#!/bin/bash
gmt begin caleta1.47_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times caleta1.47'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   321.018
    25.500   325.559
    26.000   330.088
    26.500   334.607
    27.000   339.111
    27.500   343.600
    28.000   348.067
    28.500   352.521
    29.000   356.965
    29.500   361.399
    30.000   365.826
    30.500   370.245
    31.000   374.657
    31.500   379.061
    32.000   383.456
    32.500   387.842
    33.000   392.216
    33.500   396.578
    34.000   400.926
    34.500   405.258
    35.000   409.576
    35.500   413.878
    36.000   418.165
    36.500   422.437
    37.000   426.694
    37.500   430.935
    38.000   435.159
    38.500   439.368
    39.000   443.560
    39.500   447.735
    40.000   451.893
    40.500   456.034
    41.000   460.158
    41.500   464.265
    42.000   468.355
    42.500   472.428
    43.000   476.483
    43.500   480.521
    44.000   484.541
    44.500   488.543
    45.000   492.527
    45.500   496.494
    46.000   500.442
    46.500   504.372
    47.000   508.285
    47.500   512.179
    48.000   516.055
    48.500   519.913
    49.000   523.753
    49.500   527.575
    50.000   531.378
    50.500   535.163
    51.000   538.930
    51.500   542.679
    52.000   546.409
    52.500   550.122
    53.000   553.817
    53.500   557.495
    54.000   561.154
    54.500   564.794
    55.000   568.417
    55.500   572.021
    56.000   575.606
    56.500   579.173
    57.000   582.721
    57.500   586.252
    58.000   589.765
    58.500   593.259
    59.000   596.735
    59.500   600.193
    60.000   603.633
    60.500   607.054
    61.000   610.457
    61.500   613.841
    62.000   617.208
    62.500   620.556
    63.000   623.886
    63.500   627.198
    64.000   630.493
    64.500   633.770
    65.000   637.029
    65.500   640.269
    66.000   643.492
    66.500   646.697
    67.000   649.884
    67.500   653.052
    68.000   656.203
    68.500   659.335
    69.000   662.449
    69.500   665.545
    70.000   668.623
    70.500   671.683
    71.000   674.724
    71.500   677.748
    72.000   680.753
    72.500   683.740
    73.000   686.709
    73.500   689.659
    74.000   692.591
    74.500   695.504
    75.000   698.398
    75.500   701.273
    76.000   704.131
    76.500   706.970
    77.000   709.791
    77.500   712.594
    78.000   715.379
    78.500   718.146
    79.000   720.894
    79.500   723.625
    80.000   726.336
    80.500   729.029
    81.000   731.702
    81.500   734.355
    82.000   736.990
    82.500   739.606
    83.000   742.204
    83.500   744.782
    84.000   747.341
    84.500   749.880
    85.000   752.398
    85.500   754.896
    86.000   757.376
    86.500   759.839
    87.000   762.283
    87.500   764.703
    88.000   767.089
    88.500   769.454
    89.000   771.807
    89.500   774.152
    90.000   776.489
    90.500   778.820
    91.000   781.144
    91.500   783.463
    92.000   785.777
    92.500   788.087
    93.000   790.394
    93.500   792.698
    94.000   794.998
    94.500   797.293
    95.000   799.583
    95.500   801.866
    96.000   804.144
    96.500   806.415
    97.000   808.680
    97.500   810.937
    98.000   813.188
    98.500   815.432
    99.000   817.667
    99.500   819.895
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1118.828
   116.000  1119.790
   116.500  1120.752
   117.000  1121.714
   117.500  1122.676
   118.000  1123.638
   118.500  1124.600
   119.000  1125.561
   119.500  1126.523
   120.000  1127.484
   120.500  1128.445
   121.000  1129.406
   121.500  1130.366
   122.000  1131.327
   122.500  1132.286
   123.000  1133.246
   123.500  1134.205
   124.000  1135.164
   124.500  1136.122
   125.000  1137.080
   125.500  1138.037
   126.000  1138.993
   126.500  1139.949
   127.000  1140.904
   127.500  1141.859
   128.000  1142.812
   128.500  1143.765
   129.000  1144.717
   129.500  1145.668
   130.000  1146.617
   130.500  1147.566
   131.000  1148.514
   131.500  1149.460
   132.000  1150.405
   132.500  1151.349
   133.000  1152.291
   133.500  1153.231
   134.000  1154.170
   134.500  1155.107
   135.000  1156.042
   135.500  1156.975
   136.000  1157.906
   136.500  1158.835
   137.000  1159.761
   137.500  1160.685
   138.000  1161.607
   138.500  1162.525
   139.000  1163.441
   139.500  1164.354
   140.000  1165.263
   140.500  1166.169
   141.000  1167.071
   141.500  1167.970
   142.000  1168.864
   142.500  1169.755
   143.000  1170.640
   143.500  1171.521
   144.000  1172.397
   144.500  1173.268
   145.000  1174.134
   145.500  1174.994
   146.000  1175.847
   146.500  1176.695
   147.000  1177.536
   147.500  1178.370
   148.000  1179.196
   148.500  1180.016
   149.000  1180.827
   149.500  1181.629
   150.000  1182.422
   150.500  1183.205
   151.000  1183.978
   151.500  1184.741
   152.000  1185.494
   152.500  1186.238
   153.000  1186.971
   153.500  1187.693
   154.000  1188.406
   154.500  1189.107
   155.000  1189.797
   155.500  1190.475
   156.000  1191.142
   156.500  1191.797
   157.000  1192.441
   157.500  1193.072
   158.000  1193.691
   158.500  1194.297
   159.000  1194.891
   159.500  1195.472
   160.000  1196.040
   160.500  1196.596
   161.000  1197.138
   161.500  1197.667
   162.000  1198.183
   162.500  1198.685
   163.000  1199.175
   163.500  1199.651
   164.000  1200.112
   164.500  1200.560
   165.000  1200.995
   165.500  1201.415
   166.000  1201.822
   166.500  1202.215
   167.000  1202.594
   167.500  1202.959
   168.000  1203.310
   168.500  1203.646
   169.000  1203.969
   169.500  1204.278
   170.000  1204.572
   170.500  1204.852
   171.000  1205.118
   171.500  1205.370
   172.000  1205.607
   172.500  1205.830
   173.000  1206.039
   173.500  1206.234
   174.000  1206.414
   174.500  1206.580
   175.000  1206.731
   175.500  1206.868
   176.000  1206.990
   176.500  1207.099
   177.000  1207.193
   177.500  1207.272
   178.000  1207.337
   178.500  1207.387
   179.000  1207.423
   179.500  1207.445
   180.000  1207.452
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   989.751
     1.000   989.759
     1.500   989.773
     2.000   989.793
     2.500   989.818
     3.000   989.849
     3.500   989.885
     4.000   989.927
     4.500   989.975
     5.000   990.028
     5.500   990.087
     6.000   990.151
     6.500   990.221
     7.000   990.296
     7.500   990.377
     8.000   990.464
     8.500   990.556
     9.000   990.654
     9.500   990.757
    10.000   990.866
    10.500   990.981
    11.000   991.101
    11.500   991.226
    12.000   991.357
    12.500   991.494
    13.000   991.636
    13.500   991.784
    14.000   991.937
    14.500   992.096
    15.000   992.260
    15.500   992.430
    16.000   992.606
    16.500   992.786
    17.000   992.973
    17.500   993.164
    18.000   993.362
    18.500   993.565
    19.000   993.773
    19.500   993.986
    20.000   994.205
    20.500   994.430
    21.000   994.660
    21.500   994.895
    22.000   995.136
    22.500   995.383
    23.000   995.634
    23.500   995.891
    24.000   996.154
    24.500   996.421
    25.000   996.695
    25.500   996.973
    26.000   997.257
    26.500   997.546
    27.000   997.841
    27.500   998.141
    28.000   998.446
    28.500   998.756
    29.000   999.072
    29.500   999.393
    30.000   999.719
    30.500  1000.051
    31.000  1000.388
    31.500  1000.730
    32.000  1001.077
    32.500  1001.430
    33.000  1001.787
    33.500  1002.150
    34.000  1002.518
    34.500  1002.891
    35.000  1003.270
    35.500  1003.653
    36.000  1004.042
    36.500  1004.435
    37.000  1004.834
    37.500  1005.238
    38.000  1005.647
    38.500  1006.061
    39.000  1006.480
    39.500  1006.904
    40.000  1007.333
    40.500  1007.767
    41.000  1008.206
    41.500  1008.650
    42.000  1009.099
    42.500  1009.553
    43.000  1010.012
    43.500  1010.476
    44.000  1010.944
    44.500  1011.418
    45.000  1011.896
    45.500  1012.380
    46.000  1012.868
    46.500  1013.361
    47.000  1013.858
    47.500  1014.361
    48.000  1014.868
    48.500  1015.380
    49.000  1015.897
    49.500  1016.418
    50.000  1016.945
    50.500  1017.475
    51.000  1018.011
    51.500  1018.551
    52.000  1019.096
    52.500  1019.646
    53.000  1020.200
    53.500  1020.758
    54.000  1021.321
    54.500  1021.889
    55.000  1022.461
    55.500  1023.038
    56.000  1023.619
    56.500  1024.205
    57.000  1024.795
    57.500  1025.390
    58.000  1025.989
    58.500  1026.592
    59.000  1027.200
    59.500  1027.812
    60.000  1028.429
    60.500  1029.050
    61.000  1029.675
    61.500  1030.304
    62.000  1030.938
    62.500  1031.576
    63.000  1032.218
    63.500  1032.864
    64.000  1033.515
    64.500  1034.169
    65.000  1034.828
    65.500  1035.491
    66.000  1036.158
    66.500  1036.829
    67.000  1037.505
    67.500  1038.184
    68.000  1038.867
    68.500  1039.554
    69.000  1040.246
    69.500  1040.941
    70.000  1041.640
    70.500  1042.343
    71.000  1043.050
    71.500  1043.761
    72.000  1044.476
    72.500  1045.194
    73.000  1045.916
    73.500  1046.643
    74.000  1047.372
    74.500  1048.106
    75.000  1048.843
    75.500  1049.584
    76.000  1050.329
    76.500  1051.078
    77.000  1051.830
    77.500  1052.585
    78.000  1053.344
    78.500  1054.107
    79.000  1054.873
    79.500  1055.643
    80.000  1056.417
    80.500  1057.193
    81.000  1057.974
    81.500  1058.758
    82.000  1059.545
    82.500  1060.335
    83.000  1061.129
    83.500  1061.926
    84.000  1062.727
    84.500  1063.531
    85.000  1064.338
    85.500  1065.148
    86.000  1065.962
    86.500  1066.778
    87.000  1067.599
    87.500  1068.422
    88.000  1069.248
    88.500  1070.077
    89.000  1070.910
    89.500  1071.745
    90.000  1072.584
    90.500  1073.426
    91.000  1074.270
    91.500  1075.118
    92.000  1075.968
    92.500  1076.822
    93.000  1077.678
    93.500  1078.537
    94.000  1079.399
    94.500  1080.264
    95.000  1081.132
    95.500  1082.002
    96.000  1082.876
    96.500  1083.751
    97.000  1084.630
    97.500  1085.512
    98.000  1086.396
    98.500  1087.282
    99.000  1088.172
    99.500  1089.063
   100.000  1089.958
   100.500  1090.855
   101.000  1091.754
   101.500  1092.656
   102.000  1093.561
   102.500  1094.468
   103.000  1095.377
   103.500  1096.289
   104.000  1097.203
   104.500  1098.120
   105.000  1099.038
   105.500  1099.959
   106.000  1100.883
   106.500  1101.808
   107.000  1102.736
   107.500  1103.666
   108.000  1104.599
   108.500  1105.533
   109.000  1106.470
   109.500  1107.408
   110.000  1108.349
   110.500  1109.292
   111.000  1110.237
   111.500  1111.183
   112.000  1112.132
   112.500  1113.083
   113.000  1114.036
   113.500  1114.990
   114.000  1115.947
   114.500  1116.906
   115.000  1117.866
   115.500  1118.828
   116.000  1119.792
   116.500  1120.757
   117.000  1121.725
   117.500  1122.694
   118.000  1123.665
   118.500  1124.637
   119.000  1125.611
   119.500  1126.587
   120.000  1127.565
   120.500  1128.544
   121.000  1129.524
   121.500  1130.506
   122.000  1131.490
   122.500  1132.475
   123.000  1133.461
   123.500  1134.449
   124.000  1135.439
   124.500  1136.430
   125.000  1137.422
   125.500  1138.415
   126.000  1139.410
   126.500  1140.406
   127.000  1141.403
   127.500  1142.402
   128.000  1143.402
   128.500  1144.403
   129.000  1145.405
   129.500  1146.408
   130.000  1147.413
   130.500  1148.419
   131.000  1149.425
   131.500  1150.433
   132.000  1151.442
   132.500  1152.452
   133.000  1153.463
   133.500  1154.474
   134.000  1155.487
   134.500  1156.501
   135.000  1157.515
   135.500  1158.531
   136.000  1159.547
   136.500  1160.564
   137.000  1161.582
   137.500  1162.601
   138.000  1163.620
   138.500  1164.641
   139.000  1165.662
   139.500  1166.683
   140.000  1167.706
   140.500  1168.729
   141.000  1169.752
   141.500  1170.776
   142.000  1171.801
   142.500  1172.827
   143.000  1173.853
   143.500  1174.879
   144.000  1175.906
   144.500  1176.933
   145.000  1177.961
   145.500  1178.990
   146.000  1180.019
   146.500  1181.048
   147.000  1182.077
   147.500  1183.107
   148.000  1184.137
   148.500  1185.168
   149.000  1186.198
   149.500  1187.229
   150.000  1188.261
   150.500  1189.292
   151.000  1190.324
   151.500  1191.356
   152.000  1192.388
   152.500  1193.420
   153.000  1194.453
   153.500  1195.485
   154.000  1196.517
   154.500  1197.550
   155.000  1198.583
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.494
   145.500  1175.323
   146.000  1177.207
   146.500  1179.126
   147.000  1181.073
   147.500  1183.043
   148.000  1185.033
   148.500  1187.040
   149.000  1189.062
   149.500  1191.099
   150.000  1193.148
   150.500  1195.208
   151.000  1197.279
   151.500  1199.359
   152.000  1201.448
   152.500  1203.546
   153.000  1205.651
   153.500  1207.764
   154.000  1209.884
   154.500  1212.010
   155.000  1214.143
   155.500  1216.280
   156.000  1218.424
   156.500  1220.572
   157.000  1222.724
   157.500  1224.882
   158.000  1227.043
   158.500  1229.209
   159.000  1231.379
   159.500  1233.552
   160.000  1235.728
   160.500  1237.908
   161.000  1240.091
   161.500  1242.277
   162.000  1244.465
   162.500  1246.656
   163.000  1248.849
   163.500  1251.045
   164.000  1253.243
   164.500  1255.443
   165.000  1257.644
   165.500  1259.848
   166.000  1262.053
   166.500  1264.260
   167.000  1266.468
   167.500  1268.678
   168.000  1270.889
   168.500  1273.101
   169.000  1275.315
   169.500  1277.529
   170.000  1279.745
   170.500  1281.961
   171.000  1284.179
   171.500  1286.397
   172.000  1288.616
   172.500  1290.835
   173.000  1293.055
   173.500  1295.276
   174.000  1297.497
   174.500  1299.718
   175.000  1301.940
   175.500  1304.162
   176.000  1306.384
   176.500  1308.607
   177.000  1310.829
   177.500  1313.052
   178.000  1315.275
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1173.486
   145.500  1175.104
   146.000  1176.647
   146.500  1178.134
   147.000  1179.571
   147.500  1180.963
   148.000  1182.312
   148.500  1183.622
   149.000  1184.898
   149.500  1186.145
   150.000  1187.368
   150.500  1188.567
   151.000  1189.746
   151.500  1190.906
   152.000  1192.047
   152.500  1193.171
   153.000  1194.280
   153.500  1195.373
   154.000  1196.454
   154.500  1197.521
   155.000  1198.576
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   506.626
     1.000   506.662
     1.500   506.722
     2.000   506.807
     2.500   506.915
     3.000   507.047
     3.500   507.203
     4.000   507.383
     4.500   507.587
     5.000   507.814
     5.500   508.066
     6.000   508.341
     6.500   508.640
     7.000   508.963
     7.500   509.309
     8.000   509.679
     8.500   510.072
     9.000   510.489
     9.500   510.929
    10.000   511.392
    10.500   511.878
    11.000   512.387
    11.500   512.919
    12.000   513.474
    12.500   514.052
    13.000   514.652
    13.500   515.275
    14.000   515.920
    14.500   516.588
    15.000   517.278
    15.500   517.990
    16.000   518.723
    16.500   519.479
    17.000   520.256
    17.500   521.054
    18.000   521.874
    18.500   522.715
    19.000   523.578
    19.500   524.461
    20.000   525.365
    20.500   526.289
    21.000   527.235
    21.500   528.200
    22.000   529.186
    22.500   530.191
    23.000   531.216
    23.500   532.262
    24.000   533.326
    24.500   534.410
    25.000   535.513
    25.500   536.635
    26.000   537.776
    26.500   538.935
    27.000   540.113
    27.500   541.309
    28.000   542.523
    28.500   543.756
    29.000   545.005
    29.500   546.273
    30.000   547.558
    30.500   548.860
    31.000   550.179
    31.500   551.514
    32.000   552.867
    32.500   554.236
    33.000   555.621
    33.500   557.022
    34.000   558.439
    34.500   559.872
    35.000   561.320
    35.500   562.784
    36.000   564.263
    36.500   565.756
    37.000   567.265
    37.500   568.788
    38.000   570.325
    38.500   571.877
    39.000   573.442
    39.500   575.022
    40.000   576.615
    40.500   578.221
    41.000   579.841
    41.500   581.474
    42.000   583.120
    42.500   584.778
    43.000   586.450
    43.500   588.133
    44.000   589.829
    44.500   591.536
    45.000   593.256
    45.500   594.987
    46.000   596.730
    46.500   598.484
    47.000   600.249
    47.500   602.025
    48.000   603.812
    48.500   605.609
    49.000   607.417
    49.500   609.235
    50.000   611.064
    50.500   612.902
    51.000   614.750
    51.500   616.608
    52.000   618.475
    52.500   620.351
    53.000   622.237
    53.500   624.131
    54.000   626.035
    54.500   627.947
    55.000   629.867
    55.500   631.796
    56.000   633.733
    56.500   635.679
    57.000   637.632
    57.500   639.592
    58.000   641.561
    58.500   643.537
    59.000   645.520
    59.500   647.510
    60.000   649.508
    60.500   651.512
    61.000   653.523
    61.500   655.541
    62.000   657.565
    62.500   659.596
    63.000   661.632
    63.500   663.675
    64.000   665.724
    64.500   667.779
    65.000   669.839
    65.500   671.905
    66.000   673.976
    66.500   676.053
    67.000   678.135
    67.500   680.222
    68.000   682.314
    68.500   684.411
    69.000   686.512
    69.500   688.619
    70.000   690.729
    70.500   692.844
    71.000   694.964
    71.500   697.087
    72.000   699.215
    72.500   701.346
    73.000   703.482
    73.500   705.621
    74.000   707.764
    74.500   709.910
    75.000   712.060
    75.500   714.213
    76.000   716.370
    76.500   718.529
    77.000   720.692
    77.500   722.857
    78.000   725.026
    78.500   727.197
    79.000   729.371
    79.500   731.548
    80.000   733.727
    80.500   735.909
    81.000   738.092
    81.500   740.279
    82.000   742.467
    82.500   744.657
    83.000   746.850
    83.500   749.044
    84.000   751.241
    84.500   753.439
    85.000   755.639
    85.500   757.840
    86.000   760.043
    86.500   762.248
    87.000   764.454
    87.500   766.662
    88.000   768.870
    88.500   771.080
    89.000   773.292
    89.500   775.504
    90.000   777.717
    90.500   779.932
    91.000   782.147
    91.500   784.363
    92.000   786.580
    92.500   788.798
    93.000   791.016
    93.500   793.235
    94.000   795.455
    94.500   797.675
    95.000   799.896
    95.500   802.117
    96.000   804.338
    96.500   806.560
    97.000   808.782
    97.500   811.005
    98.000   813.227
    98.500   815.450
    99.000   817.673
    99.500   819.895
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   411.546
    28.500   417.104
    29.000   422.661
    29.500   428.218
    30.000   433.774
    30.500   439.328
    31.000   444.882
    31.500   450.433
    32.000   455.982
    32.500   461.528
    33.000   467.072
    33.500   472.612
    34.000   478.149
    34.500   483.681
    35.000   489.208
    35.500   494.730
    36.000   500.247
    36.500   505.757
    37.000   511.260
    37.500   516.757
    38.000   522.245
    38.500   527.725
    39.000   533.196
    39.500   538.657
    40.000   544.108
    40.500   549.549
    41.000   554.978
    41.500   560.395
    42.000   565.800
    42.500   571.192
    43.000   576.570
    43.500   581.935
    44.000   587.285
    44.500   592.620
    45.000   597.939
    45.500   603.243
    46.000   608.531
    46.500   613.801
    47.000   619.055
    47.500   623.644
    48.000   628.214
    48.500   632.779
    49.000   637.339
    49.500   641.895
    50.000   646.445
    50.500   650.990
    51.000   655.530
    51.500   660.065
    52.000   664.593
    52.500   669.117
    53.000   673.634
    53.500   678.145
    54.000   682.648
    54.500   687.144
    55.000   691.630
    55.500   696.106
    56.000   700.572
    56.500   705.030
    57.000   709.483
    57.500   713.930
    58.000   718.372
    58.500   722.810
    59.000   727.244
    59.500   731.674
    60.000   736.100
    60.500   740.523
    61.000   744.941
    61.500   749.356
    62.000   753.767
    62.500   758.174
    63.000   762.577
    63.500   766.975
    64.000   771.370
    64.500   775.760
    65.000   780.144
    65.500   784.524
    66.000   788.897
    66.500   793.264
    67.000   797.625
    67.500   801.978
    68.000   806.324
    68.500   810.663
    69.000   814.994
    69.500   819.317
    70.000   823.633
    70.500   827.941
    71.000   832.242
    71.500   836.535
    72.000   840.821
    72.500   845.099
    73.000   849.370
    73.500   853.632
    74.000   857.887
    74.500   862.134
    75.000   866.373
    75.500   870.604
    76.000   874.828
    76.500   879.043
    77.000   883.250
    77.500   887.448
    78.000   891.638
    78.500   895.820
    79.000   899.993
    79.500   904.158
    80.000   908.314
    80.500   912.462
    81.000   916.601
    81.500   920.732
    82.000   924.854
    82.500   928.967
    83.000   933.073
    83.500   937.169
    84.000   941.257
    84.500   945.336
    85.000   949.407
    85.500   953.469
    86.000   957.522
    86.500   961.567
    87.000   965.602
    87.500   969.629
    88.000   973.647
    88.500   977.656
    89.000   981.656
    89.500   985.647
    90.000   989.630
    90.500   993.603
    91.000   997.567
    91.500  1001.522
    92.000  1005.469
    92.500  1009.406
    93.000  1013.334
    93.500  1017.253
    94.000  1021.164
    94.500  1025.065
    95.000  1028.957
    95.500  1032.840
    96.000  1036.714
    96.500  1040.579
    97.000  1044.435
    97.500  1048.281
    98.000  1052.119
    98.500  1055.948
    99.000  1059.767
    99.500  1063.577
   100.000  1067.378
   100.500  1071.170
   101.000  1074.953
   101.500  1078.727
   102.000  1082.491
   102.500  1086.247
   103.000  1089.993
   103.500  1093.730
   104.000  1097.459
   104.500  1101.178
   105.000  1104.889
   105.500  1108.591
   106.000  1112.283
   106.500  1115.967
   107.000  1119.642
   107.500  1123.308
   108.000  1126.965
   108.500  1130.612
   109.000  1134.251
   109.500  1137.880
   110.000  1141.500
   110.500  1145.110
   111.000  1148.712
   111.500  1152.304
   112.000  1155.886
   112.500  1159.460
   113.000  1163.025
   113.500  1166.580
   114.000  1170.126
   114.500  1173.663
   115.000  1177.192
   115.500  1180.711
   116.000  1184.221
   116.500  1187.722
   117.000  1191.214
   117.500  1194.697
   118.000  1198.170
   118.500  1201.635
   119.000  1205.090
   119.500  1208.536
   120.000  1211.974
   120.500  1215.401
   121.000  1218.820
   121.500  1222.229
   122.000  1225.630
   122.500  1229.021
   123.000  1232.402
   123.500  1235.775
   124.000  1239.139
   124.500  1242.494
   125.000  1245.839
   125.500  1249.176
   126.000  1252.504
   126.500  1255.823
   127.000  1259.132
   127.500  1262.433
   128.000  1265.725
   128.500  1269.008
   129.000  1272.283
   129.500  1275.548
   130.000  1278.804
   130.500  1282.051
   131.000  1285.289
   131.500  1288.519
   132.000  1291.739
   132.500  1294.950
   133.000  1298.152
   133.500  1301.345
   134.000  1304.529
   134.500  1307.704
   135.000  1310.870
   135.500  1314.027
   136.000  1317.174
   136.500  1320.313
   137.000  1323.443
   137.500  1326.563
   138.000  1329.675
   138.500  1332.777
   139.000  1335.870
   139.500  1338.954
   140.000  1342.029
   140.500  1345.095
   141.000  1348.152
   141.500  1351.200
   142.000  1354.239
   142.500  1357.269
   143.000  1360.290
   143.500  1363.301
   144.000  1366.304
   144.500  1369.297
   145.000  1372.282
   145.500  1375.257
   146.000  1378.223
   146.500  1381.179
   147.000  1384.127
   147.500  1387.065
   148.000  1389.993
   148.500  1392.912
   149.000  1395.822
   149.500  1398.723
   150.000  1401.614
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   822.118
   100.500   824.341
   101.000   826.564
   101.500   828.787
   102.000   831.010
   102.500   833.232
   103.000   835.455
   103.500   837.678
   104.000   839.901
   104.500   842.124
   105.000   844.347
   105.500   846.570
   106.000   848.792
   106.500   851.015
   107.000   853.238
   107.500   855.461
   108.000   857.684
   108.500   859.906
   109.000   862.129
   109.500   864.352
   110.000   866.575
   110.500   868.798
   111.000   871.021
   111.500   873.244
   112.000   875.466
   112.500   877.689
   113.000   879.912
   113.500   882.135
   114.000   884.358
   114.500   886.581
   115.000   888.803
   115.500   891.026
   116.000   893.249
   116.500   895.472
   117.000   897.695
   117.500   899.918
   118.000   902.140
   118.500   904.363
   119.000   906.586
   119.500   908.809
   120.000   911.032
   120.500   913.255
   121.000   915.477
   121.500   917.700
   122.000   919.923
   122.500   922.146
   123.000   924.369
   123.500   926.592
   124.000   928.814
   124.500   931.037
   125.000   933.260
   125.500   935.483
   126.000   937.706
   126.500   939.929
   127.000   942.151
   127.500   944.374
   128.000   946.597
   128.500   948.820
   129.000   951.043
   129.500   953.266
   130.000   955.488
   130.500   957.711
   131.000   959.934
   131.500   962.157
   132.000   964.380
   132.500   966.603
   133.000   968.825
   133.500   971.048
   134.000   973.271
   134.500   975.494
   135.000   977.717
   135.500   979.940
   136.000   982.162
   136.500   984.385
   137.000   986.608
   137.500   988.831
   138.000   991.054
   138.500   993.277
   139.000   995.499
   139.500   997.722
   140.000   999.945
   140.500  1002.168
   141.000  1004.391
   141.500  1006.614
   142.000  1008.836
   142.500  1011.059
   143.000  1013.282
   143.500  1015.505
   144.000  1017.728
   144.500  1019.951
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   381.575
    15.000   391.813
    15.500   402.046
    16.000   412.271
    16.500   422.484
    17.000   432.682
    17.500   442.860
    18.000   453.013
    18.500   463.137
    19.000   472.994
    19.500   483.272
    20.000   493.271
    20.500   503.217
    21.000   513.104
    21.500   522.927
    22.000   532.681
    22.500   542.361
    23.000   550.643
    23.500   558.778
    24.000   566.880
    24.500   574.948
    25.000   582.968
    25.500   590.905
    26.000   598.813
    26.500   606.712
    27.000   614.601
    27.500   622.484
    28.000   630.359
    28.500   638.228
    29.000   646.091
    29.500   653.946
    30.000   661.795
    30.500   669.634
    31.000   677.464
    31.500   685.282
    32.000   693.087
    32.500   700.878
    33.000   708.653
    33.500   716.411
    34.000   724.151
    34.500   731.872
    35.000   739.575
    35.500   747.257
    36.000   754.920
    36.500   762.563
    37.000   770.186
    37.500   777.788
    38.000   785.368
    38.500   792.927
    39.000   800.464
    39.500   807.978
    40.000   815.470
    40.500   822.938
    41.000   830.383
    41.500   837.804
    42.000   845.201
    42.500   852.574
    43.000   859.923
    43.500   867.247
    44.000   874.546
    44.500   881.820
    45.000   889.070
    45.500   896.293
    46.000   903.492
    46.500   910.664
    47.000   917.810
    47.500   924.930
    48.000   932.024
    48.500   939.090
    49.000   946.129
    49.500   953.142
    50.000   960.127
    50.500   967.085
    51.000   974.017
    51.500   980.920
    52.000   987.796
    52.500   994.644
    53.000  1001.466
    53.500  1008.261
    54.000  1015.031
    54.500  1021.774
    55.000  1028.491
    55.500  1035.181
    56.000  1041.842
    56.500  1048.477
    57.000  1055.083
    57.500  1061.661
    58.000  1068.211
    58.500  1074.733
    59.000  1081.228
    59.500  1087.695
    60.000  1094.134
    60.500  1100.546
    61.000  1106.930
    61.500  1113.285
    62.000  1119.613
    62.500  1125.912
    63.000  1132.182
    63.500  1138.425
    64.000  1144.638
    64.500  1150.824
    65.000  1156.981
    65.500  1163.110
    66.000  1169.211
    66.500  1175.283
    67.000  1181.328
    67.500  1187.344
    68.000  1193.331
    68.500  1199.289
    69.000  1205.219
    69.500  1211.120
    70.000  1216.993
    70.500  1222.837
    71.000  1228.652
    71.500  1234.438
    72.000  1240.196
    72.500  1245.923
    73.000  1251.621
    73.500  1257.289
    74.000  1262.927
    74.500  1268.535
    75.000  1274.113
    75.500  1279.662
    76.000  1285.182
    76.500  1290.672
    77.000  1296.133
    77.500  1301.563
    78.000  1306.964
    78.500  1312.333
    79.000  1317.673
    79.500  1322.984
    80.000  1328.266
    80.500  1333.518
    81.000  1338.740
    81.500  1343.930
    82.000  1349.089
    82.500  1354.215
    83.000  1359.310
    83.500  1364.374
    84.000  1369.407
    84.500  1374.408
    85.000  1379.379
    85.500  1384.318
    86.000  1389.225
    86.500  1394.101
    87.000  1398.944
    87.500  1403.755
    88.000  1408.532
    88.500  1413.277
    89.000  1417.988
    89.500  1422.666
    90.000  1427.310
    90.500  1431.920
    91.000  1436.497
    91.500  1441.040
    92.000  1445.549
    92.500  1450.025
    93.000  1454.466
    93.500  1458.873
    94.000  1463.256
    94.500  1467.622
    95.000  1471.976
    95.500  1476.318
    96.000  1480.649
    96.500  1484.966
    97.000  1489.266
    97.500  1493.546
    98.000  1497.805
    98.500  1502.045
    99.000  1506.266
    99.500  1510.467
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   715.226
     1.000   715.273
     1.500   715.350
     2.000   715.459
     2.500   715.600
     3.000   715.771
     3.500   715.973
     4.000   716.206
     4.500   716.470
     5.000   716.765
     5.500   717.091
     6.000   717.448
     6.500   717.835
     7.000   718.252
     7.500   718.700
     8.000   719.179
     8.500   719.687
     9.000   720.226
     9.500   720.794
    10.000   721.393
    10.500   722.021
    11.000   722.678
    11.500   723.365
    12.000   724.081
    12.500   724.826
    13.000   725.600
    13.500   726.403
    14.000   727.234
    14.500   728.093
    15.000   728.981
    15.500   729.896
    16.000   730.839
    16.500   731.809
    17.000   732.807
    17.500   733.831
    18.000   734.883
    18.500   735.961
    19.000   737.065
    19.500   738.195
    20.000   739.351
    20.500   740.532
    21.000   741.739
    21.500   742.971
    22.000   744.227
    22.500   745.508
    23.000   746.813
    23.500   748.142
    24.000   749.494
    24.500   750.870
    25.000   752.269
    25.500   753.690
    26.000   755.134
    26.500   756.600
    27.000   758.088
    27.500   759.598
    28.000   761.128
    28.500   762.680
    29.000   764.252
    29.500   765.844
    30.000   767.456
    30.500   769.088
    31.000   770.739
    31.500   772.410
    32.000   774.098
    32.500   775.806
    33.000   777.531
    33.500   779.273
    34.000   781.034
    34.500   782.811
    35.000   784.604
    35.500   786.415
    36.000   788.241
    36.500   790.083
    37.000   791.940
    37.500   793.812
    38.000   795.699
    38.500   797.600
    39.000   799.515
    39.500   801.444
    40.000   803.386
    40.500   805.341
    41.000   807.308
    41.500   809.289
    42.000   811.281
    42.500   813.284
    43.000   815.299
    43.500   817.325
    44.000   819.362
    44.500   821.409
    45.000   823.465
    45.500   825.532
    46.000   827.608
    46.500   829.693
    47.000   831.786
    47.500   833.888
    48.000   835.999
    48.500   838.116
    49.000   840.242
    49.500   842.374
    50.000   844.513
    50.500   846.659
    51.000   848.811
    51.500   850.969
    52.000   853.133
    52.500   855.302
    53.000   857.476
    53.500   859.654
    54.000   861.838
    54.500   864.025
    55.000   866.217
    55.500   868.412
    56.000   870.611
    56.500   872.812
    57.000   875.017
    57.500   877.225
    58.000   879.435
    58.500   881.647
    59.000   883.861
    59.500   886.077
    60.000   888.294
    60.500   890.513
    61.000   892.733
    61.500   894.954
    62.000   897.176
    62.500   899.398
    63.000   901.621
    63.500   903.844
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   927.280
     1.000   927.346
     1.500   927.457
     2.000   927.612
     2.500   927.812
     3.000   928.055
     3.500   928.343
     4.000   928.675
     4.500   929.051
     5.000   929.471
     5.500   929.935
     6.000   930.443
     6.500   930.995
     7.000   931.590
     7.500   932.228
     8.000   932.910
     8.500   933.636
     9.000   934.404
     9.500   935.216
    10.000   936.070
    10.500   936.967
    11.000   937.906
    11.500   938.888
    12.000   939.912
    12.500   940.978
    13.000   942.086
    13.500   943.235
    14.000   944.426
    14.500   945.658
    15.000   946.930
    15.500   948.244
    16.000   949.598
    16.500   950.992
    17.000   952.426
    17.500   953.900
    18.000   955.414
    18.500   956.966
    19.000   958.558
    19.500   960.188
    20.000   961.857
    20.500   963.564
    21.000   965.309
    21.500   967.092
    22.000   968.912
    22.500   970.768
    23.000   972.662
    23.500   974.592
    24.000   976.558
    24.500   978.560
    25.000   980.597
    25.500   982.670
    26.000   984.777
    26.500   986.919
    27.000   989.096
    27.500   991.306
    28.000   993.549
    28.500   995.826
    29.000   998.136
    29.500  1000.479
    30.000  1002.854
    30.500  1005.260
    31.000  1007.699
    31.500  1010.168
    32.000  1012.669
    32.500  1015.200
    33.000  1017.761
    33.500  1020.352
    34.000  1022.974
    34.500  1025.624
    35.000  1028.303
    35.500  1031.010
    36.000  1033.746
    36.500  1036.510
    37.000  1039.301
    37.500  1042.120
    38.000  1044.965
    38.500  1047.837
    39.000  1050.735
    39.500  1053.659
    40.000  1056.609
    40.500  1059.584
    41.000  1062.584
    41.500  1065.608
    42.000  1068.656
    42.500  1071.729
    43.000  1074.825
    43.500  1077.944
    44.000  1081.086
    44.500  1084.250
    45.000  1087.438
    45.500  1090.646
    46.000  1093.877
    46.500  1097.129
    47.000  1100.402
    47.500  1103.695
    48.000  1107.009
    48.500  1110.343
    49.000  1113.697
    49.500  1117.070
    50.000  1120.463
    50.500  1123.874
    51.000  1127.304
    51.500  1130.752
    52.000  1134.218
    52.500  1137.702
    53.000  1141.203
    53.500  1144.721
    54.000  1148.257
    54.500  1151.808
    55.000  1155.376
    55.500  1158.960
    56.000  1162.560
    56.500  1166.175
    57.000  1169.805
    57.500  1173.450
    58.000  1177.110
    58.500  1180.784
    59.000  1184.472
    59.500  1188.174
    60.000  1191.890
    60.500  1195.619
    61.000  1199.361
    61.500  1203.116
    62.000  1206.883
    62.500  1210.663
    63.000  1214.455
    63.500  1218.259
    64.000  1222.074
    64.500  1225.901
    65.000  1229.739
    65.500  1233.587
    66.000  1237.447
    66.500  1241.317
    67.000  1245.197
    67.500  1249.087
    68.000  1252.987
    68.500  1256.897
    69.000  1260.816
    69.500  1264.744
    70.000  1268.682
    70.500  1272.627
    71.000  1276.582
    71.500  1280.545
    72.000  1284.515
    72.500  1288.494
    73.000  1292.481
    73.500  1296.475
    74.000  1300.476
    74.500  1304.485
    75.000  1308.501
    75.500  1312.523
    76.000  1316.552
    76.500  1320.588
    77.000  1324.630
    77.500  1328.677
    78.000  1332.731
    78.500  1336.791
    79.000  1340.856
    79.500  1344.926
    80.000  1349.002
    80.500  1353.083
    81.000  1357.168
    81.500  1361.259
    82.000  1365.354
    82.500  1369.453
    83.000  1373.557
    83.500  1377.664
    84.000  1381.776
    84.500  1385.892
    85.000  1390.011
    85.500  1394.134
    86.000  1398.260
    86.500  1402.389
    87.000  1406.522
    87.500  1410.657
    88.000  1414.796
    88.500  1418.937
    89.000  1423.080
    89.500  1427.226
    90.000  1431.375
    90.500  1435.525
    91.000  1439.678
    91.500  1443.833
    92.000  1447.989
    92.500  1452.147
    93.000  1456.307
    93.500  1460.468
    94.000  1464.630
    94.500  1468.794
    95.000  1472.959
    95.500  1477.125
    96.000  1481.292
    96.500  1485.459
    97.000  1489.628
    97.500  1493.796
    98.000  1497.966
    98.500  1502.135
    99.000  1506.306
    99.500  1510.476
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   759.290
    29.000   769.530
    29.500   779.769
    30.000   790.006
    30.500   800.242
    31.000   810.475
    31.500   820.704
    32.000   830.929
    32.500   841.149
    33.000   851.362
    33.500   861.568
    34.000   871.766
    34.500   881.955
    35.000   892.133
    35.500   902.299
    36.000   912.452
    36.500   922.592
    37.000   932.715
    37.500   942.821
    38.000   952.909
    38.500   962.977
    39.000   973.024
    39.500   983.047
    40.000   993.046
    40.500  1003.019
    41.000  1012.964
    41.500  1022.880
    42.000  1032.766
    42.500  1042.621
    43.000  1052.442
    43.500  1062.230
    44.000  1071.982
    44.500  1081.697
    45.000  1091.375
    45.500  1100.361
    46.000  1108.527
    46.500  1116.676
    47.000  1124.808
    47.500  1132.924
    48.000  1141.024
    48.500  1149.107
    49.000  1157.172
    49.500  1165.216
    50.000  1173.232
    50.500  1181.205
    51.000  1189.130
    51.500  1197.044
    52.000  1204.952
    52.500  1212.854
    53.000  1220.751
    53.500  1228.644
    54.000  1236.533
    54.500  1244.418
    55.000  1252.300
    55.500  1260.178
    56.000  1268.053
    56.500  1275.925
    57.000  1283.794
    57.500  1291.659
    58.000  1299.521
    58.500  1307.379
    59.000  1315.234
    59.500  1323.086
    60.000  1330.933
    60.500  1338.777
    61.000  1346.616
    61.500  1354.450
    62.000  1362.279
    62.500  1370.102
    63.000  1377.919
    63.500  1385.730
    64.000  1393.534
    64.500  1401.331
    65.000  1409.120
    65.500  1416.902
    66.000  1424.675
    66.500  1432.440
    67.000  1440.196
    67.500  1447.944
    68.000  1455.682
    68.500  1463.411
    69.000  1471.131
    69.500  1478.841
    70.000  1486.542
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     4.208    66.848     0.150
     5.117    93.848     0.150
     6.738   103.848     0.150
     6.738   213.848     0.150
     7.068   157.848     0.150
     7.068   189.848     0.150
    10.065   213.848     0.150
    13.327   378.848     0.150
    14.725   212.848     0.150
    14.725   457.848     0.150
    19.132   253.848     0.150
    19.132   455.848     0.150
    19.132   603.848     0.150
    19.433   267.848     0.150
    19.795   289.848     0.150
    19.795   622.848     0.150
    21.665   300.848     0.150
    22.518   291.848     0.150
    22.518   722.848     0.150
    22.766   596.848     0.150
    23.017   544.848     0.150
    23.021    19.000     0.150
    23.021   719.848     0.150
    22.922   303.848     0.150
    23.238    19.000     0.150
    23.238   441.848     0.150
    24.321   336.848     0.150
    25.130   297.848     0.150
    25.215    23.000     0.150
    25.760   349.848     0.150
    26.060   563.848     0.150
    26.489   356.848     0.150
    26.751   352.848     0.150
    26.459   354.848     0.150
    30.683   367.848     0.150
    30.561   376.848     0.150
    31.656   621.848     0.150
    32.081   391.848     0.150
    35.483   583.848     0.150
    37.408   406.848     0.150
    40.773   481.848     0.150
    41.518   601.848     0.150
    42.078   483.848     0.150
    53.213   559.848     0.150
    54.594   664.848     0.150
    65.721   657.848     0.150
    86.037   753.848     0.150
    86.487   770.848     0.150
    86.971   757.848     0.150
    87.456   758.848     0.150
    87.456  1159.848     0.150
    90.157   897.848     0.150
   130.438  1135.848     0.150
     4.180    75.594     0.150
    14.387   427.594     0.150
    18.709   251.793     0.150
    19.429   357.594     0.150
    19.429   627.594     0.150
    19.817   270.895     0.150
    21.274   529.594     0.150
    21.687   289.594     0.150
    22.454     9.000     0.150
    22.454    34.000     0.150
    22.454   338.594     0.150
    23.334    27.000     0.150
    23.334   955.594     0.150
    25.346    45.000     0.150
    25.386   319.895     0.150
    25.378   797.594     0.150
    25.391   323.594     0.150
    25.391    15.000     0.150
    25.391    28.000     0.150
    25.391   487.594     0.150
    28.532   348.594     0.150
    28.532   927.594     0.150
    29.342   355.793     0.150
    35.416   412.195     0.150
    35.438   398.594     0.150
    37.434   427.594     0.150
    41.382   449.594     0.150
    52.859  1145.594     0.150
    69.959   674.594     0.150
    83.705  4609.594     0.150
    84.859   749.395     0.150
    84.859  1373.594     0.150
    85.369  1397.594     0.150
    85.426  1987.594     0.150
    86.631   753.594     0.150
    88.638   772.594     0.150
    88.629  1493.594     0.150
    88.629  1797.594     0.150
    88.629  1951.594     0.150
    88.655   766.793     0.150
    90.988   979.594     0.150
    90.988  1779.594     0.150
    90.988  2013.594     0.150
     3.776   108.547     0.150
     3.776   867.547     0.150
    15.235   212.547     0.150
    15.591   230.547     0.150
    16.837   246.547     0.150
    19.344   255.344     0.150
    19.344   328.547     0.150
    20.463   280.047     0.150
    20.774   511.547     0.150
    23.127   498.547     0.150
    23.275   682.547     0.150
    23.626    18.500     0.150
    23.892   363.547     0.150
    23.892   548.547     0.150
    25.023   335.547     0.150
    25.732   347.047     0.150
    27.174    38.000     0.150
    33.658   738.547     0.150
    48.792   519.547     0.150
    74.959   714.547     0.150
    85.202   766.547     0.150
    86.930   757.547     0.150
   126.802  1071.047     0.150
     1.971    28.152     0.150
     2.783    41.152     0.150
     3.250    52.152     0.150
     3.250    53.754     0.150
     3.524    96.152     0.150
     5.633    86.152     0.150
     5.642    91.152     0.150
     6.302    95.152     0.150
     6.302   173.152     0.150
     6.243   101.152     0.150
     6.243   175.152     0.150
    11.089   166.152     0.150
    11.089   311.152     0.150
    16.079   238.152     0.150
    20.961   282.453     0.150
    20.961   540.152     0.150
    21.296    16.000     0.150
    23.155   531.152     0.150
    23.614   302.152     0.150
    23.845   315.152     0.150
    25.027   949.152     0.150
    25.303    13.699     0.150
    25.543    14.000     0.150
    26.253   334.551     0.150
    26.253   541.152     0.150
    26.253   607.152     0.150
    27.331    18.102     0.150
    29.499   437.152     0.150
    29.575   671.152     0.150
    30.512   418.152     0.150
    30.512   548.152     0.150
    32.457   471.152     0.150
    33.655     3.000     0.150
    33.655  1041.152     0.150
    47.818  1171.152     0.150
    75.215   701.152     0.150
    75.215  2089.152     0.150
    80.628  4051.152     0.150
    85.009   752.051     0.150
    85.009  1380.152     0.150
    85.626   794.152     0.150
    86.261    19.801     0.150
    86.937   765.953     0.150
    86.937  1758.152     0.150
    87.143   814.152     0.150
    88.685   769.051     0.150
    94.435   807.152     0.150
    94.435  1440.152     0.150
    96.495   812.152     0.150
   132.978  1139.152     0.150
   133.956  1139.152     0.150
   139.383  1156.152     0.150
     1.693    52.297     0.150
     2.453    34.297     0.150
     2.453    53.297     0.150
     3.543   101.297     0.150
     3.543   616.297     0.150
     5.836   168.297     0.150
    15.265   213.297     0.150
    15.265   216.297     0.150
    15.265   505.297     0.150
    15.743   238.297     0.150
    15.743   443.297     0.150
    16.926   255.297     0.150
    16.926   554.297     0.150
    23.819   309.598     0.150
    24.787    20.602     0.150
    24.971   341.297     0.150
    25.924   319.797     0.150
    28.229    28.000     0.150
    29.011   372.297     0.150
    29.164   358.195     0.150
    36.386   415.297     0.150
    40.667   453.297     0.150
    46.239   517.297     0.150
    48.131    11.199     0.150
    48.573    11.000     0.150
    66.150   643.297     0.150
    84.151   748.996     0.150
     0.898     8.789     0.150
     0.898    16.789     0.150
     1.670    24.289     0.150
     2.242    27.789     0.150
     4.307   120.789     0.150
     4.307   118.789     0.150
     6.697    99.789     0.150
     6.697   186.789     0.150
     8.100   215.789     0.150
     9.636   262.789     0.150
    10.390   144.789     0.150
    15.159   205.789     0.150
    15.236   232.789     0.150
    16.623   250.789     0.150
    23.338   566.789     0.150
    24.148   349.789     0.150
    24.148   381.789     0.150
    24.358   792.789     0.150
    25.243    33.000     0.150
    25.284   607.789     0.150
    25.284   612.789     0.150
    25.284   698.789     0.150
    25.284   766.789     0.150
    25.467   324.090     0.150
    29.406   363.789     0.150
    30.821  1035.789     0.150
    31.381   373.789     0.150
    31.952   384.488     0.150
    35.523   413.789     0.150
    37.547   427.789     0.150
    46.945  1148.789     0.150
    49.305   943.789     0.150
    52.970  1242.789     0.150
    74.454   706.789     0.150
    74.454  1772.789     0.150
    77.746  1000.789     0.150
    77.746  1640.789     0.150
    77.746  1860.789     0.150
    80.001   728.789     0.150
    80.001  1332.789     0.150
    80.803  1685.789     0.150
    81.764  1037.789     0.150
    81.764  1418.789     0.150
    81.764  1866.789     0.150
    81.898   736.789     0.150
    81.898  1350.789     0.150
    81.898   736.789     0.150
    81.898  1350.789     0.150
    82.473  1704.789     0.150
    85.232  1399.789     0.150
    85.434  1170.789     0.150
    85.434  1738.789     0.150
    85.434  1996.789     0.150
    86.207  2020.789     0.150
    86.734   762.789     0.150
    86.734  1415.789     0.150
    87.133   762.789     0.150
    87.171   766.188     0.150
    87.171  1360.789     0.150
    87.171  1418.789     0.150
    87.171  2177.789     0.150
    87.171  2231.789     0.150
    88.687   797.590     0.150
    88.687   767.789     0.150
    88.687  1407.789     0.150
    91.278  1518.789     0.150
    91.278   781.789     0.150
    91.278  1416.789     0.150
    91.278  1518.789     0.150
    91.278  1818.789     0.150
    91.799   785.789     0.150
    91.799   785.789     0.150
    92.171  1480.789     0.150
    92.815   787.789     0.150
    98.972  1081.789     0.150
   104.784  1091.289     0.150
   104.828  1090.789     0.150
   116.348  1856.789     0.150
   116.478  1124.590     0.150
   131.712  1173.789     0.150
   133.987  1142.789     0.150
   133.987  1303.789     0.150
   135.515  1143.789     0.150
   144.299  1365.789     0.150
     1.291    30.389     0.150
     1.291    46.389     0.150
     1.421    29.889     0.150
     4.039    63.389     0.150
     5.882    84.389     0.150
     5.882    95.389     0.150
     9.221   144.889     0.150
    10.764   153.389     0.150
    10.820   101.389     0.150
    17.030   256.389     0.150
    17.276   548.389     0.150
    20.204   295.389     0.150
    20.815   678.389     0.150
    20.835   519.389     0.150
    20.835   727.389     0.150
    21.924   288.988     0.150
    23.432   312.389     0.150
    24.015     9.100     0.150
    24.361   321.389     0.150
    24.709   609.389     0.150
    24.866   364.389     0.150
    25.797   332.088     0.150
    25.797   603.389     0.150
    29.327    36.000     0.150
    29.327   686.389     0.150
    31.320   385.389     0.150
    31.497   460.389     0.150
    33.963   386.389     0.150
    40.676   503.389     0.150
    48.340   967.389     0.150
    52.453  1020.389     0.150
    54.721   579.389     0.150
    55.376   582.389     0.150
    55.376  1097.389     0.150
    59.493   598.389     0.150
    59.681     0.500     0.150
    59.941     0.500     0.150
    65.792   641.988     0.150
    68.030  1475.389     0.150
    74.690  1580.389     0.150
    81.701    28.500     0.150
    81.701    38.500     0.150
    81.701   922.389     0.150
    81.701  1032.389     0.150
    81.701  1332.389     0.150
    81.701  1381.389     0.150
    81.701  1871.389     0.150
    85.088   753.789     0.150
    85.088   753.789     0.150
    85.211   759.389     0.150
    85.377   764.389     0.150
    85.672   760.389     0.150
    85.672  1506.389     0.150
    86.694   768.389     0.150
    87.026   770.389     0.150
    87.204   766.389     0.150
    87.210   771.389     0.150
    88.572   777.389     0.150
    88.840   772.488     0.150
    88.840   780.189     0.150
    88.840   770.488     0.150
    88.840  1405.389     0.150
    89.808   782.389     0.150
    90.942   791.389     0.150
    91.354   783.789     0.150
    92.187  1407.389     0.150
    92.315   785.389     0.150
    95.296   810.389     0.150
    95.709    20.000     0.150
    96.165   809.389     0.150
   102.518  1485.389     0.150
   131.079  1367.389     0.150
   147.929  1184.789     0.150
     5.920    92.719     0.150
     9.275   254.719     0.150
    17.321   562.719     0.150
    18.767   575.719     0.150
    18.767   668.719     0.150
    20.861   292.719     0.150
    21.903   287.719     0.150
    23.681   319.422     0.150
    23.843   309.617     0.150
    23.712   314.516     0.150
    23.712   331.719     0.150
    24.060    53.000     0.150
    24.897   341.719     0.150
    25.114   339.719     0.150
    25.824   343.719     0.150
    25.824   383.719     0.150
    27.298   346.922     0.150
    27.878   354.719     0.150
    29.222   359.617     0.150
    31.501   382.219     0.150
    31.524   663.719     0.150
    85.763   762.719     0.150
    87.312   770.320     0.150
    88.413   713.117     0.150
    88.413   720.719     0.150
    88.413   759.719     0.150
    88.425   757.719     0.150
    88.664   768.922     0.150
     4.004    60.555     0.150
     7.807   195.555     0.150
    12.376   324.555     0.150
    16.903   247.352     0.150
    16.903   449.555     0.150
    22.438   294.055     0.150
    23.187   302.555     0.150
    23.641   323.555     0.150
    24.511   332.555     0.150
    25.159   325.555     0.150
    31.056   405.555     0.150
    31.709   386.555     0.150
    35.300   410.555     0.150
    35.243   422.555     0.150
    36.045   429.055     0.150
    40.999   594.555     0.150
    40.999   846.555     0.150
    40.999  1220.555     0.150
    48.653   511.156     0.150
    49.095   514.555     0.150
    51.054   545.555     0.150
    52.795   566.055     0.150
    54.998   580.555     0.150
    59.161   598.555     0.150
    84.750   752.656     0.150
    84.756   752.258     0.150
    84.813   765.055     0.150
    86.548   772.555     0.150
    86.548   901.555     0.150
    88.535   762.352     0.150
    89.400   773.555     0.150
    89.479   764.555     0.150
    90.874   781.352     0.150
    90.874   799.555     0.150
    96.078   795.953     0.150
    99.291   831.555     0.150
   126.660  1271.555     0.150
   133.682  1141.555     0.150
     2.448    44.141     0.150
    17.024   237.141     0.150
    19.486   261.141     0.150
    19.546   559.641     0.150
    21.784   289.742     0.150
    23.339   317.344     0.150
    24.250   314.539     0.150
    25.208   334.641     0.150
    25.208    52.000     0.150
    25.208   619.641     0.150
    28.497    11.203     0.150
    29.710   677.141     0.150
    30.032   379.141     0.150
    31.557   712.141     0.150
    35.950     4.000     0.150
    36.250   421.141     0.150
    37.489   420.141     0.150
    37.708   434.641     0.150
    38.524   442.141     0.150
    38.524   466.141     0.150
    39.199   442.539     0.150
    39.743    18.000     0.150
    40.778   459.141     0.150
    41.135   570.141     0.150
    45.550   501.141     0.150
    46.526    23.898     0.150
    46.526   607.242     0.150
    48.438    23.000     0.150
    48.438   958.141     0.150
    51.548   549.141     0.150
    51.415   549.141     0.150
    51.415   549.141     0.150
    51.470   554.141     0.150
    55.008   574.141     0.150
    57.360  1309.141     0.150
    57.360  1429.141     0.150
    57.360  1453.141     0.150
    57.672   593.141     0.150
    57.805   597.141     0.150
    57.945   596.141     0.150
    60.523   607.141     0.150
    60.523   641.141     0.150
    61.725  1161.141     0.150
    61.725  1531.141     0.150
    64.063   635.938     0.150
    67.801   655.641     0.150
    68.139   654.141     0.150
    70.046   841.141     0.150
    70.046   944.141     0.150
    70.046  1541.141     0.150
    71.125  1250.141     0.150
    71.305   685.141     0.150
    71.707   693.141     0.150
    74.722   705.141     0.150
    74.722  1577.141     0.150
    74.722  1779.141     0.150
    77.685  1315.141     0.150
    77.685  1639.141     0.150
    77.685  1889.141     0.150
    80.478   725.141     0.150
    80.405   729.141     0.150
    80.776   733.141     0.150
    80.863   731.141     0.150
    81.837  1379.141     0.150
    81.837  1732.141     0.150
    81.922    20.602     0.150
    81.922   930.344     0.150
    81.922  1040.641     0.150
    81.922  1414.039     0.150
    82.160   793.141     0.150
    82.160   828.141     0.150
    82.160   872.141     0.150
    82.160   948.141     0.150
    82.160   982.141     0.150
    82.160  1012.141     0.150
    82.160  1166.141     0.150
    82.160  1279.141     0.150
    82.160  1327.141     0.150
    82.160  1429.141     0.150
    82.160  1498.141     0.150
    82.160  1515.141     0.150
    82.160  1543.141     0.150
    82.160  1587.141     0.150
    82.160  1701.141     0.150
    82.160  1873.141     0.150
    82.160  1933.141     0.150
    82.121   738.641     0.150
    82.640   741.141     0.150
    83.142   775.141     0.150
    83.704   745.141     0.150
    84.834   757.141     0.150
    84.834   797.641     0.150
    84.834   843.141     0.150
    84.895   756.641     0.150
    84.970   760.641     0.150
    84.970   752.938     0.150
    85.124   751.141     0.150
    85.318   966.141     0.150
    85.318  1109.141     0.150
    85.391  1358.141     0.150
    85.391  1670.141     0.150
    85.552   968.141     0.150
    85.765    20.000     0.150
    86.597  1082.141     0.150
    86.597  1495.141     0.150
    86.597  1969.141     0.150
    86.634   768.141     0.150
    86.634    25.500     0.150
    86.634    43.000     0.150
    86.688   766.141     0.150
    86.688   788.141     0.150
    86.688  1086.141     0.150
    86.688  1366.141     0.150
    86.688  1427.141     0.150
    86.688  1492.141     0.150
    87.106   764.141     0.150
    87.106   767.141     0.150
    87.106     9.000     0.150
    87.090   769.141     0.150
    87.121  1088.141     0.150
    87.121  1400.141     0.150
    87.537   767.938     0.150
    87.809   765.141     0.150
    87.809   909.141     0.150
    87.809  1005.141     0.150
    87.809  1503.141     0.150
    88.220  1426.141     0.150
    88.687   895.141     0.150
    88.687  1371.141     0.150
    88.687  1430.141     0.150
    88.326   783.141     0.150
    88.729   776.242     0.150
    88.729   769.242     0.150
    88.729  1396.141     0.150
    88.755   771.141     0.150
    89.134   774.141     0.150
    89.134   864.141     0.150
    89.612   780.141     0.150
    89.612  1438.141     0.150
    89.650   782.641     0.150
    89.650  1001.141     0.150
    89.650  1389.141     0.150
    89.778   776.141     0.150
    89.861   773.141     0.150
    90.157   789.539     0.150
    90.845   813.141     0.150
    90.845  1019.141     0.150
    90.845  1539.141     0.150
    90.845  1839.141     0.150
    90.845  2333.141     0.150
    90.845  2518.141     0.150
    91.076   787.141     0.150
    91.221   813.344     0.150
    91.255   789.141     0.150
    91.255   816.141     0.150
    91.255  1006.141     0.150
    91.255  1026.141     0.150
    91.255  1026.141     0.150
    91.255  1327.141     0.150
    91.255  1401.141     0.150
    91.255  1849.141     0.150
    91.255  2089.141     0.150
    91.255  2324.141     0.150
    91.255  2340.141     0.150
    91.255  2532.141     0.150
    91.989   792.242     0.150
    92.206   787.141     0.150
    92.684  1029.141     0.150
    92.684  1169.141     0.150
    92.684  1564.141     0.150
    92.684  1909.141     0.150
    92.684  2089.141     0.150
    92.787  1029.141     0.150
    92.744   804.141     0.150
    92.744  1022.141     0.150
    93.636   792.141     0.150
    93.554   802.742     0.150
    94.395   787.641     0.150
    94.743  1051.141     0.150
    94.329   809.141     0.150
    94.399   813.539     0.150
    95.169   849.141     0.150
    95.169   909.141     0.150
    95.169   938.141     0.150
    95.169   998.141     0.150
    95.169  1018.141     0.150
    95.169  1044.141     0.150
    95.169  1103.141     0.150
    95.169  1138.141     0.150
    95.169  1174.141     0.150
    95.169  1212.141     0.150
    95.169  1354.141     0.150
    95.169  1387.141     0.150
    95.169  1489.141     0.150
    95.169  1595.141     0.150
    95.169  1613.141     0.150
    95.199  1446.141     0.150
    95.266   821.141     0.150
    95.266  1052.141     0.150
    95.266  2058.141     0.150
    95.875   845.438     0.150
    95.875  1445.539     0.150
    95.386   823.141     0.150
    96.067  1031.141     0.150
    95.996   811.141     0.150
    95.996  1065.141     0.150
    95.996  1449.141     0.150
    96.650   861.141     0.150
    96.650   883.141     0.150
    96.650   983.141     0.150
    96.650  1189.141     0.150
    96.650  1303.141     0.150
    96.650  1543.141     0.150
    96.650  1589.141     0.150
    97.698   811.141     0.150
    97.822   812.539     0.150
    98.411   832.242     0.150
    98.411  1462.539     0.150
    98.786   817.141     0.150
    98.454   835.742     0.150
    99.247   819.141     0.150
    99.247   819.141     0.150
    99.350   818.938     0.150
    99.350  1000.938     0.150
    99.370   818.641     0.150
    99.324   823.438     0.150
   100.070   831.438     0.150
   100.214   829.742     0.150
   100.465  1534.141     0.150
   100.465  1959.141     0.150
   100.465  2241.141     0.150
   100.740   831.141     0.150
   100.732   825.141     0.150
   101.448   823.844     0.150
   101.790   836.141     0.150
   102.080   835.141     0.150
   102.782   841.141     0.150
   103.175   845.938     0.150
   103.310   849.141     0.150
   103.841   847.141     0.150
   103.770   844.742     0.150
   103.770  1112.141     0.150
   103.770  1374.844     0.150
   105.143   849.141     0.150
   105.143  1499.141     0.150
   105.157   863.641     0.150
   105.860 18641.039     0.150
   106.122   852.141     0.150
   105.765   866.141     0.150
   107.258   859.141     0.150
   107.504   871.141     0.150
   107.804   858.039     0.150
   108.043   873.141     0.150
   108.043   859.141     0.150
   108.043   873.141     0.150
   108.073   865.141     0.150
   108.348   862.141     0.150
   108.281   872.242     0.150
   108.109   872.438     0.150
   108.109  1162.141     0.150
   108.581   870.539     0.150
   109.745   869.141     0.150
   110.270  1086.141     0.150
   111.412   883.141     0.150
   111.412  1133.141     0.150
   111.412  1791.141     0.150
   112.881   891.141     0.150
   112.881  1125.141     0.150
   112.643   903.141     0.150
   112.643  1307.141     0.150
   112.643  1527.141     0.150
   112.643  1599.141     0.150
   112.643  1649.141     0.150
   112.643  2089.141     0.150
   113.436   889.141     0.150
   113.438   894.141     0.150
   114.580   917.141     0.150
   114.580  1339.141     0.150
   114.580  1669.141     0.150
   114.580  2143.141     0.150
   114.580  2379.141     0.150
   115.192   903.141     0.150
   115.192  1170.141     0.150
   115.226   901.141     0.150
   115.226  1134.141     0.150
   115.226  1134.141     0.150
   114.774   897.938     0.150
   114.774  1128.141     0.150
   114.774  1191.141     0.150
   114.774  1311.141     0.150
   114.774  1346.141     0.150
   114.774  1755.141     0.150
   114.774  1128.141     0.150
   115.257  1131.641     0.150
   116.310   885.141     0.150
   116.310  1785.141     0.150
   116.310  2348.141     0.150
   118.381   927.141     0.150
   118.853  1130.141     0.150
   118.683  1193.141     0.150
   119.222  1137.141     0.150
   119.397  1132.039     0.150
   119.397  1911.539     0.150
   119.604   889.742     0.150
   119.909  1137.141     0.150
   120.353  1139.641     0.150
   120.570  1135.641     0.150
   121.189  1141.641     0.150
   121.692   926.141     0.150
   122.765  1137.141     0.150
   123.030  1145.141     0.150
   123.387   917.641     0.150
   123.387  2555.344     0.150
   123.387  1146.641     0.150
   123.387  2555.344     0.150
   122.982  1143.141     0.150
   123.797  1141.141     0.150
   124.220  1136.438     0.150
   124.220  1140.539     0.150
   124.220  1738.938     0.150
   124.817  1149.141     0.150
   124.817  1241.141     0.150
   125.467  1144.641     0.150
   125.467  1265.141     0.150
   125.467  2534.141     0.150
   125.583   897.141     0.150
   125.583  1257.141     0.150
   125.672   954.141     0.150
   126.652  1137.141     0.150
   126.652  1931.141     0.150
   128.315   965.141     0.150
   128.315  1147.141     0.150
   130.955   976.539     0.150
   130.955  1159.742     0.150
   130.955  1283.742     0.150
   130.538  1167.141     0.150
   131.454  1155.141     0.150
   131.454  1303.039     0.150
   131.725  1140.141     0.150
   133.372  1149.141     0.150
   133.372  1312.141     0.150
   134.058  1150.141     0.150
   134.546  1162.641     0.150
   134.609  1162.141     0.150
   135.124  1163.141     0.150
   135.124  1178.141     0.150
   136.317  1147.039     0.150
   136.972  1167.141     0.150
   136.972  1185.141     0.150
   137.303  1175.141     0.150
   137.455  1184.141     0.150
   137.941  1178.141     0.150
   138.139  1189.141     0.150
   138.761  1171.141     0.150
   138.761  1206.141     0.150
   142.914  1183.141     0.150
   143.370  1159.641     0.150
   144.544  1557.742     0.150
   147.879  1407.641     0.150
   148.325  1192.141     0.150
   148.796  1194.141     0.150
    12.521   188.699     0.150
    12.521   401.602     0.150
    16.478   236.500     0.150
    19.573   636.898     0.150
    24.132   539.500     0.150
    25.047   611.500     0.150
    25.833   323.602     0.150
    27.829   351.500     0.150
    27.829   648.500     0.150
    28.090   362.500     0.150
    29.885   377.500     0.150
    37.161   429.500     0.150
    41.470   472.500     0.150
    41.470   824.500     0.150
    41.470  1062.500     0.150
    49.143   531.500     0.150
    54.682   570.500     0.150
    59.339   626.500     0.150
    59.339   818.500     0.150
    59.339  1093.500     0.150
    60.176   611.500     0.150
    60.403   612.500     0.150
    67.269   652.500     0.150
    67.269  1190.500     0.150
    76.754  1310.500     0.150
    79.758   727.500     0.150
    79.758  1332.500     0.150
    80.625   730.500     0.150
    80.625  1342.500     0.150
    81.537   736.500     0.150
    81.537  1352.500     0.150
    82.404   743.699     0.150
    82.788  1369.500     0.150
    83.260   744.500     0.150
    83.260  1364.500     0.150
    83.234   748.301     0.150
    83.234   748.500     0.150
    84.932   756.801     0.150
    85.581   757.500     0.150
    85.677   760.500     0.150
    85.677   972.500     0.150
    85.677  1468.500     0.150
    86.787   765.500     0.150
    86.787   971.500     0.150
    86.787  1476.500     0.150
    86.787  2002.500     0.150
    86.896   767.500     0.150
    87.282   766.500     0.150
    87.282   768.500     0.150
    87.336   767.500     0.150
    87.336   966.500     0.150
    87.336  1748.500     0.150
    87.375   766.602     0.150
    88.122   804.500     0.150
    88.675   773.500     0.150
    88.786   772.801     0.150
    88.810   774.898     0.150
    88.810  1491.500     0.150
    89.257   774.500     0.150
    89.585   777.500     0.150
    89.870   994.500     0.150
    89.870  1522.500     0.150
    89.870  1854.500     0.150
    90.611   780.699     0.150
    91.424  1852.500     0.150
    91.549   787.500     0.150
    91.549   787.500     0.150
    92.114   798.500     0.150
    92.158   790.301     0.150
    94.929   791.500     0.150
    95.122  1038.500     0.150
    95.757   813.500     0.150
    96.249   811.500     0.150
    96.831   814.500     0.150
    96.831     1.000     0.150
    97.850   812.500     0.150
    99.244   821.500     0.150
    99.244   821.500     0.150
    99.379   822.500     0.150
    99.379   822.500     0.150
    99.766  1098.500     0.150
    99.845   823.301     0.150
   106.445   844.500     0.150
   114.158  1132.500     0.150
   114.158  1769.500     0.150
   119.290  1132.000     0.150
   121.387  1131.500     0.150
   122.560  1134.500     0.150
   124.163  1141.500     0.150
   124.163  1141.500     0.150
   134.186  1163.500     0.150
   148.074  1213.500     0.150
     4.204    68.348     0.150
     4.204   123.848     0.150
     4.218    69.348     0.150
     4.218   126.148     0.150
     4.339    71.348     0.150
     4.339   124.348     0.150
    11.710   197.449     0.150
    14.714   211.348     0.150
    15.935   438.348     0.150
    16.310   227.746     0.150
    17.983   245.848     0.150
    17.983   260.047     0.150
    17.983   530.449     0.150
    17.983   530.449     0.150
    17.983   530.449     0.150
    18.756   254.148     0.150
    22.794   295.949     0.150
    22.794   304.746     0.150
    22.794   504.648     0.150
    23.689   328.348     0.150
    24.105   334.246     0.150
    24.636    22.699     0.150
    24.636    37.699     0.150
    24.636    53.699     0.150
    24.636   588.348     0.150
    27.448   362.348     0.150
    30.939    26.000     0.150
    31.225   397.348     0.150
    34.842    25.199     0.150
    36.071    26.500     0.150
    40.072    23.398     0.150
    52.803   634.348     0.150
    54.158   585.348     0.150
    64.885   635.949     0.150
    70.224    27.898     0.150
    70.224  1251.348     0.150
    84.665    27.398     0.150
    86.224    30.000     0.150
    88.770   762.348     0.150
    88.770    31.000     0.150
    88.770  1450.348     0.150
    90.622    28.000     0.150
    90.622  1015.348     0.150
    91.356  1020.348     0.150
    94.331   786.348     0.150
    94.331  1042.746     0.150
    94.331  2290.348     0.150
    94.583   789.348     0.150
    94.583  1041.348     0.150
    96.236   800.348     0.150
     4.014    57.273     0.150
    13.726   476.875     0.150
    17.249   541.477     0.150
    19.093   498.273     0.150
    19.093   498.273     0.150
    19.093   498.273     0.150
    19.810   261.875     0.150
    19.810   633.875     0.150
    23.527   327.672     0.150
    24.325   788.273     0.150
    25.094   821.273     0.150
    26.024   627.273     0.150
    30.153   379.273     0.150
    40.457   465.273     0.150
    40.457   773.273     0.150
    54.245   565.672     0.150
    81.753   736.273     0.150
    82.470   740.273     0.150
    85.442   760.273     0.150
    85.835   785.273     0.150
    85.872   769.273     0.150
    86.797   765.273     0.150
    86.797  1778.273     0.150
    86.797  1988.273     0.150
    89.045   765.273     0.150
    91.047  1818.273     0.150
    97.073   830.273     0.150
    97.073   865.273     0.150
   129.493  1137.273     0.150
     3.311    54.207     0.150
    15.594   232.605     0.150
    15.594   481.906     0.150
    15.594   502.105     0.150
    17.240   472.809     0.150
    17.568   557.207     0.150
    18.747   254.207     0.150
    18.747   258.707     0.150
    18.747   456.207     0.150
    19.427   308.207     0.150
    19.427   625.105     0.150
    21.757    24.000     0.150
    23.943   315.207     0.150
    26.337   333.207     0.150
    28.409   361.008     0.150
    29.417   356.605     0.150
    29.417   648.207     0.150
    35.172   411.207     0.150
    36.634   420.207     0.150
    39.622   452.508     0.150
    40.063   582.207     0.150
    40.063  2626.207     0.150
    40.296   463.105     0.150
    45.682   495.207     0.150
    46.458   512.207     0.150
    48.145  1333.207     0.150
    58.910   656.207     0.150
    68.308   660.207     0.150
    68.308  1198.207     0.150
    77.313   720.207     0.150
    77.313  1299.207     0.150
    80.464   724.207     0.150
    81.060   733.707     0.150
    81.060  1342.207     0.150
    81.395  1350.406     0.150
    81.523   743.207     0.150
    81.523  1676.207     0.150
    82.921   745.605     0.150
    82.693  1359.707     0.150
    84.100   747.207     0.150
    84.100  1365.707     0.150
    84.310   831.207     0.150
    84.813  1577.207     0.150
    84.892   753.309     0.150
    85.157   786.707     0.150
    85.217   755.809     0.150
    85.518   758.207     0.150
    85.518     6.500     0.150
    85.570   752.207     0.150
    86.269   758.207     0.150
    86.769   763.008     0.150
    86.792   762.207     0.150
    86.792    10.000     0.150
    87.089   776.207     0.150
    87.743   792.207     0.150
    88.432   773.207     0.150
    88.546   769.707     0.150
    88.546  1402.207     0.150
    89.522   772.207     0.150
    90.268   778.207     0.150
    90.525  1788.207     0.150
    90.806   876.207     0.150
    90.932   775.207     0.150
    90.950    16.898     0.150
    90.950  1870.207     0.150
    92.875   791.605     0.150
    94.262   806.406     0.150
    94.838   868.207     0.150
    96.563   836.207     0.150
    96.563   877.207     0.150
    96.563   907.207     0.150
    97.409   812.207     0.150
    98.641   816.008     0.150
    99.127   813.207     0.150
    99.127   813.207     0.150
   100.951  1015.207     0.150
   101.328   833.207     0.150
   101.194  1062.207     0.150
   101.814   838.207     0.150
   101.814   838.207     0.150
   106.288  1108.207     0.150
   116.931  1130.207     0.150
   117.636  1141.207     0.150
   123.890  1133.207     0.150
   124.496  1138.207     0.150
   127.198  1161.406     0.150
   129.542  1141.207     0.150
   131.932  1161.207     0.150
   134.822  1170.406     0.150
   137.825  1162.207     0.150
   139.177  1164.207     0.150
   143.009  1181.207     0.150
    11.804   177.367     0.150
    15.939   491.867     0.150
    16.884   245.168     0.150
    17.281   236.367     0.150
    17.281   556.367     0.150
    18.104   553.766     0.150
    18.326   577.066     0.150
    18.652   578.867     0.150
    18.701   586.367     0.150
    19.425   268.867     0.150
    20.095   279.367     0.150
    21.092   664.168     0.150
    22.325   296.168     0.150
    24.070   314.668     0.150
    24.070   326.367     0.150
    24.489   324.168     0.150
    25.794   329.668     0.150
    25.794     8.098     0.150
    27.527   344.867     0.150
    28.826   372.566     0.150
    29.246   368.867     0.150
    34.587   413.367     0.150
    34.476   405.668     0.150
    34.822   414.367     0.150
    35.416   420.969     0.150
    36.504   431.867     0.150
    37.820   441.469     0.150
    38.541   445.367     0.150
    40.030   459.969     0.150
    43.985   493.066     0.150
    45.582   498.367     0.150
    50.095   987.367     0.150
    52.557   549.367     0.150
    57.737   585.867     0.150
     3.297    51.285     0.150
    16.322   240.484     0.150
    16.322   246.285     0.150
    16.322   527.785     0.150
    16.735   241.684     0.150
    16.735   255.887     0.150
    16.916   251.785     0.150
    17.272   234.285     0.150
    17.272   237.586     0.150
    17.272   257.984     0.150
    17.272   274.684     0.150
    18.485   258.387     0.150
    18.485   270.387     0.150
    18.485   330.387     0.150
    18.531   255.484     0.150
    18.531   258.484     0.150
    18.531   274.184     0.150
    18.769   250.285     0.150
    18.769   250.285     0.150
    18.769   250.285     0.150
    23.925    22.500     0.150
    25.063    18.801     0.150
    25.063    51.801     0.150
    25.317    22.898     0.150
    26.994    38.199     0.150
    26.994   385.285     0.150
    26.994   385.285     0.150
    28.817   371.285     0.150
    29.928   372.285     0.150
    39.344   455.285     0.150
    40.362   453.285     0.150
    48.437   899.285     0.150
    50.915   547.484     0.150
    55.408   567.285     0.150
    63.400   640.785     0.150
    63.926   645.785     0.150
    80.527    64.602     0.150
    80.527   790.887     0.150
    80.748  1335.285     0.150
    80.748  1335.285     0.150
    81.437  1370.887     0.150
    83.003   736.285     0.150
    86.510   755.785     0.150
    86.510   755.785     0.150
    86.603   758.285     0.150
    89.489   774.785     0.150
    94.655   799.285     0.150
    94.655    35.898     0.150
    96.370   811.285     0.150
    96.370    32.398     0.150
    97.212   817.285     0.150
   100.899  1483.285     0.150
   100.899  1483.285     0.150
   130.700  1349.785     0.150
   131.625  1148.684     0.150
   134.180  1154.285     0.150
   137.504  1158.586     0.150
     3.925   108.477     0.150
    17.078    13.699     0.150
    25.243   304.977     0.150
    29.381   354.477     0.150
    30.052   366.676     0.150
    30.052   366.676     0.150
    40.221   438.375     0.150
    48.669   521.477     0.150
    48.669   978.477     0.150
    49.109   544.477     0.150
    54.095   571.578     0.150
    54.095   571.578     0.150
    55.449   632.676     0.150
    79.114   723.078     0.150
    79.944   731.277     0.150
    80.369   734.176     0.150
    82.730   743.477     0.150
    85.530   765.477     0.150
    86.134   760.477     0.150
    87.006   761.875     0.150
    87.006   761.875     0.150
    87.642   758.977     0.150
    87.642    32.000     0.150
    87.752   753.977     0.150
    91.147   783.078     0.150
    91.147   783.078     0.150
    91.388   791.676     0.150
    91.388   753.477     0.150
    96.694    20.000     0.150
   125.896  1127.477     0.150
   137.438  1158.176     0.150
   143.825  1151.375     0.150
   143.825  1161.477     0.150
   144.707  1183.078     0.150
   145.698  1179.477     0.150
     2.253    67.896     0.150
    12.787   414.396     0.150
    16.404   517.396     0.150
    17.485     8.500     0.150
    18.980   608.096     0.150
    21.678   535.396     0.150
    21.678   764.396     0.150
    21.986   692.396     0.150
    22.018   694.197     0.150
    22.566     8.000     0.150
    22.566   495.596     0.150
    24.115   354.197     0.150
    24.115   845.297     0.150
    24.703     8.500     0.150
    25.669     9.000     0.150
    25.669   817.197     0.150
    26.015   827.496     0.150
    27.263   847.996     0.150
    30.529   373.197     0.150
    30.442   373.396     0.150
    31.493   385.396     0.150
    31.876   376.596     0.150
    36.406   429.096     0.150
    36.406    13.301     0.150
    39.765   462.396     0.150
    45.475   498.697     0.150
    45.517   509.396     0.150
    47.648   519.896     0.150
    51.300   532.396     0.150
    51.602   551.896     0.150
    55.342   581.896     0.150
    58.639   596.396     0.150
    58.916   603.697     0.150
    65.849   653.396     0.150
    68.582   662.197     0.150
    68.582     6.199     0.150
    68.582    10.199     0.150
    68.582   691.396     0.150
    68.582  1207.396     0.150
    68.582  1247.396     0.150
    81.133  1348.297     0.150
    81.207   737.396     0.150
    81.207   737.396     0.150
    81.207     7.000     0.150
    81.207  1345.396     0.150
    81.354   736.396     0.150
    81.354  1347.396     0.150
    82.977   739.396     0.150
    82.977   739.396     0.150
    82.977     4.000     0.150
    84.353   752.896     0.150
    84.353     3.000     0.150
    84.353  1369.396     0.150
    85.525   761.396     0.150
    86.310   764.396     0.150
    86.375   793.596     0.150
    86.797   773.297     0.150
    86.797  1393.396     0.150
    87.292   767.396     0.150
    87.407    15.600     0.150
    87.720   796.396     0.150
    88.499  1433.396     0.150
    88.865   773.396     0.150
    89.117   771.396     0.150
    89.644    13.500     0.150
    89.644   983.396     0.150
    90.539   781.297     0.150
    90.998   782.396     0.150
    92.426  2898.396     0.150
    92.426   787.896     0.150
    93.624   794.396     0.150
    93.624    11.000     0.150
    95.377   802.396     0.150
    96.602   808.396     0.150
    96.613    19.000     0.150
    96.613   863.396     0.150
    97.463   812.396     0.150
    99.240   828.396     0.150
    99.240   828.396     0.150
    99.347   829.096     0.150
    99.347   829.096     0.150
    99.347  1923.396     0.150
   133.511  1165.396     0.150
   135.897  1172.396     0.150
   136.355  1161.396     0.150
     3.632    58.191     0.150
    47.882   522.691     0.150
    85.544   762.691     0.150
    87.387   770.691     0.150
    90.373   776.491     0.150
    90.896   786.691     0.150
   145.076  1184.291     0.150
   151.631  1183.991     0.150
     2.737    37.533     0.150
     3.126    45.834     0.150
     5.530    76.834     0.150
    12.171   183.834     0.150
    15.730    10.900     0.150
    15.730   232.135     0.150
    16.801    11.199     0.150
    16.801   248.834     0.150
    17.186   248.334     0.150
    17.186   266.234     0.150
    18.308   257.135     0.150
    18.308   791.334     0.150
    18.432   241.434     0.150
    18.432   265.934     0.150
    18.770   244.635     0.150
    18.770   254.734     0.150
    18.770   797.635     0.150
    21.310    13.000     0.150
    21.310   297.834     0.150
    21.343    12.000     0.150
    21.343   298.834     0.150
    22.053   302.635     0.150
    22.287   276.834     0.150
    25.225    12.500     0.150
    25.225   338.135     0.150
    25.284   317.635     0.150
    25.341    14.000     0.150
    25.341   337.834     0.150
    86.222   760.234     0.150
    95.176   882.635     0.150
    12.333   297.281     0.150
    12.678   327.781     0.150
    13.123   436.281     0.150
    13.123   547.281     0.150
    13.123   568.281     0.150
    18.949   265.281     0.150
    18.949   295.281     0.150
    19.542   271.281     0.150
    20.858   290.281     0.150
    20.957   285.281     0.150
    20.957   656.281     0.150
    21.392   360.281     0.150
    21.766   327.281     0.150
    22.301   306.281     0.150
    23.723    19.301     0.150
    23.779   310.082     0.150
    24.641   319.582     0.150
    24.852   337.480     0.150
    24.852   549.281     0.150
    24.872    18.301     0.150
    24.872   549.281     0.150
    24.988   328.281     0.150
    24.988   339.281     0.150
    25.117   550.281     0.150
    25.677    14.301     0.150
    25.826    16.801     0.150
    25.826   552.680     0.150
    25.826   575.281     0.150
    25.826   629.281     0.150
    26.611   554.281     0.150
    27.249   554.281     0.150
    27.904   555.281     0.150
    28.515    22.797     0.150
    29.313   368.883     0.150
    40.690   453.883     0.150
    46.329   497.281     0.150
    53.527   555.281     0.150
    53.527   510.281     0.150
    53.915   557.781     0.150
    55.262   566.781     0.150
    56.846   579.281     0.150
    57.964   585.582     0.150
    66.904   647.082     0.150
    67.829   653.883     0.150
    67.829  1191.281     0.150
    69.262   662.480     0.150
    69.262   608.980     0.150
    69.262   616.383     0.150
    69.738   679.281     0.150
    79.461   725.281     0.150
    80.363   727.480     0.150
    80.363  1332.281     0.150
    80.549   724.281     0.150
    80.549   724.281     0.150
    80.549     4.000     0.150
    80.549  1333.281     0.150
    82.197   737.281     0.150
    82.197     0.500     0.150
    82.197  1350.281     0.150
    83.656   742.281     0.150
    83.656  1359.281     0.150
    84.857   760.281     0.150
    85.077  1363.281     0.150
    87.042   760.781     0.150
    87.065   761.281     0.150
    87.303   766.082     0.150
    87.765   758.281     0.150
    87.765  1310.281     0.150
    87.800  1398.281     0.150
    89.801   772.980     0.150
    89.794   772.980     0.150
    91.589   782.281     0.150
    92.080   784.582     0.150
    92.080  1439.281     0.150
    92.080  1543.281     0.150
    92.385    25.500     0.150
    92.385   785.281     0.150
    92.362  1443.281     0.150
    94.777  -114.418     0.150
    94.777  -108.918     0.150
    94.777  -104.219     0.150
    95.216  -119.719     0.150
    95.216  -115.719     0.150
    95.216   812.680     0.150
    96.136  -123.719     0.150
    96.246    26.000     0.150
    96.246   837.281     0.150
    96.466   819.281     0.150
    96.466    26.000     0.150
    98.178   812.281     0.150
    99.040  1499.281     0.150
   111.480  1103.281     0.150
   121.146  1127.980     0.150
   133.658  1142.781     0.150
   134.187  1153.281     0.150
   141.398  1162.281     0.150
   144.396  1168.281     0.150
     1.241    41.508     0.150
     3.820   112.008     0.150
     3.824   108.508     0.150
    12.656   326.508     0.150
    16.596   247.008     0.150
    17.407   256.508     0.150
    19.312   648.508     0.150
    48.830  1352.508     0.150
    54.066   559.508     0.150
    68.662   669.109     0.150
   125.940  1146.508     0.150
   144.224  1180.508     0.150
     4.635   129.396     0.150
    87.756   770.195     0.150
     0.501    13.957     0.150
     0.501    20.258     0.150
     6.338    90.258     0.150
     6.234    85.258     0.150
    12.158   183.258     0.150
    12.951   192.258     0.150
    13.675   204.258     0.150
    13.675   373.957     0.150
    18.671   317.297     0.150
    18.875   261.656     0.150
    18.875   264.359     0.150
    18.875   266.559     0.150
    18.730   328.047     0.150
    19.688   272.156     0.150
    20.242   530.957     0.150
    20.654   288.258     0.150
    21.211   279.258     0.150
    21.211   293.258     0.150
    21.223   534.258     0.150
    21.310   292.758     0.150
    21.323   298.258     0.150
    21.763   289.258     0.150
    21.798   288.258     0.150
    22.561   311.258     0.150
    22.858   311.258     0.150
    24.074   321.559     0.150
    24.140   321.059     0.150
    24.213     7.801     0.150
    24.213   357.258     0.150
    24.213   408.258     0.150
    24.213   511.258     0.150
    24.213   522.258     0.150
    24.213   548.258     0.150
    24.307   327.156     0.150
    24.613   327.559     0.150
    24.675   330.059     0.150
    24.690   328.438     0.150
    24.978   324.258     0.150
    26.193   337.559     0.150
    27.091   343.258     0.150
    26.977   347.859     0.150
    27.618   353.656     0.150
    28.716   359.258     0.150
    29.842   376.758     0.150
    30.832   380.258     0.150
    33.468   400.457     0.150
    33.468     2.102     0.150
    33.468  1080.258     0.150
    33.360   421.859     0.150
    38.904   447.969     0.150
    39.120   458.258     0.150
    39.205   461.258     0.150
    39.404   456.758     0.150
    39.939   850.258     0.150
    40.128   458.359     0.150
    40.257   462.656     0.150
    40.250   463.758     0.150
    40.601   456.156     0.150
    40.963   468.156     0.150
    40.935   475.859     0.150
    41.395   475.258     0.150
    51.609   554.656     0.150
    51.971   554.258     0.150
    52.058   553.758     0.150
    54.303   563.859     0.150
    54.324   569.457     0.150
    55.010   579.059     0.150
    55.080   579.258     0.150
    55.229   580.457     0.150
    55.307   580.957     0.150
    55.815  1291.258     0.150
    56.488   586.258     0.150
    56.881   589.258     0.150
    57.207   591.359     0.150
    57.172   592.359     0.150
    57.959   600.656     0.150
    57.963   601.559     0.150
    58.093   602.359     0.150
    58.150   602.656     0.150
    58.234   603.359     0.150
    58.923   594.258     0.150
    59.004   605.258     0.150
    59.031   602.758     0.150
    59.435   605.457     0.150
    59.366   609.258     0.150
    59.673   604.258     0.150
    61.427   635.258     0.150
    63.497    16.703     0.150
    63.497   628.668     0.150
    66.435   648.258     0.150
    67.633   660.059     0.150
    67.633  1200.059     0.150
    68.003   662.758     0.150
    68.220     0.898     0.150
    68.220   659.359     0.150
    68.220     0.898     0.150
    68.220   915.258     0.150
    68.220  1201.258     0.150
    68.142   665.258     0.150
    68.142  1213.258     0.150
    70.096   677.258     0.150
    70.066   678.156     0.150
    70.909   680.859     0.150
    75.125   720.258     0.150
    77.035   716.758     0.150
    77.539   719.656     0.150
    79.224   731.656     0.150
    79.799   732.059     0.150
    80.693   731.457     0.150
    80.748   732.258     0.150
    80.748  1346.258     0.150
    80.748  1403.258     0.150
    80.938   742.258     0.150
    80.938   800.258     0.150
    80.903   738.258     0.150
    80.903   738.258     0.150
    80.903  1349.258     0.150
    81.386  1054.258     0.150
    81.659  1039.258     0.150
    81.706   746.359     0.150
    82.576   749.258     0.150
    82.576   741.859     0.150
    82.576   747.258     0.150
    82.576  1050.258     0.150
    83.004   750.656     0.150
    83.147   748.059     0.150
    83.147   748.059     0.150
    83.147  1372.859     0.150
    84.036   758.059     0.150
    84.060   747.758     0.150
    84.060   942.258     0.150
    84.060  1061.258     0.150
    84.060  1378.258     0.150
    84.591   748.258     0.150
    84.827   761.258     0.150
    85.075   967.758     0.150
    85.075  1088.758     0.150
    85.075  1481.758     0.150
    85.075  1753.758     0.150
    85.312  1064.258     0.150
    85.352   767.258     0.150
    85.395   774.656     0.150
    85.842   757.559     0.150
    85.690   769.957     0.150
    86.304   761.457     0.150
    86.336   810.258     0.150
    86.483  1081.258     0.150
    86.483  1953.258     0.150
    86.560  1413.258     0.150
    86.560  1561.258     0.150
    86.635   769.359     0.150
    86.652   769.258     0.150
    86.909   762.559     0.150
    87.159   767.457     0.150
    87.274   772.859     0.150
    87.422   772.457     0.150
    87.474  2336.258     0.150
    87.181   773.258     0.150
    87.181  1770.258     0.150
    87.590  2336.656     0.150
    88.017   771.258     0.150
    88.017   837.258     0.150
    88.084   768.059     0.150
    88.084  1438.258     0.150
    88.084  2345.258     0.150
    88.102   770.258     0.150
    87.964   779.258     0.150
    88.611   779.059     0.150
    88.624   779.059     0.150
    88.624   858.258     0.150
    88.624   883.258     0.150
    88.659   779.059     0.150
    88.716   769.258     0.150
    88.844   776.359     0.150
    88.844   776.359     0.150
    88.844  1422.258     0.150
    88.959   771.457     0.150
    89.160   988.258     0.150
    89.160  1791.258     0.150
    89.250   782.059     0.150
    89.399   782.457     0.150
    89.513   983.258     0.150
    89.661   993.258     0.150
    89.865   784.859     0.150
    89.982   785.258     0.150
    90.188   778.359     0.150
    90.188   999.258     0.150
    90.188  1429.258     0.150
    90.188  1529.258     0.150
    90.433    15.699     0.150
    90.433   934.758     0.150
    90.380   785.258     0.150
    90.380   785.258     0.150
    90.690   780.258     0.150
    90.690   780.258     0.150
    90.690   785.758     0.150
    90.709   789.258     0.150
    90.736  1001.258     0.150
    90.736  1378.258     0.150
    90.736  1813.258     0.150
    90.736  1949.258     0.150
    90.736  2038.258     0.150
    90.736  2181.258     0.150
    90.736   781.258     0.150
    90.736   785.258     0.150
    90.736     8.000     0.150
    90.736  1001.258     0.150
    90.736  1378.258     0.150
    90.736  1429.258     0.150
    90.736  1813.258     0.150
    90.736  1949.258     0.150
    90.736  2038.258     0.150
    90.736  2181.258     0.150
    90.736   781.258     0.150
    90.986   790.258     0.150
    90.989   783.258     0.150
    90.989  1437.758     0.150
    91.047   786.758     0.150
    91.047   786.758     0.150
    91.047  1433.258     0.150
    91.157   782.258     0.150
    91.157  1429.258     0.150
    91.381   792.258     0.150
    91.219   804.258     0.150
    91.773   790.359     0.150
    91.773   790.359     0.150
    91.890   786.059     0.150
    91.890  1419.258     0.150
    92.486   789.258     0.150
    92.486  1429.258     0.150
    92.600    14.000     0.150
    92.600   790.258     0.150
    92.683   788.258     0.150
    92.683   788.258     0.150
    92.683  1428.258     0.150
    92.711   796.258     0.150
    92.711   796.258     0.150
    92.711  1461.258     0.150
    92.701  1403.258     0.150
    93.161   796.758     0.150
    93.161     4.000     0.150
    93.161  1031.258     0.150
    93.161  1395.258     0.150
    93.364   798.758     0.150
    93.212   802.258     0.150
    92.992   814.258     0.150
    92.992  1064.258     0.150
    93.476   792.258     0.150
    93.661    11.000     0.150
    93.661  1026.258     0.150
    93.661  2328.258     0.150
    93.663   797.258     0.150
    93.663   797.258     0.150
    93.663  1143.258     0.150
    93.919   802.758     0.150
    93.919  1517.258     0.150
    94.136   807.059     0.150
    94.487  1462.258     0.150
    94.487   752.301     0.150
    94.487  1589.258     0.150
    94.593   803.258     0.150
    94.597   803.359     0.150
    94.597  1030.156     0.150
    94.597   804.258     0.150
    94.597     3.500     0.150
    94.597  1030.156     0.150
    94.422   815.258     0.150
    94.422   831.258     0.150
    94.755   803.258     0.150
    94.755  1283.258     0.150
    94.766   802.859     0.150
    94.588   816.258     0.150
    94.588  1051.258     0.150
    94.588  1863.859     0.150
    95.072   835.156     0.150
    95.072  1056.359     0.150
    95.072   802.359     0.150
    95.523   814.758     0.150
    95.523  1039.258     0.150
    95.523  1419.258     0.150
    95.523   802.957     0.150
    95.523  1039.258     0.150
    95.550   812.258     0.150
    95.854   812.258     0.150
    95.504   814.457     0.150
    95.504  1050.258     0.150
    95.959   829.758     0.150
    95.959   856.258     0.150
    95.959   806.359     0.150
    95.992   806.758     0.150
    96.199   815.156     0.150
    96.155   816.258     0.150
    96.155  1408.258     0.150
    96.402   806.258     0.150
    96.454   820.359     0.150
    96.375   816.258     0.150
    96.584   815.258     0.150
    96.229   819.258     0.150
    96.229  1396.258     0.150
    96.229  1451.258     0.150
    96.552   818.258     0.150
    96.860   817.258     0.150
    97.612     4.000     0.150
    97.612     4.000     0.150
    97.612  1058.258     0.150
    97.752   817.258     0.150
    97.346   823.156     0.150
    97.407   816.758     0.150
    97.673   822.258     0.150
    98.275   826.258     0.150
    98.577   818.258     0.150
    98.796   823.859     0.150
    98.796  1074.859     0.150
    98.839   828.258     0.150
    98.652   827.758     0.150
    98.924   826.859     0.150
    98.924  1494.156     0.150
    99.150   826.758     0.150
    99.190   828.258     0.150
    98.867   823.957     0.150
    99.277   823.258     0.150
    99.277   823.258     0.150
    99.277  1067.258     0.150
    99.277  1465.258     0.150
    99.209   828.359     0.150
    99.209   828.359     0.150
    99.392   820.258     0.150
    99.392   825.258     0.150
    99.392  1197.258     0.150
    99.392  1465.258     0.150
    99.592   827.258     0.150
    99.639   830.258     0.150
    99.639   833.258     0.150
    99.872   829.258     0.150
   100.067   831.758     0.150
    99.861   828.758     0.150
    99.798   830.258     0.150
   100.563   836.258     0.150
   100.587   831.258     0.150
   100.779   833.258     0.150
   100.606   836.957     0.150
   100.871   834.758     0.150
   101.176   836.656     0.150
   101.176  1475.258     0.150
   101.247   836.258     0.150
   101.297   835.758     0.150
   101.232   832.258     0.150
   101.232  1084.258     0.150
   101.534   837.258     0.150
   101.536   837.258     0.150
   101.536   837.758     0.150
   101.702   838.258     0.150
   101.594   835.258     0.150
   101.594  1215.258     0.150
   101.845   839.258     0.150
   102.010   835.258     0.150
   102.010  1089.258     0.150
   102.023   840.258     0.150
   102.067   845.258     0.150
   102.097   839.258     0.150
   102.097   839.758     0.150
   102.244   841.258     0.150
   102.317   840.258     0.150
   102.368   842.258     0.150
   102.537   843.258     0.150
   102.667   842.258     0.150
   102.768   844.258     0.150
   102.873   845.258     0.150
   102.900   843.258     0.150
   102.899   843.758     0.150
   102.933   844.957     0.150
   102.979   845.156     0.150
   103.014   845.258     0.150
   103.248   845.758     0.150
   103.527   847.258     0.150
   103.715   847.258     0.150
   103.515   851.258     0.150
   103.515  1111.258     0.150
   103.853   849.258     0.150
   103.709   860.258     0.150
   103.787   855.258     0.150
   103.787  1112.258     0.150
   103.845   857.258     0.150
   103.845  1113.258     0.150
   104.177   846.258     0.150
   104.177  1105.258     0.150
   104.215   845.258     0.150
   104.215   845.258     0.150
   104.215  1239.258     0.150
   104.935   852.059     0.150
   104.981   851.258     0.150
   104.981  1493.258     0.150
   105.411   852.656     0.150
   105.760   857.258     0.150
   105.969   839.258     0.150
   105.995   841.258     0.150
   105.676   857.258     0.150
   106.065   855.258     0.150
   106.065   855.258     0.150
   106.065  1257.258     0.150
   106.065  1499.258     0.150
   106.065  2023.258     0.150
   106.168   865.957     0.150
   106.235   857.258     0.150
   106.235  1259.258     0.150
   106.330   857.758     0.150
   106.351   857.258     0.150
   107.294   864.059     0.150
   107.294   864.059     0.150
   107.621   868.156     0.150
   107.621   868.156     0.150
   107.732   863.258     0.150
   107.732   863.258     0.150
   107.732  1131.258     0.150
   107.568   810.758     0.150
   107.568   888.359     0.150
   107.875   868.758     0.150
   108.181   869.258     0.150
   108.181   869.758     0.150
   108.181  2053.258     0.150
   108.633   870.258     0.150
   108.633   870.258     0.150
   109.477   874.258     0.150
   109.554   871.457     0.150
   109.834   872.258     0.150
   110.291   881.258     0.150
   110.788   877.258     0.150
   110.788   877.258     0.150
   110.788  1519.258     0.150
   110.653  1124.457     0.150
   110.653  1200.258     0.150
   111.861   885.258     0.150
   111.861   885.258     0.150
   111.853   883.258     0.150
   111.915   885.258     0.150
   112.467   884.258     0.150
   112.467   884.258     0.150
   112.859   887.258     0.150
   112.859   887.258     0.150
   112.859  1171.258     0.150
   112.859  1807.258     0.150
   113.387   887.859     0.150
   112.976   900.258     0.150
   112.976  1754.258     0.150
   113.449   886.957     0.150
   113.449   886.957     0.150
   113.377   888.758     0.150
   113.377  1174.258     0.150
   113.800   892.258     0.150
   113.800   892.258     0.150
   114.249   892.258     0.150
   114.249  1181.258     0.150
   114.247   893.258     0.150
   114.247  1124.758     0.150
   114.247  1191.258     0.150
   114.559   893.258     0.150
   114.559   893.258     0.150
   114.905   900.258     0.150
   114.905  1130.258     0.150
   114.905  1774.258     0.150
   114.957   897.258     0.150
   114.957   897.258     0.150
   115.008   897.258     0.150
   114.865   898.258     0.150
   114.865   898.258     0.150
   114.865  1193.258     0.150
   115.218   900.258     0.150
   115.218  1129.258     0.150
   115.492  1124.758     0.150
   115.515   901.258     0.150
   115.515  1195.258     0.150
   115.515  1341.258     0.150
   115.515  1630.258     0.150
   115.515  2120.258     0.150
   115.913   900.457     0.150
   115.913   900.457     0.150
   116.144   900.258     0.150
   116.280   902.258     0.150
   116.280  1114.258     0.150
   116.556   911.258     0.150
   116.556   911.258     0.150
   117.024   908.758     0.150
   117.024  1304.758     0.150
   117.024  1742.758     0.150
   116.560   913.258     0.150
   117.086   915.758     0.150
   117.086  1127.258     0.150
   117.086   916.258     0.150
   117.086  1795.758     0.150
   117.204  1132.258     0.150
   117.946  1131.156     0.150
   117.946  1161.359     0.150
   117.946  1221.859     0.150
   118.171   913.758     0.150
   118.171  1150.258     0.150
   119.089   916.758     0.150
   119.073   916.258     0.150
   119.049   919.758     0.150
   119.049   919.758     0.150
   119.150   914.457     0.150
   119.150  1214.758     0.150
   119.150  1686.258     0.150
   119.218   919.258     0.150
   119.218  1687.258     0.150
   119.438   916.258     0.150
   119.438   916.258     0.150
   119.438  1215.258     0.150
   119.438  1367.258     0.150
   119.794   919.258     0.150
   119.794  1753.258     0.150
   119.830   918.258     0.150
   119.830   918.758     0.150
   119.966   918.258     0.150
   119.966   918.258     0.150
   120.116   923.258     0.150
   120.116  1203.258     0.150
   120.116  1531.258     0.150
   119.936  1107.258     0.150
   120.012   919.258     0.150
   120.012  1223.258     0.150
   120.134   920.258     0.150
   120.529  1148.258     0.150
   120.524   921.258     0.150
   120.524   921.258     0.150
   120.474  1098.258     0.150
   120.645   920.258     0.150
   120.645  1134.258     0.150
   120.875   927.258     0.150
   121.039   938.258     0.150
   121.384   929.258     0.150
   121.384   929.258     0.150
   121.384  1229.258     0.150
   121.366   925.258     0.150
   121.580   925.258     0.150
   121.580   925.258     0.150
   121.580  1384.258     0.150
   121.842   927.258     0.150
   121.842   928.059     0.150
   121.842  1232.559     0.150
   121.806   931.258     0.150
   122.788   931.258     0.150
   122.941   933.258     0.150
   122.941   933.258     0.150
   122.941  1237.258     0.150
   122.941  1915.258     0.150
   123.192   932.258     0.150
   123.192   932.656     0.150
   123.310  1142.258     0.150
   123.661  1142.258     0.150
   123.967   939.258     0.150
   123.967   939.258     0.150
   123.888  1140.859     0.150
   124.565   939.457     0.150
   124.565   939.457     0.150
   125.135   944.258     0.150
   125.371   943.258     0.150
   126.026   957.258     0.150
   126.088   949.258     0.150
   126.154  1146.758     0.150
   126.109  1147.258     0.150
   126.109  1253.258     0.150
   126.109  1346.258     0.150
   126.238   947.258     0.150
   126.238  1151.258     0.150
   126.244  1138.457     0.150
   126.244  1147.258     0.150
   126.244  1959.258     0.150
   126.964  1137.258     0.150
   127.417   958.258     0.150
   127.456  1139.258     0.150
   129.543  1919.258     0.150
   129.948   964.656     0.150
   129.948  1155.859     0.150
   129.948  1612.656     0.150
   130.507  1158.258     0.150
   130.507  1166.258     0.150
   130.382  1156.758     0.150
   130.382  1472.258     0.150
   131.081   969.258     0.150
   131.434  1954.258     0.150
   132.410  1160.957     0.150
   132.661  1312.758     0.150
   132.818  1171.758     0.150
   133.608  1148.258     0.150
   133.608  1308.258     0.150
   133.608  1483.258     0.150
   134.058  1163.559     0.150
   134.058  1378.059     0.150
   134.433  1167.258     0.150
   134.446   983.258     0.150
   134.580  1164.258     0.150
   134.780  1158.758     0.150
   135.091  1179.359     0.150
   135.728  1021.258     0.150
   135.728  1218.258     0.150
   136.218  1171.258     0.150
   136.620  1167.758     0.150
   136.914  1188.258     0.150
   137.639  1345.258     0.150
   137.698  1158.258     0.150
   141.243  1035.258     0.150
   143.087  1164.457     0.150
   143.087  1370.457     0.150
   144.028  1184.258     0.150
   144.801  1035.258     0.150
   144.801  1425.258     0.150
   144.801  1573.258     0.150
   144.801  1588.258     0.150
   144.801  1677.258     0.150
   144.801  1791.258     0.150
   144.801  1816.258     0.150
   147.572  1203.258     0.150
   148.145  1261.258     0.150
   150.079  1213.957     0.150
   150.400  1176.758     0.150
   151.963  1188.258     0.150
   151.963  1618.258     0.150
   151.963  2184.258     0.150
   153.675  1193.758     0.150
    21.609   300.281     0.150
    24.348  1102.883     0.150
    25.365   324.883     0.150
    25.410   328.383     0.150
    48.224   526.883     0.150
    48.422   528.883     0.150
    50.375   544.883     0.150
    68.919   659.883     0.150
   134.735  1161.883     0.150
    11.290   163.641     0.150
    18.386   254.641     0.150
    18.386   588.641     0.150
    19.723   635.641     0.150
    20.190   271.441     0.150
    21.163   674.641     0.150
    21.245   705.641     0.150
    21.969   700.641     0.150
    23.899   454.641     0.150
    24.289   387.141     0.150
    24.289   461.641     0.150
    24.289   799.641     0.150
    24.461    18.000     0.150
    26.008    52.400     0.150
    26.008   403.641     0.150
    26.008   483.641     0.150
    29.708   372.641     0.150
    29.735   366.641     0.150
    31.235   392.141     0.150
    38.008   438.641     0.150
    52.236   557.141     0.150
    59.488 -2494.359     0.150
    59.488 -2231.359     0.150
    59.488 -1666.359     0.150
    59.488   823.641     0.150
    68.096   659.141     0.150
    68.096   676.941     0.150
    68.096  1202.641     0.150
    68.096  1239.641     0.150
    80.611   731.840     0.150
    80.611  1339.840     0.150
    80.729   739.641     0.150
    80.729   739.641     0.150
    80.729  1343.641     0.150
    80.815   732.840     0.150
    81.841   921.641     0.150
    82.430   738.641     0.150
    82.430     2.000     0.150
    82.430   738.641     0.150
    82.430     2.000     0.150
    82.430  1423.641     0.150
    83.971   745.641     0.150
    83.971     2.000     0.150
    83.971   745.641     0.150
    83.971     2.000     0.150
    83.971  1059.641     0.150
    83.971  1370.641     0.150
    85.250  1753.641     0.150
    88.885   780.641     0.150
    88.885   780.641     0.150
    90.069   777.641     0.150
    90.222   777.941     0.150
    90.861   781.641     0.150
    90.861  1423.641     0.150
    90.861  1508.641     0.150
    90.861  1803.641     0.150
    90.861   781.641     0.150
    90.861   783.641     0.150
    91.163   775.641     0.150
    91.277   784.340     0.150
    92.010   787.441     0.150
    92.442   788.740     0.150
    92.727   790.641     0.150
    92.805   791.041     0.150
    93.664   794.941     0.150
    94.625   795.141     0.150
    94.625  1023.641     0.150
    94.625  2109.641     0.150
    97.727   813.641     0.150
    97.727  1049.641     0.150
    97.727  1507.641     0.150
    98.470   810.641     0.150
    98.470   811.541     0.150
    99.463   815.641     0.150
    99.463   815.641     0.150
   101.438   823.641     0.150
   133.581  2001.641     0.150
   144.764  1247.641     0.150
   144.764  1377.641     0.150
   147.453  1200.641     0.150
     3.595    92.836     0.150
     4.072   105.836     0.150
     5.130   126.836     0.150
    19.583   252.836     0.150
    20.906   276.836     0.150
    22.230   303.836     0.150
    48.526   520.836     0.150
    67.205   656.035     0.150
    87.327   766.936     0.150
    87.683   769.836     0.150
    88.218   771.336     0.150
   125.734  1132.637     0.150
   125.752  1135.736     0.150
     0.900    14.250     0.150
     0.900    27.250     0.150
    19.361   260.852     0.150
    21.170   479.250     0.150
    21.749   289.250     0.150
    22.082   297.250     0.150
    23.252   304.750     0.150
    24.021   316.852     0.150
    24.090   316.449     0.150
    24.513   318.148     0.150
    24.565   320.852     0.150
    25.160   326.852     0.150
    25.409   329.250     0.150
    25.419   329.949     0.150
    26.928   604.949     0.150
    28.223   352.750     0.150
    28.894   356.148     0.150
    31.067   362.250     0.150
    34.792   405.250     0.150
    48.406   524.250     0.150
    66.798   649.949     0.150
    68.071   657.250     0.150
    68.183    16.898     0.150
    68.183  1192.250     0.150
    68.183   659.352     0.150
    68.183     8.898     0.150
    68.183    16.898     0.150
    68.183  1192.250     0.150
    68.183  1257.250     0.150
    77.584   705.250     0.150
    81.717   736.250     0.150
    84.034   748.250     0.150
    84.034     8.000     0.150
    84.034  1368.250     0.150
    86.603   764.250     0.150
    86.678   765.449     0.150
    90.179   777.250     0.150
    90.179   773.250     0.150
    90.153   777.250     0.150
    90.777   781.750     0.150
    90.777   781.750     0.150
    91.030   784.551     0.150
    91.114   783.250     0.150
    91.196   785.148     0.150
    91.196   942.250     0.150
    91.196   785.148     0.150
    91.929    19.500     0.150
    91.929   787.750     0.150
    91.929     9.500     0.150
    92.474   790.449     0.150
    92.474     5.801     0.150
    92.641   787.750     0.150
    92.641   856.250     0.150
    92.723   791.250     0.150
    93.573    10.301     0.150
    96.804   809.250     0.150
    97.649   829.551     0.150
    99.416   821.250     0.150
    99.416   821.250     0.150
   118.020  1132.551     0.150
   126.157  1137.250     0.150
   144.875  1262.449     0.150
    12.516   183.715     0.150
    12.638   361.215     0.150
    12.890   188.215     0.150
    13.991   395.715     0.150
    16.943   222.219     0.150
    18.818   257.715     0.150
    20.435   279.314     0.150
    22.666   307.115     0.150
    22.666  1001.215     0.150
    23.642   810.715     0.150
    23.642   989.715     0.150
    24.698     7.699     0.150
    24.791   807.715     0.150
    24.791   321.670     0.150
    24.985   325.215     0.150
    27.858   916.715     0.150
    29.952   367.215     0.150
    31.259   442.715     0.150
    31.259   636.715     0.150
    31.899   442.414     0.150
    35.132   408.715     0.150
    39.033   448.715     0.150
    39.754   453.715     0.150
    39.672   455.016     0.150
    40.010   455.715     0.150
    40.435   465.814     0.150
    40.714   466.516     0.150
    41.058   462.215     0.150
    41.420   467.914     0.150
    41.513   469.016     0.150
    48.807   527.414     0.150
    48.807     3.301     0.150
    51.495   552.715     0.150
    57.600  1015.016     0.150
    59.378   604.715     0.150
    59.378   822.715     0.150
    65.755   645.715     0.150
    67.856   657.414     0.150
    67.856  1196.715     0.150
    67.881  1426.715     0.150
    67.881  1669.715     0.150
    68.483   664.715     0.150
    68.483   670.016     0.150
    69.265   672.115     0.150
    69.265    15.301     0.150
    69.265   686.715     0.150
    69.265   692.914     0.150
    69.587   661.914     0.150
    69.951   678.516     0.150
    69.951    13.900     0.150
    70.549   675.314     0.150
    70.549    18.000     0.150
    71.134     1.801     0.150
    71.134   674.914     0.150
    71.134     1.801     0.150
    74.782   709.715     0.150
    74.782  1229.715     0.150
    74.782  1272.715     0.150
    74.782  1656.715     0.150
    74.782  1768.715     0.150
    77.659  1012.715     0.150
    77.659  1317.715     0.150
    77.659  1630.715     0.150
    80.366   730.715     0.150
    80.366  1339.715     0.150
    80.366  1396.715     0.150
    80.366  1842.715     0.150
    80.472   732.715     0.150
    80.472   912.715     0.150
    80.472  1338.715     0.150
    80.776   734.314     0.150
    80.887   733.715     0.150
    80.887  1026.715     0.150
    80.887  1342.715     0.150
    81.128   746.914     0.150
    81.589   899.715     0.150
    81.797   729.715     0.150
    82.181   740.314     0.150
    82.181   745.715     0.150
    82.181  1040.715     0.150
    82.181  1358.314     0.150
    82.181  1416.715     0.150
    82.181  1878.715     0.150
    82.709   742.715     0.150
    82.709  1362.314     0.150
    83.750   746.215     0.150
    83.750   750.715     0.150
    83.750   946.715     0.150
    83.750  1055.715     0.150
    83.750  1364.715     0.150
    83.750  1438.715     0.150
    84.790   790.715     0.150
    84.790  1022.715     0.150
    84.790  1452.715     0.150
    84.790  1521.715     0.150
    84.790  1732.715     0.150
    84.790  2052.715     0.150
    84.848   794.215     0.150
    85.279  1467.715     0.150
    85.279   755.785     0.150
    85.494   972.715     0.150
    85.055   762.965     0.150
    85.578   755.715     0.150
    85.716   782.215     0.150
    86.069  1745.715     0.150
    85.826   770.715     0.150
    85.826   787.715     0.150
    85.826   835.715     0.150
    86.576   838.715     0.150
    86.576  1080.715     0.150
    86.576  1966.715     0.150
    87.236   763.715     0.150
    88.182  1384.715     0.150
    88.182  1408.715     0.150
    88.198   923.715     0.150
    88.762   771.516     0.150
    88.762   773.516     0.150
    88.762  1410.715     0.150
    89.260  1797.715     0.150
    89.614   781.615     0.150
    89.832   777.314     0.150
    89.832   996.715     0.150
    90.123   778.016     0.150
    89.932   778.715     0.150
    89.932  1115.715     0.150
    90.375   778.715     0.150
    90.509   781.516     0.150
    90.824  1452.715     0.150
    90.824   780.715     0.150
    90.824   790.414     0.150
    90.824   997.715     0.150
    90.824  1412.715     0.150
    90.824  1452.715     0.150
    90.824  1512.715     0.150
    90.824  1812.715     0.150
    90.824   780.715     0.150
    90.824  1412.715     0.150
    91.073   781.715     0.150
    91.236   783.115     0.150
    91.236  1413.715     0.150
    91.970   942.715     0.150
    91.970  1006.715     0.150
    91.970  1094.715     0.150
    91.970   787.215     0.150
    91.970  1422.715     0.150
    91.970  1434.715     0.150
    92.250   787.715     0.150
    92.250  1131.715     0.150
    92.274   789.414     0.150
    92.274  1453.715     0.150
    92.767   790.715     0.150
    92.767  1010.715     0.150
    92.767  1426.715     0.150
    92.783   805.715     0.150
    93.502   790.715     0.150
    93.639     7.699     0.150
    93.635   793.715     0.150
    93.635   794.715     0.150
    93.635  1142.615     0.150
    93.635  1458.715     0.150
    94.604   950.715     0.150
    94.604  1018.715     0.150
    94.604  1446.715     0.150
    94.604  1826.715     0.150
    94.604  2082.715     0.150
    94.666  1561.715     0.150
    94.689   800.215     0.150
    94.689  1024.715     0.150
    94.689  1461.914     0.150
    94.804   802.715     0.150
    94.879   799.715     0.150
    94.879  1026.215     0.150
    95.590    16.500     0.150
    95.590  1450.715     0.150
    95.590   803.516     0.150
    95.590   805.516     0.150
    95.590  1036.715     0.150
    96.047   807.715     0.150
    96.047  1035.715     0.150
    96.047  1441.715     0.150
    96.134   808.715     0.150
    96.414   807.715     0.150
    96.033  1429.715     0.150
    96.033  1741.715     0.150
    96.033  1856.715     0.150
    96.033  2094.715     0.150
    96.033  2319.715     0.150
    96.630   808.715     0.150
    96.630   811.715     0.150
    97.216   820.715     0.150
    97.681   814.516     0.150
    97.681  1174.715     0.150
    97.807   813.715     0.150
    97.807  1183.715     0.150
    98.930   826.715     0.150
    99.246   819.715     0.150
    99.246  1186.715     0.150
    99.246  1512.715     0.150
    99.368   817.715     0.150
    99.368   817.715     0.150
    99.368  1190.715     0.150
    99.368  1512.715     0.150
    99.384  1432.715     0.150
   100.799   828.715     0.150
   100.799  1206.715     0.150
   100.799  1530.715     0.150
   101.170  1074.715     0.150
   101.422   838.516     0.150
   101.610   832.715     0.150
   102.065   831.715     0.150
   104.008   835.715     0.150
   104.044  1096.215     0.150
   104.044  1554.715     0.150
   104.092   842.715     0.150
   104.092   842.715     0.150
   104.092  1096.715     0.150
   104.092  1240.715     0.150
   105.402   853.814     0.150
   105.909  1661.715     0.150
   106.238  1106.715     0.150
   107.853  1261.215     0.150
   107.670   870.715     0.150
   107.670  1133.715     0.150
   107.670  1506.715     0.150
   107.670  1602.715     0.150
   107.670  1738.715     0.150
   107.670  1841.715     0.150
   107.670  2022.715     0.150
   107.670  2071.715     0.150
   107.670  2238.715     0.150
   107.670  2274.715     0.150
   107.670  2314.715     0.150
   107.670  2656.715     0.150
   107.670  2882.715     0.150
   108.383  1273.715     0.150
   108.081   854.215     0.150
   109.409   870.715     0.150
   109.409  1138.715     0.150
   109.735   864.715     0.150
   109.735  1144.715     0.150
   111.447   877.715     0.150
   111.447  1116.715     0.150
   112.460   877.715     0.150
   112.460  1306.715     0.150
   112.873   881.715     0.150
   112.873  1163.715     0.150
   113.434   883.715     0.150
   113.434  1811.715     0.150
   113.817   886.715     0.150
   113.826  1149.814     0.150
   113.865  1170.715     0.150
   113.865  1306.715     0.150
   114.960   891.715     0.150
   114.960  1822.715     0.150
   115.161  1181.715     0.150
   114.840   900.715     0.150
   114.840  1654.715     0.150
   115.068  1174.715     0.150
   115.922   894.715     0.150
   115.922  1331.715     0.150
   115.922  1842.715     0.150
   116.265  1186.715     0.150
   117.099   904.715     0.150
   117.496  1130.715     0.150
   118.317  1068.215     0.150
   118.317  1071.215     0.150
   118.317  1078.414     0.150
   118.805  1128.715     0.150
   118.882   915.414     0.150
   118.882  1355.715     0.150
   118.882  1865.715     0.150
   119.248  1360.715     0.150
   119.248  1874.715     0.150
   119.615  2451.016     0.150
   119.581   906.715     0.150
   119.581  1130.914     0.150
   119.581  1198.215     0.150
   119.581  1343.715     0.150
   119.733  1206.715     0.150
   119.912  1131.715     0.150
   119.979   917.516     0.150
   120.272   918.715     0.150
   120.272  1209.715     0.150
   120.272  1348.715     0.150
   120.372  1131.715     0.150
   120.909   953.715     0.150
   120.909  1284.715     0.150
   120.909  1362.715     0.150
   120.909  1574.715     0.150
   121.211  1217.914     0.150
   121.449  1134.715     0.150
   121.515  1131.715     0.150
   121.515  1373.715     0.150
   121.708  1219.715     0.150
   121.708  1384.814     0.150
   122.590  1222.715     0.150
   122.785  1227.516     0.150
   124.141  1144.715     0.150
   124.401  1129.715     0.150
   125.638   944.715     0.150
   125.638  1341.715     0.150
   125.655   946.715     0.150
   125.751   946.715     0.150
   125.842  1130.414     0.150
   125.842  1199.715     0.150
   125.842  1259.715     0.150
   125.842  1724.715     0.150
   125.842  1929.715     0.150
   127.000   950.715     0.150
   127.000  1257.715     0.150
   127.943  1149.914     0.150
   130.103  1354.715     0.150
   130.428  1149.314     0.150
   130.522  1157.715     0.150
   130.522  1158.516     0.150
   130.522  1297.715     0.150
   130.522  1468.715     0.150
   131.581  1162.715     0.150
   132.254  1234.715     0.150
   133.401  1145.715     0.150
   133.401  1478.715     0.150
   133.401  1914.715     0.150
   133.401  2376.715     0.150
   133.401  1145.715     0.150
   133.401  1302.715     0.150
   133.424  1309.516     0.150
   134.108  1152.715     0.150
   134.549  1149.215     0.150
   134.549  1289.215     0.150
   135.266  1154.715     0.150
   135.547  1154.615     0.150
   136.218  1328.715     0.150
   137.292  1398.715     0.150
   145.558  1437.715     0.150
   146.399  1174.715     0.150
   147.192  1260.115     0.150
   147.192  1341.615     0.150
   151.750  1618.715     0.150
   151.750  2026.715     0.150
   151.750  2184.715     0.150
     1.374    14.994     0.150
     1.299    46.994     0.150
     2.497    43.494     0.150
    18.067   253.994     0.150
    23.198   308.994     0.150
    25.096   320.994     0.150
    25.205   328.994     0.150
     2.209    32.021     0.150
     2.209   121.021     0.150
     4.004   126.521     0.150
    18.162   255.021     0.150
    18.894   263.621     0.150
    19.620   432.021     0.150
    20.815   277.021     0.150
    20.940   290.021     0.150
    25.159   325.521     0.150
    25.925   333.422     0.150
    27.888   347.322     0.150
    48.599   526.521     0.150
    48.796   521.422     0.150
   148.466  1177.021     0.150
     3.675   106.326     0.150
     4.078   114.826     0.150
     4.084   113.326     0.150
     4.137   119.326     0.150
     4.826   142.326     0.150
     6.405   121.826     0.150
    23.896   311.326     0.150
    59.539   610.525     0.150
    85.415   750.926     0.150
     2.722    45.977     0.150
    13.606   372.176     0.150
    18.490   258.176     0.150
    21.161    43.000     0.150
    22.302   727.576     0.150
    24.305   590.176     0.150
    24.387 -2794.523     0.150
    25.152   326.018     0.150
    26.120   629.977     0.150
    26.132   631.176     0.150
    28.215   554.875     0.150
    29.666   682.176     0.150
    34.808   406.176     0.150
    35.503   430.176     0.150
    39.289   456.176     0.150
    40.320   462.676     0.150
    46.069   512.176     0.150
    59.460 -2774.824     0.150
    59.460 -2229.824     0.150
    59.460 -2124.824     0.150
    59.460 -1874.824     0.150
    67.696 -2404.824     0.150
    68.178   660.676     0.150
    68.178   909.176     0.150
    68.178  1203.176     0.150
    68.178  1645.176     0.150
    68.874   692.076     0.150
    68.874   698.275     0.150
    68.874   725.076     0.150
    68.874   735.977     0.150
    70.991   660.375     0.150
    80.701   733.176     0.150
    80.701  1341.176     0.150
    80.842   733.176     0.150
    80.842  1344.176     0.150
    81.068   735.676     0.150
    81.730   740.176     0.150
    82.437   743.375     0.150
    82.526  1359.176     0.150
    82.526  1425.176     0.150
    82.615   744.477     0.150
    84.031   749.176     0.150
    84.031   755.176     0.150
    84.031  1379.176     0.150
    85.144  1473.176     0.150
    85.144  1735.176     0.150
    85.377   760.676     0.150
    85.431   754.977     0.150
    86.534   961.176     0.150
    87.052   769.176     0.150
    87.557   766.176     0.150
    88.668 -2622.824     0.150
    88.668 -2192.824     0.150
    88.864  1412.176     0.150
    90.148   779.977     0.150
    90.148   999.676     0.150
    90.148  1437.176     0.150
    90.186   778.775     0.150
    90.787   995.176     0.150
    90.787   782.176     0.150
    90.787   790.176     0.150
    90.787   995.176     0.150
    90.787  1425.176     0.150
    90.787  1517.176     0.150
    90.787   782.176     0.150
    91.041   785.576     0.150
    91.122   783.775     0.150
    91.206   783.875     0.150
    91.206  1417.176     0.150
    91.939   787.576     0.150
    91.939  1425.176     0.150
    92.474   790.477     0.150
    92.474  1458.176     0.150
    92.648  1455.176     0.150
    92.733   791.676     0.150
    93.693   795.176     0.150
    93.693  1143.176     0.150
    93.693  1462.176     0.150
    94.543  1021.176     0.150
    94.543  1445.176     0.150
    94.543  1861.176     0.150
    94.543  2113.176     0.150
    95.570  1029.176     0.150
    95.570  1453.176     0.150
    95.570   804.775     0.150
    95.570     6.100     0.150
    96.440   808.176     0.150
    96.440  1045.176     0.150
    96.440  1477.176     0.150
    96.593   810.176     0.150
    96.593     6.000     0.150
    97.659   818.676     0.150
    99.307   821.176     0.150
    99.423   822.176     0.150
    99.423   822.176     0.150
   100.927  1515.176     0.150
   110.825  1129.176     0.150
   110.825  1129.176     0.150
   112.501  1124.176     0.150
   112.501  1124.176     0.150
   114.993  1140.176     0.150
   119.146  1120.176     0.150
   120.530  1146.176     0.150
   120.530  1146.676     0.150
   130.454  1275.176     0.150
   130.454  1283.176     0.150
   144.792  1545.176     0.150
   147.586  1209.275     0.150
    16.623    17.500     0.150
    17.088   252.350     0.150
    17.088   260.850     0.150
    17.899   269.949     0.150
    21.141    16.500     0.150
    21.175    17.000     0.150
    23.991   328.148     0.150
    23.991   335.148     0.150
    24.794    16.801     0.150
    24.856 -3060.451     0.150
    25.085   334.049     0.150
    25.145    17.000     0.150
    27.846   341.850     0.150
    31.085   367.049     0.150
    48.640   537.049     0.150
    68.778   677.549     0.150
    17.758   249.016     0.150
    21.695   287.016     0.150
    26.189   331.516     0.150
    39.790   448.016     0.150
    67.480   668.016     0.150
    67.480   653.016     0.150
    67.480    11.000     0.150
    67.480   668.016     0.150
    81.805   747.016     0.150
    81.805   735.016     0.150
    81.805   747.016     0.150
    85.183   751.016     0.150
    89.455   773.316     0.150
    90.641   777.016     0.150
    90.823   781.016     0.150
    91.900   784.414     0.150
    96.077   800.414     0.150
   126.393  1123.516     0.150
   134.220  1143.016     0.150
   144.228  1182.016     0.150
   149.585  1276.016     0.150
     2.783    43.531     0.150
     2.783   109.031     0.150
     2.821    49.031     0.150
     5.548   155.031     0.150
    16.942   255.531     0.150
    17.448   257.328     0.150
    18.429   256.031     0.150
    19.213   268.031     0.150
    19.891   290.031     0.150
    21.848    15.102     0.150
    24.296   334.430     0.150
    25.112    18.000     0.150
    48.169   513.031     0.150
    50.313   535.031     0.150
    68.610   658.234     0.150
    68.610   673.430     0.150
    89.739   772.031     0.150
     2.988    77.850     0.150
     5.699   159.460     0.150
    18.411   255.850     0.150
    19.832   266.350     0.150
    21.103   286.850     0.150
    22.449   294.850     0.150
    23.562    11.500     0.150
    24.750    10.400     0.150
    48.427   508.850     0.150
    69.652   663.750     0.150
    84.366   760.350     0.150
    85.224   751.850     0.150
    85.378   762.850     0.150
    86.110   756.850     0.150
    90.476   777.850     0.150
    90.730    21.000     0.150
    95.205   801.750     0.150
    95.430   802.630     0.150
   137.551  1165.350     0.150
   144.565  1182.850     0.150
   145.923  1189.350     0.150
   151.869  1205.149     0.150
     2.415    74.051     0.150
     3.742   109.051     0.150
     3.930   114.551     0.150
     4.055   113.551     0.150
     4.194   121.551     0.150
     4.996    61.051     0.150
     6.796   107.051     0.150
    16.235   242.750     0.150
    21.139   285.250     0.150
    21.879   292.051     0.150
    23.068   301.150     0.150
    23.745    14.801     0.150
    25.004   321.750     0.150
    35.836   427.551     0.150
    53.191   552.250     0.150
    94.418   808.211     0.150
     2.340    30.413     0.150
     2.340    54.613     0.150
     4.010    65.613     0.150
     6.607   100.613     0.150
    19.274   752.713     0.150
    23.482     8.500     0.150
    23.559     8.000     0.150
    24.868   312.613     0.150
    44.838   488.713     0.150
    44.838   591.113     0.150
    44.838   488.713     0.150
    44.838   497.113     0.150
    44.838    21.500     0.150
    44.838   591.413     0.150
    44.838   597.713     0.150
    44.838   618.113     0.150
    44.838   628.613     0.150
    54.753   565.213     0.150
    54.763   573.213     0.150
    64.743   757.413     0.150
    67.343     6.800     0.150
    71.040   672.713     0.150
    79.579   725.613     0.150
    79.875   727.613     0.150
    85.410  1607.013     0.150
    85.410  1929.313     0.150
    85.410  2122.313     0.150
    86.818   792.613     0.150
    86.859   759.613     0.150
    87.814   764.913     0.150
    91.047   780.013     0.150
    91.193   780.613     0.150
    94.213   795.813     0.150
   144.448  4718.113     0.150
   147.034  1182.313     0.150
     0.926    32.223     0.150
     1.273    41.223     0.150
     4.200    63.922     0.150
    22.334   304.852     0.150
    24.979   313.434     0.150
    35.838   417.723     0.150
    40.750   468.723     0.150
    41.716   459.223     0.150
    44.697   486.223     0.150
    48.922   533.723     0.150
    51.543   547.723     0.150
    56.251   587.184     0.150
    57.199   594.863     0.150
    85.089    19.398     0.150
    92.606   785.324     0.150
   126.018  1150.922     0.150
   144.287  1182.223     0.150
     0.194    25.305     0.150
     0.572    34.805     0.150
     0.795    36.805     0.150
     1.551    24.305     0.150
     1.551    43.602     0.150
     1.748    40.305     0.150
     1.748    77.805     0.150
     2.247    72.305     0.150
     4.083   115.805     0.150
     4.125    65.305     0.150
     4.125   115.305     0.150
     6.747   101.805     0.150
     6.753   182.305     0.150
    14.670   206.523     0.150
    19.468   260.367     0.150
    19.468   281.516     0.150
    19.957    20.719     0.150
    20.565   293.711     0.150
    20.970    18.672     0.150
    21.124    22.680     0.150
    21.560    20.859     0.150
    22.236    20.180     0.150
    22.352    20.477     0.150
    22.345    20.500     0.150
    22.474    20.703     0.150
    22.870    20.305     0.150
    23.202    20.859     0.150
    23.541   306.695     0.150
    23.541    19.133     0.150
    23.686    30.367     0.150
    23.922    21.117     0.150
    23.905    21.188     0.150
    24.050    21.250     0.150
    23.987    21.953     0.150
    24.117    20.797     0.150
    24.101   308.148     0.150
    24.101    23.477     0.150
    24.830    20.758     0.150
    24.865    21.266     0.150
    24.861    21.984     0.150
    24.861    30.578     0.150
    25.230    21.148     0.150
    25.287   319.484     0.150
    25.287    21.344     0.150
    25.287    30.758     0.150
    25.414    22.742     0.150
    31.096   372.805     0.150
    31.640   376.906     0.150
    34.490   389.805     0.150
    34.683   393.305     0.150
    40.173   450.305     0.150
    41.517   461.805     0.150
    41.892   460.961     0.150
    49.674   528.508     0.150
    52.972   547.617     0.150
    54.401   561.805     0.150
    56.437   644.648     0.150
    64.616   632.008     0.150
    64.616   634.305     0.150
    64.616   649.008     0.150
    64.616    42.695     0.150
    64.703   633.008     0.150
    64.703   653.805     0.150
    64.703    25.797     0.150
    64.703    37.500     0.150
    70.785   680.203     0.150
    84.600   736.805     0.150
    89.363   768.305     0.150
    90.244   771.305     0.150
    90.642   772.805     0.150
    92.345   798.102     0.150
    94.583  1040.602     0.150
    98.622   827.805     0.150
    98.622   938.805     0.150
   125.731  1135.805     0.150
   135.004  1144.805     0.150
   146.340  1175.406     0.150
     0.965    36.859     0.150
     1.126    35.859     0.150
     3.660   100.859     0.150
     4.571    64.559     0.150
     5.766    89.938     0.150
    15.193   214.098     0.150
    15.193    13.082     0.150
    15.193   500.559     0.150
    15.193   509.121     0.150
    16.525    12.859     0.150
    16.525   231.258     0.150
    16.629    10.934     0.150
    16.629   526.020     0.150
    17.668   242.969     0.150
    21.122   282.059     0.150
    23.361   313.379     0.150
    24.670   314.348     0.150
    27.428   340.758     0.150
    32.181   384.461     0.150
    40.456   450.668     0.150
    40.717   458.359     0.150
    41.907   467.359     0.150
    44.564   485.160     0.150
    54.033   571.660     0.150
    54.854   565.758     0.150
    54.854   627.559     0.150
    64.313   642.758     0.150
    67.402   651.660     0.150
    67.402    14.199     0.150
    67.583   654.859     0.150
    80.620   727.859     0.150
    81.720   734.859     0.150
    81.720    16.000     0.150
    83.316   741.461     0.150
    83.316    16.398     0.150
    89.866   775.160     0.150
    90.335   775.160     0.150
    90.672    20.000     0.150
    90.672   777.859     0.150
    90.672    20.000     0.150
    91.811   783.859     0.150
    91.811    12.000     0.150
    91.855   782.859     0.150
    91.855    14.000     0.150
    92.768   787.059     0.150
    97.794   809.559     0.150
    99.120   815.859     0.150
     1.706    56.621     0.150
     2.073    35.422     0.150
     2.633    67.820     0.150
     3.420    53.223     0.150
    16.858   232.020     0.150
    18.592   260.223     0.150
    18.771   258.223     0.150
    21.358   282.621     0.150
    22.378   312.582     0.150
    22.378   294.723     0.150
    22.378    17.797     0.150
    23.539   324.902     0.150
    23.539   305.320     0.150
    23.539    19.500     0.150
    23.604    18.699     0.150
    23.604    18.598     0.150
    23.622    18.699     0.150
    23.622    18.598     0.150
    23.675    19.801     0.150
    24.047   302.340     0.150
    24.047    12.000     0.150
    24.047    27.043     0.150
    24.047   581.340     0.150
    24.095   331.422     0.150
    24.272   332.371     0.150
    24.272   313.320     0.150
    24.272    19.000     0.150
    25.031    17.598     0.150
    25.145    12.102     0.150
    25.145    19.152     0.150
    25.145   320.121     0.150
    25.145    19.102     0.150
    25.339    19.582     0.150
    25.376    19.152     0.150
    25.376   322.820     0.150
    25.376    19.199     0.150
    25.431    14.270     0.150
    25.431   323.121     0.150
    25.431    14.301     0.150
    25.647   323.820     0.150
    26.758   331.223     0.150
    26.839   329.410     0.150
    26.842    12.551     0.150
    26.842   336.922     0.150
    26.842    18.500     0.150
    27.472   341.621     0.150
    27.472    19.102     0.150
    28.133   342.109     0.150
    28.353    19.469     0.150
    28.589    20.160     0.150
    30.763   386.121     0.150
    34.472   401.180     0.150
    39.267   449.121     0.150
    46.031   513.121     0.150
    48.149    13.199     0.150
    50.283   543.422     0.150
    53.890    14.059     0.150
    55.395   567.922     0.150
    56.644    13.953     0.150
    59.497   611.121     0.150
    62.314    13.301     0.150
    63.245   632.520     0.150
    81.742   733.422     0.150
    82.562   730.121     0.150
    82.562   730.223     0.150
    82.562  1437.723     0.150
    84.341  1395.121     0.150
    88.352  1401.820     0.150
    89.623   769.922     0.150
    89.928   773.121     0.150
    90.037    14.699     0.150
    90.114   773.422     0.150
    90.114    26.898     0.150
    90.114  1432.121     0.150
    90.114  1492.121     0.150
    90.114  1788.121     0.150
    90.364   783.723     0.150
    90.536   774.922     0.150
    91.976   781.121     0.150
    91.976    26.500     0.150
    92.061   782.320     0.150
    92.061    26.199     0.150
    92.627   785.121     0.150
    94.870    15.801     0.150
    95.471    22.000     0.150
    96.993   804.621     0.150
    96.993    19.801     0.150
    98.287   808.922     0.150
    98.806   811.621     0.150
    98.806   839.121     0.150
   110.098   881.121     0.150
   110.098   881.723     0.150
     2.652    66.178     0.150
    17.648   245.916     0.150
    17.964   265.678     0.150
    18.316   246.576     0.150
    20.555    19.709     0.150
    20.789    21.119     0.150
    21.385   302.207     0.150
    21.511    20.420     0.150
    22.060   309.768     0.150
    22.863    22.799     0.150
    22.878    21.301     0.150
    23.743    22.740     0.150
    23.950    22.801     0.150
    23.950    21.121     0.150
    24.094    21.049     0.150
    24.879    22.658     0.150
    24.779    23.320     0.150
    25.301    21.881     0.150
    69.472   664.307     0.150
    85.069   754.777     0.150
    92.316   778.977     0.150
   130.923  1137.977     0.150
   132.312  1145.166     0.150
     3.237    89.562     0.150
     3.279    92.266     0.150
     3.705   105.266     0.150
    17.037   234.164     0.150
    19.103   262.398     0.150
    20.851   281.469     0.150
    21.027   282.930     0.150
    21.231   284.820     0.150
    21.659   287.562     0.150
    22.296   296.461     0.150
    25.078   322.531     0.150
    29.659   368.062     0.150
    31.069   373.398     0.150
    31.091   359.062     0.150
    31.978   385.734     0.150
    32.363   388.750     0.150
    32.554   389.789     0.150
    39.367   449.562     0.150
    40.092   457.516     0.150
    40.768   458.805     0.150
    46.150   502.195     0.150
    51.790   547.562     0.150
    53.763   559.562     0.150
    54.143   561.664     0.150
    56.660   579.062     0.150
    57.013   583.359     0.150
    57.609   585.664     0.150
    59.139   596.297     0.150
    59.278   593.359     0.150
    60.238   776.461     0.150
    66.001   642.766     0.150
    66.343   643.625     0.150
    67.505   657.359     0.150
    67.829     3.703     0.150
    68.078   663.562     0.150
    68.078  1209.062     0.150
    68.078   658.961     0.150
    68.969   667.859     0.150
    69.047  1695.562     0.150
    69.183   667.461     0.150
    69.183  1493.859     0.150
    70.765   677.461     0.150
    70.765  1724.461     0.150
    71.143   673.664     0.150
    71.202   680.250     0.150
    71.202   683.250     0.150
    76.938   709.766     0.150
    77.541    39.797     0.150
    77.541   993.062     0.150
    77.541  1313.062     0.150
    77.541  1573.062     0.150
    80.659   729.648     0.150
    80.708   732.062     0.150
    80.708    11.000     0.150
    80.708   919.062     0.150
    80.708  1337.062     0.150
    81.705   737.859     0.150
    81.705   188.203     0.150
    82.567   738.664     0.150
    82.557  1044.266     0.150
    82.557  1417.359     0.150
    82.557   740.461     0.150
    82.557    16.398     0.150
    82.557  1044.266     0.150
    82.557  1350.859     0.150
    82.557  1417.359     0.150
    82.950  1439.062     0.150
    82.950   741.062     0.150
    82.950    16.000     0.150
    82.950   941.062     0.150
    82.950  1359.062     0.150
    82.950  1439.062     0.150
    83.576   745.266     0.150
    83.848   746.859     0.150
    83.921     7.867     0.150
    83.991     6.820     0.150
    84.350   749.062     0.150
    84.609   208.047     0.150
    84.733   751.062     0.150
    84.786   751.859     0.150
    84.901   752.062     0.150
    85.176   754.359     0.150
    85.317   764.820     0.150
    85.445   754.062     0.150
    85.880   757.062     0.150
    86.225   758.461     0.150
    86.632  2329.664     0.150
    86.638   760.062     0.150
    86.665   761.164     0.150
    87.089   762.062     0.150
    87.442   764.859     0.150
    87.468   764.266     0.150
    87.474  1344.062     0.150
    87.512   764.062     0.150
    87.965   767.664     0.150
    88.026   757.062     0.150
    88.070   763.062     0.150
    88.240   769.461     0.150
    88.596   988.062     0.150
    88.596  1355.062     0.150
    88.596   770.062     0.150
    88.670   770.859     0.150
    88.822   983.461     0.150
    88.822   770.000     0.150
    88.822   770.062     0.150
    88.822   983.461     0.150
    88.877   769.641     0.150
    89.081   772.766     0.150
    89.153   771.891     0.150
    89.299   773.062     0.150
    89.511   771.062     0.150
    89.622   772.859     0.150
    89.622   772.859     0.150
    90.012   776.359     0.150
    90.102   779.062     0.150
    90.127   778.664     0.150
    90.264   776.922     0.150
    90.433   778.859     0.150
    90.664   774.859     0.150
    90.671   782.062     0.150
    90.725    20.406     0.150
    90.725   819.062     0.150
    90.725  1001.062     0.150
    90.725   779.422     0.150
    90.725   779.359     0.150
    90.725    20.406     0.150
    90.725   819.062     0.150
    90.725  1001.062     0.150
    90.725  2013.062     0.150
    90.725   779.359     0.150
    90.725  1001.062     0.150
    90.980   999.766     0.150
    90.980  1040.664     0.150
    90.980   781.016     0.150
    90.980   780.961     0.150
    90.980   999.766     0.150
    91.040   780.766     0.150
    91.074   781.062     0.150
    91.084   781.062     0.150
    91.142   780.914     0.150
    91.142   780.961     0.150
    91.142   787.859     0.150
    91.142   799.062     0.150
    91.142   811.062     0.150
    91.142  1036.062     0.150
    91.142  1089.062     0.150
    91.142  1370.062     0.150
    91.142  1412.062     0.150
    91.142  1456.062     0.150
    91.142  1781.062     0.150
    91.142  1873.062     0.150
    91.142  2019.062     0.150
    91.142  2317.062     0.150
    91.142  2329.062     0.150
    91.142  2594.062     0.150
    91.142   780.961     0.150
    91.142  1412.062     0.150
    91.252   779.461     0.150
    91.372   781.859     0.150
    91.450   783.062     0.150
    91.769   784.562     0.150
    92.074    19.203     0.150
    92.198    20.797     0.150
    92.198   954.961     0.150
    92.252   786.469     0.150
    92.358    20.695     0.150
    92.429    16.797     0.150
    92.429   947.359     0.150
    92.515   788.766     0.150
    92.515    13.500     0.150
    92.515  1011.062     0.150
    92.515  1419.062     0.150
    92.515  1449.062     0.150
    92.515  1531.062     0.150
    92.567   794.062     0.150
    92.567  1013.062     0.150
    92.578   788.961     0.150
    92.591    19.500     0.150
    92.591   823.062     0.150
    92.591   787.562     0.150
    92.591  1007.062     0.150
    92.591  1421.062     0.150
    92.670   794.461     0.150
    92.670   787.984     0.150
    92.670   788.062     0.150
    92.670   794.461     0.150
    92.670  1009.062     0.150
    92.670  1419.062     0.150
    92.670  1448.664     0.150
    92.670  1532.062     0.150
    92.810  1019.266     0.150
    93.045   790.461     0.150
    93.070   790.062     0.150
    93.373   792.062     0.150
    93.604   792.062     0.150
    93.604    13.000     0.150
    93.604  1015.062     0.150
    93.604  1425.062     0.150
    93.604  1456.062     0.150
    93.604  1537.062     0.150
    94.236   796.562     0.150
    94.396   797.266     0.150
    94.488   797.766     0.150
    94.575  1031.062     0.150
    94.638   790.062     0.150
    94.638  1439.062     0.150
    94.692   802.164     0.150
    94.692   837.359     0.150
    94.692  2322.164     0.150
    94.727  1440.062     0.150
    94.758   799.961     0.150
    95.166   800.062     0.150
    95.332  1443.062     0.150
    95.528   801.266     0.150
    95.868   803.664     0.150
    96.003   820.359     0.150
    96.072  1039.961     0.150
    96.359   805.062     0.150
    96.359  1881.062     0.150
    96.530   810.062     0.150
    96.530   835.062     0.150
    96.530   851.062     0.150
    96.530   855.062     0.150
    96.530   882.062     0.150
    96.750   834.562     0.150
    97.244   816.961     0.150
    97.378   818.664     0.150
    97.651   816.961     0.150
    98.161   813.859     0.150
    98.266   822.062     0.150
    98.407   813.562     0.150
    98.780   822.859     0.150
    99.217  1057.062     0.150
    99.217  1185.062     0.150
    99.217  1603.062     0.150
    99.217  1639.062     0.150
    99.217   817.062     0.150
    99.217  1057.062     0.150
    99.217  1185.062     0.150
    99.217  1447.062     0.150
    99.217  1603.062     0.150
    99.217  1639.062     0.150
    99.217  1915.062     0.150
    99.311   820.164     0.150
    99.335   846.062     0.150
    99.335   880.062     0.150
    99.335  1063.062     0.150
    99.335  1195.062     0.150
    99.335  1671.062     0.150
    99.335  1943.062     0.150
    99.335  2173.062     0.150
    99.335   817.961     0.150
    99.335  1063.062     0.150
    99.335  1195.062     0.150
    99.335  1452.062     0.150
    99.335  1601.062     0.150
    99.607   819.219     0.150
    99.657   829.062     0.150
    99.721   811.266     0.150
    99.721  1148.266     0.150
    99.763   822.766     0.150
    99.816   824.766     0.150
   101.176   848.062     0.150
   101.176   987.062     0.150
   101.176  1564.062     0.150
   101.176  1832.062     0.150
   101.176  1961.062     0.150
   101.176  2243.062     0.150
   101.199   837.164     0.150
   101.301  1006.562     0.150
   101.301  1035.062     0.150
   101.517   829.070     0.150
   101.847   845.281     0.150
   101.936   848.562     0.150
   101.985   830.062     0.150
   101.985  1463.062     0.150
   101.985  1632.062     0.150
   102.215   835.062     0.150
   102.245   835.359     0.150
   102.245  1017.859     0.150
   102.365   838.961     0.150
   102.538   852.961     0.150
   102.937   853.242     0.150
   103.019   841.562     0.150
   103.280   841.062     0.150
   103.299   840.062     0.150
   103.299  1099.062     0.150
   103.488   842.961     0.150
   104.078  1226.062     0.150
   104.078   839.062     0.150
   104.078  1096.062     0.150
   104.078  1226.062     0.150
   104.078  1478.062     0.150
   104.078  1653.062     0.150
   104.120   840.062     0.150
   104.120  1100.062     0.150
   104.176   842.062     0.150
   104.556   847.844     0.150
   106.035  2025.062     0.150
   106.035   849.062     0.150
   106.035  1115.062     0.150
   106.035  1489.062     0.150
   106.035  1673.062     0.150
   106.035  2025.062     0.150
   106.069  1255.062     0.150
   106.069  1732.062     0.150
   106.069   852.062     0.150
   106.069  1114.062     0.150
   106.069  1255.062     0.150
   106.069  1482.062     0.150
   106.069  1659.062     0.150
   106.160   863.766     0.150
   106.532   856.062     0.150
   106.532  1120.062     0.150
   107.158  1263.062     0.150
   107.158   853.062     0.150
   107.158  1115.062     0.150
   107.158  1263.062     0.150
   107.158  1491.062     0.150
   107.158  1677.062     0.150
   107.696   860.062     0.150
   107.696  2049.062     0.150
   107.696   860.062     0.150
   107.696  1123.062     0.150
   107.696  1495.062     0.150
   107.696  1685.062     0.150
   107.696  2049.062     0.150
   108.014  2053.062     0.150
   108.014   861.062     0.150
   108.014  2053.062     0.150
   108.701  1133.062     0.150
   109.673   868.062     0.150
   109.673   868.062     0.150
   109.673  1139.062     0.150
   109.673  1501.062     0.150
   109.673  1707.062     0.150
   110.653   870.859     0.150
   110.653  1509.164     0.150
   110.653  1719.664     0.150
   110.653  2084.562     0.150
   110.743  1491.062     0.150
   110.743   875.062     0.150
   111.664   879.062     0.150
   111.664  1116.062     0.150
   112.045  1120.062     0.150
   112.116  1299.062     0.150
   112.116   875.062     0.150
   112.116  1155.062     0.150
   112.116  1299.062     0.150
   112.902   899.062     0.150
   112.902  1747.062     0.150
   112.902  2073.062     0.150
   112.902  2362.062     0.150
   113.192  1109.062     0.150
   113.192  1109.062     0.150
   113.343  1088.062     0.150
   113.343  1103.062     0.150
   113.343  1124.062     0.150
   113.343  1201.062     0.150
   113.343  1254.062     0.150
   113.343  1794.062     0.150
   113.942  1121.961     0.150
   114.535  1121.359     0.150
   115.242  1124.664     0.150
   117.624   905.062     0.150
   118.978  1127.062     0.150
   118.978  1127.062     0.150
   118.924  1871.062     0.150
   118.924  1127.562     0.150
   118.924  1207.062     0.150
   118.924  1783.062     0.150
   118.924  1871.062     0.150
   118.924  2176.062     0.150
   119.318   915.062     0.150
   119.318   915.062     0.150
   119.318  1215.062     0.150
   119.318  1551.062     0.150
   119.817   907.062     0.150
   119.946  1191.562     0.150
   120.465   910.062     0.150
   120.465  1129.062     0.150
   120.494  1133.062     0.150
   124.051  1731.164     0.150
   125.889  1144.062     0.150
   126.044  1145.859     0.150
   126.105  1125.562     0.150
   126.105  1718.766     0.150
   126.116  1124.664     0.150
   126.116  1710.664     0.150
   126.573  1129.562     0.150
   126.923  1142.062     0.150
   126.959  1118.266     0.150
   126.959  1706.062     0.150
   126.961  1127.062     0.150
   126.961  1718.562     0.150
   127.135  1146.461     0.150
   129.688  1349.266     0.150
   129.688  1938.062     0.150
   130.318   961.062     0.150
   130.318  1279.062     0.150
   131.068  1154.461     0.150
   133.482  1134.062     0.150
   133.663  1156.070     0.150
   133.673  1144.461     0.150
   133.715  1155.820     0.150
   133.964  1156.273     0.150
   134.236  1164.062     0.150
   134.236  1390.859     0.150
   137.759  1151.664     0.150
   137.811  1150.766     0.150
   138.802  1181.062     0.150
   143.955  2475.062     0.150
   144.669  1025.062     0.150
   144.669  1174.062     0.150
   144.669  1197.062     0.150
   144.669  1207.062     0.150
   144.669  1567.062     0.150
   144.669  1987.062     0.150
   144.669  2125.062     0.150
   144.669  2813.062     0.150
   144.772  1172.062     0.150
   144.772  1433.062     0.150
   144.993  1180.461     0.150
   145.816  1181.062     0.150
     1.421    40.589     0.150
     1.744    53.089     0.150
     5.956    59.388     0.150
    24.394   312.789     0.150
    68.970   675.388     0.150
     1.895    35.093     0.150
     2.512    65.493     0.150
     3.935    64.953     0.150
     4.158    71.123     0.150
     6.313   105.193     0.150
    21.213   286.793     0.150
    21.138   286.500     0.150
    25.321   546.297     0.150
    25.585   329.828     0.150
    28.859   546.398     0.150
    28.859   557.203     0.150
    45.053   604.297     0.150
    45.174   603.398     0.150
    45.793   606.703     0.150
    53.898   560.297     0.150
    55.209   629.500     0.150
    55.209   640.000     0.150
    66.153   643.328     0.150
    68.037   654.930     0.150
    68.037   747.930     0.150
    68.037   827.328     0.150
    80.854   733.500     0.150
    81.598   734.297     0.150
    81.619   746.500     0.150
    82.034   736.102     0.150
    82.274   750.000     0.150
    82.690   741.797     0.150
    82.690    10.305     0.150
    82.690   939.898     0.150
    82.690  1363.703     0.150
    82.690  1677.500     0.150
    84.555   849.500     0.150
    85.859   758.398     0.150
    86.164   759.383     0.150
    86.585   771.203     0.150
    86.598   771.398     0.150
    87.382   763.477     0.150
    87.429  2174.531     0.150
    87.560   768.000     0.150
    88.033   769.789     0.150
    88.569   780.703     0.150
    88.569   780.703     0.150
    88.641   780.602     0.150
    88.842   773.500     0.150
    88.842   773.500     0.150
    89.012   769.148     0.150
    89.109   773.898     0.150
    89.109     9.203     0.150
    90.131   778.703     0.150
    90.131     7.797     0.150
    90.602   781.398     0.150
    90.684   781.703     0.150
    90.684     8.695     0.150
    90.684   781.703     0.150
    90.684     8.695     0.150
    90.937   782.602     0.150
    90.937     9.500     0.150
    91.104    17.000     0.150
    91.104   782.500     0.150
    91.104     9.102     0.150
    91.104   799.500     0.150
    91.837   787.203     0.150
    91.837     8.594     0.150
    92.026     9.695     0.150
    92.149     9.500     0.150
    92.256   796.938     0.150
    92.310     9.500     0.150
    92.381     8.500     0.150
    92.549   816.500     0.150
    92.549   789.500     0.150
    92.549     9.000     0.150
    92.663   791.500     0.150
    92.663     8.398     0.150
    92.631   790.898     0.150
    92.631   790.898     0.150
    92.631     8.102     0.150
    92.631    12.602     0.150
    93.610     9.906     0.150
    95.944   813.703     0.150
    96.146   800.398     0.150
    96.712   839.102     0.150
    98.100   823.000     0.150
    98.519   815.500     0.150
    99.333   819.500     0.150
    99.333   829.500     0.150
   101.248   839.297     0.150
   101.481   826.500     0.150
   107.231   856.797     0.150
   107.231  1120.703     0.150
   117.354  1132.500     0.150
   117.711  1203.898     0.150
   120.589  1146.500     0.150
   122.726  1387.500     0.150
   122.726  1640.500     0.150
   126.258  1127.703     0.150
   127.093  1128.203     0.150
   127.096  1143.500     0.150
   137.948  1152.000     0.150
   144.941  1247.500     0.150
    10.394   142.875     0.150
    25.376     8.629     0.150
    25.482   546.285     0.150
   120.838  1116.086     0.150
   127.100  1127.484     0.150
   131.421  1137.586     0.150
   138.106  1155.688     0.150
   148.703  1187.586     0.150
    12.835   189.024     0.150
    15.545   220.435     0.150
    16.214    20.209     0.150
    16.214    28.627     0.150
    20.980   277.354     0.150
    21.463    19.200     0.150
    21.821     6.510     0.150
    22.508    18.551     0.150
    22.759    19.210     0.150
    23.709    19.510     0.150
    23.895   300.274     0.150
    25.101    19.301     0.150
    25.202    20.061     0.150
    25.187    18.120     0.150
    25.394    19.529     0.150
    25.826    19.609     0.150
    26.284    19.260     0.150
    26.317    19.040     0.150
    26.727    19.780     0.150
    26.851    19.400     0.150
    26.983    20.300     0.150
    27.782    18.881     0.150
    27.895    18.700     0.150
    28.577    19.399     0.150
    28.605    19.370     0.150
    29.110    18.860     0.150
    30.460    19.480     0.150
    30.526   367.755     0.150
    31.376    19.530     0.150
    32.699    18.641     0.150
    56.746    18.790     0.150
    57.315    18.630     0.150
    70.446   654.524     0.150
    81.703   723.364     0.150
    87.935   760.425     0.150
    89.167   767.064     0.150
   117.708  1119.009     0.150
   126.910  1136.425     0.150
   136.963  1157.824     0.150
     3.358    95.781     0.150
     3.566    99.664     0.150
    10.435   157.438     0.150
    16.422   233.539     0.150
    16.422   247.148     0.150
    16.872   248.227     0.150
    18.211   252.094     0.150
    24.340   318.406     0.150
    24.411    12.352     0.150
    24.411   547.391     0.150
    25.241     9.695     0.150
    25.241   547.141     0.150
    25.907   331.070     0.150
    27.346   343.578     0.150
    32.479   564.500     0.150
    45.086   604.336     0.150
    82.643  1428.539     0.150
    83.369     6.898     0.150
    83.636     6.461     0.150
    88.885   774.625     0.150
    90.907   778.734     0.150
    92.502   789.938     0.150
    97.385  1041.312     0.150
    99.210  1188.641     0.150
   127.201  1135.539     0.150
   137.905  1154.141     0.150
   144.641  1183.438     0.150
   144.641  1201.438     0.150
     1.468    22.729     0.150
     2.476    72.359     0.150
     3.326    68.289     0.150
     3.759    64.359     0.150
     3.817   115.709     0.150
     3.904    65.359     0.150
     3.957    65.809     0.150
     4.468   130.568     0.150
    11.289   359.551     0.150
    18.972   268.629     0.150
    24.294   314.439     0.150
    24.308   317.760     0.150
    58.243   593.617     0.150
    73.675    19.301     0.150
    80.616   731.289     0.150
    87.133   765.590     0.150
    90.850   784.289     0.150
    90.850   784.289     0.150
    99.455   827.391     0.150
     4.438    71.664     0.150
     5.675   159.766     0.150
    10.672   319.812     0.150
    17.995   255.445     0.150
    29.186   361.836     0.150
     2.045    60.609     0.150
    12.018   177.352     0.150
    12.065   423.559     0.150
    19.865   275.910     0.150
    20.910   288.238     0.150
    21.463   292.641     0.150
    23.913   323.539     0.150
    24.973     3.160     0.150
    29.178   359.820     0.150
    32.576  2274.113     0.150
    34.493   407.129     0.150
    36.124   418.410     0.150
    39.826   448.910     0.150
    61.726   640.141     0.150
    63.139  1124.629     0.150
    63.825     3.000     0.150
    63.825   672.062     0.150
    66.526   650.441     0.150
    67.252   643.621     0.150
    67.252    19.598     0.150
    67.252   678.102     0.150
    67.252   692.262     0.150
    67.252   726.680     0.150
    68.692     2.301     0.150
    68.692   677.340     0.150
    68.692   683.238     0.150
    68.692   726.738     0.150
    68.998   676.840     0.150
    68.998  1224.840     0.150
    71.839   681.238     0.150
    77.422  1305.039     0.150
    79.938   728.480     0.150
    82.455   740.340     0.150
    82.470   743.090     0.150
    82.470     4.961     0.150
    82.617   744.898     0.150
    82.747  1700.996     0.150
    82.898   759.359     0.150
    82.999     4.859     0.150
    83.002   758.949     0.150
    83.037   760.852     0.150
    83.933   751.969     0.150
    84.730   753.840     0.150
    88.481   770.949     0.150
    88.515  1372.340     0.150
    89.535   775.270     0.150
    90.623   781.840     0.150
    90.623  1417.840     0.150
    90.665   782.039     0.150
    90.874  1002.941     0.150
    90.874    14.109     0.150
    90.874  1002.941     0.150
    91.044  2314.738     0.150
    91.703   786.340     0.150
    92.570  1207.840     0.150
    92.734    16.000     0.150
    92.734  2048.840     0.150
    93.049  1021.039     0.150
    94.280   817.539     0.150
    94.568  1020.840     0.150
    94.958  1010.840     0.150
    94.958  1055.039     0.150
    95.242  1044.340     0.150
    95.242  1539.340     0.150
    99.180  1909.840     0.150
   101.037   827.840     0.150
   101.059   838.840     0.150
   101.252  1953.840     0.150
   101.900  1674.840     0.150
   102.127   838.141     0.150
   104.099   836.340     0.150
   104.099  1102.840     0.150
   104.099  1230.840     0.150
   104.135  1104.840     0.150
   104.135  1232.840     0.150
   104.135  1708.840     0.150
   105.956  1111.840     0.150
   107.198   860.590     0.150
   108.698  1722.840     0.150
   108.698  2082.840     0.150
   109.850  1148.840     0.150
   110.059  1138.840     0.150
   110.595  1147.738     0.150
   110.686  1784.840     0.150
   111.860  1155.840     0.150
   113.376  1118.441     0.150
   117.730  1196.340     0.150
   117.730  1351.840     0.150
   117.730  1606.840     0.150
   119.132  1205.441     0.150
   120.031  1782.840     0.150
   120.638   912.840     0.150
   121.402   914.840     0.150
   122.726  1147.840     0.150
   122.726  1391.840     0.150
   122.895  1134.211     0.150
   127.198  1122.738     0.150
   129.589   949.039     0.150
   129.589  1349.238     0.150
   129.784  1354.238     0.150
   129.955  1354.441     0.150
   130.365  1156.840     0.150
   130.513  1162.840     0.150
   130.988  1145.238     0.150
   131.111  1144.840     0.150
   131.111  1347.840     0.150
   131.299  1286.840     0.150
   131.284  1138.113     0.150
   131.284  1138.109     0.150
   131.284  1142.340     0.150
   131.284  1151.512     0.150
   131.530  1152.250     0.150
   132.538  1149.441     0.150
   133.548  1154.840     0.150
   133.548  1946.840     0.150
   133.548  2350.840     0.150
   134.266  1145.340     0.150
   135.662  1147.840     0.150
   136.197  1299.840     0.150
   137.132  1151.039     0.150
   137.705  1149.480     0.150
   138.008  1156.238     0.150
   141.206  1164.941     0.150
   141.670  1189.840     0.150
   143.988  1171.039     0.150
   144.231  1171.840     0.150
   144.745  1562.840     0.150
   144.745  2132.840     0.150
   146.489  1179.840     0.150
   148.960  1399.840     0.150
   148.960  1849.840     0.150
   153.614  1187.418     0.150
     2.901    59.750     0.150
     3.390    53.988     0.150
    18.234   255.617     0.150
    18.733   258.688     0.150
    21.853   291.078     0.150
    24.524     7.496     0.150
    25.111     7.902     0.150
    28.197   351.277     0.150
    30.754   377.688     0.150
    32.383   563.340     0.150
    45.171   602.285     0.150
    45.681   604.289     0.150
    50.024   531.539     0.150
    73.782   701.289     0.150
    86.427   761.887     0.150
    86.799   762.789     0.150
    86.868   763.887     0.150
    87.167   765.188     0.150
    87.381   766.387     0.150
    87.394   766.090     0.150
    87.518   767.289     0.150
    87.760   767.988     0.150
    89.028   774.988     0.150
    89.779   778.688     0.150
    90.555   787.488     0.150
    90.555   787.488     0.150
    90.806   790.590     0.150
    90.806   790.590     0.150
    91.710   794.188     0.150
    99.237   824.488     0.150
    24.555     7.219     0.150
    24.647   315.664     0.150
    25.151   327.688     0.150
    30.142   373.086     0.150
    55.336   575.867     0.150
    55.435   575.766     0.150
    60.318   612.102     0.150
    85.303   750.695     0.150
    85.303   752.969     0.150
   138.050  1158.094     0.150
     4.216    60.102     0.150
    11.308   168.734     0.150
    12.685   188.281     0.150
    17.200   245.305     0.150
    18.359   259.070     0.150
    21.323   288.953     0.150
    22.048   296.125     0.150
    22.051   297.211     0.150
    32.394   385.852     0.150
    57.777   591.570     0.150
    85.359   753.805     0.150
     2.157    42.395     0.150
     2.768    45.496     0.150
     2.768    71.996     0.150
     2.768    77.973     0.150
     2.990    62.855     0.150
    12.689   184.383     0.150
    16.842   239.203     0.150
    17.235   243.625     0.150
    18.837   265.336     0.150
    22.660   293.176     0.150
    24.556     9.574     0.150
    24.686   315.293     0.150
    26.962   335.156     0.150
    32.629   389.234     0.150
    36.692   417.062     0.150
    54.363   562.234     0.150
    55.299   630.484     0.150
    90.549   780.633     0.150
   138.050  1158.184     0.150
    15.960   227.992     0.150
    17.003   248.352     0.150
    21.331   294.342     0.150
    24.445    10.751     0.150
   127.372  1132.662     0.150
     3.477   100.664     0.150
     3.558    54.496     0.150
    17.178   244.102     0.150
    17.178     8.152     0.150
    18.282   254.105     0.150
    20.529   277.645     0.150
    20.900   282.207     0.150
    22.353   300.465     0.150
    22.504     9.090     0.150
    24.627   315.906     0.150
    24.511     8.500     0.150
    25.283     8.121     0.150
    26.101   333.016     0.150
    27.828   349.836     0.150
    32.568   565.281     0.150
    39.190   446.836     0.150
    45.186   598.000     0.150
    45.186   605.352     0.150
    68.687    15.199     0.150
    76.946   721.016     0.150
    78.889   731.254     0.150
    79.267   732.855     0.150
    80.102   738.457     0.150
    80.273   739.355     0.150
    80.373   739.957     0.150
    80.407   740.055     0.150
    80.496   740.555     0.150
    80.681   741.855     0.150
    80.741  1013.656     0.150
    82.382   744.855     0.150
    82.713   741.457     0.150
    82.918   742.555     0.150
    83.402   748.484     0.150
    84.212   749.555     0.150
    84.597   751.555     0.150
    84.719   756.234     0.150
    85.122   757.715     0.150
    85.280   764.555     0.150
    85.301   755.055     0.150
    85.542   765.055     0.150
    85.700   761.164     0.150
    86.022   770.055     0.150
    86.161   763.504     0.150
    86.202   770.156     0.150
    86.310   764.227     0.150
    86.418   771.555     0.150
    86.489   761.055     0.150
    86.770   773.355     0.150
    86.860   762.754     0.150
    87.013   775.156     0.150
    87.276   775.855     0.150
    87.354   774.746     0.150
    87.364   765.254     0.150
    87.472   776.754     0.150
    87.651   777.555     0.150
    87.861   778.855     0.150
    88.013   778.855     0.150
    88.083   768.957     0.150
    88.479   780.457     0.150
    88.747   764.957     0.150
    88.747  1737.855     0.150
    89.189   783.555     0.150
    89.217   783.754     0.150
    89.240   773.254     0.150
    89.336   784.254     0.150
    89.524   785.355     0.150
    89.848   786.875     0.150
    89.896   786.754     0.150
    90.002   787.457     0.150
    90.122   778.055     0.150
    90.192   788.387     0.150
    90.211   788.477     0.150
    90.494   779.355     0.150
    90.513   788.055     0.150
    90.612   782.754     0.150
    90.612     7.801     0.150
    90.612   843.855     0.150
    90.900   792.055     0.150
    90.929   791.957     0.150
    90.936   781.055     0.150
    90.980   789.355     0.150
    91.010   792.055     0.150
    91.034   791.754     0.150
    91.191   792.656     0.150
    91.237   792.656     0.150
    91.279   794.156     0.150
    91.408   794.754     0.150
    91.411   794.555     0.150
    91.692   795.555     0.150
    91.766   789.254     0.150
    91.797   796.055     0.150
    92.922   790.156     0.150
    92.734   796.656     0.150
    93.039   795.457     0.150
    93.326   802.754     0.150
    93.917   805.656     0.150
    94.034   806.055     0.150
    94.557   805.156     0.150
    94.557     2.301     0.150
    94.587   808.656     0.150
    94.636   797.156     0.150
    95.026   809.855     0.150
    95.385   812.055     0.150
    97.083   815.555     0.150
    97.083     1.902     0.150
    99.170   827.254     0.150
    99.284   828.355     0.150
   101.048   838.555     0.150
   101.168   838.855     0.150
   104.126   847.855     0.150
     1.287    22.082     0.150
     1.560    24.891     0.150
     2.769    78.551     0.150
     3.333    53.520     0.150
    25.737   332.379     0.150
     2.631    28.526     0.150
     2.631    60.626     0.150
     4.193    55.546     0.150
     6.147   168.306     0.150
    18.743   257.346     0.150
    24.385   316.386     0.150
    24.406   546.546     0.150
    25.258    29.812     0.150
    25.258   547.246     0.150
    29.013   358.386     0.150
    29.958   367.206     0.150
    32.294   564.259     0.150
    32.517   564.521     0.150
    45.109   604.041     0.150
    45.722   605.596     0.150
    55.153   641.246     0.150
    55.177   553.486     0.150
    68.799   676.146     0.150
    68.799   699.846     0.150
    68.799   700.646     0.150
    68.799   724.346     0.150
    81.855   735.246     0.150
    82.214   737.846     0.150
    83.395     6.710     0.150
    87.385   766.346     0.150
    90.616   780.746     0.150
    90.616    13.500     0.150
    91.036   791.446     0.150
    91.259     9.200     0.150
    91.959     9.101     0.150
    92.481   780.246     0.150
    92.481    18.300     0.150
    93.542     9.500     0.150
    94.415     9.700     0.150
    97.430   824.046     0.150
   126.292  1126.980     0.150
   127.132  1127.946     0.150
   147.514  1184.746     0.150
     1.070    32.908     0.150
     2.814    32.148     0.150
     2.814    63.658     0.150
     3.783    57.377     0.150
    17.173   244.568     0.150
    21.024   287.008     0.150
    22.099   302.809     0.150
    24.538     7.775     0.150
    25.338     8.100     0.150
     2.124    68.000     0.150
     2.191    70.172     0.150
    22.396   295.352     0.150
    24.762   324.703     0.150
    32.887   405.883     0.150
    38.925   454.539     0.150
    54.577     0.602     0.150
    62.009   628.445     0.150
    65.356   650.797     0.150
    86.173   765.727     0.150
    87.288   768.781     0.150
    87.516   769.586     0.150
    95.034   798.680     0.150
     1.119    19.789     0.150
     1.276    19.523     0.150
     1.276    36.125     0.150
     4.521    73.086     0.150
     4.596    82.586     0.150
     6.270    98.992     0.150
     7.103   115.609     0.150
    22.468   292.508     0.150
    23.488   303.312     0.150
    25.543   326.156     0.150
    49.536   526.812     0.150
    53.489   554.523     0.150
    63.688   624.703     0.150
    64.810   634.789     0.150
    68.876   661.383     0.150
     3.240    94.203     0.150
     3.240    50.102     0.150
     3.633    71.344     0.150
     3.689    56.375     0.150
     3.689    56.422     0.150
     3.931    69.734     0.150
     5.543   154.172     0.150
     5.543    83.164     0.150
    11.107   176.734     0.150
    12.420   173.414     0.150
    14.016   214.938     0.150
    14.031   215.641     0.150
    14.791   224.094     0.150
    15.915   230.547     0.150
    16.290   232.734     0.150
    16.753   225.125     0.150
    17.028   241.203     0.150
    17.028   251.984     0.150
    20.884   280.523     0.150
    23.199   302.875     0.150
    24.359   328.258     0.150
    24.430    12.172     0.150
    24.430    17.969     0.150
    24.430   316.484     0.150
    24.430    12.172     0.150
    24.430    17.977     0.150
    25.194   318.453     0.150
    25.194    19.383     0.150
    25.194   318.453     0.150
    25.194    19.383     0.150
    44.968   491.336     0.150
    44.968    12.820     0.150
    44.968    18.672     0.150
    45.025   502.938     0.150
    45.025   591.234     0.150
    53.752   555.961     0.150
    54.004   554.844     0.150
    56.616   568.492     0.150
    77.880   712.289     0.150
    77.880    14.375     0.150
    85.084   750.719     0.150
    85.084    20.180     0.150
   126.554  1138.867     0.150
   126.554  1152.766     0.150
   127.398  1154.234     0.150
   144.560  1170.734     0.150
     3.071    80.312     0.150
     3.077    56.789     0.150
     3.426    50.016     0.150
     3.613    63.820     0.150
     3.642    57.328     0.150
     3.868    74.719     0.150
    11.447   166.469     0.150
    11.447   360.891     0.150
    12.716   186.789     0.150
    18.841   265.898     0.150
    21.186   288.078     0.150
    24.785   322.945     0.150
    32.614   390.266     0.150
    33.046   390.992     0.150
    34.314   401.422     0.150
    45.324   498.492     0.150
    45.369   595.422     0.150
    45.369   495.367     0.150
    51.249   541.297     0.150
    62.996   624.352     0.150
    62.996   624.352     0.150
    78.174   718.047     0.150
    85.357   756.281     0.150
   126.630  1143.305     0.150
   144.890  1175.719     0.150
     3.678    57.508     0.150
     3.678   101.336     0.150
     3.678   102.508     0.150
     3.824    56.969     0.150
     4.115    65.055     0.150
     4.115   111.734     0.150
     5.941    90.711     0.150
     5.941   160.578     0.150
    20.407   281.797     0.150
    22.432   304.281     0.150
    24.032   316.391     0.150
    24.281   318.930     0.150
    25.182   324.711     0.150
    25.182   538.055     0.150
    29.953   372.828     0.150
    31.126   382.516     0.150
    32.200   389.109     0.150
    44.897   495.680     0.150
    45.045   493.297     0.150
    45.045   595.156     0.150
    45.045   826.445     0.150
    45.045   493.305     0.150
    45.045   595.109     0.150
    48.384   523.008     0.150
    53.728   560.008     0.150
    55.051   571.109     0.150
    55.051   632.305     0.150
    56.163  4237.938     0.150
    56.172  4240.227     0.150
    56.180  4239.234     0.150
    58.066  1321.711     0.150
    62.540   623.805     0.150
    80.525   733.805     0.150
    80.525   922.609     0.150
    81.794   737.070     0.150
    82.816   742.711     0.150
    85.250   755.445     0.150
    85.259   755.656     0.150
    85.274   756.008     0.150
    85.308   755.906     0.150
    85.541   760.938     0.150
    86.824   763.305     0.150
    90.225   779.211     0.150
    90.685   781.805     0.150
    90.685   781.805     0.150
    90.685   781.805     0.150
    90.888   782.930     0.150
    90.888   782.906     0.150
    91.596   792.508     0.150
    91.835   787.406     0.150
   112.073   872.508     0.150
   115.189  1119.711     0.150
   115.189  1755.906     0.150
   116.049  1135.508     0.150
   126.128  1142.508     0.150
   133.619  1158.508     0.150
   144.622  1174.508     0.150
   144.622  1183.508     0.150
   146.555  1330.578     0.150
   146.555  1553.547     0.150
     1.211    34.449     0.150
     1.719    26.988     0.150
     2.099    29.359     0.150
     2.099    53.660     0.150
     2.728    78.367     0.150
     4.323    64.867     0.150
     4.323   117.219     0.150
     4.760    72.828     0.150
     4.760   128.598     0.150
     5.908   162.230     0.150
    19.422   267.117     0.150
    23.401   308.109     0.150
    24.849   320.578     0.150
    25.241   547.938     0.150
    33.607   396.258     0.150
    56.253  4236.324     0.150
    56.263  4237.051     0.150
    56.271  4237.629     0.150
    70.377   671.738     0.150
    71.450   677.840     0.150
    71.450   677.840     0.150
    73.499   690.961     0.150
    79.426   720.039     0.150
    79.869   723.039     0.150
    80.442   742.438     0.150
    80.442  1407.238     0.150
    85.619   753.980     0.150
    85.726   752.738     0.150
    87.527   766.141     0.150
    88.085   769.738     0.150
    88.101   769.141     0.150
    91.287   782.641     0.150
    91.287    12.617     0.150
    92.334   788.340     0.150
   102.421   829.039     0.150
   124.083   938.738     0.150
   124.083   938.738     0.150
   126.329  1150.738     0.150
   126.329  1157.988     0.150
   130.539  1143.230     0.150
   144.773  1174.039     0.150
     1.276    35.742     0.150
     2.057    33.297     0.150
     2.681    38.383     0.150
     2.681    77.266     0.150
     3.111    49.828     0.150
     3.569    58.781     0.150
     4.045    67.297     0.150
    44.991   489.672     0.150
    44.991   591.383     0.150
    45.689   492.484     0.150
    53.682   557.031     0.150
    56.195  4201.672     0.150
    56.204  4202.359     0.150
    56.212  4202.992     0.150
    62.542   619.055     0.150
     1.680    54.112     0.150
     2.390    68.742     0.150
     3.849    59.112     0.150
     4.282    66.562     0.150
     4.282   113.782     0.150
    11.231   207.212     0.150
    17.088   240.322     0.150
    19.132   267.667     0.150
    27.347   345.332     0.150
    28.849   366.433     0.150
    28.978   358.612     0.150
    33.551   402.562     0.150
    35.008   411.013     0.150
    35.008   411.143     0.150
    45.114   493.612     0.150
    45.114   594.812     0.150
    45.114   493.603     0.150
    45.114   594.853     0.150
    55.080   571.212     0.150
    55.080   632.013     0.150
    56.142  4212.663     0.150
    56.151  4214.126     0.150
    56.159  4214.599     0.150
    62.587   623.112     0.150
    63.700   630.513     0.150
    71.247   676.912     0.150
    80.538  1022.013     0.150
    80.799   732.412     0.150
    81.965   740.082     0.150
    82.548   742.513     0.150
    82.522   741.782     0.150
    85.402   756.312     0.150
    85.402   756.282     0.150
    85.455   756.612     0.150
    89.470   772.912     0.150
    90.087   778.812     0.150
    90.845   783.112     0.150
    90.845   783.112     0.150
    91.027   781.513     0.150
    91.027   996.312     0.150
    91.027   781.532     0.150
    91.027   996.312     0.150
    91.261   783.612     0.150
    91.994   788.312     0.150
    92.457   787.612     0.150
    92.790   791.513     0.150
    92.932   792.513     0.150
    92.932   791.812     0.150
    92.932  1010.412     0.150
    95.657   804.812     0.150
    99.431  1074.712     0.150
    99.431   821.013     0.150
    99.718   823.114     0.150
   101.636   832.312     0.150
   108.977  1130.799     0.150
   115.268  1119.312     0.150
   115.268  1119.282     0.150
   120.597  1130.582     0.150
   120.998  1133.013     0.150
   125.963  1141.712     0.150
   126.805  1134.812     0.150
   129.662  1148.112     0.150
   137.771  1165.712     0.150
   144.706  1174.612     0.150
     1.883    30.516     0.150
     1.883    52.219     0.150
     1.883    30.516     0.150
     1.883    52.219     0.150
     2.486    41.961     0.150
     3.312    51.039     0.150
     3.767    61.414     0.150
     3.767   101.680     0.150
     4.206   114.305     0.150
     4.485    70.695     0.150
     8.276   121.961     0.150
     8.276   235.797     0.150
    15.392     9.312     0.150
    15.995     8.203     0.150
    16.855   243.758     0.150
    19.969   275.125     0.150
    20.984     7.242     0.150
    22.360     6.219     0.150
    23.924     6.609     0.150
    23.932     7.391     0.150
    24.567   321.547     0.150
    24.567     6.172     0.150
    48.124   514.891     0.150
    48.933   518.898     0.150
    56.568  4237.008     0.150
    56.577  4240.961     0.150
    56.585  4239.742     0.150
    88.114   770.805     0.150
   114.964  1121.836     0.150
     3.766    55.953     0.150
     3.766    57.898     0.150
     3.766    58.172     0.150
     3.766    99.672     0.150
    13.560   195.508     0.150
    16.334   231.945     0.150
    44.918   489.711     0.150
    44.918    10.828     0.150
    44.918   592.039     0.150
    50.929   536.602     0.150
    50.929    12.172     0.150
   115.039  1116.570     0.150
   144.463  1170.852     0.150
     1.266    20.250     0.150
     2.682    37.453     0.150
     2.682    67.961     0.150
     2.682    77.203     0.150
     2.682    82.633     0.150
     3.953    53.422     0.150
     4.382   107.398     0.150
     4.351    62.375     0.150
     4.617    68.383     0.150
     4.694    75.031     0.150
     4.694    72.039     0.150
     4.694    74.758     0.150
     4.758    68.828     0.150
     5.051    74.922     0.150
     5.051   127.953     0.150
     5.185    81.492     0.150
     6.489   484.484     0.150
     6.520   492.680     0.150
     6.548   490.984     0.150
     7.164   107.883     0.150
     8.128   113.953     0.150
     8.889   239.359     0.150
     8.889   123.961     0.150
     8.889   130.258     0.150
     8.889   239.352     0.150
    12.436   179.422     0.150
    13.553   191.922     0.150
    14.913   211.734     0.150
    15.799   227.391     0.150
    16.403   231.609     0.150
    16.737   233.031     0.150
    18.591   258.430     0.150
    19.184   257.875     0.150
    20.525   275.500     0.150
    21.154   284.359     0.150
    21.165   286.070     0.150
    21.176   284.648     0.150
    21.251   287.109     0.150
    22.379   293.734     0.150
    22.379   293.773     0.150
    22.530   300.594     0.150
    22.585   295.938     0.150
    22.787   301.852     0.150
    23.305   304.633     0.150
    23.309   308.203     0.150
    23.309   535.453     0.150
    23.606   306.734     0.150
    23.666   311.664     0.150
    24.021   314.500     0.150
    24.253   315.570     0.150
    24.509   319.125     0.150
    24.949   318.234     0.150
    24.949   318.234     0.150
    24.949   338.742     0.150
    25.430   326.500     0.150
    26.770   338.672     0.150
    26.770   542.930     0.150
    26.852   341.281     0.150
    26.907   340.828     0.150
    26.907   340.852     0.150
    27.035   340.344     0.150
    27.628   346.758     0.150
    27.807   348.328     0.150
    27.807   348.359     0.150
    27.907   350.109     0.150
    27.991   349.000     0.150
    29.215   361.062     0.150
    30.478   373.062     0.150
    31.392   380.680     0.150
    31.420   380.672     0.150
    35.960   419.320     0.150
    36.081   418.508     0.150
    49.545   530.430     0.150
    49.545     6.945     0.150
    53.017   554.930     0.150
    53.017   554.883     0.150
    53.198   557.430     0.150
    54.319   565.242     0.150
    59.093   603.430     0.150
    59.093   819.133     0.150
    59.093  1464.633     0.150
    59.093   603.430     0.150
    59.093   819.133     0.150
    59.093  1464.633     0.150
    63.695   631.031     0.150
    63.695     6.797     0.150
    66.764   655.859     0.150
    70.964   674.328     0.150
    79.135   723.422     0.150
    79.552   725.312     0.150
    79.567   726.320     0.150
    80.017   728.422     0.150
    80.041   728.773     0.150
    80.134   729.422     0.150
    80.288   730.141     0.150
    80.370   730.141     0.150
    80.602   731.883     0.150
    80.711   732.398     0.150
    80.716   732.734     0.150
    80.841   733.133     0.150
    80.907   732.961     0.150
    80.907   732.734     0.150
    80.994   733.789     0.150
    81.021   734.305     0.150
    81.078   734.398     0.150
    81.555   736.930     0.150
    81.687   737.328     0.150
    81.960   739.031     0.150
    82.035   739.539     0.150
    82.124   739.992     0.150
    82.146   739.859     0.150
    82.257   740.930     0.150
    82.382   740.930     0.150
    82.451   742.125     0.150
    82.544   742.312     0.150
    82.822   744.000     0.150
    83.178   746.234     0.150
    83.178   746.211     0.150
    83.179   746.500     0.150
    83.321   744.633     0.150
    83.321   744.609     0.150
    83.457   746.234     0.150
    83.457   746.234     0.150
    83.512   747.133     0.150
    83.920   749.188     0.150
    83.968   749.469     0.150
    84.140   749.930     0.150
    84.112   751.344     0.150
    84.332   752.102     0.150
    84.727   753.430     0.150
    84.727   753.430     0.150
    84.817   754.133     0.150
    84.817   754.133     0.150
    85.102   755.133     0.150
    85.102   755.133     0.150
    85.329   757.289     0.150
    85.384   749.633     0.150
    85.384   756.578     0.150
    85.415   755.703     0.150
    85.803   760.211     0.150
    85.805   758.672     0.150
    85.853   758.734     0.150
    85.853   758.734     0.150
    86.323   760.992     0.150
    86.467   762.594     0.150
    86.472   761.133     0.150
    86.472   761.133     0.150
    86.554   763.688     0.150
    86.789   764.328     0.150
    86.789   764.328     0.150
    86.789  1404.930     0.150
    86.945   765.391     0.150
    87.006   764.031     0.150
    87.006   764.031     0.150
    87.074   764.133     0.150
    87.074   764.133     0.150
    87.090    31.695     0.150
    87.090   764.234     0.150
    87.090   764.234     0.150
    87.090    31.695     0.150
    87.236   766.430     0.150
    87.431   765.430     0.150
    87.431   765.430     0.150
    87.472   767.688     0.150
    87.472   765.633     0.150
    87.472   765.633     0.150
    87.562   766.531     0.150
    87.562   766.531     0.150
    87.564   767.109     0.150
    87.760   766.930     0.150
    87.760   766.930     0.150
    87.928   770.578     0.150
    87.940    31.398     0.150
    87.958   767.828     0.150
    87.958   767.828     0.150
    87.987   771.070     0.150
    87.978    32.000     0.150
    88.068   769.211     0.150
    88.087   768.734     0.150
    88.087   768.734     0.150
    88.584   773.031     0.150
    88.694    30.602     0.150
    88.694   771.633     0.150
    88.694   771.633     0.150
    88.694    30.602     0.150
    88.755   778.430     0.150
    88.755   989.930     0.150
    88.755   778.430     0.150
    88.755   989.930     0.150
    89.112   774.188     0.150
    89.112     6.633     0.150
    89.441   775.531     0.150
    89.629   776.031     0.150
    89.629   776.031     0.150
    89.698   776.828     0.150
    90.255   783.031     0.150
    90.255  1328.234     0.150
    90.255   783.031     0.150
    90.255   993.633     0.150
    90.255   783.031     0.150
    90.255   993.633     0.150
    90.255  1328.234     0.150
    90.286   778.828     0.150
    90.387   779.531     0.150
    90.387   779.531     0.150
    90.511   776.234     0.150
    90.618    31.898     0.150
    91.039   782.734     0.150
    91.039   782.734     0.150
    91.259   784.133     0.150
    91.259     8.102     0.150
    91.259   784.133     0.150
    91.259     8.102     0.150
    91.378    12.602     0.150
    91.378   998.133     0.150
    91.378   783.930     0.150
    91.378  1534.531     0.150
    91.378   783.930     0.150
    91.378     8.305     0.150
    91.378  1004.531     0.150
    91.378  1424.531     0.150
    91.378  1518.531     0.150
    91.378   783.930     0.150
    91.378     8.305     0.150
    91.378    13.000     0.150
    91.378   783.930     0.150
    91.378     8.305     0.150
    91.378    13.000     0.150
    91.378  1424.531     0.150
    91.399   782.930     0.150
    91.513   784.633     0.150
    91.513   784.633     0.150
    92.112  1000.531     0.150
    92.112  1427.531     0.150
    92.112  1527.531     0.150
    92.112  1865.531     0.150
    92.112   787.430     0.150
    92.112     7.305     0.150
    92.112  1527.531     0.150
    92.112   787.430     0.150
    92.112     7.344     0.150
    92.112  1000.531     0.150
    92.112  1427.531     0.150
    92.112  1527.531     0.150
    92.112  1865.531     0.150
    92.468   789.734     0.150
    92.750   791.234     0.150
    93.086   792.430     0.150
    93.409   793.828     0.150
    93.409     7.305     0.150
    93.838   795.930     0.150
    94.793   794.023     0.150
    95.314   813.031     0.150
    95.322   803.328     0.150
    95.322     8.703     0.150
    96.080   806.734     0.150
    99.717   820.562     0.150
   100.320   827.828     0.150
   110.630  1155.031     0.150
   114.174  1180.031     0.150
   114.647  1769.328     0.150
   114.647  1118.500     0.150
   114.647  1769.328     0.150
   119.516  1228.531     0.150
   119.516  1500.531     0.150
   125.986  1139.875     0.150
   129.288  1155.828     0.150
   130.321  1148.570     0.150
     3.407    51.375     0.150
     4.242    69.875     0.150
     4.242   111.777     0.150
     4.242    69.918     0.150
     4.242   111.738     0.150
     4.242   116.637     0.150
     4.242   117.105     0.150
     4.713    72.055     0.150
     4.713   125.848     0.150
     7.004   514.941     0.150
     7.033   526.223     0.150
     7.065   518.570     0.150
     8.475   121.977     0.150
     8.475   125.238     0.150
     8.475   218.277     0.150
    12.496   177.707     0.150
    13.474   190.586     0.150
    15.305   216.777     0.150
    16.814   233.508     0.150
    18.370   251.777     0.150
    19.049   262.508     0.150
    20.399   273.656     0.150
    21.396   285.758     0.150
    21.505   286.426     0.150
    21.683   290.828     0.150
    21.683   290.906     0.150
    21.694   290.766     0.150
    21.854   287.438     0.150
    22.339   293.297     0.150
    22.412   300.367     0.150
    22.462   295.098     0.150
    22.633   296.746     0.150
    22.917   304.875     0.150
    22.953   304.488     0.150
    23.019   306.238     0.150
    23.141   305.898     0.150
    23.257   302.945     0.150
    24.473   317.945     0.150
    24.839   318.336     0.150
    24.912   321.945     0.150
    25.429   324.027     0.150
    25.643   327.066     0.150
    25.712   330.516     0.150
    26.166   334.785     0.150
    26.704   335.137     0.150
    26.909   336.957     0.150
    27.171   340.777     0.150
    27.171   340.797     0.150
    27.617   343.215     0.150
    27.936   348.336     0.150
    28.429   354.168     0.150
    28.429   354.176     0.150
    28.429   641.777     0.150
    30.815   375.898     0.150
    31.768   380.777     0.150
    31.768   553.578     0.150
    31.768   692.277     0.150
    31.768   380.805     0.150
    31.768   553.527     0.150
    31.768   692.258     0.150
    33.267   392.926     0.150
    33.267   557.945     0.150
    33.267   713.207     0.150
    35.479   415.078     0.150
    35.479   563.578     0.150
    40.077   452.527     0.150
    44.445   488.277     0.150
    44.717   489.676     0.150
    44.717   887.277     0.150
    44.717   489.668     0.150
    44.717   887.277     0.150
    45.869   500.027     0.150
    45.869   499.977     0.150
    53.337   557.375     0.150
    53.337  1005.477     0.150
    53.602   559.785     0.150
    54.707   567.957     0.150
    54.978   568.996     0.150
    63.185   626.277     0.150
    63.185   636.176     0.150
    63.185   626.266     0.150
    63.185   636.207     0.150
    80.080   733.875     0.150
    81.260   734.195     0.150
    81.981   738.805     0.150
    81.981     7.352     0.150
    83.158  1995.578     0.150
    84.557   751.977     0.150
    84.557   751.977     0.150
    84.652   752.676     0.150
    84.652   752.676     0.150
    84.936   753.875     0.150
    84.936   753.875     0.150
    85.088   754.996     0.150
    85.368   753.578     0.150
    85.368   753.586     0.150
    85.368  1385.738     0.150
    85.381   755.625     0.150
    85.454   753.078     0.150
    85.454   753.078     0.150
    85.527   757.035     0.150
    85.670   758.375     0.150
    85.670   758.375     0.150
    86.027   755.945     0.150
    86.207   760.438     0.150
    86.285   761.457     0.150
    86.679   763.176     0.150
    86.879   763.578     0.150
    86.879   763.578     0.150
    86.947   762.977     0.150
    86.947   762.977     0.150
    86.983   763.777     0.150
    87.213   765.695     0.150
    87.242   764.176     0.150
    87.242   764.176     0.150
    87.293   764.176     0.150
    87.293   764.176     0.150
    87.352   765.078     0.150
    87.352   765.078     0.150
    87.749   766.375     0.150
    87.749   766.375     0.150
    87.788   766.477     0.150
    87.788   766.477     0.150
    87.806   766.078     0.150
    87.806   766.078     0.150
    87.920   767.277     0.150
    87.920   767.277     0.150
    88.116   768.375     0.150
    88.490   770.176     0.150
    88.490   770.176     0.150
    88.516   770.176     0.150
    88.706   777.875     0.150
    89.113   772.977     0.150
    89.305   772.426     0.150
    89.310   773.875     0.150
    89.462   774.777     0.150
    89.462   774.777     0.150
    89.586   775.578     0.150
    90.140   777.277     0.150
    90.206   778.277     0.150
    90.206   778.277     0.150
    90.475   780.078     0.150
    90.475   780.078     0.150
    90.859   781.578     0.150
    90.859   781.578     0.150
    90.865   781.875     0.150
    90.905   780.496     0.150
    91.133   783.176     0.150
    91.133     6.602     0.150
    91.133  1442.676     0.150
    91.133   783.176     0.150
    91.133     6.602     0.150
    91.133  1442.676     0.150
    91.270   782.977     0.150
    91.270     8.000     0.150
    91.270  1000.977     0.150
    91.270  1416.977     0.150
    91.270  1450.977     0.150
    91.270  1804.977     0.150
    91.270   782.977     0.150
    91.270  1416.977     0.150
    91.270   782.977     0.150
    91.270  1416.977     0.150
    91.270  1450.977     0.150
    91.534   785.578     0.150
    91.534     7.199     0.150
    91.580   781.977     0.150
    91.937   786.875     0.150
    92.003    22.461     0.150
    92.003  1977.406     0.150
    92.003   786.977     0.150
    92.003     7.301     0.150
    92.003  1449.977     0.150
    92.003  1810.977     0.150
    92.003   786.996     0.150
    92.003     7.270     0.150
    92.003    22.461     0.150
    92.003  1449.977     0.150
    92.003  1810.977     0.150
    92.003  1977.406     0.150
    92.342   788.578     0.150
    92.805   791.176     0.150
    92.805     6.801     0.150
    92.961   791.078     0.150
    92.961     7.398     0.150
    93.375   793.977     0.150
    93.557   794.676     0.150
    93.557     7.000     0.150
    94.530   798.465     0.150
    94.813   800.375     0.150
    94.813     6.902     0.150
    95.450   808.977     0.150
    95.970   805.578     0.150
    95.970     7.297     0.150
    96.674   809.578     0.150
    96.854   808.676     0.150
    96.882   810.297     0.150
    96.882     7.121     0.150
    97.504   811.875     0.150
    97.504   811.875     0.150
    99.311   819.375     0.150
    99.665   820.277     0.150
    99.921   822.695     0.150
    99.921  1064.996     0.150
   107.750   853.578     0.150
   112.628  1115.977     0.150
   112.628  1167.578     0.150
   114.897  1118.375     0.150
   115.445  1124.477     0.150
   118.480  1127.277     0.150
   119.240  1126.777     0.150
   126.618  1674.477     0.150
   144.345  1172.977     0.150
     1.488    41.383     0.150
     1.473    43.695     0.150
     1.805    29.945     0.150
     1.805    46.945     0.150
     3.115    47.266     0.150
     3.115    47.945     0.150
     3.167    52.844     0.150
     3.167    50.039     0.150
     3.167    52.492     0.150
     3.167    52.844     0.150
     3.317    48.375     0.150
     3.317    48.133     0.150
     3.652    52.719     0.150
     3.652    54.586     0.150
     3.652    58.406     0.150
     3.652    93.086     0.150
     4.528   124.047     0.150
     7.409   108.578     0.150
     7.409   188.117     0.150
    13.155   193.344     0.150
    16.255   243.469     0.150
    21.994   303.914     0.150
     1.225    19.834     0.150
     2.720    82.494     0.150
     4.354    71.125     0.150
     4.382    71.875     0.150
     4.719    77.045     0.150
     4.719    77.045     0.150
     4.719   134.115     0.150
     5.212    84.584     0.150
     5.212   146.045     0.150
     5.212    84.584     0.150
     5.212   146.045     0.150
     6.050   164.535     0.150
     6.409    99.744     0.150
     6.409   176.584     0.150
     6.458   483.592     0.150
     6.488   478.711     0.150
     7.352   199.285     0.150
     8.166   219.955     0.150
     8.922   239.414     0.150
     8.922   130.855     0.150
     8.922   227.334     0.150
     8.922   239.414     0.150
     8.922   267.266     0.150
    10.547   155.664     0.150
    10.652   153.785     0.150
    10.652   268.305     0.150
    10.652   329.234     0.150
    14.877   211.744     0.150
    15.022   210.805     0.150
    16.719   232.795     0.150
    17.998   264.924     0.150
    20.050   274.096     0.150
    20.053   276.846     0.150
    20.164   273.994     0.150
    20.310   276.535     0.150
    20.310   503.635     0.150
    20.310   276.615     0.150
    20.457   275.734     0.150
    20.521   275.775     0.150
    21.125   284.164     0.150
    21.125   298.596     0.150
    21.142   284.404     0.150
    21.212     8.100     0.150
    21.212   286.254     0.150
    21.212     8.031     0.150
    22.171   291.725     0.150
    22.492   300.385     0.150
    22.581   296.164     0.150
    22.678   298.385     0.150
    22.752   301.465     0.150
    22.752   301.484     0.150
    23.295   304.654     0.150
    23.271   307.865     0.150
    23.271   534.555     0.150
    23.271   744.016     0.150
    23.610   306.975     0.150
    23.626   310.545     0.150
    23.693   307.885     0.150
    23.982   313.965     0.150
    23.982   313.934     0.150
    24.013   314.715     0.150
    24.219   320.535     0.150
    24.489   341.814     0.150
    24.488   316.834     0.150
    24.488   536.535     0.150
    24.488   572.055     0.150
    24.488   782.686     0.150
    24.471   318.955     0.150
    24.713   317.436     0.150
    24.713   574.936     0.150
    24.713   317.385     0.150
    24.713   574.965     0.150
    25.096   339.084     0.150
    25.212   340.154     0.150
    25.403   325.615     0.150
    25.403   538.574     0.150
    25.452   342.355     0.150
    25.516   342.084     0.150
    25.625   329.234     0.150
    25.756   345.055     0.150
    26.047   331.936     0.150
    26.320   349.574     0.150
    26.378   343.834     0.150
    26.733   338.584     0.150
    26.894   338.744     0.150
    26.996   340.115     0.150
    27.808   347.734     0.150
    27.952   348.385     0.150
    29.295   359.445     0.150
    29.666   363.885     0.150
    31.359   380.555     0.150
    31.385   380.135     0.150
    31.385   552.885     0.150
    31.502   381.475     0.150
    32.966   409.365     0.150
    33.490   412.084     0.150
    36.245   424.635     0.150
    40.732   457.574     0.150
    44.416   487.234     0.150
    44.416   592.936     0.150
    44.416   879.734     0.150
    44.416   487.186     0.150
    44.416   592.924     0.150
    44.416   879.734     0.150
    51.296   973.936     0.150
    51.567    12.320     0.150
    52.767   554.904     0.150
    52.767   996.715     0.150
    52.984   554.734     0.150
    52.984   999.234     0.150
    57.379   710.734     0.150
    57.379  1289.635     0.150
    59.078   604.234     0.150
    59.078   604.234     0.150
    76.632   713.744     0.150
    78.971   722.545     0.150
    79.568  1386.234     0.150
    80.054   728.445     0.150
    80.229   729.314     0.150
    80.229   729.314     0.150
    80.280   730.494     0.150
    80.710   732.154     0.150
    80.902   732.984     0.150
    80.902   733.234     0.150
    81.495   736.654     0.150
    81.604   737.334     0.150
    82.143   739.414     0.150
    82.143   739.414     0.150
    82.379   740.484     0.150
    82.636   742.984     0.150
    83.457   746.734     0.150
    83.457   746.734     0.150
    84.726   753.334     0.150
    84.726   753.334     0.150
    84.816   753.936     0.150
    84.816   753.936     0.150
    85.138   752.734     0.150
    85.247   757.775     0.150
    85.334   757.025     0.150
    85.404   755.834     0.150
    85.404  1374.635     0.150
    85.408   756.295     0.150
    85.576   757.584     0.150
    85.576     9.090     0.150
    85.784   759.145     0.150
    85.810   758.695     0.150
    85.811   759.885     0.150
    85.853   758.834     0.150
    85.853   758.834     0.150
    86.330   761.686     0.150
    86.473   762.596     0.150
    86.475   762.035     0.150
    86.475   762.035     0.150
    86.561   763.084     0.150
    86.758   764.404     0.150
    86.781  1422.334     0.150
    86.781   763.234     0.150
    86.781  1397.734     0.150
    86.781   763.234     0.150
    86.781  1397.734     0.150
    86.781  1422.334     0.150
    86.924   761.635     0.150
    87.075   763.936     0.150
    87.075   763.936     0.150
    87.242   765.984     0.150
    87.379   766.135     0.150
    87.432   765.436     0.150
    87.432   765.436     0.150
    87.472   765.334     0.150
    87.472   765.334     0.150
    87.478   767.295     0.150
    87.565   766.334     0.150
    87.565   766.334     0.150
    87.760   766.734     0.150
    87.760   766.734     0.150
    87.941   767.936     0.150
    87.941   767.936     0.150
    87.957   767.535     0.150
    87.957   767.535     0.150
    87.977   767.334     0.150
    87.977   767.334     0.150
    88.075   769.516     0.150
    88.086   768.535     0.150
    88.086   768.535     0.150
    88.268   769.436     0.150
    88.390   770.834     0.150
    88.390   770.865     0.150
    88.566   785.936     0.150
    88.695   771.535     0.150
    88.695   771.535     0.150
    88.747   770.135     0.150
    88.747   770.135     0.150
    88.747   770.135     0.150
    89.265   774.035     0.150
    89.265   774.035     0.150
    89.437   775.635     0.150
    89.626   775.734     0.150
    89.626   775.734     0.150
    89.647   776.035     0.150
    89.647   776.035     0.150
    89.693   777.035     0.150
    89.746   776.334     0.150
    89.746   776.334     0.150
    90.283   778.936     0.150
    90.570   780.535     0.150
    90.570   780.504     0.150
    90.829   781.715     0.150
    90.882   780.535     0.150
    90.978   782.936     0.150
    91.255   784.545     0.150
    91.255   994.936     0.150
    91.255   994.936     0.150
    91.255   784.535     0.150
    91.255     8.100     0.150
    91.372   783.834     0.150
    91.372   783.834     0.150
    91.372  1465.635     0.150
    91.372  1585.635     0.150
    91.372  1855.635     0.150
    91.372  2077.635     0.150
    91.647   785.834     0.150
    92.464   790.035     0.150
    92.858   791.436     0.150
    92.858     8.600     0.150
    92.845   791.936     0.150
    93.082   792.535     0.150
    93.082  1417.953     0.150
    93.082   791.834     0.150
    93.082  1417.936     0.150
    93.403     5.199     0.150
    93.506   795.834     0.150
    93.506   795.814     0.150
    94.910   800.436     0.150
    94.910     7.000     0.150
    95.317   803.234     0.150
    95.317     8.600     0.150
    95.317   803.234     0.150
    95.317     8.600     0.150
    96.075   806.234     0.150
    96.075   806.234     0.150
    96.761   809.035     0.150
    96.952   810.334     0.150
    97.591   813.436     0.150
    97.591  1043.635     0.150
    97.794   808.635     0.150
    99.289  1593.535     0.150
    99.705   820.725     0.150
    99.707   820.834     0.150
    99.707   820.855     0.150
    99.941   823.805     0.150
   100.358   824.715     0.150
   100.358  1071.555     0.150
   100.358  1802.814     0.150
   102.148   823.635     0.150
   102.148  1605.635     0.150
   103.073  1529.936     0.150
   105.891   862.936     0.150
   107.316   856.035     0.150
   107.316  1120.436     0.150
   107.316   856.055     0.150
   107.316  1120.465     0.150
   107.840   858.686     0.150
   108.399   860.936     0.150
   108.399  1132.436     0.150
   108.477   860.734     0.150
   108.477  1128.635     0.150
   110.687  1144.135     0.150
   114.133  1177.436     0.150
   114.618   888.334     0.150
   114.618  1117.984     0.150
   114.618  1756.305     0.150
   116.916  1345.436     0.150
   118.070  1353.936     0.150
   119.479  1129.035     0.150
   119.479  1136.635     0.150
   119.479  1142.635     0.150
   119.479  1209.734     0.150
   119.479  1550.635     0.150
   119.479  1129.035     0.150
   119.479  1136.635     0.150
   119.479  1142.635     0.150
   119.479  1209.734     0.150
   119.479  1550.635     0.150
   119.479  1611.635     0.150
   119.479  2175.734     0.150
   122.148  1361.035     0.150
   125.060  1718.568     0.150
   125.060  1139.334     0.150
   125.060  1939.936     0.150
   125.965  1129.035     0.150
   125.965  1715.084     0.150
   125.965  1140.484     0.150
   125.965  1715.084     0.150
   125.965  1937.584     0.150
   129.249  1446.234     0.150
   129.249  2594.936     0.150
   129.249  1147.535     0.150
   129.249  1446.234     0.150
   129.249  2308.635     0.150
   129.249  1147.535     0.150
   129.249  1178.035     0.150
   129.249  1278.834     0.150
   129.249  1362.635     0.150
   129.249  1446.234     0.150
   129.249  1570.334     0.150
   129.249  1680.535     0.150
   129.249  2308.635     0.150
   129.249  2594.834     0.150
   130.352  1147.234     0.150
   130.352  1149.436     0.150
   130.352  1147.234     0.150
   132.857  1155.234     0.150
   132.857  1299.234     0.150
   132.937  1156.744     0.150
   136.432  1160.834     0.150
   138.308  1167.135     0.150
   140.403  1168.164     0.150
   144.073  1172.135     0.150
   144.238  1175.465     0.150
   146.216  1180.457     0.150
     2.226    37.695     0.150
     2.697    82.465     0.150
     4.164   124.836     0.150
     4.164    64.395     0.150
     4.844    70.805     0.150
     6.344    94.996     0.150
     6.879   185.793     0.150
     6.879   102.566     0.150
     7.663   561.031     0.150
     7.695   112.566     0.150
     7.690   576.754     0.150
    12.676   190.605     0.150
    12.676   182.895     0.150
    13.762   205.766     0.150
    13.975   362.203     0.150
    15.535   215.273     0.150
    15.873   223.094     0.150
    17.006   237.793     0.150
    17.112   240.895     0.150
    18.397   254.293     0.150
    19.113   268.223     0.150
    19.688   271.195     0.150
    20.857   280.496     0.150
    21.158   286.996     0.150
    21.336   291.004     0.150
    21.719   303.164     0.150
    21.788   290.895     0.150
    21.928   305.836     0.150
    21.999   293.695     0.150
    22.189   297.195     0.150
    22.321   298.793     0.150
    22.373   296.293     0.150
    22.387   295.395     0.150
    22.647   298.996     0.150
    23.168   303.895     0.150
    23.663   312.195     0.150
    24.374   315.570     0.150
    24.778   319.395     0.150
    24.778   537.793     0.150
    25.105   324.395     0.150
    25.104   324.895     0.150
    25.390   324.496     0.150
    25.996   349.426     0.150
    25.996   331.695     0.150
    25.996   349.395     0.150
    25.996   540.996     0.150
    26.995   338.996     0.150
    27.164   343.094     0.150
    27.447   343.094     0.150
    27.745   348.895     0.150
    27.745   545.293     0.150
    28.403   556.086     0.150
    28.403   354.496     0.150
    28.403   546.496     0.150
    29.187   358.996     0.150
    29.310   556.793     0.150
    31.670   383.719     0.150
    32.599   564.734     0.150
    34.886   410.695     0.150
    35.116   419.703     0.150
    35.116   411.496     0.150
    35.116   419.695     0.150
    35.453   412.203     0.150
    36.599   433.023     0.150
    36.599   424.094     0.150
    36.599   432.996     0.150
    39.401   453.926     0.150
    41.151   461.895     0.150
    41.151   581.695     0.150
    45.134   493.988     0.150
    45.134   595.691     0.150
    48.340   522.094     0.150
    48.340     6.602     0.150
    48.340   608.496     0.150
    51.557   995.094     0.150
    54.175   565.094     0.150
    55.264   573.293     0.150
    55.522   574.293     0.150
    55.522   634.293     0.150
    56.088  4211.977     0.150
    56.097  4210.516     0.150
    56.105  4212.203     0.150
    56.806   591.113     0.150
    57.641   589.094     0.150
    65.764   645.395     0.150
    65.764   644.020     0.150
    66.021   652.305     0.150
    66.021   644.695     0.150
    66.021   652.293     0.150
    80.712   732.895     0.150
    81.020   735.094     0.150
    82.904   744.793     0.150
    82.904   744.793     0.150
    82.918   744.195     0.150
    83.110   745.094     0.150
    83.110   745.094     0.150
    83.216   744.996     0.150
    83.928   748.496     0.150
    84.401   752.895     0.150
    84.401   752.895     0.150
    84.501   753.395     0.150
    84.501   753.395     0.150
    84.784   754.895     0.150
    84.784   754.895     0.150
    84.835   755.395     0.150
    85.055   756.094     0.150
    85.334   757.996     0.150
    85.496   757.895     0.150
    85.496   757.895     0.150
    85.928   760.793     0.150
    85.994   761.695     0.150
    86.275   762.395     0.150
    86.391   763.695     0.150
    86.574   763.895     0.150
    86.574   763.895     0.150
    86.689   763.496     0.150
    86.689   763.496     0.150
    86.713   764.895     0.150
    86.826   764.895     0.150
    86.826   764.895     0.150
    87.058   764.895     0.150
    87.058   764.895     0.150
    87.491   768.195     0.150
    87.631   767.293     0.150
    87.631   767.293     0.150
    87.766   768.195     0.150
    87.766   768.195     0.150
    88.287   771.094     0.150
    88.287   771.094     0.150
    89.285   775.594     0.150
    89.285   775.594     0.150
    90.034   779.195     0.150
    90.034   779.195     0.150
    90.047   777.914     0.150
    90.612   779.695     0.150
    91.033   784.195     0.150
    91.033   784.195     0.150
    91.194   784.395     0.150
    91.927   788.105     0.150
    95.113   803.895     0.150
    95.518   804.293     0.150
    95.536   804.496     0.150
    95.892   806.793     0.150
    96.086  1162.094     0.150
    96.086  1868.195     0.150
    96.086  2093.293     0.150
    96.616   810.395     0.150
    96.783   810.695     0.150
    96.803   811.793     0.150
    97.447   807.996     0.150
    99.662   822.168     0.150
   115.280  1120.371     0.150
   115.280  1761.668     0.150
   119.503  1138.754     0.150
   119.967  1140.676     0.150
   126.922  1136.695     0.150
   127.250  1734.996     0.150
   144.715  1175.395     0.150
   147.170  1191.703     0.150
     4.141   -84.008     0.150
     4.141   -34.984     0.150
     4.302    69.945     0.150
     4.880    74.383     0.150
     4.880   125.500     0.150
     6.545   496.828     0.150
     6.577   486.938     0.150
    17.155   247.430     0.150
    20.311   278.203     0.150
    20.361   277.055     0.150
    21.191   283.305     0.150
    22.426   306.586     0.150
    32.010   388.805     0.150
    32.010   388.805     0.150
    49.647   536.383     0.150
    57.231  4288.578     0.150
    57.241  4289.281     0.150
    57.248  4289.867     0.150
     1.608    45.625     0.150
     2.072    32.574     0.150
     2.878    43.906     0.150
     3.306    49.055     0.150
     3.594    62.105     0.150
     3.803   109.984     0.150
     4.155   118.883     0.150
     5.007    76.355     0.150
     5.007   130.246     0.150
     6.056    93.227     0.150
     3.214    48.846     0.150
     3.214    86.426     0.150
     3.376    47.806     0.150
     3.568    54.866     0.150
     3.568    95.786     0.150
     5.056    73.876     0.150
    13.318   195.691     0.150
    14.049   203.516     0.150
    14.670   210.331     0.150
    14.866   213.618     0.150
    15.006   215.409     0.150
    18.307   250.926     0.150
    20.956   282.656     0.150
    24.706    17.073     0.150
    24.706    24.088     0.150
    29.772   358.153     0.150
    44.564   484.396     0.150
    44.564    17.020     0.150
    44.564    23.490     0.150
    56.611  4237.862     0.150
    56.620  4209.301     0.150
    56.628  4229.742     0.150
    84.816   747.526     0.150
    86.168   754.606     0.150
    86.267   754.806     0.150
    86.632   756.506     0.150
    86.730   757.106     0.150
    86.984   758.706     0.150
    87.324   759.006     0.150
    90.255   773.906     0.150
   112.717  1105.306     0.150
     1.149    22.137     0.150
     1.149    36.918     0.150
     1.626    31.785     0.150
     1.626    53.676     0.150
     2.391    41.188     0.150
     2.391    68.105     0.150
     2.695    45.734     0.150
     2.815    46.535     0.150
     2.815    78.645     0.150
     2.949    50.746     0.150
     2.949    88.555     0.150
     3.251    53.848     0.150
     3.251    92.656     0.150
     3.276    54.656     0.150
     3.276    93.227     0.150
     3.581    61.395     0.150
     3.581   103.906     0.150
     3.622    59.258     0.150
     3.622   101.156     0.150
     4.492    70.207     0.150
     4.492   120.555     0.150
     5.505    84.895     0.150
     5.505   147.578     0.150
     6.510    99.688     0.150
     6.510   172.586     0.150
     7.224   108.637     0.150
     7.224   190.156     0.150
     0.753    14.561     0.150
     0.753    24.230     0.150
     1.167    21.611     0.150
     1.167    36.172     0.150
     1.773    51.711     0.150
     2.148    34.631     0.150
     2.148    62.191     0.150
     2.432    39.922     0.150
     2.432    68.711     0.150
     2.548    42.072     0.150
     2.862    45.561     0.150
     2.862    76.752     0.150
     3.010    48.361     0.150
     3.010    83.521     0.150
    11.468   169.305     0.150
    11.483   169.119     0.150
    12.734   189.242     0.150
    12.734   186.225     0.150
    12.953   188.729     0.150
    13.360   194.420     0.150
    13.909   204.572     0.150
    14.294   208.852     0.150
    14.877   216.701     0.150
    15.504   226.393     0.150
    16.868   242.521     0.150
    17.066   243.602     0.150
    19.030   258.256     0.150
    19.137   264.406     0.150
    19.368   270.834     0.150
    19.634   272.457     0.150
    20.932   281.053     0.150
    21.104   286.361     0.150
    22.549   301.287     0.150
    29.409   359.096     0.150
    45.274   605.207     0.150
    53.975   568.922     0.150
    55.816   574.551     0.150
    55.890  4203.416     0.150
    55.899  4204.100     0.150
    55.907  4204.705     0.150
     0.710    13.781     0.150
     0.710    23.977     0.150
     1.349    22.438     0.150
     1.349    37.617     0.150
     1.420    25.125     0.150
     1.795    29.047     0.150
     1.795    52.305     0.150
     2.106    34.234     0.150
     2.106    58.234     0.150
     2.546    40.891     0.150
     2.546    71.031     0.150
     2.610    40.227     0.150
     2.610    70.336     0.150
     2.882    36.820     0.150
     2.882    36.820     0.150
     2.949    46.328     0.150
     2.949    79.789     0.150
     3.037    46.125     0.150
     3.188    48.969     0.150
     3.188    88.555     0.150
     3.189    51.211     0.150
     3.375    53.820     0.150
     3.375    90.984     0.150
     3.388    53.180     0.150
     3.388    93.258     0.150
     3.490    57.438     0.150
     3.490    57.438     0.150
     3.511    58.977     0.150
     3.511    58.977     0.150
     3.830    57.500     0.150
     3.830   101.336     0.150
     3.860    61.859     0.150
     3.863    58.719     0.150
     3.863   104.578     0.150
     4.338    65.211     0.150
     4.338   114.047     0.150
     4.725   130.445     0.150
     4.725    70.539     0.150
     4.725   130.445     0.150
     4.981    81.180     0.150
     4.981    81.180     0.150
     5.755    86.078     0.150
     5.755   148.461     0.150
     5.945    84.711     0.150
     6.748    99.297     0.150
     6.748   175.438     0.150
     7.088   103.586     0.150
     9.374   135.367     0.150
    11.030   160.055     0.150
    13.844   215.727     0.150
    14.605   223.430     0.150
    14.852   209.375     0.150
    16.617   243.758     0.150
    21.018   281.977     0.150
    21.360   286.367     0.150
    21.954   285.039     0.150
    22.738   290.430     0.150
    24.189    19.094     0.150
    24.756   329.398     0.150
    24.987    13.906     0.150
    24.987   548.609     0.150
    25.651   321.312     0.150
    28.129   347.648     0.150
    30.109   362.711     0.150
    32.221   381.484     0.150
    32.221   550.656     0.150
    36.252   415.648     0.150
    44.829   604.953     0.150
    54.905   642.359     0.150
    56.294  4206.047     0.150
    56.303  4206.711     0.150
    56.311  4207.531     0.150
    70.824   749.758     0.150
     0.906    15.664     0.150
     0.906    28.055     0.150
     1.038    17.145     0.150
     1.038    32.363     0.150
     2.175    33.895     0.150
     2.175    58.863     0.150
     2.532    41.672     0.150
     2.532    72.984     0.150
     2.976    82.914     0.150
     2.976    47.305     0.150
     2.976    82.914     0.150
     3.142    50.723     0.150
     3.142    90.715     0.150
     3.186    52.863     0.150
     3.186    52.863     0.150
     3.186    92.953     0.150
     3.596    58.102     0.150
     3.596    58.102     0.150
     3.596   102.215     0.150
     3.635    57.645     0.150
     3.635   103.875     0.150
     4.306    64.934     0.150
     4.306   113.164     0.150
     4.670    75.414     0.150
     4.670    75.414     0.150
     4.670   133.484     0.150
     4.681    71.395     0.150
     4.681   128.074     0.150
     5.381    81.215     0.150
     5.381   142.324     0.150
     6.335   163.965     0.150
     7.118   104.398     0.150
     7.118   209.949     0.150
     8.240   606.984     0.150
     9.854   143.762     0.150
     9.854   253.543     0.150
    11.271   163.223     0.150
    11.271   349.672     0.150
    12.033   172.621     0.150
    12.130   176.109     0.150
    12.544   177.375     0.150
    12.544   320.273     0.150
    13.193   184.523     0.150
    13.399   189.246     0.150
    13.785   198.746     0.150
    15.499   219.523     0.150
    16.111   225.535     0.150
    16.111   516.805     0.150
    16.741   529.734     0.150
    16.877   233.293     0.150
    16.877   516.352     0.150
    17.203   550.074     0.150
    18.139   248.633     0.150
    19.985   269.242     0.150
    20.226   271.582     0.150
    20.722   275.273     0.150
    20.857   276.453     0.150
    21.312   284.273     0.150
    21.380   288.895     0.150
    21.464   290.273     0.150
    21.464   290.285     0.150
    21.464   290.348     0.150
    21.832   289.863     0.150
    21.935   293.223     0.150
    22.052   290.043     0.150
    22.113   294.484     0.150
    22.146   294.043     0.150
    22.146   529.535     0.150
    22.517   297.344     0.150
    22.645   301.125     0.150
    23.012   301.902     0.150
    23.563   308.984     0.150
    23.842   311.562     0.150
    23.842   534.254     0.150
    23.985   309.699     0.150
    24.452     9.801     0.150
    24.452   314.465     0.150
    24.452     9.758     0.150
    24.452   534.695     0.150
    24.630   319.047     0.150
    24.630   536.453     0.150
    24.758   317.824     0.150
    24.976     9.340     0.150
    25.079   320.383     0.150
    25.191     8.641     0.150
    25.268   324.055     0.150
    25.371   324.590     0.150
    25.371   324.422     0.150
    25.371   536.625     0.150
    25.417   325.574     0.150
    25.417   325.594     0.150
    25.732   329.422     0.150
    26.001   329.973     0.150
    26.026   331.582     0.150
    26.026     9.223     0.150
    27.048   338.062     0.150
    27.269   342.684     0.150
    27.269   543.445     0.150
    28.519   353.383     0.150
    28.519   545.445     0.150
    28.881   354.582     0.150
    29.255   363.473     0.150
    29.336   358.453     0.150
    29.336   358.453     0.150
    29.336   546.078     0.150
    30.239   365.703     0.150
    30.314   364.832     0.150
    30.349   369.707     0.150
    32.445   387.449     0.150
    32.445   554.723     0.150
    32.498   385.547     0.150
    32.498   553.672     0.150
    32.814   391.844     0.150
    32.814   555.582     0.150
    32.900   388.625     0.150
    34.304   404.520     0.150
    34.404   408.422     0.150
    36.574   422.234     0.150
    36.574     8.590     0.150
    45.157   493.703     0.150
    45.194   491.969     0.150
    45.194     8.398     0.150
    45.194   593.418     0.150
    45.572   495.473     0.150
    45.572     8.750     0.150
    45.984  3422.875     0.150
    47.928   605.574     0.150
    51.939  3874.773     0.150
    52.852   552.574     0.150
    52.852     9.379     0.150
    52.852   622.594     0.150
    53.753   560.594     0.150
    53.753     8.148     0.150
    54.130   562.574     0.150
    54.130     9.125     0.150
    54.199   564.062     0.150
    54.407   564.562     0.150
    54.407     8.699     0.150
    55.322   571.125     0.150
    55.322     8.449     0.150
    55.474   572.922     0.150
    55.474     8.203     0.150
    55.619  4152.074     0.150
    55.718   573.715     0.150
    55.718     8.637     0.150
    55.870  4187.406     0.150
    55.879  4185.047     0.150
    55.888  4185.855     0.150
    56.762   579.223     0.150
    56.762   636.273     0.150
    58.349  4351.574     0.150
    59.224   599.672     0.150
    59.224   647.199     0.150
    61.798  4616.574     0.150
    62.089   617.824     0.150
    62.089     9.574     0.150
    63.088   625.773     0.150
    63.088     9.391     0.150
    65.127   637.672     0.150
    65.523   641.699     0.150
    69.625   668.645     0.150
    69.861   677.973     0.150
    71.061   673.773     0.150
    73.861   700.973     0.150
    73.861   692.793     0.150
    78.003   715.473     0.150
    78.003   724.098     0.150
    80.382   729.047     0.150
    80.382     9.051     0.150
    81.588   736.043     0.150
    81.588     9.309     0.150
    81.588   736.047     0.150
    81.588     9.301     0.150
    81.995   739.375     0.150
    82.104   738.473     0.150
    82.390   741.273     0.150
    82.502   740.574     0.150
    82.502   740.574     0.150
    82.706   741.672     0.150
    82.706   741.672     0.150
    82.982   743.773     0.150
    82.982   743.773     0.150
    84.003   748.773     0.150
    84.003   748.773     0.150
    84.107   749.273     0.150
    84.107   749.273     0.150
    84.389   750.473     0.150
    84.389   750.473     0.150
    84.594   749.574     0.150
    84.594   749.602     0.150
    84.594    11.371     0.150
    84.834   753.223     0.150
    84.834     8.727     0.150
    85.087   753.875     0.150
    85.087   753.875     0.150
    85.125   754.223     0.150
    85.125     8.902     0.150
    85.191   753.574     0.150
    85.435   763.273     0.150
    85.435   763.273     0.150
    85.608   756.973     0.150
    85.608   756.973     0.150
    86.141   759.773     0.150
    86.141   759.773     0.150
    86.271   760.074     0.150
    86.271   760.074     0.150
    86.450   760.973     0.150
    86.450   760.973     0.150
    86.582   761.309     0.150
    86.582    10.078     0.150
    86.607   761.672     0.150
    86.644   761.773     0.150
    86.644   761.773     0.150
    86.644   761.773     0.150
    86.708   762.172     0.150
    86.708   762.172     0.150
    86.716   761.973     0.150
    86.716   761.973     0.150
    86.794   761.773     0.150
    86.794   761.773     0.150
    87.016   763.273     0.150
    87.016   763.273     0.150
    87.147   764.172     0.150
    87.147   764.172     0.150
    87.147   764.172     0.150
    87.232   764.273     0.150
    87.232   764.273     0.150
    87.244   764.172     0.150
    87.244   764.172     0.150
    87.249   765.672     0.150
    87.370   765.172     0.150
    87.438   766.875     0.150
    87.595   765.473     0.150
    87.610   765.875     0.150
    87.610   765.875     0.150
    87.711   765.773     0.150
    87.862   767.875     0.150
    87.862   767.875     0.150
    87.978   767.473     0.150
    88.590   770.074     0.150
    88.590   770.074     0.150
    88.661   771.172     0.150
    88.874   772.273     0.150
    88.874   772.273     0.150
    88.970   771.672     0.150
    88.970   771.672     0.150
    88.978   771.672     0.150
    88.978   771.672     0.150
    88.987   772.594     0.150
    88.987     8.328     0.150
    89.032   772.172     0.150
    89.032   772.172     0.150
    89.626   775.273     0.150
    89.626   775.273     0.150
    89.931   777.473     0.150
    89.931   777.473     0.150
    90.281   778.473     0.150
    90.281   778.473     0.150
    90.381   776.473     0.150
    90.718   780.172     0.150
    90.718   780.172     0.150
    90.748   779.223     0.150
    90.748     8.902     0.150
    90.848   800.273     0.150
    90.848   788.672     0.150
    91.089   791.375     0.150
    91.089   782.773     0.150
    91.090   782.773     0.150
    91.090   782.773     0.150
    91.284   792.641     0.150
    91.482   781.172     0.150
    91.580   793.465     0.150
    91.580   784.875     0.150
    91.580   793.473     0.150
    92.283   795.973     0.150
    92.283   788.875     0.150
    92.371   797.074     0.150
    92.371   788.375     0.150
    92.500   788.723     0.150
    92.500     8.902     0.150
    92.889   799.074     0.150
    92.889   790.574     0.150
    93.141   800.375     0.150
    93.141   792.375     0.150
    93.861   795.309     0.150
    93.861     8.926     0.150
    94.114   796.383     0.150
    94.114     8.961     0.150
    94.261   805.723     0.150
    94.403   805.773     0.150
    94.403   798.074     0.150
    94.938   799.973     0.150
    94.957   799.797     0.150
    94.957     9.277     0.150
    95.154   810.344     0.150
    97.308   819.273     0.150
    98.857   816.973     0.150
    98.857     8.926     0.150
    98.857  1057.023     0.150
    98.857  1805.574     0.150
    99.365   827.273     0.150
    99.365   827.223     0.150
    99.365   827.223     0.150
   101.217   838.453     0.150
   101.217   829.422     0.150
   101.217   838.449     0.150
   109.303  1773.672     0.150
   109.532  1770.613     0.150
   109.603  1781.797     0.150
   115.298  1117.852     0.150
   115.298  1752.504     0.150
   115.298  1117.848     0.150
   115.298  1752.500     0.150
   120.724  1138.973     0.150
   120.724  1152.273     0.150
   121.235  1130.422     0.150
   121.235  1140.047     0.150
   122.680  1235.273     0.150
   122.680  1643.375     0.150
   126.646  1141.133     0.150
   126.658  1141.125     0.150
   126.658  1150.875     0.150
   127.143  1141.152     0.150
   127.143  1141.156     0.150
   127.487  1133.422     0.150
   127.487  1133.422     0.150
   127.487  1142.625     0.150
   127.487  1152.023     0.150
   134.559  1157.559     0.150
   138.125  1163.074     0.150
   150.632  1189.074     0.150
   151.088  1192.074     0.150
   151.088  1192.102     0.150
     0.249     8.078     0.150
     0.249    14.156     0.150
     1.941    29.957     0.150
     1.941    52.367     0.150
     1.941    31.117     0.150
     1.941    54.738     0.150
     2.225    35.137     0.150
     2.225    59.887     0.150
     2.778    42.547     0.150
     2.778    74.816     0.150
     3.573    52.656     0.150
     3.573    93.309     0.150
     7.298   524.672     0.150
     7.327   546.855     0.150
    10.765   156.383     0.150
    10.765   336.906     0.150
    11.591   167.895     0.150
    14.245   201.223     0.150
    16.598   239.328     0.150
    16.598   239.332     0.150
    16.598   513.859     0.150
    19.106   262.656     0.150
    20.577   275.078     0.150
    20.897   277.574     0.150
    20.966   278.172     0.150
    23.770   310.270     0.150
    24.258   311.484     0.150
    24.746   317.957     0.150
    24.746   534.043     0.150
    31.134   372.844     0.150
    45.631   493.559     0.150
    48.915   523.184     0.150
    52.909   553.727     0.150
    53.273   555.332     0.150
    54.569   564.109     0.150
    54.569   626.508     0.150
    56.655  4241.695     0.150
    56.664  4243.863     0.150
    56.672  4242.984     0.150
    77.743   712.207     0.150
    80.670    11.898     0.150
    80.670   729.559     0.150
    80.670    11.898     0.150
    84.286   747.059     0.150
    84.382   747.656     0.150
    84.666   748.859     0.150
    85.027   749.781     0.150
    85.150   750.914     0.150
    85.269   752.207     0.150
    86.510   758.559     0.150
    86.603   758.758     0.150
    86.683   759.156     0.150
    86.966   760.156     0.150
    87.019   761.258     0.150
    87.071   761.457     0.150
    87.517   763.258     0.150
    87.534   763.258     0.150
    87.649   763.758     0.150
    88.228   766.359     0.150
    88.991   769.957     0.150
    89.214   772.258     0.150
    89.234   772.457     0.150
    89.234   772.457     0.150
    89.310   771.656     0.150
    95.803   804.359     0.150
    95.803   804.359     0.150
   125.826  1138.160     0.150
   125.826  1150.883     0.150
   126.708  1139.809     0.150
   126.708  1151.906     0.150
   137.259  1160.387     0.150
     0.483     9.656     0.150
     0.483    17.352     0.150
     1.441    23.953     0.150
     1.441    42.281     0.150
     2.252    38.750     0.150
     2.252    70.539     0.150
     2.433    41.555     0.150
     3.359    52.930     0.150
     3.359    92.766     0.150
     4.186    64.969     0.150
     4.186   116.812     0.150
     4.854    72.516     0.150
     4.854   127.930     0.150
     7.647   565.219     0.150
     7.675   569.984     0.150
     7.711   568.055     0.150
    11.261   163.375     0.150
    11.261   351.688     0.150
    12.309   176.891     0.150
    12.309   379.609     0.150
    14.735   212.602     0.150
    15.561   223.305     0.150
    17.129   538.484     0.150
    19.139   265.945     0.150
    23.064   304.195     0.150
    23.641   310.258     0.150
    23.915   310.195     0.150
    24.356   319.516     0.150
    24.401   315.391     0.150
    24.972   324.305     0.150
    25.284   325.664     0.150
    25.284   539.203     0.150
    25.470   326.516     0.150
    25.641   325.922     0.150
    32.294   388.336     0.150
    32.294   556.062     0.150
    32.621   388.766     0.150
    45.151   494.109     0.150
    53.827   561.836     0.150
    55.140   571.961     0.150
    55.140   632.859     0.150
    56.078  4209.266     0.150
    56.087  4206.422     0.150
    56.095  4210.555     0.150
    78.153   718.898     0.150
    80.758   732.664     0.150
    83.137   742.266     0.150
    83.410   743.266     0.150
    84.428   753.062     0.150
    84.528   753.664     0.150
    84.811   755.062     0.150
    85.320   756.984     0.150
    85.396   756.547     0.150
    85.430   756.859     0.150
    85.523   758.461     0.150
    86.068   761.266     0.150
    86.601   764.164     0.150
    86.716   763.664     0.150
    86.852   764.062     0.150
    87.085   765.062     0.150
    87.106   766.523     0.150
    87.149   765.164     0.150
    87.166   766.664     0.150
    87.793   768.359     0.150
    88.314   772.164     0.150
    92.889   791.188     0.150
    95.538   805.461     0.150
   126.061  1143.352     0.150
   137.846  1166.359     0.150
     2.081    28.543     0.150
     3.414    47.793     0.150
    13.068   188.228     0.150
    13.299   189.249     0.150
    19.044   263.966     0.150
    20.142   270.883     0.150
    21.764   291.191     0.150
    22.121   293.785     0.150
    45.522  3385.813     0.150
    51.710  3858.813     0.150
    55.243  4114.313     0.150
    87.977   765.803     0.150
     0.964    16.266     0.150
     0.964    28.615     0.150
     1.090    18.676     0.150
     1.090    32.396     0.150
     1.681    28.916     0.150
     1.681    52.217     0.150
     2.341    36.217     0.150
     2.341    62.086     0.150
     2.609    40.326     0.150
     2.609    70.855     0.150
     2.688    41.506     0.150
     2.688    73.615     0.150
     2.821    43.426     0.150
     2.821    74.977     0.150
     3.142    49.217     0.150
     3.142    84.986     0.150
     3.150    48.887     0.150
     3.150    84.986     0.150
     3.589    55.695     0.150
     3.589    97.467     0.150
     4.720    70.256     0.150
     4.720   124.035     0.150
     8.165   574.348     0.150
     0.786    14.675     0.150
     0.786    25.245     0.150
     1.145    19.215     0.150
     1.145    33.255     0.150
     1.869    29.935     0.150
     1.869    54.415     0.150
     2.056    32.415     0.150
     2.056    57.064     0.150
     2.459    71.845     0.150
     2.438    38.955     0.150
     2.438    68.245     0.150
     2.486    38.654     0.150
     2.486    67.734     0.150
     2.575    41.015     0.150
     2.575    71.765     0.150
     3.095    88.345     0.150
     3.095    46.715     0.150
     3.095    88.345     0.150
     3.077    47.135     0.150
     3.077    84.455     0.150
     3.137    47.784     0.150
     3.137    85.654     0.150
     3.309    52.694     0.150
     3.309    93.965     0.150
     3.534    55.265     0.150
     3.534    96.595     0.150
     3.637    54.645     0.150
     3.637    97.165     0.150
     3.754    56.185     0.150
     4.599    66.185     0.150
    20.847   279.255     0.150
    21.509   288.425     0.150
    55.432   568.614     0.150
   113.590  1108.515     0.150
     0.779    18.072     0.150
     0.779    28.982     0.150
     0.940    17.992     0.150
     0.940    31.512     0.150
     1.961    31.932     0.150
     2.044    33.122     0.150
     3.193    48.742     0.150
     3.320    50.572     0.150
     3.320    87.452     0.150
     6.213    86.822     0.150
     7.553   547.457     0.150
    14.181   202.446     0.150
    15.885   218.952     0.150
    17.425   236.892     0.150
    17.573   237.972     0.150
    20.880   276.022     0.150
    24.244   307.378     0.150
    24.368    21.750     0.150
    24.368    33.150     0.150
    24.368    21.110     0.150
    24.368    32.511     0.150
    24.434   309.109     0.150
    24.497   309.382     0.150
    24.513   309.554     0.150
    25.665   321.322     0.150
    27.419   337.019     0.150
    30.408   363.232     0.150
    54.261    23.450     0.150
     0.943    17.375     0.150
     0.943    29.195     0.150
     1.109    20.066     0.150
     1.109    32.906     0.150
     1.646    28.285     0.150
     1.691    29.047     0.150
     1.691    48.996     0.150
     2.361    37.344     0.150
     2.361    64.766     0.150
     2.631    44.594     0.150
     2.631    44.594     0.150
     2.631    71.547     0.150
     2.709    42.637     0.150
     2.709    74.074     0.150
     2.787    39.766     0.150
     2.787    39.766     0.150
     2.787    71.285     0.150
     2.800    42.887     0.150
     2.800    75.453     0.150
     3.169    42.996     0.150
     5.785    79.426     0.150
     7.069    98.484     0.150
    17.965   247.703     0.150
    18.446   248.438     0.150
    18.452   248.684     0.150
    18.898   259.305     0.150
    19.077   253.531     0.150
    19.092   254.188     0.150
    19.467   263.746     0.150
    20.113   268.594     0.150
    20.928   275.355     0.150
    21.486   283.355     0.150
    21.856   287.336     0.150
    21.860   287.086     0.150
    23.049   300.105     0.150
    24.503   313.875     0.150
    25.118   319.766     0.150
    53.735   556.414     0.150
    58.185   588.406     0.150
   113.226  1107.125     0.150
   113.226  1157.426     0.150
   113.226  1519.926     0.150
   113.226  1560.727     0.150
   122.439  1124.625     0.150
   122.439  1162.625     0.150
     1.574    42.937     0.150
     2.587    74.816     0.150
     2.587    43.097     0.150
     4.358    73.746     0.150
     6.845   509.093     0.150
     6.875   509.394     0.150
     6.904   514.888     0.150
     6.990   110.406     0.150
    10.732   155.347     0.150
    11.739   164.666     0.150
    12.393   181.562     0.150
    12.393   181.086     0.150
    12.393   181.046     0.150
    13.383   194.422     0.150
    13.421   195.767     0.150
    13.421   195.746     0.150
    14.481   209.547     0.150
    14.481   207.847     0.150
    14.521   208.086     0.150
    15.108   217.046     0.150
    16.400   232.095     0.150
    16.395   232.597     0.150
    16.509   232.546     0.150
    16.706   228.477     0.150
    16.706   228.446     0.150
    17.911   248.438     0.150
    18.306   249.847     0.150
    18.841   256.985     0.150
    18.841   256.946     0.150
    19.127   263.003     0.150
    19.186   263.306     0.150
    19.238   266.122     0.150
    19.629   267.646     0.150
    19.851     6.641     0.150
    19.999   277.239     0.150
    20.327   276.866     0.150
    20.365   273.146     0.150
    21.212   285.446     0.150
    21.237   286.646     0.150
    21.322   286.747     0.150
    21.385   287.847     0.150
    21.385   287.847     0.150
    21.475   288.606     0.150
    21.475   288.646     0.150
    21.488   288.847     0.150
    21.667   292.948     0.150
    21.718   291.087     0.150
    21.750   296.087     0.150
    21.870   293.972     0.150
    22.273   293.546     0.150
    22.427   294.386     0.150
    22.427   294.347     0.150
    22.512   301.276     0.150
    22.526   298.517     0.150
    22.572   296.747     0.150
    22.952   303.946     0.150
    22.918    25.141     0.150
    23.389   304.536     0.150
    23.389   304.546     0.150
    23.943   313.747     0.150
    24.520   315.847     0.150
    24.799   318.646     0.150
    25.191   321.546     0.150
    25.383   323.847     0.150
    25.458   328.706     0.150
    25.493   326.847     0.150
    25.535   329.206     0.150
    25.600   329.337     0.150
    25.583   325.886     0.150
    25.758   331.267     0.150
    25.979   332.747     0.150
    26.828   337.847     0.150
    26.972   340.847     0.150
    27.610   345.507     0.150
    27.610   345.546     0.150
    30.766   376.847     0.150
    31.238   377.796     0.150
    32.238   384.146     0.150
    32.399   390.606     0.150
    35.614   416.347     0.150
    36.130   418.546     0.150
    40.767   457.446     0.150
    45.101   873.747     0.150
    45.101  3375.946     0.150
    49.243   528.366     0.150
    49.243   611.077     0.150
    49.243   528.347     0.150
    49.243   611.046     0.150
    51.459  3857.847     0.150
    52.797   553.747     0.150
    53.157   555.046     0.150
    53.203   556.747     0.150
    53.403   558.146     0.150
    54.511   566.247     0.150
    54.827  4104.747     0.150
    57.454  4301.747     0.150
    57.457   585.087     0.150
    57.515  4306.747     0.150
    63.396   628.196     0.150
    63.396   628.247     0.150
    65.089   637.946     0.150
    66.549   649.296     0.150
    66.549   649.347     0.150
    69.906   668.046     0.150
    70.938   673.446     0.150
    72.896   685.946     0.150
    82.739   739.546     0.150
    82.878   744.446     0.150
    83.030   744.146     0.150
    85.340   756.247     0.150
    90.822   780.446     0.150
    92.928   790.946     0.150
    95.161   801.946     0.150
    95.522   800.347     0.150
    95.932   805.146     0.150
    96.844   809.247     0.150
     0.452     9.359     0.150
     0.452    15.320     0.150
     1.465    25.344     0.150
     1.465    43.258     0.150
     2.455    38.570     0.150
     2.455    75.680     0.150
     2.733    43.273     0.150
     2.733    75.141     0.150
     3.333    59.328     0.150
     3.758    60.609     0.150
     4.189    77.211     0.150
     4.180    65.000     0.150
     4.180   112.273     0.150
     4.880    73.992     0.150
     5.987    91.109     0.150
     6.369   155.461     0.150
     6.915   102.891     0.150
     7.630   561.953     0.150
     7.657   565.820     0.150
     7.693   571.156     0.150
    10.495   147.094     0.150
    11.220   339.945     0.150
    12.663   183.211     0.150
    13.465   191.414     0.150
    14.702   208.664     0.150
    15.532   218.430     0.150
    15.843   224.914     0.150
    16.993   236.711     0.150
    17.981   519.500     0.150
    18.393   253.109     0.150
    18.348   256.109     0.150
    18.746   260.523     0.150
    19.407   265.008     0.150
    19.654   480.992     0.150
    19.654   269.914     0.150
    19.654   481.008     0.150
    20.001   274.344     0.150
    20.321   274.508     0.150
    20.580   276.961     0.150
    20.778   282.508     0.150
    20.841   281.164     0.150
    20.841   281.211     0.150
    20.854   282.250     0.150
    20.896   282.805     0.150
    21.004   284.109     0.150
    21.124   286.508     0.150
    21.288   285.492     0.150
    21.766   291.711     0.150
    21.899   293.711     0.150
    21.971   293.508     0.150
    22.157   296.711     0.150
    22.283   298.211     0.150
    22.287   298.312     0.150
    22.330   297.961     0.150
    22.368   295.508     0.150
    22.388   295.312     0.150
    23.176   303.930     0.150
    23.176   303.914     0.150
    23.274   305.414     0.150
    23.386   309.312     0.150
    23.499   310.531     0.150
    23.499   310.508     0.150
    23.635   311.773     0.150
    23.635   311.812     0.150
    23.812   528.805     0.150
    24.379   315.734     0.150
    24.379   315.711     0.150
    24.714   322.812     0.150
    24.778   319.898     0.150
    24.778   319.914     0.150
    24.752   322.312     0.150
    24.769   322.414     0.150
    24.880   326.680     0.150
    25.077   323.414     0.150
    25.070   324.062     0.150
    25.070   324.109     0.150
    25.152   323.602     0.150
    25.176   323.508     0.150
    25.205   324.867     0.150
    25.243   791.672     0.150
    25.389   325.609     0.150
    25.458   329.109     0.150
    25.976   331.711     0.150
    26.778   341.508     0.150
    26.988   339.414     0.150
    26.988   339.414     0.150
    27.010   342.273     0.150
    27.138   342.109     0.150
    27.223   344.062     0.150
    27.453   343.711     0.150
    27.453   343.711     0.150
    27.476   345.461     0.150
    27.714   349.008     0.150
    27.931   347.672     0.150
    28.073   350.812     0.150
    28.252   351.008     0.150
    28.377   354.211     0.150
    28.698   354.711     0.150
    28.680   358.055     0.150
    28.909   359.242     0.150
    28.982   357.578     0.150
    29.012   358.289     0.150
    29.186   359.570     0.150
    29.186   359.609     0.150
    29.219   359.562     0.150
    29.280   362.008     0.150
    29.658   363.211     0.150
    29.929   365.633     0.150
    30.074   368.859     0.150
    29.964   361.570     0.150
    30.126   367.070     0.150
    30.355   371.555     0.150
    30.681   373.148     0.150
    31.215   377.133     0.150
    31.463   382.609     0.150
    32.253  1014.211     0.150
    32.253   386.609     0.150
    32.253   557.812     0.150
    32.253  1014.211     0.150
    32.584   389.008     0.150
    32.584  1018.188     0.150
    32.584   389.008     0.150
    32.584  1018.211     0.150
    32.557   391.914     0.150
    32.911   395.312     0.150
    33.023   394.531     0.150
    33.219   394.000     0.150
    33.776   399.812     0.150
    34.915   411.711     0.150
    34.915   563.508     0.150
    35.998   419.812     0.150
    36.069   418.414     0.150
    36.151   420.008     0.150
    36.580   424.312     0.150
    36.815   426.211     0.150
    37.830   433.750     0.150
    37.984   435.320     0.150
    37.984   434.203     0.150
    38.418   440.531     0.150
    38.835   444.570     0.150
    39.094   442.812     0.150
    39.371   450.281     0.150
    40.148   449.852     0.150
    40.214   454.250     0.150
    41.135   462.312     0.150
    41.478   460.141     0.150
    45.368   500.023     0.150
    45.797   501.211     0.150
    45.863   500.258     0.150
    46.193   505.367     0.150
    48.376   523.508     0.150
    49.387   527.305     0.150
    51.159   544.109     0.150
    51.669   615.789     0.150
    51.553  3855.109     0.150
    51.805   547.914     0.150
    51.741   548.812     0.150
    53.516   560.711     0.150
    53.557   561.312     0.150
    53.786   562.008     0.150
    53.818   563.648     0.150
    53.818   563.609     0.150
    53.941   563.914     0.150
    54.145   565.008     0.150
    55.022   572.008     0.150
    55.022   634.109     0.150
    55.233   573.414     0.150
    55.109   576.508     0.150
    55.109  4123.109     0.150
    55.185  4123.508     0.150
    55.493   574.609     0.150
    56.788   581.969     0.150
    57.847   595.711     0.150
    58.246   594.578     0.150
    58.827   819.609     0.150
    58.827   596.609     0.150
    58.827   819.609     0.150
    59.182   598.938     0.150
    59.182   598.812     0.150
    59.524   604.812     0.150
    60.125   605.664     0.150
    60.125   605.609     0.150
    61.022   651.812     0.150
    61.640   616.414     0.150
    65.310   641.414     0.150
    65.795   647.008     0.150
    66.770   645.414     0.150
    69.351   666.750     0.150
    69.351   666.711     0.150
    70.078   671.055     0.150
    70.078   671.008     0.150
    70.225   672.609     0.150
    71.210   677.508     0.150
    73.620   961.609     0.150
    76.975   713.914     0.150
    78.585  1373.109     0.150
    79.986   728.609     0.150
    80.592   731.602     0.150
    80.714   733.312     0.150
    80.697   921.711     0.150
    81.219   736.609     0.150
    81.766   738.711     0.150
    81.766  1349.914     0.150
    81.869  1691.109     0.150
    82.068   740.312     0.150
    82.068  1352.914     0.150
    82.355  1702.109     0.150
    82.467  1708.711     0.150
    82.463  1702.109     0.150
    82.547   742.711     0.150
    82.547  1358.008     0.150
    82.868  1709.914     0.150
    82.888   745.055     0.150
    82.937   742.508     0.150
    83.114  1718.008     0.150
    83.144   744.953     0.150
    83.570   746.984     0.150
    83.901   749.008     0.150
    84.214  6358.227     0.150
    84.222  6324.695     0.150
    84.232  6358.359     0.150
    84.757  6384.312     0.150
    84.758  6397.492     0.150
    84.773  6411.875     0.150
    85.066   756.711     0.150
    85.361   756.008     0.150
    85.400   757.508     0.150
    85.601   758.008     0.150
    85.690   758.742     0.150
    86.611   762.812     0.150
    86.677   763.812     0.150
    87.041   764.203     0.150
    88.136   770.914     0.150
    88.136   770.914     0.150
    88.648   773.914     0.150
    88.721   773.211     0.150
    88.805  1100.711     0.150
    88.805  1761.711     0.150
    89.029   773.609     0.150
    89.373   776.109     0.150
    90.017   787.312     0.150
    90.154   779.312     0.150
    90.165   781.008     0.150
    90.165  1114.008     0.150
    90.319   781.109     0.150
    90.491   782.211     0.150
    90.485  1807.711     0.150
    91.035   784.914     0.150
    91.196  1000.711     0.150
    91.196  1000.711     0.150
    91.196  1533.711     0.150
    91.196  2061.711     0.150
    91.196   784.711     0.150
    91.447   786.414     0.150
    91.447   795.609     0.150
    91.447  1002.211     0.150
    91.447  1418.812     0.150
    91.447  1511.914     0.150
    91.929   788.414     0.150
    91.929  1003.711     0.150
    91.929  1421.711     0.150
    91.929  1447.711     0.150
    91.929  1809.711     0.150
    91.983   780.109     0.150
    91.983  1136.711     0.150
    91.983  2037.609     0.150
    92.314   788.812     0.150
    92.314  1010.812     0.150
    92.314  1423.414     0.150
    92.314  1530.414     0.150
    92.450   790.914     0.150
    92.450  1009.508     0.150
    92.450  1522.109     0.150
    92.485   790.078     0.150
    92.502   797.508     0.150
    92.502  1009.008     0.150
    92.621   791.711     0.150
    92.621  1011.312     0.150
    92.621  1524.109     0.150
    92.646   791.961     0.150
    92.646   791.914     0.150
    92.646   805.711     0.150
    92.646  1011.508     0.150
    92.646  1522.711     0.150
    92.646  1824.711     0.150
    92.724   791.914     0.150
    92.724   801.711     0.150
    92.724  1012.008     0.150
    92.724  1523.812     0.150
    92.724  1828.109     0.150
    92.865   792.508     0.150
    92.898   793.109     0.150
    92.898  1013.711     0.150
    92.898  1829.008     0.150
    93.197  1014.383     0.150
    93.197   794.008     0.150
    93.197  1014.414     0.150
    93.197  1428.508     0.150
    93.234   794.508     0.150
    93.234  1014.609     0.150
    93.234  1529.914     0.150
    93.486   795.711     0.150
    93.486  1537.609     0.150
    93.616  1434.609     0.150
    93.616   796.211     0.150
    93.616   807.508     0.150
    93.616  1018.812     0.150
    93.616  1535.008     0.150
    94.213   799.508     0.150
    94.460   800.609     0.150
    94.586   798.898     0.150
    94.689   799.508     0.150
    94.689  1028.609     0.150
    94.689  1436.211     0.150
    94.746   801.414     0.150
    94.746   811.414     0.150
    94.746  1025.109     0.150
    94.810   800.352     0.150
    94.912   801.508     0.150
    94.912  1033.914     0.150
    94.912  1437.914     0.150
    95.112   804.008     0.150
    95.116   804.609     0.150
    95.115   803.312     0.150
    95.386   803.508     0.150
    95.386  1034.711     0.150
    95.386  1440.008     0.150
    95.546   803.711     0.150
    95.564   805.812     0.150
    95.687  1187.711     0.150
    95.687  1491.711     0.150
    95.687  1887.711     0.150
    95.687  2147.711     0.150
    95.746  1033.508     0.150
    95.746  1435.508     0.150
    95.746   802.414     0.150
    95.746  1033.508     0.150
    95.746  1435.414     0.150
    95.847   807.711     0.150
    95.893   807.008     0.150
    95.897   805.312     0.150
    96.125   808.008     0.150
    96.125  1039.812     0.150
    96.125  1480.008     0.150
    96.409  1559.711     0.150
    96.409  1857.711     0.150
    96.409  2103.711     0.150
    96.409   807.711     0.150
    96.409  1039.711     0.150
    96.409  1445.711     0.150
    96.409  1483.711     0.150
    96.409  1559.711     0.150
    96.409  2103.711     0.150
    96.540   810.414     0.150
    96.617   810.711     0.150
    96.805   812.211     0.150
    97.108   810.609     0.150
    97.234   812.711     0.150
    97.234  1049.414     0.150
    97.234  1449.609     0.150
    97.234  1581.812     0.150
    97.645  1178.711     0.150
    97.779   810.008     0.150
    98.873   819.211     0.150
    99.010   821.008     0.150
    99.134   822.312     0.150
    99.134   822.312     0.150
    99.263  1059.609     0.150
    99.381   816.609     0.150
    99.381  1190.211     0.150
    99.381  1451.414     0.150
    99.535   818.812     0.150
    99.660   821.414     0.150
    99.680   829.109     0.150
    99.680   829.109     0.150
    99.804   825.008     0.150
   100.177  1085.828     0.150
   101.026   828.711     0.150
   101.276   830.812     0.150
   101.571   833.414     0.150
   102.037  1059.711     0.150
   102.037  1079.711     0.150
   102.037   833.711     0.150
   102.037  1079.711     0.150
   102.037  1471.711     0.150
   102.037  1631.711     0.150
   102.110   834.609     0.150
   102.933   838.312     0.150
   107.747  1264.109     0.150
   107.747  1490.008     0.150
   107.747  2274.711     0.150
   109.320  1136.164     0.150
   109.630   868.414     0.150
   109.723  1280.609     0.150
   109.723  2308.711     0.150
   110.702  2324.609     0.150
   111.491  1114.211     0.150
   111.491  1152.711     0.150
   111.899  1113.914     0.150
   113.443  2129.312     0.150
   113.443  2361.414     0.150
   114.046   898.211     0.150
   114.046  1172.812     0.150
   115.259  1120.633     0.150
   115.259  1179.414     0.150
   115.259  1757.883     0.150
   115.259  1120.609     0.150
   115.259  1179.414     0.150
   115.259  1757.914     0.150
   115.301  1127.211     0.150
   118.820  1128.914     0.150
   118.820  1128.914     0.150
   119.539  1130.312     0.150
   120.467  1221.914     0.150
   120.686  1132.914     0.150
   120.686  1132.914     0.150
   122.694  1147.312     0.150
   124.039  1149.312     0.150
   126.045  1143.414     0.150
   127.114  1145.211     0.150
   128.429  1146.812     0.150
   128.429  1272.211     0.150
   129.667  1149.914     0.150
   131.051  1289.609     0.150
   131.290  1152.312     0.150
   131.599  1153.609     0.150
   131.851  1154.711     0.150
   132.377  1155.688     0.150
   132.719  1155.680     0.150
   132.813  1156.391     0.150
   134.697  1160.750     0.150
   135.008  1165.688     0.150
   137.426  1164.812     0.150
   137.426  1164.812     0.150
   137.504  1167.078     0.150
   137.504  1162.812     0.150
   137.806  1337.445     0.150
   141.957  1167.680     0.150
   142.743  1183.211     0.150
   142.743  1166.742     0.150
   143.479  1173.750     0.150
   149.655  1199.211     0.150
   150.176  1186.508     0.150
   150.176  1192.109     0.150
     0.211     5.369     0.150
     0.211     8.988     0.150
     1.819    29.029     0.150
     1.819    53.578     0.150
     2.123    33.180     0.150
     2.566    75.010     0.150
     2.566    75.010     0.150
     3.054    47.529     0.150
     3.391    52.898     0.150
     3.856    64.350     0.150
     3.856   115.520     0.150
     4.268   129.238     0.150
     4.510   137.658     0.150
     4.510   137.658     0.150
     4.701    71.709     0.150
     4.701   143.270     0.150
     4.817   141.090     0.150
     5.537   168.840     0.150
     5.537   168.840     0.150
     5.523    81.680     0.150
     5.523   179.439     0.150
     6.629    98.988     0.150
     6.629   196.279     0.150
     6.999   532.479     0.150
     7.027   538.725     0.150
     7.060   542.053     0.150
    13.530   196.539     0.150
    13.539   197.189     0.150
    16.002   227.072     0.150
    18.436   253.564     0.150
    18.465   256.951     0.150
    19.830   269.115     0.150
    21.331   284.545     0.150
    21.465   290.689     0.150
    21.539   287.830     0.150
    21.918   295.619     0.150
    22.525   296.986     0.150
    24.590   317.760     0.150
    24.882   536.969     0.150
    25.175   324.459     0.150
    25.325   325.809     0.150
    25.494   327.078     0.150
    39.131   442.414     0.150
    45.095  3383.510     0.150
    51.371  3853.709     0.150
    54.747  4107.010     0.150
    54.819  4111.607     0.150
    55.040   570.021     0.150
    61.031  4580.311     0.150
    65.256   640.609     0.150
    95.260   802.609     0.150
   114.966  1117.691     0.150
     0.679    13.336     0.150
     0.679    22.711     0.150
     1.360    22.586     0.150
     1.360    39.062     0.150
     1.418    25.422     0.150
     1.831    54.305     0.150
     2.179    34.914     0.150
     2.179    61.164     0.150
     2.530    38.664     0.150
     2.530    69.305     0.150
     2.623    40.320     0.150
     2.623    69.969     0.150
     2.907    46.430     0.150
     2.907    78.422     0.150
     2.978    46.281     0.150
     2.978    80.445     0.150
     3.191    48.391     0.150
     3.191    86.242     0.150
     3.408    47.773     0.150
    10.108   141.266     0.150
    10.245   142.492     0.150
    16.447   225.359     0.150
    18.738   253.891     0.150
    18.918   253.922     0.150
    20.526   272.773     0.150
    20.646   276.500     0.150
    84.997   748.344     0.150
   120.305  1153.242     0.150
     1.425    21.203     0.150
     1.425    21.203     0.150
     1.425    39.289     0.150
     2.502    36.688     0.150
     2.502    64.102     0.150
     2.537    39.539     0.150
     2.537    69.703     0.150
     2.738    77.945     0.150
     2.738    77.945     0.150
     3.247    51.047     0.150
     3.247    87.148     0.150
     3.379    78.242     0.150
     3.379    50.805     0.150
     3.379    78.242     0.150
     3.773    54.742     0.150
     4.009    64.547     0.150
     4.052    65.547     0.150
     4.112    60.945     0.150
     4.112   111.508     0.150
     4.171    62.367     0.150
     4.171   111.242     0.150
     4.186    64.945     0.150
     4.355   122.844     0.150
     4.526    68.547     0.150
     4.526   125.945     0.150
     4.526    68.547     0.150
     4.526   125.945     0.150
     4.583    68.688     0.150
     4.583   135.078     0.150
     4.631    70.227     0.150
     4.633    70.266     0.150
     5.013    75.344     0.150
     5.013   136.648     0.150
     5.013    75.344     0.150
     5.013   136.648     0.150
     5.165    74.242     0.150
     5.165   134.789     0.150
     6.200   187.438     0.150
     6.200    91.016     0.150
     6.200   187.438     0.150
     6.669   499.281     0.150
     6.699   499.094     0.150
     6.728   493.797     0.150
     6.731   102.445     0.150
     6.982   200.148     0.150
     6.982   102.812     0.150
     6.982   200.148     0.150
     7.158   163.984     0.150
     7.158   220.422     0.150
     8.481   210.305     0.150
     9.013   128.719     0.150
    12.422   303.867     0.150
    12.422   178.547     0.150
    12.422   303.844     0.150
    12.422   178.531     0.150
    13.494   189.742     0.150
    13.646   326.445     0.150
    14.567   348.812     0.150
    15.020   212.945     0.150
    15.020   213.031     0.150
    15.551   216.664     0.150
    16.466   231.367     0.150
    16.730   231.945     0.150
    16.730   231.938     0.150
    17.437   242.547     0.150
    17.437   242.477     0.150
    17.681   510.773     0.150
    17.711   411.484     0.150
    18.369   250.547     0.150
    18.661   254.133     0.150
    18.725   258.742     0.150
    19.002   260.531     0.150
    19.274   264.266     0.150
    19.657   266.266     0.150
    19.978   271.148     0.150
    20.061   273.148     0.150
    20.217   273.648     0.150
    20.347   274.852     0.150
    20.452   273.742     0.150
    20.452   273.664     0.150
    20.490   274.242     0.150
    20.903   277.039     0.150
    21.205   283.242     0.150
    21.259   284.148     0.150
    21.284   285.945     0.150
    21.360   286.922     0.150
    21.378   286.844     0.150
    21.493   283.234     0.150
    21.797   287.312     0.150
    22.184   294.938     0.150
    22.316   295.680     0.150
    22.334   293.445     0.150
    22.513   294.648     0.150
    22.513   294.711     0.150
    22.637   296.148     0.150
    22.879   299.406     0.150
    22.879   299.445     0.150
    22.988   524.289     0.150
    22.990   299.117     0.150
    23.257   302.844     0.150
    23.326   303.008     0.150
    23.353   303.484     0.150
    23.362   303.594     0.150
    23.503   304.844     0.150
    23.503   304.859     0.150
    23.536   303.812     0.150
    23.804   310.945     0.150
    24.105   524.602     0.150
    24.105   312.406     0.150
    24.152   314.344     0.150
    24.151   311.844     0.150
    24.151   311.844     0.150
    24.316   317.062     0.150
    24.341   315.648     0.150
    24.349   311.484     0.150
    24.591   531.055     0.150
    24.591   531.672     0.150
    24.620   319.148     0.150
    24.622   315.945     0.150
    24.881   319.148     0.150
    24.881   535.945     0.150
    25.460   324.148     0.150
    25.471   323.547     0.150
    25.516   323.242     0.150
    25.544   325.055     0.150
    25.868   534.984     0.150
    25.868   330.945     0.150
    25.868   534.945     0.150
    26.449   333.086     0.150
    26.482   336.047     0.150
    26.881   339.148     0.150
    26.876   336.242     0.150
    26.927   338.562     0.150
    27.077   336.898     0.150
    27.164   340.445     0.150
    27.677   343.617     0.150
    27.703   345.047     0.150
    27.714   343.547     0.150
    28.104   348.141     0.150
    28.116   348.844     0.150
    28.116   348.867     0.150
    28.210   347.039     0.150
    28.497   352.547     0.150
    29.368   359.695     0.150
    29.368   360.633     0.150
    29.761   363.586     0.150
    30.360   367.969     0.150
    30.514   373.297     0.150
    30.597   371.648     0.150
    30.828   371.328     0.150
    30.850   372.719     0.150
    30.923   375.242     0.150
    30.923   376.773     0.150
    31.007   376.383     0.150
    31.007   376.383     0.150
    31.062   377.156     0.150
    31.232   378.312     0.150
    31.334   378.703     0.150
    31.406   380.258     0.150
    31.470   377.516     0.150
    31.510   379.547     0.150
    31.510   552.148     0.150
    31.734   381.547     0.150
    31.743   381.266     0.150
    31.922   381.453     0.150
    31.922   382.398     0.150
    32.167   383.117     0.150
    32.187   386.438     0.150
    32.247   383.844     0.150
    32.325   388.758     0.150
    33.068   392.422     0.150
    33.511   398.023     0.150
    33.658   398.414     0.150
    35.786   416.148     0.150
    40.771   457.047     0.150
    47.465   511.312     0.150
    49.386   527.148     0.150
    50.346   535.742     0.150
    52.733   553.242     0.150
    52.931   553.312     0.150
    53.097   554.344     0.150
    53.112   555.547     0.150
    53.310   556.844     0.150
    53.337   556.547     0.150
    53.471   618.469     0.150
    54.210   563.648     0.150
    54.425   564.844     0.150
    54.702    16.203     0.150
    54.816   566.766     0.150
    56.344   575.945     0.150
    57.495   633.555     0.150
    61.240   612.648     0.150
    63.537   627.242     0.150
    65.014   635.648     0.150
    65.123   637.844     0.150
    65.123   637.844     0.150
    65.301   638.422     0.150
    66.647   648.742     0.150
    69.949   668.648     0.150
    70.961   673.742     0.150
    77.804   721.148     0.150
    77.804  1298.648     0.150
    77.804   726.344     0.150
    77.942   712.148     0.150
    79.720   719.844     0.150
    79.748   730.242     0.150
    79.744   722.648     0.150
    80.272   726.797     0.150
    80.272   726.844     0.150
    80.839   729.445     0.150
    81.063   732.789     0.150
    81.673   735.547     0.150
    82.193   738.648     0.150
    82.995   742.547     0.150
    82.995  1362.344     0.150
    83.097   745.648     0.150
    83.182  6255.617     0.150
    83.156   743.945     0.150
    83.156   743.844     0.150
    83.190  6257.914     0.150
    83.201  6256.766     0.150
    83.307   744.648     0.150
    83.364   745.844     0.150
    83.633   748.242     0.150
    83.730  6293.930     0.150
    83.730  6295.648     0.150
    83.745  6296.797     0.150
    85.146   752.844     0.150
    85.370   754.648     0.150
    85.373   754.344     0.150
    85.461   756.047     0.150
    85.540   756.836     0.150
    85.666   760.148     0.150
    85.989   761.742     0.150
    86.782   760.945     0.150
    88.317   768.844     0.150
    89.217    18.102     0.150
    89.217   980.445     0.150
    90.742   778.406     0.150
    90.742   778.445     0.150
    90.868   780.148     0.150
    91.312   795.445     0.150
    91.312  1535.445     0.150
    91.312  1885.445     0.150
    91.312  2053.445     0.150
    91.312  2239.445     0.150
    91.312   782.445     0.150
    91.312   795.445     0.150
    91.312   999.445     0.150
    91.443   791.602     0.150
    91.583   785.148     0.150
    92.046   999.445     0.150
    92.046   785.445     0.150
    92.046  1414.445     0.150
    92.046  1443.445     0.150
    92.046  1513.445     0.150
    92.046  1811.445     0.150
    92.792     7.398     0.150
    92.792  1013.844     0.150
    92.792   788.844     0.150
    92.851  1417.242     0.150
    92.851   790.148     0.150
    92.851  1009.547     0.150
    92.851  1417.242     0.150
    93.014   789.547     0.150
    93.014   789.547     0.150
    93.024  1541.945     0.150
    93.344     6.203     0.150
    93.344   792.742     0.150
    93.596     6.500     0.150
    93.596   793.742     0.150
    93.596  1018.547     0.150
    93.748   794.445     0.150
    94.337   797.344     0.150
    94.570   796.055     0.150
    94.570   796.047     0.150
    95.245   801.945     0.150
    95.246   802.445     0.150
    95.247   801.445     0.150
    95.554  1029.547     0.150
    95.554   800.445     0.150
    95.554  1029.648     0.150
    95.953   805.742     0.150
    96.014   804.844     0.150
    96.136   806.047     0.150
    96.210   805.547     0.150
    96.926   808.945     0.150
    97.651   807.344     0.150
    97.738   823.445     0.150
    99.126   818.242     0.150
    99.276   819.742     0.150
    99.734   822.945     0.150
    99.888   819.547     0.150
   101.243   828.445     0.150
   101.243   828.445     0.150
   101.293   828.844     0.150
   101.679   830.047     0.150
   102.099  1141.445     0.150
   102.099  1477.445     0.150
   102.099  1659.445     0.150
   103.025   834.344     0.150
   103.256   829.344     0.150
   103.256   829.344     0.150
   109.762  1106.492     0.150
   112.325  1123.344     0.150
   112.325  1197.047     0.150
   112.325  1625.445     0.150
   113.353  2359.648     0.150
   114.712  1115.844     0.150
   119.080  1123.844     0.150
   119.215  1126.047     0.150
   119.630  1120.242     0.150
   119.630  1156.742     0.150
   119.630  2175.344     0.150
   120.301  1129.242     0.150
   121.467  1129.242     0.150
   125.239  1241.516     0.150
   126.756  1141.148     0.150
   127.999  1127.289     0.150
   127.999  1127.242     0.150
   127.999  1142.344     0.150
   128.591  1144.344     0.150
   129.416  1142.242     0.150
   129.863  1148.547     0.150
   132.042  1150.648     0.150
   132.042  1150.648     0.150
   136.601  1156.172     0.150
   136.601  1156.148     0.150
   136.900  1155.297     0.150
   136.923  1148.938     0.150
   138.136  1161.148     0.150
   138.136  1161.094     0.150
   143.063  1164.445     0.150
   146.418  1179.133     0.150
     0.733    14.146     0.150
     0.733    24.727     0.150
     1.358    22.736     0.150
     1.358    39.535     0.150
     1.759    52.125     0.150
     1.759    29.695     0.150
     1.759    52.125     0.150
     2.138    35.006     0.150
     2.138    59.885     0.150
     2.615    40.336     0.150
     2.615    71.486     0.150
     2.872    45.525     0.150
     2.872    78.736     0.150
     2.934    46.756     0.150
     2.934    80.727     0.150
     3.367    52.715     0.150
     3.367    91.906     0.150
     3.930    60.506     0.150
     3.930   105.635     0.150
     4.726    70.256     0.150
     4.726   124.266     0.150
    10.884   148.859     0.150
     0.794    14.641     0.150
     0.794    25.261     0.150
     1.154    31.671     0.150
     1.154    18.691     0.150
     1.154    31.671     0.150
     1.818    32.471     0.150
     1.818    61.721     0.150
     1.974    33.591     0.150
     2.061    32.831     0.150
     2.061    61.851     0.150
     2.419    74.871     0.150
     2.419    39.401     0.150
     2.419    74.871     0.150
     2.548    41.421     0.150
     3.044    48.571     0.150
     3.456    54.361     0.150
     3.500    55.781     0.150
     3.500    55.751     0.150
     3.728    57.311     0.150
     4.190    63.321     0.150
     4.190    63.321     0.150
     4.712    71.931     0.150
     5.684    84.591     0.150
     6.219    92.231     0.150
     8.354   608.874     0.150
     8.382   609.962     0.150
     8.417   613.335     0.150
     9.096   215.571     0.150
     9.418   137.881     0.150
     9.418   137.881     0.150
     9.701   139.251     0.150
     9.739   140.791     0.150
     9.739   140.791     0.150
     9.990   144.811     0.150
    10.236   249.151     0.150
    10.451   148.141     0.150
    10.451   148.141     0.150
    11.318  2386.603     0.150
    11.318   163.551     0.150
    12.560   179.651     0.150
    13.177   186.251     0.150
    14.518   204.357     0.150
    15.243   213.088     0.150
    15.865   221.671     0.150
    16.892   233.951     0.150
    17.259   241.751     0.150
    17.259   241.722     0.150
    17.259   241.952     0.150
    18.126   248.251     0.150
    18.368   255.251     0.150
    18.368   255.381     0.150
    18.631   254.888     0.150
    19.121   262.073     0.150
    19.193   261.059     0.150
    19.235   265.641     0.150
    19.235   265.241     0.150
    19.242   262.611     0.150
    19.955   269.051     0.150
    20.206   271.370     0.150
    20.608   275.673     0.150
    20.797   278.651     0.150
    20.866   280.721     0.150
    21.015   279.622     0.150
    21.129   280.893     0.150
    21.174   282.044     0.150
    22.022   290.351     0.150
    22.103   291.151     0.150
    22.280   295.493     0.150
    22.587   298.441     0.150
    22.692   296.951     0.150
    22.997   300.951     0.150
    23.380   308.060     0.150
    23.399   308.661     0.150
    23.696   306.700     0.150
    23.791   314.431     0.150
    23.913   312.451     0.150
    23.941   309.651     0.150
    24.096   317.371     0.150
    24.423   314.351     0.150
    24.423   314.394     0.150
    24.590   315.739     0.150
    24.718   547.015     0.150
    25.053   320.351     0.150
    25.103   324.251     0.150
    25.225   324.651     0.150
    25.267   547.977     0.150
    25.267   325.071     0.150
    25.267   325.051     0.150
    25.429   547.351     0.150
    25.429  2303.851     0.150
    25.509   326.951     0.150
    25.813   330.451     0.150
    26.041   330.851     0.150
    27.026   337.207     0.150
    27.241   339.204     0.150
    27.327   343.851     0.150
    27.377   353.851     0.150
    27.377   353.851     0.150
    27.558   348.531     0.150
    27.640   345.064     0.150
    27.616   342.403     0.150
    27.859   348.531     0.150
    28.063   349.551     0.150
    28.078   347.074     0.150
    28.200   348.118     0.150
    28.500   350.681     0.150
    28.500   350.651     0.150
    28.500   544.351     0.150
    28.529   355.841     0.150
    28.579   354.251     0.150
    28.579   545.751     0.150
    28.757   354.646     0.150
    28.753   353.421     0.150
    28.857   354.351     0.150
    28.875   357.171     0.150
    28.974   365.151     0.150
    28.974   365.151     0.150
    29.095   361.831     0.150
    29.250   357.042     0.150
    29.264   361.831     0.150
    29.334   363.161     0.150
    29.424   556.859     0.150
    29.424   360.921     0.150
    29.424   360.951     0.150
    29.397   364.481     0.150
    29.580   361.391     0.150
    29.580   361.351     0.150
    29.551   362.491     0.150
    30.036   360.105     0.150
    29.713   365.811     0.150
    29.768   366.481     0.150
    30.198   373.121     0.150
    30.265   371.791     0.150
    30.458   373.121     0.150
    30.736   375.781     0.150
    30.747   375.781     0.150
    30.843   377.111     0.150
    31.843   383.751     0.150
    31.936   554.421     0.150
    32.513   564.967     0.150
    32.513   388.251     0.150
    32.517   564.276     0.150
    32.892   392.651     0.150
    34.197   404.051     0.150
    34.197   557.251     0.150
    35.702   414.051     0.150
    36.397   420.751     0.150
    36.608   422.251     0.150
    37.113   426.391     0.150
    37.699   436.371     0.150
    38.115   441.651     0.150
    38.376   434.511     0.150
    38.924   584.212     0.150
    38.924   445.251     0.150
    39.487   451.301     0.150
    39.615   453.461     0.150
    39.717   457.281     0.150
    41.085   459.651     0.150
    41.358   474.151     0.150
    41.694   465.651     0.150
    45.243   604.096     0.150
    45.243  2764.063     0.150
    46.127   503.451     0.150
    47.824   516.351     0.150
    47.824   516.351     0.150
    47.824   516.411     0.150
    50.024   622.247     0.150
    50.162   533.251     0.150
    50.251   535.051     0.150
    50.497   535.951     0.150
    51.480   544.451     0.150
    51.866   547.891     0.150
    51.866   547.851     0.150
    51.866   617.551     0.150
    51.983  3879.151     0.150
    53.389   558.721     0.150
    53.828   560.851     0.150
    53.957   561.011     0.150
    53.991   561.151     0.150
    54.486   564.651     0.150
    55.341   572.051     0.150
    55.395   641.701     0.150
    55.549   573.651     0.150
    55.692   574.951     0.150
    55.692  4151.151     0.150
    55.772  4156.851     0.150
    55.786   575.751     0.150
    56.791   579.651     0.150
    58.365  4351.551     0.150
    58.420  4355.651     0.150
    58.507   593.978     0.150
    58.825   596.611     0.150
    59.122   598.351     0.150
    61.516   612.451     0.150
    61.778   615.041     0.150
    61.861  4615.151     0.150
    61.986   617.301     0.150
    61.986   617.351     0.150
    62.974   625.101     0.150
    62.974     9.650     0.150
    64.097   632.171     0.150
    65.127   637.951     0.150
    65.362   638.360     0.150
    65.362   641.960     0.150
    65.362   647.719     0.150
    65.362   651.523     0.150
    65.362   660.152     0.150
    65.444   641.171     0.150
    65.444   641.151     0.150
    65.726   631.969     0.150
    65.726   873.396     0.150
    65.726  1313.584     0.150
    66.485   646.651     0.150
    66.672   653.151     0.150
    67.369   652.651     0.150
    67.574   654.391     0.150
    68.318   651.860     0.150
    68.318   752.704     0.150
    68.318   815.501     0.150
    68.318  1100.151     0.150
    68.318  1210.034     0.150
    68.318  1237.941     0.150
    68.317   657.293     0.150
    68.317   668.075     0.150
    68.317   676.588     0.150
    68.317   695.286     0.150
    68.611   661.891     0.150
    68.611   661.851     0.150
    69.854   666.551     0.150
    69.854   666.651     0.150
    70.159   659.562     0.150
    70.159   757.935     0.150
    70.159   830.377     0.150
    70.159  1300.823     0.150
    71.067   674.051     0.150
    81.162   733.251     0.150
    81.329   744.351     0.150
    81.349   744.251     0.150
    81.473   744.751     0.150
    81.515   737.051     0.150
    81.515   745.151     0.150
    81.521   745.151     0.150
    81.521   734.651     0.150
    81.521   920.351     0.150
    81.521  1344.351     0.150
    81.521  1661.551     0.150
    81.557   745.251     0.150
    81.586   736.851     0.150
    81.808   746.451     0.150
    81.850   746.651     0.150
    81.862   739.251     0.150
    81.862   746.951     0.150
    81.899   747.451     0.150
    81.932   747.151     0.150
    81.985   739.651     0.150
    81.985   747.751     0.150
    81.985   737.251     0.150
    81.985   924.251     0.150
    81.985  1349.451     0.150
    82.085   748.151     0.150
    82.105   748.051     0.150
    82.120   740.151     0.150
    82.120   750.451     0.150
    82.120   741.511     0.150
    82.142   748.051     0.150
    82.325   749.051     0.150
    82.340   749.251     0.150
    82.359   749.751     0.150
    82.376   741.051     0.150
    82.376   750.751     0.150
    82.553   739.651     0.150
    82.553   750.951     0.150
    82.792   738.771     0.150
    83.419   741.551     0.150
    83.985   751.659     0.150
    84.010   747.701     0.150
    84.115   747.901     0.150
    84.115     9.290     0.150
    84.358   753.071     0.150
    84.531   751.851     0.150
    85.106   753.651     0.150
    85.438   754.251     0.150
    86.197   758.951     0.150
    86.332   759.651     0.150
    86.508   764.576     0.150
    86.593   759.551     0.150
    87.119   761.810     0.150
    87.228   767.051     0.150
    87.662   773.981     0.150
    87.717   766.451     0.150
    88.565   770.151     0.150
    88.709   770.151     0.150
    88.943   771.951     0.150
    89.403   780.619     0.150
    89.813   776.651     0.150
    89.900   776.851     0.150
    90.031   777.951     0.150
    90.319   997.451     0.150
    90.319  1804.751     0.150
    90.319  2013.451     0.150
    90.586   784.201     0.150
    90.632   781.951     0.150
    90.738   779.351     0.150
    90.738     9.700     0.150
    90.813   781.951     0.150
    90.813  1001.651     0.150
    90.813   781.951     0.150
    90.813  1410.651     0.150
    90.904   791.651     0.150
    91.052   791.751     0.150
    91.052   782.351     0.150
    91.052  1412.351     0.150
    91.052  1504.251     0.150
    91.063   782.751     0.150
    91.545   793.781     0.150
    91.545  1002.651     0.150
    91.545   784.351     0.150
    91.545   793.751     0.150
    91.545  1002.651     0.150
    91.545  1410.651     0.150
    91.545  1438.651     0.150
    92.065   796.351     0.150
    92.065   787.151     0.150
    92.065  1418.051     0.150
    92.065  1511.251     0.150
    92.245   797.351     0.150
    92.245   787.151     0.150
    92.245  1417.751     0.150
    92.245  1514.851     0.150
    92.245  1817.051     0.150
    92.335   797.651     0.150
    92.335  1412.051     0.150
    92.335   787.751     0.150
    92.335  1412.051     0.150
    92.335  1517.551     0.150
    92.335  1825.851     0.150
    92.462   788.851     0.150
    92.509   798.451     0.150
    92.509   789.251     0.150
    92.509  1413.251     0.150
    92.509  1518.951     0.150
    92.653   792.151     0.150
    92.822   790.451     0.150
    92.822     9.800     0.150
    92.855   800.151     0.150
    92.855   790.851     0.150
    92.855  1420.551     0.150
    92.855  1525.751     0.150
    93.107   801.651     0.150
    93.107   791.451     0.150
    93.107  1420.051     0.150
    93.107  1528.951     0.150
    93.224   801.751     0.150
    93.224   791.851     0.150
    93.224  1418.051     0.150
    93.224  1526.251     0.150
    93.224  1831.651     0.150
    93.505   795.351     0.150
    93.505   803.351     0.150
    93.505   795.351     0.150
    93.825   795.151     0.150
    93.851   795.051     0.150
    94.080   796.551     0.150
    94.165   794.828     0.150
    94.198   805.801     0.150
    94.370   796.201     0.150
    94.370   796.251     0.150
    94.369   807.251     0.150
    94.369   797.351     0.150
    94.369  1430.651     0.150
    94.369  1543.051     0.150
    94.369  1843.851     0.150
    94.432   806.561     0.150
    94.510   798.651     0.150
    94.564   798.851     0.150
    94.697   801.693     0.150
    94.708   808.351     0.150
    94.852   799.411     0.150
    94.852   799.451     0.150
    95.019   800.351     0.150
    95.019     8.300     0.150
    95.111   809.581     0.150
    95.392   809.651     0.150
    95.485   805.663     0.150
    95.485   805.663     0.150
    95.753   804.051     0.150
    95.753     9.300     0.150
    96.115   804.651     0.150
    96.191   813.743     0.150
    96.418   807.251     0.150
    96.537   814.751     0.150
    96.702   808.687     0.150
    96.895   812.251     0.150
    96.895  1897.651     0.150
    96.874   809.151     0.150
    96.874     8.900     0.150
    97.275   819.051     0.150
    97.427  1172.051     0.150
    97.625   820.851     0.150
    98.515   817.551     0.150
    98.627   816.851     0.150
    98.736   817.451     0.150
    99.028   824.251     0.150
    99.028  1058.551     0.150
    99.136   817.951     0.150
    99.136   817.851     0.150
    99.136   826.951     0.150
    99.154   827.251     0.150
    99.154   827.251     0.150
    99.338   828.051     0.150
    99.338   818.651     0.150
    99.341   818.651     0.150
    99.429   828.451     0.150
   100.802   837.171     0.150
   100.919   835.251     0.150
   100.919   835.251     0.150
   100.917   838.071     0.150
   101.042   837.441     0.150
   101.192   828.451     0.150
   101.293   838.831     0.150
   101.364   838.951     0.150
   101.364   838.951     0.150
   101.416   839.521     0.150
   101.479   824.351     0.150
   101.479   827.351     0.150
   101.685   838.651     0.150
   101.685   838.651     0.150
   101.685  1211.651     0.150
   101.685  1465.651     0.150
   101.685  1615.651     0.150
   101.793   838.551     0.150
   101.870   841.731     0.150
   101.976   828.951     0.150
   102.164   826.351     0.150
   102.171   823.551     0.150
   102.562  1815.751     0.150
   102.562   833.851     0.150
   102.576   841.151     0.150
   103.094   836.351     0.150
   103.190   836.651     0.150
   103.320   829.251     0.150
   106.960   861.051     0.150
   108.049  1775.619     0.150
   108.890   863.051     0.150
   110.077   878.151     0.150
   110.077   897.451     0.150
   110.077  1147.951     0.150
   113.184  2354.951     0.150
   115.339  1118.051     0.150
   115.339  1128.133     0.150
   115.342  1118.151     0.150
   115.731  1119.251     0.150
   118.781  1125.451     0.150
   118.781  1125.451     0.150
   119.101  1125.341     0.150
   119.541  1127.351     0.150
   119.676  1127.141     0.150
   119.676  1208.331     0.150
   120.124  1128.451     0.150
   120.267  1210.151     0.150
   120.335  1128.511     0.150
   120.335  1128.551     0.150
   120.801  1221.751     0.150
   120.798  1130.251     0.150
   121.679  1122.151     0.150
   121.827  1132.051     0.150
   122.817  1134.151     0.150
   126.759  1710.026     0.150
   127.038  1142.451     0.150
   127.583  1130.621     0.150
   127.584  1707.936     0.150
   128.406  1144.051     0.150
   128.512  1132.371     0.150
   130.712  1282.051     0.150
   132.461  1150.651     0.150
   132.461  1294.851     0.150
   133.522  1141.151     0.150
   133.751  1142.651     0.150
   133.849  1142.451     0.150
   133.855  1141.251     0.150
   133.867  1143.251     0.150
   134.059  1142.551     0.150
   134.470  1143.551     0.150
   134.545  1155.951     0.150
   134.664  1145.031     0.150
   136.720  1152.651     0.150
   137.907  1162.751     0.150
   138.212  1154.031     0.150
   138.212  1154.031     0.150
   138.235  1154.141     0.150
   138.745  1155.451     0.150
   138.961  1159.701     0.150
   140.410  1158.841     0.150
   140.497  1159.571     0.150
   141.005  1180.751     0.150
   141.718  1164.311     0.150
   141.718  1164.351     0.150
   143.455  1168.691     0.150
   143.463  1167.211     0.150
   143.440  1171.081     0.150
   144.751  1403.651     0.150
   145.629  1177.491     0.150
   148.912  1182.731     0.150
   148.912  1182.731     0.150
   148.912  1185.681     0.150
   148.912  1185.681     0.150
   148.912  1182.751     0.150
   148.912  1182.751     0.150
   150.736  1184.451     0.150
   150.736  1189.751     0.150
   154.408  1187.690     0.150
   154.682  1185.519     0.150
   154.682  1190.451     0.150
   154.682  1201.551     0.150
     0.081     3.820     0.150
     0.081     6.133     0.150
     1.963    30.980     0.150
     1.963    53.934     0.150
     1.983    33.230     0.150
     1.983    57.133     0.150
     7.145   537.586     0.150
    11.042   275.398     0.150
    15.612   223.309     0.150
    18.454   253.289     0.150
    19.195   268.293     0.150
    19.253   264.980     0.150
    19.801   267.621     0.150
    20.221   272.000     0.150
    22.042   295.973     0.150
    22.196   294.984     0.150
    22.237   294.879     0.150
    24.995   320.980     0.150
     0.701    24.785     0.150
     0.701    13.527     0.150
     0.701    24.785     0.150
     1.349    37.574     0.150
     1.349    21.465     0.150
     1.349    37.574     0.150
     2.543    40.477     0.150
     2.543    71.574     0.150
     2.615    40.516     0.150
     2.615    73.867     0.150
    15.409   218.621     0.150
    18.678   258.887     0.150
    20.870   281.664     0.150
    21.020   280.969     0.150
    22.153   291.656     0.150
     0.125    14.055     0.150
     0.361    14.648     0.150
     1.114    22.125     0.150
     1.114    38.422     0.150
     1.309    40.250     0.150
     1.862    28.984     0.150
     1.862    28.984     0.150
     1.862    51.453     0.150
     2.314    38.055     0.150
     2.314    37.992     0.150
     2.314    65.609     0.150
     2.592    40.914     0.150
     2.592    71.328     0.150
     2.723    42.711     0.150
     2.723    75.375     0.150
     3.321    50.914     0.150
     3.321    89.711     0.150
     3.536    92.484     0.150
     3.536    52.703     0.150
     3.536    52.898     0.150
     3.536    92.484     0.150
     3.625    56.219     0.150
     3.764    58.016     0.150
     3.967    59.766     0.150
     3.967    99.812     0.150
     4.092    61.891     0.150
     4.092   124.828     0.150
     4.138    63.422     0.150
     4.322    65.094     0.150
     4.347    66.078     0.150
    12.626   175.742     0.150
    14.566   203.039     0.150
    15.715   221.086     0.150
    19.329   260.969     0.150
    20.052   266.875     0.150
    20.182   268.445     0.150
    20.335    22.078     0.150
    20.905   278.180     0.150
    21.056   279.914     0.150
    21.056   277.273     0.150
    21.532   285.930     0.150
    21.532   283.562     0.150
    21.574   286.453     0.150
    21.747   287.734     0.150
    21.747   285.734     0.150
    22.057   291.578     0.150
    22.199   291.172     0.150
    22.357   293.820     0.150
    22.589   293.398     0.150
    22.627   294.094     0.150
    22.858    22.000     0.150
    23.501    22.773     0.150
    23.854    23.570     0.150
    24.774   314.375     0.150
    25.247   318.383     0.150
    29.081   352.211     0.150
    29.628   357.945     0.150
    30.511   364.805     0.150
    30.942   370.094     0.150
    30.942   370.094     0.150
    30.942   370.094     0.150
    31.067   371.883     0.150
    31.116   372.852     0.150
    31.120   370.094     0.150
    31.182   373.016     0.150
    31.182   374.359     0.150
    31.209   371.883     0.150
    31.589   375.969     0.150
    32.229   379.031     0.150
    32.229   379.031     0.150
    32.628   384.391     0.150
    32.649   382.602     0.150
    32.649   382.602     0.150
    33.618   391.859     0.150
    35.392   407.820     0.150
    53.653   548.664     0.150
    67.251   642.945     0.150
    79.776   716.750     0.150
   119.012  1159.023     0.150
     0.756    14.967     0.150
     1.272    24.457     0.150
     1.997    31.508     0.150
     2.399    37.667     0.150
     3.165    51.867     0.150
     3.165    89.938     0.150
     3.336    51.128     0.150
     3.336    90.448     0.150
     4.456    67.117     0.150
     4.429    84.818     0.150
     4.429   136.157     0.150
    15.765   223.957     0.150
    17.163   241.268     0.150
    17.403   242.897     0.150
    18.212   252.818     0.150
    20.267   275.467     0.150
    55.837  4182.391     0.150
    55.845  4188.004     0.150
    55.854  4185.346     0.150
     0.950    17.504     0.150
     0.950    30.344     0.150
     0.966    17.953     0.150
     0.966    31.145     0.150
     1.462    23.934     0.150
     1.462    41.461     0.150
     1.885    32.371     0.150
     1.885    32.371     0.150
     1.958    31.754     0.150
     1.958    55.781     0.150
     2.221    36.004     0.150
     2.221    62.664     0.150
     2.630    41.324     0.150
     2.630    72.344     0.150
     2.907    48.031     0.150
     3.267    49.562     0.150
     3.267    88.973     0.150
     3.851    60.703     0.150
     7.208   193.180     0.150
     8.151   611.383     0.150
     8.178   614.352     0.150
    20.073   270.453     0.150
    23.225   306.973     0.150
    23.269   305.973     0.150
    55.819  4196.695     0.150
    55.828  4198.609     0.150
    55.836  4188.391     0.150
    56.867   584.602     0.150
     0.442    18.781     0.150
     0.442    10.168     0.150
     0.442    18.781     0.150
     1.218    22.699     0.150
     1.245    22.078     0.150
     1.609    24.480     0.150
     1.609    48.180     0.150
     1.989    33.309     0.150
     1.989    60.828     0.150
     2.439    36.809     0.150
     2.439    36.809     0.150
     2.439    72.520     0.150
     2.877    42.590     0.150
     2.877    85.770     0.150
     3.171    54.309     0.150
     3.171    94.059     0.150
     3.236    51.469     0.150
     3.236    94.289     0.150
     3.415   105.719     0.150
     3.415    51.750     0.150
     4.226    63.168     0.150
     4.226   111.141     0.150
    28.025   352.801     0.150
     0.089     3.861     0.150
     0.089     6.421     0.150
     1.230    22.861     0.150
     1.733    30.121     0.150
     1.966    61.841     0.150
     1.979    32.921     0.150
     2.901    49.501     0.150
     2.901    88.441     0.150
     2.930    45.891     0.150
     3.181    51.531     0.150
     3.246    50.651     0.150
     3.649    65.911     0.150
     3.640    61.551     0.150
     3.640   106.571     0.150
     3.735    58.601     0.150
     3.724    58.921     0.150
     3.807    58.071     0.150
     3.799   113.751     0.150
     3.799    62.781     0.150
     4.169    68.651     0.150
     4.283    69.111     0.150
     4.283    69.111     0.150
     4.283   125.311     0.150
     4.299    70.861     0.150
     4.372    66.151     0.150
     4.405    71.341     0.150
     4.489    63.091     0.150
     4.565   140.241     0.150
     4.625   136.441     0.150
     4.683   131.131     0.150
     4.682   129.771     0.150
     4.682    70.991     0.150
     5.767    86.921     0.150
     6.055   178.931     0.150
     6.233   193.601     0.150
     6.795   101.761     0.150
     6.996   102.711     0.150
     6.996   214.131     0.150
     7.130   550.333     0.150
     7.429   204.561     0.150
     7.429   109.621     0.150
     7.571   109.021     0.150
     7.879   121.441     0.150
     8.230   221.191     0.150
     8.230   119.541     0.150
     9.944   265.211     0.150
    13.557   191.658     0.150
    13.557   190.941     0.150
    18.452   253.201     0.150
    18.727   256.851     0.150
    19.634   266.411     0.150
    20.455   273.229     0.150
    21.582   288.611     0.150
    21.773   291.211     0.150
    21.871   294.031     0.150
    22.118   294.041     0.150
    22.198   294.641     0.150
    24.610   320.501     0.150
    24.812   321.721     0.150
    24.983   322.991     0.150
    25.647   327.621     0.150
    25.794   330.711     0.150
    25.949   333.081     0.150
    26.041   332.671     0.150
    27.622   347.431     0.150
    28.500   355.361     0.150
    28.494   356.091     0.150
    29.906   366.271     0.150
    30.595   371.511     0.150
    30.765   375.792     0.150
    30.822   371.633     0.150
    31.298   376.991     0.150
    32.053   385.171     0.150
    33.347   398.481     0.150
    36.105   418.251     0.150
    45.155  3382.811     0.150
    50.572   539.011     0.150
    50.817   541.711     0.150
    51.948   549.081     0.150
    52.676   554.541     0.150
    53.174   558.111     0.150
    54.803  4108.611     0.150
    54.877  4115.811     0.150
    56.262   579.991     0.150
    56.473  4236.461     0.150
    56.482  4238.036     0.150
    56.490  4237.056     0.150
    61.072  4578.611     0.150
    61.970   620.114     0.150
    70.723   670.591     0.150
    82.949   745.811     0.150
    84.244  6382.585     0.150
    84.244  6402.425     0.150
    84.259  6383.675     0.150
    91.329  1546.811     0.150
    91.329  1864.811     0.150
    93.432   794.003     0.150
    94.722   799.954     0.150
    94.939   800.827     0.150
     0.558     8.564     0.150
     0.558    14.404     0.150
     0.727    11.785     0.150
     0.727    18.215     0.150
     0.727    11.785     0.150
     0.811    19.004     0.150
     0.811    32.244     0.150
     1.216    21.625     0.150
     1.216    37.484     0.150
     1.734    56.004     0.150
     1.734    32.186     0.150
     1.734    56.004     0.150
     2.102    34.244     0.150
     2.102    58.064     0.150
     2.925    43.105     0.150
     2.925    75.525     0.150
     3.070    46.895     0.150
     3.070    87.346     0.150
     3.212    47.004     0.150
     3.212    81.355     0.150
     3.212    47.004     0.150
     3.212    81.355     0.150
     3.820    57.234     0.150
     3.820    57.234     0.150
     3.820   100.285     0.150
     3.930    57.395     0.150
     3.930    98.475     0.150
     3.960    57.846     0.150
    18.061   249.906     0.150
    18.064   255.842     0.150
    18.581   260.635     0.150
    18.580   255.607     0.150
    18.621   262.785     0.150
    19.890   270.102     0.150
    20.626   278.123     0.150
    21.179   284.035     0.150
    21.619   290.516     0.150
    21.531   288.408     0.150
    22.015   296.225     0.150
    22.286   300.016     0.150
    22.286   297.049     0.150
    23.505   317.061     0.150
    24.057   315.035     0.150
    23.985   316.174     0.150
    24.984   325.715     0.150
    25.364   328.715     0.150
    25.918   330.635     0.150
    26.860   340.686     0.150
    47.751   514.234     0.150
    47.751   514.645     0.150
    53.664   562.686     0.150
    57.600  4311.160     0.150
    57.609  4312.418     0.150
    57.617  4311.479     0.150
    64.180   632.391     0.150
    65.252   638.754     0.150
    67.303   652.965     0.150
     0.559    10.750     0.150
     0.730    13.602     0.150
     0.730    23.570     0.150
     0.957    18.297     0.150
     0.957    18.242     0.150
     2.025    35.703     0.150
     2.025    59.531     0.150
     2.205    37.773     0.150
     2.294    39.477     0.150
     2.294    68.594     0.150
     2.642    40.781     0.150
     2.642    72.320     0.150
     3.326    58.203     0.150
     3.326   102.062     0.150
     3.518    54.008     0.150
     3.518    95.008     0.150
     3.973    66.633     0.150
     3.973   122.461     0.150
     4.180    66.750     0.150
     4.252   108.172     0.150
     4.252    62.961     0.150
     4.252   108.172     0.150
     4.308    69.562     0.150
     4.308    69.562     0.150
     4.308   125.492     0.150
     4.317    70.242     0.150
     4.317    70.242     0.150
     4.317   125.469     0.150
     4.360   123.781     0.150
     4.467    66.328     0.150
     4.467   119.969     0.150
     4.653    63.820     0.150
     5.072    78.430     0.150
     5.072    78.430     0.150
     5.072   137.680     0.150
     5.307   140.828     0.150
     5.975    92.102     0.150
     6.055    89.547     0.150
     6.055   158.828     0.150
     6.337   108.633     0.150
     6.337   185.258     0.150
     6.427   100.023     0.150
     6.427   176.930     0.150
     6.531   493.586     0.150
     6.562   496.594     0.150
     7.122   176.930     0.150
     7.783   235.891     0.150
     8.420   237.539     0.150
     8.847   237.523     0.150
     8.847   127.344     0.150
    10.736   292.852     0.150
    10.736   154.383     0.150
    13.089   187.516     0.150
    17.913   246.938     0.150
    18.250   249.859     0.150
    18.607   253.531     0.150
    20.124   275.562     0.150
    20.822   278.047     0.150
    22.352   292.617     0.150
    22.939   301.461     0.150
    23.424   305.109     0.150
    24.242   312.609     0.150
    28.453   356.188     0.150
    29.299   362.281     0.150
    30.372   371.422     0.150
    48.382   522.227     0.150
    50.021   534.609     0.150
    51.073   542.430     0.150
    51.272   544.164     0.150
    52.363   552.312     0.150
    52.365   550.945     0.150
    52.885   555.688     0.150
    52.922   556.086     0.150
    54.112   564.492     0.150
    54.239   565.523     0.150
    54.339   565.797     0.150
    54.622   566.469     0.150
    54.685   568.523     0.150
    55.125   571.461     0.150
    55.298   572.008     0.150
    55.300   572.688     0.150
    55.682   574.461     0.150
    57.037  4285.195     0.150
    57.046  4290.133     0.150
    57.054  4289.156     0.150
    61.429   616.391     0.150
    83.042  6259.500     0.150
    83.050  6259.148     0.150
    83.060  6285.469     0.150
    83.002   746.617     0.150
    83.073   742.320     0.150
    83.589  6311.000     0.150
    83.590  6290.062     0.150
    83.605  6292.297     0.150
    95.005   802.141     0.150
     0.612    12.207     0.150
     0.612    20.770     0.150
     1.305    21.840     0.150
     1.305    37.660     0.150
     1.435    24.816     0.150
     1.435    42.988     0.150
     1.585    28.090     0.150
     1.587    28.500     0.150
     1.602    28.348     0.150
     2.079    58.898     0.150
     2.267    36.328     0.150
     2.267    65.859     0.150
     2.576    39.898     0.150
     2.576    67.840     0.150
     2.588    37.688     0.150
     2.979    46.066     0.150
     2.962    87.887     0.150
     2.962    46.316     0.150
     2.962    87.887     0.150
     2.934    46.199     0.150
     2.934    87.398     0.150
     3.076    48.477     0.150
     3.076    88.449     0.150
     3.130    48.020     0.150
     3.130    81.148     0.150
     3.113    51.168     0.150
     3.178    93.738     0.150
     3.178    51.328     0.150
     3.178    93.738     0.150
     3.352    53.328     0.150
     3.352    93.539     0.150
     3.429    58.199     0.150
     3.429    99.238     0.150
     3.429    58.199     0.150
     3.429    99.238     0.150
     3.550   105.719     0.150
     3.550    55.316     0.150
     3.550   105.719     0.150
     3.593   105.707     0.150
     3.602   107.270     0.150
     3.697    55.727     0.150
     3.838   107.090     0.150
     3.843   112.590     0.150
     4.001   111.930     0.150
     4.001   115.898     0.150
     4.376   121.738     0.150
     4.718    70.809     0.150
     4.694   128.918     0.150
     5.101   141.227     0.150
     5.106    78.707     0.150
     6.117    90.859     0.150
     6.751    99.066     0.150
     6.751   171.777     0.150
     7.548   110.137     0.150
     7.810   587.344     0.150
     7.838   593.281     0.150
    18.420   257.094     0.150
    22.131   297.461     0.150
    22.256   293.145     0.150
    24.988   322.469     0.150
    45.642  3407.340     0.150
    54.378   565.137     0.150
    55.282  4134.137     0.150
    55.359  4140.840     0.150
    56.076  4201.016     0.150
    56.085  4202.398     0.150
    56.093  4201.906     0.150
    56.097   577.109     0.150
    60.958   620.988     0.150
    61.494  4600.637     0.150
    62.423   621.227     0.150
    82.701   741.340     0.150
    85.647   757.879     0.150
    92.472   785.297     0.150
    95.656   804.238     0.150
     3.089    52.891     0.150
     3.556    53.750     0.150
     4.005   116.152     0.150
     0.108     4.119     0.150
     0.108     7.268     0.150
     0.997    18.018     0.150
     1.180    22.088     0.150
     1.721    30.318     0.150
     1.721    53.148     0.150
     1.916    30.229     0.150
     2.020    31.488     0.150
     2.500    41.369     0.150
     2.500    70.699     0.150
     2.956    41.389     0.150
     2.956    41.389     0.150
     2.956    73.998     0.150
     2.915    46.168     0.150
     2.915    84.139     0.150
     3.288    49.469     0.150
     3.288    91.879     0.150
     3.160    56.219     0.150
     3.691    53.869     0.150
     3.691    97.439     0.150
     3.670    61.328     0.150
     3.670   105.588     0.150
     3.759    58.758     0.150
     3.759   107.869     0.150
     3.847    54.119     0.150
     3.847    54.119     0.150
     3.712    56.088     0.150
     3.712   110.488     0.150
     3.815    64.129     0.150
     3.815   103.998     0.150
     4.153    69.078     0.150
     4.153    69.078     0.150
     4.172    60.209     0.150
     4.203    65.049     0.150
     4.203   113.578     0.150
     4.193    68.838     0.150
     4.199    68.219     0.150
     4.221    62.109     0.150
     4.283    61.289     0.150
     4.413    60.609     0.150
     4.294    61.639     0.150
     4.294    61.639     0.150
     4.294   103.729     0.150
     4.309    62.928     0.150
     4.366    63.039     0.150
     4.505    63.059     0.150
     4.505   114.629     0.150
     4.643   118.168     0.150
     4.715    68.289     0.150
     4.715    77.209     0.150
     4.627   117.709     0.150
     4.666    74.258     0.150
     5.400   148.738     0.150
     6.081   165.748     0.150
     7.099   534.910     0.150
     7.128   535.219     0.150
     6.944   188.088     0.150
     7.161   539.994     0.150
     7.309   111.068     0.150
     7.845   200.029     0.150
    10.651   162.875     0.150
    10.999   152.279     0.150
    11.240   296.029     0.150
    12.572   185.129     0.150
    13.522   201.000     0.150
    14.697   218.881     0.150
    15.433   223.605     0.150
    18.421   253.258     0.150
    18.928   264.332     0.150
    20.431   278.164     0.150
    20.531   278.498     0.150
    21.525   286.738     0.150
    21.505   291.676     0.150
    22.076   293.848     0.150
    26.133   333.930     0.150
    56.527  4239.291     0.150
    56.537  4240.795     0.150
    56.545  4239.373     0.150
    61.917   617.602     0.150
    83.660  6300.486     0.150
    83.668  6293.268     0.150
    83.678  6304.920     0.150
    84.204  6357.818     0.150
    84.205  6348.541     0.150
    84.220  6346.318     0.150
     0.300     8.992     0.150
     0.300    15.914     0.150
     1.057    18.297     0.150
     1.077    32.734     0.150
     1.120    19.352     0.150
     1.349    22.742     0.150
     1.349    39.492     0.150
     1.806    28.695     0.150
     1.806    49.352     0.150
     2.640    41.703     0.150
     2.640    71.391     0.150
     2.864    43.617     0.150
     2.864    75.984     0.150
     3.076    46.562     0.150
     3.076    80.961     0.150
     3.374    51.742     0.150
     3.374    89.016     0.150
     3.434    53.625     0.150
     3.434    92.305     0.150
     3.857    59.273     0.150
     4.187    61.031     0.150
     7.407   561.102     0.150
    56.573  4236.539     0.150
    56.582  4239.094     0.150
    56.590  4240.750     0.150
     0.081     4.254     0.150
     0.081     6.785     0.150
     1.049    18.875     0.150
     1.225    22.586     0.150
     1.271    22.434     0.150
     1.724    29.844     0.150
     1.976    31.887     0.150
     1.976    58.285     0.150
     2.410    41.344     0.150
     2.496    73.125     0.150
     2.925    45.734     0.150
     2.925    87.016     0.150
     2.900    87.625     0.150
     2.965    46.824     0.150
     2.965    79.543     0.150
     3.173    54.273     0.150
     3.173    82.594     0.150
     3.173    91.316     0.150
     3.243    51.023     0.150
     3.243    91.996     0.150
     3.635    56.746     0.150
     3.635   105.754     0.150
     3.729    56.293     0.150
     3.729   102.395     0.150
     3.804    58.645     0.150
     3.792    65.535     0.150
     3.792   109.914     0.150
     3.965    54.746     0.150
     4.177    63.996     0.150
     4.177   109.977     0.150
     4.187    69.094     0.150
     4.369    66.203     0.150
     5.390    79.906     0.150
     5.761    86.477     0.150
     5.761   151.625     0.150
     7.135   540.336     0.150
     7.163   546.613     0.150
     7.197   548.543     0.150
    10.679   157.734     0.150
    11.027   154.664     0.150
    13.549   194.605     0.150
    16.837   236.125     0.150
    20.447   277.211     0.150
    22.415   295.637     0.150
    22.512   296.453     0.150
    30.140   370.559     0.150
    48.820   523.496     0.150
    51.837   545.832     0.150
    54.437   567.902     0.150
    54.671   566.680     0.150
    56.477  4235.328     0.150
    56.486  4236.562     0.150
    56.494  4235.531     0.150
    57.439   588.520     0.150
    58.095   593.406     0.150
     3.605    52.336     0.150
     3.871    56.586     0.150
     4.064   116.184     0.150
     4.530    75.254     0.150
     4.974    71.184     0.150
    10.955   292.723     0.150
    54.721   568.516     0.150
    56.511  4233.449     0.150
    56.521  4234.680     0.150
    56.528  4233.703     0.150
     1.523    24.723     0.150
     2.666    68.281     0.150
     2.838    52.113     0.150
     4.824   148.863     0.150
     7.982   240.801     0.150
     0.925    16.586     0.150
     0.925    28.375     0.150
     0.925    16.625     0.150
     0.925    28.436     0.150
     1.789    30.926     0.150
     1.798    31.535     0.150
     1.807    31.615     0.150
     1.957    32.145     0.150
     2.680    75.045     0.150
     2.647    80.996     0.150
     2.647    42.535     0.150
     2.824    69.736     0.150
     2.887    55.875     0.150
     2.887    91.266     0.150
     3.211    85.295     0.150
     3.253    92.096     0.150
     3.570    59.635     0.150
     3.587    65.176     0.150
     3.685    57.166     0.150
     3.685    99.535     0.150
     3.865    61.115     0.150
     4.061    61.016     0.150
     4.412    66.355     0.150
     4.379    66.736     0.150
     4.787    72.576     0.150
     5.432    81.076     0.150
     5.807   159.625     0.150
     7.232   105.836     0.150
     7.900   195.926     0.150
     8.126   607.465     0.150
    55.916  4193.021     0.150
    55.925  4194.297     0.150
    55.934  4192.373     0.150
     0.287     8.283     0.150
     0.287    14.674     0.150
     1.770    27.594     0.150
     1.770    47.402     0.150
     2.620    40.354     0.150
     3.041    45.674     0.150
     3.041    77.883     0.150
     2.830    80.193     0.150
     2.910    44.822     0.150
     3.350    50.934     0.150
     3.416    98.104     0.150
     3.416    52.133     0.150
     3.844   108.982     0.150
     3.844    58.482     0.150
     4.753   129.664     0.150
     4.753    70.934     0.150
     5.074    75.623     0.150
     5.074   130.812     0.150
     5.172    75.963     0.150
     5.172   132.363     0.150
     5.217    77.854     0.150
     5.529    82.264     0.150
     5.529   142.684     0.150
    24.208   308.574     0.150
    53.385   554.594     0.150
   125.965  1150.092     0.150
   126.838  1151.984     0.150
     0.798    14.350     0.150
     0.798    25.090     0.150
     0.978    33.550     0.150
     0.978    19.340     0.150
     0.978    33.550     0.150
     1.248    38.529     0.150
     1.395    22.640     0.150
     1.395    37.949     0.150
     1.358    24.979     0.150
     1.362    24.970     0.150
     1.381    24.689     0.150
     1.381    43.079     0.150
     1.361    24.760     0.150
     1.391    25.529     0.150
     1.490    25.600     0.150
     1.661    29.909     0.150
     2.109    34.010     0.150
     2.639    41.109     0.150
     2.639    68.229     0.150
     2.477    40.749     0.150
     2.854    44.560     0.150
     2.854    77.069     0.150
     2.898    45.279     0.150
     2.898    80.959     0.150
     3.317    51.560     0.150
     3.317    93.100     0.150
     3.405    53.649     0.150
     3.405    92.289     0.150
     3.915    60.079     0.150
     3.953    60.409     0.150
     3.953   103.529     0.150
     4.247    64.459     0.150
     4.247   107.399     0.150
     4.569    69.260     0.150
     4.569   118.109     0.150
     4.736    70.149     0.150
     4.736   118.949     0.150
     4.733    71.390     0.150
     4.733   122.619     0.150
     4.926    74.479     0.150
     4.926   125.569     0.150
     5.059    76.189     0.150
     5.059   129.970     0.150
     5.231    78.529     0.150
     5.231   135.100     0.150
     5.752    84.729     0.150
     5.752   147.029     0.150
     6.751    98.579     0.150
     6.751   168.329     0.150
     7.445   183.654     0.150
    10.784   152.069     0.150
    24.485   314.619     0.150
    25.044   320.649     0.150
    54.781   563.869     0.150
    54.795   562.909     0.150
    56.400  4243.348     0.150
    56.409  4246.879     0.150
    56.417  4246.654     0.150
     0.915    30.708     0.150
     2.783    79.588     0.150
     0.875    18.143     0.150
     0.973    20.301     0.150
     1.078    21.781     0.150
     1.071    21.652     0.150
     1.071    21.652     0.150
     1.325    41.152     0.150
     1.319    39.631     0.150
     1.319    23.951     0.150
     1.319    39.631     0.150
     1.788    31.262     0.150
     1.788    52.562     0.150
     2.779    47.893     0.150
     2.779    80.281     0.150
     3.057    49.152     0.150
     3.057    88.271     0.150
     3.312    54.781     0.150
     3.312    98.672     0.150
     3.319    55.021     0.150
     3.319    96.002     0.150
     3.348    54.332     0.150
     3.348    97.221     0.150
     3.364    55.732     0.150
     3.364    96.541     0.150
     3.406   100.791     0.150
     3.459    56.832     0.150
     3.459   100.521     0.150
     3.498    59.822     0.150
     3.502    55.652     0.150
     3.502   101.812     0.150
     3.595    57.121     0.150
     3.595    98.211     0.150
     3.828    61.432     0.150
     3.828   112.691     0.150
     3.900    61.691     0.150
     3.900   114.982     0.150
     3.911    68.521     0.150
     3.911   110.322     0.150
     4.010    69.752     0.150
     4.010   114.521     0.150
     4.121    67.082     0.150
     4.121   120.822     0.150
     4.166    64.992     0.150
     4.166   111.271     0.150
     4.266    67.771     0.150
     4.266   121.971     0.150
     4.364    58.531     0.150
     4.404    69.602     0.150
     4.428    69.781     0.150
     4.428   119.961     0.150
     4.446    71.611     0.150
     4.446   127.342     0.150
     4.748    74.361     0.150
     4.748   124.631     0.150
     5.070    79.021     0.150
     5.070   135.562     0.150
     5.183    79.482     0.150
     5.183   135.951     0.150
     5.219    81.102     0.150
     5.219   140.441     0.150
     5.436    83.852     0.150
     5.436   145.191     0.150
     5.534    85.521     0.150
     5.534   144.701     0.150
     5.737    88.031     0.150
     5.737   150.131     0.150
     5.829   149.643     0.150
     5.829    90.771     0.150
     5.829   149.643     0.150
     6.202    94.232     0.150
     6.202   159.932     0.150
     6.421   102.152     0.150
     6.421   177.982     0.150
     6.975   173.482     0.150
     7.209   107.152     0.150
     7.209   187.121     0.150
     7.435   563.344     0.150
     7.494   570.713     0.150
     7.942   117.951     0.150
     7.942   205.102     0.150
    20.430   276.482     0.150
    20.478   279.002     0.150
    20.666   281.281     0.150
    21.019   283.451     0.150
    21.876   294.652     0.150
    22.050   296.791     0.150
    22.123   296.361     0.150
    22.884   304.691     0.150
    24.000   313.162     0.150
    25.702   329.893     0.150
    30.731   378.201     0.150
    32.186   385.281     0.150
    48.783   518.357     0.150
    54.643   567.631     0.150
    56.573  4216.959     0.150
    56.582  4217.385     0.150
    56.590  4218.912     0.150
    62.941   619.557     0.150
    84.995   753.932     0.150
     0.641    20.211     0.150
     3.692   111.898     0.150
     0.055     4.107     0.150
     0.055     6.926     0.150
     1.120    19.797     0.150
     1.262    23.188     0.150
     1.311    39.547     0.150
     1.455    41.746     0.150
     1.665    28.717     0.150
     1.873    29.227     0.150
     2.823    44.377     0.150
     2.823    77.576     0.150
     3.020    47.777     0.150
     3.141    49.217     0.150
     3.141    86.477     0.150
     3.127    86.656     0.150
     3.532    55.736     0.150
     3.597    96.816     0.150
     3.628    57.717     0.150
     3.628    97.566     0.150
     3.701    57.518     0.150
     3.701    97.336     0.150
     3.683    58.576     0.150
     4.080    62.066     0.150
     4.080   108.207     0.150
     4.266    63.906     0.150
     4.266   115.447     0.150
     4.794    75.057     0.150
     4.944    73.996     0.150
     4.944   128.566     0.150
     5.263    78.787     0.150
     5.263   136.938     0.150
     5.288    77.857     0.150
     5.288   141.086     0.150
     5.380    80.727     0.150
     5.380   142.477     0.150
     5.661    85.707     0.150
     5.661   144.637     0.150
     5.718    82.316     0.150
     5.947    88.197     0.150
     5.947   157.188     0.150
     6.177    92.207     0.150
     6.307    92.867     0.150
     7.037   106.527     0.150
     7.322   106.506     0.150
     7.322   191.826     0.150
     7.451   110.156     0.150
     7.854   114.277     0.150
     8.121   117.727     0.150
    12.583   179.426     0.150
    13.529   195.029     0.150
    15.288   216.227     0.150
    20.405   277.148     0.150
    20.764   276.277     0.150
    20.780   280.453     0.150
    20.998   285.197     0.150
    21.576   291.584     0.150
    22.389   297.307     0.150
    22.546   299.395     0.150
    43.595   481.992     0.150
    44.622   489.715     0.150
    44.672   490.709     0.150
    45.237  3382.938     0.150
    45.731   499.508     0.150
    46.078   502.047     0.150
    53.032   556.412     0.150
    54.958  4125.137     0.150
    55.210   572.723     0.150
    55.254   572.496     0.150
    56.416  4234.834     0.150
    56.425  4251.092     0.150
    56.433  4250.109     0.150
     0.032     3.762     0.150
     0.032     6.359     0.150
     1.077    19.512     0.150
     1.209    22.762     0.150
     1.622    28.492     0.150
     1.622    49.520     0.150
     1.887    29.422     0.150
     1.887    52.469     0.150
     2.817    43.602     0.150
     2.817    76.500     0.150
     3.157    48.781     0.150
     3.157    79.891     0.150
     2.971    47.262     0.150
     2.971    79.980     0.150
     3.079    45.480     0.150
     3.079    87.012     0.150
     3.531    57.520     0.150
     3.531    99.730     0.150
     3.620    55.422     0.150
     3.620    99.129     0.150
     3.652    58.770     0.150
     3.652    58.770     0.150
     3.652   105.641     0.150
     4.066    61.941     0.150
     4.066   104.301     0.150
    12.528   177.859     0.150
    13.476   193.840     0.150
    13.938   191.191     0.150
    13.878   194.148     0.150
    14.100   195.980     0.150
    15.236   207.559     0.150
    23.003   301.742     0.150
    24.963   320.230     0.150
    25.077   319.840     0.150
    26.595   335.934     0.150
    28.089   350.176     0.150
    33.236   393.344     0.150
    43.546   481.414     0.150
    45.680   499.527     0.150
    53.594   559.336     0.150
    53.593   558.625     0.150
    54.590   566.766     0.150
    56.465  4232.766     0.150
    56.474  4233.555     0.150
    56.482  4231.031     0.150
     1.692    30.031     0.150
     2.974    67.418     0.150
     3.220    45.301     0.150
     1.646    49.824     0.150
     2.572    46.035     0.150
     2.572    80.262     0.150
     2.847    80.152     0.150
     3.283    54.492     0.150
     0.837    16.659     0.150
     0.992    18.949     0.150
     0.992    32.379     0.150
     1.125    18.659     0.150
     1.125    18.659     0.150
     1.125    33.899     0.150
     1.976    33.449     0.150
     1.976    56.619     0.150
     2.118    36.180     0.150
     2.118    61.659     0.150
     2.156    42.970     0.150
     2.469    40.560     0.150
     2.469    70.869     0.150
     2.505    41.089     0.150
     2.505    75.959     0.150
     2.722    49.659     0.150
     2.844    45.939     0.150
     2.844    80.879     0.150
     3.176    50.549     0.150
     3.205    52.659     0.150
     3.205    89.760     0.150
     3.226    82.289     0.150
     3.344    56.489     0.150
     3.516    54.060     0.150
     3.516    91.839     0.150
     3.565    98.569     0.150
     3.655    57.390     0.150
     3.725    56.989     0.150
     3.797    57.159     0.150
     4.587    70.520     0.150
     5.171    78.799     0.150
     7.962   116.089     0.150
     9.219   138.189     0.150
    18.692   256.560     0.150
    18.885   258.939     0.150
    19.866   269.629     0.150
    20.180   275.669     0.150
    20.567   280.169     0.150
    20.964   282.879     0.150
    21.369   287.029     0.150
    21.411   286.449     0.150
    54.168   563.638     0.150
     0.075     3.971     0.150
     0.075     6.591     0.150
     2.408    37.061     0.150
     2.908    38.601     0.150
     3.116    47.761     0.150
     3.116    85.461     0.150
     3.036    52.711     0.150
     3.036    91.471     0.150
     3.118    88.900     0.150
     3.507    59.021     0.150
     3.580    59.091     0.150
     3.604    56.461     0.150
     3.604   103.980     0.150
     3.675    56.081     0.150
     3.675   101.561     0.150
     3.814    59.681     0.150
     4.057    63.291     0.150
     4.057   114.641     0.150
     4.240    64.051     0.150
     4.240   117.511     0.150
     4.549   126.690     0.150
     4.918    71.551     0.150
     5.237    70.621     0.150
     5.354    71.961     0.150
     6.359    91.171     0.150
     7.263   546.343     0.150
    20.809   279.811     0.150
    21.697   289.891     0.150
    54.834   568.951     0.150
    56.399  4231.403     0.150
    56.409  4231.843     0.150
    56.417  4229.464     0.150
    59.115   600.021     0.150
     2.209    36.785     0.150
     2.209    62.285     0.150
     2.195    62.336     0.150
     2.700    44.977     0.150
     3.247    53.336     0.150
     3.247    80.824     0.150
     3.656    50.137     0.150
     3.656    91.797     0.150
     3.931    54.695     0.150
     3.972    63.047     0.150
     4.119   103.297     0.150
     4.275    67.188     0.150
     4.327    68.395     0.150
     5.163    72.555     0.150
     5.163   126.957     0.150
     5.358   129.586     0.150
     5.680    78.426     0.150
     5.653    76.984     0.150
     5.909   144.406     0.150
     5.992    90.895     0.150
     5.814    90.516     0.150
     6.288    89.227     0.150
     7.001   104.027     0.150
     1.778    46.979     0.150
     1.871    55.738     0.150
     1.869    56.129     0.150
     1.965    50.670     0.150
     2.020    53.020     0.150
     3.071    76.568     0.150
     1.796    57.351     0.150
     3.063    43.931     0.150
     3.550    54.391     0.150
     4.592    74.971     0.150
     4.874    77.230     0.150
     5.193   143.711     0.150
     5.601    83.150     0.150
     2.198    37.258     0.150
     3.704    62.023     0.150
     3.857    58.141     0.150
     3.881    55.891     0.150
     4.108    72.977     0.150
     7.441    88.523     0.150
     7.441   112.797     0.150
     7.441   203.445     0.150
     8.848   136.430     0.150
    15.534   226.102     0.150
    16.771   244.242     0.150
    17.127   243.906     0.150
    19.925   278.328     0.150
    21.197   292.219     0.150
    24.616   327.148     0.150
    32.734   388.883     0.150
    45.903   494.883     0.150
    51.688   553.688     0.150
    53.276   564.477     0.150
    54.078   570.750     0.150
    55.013   577.109     0.150
    55.374   580.281     0.150
    55.835  4198.414     0.150
    55.844  4196.258     0.150
    55.852  4196.086     0.150
    55.946   583.953     0.150
    56.282   586.281     0.150
    59.587   609.703     0.150
     1.368    20.387     0.150
     1.368    37.297     0.150
     2.412    29.848     0.150
     2.622    47.355     0.150
     3.467    57.555     0.150
     1.118    18.035     0.150
     3.736    61.145     0.150
     5.291    83.234     0.150
     2.815    47.863     0.150
     3.043    50.354     0.150
     4.075    59.305     0.150
     4.251    66.664     0.150
     4.537    73.273     0.150
     4.804    66.863     0.150
     4.012    59.740     0.150
     3.989    57.682     0.150
     4.185    69.102     0.150
     4.972    82.330     0.150
     5.022   124.711     0.150
     5.268    83.990     0.150
     5.550    89.031     0.150
     1.060    20.938     0.150
     1.060    36.438     0.150
     1.968    61.748     0.150
     1.953    29.807     0.150
     2.439    41.477     0.150
     2.439    76.088     0.150
     3.641    60.607     0.150
     4.108   115.646     0.150
     4.118    64.258     0.150
     4.129   117.217     0.150
     4.157   107.418     0.150
     4.495    69.777     0.150
     5.006    70.078     0.150
     5.020   139.877     0.150
     5.685   158.307     0.150
     5.999    94.508     0.150
     7.159   533.352     0.150
     7.188   535.137     0.150
     7.221   541.582     0.150
     7.348   102.928     0.150
     7.497   204.537     0.150
     8.202   222.801     0.150
     8.202   218.098     0.150
     8.557   248.238     0.150
     8.642   124.188     0.150
     8.828   235.818     0.150
    10.074   262.807     0.150
    10.487   156.646     0.150
    11.193   147.207     0.150
    12.539   182.658     0.150
    12.715   185.338     0.150
    14.401   198.377     0.150
    14.639   207.098     0.150
    15.442   218.357     0.150
    16.051   221.498     0.150
    16.784   236.896     0.150
    16.861   234.334     0.150
    16.861   234.357     0.150
    18.378   252.457     0.150
    18.454   253.607     0.150
    18.653   254.818     0.150
    21.632   289.252     0.150
    22.349   295.658     0.150
    23.098   306.258     0.150
    23.333   305.158     0.150
    24.292   316.957     0.150
    24.495   316.957     0.150
    24.625   320.057     0.150
    24.826   320.057     0.150
    25.052   324.158     0.150
    25.612   329.127     0.150
    25.974    11.369     0.150
    26.337   336.357     0.150
    27.579   343.957     0.150
    28.050   347.967     0.150
    28.050   350.857     0.150
    28.901   356.646     0.150
    28.901   356.658     0.150
    30.525   370.807     0.150
    31.225   376.348     0.150
    33.311   394.758     0.150
    36.355   421.957     0.150
    40.959   460.158     0.150
    46.857   509.957     0.150
    46.952   509.516     0.150
    48.888   525.318     0.150
    51.792   548.342     0.150
    52.396   551.283     0.150
    52.598   551.820     0.150
    53.389   559.418     0.150
    53.453   558.857     0.150
    54.332   566.211     0.150
    55.110   570.707     0.150
    56.215   579.406     0.150
    56.220   580.158     0.150
    56.518  4243.447     0.150
    56.527  4244.225     0.150
    56.535  4238.428     0.150
    57.163   585.492     0.150
    58.039   591.379     0.150
    58.067   591.857     0.150
    58.327   594.557     0.150
    59.058   598.932     0.150
    61.235   614.246     0.150
    61.510   615.508     0.150
    63.019   625.557     0.150
    65.222   639.158     0.150
    65.515   642.158     0.150
    73.228   710.357     0.150
    77.843   712.557     0.150
    82.128   737.857     0.150
    82.768   743.158     0.150
    82.881   744.697     0.150
    82.934   744.158     0.150
    83.447   746.396     0.150
    85.261   756.256     0.150
    85.260   755.557     0.150
    85.120   756.557     0.150
    85.390   756.459     0.150
    85.839     5.203     0.150
    87.403   764.588     0.150
    88.698   767.158     0.150
    88.947   773.408     0.150
    91.611   784.877     0.150
    91.989   788.256     0.150
    95.180   803.658     0.150
    95.186   803.857     0.150
    95.902   807.459     0.150
    95.955   806.459     0.150
    95.955   806.537     0.150
    96.071   807.959     0.150
    96.398   804.256     0.150
    96.398    14.703     0.150
    97.095   812.256     0.150
    97.187   812.018     0.150
    99.333  1058.357     0.150
    99.668   820.209     0.150
   112.773  1117.658     0.150
   113.403  1129.057     0.150
   113.403  1310.158     0.150
   113.403  1512.459     0.150
   113.403  2361.057     0.150
     1.686    53.047     0.150
     2.552    76.523     0.150
     3.278    45.969     0.150
     4.227   119.914     0.150
     0.729    13.957     0.150
     0.729    23.918     0.150
     1.195    19.836     0.150
     1.195    34.148     0.150
     1.566    27.195     0.150
     1.745    29.316     0.150
     1.766    31.527     0.150
     1.829    31.098     0.150
     1.829    58.727     0.150
     2.234    36.137     0.150
     2.234    65.297     0.150
     2.459    38.129     0.150
     2.459    64.586     0.150
     2.904    46.418     0.150
     2.904    77.898     0.150
     3.045    48.137     0.150
     3.045    83.426     0.150
     3.070    52.848     0.150
     3.070    90.566     0.150
     3.179    39.328     0.150
     3.179    79.617     0.150
     3.329    57.035     0.150
     3.329    99.168     0.150
     3.438    58.086     0.150
     3.438    99.496     0.150
     3.586    54.066     0.150
     3.586    89.758     0.150
     3.541    54.188     0.150
     3.541    97.598     0.150
     3.554    56.355     0.150
     3.554    95.328     0.150
     3.711   105.379     0.150
     3.760    54.906     0.150
     4.015    64.516     0.150
     4.015   110.777     0.150
     4.112   117.168     0.150
     7.477   112.227     0.150
     7.477   199.699     0.150
    15.097   217.945     0.150
    24.558   321.730     0.150
    25.429   328.617     0.150
    45.160   497.633     0.150
    49.609   524.176     0.150
    54.233   561.266     0.150
    55.316   574.059     0.150
    55.893  4198.852     0.150
    55.902  4201.848     0.150
    55.910  4199.184     0.150
     1.693    27.697     0.150
     3.156    54.887     0.150
     3.156    93.537     0.150
     0.600    19.602     0.150
     0.600    30.391     0.150
     1.187    17.297     0.150
     1.187    33.297     0.150
     2.389    57.992     0.150
     1.289    44.263     0.150
     3.136    53.083     0.150
     3.171    40.973     0.150
     3.171    68.133     0.150
     3.343    55.083     0.150
     4.479    63.263     0.150
     5.271   143.522     0.150
     5.468   151.503     0.150
     2.505    73.493     0.150
     3.329    56.363     0.150
     3.961    48.433     0.150
     3.961    99.633     0.150
     4.297   120.443     0.150
     4.304    70.063     0.150
     4.401    60.423     0.150
     4.755    69.453     0.150
     4.784    69.833     0.150
     4.784    70.033     0.150
     4.848   134.803     0.150
     5.722   155.623     0.150
     5.984    92.913     0.150
     6.552   109.543     0.150
     6.552   199.933     0.150
     7.532   200.913     0.150
     7.771   229.793     0.150
     0.459     7.530     0.150
     0.459    13.190     0.150
     1.231    19.910     0.150
     1.231    35.160     0.150
     1.205    18.340     0.150
     1.205    34.200     0.150
     2.559    42.920     0.150
     2.727    29.800     0.150
     2.727    63.851     0.150
     2.831    49.840     0.150
     2.831    87.610     0.150
     2.896    88.561     0.150
     3.136    52.561     0.150
     3.136    92.120     0.150
     3.544    60.410     0.150
     3.544   105.800     0.150
     4.644    80.681     0.150
     4.644   114.330     0.150
     4.838    64.190     0.150
     4.838   139.010     0.150
     4.986    67.760     0.150
     1.060    17.994     0.150
     2.096    35.334     0.150
     2.906    38.025     0.150
     3.436    56.234     0.150
     4.267    69.475     0.150
     0.547    10.674     0.150
     0.720    13.674     0.150
     0.782    15.474     0.150
     2.341    40.594     0.150
     4.116    56.583     0.150
     4.347    59.234     0.150
     5.441    80.054     0.150
     5.736    82.264     0.150
     5.966    86.524     0.150
     6.199    90.054     0.150
     6.226    88.054     0.150
     6.259    91.833     0.150
     6.709    95.703     0.150
     7.361   113.994     0.150
     1.402    21.516     0.150
     1.402    38.227     0.150
     2.385    72.918     0.150
     2.772    45.676     0.150
     2.772    79.059     0.150
     2.937    91.238     0.150
     3.507    57.219     0.150
     3.507   100.289     0.150
     3.784    96.027     0.150
     3.819   110.887     0.150
     3.826    51.156     0.150
     3.871    53.586     0.150
     3.872   110.566     0.150
     1.194    40.074     0.150
     1.285    39.514     0.150
     1.743    53.354     0.150
     2.930    86.994     0.150
     3.389    97.225     0.150
     3.428    38.885     0.150
     3.428    75.625     0.150
     3.555    56.744     0.150
     3.562   103.975     0.150
     3.643    52.545     0.150
     4.221    59.645     0.150
     4.252    60.174     0.150
     4.252    60.234     0.150
     2.868    34.543     0.150
     2.868    70.154     0.150
     3.000    85.973     0.150
     3.108    47.344     0.150
     3.317    50.898     0.150
     3.502    52.906     0.150
     3.932   100.867     0.150
     3.901    59.078     0.150
     4.439   125.430     0.150
     5.249    82.883     0.150
     1.444    23.234     0.150
     2.558    65.895     0.150
     3.021    25.515     0.150
     3.021    67.854     0.150
     3.250    45.705     0.150
     3.404    49.415     0.150
     3.842    53.795     0.150
     4.384   122.585     0.150
     1.514    25.602     0.150
     1.547    52.023     0.150
     2.801    39.283     0.150
     2.934    33.873     0.150
     2.934    69.693     0.150
     4.642    67.402     0.150
     0.554    23.820     0.150
     0.919    30.422     0.150
     1.678    30.117     0.150
     2.253    67.672     0.150
     2.481    72.680     0.150
     2.860    83.953     0.150
     2.880    84.344     0.150
     2.931    39.992     0.150
     3.182    54.711     0.150
     4.406   107.531     0.150
     3.675    61.477     0.150
     4.601    75.434     0.150
     5.831    82.004     0.150
     0.126     4.380     0.150
     0.126     7.670     0.150
     1.074    20.101     0.150
     1.245    37.030     0.150
     1.748    30.710     0.150
     1.748    52.370     0.150
     2.029    32.160     0.150
     2.029    56.641     0.150
     2.344    41.830     0.150
     2.344    71.130     0.150
     2.390    42.910     0.150
     2.390    74.050     0.150
     2.974    46.400     0.150
     2.974    79.690     0.150
     2.855    48.391     0.150
     2.929    45.971     0.150
     2.929    82.050     0.150
     3.297    50.590     0.150
     3.188    55.730     0.150
     3.188    89.641     0.150
     3.699   103.521     0.150
     3.699   103.521     0.150
     3.686   101.900     0.150
     3.744    55.971     0.150
     3.744    55.971     0.150
     3.744   104.900     0.150
     3.735   105.391     0.150
     3.798   108.271     0.150
     3.812    59.431     0.150
     4.114    67.440     0.150
     4.202    70.021     0.150
     4.202   111.000     0.150
     4.204    60.101     0.150
     4.222   119.710     0.150
     4.422   113.670     0.150
     4.703    76.311     0.150
     4.703    76.311     0.150
     4.729    66.070     0.150
     4.689    70.750     0.150
     4.689   132.740     0.150
     4.863    74.311     0.150
     5.097   131.460     0.150
     5.090    72.530     0.150
     5.090    72.530     0.150
     5.416   139.130     0.150
     5.444   147.750     0.150
     5.833   158.840     0.150
     5.810    85.740     0.150
     5.810   159.630     0.150
     5.772    84.990     0.150
     6.082    88.880     0.150
     6.099    89.721     0.150
     6.241    92.740     0.150
     6.413    94.240     0.150
     6.413   175.271     0.150
     6.540   177.210     0.150
     6.960   105.101     0.150
     7.084   534.991     0.150
     7.112   538.857     0.150
     7.146   538.764     0.150
     7.326   105.721     0.150
     7.326   186.690     0.150
     7.479   106.190     0.150
     7.479   106.190     0.150
     7.479   198.521     0.150
     7.936   116.561     0.150
     7.871   114.090     0.150
     7.871   114.090     0.150
     8.276   120.340     0.150
    10.143   144.050     0.150
    20.851   277.880     0.150
    24.705   317.010     0.150
    53.478   558.870     0.150
    54.111   563.439     0.150
    56.176   577.960     0.150
    56.516  4242.690     0.150
    56.525  4243.433     0.150
    56.533  4243.389     0.150
    59.614   603.740     0.150
    60.904   611.213     0.150
    85.583   755.311     0.150
    87.296   762.221     0.150
     0.659    13.016     0.150
     0.659    22.516     0.150
     2.034    34.828     0.150
     2.034    61.469     0.150
     2.220    37.797     0.150
     2.220    63.875     0.150
     2.397    41.031     0.150
     2.397    67.070     0.150
     2.575    41.195     0.150
     2.575    73.391     0.150
     3.362    55.258     0.150
     3.362    94.977     0.150
     3.475    54.586     0.150
     3.475   101.000     0.150
     3.634    97.211     0.150
     3.842    58.078     0.150
     3.842   101.508     0.150
     3.759    59.008     0.150
     3.759   100.828     0.150
     4.162    67.602     0.150
     4.162   114.328     0.150
     4.203    65.680     0.150
     4.203   113.531     0.150
     4.245   103.797     0.150
     4.401    67.656     0.150
     4.401   114.531     0.150
     4.491    71.992     0.150
     4.491   123.195     0.150
     4.541    73.898     0.150
     4.632   125.641     0.150
     4.635    74.117     0.150
     4.635   127.781     0.150
     4.640    74.000     0.150
     4.640   126.516     0.150
     4.650   126.617     0.150
     4.681    76.398     0.150
     4.688    72.281     0.150
     4.688   120.648     0.150
     4.741    71.266     0.150
     4.741   128.000     0.150
     4.745    73.172     0.150
     4.745   129.188     0.150
     4.772    75.172     0.150
     4.772   130.922     0.150
     4.823    73.047     0.150
     4.823   127.555     0.150
     4.832    77.469     0.150
     4.967    75.438     0.150
     4.967   126.961     0.150
     4.976    67.422     0.150
     5.047    77.445     0.150
     5.047   150.000     0.150
     5.608    84.289     0.150
     5.608   145.367     0.150
     5.929    89.289     0.150
     5.929   154.367     0.150
     6.300    90.352     0.150
     6.300    90.352     0.150
     6.300   166.438     0.150
     6.368    94.781     0.150
     6.368   164.250     0.150
     6.398    94.531     0.150
     6.398   172.336     0.150
     6.600    98.422     0.150
     6.600   166.797     0.150
     6.624   100.836     0.150
     6.624   174.422     0.150
     6.863   102.125     0.150
     6.863   179.531     0.150
     7.007   103.141     0.150
     7.007   175.609     0.150
     7.069   102.180     0.150
     7.477   105.992     0.150
     7.624   205.336     0.150
     7.836   115.641     0.150
     7.836   201.039     0.150
     8.797   126.750     0.150
     9.455   136.797     0.150
     9.455   240.859     0.150
     9.603   257.680     0.150
    10.678   155.320     0.150
    10.678   267.891     0.150
    14.458   203.906     0.150
    18.470   254.656     0.150
    20.382   274.555     0.150
    24.883   321.688     0.150
    52.598   554.156     0.150
    53.909   563.891     0.150
    54.744   569.336     0.150
    54.766   568.930     0.150
    55.963   577.938     0.150
    56.201   579.555     0.150
    56.336   581.094     0.150
    56.934  4278.906     0.150
    56.943  4278.867     0.150
    56.951  4278.367     0.150
    57.060   585.266     0.150
    57.946   592.125     0.150
    59.568   603.023     0.150
    83.273   747.148     0.150
    83.422   746.477     0.150
    83.422   746.320     0.150
    83.652  6335.641     0.150
    83.653  6325.539     0.150
    83.668  6329.641     0.150
    85.471   757.102     0.150
    85.810   757.711     0.150
     1.874    53.988     0.150
     1.971    63.324     0.150
     3.162    37.520     0.150
     3.600   108.434     0.150
     3.621   111.941     0.150
     3.584    50.629     0.150
     3.773   114.559     0.150
     3.949    56.785     0.150
     4.437    62.965     0.150
     4.751    84.395     0.150
     6.841    88.449     0.150
     7.132   197.254     0.150
    25.447   321.559     0.150
    55.804  4184.543     0.150
    55.813  4183.566     0.150
    55.821  4184.395     0.150
     1.497    30.607     0.150
     3.430    61.617     0.150
     4.342    76.428     0.150
     3.190    81.379     0.150
     5.061    74.189     0.150
     2.020    33.930     0.150
     2.021    34.867     0.150
     2.141    37.078     0.150
     2.141    66.414     0.150
     2.965    44.734     0.150
     3.072    87.344     0.150
     3.108    46.023     0.150
     3.124    41.578     0.150
     3.124    82.953     0.150
     3.461   101.945     0.150
     3.772    60.508     0.150
     4.696    51.438     0.150
     7.265   197.312     0.150
     8.669   120.516     0.150
     9.820   148.539     0.150
    10.497   147.992     0.150
    55.757  4181.289     0.150
    55.766  4181.195     0.150
    55.774  4180.742     0.150
     1.632    48.636     0.150
     2.732    70.146     0.150
     3.334    55.915     0.150
     3.526    56.136     0.150
     3.644    59.915     0.150
     3.650    60.465     0.150
     3.662    61.755     0.150
     3.775    60.575     0.150
     4.881    77.285     0.150
     0.881    30.555     0.150
     0.961    17.680     0.150
     0.931    32.805     0.150
     2.047    35.180     0.150
     2.047    64.500     0.150
     2.576    42.344     0.150
     2.657    46.781     0.150
     3.652    59.609     0.150
     3.733    52.500     0.150
     4.155    60.633     0.150
     3.216    45.965     0.150
     3.244    85.744     0.150
     3.455    47.193     0.150
     3.663    62.725     0.150
     4.122    59.283     0.150
     4.234    69.805     0.150
     1.066    33.773     0.150
     1.550    46.693     0.150
     3.016    46.164     0.150
     4.270    61.434     0.150
     5.174    76.004     0.150
     1.137    24.033     0.150
     3.321    56.883     0.150
     3.619    61.643     0.150
     3.644    62.883     0.150
     3.644   105.203     0.150
     5.014    71.333     0.150
     1.189    41.828     0.150
     1.578    50.148     0.150
     2.376    34.422     0.150
     2.376    64.531     0.150
     2.955    44.340     0.150
     3.515    50.109     0.150
     4.093    65.469     0.150
     4.285    68.730     0.150
     4.605    73.262     0.150
     5.253    82.852     0.150
     6.447    98.422     0.150
     9.890   181.715     0.150
    23.424   313.074     0.150
    54.012   566.352     0.150
     3.382    80.102     0.150
     3.425    40.410     0.150
     3.425    78.562     0.150
     3.652    51.660     0.150
     3.780    61.383     0.150
     3.817    54.691     0.150
     4.292   108.410     0.150
     4.384    69.461     0.150
    23.839   307.387     0.150
     2.890    70.785     0.150
     4.228   105.955     0.150
     4.643   114.275     0.150
     5.401   132.075     0.150
     1.438    39.082     0.150
     3.472    56.652     0.150
     3.771    62.242     0.150
     4.548    75.402     0.150
     1.949    61.289     0.150
     3.071    45.670     0.150
     4.083    67.949     0.150
     4.342   121.379     0.150
     4.631    66.068     0.150
     5.741    84.270     0.150
     6.444    91.389     0.150
     7.216   537.020     0.150
     8.176   116.039     0.150
    56.378   579.617     0.150
    56.528  4234.143     0.150
    56.537  4233.627     0.150
    56.545  4234.346     0.150
    57.395   588.297     0.150
    60.878   611.379     0.150
     4.782    78.426     0.150
     5.462    86.113     0.150
     5.728    93.203     0.150
     5.762    94.094     0.150
     0.507    10.137     0.150
     0.507    17.646     0.150
     1.411    23.258     0.150
     1.411    43.717     0.150
     1.515    26.438     0.150
     1.515    45.658     0.150
     1.617    26.758     0.150
     1.617    47.848     0.150
     1.549    27.438     0.150
     1.549    47.377     0.150
     1.621    28.057     0.150
     1.621    48.277     0.150
     1.615    29.227     0.150
     2.136    34.787     0.150
     2.136    60.928     0.150
     2.472    40.838     0.150
     2.472    68.627     0.150
     2.573    43.348     0.150
     2.573    75.348     0.150
     2.679    41.627     0.150
     2.679    73.158     0.150
     2.834    49.047     0.150
     2.834    82.807     0.150
     2.980    47.918     0.150
     2.980    85.828     0.150
     3.095    49.928     0.150
     3.095    85.057     0.150
     3.047    49.736     0.150
     3.047    87.168     0.150
     3.240    50.467     0.150
     3.240    88.287     0.150
     3.217    49.367     0.150
     3.217    88.828     0.150
     3.260    50.688     0.150
     3.260    91.158     0.150
     3.324    52.236     0.150
     3.324    95.188     0.150
     3.328    54.248     0.150
     3.328    93.547     0.150
     3.430    53.877     0.150
     3.430    94.537     0.150
     3.524    55.447     0.150
     3.524    99.908     0.150
     3.570    56.908     0.150
     3.570    97.957     0.150
     3.695    58.137     0.150
     3.695    99.877     0.150
     3.703    58.537     0.150
     3.703   100.697     0.150
     3.716    61.316     0.150
     3.716   105.838     0.150
     3.719    62.566     0.150
     3.718    58.588     0.150
     3.718   100.986     0.150
     3.719    59.598     0.150
     3.719   100.887     0.150
     3.804    57.637     0.150
     3.804   103.127     0.150
     3.749    59.396     0.150
     3.749   101.396     0.150
     3.747    55.748     0.150
     3.747    55.748     0.150
     3.747   101.408     0.150
     3.768    61.986     0.150
     3.768    61.986     0.150
     3.768   105.178     0.150
     3.768    57.998     0.150
     3.768   102.018     0.150
     3.805    61.697     0.150
     3.805   103.328     0.150
     3.830    60.008     0.150
     3.830   104.047     0.150
     3.840    61.598     0.150
     3.840   105.297     0.150
     3.870    59.658     0.150
     3.870   105.727     0.150
     3.896    63.307     0.150
     3.896   105.928     0.150
     3.947    61.986     0.150
     3.947   107.168     0.150
     4.121    62.447     0.150
     4.121   110.486     0.150
     4.111    61.986     0.150
     4.111   112.477     0.150
     4.193    61.158     0.150
     4.232    64.977     0.150
     4.232   115.078     0.150
     4.565    73.947     0.150
     4.565    73.947     0.150
     4.565   124.438     0.150
     4.673    70.736     0.150
     4.673   126.297     0.150
     4.827    73.457     0.150
     4.827   126.807     0.150
     4.930    74.486     0.150
     4.930   131.918     0.150
     5.220    77.947     0.150
     5.220   136.646     0.150
     5.246    78.328     0.150
     5.246   139.588     0.150
     5.415    82.328     0.150
     5.415   141.447     0.150
     5.439    84.447     0.150
     5.439   150.088     0.150
     5.521    82.697     0.150
     5.521   147.168     0.150
     5.845    86.527     0.150
     5.845   152.977     0.150
     5.893    85.547     0.150
     5.893    85.547     0.150
     5.893   150.758     0.150
     5.944   157.627     0.150
     5.964   155.748     0.150
     6.091    90.066     0.150
     6.091   159.998     0.150
     6.067    91.018     0.150
     6.067   157.896     0.150
     6.327    94.467     0.150
     6.327   168.828     0.150
     6.738    98.668     0.150
     6.738   176.197     0.150
     6.861    97.508     0.150
     6.861    97.508     0.150
     6.861   176.547     0.150
     7.504   111.297     0.150
     7.504   198.787     0.150
     7.709   568.416     0.150
     7.745   579.961     0.150
     7.677   111.578     0.150
     7.677   197.287     0.150
     9.853   143.027     0.150
     9.853   253.658     0.150
    10.607   154.688     0.150
    10.607   269.947     0.150
    10.638   154.688     0.150
    10.638   270.627     0.150
    11.245   335.221     0.150
    13.102   187.566     0.150
    13.102   332.717     0.150
    17.118   240.486     0.150
    22.774   300.947     0.150
    23.770   310.848     0.150
    24.359   316.486     0.150
    31.506   381.168     0.150
    31.506    12.600     0.150
    62.480   629.447     0.150
    65.753   651.771     0.150
    71.219   674.578     0.150
    81.536   735.316     0.150
   126.100  1142.543     0.150
   126.939  1141.529     0.150
     1.083    39.660     0.150
     2.485    72.129     0.150
     4.176    60.828     0.150
     4.304    62.516     0.150
     3.494    59.759     0.150
     3.588    62.949     0.150
     4.483    74.899     0.150
     4.671    77.009     0.150
     5.337    73.699     0.150
     5.913   162.188     0.150
     2.714    69.188     0.150
     3.507    59.047     0.150
     3.533    61.164     0.150
     0.955    14.062     0.150
     0.955    25.562     0.150
     1.596    27.367     0.150
     3.045    50.812     0.150
     3.083    50.758     0.150
     3.321    46.812     0.150
     3.440    49.055     0.150
     3.703    50.484     0.150
     4.088    66.859     0.150
     5.877    91.961     0.150
     7.622   106.461     0.150
    45.209   491.586     0.150
     1.519    21.395     0.150
     1.519    41.012     0.150
     2.012    62.863     0.150
     2.484    72.453     0.150
     3.200    52.902     0.150
     3.598    63.883     0.150
     3.695    60.414     0.150
     4.591    74.473     0.150
     4.591   135.324     0.150
     5.328   145.262     0.150
     5.728   159.762     0.150
     5.739    90.773     0.150
     7.239    99.312     0.150
     7.239   200.535     0.150
     7.173   542.570     0.150
     8.186   227.715     0.150
    56.435  4233.047     0.150
    56.445  4234.137     0.150
     3.419    97.574     0.150
     3.517   101.125     0.150
     3.677   108.566     0.150
     3.862   114.945     0.150
     3.873   113.395     0.150
     3.874   113.867     0.150
     3.984   113.523     0.150
     4.095    59.457     0.150
     4.204    66.547     0.150
     4.204   124.234     0.150
     4.305   127.555     0.150
     4.308    65.148     0.150
     4.351   125.734     0.150
     5.589   153.754     0.150
     5.905   162.926     0.150
     6.851   185.047     0.150
     8.728   264.766     0.150
    10.396   145.273     0.150
    51.297   176.336     0.150
    14.247   194.816     0.150
    14.165   195.867     0.150
    15.881   227.184     0.150
    17.897   253.805     0.150
    19.198   256.867     0.150
    19.419   263.914     0.150
    62.146   266.094     0.150
    40.344   287.387     0.150
    22.116   290.316     0.150
    48.817   324.234     0.150
    25.779   329.922     0.150
    30.298   381.215     0.150
    30.900   370.344     0.150
   130.203   373.867     0.150
    32.967   399.816     0.150
    44.691   590.316     0.150
    45.723   512.355     0.150
    48.816   523.344     0.150
    50.851   549.086     0.150
    32.026   556.996     0.150
   123.668   557.664     0.150
    60.799   620.832     0.150
    62.973   624.855     0.150
    62.973   623.445     0.150
    64.022   630.387     0.150
    76.818   723.621     0.150
   114.852  1115.477     0.150
   131.966  1148.297     0.150
   146.922  1186.645     0.150
     0.277     7.555     0.150
     0.277    13.414     0.150
     0.874    16.523     0.150
     0.874    28.645     0.150
     0.977    17.395     0.150
     0.977    31.102     0.150
     0.999    17.773     0.150
     1.440    22.703     0.150
     1.440    39.664     0.150
     1.527    26.523     0.150
     1.527    45.914     0.150
     1.988    30.664     0.150
     1.988    53.875     0.150
     2.051    61.254     0.150
     2.051    33.824     0.150
     2.051    61.254     0.150
     2.334    40.012     0.150
     2.334    70.191     0.150
     2.818    43.664     0.150
     2.818    78.703     0.150
     2.863    45.191     0.150
     2.863    78.914     0.150
     3.043    52.375     0.150
     3.043    82.145     0.150
     3.259    49.203     0.150
     3.259    85.715     0.150
     3.480    54.441     0.150
     3.480    90.383     0.150
     3.503    54.984     0.150
     3.503    91.543     0.150
     3.496    51.434     0.150
     3.496    95.781     0.150
     3.555    55.074     0.150
     3.555    94.152     0.150
     3.608   103.223     0.150
     3.608    55.734     0.150
     3.608   103.223     0.150
     3.627    56.145     0.150
     3.627    97.465     0.150
     3.778    58.633     0.150
     3.778    99.281     0.150
     3.800    56.672     0.150
     3.800   102.094     0.150
     3.831    59.102     0.150
     3.831   101.242     0.150
     3.933    60.102     0.150
     3.933   101.191     0.150
     3.972    64.543     0.150
     3.972    64.543     0.150
     3.972   116.375     0.150
     3.978    59.844     0.150
     3.978   105.363     0.150
     4.083    62.383     0.150
     4.083   106.094     0.150
     4.090    63.363     0.150
     4.090   109.934     0.150
     4.110    66.633     0.150
     4.110    66.633     0.150
     4.110   106.812     0.150
     4.162    64.344     0.150
     4.162   108.965     0.150
     4.184    64.133     0.150
     4.184   107.484     0.150
     4.371    64.555     0.150
     4.371   115.094     0.150
     4.443    67.242     0.150
     4.443   116.234     0.150
     4.449    68.824     0.150
     4.449   114.305     0.150
     4.450    66.043     0.150
     4.450   117.332     0.150
     4.451    67.844     0.150
     4.451   115.543     0.150
     4.638    70.133     0.150
     4.638   120.684     0.150
     4.954    74.012     0.150
     4.954   125.934     0.150
     5.276    78.594     0.150
     5.276   135.844     0.150
     5.388    79.184     0.150
     5.388   136.543     0.150
     5.426    80.984     0.150
     5.426   140.383     0.150
     5.623    84.062     0.150
     5.623   149.465     0.150
     5.637    83.934     0.150
     5.637   144.625     0.150
     5.742    85.352     0.150
     5.742   146.203     0.150
     5.941    83.484     0.150
     5.941    83.484     0.150
     5.941   152.512     0.150
     5.916    88.152     0.150
     5.916   154.965     0.150
     6.200    89.793     0.150
     6.200   162.504     0.150
     6.408   164.164     0.150
     6.732   103.004     0.150
     6.732   179.023     0.150
     7.415   106.922     0.150
     7.415   187.781     0.150
     8.613   121.914     0.150
    11.763   171.395     0.150
    51.444   178.742     0.150
    12.461   180.652     0.150
    13.387   193.953     0.150
    14.390   196.254     0.150
    95.776   200.754     0.150
    70.833   200.723     0.150
    95.785   200.102     0.150
   147.725   220.812     0.150
    17.750   245.055     0.150
    85.004   245.055     0.150
    95.331   248.414     0.150
    62.284   265.922     0.150
    20.349   273.664     0.150
    20.370   273.715     0.150
    22.195   293.922     0.150
    57.684   586.504     0.150
     0.970    18.250     0.150
     0.970    29.859     0.150
     1.041    21.289     0.150
     1.041    34.070     0.150
     1.041    21.289     0.150
     1.041    34.070     0.150
     1.201    22.141     0.150
     1.201    37.141     0.150
     1.811    29.961     0.150
     1.811    49.520     0.150
     1.799    32.770     0.150
     1.799    32.770     0.150
     1.799    47.250     0.150
     1.819    33.121     0.150
     1.819    46.410     0.150
     2.006    32.730     0.150
     2.006    53.719     0.150
     1.911    33.879     0.150
     1.911    33.879     0.150
     1.911    46.629     0.150
     2.226    35.500     0.150
     2.226    59.441     0.150
     2.522    40.500     0.150
     2.522    67.469     0.150
     2.618    41.430     0.150
     2.618    70.199     0.150
     2.656    42.879     0.150
     2.656    74.312     0.150
     2.570    42.129     0.150
     2.570    70.621     0.150
     2.661    42.891     0.150
     2.661    72.539     0.150
     2.715    43.301     0.150
     2.715    71.449     0.150
     2.755    43.312     0.150
     2.755    71.980     0.150
     2.746    43.449     0.150
     2.746    75.141     0.150
     2.918    46.281     0.150
     2.918    79.012     0.150
     2.964    47.969     0.150
     2.964    79.352     0.150
     2.930    47.781     0.150
     3.095    49.020     0.150
     3.113    48.520     0.150
     3.113    85.121     0.150
     3.119    49.121     0.150
     3.119    84.629     0.150
     3.221    50.691     0.150
     3.235    50.711     0.150
     3.235    88.422     0.150
     3.268    50.930     0.150
     3.268    89.332     0.150
     3.289    51.520     0.150
     3.289    90.590     0.150
     3.327    51.020     0.150
     3.264    53.941     0.150
     3.264    53.941     0.150
     3.264    91.492     0.150
     3.399    53.961     0.150
     3.399    90.941     0.150
     3.513    54.402     0.150
     3.513    94.141     0.150
     3.521    54.879     0.150
     3.526    55.141     0.150
     3.526    95.539     0.150
     3.539    54.980     0.150
     3.571    91.070     0.150
     3.533    56.070     0.150
     3.533    98.191     0.150
     3.631    55.922     0.150
     3.631    97.922     0.150
     3.700    57.000     0.150
     3.700    94.762     0.150
     3.725    58.230     0.150
     3.725    99.879     0.150
     3.932    60.461     0.150
     3.957    57.641     0.150
     3.957   104.211     0.150
     4.342    65.430     0.150
     4.342   112.219     0.150
     4.382    67.012     0.150
     4.650    70.480     0.150
     4.650   118.820     0.150
     4.934    74.230     0.150
     4.934   126.750     0.150
     5.361    80.129     0.150
     5.615    83.402     0.150
     5.615   142.641     0.150
     6.366    94.090     0.150
     6.294    95.301     0.150
     6.294    95.301     0.150
     7.115   104.191     0.150
     7.383   191.191     0.150
     7.570   111.312     0.150
     7.570   196.402     0.150
     8.830   220.352     0.150
     8.830   127.152     0.150
     8.830   220.352     0.150
     9.000   130.801     0.150
     9.000   223.449     0.150
     9.856   136.820     0.150
    10.208   148.922     0.150
    91.351   153.430     0.150
    50.535   182.312     0.150
    13.351   325.984     0.150
    13.709   206.664     0.150
    13.340   199.969     0.150
    95.362   205.621     0.150
    95.371   204.191     0.150
    70.918   207.539     0.150
    14.974   218.340     0.150
    16.601   236.312     0.150
    16.991   239.938     0.150
    80.125   250.859     0.150
    18.518   252.281     0.150
    61.484   270.320     0.150
    21.694   291.375     0.150
   122.009   298.312     0.150
   144.388   309.270     0.150
    29.227   358.082     0.150
    32.767   388.965     0.150
    32.767   388.969     0.150
    45.056   490.992     0.150
    49.360   524.582     0.150
    51.037   536.770     0.150
    52.377   548.191     0.150
    52.380   548.402     0.150
    32.574   561.711     0.150
    54.890   567.750     0.150
    55.992  4205.637     0.150
    56.001  4209.586     0.150
    63.137   625.660     0.150
    83.922   745.961     0.150
    90.719  3399.391     0.150
   114.170  1119.891     0.150
   115.157  1117.031     0.150
   127.548  1142.449     0.150
   108.329  1182.312     0.150
     0.785    14.416     0.150
     0.785    25.355     0.150
     0.785    14.416     0.150
     0.785    25.355     0.150
     0.870    17.686     0.150
     0.870    30.766     0.150
     1.145    21.057     0.150
     1.145    35.836     0.150
     1.160    18.195     0.150
     1.160    32.166     0.150
     1.160    32.496     0.150
     1.256    22.236     0.150
     1.256    38.355     0.150
     1.651    26.137     0.150
     1.651    42.576     0.150
     1.907    30.896     0.150
     1.907    54.426     0.150
     2.283    36.215     0.150
     2.283    64.125     0.150
     2.350    38.066     0.150
     2.589    41.557     0.150
     2.589    41.656     0.150
     2.589    72.096     0.150
     2.657    40.576     0.150
     2.657    70.406     0.150
     2.842    43.965     0.150
     2.882    43.285     0.150
     2.882    76.336     0.150
     2.869    45.605     0.150
     2.869    79.807     0.150
     2.899    45.695     0.150
     3.042    46.955     0.150
     3.042    81.576     0.150
     3.037    48.236     0.150
     3.037    82.246     0.150
     3.053    47.416     0.150
     3.053    83.016     0.150
     3.176    49.715     0.150
     3.176    87.125     0.150
     3.189    49.525     0.150
     3.189    92.986     0.150
     3.229    50.646     0.150
     3.324    52.205     0.150
     3.324    89.426     0.150
     3.385    51.195     0.150
     3.385    89.516     0.150
     3.356    52.236     0.150
     3.356    90.625     0.150
     3.372    52.865     0.150
     3.372    91.105     0.150
     3.379    52.506     0.150
     3.379    92.086     0.150
     3.438    53.105     0.150
     3.438    90.996     0.150
     3.478    54.025     0.150
     3.478    93.887     0.150
     3.482    53.875     0.150
     3.482    92.826     0.150
     3.561    54.336     0.150
     3.561    95.215     0.150
     3.573    54.736     0.150
     3.573    97.307     0.150
     3.834   101.775     0.150
     3.861    59.646     0.150
     3.861   102.887     0.150
     3.863    58.727     0.150
     3.863   103.236     0.150
     3.862    59.715     0.150
     3.862   102.926     0.150
     3.957    58.705     0.150
     3.957   100.326     0.150
     3.973    60.391     0.150
     4.049    61.166     0.150
     4.049   104.375     0.150
     4.052    61.266     0.150
     4.052   107.625     0.150
     4.742    71.236     0.150
     4.742   123.125     0.150
     4.928    73.576     0.150
     4.928   125.516     0.150
     4.961    73.086     0.150
     4.961   128.996     0.150
     5.013   144.035     0.150
     5.071    76.016     0.150
     5.071   131.146     0.150
     5.265    78.486     0.150
     5.265   136.846     0.150
     5.388    80.256     0.150
     5.388   138.416     0.150
     5.392    79.955     0.150
     5.603    81.666     0.150
     5.603   145.086     0.150
     5.975    87.646     0.150
     5.975   154.375     0.150
     6.636    96.637     0.150
     6.636   170.936     0.150
     6.968   101.557     0.150
     6.968   176.045     0.150
     7.155   195.316     0.150
     7.293   106.715     0.150
     7.623   110.416     0.150
     7.623   195.125     0.150
     7.796   563.199     0.150
     7.828   566.807     0.150
     9.126   131.766     0.150
     9.335   133.926     0.150
     9.335   234.516     0.150
     9.556   239.926     0.150
    10.374   151.486     0.150
    91.185   158.156     0.150
    11.578   160.596     0.150
    51.225   170.137     0.150
    76.989   187.057     0.150
    13.674   189.066     0.150
    15.315   214.545     0.150
    18.685   252.115     0.150
    19.122   256.746     0.150
    20.204   267.736     0.150
    21.145   279.705     0.150
    21.652   283.846     0.150
   143.862   299.416     0.150
    23.056    17.045     0.150
    23.982    18.100     0.150
    24.611   313.666     0.150
    25.293    19.154     0.150
    61.570   345.916     0.150
    31.568   377.756     0.150
    48.693   517.855     0.150
    71.340   530.426     0.150
    50.769   535.396     0.150
    54.533   623.266     0.150
    56.663  4246.025     0.150
    56.672  4245.750     0.150
    60.356   602.176     0.150
    60.356   602.086     0.150
    60.684   605.137     0.150
    62.857   618.846     0.150
    65.603   635.926     0.150
    66.191   665.916     0.150
    66.319   667.375     0.150
    66.319   643.016     0.150
    66.535   644.176     0.150
    66.535   668.096     0.150
    82.058   732.670     0.150
    84.639   745.236     0.150
    84.999   747.721     0.150
    87.764   761.449     0.150
    90.505   773.375     0.150
    90.505  1531.676     0.150
    90.505  2390.676     0.150
    93.768   788.977     0.150
   108.960  1098.787     0.150
   113.492  1154.477     0.150
   149.870  1182.396     0.150
     1.041    32.656     0.150
     1.236    39.391     0.150
     1.413    24.367     0.150
     1.593    47.648     0.150
     3.353   105.531     0.150
     0.942    34.059     0.150
     1.617    24.027     0.150
     1.617    44.078     0.150
     3.991    57.750     0.150
     0.690    13.766     0.150
     0.690    22.391     0.150
     1.224    21.023     0.150
     1.224    35.102     0.150
     1.479    25.602     0.150
     1.731    30.680     0.150
     1.751    29.875     0.150
     1.751    29.875     0.150
     1.751    51.578     0.150
     2.095    35.070     0.150
     2.216    35.898     0.150
     2.216    62.234     0.150
     2.307    36.430     0.150
     2.494    39.133     0.150
     2.494    66.992     0.150
     2.901    47.898     0.150
     2.901    82.211     0.150
     2.974    51.430     0.150
     2.974    94.734     0.150
     3.026    47.680     0.150
     3.026    84.289     0.150
     3.051    47.539     0.150
     3.051    83.070     0.150
     3.116    50.133     0.150
     3.510    54.703     0.150
     3.510    96.375     0.150
     3.466    53.984     0.150
     3.466    96.469     0.150
     3.617    55.766     0.150
     3.617    92.672     0.150
     3.934   103.430     0.150
     4.099    65.023     0.150
     4.316    66.148     0.150
     4.316   112.719     0.150
     4.638    69.648     0.150
     4.638   114.883     0.150
     4.633    70.766     0.150
     4.633   125.211     0.150
     4.736    72.211     0.150
     4.736   121.812     0.150
     4.700    75.133     0.150
     4.700   127.062     0.150
     5.028    76.719     0.150
     5.028   131.516     0.150
     5.054    82.414     0.150
     5.658    84.711     0.150
     5.658   151.078     0.150
     5.741   157.016     0.150
     6.210    90.961     0.150
     6.210   167.805     0.150
     6.544    96.922     0.150
     6.672   178.703     0.150
     6.672   178.703     0.150
     7.409   111.391     0.150
     7.409   197.328     0.150
     7.440   202.172     0.150
     7.843   116.414     0.150
     7.843   211.422     0.150
     9.197   138.891     0.150
     9.197   241.398     0.150
     9.338   135.180     0.150
     9.338   236.102     0.150
     9.271   241.922     0.150
     9.845   145.016     0.150
     9.845   259.781     0.150
    10.215   261.281     0.150
    11.280   168.969     0.150
    13.183   197.469     0.150
    13.770   193.344     0.150
    13.781   196.805     0.150
    71.187   207.164     0.150
    18.813   258.391     0.150
    19.769   274.070     0.150
    61.531   272.102     0.150
    21.441   286.680     0.150
    39.578   300.969     0.150
    94.684   302.820     0.150
    24.471   534.625     0.150
    24.886   324.391     0.150
    28.205   352.352     0.150
    29.660   363.875     0.150
    30.679   369.273     0.150
    31.297   379.945     0.150
    32.586   387.375     0.150
    32.586   554.305     0.150
    45.180   493.625     0.150
    45.180   595.070     0.150
    46.446   504.172     0.150
    48.173   607.273     0.150
    72.068   530.555     0.150
    98.026   536.891     0.150
    72.068   546.930     0.150
   123.113   547.195     0.150
    32.598   563.898     0.150
    54.282   562.875     0.150
    54.463   565.133     0.150
    54.956   570.578     0.150
    58.166  1070.469     0.150
    59.367   599.172     0.150
    60.188   606.539     0.150
    60.213   607.109     0.150
    61.370   613.203     0.150
    61.491  1104.875     0.150
    65.653   644.211     0.150
    65.653   644.195     0.150
    66.528   647.633     0.150
    71.678   681.000     0.150
    80.605   731.328     0.150
    81.840   736.352     0.150
    81.957   737.109     0.150
    82.304   738.992     0.150
    87.754   769.289     0.150
    91.089  2359.672     0.150
   115.312  1118.672     0.150
   120.886  1130.125     0.150
   131.360  1151.820     0.150
     0.802    23.438     0.150
     0.820    18.078     0.150
     0.820    32.156     0.150
     2.644    47.648     0.150
     2.732    78.094     0.150
     3.076    44.977     0.150
     3.509    64.594     0.150
     3.509   104.062     0.150
     1.100    21.461     0.150
     1.621    41.664     0.150
     1.831    54.273     0.150
     2.655    44.758     0.150
     3.141    41.680     0.150
     3.446    99.211     0.150
     4.585   114.070     0.150
     7.065   102.844     0.150
     8.959   220.242     0.150
    24.492   316.297     0.150
    55.154   568.219     0.150
     0.995    31.516     0.150
     3.497    54.496     0.150
     3.680    55.797     0.150
     6.364   102.887     0.150
     1.004    30.855     0.150
     2.786    44.617     0.150
     3.973    57.785     0.150
     5.168    76.758     0.150
     6.289   177.055     0.150
     6.415   104.637     0.150
     1.031    35.873     0.150
     2.782    78.633     0.150
     0.306     7.053     0.150
     1.389    25.582     0.150
     1.389    43.113     0.150
     1.488    25.773     0.150
     1.488    45.492     0.150
     1.642    27.143     0.150
     1.642    52.953     0.150
     1.671    28.693     0.150
     1.671    50.482     0.150
     1.939    31.193     0.150
     2.382    36.672     0.150
     2.644    42.613     0.150
     2.830    46.582     0.150
     2.905    46.643     0.150
     2.905    85.383     0.150
     3.249    51.383     0.150
     3.334    52.672     0.150
     3.453    54.973     0.150
     3.470    54.543     0.150
     3.926    61.172     0.150
     3.926   115.992     0.150
     4.352   117.422     0.150
     4.357    67.582     0.150
     4.807    77.293     0.150
    96.029   204.393     0.150
     0.849    15.750     0.150
     0.849    26.639     0.150
     1.211    20.600     0.150
     1.211    34.850     0.150
     1.420    24.689     0.150
     1.420    42.979     0.150
     1.597    27.600     0.150
     1.671    28.570     0.150
     1.671    28.570     0.150
     1.671    48.969     0.150
     1.722    29.750     0.150
     2.005    32.369     0.150
     2.005    57.129     0.150
     2.245    61.840     0.150
     2.335    36.350     0.150
     2.335    61.699     0.150
     2.466    38.270     0.150
     2.466    65.350     0.150
     2.694    75.080     0.150
     2.598    40.900     0.150
     2.598    80.340     0.150
     2.733    42.449     0.150
     2.805    43.529     0.150
     2.784    42.000     0.150
     2.834    45.139     0.150
     2.834    84.570     0.150
     2.868    45.539     0.150
     2.868    85.770     0.150
     2.992    45.850     0.150
     2.992    79.809     0.150
     3.025    48.910     0.150
     3.025    84.520     0.150
     3.052    48.350     0.150
     3.052    90.779     0.150
     3.100    48.920     0.150
     3.238    49.969     0.150
     3.251    49.910     0.150
     3.251    83.809     0.150
     3.237    50.949     0.150
     3.245    89.490     0.150
     3.243    49.969     0.150
     3.268    51.189     0.150
     3.268    90.709     0.150
     3.303    48.789     0.150
     3.303    97.320     0.150
     3.269    50.539     0.150
     3.269    91.029     0.150
     3.274    49.969     0.150
     3.283    50.629     0.150
     3.283    90.500     0.150
     3.331    51.299     0.150
     3.331    93.160     0.150
     3.331    97.150     0.150
     3.366    50.629     0.150
     3.429    54.619     0.150
     3.564    54.100     0.150
     3.564    92.170     0.150
     3.513    55.949     0.150
     3.559    55.350     0.150
     3.581    54.670     0.150
     3.678    56.820     0.150
     3.683    55.090     0.150
     3.683    98.109     0.150
     3.689   106.779     0.150
     3.788    96.910     0.150
     3.813    58.869     0.150
     3.813    98.680     0.150
     3.866    59.180     0.150
     3.866   102.129     0.150
     4.137    62.969     0.150
     4.137   105.689     0.150
     4.119   117.080     0.150
     4.198    64.080     0.150
     4.378   125.359     0.150
     4.378    66.289     0.150
     4.457    67.590     0.150
     4.577    68.469     0.150
     4.577   115.809     0.150
     4.602    69.289     0.150
     4.602   117.799     0.150
     4.837    71.449     0.150
     4.837   126.689     0.150
     4.919    73.949     0.150
     4.919   125.109     0.150
     4.940    71.900     0.150
     5.131    77.029     0.150
     5.131   131.689     0.150
     5.596    79.930     0.150
     5.594    82.070     0.150
     5.868   160.949     0.150
     6.364    92.809     0.150
     6.599    96.660     0.150
     7.178   101.629     0.150
     7.178   101.629     0.150
     7.178   187.090     0.150
     7.327   106.900     0.150
     7.479   107.789     0.150
     7.479   201.629     0.150
     7.983   115.129     0.150
     7.983   199.350     0.150
     9.042   129.910     0.150
     9.042   227.559     0.150
     9.224   132.359     0.150
     9.224   231.020     0.150
     9.505   132.840     0.150
     9.505   132.840     0.150
     9.505   243.779     0.150
    10.034   140.709     0.150
    10.034   140.709     0.150
    10.071   264.209     0.150
    13.532   199.490     0.150
   148.547   227.539     0.150
   126.072   245.561     0.150
    94.987   247.879     0.150
    19.506   267.990     0.150
   122.768   273.969     0.150
    21.254   284.109     0.150
    21.273   283.889     0.150
   116.537   291.650     0.150
   144.169   305.660     0.150
    24.297   533.039     0.150
    24.300   311.490     0.150
    93.986   320.750     0.150
    25.055   533.090     0.150
   107.879   322.650     0.150
    84.825   326.209     0.150
    21.516   333.439     0.150
    27.066   338.389     0.150
    32.239   550.520     0.150
    34.447   403.879     0.150
    36.290   417.629     0.150
    44.887   487.939     0.150
    44.887   590.770     0.150
    45.402   591.740     0.150
    48.249   520.215     0.150
    62.411   619.365     0.150
    70.826   669.689     0.150
    70.826   669.889     0.150
    80.227   725.529     0.150
    80.227   725.490     0.150
    81.945   735.219     0.150
    81.986   734.080     0.150
    81.296   734.799     0.150
    82.092   734.779     0.150
    82.924   738.760     0.150
    84.947   749.689     0.150
    85.207   751.320     0.150
    85.207   751.170     0.150
    87.414   763.820     0.150
    88.596   768.549     0.150
    89.918   775.889     0.150
    90.710  2692.689     0.150
    95.407   799.928     0.150
    71.745   805.609     0.150
   115.003  1115.500     0.150
   117.426  1152.289     0.150
     1.213    42.415     0.150
     1.662    54.674     0.150
     2.017    51.625     0.150
     2.017    61.965     0.150
     3.255    96.164     0.150
     3.750    53.645     0.150
     3.810    54.977     0.150
     3.873    68.266     0.150
     3.873   111.445     0.150
     3.945    55.637     0.150
     4.255   118.754     0.150
     4.403    65.254     0.150
     5.850    80.395     0.150
     6.957   170.094     0.150
     7.655   563.652     0.150
     7.684   577.191     0.150
     7.712   189.164     0.150
     8.371   205.855     0.150
     9.565   134.254     0.150
     9.847   135.395     0.150
    10.710   151.645     0.150
    10.805   152.977     0.150
    51.014   178.836     0.150
    13.205   196.457     0.150
    92.615   232.586     0.150
    18.219   248.156     0.150
    11.570   252.734     0.150
    19.427   268.555     0.150
    24.110   531.312     0.150
    24.991   547.105     0.150
    21.626   332.266     0.150
   130.401   372.785     0.150
    48.010   514.324     0.150
    62.680   621.082     0.150
    71.407   671.145     0.150
    81.035   731.117     0.150
    82.400   735.754     0.150
    82.466   738.676     0.150
    84.114   745.617     0.150
    84.856   752.855     0.150
    90.789   777.816     0.150
    93.716   790.715     0.150
    99.114   818.984     0.150
     3.067    44.398     0.150
     3.265    55.769     0.150
     3.265    45.019     0.150
     3.366    60.278     0.150
     4.157   101.438     0.150
    24.041   307.573     0.150
    44.578    15.976     0.150
    54.709   561.849     0.150
    54.709    15.750     0.150
     1.794    42.906     0.150
     2.769    40.837     0.150
    24.411   315.052     0.150
    45.008   488.645     0.150
    55.113   565.749     0.150
     1.609    50.637     0.150
     2.137    36.967     0.150
     3.538    49.747     0.150
     4.398    72.847     0.150
     4.398   118.687     0.150
     4.436    71.897     0.150
     4.482    62.987     0.150
     4.479    72.847     0.150
     4.852    68.417     0.150
     5.856   161.487     0.150
    56.369  4232.049     0.150
    56.378  4233.329     0.150
     1.590    40.773     0.150
     1.797    45.043     0.150
     2.665    38.613     0.150
     2.885    73.301     0.150
     3.133    89.684     0.150
     3.237    55.711     0.150
     5.343    76.648     0.150
     0.086     3.973     0.150
     0.086     6.895     0.150
     1.136    21.543     0.150
     1.136    34.895     0.150
     1.235    22.512     0.150
     1.235   442.137     0.150
     1.587    28.395     0.150
     1.834    31.422     0.150
     1.834    55.152     0.150
     1.706    30.344     0.150
     2.346    39.812     0.150
     2.346    70.035     0.150
     2.578    43.273     0.150
     2.762    44.145     0.150
     2.762    78.523     0.150
     2.895    48.184     0.150
     2.895    80.004     0.150
     3.051    49.691     0.150
     3.051    86.074     0.150
     2.998    47.984     0.150
     2.998    83.023     0.150
     3.104    49.113     0.150
     3.104    87.633     0.150
     3.530    63.723     0.150
     3.530    63.723     0.150
     3.546    59.172     0.150
     3.565    57.793     0.150
     3.565    57.793     0.150
     3.565   100.832     0.150
     3.551    58.613     0.150
     3.551    99.633     0.150
     3.660    57.133     0.150
     3.660    97.953     0.150
     3.751    59.441     0.150
     3.751   101.984     0.150
     3.851    67.504     0.150
     3.974    69.062     0.150
     3.989    68.762     0.150
     3.992    68.684     0.150
     3.995    65.262     0.150
     3.995   113.512     0.150
     3.997    56.965     0.150
     3.997    56.965     0.150
     3.997    62.828     0.150
     4.001    66.941     0.150
     4.001   112.125     0.150
     4.012    68.684     0.150
     4.016    69.152     0.150
     4.013    62.965     0.150
     4.013   112.723     0.150
     4.023    69.852     0.150
     4.038    69.742     0.150
     4.036    70.215     0.150
     4.042    68.203     0.150
     4.042   115.062     0.150
     4.078    70.441     0.150
     4.112    71.152     0.150
     4.129    71.543     0.150
     4.181    70.793     0.150
     4.236    71.152     0.150
     4.262    72.844     0.150
     4.227    63.852     0.150
     4.227   122.055     0.150
     4.317    74.145     0.150
     4.453    72.094     0.150
     4.453   123.953     0.150
     4.503    71.465     0.150
     4.503   128.922     0.150
     4.521    64.973     0.150
     4.521    71.172     0.150
     4.521   124.152     0.150
     4.527    72.414     0.150
     4.527    72.414     0.150
     4.527   127.914     0.150
     4.628    72.184     0.150
     4.717    73.875     0.150
     4.717   130.582     0.150
     4.880    79.523     0.150
     4.880    79.523     0.150
     4.880   136.234     0.150
     4.886    74.164     0.150
     4.886   130.984     0.150
     5.206    79.012     0.150
     5.206   142.805     0.150
     5.248    78.383     0.150
     5.248   141.883     0.150
     5.329    82.984     0.150
     5.329    82.984     0.150
     5.329   146.633     0.150
     5.593    89.562     0.150
     5.593    89.562     0.150
     5.593   152.113     0.150
     5.598    85.852     0.150
     5.598   151.984     0.150
     5.629    87.223     0.150
     5.629    87.223     0.150
     5.629   148.352     0.150
     5.705    84.812     0.150
     5.705   146.664     0.150
     5.887   163.715     0.150
     5.887    87.953     0.150
     5.887   163.715     0.150
     6.100    92.215     0.150
     6.100   166.043     0.150
     6.203    93.922     0.150
     6.203   165.574     0.150
     6.267    93.625     0.150
     6.267   163.582     0.150
     6.343    96.363     0.150
     6.343   163.312     0.150
     7.006   106.344     0.150
     7.006   183.395     0.150
     7.281   108.395     0.150
     7.281   191.742     0.150
     7.289   105.992     0.150
     7.436   112.484     0.150
     7.436   112.484     0.150
     7.436   191.223     0.150
     7.294   113.883     0.150
     7.294   555.785     0.150
     7.322   111.973     0.150
     7.324   106.473     0.150
     7.787   116.645     0.150
     7.787   206.633     0.150
     8.067   218.625     0.150
     8.067   118.332     0.150
     8.067   211.562     0.150
     8.400   125.262     0.150
     8.888   240.414     0.150
    10.806   285.137     0.150
    11.001  2364.988     0.150
    11.001   160.465     0.150
    11.058   291.676     0.150
    11.198   294.176     0.150
    11.640   169.715     0.150
    11.819   310.898     0.150
    12.446   332.688     0.150
    12.535   180.762     0.150
    51.211   182.363     0.150
    12.956   343.480     0.150
    13.169   350.629     0.150
    13.434   190.082     0.150
    13.830   201.777     0.150
    95.951   204.223     0.150
    95.960   203.793     0.150
    15.523   219.262     0.150
   147.846   227.113     0.150
    19.013   268.562     0.150
    19.296  7103.512     0.150
    19.303   482.629     0.150
    19.423   267.352     0.150
    19.423   482.582     0.150
    19.423   271.543     0.150
    19.423   432.293     0.150
    19.423   267.262     0.150
    31.846   266.184     0.150
    20.467   278.262     0.150
    20.702   275.992     0.150
    20.642   280.305     0.150
    20.679   276.145     0.150
    20.679   276.164     0.150
    20.664   290.520     0.150
    20.708   277.352     0.150
    20.919   282.094     0.150
    20.963   283.262     0.150
    21.116   287.348     0.150
    21.336   292.281     0.150
    21.418   284.465     0.150
    21.386   290.852     0.150
    91.455   289.762     0.150
    21.706   295.992     0.150
    91.856   290.992     0.150
    21.829   295.453     0.150
    22.019   294.562     0.150
    22.019   299.703     0.150
    22.077   303.672     0.150
    22.085   298.504     0.150
    22.109   294.004     0.150
    22.318   294.164     0.150
    21.670   296.562     0.150
    22.395   294.562     0.150
    81.859   297.645     0.150
    22.672   300.613     0.150
    22.755   300.703     0.150
    23.338   307.164     0.150
    23.839   316.992     0.150
    23.978  2318.840     0.150
    24.300   313.293     0.150
    54.824   315.254     0.150
    24.311   321.383     0.150
    24.362   321.574     0.150
    24.421   318.562     0.150
    24.156   318.734     0.150
    93.564   320.703     0.150
    24.667   324.863     0.150
    24.778   318.465     0.150
    24.812   326.043     0.150
   108.422   322.203     0.150
    24.977     6.098     0.150
    24.980  2314.613     0.150
    24.980   320.402     0.150
    25.454     0.949     0.150
    25.762   328.363     0.150
    26.358   338.312     0.150
    93.549   351.953     0.150
    61.400   355.262     0.150
    80.185   361.164     0.150
    32.890   361.215     0.150
    32.890   364.062     0.150
    33.833   364.465     0.150
    29.588   366.465     0.150
    29.975   371.762     0.150
    30.345   368.254     0.150
    30.345     0.930     0.150
    30.261   370.184     0.150
    30.261   370.164     0.150
    30.261   369.844     0.150
    61.406   372.863     0.150
    22.107   375.062     0.150
    30.871   374.164     0.150
   125.997   374.762     0.150
    31.132   376.863     0.150
    31.207   379.262     0.150
    92.634   380.262     0.150
   101.969   384.164     0.150
    27.048   386.863     0.150
    31.905   384.562     0.150
    31.961 11407.785     0.150
    32.429   388.887     0.150
    32.429   389.762     0.150
    33.833   398.262     0.150
    94.509   408.762     0.150
    36.122   418.363     0.150
    36.381   420.172     0.150
    36.381   421.863     0.150
    39.389   446.926     0.150
    39.800   451.285     0.150
    40.274   460.363     0.150
    41.584   464.707     0.150
    42.219   468.395     0.150
    44.798   491.738     0.150
    44.865  2771.863     0.150
    44.865   491.332     0.150
    46.056   502.910     0.150
    48.748   524.363     0.150
   113.206   531.371     0.150
    49.642   535.035     0.150
    50.148   534.434     0.150
    81.202   541.215     0.150
    98.256   540.520     0.150
    98.256   542.262     0.150
    98.876   546.184     0.150
    51.960   546.160     0.150
    52.821   562.191     0.150
    53.512   558.965     0.150
   123.690   560.504     0.150
    53.719  2809.660     0.150
    27.048   564.160     0.150
    54.217   564.887     0.150
    54.708   567.965     0.150
    54.792   566.863     0.150
    54.792  2378.863     0.150
    54.792  2811.113     0.150
    54.792   568.262     0.150
    55.509   576.074     0.150
    55.509   579.004     0.150
    55.713   584.824     0.150
    56.436  4234.316     0.150
    56.446  4244.824     0.150
    56.660   583.762     0.150
    56.785  4279.895     0.150
    56.789  4280.410     0.150
    56.803  4279.824     0.150
    57.062   584.824     0.150
    57.981   580.301     0.150
    57.835   595.965     0.150
    58.515   605.520     0.150
    58.572   594.441     0.150
    58.836   600.246     0.150
    59.106   597.535     0.150
    59.456   600.770     0.150
    59.627   606.816     0.150
    59.634   611.340     0.150
    59.865   611.996     0.150
    60.480   606.082     0.150
    60.480   608.262     0.150
    60.679   610.715     0.150
    61.715   617.613     0.150
    61.715   616.809     0.150
    61.757   617.066     0.150
    62.447   621.902     0.150
    62.903   623.215     0.150
    64.518   635.363     0.150
    64.518   633.434     0.150
    64.774   641.035     0.150
    64.774   642.395     0.150
    65.210   638.363     0.150
    65.531   643.012     0.150
    66.201   643.762     0.150
    66.120   649.387     0.150
    66.120   645.480     0.150
    66.120   649.504     0.150
    66.120     3.242     0.150
    66.120   649.301     0.150
    67.861   656.215     0.150
    67.861   664.934     0.150
    68.303   661.949     0.150
    68.523   662.863     0.150
    68.863   663.723     0.150
    69.247   668.176     0.150
    69.247   668.176     0.150
    69.329   665.527     0.150
    69.498   664.941     0.150
    69.498   664.965     0.150
    70.020   672.301     0.150
    70.020   672.996     0.150
    70.185   674.965     0.150
    70.578   673.863     0.150
    70.835   675.363     0.150
    71.088   678.074     0.150
    74.397   701.191     0.150
    74.468   702.660     0.150
    74.734   704.832     0.150
    74.734   704.684     0.150
    75.812   713.145     0.150
    77.099   710.051     0.150
    77.639   712.324     0.150
    77.750   718.613     0.150
    77.796   718.066     0.150
    77.973   715.762     0.150
    78.449   725.402     0.150
    78.449   725.363     0.150
    78.449  1313.066     0.150
    79.591   725.363     0.150
    79.882   726.832     0.150
    80.239   728.262     0.150
    80.341   728.980     0.150
    80.746  1859.660     0.150
    80.746   730.566     0.150
    80.569   741.637     0.150
    80.864   733.582     0.150
    81.890   738.762     0.150
    81.920  1375.480     0.150
   126.622   738.574     0.150
   126.622  1371.957     0.150
    82.219   738.840     0.150
    82.219   740.965     0.150
    82.447  1382.520     0.150
    82.454  1696.262     0.150
    82.554  1699.996     0.150
    82.578   740.730     0.150
    82.578   742.355     0.150
    82.596   742.652     0.150
    82.644   742.660     0.150
    82.578   744.465     0.150
    82.987  1703.184     0.150
    83.008   744.590     0.150
    83.008   744.520     0.150
    83.008   742.754     0.150
    83.098  1704.645     0.150
    83.243  1703.301     0.150
    83.254   744.934     0.150
    83.633   747.480     0.150
    83.623   745.246     0.150
    83.905   746.105     0.150
    83.938   746.980     0.150
    83.970   748.160     0.150
    84.050   748.746     0.150
    84.279   748.457     0.150
    84.393   758.262     0.150
    84.394   758.262     0.150
    84.409   758.629     0.150
    84.803   752.676     0.150
    84.803   752.660     0.150
    85.178   758.863     0.150
    85.357   756.363     0.150
    85.415  1849.387     0.150
    85.489   753.152     0.150
    85.488   754.152     0.150
    85.488   754.160     0.150
    85.234   764.027     0.150
    85.693   755.207     0.150
    85.741   764.387     0.150
    85.811   756.387     0.150
    86.109   767.434     0.150
    86.640   762.184     0.150
    87.346   763.363     0.150
    88.169   769.738     0.150
    88.169  1401.871     0.150
    88.070   777.480     0.150
    88.308   770.285     0.150
    88.481   771.715     0.150
    88.745   769.652     0.150
    88.907   773.590     0.150
    89.413   775.160     0.150
   107.689   775.285     0.150
    89.708   774.465     0.150
    89.708    14.797     0.150
    89.708  2000.465     0.150
    89.801  1109.965     0.150
    90.054   777.863     0.150
    90.063   778.934     0.150
    90.351   779.738     0.150
    90.257   781.965     0.150
    90.550   777.324     0.150
    90.550   781.363     0.150
    90.550   777.363     0.150
    90.730   782.762     0.150
    90.671   781.191     0.150
    90.692   790.363     0.150
    90.906   779.762     0.150
    90.995   784.574     0.150
    91.058   783.066     0.150
    91.205  2324.816     0.150
    91.205   783.566     0.150
    91.205     7.500     0.150
    91.205  1024.363     0.150
    91.205  1427.363     0.150
    91.205  1539.363     0.150
    91.205  1787.363     0.150
    91.205  1837.363     0.150
    91.205  2033.363     0.150
    91.205  2231.363     0.150
    91.205  2343.262     0.150
    91.205  2531.363     0.150
    91.205  2573.363     0.150
    91.205  4373.363     0.150
    91.014   792.105     0.150
    91.414   784.887     0.150
    91.463   787.160     0.150
    91.463   787.160     0.150
    91.471  1006.535     0.150
    91.471  1839.238     0.150
    91.595   785.762     0.150
    91.482   793.262     0.150
    91.618  2033.465     0.150
    91.805   787.660     0.150
    91.895  1837.559     0.150
    92.106  1837.027     0.150
    92.143   788.566     0.150
    92.143   791.160     0.150
    92.143  1013.363     0.150
    92.143  1139.363     0.150
    92.303   794.004     0.150
    92.303   793.965     0.150
    92.460   790.262     0.150
    92.460  1444.363     0.150
    92.179   796.215     0.150
    92.521  1840.793     0.150
    92.634   791.262     0.150
    92.666   790.762     0.150
    92.666   790.762     0.150
    92.400   797.246     0.150
    92.737  1445.863     0.150
    92.737   790.160     0.150
    92.805  1016.660     0.150
    92.887  1833.191     0.150
    92.887   790.660     0.150
    92.637   797.246     0.150
    93.187   794.363     0.150
    93.202   798.480     0.150
    93.202   798.465     0.150
    93.219   794.363     0.150
    93.219   794.363     0.150
    93.240   794.363     0.150
    93.240   794.363     0.150
    93.241   794.363     0.150
    93.241  1448.965     0.150
    93.300  1836.184     0.150
    93.321   794.363     0.150
    93.462  1830.090     0.150
    93.169   800.324     0.150
    93.494  1862.660     0.150
    93.494   795.363     0.150
    93.631   795.863     0.150
    93.311   800.324     0.150
    93.736  1023.621     0.150
    93.532   803.410     0.150
    93.893  1867.660     0.150
    93.893   797.965     0.150
    94.041   797.621     0.150
    93.827   802.379     0.150
    93.859   803.410     0.150
    94.225   798.402     0.150
    94.225   800.113     0.150
    94.225   800.066     0.150
    94.293   803.363     0.150
    94.293  2391.113     0.150
    94.304  1831.707     0.150
    94.343   796.160     0.150
    94.080   805.285     0.150
    94.467   801.957     0.150
    94.467   801.965     0.150
    94.320   796.723     0.150
    94.320   796.762     0.150
    94.320   801.645     0.150
    94.583   797.152     0.150
    94.583   797.160     0.150
    94.660   803.441     0.150
    94.660  1030.926     0.150
    94.660  1442.770     0.150
    94.660   803.465     0.150
    94.660  1030.965     0.150
    94.660   800.293     0.150
    94.752   802.066     0.150
    94.752   802.066     0.150
    94.808  1830.457     0.150
    94.856   806.215     0.150
    94.856  1443.434     0.150
    94.901   805.816     0.150
    94.901   805.863     0.150
    94.605   807.520     0.150
    94.964  1832.207     0.150
    94.770   806.496     0.150
    95.128   802.863     0.150
    95.128   802.840     0.150
    95.130   803.246     0.150
    95.385   808.176     0.150
    95.385   808.160     0.150
    95.385  1036.863     0.150
    95.336   809.996     0.150
    95.645  1035.965     0.150
    95.376   810.918     0.150
    95.853   806.457     0.150
    95.846   807.262     0.150
    95.846   807.801     0.150
    95.904   805.457     0.150
    95.925   808.066     0.150
    96.018   810.660     0.150
    96.018   810.676     0.150
    96.127   812.184     0.150
    96.127  1044.652     0.150
    96.127   812.160     0.150
    96.205   809.066     0.150
    96.032   814.715     0.150
    96.366   806.980     0.150
    96.366   806.980     0.150
    96.366  1162.965     0.150
    96.366  1879.824     0.150
    96.366  2104.387     0.150
    96.366   806.965     0.150
    96.366  1041.762     0.150
    96.366  1162.965     0.150
    96.366  1442.262     0.150
    96.366  1879.762     0.150
    96.366  2104.363     0.150
    96.085   814.730     0.150
    96.617   815.863     0.150
    96.617   815.902     0.150
    96.792   812.465     0.150
    96.792   812.488     0.150
    96.816   812.910     0.150
    96.816   812.965     0.150
    71.825   811.582     0.150
    97.132   811.566     0.150
    97.132   813.973     0.150
    97.229   816.676     0.150
    97.229  1052.074     0.150
    97.229   816.660     0.150
    97.229  1052.066     0.150
    97.229  1451.566     0.150
    96.959   814.824     0.150
    97.004   815.746     0.150
    97.389   815.645     0.150
    97.093   817.145     0.150
    97.447   815.262     0.150
    97.447   815.301     0.150
    97.261   816.770     0.150
    97.497   818.121     0.150
    97.510   819.855     0.150
    97.783   821.910     0.150
    98.549   806.066     0.150
    98.264   821.910     0.150
    98.270   826.027     0.150
    98.291   821.910     0.150
    98.876   821.863     0.150
    98.586   822.941     0.150
    99.020   822.074     0.150
    99.020   822.066     0.150
    98.830   827.051     0.150
    99.153   823.535     0.150
    99.153   823.566     0.150
    99.187  1186.160     0.150
    99.187  2145.863     0.150
    99.311   824.020     0.150
    99.311   821.332     0.150
    99.311   821.363     0.150
    99.329   823.441     0.150
    99.329  1070.660     0.150
    99.542   823.863     0.150
    99.308   828.973     0.150
    99.631  2308.590     0.150
    99.631   823.965     0.150
    99.694   826.082     0.150
    99.694   825.762     0.150
    99.694   818.934     0.150
    99.719   825.863     0.150
    99.427   826.027     0.150
    99.802   825.965     0.150
    99.602   831.168     0.150
    99.932   826.934     0.150
    99.932   826.965     0.150
    99.970   827.746     0.150
   100.161   826.262     0.150
   100.324   828.566     0.150
   100.031   830.137     0.150
   100.440   828.824     0.150
   100.170   832.191     0.150
   100.545   833.863     0.150
   100.545  1078.652     0.150
   100.582   828.363     0.150
   100.289   832.191     0.150
   100.627   829.762     0.150
   100.979   831.410     0.150
   101.012   830.340     0.150
   101.012   830.363     0.150
   101.137   831.645     0.150
   101.137   831.660     0.150
   101.266   832.699     0.150
   101.271   837.324     0.150
   101.281   836.348     0.150
   101.281   836.363     0.150
   100.993   836.309     0.150
   101.335   834.801     0.150
   101.368   836.262     0.150
   101.403   837.957     0.150
   101.578   834.074     0.150
   101.578   834.066     0.150
   101.708   833.363     0.150
   101.750   840.262     0.150
   101.926   840.160     0.150
   101.932   836.762     0.150
   102.141   834.371     0.150
   102.141   834.363     0.150
   101.840   843.504     0.150
   102.252   838.715     0.150
   102.340   842.051     0.150
   102.305   840.262     0.150
   102.900   838.566     0.150
   102.934   839.441     0.150
   102.934   839.465     0.150
   102.994   844.762     0.150
   103.159   841.184     0.150
   103.159   841.160     0.150
   103.278   841.535     0.150
   103.278   841.566     0.150
   103.569   842.691     0.150
   103.569   841.887     0.150
   103.569   841.863     0.150
   103.601   846.566     0.150
   103.880   846.262     0.150
   103.962  1237.262     0.150
   104.022  1228.262     0.150
   104.022  1703.660     0.150
   104.022  2219.465     0.150
   104.450   848.715     0.150
   104.539   848.973     0.150
   104.620   849.488     0.150
   105.374   852.598     0.150
   105.221   851.254     0.150
   105.790  1119.262     0.150
   106.068   855.965     0.150
   106.123   856.098     0.150
   106.598   858.512     0.150
   106.598  1124.363     0.150
   106.598  1805.613     0.150
   106.983   859.598     0.150
   106.830   858.137     0.150
   107.072   860.887     0.150
   107.187   863.160     0.150
   107.717   862.363     0.150
   107.726  1130.465     0.150
   107.853   864.262     0.150
   107.746   867.043     0.150
   108.313   865.965     0.150
   108.202   868.160     0.150
   108.323  1111.590     0.150
   108.773  1135.387     0.150
   108.788   871.941     0.150
   109.104   867.566     0.150
   109.104   867.566     0.150
   109.016   868.785     0.150
   109.055  1770.910     0.150
   109.659  1112.410     0.150
   109.659  1780.113     0.150
   109.659  2290.215     0.150
   109.690  1278.965     0.150
   109.889   872.965     0.150
   110.655   872.762     0.150
   110.502   878.855     0.150
   110.502  1774.684     0.150
   110.928   878.566     0.150
   111.374   878.129     0.150
   111.374  1773.090     0.150
   111.938   879.863     0.150
   111.938  1115.574     0.150
   111.938  1157.973     0.150
   113.379  2368.863     0.150
   113.687  1173.660     0.150
   113.696   891.465     0.150
   114.161   889.973     0.150
   114.161  1119.910     0.150
   114.739  1319.160     0.150
   115.031  1122.887     0.150
   115.479  1109.441     0.150
   115.328  1185.965     0.150
   115.328  2400.762     0.150
   115.711   902.660     0.150
   116.181  1128.910     0.150
   116.930   902.043     0.150
   116.930  1125.574     0.150
   116.998  1125.137     0.150
   118.229  1129.676     0.150
   118.646  1122.160     0.150
   118.657  1128.863     0.150
   118.633  1128.762     0.150
   118.633  1211.262     0.150
   118.746  1128.957     0.150
   118.835   910.754     0.150
   118.835  1128.816     0.150
   118.854   910.473     0.150
   118.854  1128.957     0.150
   118.887  1128.863     0.150
   118.940  1129.004     0.150
   118.981  1129.105     0.150
   119.339  1129.707     0.150
   119.504  1231.754     0.150
   119.551  1130.723     0.150
   119.451   917.160     0.150
   119.451  1216.262     0.150
   119.604   905.262     0.150
   120.146  1133.660     0.150
   120.146  1219.160     0.150
   120.494  1133.363     0.150
   120.494  1133.066     0.150
   120.494  1743.691     0.150
   120.494  1131.762     0.150
   120.770   921.660     0.150
   121.695  1132.262     0.150
   122.033  1140.762     0.150
   122.858  1137.965     0.150
   123.184  1143.262     0.150
   123.451  1141.715     0.150
   123.451  1251.816     0.150
   123.754  1141.223     0.150
   123.849  1142.965     0.150
   124.013  1144.223     0.150
   124.119  1143.457     0.150
   124.148  1143.676     0.150
   124.326  1144.645     0.150
   124.386  1148.215     0.150
   124.546  1144.254     0.150
   124.546  1144.254     0.150
   124.671  1145.785     0.150
   124.742  1145.746     0.150
   124.754  1146.426     0.150
   124.773  1146.074     0.150
   124.842  1145.246     0.150
   125.105  1146.637     0.150
   124.922  1145.895     0.150
   124.919  1146.074     0.150
   125.097  1146.832     0.150
   125.228  1146.832     0.150
   125.222  1146.441     0.150
   125.241  1146.793     0.150
   125.294  1151.137     0.150
   125.208  1144.332     0.150
   125.423  1148.512     0.150
   125.711  1148.465     0.150
   125.632  1147.855     0.150
   125.665  1147.934     0.150
   125.688  1273.801     0.150
   125.796  1146.855     0.150
   125.849  1146.871     0.150
   125.776  1140.160     0.150
   125.787  1130.316     0.150
   125.787  1143.566     0.150
   125.787  1720.637     0.150
   125.787  1143.566     0.150
   125.916  1132.621     0.150
   126.062  1148.332     0.150
   126.076  1147.793     0.150
   126.076  1147.793     0.150
   126.116  1147.535     0.150
   126.150  1148.004     0.150
   126.422  1148.871     0.150
   126.618  1149.012     0.150
   126.570  1147.660     0.150
   126.651  1129.660     0.150
   126.651  1145.566     0.150
   126.651  1715.863     0.150
   126.651  1145.566     0.150
   126.870  1145.762     0.150
   126.797  1148.785     0.150
   127.159  1149.832     0.150
   127.611  1151.652     0.150
   127.614  1152.723     0.150
   127.614  1269.887     0.150
   127.480  1150.816     0.150
   127.894  1152.723     0.150
   128.065  1153.582     0.150
   128.178  1154.590     0.150
   128.451  1142.465     0.150
   128.513  1154.590     0.150
   128.690  1154.473     0.150
   128.690  1280.871     0.150
   128.969  1155.215     0.150
   128.969  1277.113     0.150
   129.463  1153.246     0.150
   129.760  1155.832     0.150
   129.950   964.160     0.150
   130.678  1157.691     0.150
   130.837  1157.074     0.150
   131.089  1158.324     0.150
   131.131  1157.230     0.150
   131.539  1157.691     0.150
   131.970  1161.426     0.150
   131.970  1298.824     0.150
   132.215  1154.160     0.150
   132.215  1086.395     0.150
   132.215  1162.043     0.150
   132.063  1153.316     0.150
   132.363  1162.676     0.150
   132.445  1160.801     0.150
   132.674  1157.230     0.150
   132.769  1159.473     0.150
   133.302  1157.730     0.150
   133.454  1153.465     0.150
   133.539  1161.426     0.150
   133.735  1161.137     0.150
   133.877  1165.152     0.150
   133.987  1158.488     0.150
   133.987  1159.770     0.150
   134.166  1132.840     0.150
   134.421  1163.152     0.150
   134.468  1163.590     0.150
   135.314  1161.363     0.150
   135.469  1165.230     0.150
   126.345  1159.660     0.150
   137.163  1157.324     0.150
   137.163  1157.363     0.150
   137.464  1154.215     0.150
   137.464  1335.613     0.150
   137.464  1161.152     0.150
   137.601  1169.473     0.150
   137.296  1168.535     0.150
   137.659  1335.590     0.150
   137.659  1163.246     0.150
   137.659  1163.262     0.150
   137.659  1169.504     0.150
   138.087  1170.691     0.150
   138.368  1171.348     0.150
   138.898  1160.363     0.150
   140.754  1169.191     0.150
   140.938  1173.910     0.150
   144.673  1179.191     0.150
   145.585  1173.754     0.150
   149.791  1187.191     0.150
   152.036  1198.340     0.150
   153.221  1187.973     0.150
   154.302  1187.965     0.150
   154.850  1198.504     0.150
   160.028  1204.520     0.150
   160.028  1206.941     0.150
   167.266  1211.855     0.150
    71.825  1126.043     0.150
    71.825  1250.730     0.150
    71.825  1152.184     0.150
    71.825  1273.387     0.150
     0.884    17.383     0.150
     0.884    30.008     0.150
     0.945    18.039     0.150
     1.172    34.727     0.150
     1.172    20.992     0.150
     1.944    32.922     0.150
     2.159    37.562     0.150
     2.159    66.055     0.150
     2.416    43.305     0.150
     2.416    73.672     0.150
     2.675    43.664     0.150
     2.756    43.016     0.150
     2.756    79.133     0.150
     3.308    53.695     0.150
     3.308    99.492     0.150
     3.330    52.406     0.150
     3.330    95.906     0.150
     3.477    65.203     0.150
     3.477   105.289     0.150
     3.685    56.156     0.150
     3.685   103.586     0.150
     3.771    61.656     0.150
     3.771   104.617     0.150
     4.012    62.953     0.150
     4.012   113.242     0.150
     4.039    64.945     0.150
     4.039   111.633     0.150
     4.128    68.586     0.150
     4.128    68.586     0.150
     4.128   109.328     0.150
     4.132   129.883     0.150
     4.244   119.797     0.150
     4.244    66.727     0.150
     4.244   119.797     0.150
     4.366    69.695     0.150
     4.366   115.586     0.150
     4.471   127.008     0.150
     4.468    72.727     0.150
     4.468   124.078     0.150
     4.497    73.156     0.150
     4.497   137.734     0.150
     4.509   126.758     0.150
     4.511    67.648     0.150
     4.514    72.789     0.150
     4.514   120.766     0.150
     4.513    74.656     0.150
     4.513   133.312     0.150
     4.526    76.922     0.150
     4.526   132.047     0.150
     4.535    78.547     0.150
     4.535   132.305     0.150
     4.544    84.094     0.150
     4.544   136.289     0.150
     4.552   126.203     0.150
     4.554    73.477     0.150
     4.554   124.258     0.150
     4.619    73.547     0.150
     4.619   126.719     0.150
     4.626    74.242     0.150
     4.626   126.867     0.150
     4.718    73.906     0.150
     4.772    73.797     0.150
     4.772   131.242     0.150
     4.809    73.273     0.150
     4.809   132.258     0.150
     4.847    75.703     0.150
     4.847   132.016     0.150
     4.907    77.797     0.150
     4.981    77.398     0.150
     4.981   133.969     0.150
     4.982    78.734     0.150
     4.982   134.289     0.150
     4.984    81.398     0.150
     4.984    77.898     0.150
     4.984   135.992     0.150
     4.993    77.797     0.150
     4.993   138.844     0.150
     5.103   134.453     0.150
     5.111    77.133     0.150
     5.111   144.805     0.150
     5.170    80.398     0.150
     5.170   137.812     0.150
     5.302    83.898     0.150
     5.302    83.898     0.150
     5.461    82.523     0.150
     5.461   145.008     0.150
     5.782    87.023     0.150
     5.782   151.195     0.150
     5.831    87.578     0.150
     5.831   152.188     0.150
     5.912    88.578     0.150
     5.912   156.977     0.150
     6.159    94.328     0.150
     6.159   163.367     0.150
     6.214    94.172     0.150
     6.214   164.797     0.150
     6.353    94.898     0.150
     6.353   174.773     0.150
     6.456    96.914     0.150
     6.456   170.094     0.150
     6.718   506.344     0.150
     6.722   103.172     0.150
     6.747   513.312     0.150
     6.850   100.344     0.150
     6.850   178.633     0.150
     7.629   111.266     0.150
     8.618   121.727     0.150
     9.822   138.125     0.150
    12.370   181.883     0.150
    96.214   203.508     0.150
    15.157   213.242     0.150
    16.602   233.969     0.150
    16.602   233.945     0.150
    16.602   235.945     0.150
    16.847   234.242     0.150
    17.571   246.945     0.150
    18.857   262.977     0.150
    19.427   273.711     0.150
    19.978   272.445     0.150
    20.005   278.594     0.150
    20.005   278.656     0.150
    20.873   280.984     0.150
    91.534   297.547     0.150
    22.433   296.742     0.150
    22.433   296.781     0.150
    22.596   297.734     0.150
    22.596   297.742     0.150
    22.698   301.188     0.150
    23.567   536.383     0.150
    33.323   322.766     0.150
    24.894   322.844     0.150
    24.940   333.445     0.150
    24.967   321.633     0.150
    24.967   322.648     0.150
    24.975   323.742     0.150
    25.603   328.922     0.150
    21.785   331.648     0.150
    25.943   331.094     0.150
    27.574   345.703     0.150
    61.807   362.172     0.150
    29.432   362.633     0.150
    34.100   369.945     0.150
    30.171   380.242     0.150
    30.733   377.023     0.150
    61.094   378.547     0.150
    31.565   380.719     0.150
    92.833   386.844     0.150
    32.371   556.867     0.150
    27.167   391.742     0.150
    32.489   392.844     0.150
    32.489   393.312     0.150
    33.205   398.992     0.150
    36.246   421.703     0.150
    40.896   460.648     0.150
    44.644   490.898     0.150
    44.644   594.992     0.150
    45.974   501.578     0.150
    47.604   515.156     0.150
    49.236   529.367     0.150
    49.267   529.445     0.150
    49.267   529.344     0.150
    50.900   538.312     0.150
    98.552   547.648     0.150
    98.552   548.273     0.150
    53.065   558.961     0.150
    53.158   557.047     0.150
    54.448   631.242     0.150
    54.687   571.883     0.150
    54.687   568.164     0.150
    54.840   570.289     0.150
    30.651   576.148     0.150
    58.456   597.844     0.150
    58.456   595.328     0.150
    61.021   613.062     0.150
    61.096   617.484     0.150
    61.566   620.352     0.150
    61.566   617.945     0.150
    61.651   616.906     0.150
    63.417   629.742     0.150
    63.417   630.477     0.150
    64.573   637.453     0.150
    65.164   641.633     0.150
    65.577   644.289     0.150
    66.105   645.742     0.150
    66.105   647.047     0.150
    66.105   647.117     0.150
    66.510   648.648     0.150
    66.510   651.523     0.150
    79.452   725.297     0.150
    80.925   734.562     0.150
    81.808   739.914     0.150
    83.263  6266.172     0.150
    83.271  6266.172     0.150
    83.281  6266.289     0.150
    83.334   746.648     0.150
    83.328   747.055     0.150
    83.357   747.977     0.150
    83.719   750.289     0.150
    83.808  6305.750     0.150
    83.809  6305.750     0.150
    83.824  6304.617     0.150
    85.468   756.555     0.150
    85.473   757.648     0.150
    85.493   758.953     0.150
    85.493   758.969     0.150
    85.493   757.148     0.150
    85.514   757.547     0.150
    85.514   759.414     0.150
    87.302   765.164     0.150
    87.312   765.844     0.150
    89.355   986.148     0.150
    89.355  1992.648     0.150
    89.355   777.219     0.150
    89.929   777.898     0.150
    90.286   780.742     0.150
    90.976   782.734     0.150
    91.398   785.242     0.150
    91.398  2719.445     0.150
    92.654   792.242     0.150
    92.936   793.242     0.150
    93.431   795.242     0.150
    93.683   796.445     0.150
    94.422   800.336     0.150
    94.422   800.344     0.150
    94.657   801.242     0.150
    94.657   801.148     0.150
    95.194   804.562     0.150
    95.330   805.070     0.150
    95.331   806.008     0.150
    95.760   801.016     0.150
    96.100   807.844     0.150
    96.221   809.055     0.150
    96.480   809.398     0.150
    96.480   809.398     0.150
    96.480   809.344     0.150
    96.480  1445.844     0.150
    96.555   808.445     0.150
    97.012   813.344     0.150
    71.675   814.305     0.150
    97.588   815.469     0.150
    97.625   814.906     0.150
    99.213   820.961     0.150
    99.213   820.945     0.150
    99.360   822.742     0.150
    99.360   822.758     0.150
    99.893   824.844     0.150
    99.978   824.148     0.150
   100.135   825.547     0.150
   101.170   828.344     0.150
   101.330   831.344     0.150
   101.766   833.648     0.150
   103.114   838.844     0.150
   103.753   842.094     0.150
   103.753   842.148     0.150
   103.753   842.148     0.150
   109.817  1284.945     0.150
   109.817  2307.344     0.150
   112.461  1111.242     0.150
   114.838  1757.492     0.150
   138.142  1166.070     0.150
   138.142  1169.547     0.150
     1.742    55.277     0.150
     3.526   107.138     0.150
     3.877   119.497     0.150
     3.989    64.938     0.150
     4.435    58.428     0.150
     4.831   143.067     0.150
     7.355   554.400     0.150
    56.291  4228.316     0.150
    56.300  4229.555     0.150
     2.251    39.285     0.150
     2.370    42.835     0.150
     4.081    67.025     0.150
     4.453    72.314     0.150
     7.405   559.360     0.150
    56.249  4227.831     0.150
    56.258  4224.854     0.150
     1.364    23.574     0.150
     1.364    41.934     0.150
     1.717    27.404     0.150
     1.717    51.533     0.150
     1.834    31.135     0.150
     1.834    53.283     0.150
     2.336    39.145     0.150
     2.336    68.344     0.150
     2.677    42.184     0.150
     2.677    78.834     0.150
     2.709    44.404     0.150
     2.985    45.885     0.150
     2.985    82.314     0.150
     3.082    50.654     0.150
     3.123    49.033     0.150
     3.123    92.193     0.150
     3.510   101.395     0.150
     3.961   114.684     0.150
     3.967   116.674     0.150
     6.137    95.084     0.150
     7.126   117.094     0.150
     7.390   555.277     0.150
     7.850   219.814     0.150
     7.968   113.805     0.150
     7.968   216.885     0.150
     9.683   259.693     0.150
    10.704   293.705     0.150
    10.909   152.225     0.150
    51.079   182.154     0.150
    95.976   203.654     0.150
    15.563   219.475     0.150
    15.650   233.443     0.150
    92.920   238.344     0.150
    11.750   259.145     0.150
    94.940   266.764     0.150
    61.898   272.113     0.150
    21.092   284.135     0.150
    91.202   284.635     0.150
    67.067   292.684     0.150
    21.979   294.295     0.150
    22.162   295.215     0.150
    94.856   299.113     0.150
    93.697   320.693     0.150
    21.852   334.584     0.150
    28.385   354.494     0.150
    44.975   592.584     0.150
    44.975   495.475     0.150
    56.310  4227.209     0.150
    56.319  4226.396     0.150
     1.758    48.424     0.150
     2.196    35.023     0.150
     2.629    44.283     0.150
     2.629    44.244     0.150
     4.341    68.584     0.150
     4.521    70.385     0.150
     4.892    74.715     0.150
     6.923   523.256     0.150
     7.842   117.895     0.150
     8.769   124.805     0.150
    10.945   159.283     0.150
    11.943   169.555     0.150
    13.354   185.465     0.150
    13.572   192.184     0.150
    15.329   217.584     0.150
    15.329   217.574     0.150
    15.329   217.684     0.150
    16.489   405.635     0.150
    19.375   267.361     0.150
    19.817   269.783     0.150
    19.784   271.324     0.150
    20.683   277.783     0.150
    21.004   280.400     0.150
    21.476   287.975     0.150
    21.694   292.023     0.150
    91.552   295.201     0.150
    91.552   294.283     0.150
    22.188   294.666     0.150
    22.435   296.084     0.150
    22.435   296.453     0.150
    22.444   299.324     0.150
    22.564   297.484     0.150
    22.575   294.918     0.150
    23.010   309.684     0.150
    24.197   318.484     0.150
    24.860    12.600     0.150
    24.827   322.783     0.150
    24.827   322.857     0.150
    24.940   320.684     0.150
    24.940    14.701     0.150
    25.706   328.885     0.150
    25.706   329.184     0.150
    61.622   359.904     0.150
    61.622   359.953     0.150
    61.622   358.484     0.150
    79.923   362.943     0.150
    34.042   367.385     0.150
    30.384   366.885     0.150
    30.542   372.584     0.150
    30.599   370.385     0.150
    30.595   374.885     0.150
    30.737   373.885     0.150
    61.249   376.283     0.150
    30.915   377.184     0.150
    22.304   380.143     0.150
    22.304   379.385     0.150
    31.260   378.584     0.150
    31.345   384.723     0.150
    92.804   385.504     0.150
    92.804   384.484     0.150
   102.165   385.484     0.150
    27.168   391.604     0.150
    27.168   388.885     0.150
    32.270   390.953     0.150
    32.270   389.283     0.150
    33.375   399.363     0.150
    40.637   457.852     0.150
    40.970   459.104     0.150
    40.970   459.084     0.150
    42.433   471.234     0.150
    44.769   491.113     0.150
    49.052   528.385     0.150
    51.017   541.693     0.150
    98.483   545.283     0.150
    51.494   544.533     0.150
    54.613   568.084     0.150
    55.006   571.023     0.150
    55.006   570.930     0.150
    55.419   573.604     0.150
    55.791   578.484     0.150
    56.634  4243.631     0.150
    56.643  4244.861     0.150
    56.912   585.453     0.150
    58.398   595.814     0.150
    59.194    11.129     0.150
    59.194   597.523     0.150
    60.803   611.885     0.150
    61.009    11.510     0.150
    61.553   616.684     0.150
    62.048   620.984     0.150
    62.667    12.490     0.150
    63.203   628.156     0.150
    65.273   641.283     0.150
    65.347   641.885     0.150
    65.822   646.084     0.150
    66.187   646.283     0.150
    66.191   648.398     0.150
    67.089   653.861     0.150
    68.004   658.055     0.150
    68.149   660.646     0.150
    68.891   665.621     0.150
    69.155   666.994     0.150
    69.381   668.703     0.150
    69.668   670.084     0.150
    70.307   672.844     0.150
    70.948   677.984     0.150
    71.765   683.148     0.150
    72.805   689.373     0.150
    77.391  1355.725     0.150
    78.475   720.684     0.150
    79.761   725.002     0.150
    80.602   732.184     0.150
    82.149   741.084     0.150
    83.109   745.854     0.150
    83.265   746.939     0.150
    83.483   746.844     0.150
    83.483  6267.006     0.150
    83.491  6269.416     0.150
    83.501  6271.650     0.150
    84.027  6313.705     0.150
    84.028  6315.119     0.150
    84.043  6315.521     0.150
    85.367   756.801     0.150
    85.428   757.783     0.150
    85.465   757.934     0.150
    85.477   757.084     0.150
    85.538   757.744     0.150
    85.538   756.283     0.150
    85.627   759.074     0.150
    85.664   758.465     0.150
    85.962   760.633     0.150
    88.330   770.305     0.150
    88.356   770.285     0.150
    88.356   771.752     0.150
    88.740   768.783     0.150
    88.790   774.584     0.150
    89.302   775.783     0.150
    89.524   776.953     0.150
    89.524   783.283     0.150
    89.524  1104.885     0.150
    89.524  2001.283     0.150
   107.901   777.994     0.150
    89.605   777.084     0.150
    90.997   782.363     0.150
    91.235   784.584     0.150
    91.371   785.084     0.150
    91.371    17.000     0.150
    91.371  1123.084     0.150
    91.371  1411.084     0.150
    91.371  1467.084     0.150
    91.371  1535.084     0.150
    91.371  2059.084     0.150
    91.371  2389.084     0.150
    91.505   785.215     0.150
    92.451   789.783     0.150
    92.842   792.783     0.150
    92.907   790.783     0.150
    92.907  1008.984     0.150
    92.907   790.783     0.150
    93.363   794.584     0.150
    93.382   794.684     0.150
    93.405   794.084     0.150
    93.405  1018.084     0.150
    93.415   795.484     0.150
    93.485   793.885     0.150
    93.485   793.885     0.150
    93.658   796.283     0.150
    94.057   797.484     0.150
    94.426   799.584     0.150
    94.631   800.584     0.150
    94.631   800.924     0.150
    94.914  1436.084     0.150
    95.045  1024.814     0.150
    95.045  1437.434     0.150
    95.045  1912.654     0.150
    95.299   804.508     0.150
    95.301   805.014     0.150
    95.542   803.783     0.150
    95.764   804.465     0.150
    96.015   808.322     0.150
    96.072   807.867     0.150
    96.190   809.371     0.150
    96.287   808.484     0.150
    96.484   808.314     0.150
    96.484   808.314     0.150
    96.484    15.109     0.150
    96.484    20.920     0.150
    96.484  1165.795     0.150
    96.484  2103.135     0.150
    96.484   808.283     0.150
    96.484  1042.084     0.150
    96.484  1165.783     0.150
    96.484  1440.584     0.150
    96.484  1570.984     0.150
    96.484  1878.584     0.150
    96.484  2103.084     0.150
    97.382   812.783     0.150
    97.604   815.527     0.150
    99.327   822.084     0.150
    99.403   821.084     0.150
    99.403   820.984     0.150
    99.403   821.184     0.150
    99.403  1190.783     0.150
    99.762   822.184     0.150
    99.864   825.283     0.150
    99.958   823.885     0.150
   100.489   827.484     0.150
   101.157   829.084     0.150
   101.303   830.283     0.150
   101.741   832.084     0.150
   103.092   837.584     0.150
   103.320   838.984     0.150
   103.730   841.783     0.150
   106.209  1113.584     0.150
   108.840  1134.305     0.150
   109.816  1281.584     0.150
   109.816  2311.584     0.150
   111.906  1115.023     0.150
   113.476  1130.184     0.150
   113.476  1172.184     0.150
   113.476  1313.684     0.150
   113.476  2365.783     0.150
   114.073  1119.164     0.150
   115.439  1120.684     0.150
   116.940  1124.664     0.150
   117.285  1603.084     0.150
   118.466  1127.414     0.150
   118.574  1126.773     0.150
   118.629  1127.084     0.150
   118.722  1128.074     0.150
   118.695  1128.154     0.150
   118.773  1128.174     0.150
   118.773  1205.953     0.150
   118.803  1128.193     0.150
   118.803  1206.045     0.150
   118.839  1128.273     0.150
   118.881  1128.404     0.150
   118.929  1128.484     0.150
   119.944   920.885     0.150
   119.944  1125.885     0.150
   119.944  1206.385     0.150
   120.188  1130.684     0.150
   125.437  1140.885     0.150
   126.311  1137.314     0.150
   126.622  1167.385     0.150
   126.957  1143.584     0.150
   127.114  1143.674     0.150
   128.219  1145.783     0.150
   128.415  1147.523     0.150
   130.397  1281.684     0.150
   132.581  1155.113     0.150
   132.581  1155.109     0.150
   133.338  1155.385     0.150
   133.888  1157.354     0.150
   134.928  1155.809     0.150
   136.926  1162.783     0.150
   137.226  1153.834     0.150
   137.990  1165.834     0.150
   144.404  1176.385     0.150
   144.514  1176.734     0.150
     1.316    24.574     0.150
     1.316    41.445     0.150
     1.416    25.664     0.150
     1.416    44.145     0.150
     1.605    29.465     0.150
     1.605    51.215     0.150
     1.667    28.105     0.150
     1.667    49.617     0.150
     1.889    30.785     0.150
     1.889    56.586     0.150
     2.329    36.555     0.150
     2.639    43.164     0.150
     2.639    75.367     0.150
     2.727    43.516     0.150
     2.727    76.086     0.150
     2.763    46.344     0.150
     2.763    80.066     0.150
     2.934    44.957     0.150
     2.934    81.246     0.150
     3.091    52.926     0.150
     3.174    51.055     0.150
     3.174    90.094     0.150
     3.382    56.824     0.150
     3.446    54.844     0.150
     3.446    96.254     0.150
     3.495    54.344     0.150
     3.495    94.117     0.150
     3.910    61.734     0.150
     3.910   108.625     0.150
     3.860    61.797     0.150
     3.860   108.766     0.150
     4.060    62.887     0.150
     4.060   109.195     0.150
     4.337    67.727     0.150
     4.337   120.277     0.150
     4.343    68.035     0.150
     4.343   114.477     0.150
     4.347    68.066     0.150
     4.347   116.465     0.150
     4.373    68.457     0.150
     4.373   115.824     0.150
     4.524    70.387     0.150
     4.524   123.605     0.150
     4.752    73.375     0.150
     4.752   124.094     0.150
     4.742    74.527     0.150
     7.434   555.328     0.150
     7.462   556.992     0.150
     9.052   135.906     0.150
    11.142   205.156     0.150
    51.024   181.066     0.150
    13.493   194.906     0.150
    13.543   190.055     0.150
    16.092   224.535     0.150
   148.008   227.684     0.150
    61.845   273.586     0.150
    22.436   297.105     0.150
    24.161   318.355     0.150
    24.161   537.746     0.150
    24.823   321.105     0.150
    25.902   334.047     0.150
    25.902   334.207     0.150
    26.087   334.777     0.150
    27.571   346.707     0.150
    31.740   383.867     0.150
    32.852   392.617     0.150
    36.515   425.004     0.150
    63.826   633.555     0.150
    82.994   744.215     0.150
    91.742   787.305     0.150
    95.945   808.383     0.150
   120.547  1131.680     0.150
   125.885  1142.504     0.150
   126.735  1144.066     0.150
   131.800  1154.754     0.150
   137.647  1165.887     0.150
     0.653    13.328     0.150
     0.653    22.438     0.150
     0.788    15.656     0.150
     0.788    26.527     0.150
     0.852    16.367     0.150
     0.852    29.176     0.150
     1.129    19.977     0.150
     1.129    34.387     0.150
     1.874    30.828     0.150
     1.874    54.098     0.150
     2.087    36.457     0.150
     2.087    62.848     0.150
     2.425    38.176     0.150
     2.425    68.816     0.150
     2.590    42.566     0.150
     2.590    74.258     0.150
     3.224    52.059     0.150
     3.224    91.887     0.150
     3.309    52.727     0.150
     3.309    92.289     0.150
     3.696    56.969     0.150
     3.696   101.227     0.150
     6.739   507.855     0.150
     6.769   516.207     0.150
    10.751   322.391     0.150
    10.751   152.266     0.150
    23.908   313.195     0.150
    33.243   319.406     0.150
    21.687   328.398     0.150
    83.806  6323.953     0.150
    83.806  6318.473     0.150
    83.822  6330.836     0.150
     1.263    22.328     0.150
     1.263    38.508     0.150
     1.746    27.977     0.150
     1.791    28.188     0.150
     2.316    67.930     0.150
     2.719    42.508     0.150
     3.061    46.883     0.150
     3.508   107.852     0.150
     3.617    52.547     0.150
     3.958    59.352     0.150
     4.478    64.656     0.150
     5.162    74.922     0.150
     5.205    75.422     0.150
     5.285    74.750     0.150
     5.555    75.422     0.150
     5.734    78.781     0.150
     6.224    86.180     0.150
     7.337   536.164     0.150
     7.366   547.781     0.150
     7.448   103.000     0.150
     8.906   125.961     0.150
     9.682   146.047     0.150
     9.738   130.578     0.150
    11.010   159.352     0.150
    11.016   156.047     0.150
    12.533   180.547     0.150
    51.177   181.703     0.150
    13.869   194.078     0.150
    95.929   201.430     0.150
    15.548   218.750     0.150
    16.858   234.547     0.150
    92.879   237.148     0.150
    17.807   244.844     0.150
    18.032   250.047     0.150
    18.333   251.852     0.150
    11.663   256.781     0.150
    19.335   265.312     0.150
    19.381   265.070     0.150
    19.439   264.648     0.150
    20.490   276.953     0.150
    21.544   287.648     0.150
    67.130   291.406     0.150
    22.042   293.906     0.150
    22.062   294.781     0.150
    22.307   294.250     0.150
    22.378   295.453     0.150
    23.279   303.992     0.150
    24.014   313.953     0.150
    24.379   317.078     0.150
    24.408   315.148     0.150
    24.761   318.750     0.150
    24.996   537.930     0.150
    25.771   329.352     0.150
    27.419   347.273     0.150
    30.221   371.352     0.150
    30.532   367.617     0.150
    31.862   385.578     0.150
    32.430   555.898     0.150
    32.430   388.352     0.150
    44.879   491.883     0.150
    44.879   594.922     0.150
    45.820   597.750     0.150
    48.693   524.492     0.150
    98.231   540.047     0.150
    54.815   567.648     0.150
    54.815   568.648     0.150
    55.475   574.000     0.150
    56.411  4231.023     0.150
    56.420  4232.211     0.150
    62.866   624.852     0.150
    65.205   638.648     0.150
    70.535   674.648     0.150
    77.973   716.953     0.150
    79.968   727.227     0.150
    80.708   731.297     0.150
    80.896   733.781     0.150
    83.642   748.250     0.150
    84.436  6371.609     0.150
    84.437  6363.000     0.150
    84.452  6353.938     0.150
    85.150   755.453     0.150
    85.484   756.352     0.150
    85.690   757.461     0.150
    87.647   766.578     0.150
    87.860   768.789     0.150
    88.443   772.344     0.150
    89.502   776.930     0.150
    89.732   777.594     0.150
    90.034   780.148     0.150
    90.527   779.250     0.150
    91.039   783.352     0.150
    91.188   782.250     0.150
    91.599   785.891     0.150
    92.868   792.547     0.150
    95.109   803.758     0.150
    95.835   807.117     0.150
    95.887   806.141     0.150
    96.354   807.391     0.150
    96.354   807.391     0.150
    96.354    21.430     0.150
    96.354    30.109     0.150
    96.354  1163.531     0.150
    96.354  2098.039     0.150
    96.354   807.352     0.150
    96.354  1040.453     0.150
    96.354  1163.453     0.150
    96.354  1435.648     0.150
    96.354  1474.953     0.150
    96.354  1569.750     0.150
    96.354  1873.750     0.150
    96.354  2097.953     0.150
    96.798   809.648     0.150
    99.135   819.109     0.150
    99.302   817.148     0.150
    99.618   821.102     0.150
    99.618   821.047     0.150
    99.618   822.148     0.150
   115.042  1119.148     0.150
   137.493  1166.750     0.150
   107.644  1179.992     0.150
     1.040    33.604     0.150
     2.127    57.683     0.150
     4.007    58.433     0.150
     4.498    67.803     0.150
     4.497   113.263     0.150
     4.867    69.133     0.150
     4.867   122.263     0.150
     5.211    76.283     0.150
     5.871    85.593     0.150
     5.871   146.073     0.150
     1.635    27.658     0.150
     3.098    50.777     0.150
     3.898    62.408     0.150
     3.919   100.547     0.150
     3.982    58.027     0.150
     4.348    67.748     0.150
     4.344    67.488     0.150
     4.644    71.918     0.150
     7.204   196.797     0.150
     7.535   207.018     0.150
     7.462   557.051     0.150
     7.489   561.535     0.150
     7.650   208.188     0.150
     9.937   263.787     0.150
    10.630   267.668     0.150
    11.167   163.207     0.150
    12.441   179.377     0.150
    12.656   182.307     0.150
    50.990   184.818     0.150
    12.968   187.908     0.150
    12.968   340.197     0.150
    13.009   187.646     0.150
    15.733   223.418     0.150
    15.733   222.207     0.150
    92.924   238.547     0.150
    17.310   242.408     0.150
    18.153   253.508     0.150
    18.423   253.908     0.150
    95.552   255.748     0.150
    19.222   267.127     0.150
    19.379   262.477     0.150
    19.523   491.176     0.150
    19.523   269.408     0.150
   123.081   275.328     0.150
    35.641   278.318     0.150
    20.673   281.408     0.150
    20.818   281.307     0.150
    91.291   287.088     0.150
    21.458   286.408     0.150
    91.544   289.707     0.150
    21.706   291.008     0.150
    21.945   289.848     0.150
    21.452   298.908     0.150
    22.229   292.887     0.150
    22.229   290.557     0.150
    22.565   295.598     0.150
    81.903   301.178     0.150
    22.535   304.828     0.150
    22.535   300.438     0.150
    22.756   296.877     0.150
    24.157   314.418     0.150
    24.280   319.008     0.150
    24.267   317.107     0.150
    24.452   316.508     0.150
    24.978   323.908     0.150
    27.328   342.928     0.150
    27.539   349.908     0.150
    61.185   355.107     0.150
    80.405   359.107     0.150
    33.101   357.707     0.150
    33.851   364.408     0.150
    30.045   372.057     0.150
    30.227   372.477     0.150
    61.605   372.607     0.150
    22.135   375.508     0.150
    92.679   380.908     0.150
   101.995   384.607     0.150
    27.125   387.008     0.150
    31.709   386.438     0.150
    31.709   386.307     0.150
    32.564   388.508     0.150
    32.822   395.707     0.150
    33.851   399.707     0.150
    36.539   424.107     0.150
    39.253   447.107     0.150
    39.581   445.807     0.150
    40.380   458.607     0.150
    45.390   504.467     0.150
    45.436   504.928     0.150
    45.690   502.508     0.150
    48.527   524.432     0.150
    48.527   524.307     0.150
    48.527   524.207     0.150
    48.527   524.598     0.150
    98.260   541.887     0.150
    81.226   544.277     0.150
    51.571   546.078     0.150
    53.704   561.508     0.150
    53.996   566.078     0.150
    54.861   569.727     0.150
    56.227  4227.594     0.150
    56.236  4228.830     0.150
    56.348   583.498     0.150
    56.348   583.508     0.150
    56.576  4252.924     0.150
    56.580  4249.881     0.150
    56.593  4249.461     0.150
    57.643   589.117     0.150
    57.644   589.998     0.150
    59.239   601.697     0.150
    59.648   605.998     0.150
    63.968   633.668     0.150
    64.300   635.408     0.150
    64.300   635.498     0.150
    64.300   635.371     0.150
    64.562   640.498     0.150
    64.800   638.590     0.150
    65.309   642.707     0.150
    65.309   642.697     0.150
    65.637   644.762     0.150
    65.908   650.473     0.150
    66.566   650.227     0.150
    66.526   652.787     0.150
    68.641   663.766     0.150
    68.707   663.455     0.150
    69.026   666.367     0.150
    69.114   667.238     0.150
    69.462   669.207     0.150
    69.462   670.852     0.150
    69.462   670.852     0.150
    69.799   669.332     0.150
    70.095   671.178     0.150
    70.259   672.807     0.150
    70.393   675.207     0.150
    74.518   697.967     0.150
    74.567   700.297     0.150
    74.821   705.438     0.150
    75.693   706.598     0.150
    78.477   721.098     0.150
    78.575   721.707     0.150
    79.249   725.227     0.150
    79.416   725.828     0.150
    79.612   727.307     0.150
    79.622   727.508     0.150
    79.622   727.357     0.150
    80.037   729.568     0.150
    80.451   729.807     0.150
    80.562   915.908     0.150
    80.562   732.918     0.150
    80.771   733.607     0.150
    81.057   735.328     0.150
    81.868   740.207     0.150
   126.724   740.457     0.150
    82.434   743.107     0.150
    82.564   743.568     0.150
    82.564  1707.967     0.150
    82.569   744.037     0.150
    82.569   744.252     0.150
    82.773   744.896     0.150
    82.822   745.188     0.150
    82.799   739.807     0.150
    82.967  1703.127     0.150
    82.989   745.938     0.150
    82.989   745.883     0.150
    82.989   745.883     0.150
    83.334   748.137     0.150
    83.334  1710.678     0.150
    83.334   748.062     0.150
    83.334   748.062     0.150
    83.579   751.076     0.150
    84.164   751.787     0.150
    84.044  6314.248     0.150
    84.052  6324.033     0.150
    84.062  6319.291     0.150
    84.696   755.314     0.150
    84.776   755.508     0.150
    84.776   756.602     0.150
    84.587  6355.959     0.150
    84.588  6355.660     0.150
    84.828   756.008     0.150
    84.828   756.008     0.150
    84.603  6356.855     0.150
    84.846   756.076     0.150
    85.110   758.076     0.150
    85.164   757.508     0.150
    85.164   757.508     0.150
    85.164   757.627     0.150
    85.364   757.908     0.150
    85.394   759.135     0.150
    85.402   758.357     0.150
    85.406   758.008     0.150
    85.406   757.967     0.150
    85.602   757.678     0.150
    85.660   761.076     0.150
    85.693   760.602     0.150
    85.693   760.527     0.150
    86.106   762.105     0.150
    86.107   762.436     0.150
    86.226   763.225     0.150
    86.675   764.467     0.150
    86.724   762.988     0.150
    86.725   766.076     0.150
    87.107   967.896     0.150
    87.208   767.832     0.150
    87.293   769.076     0.150
    87.310   769.076     0.150
    87.648   769.105     0.150
    87.703   768.588     0.150
    88.202   771.297     0.150
    88.202   981.418     0.150
    88.202   771.408     0.150
    88.202   771.316     0.150
    88.202  1408.824     0.150
    88.289   773.076     0.150
    88.306   771.727     0.150
    88.345   771.916     0.150
    88.806   770.307     0.150
    88.806   977.307     0.150
    89.107   775.508     0.150
    89.271   776.297     0.150
    89.442   776.508     0.150
    89.488   777.416     0.150
   107.704   777.217     0.150
    89.565   777.867     0.150
    89.915   779.008     0.150
    89.915  1107.508     0.150
    89.915  2003.008     0.150
    90.100   781.105     0.150
    90.022  1110.908     0.150
    90.726   782.707     0.150
    90.838   994.408     0.150
    91.097   995.115     0.150
    91.097   785.508     0.150
    91.252   785.207     0.150
    91.252   785.166     0.150
    91.252   996.766     0.150
    91.252  1118.107     0.150
    91.252  1546.107     0.150
    91.252  2039.107     0.150
    91.252  2219.107     0.150
    91.252  2333.107     0.150
    91.420   786.266     0.150
    91.506   788.908     0.150
    91.506   788.908     0.150
    91.985   788.666     0.150
    91.840  2036.207     0.150
    92.053   789.818     0.150
    92.307   790.717     0.150
    92.361   790.207     0.150
    92.361  1011.207     0.150
    92.361  1423.607     0.150
    92.441   790.707     0.150
    92.506   791.207     0.150
    92.679  1008.307     0.150
    92.679   792.408     0.150
    92.706  1008.607     0.150
    92.706   792.307     0.150
    92.782   792.508     0.150
    92.782  1005.607     0.150
    92.782   792.508     0.150
    92.884   789.807     0.150
    92.926   793.266     0.150
    92.917  1011.008     0.150
    93.251   794.607     0.150
    93.251  1016.207     0.150
    93.251  1429.908     0.150
    93.267   794.707     0.150
    93.267   794.707     0.150
    93.272   793.307     0.150
    93.280   794.807     0.150
    93.280   794.807     0.150
    93.289   794.807     0.150
    93.289   794.807     0.150
    93.370   795.307     0.150
    93.542  1013.207     0.150
    93.542   796.008     0.150
    93.675   796.908     0.150
    93.940   798.008     0.150
    94.270   799.307     0.150
    94.270   799.207     0.150
    94.515   800.408     0.150
    94.652   799.309     0.150
    94.542   801.938     0.150
    94.542   801.908     0.150
    94.729   799.988     0.150
    94.729   800.008     0.150
    94.729  1028.607     0.150
    94.729  1436.707     0.150
    94.800   802.107     0.150
    94.813  1027.805     0.150
    94.959   802.107     0.150
    94.959  1439.707     0.150
    95.171   804.230     0.150
    95.174   804.529     0.150
    95.175   804.707     0.150
    95.437   804.207     0.150
    95.437   804.207     0.150
    95.437  1034.307     0.150
    95.437  1440.707     0.150
    95.721   804.617     0.150
    95.753  1156.607     0.150
    95.901   807.801     0.150
    95.950   807.508     0.150
    95.950   807.480     0.150
    96.061   808.555     0.150
    96.178   808.307     0.150
    96.178  1040.707     0.150
    96.178  1446.508     0.150
    96.442  1162.807     0.150
    96.442  2100.307     0.150
    96.442   808.367     0.150
    96.442   808.367     0.150
    96.442   808.367     0.150
    96.442  1040.268     0.150
    96.442  1162.857     0.150
    96.442  1443.268     0.150
    96.442  1876.838     0.150
    96.442  2100.396     0.150
    96.635   809.857     0.150
    96.840   811.807     0.150
    96.862   812.107     0.150
    96.862   812.107     0.150
    71.986   812.877     0.150
    71.986   813.348     0.150
    97.284   812.908     0.150
    97.284   812.908     0.150
    97.284  1049.408     0.150
    97.284  1450.707     0.150
    97.206   812.607     0.150
    97.433   816.148     0.150
    97.499   814.609     0.150
    99.067   820.107     0.150
    99.194   821.697     0.150
    99.268  1057.238     0.150
    99.281  1191.807     0.150
    99.281  1928.008     0.150
    99.281  2143.807     0.150
    99.402   821.207     0.150
    99.402   819.107     0.150
    99.402  2157.107     0.150
    99.721   827.750     0.150
    99.738   825.508     0.150
    99.855   822.607     0.150
    99.974   825.207     0.150
   100.421  1069.867     0.150
   101.072   827.607     0.150
   101.183   830.508     0.150
   101.626   831.646     0.150
   101.759   831.908     0.150
   101.789   832.607     0.150
   102.249  1081.807     0.150
   102.985   834.223     0.150
   102.985   834.207     0.150
   103.209   838.408     0.150
   103.330   839.207     0.150
   103.619   840.207     0.150
   104.096  1234.707     0.150
   104.152  2219.008     0.150
   104.152   843.008     0.150
   104.395  1238.807     0.150
   105.442   845.328     0.150
   107.051   852.098     0.150
   109.499   867.107     0.150
   109.761   863.207     0.150
   109.761  1277.908     0.150
   109.761  2306.707     0.150
   113.467   879.107     0.150
   113.467  1312.307     0.150
   113.467  2362.908     0.150
   113.915  1126.408     0.150
   114.337  1119.787     0.150
   114.337  1175.387     0.150
   114.825  1321.707     0.150
   114.888  1755.982     0.150
   115.203  1110.893     0.150
   115.203  1123.021     0.150
   115.932  1122.908     0.150
   116.298  1133.027     0.150
   117.084  1124.947     0.150
   117.084  1194.277     0.150
   117.162  1125.146     0.150
   117.574  1137.508     0.150
   118.691  1128.008     0.150
   118.801  1128.418     0.150
   118.801  1207.557     0.150
   118.956  1128.768     0.150
   118.956  1207.557     0.150
   119.001  1128.637     0.150
   119.001  1207.557     0.150
   119.016  1128.668     0.150
   119.016  1208.027     0.150
   119.047  1128.668     0.150
   119.047  1208.027     0.150
   119.104  1128.668     0.150
   119.104  1208.498     0.150
   119.482  1129.498     0.150
   119.695  1129.908     0.150
   120.357  1141.207     0.150
   120.992  1702.508     0.150
   122.254  2235.408     0.150
   123.016  1136.607     0.150
   124.062  1242.807     0.150
   123.971  1133.598     0.150
   124.192  1149.488     0.150
   124.337  1147.008     0.150
   124.337  1260.867     0.150
   125.129  1134.518     0.150
   125.640  1135.377     0.150
   125.904  1716.033     0.150
   126.273  1142.947     0.150
   126.273  1142.947     0.150
   126.752  1129.357     0.150
   126.752  1714.258     0.150
   127.437  1145.707     0.150
   127.437  1260.287     0.150
   127.366  1282.768     0.150
   127.708  1146.768     0.150
   127.626  1148.533     0.150
   128.334  1148.107     0.150
   128.780  1148.107     0.150
   128.780  1270.008     0.150
   128.905  1156.357     0.150
   128.905  1273.467     0.150
   130.915  1152.307     0.150
   130.907   968.908     0.150
   131.768  1142.707     0.150
   131.768  1289.438     0.150
   132.021  1157.107     0.150
   132.263  1154.707     0.150
   133.417  1152.607     0.150
   133.794  1145.807     0.150
   135.041  1155.939     0.150
   135.748  1157.240     0.150
   135.877  1158.148     0.150
   136.463  1158.545     0.150
   136.924  1155.695     0.150
   137.170  1159.621     0.150
   137.568  1155.723     0.150
   143.449  1174.287     0.150
    71.986  1146.928     0.150
    71.986  1270.637     0.150
     2.878    88.781     0.150
     4.075   117.230     0.150
     4.245    70.051     0.150
     4.649    77.859     0.150
     6.041   169.191     0.150
     8.514   228.430     0.150
     4.363    70.594     0.150
     5.124    75.172     0.150
     0.927    17.828     0.150
     0.927    30.164     0.150
     1.001    32.906     0.150
     1.298    22.789     0.150
     1.298    37.984     0.150
     1.859    33.008     0.150
     1.859    54.898     0.150
     2.279    36.688     0.150
     2.279    70.812     0.150
     2.259    39.375     0.150
     2.259    67.945     0.150
     2.753    44.828     0.150
     2.753    78.625     0.150
     3.200    50.695     0.150
     3.200    92.625     0.150
     3.251    52.742     0.150
     3.251    93.539     0.150
     3.340    51.305     0.150
     3.340    89.008     0.150
     3.548    53.516     0.150
     3.548    96.555     0.150
     3.771    60.164     0.150
     3.771   105.336     0.150
     3.995    62.039     0.150
     3.995   109.797     0.150
     4.000    63.477     0.150
     4.000   112.055     0.150
     4.107    63.016     0.150
     4.107   110.398     0.150
     4.383    72.312     0.150
     4.383   121.016     0.150
     4.396    71.938     0.150
     4.396   124.953     0.150
     4.395    68.812     0.150
     4.395   117.719     0.150
     4.401    73.086     0.150
     4.401    73.086     0.150
     4.401   120.828     0.150
     4.411    71.914     0.150
     4.411   123.078     0.150
     4.420    69.906     0.150
     4.420   122.945     0.150
     4.431    69.516     0.150
     4.431   121.203     0.150
     4.430    73.484     0.150
     4.430   122.812     0.150
     4.430    73.484     0.150
     4.430   122.812     0.150
     4.438    72.023     0.150
     4.438   123.016     0.150
     4.472    70.484     0.150
     4.472   122.836     0.150
     4.484    69.711     0.150
     4.527    73.203     0.150
     4.527   123.438     0.150
     4.582    73.078     0.150
     4.582   125.867     0.150
     4.672    71.039     0.150
     4.672   122.445     0.150
     4.858    74.844     0.150
     4.858   131.266     0.150
     4.861    76.148     0.150
     4.861   133.109     0.150
     4.862    75.555     0.150
     4.862   134.219     0.150
     4.935    77.016     0.150
     4.935   133.922     0.150
     4.969    76.203     0.150
     5.047    77.508     0.150
     5.047   130.539     0.150
     5.296    83.844     0.150
     5.296    83.844     0.150
     5.296   137.484     0.150
     5.329    81.234     0.150
     5.329   139.578     0.150
     5.402    80.938     0.150
     5.402   144.703     0.150
     5.649    85.867     0.150
     5.649   148.609     0.150
     5.694    85.484     0.150
     5.694   151.203     0.150
     5.777    87.812     0.150
     5.777   150.992     0.150
     5.899    90.219     0.150
     5.899   156.258     0.150
     6.032    90.703     0.150
     6.032   158.859     0.150
     6.078    92.062     0.150
     6.078   163.547     0.150
     6.301    95.297     0.150
     6.301   166.922     0.150
     6.326    95.117     0.150
     6.326   170.992     0.150
     6.615    99.383     0.150
     6.615   176.016     0.150
     6.713   183.734     0.150
     6.713    99.984     0.150
     6.713   183.734     0.150
     6.791    98.336     0.150
     6.796   104.383     0.150
     6.796   178.523     0.150
     6.850   516.836     0.150
     6.879   523.695     0.150
     7.144   109.828     0.150
     7.144   109.828     0.150
     7.144   184.359     0.150
     7.558   111.266     0.150
     7.558   195.125     0.150
     7.728   114.453     0.150
     7.728   200.016     0.150
     7.852   118.258     0.150
     7.754   112.734     0.150
     8.514   125.062     0.150
     8.514   125.125     0.150
     8.514   227.922     0.150
     8.514   125.062     0.150
     8.514   219.812     0.150
     8.689   255.375     0.150
     8.689   246.188     0.150
     8.838   128.055     0.150
     8.838   218.172     0.150
     9.175   133.625     0.150
     9.175   235.969     0.150
     9.431   129.703     0.150
     9.431   246.016     0.150
     9.659   144.359     0.150
     9.659   247.023     0.150
    10.229   273.531     0.150
    10.229   148.797     0.150
    10.229   263.633     0.150
    10.388   273.406     0.150
    10.388   278.711     0.150
    10.388   152.609     0.150
    10.388   273.406     0.150
    10.891   328.938     0.150
    10.897   157.312     0.150
    11.253   292.078     0.150
    11.468   167.227     0.150
    11.468   288.766     0.150
    11.498   168.172     0.150
    11.498   294.805     0.150
    12.476   183.242     0.150
    51.580   181.094     0.150
    12.533   178.242     0.150
    12.533   326.625     0.150
    12.546   181.414     0.150
    13.054   181.578     0.150
    13.054   181.578     0.150
    13.054   335.289     0.150
    13.560   369.594     0.150
    13.835   204.055     0.150
    13.835   204.055     0.150
    13.835   349.688     0.150
    15.251   217.219     0.150
    15.251   217.969     0.150
    15.961   232.648     0.150
    15.961   232.648     0.150
    16.403   234.547     0.150
    16.666   236.156     0.150
    16.666   235.219     0.150
    18.115   253.609     0.150
    18.115   458.805     0.150
    18.263   253.906     0.150
    18.969   264.141     0.150
    95.368   266.758     0.150
    95.368   485.273     0.150
    19.868   270.617     0.150
    20.639   278.617     0.150
    20.736   266.984     0.150
    21.588   292.836     0.150
    91.528   296.414     0.150
    22.417   296.594     0.150
    22.417   296.617     0.150
    22.417   296.547     0.150
    22.560   297.719     0.150
    23.671   313.414     0.150
    23.671   536.609     0.150
    93.205   318.242     0.150
    24.380   538.312     0.150
    24.731   320.227     0.150
    33.409   322.617     0.150
    24.850   324.227     0.150
    24.910   324.016     0.150
    24.933   321.312     0.150
    24.933   321.312     0.150
    24.933   321.219     0.150
    24.933   321.359     0.150
    25.250     0.664     0.150
    25.613   329.367     0.150
    25.651   328.617     0.150
    21.794   332.898     0.150
    26.406   333.477     0.150
    27.441   349.188     0.150
    28.357   354.555     0.150
    28.357   546.836     0.150
    61.703   360.297     0.150
    61.703   359.719     0.150
    61.703   360.945     0.150
    79.838   363.156     0.150
    34.048   369.617     0.150
    30.034   372.188     0.150
    30.505   371.445     0.150
    31.360   379.109     0.150
    32.352   391.844     0.150
    33.454   401.414     0.150
    94.717   411.195     0.150
    35.634   418.195     0.150
    36.289   421.844     0.150
    36.289   421.812     0.150
    36.289   421.773     0.150
    40.126   451.219     0.150
    40.925   460.812     0.150
    44.402   594.312     0.150
    44.707   491.367     0.150
    44.707   595.117     0.150
    45.213   494.305     0.150
    47.692   515.992     0.150
    49.140   529.516     0.150
    49.140   529.438     0.150
    49.140    11.195     0.150
    98.494   546.359     0.150
    98.494   545.914     0.150
    98.494   547.078     0.150
    52.406   549.758     0.150
    53.025   557.234     0.150
    53.025   554.258     0.150
    53.025   557.258     0.150
    53.171   558.438     0.150
    53.310   558.719     0.150
    54.538   568.039     0.150
    54.930    11.312     0.150
    54.930   570.727     0.150
    54.930   570.781     0.150
    55.506   572.836     0.150
    55.506   574.523     0.150
    30.514   577.109     0.150
    55.878   580.828     0.150
    56.713  4245.281     0.150
    56.722  4263.766     0.150
    56.900   586.617     0.150
    57.688   591.922     0.150
    57.688   591.633     0.150
    57.761   592.898     0.150
    58.283   595.180     0.150
    58.346   596.898     0.150
    58.346   596.219     0.150
    59.169   599.766     0.150
    59.876   604.422     0.150
    59.876   606.469     0.150
    60.182   609.609     0.150
    60.483   611.016     0.150
    60.891   613.062     0.150
    60.891   613.016     0.150
    60.891   612.984     0.150
    60.891   613.117     0.150
    60.990   614.953     0.150
    61.090   615.406     0.150
    61.640   619.078     0.150
    61.945   620.672     0.150
    62.749   626.906     0.150
    63.291   629.516     0.150
    63.291   629.414     0.150
    64.553   637.383     0.150
    64.606   638.344     0.150
    64.606   638.359     0.150
    65.242   640.914     0.150
    65.260   641.312     0.150
    65.374   644.188     0.150
    65.580   643.812     0.150
    66.083   647.625     0.150
    66.139   646.812     0.150
    66.139    11.492     0.150
    66.139    16.203     0.150
    66.139   646.906     0.150
    66.270   649.500     0.150
    66.410   650.711     0.150
    66.410    11.828     0.150
    67.176   655.414     0.150
    67.506   657.266     0.150
    68.091   660.758     0.150
    68.480    11.406     0.150
    68.509   663.883     0.150
    69.242   667.805     0.150
    69.755   671.734     0.150
    70.289   673.945     0.150
    70.289   673.914     0.150
    71.027   679.516     0.150
    71.566   682.672     0.150
    71.851   684.453     0.150
    79.759   727.812     0.150
    79.950   727.812     0.150
    80.503   731.719     0.150
    80.517   733.188     0.150
    80.890   734.117     0.150
    80.890   734.242     0.150
    80.890   734.328     0.150
    80.890    16.414     0.150
    81.420   735.797     0.150
    81.691   738.672     0.150
   126.231   741.266     0.150
    82.846   744.992     0.150
    82.885   745.609     0.150
    83.074   746.422     0.150
    83.130   746.812     0.150
    83.178   744.578     0.150
    83.285   747.078     0.150
    83.400  6278.375     0.150
    83.408  6280.523     0.150
    83.418  6290.328     0.150
    83.945  6350.859     0.150
    83.946  6343.836     0.150
    83.961  6352.164     0.150
    84.861   751.484     0.150
    84.861    11.734     0.150
    85.272   755.617     0.150
    85.446   759.117     0.150
    85.446   758.789     0.150
    85.449   758.367     0.150
    85.449   758.445     0.150
    85.449   758.203     0.150
    85.458   757.516     0.150
    85.458   756.914     0.150
    85.504   757.898     0.150
    85.504   758.219     0.150
    85.504   757.977     0.150
    85.681   759.219     0.150
    85.731   758.219     0.150
    86.800   764.867     0.150
    86.822   763.117     0.150
    87.270   765.453     0.150
    88.179   769.969     0.150
    88.355   772.336     0.150
    88.755   772.938     0.150
    88.755    12.078     0.150
    88.755    17.570     0.150
    89.447  1999.219     0.150
    89.447   777.453     0.150
    89.447    11.562     0.150
   107.907   777.859     0.150
    89.605   777.133     0.150
    89.605    11.523     0.150
    90.243   779.914     0.150
    90.243   779.914     0.150
    90.814   783.289     0.150
    90.972   782.414     0.150
    91.231   785.414     0.150
    91.365   785.617     0.150
    91.365   785.617     0.150
    91.365  1835.516     0.150
    91.365  2033.516     0.150
    91.365  2405.516     0.150
    91.365  2585.516     0.150
    91.631   787.219     0.150
    91.663   787.812     0.150
    92.039   790.297     0.150
    92.824   789.312     0.150
    92.838   793.312     0.150
    92.901   793.312     0.150
    93.060   793.898     0.150
    93.356   792.672     0.150
    93.356   792.719     0.150
    93.375   794.414     0.150
    93.651   796.312     0.150
    94.050   798.516     0.150
    94.050   798.609     0.150
    94.388   800.055     0.150
    94.388   800.016     0.150
    94.388   800.016     0.150
    94.624   801.219     0.150
    94.624   801.148     0.150
    94.776   799.914     0.150
    95.294   805.117     0.150
    95.294   805.094     0.150
    95.295   805.477     0.150
    95.301   805.516     0.150
    95.301   805.555     0.150
    95.533   804.414     0.150
    95.533   804.484     0.150
    95.745   805.023     0.150
    96.008   808.328     0.150
    96.066   808.359     0.150
    96.185   809.148     0.150
    96.261   808.719     0.150
    96.279   809.414     0.150
    96.465   808.633     0.150
    96.465   808.633     0.150
    96.465  1167.555     0.150
    96.465  1881.414     0.150
    96.465  2106.086     0.150
    96.465   808.617     0.150
    96.465  1042.914     0.150
    96.465  1167.516     0.150
    96.465  1443.812     0.150
    96.465  1881.414     0.150
    96.465  2106.016     0.150
    96.908   809.914     0.150
    96.948   812.836     0.150
    96.978   812.836     0.150
    96.978   812.812     0.150
    97.307   812.828     0.150
    71.722   813.953     0.150
    97.372   813.719     0.150
    97.553   812.625     0.150
    97.595   815.188     0.150
    99.179   821.648     0.150
    99.179   821.617     0.150
    99.247   832.812     0.150
    99.323   822.812     0.150
    99.378   821.617     0.150
    99.378  1190.219     0.150
    99.610   822.867     0.150
    99.699   824.312     0.150
    99.747   822.648     0.150
    99.858   825.516     0.150
   100.019   825.688     0.150
   100.099   826.016     0.150
   100.482   828.516     0.150
   101.145   829.312     0.150
   101.160   828.016     0.150
   101.296   831.312     0.150
   101.734   833.617     0.150
   101.860   833.719     0.150
   101.890   833.219     0.150
   102.246   731.094     0.150
   103.084   838.516     0.150
   103.312   840.117     0.150
   103.425   840.219     0.150
   103.722   841.914     0.150
   107.584   859.305     0.150
   108.364   820.211     0.150
   111.855  1115.727     0.150
   114.011  1119.938     0.150
   116.841  1125.297     0.150
   118.596  1128.969     0.150
   118.664  1128.797     0.150
   118.640  1128.875     0.150
   118.716  1128.836     0.150
   118.747  1129.094     0.150
   118.784  1129.094     0.150
   118.824  1129.039     0.150
   118.824  1206.898     0.150
   119.490  1130.383     0.150
   122.842  1136.453     0.150
   125.381  1719.516     0.150
   125.381  1142.047     0.150
   126.260  1128.164     0.150
   126.260  1715.266     0.150
   126.260  1143.016     0.150
   128.632  1147.219     0.150
   130.064  1149.984     0.150
   130.064  1150.969     0.150
   132.414  1155.062     0.150
   133.271  1156.617     0.150
   135.006  1145.438     0.150
   126.382  1163.266     0.150
   137.143  1151.867     0.150
   137.143  1164.117     0.150
   138.037  1167.148     0.150
   144.345  1178.414     0.150
   107.222  1183.188     0.150
     2.403    36.113     0.150
     4.282    68.305     0.150
     4.352    61.926     0.150
     7.278   193.035     0.150
     7.279   553.141     0.150
     7.308   549.234     0.150
    10.815   150.996     0.150
    96.017   203.523     0.150
    92.967   236.324     0.150
     1.682    27.582     0.150
     3.006    47.883     0.150
     3.104    51.121     0.150
     3.617    57.223     0.150
     3.791    60.641     0.150
     7.247   552.375     0.150
    51.222   180.730     0.150
    96.007   205.332     0.150
    56.211   579.742     0.150
    56.430  4229.855     0.150
    56.439  4230.965     0.150
     0.327     7.516     0.150
     0.327    13.703     0.150
     0.877    16.336     0.150
     0.877    28.535     0.150
     0.983    17.484     0.150
     0.983    30.914     0.150
     1.368    23.164     0.150
     1.368    40.773     0.150
     1.568    25.227     0.150
     1.568    47.047     0.150
     1.951    29.785     0.150
     1.951    55.965     0.150
     1.931    56.016     0.150
     2.164    34.855     0.150
     2.164    62.504     0.150
     2.346    39.113     0.150
     2.758    43.637     0.150
     2.758    76.676     0.150
     2.725    42.727     0.150
     2.795    40.855     0.150
     2.795    40.855     0.150
     3.003    49.566     0.150
     3.003    80.137     0.150
     3.408    60.566     0.150
     3.408   101.094     0.150
     3.434    51.926     0.150
     3.434    94.445     0.150
     3.547    57.465     0.150
     3.547    94.656     0.150
     3.446    49.945     0.150
     3.446    49.945     0.150
     3.561    55.914     0.150
     3.561    96.445     0.150
     3.709    55.246     0.150
     3.862   105.047     0.150
     3.921   113.055     0.150
     3.957    61.125     0.150
     3.957   105.836     0.150
     3.951   105.047     0.150
     4.042    61.195     0.150
     4.042   109.695     0.150
     4.112   110.363     0.150
     4.328    64.453     0.150
     4.195   112.594     0.150
     4.384    67.574     0.150
     4.384   117.004     0.150
     4.387    64.605     0.150
     4.558    68.395     0.150
     4.558   115.613     0.150
     4.585    69.176     0.150
     4.585   128.336     0.150
     4.472    63.625     0.150
     4.472    63.625     0.150
     4.472   127.266     0.150
     4.896    73.016     0.150
     5.218    77.434     0.150
     5.218   132.336     0.150
     5.344    77.445     0.150
     5.373    80.355     0.150
     5.373   137.344     0.150
     5.404    78.504     0.150
     5.575    82.684     0.150
     5.575   141.023     0.150
     5.691    84.445     0.150
     5.691   144.156     0.150
     5.880    84.977     0.150
     5.880   149.945     0.150
     5.848    83.273     0.150
     5.848    83.273     0.150
     6.363    92.145     0.150
     6.363   155.703     0.150
     6.716    95.574     0.150
     6.716    95.574     0.150
     6.716   191.387     0.150
     7.121   101.066     0.150
     7.121   172.613     0.150
     8.092   112.855     0.150
     8.092   112.855     0.150
     8.092   199.414     0.150
     8.743   126.766     0.150
     8.743   222.453     0.150
    95.707   201.895     0.150
    14.927   213.047     0.150
    14.930   213.023     0.150
     3.729    66.217     0.150
     3.782    64.127     0.150
     4.620    76.518     0.150
     4.786   136.007     0.150
     4.269    81.109     0.150
     4.564    74.719     0.150
     4.744    76.180     0.150
     5.553    75.180     0.150
     6.541   174.172     0.150
     6.629   105.703     0.150
     7.115   522.570     0.150
     8.272   218.250     0.150
    56.818  4243.188     0.150
    56.827  4244.453     0.150
     0.140     4.859     0.150
     0.140     8.609     0.150
     0.964    18.318     0.150
     0.964    31.988     0.150
     1.058    19.369     0.150
     1.058    33.529     0.150
     1.514    23.889     0.150
     1.514    41.428     0.150
     1.610    29.279     0.150
     1.610    49.969     0.150
     2.016    31.828     0.150
     2.016    59.039     0.150
     2.398    41.443     0.150
     2.398    41.279     0.150
     2.398    74.879     0.150
     2.391    39.838     0.150
     2.391    69.748     0.150
     2.825    44.549     0.150
     2.825    76.119     0.150
     2.910    50.869     0.150
     2.910    77.369     0.150
     3.077    40.600     0.150
     3.077    40.600     0.150
     3.077    83.039     0.150
     3.041    49.859     0.150
     3.041    86.918     0.150
     3.288    49.520     0.150
     3.288    86.939     0.150
     3.634    57.588     0.150
     3.634   102.648     0.150
     3.708    63.709     0.150
     3.708   106.418     0.150
     3.663    57.859     0.150
     3.733   105.369     0.150
     3.840    57.668     0.150
     3.840   105.619     0.150
     4.015   104.639     0.150
     4.015   104.639     0.150
     4.095   104.059     0.150
     4.095    69.459     0.150
     4.095   104.059     0.150
     4.105    70.969     0.150
     4.105   106.418     0.150
     4.106    60.248     0.150
     4.114   106.139     0.150
     4.123   111.408     0.150
     4.131   113.270     0.150
     4.139    64.939     0.150
     4.139   111.398     0.150
     4.143   111.998     0.150
     4.148   106.359     0.150
     4.184   113.799     0.150
     4.237   112.309     0.150
     4.292   111.850     0.150
     4.408    66.229     0.150
     4.408   115.248     0.150
     4.401    66.838     0.150
     4.401   117.488     0.150
     4.566    71.039     0.150
     4.566   127.889     0.150
     4.569    70.889     0.150
     4.569   127.918     0.150
     4.571    71.498     0.150
     4.571   128.770     0.150
     4.685    67.389     0.150
     4.685   124.738     0.150
     4.717    73.668     0.150
     4.717   133.898     0.150
     4.755    70.408     0.150
     4.755   127.248     0.150
     5.004   138.979     0.150
     5.004   138.979     0.150
     5.041    76.299     0.150
     5.041   133.199     0.150
     5.361    81.119     0.150
     5.361   136.238     0.150
     5.428    80.639     0.150
     5.428   135.850     0.150
     5.495    83.029     0.150
     5.495   140.648     0.150
     5.523    80.049     0.150
     5.523   147.779     0.150
     5.641    83.838     0.150
     5.641   155.449     0.150
     5.740    85.338     0.150
     5.740   153.209     0.150
     6.036    90.369     0.150
     6.036   162.428     0.150
     6.094    92.209     0.150
     6.094   161.379     0.150
     6.323    96.408     0.150
     6.323   162.020     0.150
     6.448   172.828     0.150
     6.448    95.309     0.150
     6.448   172.828     0.150
     6.845   103.369     0.150
     6.845   177.619     0.150
     7.139   528.615     0.150
     7.268   195.418     0.150
     7.268   106.520     0.150
     7.268   195.418     0.150
     7.256   107.318     0.150
     7.460   197.559     0.150
     7.460   109.148     0.150
     7.460   197.559     0.150
     7.720   208.100     0.150
     7.720   115.398     0.150
     7.720   208.100     0.150
     7.954   118.209     0.150
     8.228   120.229     0.150
     8.228   207.078     0.150
     8.730   225.539     0.150
     8.887   128.629     0.150
     8.887   228.328     0.150
     9.581   142.479     0.150
     9.581   244.818     0.150
     9.652   142.959     0.150
     9.943   143.479     0.150
     9.943   258.068     0.150
    10.110   143.809     0.150
    10.110   260.338     0.150
    10.969   153.748     0.150
    11.193   162.020     0.150
    11.222   161.520     0.150
    11.546   161.488     0.150
    51.402   177.508     0.150
    13.343   194.809     0.150
    13.395   176.934     0.150
    95.953   200.998     0.150
    16.867   233.350     0.150
    95.509   253.379     0.150
    18.276   250.059     0.150
    18.503   250.709     0.150
    23.796   313.379     0.150
    24.828   322.939     0.150
    53.648   558.270     0.150
    54.622   564.918     0.150
    55.698   573.219     0.150
    56.029   576.119     0.150
    56.612  4240.768     0.150
    56.621  4242.061     0.150
    85.444   753.619     0.150
    96.905   810.021     0.150
     3.917    63.664     0.150
     4.422    59.234     0.150
     4.443    59.755     0.150
     4.448    62.154     0.150
     4.451    59.314     0.150
     0.503     9.920     0.150
     0.503    17.970     0.150
     1.448    24.020     0.150
     1.448    42.430     0.150
     1.702    27.790     0.150
     1.702    27.790     0.150
     1.877    37.620     0.150
     2.089    31.190     0.150
     2.461    36.060     0.150
     2.461    59.360     0.150
     2.556    39.090     0.150
     3.027    48.030     0.150
     3.027    83.370     0.150
     3.469    50.910     0.150
     4.036    57.690     0.150
     4.359    63.870     0.150
     4.946    72.160     0.150
     5.148   128.640     0.150
     5.420    79.860     0.150
     5.420   135.520     0.150
     5.518    86.880     0.150
     7.465   566.820     0.150
    50.789   185.190     0.150
    96.217   213.560     0.150
    95.810   259.110     0.150
    12.109   262.170     0.150
    61.574   276.040     0.150
    21.427   288.780     0.150
    91.488   289.030     0.150
    92.149   297.170     0.150
    22.518   300.400     0.150
    95.126   304.110     0.150
    23.671   310.390     0.150
    24.614   319.660     0.150
    25.455   328.330     0.150
    34.125   331.470     0.150
    55.265   571.460     0.150
     2.264    69.332     0.150
     4.381   113.930     0.150
     4.480    73.270     0.150
     5.222    76.270     0.150
     5.289    84.973     0.150
    54.748   568.031     0.150
    56.476  4233.289     0.150
    56.485  4234.742     0.150
     0.228     6.340     0.150
     0.228    11.008     0.150
     1.210    22.328     0.150
     1.210    38.891     0.150
     1.313    23.711     0.150
     1.313    23.711     0.150
     1.313    40.551     0.150
     1.497    26.430     0.150
     1.497    45.801     0.150
     1.700    26.648     0.150
     1.700    49.961     0.150
     1.828    29.520     0.150
     1.828    54.570     0.150
     2.237    33.621     0.150
     2.621    40.750     0.150
     2.621    70.711     0.150
     2.760    74.238     0.150
     2.668    44.750     0.150
     2.668    76.230     0.150
     2.971    41.109     0.150
     2.971    41.109     0.150
     2.971    81.828     0.150
     2.976    46.910     0.150
     2.976    83.211     0.150
     3.063    47.230     0.150
     3.334    51.348     0.150
     3.424    54.809     0.150
     3.397    52.668     0.150
     3.422    54.000     0.150
     3.525    53.211     0.150
     3.490    54.668     0.150
     3.667    56.660     0.150
     3.775    59.320     0.150
     3.731    57.820     0.150
     3.844    58.648     0.150
     3.857    59.980     0.150
     3.857    58.648     0.150
     3.857   100.508     0.150
     3.861    61.648     0.150
     3.874    59.930     0.150
     3.864    54.480     0.150
     3.880    58.648     0.150
     3.880   113.141     0.150
     3.883    61.980     0.150
     3.889    61.980     0.150
     3.901    60.648     0.150
     3.986    58.648     0.150
     3.986    58.648     0.150
     4.092    60.980     0.150
     4.092   114.801     0.150
     4.046    65.301     0.150
     4.046    65.301     0.150
     4.046   115.801     0.150
     4.108    55.328     0.150
     4.108    55.328     0.150
     4.181    71.938     0.150
     4.181   120.449     0.150
     4.301    64.750     0.150
     4.301   121.551     0.150
     4.306    65.281     0.150
     4.306   120.848     0.150
     4.309    65.281     0.150
     4.387    65.629     0.150
     4.380    61.090     0.150
     4.357    64.629     0.150
     4.489    64.570     0.150
     4.489    64.570     0.150
     4.633    68.789     0.150
     4.745    70.961     0.150
     4.742   133.410     0.150
     5.064    75.648     0.150
     5.064   126.430     0.150
     5.113    75.070     0.150
     5.113   140.500     0.150
     5.188    76.938     0.150
     5.188   141.898     0.150
     5.490   148.449     0.150
     5.457    80.070     0.150
     5.483   136.578     0.150
     5.483   136.578     0.150
     5.746   147.379     0.150
     5.746   153.008     0.150
     5.786    86.371     0.150
     5.786   159.258     0.150
     6.132    89.559     0.150
     6.132   155.461     0.150
     6.021    89.469     0.150
     7.145   101.258     0.150
     7.145   101.258     0.150
     7.145   178.531     0.150
     7.435   548.617     0.150
     7.747   114.328     0.150
     7.747   199.621     0.150
     8.589   122.859     0.150
     8.589   228.910     0.150
     8.931   135.008     0.150
     9.641   147.359     0.150
    10.665   147.508     0.150
    11.015   162.309     0.150
    11.014   154.820     0.150
    11.589   161.840     0.150
    12.001   165.141     0.150
    51.111   177.480     0.150
    12.820   177.359     0.150
    95.863   200.340     0.150
    15.590   225.309     0.150
   147.984   226.211     0.150
    16.864   238.949     0.150
    16.864   239.309     0.150
    92.816   235.379     0.150
    17.761   243.098     0.150
    18.195   245.461     0.150
    85.223   248.891     0.150
    95.439   251.738     0.150
    11.656   255.348     0.150
    19.289   258.969     0.150
    25.456   265.000     0.150
    61.948   268.898     0.150
    21.036   280.840     0.150
    91.172   280.938     0.150
    21.412   285.461     0.150
    21.460   287.230     0.150
   121.078   289.348     0.150
    21.767   288.359     0.150
    67.034   290.809     0.150
    22.090   293.090     0.150
    22.244   294.738     0.150
    22.322   296.109     0.150
    22.667   295.660     0.150
    23.731   309.059     0.150
    24.063   317.508     0.150
    24.019   313.371     0.150
    25.015   322.309     0.150
    33.706   322.668     0.150
    27.593   341.641     0.150
    35.245   411.531     0.150
    39.600   448.500     0.150
    49.137   522.078     0.150
    55.448   570.598     0.150
    55.774   573.730     0.150
    55.792   574.418     0.150
    56.371  4226.129     0.150
    56.380  4227.508     0.150
    59.548   597.781     0.150
    62.795   624.434     0.150
    63.875   630.969     0.150
    66.050   646.684     0.150
    80.310   730.359     0.150
    85.075   756.309     0.150
    85.312   753.180     0.150
     0.633    13.801     0.150
     0.633    24.551     0.150
     1.021    18.633     0.150
     1.021    32.223     0.150
     1.101    20.453     0.150
     1.101    35.250     0.150
     1.213    21.570     0.150
     1.213    37.160     0.150
     1.669    27.352     0.150
     1.669    42.820     0.150
     1.785    30.359     0.150
     1.907    29.891     0.150
     1.907    50.742     0.150
     2.377    37.922     0.150
     2.377    65.562     0.150
     2.496    38.781     0.150
     2.566    40.953     0.150
     2.566    66.711     0.150
     2.697    40.980     0.150
     2.856    43.520     0.150
     2.856    77.871     0.150
     2.919    44.859     0.150
     2.919    76.680     0.150
     3.012    46.500     0.150
     3.012    81.793     0.150
     3.031    48.043     0.150
     3.128    48.160     0.150
     3.128    83.652     0.150
     3.158    49.301     0.150
     3.158    79.801     0.150
     3.160    50.520     0.150
     3.160    84.480     0.150
     3.307    51.621     0.150
     3.307    87.992     0.150
     3.352    56.562     0.150
     3.352    88.531     0.150
     3.300    50.121     0.150
     3.300    87.191     0.150
     3.436    52.590     0.150
     3.436    89.031     0.150
     3.410    54.102     0.150
     3.410    84.801     0.150
     3.461    53.453     0.150
     3.461    90.211     0.150
     3.489    55.359     0.150
     3.507    54.793     0.150
     3.507    84.250     0.150
     3.507    44.160     0.150
     3.507    85.203     0.150
     3.519    55.562     0.150
     3.548    55.410     0.150
     3.548    93.383     0.150
     3.558    55.250     0.150
     3.611    56.250     0.150
     3.611    93.891     0.150
     3.640    57.312     0.150
     3.640    95.191     0.150
     3.713    55.453     0.150
     3.764    57.070     0.150
     3.764    98.840     0.150
     3.843    59.621     0.150
     3.843   103.641     0.150
     3.971    61.609     0.150
     3.971   104.891     0.150
     4.009    60.410     0.150
     3.984    61.320     0.150
     3.984   103.723     0.150
     3.983    61.430     0.150
     3.983   107.012     0.150
     3.984    61.609     0.150
     3.984   106.453     0.150
     4.078    60.750     0.150
     4.078   115.562     0.150
     4.078    60.832     0.150
     4.172    63.742     0.150
     4.172   110.402     0.150
     4.192   107.430     0.150
     4.154    63.043     0.150
     4.154   111.812     0.150
     4.233    64.480     0.150
     4.233   108.770     0.150
     4.516    68.133     0.150
     4.838    72.801     0.150
     4.838   123.652     0.150
     5.018    74.441     0.150
     5.018   128.410     0.150
     5.010    75.492     0.150
     5.032    75.352     0.150
     5.032   124.500     0.150
     5.613    77.961     0.150
     5.613   137.203     0.150
     5.730    84.840     0.150
     5.730   139.352     0.150
     6.009   146.043     0.150
     6.035    89.230     0.150
     6.737    98.301     0.150
     7.033   102.641     0.150
     7.033   169.641     0.150
     7.684   558.809     0.150
     7.715   568.125     0.150
     7.717   112.473     0.150
     7.717   195.633     0.150
     7.997   109.832     0.150
     8.361   120.602     0.150
     8.361   209.883     0.150
     9.430   132.082     0.150
     9.430   236.691     0.150
    51.225   174.391     0.150
    13.803   193.371     0.150
    19.187   259.871     0.150
    94.356   261.562     0.150
    21.856   287.133     0.150
    21.842   290.531     0.150
    22.836   298.801     0.150
    24.684   531.281     0.150
    32.683   385.273     0.150
    32.683   385.270     0.150
    44.538   483.281     0.150
    48.708   536.203     0.150
    54.584   624.281     0.150
    54.888   564.941     0.150
    55.524   568.441     0.150
    55.524    20.148     0.150
    60.386   620.062     0.150
    62.870   620.105     0.150
    63.823   625.750     0.150
    63.823    18.051     0.150
    66.281   642.000     0.150
    66.281    18.383     0.150
    68.938   655.371     0.150
    80.806   726.430     0.150
    80.806    18.793     0.150
    84.849   747.832     0.150
    86.527   753.910     0.150
    86.875   755.609     0.150
    90.393   772.211     0.150
   137.353  1155.930     0.150
     2.245    64.836     0.150
     1.147    35.443     0.150
     1.246    39.645     0.150
     1.249    38.863     0.150
     2.355    71.473     0.150
     2.557    69.264     0.150
     2.723    72.604     0.150
     2.948    73.473     0.150
     2.999    79.674     0.150
     3.085    78.473     0.150
     3.077    81.854     0.150
     3.153    81.363     0.150
     3.717    95.133     0.150
     3.749    97.623     0.150
     3.754    97.123     0.150
     3.769    95.814     0.150
     3.952    97.895     0.150
    23.870   318.533     0.150
     1.105    37.879     0.150
     2.808    41.180     0.150
     4.327    68.180     0.150
     4.606    66.762     0.150
     4.617    74.672     0.150
     4.941    71.082     0.150
     5.262    75.902     0.150
     5.711    80.852     0.150
     5.933    83.160     0.150
     5.995    86.441     0.150
     3.671    93.668     0.150
     5.407    71.277     0.150
     2.154    55.705     0.150
     3.028    50.194     0.150
     3.028    77.075     0.150
     2.981    52.545     0.150
     3.375    86.154     0.150
     3.889    67.055     0.150
     4.019    67.715     0.150
     4.078    68.234     0.150
     4.314   109.965     0.150
     4.336    71.745     0.150
     3.422    57.542     0.150
     4.368    63.062     0.150
     4.493    73.242     0.150
     5.172   142.772     0.150
     5.470   151.922     0.150
     7.454   199.432     0.150
     1.234    39.450     0.150
     1.468    45.270     0.150
     2.929    43.540     0.150
     4.702   127.500     0.150
     1.258    38.030     0.150
     2.961    90.920     0.150
     3.012    38.940     0.150
     3.123    85.580     0.150
     3.326    86.090     0.150
     3.749    56.000     0.150
     3.749    91.700     0.150
     4.284   109.140     0.150
     4.312    63.021     0.150
     4.511    67.240     0.150
     4.830    70.200     0.150
     5.051   128.010     0.150
     5.274    74.760     0.150
     5.274   130.460     0.150
     6.039    98.130     0.150
     2.496    82.523     0.150
     3.007    47.156     0.150
     4.163    67.672     0.150
     4.254    69.305     0.150
     4.705    75.461     0.150
     4.968    79.586     0.150
     1.245    23.016     0.150
     1.245    23.105     0.150
     1.245    39.195     0.150
     2.556    47.226     0.150
     2.919    85.835     0.150
     3.236    94.096     0.150
     3.385    53.025     0.150
     3.557    51.886     0.150
     3.670    56.105     0.150
     3.670    62.785     0.150
     3.928    66.966     0.150
     4.757    70.865     0.150
     5.361   136.466     0.150
     5.411   151.436     0.150
     7.151   193.476     0.150
     8.419   124.045     0.150
     9.869   179.235     0.150
   148.130   216.136     0.150
    19.372   268.355     0.150
    23.353   311.415     0.150
    23.716   315.405     0.150
    31.162   381.285     0.150
    31.162   380.806     0.150
    43.789   488.835     0.150
    53.945   629.585     0.150
     3.577    59.738     0.150
     5.639    81.807     0.150
     1.203    21.453     0.150
     1.203    35.742     0.150
     2.876    90.152     0.150
     3.024    80.492     0.150
     5.159    82.254     0.150
     1.478    45.389     0.150
     3.676    98.828     0.150
     3.911   101.658     0.150
     4.225    63.988     0.150
     4.453   127.139     0.150
     4.453   127.309     0.150
     7.162    96.008     0.150
     1.492    47.949     0.150
     3.459    57.410     0.150
     3.626    89.949     0.150
     3.936    54.711     0.150
     3.943    57.961     0.150
     4.152    70.859     0.150
     4.242    70.109     0.150
     4.425   126.551     0.150
     6.234   170.801     0.150
     7.245   101.750     0.150
     7.380   532.660     0.150
     7.411   539.531     0.150
     8.014   117.660     0.150
     8.674   231.398     0.150
    10.933   161.570     0.150
    95.857   201.270     0.150
    15.485   224.242     0.150
   147.886   225.492     0.150
    16.773   236.656     0.150
    16.773   238.371     0.150
    92.807   234.832     0.150
    18.393   251.250     0.150
    11.583   255.750     0.150
    94.808   265.801     0.150
    19.678   265.000     0.150
    62.056   268.320     0.150
    20.055   269.879     0.150
    21.350   288.309     0.150
    67.127   291.289     0.150
    21.738   288.449     0.150
    22.227   294.109     0.150
    23.164   303.961     0.150
    33.606   324.301     0.150
    21.694   333.711     0.150
    36.309   421.711     0.150
    45.741   498.270     0.150
    49.248   536.422     0.150
    81.107   539.859     0.150
    20.300   542.590     0.150
    98.783   546.410     0.150
    51.798   555.141     0.150
    54.234   571.590     0.150
    55.520   583.852     0.150
    59.654   611.121     0.150
    60.240   616.141     0.150
    60.473   616.109     0.150
    80.632   731.391     0.150
    85.084   752.898     0.150
    91.376   786.750     0.150
    95.772   807.199     0.150
     1.885    59.773     0.150
     3.921    56.250     0.150
     4.286    62.219     0.150
     4.655    77.172     0.150
     1.900    58.031     0.150
     1.981    57.477     0.150
     3.599    57.352     0.150
     3.599   100.656     0.150
     4.363    58.867     0.150
     4.363   122.148     0.150
     4.441   124.922     0.150
     4.603   126.922     0.150
     4.628    67.141     0.150
     5.381    72.359     0.150
     5.733    81.523     0.150
     7.234   109.477     0.150
     8.140   214.375     0.150
    54.524   562.719     0.150
     0.177     3.535     0.150
     0.177     3.535     0.150
     0.177     6.938     0.150
     0.898    30.227     0.150
     1.056    35.508     0.150
     1.056    19.617     0.150
     1.056    35.508     0.150
     1.159    37.797     0.150
     1.159    20.996     0.150
     1.159    38.156     0.150
     1.836    30.355     0.150
     1.836    54.059     0.150
     2.241    67.797     0.150
     2.241    67.797     0.150
     2.514    41.738     0.150
     2.894    44.445     0.150
     2.912    45.238     0.150
     2.912    82.156     0.150
     3.107    46.238     0.150
     2.930    49.496     0.150
     2.930    49.496     0.150
     2.930    84.137     0.150
     3.441    53.168     0.150
     3.441    95.348     0.150
     3.452    55.855     0.150
     3.515    54.328     0.150
     3.515    98.027     0.150
     3.629    57.629     0.150
     3.725    59.176     0.150
     3.891    61.836     0.150
     3.911    61.836     0.150
     3.919    62.496     0.150
     3.919   108.906     0.150
     3.923   109.777     0.150
     3.949    61.488     0.150
     3.932    62.496     0.150
     3.932   111.008     0.150
     3.939    62.496     0.150
     3.947    58.516     0.150
     3.947    58.516     0.150
     3.962    61.836     0.150
     4.050    63.168     0.150
     4.107    65.816     0.150
     4.225    63.328     0.150
     4.225   114.727     0.150
     4.150    67.816     0.150
     4.185    63.168     0.150
     4.376    66.688     0.150
     4.379    66.867     0.150
     4.381    67.328     0.150
     4.403    64.496     0.150
     4.507    65.766     0.150
     4.507   120.887     0.150
     4.493    67.277     0.150
     4.493   119.406     0.150
     4.383    63.977     0.150
     4.383    69.207     0.150
     4.565    68.277     0.150
     4.565   114.668     0.150
     4.598    71.188     0.150
     4.847    73.316     0.150
     4.847   134.227     0.150
     5.168    76.656     0.150
     5.244    78.797     0.150
     5.244   138.746     0.150
     5.304    78.457     0.150
     5.304    78.457     0.150
     5.304   141.457     0.150
     5.547    83.059     0.150
     5.547   147.469     0.150
     5.611    82.848     0.150
     5.611    82.848     0.150
     5.611   147.469     0.150
     5.632    86.047     0.150
     5.632   154.836     0.150
     5.842    90.168     0.150
     5.981    92.219     0.150
     5.981   164.348     0.150
     6.264    91.977     0.150
     6.264   165.406     0.150
     6.551   180.727     0.150
     6.910   104.035     0.150
     6.910   186.887     0.150
     7.361   543.785     0.150
     7.274   103.855     0.150
     7.274   187.598     0.150
     7.337   189.129     0.150
     7.662   114.535     0.150
     7.662   206.777     0.150
     8.035   115.176     0.150
     9.750   147.758     0.150
     9.920   135.336     0.150
     9.920   259.047     0.150
    10.888   150.762     0.150
    10.888   323.934     0.150
    14.209   193.324     0.150
    16.727   509.949     0.150
    20.567   278.758     0.150
    21.946   293.727     0.150
    24.147   314.168     0.150
    24.087    12.301     0.150
    25.024    11.758     0.150
    35.151    13.859     0.150
    35.151   411.098     0.150
    36.265   420.336     0.150
    45.418   495.047     0.150
    45.710   494.684     0.150
    48.777   530.938     0.150
    48.791   529.766     0.150
    48.791   527.758     0.150
    49.290   534.418     0.150
    49.290   532.207     0.150
    49.804   537.777     0.150
    50.453   543.367     0.150
    50.477   542.578     0.150
    51.212   548.418     0.150
    51.265   547.309     0.150
    51.841   553.059     0.150
    51.841   552.469     0.150
    51.973   554.668     0.150
    52.637   559.336     0.150
    52.637    15.402     0.150
    53.508   565.996     0.150
    54.278   571.668     0.150
    54.702   628.336     0.150
    55.083   574.836     0.150
    55.563   581.277     0.150
    56.521  4223.051     0.150
    56.530  4227.633     0.150
    56.634   588.219     0.150
    56.727   588.797     0.150
    57.502   594.266     0.150
    57.720   595.676     0.150
    58.908   603.719     0.150
    59.938   610.438     0.150
    60.285   614.066     0.150
    60.512   613.578     0.150
    60.754   616.457     0.150
    60.862   616.766     0.150
    61.225   619.719     0.150
    61.739   622.957     0.150
    62.525   628.617     0.150
    62.947   630.328     0.150
    62.947   623.867     0.150
    62.947   628.457     0.150
    64.016   633.508     0.150
    64.207   638.816     0.150
    64.546   640.418     0.150
    66.202   652.516     0.150
    66.202   652.156     0.150
    66.763   655.855     0.150
    66.814   655.438     0.150
    67.148   658.059     0.150
    67.728   662.309     0.150
    68.216   664.957     0.150
    68.912   669.027     0.150
    69.348   672.367     0.150
    77.852   712.695     0.150
    80.158   728.230     0.150
    80.624   727.133     0.150
    85.304   753.332     0.150
    90.548   777.129     0.150
    90.674   777.898     0.150
    92.338   787.469     0.150
    93.363   792.266     0.150
    93.510   791.957     0.150
    93.958   794.398     0.150
    95.173   807.457     0.150
    96.974   808.195     0.150
   125.858  1144.758     0.150
   126.729  1147.395     0.150
     6.100    89.164     0.150
     6.232    91.531     0.150
     2.814    45.893     0.150
     4.075    67.123     0.150
     4.359    59.912     0.150
     4.359   111.113     0.150
     4.491    71.604     0.150
     4.578   126.492     0.150
     1.165    21.091     0.150
     1.165    35.871     0.150
     3.478    53.551     0.150
     3.645    65.671     0.150
     4.400    73.031     0.150
     4.672    61.541     0.150
     5.163    76.491     0.150
     5.163   128.531     0.150
     6.025    85.351     0.150
     2.392    45.951     0.150
     2.907    46.940     0.150
     4.249    63.891     0.150
     4.318    71.860     0.150
     4.606    70.011     0.150
     4.740    78.980     0.150
     5.312    78.501     0.150
     5.949    98.131     0.150
     0.896    25.930     0.150
     1.064    35.562     0.150
     2.989    49.562     0.150
     4.309    58.680     0.150
     4.639    74.383     0.150
    24.620   315.555     0.150
    55.304   569.719     0.150
    55.887  4185.672     0.150
    55.896  4186.852     0.150
     2.825    49.377     0.150
     3.437    50.748     0.150
     3.486    51.838     0.150
     4.305    57.217     0.150
     4.320    73.018     0.150
     5.358   131.297     0.150
     5.674   137.857     0.150
     1.094    20.945     0.150
     2.353    64.438     0.150
     2.468    67.207     0.150
     2.807    71.816     0.150
     2.926    42.258     0.150
     2.936    77.758     0.150
     3.004    77.938     0.150
     3.108    79.086     0.150
     3.126    55.445     0.150
     3.154    84.797     0.150
     3.408    88.367     0.150
     3.654    92.156     0.150
     4.153   104.227     0.150
     5.626    89.695     0.150
     5.923    84.777     0.150
     7.096   191.246     0.150
     8.027   118.348     0.150
     9.757   177.641     0.150
     9.757   141.059     0.150
    11.860   170.016     0.150
    19.597   269.637     0.150
    34.850   269.945     0.150
    20.226   277.266     0.150
    20.592   280.926     0.150
    20.785   283.227     0.150
    21.036   285.426     0.150
     5.159   286.695     0.150
    23.166   307.855     0.150
    23.294   312.566     0.150
    23.527   312.398     0.150
    23.873   317.219     0.150
    31.015   380.043     0.150
    31.015   379.598     0.150
    31.588   383.879     0.150
    43.682   486.844     0.150
    43.682   487.238     0.150
    53.877   565.969     0.150
    53.877   565.969     0.150
    58.867   600.738     0.150
    85.338   759.418     0.150
     0.364     7.441     0.150
     0.364    12.391     0.150
     1.299    25.082     0.150
     1.299    42.820     0.150
     1.376    25.602     0.150
     1.376    42.910     0.150
     1.540    28.590     0.150
     1.540    47.820     0.150
     1.570    28.301     0.150
     1.570    47.301     0.150
     2.172    37.930     0.150
     2.172    37.930     0.150
     2.172    63.781     0.150
     2.352    40.102     0.150
     2.352    70.211     0.150
     2.363    40.469     0.150
     2.430    41.090     0.150
     2.423    42.180     0.150
     2.453    40.211     0.150
     2.453    68.660     0.150
     2.601    46.891     0.150
     2.601    73.879     0.150
     2.830    47.262     0.150
     2.830    77.020     0.150
     2.876    52.789     0.150
     2.876    81.691     0.150
     2.952    81.090     0.150
     2.961    81.898     0.150
     2.961    46.410     0.150
     2.961    81.898     0.150
     3.003    48.738     0.150
     3.003    81.719     0.150
     3.025    81.141     0.150
     3.024    87.820     0.150
     3.029    47.531     0.150
     3.029    77.441     0.150
     3.083    87.332     0.150
     3.101    55.148     0.150
     3.101    83.332     0.150
     3.125    81.738     0.150
     3.125    53.859     0.150
     3.125    81.738     0.150
     3.130    55.762     0.150
     3.130    85.309     0.150
     3.144    51.371     0.150
     3.152    45.320     0.150
     3.152    45.320     0.150
     3.152    83.500     0.150
     3.221    56.199     0.150
     3.221    86.750     0.150
     3.236    57.090     0.150
     3.236    87.172     0.150
     3.245    57.141     0.150
     3.245    57.141     0.150
     3.245    92.641     0.150
     3.251    53.430     0.150
     3.251    87.469     0.150
     3.259    49.359     0.150
     3.259    49.359     0.150
     3.259    87.160     0.150
     3.302    95.148     0.150
     3.434    53.488     0.150
     3.434    92.512     0.150
     3.628    63.199     0.150
     3.628   100.449     0.150
     3.634    57.410     0.150
     3.634   103.719     0.150
     3.649    53.852     0.150
     3.649    53.852     0.150
     3.649   100.941     0.150
     3.666    62.891     0.150
     3.666    95.109     0.150
     3.832    62.320     0.150
     3.832   105.371     0.150
     4.066   113.680     0.150
     4.221    68.230     0.150
     4.221    68.230     0.150
     4.221   114.129     0.150
     4.238    65.789     0.150
     4.238   116.500     0.150
     4.288    69.582     0.150
     4.288    69.582     0.150
     4.288   116.859     0.150
     4.390    70.238     0.150
     4.390   120.109     0.150
     4.592    71.531     0.150
     4.592   128.551     0.150
     4.709    72.082     0.150
     4.709   126.520     0.150
     4.921    70.879     0.150
     4.921    70.879     0.150
     4.921   126.000     0.150
     4.987    81.301     0.150
     4.987   140.082     0.150
     4.987    81.301     0.150
     4.987   140.082     0.150
     5.175    78.102     0.150
     5.175   132.160     0.150
     5.281    78.020     0.150
     5.281   137.160     0.150
     5.298    84.449     0.150
     5.298    84.449     0.150
     5.298   146.570     0.150
     5.368    82.020     0.150
     5.368   143.012     0.150
     5.950    86.461     0.150
     5.950    86.461     0.150
     6.161    94.461     0.150
     6.161   160.262     0.150
     6.542   180.691     0.150
     6.542    97.000     0.150
     6.542   180.691     0.150
     7.572   113.871     0.150
     7.572   202.629     0.150
     7.894   115.051     0.150
     8.167   118.801     0.150
     8.167   223.070     0.150
     9.764   178.184     0.150
    19.207   265.309     0.150
    19.901   272.141     0.150
    23.288   312.184     0.150
    23.713   312.609     0.150
    23.877   317.961     0.150
    31.028   379.137     0.150
    43.687   486.859     0.150
    53.877   565.410     0.150
    59.527   603.391     0.150
     0.362     7.730     0.150
     0.362    12.461     0.150
     1.116    21.859     0.150
     1.303    25.340     0.150
     1.303    41.551     0.150
     1.380    42.949     0.150
     1.380    26.359     0.150
     1.380    42.949     0.150
     1.535    28.848     0.150
     1.535    49.000     0.150
     1.574    28.898     0.150
     1.574    49.051     0.150
     2.173    38.500     0.150
     2.173    64.738     0.150
     2.351    41.348     0.150
     2.351    71.398     0.150
     2.359    41.141     0.150
     2.359    68.711     0.150
     2.427    43.020     0.150
     2.427    73.699     0.150
     2.425    41.801     0.150
     2.425    70.570     0.150
     2.454    41.980     0.150
     2.454    66.020     0.150
     2.827    47.629     0.150
     2.827    79.188     0.150
     2.873    51.578     0.150
     2.873    88.508     0.150
     2.949    53.000     0.150
     2.949    86.719     0.150
     2.958    42.469     0.150
     3.001    51.367     0.150
     3.001    85.098     0.150
     3.098    92.480     0.150
     3.123    53.188     0.150
     3.123    85.758     0.150
     3.127    89.770     0.150
     3.216    56.559     0.150
     3.216    89.320     0.150
     3.232    88.719     0.150
     3.243    55.898     0.150
     3.243    88.641     0.150
     3.252    52.758     0.150
     3.252    93.609     0.150
     3.256    89.609     0.150
     3.430    58.488     0.150
     3.430    97.758     0.150
     3.625    61.750     0.150
     3.625    97.961     0.150
     3.631    60.840     0.150
     3.631   101.969     0.150
     3.646    60.840     0.150
     3.646   101.238     0.150
     3.665    61.188     0.150
     3.665   106.617     0.150
     3.829    60.891     0.150
     3.829   107.000     0.150
     4.221    66.141     0.150
     4.221   114.289     0.150
     4.287    68.449     0.150
     4.287   121.777     0.150
     4.388    68.711     0.150
     4.388   117.277     0.150
     4.588    72.559     0.150
     4.588   122.449     0.150
     4.706    73.020     0.150
     4.706   129.270     0.150
     4.918    73.777     0.150
     4.918   131.578     0.150
     4.986    79.648     0.150
     4.986   132.910     0.150
     5.174    82.301     0.150
     5.174    82.301     0.150
     5.174   142.129     0.150
     5.173   142.980     0.150
     5.278    81.719     0.150
     5.278   136.641     0.150
     5.367    85.789     0.150
     5.367    85.789     0.150
     5.367   144.367     0.150
     6.160   163.719     0.150
     9.761   178.871     0.150
     9.761   141.391     0.150
    15.703   226.059     0.150
    15.703   287.707     0.150
    83.783   236.008     0.150
    94.003   238.578     0.150
    19.897   273.570     0.150
    23.184   309.000     0.150
    23.287   313.965     0.150
    23.874   318.641     0.150
    24.216   319.328     0.150
    20.320   329.961     0.150
    31.024   380.215     0.150
    43.685   487.215     0.150
    43.685   487.750     0.150
    44.309   492.008     0.150
    50.786   540.848     0.150
     2.406    37.756     0.150
     2.491    43.445     0.150
     3.244    54.916     0.150
     3.250    54.416     0.150
     4.165    57.766     0.150
     4.218    61.787     0.150
     4.283    59.787     0.150
     4.383    64.496     0.150
     5.171    75.926     0.150
     5.171   143.166     0.150
     3.808    52.117     0.150
     3.835    55.758     0.150
    10.861   160.484     0.150
    54.850   566.812     0.150
     3.718    64.531     0.150
     4.209    64.201     0.150
     4.319    66.191     0.150
     4.439    67.201     0.150
     5.196    83.012     0.150
     1.189    33.680     0.150
     2.703    77.344     0.150
     2.854    48.742     0.150
     3.458    60.852     0.150
     3.582    58.930     0.150
     3.468    56.930     0.150
     4.044    64.352     0.150
     4.603    66.453     0.150
     4.673    75.844     0.150
     3.205    49.377     0.150
     3.260    50.648     0.150
     4.365    71.367     0.150
     4.495    65.447     0.150
     4.815    71.648     0.150
     5.078    82.438     0.150
     5.237    85.809     0.150
     0.179     5.500     0.150
     0.179     8.760     0.150
     1.273    23.400     0.150
     1.273    39.130     0.150
     1.365    24.180     0.150
     1.365    42.060     0.150
     1.857    28.900     0.150
     1.857    56.480     0.150
     1.775    29.100     0.150
     1.775    50.370     0.150
     2.123    38.130     0.150
     2.123    65.850     0.150
     2.681    45.070     0.150
     2.681    79.190     0.150
     2.853    44.130     0.150
     2.853    79.630     0.150
     3.118    46.860     0.150
     3.118    89.370     0.150
     3.133    49.530     0.150
     3.133    92.920     0.150
     3.246    52.410     0.150
     3.246    92.230     0.150
     3.548    53.390     0.150
     3.548   103.580     0.150
     3.684    55.480     0.150
     3.684   101.810     0.150
     3.661    60.470     0.150
     3.661   103.190     0.150
     3.945    60.220     0.150
     3.945   106.830     0.150
     4.246   104.360     0.150
     4.553    75.150     0.150
     4.741    75.650     0.150
     5.268   146.130     0.150
     5.971    85.250     0.150
     7.304   102.800     0.150
     7.659   201.390     0.150
     7.659   227.280     0.150
     8.801   218.280     0.150
     9.043   241.020     0.150
     9.845   137.910     0.150
     9.872   148.930     0.150
    11.056   291.060     0.150
    11.087   290.390     0.150
    11.178   283.050     0.150
    61.919   272.020     0.150
    23.240   305.160     0.150
    33.793   324.900     0.150
    33.969   400.960     0.150
    45.033   494.670     0.150
    46.032   500.000     0.150
    52.840   553.810     0.150
    53.339   556.690     0.150
    56.308  4227.812     0.150
    56.317  4229.056     0.150
    61.955   619.620     0.150
    62.135   618.400     0.150
    62.840   625.100     0.150
    80.957   734.531     0.150
    85.448   756.450     0.150
    85.595   757.470     0.150
    91.104   782.571     0.150
    93.081   791.240     0.150
     3.418    58.383     0.150
     3.535    61.773     0.150
     4.341    70.234     0.150
     5.144    75.734     0.150
     5.281   131.465     0.150
     1.469    21.432     0.150
     1.580    25.021     0.150
     1.580    46.531     0.150
     1.732    25.411     0.150
     1.732    25.411     0.150
     1.732    47.582     0.150
     2.368    33.632     0.150
     2.368    33.632     0.150
     2.368    62.401     0.150
     2.215    64.642     0.150
     2.334    70.151     0.150
     2.334    35.082     0.150
     2.334    70.151     0.150
     2.573    38.771     0.150
     2.573    69.882     0.150
     3.011    49.632     0.150
     3.011    88.462     0.150
     3.011    49.632     0.150
     3.011    88.462     0.150
     3.137    47.882     0.150
     3.137    78.691     0.150
     3.078    46.932     0.150
     3.078    84.392     0.150
     3.144    79.812     0.150
     3.144    48.062     0.150
     3.144    79.812     0.150
     3.215    48.611     0.150
     3.215    88.172     0.150
     3.267    52.031     0.150
     3.267    87.682     0.150
     3.467    50.491     0.150
     3.467    96.462     0.150
     3.389    51.812     0.150
     3.389    93.932     0.150
     3.475    52.691     0.150
     3.475    94.741     0.150
     3.587    60.252     0.150
     3.587   101.191     0.150
     3.587    60.252     0.150
     3.587   101.191     0.150
     3.700    53.771     0.150
     3.700    94.111     0.150
     3.598    60.462     0.150
     3.633    52.962     0.150
     3.633    95.922     0.150
     3.650    60.972     0.150
     3.650    60.972     0.150
     3.650   102.582     0.150
     3.667    57.121     0.150
     3.667   103.352     0.150
     3.671    62.292     0.150
     3.671    62.292     0.150
     3.671    99.542     0.150
     3.677    55.611     0.150
     3.677    98.812     0.150
     3.682    56.861     0.150
     3.682   101.792     0.150
     3.692    61.962     0.150
     3.692    61.962     0.150
     3.692    99.972     0.150
     3.696    60.611     0.150
     3.696    60.611     0.150
     3.696   101.682     0.150
     3.702    62.861     0.150
     3.702    62.861     0.150
     3.702    99.972     0.150
     3.758    61.161     0.150
     3.758   105.201     0.150
     3.758    61.161     0.150
     3.758   105.201     0.150
     3.776    63.151     0.150
     3.776    63.151     0.150
     3.776   106.082     0.150
     3.792    62.292     0.150
     3.792    62.292     0.150
     3.792   102.231     0.150
     3.826   110.172     0.150
     3.826    60.491     0.150
     3.826   110.172     0.150
     3.845    61.161     0.150
     3.845   105.382     0.150
     3.936    59.111     0.150
     3.936   105.371     0.150
     3.959    58.102     0.150
     3.959    58.102     0.150
     3.959   105.321     0.150
     3.957    59.632     0.150
     3.982    59.821     0.150
     3.982   106.651     0.150
     4.038    59.951     0.150
     4.038   106.292     0.150
     4.057    60.531     0.150
     4.057   108.052     0.150
     4.068    60.121     0.150
     4.068   108.672     0.150
     4.073    60.752     0.150
     4.073   108.302     0.150
     4.190    62.212     0.150
     4.190   111.882     0.150
     4.244    61.852     0.150
     4.244   113.231     0.150
     4.426    64.991     0.150
     4.426   114.762     0.150
     4.722    67.861     0.150
     4.722    67.861     0.150
     4.722   120.842     0.150
     4.742    67.661     0.150
     4.742    67.661     0.150
     4.742   120.991     0.150
     4.690    68.981     0.150
     4.690   129.991     0.150
     4.837    71.352     0.150
     4.837   124.861     0.150
     5.170    76.852     0.150
     5.170   134.582     0.150
     5.441    79.562     0.150
     5.441   140.832     0.150
     5.741    80.201     0.150
     5.741    80.201     0.150
     5.741   147.712     0.150
     6.086    89.132     0.150
     6.086   160.621     0.150
     6.653    95.552     0.150
     6.653   171.151     0.150
     6.758    94.892     0.150
     6.758    94.892     0.150
     6.758   172.411     0.150
     7.431   108.042     0.150
     7.431   195.401     0.150
     7.773   573.022     0.150
     7.800   580.228     0.150
     7.587   108.102     0.150
     7.587   194.342     0.150
     7.837   578.982     0.150
     7.934   119.672     0.150
     7.934   205.161     0.150
     9.299   246.821     0.150
     9.299   246.821     0.150
     9.432   131.672     0.150
     9.432   131.672     0.150
     9.432   239.071     0.150
     9.920   144.661     0.150
     9.920   258.111     0.150
    11.334   166.951     0.150
    50.685   183.271     0.150
    13.892   196.146     0.150
    13.951   200.731     0.150
    14.078   202.132     0.150
    15.989   219.382     0.150
    17.209   241.651     0.150
    61.535   270.701     0.150
    20.372   270.571     0.150
    20.921   277.231     0.150
    20.952   276.111     0.150
    21.280   283.231     0.150
    22.398   292.161     0.150
    24.468   316.002     0.150
    24.791   316.752     0.150
    25.367   323.052     0.150
    26.079   327.472     0.150
    28.249   353.382     0.150
    31.382   378.462     0.150
    36.677   421.951     0.150
    45.226   491.491     0.150
    48.212   516.602     0.150
    48.382   514.762     0.150
    53.346   552.602     0.150
    53.913   556.472     0.150
    55.974  4208.011     0.150
    55.983  4209.499     0.150
    60.231   603.151     0.150
    81.377   732.582     0.150
    84.030   746.092     0.150
    85.420   753.611     0.150
    85.430   754.252     0.150
    91.021   781.102     0.150
    91.021   781.102     0.150
    92.866   789.002     0.150
   126.165  1138.672     0.150
   126.997  1140.172     0.150
     1.199    20.629     0.150
     1.440    25.729     0.150
     1.523    28.299     0.150
     1.523    49.618     0.150
     2.329    76.799     0.150
     2.569    42.629     0.150
     3.370    52.919     0.150
     3.626    55.979     0.150
     3.626    98.898     0.150
     4.034    60.629     0.150
     3.993    60.818     0.150
     4.067    62.818     0.150
     4.067   109.328     0.150
     4.099    62.719     0.150
     4.099   109.398     0.150
     4.157    64.148     0.150
     4.157    62.818     0.150
     4.227    64.698     0.150
     4.279    64.148     0.150
     4.279   115.309     0.150
     4.288   114.738     0.150
     4.317    65.799     0.150
     4.344    64.849     0.150
     4.344   116.639     0.150
     4.423   117.988     0.150
     4.453    67.618     0.150
     4.453   118.578     0.150
     4.460    70.809     0.150
     4.643    70.788     0.150
     4.643   124.608     0.150
     4.806    72.618     0.150
     4.810   127.929     0.150
     4.821    72.729     0.150
     5.006    74.788     0.150
     5.105    76.578     0.150
     5.105   133.349     0.150
     5.282    78.528     0.150
     5.390    80.318     0.150
     5.542    82.839     0.150
     5.784    84.259     0.150
     6.104    89.889     0.150
     6.104   158.528     0.150
     6.229    91.669     0.150
     6.418    95.238     0.150
     6.686   102.998     0.150
     6.888   107.658     0.150
     8.101   208.028     0.150
    11.756   168.368     0.150
     4.379    73.502     0.150
     4.408    73.473     0.150
     4.402    71.162     0.150
     5.620    92.422     0.150
     5.861    92.422     0.150
     3.547    57.049     0.150
     3.839    60.078     0.150
     4.122    58.309     0.150
     1.402    24.811     0.150
     1.402    43.771     0.150
     3.362    52.361     0.150
     4.257    69.701     0.150
     2.099    59.562     0.150
     3.695    56.195     0.150
     3.695    97.352     0.150
     4.089    71.195     0.150
     4.089    74.234     0.150
     4.342    74.477     0.150
     1.261    22.188     0.150
     1.523    26.227     0.150
     3.645    60.297     0.150
     3.769    49.984     0.150
     1.167    40.523     0.150
     3.103    87.973     0.150
     3.736    63.504     0.150
     3.905    56.684     0.150
     4.323    75.883     0.150
     4.559    74.934     0.150
     4.712    79.453     0.150
     1.902    32.949     0.150
     1.902    57.770     0.150
     2.254    30.852     0.150
     3.251    53.781     0.150
     3.555    50.281     0.150
     3.523   101.160     0.150
     3.612    58.660     0.150
     3.794   106.129     0.150
     4.267    71.461     0.150
     4.633    73.371     0.150
     5.425    76.250     0.150
     5.739    79.711     0.150
     5.944   146.969     0.150
     6.402   175.531     0.150
     6.428   176.941     0.150
     0.323     7.513     0.150
     0.999    31.503     0.150
     1.343    25.443     0.150
     1.484    49.153     0.150
     1.950    33.333     0.150
     1.950    58.553     0.150
     2.169    35.333     0.150
     2.169    58.193     0.150
     2.473    42.683     0.150
     3.154    50.083     0.150
     3.226    51.743     0.150
     3.428    54.913     0.150
     3.428    91.693     0.150
     3.935    62.763     0.150
     3.960   101.343     0.150
     4.003   120.993     0.150
     3.997   106.983     0.150
     4.206   126.573     0.150
     4.313   130.863     0.150
     4.330    70.443     0.150
     4.417    53.083     0.150
     4.417   133.553     0.150
     4.517    63.403     0.150
     4.586    65.633     0.150
     4.558    69.843     0.150
     4.640    95.413     0.150
     4.640   157.083     0.150
     4.722    72.443     0.150
     4.722    72.443     0.150
     4.857    72.043     0.150
     4.858    79.513     0.150
     4.858   142.873     0.150
     4.891    70.863     0.150
     4.891   147.683     0.150
     4.893    71.633     0.150
     5.058    75.863     0.150
     5.588    84.693     0.150
     5.588   146.293     0.150
     5.616    69.803     0.150
     5.616   149.783     0.150
     5.992    94.813     0.150
     5.992   150.933     0.150
     5.984    93.973     0.150
     6.276    87.353     0.150
     6.433    96.123     0.150
     6.598   162.883     0.150
     6.700    84.613     0.150
     7.017   184.243     0.150
     6.917   530.783     0.150
     6.945   533.963     0.150
     7.616   111.553     0.150
     7.745   121.763     0.150
     8.441   119.463     0.150
     8.441   211.623     0.150
     9.647   128.753     0.150
     9.647   261.643     0.150
    13.723   190.033     0.150
    13.723   203.243     0.150
    15.469   226.243     0.150
    16.886   243.143     0.150
    23.883   314.353     0.150
    36.503   426.343     0.150
    44.927   497.233     0.150
    44.927   596.664     0.150
    48.959   531.493     0.150
    32.141   562.354     0.150
    56.496  4246.753     0.150
    56.506  4248.024     0.150
    63.108   628.757     0.150
    66.196   654.993     0.150
    78.637   725.553     0.150
    83.170   748.173     0.150
    83.358   747.733     0.150
    83.424   748.283     0.150
    85.785   759.843     0.150
    86.132     7.870     0.150
    92.119   791.184     0.150
    93.207   794.563     0.150
    94.407   801.604     0.150
    95.444     7.170     0.150
     1.033    30.111     0.150
     1.092    31.711     0.150
     1.759    53.121     0.150
     2.793    48.831     0.150
     3.740    60.401     0.150
     3.816    61.371     0.150
     4.315    72.251     0.150
     1.665    26.648     0.150
     2.694    40.148     0.150
     2.726    41.117     0.150
     3.607    93.926     0.150
     3.893    62.195     0.150
     3.864    65.195     0.150
     3.963    66.668     0.150
     3.955    56.477     0.150
     4.000    60.617     0.150
     4.457    72.227     0.150
     4.623    76.277     0.150
     4.771    76.688     0.150
     1.941    59.848     0.150
     3.297    95.648     0.150
     3.523    99.887     0.150
    12.992    43.676     0.150
    12.992    83.578     0.150
     1.619    44.991     0.150
     2.502    64.491     0.150
     2.592    43.682     0.150
     2.777    71.321     0.150
     2.817    67.281     0.150
     2.993    50.121     0.150
     3.144    71.842     0.150
     7.168    99.815     0.150
    10.597   147.521     0.150
    12.379    36.962     0.150
    24.081   306.121     0.150
    24.716   311.694     0.150
    44.523   479.646     0.150
     1.263    41.646     0.150
     2.193    63.295     0.150
     2.411    69.665     0.150
     3.961    66.885     0.150
    13.055    49.985     0.150
    13.055    87.385     0.150
     1.398    43.516     0.150
     2.429    41.727     0.150
     2.982    15.594     0.150
     2.982    25.117     0.150
     3.026    48.547     0.150
     5.215    78.156     0.150
     5.400    80.156     0.150
    12.922    28.617     0.150
    12.922    45.703     0.150
     1.161    23.195     0.150
     1.161    38.812     0.150
     2.292    34.670     0.150
     3.177    85.641     0.150
     3.778    54.891     0.150
     4.080    66.591     0.150
     4.373    65.281     0.150
    13.015    47.381     0.150
    13.015    75.081     0.150
    13.056    50.932     0.150
    13.056    88.242     0.150
     1.929    29.672     0.150
     1.989    49.980     0.150
     3.219    93.562     0.150
    13.092    39.641     0.150
    13.092    71.082     0.150
     1.654    27.027     0.150
     1.654    41.397     0.150
     2.413    38.998     0.150
    13.042    51.308     0.150
    13.042    91.848     0.150
     0.751  1303.242     0.150
     0.751  1313.773     0.150
     0.753    14.473     0.150
     0.753  1303.352     0.150
     0.753  1313.531     0.150
     0.884  1305.492     0.150
     0.884  1317.730     0.150
     0.947  1307.383     0.150
     0.947  1318.121     0.150
     1.068  1309.070     0.150
     1.068  1324.312     0.150
     1.093  1309.711     0.150
     1.093  1325.004     0.150
     1.124  1310.621     0.150
     1.124  1325.914     0.150
     1.314  1313.004     0.150
     1.314  1331.441     0.150
     1.435  1315.543     0.150
     1.435  1333.613     0.150
     1.875  1320.914     0.150
     1.875  1347.164     0.150
     4.205    64.684     0.150
     4.828    78.891     0.150
     6.478   503.633     0.150
     6.508   506.004     0.150
     9.151   135.711     0.150
    11.798   165.301     0.150
    12.175   170.312     0.150
    51.926   176.711     0.150
    15.157   210.504     0.150
    16.483   235.262     0.150
    18.651   255.203     0.150
    23.682   308.113     0.150
    24.598   322.082     0.150
    26.988   344.832     0.150
    28.821   358.172     0.150
    56.990  4284.184     0.150
    57.000  4280.094     0.150
    83.012  6255.402     0.150
    83.020  6253.992     0.150
    83.031  6251.160     0.150
    83.558  6296.793     0.150
    83.558  6293.613     0.150
    83.573  6298.469     0.150
     1.108  1310.262     0.150
     1.108  1325.852     0.150
    71.584   234.594     0.150
    18.651   254.863     0.150
     0.113     3.078     0.150
     2.699    45.523     0.150
     3.355    55.727     0.150
     3.351    54.484     0.150
    13.897    39.227     0.150
    13.897    67.133     0.150
     0.482    14.453     0.150
     1.125    20.531     0.150
     1.286    40.281     0.150
     1.392    25.344     0.150
    12.990    30.254     0.150
    12.990    52.012     0.150
     1.562    23.477     0.150
     1.562    42.641     0.150
     1.791    48.320     0.150
     2.668    75.734     0.150
     2.570    78.375     0.150
     3.933    56.141     0.150
     4.126    56.547     0.150
     4.215    78.680     0.150
     4.215   124.695     0.150
     4.775    88.180     0.150
     4.775   141.477     0.150
     4.786    69.766     0.150
     4.684    75.539     0.150
     4.945    71.281     0.150
     4.749    76.695     0.150
     7.008   532.547     0.150
    13.376    56.797     0.150
    13.376    92.797     0.150
    23.944   316.359     0.150
    54.807   570.508     0.150
    56.441  4237.383     0.150
    56.450  4244.203     0.150
    63.029   627.109     0.150
    97.105   811.430     0.150
    12.939    30.594     0.150
    12.939    52.352     0.150
     1.054    21.832     0.150
     1.054    37.273     0.150
     3.030    86.884     0.150
    12.117    48.783     0.150
    12.117    86.144     0.150
     0.842    25.215     0.150
     1.274    19.965     0.150
     2.011    34.465     0.150
    13.159    43.074     0.150
    13.159    74.725     0.150
     1.915    33.434     0.150
     1.915    58.184     0.150
     2.465    42.844     0.150
     2.770    40.875     0.150
     2.817    48.414     0.150
     3.607    59.676     0.150
     3.783    67.633     0.150
     3.783   110.363     0.150
    13.252    42.945     0.150
    13.252    83.223     0.150
     0.547    18.914     0.150
     2.793    80.148     0.150
     4.406    64.656     0.150
     5.066   122.219     0.150
     5.066   158.555     0.150
    10.118    65.414     0.150
    10.118   116.438     0.150
    13.961    40.359     0.150
    13.961    63.359     0.150
    15.701   226.086     0.150
    23.837   315.383     0.150
     1.330    39.680     0.150
     2.804    36.375     0.150
    12.541    48.984     0.150
    12.541    84.094     0.150
     1.590    47.343     0.150
     2.398    40.662     0.150
     2.398    70.053     0.150
     3.925    63.923     0.150
     4.248    69.312     0.150
     4.632    73.662     0.150
    12.834    49.022     0.150
    12.834    86.833     0.150
     2.434    62.445     0.150
    13.905    38.457     0.150
    13.905    66.965     0.150
    23.996    18.398     0.150
     1.580    44.395     0.150
     1.759    46.055     0.150
    12.437    37.027     0.150
    12.437    70.387     0.150
     2.542    42.109     0.150
    13.126    49.914     0.150
    13.126    87.797     0.150
     1.079    33.549     0.150
     1.136    33.869     0.150
     1.159    35.338     0.150
     1.297    38.369     0.150
     1.851    27.918     0.150
     1.851    49.238     0.150
     2.444    61.959     0.150
     2.527    64.088     0.150
     2.827    41.088     0.150
     3.082    43.498     0.150
    12.784    32.068     0.150
    12.784    56.668     0.150
     1.120    22.480     0.150
     1.217    23.012     0.150
     1.238    22.480     0.150
    12.896    30.602     0.150
    12.896    52.221     0.150
     2.172    44.275     0.150
     2.955    51.695     0.150
     3.309    47.965     0.150
     3.578    61.875     0.150
     7.009    99.725     0.150
    12.266    39.005     0.150
    12.266    69.075     0.150
     1.575    42.211     0.150
     3.184    51.383     0.150
     3.218    80.281     0.150
     3.623    58.770     0.150
     4.164    59.199     0.150
     5.217   142.973     0.150
     5.511    77.680     0.150
    12.811    43.410     0.150
    12.811    83.492     0.150
     1.048    32.387     0.150
     1.232    38.309     0.150
     1.408    23.988     0.150
     1.408    41.027     0.150
     3.240    81.828     0.150
     3.656    62.355     0.150
    12.890    29.258     0.150
    12.890    49.848     0.150
     2.724    46.851     0.150
    13.123    53.471     0.150
    13.123    92.441     0.150
     0.938    16.790     0.150
     1.192    22.230     0.150
     1.176    26.270     0.150
     1.176    41.840     0.150
     1.537    26.850     0.150
     2.984    46.960     0.150
     3.157    48.600     0.150
     3.311    50.860     0.150
     3.670    52.880     0.150
     3.670    96.810     0.150
     7.625   116.589     0.150
     9.759   147.370     0.150
     9.759   178.745     0.150
    12.946    31.710     0.150
    12.946    53.440     0.150
    23.259   313.070     0.150
    23.865   319.220     0.150
    53.857   566.370     0.150
     1.003    22.722     0.150
     1.415    43.001     0.150
     2.146    61.932     0.150
     2.711    45.791     0.150
    12.974    30.581     0.150
    12.974    52.481     0.150
     1.321    21.082     0.150
     1.855    30.852     0.150
     1.882    55.812     0.150
     1.929    58.074     0.150
     2.971    76.223     0.150
     3.424    42.922     0.150
     3.424   100.543     0.150
     3.654    53.562     0.150
     3.844    61.684     0.150
    12.206    48.043     0.150
    12.206    85.062     0.150
     3.189    54.839     0.150
    13.193    41.889     0.150
    13.193    74.499     0.150
     1.955    56.785     0.150
     4.112    58.686     0.150
    13.256    46.557     0.150
    13.256    81.887     0.150
     1.763   666.195     0.150
     1.763   693.398     0.150
     2.887   649.809     0.150
     2.887   665.309     0.150
     3.458   643.156     0.150
     3.458   655.367     0.150
     3.587   640.988     0.150
     3.587   650.156     0.150
     3.642   638.566     0.150
     3.642   646.336     0.150
     3.901   644.855     0.150
     3.901   656.406     0.150
     4.223   645.117     0.150
     4.223   657.477     0.150
     4.408   639.758     0.150
     4.408   648.078     0.150
     4.455   639.918     0.150
     4.455   648.945     0.150
     4.747   641.758     0.150
     4.747   651.688     0.150
     4.874   654.656     0.150
     4.874   675.094     0.150
    24.213   311.191     0.150
    54.843   562.969     0.150
     2.674    44.316     0.150
     2.674    75.555     0.150
    12.467    81.516     0.150
     1.788    32.141     0.150
     1.788    32.141     0.150
     1.899    33.871     0.150
     1.899    33.871     0.150
     2.041    35.492     0.150
     2.041    67.062     0.150
     2.529    40.672     0.150
     2.724    83.973     0.150
     2.962    49.051     0.150
     3.030    48.523     0.150
     3.142    53.383     0.150
     3.205    53.383     0.150
     3.226    57.363     0.150
     3.226    57.363     0.150
     3.260    54.262     0.150
     3.257    56.031     0.150
     3.306    55.371     0.150
     3.399    57.801     0.150
     3.516    60.812     0.150
     3.642    57.594     0.150
     3.630    58.633     0.150
     3.802    59.391     0.150
     3.809    60.242     0.150
     4.012    64.332     0.150
     4.331    67.293     0.150
     4.387    67.113     0.150
     4.387   119.082     0.150
     4.336    67.691     0.150
     4.449    73.254     0.150
     4.558    74.301     0.150
     4.752    73.254     0.150
     5.020    76.980     0.150
     5.406    81.922     0.150
     8.644    53.211     0.150
     8.644    91.672     0.150
    12.267    54.492     0.150
    12.267    93.414     0.150
    12.774   187.941     0.150
    61.454   272.562     0.150
    23.335   309.211     0.150
    45.553   496.273     0.150
    60.238   606.672     0.150
     3.656    58.512     0.150
    14.207    41.451     0.150
    14.207    73.912     0.150
     0.188     5.889     0.150
     2.187    37.100     0.150
    13.856    41.709     0.150
    13.856    79.459     0.150
     0.557    11.529     0.150
     1.191    39.062     0.150
    13.161    49.453     0.150
    13.161    88.723     0.150
     1.396    25.242     0.150
     1.627    27.869     0.150
     1.954    38.510     0.150
     2.726    70.449     0.150
     1.628    26.629     0.150
     1.628    43.990     0.150
     1.158    16.570     0.150
     1.158    30.734     0.150
     2.514    60.125     0.150
     2.853    84.180     0.150
     3.292    94.555     0.150
     3.343   105.500     0.150
     3.647   108.250     0.150
     3.995   116.570     0.150
     4.141   119.008     0.150
     4.170   120.484     0.150
     4.178   124.219     0.150
     4.194   117.688     0.150
     4.351   123.305     0.150
     4.419   123.359     0.150
     4.483   126.930     0.150
     4.658    27.391     0.150
     4.658    50.055     0.150
     4.610   132.039     0.150
     5.014   136.875     0.150
     5.072   142.391     0.150
     5.397   156.797     0.150
     5.363   157.875     0.150
     5.439   158.805     0.150
     5.506   171.164     0.150
     5.926   165.195     0.150
    12.896    44.727     0.150
    12.896    85.336     0.150
     1.425    22.969     0.150
     1.425    40.148     0.150
     1.516    48.531     0.150
     1.814    32.016     0.150
     2.009    36.352     0.150
     2.403    40.984     0.150
     3.390    51.055     0.150
     3.883    63.461     0.150
     3.913    62.992     0.150
     4.737   151.039     0.150
     4.871    76.109     0.150
    12.612    32.242     0.150
    12.612    55.680     0.150
     2.363    38.626     0.150
     2.867    47.056     0.150
    12.951    47.416     0.150
    12.951    74.206     0.150
     1.011    33.645     0.150
     1.059    35.168     0.150
     2.394    41.938     0.150
     2.435    46.758     0.150
     2.943    78.477     0.150
     3.099    81.797     0.150
     3.126    83.125     0.150
     3.241    50.574     0.150
     3.439    52.566     0.150
    12.887    29.945     0.150
    12.887    51.207     0.150
     0.877    17.730     0.150
     0.877    30.400     0.150
     0.981    19.131     0.150
     0.981    32.721     0.150
     3.955    62.211     0.150
     4.031   103.520     0.150
     4.229    65.340     0.150
     7.250   532.080     0.150
     7.280   538.305     0.150
     8.431   122.811     0.150
     8.610   127.650     0.150
    10.214   149.990     0.150
    10.214   148.080     0.150
    10.719  2357.564     0.150
    11.381   166.791     0.150
    11.717   169.721     0.150
    11.755   171.150     0.150
    11.993   173.023     0.150
    12.493   180.791     0.150
    12.541   180.770     0.150
    13.201   187.186     0.150
    18.323   254.320     0.150
    19.551   268.189     0.150
    19.551   268.152     0.150
    19.551   268.160     0.150
    35.773   272.850     0.150
    20.330   273.109     0.150
    20.418   277.658     0.150
    81.643   294.320     0.150
    22.076   291.104     0.150
    22.162   290.391     0.150
    21.921   299.350     0.150
    22.998   305.604     0.150
    22.998   305.529     0.150
    23.723    17.051     0.150
    23.723  2310.939     0.150
    24.699    16.799     0.150
    24.699  2308.342     0.150
    25.481   324.867     0.150
    61.657   354.465     0.150
    30.530   373.600     0.150
    30.873   374.400     0.150
    32.020   386.090     0.150
    32.020   385.828     0.150
    32.020   385.891     0.150
    32.155   382.516     0.150
    33.089   394.920     0.150
    35.207   411.240     0.150
    36.101   417.359     0.150
    39.612   447.180     0.150
    39.811   450.061     0.150
    44.584  2384.467     0.150
    44.584  2761.314     0.150
    44.584   487.029     0.150
    47.669   514.131     0.150
    48.089   515.779     0.150
    48.957   524.666     0.150
    49.208   527.371     0.150
    50.649   537.680     0.150
    98.077   540.586     0.150
    52.797   554.549     0.150
    52.776   552.020     0.150
    54.522  2805.389     0.150
    54.916   567.375     0.150
    54.916   567.221     0.150
    56.702  4240.557     0.150
    56.711  4242.955     0.150
    56.812   583.090     0.150
    56.921   582.480     0.150
    57.337   584.012     0.150
    58.268   592.990     0.150
    58.854   594.689     0.150
    58.854   594.689     0.150
    58.854   594.689     0.150
    58.854   594.689     0.150
    58.854   594.689     0.150
    58.854   594.689     0.150
    59.857   601.920     0.150
    61.892   616.971     0.150
    63.114   624.766     0.150
    65.924   640.859     0.150
    66.382   647.189     0.150
    66.382   647.279     0.150
    66.909   650.143     0.150
    68.040   657.320     0.150
    68.340   658.461     0.150
    69.361   661.828     0.150
    69.842   669.297     0.150
    73.039   687.490     0.150
    76.978   707.129     0.150
    76.978   708.605     0.150
    76.978    21.711     0.150
    77.437   709.152     0.150
    77.589   712.090     0.150
    77.921  1152.170     0.150
    78.111   723.523     0.150
    78.222   723.344     0.150
    78.395   725.092     0.150
    78.478   725.551     0.150
    78.506   725.707     0.150
    78.510   725.730     0.150
    78.534   725.867     0.150
    78.541   725.896     0.150
    78.552   725.961     0.150
    78.553   725.967     0.150
    78.569   726.055     0.150
    78.595   726.205     0.150
    78.597   725.387     0.150
    78.598   725.340     0.150
    78.598   724.762     0.150
    78.611   723.955     0.150
    78.993   722.668     0.150
    79.368   721.891     0.150
    79.385   719.062     0.150
    79.463   715.576     0.150
    79.828   716.785     0.150
    79.977   726.916     0.150
    80.103   726.852     0.150
    80.093   718.234     0.150
    80.324   719.453     0.150
    80.372   719.695     0.150
    80.490   720.391     0.150
    80.509   720.461     0.150
    80.509   728.371     0.150
    80.509   728.461     0.150
    80.640   721.443     0.150
    80.703   722.258     0.150
    80.761   722.594     0.150
    80.763   722.588     0.150
    80.800   722.039     0.150
    80.823   722.895     0.150
    81.021   733.785     0.150
    80.852   723.051     0.150
    80.957   723.145     0.150
    80.963   722.994     0.150
    80.972   723.689     0.150
    81.035   724.020     0.150
    81.068   723.758     0.150
    81.160   743.182     0.150
    81.301   768.568     0.150
    81.344   788.205     0.150
    81.429   792.756     0.150
    81.567   734.340     0.150
    81.673   816.441     0.150
    81.674   740.291     0.150
    81.713   823.010     0.150
    81.736   824.342     0.150
    81.801   824.613     0.150
    81.807   824.875     0.150
    81.841   736.359     0.150
    81.963   737.303     0.150
    81.963   737.211     0.150
    81.963   737.408     0.150
    81.941   737.551     0.150
    81.966   821.127     0.150
    82.417   738.871     0.150
    82.434   801.537     0.150
    82.531   739.740     0.150
    82.561   738.051     0.150
    82.578   802.318     0.150
    82.641   740.371     0.150
    82.696   740.660     0.150
    82.729   803.064     0.150
    82.773   803.400     0.150
    82.853   741.291     0.150
    83.209   743.551     0.150
    83.345   743.008     0.150
    83.345   743.121     0.150
    83.690   747.291     0.150
    83.735  6308.537     0.150
    83.742  6309.826     0.150
    83.753  6314.881     0.150
    84.285  6351.459     0.150
    84.286  6352.439     0.150
    84.301  6351.307     0.150
    84.655   749.256     0.150
    84.721   748.373     0.150
    84.735   749.180     0.150
    85.016   752.820     0.150
    85.224   752.539     0.150
    85.224   752.430     0.150
    85.252   753.779     0.150
    85.315   751.359     0.150
    85.726   753.844     0.150
    86.325   757.102     0.150
    76.493   768.029     0.150
    88.270   725.373     0.150
    88.900   770.482     0.150
    89.439   773.980     0.150
    89.439   774.008     0.150
    89.439   773.701     0.150
    89.849   774.910     0.150
    90.845   780.340     0.150
    91.909   785.490     0.150
    91.989   785.391     0.150
    92.135   787.410     0.150
    92.075   785.100     0.150
    92.075  1437.660     0.150
    92.521   787.689     0.150
    92.521   787.689     0.150
    92.521   787.689     0.150
    92.521   787.689     0.150
    92.521   787.689     0.150
    92.521   787.689     0.150
    92.521   787.660     0.150
    92.521  1440.990     0.150
    92.674   788.340     0.150
    92.940   787.891     0.150
    92.981   789.590     0.150
    92.981  1443.820     0.150
    93.416   791.891     0.150
    93.416   791.891     0.150
    93.416   791.891     0.150
    93.416   791.891     0.150
    93.416   791.891     0.150
    93.416   791.891     0.150
    93.460   791.883     0.150
    94.099   796.631     0.150
    94.008   794.391     0.150
    94.008   794.391     0.150
    94.008   794.391     0.150
    94.008   794.391     0.150
    94.008   794.391     0.150
    94.008   794.391     0.150
    94.008   794.348     0.150
    94.008   794.291     0.150
    94.040   794.490     0.150
    94.040   794.490     0.150
    94.040   794.490     0.150
    94.040   794.490     0.150
    94.040   794.490     0.150
    94.040   794.490     0.150
    94.040   794.391     0.150
    94.248   795.689     0.150
    94.248   795.689     0.150
    94.248   795.689     0.150
    94.248   795.689     0.150
    94.248   795.689     0.150
    94.248   795.689     0.150
    94.248   794.990     0.150
    94.248   795.631     0.150
    94.381   796.791     0.150
    94.381   796.791     0.150
    94.381   796.791     0.150
    94.381   796.791     0.150
    94.381   796.791     0.150
    94.381   796.791     0.150
    94.412   796.490     0.150
    94.412   796.490     0.150
    94.412   796.490     0.150
    94.412   796.490     0.150
    94.412   796.490     0.150
    94.412   796.490     0.150
    94.412   796.506     0.150
    94.425   794.689     0.150
    94.425  1450.230     0.150
    94.566   797.090     0.150
    94.566   797.090     0.150
    94.566   797.090     0.150
    94.566   797.090     0.150
    94.566   797.090     0.150
    94.566   797.090     0.150
    94.673   796.711     0.150
    94.673  1453.061     0.150
    94.673   796.670     0.150
    94.846   799.391     0.150
    94.846   799.391     0.150
    94.846   799.391     0.150
    94.846   799.391     0.150
    94.846   799.391     0.150
    94.846   799.391     0.150
    94.846   799.480     0.150
    94.908   799.291     0.150
    94.908   799.291     0.150
    94.908   799.291     0.150
    94.908   799.291     0.150
    94.908   799.291     0.150
    95.162   799.020     0.150
    95.162   799.020     0.150
    95.162  1029.301     0.150
    95.313   800.990     0.150
    95.313   800.990     0.150
    95.313   800.990     0.150
    95.313   800.990     0.150
    95.313   800.990     0.150
    95.427   800.990     0.150
    95.427   800.990     0.150
    95.427   800.990     0.150
    95.427   800.990     0.150
    95.427   800.990     0.150
    95.490   802.590     0.150
    95.490   802.590     0.150
    95.490   802.590     0.150
    95.490   802.590     0.150
    95.490   802.590     0.150
    95.566   802.189     0.150
    95.566   802.189     0.150
    95.566   802.189     0.150
    95.566   802.189     0.150
    95.622   803.391     0.150
    95.622   803.391     0.150
    95.622   803.391     0.150
    95.715   803.090     0.150
    95.715   803.090     0.150
    95.715   803.090     0.150
    95.715   803.090     0.150
    95.715   803.090     0.150
    95.748   802.791     0.150
    95.748   802.791     0.150
    95.748   802.791     0.150
    95.748   802.791     0.150
    95.748   802.791     0.150
    95.748   801.689     0.150
    95.826   803.391     0.150
    95.826   803.141     0.150
    95.906   804.000     0.150
    95.906  1034.670     0.150
    95.906  1460.740     0.150
    96.074   804.846     0.150
    96.101   806.090     0.150
    96.101   806.090     0.150
    96.101   806.090     0.150
    96.101   806.090     0.150
    96.101   806.090     0.150
    96.125   801.990     0.150
    96.386   805.189     0.150
    96.386   805.189     0.150
    96.386   805.189     0.150
    96.386   805.189     0.150
    96.386   805.189     0.150
    96.386   804.990     0.150
    96.572   807.291     0.150
    96.572   807.291     0.150
    96.572   807.291     0.150
    96.572   807.291     0.150
    96.599   806.891     0.150
    96.599   806.891     0.150
    96.599   806.891     0.150
    96.599   806.891     0.150
    96.599   806.189     0.150
    96.739   807.533     0.150
    96.687   806.490     0.150
    96.687   806.490     0.150
    96.687   806.490     0.150
    96.687   806.490     0.150
    96.687   806.529     0.150
    96.687   805.791     0.150
    96.921   807.590     0.150
    96.921   807.590     0.150
    96.921   807.590     0.150
    96.921   807.590     0.150
    96.926   808.689     0.150
    96.926   808.689     0.150
    96.926   808.689     0.150
    96.926   808.689     0.150
    96.926   808.689     0.150
    96.926   808.662     0.150
    71.545   808.270     0.150
    97.004   808.291     0.150
    97.004   808.291     0.150
    97.004   808.291     0.150
    97.004   808.291     0.150
    97.004   807.871     0.150
    97.004  1464.689     0.150
    97.084   808.990     0.150
    97.084   808.990     0.150
    97.084   808.990     0.150
    97.084   808.990     0.150
    97.173   810.391     0.150
    97.173   810.391     0.150
    97.173   810.391     0.150
    97.173   810.391     0.150
    97.173   809.689     0.150
    97.867   811.689     0.150
    97.867   811.689     0.150
    97.867   811.689     0.150
    97.867   811.689     0.150
    97.998   815.189     0.150
    97.998   815.189     0.150
    97.998   815.189     0.150
    97.998   815.189     0.150
    97.999   814.291     0.150
    97.999   814.291     0.150
    97.999   814.291     0.150
    97.999   814.291     0.150
    98.802   816.090     0.150
    98.802   816.090     0.150
    98.802   816.090     0.150
    98.802   816.090     0.150
    98.939   817.090     0.150
    98.939   817.090     0.150
    98.939   817.090     0.150
    98.939   817.020     0.150
    99.060   816.166     0.150
    99.323   818.689     0.150
    99.323   818.689     0.150
    99.323   818.689     0.150
    99.323   818.689     0.150
    99.323   818.764     0.150
    99.396  2295.416     0.150
    99.478   819.490     0.150
    99.478   819.490     0.150
    99.478   819.490     0.150
    99.480   819.090     0.150
    99.480   819.090     0.150
    99.480   819.090     0.150
    99.717   820.590     0.150
    99.717   820.590     0.150
    99.717   820.590     0.150
   100.741   824.920     0.150
   101.358   827.990     0.150
   101.358   827.990     0.150
   101.517   828.791     0.150
   101.517   828.791     0.150
   101.517   828.791     0.150
   101.517   828.871     0.150
   101.718   829.484     0.150
   101.718   829.590     0.150
   101.874   726.834     0.150
   102.520   831.689     0.150
   103.348   836.250     0.150
   103.584   837.391     0.150
   107.444  1783.891     0.150
   109.037  1140.391     0.150
   109.440  2276.592     0.150
   111.093  1141.865     0.150
   111.373  1112.090     0.150
   112.602  1114.090     0.150
   112.602  1157.291     0.150
   113.425  1107.090     0.150
   113.452   877.689     0.150
   113.452  1113.090     0.150
   114.750  1108.439     0.150
   114.756  1116.535     0.150
   115.478  1118.189     0.150
   119.350  1156.891     0.150
   121.797  1130.990     0.150
   121.797  2211.689     0.150
   124.680  1140.891     0.150
   125.820  1126.041     0.150
   125.820  1713.865     0.150
   126.705  1130.049     0.150
   126.705  1708.340     0.150
   129.697  1274.990     0.150
   131.744  1287.791     0.150
   126.087  1158.070     0.150
   137.213  1149.891     0.150
   137.213  1319.541     0.150
    15.732  1166.160     0.150
   140.465  1149.783     0.150
   144.714  1174.791     0.150
   154.021  1190.484     0.150
    77.702   713.080     0.150
    10.738   155.723     0.150
    17.227   238.934     0.150
    17.597   242.992     0.150
    19.083   262.973     0.150
    20.400   277.664     0.150
    20.553   275.984     0.150
    20.725   278.562     0.150
    21.214   282.164     0.150
    21.611   287.312     0.150
    21.787   291.312     0.150
    24.417   316.812     0.150
    32.003   385.484     0.150
    32.003   384.734     0.150
    33.073   391.625     0.150
    36.119   417.305     0.150
    52.756   551.785     0.150
    54.176   562.852     0.150
    56.680  4247.391     0.150
    56.690  4246.555     0.150
    58.013   590.012     0.150
    59.949   602.652     0.150
    60.649   607.535     0.150
    60.649   607.602     0.150
    63.093   624.047     0.150
    65.728   639.703     0.150
    66.889   649.703     0.150
    78.230   715.473     0.150
    80.518   725.973     0.150
    81.428   732.094     0.150
    81.677   739.484     0.150
    81.827   735.594     0.150
    82.070   736.125     0.150
    82.209   736.965     0.150
    82.322   737.602     0.150
    82.420   738.102     0.150
    82.450   737.953     0.150
    81.791   738.773     0.150
    82.565   737.152     0.150
    82.829   740.363     0.150
    82.855   740.375     0.150
    82.897   740.844     0.150
    82.907   741.133     0.150
    83.098   742.602     0.150
    89.461   773.582     0.150
    91.931   785.574     0.150
    13.421   185.168     0.150
    14.290   198.375     0.150
    17.733   248.316     0.150
    18.255   253.074     0.150
    18.568   257.297     0.150
    71.587   257.188     0.150
    20.066   268.855     0.150
    21.653   285.035     0.150
    23.744    12.902     0.150
    24.735    12.102     0.150
    30.976   371.555     0.150
    44.621   487.496     0.150
    44.621   487.566     0.150
    48.951   524.172     0.150
    51.374   542.836     0.150
    51.426   542.965     0.150
    52.134   549.098     0.150
    52.779   549.367     0.150
    55.119   567.156     0.150
    56.677  4246.926     0.150
    56.686  4247.934     0.150
    59.542   598.918     0.150
    60.913   610.746     0.150
    66.359   646.516     0.150
    82.117   736.074     0.150
    82.257   736.695     0.150
    82.467   738.316     0.150
    82.467   737.777     0.150
    81.839   738.617     0.150
    82.612   736.875     0.150
    82.877   740.008     0.150
    82.903   740.297     0.150
    82.903   740.086     0.150
    82.955   740.457     0.150
    92.029   788.348     0.150
   125.782  1138.820     0.150
   126.664  1140.246     0.150
     3.985   104.551     0.150
     5.718    80.641     0.150
     6.812    97.051     0.150
    20.482   273.148     0.150
    21.357   284.250     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     1.900    29.848     0.150
     1.900    51.848     0.150
     4.208   111.848     0.150
     5.117   153.848     0.150
     6.738   177.848     0.150
     7.068   105.848     0.150
    13.195   186.848     0.150
    13.327   192.848     0.150
    14.817   206.848     0.150
    14.817   373.848     0.150
    14.940   210.848     0.150
    14.938   212.848     0.150
    15.278   211.848     0.150
    16.292   225.848     0.150
    16.292   409.848     0.150
    16.481   226.848     0.150
    16.481   409.848     0.150
    18.398   249.848     0.150
    18.398   451.848     0.150
    19.795   269.848     0.150
    20.071   272.848     0.150
    20.071   291.848     0.150
    20.071   508.848     0.150
    20.898   278.848     0.150
    20.898   506.848     0.150
    21.231   280.848     0.150
    21.231   514.848     0.150
    21.368   280.848     0.150
    21.639   284.848     0.150
    21.639   518.848     0.150
    21.665   281.848     0.150
    22.766   299.848     0.150
    22.938   296.848     0.150
    22.938   539.848     0.150
    23.017   297.848     0.150
    23.021   301.848     0.150
    23.238   303.848     0.150
    24.321   315.848     0.150
    25.130   572.848     0.150
    24.987   321.848     0.150
    25.215   319.848     0.150
    25.044   321.848     0.150
    25.044   583.848     0.150
    25.477   325.848     0.150
    26.060   326.848     0.150
    26.489   334.848     0.150
    26.459   613.848     0.150
    27.558   338.848     0.150
    27.509   341.848     0.150
    27.509    20.000     0.150
    27.509   396.848     0.150
    28.148   347.848     0.150
    28.148    20.000     0.150
    28.148   400.848     0.150
    28.398   349.848     0.150
    28.398   542.848     0.150
    29.437   355.848     0.150
    29.437    20.000     0.150
    30.503   365.848     0.150
    30.503   663.848     0.150
    30.706   366.848     0.150
    30.561   676.848     0.150
    31.656   378.848     0.150
    31.978   386.848     0.150
    32.081   699.848     0.150
    33.078   391.848     0.150
    33.683   394.848     0.150
    33.683    19.000     0.150
    33.683   706.848     0.150
    33.729   397.848     0.150
    35.483   410.848     0.150
    36.415   416.848     0.150
    36.415    21.000     0.150
    36.415   917.848     0.150
    37.408   761.848     0.150
    41.518   461.848     0.150
    42.078   464.848     0.150
    41.416   467.848     0.150
    45.570   492.848     0.150
    47.165   513.848     0.150
    48.700   525.848     0.150
    54.594   563.848     0.150
    60.712   610.848     0.150
    65.721   637.848     0.150
    71.088   671.848     0.150
    84.185   745.848     0.150
    84.389   746.848     0.150
    84.542   747.848     0.150
    85.209   751.848     0.150
    85.209    20.000     0.150
    85.209  1372.848     0.150
    86.037   951.848     0.150
    86.037  1373.848     0.150
    86.652   756.848     0.150
    86.972   759.848     0.150
    88.367   763.848     0.150
    90.688   776.848     0.150
    90.978   777.848     0.150
   130.466  1145.848     0.150
     4.180    62.094     0.150
     4.180   124.594     0.150
    14.342   200.094     0.150
    14.387   200.594     0.150
    15.176   215.594     0.150
    15.320   213.992     0.150
    15.582   219.094     0.150
    16.673   232.594     0.150
    16.813   429.594     0.150
    17.250   239.594     0.150
    17.250   253.594     0.150
    19.429   260.793     0.150
    20.171   274.293     0.150
    20.429   274.594     0.150
    20.429   517.594     0.150
    21.274   281.594     0.150
    21.274   284.594     0.150
    21.562   283.594     0.150
    21.927   287.594     0.150
    22.454   295.594     0.150
    22.454   549.594     0.150
    22.750   296.594     0.150
    22.750   550.594     0.150
    22.977   302.195     0.150
    23.002   300.992     0.150
    23.150   304.094     0.150
    23.299   300.594     0.150
    23.334   300.594     0.150
    23.334   548.594     0.150
    23.280   305.492     0.150
    23.406   305.695     0.150
    23.406   334.594     0.150
    23.618   308.395     0.150
    23.820   310.293     0.150
    24.681   318.695     0.150
    25.045   319.594     0.150
    25.346   321.594     0.150
    25.359   325.594     0.150
    25.378   322.695     0.150
    25.391   595.594     0.150
    25.391   621.594     0.150
    25.584   326.594     0.150
    25.584   621.594     0.150
    26.122   330.895     0.150
    26.210   332.793     0.150
    26.210   612.594     0.150
    26.859   338.594     0.150
    26.859    10.000     0.150
    27.567   340.793     0.150
    27.567   648.594     0.150
    27.939   345.594     0.150
    27.939    20.000     0.150
    27.939   540.594     0.150
    28.781   353.594     0.150
    28.781   543.594     0.150
    29.175   354.594     0.150
    29.175   668.594     0.150
    29.681   357.895     0.150
    30.959   369.594     0.150
    31.317   373.195     0.150
    32.036   383.793     0.150
    33.886   395.594     0.150
    33.886   482.594     0.150
    33.886   740.594     0.150
    33.886   854.594     0.150
    35.577   412.594     0.150
    36.652   420.094     0.150
    37.496   430.594     0.150
    37.496   513.594     0.150
    37.496   789.594     0.150
    37.496   929.594     0.150
    37.484   427.895     0.150
    39.162   441.395     0.150
    39.176   440.594     0.150
    39.852   447.395     0.150
    40.601   453.395     0.150
    42.276   466.594     0.150
    43.143   473.594     0.150
    44.683   487.594     0.150
    45.843   495.594     0.150
    49.183   523.594     0.150
    49.183   952.594     0.150
    49.952   529.594     0.150
    52.859  1001.594     0.150
    54.986   566.395     0.150
    56.484   574.594     0.150
    58.438   590.594     0.150
    66.079   640.594     0.150
    80.110   726.594     0.150
    80.681   728.594     0.150
    80.681  1337.594     0.150
    80.768   729.594     0.150
    83.343   742.492     0.150
    83.343   748.594     0.150
    83.458   742.594     0.150
    83.458  1360.594     0.150
    83.705   744.594     0.150
    83.705  1376.594     0.150
    84.481   747.594     0.150
    84.859   749.395     0.150
    84.859  1373.594     0.150
    85.369   753.594     0.150
    85.426   753.094     0.150
    85.426  1391.594     0.150
    86.974   758.594     0.150
    87.276   760.594     0.150
    87.276  1393.594     0.150
    87.381   762.992     0.150
    88.201   766.094     0.150
    88.629   768.594     0.150
    88.629  1408.594     0.150
    88.655   766.793     0.150
    89.511   771.594     0.150
    89.584   771.492     0.150
    90.988   778.594     0.150
    90.988  1411.594     0.150
    90.988  1505.594     0.150
    91.225   779.594     0.150
    92.329   783.594     0.150
    92.760   788.094     0.150
    95.950  1559.594     0.150
    97.661   811.594     0.150
    97.929   809.594     0.150
   100.163   824.594     0.150
   126.918  1136.094     0.150
   130.809  1147.895     0.150
   130.809  1355.594     0.150
   133.175  1151.594     0.150
     2.365    62.547     0.150
     3.057    45.945     0.150
     3.776    55.547     0.150
     7.502   110.945     0.150
    13.887   197.547     0.150
    15.235   216.547     0.150
    15.591   219.445     0.150
    16.801   229.148     0.150
    16.837   235.047     0.150
    17.509   243.344     0.150
    18.651   252.547     0.150
    20.057   271.047     0.150
    20.391   276.344     0.150
    20.774   277.547     0.150
    21.403   283.047     0.150
    21.646   284.547     0.150
    22.643   297.445     0.150
    23.127   298.750     0.150
    23.023   302.547     0.150
    23.186   299.945     0.150
    23.275   304.344     0.150
    23.383   306.148     0.150
    23.623   309.148     0.150
    23.626   309.047     0.150
    23.892   311.250     0.150
    23.892   744.547     0.150
    24.596   317.547     0.150
    24.951   320.547     0.150
    24.788   319.047     0.150
    25.023   322.047     0.150
    26.532   335.047     0.150
    26.532   540.547     0.150
    27.174   341.547     0.150
    28.127   348.047     0.150
    28.127   543.547     0.150
    29.027   352.547     0.150
    29.136   354.844     0.150
    29.028   355.250     0.150
    30.798   367.547     0.150
    31.109   371.547     0.150
    33.658   394.547     0.150
    34.980   408.047     0.150
    35.264   407.547     0.150
    35.750   413.547     0.150
    36.346   417.547     0.150
    39.603   448.547     0.150
    44.834   488.547     0.150
    46.205   497.547     0.150
    48.350   519.547     0.150
    48.743   520.547     0.150
    50.090   529.547     0.150
    51.102   535.547     0.150
    55.236   568.148     0.150
    55.236   630.547     0.150
    56.556   575.547     0.150
    58.566   591.547     0.150
    58.577   591.148     0.150
    61.513   611.648     0.150
    66.130   640.547     0.150
    83.299   741.750     0.150
    84.287   747.750     0.150
    84.385   748.047     0.150
    84.681   749.148     0.150
    84.807   749.250     0.150
    85.082   750.648     0.150
    85.202   752.547     0.150
    85.397   752.648     0.150
    87.197   759.750     0.150
    87.517   762.547     0.150
    87.651   763.344     0.150
    88.546   766.445     0.150
    90.638   777.547     0.150
    90.900   777.547     0.150
    91.051   779.547     0.150
    95.599   801.344     0.150
    95.861   802.547     0.150
    95.861    15.000     0.150
    99.113   818.547     0.150
   127.555  1140.945     0.150
   130.814  1148.445     0.150
   133.273  1152.547     0.150
   133.397  1153.547     0.150
   134.033  1153.648     0.150
   139.802  1160.547     0.150
   143.252  1166.547     0.150
     2.783    73.152     0.150
     3.250    95.152     0.150
     3.524    53.152     0.150
     5.642   162.152     0.150
     7.035   104.551     0.150
    12.592   319.152     0.150
    13.411   193.051     0.150
    13.574   192.152     0.150
    15.562   218.152     0.150
    15.562   221.152     0.150
    16.079   226.051     0.150
    16.079   411.152     0.150
    17.059   234.254     0.150
    17.252   241.352     0.150
    17.252   252.152     0.150
    17.252   426.152     0.150
    17.989   249.953     0.150
    17.989   262.152     0.150
    18.859   256.152     0.150
    19.263   264.254     0.150
    20.525   278.652     0.150
    20.525   292.152     0.150
    20.909   283.652     0.150
    21.296   286.152     0.150
    21.296   529.152     0.150
    21.718   286.852     0.150
    21.870   288.352     0.150
    23.075   303.551     0.150
    23.075   557.152     0.150
    23.155   299.754     0.150
    23.330   304.352     0.150
    23.776   311.551     0.150
    24.147   315.551     0.150
    24.147   536.152     0.150
    24.099   315.152     0.150
    24.574   320.152     0.150
    25.027   319.652     0.150
    25.116   323.852     0.150
    25.116   538.152     0.150
    25.303   325.453     0.150
    25.303   538.152     0.150
    25.543   328.152     0.150
    25.543   539.152     0.150
    26.030   332.652     0.150
    26.030   603.152     0.150
    26.253   334.551     0.150
    26.253   541.152     0.150
    26.253   607.152     0.150
    26.318   332.152     0.150
    27.044   342.051     0.150
    27.044    13.102     0.150
    27.044   623.152     0.150
    27.331   340.051     0.150
    27.684   346.551     0.150
    27.684    14.602     0.150
    27.684   543.152     0.150
    28.558   353.652     0.150
    28.558     8.500     0.150
    28.558    13.500     0.150
    28.796   354.254     0.150
    28.796   544.152     0.150
    29.366   362.754     0.150
    29.366    13.398     0.150
    29.499   361.152     0.150
    29.575   359.652     0.150
    30.512   366.953     0.150
    30.883   370.152     0.150
    30.892   379.152     0.150
    30.892   687.152     0.150
    31.134   373.453     0.150
    31.703   380.551     0.150
    31.703   465.152     0.150
    31.703   553.152     0.150
    31.703  1000.152     0.150
    32.457   387.652     0.150
    32.789   391.453     0.150
    33.655   396.152     0.150
    33.655   557.152     0.150
    33.655   717.152     0.150
    34.163   402.652     0.150
    34.695   405.152     0.150
    34.616   406.652     0.150
    34.616   562.152     0.150
    34.616   734.152     0.150
    35.331   409.152     0.150
    35.307   414.152     0.150
    35.307   783.152     0.150
    36.031   416.352     0.150
    36.168   418.754     0.150
    36.521   420.652     0.150
    36.689   422.152     0.150
    37.305   427.953     0.150
    37.932   434.152     0.150
    38.974   441.551     0.150
    39.639   447.152     0.150
    40.065   454.051     0.150
    40.170   457.652     0.150
    40.441   453.953     0.150
    40.500   455.152     0.150
    41.790   464.152     0.150
    43.037   475.152     0.150
    45.233   492.352     0.150
    45.827   497.754     0.150
    45.920   503.953     0.150
    46.525   502.152     0.150
    47.818   518.152     0.150
    47.818   938.152     0.150
    48.261   520.953     0.150
    48.261   608.152     0.150
    49.781   533.453     0.150
    50.479   534.652     0.150
    51.303   539.953     0.150
    52.073   550.551     0.150
    55.708   573.352     0.150
    56.887   579.152     0.150
    58.946   595.852     0.150
    59.266   601.652     0.150
    61.965   615.754     0.150
    66.440   644.152     0.150
    71.743   678.652     0.150
    77.486   713.754     0.150
    80.628   730.453     0.150
    80.647   730.652     0.150
    80.976   733.152     0.150
    81.077   733.152     0.150
    81.077  1341.152     0.150
    81.686   736.152     0.150
    82.797   743.152     0.150
    83.067   743.953     0.150
    83.067    10.199     0.150
    83.511   744.352     0.150
    83.511    12.801     0.150
    83.534   745.152     0.150
    83.534    12.000     0.150
    84.099   747.152     0.150
    84.099  1369.152     0.150
    84.287   750.051     0.150
    84.389   750.551     0.150
    84.515   751.051     0.150
    84.515    11.102     0.150
    84.684   751.852     0.150
    85.009   752.051     0.150
    85.009  1380.152     0.150
    85.214   754.152     0.150
    85.214    10.000     0.150
    85.214  1381.152     0.150
    85.320   754.551     0.150
    85.320    11.602     0.150
    85.626   755.051     0.150
    85.626   757.152     0.150
    86.261   760.352     0.150
    86.261     9.801     0.150
    86.859   763.152     0.150
    86.937    15.199     0.150
    86.937  1406.152     0.150
    86.937  1466.152     0.150
    87.143   762.152     0.150
    87.152   762.652     0.150
    87.371   763.254     0.150
    87.371  1404.152     0.150
    87.516   765.254     0.150
    87.652   765.551     0.150
    87.930   767.652     0.150
    88.053   768.051     0.150
    88.685   769.051     0.150
    88.831   770.152     0.150
    88.977   771.551     0.150
    89.461   774.652     0.150
    89.719   774.051     0.150
    90.053   776.852     0.150
    90.239   778.152     0.150
    90.216   777.953     0.150
    90.451   778.152     0.150
    90.690   780.152     0.150
    90.690     9.000     0.150
    90.690    14.000     0.150
    90.690  1439.152     0.150
    91.063   780.551     0.150
    91.063  1415.152     0.150
    91.063  1515.152     0.150
    91.063  1791.152     0.150
    91.112   782.152     0.150
    92.553   788.852     0.150
    92.637   789.152     0.150
    92.785   790.152     0.150
    94.435   797.352     0.150
    94.715   799.152     0.150
    95.042   800.152     0.150
    95.252   801.254     0.150
    95.480   801.152     0.150
    95.480  1464.152     0.150
    96.056   805.152     0.150
    96.056    13.000     0.150
    98.624   816.152     0.150
    98.918   819.152     0.150
    98.918   830.152     0.150
    99.254   818.152     0.150
   117.852  1125.254     0.150
   126.930  1141.551     0.150
   127.859  1144.051     0.150
   129.516  1147.953     0.150
   131.074  1150.953     0.150
   132.978  1155.152     0.150
   132.978  1298.152     0.150
   133.356  1156.152     0.150
   133.622  1155.152     0.150
   133.622  1363.152     0.150
   133.956  1156.152     0.150
   133.956  1304.152     0.150
   134.491  1156.352     0.150
   137.521  1165.152     0.150
   139.383  1168.152     0.150
   143.562  1169.152     0.150
   148.541  1186.652     0.150
   151.977  1188.652     0.150
     1.693    29.297     0.150
     3.543    54.297     0.150
     5.819    86.797     0.150
     7.240   107.098     0.150
    13.625   194.297     0.150
    15.743   220.797     0.150
    16.789   229.898     0.150
    16.926   236.297     0.150
    17.653   245.098     0.150
    18.612   252.297     0.150
    19.290   259.695     0.150
    20.626   278.598     0.150
    20.968   281.297     0.150
    20.968   284.297     0.150
    20.968   298.297     0.150
    21.470   284.797     0.150
    21.470   551.297     0.150
    21.616   283.898     0.150
    23.002   297.695     0.150
    23.441   307.098     0.150
    23.510   306.398     0.150
    24.043   312.398     0.150
    24.787   319.695     0.150
    24.971   320.695     0.150
    25.214   323.797     0.150
    26.712   337.297     0.150
    26.712   540.297     0.150
    27.197   336.996     0.150
    28.229   349.297     0.150
    28.229    19.000     0.150
    28.480   349.098     0.150
    28.480    20.199     0.150
    28.834   353.695     0.150
    28.834    13.602     0.150
    28.834    19.602     0.150
    31.373   376.496     0.150
    31.373    12.801     0.150
    32.123   384.297     0.150
    32.726   387.898     0.150
    33.828   398.297     0.150
    34.727   406.098     0.150
    34.727    12.199     0.150
    34.727    17.199     0.150
    35.842   414.297     0.150
    35.940   417.297     0.150
    39.731   450.297     0.150
    39.986   451.297     0.150
    41.558   461.195     0.150
    44.912   488.297     0.150
    45.627   494.297     0.150
    46.231   497.996     0.150
    48.131   519.098     0.150
    48.573   522.297     0.150
    50.161   531.297     0.150
    55.372   569.496     0.150
    56.589   575.297     0.150
    57.029   581.297     0.150
    58.631   591.297     0.150
    58.642   591.996     0.150
    84.250   747.898     0.150
    84.468   749.297     0.150
    84.468    18.000     0.150
    84.546   749.496     0.150
    84.766   749.695     0.150
    85.006   750.297     0.150
    85.119   750.297     0.150
    85.119    14.000     0.150
    85.371   754.297     0.150
    86.210   758.398     0.150
    86.210    17.898     0.150
    86.895   759.297     0.150
    87.016   759.695     0.150
    87.142   759.996     0.150
    87.380   762.297     0.150
    87.515   762.797     0.150
    89.480   771.297     0.150
    90.839   777.297     0.150
    92.470   786.297     0.150
    94.878   797.297     0.150
    95.350   800.195     0.150
   126.261  1139.297     0.150
   129.836  1147.098     0.150
   130.805  1148.598     0.150
   143.272  1166.297     0.150
   151.672  1187.297     0.150
     1.670    46.789     0.150
     4.307    64.789     0.150
     4.307    64.789     0.150
     5.386    75.789     0.150
     5.386   132.789     0.150
     6.679    95.789     0.150
     6.679   176.789     0.150
     7.136   104.789     0.150
     8.100   115.789     0.150
     9.636   143.789     0.150
    14.484   202.289     0.150
    14.484   204.789     0.150
    14.655   208.789     0.150
    15.159   384.789     0.150
    15.236   214.590     0.150
    15.236   390.789     0.150
    15.236   215.789     0.150
    16.623   232.590     0.150
    16.623   429.789     0.150
    16.818   231.188     0.150
    17.169   239.590     0.150
    17.169   428.789     0.150
    18.246   253.391     0.150
    18.246   465.789     0.150
    19.457   263.188     0.150
    19.457   499.789     0.150
    19.742   268.789     0.150
    20.080   272.391     0.150
    20.409   272.391     0.150
    20.409   515.789     0.150
    20.321   275.590     0.150
    20.321   513.789     0.150
    21.235   284.789     0.150
    21.568   285.789     0.150
    21.701   285.590     0.150
    22.395   295.590     0.150
    22.945   301.488     0.150
    23.078   302.789     0.150
    23.141   305.289     0.150
    23.171   305.891     0.150
    23.171   332.789     0.150
    23.399   302.590     0.150
    23.338   306.090     0.150
    23.533   308.289     0.150
    24.057   313.789     0.150
    24.148   314.590     0.150
    24.379   312.488     0.150
    24.358   315.891     0.150
    24.358   343.789     0.150
    24.574   318.488     0.150
    25.243   323.789     0.150
    25.284   326.289     0.150
    25.284   364.789     0.150
    25.284   596.789     0.150
    25.304   325.789     0.150
    26.110   331.891     0.150
    26.388   329.590     0.150
    26.477   330.789     0.150
    27.430   340.289     0.150
    27.430   539.789     0.150
    27.638   340.688     0.150
    27.638   630.789     0.150
    28.704   353.789     0.150
    29.221   356.789     0.150
    29.221   410.789     0.150
    29.221   660.789     0.150
    30.821   370.289     0.150
    30.821   428.789     0.150
    30.872   372.789     0.150
    31.381   373.789     0.150
    31.706   379.789     0.150
    31.994   381.789     0.150
    31.985   386.789     0.150
    31.985   700.789     0.150
    32.423   385.789     0.150
    33.000   388.789     0.150
    33.000    11.000     0.150
    33.387   395.789     0.150
    33.619   395.789     0.150
    33.957   397.789     0.150
    33.957   730.789     0.150
    35.492   410.789     0.150
    35.551   412.289     0.150
    35.551   748.789     0.150
    35.551   788.789     0.150
    36.236   417.789     0.150
    36.329   418.789     0.150
    38.874   442.891     0.150
    39.293   446.789     0.150
    39.454   447.391     0.150
    40.076   451.289     0.150
    40.662   454.789     0.150
    40.864   457.090     0.150
    40.838   458.688     0.150
    41.198   465.789     0.150
    41.198   840.789     0.150
    41.523   462.891     0.150
    41.713   461.789     0.150
    44.636   487.789     0.150
    45.884   497.789     0.150
    46.127   497.789     0.150
    46.945   508.891     0.150
    46.945   923.789     0.150
    48.862   523.391     0.150
    48.862   940.789     0.150
    49.305   527.988     0.150
    49.908   528.789     0.150
    50.445   532.789     0.150
    51.176   537.789     0.150
    52.970   554.789     0.150
    52.970  1004.789     0.150
    52.970  1141.789     0.150
    53.107   555.488     0.150
    53.532   558.090     0.150
    53.532  1018.789     0.150
    54.849   567.188     0.150
    54.849   566.789     0.150
    54.907   567.289     0.150
    54.907   629.789     0.150
    54.907   567.090     0.150
    54.907   630.789     0.150
    56.460   575.789     0.150
    58.397   590.789     0.150
    58.408   590.789     0.150
    59.280   598.789     0.150
    61.222   611.289     0.150
    64.653   635.090     0.150
    65.273   639.090     0.150
    65.273    15.699     0.150
    65.273  1163.789     0.150
    66.062   642.789     0.150
    71.428   675.789     0.150
    71.523   678.789     0.150
    74.454  1276.789     0.150
    74.454  1560.789     0.150
    76.744   708.789     0.150
    77.746   712.789     0.150
    77.746   896.789     0.150
    77.746  1312.789     0.150
    80.001   728.789     0.150
    80.001  1332.789     0.150
    80.803   730.891     0.150
    80.803   908.789     0.150
    80.803  1334.789     0.150
    80.822   730.789     0.150
    81.764   734.789     0.150
    81.764   926.789     0.150
    81.764  1344.789     0.150
    81.764  1394.789     0.150
    81.764  1398.789     0.150
    81.764  1664.789     0.150
    81.866   738.789     0.150
    81.866  1355.789     0.150
    81.898   736.789     0.150
    81.898  1350.789     0.150
    82.232   737.789     0.150
    82.473   739.789     0.150
    82.473  1363.789     0.150
    83.120   741.789     0.150
    83.120   743.789     0.150
    83.355   743.188     0.150
    83.393   742.789     0.150
    83.393  1360.789     0.150
    84.576   749.688     0.150
    84.670   750.289     0.150
    84.875   752.289     0.150
    84.967   752.188     0.150
    85.082   752.988     0.150
    85.082   754.789     0.150
    85.232   752.688     0.150
    85.306   752.789     0.150
    85.306  1385.789     0.150
    85.332   755.289     0.150
    85.332    11.500     0.150
    85.434   755.891     0.150
    85.434   960.789     0.150
    85.434  1388.789     0.150
    85.434  1440.789     0.150
    85.455   754.789     0.150
    85.455  1396.789     0.150
    86.207   758.488     0.150
    86.207  1400.789     0.150
    86.207  1446.789     0.150
    86.632   760.789     0.150
    86.632  1400.789     0.150
    86.734  1400.789     0.150
    86.815   761.590     0.150
    86.815   763.789     0.150
    86.815    13.199     0.150
    86.815  1400.789     0.150
    86.986   760.590     0.150
    87.171   967.789     0.150
    87.171  1404.789     0.150
    87.171  1743.789     0.150
    87.299   761.090     0.150
    87.299  1398.789     0.150
    87.441   763.789     0.150
    87.692   764.789     0.150
    87.807   764.988     0.150
    87.938   765.988     0.150
    88.259   768.188     0.150
    88.340   769.789     0.150
    88.364   766.188     0.150
    88.636   769.289     0.150
    88.683   768.789     0.150
    88.683  1407.789     0.150
    88.687   767.789     0.150
    88.687  1407.789     0.150
    89.430   773.789     0.150
    89.602   773.289     0.150
    89.703   773.789     0.150
    89.703  1414.789     0.150
    90.447   779.090     0.150
    90.875   779.789     0.150
    90.875    12.000     0.150
    90.875  1410.789     0.150
    90.875  1424.789     0.150
    90.875  1425.789     0.150
    90.875  1505.789     0.150
    90.875  1808.789     0.150
    91.014   779.789     0.150
    91.014   992.789     0.150
    91.014  1412.789     0.150
    91.014  1424.789     0.150
    91.014  1516.789     0.150
    91.014  1792.789     0.150
    91.014  2036.789     0.150
    91.278   781.789     0.150
    91.278  1416.789     0.150
    91.278  1818.789     0.150
    91.799   785.789     0.150
    91.951   785.789     0.150
    92.711   788.789     0.150
    92.711  1426.789     0.150
    92.711  1441.789     0.150
    92.750   789.789     0.150
    92.815  1424.789     0.150
    94.686   797.789     0.150
    94.686  1023.789     0.150
    94.686  1434.789     0.150
    94.743   799.590     0.150
    94.776   799.289     0.150
    95.231   800.789     0.150
    95.912   803.789     0.150
    95.912  1032.789     0.150
    95.912  1440.789     0.150
    96.201   804.789     0.150
    96.160   804.488     0.150
    96.242   804.789     0.150
    97.711   811.789     0.150
    97.854   811.289     0.150
    99.301   816.789     0.150
   100.042   823.789     0.150
   104.938  1097.188     0.150
   105.215   844.789     0.150
   105.536  1096.789     0.150
   106.292   848.789     0.150
   106.292  1490.789     0.150
   111.367  1112.789     0.150
   114.378  1521.789     0.150
   114.378  1598.789     0.150
   114.378  1760.789     0.150
   114.378  2114.789     0.150
   116.348  1180.789     0.150
   116.348  1534.789     0.150
   116.348  1768.789     0.150
   124.637  1138.891     0.150
   126.952  1140.590     0.150
   130.806  1149.391     0.150
   131.712  1152.988     0.150
   131.712  1286.789     0.150
   133.143  1153.789     0.150
   133.723  1154.789     0.150
   133.934  1156.789     0.150
   133.934  1304.789     0.150
   133.934  1372.789     0.150
   133.987  1303.789     0.150
   134.969  1153.289     0.150
   135.014  1151.789     0.150
   135.515  1157.789     0.150
   137.608  1162.789     0.150
   140.393  1161.789     0.150
   144.299  1170.688     0.150
   147.459  1182.289     0.150
     1.421    44.389     0.150
     2.578    40.389     0.150
     2.578    71.389     0.150
     3.351    52.389     0.150
     4.030    62.889     0.150
     4.039   118.389     0.150
     6.257    90.389     0.150
     6.257   165.389     0.150
    13.143   190.389     0.150
    13.143   336.389     0.150
    14.025   201.389     0.150
    14.187   204.389     0.150
    15.478   216.889     0.150
    15.478   396.389     0.150
    17.070   235.889     0.150
    17.030   239.889     0.150
    17.030   433.389     0.150
    17.276   241.389     0.150
    17.642   246.488     0.150
    18.718   261.488     0.150
    18.718   476.389     0.150
    18.933   258.889     0.150
    18.933   470.389     0.150
    19.099   259.988     0.150
    19.633   264.389     0.150
    20.204   274.889     0.150
    20.815   283.389     0.150
    20.835   282.389     0.150
    21.814   289.389     0.150
    22.822   302.088     0.150
    23.432   304.988     0.150
    23.368   306.588     0.150
    23.535   309.488     0.150
    23.686   312.889     0.150
    24.015   315.289     0.150
    24.402   315.189     0.150
    24.402   577.389     0.150
    24.571   320.588     0.150
    24.660   321.389     0.150
    24.660   539.389     0.150
    24.660   585.389     0.150
    24.709   321.088     0.150
    24.866   322.789     0.150
    25.087   325.488     0.150
    25.295   327.889     0.150
    25.797   332.088     0.150
    25.797   603.389     0.150
    25.797   541.389     0.150
    25.822   332.389     0.150
    26.031   333.488     0.150
    26.576   335.889     0.150
    27.226   345.889     0.150
    27.226   626.389     0.150
    27.263   344.189     0.150
    27.786   345.789     0.150
    27.804   347.488     0.150
    27.804   545.389     0.150
    28.928   358.889     0.150
    29.327   358.389     0.150
    29.170   359.988     0.150
    29.810   362.289     0.150
    29.810   662.389     0.150
    29.970   371.389     0.150
    30.823   372.389     0.150
    31.320   683.389     0.150
    31.439   379.588     0.150
    31.497   385.988     0.150
    31.497   700.389     0.150
    32.158   385.389     0.150
    32.431   389.988     0.150
    32.431   708.389     0.150
    32.833   392.389     0.150
    33.061   390.988     0.150
    33.061     6.400     0.150
    33.061   462.389     0.150
    33.082   394.488     0.150
    33.747   398.389     0.150
    33.963   722.389     0.150
    33.848   401.389     0.150
    34.504   406.389     0.150
    35.203   412.789     0.150
    35.203   492.389     0.150
    35.203   747.389     0.150
    35.567   413.389     0.150
    35.663   418.389     0.150
    35.939   417.389     0.150
    35.920   420.389     0.150
    35.920   756.389     0.150
    35.987   419.389     0.150
    36.338   420.889     0.150
    36.580   422.389     0.150
    37.443   430.389     0.150
    37.584   431.588     0.150
    37.831   436.389     0.150
    38.522   440.289     0.150
    39.296   444.389     0.150
    39.753   452.389     0.150
    40.437   456.588     0.150
    40.709   457.389     0.150
    40.676   462.389     0.150
    40.676   583.389     0.150
    40.676   804.389     0.150
    41.165   460.389     0.150
    41.111   461.488     0.150
    41.899   466.389     0.150
    42.347   471.389     0.150
    43.273   477.389     0.150
    45.035   492.389     0.150
    45.673   500.389     0.150
    45.673   906.389     0.150
    46.009   500.389     0.150
    46.449   502.389     0.150
    46.424   508.189     0.150
    48.340   522.988     0.150
    48.340   610.389     0.150
    48.783   526.088     0.150
    50.298   534.389     0.150
    50.443   534.389     0.150
    51.385   543.389     0.150
    52.453   553.488     0.150
    52.453  1236.389     0.150
    53.432   561.189     0.150
    53.607   561.389     0.150
    53.857   563.189     0.150
    54.015   563.689     0.150
    54.015  1020.389     0.150
    55.318   572.588     0.150
    55.358   572.889     0.150
    55.376   572.488     0.150
    55.376   633.389     0.150
    56.519   581.189     0.150
    56.795   580.389     0.150
    57.027   585.389     0.150
    57.608   592.988     0.150
    57.742   593.389     0.150
    58.779   596.389     0.150
    59.493  1091.389     0.150
    59.681   604.889     0.150
    59.941   606.889     0.150
    60.417   610.789     0.150
    66.378   645.389     0.150
    68.030   659.189     0.150
    68.030  1198.389     0.150
    69.481   667.488     0.150
    70.161   670.389     0.150
    70.161  1224.389     0.150
    71.674   681.088     0.150
    71.718   680.389     0.150
    74.690   701.389     0.150
    74.690  1286.389     0.150
    77.022   712.588     0.150
    80.516   731.389     0.150
    80.874   732.689     0.150
    80.894   733.389     0.150
    81.701   737.889     0.150
    81.701  1377.389     0.150
    81.701  1670.389     0.150
    81.991   740.389     0.150
    82.174   740.389     0.150
    82.174  1361.389     0.150
    82.749   742.389     0.150
    83.249   746.189     0.150
    83.578   747.689     0.150
    83.833   746.389     0.150
    83.833  1367.389     0.150
    84.592   753.289     0.150
    84.677   752.488     0.150
    84.690   754.088     0.150
    84.954   754.389     0.150
    84.954    10.000     0.150
    84.986   755.389     0.150
    85.088   753.789     0.150
    85.185   756.389     0.150
    85.377   755.988     0.150
    85.391   757.389     0.150
    85.391  1390.389     0.150
    85.499   756.389     0.150
    85.499   758.389     0.150
    85.499     8.000     0.150
    85.499  1393.389     0.150
    85.672     7.000     0.150
    85.672  1380.389     0.150
    85.672  1718.389     0.150
    86.451   761.789     0.150
    86.694  1404.389     0.150
    86.695   763.889     0.150
    86.695   767.389     0.150
    86.695     8.500     0.150
    87.026   762.789     0.150
    87.210   763.689     0.150
    87.485   764.789     0.150
    87.822   768.189     0.150
    87.956   769.088     0.150
    88.295   769.389     0.150
    88.295  1400.389     0.150
    88.316   770.889     0.150
    88.327   773.389     0.150
    88.327  1425.389     0.150
    88.572   770.588     0.150
    88.840   770.488     0.150
    88.840  1405.389     0.150
    88.876   772.389     0.150
    89.808   776.189     0.150
    89.973   777.889     0.150
    90.038   777.088     0.150
    90.213   779.889     0.150
    90.213  1434.389     0.150
    90.942   783.389     0.150
    91.190   782.588     0.150
    91.190   786.389     0.150
    91.190  1810.389     0.150
    91.354   783.789     0.150
    92.187   786.389     0.150
    92.782   790.389     0.150
    92.782  1435.389     0.150
    92.811   791.789     0.150
    92.885   792.389     0.150
    93.751   794.389     0.150
    94.996   801.389     0.150
    95.709   804.389     0.150
    95.832   806.189     0.150
    96.288   807.389     0.150
    97.799   814.389     0.150
    98.312   819.289     0.150
    99.362   820.389     0.150
   100.565   827.389     0.150
   100.565  1466.389     0.150
   101.389   831.389     0.150
   101.424   830.389     0.150
   101.424   833.389     0.150
   102.183   832.389     0.150
   102.518   835.389     0.150
   107.979   862.689     0.150
   115.131  1120.389     0.150
   124.173  1140.088     0.150
   125.773  1141.389     0.150
   127.098  1143.389     0.150
   127.803  1144.389     0.150
   129.708  1148.389     0.150
   130.415  1152.389     0.150
   131.079  1152.689     0.150
   131.418  1154.088     0.150
   133.501  1155.389     0.150
   133.586  1156.389     0.150
   133.586  1303.389     0.150
   134.184  1157.588     0.150
   134.492  1158.189     0.150
   134.571  1158.389     0.150
   134.571  1314.389     0.150
   134.571  1373.389     0.150
   137.359  1166.889     0.150
   137.416  1160.389     0.150
   139.992  1163.389     0.150
   141.905  1167.389     0.150
   143.498  1171.389     0.150
   144.674  1174.389     0.150
     1.363    22.719     0.150
     1.433    25.719     0.150
     2.654    42.719     0.150
     2.654    73.719     0.150
     3.446    54.219     0.150
     4.111    67.219     0.150
     4.111   118.719     0.150
     4.121    68.719     0.150
     4.121   120.719     0.150
     6.295    94.219     0.150
     6.883   193.719     0.150
    14.065   201.820     0.150
    15.560   221.719     0.150
    15.560   405.719     0.150
    15.762   221.719     0.150
    15.762   397.719     0.150
    17.159   235.617     0.150
    17.098   239.719     0.150
    17.098   250.719     0.150
    17.098   443.719     0.150
    17.321   242.719     0.150
    17.691   247.219     0.150
    17.691   255.719     0.150
    18.767   258.719     0.150
    19.026   258.719     0.150
    19.727   266.422     0.150
    20.257   277.219     0.150
    20.257   287.719     0.150
    20.861   282.719     0.150
    20.861   518.719     0.150
    21.688   290.219     0.150
    21.688   527.719     0.150
    22.015   290.719     0.150
    22.885   303.219     0.150
    23.529   305.516     0.150
    23.432   307.719     0.150
    23.589   310.516     0.150
    24.060   315.719     0.150
    24.500   317.117     0.150
    24.688   321.422     0.150
    24.897   323.117     0.150
    25.114   325.320     0.150
    25.824   603.719     0.150
    26.670   335.219     0.150
    27.878   347.719     0.150
    27.878   543.719     0.150
    29.424   359.719     0.150
    29.222   547.719     0.150
    29.907   362.820     0.150
    29.907   418.719     0.150
    31.524   386.617     0.150
    32.214   387.719     0.150
    32.214   555.719     0.150
    32.478   389.719     0.150
    32.478   711.719     0.150
    33.843   397.719     0.150
    33.901   402.719     0.150
    34.551   407.719     0.150
    35.270   413.719     0.150
    35.270     9.000     0.150
    35.664   414.719     0.150
    36.005   418.719     0.150
    36.658   423.719     0.150
    36.869   424.516     0.150
    39.807   452.719     0.150
    40.663   463.719     0.150
    40.663   584.719     0.150
    41.993   466.719     0.150
    43.370   478.719     0.150
    46.105   500.719     0.150
    46.531   503.719     0.150
    48.331   523.719     0.150
    48.774   527.117     0.150
    50.540   535.719     0.150
    53.644   561.516     0.150
    53.906   563.516     0.150
    54.060   563.422     0.150
    55.409   573.617     0.150
    55.427   572.719     0.150
    55.427   633.719     0.150
    56.561   580.422     0.150
    58.852   595.719     0.150
    58.863   596.320     0.150
    71.804   681.219     0.150
    77.109   711.719     0.150
    80.972   732.617     0.150
    83.670   748.219     0.150
    84.689   753.320     0.150
    84.787   754.117     0.150
    84.771   752.719     0.150
    85.047   754.719     0.150
    85.047     9.000     0.150
    85.084   755.516     0.150
    85.181   754.016     0.150
    85.473   756.719     0.150
    85.595   758.422     0.150
    86.541   761.422     0.150
    86.787   764.219     0.150
    86.787     8.500     0.150
    87.122   763.422     0.150
    87.312  1401.719     0.150
    87.312  1407.719     0.150
    87.301   764.117     0.150
    87.579   765.320     0.150
    87.919   768.422     0.150
    88.053   769.422     0.150
    88.935   771.719     0.150
    89.901   776.719     0.150
    91.284   783.320     0.150
    92.983   792.219     0.150
   131.167  1153.320     0.150
   133.578  1156.719     0.150
   133.642  1158.719     0.150
   135.148  1160.719     0.150
   144.748  1174.719     0.150
   151.926  1194.219     0.150
     3.525    50.555     0.150
     7.807   111.555     0.150
    10.899   158.055     0.150
    12.376   177.055     0.150
    14.193   202.555     0.150
    15.341   214.555     0.150
    16.647   231.555     0.150
    16.647   436.555     0.150
    18.603   251.352     0.150
    18.603   458.555     0.150
    18.719   258.055     0.150
    19.342   259.055     0.150
    19.824   268.555     0.150
    19.824   286.555     0.150
    20.203   270.352     0.150
    20.489   275.555     0.150
    21.234   284.055     0.150
    21.234   298.555     0.150
    21.483   287.258     0.150
    22.438   539.555     0.150
    23.187   299.656     0.150
    23.154   303.055     0.150
    23.340   305.953     0.150
    23.641   307.055     0.150
    24.511   315.758     0.150
    24.739   318.758     0.150
    25.459   326.055     0.150
    26.257   332.555     0.150
    28.470   353.352     0.150
    28.791   353.453     0.150
    28.791   543.555     0.150
    31.056   372.852     0.150
    31.777   379.555     0.150
    31.709   698.555     0.150
    32.057   382.555     0.150
    32.057   698.555     0.150
    32.449   385.555     0.150
    33.467   395.555     0.150
    35.243   408.758     0.150
    35.555   410.555     0.150
    36.511   416.852     0.150
    39.372   446.555     0.150
    40.802   455.555     0.150
    40.999   463.555     0.150
    40.999  1048.555     0.150
    44.652   486.555     0.150
    46.080   497.555     0.150
    49.023   525.352     0.150
    53.243   554.953     0.150
    53.328   553.555     0.150
    53.642   557.055     0.150
    54.939   565.953     0.150
    54.998   565.555     0.150
    54.998   626.555     0.150
    56.423   574.555     0.150
    59.792   602.555     0.150
    60.214   602.953     0.150
    64.236   630.555     0.150
    65.457   637.555     0.150
    67.549   652.555     0.150
    69.837   667.555     0.150
    71.359   673.555     0.150
    80.629   727.758     0.150
    83.242   741.352     0.150
    83.449   741.555     0.150
    84.358   747.555     0.150
    84.454   747.758     0.150
    84.813   750.352     0.150
    84.813   753.555     0.150
    85.203   751.656     0.150
    85.203    15.898     0.150
    85.331   750.555     0.150
    86.013   756.555     0.150
    86.548   758.555     0.150
    86.548   762.055     0.150
    86.874   758.258     0.150
    87.165   758.852     0.150
    88.242   764.258     0.150
    89.525   772.555     0.150
    99.291   817.852     0.150
   118.376  1121.852     0.150
   125.774  1137.555     0.150
   126.796  1138.453     0.150
   126.787  1139.055     0.150
   126.660  1139.055     0.150
   133.125  1151.555     0.150
   134.716  1155.852     0.150
   143.129  1165.055     0.150
   144.295  1169.555     0.150
   148.124  1180.555     0.150
   151.472  1184.555     0.150
     3.532    53.641     0.150
     4.004    62.141     0.150
     4.011    61.141     0.150
     6.277    91.141     0.150
    10.796   156.141     0.150
    12.600   180.742     0.150
    14.070   198.141     0.150
    15.592   218.742     0.150
    16.901   235.344     0.150
    17.024   446.141     0.150
    18.815   256.039     0.150
    18.815   477.141     0.150
    18.969   259.742     0.150
    19.408   260.039     0.150
    19.546   262.641     0.150
    20.231   274.039     0.150
    20.376   277.344     0.150
    20.724   280.141     0.150
    21.352   286.641     0.150
    21.518   287.844     0.150
    21.729   290.844     0.150
    22.005   288.844     0.150
    22.016   293.539     0.150
    21.998   292.742     0.150
    22.079   294.141     0.150
    22.693   299.344     0.150
    22.982   303.242     0.150
    23.105   302.141     0.150
    23.167   304.641     0.150
    23.339   302.641     0.150
    23.339   569.938     0.150
    23.255   305.844     0.150
    23.408   306.242     0.150
    23.657   309.141     0.150
    23.574   309.742     0.150
    23.654   309.344     0.150
    23.891   312.141     0.150
    23.976   313.539     0.150
    24.311   312.539     0.150
    24.459   317.344     0.150
    24.548   318.242     0.150
    24.751   319.742     0.150
    24.975   322.742     0.150
    25.193   324.539     0.150
    25.184   325.039     0.150
    25.429   326.344     0.150
    25.508   327.344     0.150
    25.584   329.141     0.150
    25.685   328.641     0.150
    25.685   589.141     0.150
    25.697   329.141     0.150
    25.710   331.141     0.150
    26.499   336.438     0.150
    27.104   338.141     0.150
    27.554   342.641     0.150
    28.529   350.344     0.150
    28.497   350.938     0.150
    28.497    11.203     0.150
    28.710   356.344     0.150
    29.045   357.539     0.150
    29.348   359.039     0.150
    29.710   361.844     0.150
    29.710     7.297     0.150
    30.439   372.141     0.150
    31.322   378.141     0.150
    31.466   379.141     0.150
    31.557   383.141     0.150
    32.031   384.141     0.150
    32.423   387.141     0.150
    32.317   386.141     0.150
    32.308   386.938     0.150
    32.597   390.141     0.150
    32.703   388.141     0.150
    33.721   398.141     0.150
    34.381   405.141     0.150
    35.468   411.938     0.150
    35.810   415.438     0.150
    35.950   419.141     0.150
    35.950   761.141     0.150
    36.451   420.344     0.150
    36.674   421.742     0.150
    38.566   441.141     0.150
    38.566   809.141     0.150
    39.719   444.141     0.150
    39.719    15.000     0.150
    39.743   453.141     0.150
    40.449   457.641     0.150
    40.449     9.500     0.150
    41.039   458.641     0.150
    41.135   460.141     0.150
    41.135    14.500     0.150
    44.905   489.938     0.150
    45.902   497.742     0.150
    46.322   501.141     0.150
    46.526   506.242     0.150
    46.526   917.242     0.150
    48.438   520.141     0.150
    48.881   523.641     0.150
    48.881   950.141     0.150
    50.357   532.742     0.150
    51.267   539.141     0.150
    51.415   993.141     0.150
    51.415   993.141     0.150
    52.562   551.641     0.150
    53.019   556.141     0.150
    53.488   558.844     0.150
    53.583   557.938     0.150
    53.893   561.344     0.150
    53.893  1019.141     0.150
    54.716   571.141     0.150
    54.782   572.141     0.150
    55.192   570.039     0.150
    55.251   570.641     0.150
    55.251  1044.141     0.150
    54.934   573.141     0.150
    56.398   578.641     0.150
    56.666   578.039     0.150
    57.356   584.938     0.150
    57.360   586.641     0.150
    57.360     8.500     0.150
    57.360   714.141     0.150
    57.360  1065.141     0.150
    57.360  1082.141     0.150
    57.949   589.344     0.150
    57.679   592.141     0.150
    57.863   595.141     0.150
    58.649   593.141     0.150
    59.375   598.141     0.150
    59.375  1096.141     0.150
    59.551   602.141     0.150
    59.798   603.141     0.150
    60.059   606.641     0.150
    60.465   607.141     0.150
    60.998   609.938     0.150
    61.725   619.141     0.150
    61.725  1113.141     0.150
    61.725  1149.141     0.150
    61.725  1373.141     0.150
    64.063   630.641     0.150
    64.063    15.000     0.150
    64.126   634.141     0.150
    64.126    11.000     0.150
    64.126   668.141     0.150
    64.126  1139.141     0.150
    65.685   641.141     0.150
    66.250   643.438     0.150
    67.801   655.641     0.150
    68.139  1195.141     0.150
    69.419   666.039     0.150
    70.046   667.844     0.150
    70.046    11.297     0.150
    70.046  1218.141     0.150
    70.046  1249.141     0.150
    71.125   675.141     0.150
    71.563   679.141     0.150
    74.722  1279.141     0.150
    76.898   710.539     0.150
    76.898    10.602     0.150
    77.685   714.141     0.150
    78.977   725.242     0.150
    78.977  1326.742     0.150
    79.896   725.141     0.150
    80.143   727.141     0.150
    80.320   728.141     0.150
    80.405   729.141     0.150
    80.795   731.344     0.150
    80.863   731.141     0.150
    81.628   735.141     0.150
    81.628  1354.141     0.150
    81.837   737.141     0.150
    81.837    10.000     0.150
    81.837  1359.141     0.150
    81.837  1395.141     0.150
    81.922   737.039     0.150
    81.922    11.398     0.150
    81.922  1399.438     0.150
    82.036   737.938     0.150
    82.036    18.203     0.150
    82.160   739.141     0.150
    82.160  2043.141     0.150
    82.121   738.641     0.150
    82.640   741.141     0.150
    83.142   744.141     0.150
    83.142    10.000     0.150
    83.142   942.141     0.150
    83.459   744.742     0.150
    83.459   748.141     0.150
    83.704   745.141     0.150
    84.503   751.539     0.150
    84.600   752.242     0.150
    84.834  1389.141     0.150
    84.897   753.539     0.150
    84.895  1390.141     0.150
    84.970   752.938     0.150
    84.970   756.641     0.150
    84.970    10.906     0.150
    85.150   754.141     0.150
    85.318   754.141     0.150
    85.318  1392.141     0.150
    85.359   754.141     0.150
    85.391   754.844     0.150
    85.552   753.641     0.150
    85.552   758.141     0.150
    85.552    10.500     0.150
    85.607   756.844     0.150
    85.765   757.141     0.150
    85.765     7.500     0.150
    85.766   759.938     0.150
    86.597   761.141     0.150
    86.597   960.141     0.150
    86.597  1389.141     0.150
    86.597  1413.141     0.150
    86.597  1449.141     0.150
    86.597  1739.141     0.150
    86.634   762.141     0.150
    86.688   761.141     0.150
    86.688    12.000     0.150
    86.688   968.141     0.150
    86.688  1383.141     0.150
    86.688  1390.141     0.150
    86.688  1418.141     0.150
    86.688  1736.141     0.150
    86.809   762.438     0.150
    86.813   761.539     0.150
    86.931   761.539     0.150
    87.090   761.539     0.150
    87.121   762.641     0.150
    87.121   765.141     0.150
    87.121   968.141     0.150
    87.121  1388.141     0.150
    87.121  1409.141     0.150
    87.156   763.641     0.150
    87.201   763.539     0.150
    87.370   763.141     0.150
    87.370  1406.141     0.150
    87.579   765.641     0.150
    87.733   765.938     0.150
    87.809   967.141     0.150
    87.809  1418.141     0.150
    87.867   766.742     0.150
    88.059   767.539     0.150
    88.218   769.844     0.150
    88.218  1409.141     0.150
    88.220   768.344     0.150
    88.220   769.141     0.150
    88.220   985.141     0.150
    88.233   773.141     0.150
    88.449   770.141     0.150
    88.449  1405.141     0.150
    88.687   771.141     0.150
    88.687   984.141     0.150
    88.729   769.242     0.150
    88.729   772.938     0.150
    88.729  1396.141     0.150
    88.755   771.141     0.150
    89.068   772.141     0.150
    89.134   981.141     0.150
    89.134  1414.141     0.150
    89.351   773.141     0.150
    89.351    11.398     0.150
    89.413   773.641     0.150
    89.439   774.141     0.150
    89.485   773.938     0.150
    89.612   773.641     0.150
    89.612   999.141     0.150
    89.650   775.641     0.150
    89.650    11.000     0.150
    89.650  1437.141     0.150
    89.650  1489.141     0.150
    89.650  1785.141     0.150
    89.830   776.141     0.150
    89.778   776.141     0.150
    90.021   779.141     0.150
    90.021  1430.141     0.150
    90.398   777.938     0.150
    90.535   781.141     0.150
    90.701   779.141     0.150
    90.845   780.641     0.150
    90.845   784.141     0.150
    90.845    11.500     0.150
    90.845  1439.141     0.150
    90.845  1831.141     0.150
    91.076   779.742     0.150
    91.076    11.398     0.150
    91.076  1009.141     0.150
    91.076  1419.141     0.150
    91.076  1439.141     0.150
    91.102   781.641     0.150
    91.106   782.242     0.150
    91.221   782.539     0.150
    91.221   786.539     0.150
    91.255   782.242     0.150
    91.255   785.141     0.150
    91.255    10.898     0.150
    91.255    16.898     0.150
    91.255   997.141     0.150
    91.255  1445.141     0.150
    91.255  1825.141     0.150
    91.272   783.641     0.150
    91.660   780.641     0.150
    91.660    11.500     0.150
    91.989   784.844     0.150
    91.989   788.039     0.150
    91.989    12.297     0.150
    92.206   787.141     0.150
    92.684   789.141     0.150
    92.684  1454.141     0.150
    92.684  1474.141     0.150
    92.715   789.141     0.150
    92.715    12.000     0.150
    92.787   789.438     0.150
    92.787  1449.141     0.150
    92.787  2315.141     0.150
    93.636   792.141     0.150
    93.989   799.344     0.150
    94.629   798.438     0.150
    94.710   798.344     0.150
    94.743   798.344     0.150
    94.743    11.797     0.150
    94.743  1033.141     0.150
    94.743  1454.141     0.150
    94.743  1461.141     0.150
    95.169   799.141     0.150
    95.169   803.141     0.150
    95.169  1033.141     0.150
    95.169  1449.141     0.150
    95.169  1469.141     0.150
    95.199   800.938     0.150
    95.199  1038.141     0.150
    95.607   801.141     0.150
    95.607    10.000     0.150
    95.607  1033.141     0.150
    95.875   805.742     0.150
    95.875    11.695     0.150
    95.875  1469.539     0.150
    95.875  1484.242     0.150
    95.875  1569.539     0.150
    95.996   805.141     0.150
    95.996  1041.141     0.150
    96.067   804.141     0.150
    96.067  1464.141     0.150
    96.052   804.141     0.150
    96.650   807.141     0.150
    96.650    12.000     0.150
    96.650  1047.141     0.150
    96.863   809.242     0.150
    96.866   809.242     0.150
    97.698   811.141     0.150
    97.822   812.539     0.150
    98.188   813.141     0.150
    98.786   817.141     0.150
    99.048   821.141     0.150
    99.350   826.438     0.150
    99.370   818.641     0.150
    99.324  1075.141     0.150
    99.744   822.641     0.150
   100.070  1077.641     0.150
   100.214  1073.141     0.150
   100.465   827.141     0.150
   100.465  1079.141     0.150
   100.465  1468.141     0.150
   100.732   825.141     0.150
   101.291   831.141     0.150
   101.318   829.141     0.150
   101.988   831.141     0.150
   102.386   830.539     0.150
   102.521   831.141     0.150
   104.028   840.141     0.150
   105.143   849.141     0.150
   105.143  1105.141     0.150
   105.330   848.641     0.150
   105.157  1109.141     0.150
   105.860   848.141     0.150
   106.122   852.141     0.150
   106.259   851.141     0.150
   107.804   858.039     0.150
   108.043   859.141     0.150
   108.348   862.141     0.150
   108.882   864.344     0.150
   110.270   864.641     0.150
   112.643  1169.141     0.150
   112.643  1741.141     0.150
   114.967   892.141     0.150
   114.580  1174.141     0.150
   114.580  1529.141     0.150
   114.580  1769.141     0.150
   114.580  1770.141     0.150
   115.226  1184.141     0.150
   114.774  1529.141     0.150
   116.310  1200.141     0.150
   116.310  1545.141     0.150
   116.310  2143.141     0.150
   117.132   902.141     0.150
   117.132  1193.141     0.150
   117.132  1767.141     0.150
   118.683   909.141     0.150
   119.222   909.141     0.150
   119.585  1128.141     0.150
   121.444  1128.141     0.150
   121.692  1128.141     0.150
   123.387  1146.641     0.150
   124.220  1245.039     0.150
   124.380  1139.141     0.150
   124.817   937.141     0.150
   124.817  1149.141     0.150
   124.817  1241.141     0.150
   125.672  1154.141     0.150
   125.672  1247.141     0.150
   125.786  1141.141     0.150
   126.988  1140.938     0.150
   127.490  1143.141     0.150
   130.399  1148.938     0.150
   130.462  1143.844     0.150
   130.462  1361.641     0.150
   130.649  1148.141     0.150
   131.454  1149.141     0.150
   131.512  1150.844     0.150
   132.750  1156.742     0.150
   132.750  1306.141     0.150
   133.745  1154.141     0.150
   133.745  1166.141     0.150
   133.745  1302.141     0.150
   134.092  1155.539     0.150
   134.609  1175.141     0.150
   137.455  1166.141     0.150
   137.707  1154.141     0.150
   138.139  1167.141     0.150
   138.139  1174.141     0.150
   138.761  1156.141     0.150
   138.761  1167.141     0.150
   138.761  1947.141     0.150
   138.867  1168.141     0.150
   139.513  1160.141     0.150
   140.620  1162.141     0.150
   141.956  1173.844     0.150
   144.544  1172.141     0.150
   144.544  1372.539     0.150
   146.378  1177.539     0.150
   146.384  1183.141     0.150
   147.879  1180.641     0.150
   148.372  1183.141     0.150
   151.721  1188.141     0.150
   152.316  1195.141     0.150
   153.443  1205.141     0.150
    12.521   179.801     0.150
    14.821   209.602     0.150
    15.058   213.000     0.150
    15.058   386.500     0.150
    16.478   424.500     0.150
    16.529   232.500     0.150
    16.529   418.500     0.150
    16.863   237.500     0.150
    18.662   259.102     0.150
    18.799   256.500     0.150
    18.799   474.000     0.150
    19.573   264.398     0.150
    19.660   269.301     0.150
    19.746   271.699     0.150
    20.081   274.500     0.150
    20.416   277.602     0.150
    20.709   281.398     0.150
    21.165   285.500     0.150
    21.165   514.500     0.150
    21.392   288.301     0.150
    21.443   288.801     0.150
    22.060   292.199     0.150
    22.278   295.898     0.150
    22.746   297.898     0.150
    22.784   302.500     0.150
    22.927   302.801     0.150
    22.931   305.102     0.150
    23.031   304.500     0.150
    23.200   307.500     0.150
    23.350   307.801     0.150
    23.391   308.699     0.150
    23.574   306.102     0.150
    23.910   313.602     0.150
    24.132   315.602     0.150
    24.336   318.000     0.150
    24.560   316.102     0.150
    24.873   323.699     0.150
    25.047   325.602     0.150
    25.888   332.398     0.150
    28.177   348.602     0.150
    28.541   353.898     0.150
    29.885   414.500     0.150
    29.885   668.500     0.150
    31.302   383.000     0.150
    31.560   381.500     0.150
    31.771   383.000     0.150
    31.851   383.500     0.150
    32.323   387.500     0.150
    32.223   388.500     0.150
    33.231   396.500     0.150
    33.346   396.500     0.150
    33.846   401.500     0.150
    35.416   412.898     0.150
    35.642   412.500     0.150
    35.879   417.500     0.150
    35.879     8.500     0.150
    36.196   419.000     0.150
    36.685   424.500     0.150
    36.685   514.500     0.150
    39.137   447.398     0.150
    39.296   448.500     0.150
    40.088   456.500     0.150
    40.408   457.500     0.150
    40.859   457.801     0.150
    45.013   495.301     0.150
    46.104   500.199     0.150
    47.216   516.500     0.150
    47.216   930.500     0.150
    49.143   527.699     0.150
    49.143   954.500     0.150
    49.586   531.500     0.150
    49.586   960.500     0.150
    51.239   540.500     0.150
    52.485   552.699     0.150
    52.895   555.301     0.150
    53.153   555.602     0.150
    53.345   558.000     0.150
    53.220   560.500     0.150
    54.682   567.500     0.150
    54.739   567.801     0.150
    54.739  1038.500     0.150
    55.829   575.500     0.150
    56.426   576.500     0.150
    56.804   582.398     0.150
    57.432   586.500     0.150
    58.322   592.699     0.150
    59.339   600.500     0.150
    59.339   734.500     0.150
    59.927   605.000     0.150
    60.662   613.500     0.150
    61.141   616.102     0.150
    65.017   638.398     0.150
    66.044   643.102     0.150
    67.269   652.500     0.150
    67.269  1190.500     0.150
    68.798   662.500     0.150
    70.039   669.500     0.150
    71.030   674.602     0.150
    74.159  1282.500     0.150
    76.754   709.602     0.150
    79.486   729.398     0.150
    79.758   727.500     0.150
    79.758  1332.500     0.150
    80.625   730.500     0.150
    80.625  1342.500     0.150
    80.971   732.102     0.150
    81.537   736.500     0.150
    81.537  1352.500     0.150
    81.986   737.602     0.150
    81.986  1348.500     0.150
    82.788   745.500     0.150
    82.788     9.000     0.150
    82.788  1404.500     0.150
    82.788  1688.500     0.150
    83.260   744.500     0.150
    83.260  1364.500     0.150
    83.406   746.301     0.150
    84.756   753.699     0.150
    84.775   753.500     0.150
    84.848   754.301     0.150
    84.932   753.500     0.150
    85.145   755.699     0.150
    85.334   756.500     0.150
    85.429   755.500     0.150
    85.474   757.301     0.150
    85.474   956.500     0.150
    85.474  1382.500     0.150
    85.474  1442.500     0.150
    85.479   756.801     0.150
    85.479    11.699     0.150
    85.479  1383.500     0.150
    85.479  1391.500     0.150
    85.554   759.000     0.150
    85.554  1390.500     0.150
    85.677  1399.500     0.150
    85.878   759.000     0.150
    86.228   761.000     0.150
    86.228   764.000     0.150
    86.506   762.500     0.150
    86.506  1390.500     0.150
    86.787  1400.500     0.150
    86.896  1418.500     0.150
    86.999   762.500     0.150
    87.037   762.500     0.150
    87.037     9.398     0.150
    87.063   765.500     0.150
    87.063   768.500     0.150
    87.082   764.699     0.150
    87.096   763.398     0.150
    87.336  1400.500     0.150
    87.440   766.199     0.150
    87.489   765.898     0.150
    87.498   765.699     0.150
    87.780   767.000     0.150
    87.924   767.500     0.150
    87.987   767.898     0.150
    88.117   768.102     0.150
    88.122   770.500     0.150
    88.312   769.398     0.150
    88.416   773.000     0.150
    88.416   774.500     0.150
    88.416   974.500     0.150
    88.552   773.500     0.150
    88.552  1416.500     0.150
    88.675   773.500     0.150
    88.705   771.000     0.150
    88.786   772.801     0.150
    88.786  1402.500     0.150
    88.810   983.500     0.150
    88.810  1411.500     0.150
    89.257   774.500     0.150
    89.301   774.500     0.150
    89.585   774.398     0.150
    89.585   988.500     0.150
    89.585  1412.500     0.150
    89.646   776.000     0.150
    89.664   776.301     0.150
    89.709   776.500     0.150
    89.870   780.500     0.150
    90.274   778.500     0.150
    90.274   781.102     0.150
    90.896   786.500     0.150
    91.027   783.500     0.150
    91.027  1002.500     0.150
    91.027  1422.500     0.150
    91.027  1518.500     0.150
    91.027  1804.500     0.150
    91.098   784.500     0.150
    91.098   998.500     0.150
    91.098  1418.500     0.150
    91.098  1514.500     0.150
    91.424   783.500     0.150
    91.424   787.500     0.150
    91.424    10.000     0.150
    91.424  1430.500     0.150
    91.424  1516.500     0.150
    92.158     6.801     0.150
    92.860   790.500     0.150
    92.860    11.000     0.150
    92.860  1434.500     0.150
    92.860  1534.500     0.150
    92.905   791.000     0.150
    92.905     9.500     0.150
    92.964   791.500     0.150
    92.964   794.500     0.150
    92.964    11.000     0.150
    92.964  1430.500     0.150
    92.964  1534.500     0.150
    94.896   801.500     0.150
    94.929   801.500     0.150
    95.122   802.000     0.150
    95.360   801.500     0.150
    95.360     8.000     0.150
    95.383   802.500     0.150
    96.268   809.500     0.150
    96.707   808.500     0.150
    96.831     5.000     0.150
    97.026   810.500     0.150
    97.026   812.500     0.150
    97.038   811.500     0.150
    97.850   812.500     0.150
    99.766   824.500     0.150
    99.766  1498.500     0.150
    99.766  1930.500     0.150
    99.920   827.500     0.150
   102.194   835.500     0.150
   105.394   847.301     0.150
   105.394  1108.500     0.150
   105.394  1667.500     0.150
   114.158  1526.500     0.150
   114.158  1598.500     0.150
   114.158  1758.500     0.150
   118.985  1126.699     0.150
   119.290  1132.000     0.150
   121.387  1131.500     0.150
   122.560  1134.500     0.150
   126.051  1139.500     0.150
   126.844  1143.000     0.150
   130.818  1151.199     0.150
   134.186  1376.500     0.150
   137.908  1166.000     0.150
   139.483  1160.500     0.150
   144.226  1172.500     0.150
   147.124  1185.000     0.150
   148.720  1187.000     0.150
   151.419  1189.500     0.150
     2.607    45.547     0.150
    11.367   166.348     0.150
    11.710   169.348     0.150
    12.797   181.449     0.150
    14.916   215.348     0.150
    15.829   222.848     0.150
    15.829   398.348     0.150
    15.935   224.348     0.150
    17.925   247.547     0.150
    17.983   444.348     0.150
    19.679   265.348     0.150
    20.930   279.648     0.150
    20.930   301.148     0.150
    22.055   291.348     0.150
    22.315   292.848     0.150
    22.566   295.848     0.150
    22.794   541.848     0.150
    22.802   298.848     0.150
    22.899   299.949     0.150
    23.689   306.547     0.150
    23.689   530.348     0.150
    24.105   311.348     0.150
    24.636   316.648     0.150
    24.636   532.348     0.150
    24.636   622.348     0.150
    27.448   338.746     0.150
    27.951   343.949     0.150
    30.939   370.348     0.150
    31.225   372.348     0.150
    31.217   374.348     0.150
    31.339   373.547     0.150
    31.630   376.348     0.150
    32.628   386.348     0.150
    34.733   402.949     0.150
    34.842   403.148     0.150
    35.436   408.348     0.150
    36.071   412.848     0.150
    40.072   447.348     0.150
    43.840   478.348     0.150
    45.330   489.348     0.150
    51.927   543.148     0.150
    52.498   545.348     0.150
    52.803   548.348     0.150
    54.099   557.348     0.150
    54.158   558.047     0.150
    55.313   565.746     0.150
    54.991   569.848     0.150
    55.051   570.246     0.150
    55.207   571.547     0.150
    55.273   571.949     0.150
    56.267   572.746     0.150
    57.598   582.348     0.150
    57.963   590.348     0.150
    57.977   591.348     0.150
    58.095   591.348     0.150
    58.154   591.348     0.150
    58.232   592.348     0.150
    64.661   630.348     0.150
    70.224   664.449     0.150
    70.224  1205.348     0.150
    70.224  2345.348     0.150
    84.118   743.746     0.150
    84.613   745.949     0.150
    84.665   746.348     0.150
    84.665   746.949     0.150
    84.665  1362.348     0.150
    86.224   752.348     0.150
    86.545   755.348     0.150
    86.545  1381.348     0.150
    86.559   754.246     0.150
    87.970   760.746     0.150
    88.770  1384.348     0.150
    90.281   773.348     0.150
    90.281  1394.348     0.150
    90.622   774.348     0.150
    91.356   777.746     0.150
    92.059   780.348     0.150
    94.131   791.348     0.150
    96.271   800.848     0.150
   100.753   820.547     0.150
   118.209  1118.348     0.150
   123.390  1131.348     0.150
   130.689  1144.547     0.150
   147.210  1177.848     0.150
   152.787  1192.348     0.150
     7.508   107.773     0.150
    13.726   193.172     0.150
    15.674   223.773     0.150
    15.674   488.273     0.150
    15.945   224.875     0.150
    15.945   408.273     0.150
    17.249   241.570     0.150
    17.376   243.273     0.150
    17.376   446.273     0.150
    19.093   259.375     0.150
    21.062   286.273     0.150
    21.975   291.070     0.150
    21.975   541.273     0.150
    21.975   693.273     0.150
    23.527   304.773     0.150
    23.527   306.672     0.150
    23.527   337.672     0.150
    23.912   314.977     0.150
    23.996   314.273     0.150
    24.244   317.273     0.150
    24.493   315.773     0.150
    24.325   318.570     0.150
    25.094   325.070     0.150
    25.314   327.273     0.150
    26.024   334.273     0.150
    27.492   346.773     0.150
    28.139   350.773     0.150
    29.126   360.875     0.150
    29.053   361.273     0.150
    29.450   360.070     0.150
    30.217   369.375     0.150
    30.153   678.273     0.150
    30.282   373.773     0.150
    31.324   383.273     0.150
    31.324   692.273     0.150
    32.477   386.273     0.150
    32.385   387.273     0.150
    32.661   391.672     0.150
    33.051   393.273     0.150
    34.075   404.273     0.150
    34.734   409.273     0.150
    35.677   414.773     0.150
    35.791   414.273     0.150
    36.781   424.273     0.150
    36.877   424.273     0.150
    39.980   455.273     0.150
    45.251   493.773     0.150
    46.138   501.273     0.150
    46.645   503.273     0.150
    48.370   522.672     0.150
    48.370     6.203     0.150
    48.567   525.273     0.150
    48.567     5.297     0.150
    48.567   947.273     0.150
    50.522   536.273     0.150
    51.528   543.273     0.150
    53.935   563.273     0.150
    53.836   563.375     0.150
    54.245   565.672     0.150
    55.546   574.273     0.150
    55.605   575.273     0.150
    55.787   576.273     0.150
    59.654   603.273     0.150
    60.179   610.070     0.150
    60.818   611.672     0.150
    63.712   631.672     0.150
    66.571   647.273     0.150
    68.154   660.672     0.150
    68.154  1202.273     0.150
    70.315   672.273     0.150
    71.420   678.273     0.150
    71.420  1238.273     0.150
    80.104   729.273     0.150
    80.530   731.273     0.150
    80.686   732.273     0.150
    80.698   733.273     0.150
    80.925   733.273     0.150
    81.001   734.070     0.150
    80.742   733.273     0.150
    80.742  1343.273     0.150
    81.061   734.273     0.150
    81.189   734.273     0.150
    81.753  1348.273     0.150
    84.057   748.773     0.150
    84.057  1368.773     0.150
    84.677   753.172     0.150
    84.777   753.570     0.150
    85.073   755.070     0.150
    85.248   756.070     0.150
    85.603   757.375     0.150
    85.629   759.375     0.150
    85.629     5.898     0.150
    85.841   759.273     0.150
    85.841  1390.273     0.150
    85.835   761.273     0.150
    86.679   764.570     0.150
    86.721   764.570     0.150
    86.797  1408.273     0.150
    86.880   763.273     0.150
    87.176   765.672     0.150
    87.311  1402.273     0.150
    87.373   765.672     0.150
    87.635   766.172     0.150
    87.635  1395.273     0.150
    88.978   773.273     0.150
    88.978  1402.273     0.150
    89.887   778.172     0.150
    89.887  1418.273     0.150
    91.047   783.273     0.150
    91.047   998.273     0.150
    91.047  1422.273     0.150
    91.047  1508.273     0.150
    91.336   785.570     0.150
    91.336  1422.273     0.150
    91.336  1514.273     0.150
    91.463   785.273     0.150
    92.196   788.477     0.150
    92.541   792.273     0.150
    92.914   792.070     0.150
    92.992   792.070     0.150
    97.073   812.273     0.150
    97.073     8.000     0.150
    97.912   815.273     0.150
    99.634   821.273     0.150
   131.258  1153.070     0.150
   133.706  1157.273     0.150
   144.883  1175.273     0.150
   144.883  1183.477     0.150
   145.190  1177.273     0.150
   148.707  1187.273     0.150
   152.056  1192.273     0.150
     3.295    51.008     0.150
     3.295    99.707     0.150
     9.950   145.207     0.150
    13.287   186.008     0.150
    15.503   217.207     0.150
    15.594   217.105     0.150
    16.124   227.008     0.150
    16.124   411.207     0.150
    17.240   241.105     0.150
    17.240   242.008     0.150
    17.568   245.207     0.150
    18.747   254.707     0.150
    18.747   264.707     0.150
    18.756   255.207     0.150
    18.756   465.207     0.150
    19.230   263.105     0.150
    19.427   262.207     0.150
    19.427   282.207     0.150
    20.592   274.406     0.150
    20.763   277.207     0.150
    21.383   287.207     0.150
    21.383   530.207     0.150
    21.602   285.508     0.150
    21.757   288.707     0.150
    21.757   530.207     0.150
    21.995   289.309     0.150
    22.276   292.605     0.150
    22.470   294.008     0.150
    22.881   300.207     0.150
    23.376   305.207     0.150
    23.866   312.406     0.150
    24.235   316.707     0.150
    24.287   315.406     0.150
    24.424   317.207     0.150
    24.563   319.309     0.150
    25.379   326.406     0.150
    25.628   329.207     0.150
    25.734   329.707     0.150
    26.925   337.207     0.150
    27.154   339.508     0.150
    27.222   339.008     0.150
    27.752   348.207     0.150
    28.979   354.906     0.150
    29.165   359.105     0.150
    29.165     8.902     0.150
    30.271   368.809     0.150
    32.473   388.207     0.150
    32.753   390.207     0.150
    33.035   392.707     0.150
    34.185   403.207     0.150
    34.402   404.207     0.150
    36.156   418.207     0.150
    36.358   417.707     0.150
    37.719   434.406     0.150
    39.041   446.207     0.150
    39.041   802.207     0.150
    39.847   447.207     0.150
    40.086   455.207     0.150
    40.063   457.207     0.150
    45.209   493.207     0.150
    45.814   502.207     0.150
    45.814   912.207     0.150
    47.945   516.406     0.150
    48.145   519.707     0.150
    48.145   940.207     0.150
    49.943   530.207     0.150
    52.004   550.207     0.150
    51.834   548.207     0.150
    52.264   552.207     0.150
    53.968   560.207     0.150
    55.289   575.207     0.150
    55.735   574.508     0.150
    55.360   575.605     0.150
    55.508   576.809     0.150
    55.587   577.406     0.150
    56.826   580.008     0.150
    56.745   583.809     0.150
    58.235   595.406     0.150
    58.239   595.707     0.150
    58.370   596.406     0.150
    58.426   596.809     0.150
    58.910   595.207     0.150
    58.511   597.309     0.150
    59.301   598.105     0.150
    59.301  1087.207     0.150
    58.930   599.207     0.150
    59.225   601.207     0.150
    59.518   601.707     0.150
    59.518    10.699     0.150
    59.912   606.707     0.150
    66.368   643.707     0.150
    66.372   646.406     0.150
    67.469   654.207     0.150
    67.469  1190.207     0.150
    68.308   660.207     0.150
    68.308  1198.207     0.150
    68.425  1242.207     0.150
    69.936   669.207     0.150
    69.936  1217.207     0.150
    71.115   673.406     0.150
    71.115  1226.207     0.150
    71.380   677.309     0.150
    76.941   711.207     0.150
    79.593   725.207     0.150
    79.845   727.207     0.150
    80.020   728.207     0.150
    80.173   728.207     0.150
    80.192   728.207     0.150
    80.290   729.207     0.150
    80.412   729.207     0.150
    80.484   730.605     0.150
    80.549   730.207     0.150
    81.013   732.207     0.150
    81.013   732.707     0.150
    81.125   733.605     0.150
    81.125  1336.207     0.150
    81.060   733.707     0.150
    81.060  1342.207     0.150
    81.391   735.605     0.150
    81.391     9.602     0.150
    81.395   734.406     0.150
    81.523    15.000     0.150
    81.523  1351.207     0.150
    81.523  1368.207     0.150
    82.351   739.008     0.150
    82.693   742.207     0.150
    82.693  1359.707     0.150
    82.693   742.707     0.150
    83.398   745.406     0.150
    84.110   748.707     0.150
    84.119   748.309     0.150
    84.100   747.207     0.150
    84.100  1365.707     0.150
    84.212   749.207     0.150
    84.310   750.707     0.150
    84.508   750.605     0.150
    84.813   753.207     0.150
    84.813  1375.207     0.150
    84.813  1720.207     0.150
    84.892   753.309     0.150
    84.892     8.699     0.150
    85.161   753.707     0.150
    85.161    10.199     0.150
    85.174   754.707     0.150
    85.174  1379.207     0.150
    85.157   755.207     0.150
    85.157   756.707     0.150
    85.157    10.000     0.150
    85.194   754.707     0.150
    85.217     9.398     0.150
    85.518  1382.207     0.150
    85.570   762.207     0.150
    86.035   760.309     0.150
    86.058   759.207     0.150
    86.058    11.000     0.150
    86.269    11.000     0.150
    86.269  1390.207     0.150
    86.269  1449.207     0.150
    86.341   760.207     0.150
    86.341  1396.207     0.150
    86.378   760.605     0.150
    86.401   760.207     0.150
    86.735   759.605     0.150
    86.767   763.508     0.150
    86.767  1388.207     0.150
    86.767  1402.207     0.150
    86.822   761.605     0.150
    86.975   763.906     0.150
    86.975     8.000     0.150
    87.030   762.207     0.150
    87.030    10.000     0.150
    87.089   763.207     0.150
    87.089     9.000     0.150
    87.240   764.207     0.150
    87.240     9.000     0.150
    87.244   763.309     0.150
    87.244  1402.207     0.150
    87.338   764.309     0.150
    87.357   765.207     0.150
    87.357     9.000     0.150
    87.475   765.105     0.150
    87.664   765.906     0.150
    87.743   766.707     0.150
    87.743     9.500     0.150
    87.886   768.008     0.150
    87.939   768.207     0.150
    87.939  1412.207     0.150
    88.432  1398.207     0.150
    88.432  1419.207     0.150
    88.546   769.707     0.150
    88.546    10.500     0.150
    88.546  1402.207     0.150
    88.695   771.008     0.150
    89.121   772.809     0.150
    89.289   774.207     0.150
    89.522  1402.207     0.150
    90.163   776.707     0.150
    90.268   778.207     0.150
    90.525   779.707     0.150
    90.525     9.500     0.150
    90.525  1410.207     0.150
    90.525  1438.207     0.150
    90.525  1500.207     0.150
    90.806   781.207     0.150
    90.806     9.000     0.150
    90.932  1414.207     0.150
    90.950   781.309     0.150
    90.950     9.898     0.150
    90.950  1413.207     0.150
    90.950  1506.207     0.150
    91.682   784.406     0.150
    91.682     9.801     0.150
    92.386   788.008     0.150
    92.473   788.707     0.150
    92.473     9.500     0.150
    92.875   791.605     0.150
    93.685   794.207     0.150
    94.262  1021.207     0.150
    94.262  1432.207     0.150
    94.262  1436.207     0.150
    94.384   798.105     0.150
    94.384    10.102     0.150
    94.418   799.207     0.150
    94.543   798.207     0.150
    94.543     9.301     0.150
    94.838   798.207     0.150
    94.838    11.000     0.150
    94.877   798.809     0.150
    95.321   801.207     0.150
    94.856   800.207     0.150
    95.264   801.809     0.150
    95.264    10.000     0.150
    95.579   804.207     0.150
    95.579  1036.207     0.150
    95.579  1440.207     0.150
    95.579  1486.207     0.150
    95.896   804.207     0.150
    96.563   808.207     0.150
    96.563     9.000     0.150
    97.409   812.207     0.150
    98.641   816.008     0.150
    99.428   820.207     0.150
    99.428  1459.707     0.150
   100.111   826.207     0.150
   100.111  1520.207     0.150
   100.951   828.207     0.150
   100.951  1462.207     0.150
   100.951  1613.207     0.150
   101.328   829.207     0.150
   101.194   830.207     0.150
   101.194  1304.207     0.150
   106.288   851.707     0.150
   108.235   861.707     0.150
   115.528  1124.207     0.150
   121.128  1131.207     0.150
   123.301  1134.707     0.150
   123.890  1133.207     0.150
   124.496  1138.207     0.150
   125.062  1139.207     0.150
   126.326  1140.207     0.150
   126.787  1141.207     0.150
   126.537  1141.309     0.150
   127.783  1143.707     0.150
   127.390  1143.008     0.150
   128.449  1143.207     0.150
   128.307  1145.207     0.150
   131.934  1151.809     0.150
   133.568  1155.707     0.150
   133.701  1155.008     0.150
   133.761  1151.207     0.150
   133.761  1156.207     0.150
   134.282  1161.207     0.150
   134.282  1171.207     0.150
   134.507  1157.207     0.150
   136.131  1162.207     0.150
   136.621  1157.207     0.150
   136.607  1157.207     0.150
   139.177  1169.207     0.150
   142.583  1168.207     0.150
   143.488  1170.207     0.150
   144.772  1173.207     0.150
   144.772  1184.309     0.150
   145.094  1174.207     0.150
   145.094  1185.008     0.150
   148.574  1180.207     0.150
   148.726  1184.707     0.150
   149.072  1184.207     0.150
   149.336  1189.207     0.150
   150.160  1189.309     0.150
   151.924  1188.207     0.150
   153.631  1190.207     0.150
     7.337   108.367     0.150
    13.209   185.367     0.150
    14.145   200.969     0.150
    14.465   205.066     0.150
    14.596   212.367     0.150
    15.226   212.469     0.150
    15.226   218.266     0.150
    15.939   222.867     0.150
    16.111   223.566     0.150
    16.884   236.168     0.150
    17.796   247.766     0.150
    18.104   249.367     0.150
    18.326   250.766     0.150
    18.652   254.766     0.150
    18.701   254.969     0.150
    18.834   256.766     0.150
    19.522   268.367     0.150
    20.095   491.367     0.150
    20.497   274.766     0.150
    21.092   281.766     0.150
    21.046   284.367     0.150
    21.182   285.867     0.150
    21.456   288.367     0.150
    22.097   296.566     0.150
    22.362   292.867     0.150
    22.330   296.367     0.150
    22.758   302.867     0.150
    24.054   314.969     0.150
    24.241   312.266     0.150
    24.489   315.668     0.150
    27.527     8.301     0.150
    31.663   379.867     0.150
    31.647   385.367     0.150
    31.736   383.867     0.150
    32.404   388.867     0.150
    32.682   393.367     0.150
    34.008   402.668     0.150
    35.628   413.367     0.150
    36.924   432.367     0.150
    40.956   463.367     0.150
    41.993   473.266     0.150
    47.741   518.367     0.150
    49.897   533.066     0.150
    50.095   535.566     0.150
    50.737   538.367     0.150
    55.861   574.367     0.150
    65.142   639.367     0.150
    70.514   670.766     0.150
    72.658   686.367     0.150
    72.658  1248.367     0.150
   125.093  1139.469     0.150
   145.816  1178.367     0.150
   147.493  1179.367     0.150
   148.645  1183.668     0.150
   150.837  1190.168     0.150
     2.820    44.285     0.150
     2.868    44.285     0.150
     3.283    51.285     0.150
     3.297    88.285     0.150
     3.372    51.785     0.150
     3.528    54.285     0.150
     4.021    60.285     0.150
     5.627    83.285     0.150
     7.019   102.887     0.150
     7.019   181.484     0.150
     9.045   129.285     0.150
    10.109   145.785     0.150
    10.109   255.285     0.150
    12.370   176.785     0.150
    13.058   183.484     0.150
    13.407   190.785     0.150
    13.540   191.984     0.150
    15.799   221.684     0.150
    16.322   224.387     0.150
    16.322   227.785     0.150
    16.735   230.785     0.150
    16.735   233.586     0.150
    16.916   235.285     0.150
    17.272   239.984     0.150
    17.272   249.086     0.150
    18.046   242.484     0.150
    18.189   247.184     0.150
    18.189   261.785     0.150
    18.485   249.984     0.150
    18.485   252.184     0.150
    18.485   264.887     0.150
    18.485   266.785     0.150
    18.485   269.285     0.150
    18.372   252.785     0.150
    18.531   252.285     0.150
    18.716   256.285     0.150
    18.923   255.586     0.150
    18.923   256.984     0.150
    18.923   270.887     0.150
    18.923   274.285     0.150
    19.302   266.586     0.150
    19.850   273.086     0.150
    20.224   272.785     0.150
    20.367   269.785     0.150
    20.246   273.086     0.150
    20.599   277.285     0.150
    21.439   283.285     0.150
    22.182   288.684     0.150
    22.240   288.887     0.150
    23.539   305.684     0.150
    23.513   306.586     0.150
    23.771   304.285     0.150
    23.848   304.285     0.150
    23.925   310.785     0.150
    23.972   309.887     0.150
    24.098   311.484     0.150
    24.242   313.586     0.150
    24.242   532.285     0.150
    24.810   317.586     0.150
    25.096   318.285     0.150
    25.063   320.484     0.150
    25.063   534.285     0.150
    25.353   322.285     0.150
    25.353   584.285     0.150
    25.258   322.785     0.150
    25.317   323.387     0.150
    25.317   535.285     0.150
    25.409   323.785     0.150
    26.025   330.086     0.150
    26.025    21.500     0.150
    26.025   536.887     0.150
    26.025   591.285     0.150
    26.025   620.285     0.150
    26.610   333.086     0.150
    26.717   335.785     0.150
    26.891   334.086     0.150
    26.994   333.484     0.150
    26.994    22.602     0.150
    26.994   385.285     0.150
    27.141   335.586     0.150
    27.146   336.586     0.150
    27.358   337.387     0.150
    27.540   339.086     0.150
    27.434   341.484     0.150
    28.091   345.785     0.150
    28.091    22.500     0.150
    28.091   416.285     0.150
    28.091   540.285     0.150
    28.332   347.887     0.150
    28.839   353.887     0.150
    29.022   356.586     0.150
    29.022    22.699     0.150
    29.945   362.285     0.150
    29.945    23.199     0.150
    30.001   367.285     0.150
    30.673   371.285     0.150
    30.938   376.684     0.150
    31.876   377.785     0.150
    31.804   378.887     0.150
    32.132   382.086     0.150
    32.145   381.785     0.150
    32.503   386.086     0.150
    32.712   387.285     0.150
    32.712    23.000     0.150
    33.541   394.586     0.150
    34.481   402.586     0.150
    34.474   403.285     0.150
    35.833   412.887     0.150
    36.327   417.285     0.150
    37.915   432.785     0.150
    39.759   448.586     0.150
    40.432   451.586     0.150
    40.840   454.785     0.150
    44.888   487.285     0.150
    44.920   488.484     0.150
    45.462   491.285     0.150
    45.462   591.785     0.150
    46.114   501.285     0.150
    48.237   517.285     0.150
    48.437   519.586     0.150
    49.092   522.285     0.150
    53.204   554.285     0.150
    53.642   554.984     0.150
    53.754   557.586     0.150
    54.096   559.184     0.150
    55.408   567.785     0.150
    55.942   572.586     0.150
    56.522   574.285     0.150
    56.522   632.285     0.150
    57.064   583.387     0.150
    57.565   583.285     0.150
    58.111   586.785     0.150
    58.594   590.086     0.150
    58.594    22.898     0.150
    59.043   592.785     0.150
    59.524   599.785     0.150
    60.231   606.184     0.150
    61.360   609.984     0.150
    61.502   613.785     0.150
    62.227   616.484     0.150
    63.400   624.484     0.150
    66.071   639.484     0.150
    66.067   640.387     0.150
    67.981   653.285     0.150
    67.981    23.500     0.150
    67.981  1189.285     0.150
    67.981  1216.285     0.150
    70.843   668.484     0.150
    70.843    24.801     0.150
    70.929   672.285     0.150
    70.929  1220.484     0.150
    70.929  1276.086     0.150
    71.151   672.785     0.150
    76.658   704.387     0.150
    79.400   719.586     0.150
    79.651   722.184     0.150
    79.826   722.484     0.150
    79.981   723.285     0.150
    79.996   724.086     0.150
    80.097   723.887     0.150
    80.220   724.586     0.150
    80.294   725.086     0.150
    80.356   725.586     0.150
    80.527   726.285     0.150
    80.711   726.285     0.150
    80.711    24.000     0.150
    80.711  1330.285     0.150
    80.748   728.285     0.150
    80.748    24.000     0.150
    80.748  1335.285     0.150
    81.437   733.184     0.150
    81.437  1346.285     0.150
    82.172   736.387     0.150
    82.370   735.484     0.150
    82.370    23.801     0.150
    82.370  1351.285     0.150
    82.370  1375.285     0.150
    82.708   737.285     0.150
    83.137   740.285     0.150
    83.774   742.285     0.150
    83.774    23.000     0.150
    83.774  1359.285     0.150
    83.949   744.887     0.150
    83.961   744.984     0.150
    84.050   745.586     0.150
    84.235   746.785     0.150
    84.346   746.887     0.150
    84.636   747.887     0.150
    84.929   751.086     0.150
    84.955   748.887     0.150
    84.994   748.887     0.150
    85.041   750.285     0.150
    85.251   750.785     0.150
    85.251    18.301     0.150
    85.251  1371.285     0.150
    85.934   755.887     0.150
    85.977   754.785     0.150
    85.977   755.785     0.150
    86.233   755.484     0.150
    86.248   755.586     0.150
    86.510   755.785     0.150
    86.592   757.785     0.150
    86.602   756.887     0.150
    86.624   757.387     0.150
    86.668   757.285     0.150
    86.680   757.785     0.150
    86.769   756.586     0.150
    86.769    17.500     0.150
    86.935   758.484     0.150
    86.999   758.184     0.150
    87.041   760.086     0.150
    87.060   760.285     0.150
    87.107   759.387     0.150
    87.179   759.684     0.150
    87.192   759.086     0.150
    87.193   761.285     0.150
    87.220   760.387     0.150
    87.220   761.785     0.150
    87.314   760.586     0.150
    87.505   761.086     0.150
    87.558   760.785     0.150
    87.614   762.285     0.150
    88.317   764.086     0.150
    88.508   768.285     0.150
    88.527   765.984     0.150
    88.763   766.785     0.150
    88.872   767.387     0.150
    88.904   767.684     0.150
    89.268   768.984     0.150
    89.268  1419.285     0.150
    89.268  1447.285     0.150
    89.995   772.785     0.150
    89.941   772.484     0.150
    90.234   774.285     0.150
    90.338   775.285     0.150
    90.591   776.984     0.150
    90.692   775.785     0.150
    90.758   777.086     0.150
    91.491   780.184     0.150
    92.182   783.785     0.150
    92.203   783.285     0.150
    92.203    24.000     0.150
    92.285   783.785     0.150
    93.264   787.285     0.150
    94.200   792.785     0.150
    94.233   793.285     0.150
    94.655   794.387     0.150
    94.655    26.898     0.150
    94.674   795.684     0.150
    95.124   796.285     0.150
    95.328   798.285     0.150
    96.370   802.887     0.150
    96.370    23.398     0.150
    97.212   806.285     0.150
    98.314   810.785     0.150
    98.995   813.785     0.150
   100.899   825.285     0.150
   100.899  1483.285     0.150
   120.156  1126.785     0.150
   121.023  1127.285     0.150
   122.821  1131.285     0.150
   123.040  1131.285     0.150
   124.200  1133.285     0.150
   126.492  1138.484     0.150
   126.492  1157.184     0.150
   126.509  1138.684     0.150
   127.489  1140.285     0.150
   127.370  1139.285     0.150
   127.702  1140.086     0.150
   127.702  1338.285     0.150
   128.151  1140.586     0.150
   129.862  1144.285     0.150
   130.700  1146.586     0.150
   133.261  1150.484     0.150
   133.926  1149.285     0.150
   136.777  1153.285     0.150
   138.807  1155.785     0.150
   139.303  1154.285     0.150
   143.193  1165.285     0.150
   143.259  1168.285     0.150
   143.259  1195.285     0.150
   144.461  1168.785     0.150
   144.256  1169.887     0.150
   147.533  1179.086     0.150
   148.266  1177.684     0.150
   148.529  1182.285     0.150
   149.983  1185.785     0.150
   150.315  1180.785     0.150
   151.349  1188.484     0.150
   151.616  1188.285     0.150
   151.793  1190.387     0.150
     1.537    27.477     0.150
     2.613    41.477     0.150
     2.613    69.477     0.150
     3.449    52.977     0.150
     3.455    53.477     0.150
     3.910    60.977     0.150
     3.915    60.477     0.150
     3.925    60.477     0.150
     4.003    60.477     0.150
     4.154    63.477     0.150
     4.635    70.477     0.150
     6.123    91.477     0.150
     6.142    91.477     0.150
     7.516   108.977     0.150
     9.584   138.477     0.150
    10.630   153.977     0.150
    12.589   181.078     0.150
    15.495   216.477     0.150
    15.495   220.477     0.150
    15.794   222.277     0.150
    17.078   237.477     0.150
    17.078   441.477     0.150
    18.277   253.477     0.150
    19.394   262.477     0.150
    21.652   288.977     0.150
    21.564   289.477     0.150
    21.756   290.977     0.150
    22.212   295.477     0.150
    22.733   296.977     0.150
    23.602   309.875     0.150
    23.786   312.477     0.150
    23.864   311.977     0.150
    24.094   314.977     0.150
    24.184   316.375     0.150
    24.184   535.477     0.150
    24.340   312.676     0.150
    24.442   313.477     0.150
    24.961   322.477     0.150
    24.961   537.477     0.150
    25.129   324.477     0.150
    25.186   325.078     0.150
    25.397   326.676     0.150
    25.896   331.078     0.150
    27.422   341.676     0.150
    27.464   341.277     0.150
    27.354   344.676     0.150
    27.500   341.977     0.150
    27.574   342.375     0.150
    27.605   342.375     0.150
    27.667   343.078     0.150
    27.676   343.176     0.150
    27.890   344.977     0.150
    27.982   345.676     0.150
    28.070   346.777     0.150
    28.004   348.375     0.150
    28.004   543.477     0.150
    28.546   352.477     0.150
    28.920   359.477     0.150
    29.284   359.375     0.150
    29.759   362.078     0.150
    30.052   366.676     0.150
    30.724   370.777     0.150
    31.052   372.176     0.150
    31.098   372.875     0.150
    34.496   404.777     0.150
    35.076   409.875     0.150
    35.516   411.477     0.150
    36.604   422.477     0.150
    36.718   422.477     0.150
    39.873   449.578     0.150
    41.176   461.078     0.150
    45.079   491.977     0.150
    45.970   498.477     0.150
    48.471   523.176     0.150
    50.374   533.477     0.150
    53.696   560.777     0.150
    53.769   558.477     0.150
    53.769    15.000     0.150
    54.095   562.875     0.150
    54.095     8.703     0.150
    54.746   571.277     0.150
    54.814   571.477     0.150
    54.965   572.777     0.150
    55.041   573.277     0.150
    55.449   572.078     0.150
    55.449   571.578     0.150
    55.449   633.578     0.150
    56.121   580.977     0.150
    56.816   579.477     0.150
    56.816   637.477     0.150
    57.150   586.676     0.150
    57.700   591.977     0.150
    57.705   592.578     0.150
    57.890   593.578     0.150
    57.973   594.078     0.150
    58.816   594.977     0.150
    59.590   603.477     0.150
    59.851   605.477     0.150
    59.893   605.477     0.150
    61.521   616.977     0.150
    66.392   644.977     0.150
    66.884   651.477     0.150
    66.884    11.000     0.150
    71.242   675.477     0.150
    80.526   730.176     0.150
    80.536   730.977     0.150
    80.641   730.777     0.150
    80.765   731.777     0.150
    80.841   731.875     0.150
    80.900   732.578     0.150
    83.273   745.977     0.150
    83.565   746.477     0.150
    84.527   751.277     0.150
    84.527     9.500     0.150
    84.540   751.078     0.150
    84.540     9.500     0.150
    84.625   751.676     0.150
    84.625     9.902     0.150
    84.860   753.977     0.150
    84.860     9.000     0.150
    84.922   753.477     0.150
    84.922     9.500     0.150
    85.072   754.875     0.150
    85.309   755.977     0.150
    85.461   755.875     0.150
    85.625   756.777     0.150
    85.625     9.500     0.150
    86.134     9.500     0.150
    86.601   762.477     0.150
    86.601    10.000     0.150
    86.822   761.977     0.150
    86.822    10.000     0.150
    86.831   761.777     0.150
    86.831     9.500     0.150
    87.006   761.875     0.150
    86.996   763.676     0.150
    87.155   764.176     0.150
    87.189   763.477     0.150
    87.189    10.000     0.150
    87.196   762.777     0.150
    87.196     9.500     0.150
    87.214   763.676     0.150
    87.251   763.676     0.150
    87.251     9.500     0.150
    87.276   764.375     0.150
    87.462   763.676     0.150
    87.462     9.699     0.150
    87.518   764.977     0.150
    87.518     9.500     0.150
    87.593   765.477     0.150
    87.593    10.000     0.150
    87.618   766.477     0.150
    87.618     9.000     0.150
    87.642   766.977     0.150
    87.757   765.977     0.150
    87.757     9.500     0.150
    87.771   765.578     0.150
    87.771     9.797     0.150
    87.816   767.277     0.150
    87.891   766.676     0.150
    87.891     9.500     0.150
    88.082   766.676     0.150
    88.082     9.500     0.150
    88.138   767.477     0.150
    88.138     9.801     0.150
    88.807   769.977     0.150
    89.098   772.176     0.150
    89.321   774.176     0.150
    89.443   773.676     0.150
    89.471   773.875     0.150
    89.711   774.578     0.150
    89.711    10.000     0.150
    90.888   780.477     0.150
    90.888     8.000     0.150
    91.147   783.078     0.150
    91.164   781.676     0.150
    91.200   782.777     0.150
    91.303   782.477     0.150
    92.036   786.477     0.150
    92.036     9.000     0.150
    92.357   787.977     0.150
    92.756   790.477     0.150
    92.832   790.477     0.150
    92.832     9.000     0.150
    94.752   798.578     0.150
    95.210   801.477     0.150
    95.225   802.477     0.150
    95.660   802.477     0.150
    95.933   804.777     0.150
    96.694   808.477     0.150
    96.694     9.000     0.150
    96.912   809.676     0.150
   120.537  1129.477     0.150
   125.878  1141.375     0.150
   137.951  1158.176     0.150
   138.726  1157.477     0.150
   143.513  1170.078     0.150
   143.886  1177.477     0.150
   144.707  1173.477     0.150
   144.707  1187.977     0.150
   147.222  1182.977     0.150
   148.531  1181.477     0.150
   149.755  1190.078     0.150
   150.070  1184.277     0.150
   151.037  1185.477     0.150
   151.880  1188.477     0.150
   152.332  1196.375     0.150
     2.253    37.197     0.150
     3.151    49.396     0.150
     3.216    50.396     0.150
     3.216    98.396     0.150
     5.220    79.396     0.150
     6.589    97.396     0.150
    12.787   182.396     0.150
    12.963   187.096     0.150
    16.404   230.896     0.150
    17.485   244.396     0.150
    17.485   445.396     0.150
    18.884   257.596     0.150
    18.884   479.396     0.150
    18.884   574.396     0.150
    18.980   262.596     0.150
    19.336   262.596     0.150
    19.218   267.697     0.150
    19.353   268.596     0.150
    21.678   290.396     0.150
    21.986   292.697     0.150
    22.018   293.996     0.150
    22.566   295.996     0.150
    23.973   309.596     0.150
    24.115   311.697     0.150
    24.115   618.896     0.150
    24.530   319.896     0.150
    24.580   319.197     0.150
    24.703   321.596     0.150
    24.850   322.996     0.150
    25.414   328.297     0.150
    25.669   328.297     0.150
    25.671   329.697     0.150
    25.864   331.896     0.150
    25.922   332.797     0.150
    26.015   333.197     0.150
    26.015     9.600     0.150
    26.631   340.197     0.150
    26.631   625.396     0.150
    27.024   338.396     0.150
    27.172   339.797     0.150
    27.172   619.396     0.150
    27.263   343.396     0.150
    27.407   346.496     0.150
    28.042   351.396     0.150
    28.700   355.396     0.150
    29.055   356.297     0.150
    29.241   361.197     0.150
    29.420   362.797     0.150
    29.475   360.197     0.150
    29.475   663.396     0.150
    29.592   363.996     0.150
    29.456   366.896     0.150
    30.442   672.396     0.150
    32.051   387.396     0.150
    32.278   385.396     0.150
    32.375   392.396     0.150
    32.737   391.396     0.150
    33.107   395.396     0.150
    33.277   395.797     0.150
    34.453   406.396     0.150
    34.867   411.396     0.150
    35.228   410.396     0.150
    36.401   422.396     0.150
    36.840   424.896     0.150
    38.833   441.996     0.150
    45.443   495.896     0.150
    45.517   905.396     0.150
    47.847   519.396     0.150
    47.847   935.396     0.150
    49.951   531.096     0.150
    51.602   547.396     0.150
    51.602   989.396     0.150
    54.219   563.596     0.150
    54.362   566.396     0.150
    54.700   568.496     0.150
    54.700     9.400     0.150
    56.006   577.297     0.150
    56.006     9.600     0.150
    56.006   577.197     0.150
    57.023   582.396     0.150
    58.709   595.896     0.150
    59.133   598.596     0.150
    63.380   627.896     0.150
    65.849   644.297     0.150
    65.849   678.596     0.150
    66.554   646.396     0.150
    66.668   648.297     0.150
    68.582   662.197     0.150
    68.582     6.199     0.150
    68.582    10.199     0.150
    68.582  1207.396     0.150
    68.582   814.396     0.150
    71.473   680.297     0.150
    71.473    10.100     0.150
    77.105   712.496     0.150
    78.763   720.797     0.150
    78.834   721.797     0.150
    79.203   723.596     0.150
    79.295   724.197     0.150
    79.373   724.297     0.150
    80.340   730.197     0.150
    80.511   731.396     0.150
    80.531   730.797     0.150
    81.133   734.396     0.150
    81.133   741.297     0.150
    81.133  1348.297     0.150
    81.133   734.797     0.150
    81.133     6.500     0.150
    81.207     7.000     0.150
    81.207  1345.396     0.150
    81.207  1391.396     0.150
    81.354   736.396     0.150
    81.354  1347.396     0.150
    81.568   739.396     0.150
    83.005   745.396     0.150
    83.530   746.596     0.150
    84.124   749.297     0.150
    84.230   749.896     0.150
    84.317   750.996     0.150
    84.317     6.701     0.150
    84.353   749.396     0.150
    84.353    11.000     0.150
    84.353  1369.396     0.150
    84.353   749.896     0.150
    84.353    10.500     0.150
    84.525   751.297     0.150
    84.783   753.396     0.150
    84.783  1393.396     0.150
    85.019   755.396     0.150
    85.019     7.600     0.150
    85.201   754.697     0.150
    85.249   755.596     0.150
    85.255   756.396     0.150
    85.525  1394.396     0.150
    85.659   757.197     0.150
    85.659  1387.396     0.150
    86.310  1411.396     0.150
    86.375   761.697     0.150
    86.375   764.396     0.150
    86.375    10.699     0.150
    86.379   760.396     0.150
    86.409   760.297     0.150
    86.477   760.096     0.150
    86.487   760.346     0.150
    86.714   761.096     0.150
    86.754   762.096     0.150
    86.769   762.096     0.150
    86.823   761.596     0.150
    86.806   762.396     0.150
    86.831   762.596     0.150
    86.989   762.996     0.150
    86.989    11.000     0.150
    87.099   764.096     0.150
    87.162   763.896     0.150
    87.162   764.396     0.150
    87.256   764.896     0.150
    87.269   766.396     0.150
    87.269     9.000     0.150
    87.292     7.000     0.150
    87.353   765.096     0.150
    87.363   764.996     0.150
    87.407   765.797     0.150
    87.491   765.697     0.150
    87.552   765.896     0.150
    87.679   766.596     0.150
    87.729   766.697     0.150
    87.720   767.396     0.150
    87.720  1414.396     0.150
    88.499   771.396     0.150
    88.638  1414.396     0.150
    88.718   772.396     0.150
    88.865   773.396     0.150
    88.865  1407.396     0.150
    89.063   773.596     0.150
    89.117   979.396     0.150
    89.117  1417.396     0.150
    89.644   775.396     0.150
    89.644  1403.396     0.150
    89.644  1491.396     0.150
    90.539   781.297     0.150
    90.568   781.396     0.150
    90.998   782.396     0.150
    91.037   781.396     0.150
    91.037   995.396     0.150
    91.037  1411.396     0.150
    91.037  1423.396     0.150
    91.037  1507.396     0.150
    91.730   785.797     0.150
    91.730     8.600     0.150
    92.023   787.297     0.150
    92.426   788.396     0.150
    92.518   789.896     0.150
    92.518   790.396     0.150
    93.624   794.396     0.150
    93.624    11.000     0.150
    94.902   801.596     0.150
    95.082   801.596     0.150
    95.377   802.396     0.150
    95.377     9.000     0.150
    96.613   808.396     0.150
    96.613     7.000     0.150
    97.463   812.396     0.150
    99.347  1459.396     0.150
    99.347  1599.396     0.150
   126.711  1142.496     0.150
   126.722  1144.396     0.150
   138.112  1166.396     0.150
   138.112  1165.396     0.150
   139.415  1163.396     0.150
   144.983  1175.396     0.150
   144.983  1182.896     0.150
   146.503  1181.396     0.150
   148.778  1182.496     0.150
   151.413  1196.396     0.150
     3.039    47.491     0.150
     3.605    55.092     0.150
     3.605   104.092     0.150
     3.758    56.491     0.150
     3.841    54.791     0.150
     4.266    65.092     0.150
    21.504   288.691     0.150
    32.264   387.691     0.150
    45.520   495.991     0.150
    48.080   519.691     0.150
    50.230   534.191     0.150
    54.221   562.691     0.150
    54.240   563.892     0.150
    54.616   565.892     0.150
    55.950   575.491     0.150
    58.650   593.691     0.150
    62.552   622.291     0.150
    79.100   720.991     0.150
    79.168   721.691     0.150
    79.540   723.592     0.150
    79.631   723.892     0.150
    79.710   724.392     0.150
    79.964   726.092     0.150
    80.391   728.691     0.150
    80.544   729.291     0.150
    80.563   729.491     0.150
    80.661   729.892     0.150
    80.783   730.691     0.150
    80.855   731.291     0.150
    83.755   746.892     0.150
    84.477   750.392     0.150
    84.487   750.291     0.150
    84.581   751.191     0.150
    84.876   752.491     0.150
    85.252   752.491     0.150
    85.544   755.392     0.150
    85.560   755.592     0.150
    85.589   755.691     0.150
    85.872   757.491     0.150
    86.743   761.592     0.150
    86.760   760.401     0.150
    86.767   761.441     0.150
    86.767   761.491     0.150
    86.992   760.541     0.150
    87.104   761.691     0.150
    87.116   762.491     0.150
    87.136   763.691     0.150
    87.134   762.691     0.150
    87.189   762.791     0.150
    87.387   762.791     0.150
    87.456   764.092     0.150
    87.598   765.691     0.150
    87.598    10.000     0.150
    87.608   763.791     0.150
    87.620   765.491     0.150
    87.627   765.191     0.150
    87.627    14.500     0.150
    87.706   764.991     0.150
    87.718   764.892     0.150
    87.843   765.892     0.150
    88.032   766.691     0.150
    88.084   766.491     0.150
    88.914   769.592     0.150
    89.064   771.791     0.150
    89.409   773.092     0.150
    89.444   773.592     0.150
    89.882   774.691     0.150
    91.144   782.491     0.150
    91.297   781.691     0.150
    92.757   789.191     0.150
    92.844   789.892     0.150
   126.281  1142.191     0.150
   126.553  1142.191     0.150
   143.818  1170.991     0.150
   145.076  1174.691     0.150
   145.076  1181.691     0.150
   148.885  1181.092     0.150
   150.344  1190.191     0.150
   150.661  1190.191     0.150
     3.112    46.033     0.150
     3.115    46.834     0.150
     3.192    46.434     0.150
     3.361    47.934     0.150
     4.009    58.635     0.150
    10.007   138.834     0.150
    12.171   169.135     0.150
    15.050   208.834     0.150
    15.730   216.834     0.150
    16.801   230.635     0.150
    17.186   231.533     0.150
    17.186   232.635     0.150
    18.308   244.434     0.150
    18.308   246.234     0.150
    18.308   445.334     0.150
    18.330   249.334     0.150
    18.330   260.834     0.150
    18.432   245.834     0.150
    18.432   248.135     0.150
    18.770   249.234     0.150
    18.770   250.434     0.150
    21.044   276.834     0.150
    21.310   278.834     0.150
    21.343   280.334     0.150
    21.902   287.834     0.150
    22.053   284.334     0.150
    23.653   298.834     0.150
    23.895   306.033     0.150
    23.933   305.033     0.150
    24.028   306.334     0.150
    24.187   308.135     0.150
    24.984   314.334     0.150
    25.022   315.734     0.150
    25.225   317.834     0.150
    25.341   318.834     0.150
    26.754   331.934     0.150
    26.799   328.834     0.150
    26.799    22.000     0.150
    30.909   369.834     0.150
    31.700   372.834     0.150
    32.051   377.334     0.150
    32.206   380.334     0.150
    32.594   380.834     0.150
    33.769   392.834     0.150
    35.717   407.834     0.150
    36.182   412.234     0.150
    46.128   495.834     0.150
    48.241   511.135     0.150
    48.441   513.334     0.150
    68.012   649.434     0.150
    84.046   740.834     0.150
    84.046    40.500     0.150
    85.742   749.834     0.150
    86.222   745.734     0.150
    95.176   792.635     0.150
   126.656  1133.434     0.150
   126.667  1132.635     0.150
   148.122  1175.033     0.150
   150.314  1174.834     0.150
     3.083    49.582     0.150
     3.122    46.582     0.150
     3.149    47.582     0.150
     3.149    81.281     0.150
     3.507    55.980     0.150
     3.521    53.281     0.150
     3.581    55.680     0.150
     3.757    56.480     0.150
     4.262    64.281     0.150
     4.399    65.980     0.150
     5.428    81.082     0.150
     5.890    88.781     0.150
    12.333   175.281     0.150
    12.678   180.281     0.150
    13.123   183.582     0.150
    16.813   232.281     0.150
    16.813   248.281     0.150
    17.412   241.781     0.150
    18.182   251.281     0.150
    18.182   258.281     0.150
    18.509   251.680     0.150
    18.509   264.980     0.150
    18.642   252.582     0.150
    18.980   255.781     0.150
    18.949   260.281     0.150
    19.542   266.281     0.150
    19.968   271.582     0.150
    19.968   289.281     0.150
    19.969   274.281     0.150
    20.858   280.281     0.150
    20.871   281.281     0.150
    20.957   282.281     0.150
    21.057   281.281     0.150
    21.057   526.281     0.150
    21.357   284.480     0.150
    21.357   303.281     0.150
    21.392   285.480     0.150
    21.766   290.281     0.150
    21.766   310.281     0.150
    22.130   293.281     0.150
    22.301   291.281     0.150
    23.723   309.980     0.150
    24.065   313.281     0.150
    24.397   315.281     0.150
    24.608   317.281     0.150
    24.852   316.281     0.150
    24.872   319.980     0.150
    24.872   536.281     0.150
    24.988   318.781     0.150
    25.117   322.680     0.150
    25.117   537.281     0.150
    25.677   325.582     0.150
    25.826   330.480     0.150
    25.826   538.180     0.150
    26.611   336.281     0.150
    26.611    18.000     0.150
    26.611   540.281     0.150
    26.708   337.281     0.150
    27.121   336.383     0.150
    27.121    16.500     0.150
    27.249   341.281     0.150
    27.904   345.180     0.150
    27.904   542.281     0.150
    28.515   351.383     0.150
    28.831   355.883     0.150
    30.281   364.180     0.150
    30.248   369.281     0.150
    30.655   367.883     0.150
    31.195   379.281     0.150
    31.195   685.781     0.150
    31.231   379.781     0.150
    31.897   378.281     0.150
    31.897    15.000     0.150
    32.012   381.281     0.150
    32.564   388.480     0.150
    32.613   386.281     0.150
    33.046   397.281     0.150
    33.718   398.281     0.150
    34.729   405.082     0.150
    35.070   406.281     0.150
    35.171   407.582     0.150
    35.171    21.000     0.150
    35.516   413.082     0.150
    35.729   413.281     0.150
    36.270   417.281     0.150
    36.274   417.281     0.150
    39.944   449.980     0.150
    40.815   455.281     0.150
    44.798   487.281     0.150
    44.815   487.582     0.150
    44.815    19.699     0.150
    44.830   488.582     0.150
    45.534   493.781     0.150
    48.461   518.680     0.150
    48.660   521.082     0.150
    48.660   941.281     0.150
    49.921   527.781     0.150
    50.943   534.281     0.150
    52.408   550.281     0.150
    54.214   560.281     0.150
    54.336   563.480     0.150
    55.262   568.781     0.150
    56.153   576.781     0.150
    57.249   583.781     0.150
    58.517   590.281     0.150
    58.689   594.180     0.150
    59.070   594.781     0.150
    59.376   599.781     0.150
    59.704   601.180     0.150
    59.966   603.281     0.150
    59.995   603.281     0.150
    60.015   603.781     0.150
    60.046   604.883     0.150
    60.174   604.281     0.150
    60.360   606.281     0.150
    60.415   607.281     0.150
    61.873   615.281     0.150
    63.650   627.180     0.150
    65.858   641.480     0.150
    66.039   639.480     0.150
    66.904    13.098     0.150
    67.829   653.883     0.150
    67.829  1191.281     0.150
    67.829   677.480     0.150
    67.829   809.281     0.150
    67.829  1213.281     0.150
    67.829  1245.281     0.150
    67.965   654.281     0.150
    68.278   656.582     0.150
    68.278    13.500     0.150
    68.312   660.281     0.150
    68.954   661.180     0.150
    68.954    13.402     0.150
    69.738   664.781     0.150
    70.850   669.281     0.150
    71.173   675.281     0.150
    75.213   701.281     0.150
    76.649   707.582     0.150
    78.725   717.781     0.150
    79.102   719.680     0.150
    80.394   727.281     0.150
    80.363   727.480     0.150
    80.363  1332.281     0.150
    80.549   728.281     0.150
    80.549  1333.281     0.150
    80.669   728.281     0.150
    82.197   737.281     0.150
    82.197   737.781     0.150
    82.197  1350.281     0.150
    83.656   742.281     0.150
    83.656  1359.281     0.150
    83.656   937.281     0.150
    84.074   746.281     0.150
    84.087   746.082     0.150
    84.173   747.082     0.150
    84.417   748.781     0.150
    84.457   748.281     0.150
    84.664   749.480     0.150
    85.058   751.383     0.150
    85.077   751.281     0.150
    85.077   939.281     0.150
    85.172   751.480     0.150
    85.266   752.281     0.150
    85.266    14.199     0.150
    86.101   758.582     0.150
    86.158   757.281     0.150
    86.236   756.703     0.150
    86.274   757.680     0.150
    86.336   758.281     0.150
    86.369   757.680     0.150
    86.378   757.883     0.150
    86.459   757.520     0.150
    86.574   757.883     0.150
    86.705   760.383     0.150
    86.705    13.297     0.150
    86.705  1398.281     0.150
    86.705  1423.281     0.150
    86.736   759.180     0.150
    86.760   760.082     0.150
    86.792   758.980     0.150
    86.798   759.883     0.150
    86.823   759.883     0.150
    87.145   762.281     0.150
    87.145    13.000     0.150
    87.186   761.781     0.150
    87.186    13.500     0.150
    87.241   761.883     0.150
    87.303    12.500     0.150
    87.304   762.180     0.150
    87.319   761.980     0.150
    87.362   763.180     0.150
    87.439   763.082     0.150
    87.522   763.480     0.150
    87.630   763.680     0.150
    87.685   763.883     0.150
    87.765  1404.281     0.150
    87.765  1427.281     0.150
    88.377   766.781     0.150
    88.646   768.680     0.150
    88.871   769.281     0.150
    88.991   770.281     0.150
    89.020   770.383     0.150
    89.300   771.281     0.150
    89.801   772.980     0.150
    89.794   772.980     0.150
    90.441   778.281     0.150
    90.441    13.000     0.150
    90.698   778.680     0.150
    90.698    14.500     0.150
    90.741   778.480     0.150
    90.856   778.281     0.150
    90.856    14.000     0.150
    91.589   782.281     0.150
    91.589    14.000     0.150
    92.080   784.582     0.150
    92.080  1439.281     0.150
    92.080  1002.281     0.150
    92.308   786.781     0.150
    92.308    14.500     0.150
    92.308   786.883     0.150
    92.385   785.281     0.150
    92.385    14.199     0.150
    92.362   787.281     0.150
    92.362  1443.281     0.150
    92.362   787.980     0.150
    94.777   797.180     0.150
    94.777   811.480     0.150
    95.216   812.281     0.150
    95.572   800.480     0.150
    95.572    14.602     0.150
    95.894   800.883     0.150
    95.894    15.199     0.150
    96.136   804.281     0.150
    96.246   804.281     0.150
    96.246    14.000     0.150
    96.465   806.281     0.150
    96.465    13.000     0.150
    96.465    21.000     0.150
    96.466   804.281     0.150
    96.466    19.000     0.150
    97.305   809.281     0.150
    97.305   809.781     0.150
    98.178   812.281     0.150
    99.040   815.281     0.150
    99.040  1499.281     0.150
    99.040   815.781     0.150
    99.040  1453.281     0.150
   117.893  1122.281     0.150
   120.257  1127.281     0.150
   120.474  1126.281     0.150
   120.474  1126.980     0.150
   120.576  1127.281     0.150
   121.146  1127.980     0.150
   122.801  1131.281     0.150
   122.801  1131.781     0.150
   123.062  1133.281     0.150
   124.169  1135.281     0.150
   126.260  1140.180     0.150
   126.271  1140.082     0.150
   127.136  1140.281     0.150
   129.950  1145.281     0.150
   130.698  1149.383     0.150
   130.698  1162.480     0.150
   130.698  1352.281     0.150
   131.566  1148.980     0.150
   131.626  1149.781     0.150
   132.381  1148.680     0.150
   132.999  1150.281     0.150
   133.205  1152.082     0.150
   133.440  1152.883     0.150
   133.533  1150.281     0.150
   133.633  1152.281     0.150
   133.645  1153.281     0.150
   134.025  1152.281     0.150
   134.187  1169.281     0.150
   134.245  1155.582     0.150
   134.677  1154.281     0.150
   134.677  1170.281     0.150
   134.967  1155.281     0.150
   136.529  1158.281     0.150
   136.529  1175.281     0.150
   141.110  1162.281     0.150
   142.440  1165.281     0.150
   143.162  1166.781     0.150
   143.995  1171.082     0.150
   143.986  1170.281     0.150
   144.396  1184.281     0.150
   144.396  1190.281     0.150
   144.401  1169.281     0.150
   145.690  1176.281     0.150
   148.210  1178.980     0.150
   149.761  1186.281     0.150
   150.089  1182.082     0.150
   151.110  1183.281     0.150
   151.560  1186.281     0.150
   152.052  1186.281     0.150
     1.241    21.508     0.150
     3.378    52.109     0.150
     3.378   104.711     0.150
     3.483    53.305     0.150
     3.816    57.508     0.150
     3.820    58.008     0.150
     3.824    58.508     0.150
     3.859    57.508     0.150
     3.882    57.508     0.150
     3.882    96.508     0.150
     4.068    62.711     0.150
     4.596    68.508     0.150
     4.678    70.109     0.150
     5.235    75.008     0.150
     5.746    84.805     0.150
     6.271    91.008     0.150
     6.271   158.508     0.150
     6.278    91.008     0.150
    10.750   153.008     0.150
    10.750   154.906     0.150
    12.260   174.508     0.150
    12.656   181.508     0.150
    13.155   184.508     0.150
    15.270   216.508     0.150
    15.394   216.508     0.150
    16.596   230.711     0.150
    17.407   239.609     0.150
    17.852   246.508     0.150
    18.475   251.008     0.150
    18.475   261.508     0.150
    18.475   459.508     0.150
    18.956   255.805     0.150
    18.956   268.508     0.150
    19.200   262.508     0.150
    19.312   262.508     0.150
    19.958   270.508     0.150
    20.515   276.508     0.150
    20.527   276.508     0.150
    20.628   277.508     0.150
    20.719   277.508     0.150
    21.397   284.508     0.150
    21.436   284.508     0.150
    21.794   289.508     0.150
    21.873   290.008     0.150
    23.379   306.211     0.150
    23.444   305.008     0.150
    23.640   306.906     0.150
    23.748   309.305     0.150
    23.869   309.305     0.150
    23.923   310.406     0.150
    24.348   313.805     0.150
    24.515   315.305     0.150
    24.718   317.305     0.150
    24.762   315.508     0.150
    24.775   318.508     0.150
    24.945   318.906     0.150
    26.282   332.406     0.150
    28.276   348.305     0.150
    30.635   372.008     0.150
    31.586   382.008     0.150
    31.854   377.508     0.150
    35.142   405.508     0.150
    35.142    22.000     0.150
    35.508   410.008     0.150
    36.123   415.508     0.150
    44.596   485.508     0.150
    44.627   486.406     0.150
    45.568   492.508     0.150
    48.830   521.008     0.150
    48.830   941.508     0.150
    49.028   522.508     0.150
    49.302   525.508     0.150
    50.050   526.508     0.150
    50.911   535.508     0.150
    53.291   552.508     0.150
    53.291    17.000     0.150
    54.603   563.406     0.150
    54.697   566.305     0.150
    54.985   565.508     0.150
    65.917   638.008     0.150
    67.293   649.508     0.150
    68.662   658.906     0.150
    69.343   662.711     0.150
    84.191   745.008     0.150
    84.206   745.008     0.150
    84.287   745.711     0.150
    84.571   747.109     0.150
    84.629   747.609     0.150
    85.077   750.008     0.150
    85.211   750.508     0.150
    86.477   755.109     0.150
    86.503   757.109     0.150
    86.504   756.805     0.150
    86.749   757.109     0.150
    86.867   758.508     0.150
    86.896   758.711     0.150
    86.922   758.508     0.150
    86.936   759.906     0.150
    86.969   759.109     0.150
    87.030   758.008     0.150
    87.188   759.406     0.150
    87.215   759.906     0.150
    87.374   760.805     0.150
    87.421   761.008     0.150
    87.508   762.711     0.150
    87.554   761.109     0.150
    87.746   761.805     0.150
    88.392   764.109     0.150
    89.271   769.305     0.150
    89.783   771.609     0.150
    90.737   776.508     0.150
    95.902   800.711     0.150
   125.940  1137.211     0.150
   125.951  1137.211     0.150
   133.048  1150.508     0.150
   144.224  1168.508     0.150
   144.224  1185.508     0.150
   145.327  1174.008     0.150
   146.911  1178.508     0.150
   146.980  1178.508     0.150
   148.049  1176.109     0.150
   151.398  1194.508     0.150
     0.731    14.396     0.150
     3.027    49.396     0.150
     3.019    48.396     0.150
     3.019    87.396     0.150
     3.496    56.396     0.150
     4.635    70.396     0.150
     5.723    87.396     0.150
     5.723   156.396     0.150
     7.104   106.396     0.150
    11.203   165.195     0.150
    17.098   242.396     0.150
    17.617   246.096     0.150
    18.469   265.396     0.150
    18.729   258.796     0.150
    18.729   485.396     0.150
    19.194   263.896     0.150
    19.825   271.396     0.150
    19.930   278.396     0.150
    20.259   276.995     0.150
    21.141   288.396     0.150
    21.244   288.396     0.150
    21.342   291.396     0.150
    21.635   292.396     0.150
    21.670   293.096     0.150
    22.053   297.396     0.150
    22.491   298.396     0.150
    22.415   302.396     0.150
    23.066   302.695     0.150
    25.134   326.596     0.150
    25.274   326.396     0.150
    25.536   330.495     0.150
    25.949   333.096     0.150
    28.804   358.995     0.150
    32.303   389.396     0.150
    33.432   396.396     0.150
    36.540   424.396     0.150
    45.080   494.396     0.150
    45.111   495.596     0.150
    48.193   521.396     0.150
    48.392   523.396     0.150
    51.160   543.396     0.150
    53.815   562.396     0.150
    58.794   597.495     0.150
    66.295   646.396     0.150
    66.707   652.296     0.150
    80.548   732.396     0.150
    84.200   752.296     0.150
    84.212   752.195     0.150
    84.301   752.695     0.150
    84.584   754.195     0.150
    85.246   756.596     0.150
    85.291   757.796     0.150
    86.482   763.495     0.150
    86.498   763.195     0.150
    86.852   765.096     0.150
    86.918   766.195     0.150
    86.927   765.796     0.150
    87.185   766.695     0.150
    87.430   768.695     0.150
    87.566   769.596     0.150
   144.668  1176.396     0.150
     0.085     5.508     0.150
     0.085     8.258     0.150
     1.880    33.258     0.150
     1.880    55.258     0.150
     3.095    47.258     0.150
     3.138    48.258     0.150
     3.275    48.758     0.150
     3.591    55.758     0.150
     3.595    56.758     0.150
     3.610    55.758     0.150
     3.708    57.258     0.150
     4.291    64.258     0.150
     4.646    67.559     0.150
     5.763    85.258     0.150
     6.234   178.258     0.150
    11.333   164.258     0.150
    11.648   168.758     0.150
    11.833   173.258     0.150
    12.036   173.258     0.150
    12.343   176.258     0.150
    12.476   176.258     0.150
    12.685   178.258     0.150
    12.716   181.758     0.150
    12.760   183.258     0.150
    12.806   179.258     0.150
    13.207   190.156     0.150
    14.154   206.758     0.150
    17.219   241.258     0.150
    17.222   241.516     0.150
    18.357   251.758     0.150
    18.253   255.359     0.150
    18.547   257.258     0.150
    18.547   266.258     0.150
    18.671   255.836     0.150
    18.875   257.559     0.150
    18.875   258.859     0.150
    18.875   259.957     0.150
    18.875   269.059     0.150
    18.790   266.258     0.150
    18.730   260.059     0.150
    18.875   260.156     0.150
    19.342   262.258     0.150
    19.299   266.258     0.150
    19.356   268.957     0.150
    19.502   268.758     0.150
    19.531   268.758     0.150
    19.768   273.258     0.150
    19.894   275.059     0.150
    19.899   275.156     0.150
    19.937   277.258     0.150
    19.895   272.258     0.150
    19.895   285.258     0.150
    19.948   275.258     0.150
    20.242   274.156     0.150
    20.194   275.559     0.150
    20.198   274.656     0.150
    20.654   280.258     0.150
    21.127   285.359     0.150
    21.223   285.258     0.150
    21.223   750.258     0.150
    21.323   287.258     0.150
    22.131   295.258     0.150
    22.348   297.758     0.150
    22.639   298.758     0.150
    22.561   300.258     0.150
    23.209   302.859     0.150
    23.707   312.758     0.150
    24.234   313.758     0.150
    24.234   313.258     0.150
    24.074   315.258     0.150
    24.140   314.859     0.150
    24.213   315.457     0.150
    24.213   591.258     0.150
    24.323   317.758     0.150
    24.440   319.559     0.150
    24.565   319.258     0.150
    24.618   320.059     0.150
    24.984   319.758     0.150
    25.093   320.758     0.150
    24.959   323.559     0.150
    25.044   324.258     0.150
    25.210   325.059     0.150
    25.393   325.059     0.150
    25.414   327.559     0.150
    25.462   327.859     0.150
    25.471   328.359     0.150
    25.630   329.457     0.150
    26.007   332.559     0.150
    26.181   336.258     0.150
    26.181   607.258     0.150
    26.977   342.059     0.150
    27.387   341.656     0.150
    27.387   341.258     0.150
    27.618   347.059     0.150
    28.170   351.758     0.150
    28.271   350.957     0.150
    28.804   356.859     0.150
    28.919   357.859     0.150
    29.125   359.656     0.150
    29.194   362.758     0.150
    29.618   363.258     0.150
    29.624   362.859     0.150
    29.991   369.258     0.150
    30.595   370.457     0.150
    30.922   372.559     0.150
    30.970   373.156     0.150
    30.991   380.258     0.150
    31.185   376.820     0.150
    31.808   382.957     0.150
    31.966   386.258     0.150
    32.042   387.258     0.150
    32.082   387.559     0.150
    32.266   384.258     0.150
    32.412   390.258     0.150
    32.424   389.859     0.150
    32.412   388.258     0.150
    32.412   389.258     0.150
    32.734   391.680     0.150
    32.921   393.758     0.150
    33.019   392.859     0.150
    33.575   396.258     0.150
    33.710   396.758     0.150
    33.835   401.258     0.150
    34.115   403.258     0.150
    34.714   407.457     0.150
    34.714     6.801     0.150
    34.925   411.258     0.150
    35.192   409.258     0.150
    35.375   412.258     0.150
    35.375     6.500     0.150
    35.466   411.559     0.150
    35.409   414.258     0.150
    36.135   419.457     0.150
    36.233   420.258     0.150
    36.375   423.258     0.150
    36.567   421.258     0.150
    36.676   423.359     0.150
    38.028   437.758     0.150
    38.140   438.758     0.150
    38.916   445.457     0.150
    39.026   443.758     0.150
    39.328   446.688     0.150
    39.498   448.758     0.150
    39.581   448.238     0.150
    39.822   451.957     0.150
    39.939   453.258     0.150
    39.984   456.629     0.150
    40.144   452.156     0.150
    40.153   460.656     0.150
    40.215   455.559     0.150
    40.198   461.059     0.150
    40.250   825.258     0.150
    41.049   464.148     0.150
    40.935   819.859     0.150
    45.236   495.559     0.150
    45.862   498.457     0.150
    45.974   504.859     0.150
    46.000   503.258     0.150
    48.145   519.059     0.150
    48.145   519.508     0.150
    48.344   521.258     0.150
    48.344     6.301     0.150
    50.180   532.258     0.150
    53.441   559.656     0.150
    53.377   560.559     0.150
    53.932   561.656     0.150
    53.951   563.258     0.150
    54.036   562.859     0.150
    54.007   564.258     0.150
    55.657   574.258     0.150
    55.657   574.152     0.150
    55.657   573.559     0.150
    55.815   575.258     0.150
    55.815  1050.258     0.150
    56.844   582.758     0.150
    57.790   588.656     0.150
    58.358   592.758     0.150
    58.971   602.859     0.150
    59.025   599.859     0.150
    59.086   600.258     0.150
    59.330   602.258     0.150
    59.592   605.258     0.150
    59.594   606.258     0.150
    59.620   605.258     0.150
    59.639   602.258     0.150
    59.800   605.258     0.150
    61.922   616.059     0.150
    63.497   628.656     0.150
    63.497    12.801     0.150
    63.497   663.559     0.150
    66.199   646.258     0.150
    66.722   650.059     0.150
    66.722     7.898     0.150
    67.086   655.457     0.150
    67.086  1186.656     0.150
    67.600   654.758     0.150
    68.003   658.059     0.150
    68.003     9.000     0.150
    68.220   659.359     0.150
    68.220  1201.258     0.150
    68.220   683.758     0.150
    68.782   663.156     0.150
    68.782     8.000     0.150
    69.966   673.656     0.150
    69.966     5.703     0.150
    71.227   675.758     0.150
    71.550   681.359     0.150
    71.550     7.297     0.150
    71.814   679.258     0.150
    75.125  1293.258     0.150
    77.539   885.758     0.150
    78.639   720.258     0.150
    78.639     8.898     0.150
    79.499   725.457     0.150
    79.745   726.859     0.150
    79.794   727.156     0.150
    79.799   726.559     0.150
    80.050   728.359     0.150
    80.050   733.559     0.150
    80.225   729.258     0.150
    80.225   734.656     0.150
    80.380   730.059     0.150
    80.380   735.359     0.150
    80.395   730.258     0.150
    80.496   730.656     0.150
    80.619   731.457     0.150
    80.673   731.656     0.150
    80.693   731.457     0.150
    80.804   732.656     0.150
    80.804   737.957     0.150
    80.748   732.258     0.150
    80.748  1346.258     0.150
    80.748     9.000     0.150
    80.748  1653.258     0.150
    80.938   734.258     0.150
    80.903  1349.258     0.150
    80.903   923.258     0.150
    81.068   733.258     0.150
    81.068   733.758     0.150
    81.068  1353.258     0.150
    81.386   735.258     0.150
    81.386   926.957     0.150
    81.386  1364.258     0.150
    81.659   737.258     0.150
    81.659   914.156     0.150
    81.659  1354.258     0.150
    81.787   737.258     0.150
    82.576   741.859     0.150
    82.576   747.258     0.150
    82.576  1367.258     0.150
    82.576  1408.859     0.150
    83.162   747.258     0.150
    83.147  1372.859     0.150
    83.147   946.059     0.150
    83.147  1362.258     0.150
    83.537   747.156     0.150
    83.528   747.656     0.150
    83.551   747.559     0.150
    83.800   748.258     0.150
    83.895   750.457     0.150
    84.060   747.758     0.150
    84.060  1378.258     0.150
    84.060  1370.258     0.150
    84.342   751.258     0.150
    84.353   750.859     0.150
    84.443   750.656     0.150
    84.591    12.000     0.150
    84.726   753.156     0.150
    84.750   754.258     0.150
    84.827     9.000     0.150
    84.855   753.258     0.150
    85.028   754.359     0.150
    85.028   757.957     0.150
    85.028     8.398     0.150
    85.075   754.758     0.150
    85.075  1382.758     0.150
    85.075  1393.758     0.150
    85.312   756.359     0.150
    85.312   949.258     0.150
    85.312  1376.758     0.150
    85.336   755.258     0.150
    85.355   756.059     0.150
    85.394   755.258     0.150
    85.432   756.156     0.150
    85.639   758.457     0.150
    85.639     6.000     0.150
    85.639  1395.258     0.150
    85.842    11.000     0.150
    85.842  1374.258     0.150
    86.321   762.156     0.150
    86.336   761.258     0.150
    86.336     8.000     0.150
    86.460   761.656     0.150
    86.483   761.758     0.150
    86.483     4.500     0.150
    86.483   966.258     0.150
    86.483  1397.258     0.150
    86.483  1743.258     0.150
    86.560   762.258     0.150
    86.560     7.000     0.150
    86.560   974.258     0.150
    86.560  1404.258     0.150
    86.578   762.656     0.150
    86.171   765.258     0.150
    86.621   762.457     0.150
    86.638   761.457     0.150
    86.649   761.559     0.150
    86.909   762.559     0.150
    86.988   764.258     0.150
    86.988     5.199     0.150
    86.992   763.359     0.150
    87.002   765.258     0.150
    87.002     7.199     0.150
    87.012   763.656     0.150
    87.059   763.559     0.150
    87.065   764.059     0.150
    87.159   763.559     0.150
    87.207   764.559     0.150
    87.326   764.559     0.150
    87.358   764.656     0.150
    87.396   764.258     0.150
    87.396   769.758     0.150
    87.439   765.258     0.150
    87.439     6.000     0.150
    87.439     8.602     0.150
    87.474   766.258     0.150
    87.474     5.898     0.150
    87.474     7.602     0.150
    87.496   765.559     0.150
    87.181   960.258     0.150
    87.181  1399.258     0.150
    87.571   765.758     0.150
    87.584   765.559     0.150
    87.590   767.457     0.150
    87.590     6.500     0.150
    87.605   766.359     0.150
    87.707   766.656     0.150
    87.749   770.457     0.150
    87.897   767.059     0.150
    87.951   768.359     0.150
    88.084   773.258     0.150
    88.084  1421.258     0.150
    88.084  1755.258     0.150
    88.102   770.258     0.150
    88.102  1411.258     0.150
    88.102  1758.258     0.150
    88.201   773.457     0.150
    88.202   771.758     0.150
    88.202  1417.758     0.150
    88.448   771.258     0.150
    88.448     5.801     0.150
    88.624  1425.258     0.150
    88.716     9.398     0.150
    88.844  1422.258     0.150
    88.844   980.258     0.150
    88.844  1408.258     0.150
    88.922   772.359     0.150
    88.959     7.902     0.150
    89.160   774.359     0.150
    89.160     8.199     0.150
    89.160  1433.258     0.150
    89.267   773.758     0.150
    89.299   773.957     0.150
    89.317   774.859     0.150
    89.317     7.000     0.150
    89.513   778.258     0.150
    89.513  1421.258     0.150
    89.661   775.758     0.150
    89.661     5.699     0.150
    89.661  1421.258     0.150
    89.744   777.059     0.150
    90.132   779.156     0.150
    90.157   777.758     0.150
    90.272   779.559     0.150
    90.188   778.359     0.150
    90.188  1429.258     0.150
    90.320   779.957     0.150
    90.389   780.559     0.150
    90.425   781.457     0.150
    90.433   779.859     0.150
    90.433     7.098     0.150
    90.690     5.500     0.150
    90.736   781.258     0.150
    90.736   785.258     0.150
    90.736     8.000     0.150
    90.736  1429.258     0.150
    90.783   783.359     0.150
    90.917   782.059     0.150
    90.989   783.258     0.150
    90.989     8.102     0.150
    90.989  1437.758     0.150
    91.047  1433.258     0.150
    91.058   782.457     0.150
    91.057   783.457     0.150
    91.067   782.258     0.150
    91.071   784.059     0.150
    91.089   782.457     0.150
    91.089     5.199     0.150
    91.089  1423.258     0.150
    91.157   782.258     0.150
    91.157  1429.258     0.150
    91.320   784.258     0.150
    91.366   784.258     0.150
    91.381  1516.258     0.150
    91.820   787.258     0.150
    91.890   786.059     0.150
    91.890     7.199     0.150
    91.890  1005.258     0.150
    91.890  1419.258     0.150
    91.890  2323.258     0.150
    92.200   788.156     0.150
    92.200  1432.758     0.150
    92.263   789.258     0.150
    92.486   789.258     0.150
    92.573   790.258     0.150
    92.580   789.258     0.150
    92.580     6.000     0.150
    92.580     9.000     0.150
    92.600   790.258     0.150
    92.600     8.000     0.150
    92.600  1433.258     0.150
    92.600  1441.258     0.150
    92.683     7.500     0.150
    92.683    10.301     0.150
    92.683  1428.258     0.150
    92.711  1461.258     0.150
    92.711  1017.258     0.150
    92.711  1426.258     0.150
    92.701   794.258     0.150
    92.959   790.758     0.150
    93.212  1456.258     0.150
    93.476   797.258     0.150
    93.530   794.258     0.150
    93.661   794.258     0.150
    93.661  1423.258     0.150
    93.661  1539.258     0.150
    93.661  1840.258     0.150
    93.663  1020.258     0.150
    93.919  1429.258     0.150
    94.136  1477.258     0.150
    94.397   797.758     0.150
    94.487   798.957     0.150
    94.487     7.699     0.150
    94.487  1023.859     0.150
    94.487  1447.258     0.150
    94.487  1483.258     0.150
    94.487  1859.258     0.150
    94.593  1029.258     0.150
    94.593  1299.258     0.150
    94.593  1453.258     0.150
    94.597     4.398     0.150
    94.536   804.258     0.150
    94.536  1466.258     0.150
    94.766  1454.258     0.150
    94.867   800.258     0.150
    95.053   800.258     0.150
    95.072   802.359     0.150
    95.072     7.898     0.150
    95.072    12.598     0.150
    95.516   802.758     0.150
    95.523   802.957     0.150
    95.523     5.301     0.150
    95.523  1559.258     0.150
    95.576   804.059     0.150
    95.576     6.500     0.150
    95.742   805.258     0.150
    95.550  1483.258     0.150
    95.959   806.359     0.150
    95.959     7.398     0.150
    96.099   805.758     0.150
    96.402   806.258     0.150
    96.402  1446.258     0.150
    96.454   811.258     0.150
    96.542   809.258     0.150
    96.375  1498.258     0.150
    96.229  1035.258     0.150
    96.552  1499.258     0.150
    96.765   810.859     0.150
    96.860  1497.258     0.150
    97.612   813.258     0.150
    97.612   813.957     0.150
    97.612  1447.258     0.150
    97.625   815.758     0.150
    97.752   817.258     0.150
    98.147   814.258     0.150
    98.062   816.258     0.150
    98.577   818.559     0.150
    98.796  1454.258     0.150
    98.652  1507.258     0.150
    98.924  1089.656     0.150
    99.090   819.258     0.150
    99.090     8.500     0.150
    99.090  1463.258     0.150
    99.392   820.258     0.150
    99.392   825.258     0.150
    99.592  1055.258     0.150
    99.592  1463.258     0.150
    99.617   822.258     0.150
    99.617   830.156     0.150
    99.738   826.258     0.150
   100.083   824.258     0.150
   101.176  1083.258     0.150
   101.176  1631.258     0.150
   100.998   830.258     0.150
   100.998  1531.258     0.150
   101.297   830.559     0.150
   101.297  1463.758     0.150
   101.232   832.258     0.150
   101.534   830.758     0.150
   101.594   844.258     0.150
   101.594  1084.258     0.150
   101.594  1471.258     0.150
   101.594  1525.258     0.150
   101.594  1623.258     0.150
   102.010   835.258     0.150
   102.010  1476.258     0.150
   102.067   836.758     0.150
   102.244   833.656     0.150
   102.323   833.258     0.150
   104.177   846.258     0.150
   104.177  1487.258     0.150
   104.177  1993.258     0.150
   104.215  1100.258     0.150
   104.368   847.258     0.150
   104.368  1106.258     0.150
   106.065  1117.258     0.150
   106.065  1533.258     0.150
   106.235   855.258     0.150
   106.235  1117.258     0.150
   106.887   857.258     0.150
   106.851   856.859     0.150
   106.851  1116.258     0.150
   107.294  1501.258     0.150
   107.393   859.359     0.150
   108.181  1139.258     0.150
   108.322   859.258     0.150
   108.811   863.258     0.150
   108.811  1698.258     0.150
   110.788  1151.258     0.150
   110.788  1719.258     0.150
   110.653  1784.258     0.150
   111.861  1151.559     0.150
   111.853  1165.258     0.150
   112.467  1163.258     0.150
   112.467  1723.258     0.150
   112.859  2099.258     0.150
   113.387  1523.859     0.150
   112.976  1170.258     0.150
   112.976  2110.258     0.150
   113.438   887.859     0.150
   113.449  1550.957     0.150
   113.449  1745.957     0.150
   113.800  1172.258     0.150
   113.800  1549.258     0.150
   114.247  1179.258     0.150
   114.042  1119.258     0.150
   114.559  1179.258     0.150
   114.559  1550.258     0.150
   114.905  1187.258     0.150
   114.957  1184.258     0.150
   114.865  1534.258     0.150
   115.218  1190.258     0.150
   115.218  1533.258     0.150
   115.492  1191.258     0.150
   115.515  1537.258     0.150
   115.515  1777.258     0.150
   115.913  1194.859     0.150
   116.556  1197.258     0.150
   117.024  1123.258     0.150
   117.024  1183.758     0.150
   116.560  1203.258     0.150
   116.560  1547.258     0.150
   116.560  1751.258     0.150
   117.086  1195.258     0.150
   117.086  1533.258     0.150
   118.171  1127.258     0.150
   118.171  1200.758     0.150
   119.089  1131.457     0.150
   119.089  1136.258     0.150
   119.089  1214.258     0.150
   119.089  1550.258     0.150
   119.049  1565.258     0.150
   119.150  1124.258     0.150
   119.438  1136.758     0.150
   119.438  1540.258     0.150
   119.438  1796.258     0.150
   119.438  2196.258     0.150
   119.830  1220.258     0.150
   119.830  1549.258     0.150
   119.830  1797.258     0.150
   119.966  1213.359     0.150
   119.966  1805.258     0.150
   120.116  1627.258     0.150
   120.012  1135.258     0.150
   120.012  1809.258     0.150
   120.134  1134.656     0.150
   120.524  1139.258     0.150
   120.524  1218.258     0.150
   120.524  1551.258     0.150
   120.645  1221.258     0.150
   121.187  1133.258     0.150
   120.834  1131.258     0.150
   121.580  1136.258     0.150
   121.580  1227.758     0.150
   121.580  1546.258     0.150
   121.842  1141.559     0.150
   122.788  1240.258     0.150
   122.941  1143.258     0.150
   122.941  1831.258     0.150
   123.192  1239.258     0.150
   123.967  1239.258     0.150
   123.967  1559.258     0.150
   124.565  1147.258     0.150
   124.565  1251.258     0.150
   125.200  1139.957     0.150
   125.135  1148.258     0.150
   125.371  1140.258     0.150
   126.035  1142.258     0.150
   126.035  1971.258     0.150
   126.088  1147.258     0.150
   126.088  1259.258     0.150
   129.543  1148.258     0.150
   129.948  1276.258     0.150
   130.507  1289.258     0.150
   130.507  1369.258     0.150
   130.507  1589.258     0.150
   130.382  1901.258     0.150
   130.749  1154.258     0.150
   130.749  1291.258     0.150
   131.434  1146.258     0.150
   131.939  1153.258     0.150
   132.173  1155.859     0.150
   132.173  1164.258     0.150
   132.332  1157.258     0.150
   132.661  1153.258     0.150
   132.729  1154.156     0.150
   132.968  1147.859     0.150
   132.968  1163.258     0.150
   132.968  1376.258     0.150
   133.434  1160.258     0.150
   133.456  1156.758     0.150
   133.944  1159.258     0.150
   134.065  1157.859     0.150
   134.446  1313.258     0.150
   134.780  1166.258     0.150
   136.436  1165.758     0.150
   136.436  1369.156     0.150
   136.914  1160.258     0.150
   136.908  1167.758     0.150
   137.429  1162.258     0.150
   137.403  1159.258     0.150
   137.639  1164.258     0.150
   138.229  1166.258     0.150
   138.339  1163.156     0.150
   138.339  1343.156     0.150
   138.307  1165.258     0.150
   138.993  1170.457     0.150
   139.694  1166.258     0.150
   139.769  1168.258     0.150
   139.769  1344.258     0.150
   139.886  1166.258     0.150
   141.260  1172.156     0.150
   141.553  1170.258     0.150
   141.243  1170.258     0.150
   141.569  1168.359     0.150
   142.040  1170.258     0.150
   142.410  1168.457     0.150
   142.294  1167.258     0.150
   143.087  1174.258     0.150
   143.087  1370.457     0.150
   143.557  1171.059     0.150
   143.946  1173.258     0.150
   144.134  1173.359     0.150
   144.797  1174.258     0.150
   144.801  1174.258     0.150
   144.801  1180.059     0.150
   144.801  1373.258     0.150
   144.953  1176.156     0.150
   146.560  1180.258     0.150
   147.572  1185.457     0.150
   147.660  1182.457     0.150
   147.660  1190.457     0.150
   147.660  1199.359     0.150
   148.145  1190.957     0.150
   148.613  1182.559     0.150
   148.440  1185.758     0.150
   150.079  1184.859     0.150
   150.680  1199.758     0.150
   151.387  1192.758     0.150
   151.963  1201.258     0.150
   151.963  1407.258     0.150
   151.963  1413.258     0.150
   151.963  1615.258     0.150
   151.963  2571.258     0.150
   151.963  1188.758     0.150
     3.265    49.883     0.150
     3.311    49.383     0.150
     3.764    55.883     0.150
     3.768    62.883     0.150
     3.768   101.883     0.150
     3.880    58.883     0.150
     3.880   105.883     0.150
     4.781    69.883     0.150
     4.781   120.883     0.150
     5.916    86.383     0.150
     7.284   105.883     0.150
    11.382   164.180     0.150
    12.808   182.883     0.150
    17.249   238.883     0.150
    18.507   256.883     0.150
    19.846   271.883     0.150
    20.605   279.883     0.150
    21.161   285.883     0.150
    21.171   286.883     0.150
    21.284   286.883     0.150
    21.368   287.883     0.150
    21.808   291.680     0.150
    21.844   291.883     0.150
    22.091   295.883     0.150
    22.308   297.680     0.150
    22.445   300.883     0.150
    22.503   298.883     0.150
    22.764   298.883     0.150
    24.022   314.883     0.150
    24.348   314.883     0.150
    24.096   314.383     0.150
    24.307   317.383     0.150
    24.409   318.984     0.150
    24.515   318.883     0.150
    25.168   324.383     0.150
    25.419   324.984     0.150
    25.422   327.484     0.150
    25.612   328.883     0.150
    26.136   332.180     0.150
    26.938   341.383     0.150
    28.938   357.984     0.150
    33.664   396.680     0.150
    36.163   419.383     0.150
    36.738   423.883     0.150
    45.274   495.883     0.150
    45.992   499.883     0.150
    50.334   532.883     0.150
    53.448   560.883     0.150
    53.952   560.883     0.150
    55.654   573.883     0.150
    66.857   650.883     0.150
    66.857     7.203     0.150
    68.919    11.203     0.150
    71.325   676.180     0.150
    79.940   726.984     0.150
    80.190   728.680     0.150
    80.366   729.781     0.150
    80.637   730.883     0.150
    80.760   731.984     0.150
    80.835   732.383     0.150
    84.494   750.984     0.150
    84.505   750.984     0.150
    84.595   751.484     0.150
    84.878   752.883     0.150
    85.238   755.883     0.150
    85.520   756.586     0.150
    85.586   756.281     0.150
    86.008   760.383     0.150
    86.777   762.383     0.150
    86.792   762.180     0.150
    87.147   764.086     0.150
    87.168   764.484     0.150
    87.213   764.383     0.150
    87.223   765.781     0.150
    87.480   765.586     0.150
    87.511   765.883     0.150
    87.723   766.680     0.150
    87.859   767.484     0.150
    88.049   767.984     0.150
    90.425   779.180     0.150
    95.216   802.781     0.150
    96.102   806.086     0.150
   134.206  1149.484     0.150
   144.871  1174.883     0.150
   144.854  1174.883     0.150
   144.854  1181.383     0.150
   144.854  1190.383     0.150
   145.944  1179.883     0.150
   147.578  1182.586     0.150
   148.671  1182.383     0.150
   150.318  1190.680     0.150
   152.021  1192.883     0.150
     1.484    22.641     0.150
     3.342    55.641     0.150
     3.342    89.641     0.150
     3.358    51.641     0.150
     3.820    59.141     0.150
     3.826    58.141     0.150
     3.832    59.641     0.150
     3.832   104.641     0.150
     3.918    59.340     0.150
     7.388   108.641     0.150
    11.290   163.641     0.150
    12.742   180.740     0.150
    17.148   239.840     0.150
    17.834   246.840     0.150
    18.111   250.041     0.150
    18.413   252.641     0.150
    18.927   258.541     0.150
    18.927   471.641     0.150
    19.118   270.641     0.150
    19.123   263.641     0.150
    19.723   270.641     0.150
    20.012   275.641     0.150
    20.193   278.141     0.150
    20.489   277.441     0.150
    20.482   277.641     0.150
    20.775   281.840     0.150
    20.858   278.441     0.150
    21.037   284.641     0.150
    21.048   283.641     0.150
    21.048   531.641     0.150
    21.163   285.641     0.150
    21.245   285.641     0.150
    21.481   285.041     0.150
    21.713   289.641     0.150
    21.750   289.840     0.150
    21.953   293.240     0.150
    21.969   293.641     0.150
    22.186   296.041     0.150
    22.379   297.641     0.150
    22.402   298.441     0.150
    22.681   297.240     0.150
    22.725   297.740     0.150
    23.342   303.740     0.150
    23.443   308.041     0.150
    23.899   314.041     0.150
    23.974   313.541     0.150
    24.191   316.141     0.150
    24.289   317.840     0.150
    24.393   313.740     0.150
    24.392   317.740     0.150
    24.461   318.641     0.150
    24.461   589.641     0.150
    24.441   318.641     0.150
    24.784   321.240     0.150
    25.046   323.840     0.150
    25.046   756.641     0.150
    25.242   325.941     0.150
    25.286   326.141     0.150
    25.298   326.840     0.150
    25.316   323.840     0.150
    25.495   328.441     0.150
    25.744   331.740     0.150
    26.008   333.240     0.150
    26.008   608.441     0.150
    26.021   333.340     0.150
    26.046   331.840     0.150
    26.816   340.541     0.150
    27.461   345.840     0.150
    27.533   342.441     0.150
    27.531   347.441     0.150
    28.111   349.840     0.150
    28.832   356.641     0.150
    32.309   385.641     0.150
    32.309   554.641     0.150
    32.314   384.641     0.150
    32.605   390.441     0.150
    32.677   392.541     0.150
    32.950   392.141     0.150
    33.594   396.240     0.150
    33.641   398.541     0.150
    34.005   402.641     0.150
    34.585   408.141     0.150
    34.797   409.641     0.150
    34.962   409.641     0.150
    35.492   412.641     0.150
    35.591   412.941     0.150
    36.061   419.041     0.150
    36.652   423.141     0.150
    36.690   422.941     0.150
    45.145   492.840     0.150
    45.161   493.740     0.150
    45.958   499.641     0.150
    48.349   521.641     0.150
    48.349   947.641     0.150
    48.546   522.941     0.150
    48.546     6.100     0.150
    48.546   943.641     0.150
    48.819   525.840     0.150
    50.331   533.641     0.150
    50.500   536.941     0.150
    53.315   559.340     0.150
    53.572   562.141     0.150
    53.846   560.740     0.150
    54.171   564.541     0.150
    54.192   564.740     0.150
    54.285   564.641     0.150
    55.540   573.641     0.150
    55.540   573.840     0.150
    56.003   577.641     0.150
    57.657   588.641     0.150
    58.239   592.441     0.150
    58.876   596.840     0.150
    59.484   602.840     0.150
    59.488   605.641     0.150
    63.644   630.141     0.150
    66.431   645.641     0.150
    66.969   651.240     0.150
    68.096   659.141     0.150
    68.096  1202.641     0.150
    68.096   811.641     0.150
    68.096  1260.641     0.150
    68.225   659.541     0.150
    69.030   664.941     0.150
    71.135   677.641     0.150
    71.135  1236.441     0.150
    71.262   675.441     0.150
    79.919   727.240     0.150
    80.344   730.041     0.150
    80.500   730.541     0.150
    80.611   731.840     0.150
    80.611  1339.840     0.150
    80.729  1343.641     0.150
    80.795   732.141     0.150
    80.815   732.840     0.150
    80.923   733.340     0.150
    81.561   736.641     0.150
    81.841   737.641     0.150
    82.430   931.641     0.150
    82.430  1357.641     0.150
    83.971  1370.641     0.150
    83.971  1364.641     0.150
    84.487   752.441     0.150
    84.499   752.240     0.150
    84.586   753.041     0.150
    84.870   754.340     0.150
    85.250   756.641     0.150
    85.250  1392.641     0.150
    85.450   756.441     0.150
    85.478   758.141     0.150
    85.482   756.340     0.150
    85.582   757.740     0.150
    85.680  1391.641     0.150
    86.487   762.840     0.150
    86.530   762.641     0.150
    86.609   762.641     0.150
    86.609   971.641     0.150
    86.609  1399.641     0.150
    86.692   762.641     0.150
    86.776   762.941     0.150
    86.788   763.240     0.150
    87.122   764.641     0.150
    87.122  1398.641     0.150
    87.144   764.340     0.150
    87.167   764.541     0.150
    87.208   764.441     0.150
    87.209   763.441     0.150
    87.226   765.041     0.150
    87.464   764.740     0.150
    87.475   765.641     0.150
    87.505   765.840     0.150
    87.564   766.641     0.150
    87.604   766.141     0.150
    87.649   766.441     0.150
    87.716   766.641     0.150
    87.721   766.840     0.150
    87.766   767.340     0.150
    87.851   767.441     0.150
    88.042   768.041     0.150
    88.217   769.641     0.150
    88.801   769.641     0.150
    89.061   773.441     0.150
    89.406   774.740     0.150
    89.720  1407.641     0.150
    89.720  1499.641     0.150
    90.069   777.641     0.150
    90.222   777.941     0.150
    90.587   780.441     0.150
    90.861   781.641     0.150
    90.861   783.641     0.150
    90.861  1423.641     0.150
    90.861  1508.641     0.150
    90.861  1803.641     0.150
    91.071   781.740     0.150
    91.117   784.141     0.150
    91.163  1419.641     0.150
    91.163  1519.641     0.150
    91.211   781.941     0.150
    91.221   782.041     0.150
    91.277   784.340     0.150
    92.010   787.441     0.150
    92.327   789.340     0.150
    92.442   788.740     0.150
    92.442  1422.641     0.150
    92.702   790.641     0.150
    92.727   790.641     0.150
    92.805   791.041     0.150
    93.279   792.641     0.150
    93.664   794.941     0.150
    94.533   798.641     0.150
    94.625  1438.641     0.150
    94.625  1483.641     0.150
    94.625  1557.641     0.150
    94.625  1851.641     0.150
    95.180   802.141     0.150
    95.197   802.041     0.150
    95.638   802.441     0.150
    95.638    11.000     0.150
    95.822   804.740     0.150
    96.083   807.041     0.150
    96.215   805.641     0.150
    96.215    12.000     0.150
    96.316   807.941     0.150
    96.886   810.641     0.150
    97.727   813.641     0.150
    97.727  1507.641     0.150
    97.727  1451.641     0.150
    98.470  1055.441     0.150
    99.463  1063.641     0.150
   125.991  1141.141     0.150
   126.003  1141.240     0.150
   126.842  1142.641     0.150
   130.354  1150.641     0.150
   131.106  1151.641     0.150
   133.581  1155.641     0.150
   133.581  1301.641     0.150
   133.581  1364.641     0.150
   134.339  1157.141     0.150
   137.544  1164.141     0.150
   143.554  1170.641     0.150
   143.957  1173.641     0.150
   144.764  1174.641     0.150
   144.764  1183.141     0.150
   144.792  1174.641     0.150
   145.819  1179.641     0.150
   147.350  1184.840     0.150
   147.453  1181.941     0.150
   148.583  1183.340     0.150
   151.165  1192.141     0.150
     1.310    22.736     0.150
     1.310    35.836     0.150
     3.595    55.336     0.150
     3.597    56.336     0.150
     4.062    61.836     0.150
     4.062   106.836     0.150
     4.074    62.336     0.150
     4.074   105.836     0.150
     4.072    63.336     0.150
     5.130    76.836     0.150
     6.265    92.836     0.150
     6.265   156.836     0.150
    11.291   163.836     0.150
    12.811   184.936     0.150
    17.119   239.836     0.150
    17.198   237.535     0.150
    17.943   247.836     0.150
    18.189   251.836     0.150
    19.020   259.836     0.150
    19.020   490.836     0.150
    18.980   262.836     0.150
    19.498   264.836     0.150
    19.716   271.836     0.150
    20.344   278.836     0.150
    20.896   283.836     0.150
    21.037   285.836     0.150
    21.109   285.836     0.150
    21.705   292.035     0.150
    21.842   293.836     0.150
    22.189   297.836     0.150
    22.571   301.836     0.150
    22.818   299.535     0.150
    22.850   299.936     0.150
    23.387   308.535     0.150
    23.620   311.637     0.150
    23.756   313.436     0.150
    23.842   313.137     0.150
    24.096   316.836     0.150
    24.175   317.637     0.150
    24.250   317.336     0.150
    24.582   318.035     0.150
    24.633   316.236     0.150
    24.915   323.436     0.150
    25.102   326.035     0.150
    25.158   326.436     0.150
    25.280   325.137     0.150
    26.157   328.936     0.150
    26.625   338.436     0.150
    26.690   340.137     0.150
    27.540   342.336     0.150
    27.710   343.936     0.150
    28.785   357.535     0.150
    28.899   361.436     0.150
    33.933   402.836     0.150
    35.644   415.336     0.150
    36.670   424.736     0.150
    36.847   425.336     0.150
    46.090   501.336     0.150
    48.723   524.836     0.150
    50.679   539.436     0.150
    53.800   560.836     0.150
    54.086   564.637     0.150
    58.869   597.035     0.150
    71.336   677.236     0.150
    80.970   733.836     0.150
    84.662   753.936     0.150
    84.676   753.736     0.150
    84.761   754.436     0.150
    85.044   755.936     0.150
    86.960   765.236     0.150
    87.352   767.236     0.150
    87.416   767.535     0.150
    87.654   767.436     0.150
    88.026   769.035     0.150
   144.825  1173.836     0.150
   148.592  1186.836     0.150
   150.012  1191.336     0.150
   151.941  1195.836     0.150
     3.172    47.750     0.150
     3.207    49.250     0.150
     3.661    57.750     0.150
     3.666    56.250     0.150
     3.666    99.250     0.150
     3.679    57.250     0.150
     3.679    98.750     0.150
     4.366    65.750     0.150
     4.722    67.250     0.150
     4.722   119.250     0.150
     5.841    84.250     0.150
    10.733   153.750     0.150
    11.321   164.250     0.150
    11.683   166.750     0.150
    11.945   174.250     0.150
    12.114   173.750     0.150
    12.236   177.250     0.150
    12.291   175.750     0.150
    12.438   177.250     0.150
    12.725   181.250     0.150
    17.199   241.750     0.150
    17.202   243.020     0.150
    17.788   245.949     0.150
    18.088   250.852     0.150
    18.376   252.449     0.150
    18.498   257.250     0.150
    18.594   254.551     0.150
    18.893   257.750     0.150
    18.893   481.750     0.150
    19.246   267.250     0.150
    19.320   264.750     0.150
    19.843   274.250     0.150
    19.843   275.250     0.150
    20.024   276.250     0.150
    19.958   274.250     0.150
    20.127   271.750     0.150
    20.273   278.250     0.150
    20.319   275.352     0.150
    20.602   280.250     0.150
    20.890   282.250     0.150
    21.158   286.250     0.150
    21.170   287.250     0.150
    21.274   287.250     0.150
    21.398   283.949     0.150
    21.363   287.250     0.150
    21.785   292.250     0.150
    22.439   298.250     0.150
    22.506   300.250     0.150
    22.614   297.250     0.150
    22.667   298.250     0.150
    24.290   317.051     0.150
    24.283   317.449     0.150
    24.394   318.750     0.150
    24.906   324.250     0.150
    25.160   599.051     0.150
    25.160   325.039     0.150
    25.371   325.250     0.150
    25.361   326.949     0.150
    25.564   325.449     0.150
    25.589   328.750     0.150
    26.128   336.750     0.150
    26.928   340.949     0.150
    27.434   341.250     0.150
    27.571   348.551     0.150
    29.540   366.250     0.150
    29.656   362.250     0.150
    29.656   670.250     0.150
    30.062   371.250     0.150
    30.909   377.250     0.150
    31.608   383.250     0.150
    32.283   386.250     0.150
    32.381   387.250     0.150
    32.503   390.352     0.150
    32.696   391.754     0.150
    34.082   405.250     0.150
    35.413   413.250     0.150
    36.114   418.750     0.150
    36.607   423.250     0.150
    36.670   423.250     0.150
    38.107   439.051     0.150
    39.900   452.750     0.150
    45.188   493.250     0.150
    45.204   494.051     0.150
    45.219   494.352     0.150
    45.894   499.250     0.150
    48.207   520.352     0.150
    48.406     7.000     0.150
    48.678   524.750     0.150
    50.229   532.250     0.150
    50.357   535.648     0.150
    51.326   542.250     0.150
    53.436   561.352     0.150
    53.436     7.000     0.150
    53.907   560.250     0.150
    53.906   562.750     0.150
    54.113   562.750     0.150
    54.264   565.250     0.150
    54.285   565.250     0.150
    54.859   570.250     0.150
    55.623   574.250     0.150
    55.623   574.559     0.150
    55.623   574.352     0.150
    55.872   576.250     0.150
    56.802   582.051     0.150
    58.323   592.949     0.150
    58.911   596.250     0.150
    59.050   601.250     0.150
    59.077   600.250     0.150
    59.376   602.148     0.150
    59.684   604.852     0.150
    66.798     7.699     0.150
    68.071     9.898     0.150
    68.183   659.352     0.150
    68.183     8.898     0.150
    68.183  1221.250     0.150
    68.859   664.449     0.150
    68.859     6.801     0.150
    71.240   677.750     0.150
    78.648   722.250     0.150
    79.543   724.852     0.150
    79.788   726.051     0.150
    79.838   726.449     0.150
    80.733   731.949     0.150
    80.707   732.250     0.150
    80.707   732.449     0.150
    80.707     7.500     0.150
    81.442   736.949     0.150
    84.034   748.250     0.150
    84.034     8.000     0.150
    84.034  1368.250     0.150
    84.389   750.949     0.150
    84.400   750.852     0.150
    84.489   751.352     0.150
    84.653   754.250     0.150
    84.773   752.750     0.150
    85.047   755.250     0.150
    85.131   756.250     0.150
    85.386   756.750     0.150
    85.423   755.648     0.150
    85.480   756.750     0.150
    85.654   759.250     0.150
    85.712   759.148     0.150
    86.362   763.750     0.150
    86.398   763.250     0.150
    86.671   762.250     0.150
    86.687   761.750     0.150
    86.939   761.352     0.150
    87.031   765.250     0.150
    87.041   763.852     0.150
    87.062   764.148     0.150
    87.107   763.949     0.150
    87.116   764.352     0.150
    87.177   764.551     0.150
    87.374   765.051     0.150
    87.405   765.148     0.150
    87.419   764.352     0.150
    87.480   766.250     0.150
    87.480    11.000     0.150
    87.516   765.750     0.150
    87.516    12.500     0.150
    87.545   765.949     0.150
    87.618   766.051     0.150
    87.631   766.750     0.150
    87.632   767.750     0.150
    87.754   766.852     0.150
    87.944   767.352     0.150
    87.998   768.352     0.150
    88.127   770.250     0.150
    88.967   771.949     0.150
    89.312   774.051     0.150
    89.344   774.051     0.150
    89.682   776.250     0.150
    90.153   778.051     0.150
    90.319   779.750     0.150
    90.777   781.750     0.150
    91.114   783.250     0.150
    91.929   787.750     0.150
    91.929     9.500     0.150
    92.474   790.449     0.150
    92.474     5.801     0.150
    92.620   791.250     0.150
    92.723   791.250     0.150
    93.200   793.750     0.150
    93.573   795.250     0.150
    94.638   800.449     0.150
    94.638  1023.750     0.150
    95.113   803.051     0.150
    95.561   804.250     0.150
    95.561   804.148     0.150
    95.561     7.000     0.150
    95.653   804.250     0.150
    96.000   807.250     0.150
    96.137   807.250     0.150
    96.237   808.852     0.150
    96.743   812.750     0.150
    97.649   815.250     0.150
    97.649   829.551     0.150
    97.649   816.051     0.150
    98.546   817.250     0.150
    98.546   817.852     0.150
   101.343   830.750     0.150
   126.147  1137.250     0.150
   126.147  1142.250     0.150
   126.157  1142.449     0.150
   126.168  1142.250     0.150
   131.091  1151.250     0.150
   134.019  1157.051     0.150
   134.415  1158.250     0.150
   143.558  1170.750     0.150
   144.791  1174.449     0.150
   144.791  1175.949     0.150
   144.791  1182.250     0.150
   144.791  1395.750     0.150
   144.798  1173.250     0.150
   144.875  1176.250     0.150
   146.562  1180.750     0.150
   147.504  1184.250     0.150
   147.597  1181.750     0.150
   147.597  1189.449     0.150
   148.606  1183.750     0.150
   150.018  1192.852     0.150
   150.337  1190.250     0.150
   151.956  1189.250     0.150
   152.032  1193.051     0.150
     1.220    22.715     0.150
     1.401    24.314     0.150
     1.401    44.215     0.150
     2.205    35.715     0.150
     2.480    41.715     0.150
     2.480    77.715     0.150
     3.471    53.215     0.150
     3.515    52.715     0.150
     3.941    60.715     0.150
     3.949    60.715     0.150
     4.013    60.715     0.150
     4.677    69.215     0.150
     6.231    91.516     0.150
    10.718   153.715     0.150
    10.718   272.715     0.150
    11.102   161.914     0.150
    11.102   161.715     0.150
    11.135   160.414     0.150
    11.191   162.715     0.150
    12.400   177.715     0.150
    12.609   181.215     0.150
    12.516   179.414     0.150
    12.590   179.965     0.150
    12.615   184.064     0.150
    12.638   181.215     0.150
    12.694   181.715     0.150
    12.820   183.715     0.150
    12.843   184.314     0.150
    13.279   188.715     0.150
    13.431   191.715     0.150
    13.991   198.715     0.150
    16.940   238.115     0.150
    16.940   436.715     0.150
    16.976   240.814     0.150
    17.987   248.414     0.150
    18.132   252.715     0.150
    18.306   251.914     0.150
    18.290   257.176     0.150
    18.596   260.395     0.150
    18.773   257.615     0.150
    18.818   474.715     0.150
    18.782   260.715     0.150
    18.866   261.715     0.150
    19.296   262.215     0.150
    19.466   267.715     0.150
    19.590   267.715     0.150
    20.254   278.215     0.150
    20.386   280.016     0.150
    20.520   278.715     0.150
    20.656   278.516     0.150
    20.780   282.715     0.150
    20.791   282.715     0.150
    20.909   283.715     0.150
    20.989   283.715     0.150
    21.519   286.914     0.150
    21.556   288.715     0.150
    21.556   287.516     0.150
    21.715   291.715     0.150
    21.898   293.715     0.150
    22.067   295.715     0.150
    22.121   295.715     0.150
    22.444   298.715     0.150
    22.650   297.516     0.150
    22.650   296.715     0.150
    22.636   300.715     0.150
    22.666   303.016     0.150
    22.666   547.516     0.150
    23.319   304.016     0.150
    23.273   308.516     0.150
    23.642   312.115     0.150
    23.719   311.314     0.150
    23.948   313.715     0.150
    24.039   315.715     0.150
    24.134   316.016     0.150
    24.183   316.715     0.150
    24.402   313.314     0.150
    24.527   318.715     0.150
    24.698   319.516     0.150
    24.698   583.516     0.150
    24.791   321.615     0.150
    24.791   980.715     0.150
    25.103   322.715     0.150
    25.029   324.414     0.150
    25.041   324.516     0.150
    25.251   326.516     0.150
    25.574   329.414     0.150
    25.861   331.016     0.150
    25.751   330.715     0.150
    25.751   606.715     0.150
    25.764   330.814     0.150
    26.563   338.016     0.150
    27.097   340.715     0.150
    27.209   343.516     0.150
    27.525   343.715     0.150
    27.856   349.715     0.150
    27.858   348.115     0.150
    28.503   354.615     0.150
    28.613   355.314     0.150
    28.666   355.914     0.150
    28.767   354.016     0.150
    28.819   357.215     0.150
    28.775   358.715     0.150
    29.328   362.115     0.150
    29.692   363.414     0.150
    29.692   670.814     0.150
    30.323   373.615     0.150
    30.652   370.314     0.150
    30.476   373.215     0.150
    30.981   372.414     0.150
    31.025   373.215     0.150
    31.259   380.715     0.150
    31.314   380.215     0.150
    31.386   382.715     0.150
    31.478   383.215     0.150
    31.478   691.715     0.150
    31.899   389.215     0.150
    32.080   384.715     0.150
    32.199   385.414     0.150
    32.364   388.885     0.150
    32.364     7.859     0.150
    32.364   389.029     0.150
    32.742   389.715     0.150
    32.899   395.016     0.150
    33.134   391.715     0.150
    33.454   396.324     0.150
    33.454     8.201     0.150
    33.391   398.914     0.150
    33.725   397.115     0.150
    33.772   400.715     0.150
    34.557   408.914     0.150
    35.449   412.115     0.150
    35.557   414.016     0.150
    35.850   417.215     0.150
    35.873   420.715     0.150
    36.477   421.914     0.150
    36.654   422.215     0.150
    37.765   435.715     0.150
    38.452   441.115     0.150
    38.489   441.715     0.150
    39.141   442.715     0.150
    39.141   443.516     0.150
    39.327   450.115     0.150
    39.647   452.715     0.150
    39.930   453.715     0.150
    40.039   454.715     0.150
    40.375   458.215     0.150
    41.102   462.914     0.150
    41.503   468.314     0.150
    41.574   470.516     0.150
    44.942   491.715     0.150
    44.959   493.025     0.150
    44.959     8.109     0.150
    45.605   500.615     0.150
    45.891   499.516     0.150
    46.454   507.715     0.150
    48.610   523.715     0.150
    48.610   522.322     0.150
    49.080   526.615     0.150
    50.328   533.215     0.150
    50.312   537.115     0.150
    51.493   548.715     0.150
    52.494   553.516     0.150
    52.494  1001.516     0.150
    53.074   557.516     0.150
    53.550   560.115     0.150
    53.628   559.516     0.150
    53.929   562.615     0.150
    53.949   562.615     0.150
    53.949   562.914     0.150
    54.520   566.215     0.150
    54.462   566.715     0.150
    54.761   572.715     0.150
    54.828   573.016     0.150
    55.304   572.275     0.150
    55.304     7.779     0.150
    55.304  1038.715     0.150
    55.304   572.051     0.150
    55.304   572.016     0.150
    54.979   574.414     0.150
    55.054   574.914     0.150
    56.263   583.516     0.150
    56.457   580.115     0.150
    57.413   587.016     0.150
    57.600   591.016     0.150
    58.002   590.814     0.150
    57.716   593.715     0.150
    59.378   600.314     0.150
    59.378   734.715     0.150
    59.378  1089.715     0.150
    59.378   600.018     0.150
    59.388   602.414     0.150
    59.411   602.215     0.150
    59.436   602.215     0.150
    59.736   604.715     0.150
    59.736     8.199     0.150
    59.997   606.715     0.150
    60.023   606.715     0.150
    60.039   606.414     0.150
    60.204   607.715     0.150
    61.594   615.016     0.150
    62.142   621.016     0.150
    63.984   632.314     0.150
    64.007   633.314     0.150
    66.271   644.715     0.150
    67.523   656.715     0.150
    67.523  1191.115     0.150
    67.856   657.414     0.150
    67.856  1196.715     0.150
    67.856   682.715     0.150
    67.856   808.715     0.150
    67.856  1258.715     0.150
    68.070   658.715     0.150
    67.881   662.715     0.150
    67.881    10.000     0.150
    67.881  1206.715     0.150
    67.881  1233.715     0.150
    67.881  1464.715     0.150
    68.483   660.715     0.150
    68.483   661.016     0.150
    68.483    12.000     0.150
    69.374   666.715     0.150
    69.265   666.914     0.150
    69.265   668.814     0.150
    69.265     8.801     0.150
    69.329   668.914     0.150
    69.987   673.615     0.150
    70.059   669.715     0.150
    69.951   671.615     0.150
    69.951   674.615     0.150
    69.951    10.100     0.150
    69.951   696.414     0.150
    70.549   672.115     0.150
    70.549   697.914     0.150
    71.134   674.914     0.150
    71.556   680.414     0.150
    71.556   681.615     0.150
    71.374   674.414     0.150
    71.392   679.914     0.150
    74.782   880.715     0.150
    74.782  1564.715     0.150
    76.912   711.715     0.150
    77.659   716.715     0.150
    77.659   898.715     0.150
    78.526   720.516     0.150
    79.611   725.215     0.150
    79.853   726.115     0.150
    79.877   727.016     0.150
    79.907   726.516     0.150
    80.125   728.615     0.150
    80.301   729.814     0.150
    80.459   730.914     0.150
    80.468   730.914     0.150
    80.366   730.715     0.150
    80.366  1339.715     0.150
    80.366   916.715     0.150
    80.574   731.414     0.150
    80.472   732.715     0.150
    80.472  1338.715     0.150
    80.698   731.914     0.150
    80.756   731.715     0.150
    80.773   734.016     0.150
    80.881   732.715     0.150
    80.887   733.715     0.150
    80.887  1342.715     0.150
    80.887   924.715     0.150
    81.128   734.914     0.150
    81.589   736.215     0.150
    81.589  1356.715     0.150
    81.881   738.814     0.150
    81.996   740.016     0.150
    82.181   740.314     0.150
    82.181   745.715     0.150
    82.181  1358.314     0.150
    82.181  1670.715     0.150
    82.574   742.215     0.150
    82.709   742.715     0.150
    82.709  1362.314     0.150
    82.709   934.715     0.150
    82.709  1354.715     0.150
    82.709  1409.914     0.150
    83.037   744.215     0.150
    83.136   746.215     0.150
    83.270   749.215     0.150
    83.463   747.615     0.150
    83.750   746.215     0.150
    83.750   750.715     0.150
    83.750  1364.715     0.150
    84.026   750.715     0.150
    84.113   750.715     0.150
    84.476   750.414     0.150
    84.573   750.715     0.150
    84.790   754.715     0.150
    84.790  1387.715     0.150
    84.848   754.215     0.150
    84.857   752.314     0.150
    84.948   754.715     0.150
    85.077   755.215     0.150
    85.279   755.715     0.150
    85.279   962.715     0.150
    85.279  1392.715     0.150
    85.381   756.814     0.150
    85.381   756.057     0.150
    85.406   755.615     0.150
    85.494   758.215     0.150
    85.559   756.715     0.150
    85.696   757.115     0.150
    85.716   758.715     0.150
    85.716     6.000     0.150
    86.069   760.715     0.150
    86.069   954.715     0.150
    86.069  1386.715     0.150
    85.826     8.000     0.150
    86.527   763.914     0.150
    86.576   762.715     0.150
    86.576   964.715     0.150
    86.576  1400.715     0.150
    86.576  1742.715     0.150
    86.588   763.215     0.150
    86.588     9.500     0.150
    86.584   762.414     0.150
    86.665   763.814     0.150
    86.665   766.115     0.150
    86.665   970.715     0.150
    86.665  1388.715     0.150
    86.665  1401.715     0.150
    86.665  1408.715     0.150
    86.703   763.016     0.150
    86.742   763.914     0.150
    86.777   762.715     0.150
    86.783   762.914     0.150
    86.833   764.715     0.150
    86.923   762.414     0.150
    87.086   764.715     0.150
    87.097   765.016     0.150
    87.097   969.715     0.150
    87.097  1392.715     0.150
    87.097  1416.715     0.150
    87.095   763.414     0.150
    87.095     7.201     0.150
    87.144   764.715     0.150
    87.170   765.215     0.150
    87.202   764.914     0.150
    87.456   766.115     0.150
    87.498   766.115     0.150
    87.529   766.215     0.150
    87.575   766.715     0.150
    87.649   767.215     0.150
    87.692   767.715     0.150
    87.692   769.115     0.150
    87.706   767.016     0.150
    87.721   766.814     0.150
    87.776   768.814     0.150
    87.839   767.914     0.150
    88.031   768.414     0.150
    88.087   768.615     0.150
    88.175   768.814     0.150
    88.182   769.814     0.150
    88.182   984.715     0.150
    88.193   769.615     0.150
    88.193   972.715     0.150
    88.193  1398.715     0.150
    88.193  1422.715     0.150
    88.198   769.115     0.150
    88.198  1400.715     0.150
    88.407   772.715     0.150
    88.673   771.715     0.150
    88.731   772.314     0.150
    88.722   770.914     0.150
    88.722  1401.715     0.150
    88.722  1411.715     0.150
    88.722   771.016     0.150
    88.722   772.814     0.150
    88.762   771.516     0.150
    88.762   773.516     0.150
    88.762  1410.715     0.150
    88.762   979.715     0.150
    88.762  1400.715     0.150
    89.043   773.615     0.150
    89.260   774.516     0.150
    89.260   983.715     0.150
    89.260  1422.715     0.150
    89.361   773.914     0.150
    89.388   775.215     0.150
    89.415   775.215     0.150
    89.521   775.516     0.150
    89.584   776.314     0.150
    89.614   774.715     0.150
    89.614   978.715     0.150
    89.614  1416.715     0.150
    89.856   776.715     0.150
    89.832   777.314     0.150
    89.832  1405.414     0.150
    89.986   778.314     0.150
    90.099   778.314     0.150
    90.123   778.016     0.150
    89.932   778.715     0.150
    89.932   993.715     0.150
    90.265   780.215     0.150
    90.410   780.016     0.150
    90.437   780.516     0.150
    90.509   781.615     0.150
    90.587   782.215     0.150
    90.587   782.814     0.150
    90.761   782.215     0.150
    90.824   780.715     0.150
    90.824     9.500     0.150
    90.824   997.715     0.150
    90.824  1412.715     0.150
    90.824  1512.715     0.150
    90.824  1812.715     0.150
    90.914   784.016     0.150
    91.085   783.715     0.150
    91.085  1422.516     0.150
    91.084   783.164     0.150
    91.084     8.271     0.150
    91.084   783.393     0.150
    91.073   781.715     0.150
    91.121   783.715     0.150
    91.180   784.715     0.150
    91.190   784.814     0.150
    91.210   784.016     0.150
    91.222   783.814     0.150
    91.236   783.115     0.150
    91.236     7.600     0.150
    91.236  1413.715     0.150
    91.448   785.615     0.150
    91.620   787.215     0.150
    91.867   787.715     0.150
    91.941   788.314     0.150
    91.970   787.215     0.150
    91.970     6.500     0.150
    91.970  1422.715     0.150
    91.970  1434.715     0.150
    91.970  1814.715     0.150
    91.970  1518.715     0.150
    92.119   782.715     0.150
    92.295   788.814     0.150
    92.250   787.715     0.150
    92.250  1005.715     0.150
    92.250  1422.715     0.150
    92.250  1814.715     0.150
    92.274   789.414     0.150
    92.274  1453.715     0.150
    92.274  1011.715     0.150
    92.274  1524.715     0.150
    92.664   789.715     0.150
    92.700   790.715     0.150
    92.700  1013.715     0.150
    92.767   790.715     0.150
    92.767     8.500     0.150
    92.767  1010.715     0.150
    92.767  1426.715     0.150
    92.767  1536.715     0.150
    93.034   792.914     0.150
    93.113   792.115     0.150
    93.163   791.215     0.150
    93.235   792.715     0.150
    93.575   794.814     0.150
    93.575  1012.715     0.150
    93.639   795.115     0.150
    93.639  1017.016     0.150
    93.639  1021.215     0.150
    93.639  1450.715     0.150
    93.635   793.715     0.150
    93.635   794.715     0.150
    93.635  1458.715     0.150
    93.635  1018.715     0.150
    93.635  1430.715     0.150
    93.635  1540.715     0.150
    93.635  1830.715     0.150
    93.762   795.016     0.150
    93.762  1018.715     0.150
    94.058   795.715     0.150
    94.058  1432.715     0.150
    94.103   796.215     0.150
    94.103  1023.715     0.150
    94.511   798.715     0.150
    94.511  1022.715     0.150
    94.572   798.715     0.150
    94.604   799.715     0.150
    94.604  1430.715     0.150
    94.604  1542.715     0.150
    94.665   801.715     0.150
    94.666   798.715     0.150
    94.666  1027.715     0.150
    94.666  1435.715     0.150
    94.689   800.215     0.150
    94.689  1024.715     0.150
    94.689  1452.715     0.150
    94.689  1461.914     0.150
    94.804  1032.715     0.150
    94.804  1440.715     0.150
    94.370   799.016     0.150
    94.370  1038.715     0.150
    94.879  1436.715     0.150
    95.148   801.314     0.150
    95.161   802.115     0.150
    95.161     7.400     0.150
    95.253   803.215     0.150
    95.253  1030.715     0.150
    95.295   802.715     0.150
    95.295  1032.715     0.150
    95.590   803.516     0.150
    95.590   805.516     0.150
    95.590     7.500     0.150
    95.590  1036.715     0.150
    95.660   803.215     0.150
    95.852   805.215     0.150
    95.852  1442.715     0.150
    96.002   805.715     0.150
    95.983   806.414     0.150
    96.047   807.715     0.150
    96.047  1035.715     0.150
    96.047  1441.715     0.150
    96.169   806.715     0.150
    96.271   807.414     0.150
    96.271     8.102     0.150
    96.414   807.715     0.150
    96.414  1038.715     0.150
    96.414  1442.715     0.150
    96.414  1569.715     0.150
    96.502   809.715     0.150
    96.033   808.715     0.150
    96.033  1446.715     0.150
    96.033  1487.715     0.150
    96.033  1506.715     0.150
    96.033  1562.715     0.150
    96.630   808.715     0.150
    96.630   811.715     0.150
    97.168   810.715     0.150
    97.168  1044.715     0.150
    97.681   814.516     0.150
    97.681  1052.715     0.150
    97.681  1452.715     0.150
    97.681  1582.715     0.150
    97.807   813.715     0.150
    97.807  1051.715     0.150
    97.807  1447.715     0.150
    98.295   816.715     0.150
    98.842   814.715     0.150
    98.842   815.016     0.150
    99.025   817.814     0.150
    99.025  1065.516     0.150
    99.025  1454.516     0.150
    99.025  1601.516     0.150
    99.181   817.715     0.150
    99.246   819.715     0.150
    99.246  1512.715     0.150
    99.246  1061.715     0.150
    99.246  1458.715     0.150
    99.298   823.715     0.150
    99.368  1512.715     0.150
    99.368  1058.715     0.150
    99.368  1458.715     0.150
    99.368  1602.715     0.150
    99.384   823.715     0.150
    99.912   823.215     0.150
   100.207   824.715     0.150
   100.714   830.215     0.150
   100.538   827.215     0.150
   100.538   834.834     0.150
   100.538   828.715     0.150
   100.538  1520.715     0.150
   100.799   828.715     0.150
   100.799  1530.715     0.150
   100.799  1072.715     0.150
   101.293   829.516     0.150
   101.293  1078.715     0.150
   101.293  1463.715     0.150
   101.293  1622.715     0.150
   101.293  1952.715     0.150
   101.170   829.715     0.150
   101.170  1468.715     0.150
   101.422   828.414     0.150
   101.512   833.715     0.150
   101.772   832.715     0.150
   101.951   832.715     0.150
   102.065   831.715     0.150
   102.065  1082.715     0.150
   102.361   835.914     0.150
   102.400   832.715     0.150
   102.400   833.215     0.150
   102.406   838.715     0.150
   102.878   837.715     0.150
   102.968   837.715     0.150
   103.818   840.715     0.150
   103.947   842.715     0.150
   104.044   842.715     0.150
   104.044  1554.715     0.150
   104.044   843.215     0.150
   104.044  1482.715     0.150
   104.044  1644.715     0.150
   104.092  1483.715     0.150
   104.092  1645.715     0.150
   103.951   842.715     0.150
   105.232   850.715     0.150
   105.909   849.715     0.150
   105.909  1660.715     0.150
   105.844   850.715     0.150
   105.865   850.715     0.150
   106.238   850.715     0.150
   106.305   853.715     0.150
   106.305  1116.715     0.150
   106.431   853.715     0.150
   106.431  1116.715     0.150
   107.059   853.914     0.150
   107.305   857.814     0.150
   107.853   862.215     0.150
   107.853  1494.715     0.150
   107.670  1686.715     0.150
   108.383   861.215     0.150
   109.735   864.715     0.150
   109.735  1509.715     0.150
   109.735  1706.715     0.150
   110.793   872.715     0.150
   111.447  1157.715     0.150
   111.638   877.314     0.150
   111.638  1723.314     0.150
   112.460   877.715     0.150
   112.460  1158.715     0.150
   112.460  1732.715     0.150
   112.873   881.715     0.150
   112.988   884.914     0.150
   113.394   884.314     0.150
   113.394  1741.314     0.150
   113.394  1745.314     0.150
   113.434   883.715     0.150
   113.434  1175.715     0.150
   113.445   883.715     0.150
   113.817   886.715     0.150
   113.817  1172.715     0.150
   113.826   886.715     0.150
   113.865   887.715     0.150
   114.576   890.715     0.150
   114.960   891.715     0.150
   115.161   892.715     0.150
   115.090   893.715     0.150
   115.090  1179.715     0.150
   115.090  1764.715     0.150
   114.840  1527.715     0.150
   114.840  1762.715     0.150
   114.840  2136.715     0.150
   115.068   892.715     0.150
   115.922   894.715     0.150
   115.922  1184.715     0.150
   115.922  1536.715     0.150
   115.922  1766.715     0.150
   115.842   896.715     0.150
   115.842  1182.715     0.150
   116.265   897.715     0.150
   117.099  1197.715     0.150
   117.099  1782.715     0.150
   117.099  2172.715     0.150
   117.496  1190.715     0.150
   118.317  1207.715     0.150
   118.805  1207.715     0.150
   118.805  1344.715     0.150
   118.805  1556.715     0.150
   118.882  1547.715     0.150
   118.882  2202.715     0.150
   118.756   909.715     0.150
   119.248   908.715     0.150
   119.248  1129.215     0.150
   119.248  1208.715     0.150
   119.248  1546.715     0.150
   119.248  1798.715     0.150
   119.248  2182.715     0.150
   119.615  1131.715     0.150
   119.615   912.715     0.150
   119.615  1130.715     0.150
   119.581  1557.715     0.150
   119.733   915.715     0.150
   119.733  1130.715     0.150
   119.733  1559.715     0.150
   119.912  1131.715     0.150
   119.912  1213.715     0.150
   119.912  1547.715     0.150
   119.912  1791.715     0.150
   119.912  1799.715     0.150
   120.272  1560.715     0.150
   120.272  1622.715     0.150
   120.372  1131.715     0.150
   120.372  1211.715     0.150
   120.372  1551.715     0.150
   120.676  1129.715     0.150
   120.676  1130.115     0.150
   121.066  1131.715     0.150
   120.909   920.715     0.150
   121.211  1134.715     0.150
   121.211  1134.914     0.150
   121.211  1553.715     0.150
   121.449  1134.715     0.150
   121.449  1223.715     0.150
   121.515  1131.715     0.150
   121.515  1224.715     0.150
   121.515  1545.715     0.150
   121.515  1815.715     0.150
   121.338   918.715     0.150
   121.708  1132.715     0.150
   121.708  1133.414     0.150
   121.708  1544.715     0.150
   122.590  1137.715     0.150
   122.785  1134.715     0.150
   122.785  1135.516     0.150
   122.785  1568.516     0.150
   123.048  1137.715     0.150
   123.048  1138.215     0.150
   123.048  1232.715     0.150
   123.048  1832.715     0.150
   123.816  1136.715     0.150
   123.816  1137.516     0.150
   123.816  1564.615     0.150
   124.141  1246.215     0.150
   124.401  1130.516     0.150
   124.745  1141.516     0.150
   124.745  1247.715     0.150
   124.893   936.715     0.150
   124.893  1141.715     0.150
   124.893  1246.715     0.150
   125.146  1140.715     0.150
   125.530  1141.715     0.150
   125.544  1136.715     0.150
   125.638  1253.715     0.150
   125.638  1564.715     0.150
   125.655  1140.715     0.150
   125.655  1251.715     0.150
   125.751  1250.715     0.150
   125.842  1141.715     0.150
   125.853  1141.615     0.150
   127.000  1143.715     0.150
   129.802  1148.715     0.150
   130.103   960.715     0.150
   130.103  1148.715     0.150
   130.103  1281.715     0.150
   130.333  1153.914     0.150
   130.522  1572.715     0.150
   130.522  1895.715     0.150
   130.968  1153.414     0.150
   130.968  1280.715     0.150
   130.968  1363.215     0.150
   132.254  1152.715     0.150
   132.254  1297.215     0.150
   133.214  1156.115     0.150
   133.401  1302.715     0.150
   133.401  1367.215     0.150
   133.401  1723.715     0.150
   133.424  1148.215     0.150
   133.424  1371.715     0.150
   133.697  1160.215     0.150
   134.326  1152.715     0.150
   134.530  1155.914     0.150
   134.530  1374.715     0.150
   135.041  1159.215     0.150
   135.308  1161.016     0.150
   136.218  1154.715     0.150
   136.509  1156.715     0.150
   136.509  1324.715     0.150
   137.269  1166.715     0.150
   137.292  1162.516     0.150
   138.215  1163.215     0.150
   138.581  1163.615     0.150
   139.270  1167.615     0.150
   140.840  1165.715     0.150
   140.781  1164.715     0.150
   140.965  1169.715     0.150
   141.976  1168.715     0.150
   142.007  1166.715     0.150
   142.934  1170.715     0.150
   142.934  1171.215     0.150
   143.392  1180.914     0.150
   143.898  1173.715     0.150
   143.565  1171.715     0.150
   143.660  1174.414     0.150
   144.576  1173.715     0.150
   144.628  1172.715     0.150
   145.558  1178.715     0.150
   147.091  1184.016     0.150
   147.192  1183.715     0.150
   148.401  1187.115     0.150
   149.616  1195.715     0.150
   149.933  1185.715     0.150
   150.241  1189.215     0.150
   150.907  1187.715     0.150
   151.750  1189.715     0.150
   151.750  1409.715     0.150
   151.750  1413.715     0.150
   151.750  1616.715     0.150
   151.750  1821.715     0.150
   152.416  1192.715     0.150
     1.299    23.994     0.150
     2.098    33.994     0.150
     3.623    56.994     0.150
     3.670    55.994     0.150
     4.094    64.494     0.150
     4.094   120.494     0.150
     4.163    67.994     0.150
     4.163   127.494     0.150
     4.832    74.994     0.150
     4.832   145.994     0.150
    12.668   182.994     0.150
    14.134   202.094     0.150
    16.938   237.994     0.150
    18.049   249.594     0.150
    18.823   258.795     0.150
    18.889   257.895     0.150
    18.790   261.994     0.150
    19.371   263.395     0.150
    19.393   268.994     0.150
    19.524   268.994     0.150
    20.706   280.994     0.150
    20.716   280.994     0.150
    20.846   283.994     0.150
    20.918   285.994     0.150
    21.529   289.094     0.150
    21.567   290.994     0.150
    21.650   290.994     0.150
    21.998   294.994     0.150
    22.041   294.994     0.150
    22.740   297.994     0.150
    23.432   305.594     0.150
    23.566   311.295     0.150
    23.650   310.994     0.150
    23.983   315.193     0.150
    24.724   321.295     0.150
    24.968   324.494     0.150
    25.880   332.295     0.150
    26.498   338.295     0.150
    27.147   341.994     0.150
    27.794   347.193     0.150
    28.599   355.193     0.150
    28.707   359.693     0.150
    32.055   386.994     0.150
    33.505   397.295     0.150
    33.743   401.994     0.150
    35.288   412.994     0.150
    35.554   412.994     0.150
    35.666   414.295     0.150
    36.503   422.994     0.150
    36.761   424.094     0.150
    44.945   492.494     0.150
    44.961   493.295     0.150
    48.707   524.994     0.150
    48.905   524.994     0.150
    49.177   529.094     0.150
    51.325   542.994     0.150
    53.614   558.994     0.150
    55.269   571.994     0.150
    69.405   668.295     0.150
    69.405     6.500     0.150
    71.193   676.094     0.150
    80.882   732.994     0.150
    84.593   752.895     0.150
    84.690   753.494     0.150
    84.974   754.994     0.150
    85.043   753.994     0.150
    85.494   756.494     0.150
    85.621   755.994     0.150
    85.698   758.295     0.150
    86.205   761.994     0.150
    86.661   765.094     0.150
    86.727   764.494     0.150
    86.900   763.994     0.150
    86.903   764.193     0.150
    87.162   764.295     0.150
    87.209   766.594     0.150
    87.265   765.193     0.150
    87.292   765.494     0.150
    87.322   765.795     0.150
    87.361   766.094     0.150
    87.446   765.094     0.150
    87.575   766.395     0.150
    87.771   768.094     0.150
    87.823   767.693     0.150
    87.839   767.693     0.150
    87.956   768.494     0.150
    88.149   769.094     0.150
    89.686   775.994     0.150
    90.198   778.693     0.150
    91.153   783.994     0.150
   144.590  1174.494     0.150
   144.590  1181.994     0.150
   145.465  1178.994     0.150
   147.091  1183.494     0.150
   149.832  1190.994     0.150
     1.271    23.521     0.150
     2.542    46.021     0.150
     4.004    66.521     0.150
     4.012    60.021     0.150
     4.012   120.021     0.150
    16.997   238.322     0.150
    18.383   252.721     0.150
    18.890   262.021     0.150
    19.373   263.221     0.150
    19.491   269.021     0.150
    19.620   270.021     0.150
    20.805   283.021     0.150
    21.015   286.021     0.150
    21.580   290.521     0.150
    21.618   290.021     0.150
    21.745   292.021     0.150
    22.094   296.021     0.150
    22.729   298.521     0.150
    23.297   309.021     0.150
    23.398   304.521     0.150
    24.073   316.221     0.150
    24.159   316.021     0.150
    24.820   322.121     0.150
    25.067   324.822     0.150
    25.290   326.221     0.150
    26.593   339.031     0.150
    28.666   355.922     0.150
    32.128   386.521     0.150
    33.526   396.422     0.150
    33.819   402.021     0.150
    35.528   413.021     0.150
    35.637   414.322     0.150
    36.543   422.021     0.150
    36.733   423.521     0.150
    45.001   492.521     0.150
    45.017   493.121     0.150
    49.068   526.021     0.150
    53.680   560.021     0.150
    55.348   572.021     0.150
    66.340   645.521     0.150
    69.289   666.621     0.150
    69.289     7.701     0.150
    71.209   675.922     0.150
    84.555   752.621     0.150
    84.569   752.521     0.150
    84.652   753.221     0.150
    84.936   754.621     0.150
    85.049   754.021     0.150
    85.484   756.221     0.150
    85.656   758.221     0.150
    86.145   761.721     0.150
    86.856   764.221     0.150
    87.176   765.121     0.150
    87.176     9.100     0.150
    87.222   765.422     0.150
    87.248   765.822     0.150
    87.281   764.422     0.150
    87.314   765.621     0.150
    87.446   764.922     0.150
    87.534   765.922     0.150
    87.785   767.121     0.150
    87.918   767.922     0.150
    88.110   768.621     0.150
   144.639  1174.021     0.150
   145.572  1179.521     0.150
   147.201  1183.922     0.150
   149.942  1190.021     0.150
     1.229    20.326     0.150
     1.229    36.326     0.150
     3.605    52.025     0.150
     3.675    52.826     0.150
     4.078    59.326     0.150
     4.084    63.326     0.150
     4.115    59.727     0.150
     4.137    63.326     0.150
     4.826    69.826     0.150
     5.310    76.826     0.150
     6.405    91.326     0.150
     7.786   112.826     0.150
    11.025   160.025     0.150
    14.168   198.926     0.150
    16.844   234.326     0.150
    17.983   249.326     0.150
    18.295   249.426     0.150
    18.804   255.025     0.150
    18.804   476.326     0.150
    18.709   259.326     0.150
    19.287   259.727     0.150
    19.311   267.326     0.150
    19.440   266.326     0.150
    20.071   272.326     0.150
    20.368   275.326     0.150
    20.625   278.326     0.150
    20.635   278.326     0.150
    20.805   277.127     0.150
    20.761   279.326     0.150
    20.835   280.326     0.150
    21.435   285.326     0.150
    21.566   287.326     0.150
    21.914   291.326     0.150
    22.479   297.727     0.150
    22.662   295.326     0.150
    23.106   302.326     0.150
    23.366   302.326     0.150
    23.814   311.127     0.150
    24.470   312.926     0.150
    24.640   318.025     0.150
    25.002   320.025     0.150
    28.505   351.926     0.150
    31.962   382.326     0.150
    33.415   392.627     0.150
    36.409   419.326     0.150
    44.881   490.326     0.150
    45.907   496.326     0.150
    48.779   522.326     0.150
    48.976   524.025     0.150
    49.249   525.727     0.150
    50.181   534.127     0.150
    50.931   537.826     0.150
    53.520   556.326     0.150
    53.794   559.826     0.150
    53.815   559.627     0.150
    55.178   568.326     0.150
    55.178   568.826     0.150
    57.278   583.926     0.150
    57.875   587.926     0.150
    58.599   592.326     0.150
    61.478   611.926     0.150
    61.747   615.326     0.150
    67.385   651.926     0.150
    68.659   659.525     0.150
    71.105   673.727     0.150
    80.811   728.926     0.150
    84.529   750.127     0.150
    84.545   749.926     0.150
    84.626   750.727     0.150
    84.910   752.025     0.150
    85.534   754.326     0.150
    85.636   755.426     0.150
    86.157   759.025     0.150
    86.839   760.826     0.150
    86.841   761.127     0.150
    87.076   760.326     0.150
    87.204   762.127     0.150
    87.232   762.627     0.150
    87.259   762.525     0.150
    87.304   763.127     0.150
    87.363   761.326     0.150
    87.513   763.525     0.150
    87.734   766.627     0.150
    87.760   764.627     0.150
    87.776   764.127     0.150
    87.893   765.326     0.150
    88.085   765.926     0.150
    89.601   773.326     0.150
    90.115   775.426     0.150
    91.072   779.326     0.150
    95.199   799.326     0.150
   144.569  1171.326     0.150
   145.391  1176.326     0.150
   146.916  1180.725     0.150
   147.021  1180.525     0.150
   147.021  1187.326     0.150
   148.326  1182.826     0.150
   149.762  1186.928     0.150
   151.675  1192.326     0.150
     1.799    30.477     0.150
     2.722    73.375     0.150
     3.222    51.176     0.150
     3.680    57.176     0.150
     3.681    57.775     0.150
     3.695    58.176     0.150
     3.695   113.176     0.150
     3.789    58.676     0.150
     4.382    67.176     0.150
     4.489    77.275     0.150
     4.737    71.176     0.150
     5.838    85.176     0.150
     5.857    87.275     0.150
    11.321   165.275     0.150
    13.606   194.676     0.150
    17.197   241.176     0.150
    17.197   437.176     0.150
    17.200   242.326     0.150
    18.093   250.676     0.150
    18.382   253.477     0.150
    18.899   258.977     0.150
    18.914   259.477     0.150
    19.237   266.176     0.150
    19.858   274.176     0.150
    19.834   272.176     0.150
    20.039   277.176     0.150
    19.950   273.176     0.150
    20.288   280.176     0.150
    20.336   277.176     0.150
    20.882   283.875     0.150
    21.149   286.176     0.150
    21.161   286.176     0.150
    21.161   527.176     0.150
    21.161   735.176     0.150
    21.354   288.775     0.150
    21.408   285.176     0.150
    21.749   290.676     0.150
    21.785   292.076     0.150
    22.074   296.375     0.150
    22.302   298.875     0.150
    22.269   298.477     0.150
    22.430   299.176     0.150
    22.496   301.176     0.150
    22.675   298.076     0.150
    22.802   303.176     0.150
    23.263   304.477     0.150
    23.644   312.977     0.150
    24.012   315.775     0.150
    24.081   315.676     0.150
    24.305   317.176     0.150
    24.297   313.875     0.150
    24.277   317.375     0.150
    24.387   319.275     0.150
    24.504   319.775     0.150
    24.555   320.275     0.150
    24.897   323.176     0.150
    25.152   326.076     0.150
    25.369   326.275     0.150
    25.400   327.676     0.150
    25.410   328.176     0.150
    25.583   329.676     0.150
    25.945   333.576     0.150
    26.120   336.076     0.150
    26.132   335.176     0.150
    26.920   342.775     0.150
    27.127   341.176     0.150
    27.563   347.275     0.150
    28.215   351.076     0.150
    28.760   354.977     0.150
    28.891   358.576     0.150
    29.136   362.477     0.150
    29.555   366.176     0.150
    29.666   364.576     0.150
    30.968   372.676     0.150
    31.239   375.938     0.150
    31.601   383.176     0.150
    31.601   701.176     0.150
    32.288   386.176     0.150
    32.377   389.176     0.150
    32.518   391.875     0.150
    32.690   392.836     0.150
    33.587   397.375     0.150
    33.587   473.275     0.150
    34.078   404.176     0.150
    34.881   412.176     0.150
    35.423   412.176     0.150
    35.517   413.576     0.150
    36.112   420.176     0.150
    36.617   423.775     0.150
    36.672   424.176     0.150
    38.095   439.176     0.150
    45.187   493.676     0.150
    45.203   494.775     0.150
    45.218   494.875     0.150
    45.902   499.676     0.150
    48.219   521.477     0.150
    48.417   523.176     0.150
    48.689   525.176     0.150
    50.240   533.676     0.150
    50.369   536.775     0.150
    50.636   540.676     0.150
    51.332   542.176     0.150
    53.899   564.076     0.150
    53.904   561.176     0.150
    54.128   563.076     0.150
    54.258   566.176     0.150
    54.279   565.875     0.150
    55.618   575.477     0.150
    55.618  1047.176     0.150
    55.618   575.273     0.150
    55.618   575.275     0.150
    55.882   579.176     0.150
    57.745   590.275     0.150
    58.318   593.977     0.150
    58.910   597.176     0.150
    59.460   601.576     0.150
    62.214   621.676     0.150
    63.495   630.375     0.150
    63.583   630.676     0.150
    66.438   647.176     0.150
    66.813   651.676     0.150
    66.813     6.199     0.150
    66.813   680.875     0.150
    67.696   658.176     0.150
    68.084   659.477     0.150
    68.084     4.898     0.150
    68.178   660.676     0.150
    68.178  1203.176     0.150
    68.178   685.176     0.150
    68.178   810.176     0.150
    68.178  1263.176     0.150
    68.874   664.576     0.150
    68.874     6.900     0.150
    68.874     9.400     0.150
    69.201   666.676     0.150
    69.550   670.477     0.150
    69.550     5.600     0.150
    70.148   670.176     0.150
    70.124   671.176     0.150
    71.245   676.977     0.150
    71.586   681.275     0.150
    77.047   713.875     0.150
    77.595   715.875     0.150
    78.653   721.176     0.150
    79.554   726.477     0.150
    79.799   727.977     0.150
    79.849   726.775     0.150
    79.848   728.176     0.150
    80.098   729.775     0.150
    80.274   730.176     0.150
    80.429   731.576     0.150
    80.443   731.676     0.150
    80.545   732.275     0.150
    80.668   732.875     0.150
    80.723   732.676     0.150
    80.743   732.875     0.150
    80.701   733.176     0.150
    80.701  1341.176     0.150
    80.853   734.076     0.150
    80.842   733.176     0.150
    80.842  1344.176     0.150
    80.842  1351.176     0.150
    80.842  1661.176     0.150
    81.005   735.176     0.150
    81.068   735.676     0.150
    81.068  1355.176     0.150
    81.455   735.977     0.150
    81.455  1351.176     0.150
    82.526   742.176     0.150
    82.526  1359.176     0.150
    82.526   742.477     0.150
    82.526  1685.176     0.150
    82.893   745.176     0.150
    83.044   745.676     0.150
    83.083   746.176     0.150
    83.083   746.775     0.150
    83.148   746.775     0.150
    83.201   746.875     0.150
    83.551   748.576     0.150
    83.593   748.477     0.150
    83.936   748.375     0.150
    84.031   749.176     0.150
    84.031   755.176     0.150
    84.031  1379.176     0.150
    84.031  1369.176     0.150
    84.412   752.076     0.150
    84.501   752.676     0.150
    84.667   754.676     0.150
    84.784   753.977     0.150
    85.053   754.176     0.150
    85.053   756.375     0.150
    85.144   756.176     0.150
    85.144  1390.176     0.150
    85.395   757.977     0.150
    85.395   757.316     0.150
    85.492   757.375     0.150
    85.522   758.176     0.150
    85.659   756.375     0.150
    85.659  1390.176     0.150
    85.720   758.375     0.150
    85.914   760.176     0.150
    85.914  1387.176     0.150
    86.376   763.676     0.150
    86.412   763.176     0.150
    86.534   763.176     0.150
    86.534  1393.176     0.150
    86.534  1413.176     0.150
    86.534  1468.176     0.150
    86.614   762.176     0.150
    86.614  1400.176     0.150
    86.683   763.775     0.150
    86.698   763.275     0.150
    86.947   763.176     0.150
    87.042   765.477     0.150
    87.042  1410.176     0.150
    87.053   765.076     0.150
    87.074   765.477     0.150
    87.119   764.375     0.150
    87.129   764.977     0.150
    87.183   764.775     0.150
    87.372   765.275     0.150
    87.417   765.576     0.150
    87.426   765.676     0.150
    87.426   967.076     0.150
    87.490   767.176     0.150
    87.527   767.176     0.150
    87.630   766.576     0.150
    87.643   766.375     0.150
    87.643   768.375     0.150
    87.669   767.977     0.150
    87.765   767.375     0.150
    87.955   768.076     0.150
    88.009   767.977     0.150
    88.127   765.875     0.150
    88.138   770.676     0.150
    88.138  1426.176     0.150
    88.154   771.977     0.150
    88.668   773.176     0.150
    88.752   771.875     0.150
    88.752   978.176     0.150
    88.752  1403.176     0.150
    88.864   772.176     0.150
    88.864  1412.176     0.150
    88.864   772.875     0.150
    88.864   982.176     0.150
    88.864  1395.176     0.150
    88.864  1774.176     0.150
    88.978   773.275     0.150
    89.323   774.775     0.150
    89.354   774.977     0.150
    89.688   776.576     0.150
    89.688   985.176     0.150
    89.688  1409.176     0.150
    90.190   780.176     0.150
    90.148   779.977     0.150
    90.148  1437.176     0.150
    90.186   778.775     0.150
    90.331   779.977     0.150
    90.313   780.176     0.150
    90.376   780.576     0.150
    90.445   780.977     0.150
    90.787   782.176     0.150
    90.787     8.000     0.150
    90.787  1425.176     0.150
    90.787  1517.176     0.150
    90.841   784.375     0.150
    91.045   783.176     0.150
    91.098   784.176     0.150
    91.113   785.076     0.150
    91.129   782.477     0.150
    91.127   784.775     0.150
    91.122   783.775     0.150
    91.137   785.576     0.150
    91.206   783.875     0.150
    91.206     7.301     0.150
    91.206  1417.176     0.150
    91.377   785.977     0.150
    91.496   784.576     0.150
    91.876   788.275     0.150
    91.939   787.576     0.150
    91.939     7.600     0.150
    91.939  1425.176     0.150
    92.048   787.676     0.150
    92.252   789.775     0.150
    92.474   790.477     0.150
    92.474  1458.176     0.150
    92.474  1008.176     0.150
    92.474  1425.176     0.150
    92.474  1820.176     0.150
    92.652   791.676     0.150
    92.652  1011.176     0.150
    92.648   791.176     0.150
    92.648  1455.176     0.150
    92.648   791.576     0.150
    92.648  1830.176     0.150
    92.733   791.676     0.150
    93.099   793.676     0.150
    93.209   794.176     0.150
    93.584   795.477     0.150
    93.693   795.176     0.150
    93.693  1462.176     0.150
    93.693  1018.176     0.150
    93.693  1423.176     0.150
    93.693  1535.176     0.150
    93.714   796.176     0.150
    94.045   797.676     0.150
    94.543   799.875     0.150
    94.543  1488.176     0.150
    94.543  1545.176     0.150
    94.642   799.176     0.150
    94.649   800.676     0.150
    94.649  1019.176     0.150
    95.123   803.176     0.150
    95.123   803.477     0.150
    95.215   802.676     0.150
    95.576   804.875     0.150
    95.570   804.775     0.150
    95.570     6.100     0.150
    95.570     8.100     0.150
    95.669   805.477     0.150
    96.440   808.176     0.150
    96.440  1477.176     0.150
    96.440  1445.176     0.150
    96.593   810.176     0.150
    96.593     6.000     0.150
    97.659   815.176     0.150
    97.659   818.676     0.150
    97.659   815.477     0.150
    98.542   816.176     0.150
    98.542   817.076     0.150
    99.166   822.176     0.150
    99.307   821.176     0.150
    99.423  1062.176     0.150
    99.423  1461.176     0.150
    99.423  1602.176     0.150
   100.927   832.176     0.150
   101.354   830.375     0.150
   101.583   832.977     0.150
   110.825  1779.176     0.150
   112.501  1161.176     0.150
   112.501  1520.176     0.150
   112.501  1736.176     0.150
   117.053  1125.176     0.150
   117.053  1780.176     0.150
   117.053  2165.176     0.150
   117.747  1125.676     0.150
   118.036  1127.176     0.150
   118.036  1135.275     0.150
   119.113  1128.775     0.150
   119.113  1209.176     0.150
   120.082  1128.176     0.150
   120.530  1550.176     0.150
   120.601  1132.676     0.150
   121.386  1134.176     0.150
   121.386  1134.676     0.150
   123.200  1135.176     0.150
   123.200  1136.076     0.150
   123.200  1832.176     0.150
   125.086  1141.275     0.150
   126.141  1142.477     0.150
   126.152  1144.176     0.150
   127.360  1144.977     0.150
   127.360  1265.176     0.150
   130.454  1151.176     0.150
   130.454  1355.176     0.150
   131.095  1153.176     0.150
   131.962  1154.477     0.150
   132.650  1155.676     0.150
   133.603  1157.676     0.150
   133.825  1157.576     0.150
   134.018  1157.275     0.150
   134.030  1157.375     0.150
   134.152  1155.176     0.150
   134.675  1159.176     0.150
   137.644  1166.176     0.150
   142.348  1169.176     0.150
   143.561  1172.076     0.150
   144.792  1175.676     0.150
   144.792  1185.176     0.150
   144.792  1373.176     0.150
   144.800  1176.176     0.150
   145.945  1181.176     0.150
   147.491  1185.977     0.150
   147.586  1185.275     0.150
   148.607  1182.477     0.150
   150.325  1190.977     0.150
   152.048  1195.775     0.150
   151.957  1189.176     0.150
    12.041   171.850     0.150
    13.484   192.049     0.150
    16.454   228.549     0.150
    16.623   232.049     0.150
    17.088   236.449     0.150
    17.088   237.248     0.150
    17.679   241.850     0.150
    17.899   244.148     0.150
    17.899   261.248     0.150
    18.130   249.549     0.150
    18.130   266.049     0.150
    18.197   247.549     0.150
    18.197   263.449     0.150
    18.234   248.748     0.150
    18.630   252.549     0.150
    18.630   269.350     0.150
    20.067   270.549     0.150
    21.141   280.549     0.150
    21.175   281.049     0.150
    21.967   286.549     0.150
    23.260   303.049     0.150
    23.258   304.049     0.150
    23.329   305.049     0.150
    23.695   308.049     0.150
    23.733   307.049     0.150
    23.832   308.549     0.150
    23.991   311.148     0.150
    24.181   311.748     0.150
    24.245   312.648     0.150
    24.579   315.748     0.150
    24.794   316.248     0.150
    24.856   317.949     0.150
    25.084   320.748     0.150
    25.085   320.148     0.150
    25.145   321.049     0.150
    25.626   324.850     0.150
    25.805   326.949     0.150
    26.554   334.049     0.150
    26.766   333.549     0.150
    27.186   339.148     0.150
    27.285   342.248     0.150
    28.344   348.850     0.150
    30.155   368.549     0.150
    31.863   378.549     0.150
    33.579   394.049     0.150
    35.540   410.049     0.150
    36.027   414.049     0.150
    39.563   447.748     0.150
    44.592   484.549     0.150
    44.624   485.148     0.150
    46.328   503.049     0.150
    48.439   518.049     0.150
    48.439  1016.049     0.150
    48.640   520.049     0.150
    50.628   532.049     0.150
    50.581   534.049     0.150
    52.933   551.350     0.150
    53.352   552.049     0.150
    53.352    17.000     0.150
    53.499   555.148     0.150
    53.806   556.949     0.150
    54.334   562.449     0.150
    55.132   565.549     0.150
    55.136   569.049     0.150
    56.367   574.549     0.150
    57.298   580.949     0.150
    57.835   584.148     0.150
    61.365   608.350     0.150
    65.772   636.049     0.150
    65.843   638.850     0.150
    68.778   659.850     0.150
    68.778    25.398     0.150
    70.550   666.049     0.150
    84.723   747.049     0.150
    84.961   749.049     0.150
    86.012   753.350     0.150
    86.022   753.248     0.150
    86.380   755.049     0.150
    86.442   755.148     0.150
    86.481   754.248     0.150
    86.466   755.648     0.150
    86.695   755.748     0.150
    86.738   755.949     0.150
    86.949   757.449     0.150
    87.083   758.248     0.150
    87.274   759.049     0.150
    89.480   769.449     0.150
   126.564  1138.248     0.150
   126.575  1136.049     0.150
   147.966  1176.850     0.150
   150.116  1185.049     0.150
   151.316  1188.049     0.150
     0.728    14.016     0.150
     3.534    55.516     0.150
     3.565    56.516     0.150
     3.673    56.516     0.150
     4.013    62.016     0.150
     4.043    62.516     0.150
     4.072    62.516     0.150
     4.786    72.516     0.150
     4.893    77.816     0.150
     5.276    80.215     0.150
     5.405    81.016     0.150
     6.453    96.016     0.150
     6.460    95.016     0.150
     7.846   115.016     0.150
     9.582   138.316     0.150
     9.758   139.016     0.150
     9.947   144.016     0.150
    10.040   144.016     0.150
    11.204   163.016     0.150
    16.578   232.215     0.150
    16.728   231.516     0.150
    17.703   243.516     0.150
    18.550   253.016     0.150
    18.497   270.016     0.150
    19.035   257.816     0.150
    19.096   264.016     0.150
    19.217   265.016     0.150
    19.905   267.215     0.150
    19.855   271.016     0.150
    20.411   277.016     0.150
    20.422   276.016     0.150
    20.536   278.016     0.150
    20.618   278.016     0.150
    21.167   282.316     0.150
    21.267   281.117     0.150
    21.205   283.016     0.150
    21.346   285.016     0.150
    21.342   286.016     0.150
    22.408   293.316     0.150
    22.422   293.516     0.150
    23.156   300.016     0.150
    23.084   304.016     0.150
    23.273   306.516     0.150
    23.347   305.715     0.150
    23.571   309.016     0.150
    23.815   311.117     0.150
    24.298   311.117     0.150
    24.132   313.715     0.150
    24.480   316.715     0.150
    24.727   318.316     0.150
    25.120   319.914     0.150
    25.153   319.316     0.150
    25.573   323.016     0.150
    25.518   326.016     0.150
    25.641   326.016     0.150
    26.084   330.117     0.150
    27.208   337.715     0.150
    27.383   339.816     0.150
    28.244   349.617     0.150
    29.095   354.516     0.150
    29.647   359.715     0.150
    31.987   383.117     0.150
    32.839   388.316     0.150
    33.151   390.816     0.150
    33.398   395.016     0.150
    33.578   394.117     0.150
    35.139   407.316     0.150
    35.380   409.715     0.150
    35.487   411.516     0.150
    36.141   416.516     0.150
    36.385   418.516     0.150
    37.302   426.617     0.150
    38.979   440.715     0.150
    39.461   446.016     0.150
    39.669   446.516     0.150
    39.894   449.016     0.150
    44.615   487.215     0.150
    48.960   524.516     0.150
    49.158   527.016     0.150
    49.431   529.016     0.150
    50.985   536.016     0.150
    52.698   552.316     0.150
    53.174   555.414     0.150
    53.259   554.117     0.150
    53.572   557.816     0.150
    54.780   566.316     0.150
    54.928   566.617     0.150
    54.928   628.816     0.150
    56.081   575.215     0.150
    57.036   581.914     0.150
    57.626   585.715     0.150
    57.626   639.914     0.150
    58.331   589.914     0.150
    61.221   609.816     0.150
    61.506   613.516     0.150
    64.200   632.516     0.150
    65.391   638.215     0.150
    67.480   653.016     0.150
    67.480    11.000     0.150
    68.810   662.016     0.150
    69.520   666.617     0.150
    70.272   672.117     0.150
    70.844   670.816     0.150
    81.020   730.715     0.150
    81.805   735.016     0.150
    82.159   737.016     0.150
    83.380   742.016     0.150
    83.380    16.500     0.150
    83.380   742.516     0.150
    83.380    16.000     0.150
    83.649   745.016     0.150
    84.325   748.516     0.150
    84.341   748.414     0.150
    84.420   749.117     0.150
    84.704   750.617     0.150
    84.702   749.215     0.150
    84.848   751.914     0.150
    85.120   751.914     0.150
    85.274   752.016     0.150
    85.436   754.215     0.150
    85.465   753.516     0.150
    85.680   756.414     0.150
    86.012   757.516     0.150
    86.092   758.516     0.150
    86.227   759.215     0.150
    86.277   759.215     0.150
    86.300   759.516     0.150
    86.351   755.816     0.150
    86.460   760.215     0.150
    86.461   760.016     0.150
    86.532   760.516     0.150
    86.572   760.316     0.150
    86.641   760.016     0.150
    86.644   759.715     0.150
    86.742   761.316     0.150
    86.819   759.316     0.150
    86.929   761.316     0.150
    87.007   761.016     0.150
    87.037   761.414     0.150
    87.059   761.016     0.150
    87.114   762.016     0.150
    87.113   760.316     0.150
    87.312   762.117     0.150
    87.347   763.016     0.150
    87.351   762.117     0.150
    87.401   763.016     0.150
    87.513   763.316     0.150
    87.519   763.715     0.150
    87.555   763.316     0.150
    87.573   762.914     0.150
    87.687   764.215     0.150
    87.880   764.516     0.150
    87.939   764.816     0.150
    88.024   766.617     0.150
    88.073   766.016     0.150
    88.486   766.316     0.150
    88.882   769.715     0.150
    89.347   771.215     0.150
    89.455   773.316     0.150
    89.863   773.617     0.150
    90.641   777.016     0.150
    90.907   780.016     0.150
    91.781   784.016     0.150
    91.900   784.414     0.150
    91.907   784.016     0.150
    91.907   784.215     0.150
    92.514   787.016     0.150
    92.514   787.816     0.150
    92.581   787.016     0.150
    94.979   799.117     0.150
    95.864   803.016     0.150
    95.868   802.816     0.150
    96.092   803.816     0.150
   125.752  1138.816     0.150
   130.666  1148.715     0.150
   132.172  1153.016     0.150
   132.978  1152.215     0.150
   133.101  1153.414     0.150
   133.202  1152.715     0.150
   133.394  1153.016     0.150
   134.752  1155.316     0.150
   134.752  1169.516     0.150
   134.810  1156.516     0.150
   137.088  1152.516     0.150
   137.088  1160.914     0.150
   143.066  1166.715     0.150
   144.228  1170.316     0.150
   144.228  1187.516     0.150
   145.203  1175.816     0.150
   146.763  1180.016     0.150
   146.846  1180.016     0.150
   148.058  1179.617     0.150
   149.585  1186.715     0.150
   151.406  1185.016     0.150
   152.612  1190.914     0.150
     2.790    46.031     0.150
     2.790    86.031     0.150
     2.862    45.930     0.150
     3.209    53.531     0.150
     3.209   100.031     0.150
     3.299    52.031     0.150
     3.299    90.734     0.150
     3.735    59.734     0.150
     5.548    84.531     0.150
     5.801    90.734     0.150
     6.694   102.734     0.150
    16.742   232.531     0.150
    16.942   237.531     0.150
    17.948   246.133     0.150
    18.174   248.734     0.150
    18.468   252.328     0.150
    18.468   461.031     0.150
    18.930   257.031     0.150
    19.802   273.031     0.150
    19.891   270.031     0.150
    20.557   280.031     0.150
    21.201   284.031     0.150
    21.314   287.031     0.150
    21.457   285.328     0.150
    21.490   286.828     0.150
    21.848   290.531     0.150
    22.148   291.031     0.150
    22.211   291.734     0.150
    22.245   295.328     0.150
    22.487   297.031     0.150
    22.768   296.828     0.150
    22.991   303.633     0.150
    23.300   304.828     0.150
    23.564   308.531     0.150
    23.794   306.031     0.150
    23.876   306.828     0.150
    23.985   312.531     0.150
    24.030   311.234     0.150
    24.144   313.633     0.150
    24.296   315.633     0.150
    24.473   315.828     0.150
    24.534   317.031     0.150
    24.752   319.734     0.150
    25.112   320.031     0.150
    25.155   322.430     0.150
    25.318   324.930     0.150
    25.375   324.734     0.150
    25.376   325.031     0.150
    26.062   330.031     0.150
    26.062    18.203     0.150
    26.491   333.633     0.150
    26.491    18.500     0.150
    26.870   337.430     0.150
    26.870    18.398     0.150
    26.854   338.328     0.150
    26.945   335.031     0.150
    28.373   351.031     0.150
    28.373    19.102     0.150
    28.663   353.430     0.150
    28.663    18.898     0.150
    32.548   387.633     0.150
    32.919   391.234     0.150
    33.896   399.031     0.150
    35.858   414.531     0.150
    36.335   418.234     0.150
    44.909   489.031     0.150
    44.941   490.031     0.150
    48.369   520.031     0.150
    48.643   522.531     0.150
    50.896   537.031     0.150
    53.247   555.828     0.150
    53.671   557.031     0.150
    53.671    19.000     0.150
    53.805   559.328     0.150
    54.141   561.234     0.150
    55.448   569.930     0.150
    56.678   578.828     0.150
    57.611   585.133     0.150
    58.151   588.633     0.150
    58.610   591.031     0.150
    66.072   640.531     0.150
    80.253   726.031     0.150
    83.102   742.031     0.150
    83.900   745.633     0.150
    83.911   745.430     0.150
    84.001   746.234     0.150
    84.284   747.328     0.150
    84.964   750.734     0.150
    84.990   751.328     0.150
    85.437   754.734     0.150
    85.516   755.031     0.150
    85.649   755.734     0.150
    85.705   756.031     0.150
    85.724   756.430     0.150
    85.754   755.734     0.150
    85.883   756.531     0.150
    85.911   757.031     0.150
    86.180   756.633     0.150
    86.197   756.531     0.150
    86.189   758.031     0.150
    86.367   756.828     0.150
    86.550   758.328     0.150
    86.617   758.734     0.150
    86.871   759.734     0.150
    86.916   760.531     0.150
    87.129   761.031     0.150
    87.265   761.133     0.150
    87.455   761.828     0.150
    88.480   766.531     0.150
    94.631   796.930     0.150
    95.759   802.633     0.150
   126.580  1139.031     0.150
   126.591  1140.133     0.150
   133.346  1153.031     0.150
   133.447  1153.828     0.150
   133.755  1154.234     0.150
   144.434  1174.031     0.150
   144.472  1170.828     0.150
   144.276  1171.133     0.150
   147.648  1181.930     0.150
   148.275  1177.133     0.150
   150.384  1182.031     0.150
   151.625  1191.031     0.150
     1.973    33.369     0.150
     1.973    58.050     0.150
     2.926    46.149     0.150
     2.926    92.350     0.150
     2.960    45.149     0.150
     2.960    90.350     0.150
     2.988    47.149     0.150
     3.405    52.350     0.150
     3.405   105.850     0.150
     3.498    55.340     0.150
     3.644    57.350     0.150
     3.841    57.850     0.150
     3.841   106.779     0.150
     5.699    84.850     0.150
     5.994    87.350     0.150
     6.120    91.149     0.150
    17.004   238.350     0.150
    17.008   238.050     0.150
    18.316   250.250     0.150
    18.613   253.350     0.150
    18.613   468.850     0.150
    19.181   262.850     0.150
    19.773   269.850     0.150
    20.333   275.149     0.150
    20.529   277.850     0.150
    21.098   279.350     0.150
    21.090   283.850     0.150
    21.288   285.850     0.150
    21.536   285.850     0.150
    21.570   286.350     0.150
    21.879   290.850     0.150
    21.995   292.850     0.150
    22.213   295.350     0.150
    22.374   291.949     0.150
    22.360   296.850     0.150
    22.951   297.850     0.150
    22.956   303.350     0.150
    23.343   305.850     0.150
    23.562   308.350     0.150
    23.610   308.649     0.150
    23.802   305.850     0.150
    23.986   307.850     0.150
    24.009   311.850     0.150
    24.443   316.949     0.150
    24.501   316.850     0.150
    24.750   320.449     0.150
    24.846   315.850     0.150
    25.136   323.149     0.150
    25.171   321.050     0.150
    25.265   319.850     0.150
    25.290   324.850     0.150
    25.343   325.350     0.150
    25.847   327.350     0.150
    26.839   339.350     0.150
    26.966   334.850     0.150
    27.133   336.850     0.150
    28.715   354.649     0.150
    28.715    10.900     0.150
    32.563   388.850     0.150
    32.802   389.449     0.150
    33.319   391.649     0.150
    35.921   416.350     0.150
    48.427   519.850     0.150
    50.374   534.750     0.150
    51.044   535.850     0.150
    53.267   557.050     0.150
    53.725   558.050     0.150
    53.725    10.300     0.150
    53.801   560.850     0.150
    54.155   562.649     0.150
    55.237   572.949     0.150
    55.306   573.149     0.150
    55.475   571.350     0.150
    55.456   574.449     0.150
    55.533   574.949     0.150
    56.684   579.850     0.150
    57.623   586.149     0.150
    58.177   589.949     0.150
    58.193   593.949     0.150
    58.693   593.350     0.150
    61.726   613.850     0.150
    63.425   626.850     0.150
    69.652    12.300     0.150
    70.968   671.850     0.150
    80.432   727.850     0.150
    84.088   747.250     0.150
    84.099   747.250     0.150
    84.508   749.850     0.150
    84.835   752.250     0.150
    84.893   753.350     0.150
    85.010   752.649     0.150
    85.129   752.850     0.150
    85.179   752.750     0.150
    85.224    12.800     0.150
    85.599   756.250     0.150
    85.635   755.850     0.150
    85.713   756.850     0.150
    85.846   757.850     0.150
    85.902   757.850     0.150
    85.949   757.850     0.150
    86.080   758.850     0.150
    86.085   758.350     0.150
    86.110    12.500     0.150
    86.371   759.050     0.150
    86.385   759.649     0.150
    86.386   758.850     0.150
    86.730   760.949     0.150
    86.740   760.649     0.150
    86.762   760.649     0.150
    86.806   760.850     0.150
    86.817   761.850     0.150
    87.060   762.149     0.150
    87.105   762.050     0.150
    87.131   761.050     0.150
    87.317   763.050     0.150
    87.331   762.949     0.150
    87.453   763.750     0.150
    87.643   764.449     0.150
    88.666   769.050     0.150
    89.893   774.750     0.150
    90.476   777.850     0.150
    90.730   779.850     0.150
    90.730    11.000     0.150
    91.629   783.149     0.150
    92.341   787.750     0.150
    92.423   787.750     0.150
    94.812   798.350     0.150
    95.077   800.710     0.150
    95.699   803.250     0.150
   126.367  1140.649     0.150
   126.402  1140.449     0.150
   144.565  1171.850     0.150
   144.565  1187.350     0.150
   147.585  1183.350     0.150
   148.373  1183.649     0.150
     2.415    38.801     0.150
     3.732    57.551     0.150
     3.742    57.051     0.150
     3.930    60.051     0.150
     4.055    60.551     0.150
     4.194    65.051     0.150
     4.696    72.051     0.150
    16.235   227.250     0.150
    16.239   227.951     0.150
    16.485   227.051     0.150
    17.369   240.551     0.150
    17.291   237.551     0.150
    18.107   256.551     0.150
    18.022   246.352     0.150
    18.022   260.250     0.150
    18.339   249.551     0.150
    18.339   263.951     0.150
    18.342   249.551     0.150
    18.342   263.951     0.150
    18.827   271.551     0.150
    19.465   264.551     0.150
    19.754   264.951     0.150
    20.020   271.551     0.150
    20.146   271.551     0.150
    20.227   271.551     0.150
    20.415   270.951     0.150
    20.840   278.051     0.150
    20.952   295.551     0.150
    20.975   280.051     0.150
    22.259   290.451     0.150
    22.264   290.551     0.150
    22.485   295.650     0.150
    22.882   301.750     0.150
    22.957   301.250     0.150
    23.425   306.051     0.150
    23.745   309.150     0.150
    24.090   311.951     0.150
    24.270   313.750     0.150
    24.281   314.551     0.150
    24.378   313.551     0.150
    24.241   309.852     0.150
    25.117   317.951     0.150
    44.277   481.951     0.150
    45.513   492.551     0.150
    49.344   526.551     0.150
    49.543   527.551     0.150
    49.816   529.750     0.150
    52.902   549.551     0.150
    54.300   560.551     0.150
    54.553   562.150     0.150
    56.654   577.650     0.150
    56.654    14.301     0.150
    57.250   581.451     0.150
    58.003   586.051     0.150
    58.003    15.000     0.150
    64.556   633.352     0.150
    70.762   671.852     0.150
    70.762    21.600     0.150
   125.557  1136.551     0.150
   125.593  1136.650     0.150
     0.949    15.613     0.150
     1.393    23.613     0.150
     1.393    40.413     0.150
     2.404    38.113     0.150
     2.404    62.613     0.150
     3.558    53.413     0.150
     3.558    96.613     0.150
     3.612    53.113     0.150
     3.612    95.613     0.150
     4.006    63.113     0.150
     4.006   104.113     0.150
     4.449    69.613     0.150
     4.465    67.213     0.150
     4.465   118.113     0.150
     4.757    72.613     0.150
     4.757   121.913     0.150
     5.270    75.413     0.150
     5.270   137.613     0.150
     5.628    83.213     0.150
     5.628   146.113     0.150
     6.360    92.713     0.150
     6.360   165.813     0.150
     7.738   110.613     0.150
    10.975   158.713     0.150
    10.975   340.913     0.150
    16.802   234.513     0.150
    16.806   234.713     0.150
    17.973   256.613     0.150
    18.706   259.613     0.150
    18.735   254.613     0.150
    18.735   479.613     0.150
    19.274   263.913     0.150
    19.274   743.813     0.150
    19.306   265.613     0.150
    19.431   264.613     0.150
    19.871   270.213     0.150
    20.066   271.613     0.150
    20.620   278.613     0.150
    20.631   277.613     0.150
    20.751   279.613     0.150
    20.751   278.013     0.150
    20.829   282.613     0.150
    21.388   284.613     0.150
    21.426   286.413     0.150
    21.960   293.613     0.150
    22.588   293.613     0.150
    23.162   304.113     0.150
    23.288   301.613     0.150
    23.482   308.213     0.150
    23.559   307.913     0.150
    24.023   312.113     0.150
    24.367   315.613     0.150
    24.693   318.413     0.150
    24.803   319.613     0.150
    24.881   321.113     0.150
    26.404   335.113     0.150
    27.503   340.213     0.150
    27.503   340.913     0.150
    27.699   344.113     0.150
    28.470   352.013     0.150
    31.932   381.613     0.150
    32.605   387.613     0.150
    33.622   397.613     0.150
    36.356   419.413     0.150
    45.833   496.613     0.150
    48.769   521.813     0.150
    48.769   956.613     0.150
    48.966   523.113     0.150
    49.239   525.813     0.150
    50.919   537.613     0.150
    52.921   554.713     0.150
    53.484   555.613     0.150
    53.746   557.613     0.150
    53.795   559.913     0.150
    54.763   567.113     0.150
    55.152   569.313     0.150
    56.301   577.413     0.150
    57.258   583.913     0.150
    57.850   587.813     0.150
    61.728   615.613     0.150
    64.743   634.113     0.150
    67.343   651.913     0.150
    71.040   672.713     0.150
    79.077   720.413     0.150
    79.462   722.313     0.150
    80.734   729.613     0.150
    80.734   728.713     0.150
    83.744   745.713     0.150
    84.450   749.413     0.150
    84.465   749.313     0.150
    84.547   750.113     0.150
    84.831   751.413     0.150
    84.889   751.213     0.150
    84.945   752.713     0.150
    85.232   752.813     0.150
    85.232   752.012     0.150
    85.278   754.313     0.150
    85.342   753.213     0.150
    85.410   754.413     0.150
    85.410    16.900     0.150
    85.410  1376.913     0.150
    85.427   754.913     0.150
    85.468   754.613     0.150
    85.556   755.113     0.150
    85.633   755.013     0.150
    85.633   755.613     0.150
    86.380   759.713     0.150
    86.524   761.213     0.150
    86.548   760.613     0.150
    86.604   761.613     0.150
    86.760   760.513     0.150
    86.762   759.613     0.150
    86.818   761.913     0.150
    86.859   759.613     0.150
    87.008   760.613     0.150
    87.125   761.913     0.150
    87.152   761.913     0.150
    87.180   761.813     0.150
    87.224   762.513     0.150
    87.293   761.813     0.150
    87.433   762.913     0.150
    87.474   763.013     0.150
    87.489   764.613     0.150
    87.539   763.613     0.150
    87.539   764.413     0.150
    87.631   764.013     0.150
    87.656   763.313     0.150
    87.681   764.013     0.150
    87.697   763.913     0.150
    87.814   764.813     0.150
    88.006   765.513     0.150
    88.656   769.213     0.150
    89.013   770.713     0.150
    89.358   772.113     0.150
    90.386   776.813     0.150
    90.512   776.613     0.150
    90.784   780.613     0.150
    91.000   780.613     0.150
    91.047   781.313     0.150
    91.047   781.412     0.150
    91.193   780.613     0.150
    91.191   780.113     0.150
    91.204   780.813     0.150
    91.564   782.413     0.150
    91.927   784.613     0.150
    92.655   789.113     0.150
    92.726   789.113     0.150
    92.875   788.713     0.150
    92.875   789.113     0.150
    94.213   795.813     0.150
    95.121   799.813     0.150
    96.007   804.513     0.150
   125.777  1137.613     0.150
   144.448  1171.113     0.150
   145.398  1176.313     0.150
   148.277  1182.813     0.150
   151.625  1191.613     0.150
     0.926    16.922     0.150
     1.118    20.922     0.150
     1.118    35.723     0.150
     1.273    23.223     0.150
     2.124    34.922     0.150
     2.124    61.223     0.150
     3.432    50.621     0.150
     3.432    88.723     0.150
     3.391    51.723     0.150
     3.391    90.723     0.150
     3.444    53.824     0.150
     4.219    64.723     0.150
     4.513    67.023     0.150
     4.513   124.324     0.150
     5.387    80.824     0.150
     5.659    84.223     0.150
     6.176    90.723     0.150
     6.353    92.723     0.150
     7.563   107.723     0.150
    16.669   233.234     0.150
    16.707   231.223     0.150
    17.391   238.723     0.150
    17.672   245.223     0.150
    17.989   246.422     0.150
    18.463   254.324     0.150
    18.500   251.621     0.150
    18.500   263.422     0.150
    18.500   462.723     0.150
    18.503   251.324     0.150
    19.301   265.324     0.150
    19.807   265.613     0.150
    20.496   273.723     0.150
    21.137   279.363     0.150
    21.235   283.824     0.150
    21.275   284.461     0.150
    21.483   285.383     0.150
    21.554   284.664     0.150
    21.738   289.574     0.150
    22.051   288.133     0.150
    22.334   291.094     0.150
    22.969   300.652     0.150
    23.119   303.453     0.150
    24.146   308.523     0.150
    24.660   316.961     0.150
    24.819   319.254     0.150
    25.399   320.113     0.150
    27.915   346.574     0.150
    28.355   349.824     0.150
    34.315   401.223     0.150
    48.723   520.523     0.150
    49.195   525.023     0.150
    50.871   536.723     0.150
    54.609   563.984     0.150
    54.692   564.344     0.150
    55.073   565.801     0.150
    56.251   574.543     0.150
    56.251    17.738     0.150
    57.199   581.383     0.150
    58.398   590.121     0.150
    70.152   667.422     0.150
    78.748   716.723     0.150
    78.807   716.723     0.150
    80.466   726.324     0.150
    84.175   745.824     0.150
    84.190   745.824     0.150
    84.272   746.422     0.150
    84.556   747.824     0.150
    85.089   750.324     0.150
    85.280   751.324     0.150
    86.848   759.023     0.150
    86.904   759.324     0.150
    87.158   760.422     0.150
    87.406   761.621     0.150
    87.539   762.324     0.150
    87.731   763.121     0.150
    90.755   778.723     0.150
   126.029  1137.922     0.150
   144.287  1169.723     0.150
   144.287  1187.223     0.150
   151.458  1190.023     0.150
     0.194    13.805     0.150
     0.572    15.805     0.150
     0.795    16.805     0.150
     2.247    38.602     0.150
     2.955    47.406     0.150
     2.955    86.805     0.150
     4.083    63.805     0.150
     4.571    71.305     0.150
     4.603    71.805     0.150
     4.889    72.406     0.150
     4.889   122.805     0.150
     4.905    76.008     0.150
     4.905   132.805     0.150
     5.787    88.703     0.150
     6.753   102.406     0.150
     8.156   118.805     0.150
    15.970   223.547     0.150
    16.947   233.203     0.150
    17.001   231.008     0.150
    17.181   236.445     0.150
    17.704   240.484     0.150
    18.410   249.406     0.150
    19.094   259.195     0.150
    19.094   278.586     0.150
    19.629   264.695     0.150
    19.629   284.922     0.150
    19.957   267.305     0.150
    20.519   273.781     0.150
    20.519   294.453     0.150
    20.565   273.781     0.150
    20.565   305.938     0.150
    20.737   276.273     0.150
    20.737   295.602     0.150
    20.737   307.695     0.150
    20.823   276.367     0.150
    20.823   298.125     0.150
    20.984   279.398     0.150
    20.984   299.133     0.150
    20.970   278.727     0.150
    21.124   279.781     0.150
    21.560   285.078     0.150
    21.712   286.375     0.150
    21.971   286.062     0.150
    21.980   286.203     0.150
    22.236   291.336     0.150
    22.334   295.023     0.150
    22.352   292.367     0.150
    22.345   293.664     0.150
    22.474   293.773     0.150
    22.712   297.062     0.150
    22.771   298.055     0.150
    22.771   526.992     0.150
    22.774   296.688     0.150
    22.870   298.953     0.150
    23.202   300.922     0.150
    23.258   302.008     0.150
    23.686   302.914     0.150
    23.922   307.344     0.150
    23.905   307.547     0.150
    24.050   308.984     0.150
    24.050   529.914     0.150
    23.987   305.914     0.150
    24.117   308.008     0.150
    24.830   315.258     0.150
    24.836   312.258     0.150
    24.865   313.445     0.150
    24.861   314.023     0.150
    25.230   319.234     0.150
    25.414   321.375     0.150
    25.611   324.062     0.150
    26.221   326.164     0.150
    26.221    18.750     0.150
    26.221   533.211     0.150
    27.053   333.617     0.150
    27.053    21.766     0.150
    27.146   336.633     0.150
    27.146    21.430     0.150
    27.146    32.875     0.150
    27.146   536.078     0.150
    27.220   335.562     0.150
    27.220    21.234     0.150
    27.633   340.805     0.150
    27.633    21.398     0.150
    27.633   537.906     0.150
    31.069   370.828     0.150
    31.069    21.484     0.150
    31.069   545.516     0.150
    31.096    21.000     0.150
    31.385   373.875     0.150
    31.385   546.102     0.150
    31.772   376.805     0.150
    31.772    21.000     0.150
    32.421   382.703     0.150
    32.421    21.891     0.150
    33.365   391.484     0.150
    33.365   552.156     0.150
    33.409   394.203     0.150
    33.981   397.406     0.150
    33.981    22.398     0.150
    33.870   398.008     0.150
    34.777   401.305     0.150
    34.996   403.172     0.150
    34.996    22.172     0.150
    34.996    31.586     0.150
    34.996   478.977     0.150
    34.996   556.234     0.150
    34.909   403.805     0.150
    34.963   404.406     0.150
    36.938   419.797     0.150
    36.938    22.039     0.150
    36.938    32.258     0.150
    36.938   562.164     0.150
    39.285   442.453     0.150
    40.278   449.102     0.150
    40.330   448.008     0.150
    40.448   449.406     0.150
    40.672   450.906     0.150
    40.672    21.898     0.150
    40.797   454.758     0.150
    40.905   454.844     0.150
    41.517    21.500     0.150
    41.817   461.367     0.150
    41.839   458.867     0.150
    47.344   510.805     0.150
    49.474   525.906     0.150
    49.947   530.203     0.150
    51.639   539.523     0.150
    51.620   538.805     0.150
    52.094   544.008     0.150
    52.862   547.992     0.150
    52.862    22.953     0.150
    52.862   616.461     0.150
    53.976   556.094     0.150
    54.060   556.461     0.150
    54.321   557.156     0.150
    54.321   621.586     0.150
    55.485   566.203     0.150
    56.437   572.953     0.150
    57.020   576.578     0.150
    57.020   633.164     0.150
    57.167   583.008     0.150
    57.729   581.805     0.150
    58.247   589.805     0.150
    60.695   606.305     0.150
    64.703   664.406     0.150
    69.272   661.406     0.150
    70.306   663.406     0.150
    70.785    22.602     0.150
    78.505   711.602     0.150
    78.556   712.203     0.150
    78.947   714.703     0.150
    80.189   720.906     0.150
    83.385   738.805     0.150
    83.708   740.305     0.150
    83.976   741.805     0.150
    83.996   741.602     0.150
    84.067   742.305     0.150
    84.352   743.602     0.150
    84.573   744.805     0.150
    84.710   744.406     0.150
    84.743   745.805     0.150
    84.749   745.703     0.150
    85.025   747.703     0.150
    85.051   748.008     0.150
    85.100   747.203     0.150
    85.713   750.703     0.150
    85.754   751.305     0.150
    85.998   751.906     0.150
    86.192   753.305     0.150
    86.304   752.203     0.150
    86.320   752.805     0.150
    86.326   754.805     0.150
    86.351   753.703     0.150
    86.481   754.703     0.150
    86.554   755.203     0.150
    86.619   752.805     0.150
    86.677   754.203     0.150
    86.713   754.508     0.150
    86.720   754.203     0.150
    86.718   755.906     0.150
    86.807   755.102     0.150
    86.972   755.305     0.150
    87.018   756.305     0.150
    87.008   755.406     0.150
    87.119   757.305     0.150
    87.207   756.406     0.150
    87.227   756.203     0.150
    87.336   757.203     0.150
    87.531   757.805     0.150
    87.563   759.305     0.150
    87.648   759.805     0.150
    88.519   762.906     0.150
    88.849   766.008     0.150
    88.849    23.797     0.150
    89.833   768.305     0.150
    90.244   771.305     0.150
    90.518   773.508     0.150
    90.642   772.805     0.150
    91.376   777.703     0.150
    92.122   780.305     0.150
    92.181   779.805     0.150
    92.345   781.008     0.150
    94.583   792.102     0.150
    95.794   797.562     0.150
    95.929   798.383     0.150
    96.256   799.406     0.150
    96.151   799.484     0.150
    98.622   808.305     0.150
   116.526  1115.305     0.150
   118.355  1119.805     0.150
   118.770  1120.008     0.150
   119.294  1121.008     0.150
   126.050  1134.602     0.150
   129.142  1141.305     0.150
   129.445  1142.008     0.150
   130.423  1144.406     0.150
   132.367  1146.867     0.150
   132.491  1145.602     0.150
   132.592  1146.766     0.150
   132.783  1147.023     0.150
   132.799  1146.406     0.150
   135.440  1151.102     0.150
   136.333  1154.008     0.150
   143.628  1163.305     0.150
   143.628  1200.305     0.150
   146.296  1174.305     0.150
   146.340  1198.602     0.150
   147.462  1174.203     0.150
   148.977  1180.703     0.150
   149.064  1181.008     0.150
   149.310  1181.602     0.150
   149.471  1181.102     0.150
   149.550  1181.406     0.150
   149.614  1181.906     0.150
   149.640  1181.805     0.150
   149.825  1182.203     0.150
   150.809  1184.805     0.150
   152.261  1189.406     0.150
   152.528  1188.906     0.150
   152.639  1190.305     0.150
   152.814  1190.508     0.150
     0.965    16.859     0.150
     1.126    20.359     0.150
     2.412    38.859     0.150
     2.412    67.859     0.150
     3.462    54.359     0.150
     3.660    57.359     0.150
     3.782    57.359     0.150
     3.782    99.859     0.150
     3.816    57.160     0.150
     3.816   102.359     0.150
     4.110    60.859     0.150
     4.110    62.859     0.150
     4.110   111.660     0.150
     4.175    60.359     0.150
     4.593    69.359     0.150
     4.593   122.359     0.150
     5.382    79.461     0.150
     6.574    96.660     0.150
    11.318   161.859     0.150
    16.525   231.320     0.150
    16.629   229.938     0.150
    16.717   230.961     0.150
    17.465   242.160     0.150
    17.481   240.258     0.150
    17.697   245.059     0.150
    18.177   247.969     0.150
    18.452   253.961     0.150
    19.001   261.230     0.150
    19.566   266.379     0.150
    19.925   267.289     0.150
    20.099   272.730     0.150
    20.446   276.008     0.150
    21.048   281.668     0.150
    21.122   282.098     0.150
    21.275   284.340     0.150
    21.369   284.211     0.150
    21.489   287.410     0.150
    21.532   283.969     0.150
    21.602   288.391     0.150
    22.107   294.488     0.150
    22.431   292.918     0.150
    22.439   293.039     0.150
    22.782   299.238     0.150
    22.809   301.379     0.150
    23.014   300.461     0.150
    23.197   300.738     0.150
    23.361   307.418     0.150
    24.047   313.348     0.150
    24.072   309.059     0.150
    24.341   312.199     0.150
    24.388   315.051     0.150
    24.465   315.020     0.150
    24.520   316.910     0.150
    25.206   319.211     0.150
    25.478   323.078     0.150
    25.627   323.539     0.150
    26.099   331.719     0.150
    27.253   338.289     0.150
    27.428   340.840     0.150
    27.644   344.840     0.150
    28.075   347.758     0.150
    33.243   395.160     0.150
    33.724   399.359     0.150
    34.437   403.859     0.150
    34.437    16.500     0.150
    35.414   409.000     0.150
    37.341   426.738     0.150
    41.157   458.160     0.150
    41.157    15.699     0.150
    49.065   524.859     0.150
    49.263   526.859     0.150
    49.535   528.961     0.150
    53.087   554.359     0.150
    53.377   555.809     0.150
    53.493   556.680     0.150
    54.033    10.598     0.150
    54.449   563.930     0.150
    54.576   564.359     0.150
    54.611   565.160     0.150
    54.854   565.781     0.150
    54.854   627.570     0.150
    55.997   574.328     0.150
    56.326   575.359     0.150
    56.956   580.781     0.150
    57.551   584.750     0.150
    57.551    15.711     0.150
    57.551   637.348     0.150
    64.313   630.859     0.150
    64.401   631.859     0.150
    67.402   651.660     0.150
    67.402    14.199     0.150
    78.919   718.461     0.150
    78.974   718.160     0.150
    79.361   721.258     0.150
    80.620   727.859     0.150
    81.720   734.859     0.150
    81.720    16.000     0.150
    81.765   734.359     0.150
    82.214   737.359     0.150
    83.316   741.461     0.150
    83.316    16.398     0.150
    83.708   744.859     0.150
    84.011   746.359     0.150
    84.367   748.160     0.150
    84.384   748.160     0.150
    84.461   748.859     0.150
    84.701   748.758     0.150
    84.746   750.258     0.150
    84.904   751.559     0.150
    85.057   751.859     0.150
    85.138   752.359     0.150
    85.188   751.258     0.150
    85.267   752.859     0.150
    85.348   754.359     0.150
    85.374   753.859     0.150
    85.481   753.758     0.150
    85.878   755.859     0.150
    86.335   757.859     0.150
    86.499   759.359     0.150
    86.655   759.859     0.150
    86.686   759.461     0.150
    86.691   759.258     0.150
    86.715   758.258     0.150
    86.801   760.859     0.150
    86.965   761.660     0.150
    87.031   761.859     0.150
    87.053   760.660     0.150
    87.084   760.961     0.150
    87.103   760.660     0.150
    87.118   760.258     0.150
    87.165   761.559     0.150
    87.356   761.859     0.150
    87.379   763.359     0.150
    87.395   761.859     0.150
    87.436   762.859     0.150
    87.471   763.359     0.150
    87.562   765.359     0.150
    87.598   762.859     0.150
    87.616   762.660     0.150
    87.729   763.758     0.150
    87.923   764.359     0.150
    88.060   765.859     0.150
    88.067   765.859     0.150
    88.922   769.359     0.150
    90.335   775.160     0.150
    90.672   777.859     0.150
    90.831   778.859     0.150
    90.831   778.559     0.150
    90.940   780.359     0.150
    91.810   783.461     0.150
    91.811   783.859     0.150
    91.811    12.000     0.150
    91.855   782.859     0.150
    91.855    14.000     0.150
    92.547   786.359     0.150
    92.768   789.859     0.150
    92.768    16.402     0.150
    95.010   798.660     0.150
    95.895   802.559     0.150
    95.969   803.258     0.150
    96.193   804.059     0.150
    97.794   809.559     0.150
    99.120   815.859     0.150
   125.653  1138.461     0.150
   125.665  1138.859     0.150
   144.184  1169.859     0.150
   144.271  1169.660     0.150
   145.100  1175.059     0.150
   146.740  1179.660     0.150
   147.589  1181.359     0.150
   148.017  1178.859     0.150
     1.601    26.820     0.150
     1.601    49.621     0.150
     1.559    26.621     0.150
     1.706    29.121     0.150
     2.633    39.223     0.150
     2.757    42.422     0.150
     3.031    46.121     0.150
     3.031    85.621     0.150
     3.480    52.320     0.150
     3.480    92.621     0.150
     3.420    93.621     0.150
     3.770    56.520     0.150
     3.770   100.621     0.150
     4.641    69.020     0.150
     6.144    91.020     0.150
     6.144   156.121     0.150
     9.316   130.621     0.150
    10.188   146.422     0.150
    10.922   155.121     0.150
    10.922   155.520     0.150
    10.922   155.922     0.150
    15.810   220.621     0.150
    16.521   226.590     0.150
    16.583   229.922     0.150
    16.599   228.520     0.150
    16.858   232.109     0.150
    17.103   239.020     0.150
    17.292   237.422     0.150
    17.532   240.922     0.150
    17.791   243.520     0.150
    17.800   241.723     0.150
    17.800   518.121     0.150
    18.020   244.922     0.150
    18.312   248.422     0.150
    18.391   250.121     0.150
    20.416   271.730     0.150
    20.712   277.121     0.150
    20.712   277.320     0.150
    20.897   279.391     0.150
    21.358   282.660     0.150
    22.173   292.320     0.150
    22.249   293.121     0.150
    22.378   294.730     0.150
    22.467   291.430     0.150
    22.997   299.121     0.150
    22.997   299.723     0.150
    23.087   298.301     0.150
    23.539   305.391     0.150
    23.604   307.121     0.150
    23.604   307.223     0.150
    23.690   303.223     0.150
    23.622   307.121     0.150
    23.622   307.223     0.150
    23.663   307.262     0.150
    23.675   307.180     0.150
    23.981   310.121     0.150
    23.981   311.020     0.150
    24.095   312.172     0.150
    24.272   313.352     0.150
    24.727   317.121     0.150
    24.727   317.520     0.150
    24.883   314.121     0.150
    24.883   314.223     0.150
    25.031   317.723     0.150
    25.031   532.223     0.150
    25.145   320.141     0.150
    25.339   322.270     0.150
    25.376   322.910     0.150
    25.431   323.191     0.150
    25.647   323.883     0.150
    26.022   328.832     0.150
    26.758   331.230     0.150
    26.842   336.922     0.150
    26.842    18.551     0.150
    27.472   341.691     0.150
    27.472    19.051     0.150
    27.680   342.410     0.150
    28.133    22.051     0.150
    28.353   348.832     0.150
    28.589   351.152     0.150
    29.859   364.121     0.150
    30.763   680.121     0.150
    31.934   381.711     0.150
    31.968   379.820     0.150
    31.968   549.621     0.150
    32.116   381.160     0.150
    32.116    18.621     0.150
    32.141   378.820     0.150
    32.141   549.621     0.150
    32.119   381.090     0.150
    32.380   385.512     0.150
    32.506   384.730     0.150
    32.578   381.922     0.150
    32.597   385.941     0.150
    32.883   389.383     0.150
    33.079   389.562     0.150
    33.544   393.680     0.150
    33.726   395.570     0.150
    34.472    18.711     0.150
    44.846   486.223     0.150
    44.846    14.398     0.150
    44.846   588.820     0.150
    45.740   496.723     0.150
    45.816   496.723     0.150
    48.149   513.723     0.150
    48.149   602.723     0.150
    48.139   514.621     0.150
    48.139   601.422     0.150
    48.342   516.121     0.150
    48.342   936.121     0.150
    51.092   536.930     0.150
    52.041   543.020     0.150
    53.202   553.621     0.150
    53.594   553.922     0.150
    53.594    14.898     0.150
    53.781   556.383     0.150
    53.890   556.883     0.150
    54.099   559.422     0.150
    54.100   558.520     0.150
    55.003   564.723     0.150
    55.003   626.820     0.150
    55.205   566.801     0.150
    55.240   567.242     0.150
    55.395   567.922     0.150
    55.625   572.121     0.150
    55.694   572.520     0.150
    55.844   573.621     0.150
    55.921   574.422     0.150
    56.644   575.609     0.150
    57.571   582.570     0.150
    58.099   586.102     0.150
    58.099    17.008     0.150
    58.506   588.723     0.150
    58.576   592.723     0.150
    61.617   610.422     0.150
    62.040   614.320     0.150
    62.314   614.820     0.150
    63.230   622.020     0.150
    65.828   638.922     0.150
    66.138   640.082     0.150
    70.681   667.223     0.150
    77.647   709.621     0.150
    80.071   721.121     0.150
    80.311   724.121     0.150
    81.013   728.102     0.150
    81.447   730.441     0.150
    82.912   738.492     0.150
    83.179   739.832     0.150
    83.713   741.723     0.150
    83.713    19.000     0.150
    83.724   741.922     0.150
    83.815   742.121     0.150
    83.815    19.000     0.150
    83.907   744.422     0.150
    84.098   743.422     0.150
    84.123   744.980     0.150
    84.233   745.211     0.150
    84.257   746.121     0.150
    84.341   746.223     0.150
    84.395   746.723     0.150
    84.505   748.051     0.150
    84.580   746.520     0.150
    84.627   747.090     0.150
    84.748   748.359     0.150
    84.748  1371.480     0.150
    84.802   746.723     0.150
    84.802    20.000     0.150
    84.792   747.621     0.150
    84.836   747.520     0.150
    84.836    20.602     0.150
    84.840   746.520     0.150
    85.081   749.520     0.150
    85.212   749.980     0.150
    85.277   751.340     0.150
    85.564   752.410     0.150
    85.581   752.840     0.150
    85.674   753.270     0.150
    85.722   754.121     0.150
    85.825   753.590     0.150
    85.992   752.820     0.150
    85.992    19.000     0.150
    85.999   754.609     0.150
    86.009   752.520     0.150
    86.010   754.820     0.150
    86.218   755.891     0.150
    86.307   754.520     0.150
    86.362   754.820     0.150
    86.362   755.922     0.150
    86.383   755.121     0.150
    86.380   757.121     0.150
    86.430   754.820     0.150
    86.430    19.000     0.150
    86.436   755.020     0.150
    86.684   756.223     0.150
    86.730   758.211     0.150
    86.729   756.320     0.150
    86.816   757.621     0.150
    86.849   757.121     0.150
    86.866   757.121     0.150
    86.943   757.223     0.150
    86.956   756.922     0.150
    87.071   759.551     0.150
    87.077   759.223     0.150
    87.079   758.121     0.150
    87.116   760.320     0.150
    87.153   759.422     0.150
    87.268   758.723     0.150
    87.306   760.551     0.150
    87.322   758.723     0.150
    87.367   761.621     0.150
    87.450   761.820     0.150
    87.457   760.422     0.150
    87.515   761.422     0.150
    87.688   762.121     0.150
    87.958   763.422     0.150
    87.971   763.820     0.150
    88.117   762.520     0.150
    88.174   764.723     0.150
    88.294   763.820     0.150
    88.352   764.121     0.150
    88.352    20.199     0.150
    88.352  1401.820     0.150
    88.352   764.422     0.150
    88.352    19.898     0.150
    88.352   968.223     0.150
    88.428   765.180     0.150
    88.639   765.223     0.150
    88.672   766.312     0.150
    88.836   767.422     0.150
    88.873   767.223     0.150
    89.355   769.500     0.150
    89.503   769.820     0.150
    89.643   770.320     0.150
    89.693   770.320     0.150
    89.928   773.121     0.150
    90.037   771.422     0.150
    90.114   773.422     0.150
    90.114    26.898     0.150
    90.114  1492.121     0.150
    90.114  1788.121     0.150
    90.155   773.723     0.150
    90.288   772.820     0.150
    90.364   775.020     0.150
    90.364    20.102     0.150
    90.364    26.102     0.150
    90.405   773.621     0.150
    90.429   773.723     0.150
    90.429   774.320     0.150
    90.438   772.922     0.150
    90.500   774.121     0.150
    90.536   774.922     0.150
    90.536    18.199     0.150
    90.691   775.422     0.150
    90.829   776.520     0.150
    90.868   776.621     0.150
    91.193   778.922     0.150
    91.268   778.922     0.150
    91.268    26.898     0.150
    91.976   781.121     0.150
    91.976    26.500     0.150
    92.061   782.320     0.150
    92.061    26.199     0.150
    92.194   782.820     0.150
    92.194   783.020     0.150
    92.627   785.121     0.150
    93.248   787.211     0.150
    93.550   789.621     0.150
    93.801   790.422     0.150
    94.089   791.121     0.150
    94.449   793.320     0.150
    94.725   793.961     0.150
    94.735   794.121     0.150
    94.854   794.902     0.150
    94.870   794.020     0.150
    94.905   794.320     0.150
    95.079   795.941     0.150
    95.336   797.723     0.150
    95.471   799.121     0.150
    95.579   798.520     0.150
    96.993   804.621     0.150
    96.993    19.801     0.150
    97.155   805.820     0.150
    98.287   808.922     0.150
    98.806   811.621     0.150
    98.806   839.121     0.150
   100.991   824.621     0.150
   107.667   854.723     0.150
   117.002  1117.723     0.150
   117.385  1118.922     0.150
   119.958  1123.621     0.150
   120.414  1125.621     0.150
   120.414  1146.121     0.150
   120.966  1126.121     0.150
   121.424  1126.422     0.150
   121.424  1142.621     0.150
   122.323  1130.621     0.150
   124.934  1133.922     0.150
   126.741  1137.223     0.150
   126.741  1152.422     0.150
   126.762  1137.121     0.150
   127.618  1138.520     0.150
   127.618  1155.020     0.150
   129.939  1142.223     0.150
   130.429  1148.422     0.150
   133.257  1149.793     0.150
   133.354  1149.090     0.150
   133.459  1150.133     0.150
   133.470  1150.609     0.150
   133.471  1150.949     0.150
   133.674  1150.652     0.150
   133.716  1150.191     0.150
   134.010  1151.590     0.150
   134.072  1151.512     0.150
   137.837  1158.820     0.150
   143.061  1163.121     0.150
   143.562  1165.121     0.150
   144.359  1167.820     0.150
   144.359  1188.621     0.150
   147.659  1179.223     0.150
   147.680  1179.121     0.150
   148.157  1176.320     0.150
   148.721  1176.121     0.150
   151.024  1187.621     0.150
   151.392  1188.520     0.150
   151.570  1188.621     0.150
   151.507  1189.121     0.150
     0.099    14.377     0.150
     0.463    15.576     0.150
     0.463    25.877     0.150
     2.356    39.178     0.150
     2.356    67.377     0.150
     2.652    41.576     0.150
     2.884    46.477     0.150
     3.901    58.576     0.150
     3.901    99.178     0.150
     4.030    61.477     0.150
     4.160    63.377     0.150
     4.222    65.178     0.150
     4.257    64.377     0.150
     4.291    64.977     0.150
     4.311    65.178     0.150
     4.436    67.076     0.150
     4.569    68.678     0.150
     4.716    72.178     0.150
     4.750    72.377     0.150
     4.690    69.377     0.150
     5.054    76.777     0.150
     5.935    88.377     0.150
     5.987    88.076     0.150
     5.987   147.877     0.150
     6.933   103.277     0.150
     7.899   112.377     0.150
     7.991   115.877     0.150
     7.991   196.377     0.150
    10.018   143.576     0.150
    15.999   219.018     0.150
    17.084   233.877     0.150
    17.648   237.447     0.150
    17.806   241.777     0.150
    17.964   243.076     0.150
    17.964   446.377     0.150
    18.293   250.678     0.150
    18.293   267.877     0.150
    18.464   248.977     0.150
    19.302   263.178     0.150
    19.422   261.367     0.150
    19.606   261.547     0.150
    19.767   262.246     0.150
    19.721   264.107     0.150
    19.743   264.107     0.150
    20.048   264.438     0.150
    20.332   270.768     0.150
    20.453   271.188     0.150
    20.555   273.438     0.150
    20.647   273.217     0.150
    20.789   276.518     0.150
    20.924   276.027     0.150
    21.385   281.678     0.150
    21.511   284.807     0.150
    22.060   288.156     0.150
    22.863   292.348     0.150
    22.878   297.477     0.150
    22.878   524.877     0.150
    23.369   297.857     0.150
    23.594   303.477     0.150
    23.743   304.287     0.150
    23.950   304.877     0.150
    23.950   525.977     0.150
    23.950   305.076     0.150
    24.094   308.838     0.150
    24.879   310.838     0.150
    24.779   312.947     0.150
    25.301   317.236     0.150
    26.145   323.236     0.150
    27.050   331.527     0.150
    27.050    22.400     0.150
    27.050   532.736     0.150
    27.461   338.076     0.150
    27.461    23.102     0.150
    28.865   347.348     0.150
    31.524   371.377     0.150
    31.524    22.801     0.150
    31.524   542.777     0.150
    32.727   381.746     0.150
    45.159   486.477     0.150
    45.159   585.576     0.150
    45.159   592.678     0.150
    52.669   544.986     0.150
    53.747   552.477     0.150
    53.747    25.600     0.150
    53.747   617.678     0.150
    63.846   623.178     0.150
    64.796   630.576     0.150
    64.811   630.377     0.150
    67.160   646.877     0.150
    69.472   660.438     0.150
    70.021   662.877     0.150
    70.204   661.277     0.150
    77.081   702.477     0.150
    84.415   741.977     0.150
    84.415    26.900     0.150
    84.941   746.178     0.150
    85.069   744.576     0.150
    94.551   790.178     0.150
    95.915   795.896     0.150
    96.051   796.678     0.150
    96.059   795.877     0.150
    95.970   797.576     0.150
    96.273   797.637     0.150
   118.046  1116.377     0.150
   120.596  1121.477     0.150
   120.859  1122.277     0.150
   124.344  1129.932     0.150
   125.616  1132.576     0.150
   126.160  1133.377     0.150
   126.560  1134.178     0.150
   127.741  1136.611     0.150
   129.936  1141.467     0.150
   131.319  1143.227     0.150
   131.349  1143.146     0.150
   131.656  1143.588     0.150
   131.951  1144.188     0.150
   132.820  1144.576     0.150
   136.438  1153.377     0.150
   144.472  1168.178     0.150
   152.318  1197.576     0.150
   152.415  1198.076     0.150
   152.687  1199.678     0.150
   152.795  1199.777     0.150
   152.969  1200.477     0.150
     1.423    23.492     0.150
     1.423    39.961     0.150
     1.682    28.766     0.150
     1.682    50.062     0.150
     2.239    36.984     0.150
     2.239    65.562     0.150
     2.369    37.750     0.150
     2.369    65.062     0.150
     2.692    41.539     0.150
     2.692    75.062     0.150
     3.122    47.789     0.150
     3.122    81.266     0.150
     3.206    49.719     0.150
     3.237    50.305     0.150
     3.279    51.555     0.150
     3.513    54.805     0.150
     3.513    94.859     0.150
     3.655    57.016     0.150
     3.655   103.359     0.150
     3.679    56.445     0.150
     3.679    97.766     0.150
     3.696    57.562     0.150
     3.705    57.484     0.150
     3.816    58.930     0.150
     3.816   103.859     0.150
     3.845    59.164     0.150
     3.845   104.164     0.150
     3.852    59.500     0.150
     3.852   106.164     0.150
     4.129    63.641     0.150
     4.151    62.914     0.150
     4.151   116.766     0.150
     5.277    80.234     0.150
     5.944    89.445     0.150
     6.063    89.523     0.150
     6.871   101.023     0.150
     7.147   104.562     0.150
     8.028   115.031     0.150
     9.154   134.281     0.150
     9.859   143.062     0.150
     9.859   254.062     0.150
    10.655   154.852     0.150
    11.196   160.961     0.150
    11.196   282.062     0.150
    17.755   245.062     0.150
    17.992   246.359     0.150
    18.804   255.859     0.150
    19.103   262.391     0.150
    19.224   260.266     0.150
    19.664   268.164     0.150
    19.664   486.062     0.150
    19.664   268.750     0.150
    20.851   281.469     0.150
    20.900   278.836     0.150
    21.006   281.352     0.150
    21.027   282.930     0.150
    21.038   281.445     0.150
    21.172   285.289     0.150
    21.231   284.820     0.150
    21.659   287.625     0.150
    22.296   296.461     0.150
    23.524   309.133     0.150
    24.322   311.766     0.150
    24.322   559.664     0.150
    25.078   322.531     0.150
    25.227   321.961     0.150
    27.546   345.492     0.150
    27.587   344.945     0.150
    27.590   344.656     0.150
    27.919   347.812     0.150
    28.108   349.305     0.150
    28.233   350.633     0.150
    28.645   353.734     0.150
    28.759   354.586     0.150
    28.768   354.633     0.150
    28.803   354.984     0.150
    28.965   356.281     0.150
    29.467   360.422     0.150
    30.191   370.562     0.150
    30.720   371.234     0.150
    30.718   372.930     0.150
    30.778   374.359     0.150
    31.001   373.820     0.150
    31.018   376.562     0.150
    31.069   373.391     0.150
    31.090   377.242     0.150
    31.154   378.352     0.150
    31.184   382.562     0.150
    31.225   375.289     0.150
    31.300   378.203     0.150
    32.211   387.195     0.150
    32.549   385.359     0.150
    32.549   689.664     0.150
    32.649   391.180     0.150
    32.658   390.250     0.150
    33.167   390.164     0.150
    33.458   398.203     0.150
    33.476   393.461     0.150
    33.791   399.641     0.150
    34.282   404.562     0.150
    34.358   404.062     0.150
    34.429   406.391     0.150
    34.532   406.766     0.150
    34.833   407.359     0.150
    34.857   408.062     0.150
    38.755   442.766     0.150
    38.802   443.289     0.150
    39.002   442.656     0.150
    39.420   448.562     0.150
    39.649   449.562     0.150
    39.912   450.859     0.150
    40.208   454.852     0.150
    40.312   455.531     0.150
    40.368   455.203     0.150
    40.423   459.242     0.150
    40.811   459.492     0.150
    41.130   461.320     0.150
    45.090   490.359     0.150
    45.090   886.859     0.150
    45.795   501.625     0.150
    45.812   496.766     0.150
    45.812   895.664     0.150
    46.150   502.203     0.150
    46.199   504.062     0.150
    48.354   519.766     0.150
    48.545   520.062     0.150
    50.244   534.562     0.150
    51.156   540.164     0.150
    51.610   545.562     0.150
    51.609   545.461     0.150
    51.756   546.859     0.150
    51.790   547.570     0.150
    53.763   559.602     0.150
    53.939   559.961     0.150
    54.035   560.766     0.150
    54.143   561.672     0.150
    54.913   568.102     0.150
    55.049   568.742     0.150
    55.020   571.766     0.150
    55.093   568.164     0.150
    55.093  1031.664     0.150
    55.269   570.234     0.150
    55.246   573.461     0.150
    55.487   570.922     0.150
    56.660   579.141     0.150
    57.013   583.383     0.150
    57.609   585.672     0.150
    57.779   589.164     0.150
    57.908   592.164     0.150
    58.037   593.062     0.150
    58.182   589.164     0.150
    58.785  1079.664     0.150
    59.139   596.305     0.150
    59.193   599.164     0.150
    59.358   599.859     0.150
    59.519   601.359     0.150
    59.808   603.359     0.150
    59.827   603.164     0.150
    59.863   604.461     0.150
    59.989   604.562     0.150
    60.174   605.562     0.150
    60.238   606.562     0.150
    60.238  1100.461     0.150
    60.314   605.664     0.150
    60.348   607.266     0.150
    60.377   608.266     0.150
    60.553   608.359     0.150
    61.755   613.766     0.150
    62.511   620.094     0.150
    63.592   627.711     0.150
    63.607   628.164     0.150
    66.001   642.852     0.150
    66.343   643.625     0.150
    66.936   652.062     0.150
    66.936   652.266     0.150
    67.505   650.461     0.150
    67.505    18.703     0.150
    67.829   656.562     0.150
    67.829    11.500     0.150
    67.829   805.062     0.150
    67.829  1190.062     0.150
    67.829  1216.062     0.150
    67.829  1249.062     0.150
    67.829  1453.062     0.150
    68.078   659.031     0.150
    68.969   663.164     0.150
    68.969    16.398     0.150
    69.047   663.664     0.150
    69.047   665.961     0.150
    69.047    15.898     0.150
    69.047  1208.359     0.150
    69.104   661.766     0.150
    69.104   666.461     0.150
    69.104    16.195     0.150
    69.183  1215.062     0.150
    69.290   665.172     0.150
    69.290   664.711     0.150
    70.175   670.164     0.150
    70.175  1214.859     0.150
    70.175   669.422     0.150
    70.765   673.961     0.150
    70.765     8.398     0.150
    70.765  1227.961     0.150
    71.143   673.664     0.150
    71.202   676.695     0.150
    71.202    15.875     0.150
    71.202  1232.953     0.150
    74.459   698.062     0.150
    75.022   700.820     0.150
    76.938   709.711     0.150
    76.938   709.852     0.150
    77.414   712.859     0.150
    77.541   713.266     0.150
    77.541   885.062     0.150
    78.685   720.062     0.150
    79.309   724.062     0.150
    79.492   723.094     0.150
    79.492   722.961     0.150
    79.719   725.102     0.150
    79.783   724.859     0.150
    79.792   725.461     0.150
    80.033   726.359     0.150
    80.204   726.766     0.150
    80.208   727.266     0.150
    80.364   727.859     0.150
    80.377   728.062     0.150
    80.480   728.859     0.150
    80.509   728.562     0.150
    80.527   729.164     0.150
    80.555   729.062     0.150
    80.604   729.062     0.150
    80.621   728.359     0.150
    80.638   729.266     0.150
    80.659   729.641     0.150
    80.659   729.375     0.150
    80.679   728.062     0.150
    80.679   729.734     0.150
    80.708   732.062     0.150
    80.708    11.000     0.150
    80.708   919.062     0.150
    80.708  1337.062     0.150
    80.788   730.664     0.150
    80.848   731.062     0.150
    80.970   731.359     0.150
    81.074   731.961     0.150
    81.097   733.266     0.150
    81.167   732.781     0.150
    81.173   732.359     0.150
    81.274   733.305     0.150
    81.343   733.266     0.150
    81.646   734.961     0.150
    81.651   737.859     0.150
    81.670   735.164     0.150
    81.705  1354.062     0.150
    81.726   735.664     0.150
    81.761   735.984     0.150
    81.790   736.859     0.150
    81.936   739.266     0.150
    81.969   737.164     0.150
    81.979   736.961     0.150
    82.025   736.953     0.150
    82.059   736.984     0.150
    82.060   737.266     0.150
    82.081   737.164     0.150
    82.107   737.664     0.150
    82.360   739.859     0.150
    82.361   738.602     0.150
    82.368   739.766     0.150
    82.407   739.062     0.150
    82.441   740.156     0.150
    82.441   746.570     0.150
    82.441    10.562     0.150
    82.562   740.383     0.150
    82.557   740.461     0.150
    82.557    16.398     0.150
    82.557  1350.859     0.150
    82.621   740.070     0.150
    82.646   741.164     0.150
    82.646    10.266     0.150
    82.853   741.164     0.150
    82.867   741.961     0.150
    82.870   741.414     0.150
    82.967   743.039     0.150
    82.967     9.625     0.150
    82.950   741.062     0.150
    82.950    16.000     0.150
    82.950   941.062     0.150
    82.950  1359.062     0.150
    83.059   741.164     0.150
    83.062   742.680     0.150
    83.068   742.766     0.150
    83.069   743.461     0.150
    83.069     9.430     0.150
    83.071   743.359     0.150
    83.071    10.547     0.150
    83.071    11.133     0.150
    83.095   742.914     0.150
    83.095    10.656     0.150
    83.102   743.039     0.150
    83.106   742.953     0.150
    83.122   743.609     0.150
    83.122   750.430     0.150
    83.122    10.695     0.150
    83.174   745.062     0.150
    83.332   742.461     0.150
    83.519   745.352     0.150
    83.519    10.422     0.150
    83.576   745.266     0.150
    83.680   745.961     0.150
    83.848   746.859     0.150
    83.858   747.812     0.150
    83.858     9.609     0.150
    83.858    11.633     0.150
    83.921   747.602     0.150
    83.921    11.000     0.150
    83.969   747.711     0.150
    83.969    11.094     0.150
    83.991   748.711     0.150
    83.991     9.422     0.150
    84.350   749.062     0.150
    84.449   748.766     0.150
    84.449   749.062     0.150
    84.543   750.562     0.150
    84.550   750.766     0.150
    84.578   751.062     0.150
    84.609   753.016     0.150
    84.609  1375.062     0.150
    84.609  1709.062     0.150
    84.653   751.062     0.150
    84.653    13.000     0.150
    84.733   751.062     0.150
    84.786   751.859     0.150
    84.901   752.062     0.150
    84.902   752.266     0.150
    84.958   752.562     0.150
    85.006   752.406     0.150
    85.006   752.812     0.150
    85.013   753.016     0.150
    85.023   754.922     0.150
    85.048   753.664     0.150
    85.048     9.500     0.150
    85.055   752.453     0.150
    85.079   755.562     0.150
    85.176   754.359     0.150
    85.244   753.062     0.150
    85.244  1379.562     0.150
    85.244  1839.664     0.150
    85.284   754.445     0.150
    85.317   753.734     0.150
    85.317   754.805     0.150
    85.317    10.531     0.150
    85.317   754.414     0.150
    85.320   752.562     0.150
    85.320  1373.766     0.150
    85.320  1840.359     0.150
    85.351   753.859     0.150
    85.445   754.062     0.150
    85.559   754.461     0.150
    85.640   754.961     0.150
    85.640  1371.266     0.150
    85.640  1837.562     0.150
    85.723   756.375     0.150
    85.766   756.219     0.150
    85.880   757.062     0.150
    85.946   758.023     0.150
    85.991   756.164     0.150
    86.225   758.461     0.150
    86.251   759.406     0.150
    86.343   759.922     0.150
    86.494   760.922     0.150
    86.524   759.164     0.150
    86.556   760.062     0.150
    86.556  1395.062     0.150
    86.625   760.461     0.150
    86.625  1395.062     0.150
    86.632   760.961     0.150
    86.638   760.062     0.150
    86.665   761.164     0.150
    86.774   760.266     0.150
    86.885   762.414     0.150
    86.985   761.812     0.150
    86.988   763.062     0.150
    86.988   761.234     0.150
    87.034   763.133     0.150
    87.071   761.461     0.150
    87.071   761.062     0.150
    87.089   762.062     0.150
    87.116   761.961     0.150
    87.254   761.945     0.150
    87.385   764.523     0.150
    87.428   764.562     0.150
    87.428    17.500     0.150
    87.442   764.859     0.150
    87.468   764.266     0.150
    87.474   763.805     0.150
    87.474  1737.039     0.150
    87.474   763.930     0.150
    87.512   764.062     0.150
    87.579   763.664     0.150
    87.579   763.062     0.150
    87.584   765.844     0.150
    87.593   763.461     0.150
    87.593   763.062     0.150
    87.714   764.359     0.150
    87.714  1384.766     0.150
    87.714   764.062     0.150
    87.738   766.484     0.150
    87.752   763.461     0.150
    87.795   765.664     0.150
    87.810   765.312     0.150
    87.810   765.641     0.150
    87.856   761.859     0.150
    87.879   765.453     0.150
    87.879   765.992     0.150
    87.959   765.164     0.150
    87.959   765.062     0.150
    87.965   767.664     0.150
    88.026  1400.062     0.150
    88.027   766.789     0.150
    88.070   772.062     0.150
    88.081   767.023     0.150
    88.090   766.961     0.150
    88.098   765.766     0.150
    88.126   767.023     0.150
    88.141   767.531     0.150
    88.155   767.062     0.150
    88.158   767.359     0.150
    88.171   767.625     0.150
    88.211   767.562     0.150
    88.237   767.266     0.150
    88.240   769.461     0.150
    88.242   767.531     0.150
    88.251   768.539     0.150
    88.255   767.250     0.150
    88.269   767.523     0.150
    88.287   766.570     0.150
    88.297   768.211     0.150
    88.297   767.844     0.150
    88.305   767.586     0.150
    88.382   766.875     0.150
    88.401   767.555     0.150
    88.406   768.242     0.150
    88.406   768.375     0.150
    88.406   768.641     0.150
    88.407   767.422     0.150
    88.412   768.180     0.150
    88.415   767.805     0.150
    88.420   768.023     0.150
    88.436   768.289     0.150
    88.452   768.273     0.150
    88.451   768.375     0.150
    88.499   768.539     0.150
    88.555   767.945     0.150
    88.558   769.406     0.150
    88.582   767.859     0.150
    88.593   770.359     0.150
    88.592   769.219     0.150
    88.596   770.062     0.150
    88.596    19.000     0.150
    88.597   768.914     0.150
    88.605   769.766     0.150
    88.609   768.766     0.150
    88.634   769.656     0.150
    88.669   770.266     0.150
    88.670   981.062     0.150
    88.670  1393.062     0.150
    88.670  1423.062     0.150
    88.687   769.492     0.150
    88.704   769.023     0.150
    88.704   769.414     0.150
    88.707   768.789     0.150
    88.793   769.781     0.150
    88.794   770.164     0.150
    88.794   771.062     0.150
    88.794   769.156     0.150
    88.803   770.445     0.150
    88.822   768.594     0.150
    88.822   770.062     0.150
    88.838   770.516     0.150
    88.848   770.133     0.150
    88.865   769.289     0.150
    88.871   769.609     0.150
    88.875   770.680     0.150
    88.910   770.484     0.150
    88.924   770.359     0.150
    88.924   770.062     0.150
    88.932   769.805     0.150
    88.949   769.891     0.150
    88.949   770.219     0.150
    88.972   770.461     0.150
    88.984   770.242     0.150
    88.988   771.461     0.150
    89.066   770.086     0.150
    89.081   772.766     0.150
    89.153   772.141     0.150
    89.153   771.859     0.150
    89.171   772.133     0.150
    89.210   771.289     0.150
    89.223   771.852     0.150
    89.234   772.266     0.150
    89.283   772.805     0.150
    89.299   773.062     0.150
    89.312   771.766     0.150
    89.317   771.266     0.150
    89.317   772.250     0.150
    89.345   771.062     0.150
    89.354   771.961     0.150
    89.361   773.961     0.150
    89.376   772.664     0.150
    89.387   772.891     0.150
    89.406   773.422     0.150
    89.454   773.250     0.150
    89.454   773.695     0.150
    89.466   771.766     0.150
    89.504   773.961     0.150
    89.536   773.586     0.150
    89.612   774.562     0.150
    89.645   774.859     0.150
    89.698   774.305     0.150
    89.730   774.789     0.150
    89.735   774.391     0.150
    89.736   773.570     0.150
    89.752   774.203     0.150
    89.755   774.750     0.150
    89.755   774.375     0.150
    89.761   774.516     0.150
    89.773   774.625     0.150
    89.775   774.422     0.150
    89.776   775.141     0.150
    89.778   774.594     0.150
    89.781   774.539     0.150
    89.792   775.000     0.150
    89.800   774.984     0.150
    89.815   774.750     0.150
    89.867   775.359     0.150
    89.889   775.359     0.150
    89.962   775.023     0.150
    89.977   776.164     0.150
    89.983   775.664     0.150
    90.002   775.859     0.150
    90.009   777.062     0.150
    90.012   776.359     0.150
    90.081   776.664     0.150
    90.118   776.562     0.150
    90.127   778.664     0.150
    90.139   776.859     0.150
    90.261   777.359     0.150
    90.264   776.852     0.150
    90.282   777.664     0.150
    90.282   778.062     0.150
    90.321   777.461     0.150
    90.321   777.266     0.150
    90.334   778.164     0.150
    90.339   775.461     0.150
    90.352   775.359     0.150
    90.390   777.664     0.150
    90.402   777.062     0.150
    90.432   778.766     0.150
    90.433   778.859     0.150
    90.433   778.352     0.150
    90.467   775.859     0.150
    90.481   779.062     0.150
    90.540   779.969     0.150
    90.547   778.664     0.150
    90.556   776.859     0.150
    90.560   777.664     0.150
    90.563   779.875     0.150
    90.590   779.164     0.150
    90.637   778.664     0.150
    90.725   779.359     0.150
    90.725  1416.062     0.150
    90.725  1514.062     0.150
    90.725  1803.062     0.150
    90.725  1813.062     0.150
    90.725  2315.062     0.150
    90.747   778.359     0.150
    90.747   779.414     0.150
    90.762   780.273     0.150
    90.773   781.359     0.150
    90.790   780.062     0.150
    90.899   780.469     0.150
    90.932   778.766     0.150
    90.932   996.266     0.150
    90.932  1406.359     0.150
    90.932  1824.062     0.150
    90.933   778.562     0.150
    90.955   781.680     0.150
    90.980   780.961     0.150
    90.980    18.602     0.150
    90.980  1823.859     0.150
    90.980   781.016     0.150
    90.992   781.383     0.150
    90.994   781.062     0.150
    91.000   781.211     0.150
    91.036   781.062     0.150
    91.035   779.883     0.150
    91.035   778.766     0.150
    91.035    18.594     0.150
    91.040   780.859     0.150
    91.060   781.359     0.150
    91.074   781.062     0.150
    91.077   781.461     0.150
    91.084   781.062     0.150
    91.142   780.961     0.150
    91.142  1412.062     0.150
    91.142  2317.062     0.150
    91.142   997.062     0.150
    91.142  1507.062     0.150
    91.146   779.664     0.150
    91.164   781.672     0.150
    91.207   783.492     0.150
    91.262   779.961     0.150
    91.276   783.289     0.150
    91.283   782.273     0.150
    91.321   782.664     0.150
    91.325   782.164     0.150
    91.372   781.859     0.150
    91.374   782.891     0.150
    91.385   780.859     0.150
    91.443   783.062     0.150
    91.450   783.062     0.150
    91.455   782.789     0.150
    91.462   781.961     0.150
    91.477   782.750     0.150
    91.484   783.250     0.150
    91.497   782.945     0.150
    91.500   783.461     0.150
    91.529   783.234     0.150
    91.538   783.359     0.150
    91.543   783.492     0.150
    91.558   783.594     0.150
    91.586   783.312     0.150
    91.630   784.406     0.150
    91.723   784.906     0.150
    91.769   784.562     0.150
    91.769   784.312     0.150
    91.788   784.805     0.150
    91.822   784.859     0.150
    91.849   785.406     0.150
    91.996   785.859     0.150
    92.074   786.359     0.150
    92.191   786.664     0.150
    92.191   786.430     0.150
    92.198   787.062     0.150
    92.252   786.469     0.150
    92.263   787.859     0.150
    92.313   786.664     0.150
    92.774   788.664     0.150
    92.774  1413.266     0.150
    92.774  1820.766     0.150
    92.358   787.664     0.150
    92.429   788.266     0.150
    92.515   788.766     0.150
    92.515    13.500     0.150
    92.515  1011.062     0.150
    92.515  1419.062     0.150
    92.515  1449.062     0.150
    92.515  1531.062     0.150
    92.567   788.062     0.150
    92.567  1521.062     0.150
    92.578   788.961     0.150
    92.591   787.562     0.150
    92.591  1007.062     0.150
    92.591  1421.062     0.150
    92.591   787.859     0.150
    92.670   788.062     0.150
    92.670    19.000     0.150
    92.670  1009.062     0.150
    92.670  1419.062     0.150
    92.670  1429.062     0.150
    92.670  1448.664     0.150
    92.670  1532.062     0.150
    92.670  2311.562     0.150
    92.670   787.484     0.150
    92.806   787.922     0.150
    92.810   789.266     0.150
    92.810   788.766     0.150
    92.810  1012.961     0.150
    92.924   790.461     0.150
    93.045   790.461     0.150
    93.070   790.062     0.150
    93.143   791.062     0.150
    93.143  1424.562     0.150
    93.191   789.430     0.150
    93.250   789.719     0.150
    93.373   792.062     0.150
    93.433   791.711     0.150
    93.433   791.930     0.150
    93.433   792.055     0.150
    93.443   793.062     0.150
    93.443   793.266     0.150
    93.469   792.062     0.150
    93.493   792.461     0.150
    93.547   796.062     0.150
    93.604   792.062     0.150
    93.604    13.000     0.150
    93.604  1015.062     0.150
    93.604  1425.062     0.150
    93.604  1456.062     0.150
    93.604  1537.062     0.150
    93.655   793.562     0.150
    93.749   795.250     0.150
    93.841   795.602     0.150
    93.903   795.625     0.150
    93.929   795.266     0.150
    93.929  1435.062     0.150
    93.948   796.164     0.150
    94.037   796.609     0.150
    94.025   796.562     0.150
    94.159   795.266     0.150
    94.174   795.922     0.150
    94.236   796.562     0.150
    94.279   794.352     0.150
    94.406   796.266     0.150
    94.406   796.430     0.150
    94.488   797.766     0.150
    94.575   799.062     0.150
    94.575  1436.062     0.150
    94.587   797.164     0.150
    94.638  1023.062     0.150
    94.638   795.586     0.150
    94.692   798.164     0.150
    94.692    18.398     0.150
    94.692  1026.859     0.150
    94.727   798.062     0.150
    94.727  1033.062     0.150
    94.751   797.820     0.150
    94.758   799.961     0.150
    94.765   798.266     0.150
    94.765    18.297     0.150
    94.765  1029.062     0.150
    94.765  1433.062     0.150
    94.793   798.859     0.150
    95.061   799.664     0.150
    95.061    18.102     0.150
    95.061  1038.562     0.150
    95.126   799.766     0.150
    95.166   800.062     0.150
    95.261   801.062     0.150
    95.332   800.664     0.150
    95.332  1032.359     0.150
    95.332  1563.062     0.150
    95.359   801.336     0.150
    95.487   802.016     0.150
    95.505   800.773     0.150
    95.528   801.266     0.150
    95.685   803.664     0.150
    95.713   802.656     0.150
    95.740   802.664     0.150
    95.832   805.062     0.150
    95.832   805.266     0.150
    95.868   803.664     0.150
    95.948   804.062     0.150
    96.072   804.961     0.150
    96.180   805.164     0.150
    96.248   806.961     0.150
    96.359   805.062     0.150
    96.359  1037.062     0.150
    96.359  1480.062     0.150
    96.359  1565.062     0.150
    96.530    11.000     0.150
    96.596   807.562     0.150
    96.596   807.766     0.150
    96.750   807.961     0.150
    96.750   808.375     0.150
    96.745  1439.961     0.150
    97.294   809.664     0.150
    97.294  1441.266     0.150
    97.294  1808.461     0.150
    97.339   811.961     0.150
    97.339  1050.062     0.150
    97.339  1450.562     0.150
    97.592   811.062     0.150
    97.726   815.062     0.150
    97.726  1447.062     0.150
    98.161   813.859     0.150
    98.407   813.562     0.150
    98.571   819.133     0.150
    98.918   818.062     0.150
    99.080   818.562     0.150
    99.217   817.062     0.150
    99.217  1447.062     0.150
    99.217  1915.062     0.150
    99.311   820.164     0.150
    99.335   817.961     0.150
    99.335  1452.062     0.150
    99.335  1481.062     0.150
    99.335  1601.062     0.150
    99.335   817.398     0.150
    99.335   817.602     0.150
    99.607   819.211     0.150
    99.607   818.203     0.150
    99.626   823.062     0.150
    99.660  1455.266     0.150
    99.763   822.766     0.150
    99.816   824.766     0.150
    99.861   821.062     0.150
    99.875   823.359     0.150
   100.797   826.766     0.150
   100.797  1089.664     0.150
   100.798   826.961     0.150
   100.798  1523.664     0.150
   101.126   831.062     0.150
   101.176   828.664     0.150
   101.176  1461.062     0.150
   101.176  1632.062     0.150
   101.216   830.062     0.150
   101.301   829.062     0.150
   101.376   829.562     0.150
   101.400   825.562     0.150
   101.517   829.062     0.150
   101.683   831.062     0.150
   101.841   831.766     0.150
   101.985   830.062     0.150
   101.985  1463.062     0.150
   101.985  1632.062     0.150
   102.001   831.062     0.150
   102.080   834.562     0.150
   102.309   833.062     0.150
   102.420   833.062     0.150
   102.765   835.062     0.150
   102.879   834.062     0.150
   103.010   835.562     0.150
   103.010  1093.766     0.150
   103.010  1790.266     0.150
   103.232   835.641     0.150
   103.299   840.062     0.150
   103.299  1099.062     0.150
   104.078   839.062     0.150
   104.078  1096.062     0.150
   104.078  1478.062     0.150
   104.078  1653.062     0.150
   104.120   840.062     0.150
   104.120  1100.062     0.150
   104.120  1095.164     0.150
   104.120  1469.961     0.150
   104.120  1788.062     0.150
   104.120   839.594     0.150
   104.176   842.062     0.150
   106.035   849.062     0.150
   106.035  1115.062     0.150
   106.035  1489.062     0.150
   106.035  1673.062     0.150
   106.069   852.062     0.150
   106.069  1114.062     0.150
   106.069  1482.062     0.150
   106.069  1659.062     0.150
   106.069  1792.062     0.150
   106.160   846.859     0.150
   106.974   851.359     0.150
   106.974  1101.961     0.150
   106.974  1784.062     0.150
   107.158   853.062     0.150
   107.158  1115.062     0.150
   107.158  1491.062     0.150
   107.158  1677.062     0.150
   107.696  1123.062     0.150
   107.696  1495.062     0.150
   107.696  1685.062     0.150
   107.948   857.266     0.150
   107.948  1776.266     0.150
   108.014   861.062     0.150
   108.476   859.062     0.150
   109.640   869.062     0.150
   109.640  1141.062     0.150
   109.673  1139.062     0.150
   109.673  1501.062     0.150
   109.673  1707.062     0.150
   110.653   870.859     0.150
   110.653  1509.164     0.150
   110.653  1719.664     0.150
   110.653  2084.562     0.150
   110.653   869.570     0.150
   110.661   871.266     0.150
   110.661  1148.266     0.150
   110.743   871.562     0.150
   110.743  1145.062     0.150
   110.743  2081.062     0.150
   110.926   870.266     0.150
   110.926  1767.961     0.150
   111.664  2085.062     0.150
   112.045  1773.359     0.150
   112.116   875.062     0.150
   112.116  1155.062     0.150
   112.902  1170.062     0.150
   112.902  1524.062     0.150
   113.192   880.062     0.150
   113.343   883.062     0.150
   113.343   885.062     0.150
   113.343  1166.664     0.150
   113.343  1516.062     0.150
   113.343  1738.062     0.150
   113.942  1763.664     0.150
   114.054  1117.062     0.150
   114.054  1173.062     0.150
   114.066  1114.266     0.150
   114.901  1173.062     0.150
   115.242  1761.062     0.150
   115.303   894.062     0.150
   115.303  1181.062     0.150
   115.303  2132.062     0.150
   115.316   891.062     0.150
   115.316  1121.062     0.150
   115.316  1183.062     0.150
   117.066   899.062     0.150
   117.241  1122.266     0.150
   117.624  1119.859     0.150
   117.624  1199.461     0.150
   117.624  1336.062     0.150
   117.624  1545.062     0.150
   117.624  2161.062     0.150
   117.661  1121.281     0.150
   117.798  1123.766     0.150
   117.798  1751.859     0.150
   118.678  1126.062     0.150
   118.978   910.062     0.150
   118.978  1555.062     0.150
   118.978  1618.062     0.150
   118.924  1127.562     0.150
   118.924  1207.062     0.150
   118.924  1783.062     0.150
   118.924  2176.062     0.150
   119.318  1215.062     0.150
   119.318  1551.062     0.150
   119.817  1212.562     0.150
   119.946  1127.859     0.150
   119.946  1213.062     0.150
   120.014  1129.062     0.150
   120.465  1129.062     0.150
   120.748  1128.562     0.150
   120.748  1730.359     0.150
   121.166  1130.062     0.150
   121.321  1129.766     0.150
   121.321  1733.461     0.150
   122.665  1135.266     0.150
   122.665  1151.062     0.150
   122.665  1232.062     0.150
   122.665  1351.062     0.150
   122.665  1562.062     0.150
   122.665  1640.062     0.150
   122.665  2222.062     0.150
   124.051  1136.266     0.150
   124.190  1129.062     0.150
   124.950  1138.062     0.150
   124.950  1152.062     0.150
   124.950  1244.062     0.150
   125.170  1141.961     0.150
   125.255  1139.734     0.150
   125.455  1137.859     0.150
   125.889  1253.062     0.150
   125.889  1254.062     0.150
   125.889  2274.062     0.150
   126.105  1140.164     0.150
   126.116  1139.359     0.150
   126.437  1141.562     0.150
   126.573  1140.961     0.150
   126.959  1141.266     0.150
   126.961  1140.664     0.150
   127.225  1143.062     0.150
   127.362  1143.391     0.150
   128.646  1145.812     0.150
   129.688  1145.859     0.150
   129.688  1276.266     0.150
   129.688  1695.766     0.150
   129.688  2463.359     0.150
   130.125  1148.234     0.150
   130.318  1150.062     0.150
   130.318  1165.062     0.150
   130.318  1364.859     0.150
   130.318  1576.062     0.150
   130.584  1151.062     0.150
   130.584  1287.062     0.150
   130.584  1364.062     0.150
   130.584  1571.062     0.150
   130.584  1693.062     0.150
   131.068  1286.062     0.150
   131.068  1361.062     0.150
   131.698  1150.492     0.150
   132.324  1153.859     0.150
   132.536  1153.531     0.150
   132.561  1152.891     0.150
   132.866  1153.312     0.150
   133.184  1153.875     0.150
   133.372  1155.492     0.150
   133.475  1155.242     0.150
   133.482  1301.062     0.150
   133.537  1153.711     0.150
   133.588  1155.320     0.150
   133.662  1157.211     0.150
   133.695  1155.133     0.150
   133.673  1366.766     0.150
   133.901  1156.086     0.150
   134.204  1155.859     0.150
   134.277  1156.602     0.150
   137.365  1156.703     0.150
   137.356  1158.562     0.150
   137.509  1160.062     0.150
   137.509  1330.164     0.150
   137.759  1160.664     0.150
   137.811  1161.461     0.150
   137.811  1327.461     0.150
   139.500  1164.062     0.150
   140.858  1160.461     0.150
   140.973  1164.062     0.150
   140.995  1164.062     0.150
   141.171  1168.461     0.150
   142.056  1163.562     0.150
   142.887  1166.062     0.150
   143.446  1168.562     0.150
   143.955  1173.062     0.150
   144.669  1171.562     0.150
   144.669  1373.062     0.150
   144.669  1389.062     0.150
   144.669  2497.062     0.150
   144.993  1174.664     0.150
   146.425  1179.266     0.150
   146.425  1593.062     0.150
   147.371  1182.164     0.150
   147.459  1181.859     0.150
   148.485  1183.062     0.150
   151.464  1192.266     0.150
   151.582  1192.461     0.150
   151.807  1192.164     0.150
   151.943  1192.961     0.150
   152.124  1192.164     0.150
     1.421    25.148     0.150
     1.744    31.719     0.150
     2.309    38.818     0.150
     2.441    40.148     0.150
     2.441    70.388     0.150
     2.686    43.248     0.150
     2.686    73.388     0.150
     3.116    50.039     0.150
     3.116    84.388     0.150
     3.237    50.878     0.150
     3.268    50.888     0.150
     3.268    89.388     0.150
     3.331    53.578     0.150
     3.331    95.688     0.150
     3.562    57.839     0.150
     3.562    98.289     0.150
     3.699    58.539     0.150
     3.699    98.789     0.150
     3.744    58.888     0.150
     3.744   104.388     0.150
     3.756    58.958     0.150
     3.756   105.388     0.150
     3.865    60.508     0.150
     3.865   106.188     0.150
     3.896    60.729     0.150
     3.896   104.888     0.150
     4.170    65.808     0.150
     4.170   110.888     0.150
     4.203    65.159     0.150
     4.203   115.589     0.150
     4.454    73.388     0.150
     4.835    73.818     0.150
     5.314    81.798     0.150
     5.956    91.708     0.150
     6.113    91.888     0.150
    11.268   163.589     0.150
    18.881   258.888     0.150
    19.710   270.789     0.150
    20.966   281.659     0.150
    21.104   284.289     0.150
    25.294   325.089     0.150
    32.625   387.789     0.150
    33.242   392.488     0.150
    45.160   493.488     0.150
    45.888   499.488     0.150
    51.315   540.189     0.150
    53.838   560.988     0.150
    55.153   570.888     0.150
    63.593   631.488     0.150
    85.310   757.189     0.150
    85.397   756.289     0.150
    85.717   757.988     0.150
    87.786   767.888     0.150
    91.009   782.289     0.150
   126.078  1142.688     0.150
   126.915  1143.888     0.150
   132.607  1155.848     0.150
   132.632  1154.928     0.150
   132.938  1155.529     0.150
   133.255  1156.789     0.150
   133.608  1156.408     0.150
   144.741  1174.388     0.150
   148.559  1186.388     0.150
     1.113    19.503     0.150
     1.113    31.693     0.150
     1.895    56.093     0.150
     2.130    36.453     0.150
     2.383    37.663     0.150
     2.383    66.083     0.150
     2.512    42.093     0.150
     2.813    45.733     0.150
     2.813    85.693     0.150
     2.961    47.193     0.150
     2.961    86.393     0.150
     3.064    49.953     0.150
     3.064    85.133     0.150
     3.286    54.433     0.150
     3.286    90.193     0.150
     3.411    54.403     0.150
     3.411    92.593     0.150
     3.465    54.193     0.150
     3.465    98.693     0.150
     3.486    57.533     0.150
     3.486    92.393     0.150
     3.609    56.693     0.150
     3.609    98.193     0.150
     3.626    57.503     0.150
     3.626    96.493     0.150
     3.877    61.453     0.150
     3.877   126.093     0.150
     3.935   105.493     0.150
     5.013    79.693     0.150
     5.641    86.473     0.150
    11.325   165.593     0.150
    18.866   261.193     0.150
    19.921   273.393     0.150
    21.074   283.573     0.150
    21.792   291.183     0.150
    24.218   312.293     0.150
    25.392   325.793     0.150
    25.392   537.793     0.150
    28.934   357.193     0.150
    32.614   387.193     0.150
    45.236   493.193     0.150
    45.236   594.493     0.150
    45.770   499.093     0.150
    55.298   571.493     0.150
    55.298   632.193     0.150
    63.301   628.293     0.150
    80.602   730.193     0.150
    84.241   749.893     0.150
    84.343   750.393     0.150
    84.626   751.693     0.150
    85.092   754.393     0.150
    85.343   756.693     0.150
    86.390   760.793     0.150
    86.515   760.593     0.150
    86.956   762.793     0.150
    86.956   762.993     0.150
    87.470   764.293     0.150
    87.606   766.293     0.150
    97.483   814.193     0.150
   126.366  1142.693     0.150
   126.378  1142.193     0.150
   127.206  1143.493     0.150
   132.667  1154.393     0.150
   132.689  1154.453     0.150
   132.994  1156.013     0.150
   133.322  1155.433     0.150
   133.671  1156.593     0.150
   138.054  1164.893     0.150
   144.787  1174.193     0.150
   144.787  1184.693     0.150
   148.594  1188.193     0.150
     1.252    22.023     0.150
     1.252    40.727     0.150
     1.799    31.719     0.150
     1.799    50.500     0.150
     2.179    37.211     0.150
     2.179    64.000     0.150
     2.448    40.062     0.150
     2.448    70.500     0.150
     2.521    39.750     0.150
     2.521    71.000     0.150
     2.951    46.328     0.150
     2.951    78.797     0.150
     3.086    48.242     0.150
     3.086    82.500     0.150
     3.162    51.031     0.150
     3.389    54.094     0.150
     3.389    89.602     0.150
     3.522    55.773     0.150
     3.539    55.039     0.150
     3.539    95.102     0.150
     3.570    55.000     0.150
     3.570    96.000     0.150
     3.586    56.719     0.150
     3.586    98.500     0.150
     3.693    58.422     0.150
     3.693   101.797     0.150
     3.720    58.508     0.150
     3.726    58.602     0.150
     3.991    63.039     0.150
     3.991   109.500     0.150
     4.034    62.133     0.150
     4.274    64.609     0.150
     5.133    76.102     0.150
     5.778    88.406     0.150
     6.203    92.500     0.150
    10.486   153.688     0.150
    17.067   240.000     0.150
    17.076   236.500     0.150
    17.776   246.500     0.150
    18.014   249.703     0.150
    18.842   259.500     0.150
    19.246   261.898     0.150
    19.808   271.844     0.150
    20.999   282.500     0.150
    21.294   289.852     0.150
    21.736   291.500     0.150
    22.429   298.930     0.150
    23.657   311.844     0.150
    24.911   320.992     0.150
    25.220   325.242     0.150
    25.321   325.000     0.150
    25.321   537.398     0.150
    28.859   357.000     0.150
    32.589   387.500     0.150
    32.589     8.000     0.150
    33.138   391.203     0.150
    39.266   448.000     0.150
    39.758   448.500     0.150
    45.053   594.703     0.150
    45.174   493.297     0.150
    45.174     8.906     0.150
    45.174   594.500     0.150
    45.793   498.602     0.150
    45.793   597.703     0.150
    46.044   505.500     0.150
    48.195   520.898     0.150
    48.386   520.297     0.150
    51.277   542.844     0.150
    53.384   559.500     0.150
    53.871   561.203     0.150
    53.871     8.094     0.150
    54.063   563.367     0.150
    54.163   563.727     0.150
    54.268   564.539     0.150
    55.045   570.531     0.150
    55.179   570.867     0.150
    55.209   570.602     0.150
    56.789   581.797     0.150
    57.735   588.398     0.150
    58.300   592.977     0.150
    58.861   595.797     0.150
    58.861     8.805     0.150
    62.204   620.094     0.150
    62.204     9.047     0.150
    62.352   621.172     0.150
    62.352     8.961     0.150
    63.422   629.258     0.150
    68.799   664.000     0.150
    68.799     9.203     0.150
    68.799   688.203     0.150
    68.880   664.500     0.150
    68.880     8.797     0.150
    70.597   674.898     0.150
    70.597     9.000     0.150
    71.033   677.711     0.150
    71.033     8.938     0.150
    71.033    12.117     0.150
    76.972   720.906     0.150
    78.113   716.898     0.150
    78.113     8.398     0.150
    79.997   728.102     0.150
    80.161   729.602     0.150
    80.172   729.000     0.150
    80.327   729.797     0.150
    80.444   730.203     0.150
    80.566   730.797     0.150
    80.641   730.711     0.150
    80.854   733.500     0.150
    80.895   733.273     0.150
    81.296   734.602     0.150
    81.597   737.023     0.150
    82.012   738.703     0.150
    82.032   739.844     0.150
    82.326   740.102     0.150
    82.475   740.500     0.150
    82.690   741.797     0.150
    82.690    10.305     0.150
    82.690   939.898     0.150
    82.690  1363.703     0.150
    82.690  1677.500     0.150
    82.795   742.203     0.150
    83.000   744.000     0.150
    83.274   744.398     0.150
    83.496   746.523     0.150
    83.761   748.422     0.150
    84.294   750.203     0.150
    84.395   750.797     0.150
    84.489   752.500     0.150
    84.555   752.500     0.150
    84.678   752.203     0.150
    84.707   752.711     0.150
    84.816   753.180     0.150
    84.840   755.500     0.150
    85.087   754.727     0.150
    85.164   754.500     0.150
    85.164     8.898     0.150
    85.212   755.852     0.150
    85.299   755.508     0.150
    85.299     9.359     0.150
    85.337   755.898     0.150
    85.337     8.203     0.150
    85.337   755.297     0.150
    85.384   755.500     0.150
    85.410   755.500     0.150
    85.410    11.398     0.150
    85.626   756.000     0.150
    85.626    10.500     0.150
    85.637   757.711     0.150
    85.696   757.453     0.150
    85.796   758.117     0.150
    85.921   758.500     0.150
    86.149   759.148     0.150
    86.257   761.031     0.150
    86.407   759.609     0.150
    86.454   761.000     0.150
    86.575   761.203     0.150
    86.583   762.320     0.150
    86.726   761.398     0.150
    86.801   763.289     0.150
    87.012   762.500     0.150
    87.020   763.297     0.150
    87.069   763.000     0.150
    87.310   763.797     0.150
    87.314   765.711     0.150
    87.363   766.719     0.150
    87.388   766.000     0.150
    87.388     9.500     0.150
    87.429   765.523     0.150
    87.429     9.250     0.150
    87.429  1409.078     0.150
    87.429  1756.680     0.150
    87.449   764.703     0.150
    87.523   764.703     0.150
    87.536   764.500     0.150
    87.655   767.031     0.150
    87.659   765.602     0.150
    87.700   768.102     0.150
    87.891   768.602     0.150
    87.902   766.297     0.150
    87.951   770.500     0.150
    88.033     8.242     0.150
    88.170   768.203     0.150
    88.230   768.594     0.150
    88.546   771.297     0.150
    88.558   771.102     0.150
    88.597   771.031     0.150
    88.648   770.859     0.150
    88.659   770.000     0.150
    88.659     8.500     0.150
    88.748   772.602     0.150
    88.765   771.961     0.150
    88.839   772.117     0.150
    88.873   771.203     0.150
    88.949   772.367     0.150
    89.109   773.898     0.150
    89.109     9.203     0.150
    89.115   773.609     0.150
    89.173   773.203     0.150
    89.249   772.898     0.150
    89.261   772.797     0.150
    89.267   772.797     0.150
    89.295   773.398     0.150
    89.306   775.102     0.150
    89.414   775.398     0.150
    89.415   774.773     0.150
    89.452   775.398     0.150
    89.497   775.000     0.150
    89.599   776.297     0.150
    89.815   775.859     0.150
    89.839   776.797     0.150
    89.923   776.500     0.150
    89.927   777.602     0.150
    89.939   778.398     0.150
    90.061   778.602     0.150
    90.083   778.797     0.150
    90.131   778.703     0.150
    90.131     7.797     0.150
    90.204   778.500     0.150
    90.224   778.602     0.150
    90.270   779.102     0.150
    90.276   780.297     0.150
    90.279   780.102     0.150
    90.288   779.797     0.150
    90.340   780.203     0.150
    90.339   779.602     0.150
    90.375   778.703     0.150
    90.376   780.602     0.150
    90.404   778.297     0.150
    90.434   780.297     0.150
    90.492   780.703     0.150
    90.495   780.500     0.150
    90.541   780.297     0.150
    90.561   779.500     0.150
    90.577   779.703     0.150
    90.684   781.703     0.150
    90.684     8.695     0.150
    90.735   782.703     0.150
    90.870   780.898     0.150
    90.932   781.500     0.150
    90.932     8.500     0.150
    90.937   782.602     0.150
    90.937     9.500     0.150
    90.938   782.000     0.150
    90.980   782.500     0.150
    91.008   783.102     0.150
    91.011   781.297     0.150
    91.021   781.297     0.150
    91.031   780.500     0.150
    91.085   783.102     0.150
    91.104   782.500     0.150
    91.104     9.102     0.150
    91.191   784.000     0.150
    91.201   783.297     0.150
    91.271   784.750     0.150
    91.272   784.102     0.150
    91.317   782.703     0.150
    91.324   784.398     0.150
    91.389   782.898     0.150
    91.400   784.898     0.150
    91.487   786.102     0.150
    91.771   786.797     0.150
    91.837   787.203     0.150
    91.837     8.594     0.150
    92.026   787.203     0.150
    92.149   788.102     0.150
    92.310   788.703     0.150
    92.381   789.797     0.150
    92.848   790.203     0.150
    92.848     8.898     0.150
    92.549   789.500     0.150
    92.549     9.000     0.150
    92.549   789.258     0.150
    92.663   791.500     0.150
    92.663     8.398     0.150
    92.631     8.102     0.150
    92.631    12.602     0.150
    92.767   790.500     0.150
    92.767   790.000     0.150
    92.767     9.203     0.150
    92.993   790.898     0.150
    93.007   790.398     0.150
    93.434   795.000     0.150
    93.610   793.797     0.150
    94.179   797.203     0.150
    94.369   797.898     0.150
    94.386   797.922     0.150
    94.544   799.844     0.150
    94.657   799.797     0.150
    94.657     9.102     0.150
    94.716   799.500     0.150
    94.716     9.000     0.150
    95.020   801.398     0.150
    95.020    10.102     0.150
    95.070   800.898     0.150
    95.108   800.438     0.150
    95.212   802.352     0.150
    95.339   802.828     0.150
    95.468   802.297     0.150
    95.566   803.992     0.150
    95.637   803.898     0.150
    95.807   806.000     0.150
    95.907   806.898     0.150
    96.037   805.500     0.150
    96.536   807.102     0.150
    96.712   809.602     0.150
    97.402   812.703     0.150
    97.402   819.703     0.150
    97.899   813.930     0.150
    98.519   815.500     0.150
    99.038   819.500     0.150
    99.333   819.500     0.150
    99.333   829.500     0.150
   100.956   828.500     0.150
   101.126   829.000     0.150
   101.126   837.500     0.150
   101.248   829.500     0.150
   101.339   830.500     0.150
   102.194   831.000     0.150
   102.194   842.000     0.150
   107.231   856.797     0.150
   107.231  1120.703     0.150
   108.122   862.500     0.150
   115.438  1121.000     0.150
   117.711  1124.797     0.150
   117.711  1139.500     0.150
   117.711  1612.500     0.150
   119.092  1127.500     0.150
   119.963  1129.000     0.150
   120.081  1129.000     0.150
   120.589  1130.500     0.150
   120.589  1217.000     0.150
   120.860  1131.203     0.150
   120.860  1140.500     0.150
   121.460  1132.203     0.150
   121.460  1142.000     0.150
   122.726  1135.797     0.150
   122.726  1145.500     0.150
   122.726  1232.500     0.150
   122.726  1350.500     0.150
   123.948  1136.703     0.150
   125.080  1139.797     0.150
   125.080  1250.898     0.150
   126.247  1142.297     0.150
   126.247  1151.602     0.150
   126.258  1140.703     0.150
   126.258  1150.602     0.150
   127.093  1142.000     0.150
   127.093  1152.000     0.150
   127.096  1152.898     0.150
   127.365  1143.797     0.150
   129.605  1147.203     0.150
   129.605  1155.602     0.150
   130.454  1149.500     0.150
   130.689  1151.898     0.150
   131.019  1152.500     0.150
   132.612  1149.344     0.150
   132.635  1149.000     0.150
   132.941  1151.039     0.150
   133.264  1150.703     0.150
   133.456  1156.258     0.150
   133.545  1155.000     0.150
   133.566  1155.922     0.150
   133.615  1153.938     0.150
   133.676  1155.398     0.150
   133.759  1156.203     0.150
   133.797  1153.617     0.150
   133.990  1155.797     0.150
   134.049  1156.062     0.150
   134.301  1156.820     0.150
   134.371  1156.062     0.150
   137.948  1162.398     0.150
   137.948  1173.500     0.150
   140.984  1163.203     0.150
   143.495  1169.500     0.150
   144.738  1173.500     0.150
   144.738  1183.500     0.150
   144.738  1187.500     0.150
   144.941  1175.500     0.150
   145.132  1177.500     0.150
   147.537  1181.500     0.150
   147.620  1184.500     0.150
   148.550  1182.500     0.150
   151.299  1194.000     0.150
   151.418  1194.500     0.150
   151.641  1194.703     0.150
   151.778  1195.102     0.150
   151.959  1195.203     0.150
     1.157    19.637     0.150
     1.157    37.906     0.150
     1.961    33.906     0.150
     1.961    58.484     0.150
     2.265    37.805     0.150
     2.417    37.586     0.150
     2.417    66.258     0.150
     2.607    42.156     0.150
     2.607    71.766     0.150
     2.846    44.605     0.150
     2.846    76.984     0.150
     3.026    47.664     0.150
     3.026    91.336     0.150
     3.055    48.355     0.150
     3.186    49.676     0.150
     3.186    98.625     0.150
     3.522    55.637     0.150
     3.522    98.188     0.150
     3.528    54.266     0.150
     3.528    94.387     0.150
     3.581    56.586     0.150
     3.581   100.086     0.150
     3.607    56.688     0.150
     3.721    58.734     0.150
     3.985    62.195     0.150
     4.055    62.324     0.150
     4.263    66.625     0.150
     4.567    68.145     0.150
     5.114    78.586     0.150
     5.114   138.586     0.150
     5.705    86.805     0.150
     5.705   149.586     0.150
     6.360   108.246     0.150
     6.360   166.055     0.150
    11.427   165.387     0.150
    18.151   250.688     0.150
    19.963   272.887     0.150
    21.160   284.137     0.150
    21.299   286.477     0.150
    21.456   289.125     0.150
    21.893   293.055     0.150
    22.586   301.055     0.150
    23.816   313.125     0.150
    24.353   314.285     0.150
    25.376   327.285     0.150
    25.482   326.086     0.150
    25.482   538.387     0.150
    25.482   757.484     0.150
    29.020   359.387     0.150
    29.020   548.984     0.150
    32.733   388.887     0.150
    32.733     9.500     0.150
    32.733   556.188     0.150
    33.242   392.484     0.150
    45.333   494.984     0.150
    45.333     8.801     0.150
    45.333   828.586     0.150
    48.052   520.066     0.150
    51.375   541.984     0.150
    54.429   566.586     0.150
    55.371   572.785     0.150
    55.371     9.102     0.150
    56.949   582.895     0.150
    57.895   590.145     0.150
    58.462   594.086     0.150
    63.303   627.484     0.150
    63.303     7.703     0.150
    65.507   643.387     0.150
    65.507     7.000     0.150
    68.703   664.086     0.150
    78.254   718.785     0.150
    80.737   731.855     0.150
    82.875   743.785     0.150
    83.079   744.785     0.150
    83.355   746.086     0.150
    84.375   751.887     0.150
    84.477   752.484     0.150
    84.760   753.484     0.150
    85.222   755.984     0.150
    85.222     7.301     0.150
    85.450   756.785     0.150
    85.469   757.188     0.150
    85.462   757.285     0.150
    85.739   758.984     0.150
    85.911   760.484     0.150
    85.990   759.887     0.150
    86.212   761.484     0.150
    86.523   762.887     0.150
    86.640   763.805     0.150
    86.649   762.188     0.150
    86.814   762.984     0.150
    86.856   764.508     0.150
    87.089   764.688     0.150
    87.090   764.188     0.150
    87.157   764.785     0.150
    87.390   765.484     0.150
    87.524   766.285     0.150
    87.604   766.484     0.150
    87.617   766.188     0.150
    87.983   767.984     0.150
    88.242   769.984     0.150
    88.958   773.086     0.150
    89.201   775.387     0.150
    89.250   774.984     0.150
    89.346   774.586     0.150
    89.403   775.086     0.150
    90.001   778.188     0.150
    90.284   779.984     0.150
    90.304   779.188     0.150
    90.656   781.387     0.150
    91.030   783.984     0.150
    91.030     7.301     0.150
    91.096   783.086     0.150
    92.860   791.285     0.150
    92.860     7.902     0.150
    92.860  1014.984     0.150
    95.184   802.734     0.150
    95.310   803.277     0.150
    95.330   802.785     0.150
    95.537   804.414     0.150
    97.564   814.086     0.150
    97.564   821.285     0.150
   117.518  1124.785     0.150
   117.518  1131.086     0.150
   120.838  1131.387     0.150
   120.838  1138.387     0.150
   127.100  1143.785     0.150
   127.100  1150.586     0.150
   131.421  1151.484     0.150
   131.421  1159.887     0.150
   138.106  1165.285     0.150
   138.106  1173.285     0.150
   144.893  1175.086     0.150
     0.553    14.805     0.150
     0.553    25.345     0.150
     1.549    26.395     0.150
     1.549    45.465     0.150
     1.860    30.425     0.150
     1.860    53.284     0.150
     2.017    33.624     0.150
     2.017    57.975     0.150
     2.087    33.244     0.150
     2.087    56.944     0.150
     3.338    52.314     0.150
     3.516    54.084     0.150
     3.516    94.954     0.150
     3.600    55.935     0.150
     3.750    58.175     0.150
     3.750   100.975     0.150
     3.760    56.645     0.150
     3.760    99.255     0.150
     3.782    58.345     0.150
     3.782   103.135     0.150
     3.792    58.515     0.150
     3.792    59.024     0.150
     3.792   102.175     0.150
     3.885    59.694     0.150
     3.885   103.984     0.150
     4.184    64.614     0.150
     4.184   111.305     0.150
     4.249    64.895     0.150
     4.249   115.185     0.150
     4.298    65.954     0.150
     4.298    66.084     0.150
     4.298    66.354     0.150
     4.298   114.744     0.150
     4.298   118.164     0.150
     4.564    70.215     0.150
     4.564   126.505     0.150
     5.213    76.954     0.150
     5.213   133.055     0.150
     5.429    79.965     0.150
     5.480    83.234     0.150
     5.480   144.204     0.150
     6.396    95.034     0.150
     6.396   164.584     0.150
     6.402    95.484     0.150
     6.402   168.414     0.150
     7.439   109.114     0.150
    10.364   149.734     0.150
    12.835   179.207     0.150
    12.835   326.405     0.150
    13.255   188.185     0.150
    15.466   216.664     0.150
    15.624   218.584     0.150
    15.807   221.055     0.150
    16.214   226.533     0.150
    16.214   414.882     0.150
    18.833   256.680     0.150
    19.646   264.794     0.150
    19.758   262.994     0.150
    19.807   264.354     0.150
    19.908   267.114     0.150
    20.036   267.675     0.150
    20.033   267.074     0.150
    20.077   266.755     0.150
    20.261   268.354     0.150
    20.819   276.524     0.150
    20.853   274.234     0.150
    20.901   277.124     0.150
    20.901   296.175     0.150
    21.024   279.584     0.150
    21.024   296.874     0.150
    21.306   282.824     0.150
    21.315   282.645     0.150
    21.463   283.874     0.150
    21.821   284.131     0.150
    21.821   520.680     0.150
    21.821   956.819     0.150
    21.893   286.536     0.150
    21.893   532.188     0.150
    22.508   294.204     0.150
    22.759   297.685     0.150
    23.304   299.354     0.150
    23.398   303.604     0.150
    23.457   304.294     0.150
    23.469   305.050     0.150
    23.709   305.145     0.150
    24.198   308.114     0.150
    24.240   311.064     0.150
    24.367   310.975     0.150
    24.766   313.024     0.150
    24.976   317.944     0.150
    25.101   318.334     0.150
    25.202   318.334     0.150
    25.187   316.774     0.150
    25.359   320.324     0.150
    25.394   320.675     0.150
    25.734   327.284     0.150
    25.826   323.925     0.150
    26.284   326.465     0.150
    26.317   329.305     0.150
    26.727   333.244     0.150
    26.851   334.274     0.150
    26.983   332.694     0.150
    27.054   335.895     0.150
    27.127   333.604     0.150
    27.782   342.294     0.150
    27.895   343.624     0.150
    28.170   344.624     0.150
    28.577   347.265     0.150
    28.605   348.794     0.150
    28.832   348.694     0.150
    29.110   353.354     0.150
    29.377   357.234     0.150
    29.634   359.694     0.150
    29.700   359.444     0.150
    30.441   365.685     0.150
    30.460   363.664     0.150
    30.615   364.574     0.150
    31.114   373.435     0.150
    31.295   374.614     0.150
    31.345   374.965     0.150
    31.355   373.864     0.150
    31.376   373.564     0.150
    31.690   377.294     0.150
    31.785   378.864     0.150
    31.783   375.449     0.150
    32.049   380.544     0.150
    32.271   381.755     0.150
    32.699   383.114     0.150
    32.925   387.465     0.150
    32.983   388.215     0.150
    33.454   393.175     0.150
    35.069   405.204     0.150
    36.299   414.784     0.150
    44.241   480.475     0.150
    44.241   585.524     0.150
    45.232   488.374     0.150
    45.232   588.425     0.150
    49.124   522.313     0.150
    52.397   546.225     0.150
    52.911   549.454     0.150
    53.280   551.104     0.150
    54.225   558.418     0.150
    54.225   620.719     0.150
    54.252   558.555     0.150
    54.620   560.824     0.150
    55.801   569.324     0.150
    56.746   575.805     0.150
    57.315   579.005     0.150
    63.286   622.197     0.150
    64.236   629.273     0.150
    64.251   629.324     0.150
    66.656   645.186     0.150
    80.444   724.124     0.150
    80.636   724.524     0.150
    80.750   724.225     0.150
    81.325   728.024     0.150
    81.775   730.725     0.150
    82.103   732.024     0.150
    82.238   732.925     0.150
    83.024   736.474     0.150
    83.272   738.624     0.150
    83.580   740.524     0.150
    83.920   742.225     0.150
    84.014   742.324     0.150
    84.298   743.225     0.150
    84.613   744.547     0.150
    84.625   745.725     0.150
    84.703   746.066     0.150
    84.731   746.460     0.150
    84.746   745.524     0.150
    84.746   745.800     0.150
    84.919   747.925     0.150
    84.933   747.725     0.150
    84.938   746.524     0.150
    84.938   746.524     0.150
    85.035   746.824     0.150
    85.446   750.024     0.150
    85.593   750.624     0.150
    85.674   751.725     0.150
    85.896   752.324     0.150
    85.979   753.225     0.150
    86.067   753.324     0.150
    86.163   753.824     0.150
    86.188   754.225     0.150
    86.225   753.725     0.150
    86.246   752.925     0.150
    86.307   753.425     0.150
    86.366   754.624     0.150
    86.565   756.324     0.150
    86.598   755.925     0.150
    86.608   754.624     0.150
    86.657   754.725     0.150
    86.722   755.524     0.150
    86.931   757.024     0.150
    86.948   755.824     0.150
    87.029   757.425     0.150
    87.067   757.925     0.150
    87.115   756.925     0.150
    87.125   758.524     0.150
    87.151   756.024     0.150
    87.169   756.124     0.150
    87.260   758.225     0.150
    87.282   757.225     0.150
    87.384   758.524     0.150
    87.402   759.624     0.150
    87.446   759.324     0.150
    87.535   758.425     0.150
    87.612   760.364     0.150
    87.627   759.925     0.150
    87.687   761.024     0.150
    87.739   761.124     0.150
    87.753   760.624     0.150
    87.859   760.725     0.150
    88.318   763.385     0.150
    88.474   763.425     0.150
    88.634   764.324     0.150
    88.714   764.624     0.150
    88.828   764.524     0.150
    88.841   764.324     0.150
    88.861   765.324     0.150
    89.839   770.425     0.150
    89.859   769.824     0.150
    89.877   770.294     0.150
    89.902   768.725     0.150
    90.164   770.425     0.150
    90.223   772.024     0.150
    90.280   771.600     0.150
    90.492   774.124     0.150
    90.977   776.624     0.150
    91.362   777.324     0.150
    92.320   781.850     0.150
    94.562   791.725     0.150
    96.427   801.874     0.150
   120.855  1124.774     0.150
   126.907  1136.475     0.150
   130.535  1143.624     0.150
   132.273  1147.122     0.150
   143.838  1165.024     0.150
     1.217    21.086     0.150
     1.217    35.094     0.150
     1.451    25.234     0.150
     1.451    43.625     0.150
     2.050    35.148     0.150
     2.050    59.875     0.150
     2.362    38.289     0.150
     2.362    68.656     0.150
     2.488    39.336     0.150
     2.488    69.055     0.150
     2.667    41.508     0.150
     2.667    74.648     0.150
     2.964    46.438     0.150
     2.964    81.266     0.150
     2.918    45.070     0.150
     2.918    77.398     0.150
     2.995    47.977     0.150
     3.046    48.547     0.150
     3.046    85.891     0.150
     3.147    50.547     0.150
     3.147    86.328     0.150
     3.276    51.469     0.150
     3.276    91.195     0.150
     3.358    56.320     0.150
     3.415    54.695     0.150
     3.415    96.055     0.150
     3.437    54.266     0.150
     3.437    92.891     0.150
     3.459    53.438     0.150
     3.459    55.750     0.150
     3.459    56.938     0.150
     3.459    97.664     0.150
     3.471    55.648     0.150
     3.471    96.820     0.150
     3.558    56.750     0.150
     3.558   101.016     0.150
     3.566    58.438     0.150
     3.611    57.781     0.150
     3.611    99.219     0.150
     3.833    62.227     0.150
     3.833   107.227     0.150
     3.887    60.961     0.150
     3.887    61.820     0.150
     3.887    62.914     0.150
     3.887   107.516     0.150
     3.887   107.898     0.150
     3.952    60.938     0.150
     3.952   106.984     0.150
     4.128    64.359     0.150
     4.280    68.938     0.150
     4.280   116.938     0.150
     5.035    74.984     0.150
     5.714    86.938     0.150
     5.714   155.180     0.150
    11.177   161.898     0.150
    11.177   163.234     0.150
    11.177   351.523     0.150
    12.540   180.898     0.150
    14.082   202.258     0.150
    15.912   224.625     0.150
    16.337   231.609     0.150
    16.686   236.305     0.150
    16.872   235.234     0.150
    16.953   238.438     0.150
    17.078   241.227     0.150
    19.775   271.320     0.150
    20.105   269.836     0.150
    20.515   278.219     0.150
    20.744   278.727     0.150
    20.738   281.664     0.150
    20.835   281.414     0.150
    20.922   280.711     0.150
    20.961   282.648     0.150
    21.061   282.500     0.150
    21.173   281.594     0.150
    21.146   285.328     0.150
    21.733   290.195     0.150
    21.747   291.844     0.150
    21.941   293.336     0.150
    21.945   292.938     0.150
    21.993   292.859     0.150
    22.172   291.719     0.150
    22.227   298.117     0.150
    22.247   297.125     0.150
    22.255   296.750     0.150
    22.289   298.664     0.150
    22.390   298.367     0.150
    22.923   300.234     0.150
    23.090   302.914     0.150
    23.147   305.484     0.150
    23.408   307.859     0.150
    23.611   309.820     0.150
    23.673   309.961     0.150
    23.673   534.328     0.150
    23.713   312.156     0.150
    23.807   310.508     0.150
    24.140   312.039     0.150
    24.340   536.664     0.150
    24.411   318.688     0.150
    24.411   536.914     0.150
    24.566   315.961     0.150
    24.606   318.438     0.150
    24.882   321.641     0.150
    25.006   322.977     0.150
    25.006   537.391     0.150
    25.107   323.047     0.150
    25.241   322.867     0.150
    25.241   323.891     0.150
    25.241   537.586     0.150
    25.340   323.031     0.150
    25.577   327.164     0.150
    25.557   328.578     0.150
    25.932   332.688     0.150
    25.999   331.656     0.150
    26.085   331.734     0.150
    26.236   333.695     0.150
    26.236   540.500     0.150
    26.287   333.719     0.150
    26.287   540.805     0.150
    26.535   337.641     0.150
    26.535   540.695     0.150
    26.706   337.648     0.150
    26.706   541.930     0.150
    26.719   339.125     0.150
    26.719   540.219     0.150
    26.756   339.461     0.150
    27.210   339.836     0.150
    27.227   342.109     0.150
    27.354   343.578     0.150
    27.610   346.438     0.150
    27.785   347.891     0.150
    27.785   544.078     0.150
    28.085   351.031     0.150
    28.138   352.578     0.150
    28.382   352.570     0.150
    28.382   545.836     0.150
    28.665   355.180     0.150
    28.782   356.438     0.150
    28.782   547.234     0.150
    29.041   359.695     0.150
    29.112   358.227     0.150
    29.485   362.000     0.150
    29.999   366.398     0.150
    29.999    12.547     0.150
    30.641   372.906     0.150
    31.078   374.039     0.150
    31.078    13.211     0.150
    31.163   378.195     0.150
    31.243   379.461     0.150
    31.379   378.914     0.150
    31.548   381.195     0.150
    31.601   382.375     0.150
    32.046   386.555     0.150
    32.269   386.914     0.150
    32.269    12.555     0.150
    32.283   386.484     0.150
    32.479   386.562     0.150
    32.479    13.000     0.150
    32.479   554.812     0.150
    32.442   389.688     0.150
    32.621   390.586     0.150
    33.011   390.859     0.150
    32.985   394.086     0.150
    33.909   400.961     0.150
    34.331   404.688     0.150
    34.388   406.359     0.150
    34.388    12.500     0.150
    36.512   421.836     0.150
    39.285   448.453     0.150
    42.045   471.227     0.150
    42.045    13.539     0.150
    42.045   583.781     0.150
    45.086   492.508     0.150
    45.086    12.750     0.150
    45.086   593.984     0.150
    45.667   496.812     0.150
    45.667    12.023     0.150
    48.204   519.898     0.150
    48.204    12.852     0.150
    52.606   553.148     0.150
    53.326   558.641     0.150
    54.213   563.930     0.150
    54.213    12.859     0.150
    55.146   570.289     0.150
    55.146    13.312     0.150
    55.190   571.125     0.150
    55.190    13.789     0.150
    55.290   571.641     0.150
    55.290    13.125     0.150
    55.542   573.141     0.150
    56.739   581.336     0.150
    57.680   588.055     0.150
    57.680    13.484     0.150
    58.238   592.070     0.150
    58.238    12.727     0.150
    62.150   619.641     0.150
    62.363   620.531     0.150
    63.398   628.375     0.150
    63.414   627.938     0.150
    65.721   643.523     0.150
    65.721     9.250     0.150
    65.721    13.547     0.150
    66.130   644.695     0.150
    71.076   674.938     0.150
    77.182   711.078     0.150
    78.454   717.695     0.150
    78.835   719.234     0.150
    79.214   722.641     0.150
    80.325   727.961     0.150
    80.656   729.938     0.150
    80.640   731.438     0.150
    80.768   732.016     0.150
    80.870   732.398     0.150
    80.824   732.938     0.150
    81.470   735.977     0.150
    81.905   738.297     0.150
    81.905     7.539     0.150
    82.643   742.039     0.150
    82.643  1360.336     0.150
    82.643  1686.438     0.150
    83.369   746.156     0.150
    83.636   747.398     0.150
    83.913   746.438     0.150
    84.165   748.234     0.150
    84.549   750.234     0.150
    84.690   752.219     0.150
    84.880   753.359     0.150
    84.962   754.898     0.150
    85.038   754.539     0.150
    85.038     9.500     0.150
    85.038   754.711     0.150
    85.038     8.859     0.150
    85.084   755.359     0.150
    85.084     9.641     0.150
    85.172   754.680     0.150
    85.172  1390.766     0.150
    85.211   754.039     0.150
    85.211   754.789     0.150
    85.211     8.625     0.150
    85.218   754.234     0.150
    85.256   754.039     0.150
    85.568   758.297     0.150
    85.734   758.539     0.150
    85.734     9.375     0.150
    86.022   759.938     0.150
    86.022     9.133     0.150
    86.039   760.078     0.150
    86.132   760.836     0.150
    86.132     8.000     0.150
    86.327   759.141     0.150
    86.446   759.438     0.150
    86.457   762.016     0.150
    86.457    10.078     0.150
    86.597   760.234     0.150
    86.675   763.539     0.150
    86.883   761.539     0.150
    86.892   761.836     0.150
    86.940   762.039     0.150
    87.182   762.836     0.150
    87.187   765.461     0.150
    87.394   763.938     0.150
    87.408   764.336     0.150
    87.530   764.836     0.150
    87.774   765.539     0.150
    88.042   767.438     0.150
    88.744   770.836     0.150
    88.725   770.234     0.150
    88.836   771.438     0.150
    89.121   772.141     0.150
    89.795   775.641     0.150
    89.924   780.195     0.150
    90.068   777.234     0.150
    90.449   778.938     0.150
    90.438   777.234     0.150
    90.809   781.938     0.150
    90.809     9.000     0.150
    90.809   780.234     0.150
    90.809     9.031     0.150
    90.976   781.336     0.150
    91.709   785.336     0.150
    92.420   789.938     0.150
    92.639   790.062     0.150
    92.639     9.602     0.150
    92.639    14.031     0.150
    94.154   796.891     0.150
    94.892   800.734     0.150
    94.892     9.000     0.150
    95.509   803.539     0.150
    97.385   810.938     0.150
    97.385   819.836     0.150
    98.450   814.438     0.150
    98.450     8.703     0.150
    99.210   817.336     0.150
    99.210  1499.734     0.150
   100.944   830.008     0.150
   103.086   837.875     0.150
   107.931  1126.141     0.150
   117.421  1123.742     0.150
   117.624  1122.438     0.150
   117.624  1198.938     0.150
   119.026  1127.039     0.150
   120.035  1128.734     0.150
   120.533  1129.938     0.150
   120.533  1138.938     0.150
   120.978  1131.188     0.150
   125.030  1138.734     0.150
   127.199  1142.539     0.150
   127.199  1152.688     0.150
   129.694  1146.539     0.150
   130.410  1150.141     0.150
   130.615  1150.234     0.150
   131.350  1151.320     0.150
   131.350  1162.164     0.150
   132.519  1153.414     0.150
   132.542  1153.281     0.150
   132.847  1153.656     0.150
   133.174  1154.781     0.150
   133.523  1154.734     0.150
   134.318  1156.438     0.150
   134.318  1366.438     0.150
   134.251  1157.938     0.150
   137.905  1163.891     0.150
   137.905  1173.734     0.150
   137.905  1333.039     0.150
   143.388  1168.938     0.150
   144.641  1173.539     0.150
     1.359    23.158     0.150
     1.359    41.939     0.150
     1.468    44.020     0.150
     2.365    39.350     0.150
     2.365    70.479     0.150
     2.476    40.949     0.150
     2.462    39.789     0.150
     2.462    70.789     0.150
     2.731    43.029     0.150
     2.731    75.430     0.150
     3.160    48.850     0.150
     3.296    50.779     0.150
     3.296    90.818     0.150
     3.392    54.090     0.150
     3.392    93.789     0.150
     3.490    54.359     0.150
     3.490   100.619     0.150
     3.623    58.979     0.150
     3.623   112.238     0.150
     3.703    58.299     0.150
     3.759   118.828     0.150
     3.805    61.988     0.150
     3.817    61.100     0.150
     3.911    62.789     0.150
     3.911   104.789     0.150
     3.904   119.430     0.150
     3.957   121.959     0.150
     4.179    66.959     0.150
     4.179   131.979     0.150
     4.230    65.189     0.150
     4.230   131.879     0.150
     4.230   132.719     0.150
     4.298    64.869     0.150
     4.298   134.170     0.150
     4.468    69.609     0.150
     4.621    73.289     0.150
     5.373    81.510     0.150
     6.009    89.289     0.150
    11.289   164.670     0.150
    11.289   163.988     0.150
    11.289   349.902     0.150
    12.737   184.529     0.150
    14.184   203.670     0.150
    15.895   224.750     0.150
    16.405   230.809     0.150
    16.485   231.068     0.150
    16.746   236.049     0.150
    17.152   241.328     0.150
    18.466   253.539     0.150
    18.921   258.988     0.150
    18.972   263.699     0.150
    19.697   270.824     0.150
    20.393   274.279     0.150
    20.584   280.619     0.150
    20.976   282.238     0.150
    21.466   285.229     0.150
    21.471   285.309     0.150
    21.743   293.139     0.150
    21.833   291.309     0.150
    21.957   294.199     0.150
    22.031   293.959     0.150
    22.164   296.619     0.150
    22.205   297.059     0.150
    23.243   303.889     0.150
    23.304   308.809     0.150
    23.653   312.479     0.150
    23.692   312.090     0.150
    23.841   312.779     0.150
    24.363   318.988     0.150
    24.448   314.514     0.150
    24.535   317.299     0.150
    24.850   319.250     0.150
    25.005   324.488     0.150
    25.306   325.289     0.150
    25.306   537.289     0.150
    25.472   328.850     0.150
    25.750   331.709     0.150
    26.141   333.510     0.150
    26.298   335.059     0.150
    26.482   337.709     0.150
    26.653   339.670     0.150
    26.766   339.090     0.150
    27.252   343.619     0.150
    27.521   343.309     0.150
    27.767   348.809     0.150
    27.992   351.148     0.150
    28.439   354.320     0.150
    28.722   357.000     0.150
    28.834   357.891     0.150
    29.545   363.578     0.150
    30.049   368.000     0.150
    30.293   371.750     0.150
    31.142   379.680     0.150
    31.199   380.309     0.150
    31.289   376.641     0.150
    31.350   380.570     0.150
    32.032   387.949     0.150
    32.218   388.898     0.150
    32.269   389.438     0.150
    32.610   391.320     0.150
    32.657   388.266     0.150
    32.719   392.770     0.150
    33.291   393.039     0.150
    33.646   400.340     0.150
    33.646     8.910     0.150
    33.849   401.910     0.150
    33.910   402.480     0.150
    34.364   407.988     0.150
    34.369   407.320     0.150
    34.589   408.961     0.150
    42.023   471.328     0.150
    45.176   493.891     0.150
    45.176   595.391     0.150
    45.936   499.590     0.150
    48.346   521.785     0.150
    53.319   558.988     0.150
    53.807   562.488     0.150
    53.848   561.391     0.150
    54.197   564.930     0.150
    55.154   571.539     0.150
    55.154   632.188     0.150
    55.161   572.219     0.150
    55.201   572.070     0.150
    55.201     9.277     0.150
    55.549   574.488     0.150
    56.709   582.188     0.150
    57.662   588.391     0.150
    62.501   622.324     0.150
    63.616   629.504     0.150
    65.743   644.762     0.150
    73.675   692.988     0.150
    73.675     8.801     0.150
    73.675  1258.688     0.150
    79.070   721.590     0.150
    79.134   721.988     0.150
    79.514   724.090     0.150
    83.963   748.527     0.150
    83.963     9.000     0.150
    84.475   752.488     0.150
    84.575   753.090     0.150
    84.859   754.391     0.150
    85.368   756.891     0.150
    85.435   756.266     0.150
    85.473   756.391     0.150
    85.473   756.477     0.150
    86.649   762.789     0.150
    86.899   763.590     0.150
    87.197   764.688     0.150
    87.214   766.188     0.150
    87.494   765.891     0.150
    87.705   766.891     0.150
    87.719   766.590     0.150
    87.840   767.891     0.150
    88.362   771.590     0.150
    88.936   771.590     0.150
    89.050   773.289     0.150
    89.425   776.188     0.150
    89.438   774.988     0.150
    89.502   776.488     0.150
    91.052   782.266     0.150
    91.106   784.090     0.150
    92.541   789.789     0.150
    92.935   791.957     0.150
    94.284   798.391     0.150
   126.855  1143.641     0.150
   137.852  1164.090     0.150
   144.762  1174.789     0.150
     1.198    21.906     0.150
     1.198    37.555     0.150
     2.139    37.422     0.150
     2.139    64.133     0.150
     2.767    46.648     0.150
     2.767    82.062     0.150
     2.965    50.953     0.150
     2.965    86.734     0.150
     3.016    52.562     0.150
     4.037    64.797     0.150
     4.037   113.078     0.150
     4.321    68.516     0.150
     4.321   119.336     0.150
     4.338    69.734     0.150
     4.338   119.945     0.150
     4.438   123.422     0.150
     4.467    69.922     0.150
     4.467   120.734     0.150
     4.588    72.867     0.150
     4.588   126.438     0.150
     4.702    75.234     0.150
     4.744    75.906     0.150
     4.744   131.406     0.150
     4.782    75.938     0.150
     4.778    76.375     0.150
     4.778   132.188     0.150
     4.781    74.438     0.150
     4.781   132.258     0.150
     4.844    76.742     0.150
     4.844   133.898     0.150
     4.881    75.273     0.150
     4.881   136.359     0.150
     4.935    79.047     0.150
     4.935   137.133     0.150
     5.169    80.328     0.150
     5.169   141.906     0.150
     5.243    80.047     0.150
     5.243   141.609     0.150
     5.271    82.922     0.150
     5.271    83.266     0.150
     5.271   143.734     0.150
     5.271   146.258     0.150
     5.532    88.039     0.150
     5.675    96.766     0.150
     6.448    96.758     0.150
     6.448   172.344     0.150
     7.259   109.133     0.150
     7.259   191.422     0.150
    10.672   157.727     0.150
    10.672   159.016     0.150
    11.720   172.328     0.150
    12.453   182.859     0.150
    13.520   196.109     0.150
    13.592   195.859     0.150
    14.871   216.375     0.150
    15.618   226.836     0.150
    15.778   228.664     0.150
    15.935   227.945     0.150
    16.383   235.609     0.150
    18.451   254.297     0.150
    18.534   260.773     0.150
    20.133   275.484     0.150
    20.269   277.875     0.150
    20.484   278.688     0.150
    21.007   286.062     0.150
    21.010   286.273     0.150
    20.976   286.656     0.150
    21.139   286.406     0.150
    21.145   286.508     0.150
    21.116   287.758     0.150
    21.170   288.422     0.150
    21.197   289.016     0.150
    22.115   299.156     0.150
    22.269   299.734     0.150
    22.480   302.188     0.150
    22.555   301.883     0.150
    22.751   304.633     0.150
    23.192   309.477     0.150
    23.258   310.492     0.150
    23.763   313.703     0.150
    23.965   316.523     0.150
    24.009   316.766     0.150
    24.292   320.523     0.150
    24.496   320.719     0.150
    24.463   321.133     0.150
    24.635   324.258     0.150
    24.764   321.156     0.150
    24.716   323.766     0.150
    25.299   327.875     0.150
    25.421   328.289     0.150
    25.366   330.227     0.150
    25.460   328.984     0.150
    25.510   331.148     0.150
    26.319   337.516     0.150
    26.725   341.688     0.150
    26.900   344.297     0.150
    26.970   344.117     0.150
    27.114   345.336     0.150
    27.601   348.289     0.150
    27.805   352.133     0.150
    27.816   352.859     0.150
    27.880   351.523     0.150
    27.977   351.367     0.150
    27.938   351.414     0.150
    28.713   358.609     0.150
    31.021   376.789     0.150
    32.243   387.344     0.150
    33.402   398.297     0.150
    44.426   490.719     0.150
    44.426   595.516     0.150
    45.964   502.875     0.150
    45.964   823.219     0.150
    49.616   535.445     0.150
    52.296   554.367     0.150
    53.153   559.469     0.150
    54.168   566.516     0.150
    54.276   567.539     0.150
    54.559   569.164     0.150
    56.611   584.016     0.150
    57.247   587.977     0.150
    63.765   635.117     0.150
    64.930   643.469     0.150
    66.812   656.250     0.150
    70.976   678.062     0.150
    79.344   726.766     0.150
    79.736   726.766     0.150
    83.080   745.867     0.150
    84.776   755.664     0.150
    84.866   756.164     0.150
    85.170   756.867     0.150
    85.445   758.969     0.150
    85.445   758.969     0.150
    85.865   762.367     0.150
    85.904   761.062     0.150
    87.061   767.766     0.150
    87.127   767.562     0.150
    87.483   768.969     0.150
    87.523   768.867     0.150
    87.617   769.062     0.150
    87.811   769.367     0.150
    88.007   770.367     0.150
    88.028   769.664     0.150
    88.136   770.766     0.150
    89.070   776.789     0.150
    89.675   777.562     0.150
    89.703   777.969     0.150
    90.919   784.570     0.150
    91.302   787.266     0.150
    93.129   795.969     0.150
    96.489   810.375     0.150
   118.709  1130.516     0.150
   119.864  1132.969     0.150
   125.906  1144.164     0.150
   132.903  1158.953     0.150
   136.715  1164.945     0.150
     1.148    20.270     0.150
     1.148    35.250     0.150
     2.045    35.711     0.150
     2.111    35.551     0.150
     2.419    39.840     0.150
     2.419    68.031     0.150
     2.468    39.840     0.150
     2.468    67.660     0.150
     2.746    43.328     0.150
     2.746    74.191     0.150
     2.849    44.328     0.150
     2.849    76.469     0.150
     2.946    48.129     0.150
     2.946    82.750     0.150
     3.064    48.750     0.150
     3.064    84.719     0.150
     3.176    50.320     0.150
     3.288    52.949     0.150
     3.288    90.762     0.150
     3.432    55.820     0.150
     3.432    94.711     0.150
     3.469    53.840     0.150
     3.469    55.660     0.150
     3.469    55.840     0.150
     3.469    95.840     0.150
     3.487    54.520     0.150
     3.487    97.180     0.150
     3.568    57.852     0.150
     3.568    99.828     0.150
     3.582    55.750     0.150
     3.627    57.852     0.150
     3.627    98.828     0.150
     3.840    60.828     0.150
     3.840   106.621     0.150
     3.886    60.852     0.150
     3.886    61.180     0.150
     3.886    61.512     0.150
     3.886   105.078     0.150
     3.965    61.180     0.150
     4.122    62.352     0.150
     4.562    69.270     0.150
     4.562   120.961     0.150
     4.701    71.488     0.150
     4.701   129.660     0.150
     5.026    74.559     0.150
     5.661    85.930     0.150
     5.661   150.691     0.150
     5.668    86.660     0.150
     6.069    91.512     0.150
     6.069   163.219     0.150
     6.595    97.668     0.150
     6.595   170.668     0.150
     7.761   114.961     0.150
     7.761   203.859     0.150
     9.584   140.840     0.150
    10.135   147.352     0.150
    10.135   260.852     0.150
    10.379   152.211     0.150
    11.282   163.715     0.150
    11.282   356.715     0.150
    11.825   173.641     0.150
    12.065   177.918     0.150
    12.236   180.031     0.150
    12.635   180.668     0.150
    13.354   188.109     0.150
    13.692   191.648     0.150
    15.866   227.090     0.150
    15.887   228.371     0.150
    15.928   226.531     0.150
    16.017   226.211     0.150
    16.030   227.879     0.150
    16.040   231.418     0.150
    16.093   229.898     0.150
    16.120   231.121     0.150
    16.120   230.289     0.150
    16.279   231.121     0.150
    16.289   233.781     0.150
    16.317   232.840     0.150
    16.457   232.852     0.150
    16.694   236.969     0.150
    16.747   238.129     0.150
    16.801   238.629     0.150
    16.820   239.480     0.150
    16.835   239.059     0.150
    16.845   239.969     0.150
    16.868   240.488     0.150
    16.943   240.828     0.150
    16.968   234.859     0.150
    17.071   241.738     0.150
    17.184   243.602     0.150
    17.606   248.570     0.150
    18.215   256.059     0.150
    18.292   250.250     0.150
    18.785   257.238     0.150
    18.796   262.211     0.150
    18.912   263.559     0.150
    19.074   263.512     0.150
    19.288   267.859     0.150
    19.416   270.590     0.150
    19.439   271.711     0.150
    19.659   268.328     0.150
    19.686   272.762     0.150
    19.686   493.859     0.150
    19.720   271.570     0.150
    19.875   272.691     0.150
    19.818   273.551     0.150
    19.819   273.691     0.150
    20.117   276.680     0.150
    20.285   274.418     0.150
    20.391   274.102     0.150
    20.476   280.340     0.150
    20.539   276.750     0.150
    20.696   278.488     0.150
    20.841   282.941     0.150
    20.842   279.801     0.150
    21.032   281.770     0.150
    21.244   286.590     0.150
    21.241   283.039     0.150
    21.246   283.141     0.150
    21.253   285.121     0.150
    21.275   289.512     0.150
    21.459   290.191     0.150
    21.574   293.398     0.150
    21.624   287.512     0.150
    21.776   295.168     0.150
    21.852   293.809     0.150
    21.852   290.340     0.150
    21.888   290.199     0.150
    22.047   294.750     0.150
    22.051   295.031     0.150
    22.099   295.070     0.150
    22.188   298.430     0.150
    22.242   292.961     0.150
    22.353   298.949     0.150
    22.350   298.648     0.150
    22.492   299.852     0.150
    22.506   300.168     0.150
    22.614   295.730     0.150
    22.832   300.059     0.150
    22.976   299.980     0.150
    23.170   303.891     0.150
    23.253   306.809     0.150
    23.493   310.301     0.150
    23.515   309.410     0.150
    23.714   311.988     0.150
    23.815   313.820     0.150
    23.983   314.270     0.150
    23.982   316.191     0.150
    24.126   315.059     0.150
    24.126   574.871     0.150
    24.443   319.730     0.150
    24.497   319.750     0.150
    24.514   320.266     0.150
    24.514   538.090     0.150
    24.638   317.500     0.150
    24.854   319.551     0.150
    24.861   319.379     0.150
    24.981   323.031     0.150
    24.971   319.699     0.150
    24.973   318.480     0.150
    25.111   324.871     0.150
    25.103   322.781     0.150
    25.347   325.430     0.150
    25.391   323.668     0.150
    25.636   329.918     0.150
    25.657   330.449     0.150
    25.684   327.840     0.150
    26.007   334.141     0.150
    26.026   331.648     0.150
    26.106   333.070     0.150
    26.394   335.500     0.150
    26.820   341.012     0.150
    26.856   341.328     0.150
    26.910   337.512     0.150
    27.244   344.141     0.150
    27.222   345.602     0.150
    27.268   340.840     0.150
    27.334   343.898     0.150
    27.446   346.711     0.150
    27.460   344.859     0.150
    27.717   347.941     0.150
    27.890   349.379     0.150
    27.839   346.070     0.150
    28.055   350.891     0.150
    28.189   352.809     0.150
    28.210   354.059     0.150
    28.238   354.531     0.150
    28.488   354.219     0.150
    28.772   356.988     0.150
    28.889   357.738     0.150
    29.123   361.250     0.150
    29.230   362.391     0.150
    29.252   362.691     0.150
    29.426   363.480     0.150
    29.591   363.738     0.150
    29.560   366.641     0.150
    30.065   368.281     0.150
    30.105   368.199     0.150
    30.416   371.871     0.150
    30.631   374.102     0.150
    30.745   374.859     0.150
    30.910   381.840     0.150
    30.910   690.840     0.150
    30.954   373.590     0.150
    31.171   375.820     0.150
    31.268   380.031     0.150
    31.304   383.340     0.150
    31.346   381.230     0.150
    31.282   373.039     0.150
    31.424   381.262     0.150
    31.538   382.121     0.150
    31.557   381.250     0.150
    31.631   383.512     0.150
    31.704   384.129     0.150
    31.842   385.000     0.150
    31.969   386.480     0.150
    32.151   388.340     0.150
    32.305   388.859     0.150
    32.329   389.270     0.150
    32.377   389.570     0.150
    32.376   388.211     0.150
    32.390   556.238     0.150
    32.390   387.801     0.150
    32.546   391.418     0.150
    32.568   391.262     0.150
    32.580   391.500     0.150
    32.583   391.441     0.150
    32.576   387.863     0.150
    32.576   555.316     0.150
    32.627   391.320     0.150
    32.755   392.941     0.150
    32.819   393.441     0.150
    32.874   393.648     0.150
    33.049   391.391     0.150
    33.083   391.066     0.150
    33.278   397.168     0.150
    33.349   394.840     0.150
    33.555   400.039     0.150
    33.609   400.648     0.150
    33.592   396.031     0.150
    33.764   400.781     0.150
    33.958   402.211     0.150
    34.097   403.781     0.150
    34.437   406.430     0.150
    34.597   407.988     0.150
    35.161   409.949     0.150
    35.967   417.121     0.150
    36.615   423.238     0.150
    36.646   423.461     0.150
    38.492   442.531     0.150
    38.529   444.500     0.150
    38.788   443.328     0.150
    39.103   445.840     0.150
    39.190   447.969     0.150
    39.212   447.340     0.150
    39.383   447.840     0.150
    39.540   449.488     0.150
    39.648   448.840     0.150
    39.941   453.961     0.150
    40.045   454.148     0.150
    40.101   455.469     0.150
    40.495   456.340     0.150
    45.093   496.289     0.150
    45.192   493.887     0.150
    45.192   595.734     0.150
    45.743   497.789     0.150
    45.965   504.039     0.150
    48.113   519.977     0.150
    48.113   609.324     0.150
    49.959   535.211     0.150
    52.066   550.531     0.150
    53.431   560.340     0.150
    53.900   561.539     0.150
    53.956   563.941     0.150
    53.973   563.840     0.150
    54.016   564.199     0.150
    54.215   565.070     0.150
    54.305   564.160     0.150
    54.318   565.898     0.150
    54.383   566.520     0.150
    55.252   572.652     0.150
    55.294   573.230     0.150
    55.648   574.410     0.150
    56.462   582.141     0.150
    56.843   582.941     0.150
    56.813   582.461     0.150
    57.154   587.840     0.150
    57.222   586.719     0.150
    57.785   589.879     0.150
    58.344   592.949     0.150
    59.103   598.242     0.150
    59.103  1082.367     0.150
    60.276   607.969     0.150
    61.162   613.840     0.150
    61.726   617.238     0.150
    62.255   621.340     0.150
    62.271   620.699     0.150
    62.271  2376.250     0.150
    63.139   626.289     0.150
    63.139   762.652     0.150
    63.139  1133.910     0.150
    63.825   631.426     0.150
    63.825   666.805     0.150
    65.616   644.062     0.150
    65.616  2364.914     0.150
    66.227   646.012     0.150
    66.384   646.238     0.150
    66.530   651.539     0.150
    66.591   650.840     0.150
    66.709   651.039     0.150
    66.753   651.141     0.150
    66.877   651.840     0.150
    66.998   653.641     0.150
    67.004   652.238     0.150
    67.052   652.941     0.150
    67.252    11.797     0.150
    67.609   655.840     0.150
    67.609    11.000     0.150
    67.609  1191.840     0.150
    67.609  1205.840     0.150
    67.609  1207.840     0.150
    67.668   657.141     0.150
    68.692   663.539     0.150
    68.692     8.902     0.150
    69.105   666.148     0.150
    69.383   668.141     0.150
    69.898   671.871     0.150
    70.113   670.969     0.150
    71.169   675.840     0.150
    72.386   684.660     0.150
    72.386   684.938     0.150
    73.783   693.441     0.150
    73.783   707.141     0.150
    73.783  1262.840     0.150
    74.350   697.180     0.150
    76.955   712.012     0.150
    76.955   723.852     0.150
    76.955  1301.629     0.150
    76.955  1603.168     0.150
    76.955   712.191     0.150
    76.924   712.941     0.150
    77.199   713.441     0.150
    77.324   714.441     0.150
    77.422   714.539     0.150
    77.422   714.059     0.150
    77.744   715.648     0.150
    77.981   716.969     0.150
    78.091   718.250     0.150
    78.109   717.680     0.150
    78.243   719.820     0.150
    78.452   719.578     0.150
    78.646   720.891     0.150
    78.651   720.680     0.150
    78.657   720.699     0.150
    78.671   721.039     0.150
    78.691   721.160     0.150
    78.811   721.820     0.150
    78.826   721.602     0.150
    78.900   722.840     0.150
    78.900   722.398     0.150
    78.997   723.281     0.150
    79.024   723.012     0.150
    79.170   723.789     0.150
    79.246   724.211     0.150
    79.267   724.059     0.150
    79.278   724.738     0.150
    79.278   724.219     0.150
    79.300   724.590     0.150
    79.313   724.570     0.150
    79.352   724.738     0.150
    79.381   724.559     0.150
    79.435   725.531     0.150
    79.473   725.730     0.150
    79.568   725.898     0.150
    79.572   725.711     0.150
    79.580   726.461     0.150
    79.687   726.941     0.150
    79.687   726.629     0.150
    79.719   726.719     0.150
    79.738   726.828     0.150
    79.844   727.828     0.150
    79.868   727.602     0.150
    79.874   727.570     0.150
    79.875   727.570     0.150
    79.938   728.441     0.150
    80.074   728.699     0.150
    80.098   729.539     0.150
    80.098   729.219     0.150
    80.113   729.340     0.150
    80.113   729.230     0.150
    80.172   729.539     0.150
    80.267   730.340     0.150
    80.267   729.699     0.150
    80.284   730.340     0.150
    80.284   729.859     0.150
    80.294   730.141     0.150
    80.345   730.102     0.150
    80.358   730.250     0.150
    80.384   730.941     0.150
    80.384   730.320     0.150
    80.396   730.398     0.150
    80.417   731.141     0.150
    80.417   730.570     0.150
    80.418   730.340     0.150
    80.418   730.512     0.150
    80.438   730.680     0.150
    80.507   731.738     0.150
    80.507   730.980     0.150
    80.508   731.000     0.150
    80.510   731.539     0.150
    80.510   731.012     0.150
    80.530   731.539     0.150
    80.530   731.121     0.150
    80.560   731.641     0.150
    80.560   731.270     0.150
    80.584   731.410     0.150
    80.622   731.660     0.150
    80.644   732.141     0.150
    80.644   731.789     0.150
    80.653   731.828     0.150
    80.683   731.941     0.150
    80.678   733.539     0.150
    80.692   732.840     0.150
    80.692   732.668     0.150
    80.690   732.160     0.150
    80.689   733.168     0.150
    80.689   733.371     0.150
    80.716   732.168     0.150
    80.725   732.340     0.150
    80.767   732.680     0.150
    80.800   732.559     0.150
    80.808   732.961     0.150
    80.815   732.578     0.150
    80.840   733.129     0.150
    80.923   733.641     0.150
    80.842   733.352     0.150
    80.865   732.969     0.150
    80.869   732.988     0.150
    80.898   733.418     0.150
    80.916   733.641     0.150
    80.935   733.430     0.150
    80.963   733.578     0.150
    80.973   733.910     0.150
    80.970   733.621     0.150
    80.974   733.641     0.150
    80.977   733.660     0.150
    81.014   733.852     0.150
    81.022   734.340     0.150
    81.022   733.969     0.150
    81.027   733.930     0.150
    81.091   734.020     0.150
    81.114   734.820     0.150
    81.145   734.551     0.150
    81.244   735.738     0.150
    81.244   735.430     0.150
    81.279   735.449     0.150
    81.485   735.840     0.150
    81.518   736.719     0.150
    81.518   736.520     0.150
    81.533   737.039     0.150
    81.533   736.801     0.150
    81.533   736.602     0.150
    81.534   736.840     0.150
    81.534  1348.840     0.150
    81.620   737.262     0.150
    81.637   737.738     0.150
    81.717   737.781     0.150
    81.764   738.641     0.150
    81.831   737.941     0.150
    81.866   739.039     0.150
    81.865   738.039     0.150
    81.896   738.539     0.150
    81.945   739.340     0.150
    81.945   738.980     0.150
    81.951   738.879     0.150
    81.968   739.340     0.150
    81.968   739.109     0.150
    82.186   740.441     0.150
    82.189   741.039     0.150
    82.225   740.840     0.150
    82.243   740.539     0.150
    82.243   740.719     0.150
    82.357   741.941     0.150
    82.377   742.211     0.150
    82.377    10.398     0.150
    82.393   740.840     0.150
    82.410   740.641     0.150
    82.434   742.039     0.150
    82.575   743.340     0.150
    82.617     5.180     0.150
    82.615   743.340     0.150
    82.747   743.008     0.150
    82.747  1359.945     0.150
    82.697   742.738     0.150
    82.724   742.941     0.150
    82.832   744.539     0.150
    82.898   745.328     0.150
    82.929   744.039     0.150
    82.999   746.109     0.150
    83.002   746.211     0.150
    82.998   746.141     0.150
    83.002   745.238     0.150
    83.037   745.078     0.150
    83.057   746.129     0.150
    83.057    10.750     0.150
    83.159   743.840     0.150
    83.204   745.539     0.150
    83.413   746.898     0.150
    83.437   746.250     0.150
    83.437    11.281     0.150
    83.444   746.941     0.150
    83.444     5.340     0.150
    83.675   748.520     0.150
    83.876   748.871     0.150
    83.876    10.918     0.150
    83.919   750.031     0.150
    83.919     5.289     0.150
    84.020   748.340     0.150
    84.223   750.941     0.150
    84.223   751.250     0.150
    84.325   751.441     0.150
    84.416   752.141     0.150
    84.608   752.840     0.150
    84.766   753.941     0.150
    84.905   754.641     0.150
    84.919   755.121     0.150
    85.000   756.340     0.150
    85.032   753.191     0.150
    85.032    12.777     0.150
    85.081   754.840     0.150
    85.081  1844.238     0.150
    85.081   754.590     0.150
    85.133   755.102     0.150
    85.245   755.461     0.150
    85.253   755.441     0.150
    85.290   755.641     0.150
    85.290   755.699     0.150
    85.309   755.191     0.150
    85.309  1843.414     0.150
    85.499   757.340     0.150
    85.552   758.199     0.150
    85.618   757.559     0.150
    85.774   759.480     0.150
    86.006   759.039     0.150
    86.068   760.379     0.150
    86.078   761.102     0.150
    86.172   761.320     0.150
    86.213   760.441     0.150
    86.321   761.602     0.150
    86.377   761.840     0.150
    86.400   762.840     0.150
    86.429   761.941     0.150
    86.500   762.039     0.150
    86.499   762.180     0.150
    86.543   762.238     0.150
    86.543  1380.340     0.150
    86.660   762.441     0.150
    86.717   763.539     0.150
    86.781   763.641     0.150
    86.828   763.441     0.150
    86.871   763.441     0.150
    86.940   763.539     0.150
    86.943   764.039     0.150
    87.003   764.238     0.150
    87.136   766.129     0.150
    87.024   765.039     0.150
    87.239   764.840     0.150
    87.236   766.059     0.150
    87.281   766.699     0.150
    87.287   765.738     0.150
    87.332   765.512     0.150
    87.365   766.000     0.150
    87.453   765.941     0.150
    87.465   765.840     0.150
    87.483   766.441     0.150
    87.571   766.859     0.150
    87.589   766.738     0.150
    87.662   767.340     0.150
    87.709   767.391     0.150
    87.832   767.539     0.150
    87.872   769.238     0.150
    87.871   768.668     0.150
    87.957   769.539     0.150
    87.967   768.340     0.150
    87.978   768.102     0.150
    88.024   769.238     0.150
    88.038   769.340     0.150
    88.077   770.500     0.150
    88.094   769.238     0.150
    88.197   769.738     0.150
    88.263   770.039     0.150
    88.315   770.441     0.150
    88.325   770.738     0.150
    88.465   771.238     0.150
    88.490   770.738     0.150
    88.515   771.441     0.150
    88.587   772.840     0.150
    88.632   770.539     0.150
    88.684   771.590     0.150
    88.817   771.941     0.150
    88.817   977.840     0.150
    88.817  1398.941     0.150
    88.817  1412.941     0.150
    88.839   772.441     0.150
    88.881   773.039     0.150
    88.936   773.738     0.150
    89.045   774.039     0.150
    89.100   774.340     0.150
    89.193   774.039     0.150
    89.200   773.738     0.150
    89.228   774.141     0.150
    89.240   774.441     0.150
    89.251   774.539     0.150
    89.347   774.840     0.150
    89.355   775.441     0.150
    89.383   775.039     0.150
    89.395   775.539     0.150
    89.537   775.961     0.150
    89.609   775.738     0.150
    89.719   776.539     0.150
    89.747   775.930     0.150
    89.846   776.641     0.150
    89.851   777.641     0.150
    89.859   777.441     0.150
    89.865   777.641     0.150
    89.907   777.441     0.150
    89.990   778.141     0.150
    90.022   777.641     0.150
    90.083   778.738     0.150
    90.174   779.590     0.150
    90.133   779.441     0.150
    90.153   779.738     0.150
    90.203   778.539     0.150
    90.202   779.141     0.150
    90.210   779.539     0.150
    90.214   778.738     0.150
    90.222   778.301     0.150
    90.266   779.641     0.150
    90.271   779.039     0.150
    90.303   780.609     0.150
    90.303   780.738     0.150
    90.306   780.039     0.150
    90.306   780.141     0.150
    90.330   779.340     0.150
    90.412   781.379     0.150
    90.417   780.039     0.150
    90.427   779.941     0.150
    90.432   781.430     0.150
    90.439   780.039     0.150
    90.459   780.238     0.150
    90.505   780.840     0.150
    90.528   780.441     0.150
    90.574   781.039     0.150
    90.614   780.738     0.150
    90.623   781.840     0.150
    90.623  1799.840     0.150
    90.633   782.199     0.150
    90.665   781.941     0.150
    90.722   782.941     0.150
    90.741   780.668     0.150
    90.823   782.820     0.150
    90.866   784.371     0.150
    90.874   782.629     0.150
    90.874  1415.121     0.150
    90.874  1507.133     0.150
    90.874   782.039     0.150
    90.874  1419.141     0.150
    90.874  1800.441     0.150
    90.874   782.039     0.150
    90.874  1419.141     0.150
    90.874  1800.441     0.150
    90.893   781.363     0.150
    90.893   995.664     0.150
    90.893  1829.289     0.150
    90.885   782.211     0.150
    90.911   782.738     0.150
    90.938   782.441     0.150
    90.940   782.539     0.150
    90.940   782.840     0.150
    91.011   782.641     0.150
    91.021   783.039     0.150
    91.044   782.441     0.150
    91.044  1414.840     0.150
    91.044  1440.840     0.150
    91.044  1827.941     0.150
    91.072   783.141     0.150
    91.075   784.668     0.150
    91.118   783.539     0.150
    91.128   783.238     0.150
    91.144   783.031     0.150
    91.202   783.340     0.150
    91.236   783.738     0.150
    91.248   784.039     0.150
    91.252   783.738     0.150
    91.258   784.539     0.150
    91.335   785.719     0.150
    91.316   784.141     0.150
    91.327   784.141     0.150
    91.338   784.340     0.150
    91.379   784.738     0.150
    91.379   785.141     0.150
    91.412   784.879     0.150
    91.419   785.340     0.150
    91.419  1827.855     0.150
    91.422   785.441     0.150
    91.497   784.730     0.150
    91.590   785.039     0.150
    91.606   785.648     0.150
    91.657   786.238     0.150
    91.657  1419.840     0.150
    91.657   785.551     0.150
    91.720   785.910     0.150
    91.760   786.840     0.150
    91.777   787.141     0.150
    91.777  1002.840     0.150
    91.777  1416.840     0.150
    91.777  1448.840     0.150
    91.777  1510.840     0.150
    91.777  1811.840     0.150
    91.959   787.039     0.150
    92.082   788.039     0.150
    92.185   788.238     0.150
    92.243   788.641     0.150
    92.314   789.039     0.150
    92.455   789.941     0.150
    92.467   790.840     0.150
    92.467  1524.840     0.150
    92.486   789.840     0.150
    92.486     9.500     0.150
    92.486  1422.840     0.150
    92.570   790.238     0.150
    92.570     9.902     0.150
    92.570  1010.840     0.150
    92.570  1422.340     0.150
    92.570  1454.738     0.150
    92.570  1525.340     0.150
    92.570  1820.539     0.150
    92.570  1826.539     0.150
    92.570  2312.238     0.150
    92.734   790.840     0.150
    92.734    11.000     0.150
    92.734  1010.840     0.150
    92.734  1422.840     0.150
    92.734  1452.840     0.150
    92.734  1527.840     0.150
    92.734  1830.840     0.150
    92.704   790.941     0.150
    92.704   791.363     0.150
    92.704  1012.141     0.150
    92.704  1826.488     0.150
    92.925   791.520     0.150
    93.049   791.941     0.150
    93.049    10.098     0.150
    93.049  1425.141     0.150
    93.049  1530.340     0.150
    93.049  1827.840     0.150
    93.245   792.199     0.150
    93.328   794.379     0.150
    93.337   794.141     0.150
    93.337  1468.539     0.150
    93.337  1530.738     0.150
    93.361   793.840     0.150
    93.363   792.949     0.150
    93.414   793.539     0.150
    93.546   794.340     0.150
    93.566   793.840     0.150
    93.566  1018.840     0.150
    93.566  1426.840     0.150
    93.566  1456.840     0.150
    93.566  1538.840     0.150
    93.766   795.641     0.150
    93.971   795.711     0.150
    94.044   797.039     0.150
    94.059   796.340     0.150
    94.053   797.840     0.150
    94.109   797.840     0.150
    94.251   798.289     0.150
    94.280   797.840     0.150
    94.280     9.301     0.150
    94.310   798.270     0.150
    94.370   799.340     0.150
    94.417   798.141     0.150
    94.482   799.441     0.150
    94.482   799.840     0.150
    94.482     9.598     0.150
    94.482  1026.340     0.150
    94.482  1431.840     0.150
    94.482  1467.539     0.150
    94.482  1542.238     0.150
    94.482  1848.941     0.150
    94.483   798.238     0.150
    94.568   798.039     0.150
    94.568     8.402     0.150
    94.568  1433.039     0.150
    94.568  1467.738     0.150
    94.586   798.738     0.150
    94.597   799.641     0.150
    94.597  1433.738     0.150
    94.597  1551.840     0.150
    94.647   798.039     0.150
    94.647     7.699     0.150
    94.647  1434.539     0.150
    94.647  1468.340     0.150
    94.650   799.738     0.150
    94.650     9.703     0.150
    94.958   801.340     0.150
    94.958     9.301     0.150
    94.999   801.531     0.150
    95.037   801.320     0.150
    95.122   801.840     0.150
    95.242   802.738     0.150
    95.242  1439.539     0.150
    95.250   802.109     0.150
    95.396   803.121     0.150
    95.446   803.238     0.150
    95.572   804.738     0.150
    95.581   802.418     0.150
    95.626   804.641     0.150
    95.913   805.719     0.150
    96.047   806.441     0.150
    96.428   808.840     0.150
    96.464   807.980     0.150
    97.093   810.340     0.150
    97.093  1046.641     0.150
    97.093  1450.941     0.150
    97.093  1490.539     0.150
    97.093   810.762     0.150
    97.344   810.418     0.150
    97.539   811.641     0.150
    97.539  1498.840     0.150
    97.503   813.340     0.150
    97.572   815.941     0.150
    97.695   814.969     0.150
    98.027   815.340     0.150
    98.410   816.840     0.150
    98.557   816.340     0.150
    98.557  1451.340     0.150
    99.180   818.738     0.150
    99.180  1061.840     0.150
    99.180  1454.141     0.150
    99.180  1503.641     0.150
    99.180  1591.941     0.150
    99.176   820.789     0.150
    99.294   819.141     0.150
    99.294  1911.941     0.150
    99.582   822.941     0.150
    99.616   823.340     0.150
   100.061   824.941     0.150
   100.425   824.699     0.150
   100.793   826.039     0.150
   100.793  1464.039     0.150
   101.037   829.066     0.150
   101.037  1467.082     0.150
   101.037  1525.840     0.150
   101.036   830.551     0.150
   101.036  1077.953     0.150
   101.059   828.840     0.150
   101.252   828.840     0.150
   101.252  1076.840     0.150
   101.252  1620.840     0.150
   101.179   831.441     0.150
   101.279   830.840     0.150
   101.422   830.840     0.150
   101.422   830.141     0.150
   101.609   831.441     0.150
   101.609   840.141     0.150
   101.609  1081.039     0.150
   101.609  1469.441     0.150
   101.609  1526.441     0.150
   101.590   830.840     0.150
   101.900   831.840     0.150
   101.900  1467.840     0.150
   101.900  1532.840     0.150
   102.787   835.840     0.150
   103.191   838.398     0.150
   103.136   837.840     0.150
   104.099  1481.840     0.150
   104.099  1650.840     0.150
   104.135   841.840     0.150
   104.135  1480.840     0.150
   105.956   849.941     0.150
   105.956  1489.840     0.150
   105.956  2012.840     0.150
   106.210   850.840     0.150
   106.738   854.840     0.150
   106.738  1117.840     0.150
   107.198  1106.039     0.150
   107.198  1783.789     0.150
   107.198  1796.941     0.150
   107.241   854.840     0.150
   107.592   861.738     0.150
   107.626   857.840     0.150
   107.626  1124.840     0.150
   107.626  1494.840     0.150
   107.626  1683.840     0.150
   107.626  2043.840     0.150
   107.875  1778.039     0.150
   107.875  1779.641     0.150
   107.875  1788.141     0.150
   107.875   860.941     0.150
   107.875   871.141     0.150
   107.934   861.840     0.150
   108.036   861.016     0.150
   108.036  1106.840     0.150
   108.036  1778.191     0.150
   108.036  1791.891     0.150
   108.309  1778.441     0.150
   108.309  1781.539     0.150
   108.309  1788.340     0.150
   108.309   863.641     0.150
   108.309   873.941     0.150
   108.605  1775.539     0.150
   108.605  1776.441     0.150
   108.605  1786.238     0.150
   108.605   864.340     0.150
   108.698   862.840     0.150
   108.698  1138.840     0.150
   108.698  1532.840     0.150
   109.224   865.590     0.150
   109.500  1109.012     0.150
   109.605   867.840     0.150
   109.850   870.840     0.150
   109.850  1710.840     0.150
   110.059   869.840     0.150
   110.059  1106.840     0.150
   110.595   870.039     0.150
   110.595  1716.641     0.150
   110.686   871.840     0.150
   110.686  1150.840     0.150
   110.686  1506.840     0.150
   110.686  1716.840     0.150
   111.860   875.840     0.150
   111.860  2082.840     0.150
   111.880   878.586     0.150
   111.880  1158.215     0.150
   113.376   884.840     0.150
   113.376  1166.840     0.150
   114.262  1118.238     0.150
   115.341  1121.262     0.150
   115.497   894.840     0.150
   115.497  1184.840     0.150
   115.543  1121.840     0.150
   115.543  1183.840     0.150
   116.304   896.840     0.150
   116.304  1119.840     0.150
   117.003  1198.840     0.150
   117.421  1123.762     0.150
   117.730  1124.340     0.150
   117.730  1339.840     0.150
   117.730  1551.840     0.150
   118.989  1129.340     0.150
   119.132  1127.840     0.150
   119.373  1127.840     0.150
   119.373  1209.840     0.150
   119.564  1128.449     0.150
   120.031   914.840     0.150
   120.031  1129.840     0.150
   120.031  1624.840     0.150
   120.031  2199.840     0.150
   120.139  1129.840     0.150
   120.139  1552.840     0.150
   120.139  1621.840     0.150
   120.638  1130.340     0.150
   120.958  1131.539     0.150
   120.958  1221.840     0.150
   120.958  1732.941     0.150
   120.958  1815.840     0.150
   121.402  1221.840     0.150
   121.489  1133.840     0.150
   122.726  1133.840     0.150
   122.726  1235.840     0.150
   122.726  1348.840     0.150
   122.726  1560.840     0.150
   122.726  1643.840     0.150
   123.340  1136.840     0.150
   123.705  1137.039     0.150
   125.108  1139.340     0.150
   125.134  1139.840     0.150
   125.134  1249.840     0.150
   125.134  2259.840     0.150
   126.118  1144.840     0.150
   126.118  1254.840     0.150
   126.354  1141.859     0.150
   126.416  1139.840     0.150
   126.839  1143.738     0.150
   126.839  1255.738     0.150
   127.146  1143.039     0.150
   127.198  1144.238     0.150
   127.201  1143.840     0.150
   127.201  1934.941     0.150
   127.428  1142.840     0.150
   127.428  1264.840     0.150
   127.383  1145.398     0.150
   129.589  1146.941     0.150
   129.589  1932.941     0.150
   129.784  1146.840     0.150
   130.365  1349.840     0.150
   130.513  1149.840     0.150
   130.513  1284.840     0.150
   130.513  1696.840     0.150
   130.513  2329.840     0.150
   130.722  1152.641     0.150
   130.815  1355.840     0.150
   130.988  1153.102     0.150
   131.299  1148.840     0.150
   131.284  1151.312     0.150
   131.284  1289.762     0.150
   131.530  1144.441     0.150
   131.530  1147.891     0.150
   131.911  1152.840     0.150
   131.911  1357.840     0.150
   132.624  1154.102     0.150
   132.646  1154.340     0.150
   132.706  1155.840     0.150
   132.706  1365.141     0.150
   132.951  1153.941     0.150
   133.279  1155.102     0.150
   133.313  1156.691     0.150
   133.474  1156.699     0.150
   133.548  1302.840     0.150
   133.548  1365.340     0.150
   133.548  1718.840     0.150
   133.628  1154.961     0.150
   133.696  1155.578     0.150
   133.780  1155.539     0.150
   133.806  1156.578     0.150
   134.000  1156.621     0.150
   134.011  1156.762     0.150
   134.266  1158.141     0.150
   134.266  1308.738     0.150
   134.266  1366.340     0.150
   134.327  1156.961     0.150
   134.396  1157.641     0.150
   134.425  1156.840     0.150
   134.425  1312.340     0.150
   134.425  1367.340     0.150
   136.197  1163.840     0.150
   136.671  1158.340     0.150
   136.698  1160.840     0.150
   137.705  1162.789     0.150
   138.008  1164.289     0.150
   138.008  1165.391     0.150
   138.008  1331.988     0.150
   138.279  1164.680     0.150
   138.279  1174.512     0.150
   138.968  1163.531     0.150
   138.968  1171.871     0.150
   138.968  1380.168     0.150
   139.809  1164.840     0.150
   141.234  1162.441     0.150
   142.421  1166.340     0.150
   143.081  1167.840     0.150
   143.013  1171.289     0.150
   143.013  1176.930     0.150
   143.487  1170.840     0.150
   143.759  1170.840     0.150
   144.727  1173.340     0.150
   144.745  1173.840     0.150
   144.745  1178.840     0.150
   144.745  1184.840     0.150
   144.745  1374.840     0.150
   144.745  1782.840     0.150
   145.049  1174.840     0.150
   148.960  1182.840     0.150
   148.960  1399.840     0.150
   149.513  1183.141     0.150
   150.348  1185.340     0.150
   150.842  1185.941     0.150
   150.908  1185.238     0.150
   153.614  1197.910     0.150
     1.094    18.488     0.150
     1.094    34.027     0.150
     1.975    34.238     0.150
     1.975    61.047     0.150
     2.366    36.848     0.150
     2.366    63.238     0.150
     2.451    39.547     0.150
     2.451    70.637     0.150
     2.795    42.367     0.150
     2.795    73.488     0.150
     2.791    44.457     0.150
     2.791    76.066     0.150
     2.870    45.289     0.150
     2.870    79.148     0.150
     2.985    47.590     0.150
     2.985    83.758     0.150
     3.098    49.609     0.150
     3.098    85.508     0.150
     3.209    49.887     0.150
     3.209    89.816     0.150
     3.354    52.250     0.150
     3.354    93.469     0.150
     3.390    53.938     0.150
     3.390    94.539     0.150
     3.408    54.520     0.150
     3.408    95.609     0.150
     3.489    54.637     0.150
     3.489    95.969     0.150
     3.503    54.316     0.150
     3.503    95.680     0.150
     3.548    55.289     0.150
     3.548    97.199     0.150
     3.761    57.770     0.150
     3.761   101.887     0.150
     3.807    58.418     0.150
     3.807    58.938     0.150
     3.807    59.359     0.150
     3.807   100.887     0.150
     3.807   103.398     0.150
     3.807   105.418     0.150
     3.885    59.199     0.150
     3.885   104.020     0.150
     4.044    61.988     0.150
     4.505    67.520     0.150
     4.948    72.758     0.150
     5.601    82.848     0.150
     5.601   147.199     0.150
    11.257   163.887     0.150
    11.257   358.996     0.150
    11.257   162.797     0.150
    12.591   180.590     0.150
    14.164   202.098     0.150
    16.585   229.328     0.150
    16.924   234.660     0.150
    17.167   241.367     0.150
    19.073   263.750     0.150
    19.893   272.648     0.150
    19.893   284.250     0.150
    20.327   273.359     0.150
    20.631   275.977     0.150
    20.804   278.609     0.150
    21.174   281.137     0.150
    21.179   281.430     0.150
    21.773   290.367     0.150
    22.043   294.367     0.150
    22.090   293.199     0.150
    22.176   290.918     0.150
    22.359   297.438     0.150
    22.374   298.020     0.150
    23.111   303.137     0.150
    23.514   309.629     0.150
    23.506   308.398     0.150
    24.453   318.359     0.150
    24.517   319.199     0.150
    24.524   319.789     0.150
    25.111   324.266     0.150
    25.317   321.938     0.150
    25.676   329.867     0.150
    26.026   333.559     0.150
    26.097   332.410     0.150
    26.383   334.488     0.150
    26.835   340.137     0.150
    26.835     7.750     0.150
    26.874   340.520     0.150
    27.197   339.438     0.150
    27.328   342.699     0.150
    27.894   348.039     0.150
    27.894     8.371     0.150
    28.044   350.078     0.150
    28.197     8.383     0.150
    28.255   352.199     0.150
    28.255     8.961     0.150
    28.759   355.918     0.150
    28.877   357.289     0.150
    29.138   360.789     0.150
    29.577   362.566     0.150
    30.094   367.039     0.150
    32.383   387.289     0.150
    32.383     9.148     0.150
    32.535   386.688     0.150
    32.535     8.449     0.150
    45.089   495.613     0.150
    45.089     7.977     0.150
    45.171   493.035     0.150
    45.171     8.297     0.150
    45.681   497.113     0.150
    45.681     7.949     0.150
    51.162   539.262     0.150
    51.162     8.453     0.150
    53.432   559.488     0.150
    53.887   560.789     0.150
    53.887     8.348     0.150
    54.321   565.188     0.150
    55.250   571.188     0.150
    55.250     8.301     0.150
    55.301   572.469     0.150
    55.395   572.609     0.150
    55.645   574.090     0.150
    56.849   582.688     0.150
    57.789   588.770     0.150
    62.240   619.047     0.150
    62.240     9.352     0.150
    65.612   642.812     0.150
    65.612     9.297     0.150
    78.051   716.570     0.150
    78.051   724.672     0.150
    80.513   730.039     0.150
    80.513     8.598     0.150
    82.653   742.289     0.150
    82.857   743.488     0.150
    83.132   744.789     0.150
    84.152   750.488     0.150
    84.254   751.090     0.150
    84.537   752.387     0.150
    85.005   754.340     0.150
    85.005     8.211     0.150
    85.230   754.090     0.150
    85.230   754.230     0.150
    85.230     9.484     0.150
    85.259   752.812     0.150
    85.259    10.152     0.150
    86.303   760.789     0.150
    86.590   762.789     0.150
    86.869   763.289     0.150
    86.934   763.590     0.150
    88.021   768.887     0.150
    88.768   770.688     0.150
    89.180   773.988     0.150
    90.837   788.789     0.150
    92.636   798.363     0.150
    99.237  1056.988     0.150
    99.237  1458.387     0.150
   121.037  1131.738     0.150
   121.037  1140.438     0.150
   127.276  1143.137     0.150
   127.276  1151.938     0.150
   129.610  1156.039     0.150
   131.229  1159.812     0.150
   138.019  1162.488     0.150
   138.019  1173.238     0.150
   144.716  1182.988     0.150
     1.108    19.414     0.150
     1.108    33.141     0.150
     2.050    35.000     0.150
     2.050    61.062     0.150
     2.378    37.500     0.150
     2.378    66.141     0.150
     2.503    40.906     0.150
     2.503    72.094     0.150
     2.808    43.594     0.150
     2.808    74.672     0.150
     2.788    45.438     0.150
     2.788    78.984     0.150
     2.919    46.242     0.150
     2.919    80.625     0.150
     2.950    61.047     0.150
     3.050    50.086     0.150
     3.050    84.625     0.150
     3.166    49.664     0.150
     3.166    87.906     0.150
     3.272    52.594     0.150
     3.272    90.383     0.150
     3.410    53.281     0.150
     3.410    93.766     0.150
     3.452    55.094     0.150
     3.452    55.734     0.150
     3.452    94.883     0.150
     3.452   101.344     0.150
     3.473    54.203     0.150
     3.473    96.703     0.150
     3.548    55.781     0.150
     3.548    98.344     0.150
     3.569    56.375     0.150
     3.569    98.242     0.150
     3.613    55.750     0.150
     3.613    97.938     0.150
     3.821    60.977     0.150
     3.821   102.211     0.150
     3.864    60.203     0.150
     3.864    60.820     0.150
     3.864    64.555     0.150
     3.864   105.102     0.150
     3.864   106.305     0.150
     3.948    61.023     0.150
     3.948   109.516     0.150
     4.099    62.867     0.150
     4.522    68.344     0.150
     4.522   119.531     0.150
     5.001    74.594     0.150
     5.633    85.594     0.150
     6.556    96.805     0.150
     6.556   169.375     0.150
    11.315   163.391     0.150
    11.315   164.094     0.150
    11.315   355.742     0.150
    16.829   237.586     0.150
    16.992   235.586     0.150
    17.220   242.664     0.150
    18.307   251.250     0.150
    19.918   272.836     0.150
    21.253   282.367     0.150
    21.871   291.492     0.150
    22.251   292.211     0.150
    22.392   298.797     0.150
    23.553   310.234     0.150
    24.555   319.672     0.150
    24.750   321.922     0.150
    28.092   352.211     0.150
    28.808   356.484     0.150
    28.926   357.297     0.150
    28.926     8.000     0.150
    32.602   387.492     0.150
    32.602     7.328     0.150
    45.226   493.539     0.150
    45.226     7.352     0.150
    48.069   519.383     0.150
    54.358   565.703     0.150
    55.292   571.023     0.150
    55.292     7.617     0.150
    62.228   620.000     0.150
    65.576   643.664     0.150
    80.587   731.297     0.150
    80.587     7.695     0.150
    84.226   750.195     0.150
    84.328   750.797     0.150
    84.611   751.992     0.150
    85.303    10.000     0.150
    85.329   756.258     0.150
    86.375   761.297     0.150
    86.501   761.492     0.150
    86.872   763.094     0.150
    86.942   763.797     0.150
    86.941   763.492     0.150
    87.241   764.891     0.150
    87.455   765.797     0.150
    87.468   765.492     0.150
    87.591   766.695     0.150
    88.094   768.297     0.150
    90.214   780.391     0.150
    92.710   798.391     0.150
   127.219  1143.242     0.150
   138.050  1166.547     0.150
   144.776  1175.094     0.150
     1.219    22.172     0.150
     1.219    38.172     0.150
     2.127    35.508     0.150
     2.127    61.594     0.150
     2.487    41.359     0.150
     2.487    69.898     0.150
     2.487    40.602     0.150
     2.487    70.102     0.150
     2.689    43.984     0.150
     2.689    74.914     0.150
     2.917    45.602     0.150
     2.917    79.094     0.150
     3.038    49.758     0.150
     3.038    85.164     0.150
     3.158    50.508     0.150
     3.158    88.164     0.150
     3.269    53.562     0.150
     3.269    94.211     0.150
     3.383    54.062     0.150
     3.383    96.539     0.150
     3.563    56.508     0.150
     3.563    57.102     0.150
     3.563    97.492     0.150
     3.582    55.930     0.150
     3.582    97.758     0.150
     3.663    57.508     0.150
     3.663    99.805     0.150
     3.675    58.672     0.150
     3.675    97.750     0.150
     3.722    59.062     0.150
     3.722   102.430     0.150
     3.934    61.844     0.150
     3.934   107.164     0.150
     3.980    61.602     0.150
     3.980    63.328     0.150
     3.980    65.219     0.150
     3.980   107.633     0.150
     3.980   108.078     0.150
     3.980   108.789     0.150
     4.059    61.672     0.150
     4.059   110.875     0.150
     4.634    70.695     0.150
     4.634   123.773     0.150
     5.119    76.461     0.150
     5.119   137.211     0.150
     5.751    86.602     0.150
     5.751   155.859     0.150
    11.308   163.547     0.150
    11.308   355.953     0.150
    14.211   207.789     0.150
    16.008   227.664     0.150
    17.017   244.359     0.150
    22.335   298.133     0.150
    22.482   300.625     0.150
    28.784   356.773     0.150
    32.621   387.500     0.150
    45.213   493.297     0.150
    45.213     8.352     0.150
    45.213    12.000     0.150
    48.154   519.539     0.150
    55.251   571.414     0.150
    55.251     7.688     0.150
    55.251    11.641     0.150
    62.312   620.359     0.150
    65.626   644.172     0.150
    78.144   716.984     0.150
    78.144     7.898     0.150
    80.658   731.250     0.150
    80.658     8.250     0.150
    83.013   744.305     0.150
    84.307   749.898     0.150
    84.408   750.602     0.150
    84.691   751.898     0.150
    85.171   756.305     0.150
    85.171     7.938     0.150
    85.365   755.898     0.150
    85.359   755.266     0.150
    85.359     8.609     0.150
    86.464   761.000     0.150
    86.586   761.203     0.150
    87.024   763.000     0.150
    87.029   763.602     0.150
    87.323   763.398     0.150
    87.536   765.398     0.150
    87.672   765.398     0.150
    87.915   766.203     0.150
    88.180   769.102     0.150
    92.783   799.461     0.150
   127.103  1143.000     0.150
   131.354  1151.125     0.150
   137.990  1164.453     0.150
   144.775  1174.102     0.150
   144.775  1183.102     0.150
     1.136    19.426     0.150
     1.136    35.043     0.150
     2.091    34.516     0.150
     2.091    60.266     0.150
     2.404    38.453     0.150
     2.404    67.805     0.150
     2.519    39.383     0.150
     2.519    69.746     0.150
     2.834    44.723     0.150
     2.834    76.805     0.150
     3.094    48.926     0.150
     3.094    85.895     0.150
     3.210    49.773     0.150
     3.210    88.133     0.150
     3.316    51.594     0.150
     3.316    92.863     0.150
     3.452    53.113     0.150
     3.452    93.953     0.150
     3.495    54.996     0.150
     3.495    56.234     0.150
     3.495    95.383     0.150
     3.591    55.312     0.150
     3.591    97.656     0.150
     3.613    57.363     0.150
     3.613   100.062     0.150
     3.657    56.594     0.150
     3.657    99.523     0.150
     3.865    62.336     0.150
     3.865   104.496     0.150
     3.907    60.715     0.150
     3.907    61.145     0.150
     3.907    65.414     0.150
     3.907   105.703     0.150
     3.907   105.875     0.150
     3.907   107.945     0.150
     3.992    60.496     0.150
     3.992   107.906     0.150
     4.141    64.293     0.150
     4.141   112.312     0.150
     4.550    68.453     0.150
     4.550   124.223     0.150
     4.754    72.246     0.150
     4.754   129.523     0.150
     5.043    76.723     0.150
     5.043   135.676     0.150
     5.667    84.906     0.150
     5.667   148.414     0.150
    11.334   166.656     0.150
    11.334   163.809     0.150
    11.334   361.336     0.150
    13.404   190.164     0.150
    14.239   205.914     0.150
    16.062   228.004     0.150
    16.494   234.344     0.150
    17.021   236.895     0.150
    18.343   253.355     0.150
    19.120   264.656     0.150
    19.914   271.938     0.150
    20.896   279.906     0.150
    21.289   281.594     0.150
    21.293   282.766     0.150
    22.094   294.812     0.150
    22.098   294.855     0.150
    22.148   294.406     0.150
    22.391   298.605     0.150
    22.393   297.793     0.150
    22.290   291.793     0.150
    22.545   299.395     0.150
    24.485   319.074     0.150
    24.556   320.160     0.150
    25.157   324.094     0.150
    25.397   324.363     0.150
    26.079   331.535     0.150
    27.382   343.523     0.150
    28.538   353.375     0.150
    28.822   356.246     0.150
    28.938   357.734     0.150
    29.641   362.766     0.150
    30.155   367.754     0.150
    45.244   493.578     0.150
    45.793   497.984     0.150
    45.793     7.977     0.150
    48.081   518.219     0.150
    55.299   571.535     0.150
    55.299     9.148     0.150
    55.299    14.043     0.150
    65.572   643.059     0.150
    82.973   742.336     0.150
    83.248   744.035     0.150
    84.268   749.434     0.150
    84.370   750.133     0.150
    84.653   751.434     0.150
    85.361   754.809     0.150
    85.361     8.301     0.150
    86.418   760.535     0.150
    86.543   760.836     0.150
    86.914   762.535     0.150
    86.983   761.934     0.150
    86.984   763.133     0.150
    87.283   764.336     0.150
    87.497   764.336     0.150
    87.633   766.234     0.150
    87.876   767.434     0.150
    88.136   768.734     0.150
    88.933   772.535     0.150
    89.895   777.434     0.150
   120.928  1131.484     0.150
   127.176  1143.285     0.150
   127.176  1153.285     0.150
   129.537  1147.285     0.150
   138.050  1161.891     0.150
     1.283    20.922     0.150
     1.283    39.062     0.150
     2.210    36.452     0.150
     2.210    63.462     0.150
     2.453    39.412     0.150
     2.453    68.882     0.150
     2.551    42.602     0.150
     2.551    77.322     0.150
     2.627    41.182     0.150
     2.627    71.482     0.150
     2.981    45.082     0.150
     2.981    79.812     0.150
     3.092    49.992     0.150
     3.092    85.682     0.150
     3.199    50.902     0.150
     3.199    88.352     0.150
     3.304    52.872     0.150
     3.304    90.512     0.150
     3.426    56.602     0.150
     3.426   105.962     0.150
     3.623    58.582     0.150
     3.710    59.002     0.150
     3.710   105.422     0.150
     3.714    60.792     0.150
     3.714   100.922     0.150
     3.763    59.422     0.150
     3.763   102.112     0.150
     3.980    59.882     0.150
     3.980   110.322     0.150
     4.029    65.682     0.150
     4.029    66.622     0.150
     4.029   111.762     0.150
     4.029   113.642     0.150
     4.102    63.932     0.150
     4.102   113.312     0.150
     4.266    68.072     0.150
     4.266   117.172     0.150
     5.171    78.072     0.150
     5.171   135.402     0.150
     5.812    88.022     0.150
     5.812   151.722     0.150
    11.278   165.002     0.150
    11.278   164.462     0.150
    11.278   355.737     0.150
    12.671   181.722     0.150
    17.003   236.212     0.150
    17.164   239.432     0.150
    21.331   282.442     0.150
    21.829   291.042     0.150
    22.003   293.002     0.150
    22.284   297.152     0.150
    24.375   317.852     0.150
    24.445   319.337     0.150
    24.722   316.192     0.150
    27.293   342.902     0.150
    28.860   357.262     0.150
    32.604   387.587     0.150
    45.179   493.207     0.150
    45.179     8.800     0.150
    45.179    12.500     0.150
    45.819   497.837     0.150
    55.205   570.941     0.150
    55.205     8.971     0.150
    55.205    12.070     0.150
    62.372   620.309     0.150
    65.675   643.246     0.150
    84.325   749.662     0.150
    84.426   750.262     0.150
    84.709   751.462     0.150
    85.356   754.612     0.150
    85.356    13.250     0.150
    85.362   754.862     0.150
    85.362   754.801     0.150
    85.362    12.736     0.150
    86.487   760.762     0.150
    86.607   760.862     0.150
    86.977   762.662     0.150
    87.053   763.962     0.150
    87.342   763.162     0.150
    87.554   765.562     0.150
   137.938  1162.762     0.150
     1.143    20.746     0.150
     1.143    33.836     0.150
     1.545    27.805     0.150
     1.545    47.484     0.150
     1.846    32.645     0.150
     1.846    55.984     0.150
     2.034    35.645     0.150
     2.034    61.754     0.150
     2.100    36.426     0.150
     2.100    61.125     0.150
     2.462    40.844     0.150
     2.462    72.195     0.150
     2.844    44.625     0.150
     2.844    76.805     0.150
     3.054    49.035     0.150
     3.054    88.215     0.150
     3.165    51.266     0.150
     3.354    55.637     0.150
     3.459    53.355     0.150
     3.477    56.316     0.150
     3.571    57.555     0.150
     3.558    97.484     0.150
     3.617    57.375     0.150
     3.617    99.547     0.150
     3.830    62.484     0.150
     3.830   108.387     0.150
     3.876    61.457     0.150
     3.876    61.945     0.150
     3.876    64.367     0.150
     3.876   105.617     0.150
     3.876   107.926     0.150
     3.954    63.836     0.150
     4.112    63.855     0.150
     4.266    71.855     0.150
     4.266   122.855     0.150
     4.693    72.734     0.150
     4.693   130.926     0.150
     5.016    74.285     0.150
     5.662    86.906     0.150
     5.662   148.715     0.150
    10.373   154.934     0.150
    10.373   265.555     0.150
    11.275   164.957     0.150
    11.275   164.285     0.150
    12.626   181.867     0.150
    13.344   189.824     0.150
    14.181   201.465     0.150
    16.014   227.055     0.150
    17.178   444.070     0.150
    17.877   252.887     0.150
    18.775   258.555     0.150
    18.792   262.316     0.150
    18.868   261.906     0.150
    18.907   265.117     0.150
    19.070   264.707     0.150
    19.181   266.887     0.150
    19.403   274.695     0.150
    19.783   272.934     0.150
    19.813   273.305     0.150
    19.812   274.145     0.150
    19.815   273.145     0.150
    19.955   275.566     0.150
    19.874   274.086     0.150
    20.112   277.375     0.150
    20.381   275.406     0.150
    20.686   278.676     0.150
    20.834   280.625     0.150
    20.839   284.957     0.150
    21.022   281.746     0.150
    21.235   283.414     0.150
    21.060   286.285     0.150
    21.288   289.164     0.150
    21.243   285.574     0.150
    21.841   291.164     0.150
    21.849   294.234     0.150
    22.043   295.434     0.150
    22.047   295.496     0.150
    22.094   295.527     0.150
    22.232   293.426     0.150
    22.190   298.496     0.150
    22.348   299.145     0.150
    22.603   297.324     0.150
    22.490   300.625     0.150
    22.691   298.375     0.150
    22.504   300.906     0.150
    22.822   301.375     0.150
    22.965   300.406     0.150
    22.979   301.477     0.150
    23.510   309.965     0.150
    23.493   312.086     0.150
    23.712   312.625     0.150
    23.775   312.484     0.150
    23.813   314.164     0.150
    24.038   311.547     0.150
    23.979   314.676     0.150
    24.266   315.117     0.150
    24.441   320.035     0.150
    24.511   321.207     0.150
    24.496   320.727     0.150
    24.708   320.707     0.150
    24.850   319.176     0.150
    24.960   319.477     0.150
    24.980   324.367     0.150
    25.247   323.594     0.150
    25.108   325.434     0.150
    25.209   325.004     0.150
    25.379   324.387     0.150
    25.341   325.824     0.150
    25.283   326.656     0.150
    25.716   329.066     0.150
    25.633   330.285     0.150
    25.656   330.945     0.150
    25.903   333.227     0.150
    26.019   332.215     0.150
    26.005   334.824     0.150
    26.389   335.637     0.150
    26.900   337.406     0.150
    26.818   341.477     0.150
    26.818     6.988     0.150
    26.854   342.066     0.150
    27.257   341.027     0.150
    27.238   344.617     0.150
    27.329   344.027     0.150
    27.444   347.367     0.150
    27.711   348.277     0.150
    27.887   350.105     0.150
    27.887     7.262     0.150
    28.050   351.324     0.150
    28.186   353.254     0.150
    28.186     7.480     0.150
    28.208   354.426     0.150
    28.237   355.086     0.150
    28.483   354.664     0.150
    28.766   357.426     0.150
    28.884   358.754     0.150
    28.884     7.902     0.150
    29.121   361.695     0.150
    29.213   360.625     0.150
    29.213     7.352     0.150
    29.586   364.016     0.150
    30.100   368.387     0.150
    31.161   375.727     0.150
    31.265   381.027     0.150
    31.344   382.137     0.150
    31.965   387.426     0.150
    32.148   389.094     0.150
    32.265   387.984     0.150
    32.568   388.980     0.150
    32.568     8.125     0.150
    32.568   556.980     0.150
    32.576   392.566     0.150
    32.602   392.605     0.150
    32.723   392.746     0.150
    32.870   394.566     0.150
    33.073   392.457     0.150
    33.073     9.125     0.150
    33.443   399.777     0.150
    34.588   408.055     0.150
    36.607   423.254     0.150
    41.127   461.277     0.150
    41.127     8.289     0.150
    45.089   495.629     0.150
    45.089     9.703     0.150
    45.186   494.750     0.150
    45.186     8.652     0.150
    45.733   498.281     0.150
    45.733     8.223     0.150
    48.112   520.988     0.150
    52.708   554.375     0.150
    52.708     8.410     0.150
    53.428   561.254     0.150
    53.895   561.230     0.150
    53.895     9.426     0.150
    53.954   563.746     0.150
    53.954     8.301     0.150
    54.013   565.695     0.150
    54.212   566.176     0.150
    54.212     7.238     0.150
    54.314   566.496     0.150
    54.314     7.488     0.150
    55.248   572.805     0.150
    55.248     8.652     0.150
    55.292   573.727     0.150
    55.292     7.438     0.150
    55.325   573.926     0.150
    55.325     7.031     0.150
    55.392   573.914     0.150
    55.392     7.973     0.150
    55.644   574.457     0.150
    56.840   583.855     0.150
    57.782   590.977     0.150
    57.782     6.891     0.150
    60.275   608.195     0.150
    62.270   621.652     0.150
    62.270     8.949     0.150
    63.320   629.312     0.150
    63.336   629.957     0.150
    63.336     8.098     0.150
    65.619   644.793     0.150
    66.226   647.016     0.150
    68.687   664.656     0.150
    68.687     8.301     0.150
    71.160   676.254     0.150
    71.160     8.602     0.150
    73.779   693.355     0.150
    73.779     8.699     0.150
    78.082   715.656     0.150
    80.549   732.004     0.150
    80.549     7.883     0.150
    80.804   734.836     0.150
    80.804     7.898     0.150
    80.904   735.004     0.150
    80.904     8.273     0.150
    80.741   733.656     0.150
    81.507   738.156     0.150
    81.507     8.258     0.150
    81.940   740.754     0.150
    81.940     7.902     0.150
    82.232   749.855     0.150
    82.744   745.055     0.150
    83.193   743.855     0.150
    83.402     7.562     0.150
    83.427   747.855     0.150
    83.664   750.305     0.150
    84.014   749.957     0.150
    84.314   750.355     0.150
    84.615   755.176     0.150
    84.615     6.238     0.150
    84.719     5.621     0.150
    84.908   756.656     0.150
    84.989   756.777     0.150
    85.070   756.254     0.150
    85.070     8.352     0.150
    85.070   756.176     0.150
    85.122     5.461     0.150
    85.239   757.426     0.150
    85.280   756.855     0.150
    85.280     8.449     0.150
    85.299   756.895     0.150
    85.299     7.973     0.150
    85.299   756.227     0.150
    85.607   758.957     0.150
    85.763   760.676     0.150
    86.057   761.824     0.150
    86.067   762.504     0.150
    86.366   760.754     0.150
    86.488   764.227     0.150
    86.649   761.957     0.150
    86.706   765.227     0.150
    86.817   762.754     0.150
    86.929   763.055     0.150
    86.932   764.555     0.150
    86.992   763.754     0.150
    87.225   768.246     0.150
    87.228   764.457     0.150
    87.270   768.945     0.150
    87.442   765.457     0.150
    87.455   765.254     0.150
    87.578   766.457     0.150
    87.821   766.957     0.150
    88.879   773.355     0.150
    89.182   773.957     0.150
    90.142   778.254     0.150
    90.170   780.457     0.150
    90.612   782.754     0.150
    90.612     7.801     0.150
    90.711   784.254     0.150
    90.785   780.555     0.150
    90.863   783.957     0.150
    90.863     3.199     0.150
    90.863     8.297     0.150
    90.883   783.656     0.150
    90.883     7.176     0.150
    91.305   783.754     0.150
    91.766     6.500     0.150
    92.475   791.855     0.150
    92.475     8.500     0.150
    92.559   790.855     0.150
    92.559     8.000     0.150
    92.693   792.105     0.150
    92.693     8.148     0.150
    93.039     5.797     0.150
    94.049   797.254     0.150
    94.098   798.855     0.150
    94.251   799.906     0.150
    94.251     8.098     0.150
    94.471   798.055     0.150
    94.471  1430.656     0.150
    94.557     4.898     0.150
    94.947   803.754     0.150
    94.947     7.703     0.150
    95.095   802.547     0.150
    95.221   803.266     0.150
    95.448   804.246     0.150
    97.083     5.000     0.150
    98.552   817.457     0.150
    98.552   825.656     0.150
   101.037   831.629     0.150
   102.116   830.855     0.150
   117.411  1125.457     0.150
   117.411  1133.957     0.150
   117.723  1123.855     0.150
   119.128  1128.754     0.150
   119.128  1216.855     0.150
   120.136  1130.355     0.150
   120.968  1132.605     0.150
   120.968  1141.855     0.150
   123.331  1137.855     0.150
   125.131  1140.656     0.150
   127.208  1144.504     0.150
   127.208  1154.105     0.150
   127.210  1143.957     0.150
   129.595  1149.004     0.150
   129.595  1158.355     0.150
   130.510  1151.457     0.150
   130.717  1152.461     0.150
   130.717  1161.844     0.150
   131.904  1151.855     0.150
   131.904  1355.855     0.150
   134.275  1157.555     0.150
   138.006  1166.707     0.150
   138.006  1165.004     0.150
   138.006  1174.207     0.150
   138.006  1333.805     0.150
   144.719  1175.855     0.150
   144.737  1175.855     0.150
   144.737  1184.855     0.150
     1.222    21.500     0.150
     1.222    38.582     0.150
     1.321    21.930     0.150
     1.321    38.531     0.150
     1.287    39.629     0.150
     1.560    44.109     0.150
     1.908    31.039     0.150
     1.908    53.902     0.150
     2.406    39.602     0.150
     2.406    68.699     0.150
     2.469    39.672     0.150
     2.469    69.129     0.150
     2.662    42.492     0.150
     2.662    73.199     0.150
     2.769    44.992     0.150
     2.877    43.992     0.150
     2.877    78.000     0.150
     2.851    47.109     0.150
     2.851    48.051     0.150
     2.851    78.441     0.150
     2.851    78.652     0.150
     2.907    48.039     0.150
     2.907    80.422     0.150
     2.998    49.301     0.150
     2.998    84.871     0.150
     3.239    50.410     0.150
     3.239    90.473     0.150
     3.326    52.570     0.150
     3.326    91.699     0.150
     3.333    53.480     0.150
     3.333    54.812     0.150
     3.333    91.980     0.150
     3.333    93.891     0.150
     3.333    95.199     0.150
     3.594    55.879     0.150
     3.594    97.789     0.150
     4.494    68.410     0.150
     4.494   119.770     0.150
     4.510    69.301     0.150
     4.510   122.750     0.150
     5.418    79.910     0.150
     5.418   143.699     0.150
     7.101   105.730     0.150
     7.101   187.879     0.150
    16.181   229.340     0.150
    24.120   317.199     0.150
    24.734   321.402     0.150
    44.536   489.258     0.150
    54.736   567.750     0.150
     1.259    20.937     0.150
     1.259    35.456     0.150
     1.745    30.946     0.150
     1.745    52.246     0.150
     2.048    35.296     0.150
     2.048    61.116     0.150
     2.113    36.246     0.150
     2.382    38.246     0.150
     2.530    39.196     0.150
     2.530    69.736     0.150
     2.960    44.736     0.150
     2.960    77.526     0.150
     3.027    48.066     0.150
     3.027    83.496     0.150
     3.114    50.556     0.150
     3.114    86.576     0.150
     3.215    50.187     0.150
     3.344    53.316     0.150
     3.344    91.286     0.150
     3.425    53.576     0.150
     3.425    93.626     0.150
     3.481    54.206     0.150
     3.481    94.756     0.150
     3.503    55.606     0.150
     3.503    95.926     0.150
     3.526    55.546     0.150
     3.526    57.636     0.150
     3.526    59.746     0.150
     3.526    96.906     0.150
     3.538    56.246     0.150
     3.538    95.196     0.150
     3.633    56.306     0.150
     3.633   100.446     0.150
     3.900    60.956     0.150
     3.900   106.816     0.150
     3.953    60.126     0.150
     3.953    61.446     0.150
     3.953    62.956     0.150
     3.953   107.656     0.150
     3.953   108.477     0.150
     4.019    61.716     0.150
     4.671    69.246     0.150
     4.671   123.876     0.150
     5.100    77.746     0.150
     5.761    85.866     0.150
     5.761   150.977     0.150
     5.768    87.246     0.150
     5.768   147.246     0.150
     6.147    91.656     0.150
     6.704    98.766     0.150
     6.704   177.416     0.150
     7.499   109.316     0.150
    10.485   154.246     0.150
    11.203   161.416     0.150
    11.203   163.546     0.150
    11.203   352.723     0.150
    12.582   180.466     0.150
    13.329   189.406     0.150
    14.106   201.216     0.150
    15.913   224.446     0.150
    16.354   229.536     0.150
    16.439   231.846     0.150
    16.914   235.536     0.150
    17.097   240.206     0.150
    18.264   253.026     0.150
    18.973   262.596     0.150
    20.164   270.536     0.150
    20.600   277.846     0.150
    20.951   282.716     0.150
    20.937   280.866     0.150
    21.132   283.746     0.150
    21.233   282.016     0.150
    21.669   290.966     0.150
    21.751   291.796     0.150
    21.756   290.276     0.150
    21.952   292.866     0.150
    22.005   293.416     0.150
    22.242   297.066     0.150
    22.231   291.937     0.150
    22.243   296.526     0.150
    22.240   293.426     0.150
    22.382   297.856     0.150
    22.395   297.916     0.150
    22.611   296.546     0.150
    22.811   299.006     0.150
    22.987   300.666     0.150
    23.143   302.937     0.150
    23.157   305.486     0.150
    23.420   307.586     0.150
    23.607   310.396     0.150
    23.681   310.736     0.150
    23.818   311.076     0.150
    23.887   311.966     0.150
    24.284   315.076     0.150
    24.406   318.471     0.150
    24.406   537.121     0.150
    24.624   316.716     0.150
    24.869   320.316     0.150
    24.879   318.946     0.150
    24.985   320.166     0.150
    25.108   320.526     0.150
    25.166   323.156     0.150
    25.241   322.176     0.150
    25.258   324.034     0.150
    25.258   537.796     0.150
    25.532   327.666     0.150
    25.592   326.926     0.150
    25.797   331.556     0.150
    25.895   331.556     0.150
    25.927   331.196     0.150
    26.101   331.437     0.150
    26.253   333.346     0.150
    26.529   338.206     0.150
    26.710   338.566     0.150
    26.722   337.416     0.150
    27.237   342.156     0.150
    27.273   339.606     0.150
    27.626   346.187     0.150
    27.829   345.856     0.150
    27.961   349.306     0.150
    28.083   350.886     0.150
    28.083    12.141     0.150
    28.398   352.596     0.150
    28.398    12.051     0.150
    28.797   356.546     0.150
    29.501   361.727     0.150
    29.707   366.426     0.150
    30.013   366.176     0.150
    30.013    11.960     0.150
    30.404   369.606     0.150
    31.123   373.876     0.150
    31.239   380.046     0.150
    31.434   381.066     0.150
    31.527   382.206     0.150
    31.546   381.396     0.150
    31.738   383.706     0.150
    32.048   386.756     0.150
    32.179   385.687     0.150
    32.294   387.034     0.150
    32.294     9.550     0.150
    32.294    13.450     0.150
    32.294   555.284     0.150
    32.517   387.296     0.150
    32.517   555.471     0.150
    32.624   390.116     0.150
    32.774   392.386     0.150
    33.068   391.146     0.150
    33.690   398.746     0.150
    34.678   407.116     0.150
    34.814   410.246     0.150
    35.121   410.836     0.150
    36.644   423.286     0.150
    41.074   459.986     0.150
    45.109   492.405     0.150
    45.109     8.936     0.150
    45.109    12.979     0.150
    45.109   594.791     0.150
    45.722   497.871     0.150
    45.722     8.950     0.150
    45.722   596.521     0.150
    45.983   501.486     0.150
    48.227   519.687     0.150
    53.329   558.446     0.150
    53.809   559.716     0.150
    53.849   561.937     0.150
    53.908   561.516     0.150
    54.111   563.246     0.150
    54.214   563.956     0.150
    55.153   570.446     0.150
    55.153     8.747     0.150
    55.153    12.761     0.150
    55.153   631.796     0.150
    55.294   571.526     0.150
    56.738   581.146     0.150
    56.744   578.886     0.150
    57.681   587.816     0.150
    58.244   591.596     0.150
    60.164   605.356     0.150
    63.437   628.982     0.150
    63.453   628.146     0.150
    65.720   643.426     0.150
    67.697   655.386     0.150
    68.248   658.098     0.150
    68.248   660.431     0.150
    68.248   662.764     0.150
    68.248    11.536     0.150
    68.799   687.446     0.150
    68.799    12.100     0.150
    72.274   683.187     0.150
    73.681   692.546     0.150
    73.681     8.800     0.150
    78.831   717.946     0.150
    78.896   718.446     0.150
    79.275   721.346     0.150
    80.552   728.576     0.150
    80.572   731.256     0.150
    80.833   730.906     0.150
    81.507   735.746     0.150
    81.507     9.500     0.150
    81.535   734.766     0.150
    81.855    11.800     0.150
    81.918   738.246     0.150
    81.918     9.500     0.150
    81.970   737.326     0.150
    82.214    11.500     0.150
    82.266   739.346     0.150
    82.429   741.446     0.150
    82.429     8.600     0.150
    82.479   740.746     0.150
    82.479     9.500     0.150
    82.640   741.746     0.150
    82.724   742.346     0.150
    82.724     9.301     0.150
    83.395   745.796     0.150
    83.395   747.886     0.150
    83.435   746.006     0.150
    83.928   747.746     0.150
    84.228   749.446     0.150
    84.329   750.146     0.150
    84.612   751.446     0.150
    84.646   751.906     0.150
    84.757   752.466     0.150
    84.947   753.846     0.150
    85.104   754.896     0.150
    85.104     8.550     0.150
    85.104   753.096     0.150
    85.149   754.227     0.150
    85.228   754.746     0.150
    85.266   754.846     0.150
    85.266   754.646     0.150
    85.266     9.457     0.150
    85.266    12.848     0.150
    85.265   754.234     0.150
    85.265     9.092     0.150
    85.265    13.672     0.150
    85.319   754.846     0.150
    85.578   756.266     0.150
    85.736   757.526     0.150
    85.801   758.446     0.150
    85.858   757.846     0.150
    86.087   758.766     0.150
    86.105   760.286     0.150
    86.198   760.426     0.150
    86.391   760.446     0.150
    86.510   760.946     0.150
    86.523   762.006     0.150
    86.658   761.746     0.150
    86.742   762.666     0.150
    86.880   762.546     0.150
    86.946   762.846     0.150
    86.956   763.146     0.150
    87.001   762.446     0.150
    87.245   764.146     0.150
    87.457   765.146     0.150
    87.471   764.746     0.150
    87.593   766.146     0.150
    87.837   766.746     0.150
    88.106   768.646     0.150
    88.770   771.446     0.150
    88.900   772.846     0.150
    89.108   773.646     0.150
    89.183   772.246     0.150
    89.194   772.246     0.150
    89.858   775.646     0.150
    90.074   777.786     0.150
    90.489   778.246     0.150
    90.616   780.746     0.150
    90.616     9.500     0.150
    90.616    13.500     0.150
    90.616     9.000     0.150
    90.806   780.546     0.150
    90.860   780.221     0.150
    90.860     9.375     0.150
    90.869   782.346     0.150
    90.869     9.101     0.150
    90.869    14.400     0.150
    90.869   782.346     0.150
    90.869     9.101     0.150
    90.869    14.400     0.150
    90.947   780.846     0.150
    90.956   780.746     0.150
    91.259   783.346     0.150
    91.283   783.846     0.150
    91.283     8.801     0.150
    91.324   782.246     0.150
    91.768   786.046     0.150
    91.768     8.900     0.150
    91.959   787.046     0.150
    92.082   787.346     0.150
    92.481   789.746     0.150
    92.562   789.046     0.150
    92.562     9.101     0.150
    92.622   790.046     0.150
    92.622     9.200     0.150
    92.699   790.146     0.150
    92.699     8.899     0.150
    92.699    13.649     0.150
    92.942   790.946     0.150
    93.327   792.846     0.150
    93.327     9.000     0.150
    93.542   794.246     0.150
    94.052   795.946     0.150
    94.052     9.300     0.150
    94.114   796.946     0.150
    94.138   797.796     0.150
    94.138     8.650     0.150
    94.415   797.946     0.150
    94.952   801.346     0.150
    94.952     9.400     0.150
    95.042   800.046     0.150
    95.230   801.346     0.150
    95.403   802.246     0.150
    95.570   803.646     0.150
    98.460   815.146     0.150
    99.262   817.746     0.150
    99.262   827.346     0.150
   100.922   829.208     0.150
   117.645  1124.246     0.150
   120.031  1127.746     0.150
   120.910  1131.346     0.150
   122.786  1133.646     0.150
   126.292  1141.854     0.150
   127.132  1143.046     0.150
   127.132  1152.496     0.150
   127.135  1142.946     0.150
   127.319  1143.746     0.150
   129.671  1147.746     0.150
   131.395  1151.827     0.150
   131.395  1160.985     0.150
   131.395  1291.169     0.150
   132.531  1152.246     0.150
   132.531  1363.246     0.150
   134.187  1156.946     0.150
   137.900  1163.896     0.150
   137.900  1173.246     0.150
   142.377  1165.146     0.150
   144.670  1174.246     0.150
   144.670  1183.746     0.150
   147.590  1183.246     0.150
   151.831  1193.246     0.150
     1.070    19.947     0.150
     1.070    32.838     0.150
     1.869    32.588     0.150
     1.869    55.338     0.150
     1.961    35.348     0.150
     1.961    60.648     0.150
     2.027    36.588     0.150
     2.027    61.078     0.150
     2.342    38.668     0.150
     2.342    65.607     0.150
     2.457    40.469     0.150
     2.457    72.828     0.150
     2.772    44.848     0.150
     2.772    75.469     0.150
     2.844    47.658     0.150
     2.844    80.607     0.150
     3.261    94.127     0.150
     3.330    56.568     0.150
     3.330    94.098     0.150
     3.366    53.809     0.150
     3.366    58.838     0.150
     3.366    94.219     0.150
     3.366    94.658     0.150
     3.465    94.389     0.150
     3.481    94.568     0.150
     3.783    62.828     0.150
     3.783   107.139     0.150
     3.783   107.469     0.150
     4.019    62.707     0.150
     4.923    77.107     0.150
     5.576    85.088     0.150
     5.576   148.648     0.150
     7.308   106.059     0.150
     7.308   190.828     0.150
    11.261   166.287     0.150
    16.920   235.848     0.150
    19.084   265.969     0.150
    20.096   271.838     0.150
    21.165   283.117     0.150
    22.053   295.838     0.150
    22.373   299.377     0.150
    24.560   317.617     0.150
    24.538   320.738     0.150
    25.338   325.838     0.150
    45.176   494.133     0.150
    45.176     7.750     0.150
    55.260   572.639     0.150
    55.260     7.699     0.150
    63.252   629.072     0.150
    65.600   644.074     0.150
    85.252   756.615     0.150
     0.929    17.945     0.150
     0.929    29.875     0.150
     2.190    35.727     0.150
     2.190    61.414     0.150
     2.110    36.594     0.150
     2.124    37.859     0.150
     2.191    38.141     0.150
     2.619    42.953     0.150
     2.706    44.430     0.150
     2.821    46.312     0.150
     2.821    80.930     0.150
     3.025    53.500     0.150
     2.996    46.945     0.150
     2.996    85.281     0.150
     3.233    55.102     0.150
     3.408    55.359     0.150
     3.408    56.992     0.150
     3.408    98.445     0.150
     3.442    56.070     0.150
     3.582    57.734     0.150
     3.795    60.320     0.150
     3.795    61.281     0.150
     4.339    66.180     0.150
     4.339   113.781     0.150
     4.915    75.852     0.150
     5.471    83.477     0.150
     5.479    83.086     0.150
     6.375   167.320     0.150
     7.221   107.375     0.150
    11.506   169.367     0.150
    11.506   168.906     0.150
    12.812   184.391     0.150
    13.473   191.695     0.150
    16.277   230.516     0.150
    16.683   234.922     0.150
    16.770   237.461     0.150
    16.840   237.930     0.150
    17.034   241.695     0.150
    17.145   239.820     0.150
    17.421   245.922     0.150
    18.419   254.531     0.150
    19.330   268.211     0.150
    20.265   273.891     0.150
    20.489   277.492     0.150
    20.640   278.664     0.150
    20.859   283.742     0.150
    20.933   284.094     0.150
    21.034   283.164     0.150
    21.105   287.070     0.150
    21.273   286.961     0.150
    21.324   284.672     0.150
    21.328   285.516     0.150
    21.510   291.594     0.150
    22.065   295.625     0.150
    22.110   298.172     0.150
    22.300   299.375     0.150
    22.305   299.055     0.150
    22.347   298.391     0.150
    22.619   302.711     0.150
    22.756   303.953     0.150
    23.013   302.094     0.150
    23.763   313.203     0.150
    23.759   314.477     0.150
    23.977   316.203     0.150
    24.031   315.750     0.150
    24.162   315.695     0.150
    24.234   318.164     0.150
    24.731   319.453     0.150
    24.706   323.445     0.150
    24.777   324.859     0.150
    24.960   323.859     0.150
    25.246   328.594     0.150
    25.368   328.727     0.150
    25.463   328.234     0.150
    25.586   329.430     0.150
    25.586   541.180     0.150
    25.897   333.391     0.150
    26.169   337.859     0.150
    26.272   338.320     0.150
    26.435   336.914     0.150
    26.584   338.891     0.150
    26.901   342.906     0.150
    27.085   344.227     0.150
    27.585   347.594     0.150
    27.702   349.062     0.150
    28.451   356.227     0.150
    28.504   357.805     0.150
    28.730   357.914     0.150
    29.014   360.594     0.150
    29.014     7.031     0.150
    29.133   361.984     0.150
    29.133   550.883     0.150
    30.350   371.727     0.150
    31.798   386.430     0.150
    32.411   392.516     0.150
    32.514   390.812     0.150
    32.762   391.609     0.150
    32.863   395.891     0.150
    32.985   395.805     0.150
    33.074   397.289     0.150
    33.180   393.883     0.150
    33.869   406.531     0.150
    45.422   498.125     0.150
    45.652   500.070     0.150
    45.853   500.680     0.150
    47.851   518.859     0.150
    47.851     6.984     0.150
    51.362   542.086     0.150
    54.142   564.156     0.150
    54.220   567.086     0.150
    54.476   568.562     0.150
    54.572   569.586     0.150
    54.577   568.984     0.150
    55.507   575.680     0.150
    55.589   576.031     0.150
    55.652   576.836     0.150
    55.903   578.586     0.150
    57.104   586.281     0.150
    58.045   593.109     0.150
    58.599   596.430     0.150
    78.272   719.867     0.150
    80.660   734.086     0.150
    81.542   738.281     0.150
    84.276   752.086     0.150
    84.380   752.680     0.150
    84.641   754.703     0.150
    84.662   754.781     0.150
    85.093   757.281     0.150
    85.358   758.383     0.150
    85.406   758.086     0.150
    85.406   758.008     0.150
    85.466   757.742     0.150
    85.774   761.383     0.150
    86.406   763.781     0.150
    86.508   764.148     0.150
    86.540   764.281     0.150
    86.721   766.023     0.150
    86.725   765.281     0.150
    86.987   766.383     0.150
    87.505   768.781     0.150
    87.642   769.680     0.150
    88.129   772.180     0.150
    90.430   782.445     0.150
    90.947   785.281     0.150
    90.947     6.305     0.150
    90.947  1000.484     0.150
    91.027   782.883     0.150
    92.777   792.531     0.150
   121.007  1132.883     0.150
   126.481  1144.414     0.150
   127.294  1146.031     0.150
   129.360  1149.883     0.150
   131.054  1153.133     0.150
   138.272  1167.180     0.150
   144.921  1175.883     0.150
   144.960  1177.383     0.150
   144.960  1184.383     0.150
   151.125  1194.883     0.150
   151.664  1196.883     0.150
     0.559    11.609     0.150
     0.559    20.438     0.150
     1.994    33.258     0.150
     1.994    56.844     0.150
     2.634    41.703     0.150
     2.634    70.398     0.150
     2.777    44.148     0.150
     2.777    76.477     0.150
     2.828    50.062     0.150
     2.828    84.438     0.150
     3.906    58.586     0.150
     3.906   105.117     0.150
     4.268    64.844     0.150
     4.268   113.477     0.150
     4.265    65.586     0.150
     4.265   115.188     0.150
     4.336    65.523     0.150
     4.596   122.492     0.150
     4.667    70.328     0.150
     4.667   123.008     0.150
     5.092    74.969     0.150
     5.092    80.344     0.150
     5.092   133.008     0.150
     5.353    78.047     0.150
     6.044   155.047     0.150
     7.096   185.180     0.150
    10.594   155.375     0.150
    10.594   154.734     0.150
    10.594   333.211     0.150
    12.332   176.938     0.150
    13.438   187.734     0.150
    14.872   212.758     0.150
    15.570   219.945     0.150
    15.570   224.609     0.150
    15.730   223.367     0.150
    15.892   226.953     0.150
    16.333   233.234     0.150
    21.022   283.992     0.150
    21.133   285.164     0.150
    21.207   286.078     0.150
    22.305   296.656     0.150
    23.213   307.523     0.150
    23.280   307.734     0.150
    24.455   317.812     0.150
    44.031   487.188     0.150
    44.376   487.133     0.150
    52.957   554.336     0.150
    54.163   563.336     0.150
    56.227   577.453     0.150
    56.621   580.875     0.150
    80.810   732.688     0.150
    85.054   753.602     0.150
    85.304   754.984     0.150
    85.304   755.086     0.150
    90.788   781.109     0.150
    92.969   791.586     0.150
   125.185  1139.398     0.150
   126.092  1140.883     0.150
   132.769  1155.461     0.150
   136.748  1162.383     0.150
     1.102    19.633     0.150
     1.102    32.805     0.150
     1.529    26.602     0.150
     1.529    45.195     0.150
     1.762    29.531     0.150
     1.762    52.234     0.150
     1.801    30.172     0.150
     1.801    51.625     0.150
     2.367    37.234     0.150
     2.367    63.773     0.150
     2.315    37.914     0.150
     2.785    42.977     0.150
     2.785    75.445     0.150
     2.795    42.883     0.150
     2.795    74.734     0.150
     2.775    43.367     0.150
     2.775    74.953     0.150
     2.844    45.555     0.150
     3.075    47.797     0.150
     3.157    48.977     0.150
     3.215    50.164     0.150
     3.240    50.102     0.150
     3.240    87.781     0.150
     3.257    54.242     0.150
     3.257   101.297     0.150
     3.257    49.234     0.150
     3.268    54.516     0.150
     3.356    53.766     0.150
     3.367    52.844     0.150
     3.408    52.453     0.150
     3.689    56.422     0.150
     3.689    58.438     0.150
     3.750    56.734     0.150
     4.490   115.836     0.150
     4.513    67.727     0.150
     4.840    73.234     0.150
     5.543    83.164     0.150
     5.543   144.523     0.150
     5.550    83.078     0.150
     7.273   106.164     0.150
    11.107   161.086     0.150
    11.107   161.188     0.150
    14.016   201.227     0.150
    14.031   202.258     0.150
    14.791   209.922     0.150
    16.643   235.086     0.150
    18.958   261.141     0.150
    19.625   266.562     0.150
    20.543   275.977     0.150
    20.884   294.594     0.150
    21.923   292.195     0.150
    22.263   295.344     0.150
    23.378   305.578     0.150
    24.359   315.781     0.150
    24.430   316.484     0.150
    24.998   320.742     0.150
    25.194   320.484     0.150
    44.968   491.336     0.150
    44.968    12.820     0.150
    44.968    18.680     0.150
    45.025   488.938     0.150
    45.025   489.078     0.150
    45.025    12.203     0.150
    45.025    19.453     0.150
    45.025   591.727     0.150
    53.752   556.938     0.150
    53.752    13.820     0.150
    53.752    19.172     0.150
    55.132   567.688     0.150
    55.132    13.000     0.150
    55.132    19.047     0.150
    55.132   628.836     0.150
    77.880   712.297     0.150
    77.880    14.367     0.150
    85.084   750.727     0.150
    85.084    20.164     0.150
   126.554  1138.867     0.150
   126.554  1152.766     0.150
   144.560  1170.734     0.150
     0.820    15.750     0.150
     0.820    26.008     0.150
     1.853    30.969     0.150
     1.853    52.930     0.150
     2.090    33.906     0.150
     2.090    58.062     0.150
     1.991    34.750     0.150
     1.991    60.727     0.150
     2.115    35.711     0.150
     2.115    62.047     0.150
     2.520    40.812     0.150
     2.672    43.297     0.150
     2.672    74.219     0.150
     2.668    42.469     0.150
     2.668    74.719     0.150
     3.071    46.898     0.150
     3.140    49.750     0.150
     3.184    50.562     0.150
     3.252    51.961     0.150
     3.252    53.219     0.150
     3.252    90.477     0.150
     3.287    56.242     0.150
     3.333    55.969     0.150
     3.397    52.445     0.150
     3.642    57.328     0.150
     3.642    55.156     0.150
     3.642   102.727     0.150
     3.753    58.406     0.150
     4.764    73.125     0.150
     5.345    81.047     0.150
     5.345   142.172     0.150
     5.353    81.219     0.150
     7.091   104.977     0.150
     7.091   182.422     0.150
    11.447   168.891     0.150
    11.447   166.469     0.150
    11.447   360.891     0.150
    17.049   237.867     0.150
    19.315   267.539     0.150
    19.967   272.078     0.150
    20.901   283.859     0.150
    21.236   285.281     0.150
    21.614   290.031     0.150
    22.280   297.172     0.150
    22.618   301.430     0.150
    22.792   302.656     0.150
    24.009   314.992     0.150
    24.785   322.938     0.150
    25.355   327.766     0.150
    25.355   328.039     0.150
    25.544   327.469     0.150
    25.544   327.859     0.150
    27.561   346.250     0.150
    28.691   355.859     0.150
    32.614   390.258     0.150
    33.046   391.000     0.150
    45.324   498.500     0.150
    45.369   495.422     0.150
    45.369   596.117     0.150
    51.249   541.297     0.150
    54.104   563.188     0.150
    54.104   563.695     0.150
    55.489   574.070     0.150
    55.489   633.820     0.150
    65.362   642.109     0.150
    78.174   718.047     0.150
    84.226   749.172     0.150
    85.357   756.281     0.150
   126.630  1143.297     0.150
   127.446  1144.570     0.150
   144.890  1175.719     0.150
     1.287    24.070     0.150
     1.287    40.469     0.150
     1.437    25.648     0.150
     1.437    42.758     0.150
     1.639    29.008     0.150
     2.141    37.352     0.150
     2.141    61.852     0.150
     2.323    38.156     0.150
     2.323    66.438     0.150
     2.461    39.719     0.150
     2.461    70.188     0.150
     2.707    43.625     0.150
     2.707    75.586     0.150
     3.137    49.875     0.150
     3.137    85.719     0.150
     3.199    51.141     0.150
     3.199    86.727     0.150
     3.494    56.875     0.150
     3.640    58.102     0.150
     3.678    57.508     0.150
     3.678    58.570     0.150
     3.678   101.336     0.150
     3.678   102.508     0.150
     3.684    57.469     0.150
     3.792    59.055     0.150
     3.824   107.781     0.150
     4.055    63.570     0.150
     4.055   111.734     0.150
     4.115    65.055     0.150
     4.115    65.305     0.150
     4.115    65.945     0.150
     4.115   111.734     0.150
     4.115   114.117     0.150
     4.115   114.359     0.150
     4.357    71.469     0.150
     4.357   116.586     0.150
     4.850    74.438     0.150
     4.850   132.125     0.150
     5.266    79.805     0.150
     5.266   139.617     0.150
     5.368    81.281     0.150
     5.368   144.516     0.150
     5.941    90.711     0.150
     5.941   160.578     0.150
     5.949    89.750     0.150
     5.949   160.047     0.150
     6.015    87.477     0.150
     7.679   113.719     0.150
    11.150   162.914     0.150
    11.150   163.133     0.150
    11.150   346.938     0.150
    11.433   167.281     0.150
    12.557   182.617     0.150
    13.373   191.461     0.150
    14.049   200.352     0.150
    14.077   202.234     0.150
    14.839   211.219     0.150
    15.800   224.352     0.150
    16.280   230.570     0.150
    16.361   232.141     0.150
    16.437   232.398     0.150
    16.623   235.234     0.150
    17.025   240.234     0.150
    17.025   239.805     0.150
    18.301   253.617     0.150
    18.869   263.031     0.150
    19.018   262.008     0.150
    19.069   266.664     0.150
    19.652   270.391     0.150
    19.628   272.656     0.150
    20.067   276.227     0.150
    20.228   272.352     0.150
    20.459   279.352     0.150
    20.521   280.039     0.150
    20.554   275.602     0.150
    20.761   279.336     0.150
    20.855   282.836     0.150
    20.981   284.688     0.150
    21.094   285.906     0.150
    21.301   283.852     0.150
    21.565   287.188     0.150
    21.663   289.008     0.150
    21.698   291.430     0.150
    21.850   292.898     0.150
    21.853   293.625     0.150
    22.277   293.781     0.150
    22.294   293.406     0.150
    22.260   298.906     0.150
    22.552   296.859     0.150
    22.432   300.828     0.150
    22.860   301.641     0.150
    23.083   302.078     0.150
    23.065   306.180     0.150
    23.138   306.938     0.150
    23.183   304.266     0.150
    23.331   308.008     0.150
    23.485   310.898     0.150
    23.560   310.586     0.150
    23.584   310.906     0.150
    23.576   311.938     0.150
    23.690   308.336     0.150
    23.727   312.914     0.150
    23.794   309.516     0.150
    24.211   317.359     0.150
    24.245   317.961     0.150
    24.281   318.930     0.150
    24.496   318.367     0.150
    24.531   319.258     0.150
    24.684   317.445     0.150
    25.024   323.938     0.150
    25.083   322.320     0.150
    25.041   324.039     0.150
    25.182   324.711     0.150
    25.182   538.055     0.150
    25.417   327.727     0.150
    25.671   331.609     0.150
    25.904   330.047     0.150
    26.402   337.641     0.150
    26.579   339.531     0.150
    27.292   343.945     0.150
    27.359   341.664     0.150
    27.545   347.078     0.150
    27.673   347.164     0.150
    27.892   347.781     0.150
    28.318   353.156     0.150
    28.601   355.930     0.150
    29.930   366.984     0.150
    29.876   369.688     0.150
    30.115   374.031     0.150
    30.414   368.578     0.150
    30.916   379.578     0.150
    31.489   385.914     0.150
    32.200   389.109     0.150
    32.502   387.406     0.150
    32.502   387.227     0.150
    33.075   396.250     0.150
    33.126   392.281     0.150
    41.055   460.445     0.150
    44.897   495.680     0.150
    45.045   493.305     0.150
    45.045   595.156     0.150
    45.045   826.453     0.150
    45.111   493.617     0.150
    45.770   498.281     0.150
    45.770   498.086     0.150
    48.384   523.031     0.150
    48.384   522.281     0.150
    52.380   554.047     0.150
    53.728   560.008     0.150
    53.728   560.164     0.150
    54.438   566.609     0.150
    55.051   571.055     0.150
    55.051   632.258     0.150
    55.445   572.945     0.150
    55.445   574.211     0.150
    56.620   582.805     0.150
    56.712   579.891     0.150
    58.140   591.625     0.150
    58.066  1086.406     0.150
    62.540   623.758     0.150
    62.540   623.414     0.150
    66.297   645.805     0.150
    66.297   645.602     0.150
    69.875   671.078     0.150
    69.875     8.555     0.150
    73.575   693.508     0.150
    76.892   711.039     0.150
    80.525     7.703     0.150
    80.525  1333.406     0.150
    80.525  1343.711     0.150
    80.525  1378.711     0.150
    80.525  1644.305     0.150
    80.673   732.859     0.150
    80.937   733.789     0.150
    81.041   733.727     0.150
    81.574   737.438     0.150
    81.620   738.508     0.150
    81.849   737.578     0.150
    81.967   740.109     0.150
    81.993   740.211     0.150
    82.027   740.305     0.150
    82.074   738.789     0.150
    82.331   742.008     0.150
    82.375   741.805     0.150
    82.375   741.055     0.150
    82.496   741.211     0.150
    82.535   742.609     0.150
    82.518   742.797     0.150
    82.518   743.406     0.150
    82.580   742.109     0.150
    82.590   742.906     0.150
    82.839   744.508     0.150
    83.023   744.109     0.150
    83.150   744.234     0.150
    83.277   746.266     0.150
    83.295   745.008     0.150
    83.303   747.508     0.150
    83.818   749.016     0.150
    84.313   751.008     0.150
    84.412   752.609     0.150
    84.696   753.906     0.150
    84.718   753.805     0.150
    84.718     8.172     0.150
    84.871   754.547     0.150
    85.212   756.797     0.150
    85.212   756.289     0.150
    85.212     9.422     0.150
    85.274   756.008     0.150
    85.308   756.211     0.150
    85.308   755.906     0.150
    85.408   757.508     0.150
    85.692   758.617     0.150
    85.541   760.906     0.150
    85.849   759.180     0.150
    85.849     8.430     0.150
    85.915   760.664     0.150
    85.915     8.695     0.150
    85.957   759.406     0.150
    86.192   760.977     0.150
    86.192     9.383     0.150
    86.220   761.734     0.150
    86.220     9.750     0.150
    86.312   762.109     0.150
    86.312     8.688     0.150
    86.490   762.109     0.150
    86.502   762.375     0.150
    86.502     9.227     0.150
    86.603   762.406     0.150
    86.735   763.008     0.150
    86.824   763.289     0.150
    86.854   765.305     0.150
    86.951   764.625     0.150
    86.983   765.039     0.150
    87.035   764.305     0.150
    87.054   764.805     0.150
    87.078   764.008     0.150
    87.332   765.609     0.150
    87.330   766.961     0.150
    87.476   766.711     0.150
    87.481   767.406     0.150
    87.542   766.609     0.150
    87.557   766.305     0.150
    87.677   767.508     0.150
    87.891   768.711     0.150
    87.923   768.305     0.150
    88.202   770.305     0.150
    88.886   773.305     0.150
    88.992   774.508     0.150
    89.198   775.211     0.150
    89.261   775.008     0.150
    89.275   774.211     0.150
    89.339   775.609     0.150
    89.947   778.211     0.150
    89.971   777.828     0.150
    89.971   779.109     0.150
    90.158   778.805     0.150
    90.245   779.508     0.150
    90.515   778.711     0.150
    90.601   781.406     0.150
    90.685   781.805     0.150
    90.888   782.930     0.150
    90.941   783.305     0.150
    90.941   783.305     0.150
    91.038   783.805     0.150
    91.048   783.305     0.150
    91.414   785.109     0.150
    91.835   787.406     0.150
    92.481   790.586     0.150
    92.481     9.320     0.150
    92.481   789.711     0.150
    92.481     9.594     0.150
    93.034   792.211     0.150
    94.119   797.719     0.150
    94.366   798.156     0.150
    95.018   803.406     0.150
    95.022   802.805     0.150
    95.021   802.406     0.150
    95.021     9.305     0.150
    95.908   807.711     0.150
    96.711   810.711     0.150
    96.711   809.688     0.150
    96.951   811.109     0.150
    98.364   815.305     0.150
    99.291   820.008     0.150
    99.291  1060.406     0.150
   108.071  1107.664     0.150
   110.610   873.508     0.150
   113.153  1115.008     0.150
   115.189  1119.680     0.150
   115.189  1755.883     0.150
   115.283  1119.305     0.150
   115.283  2135.711     0.150
   116.049  1121.305     0.150
   116.049  1189.508     0.150
   116.049  1546.508     0.150
   117.579  1124.609     0.150
   120.424  1129.508     0.150
   120.771  1132.109     0.150
   126.117  1142.609     0.150
   126.117  1142.250     0.150
   126.128  1142.539     0.150
   126.974  1144.258     0.150
   130.541  1150.508     0.150
   133.430  1154.211     0.150
   133.650  1154.305     0.150
   133.843  1157.211     0.150
   133.856  1155.508     0.150
   133.919  1155.508     0.150
   142.243  1168.305     0.150
   144.622  1174.508     0.150
   144.622  1183.508     0.150
   144.639  1174.008     0.150
   146.555  1181.281     0.150
   147.534  1183.125     0.150
     1.211    19.340     0.150
     1.719    50.039     0.150
     1.983    29.949     0.150
     1.983    57.719     0.150
     2.538    39.211     0.150
     2.538    71.641     0.150
     2.728    43.668     0.150
     3.230    47.598     0.150
     3.230    86.180     0.150
     3.656    53.809     0.150
     3.656    95.777     0.150
     3.833    57.438     0.150
     3.833   104.500     0.150
     4.139    63.078     0.150
     4.139   112.629     0.150
     4.225    65.320     0.150
     4.285    63.980     0.150
     4.285   118.438     0.150
     4.310    65.000     0.150
     4.310   113.750     0.150
     4.323    64.867     0.150
     4.323    67.039     0.150
     4.323   117.219     0.150
     4.466    66.777     0.150
     4.466   121.238     0.150
     4.760    69.789     0.150
     4.760    70.910     0.150
     4.760    72.828     0.150
     4.760   128.598     0.150
     4.760   129.980     0.150
     4.760   132.129     0.150
     4.851    72.430     0.150
     4.851   124.699     0.150
     5.861    83.000     0.150
     5.861   149.750     0.150
     5.908    86.848     0.150
     6.529    96.211     0.150
     6.529   168.688     0.150
     6.537    96.141     0.150
     6.537   172.277     0.150
     8.277   119.891     0.150
     8.277   214.840     0.150
     8.799   126.551     0.150
    11.308   161.949     0.150
    11.308   162.465     0.150
    11.308   352.840     0.150
    12.898   182.578     0.150
    13.826   194.000     0.150
    14.185   201.320     0.150
    14.232   201.559     0.150
    14.573   202.590     0.150
    14.996   211.340     0.150
    15.710   222.438     0.150
    16.348   230.301     0.150
    16.419   230.930     0.150
    16.507   231.668     0.150
    16.678   233.219     0.150
    17.105   239.340     0.150
    17.105   239.020     0.150
    17.220   237.219     0.150
    18.733   255.090     0.150
    18.816   260.129     0.150
    19.469   263.527     0.150
    19.422   267.039     0.150
    19.538   267.781     0.150
    19.774   268.648     0.150
    20.273   275.508     0.150
    20.726   276.578     0.150
    20.917   279.410     0.150
    21.098   280.910     0.150
    21.538   286.379     0.150
    21.809   288.238     0.150
    21.824   290.660     0.150
    21.817   291.309     0.150
    21.926   291.469     0.150
    22.140   293.090     0.150
    22.076   293.910     0.150
    22.648   297.277     0.150
    22.705   297.668     0.150
    22.791   297.688     0.150
    22.993   300.020     0.150
    23.061   303.980     0.150
    23.123   305.168     0.150
    23.216   302.398     0.150
    23.321   304.270     0.150
    23.338   306.480     0.150
    23.345   307.230     0.150
    23.565   309.051     0.150
    23.619   307.438     0.150
    23.651   306.098     0.150
    24.129   315.664     0.150
    24.228   312.648     0.150
    24.231   312.891     0.150
    24.271   313.758     0.150
    24.294   316.078     0.150
    24.543   317.758     0.150
    25.015   322.418     0.150
    25.241   323.598     0.150
    25.241   323.641     0.150
    25.241   536.246     0.150
    25.509   328.039     0.150
    25.656   326.250     0.150
    25.654   329.617     0.150
    25.771   327.559     0.150
    26.070   331.430     0.150
    26.266   333.488     0.150
    26.241   334.391     0.150
    26.393   335.270     0.150
    27.122   341.719     0.150
    27.291   340.320     0.150
    27.587   343.270     0.150
    27.586   346.188     0.150
    27.573   345.359     0.150
    27.707   344.508     0.150
    27.886   346.348     0.150
    27.907   345.988     0.150
    27.832   348.641     0.150
    27.893   349.000     0.150
    28.641   354.848     0.150
    28.814   355.645     0.150
    29.469   362.328     0.150
    29.563   361.188     0.150
    29.779   362.570     0.150
    29.957   366.309     0.150
    30.293   371.660     0.150
    30.405   369.609     0.150
    30.615   375.680     0.150
    30.919   372.469     0.150
    31.409   380.711     0.150
    31.560   378.211     0.150
    31.662   383.910     0.150
    31.833   385.609     0.150
    32.001   387.711     0.150
    32.037   387.551     0.150
    32.098   387.199     0.150
    32.330   389.141     0.150
    32.425   388.570     0.150
    32.561   390.309     0.150
    32.609   390.828     0.150
    32.776   389.312     0.150
    33.019   394.969     0.150
    33.607   396.266     0.150
    33.648   396.590     0.150
    33.743   399.961     0.150
    34.228   401.949     0.150
    34.413   406.520     0.150
    35.485   414.125     0.150
    35.485   414.980     0.150
    35.724   414.660     0.150
    35.748   414.609     0.150
    35.766   417.020     0.150
    36.209   418.527     0.150
    44.859   493.359     0.150
    45.144   493.383     0.150
    45.211   493.641     0.150
    46.225   501.613     0.150
    48.717   523.363     0.150
    48.717    11.102     0.150
    48.717   522.730     0.150
    48.717    10.137     0.150
    52.077   548.117     0.150
    53.760   559.828     0.150
    53.880   561.359     0.150
    53.991   562.738     0.150
    54.004   562.340     0.150
    54.947   569.051     0.150
    54.996   569.160     0.150
    54.996   569.418     0.150
    55.388   572.340     0.150
    55.388   571.641     0.150
    56.495   579.641     0.150
    56.921   581.219     0.150
    61.933   617.039     0.150
    62.865   623.914     0.150
    62.865    11.102     0.150
    62.865   622.777     0.150
    64.071   631.699     0.150
    64.071    10.559     0.150
    70.377   671.738     0.150
    71.450   677.840     0.150
    73.499   691.039     0.150
    73.499   705.738     0.150
    79.485   724.039     0.150
    80.442  1345.039     0.150
    82.370   740.738     0.150
    82.370   740.051     0.150
    82.966   742.980     0.150
    83.179   743.641     0.150
    83.841   747.539     0.150
    84.855   753.238     0.150
    84.952   754.039     0.150
    85.236   755.039     0.150
    85.619   756.613     0.150
    85.746   757.438     0.150
    85.746   757.164     0.150
    85.746     9.801     0.150
    85.803   758.152     0.150
    85.803     8.051     0.150
    85.960   758.539     0.150
    87.061   764.438     0.150
    87.162   763.840     0.150
    87.260   765.938     0.150
    87.584   766.438     0.150
    87.623   766.840     0.150
    88.219   769.840     0.150
    89.419   775.141     0.150
    89.880   776.840     0.150
    89.906   776.738     0.150
    91.287   782.641     0.150
    91.287    12.625     0.150
    91.454   784.539     0.150
    91.454   784.539     0.150
    91.860   786.141     0.150
    92.334   788.340     0.150
    93.062   792.938     0.150
    93.133   791.738     0.150
    93.283   792.027     0.150
    93.637   794.141     0.150
    93.889   795.840     0.150
    95.147   801.539     0.150
    95.529   804.840     0.150
    96.300   807.141     0.150
    97.212   811.840     0.150
    99.692   821.141     0.150
    99.692  1063.641     0.150
   125.473  1138.738     0.150
   125.485  1138.949     0.150
   125.485  1149.598     0.150
   126.329  1140.391     0.150
   126.329  1151.590     0.150
   137.598  1163.141     0.150
   144.773  1174.039     0.150
     1.276    21.484     0.150
     1.276    21.211     0.150
     1.276    37.867     0.150
     1.603    25.984     0.150
     1.603    46.984     0.150
     2.057    33.297     0.150
     2.057    59.594     0.150
     2.057    61.594     0.150
     2.267    35.391     0.150
     2.267    63.094     0.150
     2.477    38.062     0.150
     2.477    65.633     0.150
     2.681    71.523     0.150
     2.681    43.273     0.150
     3.111    46.195     0.150
     3.111    80.867     0.150
     3.137    46.828     0.150
     3.137    84.688     0.150
     3.137    48.805     0.150
     3.137    85.016     0.150
     3.420    52.352     0.150
     3.420    92.555     0.150
     3.420    55.742     0.150
     3.507    54.227     0.150
     3.569    55.211     0.150
     3.569    95.812     0.150
     3.598    55.234     0.150
     3.598    95.984     0.150
     3.598    56.344     0.150
     3.598    99.242     0.150
     3.604    55.727     0.150
     3.604    55.984     0.150
     3.604    95.055     0.150
     3.608    54.555     0.150
     3.608    97.312     0.150
     3.608    57.516     0.150
     3.748    57.734     0.150
     3.748   100.594     0.150
     3.748    60.312     0.150
     4.045    61.367     0.150
     4.045    62.164     0.150
     4.045    64.047     0.150
     4.045   108.391     0.150
     4.045   109.016     0.150
     4.045   109.312     0.150
     4.532    66.945     0.150
     4.532   120.094     0.150
     4.532    70.406     0.150
     4.532   123.922     0.150
     5.301    77.656     0.150
     5.301   139.883     0.150
     5.895    85.477     0.150
     5.903    89.023     0.150
     5.903   155.625     0.150
     5.903    87.984     0.150
     7.630   109.484     0.150
    11.093   161.383     0.150
    24.257   315.383     0.150
    44.858   491.031     0.150
    44.991   489.680     0.150
    44.991   591.383     0.150
    53.682   557.031     0.150
    55.014   567.938     0.150
    62.542   619.062     0.150
   126.197  1138.516     0.150
   127.046  1140.586     0.150
     1.279    22.072     0.150
     1.279    40.292     0.150
     1.548    25.452     0.150
     1.548    43.082     0.150
     1.680    28.812     0.150
     2.311    39.393     0.150
     2.311    68.843     0.150
     2.407    40.112     0.150
     2.390    39.452     0.150
     2.390    65.252     0.150
     2.390    40.872     0.150
     2.812    41.962     0.150
     2.812    75.973     0.150
     3.242    50.522     0.150
     3.242    83.322     0.150
     3.750    57.662     0.150
     3.808    62.473     0.150
     3.832    59.062     0.150
     3.832   104.093     0.150
     3.849    58.812     0.150
     3.849    59.112     0.150
     3.849    62.973     0.150
     3.849   105.303     0.150
     3.849   116.723     0.150
     3.969    66.122     0.150
     3.969   116.982     0.150
     3.997    67.683     0.150
     4.282    65.593     0.150
     4.282    66.562     0.150
     4.282   113.782     0.150
     4.522    69.553     0.150
     4.697    72.832     0.150
     4.697   131.272     0.150
     5.429    81.032     0.150
     5.532    84.022     0.150
     6.075    91.082     0.150
     6.075   154.803     0.150
     6.083    92.002     0.150
     6.461    95.952     0.150
     6.461   170.692     0.150
     6.997   182.902     0.150
     7.296   107.473     0.150
     7.818   114.672     0.150
     7.818   199.952     0.150
    10.550   152.172     0.150
    10.550   267.843     0.150
    11.231   162.438     0.150
    11.231   351.726     0.150
    13.522   192.382     0.150
    13.740   197.272     0.150
    14.125   202.902     0.150
    14.158   203.853     0.150
    14.920   212.223     0.150
    15.818   223.582     0.150
    16.339   231.143     0.150
    16.418   232.482     0.150
    17.028   236.263     0.150
    17.088   240.412     0.150
    19.048   263.232     0.150
    19.167   262.832     0.150
    19.614   269.973     0.150
    20.069   275.252     0.150
    20.413   278.122     0.150
    20.575   279.002     0.150
    20.869   280.433     0.150
    20.908   282.082     0.150
    20.962   284.252     0.150
    21.219   285.263     0.150
    21.461   285.312     0.150
    21.461   530.272     0.150
    21.687   289.053     0.150
    21.773   291.362     0.150
    21.817   291.232     0.150
    21.884   293.452     0.150
    21.961   293.632     0.150
    22.197   294.822     0.150
    22.247   298.672     0.150
    22.421   296.482     0.150
    22.452   295.172     0.150
    22.699   298.553     0.150
    22.851   299.872     0.150
    23.011   302.382     0.150
    23.107   306.473     0.150
    23.177   307.242     0.150
    23.177   534.803     0.150
    23.329   306.232     0.150
    23.376   308.782     0.150
    23.490   310.122     0.150
    23.571   311.162     0.150
    23.604   310.772     0.150
    23.770   312.692     0.150
    23.855   310.112     0.150
    23.949   311.992     0.150
    24.077   315.492     0.150
    24.225   317.612     0.150
    24.283   318.263     0.150
    24.577   319.853     0.150
    24.577   537.303     0.150
    24.709   321.242     0.150
    24.841   319.422     0.150
    24.841   537.593     0.150
    25.032   323.973     0.150
    25.065   324.332     0.150
    25.156   321.843     0.150
    25.253   323.742     0.150
    25.240   324.162     0.150
    25.240   538.662     0.150
    25.450   325.212     0.150
    25.432   328.272     0.150
    25.560   328.303     0.150
    25.670   330.982     0.150
    25.739   331.343     0.150
    25.989   331.822     0.150
    26.219   334.452     0.150
    26.275   335.202     0.150
    26.402   337.362     0.150
    26.571   338.692     0.150
    26.592   338.853     0.150
    27.179   343.593     0.150
    27.328   341.832     0.150
    27.510   343.812     0.150
    27.526   343.622     0.150
    27.599   347.482     0.150
    27.923   350.632     0.150
    28.051   348.962     0.150
    28.037   349.442     0.150
    28.372   353.853     0.150
    28.872   359.532     0.150
    28.978   358.604     0.150
    28.978   358.362     0.150
    29.416   360.482     0.150
    29.431   364.252     0.150
    29.478   363.263     0.150
    29.757   366.172     0.150
    29.980   367.492     0.150
    29.951   370.843     0.150
    30.061   365.622     0.150
    30.065   368.192     0.150
    30.033   372.702     0.150
    30.094   370.362     0.150
    30.217   373.902     0.150
    30.519   372.812     0.150
    30.631   375.382     0.150
    30.980   373.742     0.150
    30.963   381.000     0.150
    30.963   381.172     0.150
    31.016   379.132     0.150
    31.195   376.683     0.150
    31.241   382.183     0.150
    31.272   379.162     0.150
    31.279   379.792     0.150
    31.433   381.502     0.150
    31.596   386.062     0.150
    31.745   381.343     0.150
    32.149   386.252     0.150
    32.215   388.022     0.150
    32.215   556.002     0.150
    32.240   387.912     0.150
    32.613   388.987     0.150
    32.613   556.013     0.150
    32.613   388.343     0.150
    32.613   556.372     0.150
    32.629   392.522     0.150
    32.645   391.942     0.150
    32.885   394.492     0.150
    32.900   394.582     0.150
    33.104   395.402     0.150
    33.117   396.202     0.150
    33.286   394.732     0.150
    33.598   399.532     0.150
    33.773   401.122     0.150
    33.834   402.143     0.150
    34.035   403.522     0.150
    34.292   406.652     0.150
    34.532   407.952     0.150
    34.720   410.062     0.150
    34.725   409.692     0.150
    35.008   411.047     0.150
    35.361   411.792     0.150
    35.392   412.103     0.150
    35.677   414.822     0.150
    35.787   419.462     0.150
    36.598   423.782     0.150
    44.930   495.402     0.150
    45.114   493.607     0.150
    45.114   594.857     0.150
    45.180   494.482     0.150
    45.920   499.962     0.150
    45.920   499.792     0.150
    45.920   607.212     0.150
    48.432   522.438     0.150
    48.432   522.843     0.150
    52.145   549.803     0.150
    52.410   554.502     0.150
    53.243   559.412     0.150
    53.780   560.872     0.150
    53.917   563.212     0.150
    54.111   564.612     0.150
    54.120   564.132     0.150
    54.455   566.513     0.150
    55.080   571.162     0.150
    55.080   632.013     0.150
    55.212   572.412     0.150
    55.474   572.612     0.150
    55.474   573.272     0.150
    55.474   634.172     0.150
    56.631   581.212     0.150
    56.808   581.473     0.150
    58.168   591.912     0.150
    62.054   620.312     0.150
    62.587   623.138     0.150
    62.587   623.442     0.150
    63.375   628.752     0.150
    63.700   630.542     0.150
    65.353   640.752     0.150
    67.838   658.152     0.150
    71.247   676.912     0.150
    73.599   693.112     0.150
    73.599   692.772     0.150
    77.008   711.822     0.150
    78.145   718.553     0.150
    79.069   721.513     0.150
    79.131   721.812     0.150
    79.512   723.712     0.150
    80.538   732.513     0.150
    80.538     7.100     0.150
    80.538   915.412     0.150
    80.538  1327.712     0.150
    80.538  1340.013     0.150
    80.654   732.013     0.150
    80.654  1334.212     0.150
    80.779   732.382     0.150
    80.791   733.683     0.150
    80.799   732.362     0.150
    81.108   735.242     0.150
    81.213   736.132     0.150
    81.746   737.723     0.150
    82.020   739.072     0.150
    82.020     7.370     0.150
    82.140   740.712     0.150
    82.165   740.112     0.150
    82.200   740.612     0.150
    82.246   741.553     0.150
    82.246     6.060     0.150
    82.246     7.109     0.150
    82.503   743.212     0.150
    82.505   742.513     0.150
    82.548   742.612     0.150
    82.522   741.812     0.150
    82.668   742.312     0.150
    82.706   744.013     0.150
    82.753   743.612     0.150
    82.763   743.712     0.150
    82.983   744.712     0.150
    83.013   745.212     0.150
    83.190   745.112     0.150
    83.321   746.093     0.150
    83.433   746.452     0.150
    83.450   746.643     0.150
    83.462   747.312     0.150
    83.894   748.212     0.150
    83.894     9.000     0.150
    83.894  1371.912     0.150
    83.894   748.032     0.150
    83.992   749.433     0.150
    84.479   752.912     0.150
    84.570   751.992     0.150
    84.578   753.513     0.150
    84.861   754.812     0.150
    84.892   754.082     0.150
    84.925   755.172     0.150
    85.237   757.002     0.150
    85.320   757.353     0.150
    85.385   756.851     0.150
    85.385   756.952     0.150
    85.385   757.382     0.150
    85.402   756.287     0.150
    85.402   756.473     0.150
    85.425   756.763     0.150
    85.433   757.522     0.150
    85.433     8.460     0.150
    85.455   757.013     0.150
    85.455   756.638     0.150
    85.576   758.312     0.150
    85.865   759.803     0.150
    85.896   759.263     0.150
    86.022   760.452     0.150
    86.089   760.992     0.150
    86.364   762.053     0.150
    86.394   762.572     0.150
    86.486   762.982     0.150
    86.660   763.612     0.150
    86.676   763.862     0.150
    86.772   763.412     0.150
    86.806   765.212     0.150
    86.899   763.912     0.150
    87.027   765.952     0.150
    87.064   766.312     0.150
    87.139   765.013     0.150
    87.154   765.832     0.150
    87.202   765.112     0.150
    87.224   765.812     0.150
    87.241   765.712     0.150
    87.307   767.412     0.150
    87.498   766.312     0.150
    87.503   767.792     0.150
    87.556   767.470     0.150
    87.597   767.391     0.150
    87.644   767.212     0.150
    87.652   768.513     0.150
    87.709   767.312     0.150
    87.723   767.013     0.150
    87.764   768.312     0.150
    87.904   769.712     0.150
    87.926   768.513     0.150
    88.018   770.303     0.150
    88.055   769.212     0.150
    88.089   768.812     0.150
    88.205   769.893     0.150
    88.228   770.612     0.150
    88.290   770.812     0.150
    88.370   770.172     0.150
    88.371   770.912     0.150
    88.462   771.612     0.150
    88.523   771.912     0.150
    89.051   773.812     0.150
    89.161   775.013     0.150
    89.366   775.612     0.150
    89.425   775.513     0.150
    89.439   775.312     0.150
    89.505   776.013     0.150
    89.573   777.013     0.150
    89.592   776.412     0.150
    89.998   778.412     0.150
    89.998   779.312     0.150
    90.087   778.812     0.150
    90.103   779.013     0.150
    90.114   779.112     0.150
    90.326   780.513     0.150
    90.391   780.912     0.150
    90.412   781.212     0.150
    90.464   780.312     0.150
    90.768   782.312     0.150
    90.845   783.112     0.150
    91.027   781.537     0.150
    91.027   996.312     0.150
    91.103   784.612     0.150
    91.103   784.612     0.150
    91.206   783.812     0.150
    91.217   783.912     0.150
    91.261   783.612     0.150
    91.279   784.612     0.150
    91.384   784.513     0.150
    91.501   785.013     0.150
    91.513   786.112     0.150
    91.582   785.513     0.150
    91.594   785.812     0.150
    91.603   785.612     0.150
    91.745   787.153     0.150
    91.994   788.312     0.150
    92.457   790.513     0.150
    92.713   792.013     0.150
    92.790   791.513     0.150
    92.932   792.513     0.150
    92.932   791.775     0.150
    92.932  1010.450     0.150
    93.202   793.013     0.150
    93.299   794.412     0.150
    93.551   795.812     0.150
    94.183   797.922     0.150
    94.524   799.562     0.150
    94.993   802.013     0.150
    95.182   804.013     0.150
    95.657   804.763     0.150
    95.959   806.612     0.150
    95.959     9.100     0.150
    96.068   807.513     0.150
    96.068     9.399     0.150
    96.870   811.412     0.150
    96.870   811.183     0.150
    97.108   811.812     0.150
    97.108   819.412     0.150
    97.108   827.412     0.150
    97.296   811.782     0.150
    98.401   815.912     0.150
    99.431   821.013     0.150
   101.351   831.412     0.150
   101.636   832.355     0.150
   107.979  1127.013     0.150
   108.944  1108.223     0.150
   109.303  1140.332     0.150
   109.716  1110.513     0.150
   110.756  1112.013     0.150
   110.756  1147.412     0.150
   111.624  1113.013     0.150
   115.268  1119.287     0.150
   115.252  1121.912     0.150
   116.024  1120.112     0.150
   116.024  1189.612     0.150
   120.597  1130.587     0.150
   120.998  1132.962     0.150
   125.963  1141.722     0.150
   126.805  1143.062     0.150
   129.662  1148.101     0.150
   137.771  1165.712     0.150
   144.706  1174.612     0.150
   144.706  1183.612     0.150
     2.171    36.008     0.150
     2.486    41.961     0.150
     2.486    73.305     0.150
     2.486    75.445     0.150
     3.312    51.039     0.150
     3.312    88.656     0.150
     3.312    86.867     0.150
     3.741    56.508     0.150
     3.741    97.008     0.150
     3.741    57.008     0.150
     3.767    57.555     0.150
     3.767   101.680     0.150
     4.180    66.008     0.150
     4.180   117.008     0.150
     4.206    64.617     0.150
     4.206   114.305     0.150
     4.206    67.688     0.150
     4.485    70.695     0.150
     4.485   123.852     0.150
     4.485   126.719     0.150
     4.645    73.008     0.150
     5.456   144.945     0.150
     5.558    82.906     0.150
     5.558   148.836     0.150
     6.543    98.516     0.150
     6.550    98.008     0.150
     6.550   174.008     0.150
     8.276   121.961     0.150
     8.276   215.586     0.150
    10.944   158.930     0.150
    13.411   193.617     0.150
    15.392   221.102     0.150
    15.550   217.484     0.150
    15.550   223.430     0.150
    15.995   228.516     0.150
    16.327   230.555     0.150
    16.750   233.180     0.150
    16.750   237.727     0.150
    16.855   234.570     0.150
    19.144   266.227     0.150
    19.144   274.430     0.150
    19.414   268.250     0.150
    19.414   277.711     0.150
    19.618   271.367     0.150
    20.799   279.258     0.150
    20.984   283.734     0.150
    21.484   288.539     0.150
    21.491   286.750     0.150
    22.360   295.227     0.150
    22.468   295.906     0.150
    23.924   311.016     0.150
    23.932   311.156     0.150
    24.515   320.891     0.150
    24.846   320.180     0.150
    24.890   322.406     0.150
    24.890   537.961     0.150
    25.234   323.117     0.150
    25.903   332.305     0.150
    27.585   343.469     0.150
    27.585     8.328     0.150
    27.609   343.477     0.150
    27.609     8.188     0.150
    48.933   527.109     0.150
    53.571   560.375     0.150
    54.642   568.414     0.150
    54.670   568.711     0.150
    54.670   630.961     0.150
    54.687   568.516     0.150
    63.086   627.109     0.150
    66.258   649.109     0.150
    84.553   752.211     0.150
    84.648   753.711     0.150
    84.932   755.008     0.150
    85.257   755.180     0.150
    85.401   756.008     0.150
    85.401   756.656     0.150
    85.536   757.898     0.150
    86.245   761.609     0.150
    86.778   764.508     0.150
    86.870   764.609     0.150
    86.947   765.008     0.150
    87.233   765.211     0.150
    87.286   766.305     0.150
    87.339   766.906     0.150
    87.800   768.609     0.150
    87.915   768.305     0.150
    92.964   791.844     0.150
     1.795    31.484     0.150
     1.795    50.922     0.150
     1.860    31.102     0.150
     1.860    52.695     0.150
     2.200    35.781     0.150
     2.200    60.875     0.150
     2.500    38.820     0.150
     2.500    67.523     0.150
     2.791    43.758     0.150
     2.791    76.500     0.150
     2.870    45.344     0.150
     2.870    78.758     0.150
     2.928    46.352     0.150
     2.928    78.961     0.150
     3.136    49.375     0.150
     3.136    86.383     0.150
     3.288    50.539     0.150
     3.288    90.391     0.150
     3.321    50.852     0.150
     3.321    51.492     0.150
     3.321    52.648     0.150
     3.321    88.648     0.150
     3.321    89.898     0.150
     3.321    91.641     0.150
     3.321    51.789     0.150
     3.321    88.109     0.150
     3.440    53.289     0.150
     3.440    93.094     0.150
     3.464    53.398     0.150
     3.464    90.562     0.150
     3.766    55.953     0.150
     3.766    57.898     0.150
     3.766    58.172     0.150
     3.766    99.672     0.150
     4.517    68.641     0.150
     4.517   117.633     0.150
     4.620    67.414     0.150
     5.659    85.070     0.150
     5.659   148.742     0.150
     5.666    86.758     0.150
     5.666   147.680     0.150
     5.940    88.570     0.150
     5.940   154.445     0.150
    12.347   174.523     0.150
    15.786   219.242     0.150
    15.786   238.891     0.150
    16.177   227.531     0.150
    16.528   230.008     0.150
    16.679   231.328     0.150
    18.012   247.148     0.150
    19.909   267.109     0.150
    20.216   270.523     0.150
    20.978   278.312     0.150
    21.326   283.961     0.150
    21.562   286.891     0.150
    21.843   289.719     0.150
    24.227   315.195     0.150
    24.298   315.922     0.150
    24.369   313.320     0.150
    25.081   320.953     0.150
    25.081   535.203     0.150
    32.288   383.555     0.150
    32.288   552.250     0.150
    32.336   385.984     0.150
    40.847   456.570     0.150
    44.918   489.711     0.150
    44.918    10.836     0.150
    44.918   592.047     0.150
    44.985   490.531     0.150
    47.351   509.375     0.150
    47.351    11.773     0.150
    48.268   518.750     0.150
    48.268    12.148     0.150
    48.268   518.453     0.150
    48.268    11.789     0.150
    48.268    12.445     0.150
    50.929   536.602     0.150
    50.929    12.172     0.150
    53.637   557.102     0.150
    53.637    11.922     0.150
    55.008   567.852     0.150
    55.008    12.047     0.150
    55.008   629.055     0.150
    56.527   577.281     0.150
    57.553   585.672     0.150
    57.553    11.781     0.150
    62.429   619.602     0.150
    62.429    11.828     0.150
    63.413   626.000     0.150
    63.413    13.281     0.150
    65.847   642.977     0.150
    67.794   654.820     0.150
    73.543   688.750     0.150
    73.543    13.359     0.150
    85.021   751.625     0.150
    86.645   761.242     0.150
    86.645    12.422     0.150
    92.444   787.398     0.150
   115.039  1116.578     0.150
   121.133  1127.375     0.150
   126.475  1139.914     0.150
   127.328  1141.703     0.150
   144.463  1170.852     0.150
     0.674    13.531     0.150
     1.266    38.742     0.150
     2.106    34.531     0.150
     2.682    47.461     0.150
     2.887    47.055     0.150
     2.887    81.242     0.150
     3.953    99.570     0.150
     3.953    65.359     0.150
     3.953   110.859     0.150
     4.294    63.484     0.150
     4.294   111.859     0.150
     4.382    67.531     0.150
     4.382   123.531     0.150
     4.351   114.953     0.150
     4.351    67.062     0.150
     4.351   117.711     0.150
     4.503   123.969     0.150
     4.617   125.844     0.150
     4.694    72.039     0.150
     4.694    74.758     0.150
     4.758   124.102     0.150
     4.758    72.523     0.150
     4.758   129.219     0.150
     4.797   126.258     0.150
     5.084   132.891     0.150
     5.051    74.922     0.150
     5.051   136.438     0.150
     5.185    78.578     0.150
     5.185   137.023     0.150
     5.185   139.984     0.150
     6.017    87.133     0.150
     6.017   155.242     0.150
     6.378    92.781     0.150
     7.164   103.844     0.150
     7.171   106.031     0.150
     7.582   111.508     0.150
     7.582   203.133     0.150
     7.967   115.492     0.150
     7.967   118.938     0.150
     8.128   119.781     0.150
     8.889   130.258     0.150
    12.436   179.430     0.150
    13.553   191.930     0.150
    14.913   211.734     0.150
    15.608   219.508     0.150
    15.639   221.219     0.150
    15.639   225.234     0.150
    15.702   222.484     0.150
    15.799   224.078     0.150
    15.959   225.938     0.150
    16.345   228.734     0.150
    16.403   231.258     0.150
    16.403   231.633     0.150
    16.737   233.031     0.150
    18.033   250.750     0.150
    18.591   258.430     0.150
    18.928   260.711     0.150
    19.840   270.875     0.150
    20.272   277.531     0.150
    20.159   272.719     0.150
    20.525   275.531     0.150
    20.543   278.891     0.150
    20.644   279.844     0.150
    20.783   281.531     0.150
    21.154   284.328     0.150
    21.165   286.031     0.150
    21.176   284.633     0.150
    21.251   287.133     0.150
    21.420   284.484     0.150
    21.627   286.688     0.150
    22.074   295.008     0.150
    22.175   297.172     0.150
    22.302   296.758     0.150
    22.359   298.078     0.150
    22.530   300.633     0.150
    22.585   295.930     0.150
    22.577   301.031     0.150
    22.586   299.531     0.150
    22.643   299.078     0.150
    22.806   300.883     0.150
    22.787   301.828     0.150
    22.970   304.320     0.150
    23.073   301.883     0.150
    23.154   304.875     0.150
    23.305   304.633     0.150
    23.292   307.789     0.150
    23.309   308.203     0.150
    23.309   535.445     0.150
    23.606   306.734     0.150
    23.666   311.633     0.150
    23.793   311.484     0.150
    24.026   312.211     0.150
    24.021   314.531     0.150
    24.106   312.258     0.150
    24.253   315.531     0.150
    24.509   319.133     0.150
    24.520   318.328     0.150
    24.520   537.125     0.150
    24.835   322.992     0.150
    25.326   325.055     0.150
    25.406   324.750     0.150
    25.404   326.070     0.150
    25.404   326.109     0.150
    25.430   326.531     0.150
    25.468   326.500     0.150
    25.560   329.898     0.150
    25.565   329.898     0.150
    25.614   328.125     0.150
    25.679   328.031     0.150
    25.858   330.562     0.150
    25.994   331.609     0.150
    26.153   335.062     0.150
    26.354   335.070     0.150
    26.375   336.109     0.150
    26.770   338.633     0.150
    26.770   542.930     0.150
    26.957   341.359     0.150
    27.035   340.328     0.150
    27.144   344.219     0.150
    27.494   344.875     0.150
    27.602   345.844     0.150
    27.597   347.562     0.150
    27.628   346.734     0.150
    27.675   347.969     0.150
    27.861   350.102     0.150
    27.991   349.172     0.150
    27.991   349.031     0.150
    28.398   352.812     0.150
    28.398   545.844     0.150
    28.427   354.750     0.150
    28.639   356.703     0.150
    28.739   357.070     0.150
    28.779   355.781     0.150
    28.867   357.109     0.150
    29.286   360.852     0.150
    29.294   363.633     0.150
    29.417   363.352     0.150
    29.560   364.555     0.150
    29.640   366.219     0.150
    29.697   363.828     0.150
    29.835   366.680     0.150
    29.844   367.531     0.150
    29.855   366.781     0.150
    30.150   370.352     0.150
    30.436   374.711     0.150
    30.302   371.203     0.150
    30.331   370.828     0.150
    30.379   371.555     0.150
    30.408   372.109     0.150
    30.478   373.031     0.150
    30.497   371.812     0.150
    30.507   373.469     0.150
    30.524   374.008     0.150
    30.856   376.641     0.150
    31.102   376.664     0.150
    31.360   383.523     0.150
    31.305   380.273     0.150
    31.574   384.422     0.150
    31.391   380.930     0.150
    31.420   381.383     0.150
    31.420   553.578     0.150
    31.420   380.633     0.150
    31.483   381.562     0.150
    31.538   382.562     0.150
    31.607   383.539     0.150
    31.626   382.234     0.150
    31.639   382.531     0.150
    31.726   383.844     0.150
    31.736   384.852     0.150
    31.775   383.992     0.150
    31.820   384.625     0.150
    31.999   385.828     0.150
    32.369   391.492     0.150
    32.233   388.469     0.150
    32.238   384.781     0.150
    32.238   384.664     0.150
    32.609   393.859     0.150
    32.752   394.875     0.150
    32.845   393.172     0.150
    32.883   392.828     0.150
    32.952   393.820     0.150
    33.145   395.531     0.150
    33.363   393.828     0.150
    33.363   558.734     0.150
    33.363   398.703     0.150
    33.579   399.062     0.150
    33.649   399.930     0.150
    34.695   411.352     0.150
    35.284   412.234     0.150
    35.576   414.078     0.150
    35.960   419.055     0.150
    35.960   419.328     0.150
    36.042   417.570     0.150
    36.081   418.531     0.150
    38.438   441.234     0.150
    39.045   446.141     0.150
    44.446   487.578     0.150
    45.930   499.930     0.150
    48.762   521.938     0.150
    48.762     6.414     0.150
    49.545   530.883     0.150
    49.545   530.430     0.150
    49.545     6.898     0.150
    51.292   980.531     0.150
    51.250   543.805     0.150
    51.300   542.820     0.150
    51.604   544.930     0.150
    51.963   548.234     0.150
    53.017   555.008     0.150
    53.069   556.328     0.150
    53.198   557.430     0.150
    54.319   565.234     0.150
    54.600   566.633     0.150
    54.600   566.523     0.150
    55.659   574.430     0.150
    56.657   581.133     0.150
    57.387  1063.930     0.150
    57.387  1295.430     0.150
    57.291   585.734     0.150
    63.695   631.031     0.150
    63.695     6.797     0.150
    64.848   637.750     0.150
    65.954   643.430     0.150
    70.964   674.328     0.150
    72.702   686.930     0.150
    72.702   686.688     0.150
    74.359   697.508     0.150
    76.653   710.070     0.150
    76.653   710.328     0.150
    76.653   710.594     0.150
    77.795   714.711     0.150