#!/bin/bash
gmt begin caleta1.47_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-67/67/-67/67
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation caleta1.47'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    21.927    21.927
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    26.978    60.593
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    26.978    60.593 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.515    -6.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    28.506    24.780
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    28.506    24.780 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.987    16.186
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.797    48.967
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.797    48.967 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.789    14.558
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    25.375    31.335
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    25.375    31.335 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    29.943    34.446
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    29.943    34.446 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.327    25.648
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.327    25.648 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    21.259    22.014
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    21.259    22.014 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.853     6.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.906    31.217
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.906    31.217 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    24.707    41.119
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    24.707    41.119 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.699    25.088
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.699    25.088 14
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.153    26.362
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.153    26.362 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.540    12.584
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.033    22.457
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.033    22.457 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.508    17.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.620    16.996
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.406    -1.676
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.069     4.213
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.822     2.457
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.841    12.698
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.061    17.668
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.061    17.668 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    25.434     7.776
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    25.434     7.776 25
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.909    -2.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.253    -4.969
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.428    -1.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.455    19.790
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.455    19.790 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    20.482     9.990
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    20.482     9.990 30
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.720   -11.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.704    11.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.299    -5.917
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.472    23.005
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.472    23.005 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.412    18.412
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    18.412    18.412 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.000    19.997
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.040     0.703
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -17.114     4.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.397     0.612
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.929   -10.235
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.176    25.866
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.176    25.866 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.625     4.465
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.103    -2.343
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    18.452     3.587
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.877     2.013
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.821     5.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.832   -10.853
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.869    -5.958
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.017    -6.231
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.474     2.005
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.283    10.306
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.955    -8.581
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.809    15.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.736    -3.444
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.142    -9.301
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.262    -7.505
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.380    -4.515
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.858    -7.061
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.916   -12.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.098    16.602
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.098    16.602 60
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.528    -2.241
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.228    -9.998
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.705     1.261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.612    -3.351
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.097    -6.314
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.892    -6.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.687    -6.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.145    10.227
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.753    11.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.177    -6.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.599     6.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.032   -18.099
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.496     1.069
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.957   -13.680
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.399    -3.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.585    -3.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.097    11.214
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.387    10.340
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.806    -2.812
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.178     1.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.171     1.081
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.592   -10.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.988    -3.561
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.267    -2.552
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.083    -3.946
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.313    -1.206
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.639   -20.221
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.639   -20.221 87
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.090    -1.312
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.004   -13.484
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.677    -7.540
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.015    -0.705
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.598    -1.050
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.967     1.481
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.629    13.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.167    -4.253
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.535    -7.898
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.683    -0.821
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.398    -4.326
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.203    -0.817
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.320    -9.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.566     0.315
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.053     1.622
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.656   -21.688
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.656   -21.688 103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.163    10.305
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.200    -5.376
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.215    -5.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    23.018     5.739
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    23.018     5.739 107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.574    -6.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.565    -9.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -18.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.832   -21.767
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.832   -21.767 111
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.669    -3.422
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.091    -4.697
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.082   -21.685
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.082   -21.685 114
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.117   -11.312
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.772   -14.261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.597   -22.708
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.597   -22.708 117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.754   -15.549
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.588    -7.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.076    -0.106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -18.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.548    -3.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.167    -5.938
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.334   -10.211
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.775   -20.140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.999    -6.305
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.353    -9.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.773    -9.280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.785   -13.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.630   -12.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.120    -7.970
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.357   -14.476
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.837    -5.522
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.281     1.585
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.491     2.690
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.274     1.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.920   -14.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.021   -14.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.686    -7.304
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.471    -3.249
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.675   -10.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.995   -16.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.220     5.808
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.905    -6.844
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.326     2.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.017   -15.521
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.939   -12.519
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.262   -15.007
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.286   -16.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.821   -16.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.592   -16.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.419    -8.344
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.921   -15.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.523   -13.030
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.295    -9.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.386    16.620
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.190   -22.925
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.190   -22.925 157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.026    -1.622
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.798    -9.894
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.044   -20.805
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.344   -12.479
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.178   -12.134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.595    10.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.141   -22.351
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.141   -22.351 164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.043     3.284
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.148    -9.318
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.032    -4.496
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.428    -8.099
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.084    -4.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.629   -13.287
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.617   -11.013
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.325    18.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.990    -8.619
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.551    -4.798
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.739   -14.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.395     0.887
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.377    13.087
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.013   -11.222
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.879    -1.776
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.528    -3.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.873    -8.083
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.434     8.495
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.507     0.367
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.774    -4.616
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.131   -13.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.076   -20.549
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.132    -5.272
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.423    -5.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.201   -11.505
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.649     0.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.740   -12.234
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.774   -13.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.407   -21.512
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.806   -12.450
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.341   -14.949
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.408    -6.409
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.669    -1.912
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.811    -5.259
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.455   -11.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.151    11.459
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.964     0.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.596     5.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.173   -11.620
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.166   -10.452
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.523    -3.042
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.533     6.374
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.266     2.607
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.751    -3.327
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.942    -6.250
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -46.574    -7.377
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -46.574    -7.377 210
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.275    13.633
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.339    -7.867
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.820   -13.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.522    -1.106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.490     6.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.126   -11.184
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.557   -19.686
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -18.780   -14.673
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -18.780   -14.673 218
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.333    -3.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.612    -2.771
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.584     0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.985     2.321
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.948    -6.353
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.339   -12.738
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.779    -5.167
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.578   -16.551
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.423   -19.319
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -26.624   -39.471
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -26.624   -39.471 228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.227    15.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.227   -22.013
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -13.227   -22.013 230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.849   -16.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.591    -8.474
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.381   -15.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.881    -6.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.164     1.754
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.903    -7.976
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.221    12.682
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.036    -5.329
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.413   -10.504
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.209    -7.917
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.990   -11.492
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.000   -19.626
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.000   -19.626 242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.388     3.762
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000   -11.331
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.924     4.160
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.941    -4.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.627    -3.240
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.090   -10.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.677    -0.798
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.972    -0.757
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.579     0.437
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.796    -0.405
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.169     5.105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.538     1.279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.025   -19.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.623     3.745
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.716   -12.287
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.153   -25.532
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -14.153   -25.532 258
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -15.931   -18.985
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -15.931   -18.985 259
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -13.045    -9.477
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.467   -20.749
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.467   -20.749 261
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.547    -7.816
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.393     1.347
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.883    -7.098
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.685    -1.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.167   -20.615
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.645   -15.654
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.255    -5.857
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.716     5.698
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.255    -9.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.427   -12.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.532    -4.861
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.800    -5.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.475   -12.732
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.164     5.043
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.963    -7.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.946   -11.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.107    -6.145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -11.887   -23.330
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -11.887   -23.330 279
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.780     1.763
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.226     2.653
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.481     4.884
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    35.271     0.616
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    35.271     0.616 283
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.005     1.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.528    -9.433
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.017    -3.546
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.051    -4.548
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.642     3.727
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.710   -13.943
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.488    -9.780
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.534    -5.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.396    -4.523
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.459   -11.887
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.271    -5.271
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    20.388   -56.016
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    20.388   -56.016 295
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.335    -6.395
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.603    -2.033
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.847    -3.115
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.406   -11.084
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.275    -3.054
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.947    -2.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.443    -2.443
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.643    -1.445
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.167    -4.775
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.380    -2.396
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.315   -16.472
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.806   -12.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.671    -2.966
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.223    -6.389
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.116    -0.897
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.335   -11.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.796   -14.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.645   -13.608
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.430   -13.603
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.687    -9.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.644    -7.783
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.032    -6.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -14.310    -3.042
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.302     0.987
EOF
gmt plot $proj $reg -SE -Gred << EOF
     1.049    -3.469     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -65.000    65.000 Author: all ( 319 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -65.000   -65.000 Average =   3.6 km at 163.2 deg; median =   11.0 km
EOF
gmt end
