#!/bin/bash
gmt begin caleta1.47_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-45/61/0/26
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya25f5+lCounts -BWeSn+t'Focal Depth Mislocation caleta1.47' << EOF
    39.300
    13.000
    12.000
     6.200
     1.800
    -0.000
    38.700
    -4.400
    -7.000
    13.000
    -7.600
    56.400
    -6.000
    -0.900
    22.000
    26.100
    17.000
     4.700
    16.000
   -35.500
     4.400
     9.800
    17.000
    -9.400
     1.000
   -16.700
    17.000
     8.500
     5.000
    14.000
     4.000
     5.000
     1.000
    22.700
    14.700
    37.100
     4.000
    -1.100
    -0.100
    10.200
    16.800
     6.900
    -5.900
     9.800
     2.000
     5.000
    14.600
     1.500
     2.800
     0.300
    -2.000
    19.400
    17.000
     2.400
     0.100
    -5.800
    -1.300
     1.400
     0.800
     6.300
    10.000
     0.600
    -0.300
     4.600
     3.100
     0.700
    16.900
     7.000
    -2.000
     0.300
     2.700
     5.300
     0.100
   -10.000
    -4.300
     4.100
     9.000
     0.900
     9.100
   -40.400
     1.200
     1.600
     4.300
    -1.300
    -0.400
    -0.400
    22.000
     4.300
     2.500
    10.000
     2.900
     4.300
   -10.000
    11.600
     1.300
     6.000
    -0.000
     1.900
    -0.500
    -3.900
   -11.300
     4.300
    -4.200
   -16.500
   -30.900
    -4.800
     8.100
   -11.800
    12.400
   -13.400
    -8.100
     0.300
     0.600
    -5.000
    15.400
   -15.000
     8.300
     8.600
   -20.000
     2.600
    19.700
    -0.300
   -13.000
     1.500
    27.900
     1.500
    -4.500
    -7.200
    13.600
   -20.600
    -1.000
     6.200
   -10.000
   -20.500
    -6.500
    10.000
    10.200
   -21.900
     5.600
     7.400
    -7.400
     4.500
    -2.100
    -3.500
   -11.000
    17.600
    10.800
   -18.000
    -8.500
    13.400
   -20.000
     7.400
   -13.200
     1.700
   -13.100
   -17.700
     9.000
    -8.200
   -15.800
     6.900
    17.600
   -10.000
    12.200
   -16.000
   -10.600
     7.000
     7.500
     4.400
    -1.600
   -11.200
     7.000
    15.000
   -11.300
   -22.200
     9.300
   -31.900
    -9.900
     3.000
    -2.300
    12.100
    -3.600
     6.500
    -3.200
    -0.000
   -16.800
    -2.000
     4.000
     7.000
    -3.900
   -13.500
     2.300
    -1.000
    17.600
    -2.400
     3.400
    -5.400
    -9.900
     5.100
   -15.000
    -8.400
     3.000
    -8.300
    -7.900
    -7.100
   -16.400
    15.300
   -10.300
    -7.000
     0.500
    -0.000
     4.500
    -0.300
    -4.800
    13.200
   -15.500
    -3.800
    13.700
   -10.000
     1.100
     2.400
   -19.100
     2.800
    -1.500
    -6.700
    -2.500
   -27.100
     1.500
     1.600
    -0.100
    -6.600
   -22.500
     3.000
    13.000
    -7.000
     9.000
   -18.000
   -14.500
    10.000
     4.900
   -11.300
     3.800
    -2.000
     2.000
    -5.700
    -2.700
     1.600
   -10.800
     7.300
    -1.800
    -5.500
    -1.200
    -0.000
   -12.400
     1.100
   -25.800
    -0.700
   -18.500
     5.800
   -36.200
     3.000
    -3.800
     4.400
    10.000
     0.900
    -3.600
   -15.100
    -5.000
     5.400
     8.500
   -13.600
   -20.000
    -2.800
    -1.100
   -27.000
     2.000
    -7.700
   -20.700
     0.300
     4.600
    -5.000
   -12.000
     2.000
   -25.000
    -0.000
   -14.500
    -3.100
     6.200
    -4.700
    -5.400
   -24.700
     2.600
     1.200
   -23.400
     7.400
     2.000
    -1.200
   -11.000
     4.000
   -16.500
   -25.100
     3.000
     8.000
    -3.900
     0.100
     3.400
   -21.000
    12.300
     8.500
    -1.800
   -24.000
     4.800
     9.700
   -13.200
    12.600
    -4.000
    -0.000
    -4.000
    -8.000
    -0.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     0.300    23.365 Median =   0.3 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  0.3  0.
  0.3  22.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -44.000    24.635 Author: all ( 319 samples)
EOF
gmt end
