#!/bin/bash
gmt begin caleta1.47_dcal pdf,ps
proj=-JM16.0c+
reg=-R-106.3/-100.0/15.8/21.6
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration caleta1.47'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -101.882    18.275
  -102.635    18.118
>
  -102.750    18.053
  -102.699    17.983
>
  -102.750    18.053
  -102.699    17.983
>
  -103.691    19.181
  -103.335    18.532
>
  -103.691    19.181
  -103.272    18.314
>
  -103.691    19.181
  -103.039    18.487
>
  -103.691    19.181
  -103.495    19.128
>
  -103.462    19.703
  -103.495    19.128
>
  -104.331    19.054
  -103.495    19.128
>
  -104.331    19.054
  -103.448    18.570
>
  -103.691    19.181
  -103.648    19.271
>
  -103.462    19.703
  -103.648    19.271
>
  -103.462    19.703
  -103.648    19.271
>
  -103.691    19.181
  -103.167    18.934
>
  -103.691    19.181
  -103.167    18.934
>
  -101.465    17.607
  -102.411    17.833
>
  -101.465    17.607
  -102.411    17.833
>
  -103.691    19.181
  -103.990    18.697
>
  -103.691    19.181
  -103.990    18.697
>
  -101.465    17.607
  -102.267    17.907
>
  -101.465    17.607
  -102.267    17.907
>
  -103.691    19.181
  -104.081    18.614
>
  -103.345    18.289
  -103.551    18.403
>
  -103.345    18.289
  -103.551    18.403
>
  -103.345    18.289
  -102.471    18.753
>
  -103.345    18.289
  -102.471    18.753
>
  -103.345    18.289
  -102.888    18.063
>
  -103.345    18.289
  -102.888    18.063
>
  -103.345    18.289
  -104.016    18.835
>
  -103.345    18.289
  -104.016    18.835
>
  -103.345    18.289
  -102.933    18.406
>
  -103.345    18.289
  -102.933    18.406
>
  -103.345    18.289
  -102.879    18.643
>
  -103.345    18.289
  -102.879    18.643
>
  -103.345    18.289
  -102.341    18.402
>
  -103.345    18.289
  -102.341    18.402
>
  -103.345    18.289
  -102.635    17.954
>
  -103.345    18.289
  -102.635    17.954
>
  -103.345    18.289
  -102.609    18.409
>
  -103.345    18.289
  -102.609    18.409
>
  -101.465    17.607
  -102.275    18.083
>
  -101.465    17.607
  -102.275    18.083
>
  -103.345    18.289
  -103.264    18.527
>
  -103.345    18.289
  -103.264    18.527
>
  -103.983    19.170
  -103.264    18.527
>
  -103.983    19.170
  -103.264    18.527
>
  -103.345    18.289
  -102.907    18.044
>
  -103.345    18.289
  -102.907    18.044
>
  -103.345    18.289
  -103.066    18.395
>
  -103.345    18.289
  -103.066    18.395
>
  -103.345    18.289
  -102.331    18.325
>
  -103.345    18.289
  -102.331    18.325
>
  -101.465    17.607
  -102.180    18.002
>
  -101.465    17.607
  -102.180    18.002
>
  -103.345    18.289
  -102.951    18.976
>
  -103.345    18.289
  -102.951    18.976
>
  -103.602    19.479
  -102.951    18.976
>
  -103.602    19.479
  -102.951    18.976
>
  -103.983    19.170
  -102.951    18.976
>
  -103.983    19.170
  -102.951    18.976
>
  -103.345    18.289
  -102.354    18.327
>
  -103.345    18.289
  -102.354    18.327
>
  -103.345    18.289
  -103.709    18.553
>
  -103.345    18.289
  -103.709    18.553
>
  -103.602    19.479
  -103.709    18.553
>
  -103.602    19.479
  -103.709    18.553
>
  -103.345    18.289
  -102.921    18.083
>
  -103.345    18.289
  -102.921    18.083
>
  -103.345    18.289
  -103.562    18.333
>
  -103.345    18.289
  -103.562    18.333
>
  -103.983    19.170
  -103.562    18.333
>
  -103.983    19.170
  -103.562    18.333
>
  -103.345    18.289
  -102.639    18.387
>
  -103.345    18.289
  -102.639    18.387
>
  -103.983    19.170
  -103.894    18.574
>
  -103.983    19.170
  -103.894    18.574
>
  -103.983    19.170
  -103.894    18.574
>
  -103.602    19.479
  -103.894    18.574
>
  -103.602    19.479
  -103.894    18.574
>
  -103.345    18.289
  -102.592    18.446
>
  -103.345    18.289
  -102.592    18.446
>
  -101.465    17.607
  -102.159    18.049
>
  -101.465    17.607
  -102.159    18.049
>
  -103.345    18.289
  -103.416    18.244
>
  -103.345    18.289
  -103.416    18.244
>
  -103.345    18.289
  -104.036    18.539
>
  -103.602    19.479
  -103.663    19.367
>
  -103.602    19.479
  -103.663    19.367
>
  -103.983    19.170
  -103.663    19.367
>
  -103.983    19.170
  -103.663    19.367
>
  -101.465    17.607
  -102.015    18.155
>
  -101.465    17.607
  -102.015    18.155
>
  -101.465    17.607
  -102.015    18.155
>
  -101.465    17.607
  -102.382    17.983
>
  -101.465    17.607
  -102.382    17.983
>
  -103.345    18.289
  -102.382    17.983
>
  -103.345    18.289
  -102.382    17.983
>
  -103.345    18.289
  -102.910    18.447
>
  -103.345    18.289
  -103.431    18.253
>
  -103.345    18.289
  -103.431    18.253
>
  -103.690    19.180
  -103.431    18.253
>
  -103.690    19.180
  -103.431    18.253
>
  -103.983    19.170
  -104.278    19.128
>
  -103.983    19.170
  -104.278    19.128
>
  -103.983    19.170
  -104.278    19.128
>
  -103.983    19.170
  -104.037    18.610
>
  -103.983    19.170
  -104.037    18.610
>
  -103.983    19.170
  -104.037    18.610
>
  -103.983    19.170
  -104.037    18.610
>
  -103.690    19.180
  -104.037    18.610
>
  -103.690    19.180
  -104.037    18.610
>
  -103.690    19.180
  -104.037    18.610
>
  -103.690    19.180
  -104.037    18.610
>
  -103.345    18.289
  -104.037    18.610
>
  -103.345    18.289
  -104.037    18.610
>
  -103.602    19.479
  -104.037    18.610
>
  -103.602    19.479
  -104.037    18.610
>
  -103.602    19.479
  -104.037    18.610
>
  -103.345    18.289
  -102.726    18.119
>
  -103.345    18.289
  -102.726    18.119
>
  -101.815    17.970
  -102.726    18.119
>
  -101.815    17.970
  -102.726    18.119
>
  -103.345    18.289
  -102.745    18.175
>
  -103.345    18.289
  -102.745    18.175
>
  -101.815    17.970
  -102.745    18.175
>
  -101.815    17.970
  -102.745    18.175
>
  -103.345    18.289
  -103.459    18.301
>
  -103.345    18.289
  -103.459    18.301
>
  -104.011    18.941
  -103.459    18.301
>
  -104.011    18.941
  -103.459    18.301
>
  -103.690    19.180
  -103.459    18.301
>
  -103.690    19.180
  -103.459    18.301
>
  -103.983    19.170
  -103.459    18.301
>
  -103.983    19.170
  -103.459    18.301
>
  -103.345    18.289
  -103.119    18.499
>
  -103.345    18.289
  -103.119    18.499
>
  -103.690    19.180
  -103.119    18.499
>
  -103.690    19.180
  -103.119    18.499
>
  -104.011    18.941
  -103.119    18.499
>
  -104.011    18.941
  -103.119    18.499
>
  -103.345    18.289
  -103.425    18.260
>
  -103.345    18.289
  -103.425    18.260
>
  -104.011    18.941
  -103.425    18.260
>
  -104.011    18.941
  -103.425    18.260
>
  -103.690    19.180
  -103.425    18.260
>
  -103.690    19.180
  -103.425    18.260
>
  -103.345    18.289
  -103.344    18.333
>
  -103.345    18.289
  -103.344    18.333
>
  -104.011    18.941
  -103.344    18.333
>
  -104.011    18.941
  -103.344    18.333
>
  -103.690    19.180
  -103.344    18.333
>
  -103.690    19.180
  -103.344    18.333
>
  -101.815    17.970
  -102.443    18.465
>
  -101.815    17.970
  -102.443    18.465
>
  -103.345    18.289
  -102.443    18.465
>
  -103.345    18.289
  -102.443    18.465
>
  -101.815    17.970
  -102.396    18.083
>
  -101.815    17.970
  -102.396    18.083
>
  -103.345    18.289
  -103.100    18.457
>
  -103.345    18.289
  -103.100    18.457
>
  -103.345    18.289
  -102.551    18.549
>
  -103.345    18.289
  -102.551    18.549
>
  -101.815    17.970
  -102.551    18.549
>
  -101.815    17.970
  -102.551    18.549
>
  -102.074    19.422
  -102.551    18.549
>
  -101.815    17.970
  -102.382    18.309
>
  -101.815    17.970
  -102.382    18.309
>
  -103.345    18.289
  -102.382    18.309
>
  -103.690    19.180
  -103.088    18.512
>
  -104.011    18.941
  -103.088    18.512
>
  -101.815    17.970
  -102.361    18.349
>
  -103.345    18.289
  -102.361    18.349
>
  -103.345    18.289
  -102.361    18.349
>
  -103.345    18.289
  -103.318    18.240
>
  -103.345    18.289
  -103.318    18.240
>
  -104.011    18.941
  -103.318    18.240
>
  -104.011    18.941
  -103.318    18.240
>
  -103.345    18.289
  -103.312    18.296
>
  -103.345    18.289
  -103.312    18.296
>
  -104.011    18.941
  -103.312    18.296
>
  -104.011    18.941
  -103.312    18.296
>
  -103.690    19.180
  -103.312    18.296
>
  -103.690    19.180
  -103.312    18.296
>
  -103.345    18.289
  -102.513    18.745
>
  -103.345    18.289
  -102.513    18.745
>
  -102.074    19.422
  -102.513    18.745
>
  -102.074    19.422
  -102.513    18.745
>
  -102.074    19.422
  -102.184    18.605
>
  -102.074    19.422
  -102.184    18.605
>
  -103.570    19.515
  -102.793    19.136
>
  -103.570    19.515
  -102.793    19.136
>
  -103.690    19.180
  -102.793    19.136
>
  -103.690    19.180
  -102.793    19.136
>
  -103.602    19.479
  -102.793    19.136
>
  -103.602    19.479
  -102.793    19.136
>
  -103.620    19.466
  -102.793    19.136
>
  -103.620    19.466
  -102.793    19.136
>
  -103.620    19.466
  -102.793    19.136
>
  -103.604    19.525
  -102.793    19.136
>
  -103.604    19.525
  -102.793    19.136
>
  -103.630    19.524
  -102.793    19.136
>
  -103.630    19.524
  -102.793    19.136
>
  -103.345    18.289
  -102.793    19.136
>
  -103.345    18.289
  -102.793    19.136
>
  -103.761    19.325
  -102.793    19.136
>
  -103.761    19.325
  -102.793    19.136
>
  -103.345    18.289
  -103.292    18.233
>
  -103.345    18.289
  -103.292    18.233
>
  -104.011    18.941
  -103.292    18.233
>
  -103.570    19.515
  -103.546    19.457
>
  -103.570    19.515
  -103.546    19.457
>
  -103.602    19.479
  -103.546    19.457
>
  -103.602    19.479
  -103.546    19.457
>
  -103.620    19.466
  -103.546    19.457
>
  -103.620    19.466
  -103.546    19.457
>
  -103.604    19.525
  -103.546    19.457
>
  -103.604    19.525
  -103.546    19.457
>
  -103.630    19.524
  -103.546    19.457
>
  -103.630    19.524
  -103.546    19.457
>
  -103.690    19.180
  -103.546    19.457
>
  -103.690    19.180
  -103.546    19.457
>
  -103.761    19.325
  -103.546    19.457
>
  -103.761    19.325
  -103.546    19.457
>
  -103.857    19.391
  -103.546    19.457
>
  -103.857    19.391
  -103.546    19.457
>
  -104.011    18.941
  -103.546    19.457
>
  -104.011    18.941
  -103.546    19.457
>
  -101.815    17.970
  -102.042    18.325
>
  -101.815    17.970
  -102.042    18.325
>
  -101.465    17.607
  -102.042    18.325
>
  -101.465    17.607
  -102.042    18.325
>
  -103.345    18.289
  -103.247    18.199
>
  -103.345    18.289
  -103.247    18.199
>
  -101.815    17.970
  -102.637    17.892
>
  -101.815    17.970
  -102.637    17.892
>
  -103.345    18.289
  -102.637    17.892
>
  -103.345    18.289
  -102.637    17.892
>
  -103.345    18.289
  -102.726    19.037
>
  -103.345    18.289
  -102.726    19.037
>
  -103.690    19.180
  -102.726    19.037
>
  -103.690    19.180
  -102.726    19.037
>
  -103.570    19.515
  -102.726    19.037
>
  -103.570    19.515
  -102.726    19.037
>
  -103.602    19.479
  -102.726    19.037
>
  -103.602    19.479
  -102.726    19.037
>
  -103.620    19.466
  -102.726    19.037
>
  -103.620    19.466
  -102.726    19.037
>
  -103.604    19.525
  -102.726    19.037
>
  -103.604    19.525
  -102.726    19.037
>
  -103.630    19.524
  -102.726    19.037
>
  -103.630    19.524
  -102.726    19.037
>
  -103.345    18.289
  -103.345    18.273
>
  -103.345    18.289
  -103.345    18.273
>
  -104.011    18.941
  -103.345    18.273
>
  -104.011    18.941
  -103.345    18.273
>
  -103.690    19.180
  -103.345    18.273
>
  -103.690    19.180
  -103.345    18.273
>
  -103.345    18.289
  -103.309    18.218
>
  -103.345    18.289
  -103.309    18.218
>
  -104.011    18.941
  -103.309    18.218
>
  -104.011    18.941
  -103.309    18.218
>
  -104.011    18.941
  -103.880    18.931
>
  -104.011    18.941
  -103.880    18.931
>
  -103.690    19.180
  -103.880    18.931
>
  -103.690    19.180
  -103.880    18.931
>
  -103.761    19.325
  -103.880    18.931
>
  -103.761    19.325
  -103.880    18.931
>
  -103.857    19.391
  -103.880    18.931
>
  -103.857    19.391
  -103.880    18.931
>
  -103.620    19.466
  -103.880    18.931
>
  -103.620    19.466
  -103.880    18.931
>
  -103.602    19.479
  -103.880    18.931
>
  -103.630    19.524
  -103.880    18.931
>
  -103.630    19.524
  -103.880    18.931
>
  -103.604    19.525
  -103.880    18.931
>
  -103.604    19.525
  -103.880    18.931
>
  -103.570    19.515
  -103.880    18.931
>
  -103.570    19.515
  -103.880    18.931
>
  -103.345    18.289
  -103.880    18.931
>
  -103.345    18.289
  -103.880    18.931
>
  -104.735    19.265
  -103.880    18.931
>
  -104.735    19.265
  -103.880    18.931
>
  -103.345    18.289
  -103.394    18.319
>
  -103.345    18.289
  -103.394    18.319
>
  -104.011    18.941
  -103.394    18.319
>
  -104.011    18.941
  -103.394    18.319
>
  -103.690    19.180
  -103.394    18.319
>
  -103.690    19.180
  -103.394    18.319
>
  -103.345    18.289
  -103.031    18.399
>
  -103.345    18.289
  -103.031    18.399
>
  -103.345    18.289
  -102.670    17.942
>
  -103.345    18.289
  -102.670    17.942
>
  -101.815    17.970
  -102.670    17.942
>
  -101.815    17.970
  -102.670    17.942
>
  -101.815    17.970
  -102.261    18.710
>
  -101.815    17.970
  -102.261    18.710
>
  -103.690    19.180
  -103.240    18.979
>
  -103.690    19.180
  -103.240    18.979
>
  -103.620    19.466
  -103.240    18.979
>
  -103.620    19.466
  -103.240    18.979
>
  -103.602    19.479
  -103.240    18.979
>
  -103.570    19.515
  -103.240    18.979
>
  -103.570    19.515
  -103.240    18.979
>
  -103.604    19.525
  -103.240    18.979
>
  -103.604    19.525
  -103.240    18.979
>
  -103.630    19.524
  -103.240    18.979
>
  -103.630    19.524
  -103.240    18.979
>
  -103.345    18.289
  -103.240    18.979
>
  -103.345    18.289
  -103.240    18.979
>
  -104.011    18.941
  -103.240    18.979
>
  -104.011    18.941
  -103.240    18.979
>
  -103.983    19.170
  -103.240    18.979
>
  -103.983    19.170
  -103.240    18.979
>
  -103.857    19.391
  -103.240    18.979
>
  -103.857    19.391
  -103.240    18.979
>
  -103.345    18.289
  -102.805    18.493
>
  -103.345    18.289
  -102.805    18.493
>
  -104.011    18.941
  -103.664    18.657
>
  -104.011    18.941
  -103.664    18.657
>
  -103.345    18.289
  -103.664    18.657
>
  -103.345    18.289
  -103.664    18.657
>
  -103.761    19.325
  -103.664    18.657
>
  -103.761    19.325
  -103.664    18.657
>
  -103.857    19.391
  -103.664    18.657
>
  -103.857    19.391
  -103.664    18.657
>
  -103.620    19.466
  -103.664    18.657
>
  -103.620    19.466
  -103.664    18.657
>
  -103.630    19.524
  -103.664    18.657
>
  -103.630    19.524
  -103.664    18.657
>
  -103.604    19.525
  -103.664    18.657
>
  -103.604    19.525
  -103.664    18.657
>
  -103.345    18.289
  -103.121    18.451
>
  -103.345    18.289
  -103.121    18.451
>
  -104.011    18.941
  -104.086    18.886
>
  -104.011    18.941
  -104.086    18.886
>
  -103.761    19.325
  -104.086    18.886
>
  -103.761    19.325
  -104.086    18.886
>
  -103.857    19.391
  -104.086    18.886
>
  -103.620    19.466
  -104.086    18.886
>
  -103.620    19.466
  -104.086    18.886
>
  -104.735    19.265
  -104.086    18.886
>
  -103.602    19.479
  -104.086    18.886
>
  -103.602    19.479
  -104.086    18.886
>
  -103.630    19.524
  -104.086    18.886
>
  -103.630    19.524
  -104.086    18.886
>
  -103.604    19.525
  -104.086    18.886
>
  -103.345    18.289
  -104.086    18.886
>
  -103.345    18.289
  -104.086    18.886
>
  -101.815    17.970
  -102.525    18.080
>
  -101.815    17.970
  -102.525    18.080
>
  -103.345    18.289
  -102.525    18.080
>
  -103.345    18.289
  -102.525    18.080
>
  -103.345    18.289
  -103.071    18.448
>
  -103.345    18.289
  -103.071    18.448
>
  -101.815    17.970
  -102.326    17.951
>
  -101.815    17.970
  -102.326    17.951
>
  -101.465    17.607
  -102.326    17.951
>
  -101.465    17.607
  -102.326    17.951
>
  -103.345    18.289
  -102.751    18.581
>
  -103.345    18.289
  -102.751    18.581
>
  -103.345    18.289
  -102.618    18.363
>
  -103.345    18.289
  -102.618    18.363
>
  -101.815    17.970
  -102.618    18.363
>
  -101.815    17.970
  -102.618    18.363
>
  -101.815    17.970
  -102.528    18.375
>
  -101.815    17.970
  -102.528    18.375
>
  -103.345    18.289
  -102.528    18.375
>
  -103.345    18.289
  -102.528    18.375
>
  -102.074    19.422
  -102.053    18.866
>
  -101.815    17.970
  -102.053    18.866
>
  -103.345    18.289
  -103.460    18.343
>
  -103.345    18.289
  -103.460    18.343
>
  -104.011    18.941
  -103.460    18.343
>
  -104.011    18.941
  -103.460    18.343
>
  -103.345    18.289
  -103.478    18.280
>
  -103.345    18.289
  -103.478    18.280
>
  -104.011    18.941
  -103.478    18.280
>
  -104.011    18.941
  -103.478    18.280
>
  -104.011    18.941
  -103.999    18.513
>
  -104.011    18.941
  -103.999    18.513
>
  -103.345    18.289
  -103.999    18.513
>
  -103.345    18.289
  -103.999    18.513
>
  -103.857    19.391
  -103.999    18.513
>
  -103.857    19.391
  -103.999    18.513
>
  -101.815    17.970
  -102.300    18.000
>
  -101.815    17.970
  -102.300    18.000
>
  -103.620    19.466
  -103.335    19.025
>
  -103.620    19.466
  -103.335    19.025
>
  -103.604    19.525
  -103.335    19.025
>
  -103.604    19.525
  -103.335    19.025
>
  -103.630    19.524
  -103.335    19.025
>
  -103.630    19.524
  -103.335    19.025
>
  -103.857    19.391
  -103.335    19.025
>
  -103.857    19.391
  -103.335    19.025
>
  -104.011    18.941
  -103.335    19.025
>
  -104.011    18.941
  -103.335    19.025
>
  -103.345    18.289
  -103.335    19.025
>
  -103.345    18.289
  -103.335    19.025
>
  -101.465    17.607
  -102.109    18.028
>
  -101.465    17.607
  -102.109    18.028
>
  -103.345    18.289
  -102.418    18.358
>
  -103.345    18.289
  -102.418    18.358
>
  -103.345    18.289
  -103.007    18.799
>
  -103.345    18.289
  -103.007    18.799
>
  -103.602    19.479
  -103.007    18.799
>
  -103.602    19.479
  -103.007    18.799
>
  -103.620    19.466
  -103.007    18.799
>
  -104.011    18.941
  -103.007    18.799
>
  -103.604    19.525
  -103.007    18.799
>
  -103.604    19.525
  -103.007    18.799
>
  -103.630    19.524
  -103.007    18.799
>
  -103.857    19.391
  -103.007    18.799
>
  -103.857    19.391
  -103.007    18.799
>
  -103.345    18.289
  -102.935    18.492
>
  -103.345    18.289
  -102.935    18.492
>
  -102.074    19.422
  -102.338    19.447
>
  -102.074    19.422
  -102.338    19.447
>
  -101.815    17.970
  -102.335    18.037
>
  -101.815    17.970
  -102.335    18.037
>
  -101.465    17.607
  -102.335    18.037
>
  -101.465    17.607
  -102.335    18.037
>
  -103.345    18.289
  -102.335    18.037
>
  -103.345    18.289
  -102.335    18.037
>
  -102.074    19.422
  -102.345    19.474
>
  -102.074    19.422
  -102.345    19.474
>
  -103.345    18.289
  -103.156    18.506
>
  -103.345    18.289
  -103.156    18.506
>
  -104.011    18.941
  -103.156    18.506
>
  -104.011    18.941
  -103.156    18.506
>
  -103.761    19.325
  -103.156    18.506
>
  -103.761    19.325
  -103.156    18.506
>
  -103.857    19.391
  -103.832    19.437
>
  -103.857    19.391
  -103.832    19.437
>
  -103.630    19.524
  -103.832    19.437
>
  -103.630    19.524
  -103.832    19.437
>
  -103.604    19.525
  -103.832    19.437
>
  -103.604    19.525
  -103.832    19.437
>
  -104.011    18.941
  -103.832    19.437
>
  -104.011    18.941
  -103.832    19.437
>
  -103.345    18.289
  -103.222    18.501
>
  -103.345    18.289
  -103.222    18.501
>
  -104.011    18.941
  -103.222    18.501
>
  -104.011    18.941
  -103.222    18.501
>
  -103.761    19.325
  -103.222    18.501
>
  -103.761    19.325
  -103.222    18.501
>
  -103.345    18.289
  -103.363    18.343
>
  -103.345    18.289
  -103.363    18.343
>
  -103.345    18.289
  -103.392    18.316
>
  -103.345    18.289
  -103.392    18.316
>
  -104.011    18.941
  -103.392    18.316
>
  -104.011    18.941
  -103.392    18.316
>
  -103.345    18.289
  -102.869    18.061
>
  -103.345    18.289
  -102.869    18.061
>
  -102.074    19.422
  -102.344    19.393
>
  -102.074    19.422
  -102.344    19.393
>
  -103.345    18.289
  -103.468    18.341
>
  -103.345    18.289
  -103.468    18.341
>
  -103.345    18.289
  -103.283    18.182
>
  -103.345    18.289
  -103.283    18.182
>
  -101.815    17.970
  -102.334    18.602
>
  -101.815    17.970
  -102.334    18.602
>
  -103.345    18.289
  -102.818    17.996
>
  -103.345    18.289
  -102.818    17.996
>
  -103.345    18.289
  -103.388    18.231
>
  -103.345    18.289
  -103.388    18.231
>
  -103.345    18.289
  -103.171    18.476
>
  -103.345    18.289
  -103.171    18.476
>
  -103.345    18.289
  -103.300    18.564
>
  -103.345    18.289
  -103.300    18.564
>
  -103.761    19.325
  -103.300    18.564
>
  -103.761    19.325
  -103.300    18.564
>
  -103.857    19.391
  -103.300    18.564
>
  -103.857    19.391
  -103.300    18.564
>
  -103.604    19.525
  -103.300    18.564
>
  -101.815    17.970
  -102.252    18.226
>
  -101.815    17.970
  -102.252    18.226
>
  -101.465    17.607
  -102.252    18.226
>
  -101.465    17.607
  -102.252    18.226
>
  -102.074    19.422
  -102.696    18.777
>
  -102.074    19.422
  -102.696    18.777
>
  -102.074    19.422
  -102.321    19.498
>
  -102.074    19.422
  -102.321    19.498
>
  -102.074    19.422
  -102.221    19.551
>
  -102.074    19.422
  -102.221    19.551
>
  -101.227    19.647
  -102.221    19.551
>
  -103.345    18.289
  -102.665    18.046
>
  -103.345    18.289
  -102.665    18.046
>
  -101.815    17.970
  -102.304    18.627
>
  -101.815    17.970
  -102.188    18.298
>
  -101.815    17.970
  -102.188    18.298
>
  -101.465    17.607
  -102.188    18.298
>
  -101.465    17.607
  -102.188    18.298
>
  -102.074    19.422
  -102.269    19.486
>
  -102.074    19.422
  -102.269    19.486
>
  -101.227    19.647
  -102.269    19.486
>
  -102.074    19.422
  -102.267    19.432
>
  -102.074    19.422
  -102.267    19.432
>
  -101.815    17.970
  -102.334    18.415
>
  -101.815    17.970
  -102.334    18.415
>
  -103.345    18.289
  -102.334    18.415
>
  -103.345    18.289
  -102.334    18.415
>
  -103.345    18.289
  -103.120    18.070
>
  -103.345    18.289
  -103.120    18.070
>
  -103.345    18.289
  -103.120    18.070
>
  -101.815    17.970
  -102.403    18.391
>
  -101.815    17.970
  -102.403    18.391
>
  -103.345    18.289
  -102.403    18.391
>
  -103.345    18.289
  -102.403    18.391
>
  -103.345    18.289
  -102.456    18.370
>
  -103.345    18.289
  -102.456    18.370
>
  -101.465    17.607
  -102.111    18.203
>
  -101.465    17.607
  -102.111    18.203
>
  -103.345    18.289
  -102.868    18.352
>
  -103.345    18.289
  -102.868    18.352
>
  -103.345    18.289
  -102.432    18.688
>
  -103.345    18.289
  -102.432    18.688
>
  -102.074    19.422
  -102.432    18.688
>
  -102.074    19.422
  -102.432    18.688
>
  -103.345    18.289
  -102.429    18.252
>
  -103.345    18.289
  -102.429    18.252
>
  -103.345    18.289
  -103.222    18.229
>
  -103.345    18.289
  -103.222    18.229
>
  -103.345    18.289
  -103.399    18.307
>
  -103.345    18.289
  -103.399    18.307
>
  -103.345    18.289
  -103.255    18.289
>
  -103.345    18.289
  -103.255    18.289
>
  -103.690    19.180
  -103.255    18.289
>
  -103.345    18.289
  -103.850    18.441
>
  -103.345    18.289
  -103.850    18.441
>
  -103.690    19.180
  -103.850    18.441
>
  -103.690    19.180
  -103.850    18.441
>
  -103.761    19.325
  -103.850    18.441
>
  -103.761    19.325
  -103.850    18.441
>
  -103.857    19.391
  -103.850    18.441
>
  -103.857    19.391
  -103.850    18.441
>
  -103.857    19.391
  -103.850    18.441
>
  -103.345    18.289
  -103.204    18.151
>
  -103.345    18.289
  -103.204    18.151
>
  -103.345    18.289
  -103.154    18.127
>
  -103.345    18.289
  -103.154    18.127
>
  -103.345    18.289
  -103.271    18.344
>
  -103.345    18.289
  -103.271    18.344
>
  -103.690    19.180
  -103.271    18.344
>
  -103.690    19.180
  -103.271    18.344
>
  -103.345    18.289
  -103.162    18.190
>
  -103.345    18.289
  -103.162    18.190
>
  -103.690    19.180
  -103.642    18.339
>
  -103.690    19.180
  -103.642    18.339
>
  -103.761    19.325
  -103.642    18.339
>
  -103.761    19.325
  -103.642    18.339
>
  -103.761    19.325
  -103.822    18.535
>
  -103.761    19.325
  -103.822    18.535
>
  -103.857    19.391
  -103.822    18.535
>
  -103.857    19.391
  -103.822    18.535
>
  -103.690    19.180
  -103.165    18.334
>
  -103.690    19.180
  -103.165    18.334
>
  -103.690    19.180
  -103.715    18.394
>
  -103.690    19.180
  -103.715    18.394
>
  -103.761    19.325
  -103.715    18.394
>
  -103.761    19.325
  -103.715    18.394
>
  -103.345    18.289
  -103.276    18.220
>
  -103.345    18.289
  -103.276    18.220
>
  -103.345    18.289
  -103.307    18.260
>
  -103.345    18.289
  -103.307    18.260
>
  -103.690    19.180
  -103.307    18.260
>
  -103.690    19.180
  -103.307    18.260
>
  -103.345    18.289
  -103.234    18.600
>
  -103.345    18.289
  -103.234    18.600
>
  -103.690    19.180
  -103.234    18.600
>
  -103.690    19.180
  -103.234    18.600
>
  -103.761    19.325
  -103.234    18.600
>
  -103.761    19.325
  -103.234    18.600
>
  -103.857    19.391
  -103.234    18.600
>
  -103.857    19.391
  -103.234    18.600
>
  -103.345    18.289
  -103.483    18.585
>
  -103.345    18.289
  -103.483    18.585
>
  -103.690    19.180
  -103.483    18.585
>
  -103.690    19.180
  -103.483    18.585
>
  -103.761    19.325
  -103.483    18.585
>
  -103.761    19.325
  -103.483    18.585
>
  -103.857    19.391
  -103.483    18.585
>
  -103.857    19.391
  -103.483    18.585
>
  -103.345    18.289
  -103.419    18.639
>
  -103.345    18.289
  -103.419    18.639
>
  -103.690    19.180
  -103.419    18.639
>
  -103.690    19.180
  -103.419    18.639
>
  -103.761    19.325
  -103.419    18.639
>
  -103.761    19.325
  -103.419    18.639
>
  -103.857    19.391
  -103.419    18.639
>
  -103.857    19.391
  -103.419    18.639
>
  -103.345    18.289
  -103.408    18.417
>
  -103.345    18.289
  -103.408    18.417
>
  -103.690    19.180
  -103.408    18.417
>
  -103.690    19.180
  -103.408    18.417
>
  -103.761    19.325
  -103.408    18.417
>
  -103.761    19.325
  -103.408    18.417
>
  -103.345    18.289
  -103.250    18.243
>
  -103.345    18.289
  -103.250    18.243
>
  -103.345    18.289
  -103.131    17.826
>
  -103.345    18.289
  -103.131    17.826
>
  -103.690    19.180
  -103.199    18.358
>
  -103.690    19.180
  -103.199    18.358
>
  -103.345    18.289
  -103.106    18.281
>
  -103.345    18.289
  -103.106    18.281
>
  -103.345    18.289
  -102.817    18.677
>
  -103.345    18.289
  -102.817    18.677
>
  -103.690    19.180
  -102.817    18.677
>
  -103.690    19.180
  -102.817    18.677
>
  -103.345    18.289
  -103.126    18.172
>
  -103.345    18.289
  -103.126    18.172
>
  -102.074    19.422
  -102.547    19.572
>
  -102.074    19.422
  -102.547    19.572
>
  -103.690    19.180
  -103.298    18.459
>
  -103.690    19.180
  -103.298    18.459
>
  -103.761    19.325
  -103.298    18.459
>
  -103.761    19.325
  -103.298    18.459
>
  -102.074    19.422
  -102.521    19.492
>
  -102.074    19.422
  -102.521    19.492
>
  -103.345    18.289
  -103.146    18.302
>
  -103.345    18.289
  -103.146    18.302
>
  -103.345    18.289
  -103.100    18.221
>
  -103.345    18.289
  -103.100    18.221
>
  -102.074    19.422
  -102.532    19.546
>
  -102.074    19.422
  -102.532    19.546
>
  -102.074    19.422
  -102.560    19.575
>
  -102.074    19.422
  -102.560    19.575
>
  -102.074    19.422
  -102.468    19.446
>
  -102.074    19.422
  -102.468    19.446
>
  -102.074    19.422
  -102.535    19.475
>
  -102.074    19.422
  -102.535    19.475
>
  -103.345    18.289
  -103.267    18.284
>
  -103.345    18.289
  -103.267    18.284
>
  -103.690    19.180
  -103.267    18.284
>
  -103.690    19.180
  -103.267    18.284
>
  -102.074    19.422
  -102.490    19.471
>
  -102.074    19.422
  -102.490    19.471
>
  -102.074    19.422
  -102.508    19.542
>
  -102.074    19.422
  -102.508    19.542
>
  -103.345    18.289
  -103.188    18.361
>
  -103.345    18.289
  -103.188    18.361
>
  -103.690    19.180
  -103.188    18.361
>
  -103.690    19.180
  -103.188    18.361
>
  -101.465    17.607
  -102.248    18.095
>
  -101.465    17.607
  -102.248    18.095
>
  -103.345    18.289
  -103.290    18.566
>
  -103.345    18.289
  -103.290    18.566
>
  -103.690    19.180
  -103.290    18.566
>
  -103.690    19.180
  -103.290    18.566
>
  -103.761    19.325
  -103.290    18.566
>
  -103.761    19.325
  -103.290    18.566
>
  -103.857    19.391
  -103.290    18.566
>
  -103.857    19.391
  -103.290    18.566
>
  -103.690    19.180
  -103.204    18.405
>
  -102.074    19.422
  -102.569    19.504
>
  -102.074    19.422
  -102.569    19.504
>
  -103.345    18.289
  -103.309    18.330
>
  -103.345    18.289
  -103.309    18.330
>
  -103.690    19.180
  -103.309    18.330
>
  -103.690    19.180
  -103.309    18.330
>
  -102.074    19.422
  -102.456    19.522
>
  -102.074    19.422
  -102.456    19.522
>
  -102.074    19.422
  -102.446    19.602
>
  -102.074    19.422
  -102.446    19.602
>
  -101.465    17.607
  -102.241    18.116
>
  -103.345    18.289
  -103.228    18.557
>
  -103.345    18.289
  -103.228    18.557
>
  -103.690    19.180
  -103.228    18.557
>
  -103.690    19.180
  -103.228    18.557
>
  -103.761    19.325
  -103.228    18.557
>
  -103.761    19.325
  -103.228    18.557
>
  -102.074    19.422
  -102.387    19.604
>
  -102.074    19.422
  -102.387    19.604
>
  -102.074    19.422
  -102.414    19.594
>
  -102.074    19.422
  -102.414    19.594
>
  -102.074    19.422
  -102.410    19.597
>
  -102.074    19.422
  -102.410    19.597
>
  -102.074    19.422
  -102.403    19.601
>
  -102.074    19.422
  -102.403    19.601
>
  -103.345    18.289
  -102.609    18.467
>
  -103.345    18.289
  -102.609    18.467
>
  -102.074    19.422
  -102.501    19.519
>
  -102.074    19.422
  -102.501    19.519
>
  -103.345    18.289
  -102.615    18.073
>
  -103.345    18.289
  -102.615    18.073
>
  -102.074    19.422
  -102.574    19.493
>
  -102.074    19.422
  -102.574    19.493
>
  -103.604    19.525
  -102.574    19.493
>
  -103.604    19.525
  -102.574    19.493
>
  -103.345    18.289
  -103.343    18.109
>
  -103.345    18.289
  -103.343    18.109
>
  -103.345    18.289
  -103.179    18.409
>
  -103.345    18.289
  -103.179    18.409
>
  -103.690    19.180
  -103.179    18.409
>
  -103.690    19.180
  -103.179    18.409
>
  -103.857    19.391
  -103.688    19.449
>
  -103.857    19.391
  -103.688    19.449
>
  -103.690    19.180
  -103.688    19.449
>
  -103.690    19.180
  -103.688    19.449
>
  -103.345    18.289
  -103.226    18.361
>
  -103.345    18.289
  -103.226    18.361
>
  -103.690    19.180
  -103.226    18.361
>
  -103.690    19.180
  -103.226    18.361
>
  -103.345    18.289
  -103.235    18.572
>
  -103.345    18.289
  -103.235    18.572
>
  -103.690    19.180
  -103.235    18.572
>
  -103.690    19.180
  -103.235    18.572
>
  -102.074    19.422
  -102.563    19.485
>
  -102.074    19.422
  -102.563    19.485
>
  -103.604    19.525
  -102.563    19.485
>
  -103.604    19.525
  -102.563    19.485
>
  -103.345    18.289
  -102.939    18.825
>
  -103.345    18.289
  -102.939    18.825
>
  -103.690    19.180
  -102.939    18.825
>
  -103.690    19.180
  -102.939    18.825
>
  -102.074    19.422
  -102.554    19.561
>
  -102.074    19.422
  -102.554    19.561
>
  -103.604    19.525
  -102.554    19.561
>
  -103.345    18.289
  -102.840    18.205
>
  -103.345    18.289
  -102.840    18.205
>
  -101.465    17.607
  -102.143    18.050
>
  -101.465    17.607
  -102.143    18.050
>
  -103.345    18.289
  -103.305    18.537
>
  -103.345    18.289
  -103.305    18.537
>
  -103.690    19.180
  -103.305    18.537
>
  -103.690    19.180
  -103.305    18.537
>
  -103.857    19.391
  -103.305    18.537
>
  -103.857    19.391
  -103.305    18.537
>
  -103.345    18.289
  -103.664    18.177
>
  -103.690    19.180
  -103.664    18.177
>
  -103.345    18.289
  -102.423    18.211
>
  -103.345    18.289
  -102.423    18.211
>
  -103.345    18.289
  -103.178    18.159
>
  -103.345    18.289
  -103.178    18.159
>
  -103.345    18.289
  -103.049    18.413
>
  -103.345    18.289
  -103.049    18.413
>
  -103.690    19.180
  -103.049    18.413
>
  -103.690    19.180
  -103.049    18.413
>
  -102.311    19.349
  -102.206    18.774
>
  -102.311    19.349
  -102.206    18.774
>
  -102.074    19.422
  -102.206    18.774
>
  -102.074    19.422
  -102.206    18.774
>
  -102.057    19.635
  -102.206    18.774
>
  -102.057    19.635
  -102.206    18.774
>
  -103.345    18.289
  -103.221    18.139
>
  -103.345    18.289
  -103.221    18.139
>
  -102.057    19.635
  -102.405    19.672
>
  -102.057    19.635
  -102.405    19.672
>
  -102.311    19.349
  -102.405    19.672
>
  -102.311    19.349
  -102.405    19.672
>
  -102.074    19.422
  -102.405    19.672
>
  -102.074    19.422
  -102.405    19.672
>
  -103.345    18.289
  -102.988    18.637
>
  -103.345    18.289
  -102.988    18.637
>
  -103.690    19.180
  -102.988    18.637
>
  -103.690    19.180
  -102.988    18.637
>
  -103.693    19.326
  -102.988    18.637
>
  -103.693    19.326
  -102.988    18.637
>
  -102.311    19.349
  -102.988    18.637
>
  -102.311    19.349
  -102.988    18.637
>
  -103.550    19.471
  -102.988    18.637
>
  -103.550    19.471
  -102.988    18.637
>
  -103.345    18.289
  -103.204    18.188
>
  -103.345    18.289
  -103.204    18.188
>
  -103.345    18.289
  -103.033    18.742
>
  -103.345    18.289
  -103.033    18.742
>
  -103.690    19.180
  -103.033    18.742
>
  -103.690    19.180
  -103.033    18.742
>
  -103.693    19.326
  -103.033    18.742
>
  -103.693    19.326
  -103.033    18.742
>
  -103.578    19.485
  -103.033    18.742
>
  -103.578    19.485
  -103.033    18.742
>
  -102.311    19.349
  -103.033    18.742
>
  -102.311    19.349
  -103.033    18.742
>
  -103.543    19.532
  -103.033    18.742
>
  -103.543    19.532
  -103.033    18.742
>
  -103.604    19.525
  -103.033    18.742
>
  -103.604    19.525
  -103.033    18.742
>
  -103.617    19.566
  -103.033    18.742
>
  -103.617    19.566
  -103.033    18.742
>
  -103.630    19.554
  -103.033    18.742
>
  -103.630    19.554
  -103.033    18.742
>
  -103.345    18.289
  -103.122    18.370
>
  -103.345    18.289
  -103.122    18.370
>
  -103.690    19.180
  -103.122    18.370
>
  -103.690    19.180
  -103.122    18.370
>
  -103.690    19.180
  -104.097    18.532
>
  -103.690    19.180
  -104.097    18.532
>
  -103.345    18.289
  -104.097    18.532
>
  -103.345    18.289
  -104.097    18.532
>
  -103.693    19.326
  -104.097    18.532
>
  -103.857    19.391
  -104.097    18.532
>
  -103.857    19.391
  -104.097    18.532
>
  -104.735    19.265
  -104.097    18.532
>
  -104.735    19.265
  -104.097    18.532
>
  -103.690    19.180
  -103.747    19.225
>
  -103.690    19.180
  -103.747    19.225
>
  -103.857    19.391
  -103.747    19.225
>
  -103.857    19.391
  -103.747    19.225
>
  -103.578    19.485
  -103.747    19.225
>
  -103.578    19.485
  -103.747    19.225
>
  -103.604    19.525
  -103.747    19.225
>
  -103.604    19.525
  -103.747    19.225
>
  -103.617    19.566
  -103.747    19.225
>
  -103.617    19.566
  -103.747    19.225
>
  -103.488    19.854
  -103.747    19.225
>
  -103.488    19.854
  -103.747    19.225
>
  -104.735    19.265
  -103.747    19.225
>
  -104.735    19.265
  -103.747    19.225
>
  -103.630    19.554
  -103.747    19.225
>
  -102.311    19.349
  -102.581    19.484
>
  -102.311    19.349
  -102.581    19.484
>
  -102.074    19.422
  -102.581    19.484
>
  -103.460    19.723
  -102.581    19.484
>
  -103.460    19.723
  -102.581    19.484
>
  -103.543    19.532
  -102.581    19.484
>
  -103.543    19.532
  -102.581    19.484
>
  -103.488    19.854
  -102.581    19.484
>
  -103.488    19.854
  -102.581    19.484
>
  -103.578    19.485
  -102.581    19.484
>
  -103.578    19.485
  -102.581    19.484
>
  -103.604    19.525
  -102.581    19.484
>
  -103.604    19.525
  -102.581    19.484
>
  -103.617    19.566
  -102.581    19.484
>
  -103.617    19.566
  -102.581    19.484
>
  -103.630    19.554
  -102.581    19.484
>
  -103.630    19.554
  -102.581    19.484
>
  -103.345    18.289
  -103.570    18.156
>
  -103.345    18.289
  -103.570    18.156
>
  -102.311    19.349
  -102.515    19.496
>
  -102.311    19.349
  -102.515    19.496
>
  -102.074    19.422
  -102.515    19.496
>
  -102.074    19.422
  -102.515    19.496
>
  -102.057    19.635
  -102.515    19.496
>
  -102.057    19.635
  -102.515    19.496
>
  -103.543    19.532
  -102.515    19.496
>
  -103.543    19.532
  -102.515    19.496
>
  -103.488    19.854
  -102.515    19.496
>
  -103.488    19.854
  -102.515    19.496
>
  -101.465    17.607
  -102.153    18.193
>
  -101.465    17.607
  -102.153    18.193
>
  -103.345    18.289
  -103.219    18.463
>
  -103.345    18.289
  -103.219    18.463
>
  -103.690    19.180
  -103.219    18.463
>
  -103.693    19.326
  -103.219    18.463
>
  -103.693    19.326
  -103.219    18.463
>
  -103.345    18.289
  -103.300    18.521
>
  -103.345    18.289
  -103.300    18.521
>
  -103.690    19.180
  -103.300    18.521
>
  -103.690    19.180
  -103.300    18.521
>
  -103.693    19.326
  -103.300    18.521
>
  -103.693    19.326
  -103.300    18.521
>
  -103.761    19.325
  -103.300    18.521
>
  -103.761    19.325
  -103.300    18.521
>
  -103.578    19.485
  -103.300    18.521
>
  -103.578    19.485
  -103.300    18.521
>
  -103.857    19.391
  -103.758    19.368
>
  -103.857    19.391
  -103.758    19.368
>
  -103.761    19.325
  -103.758    19.368
>
  -103.761    19.325
  -103.758    19.368
>
  -103.693    19.326
  -103.758    19.368
>
  -103.693    19.326
  -103.758    19.368
>
  -103.604    19.525
  -103.758    19.368
>
  -103.604    19.525
  -103.758    19.368
>
  -103.578    19.485
  -103.758    19.368
>
  -103.578    19.485
  -103.758    19.368
>
  -103.690    19.180
  -103.758    19.368
>
  -103.690    19.180
  -103.758    19.368
>
  -103.617    19.566
  -103.758    19.368
>
  -103.617    19.566
  -103.758    19.368
>
  -103.543    19.532
  -103.758    19.368
>
  -103.543    19.532
  -103.758    19.368
>
  -103.730    19.738
  -103.758    19.368
>
  -103.730    19.738
  -103.758    19.368
>
  -103.460    19.723
  -103.758    19.368
>
  -103.460    19.723
  -103.758    19.368
>
  -103.488    19.854
  -103.758    19.368
>
  -103.650    19.955
  -103.758    19.368
>
  -103.650    19.955
  -103.758    19.368
>
  -103.345    18.289
  -102.509    18.495
>
  -103.345    18.289
  -102.509    18.495
>
  -102.311    19.349
  -102.509    18.495
>
  -102.311    19.349
  -102.509    18.495
>
  -103.345    18.289
  -102.996    18.081
>
  -103.345    18.289
  -102.996    18.081
>
  -103.690    19.180
  -103.764    19.204
>
  -103.690    19.180
  -103.764    19.204
>
  -103.761    19.325
  -103.764    19.204
>
  -103.761    19.325
  -103.764    19.204
>
  -103.693    19.326
  -103.764    19.204
>
  -103.693    19.326
  -103.764    19.204
>
  -103.857    19.391
  -103.764    19.204
>
  -103.857    19.391
  -103.764    19.204
>
  -103.578    19.485
  -103.764    19.204
>
  -103.578    19.485
  -103.764    19.204
>
  -103.550    19.471
  -103.764    19.204
>
  -103.550    19.471
  -103.764    19.204
>
  -103.604    19.525
  -103.764    19.204
>
  -103.604    19.525
  -103.764    19.204
>
  -103.617    19.566
  -103.764    19.204
>
  -103.617    19.566
  -103.764    19.204
>
  -103.543    19.532
  -103.764    19.204
>
  -103.543    19.532
  -103.764    19.204
>
  -103.730    19.738
  -103.764    19.204
>
  -103.730    19.738
  -103.764    19.204
>
  -103.460    19.723
  -103.764    19.204
>
  -103.460    19.723
  -103.764    19.204
>
  -103.488    19.854
  -103.764    19.204
>
  -103.488    19.854
  -103.764    19.204
>
  -103.650    19.955
  -103.764    19.204
>
  -103.650    19.955
  -103.764    19.204
>
  -104.735    19.265
  -103.764    19.204
>
  -104.735    19.265
  -103.764    19.204
>
  -103.345    18.289
  -103.764    19.204
>
  -103.345    18.289
  -103.764    19.204
>
  -102.311    19.349
  -102.282    18.755
>
  -102.311    19.349
  -102.282    18.755
>
  -102.074    19.422
  -102.282    18.755
>
  -102.074    19.422
  -102.282    18.755
>
  -102.057    19.635
  -102.282    18.755
>
  -102.057    19.635
  -102.282    18.755
>
  -103.345    18.289
  -103.288    18.170
>
  -103.345    18.289
  -103.288    18.170
>
  -102.311    19.349
  -102.472    19.213
>
  -102.311    19.349
  -102.472    19.213
>
  -102.311    19.349
  -102.429    19.567
>
  -102.311    19.349
  -102.429    19.567
>
  -102.074    19.422
  -102.429    19.567
>
  -102.074    19.422
  -102.429    19.567
>
  -102.311    19.349
  -102.110    18.699
>
  -102.311    19.349
  -102.110    18.699
>
  -102.074    19.422
  -102.110    18.699
>
  -102.074    19.422
  -102.110    18.699
>
  -102.057    19.635
  -102.110    18.699
>
  -102.057    19.635
  -102.110    18.699
>
  -103.345    18.289
  -102.856    18.389
>
  -103.345    18.289
  -102.856    18.389
>
  -102.311    19.349
  -102.415    19.579
>
  -102.311    19.349
  -102.415    19.579
>
  -102.057    19.635
  -102.415    19.579
>
  -102.057    19.635
  -102.415    19.579
>
  -102.074    19.422
  -102.415    19.579
>
  -102.074    19.422
  -102.415    19.579
>
  -103.345    18.289
  -103.255    18.256
>
  -103.345    18.289
  -103.255    18.256
>
  -102.311    19.349
  -102.474    19.593
>
  -102.311    19.349
  -102.474    19.593
>
  -102.057    19.635
  -102.474    19.593
>
  -102.057    19.635
  -102.474    19.593
>
  -102.074    19.422
  -102.474    19.593
>
  -102.074    19.422
  -102.474    19.593
>
  -103.460    19.723
  -102.474    19.593
>
  -103.488    19.854
  -102.474    19.593
>
  -103.488    19.854
  -102.474    19.593
>
  -102.311    19.349
  -102.556    19.497
>
  -102.311    19.349
  -102.556    19.497
>
  -102.074    19.422
  -102.556    19.497
>
  -102.074    19.422
  -102.556    19.497
>
  -102.057    19.635
  -102.556    19.497
>
  -102.057    19.635
  -102.556    19.497
>
  -103.543    19.532
  -102.556    19.497
>
  -103.543    19.532
  -102.556    19.497
>
  -103.550    19.471
  -102.556    19.497
>
  -103.488    19.854
  -102.556    19.497
>
  -103.488    19.854
  -102.556    19.497
>
  -103.578    19.485
  -102.556    19.497
>
  -103.578    19.485
  -102.556    19.497
>
  -103.604    19.525
  -102.556    19.497
>
  -103.604    19.525
  -102.556    19.497
>
  -101.516    17.639
  -102.319    18.021
>
  -101.516    17.639
  -102.319    18.021
>
  -101.465    17.607
  -102.319    18.021
>
  -101.465    17.607
  -102.319    18.021
>
  -103.345    18.289
  -103.218    18.563
>
  -103.345    18.289
  -103.218    18.563
>
  -103.690    19.180
  -103.218    18.563
>
  -103.690    19.180
  -103.218    18.563
>
  -103.693    19.326
  -103.218    18.563
>
  -103.693    19.326
  -103.218    18.563
>
  -103.761    19.325
  -103.218    18.563
>
  -103.761    19.325
  -103.218    18.563
>
  -103.550    19.471
  -103.218    18.563
>
  -103.550    19.471
  -103.218    18.563
>
  -103.578    19.485
  -103.218    18.563
>
  -103.578    19.485
  -103.218    18.563
>
  -103.602    19.479
  -103.218    18.563
>
  -103.602    19.479
  -103.218    18.563
>
  -103.345    18.289
  -103.369    18.347
>
  -103.345    18.289
  -103.369    18.347
>
  -103.690    19.180
  -103.369    18.347
>
  -103.690    19.180
  -103.369    18.347
>
  -102.311    19.349
  -102.165    18.643
>
  -102.311    19.349
  -102.165    18.643
>
  -102.074    19.422
  -102.165    18.643
>
  -102.074    19.422
  -102.165    18.643
>
  -102.057    19.635
  -102.165    18.643
>
  -102.057    19.635
  -102.165    18.643
>
  -103.345    18.289
  -102.462    18.406
>
  -103.345    18.289
  -102.462    18.406
>
  -102.311    19.349
  -102.462    18.406
>
  -102.311    19.349
  -102.462    18.406
>
  -101.815    17.970
  -102.343    18.140
>
  -101.815    17.970
  -102.343    18.140
>
  -101.465    17.607
  -102.343    18.140
>
  -101.465    17.607
  -102.343    18.140
>
  -103.345    18.289
  -102.343    18.140
>
  -103.345    18.289
  -102.343    18.140
>
  -103.857    19.391
  -104.020    19.415
>
  -103.857    19.391
  -104.020    19.415
>
  -103.761    19.325
  -104.020    19.415
>
  -103.761    19.325
  -104.020    19.415
>
  -103.693    19.326
  -104.020    19.415
>
  -103.693    19.326
  -104.020    19.415
>
  -103.690    19.180
  -104.020    19.415
>
  -103.690    19.180
  -104.020    19.415
>
  -103.602    19.479
  -104.020    19.415
>
  -103.602    19.479
  -104.020    19.415
>
  -104.316    19.139
  -104.020    19.415
>
  -104.316    19.139
  -104.020    19.415
>
  -103.604    19.525
  -104.020    19.415
>
  -103.604    19.525
  -104.020    19.415
>
  -103.617    19.566
  -104.020    19.415
>
  -103.617    19.566
  -104.020    19.415
>
  -103.578    19.485
  -104.020    19.415
>
  -103.578    19.485
  -104.020    19.415
>
  -103.550    19.471
  -104.020    19.415
>
  -103.730    19.738
  -104.020    19.415
>
  -103.730    19.738
  -104.020    19.415
>
  -103.460    19.723
  -104.020    19.415
>
  -103.460    19.723
  -104.020    19.415
>
  -103.650    19.955
  -104.020    19.415
>
  -103.650    19.955
  -104.020    19.415
>
  -103.488    19.854
  -104.020    19.415
>
  -103.488    19.854
  -104.020    19.415
>
  -104.735    19.265
  -104.020    19.415
>
  -104.735    19.265
  -104.020    19.415
>
  -105.043    19.499
  -104.020    19.415
>
  -105.043    19.499
  -104.020    19.415
>
  -103.630    19.554
  -104.020    19.415
>
  -103.630    19.554
  -104.020    19.415
>
  -103.690    19.180
  -103.787    19.015
>
  -103.761    19.325
  -103.787    19.015
>
  -103.761    19.325
  -103.787    19.015
>
  -103.693    19.326
  -103.787    19.015
>
  -103.693    19.326
  -103.787    19.015
>
  -103.857    19.391
  -103.787    19.015
>
  -103.857    19.391
  -103.787    19.015
>
  -104.316    19.139
  -103.787    19.015
>
  -104.316    19.139
  -103.787    19.015
>
  -103.602    19.479
  -103.787    19.015
>
  -103.602    19.479
  -103.787    19.015
>
  -103.550    19.471
  -103.787    19.015
>
  -103.550    19.471
  -103.787    19.015
>
  -103.578    19.485
  -103.787    19.015
>
  -103.578    19.485
  -103.787    19.015
>
  -103.604    19.525
  -103.787    19.015
>
  -103.604    19.525
  -103.787    19.015
>
  -103.543    19.532
  -103.787    19.015
>
  -103.543    19.532
  -103.787    19.015
>
  -103.617    19.566
  -103.787    19.015
>
  -103.617    19.566
  -103.787    19.015
>
  -103.730    19.738
  -103.787    19.015
>
  -103.345    18.289
  -103.787    19.015
>
  -103.345    18.289
  -103.787    19.015
>
  -103.488    19.854
  -103.787    19.015
>
  -103.488    19.854
  -103.787    19.015
>
  -104.735    19.265
  -103.787    19.015
>
  -104.735    19.265
  -103.787    19.015
>
  -103.650    19.955
  -103.787    19.015
>
  -103.650    19.955
  -103.787    19.015
>
  -103.630    19.554
  -103.787    19.015
>
  -103.345    18.289
  -103.323    18.182
>
  -103.345    18.289
  -103.323    18.182
>
  -103.345    18.289
  -102.400    18.411
>
  -103.345    18.289
  -102.400    18.411
>
  -102.311    19.349
  -102.400    18.411
>
  -102.311    19.349
  -102.400    18.411
>
  -103.345    18.289
  -102.969    18.344
>
  -103.345    18.289
  -102.969    18.344
>
  -102.311    19.349
  -102.202    19.354
>
  -102.311    19.349
  -102.202    19.354
>
  -101.484    19.219
  -102.202    19.354
>
  -101.484    19.219
  -102.202    19.354
>
  -101.227    19.647
  -102.202    19.354
>
  -101.227    19.647
  -102.202    19.354
>
  -103.345    18.289
  -102.933    18.595
>
  -103.345    18.289
  -102.933    18.595
>
  -103.690    19.180
  -102.933    18.595
>
  -103.690    19.180
  -102.933    18.595
>
  -102.311    19.349
  -102.933    18.595
>
  -102.311    19.349
  -102.933    18.595
>
  -102.311    19.349
  -102.393    19.617
>
  -102.311    19.349
  -102.393    19.617
>
  -103.761    19.325
  -103.386    18.457
>
  -103.761    19.325
  -103.386    18.457
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -101.882    18.275     0.300
  -102.750    18.053     0.300
  -103.691    19.181     0.300
  -103.691    19.181     0.300
  -103.462    19.703     0.300
  -104.331    19.054     0.300
  -101.465    17.607     0.300
  -103.345    18.289     0.300
  -103.983    19.170     0.300
  -103.602    19.479     0.300
  -103.690    19.180     0.300
  -101.815    17.970     0.300
  -104.011    18.941     0.300
  -102.074    19.422     0.300
  -103.570    19.515     0.300
  -103.620    19.466     0.300
  -103.604    19.525     0.300
  -103.630    19.524     0.300
  -103.761    19.325     0.300
  -103.857    19.391     0.300
  -104.735    19.265     0.300
  -101.227    19.647     0.300
  -102.311    19.349     0.300
  -102.057    19.635     0.300
  -103.693    19.326     0.300
  -103.550    19.471     0.300
  -103.578    19.485     0.300
  -103.543    19.532     0.300
  -103.617    19.566     0.300
  -103.630    19.554     0.300
  -103.488    19.854     0.300
  -103.460    19.723     0.300
  -103.730    19.738     0.300
  -103.650    19.955     0.300
  -101.516    17.639     0.300
  -104.316    19.139     0.300
  -105.043    19.499     0.300
  -101.484    19.219     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -103.598    18.783     0.200
>
  -103.486    18.412     0.200
>
  -103.017    18.317     0.200
>
  -102.594    17.967     0.200
>
  -102.745    18.272     0.200
>
  -103.633    18.443     0.200
>
  -103.228    18.088     0.200
>
  -103.290    18.009     0.200
>
  -103.310    18.465     0.200
>
  -103.242    18.218     0.200
>
  -103.985    18.494     0.200
>
  -103.645    19.248     0.200
>
  -103.118    17.880     0.200
>
  -102.373    18.021     0.200
>
  -104.159    19.071     0.200
>
  -102.489    18.331     0.200
>
  -103.090    18.061     0.200
>
  -102.149    17.813     0.200
>
  -102.587    17.710     0.200
>
  -102.350    18.476     0.200
>
  -102.757    18.388     0.200
>
  -103.134    18.546     0.200
>
  -102.635    18.118     0.200
>
  -102.699    17.983     0.200
>
  -102.870    17.922     0.200
>
  -102.964    18.010     0.200
>
  -103.230    17.996     0.200
>
  -102.782    17.989     0.200
>
  -103.164    18.190     0.200
>
  -103.324    18.169     0.200
>
  -103.211    18.125     0.200
>
  -103.337    18.262     0.200
>
  -102.799    17.988     0.200
>
  -102.482    18.633     0.200
>
  -103.335    18.532     0.200
>
  -102.399    18.323     0.200
>
  -102.581    18.224     0.200
>
  -103.584    18.844     0.200
>
  -103.272    18.314     0.200
>
  -103.039    18.487     0.200
>
  -103.495    19.128     0.200
>
  -103.448    18.570     0.200
>
  -102.241    18.440     0.200
>
  -103.648    19.271     0.200
>
  -102.863    18.110     0.200
>
  -102.888    18.036     0.200
>
  -102.559    18.003     0.200
>
  -102.697    18.047     0.200
>
  -102.642    17.892     0.200
>
  -103.167    18.934     0.200
>
  -102.611    18.147     0.200
>
  -102.947    18.013     0.200
>
  -104.173    18.624     0.200
>
  -102.581    18.044     0.200
>
  -102.504    18.075     0.200
>
  -102.548    18.014     0.200
>
  -102.674    18.011     0.200
>
  -102.588    17.991     0.200
>
  -102.735    18.037     0.200
>
  -102.572    18.051     0.200
>
  -102.135    18.770     0.200
>
  -102.675    18.116     0.200
>
  -102.477    18.074     0.200
>
  -102.411    17.833     0.200
>
  -103.990    18.697     0.200
>
  -102.419    18.236     0.200
>
  -102.267    17.907     0.200
>
  -102.860    18.157     0.200
>
  -103.511    17.975     0.200
>
  -102.800    18.220     0.200
>
  -103.018    18.067     0.200
>
  -103.469    18.342     0.200
>
  -102.524    18.329     0.200
>
  -104.081    18.614     0.200
>
  -103.551    18.403     0.200
>
  -102.471    18.753     0.200
>
  -104.113    18.641     0.200
>
  -102.888    18.063     0.200
>
  -104.016    18.835     0.200
>
  -102.933    18.406     0.200
>
  -102.879    18.643     0.200
>
  -102.341    18.402     0.200
>
  -102.635    17.954     0.200
>
  -102.609    18.409     0.200
>
  -102.275    18.083     0.200
>
  -103.264    18.527     0.200
>
  -102.907    18.044     0.200
>
  -103.066    18.395     0.200
>
  -102.331    18.325     0.200
>
  -102.180    18.002     0.200
>
  -102.951    18.976     0.200
>
  -102.354    18.327     0.200
>
  -103.709    18.553     0.200
>
  -102.921    18.083     0.200
>
  -103.562    18.333     0.200
>
  -102.639    18.387     0.200
>
  -103.894    18.574     0.200
>
  -102.592    18.446     0.200
>
  -102.159    18.049     0.200
>
  -103.416    18.244     0.200
>
  -104.036    18.539     0.200
>
  -103.663    19.367     0.200
>
  -102.015    18.155     0.200
>
  -102.382    17.983     0.200
>
  -102.910    18.447     0.200
>
  -103.431    18.253     0.200
>
  -104.278    19.128     0.200
>
  -104.037    18.610     0.200
>
  -102.726    18.119     0.200
>
  -102.745    18.175     0.200
>
  -103.459    18.301     0.200
>
  -103.119    18.499     0.200
>
  -103.425    18.260     0.200
>
  -103.344    18.333     0.200
>
  -102.443    18.465     0.200
>
  -102.396    18.083     0.200
>
  -103.100    18.457     0.200
>
  -102.551    18.549     0.200
>
  -102.382    18.309     0.200
>
  -103.088    18.512     0.200
>
  -102.361    18.349     0.200
>
  -103.318    18.240     0.200
>
  -103.312    18.296     0.200
>
  -102.513    18.745     0.200
>
  -102.184    18.605     0.200
>
  -102.793    19.136     0.200
>
  -103.292    18.233     0.200
>
  -103.546    19.457     0.200
>
  -102.042    18.325     0.200
>
  -103.247    18.199     0.200
>
  -102.637    17.892     0.200
>
  -102.726    19.037     0.200
>
  -103.345    18.273     0.200
>
  -103.309    18.218     0.200
>
  -103.880    18.931     0.200
>
  -103.394    18.319     0.200
>
  -103.031    18.399     0.200
>
  -102.670    17.942     0.200
>
  -102.261    18.710     0.200
>
  -103.240    18.979     0.200
>
  -102.805    18.493     0.200
>
  -103.664    18.657     0.200
>
  -102.374    19.059     0.200
>
  -103.121    18.451     0.200
>
  -104.086    18.886     0.200
>
  -102.525    18.080     0.200
>
  -103.071    18.448     0.200
>
  -102.326    17.951     0.200
>
  -102.751    18.581     0.200
>
  -102.618    18.363     0.200
>
  -102.528    18.375     0.200
>
  -102.053    18.866     0.200
>
  -103.460    18.343     0.200
>
  -103.478    18.280     0.200
>
  -103.999    18.513     0.200
>
  -102.300    18.000     0.200
>
  -103.157    18.323     0.200
>
  -103.335    19.025     0.200
>
  -102.109    18.028     0.200
>
  -102.418    18.358     0.200
>
  -103.007    18.799     0.200
>
  -102.935    18.492     0.200
>
  -102.338    19.447     0.200
>
  -102.335    18.037     0.200
>
  -102.345    19.474     0.200
>
  -103.156    18.506     0.200
>
  -103.832    19.437     0.200
>
  -103.222    18.501     0.200
>
  -103.363    18.343     0.200
>
  -103.392    18.316     0.200
>
  -102.869    18.061     0.200
>
  -102.344    19.393     0.200
>
  -103.468    18.341     0.200
>
  -103.283    18.182     0.200
>
  -102.334    18.602     0.200
>
  -102.818    17.996     0.200
>
  -103.388    18.231     0.200
>
  -103.171    18.476     0.200
>
  -103.300    18.564     0.200
>
  -102.252    18.226     0.200
>
  -102.696    18.777     0.200
>
  -102.321    19.498     0.200
>
  -102.221    19.551     0.200
>
  -102.665    18.046     0.200
>
  -102.304    18.627     0.200
>
  -102.188    18.298     0.200
>
  -102.269    19.486     0.200
>
  -102.267    19.432     0.200
>
  -102.334    18.415     0.200
>
  -103.120    18.070     0.200
>
  -102.403    18.391     0.200
>
  -102.456    18.370     0.200
>
  -102.111    18.203     0.200
>
  -102.868    18.352     0.200
>
  -102.432    18.688     0.200
>
  -102.429    18.252     0.200
>
  -103.222    18.229     0.200
>
  -102.236    18.370     0.200
>
  -103.399    18.307     0.200
>
  -103.255    18.289     0.200
>
  -103.850    18.441     0.200
>
  -103.204    18.151     0.200
>
  -103.154    18.127     0.200
>
  -103.271    18.344     0.200
>
  -103.162    18.190     0.200
>
  -103.642    18.339     0.200
>
  -103.120    18.152     0.200
>
  -103.822    18.535     0.200
>
  -103.209    18.281     0.200
>
  -103.238    18.227     0.200
>
  -103.094    18.128     0.200
>
  -103.033    18.206     0.200
>
  -103.165    18.334     0.200
>
  -103.715    18.394     0.200
>
  -103.276    18.220     0.200
>
  -103.307    18.260     0.200
>
  -103.234    18.600     0.200
>
  -103.483    18.585     0.200
>
  -103.419    18.639     0.200
>
  -103.408    18.417     0.200
>
  -103.250    18.243     0.200
>
  -103.131    17.826     0.200
>
  -103.199    18.358     0.200
>
  -103.106    18.281     0.200
>
  -102.817    18.677     0.200
>
  -103.126    18.172     0.200
>
  -102.547    19.572     0.200
>
  -103.298    18.459     0.200
>
  -102.521    19.492     0.200
>
  -103.146    18.302     0.200
>
  -103.100    18.221     0.200
>
  -102.532    19.546     0.200
>
  -102.560    19.575     0.200
>
  -102.468    19.446     0.200
>
  -102.535    19.475     0.200
>
  -103.267    18.284     0.200
>
  -102.490    19.471     0.200
>
  -102.508    19.542     0.200
>
  -103.188    18.361     0.200
>
  -102.248    18.095     0.200
>
  -103.290    18.566     0.200
>
  -103.204    18.405     0.200
>
  -102.569    19.504     0.200
>
  -103.309    18.330     0.200
>
  -102.456    19.522     0.200
>
  -102.446    19.602     0.200
>
  -102.241    18.116     0.200
>
  -103.228    18.557     0.200
>
  -102.387    19.604     0.200
>
  -102.414    19.594     0.200
>
  -102.410    19.597     0.200
>
  -102.403    19.601     0.200
>
  -102.609    18.467     0.200
>
  -102.501    19.519     0.200
>
  -102.615    18.073     0.200
>
  -102.574    19.493     0.200
>
  -103.343    18.109     0.200
>
  -103.179    18.409     0.200
>
  -102.782    17.983     0.200
>
  -103.688    19.449     0.200
>
  -103.226    18.361     0.200
>
  -103.235    18.572     0.200
>
  -102.563    19.485     0.200
>
  -102.939    18.825     0.200
>
  -102.554    19.561     0.200
>
  -102.840    18.205     0.200
>
  -102.143    18.050     0.200
>
  -103.305    18.537     0.200
>
  -103.664    18.177     0.200
>
  -102.423    18.211     0.200
>
  -103.178    18.159     0.200
>
  -103.049    18.413     0.200
>
  -102.206    18.774     0.200
>
  -103.221    18.139     0.200
>
  -102.405    19.672     0.200
>
  -102.988    18.637     0.200
>
  -103.204    18.188     0.200
>
  -103.033    18.742     0.200
>
  -103.122    18.370     0.200
>
  -104.097    18.532     0.200
>
  -103.747    19.225     0.200
>
  -102.581    19.484     0.200
>
  -103.570    18.156     0.200
>
  -102.515    19.496     0.200
>
  -102.153    18.193     0.200
>
  -103.219    18.463     0.200
>
  -103.300    18.521     0.200
>
  -103.758    19.368     0.200
>
  -102.509    18.495     0.200
>
  -102.996    18.081     0.200
>
  -103.764    19.204     0.200
>
  -102.282    18.755     0.200
>
  -103.288    18.170     0.200
>
  -102.472    19.213     0.200
>
  -102.429    19.567     0.200
>
  -102.110    18.699     0.200
>
  -102.856    18.389     0.200
>
  -102.415    19.579     0.200
>
  -103.255    18.256     0.200
>
  -102.474    19.593     0.200
>
  -102.556    19.497     0.200
>
  -102.319    18.021     0.200
>
  -103.218    18.563     0.200
>
  -103.369    18.347     0.200
>
  -102.165    18.643     0.200
>
  -102.462    18.406     0.200
>
  -102.343    18.140     0.200
>
  -104.020    19.415     0.200
>
  -103.787    19.015     0.200
>
  -103.323    18.182     0.200
>
  -102.400    18.411     0.200
>
  -102.969    18.344     0.200
>
  -102.202    19.354     0.200
>
  -102.933    18.595     0.200
>
  -102.393    19.617     0.200
>
  -103.281    18.572     0.200
>
  -103.268    18.553     0.200
>
  -103.313    18.529     0.200
>
  -103.386    18.457     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -102.940    18.509     0.000   222.000   222.000
  -102.940    18.509     0.000   444.000   444.000
EOF
gmt end
