#!/bin/bash
gmt begin caleta1.47_base pdf,ps
proj=-JM16.0c+
reg=-R-104.4/-101.9/17.6/19.8
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map caleta1.47'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Cross-section locations
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -102.940    18.509    31.000 145.0k
EOF
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
  -102.940    18.509    31.000 -86.9k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -102.940    18.509   121.000 2.5k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
  -102.940    18.509   121.000 -2.5k
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -103.598    18.783 1
  -103.486    18.412 2
  -103.017    18.317 3
  -102.594    17.967 4
  -102.745    18.272 5
  -103.633    18.443 6
  -103.228    18.088 7
  -103.290    18.009 8
  -103.310    18.465 9
  -103.242    18.218 10
  -103.985    18.494 11
  -103.645    19.248 12
  -103.118    17.880 13
  -102.373    18.021 14
  -104.159    19.071 15
  -102.489    18.331 16
  -103.090    18.061 17
  -102.149    17.813 18
  -102.587    17.710 19
  -102.350    18.476 20
  -102.757    18.388 21
  -103.134    18.546 22
  -102.635    18.118 23
  -102.699    17.983 24
  -102.870    17.922 25
  -102.964    18.010 26
  -103.230    17.996 27
  -102.782    17.989 28
  -103.164    18.190 29
  -103.324    18.169 30
  -103.211    18.125 31
  -103.337    18.262 32
  -102.799    17.988 33
  -102.482    18.633 34
  -103.335    18.532 35
  -102.399    18.323 36
  -102.581    18.224 37
  -103.584    18.844 38
  -103.272    18.314 39
  -103.039    18.487 40
  -103.495    19.128 41
  -103.448    18.570 42
  -102.241    18.440 43
  -103.648    19.271 44
  -102.863    18.110 45
  -102.888    18.036 46
  -102.559    18.003 47
  -102.697    18.047 48
  -102.642    17.892 49
  -103.167    18.934 50
  -102.611    18.147 51
  -102.947    18.013 52
  -104.173    18.624 53
  -102.581    18.044 54
  -102.504    18.075 55
  -102.548    18.014 56
  -102.674    18.011 57
  -102.588    17.991 58
  -102.735    18.037 59
  -102.572    18.051 60
  -102.135    18.770 61
  -102.675    18.116 62
  -102.477    18.074 63
  -102.411    17.833 64
  -103.990    18.697 65
  -102.419    18.236 66
  -102.267    17.907 67
  -102.860    18.157 68
  -103.511    17.975 69
  -102.800    18.220 70
  -103.018    18.067 71
  -103.469    18.342 72
  -102.524    18.329 73
  -104.081    18.614 74
  -103.551    18.403 75
  -102.471    18.753 76
  -104.113    18.641 77
  -102.888    18.063 78
  -104.016    18.835 79
  -102.933    18.406 80
  -102.879    18.643 81
  -102.341    18.402 82
  -102.635    17.954 83
  -102.609    18.409 84
  -102.275    18.083 85
  -103.264    18.527 86
  -102.907    18.044 87
  -103.066    18.395 88
  -102.331    18.325 89
  -102.180    18.002 90
  -102.951    18.976 91
  -102.354    18.327 92
  -103.709    18.553 93
  -102.921    18.083 94
  -103.562    18.333 95
  -102.639    18.387 96
  -103.894    18.574 97
  -102.592    18.446 98
  -102.159    18.049 99
  -103.416    18.244 100
  -104.036    18.539 101
  -103.663    19.367 102
  -102.015    18.155 103
  -102.382    17.983 104
  -102.910    18.447 105
  -103.431    18.253 106
  -104.278    19.128 107
  -104.037    18.610 108
  -102.726    18.119 109
  -102.745    18.175 110
  -103.459    18.301 111
  -103.119    18.499 112
  -103.425    18.260 113
  -103.344    18.333 114
  -102.443    18.465 115
  -102.396    18.083 116
  -103.100    18.457 117
  -102.551    18.549 118
  -102.382    18.309 119
  -103.088    18.512 120
  -102.361    18.349 121
  -103.318    18.240 122
  -103.312    18.296 123
  -102.513    18.745 124
  -102.184    18.605 125
  -102.793    19.136 126
  -103.292    18.233 127
  -103.546    19.457 128
  -102.042    18.325 129
  -103.247    18.199 130
  -102.637    17.892 131
  -102.726    19.037 132
  -103.345    18.273 133
  -103.309    18.218 134
  -103.880    18.931 135
  -103.394    18.319 136
  -103.031    18.399 137
  -102.670    17.942 138
  -102.261    18.710 139
  -103.240    18.979 140
  -102.805    18.493 141
  -103.664    18.657 142
  -102.374    19.059 143
  -103.121    18.451 144
  -104.086    18.886 145
  -102.525    18.080 146
  -103.071    18.448 147
  -102.326    17.951 148
  -102.751    18.581 149
  -102.618    18.363 150
  -102.528    18.375 151
  -102.053    18.866 152
  -103.460    18.343 153
  -103.478    18.280 154
  -103.999    18.513 155
  -102.300    18.000 156
  -103.157    18.323 157
  -103.335    19.025 158
  -102.109    18.028 159
  -102.418    18.358 160
  -103.007    18.799 161
  -102.935    18.492 162
  -102.338    19.447 163
  -102.335    18.037 164
  -102.345    19.474 165
  -103.156    18.506 166
  -103.832    19.437 167
  -103.222    18.501 168
  -103.363    18.343 169
  -103.392    18.316 170
  -102.869    18.061 171
  -102.344    19.393 172
  -103.468    18.341 173
  -103.283    18.182 174
  -102.334    18.602 175
  -102.818    17.996 176
  -103.388    18.231 177
  -103.171    18.476 178
  -103.300    18.564 179
  -102.252    18.226 180
  -102.696    18.777 181
  -102.321    19.498 182
  -102.221    19.551 183
  -102.665    18.046 184
  -102.304    18.627 185
  -102.188    18.298 186
  -102.269    19.486 187
  -102.267    19.432 188
  -102.334    18.415 189
  -103.120    18.070 190
  -102.403    18.391 191
  -102.456    18.370 192
  -102.111    18.203 193
  -102.868    18.352 194
  -102.432    18.688 195
  -102.429    18.252 196
  -103.222    18.229 197
  -102.236    18.370 198
  -103.399    18.307 199
  -103.255    18.289 200
  -103.850    18.441 201
  -103.204    18.151 202
  -103.154    18.127 203
  -103.271    18.344 204
  -103.162    18.190 205
  -103.642    18.339 206
  -103.120    18.152 207
  -103.822    18.535 208
  -103.209    18.281 209
  -103.238    18.227 210
  -103.094    18.128 211
  -103.033    18.206 212
  -103.165    18.334 213
  -103.715    18.394 214
  -103.276    18.220 215
  -103.307    18.260 216
  -103.234    18.600 217
  -103.483    18.585 218
  -103.419    18.639 219
  -103.408    18.417 220
  -103.250    18.243 221
  -103.131    17.826 222
  -103.199    18.358 223
  -103.106    18.281 224
  -102.817    18.677 225
  -103.126    18.172 226
  -102.547    19.572 227
  -103.298    18.459 228
  -102.521    19.492 229
  -103.146    18.302 230
  -103.100    18.221 231
  -102.532    19.546 232
  -102.560    19.575 233
  -102.468    19.446 234
  -102.535    19.475 235
  -103.267    18.284 236
  -102.490    19.471 237
  -102.508    19.542 238
  -103.188    18.361 239
  -102.248    18.095 240
  -103.290    18.566 241
  -103.204    18.405 242
  -102.569    19.504 243
  -103.309    18.330 244
  -102.456    19.522 245
  -102.446    19.602 246
  -102.241    18.116 247
  -103.228    18.557 248
  -102.387    19.604 249
  -102.414    19.594 250
  -102.410    19.597 251
  -102.403    19.601 252
  -102.609    18.467 253
  -102.501    19.519 254
  -102.615    18.073 255
  -102.574    19.493 256
  -103.343    18.109 257
  -103.179    18.409 258
  -102.782    17.983 259
  -103.688    19.449 260
  -103.226    18.361 261
  -103.235    18.572 262
  -102.563    19.485 263
  -102.939    18.825 264
  -102.554    19.561 265
  -102.840    18.205 266
  -102.143    18.050 267
  -103.305    18.537 268
  -103.664    18.177 269
  -102.423    18.211 270
  -103.178    18.159 271
  -103.049    18.413 272
  -102.206    18.774 273
  -103.221    18.139 274
  -102.405    19.672 275
  -102.988    18.637 276
  -103.204    18.188 277
  -103.033    18.742 278
  -103.122    18.370 279
  -104.097    18.532 280
  -103.747    19.225 281
  -102.581    19.484 282
  -103.570    18.156 283
  -102.515    19.496 284
  -102.153    18.193 285
  -103.219    18.463 286
  -103.300    18.521 287
  -103.758    19.368 288
  -102.509    18.495 289
  -102.996    18.081 290
  -103.764    19.204 291
  -102.282    18.755 292
  -103.288    18.170 293
  -102.472    19.213 294
  -102.429    19.567 295
  -102.110    18.699 296
  -102.856    18.389 297
  -102.415    19.579 298
  -103.255    18.256 299
  -102.474    19.593 300
  -102.556    19.497 301
  -102.319    18.021 302
  -103.218    18.563 303
  -103.369    18.347 304
  -102.165    18.643 305
  -102.462    18.406 306
  -102.343    18.140 307
  -104.020    19.415 308
  -103.787    19.015 309
  -103.323    18.182 310
  -102.400    18.411 311
  -102.969    18.344 312
  -102.202    19.354 313
  -102.933    18.595 314
  -102.393    19.617 315
  -103.281    18.572 316
  -103.268    18.553 317
  -103.313    18.529 318
  -103.386    18.457 319
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -103.345    19.333
  -103.598    18.783
>
  -103.415    18.356
  -103.486    18.412
>
  -102.748    18.542
  -103.017    18.317
>
  -102.612    18.114
  -102.594    17.967
>
  -102.566    18.715
  -102.745    18.272
>
  -103.521    18.575
  -103.633    18.443
>
  -102.991    18.373
  -103.228    18.088
>
  -103.005    18.319
  -103.290    18.009
>
  -103.126    18.697
  -103.310    18.465
>
  -103.041    18.417
  -103.242    18.218
>
  -104.022    18.556
  -103.985    18.494
>
  -103.493    19.530
  -103.645    19.248
>
  -102.883    18.251
  -103.118    17.880
>
  -102.261    18.247
  -102.373    18.021
>
  -103.978    19.310
  -104.159    19.071
>
  -102.341    18.444
  -102.489    18.331
>
  -102.958    18.264
  -103.090    18.061
>
  -102.125    17.975
  -102.149    17.813
>
  -102.486    17.864
  -102.587    17.710
>
  -102.364    18.461
  -102.350    18.476
>
  -102.719    18.426
  -102.757    18.388
>
  -103.089    18.568
  -103.134    18.546
>
  -102.523    18.233
  -102.635    18.118
>
  -102.538    18.143
  -102.699    17.983
>
  -102.630    17.993
  -102.870    17.922
>
  -102.955    17.990
  -102.964    18.010
>
  -103.077    17.952
  -103.230    17.996
>
  -102.730    17.977
  -102.782    17.989
>
  -102.988    18.368
  -103.164    18.190
>
  -103.131    18.260
  -103.324    18.169
>
  -103.148    18.023
  -103.211    18.125
>
  -103.236    18.369
  -103.337    18.262
>
  -102.758    17.934
  -102.799    17.988
>
  -102.440    18.841
  -102.482    18.633
>
  -103.161    18.699
  -103.335    18.532
>
  -102.400    18.504
  -102.399    18.323
>
  -102.505    18.230
  -102.581    18.224
>
  -103.747    18.882
  -103.584    18.844
>
  -103.276    18.319
  -103.272    18.314
>
  -103.076    18.394
  -103.039    18.487
>
  -103.525    19.361
  -103.495    19.128
>
  -103.433    18.610
  -103.448    18.570
>
  -102.183    18.419
  -102.241    18.440
>
  -103.473    19.303
  -103.648    19.271
>
  -102.846    18.128
  -102.863    18.110
>
  -102.795    18.089
  -102.888    18.036
>
  -102.604    17.904
  -102.559    18.003
>
  -102.734    17.993
  -102.697    18.047
>
  -102.699    17.836
  -102.642    17.892
>
  -103.200    18.952
  -103.167    18.934
>
  -102.495    18.240
  -102.611    18.147
>
  -102.975    17.935
  -102.947    18.013
>
  -104.062    18.761
  -104.173    18.624
>
  -102.654    18.012
  -102.581    18.044
>
  -102.515    17.991
  -102.504    18.075
>
  -102.550    17.946
  -102.548    18.014
>
  -102.725    17.970
  -102.674    18.011
>
  -102.718    17.927
  -102.588    17.991
>
  -102.838    17.928
  -102.735    18.037
>
  -102.392    18.201
  -102.572    18.051
>
  -102.244    18.751
  -102.135    18.770
>
  -102.687    18.026
  -102.675    18.116
>
  -102.433    18.086
  -102.477    18.074
>
  -102.367    17.802
  -102.411    17.833
>
  -104.049    18.640
  -103.990    18.697
>
  -102.446    18.177
  -102.419    18.236
>
  -102.292    17.850
  -102.267    17.907
>
  -102.802    18.250
  -102.860    18.157
>
  -103.428    18.076
  -103.511    17.975
>
  -102.886    18.157
  -102.800    18.220
>
  -102.984    18.123
  -103.018    18.067
>
  -103.565    18.179
  -103.469    18.342
>
  -102.557    18.339
  -102.524    18.329
>
  -104.073    18.491
  -104.081    18.614
>
  -103.481    18.369
  -103.551    18.403
>
  -102.514    18.722
  -102.471    18.753
>
  -104.018    18.743
  -104.113    18.641
>
  -102.867    18.157
  -102.888    18.063
>
  -104.008    18.810
  -104.016    18.835
>
  -102.894    18.420
  -102.933    18.406
>
  -102.881    18.652
  -102.879    18.643
>
  -102.403    18.310
  -102.341    18.402
>
  -102.663    17.922
  -102.635    17.954
>
  -102.640    18.386
  -102.609    18.409
>
  -102.304    18.048
  -102.275    18.083
>
  -103.233    18.516
  -103.264    18.527
>
  -103.035    17.860
  -102.907    18.044
>
  -103.037    18.383
  -103.066    18.395
>
  -102.388    18.203
  -102.331    18.325
>
  -102.214    17.933
  -102.180    18.002
>
  -102.903    18.969
  -102.951    18.976
>
  -102.329    18.318
  -102.354    18.327
>
  -103.775    18.567
  -103.709    18.553
>
  -102.876    18.204
  -102.921    18.083
>
  -103.583    18.295
  -103.562    18.333
>
  -102.653    18.316
  -102.639    18.387
>
  -103.910    18.566
  -103.894    18.574
>
  -102.614    18.406
  -102.592    18.446
>
  -102.198    18.041
  -102.159    18.049
>
  -103.414    18.161
  -103.416    18.244
>
  -104.011    18.542
  -104.036    18.539
>
  -103.720    19.381
  -103.663    19.367
>
  -102.106    17.959
  -102.015    18.155
>
  -102.343    18.076
  -102.382    17.983
>
  -102.870    18.399
  -102.910    18.447
>
  -103.471    18.206
  -103.431    18.253
>
  -104.058    19.179
  -104.278    19.128
>
  -104.081    18.556
  -104.037    18.610
>
  -102.770    18.031
  -102.726    18.119
>
  -102.746    18.006
  -102.745    18.175
>
  -103.516    18.105
  -103.459    18.301
>
  -103.134    18.468
  -103.119    18.499
>
  -103.405    18.217
  -103.425    18.260
>
  -103.479    18.138
  -103.344    18.333
>
  -102.482    18.363
  -102.443    18.465
>
  -102.422    17.954
  -102.396    18.083
>
  -103.134    18.251
  -103.100    18.457
>
  -102.595    18.409
  -102.551    18.549
>
  -102.339    18.245
  -102.382    18.309
>
  -103.031    18.511
  -103.088    18.512
>
  -102.362    18.183
  -102.361    18.349
>
  -103.352    18.212
  -103.318    18.240
>
  -103.206    18.242
  -103.312    18.296
>
  -102.554    18.653
  -102.513    18.745
>
  -102.240    18.423
  -102.184    18.605
>
  -102.784    19.079
  -102.793    19.136
>
  -103.252    18.148
  -103.292    18.233
>
  -103.425    19.373
  -103.546    19.457
>
  -102.115    18.203
  -102.042    18.325
>
  -103.366    18.088
  -103.247    18.199
>
  -102.647    17.820
  -102.637    17.892
>
  -102.646    18.906
  -102.726    19.037
>
  -103.262    18.223
  -103.345    18.273
>
  -103.202    18.233
  -103.309    18.218
>
  -103.894    18.955
  -103.880    18.931
>
  -103.259    18.330
  -103.394    18.319
>
  -103.116    18.265
  -103.031    18.399
>
  -102.660    17.810
  -102.670    17.942
>
  -102.277    18.644
  -102.261    18.710
>
  -103.283    18.950
  -103.240    18.979
>
  -102.760    18.398
  -102.805    18.493
>
  -103.797    18.507
  -103.664    18.657
>
  -102.343    19.111
  -102.374    19.059
>
  -103.094    18.389
  -103.121    18.451
>
  -104.083    18.907
  -104.086    18.886
>
  -102.554    17.940
  -102.525    18.080
>
  -103.137    18.335
  -103.071    18.448
>
  -102.328    17.815
  -102.326    17.951
>
  -102.754    18.433
  -102.751    18.581
>
  -102.656    18.214
  -102.618    18.363
>
  -102.535    18.222
  -102.528    18.375
>
  -102.104    18.790
  -102.053    18.866
>
  -103.545    18.204
  -103.460    18.343
>
  -103.407    18.162
  -103.478    18.280
>
  -104.030    18.426
  -103.999    18.513
>
  -102.202    18.151
  -102.300    18.000
>
  -103.271    18.115
  -103.157    18.323
>
  -103.402    19.010
  -103.335    19.025
>
  -102.144    17.938
  -102.109    18.028
>
  -102.458    18.170
  -102.418    18.358
>
  -102.975    18.686
  -103.007    18.799
>
  -102.974    18.382
  -102.935    18.492
>
  -102.190    19.539
  -102.338    19.447
>
  -102.365    17.835
  -102.335    18.037
>
  -102.277    19.503
  -102.345    19.474
>
  -103.195    18.422
  -103.156    18.506
>
  -103.861    19.396
  -103.832    19.437
>
  -103.236    18.428
  -103.222    18.501
>
  -103.363    18.300
  -103.363    18.343
>
  -103.473    18.195
  -103.392    18.316
>
  -102.932    17.962
  -102.869    18.061
>
  -102.274    19.557
  -102.344    19.393
>
  -103.487    18.263
  -103.468    18.341
>
  -103.307    18.139
  -103.283    18.182
>
  -102.389    18.474
  -102.334    18.602
>
  -102.822    18.004
  -102.818    17.996
>
  -103.281    18.349
  -103.388    18.231
>
  -103.236    18.374
  -103.171    18.476
>
  -103.254    18.548
  -103.300    18.564
>
  -102.200    18.194
  -102.252    18.226
>
  -102.751    18.704
  -102.696    18.777
>
  -102.230    19.574
  -102.321    19.498
>
  -102.121    19.554
  -102.221    19.551
>
  -102.639    18.004
  -102.665    18.046
>
  -102.342    18.505
  -102.304    18.627
>
  -102.256    18.112
  -102.188    18.298
>
  -102.182    19.438
  -102.269    19.486
>
  -102.225    19.381
  -102.267    19.432
>
  -102.335    18.311
  -102.334    18.415
>
  -103.104    18.073
  -103.120    18.070
>
  -102.367    18.281
  -102.403    18.391
>
  -102.521    18.245
  -102.456    18.370
>
  -102.142    18.008
  -102.111    18.203
>
  -102.924    18.240
  -102.868    18.352
>
  -102.520    18.552
  -102.432    18.688
>
  -102.461    18.194
  -102.429    18.252
>
  -103.150    18.212
  -103.222    18.229
>
  -102.253    18.322
  -102.236    18.370
>
  -103.442    18.202
  -103.399    18.307
>
  -103.120    18.392
  -103.255    18.289
>
  -103.859    18.447
  -103.850    18.441
>
  -103.160    18.196
  -103.204    18.151
>
  -103.202    18.021
  -103.154    18.127
>
  -103.349    18.250
  -103.271    18.344
>
  -103.100    18.163
  -103.162    18.190
>
  -103.608    18.396
  -103.642    18.339
>
  -103.004    18.176
  -103.120    18.152
>
  -103.867    18.505
  -103.822    18.535
>
  -103.275    18.225
  -103.209    18.281
>
  -103.678    18.159
  -103.238    18.227
>
  -102.978    18.252
  -103.094    18.128
>
  -103.065    18.135
  -103.033    18.206
>
  -103.248    18.216
  -103.165    18.334
>
  -103.700    18.384
  -103.715    18.394
>
  -103.139    18.281
  -103.276    18.220
>
  -103.383    18.158
  -103.307    18.260
>
  -103.304    18.421
  -103.234    18.600
>
  -103.660    18.451
  -103.483    18.585
>
  -103.422    18.611
  -103.419    18.639
>
  -103.364    18.392
  -103.408    18.417
>
  -103.188    18.243
  -103.250    18.243
>
  -103.121    17.847
  -103.131    17.826
>
  -103.312    18.300
  -103.199    18.358
>
  -103.119    18.166
  -103.106    18.281
>
  -102.834    18.631
  -102.817    18.677
>
  -103.132    18.022
  -103.126    18.172
>
  -102.456    19.398
  -102.547    19.572
>
  -103.551    18.103
  -103.298    18.459
>
  -102.386    19.631
  -102.521    19.492
>
  -103.270    18.102
  -103.146    18.302
>
  -103.091    18.075
  -103.100    18.221
>
  -102.508    19.469
  -102.532    19.546
>
  -102.518    19.437
  -102.560    19.575
>
  -102.440    19.390
  -102.468    19.446
>
  -102.505    19.491
  -102.535    19.475
>
  -103.240    18.212
  -103.267    18.284
>
  -102.487    19.586
  -102.490    19.471
>
  -102.518    19.494
  -102.508    19.542
>
  -103.221    18.266
  -103.188    18.361
>
  -102.209    18.023
  -102.248    18.095
>
  -103.385    18.462
  -103.290    18.566
>
  -103.299    18.228
  -103.204    18.405
>
  -102.537    19.538
  -102.569    19.504
>
  -103.309    18.228
  -103.309    18.330
>
  -102.390    19.560
  -102.456    19.522
>
  -102.380    19.566
  -102.446    19.602
>
  -102.285    18.087
  -102.241    18.116
>
  -103.170    18.462
  -103.228    18.557
>
  -102.333    19.597
  -102.387    19.604
>
  -102.395    19.587
  -102.414    19.594
>
  -102.405    19.601
  -102.410    19.597
>
  -102.348    19.597
  -102.403    19.601
>
  -102.532    18.513
  -102.609    18.467
>
  -102.448    19.531
  -102.501    19.519
>
  -102.605    17.896
  -102.615    18.073
>
  -102.549    19.527
  -102.574    19.493
>
  -103.387    17.997
  -103.343    18.109
>
  -103.314    18.179
  -103.179    18.409
>
  -102.934    17.813
  -102.782    17.983
>
  -103.813    19.364
  -103.688    19.449
>
  -103.345    18.174
  -103.226    18.361
>
  -103.230    18.501
  -103.235    18.572
>
  -102.416    19.498
  -102.563    19.485
>
  -103.014    18.761
  -102.939    18.825
>
  -102.528    19.548
  -102.554    19.561
>
  -102.818    18.019
  -102.840    18.205
>
  -102.159    17.908
  -102.143    18.050
>
  -103.265    18.484
  -103.305    18.537
>
  -103.563    18.228
  -103.664    18.177
>
  -102.402    18.129
  -102.423    18.211
>
  -103.221    18.049
  -103.178    18.159
>
  -103.016    18.369
  -103.049    18.413
>
  -102.223    18.721
  -102.206    18.774
>
  -103.244    18.024
  -103.221    18.139
>
  -102.416    19.718
  -102.405    19.672
>
  -103.016    18.571
  -102.988    18.637
>
  -103.289    18.085
  -103.204    18.188
>
  -103.034    18.686
  -103.033    18.742
>
  -103.234    18.159
  -103.122    18.370
>
  -104.061    18.548
  -104.097    18.532
>
  -103.768    19.249
  -103.747    19.225
>
  -102.519    19.528
  -102.581    19.484
>
  -103.237    18.164
  -103.570    18.156
>
  -102.458    19.510
  -102.515    19.496
>
  -102.128    18.108
  -102.153    18.193
>
  -103.209    18.431
  -103.219    18.463
>
  -103.252    18.480
  -103.300    18.521
>
  -103.831    19.401
  -103.758    19.368
>
  -102.534    18.369
  -102.509    18.495
>
  -103.096    17.993
  -102.996    18.081
>
  -103.788    19.155
  -103.764    19.204
>
  -102.285    18.714
  -102.282    18.755
>
  -103.274    18.063
  -103.288    18.170
>
  -102.522    19.165
  -102.472    19.213
>
  -102.232    19.061
  -102.429    19.567
>
  -102.113    18.641
  -102.110    18.699
>
  -102.831    18.371
  -102.856    18.389
>
  -102.378    19.551
  -102.415    19.579
>
  -103.306    18.156
  -103.255    18.256
>
  -102.505    19.565
  -102.474    19.593
>
  -102.547    19.473
  -102.556    19.497
>
  -102.342    17.999
  -102.319    18.021
>
  -103.212    18.550
  -103.218    18.563
>
  -103.368    18.304
  -103.369    18.347
>
  -102.169    18.621
  -102.165    18.643
>
  -102.441    18.257
  -102.462    18.406
>
  -102.369    18.030
  -102.343    18.140
>
  -103.994    19.388
  -104.020    19.415
>
  -103.785    18.957
  -103.787    19.015
>
  -103.161    18.173
  -103.323    18.182
>
  -102.450    18.307
  -102.400    18.411
>
  -103.013    18.210
  -102.969    18.344
>
  -102.226    19.231
  -102.202    19.354
>
  -102.919    18.472
  -102.933    18.595
>
  -102.377    19.530
  -102.393    19.617
>
  -103.363    18.502
  -103.281    18.572
>
  -103.334    18.493
  -103.268    18.553
>
  -103.449    18.503
  -103.313    18.529
>
  -103.388    18.466
  -103.386    18.457
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -103.591    18.810
  -103.598    18.783
>
  -103.481    18.423
  -103.486    18.412
>
  -103.014    18.322
  -103.017    18.317
>
  -102.589    17.976
  -102.594    17.967
>
  -102.742    18.284
  -102.745    18.272
>
  -103.628    18.452
  -103.633    18.443
>
  -103.224    18.095
  -103.228    18.088
>
  -103.286    18.024
  -103.290    18.009
>
  -103.323    18.416
  -103.310    18.465
>
  -103.242    18.217
  -103.242    18.218
>
  -103.975    18.506
  -103.985    18.494
>
  -103.641    19.255
  -103.645    19.248
>
  -103.091    17.896
  -103.118    17.880
>
  -102.369    18.031
  -102.373    18.021
>
  -104.181    19.053
  -104.159    19.071
>
  -102.488    18.334
  -102.489    18.331
>
  -103.085    18.067
  -103.090    18.061
>
  -102.146    17.822
  -102.149    17.813
>
  -102.582    17.711
  -102.587    17.710
>
  -102.346    18.469
  -102.350    18.476
>
  -102.753    18.391
  -102.757    18.388
>
  -103.133    18.547
  -103.134    18.546
>
  -102.633    18.120
  -102.635    18.118
>
  -102.697    17.985
  -102.699    17.983
>
  -102.868    17.925
  -102.870    17.922
>
  -102.962    18.010
  -102.964    18.010
>
  -103.226    18.006
  -103.230    17.996
>
  -102.780    17.992
  -102.782    17.989
>
  -103.160    18.200
  -103.164    18.190
>
  -103.347    18.132
  -103.324    18.169
>
  -103.208    18.130
  -103.211    18.125
>
  -103.332    18.266
  -103.337    18.262
>
  -102.794    17.995
  -102.799    17.988
>
  -102.478    18.635
  -102.482    18.633
>
  -103.333    18.537
  -103.335    18.532
>
  -102.397    18.326
  -102.399    18.323
>
  -102.577    18.233
  -102.581    18.224
>
  -103.584    18.850
  -103.584    18.844
>
  -103.271    18.315
  -103.272    18.314
>
  -103.038    18.485
  -103.039    18.487
>
  -103.491    19.133
  -103.495    19.128
>
  -103.446    18.568
  -103.448    18.570
>
  -102.242    18.435
  -102.241    18.440
>
  -103.641    19.273
  -103.648    19.271
>
  -102.858    18.118
  -102.863    18.110
>
  -102.888    18.049
  -102.888    18.036
>
  -102.555    18.004
  -102.559    18.003
>
  -102.691    18.065
  -102.697    18.047
>
  -102.642    17.896
  -102.642    17.892
>
  -103.165    18.939
  -103.167    18.934
>
  -102.610    18.144
  -102.611    18.147
>
  -102.924    18.023
  -102.947    18.013
>
  -104.177    18.615
  -104.173    18.624
>
  -102.578    18.048
  -102.581    18.044
>
  -102.506    18.088
  -102.504    18.075
>
  -102.551    18.026
  -102.548    18.014
>
  -102.680    18.003
  -102.674    18.011
>
  -102.588    17.989
  -102.588    17.991
>
  -102.739    18.031
  -102.735    18.037
>
  -102.569    18.054
  -102.572    18.051
>
  -102.138    18.782
  -102.135    18.770
>
  -102.673    18.118
  -102.675    18.116
>
  -102.473    18.077
  -102.477    18.074
>
  -102.408    17.835
  -102.411    17.833
>
  -103.994    18.686
  -103.990    18.697
>
  -102.418    18.233
  -102.419    18.236
>
  -102.265    17.910
  -102.267    17.907
>
  -102.854    18.166
  -102.860    18.157
>
  -103.510    17.977
  -103.511    17.975
>
  -102.800    18.221
  -102.800    18.220
>
  -103.017    18.068
  -103.018    18.067
>
  -103.472    18.345
  -103.469    18.342
>
  -102.522    18.331
  -102.524    18.329
>
  -104.080    18.615
  -104.081    18.614
>
  -103.549    18.405
  -103.551    18.403
>
  -102.469    18.754
  -102.471    18.753
>
  -104.110    18.645
  -104.113    18.641
>
  -102.888    18.066
  -102.888    18.063
>
  -104.016    18.835
  -104.016    18.835
>
  -102.934    18.409
  -102.933    18.406
>
  -102.878    18.643
  -102.879    18.643
>
  -102.341    18.401
  -102.341    18.402
>
  -102.634    17.956
  -102.635    17.954
>
  -102.608    18.411
  -102.609    18.409
>
  -102.274    18.085
  -102.275    18.083
>
  -103.264    18.527
  -103.264    18.527
>
  -102.906    18.044
  -102.907    18.044
>
  -103.066    18.395
  -103.066    18.395
>
  -102.331    18.323
  -102.331    18.325
>
  -102.180    18.001
  -102.180    18.002
>
  -102.949    18.977
  -102.951    18.976
>
  -102.353    18.329
  -102.354    18.327
>
  -103.708    18.555
  -103.709    18.553
>
  -102.920    18.085
  -102.921    18.083
>
  -103.561    18.335
  -103.562    18.333
>
  -102.639    18.387
  -102.639    18.387
>
  -103.892    18.575
  -103.894    18.574
>
  -102.592    18.445
  -102.592    18.446
>
  -102.157    18.051
  -102.159    18.049
>
  -103.415    18.245
  -103.416    18.244
>
  -104.034    18.540
  -104.036    18.539
>
  -103.661    19.366
  -103.663    19.367
>
  -102.014    18.156
  -102.015    18.155
>
  -102.381    17.985
  -102.382    17.983
>
  -102.909    18.447
  -102.910    18.447
>
  -103.430    18.254
  -103.431    18.253
>
  -104.277    19.124
  -104.278    19.128
>
  -104.037    18.610
  -104.037    18.610
>
  -102.725    18.120
  -102.726    18.119
>
  -102.748    18.173
  -102.745    18.175
>
  -103.458    18.303
  -103.459    18.301
>
  -103.118    18.499
  -103.119    18.499
>
  -103.424    18.260
  -103.425    18.260
>
  -103.342    18.334
  -103.344    18.333
>
  -102.443    18.465
  -102.443    18.465
>
  -102.400    18.082
  -102.396    18.083
>
  -103.099    18.456
  -103.100    18.457
>
  -102.551    18.548
  -102.551    18.549
>
  -102.382    18.309
  -102.382    18.309
>
  -103.087    18.513
  -103.088    18.512
>
  -102.360    18.348
  -102.361    18.349
>
  -103.317    18.241
  -103.318    18.240
>
  -103.312    18.297
  -103.312    18.296
>
  -102.513    18.744
  -102.513    18.745
>
  -102.184    18.603
  -102.184    18.605
>
  -102.793    19.136
  -102.793    19.136
>
  -103.291    18.233
  -103.292    18.233
>
  -103.547    19.457
  -103.546    19.457
>
  -102.042    18.325
  -102.042    18.325
>
  -103.247    18.199
  -103.247    18.199
>
  -102.638    17.891
  -102.637    17.892
>
  -102.726    19.036
  -102.726    19.037
>
  -103.345    18.273
  -103.345    18.273
>
  -103.309    18.219
  -103.309    18.218
>
  -103.880    18.931
  -103.880    18.931
>
  -103.394    18.319
  -103.394    18.319
>
  -103.030    18.398
  -103.031    18.399
>
  -102.671    17.940
  -102.670    17.942
>
  -102.261    18.708
  -102.261    18.710
>
  -103.240    18.979
  -103.240    18.979
>
  -102.804    18.493
  -102.805    18.493
>
  -103.663    18.658
  -103.664    18.657
>
  -102.374    19.058
  -102.374    19.059
>
  -103.131    18.441
  -103.121    18.451
>
  -104.086    18.886
  -104.086    18.886
>
  -102.524    18.081
  -102.525    18.080
>
  -103.071    18.447
  -103.071    18.448
>
  -102.325    17.951
  -102.326    17.951
>
  -102.749    18.582
  -102.751    18.581
>
  -102.618    18.363
  -102.618    18.363
>
  -102.531    18.371
  -102.528    18.375
>
  -102.053    18.867
  -102.053    18.866
>
  -103.461    18.343
  -103.460    18.343
>
  -103.476    18.281
  -103.478    18.280
>
  -103.999    18.514
  -103.999    18.513
>
  -102.302    17.996
  -102.300    18.000
>
  -103.156    18.324
  -103.157    18.323
>
  -103.335    19.025
  -103.335    19.025
>
  -102.110    18.027
  -102.109    18.028
>
  -102.418    18.357
  -102.418    18.358
>
  -103.008    18.799
  -103.007    18.799
>
  -102.935    18.492
  -102.935    18.492
>
  -102.337    19.448
  -102.338    19.447
>
  -102.335    18.037
  -102.335    18.037
>
  -102.345    19.474
  -102.345    19.474
>
  -103.154    18.506
  -103.156    18.506
>
  -103.829    19.436
  -103.832    19.437
>
  -103.222    18.501
  -103.222    18.501
>
  -103.362    18.344
  -103.363    18.343
>
  -103.392    18.315
  -103.392    18.316
>
  -102.869    18.061
  -102.869    18.061
>
  -102.339    19.395
  -102.344    19.393
>
  -103.467    18.341
  -103.468    18.341
>
  -103.280    18.183
  -103.283    18.182
>
  -102.333    18.600
  -102.334    18.602
>
  -102.818    17.995
  -102.818    17.996
>
  -103.387    18.230
  -103.388    18.231
>
  -103.169    18.477
  -103.171    18.476
>
  -103.299    18.565
  -103.300    18.564
>
  -102.252    18.226
  -102.252    18.226
>
  -102.694    18.779
  -102.696    18.777
>
  -102.320    19.498
  -102.321    19.498
>
  -102.221    19.553
  -102.221    19.551
>
  -102.665    18.046
  -102.665    18.046
>
  -102.304    18.626
  -102.304    18.627
>
  -102.187    18.298
  -102.188    18.298
>
  -102.269    19.487
  -102.269    19.486
>
  -102.267    19.433
  -102.267    19.432
>
  -102.333    18.415
  -102.334    18.415
>
  -103.119    18.071
  -103.120    18.070
>
  -102.403    18.391
  -102.403    18.391
>
  -102.455    18.370
  -102.456    18.370
>
  -102.110    18.203
  -102.111    18.203
>
  -102.868    18.354
  -102.868    18.352
>
  -102.432    18.687
  -102.432    18.688
>
  -102.429    18.252
  -102.429    18.252
>
  -103.222    18.228
  -103.222    18.229
>
  -102.236    18.369
  -102.236    18.370
>
  -103.398    18.306
  -103.399    18.307
>
  -103.255    18.289
  -103.255    18.289
>
  -103.850    18.441
  -103.850    18.441
>
  -103.204    18.149
  -103.204    18.151
>
  -103.156    18.126
  -103.154    18.127
>
  -103.270    18.344
  -103.271    18.344
>
  -103.162    18.191
  -103.162    18.190
>
  -103.643    18.339
  -103.642    18.339
>
  -103.120    18.154
  -103.120    18.152
>
  -103.823    18.534
  -103.822    18.535
>
  -103.211    18.285
  -103.209    18.281
>
  -103.228    18.242
  -103.238    18.227
>
  -103.091    18.129
  -103.094    18.128
>
  -103.033    18.206
  -103.033    18.206
>
  -103.166    18.333
  -103.165    18.334
>
  -103.714    18.394
  -103.715    18.394
>
  -103.275    18.222
  -103.276    18.220
>
  -103.307    18.261
  -103.307    18.260
>
  -103.234    18.600
  -103.234    18.600
>
  -103.482    18.585
  -103.483    18.585
>
  -103.419    18.640
  -103.419    18.639
>
  -103.404    18.419
  -103.408    18.417
>
  -103.249    18.244
  -103.250    18.243
>
  -103.125    17.830
  -103.131    17.826
>
  -103.198    18.358
  -103.199    18.358
>
  -103.105    18.283
  -103.106    18.281
>
  -102.817    18.678
  -102.817    18.677
>
  -103.126    18.171
  -103.126    18.172
>
  -102.549    19.572
  -102.547    19.572
>
  -103.297    18.459
  -103.298    18.459
>
  -102.521    19.493
  -102.521    19.492
>
  -103.146    18.302
  -103.146    18.302
>
  -103.099    18.221
  -103.100    18.221
>
  -102.532    19.546
  -102.532    19.546
>
  -102.559    19.575
  -102.560    19.575
>
  -102.468    19.444
  -102.468    19.446
>
  -102.534    19.474
  -102.535    19.475
>
  -103.267    18.284
  -103.267    18.284
>
  -102.487    19.473
  -102.490    19.471
>
  -102.507    19.541
  -102.508    19.542
>
  -103.186    18.362
  -103.188    18.361
>
  -102.248    18.095
  -102.248    18.095
>
  -103.294    18.567
  -103.290    18.566
>
  -103.207    18.403
  -103.204    18.405
>
  -102.569    19.504
  -102.569    19.504
>
  -103.307    18.331
  -103.309    18.330
>
  -102.456    19.522
  -102.456    19.522
>
  -102.447    19.591
  -102.446    19.602
>
  -102.242    18.115
  -102.241    18.116
>
  -103.228    18.557
  -103.228    18.557
>
  -102.387    19.604
  -102.387    19.604
>
  -102.414    19.594
  -102.414    19.594
>
  -102.410    19.597
  -102.410    19.597
>
  -102.404    19.599
  -102.403    19.601
>
  -102.609    18.467
  -102.609    18.467
>
  -102.500    19.518
  -102.501    19.519
>
  -102.615    18.071
  -102.615    18.073
>
  -102.574    19.492
  -102.574    19.493
>
  -103.343    18.108
  -103.343    18.109
>
  -103.179    18.409
  -103.179    18.409
>
  -102.817    17.971
  -102.782    17.983
>
  -103.687    19.449
  -103.688    19.449
>
  -103.226    18.360
  -103.226    18.361
>
  -103.237    18.573
  -103.235    18.572
>
  -102.563    19.485
  -102.563    19.485
>
  -102.939    18.825
  -102.939    18.825
>
  -102.553    19.559
  -102.554    19.561
>
  -102.840    18.205
  -102.840    18.205
>
  -102.144    18.049
  -102.143    18.050
>
  -103.303    18.538
  -103.305    18.537
>
  -103.667    18.176
  -103.664    18.177
>
  -102.422    18.210
  -102.423    18.211
>
  -103.179    18.158
  -103.178    18.159
>
  -103.050    18.412
  -103.049    18.413
>
  -102.211    18.769
  -102.206    18.774
>
  -103.220    18.139
  -103.221    18.139
>
  -102.405    19.672
  -102.405    19.672
>
  -102.988    18.636
  -102.988    18.637
>
  -103.204    18.188
  -103.204    18.188
>
  -103.033    18.740
  -103.033    18.742
>
  -103.122    18.370
  -103.122    18.370
>
  -104.098    18.531
  -104.097    18.532
>
  -103.748    19.226
  -103.747    19.225
>
  -102.581    19.484
  -102.581    19.484
>
  -103.569    18.155
  -103.570    18.156
>
  -102.515    19.496
  -102.515    19.496
>
  -102.153    18.193
  -102.153    18.193
>
  -103.221    18.462
  -103.219    18.463
>
  -103.301    18.520
  -103.300    18.521
>
  -103.758    19.368
  -103.758    19.368
>
  -102.508    18.495
  -102.509    18.495
>
  -102.994    18.082
  -102.996    18.081
>
  -103.765    19.203
  -103.764    19.204
>
  -102.283    18.753
  -102.282    18.755
>
  -103.289    18.170
  -103.288    18.170
>
  -102.473    19.210
  -102.472    19.213
>
  -102.429    19.566
  -102.429    19.567
>
  -102.110    18.698
  -102.110    18.699
>
  -102.858    18.388
  -102.856    18.389
>
  -102.414    19.579
  -102.415    19.579
>
  -103.254    18.256
  -103.255    18.256
>
  -102.473    19.592
  -102.474    19.593
>
  -102.555    19.497
  -102.556    19.497
>
  -102.322    18.017
  -102.319    18.021
>
  -103.218    18.563
  -103.218    18.563
>
  -103.369    18.347
  -103.369    18.347
>
  -102.166    18.641
  -102.165    18.643
>
  -102.461    18.407
  -102.462    18.406
>
  -102.342    18.140
  -102.343    18.140
>
  -104.020    19.415
  -104.020    19.415
>
  -103.787    19.015
  -103.787    19.015
>
  -103.322    18.182
  -103.323    18.182
>
  -102.402    18.411
  -102.400    18.411
>
  -102.968    18.345
  -102.969    18.344
>
  -102.202    19.354
  -102.202    19.354
>
  -102.932    18.595
  -102.933    18.595
>
  -102.393    19.617
  -102.393    19.617
>
  -103.279    18.572
  -103.281    18.572
>
  -103.291    18.530
  -103.268    18.553
>
  -103.313    18.530
  -103.313    18.529
>
  -103.384    18.459
  -103.386    18.457
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -103.598    18.783   -61.080     8.057    10.490
  -103.486    18.412   -45.526     4.131     6.791
  -103.017    18.317   -67.556     5.466     8.091
  -102.594    17.967   -56.985     2.904     4.873
  -102.745    18.272   -69.423     6.214     9.705
  -103.633    18.443   -46.974     3.409     5.797
  -103.228    18.088   -65.965     3.150     4.284
  -103.290    18.009   -85.982     3.621     6.007
  -103.310    18.465   -60.662     6.409     8.982
  -103.242    18.218   -58.308     2.998     4.897
  -103.985    18.494   -57.290     3.650     6.475
  -103.645    19.248   -47.154     8.729    11.631
  -103.118    17.880   -65.309     5.881    12.860
  -102.373    18.021    21.684     3.564     3.831
  -104.159    19.071   -19.277     9.005    10.868
  -102.489    18.331   -58.873     2.553     4.436
  -103.090    18.061   -61.954     2.833     4.736
  -102.149    17.813   -50.354     3.182     6.800
  -102.587    17.710    20.781     0.126     8.640
  -102.350    18.476   -72.491     7.563    11.245
  -102.757    18.388   -43.277     3.194     4.940
  -103.134    18.546   -75.816     2.355     4.784
  -102.635    18.118   -72.439     4.230     8.085
  -102.699    17.983   -54.326     2.258     4.052
  -102.870    17.922   -51.621     3.797     8.968
  -102.964    18.010   -53.531     2.582     5.127
  -103.230    17.996   -69.664     5.247    10.837
  -102.782    17.989   -49.996     3.499     6.146
  -103.164    18.190   -59.830     2.189     3.448
  -103.324    18.169    85.433     3.209     7.389
  -103.211    18.125   -87.249     3.411     7.334
  -103.337    18.262   -51.322     4.729     8.669
  -102.799    17.988   -55.868     2.487     5.069
  -102.482    18.633   -62.462     4.584     8.058
  -103.335    18.532   -69.749     3.194     4.994
  -102.399    18.323   -87.987     3.316     6.439
  -102.581    18.224   -63.665     4.026     7.229
  -103.584    18.844   -88.728     4.395     7.728
  -103.272    18.314   -59.717     3.792     8.068
  -103.039    18.487   -72.135     4.741     6.105
  -103.495    19.128   -60.633     3.496     7.165
  -103.448    18.570   -67.750     3.034     4.745
  -102.241    18.440   -59.470     3.192     5.488
  -103.648    19.271   -50.261     4.801     6.051
  -102.863    18.110   -57.822     2.490     3.141
  -102.888    18.036   -29.130     3.171     4.699
  -102.559    18.003   -76.616     6.705    10.538
  -102.697    18.047   -26.793     2.728     3.745
  -102.642    17.892    87.984     2.874     4.541
  -103.167    18.934   -61.361     2.403     5.197
  -102.611    18.147   -75.382     2.311     3.594
  -102.947    18.013    88.403     2.054     2.796
  -104.173    18.624   -67.825     2.400     6.530
  -102.581    18.044   -59.277     1.672     3.004
  -102.504    18.075   -67.233     2.608     3.358
  -102.548    18.014   -46.766     3.055     4.014
  -102.674    18.011    76.130     3.614     6.306
  -102.588    17.991    87.875     3.265     5.370
  -102.735    18.037    81.356     3.294     6.874
  -102.572    18.051   -66.084     2.953     4.560
  -102.135    18.770   -56.849     6.343     6.688
  -102.675    18.116   -59.595     2.590     4.632
  -102.477    18.074   -66.038     4.730     6.059
  -102.411    17.833   -62.471     3.439     6.740
  -103.990    18.697    87.977     5.128     6.792
  -102.419    18.236   -62.959     4.731    10.480
  -102.267    17.907   -60.833     4.577     9.600
  -102.860    18.157   -50.072     2.957     5.875
  -103.511    17.975   -63.400     3.319     6.533
  -102.800    18.220   -71.470     5.619    10.009
  -103.018    18.067   -59.632     2.051     4.366
  -103.469    18.342   -62.969     5.965     9.484
  -102.524    18.329   -58.277     4.121     5.874
  -104.081    18.614   -58.428     1.964     3.090
  -103.551    18.403   -60.104     1.709     3.620
  -102.471    18.753   -63.075     4.964     6.927
  -104.113    18.641   -56.678     1.271     2.907
  -102.888    18.063   -59.550     1.897     4.147
  -104.016    18.835   -46.142     2.786    10.146
  -102.933    18.406   -66.064     5.833     7.479
  -102.879    18.643   -46.833     2.724     4.497
  -102.341    18.402   -88.570     2.366     6.868
  -102.635    17.954   -61.969     3.407     8.664
  -102.609    18.409   -56.396     2.715     4.000
  -102.275    18.083   -46.877     1.818     3.030
  -103.264    18.527   -27.436     3.486     5.175
  -102.907    18.044   -63.020     2.157     3.372
  -103.066    18.395   -28.108     3.971     4.192
  -102.331    18.325   -72.786     4.181     9.810
  -102.180    18.002   -74.142     4.330    11.151
  -102.951    18.976   -84.813     2.879     4.342
  -102.354    18.327   -88.680     2.814     4.602
  -103.709    18.553   -65.099     1.907     2.956
  -102.921    18.083   -60.258     1.024     1.445
  -103.562    18.333   -77.865     1.606     2.974
  -102.639    18.387   -76.404     4.353     6.464
  -103.894    18.574   -57.601     1.360     1.907
  -102.592    18.446   -83.019     3.560     6.177
  -102.159    18.049   -65.502     1.227     1.560
  -103.416    18.244   -83.300     2.546     5.251
  -104.036    18.539   -65.399     2.489     5.838
  -103.663    19.367   -38.449     4.278     7.171
  -102.015    18.155   -72.874     3.599     8.805
  -102.382    17.983   -80.834     4.122    11.365
  -102.910    18.447   -60.364     4.293     6.512
  -103.431    18.253   -71.690     1.539     2.905
  -104.278    19.128   -61.837     3.138     5.886
  -104.037    18.610   -60.393     1.523     2.288
  -102.726    18.119   -53.590     1.619     2.973
  -102.745    18.175   -70.342     2.749     5.681
  -103.459    18.301   -56.986     1.950     3.908
  -103.119    18.499   -60.775     2.499     3.709
  -103.425    18.260   -60.297     2.226     3.998
  -103.344    18.333   -41.767     2.924     5.844
  -102.443    18.465   -63.183     1.902     5.868
  -102.396    18.083   -66.633     2.114     4.803
  -103.100    18.457   -72.510     3.402     6.369
  -102.551    18.549   -64.490     3.270     5.505
  -102.382    18.309   -63.521     2.446     5.743
  -103.088    18.512   -62.065     2.201     5.359
  -102.361    18.349   -75.262     3.000     4.981
  -103.318    18.240   -64.487     2.401     3.694
  -103.312    18.296   -69.168     2.807     3.781
  -102.513    18.745   -58.863     2.092     5.528
  -102.184    18.605   -67.465     3.800     9.300
  -102.793    19.136    84.453     1.926     2.518
  -103.292    18.233   -58.442     2.596     5.428
  -103.546    19.457   -39.141     2.065     3.791
  -102.042    18.325   -56.597     3.088     7.550
  -103.247    18.199   -52.452     4.322     8.529
  -102.637    17.892   -68.880     2.183     6.625
  -102.726    19.037   -66.323     4.833    10.358
  -103.345    18.273   -43.135     3.868     7.588
  -103.309    18.218   -53.700     3.292     7.462
  -103.880    18.931   -42.761     2.062     3.309
  -103.394    18.319   -59.738     1.288     2.449
  -103.031    18.399   -56.704     3.790     9.135
  -102.670    17.942   -67.241     3.135     9.295
  -102.261    18.710   -56.532     2.534     6.928
  -103.240    18.979   -56.370     3.023     6.277
  -102.805    18.493   -64.848     3.455     5.100
  -103.664    18.657   -49.713     2.967     6.436
  -102.374    19.059   -76.914     4.970    10.111
  -103.121    18.451   -53.204     3.727    10.057
  -104.086    18.886   -44.449     2.026     4.862
  -102.525    18.080   -66.285     3.844    13.477
  -103.071    18.448   -60.690     3.597     8.054
  -102.326    17.951   -72.774     2.726     7.815
  -102.751    18.581    89.925     3.162     4.650
  -102.618    18.363   -62.731     3.511     9.615
  -102.528    18.375   -62.064     2.435     6.205
  -102.053    18.866   -70.017     3.094     7.999
  -103.460    18.343   -48.481     3.255    11.153
  -103.478    18.280   -63.711     2.326     3.693
  -103.999    18.513   -61.526     1.689     2.550
  -102.300    18.000   -69.853     2.108     7.287
  -103.157    18.323   -69.452     3.311    11.003
  -103.335    19.025   -32.352     3.293     5.348
  -102.109    18.028   -59.726     2.623     5.745
  -102.418    18.358   -68.385     4.942    11.528
  -103.007    18.799   -59.012     5.467    11.035
  -102.935    18.492   -78.543     2.705     3.741
  -102.338    19.447   -79.815     3.009     9.122
  -102.335    18.037   -73.407     1.916     6.445
  -102.345    19.474   -73.157     2.669     4.556
  -103.156    18.506   -49.800     2.797     4.851
  -103.832    19.437   -75.486     7.461     8.783
  -103.222    18.501   -54.498     2.432     5.148
  -103.363    18.343   -42.505     3.017     4.920
  -103.392    18.316   -50.211     3.035     6.710
  -102.869    18.061   -64.592     1.796     4.692
  -102.344    19.393   -85.750     2.790     5.660
  -103.468    18.341   -51.859     2.881    10.661
  -103.283    18.182   -59.861     3.412    10.045
  -102.334    18.602   -61.565     2.755     7.512
  -102.818    17.996   -67.779     3.069     9.405
  -103.388    18.231   -52.417     3.703    10.279
  -103.171    18.476   -60.829     2.386     4.375
  -103.300    18.564   -48.660     2.496     3.523
  -102.252    18.226   -51.934     2.713     4.739
  -102.696    18.777   -43.881     1.428     2.528
  -102.321    19.498   -59.105     2.866     4.615
  -102.221    19.551   -80.922     3.851    14.996
  -102.665    18.046   -39.482     1.726     2.962
  -102.304    18.627   -69.207     3.330     6.990
  -102.188    18.298   -62.955     2.473     5.168
  -102.269    19.486   -82.314     2.640     6.794
  -102.267    19.432   -83.580     3.032     5.946
  -102.334    18.415   -70.230     2.432     5.147
  -103.120    18.070   -70.727     1.968     6.177
  -102.403    18.391   -69.369     2.152     4.591
  -102.456    18.370   -47.722     2.194     3.418
  -102.111    18.203   -80.020     1.840     5.397
  -102.868    18.352   -61.729     2.292     3.977
  -102.432    18.688   -71.510     3.345     9.261
  -102.429    18.252   -79.162     2.610     6.438
  -103.222    18.229   -67.775     2.989     5.689
  -102.236    18.370   -72.126     3.169     9.459
  -103.399    18.307   -53.838     4.310     8.078
  -103.255    18.289   -40.002     1.381     2.320
  -103.850    18.441   -38.846     1.587     2.754
  -103.204    18.151   -50.859     2.184     3.910
  -103.154    18.127   -63.994     3.012     7.374
  -103.271    18.344   -41.575     3.347     4.662
  -103.162    18.190   -68.383     2.470     4.621
  -103.642    18.339   -36.731     1.302     2.192
  -103.120    18.152   -52.616     2.671     4.700
  -103.822    18.535   -60.022     7.178    10.535
  -103.209    18.281   -37.565     2.183     3.792
  -103.238    18.227   -66.818     2.925     9.304
  -103.094    18.128   -34.535     1.012     1.737
  -103.033    18.206   -63.347     2.026     6.036
  -103.165    18.334   -60.707     3.006     8.331
  -103.715    18.394   -29.825     1.186     2.065
  -103.276    18.220   -64.881     2.773     5.523
  -103.307    18.260   -47.692     4.566     7.649
  -103.234    18.600   -56.781     3.750     7.788
  -103.483    18.585   -29.998     2.407     5.567
  -103.419    18.639   -36.883     2.965     4.781
  -103.408    18.417   -52.433     1.841     3.503
  -103.250    18.243   -59.073     2.764     6.570
  -103.131    17.826   -57.003     3.927     9.113
  -103.199    18.358   -55.835     3.009    11.258
  -103.106    18.281   -72.099     2.493     5.241
  -102.817    18.677   -66.231     2.570     4.437
  -103.126    18.172   -61.115     2.966     5.853
  -102.547    19.572    60.554     2.424     2.689
  -103.298    18.459   -59.504     4.669    12.598
  -102.521    19.492   -86.106     3.856     6.878
  -103.146    18.302   -77.092     3.677     5.095
  -103.100    18.221   -64.680     2.892     5.213
  -102.532    19.546   -71.569     2.319     4.830
  -102.560    19.575   -82.037     2.439     5.025
  -102.468    19.446   -89.982     2.703     4.880
  -102.535    19.475    75.455     2.740     3.031
  -103.267    18.284   -53.187     3.179     5.936
  -102.490    19.471   -65.214     2.538     4.524
  -102.508    19.542   -26.054     2.190     2.623
  -103.188    18.361   -72.503     2.597     3.589
  -102.248    18.095   -73.244     2.864     6.309
  -103.290    18.566   -51.541     4.650     9.409
  -103.204    18.405   -63.970     2.868     6.865
  -102.569    19.504   -87.264     2.727     6.456
  -103.309    18.330   -51.149     3.380     6.532
  -102.456    19.522   -87.340     3.103     8.035
  -102.446    19.602    89.302     2.954     7.821
  -102.241    18.116   -72.817     2.628     6.775
  -103.228    18.557   -34.709     3.320     5.119
  -102.387    19.604   -68.309     2.795     3.698
  -102.414    19.594   -79.557     2.414     3.154
  -102.410    19.597    82.131     2.862     4.899
  -102.403    19.601   -84.301     3.325     7.108
  -102.609    18.467   -80.492     2.445     4.172
  -102.501    19.519   -88.282     2.662     6.395
  -102.615    18.073   -73.400     3.918     8.544
  -102.574    19.493   -84.761     3.204     8.350
  -103.343    18.109   -52.166     3.354     6.406
  -103.179    18.409   -12.060     4.090     4.439
  -102.782    17.983   -65.108     3.718     6.190
  -103.688    19.449    88.516     3.498     4.366
  -103.226    18.361   -85.278     4.008     4.411
  -103.235    18.572   -57.286     4.130     8.351
  -102.563    19.485   -67.488     2.310     5.145
  -102.939    18.825   -88.302     2.051     2.680
  -102.554    19.561    89.285     2.634     6.085
  -102.840    18.205   -78.499     3.081     5.678
  -102.143    18.050   -71.797     2.212     4.912
  -103.305    18.537   -52.938     5.000    10.575
  -103.664    18.177   -20.705     2.874     3.103
  -102.423    18.211   -57.595     1.684     4.040
  -103.178    18.159   -48.044     2.421     5.387
  -103.049    18.413   -45.162     2.063     5.478
  -102.206    18.774   -53.443     1.742     5.305
  -103.221    18.139   -52.419     3.972     5.931
  -102.405    19.672   -88.748     2.172     4.761
  -102.988    18.637   -48.540     1.823     2.585
  -103.204    18.188   -45.878     2.514     5.633
  -103.033    18.742   -48.499     1.687     5.265
  -103.122    18.370    26.913     2.706     3.292
  -104.097    18.532   -41.392     2.923     5.181
  -103.747    19.225    -7.796     2.513     4.337
  -102.581    19.484   -69.370     1.820     4.938
  -103.570    18.156   -39.564     1.954     5.611
  -102.515    19.496   -75.299     1.658     4.114
  -102.153    18.193   -57.686     2.138     4.731
  -103.219    18.463   -38.450     2.148     4.825
  -103.300    18.521   -36.936     2.943     7.122
  -103.758    19.368    -5.710     2.210     3.329
  -102.509    18.495   -60.822     1.790     2.807
  -102.996    18.081   -59.261     2.352     6.266
  -103.764    19.204   -12.580     4.348     5.313
  -102.282    18.755   -59.024     1.564     4.672
  -103.288    18.170   -42.403     2.593     7.598
  -102.472    19.213   -61.170     2.892     8.907
  -102.429    19.567   -73.396     2.432     6.296
  -102.110    18.699   -59.867     1.263     3.050
  -102.856    18.389   -48.945     1.486     5.035
  -102.415    19.579   -64.434     2.320     5.819
  -103.255    18.256   -28.891     2.766     3.298
  -102.474    19.593   -81.185     2.234     5.292
  -102.556    19.497   -83.038     2.433     6.031
  -102.319    18.021   -52.995     2.068     8.306
  -103.218    18.563   -40.291     1.861     4.607
  -103.369    18.347   -38.962     2.832     8.617
  -102.165    18.643   -56.295     3.024     5.387
  -102.462    18.406   -55.195     2.101     4.331
  -102.343    18.140   -59.688     1.451     3.681
  -104.020    19.415    57.060     1.660     2.951
  -103.787    19.015   -20.886     2.267     2.704
  -103.323    18.182   -48.363     2.307     5.275
  -102.400    18.411   -54.324     2.062     5.619
  -102.969    18.344   -45.139     1.611     5.299
  -102.202    19.354   -64.760     1.467     3.231
  -102.933    18.595    -6.766     2.402     3.589
  -102.393    19.617   -88.319     1.493     3.640
  -103.281    18.572   -29.283     1.615     2.459
  -103.268    18.553   -31.110     1.993     4.110
  -103.313    18.529    -8.747     1.804     2.908
  -103.386    18.457   -73.291     3.433     7.294
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
  -103.242    18.218     0.300
  -102.699    17.983     0.400
  -103.164    18.190     0.200
  -102.863    18.110     0.300
  -102.581    18.044     0.200
  -102.921    18.083     0.200
  -102.159    18.049     0.200
  -103.094    18.128     0.200
  -103.281    18.572     0.200
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -104.321    17.664   -68.077     1.208     1.980
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -104.299    17.664   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -104.321    17.664     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -104.321    17.664     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -104.321    17.619   5 km
EOF
gmt end
