#!/bin/bash
gmt begin bohol1.86_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases bohol1.86'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     3.048
     1.500    -0.467
     2.000    -3.983
     2.500    -7.498
     3.000   -11.014
     3.500   -14.533
     4.000   -18.054
     4.500   -21.578
     5.000   -25.106
     5.500   -28.637
     6.000   -32.172
     6.500   -35.712
     7.000   -39.256
     7.500   -42.807
     8.000   -46.362
     8.500   -49.925
     9.000   -53.493
     9.500   -57.070
    10.000   -60.653
    10.500   -64.245
    11.000   -67.844
    11.500   -71.452
    12.000   -75.070
    12.500   -78.697
    13.000   -82.333
    13.500   -85.978
    14.000   -89.635
    14.500   -93.303
    15.000   -96.981
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -79.333 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.534
     1.000     1.104
     1.500    -0.351
     2.000    -1.806
     2.500    -3.262
     3.000    -4.720
     3.500    -6.179
     4.000    -7.640
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -10.640 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.101     3.516     0.200
   106.244  -725.253     0.200
     2.855    -0.461     0.200
     2.915    -2.225     0.200
     2.708    -0.709     0.200
     2.618    -0.484     0.200
     2.662    -1.272     0.200
     2.769     4.601     0.200
     2.862    -2.185     0.200
     3.134    -0.660     0.200
     2.528     0.011     0.200
     3.140     0.453     0.200
     3.221    -1.429     0.200
     4.148    -1.457     0.200
     3.002    -2.122     0.200
     2.844     3.050     0.200
     4.246    -3.282     0.200
     3.239     1.708     0.200
     3.004     2.568     0.200
     3.129    -0.496     0.200
     3.086     2.428     0.200
     3.129     0.226     0.200
     3.134    -1.554     0.200
     3.052     1.829     0.200
     3.056     0.408     0.200
     3.126    -0.329     0.200
     2.539     0.856     0.200
     3.680    -0.283     0.200
     3.133    -1.437     0.200
     3.547    -1.595     0.200
     2.590     4.210     0.200
     3.046     3.989     0.200
     2.500    -1.179     0.200
     3.146     0.002     0.200
     3.165     4.566     0.200
     3.282     2.882     0.200
     2.956     2.607     0.200
     3.194     2.725     0.200
     4.075    -3.206     0.200
     4.136     2.478     0.200
     3.027     4.438     0.200
     3.002     5.629     0.200
     2.634     2.311     0.200
     3.075     3.274     0.200
     3.170    -1.597     0.200
     4.148    -1.209     0.200
     3.023    -2.774     0.200
     3.296    -2.834     0.200
     4.101    -1.915     0.200
     3.007     4.642     0.200
     3.104    -0.260     0.200
     3.758     3.974     0.200
     3.109     2.797     0.200
     3.196     2.466     0.200
     3.321    -2.746     0.200
     3.173     1.757     0.200
     3.245    -1.254     0.200
     2.697     3.502     0.200
     3.192     2.535     0.200
     3.052    -0.671     0.200
     3.653     2.660     0.200
     3.171     0.902     0.200
     3.135     4.238     0.200
     3.559    -1.564     0.200
     3.178     3.331     0.200
     3.079     3.228     0.200
     3.092     3.143     0.200
     2.567     1.752     0.200
     3.033    -0.037     0.200
     3.127     2.336     0.200
     3.288    -1.824     0.200
     3.180    -0.923     0.200
     3.224     0.637     0.200
     3.271     0.299     0.200
     2.535    -0.271     0.200
     3.361    -0.566     0.200
     2.571    -2.006     0.200
     3.301    -1.313     0.200
     3.183     3.734     0.200
     3.289     3.480     0.200
     3.066     2.096     0.200
     2.997    -0.642     0.200
     3.659    -0.230     0.200
     3.165     2.677     0.200
     3.080     1.734     0.200
     3.253    -2.587     0.200
     3.828     0.582     0.200
     3.123     1.856     0.200
     2.968     4.480     0.200
     3.137    -1.464     0.200
     2.673     1.854     0.200
     2.540    -1.362     0.200
     3.203     3.190     0.200
     3.126    -1.153     0.200
     3.632     4.459     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
    23.235  -158.738     0.200
     1.790    -6.444     0.200
    15.790  -101.228     0.200
    19.838  -134.563     0.200
    20.225  -134.827     0.200
    21.027  -146.243     0.200
     8.075   -52.044     0.200
    20.252  -141.322     0.200
    21.423  -148.422     0.200
    20.301  -138.960     0.200
    16.193  -101.797     0.200
    19.969  -135.320     0.200
     1.910   -10.992     0.200
     1.059     2.430     0.200
     1.883    -4.693     0.200
     1.830    -6.222     0.200
     1.772    -7.092     0.200
    21.040  -144.886     0.200
     1.778    -4.735     0.200
     4.698   -22.308     0.200
     1.694   -10.034     0.200
     2.854   -18.319     0.200
     7.169   -47.098     0.200
     1.868    -3.374     0.200
     1.041     3.761     0.200
     1.364    -0.499     0.200
     2.064    -5.685     0.200
     2.167    -8.961     0.200
     1.360     1.322     0.200
     0.936     2.660     0.200
     2.689    -8.505     0.200
     2.657   -10.396     0.200
     1.190    -0.185     0.200
     1.668    -4.747     0.200
     2.309    -9.485     0.200
     1.211     2.361     0.200
     2.949   -19.333     0.200
     1.323    -3.694     0.200
     1.833    -7.941     0.200
     2.663    -9.334     0.200
     2.687    -9.125     0.200
     1.085     1.467     0.200
     1.454     0.427     0.200
     1.825    -4.228     0.200
     2.207    -7.472     0.200
     2.608   -11.555     0.200
     1.492    -0.296     0.200
     1.681    -4.253     0.200
     2.233    -4.712     0.200
     2.777    -7.879     0.200
     2.941    -9.632     0.200
     3.050   -10.513     0.200
     3.064   -11.463     0.200
     3.744   -15.769     0.200
     4.036   -17.904     0.200
     4.238   -19.537     0.200
     4.666   -25.428     0.200
     6.247   -32.321     0.200
     1.007     2.987     0.200
     1.275     0.404     0.200
     1.722    -4.232     0.200
     2.489    -7.068     0.200
     2.683   -10.219     0.200
     2.829   -11.240     0.200
     4.048   -19.111     0.200
     1.406    -2.267     0.200
     2.405    -9.538     0.200
     2.567    -8.232     0.200
     2.696    -8.092     0.200
     2.965   -12.260     0.200
     3.626   -14.779     0.200
    17.030  -114.951     0.200
     1.390    -2.969     0.200
     2.373    -8.173     0.200
     2.640    -8.972     0.200
     2.698    -9.038     0.200
     3.741   -16.235     0.200
     6.874   -37.281     0.200
     2.001    -4.406     0.200
     2.247    -4.777     0.200
     2.502    -6.257     0.200
     2.541    -9.170     0.200
    16.777  -109.816     0.200
     1.023     1.573     0.200
     1.701    -5.657     0.200
     2.809   -11.460     0.200
     1.179     3.990     0.200
     1.267     1.818     0.200
     1.034     4.604     0.200
     1.707    -1.791     0.200
     1.946    -3.135     0.200
     0.758     1.915     0.200
     1.334    -3.837     0.200
     1.358    -3.034     0.200
     1.443    -3.094     0.200
     2.418   -11.853     0.200
     2.479    -8.818     0.200
     3.544   -18.654     0.200
     4.780   -26.996     0.200
    23.673  -162.264     0.200
     0.752     2.376     0.200
     1.443    -3.598     0.200
     1.657    -5.426     0.200
     2.473    -8.110     0.200
     2.697   -11.378     0.200
     2.707   -10.608     0.200
     1.112     2.636     0.200
     1.170     1.941     0.200
     1.230     1.306     0.200
     1.354     0.372     0.200
     1.273     2.106     0.200
     2.550    -7.569     0.200
     0.711     4.516     0.200
     1.196     0.947     0.200
     1.712    -5.287     0.200
     1.881    -6.329     0.200
     1.802    -5.517     0.200
     1.754    -3.779     0.200
     2.002    -6.369     0.200
     2.155    -6.566     0.200
     2.603   -10.377     0.200
     3.311   -16.072     0.200
     1.064    -0.959     0.200
     1.621    -4.428     0.200
     1.889    -5.675     0.200
     2.027    -6.718     0.200
     2.134    -7.092     0.200
     2.732   -11.706     0.200
     0.888     2.182     0.200
     1.058     1.395     0.200
     1.262     2.137     0.200
     1.817    -6.080     0.200
     2.066    -6.580     0.200
     2.428   -10.319     0.200
     2.366    -6.675     0.200
     3.082   -13.259     0.200
     3.586   -13.169     0.200
     4.777   -26.931     0.200
     0.988     2.393     0.200
     1.008     1.501     0.200
     1.069     1.429     0.200
     1.247     2.846     0.200
     1.308     1.140     0.200
     1.720    -6.480     0.200
     2.259    -6.451     0.200
     2.373    -7.138     0.200
     2.456    -8.044     0.200
     0.936     0.789     0.200
     1.482    -2.769     0.200
     1.956    -6.173     0.200
     1.974    -6.184     0.200
     2.718    -8.669     0.200
    16.457  -105.999     0.200
     3.247    -9.846     0.200
     1.237     1.069     0.200
     1.369    -0.251     0.200
     2.663    -8.662     0.200
     0.886     4.502     0.200
     2.491    -5.996     0.200
     1.291     0.755     0.200
     2.531    -8.037     0.200
     3.211   -13.894     0.200
     2.302    -4.468     0.200
     8.758   -51.909     0.200
     1.110     2.293     0.200
     2.319    -5.317     0.200
     3.263   -15.107     0.200
     1.121     2.879     0.200
     3.125    -8.629     0.200
     1.199     4.489     0.200
     2.091    -2.567     0.200
     2.208    -3.898     0.200
     2.605    -6.747     0.200
     2.815    -7.650     0.200
     3.170    -8.179     0.200
     3.195   -12.818     0.200
     8.740   -52.100     0.200
     1.025     5.648     0.200
     2.344    -5.403     0.200
     3.129    -8.945     0.200
     3.297   -13.363     0.200
     8.513   -50.147     0.200
     1.309     2.105     0.200
     2.515    -6.918     0.200
     3.141   -14.094     0.200
     3.186   -16.628     0.200
     1.593    -1.488     0.200
     2.492    -5.121     0.200
     1.211     0.611     0.200
     1.380    -1.123     0.200
     2.252    -5.830     0.200
     8.272   -49.517     0.200
    10.773   -69.028     0.200
     1.368     0.648     0.200
     1.552    -2.691     0.200
     2.056    -5.495     0.200
     2.894   -12.019     0.200
     3.188   -15.121     0.200
     3.432   -12.369     0.200
     8.538   -50.246     0.200
    16.424  -108.871     0.200
     1.098     1.859     0.200
     1.267     1.711     0.200
     3.206   -15.120     0.200
     1.287     1.236     0.200
     1.584    -2.479     0.200
     3.057   -11.126     0.200
     3.203   -13.429     0.200
     8.623   -54.583     0.200
     1.243     1.552     0.200
     1.243     3.213     0.200
     1.564    -2.406     0.200
     2.176    -3.994     0.200
     2.577    -6.697     0.200
     3.790   -16.454     0.200
     1.070     4.437     0.200
     1.170     1.911     0.200
     2.337    -6.413     0.200
     2.342    -6.327     0.200
     2.761    -8.802     0.200
     3.110   -11.453     0.200
     0.924     1.890     0.200
     3.204    -9.901     0.200
     3.204   -17.361     0.200
     1.288     2.695     0.200
     2.537    -7.133     0.200
     2.851    -8.658     0.200
     3.517   -12.066     0.200
     8.634   -54.760     0.200
    13.870   -92.259     0.200
    14.135   -92.511     0.200
    16.467  -108.665     0.200
     1.375     1.053     0.200
     2.254    -4.922     0.200
     2.442    -7.446     0.200
     4.626   -25.376     0.200
     1.464     1.182     0.200
     1.904    -3.767     0.200
     1.972    -4.412     0.200
     1.506     0.180     0.200
     1.783    -2.009     0.200
     1.079     3.927     0.200
     1.161     1.447     0.200
     1.070     4.565     0.200
     1.152     1.824     0.200
     1.359     1.692     0.200
     1.833    -2.872     0.200
     2.470    -5.595     0.200
    16.439  -103.915     0.200
     1.847    -6.013     0.200
     2.585    -8.074     0.200
     3.246   -17.760     0.200
     1.616    -2.199     0.200
     3.239   -10.446     0.200
     8.758   -49.570     0.200
     1.187     1.212     0.200
     1.383    -0.663     0.200
     2.851   -11.030     0.200
     8.298   -50.803     0.200
    16.262  -108.449     0.200
     1.265     1.902     0.200
     3.536   -14.632     0.200
     8.624   -51.486     0.200
     9.691   -59.379     0.200
    15.795  -101.604     0.200
    16.416  -108.279     0.200
     0.925     3.620     0.200
     1.321     1.158     0.200
     1.606    -1.554     0.200
     3.171    -9.630     0.200
     3.171   -15.403     0.200
     8.606   -50.757     0.200
     1.021     5.191     0.200
     1.691    -1.350     0.200
     2.137    -2.584     0.200
     1.188     2.873     0.200
     1.460     1.114     0.200
     1.683    -1.402     0.200
     2.217    -5.447     0.200
     1.134     3.055     0.200
     1.403     0.836     0.200
     1.748    -1.640     0.200
     0.947     4.402     0.200
     1.410     2.346     0.200
     1.592    -1.872     0.200
     3.134   -10.703     0.200
     3.134   -13.769     0.200
     8.527   -50.269     0.200
     1.257     0.164     0.200
     1.376     1.256     0.200
     3.255   -13.438     0.200
     0.817     4.230     0.200
     3.296   -12.453     0.200
     3.296   -14.442     0.200
     8.472   -51.723     0.200
    10.924   -72.044     0.200
     1.100     3.685     0.200
     1.063     3.644     0.200
     1.160     3.898     0.200
     1.591    -2.911     0.200
     0.942     3.651     0.200
     1.318     2.157     0.200
     1.626    -1.331     0.200
     1.148     3.357     0.200
     1.416    -0.895     0.200
     1.831    -5.119     0.200
     5.952   -33.389     0.200
    16.295  -107.848     0.200
     1.017     4.250     0.200
     1.290     2.631     0.200
     1.555     0.948     0.200
     1.713    -1.132     0.200
     0.992     2.657     0.200
     1.410     2.087     0.200
     1.707    -2.337     0.200
     2.022    -3.753     0.200
     1.145     3.219     0.200
     3.272   -13.443     0.200
     1.142     2.172     0.200
     1.125     1.576     0.200
     1.396     1.038     0.200
     2.280    -5.661     0.200
     1.116     2.369     0.200
     1.411     1.077     0.200
     1.655    -0.641     0.200
     1.780    -1.711     0.200
     0.992     3.779     0.200
     1.263     2.234     0.200
     2.146    -4.870     0.200
     3.039   -11.272     0.200
     1.140     2.910     0.200
     1.382     1.664     0.200
     2.000    -2.708     0.200
     2.306    -5.060     0.200
     2.507    -8.341     0.200
     3.119    -8.494     0.200
     3.191    -9.829     0.200
     4.192   -18.445     0.200
     1.125     2.103     0.200
     1.170     1.877     0.200
     1.433     0.790     0.200
     1.253     2.268     0.200
     1.852    -3.057     0.200
     1.288     1.279     0.200
     2.676    -8.609     0.200
     3.199    -9.181     0.200
     1.090     2.975     0.200
     1.154     2.521     0.200
     1.369     1.555     0.200
     1.987    -3.219     0.200
     2.316    -4.765     0.200
     2.499    -6.688     0.200
     3.266   -15.851     0.200
     3.521   -10.709     0.200
     1.227     2.552     0.200
     1.432    -0.458     0.200
     1.858    -3.233     0.200
     3.203   -15.683     0.200
     8.250   -48.591     0.200
     1.369     1.761     0.200
     1.663    -2.113     0.200
     1.782    -1.286     0.200
     1.987    -5.530     0.200
     2.321    -4.546     0.200
     2.315    -5.095     0.200
     1.080     2.505     0.200
     2.327    -5.196     0.200
     2.487    -5.019     0.200
     1.049     3.928     0.200
     1.205     3.206     0.200
     1.484     1.729     0.200
     1.777    -3.363     0.200
     1.644    -1.113     0.200
     2.608    -9.226     0.200
     3.160   -10.763     0.200
     1.087     2.346     0.200
     1.176     2.671     0.200
     1.451    -0.142     0.200
     3.202   -14.641     0.200
     1.395     1.244     0.200
     1.584    -4.479     0.200
     1.695    -1.752     0.200
     2.041    -5.059     0.200
     2.262    -4.719     0.200
     1.263     2.526     0.200
     1.387    -0.145     0.200
     2.541    -8.938     0.200
     2.828   -10.227     0.200
     3.289   -13.741     0.200
     4.086   -19.700     0.200
     8.216   -50.137     0.200
     1.161     1.864     0.200
     1.803    -2.511     0.200
     2.222    -4.921     0.200
     2.665    -7.544     0.200
     3.098   -16.849     0.200
     3.293   -12.002     0.200
     3.672   -13.622     0.200
     4.509   -21.516     0.200
     8.850   -52.726     0.200
     9.580   -60.942     0.200
     1.640    -0.754     0.200
     1.787    -0.871     0.200
     2.217    -4.856     0.200
     2.666    -7.115     0.200
     2.680    -6.694     0.200
     3.107   -14.402     0.200
     3.280   -12.399     0.200
     3.317   -14.104     0.200
     3.376    -8.911     0.200
     8.835   -49.802     0.200
     1.094     2.548     0.200
     2.063    -4.127     0.200
     2.230    -5.296     0.200
     2.586    -6.843     0.200
     2.719    -8.253     0.200
     2.799    -9.280     0.200
     3.180   -11.253     0.200
     3.214   -13.737     0.200
     4.387   -20.825     0.200
     1.226     3.100     0.200
     1.434    -0.733     0.200
     1.857    -3.616     0.200
     1.932    -4.158     0.200
     1.042     2.488     0.200
     1.241     2.005     0.200
     1.532    -1.817     0.200
     1.687    -1.752     0.200
     2.126    -4.092     0.200
     2.164    -5.766     0.200
     2.658    -7.928     0.200
     3.148   -13.535     0.200
     3.148   -14.009     0.200
     3.211   -13.559     0.200
     3.213    -8.833     0.200
     4.397   -21.335     0.200
     8.726   -51.001     0.200
    16.542  -106.021     0.200
     1.131    -0.308     0.200
     1.300     3.562     0.200
     1.375    -0.065     0.200
     1.985    -5.137     0.200
     2.531    -8.392     0.200
     1.264     1.856     0.200
     1.420    -0.448     0.200
     1.968    -4.619     0.200
     2.504    -7.858     0.200
     1.138     0.631     0.200
     1.262     2.646     0.200
     1.960    -6.892     0.200
     2.518    -8.419     0.200
     4.106   -21.418     0.200
     8.215   -48.321     0.200
     1.293     1.422     0.200
     1.981    -4.807     0.200
     2.527    -8.988     0.200
     4.077   -20.593     0.200
     1.001     4.685     0.200
     1.243     2.132     0.200
     1.615    -1.475     0.200
     2.168    -2.653     0.200
     2.639    -7.406     0.200
     2.688    -7.497     0.200
     3.149    -8.705     0.200
     4.326   -19.931     0.200
     1.313     1.847     0.200
     1.380    -0.324     0.200
     2.518    -7.809     0.200
     2.805    -9.765     0.200
     3.268   -12.045     0.200
    16.248  -103.360     0.200
     1.024     2.655     0.200
     3.019    -8.019     0.200
     3.415   -10.542     0.200
    16.523  -111.620     0.200
     1.280     2.679     0.200
     1.331    -0.333     0.200
     1.910    -5.001     0.200
     0.998     2.650     0.200
     1.240     2.750     0.200
     1.526    -2.573     0.200
     1.593    -3.612     0.200
     2.585    -7.814     0.200
     2.859    -9.943     0.200
     3.128   -12.792     0.200
     3.138   -11.072     0.200
     3.214   -11.876     0.200
     3.565   -11.892     0.200
     4.125   -15.990     0.200
     4.256   -20.199     0.200
     4.314   -21.468     0.200
     1.206     2.308     0.200
     1.877    -6.574     0.200
     2.841   -10.245     0.200
     1.538    -4.381     0.200
     1.500    -3.280     0.200
     1.582    -4.001     0.200
     2.575    -9.561     0.200
     2.701   -12.496     0.200
     4.111   -16.713     0.200
    10.973   -73.753     0.200
     1.102     1.350     0.200
     1.259     0.091     0.200
     1.807    -3.436     0.200
     1.962    -3.782     0.200
     2.944    -9.607     0.200
     3.115   -12.581     0.200
     3.310   -11.312     0.200
     3.755   -18.728     0.200
     3.820   -19.832     0.200
     4.536   -25.540     0.200
    15.197  -100.678     0.200
    23.208  -160.409     0.200
     2.183    -5.833     0.200
     2.585    -6.995     0.200
     2.887    -8.679     0.200
     2.989   -11.449     0.200
     3.410   -12.561     0.200
     1.458    -0.766     0.200
     1.881    -4.449     0.200
     2.195    -7.412     0.200
     2.609    -8.855     0.200
     1.175     2.510     0.200
     2.541    -6.130     0.200
     3.114    -9.433     0.200
     1.404     0.410     0.200
     1.518    -2.275     0.200
     1.626    -2.604     0.200
     1.624    -2.457     0.200
     2.253    -6.425     0.200
     2.690    -7.552     0.200
     2.721    -7.425     0.200
     3.286   -12.401     0.200
     3.546   -15.703     0.200
     4.001   -18.794     0.200
     4.052   -17.243     0.200
     9.598   -59.465     0.200
     1.180    -5.817     0.200
     1.898    -8.006     0.200
     1.962    -7.281     0.200
     2.358   -10.053     0.200
     1.037     3.561     0.200
     1.245     1.652     0.200
     1.510     1.156     0.200
     2.160    -5.455     0.200
     2.597    -5.698     0.200
     2.655    -7.965     0.200
    16.540  -106.134     0.200
    22.480  -155.623     0.200
     1.676    -2.641     0.200
     1.853    -2.129     0.200
     2.220    -3.731     0.200
     2.296    -6.326     0.200
     2.436    -5.665     0.200
     2.599    -9.000     0.200
     2.764    -6.689     0.200
     3.157    -8.309     0.200
    16.435  -107.633     0.200
    22.621  -154.637     0.200
     1.034     3.215     0.200
     1.243     2.556     0.200
     2.163    -5.684     0.200
     1.674    -0.929     0.200
     2.014    -3.011     0.200
     2.146    -2.305     0.200
     2.437    -4.704     0.200
     2.546    -6.517     0.200
     2.524   -10.395     0.200
     1.290     1.384     0.200
     2.012    -6.052     0.200
     2.455    -8.302     0.200
     8.183   -49.156     0.200
     1.039     1.505     0.200
     1.195     3.618     0.200
     1.553    -1.809     0.200
     1.622    -5.716     0.200
     2.217    -5.296     0.200
     1.090    -0.145     0.200
     1.306     2.582     0.200
     1.414    -2.303     0.200
     1.802    -4.763     0.200
     2.011    -5.131     0.200
     2.255    -7.475     0.200
     1.135     2.004     0.200
     1.400     0.964     0.200
     1.621    -2.546     0.200
     1.679    -0.986     0.200
     2.280    -7.009     0.200
     2.285    -4.445     0.200
     0.808     2.958     0.200
     0.992     2.916     0.200
     2.224    -5.263     0.200
     2.565    -7.273     0.200
     2.658    -7.321     0.200
     1.386    -0.953     0.200
     1.710    -4.797     0.200
     2.837   -10.168     0.200
     1.183     2.285     0.200
     1.347     1.191     0.200
     1.656    -3.407     0.200
     2.809    -8.493     0.200
     1.185     1.752     0.200
     1.336     1.563     0.200
     1.684    -3.344     0.200
     2.834    -8.395     0.200
     2.852    -8.666     0.200
     3.286   -15.863     0.200
     3.755   -12.276     0.200
     4.172   -19.786     0.200
     2.478    -7.269     0.200
    16.299  -103.286     0.200
     1.115     2.606     0.200
     1.395    -0.628     0.200
     1.691    -4.826     0.200
     2.819    -9.422     0.200
     2.898   -11.857     0.200
     3.303   -12.604     0.200
    15.709  -101.534     0.200
    16.430  -104.787     0.200
    23.203  -158.785     0.200
     1.332     2.750     0.200
     1.636    -2.309     0.200
     2.787    -9.488     0.200
     2.800    -8.194     0.200
    23.304  -157.947     0.200
     0.994     1.820     0.200
     1.622    -2.222     0.200
     2.675    -8.139     0.200
     3.191   -15.960     0.200
     3.667   -16.317     0.200
     3.849   -19.650     0.200
     4.114   -18.095     0.200
     1.174     1.705     0.200
     1.345     0.827     0.200
     1.964    -4.043     0.200
     2.342    -5.909     0.200
     2.766    -8.284     0.200
     2.830   -10.242     0.200
     3.723   -14.302     0.200
     3.827   -17.391     0.200
    12.913   -83.143     0.200
    16.431  -108.736     0.200
     1.111     3.391     0.200
     1.389    -0.438     0.200
     2.788    -9.683     0.200
     3.197   -13.541     0.200
     2.020    -2.977     0.200
     2.278    -3.096     0.200
     2.362    -3.931     0.200
     2.688    -5.578     0.200
     2.793    -8.729     0.200
     3.284   -10.564     0.200
     4.213   -13.733     0.200
     4.301   -18.520     0.200
     1.353     0.636     0.200
     2.031    -4.919     0.200
     2.475    -5.929     0.200
     2.832    -9.073     0.200
     3.186    -9.903     0.200
     4.060   -18.915     0.200
     1.183     2.168     0.200
     1.569     1.168     0.200
     1.658    -0.869     0.200
     2.096    -6.192     0.200
     2.437    -5.171     0.200
     2.651    -6.885     0.200
     2.147    -7.009     0.200
     2.650    -7.908     0.200
     3.018    -8.642     0.200
     3.153   -10.709     0.200
     1.503     1.489     0.200
     1.730    -2.117     0.200
     2.145    -6.257     0.200
     2.594    -6.467     0.200
     2.624    -7.645     0.200
     3.104   -15.023     0.200
     3.953   -20.015     0.200
     9.573   -60.828     0.200
     1.666    -3.501     0.200
     2.727    -9.307     0.200
     2.803    -9.407     0.200
     2.861   -11.939     0.200
    12.949   -82.400     0.200
    16.468  -106.324     0.200
     1.644    -3.041     0.200
     2.001    -4.211     0.200
     2.600    -8.629     0.200
     1.551    -3.133     0.200
     1.568    -2.225     0.200
     1.620    -1.994     0.200
     2.126    -4.216     0.200
     2.543    -5.655     0.200
     2.649    -7.643     0.200
     1.491     0.185     0.200
     2.106    -3.845     0.200
     2.128    -5.465     0.200
     2.682   -10.370     0.200
     2.611    -8.423     0.200
     2.718    -9.727     0.200
     1.668    -2.586     0.200
     1.993    -3.843     0.200
     2.314    -7.943     0.200
     2.736    -8.676     0.200
     2.808    -8.369     0.200
     1.659    -2.862     0.200
     1.672    -2.882     0.200
     2.066    -3.347     0.200
     2.808    -9.025     0.200
     3.263    -9.492     0.200
     1.556    -0.798     0.200
     1.671    -2.926     0.200
     2.111    -4.201     0.200
     2.125    -4.071     0.200
     2.184    -4.432     0.200
     2.681    -9.520     0.200
     3.129   -12.446     0.200
     3.171   -11.962     0.200
     3.171   -14.681     0.200
     3.657   -13.734     0.200
     1.691    -1.179     0.200
     2.150    -4.955     0.200
     2.125    -3.732     0.200
     2.656    -7.822     0.200
     3.015    -7.353     0.200
     3.145    -9.516     0.200
     4.072   -13.675     0.200
     1.883    -3.832     0.200
     2.559    -7.873     0.200
     0.996     4.117     0.200
     1.550    -3.138     0.200
     1.543    -1.471     0.200
     2.658    -8.465     0.200
     2.819    -9.974     0.200
    16.499  -104.714     0.200
     1.139     2.490     0.200
     1.528    -3.648     0.200
     2.107    -4.322     0.200
     2.571    -7.916     0.200
     1.444    -0.016     0.200
     1.637    -4.793     0.200
     2.697    -8.414     0.200
     1.483    -0.410     0.200
     1.574    -2.054     0.200
     2.274    -5.171     0.200
     2.691    -8.885     0.200
     3.095   -12.598     0.200
     3.121   -13.254     0.200
     3.656   -15.169     0.200
     3.691   -15.472     0.200
     4.144   -19.575     0.200
     1.063     3.712     0.200
     1.196     1.979     0.200
     1.692    -2.615     0.200
     2.342    -6.670     0.200
     3.149   -15.808     0.200
     3.144   -10.542     0.200
     1.278     1.843     0.200
     1.469    -0.226     0.200
     1.583    -1.273     0.200
     1.830    -2.581     0.200
     2.138    -4.500     0.200
     2.674    -8.636     0.200
     2.666    -8.271     0.200
     1.665    -4.097     0.200
     2.808    -8.769     0.200
     1.250     3.460     0.200
     1.873    -1.797     0.200
     1.872    -1.625     0.200
     2.494    -4.772     0.200
     1.634     1.707     0.200
     1.788    -2.291     0.200
     2.075    -3.038     0.200
     2.147    -2.121     0.200
     2.225    -5.241     0.200
     2.646    -6.723     0.200
     2.642    -5.889     0.200
     3.292   -12.117     0.200
     1.577    -1.001     0.200
     2.033    -3.395     0.200
     2.588    -7.732     0.200
     1.314     1.359     0.200
     1.562    -4.660     0.200
     2.102    -4.731     0.200
     2.237    -5.770     0.200
     2.643    -8.679     0.200
     3.038    -9.305     0.200
     3.187   -12.813     0.200
     3.187   -11.762     0.200
     4.105   -14.338     0.200
     8.602   -51.108     0.200
     1.398    -0.983     0.200
     1.610    -2.807     0.200
     2.548    -7.407     0.200
     2.546    -8.196     0.200
     3.703   -21.861     0.200
     1.228     1.667     0.200
     1.362     0.246     0.200
     1.795    -3.527     0.200
     1.367     2.407     0.200
     1.699    -2.944     0.200
     2.457    -6.029     0.200
     2.847    -9.183     0.200
     3.097   -11.643     0.200
     3.301    -9.092     0.200
     1.449    -0.498     0.200
     1.570    -3.908     0.200
     1.827    -2.766     0.200
     2.081    -6.139     0.200
     1.701    -2.365     0.200
     2.388    -5.531     0.200
     1.119     2.050     0.200
     1.529    -2.118     0.200
     1.746    -3.213     0.200
     2.192    -4.405     0.200
     2.213    -5.386     0.200
     3.245   -14.741     0.200
     3.276   -14.672     0.200
     3.578   -12.196     0.200
     4.068   -16.474     0.200
     4.453   -22.266     0.200
     1.305     1.821     0.200
     1.747    -1.540     0.200
     2.101    -4.159     0.200
     2.578    -7.077     0.200
     1.103     4.180     0.200
     1.596    -1.992     0.200
     1.750    -1.364     0.200
     2.304    -4.004     0.200
     2.144    -3.804     0.200
     4.131   -13.446     0.200
     1.307     1.405     0.200
     1.370     0.950     0.200
     1.440    -0.496     0.200
     1.549    -4.381     0.200
     3.027    -9.939     0.200
     3.120   -14.698     0.200
     1.615    -1.786     0.200
     1.663    -1.986     0.200
     2.184    -4.329     0.200
     2.403    -7.743     0.200
     1.180     3.581     0.200
     1.613    -0.813     0.200
     2.240    -5.977     0.200
     3.105   -12.585     0.200
     3.385   -13.821     0.200
     1.042     3.479     0.200
     1.446     0.152     0.200
     1.542    -1.629     0.200
     1.592    -2.993     0.200
     2.201    -5.515     0.200
     3.076   -12.611     0.200
     3.208   -11.154     0.200
     3.431   -13.911     0.200
     4.135   -19.950     0.200
     8.718   -50.822     0.200
     1.012     4.501     0.200
     1.227     3.886     0.200
     1.521     1.561     0.200
     1.808    -1.316     0.200
     1.610    -0.944     0.200
     2.072    -2.170     0.200
     2.445    -5.048     0.200
     2.705    -6.938     0.200
     3.428   -11.445     0.200
     1.274     2.733     0.200
     1.620    -2.054     0.200
     2.102    -4.936     0.200
     1.640    -1.576     0.200
     2.308    -5.866     0.200
     2.775    -7.946     0.200
     1.000     1.950     0.200
     1.250     1.260     0.200
     2.160    -6.646     0.200
     2.648   -11.883     0.200
     3.162   -15.555     0.200
     4.114   -20.846     0.200
     1.225     1.956     0.200
     1.559    -1.933     0.200
     2.310    -5.120     0.200
     0.970     2.007     0.200
     1.382    -0.078     0.200
     1.289     1.745     0.200
     1.585    -4.461     0.200
     1.352     0.638     0.200
     2.259    -5.618     0.200
     2.169    -4.363     0.200
     3.416   -11.556     0.200
     3.671   -17.097     0.200
     4.132   -17.285     0.200
     1.294     2.303     0.200
     1.693    -3.958     0.200
     1.918    -3.901     0.200
     2.492    -7.811     0.200
     1.218     2.424     0.200
     1.598    -3.218     0.200
     2.220    -5.458     0.200
     1.061     1.933     0.200
     1.191     2.973     0.200
     1.612    -1.757     0.200
     2.289    -5.860     0.200
     2.379    -7.353     0.200
     1.908    -7.078     0.200
     3.570   -13.521     0.200
     1.641    -1.772     0.200
     1.668    -0.954     0.200
     2.073    -3.102     0.200
     2.305    -4.235     0.200
     2.297    -4.900     0.200
     2.297    -4.560     0.200
     3.705   -11.593     0.200
     2.281   -10.197     0.200
     2.714   -10.081     0.200
    17.576  -116.299     0.200
     1.293     2.501     0.200
     1.970    -2.954     0.200
     2.129    -3.100     0.200
     2.600    -5.627     0.200
     5.341   -26.771     0.200
     1.194     0.219     0.200
    16.602  -106.282     0.200
     1.788    -4.932     0.200
     2.321    -8.987     0.200
     2.608    -7.444     0.200
     2.866   -10.841     0.200
     2.866   -13.154     0.200
     1.269     2.730     0.200
     1.419     0.138     0.200
     2.117    -4.457     0.200
     2.654    -9.247     0.200
     2.819    -9.502     0.200
     0.955     3.630     0.200
     1.274     1.385     0.200
     1.361    -0.386     0.200
     2.081    -5.345     0.200
     2.681    -7.976     0.200
     2.880    -9.449     0.200
     1.368     1.545     0.200
     1.310     0.907     0.200
     1.542    -4.166     0.200
     2.218    -4.180     0.200
     2.873   -10.885     0.200
     3.013   -13.686     0.200
     1.546    -1.686     0.200
     1.704    -2.368     0.200
     1.824    -3.151     0.200
     1.930    -3.680     0.200
     2.262    -5.682     0.200
     2.445    -5.866     0.200
     1.362     0.643     0.200
     2.219    -4.635     0.200
     2.237    -4.643     0.200
     2.466    -7.012     0.200
     2.643    -9.721     0.200
     1.663    -2.226     0.200
     1.665    -1.336     0.200
     2.059    -4.538     0.200
     2.323    -3.828     0.200
     2.842    -9.501     0.200
     1.295     0.413     0.200
     1.625    -4.216     0.200
     2.449    -8.172     0.200
     2.776    -9.894     0.200
     2.821   -13.663     0.200
     1.569    -3.597     0.200
     1.600    -1.263     0.200
     1.813    -2.192     0.200
     2.063    -3.677     0.200
     2.132    -4.106     0.200
     2.132    -4.946     0.200
     2.855    -8.242     0.200
     3.049   -13.046     0.200
     3.166   -12.378     0.200
     1.375     1.066     0.200
     1.564    -1.198     0.200
     1.594    -2.318     0.200
     2.066    -6.417     0.200
     2.080    -3.732     0.200
     2.137    -4.124     0.200
     2.862    -8.676     0.200
     3.056    -9.410     0.200
     3.173   -10.782     0.200
     1.283     1.716     0.200
     1.465    -0.256     0.200
     2.076    -4.652     0.200
     2.253    -4.650     0.200
     2.476    -6.097     0.200
     2.668    -7.947     0.200
     2.869    -8.774     0.200
     3.203   -11.154     0.200
     1.235     1.477     0.200
     1.524    -0.733     0.200
     1.572    -3.102     0.200
     2.103    -4.234     0.200
     2.464    -8.685     0.200
     2.689    -7.469     0.200
     2.822    -8.682     0.200
     3.138   -13.433     0.200
     3.169   -10.877     0.200
     1.942    -3.432     0.200
     2.156    -2.562     0.200
     2.749    -8.676     0.200
     0.800     3.633     0.200
     0.822     3.408     0.200
     1.030     1.207     0.200
     1.177     1.078     0.200
     1.278    -0.393     0.200
     2.201    -7.508     0.200
     2.330    -8.617     0.200
     2.643    -9.209     0.200
     2.734    -9.904     0.200
     2.703    -9.624     0.200
     3.683   -15.380     0.200
     1.376     0.752     0.200
     1.546    -4.008     0.200
     1.611    -1.673     0.200
     2.063    -3.646     0.200
     2.509    -6.222     0.200
     2.841   -11.062     0.200
     1.371     1.425     0.200
     1.814    -4.558     0.200
     2.296    -7.970     0.200
     2.240    -6.074     0.200
     2.352    -6.527     0.200
     2.706   -12.160     0.200
     2.484   -12.106     0.200
     2.621    -7.838     0.200
     2.671   -11.960     0.200
     2.795   -10.349     0.200
     3.044    -9.922     0.200
     0.806     4.790     0.200
     1.252     1.023     0.200
     1.289     1.844     0.200
     1.325     0.662     0.200
     1.332     1.908     0.200
     1.416    -0.252     0.200
     1.568    -2.507     0.200
     1.486    -1.993     0.200
     1.700    -2.822     0.200
     2.114    -4.706     0.200
     2.505    -6.467     0.200
     2.635   -11.981     0.200
     2.881   -11.437     0.200
     3.186   -10.218     0.200
     0.997     2.991     0.200
     1.263     2.237     0.200
     1.265     1.118     0.200
     1.284     0.891     0.200
     1.424    -0.478     0.200
     1.487    -1.326     0.200
     1.550    -3.059     0.200
     1.728    -6.022     0.200
     1.880    -8.049     0.200
     2.159    -4.849     0.200
     2.253    -6.530     0.200
     2.492    -8.918     0.200
     2.818    -9.533     0.200
     3.131   -11.867     0.200
     3.170   -16.781     0.200
     3.381   -14.352     0.200
     3.870   -20.196     0.200
     4.094   -17.174     0.200
     4.353   -21.734     0.200
     1.026    -0.851     0.200
     1.058    -2.374     0.200
     1.134    -4.418     0.200
     1.367    -4.013     0.200
     1.493    -2.968     0.200
     1.558    -5.092     0.200
     1.732    -4.963     0.200
     1.820    -5.891     0.200
     1.918    -6.203     0.200
     1.921    -6.843     0.200
     1.999    -5.689     0.200
     2.118    -5.831     0.200
     2.149    -7.376     0.200
     2.124   -10.262     0.200
     2.549   -10.599     0.200
     2.630   -10.612     0.200
     2.697   -10.131     0.200
     2.953   -10.251     0.200
     3.352   -14.122     0.200
     3.362   -18.666     0.200
     3.610   -19.661     0.200
     3.874   -18.172     0.200
     1.281     0.913     0.200
     1.680    -6.025     0.200
     1.735    -7.084     0.200
     1.953    -4.660     0.200
     2.205    -6.759     0.200
     2.200    -8.075     0.200
     2.286   -10.084     0.200
     2.366    -6.788     0.200
     2.435    -9.297     0.200
     2.522    -9.460     0.200
     2.641    -8.827     0.200
     2.729   -10.116     0.200
     2.804   -11.259     0.200
     3.390   -15.388     0.200
     3.331   -14.462     0.200
     3.764   -19.250     0.200
     3.868   -21.872     0.200
     4.080   -20.160     0.200
     4.554   -25.096     0.200
     7.796   -41.549     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     5.745   -14.012     0.200
     0.848     1.141     0.200
     1.079     1.723     0.200
     0.848     1.910     0.200
     2.479    -4.295     0.200
     0.868     2.552     0.200
     0.516     2.263     0.200
     2.073    -1.112     0.200
     1.084     0.232     0.200
     2.251     0.243     0.200
     2.468    -0.572     0.200
     1.932    -0.710     0.200
     2.776    -4.459     0.200
     0.911     1.265     0.200
     1.592    -0.741     0.200
     2.639    -6.918     0.200
     2.849    -5.887     0.200
     0.989     0.895     0.200
     1.633    -0.516     0.200
     2.628    -6.974     0.200
     2.788    -5.237     0.200
     1.594    -0.792     0.200
     2.834    -5.602     0.200
     0.442     1.626     0.200
     0.540     2.803     0.200
     0.666     2.005     0.200
     1.202    -1.807     0.200
     1.953    -2.988     0.200
     0.292     5.085     0.200
     0.864     0.398     0.200
     1.557    -0.542     0.200
     2.678    -7.436     0.200
     0.831     0.572     0.200
     0.839     0.791     0.200
     2.927    -6.863     0.200
     0.171     2.084     0.200
     0.776     3.282     0.200
     0.891     1.365     0.200
     0.347     1.491     0.200
     0.842     2.253     0.200
     1.011     0.255     0.200
     1.891    -1.370     0.200
     1.985    -2.229     0.200
     2.114     0.237     0.200
     2.368    -4.633     0.200
     3.162    -7.223     0.200
     1.016     0.390     0.200
     1.102     0.256     0.200
     1.489     1.397     0.200
     2.383    -1.719     0.200
     3.019    -7.479     0.200
     0.864     0.356     0.200
     0.865     0.643     0.200
     1.312     0.399     0.200
     1.554    -0.462     0.200
     1.859    -2.392     0.200
     2.673    -7.512     0.200
     2.951    -4.963     0.200
     0.827     0.635     0.200
     0.844     0.896     0.200
     1.335    -0.697     0.200
     1.888     0.171     0.200
     1.997    -2.338     0.200
     0.714     1.329     0.200
     1.940    -2.846     0.200
     1.906    -1.888     0.200
     1.906    -2.529     0.200
     2.001    -3.254     0.200
     0.204     3.297     0.200
     0.539     1.244     0.200
     1.036    -0.469     0.200
     1.262    -0.891     0.200
     1.511    -1.010     0.200
     2.233    -1.686     0.200
     2.402    -4.762     0.200
     0.684     0.901     0.200
     0.862     1.205     0.200
     1.862    -2.656     0.200
     2.227    -3.955     0.200
     2.570    -4.489     0.200
     0.392     1.941     0.200
     1.349    -0.591     0.200
     1.894    -1.174     0.200
     1.925    -2.257     0.200
     2.301    -0.571     0.200
     1.260     0.538     0.200
     1.970    -2.709     0.200
     0.648     1.423     0.200
     1.471    -1.773     0.200
     1.542    -2.860     0.200
     1.500    -1.400     0.200
     2.237    -3.886     0.200
     0.494     2.283     0.200
     0.648     1.823     0.200
     0.763     1.475     0.200
     1.323    -3.316     0.200
     1.456    -1.485     0.200
     1.042    -1.170     0.200
     0.353     2.800     0.200
     0.934     0.152     0.200
     1.041    -1.153     0.200
     1.654    -3.038     0.200
     1.804    -1.576     0.200
     2.145    -4.949     0.200
     0.463     3.254     0.200
     1.220    -0.226     0.200
     1.520    -2.328     0.200
     0.943     0.504     0.200
     1.219    -0.773     0.200
     1.639    -0.429     0.200
     1.713    -1.935     0.200
     1.848    -1.711     0.200
     3.135    -5.248     0.200
     1.492    -0.369     0.200
     2.281    -5.268     0.200
     0.237     3.881     0.200
     0.488     2.271     0.200
     1.355    -0.539     0.200
     1.346    -0.972     0.200
     1.381    -0.029     0.200
     2.255    -5.969     0.200
     0.293     2.006     0.200
     0.804     1.275     0.200
     0.306     1.706     0.200
     0.764     1.334     0.200
     0.303     0.800     0.200
     0.204     1.588     0.200
     0.636     1.495     0.200
     0.352     1.843     0.200
     0.763     1.000     0.200
     1.965    -2.846     0.200
     0.745     2.880     0.200
     1.077    -0.053     0.200
     1.793    -2.128     0.200
     0.211     0.741     0.200
     0.468     1.032     0.200
     0.911     1.729     0.200
     1.596    -0.343     0.200
     0.245     2.400     0.200
     0.833     1.144     0.200
     0.419     1.177     0.200
     0.872     2.021     0.200
     0.938     1.451     0.200
     1.572    -1.167     0.200
     1.841    -2.298     0.200
     2.128    -4.019     0.200
     0.398     1.367     0.200
     0.740     1.504     0.200
     0.336     1.168     0.200
     1.632    -1.425     0.200
     1.804    -1.220     0.200
     0.344     0.943     0.200
     0.711     1.931     0.200
     0.404     1.307     0.200
     0.745     1.062     0.200
     1.199     0.869     0.200
     1.659    -0.020     0.200
     1.659     0.560     0.200
     1.763    -0.159     0.200
     2.104    -2.469     0.200
     2.249    -0.505     0.200
     2.249    -1.545     0.200
     3.153    -3.218     0.200
     4.149   -10.389     0.200
     0.427     1.621     0.200
     0.819     2.523     0.200
     0.422     2.136     0.200
     0.850     1.104     0.200
     0.981     1.272     0.200
     0.326     0.796     0.200
     0.350     1.450     0.200
     1.004     1.238     0.200
     1.563    -0.964     0.200
     0.235     0.483     0.200
     0.444     1.361     0.200
     0.872     1.668     0.200
     0.931     1.537     0.200
     1.590    -0.983     0.200
     2.107    -2.244     0.200
     3.153    -8.730     0.200
     0.208     0.996     0.200
     0.591     1.843     0.200
     0.628     1.536     0.200
     0.465     0.849     0.200
     0.886     2.202     0.200
     1.333     0.882     0.200
     2.083    -2.183     0.200
     2.219    -3.273     0.200
     0.186     2.012     0.200
     0.611     1.802     0.200
     0.615     1.347     0.200
     1.380    -1.653     0.200
     1.927    -3.525     0.200
     2.065    -2.974     0.200
     2.252    -5.301     0.200
     2.313    -5.357     0.200
     2.840    -6.825     0.200
     3.072    -8.705     0.200
     3.234    -6.293     0.200
     0.170     1.216     0.200
     0.476     1.468     0.200
     0.859     2.237     0.200
     0.942     2.780     0.200
     1.861    -1.414     0.200
     2.451    -4.817     0.200
     3.142    -4.917     0.200
     0.367     1.133     0.200
     0.403     1.473     0.200
     0.276     1.528     0.200
     0.412     1.089     0.200
     0.841     2.432     0.200
     1.593    -1.113     0.200
     3.162    -6.636     0.200
     3.206    -7.801     0.200
     0.423     1.280     0.200
     0.861     1.531     0.200
     0.947     0.787     0.200
     2.129    -2.799     0.200
     0.375     1.453     0.200
     0.847     3.094     0.200
     0.978     2.827     0.200
     1.852    -1.548     0.200
     0.323     1.820     0.200
     0.678     2.076     0.200
     1.656    -1.097     0.200
     1.330    -1.061     0.200
     1.799    -1.975     0.200
     0.567     2.259     0.200
     0.678     1.878     0.200
     0.847     1.913     0.200
     0.955     0.235     0.200
     1.603    -1.528     0.200
     2.125    -2.294     0.200
     3.142    -5.664     0.200
     3.186    -9.380     0.200
     0.471     0.987     0.200
     0.965     1.760     0.200
     1.526    -0.614     0.200
     0.756     3.170     0.200
     1.039     1.101     0.200
     1.519    -0.717     0.200
     2.352    -4.508     0.200
     3.126    -5.370     0.200
     0.562     1.521     0.200
     0.734     1.954     0.200
     1.921    -1.667     0.200
     1.958    -1.513     0.200
     2.225    -3.278     0.200
     2.334    -3.424     0.200
     3.130    -5.056     0.200
     3.178    -5.770     0.200
     3.178    -7.678     0.200
     0.328     1.128     0.200
     0.683     1.349     0.200
     1.655    -0.370     0.200
     0.290     1.959     0.200
     0.712     0.493     0.200
     2.370    -0.441     0.200
     3.271    -4.682     0.200
     0.587     1.083     0.200
     0.651     1.510     0.200
     0.721     1.780     0.200
     0.460     0.781     0.200
     0.469     1.621     0.200
     3.598    -6.093     0.200
     0.589     1.180     0.200
     0.638     1.941     0.200
     1.541    -0.987     0.200
     1.858    -3.285     0.200
     2.318    -4.434     0.200
     3.260    -9.936     0.200
     0.388     1.952     0.200
     0.867     1.494     0.200
     0.954     1.375     0.200
     2.156    -3.488     0.200
     2.289    -4.680     0.200
     2.554    -6.399     0.200
     3.194    -5.158     0.200
     0.459     0.791     0.200
     0.873     2.589     0.200
     1.600    -0.866     0.200
     1.812    -0.168     0.200
     2.094    -2.693     0.200
     2.221    -3.285     0.200
     2.181    -0.405     0.200
     0.415     1.616     0.200
     0.720     2.014     0.200
     1.084     1.583     0.200
     2.239    -3.287     0.200
     2.652    -5.056     0.200
     3.142    -5.987     0.200
     3.184    -6.804     0.200
     0.384     1.145     0.200
     0.682     1.394     0.200
     1.688    -0.545     0.200
     2.019    -0.222     0.200
     2.275    -3.347     0.200
     2.708    -4.768     0.200
     3.176    -3.725     0.200
     3.218    -6.445     0.200
     0.530     0.333     0.200
     0.842     2.096     0.200
     1.697    -0.493     0.200
     2.182    -3.344     0.200
     0.559     2.008     0.200
     0.665     1.711     0.200
     1.884    -2.802     0.200
     2.084    -1.581     0.200
     1.026     0.426     0.200
     1.679    -0.764     0.200
     3.249    -4.525     0.200
     0.425     1.149     0.200
     0.701     1.924     0.200
     1.182     0.974     0.200
     1.450     0.711     0.200
     1.701    -0.020     0.200
     2.223    -1.152     0.200
     3.174    -6.755     0.200
     0.777     2.118     0.200
     1.837    -1.522     0.200
     3.231    -4.668     0.200
     0.471     1.054     0.200
     0.852     2.343     0.200
     2.093    -2.381     0.200
     0.573     1.732     0.200
     0.668     0.553     0.200
     2.017    -1.860     0.200
     3.197    -5.256     0.200
     3.281    -8.580     0.200
     0.504     1.017     0.200
     0.768     2.087     0.200
     2.115    -2.320     0.200
     2.966    -2.933     0.200
     3.099    -5.647     0.200
     0.502     1.334     0.200
     1.525    -0.960     0.200
     0.437     0.906     0.200
     0.654     1.824     0.200
     1.153     2.071     0.200
     1.414     0.827     0.200
     1.737    -0.367     0.200
     2.226     0.149     0.200
     2.252    -1.419     0.200
     3.052    -5.939     0.200
     0.383     1.307     0.200
     0.443     1.514     0.200
     0.676     1.833     0.200
     1.691    -0.915     0.200
     1.747    -1.482     0.200
     2.011    -1.012     0.200
     2.277    -3.668     0.200
     0.358     0.818     0.200
     0.423     1.994     0.200
     0.710     2.092     0.200
     1.132     2.099     0.200
     2.028    -0.763     0.200
     2.275    -3.117     0.200
     2.298    -1.443     0.200
     0.292     0.929     0.200
     0.432     1.119     0.200
     0.808     1.497     0.200
     1.544    -0.493     0.200
     1.632    -0.847     0.200
     1.782    -1.060     0.200
     2.229    -4.198     0.200
     3.177    -8.717     0.200
     0.335     1.214     0.200
     0.450     0.919     0.200
     0.698     1.992     0.200
     1.101     1.928     0.200
     1.650    -0.005     0.200
     1.793    -0.841     0.200
     3.225    -4.987     0.200
     0.420     1.359     0.200
     0.437     1.178     0.200
     0.674     1.820     0.200
     1.703    -0.454     0.200
     1.726    -0.645     0.200
     2.045    -0.945     0.200
     2.235    -3.394     0.200
     2.221    -3.044     0.200
     0.191     0.843     0.200
     0.549     1.584     0.200
     0.688     1.664     0.200
     1.412    -0.430     0.200
     1.952    -2.419     0.200
     2.056    -2.353     0.200
     2.266     0.788     0.200
     0.255     0.220     0.200
     0.425     0.922     0.200
     0.858     2.073     0.200
     0.949     2.390     0.200
     1.576    -0.470     0.200
     1.588    -0.684     0.200
     1.825    -1.225     0.200
     2.128    -2.335     0.200
     2.249    -4.104     0.200
     0.338     1.053     0.200
     0.463     1.358     0.200
     0.684     1.692     0.200
     1.786     1.183     0.200
     1.660    -0.124     0.200
     2.324    -2.418     0.200
     3.225    -4.704     0.200
     3.722    -8.796     0.200
     0.572     1.109     0.200
     0.675     1.858     0.200
     0.341     1.404     0.200
     0.464     1.211     0.200
     0.682     2.232     0.200
     1.091     2.429     0.200
     1.155     2.022     0.200
     0.322     1.680     0.200
     0.470     1.356     0.200
     0.690     1.561     0.200
     1.157     1.468     0.200
     1.648    -0.061     0.200
     2.340    -1.152     0.200
     3.823    -9.632     0.200
     0.351     1.425     0.200
     0.398     1.200     0.200
     0.761     2.375     0.200
     2.256    -2.595     0.200
     2.203    -2.044     0.200
     2.101    -1.802     0.200
     3.203    -7.115     0.200
     0.387     1.264     0.200
     0.397     1.165     0.200
     0.723     1.324     0.200
     1.757    -0.910     0.200
     1.670    -1.548     0.200
     2.230    -4.101     0.200
     0.150     1.784     0.200
     0.481     1.447     0.200
     0.816     1.264     0.200
     0.993     1.809     0.200
     1.506    -0.677     0.200
     1.909    -2.151     0.200
     0.209     1.815     0.200
     0.547     1.677     0.200
     0.680     1.650     0.200
     1.157    -0.529     0.200
     1.868    -0.549     0.200
     2.186    -4.343     0.200
     0.624     1.998     0.200
     1.189    -0.221     0.200
     1.435    -1.644     0.200
     1.499    -0.619     0.200
     1.594    -0.634     0.200
     2.041    -1.000     0.200
     2.158    -0.700     0.200
     2.620    -4.362     0.200
     2.689    -5.883     0.200
     0.439     1.163     0.200
     0.497     0.988     0.200
     0.640     2.541     0.200
     1.192     1.517     0.200
     1.147     2.148     0.200
     1.442    -2.211     0.200
     1.505    -1.308     0.200
     2.166    -1.153     0.200
     0.393     1.720     0.200
     0.405     1.587     0.200
     0.713     1.534     0.200
     1.448    -1.579     0.200
     1.583    -0.553     0.200
     1.681    -0.839     0.200
     1.745    -1.443     0.200
     2.249    -1.864     0.200
     2.664    -6.240     0.200
     3.436    -9.656     0.200
     0.162     2.139     0.200
     0.572     1.948     0.200
     0.676     1.482     0.200
     2.194    -4.496     0.200
     2.249    -2.375     0.200
     3.124    -8.584     0.200
     0.336     1.539     0.200
     0.453     0.928     0.200
     0.752     1.884     0.200
     1.514     0.419     0.200
     1.512    -0.880     0.200
     1.730    -1.111     0.200
     2.601    -5.362     0.200
     3.377    -8.719     0.200
     0.511     1.864     0.200
     0.711     1.412     0.200
     2.155    -4.119     0.200
     0.196     2.026     0.200
     0.534     1.831     0.200
     0.706     1.629     0.200
     1.126    -0.250     0.200
     2.055    -2.775     0.200
     0.199     1.941     0.200
     0.540     1.452     0.200
     0.695     1.847     0.200
     1.408    -0.937     0.200
     2.172    -3.447     0.200
     2.269    -3.158     0.200
     0.233     1.475     0.200
     0.515     1.773     0.200
     0.709     1.643     0.200
     1.131    -0.213     0.200
     1.382    -0.575     0.200
     2.157    -3.774     0.200
     0.305    -0.034     0.200
     0.406     1.502     0.200
     0.808     1.386     0.200
     1.527    -0.136     0.200
     1.801    -0.638     0.200
     2.584    -4.251     0.200
     0.249     1.476     0.200
     0.495     2.422     0.200
     0.728     0.834     0.200
     1.114     0.327     0.200
     1.829    -0.821     0.200
     2.105    -1.480     0.200
     2.290    -2.749     0.200
     3.092    -6.932     0.200
     0.207     1.546     0.200
     0.771     0.762     0.200
     0.787     2.032     0.200
     1.612     1.956     0.200
     0.086     3.584     0.200
     0.729     2.512     0.200
     0.690     2.064     0.200
     3.238    -7.257     0.200
     0.250     1.470     0.200
     0.557     1.624     0.200
     0.655     1.516     0.200
     1.195    -0.541     0.200
     3.027    -7.956     0.200
     0.305     0.821     0.200
     0.397     1.404     0.200
     0.815     1.581     0.200
     1.604    -1.418     0.200
     1.812    -2.002     0.200
     2.145    -1.841     0.200
     2.172    -3.781     0.200
     2.265    -3.570     0.200
     3.828   -10.820     0.200
     0.186     0.801     0.200
     0.606     1.380     0.200
     0.619     1.976     0.200
     1.227    -0.183     0.200
     1.378    -0.949     0.200
     1.935    -3.141     0.200
     2.064    -1.745     0.200
     2.317    -4.573     0.200
     2.501    -2.906     0.200
     2.885    -4.095     0.200
     0.981     1.180     0.200
     1.605    -3.325     0.200
     2.277    -3.948     0.200
     3.625    -5.766     0.200
     3.691    -8.365     0.200
     0.569     1.182     0.200
     0.700     2.858     0.200
     1.468    -1.338     0.200
     1.502     1.401     0.200
     1.952    -1.636     0.200
     2.313    -3.345     0.200
     2.429    -1.305     0.200
     0.503     1.845     0.200
     0.586     3.107     0.200
     0.625     1.309     0.200
     1.398    -0.434     0.200
     1.470    -2.180     0.200
     1.914    -1.560     0.200
     2.052    -2.255     0.200
     2.690    -3.547     0.200
     2.949    -5.401     0.200
     0.486     1.304     0.200
     0.594     2.375     0.200
     0.590     1.215     0.200
     1.428    -2.750     0.200
     2.084    -0.504     0.200
     0.127     2.686     0.200
     0.627     1.760     0.200
     1.200    -0.652     0.200
     3.740   -10.006     0.200
     0.482     1.158     0.200
     0.500     1.628     0.200
     0.598     1.693     0.200
     2.175    -3.363     0.200
     1.318    -1.684     0.200
     0.297     3.212     0.200
     1.825    -2.087     0.200
     3.204    -8.593     0.200
     3.398    -7.750     0.200
     0.331     1.582     0.200
     0.454     1.274     0.200
     0.757     2.634     0.200
     1.531    -2.603     0.200
     1.732    -0.426     0.200
     1.684    -0.842     0.200
     2.130     1.955     0.200
     0.155     1.128     0.200
     0.155     1.297     0.200
     0.494     1.761     0.200
     0.849     1.666     0.200
     0.948     1.412     0.200
     1.364     0.470     0.200
     1.384    -0.234     0.200
     5.318   -11.116     0.200
     0.329     1.819     0.200
     0.446     1.133     0.200
     0.762     2.337     0.200
     1.511    -0.685     0.200
     1.516    -0.790     0.200
     1.539    -2.200     0.200
     1.741    -0.566     0.200
     2.208    -2.759     0.200
     0.175     1.148     0.200
     0.542     0.566     0.200
     0.883     1.673     0.200
     0.902     2.971     0.200
     1.354     0.429     0.200
     1.396     0.882     0.200
     1.470    -2.636     0.200
     1.772     0.948     0.200
     0.522     1.598     0.200
     0.705     1.607     0.200
     1.133    -2.265     0.200
     1.845    -1.262     0.200
     2.086    -3.230     0.200
     0.498     1.377     0.200
     0.756     0.992     0.200
     1.075    -0.209     0.200
     1.449    -1.819     0.200
     2.045    -3.322     0.200
     2.114    -5.025     0.200
     0.350     1.908     0.200
     0.364     1.103     0.200
     0.785     2.436     0.200
     1.481    -1.431     0.200
     1.606    -0.669     0.200
     1.816    -1.398     0.200
     2.292    -2.943     0.200
     2.630    -6.243     0.200
     3.106    -6.615     0.200
     0.234     3.040     0.200
     2.121    -4.445     0.200
     0.437     1.859     0.200
     0.686     2.216     0.200
     1.628     1.096     0.200
     0.290     0.454     0.200
     0.437     1.385     0.200
     1.483     0.533     0.200
     1.636    -1.050     0.200
     2.143    -2.750     0.200
     0.278     2.186     0.200
     0.447     1.867     0.200
     1.655    -0.354     0.200
     0.354     1.031     0.200
     0.489     1.699     0.200
     1.681    -0.308     0.200
     2.365    -3.359     0.200
     3.145    -6.150     0.200
     0.325     1.599     0.200
     0.496     1.224     0.200
     1.694    -0.053     0.200
     2.337    -3.131     0.200
     3.286    -5.394     0.200
     0.212     2.068     0.200
     0.508     2.536     0.200
     0.737     1.165     0.200
     1.095     0.648     0.200
     0.296     1.613     0.200
     0.436     1.140     0.200
     1.643     0.649     0.200
     2.338    -3.798     0.200
     0.389     0.828     0.200
     0.511     1.332     0.200
     1.211     1.484     0.200
     1.694     0.287     0.200
     2.383    -2.792     0.200
     0.296     1.629     0.200
     0.419     1.421     0.200
     1.494     0.021     0.200
     2.474    -3.740     0.200
     0.322     1.635     0.200
     0.486     1.378     0.200
     1.657    -0.416     0.200
     1.685    -0.026     0.200
     0.347     1.577     0.200
     0.697     1.962     0.200
     1.640    -2.207     0.200
     1.657    -1.192     0.200
     1.783    -1.122     0.200
     2.007    -1.752     0.200
     2.064    -3.488     0.200
     2.296    -4.286     0.200
     2.293    -2.044     0.200
     2.311    -4.893     0.200
     2.377    -3.192     0.200
     0.315     1.563     0.200
     1.425    -1.864     0.200
     1.598     0.127     0.200
     1.613     2.223     0.200
     3.242    -6.071     0.200
     0.311     1.829     0.200
     1.679    -1.142     0.200
     1.810    -0.111     0.200
     2.333    -3.221     0.200
     3.295    -5.562     0.200
     0.393     1.228     0.200
     0.737     1.793     0.200
     1.460    -1.402     0.200
     1.767    -0.037     0.200
     2.224    -2.566     0.200
     2.261    -0.843     0.200
     0.309     1.465     0.200
     0.451     1.461     0.200
     1.534    -0.554     0.200
     1.666    -0.530     0.200
     0.345     1.183     0.200
     0.495     1.079     0.200
     1.522    -1.847     0.200
     0.447     2.206     0.200
     1.384    -2.365     0.200
     1.640    -1.333     0.200
     2.306    -4.426     0.200
     2.359    -3.345     0.200
     3.707   -10.409     0.200
     0.597     1.456     0.200
     1.236     0.067     0.200
     1.868    -2.424     0.200
     3.079    -5.683     0.200
     0.442     1.215     0.200
     1.463    -0.471     0.200
     3.032    -4.159     0.200
     0.430     1.760     0.200
     1.555     0.319     0.200
     1.536     0.754     0.200
     1.677    -1.028     0.200
     2.621    -3.861     0.200
     0.378     1.522     0.200
     1.500    -0.257     0.200
     1.534    -0.902     0.200
     1.609     0.838     0.200
     1.606    -0.870     0.200
     2.119    -0.901     0.200
     2.063    -3.615     0.200
     0.328     1.136     0.200
     1.646    -0.744     0.200
     1.656    -0.532     0.200
     2.046    -2.174     0.200
     3.155    -6.080     0.200
     3.274    -6.504     0.200
     3.826   -10.073     0.200
     0.345     1.303     0.200
     1.357     0.763     0.200
     0.429     1.465     0.200
     1.496    -1.162     0.200
     1.531    -0.602     0.200
     4.099    -6.398     0.200
     0.456     0.953     0.200
     1.511    -0.610     0.200
     0.552     2.096     0.200
     0.669     1.257     0.200
     1.171    -0.572     0.200
     1.635    -0.043     0.200
     1.370    -1.166     0.200
     2.025    -2.497     0.200
     3.056    -8.253     0.200
     0.438     1.320     0.200
     2.115    -3.297     0.200
     3.547    -9.891     0.200
     0.314     0.857     0.200
     1.680    -1.369     0.200
     2.031    -2.239     0.200
     0.527     1.227     0.200
     0.809     1.166     0.200
     1.323    -0.637     0.200
     0.399     1.199     0.200
     0.892     1.809     0.200
     2.005    -2.458     0.200
     3.109    -5.968     0.200
     3.265    -8.740     0.200
     0.827     1.594     0.200
     0.973     2.202     0.200
     1.469    -0.470     0.200
     1.622    -1.978     0.200
     1.791    -2.285     0.200
     2.131    -3.680     0.200
     2.179    -1.165     0.200
     0.853     2.422     0.200
     0.963     1.637     0.200
     1.840    -2.610     0.200
     2.056    -3.054     0.200
     2.153    -3.341     0.200
     3.080    -3.966     0.200
     0.356     1.610     0.200
     0.640     2.111     0.200
     1.196    -0.013     0.200
     1.696    -1.590     0.200
     1.759    -1.793     0.200
     2.319    -1.708     0.200
     0.415     1.330     0.200
     0.855     2.178     0.200
     0.955     2.701     0.200
     2.071    -2.993     0.200
     2.258    -4.230     0.200
     3.063    -6.863     0.200
     0.333     1.378     0.200
     0.690     1.598     0.200
     1.090     1.974     0.200
     1.660    -0.787     0.200
     1.654    -1.162     0.200
     1.792    -0.643     0.200
     1.988    -2.026     0.200
     2.051    -2.786     0.200
     2.329    -2.323     0.200
     0.161     1.252     0.200
     0.741     1.128     0.200
     0.932     1.400     0.200
     1.547    -0.351     0.200
     1.819     0.640     0.200
     1.868     1.693     0.200
     1.956     0.538     0.200
     2.310    -0.364     0.200
     0.512    -0.086     0.200
     1.218     1.555     0.200
     1.127     2.185     0.200
     1.485     0.727     0.200
     1.560     0.540     0.200
     2.191    -1.822     0.200
     2.973    -4.662     0.200
     0.503     0.712     0.200
     0.855     2.473     0.200
     0.939     1.983     0.200
     1.361     0.296     0.200
     1.837    -1.448     0.200
     2.111    -2.609     0.200
     2.205    -2.985     0.200
     2.998    -5.687     0.200
     0.445     1.451     0.200
     0.879     2.089     0.200
     0.924     1.346     0.200
     1.434    -2.118     0.200
     1.585    -1.612     0.200
     1.827    -2.776     0.200
     2.221    -3.154     0.200
     2.509    -5.364     0.200
     0.573     1.665     0.200
     0.658     1.375     0.200
     1.883    -3.657     0.200
     2.044    -3.700     0.200
     0.601     3.235     0.200
     0.619     1.143     0.200
     1.219    -0.669     0.200
     1.929    -3.010     0.200
     2.084    -3.209     0.200
     2.328    -3.459     0.200
     0.548     0.665     0.200
     1.881    -0.720     0.200
     2.096    -1.491     0.200
     0.310     1.221     0.200
     1.653    -0.704     0.200
     1.950    -0.392     0.200
     2.032    -2.548     0.200
     0.433     0.975     0.200
     0.868     1.953     0.200
     1.456    -0.749     0.200
     1.585    -0.635     0.200
     2.117    -2.771     0.200
     0.342     1.421     0.200
     0.545     1.390     0.200
     0.617     1.243     0.200
     1.017     0.923     0.200
     1.237     1.207     0.200
     1.694     0.046     0.200
     2.062    -2.014     0.200
     2.351     0.463     0.200
     0.411     1.825     0.200
     0.673     2.717     0.200
     1.193    -0.082     0.200
     2.178    -2.248     0.200
     3.135    -7.720     0.200
     0.321     0.996     0.200
     0.536     0.972     0.200
     0.755     2.652     0.200
     1.028     2.539     0.200
     1.463    -0.840     0.200
     3.295    -7.672     0.200
     0.423     0.888     0.200
     0.240     0.776     0.200
     0.451     1.038     0.200
     0.859     2.042     0.200
     1.606    -0.956     0.200
     1.806    -1.690     0.200
     2.106    -2.572     0.200
     2.103    -2.833     0.200
     2.223    -3.722     0.200
     3.174    -8.255     0.200
     0.465     1.173     0.200
     0.630     2.015     0.200
     1.163     1.773     0.200
     1.591    -0.290     0.200
     1.770    -1.047     0.200
     2.202    -3.236     0.200
     2.584    -3.728     0.200
     0.506     1.639     0.200
     0.607     2.022     0.200
     1.172     1.910     0.200
     1.508    -0.779     0.200
     2.225    -3.170     0.200
     3.105    -4.280     0.200
     0.393     1.629     0.200
     0.769     2.523     0.200
     1.635    -0.296     0.200
     2.087    -2.720     0.200
     3.664    -5.930     0.200
     0.391     1.152     0.200
     0.802     2.395     0.200
     1.413     0.964     0.200
     1.597    -0.378     0.200
     3.216    -3.808     0.200
     0.433     1.189     0.200
     0.825     1.852     0.200
     0.977     1.999     0.200
     1.400    -0.707     0.200
     2.232    -3.886     0.200
     0.346     1.248     0.200
     0.722     2.424     0.200
     1.353    -0.985     0.200
     1.486    -1.031     0.200
     0.302     2.381     0.200
     0.418     1.248     0.200
     0.805     2.286     0.200
     1.499    -1.450     0.200
     1.625    -1.278     0.200
     2.242    -4.509     0.200
     0.839     2.293     0.200
     1.371    -0.096     0.200
     2.195    -3.535     0.200
     0.414     1.543     0.200
     0.838     1.910     0.200
     1.480    -1.505     0.200
     1.597    -1.643     0.200
     2.146    -3.363     0.200
     2.253    -4.451     0.200
     2.470    -1.730     0.200
     3.159    -5.206     0.200
     0.251     1.386     0.200
     0.419     1.182     0.200
     0.869     2.099     0.200
     1.574    -1.488     0.200
     2.090    -2.218     0.200
     2.128    -3.090     0.200
     2.199    -0.776     0.200
     0.401     1.183     0.200
     0.304     0.847     0.200
     0.813     2.347     0.200
     1.404     0.281     0.200
     1.608    -0.262     0.200
     2.040    -1.982     0.200
     2.260    -1.954     0.200
     3.070    -6.696     0.200
     0.270     1.600     0.200
     0.656     1.760     0.200
     0.947     0.777     0.200
     2.368    -3.658     0.200
     0.481     1.377     0.200
     1.012     1.773     0.200
     1.402    -0.306     0.200
     1.486    -0.322     0.200
     2.040    -2.398     0.200
     2.276    -2.615     0.200
     0.615     1.234     0.200
     1.407    -0.529     0.200
     1.919    -1.394     0.200
     3.241    -5.044     0.200
     0.476     1.172     0.200
     0.697     1.169     0.200
     1.220     0.752     0.200
     1.513    -0.782     0.200
     1.533    -2.096     0.200
     1.682    -0.255     0.200
     1.739    -1.336     0.200
     2.178    -2.510     0.200
     2.186    -2.825     0.200
     0.355     1.372     0.200
     0.687     1.631     0.200
     0.687     1.031     0.200
     1.109     0.974     0.200
     1.109     2.834     0.200
     1.521    -1.755     0.200
     1.521    -0.496     0.200
     1.668     0.196     0.200
     1.773     0.261     0.200
     1.773     1.251     0.200
     2.305    -3.115     0.200
     4.811    -6.655     0.200
     0.750     1.182     0.200
     1.020    -1.035     0.200
     1.104    -1.115     0.200
     1.521    -0.135     0.200
     1.415    -1.555     0.200
     1.694    -2.304     0.200
     2.378    -6.576     0.200
     2.385    -3.655     0.200
     3.344   -10.329     0.200
     0.558     1.423     0.200
     0.787     2.942     0.200
     1.002     3.771     0.200
     1.551    -0.276     0.200
     2.184    -2.047     0.200
     2.184    -0.844     0.200
     0.462     2.823     0.200
     0.645     0.462     0.200
     0.803     0.479     0.200
     2.573    -5.466     0.200
     0.289     1.349     0.200
     0.441     1.011     0.200
     0.807     1.483     0.200
     0.991     2.188     0.200
     1.639    -0.705     0.200
     2.022    -2.627     0.200
     2.140    -3.355     0.200
     2.219    -0.619     0.200
     0.266     1.471     0.200
     0.857     1.669     0.200
     1.473    -1.066     0.200
     1.577    -0.793     0.200
     1.837    -2.134     0.200
     2.063    -3.406     0.200
     2.184    -1.300     0.200
     2.143    -3.651     0.200
     2.266    -3.532     0.200
     3.071    -7.425     0.200
     0.173     1.389     0.200
     0.399     0.740     0.200
     0.442     0.973     0.200
     0.485     1.350     0.200
     0.770     0.948     0.200
     0.927     1.909     0.200
     1.499    -0.730     0.200
     1.572    -0.877     0.200
     1.840    -1.083     0.200
     2.052    -2.314     0.200
     2.127    -1.948     0.200
     2.099    -3.051     0.200
     0.361     1.545     0.200
     0.656     0.910     0.200
     1.049     0.233     0.200
     1.179     0.806     0.200
     1.319     0.195     0.200
     0.076     1.531     0.200
     0.446     0.637     0.200
     0.663     2.713     0.200
     0.768     0.147     0.200
     0.948     1.960     0.200
     1.001     2.595     0.200
     1.499    -0.672     0.200
     0.158    -0.136     0.200
     1.531     0.310     0.200
     1.782     0.171     0.200
     0.212     3.017     0.200
     0.338     1.803     0.200
     0.517     3.068     0.200
     0.609     1.164     0.200
     0.730     1.610     0.200
     0.936     1.769     0.200
     1.052    -0.418     0.200
     1.457     1.249     0.200
     1.630    -1.913     0.200
     1.866    -0.447     0.200
     1.808    -1.653     0.200
     2.036    -3.012     0.200
     2.452    -5.620     0.200
     2.693    -6.357     0.200
     3.241    -7.706     0.200
     0.264     0.287     0.200
     0.352     0.863     0.200
     0.383     1.031     0.200
     0.428     0.940     0.200
     0.856     1.402     0.200
     0.845     1.846     0.200
     0.845     1.686     0.200
     1.378     0.214     0.200
     1.466    -0.822     0.200
     2.087    -2.905     0.200
     2.186    -2.131     0.200
     0.420     1.146     0.200
     0.961     2.999     0.200
     1.471    -1.861     0.200
     2.183    -0.880     0.200
     2.669    -6.062     0.200
     0.260     1.373     0.200
     0.421     1.508     0.200
     0.856     1.350     0.200
     1.366     0.189     0.200
     1.826    -1.804     0.200
     2.076    -3.200     0.200
     0.281     0.859     0.200
     0.363     0.940     0.200
     0.413     1.194     0.200
     0.590     1.170     0.200
     0.753     1.645     0.200
     0.774     1.273     0.200
     0.915     1.060     0.200
     1.445    -0.993     0.200
     1.773    -1.054     0.200
     2.122    -0.993     0.200
     2.230    -0.019     0.200
     2.242    -3.438     0.200
     0.345     0.931     0.200
     0.736     1.917     0.200
     0.736     1.628     0.200
     1.053     1.264     0.200
     1.249     2.224     0.200
     2.176     1.808     0.200
     2.175    -1.460     0.200
     0.133     3.702     0.200
     0.582     1.246     0.200
     1.068    -1.701     0.200
     1.163    -1.715     0.200
     1.476    -1.142     0.200
     1.459     1.997     0.200
     1.642    -2.946     0.200
     1.565    -1.685     0.200
     1.818    -0.983     0.200
     2.426    -5.362     0.200
     0.368     1.111     0.200
     0.453     0.929     0.200
     0.832     0.512     0.200
     0.854     1.911     0.200
     0.944     2.359     0.200
     1.442    -1.420     0.200
     2.107    -3.088     0.200
     2.107    -2.706     0.200
     0.466     1.127     0.200
     0.767     0.748     0.200
     0.846     1.029     0.200
     1.262    -0.081     0.200
     1.395    -1.611     0.200
     1.528     1.564     0.200
     2.599    -5.407     0.200
     0.977    -0.155     0.200
     2.535    -4.208     0.200
     0.452     1.031     0.200
     0.804     1.810     0.200
     0.854     1.433     0.200
     0.900     2.113     0.200
     0.904     1.799     0.200
     1.690    -1.832     0.200
     1.844    -2.373     0.200
     2.088    -3.908     0.200
     2.242    -4.232     0.200
     2.241    -0.421     0.200
     2.699    -5.098     0.200
     2.748    -6.016     0.200
     0.295     1.447     0.200
     0.350     1.707     0.200
     0.438     1.104     0.200
     0.564     2.271     0.200
     0.877     0.409     0.200
     0.882     2.450     0.200
     1.542    -0.969     0.200
     1.588    -0.580     0.200
     1.773    -1.403     0.200
     2.017    -3.616     0.200
     2.145    -3.560     0.200
     2.225    -2.939     0.200
     2.658    -3.860     0.200
     2.672    -4.840     0.200
     2.874    -6.099     0.200
     0.480     2.749     0.200
     0.619     1.260     0.200
     0.663     1.664     0.200
     0.950    -0.294     0.200
     1.143     0.930     0.200
     1.194    -0.164     0.200
     1.456    -1.500     0.200
     1.480    -1.174     0.200
     1.682    -0.530     0.200
     2.006    -4.856     0.200
     2.522    -7.382     0.200
     0.236     3.709     0.200
     0.498     1.999     0.200
     0.588     1.050     0.200
     0.894     1.072     0.200
     0.901     0.534     0.200
     1.062    -0.713     0.200
     1.067     0.119     0.200
     1.134    -0.757     0.200
     1.235    -1.407     0.200
     1.511    -0.990     0.200
     1.531    -0.630     0.200
     1.530    -0.924     0.200
     1.819    -2.146     0.200
     2.130    -1.890     0.200
     2.275    -1.906     0.200
     2.453    -6.673     0.200
     2.435    -5.927     0.200
     3.069    -8.362     0.200
     3.343    -6.955     0.200
     3.597   -11.469     0.200
EOF
gmt end
