#!/bin/bash
gmt begin bohol1.86_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional bohol1.86'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.394
    14.500    42.117
    15.000    41.838
    15.500    41.557
    16.000    41.272
    16.500    40.983
    17.000    40.686
    17.500    40.381
    18.000    40.066
    18.500    39.738
    19.000    39.396
    19.500    39.036
    20.000    38.658
    20.500    38.258
    21.000    37.835
    21.500    37.386
    22.000    36.909
    22.500    36.402
    23.000    35.863
    23.500    35.291
    24.000    34.049
    24.500    32.777
    25.000    31.496
    25.500    30.203
    26.000    28.900
    26.500    27.585
    27.000    26.258
    27.500    24.914
    28.000    23.550
    28.500    22.171
    29.000    20.781
    29.500    19.382
    30.000    17.975
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.550 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     8.223
     1.500     9.295
     2.000    10.367
     2.500    11.439
     3.000    12.508
     3.500    13.576
     4.000    14.639
     4.500    15.701
     5.000    16.759
     5.500    17.812
     6.000    18.861
     6.500    19.905
     7.000    20.944
     7.500    21.976
     8.000    23.002
     8.500    24.022
     9.000    25.033
     9.500    26.038
    10.000    27.034
    10.500    28.025
    11.000    29.015
    11.500    30.005
    12.000    30.993
    12.500    31.979
    13.000    32.961
    13.500    33.941
    14.000    34.917
    14.500    35.891
    15.000    36.662
    15.500    37.376
    16.000    38.031
    16.500    38.563
    17.000    39.028
    17.500    39.272
    18.000    39.616
    18.500    39.902
    19.000    40.130
    19.500    40.300
    20.000    40.411
    20.500    40.464
    21.000    40.457
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    29.961 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.726
     1.000     6.996
     1.500     9.729
     2.000    12.420
     2.500    15.111
     3.000    17.801
     3.500    20.490
     4.000    23.179
     4.500    25.865
     5.000    28.551
     5.500    31.236
     6.000    33.919
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.551 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    23.078
     1.500    29.578
     2.000    36.077
     2.500    42.577
     3.000    49.076
     3.500    55.572
     4.000    62.066
     4.500    68.557
     5.000    75.044
     5.500    81.528
     6.000    88.008
     6.500    94.483
     7.000   100.954
     7.500   107.418
     8.000   113.878
     8.500   120.330
     9.000   126.777
     9.500   133.215
    10.000   139.647
    10.500   146.070
    11.000   152.486
    11.500   158.893
    12.000   165.290
    12.500   171.678
    13.000   178.057
    13.500   184.427
    14.000   190.785
    14.500   197.132
    15.000   203.469
    15.500   209.794
    16.000   216.107
    16.500   222.407
    17.000   228.694
    17.500   233.856
    18.000   240.127
    18.500   246.385
    19.000   252.630
    19.500   258.862
    20.000   265.080
    20.500   271.284
    21.000   277.472
    21.500   283.646
    22.000   289.803
    22.500   295.945
    23.000   302.070
    23.500   308.179
    24.000   314.271
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    60.066 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.549
     1.000    21.134
     1.500    29.694
     2.000    38.254
     2.500    46.813
     3.000    55.370
     3.500    63.926
     4.000    72.480
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    61.926 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    23.305   293.531     0.150
    16.265   224.120     0.150
    16.501   229.365     0.150
    28.081   306.220     0.150
    15.576   218.904     0.150
    19.845    49.091     0.150
    20.252    54.633     0.150
    23.843   298.625     0.150
    23.956    62.210     0.150
    27.150   299.832     0.150
    28.082   304.966     0.150
    28.572    72.246     0.150
    28.572   309.246     0.150
    19.803    51.977     0.150
    17.162    44.741     0.150
    21.484   289.297     0.150
    22.834   283.543     0.150
    17.151    44.300     0.150
    17.151   237.300     0.150
    29.888   321.399     0.150
    20.119   274.257     0.150
    21.429   268.975     0.150
    21.429   282.975     0.150
    29.536   308.857     0.150
    19.645    50.092     0.150
    20.973   272.803     0.150
    20.973   304.803     0.150
    23.654   289.508     0.150
    27.849   310.554     0.150
    29.537   315.860     0.150
    15.960   227.344     0.150
    27.999    72.845     0.150
    27.999   218.845     0.150
    27.999   381.845     0.150
    28.607    80.751     0.150
    21.145   265.393     0.150
    21.145   281.393     0.150
    23.153   279.965     0.150
    25.657   235.340     0.150
    28.039   325.950     0.150
    28.039   387.950     0.150
    22.362   284.696     0.150
    23.670   291.432     0.150
    17.526    46.500     0.150
    26.860  -302.803     0.150
    26.860   230.229     0.150
    27.870  -314.301     0.150
    26.439   453.279     0.150
    26.289   235.066     0.150
    17.214    45.509     0.150
    21.149   268.991     0.150
    23.174   287.654     0.150
    23.174   331.154     0.150
    25.812   293.785     0.150
    25.812   362.685     0.150
    21.385   270.813     0.150
    25.795   297.846     0.150
    22.837   305.493     0.150
    23.591   287.688     0.150
    25.593   298.825     0.150
    16.913    55.090     0.150
    16.913   231.490     0.150
    23.673   257.402     0.150
    23.673   282.402     0.150
    23.673   467.702     0.150
    23.673   476.303     0.150
    25.710   294.028     0.150
    25.710   321.128     0.150
    25.710   364.227     0.150
    25.710    73.028     0.150
    28.543    76.072     0.150
    28.543   209.272     0.150
    28.543   305.072     0.150
    28.543   396.072     0.150
    28.543   431.272     0.150
    29.519  -327.101     0.150
    16.813   227.960     0.150
    25.967   235.334     0.150
    15.825    48.505     0.150
    17.573    44.706     0.150
    19.986   251.374     0.150
    20.714   263.094     0.150
    22.552   280.697     0.150
    22.552   292.697     0.150
    22.552   324.197     0.150
    23.324  1633.924     0.150
    23.946   281.357     0.150
    24.198   290.850     0.150
    25.269    71.396     0.150
    25.747   238.547     0.150
    25.747   238.551     0.150
    25.747   298.543     0.150
    25.957   299.393     0.150
    27.631   219.970     0.150
    27.631   305.951     0.150
    27.872   305.741     0.150
    28.955   313.579     0.150
    29.461   203.871     0.150
    29.461   316.871     0.150
    29.461   203.830     0.150
    29.461   315.421     0.150
    29.960   314.426     0.150
    19.889    52.628     0.150
    23.543   259.009     0.150
    25.922   236.497     0.150
    29.485   202.258     0.150
    29.485   202.257     0.150
    26.071   298.971     0.150
    25.813   237.300     0.150
    25.813   241.267     0.150
    25.813   238.760     0.150
    25.615   242.907     0.150
    19.979    51.238     0.150
    19.939    51.302     0.150
    29.734   201.612     0.150
    23.254   286.296     0.150
    23.259    66.058     0.150
    23.259   282.958     0.150
    23.259   299.158     0.150
    23.259   327.658     0.150
    25.933   236.953     0.150
    25.933   236.753     0.150
    25.932   236.781     0.150
    27.860   218.089     0.150
    22.449   282.044     0.150
    23.277   296.381     0.150
    25.280    68.806     0.150
    25.280   291.606     0.150
    25.752   240.357     0.150
    25.235    71.700     0.150
    25.235   298.200     0.150
    28.079   310.311     0.150
    22.495   282.123     0.150
    22.595    69.149     0.150
    22.595   283.749     0.150
    23.364    69.282     0.150
    23.364   288.483     0.150
    23.364   293.782     0.150
    23.364   335.182     0.150
    25.380   299.254     0.150
    25.380   358.455     0.150
    25.874   240.543     0.150
    26.972   306.571     0.150
    27.812   309.077     0.150
    28.245   310.215     0.150
    15.843   222.154     0.150
    24.150   252.892     0.150
    25.096   291.170     0.150
    25.490   242.326     0.150
    25.607   239.530     0.150
    27.795   219.430     0.150
    28.041   308.407     0.150
    29.708   201.917     0.150
    29.708   314.747     0.150
    29.708   202.449     0.150
    29.708  2063.513     0.150
    16.416    47.130     0.150
    25.706   239.816     0.150
    25.926   236.967     0.150
    25.926   237.070     0.150
    27.616   221.571     0.150
    27.894   217.908     0.150
    28.112   309.236     0.150
    29.458   311.525     0.150
    29.458   204.784     0.150
    25.838   240.345     0.150
    16.433   229.290     0.150
    25.236    72.252     0.150
    25.236   295.651     0.150
    25.236   307.651     0.150
    23.162   284.509     0.150
    23.162   292.310     0.150
    25.128   293.565     0.150
    25.528   242.793     0.150
    25.528   242.794     0.150
    28.067   307.668     0.150
    16.260   230.071     0.150
    22.470   281.096     0.150
    23.152    68.644     0.150
    25.101   296.292     0.150
    25.101   310.792     0.150
    27.736   310.052     0.150
    28.064   309.321     0.150
    16.645   231.752     0.150
    22.521   286.179     0.150
    23.421   335.983     0.150
    25.447   299.038     0.150
    25.447   312.438     0.150
    27.846   309.435     0.150
    28.297   312.274     0.150
    25.836   239.612     0.150
    27.913   218.521     0.150
    16.280   225.537     0.150
    28.157   311.405     0.150
    25.092   309.757     0.150
    25.092   354.558     0.150
    25.443   242.918     0.150
    25.443   242.918     0.150
    28.065   309.167     0.150
    22.645   289.776     0.150
    25.743   236.668     0.150
    25.756   240.600     0.150
    15.885   223.508     0.150
    16.347   229.126     0.150
    22.471   284.057     0.150
    22.643   286.439     0.150
    23.208    71.052     0.150
    23.208   288.950     0.150
    25.583   242.027     0.150
    25.583   242.035     0.150
    27.751    72.634     0.150
    27.751   224.532     0.150
    27.751   665.329     0.150
    27.798   219.344     0.150
    27.798   219.961     0.150
    29.079   314.835     0.150
    16.644   238.811     0.150
    19.801    51.569     0.150
    22.477    70.037     0.150
    22.477   285.037     0.150
    22.621   288.058     0.150
    25.256   298.402     0.150
    25.256   361.603     0.150
    27.772   312.240     0.150
    27.772   444.840     0.150
    22.553   281.154     0.150
    25.162   290.810     0.150
    17.651    45.352     0.150
    22.334   286.263     0.150
    22.422   285.737     0.150
    23.241    68.673     0.150
    23.241   290.477     0.150
    23.241   330.774     0.150
    25.819   239.790     0.150
    26.799   321.752     0.150
    27.659   310.620     0.150
    22.531   286.473     0.150
    23.203    69.966     0.150
    25.229   294.215     0.150
    25.756   240.461     0.150
    25.756   240.461     0.150
    23.304   288.841     0.150
    23.304   335.544     0.150
    25.884   240.084     0.150
    25.884   240.085     0.150
    25.884   239.624     0.150
    25.980   239.621     0.150
    27.750   307.521     0.150
    22.422   282.478     0.150
    25.246    67.125     0.150
    25.246   291.425     0.150
    25.716   236.890     0.150
    25.716   236.889     0.150
    27.642   219.561     0.150
    27.699   218.895     0.150
    27.725   305.090     0.150
    27.868   216.572     0.150
    16.468    53.339     0.150
    23.238    68.529     0.150
    23.238   288.334     0.150
    25.267   294.356     0.150
    25.795   239.281     0.150
    25.795   236.968     0.150
    27.998   216.460     0.150
    28.115   308.619     0.150
    25.829   239.931     0.150
    19.886    51.681     0.150
    21.270   272.294     0.150
    23.303    70.769     0.150
    23.303   286.667     0.150
    25.310    72.037     0.150
    25.310   294.939     0.150
    25.790   238.844     0.150
    26.953   304.776     0.150
    27.644   220.727     0.150
    27.769   220.141     0.150
    29.461   317.504     0.150
    29.461   204.005     0.150
    25.771   239.579     0.150
    25.724   240.626     0.150
    25.942   238.702     0.150
    25.747   239.447     0.150
    15.166    44.502     0.150
    17.164    46.362     0.150
    29.180   311.320     0.150
    26.190   234.094     0.150
    16.303   224.756     0.150
    17.304   235.084     0.150
    21.554   270.480     0.150
    22.928   282.448     0.150
    22.954   283.138     0.150
    23.243   257.352     0.150
    26.084   294.118     0.150
    26.651   226.579     0.150
    26.651   226.704     0.150
    26.651   683.602     0.150
    27.231   298.231     0.150
    27.580   302.151     0.150
    29.068   307.795     0.150
    29.212   309.610     0.150
    29.377   300.180     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    19.604    38.319     0.200
    20.542    36.077     0.200
    23.051    37.792     0.200
    23.235    35.650     0.200
    23.381    31.641     0.200
    23.305    36.727     0.200
    24.728    31.222     0.200
    25.608    27.854     0.200
    25.919    27.825     0.200
    26.084    29.188     0.200
    26.532    24.966     0.200
    29.719    20.976     0.200
    15.775    38.207     0.200
    16.280    44.320     0.200
    16.869    42.440     0.200
    21.027    37.421     0.200
    22.403    34.863     0.200
    22.448    36.838     0.200
    23.327    34.077     0.200
    23.766    32.956     0.200
    23.588    35.536     0.200
    24.171    32.230     0.200
    24.329    32.177     0.200
    25.204    30.077     0.200
    25.701    29.672     0.200
    26.480    26.776     0.200
    26.839    25.288     0.200
    26.788    24.784     0.200
    27.834    22.885     0.200
    28.420    21.436     0.200
    28.828    16.883     0.200
    29.543    18.539     0.200
    29.552    19.429     0.200
    29.977    16.471     0.200
    16.501    38.466     0.200
    20.654    33.901     0.200
    21.200    37.421     0.200
    21.236    36.405     0.200
    21.782    34.935     0.200
    22.786    33.015     0.200
    22.830    35.008     0.200
    22.982    35.827     0.200
    23.241    31.712     0.200
    23.049    33.951     0.200
    23.814    33.121     0.200
    25.240    29.380     0.200
    25.422    26.256     0.200
    25.361    28.964     0.200
    28.081    20.021     0.200
    28.372    19.127     0.200
    14.746    44.095     0.200
    15.942    40.634     0.200
    16.186    42.186     0.200
    16.957    40.293     0.200
    17.034    40.887     0.200
    21.071    37.782     0.200
    21.423    34.675     0.200
    22.114    38.607     0.200
    22.505    35.547     0.200
    22.735    35.855     0.200
    22.769    35.767     0.200
    23.418    31.388     0.200
    23.418    33.788     0.200
    23.445    34.078     0.200
    23.705    35.035     0.200
    23.731    34.738     0.200
    23.843    33.227     0.200
    23.956    33.912     0.200
    24.529    30.923     0.200
    24.539    33.309     0.200
    24.939    30.836     0.200
    25.590    28.847     0.200
    25.722    28.507     0.200
    25.708    29.161     0.200
    25.750    30.177     0.200
    25.750    30.488     0.200
    25.926    28.123     0.200
    26.318    25.547     0.200
    26.379    27.339     0.200
    26.379    26.538     0.200
    26.449    26.519     0.200
    26.539    24.963     0.200
    26.892    25.846     0.200
    27.150    24.133     0.200
    27.684    25.611     0.200
    28.082    21.966     0.200
    28.572    21.746     0.200
    29.102    19.061     0.200
    29.349    17.183     0.200
    29.349    17.318     0.200
    29.479    19.755     0.200
    29.870    18.096     0.200
    16.047    43.806     0.200
    16.226    40.714     0.200
    17.031    41.721     0.200
    17.139    40.664     0.200
    20.961    38.558     0.200
    21.554    37.536     0.200
    22.898    35.251     0.200
    23.291    33.266     0.200
    23.801    36.910     0.200
    23.929    35.415     0.200
    25.969    28.216     0.200
    29.396    17.025     0.200
    29.472    16.131     0.200
    14.774    41.675     0.200
    16.124    40.412     0.200
    16.190    40.244     0.200
    16.945    40.837     0.200
    17.040    40.726     0.200
    21.015    38.338     0.200
    21.456    37.794     0.200
    21.504    39.638     0.200
    22.120    38.637     0.200
    22.120    38.438     0.200
    22.103    36.644     0.200
    22.453    36.555     0.200
    22.755    37.032     0.200
    22.798    35.730     0.200
    23.392    31.598     0.200
    23.392    36.598     0.200
    23.396    33.548     0.200
    23.681    34.225     0.200
    23.908    33.776     0.200
    24.494    31.734     0.200
    24.987    30.990     0.200
    24.987    31.291     0.200
    25.640    28.168     0.200
    25.640    27.367     0.200
    25.690    28.484     0.200
    25.757    26.799     0.200
    25.900    28.332     0.200
    26.369    26.755     0.200
    26.369    25.855     0.200
    26.356    27.211     0.200
    26.400    26.201     0.200
    26.589    26.095     0.200
    26.589    25.295     0.200
    27.695    26.389     0.200
    27.696    22.369     0.200
    27.696    23.269     0.200
    28.096    21.698     0.200
    28.576    21.607     0.200
    29.282    17.264     0.200
    29.282    16.864     0.200
    29.287    18.005     0.200
    29.287    17.806     0.200
    29.486    17.983     0.200
    29.401    17.068     0.200
    29.401    16.472     0.200
    29.910    16.538     0.200
    29.893    17.132     0.200
    16.839    38.324     0.200
    16.972    38.074     0.200
    20.910    35.720     0.200
    21.462    35.069     0.200
    22.722    34.371     0.200
    22.792    33.547     0.200
    23.625    32.835     0.200
    23.758    32.274     0.200
    25.770    25.700     0.200
    26.230    24.426     0.200
    26.230    24.625     0.200
    27.172    22.441     0.200
    28.050    19.388     0.200
    28.502    18.812     0.200
    29.483    12.468     0.200
    29.583    13.304     0.200
    29.869    14.461     0.200
    15.779    44.878     0.200
    16.069    44.892     0.200
    17.108    40.566     0.200
    21.484    37.797     0.200
    22.640    37.809     0.200
    22.842    34.950     0.200
    22.834    36.943     0.200
    23.605    35.552     0.200
    23.842    35.785     0.200
    23.996    33.985     0.200
    24.102    35.151     0.200
    24.700    33.770     0.200
    25.896    30.809     0.200
    26.086    28.490     0.200
    26.271    28.935     0.200
    26.538    28.219     0.200
    26.538    27.219     0.200
    27.226    25.598     0.200
    28.702    22.063     0.200
    29.960    16.585     0.200
    21.385    37.391     0.200
    22.756    36.298     0.200
    22.778    35.637     0.200
    23.416    32.190     0.200
    23.847    35.365     0.200
    24.255    33.199     0.200
    26.615    25.861     0.200
    28.696    20.577     0.200
    29.309    17.422     0.200
    29.892    15.812     0.200
    16.036    42.052     0.200
    16.122    41.045     0.200
    17.117    39.939     0.200
    17.129    43.295     0.200
    19.969    34.958     0.200
    19.969    34.956     0.200
    21.391    37.255     0.200
    22.757    35.115     0.200
    22.770    35.466     0.200
    23.417    31.919     0.200
    23.643    36.278     0.200
    23.821    35.594     0.200
    24.203    32.446     0.200
    26.573    25.084     0.200
    28.137    20.328     0.200
    28.673    19.970     0.200
    29.888    15.700     0.200
    17.118    42.538     0.200
    21.370    38.516     0.200
    22.738    34.452     0.200
    22.755    36.751     0.200
    24.105    33.895     0.200
    24.224    34.106     0.200
    26.580    27.615     0.200
    27.122    26.087     0.200
    28.125    22.786     0.200
    29.871    18.603     0.200
    21.429    37.475     0.200
    22.783    35.674     0.200
    22.767    36.858     0.200
    23.398    31.992     0.200
    23.941    33.662     0.200
    24.053    34.253     0.200
    25.821    31.725     0.200
    26.465    26.200     0.200
    27.166    24.927     0.200
    28.121    22.375     0.200
    28.628    20.563     0.200
    29.102    19.227     0.200
    29.896    17.569     0.200
    21.452    36.711     0.200
    22.812    34.839     0.200
    22.810    34.866     0.200
    24.129    34.571     0.200
    26.620    28.403     0.200
    28.169    21.315     0.200
    28.688    21.066     0.200
    29.933    16.733     0.200
    15.779    35.907     0.200
    16.926    40.023     0.200
    20.968    35.043     0.200
    22.362    31.585     0.200
    22.448    33.582     0.200
    23.662    32.410     0.200
    23.715    30.791     0.200
    24.542    30.645     0.200
    25.801    27.443     0.200
    26.217    24.592     0.200
    26.631    24.064     0.200
    26.749    21.586     0.200
    27.852    19.015     0.200
    28.481    18.374     0.200
    28.614    17.621     0.200
    28.668    14.986     0.200
    28.668    14.787     0.200
    29.536    16.457     0.200
    22.459    37.909     0.200
    27.861    24.370     0.200
    28.484    23.799     0.200
    29.550    19.659     0.200
    17.024    44.337     0.200
    20.940    39.742     0.200
    22.330    38.018     0.200
    22.410    38.090     0.200
    23.616    37.411     0.200
    25.754    32.064     0.200
    27.811    24.449     0.200
    28.436    23.966     0.200
    20.994    39.929     0.200
    22.471    40.696     0.200
    23.680    38.991     0.200
    27.874    24.942     0.200
    28.500    23.339     0.200
    15.825    40.874     0.200
    17.061    44.452     0.200
    20.973    41.002     0.200
    22.207    38.399     0.200
    22.364    40.562     0.200
    22.446    37.602     0.200
    23.122    36.419     0.200
    23.800    34.809     0.200
    23.654    37.908     0.200
    24.522    34.077     0.200
    25.791    33.766     0.200
    26.171    28.135     0.200
    26.203    31.768     0.200
    26.617    29.338     0.200
    26.617    28.938     0.200
    27.034    28.067     0.200
    27.034    28.667     0.200
    27.849    24.054     0.200
    28.474    23.058     0.200
    29.537    22.161     0.200
    26.431    30.335     0.200
    16.947    43.513     0.200
    21.040    39.043     0.200
    23.586    37.037     0.200
    26.799    26.829     0.200
    27.838    23.907     0.200
    28.420    22.118     0.200
    29.561    19.603     0.200
    15.864    42.378     0.200
    20.941    40.232     0.200
    21.993    39.157     0.200
    22.306    39.300     0.200
    23.400    38.040     0.200
    23.811    35.744     0.200
    25.242    33.038     0.200
    25.242    33.038     0.200
    27.261    26.573     0.200
    29.182    20.257     0.200
    15.960    44.044     0.200
    16.266    45.272     0.200
    20.025    37.907     0.200
    20.025    38.208     0.200
    21.139    37.904     0.200
    21.606    37.451     0.200
    21.606    38.349     0.200
    22.529    36.686     0.200
    22.602    37.328     0.200
    23.001    38.875     0.200
    23.076    37.296     0.200
    23.636    33.561     0.200
    23.767    35.237     0.200
    23.780    35.687     0.200
    24.228    35.858     0.200
    24.498    32.005     0.200
    24.483    31.974     0.200
    24.903    33.973     0.200
    25.098    30.701     0.200
    25.098    31.302     0.200
    25.812    28.371     0.200
    25.812    29.269     0.200
    25.901    29.324     0.200
    26.060    28.472     0.200
    26.915    26.094     0.200
    27.142    25.544     0.200
    27.783    22.168     0.200
    27.999    23.845     0.200
    28.607    21.950     0.200
    28.704    19.919     0.200
    28.722    20.610     0.200
    28.832    18.221     0.200
    29.696    18.937     0.200
    15.424    36.165     0.200
    16.354    38.107     0.200
    16.514    36.741     0.200
    21.145    33.894     0.200
    22.013    36.263     0.200
    22.318    35.208     0.200
    22.446    32.514     0.200
    23.153    32.965     0.200
    23.271    32.593     0.200
    23.417    31.286     0.200
    24.153    27.799     0.200
    24.081    27.632     0.200
    24.156    27.464     0.200
    24.903    30.740     0.200
    25.163    28.509     0.200
    25.927    24.990     0.200
    25.657    25.439     0.200
    25.754    26.807     0.200
    26.239    25.645     0.200
    27.623    19.294     0.200
    28.039    18.950     0.200
    28.855    16.426     0.200
    29.396    14.410     0.200
    29.483    17.092     0.200
    16.932    44.660     0.200
    20.967    39.367     0.200
    22.362    40.696     0.200
    22.450    37.160     0.200
    23.670    38.233     0.200
    24.037    33.047     0.200
    25.811    34.845     0.200
    26.749    26.895     0.200
    27.856    24.079     0.200
    28.264    23.219     0.200
    28.488    23.207     0.200
    28.659    23.901     0.200
    24.009    33.972     0.200
    28.223    23.092     0.200
    23.586    33.396     0.200
    26.558    29.010     0.200
    28.765    22.055     0.200
    23.292    35.018     0.200
    23.121    37.712     0.200
    23.166    40.385     0.200
    23.752    35.800     0.200
    24.241    36.639     0.200
    26.309    32.302     0.200
    26.860    28.578     0.200
    27.487    24.158     0.200
    27.870    25.289     0.200
    28.544    23.027     0.200
    29.093    22.523     0.200
    21.427    38.479     0.200
    22.791    36.969     0.200
    22.789    37.390     0.200
    23.820    35.554     0.200
    26.451    30.525     0.200
    27.173    24.332     0.200
    27.757    22.613     0.200
    27.639    24.696     0.200
    28.153    22.393     0.200
    28.676    21.282     0.200
    29.913    18.854     0.200
    22.821    37.420     0.200
    22.830    36.712     0.200
    23.869    35.982     0.200
    26.504    27.510     0.200
    27.205    24.156     0.200
    27.734    22.584     0.200
    28.195    21.602     0.200
    28.724    20.928     0.200
    29.949    17.627     0.200
    24.842    30.277     0.200
    26.702    28.035     0.200
    27.362    24.153     0.200
    27.993    20.797     0.200
    25.371    31.328     0.200
    17.214    41.510     0.200
    22.622    35.642     0.200
    24.763    30.762     0.200
    26.353    26.083     0.200
    26.353    26.447     0.200
    27.801    20.845     0.200
    28.588    20.324     0.200
    29.250    15.194     0.200
    29.442    18.443     0.200
    24.463    33.743     0.200
    28.218    21.842     0.200
    21.149    40.390     0.200
    22.330    39.710     0.200
    22.452    36.281     0.200
    23.174    37.756     0.200
    23.447    37.963     0.200
    23.859    34.552     0.200
    24.189    34.010     0.200
    24.291    33.551     0.200
    25.187    31.867     0.200
    25.329    30.702     0.200
    25.686    31.643     0.200
    27.638    25.562     0.200
    27.971    23.083     0.200
    27.971    22.841     0.200
    29.383    21.692     0.200
    26.605    29.128     0.200
    26.605    29.027     0.200
    28.070    22.425     0.200
    17.030    41.069     0.200
    17.203    40.904     0.200
    22.732    35.632     0.200
    22.727    36.094     0.200
    23.708    33.045     0.200
    23.749    35.263     0.200
    24.102    33.539     0.200
    24.777    32.243     0.200
    25.812    31.086     0.200
    26.383    27.934     0.200
    27.804    22.326     0.200
    28.086    23.148     0.200
    28.606    20.682     0.200
    17.010    39.263     0.200
    22.727    35.547     0.200
    24.065    32.937     0.200
    24.772    31.217     0.200
    25.795    31.647     0.200
    26.356    27.951     0.200
    27.618    23.728     0.200
    27.789    23.112     0.200
    16.777    40.718     0.200
    16.777    41.140     0.200
    16.953    43.956     0.200
    17.495    41.680     0.200
    21.518    40.382     0.200
    22.740    37.629     0.200
    23.591    35.989     0.200
    23.805    34.750     0.200
    24.232    34.409     0.200
    24.232    34.410     0.200
    24.711    31.697     0.200
    25.593    31.626     0.200
    26.042    30.035     0.200
    27.214    24.209     0.200
    27.616    25.635     0.200
    28.055    23.602     0.200
    28.478    23.161     0.200
    29.600    17.847     0.200
    24.751    31.922     0.200
    27.568    23.782     0.200
    27.756    28.374     0.200
    24.015    34.155     0.200
    27.147    25.702     0.200
    28.222    22.870     0.200
    15.199    43.074     0.200
    26.052    30.454     0.200
    27.561    25.615     0.200
    15.101    38.215     0.200
    15.451    39.655     0.200
    15.451    40.436     0.200
    15.451    39.985     0.200
    16.176    42.885     0.200
    16.315    40.971     0.200
    17.323    39.008     0.200
    17.827    40.328     0.200
    20.096    36.947     0.200
    21.428    36.796     0.200
    21.498    37.586     0.200
    21.546    37.118     0.200
    21.819    36.337     0.200
    22.103    37.728     0.200
    22.512    37.148     0.200
    22.769    35.548     0.200
    23.576    33.234     0.200
    23.673    34.803     0.200
    23.779    33.158     0.200
    23.854    34.884     0.200
    23.971    30.473     0.200
    23.971    30.472     0.200
    24.017    33.380     0.200
    24.193    32.129     0.200
    25.600    30.511     0.200
    25.710    29.828     0.200
    25.871    28.747     0.200
    26.076    26.451     0.200
    26.202    29.692     0.200
    26.229    26.771     0.200
    26.326    26.738     0.200
    26.326    27.068     0.200
    27.701    21.692     0.200
    28.064    20.753     0.200
    28.543    21.072     0.200
    29.387    15.620     0.200
    29.387    14.820     0.200
    29.519    15.003     0.200
    26.222    29.756     0.200
    27.700    22.093     0.200
    24.036    31.203     0.200
    26.447    25.808     0.200
    27.575    21.084     0.200
    27.830    22.277     0.200
    27.830    22.281     0.200
    26.641    27.479     0.200
    27.514    24.661     0.200
    27.514    24.657     0.200
    26.585    29.608     0.200
    27.136    25.901     0.200
    27.136    25.897     0.200
    28.224    22.866     0.200
    25.944    29.377     0.200
    27.348    23.517     0.200
    28.154    22.337     0.200
    14.303    39.568     0.200
    14.343    40.814     0.200
    14.750    40.413     0.200
    15.160    40.901     0.200
    15.451    43.953     0.200
    15.541    40.606     0.200
    16.813    40.358     0.200
    19.328    37.500     0.200
    20.944    41.151     0.200
    21.105    37.077     0.200
    21.397    38.869     0.200
    21.624    37.814     0.200
    22.019    32.604     0.200
    22.062    37.408     0.200
    22.289    37.753     0.200
    22.472    36.026     0.200
    23.293    33.716     0.200
    23.493    33.541     0.200
    23.585    33.278     0.200
    23.585    34.130     0.200
    24.013    32.241     0.200
    24.108    32.025     0.200
    24.293    33.369     0.200
    24.413    32.470     0.200
    24.494    33.425     0.200
    24.655    31.540     0.200
    24.778    31.212     0.200
    24.869    31.745     0.200
    24.930    29.982     0.200
    25.062    32.091     0.200
    25.363    30.182     0.200
    25.422    29.397     0.200
    25.464    30.601     0.200
    25.528    30.555     0.200
    25.664    30.067     0.200
    25.717    28.554     0.200
    25.766    27.793     0.200
    25.942    27.689     0.200
    25.967    27.385     0.200
    25.967    27.963     0.200
    26.069    27.739     0.200
    26.073    26.691     0.200
    26.073    27.691     0.200
    26.671    25.317     0.200
    27.218    22.184     0.200
    27.218    22.036     0.200
    28.289    20.494     0.200
    28.289    20.494     0.200
    28.303    20.578     0.200
    28.640    20.143     0.200
    26.169    28.866     0.200
    28.075    22.838     0.200
    14.423    38.367     0.200
    15.286    42.297     0.200
    15.427    39.769     0.200
    15.536    42.581     0.200
    15.767    40.879     0.200
    15.871    42.876     0.200
    16.019    44.942     0.200
    16.306    39.891     0.200
    16.457    43.133     0.200
    16.457    40.443     0.200
    16.626    45.157     0.200
    16.867    41.852     0.200
    17.303    40.236     0.200
    19.187    38.237     0.200
    19.535    38.048     0.200
    19.986    38.199     0.200
    20.682    37.496     0.200
    20.608    38.790     0.200
    20.714    38.244     0.200
    20.714    36.849     0.200
    21.248    38.018     0.200
    21.248    37.728     0.200
    21.581    41.533     0.200
    21.616    35.011     0.200
    21.629    38.480     0.200
    21.629    37.510     0.200
    21.947    41.557     0.200
    22.041    37.600     0.200
    22.079    39.725     0.200
    22.240    37.677     0.200
    22.218    38.596     0.200
    22.303    41.409     0.200
    22.430    38.632     0.200
    22.552    36.597     0.200
    22.800    38.413     0.200
    22.910    36.924     0.200
    23.042    38.385     0.200
    23.042    36.515     0.200
    23.324    35.274     0.200
    23.263    36.303     0.200
    23.318    37.167     0.200
    23.452    37.799     0.200
    23.399    34.417     0.200
    23.454    36.181     0.200
    23.454    34.061     0.200
    23.568    40.152     0.200
    23.628    35.143     0.200
    23.628    34.723     0.200
    23.709    35.704     0.200
    23.914    37.708     0.200
    23.946    33.157     0.200
    23.946    32.802     0.200
    23.946    33.582     0.200
    24.092    35.132     0.200
    24.102    36.514     0.200
    24.198    31.900     0.200
    24.110    34.026     0.200
    24.199    36.280     0.200
    24.144    33.724     0.200
    24.387    32.526     0.200
    24.575    35.294     0.200
    24.627    32.686     0.200
    24.783    33.265     0.200
    24.822    35.310     0.200
    24.953    35.387     0.200
    25.137    32.038     0.200
    25.174    30.807     0.200
    25.341    29.487     0.200
    25.269    31.496     0.200
    25.269    30.696     0.200
    25.300    32.737     0.200
    25.449    32.694     0.200
    25.472    30.921     0.200
    25.747    30.167     0.200
    25.747    28.957     0.200
    25.747    29.357     0.200
    25.747    29.118     0.200
    25.815    30.723     0.200
    25.845    30.843     0.200
    25.845    28.474     0.200
    26.087    27.644     0.200
    25.957    28.393     0.200
    26.522    28.574     0.200
    26.835    25.621     0.200
    26.927    26.041     0.200
    27.292    22.926     0.200
    27.276    24.273     0.200
    27.286    23.993     0.200
    27.248    28.603     0.200
    27.248    24.533     0.200
    27.477    26.131     0.200
    27.631    22.126     0.200
    27.631    24.176     0.200
    27.689    23.050     0.200
    27.872    22.466     0.200
    27.872    23.426     0.200
    27.736    23.206     0.200
    27.736    23.606     0.200
    27.980    27.762     0.200
    28.150    22.873     0.200
    28.523    25.422     0.200
    28.955    20.779     0.200
    29.461    17.070     0.200
    29.461    16.571     0.200
    29.461    16.732     0.200
    29.461    16.521     0.200
    29.463    17.013     0.200
    29.593    19.330     0.200
    29.960    15.226     0.200
    29.960    16.056     0.200
    18.931    37.553     0.200
    23.648    30.879     0.200
    25.823    27.623     0.200
    25.991    29.209     0.200
    27.643    24.242     0.200
    25.745    28.455     0.200
    25.745    30.706     0.200
    27.501    24.210     0.200
    20.026    40.833     0.200
    20.718    39.812     0.200
    20.771    39.356     0.200
    21.206    39.057     0.200
    23.052    40.093     0.200
    23.342    40.037     0.200
    23.373    37.179     0.200
    23.448    37.261     0.200
    23.621    37.542     0.200
    23.718    34.648     0.200
    23.728    36.980     0.200
    24.784    34.472     0.200
    25.719    33.251     0.200
    25.953    31.414     0.200
    25.952    29.372     0.200
    27.593    26.888     0.200
    23.059    36.449     0.200
    23.237    35.132     0.200
    25.463    32.023     0.200
    25.559    30.934     0.200
    25.814    27.235     0.200
    27.510    26.594     0.200
    19.910    37.793     0.200
    21.409    37.630     0.200
    25.738    29.033     0.200
    25.737    29.036     0.200
    27.728    22.719     0.200
    27.785    22.057     0.200
    27.812    22.204     0.200
    15.162    42.301     0.200
    15.389    42.745     0.200
    15.716    41.328     0.200
    16.122    45.288     0.200
    16.300    40.517     0.200
    17.213    41.557     0.200
    18.937    38.798     0.200
    19.609    36.918     0.200
    20.062    38.563     0.200
    20.624    37.469     0.200
    20.665    37.455     0.200
    20.665    38.380     0.200
    20.713    38.811     0.200
    20.845    36.120     0.200
    21.354    42.140     0.200
    21.463    42.064     0.200
    21.722    36.578     0.200
    21.726    40.896     0.200
    22.184    41.153     0.200
    22.345    36.299     0.200
    22.310    38.076     0.200
    22.347    39.151     0.200
    22.390    38.749     0.200
    22.466    37.181     0.200
    22.495    37.323     0.200
    22.906    40.526     0.200
    23.146    40.522     0.200
    23.146    36.382     0.200
    23.430    36.234     0.200
    23.430    39.309     0.200
    23.400    40.061     0.200
    23.426    39.453     0.200
    23.447    36.410     0.200
    23.543    34.899     0.200
    23.724    32.528     0.200
    23.724    33.411     0.200
    23.715    34.537     0.200
    23.815    36.715     0.200
    23.855    34.220     0.200
    24.002    32.418     0.200
    24.020    38.320     0.200
    24.091    31.841     0.200
    24.091    31.842     0.200
    24.197    35.155     0.200
    24.208    37.531     0.200
    24.172    34.945     0.200
    24.224    35.645     0.200
    24.306    37.290     0.200
    24.364    29.989     0.200
    24.680    34.919     0.200
    24.881    33.576     0.200
    24.927    35.735     0.200
    24.997    32.523     0.200
    25.053    33.873     0.200
    25.212    32.315     0.200
    25.280    33.216     0.200
    25.280    31.216     0.200
    25.550    34.263     0.200
    25.552    31.649     0.200
    25.790    29.103     0.200
    25.790    28.887     0.200
    25.790    30.073     0.200
    25.914    31.017     0.200
    25.886    27.446     0.200
    26.051    27.662     0.200
    26.049    27.945     0.200
    26.049    28.345     0.200
    26.048    28.342     0.200
    26.440    27.284     0.200
    27.549    24.743     0.200
    27.549    22.666     0.200
    27.705    24.013     0.200
    27.705    23.114     0.200
    27.942    22.216     0.200
    27.942    21.423     0.200
    27.942    21.168     0.200
    29.363    17.474     0.200
    29.363    17.462     0.200
    29.948    16.189     0.200
    29.948    15.644     0.200
    18.876    41.302     0.200
    19.925    40.646     0.200
    20.674    39.306     0.200
    21.576    39.187     0.200
    23.258    37.432     0.200
    23.387    36.735     0.200
    25.739    31.091     0.200
    25.739    31.095     0.200
    25.739    30.841     0.200
    25.910    30.280     0.200
    25.909    30.293     0.200
    27.695    24.547     0.200
    27.814    24.983     0.200
    29.948    19.107     0.200
    15.347    39.564     0.200
    18.953    38.667     0.200
    19.440    34.384     0.200
    21.347    36.566     0.200
    23.283    38.130     0.200
    23.465    36.589     0.200
    24.783    32.160     0.200
    25.817    29.981     0.200
    25.817    29.980     0.200
    25.817    30.201     0.200
    27.721    22.430     0.200
    15.149    41.382     0.200
    15.483    42.294     0.200
    15.837    42.657     0.200
    15.985    42.537     0.200
    15.985    41.697     0.200
    17.321    42.316     0.200
    17.542    42.667     0.200
    19.189    36.987     0.200
    19.525    37.902     0.200
    20.574    38.472     0.200
    20.703    37.794     0.200
    21.255    35.329     0.200
    21.593    41.084     0.200
    22.183    38.200     0.200
    22.210    39.290     0.200
    22.420    36.438     0.200
    22.427    38.955     0.200
    22.556    36.642     0.200
    23.008    37.887     0.200
    23.292    35.285     0.200
    23.283    37.961     0.200
    23.371    38.439     0.200
    23.371    33.960     0.200
    23.418    35.784     0.200
    23.418    35.444     0.200
    23.593    35.743     0.200
    23.593    33.803     0.200
    23.675    32.541     0.200
    23.678    34.419     0.200
    23.961    33.926     0.200
    23.965    34.203     0.200
    23.965    34.073     0.200
    24.228    32.661     0.200
    24.228    32.656     0.200
    24.379    31.376     0.200
    24.541    33.986     0.200
    24.748    29.999     0.200
    25.250    32.809     0.200
    25.250    31.309     0.200
    25.720    30.825     0.200
    25.720    29.925     0.200
    25.842    30.049     0.200
    25.842    29.633     0.200
    25.818    28.579     0.200
    25.922    29.172     0.200
    26.536    26.698     0.200
    27.213    26.201     0.200
    27.213    25.501     0.200
    27.441    25.436     0.200
    27.646    22.245     0.200
    27.646    23.995     0.200
    27.730    24.067     0.200
    27.730    22.867     0.200
    27.863    23.326     0.200
    27.863    22.612     0.200
    27.863    21.723     0.200
    29.485    14.688     0.200
    29.485    19.608     0.200
    29.485    19.610     0.200
    29.979    16.493     0.200
    29.979    14.523     0.200
    18.606    39.255     0.200
    18.935    39.221     0.200
    19.624    35.561     0.200
    22.359    36.549     0.200
    23.737    34.351     0.200
    23.721    35.755     0.200
    25.456    30.958     0.200
    25.786    30.958     0.200
    25.786    29.648     0.200
    26.055    31.194     0.200
    26.055    29.707     0.200
    27.533    27.844     0.200
    27.957    23.772     0.200
    23.532    37.351     0.200
    23.792    34.689     0.200
    25.818    33.399     0.200
    26.131    32.001     0.200
    26.130    30.669     0.200
    27.461    25.920     0.200
    16.010    43.304     0.200
    19.647    38.959     0.200
    20.884    37.480     0.200
    22.383    34.755     0.200
    23.448    35.802     0.200
    23.564    34.966     0.200
    23.735    35.719     0.200
    23.816    36.032     0.200
    23.816    33.837     0.200
    24.180    36.661     0.200
    24.683    37.685     0.200
    24.907    34.070     0.200
    25.010    33.964     0.200
    25.788    30.952     0.200
    25.788    29.351     0.200
    25.942    32.598     0.200
    26.071    29.133     0.200
    26.071    27.861     0.200
    26.946    27.981     0.200
    27.979    22.992     0.200
    29.323    21.229     0.200
    25.802    34.111     0.200
    14.801    41.677     0.200
    15.484    41.308     0.200
    15.680    42.318     0.200
    15.820    41.383     0.200
    15.959    43.256     0.200
    17.251    42.337     0.200
    18.551    40.535     0.200
    18.959    39.602     0.200
    20.022    40.869     0.200
    20.633    40.209     0.200
    20.814    38.033     0.200
    21.327    41.515     0.200
    21.720    37.933     0.200
    21.949    38.138     0.200
    22.310    39.849     0.200
    22.368    40.669     0.200
    22.430    40.537     0.200
    22.495    37.139     0.200
    22.536    38.804     0.200
    22.882    39.966     0.200
    23.408    38.826     0.200
    23.469    38.319     0.200
    23.544    37.441     0.200
    23.544    36.571     0.200
    23.718    37.411     0.200
    23.718    36.351     0.200
    23.792    37.544     0.200
    23.892    34.955     0.200
    24.188    36.925     0.200
    24.231    36.924     0.200
    24.403    34.637     0.200
    24.665    35.756     0.200
    24.700    36.251     0.200
    24.875    34.008     0.200
    25.006    34.678     0.200
    25.237    34.684     0.200
    25.313    33.797     0.200
    25.371    36.416     0.200
    25.559    33.425     0.200
    25.813    29.420     0.200
    25.813    32.010     0.200
    25.813    29.960     0.200
    25.907    32.666     0.200
    26.048    30.820     0.200
    26.479    27.991     0.200
    26.926    28.380     0.200
    27.588    27.153     0.200
    27.745    25.511     0.200
    27.745    24.511     0.200
    27.902    23.712     0.200
    29.396    20.652     0.200
    29.396    20.603     0.200
    19.979    40.909     0.200
    25.570    30.480     0.200
    25.570    32.310     0.200
    25.570    29.780     0.200
    25.768    27.945     0.200
    14.160    39.653     0.200
    18.753    39.637     0.200
    20.664    38.882     0.200
    20.795    39.064     0.200
    20.795    39.314     0.200
    21.154    42.130     0.200
    22.533    37.729     0.200
    22.695    40.144     0.200
    22.914    36.952     0.200
    23.264    35.731     0.200
    23.309    36.353     0.200
    23.601    36.400     0.200
    23.992    35.430     0.200
    24.319    32.560     0.200
    24.447    34.299     0.200
    24.643    34.505     0.200
    24.643    33.335     0.200
    25.045    34.216     0.200
    25.163    33.444     0.200
    25.615    29.172     0.200
    25.615    30.512     0.200
    25.615    29.562     0.200
    25.813    30.657     0.200
    25.813    29.557     0.200
    25.812    29.595     0.200
    26.690    29.122     0.200
    27.658    25.175     0.200
    27.677    25.502     0.200
    27.715    21.715     0.200
    27.871    24.391     0.200
    27.871    23.231     0.200
    25.717    31.899     0.200
    18.790    38.717     0.200
    18.875    40.065     0.200
    20.683    39.075     0.200
    20.747    35.477     0.200
    20.700    39.291     0.200
    21.205    39.133     0.200
    22.452    39.079     0.200
    22.756    37.929     0.200
    23.280    39.387     0.200
    23.386    36.401     0.200
    23.421    36.300     0.200
    23.665    35.439     0.200
    24.090    37.867     0.200
    24.612    35.677     0.200
    25.165    33.121     0.200
    25.736    29.394     0.200
    25.736    31.454     0.200
    25.736    29.754     0.200
    25.777    30.572     0.200
    25.923    30.072     0.200
    25.923    29.472     0.200
    25.922    29.530     0.200
    26.802    26.710     0.200
    27.669    24.795     0.200
    27.726    22.829     0.200
    27.755    25.895     0.200
    27.755    23.294     0.200
    27.839    24.517     0.200
    27.839    23.487     0.200
    29.504    15.885     0.200
    29.504    15.873     0.200
    24.318    32.717     0.200
    25.458    29.675     0.200
    25.458    31.956     0.200
    25.560    31.617     0.200
    27.750    23.960     0.200
    27.695    24.155     0.200
    27.821    23.865     0.200
    19.928    40.747     0.200
    20.677    39.057     0.200
    24.011    34.989     0.200
    24.418    33.621     0.200
    25.737    32.101     0.200
    25.737    29.101     0.200
    25.909    30.613     0.200
    27.750    26.643     0.200
    14.185    39.052     0.200
    14.515    41.595     0.200
    14.984    42.826     0.200
    15.195    39.290     0.200
    15.401    40.665     0.200
    15.856    39.752     0.200
    17.226    41.168     0.200
    18.605    39.263     0.200
    19.190    35.887     0.200
    19.399    37.759     0.200
    19.637    38.832     0.200
    20.451    36.768     0.200
    20.498    37.883     0.200
    21.265    41.823     0.200
    21.252    39.477     0.200
    21.252    36.467     0.200
    21.285    36.400     0.200
    21.353    36.532     0.200
    21.846    39.549     0.200
    21.914    35.986     0.200
    22.011    39.625     0.200
    22.285    40.926     0.200
    22.230    36.202     0.200
    22.461    38.772     0.200
    22.433    38.496     0.200
    22.671    38.214     0.200
    22.671    36.204     0.200
    22.627    37.438     0.200
    22.976    37.188     0.200
    23.084    36.102     0.200
    23.084    35.282     0.200
    23.118    37.708     0.200
    23.118    35.748     0.200
    23.262    36.029     0.200
    23.262    34.979     0.200
    23.365    34.469     0.200
    23.557    37.475     0.200
    23.645    34.797     0.200
    23.645    32.962     0.200
    23.790    37.666     0.200
    23.950    33.542     0.200
    24.205    35.622     0.200
    24.173    33.691     0.200
    24.173    32.862     0.200
    24.332    37.035     0.200
    24.329    32.532     0.200
    24.407    32.273     0.200
    24.456    36.089     0.200
    24.919    33.787     0.200
    25.010    35.024     0.200
    25.074    33.181     0.200
    25.094    32.942     0.200
    25.094    30.842     0.200
    25.439    31.922     0.200
    25.480    29.032     0.200
    25.480    31.392     0.200
    25.480    29.642     0.200
    25.584    30.148     0.200
    25.584    29.223     0.200
    25.584    29.281     0.200
    25.771    29.992     0.200
    25.771    27.417     0.200
    26.329    32.529     0.200
    26.465    28.544     0.200
    27.751    22.955     0.200
    27.751    21.982     0.200
    27.704    24.289     0.200
    27.704    22.989     0.200
    27.816    24.827     0.200
    29.734    18.500     0.200
    15.336    41.874     0.200
    15.757    46.083     0.200
    15.907    46.239     0.200
    16.327    41.041     0.200
    18.431    39.092     0.200
    18.826    40.055     0.200
    19.467    37.201     0.200
    20.495    40.397     0.200
    20.639    38.205     0.200
    20.714    38.760     0.200
    20.714    39.336     0.200
    21.140    43.074     0.200
    21.307    38.420     0.200
    21.506    38.116     0.200
    21.521    42.727     0.200
    21.970    39.680     0.200
    22.130    40.513     0.200
    22.115    39.791     0.200
    22.405    35.076     0.200
    22.460    40.363     0.200
    22.603    39.596     0.200
    22.688    39.899     0.200
    22.929    41.287     0.200
    22.929    37.907     0.200
    23.211    38.447     0.200
    23.254    37.896     0.200
    23.352    35.792     0.200
    23.337    37.925     0.200
    23.337    35.645     0.200
    23.636    34.402     0.200
    23.529    36.290     0.200
    24.036    36.701     0.200
    24.036    34.286     0.200
    24.033    37.706     0.200
    24.052    37.991     0.200
    24.462    35.996     0.200
    24.400    32.869     0.200
    24.675    36.016     0.200
    24.675    32.576     0.200
    24.680    37.456     0.200
    24.843    36.957     0.200
    25.235    36.781     0.200
    25.245    34.167     0.200
    25.245    31.368     0.200
    25.338    35.576     0.200
    25.794    29.151     0.200
    25.706    33.787     0.200
    25.691    31.773     0.200
    25.691    31.779     0.200
    25.691    29.543     0.200
    25.853    30.464     0.200
    25.853    30.564     0.200
    25.790    30.204     0.200
    25.853    30.582     0.200
    26.137    26.837     0.200
    26.543    33.210     0.200
    26.733    28.793     0.200
    27.808    23.627     0.200
    27.808    23.932     0.200
    27.711    24.786     0.200
    27.711    25.136     0.200
    27.756    24.757     0.200
    27.756    23.957     0.200
    29.561    20.597     0.200
    29.561    18.898     0.200
    29.985    15.445     0.200
    29.985    17.145     0.200
    15.426    41.866     0.200
    18.508    38.767     0.200
    19.535    39.092     0.200
    19.535    36.882     0.200
    19.986    38.835     0.200
    20.306    38.493     0.200
    20.605    39.412     0.200
    20.741    37.725     0.200
    22.428    40.734     0.200
    22.439    36.518     0.200
    22.797    35.829     0.200
    23.321    37.443     0.200
    23.321    36.417     0.200
    23.395    38.846     0.200
    23.395    35.506     0.200
    23.450    36.072     0.200
    24.572    32.618     0.200
    24.623    36.815     0.200
    24.779    32.743     0.200
    25.170    36.234     0.200
    25.743    29.685     0.200
    25.743    32.296     0.200
    25.743    31.935     0.200
    25.811    30.851     0.200
    25.953    30.023     0.200
    25.952    29.965     0.200
    27.632    25.204     0.200
    27.689    24.538     0.200
    27.872    25.199     0.200
    27.954    19.726     0.200
    15.263    39.767     0.200
    15.408    42.294     0.200
    15.845    40.375     0.200
    17.321    41.028     0.200
    17.548    41.399     0.200
    18.800    37.097     0.200
    18.872    38.367     0.200
    19.522    38.517     0.200
    19.826    37.713     0.200
    20.312    37.945     0.200
    20.692    35.214     0.200
    20.720    37.590     0.200
    21.225    39.296     0.200
    21.558    37.510     0.200
    21.592    38.507     0.200
    21.592    36.776     0.200
    21.604    35.483     0.200
    21.805    39.328     0.200
    22.065    35.534     0.200
    22.216    37.130     0.200
    22.216    37.560     0.200
    22.434    38.382     0.200
    22.562    37.394     0.200
    22.775    36.102     0.200
    23.016    36.835     0.200
    23.299    36.518     0.200
    23.299    39.492     0.200
    23.383    36.406     0.200
    23.383    34.765     0.200
    23.430    36.662     0.200
    23.430    34.832     0.200
    23.669    33.986     0.200
    23.605    33.480     0.200
    23.684    34.996     0.200
    23.684    34.826     0.200
    24.388    31.165     0.200
    24.758    31.360     0.200
    24.758    30.159     0.200
    24.927    31.684     0.200
    25.122    33.811     0.200
    25.160    32.070     0.200
    25.266    32.140     0.200
    25.261    32.191     0.200
    25.261    30.191     0.200
    25.283    34.132     0.200
    25.424    30.492     0.200
    25.450    32.281     0.200
    25.732    30.544     0.200
    25.790    28.520     0.200
    25.830    26.846     0.200
    25.933    29.703     0.200
    25.933    28.353     0.200
    25.932    28.381     0.200
    26.538    26.593     0.200
    26.587    30.221     0.200
    26.811    26.402     0.200
    27.647    21.942     0.200
    27.647    24.692     0.200
    27.738    23.984     0.200
    27.738    22.384     0.200
    27.860    24.389     0.200
    27.860    22.454     0.200
    28.147    23.411     0.200
    29.483    20.527     0.200
    29.482    20.499     0.200
    29.482    17.728     0.200
    29.968    15.965     0.200
    29.968    17.016     0.200
    25.716    32.018     0.200
    22.443    39.758     0.200
    23.783    35.223     0.200
    25.811    27.963     0.200
    25.811    30.943     0.200
    25.756    27.733     0.200
    25.756    29.348     0.200
    25.756    28.623     0.200
    23.146    35.857     0.200
    23.254    35.043     0.200
    25.571    31.305     0.200
    25.512    29.739     0.200
    25.512    31.919     0.200
    25.512    30.888     0.200
    25.570    30.357     0.200
    25.699    26.085     0.200
    27.678    24.163     0.200
    27.770    24.863     0.200
    15.404    41.234     0.200
    15.601    40.860     0.200
    15.853    44.523     0.200
    15.846    39.607     0.200
    17.326    43.054     0.200
    18.485    38.154     0.200
    18.658    38.885     0.200
    18.892    37.643     0.200
    19.512    37.620     0.200
    19.512    36.400     0.200
    20.293    37.509     0.200
    20.672    38.231     0.200
    20.672    36.481     0.200
    20.591    38.836     0.200
    20.720    35.642     0.200
    21.227    41.406     0.200
    21.271    35.008     0.200
    21.596    36.336     0.200
    21.824    39.241     0.200
    22.057    39.218     0.200
    22.219    39.136     0.200
    22.219    34.796     0.200
    22.208    38.555     0.200
    22.282    38.996     0.200
    22.300    37.088     0.200
    22.449    37.844     0.200
    22.574    37.385     0.200
    22.779    38.192     0.200
    23.026    39.517     0.200
    23.026    35.668     0.200
    23.304    37.819     0.200
    23.304    38.969     0.200
    23.277    37.482     0.200
    23.311    38.283     0.200
    23.402    32.821     0.200
    23.445    36.129     0.200
    23.445    34.199     0.200
    23.654    32.151     0.200
    23.620    36.081     0.200
    23.620    33.551     0.200
    23.689    32.918     0.200
    23.896    37.167     0.200
    23.970    31.570     0.200
    24.075    34.875     0.200
    24.109    34.675     0.200
    24.138    34.531     0.200
    24.180    34.546     0.200
    24.405    31.536     0.200
    24.559    34.627     0.200
    24.629    33.105     0.200
    24.771    32.654     0.200
    24.771    29.634     0.200
    24.805    32.253     0.200
    24.916    33.053     0.200
    24.939    35.488     0.200
    25.142    33.024     0.200
    25.179    31.883     0.200
    25.276    33.361     0.200
    25.280    32.306     0.200
    25.280    30.906     0.200
    25.302    33.249     0.200
    25.435    32.204     0.200
    25.467    31.526     0.200
    25.824    25.902     0.200
    25.824    25.457     0.200
    25.752    30.718     0.200
    25.752    30.006     0.200
    25.802    31.219     0.200
    25.850    27.159     0.200
    25.947    29.477     0.200
    25.947    27.527     0.200
    25.946    27.525     0.200
    26.080    27.479     0.200
    26.606    29.835     0.200
    26.826    26.370     0.200
    27.240    23.433     0.200
    27.655    21.594     0.200
    27.655    24.645     0.200
    27.712    22.538     0.200
    27.754    23.433     0.200
    27.754    21.733     0.200
    27.849    23.840     0.200
    27.849    24.001     0.200
    27.972    26.300     0.200
    28.165    23.039     0.200
    28.804    21.084     0.200
    29.484    20.196     0.200
    29.484    18.446     0.200
    29.484    16.945     0.200
    29.484    20.195     0.200
    29.948    16.529     0.200
    27.816    23.874     0.200
    15.251    41.514     0.200
    18.842    39.438     0.200
    18.771    39.623     0.200
    19.723    39.955     0.200
    19.848    40.091     0.200
    20.543    39.542     0.200
    20.742    38.691     0.200
    20.742    37.367     0.200
    21.423    38.567     0.200
    22.178    40.506     0.200
    22.652    39.077     0.200
    23.108    38.446     0.200
    23.261    35.526     0.200
    23.283    37.304     0.200
    23.283    35.644     0.200
    23.439    35.693     0.200
    23.876    32.793     0.200
    23.965    36.045     0.200
    24.414    33.712     0.200
    24.577    33.170     0.200
    25.077    33.171     0.200
    25.225    33.242     0.200
    25.606    30.096     0.200
    25.642    31.185     0.200
    25.642    31.185     0.200
    25.642    31.083     0.200
    25.642    29.634     0.200
    25.745    29.706     0.200
    25.742    32.011     0.200
    25.760    30.556     0.200
    26.642    26.811     0.200
    27.785    25.166     0.200
    27.748    25.657     0.200
    27.748    24.737     0.200
    27.785    23.612     0.200
    27.778    24.258     0.200
    27.778    25.157     0.200
    28.149    23.626     0.200
    23.238    37.602     0.200
    23.417    36.616     0.200
    24.410    33.409     0.200
    25.625    31.450     0.200
    25.625    31.450     0.200
    25.625    29.890     0.200
    25.737    30.788     0.200
    25.736    30.790     0.200
    27.741    25.677     0.200
    19.681    38.125     0.200
    23.608    36.161     0.200
    23.778    36.176     0.200
    25.810    30.163     0.200
    25.810    29.739     0.200
    26.116    28.681     0.200
    14.615    40.140     0.200
    15.618    43.676     0.200
    15.814    43.840     0.200
    16.050    45.684     0.200
    20.158    39.868     0.200
    20.158    40.043     0.200
    20.787    39.806     0.200
    20.938    39.121     0.200
    21.443    43.756     0.200
    22.309    42.149     0.200
    22.337    40.419     0.200
    22.354    41.027     0.200
    22.405    38.729     0.200
    23.428    39.484     0.200
    23.435    36.190     0.200
    23.512    38.333     0.200
    23.582    36.554     0.200
    23.751    36.393     0.200
    24.249    35.706     0.200
    24.935    33.065     0.200
    25.235    34.200     0.200
    25.342    34.646     0.200
    25.576    32.920     0.200
    25.773    31.399     0.200
    25.773    31.127     0.200
    26.093    29.992     0.200
    26.092    30.000     0.200
    26.964    29.318     0.200
    27.451    26.659     0.200
    27.630    26.250     0.200
    28.037    22.748     0.200
    28.079    25.212     0.200
    29.267    18.351     0.200
    29.267    18.340     0.200
    23.309    35.023     0.200
    25.520    30.056     0.200
    27.756    20.938     0.200
    27.756    23.604     0.200
    29.706    19.787     0.200
    25.572    32.511     0.200
    25.572    31.993     0.200
    27.779    25.832     0.200
    27.779    24.148     0.200
    23.585    35.721     0.200
    25.734    31.820     0.200
    25.734    29.890     0.200
    27.688    24.171     0.200
    23.763    37.351     0.200
    25.820    32.416     0.200
    14.446    40.451     0.200
    14.764    40.448     0.200
    15.360    40.488     0.200
    15.448    41.832     0.200
    15.964    41.843     0.200
    16.122    42.693     0.200
    16.573    41.030     0.200
    17.291    43.351     0.200
    17.291    40.650     0.200
    17.653    45.023     0.200
    18.505    39.554     0.200
    19.122    39.116     0.200
    19.017    40.961     0.200
    20.567    37.468     0.200
    20.790    37.676     0.200
    21.281    39.292     0.200
    21.281    37.821     0.200
    21.586    39.924     0.200
    21.641    42.083     0.200
    21.686    37.465     0.200
    21.924    37.618     0.200
    21.744    40.085     0.200
    21.744    38.425     0.200
    21.944    40.553     0.200
    22.306    37.189     0.200
    22.340    39.130     0.200
    22.426    37.631     0.200
    22.495    38.723     0.200
    22.595    37.749     0.200
    22.560    36.727     0.200
    22.874    39.402     0.200
    23.142    41.570     0.200
    23.142    36.420     0.200
    23.364    37.583     0.200
    23.404    37.842     0.200
    23.620    34.785     0.200
    23.620    34.000     0.200
    23.527    36.774     0.200
    23.527    35.485     0.200
    23.577    36.692     0.200
    23.577    35.801     0.200
    23.898    34.023     0.200
    23.753    36.636     0.200
    23.753    34.925     0.200
    23.931    32.612     0.200
    23.931    34.382     0.200
    24.122    32.380     0.200
    24.187    35.879     0.200
    24.240    36.053     0.200
    24.273    36.274     0.200
    24.378    35.844     0.200
    24.470    34.131     0.200
    24.675    35.682     0.200
    24.757    33.929     0.200
    24.898    35.079     0.200
    24.898    32.779     0.200
    24.882    35.666     0.200
    25.050    33.299     0.200
    25.263    33.418     0.200
    25.299    32.601     0.200
    25.380    33.654     0.200
    25.395    36.076     0.200
    25.429    32.984     0.200
    25.806    29.751     0.200
    25.806    29.108     0.200
    25.962    28.506     0.200
    25.874    31.368     0.200
    25.874    30.944     0.200
    25.967    31.303     0.200
    25.971    31.062     0.200
    25.971    29.855     0.200
    26.078    29.804     0.200
    26.078    29.203     0.200
    26.078    29.222     0.200
    26.526    30.285     0.200
    26.729    30.409     0.200
    26.972    27.372     0.200
    26.958    28.333     0.200
    27.634    25.153     0.200
    27.848    23.325     0.200
    27.918    23.970     0.200
    27.812    24.177     0.200
    27.812    24.376     0.200
    28.245    24.016     0.200
    29.425    19.445     0.200
    29.425    19.215     0.200
    29.425    18.259     0.200
    29.848    18.508     0.200
    15.010    44.074     0.200
    15.211    39.129     0.200
    15.424    39.249     0.200
    15.494    39.230     0.200
    15.534    39.966     0.200
    16.262    39.570     0.200
    16.471    40.332     0.200
    16.533    42.603     0.200
    17.023    43.483     0.200
    17.253    40.906     0.200
    17.500    42.023     0.200
    18.617    38.539     0.200
    19.200    37.784     0.200
    19.200    38.075     0.200
    19.613    38.759     0.200
    19.858    38.506     0.200
    20.477    37.790     0.200
    20.878    38.045     0.200
    20.878    38.195     0.200
    21.012    39.832     0.200
    21.062    37.619     0.200
    21.062    36.849     0.200
    21.143    38.903     0.200
    21.292    38.567     0.200
    21.277    40.943     0.200
    21.312    40.129     0.200
    21.312    37.069     0.200
    21.336    38.854     0.200
    21.336    36.094     0.200
    21.786    38.504     0.200
    21.941    38.297     0.200
    22.002    39.483     0.200
    22.023    37.638     0.200
    22.392    35.696     0.200
    22.422    37.576     0.200
    22.488    38.612     0.200
    22.608    39.112     0.200
    22.611    36.671     0.200
    22.698    38.960     0.200
    22.698    36.581     0.200
    22.975    38.622     0.200
    23.003    37.776     0.200
    22.980    37.571     0.200
    23.106    35.362     0.200
    23.140    37.003     0.200
    23.129    36.326     0.200
    23.129    34.996     0.200
    23.134    36.768     0.200
    23.240    38.934     0.200
    23.283    35.456     0.200
    23.392    35.757     0.200
    23.584    36.915     0.200
    23.657    33.183     0.200
    23.657    32.923     0.200
    23.767    35.585     0.200
    23.810    35.288     0.200
    23.806    35.426     0.200
    23.875    36.225     0.200
    23.961    32.220     0.200
    24.004    34.715     0.200
    24.231    34.467     0.200
    24.322    32.172     0.200
    24.345    34.136     0.200
    24.431    33.828     0.200
    24.431    33.209     0.200
    24.483    33.131     0.200
    24.512    30.409     0.200
    24.584    32.345     0.200
    24.602    32.743     0.200
    24.592    33.453     0.200
    24.882    33.066     0.200
    24.944    32.351     0.200
    24.928    32.134     0.200
    24.997    30.725     0.200
    24.997    30.426     0.200
    25.022    33.431     0.200
    25.099    32.636     0.200
    25.096    32.270     0.200
    25.096    31.369     0.200
    25.139    32.174     0.200
    25.464    29.983     0.200
    25.490    31.568     0.200
    25.490    30.826     0.200
    25.607    30.655     0.200
    25.587    30.541     0.200
    25.591    30.361     0.200
    25.591    29.593     0.200
    25.786    28.020     0.200
    25.786    28.135     0.200
    26.329    26.962     0.200
    26.340    29.956     0.200
    26.488    27.135     0.200
    26.693    26.932     0.200
    26.682    28.666     0.200
    26.881    25.639     0.200
    26.905    28.062     0.200
    26.905    25.030     0.200
    26.978    24.729     0.200
    26.981    25.380     0.200
    27.125    26.393     0.200
    27.635    24.247     0.200
    27.768    22.751     0.200
    27.768    22.387     0.200
    27.768    22.489     0.200
    27.695    23.739     0.200
    27.795    23.280     0.200
    27.795    23.014     0.200
    28.041    23.007     0.200
    28.174    24.451     0.200
    28.197    20.725     0.200
    29.708    16.247     0.200
    29.708    16.137     0.200
    29.708    16.247     0.200
    29.708    16.023     0.200
    29.708    16.949     0.200
    14.087    43.211     0.200
    14.754    43.430     0.200
    14.873    41.747     0.200
    15.176    40.994     0.200
    15.436    39.762     0.200
    15.436    41.830     0.200
    15.853    44.096     0.200
    15.998    41.191     0.200
    16.416    40.019     0.200
    17.292    44.480     0.200
    17.292    40.445     0.200
    20.005    39.448     0.200
    20.723    37.387     0.200
    20.723    38.160     0.200
    21.242    41.604     0.200
    21.225    37.832     0.200
    21.467    38.686     0.200
    21.601    41.217     0.200
    21.601    38.178     0.200
    22.073    39.309     0.200
    22.069    36.798     0.200
    22.233    37.827     0.200
    22.256    36.874     0.200
    22.296    41.713     0.200
    22.398    37.922     0.200
    22.401    35.884     0.200
    22.526    37.823     0.200
    22.790    38.147     0.200
    23.022    39.640     0.200
    23.224    37.077     0.200
    23.301    38.280     0.200
    23.311    36.509     0.200
    23.311    36.859     0.200
    23.358    36.212     0.200
    23.358    35.173     0.200
    23.422    35.102     0.200
    23.595    35.944     0.200
    23.595    35.184     0.200
    23.698    36.251     0.200
    23.698    34.302     0.200
    23.899    36.299     0.200
    23.936    32.265     0.200
    23.936    33.365     0.200
    24.085    34.826     0.200
    24.070    34.601     0.200
    24.109    34.456     0.200
    24.186    37.052     0.200
    24.208    32.745     0.200
    24.351    32.991     0.200
    24.555    34.148     0.200
    24.587    33.476     0.200
    24.756    33.097     0.200
    24.756    31.859     0.200
    24.804    34.242     0.200
    24.884    32.803     0.200
    24.927    32.900     0.200
    25.096    32.937     0.200
    25.132    31.706     0.200
    25.228    32.188     0.200
    25.269    33.315     0.200
    25.259    32.929     0.200
    25.425    32.789     0.200
    25.437    31.855     0.200
    25.706    30.941     0.200
    25.706    30.236     0.200
    25.706    30.367     0.200
    25.706    29.915     0.200
    25.789    31.343     0.200
    25.800    30.321     0.200
    25.804    30.343     0.200
    25.804    29.074     0.200
    25.872    28.484     0.200
    25.926    29.742     0.200
    25.926    29.043     0.200
    25.926    29.029     0.200
    26.128    27.640     0.200
    26.506    29.973     0.200
    26.561    29.639     0.200
    26.803    26.410     0.200
    26.901    25.772     0.200
    27.616    23.920     0.200
    27.616    24.219     0.200
    27.702    24.023     0.200
    27.702    23.722     0.200
    27.894    22.033     0.200
    28.112    23.336     0.200
    29.458    16.725     0.200
    29.458    16.284     0.200
    18.883    39.978     0.200
    19.149    37.543     0.200
    19.486    36.284     0.200
    20.671    38.776     0.200
    21.195    39.266     0.200
    22.186    35.406     0.200
    22.597    36.804     0.200
    23.272    39.300     0.200
    23.421    36.332     0.200
    23.394    35.125     0.200
    23.634    34.662     0.200
    24.096    39.516     0.200
    24.250    32.569     0.200
    24.250    32.569     0.200
    24.418    34.754     0.200
    24.529    34.060     0.200
    24.744    33.428     0.200
    25.801    28.810     0.200
    25.745    30.568     0.200
    25.745    33.268     0.200
    25.745    30.166     0.200
    25.844    28.514     0.200
    25.923    30.369     0.200
    25.923    29.795     0.200
    25.922    29.822     0.200
    26.574    27.791     0.200
    27.684    25.040     0.200
    27.824    24.284     0.200
    27.824    23.690     0.200
    28.175    24.213     0.200
    29.516    20.154     0.200
    29.516    19.787     0.200
    19.947    41.308     0.200
    23.705    37.693     0.200
    25.791    28.690     0.200
    25.841    34.751     0.200
    27.662    25.976     0.200
    27.827    24.611     0.200
    14.490    40.504     0.200
    15.492    44.100     0.200
    15.687    41.331     0.200
    18.725    40.580     0.200
    18.984    39.940     0.200
    19.569    40.527     0.200
    19.569    36.719     0.200
    19.698    40.725     0.200
    20.023    40.433     0.200
    20.023    40.229     0.200
    20.235    39.358     0.200
    20.612    38.604     0.200
    20.612    39.155     0.200
    20.718    40.615     0.200
    20.827    36.660     0.200
    21.343    40.726     0.200
    22.393    41.874     0.200
    22.440    40.122     0.200
    22.541    39.746     0.200
    22.900    38.056     0.200
    23.314    39.730     0.200
    23.427    40.427     0.200
    23.494    39.027     0.200
    23.494    37.457     0.200
    23.675    32.931     0.200
    23.744    36.174     0.200
    23.885    35.134     0.200
    23.885    35.318     0.200
    24.214    38.522     0.200
    24.417    32.158     0.200
    25.261    34.005     0.200
    25.860    29.990     0.200
    25.838    30.674     0.200
    25.838    30.076     0.200
    26.074    30.593     0.200
    26.073    27.257     0.200
    27.584    26.756     0.200
    27.757    24.469     0.200
    27.757    24.269     0.200
    28.194    24.278     0.200
    29.385    21.778     0.200
    29.385    21.220     0.200
    29.385    21.217     0.200
    15.743    41.621     0.200
    18.736    39.588     0.200
    18.993    41.100     0.200
    19.977    40.810     0.200
    20.074    39.998     0.200
    20.074    40.771     0.200
    20.884    39.283     0.200
    22.404    41.788     0.200
    22.497    38.700     0.200
    23.606    34.926     0.200
    23.779    34.823     0.200
    25.843    31.577     0.200
    25.843    29.577     0.200
    25.906    30.622     0.200
    25.939    29.068     0.200
    26.111    28.929     0.200
    27.531    27.554     0.200
    27.950    22.714     0.200
    28.171    24.579     0.200
    20.671    39.416     0.200
    25.739    29.281     0.200
    25.724    30.951     0.200
    25.854    30.614     0.200
    25.853    30.337     0.200
    29.605    18.108     0.200
    29.605    18.496     0.200
    29.606    17.950     0.200
    20.891    37.924     0.200
    23.220    36.350     0.200
    24.343    35.126     0.200
    25.461    31.895     0.200
    25.461    31.047     0.200
    25.461    31.477     0.200
    25.741    30.364     0.200
    27.715    22.964     0.200
    27.715    23.558     0.200
    27.915    23.324     0.200
    29.783    18.182     0.200
    29.784    18.279     0.200
    15.368    40.646     0.200
    18.485    38.378     0.200
    18.707    37.734     0.200
    19.532    38.801     0.200
    19.977    38.866     0.200
    20.645    35.314     0.200
    20.836    37.642     0.200
    21.129    42.799     0.200
    21.772    41.588     0.200
    22.226    37.479     0.200
    22.283    35.870     0.200
    22.521    37.555     0.200
    22.666    38.457     0.200
    23.182    37.759     0.200
    23.218    38.415     0.200
    23.218    35.137     0.200
    23.263    35.045     0.200
    23.436    35.520     0.200
    24.291    33.596     0.200
    24.409    35.317     0.200
    24.601    31.211     0.200
    24.961    35.680     0.200
    25.001    34.714     0.200
    25.120    33.423     0.200
    25.570    29.889     0.200
    25.570    31.967     0.200
    25.570    30.588     0.200
    25.768    30.885     0.200
    25.767    28.728     0.200
    25.876    31.710     0.200
    26.644    27.134     0.200
    27.388    24.338     0.200
    27.652    23.934     0.200
    27.660    24.226     0.200
    27.878    24.891     0.200
    27.878    25.551     0.200
    28.033    24.326     0.200
    20.022    39.885     0.200
    25.856    32.256     0.200
    15.480    42.955     0.200
    18.611    38.329     0.200
    19.634    38.234     0.200
    20.709    37.677     0.200
    20.848    37.311     0.200
    22.342    35.180     0.200
    22.464    37.612     0.200
    23.421    37.001     0.200
    23.404    34.703     0.200
    23.512    34.454     0.200
    23.683    35.475     0.200
    23.758    34.047     0.200
    24.856    31.435     0.200
    25.236    34.252     0.200
    25.746    31.302     0.200
    25.746    31.302     0.200
    25.746    30.399     0.200
    26.020    29.938     0.200
    26.020    28.813     0.200
    26.019    28.782     0.200
    27.529    25.861     0.200
    27.586    25.194     0.200
    28.098    24.753     0.200
    25.771    31.444     0.200
    27.690    23.617     0.200
    27.747    22.951     0.200
    15.196    43.065     0.200
    15.229    40.392     0.200
    15.566    43.254     0.200
    15.708    44.998     0.200
    15.708    43.927     0.200
    16.295    39.446     0.200
    19.627    37.457     0.200
    19.680    38.345     0.200
    19.857    39.096     0.200
    20.664    37.557     0.200
    20.844    39.321     0.200
    20.844    39.954     0.200
    21.315    39.970     0.200
    21.608    40.142     0.200
    21.965    39.684     0.200
    22.062    38.947     0.200
    22.269    36.745     0.200
    22.515    39.361     0.200
    22.507    35.764     0.200
    22.619    35.341     0.200
    22.732    38.624     0.200
    22.732    37.945     0.200
    23.021    38.658     0.200
    23.032    37.080     0.200
    23.147    38.188     0.200
    23.147    36.129     0.200
    23.168    37.038     0.200
    23.168    35.206     0.200
    23.162    37.509     0.200
    23.324    35.379     0.200
    23.420    36.195     0.200
    23.420    35.605     0.200
    23.615    37.220     0.200
    23.644    35.299     0.200
    23.786    35.527     0.200
    23.847    35.915     0.200
    23.851    36.273     0.200
    23.945    33.136     0.200
    24.139    33.352     0.200
    24.265    35.131     0.200
    24.344    31.177     0.200
    24.385    36.341     0.200
    24.470    34.446     0.200
    24.470    34.017     0.200
    24.516    33.011     0.200
    24.965    32.661     0.200
    25.062    34.537     0.200
    25.136    32.973     0.200
    25.128    31.963     0.200
    25.501    34.009     0.200
    25.528    33.770     0.200
    25.528    30.793     0.200
    25.528    31.247     0.200
    25.528    29.594     0.200
    25.647    29.955     0.200
    25.625    31.064     0.200
    25.629    30.556     0.200
    25.629    29.216     0.200
    25.647    29.834     0.200
    25.777    30.282     0.200
    25.777    28.716     0.200
    26.378    31.672     0.200
    26.528    26.730     0.200
    27.714    24.281     0.200
    27.714    23.082     0.200
    27.765    23.175     0.200
    27.765    22.460     0.200
    27.765    23.390     0.200
    27.790    22.871     0.200
    27.847    22.208     0.200
    28.067    22.570     0.200
    14.200    44.861     0.200
    19.920    39.838     0.200
    23.344    39.732     0.200
    23.712    36.945     0.200
    25.861    32.896     0.200
    25.861    30.717     0.200
    26.032    31.063     0.200
    27.799    23.588     0.200
    21.470    41.561     0.200
    25.658    31.837     0.200
    25.658    31.275     0.200
    25.804    30.351     0.200
    25.803    29.565     0.200
    27.739    25.034     0.200
    27.796    24.362     0.200
    14.061    47.793     0.200
    19.164    40.769     0.200
    20.038    39.738     0.200
    21.222    37.964     0.200
    23.551    38.542     0.200
    23.551    37.722     0.200
    25.314    36.761     0.200
    25.893    31.270     0.200
    25.893    31.329     0.200
    25.893    30.891     0.200
    20.085    40.928     0.200
    23.470    36.203     0.200
    23.579    34.393     0.200
    23.751    34.451     0.200
    25.811    29.489     0.200
    25.811    31.438     0.200
    25.811    29.579     0.200
    26.086    31.555     0.200
    27.821    25.339     0.200
    27.963    23.597     0.200
    14.421    39.245     0.200
    14.395    40.814     0.200
    15.111    41.886     0.200
    15.424    42.175     0.200
    15.424    44.632     0.200
    15.424    40.581     0.200
    20.648    38.473     0.200
    21.258    41.552     0.200
    21.655    38.667     0.200
    22.250    39.449     0.200
    22.812    37.516     0.200
    23.338    37.755     0.200
    23.338    37.579     0.200
    23.435    36.122     0.200
    23.484    36.509     0.200
    23.653    34.233     0.200
    23.659    36.115     0.200
    23.722    34.857     0.200
    23.951    36.020     0.200
    24.144    37.367     0.200
    24.416    35.014     0.200
    24.663    37.519     0.200
    24.810    33.207     0.200
    24.810    32.387     0.200
    25.209    36.342     0.200
    25.828    27.455     0.200
    25.783    28.339     0.200
    25.783    30.851     0.200
    25.783    30.050     0.200
    25.783    28.288     0.200
    25.841    31.675     0.200
    25.986    29.076     0.200
    25.985    28.486     0.200
    27.279    25.415     0.200
    27.640    25.170     0.200
    27.763    25.441     0.200
    27.857    23.438     0.200
    27.857    22.528     0.200
    18.957    40.259     0.200
    20.117    40.661     0.200
    22.042    36.109     0.200
    22.355    40.192     0.200
    22.450    41.081     0.200
    23.466    39.620     0.200
    23.466    35.190     0.200
    23.592    36.169     0.200
    23.764    34.053     0.200
    23.762    36.184     0.200
    23.880    38.538     0.200
    24.703    37.291     0.200
    24.936    33.336     0.200
    25.372    36.781     0.200
    25.805    31.274     0.200
    25.805    29.754     0.200
    25.952    30.562     0.200
    26.100    30.315     0.200
    26.099    29.576     0.200
    27.491    27.457     0.200
    27.548    26.614     0.200
    27.994    22.814     0.200
    28.123    24.074     0.200
    29.298    17.745     0.200
    25.490    32.660     0.200
    19.970    40.014     0.200
    25.736    29.617     0.200
    18.968    39.433     0.200
    23.477    36.682     0.200
    23.606    36.068     0.200
    23.776    36.093     0.200
    25.815    31.588     0.200
    25.956    28.629     0.200
    25.911    31.019     0.200
    26.113    30.580     0.200
    27.106    28.394     0.200
    27.477    24.599     0.200
    27.999    22.638     0.200
    27.999    23.045     0.200
    19.767    39.306     0.200
    23.078    35.214     0.200
    23.259    36.171     0.200
    23.320    35.142     0.200
    25.515    30.996     0.200
    25.515    30.441     0.200
    25.515    31.230     0.200
    25.575    29.841     0.200
    25.699    29.728     0.200
    27.679    22.320     0.200
    27.679    23.156     0.200
    27.771    24.172     0.200
    20.121    40.197     0.200
    23.702    37.300     0.200
    25.798    33.964     0.200
    27.738    25.471     0.200
    15.132    44.073     0.200
    15.190    42.259     0.200
    15.449    42.633     0.200
    15.445    40.586     0.200
    15.897    41.705     0.200
    16.260    44.470     0.200
    18.440    41.132     0.200
    18.588    38.113     0.200
    18.975    40.093     0.200
    19.154    38.394     0.200
    19.154    38.044     0.200
    19.345    39.367     0.200
    19.345    37.857     0.200
    19.525    39.272     0.200
    19.784    39.215     0.200
    19.784    39.548     0.200
    20.386    36.455     0.200
    20.882    38.446     0.200
    21.200    39.524     0.200
    21.199    41.035     0.200
    21.199    37.285     0.200
    21.220    41.087     0.200
    21.220    36.147     0.200
    21.694    39.862     0.200
    21.848    35.725     0.200
    21.910    41.841     0.200
    22.396    39.866     0.200
    22.470    40.996     0.200
    22.611    41.053     0.200
    22.673    36.628     0.200
    22.911    38.212     0.200
    22.911    40.250     0.200
    22.918    40.569     0.200
    23.037    34.421     0.200
    23.101    38.233     0.200
    23.101    36.103     0.200
    23.301    37.909     0.200
    23.494    38.050     0.200
    23.764    38.200     0.200
    24.144    35.961     0.200
    24.312    36.402     0.200
    24.356    34.397     0.200
    24.353    32.006     0.200
    24.357    32.302     0.200
    24.394    34.944     0.200
    24.537    35.380     0.200
    24.859    34.925     0.200
    24.910    31.101     0.200
    24.909    35.236     0.200
    24.992    36.275     0.200
    24.997    34.114     0.200
    25.017    34.383     0.200
    25.081    34.836     0.200
    25.101    33.292     0.200
    25.384    33.800     0.200
    25.467    28.996     0.200
    25.535    31.251     0.200
    25.570    31.030     0.200
    26.315    32.729     0.200
    26.418    29.227     0.200
    27.568    27.810     0.200
    27.699    23.682     0.200
    27.736    24.752     0.200
    27.736    23.752     0.200
    27.875    24.713     0.200
    15.487    44.429     0.200
    15.678    41.437     0.200
    15.903    41.215     0.200
    16.047    40.429     0.200
    16.645    43.252     0.200
    18.527    39.331     0.200
    18.707    38.996     0.200
    19.104    39.403     0.200
    19.529    37.451     0.200
    19.986    40.063     0.200
    20.016    39.817     0.200
    20.120    38.799     0.200
    20.497    39.104     0.200
    20.497    37.205     0.200
    20.847    37.005     0.200
    21.756    38.480     0.200
    21.838    41.652     0.200
    21.838    37.782     0.200
    22.207    41.440     0.200
    22.374    37.203     0.200
    22.436    39.674     0.200
    22.521    39.679     0.200
    22.513    38.269     0.200
    22.604    39.714     0.200
    22.947    39.913     0.200
    23.421    39.483     0.200
    23.480    37.808     0.200
    23.614    36.521     0.200
    23.861    36.845     0.200
    24.360    34.918     0.200
    24.333    36.736     0.200
    24.461    34.039     0.200
    24.511    32.666     0.200
    24.762    35.127     0.200
    24.846    35.651     0.200
    24.992    34.948     0.200
    24.992    32.938     0.200
    25.381    33.204     0.200
    25.447    34.938     0.200
    25.517    33.416     0.200
    25.543    33.718     0.200
    25.958    30.569     0.200
    25.958    31.020     0.200
    25.958    30.070     0.200
    26.055    28.939     0.200
    26.174    29.732     0.200
    26.174    28.549     0.200
    26.173    28.556     0.200
    27.612    25.352     0.200
    27.669    24.686     0.200
    27.855    23.541     0.200
    27.855    23.134     0.200
    27.846    25.134     0.200
    27.846    24.134     0.200
    28.297    24.574     0.200
    19.987    40.152     0.200
    25.941    30.601     0.200
    25.941    31.289     0.200
    14.822    41.750     0.200
    15.118    40.797     0.200
    15.505    41.614     0.200
    15.991    42.805     0.200
    18.983    38.497     0.200
    20.036    40.150     0.200
    20.840    37.598     0.200
    21.355    40.501     0.200
    21.686    38.344     0.200
    21.753    38.680     0.200
    22.392    40.602     0.200
    22.430    39.164     0.200
    22.529    37.302     0.200
    22.912    37.237     0.200
    23.493    38.457     0.200
    23.493    37.066     0.200
    23.576    35.006     0.200
    23.750    36.069     0.200
    23.823    37.010     0.200
    24.213    32.053     0.200
    24.216    37.424     0.200
    24.262    36.787     0.200
    24.725    36.075     0.200
    24.908    34.025     0.200
    25.259    33.048     0.200
    25.328    32.943     0.200
    25.836    30.061     0.200
    25.836    32.712     0.200
    25.836    29.753     0.200
    26.080    29.261     0.200
    26.080    28.761     0.200
    26.080    28.769     0.200
    26.958    28.724     0.200
    27.571    25.258     0.200
    27.748    24.603     0.200
    27.748    24.103     0.200
    27.913    23.370     0.200
    27.913    24.181     0.200
    28.186    23.186     0.200
    25.517    32.080     0.200
    25.517    32.080     0.200
    26.884    27.585     0.200
    27.678    23.313     0.200
    14.756    39.658     0.200
    15.077    43.008     0.200
    15.431    41.578     0.200
    15.936    42.584     0.200
    19.520    37.672     0.200
    19.973    39.070     0.200
    19.973    39.371     0.200
    20.598    38.402     0.200
    20.775    39.116     0.200
    20.775    38.975     0.200
    20.953    38.139     0.200
    21.292    39.773     0.200
    21.711    38.423     0.200
    21.985    39.089     0.200
    22.122    39.996     0.200
    22.305    39.253     0.200
    22.479    36.828     0.200
    22.586    40.080     0.200
    23.379    38.119     0.200
    23.492    35.492     0.200
    23.542    35.821     0.200
    23.542    35.411     0.200
    23.633    33.706     0.200
    23.718    35.768     0.200
    23.718    35.259     0.200
    23.762    36.948     0.200
    23.762    35.538     0.200
    23.938    34.479     0.200
    24.159    35.225     0.200
    24.204    38.695     0.200
    24.625    34.082     0.200
    24.646    35.843     0.200
    24.721    36.364     0.200
    24.865    34.582     0.200
    24.865    32.194     0.200
    25.365    33.750     0.200
    25.350    33.717     0.200
    25.815    30.235     0.200
    25.839    30.241     0.200
    25.839    31.415     0.200
    25.895    32.262     0.200
    26.044    28.351     0.200
    26.043    28.865     0.200
    26.923    26.461     0.200
    27.635    24.328     0.200
    27.852    22.696     0.200
    27.793    24.817     0.200
    28.221    24.524     0.200
    25.444    30.198     0.200
    27.683    22.899     0.200
    25.492    32.457     0.200
    25.492    32.458     0.200
    25.492    32.278     0.200
    14.435    41.373     0.200
    15.426    46.012     0.200
    15.439    40.157     0.200
    16.280    39.636     0.200
    18.419    42.374     0.200
    19.762    38.283     0.200
    20.862    38.303     0.200
    21.540    39.860     0.200
    22.009    41.384     0.200
    22.386    37.186     0.200
    22.494    38.223     0.200
    22.696    37.662     0.200
    22.903    35.335     0.200
    23.042    34.588     0.200
    23.117    37.549     0.200
    23.117    37.350     0.200
    23.222    36.384     0.200
    23.174    36.086     0.200
    23.291    34.233     0.200
    23.759    36.463     0.200
    23.777    36.851     0.200
    24.137    33.545     0.200
    24.140    34.811     0.200
    24.327    36.230     0.200
    24.254    34.313     0.200
    24.546    34.773     0.200
    24.856    33.960     0.200
    24.927    36.233     0.200
    25.011    32.850     0.200
    25.007    34.498     0.200
    25.123    31.949     0.200
    25.383    30.004     0.200
    25.539    30.262     0.200
    25.484    30.987     0.200
    25.538    30.906     0.200
    25.701    31.483     0.200
    26.423    25.275     0.200
    27.676    23.619     0.200
    27.759    24.580     0.200
    27.759    25.479     0.200
    27.895    22.982     0.200
    28.087    23.957     0.200
    29.814    17.696     0.200
    29.814    17.717     0.200
    22.480    40.001     0.200
    22.689    37.271     0.200
    23.009    36.518     0.200
    23.085    36.014     0.200
    23.269    36.538     0.200
    24.636    32.070     0.200
    24.636    32.074     0.200
    25.096    33.679     0.200
    25.452    31.819     0.200
    25.452    32.319     0.200
    25.507    31.783     0.200
    25.506    31.791     0.200
    25.709    29.818     0.200
    27.680    23.994     0.200
    27.680    23.309     0.200
    27.743    25.293     0.200
    27.743    24.691     0.200
    14.106    43.127     0.200
    14.443    40.852     0.200
    14.763    41.308     0.200
    15.136    43.260     0.200
    15.481    42.932     0.200
    15.643    42.840     0.200
    15.822    42.257     0.200
    15.899    41.857     0.200
    16.472    42.574     0.200
    19.547    40.313     0.200
    19.649    39.393     0.200
    19.868    39.140     0.200
    19.982    38.705     0.200
    19.999    38.990     0.200
    19.999    39.115     0.200
    20.290    40.119     0.200
    20.668    39.099     0.200
    20.668    38.502     0.200
    20.766    40.257     0.200
    20.766    40.116     0.200
    20.942    39.112     0.200
    21.274    42.731     0.200
    21.606    38.253     0.200
    21.658    39.065     0.200
    22.104    41.243     0.200
    22.247    39.276     0.200
    22.428    39.161     0.200
    22.546    40.290     0.200
    22.826    39.714     0.200
    23.071    38.463     0.200
    23.351    36.593     0.200
    23.351    38.495     0.200
    23.353    38.869     0.200
    23.420    39.387     0.200
    23.420    37.176     0.200
    23.482    37.864     0.200
    23.482    36.474     0.200
    23.679    36.385     0.200
    23.679    33.244     0.200
    23.656    36.829     0.200
    23.656    36.720     0.200
    23.736    36.902     0.200
    23.736    35.730     0.200
    23.961    36.041     0.200
    24.130    35.996     0.200
    24.134    37.959     0.200
    24.171    38.822     0.200
    24.227    37.570     0.200
    24.391    34.291     0.200
    24.604    35.873     0.200
    24.649    37.043     0.200
    24.812    34.941     0.200
    24.851    34.492     0.200
    25.193    36.600     0.200
    25.282    34.465     0.200
    25.282    32.863     0.200
    25.478    35.068     0.200
    25.767    31.703     0.200
    25.767    32.481     0.200
    25.854    30.944     0.200
    25.844    33.195     0.200
    25.865    30.759     0.200
    25.986    30.046     0.200
    25.985    31.264     0.200
    26.622    33.917     0.200
    26.863    28.802     0.200
    27.616    26.016     0.200
    27.616    25.567     0.200
    27.673    25.041     0.200
    27.737    25.504     0.200
    27.737    25.402     0.200
    27.883    25.640     0.200
    27.883    23.527     0.200
    27.883    25.273     0.200
    28.008    28.649     0.200
    28.157    25.304     0.200
    14.038    39.869     0.200
    14.411    39.405     0.200
    15.090    43.992     0.200
    15.186    40.762     0.200
    15.297    41.065     0.200
    15.392    40.455     0.200
    15.477    41.576     0.200
    15.536    40.285     0.200
    15.536    41.375     0.200
    15.526    41.053     0.200
    18.241    40.324     0.200
    18.402    41.130     0.200
    19.643    39.356     0.200
    20.058    39.409     0.200
    20.337    38.690     0.200
    20.896    39.431     0.200
    20.882    39.095     0.200
    21.150    40.269     0.200
    21.150    40.771     0.200
    21.150    39.329     0.200
    21.169    39.346     0.200
    21.464    39.203     0.200
    21.501    38.670     0.200
    21.529    40.948     0.200
    21.643    39.210     0.200
    21.750    39.760     0.200
    21.798    36.408     0.200
    21.859    38.695     0.200
    21.966    37.444     0.200
    22.214    37.626     0.200
    22.344    39.430     0.200
    22.487    39.562     0.200
    22.559    39.517     0.200
    22.559    37.357     0.200
    22.699    36.792     0.200
    22.876    37.626     0.200
    22.991    37.278     0.200
    22.991    35.817     0.200
    23.075    37.304     0.200
    23.075    36.203     0.200
    23.172    38.172     0.200
    23.172    36.594     0.200
    23.249    36.774     0.200
    23.249    34.274     0.200
    23.442    37.321     0.200
    23.586    33.297     0.200
    23.612    35.228     0.200
    23.625    36.778     0.200
    23.709    36.203     0.200
    23.730    36.052     0.200
    24.093    34.124     0.200
    24.093    35.324     0.200
    24.303    33.364     0.200
    24.283    34.401     0.200
    24.342    34.211     0.200
    24.365    33.297     0.200
    24.470    32.018     0.200
    24.497    34.207     0.200
    24.837    34.942     0.200
    24.859    34.885     0.200
    24.859    32.256     0.200
    24.887    33.852     0.200
    24.966    33.437     0.200
    24.963    33.866     0.200
    24.966    32.233     0.200
    25.039    32.980     0.200
    25.092    32.058     0.200
    25.333    31.144     0.200
    25.443    32.519     0.200
    25.443    31.476     0.200
    25.443    31.367     0.200
    25.443    30.867     0.200
    25.488    30.990     0.200
    25.488    30.740     0.200
    25.488    30.786     0.200
    25.542    31.813     0.200
    25.546    31.210     0.200
    25.546    30.464     0.200
    25.700    28.850     0.200
    26.290    31.482     0.200
    26.372    27.125     0.200
    26.751    27.498     0.200
    26.796    28.275     0.200
    26.999    27.109     0.200
    27.009    26.785     0.200
    27.523    25.396     0.200
    27.668    23.896     0.200
    27.668    23.209     0.200
    27.747    24.577     0.200
    27.747    24.276     0.200
    27.913    24.584     0.200
    27.970    23.918     0.200
    28.057    23.866     0.200
    28.065    23.667     0.200
    28.333    21.898     0.200
    28.363    23.288     0.200
    19.621    38.811     0.200
    21.473    41.066     0.200
    23.351    36.657     0.200
    23.539    35.950     0.200
    25.494    28.929     0.200
    25.838    29.065     0.200
    25.837    30.506     0.200
    25.856    31.026     0.200
    27.511    24.618     0.200
    27.511    24.758     0.200
    14.118    38.590     0.200
    17.605    41.824     0.200
    18.217    39.408     0.200
    18.387    41.668     0.200
    18.714    38.458     0.200
    20.233    38.030     0.200
    20.617    37.617     0.200
    22.270    39.854     0.200
    22.645    37.276     0.200
    22.805    37.211     0.200
    23.175    36.593     0.200
    23.280    33.782     0.200
    23.378    36.425     0.200
    23.378    34.393     0.200
    23.464    35.470     0.200
    24.011    34.940     0.200
    24.038    35.518     0.200
    24.288    33.199     0.200
    24.322    32.414     0.200
    24.570    32.121     0.200
    24.589    34.190     0.200
    24.565    32.976     0.200
    24.801    33.114     0.200
    25.086    31.686     0.200
    25.215    30.587     0.200
    25.273    33.911     0.200
    25.341    31.910     0.200
    25.357    29.831     0.200
    25.592    29.553     0.200
    25.594    29.671     0.200
    25.771    29.372     0.200
    25.771    28.497     0.200
    25.770    28.524     0.200
    25.743    29.328     0.200
    25.743    30.727     0.200
    25.743    29.227     0.200
    25.845    28.738     0.200
    26.660    25.522     0.200
    26.810    26.674     0.200
    27.091    26.593     0.200
    27.269    23.814     0.200
    27.297    24.492     0.200
    27.598    22.698     0.200
    27.815    22.448     0.200
    27.930    23.299     0.200
    28.342    21.200     0.200
    28.294    22.059     0.200
    23.660    32.868     0.200
    25.418    32.911     0.200
    25.777    30.400     0.200
    27.748    23.387     0.200
    15.897    42.909     0.200
    18.530    39.154     0.200
    19.555    38.888     0.200
    20.006    39.553     0.200
    20.006    39.753     0.200
    20.634    38.327     0.200
    20.680    38.891     0.200
    21.275    43.046     0.200
    21.652    39.845     0.200
    21.652    38.634     0.200
    21.967    40.367     0.200
    22.240    37.979     0.200
    22.308    39.892     0.200
    22.826    40.041     0.200
    23.409    37.234     0.200
    23.409    35.707     0.200
    23.475    36.572     0.200
    23.475    34.353     0.200
    23.649    36.541     0.200
    23.649    35.841     0.200
    23.689    33.517     0.200
    23.735    36.725     0.200
    24.118    35.670     0.200
    24.124    35.500     0.200
    24.163    35.443     0.200
    24.601    36.736     0.200
    24.807    33.630     0.200
    24.807    32.290     0.200
    25.182    32.655     0.200
    25.316    32.886     0.200
    25.756    30.413     0.200
    25.756    30.350     0.200
    25.756    29.882     0.200
    25.839    31.380     0.200
    25.863    30.238     0.200
    25.979    29.998     0.200
    25.978    29.736     0.200
    26.856    26.911     0.200
    27.610    24.869     0.200
    27.727    24.754     0.200
    27.891    22.961     0.200
    27.891    23.497     0.200
    23.089    36.215     0.200
    23.266    36.106     0.200
    25.480    31.865     0.200
    25.777    30.411     0.200
    14.443    38.049     0.200
    14.765    41.192     0.200
    15.162    37.663     0.200
    15.503    37.482     0.200
    15.880    40.778     0.200
    18.531    35.901     0.200
    18.877    36.420     0.200
    19.649    34.697     0.200
    19.866    36.356     0.200
    19.985    35.775     0.200
    20.008    36.838     0.200
    20.008    36.603     0.200
    20.700    35.334     0.200
    20.700    34.334     0.200
    20.760    34.174     0.200
    21.225    35.521     0.200
    21.264    38.852     0.200
    21.597    37.464     0.200
    21.632    37.954     0.200
    21.632    33.564     0.200
    21.956    34.777     0.200
    22.094    36.457     0.200
    22.219    36.101     0.200
    22.255    35.398     0.200
    22.285    34.227     0.200
    22.407    35.209     0.200
    22.529    35.083     0.200
    22.813    35.669     0.200
    23.315    38.519     0.200
    23.336    34.786     0.200
    23.336    33.966     0.200
    23.387    33.869     0.200
    23.387    32.861     0.200
    23.453    32.698     0.200
    23.627    32.670     0.200
    23.698    30.723     0.200
    23.722    31.668     0.200
    23.722    30.895     0.200
    24.101    32.538     0.200
    24.101    31.840     0.200
    24.140    31.884     0.200
    24.211    31.854     0.200
    24.365    30.813     0.200
    24.576    31.998     0.200
    24.583    30.311     0.200
    24.616    31.229     0.200
    24.787    29.840     0.200
    24.831    32.116     0.200
    24.916    30.333     0.200
    24.957    29.348     0.200
    25.124    31.808     0.200
    25.160    29.681     0.200
    25.251    30.222     0.200
    25.251    29.120     0.200
    25.288    31.782     0.200
    25.298    29.875     0.200
    25.312    30.905     0.200
    25.455    28.840     0.200
    25.469    29.181     0.200
    25.734    29.326     0.200
    25.734    27.521     0.200
    25.734    28.037     0.200
    25.734    26.685     0.200
    25.828    28.390     0.200
    25.819    28.085     0.200
    25.832    27.147     0.200
    25.870    26.962     0.200
    25.958    26.870     0.200
    26.500    26.645     0.200
    26.589    28.704     0.200
    26.835    23.236     0.200
    27.237    21.246     0.200
    27.610    22.492     0.200
    27.610    21.859     0.200
    27.714    21.378     0.200
    27.714    20.480     0.200
    27.895    21.855     0.200
    29.978    14.355     0.200
    14.999    41.806     0.200
    15.229    44.568     0.200
    15.229    40.466     0.200
    15.197    41.397     0.200
    15.432    39.698     0.200
    15.600    39.742     0.200
    16.347    41.227     0.200
    17.309    42.601     0.200
    17.492    41.551     0.200
    17.492    41.254     0.200
    18.711    40.116     0.200
    18.891    39.730     0.200
    19.149    39.321     0.200
    19.621    38.207     0.200
    19.843    39.427     0.200
    20.337    39.264     0.200
    20.376    36.399     0.200
    20.508    38.159     0.200
    20.793    37.764     0.200
    21.093    42.635     0.200
    21.360    39.219     0.200
    21.360    38.500     0.200
    21.360    41.620     0.200
    21.688    40.584     0.200
    21.675    38.643     0.200
    21.662    40.192     0.200
    21.829    42.049     0.200
    21.986    36.179     0.200
    21.957    39.652     0.200
    22.117    37.887     0.200
    22.367    38.067     0.200
    22.471    37.955     0.200
    22.539    38.355     0.200
    22.643    37.439     0.200
    22.769    38.275     0.200
    22.769    38.994     0.200
    23.059    39.792     0.200
    23.059    37.893     0.200
    23.051    38.382     0.200
    23.073    41.135     0.200
    23.196    37.195     0.200
    23.196    36.507     0.200
    23.223    36.979     0.200
    23.223    36.049     0.200
    23.300    36.581     0.200
    23.374    37.114     0.200
    23.446    36.172     0.200
    23.446    34.836     0.200
    23.614    34.878     0.200
    23.646    35.946     0.200
    23.820    35.009     0.200
    23.832    33.573     0.200
    23.913    34.189     0.200
    23.933    33.889     0.200
    23.903    36.442     0.200
    23.902    36.357     0.200
    24.096    34.190     0.200
    24.140    34.430     0.200
    24.140    32.258     0.200
    24.296    33.853     0.200
    24.302    34.079     0.200
    24.384    33.795     0.200
    24.509    33.866     0.200
    24.440    34.475     0.200
    24.510    32.956     0.200
    24.514    33.709     0.200
    24.514    34.139     0.200
    24.682    31.755     0.200
    24.687    34.502     0.200
    24.975    33.833     0.200
    25.018    33.531     0.200
    25.020    32.208     0.200
    25.068    33.641     0.200
    25.117    34.278     0.200
    25.128    35.650     0.200
    25.177    32.576     0.200
    25.178    31.963     0.200
    25.178    31.267     0.200
    25.233    32.630     0.200
    25.545    30.786     0.200
    25.583    31.918     0.200
    25.583    30.363     0.200
    25.583    30.840     0.200
    25.583    29.840     0.200
    25.695    30.567     0.200
    25.753    31.132     0.200
    25.680    30.608     0.200
    25.684    30.505     0.200
    25.684    29.060     0.200
    26.238    27.102     0.200
    26.433    30.916     0.200
    26.577    27.137     0.200
    26.771    27.073     0.200
    26.963    25.441     0.200
    26.997    27.441     0.200
    27.014    26.236     0.200
    27.209    24.963     0.200
    27.747    23.539     0.200
    27.747    23.977     0.200
    27.725    25.133     0.200
    27.751    24.430     0.200
    27.751    24.930     0.200
    27.798    24.860     0.200
    28.263    22.862     0.200
    28.562    25.670     0.200
    19.447    37.670     0.200
    21.889    36.234     0.200
    23.484    38.184     0.200
    23.740    34.220     0.200
    23.920    34.209     0.200
    23.956    35.044     0.200
    23.956    33.829     0.200
    25.041    32.874     0.200
    26.067    31.258     0.200
    26.067    28.666     0.200
    26.236    30.082     0.200
    26.236    30.089     0.200
    27.684    25.368     0.200
    23.721    35.183     0.200
    26.035    29.320     0.200
    27.661    24.776     0.200
    21.043    36.300     0.200
    21.287    36.959     0.200
    22.535    34.236     0.200
    25.540    31.927     0.200
    27.712    23.721     0.200
    21.703    38.421     0.200
    21.865    35.688     0.200
    22.105    38.236     0.200
    22.524    39.844     0.200
    22.583    35.854     0.200
    22.978    36.940     0.200
    23.624    37.203     0.200
    23.624    33.193     0.200
    23.868    34.263     0.200
    24.500    31.745     0.200
    24.857    36.214     0.200
    25.019    32.661     0.200
    25.165    33.717     0.200
    25.388    35.120     0.200
    25.445    31.151     0.200
    25.528    34.986     0.200
    25.557    28.367     0.200
    25.966    30.593     0.200
    25.966    30.071     0.200
    26.063    27.135     0.200
    26.199    29.418     0.200
    26.198    26.375     0.200
    27.584    23.999     0.200
    27.584    25.655     0.200
    27.641    23.701     0.200
    27.879    23.105     0.200
    28.290    24.059     0.200
    14.473    36.704     0.200
    23.033    35.405     0.200
    23.033    35.034     0.200
    23.165    31.829     0.200
    23.640    30.722     0.200
    23.694    35.795     0.200
    24.245    35.460     0.200
    24.840    32.022     0.200
    25.023    30.181     0.200
    25.398    28.935     0.200
    25.398    28.006     0.200
    25.398    28.147     0.200
    25.500    27.112     0.200
    26.731    22.757     0.200
    27.741    20.391     0.200
    27.844    21.608     0.200
    27.901    20.946     0.200
    29.787    17.284     0.200
    19.967    37.746     0.200
    23.034    35.823     0.200
    25.387    30.932     0.200
    27.882    19.650     0.200
    14.148    44.178     0.200
    14.930    44.897     0.200
    15.318    40.926     0.200
    20.948    38.316     0.200
    21.288    41.654     0.200
    22.387    40.725     0.200
    22.588    38.585     0.200
    22.846    39.467     0.200
    23.489    38.164     0.200
    23.537    35.801     0.200
    23.713    35.778     0.200
    24.200    36.164     0.200
    24.232    36.793     0.200
    24.718    35.327     0.200
    24.860    34.277     0.200
    25.349    31.662     0.200
    25.390    35.680     0.200
    25.561    32.987     0.200
    25.836    30.475     0.200
    25.836    31.975     0.200
    25.836    30.694     0.200
    26.039    29.782     0.200
    26.038    30.286     0.200
    27.639    25.889     0.200
    27.696    26.671     0.200
    27.850    22.773     0.200
    14.181    44.135     0.200
    15.318    41.994     0.200
    15.318    43.880     0.200
    15.881    44.017     0.200
    16.315    41.453     0.200
    16.644    46.410     0.200
    17.408    45.169     0.200
    17.408    44.118     0.200
    18.584    40.972     0.200
    19.449    40.675     0.200
    19.517    39.875     0.200
    19.733    40.760     0.200
    19.897    40.299     0.200
    20.623    40.774     0.200
    20.704    39.615     0.200
    20.704    38.730     0.200
    21.125    43.817     0.200
    21.514    41.903     0.200
    21.817    40.041     0.200
    22.116    38.754     0.200
    22.239    43.514     0.200
    22.477    40.336     0.200
    22.621    39.058     0.200
    22.675    39.930     0.200
    22.919    39.523     0.200
    23.348    36.537     0.200
    23.343    40.727     0.200
    23.343    38.848     0.200
    23.526    36.207     0.200
    23.618    35.236     0.200
    24.036    39.142     0.200
    24.051    39.473     0.200
    24.452    35.882     0.200
    24.415    33.978     0.200
    24.668    33.626     0.200
    25.129    34.981     0.200
    25.170    34.910     0.200
    25.256    36.603     0.200
    25.776    33.282     0.200
    25.697    34.177     0.200
    25.697    33.154     0.200
    25.849    30.402     0.200
    25.848    30.506     0.200
    26.619    29.704     0.200
    26.730    29.109     0.200
    27.790    23.548     0.200
    27.790    25.617     0.200
    27.729    25.545     0.200
    27.729    25.248     0.200
    27.786    25.620     0.200
    27.772    25.840     0.200
    29.578    20.173     0.200
    29.578    20.139     0.200
    14.240    47.301     0.200
    23.406    38.138     0.200
    25.778    33.349     0.200
    25.778    32.987     0.200
    25.903    32.082     0.200
    25.902    31.351     0.200
    27.767    24.886     0.200
    22.228    36.723     0.200
    25.461    27.627     0.200
    27.679    24.101     0.200
    27.679    21.539     0.200
    16.316    42.834     0.200
    19.697    39.304     0.200
    22.553    38.154     0.200
    22.648    36.425     0.200
    22.759    37.046     0.200
    23.025    36.732     0.200
    23.135    37.256     0.200
    23.135    35.947     0.200
    23.208    35.969     0.200
    23.521    34.785     0.200
    23.784    36.784     0.200
    24.342    35.877     0.200
    24.951    34.469     0.200
    25.162    34.412     0.200
    25.505    29.618     0.200
    25.505    30.723     0.200
    25.505    28.798     0.200
    25.519    29.255     0.200
    25.609    27.651     0.200
    25.639    30.064     0.200
    26.826    24.200     0.200
    27.612    22.416     0.200
    27.612    24.713     0.200
    27.815    23.342     0.200
    27.815    21.983     0.200
    27.960    23.305     0.200
    27.960    22.414     0.200
    28.017    24.103     0.200
    29.877    15.578     0.200
    25.761    29.280     0.200
    25.761    29.178     0.200
    25.761    29.690     0.200
    27.567    23.734     0.200
    14.747    42.735     0.200
    25.472    31.550     0.200
    26.811    25.774     0.200
    27.637    22.980     0.200
    16.495    41.249     0.200
    18.495    38.398     0.200
    23.438    37.790     0.200
    23.438    36.329     0.200
    23.484    35.475     0.200
    23.648    31.722     0.200
    25.823    25.842     0.200
    25.786    29.837     0.200
    25.786    30.790     0.200
    25.786    29.860     0.200
    25.986    31.251     0.200
    27.644    23.547     0.200
    27.701    21.373     0.200
    27.853    22.351     0.200
    20.150    37.467     0.200
    25.743    31.198     0.200
    28.031    21.064     0.200
    20.129    38.229     0.200
    25.843    31.763     0.200
    27.475    26.641     0.200
    28.002    21.246     0.200
    14.941    41.040     0.200
    15.200    43.715     0.200
    15.625    41.466     0.200
    15.717    41.486     0.200
    15.819    41.785     0.200
    16.084    43.803     0.200
    16.226    44.245     0.200
    18.686    39.365     0.200
    18.974    39.601     0.200
    19.698    39.083     0.200
    20.051    39.398     0.200
    20.152    37.446     0.200
    20.152    39.219     0.200
    20.821    39.326     0.200
    20.955    38.159     0.200
    20.955    37.550     0.200
    21.834    38.802     0.200
    21.834    36.459     0.200
    21.821    38.956     0.200
    21.821    36.917     0.200
    22.157    40.024     0.200
    22.150    38.913     0.200
    22.295    37.416     0.200
    22.334    38.567     0.200
    22.398    39.221     0.200
    22.384    37.172     0.200
    22.457    36.235     0.200
    22.422    38.940     0.200
    22.475    36.097     0.200
    23.017    36.290     0.200
    23.241    37.977     0.200
    23.483    36.159     0.200
    23.483    35.237     0.200
    23.528    39.430     0.200
    23.627    36.870     0.200
    23.627    35.471     0.200
    23.789    34.487     0.200
    23.753    33.235     0.200
    23.753    33.688     0.200
    23.797    35.891     0.200
    23.797    35.164     0.200
    23.926    33.886     0.200
    23.926    34.308     0.200
    24.225    36.897     0.200
    24.304    31.870     0.200
    24.296    35.269     0.200
    24.318    35.308     0.200
    24.325    33.093     0.200
    24.722    34.498     0.200
    24.784    34.473     0.200
    24.976    31.926     0.200
    25.065    33.298     0.200
    25.151    35.694     0.200
    25.277    32.625     0.200
    25.390    34.199     0.200
    25.424    34.406     0.200
    25.623    31.783     0.200
    25.819    29.853     0.200
    25.819    29.611     0.200
    25.981    29.140     0.200
    25.910    31.524     0.200
    25.914    29.180     0.200
    26.137    27.688     0.200
    26.137    28.587     0.200
    26.136    28.641     0.200
    26.345    28.863     0.200
    27.009    28.302     0.200
    27.413    25.596     0.200
    27.453    25.625     0.200
    27.453    24.774     0.200
    27.659    24.620     0.200
    28.028    22.793     0.200
    28.028    22.387     0.200
    29.254    19.806     0.200
    29.254    19.783     0.200
    15.556    40.220     0.200
    15.569    39.956     0.200
    16.299    41.192     0.200
    21.178    39.165     0.200
    22.266    36.763     0.200
    22.531    39.676     0.200
    22.737    37.273     0.200
    23.026    36.706     0.200
    23.124    37.544     0.200
    23.255    36.092     0.200
    23.208    36.614     0.200
    23.749    36.454     0.200
    23.777    36.430     0.200
    24.013    36.985     0.200
    24.332    35.859     0.200
    24.413    34.533     0.200
    25.080    33.630     0.200
    25.144    33.176     0.200
    25.521    31.627     0.200
    25.493    32.173     0.200
    25.493    31.602     0.200
    25.493    32.399     0.200
    25.493    29.993     0.200
    25.661    30.275     0.200
    25.593    32.546     0.200
    25.597    31.194     0.200
    26.833    25.775     0.200
    27.635    24.034     0.200
    27.793    24.361     0.200
    27.793    24.658     0.200
    14.244    39.801     0.200
    14.766    41.418     0.200
    15.047    39.589     0.200
    15.515    39.677     0.200
    15.452    41.742     0.200
    15.589    42.116     0.200
    15.586    44.008     0.200
    15.586    43.649     0.200
    15.586    42.071     0.200
    15.709    40.318     0.200
    15.783    39.555     0.200
    16.013    44.768     0.200
    16.152    45.645     0.200
    16.430    41.201     0.200
    17.146    40.878     0.200
    17.146    40.089     0.200
    18.660    38.545     0.200
    20.133    38.768     0.200
    20.133    39.088     0.200
    20.903    39.131     0.200
    21.744    38.164     0.200
    21.772    38.301     0.200
    22.098    40.360     0.200
    22.237    39.037     0.200
    22.321    38.451     0.200
    22.318    37.192     0.200
    22.320    38.663     0.200
    22.424    38.559     0.200
    22.397    38.234     0.200
    22.421    38.058     0.200
    22.954    37.273     0.200
    23.203    37.263     0.200
    23.417    35.967     0.200
    23.550    36.312     0.200
    23.550    35.804     0.200
    23.788    34.202     0.200
    23.788    35.413     0.200
    23.720    36.332     0.200
    23.720    35.543     0.200
    23.861    33.579     0.200
    23.861    35.634     0.200
    24.153    36.373     0.200
    24.220    35.097     0.200
    24.300    33.823     0.200
    24.256    35.172     0.200
    24.349    35.593     0.200
    24.654    33.932     0.200
    24.900    35.360     0.200
    24.900    33.133     0.200
    24.963    35.827     0.200
    24.989    33.311     0.200
    25.229    33.215     0.200
    25.323    33.725     0.200
    25.354    32.355     0.200
    25.547    32.007     0.200
    25.756    30.172     0.200
    25.756    30.867     0.200
    25.756    29.664     0.200
    25.848    31.399     0.200
    25.852    30.249     0.200
    25.977    29.477     0.200
    26.059    29.482     0.200
    26.059    29.443     0.200
    26.614    30.454     0.200
    27.335    28.840     0.200
    27.335    26.379     0.200
    27.479    24.758     0.200
    27.479    25.109     0.200
    27.536    24.794     0.200
    27.445    25.493     0.200
    27.639    24.695     0.200
    27.639    24.890     0.200
    27.792    24.374     0.200
    28.014    22.516     0.200
    28.080    23.340     0.200
    29.301    17.303     0.200
    29.301    20.959     0.200
    29.301    20.960     0.200
    14.092    45.058     0.200
    14.804    41.212     0.200
    15.142    42.507     0.200
    15.525    44.623     0.200
    15.609    42.694     0.200
    15.585    42.946     0.200
    16.109    42.816     0.200
    17.132    43.894     0.200
    19.817    40.343     0.200
    20.041    40.023     0.200
    20.121    39.676     0.200
    20.121    39.402     0.200
    20.125    39.351     0.200
    20.846    40.333     0.200
    21.144    41.004     0.200
    21.473    43.025     0.200
    21.844    40.986     0.200
    21.844    39.509     0.200
    21.862    40.512     0.200
    22.165    40.637     0.200
    22.302    38.348     0.200
    22.387    40.154     0.200
    22.466    39.930     0.200
    22.465    40.134     0.200
    22.465    38.689     0.200
    22.449    39.133     0.200
    22.541    39.414     0.200
    23.030    38.542     0.200
    23.304    39.146     0.200
    23.557    40.297     0.200
    23.547    37.914     0.200
    23.547    37.563     0.200
    23.740    37.451     0.200
    23.771    35.471     0.200
    23.771    35.846     0.200
    23.847    37.138     0.200
    23.941    37.897     0.200
    24.286    37.688     0.200
    24.330    35.369     0.200
    24.383    36.769     0.200
    24.351    36.831     0.200
    24.785    36.662     0.200
    25.017    34.356     0.200
    25.122    34.636     0.200
    25.342    35.169     0.200
    25.454    36.061     0.200
    25.939    30.654     0.200
    25.884    31.538     0.200
    25.884    31.889     0.200
    25.884    32.335     0.200
    25.884    31.530     0.200
    25.976    33.372     0.200
    25.980    31.121     0.200
    26.183    30.722     0.200
    26.183    29.847     0.200
    26.183    29.823     0.200
    26.372    28.042     0.200
    27.058    27.946     0.200
    27.480    26.523     0.200
    27.480    25.718     0.200
    27.537    26.824     0.200
    27.464    26.860     0.200
    27.715    27.371     0.200
    27.991    23.394     0.200
    28.177    25.187     0.200
    29.262    19.222     0.200
    15.434    40.889     0.200
    19.175    36.335     0.200
    20.629    39.221     0.200
    22.255    39.264     0.200
    22.323    39.747     0.200
    22.466    37.647     0.200
    23.342    38.530     0.200
    23.342    40.561     0.200
    23.425    37.683     0.200
    23.425    36.160     0.200
    23.480    35.505     0.200
    23.655    35.362     0.200
    23.726    36.268     0.200
    23.726    36.041     0.200
    24.137    37.382     0.200
    24.171    37.884     0.200
    24.403    34.332     0.200
    24.654    35.449     0.200
    24.778    37.196     0.200
    25.773    30.890     0.200
    25.773    30.890     0.200
    25.840    33.609     0.200
    25.983    29.741     0.200
    25.983    29.241     0.200
    25.982    29.287     0.200
    26.520    27.267     0.200
    27.275    29.144     0.200
    27.630    24.618     0.200
    27.630    25.118     0.200
    27.750    24.716     0.200
    27.870    24.747     0.200
    17.118    41.839     0.200
    19.284    39.257     0.200
    19.693    39.750     0.200
    21.824    37.359     0.200
    23.475    36.149     0.200
    23.617    34.780     0.200
    23.759    31.971     0.200
    23.787    35.354     0.200
    23.787    34.956     0.200
    23.916    35.790     0.200
    25.812    30.479     0.200
    25.979    28.802     0.200
    27.458    25.305     0.200
    27.515    25.669     0.200
    27.500    25.188     0.200
    28.024    23.759     0.200
    29.262    20.183     0.200
    29.262    19.872     0.200
    29.264    20.455     0.200
    29.957    17.715     0.200
    14.045    42.939     0.200
    14.112    43.322     0.200
    15.154    42.690     0.200
    15.411    38.708     0.200
    16.328    37.888     0.200
    17.317    42.343     0.200
    18.499    37.837     0.200
    19.529    37.893     0.200
    20.708    35.551     0.200
    20.750    35.322     0.200
    20.720    37.438     0.200
    21.589    34.478     0.200
    21.593    39.751     0.200
    21.593    35.601     0.200
    21.789    38.366     0.200
    21.914    38.203     0.200
    22.053    38.085     0.200
    22.182    37.873     0.200
    22.265    37.609     0.200
    22.422    37.578     0.200
    22.416    34.350     0.200
    22.552    35.864     0.200
    22.771    37.702     0.200
    23.009    34.011     0.200
    23.294    36.059     0.200
    23.294    38.002     0.200
    23.282    37.543     0.200
    23.368    35.142     0.200
    23.417    34.459     0.200
    23.417    33.799     0.200
    23.592    34.421     0.200
    23.592    33.381     0.200
    23.680    35.700     0.200
    23.961    31.651     0.200
    24.226    30.920     0.200
    24.226    30.923     0.200
    24.059    33.567     0.200
    24.076    34.080     0.200
    24.108    34.098     0.200
    24.223    33.860     0.200
    24.374    31.958     0.200
    24.595    31.922     0.200
    24.748    30.195     0.200
    24.885    32.030     0.200
    25.106    33.749     0.200
    25.246    31.125     0.200
    25.246    29.525     0.200
    25.268    34.368     0.200
    25.289    31.317     0.200
    25.415    29.454     0.200
    25.437    30.995     0.200
    25.716    30.561     0.200
    25.716    28.720     0.200
    25.716    28.722     0.200
    25.716    29.131     0.200
    25.716    28.470     0.200
    25.811    30.232     0.200
    25.815    27.584     0.200
    25.921    28.585     0.200
    25.921    27.044     0.200
    25.920    27.092     0.200
    26.571    30.159     0.200
    26.799    27.099     0.200
    27.642    22.761     0.200
    27.642    22.255     0.200
    27.699    22.895     0.200
    27.725    22.690     0.200
    27.725    22.290     0.200
    27.868    20.699     0.200
    27.868    21.032     0.200
    28.133    22.234     0.200
    29.481    16.173     0.200
    29.481    16.193     0.200
    18.964    36.746     0.200
    19.651    36.814     0.200
    25.813    30.253     0.200
    27.982    24.138     0.200
    27.982    22.648     0.200
    14.130    46.931     0.200
    14.553    41.397     0.200
    18.632    40.993     0.200
    18.904    40.369     0.200
    19.654    41.757     0.200
    22.368    39.783     0.200
    22.447    40.173     0.200
    23.413    36.316     0.200
    23.532    35.854     0.200
    23.703    35.613     0.200
    23.772    37.194     0.200
    25.754    32.275     0.200
    25.754    30.982     0.200
    25.953    30.189     0.200
    26.040    30.419     0.200
    26.040    29.150     0.200
    27.988    23.915     0.200
    28.093    24.883     0.200
    20.149    40.770     0.200
    22.419    37.488     0.200
    23.459    35.518     0.200
    23.602    35.283     0.200
    23.794    34.686     0.200
    23.771    35.575     0.200
    25.796    30.916     0.200
    25.984    29.723     0.200
    26.111    28.850     0.200
    26.110    28.127     0.200
    26.110    28.858     0.200
    27.458    26.549     0.200
    28.027    21.695     0.200
    28.100    23.787     0.200
    20.037    39.072     0.200
    25.813    34.502     0.200
    19.511    38.093     0.200
    20.616    37.367     0.200
    23.633    32.130     0.200
    25.816    32.840     0.200
    25.816    30.005     0.200
    25.914    27.883     0.200
    27.274    25.236     0.200
    18.474    39.841     0.200
    19.941    38.472     0.200
    20.602    35.863     0.200
    23.533    38.999     0.200
    23.566    38.414     0.200
    25.881    29.583     0.200
    25.881    33.688     0.200
    26.066    31.729     0.200
    27.665    25.939     0.200
    27.836    26.411     0.200
    29.455    20.711     0.200
    14.006    39.534     0.200
    14.264    38.858     0.200
    14.580    39.271     0.200
    14.786    38.761     0.200
    15.067    41.233     0.200
    15.453    40.882     0.200
    15.490    41.744     0.200
    15.494    42.150     0.200
    15.583    40.785     0.200
    15.583    39.020     0.200
    15.779    41.384     0.200
    16.034    40.806     0.200
    16.177    39.523     0.200
    16.468    41.027     0.200
    17.151    43.938     0.200
    17.151    42.157     0.200
    18.791    38.133     0.200
    20.675    38.021     0.200
    20.909    37.278     0.200
    21.130    36.301     0.200
    21.417    40.886     0.200
    21.785    35.920     0.200
    21.773    38.827     0.200
    21.773    36.640     0.200
    22.109    38.114     0.200
    22.247    37.800     0.200
    22.353    38.067     0.200
    22.348    38.915     0.200
    22.357    36.216     0.200
    22.408    37.529     0.200
    22.460    36.254     0.200
    22.968    37.592     0.200
    22.992    38.107     0.200
    23.201    36.974     0.200
    23.238    37.334     0.200
    23.434    36.653     0.200
    23.491    35.581     0.200
    23.479    37.923     0.200
    23.456    35.084     0.200
    23.456    34.358     0.200
    23.583    35.705     0.200
    23.583    34.385     0.200
    23.770    33.054     0.200
    23.770    32.312     0.200
    23.754    34.715     0.200
    23.754    34.528     0.200
    23.793    36.009     0.200
    23.793    33.282     0.200
    23.876    36.682     0.200
    23.876    33.112     0.200
    24.046    32.131     0.200
    24.030    34.646     0.200
    24.266    35.440     0.200
    24.256    33.956     0.200
    24.331    32.510     0.200
    24.693    33.457     0.200
    24.735    34.168     0.200
    24.929    34.104     0.200
    24.929    32.026     0.200
    25.026    32.264     0.200
    25.103    33.974     0.200
    25.184    33.326     0.200
    25.215    31.767     0.200
    25.267    32.161     0.200
    25.267    30.356     0.200
    25.362    32.647     0.200
    25.394    32.875     0.200
    25.448    34.246     0.200
    25.501    31.172     0.200
    25.583    30.763     0.200
    25.602    31.043     0.200
    25.795    29.796     0.200
    25.795    28.859     0.200
    25.795    29.437     0.200
    25.795    28.593     0.200
    25.957    27.801     0.200
    25.957    27.262     0.200
    25.887    29.922     0.200
    25.891    28.976     0.200
    25.964    31.129     0.200
    26.050    26.880     0.200
    26.091    28.512     0.200
    26.091    28.137     0.200
    26.091    28.122     0.200
    26.654    28.477     0.200
    26.822    25.810     0.200
    26.965    25.943     0.200
    27.370    26.912     0.200
    27.370    25.717     0.200
    27.489    24.332     0.200
    27.489    25.965     0.200
    27.546    22.774     0.200
    27.669    23.426     0.200
    27.669    22.926     0.200
    27.790    22.743     0.200
    27.998    22.077     0.200
    27.998    21.686     0.200
    27.998    21.444     0.200
    28.115    23.221     0.200
    29.299    19.404     0.200
    29.299    19.913     0.200
    29.299    18.210     0.200
    29.962    14.473     0.200
    25.481    32.259     0.200
    25.596    31.794     0.200
    25.595    31.808     0.200
    25.785    28.789     0.200
    27.766    22.923     0.200
    25.769    31.619     0.200
    25.962    29.517     0.200
    19.998    38.904     0.200
    25.830    31.013     0.200
    20.029    38.830     0.200
    23.492    37.934     0.200
    20.125    39.465     0.200
    23.463    38.512     0.200
    23.593    36.377     0.200
    23.764    36.118     0.200
    25.802    32.515     0.200
    26.101    31.642     0.200
    28.002    22.610     0.200
    14.081    45.837     0.200
    20.127    39.406     0.200
    22.393    39.987     0.200
    23.491    38.164     0.200
    23.491    37.273     0.200
    23.623    36.031     0.200
    23.793    35.611     0.200
    24.295    37.085     0.200
    24.329    36.889     0.200
    24.729    36.522     0.200
    25.398    35.615     0.200
    25.622    33.896     0.200
    25.829    32.029     0.200
    25.829    31.431     0.200
    26.131    31.738     0.200
    26.130    31.750     0.200
    26.130    30.723     0.200
    27.478    26.886     0.200
    27.843    25.518     0.200
    28.002    23.175     0.200
    28.002    23.397     0.200
    14.123    42.742     0.200
    14.457    39.942     0.200
    19.543    37.651     0.200
    19.996    39.526     0.200
    20.617    39.554     0.200
    20.792    37.608     0.200
    21.712    38.221     0.200
    21.894    41.049     0.200
    22.377    38.617     0.200
    22.455    39.806     0.200
    22.510    38.870     0.200
    22.864    41.237     0.200
    23.478    37.961     0.200
    23.478    36.762     0.200
    23.540    35.753     0.200
    23.715    35.243     0.200
    23.917    35.767     0.200
    24.194    36.517     0.200
    24.231    36.581     0.200
    24.328    36.743     0.200
    24.426    34.775     0.200
    24.708    36.312     0.200
    25.007    33.520     0.200
    25.249    33.899     0.200
    25.330    33.948     0.200
    25.380    35.869     0.200
    25.559    32.579     0.200
    25.824    31.488     0.200
    25.824    31.086     0.200
    25.917    33.399     0.200
    26.043    29.409     0.200
    26.042    28.842     0.200
    26.938    26.988     0.200
    27.613    25.756     0.200
    27.769    25.990     0.200
    27.876    23.643     0.200
    27.876    23.034     0.200
    18.986    40.564     0.200
    19.971    41.187     0.200
    25.843    33.417     0.200
    26.047    32.063     0.200
    26.046    32.075     0.200
    27.850    23.388     0.200
    23.623    35.263     0.200
    25.453    32.168     0.200
    25.453    31.074     0.200
    25.742    30.253     0.200
    27.716    22.884     0.200
    27.716    23.392     0.200
    14.138    41.864     0.200
    14.419    40.441     0.200
    14.739    40.905     0.200
    14.921    41.729     0.200
    15.104    39.592     0.200
    15.422    39.994     0.200
    15.422    39.451     0.200
    15.619    41.441     0.200
    15.892    39.852     0.200
    16.826    40.852     0.200
    17.310    44.722     0.200
    17.310    42.499     0.200
    18.496    38.304     0.200
    19.922    38.725     0.200
    20.640    38.114     0.200
    20.747    39.003     0.200
    21.259    40.722     0.200
    21.270    39.295     0.200
    21.590    39.055     0.200
    21.629    36.203     0.200
    21.951    38.939     0.200
    22.340    37.303     0.200
    22.577    37.937     0.200
    22.814    37.975     0.200
    22.952    37.256     0.200
    23.340    36.709     0.200
    23.303    38.069     0.200
    23.442    36.339     0.200
    23.442    35.991     0.200
    23.489    36.263     0.200
    23.647    34.870     0.200
    23.665    36.152     0.200
    23.724    36.153     0.200
    23.724    36.024     0.200
    23.929    33.528     0.200
    23.953    32.932     0.200
    23.953    34.510     0.200
    24.183    31.973     0.200
    24.114    34.400     0.200
    24.152    34.861     0.200
    24.183    35.596     0.200
    24.414    33.798     0.200
    24.423    31.489     0.200
    24.583    34.021     0.200
    24.599    35.034     0.200
    24.670    33.913     0.200
    24.814    33.527     0.200
    24.961    33.119     0.200
    25.217    32.428     0.200
    25.310    33.736     0.200
    25.343    34.858     0.200
    25.365    31.304     0.200
    25.512    32.689     0.200
    25.823    30.534     0.200
    25.823    29.331     0.200
    25.790    31.129     0.200
    25.790    30.137     0.200
    25.790    30.590     0.200
    25.845    31.201     0.200
    25.884    31.541     0.200
    25.888    30.197     0.200
    25.991    29.891     0.200
    25.991    29.591     0.200
    25.991    29.911     0.200
    26.534    29.655     0.200
    26.645    30.160     0.200
    26.953    26.475     0.200
    27.644    24.712     0.200
    27.701    21.635     0.200
    27.700    24.056     0.200
    27.700    24.423     0.200
    27.853    23.676     0.200
    27.853    22.364     0.200
    27.853    23.196     0.200
    27.769    24.141     0.200
    27.769    24.442     0.200
    28.188    23.952     0.200
    29.461    17.301     0.200
    29.461    17.993     0.200
    29.461    17.903     0.200
    29.461    18.204     0.200
    29.461    17.677     0.200
    29.462    17.885     0.200
    29.918    16.868     0.200
    29.918    16.661     0.200
    29.918    16.368     0.200
    20.133    39.348     0.200
    23.581    34.817     0.200
    23.751    35.302     0.200
    23.883    33.807     0.200
    25.786    32.306     0.200
    27.476    26.540     0.200
    28.011    22.108     0.200
    23.316    36.218     0.200
    23.328    36.034     0.200
    23.494    35.757     0.200
    25.684    32.336     0.200
    27.764    24.834     0.200
    15.406    40.271     0.200
    17.318    41.466     0.200
    19.546    39.828     0.200
    23.349    36.413     0.200
    23.523    36.450     0.200
    25.255    30.446     0.200
    25.643    30.957     0.200
    14.140    42.852     0.200
    15.111    39.386     0.200
    17.322    40.062     0.200
    21.636    38.042     0.200
    21.844    39.217     0.200
    22.320    36.656     0.200
    22.458    38.748     0.200
    22.579    38.035     0.200
    23.423    35.790     0.200
    23.423    35.030     0.200
    23.465    34.703     0.200
    23.647    31.767     0.200
    23.641    33.532     0.200
    24.130    34.234     0.200
    24.278    34.010     0.200
    24.416    32.375     0.200
    24.650    33.670     0.200
    24.773    33.628     0.200
    24.938    32.710     0.200
    25.199    32.061     0.200
    25.297    32.817     0.200
    25.323    34.216     0.200
    25.344    30.566     0.200
    25.488    32.384     0.200
    25.820    28.843     0.200
    25.771    30.130     0.200
    25.866    31.881     0.200
    25.870    29.134     0.200
    27.653    23.322     0.200
    27.653    24.421     0.200
    27.765    23.916     0.200
    27.848    22.351     0.200
    28.179    22.783     0.200
    29.476    17.643     0.200
    14.098    44.566     0.200
    15.862    43.274     0.200
    17.296    44.190     0.200
    19.997    39.663     0.200
    19.997    40.218     0.200
    20.744    38.704     0.200
    21.614    40.395     0.200
    21.938    37.365     0.200
    22.202    38.386     0.200
    22.275    40.439     0.200
    22.237    40.253     0.200
    22.419    38.470     0.200
    22.795    37.863     0.200
    23.318    37.194     0.200
    23.377    37.382     0.200
    23.377    35.390     0.200
    23.437    36.979     0.200
    23.437    35.455     0.200
    23.611    35.947     0.200
    23.611    35.353     0.200
    23.692    34.745     0.200
    23.704    33.934     0.200
    24.125    35.946     0.200
    24.230    35.619     0.200
    24.367    34.170     0.200
    24.605    35.446     0.200
    24.730    35.685     0.200
    24.769    32.687     0.200
    25.151    33.676     0.200
    25.453    32.843     0.200
    25.724    29.821     0.200
    25.724    30.735     0.200
    25.724    30.001     0.200
    25.818    34.390     0.200
    25.822    30.358     0.200
    25.802    29.177     0.200
    25.861    30.290     0.200
    25.940    29.670     0.200
    27.622    25.198     0.200
    27.716    23.885     0.200
    27.885    24.144     0.200
    27.885    22.722     0.200
    28.129    24.725     0.200
    25.851    28.961     0.200
    20.125    39.114     0.200
    23.770    33.694     0.200
    25.809    30.286     0.200
    25.959    31.674     0.200
    14.128    43.594     0.200
    16.325    42.281     0.200
    23.361    38.372     0.200
    23.599    36.516     0.200
    23.596    36.681     0.200
    25.690    31.296     0.200
    25.690    30.480     0.200
    27.286    28.345     0.200
    19.963    41.160     0.200
    23.597    36.886     0.200
    23.643    37.773     0.200
    25.942    33.389     0.200
    25.942    31.022     0.200
    25.942    32.569     0.200
    26.039    31.434     0.200
    14.461    40.908     0.200
    24.677    33.066     0.200
    22.190    39.230     0.200
    23.274    38.231     0.200
    23.414    35.678     0.200
    23.590    35.548     0.200
    23.991    33.287     0.200
    24.402    32.602     0.200
    25.160    35.747     0.200
    25.731    28.852     0.200
    25.731    32.731     0.200
    25.731    29.012     0.200
    25.815    29.452     0.200
    25.915    29.230     0.200
    27.624    24.934     0.200
    27.672    24.922     0.200
    27.754    23.502     0.200
    27.837    24.474     0.200
    19.356    36.800     0.200
    27.708    23.492     0.200
    27.708    22.577     0.200
    25.460    30.103     0.200
    27.757    22.919     0.200
    15.144    41.524     0.200
    23.749    38.390     0.200
    24.296    39.008     0.200
    24.295    39.813     0.200
    24.406    37.422     0.200
    24.975    36.784     0.200
    25.449    31.474     0.200
    26.297    31.946     0.200
    27.715    24.525     0.200
    25.550    28.396     0.200
    26.131    28.336     0.200
    27.498    23.197     0.200
    23.383    37.250     0.200
    25.733    30.732     0.200
    25.733    33.120     0.200
    27.659    24.500     0.200
    23.556    36.480     0.200
    25.901    30.827     0.200
    27.604    26.171     0.200
    27.773    25.398     0.200
    23.567    36.050     0.200
    23.848    36.545     0.200
    25.906    31.909     0.200
    26.002    32.014     0.200
    27.518    26.323     0.200
    14.547    43.379     0.200
    21.604    40.792     0.200
    22.590    36.078     0.200
    23.435    35.527     0.200
    23.611    35.622     0.200
    24.758    33.942     0.200
    25.752    32.650     0.200
    25.752    31.181     0.200
    25.752    30.820     0.200
    25.808    31.558     0.200
    25.851    31.541     0.200
    25.936    29.385     0.200
    25.935    29.672     0.200
    25.935    29.392     0.200
    27.673    23.809     0.200
    27.767    24.365     0.200
    27.832    24.010     0.200
    27.832    24.950     0.200
    29.503    21.413     0.200
    29.503    20.384     0.200
    25.925    31.206     0.200
    20.866    38.944     0.200
    23.613    35.293     0.200
    23.690    36.033     0.200
    23.866    34.639     0.200
    24.507    33.858     0.200
    25.966    30.730     0.200
    26.190    27.282     0.200
    27.868    24.229     0.200
    14.090    42.795     0.200
    17.254    43.502     0.200
    20.023    39.591     0.200
    23.692    34.823     0.200
    25.789    31.925     0.200
    25.871    29.570     0.200
    26.024    29.832     0.200
    26.024    29.840     0.200
    27.589    26.068     0.200
    27.905    23.584     0.200
    27.905    22.724     0.200
    25.763    32.858     0.200
    27.599    26.223     0.200
    27.899    24.921     0.200
    25.770    31.502     0.200
    27.647    24.779     0.200
    20.091    38.909     0.200
    25.796    28.526     0.200
    27.626    24.259     0.200
    20.040    39.422     0.200
    23.731    36.348     0.200
    25.712    31.073     0.200
    27.580    24.628     0.200
    27.927    23.949     0.200
    14.106    39.637     0.200
    14.421    40.566     0.200
    17.305    41.794     0.200
    19.533    37.124     0.200
    20.741    37.918     0.200
    21.246    39.312     0.200
    21.485    38.926     0.200
    22.431    39.988     0.200
    22.554    37.347     0.200
    23.399    34.122     0.200
    23.452    34.459     0.200
    23.674    32.964     0.200
    23.627    34.061     0.200
    23.948    33.820     0.200
    23.948    34.039     0.200
    24.200    32.381     0.200
    24.200    31.209     0.200
    24.154    32.523     0.200
    24.412    34.371     0.200
    24.388    32.801     0.200
    24.951    31.977     0.200
    25.256    31.726     0.200
    25.339    29.301     0.200
    25.270    30.862     0.200
    25.845    26.433     0.200
    25.747    29.150     0.200
    25.747    29.893     0.200
    25.747    29.783     0.200
    25.845    28.288     0.200
    25.956    29.848     0.200
    25.956    29.050     0.200
    25.955    28.215     0.200
    26.075    32.560     0.200
    26.834    26.007     0.200
    27.290    20.165     0.200
    27.665    22.776     0.200
    27.633    23.565     0.200
    27.633    25.072     0.200
    27.691    23.109     0.200
    27.870    24.003     0.200
    27.870    22.581     0.200
    27.737    22.946     0.200
    27.955    22.826     0.200
    28.151    23.235     0.200
    29.463    18.576     0.200
    29.465    16.753     0.200
    15.148    39.359     0.200
    19.974    38.036     0.200
    22.557    37.571     0.200
    23.674    32.558     0.200
    25.252    32.117     0.200
    25.723    31.378     0.200
    27.634    25.076     0.200
    27.863    24.499     0.200
    27.646    24.634     0.200
    28.328    22.067     0.200
    25.760    34.218     0.200
    24.839    32.649     0.200
    25.325    35.377     0.200
    25.398    33.306     0.200
    25.499    33.853     0.200
    14.146    41.680     0.200
    14.418    40.438     0.200
    15.175    40.980     0.200
    19.472    38.886     0.200
    25.621    32.509     0.200
    25.782    31.347     0.200
    27.716    24.479     0.200
    25.508    31.806     0.200
    25.508    32.005     0.200
    27.313    25.919     0.200
    27.737    23.241     0.200
    25.892    32.861     0.200
    14.570    40.964     0.200
    15.572    43.085     0.200
    17.164    42.977     0.200
    19.648    41.165     0.200
    19.648    39.405     0.200
    19.778    40.887     0.200
    21.656    40.069     0.200
    22.408    40.775     0.200
    23.494    38.291     0.200
    23.602    37.418     0.200
    23.745    35.864     0.200
    23.773    37.339     0.200
    24.262    33.954     0.200
    24.744    35.831     0.200
    24.944    35.542     0.200
    24.944    33.002     0.200
    25.426    33.875     0.200
    26.116    29.723     0.200
    27.390    28.350     0.200
    27.395    25.597     0.200
    27.978    24.234     0.200
    27.978    24.114     0.200
    15.278    40.527     0.200
    17.592    39.063     0.200
    17.576    40.443     0.200
    18.357    35.171     0.200
    19.834    34.684     0.200
    20.011    37.320     0.200
    22.422    35.223     0.200
    22.548    35.354     0.200
    22.912    33.388     0.200
    23.257    35.743     0.200
    23.567    34.421     0.200
    23.894    31.670     0.200
    24.198    31.329     0.200
    24.361    31.133     0.200
    25.191    27.780     0.200
    26.371    28.509     0.200
    26.877    26.389     0.200
    27.338    22.975     0.200
    27.428    21.063     0.200
    28.024    21.316     0.200
    29.352    17.271     0.200
    29.180    19.119     0.200
    29.525    15.855     0.200
    24.450    33.989     0.200
    25.722    30.642     0.200
    25.690    33.140     0.200
    25.690    32.874     0.200
    27.794    24.478     0.200
    14.339    39.721     0.200
    14.364    38.938     0.200
    14.733    39.661     0.200
    14.781    42.863     0.200
    14.942    39.320     0.200
    16.602    40.253     0.200
    17.893    38.984     0.200
    20.541    38.179     0.200
    20.770    38.309     0.200
    22.989    37.112     0.200
    23.120    34.190     0.200
    23.218    36.544     0.200
    23.682    34.930     0.200
    25.182    28.505     0.200
    25.368    29.749     0.200
    25.417    29.953     0.200
    25.417    29.777     0.200
    25.417    30.277     0.200
    25.416    27.866     0.200
    25.416    29.964     0.200
    25.696    29.878     0.200
    25.696    26.398     0.200
    28.420    22.799     0.200
    19.911    38.192     0.200
    24.048    33.637     0.200
    26.363    29.584     0.200
    26.363    26.686     0.200
    27.633    25.266     0.200
    25.331    32.725     0.200
    15.432    40.878     0.200
    20.325    37.792     0.200
    20.841    37.837     0.200
    23.429    33.406     0.200
    23.540    35.740     0.200
    23.968    34.496     0.200
    24.029    32.882     0.200
    24.721    32.555     0.200
    25.030    31.823     0.200
    25.354    29.728     0.200
    25.647    29.023     0.200
    26.190    28.645     0.200
    26.190    29.067     0.200
    26.190    28.363     0.200
    26.287    26.720     0.200
    27.725    22.820     0.200
    27.711    23.908     0.200
    14.037    36.310     0.200
    14.544    38.084     0.200
    14.500    37.304     0.200
    14.571    38.273     0.200
    14.571    40.984     0.200
    14.725    37.075     0.200
    14.837    38.871     0.200
    14.837    39.433     0.200
    15.529    37.489     0.200
    16.710    36.719     0.200
    16.710    40.610     0.200
    16.710    40.977     0.200
    17.306    39.175     0.200
    17.304    37.021     0.200
    17.304    38.084     0.200
    17.304    40.982     0.200
    17.975    37.033     0.200
    18.436    37.232     0.200
    18.436    35.099     0.200
    18.635    38.078     0.200
    19.361    35.178     0.200
    19.477    36.128     0.200
    19.877    34.351     0.200
    21.554    35.277     0.200
    22.411    35.485     0.200
    22.787    33.092     0.200
    22.928    33.245     0.200
    22.954    34.434     0.200
    23.243    30.383     0.200
    23.243    30.766     0.200
    23.243    31.274     0.200
    23.301    34.807     0.200
    23.301    32.783     0.200
    23.301    33.994     0.200
    23.482    30.478     0.200
    23.482    31.088     0.200
    23.736    29.317     0.200
    23.736    31.122     0.200
    23.736    30.669     0.200
    23.920    28.575     0.200
    23.920    29.372     0.200
    23.920    31.169     0.200
    24.014    32.767     0.200
    24.300    29.399     0.200
    24.300    31.829     0.200
    24.488    29.282     0.200
    25.026    27.720     0.200
    25.026    29.360     0.200
    25.197    25.893     0.200
    25.263    27.058     0.200
    25.263    27.800     0.200
    25.263    27.949     0.200
    25.515    25.836     0.200
    25.515    26.594     0.200
    26.084    28.118     0.200
    26.625    23.025     0.200
    26.625    24.400     0.200
    26.651    23.649     0.200
    26.651    23.368     0.200
    26.651    24.602     0.200
    26.753    24.619     0.200
    26.786    24.721     0.200
    26.786    22.823     0.200
    26.746    23.314     0.200
    26.746    26.228     0.200
    26.785    22.869     0.200
    27.231    23.028     0.200
    27.313    21.775     0.200
    27.650    19.562     0.200
    27.580    22.651     0.200
    27.725    19.655     0.200
    27.725    20.671     0.200
    27.783    18.048     0.200
    27.783    18.400     0.200
    27.783    19.892     0.200
    27.783    19.113     0.200
    28.132    17.618     0.200
    28.326    18.950     0.200
    28.481    18.673     0.200
    28.867    17.939     0.200
    29.068    17.295     0.200
    29.212    16.907     0.200
    29.282    14.404     0.200
    29.282    15.592     0.200
    29.282    14.998     0.200
    29.282    14.109     0.200
    29.282    14.648     0.200
    29.377    17.477     0.200
    29.670    14.013     0.200
    29.558    17.844     0.200
    23.539    36.011     0.200
    24.921    32.193     0.200
    25.814    30.540     0.200
    25.992    30.208     0.200
    25.992    29.442     0.200
    25.992    30.368     0.200
    26.098    30.092     0.200
    27.251    24.862     0.200
    19.166    37.731     0.200
    24.396    30.571     0.200
    25.712    31.457     0.200
    27.830    23.483     0.200
    27.830    22.464     0.200
    14.506    39.713     0.200
    17.711    41.312     0.200
    17.727    42.619     0.200
    18.009    40.728     0.200
    18.748    38.804     0.200
    19.156    39.291     0.200
    19.518    38.550     0.200
    23.647    34.369     0.200
    23.771    36.151     0.200
    25.061    32.677     0.200
    25.792    31.161     0.200
    25.823    30.737     0.200
    25.993    30.409     0.200
    27.643    23.951     0.200
    27.853    23.487     0.200
    26.645    26.382     0.200
    27.341    23.516     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.953    11.341     0.200
     7.555    23.128     0.200
    15.766    37.808     0.200
    20.128    40.797     0.200
     1.790     6.412     0.200
     2.711     9.366     0.200
     3.232    12.586     0.200
     3.101    11.119     0.200
     5.022    18.098     0.200
     5.728    23.454     0.200
     5.745    19.259     0.200
     7.417    22.742     0.200
     9.537    23.800     0.200
    14.231    37.231     0.200
    15.790    37.538     0.200
    19.838    43.793     0.200
    19.876    42.354     0.200
    20.225    38.778     0.200
     2.934    10.691     0.200
     7.657    23.577     0.200
     8.075    22.696     0.200
    16.265    36.120     0.200
    19.970    37.983     0.200
     2.887     9.988     0.200
     5.115    18.983     0.200
     5.768    17.361     0.200
     5.920    21.586     0.200
     7.639    24.532     0.200
     8.300    27.821     0.200
     8.617    24.116     0.200
     8.684    28.337     0.200
     9.089    26.309     0.200
    13.294    34.737     0.200
    15.576    32.904     0.200
    16.102    38.573     0.200
    18.889    39.446     0.200
    20.188    38.082     0.200
    20.216    41.259     0.200
    20.216    41.261     0.200
    20.252    41.333     0.200
    20.459    41.418     0.200
     7.753    24.592     0.200
     8.533    25.391     0.200
     5.115    18.387     0.200
     7.652    24.284     0.200
     8.560    23.783     0.200
     9.036    25.839     0.200
     9.323    30.982     0.200
    15.948    38.870     0.200
    18.867    40.708     0.200
    20.198    38.872     0.200
    20.265    44.196     0.200
    20.264    44.098     0.200
    20.301    44.270     0.200
    20.447    41.962     0.200
     2.897     8.732     0.200
     7.603    21.806     0.200
     8.430    20.162     0.200
     8.890    23.790     0.200
    15.880    36.710     0.200
    16.100    35.646     0.200
    18.896    38.622     0.200
     2.799    13.354     0.200
     6.026    24.697     0.200
     7.753    25.543     0.200
     8.715    25.720     0.200
     9.217    27.261     0.200
     2.879    11.860     0.200
     6.010    22.323     0.200
     7.721    24.358     0.200
     2.878     8.601     0.200
     5.990    19.293     0.200
     7.705    23.273     0.200
     2.897    11.997     0.200
     7.694    26.014     0.200
     2.862     9.649     0.200
     5.177    19.431     0.200
     5.865    18.601     0.200
     7.682    22.404     0.200
     8.311    26.162     0.200
    17.033    35.779     0.200
    20.119    44.859     0.200
    20.156    44.632     0.200
     2.828    13.056     0.200
     5.242    18.884     0.200
     5.945    19.674     0.200
     7.733    24.813     0.200
     1.080     1.936     0.200
     3.285    10.210     0.200
     5.117    15.330     0.200
     5.512    17.719     0.200
     5.828    22.035     0.200
     6.277    17.291     0.200
     7.455    21.543     0.200
    17.072    35.710     0.200
     1.883     9.030     0.200
     3.266    14.896     0.200
     5.115    19.822     0.200
     5.512    21.681     0.200
     7.450    27.064     0.200
     7.461    24.933     0.200
     7.986    26.814     0.200
     3.313    15.841     0.200
     5.069    19.949     0.200
     5.465    23.327     0.200
     7.412    25.108     0.200
     7.936    26.995     0.200
     2.375    14.217     0.200
     1.899     8.391     0.200
     2.400    12.548     0.200
     3.225    12.915     0.200
     3.281    13.268     0.200
     5.107    18.951     0.200
     5.504    24.824     0.200
     6.258    22.516     0.200
     7.439    24.736     0.200
     7.451    23.605     0.200
     7.973    26.511     0.200
     9.315    30.848     0.200
    15.152    38.725     0.200
    15.779    39.416     0.200
    19.683    49.650     0.200
     1.830     6.433     0.200
     3.282    15.488     0.200
     7.362    23.879     0.200
    20.978    38.971     0.200
     1.772     7.400     0.200
     5.432    22.692     0.200
     7.420    24.484     0.200
     2.073     8.417     0.200
     3.025    13.311     0.200
     3.704    15.388     0.200
     4.698    16.789     0.200
     5.054    20.635     0.200
     8.058    26.580     0.200
     1.738     9.315     0.200
     2.251    10.827     0.200
     3.067    12.797     0.200
     5.220    18.674     0.200
     6.257    20.570     0.200
     8.130    28.712     0.200
     9.217    28.529     0.200
    10.648    26.335     0.200
    17.159    38.955     0.200
    19.670    45.048     0.200
    19.670    45.849     0.200
    19.707    44.613     0.200
    19.707    45.414     0.200
     2.796     7.531     0.200
     3.317     9.451     0.200
     4.156    11.654     0.200
     4.568    13.849     0.200
     5.044    15.792     0.200
     7.169    19.498     0.200
     7.176    20.415     0.200
     8.639    22.842     0.200
     8.889    24.426     0.200
    10.556    24.973     0.200
    19.057    36.567     0.200
    20.751    39.901     0.200
     1.375     9.115     0.200
     1.916     8.295     0.200
     2.082    11.357     0.200
     2.451    10.556     0.200
     2.468    11.357     0.200
     2.604    13.263     0.200
     3.013    14.388     0.200
     3.099    14.986     0.200
     3.264    16.565     0.200
     3.286    13.305     0.200
     3.312    15.009     0.200
     4.230    20.292     0.200
     5.110    22.028     0.200
     5.126    19.834     0.200
     7.449    24.723     0.200
     1.868     9.051     0.200
     2.376    13.132     0.200
     2.395    11.901     0.200
     2.480    11.411     0.200
     2.591    13.614     0.200
     2.999    13.858     0.200
     3.064    15.600     0.200
     3.271    15.686     0.200
     7.462    25.779     0.200
     1.685     9.085     0.200
     2.064    10.658     0.200
     2.167     9.452     0.200
     2.765    13.476     0.200
     2.736    13.214     0.200
     2.959    12.714     0.200
     1.360    10.562     0.200
     1.839     9.766     0.200
     1.868    11.032     0.200
     2.479    12.899     0.200
     3.455    16.908     0.200
     3.979    14.292     0.200
     8.117    26.508     0.200
     1.363     6.530     0.200
     1.592     8.853     0.200
     1.870     8.310     0.200
     2.260     9.564     0.200
     2.639    12.139     0.200
     2.638    12.646     0.200
     2.814    13.194     0.200
     2.760    12.821     0.200
     3.022    14.166     0.200
     3.915    13.043     0.200
     5.309    21.074     0.200
     1.345     6.336     0.200
     1.893     7.645     0.200
     2.211     9.338     0.200
     2.628    11.069     0.200
     2.689    12.255     0.200
     2.788    11.705     0.200
     2.815    12.082     0.200
     3.074    13.766     0.200
     3.693    17.034     0.200
     3.934    11.931     0.200
     4.695    18.040     0.200
     1.594     9.027     0.200
     1.879     8.092     0.200
     2.277     9.054     0.200
     2.657    11.620     0.200
     2.622    12.626     0.200
     2.834    11.954     0.200
     2.838    10.110     0.200
     2.741    13.638     0.200
     1.668     7.294     0.200
     2.020     9.923     0.200
     2.225     9.803     0.200
     2.309     9.279     0.200
     2.787    12.285     0.200
     3.189    13.125     0.200
     1.211     8.518     0.200
     1.715     8.336     0.200
     1.953    10.329     0.200
     0.864     4.883     0.200
     0.866     4.508     0.200
     1.264     4.936     0.200
     1.557     6.638     0.200
     1.855     8.787     0.200
     2.227     8.990     0.200
     2.333     7.575     0.200
     2.565    10.785     0.200
     2.621    12.453     0.200
     2.870    11.821     0.200
     2.949    10.382     0.200
     1.282     4.911     0.200
     1.402     5.619     0.200
     1.323     8.107     0.200
     1.833     7.616     0.200
     1.876     8.992     0.200
     2.198     9.761     0.200
     2.383     9.103     0.200
     2.663    10.833     0.200
     2.545    11.851     0.200
     2.629    11.090     0.200
     2.866    12.619     0.200
     2.687    11.095     0.200
     2.915    11.734     0.200
     2.927    11.458     0.200
     3.605    13.053     0.200
     3.739    13.205     0.200
     3.744    14.433     0.200
     4.348    15.525     0.200
     4.528    15.321     0.200
     4.892    16.128     0.200
     5.224    18.743     0.200
     5.342    16.632     0.200
     5.584    18.789     0.200
     5.803    20.005     0.200
     5.871    18.313     0.200
     7.567    22.788     0.200
    15.332    33.238     0.200
     1.454     7.660     0.200
     1.825     9.499     0.200
     2.211    11.014     0.200
     2.207    11.065     0.200
     2.367    12.439     0.200
     2.608    11.564     0.200
     2.770    11.940     0.200
     2.797    12.622     0.200
     3.344    15.371     0.200
    14.938    37.573     0.200
     1.681     9.324     0.200
     1.891    10.321     0.200
     1.985    10.981     0.200
     2.078    11.543     0.200
     2.114    10.801     0.200
     2.233    11.385     0.200
     2.368    12.345     0.200
     2.569    11.611     0.200
     2.777    13.097     0.200
     2.941    14.010     0.200
     3.050    14.193     0.200
     3.064    13.176     0.200
     3.571    13.941     0.200
     3.744    15.764     0.200
     4.238    16.022     0.200
     4.666    16.665     0.200
     5.227    20.725     0.200
     6.247    22.352     0.200
     8.667    26.550     0.200
    16.380    36.749     0.200
    16.380    37.608     0.200
     1.722     8.437     0.200
     2.253    10.886     0.200
     2.383    12.259     0.200
     2.489    12.018     0.200
     2.683    13.128     0.200
     2.829    12.299     0.200
     3.118    13.837     0.200
     3.086    13.302     0.200
     3.389    13.762     0.200
     3.715    15.243     0.200
     4.048    15.731     0.200
     4.508    17.206     0.200
     5.127    18.431     0.200
     5.649    19.354     0.200
     5.639    19.937     0.200
     5.917    22.341     0.200
     7.458    25.495     0.200
     1.262     6.902     0.200
     1.406     6.192     0.200
     1.554     8.174     0.200
     1.859     9.988     0.200
     2.007    10.015     0.200
     2.331     9.113     0.200
     2.228    10.183     0.200
     2.405    10.067     0.200
     2.567    11.370     0.200
     2.673    11.316     0.200
     2.625    12.104     0.200
     2.696    11.797     0.200
     2.866    11.548     0.200
     2.787    13.286     0.200
     2.965    12.435     0.200
     2.951    11.620     0.200
     3.279    12.739     0.200
     3.626    13.935     0.200
     4.920    16.730     0.200
     5.240    19.203     0.200
     6.671    23.555     0.200
     1.275     5.421     0.200
     1.390     5.673     0.200
     1.335     7.449     0.200
     1.516     8.583     0.200
     1.888     9.197     0.200
     1.997     9.167     0.200
     2.201     9.711     0.200
     2.373     9.457     0.200
     2.652    11.171     0.200
     2.551    11.023     0.200
     2.640    12.332     0.200
     2.698    11.846     0.200
     2.855    11.730     0.200
     2.929    12.250     0.200
     3.281    12.263     0.200
     3.612    13.982     0.200
     3.741    13.887     0.200
     3.755    14.512     0.200
     4.354    15.757     0.200
     4.536    18.797     0.200
     4.895    16.414     0.200
     5.233    18.452     0.200
     5.344    16.773     0.200
     5.592    21.079     0.200
     5.810    20.358     0.200
     6.666    23.979     0.200
     9.202    25.985     0.200
     1.508     7.816     0.200
     1.508     7.688     0.200
     1.940     9.806     0.200
     1.906     9.691     0.200
     1.906    10.683     0.200
     2.001     9.631     0.200
     2.247    11.033     0.200
     2.502    11.566     0.200
     2.541    10.886     0.200
     2.760    14.382     0.200
     2.886    13.823     0.200
     2.859    12.852     0.200
     3.343    13.563     0.200
     3.404    13.294     0.200
     3.404    13.403     0.200
     3.459    13.130     0.200
     3.470    14.773     0.200
     3.470    14.543     0.200
     3.912    14.980     0.200
     3.912    14.871     0.200
     4.154    16.350     0.200
     4.154    16.010     0.200
     4.577    16.809     0.200
     4.620    16.125     0.200
     4.620    16.016     0.200
     4.999    16.910     0.200
     4.999    16.749     0.200
     5.643    20.862     0.200
     5.643    20.655     0.200
     6.436    20.176     0.200
     6.436    19.945     0.200
     6.586    26.052     0.200
     6.586    23.110     0.200
     7.618    27.622     0.200
     7.618    26.922     0.200
     7.909    26.345     0.200
     8.662    31.339     0.200
     8.744    25.060     0.200
     1.511     8.858     0.200
     1.701     7.303     0.200
     2.233    10.183     0.200
     2.283     9.452     0.200
     2.402    11.215     0.200
     2.487    11.417     0.200
     2.688    13.154     0.200
     2.809    12.292     0.200
     3.387    12.586     0.200
     3.947    14.905     0.200
     4.045    14.959     0.200
     4.513    15.231     0.200
     5.128    18.051     0.200
     1.751     9.575     0.200
     4.029    14.845     0.200
     4.029    13.314     0.200
     4.024    15.937     0.200
    14.825    38.385     0.200
    15.624    39.170     0.200
     1.444     8.576     0.200
     1.862     6.971     0.200
     2.227    10.387     0.200
     2.570    12.076     0.200
     3.387    15.030     0.200
     3.545    15.904     0.200
     3.593    13.953     0.200
     3.982    15.372     0.200
     4.396    16.440     0.200
     5.034    17.420     0.200
     5.581    18.441     0.200
     7.304    23.545     0.200
     8.367    29.345     0.200
     1.493     8.209     0.200
     1.479     9.815     0.200
     1.707     9.931     0.200
     1.894    10.267     0.200
     1.925     9.955     0.200
     1.946    10.230     0.200
     2.301    12.641     0.200
     2.369    11.829     0.200
     2.442    11.499     0.200
     2.453    12.170     0.200
     2.519    10.733     0.200
     2.788    12.646     0.200
     2.842    14.562     0.200
     2.915    14.216     0.200
     3.414    14.490     0.200
     3.506    14.566     0.200
     3.967    16.762     0.200
     4.639    16.723     0.200
     5.006    17.615     0.200
    19.690    40.904     0.200
     1.334     4.762     0.200
     1.358     5.540     0.200
     1.339     7.032     0.200
     1.970     8.766     0.200
     2.017    10.546     0.200
     2.075     9.224     0.200
     2.230     9.465     0.200
     2.418     8.014     0.200
     2.479    10.505     0.200
     2.711    11.278     0.200
     2.817    10.452     0.200
     2.896    12.394     0.200
     2.896    12.031     0.200
     2.896    11.902     0.200
     3.305    13.525     0.200
     3.544    12.285     0.200
     3.700    19.153     0.200
     3.603    12.736     0.200
     3.803    13.494     0.200
     4.265    15.596     0.200
     4.780    15.490     0.200
     5.204    15.883     0.200
     5.735    18.837     0.200
     6.577    22.546     0.200
     6.703    20.062     0.200
     7.582    23.349     0.200
     7.594    22.114     0.200
    15.451    37.495     0.200
    16.094    36.950     0.200
    16.913    38.890     0.200
    19.754    39.838     0.200
    19.879    38.197     0.200
    19.879    38.372     0.200
    20.916    38.173     0.200
     1.258     6.362     0.200
     1.364     5.090     0.200
     1.443     7.476     0.200
     1.657     7.027     0.200
     1.973     9.166     0.200
     2.068     8.634     0.200
     2.228     9.805     0.200
     2.473    10.666     0.200
     2.709    11.770     0.200
     2.762    11.430     0.200
     4.259    15.381     0.200
     5.197    16.073     0.200
     1.129     4.332     0.200
     1.471     7.794     0.200
     1.542     7.040     0.200
     1.785     7.666     0.200
     2.203     7.907     0.200
     2.296     9.327     0.200
     2.663    10.682     0.200
     2.697    11.752     0.200
     2.707    11.045     0.200
     2.792    10.242     0.200
     3.089    11.522     0.200
     3.772    13.879     0.200
     3.816    12.837     0.200
     5.415    16.148     0.200
    15.367    35.639     0.200
     1.230     7.099     0.200
     1.500     6.294     0.200
     2.036     8.881     0.200
     2.496    11.199     0.200
     2.591    11.922     0.200
     2.628    10.865     0.200
     2.766    11.938     0.200
     3.813    14.786     0.200
     2.237    10.062     0.200
     2.435    10.438     0.200
     2.637    12.512     0.200
     3.245    12.237     0.200
     3.404    14.075     0.200
     3.656    14.517     0.200
     4.462    17.224     0.200
    20.425    40.441     0.200
     1.323     6.228     0.200
     1.354     6.995     0.200
     1.456     7.971     0.200
     1.959     9.684     0.200
     2.075    10.375     0.200
     2.216    10.439     0.200
     2.550    11.254     0.200
     2.484    11.490     0.200
     2.753    12.167     0.200
     2.886    10.909     0.200
    19.402    40.325     0.200
     1.196     6.645     0.200
     1.554     8.269     0.200
     1.655     8.352     0.200
     1.712     7.692     0.200
     1.881     8.764     0.200
     1.802     9.072     0.200
     2.286     9.716     0.200
     2.692    11.000     0.200
     2.754    12.524     0.200
     2.950    11.854     0.200
     1.654     8.785     0.200
     1.804     9.370     0.200
     1.754     8.793     0.200
     1.888     9.062     0.200
     2.002     9.575     0.200
     2.145    10.556     0.200
     2.155    10.171     0.200
     2.465    12.140     0.200
     2.511    11.168     0.200
     2.577    11.791     0.200
     2.603    10.978     0.200
     3.311    12.473     0.200
     3.563    13.319     0.200
     4.192    14.675     0.200
     4.192    13.916     0.200
     4.584    15.149     0.200
     1.064     5.634     0.200
     1.220     6.324     0.200
     1.621     6.367     0.200
     1.520     6.865     0.200
     1.889     8.063     0.200
     2.134     8.404     0.200
     2.666    11.454     0.200
     2.611    10.491     0.200
     2.732     9.769     0.200
     2.762    10.870     0.200
     3.658    13.215     0.200
     4.325    13.500     0.200
     8.350    24.020     0.200
    18.025    39.413     0.200
    19.328    38.813     0.200
     1.058     7.655     0.200
     1.378     6.855     0.200
     1.639     8.783     0.200
     1.713     8.475     0.200
     1.848     9.282     0.200
     1.817     8.528     0.200
     2.066    10.150     0.200
     2.428     9.308     0.200
     2.366    11.182     0.200
     2.901    10.698     0.200
     3.082    12.763     0.200
     3.135    12.193     0.200
     3.586    12.490     0.200
     4.777    16.555     0.200
     1.720     7.630     0.200
     2.259     9.898     0.200
     2.456    10.384     0.200
     1.355     7.103     0.200
     1.362     7.251     0.200
     1.381     7.519     0.200
     1.482     6.088     0.200
     1.974     7.029     0.200
     2.255    10.410     0.200
     2.718     9.778     0.200
     2.785    10.346     0.200
     2.816    10.787     0.200
     3.002    12.529     0.200
     3.040    12.290     0.200
     3.737    14.989     0.200
     3.887    13.420     0.200
     4.045    15.082     0.200
     1.597     8.521     0.200
     1.817     8.596     0.200
     2.148     8.886     0.200
     2.171    11.065     0.200
     2.077    10.904     0.200
     2.559    11.334     0.200
     2.657    11.176     0.200
     2.862    11.191     0.200
     3.062    11.501     0.200
     3.204    12.959     0.200
     3.204    13.134     0.200
     3.117    12.434     0.200
     3.142    13.055     0.200
     3.404    11.844     0.200
     3.670    13.203     0.200
     3.667    13.815     0.200
     3.828    15.774     0.200
     4.126    14.310     0.200
     4.133    17.285     0.200
     4.268    15.633     0.200
     4.308    14.776     0.200
     4.718    16.086     0.200
     4.842    18.293     0.200
     5.157    19.907     0.200
     5.157    22.677     0.200
     5.212    21.865     0.200
     5.235    16.162     0.200
     5.315    19.316     0.200
     6.356    19.913     0.200
     6.256    21.590     0.200
     6.275    22.180     0.200
     7.318    26.660     0.200
     8.345    27.443     0.200
     8.359    29.941     0.200
     8.648    24.199     0.200
     9.273    30.073     0.200
     9.599    27.462     0.200
     9.661    26.346     0.200
     9.661    23.926     0.200
    10.951    29.837     0.200
    11.028    28.085     0.200
    11.008    32.618     0.200
    12.036    26.722     0.200
    12.189    28.441     0.200
    12.330    34.388     0.200
    12.898    31.840     0.200
    13.179    32.853     0.200
    13.151    32.207     0.200
    13.411    30.177     0.200
    13.537    36.503     0.200
    13.711    35.769     0.200
    13.886    35.344     0.200
    14.038    35.959     0.200
    14.125    32.745     0.200
    14.113    37.214     0.200
    14.377    34.844     0.200
    14.506    36.994     0.200
    14.745    38.216     0.200
    14.898    38.925     0.200
    15.140    36.898     0.200
    15.140    33.788     0.200
    15.180    36.273     0.200
    15.364    37.788     0.200
    15.427    36.593     0.200
    15.427    37.879     0.200
    15.480    38.434     0.200
    15.406    35.943     0.200
    15.444    37.750     0.200
    15.625    38.543     0.200
    15.536    37.307     0.200
    15.825    39.505     0.200
    16.019    37.302     0.200
    17.303    39.271     0.200
    18.509    41.087     0.200
    18.509    40.097     0.200
    18.682    40.866     0.200
    18.791    39.892     0.200
    18.888    41.457     0.200
    18.888    41.617     0.200
    19.187    41.977     0.200
    19.535    41.808     0.200
    19.629    41.113     0.200
    19.802    41.699     0.200
    19.847    39.670     0.200
    19.919    40.730     0.200
    19.986    40.449     0.200
    20.303    40.345     0.200
    20.295    40.840     0.200
    20.449    42.444     0.200
    20.603    41.549     0.200
    20.682    39.521     0.200
    20.743    41.217     0.200
    20.743    38.557     0.200
    20.918    42.277     0.200
     1.639     8.157     0.200
     3.171    11.808     0.200
     8.677    25.922     0.200
    13.187    29.486     0.200
    13.911    33.216     0.200
    15.422    36.547     0.200
    15.573    36.641     0.200
    14.782    34.539     0.200
    15.561    37.258     0.200
    18.895    41.140     0.200
    20.112    38.652     0.200
     3.247    13.317     0.200
    14.465    36.227     0.200
    15.462    39.855     0.200
    18.862    42.335     0.200
     3.269    13.504     0.200
    15.065    35.429     0.200
    19.826    40.982     0.200
     3.249    11.585     0.200
    20.098    40.256     0.200
     1.965     9.603     0.200
     2.782    12.298     0.200
     3.247    11.978     0.200
     3.247    10.403     0.200
     8.430    24.643     0.200
     9.666    25.663     0.200
    20.580    40.213     0.200
     1.634     9.156     0.200
     1.793     8.890     0.200
     2.066    11.320     0.200
     2.290    10.226     0.200
     2.568    10.570     0.200
     2.663    11.615     0.200
     3.108    13.078     0.200
     3.235    13.149     0.200
     3.235    13.719     0.200
     3.134    14.117     0.200
     3.836    16.458     0.200
     4.110    16.168     0.200
     4.339    15.265     0.200
     4.816    18.610     0.200
     5.142    20.685     0.200
     6.411    22.219     0.200
     8.749    25.404     0.200
     9.705    25.782     0.200
    11.034    33.369     0.200
    11.075    30.086     0.200
    11.098    33.125     0.200
    12.098    27.256     0.200
    12.435    37.123     0.200
    12.917    33.267     0.200
    13.467    30.981     0.200
    13.632    37.650     0.200
    13.656    32.840     0.200
    13.990    35.596     0.200
    14.082    37.303     0.200
    14.056    34.416     0.200
    14.316    34.223     0.200
    14.837    34.627     0.200
    15.162    35.851     0.200
    15.520    38.060     0.200
    15.520    37.016     0.200
    16.122    36.188     0.200
    18.591    41.184     0.200
    18.778    39.798     0.200
    18.766    40.942     0.200
    19.609    42.598     0.200
    19.724    43.056     0.200
    19.944    39.489     0.200
    20.020    41.708     0.200
    20.288    40.380     0.200
    20.243    42.303     0.200
    20.400    42.970     0.200
    20.845    41.280     0.200
     3.105    13.010     0.200
     3.169    13.624     0.200
     3.168    15.849     0.200
     8.592    26.580     0.200
    13.826    35.239     0.200
    18.446    40.131     0.200
    13.812    33.151     0.200
    14.213    35.811     0.200
    15.347    34.975     0.200
    17.387    36.133     0.200
    19.892    40.553     0.200
    20.597    38.796     0.200
     1.572     8.785     0.200
     1.841     9.304     0.200
     2.531    11.703     0.200
     3.089    12.291     0.200
     3.211    13.974     0.200
     3.211    11.474     0.200
     3.211     9.914     0.200
     3.130    13.322     0.200
     4.284    14.767     0.200
     8.613    24.970     0.200
     9.662    24.921     0.200
     9.662    24.081     0.200
    10.936    32.331     0.200
    10.990    33.620     0.200
    11.029    32.573     0.200
    12.031    27.676     0.200
    12.303    35.605     0.200
    12.908    33.590     0.200
    13.152    34.186     0.200
    13.408    29.902     0.200
    13.516    36.739     0.200
    13.852    36.428     0.200
    13.852    32.458     0.200
    14.040    35.932     0.200
    14.125    33.942     0.200
    14.403    37.098     0.200
    14.903    36.265     0.200
    15.149    38.142     0.200
    15.407    38.417     0.200
    15.407    37.173     0.200
    16.324    38.675     0.200
    18.495    41.144     0.200
    18.495    40.704     0.200
    18.811    40.453     0.200
    18.860    42.881     0.200
    18.860    40.281     0.200
    19.608    40.352     0.200
    19.894    39.012     0.200
    19.974    38.826     0.200
    19.974    39.276     0.200
    20.175    44.534     0.200
    20.717    40.010     0.200
    20.717    39.520     0.200
    20.891    39.279     0.200
     2.258    11.696     0.200
     3.248    16.055     0.200
     3.248    12.735     0.200
     8.758    25.457     0.200
    11.049    31.059     0.200
    12.928    34.187     0.200
    14.000    35.195     0.200
    15.173    37.338     0.200
    15.535    38.006     0.200
    15.535    36.717     0.200
    15.511    35.888     0.200
    17.198    39.803     0.200
    20.077    40.285     0.200
    20.671    40.700     0.200
     3.281    13.438     0.200
     8.842    25.163     0.200
    13.386    31.343     0.200
    20.145    41.232     0.200
     1.804     9.497     0.200
     2.048    11.229     0.200
     2.283    10.927     0.200
     2.319    10.687     0.200
     2.528    12.951     0.200
     2.702    12.865     0.200
     3.114    13.434     0.200
     3.263    11.524     0.200
     8.778    23.350     0.200
     9.736    25.129     0.200
    11.073    31.913     0.200
    11.073    28.573     0.200
    11.137    32.961     0.200
    12.133    28.346     0.200
    12.941    33.662     0.200
    13.672    36.083     0.200
    14.021    33.562     0.200
    15.560    37.260     0.200
    18.805    41.785     0.200
    18.938    43.624     0.200
    18.938    40.394     0.200
    19.647    41.459     0.200
    20.100    39.944     0.200
    20.100    40.069     0.200
    20.747    39.622     0.200
     1.646    10.379     0.200
     2.312    11.907     0.200
     3.125    14.494     0.200
    14.285    33.632     0.200
    20.099    40.824     0.200
     1.062     8.609     0.200
     1.659    10.800     0.200
     1.763     8.366     0.200
     1.763     9.826     0.200
     2.091    10.804     0.200
     2.104    11.026     0.200
     2.249    11.534     0.200
     2.605    11.317     0.200
     2.605    11.447     0.200
     2.636    13.568     0.200
     2.815    13.445     0.200
     3.170    14.283     0.200
     3.170    14.473     0.200
     3.195    16.082     0.200
     3.195    13.283     0.200
     3.189    13.997     0.200
     3.189    14.177     0.200
     3.648    16.668     0.200
     4.149    16.037     0.200
     4.268    16.539     0.200
     4.367    16.431     0.200
     4.367    17.681     0.200
     4.856    19.455     0.200
     5.179    22.432     0.200
     6.370    20.066     0.200
     8.473    27.723     0.200
     8.740    26.434     0.200
     8.740    27.354     0.200
     9.207    31.754     0.200
     9.308    32.078     0.200
     9.664    27.925     0.200
     9.664    26.145     0.200
     9.652    29.165     0.200
    10.995    29.386     0.200
    10.995    29.736     0.200
    11.034    30.031     0.200
    11.061    35.522     0.200
    12.056    28.302     0.200
    12.407    37.215     0.200
    12.879    34.807     0.200
    13.597    39.124     0.200
    13.645    34.561     0.200
    13.977    39.092     0.200
    13.977    34.922     0.200
    14.097    34.377     0.200
    14.133    34.970     0.200
    14.133    37.970     0.200
    14.481    39.302     0.200
    14.878    38.040     0.200
    15.123    39.729     0.200
    15.441    37.224     0.200
    15.479    40.457     0.200
    15.484    40.594     0.200
    15.484    35.600     0.200
    15.485    38.376     0.200
    16.110    39.338     0.200
    18.551    43.605     0.200
    18.727    43.358     0.200
    18.959    43.952     0.200
    19.569    42.533     0.200
    19.689    42.929     0.200
    19.910    41.951     0.200
    19.988    42.043     0.200
    20.022    41.844     0.200
    20.256    41.516     0.200
    20.267    44.984     0.200
    20.633    41.360     0.200
    20.697    41.168     0.200
    20.814    43.203     0.200
     2.344    10.997     0.200
     2.450    12.885     0.200
     3.129    13.787     0.200
     3.297    14.056     0.200
     8.473    24.600     0.200
     2.000    11.070     0.200
     2.315    10.283     0.200
     3.268    12.367     0.200
     8.513    24.352     0.200
    10.925    32.100     0.200
    10.925    28.350     0.200
    12.051    28.759     0.200
    13.483    37.351     0.200
    13.757    35.276     0.200
    15.377    37.070     0.200
    17.345    38.743     0.200
    18.485    40.553     0.200
    18.654    41.901     0.200
    18.900    41.431     0.200
    19.528    42.408     0.200
    19.528    39.778     0.200
    19.573    43.275     0.200
    19.785    40.902     0.200
    19.974    39.952     0.200
    19.974    40.102     0.200
    20.485    40.431     0.200
    20.664    41.342     0.200
     2.023    11.001     0.200
     2.314    10.538     0.200
    20.048    40.364     0.200
     1.590     8.061     0.200
     2.090    10.940     0.200
     2.107     9.167     0.200
     2.236    10.006     0.200
     2.515    12.082     0.200
     3.141    13.026     0.200
     3.104    13.465     0.200
     3.186    12.257     0.200
     3.186    10.422     0.200
     3.153    15.674     0.200
     3.832    15.434     0.200
     4.859    17.069     0.200
     8.610    24.859     0.200
     9.559    26.537     0.200
    10.913    29.038     0.200
    10.913    28.668     0.200
    12.006    29.186     0.200
    12.884    32.116     0.200
    13.383    31.015     0.200
    13.496    35.297     0.200
    13.846    35.735     0.200
    14.015    34.246     0.200
    14.382    36.757     0.200
    14.928    35.402     0.200
    18.471    40.203     0.200
    18.644    41.020     0.200
    18.875    44.325     0.200
    19.950    40.324     0.200
    19.950    39.874     0.200
    20.566    40.387     0.200
    20.700    39.431     0.200
     3.278    10.372     0.200
     8.250    20.880     0.200
     1.593     8.087     0.200
     1.818     9.671     0.200
     2.083    12.015     0.200
     2.219    10.582     0.200
     2.492    12.451     0.200
     2.855    13.850     0.200
     4.875    19.674     0.200
    14.163    37.343     0.200
     1.380     7.397     0.200
     1.380     7.827     0.200
     1.927     9.903     0.200
     2.065    10.604     0.200
     2.252    11.003     0.200
     2.840    11.785     0.200
     3.057    14.027     0.200
     3.234    12.527     0.200
     3.265     9.844     0.200
     3.332    13.441     0.200
     3.680    14.468     0.200
     3.781    13.722     0.200
     4.086    14.560     0.200
     8.272    22.101     0.200
     8.749    28.395     0.200
     9.133    26.308     0.200
     9.387    26.839     0.200
     9.653    26.438     0.200
     9.653    23.268     0.200
    10.796    30.498     0.200
    10.935    24.745     0.200
    11.956    29.858     0.200
    12.980    34.335     0.200
    13.295    35.743     0.200
    13.356    30.424     0.200
    13.514    35.778     0.200
    13.514    32.958     0.200
    13.775    33.932     0.200
    14.096    33.594     0.200
    15.195    34.071     0.200
    15.214    37.043     0.200
    15.214    33.823     0.200
    15.484    37.390     0.200
    15.647    36.746     0.200
    18.498    43.119     0.200
    18.605    44.573     0.200
    18.978    40.514     0.200
    19.190    40.747     0.200
    19.383    41.289     0.200
    19.399    41.609     0.200
    19.838    39.352     0.200
    19.838    40.177     0.200
    20.324    42.212     0.200
    20.451    40.628     0.200
    20.618    42.183     0.200
    20.883    38.713     0.200
    20.883    39.088     0.200
    20.927    40.078     0.200
     1.861     9.620     0.200
     2.236    10.524     0.200
     2.081    10.619     0.200
     2.894    12.672     0.200
     3.188    15.041     0.200
     3.188    15.173     0.200
     3.188    11.541     0.200
     3.432    13.818     0.200
     4.148    16.650     0.200
     4.653    15.145     0.200
     4.858    19.955     0.200
     8.538    23.826     0.200
     9.512    31.266     0.200
     9.627    26.228     0.200
     9.627    24.938     0.200
    10.872    28.608     0.200
    10.921    34.622     0.200
    10.991    31.808     0.200
    11.983    29.136     0.200
    12.891    35.430     0.200
    13.072    31.617     0.200
    13.364    32.010     0.200
    13.444    38.286     0.200
    13.774    37.133     0.200
    13.774    34.003     0.200
    14.164    34.764     0.200
    14.330    38.338     0.200
    14.952    37.900     0.200
    15.131    35.302     0.200
    15.336    35.105     0.200
    15.907    37.259     0.200
    16.424    36.703     0.200
    18.431    42.482     0.200
    18.602    42.088     0.200
    18.826    43.875     0.200
    19.467    43.692     0.200
    19.535    41.502     0.200
    19.750    40.390     0.200
    19.817    43.608     0.200
    19.915    39.965     0.200
    19.915    40.166     0.200
    20.147    45.458     0.200
    20.333    41.184     0.200
    20.639    43.015     0.200
    20.812    42.392     0.200
     2.076    10.864     0.200
     3.231    10.686     0.200
    15.402    37.751     0.200
     1.593     8.008     0.200
     1.821     9.651     0.200
     2.075    10.486     0.200
     2.147    10.735     0.200
     2.257    11.015     0.200
     2.556    12.436     0.200
     2.658    11.679     0.200
     3.162    14.299     0.200
     3.206    10.662     0.200
     3.140    14.728     0.200
     4.840    20.300     0.200
     8.645    26.455     0.200
    10.950    30.078     0.200
    10.950    29.028     0.200
    12.037    30.300     0.200
    13.150    30.861     0.200
    13.412    34.351     0.200
    13.536    36.203     0.200
    13.883    36.068     0.200
    16.016    39.457     0.200
    18.681    40.058     0.200
    18.885    44.985     0.200
    18.885    41.016     0.200
    19.986    40.385     0.200
    20.741    39.755     0.200
     1.584     8.824     0.200
     1.829     8.955     0.200
     2.129     9.497     0.200
     2.075    10.702     0.200
     2.196    11.116     0.200
     2.252     9.993     0.200
     2.535    11.930     0.200
     2.675    11.196     0.200
     3.057    12.477     0.200
     3.101    12.137     0.200
     3.203    14.257     0.200
     3.203    14.507     0.200
     3.203    11.672     0.200
     3.139    14.061     0.200
     3.393    13.508     0.200
     4.122    14.358     0.200
     4.296    15.088     0.200
     5.155    21.926     0.200
     6.348    17.413     0.200
     8.623    21.677     0.200
     9.581    25.775     0.200
     9.655    24.712     0.200
     9.655    25.341     0.200
    10.935    30.778     0.200
    10.935    26.968     0.200
    10.990    30.631     0.200
    11.022    27.361     0.200
    12.026    28.342     0.200
    12.899    34.033     0.200
    13.403    30.578     0.200
    13.518    36.337     0.200
    13.719    30.994     0.200
    13.861    32.184     0.200
    14.033    34.324     0.200
    14.118    32.526     0.200
    14.122    34.262     0.200
    14.404    37.297     0.200
    14.726    38.140     0.200
    14.908    34.082     0.200
    15.140    36.099     0.200
    15.140    34.988     0.200
    15.408    37.176     0.200
    15.994    36.042     0.200
    17.321    37.213     0.200
    18.493    39.674     0.200
    18.493    39.113     0.200
    18.666    39.559     0.200
    18.872    42.447     0.200
    19.522    39.867     0.200
    19.609    39.848     0.200
    19.972    39.842     0.200
    19.972    39.417     0.200
    20.187    42.702     0.200
    20.692    38.464     0.200
    20.692    40.414     0.200
    20.720    39.880     0.200
     1.564     8.019     0.200
     1.564     9.179     0.200
     1.852    10.477     0.200
     2.038    11.041     0.200
     2.176    10.124     0.200
     2.176    11.564     0.200
     2.577    12.524     0.200
     3.089    12.756     0.200
     3.103    13.551     0.200
     3.790    16.401     0.200
     4.690    15.380     0.200
    20.021    41.931     0.200
     1.656     7.250     0.200
     2.337     8.760     0.200
     2.342     9.959     0.200
     2.761    11.032     0.200
     3.110    14.261     0.200
     3.200    11.606     0.200
     4.804    14.654     0.200
     8.834    25.880     0.200
    18.965    40.143     0.200
    20.144    40.248     0.200
     2.118     9.317     0.200
     2.723    11.097     0.200
     3.182    12.774     0.200
    18.893    40.161     0.200
    19.922    38.732     0.200
     3.204     9.202     0.200
     8.245    21.820     0.200
    19.766    40.871     0.200
     1.603     8.467     0.200
     1.809     8.722     0.200
     2.125    10.293     0.200
     2.093    10.193     0.200
     2.537    11.568     0.200
     2.681     9.663     0.200
     2.851    11.843     0.200
     3.042    11.860     0.200
     3.042    12.270     0.200
     3.186    14.615     0.200
     3.186    14.189     0.200
     3.186    10.675     0.200
     3.120    12.393     0.200
     3.158    13.379     0.200
     3.381    13.378     0.200
     3.517    12.988     0.200
     3.690    13.657     0.200
     3.840    15.134     0.200
     4.106    14.569     0.200
     4.316    14.971     0.200
     4.720    14.972     0.200
     4.860    17.587     0.200
     5.173    22.710     0.200
     5.329    19.808     0.200
     6.334    19.406     0.200
     8.634    23.395     0.200
     9.249    26.187     0.200
     9.576    25.980     0.200
     9.640    23.925     0.200
     9.640    23.524     0.200
    10.927    30.705     0.200
    10.927    26.745     0.200
    11.008    27.868     0.200
    10.985    30.135     0.200
    12.014    27.424     0.200
    12.881    34.702     0.200
    13.390    31.271     0.200
    13.514    35.319     0.200
    13.823    35.513     0.200
    13.870    38.862     0.200
    13.870    32.352     0.200
    14.135    35.053     0.200
    14.721    38.033     0.200
    14.920    37.080     0.200
    15.123    35.340     0.200
    15.123    35.509     0.200
    15.340    37.805     0.200
    15.404    34.765     0.200
    15.460    34.907     0.200
    15.406    34.384     0.200
    15.465    35.125     0.200
    16.003    36.527     0.200
    16.467    39.462     0.200
    17.326    38.208     0.200
    18.485    40.103     0.200
    18.780    39.762     0.200
    18.892    42.063     0.200
    19.167    38.951     0.200
    19.606    40.129     0.200
    19.824    40.184     0.200
    19.896    40.638     0.200
    19.963    39.714     0.200
    20.207    42.215     0.200
    20.274    40.633     0.200
    20.672    38.580     0.200
    20.720    40.522     0.200
    20.895    41.478     0.200
     0.842     7.290     0.200
     1.526     8.255     0.200
     2.061    11.172     0.200
     2.254    10.647     0.200
     2.442    12.054     0.200
     3.045    14.869     0.200
     4.626    14.939     0.200
    14.562    33.988     0.200
    15.302    33.151     0.200
    19.921    40.410     0.200
     1.519     8.197     0.200
     1.904     8.477     0.200
     1.972     9.762     0.200
     2.092     9.689     0.200
     2.352    12.000     0.200
     2.830    11.539     0.200
     3.174    14.356     0.200
     3.174    13.346     0.200
     3.148    13.638     0.200
     3.300    13.989     0.200
     3.798    16.813     0.200
     4.075    14.240     0.200
     4.878    16.221     0.200
     6.267    20.984     0.200
     8.437    23.676     0.200
     9.138    27.680     0.200
     9.431    28.558     0.200
     9.595    26.153     0.200
    10.798    31.507     0.200
    10.798    29.116     0.200
    10.840    29.713     0.200
    11.932    28.875     0.200
    13.357    34.550     0.200
    13.671    34.365     0.200
    13.973    36.661     0.200
    15.251    36.744     0.200
    18.358    39.278     0.200
    18.527    41.409     0.200
    18.771    43.662     0.200
    19.447    40.772     0.200
    19.848    40.792     0.200
    20.543    40.481     0.200
     1.482     9.240     0.200
     1.506     8.358     0.200
     1.783    10.037     0.200
     1.921    10.394     0.200
     1.958     9.414     0.200
     2.088    10.747     0.200
     2.225    10.466     0.200
     2.334    12.297     0.200
     3.143    14.692     0.200
     3.178    14.600     0.200
     4.078    15.161     0.200
     8.414    24.325     0.200
    10.788    31.377     0.200
    19.840    41.104     0.200
     1.794     9.503     0.200
     2.047    10.829     0.200
     2.336    11.132     0.200
     2.328     8.949     0.200
     2.487    11.112     0.200
     3.114    13.688     0.200
     3.199    13.635     0.200
     3.278    14.709     0.200
     4.180    12.707     0.200
     8.827    24.246     0.200
    11.112    30.006     0.200
    14.071    35.243     0.200
    15.604    37.836     0.200
    18.964    41.487     0.200
     1.833    10.476     0.200
     2.009    11.298     0.200
     2.340    12.113     0.200
     2.370    11.448     0.200
     2.470    11.751     0.200
     3.075    14.326     0.200
     3.163    13.773     0.200
     3.313    13.502     0.200
     3.313    15.878     0.200
     3.313    13.332     0.200
     3.313    13.771     0.200
     4.246    16.613     0.200
     8.810    25.944     0.200
     9.789    28.659     0.200
     9.789    28.069     0.200
     9.787    30.179     0.200
    11.132    34.285     0.200
    11.132    34.504     0.200
    11.196    34.836     0.200
    12.189    29.340     0.200
    13.730    36.368     0.200
    14.057    37.654     0.200
    16.439    39.152     0.200
    18.688    42.401     0.200
    18.688    42.212     0.200
    18.863    42.455     0.200
    18.927    43.916     0.200
    18.927    42.486     0.200
    19.705    42.935     0.200
    19.705    42.146     0.200
    20.225    45.773     0.200
    20.938    40.441     0.200
     1.847     9.454     0.200
     2.025    10.063     0.200
     3.246    14.872     0.200
     3.246    13.477     0.200
     8.318    21.523     0.200
     9.644    25.878     0.200
    10.786    28.072     0.200
    14.466    34.856     0.200
    15.195    37.873     0.200
    18.347    39.468     0.200
     3.231     9.321     0.200
     8.392    26.338     0.200
    10.819    29.060     0.200
     0.913     8.788     0.200
     1.616     9.058     0.200
     2.098    11.502     0.200
     3.176    12.625     0.200
     4.870    20.088     0.200
     8.594    21.957     0.200
     9.624    24.165     0.200
     1.665     9.595     0.200
     2.077    11.763     0.200
     2.296    10.460     0.200
     2.281    12.001     0.200
     2.534    12.957     0.200
     2.709    13.745     0.200
     3.239    16.091     0.200
     4.817    21.030     0.200
     3.004    12.860     0.200
     3.129    15.712     0.200
     3.129    12.814     0.200
     3.129    12.077     0.200
     4.332    15.854     0.200
     4.923    17.472     0.200
     5.247    20.829     0.200
     6.310    21.700     0.200
     8.418    27.299     0.200
     8.758    26.103     0.200
     9.257    30.405     0.200
     9.216    29.293     0.200
     9.600    25.400     0.200
     9.612    30.066     0.200
    10.496    27.581     0.200
    10.972    27.896     0.200
    10.950    33.353     0.200
    11.021    34.225     0.200
    11.999    28.311     0.200
    12.811    32.430     0.200
    13.195    34.101     0.200
    13.365    34.564     0.200
    13.563    38.262     0.200
    13.704    35.150     0.200
    13.758    35.784     0.200
    13.977    37.724     0.200
    14.071    34.630     0.200
    13.988    38.598     0.200
    13.988    36.668     0.200
    14.157    36.761     0.200
    14.415    37.136     0.200
    15.055    37.840     0.200
    15.055    35.701     0.200
    14.937    37.578     0.200
    15.415    38.245     0.200
    15.448    38.063     0.200
    15.504    38.621     0.200
    15.642    39.601     0.200
    15.537    39.110     0.200
    15.627    38.858     0.200
    16.198    37.501     0.200
    16.122    38.943     0.200
    18.505    42.884     0.200
    18.682    42.721     0.200
    19.017    42.910     0.200
    19.517    42.973     0.200
    19.517    39.832     0.200
    19.655    43.164     0.200
    19.879    41.955     0.200
    19.972    40.569     0.200
    19.962    42.283     0.200
    20.189    41.327     0.200
    20.567    40.017     0.200
    20.591    41.359     0.200
    20.328    44.512     0.200
    20.644    45.119     0.200
    20.702    40.847     0.200
    20.790    44.016     0.200
     1.383     7.382     0.200
     1.541     8.496     0.200
     1.858     9.212     0.200
     1.949     9.660     0.200
     2.055    10.716     0.200
     2.003    10.045     0.200
     2.278    10.852     0.200
     2.318    10.509     0.200
     2.482    11.640     0.200
     2.869    11.466     0.200
     2.851    11.587     0.200
     3.077    12.808     0.200
     3.051    11.838     0.200
     3.270    14.651     0.200
     3.270    12.722     0.200
     3.260    14.017     0.200
     3.661    15.062     0.200
     3.679    14.081     0.200
     3.783    14.849     0.200
     3.815    13.614     0.200
     4.084    15.045     0.200
     4.091    14.210     0.200
     4.279    15.071     0.200
     4.797    17.973     0.200
     5.077    18.571     0.200
     7.013    24.622     0.200
     7.350    22.936     0.200
     7.527    25.909     0.200
     8.298    21.897     0.200
     9.152    28.044     0.200
     9.410    26.732     0.200
     9.664    25.970     0.200
     9.664    25.440     0.200
    10.793    27.896     0.200
    10.819    30.990     0.200
    11.019    31.150     0.200
    11.972    29.336     0.200
    12.897    33.036     0.200
    12.897    30.495     0.200
    12.985    30.912     0.200
    13.208    31.347     0.200
    13.318    35.417     0.200
    13.370    32.019     0.200
    13.541    36.224     0.200
    13.541    32.984     0.200
    13.728    32.854     0.200
    13.761    33.847     0.200
    14.108    34.408     0.200
    14.209    36.628     0.200
    14.173    34.256     0.200
    14.453    34.181     0.200
    14.539    37.977     0.200
    14.971    34.635     0.200
    15.102    35.504     0.200
    15.219    38.138     0.200
    15.219    36.028     0.200
    15.218    38.494     0.200
    15.218    35.951     0.200
    15.445    35.545     0.200
    15.455    35.938     0.200
    15.673    37.183     0.200
    15.664    35.440     0.200
    15.843    37.753     0.200
    16.262    38.361     0.200
    17.500    38.472     0.200
    18.355    40.540     0.200
    18.355    38.979     0.200
    18.519    40.225     0.200
    18.617    42.389     0.200
    19.417    39.845     0.200
    19.417    39.286     0.200
    19.407    40.062     0.200
    19.662    39.387     0.200
    19.858    39.856     0.200
    19.949    43.040     0.200
    20.005    40.182     0.200
    20.195    41.264     0.200
    20.270    39.492     0.200
    20.349    39.369     0.200
    20.493    39.785     0.200
    20.477    38.880     0.200
    20.644    40.132     0.200
    20.953    40.720     0.200
     1.265     8.341     0.200
     1.559     8.946     0.200
     1.555     8.463     0.200
     1.859     8.682     0.200
     2.040    10.171     0.200
     2.156     9.444     0.200
     2.180    11.106     0.200
     2.289    10.023     0.200
     2.554    10.924     0.200
     2.647    10.863     0.200
     3.093    12.459     0.200
     3.077    11.747     0.200
     3.104    13.638     0.200
     3.239    13.474     0.200
     3.239    13.849     0.200
     3.239    13.343     0.200
     3.536    13.803     0.200
     3.648    13.465     0.200
     3.788    15.111     0.200
     4.097    14.357     0.200
     4.267    14.956     0.200
     4.807    18.120     0.200
     6.383    20.009     0.200
     8.469    25.367     0.200
     8.624    24.011     0.200
     9.610    30.452     0.200
     9.691    25.004     0.200
     9.691    25.164     0.200
    10.966    28.659     0.200
    11.019    34.806     0.200
    12.061    28.146     0.200
    12.326    38.154     0.200
    12.935    30.281     0.200
    13.176    30.953     0.200
    13.438    30.175     0.200
    13.544    37.640     0.200
    13.637    35.490     0.200
    13.865    36.497     0.200
    13.865    35.036     0.200
    14.069    34.615     0.200
    14.155    33.719     0.200
    15.176    35.213     0.200
    15.367    37.256     0.200
    15.436    35.767     0.200
    15.414    36.024     0.200
    15.512    37.379     0.200
    15.795    39.274     0.200
    16.416    38.031     0.200
    18.525    42.820     0.200
    18.525    39.900     0.200
    18.697    41.312     0.200
    18.848    42.251     0.200
    18.848    41.482     0.200
    19.555    42.093     0.200
    19.555    39.783     0.200
    19.852    41.531     0.200
    19.920    42.534     0.200
    20.005    39.673     0.200
    20.161    42.029     0.200
    20.290    44.215     0.200
    20.344    40.687     0.200
    20.590    40.712     0.200
    20.605    41.648     0.200
    20.742    41.041     0.200
    20.742    40.041     0.200
    20.916    42.217     0.200
     1.600     8.821     0.200
     2.221    11.968     0.200
     2.104    10.951     0.200
     2.225    11.141     0.200
     3.171    11.661     0.200
     3.112    13.296     0.200
     3.167    13.806     0.200
     4.089    15.762     0.200
     4.874    18.685     0.200
     8.606    22.686     0.200
    10.899    27.352     0.200
    13.483    36.168     0.200
    13.841    32.498     0.200
    14.158    35.382     0.200
    14.423    34.453     0.200
    14.555    35.053     0.200
    15.111    35.389     0.200
    18.629    40.704     0.200
    18.778    40.673     0.200
    19.935    40.791     0.200
    19.935    39.963     0.200
    20.291    39.309     0.200
    20.671    39.276     0.200
    20.671    40.276     0.200
     1.021     8.825     0.200
     1.691    10.255     0.200
     2.137    12.911     0.200
     2.575    14.900     0.200
     3.129    12.943     0.200
     8.707    28.980     0.200
    10.921    28.847     0.200
    18.982    43.758     0.200
     1.084     8.188     0.200
     1.460     9.242     0.200
     1.741     9.711     0.200
     1.683     9.430     0.200
     2.217    10.984     0.200
     2.239    11.203     0.200
     2.121    10.941     0.200
     2.652    12.520     0.200
     2.600    11.553     0.200
     3.059    15.201     0.200
     3.187    14.246     0.200
     3.424    16.098     0.200
     3.889    16.053     0.200
     4.114    16.100     0.200
     4.869    18.639     0.200
     9.658    26.390     0.200
    10.999    32.942     0.200
    11.067    35.148     0.200
    12.053    29.344     0.200
    13.606    37.322     0.200
    13.650    36.275     0.200
    13.703    35.114     0.200
    14.032    38.747     0.200
    14.808    39.686     0.200
    14.883    37.762     0.200
    18.731    42.012     0.200
    18.984    44.561     0.200
    19.920    41.133     0.200
    20.000    42.399     0.200
     1.134     9.161     0.200
     1.688    10.326     0.200
     1.748     9.316     0.200
     2.019     9.692     0.200
     2.100    11.592     0.200
     2.274    11.303     0.200
     2.275    12.092     0.200
     2.545     9.172     0.200
     2.708    13.912     0.200
     3.167    14.565     0.200
     3.176    18.059     0.200
     3.218    16.378     0.200
     4.151    19.927     0.200
     9.694    29.617     0.200
    11.053    30.457     0.200
    11.053    30.867     0.200
    12.099    29.146     0.200
    13.662    37.002     0.200
    14.546    39.284     0.200
    14.864    39.372     0.200
    15.548    39.461     0.200
    18.608    42.788     0.200
    18.785    43.225     0.200
    19.620    42.078     0.200
    20.884    41.623     0.200
     1.697    10.293     0.200
     3.134    14.124     0.200
     8.527    26.317     0.200
    19.861    40.522     0.200
     1.376     8.434     0.200
     1.620     9.120     0.200
     1.884    10.018     0.200
     1.937    10.192     0.200
     2.084    11.236     0.200
     2.029    11.508     0.200
     2.940    10.384     0.200
     3.255    11.504     0.200
     3.070    14.827     0.200
     3.683    14.394     0.200
     8.224    25.357     0.200
     1.679     9.734     0.200
     1.983     8.639     0.200
     2.091     9.555     0.200
     2.343     9.614     0.200
     2.448    11.590     0.200
     2.714    11.911     0.200
     3.296    16.332     0.200
     3.296    13.571     0.200
     3.431    16.200     0.200
     3.690    16.690     0.200
     4.144    16.844     0.200
     4.202    16.311     0.200
     4.753    17.844     0.200
     9.723    27.443     0.200
    10.924    30.292     0.200
    10.924    29.062     0.200
    10.962    34.052     0.200
    12.063    28.799     0.200
    13.472    37.955     0.200
    14.361    38.584     0.200
    15.368    36.876     0.200
    17.353    37.356     0.200
    18.652    44.102     0.200
    19.532    44.531     0.200
    20.026    45.368     0.200
    20.450    40.024     0.200
    20.645    42.045     0.200
    20.836    40.517     0.200
     1.100     9.533     0.200
     1.701     9.976     0.200
     1.725    11.141     0.200
     2.134    11.858     0.200
     2.230    12.363     0.200
     2.223    11.734     0.200
     2.597    11.887     0.200
     3.052    15.879     0.200
     3.905    18.716     0.200
     1.450     9.186     0.200
     1.591     7.665     0.200
     1.837     9.559     0.200
     2.025    10.439     0.200
     2.254    10.725     0.200
     2.552    11.699     0.200
     3.091    13.796     0.200
     3.126    12.796     0.200
     3.274    12.562     0.200
     3.274    12.347     0.200
     3.496    15.420     0.200
     4.777    18.797     0.200
     8.727    25.857     0.200
     9.740    24.103     0.200
    11.054    28.433     0.200
    13.971    36.194     0.200
    14.024    36.734     0.200
    14.410    38.388     0.200
    16.433    38.193     0.200
    18.895    43.556     0.200
    18.895    42.938     0.200
    20.085    39.669     0.200
     0.852     6.989     0.200
     0.942     8.399     0.200
     1.318     8.940     0.200
     1.626     9.540     0.200
     3.190    14.261     0.200
     3.869    15.044     0.200
    19.927    41.012     0.200
     1.148     7.959     0.200
     1.416     7.902     0.200
     1.518     8.949     0.200
     1.831    10.084     0.200
     1.956     9.753     0.200
     2.017    10.684     0.200
     2.298    10.790     0.200
     2.294    11.052     0.200
     2.856    11.681     0.200
     2.889    11.518     0.200
     3.074    13.178     0.200
     3.247    13.040     0.200
     3.247    12.614     0.200
     3.247    10.298     0.200
     3.336    13.437     0.200
     3.707    14.371     0.200
     3.755    14.865     0.200
     3.811    13.985     0.200
     4.103    15.392     0.200
     4.126    13.549     0.200
     4.139    15.616     0.200
     4.481    14.481     0.200
     4.815    16.581     0.200
     5.952    19.474     0.200
     8.335    23.580     0.200
     8.355    24.710     0.200
     9.150    27.827     0.200
     9.417    26.606     0.200
     9.648    26.719     0.200
     9.648    25.160     0.200
    10.797    31.011     0.200
    11.964    29.194     0.200
    12.960    32.861     0.200
    13.330    36.642     0.200
    13.359    31.107     0.200
    13.576    34.812     0.200
    14.094    33.828     0.200
    14.181    34.571     0.200
    14.220    35.561     0.200
    18.358    39.330     0.200
    18.523    41.640     0.200
    18.656    42.699     0.200
    18.656    40.648     0.200
    19.416    42.426     0.200
    19.416    40.856     0.200
    19.987    44.263     0.200
    20.303    38.976     0.200
    20.460    41.141     0.200
    20.496    41.122     0.200
    20.496    39.110     0.200
    20.977    40.806     0.200
     1.555     9.580     0.200
     1.700    10.609     0.200
     1.713     9.868     0.200
     2.115    10.636     0.200
     2.190    11.302     0.200
     2.966    13.797     0.200
     3.099    11.504     0.200
     3.256    14.479     0.200
     3.323    16.348     0.200
     3.945    16.055     0.200
     4.949    19.847     0.200
     8.706    27.066     0.200
     9.564    24.833     0.200
    13.933    38.918     0.200
    15.389    40.930     0.200
    19.001    43.451     0.200
     1.525     8.986     0.200
     1.707    10.176     0.200
     1.891    10.192     0.200
     2.022    10.366     0.200
     2.075    11.239     0.200
     2.328    11.261     0.200
     3.020    12.833     0.200
     3.134    15.337     0.200
     1.145     9.091     0.200
     1.695    10.305     0.200
     1.737     9.587     0.200
     2.226    12.016     0.200
     2.252    10.664     0.200
     2.575    11.465     0.200
     3.052    14.918     0.200
     3.167    15.662     0.200
     3.167    15.897     0.200
     3.220    14.831     0.200
     3.272    13.281     0.200
     3.430    16.033     0.200
     3.930    18.640     0.200
     4.892    18.868     0.200
     8.828    26.627     0.200
     9.646    27.469     0.200
    11.020    33.082     0.200
    19.041    46.271     0.200
    19.041    43.291     0.200
     1.142     8.166     0.200
     1.396     8.914     0.200
     1.691     9.816     0.200
     1.747     9.764     0.200
     2.011    10.597     0.200
     2.100    10.721     0.200
     2.277    11.493     0.200
     2.280    10.665     0.200
     2.539    13.396     0.200
     3.103    13.781     0.200
     1.655     9.425     0.200
     1.780     9.588     0.200
     2.028    10.590     0.200
     2.071    10.739     0.200
     2.275    11.326     0.200
     2.298    11.656     0.200
     2.539    12.305     0.200
     3.120    13.312     0.200
     3.138    15.392     0.200
     3.193    13.028     0.200
     3.242    17.065     0.200
     3.680    15.754     0.200
     3.846    17.225     0.200
     4.218    16.101     0.200
    12.918    32.316     0.200
     1.632     8.354     0.200
     1.782     9.105     0.200
     2.146    10.626     0.200
     2.108    10.784     0.200
     2.161    11.046     0.200
     2.229    11.439     0.200
     2.662    11.454     0.200
     3.039    14.363     0.200
     3.153    12.817     0.200
     3.173    14.164     0.200
     3.386    13.769     0.200
     3.547    13.990     0.200
     3.861    15.842     0.200
     4.292    15.548     0.200
     4.870    15.434     0.200
     8.673    25.575     0.200
     9.637    25.118     0.200
    11.006    33.397     0.200
    13.391    33.763     0.200
    13.536    38.473     0.200
    14.916    36.393     0.200
    18.673    42.617     0.200
    18.924    41.871     0.200
    19.162    40.711     0.200
    19.522    42.213     0.200
    19.522    41.201     0.200
    19.922    41.241     0.200
    19.974    40.392     0.200
    19.974    40.142     0.200
    20.269    40.594     0.200
    20.627    39.819     0.200
    20.747    40.210     0.200
     1.382     9.399     0.200
     1.650     9.302     0.200
     1.793     9.912     0.200
     2.000    11.148     0.200
     2.053    10.909     0.200
     2.324    10.876     0.200
     2.306    11.420     0.200
     2.507    11.160     0.200
     3.147    13.564     0.200
     3.119    14.138     0.200
     3.191    12.513     0.200
     3.267    16.230     0.200
     3.516    13.459     0.200
     3.709    15.426     0.200
     3.832    15.399     0.200
     4.192    14.798     0.200
     4.791    18.965     0.200
     8.807    25.062     0.200
     9.743    25.668     0.200
    11.092    30.458     0.200
    12.941    32.331     0.200
    13.559    37.683     0.200
    13.613    34.236     0.200
    14.051    37.602     0.200
    18.957    43.642     0.200
    19.663    44.112     0.200
     1.125     8.513     0.200
     1.433     9.448     0.200
     1.703     9.541     0.200
     1.726     9.318     0.200
     2.045    11.721     0.200
     2.151    11.186     0.200
     2.235    11.514     0.200
     2.221    11.257     0.200
     3.046    12.491     0.200
     1.412     8.153     0.200
     1.639     9.152     0.200
     1.952    10.504     0.200
     2.056    11.320     0.200
     2.068    11.117     0.200
     2.266    10.054     0.200
     2.575    11.090     0.200
     1.576     9.563     0.200
     1.588     8.585     0.200
     1.825     9.464     0.200
     2.079    10.966     0.200
     2.128    10.809     0.200
     2.195    11.091     0.200
     2.249    10.716     0.200
     3.143    14.122     0.200
     3.825    15.846     0.200
     4.846    20.795     0.200
     1.786     9.177     0.200
     1.987    11.430     0.200
     2.057    11.003     0.200
     2.324    12.260     0.200
     2.499    11.415     0.200
     3.149    14.529     0.200
     3.123    13.935     0.200
     3.266    15.537     0.200
     3.266    15.302     0.200
     3.266    16.662     0.200
     3.202    13.466     0.200
     3.521    14.351     0.200
     3.722    16.350     0.200
     3.838    17.173     0.200
     4.793    18.749     0.200
     8.822    27.879     0.200
     9.744    25.007     0.200
    11.100    32.896     0.200
    18.655    41.684     0.200
    19.668    41.609     0.200
    20.123    40.853     0.200
     1.227     8.365     0.200
     1.432     8.408     0.200
     1.622     9.498     0.200
     1.858     8.968     0.200
     1.932    10.333     0.200
     2.079    11.134     0.200
     2.876    11.965     0.200
     3.122    14.140     0.200
     3.203    14.627     0.200
     3.738    15.895     0.200
     4.874    18.640     0.200
     8.250    24.610     0.200
     9.584    27.143     0.200
    10.703    31.366     0.200
    13.485    34.345     0.200
    18.636    41.304     0.200
     1.663     8.674     0.200
     1.782    10.040     0.200
     1.987    10.410     0.200
     2.061    10.898     0.200
     2.321    11.491     0.200
     2.315    11.607     0.200
     2.500    11.202     0.200
     3.146    15.618     0.200
     3.127    14.792     0.200
     3.842    17.013     0.200
     4.796    20.873     0.200
     9.741    25.886     0.200
    13.050    31.202     0.200
     1.157     8.575     0.200
     1.362     9.387     0.200
     1.648     9.015     0.200
     1.980    11.061     0.200
     2.042    11.211     0.200
     2.327    10.836     0.200
     2.340    11.014     0.200
     3.108    15.644     0.200
     3.165    14.941     0.200
     1.049     7.894     0.200
     1.484     9.335     0.200
     1.644     8.810     0.200
     2.256    11.558     0.200
     2.101    10.894     0.200
     2.094    10.941     0.200
     2.608    13.560     0.200
     3.072    14.817     0.200
     3.203    10.806     0.200
     3.160    13.913     0.200
    18.944    41.718     0.200
     1.087     8.169     0.200
     1.176     8.134     0.200
     1.757     9.493     0.200
     1.670     9.962     0.200
     2.067    10.804     0.200
     2.104    10.771     0.200
     2.230    10.774     0.200
     3.077    14.580     0.200
     3.202    10.238     0.200
     3.170    14.686     0.200
     3.873    14.833     0.200
     1.506     8.869     0.200
     1.584     8.805     0.200
     1.695    10.151     0.200
     2.041     8.941     0.200
     2.051    10.865     0.200
     2.262    10.107     0.200
     2.623    12.472     0.200
     3.111    13.009     0.200
     1.387     8.133     0.200
     1.617     7.337     0.200
     1.634     9.392     0.200
     1.868     8.281     0.200
     2.044    10.795     0.200
     2.079    10.755     0.200
     2.186    10.761     0.200
     2.541    10.995     0.200
     2.574    12.273     0.200
     2.828    11.991     0.200
     2.956    12.094     0.200
     3.084    13.285     0.200
     3.242    15.332     0.200
     3.242    16.235     0.200
     3.242    11.748     0.200
     3.289    11.708     0.200
     3.695    13.972     0.200
     3.717    17.269     0.200
     3.895    13.365     0.200
     4.086    14.406     0.200
     4.122    14.966     0.200
     4.126    12.365     0.200
     4.414    14.510     0.200
     4.839    18.130     0.200
     8.216    22.447     0.200
     9.327    28.578     0.200
     9.617    23.996     0.200
    10.736    32.538     0.200
    11.910    29.534     0.200
    12.805    29.380     0.200
    13.232    37.611     0.200
    13.313    32.163     0.200
    13.455    35.410     0.200
    13.455    32.290     0.200
    13.994    34.418     0.200
    15.132    34.731     0.200
    15.190    35.069     0.200
    15.587    35.993     0.200
    18.277    38.500     0.200
    19.572    41.125     0.200
    19.913    41.838     0.200
    19.928    47.072     0.200
    20.181    40.808     0.200
    20.259    41.604     0.200
    20.386    40.825     0.200
    20.495    42.946     0.200
    20.861    42.278     0.200
    20.882    41.636     0.200
     1.499     8.131     0.200
     1.625     9.392     0.200
     1.803     9.227     0.200
     2.041     9.972     0.200
     2.158    11.086     0.200
     2.222     9.769     0.200
     2.226    10.151     0.200
     2.620    10.806     0.200
     2.665    11.953     0.200
     2.689    12.726     0.200
     3.098    13.099     0.200
     3.098    10.962     0.200
     3.373    11.282     0.200
     3.293    13.317     0.200
     3.334    12.738     0.200
     3.535    13.446     0.200
     3.672    12.668     0.200
     4.035    14.823     0.200
     4.002    14.545     0.200
     4.258    13.857     0.200
     4.359    15.698     0.200
     4.509    15.111     0.200
     4.936    15.414     0.200
     4.963    16.961     0.200
     6.302    21.561     0.200
     7.392    24.096     0.200
     8.850    25.324     0.200
     9.580    25.604     0.200
     9.580    25.774     0.200
     9.646    28.331     0.200
    10.954    31.567     0.200
    10.974    28.292     0.200
    11.055    34.894     0.200
    11.996    28.205     0.200
    12.768    32.921     0.200
    13.356    30.137     0.200
    13.605    36.932     0.200
    13.712    34.075     0.200
    13.956    36.539     0.200
    14.076    37.232     0.200
    14.076    35.742     0.200
    14.166    34.038     0.200
    15.014    37.291     0.200
    15.014    33.850     0.200
    15.487    36.369     0.200
    16.135    38.300     0.200
    16.211    36.802     0.200
    16.645    39.842     0.200
    18.527    41.492     0.200
    18.611    41.209     0.200
    19.104    42.454     0.200
    19.529    41.502     0.200
    19.698    40.630     0.200
    19.925    40.976     0.200
    19.986    40.613     0.200
    20.412    44.296     0.200
    20.697    44.966     0.200
    20.847    41.314     0.200
     1.585    10.527     0.200
     1.787    10.027     0.200
     2.166    11.651     0.200
     2.213    11.048     0.200
     2.217    10.488     0.200
     2.621    10.862     0.200
     2.666    12.901     0.200
     2.680    12.934     0.200
     3.107    10.857     0.200
     3.280    13.174     0.200
     3.317    13.024     0.200
     3.376    15.994     0.200
     4.952    21.323     0.200
     8.835    27.397     0.200
     9.587    23.737     0.200
    19.087    42.289     0.200
     1.094     8.162     0.200
     1.448     8.416     0.200
     1.583     8.696     0.200
     1.681     9.062     0.200
     1.745     9.150     0.200
     2.063    10.548     0.200
     2.113    10.285     0.200
     2.230     9.039     0.200
     2.249    10.924     0.200
     2.586    11.656     0.200
     2.664    12.077     0.200
     2.719    12.008     0.200
     2.799    12.761     0.200
     3.070    12.933     0.200
     3.180    13.250     0.200
     3.194    13.656     0.200
     3.194    12.400     0.200
     3.194    12.179     0.200
     3.214    12.785     0.200
     3.436    14.613     0.200
     3.648    14.513     0.200
     4.124    13.737     0.200
     4.154    17.417     0.200
     4.387    14.934     0.200
     4.860    17.535     0.200
     5.187    23.390     0.200
     8.773    24.341     0.200
     9.671    27.154     0.200
     9.666    26.815     0.200
    11.012    28.727     0.200
    11.080    32.511     0.200
    12.065    29.722     0.200
    13.619    39.285     0.200
    14.009    33.532     0.200
    18.744    41.576     0.200
    18.983    44.186     0.200
    19.582    43.199     0.200
    19.582    41.099     0.200
    19.711    40.889     0.200
    19.933    41.597     0.200
    20.036    40.701     0.200
    20.038    43.181     0.200
    20.240    40.619     0.200
    20.617    41.045     0.200
    20.696    41.797     0.200
    20.729    40.115     0.200
    20.840    40.719     0.200
     1.226     8.176     0.200
     1.434     7.912     0.200
     1.857     8.096     0.200
     1.932     9.649     0.200
     2.029    11.473     0.200
     2.080    10.785     0.200
     2.194     9.754     0.200
     2.249    10.505     0.200
     2.513    11.614     0.200
     3.124    11.761     0.200
     4.134    13.275     0.200
     8.250    23.962     0.200
     1.532     8.034     0.200
     1.512     8.217     0.200
     1.730     9.238     0.200
     1.687     8.930     0.200
     2.126    10.472     0.200
     2.164    10.878     0.200
     2.147    10.672     0.200
     2.601    12.601     0.200
     2.658    12.193     0.200
     3.018    12.983     0.200
     3.148    13.440     0.200
     3.148    12.802     0.200
     3.148    12.481     0.200
     3.211    13.166     0.200
     3.213    13.831     0.200
     3.377    13.422     0.200
     3.908    13.455     0.200
     4.075    15.170     0.200
     4.397    14.530     0.200
     4.902    19.192     0.200
     8.726    25.092     0.200
     9.615    26.051     0.200
     9.615    25.641     0.200
     9.606    26.656     0.200
    10.985    31.060     0.200
    11.015    33.015     0.200
    12.007    30.038     0.200
    12.833    35.041     0.200
    13.553    37.694     0.200
    13.958    36.665     0.200
    13.958    36.876     0.200
    15.077    36.748     0.200
    15.440    37.071     0.200
    16.227    38.788     0.200
    16.542    39.513     0.200
    18.679    41.569     0.200
    18.709    42.026     0.200
    18.982    43.640     0.200
    18.982    40.210     0.200
    19.520    41.162     0.200
    19.972    39.985     0.200
    20.220    42.392     0.200
    20.674    40.192     0.200
     1.131     7.214     0.200
     1.375     8.176     0.200
     1.845     9.630     0.200
     1.985     9.466     0.200
     2.103     9.352     0.200
     2.155     8.879     0.200
     1.264     8.226     0.200
     1.420     8.047     0.200
     1.835     8.969     0.200
     1.968     9.690     0.200
     2.055     8.794     0.200
     2.081    10.839     0.200
     2.256    10.985     0.200
     2.504    11.124     0.200
     4.877    20.492     0.200
    18.612    42.495     0.200
     1.408     8.146     0.200
     1.594     7.402     0.200
     1.646     9.308     0.200
     1.960     9.866     0.200
     2.063    10.606     0.200
     2.172    10.150     0.200
     2.067    10.772     0.200
     2.518    11.048     0.200
     3.013    12.703     0.200
     3.107    13.785     0.200
     3.219    14.093     0.200
     3.219    13.240     0.200
     3.266    11.594     0.200
     4.863    17.787     0.200
     8.215    24.221     0.200
     9.308    30.609     0.200
    10.694    27.236     0.200
    10.716    33.470     0.200
    13.451    32.612     0.200
    13.593    37.193     0.200
    14.104    37.433     0.200
    15.114    37.949     0.200
    15.167    35.680     0.200
    18.604    42.820     0.200
    19.302    40.371     0.200
    19.556    41.009     0.200
    19.945    46.373     0.200
    20.176    40.976     0.200
    20.371    43.100     0.200
    20.475    40.483     0.200
    20.849    40.121     0.200
     1.617     7.744     0.200
     1.664     9.138     0.200
     1.844     9.095     0.200
     1.981     9.537     0.200
     2.095    10.462     0.200
     2.052    11.035     0.200
     2.157    10.898     0.200
     2.291    11.078     0.200
     2.527    11.479     0.200
     3.089    14.619     0.200
     3.241    13.360     0.200
     4.077    14.208     0.200
     4.848    17.977     0.200
     8.185    22.779     0.200
    10.693    27.060     0.200
    13.423    36.998     0.200
    15.187    34.862     0.200
    18.572    40.757     0.200
    20.890    40.525     0.200
     1.583     9.379     0.200
     1.615     9.040     0.200
     1.801     9.251     0.200
     2.084    10.780     0.200
     2.145    11.074     0.200
     2.168    10.130     0.200
     2.254    11.514     0.200
     2.639    11.868     0.200
     2.688    12.309     0.200
     3.065    13.203     0.200
     3.203    14.444     0.200
     3.203    15.721     0.200
     3.412    13.541     0.200
     3.664    13.027     0.200
     3.839    15.741     0.200
     4.126    15.323     0.200
     4.844    17.865     0.200
     5.325    19.520     0.200
     8.677    26.613     0.200
     9.146    31.166     0.200
     9.617    30.367     0.200
     9.663    27.830     0.200
    10.966    34.102     0.200
    11.032    28.761     0.200
    11.026    35.224     0.200
    12.044    30.946     0.200
    13.417    33.122     0.200
    13.557    38.485     0.200
    13.915    36.901     0.200
    14.040    41.347     0.200
    14.129    36.012     0.200
    14.496    37.629     0.200
    15.136    37.971     0.200
    15.446    38.638     0.200
    15.431    39.426     0.200
    16.295    38.937     0.200
    16.856    40.191     0.200
    18.524    44.329     0.200
    18.524    41.466     0.200
    18.697    43.097     0.200
    18.778    42.559     0.200
    18.910    45.524     0.200
    18.910    42.504     0.200
    19.188    41.674     0.200
    19.547    44.281     0.200
    19.942    41.280     0.200
    20.221    45.717     0.200
     1.618     8.297     0.200
     1.684     9.312     0.200
     1.829     9.149     0.200
     2.002     9.798     0.200
     2.105    10.337     0.200
     2.057    11.138     0.200
     2.290    10.372     0.200
     2.518    11.141     0.200
     2.625    13.506     0.200
     2.805    12.309     0.200
     3.027    12.795     0.200
     3.002    12.879     0.200
     3.120    12.735     0.200
     3.092    14.318     0.200
     3.240    13.401     0.200
     3.240    14.600     0.200
     3.268    13.724     0.200
     3.694    15.021     0.200
     4.356    14.046     0.200
     4.853    17.971     0.200
     5.119    20.873     0.200
     8.165    24.107     0.200
     8.636    26.809     0.200
     9.048    26.495     0.200
     9.287    26.706     0.200
     9.602    27.633     0.200
     9.602    25.161     0.200
    10.679    30.666     0.200
    10.696    31.069     0.200
    10.953    30.569     0.200
    12.955    34.580     0.200
    13.188    35.981     0.200
    13.403    36.173     0.200
    13.403    34.962     0.200
    13.846    35.876     0.200
    14.038    36.666     0.200
    14.079    35.581     0.200
    15.026    38.606     0.200
    15.090    37.332     0.200
    15.090    36.988     0.200
    15.186    39.269     0.200
    15.435    38.957     0.200
    16.248    36.778     0.200
    16.474    39.336     0.200
    17.626    40.057     0.200
    18.561    42.977     0.200
    18.561    41.017     0.200
    18.987    41.313     0.200
    19.276    41.134     0.200
    19.313    40.701     0.200
    19.313    41.361     0.200
    19.479    40.261     0.200
    19.524    40.239     0.200
    19.751    39.995     0.200
    19.751    40.995     0.200
    19.863    40.484     0.200
    19.904    44.701     0.200
    20.129    40.779     0.200
    20.212    40.016     0.200
    20.337    40.448     0.200
    20.508    41.452     0.200
    20.503    39.813     0.200
    20.810    39.729     0.200
    20.896    40.833     0.200
     1.612     9.629     0.200
     1.765     9.267     0.200
     1.794    10.308     0.200
     1.874     9.873     0.200
     1.953    10.271     0.200
     2.318    10.987     0.200
     2.359    11.859     0.200
     3.019    15.025     0.200
     4.057    15.642     0.200
     8.467    26.855     0.200
    13.500    35.769     0.200
     2.975    14.289     0.200
     3.024    14.460     0.200
     8.419    21.069     0.200
     8.975    26.506     0.200
     8.991    28.626     0.200
     9.298    29.139     0.200
     9.440    28.182     0.200
     9.440    26.753     0.200
    10.657    32.177     0.200
    10.707    32.397     0.200
    10.801    30.503     0.200
    12.727    33.022     0.200
    13.402    33.824     0.200
    14.781    36.757     0.200
    16.523    38.530     0.200
    18.865    42.492     0.200
    18.973    40.342     0.200
    19.255    39.937     0.200
    19.255    41.308     0.200
    19.662    40.491     0.200
     1.910     8.941     0.200
     1.987    11.009     0.200
     8.207    25.037     0.200
    17.546    37.739     0.200
    19.831    39.654     0.200
     1.526     8.801     0.200
     1.593     9.145     0.200
     1.604     9.116     0.200
     1.812     9.012     0.200
     2.072    10.978     0.200
     2.145    10.711     0.200
     2.172    10.641     0.200
     2.265    10.672     0.200
     2.585    12.145     0.200
     2.634    10.517     0.200
     2.696    11.718     0.200
     2.859    13.027     0.200
     3.075    12.872     0.200
     3.128    12.735     0.200
     3.138    13.981     0.200
     3.170    15.513     0.200
     3.214    14.694     0.200
     3.214    12.932     0.200
     3.421    11.425     0.200
     3.565    13.856     0.200
     3.676    12.880     0.200
     3.828    15.083     0.200
     4.125    17.974     0.200
     4.137    13.949     0.200
     4.256    13.041     0.200
     4.314    15.727     0.200
     4.729    15.203     0.200
     8.673    23.273     0.200
     9.673    26.639     0.200
     9.673    24.287     0.200
    10.973    28.152     0.200
    12.053    27.968     0.200
    13.426    31.838     0.200
    13.562    36.258     0.200
    13.911    37.458     0.200
    14.139    33.422     0.200
    18.704    43.250     0.200
    18.790    41.351     0.200
    18.899    42.972     0.200
    18.899    42.492     0.200
    19.555    43.318     0.200
    19.872    40.721     0.200
    19.988    44.570     0.200
     1.378     8.075     0.200
     1.560     8.682     0.200
     1.877     8.715     0.200
     1.935     9.526     0.200
     2.006    10.392     0.200
     2.064    10.534     0.200
     2.317    10.247     0.200
     2.501    12.442     0.200
     2.592    11.293     0.200
     2.841    11.748     0.200
     2.885     9.322     0.200
     3.270    13.727     0.200
     1.538     5.494     0.200
     1.500     6.262     0.200
     1.582     5.645     0.200
     1.833     6.153     0.200
     2.056     7.589     0.200
     2.157     7.499     0.200
     2.168     6.690     0.200
     2.277     7.455     0.200
     2.575     9.165     0.200
     2.636     8.594     0.200
     3.085     9.787     0.200
     3.183    14.860     0.200
     3.227    10.540     0.200
     3.227    13.790     0.200
     3.227    12.806     0.200
     3.227    11.071     0.200
     3.427     8.760     0.200
     3.691    10.212     0.200
     4.111    11.722     0.200
     4.707    11.758     0.200
     4.820    15.497     0.200
     6.255    16.453     0.200
     6.379    19.355     0.200
     8.654    19.620     0.200
     9.295    24.322     0.200
     9.684    23.634     0.200
    10.973    30.447     0.200
    10.973    27.853     0.200
    11.029    31.085     0.200
    11.051    27.828     0.200
    12.059    24.463     0.200
    13.557    34.083     0.200
    13.869    32.850     0.200
    13.894    31.970     0.200
    14.090    32.851     0.200
    15.162    33.530     0.200
    15.448    32.328     0.200
    18.531    38.940     0.200
    18.704    37.922     0.200
    18.809    37.694     0.200
    19.558    37.954     0.200
    19.558    37.696     0.200
    19.937    37.530     0.200
    20.188    40.097     0.200
    20.760    38.127     0.200
     1.468     8.419     0.200
     1.502     8.891     0.200
     1.574     6.958     0.200
     1.807     9.418     0.200
     1.962    10.030     0.200
     1.952     9.722     0.200
     2.062    10.648     0.200
     2.313    10.291     0.200
     2.429    10.721     0.200
     2.853    11.695     0.200
     3.023    13.022     0.200
     2.944    12.110     0.200
     3.205    14.508     0.200
     3.205    15.336     0.200
     3.205    15.664     0.200
     3.115    11.898     0.200
     3.310    11.577     0.200
     3.296    12.953     0.200
     3.709    12.845     0.200
     3.702    15.379     0.200
     3.755    14.503     0.200
     3.820    12.469     0.200
     4.101    14.097     0.200
     4.140    14.855     0.200
     4.178    14.979     0.200
     4.321    13.391     0.200
     4.536    14.664     0.200
     4.852    18.047     0.200
     5.140    18.879     0.200
     5.259    18.201     0.200
     6.002    16.035     0.200
     6.281    19.596     0.200
     7.035    21.630     0.200
     7.388    22.569     0.200
     8.377    22.433     0.200
     9.135    29.992     0.200
     9.414    29.133     0.200
     9.615    25.891     0.200
     9.615    26.461     0.200
    10.142    26.532     0.200
    10.787    32.705     0.200
    10.787    31.611     0.200
    10.823    29.791     0.200
    10.973    29.130     0.200
    11.940    28.759     0.200
    12.918    31.912     0.200
    13.332    31.307     0.200
    13.333    36.502     0.200
    13.613    36.024     0.200
    13.613    36.336     0.200
    13.758    37.924     0.200
    13.795    35.414     0.200
    14.064    35.866     0.200
    14.221    37.225     0.200
    14.204    37.836     0.200
    14.480    35.729     0.200
    15.154    37.646     0.200
    15.154    37.904     0.200
    15.204    37.357     0.200
    15.443    38.070     0.200
    15.746    37.929     0.200
    15.885    39.407     0.200
    16.390    38.122     0.200
    18.348    40.663     0.200
    18.348    41.827     0.200
    18.515    40.021     0.200
    18.711    42.937     0.200
    19.149    39.954     0.200
    19.400    41.491     0.200
    19.423    39.831     0.200
    19.633    40.073     0.200
    19.690    40.810     0.200
    19.775    39.721     0.200
    19.843    40.021     0.200
    20.047    42.147     0.200
    20.041    43.112     0.200
    20.409    40.221     0.200
    20.678    41.971     0.200
    20.997    39.652     0.200
     1.470     8.573     0.200
     1.914    10.313     0.200
     2.052     9.973     0.200
     2.183     9.269     0.200
     2.343    11.870     0.200
     2.585    11.918     0.200
     2.690    13.655     0.200
     2.887    13.170     0.200
     2.989    12.492     0.200
     2.989    11.414     0.200
     3.410    13.516     0.200
     3.439    13.371     0.200
     8.892    25.805     0.200
    14.107    36.628     0.200
    19.907    41.202     0.200
     1.428     7.208     0.200
     1.458     7.873     0.200
     1.881     9.525     0.200
     2.084     9.576     0.200
     2.195     8.388     0.200
     2.308    11.498     0.200
     2.609    11.844     0.200
     2.917    13.742     0.200
    10.927    27.232     0.200
    13.779    32.222     0.200
     1.175     8.112     0.200
     1.441     6.840     0.200
     1.578     8.089     0.200
     1.901     7.805     0.200
     1.878     9.627     0.200
     2.066    10.058     0.200
     2.255    12.190     0.200
     2.541    11.644     0.200
     3.014    13.690     0.200
     3.114    14.833     0.200
     3.740    15.723     0.200
     8.302    23.078     0.200
     1.404     8.557     0.200
     1.518     7.542     0.200
     1.626     9.746     0.200
     2.175    10.434     0.200
     2.220    11.326     0.200
     2.253     9.434     0.200
     2.592    13.528     0.200
     2.690    12.309     0.200
     2.721    12.502     0.200
     3.007    14.964     0.200
     3.114    12.899     0.200
     3.286    14.374     0.200
     4.001    15.990     0.200
     4.052    14.779     0.200
     9.598    26.770     0.200
    13.331    30.626     0.200
    13.635    35.374     0.200
    13.691    31.896     0.200
    14.106    32.605     0.200
    14.145    33.595     0.200
    14.517    38.783     0.200
    15.509    34.971     0.200
    15.517    35.896     0.200
    15.645    35.911     0.200
    15.667    34.927     0.200
    16.240    35.997     0.200
    17.230    38.067     0.200
    19.114    43.131     0.200
    20.419    46.303     0.200
     1.318     4.078     0.200
     1.962     6.334     0.200
     1.984     8.097     0.200
     3.021    10.566     0.200
     3.308     9.096     0.200
     3.628    12.106     0.200
     4.067    12.284     0.200
     4.780    14.836     0.200
     8.180    21.624     0.200
    13.745    31.097     0.200
    15.557    36.197     0.200
    18.520    40.272     0.200
    18.520    40.042     0.200
    19.822    38.504     0.200
    19.822    38.879     0.200
     1.768     7.833     0.200
     1.825     8.212     0.200
     1.531     8.100     0.200
     1.510     9.361     0.200
     1.684     9.746     0.200
     2.130    11.203     0.200
     2.146    11.115     0.200
     2.160    10.219     0.200
     2.597    12.931     0.200
     2.655    12.445     0.200
     2.655    12.347     0.200
     3.016    12.590     0.200
     3.147    15.047     0.200
     3.147    13.451     0.200
     3.212    14.314     0.200
     3.682    12.897     0.200
     3.906    18.447     0.200
     4.074    18.345     0.200
     8.721    24.957     0.200
     9.614    28.688     0.200
    13.549    36.464     0.200
    16.540    39.260     0.200
    18.978    43.302     0.200
    18.978    43.123     0.200
    20.669    40.875     0.200
    20.770    41.192     0.200
    20.770    42.182     0.200
     1.543     6.860     0.200
     1.561     8.838     0.200
     1.676     9.758     0.200
     1.853     9.228     0.200
     2.038     9.658     0.200
     2.096    10.906     0.200
     2.220    10.299     0.200
     2.296    12.170     0.200
     2.436    12.466     0.200
     2.764    11.279     0.200
     3.012    12.604     0.200
     3.126    15.616     0.200
     3.172    16.220     0.200
     3.172    16.073     0.200
     3.172    11.794     0.200
     3.157    13.952     0.200
     3.331    13.816     0.200
     3.699    18.809     0.200
     3.758    14.327     0.200
     3.822    15.812     0.200
     4.083    15.816     0.200
     4.275    15.772     0.200
     4.658    16.394     0.200
     4.874    18.541     0.200
     5.318    20.293     0.200
     6.153    22.342     0.200
     7.053    21.131     0.200
     8.530    25.570     0.200
     9.610    28.798     0.200
     9.610    28.516     0.200
    10.247    29.766     0.200
    10.903    32.301     0.200
    11.965    29.317     0.200
    13.057    31.927     0.200
    13.426    35.059     0.200
    13.764    36.605     0.200
    13.988    38.607     0.200
    14.313    38.112     0.200
    15.517    39.653     0.200
    16.435    39.851     0.200
    18.413    43.255     0.200
    18.807    42.260     0.200
    18.832    44.879     0.200
    18.832    42.099     0.200
    19.449    42.156     0.200
    19.897    40.949     0.200
    20.322    42.782     0.200
    20.484    41.496     0.200
    20.623    42.964     0.200
     1.511     9.611     0.200
     2.138    10.807     0.200
     2.130    11.744     0.200
     2.163    11.300     0.200
     2.208    11.483     0.200
     2.597    13.071     0.200
     3.204    13.928     0.200
     1.674     9.691     0.200
     1.772    10.997     0.200
     2.014    11.090     0.200
     2.146    11.336     0.200
     2.290    12.361     0.200
     2.437    13.563     0.200
     2.546    12.260     0.200
     3.098    14.738     0.200
     3.234    14.627     0.200
     4.947    21.576     0.200
     1.285     6.605     0.200
     1.611     8.069     0.200
     1.659     8.055     0.200
     1.845     6.886     0.200
     1.975     8.834     0.200
     2.086     8.993     0.200
     2.056    10.174     0.200
     2.161     8.899     0.200
     2.284     8.919     0.200
     2.981    11.008     0.200
     3.094    13.470     0.200
     3.235     9.587     0.200
     3.701    14.681     0.200
     4.111    15.287     0.200
     4.085    13.677     0.200
     4.852    14.226     0.200
     8.193    23.092     0.200
    13.810    31.203     0.200
    14.704    33.375     0.200
    15.054    33.646     0.200
    19.763    39.531     0.200
     1.290     7.271     0.200
     1.449     6.905     0.200
     1.548     8.223     0.200
     1.702     8.003     0.200
     1.783     8.113     0.200
     2.012     8.571     0.200
     2.045    10.399     0.200
     2.114     9.666     0.200
     2.124     9.814     0.200
     2.455     9.701     0.200
     2.869    10.924     0.200
     2.958    14.583     0.200
     3.096    11.583     0.200
     3.161    12.597     0.200
     3.205    14.167     0.200
     3.764    13.756     0.200
     4.044    13.922     0.200
     4.139    14.010     0.200
     8.183    23.105     0.200
     9.535    27.580     0.200
    10.629    30.874     0.200
    13.356    35.109     0.200
    13.414    33.768     0.200
    18.622    42.232     0.200
    18.622    39.693     0.200
    20.312    39.439     0.200
     1.622     7.441     0.200
     1.606     8.123     0.200
     1.816     9.874     0.200
     2.055    10.319     0.200
     2.100    10.935     0.200
     2.217    10.481     0.200
     2.292    10.141     0.200
     2.630    11.711     0.200
     2.735    11.579     0.200
     3.106    13.932     0.200
     3.121    13.269     0.200
     3.818    14.797     0.200
     4.314    15.175     0.200
     4.810    19.758     0.200
     8.710    27.098     0.200
    13.100    31.925     0.200
    17.236    35.008     0.200
     1.306     7.402     0.200
     1.414     6.855     0.200
     1.583     7.776     0.200
     1.698     7.994     0.200
     1.802     8.828     0.200
     2.011     9.115     0.200
     2.092     9.877     0.200
     2.121    10.459     0.200
     3.128    13.338     0.200
    18.589    41.531     0.200
    19.721    38.819     0.200
     1.135     8.510     0.200
     1.621     8.153     0.200
     2.090    10.854     0.200
     2.280    11.204     0.200
     2.285    11.018     0.200
     3.109    13.117     0.200
     3.157    14.519     0.200
     1.552     7.374     0.200
     1.636     9.541     0.200
     2.143     9.332     0.200
     2.112    11.050     0.200
     2.224    10.315     0.200
     2.565    12.066     0.200
     2.658    12.016     0.200
     8.673    26.881     0.200
    10.938    26.449     0.200
    18.927    43.629     0.200
    18.927    41.750     0.200
     1.120     8.260     0.200
     1.386     7.935     0.200
     1.655     9.822     0.200
     1.710     7.498     0.200
     1.991    10.445     0.200
     2.224    11.811     0.200
     2.837    10.988     0.200
     3.196    13.088     0.200
     3.321    15.754     0.200
     4.733    18.404     0.200
    12.999    33.067     0.200
     1.183     8.343     0.200
     1.656     8.613     0.200
     1.681    10.254     0.200
     2.076    10.595     0.200
     2.326    12.964     0.200
     2.365    13.921     0.200
     2.809    12.312     0.200
     3.145    13.970     0.200
     3.257    17.243     0.200
     4.201    14.134     0.200
     4.806    18.692     0.200
    12.925    34.501     0.200
    18.997    44.361     0.200
     1.684     7.559     0.200
     2.047    10.326     0.200
     2.303    12.789     0.200
     2.337    12.875     0.200
     2.834    12.575     0.200
     2.852    12.608     0.200
     3.173    13.327     0.200
     3.286    13.175     0.200
     3.286    15.543     0.200
     3.286    14.253     0.200
     3.755    14.651     0.200
     4.172    16.229     0.200
     5.112    18.715     0.200
     8.849    24.772     0.200
     9.766    26.232     0.200
     9.791    27.946     0.200
    10.570    30.146     0.200
    11.140    31.102     0.200
    11.131    29.098     0.200
    11.200    34.699     0.200
    12.954    30.633     0.200
    13.538    30.609     0.200
    13.738    36.883     0.200
    13.983    33.879     0.200
    14.094    35.274     0.200
    14.622    38.860     0.200
    15.200    37.309     0.200
    15.524    38.894     0.200
    15.625    36.255     0.200
    15.625    37.833     0.200
    16.226    39.097     0.200
    17.112    40.155     0.200
    18.686    42.037     0.200
    18.781    41.430     0.200
    18.863    40.976     0.200
    18.974    42.773     0.200
    19.698    40.231     0.200
    19.830    39.982     0.200
    20.129    39.795     0.200
    20.157    40.770     0.200
     1.567     8.869     0.200
     1.997    10.212     0.200
     2.005    11.466     0.200
     2.102    10.715     0.200
     2.478    11.189     0.200
     2.980    14.297     0.200
     3.190    11.250     0.200
     3.190    11.571     0.200
     4.898    17.673     0.200
     5.166    23.020     0.200
     8.190    24.403     0.200
     9.557    27.435     0.200
    13.423    35.937     0.200
    13.856    37.547     0.200
    14.582    38.156     0.200
    18.611    42.062     0.200
    19.720    40.503     0.200
    20.330    39.617     0.200
     1.691     6.840     0.200
     2.009     9.903     0.200
     2.236    12.752     0.200
     2.338    12.077     0.200
     2.819    11.384     0.200
     2.898    10.603     0.200
     3.178    11.852     0.200
     3.303    14.397     0.200
     3.303    14.631     0.200
     3.303    12.147     0.200
     3.303    13.061     0.200
     4.158    14.661     0.200
     4.752    17.947     0.200
     5.080    18.105     0.200
     8.773    27.012     0.200
     9.255    30.132     0.200
     9.774    24.574     0.200
     9.774    27.082     0.200
     9.756    31.784     0.200
    11.104    33.561     0.200
    11.165    34.841     0.200
    12.169    28.127     0.200
    12.981    32.257     0.200
    13.538    32.555     0.200
    13.533    39.191     0.200
    13.585    38.625     0.200
    13.697    37.398     0.200
    14.020    37.522     0.200
    14.020    36.780     0.200
    14.582    37.362     0.200
    15.226    36.059     0.200
    15.226    37.176     0.200
    15.331    37.874     0.200
    15.586    39.047     0.200
    16.152    39.262     0.200
    18.660    41.373     0.200
    18.828    40.413     0.200
    18.835    39.937     0.200
    18.908    42.782     0.200
    18.908    41.438     0.200
    19.680    40.074     0.200
    19.680    39.621     0.200
    19.789    39.806     0.200
    20.007    40.553     0.200
    20.080    41.710     0.200
    20.122    43.219     0.200
    20.713    42.124     0.200
    20.750    40.490     0.200
    20.903    41.701     0.200
     1.636     8.886     0.200
     1.694    10.164     0.200
     2.110    10.750     0.200
     2.383    13.336     0.200
     2.367    13.610     0.200
     2.787    13.325     0.200
     2.800    12.619     0.200
     3.125    13.580     0.200
     3.232    15.360     0.200
     4.226    15.845     0.200
     4.835    18.195     0.200
     5.174    21.382     0.200
     8.885    28.488     0.200
     9.716    26.620     0.200
     9.716    28.729     0.200
    11.105    34.115     0.200
    11.180    32.636     0.200
    12.134    28.804     0.200
    12.895    33.650     0.200
    13.494    33.334     0.200
    13.725    38.342     0.200
    14.028    39.231     0.200
    14.125    38.428     0.200
    14.391    39.359     0.200
    14.608    39.331     0.200
    15.142    38.671     0.200
    15.609    40.647     0.200
    15.802    39.800     0.200
    16.258    41.827     0.200
    18.659    42.759     0.200
    18.837    42.381     0.200
    19.039    44.624     0.200
    19.039    42.530     0.200
    19.664    42.130     0.200
    19.664    42.739     0.200
    20.222    40.614     0.200
     0.994     7.583     0.200
     1.494     9.351     0.200
     1.622     8.452     0.200
     2.095    10.819     0.200
     2.155    10.496     0.200
     2.675    12.185     0.200
     3.052    13.253     0.200
     3.191    15.392     0.200
     3.191    11.446     0.200
     3.667    13.190     0.200
     3.849    15.498     0.200
     4.856    19.295     0.200
     8.672    26.733     0.200
    10.953    28.296     0.200
    13.158    30.741     0.200
    13.545    37.393     0.200
    14.383    33.437     0.200
    15.434    37.943     0.200
    15.455    37.536     0.200
    15.433    37.869     0.200
    18.769    40.324     0.200
    18.915    42.462     0.200
    19.985    40.577     0.200
    19.985    40.132     0.200
     1.657     7.793     0.200
     1.685     9.903     0.200
     1.964     9.225     0.200
     2.043    10.789     0.200
     2.342     9.181     0.200
     2.766    12.771     0.200
     2.830    11.755     0.200
     3.171    14.289     0.200
     3.286    10.822     0.200
     3.723    14.032     0.200
     3.827    14.704     0.200
     4.221    17.065     0.200
     4.775    19.181     0.200
     8.838    24.099     0.200
     9.765    26.258     0.200
    13.024    31.281     0.200
    13.532    35.367     0.200
    18.966    41.413     0.200
    20.148    40.476     0.200
     3.216    13.135     0.200
     3.216    12.606     0.200
     3.216    11.706     0.200
     3.216    11.841     0.200
     5.141    20.086     0.200
     8.614    23.631     0.200
     9.667    25.028     0.200
     9.667    23.528     0.200
     9.585    29.781     0.200
    10.941    28.515     0.200
    12.913    32.383     0.200
    13.413    29.410     0.200
    13.520    36.560     0.200
    14.511    35.203     0.200
    15.154    35.350     0.200
    15.411    33.092     0.200
    15.985    36.493     0.200
    16.431    37.486     0.200
    18.671    39.148     0.200
    18.815    39.068     0.200
    18.857    41.084     0.200
    18.857    40.374     0.200
    19.529    43.033     0.200
    19.979    38.217     0.200
    19.950    43.728     0.200
    20.328    39.115     0.200
     1.389     8.263     0.200
     1.657     8.659     0.200
     1.783     8.210     0.200
     2.007    10.397     0.200
     2.064    10.396     0.200
     2.296    10.153     0.200
     2.293    11.731     0.200
     2.311    10.054     0.200
     2.788    11.595     0.200
     3.135    13.662     0.200
     3.130    13.112     0.200
     3.197    12.453     0.200
     3.255    13.708     0.200
     4.187    12.690     0.200
     4.800    14.766     0.200
     4.803    17.240     0.200
    20.105    39.865     0.200
     1.598    10.200     0.200
     1.613    10.998     0.200
     2.020    10.953     0.200
     2.278    11.656     0.200
     2.362    12.850     0.200
     2.688    13.611     0.200
     2.793    12.913     0.200
     3.156    15.940     0.200
     3.242    16.290     0.200
     3.284    17.612     0.200
     3.284    15.995     0.200
     3.734    13.309     0.200
     3.792    15.798     0.200
     4.178    15.285     0.200
     4.213    15.287     0.200
     4.301    15.912     0.200
     4.768    18.890     0.200
     4.740    16.142     0.200
     8.750    25.616     0.200
     9.753    28.839     0.200
    12.145    30.707     0.200
    13.668    39.633     0.200
    13.996    36.426     0.200
    15.210    39.923     0.200
    15.557    41.206     0.200
    16.127    41.136     0.200
    18.632    42.743     0.200
    18.807    44.158     0.200
    19.654    45.476     0.200
    19.759    42.241     0.200
    20.106    41.698     0.200
    20.106    42.096     0.200
     1.679     9.765     0.200
     1.810     8.788     0.200
     2.031    10.576     0.200
     2.279    13.178     0.200
     2.475    11.196     0.200
     2.832    11.738     0.200
     3.097    13.486     0.200
     3.178    14.779     0.200
     3.186    12.964     0.200
     3.295    12.771     0.200
     3.545    17.580     0.200
     3.813    14.994     0.200
     4.337    15.494     0.200
     4.765    19.938     0.200
     4.789    16.631     0.200
     8.825    27.331     0.200
    11.125    30.854     0.200
    17.120    39.216     0.200
    18.950    42.462     0.200
     1.658     9.569     0.200
     1.767    10.332     0.200
     2.096    10.923     0.200
     2.224    11.423     0.200
     2.261    11.657     0.200
     2.651    13.082     0.200
     4.845    19.008     0.200
     1.535     8.921     0.200
     1.534     9.421     0.200
     1.666     8.594     0.200
     2.147     9.356     0.200
     2.136    10.886     0.200
     2.578    12.088     0.200
     2.650    12.832     0.200
     3.018    13.877     0.200
     3.153     9.605     0.200
     4.895    17.410     0.200
    19.964    40.872     0.200
     1.490     8.142     0.200
     1.522     9.358     0.200
     1.730     7.978     0.200
     2.133    10.319     0.200
     2.145     9.095     0.200
     2.192    10.838     0.200
     2.594    11.971     0.200
     2.624    12.035     0.200
     3.104    10.988     0.200
     3.713    12.936     0.200
     3.953    14.764     0.200
     4.033    16.520     0.200
     4.946    16.360     0.200
     8.741    28.001     0.200
     9.573    28.104     0.200
    10.919    28.779     0.200
    13.733    35.518     0.200
    13.786    33.738     0.200
    14.966    36.672     0.200
    15.032    35.737     0.200
    19.022    44.987     0.200
    19.487    42.114     0.200
     1.384     7.538     0.200
     1.666     7.959     0.200
     1.647     9.548     0.200
     1.640     7.285     0.200
     2.003     7.500     0.200
     2.044     9.634     0.200
     2.306     9.227     0.200
     2.276    12.432     0.200
     2.727    10.874     0.200
     2.803    11.862     0.200
     2.861    10.937     0.200
     3.153    14.146     0.200
     3.232    13.584     0.200
     3.274    15.170     0.200
     3.707    13.169     0.200
     3.822    13.966     0.200
     4.206    13.342     0.200
     4.186    14.436     0.200
     4.783    18.198     0.200
     8.800    25.495     0.200
     9.405    26.363     0.200
     9.749    26.356     0.200
     9.749    25.614     0.200
     9.751    27.331     0.200
    10.526    26.987     0.200
    11.094    32.749     0.200
    11.094    29.944     0.200
    11.160    32.287     0.200
    12.150    27.839     0.200
    12.949    31.585     0.200
    13.516    31.990     0.200
    13.695    36.596     0.200
    14.045    36.023     0.200
    14.045    35.733     0.200
    14.220    35.767     0.200
    15.194    35.507     0.200
    15.194    37.100     0.200
    15.583    38.762     0.200
    16.317    37.505     0.200
    16.468    39.339     0.200
    18.650    40.773     0.200
    18.650    39.702     0.200
    18.947    42.008     0.200
    19.666    41.420     0.200
    19.666    39.240     0.200
    19.788    41.298     0.200
    20.008    39.727     0.200
    20.084    40.749     0.200
    20.120    38.851     0.200
    20.120    39.023     0.200
    20.117    42.557     0.200
    20.299    41.431     0.200
    20.463    40.912     0.200
    20.613    42.466     0.200
    20.675    38.748     0.200
    20.767    39.468     0.200
    20.771    39.126     0.200
    20.909    40.020     0.200
     1.644     7.566     0.200
     1.868    10.027     0.200
     2.001    11.042     0.200
     2.600    12.340     0.200
     3.079    12.907     0.200
     4.795    17.825     0.200
     1.463     9.728     0.200
     1.551     8.141     0.200
     1.568     9.726     0.200
     1.620     8.265     0.200
     2.126     9.261     0.200
     2.107    11.038     0.200
     2.245    13.528     0.200
     2.543    12.125     0.200
     2.649    12.029     0.200
     3.032    14.675     0.200
     3.856    17.321     0.200
     4.872    17.789     0.200
     1.491     9.294     0.200
     1.555     7.286     0.200
     1.536     8.768     0.200
     1.677     8.054     0.200
     2.106     9.959     0.200
     2.128    10.596     0.200
     2.188     9.852     0.200
     2.621    11.574     0.200
     2.682    12.243     0.200
     3.041    14.828     0.200
     4.881    18.273     0.200
     1.500     9.040     0.200
     1.534     8.805     0.200
     1.609     8.058     0.200
     1.606     9.420     0.200
     2.119     9.330     0.200
     2.063    10.507     0.200
     2.198     8.884     0.200
     2.235    12.560     0.200
     2.611    13.333     0.200
     2.718    11.273     0.200
     3.092    13.701     0.200
     3.822    15.500     0.200
     4.735    14.474     0.200
     4.820    17.097     0.200
     1.668     9.307     0.200
     1.646     8.404     0.200
     1.993     9.845     0.200
     2.046    10.840     0.200
     2.314    10.326     0.200
     2.736    12.928     0.200
     2.808    13.448     0.200
     3.155    15.414     0.200
     3.826    17.100     0.200
     4.784    18.175     0.200
    18.954    43.700     0.200
     1.659     8.296     0.200
     2.066    10.623     0.200
     2.311    13.548     0.200
     2.808    12.144     0.200
     3.263    12.934     0.200
    14.008    36.940     0.200
    18.983    44.281     0.200
    18.983    42.640     0.200
    19.672    40.879     0.200
    20.933    40.603     0.200
     1.496     9.435     0.200
     1.531     8.838     0.200
     1.556     8.682     0.200
     1.671     7.914     0.200
     2.111     9.877     0.200
     2.125    10.337     0.200
     2.184    10.109     0.200
     2.300    12.474     0.200
     3.042    13.689     0.200
     3.171    15.512     0.200
     3.171    13.434     0.200
     3.657    14.361     0.200
     4.099    14.390     0.200
    12.031    30.759     0.200
    12.856    34.373     0.200
    13.573    38.060     0.200
    13.723    35.419     0.200
    15.100    38.836     0.200
    15.100    37.356     0.200
    15.460    38.785     0.200
    15.460    35.980     0.200
    16.523    39.230     0.200
    18.701    43.209     0.200
    18.968    43.186     0.200
    19.996    40.100     0.200
    20.239    43.762     0.200
    20.682    40.993     0.200
    20.792    43.718     0.200
     1.515     9.718     0.200
     1.511     9.869     0.200
     1.529     8.136     0.200
     1.691     7.881     0.200
     2.150    10.908     0.200
     2.125    10.055     0.200
     2.164     9.149     0.200
     2.319    13.264     0.200
     2.656    12.180     0.200
     3.015    15.372     0.200
     3.145    14.176     0.200
     3.145    15.903     0.200
    13.750    33.707     0.200
    14.149    35.883     0.200
    14.930    37.574     0.200
     1.635     8.217     0.200
     1.883     8.023     0.200
     1.943    10.162     0.200
     1.953    12.281     0.200
     2.025    10.916     0.200
     2.559    11.695     0.200
     3.056    13.310     0.200
    20.397    41.640     0.200
     1.550     6.926     0.200
     1.543     8.690     0.200
     2.115    10.939     0.200
     2.658    11.361     0.200
     2.819    12.000     0.200
     3.033    14.108     0.200
     3.171    15.513     0.200
     3.547    13.691     0.200
     5.194    20.351     0.200
     6.330    21.639     0.200
     8.677    25.521     0.200
     9.256    29.493     0.200
     9.631    26.118     0.200
     9.631    25.715     0.200
     9.592    30.976     0.200
    10.363    27.469     0.200
    10.939    31.253     0.200
    11.001    32.435     0.200
    12.013    29.120     0.200
    12.862    32.764     0.200
    13.386    32.200     0.200
    13.534    37.168     0.200
    14.008    34.432     0.200
    13.911    36.584     0.200
    15.104    37.342     0.200
    16.265    38.696     0.200
    18.496    42.761     0.200
    18.749    40.304     0.200
    19.518    40.936     0.200
    19.626    40.574     0.200
    19.614    40.413     0.200
    19.846    39.911     0.200
    19.970    40.265     0.200
    20.261    40.563     0.200
    20.630    40.160     0.200
    20.747    40.991     0.200
    20.923    40.234     0.200
     1.680     8.497     0.200
     2.031    10.216     0.200
     2.817    12.504     0.200
     3.167    14.623     0.200
     4.769    20.750     0.200
     1.528     7.555     0.200
     2.107    10.513     0.200
     2.571    11.641     0.200
     2.993    11.432     0.200
     1.444     9.121     0.200
     1.637     9.475     0.200
     2.005    10.919     0.200
     2.697    11.742     0.200
     3.109    14.147     0.200
    19.993    40.699     0.200
     1.469     8.630     0.200
     1.553     6.845     0.200
     1.622     8.429     0.200
     1.791     8.965     0.200
     2.131     9.897     0.200
     2.106    10.232     0.200
     2.226     9.975     0.200
     2.179    10.510     0.200
     2.247    12.256     0.200
     2.653    11.392     0.200
     2.676    10.398     0.200
     3.034    12.377     0.200
     3.176    14.094     0.200
     3.176    12.725     0.200
     3.171    13.204     0.200
     3.378    13.674     0.200
     3.856    15.401     0.200
     4.296    15.501     0.200
    10.929    29.466     0.200
    12.010    27.376     0.200
    15.111    35.915     0.200
    18.912    41.730     0.200
    18.912    41.611     0.200
    19.612    39.661     0.200
    20.730    41.013     0.200
     1.483     9.781     0.200
     1.574     8.798     0.200
     1.601     7.328     0.200
     1.840     9.016     0.200
     2.056    11.024     0.200
     2.175    10.135     0.200
     2.153     9.964     0.200
     2.274    10.413     0.200
     2.650    11.329     0.200
     3.095    12.834     0.200
     3.121    12.933     0.200
     3.080    12.801     0.200
     3.224    14.788     0.200
     3.224    14.210     0.200
     3.418    13.173     0.200
     3.656    12.653     0.200
     3.691    16.538     0.200
     3.805    15.639     0.200
     4.113    15.499     0.200
     4.144    14.770     0.200
     4.696    15.217     0.200
     4.822    18.443     0.200
     5.136    23.068     0.200
     8.636    24.894     0.200
     9.284    28.841     0.200
     9.678    26.498     0.200
    13.875    36.215     0.200
    18.866    43.420     0.200
    18.866    42.576     0.200
    19.851    42.427     0.200
    20.744    40.587     0.200
     1.692     9.102     0.200
     1.696     9.487     0.200
     1.759     7.056     0.200
     2.078    10.533     0.200
     2.319    10.677     0.200
     2.342     9.987     0.200
     2.479    11.403     0.200
     2.816    11.585     0.200
     3.149    14.108     0.200
     3.144    12.596     0.200
     1.583     8.720     0.200
     1.584     8.210     0.200
     1.830     9.198     0.200
     2.071    11.007     0.200
     2.138    10.422     0.200
     2.258    10.910     0.200
     2.674    11.685     0.200
     2.666     9.916     0.200
     3.063    14.953     0.200
     1.665     7.702     0.200
     1.660     9.823     0.200
     1.654     9.007     0.200
     1.792     9.106     0.200
     1.988    10.482     0.200
     2.051    10.609     0.200
     2.329    11.109     0.200
     2.317    10.152     0.200
     2.290    12.968     0.200
     2.498    11.349     0.200
     2.808    11.847     0.200
     3.153    12.888     0.200
     3.117    13.486     0.200
     3.196    12.889     0.200
     3.271    15.821     0.200
     3.271    13.591     0.200
     3.832    15.900     0.200
     4.788    18.337     0.200
    18.962    42.931     0.200
     1.547     8.666     0.200
     1.819    10.763     0.200
     1.868    10.365     0.200
     1.873     9.821     0.200
     1.872    10.189     0.200
     1.956    10.233     0.200
     2.189    13.030     0.200
     2.494    10.492     0.200
     2.535    13.057     0.200
     3.012    13.495     0.200
     3.361    14.679     0.200
     8.866    26.849     0.200
    15.430    39.252     0.200
    18.855    42.827     0.200
     1.634    10.277     0.200
     1.788     9.037     0.200
     2.075    11.344     0.200
     2.147    11.883     0.200
     2.191    11.611     0.200
     2.418    13.155     0.200
     2.646    11.282     0.200
     2.642    12.830     0.200
     2.973    15.824     0.200
     3.089    13.042     0.200
     3.292    13.733     0.200
    15.458    37.798     0.200
     1.528     8.137     0.200
     1.577     8.787     0.200
     1.837    10.194     0.200
     2.033     9.007     0.200
     2.111    10.915     0.200
     2.205    11.020     0.200
     2.588    12.098     0.200
     2.998    15.281     0.200
    13.771    33.926     0.200
    13.788    39.854     0.200
    14.982    37.418     0.200
     1.434     7.719     0.200
     1.585     8.414     0.200
     1.562     6.583     0.200
     1.827     9.358     0.200
     2.102     9.542     0.200
     2.221    10.797     0.200
     2.237    10.329     0.200
     2.509    11.787     0.200
     2.643    11.393     0.200
     3.038    14.243     0.200
     3.187    12.892     0.200
     4.105    16.469     0.200
     8.602    24.258     0.200
    10.910    30.130     0.200
    13.740    32.188     0.200
    17.347    39.072     0.200
    19.165    40.338     0.200
    19.498    39.834     0.200
    20.694    39.520     0.200
     1.398     7.960     0.200
     1.610     7.315     0.200
     1.883     8.264     0.200
     2.044    10.557     0.200
     2.548    10.586     0.200
     2.546    11.238     0.200
     3.036    12.460     0.200
     3.703    16.247     0.200
     1.652     7.870     0.200
     1.795     9.358     0.200
     1.929     9.119     0.200
     2.084     9.588     0.200
     2.328    10.249     0.200
     2.595    12.250     0.200
     4.165    16.688     0.200
     1.637     9.362     0.200
     1.826     8.567     0.200
     2.096     9.700     0.200
     2.312    10.959     0.200
     2.559    12.854     0.200
     2.571    12.102     0.200
     3.057    14.824     0.200
    18.571    43.816     0.200
     1.699     8.280     0.200
     1.653     9.827     0.200
     1.950    10.420     0.200
     2.032    11.135     0.200
     2.847    12.220     0.200
     3.097    14.297     0.200
     3.187    12.890     0.200
     3.301    14.735     0.200
     3.301    14.630     0.200
     4.761    19.999     0.200
     1.456     8.793     0.200
     1.449     8.276     0.200
     1.570     7.455     0.200
     1.585     9.248     0.200
     2.117    10.083     0.200
     2.081    10.830     0.200
     2.245    10.634     0.200
     2.655    11.830     0.200
     3.048    12.782     0.200
     4.850    18.607     0.200
    18.872    43.153     0.200
     1.694     8.569     0.200
     1.701     8.785     0.200
     1.738     9.805     0.200
     2.062    10.979     0.200
     2.351    11.785     0.200
     2.341    13.413     0.200
     2.388    10.572     0.200
     2.858    12.699     0.200
     3.183    14.665     0.200
     1.529     7.725     0.200
     1.574     9.212     0.200
     1.679     8.632     0.200
     1.746     8.289     0.200
     2.192    10.897     0.200
     2.213    11.221     0.200
     2.178    11.032     0.200
     2.679    12.265     0.200
     2.615    10.259     0.200
     3.017    12.483     0.200
     3.135    12.345     0.200
     3.135    11.697     0.200
     3.245    12.360     0.200
     3.276    12.257     0.200
     3.578    14.773     0.200
     4.068    15.478     0.200
     4.453    15.319     0.200
     4.878    15.604     0.200
     8.420    25.266     0.200
     8.804    25.309     0.200
     9.611    23.328     0.200
    13.743    34.997     0.200
    19.046    42.925     0.200
     1.747    10.268     0.200
     2.118    11.422     0.200
     2.101    10.974     0.200
     2.578    12.376     0.200
     2.724    12.979     0.200
    19.441    41.195     0.200
     1.596     8.452     0.200
     1.695     7.677     0.200
     1.750     9.836     0.200
     2.304     9.987     0.200
     2.144    11.576     0.200
     2.386    13.984     0.200
     2.528    11.330     0.200
     2.761    13.116     0.200
     1.440     8.357     0.200
     1.549     7.970     0.200
     1.606     9.528     0.200
     1.806     9.688     0.200
     2.106    10.765     0.200
     2.103    10.714     0.200
     2.223    10.812     0.200
     2.638    11.756     0.200
     2.700    10.035     0.200
     3.027    13.050     0.200
     3.129    13.312     0.200
     3.120    12.870     0.200
     3.167    14.265     0.200
     3.365    16.023     0.200
     3.708    14.316     0.200
     3.847    16.032     0.200
     4.093    14.918     0.200
     5.337    20.052     0.200
    15.385    37.512     0.200
    15.385    38.877     0.200
    16.471    38.686     0.200
    19.494    41.719     0.200
     1.591     9.639     0.200
     1.663     8.980     0.200
     1.770    10.378     0.200
     2.202    11.066     0.200
     2.184    10.985     0.200
     2.251    11.306     0.200
     2.584    10.762     0.200
     3.304    13.547     0.200
     1.508     9.270     0.200
     1.613     9.336     0.200
     2.240    10.126     0.200
     2.225    11.672     0.200
     2.997    13.721     0.200
     3.105    13.012     0.200
     3.385    13.775     0.200
     3.659    12.956     0.200
     9.589    27.235     0.200
    10.990    29.651     0.200
    14.095    35.612     0.200
    14.155    36.450     0.200
    15.018    35.052     0.200
     1.446     8.505     0.200
     1.542     8.397     0.200
     1.592     8.409     0.200
     1.635     8.622     0.200
     1.785     9.133     0.200
     2.087    11.286     0.200
     2.201    10.807     0.200
     2.609    12.322     0.200
     2.710    11.859     0.200
     3.076    14.397     0.200
     3.208    15.501     0.200
     3.208    13.185     0.200
     3.431    14.955     0.200
     3.664    15.132     0.200
     4.135    15.293     0.200
     8.718    23.633     0.200
    10.994    28.825     0.200
    13.956    35.016     0.200
     1.808    10.749     0.200
     1.610     9.780     0.200
     2.072    11.575     0.200
     2.239    13.813     0.200
     2.623    11.133     0.200
     2.705    12.227     0.200
     3.080    14.728     0.200
     3.216    14.918     0.200
     3.428    17.080     0.200
     4.141    15.039     0.200
     4.831    21.108     0.200
    20.015    42.629     0.200
     1.559     8.143     0.200
     1.620     8.558     0.200
     1.793     9.086     0.200
     2.137    10.825     0.200
     2.232    11.340     0.200
     2.102    10.580     0.200
     2.246    12.837     0.200
     2.659    12.110     0.200
     2.670    12.646     0.200
     3.040    14.747     0.200
     3.139    13.027     0.200
     3.852    15.726     0.200
     4.740    14.993     0.200
     4.865    18.034     0.200
    19.969    40.286     0.200
     1.486     8.512     0.200
     1.640     9.017     0.200
     1.642     8.280     0.200
     2.058    10.352     0.200
     2.275    12.697     0.200
     2.275    10.649     0.200
     2.308    10.930     0.200
     2.536    13.088     0.200
     2.775    12.138     0.200
     3.124    13.907     0.200
     3.129    14.725     0.200
     3.178    13.137     0.200
     3.562    16.516     0.200
     3.832    18.008     0.200
     4.184    15.270     0.200
     1.400     7.939     0.200
     1.499     8.495     0.200
     1.625     9.029     0.200
     2.160     9.681     0.200
     2.242    10.726     0.200
     2.648    11.006     0.200
     2.677    11.574     0.200
     3.053    12.703     0.200
     3.148    11.568     0.200
     3.162    12.682     0.200
     4.114    15.728     0.200
    19.988    39.253     0.200
     1.559     8.881     0.200
     1.523     8.029     0.200
     1.638     9.832     0.200
     2.195     8.808     0.200
     2.310    10.462     0.200
     2.608    11.613     0.200
     3.090    13.828     0.200
     3.118    14.474     0.200
     3.259    15.515     0.200
     3.259    14.185     0.200
     4.181    17.478     0.200
     7.250    24.210     0.200
    13.216    32.794     0.200
    20.782    43.172     0.200
     1.434     7.715     0.200
     1.480     8.511     0.200
     1.382     6.848     0.200
     1.597     8.279     0.200
     2.146     8.863     0.200
     2.253     9.577     0.200
     2.659    13.233     0.200
     3.203    13.971     0.200
     3.203    10.877     0.200
     3.143    13.420     0.200
     3.402    14.168     0.200
     4.124    15.169     0.200
     4.718    15.155     0.200
     8.647    22.452     0.200
     9.659    25.537     0.200
    10.949    25.890     0.200
    13.713    32.732     0.200
    13.884    31.868     0.200
    14.508    33.015     0.200
    14.900    37.096     0.200
    15.139    34.718     0.200
    17.305    37.357     0.200
    18.791    39.870     0.200
    19.845    40.567     0.200
    19.962    42.199     0.200
    19.984    39.436     0.200
    19.984    40.147     0.200
    20.741    39.512     0.200
     1.585     6.690     0.200
     1.352     7.556     0.200
     1.574     8.579     0.200
     2.090     9.075     0.200
     2.128     9.903     0.200
     2.259    10.348     0.200
     2.199    10.768     0.200
     2.199    11.955     0.200
     3.210    13.428     0.200
     3.132    13.676     0.200
     4.287    15.602     0.200
     4.836    17.268     0.200
     7.196    22.821     0.200
    14.118    37.507     0.200
    19.525    39.819     0.200
     1.608     8.516     0.200
     1.588     8.403     0.200
     2.040    10.221     0.200
     2.169     9.949     0.200
     2.260    11.032     0.200
     3.070    15.149     0.200
     3.416    13.936     0.200
     3.671    16.170     0.200
     4.132    15.555     0.200
     1.618     8.890     0.200
     1.693     7.789     0.200
     1.918     8.402     0.200
     2.368    10.891     0.200
     2.492    10.001     0.200
     3.358    14.449     0.200
     1.486     8.787     0.200
     2.040    10.334     0.200
     2.220    11.792     0.200
     2.276    11.512     0.200
     3.061    15.465     0.200
     4.135    17.761     0.200
     7.060    25.367     0.200
    18.754    45.388     0.200
    19.917    41.266     0.200
     1.612     8.170     0.200
     1.563     8.946     0.200
     1.919     9.429     0.200
     2.289    10.740     0.200
     2.379     9.945     0.200
     3.046    13.860     0.200
     3.241    11.551     0.200
     6.880    24.118     0.200
     1.513     8.977     0.200
     1.533     8.962     0.200
     1.739     9.364     0.200
     1.908     8.761     0.200
     2.178    11.945     0.200
     2.186    10.187     0.200
     3.371    12.399     0.200
     3.570    13.862     0.200
     4.931    19.022     0.200
     1.521     8.915     0.200
     1.641     9.961     0.200
     1.668     9.130     0.200
     1.773     9.663     0.200
     1.773     9.943     0.200
     2.305    11.387     0.200
     2.305    11.787     0.200
     2.297    10.521     0.200
     3.129    16.406     0.200
     3.208    13.344     0.200
     3.500    13.089     0.200
     3.500    13.509     0.200
     3.688    14.832     0.200
     3.851    15.777     0.200
     4.105    17.323     0.200
     4.181    16.702     0.200
     4.181    16.842     0.200
     4.368    16.382     0.200
     4.478    15.999     0.200
     4.811    18.622     0.200
     4.811    16.237     0.200
     6.221    21.612     0.200
     7.398    24.273     0.200
     8.813    26.796     0.200
     9.396    27.042     0.200
     9.472    28.632     0.200
     9.724    27.313     0.200
    11.079    34.000     0.200
    12.128    30.858     0.200
    13.493    33.030     0.200
    13.685    38.784     0.200
    14.054    37.508     0.200
    14.888    39.945     0.200
    15.166    37.852     0.200
    15.166    35.002     0.200
    15.572    37.616     0.200
    18.635    43.708     0.200
    18.811    44.269     0.200
    19.243    41.222     0.200
    19.771    43.961     0.200
    19.999    41.902     0.200
    20.078    41.788     0.200
    20.102    42.252     0.200
    20.102    41.202     0.200
    20.278    41.946     0.200
    20.904    41.738     0.200
    20.904    42.148     0.200
     1.521     7.946     0.200
     1.415     7.545     0.200
     1.694     8.156     0.200
     2.281    10.023     0.200
     2.378    10.416     0.200
     2.385    10.898     0.200
     2.714    10.364     0.200
     2.919    11.019     0.200
     3.132    12.003     0.200
     3.344    10.919     0.200
     5.704    18.086     0.200
     5.815    19.056     0.200
     7.756    23.390     0.200
     8.879    23.413     0.200
     8.879    24.433     0.200
     8.954    24.757     0.200
     9.254    27.095     0.200
    10.632    25.866     0.200
    11.929    28.769     0.200
    14.182    33.302     0.200
    14.453    37.298     0.200
    14.528    34.506     0.200
    15.278    36.128     0.200
    16.493    38.400     0.200
    16.669    35.825     0.200
    17.576    38.904     0.200
    18.147    36.899     0.200
    19.055    38.278     0.200
    19.537    40.256     0.200
     1.551     8.775     0.200
     1.970    10.186     0.200
     2.184    10.851     0.200
     2.184    11.578     0.200
     2.129    11.215     0.200
     2.173    12.249     0.200
     2.600    11.725     0.200
     3.137    10.947     0.200
     4.658    20.193     0.200
     5.341    19.829     0.200
    19.835    41.140     0.200
     1.194     7.114     0.200
     1.907     7.888     0.200
     2.317    11.750     0.200
     2.557    11.000     0.200
     2.556    11.467     0.200
     5.349    16.013     0.200
     7.748    24.078     0.200
     8.346    26.800     0.200
     8.487    22.658     0.200
     8.488    22.866     0.200
    10.197    29.194     0.200
    12.348    32.294     0.200
    12.510    34.606     0.200
    12.709    35.880     0.200
    13.298    35.202     0.200
    13.388    35.957     0.200
    13.480    35.980     0.200
    13.432    36.246     0.200
    13.923    35.912     0.200
    14.604    37.166     0.200
    14.806    36.906     0.200
    15.124    37.197     0.200
    15.310    37.731     0.200
    18.118    40.775     0.200
    18.646    39.500     0.200
    18.774    39.503     0.200
    19.082    38.512     0.200
    19.232    39.077     0.200
    19.232    39.651     0.200
    19.906    38.462     0.200
    20.167    39.842     0.200
    20.562    39.336     0.200
     1.788     8.459     0.200
     2.321     9.329     0.200
     2.573    13.061     0.200
     2.608    11.094     0.200
     2.814    10.925     0.200
     2.866    13.073     0.200
     2.866    12.604     0.200
     7.658    23.846     0.200
     9.370    24.140     0.200
    12.475    30.577     0.200
    19.513    40.372     0.200
     1.419     8.279     0.200
     1.639     9.798     0.200
     2.022    10.085     0.200
     2.140    10.580     0.200
     2.140    11.350     0.200
     2.117    10.378     0.200
     2.219    11.138     0.200
     2.654    11.655     0.200
     2.819    12.207     0.200
     3.030    14.222     0.200
     1.361     8.792     0.200
     1.473     8.295     0.200
     1.577     9.198     0.200
     1.837     9.612     0.200
     2.063    11.164     0.200
     2.081    10.077     0.200
     2.184    10.941     0.200
     2.143    10.841     0.200
     2.266    10.756     0.200
     2.681    11.624     0.200
     2.880    12.619     0.200
     1.499     9.179     0.200
     1.542     7.476     0.200
     1.572     9.118     0.200
     1.840    10.461     0.200
     2.052    10.270     0.200
     2.127    10.536     0.200
     2.099    10.903     0.200
     2.218    10.862     0.200
     2.606    11.929     0.200
     2.873    12.591     0.200
     3.013    11.142     0.200
     4.083    18.170     0.200
     4.875    17.442     0.200
     1.546     7.862     0.200
     1.704     9.110     0.200
     1.824     9.710     0.200
     1.930     9.521     0.200
     2.262    10.795     0.200
     2.445    11.607     0.200
     2.924    12.858     0.200
     3.276    13.615     0.200
     3.385    12.541     0.200
     1.499     8.711     0.200
     1.650     7.205     0.200
     2.132    10.250     0.200
     2.219    11.012     0.200
     2.237    11.770     0.200
     2.466    13.154     0.200
     2.643    13.039     0.200
     1.663     8.545     0.200
     1.668     9.143     0.200
     1.665    10.137     0.200
     2.059    12.153     0.200
     2.323    13.026     0.200
     2.842    14.275     0.200
     3.151    15.544     0.200
     1.336     7.090     0.200
     1.630     8.337     0.200
     1.625     7.688     0.200
     1.808     9.691     0.200
     2.036    10.260     0.200
     2.449    10.452     0.200
     2.452    11.635     0.200
     2.553    11.472     0.200
     2.693    11.808     0.200
     2.776    12.158     0.200
     2.907    11.230     0.200
     3.035    12.348     0.200
     3.241    14.304     0.200
     3.517    14.749     0.200
     3.853    14.723     0.200
     3.804    14.450     0.200
     5.174    19.070     0.200
     5.661    19.319     0.200
     7.480    22.322     0.200
     8.982    25.084     0.200
     9.401    24.924     0.200
    13.313    29.592     0.200
    13.937    34.577     0.200
    14.804    34.652     0.200
    19.408    39.512     0.200
     1.436     7.980     0.200
     1.466     8.274     0.200
     1.569     7.680     0.200
     1.600     8.938     0.200
     2.063    10.661     0.200
     2.087    10.856     0.200
     2.132    10.524     0.200
     2.132    11.075     0.200
     2.662    12.235     0.200
     2.855    12.670     0.200
     3.049    14.665     0.200
     3.166    13.870     0.200
     1.439     7.959     0.200
     1.471     7.775     0.200
     1.577     7.498     0.200
     1.564     8.612     0.200
     1.594     9.286     0.200
     2.066    10.263     0.200
     2.080    10.666     0.200
     2.137    10.905     0.200
     2.183    12.114     0.200
     2.669    11.906     0.200
     2.862    12.850     0.200
     3.056    14.804     0.200
     3.173    14.046     0.200
     1.449     7.505     0.200
     1.465     8.392     0.200
     1.579     7.307     0.200
     1.572     9.457     0.200
     1.826     9.662     0.200
     2.076    10.609     0.200
     2.076    11.060     0.200
     2.253    11.295     0.200
     2.476    12.522     0.200
     2.540    12.613     0.200
     2.668    12.024     0.200
     2.637    13.181     0.200
     2.869    12.444     0.200
     3.058    13.809     0.200
     3.203    12.878     0.200
     1.445     8.665     0.200
     1.505     9.328     0.200
     1.524     8.725     0.200
     1.572     8.337     0.200
     1.773     9.636     0.200
     2.103    10.828     0.200
     2.122    11.245     0.200
     2.230    12.304     0.200
     2.242    11.527     0.200
     2.464    12.953     0.200
     2.689    12.201     0.200
     2.822    12.178     0.200
     3.138    13.903     0.200
     3.169    13.861     0.200
     1.942    10.865     0.200
     2.156    12.337     0.200
     2.176    11.470     0.200
     2.749    13.340     0.200
     4.929    21.271     0.200
     1.278     6.598     0.200
     1.650     8.097     0.200
     1.565     9.220     0.200
     1.818     9.338     0.200
     2.201     9.948     0.200
     2.327    10.887     0.200
     2.330     9.389     0.200
     2.419    11.612     0.200
     2.426    10.814     0.200
     2.643    12.137     0.200
     2.734    11.716     0.200
     2.703    11.494     0.200
     3.255    12.324     0.200
     3.367    12.754     0.200
     3.578    15.088     0.200
     3.683    15.169     0.200
     3.976    14.447     0.200
     4.024    14.713     0.200
     4.466    15.950     0.200
     5.579    18.265     0.200
     5.885    21.185     0.200
     1.435     8.655     0.200
     1.442     9.153     0.200
     1.546     7.762     0.200
     1.590     9.474     0.200
     1.611     9.246     0.200
     2.063    10.549     0.200
     2.107    10.057     0.200
     2.107    11.391     0.200
     2.841    12.749     0.200
     1.395     7.801     0.200
     1.528     9.240     0.200
     1.814     9.147     0.200
     2.296     9.763     0.200
     2.240    11.191     0.200
     2.352    11.659     0.200
     2.599    12.386     0.200
     2.706     9.330     0.200
     2.706    10.104     0.200
     2.706    11.534     0.200
     2.706     8.932     0.200
     2.706    10.244     0.200
     5.865    19.647     0.200
     6.023    16.323     0.200
     7.829    21.533     0.200
     8.323    20.358     0.200
     9.138    22.980     0.200
     9.209    21.323     0.200
     9.209    24.643     0.200
     9.209    21.940     0.200
     9.395    24.577     0.200
     9.507    21.707     0.200
     9.661    27.674     0.200
     9.661    28.604     0.200
    10.911    24.818     0.200
    10.911    30.287     0.200
    10.911    27.482     0.200
    10.911    31.545     0.200
    11.739    24.336     0.200
    12.247    28.299     0.200
    13.051    26.910     0.200
    13.051    27.285     0.200
    13.572    30.232     0.200
    13.572    32.990     0.200
    13.542    28.376     0.200
    13.540    35.601     0.200
    13.545    31.667     0.200
    13.675    32.724     0.200
    14.122    32.041     0.200
    14.122    35.916     0.200
    14.453    32.150     0.200
    14.453    35.486     0.200
    14.509    30.673     0.200
    14.500    33.804     0.200
    14.571    34.515     0.200
    14.725    33.700     0.200
    14.985    35.241     0.200
    15.251    36.932     0.200
    15.520    35.100     0.200
    15.529    34.895     0.200
    16.092    34.923     0.200
    16.092    35.048     0.200
    17.306    35.917     0.200
    17.306    36.847     0.200
    18.436    38.872     0.200
    19.361    37.178     0.200
    19.477    36.519     0.200
     1.507     8.868     0.200
     1.718     9.683     0.200
     2.484    11.579     0.200
     2.535    12.161     0.200
     2.671    13.556     0.200
     2.795    12.871     0.200
     1.416     7.638     0.200
     1.486     7.768     0.200
     1.565     7.416     0.200
     1.623     9.122     0.200
     1.700     7.559     0.200
     1.690     9.310     0.200
     1.844     9.473     0.200
     2.088     9.965     0.200
     2.114     9.920     0.200
     2.242    10.994     0.200
     2.241    10.652     0.200
     2.283    12.062     0.200
     2.334    10.197     0.200
     2.635    12.910     0.200
     2.638    11.812     0.200
     2.699    12.821     0.200
     2.748    13.129     0.200
     2.881    12.214     0.200
     3.039    12.362     0.200
     3.147    13.269     0.200
     3.192    13.152     0.200
     3.186    13.489     0.200
     4.107    16.190     0.200
    15.133    37.037     0.200
     1.390     7.092     0.200
     1.424     8.473     0.200
     1.487     8.375     0.200
     1.550     6.989     0.200
     1.588     9.086     0.200
     1.728     7.748     0.200
     1.773     9.173     0.200
     1.880     8.311     0.200
     2.017    10.265     0.200
     2.159    11.157     0.200
     2.145    10.113     0.200
     2.225    11.599     0.200
     2.222    10.691     0.200
     2.253     9.830     0.200
     2.492     9.985     0.200
     2.658    13.157     0.200
     2.672    12.840     0.200
     2.664    11.327     0.200
     2.658    11.453     0.200
     2.681    13.516     0.200
     2.818    13.086     0.200
     2.874    12.366     0.200
     3.032    13.099     0.200
     3.131    13.379     0.200
     3.170    12.094     0.200
     3.170    11.390     0.200
     3.170    15.199     0.200
     3.381    15.888     0.200
     3.632    14.500     0.200
     3.870    14.215     0.200
     4.094    18.253     0.200
     4.298    12.817     0.200
     4.353    15.693     0.200
     4.762    16.330     0.200
     5.243    17.727     0.200
     5.417    22.006     0.200
     6.330    20.824     0.200
     6.384    22.689     0.200
     7.230    22.227     0.200
     8.705    25.007     0.200
     9.016    26.883     0.200
     9.008    29.874     0.200
     9.131    30.133     0.200
     9.446    30.663     0.200
     9.633    28.876     0.200
     9.631    24.785     0.200
    10.020    27.467     0.200
    12.747    36.237     0.200
    12.988    36.423     0.200
    13.601    38.973     0.200
    13.723    39.050     0.200
    14.182    37.799     0.200
    14.526    37.019     0.200
    14.921    38.037     0.200
    16.264    37.793     0.200
    16.307    39.498     0.200
    18.453    41.456     0.200
    18.527    42.091     0.200
    18.715    41.890     0.200
    18.722    41.816     0.200
    18.866    42.331     0.200
    18.941    41.659     0.200
     1.026     6.085     0.200
     1.058     5.446     0.200
     1.134     4.807     0.200
     1.143     7.380     0.200
     1.194     7.273     0.200
     1.359     7.546     0.200
     1.367     6.679     0.200
     1.493     6.626     0.200
     1.456     8.263     0.200
     1.558     6.987     0.200
     1.480     8.432     0.200
     1.732     8.419     0.200
     1.820     7.854     0.200
     1.918     8.145     0.200
     1.921     8.461     0.200
     2.006     9.192     0.200
     1.999     9.325     0.200
     2.016     7.224     0.200
     2.118     8.672     0.200
     2.124     9.062     0.200
     2.282     8.019     0.200
     2.522    11.877     0.200
     2.630     9.032     0.200
     2.697    10.405     0.200
     2.819    11.399     0.200
     2.953    11.005     0.200
     3.362    12.498     0.200
     3.610    12.466     0.200
     3.874    14.681     0.200
     4.419    14.771     0.200
     1.281     7.178     0.200
     1.511     8.337     0.200
     1.530     8.541     0.200
     1.583     8.584     0.200
     1.680     7.300     0.200
     1.780     8.967     0.200
     1.735     5.956     0.200
     1.819     9.281     0.200
     1.981     9.973     0.200
     1.953     9.469     0.200
     2.205    10.175     0.200
     2.130    11.006     0.200
     2.200     9.733     0.200
     2.286    10.021     0.200
     2.366    10.045     0.200
     2.453    10.833     0.200
     2.435    10.434     0.200
     2.435    10.962     0.200
     2.522    11.148     0.200
     2.641    11.930     0.200
     2.729    11.777     0.200
     2.804    10.779     0.200
     3.023    12.761     0.200
     3.069    11.451     0.200
     3.335    12.752     0.200
     3.390    13.068     0.200
     3.331    11.126     0.200
     3.343    13.693     0.200
     3.597    15.415     0.200
     3.764    14.862     0.200
     3.868    12.149     0.200
     4.014    14.903     0.200
     4.554    16.492     0.200
     4.781    18.253     0.200
     5.167    17.336     0.200
     5.758    20.766     0.200
     6.238    21.150     0.200
     6.687    22.953     0.200
     7.280    22.550     0.200
     7.796    22.751     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     5.792    44.412     0.200
     4.188    29.983     0.200
     3.240    22.926     0.200
     3.548    25.325     0.200
     2.662    19.703     0.200
     4.840    31.166     0.200
     2.844    19.485     0.200
     2.585    22.033     0.200
     3.126    20.366     0.200
     3.086    21.495     0.200
     3.174    22.473     0.200
     6.335    48.198     0.200
     2.957    19.732     0.200
     3.000    21.373     0.200
     3.104    24.142     0.200
     3.026    20.954     0.200
     4.031    31.024     0.200
     3.988    31.574     0.200
     3.274    22.661     0.200
     3.233    21.769     0.200
     3.171    24.254     0.200
     3.288    24.749     0.200
     3.253    23.689     0.200
     2.640    17.992     0.200
     3.710    24.417     0.200
     3.071    22.844     0.200
     2.750    18.792     0.200
     3.151    24.247     0.200
     3.056    21.017     0.200
     3.470    23.546     0.200
     4.007    25.962     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.960     5.501     0.200
     0.917     6.195     0.200
     0.788     5.487     0.200
     0.784     5.430     0.200
     0.848     6.117     0.200
     1.059     7.147     0.200
     1.038     7.000     0.200
     2.437    16.164     0.200
     3.247    18.721     0.200
     1.079     7.338     0.200
     0.832     5.838     0.200
     1.062     7.156     0.200
     0.879     5.927     0.200
     0.848     5.894     0.200
     2.479    14.359     0.200
     3.136    18.195     0.200
     0.868     5.945     0.200
     0.936     6.154     0.200
     0.516     3.594     0.200
     1.778    11.069     0.200
     4.642    23.937     0.200
     0.999     6.930     0.200
     1.084     6.944     0.200
     0.679     3.728     0.200
     0.825     6.023     0.200
     1.110     7.708     0.200
     2.393    14.225     0.200
     3.244    17.795     0.200
     3.286    17.703     0.200
     5.520    32.236     0.200
     0.669     4.046     0.200
     0.862     5.293     0.200
     1.072     7.341     0.200
     1.323     9.420     0.200
     2.030    12.164     0.200
     0.598     3.765     0.200
     1.011     6.947     0.200
     1.041     6.703     0.200
     1.364     9.826     0.200
     2.776    14.348     0.200
     3.123    17.505     0.200
     1.244     8.215     0.200
     0.596     3.177     0.200
     0.704     5.122     0.200
     0.911     6.407     0.200
     0.936     6.610     0.200
     0.586     3.102     0.200
     0.654     5.101     0.200
     0.956     6.081     0.200
     0.989     6.098     0.200
     1.362     9.136     0.200
     0.710     4.738     0.200
     0.909     6.216     0.200
     0.922     6.664     0.200
     2.842    15.457     0.200
     0.442     3.139     0.200
     0.956     5.094     0.200
     1.190     7.192     0.200
     0.540     4.282     0.200
     0.666     4.583     0.200
     2.248    12.764     0.200
     0.292     3.910     0.200
     1.175     7.267     0.200
     1.308     7.516     0.200
     0.316     4.034     0.200
     0.831     5.442     0.200
     0.839     5.800     0.200
     1.180     7.228     0.200
     1.522    10.490     0.200
     0.171     1.788     0.200
     0.858     4.210     0.200
     0.776     5.603     0.200
     0.891     5.341     0.200
     1.085     7.451     0.200
     1.550    10.487     0.200
     1.792    11.355     0.200
     0.347     2.648     0.200
     0.842     6.007     0.200
     1.011     7.501     0.200
     1.192     7.673     0.200
     1.492     9.278     0.200
     3.162    16.064     0.200
     4.036    21.696     0.200
     5.062    28.632     0.200
     1.007     7.751     0.200
     1.016     7.603     0.200
     1.102     7.674     0.200
     1.275     8.509     0.200
     1.489     9.862     0.200
     3.934    21.648     0.200
     0.864     5.768     0.200
     0.865     6.026     0.200
     1.179     8.219     0.200
     1.312     8.675     0.200
     0.327     4.057     0.200
     0.827     5.437     0.200
     0.844     5.475     0.200
     1.192     7.554     0.200
     2.904    16.086     0.200
     0.395     3.558     0.200
     0.714     4.973     0.200
     0.753     5.415     0.200
     1.060     8.126     0.200
     1.273     7.018     0.200
     0.204     3.093     0.200
     0.539     3.925     0.200
     1.023     6.703     0.200
     1.036     6.110     0.200
     1.099     6.715     0.200
     1.262     7.739     0.200
     0.527     3.959     0.200
     1.232     8.482     0.200
     1.267     8.268     0.200
     0.235     2.120     0.200
     0.684     4.234     0.200
     0.862     5.637     0.200
     0.854     5.287     0.200
     1.299     7.915     0.200
     2.007    13.388     0.200
     0.392     3.639     0.200
     0.761     4.881     0.200
     0.797     5.574     0.200
     1.034     7.318     0.200
     1.349     7.886     0.200
     0.481     4.966     0.200
     0.654     4.590     0.200
     0.758     5.352     0.200
     0.485     4.342     0.200
     0.648     4.793     0.200
     0.752     5.633     0.200
     1.334     7.908     0.200
     0.518     4.705     0.200
     1.406     7.984     0.200
     0.262     2.377     0.200
     1.112     6.687     0.200
     1.170     7.559     0.200
     1.189     8.025     0.200
     2.892    17.624     0.200
     1.126     7.424     0.200
     3.833    24.448     0.200
     0.494     3.832     0.200
     0.648     4.586     0.200
     0.763     5.060     0.200
     1.273     8.556     0.200
     0.550     4.701     0.200
     0.711     4.944     0.200
     0.736     4.516     0.200
     1.042     5.202     0.200
     2.346    12.225     0.200
     0.353     3.940     0.200
     0.934     6.006     0.200
     1.041     6.388     0.200
     1.126     5.188     0.200
     2.708    15.439     0.200
     0.463     3.957     0.200
     0.508     3.660     0.200
     0.888     6.076     0.200
     0.943     6.219     0.200
     1.042     5.397     0.200
     2.618    13.234     0.200
     0.988     7.121     0.200
     1.008     5.918     0.200
     1.069     7.450     0.200
     1.247     8.254     0.200
     1.308     7.372     0.200
     1.492     9.091     0.200
     1.951    11.820     0.200
     2.281    13.128     0.200
     2.373    12.416     0.200
     0.488     3.731     0.200
     2.749    16.981     0.200
     2.769    16.715     0.200
     1.266     7.815     0.200
     0.293     2.773     0.200
     0.437     3.363     0.200
     0.804     5.366     0.200
     0.764     5.360     0.200
     1.132     8.050     0.200
     0.303     2.020     0.200
     0.204     2.089     0.200
     0.636     4.988     0.200
     1.237     8.233     0.200
     0.352     2.513     0.200
     0.700     4.814     0.200
     0.763     5.955     0.200
     0.745     4.819     0.200
     1.077     6.325     0.200
     1.166     7.962     0.200
     0.211     1.906     0.200
     0.468     3.584     0.200
     0.911     6.764     0.200
     0.245     1.944     0.200
     0.833     6.150     0.200
     0.938     6.346     0.200
     1.291     8.445     0.200
     2.128    11.597     0.200
     0.398     3.013     0.200
     0.740     5.272     0.200
     3.121    16.319     0.200
     0.670     4.727     0.200
     0.336     2.446     0.200
     0.725     4.430     0.200
     1.110     8.356     0.200
     1.126     7.635     0.200
     3.140    16.197     0.200
     0.344     2.133     0.200
     0.711     4.824     0.200
     1.121     8.348     0.200
     2.527    13.847     0.200
     0.362     3.298     0.200
     0.404     2.824     0.200
     1.199     8.301     0.200
     2.208    13.745     0.200
     3.153    18.419     0.200
     0.212     0.975     0.200
     0.427     3.143     0.200
     0.819     6.532     0.200
     1.025     6.773     0.200
     1.969    12.015     0.200
     0.422     3.226     0.200
     0.850     6.229     0.200
     0.981     6.762     0.200
     2.470    14.178     0.200
     0.326     3.522     0.200
     0.350     2.764     0.200
     1.004     6.928     0.200
     0.235     2.381     0.200
     0.444     3.558     0.200
     0.872     6.054     0.200
     0.931     7.282     0.200
     1.309     8.194     0.200
     0.208     2.350     0.200
     0.628     4.524     0.200
     0.213     2.442     0.200
     0.465     3.471     0.200
     0.886     5.887     0.200
     2.721    14.996     0.200
     2.721    15.536     0.200
     0.186     1.936     0.200
     0.611     4.464     0.200
     0.615     4.348     0.200
     1.211     8.444     0.200
     1.211     8.584     0.200
     1.568     9.252     0.200
     1.568     9.382     0.200
     1.927    11.023     0.200
     2.252    11.882     0.200
     3.265    17.079     0.200
     0.859     6.665     0.200
     0.942     5.935     0.200
     1.368     7.974     0.200
     3.142    16.750     0.200
     0.367     2.640     0.200
     0.403     3.184     0.200
     0.276     2.178     0.200
     0.412     2.981     0.200
     0.841     5.790     0.200
     1.267     8.448     0.200
     3.063    15.400     0.200
     3.206    19.347     0.200
     0.423     3.142     0.200
     0.861     5.989     0.200
     0.947     6.430     0.200
     1.287     8.203     0.200
     3.158    15.823     0.200
     0.375     2.887     0.200
     0.847     5.180     0.200
     0.978     7.330     0.200
     1.243     8.046     0.200
     1.243     8.516     0.200
     3.102    16.331     0.200
     0.323     2.389     0.200
     0.678     4.387     0.200
     1.070     8.002     0.200
     1.170     7.262     0.200
     2.044    11.711     0.200
     0.924     6.801     0.200
     1.330     8.042     0.200
     1.799     9.759     0.200
     0.567     4.551     0.200
     2.034    11.582     0.200
     3.002    15.647     0.200
     3.204    17.397     0.200
     0.847     5.708     0.200
     0.955     6.539     0.200
     1.288     8.232     0.200
     3.142    15.254     0.200
     3.186    16.115     0.200
     0.965     6.826     0.200
     1.375     8.472     0.200
     0.756     5.476     0.200
     3.126    16.806     0.200
     0.562     3.864     0.200
     0.734     5.458     0.200
     3.178    19.491     0.200
     3.178    16.920     0.200
     0.328     2.110     0.200
     0.683     4.958     0.200
     1.079     7.411     0.200
     0.290     2.127     0.200
     0.712     4.994     0.200
     1.070     6.903     0.200
     1.152     7.599     0.200
     1.359     8.367     0.200
     3.271    18.045     0.200
     0.587     4.691     0.200
     0.651     5.138     0.200
     0.538     4.089     0.200
     0.721     5.333     0.200
     0.460     3.487     0.200
     3.025    15.301     0.200
     0.362     2.349     0.200
     0.698     4.827     0.200
     1.125     7.950     0.200
     0.469     2.631     0.200
     1.072     8.448     0.200
     2.172    13.281     0.200
     3.087    17.250     0.200
     0.589     3.950     0.200
     0.638     4.742     0.200
     1.187     8.217     0.200
     3.220    18.765     0.200
     0.388     2.921     0.200
     0.867     5.513     0.200
     0.954     5.696     0.200
     3.194    16.085     0.200
     5.120    26.382     0.200
     0.459     3.484     0.200
     1.321     8.660     0.200
     1.606     9.764     0.200
     2.094    12.420     0.200
     2.505    13.691     0.200
     3.023    15.375     0.200
     3.171    16.044     0.200
     5.184    29.461     0.200
     0.474     2.943     0.200
     1.268     8.133     0.200
     2.181    15.146     0.200
     0.415     3.107     0.200
     0.720     5.023     0.200
     1.188     7.524     0.200
     3.142    20.189     0.200
     3.184    17.439     0.200
     6.364    34.829     0.200
     0.384     2.717     0.200
     0.682     4.559     0.200
     1.131     6.797     0.200
     1.403     8.873     0.200
     3.218    18.558     0.200
     0.530     4.031     0.200
     0.842     6.882     0.200
     1.410     9.831     0.200
     2.008    11.669     0.200
     2.182    13.295     0.200
     2.415    13.463     0.200
     0.665     4.522     0.200
     1.257     8.437     0.200
     2.304    14.378     0.200
     0.429     3.609     0.200
     0.817     6.143     0.200
     1.367     8.607     0.200
     1.430     9.429     0.200
     1.970    11.559     0.200
     3.030    15.747     0.200
     3.249    18.152     0.200
     0.425     3.178     0.200
     0.701     4.784     0.200
     1.182     7.174     0.200
     1.450     9.231     0.200
     3.201    17.225     0.200
     0.777     4.702     0.200
     1.063     6.688     0.200
     1.160     7.298     0.200
     3.142    16.179     0.200
     3.231    17.936     0.200
     0.471     3.840     0.200
     0.573     4.395     0.200
     0.668     4.641     0.200
     3.197    17.785     0.200
     0.504     3.315     0.200
     0.768     5.573     0.200
     1.017     7.412     0.200
     1.290     7.557     0.200
     3.056    19.509     0.200
     0.502     3.813     0.200
     0.809     6.575     0.200
     0.992     6.800     0.200
     1.410     8.867     0.200
     0.437     2.751     0.200
     0.654     4.035     0.200
     1.153     7.670     0.200
     1.414     9.296     0.200
     3.126    20.183     0.200
     0.383     2.729     0.200
     0.443     3.174     0.200
     0.676     5.003     0.200
     1.125     7.113     0.200
     0.358     2.283     0.200
     0.423     3.267     0.200
     0.710     5.136     0.200
     1.116     7.871     0.200
     1.411     8.715     0.200
     3.486    18.576     0.200
     0.292     2.679     0.200
     0.432     3.080     0.200
     0.808     5.550     0.200
     0.992     7.483     0.200
     1.263     7.725     0.200
     1.544     9.636     0.200
     3.133    19.776     0.200
     3.177    15.925     0.200
     0.335     2.431     0.200
     0.450     3.549     0.200
     0.698     4.836     0.200
     1.101     6.705     0.200
     1.140     7.877     0.200
     3.225    19.166     0.200
     3.267    18.921     0.200
     3.267    20.535     0.200
     0.420     3.193     0.200
     0.437     2.919     0.200
     0.674     4.491     0.200
     0.191     1.914     0.200
     0.549     4.339     0.200
     0.688     4.952     0.200
     1.253     8.673     0.200
     1.852    11.315     0.200
     0.255     2.474     0.200
     0.425     3.161     0.200
     0.858     5.963     0.200
     0.949     7.406     0.200
     1.288     8.396     0.200
     0.338     2.377     0.200
     1.154     8.882     0.200
     1.369     8.810     0.200
     3.225    17.517     0.200
     0.163     1.775     0.200
     0.572     4.158     0.200
     0.675     4.885     0.200
     2.031    12.169     0.200
     2.251    14.349     0.200
     3.262    17.092     0.200
     0.341     2.398     0.200
     0.464     3.142     0.200
     0.682     4.747     0.200
     1.091     6.783     0.200
     1.155     8.149     0.200
     1.369     8.850     0.200
     3.518    19.152     0.200
     0.322     2.762     0.200
     0.470     3.434     0.200
     3.282    16.774     0.200
     3.282    18.157     0.200
     3.823    19.615     0.200
     3.823    22.982     0.200
     0.351     2.541     0.200
     0.398     2.628     0.200
     0.761     5.286     0.200
     1.205     7.952     0.200
     1.777    11.620     0.200
     2.203    12.795     0.200
     4.847    29.198     0.200
     0.387     3.093     0.200
     0.397     2.789     0.200
     0.723     5.118     0.200
     1.451     9.459     0.200
     0.150     1.835     0.200
     0.481     3.581     0.200
     0.816     6.504     0.200
     0.993     6.733     0.200
     1.395     8.388     0.200
     0.209     1.855     0.200
     0.547     4.103     0.200
     0.680     4.564     0.200
     1.157     7.788     0.200
     1.263     8.182     0.200
     0.624     4.495     0.200
     1.161     7.911     0.200
     1.594    11.451     0.200
     3.098    16.461     0.200
     0.439     3.975     0.200
     0.497     3.546     0.200
     0.640     4.810     0.200
     1.192     7.026     0.200
     1.147     8.546     0.200
     1.505     9.472     0.200
     0.393     2.975     0.200
     0.713     4.967     0.200
     1.579    10.530     0.200
     3.194    17.618     0.200
     0.162     1.702     0.200
     0.572     4.179     0.200
     0.676     4.712     0.200
     1.152     7.454     0.200
     1.574    11.577     0.200
     2.513    13.575     0.200
     0.336     2.822     0.200
     0.453     3.155     0.200
     0.752     5.433     0.200
     1.042     7.227     0.200
     1.241     7.433     0.200
     1.514     9.884     0.200
     3.148    18.103     0.200
     0.241     2.053     0.200
     0.511     4.093     0.200
     0.711     4.924     0.200
     1.300     8.202     0.200
     2.047    10.948     0.200
     2.531    14.218     0.200
     0.196     2.032     0.200
     0.534     3.566     0.200
     0.706     4.819     0.200
     0.199     1.954     0.200
     0.540     3.898     0.200
     0.695     4.928     0.200
     1.138     7.277     0.200
     1.262     7.867     0.200
     0.233     1.960     0.200
     0.515     4.125     0.200
     0.709     5.025     0.200
     1.131     7.319     0.200
     1.293     8.345     0.200
     1.382     8.308     0.200
     0.305     2.397     0.200
     0.406     2.716     0.200
     0.808     5.278     0.200
     1.001     7.411     0.200
     1.505    11.224     0.200
     1.527     8.954     0.200
     3.203    17.588     0.200
     0.249     2.166     0.200
     0.495     4.422     0.200
     0.728     5.039     0.200
     1.114     7.541     0.200
     1.313     7.998     0.200
     1.380     8.147     0.200
     3.187    19.050     0.200
     0.207     1.986     0.200
     0.771     5.130     0.200
     0.787     5.930     0.200
     1.024     7.295     0.200
     1.153     8.257     0.200
     1.691    10.949     0.200
     3.415    19.169     0.200
     0.086     1.752     0.200
     0.729     6.182     0.200
     0.690     4.417     0.200
     3.024    15.831     0.200
     0.250     2.278     0.200
     0.557     4.378     0.200
     0.655     4.334     0.200
     1.195     7.740     0.200
     1.280     9.089     0.200
     1.331     7.985     0.200
     1.615     9.629     0.200
     3.027    17.126     0.200
     0.305     2.924     0.200
     0.397     3.220     0.200
     0.815     5.588     0.200
     0.998     7.416     0.200
     1.240     7.660     0.200
     1.508    10.417     0.200
     3.636    19.055     0.200
     0.186     2.319     0.200
     0.606     4.466     0.200
     0.619     4.726     0.200
     1.206     8.314     0.200
     1.227     7.772     0.200
     0.569     4.246     0.200
     0.700     5.466     0.200
     1.102     7.033     0.200
     1.259     8.428     0.200
     3.156    18.367     0.200
     3.205    16.586     0.200
     0.503     3.999     0.200
     0.586     3.951     0.200
     0.625     4.509     0.200
     1.248     6.986     0.200
     1.509     9.530     0.200
     2.949    15.807     0.200
     0.486     4.308     0.200
     0.594     4.060     0.200
     0.590     4.065     0.200
     0.127     1.633     0.200
     0.627     3.675     0.200
     1.200     7.844     0.200
     0.482     3.508     0.200
     0.500     3.632     0.200
     0.598     3.753     0.200
     1.624     9.777     0.200
     3.074    16.706     0.200
     3.114    16.907     0.200
     0.530     3.979     0.200
     1.876    10.499     0.200
     3.398    17.655     0.200
     0.331     2.346     0.200
     0.454     3.099     0.200
     0.757     5.091     0.200
     1.037     7.010     0.200
     1.245     7.652     0.200
     1.732    10.868     0.200
     3.147    16.338     0.200
     0.155     1.157     0.200
     0.849     5.987     0.200
     1.364     8.670     0.200
     4.163    25.256     0.200
     0.329     2.557     0.200
     0.446     2.898     0.200
     0.762     5.195     0.200
     1.034     6.991     0.200
     1.243     8.680     0.200
     1.516     9.856     0.200
     1.539    10.504     0.200
     0.175     1.511     0.200
     0.542     3.552     0.200
     0.883     6.092     0.200
     0.902     6.748     0.200
     1.354     9.334     0.200
     1.396     9.012     0.200
     1.470     8.285     0.200
     3.141    20.671     0.200
     0.215     2.862     0.200
     1.075     5.776     0.200
     2.220    13.149     0.200
     2.634    14.248     0.200
     0.350     3.574     0.200
     0.364     2.270     0.200
     0.785     5.630     0.200
     1.039     6.412     0.200
     1.195     7.797     0.200
     1.481     9.310     0.200
     1.553     9.422     0.200
     0.234     2.632     0.200
     1.090     6.778     0.200
     2.992    15.985     0.200
     0.374     2.653     0.200
     0.437     3.487     0.200
     0.686     4.954     0.200
     1.400     8.876     0.200
     1.628    10.333     0.200
     0.290     2.803     0.200
     0.437     3.583     0.200
     0.808     6.442     0.200
     0.992     7.730     0.200
     1.483     9.989     0.200
     1.546     9.765     0.200
     2.262    13.095     0.200
     0.278     2.090     0.200
     0.447     3.086     0.200
     0.354     2.341     0.200
     0.489     3.493     0.200
     1.347     8.688     0.200
     0.325     2.328     0.200
     0.496     3.212     0.200
     1.185     7.629     0.200
     1.336     7.914     0.200
     1.694    10.202     0.200
     3.245    16.165     0.200
     0.212     2.065     0.200
     0.508     3.220     0.200
     1.095     7.328     0.200
     2.697    15.251     0.200
     3.190    17.813     0.200
     0.436     3.261     0.200
     1.115     7.306     0.200
     1.643    10.042     0.200
     3.261    16.457     0.200
     0.389     2.644     0.200
     0.511     3.260     0.200
     1.211     7.877     0.200
     1.332     8.856     0.200
     3.192    19.857     0.200
     3.232    18.485     0.200
     0.296     2.527     0.200
     0.419     3.206     0.200
     1.538     9.984     0.200
     2.248    13.113     0.200
     2.474    14.344     0.200
     3.191    20.321     0.200
     3.653    19.065     0.200
     0.322     2.372     0.200
     0.486     3.332     0.200
     1.174     7.820     0.200
     1.345     8.182     0.200
     2.295    13.116     0.200
     0.347     2.388     0.200
     0.697     4.727     0.200
     1.111     6.797     0.200
     1.640     9.497     0.200
     2.377    13.149     0.200
     3.585    18.275     0.200
     0.315     2.537     0.200
     2.233    14.004     0.200
     3.284    19.377     0.200
     5.094    30.988     0.200
     0.311     2.449     0.200
     1.353     7.992     0.200
     2.333    13.035     0.200
     3.295    18.709     0.200
     0.393     3.013     0.200
     0.737     5.358     0.200
     1.183     7.376     0.200
     1.460     8.979     0.200
     1.569    10.718     0.200
     2.289    13.533     0.200
     2.437    16.721     0.200
     0.309     2.236     0.200
     0.451     3.097     0.200
     2.292    13.242     0.200
     3.153    18.225     0.200
     0.345     2.070     0.200
     0.495     3.277     0.200
     1.503     9.906     0.200
     2.976    16.108     0.200
     3.104    16.425     0.200
     0.447     3.182     0.200
     2.359    14.342     0.200
     3.274    17.162     0.200
     0.597     4.420     0.200
     1.236     8.208     0.200
     0.442     3.316     0.200
     0.430     3.106     0.200
     2.306    13.228     0.200
     0.378     2.878     0.200
     3.228    17.773     0.200
     0.328     2.149     0.200
     1.375     8.941     0.200
     1.656    10.541     0.200
     2.283    14.166     0.200
     3.274    17.481     0.200
     0.345     2.220     0.200
     1.357     9.005     0.200
     1.672    10.250     0.200
     3.263    16.805     0.200
     0.429     2.743     0.200
     3.129    16.004     0.200
     5.201    30.633     0.200
     0.456     3.047     0.200
     0.552     4.516     0.200
     0.669     4.744     0.200
     1.171     7.387     0.200
     1.370     6.326     0.200
     2.567    14.720     0.200
     0.438     2.660     0.200
     0.996     6.982     0.200
     1.486     9.382     0.200
     2.266    13.067     0.200
     3.127    19.008     0.200
     0.314     1.888     0.200
     1.139     8.724     0.200
     1.377     8.190     0.200
     1.657    10.690     0.200
     2.267    13.308     0.200
     0.527     3.907     0.200
     0.809     6.074     0.200
     1.323     8.579     0.200
     2.166    13.088     0.200
     0.399     2.701     0.200
     0.892     7.244     0.200
     3.265    20.533     0.200
     0.827     5.708     0.200
     0.973     6.093     0.200
     1.280     7.987     0.200
     3.131    16.900     0.200
     0.853     6.314     0.200
     0.963     6.598     0.200
     1.264     7.991     0.200
     3.224    19.647     0.200
     3.918    24.623     0.200
     4.249    26.932     0.200
     0.356     2.669     0.200
     0.640     4.716     0.200
     1.063     7.213     0.200
     1.196     7.692     0.200
     0.415     3.215     0.200
     0.855     6.073     0.200
     0.955     6.506     0.200
     1.278     8.463     0.200
     1.469     9.705     0.200
     2.209    12.726     0.200
     0.333     2.506     0.200
     0.690     4.677     0.200
     1.090     7.241     0.200
     0.161     1.339     0.200
     0.741     4.696     0.200
     1.250     8.438     0.200
     2.310    13.770     0.200
     4.591    26.485     0.200
     0.512     3.083     0.200
     1.218     8.576     0.200
     1.127     8.394     0.200
     1.485     8.922     0.200
     1.560     9.995     0.200
     3.089    18.495     0.200
     0.503     3.470     0.200
     0.855     6.686     0.200
     0.939     6.726     0.200
     1.361     8.417     0.200
     2.192    13.086     0.200
     0.445     3.361     0.200
     0.879     6.333     0.200
     0.924     6.368     0.200
     1.314     8.546     0.200
     3.187    17.095     0.200
     0.573     4.836     0.200
     0.658     4.701     0.200
     0.619     4.729     0.200
     1.219     7.000     0.200
     1.228     7.852     0.200
     1.362     7.657     0.200
     0.548     3.540     0.200
     1.367     8.805     0.200
     3.263    19.457     0.200
     0.310     2.153     0.200
     1.327     7.840     0.200
     0.433     3.182     0.200
     0.868     6.359     0.200
     1.299     8.470     0.200
     3.195    19.511     0.200
     0.342     2.549     0.200
     0.545     3.610     0.200
     0.617     4.424     0.200
     1.017     6.382     0.200
     1.237     8.541     0.200
     3.289    19.005     0.200
     0.411     3.300     0.200
     0.673     4.031     0.200
     1.119     7.540     0.200
     0.321     2.463     0.200
     0.536     3.642     0.200
     0.755     5.379     0.200
     1.028     8.222     0.200
     1.305     8.140     0.200
     1.449     7.991     0.200
     3.066    18.574     0.200
     0.613     4.418     0.200
     0.491     2.961     0.200
     0.423     2.894     0.200
     1.103     7.136     0.200
     4.131    25.605     0.200
     0.240     2.631     0.200
     0.451     3.640     0.200
     0.859     6.251     0.200
     1.307     8.411     0.200
     1.370     8.567     0.200
     2.228    12.822     0.200
     3.174    15.841     0.200
     0.465     3.462     0.200
     0.630     4.501     0.200
     1.163     8.304     0.200
     2.403    13.708     0.200
     0.506     3.387     0.200
     0.607     3.863     0.200
     1.172     7.378     0.200
     1.180     8.501     0.200
     2.443    14.501     0.200
     3.105    16.719     0.200
     3.539    18.732     0.200
     0.393     2.917     0.200
     0.769     4.570     0.200
     1.042     6.635     0.200
     1.207     7.849     0.200
     1.377     9.572     0.200
     2.266    13.006     0.200
     0.391     2.276     0.200
     0.802     5.281     0.200
     1.012     7.356     0.200
     1.227     7.936     0.200
     1.413     9.103     0.200
     1.597    10.942     0.200
     1.521     9.612     0.200
     2.445    14.596     0.200
     0.433     3.393     0.200
     0.977     7.186     0.200
     1.274     8.462     0.200
     1.400     8.490     0.200
     0.346     2.513     0.200
     0.722     5.055     0.200
     1.353     8.567     0.200
     0.302     2.187     0.200
     0.418     3.120     0.200
     0.805     5.830     0.200
     1.000     6.866     0.200
     1.250     7.893     0.200
     1.416     8.844     0.200
     2.253    13.380     0.200
     3.190    16.306     0.200
     0.357     2.989     0.200
     0.839     5.597     0.200
     1.225     8.368     0.200
     1.371     7.771     0.200
     2.188    13.697     0.200
     0.414     3.281     0.200
     0.838     5.884     0.200
     0.970     6.622     0.200
     1.268     7.432     0.200
     2.223    12.850     0.200
     3.159    15.425     0.200
     3.828    19.009     0.200
     0.251     3.290     0.200
     0.419     2.928     0.200
     0.869     5.857     0.200
     1.289     8.248     0.200
     0.401     2.918     0.200
     0.304     2.729     0.200
     0.813     5.279     0.200
     1.404     7.713     0.200
     0.270     2.392     0.200
     0.656     5.154     0.200
     0.947     5.294     0.200
     1.294     7.829     0.200
     3.111    17.503     0.200
     0.481     3.814     0.200
     1.012     6.902     0.200
     1.218     7.733     0.200
     1.402     8.643     0.200
     1.598    12.352     0.200
     3.229    18.040     0.200
     0.615     4.776     0.200
     1.061     6.617     0.200
     1.191     8.010     0.200
     1.407     7.707     0.200
     2.001    12.601     0.200
     0.476     3.592     0.200
     0.697     4.693     0.200
     1.220     7.531     0.200
     1.682    10.472     0.200
     3.001    15.697     0.200
     3.123    18.628     0.200
     0.355     3.227     0.200
     0.687     4.494     0.200
     1.109     6.416     0.200
     5.142    30.583     0.200
     0.696     5.362     0.200
     0.750     5.218     0.200
     1.020     6.722     0.200
     1.104     5.463     0.200
     2.378    11.900     0.200
     0.558     3.007     0.200
     0.787     5.206     0.200
     1.002     7.045     0.200
     1.293     8.047     0.200
     2.968    15.924     0.200
     0.462     4.468     0.200
     0.645     4.181     0.200
     0.803     4.844     0.200
     0.861     6.434     0.200
     0.810     5.456     0.200
     0.289     2.300     0.200
     0.441     3.118     0.200
     0.807     5.736     0.200
     0.991     6.906     0.200
     1.269     8.979     0.200
     0.266     2.187     0.200
     0.857     5.963     0.200
     0.955     6.650     0.200
     1.274     8.099     0.200
     0.173     1.707     0.200
     0.399     2.939     0.200
     0.442     3.139     0.200
     0.485     3.681     0.200
     0.770     4.956     0.200
     0.927     6.716     0.200
     1.368     8.818     0.200
     1.310     7.815     0.200
     0.361     2.994     0.200
     0.656     4.639     0.200
     0.970     6.627     0.200
     1.049     6.007     0.200
     1.179     6.113     0.200
     1.175     8.031     0.200
     1.319     8.391     0.200
     1.808    11.116     0.200
     0.446     3.336     0.200
     0.663     5.069     0.200
     0.768     4.980     0.200
     0.831     5.007     0.200
     1.362     8.367     0.200
     1.405     8.610     0.200
     0.158     1.288     0.200
     0.439     2.865     0.200
     0.339     2.358     0.200
     0.472     3.207     0.200
     0.677     4.425     0.200
     1.059     6.327     0.200
     1.319     8.499     0.200
     1.531     9.445     0.200
     1.782    11.606     0.200
     2.810    16.556     0.200
     0.212     2.522     0.200
     0.338     2.871     0.200
     0.517     4.209     0.200
     0.609     4.479     0.200
     0.730     5.396     0.200
     0.936     6.430     0.200
     1.001     5.681     0.200
     1.052     6.099     0.200
     1.295     7.719     0.200
     1.391     8.138     0.200
     1.866    10.343     0.200
     2.821    13.807     0.200
     2.907    16.093     0.200
     3.700    22.976     0.200
     0.264     2.272     0.200
     0.352     2.728     0.200
     0.383     3.085     0.200
     0.428     3.233     0.200
     0.856     5.384     0.200
     0.845     5.342     0.200
     1.378     8.249     0.200
     2.673    14.715     0.200
     0.351     2.716     0.200
     0.390     2.917     0.200
     0.420     3.256     0.200
     0.846     5.343     0.200
     0.860     5.218     0.200
     0.961     6.313     0.200
     1.375     8.502     0.200
     4.846    27.560     0.200
     0.260     2.142     0.200
     0.360     2.857     0.200
     0.396     2.873     0.200
     0.421     3.403     0.200
     0.856     5.448     0.200
     1.283     8.631     0.200
     1.366     8.330     0.200
     0.281     2.246     0.200
     0.331     2.919     0.200
     0.363     2.918     0.200
     0.413     3.228     0.200
     0.774     4.919     0.200
     0.915     5.800     0.200
     1.235     8.106     0.200
     2.672    15.266     0.200
     3.656    21.676     0.200
     0.292     2.577     0.200
     0.273     1.910     0.200
     0.345     2.507     0.200
     0.478     3.613     0.200
     0.736     4.796     0.200
     0.905     5.517     0.200
     1.053     6.947     0.200
     1.498     9.267     0.200
     1.514     9.592     0.200
     0.133     2.442     0.200
     0.582     4.190     0.200
     0.645     4.811     0.200
     0.800     5.883     0.200
     0.822     5.555     0.200
     1.030     6.588     0.200
     1.177     7.769     0.200
     1.068     6.764     0.200
     1.163     6.270     0.200
     1.476     8.583     0.200
     1.459     8.827     0.200
     1.879    10.980     0.200
     3.063    14.902     0.200
     0.244     2.141     0.200
     0.368     2.742     0.200
     0.367     2.974     0.200
     0.453     3.331     0.200
     0.832     5.483     0.200
     0.854     5.489     0.200
     0.944     6.789     0.200
     1.376     8.860     0.200
     0.352     3.219     0.200
     0.425     4.210     0.200
     0.466     3.531     0.200
     0.767     5.626     0.200
     0.846     5.819     0.200
     0.889     5.777     0.200
     1.262     7.338     0.200
     1.348     7.066     0.200
     1.371     8.602     0.200
     1.042     6.346     0.200
     0.977     6.896     0.200
     2.621    16.961     0.200
     3.044    19.394     0.200
     0.208     1.902     0.200
     0.462     3.885     0.200
     0.452     3.320     0.200
     0.405     2.741     0.200
     0.804     5.818     0.200
     0.806     4.800     0.200
     0.854     5.854     0.200
     0.900     6.012     0.200
     0.904     6.303     0.200
     1.252     8.355     0.200
     1.289     8.257     0.200
     1.325     8.175     0.200
     1.332     8.391     0.200
     1.568     9.266     0.200
     2.188    12.813     0.200
     2.505    14.512     0.200
     0.295     2.484     0.200
     0.350     2.617     0.200
     0.438     3.264     0.200
     0.564     4.521     0.200
     0.789     5.463     0.200
     0.877     5.387     0.200
     0.882     6.137     0.200
     0.997     6.521     0.200
     1.263     8.006     0.200
     1.265     8.133     0.200
     1.284     8.340     0.200
     1.542     9.229     0.200
     2.267    12.926     0.200
     3.126    15.791     0.200
     0.480     4.293     0.200
     0.619     4.471     0.200
     0.663     4.933     0.200
     0.950     6.190     0.200
     1.682     8.979     0.200
     2.149    10.946     0.200
     2.775    15.584     0.200
     0.236     2.874     0.200
     0.498     3.962     0.200
     0.588     4.027     0.200
     0.894     5.801     0.200
     1.062     6.028     0.200
     1.067     6.180     0.200
     1.531     8.711     0.200
     2.275    12.208     0.200
     2.671    16.618     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    23.235   306.650     0.200
     1.790    29.412     0.200
    15.790   215.038     0.200
    19.838   262.793     0.200
    20.225   270.278     0.200
    21.027   274.921     0.200
     8.075   109.696     0.200
    20.252   264.333     0.200
    21.423   280.675     0.200
    20.301   267.670     0.200
    16.193   222.548     0.200
    19.969   264.655     0.200
     1.910    27.259     0.200
     1.059    23.647     0.200
     1.883    33.030     0.200
     1.830    30.433     0.200
     1.772    28.400     0.200
    21.040   276.543     0.200
     1.778    30.869     0.200
     4.698    71.789     0.200
     1.694    23.893     0.200
     2.854    38.851     0.200
     7.169    96.498     0.200
     1.868    34.051     0.200
     1.041    24.603     0.200
     1.364    26.826     0.200
     2.064    35.658     0.200
     2.167    34.452     0.200
     1.360    28.562     0.200
     0.936    21.411     0.200
     2.689    45.357     0.200
     2.657    42.819     0.200
     1.190    23.642     0.200
     1.668    28.653     0.200
     2.309    36.760     0.200
     1.211    26.608     0.200
     2.949    39.732     0.200
     1.323    22.806     0.200
     1.833    28.768     0.200
     2.663    44.012     0.200
     2.687    44.704     0.200
     1.085    23.201     0.200
     1.454    29.541     0.200
     1.825    32.320     0.200
     2.207    36.725     0.200
     2.608    40.674     0.200
     1.492    29.598     0.200
     1.681    29.425     0.200
     2.233    40.018     0.200
     2.777    47.737     0.200
     2.941    49.284     0.200
     3.050    50.583     0.200
     3.064    49.903     0.200
     3.744    59.217     0.200
     4.036    62.938     0.200
     4.238    65.358     0.200
     4.666    68.032     0.200
     6.247    92.798     0.200
     1.007    23.165     0.200
     1.275    25.947     0.200
     1.722    30.257     0.200
     2.489    42.784     0.200
     2.683    43.519     0.200
     2.829    45.424     0.200
     4.048    61.966     0.200
     1.406    25.902     0.200
     2.405    38.637     0.200
     2.567    43.181     0.200
     2.696    45.918     0.200
     2.965    47.125     0.200
     3.626    57.855     0.200
    17.030   226.169     0.200
     1.390    24.874     0.200
     2.373    39.348     0.200
     2.640    43.913     0.200
     2.698    44.994     0.200
     3.741    58.698     0.200
     6.874   100.412     0.200
     2.001    35.670     0.200
     2.247    40.240     0.200
     2.502    43.855     0.200
     2.541    41.726     0.200
    16.777   226.218     0.200
     1.023    22.062     0.200
     1.701    28.405     0.200
     2.809    44.800     0.200
     1.179    27.607     0.200
     1.267    27.198     0.200
     1.034    25.318     0.200
     1.707    32.410     0.200
     1.946    35.840     0.200
     0.758    17.091     0.200
     1.334    22.891     0.200
     1.358    24.160     0.200
     1.443    25.806     0.200
     2.418    36.583     0.200
     2.479    40.835     0.200
     3.544    52.335     0.200
     4.780    68.750     0.200
    23.673   311.902     0.200
     0.752    17.434     0.200
     1.443    25.306     0.200
     1.657    27.767     0.200
     2.473    41.425     0.200
     2.697    42.643     0.200
     2.707    43.615     0.200
     1.112    24.909     0.200
     1.170    25.379     0.200
     1.230    25.943     0.200
     1.354    27.495     0.200
     1.273    27.595     0.200
     2.550    43.512     0.200
     0.711    18.765     0.200
     1.196    24.895     0.200
     1.712    29.012     0.200
     1.881    31.346     0.200
     1.802    30.584     0.200
     1.754    31.352     0.200
     2.002    33.736     0.200
     2.155    36.600     0.200
     2.603    41.755     0.200
     3.311    50.243     0.200
     1.064    20.353     0.200
     1.621    28.035     0.200
     1.889    32.165     0.200
     2.027    33.884     0.200
     2.134    35.654     0.200
     2.732    43.011     0.200
     0.888    19.966     0.200
     1.058    22.584     0.200
     1.262    27.419     0.200
     1.817    30.317     0.200
     2.066    34.798     0.200
     2.428    38.323     0.200
     2.366    40.722     0.200
     3.082    48.467     0.200
     3.586    58.654     0.200
     4.777    68.742     0.200
     0.988    22.192     0.200
     1.008    21.699     0.200
     1.069    22.841     0.200
     1.247    27.824     0.200
     1.308    27.340     0.200
     1.720    27.980     0.200
     2.259    38.789     0.200
     2.373    40.387     0.200
     2.456    41.153     0.200
     0.936    19.542     0.200
     1.482    26.916     0.200
     1.956    33.008     0.200
     1.974    33.349     0.200
     2.718    45.778     0.200
    16.457   223.633     0.200
     3.247    55.187     0.200
     1.237    25.853     0.200
     1.369    27.180     0.200
     2.663    44.685     0.200
     0.886    22.252     0.200
     2.491    43.889     0.200
     1.291    26.606     0.200
     2.531    42.653     0.200
     3.211    50.424     0.200
     2.302    41.647     0.200
     8.758   123.517     0.200
     1.110    24.536     0.200
     2.319    41.126     0.200
     3.263    50.254     0.200
     1.121    25.338     0.200
     3.125    53.964     0.200
     1.199    28.501     0.200
     2.091    39.324     0.200
     2.208    40.325     0.200
     2.605    45.437     0.200
     2.815    48.725     0.200
     3.170    55.323     0.200
     3.195    51.183     0.200
     8.740   122.964     0.200
     1.025    26.173     0.200
     2.344    41.547     0.200
     3.129    53.727     0.200
     3.297    52.676     0.200
     8.513   120.362     0.200
     1.309    28.314     0.200
     2.515    43.462     0.200
     3.141    48.826     0.200
     3.186    47.192     0.200
     1.593    30.427     0.200
     2.492    44.792     0.200
     1.211    24.874     0.200
     1.380    26.517     0.200
     2.252    39.273     0.200
     8.272   116.181     0.200
    10.773   146.746     0.200
     1.368    28.054     0.200
     1.552    28.386     0.200
     2.056    35.681     0.200
     2.894    45.942     0.200
     3.188    48.731     0.200
     3.432    56.378     0.200
     8.538   120.766     0.200
    16.424   220.103     0.200
     1.098    23.847     0.200
     1.267    27.098     0.200
     3.206    49.102     0.200
     1.287    27.023     0.200
     1.584    29.244     0.200
     3.057    50.097     0.200
     3.203    50.722     0.200
     8.623   118.137     0.200
     1.243    26.446     0.200
     1.243    28.106     0.200
     1.564    28.919     0.200
     2.176    39.594     0.200
     2.577    44.924     0.200
     3.790    59.460     0.200
     1.070    25.862     0.200
     1.170    25.342     0.200
     2.337    40.399     0.200
     2.342    40.589     0.200
     2.761    46.503     0.200
     3.110    50.841     0.200
     0.924    20.390     0.200
     3.204    54.272     0.200
     3.204    46.812     0.200
     1.288    28.501     0.200
     2.537    43.688     0.200
     2.851    48.453     0.200
     3.517    58.389     0.200
     8.634   118.185     0.200
    13.870   185.562     0.200
    14.135   190.612     0.200
    16.467   221.162     0.200
     1.375    28.601     0.200
     2.254    40.227     0.200
     2.442    41.464     0.200
     4.626    67.279     0.200
     1.464    30.513     0.200
     1.904    34.378     0.200
     1.972    35.082     0.200
     1.506    30.339     0.200
     1.783    33.697     0.200
     1.079    25.540     0.200
     1.161    24.710     0.200
     1.070    26.002     0.200
     1.152    24.898     0.200
     1.359    28.906     0.200
     1.833    33.836     0.200
     2.470    43.872     0.200
    16.439   225.353     0.200
     1.847    30.985     0.200
     2.585    43.703     0.200
     3.246    47.260     0.200
     1.616    30.168     0.200
     3.239    54.431     0.200
     8.758   125.853     0.200
     1.187    24.996     0.200
     1.383    27.042     0.200
     2.851    46.067     0.200
     8.298   115.406     0.200
    16.262   217.272     0.200
     1.265    27.240     0.200
     3.536    56.184     0.200
     8.624   121.251     0.200
     9.691   134.742     0.200
    15.795   214.774     0.200
    16.416   220.531     0.200
     0.925    22.152     0.200
     1.321    27.609     0.200
     1.606    30.624     0.200
     3.171    53.895     0.200
     3.171    48.122     0.200
     8.606   121.627     0.200
     1.021    25.645     0.200
     1.691    32.513     0.200
     2.137    40.223     0.200
     1.188    26.673     0.200
     1.460    30.359     0.200
     1.683    32.308     0.200
     2.217    38.965     0.200
     1.134    25.775     0.200
     1.403    28.944     0.200
     1.748    33.379     0.200
     0.947    23.378     0.200
     1.410    30.581     0.200
     1.592    30.008     0.200
     3.134    52.073     0.200
     3.134    49.007     0.200
     8.527   120.536     0.200
     1.257    25.347     0.200
     1.376    28.825     0.200
     3.255    51.770     0.200
     0.817    20.604     0.200
     3.296    53.559     0.200
     3.296    51.571     0.200
     8.472   117.966     0.200
    10.924   146.761     0.200
     1.100    25.713     0.200
     1.063    24.930     0.200
     1.160    27.127     0.200
     1.591    28.954     0.200
     0.942    22.509     0.200
     1.318    28.549     0.200
     1.626    31.239     0.200
     1.148    26.357     0.200
     1.416    27.473     0.200
     1.831    31.552     0.200
     5.952    85.822     0.200
    16.295   218.543     0.200
     1.017    24.623     0.200
     1.290    28.467     0.200
     1.555    32.100     0.200
     1.713    33.181     0.200
     0.992    22.530     0.200
     1.410    30.328     0.200
     1.707    31.863     0.200
     2.022    36.745     0.200
     1.145    26.161     0.200
     3.272    52.101     0.200
     1.142    25.037     0.200
     1.125    24.105     0.200
     1.396    29.003     0.200
     2.280    40.016     0.200
     1.116    24.730     0.200
     1.411    29.336     0.200
     1.655    32.507     0.200
     1.780    33.940     0.200
     0.992    23.654     0.200
     1.263    27.533     0.200
     2.146    38.118     0.200
     3.039    49.593     0.200
     1.140    25.748     0.200
     1.382    29.340     0.200
     2.000    37.347     0.200
     2.306    41.131     0.200
     2.507    41.883     0.200
     3.119    53.977     0.200
     3.191    54.091     0.200
     4.192    65.528     0.200
     1.125    24.634     0.200
     1.170    25.309     0.200
     1.433    29.495     0.200
     1.253    27.368     0.200
     1.852    34.041     0.200
     1.288    27.068     0.200
     2.676    45.000     0.200
     3.199    54.900     0.200
     1.090    24.815     0.200
     1.154    25.640     0.200
     1.369    28.982     0.200
     1.987    36.579     0.200
     2.316    41.627     0.200
     2.499    43.368     0.200
     3.266    49.576     0.200
     3.521    59.812     0.200
     1.227    27.122     0.200
     1.432    28.221     0.200
     1.858    33.992     0.200
     3.203    48.463     0.200
     8.250   116.649     0.200
     1.369    29.186     0.200
     1.663    31.205     0.200
     1.782    34.407     0.200
     1.987    34.262     0.200
     2.321    41.944     0.200
     2.315    41.279     0.200
     1.080    24.143     0.200
     2.327    41.414     0.200
     2.487    44.786     0.200
     1.049    24.933     0.200
     1.205    27.343     0.200
     1.484    31.460     0.200
     1.777    32.221     0.200
     1.644    31.825     0.200
     2.608    43.021     0.200
     3.160    52.530     0.200
     1.087    24.114     0.200
     1.176    26.228     0.200
     1.451    28.920     0.200
     3.202    49.488     0.200
     1.395    29.178     0.200
     1.584    27.255     0.200
     1.695    32.202     0.200
     2.041    35.831     0.200
     2.262    40.587     0.200
     1.263    27.832     0.200
     1.387    27.633     0.200
     2.541    41.955     0.200
     2.828    46.421     0.200
     3.289    52.148     0.200
     4.086    62.136     0.200
     8.216   114.427     0.200
     1.161    25.121     0.200
     1.803    33.607     0.200
     2.222    39.588     0.200
     2.665    45.832     0.200
     3.098    45.212     0.200
     3.293    53.947     0.200
     3.672    59.929     0.200
     4.509    68.800     0.200
     8.850   124.534     0.200
     9.580   130.944     0.200
     1.640    32.091     0.200
     1.787    34.917     0.200
     2.217    39.548     0.200
     2.666    46.292     0.200
     2.680    46.984     0.200
     3.107    47.836     0.200
     3.280    53.294     0.200
     3.317    52.343     0.200
     3.376    58.704     0.200
     8.835   127.157     0.200
     1.094    24.461     0.200
     2.063    37.188     0.200
     2.230    39.379     0.200
     2.586    44.964     0.200
     2.719    46.209     0.200
     2.799    46.791     0.200
     3.180    52.440     0.200
     3.214    50.634     0.200
     4.387    67.044     0.200
     1.226    27.656     0.200
     1.434    27.982     0.200
     1.857    33.586     0.200
     1.932    34.550     0.200
     1.042    23.358     0.200
     1.241    26.863     0.200
     1.532    28.874     0.200
     1.687    32.039     0.200
     2.126    38.482     0.200
     2.164    37.587     0.200
     2.658    45.303     0.200
     3.148    49.517     0.200
     3.148    49.042     0.200
     3.211    50.755     0.200
     3.213    55.522     0.200
     4.397    66.741     0.200
     8.726   123.783     0.200
    16.542   225.313     0.200
     1.131    22.345     0.200
     1.300    29.602     0.200
     1.375    27.477     0.200
     1.985    34.626     0.200
     2.531    42.298     0.200
     1.264    27.167     0.200
     1.420    27.986     0.200
     1.968    34.792     0.200
     2.504    42.294     0.200
     1.138    23.427     0.200
     1.262    27.928     0.200
     1.960    32.366     0.200
     2.518    42.008     0.200
     4.106    60.817     0.200
     8.215   116.221     0.200
     1.293    27.326     0.200
     1.981    34.877     0.200
     2.527    41.627     0.200
     4.077    61.070     0.200
     1.001    24.731     0.200
     1.243    27.032     0.200
     1.615    30.872     0.200
     2.168    40.771     0.200
     2.639    45.458     0.200
     2.688    46.348     0.200
     3.149    54.376     0.200
     4.326    66.709     0.200
     1.313    28.139     0.200
     1.380    27.307     0.200
     2.518    42.629     0.200
     2.805    46.426     0.200
     3.268    53.423     0.200
    16.248   222.078     0.200
     1.024    23.166     0.200
     3.019    52.454     0.200
     3.415    57.856     0.200
    16.523   219.327     0.200
     1.280    28.312     0.200
     1.331    26.324     0.200
     1.910    33.262     0.200
     0.998    22.639     0.200
     1.240    27.590     0.200
     1.526    28.000     0.200
     1.593    28.294     0.200
     2.585    43.965     0.200
     2.859    47.328     0.200
     3.128    49.868     0.200
     3.138    51.782     0.200
     3.214    52.490     0.200
     3.565    59.524     0.200
     4.125    66.634     0.200
     4.256    65.041     0.200
     4.314    64.946     0.200
     1.206    26.455     0.200
     1.877    31.019     0.200
     2.841    46.654     0.200
     1.538    26.416     0.200
     1.500    26.762     0.200
     1.582    27.692     0.200
     2.575    42.009     0.200
     2.701    41.600     0.200
     4.111    65.628     0.200
    10.973   146.033     0.200
     1.102    23.432     0.200
     1.259    25.303     0.200
     1.807    32.762     0.200
     1.962    35.522     0.200
     2.944    49.352     0.200
     3.115    49.812     0.200
     3.310    54.984     0.200
     3.755    56.479     0.200
     3.820    56.680     0.200
     4.536    65.320     0.200
    15.197   203.725     0.200
    23.208   304.450     0.200
     2.183    37.899     0.200
     2.585    44.788     0.200
     2.887    49.141     0.200
     2.989    48.424     0.200
     3.410    55.736     0.200
     1.458    28.433     0.200
     1.881    33.225     0.200
     2.195    36.558     0.200
     2.609    43.413     0.200
     1.175    26.052     0.200
     2.541    44.765     0.200
     3.114    52.932     0.200
     1.404    28.525     0.200
     1.518    28.132     0.200
     1.626    29.957     0.200
     1.624    30.068     0.200
     2.253    38.703     0.200
     2.690    46.338     0.200
     2.721    47.080     0.200
     3.286    53.425     0.200
     3.546    55.318     0.200
     4.001    61.340     0.200
     4.052    63.919     0.200
     9.598   132.780     0.200
     1.180    17.826     0.200
     1.898    30.013     0.200
     1.962    32.018     0.200
     2.358    37.170     0.200
     1.037    24.331     0.200
     1.245    26.591     0.200
     1.510    31.400     0.200
     2.160    37.819     0.200
     2.597    46.310     0.200
     2.655    45.216     0.200
    16.540   225.161     0.200
    22.480   294.645     0.200
     1.676    30.939     0.200
     1.853    34.988     0.200
     2.220    40.729     0.200
     2.296    39.660     0.200
     2.436    43.126     0.200
     2.599    43.054     0.200
     2.764    48.670     0.200
     3.157    54.923     0.200
    16.435   221.552     0.200
    22.621   298.458     0.200
     1.034    23.921     0.200
     1.243    27.449     0.200
     2.163    37.642     0.200
     1.674    32.611     0.200
     2.014    37.330     0.200
     2.146    40.685     0.200
     2.437    44.112     0.200
     2.546    44.481     0.200
     2.524    40.166     0.200
     1.290    27.228     0.200
     2.012    34.242     0.200
     2.455    40.880     0.200
     8.183   114.758     0.200
     1.039    22.314     0.200
     1.195    27.547     0.200
     1.553    29.301     0.200
     1.622    26.769     0.200
     2.217    39.114     0.200
     1.090    21.692     0.200
     1.306    28.738     0.200
     1.414    26.011     0.200
     1.802    31.335     0.200
     2.011    35.154     0.200
     2.255    37.697     0.200
     1.135    24.729     0.200
     1.400    28.997     0.200
     1.621    29.923     0.200
     1.679    32.652     0.200
     2.280    38.655     0.200
     2.285    41.316     0.200
     0.808    19.142     0.200
     0.992    22.777     0.200
     2.224    39.284     0.200
     2.565    44.105     0.200
     2.658    45.926     0.200
     1.386    26.814     0.200
     1.710    29.455     0.200
     2.837    46.648     0.200
     1.183    25.980     0.200
     1.347    28.169     0.200
     1.656    29.761     0.200
     2.809    47.780     0.200
     1.185    25.480     0.200
     1.336    28.328     0.200
     1.684    30.387     0.200
     2.834    48.372     0.200
     2.852    48.459     0.200
     3.286    49.957     0.200
     3.755    62.932     0.200
     4.172    63.776     0.200
     2.478    42.369     0.200
    16.299   223.192     0.200
     1.115    24.931     0.200
     1.395    27.324     0.200
     1.691    29.051     0.200
     2.819    47.041     0.200
     2.898    46.189     0.200
     3.303    53.545     0.200
    15.709   213.115     0.200
    16.430   224.303     0.200
    23.203   305.966     0.200
     1.332    29.426     0.200
     1.636    30.457     0.200
     2.787    46.340     0.200
     2.800    47.893     0.200
    23.304   308.841     0.200
     0.994    21.724     0.200
     1.622    30.257     0.200
     2.675    45.435     0.200
     3.191    47.946     0.200
     3.667    57.135     0.200
     3.849    57.443     0.200
     4.114    64.299     0.200
     1.174    25.226     0.200
     1.345    27.775     0.200
     1.964    35.288     0.200
     2.342    40.994     0.200
     2.766    47.114     0.200
     2.830    46.443     0.200
     3.723    60.266     0.200
     3.827    59.267     0.200
    12.913   175.501     0.200
    16.431   220.386     0.200
     1.111    25.637     0.200
     1.389    27.393     0.200
     2.788    46.155     0.200
     3.197    50.504     0.200
     2.020    37.492     0.200
     2.278    42.535     0.200
     2.362    43.373     0.200
     2.688    48.263     0.200
     2.793    47.209     0.200
     3.284    55.217     0.200
     4.213    70.654     0.200
     4.301    67.623     0.200
     1.353    27.742     0.200
     2.031    35.755     0.200
     2.475    43.637     0.200
     2.832    47.660     0.200
     3.186    53.913     0.200
     4.060    62.406     0.200
     1.183    25.860     0.200
     1.569    32.586     0.200
     1.658    32.335     0.200
     2.096    35.790     0.200
     2.437    43.635     0.200
     2.651    46.222     0.200
     2.147    35.997     0.200
     2.650    45.181     0.200
     3.018    51.817     0.200
     3.153    52.450     0.200
     1.503    31.593     0.200
     1.730    32.529     0.200
     2.145    36.704     0.200
     2.594    45.490     0.200
     2.624    44.906     0.200
     3.104    47.156     0.200
     3.953    59.162     0.200
     9.573   130.924     0.200
     1.666    29.865     0.200
     2.727    45.311     0.200
     2.803    46.745     0.200
     2.861    45.359     0.200
    12.949   176.960     0.200
    16.468   223.534     0.200
     1.644    29.896     0.200
     2.001    35.872     0.200
     2.600    43.439     0.200
     1.551    27.942     0.200
     1.568    29.180     0.200
     1.620    30.464     0.200
     2.126    38.359     0.200
     2.543    45.285     0.200
     2.649    45.420     0.200
     1.491    30.044     0.200
     2.106    38.330     0.200
     2.128    37.166     0.200
     2.682    43.352     0.200
     2.611    43.883     0.200
     2.718    44.723     0.200
     1.668    30.817     0.200
     1.993    36.085     0.200
     2.314    38.405     0.200
     2.736    46.128     0.200
     2.808    47.878     0.200
     1.659    30.374     0.200
     1.672    30.601     0.200
     2.066    38.029     0.200
     2.808    47.227     0.200
     3.263    55.856     0.200
     1.556    30.374     0.200
     1.671    30.543     0.200
     2.111    38.088     0.200
     2.125    38.489     0.200
     2.184    39.309     0.200
     2.681    44.179     0.200
     3.129    50.222     0.200
     3.171    51.563     0.200
     3.171    48.844     0.200
     3.657    59.510     0.200
     1.691    32.689     0.200
     2.150    38.119     0.200
     2.125    38.828     0.200
     2.656    45.371     0.200
     3.015    53.032     0.200
     3.145    53.473     0.200
     4.072    67.891     0.200
     1.883    33.885     0.200
     2.559    43.384     0.200
     0.996    24.060     0.200
     1.550    27.918     0.200
     1.543    29.440     0.200
     2.658    44.779     0.200
     2.819    46.500     0.200
    16.499   225.766     0.200
     1.139    25.302     0.200
     1.528    26.965     0.200
     2.107    37.882     0.200
     2.571    43.573     0.200
     1.444    28.902     0.200
     1.637    28.002     0.200
     2.697    45.613     0.200
     1.483    29.305     0.200
     1.574    29.470     0.200
     2.274    40.382     0.200
     2.691    45.017     0.200
     3.095    49.396     0.200
     3.121    49.253     0.200
     3.656    58.051     0.200
     3.691    58.468     0.200
     4.144    63.434     0.200
     1.063    25.002     0.200
     1.196    25.934     0.200
     1.692    31.282     0.200
     2.342    40.245     0.200
     3.149    47.257     0.200
     3.144    52.424     0.200
     1.278    27.444     0.200
     1.469    29.205     0.200
     1.583    30.443     0.200
     1.830    34.069     0.200
     2.138    38.321     0.200
     2.674    44.924     0.200
     2.666    45.135     0.200
     1.665    29.261     0.200
     2.808    47.476     0.200
     1.250    28.501     0.200
     1.873    35.720     0.200
     1.872    35.877     0.200
     2.494    45.184     0.200
     1.634    34.433     0.200
     1.788    33.529     0.200
     2.075    38.516     0.200
     2.147    40.883     0.200
     2.225    39.334     0.200
     2.646    46.282     0.200
     2.642    47.033     0.200
     3.292    53.819     0.200
     1.577    30.588     0.200
     2.033    37.326     0.200
     2.588    44.107     0.200
     1.314    27.675     0.200
     1.562    26.622     0.200
     2.102    37.382     0.200
     2.237    39.028     0.200
     2.643    44.264     0.200
     3.038    51.551     0.200
     3.187    51.033     0.200
     3.187    52.083     0.200
     4.105    67.879     0.200
     8.602   121.199     0.200
     1.398    27.020     0.200
     1.610    29.445     0.200
     2.548    43.636     0.200
     2.546    42.809     0.200
     3.703    52.317     0.200
     1.228    26.262     0.200
     1.362    27.527     0.200
     1.795    32.418     0.200
     1.367    29.785     0.200
     1.699    31.081     0.200
     2.457    43.176     0.200
     2.847    47.841     0.200
     3.097    50.398     0.200
     3.301    57.030     0.200
     1.449    28.516     0.200
     1.570    27.544     0.200
     1.827    33.828     0.200
     2.081    35.551     0.200
     1.701    31.715     0.200
     2.388    42.303     0.200
     1.119    24.454     0.200
     1.529    28.498     0.200
     1.746    31.758     0.200
     2.192    39.499     0.200
     2.213    38.940     0.200
     3.245    50.251     0.200
     3.276    50.953     0.200
     3.578    59.476     0.200
     4.068    65.010     0.200
     4.453    66.920     0.200
     1.305    27.950     0.200
     1.747    33.449     0.200
     2.101    37.924     0.200
     2.578    44.565     0.200
     1.103    26.265     0.200
     1.596    29.971     0.200
     1.750    33.695     0.200
     2.304    42.139     0.200
     2.144    39.135     0.200
     4.131    69.296     0.200
     1.307    27.591     0.200
     1.370    28.397     0.200
     1.440    28.357     0.200
     1.549    26.650     0.200
     3.027    50.699     0.200
     3.120    47.790     0.200
     1.615    30.569     0.200
     1.663    31.330     0.200
     2.184    39.415     0.200
     2.403    40.388     0.200
     1.180    27.212     0.200
     1.613    31.496     0.200
     2.240    38.895     0.200
     3.105    49.613     0.200
     3.385    53.986     0.200
     1.042    24.353     0.200
     1.446    29.107     0.200
     1.542    29.261     0.200
     1.592    28.889     0.200
     2.201    38.577     0.200
     3.076    49.006     0.200
     3.208    53.107     0.200
     3.431    54.814     0.200
     4.135    62.871     0.200
     8.718   123.805     0.200
     1.012    24.774     0.200
     1.227    28.468     0.200
     1.521    32.022     0.200
     1.808    34.897     0.200
     1.610    31.300     0.200
     2.072    39.337     0.200
     2.445    43.924     0.200
     2.705    47.235     0.200
     3.428    57.220     0.200
     1.274    28.243     0.200
     1.620    30.398     0.200
     2.102    37.158     0.200
     1.640    31.274     0.200
     2.308    40.368     0.200
     2.775    47.638     0.200
     1.000    21.985     0.200
     1.250    26.294     0.200
     2.160    36.620     0.200
     2.648    41.156     0.200
     3.162    47.772     0.200
     4.114    61.558     0.200
     1.225    26.489     0.200
     1.559    29.291     0.200
     2.310    41.153     0.200
     0.970    21.442     0.200
     1.382    27.605     0.200
     1.289    27.568     0.200
     1.585    27.280     0.200
     1.352    27.716     0.200
     2.259    39.630     0.200
     2.169    39.090     0.200
     3.416    56.874     0.200
     3.671    56.428     0.200
     4.132    65.477     0.200
     1.294    28.227     0.200
     1.693    29.961     0.200
     1.918    34.511     0.200
     2.492    42.103     0.200
     1.218    26.813     0.200
     1.598    28.792     0.200
     2.220    39.012     0.200
     1.061    23.187     0.200
     1.191    26.831     0.200
     1.612    30.529     0.200
     2.289    39.983     0.200
     2.379    40.304     0.200
     1.908    31.140     0.200
     3.570    57.991     0.200
     1.641    31.100     0.200
     1.668    32.450     0.200
     2.073    38.414     0.200
     2.305    41.928     0.200
     2.297    41.101     0.200
     2.297    41.441     0.200
     3.705    62.610     0.200
     2.281    35.493     0.200
     2.714    44.274     0.200
    17.576   235.744     0.200
     1.293    28.407     0.200
     1.970    36.498     0.200
     2.129    39.535     0.200
     2.600    46.444     0.200
     5.341    80.204     0.200
     1.194    24.133     0.200
    16.602   226.253     0.200
     1.788    30.873     0.200
     2.321    37.501     0.200
     2.608    44.797     0.200
     2.866    46.573     0.200
     2.866    44.260     0.200
     1.269    28.149     0.200
     1.419    28.559     0.200
     2.117    37.938     0.200
     2.654    43.915     0.200
     2.819    46.967     0.200
     0.955    22.763     0.200
     1.274    26.907     0.200
     1.361    26.882     0.200
     2.081    36.346     0.200
     2.681    45.722     0.200
     2.880    48.233     0.200
     1.368    28.938     0.200
     1.310    27.156     0.200
     1.542    26.716     0.200
     2.218    40.252     0.200
     2.873    46.661     0.200
     3.013    46.673     0.200
     1.546    29.272     0.200
     1.704    31.770     0.200
     1.824    33.390     0.200
     1.930    34.970     0.200
     2.262    39.623     0.200
     2.445    43.107     0.200
     1.362    27.927     0.200
     2.219    39.822     0.200
     2.237    40.160     0.200
     2.466    42.384     0.200
     2.643    43.219     0.200
     1.663    31.085     0.200
     1.665    32.020     0.200
     2.059    36.700     0.200
     2.323    42.698     0.200
     2.842    47.431     0.200
     1.295    26.360     0.200
     1.625    28.341     0.200
     2.449    40.874     0.200
     2.776    45.717     0.200
     2.821    42.838     0.200
     1.569    27.833     0.200
     1.600    30.790     0.200
     1.813    34.118     0.200
     2.063    37.641     0.200
     2.132    38.594     0.200
     2.132    37.755     0.200
     2.855    48.951     0.200
     3.049    48.017     0.200
     3.166    51.030     0.200
     1.375    28.611     0.200
     1.564    30.135     0.200
     1.594    29.614     0.200
     2.066    34.974     0.200
     2.080    37.927     0.200
     2.137    38.686     0.200
     2.862    48.651     0.200
     3.056    51.804     0.200
     3.173    52.765     0.200
     1.283    27.412     0.200
     1.465    29.080     0.200
     2.076    36.930     0.200
     2.253    40.475     0.200
     2.476    43.506     0.200
     2.668    45.501     0.200
     2.869    48.686     0.200
     3.203    53.003     0.200
     1.235    26.223     0.200
     1.524    29.796     0.200
     1.572    28.388     0.200
     2.103    37.891     0.200
     2.464    40.675     0.200
     2.689    46.392     0.200
     2.822    47.846     0.200
     3.138    49.422     0.200
     3.169    52.599     0.200
     1.942    35.459     0.200
     2.156    40.626     0.200
     2.749    46.387     0.200
     0.800    19.654     0.200
     0.822    19.874     0.200
     1.030    21.838     0.200
     1.177    24.659     0.200
     1.278    25.198     0.200
     2.201    36.587     0.200
     2.330    38.049     0.200
     2.643    43.727     0.200
     2.734    44.867     0.200
     2.703    44.516     0.200
     3.683    58.388     0.200
     1.376    28.310     0.200
     1.546    26.962     0.200
     1.611    30.596     0.200
     2.063    37.679     0.200
     2.509    44.029     0.200
     2.841    45.849     0.200
     1.371    28.879     0.200
     1.814    31.776     0.200
     2.296    38.013     0.200
     2.240    38.801     0.200
     2.352    40.581     0.200
     2.706    42.049     0.200
     2.484    37.641     0.200
     2.621    44.652     0.200
     2.671    41.533     0.200
     2.795    45.628     0.200
     3.044    51.043     0.200
     0.806    20.929     0.200
     1.252    26.095     0.200
     1.289    27.668     0.200
     1.325    27.194     0.200
     1.332    28.582     0.200
     1.416    28.109     0.200
     1.568    28.897     0.200
     1.486    27.778     0.200
     1.700    31.219     0.200
     2.114    37.640     0.200
     2.505    43.702     0.200
     2.635    40.801     0.200
     2.881    46.264     0.200
     3.186    53.601     0.200
     0.997    22.962     0.200
     1.263    27.537     0.200
     1.265    26.461     0.200
     1.284    26.617     0.200
     1.424    28.036     0.200
     1.487    28.457     0.200
     1.550    27.989     0.200
     1.728    28.596     0.200
     1.880    29.600     0.200
     2.159    38.387     0.200
     2.253    38.588     0.200
     2.492    40.996     0.200
     2.818    46.918     0.200
     3.131    50.847     0.200
     3.170    46.719     0.200
     3.381    53.376     0.200
     3.870    57.316     0.200
     4.094    64.824     0.200
     4.353    65.450     0.200
     1.026    19.706     0.200
     1.058    18.817     0.200
     1.134    18.300     0.200
     1.367    23.370     0.200
     1.493    26.946     0.200
     1.558    26.108     0.200
     1.732    29.731     0.200
     1.820    30.565     0.200
     1.918    32.207     0.200
     1.921    31.641     0.200
     1.999    34.349     0.200
     2.118    36.602     0.200
     2.149    35.665     0.200
     2.124    32.273     0.200
     2.549    40.457     0.200
     2.630    42.064     0.200
     2.697    43.897     0.200
     2.953    48.895     0.200
     3.352    53.011     0.200
     3.362    48.678     0.200
     3.610    52.646     0.200
     3.874    59.431     0.200
     1.281    26.581     0.200
     1.680    27.620     0.200
     1.735    27.667     0.200
     1.953    34.461     0.200
     2.205    37.398     0.200
     2.200    35.983     0.200
     2.286    35.712     0.200
     2.366    40.596     0.200
     2.435    39.477     0.200
     2.522    41.059     0.200
     2.641    44.078     0.200
     2.729    44.547     0.200
     2.804    44.908     0.200
     3.390    52.506     0.200
     3.331    52.267     0.200
     3.764    56.139     0.200
     3.868    55.598     0.200
     4.080    61.567     0.200
     4.554    66.113     0.200
     7.796   114.611     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.101    65.619     0.200
   106.244  1402.812     0.200
     2.855    56.720     0.200
     2.915    56.167     0.200
     2.708    53.529     0.200
     2.618    51.960     0.200
     2.662    52.055     0.200
     2.769    60.067     0.200
     2.862    55.131     0.200
     3.134    62.107     0.200
     2.528    50.651     0.200
     3.140    63.337     0.200
     3.221    63.093     0.200
     4.148    81.619     0.200
     3.002    58.008     0.200
     2.844    60.024     0.200
     4.246    81.763     0.200
     3.239    66.586     0.200
     3.004    62.741     0.200
     3.129    62.187     0.200
     3.086    64.233     0.200
     3.129    62.897     0.200
     3.134    61.222     0.200
     3.052    62.961     0.200
     3.056    61.618     0.200
     3.126    62.293     0.200
     2.539    51.715     0.200
     3.680    73.426     0.200
     3.133    61.327     0.200
     3.547    69.451     0.200
     2.590    56.080     0.200
     3.046    65.003     0.200
     2.500    48.906     0.200
     3.146    63.024     0.200
     3.165    67.957     0.200
     3.282    68.626     0.200
     2.956    61.824     0.200
     3.194    66.695     0.200
     4.075    78.420     0.200
     4.136    85.323     0.200
     3.027    65.064     0.200
     3.002    65.750     0.200
     2.634    55.067     0.200
     3.075    64.860     0.200
     3.170    61.892     0.200
     4.148    81.879     0.200
     3.023    57.772     0.200
     3.296    63.179     0.200
     4.101    80.238     0.200
     3.007    64.874     0.200
     3.104    61.923     0.200
     3.758    79.247     0.200
     3.109    65.069     0.200
     3.196    66.490     0.200
     3.321    63.777     0.200
     3.173    65.304     0.200
     3.245    63.751     0.200
     2.697    57.525     0.200
     3.192    66.474     0.200
     3.052    60.456     0.200
     3.653    75.830     0.200
     3.171    64.422     0.200
     3.135    67.032     0.200
     3.559    69.714     0.200
     3.178    66.982     0.200
     3.079    64.908     0.200
     3.092    65.080     0.200
     2.567    53.171     0.200
     3.033    60.709     0.200
     3.127    64.969     0.200
     3.288    64.030     0.200
     3.180    62.767     0.200
     3.224    65.218     0.200
     3.271    65.821     0.200
     2.535    50.499     0.200
     3.361    66.761     0.200
     2.571    49.492     0.200
     3.301    64.810     0.200
     3.183    67.493     0.200
     3.289    69.357     0.200
     3.066    63.499     0.200
     2.997    59.393     0.200
     3.659    73.053     0.200
     3.165    66.077     0.200
     3.080    63.420     0.200
     3.253    62.564     0.200
     3.828    77.267     0.200
     3.123    64.405     0.200
     2.968    63.932     0.200
     3.137    61.369     0.200
     2.673    55.403     0.200
     2.540    49.519     0.200
     3.203    67.347     0.200
     3.126    61.471     0.200
     3.632    77.211     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     5.745   101.059     0.200
     0.848    18.117     0.200
     1.079    23.338     0.200
     0.848    18.894     0.200
     2.479    45.359     0.200
     0.868    19.945     0.200
     0.516    12.594     0.200
     2.073    40.417     0.200
     1.084    21.944     0.200
     2.251    45.327     0.200
     2.468    48.857     0.200
     1.932    37.996     0.200
     2.776    51.148     0.200
     0.911    19.507     0.200
     1.592    31.154     0.200
     2.639    45.940     0.200
     2.849    51.184     0.200
     0.989    20.700     0.200
     1.633    32.186     0.200
     2.628    45.666     0.200
     2.788    50.603     0.200
     1.594    31.129     0.200
     2.834    51.157     0.200
     0.442    10.471     0.200
     0.540    13.622     0.200
     0.666    15.345     0.200
     1.202    22.262     0.200
     1.953    36.138     0.200
     0.292    10.929     0.200
     0.864    17.703     0.200
     1.557    30.638     0.200
     2.678    46.197     0.200
     0.831    17.212     0.200
     0.839    17.601     0.200
     2.927    51.767     0.200
     0.171     5.509     0.200
     0.776    18.834     0.200
     0.891    19.220     0.200
     0.347     8.437     0.200
     0.842    19.124     0.200
     1.011    20.501     0.200
     1.891    36.509     0.200
     1.985    37.521     0.200
     2.114    42.590     0.200
     2.368    42.806     0.200
     3.162    56.119     0.200
     1.016    20.743     0.200
     1.102    22.323     0.200
     1.489    31.229     0.200
     2.383    46.016     0.200
     3.019    52.999     0.200
     0.864    17.668     0.200
     0.865    17.976     0.200
     1.312    26.675     0.200
     1.554    30.674     0.200
     1.859    34.848     0.200
     2.673    46.036     0.200
     2.951    54.140     0.200
     0.827    17.197     0.200
     0.844    17.805     0.200
     1.335    26.039     0.200
     1.888    37.978     0.200
     1.997    37.667     0.200
     0.714    15.622     0.200
     1.940    36.005     0.200
     1.906    36.281     0.200
     1.906    35.640     0.200
     2.001    36.823     0.200
     0.204     7.374     0.200
     0.539    12.046     0.200
     1.036    20.281     0.200
     1.262    24.391     0.200
     1.511    29.249     0.200
     2.233    43.035     0.200
     2.402    43.356     0.200
     0.684    14.605     0.200
     0.862    18.476     0.200
     1.862    34.639     0.200
     2.227    40.657     0.200
     2.570    46.993     0.200
     0.392     9.799     0.200
     1.349    26.425     0.200
     1.894    36.758     0.200
     1.925    36.295     0.200
     2.301    45.522     0.200
     1.260    25.772     0.200
     1.970    36.747     0.200
     0.648    14.404     0.200
     1.471    27.684     0.200
     1.542    28.030     0.200
     1.500    28.641     0.200
     2.237    40.929     0.200
     0.494    12.172     0.200
     0.648    14.797     0.200
     0.763    16.759     0.200
     1.323    23.178     0.200
     1.456    27.682     0.200
     1.042    19.710     0.200
     0.353     9.877     0.200
     0.934    18.854     0.200
     1.041    19.689     0.200
     1.654    30.082     0.200
     1.804    34.557     0.200
     2.145    38.005     0.200
     0.463    12.527     0.200
     1.220    24.207     0.200
     1.520    28.115     0.200
     0.943    19.383     0.200
     1.219    23.652     0.200
     1.639    32.393     0.200
     1.713    32.382     0.200
     1.848    35.298     0.200
     3.135    57.537     0.200
     1.492    29.521     0.200
     2.281    40.419     0.200
     0.237     8.636     0.200
     0.488    12.052     0.200
     1.355    26.611     0.200
     1.346    25.988     0.200
     1.381    27.628     0.200
     2.255    39.199     0.200
     0.293     7.883     0.200
     0.804    17.376     0.200
     0.306     7.830     0.200
     0.764    16.640     0.200
     0.303     6.870     0.200
     0.204     5.679     0.200
     0.636    14.238     0.200
     0.352     8.893     0.200
     0.763    16.285     0.200
     1.965    36.523     0.200
     0.745    17.809     0.200
     1.077    21.525     0.200
     1.793    33.790     0.200
     0.211     4.976     0.200
     0.468    10.404     0.200
     0.911    19.974     0.200
     1.596    31.614     0.200
     0.245     7.304     0.200
     0.833    17.830     0.200
     0.419     9.568     0.200
     0.872    19.489     0.200
     0.938    20.246     0.200
     1.572    30.315     0.200
     1.841    34.574     0.200
     2.128    38.597     0.200
     0.398     9.333     0.200
     0.740    16.322     0.200
     0.336     7.896     0.200
     1.632    31.268     0.200
     1.804    34.907     0.200
     0.344     7.842     0.200
     0.711    16.174     0.200
     0.404     9.403     0.200
     0.745    15.992     0.200
     1.199    24.881     0.200
     1.659    33.210     0.200
     1.659    33.790     0.200
     1.763    35.155     0.200
     2.104    39.676     0.200
     2.249    44.544     0.200
     2.249    43.504     0.200
     3.153    59.930     0.200
     4.149    72.707     0.200
     0.427    10.183     0.200
     0.819    18.932     0.200
     0.422    10.596     0.200
     0.850    18.139     0.200
     0.981    20.912     0.200
     0.326     7.322     0.200
     0.350     8.454     0.200
     1.004    21.348     0.200
     1.563    30.344     0.200
     0.235     5.192     0.200
     0.444    10.247     0.200
     0.872    19.124     0.200
     0.931    20.182     0.200
     1.590    30.862     0.200
     2.107    39.957     0.200
     3.153    54.434     0.200
     0.208     5.170     0.200
     0.591    13.690     0.200
     0.628    14.113     0.200
     0.465    10.171     0.200
     0.886    19.957     0.200
     1.333    27.572     0.200
     2.083    39.535     0.200
     2.219    41.182     0.200
     0.186     5.746     0.200
     0.611    14.034     0.200
     0.615    13.658     0.200
     1.380    25.987     0.200
     1.927    35.073     0.200
     2.065    38.385     0.200
     2.252    39.802     0.200
     2.313    40.976     0.200
     2.840    50.065     0.200
     3.072    52.829     0.200
     3.234    58.488     0.200
     0.170     4.626     0.200
     0.476    10.999     0.200
     0.859    19.446     0.200
     0.942    21.655     0.200
     1.861    35.870     0.200
     2.451    44.278     0.200
     3.142    58.009     0.200
     0.367     8.491     0.200
     0.403     9.545     0.200
     0.276     7.058     0.200
     0.412     9.341     0.200
     0.841    19.269     0.200
     1.593    30.798     0.200
     3.162    56.699     0.200
     3.206    56.421     0.200
     0.423     9.752     0.200
     0.861    18.779     0.200
     0.947    19.750     0.200
     2.129    39.837     0.200
     0.375     8.958     0.200
     0.847    20.050     0.200
     0.978    22.410     0.200
     1.852    35.547     0.200
     0.323     8.299     0.200
     0.678    15.666     0.200
     1.656    32.070     0.200
     1.330    25.572     0.200
     1.799    34.068     0.200
     0.567    13.621     0.200
     0.678    15.465     0.200
     0.847    18.887     0.200
     0.955    19.369     0.200
     1.603    30.587     0.200
     2.125    40.263     0.200
     3.142    57.264     0.200
     3.186    54.439     0.200
     0.471    10.424     0.200
     0.965    21.096     0.200
     1.526    29.947     0.200
     0.756    18.316     0.200
     1.039    21.921     0.200
     1.519    29.706     0.200
     2.352    42.609     0.200
     3.126    57.235     0.200
     0.562    12.774     0.200
     0.734    16.648     0.200
     1.921    36.804     0.200
     1.958    37.715     0.200
     2.225    41.286     0.200
     2.334    43.316     0.200
     3.130    57.635     0.200
     3.178    57.889     0.200
     3.178    55.981     0.200
     0.328     7.690     0.200
     0.683    15.038     0.200
     1.655    32.780     0.200
     0.290     7.768     0.200
     0.712    14.754     0.200
     2.370    47.026     0.200
     3.271    60.845     0.200
     0.587    12.840     0.200
     0.651    14.558     0.200
     0.721    16.224     0.200
     0.460     9.996     0.200
     0.469    11.021     0.200
     3.598    65.984     0.200
     0.589    12.979     0.200
     0.638    14.713     0.200
     1.541    29.887     0.200
     1.858    33.930     0.200
     2.318    41.987     0.200
     3.260    55.367     0.200
     0.388     9.731     0.200
     0.867    18.863     0.200
     0.954    20.488     0.200
     2.156    39.694     0.200
     2.289    41.163     0.200
     2.554    44.764     0.200
     3.194    58.825     0.200
     0.459     9.984     0.200
     0.873    20.074     0.200
     1.600    31.180     0.200
     1.812    36.124     0.200
     2.094    39.240     0.200
     2.221    41.194     0.200
     2.181    43.287     0.200
     0.415     9.927     0.200
     0.720    16.429     0.200
     1.084    23.298     0.200
     2.239    41.554     0.200
     2.652    48.063     0.200
     3.142    56.939     0.200
     3.184    56.967     0.200
     0.384     8.838     0.200
     0.682    15.059     0.200
     1.688    33.256     0.200
     2.019    40.212     0.200
     2.275    42.221     0.200
     2.708    49.482     0.200
     3.176    59.899     0.200
     3.218    58.007     0.200
     0.530    10.941     0.200
     0.842    18.952     0.200
     1.697    33.492     0.200
     2.182    40.353     0.200
     0.559    13.199     0.200
     0.665    15.022     0.200
     1.884    34.940     0.200
     2.084    40.166     0.200
     1.026    20.971     0.200
     1.679    32.874     0.200
     3.249    60.543     0.200
     0.425     9.659     0.200
     0.701    15.972     0.200
     1.182    24.651     0.200
     1.450    29.762     0.200
     1.701    34.054     0.200
     2.223    43.374     0.200
     3.174    56.824     0.200
     0.777    17.682     0.200
     1.837    35.278     0.200
     3.231    60.046     0.200
     0.471    10.488     0.200
     0.852    19.411     0.200
     2.093    39.540     0.200
     0.573    13.203     0.200
     0.668    13.934     0.200
     2.017    38.535     0.200
     3.197    58.785     0.200
     3.281    57.132     0.200
     0.504    11.104     0.200
     0.768    17.476     0.200
     2.115    40.047     0.200
     2.966    56.476     0.200
     3.099    56.430     0.200
     0.502    11.391     0.200
     1.525    29.584     0.200
     0.437     9.653     0.200
     0.654    14.925     0.200
     1.153    25.170     0.200
     1.414    29.155     0.200
     1.737    34.427     0.200
     2.226    44.727     0.200
     2.252    43.695     0.200
     3.052    55.200     0.200
     0.383     8.979     0.200
     0.443    10.381     0.200
     0.676    15.370     0.200
     1.691    32.949     0.200
     1.747    33.506     0.200
     2.011    39.277     0.200
     2.277    41.950     0.200
     0.358     7.990     0.200
     0.423    10.459     0.200
     0.710    16.307     0.200
     1.132    24.776     0.200
     2.028    39.859     0.200
     2.275    42.443     0.200
     2.298    44.578     0.200
     0.292     6.769     0.200
     0.432     9.779     0.200
     0.808    17.690     0.200
     1.544    30.429     0.200
     1.632    31.847     0.200
     1.782    34.636     0.200
     2.229    40.439     0.200
     3.177    54.925     0.200
     0.335     7.931     0.200
     0.450     9.940     0.200
     0.698    15.977     0.200
     1.101    23.983     0.200
     1.650    33.040     0.200
     1.793    35.065     0.200
     3.225    59.615     0.200
     0.420     9.764     0.200
     0.437     9.931     0.200
     0.674    15.312     0.200
     1.703    33.650     0.200
     1.726    33.928     0.200
     2.045    40.022     0.200
     2.235    41.382     0.200
     2.221    41.449     0.200
     0.191     4.664     0.200
     0.549    12.574     0.200
     0.688    15.452     0.200
     1.412    27.856     0.200
     1.952    36.676     0.200
     2.056    38.828     0.200
     2.266    46.179     0.200
     0.255     5.333     0.200
     0.425     9.442     0.200
     0.858    19.260     0.200
     0.949    21.391     0.200
     1.576    31.094     0.200
     1.588    31.124     0.200
     1.825    35.323     0.200
     2.128    40.285     0.200
     2.249    40.942     0.200
     0.338     7.822     0.200
     0.463    10.639     0.200
     0.684    15.403     0.200
     1.786    36.950     0.200
     1.660    33.122     0.200
     2.324    44.135     0.200
     3.225    59.899     0.200
     3.722    65.748     0.200
     0.572    12.557     0.200
     0.675    15.385     0.200
     0.341     8.242     0.200
     0.464    10.501     0.200
     0.682    15.888     0.200
     1.091    24.283     0.200
     1.155    25.165     0.200
     0.322     8.137     0.200
     0.470    10.762     0.200
     0.690    15.379     0.200
     1.157    24.645     0.200
     1.648    32.953     0.200
     2.340    45.717     0.200
     3.823    66.951     0.200
     0.351     8.448     0.200
     0.398     9.174     0.200
     0.761    17.614     0.200
     2.256    42.589     0.200
     2.203    42.076     0.200
     2.101    40.284     0.200
     3.203    57.032     0.200
     0.387     9.015     0.200
     0.397     9.117     0.200
     0.723    15.805     0.200
     1.757    34.274     0.200
     1.670    31.892     0.200
     2.230    40.563     0.200
     0.150     4.785     0.200
     0.481    11.081     0.200
     0.816    17.604     0.200
     0.993    21.703     0.200
     1.506    29.488     0.200
     1.909    36.080     0.200
     0.209     6.005     0.200
     0.547    12.633     0.200
     0.680    15.264     0.200
     1.157    22.638     0.200
     1.868    36.861     0.200
     2.186    39.451     0.200
     0.624    14.504     0.200
     1.189    23.589     0.200
     1.435    27.102     0.200
     1.499    29.401     0.200
     1.594    31.290     0.200
     2.041    39.882     0.200
     2.158    42.526     0.200
     2.620    48.116     0.200
     2.689    47.986     0.200
     0.439     9.955     0.200
     0.497    10.946     0.200
     0.640    15.360     0.200
     1.192    25.395     0.200
     1.147    25.116     0.200
     1.442    26.677     0.200
     1.505    28.842     0.200
     2.166    42.231     0.200
     0.393     9.586     0.200
     0.405     9.702     0.200
     0.713    15.817     0.200
     1.448    27.416     0.200
     1.583    31.155     0.200
     1.681    32.832     0.200
     1.745    33.519     0.200
     2.249    43.184     0.200
     2.664    47.126     0.200
     3.436    59.163     0.200
     0.162     5.382     0.200
     0.572    13.400     0.200
     0.676    15.023     0.200
     2.194    39.455     0.200
     2.249    42.675     0.200
     3.124    53.980     0.200
     0.336     8.274     0.200
     0.453     9.995     0.200
     0.752    16.943     0.200
     1.514    30.753     0.200
     1.512    29.397     0.200
     1.730    33.539     0.200
     2.601    46.740     0.200
     3.377    58.913     0.200
     0.511    12.093     0.200
     0.711    15.655     0.200
     2.155    39.039     0.200
     0.196     5.961     0.200
     0.534    12.536     0.200
     0.706    15.761     0.200
     1.126    22.310     0.200
     2.055    38.383     0.200
     0.199     5.932     0.200
     0.540    12.267     0.200
     0.695    15.768     0.200
     1.408    27.267     0.200
     2.172    40.060     0.200
     2.269    42.283     0.200
     0.233     6.140     0.200
     0.515    12.094     0.200
     0.709    15.844     0.200
     1.131    22.440     0.200
     1.382    27.109     0.200
     2.157    39.427     0.200
     0.305     6.077     0.200
     0.406     9.638     0.200
     0.808    17.570     0.200
     1.527    30.454     0.200
     1.801    35.438     0.200
     2.584    47.505     0.200
     0.249     6.467     0.200
     0.495    12.332     0.200
     0.728    15.417     0.200
     1.114    22.650     0.200
     1.829    35.817     0.200
     2.105    40.689     0.200
     2.290    43.122     0.200
     3.092    55.009     0.200
     0.207     5.686     0.200
     0.771    16.208     0.200
     0.787    17.801     0.200
     1.612    34.238     0.200
     0.086     5.311     0.200
     0.729    17.111     0.200
     0.690    15.878     0.200
     3.238    57.599     0.200
     0.250     6.477     0.200
     0.557    12.776     0.200
     0.655    14.627     0.200
     1.195    23.392     0.200
     3.027    52.665     0.200
     0.305     6.932     0.200
     0.397     9.353     0.200
     0.815    17.897     0.200
     1.604    30.706     0.200
     1.812    34.302     0.200
     2.145    41.121     0.200
     2.172    39.731     0.200
     2.265    41.793     0.200
     3.828    65.852     0.200
     0.186     4.530     0.200
     0.606    13.520     0.200
     0.619    14.367     0.200
     1.227    24.397     0.200
     1.378    26.653     0.200
     1.935    35.620     0.200
     2.064    39.604     0.200
     2.317    41.841     0.200
     2.501    47.184     0.200
     2.885    53.682     0.200
     0.981    20.836     0.200
     1.605    28.814     0.200
     2.277    41.666     0.200
     3.625    66.839     0.200
     3.691    65.571     0.200
     0.569    12.574     0.200
     0.700    16.888     0.200
     1.468    28.060     0.200
     1.502    31.477     0.200
     1.952    37.472     0.200
     2.313    42.994     0.200
     2.429    47.353     0.200
     0.503    11.919     0.200
     0.586    14.841     0.200
     0.625    13.819     0.200
     1.398    27.565     0.200
     1.470    27.263     0.200
     1.914    36.773     0.200
     2.052    38.843     0.200
     2.690    50.335     0.200
     2.949    53.677     0.200
     0.486    11.048     0.200
     0.594    14.280     0.200
     0.590    13.025     0.200
     1.428    25.858     0.200
     2.084    41.236     0.200
     0.127     5.233     0.200
     0.627    14.313     0.200
     1.200    23.383     0.200
     3.740    64.903     0.200
     0.482    10.819     0.200
     0.500    11.642     0.200
     0.598    13.663     0.200
     2.175    40.203     0.200
     1.318    24.706     0.200
     0.297     9.155     0.200
     1.825    34.478     0.200
     3.204    55.585     0.200
     3.398    60.303     0.200
     0.331     8.217     0.200
     0.454    10.359     0.200
     0.757    17.790     0.200
     1.531    28.071     0.200
     1.732    34.269     0.200
     1.684    32.895     0.200
     2.130    44.623     0.200
     0.155     4.227     0.200
     0.155     4.397     0.200
     0.494    11.658     0.200
     0.849    18.667     0.200
     0.948    20.406     0.200
     1.364    27.781     0.200
     1.384    27.496     0.200
     5.318    95.403     0.200
     0.329     8.406     0.200
     0.446    10.068     0.200
     0.762    17.595     0.200
     1.511    29.580     0.200
     1.516    29.567     0.200
     1.539    28.625     0.200
     1.741    34.306     0.200
     2.208    41.473     0.200
     0.175     4.652     0.200
     0.542    11.433     0.200
     0.883    19.352     0.200
     0.902    21.037     0.200
     1.354    27.545     0.200
     1.396    28.842     0.200
     1.470    26.814     0.200
     1.772    36.437     0.200
     0.522    12.053     0.200
     0.705    15.729     0.200
     1.133    20.425     0.200
     1.845    35.695     0.200
     2.086    38.552     0.200
     0.498    11.355     0.200
     0.756    16.127     0.200
     1.075    21.315     0.200
     1.449    27.206     0.200
     2.045    37.641     0.200
     2.114    37.318     0.200
     0.350     8.914     0.200
     0.364     8.391     0.200
     0.785    18.149     0.200
     1.481    28.240     0.200
     1.606    31.502     0.200
     1.816    34.976     0.200
     2.292    42.962     0.200
     2.630    46.441     0.200
     3.106    55.592     0.200
     0.234     7.734     0.200
     2.121    38.038     0.200
     0.437    10.616     0.200
     0.686    15.954     0.200
     1.628    33.702     0.200
     0.290     6.264     0.200
     0.437    10.133     0.200
     1.483    30.246     0.200
     1.636    31.712     0.200
     2.143    40.172     0.200
     0.278     7.750     0.200
     0.447    10.817     0.200
     1.655    32.791     0.200
     0.354     8.130     0.200
     0.489    11.486     0.200
     1.681    33.356     0.200
     2.365    44.003     0.200
     3.145    56.837     0.200
     0.325     8.117     0.200
     0.496    11.158     0.200
     1.694    33.874     0.200
     2.337    43.680     0.200
     3.286    60.425     0.200
     0.212     6.315     0.200
     0.508    12.712     0.200
     0.737    15.919     0.200
     1.095    22.586     0.200
     0.296     7.549     0.200
     0.436     9.878     0.200
     1.643    33.550     0.200
     2.338    43.030     0.200
     0.389     8.613     0.200
     0.511    11.573     0.200
     1.211    25.737     0.200
     1.694    34.211     0.200
     2.383    44.945     0.200
     0.296     7.550     0.200
     0.419     9.823     0.200
     1.494    29.937     0.200
     2.474    45.820     0.200
     0.322     8.090     0.200
     0.486    11.121     0.200
     1.657    32.778     0.200
     1.685    33.731     0.200
     0.347     8.528     0.200
     0.697    15.917     0.200
     1.640    30.646     0.200
     1.657    31.999     0.200
     1.783    34.591     0.200
     2.007    38.447     0.200
     2.064    37.846     0.200
     2.296    41.703     0.200
     2.293    43.881     0.200
     2.311    41.404     0.200
     2.377    44.419     0.200
     0.315     7.869     0.200
     1.425    26.669     0.200
     1.598    32.141     0.200
     1.613    34.529     0.200
     3.242    58.861     0.200
     0.311     8.051     0.200
     1.679    32.496     0.200
     1.810    36.136     0.200
     2.333    43.516     0.200
     3.295    60.435     0.200
     0.393     9.091     0.200
     0.737    16.545     0.200
     1.460    27.838     0.200
     1.767    35.356     0.200
     2.224    41.977     0.200
     2.261    44.438     0.200
     0.309     7.656     0.200
     0.451    10.498     0.200
     1.534    30.171     0.200
     1.666    32.834     0.200
     0.345     8.089     0.200
     0.495    10.996     0.200
     1.522    28.647     0.200
     0.447    11.159     0.200
     1.384    25.366     0.200
     1.640    31.512     0.200
     2.306    41.767     0.200
     2.359    43.912     0.200
     3.707    63.841     0.200
     0.597    13.410     0.200
     1.236    24.829     0.200
     1.868    34.988     0.200
     3.079    55.985     0.200
     0.442    10.073     0.200
     1.463    28.838     0.200
     3.032    56.566     0.200
     0.430    10.375     0.200
     1.555    31.466     0.200
     1.536    31.518     0.200
     1.677    32.562     0.200
     2.621    48.644     0.200
     0.378     9.088     0.200
     1.500    29.790     0.200
     1.534    29.825     0.200
     1.609    33.069     0.200
     1.606    31.290     0.200
     2.119    41.540     0.200
     2.063    37.698     0.200
     0.328     7.709     0.200
     1.646    32.234     0.200
     1.656    32.641     0.200
     2.046    38.810     0.200
     3.155    57.124     0.200
     3.274    59.082     0.200
     3.826    66.560     0.200
     0.345     8.220     0.200
     1.357    27.942     0.200
     0.429    10.052     0.200
     1.496    28.806     0.200
     1.531    30.061     0.200
     4.099    75.707     0.200
     0.456    10.078     0.200
     1.511    29.658     0.200
     0.552    13.155     0.200
     0.669    14.654     0.200
     1.171    22.877     0.200
     1.635    32.708     0.200
     1.370    26.266     0.200
     2.025    38.066     0.200
     3.056    52.951     0.200
     0.438    10.090     0.200
     2.115    39.068     0.200
     3.547    61.164     0.200
     0.314     7.138     0.200
     1.680    32.279     0.200
     2.031    38.435     0.200
     0.527    11.788     0.200
     0.809    17.364     0.200
     1.323    25.868     0.200
     0.399     9.181     0.200
     0.892    19.666     0.200
     2.005    37.708     0.200
     3.109    56.307     0.200
     3.265    56.666     0.200
     0.827    18.167     0.200
     0.973    21.683     0.200
     1.469    28.951     0.200
     1.622    30.519     0.200
     1.791    33.584     0.200
     2.131    38.998     0.200
     2.179    42.488     0.200
     0.853    19.502     0.200
     0.963    20.926     0.200
     1.840    34.251     0.200
     2.056    38.125     0.200
     2.153    39.792     0.200
     3.080    57.723     0.200
     0.356     8.748     0.200
     0.640    14.935     0.200
     1.196    23.942     0.200
     1.696    32.385     0.200
     1.759    33.431     0.200
     2.319    44.747     0.200
     0.415     9.644     0.200
     0.855    19.303     0.200
     0.955    21.826     0.200
     2.071    38.483     0.200
     2.258    41.000     0.200
     3.063    54.492     0.200
     0.333     8.038     0.200
     0.690    15.415     0.200
     1.090    23.812     0.200
     1.660    32.463     0.200
     1.654    31.960     0.200
     1.792    35.246     0.200
     1.988    37.803     0.200
     2.051    38.300     0.200
     2.329    44.320     0.200
     0.161     4.479     0.200
     0.741    15.977     0.200
     0.932    20.076     0.200
     1.547    30.635     0.200
     1.819    37.083     0.200
     1.868    39.115     0.200
     1.956    39.714     0.200
     2.310    45.903     0.200
     0.512    10.177     0.200
     1.218    25.951     0.200
     1.127    24.761     0.200
     1.485    30.469     0.200
     1.560    31.792     0.200
     2.191    42.064     0.200
     2.973    54.894     0.200
     0.503    10.790     0.200
     0.855    19.596     0.200
     0.939    20.787     0.200
     1.361    27.558     0.200
     1.837    35.345     0.200
     2.111    39.675     0.200
     2.205    41.180     0.200
     2.998    54.370     0.200
     0.445    10.372     0.200
     0.879    19.693     0.200
     0.924    19.849     0.200
     1.434    26.598     0.200
     1.585    30.133     0.200
     1.827    33.819     0.200
     2.221    41.337     0.200
     2.509    44.896     0.200
     0.573    13.146     0.200
     0.658    14.562     0.200
     1.883    34.054     0.200
     2.044    37.248     0.200
     0.601    15.263     0.200
     0.619    13.539     0.200
     1.219    23.740     0.200
     1.929    35.629     0.200
     2.084    38.538     0.200
     2.328    43.179     0.200
     0.548    11.642     0.200
     1.881    36.962     0.200
     2.096    40.501     0.200
     0.310     7.434     0.200
     1.653    32.398     0.200
     1.950    38.661     0.200
     2.032    38.145     0.200
     0.433     9.653     0.200
     0.868    19.339     0.200
     1.456    28.423     0.200
     1.585    31.119     0.200
     2.117    39.634     0.200
     0.342     8.276     0.200
     0.545    12.310     0.200
     0.617    13.596     0.200
     1.017    21.292     0.200
     1.237    25.978     0.200
     1.694    33.980     0.200
     2.062    39.288     0.200
     2.351    47.555     0.200
     0.411    10.066     0.200
     0.673    16.195     0.200
     1.193    23.813     0.200
     2.178    41.384     0.200
     3.135    55.072     0.200
     0.321     7.433     0.200
     0.536    11.702     0.200
     0.755    17.780     0.200
     1.028    23.121     0.200
     1.463    28.455     0.200
     3.295    58.336     0.200
     0.423     9.351     0.200
     0.240     5.592     0.200
     0.451    10.080     0.200
     0.859    19.251     0.200
     1.606    31.208     0.200
     1.806    34.489     0.200
     2.106    39.605     0.200
     2.103    39.294     0.200
     2.223    40.812     0.200
     3.174    55.316     0.200
     0.465    10.491     0.200
     0.630    14.631     0.200
     1.163    25.074     0.200
     1.591    31.568     0.200
     1.770    34.399     0.200
     2.202    40.866     0.200
     2.584    48.033     0.200
     0.506    11.770     0.200
     0.607    14.171     0.200
     1.172    25.378     0.200
     1.508    29.430     0.200
     2.225    41.402     0.200
     3.105    57.918     0.200
     0.393     9.507     0.200
     0.769    17.930     0.200
     1.635    32.461     0.200
     2.087    39.075     0.200
     3.664    67.453     0.200
     0.391     8.979     0.200
     0.802    18.453     0.200
     1.413    29.275     0.200
     1.597    31.609     0.200
     3.216    60.617     0.200
     0.433     9.861     0.200
     0.825    18.372     0.200
     0.977    21.565     0.200
     1.400    27.329     0.200
     2.232    40.813     0.200
     0.346     8.185     0.200
     0.722    16.891     0.200
     1.353    26.106     0.200
     1.486    28.731     0.200
     0.302     8.427     0.200
     0.418     9.620     0.200
     0.805    18.400     0.200
     1.499    28.575     0.200
     1.625    31.279     0.200
     2.242    40.396     0.200
     0.839    19.107     0.200
     1.371    27.370     0.200
     2.195    40.429     0.200
     0.414     9.843     0.200
     0.838    18.696     0.200
     1.480    28.136     0.200
     1.597    30.342     0.200
     2.146    39.620     0.200
     2.253    40.686     0.200
     2.470    47.750     0.200
     3.159    58.066     0.200
     0.251     6.419     0.200
     0.419     9.580     0.200
     0.869    19.509     0.200
     1.574    30.048     0.200
     2.090    39.638     0.200
     2.128    39.544     0.200
     2.199    43.276     0.200
     0.401     9.222     0.200
     0.304     6.932     0.200
     0.813    18.630     0.200
     1.404    28.409     0.200
     1.608    31.946     0.200
     2.040    38.885     0.200
     2.260    43.314     0.200
     3.070    54.797     0.200
     0.270     7.009     0.200
     0.656    14.904     0.200
     0.947    19.755     0.200
     2.368    43.770     0.200
     0.481    11.004     0.200
     1.012    22.042     0.200
     1.402    27.773     0.200
     1.486    29.447     0.200
     2.040    38.464     0.200
     2.276    42.972     0.200
     0.615    13.546     0.200
     1.407    27.657     0.200
     1.919    37.050     0.200
     3.241    59.876     0.200
     0.476    10.709     0.200
     0.697    15.131     0.200
     1.220    25.184     0.200
     1.513    29.528     0.200
     1.533    28.615     0.200
     1.682    33.429     0.200
     1.739    33.493     0.200
     2.178    41.124     0.200
     2.186    40.957     0.200
     0.355     8.487     0.200
     0.687    15.394     0.200
     0.687    14.794     0.200
     1.109    23.196     0.200
     1.109    25.056     0.200
     1.521    28.705     0.200
     1.521    29.965     0.200
     1.668    33.600     0.200
     1.773    35.773     0.200
     1.773    36.763     0.200
     2.305    43.047     0.200
     4.811    89.702     0.200
     0.750    16.208     0.200
     1.020    19.392     0.200
     1.104    20.993     0.200
     1.521    30.325     0.200
     1.415    26.795     0.200
     1.694    31.625     0.200
     2.378    41.050     0.200
     2.385    44.119     0.200
     3.344    56.650     0.200
     0.558    12.593     0.200
     0.787    18.706     0.200
     1.002    23.834     0.200
     1.551    30.790     0.200
     2.184    41.695     0.200
     2.184    42.898     0.200
     0.462    12.070     0.200
     0.645    13.380     0.200
     0.803    16.555     0.200
     2.573    46.068     0.200
     0.289     7.130     0.200
     0.441     9.849     0.200
     0.807    17.656     0.200
     0.991    22.035     0.200
     1.639    32.128     0.200
     2.022    37.866     0.200
     2.140    39.500     0.200
     2.219    43.837     0.200
     0.266     6.808     0.200
     0.857    18.842     0.200
     1.473    28.444     0.200
     1.577    30.788     0.200
     1.837    34.655     0.200
     2.063    37.914     0.200
     2.184    42.449     0.200
     2.143    39.270     0.200
     2.266    41.854     0.200
     3.071    54.082     0.200
     0.173     4.858     0.200
     0.399     8.738     0.200
     0.442     9.830     0.200
     0.485    11.061     0.200
     0.770    16.366     0.200
     0.927    20.485     0.200
     1.499    29.289     0.200
     1.572    30.618     0.200
     1.840    35.781     0.200
     2.052    38.790     0.200
     2.127    40.656     0.200
     2.099    38.993     0.200
     0.361     8.783     0.200
     0.656    14.041     0.200
     1.049    21.246     0.200
     1.179    24.421     0.200
     1.319    26.610     0.200
     0.076     3.055     0.200
     0.446     9.576     0.200
     0.663    15.989     0.200
     0.768    15.530     0.200
     0.948    20.943     0.200
     1.001    22.649     0.200
     1.499    29.351     0.200
     0.158     3.030     0.200
     1.531    30.977     0.200
     1.782    35.872     0.200
     0.212     7.264     0.200
     0.338     8.574     0.200
     0.517    13.431     0.200
     0.609    13.362     0.200
     0.730    16.236     0.200
     0.936    20.508     0.200
     1.052    20.658     0.200
     1.457    30.434     0.200
     1.630    30.736     0.200
     1.866    36.925     0.200
     1.808    34.559     0.200
     2.036    37.768     0.200
     2.452    43.487     0.200
     2.693    47.589     0.200
     3.241    57.215     0.200
     0.264     5.573     0.200
     0.352     7.908     0.200
     0.383     8.702     0.200
     0.428     9.503     0.200
     0.856    18.544     0.200
     0.845    18.772     0.200
     0.845    18.612     0.200
     1.378    27.819     0.200
     1.466    28.543     0.200
     2.087    38.903     0.200
     2.186    41.659     0.200
     0.420     9.564     0.200
     0.961    22.247     0.200
     1.471    27.596     0.200
     2.183    42.845     0.200
     2.669    47.406     0.200
     0.260     6.572     0.200
     0.421     9.934     0.200
     0.856    18.495     0.200
     1.366    27.541     0.200
     1.826    34.779     0.200
     2.076    38.373     0.200
     0.281     6.484     0.200
     0.363     8.207     0.200
     0.413     9.471     0.200
     0.590    12.987     0.200
     0.753    16.726     0.200
     0.774    16.779     0.200
     0.915    19.378     0.200
     1.445    27.942     0.200
     1.773    34.468     0.200
     2.122    41.503     0.200
     2.230    44.655     0.200
     2.242    41.469     0.200
     0.345     7.851     0.200
     0.736    16.655     0.200
     0.736    16.366     0.200
     1.053    22.353     0.200
     1.249    27.239     0.200
     2.176    45.384     0.200
     2.175    42.108     0.200
     0.133     6.372     0.200
     0.582    12.899     0.200
     1.068    19.693     0.200
     1.163    21.590     0.200
     1.476    28.423     0.200
     1.459    31.227     0.200
     1.642    29.944     0.200
     1.565    29.670     0.200
     1.818    35.438     0.200
     2.426    43.234     0.200
     0.368     8.482     0.200
     0.453    10.001     0.200
     0.832    17.183     0.200
     0.854    19.019     0.200
     0.944    21.269     0.200
     1.442    27.473     0.200
     2.107    39.117     0.200
     2.107    39.491     0.200
     0.466    10.453     0.200
     0.767    16.114     0.200
     0.846    17.967     0.200
     1.262    25.198     0.200
     1.395    26.340     0.200
     1.528    32.162     0.200
     2.599    46.648     0.200
     0.977    19.407     0.200
     2.535    46.564     0.200
     0.452    10.080     0.200
     0.804    17.918     0.200
     0.854    18.543     0.200
     0.900    20.133     0.200
     0.904    19.904     0.200
     1.690    32.019     0.200
     1.844    34.562     0.200
     2.088    37.916     0.200
     2.242    40.683     0.200
     2.241    44.463     0.200
     2.699    48.971     0.200
     2.748    49.018     0.200
     0.295     7.355     0.200
     0.350     8.727     0.200
     0.438     9.877     0.200
     0.564    13.560     0.200
     0.877    17.981     0.200
     0.882    20.110     0.200
     1.542    29.921     0.200
     1.588    31.226     0.200
     1.773    34.115     0.200
     2.017    36.793     0.200
     2.145    39.410     0.200
     2.225    41.618     0.200
     2.658    49.380     0.200
     2.672    48.688     0.200
     2.874    51.468     0.200
     0.480    12.363     0.200
     0.619    13.659     0.200
     0.663    14.953     0.200
     0.950    18.729     0.200
     1.143    23.818     0.200
     1.194    23.746     0.200
     1.456    27.662     0.200
     1.480    28.471     0.200
     1.682    33.170     0.200
     2.006    35.329     0.200
     2.522    43.127     0.200
     0.236     8.444     0.200
     0.498    11.974     0.200
     0.588    12.836     0.200
     0.894    18.980     0.200
     0.901    18.585     0.200
     1.062    20.559     0.200
     1.067    21.493     0.200
     1.134    21.953     0.200
     1.235    23.330     0.200
     1.511    29.266     0.200
     1.531    30.043     0.200
     1.530    29.720     0.200
     1.819    34.293     0.200
     2.130    40.775     0.200
     2.275    43.657     0.200
     2.453    42.470     0.200
     2.435    42.853     0.200
     3.069    53.103     0.200
     3.343    60.001     0.200
     3.597    60.583     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
