#!/bin/bash
gmt begin bohol1.86_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance bohol1.86'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    17.130
     0.900    18.511
     1.000    19.893
     1.100    21.274
     1.200    22.656
     1.300    24.037
     1.400    25.418
     1.500    26.800
     1.600    28.181
     1.700    29.563
     1.800    30.944
     1.900    32.325
     2.000    33.707
     2.100    35.088
     2.200    36.470
     2.300    37.851
     2.400    39.233
     2.500    40.614
     2.600    41.995
     2.700    43.377
     2.800    44.757
     2.900    46.138
     3.000    47.518
     3.100    48.899
     3.200    50.279
     3.300    51.660
     3.400    53.040
     3.500    54.421
     3.600    55.801
     3.700    57.180
     3.800    58.560
     3.900    59.940
     4.000    61.319
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.801 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.028
     0.200     4.410
     0.300     6.049
     0.400     7.783
     0.500     9.561
     0.600    11.362
     0.700    13.178
     0.800    15.002
     0.900    16.832
     1.000    18.666
     1.100    20.413
     1.200    22.118
     1.300    23.823
     1.400    25.529
     1.500    27.234
     1.600    28.939
     1.700    30.644
     1.800    32.350
     1.900    34.055
     2.000    35.760
     2.100    37.465
     2.200    39.171
     2.300    40.876
     2.400    42.581
     2.500    44.286
     2.600    45.991
     2.700    47.696
     2.800    49.401
     2.900    51.106
     3.000    52.811
     3.100    54.516
     3.200    56.221
     3.300    57.926
     3.400    59.631
     3.500    61.335
     3.600    63.040
     3.700    64.745
     3.800    66.449
     3.900    68.154
     4.000    69.859
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.040 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.800    29.814
     0.900    32.281
     1.000    34.748
     1.100    37.215
     1.200    39.682
     1.300    42.149
     1.400    44.616
     1.500    47.083
     1.600    49.550
     1.700    52.017
     1.800    54.484
     1.900    56.950
     2.000    59.417
     2.100    61.884
     2.200    64.351
     2.300    66.818
     2.400    69.285
     2.500    71.752
     2.600    74.219
     2.700    76.686
     2.800    79.153
     2.900    81.620
     3.000    84.086
     3.100    86.553
     3.200    89.020
     3.300    91.486
     3.400    93.951
     3.500    96.417
     3.600    98.883
     3.700   101.349
     3.800   103.814
     3.900   106.280
     4.000   108.746
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    96.883 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.506
     0.200     8.019
     0.300    10.998
     0.400    14.151
     0.500    17.384
     0.600    20.659
     0.700    23.960
     0.800    27.046
     0.900    29.925
     1.000    32.804
     1.100    35.683
     1.200    38.562
     1.300    41.441
     1.400    44.320
     1.500    47.199
     1.600    50.078
     1.700    52.957
     1.800    55.836
     1.900    58.715
     2.000    61.594
     2.100    64.473
     2.200    67.352
     2.300    70.231
     2.400    73.109
     2.500    75.988
     2.600    78.866
     2.700    81.745
     2.800    84.623
     2.900    87.502
     3.000    90.380
     3.100    93.259
     3.200    96.138
     3.300    99.015
     3.400   101.893
     3.500   104.771
     3.600   107.649
     3.700   110.527
     3.800   113.405
     3.900   116.282
     4.000   119.160
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   106.649 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.107
     1.000    21.488
     1.100    22.870
     1.200    24.251
     1.300    25.633
     1.400    27.014
     1.500    28.395
     1.600    29.777
     1.700    31.158
     1.800    32.540
     1.900    33.921
     2.000    35.302
     2.100    36.684
     2.200    38.065
     2.300    39.447
     2.400    40.828
     2.500    42.209
     2.600    43.591
     2.700    44.972
     2.800    46.354
     2.900    47.734
     3.000    49.115
     3.100    50.496
     3.200    51.876
     3.300    53.256
     3.400    54.637
     3.500    56.017
     3.600    57.398
     3.700    58.778
     3.800    60.158
     3.900    61.538
     4.000    62.918
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.853
     0.200     3.706
     0.300     5.559
     0.400     7.413
     0.500     9.266
     0.600    11.119
     0.700    12.972
     0.800    14.825
     0.900    16.678
     1.000    18.532
     1.100    20.385
     1.200    22.238
     1.300    24.091
     1.400    25.944
     1.500    27.797
     1.600    29.651
     1.700    31.504
     1.800    33.282
     1.900    34.987
     2.000    36.693
     2.100    38.398
     2.200    40.103
     2.300    41.808
     2.400    43.514
     2.500    45.219
     2.600    46.924
     2.700    48.629
     2.800    50.334
     2.900    52.040
     3.000    53.745
     3.100    55.450
     3.200    57.154
     3.300    58.859
     3.400    60.564
     3.500    62.269
     3.600    63.974
     3.700    65.679
     3.800    67.384
     3.900    69.089
     4.000    70.793
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    37.713
     1.100    40.180
     1.200    42.647
     1.300    45.113
     1.400    47.580
     1.500    50.047
     1.600    52.514
     1.700    54.981
     1.800    57.448
     1.900    59.915
     2.000    62.382
     2.100    64.849
     2.200    67.316
     2.300    69.783
     2.400    72.249
     2.500    74.716
     2.600    77.183
     2.700    79.650
     2.800    82.117
     2.900    84.584
     3.000    87.051
     3.100    89.518
     3.200    91.985
     3.300    94.451
     3.400    96.918
     3.500    99.383
     3.600   101.849
     3.700   104.315
     3.800   106.780
     3.900   109.246
     4.000   111.712
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.369
     0.200     6.739
     0.300    10.108
     0.400    13.478
     0.500    16.847
     0.600    20.216
     0.700    23.586
     0.800    26.955
     0.900    30.324
     1.000    33.694
     1.100    37.063
     1.200    40.433
     1.300    43.698
     1.400    46.577
     1.500    49.456
     1.600    52.335
     1.700    55.214
     1.800    58.093
     1.900    60.972
     2.000    63.851
     2.100    66.730
     2.200    69.609
     2.300    72.488
     2.400    75.367
     2.500    78.246
     2.600    81.125
     2.700    84.003
     2.800    86.881
     2.900    89.760
     3.000    92.638
     3.100    95.517
     3.200    98.395
     3.300   101.274
     3.400   104.152
     3.500   107.031
     3.600   109.909
     3.700   112.786
     3.800   115.664
     3.900   118.542
     4.000   121.421
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.630
     0.200     9.080
     0.300     9.781
     0.400    10.679
     0.500    11.722
     0.600    12.869
     0.700    14.086
     0.800    15.351
     0.900    16.648
     1.000    17.966
     1.100    19.298
     1.200    20.641
     1.300    21.991
     1.400    23.346
     1.500    24.705
     1.600    26.067
     1.700    27.431
     1.800    28.797
     1.900    30.165
     2.000    31.533
     2.100    32.903
     2.200    34.273
     2.300    35.644
     2.400    37.016
     2.500    38.388
     2.600    39.760
     2.700    41.133
     2.800    42.506
     2.900    43.879
     3.000    45.252
     3.100    46.626
     3.200    47.999
     3.300    49.373
     3.400    50.747
     3.500    52.120
     3.600    53.494
     3.700    54.868
     3.800    56.242
     3.900    57.615
     4.000    58.989
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    15.250
     0.200    16.045
     0.300    17.282
     0.400    18.868
     0.500    20.712
     0.600    22.741
     0.700    24.899
     0.800    27.145
     0.900    29.451
     1.000    31.798
     1.100    34.173
     1.200    36.568
     1.300    38.977
     1.400    41.396
     1.500    43.823
     1.600    46.255
     1.700    48.692
     1.800    51.133
     1.900    53.576
     2.000    56.022
     2.100    58.469
     2.200    60.918
     2.300    63.369
     2.400    65.820
     2.500    68.272
     2.600    70.726
     2.700    73.179
     2.800    75.634
     2.900    78.089
     3.000    80.544
     3.100    82.999
     3.200    85.455
     3.300    87.911
     3.400    90.368
     3.500    92.825
     3.600    95.281
     3.700    97.738
     3.800   100.195
     3.900   102.652
     4.000   105.109
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.953    45.797     0.200
     7.555   111.297     0.200
    15.766   221.797     0.200
    20.128   275.695     0.200
     1.790    27.303     0.200
     2.711    41.003     0.200
     3.232    50.303     0.200
     3.101    47.303     0.200
     5.022    76.703     0.200
     5.728    90.303     0.200
     5.745    86.303     0.200
     7.417   109.303     0.200
     9.537   135.103     0.200
    14.231   203.303     0.200
    15.790   221.803     0.200
    19.838   275.303     0.200
    19.876   274.303     0.200
    20.225   274.803     0.200
     2.934    44.930     0.200
     7.657   112.930     0.200
     8.075   116.930     0.200
    16.265   225.930     0.200
    19.970   271.031     0.200
     2.887    43.678     0.200
     5.115    78.678     0.200
     5.768    84.678     0.200
     5.920    90.678     0.200
     7.639   113.678     0.200
     8.300   124.678     0.200
     8.617   124.678     0.200
     8.684   129.678     0.200
     9.089   132.377     0.200
    13.294   189.877     0.200
    15.576   214.678     0.200
    16.102   226.479     0.200
    18.889   259.877     0.200
    20.188   273.678     0.200
    20.216   277.178     0.200
    20.216   277.178     0.200
    20.252   277.678     0.200
    20.459   280.178     0.200
     7.753   115.072     0.200
     8.533   124.973     0.200
     5.115    78.084     0.200
     7.652   113.584     0.200
     8.560   123.684     0.200
     9.036   131.283     0.200
     9.323   139.783     0.200
    15.948   224.984     0.200
    18.867   260.885     0.200
    20.198   274.584     0.200
    20.265   280.684     0.200
    20.264   280.584     0.200
    20.301   281.184     0.200
    20.447   280.584     0.200
     2.897    42.535     0.200
     7.603   110.535     0.200
     8.430   118.535     0.200
     8.890   127.535     0.200
    15.880   222.035     0.200
    16.100   223.535     0.200
    18.896   259.135     0.200
     2.799    46.020     0.200
     6.026    95.020     0.200
     7.753   116.020     0.200
     8.715   127.419     0.200
     9.217   134.819     0.200
     2.879    45.457     0.200
     6.010    92.457     0.200
     7.721   114.457     0.200
     2.878    42.191     0.200
     5.990    89.191     0.200
     7.705   113.191     0.200
     2.897    45.805     0.200
     7.694   115.805     0.200
     2.862    43.051     0.200
     5.177    79.852     0.200
     5.865    87.051     0.200
     7.682   112.051     0.200
     8.311   123.152     0.200
    17.033   234.551     0.200
    20.119   279.652     0.200
    20.156   279.852     0.200
     2.828    46.053     0.200
     5.242    80.053     0.200
     5.945    89.053     0.200
     7.733   115.053     0.200
     1.080    14.545     0.200
     3.285    48.545     0.200
     5.117    75.045     0.200
     5.512    82.045     0.200
     5.828    90.045     0.200
     6.277    90.545     0.200
     7.455   108.545     0.200
    17.072   234.945     0.200
     1.883    31.008     0.200
     3.266    53.008     0.200
     5.115    79.508     0.200
     5.512    86.008     0.200
     7.450   114.008     0.200
     7.461   112.008     0.200
     7.986   120.008     0.200
     3.313    54.508     0.200
     5.069    79.109     0.200
     5.465    87.109     0.200
     7.412   111.609     0.200
     7.936   119.609     0.200
     2.375    41.932     0.200
     1.899    30.553     0.200
     2.400    40.553     0.200
     3.225    50.553     0.200
     3.281    51.553     0.200
     5.107    78.553     0.200
     5.504    89.053     0.200
     6.258    95.553     0.200
     7.439   111.553     0.200
     7.451   110.553     0.200
     7.973   119.553     0.200
     9.315   139.553     0.200
    15.152   215.553     0.200
    15.779   223.553     0.200
    19.683   279.354     0.200
     1.830    27.789     0.200
     3.282    53.789     0.200
     7.362   109.789     0.200
    20.978   283.789     0.200
     1.772    28.078     0.200
     5.432    86.078     0.200
     7.420   111.078     0.200
     2.073    32.613     0.200
     3.025    48.613     0.200
     3.704    58.613     0.200
     4.698    71.613     0.200
     5.054    79.613     0.200
     8.058   120.613     0.200
     1.738    29.594     0.200
     2.251    37.094     0.200
     3.067    48.594     0.200
     5.220    79.594     0.200
     6.257    93.594     0.200
     8.130   123.594     0.200
     9.217   136.094     0.200
    10.648   150.594     0.200
    17.159   239.195     0.200
    19.670   274.594     0.200
    19.670   275.395     0.200
    19.707   274.594     0.200
    19.707   275.395     0.200
     2.796    40.160     0.200
     3.317    48.160     0.200
     4.156    60.160     0.200
     4.568    67.160     0.200
     5.044    74.660     0.200
     7.169   103.160     0.200
     7.176   104.160     0.200
     8.639   123.660     0.200
     8.889   128.160     0.200
    10.556   148.160     0.200
    19.057   258.961     0.200
    20.751   282.061     0.200
     1.375    25.156     0.200
     1.916    30.656     0.200
     2.082    35.656     0.200
     2.451    39.156     0.200
     2.468    40.156     0.200
     2.604    43.656     0.200
     3.013    49.555     0.200
     3.099    51.156     0.200
     3.264    54.656     0.200
     3.286    51.656     0.200
     3.312    53.656     0.200
     4.230    69.656     0.200
     5.110    81.656     0.200
     5.126    79.656     0.200
     7.449   111.656     0.200
     1.868    30.855     0.200
     2.376    40.855     0.200
     2.395    39.855     0.200
     2.480    40.355     0.200
     2.591    43.855     0.200
     2.999    48.855     0.200
     3.064    51.355     0.200
     3.271    53.855     0.200
     7.462   112.855     0.200
     1.685    28.746     0.200
     2.064    34.746     0.200
     2.167    34.746     0.200
     2.765    45.746     0.200
     2.736    45.146     0.200
     2.959    47.246     0.200
     1.360    26.433     0.200
     1.839    31.232     0.200
     1.868    32.832     0.200
     2.479    41.832     0.200
     3.455    57.232     0.200
     3.979    60.732     0.200
     8.117   121.232     0.200
     1.363    22.436     0.200
     1.592    27.436     0.200
     1.870    30.135     0.200
     2.260    35.936     0.200
     2.639    42.936     0.200
     2.638    43.436     0.200
     2.814    46.035     0.200
     2.760    45.035     0.200
     3.022    49.436     0.200
     3.915    58.736     0.200
     5.309    83.035     0.200
     1.345    22.035     0.200
     1.893    29.738     0.200
     2.211    35.137     0.200
     2.628    41.738     0.200
     2.689    43.637     0.200
     2.788    44.238     0.200
     2.815    44.938     0.200
     3.074    49.637     0.200
     3.693    60.137     0.200
     3.934    57.836     0.200
     4.695    72.836     0.200
     1.594    27.625     0.200
     1.879    30.023     0.200
     2.277    35.625     0.200
     2.657    42.625     0.200
     2.622    43.227     0.200
     2.834    45.023     0.200
     2.838    43.227     0.200
     2.741    45.625     0.200
     1.668    26.754     0.200
     2.020    33.492     0.200
     2.225    35.766     0.200
     2.309    36.223     0.200
     2.787    44.805     0.200
     3.189    50.344     0.200
     1.211    22.645     0.200
     1.715    28.355     0.200
     1.953    33.125     0.200
     0.864    14.965     0.200
     0.866    14.615     0.200
     1.264    19.686     0.200
     1.557    24.805     0.200
     1.855    30.436     0.200
     2.227    34.984     0.200
     2.333    34.805     0.200
     2.565    40.715     0.200
     2.621    43.035     0.200
     2.870    45.314     0.200
     2.949    44.795     0.200
     1.282    19.875     0.200
     1.402    21.977     0.200
     1.323    23.547     0.200
     1.833    29.004     0.200
     1.876    30.887     0.200
     2.198    35.414     0.200
     2.383    36.914     0.200
     2.663    41.914     0.200
     2.545    41.547     0.200
     2.629    41.766     0.200
     2.866    46.066     0.200
     2.687    42.457     0.200
     2.915    45.746     0.200
     2.927    45.617     0.200
     3.605    55.125     0.200
     3.739    56.844     0.200
     3.744    58.125     0.200
     4.348    66.266     0.200
     4.528    68.164     0.200
     4.892    73.215     0.200
     5.224    79.707     0.200
     5.342    78.977     0.200
     5.584    83.957     0.200
     5.803    87.727     0.200
     5.871    86.824     0.200
     7.567   111.094     0.200
    15.332   212.164     0.200
     1.454    24.623     0.200
     1.825    30.793     0.200
     2.211    36.814     0.200
     2.207    36.814     0.200
     2.367    40.064     0.200
     2.608    41.994     0.200
     2.770    44.264     0.200
     2.797    45.264     0.200
     3.344    54.395     0.200
    14.938   211.904     0.200
     1.681    28.945     0.200
     1.891    32.391     0.200
     1.985    34.141     0.200
     2.078    35.797     0.200
     2.114    35.477     0.200
     2.233    37.445     0.200
     2.368    39.984     0.200
     2.569    41.594     0.200
     2.777    45.500     0.200
     2.941    48.336     0.200
     3.050    49.789     0.200
     3.064    48.930     0.200
     3.571    55.609     0.200
     3.744    59.453     0.200
     4.238    65.484     0.200
     4.666    71.117     0.200
     5.227    81.727     0.200
     6.247    95.250     0.200
     8.667   127.695     0.200
    16.380   227.898     0.200
    16.380   228.758     0.200
     1.722    28.531     0.200
     2.253    37.180     0.200
     2.383    40.070     0.200
     2.489    41.062     0.200
     2.683    44.438     0.200
     2.829    45.312     0.200
     3.118    50.219     0.200
     3.086    49.320     0.200
     3.389    53.312     0.200
     3.715    58.602     0.200
     4.048    62.969     0.200
     4.508    69.812     0.200
     5.127    78.258     0.200
     5.649    85.281     0.200
     5.639    85.750     0.200
     5.917    91.391     0.200
     7.458   112.531     0.200
     1.262    21.624     0.200
     1.406    22.604     0.200
     1.554    26.314     0.200
     1.859    31.685     0.200
     2.007    33.435     0.200
     2.331    36.314     0.200
     2.228    36.185     0.200
     2.405    38.135     0.200
     2.567    41.324     0.200
     2.673    42.515     0.200
     2.625    42.734     0.200
     2.696    43.265     0.200
     2.866    44.994     0.200
     2.787    45.814     0.200
     2.965    47.034     0.200
     2.951    46.055     0.200
     3.279    51.004     0.200
     3.626    56.254     0.200
     4.920    74.145     0.200
     5.240    80.354     0.200
     6.671   101.404     0.200
     1.275    20.305     0.200
     1.390    21.895     0.200
     1.335    23.025     0.200
     1.516    26.275     0.200
     1.888    31.225     0.200
     1.997    32.475     0.200
     2.201    35.395     0.200
     2.373    37.145     0.200
     2.652    42.115     0.200
     2.551    40.795     0.200
     2.640    43.145     0.200
     2.698    43.326     0.200
     2.855    45.045     0.200
     2.929    46.426     0.200
     3.281    50.555     0.200
     3.612    56.135     0.200
     3.741    57.545     0.200
     3.755    58.336     0.200
     4.354    66.564     0.200
     4.536    71.736     0.200
     4.895    73.545     0.200
     5.233    79.516     0.200
     5.344    79.135     0.200
     5.592    86.338     0.200
     5.810    88.156     0.200
     6.666   101.775     0.200
     9.202   133.375     0.200
     1.508    25.410     0.200
     1.508    25.281     0.200
     1.940    32.441     0.200
     1.906    31.930     0.200
     1.906    32.922     0.200
     2.001    32.980     0.200
     2.247    37.262     0.200
     2.502    40.762     0.200
     2.541    40.539     0.200
     2.760    46.590     0.200
     2.886    47.500     0.200
     2.859    46.211     0.200
     3.343    52.578     0.200
     3.404    53.020     0.200
     3.404    53.129     0.200
     3.459    53.500     0.200
     3.470    55.270     0.200
     3.470    55.039     0.200
     3.912    60.629     0.200
     3.912    60.520     0.200
     4.154    64.828     0.200
     4.154    64.488     0.200
     4.577    70.219     0.200
     4.620    70.039     0.200
     4.620    69.930     0.200
     4.999    75.250     0.200
     4.999    75.090     0.200
     5.643    86.719     0.200
     5.643    86.512     0.200
     6.436    95.281     0.200
     6.436    95.051     0.200
     6.586   102.910     0.200
     6.586    99.969     0.200
     7.618   116.520     0.200
     7.618   115.820     0.200
     7.909   118.641     0.200
     8.662   132.430     0.200
     8.744   127.102     0.200
     1.511    26.488     0.200
     1.701    27.148     0.200
     2.233    36.238     0.200
     2.283    36.090     0.200
     2.402    39.250     0.200
     2.487    40.438     0.200
     2.688    44.527     0.200
     2.809    45.070     0.200
     3.387    52.109     0.200
     3.947    60.961     0.200
     4.045    62.168     0.200
     4.513    67.898     0.200
     5.128    77.898     0.200
     1.751    30.008     0.200
     4.029    61.859     0.200
     4.029    60.328     0.200
     4.024    62.898     0.200
    14.825   211.391     0.200
    15.624   221.500     0.200
     1.444    25.430     0.200
     1.862    28.699     0.200
     2.227    36.379     0.200
     2.570    42.070     0.200
     3.387    54.559     0.200
     3.545    57.277     0.200
     3.593    55.887     0.200
     3.982    61.848     0.200
     4.396    67.738     0.200
     5.034    76.168     0.200
     5.581    83.570     0.200
     7.304   108.777     0.200
     8.367   126.988     0.200
     1.493    25.637     0.200
     1.479    27.076     0.200
     1.707    29.857     0.200
     1.894    32.367     0.200
     1.925    32.416     0.200
     1.946    32.938     0.200
     2.301    39.496     0.200
     2.369    39.477     0.200
     2.442    39.996     0.200
     2.453    40.797     0.200
     2.519    40.127     0.200
     2.788    45.188     0.200
     2.842    47.723     0.200
     2.915    48.236     0.200
     3.414    54.326     0.200
     3.506    55.486     0.200
     3.967    63.057     0.200
     4.639    70.857     0.200
     5.006    76.037     0.200
    19.690   270.688     0.200
     1.334    20.334     0.200
     1.358    21.384     0.200
     1.339    22.664     0.200
     1.970    31.754     0.200
     2.017    34.084     0.200
     2.075    33.434     0.200
     2.230    35.484     0.200
     2.418    36.234     0.200
     2.479    39.434     0.200
     2.711    42.914     0.200
     2.817    43.324     0.200
     2.896    46.187     0.200
     2.896    45.823     0.200
     2.896    45.694     0.200
     3.305    52.094     0.200
     3.544    53.645     0.200
     3.700    62.334     0.200
     3.603    54.784     0.200
     3.803    57.874     0.200
     4.265    65.374     0.200
     4.780    71.274     0.200
     5.204    76.614     0.200
     5.735    85.764     0.200
     6.577    99.304     0.200
     6.703    98.284     0.200
     7.582   111.834     0.200
     7.594   110.734     0.200
    15.451   217.804     0.200
    16.094   224.764     0.200
    16.913   236.264     0.200
    19.754   270.364     0.200
    19.879   270.189     0.200
    19.879   270.364     0.200
    20.916   282.264     0.200
     1.258    21.047     0.200
     1.364    21.007     0.200
     1.443    24.316     0.200
     1.657    26.366     0.200
     1.973    32.196     0.200
     2.068    32.767     0.200
     2.228    35.807     0.200
     2.473    39.526     0.200
     2.709    43.387     0.200
     2.762    43.667     0.200
     4.259    65.087     0.200
     5.197    76.727     0.200
     1.129    17.507     0.200
     1.471    24.957     0.200
     1.542    25.037     0.200
     1.785    28.497     0.200
     2.203    33.617     0.200
     2.296    36.117     0.200
     2.663    41.757     0.200
     2.697    43.227     0.200
     2.707    42.637     0.200
     2.792    42.827     0.200
     3.089    47.566     0.200
     3.772    57.896     0.200
     3.816    57.367     0.200
     5.415    79.337     0.200
    15.367   214.972     0.200
     1.230    21.453     0.200
     1.500    23.797     0.200
     2.036    32.645     0.200
     2.496    40.324     0.200
     2.591    42.156     0.200
     2.628    41.535     0.200
     2.766    44.215     0.200
     3.813    59.285     0.200
     2.237    36.172     0.200
     2.435    38.852     0.200
     2.637    43.289     0.200
     3.245    50.109     0.200
     3.404    53.801     0.200
     3.656    57.180     0.200
     4.462    69.301     0.200
    20.425   278.801     0.200
     1.323    21.664     0.200
     1.354    22.797     0.200
     1.456    24.965     0.200
     1.959    32.547     0.200
     2.075    34.594     0.200
     2.216    36.305     0.200
     2.550    41.016     0.200
     2.484    40.484     0.200
     2.753    44.297     0.200
     2.886    44.586     0.200
    19.402   266.746     0.200
     1.196    20.598     0.200
     1.554    26.406     0.200
     1.655    27.668     0.200
     1.712    27.676     0.200
     1.881    30.715     0.200
     1.802    30.105     0.200
     2.286    36.395     0.200
     2.692    42.418     0.200
     2.754    44.668     0.200
     2.950    46.285     0.200
     1.654    28.082     0.200
     1.804    30.422     0.200
     1.754    29.262     0.200
     1.888    31.090     0.200
     2.002    32.941     0.200
     2.145    35.582     0.200
     2.155    35.320     0.200
     2.465    40.910     0.200
     2.511    40.469     0.200
     2.577    41.859     0.200
     2.603    41.352     0.200
     3.311    51.109     0.200
     3.563    54.902     0.200
     4.192    63.602     0.200
     4.192    62.832     0.200
     4.584    68.641     0.200
     1.064    18.051     0.200
     1.220    20.559     0.200
     1.621    25.281     0.200
     1.520    24.602     0.200
     1.889    30.109     0.200
     2.134    33.309     0.200
     2.666    42.570     0.200
     2.611    40.961     0.200
     2.732    41.648     0.200
     2.762    43.102     0.200
     3.658    55.898     0.200
     4.325    63.969     0.200
     8.350   121.461     0.200
    18.025   249.770     0.200
    19.328   264.371     0.200
     1.058    20.000     0.200
     1.378    22.938     0.200
     1.639    27.906     0.200
     1.713    28.469     0.200
     1.848    30.844     0.200
     1.817    29.734     0.200
     2.066    34.258     0.200
     2.428    37.648     0.200
     2.366    38.797     0.200
     2.901    44.555     0.200
     3.082    48.727     0.200
     3.135    48.773     0.200
     3.586    54.336     0.200
     4.777    72.297     0.200
     1.720    27.707     0.200
     2.259    36.256     0.200
     2.456    39.047     0.200
     1.355    22.922     0.200
     1.362    23.148     0.200
     1.381    23.633     0.200
     1.482    23.383     0.200
     1.974    30.062     0.200
     2.255    36.727     0.200
     2.718    41.500     0.200
     2.785    42.852     0.200
     2.816    43.648     0.200
     3.002    47.562     0.200
     3.040    47.766     0.200
     3.737    58.602     0.200
     3.887    58.781     0.200
     4.045    62.289     0.200
     1.597    27.155     0.200
     1.817    29.805     0.200
     2.148    33.955     0.200
     2.171    36.405     0.200
     2.077    35.145     0.200
     2.559    41.195     0.200
     2.657    42.185     0.200
     2.862    44.585     0.200
     3.062    47.235     0.200
     3.204    50.355     0.200
     3.204    50.530     0.200
     3.117    48.815     0.200
     3.142    49.725     0.200
     3.404    51.565     0.200
     3.670    56.035     0.200
     3.667    56.605     0.200
     3.828    60.445     0.200
     4.126    62.455     0.200
     4.133    65.515     0.200
     4.268    65.435     0.200
     4.308    65.055     0.200
     4.718    71.145     0.200
     4.842    74.795     0.200
     5.157    80.085     0.200
     5.157    82.855     0.200
     5.212    82.685     0.200
     5.235    77.255     0.200
     5.315    81.345     0.200
     6.356    94.085     0.200
     6.256    94.595     0.200
     6.275    95.415     0.200
     7.318   112.065     0.200
     8.345   124.835     0.200
     8.359   127.495     0.200
     8.648   125.125     0.200
     9.273   138.285     0.200
     9.599   139.485     0.200
     9.661   139.085     0.200
     9.661   136.665     0.200
    10.951   157.635     0.200
    11.028   156.785     0.200
    11.008   161.085     0.200
    12.036   167.185     0.200
    12.189   170.685     0.200
    12.330   178.285     0.200
    12.898   182.360     0.200
    13.179   186.655     0.200
    13.151   185.675     0.200
    13.411   186.685     0.200
    13.537   194.485     0.200
    13.711   195.775     0.200
    13.886   197.395     0.200
    14.038   199.785     0.200
    14.125   197.585     0.200
    14.113   201.915     0.200
    14.377   202.625     0.200
    14.506   206.285     0.200
    14.745   210.285     0.200
    14.898   212.785     0.200
    15.140   213.585     0.200
    15.140   210.475     0.200
    15.180   213.425     0.200
    15.364   217.085     0.200
    15.427   216.629     0.200
    15.427   217.915     0.200
    15.480   219.085     0.200
    15.406   215.735     0.200
    15.444   217.985     0.200
    15.625   220.885     0.200
    15.536   218.615     0.200
    15.825   224.185     0.200
    16.019   224.245     0.200
    17.303   241.195     0.200
    18.509   257.085     0.200
    18.509   256.095     0.200
    18.682   258.885     0.200
    18.791   259.185     0.200
    18.888   261.885     0.200
    18.888   262.045     0.200
    19.187   265.885     0.200
    19.535   269.785     0.200
    19.629   270.185     0.200
    19.802   272.785     0.200
    19.847   271.285     0.200
    19.919   273.185     0.200
    19.986   273.685     0.200
    20.303   277.285     0.200
    20.295   277.685     0.200
    20.449   281.085     0.200
    20.603   281.985     0.200
    20.682   280.885     0.200
    20.743   283.285     0.200
    20.743   280.625     0.200
    20.918   286.385     0.200
     1.639    27.287     0.200
     3.171    48.817     0.200
     8.677   127.177     0.200
    13.187   183.377     0.200
    13.911   195.557     0.200
    15.422   216.527     0.200
    15.573   218.377     0.200
    14.782   207.048     0.200
    15.561   218.858     0.200
    18.895   261.648     0.200
    20.112   273.363     0.200
     3.247    51.206     0.200
    14.465   205.036     0.200
    15.462   220.296     0.200
    18.862   262.456     0.200
     3.269    51.652     0.200
    15.065   211.242     0.200
    19.826   272.352     0.200
     3.249    49.500     0.200
    20.098   274.795     0.200
     1.965    32.540     0.200
     2.782    44.760     0.200
     3.247    49.865     0.200
     3.247    48.290     0.200
     8.430   123.020     0.200
     9.666   138.470     0.200
    20.580   280.380     0.200
     1.634    28.227     0.200
     1.793    29.817     0.200
     2.066    35.427     0.200
     2.290    36.947     0.200
     2.568    40.536     0.200
     2.663    42.697     0.200
     3.108    49.347     0.200
     3.235    50.906     0.200
     3.235    51.477     0.200
     3.134    50.687     0.200
     3.836    61.227     0.200
     4.110    64.126     0.200
     4.339    65.906     0.200
     4.816    74.817     0.200
     5.142    80.687     0.200
     6.411    97.036     0.200
     8.749   127.506     0.200
     9.705   139.036     0.200
    11.034   162.136     0.200
    11.075   159.337     0.200
    11.098   162.636     0.200
    12.098   168.437     0.200
    12.435   182.237     0.200
    12.917   184.011     0.200
    13.467   188.136     0.200
    13.632   196.737     0.200
    13.656   192.207     0.200
    13.990   198.857     0.200
    14.082   201.636     0.200
    14.056   198.447     0.200
    14.316   201.286     0.200
    14.837   207.776     0.200
    15.162   212.786     0.200
    15.520   219.181     0.200
    15.520   218.136     0.200
    16.122   224.337     0.200
    18.591   258.136     0.200
    18.778   258.937     0.200
    18.766   259.937     0.200
    19.609   271.437     0.200
    19.724   273.237     0.200
    19.944   272.237     0.200
    20.020   275.337     0.200
    20.288   277.136     0.200
    20.243   278.536     0.200
    20.400   281.036     0.200
    20.845   284.536     0.200
     3.105    49.244     0.200
     3.169    50.604     0.200
     3.168    52.819     0.200
     8.592   126.854     0.200
    13.826   196.594     0.200
    18.446   255.394     0.200
    13.812   194.331     0.200
    14.213   201.681     0.200
    15.347   214.071     0.200
    17.387   239.041     0.200
    19.892   272.691     0.200
    20.597   279.166     0.200
     1.572    27.126     0.200
     1.841    30.786     0.200
     2.531    41.236     0.200
     3.089    48.336     0.200
     3.211    51.447     0.200
     3.211    48.947     0.200
     3.211    47.386     0.200
     3.130    49.846     0.200
     4.284    64.766     0.200
     8.613   125.486     0.200
     9.662   137.677     0.200
     9.662   136.836     0.200
    10.936   159.956     0.200
    10.990   161.876     0.200
    11.029   161.276     0.200
    12.031   168.076     0.200
    12.303   179.177     0.200
    12.908   184.226     0.200
    13.152   187.667     0.200
    13.408   186.376     0.200
    13.516   194.476     0.200
    13.852   198.076     0.200
    13.852   194.106     0.200
    14.040   199.776     0.200
    14.125   198.776     0.200
    14.403   205.177     0.200
    14.903   210.187     0.200
    15.149   214.937     0.200
    15.407   218.220     0.200
    15.407   216.976     0.200
    16.324   229.177     0.200
    18.495   256.976     0.200
    18.495   256.536     0.200
    18.811   259.976     0.200
    18.860   262.976     0.200
    18.860   260.376     0.200
    19.608   269.177     0.200
    19.894   271.177     0.200
    19.974   271.927     0.200
    19.974   272.376     0.200
    20.175   279.976     0.200
    20.717   281.776     0.200
    20.717   281.286     0.200
    20.891   283.076     0.200
     2.258    38.045     0.200
     3.248    53.955     0.200
     3.248    50.635     0.200
     8.758   127.665     0.200
    11.049   160.005     0.200
    12.928   185.060     0.200
    14.000   198.575     0.200
    15.173   214.405     0.200
    15.535   219.304     0.200
    15.535   218.015     0.200
    15.511   216.905     0.200
    17.198   240.505     0.200
    20.077   274.585     0.200
    20.671   281.935     0.200
     3.281    51.728     0.200
     8.842   128.348     0.200
    13.386   187.558     0.200
    20.145   276.323     0.200
     1.804    30.545     0.200
     2.048    35.125     0.200
     2.283    37.565     0.200
     2.319    37.746     0.200
     2.528    42.456     0.200
     2.702    44.396     0.200
     3.114    49.775     0.200
     3.263    49.605     0.200
     8.778   125.785     0.200
     9.736   138.746     0.200
    11.073   161.135     0.200
    11.073   157.795     0.200
    11.137   162.936     0.200
    12.133   169.936     0.200
    12.941   184.686     0.200
    13.672   195.635     0.200
    14.021   197.186     0.200
    15.560   218.845     0.200
    18.805   261.236     0.200
    18.938   264.635     0.200
    18.938   261.406     0.200
    19.647   270.736     0.200
    20.100   274.510     0.200
    20.100   274.635     0.200
    20.747   281.736     0.200
     1.646    29.593     0.200
     2.312    38.883     0.200
     3.125    50.963     0.200
    14.285   200.333     0.200
    20.099   275.377     0.200
     1.062    21.001     0.200
     1.659    30.161     0.200
     1.763    28.941     0.200
     1.763    30.401     0.200
     2.091    35.211     0.200
     2.104    35.581     0.200
     2.249    37.781     0.200
     2.605    41.721     0.200
     2.605    41.851     0.200
     2.636    44.331     0.200
     2.815    46.291     0.200
     3.170    51.281     0.200
     3.170    51.471     0.200
     3.195    53.371     0.200
     3.195    50.571     0.200
     3.189    51.210     0.200
     3.189    51.391     0.200
     3.648    59.241     0.200
     4.149    64.451     0.200
     4.268    66.341     0.200
     4.367    67.391     0.200
     4.367    68.641     0.200
     4.856    76.121     0.200
     5.179    82.875     0.200
     6.370    94.401     0.200
     8.473   126.601     0.200
     8.740   128.431     0.200
     8.740   129.351     0.200
     9.207   139.201     0.200
     9.308   140.701     0.200
     9.664   140.701     0.200
     9.664   138.921     0.200
     9.652   141.801     0.200
    10.995   157.701     0.200
    10.995   158.051     0.200
    11.034   158.801     0.200
    11.061   164.601     0.200
    12.056   169.000     0.200
    12.407   182.000     0.200
    12.879   185.101     0.200
    13.597   197.801     0.200
    13.645   193.801     0.200
    13.977   202.201     0.200
    13.977   198.031     0.200
    14.097   198.891     0.200
    14.133   199.901     0.200
    14.133   202.901     0.200
    14.481   208.301     0.200
    14.878   211.671     0.200
    15.123   216.210     0.200
    15.441   217.421     0.200
    15.479   221.101     0.200
    15.484   221.295     0.200
    15.484   216.301     0.200
    15.485   219.091     0.200
    16.110   227.341     0.200
    18.551   260.101     0.200
    18.727   261.901     0.200
    18.959   265.201     0.200
    19.569   270.901     0.200
    19.689   272.701     0.200
    19.910   274.301     0.200
    19.988   275.301     0.200
    20.022   275.500     0.200
    20.256   277.901     0.200
    20.267   281.500     0.200
    20.633   282.151     0.200
    20.697   282.701     0.200
    20.814   286.101     0.200
     2.344    38.352     0.200
     2.450    41.481     0.200
     3.129    50.302     0.200
     3.297    52.532     0.200
     8.473   123.481     0.200
     2.000    34.404     0.200
     2.315    37.304     0.200
     3.268    50.504     0.200
     8.513   123.694     0.200
    10.925   159.594     0.200
    10.925   155.844     0.200
    12.051   169.395     0.200
    13.483   194.694     0.200
    13.757   195.814     0.200
    15.377   216.524     0.200
    17.345   241.165     0.200
    18.485   256.274     0.200
    18.654   259.594     0.200
    18.900   261.994     0.200
    19.528   270.294     0.200
    19.528   267.665     0.200
    19.573   271.694     0.200
    19.785   271.794     0.200
    19.974   273.044     0.200
    19.974   273.194     0.200
    20.485   279.494     0.200
    20.664   282.494     0.200
     2.023    34.615     0.200
     2.314    37.545     0.200
    20.048   274.330     0.200
     1.590    26.615     0.200
     2.090    35.325     0.200
     2.107    33.755     0.200
     2.236    36.095     0.200
     2.515    41.435     0.200
     3.141    49.685     0.200
     3.104    49.685     0.200
     3.186    49.440     0.200
     3.186    47.605     0.200
     3.153    52.475     0.200
     3.832    60.155     0.200
     4.859    73.775     0.200
     8.610   125.335     0.200
     9.559   138.095     0.200
    10.913   156.395     0.200
    10.913   156.025     0.200
    12.006   169.295     0.200
    12.884   182.470     0.200
    13.383   187.195     0.200
    13.496   192.795     0.200
    13.846   197.315     0.200
    14.015   197.795     0.200
    14.382   204.595     0.200
    14.928   209.615     0.200
    18.471   255.765     0.200
    18.644   258.595     0.200
    18.875   264.595     0.200
    19.950   273.145     0.200
    19.950   272.695     0.200
    20.566   280.395     0.200
    20.700   280.995     0.200
     3.278    48.622     0.200
     8.250   117.151     0.200
     1.593    26.682     0.200
     1.818    30.892     0.200
     2.083    36.322     0.200
     2.219    36.482     0.200
     2.492    41.532     0.200
     2.855    47.172     0.200
     4.875    76.562     0.200
    14.163   202.622     0.200
     1.380    23.500     0.200
     1.380    23.931     0.200
     1.927    32.391     0.200
     2.065    34.701     0.200
     2.252    37.281     0.200
     2.840    44.931     0.200
     3.057    49.701     0.200
     3.234    50.271     0.200
     3.265    47.951     0.200
     3.332    52.331     0.200
     3.680    57.411     0.200
     3.781    57.851     0.200
     4.086    62.241     0.200
     8.272   118.641     0.200
     8.749   130.491     0.200
     9.133   132.891     0.200
     9.387   136.391     0.200
     9.653   139.091     0.200
     9.653   135.921     0.200
    10.796   156.491     0.200
    10.935   152.352     0.200
    11.956   169.391     0.200
    12.980   185.816     0.200
    13.295   190.891     0.200
    13.356   186.291     0.200
    13.514   193.491     0.200
    13.514   190.671     0.200
    13.775   194.691     0.200
    14.096   198.091     0.200
    15.195   211.391     0.200
    15.214   214.591     0.200
    15.214   211.371     0.200
    15.484   218.091     0.200
    15.647   219.341     0.200
    18.498   258.991     0.200
    18.605   261.691     0.200
    18.978   261.991     0.200
    19.190   264.691     0.200
    19.383   267.491     0.200
    19.399   267.991     0.200
    19.838   270.866     0.200
    19.838   271.691     0.200
    20.324   279.391     0.200
    20.451   279.291     0.200
    20.618   282.791     0.200
    20.883   282.416     0.200
    20.883   282.791     0.200
    20.927   284.291     0.200
     1.861    31.342     0.200
     2.236    36.612     0.200
     2.081    34.902     0.200
     2.894    46.442     0.200
     3.188    52.242     0.200
     3.188    52.375     0.200
     3.188    48.742     0.200
     3.432    53.872     0.200
     4.148    65.052     0.200
     4.653    69.442     0.200
     4.858    76.652     0.200
     8.538   123.462     0.200
     9.512   142.272     0.200
     9.627   138.572     0.200
     9.627   137.282     0.200
    10.872   155.482     0.200
    10.921   162.072     0.200
    10.991   160.072     0.200
    11.983   168.972     0.200
    12.891   185.872     0.200
    13.072   184.172     0.200
    13.364   187.972     0.200
    13.444   195.172     0.200
    13.774   197.872     0.200
    13.774   194.742     0.200
    14.164   200.052     0.200
    14.330   205.572     0.200
    14.952   212.392     0.200
    15.131   211.882     0.200
    15.336   214.072     0.200
    15.907   222.892     0.200
    16.424   228.372     0.200
    18.431   257.572     0.200
    18.602   259.172     0.200
    18.826   263.572     0.200
    19.467   270.872     0.200
    19.535   269.472     0.200
    19.750   270.872     0.200
    19.817   274.872     0.200
    19.915   272.372     0.200
    19.915   272.572     0.200
    20.147   280.572     0.200
    20.333   278.472     0.200
    20.639   283.872     0.200
    20.812   285.272     0.200
     2.076    35.097     0.200
     3.231    48.396     0.200
    15.402   217.487     0.200
     1.593    26.600     0.200
     1.821    30.899     0.200
     2.075    34.699     0.200
     2.147    35.789     0.200
     2.257    37.350     0.200
     2.556    42.270     0.200
     2.658    42.699     0.200
     3.162    51.199     0.200
     3.206    48.079     0.200
     3.140    51.369     0.200
     4.840    76.779     0.200
     8.645   127.339     0.200
    10.950   157.869     0.200
    10.950   156.819     0.200
    12.037   170.770     0.200
    13.150   184.319     0.200
    13.412   190.869     0.200
    13.536   194.169     0.200
    13.883   198.079     0.200
    16.016   226.359     0.200
    18.681   258.069     0.200
    18.885   265.369     0.200
    18.885   261.399     0.200
    19.986   273.619     0.200
    20.741   281.800     0.200
     1.584    27.308     0.200
     1.829    30.298     0.200
     2.129    34.338     0.200
     2.075    34.918     0.200
     2.196    36.738     0.200
     2.252    36.278     0.200
     2.535    41.518     0.200
     2.675    42.418     0.200
     3.057    48.147     0.200
     3.101    48.328     0.200
     3.203    51.633     0.200
     3.203    51.883     0.200
     3.203    49.048     0.200
     3.139    50.698     0.200
     3.393    53.107     0.200
     4.122    62.458     0.200
     4.296    65.228     0.200
     5.155    82.088     0.200
     6.348    91.488     0.200
     8.623   122.308     0.200
     9.581   137.588     0.200
     9.655   137.388     0.200
     9.655   138.018     0.200
    10.935   158.388     0.200
    10.935   154.578     0.200
    10.990   158.888     0.200
    11.022   155.988     0.200
    12.026   168.688     0.200
    12.899   184.562     0.200
    13.403   186.988     0.200
    13.518   194.088     0.200
    13.719   191.098     0.200
    13.861   193.938     0.200
    14.033   198.088     0.200
    14.118   197.288     0.200
    14.122   199.068     0.200
    14.404   205.388     0.200
    14.726   209.988     0.200
    14.908   208.058     0.200
    15.140   212.788     0.200
    15.140   211.678     0.200
    15.408   216.988     0.200
    15.994   222.688     0.200
    17.321   239.348     0.200
    18.493   255.488     0.200
    18.493   254.928     0.200
    18.666   257.388     0.200
    18.872   262.688     0.200
    19.522   267.688     0.200
    19.609   268.688     0.200
    19.972   272.913     0.200
    19.972   272.488     0.200
    20.187   278.288     0.200
    20.692   279.938     0.200
    20.692   281.888     0.200
    20.720   281.688     0.200
     1.564    26.270     0.200
     1.564    27.430     0.200
     1.852    32.090     0.200
     2.038    34.819     0.200
     2.176    35.520     0.200
     2.176    36.960     0.200
     2.577    42.600     0.200
     3.089    48.800     0.200
     3.103    49.760     0.200
     3.790    60.630     0.200
     4.690    70.109     0.200
    20.021   275.574     0.200
     1.656    26.574     0.200
     2.337    36.034     0.200
     2.342    37.294     0.200
     2.761    43.254     0.200
     3.110    50.555     0.200
     3.200    48.954     0.200
     4.804    70.714     0.200
     8.834   128.975     0.200
    18.965   261.464     0.200
    20.144   275.329     0.200
     2.118    34.039     0.200
     2.723    42.869     0.200
     3.182    49.909     0.200
    18.893   260.648     0.200
    19.922   271.224     0.200
     3.204    46.591     0.200
     8.245   118.041     0.200
    19.766   271.541     0.200
     1.603    27.178     0.200
     1.809    29.838     0.200
     2.125    35.088     0.200
     2.093    34.617     0.200
     2.537    41.178     0.200
     2.681    40.947     0.200
     2.851    45.117     0.200
     3.042    47.357     0.200
     3.042    47.768     0.200
     3.186    51.798     0.200
     3.186    51.372     0.200
     3.186    47.857     0.200
     3.120    48.808     0.200
     3.158    50.228     0.200
     3.381    52.838     0.200
     3.517    54.037     0.200
     3.690    56.718     0.200
     3.840    59.947     0.200
     4.106    62.487     0.200
     4.316    65.338     0.200
     4.720    70.058     0.200
     4.860    74.298     0.200
     5.173    83.077     0.200
     5.329    81.997     0.200
     6.334    93.327     0.200
     8.634   124.157     0.200
     9.249   134.128     0.200
     9.576   137.728     0.200
     9.640   136.428     0.200
     9.640   136.027     0.200
    10.927   158.228     0.200
    10.927   154.268     0.200
    11.008   156.327     0.200
    10.985   158.327     0.200
    12.014   167.628     0.200
    12.881   185.027     0.200
    13.390   187.527     0.200
    13.514   193.027     0.200
    13.823   196.827     0.200
    13.870   200.728     0.200
    13.870   194.218     0.200
    14.135   200.008     0.200
    14.721   209.827     0.200
    14.920   211.197     0.200
    15.123   211.827     0.200
    15.123   211.997     0.200
    15.340   216.827     0.200
    15.404   214.527     0.200
    15.460   215.327     0.200
    15.406   214.168     0.200
    15.465   215.598     0.200
    16.003   223.287     0.200
    16.467   231.628     0.200
    17.326   240.407     0.200
    18.485   255.827     0.200
    18.780   258.928     0.200
    18.892   262.527     0.200
    19.167   262.628     0.200
    19.606   268.928     0.200
    19.824   271.527     0.200
    19.896   272.827     0.200
    19.963   272.678     0.200
    20.207   278.027     0.200
    20.274   277.228     0.200
    20.672   279.827     0.200
    20.720   282.327     0.200
    20.895   285.327     0.200
     0.842    17.111     0.200
     1.526    26.061     0.200
     2.061    35.221     0.200
     2.254    36.951     0.200
     2.442    40.551     0.200
     3.045    50.400     0.200
     4.626    68.922     0.200
    14.562   203.932     0.200
    15.302   211.730     0.200
    19.921   272.887     0.200
     1.519    25.922     0.200
     1.904    30.701     0.200
     1.972    32.771     0.200
     2.092    34.102     0.200
     2.352    39.451     0.200
     2.830    44.570     0.200
     3.174    51.391     0.200
     3.174    50.381     0.200
     3.148    50.381     0.200
     3.300    52.502     0.200
     3.798    61.131     0.200
     4.075    61.801     0.200
     4.878    73.150     0.200
     6.267    94.121     0.200
     8.437   122.141     0.200
     9.138   134.320     0.200
     9.431   138.621     0.200
     9.595   138.121     0.200
    10.798   157.521     0.200
    10.798   155.131     0.200
    10.840   156.221     0.200
    11.932   168.121     0.200
    13.357   190.422     0.200
    13.671   193.910     0.200
    13.973   199.721     0.200
    15.251   214.721     0.200
    18.358   253.521     0.200
    18.527   257.621     0.200
    18.771   262.721     0.200
    19.447   267.721     0.200
    19.848   272.422     0.200
    20.543   280.221     0.200
     1.482    26.539     0.200
     1.506    25.930     0.200
     1.783    30.840     0.200
     1.921    32.809     0.200
     1.958    32.270     0.200
     2.088    35.109     0.200
     2.225    36.430     0.200
     2.334    39.529     0.200
     3.143    51.369     0.200
     3.178    51.689     0.200
     4.078    62.750     0.200
     8.414   122.520     0.200
    10.788   157.270     0.200
    19.840   272.635     0.200
     1.794    30.434     0.200
     2.047    34.723     0.200
     2.336    38.393     0.200
     2.328    36.113     0.200
     2.487    40.133     0.200
     3.114    50.023     0.200
     3.199    50.963     0.200
     3.278    52.963     0.200
     4.180    61.492     0.200
     8.827   127.254     0.200
    11.112   159.684     0.200
    14.071   199.453     0.200
    15.604   219.934     0.200
    18.964   262.793     0.200
     1.833    31.863     0.200
     2.009    34.742     0.200
     2.340    39.422     0.200
     2.370    39.104     0.200
     2.470    40.572     0.200
     3.075    50.213     0.200
     3.163    50.682     0.200
     3.313    52.162     0.200
     3.313    54.539     0.200
     3.313    51.992     0.200
     3.313    52.432     0.200
     4.246    66.162     0.200
     8.810   128.752     0.200
     9.789   142.893     0.200
     9.789   142.303     0.200
     9.787   144.393     0.200
    11.132   164.193     0.200
    11.132   164.412     0.200
    11.196   165.492     0.200
    12.189   171.592     0.200
    13.730   196.592     0.200
    14.057   201.703     0.200
    16.439   230.992     0.200
    18.688   260.492     0.200
    18.688   260.303     0.200
    18.863   262.592     0.200
    18.927   264.793     0.200
    18.927   263.363     0.200
    19.705   272.893     0.200
    19.705   272.104     0.200
    20.225   281.793     0.200
    20.938   284.793     0.200
     1.847    31.010     0.200
     2.025    33.699     0.200
     3.246    52.754     0.200
     3.246    51.359     0.200
     8.318   118.600     0.200
     9.644   138.420     0.200
    10.786   153.939     0.200
    14.466   203.680     0.200
    15.195   215.199     0.200
    18.347   253.580     0.200
     3.231    47.027     0.200
     8.392   124.268     0.200
    10.819   155.318     0.200
     0.913    19.445     0.200
     1.616    27.916     0.200
     2.098    35.984     0.200
     3.176    49.686     0.200
     4.870    76.916     0.200
     8.594   122.246     0.200
     9.624   136.475     0.200
     1.665    29.021     0.200
     2.077    36.000     0.200
     2.296    37.250     0.200
     2.281    38.621     0.200
     2.534    42.531     0.200
     2.709    45.361     0.200
     3.239    53.891     0.200
     4.817    77.250     0.200
     3.004    47.918     0.200
     3.129    52.232     0.200
     3.129    49.334     0.200
     3.129    48.598     0.200
     4.332    66.408     0.200
     4.923    74.918     0.200
     5.247    82.062     0.200
     6.310    95.338     0.200
     8.418   125.537     0.200
     8.758   128.309     0.200
     9.257   138.438     0.200
     9.216   136.838     0.200
     9.600   137.438     0.200
     9.612   142.238     0.200
    10.496   150.066     0.200
    10.972   155.938     0.200
    10.950   161.139     0.200
    11.021   162.838     0.200
    11.999   168.338     0.200
    12.811   181.938     0.200
    13.195   188.088     0.200
    13.365   190.537     0.200
    13.563   196.537     0.200
    13.704   195.078     0.200
    13.758   196.338     0.200
    13.977   200.838     0.200
    14.071   198.838     0.200
    13.988   201.838     0.200
    13.988   199.908     0.200
    14.157   201.969     0.200
    14.415   205.357     0.200
    15.055   213.537     0.200
    15.055   211.398     0.200
    14.937   211.889     0.200
    15.415   218.139     0.200
    15.448   218.338     0.200
    15.504   219.559     0.200
    15.642   222.139     0.200
    15.537   220.428     0.200
    15.627   221.229     0.200
    16.198   226.537     0.200
    16.122   227.088     0.200
    18.505   258.838     0.200
    18.682   260.738     0.200
    19.017   264.838     0.200
    19.517   270.738     0.200
    19.517   267.598     0.200
    19.655   272.537     0.200
    19.879   273.938     0.200
    19.972   273.639     0.200
    19.962   275.238     0.200
    20.189   276.938     0.200
    20.567   280.037     0.200
    20.591   281.658     0.200
    20.328   281.738     0.200
    20.644   286.037     0.200
    20.702   282.438     0.200
    20.790   286.639     0.200
     1.383    23.523     0.200
     1.541    26.484     0.200
     1.858    30.895     0.200
     1.949    32.404     0.200
     2.055    34.693     0.200
     2.003    33.424     0.200
     2.278    37.434     0.200
     2.318    37.555     0.200
     2.482    40.604     0.200
     2.869    44.943     0.200
     2.851    44.854     0.200
     3.077    48.715     0.200
     3.051    47.443     0.200
     3.270    52.814     0.200
     3.270    50.885     0.200
     3.260    52.064     0.200
     3.661    57.783     0.200
     3.679    57.014     0.200
     3.783    58.994     0.200
     3.815    58.135     0.200
     4.084    62.705     0.200
     4.091    61.955     0.200
     4.279    65.004     0.200
     4.797    73.955     0.200
     5.077    77.818     0.200
     7.013   106.465     0.200
     7.350   108.715     0.200
     7.527   113.754     0.200
     8.298   118.734     0.200
     9.152   134.844     0.200
     9.410   136.545     0.200
     9.664   138.744     0.200
     9.664   138.215     0.200
    10.793   153.854     0.200
    10.819   157.244     0.200
    11.019   159.744     0.200
    11.972   169.045     0.200
    12.897   183.545     0.200
    12.897   181.004     0.200
    12.985   182.443     0.200
    13.208   185.484     0.200
    13.318   190.844     0.200
    13.370   188.045     0.200
    13.541   194.244     0.200
    13.541   191.004     0.200
    13.728   193.064     0.200
    13.761   194.434     0.200
    14.108   199.045     0.200
    14.209   202.443     0.200
    14.173   199.654     0.200
    14.453   202.844     0.200
    14.539   207.645     0.200
    14.971   209.344     0.200
    15.102   211.744     0.200
    15.219   215.744     0.200
    15.219   213.635     0.200
    15.218   216.088     0.200
    15.218   213.545     0.200
    15.445   215.783     0.200
    15.455   216.295     0.200
    15.673   220.084     0.200
    15.664   218.244     0.200
    15.843   222.645     0.200
    16.262   228.135     0.200
    17.500   242.693     0.200
    18.355   254.744     0.200
    18.355   253.184     0.200
    18.519   256.344     0.200
    18.617   259.645     0.200
    19.417   266.443     0.200
    19.417   265.885     0.200
    19.407   266.545     0.200
    19.662   268.844     0.200
    19.858   271.594     0.200
    19.949   275.844     0.200
    20.005   273.645     0.200
    20.195   276.943     0.200
    20.270   276.045     0.200
    20.349   276.844     0.200
    20.493   278.943     0.200
    20.477   277.844     0.200
    20.644   281.045     0.200
    20.953   285.244     0.200
     1.265    23.104     0.200
     1.559    27.143     0.200
     1.555    26.613     0.200
     1.859    30.373     0.200
     2.040    33.973     0.200
     2.156    34.604     0.200
     2.180    36.543     0.200
     2.289    36.732     0.200
     2.554    40.732     0.200
     2.647    41.752     0.200
     3.093    48.553     0.200
     3.077    47.652     0.200
     3.104    49.863     0.200
     3.239    51.273     0.200
     3.239    51.648     0.200
     3.239    51.143     0.200
     3.536    55.062     0.200
     3.648    56.043     0.200
     3.788    59.312     0.200
     4.097    62.172     0.200
     4.267    64.752     0.200
     4.807    74.213     0.200
     6.383    94.502     0.200
     8.469   124.203     0.200
     8.624   124.652     0.200
     9.610   142.604     0.200
     9.691   138.104     0.200
     9.691   138.264     0.200
    10.966   156.633     0.200
    11.019   163.402     0.200
    12.061   168.902     0.200
    12.326   182.002     0.200
    12.935   181.229     0.200
    13.176   184.713     0.200
    13.438   187.002     0.200
    13.544   195.703     0.200
    13.637   194.633     0.200
    13.865   198.303     0.200
    13.865   196.842     0.200
    14.069   198.803     0.200
    14.155   198.902     0.200
    15.176   212.322     0.200
    15.367   216.592     0.200
    15.436   215.902     0.200
    15.414   215.902     0.200
    15.512   218.402     0.200
    15.795   223.604     0.200
    16.416   229.604     0.200
    18.525   259.002     0.200
    18.525   256.082     0.200
    18.697   259.502     0.200
    18.848   262.203     0.200
    18.848   261.434     0.200
    19.555   270.303     0.200
    19.555   267.992     0.200
    19.852   273.203     0.200
    19.920   275.002     0.200
    20.005   273.127     0.200
    20.161   277.303     0.200
    20.290   281.002     0.200
    20.344   278.104     0.200
    20.590   281.002     0.200
    20.605   282.104     0.200
    20.742   283.104     0.200
    20.742   282.104     0.200
    20.916   286.303     0.200
     1.600    27.492     0.200
     2.221    37.883     0.200
     2.104    35.500     0.200
     2.225    37.102     0.200
     3.171    48.672     0.200
     3.112    49.609     0.200
     3.167    50.770     0.200
     4.089    63.480     0.200
     4.874    75.562     0.200
     8.606   123.121     0.200
    10.899   154.539     0.200
    13.483   193.512     0.200
    13.841   194.020     0.200
    14.158   200.602     0.200
    14.423   202.770     0.200
    14.555   204.910     0.200
    15.111   211.730     0.200
    18.629   258.109     0.200
    18.778   259.812     0.200
    19.935   273.438     0.200
    19.935   272.609     0.200
    20.291   276.109     0.200
    20.671   280.512     0.200
    20.671   281.512     0.200
     1.021    20.742     0.200
     1.691    29.984     0.200
     2.137    37.852     0.200
     2.575    44.953     0.200
     3.129    49.457     0.200
     8.707   130.594     0.200
    10.921   156.293     0.200
    18.982   265.273     0.200
     1.084    20.840     0.200
     1.460    26.281     0.200
     1.741    30.031     0.200
     1.683    29.070     0.200
     2.217    36.859     0.200
     2.239    37.328     0.200
     2.121    35.691     0.200
     2.652    43.469     0.200
     2.600    41.891     0.200
     3.059    50.898     0.200
     3.187    51.441     0.200
     3.424    56.051     0.200
     3.889    61.441     0.200
     4.114    64.109     0.200
     4.869    75.461     0.200
     9.658   139.102     0.200
    10.999   161.301     0.200
    11.067   164.301     0.200
    12.053   170.000     0.200
    13.606   196.102     0.200
    13.650   195.570     0.200
    13.703   195.031     0.200
    14.032   202.500     0.200
    14.808   212.500     0.200
    14.883   211.441     0.200
    18.731   260.602     0.200
    18.984   266.102     0.200
    19.920   273.602     0.200
    20.000   275.801     0.200
     1.134    22.398     0.200
     1.688    30.020     0.200
     1.748    29.719     0.200
     2.019    33.250     0.200
     2.100    36.102     0.200
     2.274    37.840     0.200
     2.275    38.641     0.200
     2.545    38.871     0.200
     2.708    45.520     0.200
     3.167    51.520     0.200
     3.176    55.129     0.200
     3.218    53.930     0.200
     4.151    68.371     0.200
     9.694   142.750     0.200
    11.053   159.441     0.200
    11.053   159.852     0.200
    12.099   170.340     0.200
    13.662   196.441     0.200
    14.546   209.039     0.200
    14.864   212.840     0.200
    15.548   220.910     0.200
    18.608   259.941     0.200
    18.785   262.441     0.200
    19.620   271.039     0.200
    20.884   285.340     0.200
     1.697    30.094     0.200
     3.134    50.699     0.200
     8.527   125.832     0.200
    19.861   272.301     0.200
     1.376    24.496     0.200
     1.620    28.020     0.200
     1.884    32.008     0.200
     1.937    32.797     0.200
     2.084    35.559     0.200
     2.029    35.188     0.200
     2.940    44.699     0.200
     3.255    49.496     0.200
     3.070    50.656     0.200
     3.683    57.379     0.200
     8.224   121.328     0.200
     1.679    29.332     0.200
     1.983    31.781     0.200
     2.091    33.961     0.200
     2.343    36.953     0.200
     2.448    40.164     0.200
     2.714    43.582     0.200
     3.296    54.793     0.200
     3.296    52.031     0.200
     3.431    56.242     0.200
     3.690    59.754     0.200
     4.144    65.203     0.200
     4.202    65.344     0.200
     4.753    73.312     0.200
     9.723   140.914     0.200
    10.924   157.773     0.200
    10.924   156.543     0.200
    10.962   161.973     0.200
    12.063   169.574     0.200
    13.472   195.172     0.200
    14.361   206.172     0.200
    15.368   216.223     0.200
    17.353   239.863     0.200
    18.652   261.773     0.200
    19.532   272.473     0.200
    20.026   279.074     0.200
    20.450   278.672     0.200
    20.645   282.973     0.200
    20.836   283.672     0.200
     1.100    22.367     0.200
     1.701    29.828     0.200
     1.725    31.266     0.200
     2.134    36.766     0.200
     2.230    38.387     0.200
     2.223    37.676     0.200
     2.597    42.195     0.200
     3.052    51.496     0.200
     3.905    64.285     0.200
     1.450    26.109     0.200
     1.591    26.230     0.200
     1.837    31.000     0.200
     2.025    34.070     0.200
     2.254    37.031     0.200
     2.552    41.480     0.200
     3.091    49.871     0.200
     3.126    49.281     0.200
     3.274    50.766     0.200
     3.274    50.551     0.200
     3.496    56.219     0.200
     4.777    74.539     0.200
     8.727   127.699     0.200
     9.740   137.770     0.200
    11.054   157.430     0.200
    13.971   199.238     0.200
    14.024   200.398     0.200
    14.410   206.559     0.200
    16.433   229.961     0.200
    18.895   264.059     0.200
    18.895   263.441     0.200
    20.085   274.066     0.200
     0.852    16.934     0.200
     0.942    19.387     0.200
     1.318    24.316     0.200
     1.626    28.516     0.200
     3.190    51.484     0.200
     3.869    60.195     0.200
    19.927   273.562     0.200
     1.148    21.359     0.200
     1.416    24.430     0.200
     1.518    26.668     0.200
     1.831    31.449     0.200
     1.956    32.578     0.200
     2.017    34.219     0.200
     2.298    37.609     0.200
     2.294    37.820     0.200
     2.856    45.008     0.200
     2.889    45.230     0.200
     3.074    49.047     0.200
     3.247    50.930     0.200
     3.247    50.504     0.200
     3.247    48.188     0.200
     3.336    52.367     0.200
     3.707    57.637     0.200
     3.755    58.688     0.200
     3.811    58.457     0.200
     4.103    63.270     0.200
     4.126    61.699     0.200
     4.139    63.918     0.200
     4.481    66.777     0.200
     4.815    72.777     0.200
     5.952    88.930     0.200
     8.335   120.848     0.200
     8.355   122.207     0.200
     9.150   134.609     0.200
     9.417   136.508     0.200
     9.648   139.309     0.200
     9.648   137.750     0.200
    10.797   157.008     0.200
    11.964   168.809     0.200
    12.960   184.109     0.200
    13.330   192.207     0.200
    13.359   187.008     0.200
    13.576   193.238     0.200
    14.094   198.309     0.200
    14.181   200.059     0.200
    14.220   201.508     0.200
    18.358   253.570     0.200
    18.523   257.809     0.200
    18.656   260.410     0.200
    18.656   258.359     0.200
    19.416   269.008     0.200
    19.416   267.438     0.200
    19.987   277.508     0.200
    20.303   275.910     0.200
    20.460   279.910     0.200
    20.496   280.309     0.200
    20.496   278.297     0.200
    20.977   285.609     0.200
     1.555    27.730     0.200
     1.700    30.449     0.200
     1.713    29.859     0.200
     2.115    35.320     0.200
     2.190    36.859     0.200
     2.966    48.410     0.200
     3.099    47.672     0.200
     3.256    52.473     0.200
     3.323    55.129     0.200
     3.945    62.090     0.200
     4.949    77.602     0.200
     8.706   128.660     0.200
     9.564   136.441     0.200
    13.933   201.512     0.200
    15.389   220.520     0.200
    19.001   265.191     0.200
     1.525    26.781     0.200
     1.707    30.102     0.200
     1.891    32.262     0.200
     2.022    33.961     0.200
     2.075    35.449     0.200
     2.328    38.430     0.200
     3.020    48.082     0.200
     3.134    51.910     0.200
     1.145    22.457     0.200
     1.695    30.090     0.200
     1.737    29.859     0.200
     2.226    37.988     0.200
     2.252    36.949     0.200
     2.575    41.520     0.200
     3.052    50.539     0.200
     3.167    52.625     0.200
     3.167    52.859     0.200
     3.220    52.410     0.200
     3.272    51.469     0.200
     3.430    56.059     0.200
     3.930    64.508     0.200
     4.892    75.957     0.200
     8.828   129.648     0.200
     9.646   140.039     0.200
    11.020   161.688     0.200
    19.041   268.480     0.200
    19.041   265.500     0.200
     1.142    21.488     0.200
     1.396    25.207     0.200
     1.691    29.547     0.200
     1.747    30.148     0.200
     2.011    34.070     0.200
     2.100    35.230     0.200
     2.277    38.070     0.200
     2.280    37.277     0.200
     2.539    43.027     0.200
     3.103    49.988     0.200
     1.655    28.738     0.200
     1.780    30.359     0.200
     2.028    34.258     0.200
     2.071    34.910     0.200
     2.275    37.871     0.200
     2.298    38.469     0.200
     2.539    41.938     0.200
     3.120    49.719     0.200
     3.138    52.008     0.200
     3.193    50.289     0.200
     3.242    54.895     0.200
     3.680    58.699     0.200
     3.846    62.109     0.200
     4.218    65.328     0.200
    12.918   183.074     0.200
     1.632    27.402     0.200
     1.782    29.902     0.200
     2.146    35.672     0.200
     2.108    35.383     0.200
     2.161    36.262     0.200
     2.229    37.445     0.200
     2.662    42.523     0.200
     3.039    49.824     0.200
     3.153    49.613     0.200
     3.173    51.195     0.200
     3.386    53.285     0.200
     3.547    55.383     0.200
     3.861    60.902     0.200
     4.292    65.633     0.200
     4.870    72.262     0.200
     8.673   126.785     0.200
     9.637   137.582     0.200
    11.006   161.832     0.200
    13.391   190.035     0.200
    13.536   196.434     0.200
    14.916   210.465     0.200
    18.673   260.535     0.200
    18.924   262.715     0.200
    19.162   264.332     0.200
    19.522   270.035     0.200
    19.522   269.023     0.200
    19.922   273.734     0.200
    19.974   273.484     0.200
    19.974   273.234     0.200
    20.269   277.133     0.200
    20.627   280.535     0.200
    20.747   282.332     0.200
     1.382    25.523     0.200
     1.650    28.555     0.200
     1.793    30.832     0.200
     2.000    34.484     0.200
     2.053    34.863     0.200
     2.324    37.992     0.200
     2.306    38.332     0.200
     2.507    40.422     0.200
     3.147    50.293     0.200
     3.119    50.535     0.200
     3.191    49.754     0.200
     3.267    54.352     0.200
     3.516    54.492     0.200
     3.709    58.715     0.200
     3.832    60.113     0.200
     4.192    63.723     0.200
     4.791    74.875     0.200
     8.807   127.844     0.200
     9.743   139.363     0.200
    11.092   159.902     0.200
    12.941   183.348     0.200
    13.559   195.914     0.200
    13.613   193.102     0.200
    14.051   201.574     0.200
    18.957   264.875     0.200
    19.663   273.574     0.200
     1.125    21.641     0.200
     1.433    26.172     0.200
     1.703    29.410     0.200
     1.726    29.461     0.200
     2.045    35.590     0.200
     2.151    36.289     0.200
     2.235    37.602     0.200
     2.221    37.180     0.200
     3.046    48.039     0.200
     1.412    24.633     0.200
     1.639    28.273     0.200
     1.952    33.281     0.200
     2.056    35.312     0.200
     2.068    35.250     0.200
     2.266    36.500     0.200
     2.575    41.141     0.200
     1.576    27.953     0.200
     1.588    27.117     0.200
     1.825    30.758     0.200
     2.079    35.227     0.200
     2.128    35.641     0.200
     2.195    36.703     0.200
     2.249    36.961     0.200
     3.143    50.805     0.200
     3.825    60.484     0.200
     4.846    77.352     0.200
     1.786    30.016     0.200
     1.987    34.617     0.200
     2.057    35.008     0.200
     2.324    39.383     0.200
     2.499    40.578     0.200
     3.149    51.281     0.200
     3.123    50.383     0.200
     3.266    53.656     0.200
     3.266    53.422     0.200
     3.266    54.781     0.200
     3.202    50.836     0.200
     3.521    55.438     0.200
     3.722    59.781     0.200
     3.838    61.961     0.200
     4.793    74.680     0.200
     8.822   130.828     0.200
     9.744   138.719     0.200
    11.100   162.430     0.200
    18.655   259.391     0.200
    19.668   271.141     0.200
    20.123   275.688     0.200
     1.227    22.680     0.200
     1.432    25.117     0.200
     1.622    28.422     0.200
     1.858    30.656     0.200
     1.932    32.883     0.200
     2.079    35.391     0.200
     2.876    45.531     0.200
     3.122    50.570     0.200
     3.203    52.000     0.200
     3.738    59.516     0.200
     4.874    75.516     0.200
     8.250   120.883     0.200
     9.584   138.992     0.200
    10.703   156.266     0.200
    13.485   191.711     0.200
    18.636   258.789     0.200
     1.663    28.086     0.200
     1.782    30.836     0.200
     1.987    33.594     0.200
     2.061    34.945     0.200
     2.321    38.578     0.200
     2.315    38.625     0.200
     2.500    40.383     0.200
     3.146    52.336     0.200
     3.127    51.281     0.200
     3.842    61.844     0.200
     4.796    76.844     0.200
     9.741   139.562     0.200
    13.050   183.492     0.200
     1.157    22.078     0.200
     1.362    25.281     0.200
     1.648    28.250     0.200
     1.980    34.172     0.200
     2.042    35.039     0.200
     2.327    37.992     0.200
     2.340    38.320     0.200
     3.108    51.914     0.200
     3.165    51.875     0.200
     1.049    20.133     0.200
     1.484    26.656     0.200
     1.644    28.000     0.200
     2.256    37.883     0.200
     2.101    35.414     0.200
     2.094    35.375     0.200
     2.608    44.000     0.200
     3.072    50.664     0.200
     3.203    48.180     0.200
     3.160    50.789     0.200
    18.944   262.789     0.200
     1.087    20.852     0.200
     1.176    21.859     0.200
     1.757    29.992     0.200
     1.670    29.445     0.200
     2.067    34.922     0.200
     2.104    35.320     0.200
     2.230    36.797     0.200
     3.077    50.484     0.200
     3.202    47.602     0.200
     3.170    51.680     0.200
     3.873    60.031     0.200
     1.506    26.444     0.200
     1.584    27.294     0.200
     1.695    29.934     0.200
     2.041    32.764     0.200
     2.051    34.804     0.200
     2.262    36.504     0.200
     2.623    43.083     0.200
     3.111    49.313     0.200
     1.387    24.316     0.200
     1.617    26.206     0.200
     1.634    28.456     0.200
     1.868    30.076     0.200
     2.044    34.646     0.200
     2.079    35.016     0.200
     2.186    36.276     0.200
     2.541    40.646     0.200
     2.574    42.306     0.200
     2.828    44.996     0.200
     2.956    46.596     0.200
     3.084    49.276     0.200
     3.242    53.170     0.200
     3.242    54.074     0.200
     3.242    49.586     0.200
     3.289    50.096     0.200
     3.695    57.096     0.200
     3.717    60.646     0.200
     3.895    58.816     0.200
     4.086    62.086     0.200
     4.122    63.066     0.200
     4.126    60.516     0.200
     4.414    66.026     0.200
     4.839    74.606     0.200
     8.216   118.326     0.200
     9.327   137.426     0.200
     9.617   136.226     0.200
    10.736   157.826     0.200
    11.910   168.526     0.200
    12.805   178.816     0.200
    13.232   192.026     0.200
    13.313   187.526     0.200
    13.455   192.426     0.200
    13.455   189.306     0.200
    13.994   197.726     0.200
    15.132   211.326     0.200
    15.190   212.336     0.200
    15.587   217.896     0.200
    18.277   251.796     0.200
    19.572   269.526     0.200
    19.913   274.226     0.200
    19.928   279.626     0.200
    20.181   276.326     0.200
    20.259   278.026     0.200
    20.386   278.726     0.200
    20.495   282.126     0.200
    20.861   285.726     0.200
    20.882   285.326     0.200
     1.499    25.621     0.200
     1.625    28.351     0.200
     1.803    30.271     0.200
     2.041    33.791     0.200
     2.158    36.271     0.200
     2.222    35.701     0.200
     2.226    36.131     0.200
     2.620    41.381     0.200
     2.665    43.051     0.200
     2.689    44.111     0.200
     3.098    49.258     0.200
     3.098    47.121     0.200
     3.373    50.641     0.200
     3.293    51.741     0.200
     3.334    51.651     0.200
     3.535    54.701     0.200
     3.672    55.521     0.200
     4.035    61.911     0.200
     4.002    61.251     0.200
     4.258    63.551     0.200
     4.359    66.571     0.200
     4.509    67.731     0.200
     4.936    73.021     0.200
     4.963    74.881     0.200
     6.302    95.101     0.200
     7.392   110.361     0.200
     8.850   128.601     0.200
     9.580   137.401     0.200
     9.580   137.571     0.200
     9.646   140.901     0.200
    10.954   159.401     0.200
    10.974   156.361     0.200
    11.055   163.901     0.200
    11.996   168.201     0.200
    12.768   181.922     0.200
    13.356   186.001     0.200
    13.605   195.701     0.200
    13.712   194.091     0.200
    13.956   199.401     0.200
    14.076   201.501     0.200
    14.076   200.011     0.200
    14.166   199.351     0.200
    15.014   212.501     0.200
    15.014   209.061     0.200
    15.487   217.101     0.200
    16.135   226.601     0.200
    16.211   225.981     0.200
    16.645   234.091     0.200
    18.527   257.701     0.200
    18.611   258.401     0.200
    19.104   265.401     0.200
    19.529   269.401     0.200
    19.698   270.501     0.200
    19.925   273.501     0.200
    19.986   273.851     0.200
    20.412   282.501     0.200
    20.697   286.501     0.200
    20.847   284.601     0.200
     1.585    29.028     0.200
     1.787    30.878     0.200
     2.166    36.928     0.200
     2.213    36.878     0.200
     2.217    36.358     0.200
     2.621    41.448     0.200
     2.666    44.018     0.200
     2.680    44.208     0.200
     3.107    47.118     0.200
     3.280    51.448     0.200
     3.317    51.738     0.200
     3.376    55.388     0.200
     4.952    79.118     0.200
     8.835   130.498     0.200
     9.587   135.618     0.200
    19.087   265.038     0.200
     1.094    20.930     0.200
     1.448    25.309     0.200
     1.583    27.170     0.200
     1.681    28.680     0.200
     1.745    29.520     0.200
     2.063    34.619     0.200
     2.113    34.949     0.200
     2.230    35.068     0.200
     2.249    37.170     0.200
     2.586    41.840     0.200
     2.664    43.170     0.200
     2.719    43.738     0.200
     2.799    45.430     0.200
     3.070    48.760     0.200
     3.180    50.359     0.200
     3.194    50.926     0.200
     3.194    49.670     0.200
     3.194    49.449     0.200
     3.214    50.289     0.200
     3.436    54.709     0.200
     3.648    57.080     0.200
     4.124    61.869     0.200
     4.154    65.889     0.200
     4.387    66.129     0.200
     4.860    74.250     0.200
     5.187    83.920     0.200
     8.773   126.719     0.200
     9.671   140.020     0.200
     9.666   139.619     0.200
    11.012   157.238     0.200
    11.080   161.818     0.200
    12.065   170.520     0.200
    13.619   198.219     0.200
    14.009   197.020     0.200
    18.744   260.318     0.200
    18.983   265.719     0.200
    19.582   271.719     0.200
    19.582   269.619     0.200
    19.711   270.920     0.200
    19.933   274.219     0.200
    20.036   274.520     0.200
    20.038   277.020     0.200
    20.240   276.818     0.200
    20.617   281.645     0.200
    20.696   283.318     0.200
    20.729   282.020     0.200
    20.840   283.920     0.200
     1.226    22.482     0.200
     1.434    24.643     0.200
     1.857    29.771     0.200
     1.932    32.201     0.200
     2.029    35.152     0.200
     2.080    35.062     0.200
     2.194    35.361     0.200
     2.249    36.752     0.200
     2.513    40.941     0.200
     3.124    48.213     0.200
     4.134    61.521     0.200
     8.250   120.242     0.200
     1.532    25.916     0.200
     1.512    25.857     0.200
     1.730    29.426     0.200
     1.687    28.617     0.200
     2.126    35.277     0.200
     2.164    36.137     0.200
     2.147    35.727     0.200
     2.601    42.957     0.200
     2.658    43.207     0.200
     3.018    48.197     0.200
     3.148    50.176     0.200
     3.148    49.537     0.200
     3.148    49.217     0.200
     3.211    50.637     0.200
     3.213    51.326     0.200
     3.377    52.826     0.200
     3.908    59.057     0.200
     4.075    62.727     0.200
     4.397    65.846     0.200
     4.902    76.396     0.200
     8.726   126.926     0.200
     9.615   138.256     0.200
     9.615   137.846     0.200
     9.606   138.756     0.200
    10.985   159.256     0.200
    11.015   161.557     0.200
    12.007   170.156     0.200
    12.833   184.807     0.200
    13.553   195.857     0.200
    13.958   199.557     0.200
    13.958   199.768     0.200
    15.077   212.697     0.200
    15.440   217.250     0.200
    16.227   228.156     0.200
    16.542   232.557     0.200
    18.679   259.557     0.200
    18.709   260.357     0.200
    18.982   265.156     0.200
    18.982   261.727     0.200
    19.520   268.957     0.200
    19.972   273.057     0.200
    20.220   278.357     0.200
    20.674   281.457     0.200
     1.131    20.412     0.200
     1.375    24.223     0.200
     1.845    31.162     0.200
     1.985    32.633     0.200
     2.103    33.893     0.200
     2.155    34.023     0.200
     1.264    22.973     0.200
     1.420    24.613     0.200
     1.835    30.383     0.200
     1.968    32.652     0.200
     2.055    32.773     0.200
     2.081    35.123     0.200
     2.256    37.312     0.200
     2.504    40.344     0.200
     4.877    77.402     0.200
    18.612   259.693     0.200
     1.408    24.578     0.200
     1.594    26.008     0.200
     1.646    28.518     0.200
     1.960    32.738     0.200
     2.063    34.678     0.200
     2.172    35.498     0.200
     2.067    34.898     0.200
     2.518    40.428     0.200
     3.013    47.869     0.200
     3.107    50.049     0.200
     3.219    51.664     0.200
     3.219    50.811     0.200
     3.266    49.709     0.200
     4.863    74.539     0.200
     8.215   120.088     0.200
     9.308   139.229     0.200
    10.694   152.039     0.200
    10.716   158.529     0.200
    13.451   189.588     0.200
    13.593   195.828     0.200
    14.104   202.029     0.200
    15.114   214.328     0.200
    15.167   212.678     0.200
    18.604   259.928     0.200
    19.302   265.629     0.200
    19.556   269.229     0.200
    19.945   279.129     0.200
    20.176   276.428     0.200
    20.371   280.828     0.200
    20.475   279.428     0.200
    20.849   283.428     0.200
     1.617    26.617     0.200
     1.664    28.559     0.200
     1.844    30.617     0.200
     1.981    32.658     0.200
     2.095    34.908     0.200
     2.052    34.979     0.200
     2.157    36.068     0.200
     2.291    37.809     0.200
     2.527    40.969     0.200
     3.089    50.668     0.200
     3.241    51.178     0.200
     4.077    61.787     0.200
     4.848    74.549     0.200
     8.185   118.299     0.200
    10.693   151.848     0.200
    13.423   193.648     0.200
    15.187   212.098     0.200
    18.572   257.488     0.200
    20.890   284.314     0.200
     1.583    27.848     0.200
     1.615    27.887     0.200
     1.801    30.270     0.200
     2.084    35.098     0.200
     2.145    36.109     0.200
     2.168    35.430     0.200
     2.254    37.820     0.200
     2.639    42.668     0.200
     2.688    43.680     0.200
     3.065    48.969     0.200
     3.203    51.820     0.200
     3.203    53.098     0.200
     3.412    53.359     0.200
     3.664    55.789     0.200
     3.839    60.547     0.200
     4.126    63.477     0.200
     4.844    74.398     0.200
     5.325    81.660     0.200
     8.677   127.879     0.200
     9.146   137.898     0.200
     9.617   142.598     0.200
     9.663   140.598     0.200
    10.966   162.078     0.200
    11.032   157.500     0.200
    11.026   163.898     0.200
    12.044   171.500     0.200
    13.417   189.699     0.200
    13.557   196.699     0.200
    13.915   199.289     0.200
    14.040   205.199     0.200
    14.129   200.898     0.200
    14.496   206.797     0.200
    15.136   214.609     0.200
    15.446   218.898     0.200
    15.431   219.500     0.200
    16.295   229.098     0.200
    16.856   236.898     0.200
    18.524   260.500     0.200
    18.524   257.637     0.200
    18.697   261.297     0.200
    18.778   261.699     0.200
    18.910   266.199     0.200
    18.910   263.180     0.200
    19.188   265.598     0.200
    19.547   272.398     0.200
    19.942   274.000     0.200
    20.221   281.699     0.200
     1.618    27.176     0.200
     1.684    28.965     0.200
     1.829    30.496     0.200
     2.002    33.156     0.200
     2.105    34.906     0.200
     2.057    35.145     0.200
     2.290    37.098     0.200
     2.518    40.527     0.200
     2.625    44.145     0.200
     2.805    45.047     0.200
     3.027    48.117     0.200
     3.002    47.906     0.200
     3.120    49.145     0.200
     3.092    50.406     0.200
     3.240    51.207     0.200
     3.240    52.406     0.200
     3.268    51.867     0.200
     3.694    58.125     0.200
     4.356    64.875     0.200
     4.853    74.605     0.200
     5.119    80.609     0.200
     8.165   119.395     0.200
     8.636   127.586     0.200
     9.048   132.086     0.200
     9.287   135.086     0.200
     9.602   139.688     0.200
     9.602   137.215     0.200
    10.679   155.285     0.200
    10.696   155.887     0.200
    10.953   158.387     0.200
    12.955   185.762     0.200
    13.188   189.887     0.200
    13.403   192.586     0.200
    13.403   191.375     0.200
    13.846   197.457     0.200
    14.038   200.484     0.200
    14.079   199.887     0.200
    15.026   213.957     0.200
    15.090   213.430     0.200
    15.090   213.086     0.200
    15.186   216.484     0.200
    15.435   219.086     0.200
    16.248   226.387     0.200
    16.474   231.586     0.200
    17.626   245.758     0.200
    18.561   259.586     0.200
    18.561   257.625     0.200
    18.987   262.887     0.200
    19.276   266.086     0.200
    19.313   266.086     0.200
    19.313   266.746     0.200
    19.479   267.586     0.200
    19.524   268.086     0.200
    19.751   270.484     0.200
    19.751   271.484     0.200
    19.863   272.285     0.200
    19.904   276.984     0.200
    20.129   275.688     0.200
    20.212   275.887     0.200
    20.337   277.785     0.200
    20.508   280.785     0.200
    20.503   279.086     0.200
    20.810   282.586     0.200
    20.896   284.688     0.200
     1.612    28.438     0.200
     1.765    29.859     0.200
     1.794    31.238     0.200
     1.874    31.746     0.200
     1.953    33.066     0.200
     2.318    38.039     0.200
     2.359    39.387     0.200
     3.019    50.258     0.200
     4.057    62.988     0.200
     8.467   125.668     0.200
    13.500   193.316     0.200
     2.975    49.008     0.200
     3.024    49.746     0.200
     8.419   119.324     0.200
     8.975   131.246     0.200
     8.991   133.547     0.200
     9.298   137.645     0.200
     9.440   138.348     0.200
     9.440   136.918     0.200
    10.657   156.547     0.200
    10.707   157.348     0.200
    10.801   156.547     0.200
    12.727   181.547     0.200
    13.402   190.227     0.200
    14.781   209.246     0.200
    16.523   231.348     0.200
    18.865   262.645     0.200
    18.973   261.758     0.200
    19.255   264.645     0.200
    19.255   266.016     0.200
    19.662   269.945     0.200
     1.910    31.234     0.200
     1.987    34.195     0.200
     8.207   120.812     0.200
    17.546   242.504     0.200
    19.831   271.086     0.200
     1.526    26.613     0.200
     1.593    27.734     0.200
     1.604    27.832     0.200
     1.812    30.164     0.200
     2.072    35.164     0.200
     2.145    35.742     0.200
     2.172    35.992     0.200
     2.265    37.102     0.200
     2.585    42.312     0.200
     2.634    41.254     0.200
     2.696    43.184     0.200
     2.859    46.395     0.200
     3.075    48.754     0.200
     3.128    49.242     0.200
     3.138    50.602     0.200
     3.170    52.504     0.200
     3.214    52.195     0.200
     3.214    50.434     0.200
     3.421    51.344     0.200
     3.565    55.465     0.200
     3.676    55.773     0.200
     3.828    59.754     0.200
     4.125    66.113     0.200
     4.137    62.223     0.200
     4.256    62.703     0.200
     4.314    66.074     0.200
     4.729    70.395     0.200
     8.673   124.484     0.200
     9.673   139.523     0.200
     9.673   137.172     0.200
    10.973   156.203     0.200
    12.053   168.625     0.200
    13.426   188.523     0.200
    13.562   194.523     0.200
    13.911   199.805     0.200
    14.139   198.422     0.200
    18.704   261.523     0.200
    18.790   260.625     0.200
    18.899   263.523     0.200
    18.899   263.043     0.200
    19.555   271.523     0.200
    19.872   272.625     0.200
    19.988   277.824     0.200
     1.378    24.156     0.200
     1.560    26.883     0.200
     1.877    30.617     0.200
     1.935    32.109     0.200
     2.006    33.805     0.200
     2.064    34.625     0.200
     2.317    37.289     0.200
     2.501    41.625     0.200
     2.592    41.547     0.200
     2.841    44.898     0.200
     2.885    42.984     0.200
     3.270    51.883     0.200
     1.538    23.438     0.200
     1.500    23.766     0.200
     1.582    24.109     0.200
     1.833    27.547     0.200
     2.056    31.586     0.200
     2.157    32.672     0.200
     2.168    31.992     0.200
     2.277    34.031     0.200
     2.575    39.211     0.200
     2.636    39.359     0.200
     3.085    45.789     0.200
     3.183    52.000     0.200
     3.227    48.195     0.200
     3.227    51.445     0.200
     3.227    50.461     0.200
     3.227    48.727     0.200
     3.427    48.750     0.200
     3.691    53.289     0.200
     4.111    59.695     0.200
     4.707    66.688     0.200
     4.820    71.742     0.200
     6.255    89.445     0.200
     6.379    93.797     0.200
     8.654   120.609     0.200
     9.295   132.797     0.200
     9.684   136.641     0.200
    10.973   158.500     0.200
    10.973   155.906     0.200
    11.029   159.797     0.200
    11.051   156.797     0.200
    12.059   165.195     0.200
    13.557   192.297     0.200
    13.869   194.695     0.200
    13.894   194.109     0.200
    14.090   197.281     0.200
    15.162   210.469     0.200
    15.448   212.602     0.200
    18.531   255.195     0.200
    18.704   256.195     0.200
    18.809   257.195     0.200
    19.558   266.195     0.200
    19.558   265.938     0.200
    19.937   270.195     0.200
    20.188   275.695     0.200
    20.760   280.398     0.200
     1.468    25.547     0.200
     1.502    26.414     0.200
     1.574    25.328     0.200
     1.807    30.508     0.200
     1.962    32.930     0.200
     1.952    32.508     0.200
     2.062    34.711     0.200
     2.313    37.289     0.200
     2.429    39.070     0.200
     2.853    44.992     0.200
     3.023    48.297     0.200
     2.944    46.461     0.200
     3.205    51.914     0.200
     3.205    52.742     0.200
     3.205    53.070     0.200
     3.115    48.250     0.200
     3.310    50.203     0.200
     3.296    51.414     0.200
     3.709    56.133     0.200
     3.702    58.578     0.200
     3.755    58.320     0.200
     3.820    57.047     0.200
     4.101    61.961     0.200
     4.140    63.164     0.200
     4.178    63.742     0.200
     4.321    63.812     0.200
     4.536    67.602     0.200
     4.852    74.672     0.200
     5.140    78.859     0.200
     5.259    79.578     0.200
     6.002    86.078     0.200
     6.281    92.891     0.200
     7.035   103.734     0.200
     7.388   108.789     0.200
     8.377   120.188     0.200
     9.135   136.594     0.200
     9.414   138.992     0.200
     9.615   138.094     0.200
     9.615   138.664     0.200
    10.142   144.891     0.200
    10.787   158.594     0.200
    10.787   157.500     0.200
    10.823   156.094     0.200
    10.973   157.188     0.200
    11.940   168.094     0.200
    12.918   182.664     0.200
    13.332   186.891     0.200
    13.333   192.094     0.200
    13.613   194.891     0.200
    13.613   195.203     0.200
    13.758   198.484     0.200
    13.795   196.398     0.200
    14.064   199.992     0.200
    14.221   203.188     0.200
    14.204   203.602     0.200
    14.480   204.711     0.200
    15.154   214.492     0.200
    15.154   214.750     0.200
    15.204   214.789     0.200
    15.443   218.289     0.200
    15.746   221.688     0.200
    15.885   224.789     0.200
    16.390   229.391     0.200
    18.348   254.789     0.200
    18.348   255.953     0.200
    18.515   256.094     0.200
    18.711   261.289     0.200
    19.149   263.422     0.200
    19.400   267.891     0.200
    19.423   266.492     0.200
    19.633   269.188     0.200
    19.690   270.594     0.200
    19.775   270.492     0.200
    19.843   271.594     0.200
    20.047   276.094     0.200
    20.041   276.992     0.200
    20.409   278.391     0.200
    20.678   283.289     0.200
    20.997   284.688     0.200
     1.470    25.728     0.200
     1.914    32.647     0.200
     2.052    33.918     0.200
     2.183    34.748     0.200
     2.343    39.218     0.200
     2.585    42.088     0.200
     2.690    45.048     0.200
     2.887    46.857     0.200
     2.989    47.375     0.200
     2.989    46.298     0.200
     3.410    53.308     0.200
     3.439    53.508     0.200
     8.892   129.578     0.200
    14.107   201.258     0.200
    19.907   273.519     0.200
     1.428    23.876     0.200
     1.458    24.886     0.200
     1.881    31.476     0.200
     2.084    33.896     0.200
     2.195    34.006     0.200
     2.308    38.436     0.200
     2.609    42.296     0.200
     2.917    47.786     0.200
    10.927   154.746     0.200
    13.779   193.025     0.200
     1.175    21.828     0.200
     1.441    23.658     0.200
     1.578    26.508     0.200
     1.901    29.988     0.200
     1.878    31.547     0.200
     2.066    34.168     0.200
     2.255    38.508     0.200
     2.541    41.297     0.200
     3.014    48.867     0.200
     3.114    51.168     0.200
     3.740    59.367     0.200
     8.302   119.967     0.200
     1.404    24.938     0.200
     1.518    25.258     0.200
     1.626    28.717     0.200
     2.175    35.816     0.200
     2.220    37.236     0.200
     2.253    35.727     0.200
     2.592    43.777     0.200
     2.690    43.707     0.200
     2.721    44.258     0.200
     3.007    50.057     0.200
     3.114    49.236     0.200
     3.286    52.727     0.200
     4.001    62.678     0.200
     4.052    62.066     0.200
     9.598   138.777     0.200
    13.331   186.197     0.200
    13.635   194.496     0.200
    13.691   191.666     0.200
    14.106   197.217     0.200
    14.145   198.666     0.200
    14.517   208.197     0.200
    15.509   215.967     0.200
    15.517   216.977     0.200
    15.645   218.486     0.200
    15.667   217.758     0.200
    16.240   225.518     0.200
    17.230   239.146     0.200
    19.114   266.197     0.200
    20.419   284.598     0.200
     1.318    19.453     0.200
     1.962    29.230     0.200
     1.984    31.254     0.200
     3.021    45.824     0.200
     3.308    47.699     0.200
     3.628    54.441     0.200
     4.067    59.742     0.200
     4.780    70.621     0.200
     8.180   117.082     0.200
    13.745   191.504     0.200
    15.557   217.742     0.200
    18.520   256.402     0.200
    18.520   256.172     0.200
    19.822   269.828     0.200
    19.822   270.203     0.200
     1.768    28.461     0.200
     1.825    29.516     0.200
     1.531    25.971     0.200
     1.510    26.982     0.200
     1.684    29.402     0.200
     2.130    36.062     0.200
     2.146    36.162     0.200
     2.160    35.432     0.200
     2.597    43.232     0.200
     2.655    43.432     0.200
     2.655    43.332     0.200
     3.016    47.791     0.200
     3.147    51.777     0.200
     3.147    50.182     0.200
     3.212    51.801     0.200
     3.682    55.871     0.200
     3.906    64.031     0.200
     4.074    65.893     0.200
     8.721   126.732     0.200
     9.614   140.881     0.200
    13.549   194.582     0.200
    16.540   232.281     0.200
    18.978   264.781     0.200
    18.978   264.602     0.200
    20.669   282.082     0.200
    20.770   283.582     0.200
    20.770   284.572     0.200
     1.543    24.863     0.200
     1.561    27.053     0.200
     1.676    29.322     0.200
     1.853    30.854     0.200
     2.038    33.443     0.200
     2.096    35.363     0.200
     2.220    36.203     0.200
     2.296    38.963     0.200
     2.436    40.893     0.200
     2.764    43.533     0.200
     3.012    47.754     0.200
     3.126    52.094     0.200
     3.172    53.238     0.200
     3.172    53.092     0.200
     3.172    48.812     0.200
     3.157    50.793     0.200
     3.331    52.693     0.200
     3.699    61.973     0.200
     3.758    58.184     0.200
     3.822    60.412     0.200
     4.083    63.463     0.200
     4.275    65.662     0.200
     4.658    70.754     0.200
     4.874    75.424     0.200
     5.318    82.354     0.200
     6.153    94.152     0.200
     7.053   103.434     0.200
     8.530   125.113     0.200
     9.610   140.943     0.200
     9.610   140.662     0.200
    10.247   149.344     0.200
    10.903   159.543     0.200
    11.965   168.943     0.200
    13.057   184.303     0.200
    13.426   191.742     0.200
    13.764   197.232     0.200
    13.988   201.844     0.200
    14.313   205.143     0.200
    15.517   220.742     0.200
    16.435   231.643     0.200
    18.413   258.133     0.200
    18.807   261.742     0.200
    18.832   264.643     0.200
    18.832   261.863     0.200
    19.449   269.123     0.200
    19.897   273.143     0.200
    20.322   279.943     0.200
    20.484   280.543     0.200
    20.623   283.633     0.200
     1.511    27.244     0.200
     2.138    35.754     0.200
     2.130    36.604     0.200
     2.163    36.543     0.200
     2.208    37.254     0.200
     2.597    43.373     0.200
     3.204    51.314     0.200
     1.674    29.232     0.200
     1.772    31.674     0.200
     2.014    34.594     0.200
     2.146    36.383     0.200
     2.290    39.084     0.200
     2.437    42.004     0.200
     2.546    41.973     0.200
     3.098    50.893     0.200
     3.234    52.373     0.200
     4.947    79.312     0.200
     1.285    21.598     0.200
     1.611    26.867     0.200
     1.659    27.418     0.200
     1.845    28.418     0.200
     1.975    31.887     0.200
     2.086    33.336     0.200
     2.056    34.168     0.200
     2.161    34.117     0.200
     2.284    35.578     0.200
     2.981    45.797     0.200
     3.094    49.578     0.200
     3.235    47.336     0.200
     3.701    57.867     0.200
     4.111    63.266     0.200
     4.085    61.348     0.200
     4.852    70.848     0.200
     8.193   118.707     0.200
    13.810   192.367     0.200
    14.704   204.977     0.200
    15.054   209.328     0.200
    19.763   270.168     0.200
     1.290    22.328     0.200
     1.449    23.816     0.200
     1.548    26.285     0.200
     1.702    27.867     0.200
     1.783    28.918     0.200
     2.012    32.047     0.200
     2.045    34.266     0.200
     2.114    34.336     0.200
     2.124    34.605     0.200
     2.455    38.355     0.200
     2.869    44.406     0.200
     2.958    49.105     0.200
     3.096    47.719     0.200
     3.161    49.488     0.200
     3.205    51.566     0.200
     3.764    57.676     0.200
     4.044    61.117     0.200
     4.139    62.316     0.200
     8.183   118.605     0.200
     9.535   138.855     0.200
    10.629   154.918     0.200
    13.356   190.977     0.200
    13.414   190.309     0.200
    18.622   259.547     0.200
    18.622   257.008     0.200
    20.312   276.477     0.200
     1.622    26.367     0.200
     1.606    26.867     0.200
     1.816    31.066     0.200
     2.055    34.297     0.200
     2.100    35.445     0.200
     2.217    36.355     0.200
     2.292    36.887     0.200
     2.630    42.406     0.200
     2.735    43.496     0.200
     3.106    50.176     0.200
     3.121    49.688     0.200
     3.818    59.348     0.200
     4.314    65.516     0.200
     4.810    75.887     0.200
     8.710   128.738     0.200
    13.100   184.805     0.200
    17.236   236.148     0.200
     1.306    22.641     0.200
     1.414    23.352     0.200
     1.583    26.250     0.200
     1.698    27.805     0.200
     1.802    29.859     0.200
     2.011    32.586     0.200
     2.092    34.289     0.200
     2.121    35.211     0.200
     3.128    49.836     0.200
    18.589   258.461     0.200
    19.721   268.961     0.200
     1.135    21.750     0.200
     1.621    27.070     0.200
     2.090    35.250     0.200
     2.280    37.809     0.200
     2.285    37.680     0.200
     3.109    49.398     0.200
     3.157    51.359     0.200
     1.552    25.488     0.200
     1.636    28.629     0.200
     2.143    34.340     0.200
     2.112    35.699     0.200
     2.224    36.270     0.200
     2.565    42.000     0.200
     2.658    43.039     0.200
     8.673   128.090     0.200
    10.938   154.098     0.200
    18.927   264.508     0.200
    18.927   262.629     0.200
     1.120    21.332     0.200
     1.386    24.113     0.200
     1.655    29.133     0.200
     1.710    27.453     0.200
     1.991    33.680     0.200
     2.224    37.770     0.200
     2.837    44.090     0.200
     3.196    50.391     0.200
     3.321    54.512     0.200
     4.733    73.641     0.200
    12.999   184.766     0.200
     1.183    22.148     0.200
     1.656    27.938     0.200
     1.681    29.867     0.200
     2.076    34.816     0.200
     2.326    40.105     0.200
     2.365    41.516     0.200
     2.809    45.098     0.200
     3.145    50.668     0.200
     3.257    55.254     0.200
     4.201    63.156     0.200
     4.806    74.777     0.200
    12.925   185.332     0.200
    18.997   266.059     0.200
     1.684    27.211     0.200
     2.047    34.211     0.200
     2.303    39.664     0.200
     2.337    40.148     0.200
     2.834    45.648     0.200
     2.852    45.891     0.200
     3.173    50.352     0.200
     3.286    51.523     0.200
     3.286    53.891     0.200
     3.286    52.602     0.200
     3.755    58.469     0.200
     4.172    64.914     0.200
     5.112    78.375     0.200
     8.849   128.039     0.200
     9.766   140.203     0.200
     9.791   142.203     0.200
    10.570   153.500     0.200
    11.140   161.102     0.200
    11.131   158.992     0.200
    11.200   165.398     0.200
    12.954   181.805     0.200
    13.538   188.602     0.200
    13.738   197.203     0.200
    13.983   197.062     0.200
    14.094   199.750     0.200
    14.622   209.500     0.200
    15.200   214.695     0.200
    15.524   220.055     0.200
    15.625   218.594     0.200
    15.625   220.172     0.200
    16.226   228.453     0.200
    17.112   239.852     0.200
    18.686   260.102     0.200
    18.781   260.602     0.200
    18.863   261.102     0.200
    18.974   264.203     0.200
    19.698   270.102     0.200
    19.830   271.398     0.200
    20.129   274.703     0.200
    20.157   276.000     0.200
     1.567    27.156     0.200
     1.997    33.516     0.200
     2.005    34.867     0.200
     2.102    35.250     0.200
     2.478    40.109     0.200
     2.980    49.070     0.200
     3.190    48.477     0.200
     3.190    48.797     0.200
     4.898    74.836     0.200
     5.166    83.312     0.200
     8.190   119.977     0.200
     9.557   138.969     0.200
    13.423   192.578     0.200
    13.856   199.242     0.200
    14.582   208.328     0.200
    18.611   259.250     0.200
    19.720   270.633     0.200
    20.330   276.867     0.200
     1.691    26.578     0.200
     2.009    33.344     0.200
     2.236    38.852     0.200
     2.338    39.359     0.200
     2.819    44.281     0.200
     2.898    44.422     0.200
     3.178    48.938     0.200
     3.303    52.938     0.200
     3.303    53.172     0.200
     3.303    50.688     0.200
     3.303    51.602     0.200
     4.158    63.188     0.200
     4.752    73.398     0.200
     5.080    77.391     0.200
     8.773   129.398     0.200
     9.255   138.141     0.200
     9.774   138.641     0.200
     9.774   141.148     0.200
     9.756   145.641     0.200
    11.104   163.141     0.200
    11.165   165.141     0.200
    12.169   170.141     0.200
    12.981   183.742     0.200
    13.538   190.539     0.200
    13.533   197.117     0.200
    13.585   197.164     0.200
    13.697   197.242     0.200
    14.020   201.141     0.200
    14.020   200.398     0.200
    14.582   207.539     0.200
    15.226   213.742     0.200
    15.226   214.859     0.200
    15.331   216.781     0.200
    15.586   220.938     0.200
    16.152   227.758     0.200
    18.660   259.141     0.200
    18.828   260.141     0.200
    18.835   259.742     0.200
    18.908   263.438     0.200
    18.908   262.094     0.200
    19.680   269.742     0.200
    19.680   269.289     0.200
    19.789   270.742     0.200
    20.007   274.039     0.200
    20.080   276.039     0.200
    20.122   278.039     0.200
    20.713   283.844     0.200
    20.750   282.641     0.200
    20.903   285.641     0.200
     1.636    27.977     0.200
     1.694    29.930     0.200
     2.110    35.375     0.200
     2.383    41.148     0.200
     2.367    41.234     0.200
     2.787    45.852     0.200
     2.800    45.297     0.200
     3.125    50.047     0.200
     3.232    53.078     0.200
     4.226    65.156     0.200
     4.835    74.625     0.200
     5.174    81.758     0.200
     8.885   132.180     0.200
     9.716   140.008     0.200
     9.716   142.117     0.200
    11.105   163.711     0.200
    11.180   163.109     0.200
    12.134   170.406     0.200
    12.895   184.133     0.200
    13.494   190.805     0.200
    13.725   198.508     0.200
    14.028   202.938     0.200
    14.125   203.266     0.200
    14.391   207.305     0.200
    14.608   209.805     0.200
    15.142   215.375     0.200
    15.609   222.805     0.200
    15.802   224.211     0.200
    16.258   231.555     0.200
    18.659   260.508     0.200
    18.837   262.211     0.200
    19.039   266.805     0.200
    19.039   264.711     0.200
    19.664   271.609     0.200
    19.664   272.219     0.200
    20.222   276.609     0.200
     0.994    19.180     0.200
     1.494    26.781     0.200
     1.622    27.375     0.200
     2.095    35.266     0.200
     2.155    35.648     0.200
     2.675    43.398     0.200
     3.052    48.867     0.200
     3.191    52.625     0.200
     3.191    48.680     0.200
     3.667    55.984     0.200
     3.849    60.414     0.200
     4.856    75.969     0.200
     8.672   127.938     0.200
    10.953   156.117     0.200
    13.158   184.289     0.200
    13.545   195.461     0.200
    14.383   201.281     0.200
    15.434   218.055     0.200
    15.455   217.891     0.200
    15.433   217.977     0.200
    18.769   259.359     0.200
    18.915   263.195     0.200
    19.985   273.805     0.200
    19.985   273.359     0.200
     1.657    27.133     0.200
     1.685    29.570     0.200
     1.964    32.141     0.200
     2.043    34.633     0.200
     2.342    36.508     0.200
     2.766    45.047     0.200
     2.830    44.781     0.200
     3.171    51.297     0.200
     3.286    49.172     0.200
     3.723    57.477     0.200
     3.827    59.367     0.200
     4.221    66.328     0.200
     4.775    74.906     0.200
     8.838   127.242     0.200
     9.765   140.219     0.200
    13.024   183.273     0.200
    13.532   193.289     0.200
    18.966   262.750     0.200
    20.148   275.602     0.200
     3.216    50.665     0.200
     3.216    50.136     0.200
     3.216    49.236     0.200
     3.216    49.371     0.200
     5.141    80.082     0.200
     8.614   124.151     0.200
     9.667   137.841     0.200
     9.667   136.341     0.200
     9.585   141.641     0.200
    10.941   156.191     0.200
    12.913   183.076     0.200
    13.413   185.941     0.200
    13.520   194.341     0.200
    14.511   204.541     0.200
    15.154   212.201     0.200
    15.411   212.941     0.200
    15.985   223.041     0.200
    16.431   229.241     0.200
    18.671   257.041     0.200
    18.815   258.641     0.200
    18.857   261.141     0.200
    18.857   260.431     0.200
    19.529   270.941     0.200
    19.979   271.371     0.200
    19.950   276.541     0.200
    20.328   276.341     0.200
     1.389    24.478     0.200
     1.657    27.998     0.200
     1.783    29.018     0.200
     2.007    33.818     0.200
     2.064    34.478     0.200
     2.296    36.948     0.200
     2.293    38.488     0.200
     2.311    37.028     0.200
     2.788    44.128     0.200
     3.135    50.248     0.200
     3.130    49.638     0.200
     3.197    49.768     0.200
     3.255    51.688     0.200
     4.187    61.558     0.200
     4.800    70.788     0.200
     4.803    73.288     0.200
    20.105   274.488     0.200
     1.598    28.852     0.200
     1.613    29.820     0.200
     2.020    34.531     0.200
     2.278    38.242     0.200
     2.362    40.410     0.200
     2.688    44.980     0.200
     2.793    45.504     0.200
     3.156    52.773     0.200
     3.242    54.121     0.200
     3.284    55.938     0.200
     3.284    54.320     0.200
     3.734    56.883     0.200
     3.792    60.051     0.200
     4.178    64.043     0.200
     4.213    64.453     0.200
     4.301    66.102     0.200
     4.768    74.531     0.200
     4.740    71.453     0.200
     8.750   127.730     0.200
     9.753   142.660     0.200
    12.145   172.434     0.200
    13.668   199.133     0.200
    13.996   199.754     0.200
    15.210   217.422     0.200
    15.557   222.754     0.200
    16.127   229.344     0.200
    18.632   260.184     0.200
    18.807   263.633     0.200
    19.654   274.832     0.200
    19.759   272.832     0.200
    20.106   276.332     0.200
    20.106   276.730     0.200
     1.679    29.363     0.200
     1.810    29.906     0.200
     2.031    34.273     0.200
     2.279    39.773     0.200
     2.475    40.074     0.200
     2.832    44.793     0.200
     3.097    49.625     0.200
     3.178    51.863     0.200
     3.186    50.145     0.200
     3.295    51.223     0.200
     3.545    58.945     0.200
     3.813    59.496     0.200
     4.337    66.105     0.200
     4.765    75.543     0.200
     4.789    72.523     0.200
     8.825   130.316     0.200
    11.125   160.684     0.200
    17.120   239.004     0.200
    18.950   263.613     0.200
     1.658    28.914     0.200
     1.767    30.953     0.200
     2.096    35.383     0.200
     2.224    37.375     0.200
     2.261    38.039     0.200
     2.651    44.023     0.200
     4.845    75.555     0.200
     1.535    26.832     0.200
     1.534    27.322     0.200
     1.666    28.032     0.200
     2.147    34.412     0.200
     2.136    35.812     0.200
     2.578    42.172     0.200
     2.650    43.763     0.200
     3.018    49.103     0.200
     3.153    46.402     0.200
     4.895    74.532     0.200
    19.964   273.853     0.200
     1.490    25.535     0.200
     1.522    27.125     0.200
     1.730    28.164     0.200
     2.133    35.215     0.200
     2.145    34.125     0.200
     2.192    36.422     0.200
     2.594    42.242     0.200
     2.624    42.652     0.200
     3.104    47.215     0.200
     3.713    56.262     0.200
     3.953    60.895     0.200
     4.033    63.582     0.200
     4.946    74.082     0.200
     8.741   130.004     0.200
     9.573   139.824     0.200
    10.919   156.203     0.200
    13.733   195.785     0.200
    13.786   194.625     0.200
    14.966   211.324     0.200
    15.032   211.164     0.200
    19.022   266.973     0.200
    19.487   269.523     0.200
     1.384    23.695     0.200
     1.666    27.398     0.200
     1.647    28.773     0.200
     1.640    26.422     0.200
     2.003    30.875     0.200
     2.044    33.484     0.200
     2.306    36.141     0.200
     2.276    38.992     0.200
     2.727    42.695     0.200
     2.803    44.578     0.200
     2.861    44.320     0.200
     3.153    50.945     0.200
     3.232    51.305     0.200
     3.274    53.375     0.200
     3.707    56.430     0.200
     3.822    58.570     0.200
     4.206    62.430     0.200
     4.186    63.281     0.200
     4.783    74.016     0.200
     8.800   128.195     0.200
     9.405   136.125     0.200
     9.749   140.125     0.200
     9.749   139.383     0.200
     9.751   141.125     0.200
    10.526   149.820     0.200
    11.094   162.219     0.200
    11.094   159.414     0.200
    11.160   162.523     0.200
    12.150   169.625     0.200
    12.949   182.695     0.200
    13.516   189.719     0.200
    13.695   196.422     0.200
    14.045   199.922     0.200
    14.045   199.633     0.200
    14.220   201.719     0.200
    15.194   212.820     0.200
    15.194   214.414     0.200
    15.583   220.617     0.200
    16.317   227.922     0.200
    16.468   231.523     0.200
    18.650   258.422     0.200
    18.650   257.352     0.200
    18.947   263.125     0.200
    19.666   270.922     0.200
    19.666   268.742     0.200
    19.788   272.219     0.200
    20.008   273.219     0.200
    20.084   275.125     0.200
    20.120   273.648     0.200
    20.120   273.820     0.200
    20.117   277.320     0.200
    20.299   278.320     0.200
    20.463   279.719     0.200
    20.613   283.023     0.200
    20.675   280.023     0.200
    20.767   281.820     0.200
    20.771   281.523     0.200
    20.909   284.023     0.200
     1.644    26.756     0.200
     1.868    31.824     0.200
     2.001    34.395     0.200
     2.600    42.676     0.200
     3.079    48.836     0.200
     4.795    73.785     0.200
     1.463    26.805     0.200
     1.551    26.246     0.200
     1.568    28.023     0.200
     1.620    27.176     0.200
     2.126    34.066     0.200
     2.107    35.625     0.200
     2.245    39.727     0.200
     2.543    41.805     0.200
     2.649    42.945     0.200
     3.032    50.055     0.200
     3.856    62.316     0.200
     4.872    74.645     0.200
     1.491    26.691     0.200
     1.555    25.434     0.200
     1.536    26.691     0.200
     1.677    27.625     0.200
     2.106    34.531     0.200
     2.128    35.434     0.200
     2.188    35.383     0.200
     2.621    42.164     0.200
     2.682    43.543     0.200
     3.041    50.312     0.200
     4.881    75.234     0.200
     1.500    26.547     0.200
     1.534    26.707     0.200
     1.609    26.837     0.200
     1.606    28.157     0.200
     2.119    34.058     0.200
     2.063    34.577     0.200
     2.198    34.537     0.200
     2.235    38.647     0.200
     2.611    43.808     0.200
     2.718    42.997     0.200
     3.092    49.787     0.200
     3.822    60.107     0.200
     4.735    69.737     0.200
     4.820    73.348     0.200
     1.668    28.769     0.200
     1.646    27.618     0.200
     1.993    33.108     0.200
     2.046    34.719     0.200
     2.314    37.329     0.200
     2.736    44.858     0.200
     2.808    46.219     0.200
     3.155    52.238     0.200
     3.826    61.749     0.200
     4.784    73.999     0.200
    18.954   264.898     0.200
     1.659    27.660     0.200
     2.066    34.730     0.200
     2.311    40.520     0.200
     2.808    44.918     0.200
     3.263    51.008     0.200
    14.008   200.418     0.200
    18.983   265.809     0.200
    18.983   264.168     0.200
    19.672   270.449     0.200
    20.933   284.887     0.200
     1.496    26.895     0.200
     1.531    26.703     0.200
     1.556    26.844     0.200
     1.671    27.414     0.200
     2.111    34.516     0.200
     2.125    35.133     0.200
     2.184    35.594     0.200
     2.300    39.316     0.200
     3.042    49.184     0.200
     3.171    52.523     0.200
     3.171    50.445     0.200
     3.657    57.035     0.200
     4.099    62.227     0.200
    12.031   171.156     0.200
    12.856   184.406     0.200
    13.573   196.453     0.200
    13.723   195.566     0.200
    15.100   215.055     0.200
    15.100   213.574     0.200
    15.460   219.199     0.200
    15.460   216.395     0.200
    16.523   232.055     0.200
    18.701   261.453     0.200
    18.968   264.543     0.200
    19.996   273.453     0.200
    20.239   279.953     0.200
    20.682   282.355     0.200
    20.792   286.355     0.200
     1.515    27.395     0.200
     1.511    27.504     0.200
     1.529    25.984     0.200
     1.691    27.613     0.200
     2.150    36.004     0.200
     2.125    34.852     0.200
     2.164    34.402     0.200
     2.319    40.324     0.200
     2.656    43.172     0.200
     3.015    50.555     0.200
     3.145    50.875     0.200
     3.145    52.602     0.200
    13.750   194.164     0.200
    14.149   201.004     0.200
    14.930   211.812     0.200
     1.635    27.299     0.200
     1.883    29.998     0.200
     1.943    32.838     0.200
     1.953    35.078     0.200
     2.025    34.549     0.200
     2.559    41.559     0.200
     3.056    48.969     0.200
    20.397   279.668     0.200
     1.550    25.020     0.200
     1.543    26.699     0.200
     2.115    35.621     0.200
     2.658    42.383     0.200
     2.819    44.902     0.200
     3.033    49.500     0.200
     3.171    52.516     0.200
     3.547    55.090     0.200
     5.194    80.961     0.200
     6.330    95.512     0.200
     8.677   126.781     0.200
     9.256   137.512     0.200
     9.631   138.512     0.200
     9.631   138.109     0.200
     9.592   142.910     0.200
    10.363   148.410     0.200
    10.939   158.910     0.200
    11.001   160.812     0.200
    12.013   169.312     0.200
    12.862   182.859     0.200
    13.386   188.410     0.200
    13.534   195.109     0.200
    14.008   197.910     0.200
    13.911   198.930     0.200
    15.104   213.609     0.200
    16.265   228.512     0.200
    18.496   258.609     0.200
    18.749   259.109     0.200
    19.518   268.711     0.200
    19.626   269.609     0.200
    19.614   269.312     0.200
    19.846   271.512     0.200
    19.970   273.312     0.200
    20.261   277.012     0.200
    20.630   280.910     0.200
    20.747   283.109     0.200
    20.923   284.410     0.200
     1.680    28.102     0.200
     2.031    33.914     0.200
     2.817    45.375     0.200
     3.167    51.586     0.200
     4.769    76.406     0.200
     1.528    25.391     0.200
     2.107    35.102     0.200
     2.571    41.641     0.200
     2.993    46.361     0.200
     1.444    25.969     0.200
     1.637    28.582     0.200
     2.005    34.320     0.200
     2.697    43.219     0.200
     3.109    50.430     0.200
    19.993   274.020     0.200
     1.469    25.771     0.200
     1.553    24.973     0.200
     1.622    27.363     0.200
     1.791    29.863     0.200
     2.131    34.762     0.200
     2.106    34.812     0.200
     2.226    35.953     0.200
     2.179    35.943     0.200
     2.247    38.482     0.200
     2.653    42.352     0.200
     2.676    41.633     0.200
     3.034    47.783     0.200
     3.176    51.152     0.200
     3.176    49.783     0.200
     3.171    50.213     0.200
     3.378    53.092     0.200
     3.856    60.402     0.200
     4.296    65.633     0.200
    10.929   157.012     0.200
    12.010   167.533     0.200
    15.111   212.262     0.200
    18.912   262.432     0.200
    18.912   262.312     0.200
    19.612   268.533     0.200
    20.730   282.932     0.200
     1.483    27.094     0.200
     1.574    27.164     0.200
     1.601    26.008     0.200
     1.840    30.492     0.200
     2.056    35.016     0.200
     2.175    35.516     0.200
     2.153    35.094     0.200
     2.274    36.953     0.200
     2.650    42.258     0.200
     3.095    48.953     0.200
     3.121    49.352     0.200
     3.080    48.742     0.200
     3.224    52.414     0.200
     3.224    51.836     0.200
     3.418    53.062     0.200
     3.656    55.312     0.200
     3.691    59.617     0.200
     3.805    60.047     0.200
     4.113    63.492     0.200
     4.144    63.133     0.200
     4.696    70.016     0.200
     4.822    74.711     0.200
     5.136    83.000     0.200
     8.636   125.672     0.200
     9.284   137.188     0.200
     9.678   139.445     0.200
    13.875   198.141     0.200
    18.866   263.586     0.200
    18.866   262.742     0.200
    19.851   274.086     0.200
    20.744   282.664     0.200
     1.692    28.852     0.200
     1.696    29.281     0.200
     1.759    27.578     0.200
     2.078    34.781     0.200
     2.319    37.742     0.200
     2.342    37.320     0.200
     2.479    40.336     0.200
     2.816    44.453     0.200
     3.149    50.852     0.200
     3.144    49.281     0.200
     1.583    27.199     0.200
     1.584    26.699     0.200
     1.830    30.551     0.200
     2.071    35.172     0.200
     2.138    35.371     0.200
     2.258    37.262     0.200
     2.674    42.891     0.200
     2.666    41.031     0.200
     3.063    50.699     0.200
     1.665    27.137     0.200
     1.660    29.195     0.200
     1.654    28.305     0.200
     1.792    30.016     0.200
     1.988    33.688     0.200
     2.051    34.547     0.200
     2.329    38.285     0.200
     2.317    37.188     0.200
     2.290    39.695     0.200
     2.498    40.496     0.200
     2.808    44.617     0.200
     3.153    49.688     0.200
     3.117    49.867     0.200
     3.196    50.188     0.200
     3.271    53.996     0.200
     3.271    51.766     0.200
     3.832    60.617     0.200
     4.788    74.207     0.200
    18.962   264.215     0.200
     1.547    26.719     0.200
     1.819    31.996     0.200
     1.868    32.168     0.200
     1.873    31.680     0.200
     1.872    32.039     0.200
     1.956    33.059     0.200
     2.189    38.578     0.200
     2.494    39.598     0.200
     2.535    42.637     0.200
     3.012    48.648     0.200
     3.361    53.906     0.200
     8.866   130.316     0.200
    15.430   219.316     0.200
    18.855   262.859     0.200
     1.634    29.344     0.200
     1.788    29.906     0.200
     2.075    35.555     0.200
     2.147    36.938     0.200
     2.191    37.180     0.200
     2.418    41.375     0.200
     2.646    42.164     0.200
     2.642    43.664     0.200
     2.973    50.523     0.200
     3.089    49.094     0.200
     3.292    52.148     0.200
    15.458   218.188     0.200
     1.528    25.971     0.200
     1.577    27.191     0.200
     1.837    31.631     0.200
     2.033    32.732     0.200
     2.111    35.551     0.200
     2.205    36.752     0.200
     2.588    42.301     0.200
     2.998    50.271     0.200
    13.771   194.631     0.200
    13.788   200.762     0.200
    14.982   212.252     0.200
     1.434    24.449     0.200
     1.585    26.910     0.200
     1.562    24.809     0.200
     1.827    30.680     0.200
     2.102    34.078     0.200
     2.221    36.719     0.200
     2.237    36.430     0.200
     2.509    41.070     0.200
     2.643    42.238     0.200
     3.038    49.699     0.200
     3.187    50.090     0.200
     4.105    64.371     0.200
     8.602   124.648     0.200
    10.910   157.449     0.200
    13.740   192.531     0.200
    17.347   241.508     0.200
    19.165   263.988     0.200
    19.498   267.379     0.200
    20.694   281.020     0.200
     1.398    24.275     0.200
     1.610    26.105     0.200
     1.883    30.235     0.200
     2.044    34.415     0.200
     2.548    40.325     0.200
     2.546    40.955     0.200
     3.036    47.885     0.200
     3.703    59.465     0.200
     1.652    27.151     0.200
     1.795    30.301     0.200
     1.929    31.631     0.200
     2.084    33.911     0.200
     2.328    37.421     0.200
     2.595    42.531     0.200
     4.165    65.291     0.200
     1.637    28.467     0.200
     1.826    29.877     0.200
     2.096    34.166     0.200
     2.312    37.936     0.200
     2.559    42.717     0.200
     2.571    42.105     0.200
     3.057    50.496     0.200
    18.571   260.537     0.200
     1.699    28.104     0.200
     1.653    29.113     0.200
     1.950    33.174     0.200
     2.032    34.844     0.200
     2.847    45.443     0.200
     3.097    50.443     0.200
     3.187    50.084     0.200
     3.301    53.260     0.200
     3.301    53.154     0.200
     4.761    75.564     0.200
     1.456    25.789     0.200
     1.449    25.180     0.200
     1.570    25.779     0.200
     1.585    27.748     0.200
     2.117    34.789     0.200
     2.081    35.119     0.200
     2.245    36.828     0.200
     2.655    42.818     0.200
     3.048    48.350     0.200
     4.850    75.209     0.200
    18.872   263.389     0.200
     1.694    28.340     0.200
     1.701    28.641     0.200
     1.738    30.090     0.200
     2.062    35.043     0.200
     2.351    39.223     0.200
     2.341    40.730     0.200
     2.388    38.441     0.200
     2.858    46.051     0.200
     3.183    51.812     0.200
     1.529    25.562     0.200
     1.574    27.578     0.200
     1.679    28.227     0.200
     1.746    28.664     0.200
     2.192    36.477     0.200
     2.213    37.047     0.200
     2.178    36.453     0.200
     2.679    43.523     0.200
     2.615    40.781     0.200
     3.017    47.688     0.200
     3.135    48.930     0.200
     3.135    48.281     0.200
     3.245    50.227     0.200
     3.276    50.492     0.200
     3.578    56.531     0.200
     4.068    62.953     0.200
     4.453    67.281     0.200
     4.878    72.531     0.200
     8.420   123.523     0.200
     8.804   128.055     0.200
     9.611   135.492     0.200
    13.743   195.375     0.200
    19.046   265.195     0.200
     1.747    30.653     0.200
     2.118    36.144     0.200
     2.101    35.493     0.200
     2.578    42.464     0.200
     2.724    44.764     0.200
    19.441   268.073     0.200
     1.596    27.074     0.200
     1.695    27.461     0.200
     1.750    30.262     0.200
     2.304    36.871     0.200
     2.144    36.594     0.200
     2.386    41.832     0.200
     2.528    40.832     0.200
     2.761    45.332     0.200
     1.440    25.168     0.200
     1.549    26.049     0.200
     1.606    28.268     0.200
     1.806    30.768     0.200
     2.106    35.338     0.200
     2.103    35.258     0.200
     2.223    36.758     0.200
     2.638    42.539     0.200
     2.700    41.539     0.200
     3.027    48.379     0.200
     3.129    49.828     0.200
     3.120    49.277     0.200
     3.167    51.229     0.200
     3.365    55.289     0.200
     3.708    57.588     0.200
     3.847    60.928     0.200
     4.093    62.678     0.200
     5.337    82.338     0.200
    15.385   217.053     0.200
    15.385   218.418     0.200
    16.471   230.908     0.200
    19.494   269.219     0.200
     1.591    28.200     0.200
     1.663    28.391     0.200
     1.770    31.030     0.200
     2.202    36.761     0.200
     2.184    36.471     0.200
     2.251    37.570     0.200
     2.584    40.920     0.200
     3.304    52.110     0.200
     1.508    26.871     0.200
     1.613    28.160     0.200
     2.240    36.270     0.200
     2.225    37.641     0.200
     2.997    48.699     0.200
     3.105    49.250     0.200
     3.385    53.281     0.200
     3.659    55.652     0.200
     9.589   139.133     0.200
    10.990   157.902     0.200
    14.095   200.102     0.200
    14.155   201.641     0.200
    15.018   210.312     0.200
     1.446    25.375     0.200
     1.542    26.395     0.200
     1.592    26.984     0.200
     1.635    27.707     0.200
     1.785    29.965     0.200
     2.087    35.637     0.200
     2.201    36.496     0.200
     2.609    42.766     0.200
     2.710    43.484     0.200
     3.076    50.297     0.200
     3.208    52.941     0.200
     3.208    50.625     0.200
     3.431    54.996     0.200
     3.664    57.887     0.200
     4.135    63.547     0.200
     8.718   125.375     0.200
    10.994   157.125     0.200
    13.956   197.887     0.200
     1.808    31.848     0.200
     1.610    28.566     0.200
     2.072    35.758     0.200
     2.239    39.938     0.200
     2.623    41.738     0.200
     2.705    43.789     0.200
     3.080    50.668     0.200
     3.216    52.453     0.200
     3.428    57.086     0.200
     4.141    63.359     0.200
     4.831    77.488     0.200
    20.015   276.207     0.200
     1.559    26.336     0.200
     1.620    27.465     0.200
     1.793    30.016     0.200
     2.137    35.766     0.200
     2.232    37.383     0.200
     2.102    35.105     0.200
     2.246    39.043     0.200
     2.659    43.145     0.200
     2.670    43.805     0.200
     3.040    50.223     0.200
     3.139    49.664     0.200
     3.852    60.684     0.200
     4.740    70.305     0.200
     4.865    74.812     0.200
    19.969   273.324     0.200
     1.486    25.852     0.200
     1.640    28.156     0.200
     1.642    27.445     0.200
     2.058    34.367     0.200
     2.275    39.242     0.200
     2.275    37.203     0.200
     2.308    37.867     0.200
     2.536    42.688     0.200
     2.775    44.523     0.200
     3.124    50.367     0.200
     3.129    51.242     0.200
     3.178    50.227     0.200
     3.562    58.086     0.200
     3.832    62.727     0.200
     4.184    64.094     0.200
     1.400    24.279     0.200
     1.499    25.988     0.200
     1.625    27.998     0.200
     2.160    34.889     0.200
     2.242    36.889     0.200
     2.648    41.908     0.200
     2.677    42.818     0.200
     3.053    48.328     0.200
     3.148    48.309     0.200
     3.162    49.578     0.200
     4.114    63.738     0.200
    19.988   272.518     0.200
     1.559    27.072     0.200
     1.523    25.803     0.200
     1.638    28.943     0.200
     2.195    34.422     0.200
     2.310    37.422     0.200
     2.608    42.053     0.200
     3.090    49.893     0.200
     3.118    50.863     0.200
     3.259    53.553     0.200
     3.259    52.223     0.200
     4.181    66.273     0.200
     7.250   108.812     0.200
    13.216   187.023     0.200
    20.782   285.703     0.200
     1.434    24.445     0.200
     1.480    25.781     0.200
     1.382    22.977     0.200
     1.597    26.914     0.200
     2.146    33.906     0.200
     2.253    35.875     0.200
     2.659    44.266     0.200
     3.203    51.352     0.200
     3.203    48.258     0.200
     3.143    50.102     0.200
     3.402    53.867     0.200
     4.124    63.297     0.200
     4.718    70.211     0.200
     8.647   123.359     0.200
     9.659   138.258     0.200
    10.949   153.664     0.200
    13.713   192.758     0.200
    13.884   193.898     0.200
    14.508   202.328     0.200
    14.900   210.977     0.200
    15.139   211.391     0.200
    17.305   239.305     0.200
    18.791   259.156     0.200
    19.845   272.156     0.200
    19.962   275.156     0.200
    19.984   272.648     0.200
    19.984   273.359     0.200
    20.741   281.555     0.200
     1.585    25.184     0.200
     1.352    23.332     0.200
     1.574    26.953     0.200
     2.090    33.461     0.200
     2.128    34.742     0.200
     2.259    36.711     0.200
     2.199    36.434     0.200
     2.199    37.613     0.200
     3.210    50.883     0.200
     3.132    50.223     0.200
     4.287    65.633     0.200
     4.836    73.703     0.200
     7.196   106.801     0.200
    14.118   202.262     0.200
    19.525   267.672     0.200
     1.608    27.281     0.200
     1.588    26.938     0.200
     2.040    34.031     0.200
     2.169    35.266     0.200
     2.260    37.406     0.200
     3.070    50.977     0.200
     3.416    53.805     0.200
     3.671    59.008     0.200
     4.132    63.773     0.200
     1.618    27.773     0.200
     1.693    27.551     0.200
     1.918    30.781     0.200
     2.368    38.523     0.200
     2.492    39.082     0.200
     3.358    53.641     0.200
     1.486    26.132     0.200
     2.040    34.142     0.200
     2.220    37.702     0.200
     2.276    38.072     0.200
     3.061    51.182     0.200
     4.135    66.012     0.200
     7.060   107.752     0.200
    18.754   264.252     0.200
    19.917   273.702     0.200
     1.612    26.980     0.200
     1.563    27.191     0.200
     1.919    31.828     0.200
     2.289    37.449     0.200
     2.379    37.711     0.200
     3.046    49.410     0.200
     3.241    49.375     0.200
     6.880   104.410     0.200
     1.513    26.637     0.200
     1.533    26.855     0.200
     1.739    29.656     0.200
     1.908    31.027     0.200
     2.178    37.367     0.200
     2.186    35.695     0.200
     3.371    51.738     0.200
     3.570    55.527     0.200
     4.931    76.566     0.200
     1.521    26.663     0.200
     1.641    29.113     0.200
     1.668    28.593     0.200
     1.773    30.353     0.200
     1.773    30.633     0.200
     2.305    38.283     0.200
     2.305    38.683     0.200
     2.297    37.323     0.200
     3.129    52.922     0.200
     3.208    50.783     0.200
     3.500    53.933     0.200
     3.500    54.353     0.200
     3.688    57.873     0.200
     3.851    60.723     0.200
     4.105    65.232     0.200
     4.181    65.493     0.200
     4.181    65.633     0.200
     4.368    67.353     0.200
     4.478    68.263     0.200
     4.811    74.763     0.200
     4.811    72.383     0.200
     6.221    94.212     0.200
     7.398   110.603     0.200
     8.813   129.643     0.200
     9.396   136.692     0.200
     9.472   139.172     0.200
     9.724   140.792     0.200
    11.079   163.292     0.200
    12.128   172.393     0.200
    13.493   190.493     0.200
    13.685   198.493     0.200
    14.054   201.522     0.200
    14.888   213.692     0.200
    15.166   214.843     0.200
    15.166   211.993     0.200
    15.572   219.343     0.200
    18.635   261.172     0.200
    18.811   263.792     0.200
    19.243   265.792     0.200
    19.771   274.692     0.200
    19.999   275.292     0.200
    20.078   276.093     0.200
    20.102   276.843     0.200
    20.102   275.792     0.200
    20.278   278.593     0.200
    20.904   285.683     0.200
    20.904   286.093     0.200
     1.521    25.693     0.200
     1.415    24.062     0.200
     1.694    27.924     0.200
     2.281    36.643     0.200
     2.378    38.164     0.200
     2.385    38.732     0.200
     2.714    42.033     0.200
     2.919    45.084     0.200
     3.132    48.553     0.200
     3.344    49.943     0.200
     5.704    84.652     0.200
     5.815    86.914     0.200
     7.756   113.902     0.200
     8.879   127.033     0.200
     8.879   128.053     0.200
     8.954   129.254     0.200
     9.254   135.084     0.200
    10.632   149.943     0.200
    11.929   167.979     0.200
    14.182   198.803     0.200
    14.453   205.963     0.200
    14.528   204.043     0.200
    15.278   214.424     0.200
    16.493   230.873     0.200
    16.669   230.354     0.200
    17.576   244.014     0.200
    18.147   248.674     0.200
    19.055   260.652     0.200
    19.537   268.254     0.200
     1.551    26.875     0.200
     1.970    33.172     0.200
     2.184    36.336     0.200
     2.184    37.062     0.200
     2.129    36.055     0.200
     2.173    37.609     0.200
     2.600    42.062     0.200
     3.137    47.555     0.200
     4.658    74.555     0.200
     5.341    82.156     0.200
    19.835   272.609     0.200
     1.194    21.047     0.200
     1.907    30.137     0.200
     2.317    38.785     0.200
     2.557    40.836     0.200
     2.556    41.297     0.200
     5.349    78.434     0.200
     7.748   114.496     0.200
     8.346   124.195     0.200
     8.487   121.695     0.200
     8.488   121.926     0.200
    10.197   148.195     0.200
    12.348   176.395     0.200
    12.510   180.594     0.200
    12.709   184.195     0.200
    13.298   190.395     0.200
    13.388   192.195     0.200
    13.480   193.297     0.200
    13.432   192.996     0.200
    13.923   198.395     0.200
    14.604   207.594     0.200
    14.806   209.695     0.200
    15.124   213.695     0.200
    15.310   216.395     0.200
    18.118   252.207     0.200
    18.646   257.094     0.200
    18.774   258.594     0.200
    19.082   261.195     0.200
    19.232   263.520     0.200
    19.232   264.094     0.200
    19.906   270.766     0.200
    20.167   275.195     0.200
    20.562   279.297     0.200
     1.788    29.320     0.200
     2.321    36.414     0.200
     2.573    43.086     0.200
     2.608    41.531     0.200
     2.814    43.766     0.200
     2.866    46.523     0.200
     2.866    46.055     0.200
     7.658   113.211     0.200
     9.370   133.492     0.200
    12.475   176.156     0.200
    19.513   268.086     0.200
     1.419    24.838     0.200
     1.639    28.928     0.200
     2.022    33.678     0.200
     2.140    35.549     0.200
     2.140    36.318     0.200
     2.117    35.078     0.200
     2.219    37.039     0.200
     2.654    42.629     0.200
     2.819    45.107     0.200
     3.030    49.578     0.200
     1.361    24.680     0.200
     1.473    25.488     0.200
     1.577    27.598     0.200
     1.837    31.047     0.200
     2.063    35.238     0.200
     2.081    34.367     0.200
     2.184    36.430     0.200
     2.143    35.848     0.200
     2.266    37.199     0.200
     2.681    42.910     0.200
     2.880    46.227     0.200
     1.499    26.669     0.200
     1.542    25.469     0.200
     1.572    27.469     0.200
     1.840    31.938     0.200
     2.052    34.219     0.200
     2.127    35.358     0.200
     2.099    35.398     0.200
     2.218    36.749     0.200
     2.606    42.339     0.200
     2.873    46.119     0.200
     3.013    46.309     0.200
     4.083    65.818     0.200
     4.875    74.339     0.200
     1.546    25.898     0.200
     1.704    29.000     0.200
     1.824    31.000     0.200
     1.930    32.039     0.200
     2.262    37.191     0.200
     2.445    40.141     0.200
     2.924    46.980     0.200
     3.276    51.840     0.200
     3.385    52.039     0.200
     1.499    26.203     0.200
     1.650    26.463     0.200
     2.132    35.133     0.200
     2.219    36.913     0.200
     2.237    37.873     0.200
     2.466    41.933     0.200
     2.643    43.883     0.200
     1.663    27.953     0.200
     1.668    28.609     0.200
     1.665    29.570     0.200
     2.059    36.180     0.200
     2.323    40.133     0.200
     2.842    47.445     0.200
     3.151    52.320     0.200
     1.336    22.676     0.200
     1.630    27.359     0.200
     1.625    26.656     0.200
     1.808    30.789     0.200
     2.036    34.020     0.200
     2.449    39.027     0.200
     2.452    40.246     0.200
     2.553    41.270     0.200
     2.693    43.238     0.200
     2.776    44.559     0.200
     2.907    45.156     0.200
     3.035    47.770     0.200
     3.241    52.129     0.200
     3.517    55.797     0.200
     3.853    59.688     0.200
     3.804    58.848     0.200
     5.174    79.449     0.200
     5.661    85.379     0.200
     7.480   109.617     0.200
     8.982   129.906     0.200
     9.401   134.637     0.200
    13.313   184.949     0.200
    13.937   197.227     0.200
    14.804   207.418     0.200
    19.408   266.008     0.200
     1.436    24.734     0.200
     1.466    25.383     0.200
     1.569    25.992     0.200
     1.600    27.613     0.200
     2.063    34.734     0.200
     2.087    35.215     0.200
     2.132    35.402     0.200
     2.132    35.953     0.200
     2.662    43.305     0.200
     2.855    45.992     0.200
     3.049    50.242     0.200
     3.166    50.812     0.200
     1.439    24.758     0.200
     1.471    24.938     0.200
     1.577    25.898     0.200
     1.564    26.867     0.200
     1.594    27.891     0.200
     2.066    34.379     0.200
     2.080    34.938     0.200
     2.137    35.848     0.200
     2.183    37.590     0.200
     2.669    43.059     0.200
     2.862    46.250     0.200
     3.056    50.469     0.200
     3.173    51.070     0.200
     1.449    24.414     0.200
     1.465    25.484     0.200
     1.579    25.734     0.200
     1.572    27.797     0.200
     1.826    30.977     0.200
     2.076    34.836     0.200
     2.076    35.281     0.200
     2.253    37.586     0.200
     2.476    41.422     0.200
     2.540    42.258     0.200
     2.668    43.164     0.200
     2.637    43.953     0.200
     2.869    45.922     0.200
     3.058    49.492     0.200
     3.203    50.258     0.200
     1.445    25.523     0.200
     1.505    26.891     0.200
     1.524    26.512     0.200
     1.572    26.684     0.200
     1.773    30.332     0.200
     2.103    35.371     0.200
     2.122    36.004     0.200
     2.230    38.332     0.200
     2.242    37.691     0.200
     2.464    41.711     0.200
     2.689    43.582     0.200
     2.822    45.113     0.200
     3.138    50.523     0.200
     3.169    50.844     0.200
     1.942    33.523     0.200
     2.156    37.500     0.200
     2.176    36.859     0.200
     2.749    45.422     0.200
     4.929    78.789     0.200
     1.278    21.508     0.200
     1.650    27.357     0.200
     1.565    27.488     0.200
     1.818    30.559     0.200
     2.201    35.639     0.200
     2.327    38.047     0.200
     2.330    36.578     0.200
     2.419    39.838     0.200
     2.426    39.127     0.200
     2.643    42.979     0.200
     2.734    43.627     0.200
     2.703    43.037     0.200
     3.255    50.309     0.200
     3.367    52.047     0.200
     3.578    56.848     0.200
     3.683    58.148     0.200
     3.976    60.848     0.200
     4.024    61.678     0.200
     4.466    68.068     0.200
     5.579    83.367     0.200
     5.885    89.867     0.200
     1.435    25.406     0.200
     1.442    25.986     0.200
     1.546    25.806     0.200
     1.590    28.026     0.200
     1.611    28.046     0.200
     2.063    34.626     0.200
     2.107    34.646     0.200
     2.107    35.976     0.200
     2.841    45.906     0.200
     1.395    24.086     0.200
     1.528    27.066     0.200
     1.814    30.316     0.200
     2.296    36.555     0.200
     2.240    37.336     0.200
     2.352    39.105     0.200
     2.599    42.715     0.200
     2.706    40.914     0.200
     2.706    41.688     0.200
     2.706    43.117     0.200
     2.706    40.516     0.200
     2.706    41.828     0.200
     5.865    88.094     0.200
     6.023    86.617     0.200
     7.829   112.898     0.200
     8.323   117.492     0.200
     9.138   129.625     0.200
     9.209   128.797     0.200
     9.209   132.117     0.200
     9.209   129.414     0.200
     9.395   134.219     0.200
     9.507   132.656     0.200
     9.661   140.414     0.200
     9.661   141.344     0.200
    10.911   152.148     0.200
    10.911   157.617     0.200
    10.911   154.812     0.200
    10.911   158.875     0.200
    11.739   161.328     0.200
    12.247   171.219     0.200
    13.051   179.219     0.200
    13.051   179.594     0.200
    13.572   188.617     0.200
    13.572   191.375     0.200
    13.542   186.414     0.200
    13.540   193.617     0.200
    13.545   189.742     0.200
    13.675   192.312     0.200
    14.122   196.844     0.200
    14.122   200.719     0.200
    14.453   200.812     0.200
    14.453   204.148     0.200
    14.509   199.992     0.200
    14.500   203.016     0.200
    14.571   204.555     0.200
    14.725   205.539     0.200
    14.985   210.117     0.200
    15.251   214.914     0.200
    15.520   216.219     0.200
    15.529   216.117     0.200
    16.092   222.719     0.200
    16.092   222.844     0.200
    17.306   237.883     0.200
    17.306   238.812     0.200
    18.436   254.016     0.200
    19.361   263.117     0.200
    19.477   263.812     0.200
     1.507    26.453     0.200
     1.718    29.734     0.200
     2.484    40.562     0.200
     2.535    41.742     0.200
     2.671    44.723     0.200
     2.795    45.484     0.200
     1.416    24.162     0.200
     1.486    25.113     0.200
     1.565    25.682     0.200
     1.623    28.062     0.200
     1.700    27.393     0.200
     1.690    29.033     0.200
     1.844    30.992     0.200
     2.088    34.332     0.200
     2.114    34.592     0.200
     2.242    37.162     0.200
     2.241    36.803     0.200
     2.283    38.703     0.200
     2.334    37.432     0.200
     2.635    43.662     0.200
     2.638    42.592     0.200
     2.699    44.322     0.200
     2.748    45.193     0.200
     2.881    45.832     0.200
     3.039    47.832     0.200
     3.147    49.992     0.200
     3.192    50.406     0.200
     3.186    50.672     0.200
     4.107    64.123     0.200
    15.133   213.643     0.200
     1.390    23.316     0.200
     1.424    25.086     0.200
     1.487    25.727     0.200
     1.550    25.078     0.200
     1.588    27.617     0.200
     1.728    27.918     0.200
     1.773    29.867     0.200
     1.880    30.246     0.200
     2.017    33.809     0.200
     2.159    36.348     0.200
     2.145    35.148     0.200
     2.225    37.559     0.200
     2.222    36.617     0.200
     2.253    36.117     0.200
     2.492    39.066     0.200
     2.658    44.176     0.200
     2.672    44.027     0.200
     2.664    42.418     0.200
     2.658    42.477     0.200
     2.681    44.809     0.200
     2.818    45.977     0.200
     2.874    45.906     0.200
     3.032    48.488     0.200
     3.131    49.918     0.200
     3.170    49.090     0.200
     3.170    48.387     0.200
     3.170    52.195     0.200
     3.381    55.348     0.200
     3.632    56.887     0.200
     3.870    59.375     0.200
     4.094    66.027     0.200
     4.298    62.977     0.200
     4.353    66.488     0.200
     4.762    71.906     0.200
     5.243    78.918     0.200
     5.417    85.219     0.200
     6.330    94.695     0.200
     6.384    97.195     0.200
     7.230   106.598     0.200
     8.705   126.598     0.200
     9.016   132.098     0.200
     9.008   134.996     0.200
     9.131   136.695     0.200
     9.446   140.898     0.200
     9.633   141.297     0.200
     9.631   137.176     0.200
    10.020   144.398     0.200
    12.747   184.996     0.200
    12.988   187.996     0.200
    13.601   197.695     0.200
    13.723   199.195     0.200
    14.182   203.297     0.200
    14.526   206.535     0.200
    14.921   212.168     0.200
    16.264   227.598     0.200
    16.307   229.797     0.200
    18.453   256.797     0.200
    18.527   258.297     0.200
    18.715   260.297     0.200
    18.722   260.297     0.200
    18.866   262.496     0.200
    18.941   262.695     0.200
     1.026    18.062     0.200
     1.058    17.793     0.200
     1.134    18.043     0.200
     1.143    20.715     0.200
     1.194    21.203     0.200
     1.359    23.402     0.200
     1.367    22.633     0.200
     1.493    24.055     0.200
     1.456    25.254     0.200
     1.558    25.164     0.200
     1.480    25.703     0.200
     1.732    28.633     0.200
     1.820    29.094     0.200
     1.918    30.523     0.200
     1.921    30.883     0.200
     2.006    32.605     0.200
     1.999    32.652     0.200
     2.016    30.754     0.200
     2.118    33.395     0.200
     2.124    33.844     0.200
     2.282    34.652     0.200
     2.522    41.305     0.200
     2.630    39.723     0.200
     2.697    41.883     0.200
     2.819    44.293     0.200
     2.953    45.465     0.200
     3.362    51.734     0.200
     3.610    54.594     0.200
     3.874    59.895     0.200
     4.419    66.336     0.200
     1.281    22.133     0.200
     1.511    25.965     0.200
     1.530    26.395     0.200
     1.583    27.055     0.200
     1.680    26.902     0.200
     1.780    29.734     0.200
     1.735    26.203     0.200
     1.819    30.512     0.200
     1.981    33.094     0.200
     1.953    32.262     0.200
     2.205    35.902     0.200
     2.130    35.863     0.200
     2.200    35.402     0.200
     2.286    36.703     0.200
     2.366    37.652     0.200
     2.453    39.465     0.200
     2.435    38.852     0.200
     2.435    39.383     0.200
     2.522    40.582     0.200
     2.641    42.754     0.200
     2.729    43.625     0.200
     2.804    43.504     0.200
     3.023    48.035     0.200
     3.069    47.262     0.200
     3.335    51.672     0.200
     3.390    52.625     0.200
     3.331    50.004     0.200
     3.343    52.703     0.200
     3.597    57.395     0.200
     3.764    58.785     0.200
     3.868    57.285     0.200
     4.014    61.742     0.200
     4.554    69.633     0.200
     4.781    74.043     0.200
     5.167    77.633     0.200
     5.758    87.965     0.200
     6.238    93.945     0.200
     6.687   100.984     0.200
     7.280   107.504     0.200
     7.796   113.734     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     5.792   112.008     0.200
     4.188    78.855     0.200
     3.240    60.732     0.200
     3.548    66.727     0.200
     2.662    50.773     0.200
     4.840    87.650     0.200
     2.844    52.680     0.200
     2.585    52.199     0.200
     3.126    56.852     0.200
     3.086    57.504     0.200
     3.174    59.516     0.200
     6.335   122.133     0.200
     2.957    54.242     0.200
     3.000    56.383     0.200
     3.104    60.371     0.200
     3.026    56.266     0.200
     4.031    78.070     0.200
     3.988    78.117     0.200
     3.274    60.865     0.200
     3.233    59.499     0.200
     3.171    61.266     0.200
     3.288    63.117     0.200
     3.253    61.648     0.200
     2.640    48.805     0.200
     3.710    67.711     0.200
     3.071    58.680     0.200
     2.750    50.889     0.200
     3.151    61.023     0.200
     3.056    56.684     0.200
     3.470    64.043     0.200
     4.007    72.727     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.960    16.703     0.200
     0.917    16.902     0.200
     0.788    14.678     0.200
     0.784    14.584     0.200
     0.848    16.008     0.200
     1.059    19.508     0.200
     1.038    19.109     0.200
     2.437    44.609     0.200
     3.247    56.609     0.200
     1.079    19.932     0.200
     0.832    15.553     0.200
     1.062    19.553     0.200
     0.879    16.188     0.200
     0.848    15.789     0.200
     2.479    43.289     0.200
     3.136    54.789     0.200
     0.868    16.078     0.200
     0.936    17.078     0.200
     0.516     9.613     0.200
     1.778    31.813     0.200
     4.642    78.113     0.200
     0.999    18.594     0.200
     1.084    19.594     0.200
     0.679    11.656     0.200
     0.825    15.656     0.200
     1.110    20.656     0.200
     2.393    42.156     0.200
     3.244    55.656     0.200
     3.286    56.055     0.200
     5.520    96.656     0.200
     0.669    11.855     0.200
     0.862    15.355     0.200
     1.072    19.855     0.200
     1.323    24.855     0.200
     2.030    35.855     0.200
     0.598    10.746     0.200
     1.011    18.746     0.200
     1.041    18.846     0.200
     1.364    25.746     0.200
     2.776    46.746     0.200
     3.123    53.945     0.200
     1.244    22.732     0.200
     0.596    10.135     0.200
     0.704    13.336     0.200
     0.911    17.035     0.200
     0.936    17.535     0.200
     0.586     9.938     0.200
     0.654    12.738     0.200
     0.956    17.238     0.200
     0.989    17.637     0.200
     1.362    25.035     0.200
     0.710    13.023     0.200
     0.909    16.824     0.200
     0.922    17.426     0.200
     2.842    48.625     0.200
     0.442     8.293     0.200
     0.956    16.254     0.200
     1.190    21.074     0.200
     0.540    10.586     0.200
     0.666    12.355     0.200
     2.248    39.004     0.200
     0.292     7.314     0.200
     1.175    20.975     0.200
     1.308    22.775     0.200
     0.316     7.727     0.200
     0.831    15.137     0.200
     0.839    15.594     0.200
     1.180    21.004     0.200
     1.522    28.246     0.200
     0.171     3.783     0.200
     0.858    14.225     0.200
     0.776    14.664     0.200
     0.891    15.744     0.200
     1.085    20.113     0.200
     1.550    28.574     0.200
     1.792    32.264     0.200
     0.347     6.695     0.200
     0.842    15.836     0.200
     1.011    19.297     0.200
     1.192    21.586     0.200
     1.492    26.695     0.200
     3.162    52.969     0.200
     4.036    68.797     0.200
     5.062    87.711     0.200
     1.007    19.508     0.200
     1.016    19.461     0.200
     1.102    20.531     0.200
     1.275    23.391     0.200
     1.489    27.242     0.200
     3.934    67.555     0.200
     0.864    15.854     0.200
     0.865    16.124     0.200
     1.179    21.975     0.200
     1.312    23.984     0.200
     0.327     7.875     0.200
     0.827    15.086     0.200
     0.844    15.326     0.200
     1.192    21.465     0.200
     2.904    49.975     0.200
     0.395     8.172     0.200
     0.714    13.301     0.200
     0.753    14.199     0.200
     1.060    20.500     0.200
     1.273    21.871     0.200
     0.204     5.469     0.200
     0.539    10.219     0.200
     1.023    18.641     0.200
     1.036    18.199     0.200
     1.099    19.539     0.200
     1.262    22.469     0.200
     0.527    10.109     0.200
     1.232    22.859     0.200
     1.267    23.055     0.200
     0.235     4.859     0.200
     0.684    12.219     0.200
     0.862    15.699     0.200
     0.854    15.258     0.200
     1.299    23.078     0.200
     2.007    36.809     0.200
     0.392     8.217     0.200
     0.761    13.756     0.200
     0.797    14.877     0.200
     1.034    19.387     0.200
     1.349    23.627     0.200
     0.481    10.584     0.200
     0.654    12.224     0.200
     0.758    14.194     0.200
     0.485     9.996     0.200
     0.648    12.356     0.200
     0.752    14.406     0.200
     1.334    23.477     0.200
     0.518    10.747     0.200
     1.406    24.396     0.200
     0.262     5.434     0.200
     1.112    19.664     0.200
     1.170    21.215     0.200
     1.189    21.895     0.200
     2.892    51.375     0.200
     1.126    20.562     0.200
     3.833    69.180     0.200
     0.494     9.594     0.200
     0.648    12.145     0.200
     0.763    13.965     0.200
     1.273    23.406     0.200
     0.550    11.117     0.200
     0.711    13.246     0.200
     0.736    13.105     0.200
     1.042    17.367     0.200
     2.346    39.605     0.200
     0.353     8.062     0.200
     0.934    16.902     0.200
     1.041    18.531     0.200
     1.126    18.332     0.200
     2.708    47.039     0.200
     0.463     9.359     0.200
     0.508     9.586     0.200
     0.888    16.438     0.200
     0.943    17.219     0.200
     1.042    17.562     0.200
     2.618    43.789     0.200
     0.988    18.656     0.200
     1.008    17.686     0.200
     1.069    19.926     0.200
     1.247    22.807     0.200
     1.308    22.637     0.200
     1.492    26.506     0.200
     1.951    34.586     0.200
     2.281    39.746     0.200
     2.373    40.105     0.200
     0.488     9.430     0.200
     2.749    49.062     0.200
     2.769    49.031     0.200
     1.266    22.585     0.200
     0.293     6.197     0.200
     0.437     8.467     0.200
     0.804    14.747     0.200
     0.764    14.278     0.200
     1.132    21.258     0.200
     0.303     5.556     0.200
     0.204     4.472     0.200
     0.636    12.412     0.200
     1.237    22.672     0.200
     0.352     6.620     0.200
     0.700    12.980     0.200
     0.763    14.860     0.200
     0.745    13.516     0.200
     1.077    18.896     0.200
     1.166    21.567     0.200
     0.211     4.374     0.200
     0.468     9.044     0.200
     0.911    17.394     0.200
     0.245     4.801     0.200
     0.833    15.871     0.200
     0.938    17.296     0.200
     1.291    23.506     0.200
     2.128    36.427     0.200
     0.398     7.655     0.200
     0.740    13.905     0.200
     3.121    52.745     0.200
     0.670    12.548     0.200
     0.336     6.365     0.200
     0.725    12.896     0.200
     1.110    21.315     0.200
     1.126    20.775     0.200
     3.140    52.835     0.200
     0.344     6.153     0.200
     0.711    13.123     0.200
     1.121    21.433     0.200
     2.527    43.333     0.200
     0.362     7.521     0.200
     0.404     7.541     0.200
     1.199    22.291     0.200
     2.208    39.511     0.200
     3.153    55.210     0.200
     0.212     3.452     0.200
     0.427     8.132     0.200
     0.819    16.092     0.200
     1.025    18.731     0.200
     1.969    34.992     0.200
     0.422     8.154     0.200
     0.850    16.154     0.200
     0.981    18.204     0.200
     2.470    43.004     0.200
     0.326     7.325     0.200
     0.350     6.845     0.200
     1.004    18.645     0.200
     0.235     5.125     0.200
     0.444     8.735     0.200
     0.872    16.225     0.200
     0.931    18.145     0.200
     1.309    23.465     0.200
     0.208     4.782     0.200
     0.628    11.852     0.200
     0.213     4.922     0.200
     0.465     8.902     0.200
     0.886    16.232     0.200
     2.721    46.752     0.200
     2.721    47.292     0.200
     0.186     4.111     0.200
     0.611    11.591     0.200
     0.615    11.521     0.200
     1.211    22.581     0.200
     1.211    22.721     0.200
     1.568    27.551     0.200
     1.568    27.681     0.200
     1.927    33.511     0.200
     2.252    38.161     0.200
     3.265    55.186     0.200
     0.859    16.692     0.200
     0.942    16.932     0.200
     1.368    23.942     0.200
     3.142    53.412     0.200
     0.367     6.927     0.200
     0.403     7.887     0.200
     0.276     5.399     0.200
     0.412     7.789     0.200
     0.841    15.600     0.200
     1.267    23.239     0.200
     3.063    51.149     0.200
     3.206    56.765     0.200
     0.423     8.078     0.200
     0.861    16.038     0.200
     0.947    17.478     0.200
     1.287    23.228     0.200
     3.158    52.678     0.200
     0.375     7.260     0.200
     0.847    15.060     0.200
     0.978    18.739     0.200
     1.243    22.550     0.200
     1.243    23.020     0.200
     3.102    52.529     0.200
     0.323     6.164     0.200
     0.678    12.305     0.200
     1.070    20.484     0.200
     1.170    20.914     0.200
     2.044    35.564     0.200
     0.924    17.579     0.200
     1.330    23.559     0.200
     1.799    30.759     0.200
     0.567    11.171     0.200
     2.034    35.321     0.200
     3.002    50.681     0.200
     3.204    54.786     0.200
     0.847    15.598     0.200
     0.955    17.688     0.200
     1.288    23.268     0.200
     3.142    51.918     0.200
     3.186    53.298     0.200
     0.965    18.092     0.200
     1.375    24.521     0.200
     0.756    14.301     0.200
     3.126    53.281     0.200
     0.562    10.420     0.200
     0.734    14.020     0.200
     3.178    56.580     0.200
     3.178    54.010     0.200
     0.328     5.934     0.200
     0.683    12.934     0.200
     1.079    20.004     0.200
     0.290     5.512     0.200
     0.712    13.303     0.200
     1.070    19.393     0.200
     1.152    21.043     0.200
     1.359    24.223     0.200
     3.271    56.223     0.200
     0.587    11.541     0.200
     0.651    12.740     0.200
     0.538    10.367     0.200
     0.721    13.748     0.200
     0.460     8.855     0.200
     3.025    50.605     0.200
     0.362     6.570     0.200
     0.698    12.971     0.200
     1.125    21.080     0.200
     0.469     8.107     0.200
     1.072    20.957     0.200
     2.172    38.627     0.200
     3.087    53.277     0.200
     0.589    10.824     0.200
     0.638    12.184     0.200
     1.187    22.074     0.200
     3.220    56.344     0.200
     0.388     7.453     0.200
     0.867    15.633     0.200
     0.954    16.832     0.200
     3.194    53.363     0.200
     5.120    86.127     0.200
     0.459     8.840     0.200
     1.321    24.070     0.200
     1.606    28.512     0.200
     2.094    36.852     0.200
     2.505    42.922     0.200
     3.023    50.652     0.200
     3.171    53.055     0.200
     5.184    89.961     0.200
     0.474     8.473     0.200
     1.268    22.934     0.200
     2.181    40.602     0.200
     0.415     7.949     0.200
     0.720    13.422     0.200
     1.188    21.391     0.200
     3.142    56.852     0.200
     3.184    54.594     0.200
     6.364   109.102     0.200
     0.384     7.199     0.200
     0.682    12.520     0.200
     1.131    20.000     0.200
     1.403    25.250     0.200
     3.218    56.109     0.200
     0.530    10.211     0.200
     0.842    16.703     0.200
     1.410    26.281     0.200
     2.008    35.102     0.200
     2.182    38.754     0.200
     2.415    41.641     0.200
     0.665    12.277     0.200
     1.257    23.109     0.200
     2.304    41.270     0.200
     0.429     8.621     0.200
     0.817    15.684     0.200
     1.367    24.562     0.200
     1.430    26.113     0.200
     1.970    34.551     0.200
     3.030    51.102     0.200
     3.249    56.062     0.200
     0.425     8.137     0.200
     0.701    12.969     0.200
     1.182    20.969     0.200
     1.450    26.156     0.200
     3.201    54.578     0.200
     0.777    13.770     0.200
     1.063    19.090     0.200
     1.160    20.832     0.200
     3.142    52.852     0.200
     3.231    55.641     0.200
     0.471     9.336     0.200
     0.573    11.078     0.200
     0.668    12.438     0.200
     3.197    55.098     0.200
     0.504     9.191     0.200
     0.768    14.539     0.200
     1.017    19.281     0.200
     1.290    22.609     0.200
     3.056    55.172     0.200
     0.502     9.672     0.200
     0.809    16.020     0.200
     0.992    18.379     0.200
     1.410    25.320     0.200
     0.437     7.848     0.200
     0.654    11.668     0.200
     1.153    21.129     0.200
     1.414    25.801     0.200
     3.126    56.668     0.200
     0.383     7.199     0.200
     0.443     8.340     0.200
     0.676    12.891     0.200
     1.125    20.238     0.200
     0.358     6.461     0.200
     0.423     8.199     0.200
     0.710    13.418     0.200
     1.116    20.898     0.200
     1.411    25.180     0.200
     3.486    59.258     0.200
     0.292     6.082     0.200
     0.432     8.125     0.200
     0.808    14.984     0.200
     0.992    19.062     0.200
     1.263    22.465     0.200
     1.544    27.652     0.200
     3.133    56.344     0.200
     3.177    53.004     0.200
     0.335     6.344     0.200
     0.450     8.805     0.200
     0.698    12.984     0.200
     1.101    19.555     0.200
     1.140    21.184     0.200
     3.225    56.805     0.200
     3.267    57.043     0.200
     3.267    58.656     0.200
     0.420     8.090     0.200
     0.437     8.020     0.200
     0.674    12.352     0.200
     0.191     4.141     0.200
     0.549    10.742     0.200
     0.688    12.984     0.200
     1.253    23.297     0.200
     1.852    32.930     0.200
     0.255     5.453     0.200
     0.425     8.125     0.200
     0.858    15.977     0.200
     0.949    18.477     0.200
     1.288    23.422     0.200
     0.338     6.320     0.200
     1.154    22.352     0.200
     1.369    24.789     0.200
     3.225    55.156     0.200
     0.163     3.680     0.200
     0.572    10.828     0.200
     0.675    12.766     0.200
     2.031    35.867     0.200
     2.251    40.617     0.200
     3.262    55.156     0.200
     0.341     6.383     0.200
     0.464     8.555     0.200
     0.682    12.703     0.200
     1.091    19.516     0.200
     1.155    21.633     0.200
     1.369    24.828     0.200
     3.518    60.211     0.200
     0.322     6.523     0.200
     0.470     8.914     0.200
     3.282    55.078     0.200
     3.282    56.461     0.200
     3.823    64.234     0.200
     3.823    67.602     0.200
     0.351     6.633     0.200
     0.398     7.273     0.200
     0.761    14.164     0.200
     1.205    22.016     0.200
     1.777    32.352     0.200
     2.203    38.500     0.200
     4.847    85.766     0.200
     0.387     7.609     0.200
     0.397     7.422     0.200
     0.723    13.555     0.200
     1.451    26.391     0.200
     0.150     3.583     0.200
     0.481     9.194     0.200
     0.816    16.024     0.200
     0.993    18.324     0.200
     1.395    24.664     0.200
     0.209     4.296     0.200
     0.547    10.486     0.200
     0.680    12.496     0.200
     1.157    21.286     0.200
     1.263    22.926     0.200
     0.624    11.781     0.200
     1.161    21.461     0.200
     1.594    30.051     0.200
     3.098    52.620     0.200
     0.439     9.098     0.200
     0.497     9.348     0.200
     0.640    12.278     0.200
     1.192    20.938     0.200
     1.147    21.928     0.200
     1.505    27.038     0.200
     0.393     7.559     0.200
     0.713    13.289     0.200
     1.579    28.959     0.200
     3.194    54.889     0.200
     0.162     3.592     0.200
     0.572    10.852     0.200
     0.676    12.602     0.200
     1.152    20.902     0.200
     1.574    29.941     0.200
     2.513    42.902     0.200
     0.336     6.746     0.200
     0.453     8.438     0.200
     0.752    14.207     0.200
     1.042    19.387     0.200
     1.241    21.916     0.200
     1.514    27.557     0.200
     3.148    54.838     0.200
     0.241     4.863     0.200
     0.511    10.053     0.200
     0.711    13.223     0.200
     1.300    23.373     0.200
     2.047    34.832     0.200
     2.531    43.752     0.200
     0.196     4.324     0.200
     0.534     9.803     0.200
     0.706    13.053     0.200
     0.199     4.279     0.200
     0.540    10.199     0.200
     0.695    13.039     0.200
     1.138    20.559     0.200
     1.262    22.598     0.200
     0.233     4.678     0.200
     0.515    10.139     0.200
     0.709    13.299     0.200
     1.131    20.518     0.200
     1.293    23.438     0.200
     1.382    24.438     0.200
     0.305     5.957     0.200
     0.406     7.457     0.200
     0.808    14.707     0.200
     1.001    19.090     0.200
     1.505    28.789     0.200
     1.527    26.777     0.200
     3.203    54.965     0.200
     0.249     5.074     0.200
     0.495    10.195     0.200
     0.728    13.535     0.200
     1.114    20.547     0.200
     1.313    23.316     0.200
     1.380    24.246     0.200
     3.187    56.246     0.200
     0.207     4.398     0.200
     0.771    14.129     0.200
     0.787    15.117     0.200
     1.024    19.246     0.200
     1.153    21.707     0.200
     1.691    30.680     0.200
     3.415    59.020     0.200
     0.086     2.758     0.200
     0.729    14.688     0.200
     0.690    12.465     0.200
     3.024    51.117     0.200
     0.250     5.195     0.200
     0.557    10.875     0.200
     0.655    11.973     0.200
     1.195    21.684     0.200
     1.280    24.023     0.200
     1.331    23.516     0.200
     1.615    28.473     0.200
     3.027    52.445     0.200
     0.305     6.484     0.200
     0.397     7.852     0.200
     0.815    15.094     0.200
     0.998    19.062     0.200
     1.240    22.133     0.200
     1.508    28.012     0.200
     3.636    61.484     0.200
     0.186     4.492     0.200
     0.606    11.539     0.200
     0.619    11.945     0.200
     1.206    22.383     0.200
     1.227    22.094     0.200
     0.569    10.883     0.200
     0.700    13.641     0.200
     1.102    19.898     0.200
     1.259    23.117     0.200
     3.156    55.203     0.200
     3.205    53.992     0.200
     0.503     9.868     0.200
     0.586    10.788     0.200
     0.625    11.798     0.200
     1.248    21.548     0.200
     1.509    27.138     0.200
     2.949    50.228     0.200
     0.486     9.985     0.200
     0.594    10.996     0.200
     0.590    10.945     0.200
     0.127     3.117     0.200
     0.627    10.988     0.200
     1.200    21.848     0.200
     0.482     9.137     0.200
     0.500     9.467     0.200
     0.598    10.727     0.200
     1.624    28.727     0.200
     3.074    52.576     0.200
     3.114    53.244     0.200
     0.530    10.164     0.200
     1.876    32.391     0.200
     3.398    57.305     0.200
     0.331     6.211     0.200
     0.454     8.393     0.200
     0.757    13.922     0.200
     1.037    19.111     0.200
     1.245    22.182     0.200
     1.732    31.082     0.200
     3.147    53.068     0.200
     0.155     2.963     0.200
     0.849    15.893     0.200
     1.364    24.582     0.200
     4.163    73.844     0.200
     0.329     6.395     0.200
     0.446     8.104     0.200
     0.762    14.084     0.200
     1.034    19.055     0.200
     1.243    23.184     0.200
     1.516    27.543     0.200
     1.539    28.463     0.200
     0.175     3.553     0.200
     0.542     9.883     0.200
     0.883    16.393     0.200
     0.902    17.273     0.200
     1.354    25.133     0.200
     1.396    25.303     0.200
     1.470    25.443     0.200
     3.141    57.322     0.200
     0.215     5.367     0.200
     1.075    18.316     0.200
     2.220    39.059     0.200
     2.634    44.988     0.200
     0.350     7.656     0.200
     0.364     6.516     0.200
     0.785    14.785     0.200
     1.039    18.535     0.200
     1.195    21.738     0.200
     1.481    26.598     0.200
     1.553    27.547     0.200
     0.234     5.367     0.200
     1.090    19.500     0.200
     2.992    50.898     0.200
     0.374     7.020     0.200
     0.437     8.590     0.200
     0.686    12.959     0.200
     1.400    25.209     0.200
     1.628    29.330     0.200
     0.290     6.188     0.200
     0.437     8.680     0.200
     0.808    15.871     0.200
     0.992    19.301     0.200
     1.483    27.301     0.200
     1.546    27.809     0.200
     2.262    39.488     0.200
     0.278     5.332     0.200
     0.447     8.301     0.200
     0.354     6.477     0.200
     0.489     9.195     0.200
     1.347    24.406     0.200
     0.325     6.125     0.200
     0.496     9.000     0.200
     1.185    21.453     0.200
     1.336    23.508     0.200
     1.694    29.969     0.200
     3.245    54.039     0.200
     0.212     4.539     0.200
     0.508     9.148     0.200
     1.095    20.109     0.200
     2.697    46.727     0.200
     3.190    55.039     0.200
     0.436     8.352     0.200
     1.115    20.312     0.200
     1.643    29.211     0.200
     3.261    54.508     0.200
     0.389     7.180     0.200
     0.511     9.227     0.200
     1.211    22.008     0.200
     1.332    24.398     0.200
     3.192    57.109     0.200
     3.232    56.203     0.200
     0.296     5.977     0.200
     0.419     8.102     0.200
     1.538    27.930     0.200
     2.248    39.352     0.200
     2.474    43.219     0.200
     3.191    57.555     0.200
     3.653    61.695     0.200
     0.322     6.133     0.200
     0.486     9.008     0.200
     1.174    21.523     0.200
     1.345    23.883     0.200
     2.295    39.898     0.200
     0.347     6.438     0.200
     0.697    12.858     0.200
     1.111    19.758     0.200
     1.640    28.638     0.200
     2.377    40.888     0.200
     3.585    60.118     0.200
     0.315     6.211     0.200
     2.233    40.062     0.200
     3.284    57.703     0.200
     5.094    90.434     0.200
     0.311     6.074     0.200
     1.353    23.785     0.200
     2.333    40.266     0.200
     3.295    57.160     0.200
     0.393     7.594     0.200
     0.737    13.953     0.200
     1.183    21.180     0.200
     1.460    26.016     0.200
     1.569    29.023     0.200
     2.289    40.250     0.200
     2.437    45.156     0.200
     0.309     5.843     0.200
     0.451     8.362     0.200
     2.292    39.992     0.200
     3.153    55.022     0.200
     0.345     6.094     0.200
     0.495     9.055     0.200
     1.503    27.445     0.200
     2.976    50.844     0.200
     3.104    52.652     0.200
     0.447     8.398     0.200
     2.359    41.875     0.200
     3.274    55.367     0.200
     0.597    11.385     0.200
     1.236    22.635     0.200
     0.442     8.477     0.200
     0.430     8.125     0.200
     2.306    40.145     0.200
     0.378     7.287     0.200
     3.228    55.442     0.200
     0.328     5.979     0.200
     1.375    24.988     0.200
     1.656    29.868     0.200
     2.283    40.809     0.200
     3.274    55.693     0.200
     0.345     6.250     0.200
     1.357    24.840     0.200
     1.672    29.758     0.200
     3.263    54.879     0.200
     0.429     7.746     0.200
     3.129    52.516     0.200
     5.201    91.328     0.200
     0.456     8.363     0.200
     0.552    10.959     0.200
     0.669    12.549     0.200
     1.171    21.049     0.200
     1.370    22.309     0.200
     2.567    44.678     0.200
     0.438     7.770     0.200
     0.996    18.602     0.200
     1.486    26.723     0.200
     2.266    39.512     0.200
     3.127    55.500     0.200
     0.314     5.547     0.200
     1.139    22.016     0.200
     1.377    24.258     0.200
     1.657    30.023     0.200
     2.267    39.766     0.200
     0.527    10.061     0.200
     0.809    15.512     0.200
     1.323    24.021     0.200
     2.166    38.361     0.200
     0.399     7.352     0.200
     0.892    17.648     0.200
     3.265    58.641     0.200
     0.827    15.363     0.200
     0.973    17.443     0.200
     1.280    22.922     0.200
     3.131    53.443     0.200
     0.853    16.266     0.200
     0.963    17.836     0.200
     1.264    22.742     0.200
     3.224    57.273     0.200
     3.918    70.344     0.200
     4.249    76.523     0.200
     0.356     6.828     0.200
     0.640    12.188     0.200
     1.063    19.617     0.200
     1.196    21.648     0.200
     0.415     8.059     0.200
     0.855    16.051     0.200
     0.955    17.648     0.200
     1.278    23.379     0.200
     1.469    26.852     0.200
     2.209    38.500     0.200
     0.333     6.387     0.200
     0.690    12.727     0.200
     1.090    19.965     0.200
     0.161     3.219     0.200
     0.741    13.348     0.200
     1.250    23.027     0.200
     2.310    40.727     0.200
     4.591    80.059     0.200
     0.512     9.062     0.200
     1.218    22.789     0.200
     1.127    21.547     0.200
     1.485    26.250     0.200
     1.560    28.203     0.200
     3.089    54.547     0.200
     0.503     9.342     0.200
     0.855    16.662     0.200
     0.939    17.682     0.200
     1.361    24.301     0.200
     2.192    38.672     0.200
     0.445     8.559     0.200
     0.879    16.590     0.200
     0.924    17.148     0.200
     1.314    23.879     0.200
     3.187    54.293     0.200
     0.573    11.525     0.200
     0.658    12.385     0.200
     0.619    11.951     0.200
     1.219    21.221     0.200
     1.228    22.181     0.200
     1.362    23.551     0.200
     0.548     9.936     0.200
     1.367    24.756     0.200
     3.263    57.531     0.200
     0.310     5.773     0.200
     1.327    23.324     0.200
     0.433     8.238     0.200
     0.868    16.488     0.200
     1.299    23.629     0.200
     3.195    56.799     0.200
     0.342     6.543     0.200
     0.545     9.973     0.200
     0.617    11.621     0.200
     1.017    18.250     0.200
     1.237    22.973     0.200
     3.289    57.387     0.200
     0.411     8.102     0.200
     0.673    11.883     0.200
     1.119    20.594     0.200
     0.321     6.214     0.200
     0.536     9.894     0.200
     0.755    14.193     0.200
     1.028    20.214     0.200
     1.305    23.363     0.200
     1.449    24.903     0.200
     3.066    54.349     0.200
     0.613    11.574     0.200
     0.491     8.691     0.200
     0.423     7.824     0.200
     1.103    20.004     0.200
     4.131    73.812     0.200
     0.240     5.438     0.200
     0.451     8.908     0.200
     0.859    16.277     0.200
     1.307    23.668     0.200
     1.370    24.559     0.200
     2.228    38.828     0.200
     3.174    52.879     0.200
     0.465     8.891     0.200
     0.630    11.851     0.200
     1.163    21.880     0.200
     2.403    41.750     0.200
     0.506     9.289     0.200
     0.607    10.941     0.200
     1.172    21.051     0.200
     1.180    22.270     0.200
     2.443    43.012     0.200
     3.105    52.957     0.200
     3.539    60.031     0.200
     0.393     7.508     0.200
     0.769    13.547     0.200
     1.042    18.797     0.200
     1.207    21.938     0.200
     1.377    25.637     0.200
     2.266    39.445     0.200
     0.391     6.836     0.200
     0.802    14.637     0.200
     1.012    19.168     0.200
     1.227    22.258     0.200
     1.413    25.598     0.200
     1.597    29.578     0.200
     1.521    27.359     0.200
     2.445    43.129     0.200
     0.433     8.445     0.200
     0.977    18.586     0.200
     1.274    23.324     0.200
     1.400    24.824     0.200
     0.346     6.555     0.200
     0.722    13.484     0.200
     1.353    24.352     0.200
     0.302     5.709     0.200
     0.418     7.998     0.200
     0.805    15.219     0.200
     1.000    18.539     0.200
     1.250    22.479     0.200
     1.416    25.369     0.200
     2.253    39.668     0.200
     3.190    53.539     0.200
     0.357     7.152     0.200
     0.839    15.393     0.200
     1.225    22.662     0.200
     1.371    23.773     0.200
     2.188    39.232     0.200
     0.414     8.117     0.200
     0.838    15.664     0.200
     0.970    17.945     0.200
     1.268    22.227     0.200
     2.223    38.789     0.200
     3.159    52.289     0.200
     3.828    63.688     0.200
     0.251     6.223     0.200
     0.419     7.820     0.200
     0.869    16.000     0.200
     1.289    23.293     0.200
     0.401     7.602     0.200
     0.304     6.273     0.200
     0.813    14.766     0.200
     1.404    24.102     0.200
     0.270     5.543     0.200
     0.656    12.812     0.200
     0.947    16.352     0.200
     1.294    22.934     0.200
     3.111    53.812     0.200
     0.481     9.422     0.200
     1.012    18.712     0.200
     1.218    21.942     0.200
     1.402    25.002     0.200
     1.598    31.002     0.200
     3.229    55.722     0.200
     0.615    11.949     0.200
     1.061    19.000     0.200
     1.191    21.910     0.200
     1.407    24.129     0.200
     2.001    35.949     0.200
     0.476     9.148     0.200
     0.697    12.828     0.200
     1.220    21.766     0.200
     1.682    30.098     0.200
     3.001    50.715     0.200
     3.123    55.070     0.200
     0.355     7.373     0.200
     0.687    12.513     0.200
     1.109    19.363     0.200
     5.142    90.593     0.200
     0.696    13.482     0.200
     0.750    13.973     0.200
     1.020    18.623     0.200
     1.104    18.344     0.200
     2.378    39.648     0.200
     0.558     9.516     0.200
     0.787    14.391     0.200
     1.002    18.734     0.200
     1.293    23.141     0.200
     2.968    50.562     0.200
     0.462     9.855     0.200
     0.645    11.707     0.200
     0.803    14.211     0.200
     0.861    16.477     0.200
     0.810    14.914     0.200
     0.289     5.668     0.200
     0.441     8.268     0.200
     0.807    15.158     0.200
     0.991    18.469     0.200
     1.269    23.789     0.200
     0.266     5.297     0.200
     0.857    15.969     0.200
     0.955    17.797     0.200
     1.274    22.969     0.200
     0.173     3.729     0.200
     0.399     7.599     0.200
     0.442     8.299     0.200
     0.485     9.339     0.200
     0.770    13.938     0.200
     0.927    17.539     0.200
     1.368    24.778     0.200
     1.310    23.108     0.200
     0.361     7.211     0.200
     0.656    12.289     0.200
     0.970    17.949     0.200
     1.049    18.250     0.200
     1.179    19.871     0.200
     1.175    21.738     0.200
     1.319    23.781     0.200
     1.808    32.211     0.200
     0.446     8.543     0.200
     0.663    12.803     0.200
     0.768    13.943     0.200
     0.831    14.703     0.200
     1.362    24.263     0.200
     1.405    25.003     0.200
     0.158     3.133     0.200
     0.439     7.984     0.200
     0.339     6.312     0.200
     0.472     8.711     0.200
     0.677    12.320     0.200
     1.059    18.680     0.200
     1.319    23.891     0.200
     1.531    27.312     0.200
     1.782    32.406     0.200
     2.810    49.344     0.200
     0.212     4.996     0.200
     0.338     6.816     0.200
     0.517    10.246     0.200
     0.609    11.586     0.200
     0.730    13.918     0.200
     0.936    17.348     0.200
     1.001    17.367     0.200
     1.052    18.379     0.200
     1.295    22.836     0.200
     1.391    24.367     0.200
     1.866    32.117     0.200
     2.821    46.727     0.200
     2.907    50.020     0.200
     3.700    66.156     0.200
     0.264     5.352     0.200
     0.352     6.832     0.200
     0.383     7.555     0.200
     0.428     8.223     0.200
     0.856    15.371     0.200
     0.845    15.203     0.200
     1.378    24.332     0.200
     2.673    45.914     0.200
     0.351     6.809     0.200
     0.390     7.469     0.200
     0.420     8.160     0.200
     0.846    15.219     0.200
     0.860    15.258     0.200
     0.961    17.527     0.200
     1.375    24.551     0.200
     4.846    84.109     0.200
     0.260     5.172     0.200
     0.360     7.055     0.200
     0.396     7.492     0.200
     0.421     8.312     0.200
     0.856    15.438     0.200
     1.283    23.602     0.200
     1.366    24.266     0.200
     0.281     5.523     0.200
     0.331     6.781     0.200
     0.363     7.152     0.200
     0.413     8.051     0.200
     0.774    13.953     0.200
     0.915    16.473     0.200
     1.235    22.523     0.200
     2.672    46.453     0.200
     3.656    64.344     0.200
     0.292     5.984     0.200
     0.273     5.102     0.200
     0.345     6.539     0.200
     0.478     9.188     0.200
     0.736    13.383     0.200
     0.905    16.078     0.200
     1.053    19.234     0.200
     1.498    26.750     0.200
     1.514    27.258     0.200
     0.133     3.998     0.200
     0.582    10.979     0.200
     0.645    12.338     0.200
     0.800    15.217     0.200
     0.822    15.148     0.200
     1.030    18.607     0.200
     1.177    21.508     0.200
     1.068    19.229     0.200
     1.163    19.848     0.200
     1.476    25.809     0.200
     1.459    25.857     0.200
     1.879    32.908     0.200
     3.063    50.648     0.200
     0.244     4.986     0.200
     0.368     7.036     0.200
     0.367     7.256     0.200
     0.453     8.616     0.200
     0.832    15.196     0.200
     0.854    15.456     0.200
     0.944    17.806     0.200
     1.376    24.916     0.200
     0.352     7.328     0.200
     0.425     9.168     0.200
     0.466     8.965     0.200
     0.767    14.578     0.200
     0.846    15.688     0.200
     0.889    16.156     0.200
     1.262    22.066     0.200
     1.348    22.797     0.200
     1.371    24.598     0.200
     1.042    18.504     0.200
     0.977    18.293     0.200
     2.621    47.543     0.200
     3.044    54.914     0.200
     0.208     4.332     0.200
     0.462     9.273     0.200
     0.452     8.592     0.200
     0.405     7.473     0.200
     0.804    15.203     0.200
     0.806    14.203     0.200
     0.854    15.822     0.200
     0.900    16.512     0.200
     0.904    16.852     0.200
     1.252    22.963     0.200
     1.289    23.303     0.200
     1.325    23.633     0.200
     1.332    23.932     0.200
     1.568    27.562     0.200
     2.188    38.352     0.200
     2.505    43.742     0.200
     0.295     5.926     0.200
     0.350     6.707     0.200
     0.438     8.375     0.200
     0.564    11.098     0.200
     0.789    14.676     0.200
     0.877    15.625     0.200
     0.882    16.426     0.200
     0.997    18.156     0.200
     1.263    22.746     0.200
     1.265    22.898     0.200
     1.284    23.328     0.200
     1.542    27.227     0.200
     2.267    39.387     0.200
     3.126    52.277     0.200
     0.480     9.895     0.200
     0.619    11.695     0.200
     0.663    12.676     0.200
     0.950    17.273     0.200
     1.682    28.613     0.200
     2.149    36.023     0.200
     2.775    47.965     0.200
     0.236     5.633     0.200
     0.498     9.773     0.200
     0.588    10.895     0.200
     0.894    16.234     0.200
     1.062    18.422     0.200
     1.067    18.633     0.200
     1.531    26.582     0.200
     2.275    38.754     0.200
     2.671    47.785     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
    23.235   577.797     0.200
     1.790    50.303     0.200
    15.790   399.303     0.200
    19.838   494.303     0.200
    20.225   506.303     0.200
    21.027   520.303     0.200
     8.075   203.930     0.200
    20.252   500.678     0.200
    21.423   530.678     0.200
    20.301   504.584     0.200
    16.193   411.520     0.200
    19.969   497.691     0.200
     1.910    49.545     0.200
     1.059    36.008     0.200
     1.883    55.008     0.200
     1.830    51.789     0.200
     1.772    49.078     0.200
    21.040   522.078     0.200
     1.778    51.613     0.200
     4.698   126.613     0.200
     1.694    43.660     0.200
     2.854    72.160     0.200
     7.169   180.160     0.200
     1.868    55.855     0.200
     1.041    36.746     0.200
     1.364    42.746     0.200
     2.064    59.746     0.200
     2.167    59.746     0.200
     1.360    44.433     0.200
     0.936    32.336     0.200
     2.689    76.738     0.200
     2.657    73.824     0.200
     1.190    37.523     0.200
     1.668    48.113     0.200
     2.309    63.703     0.200
     1.211    40.734     0.200
     2.949    74.145     0.200
     1.323    38.246     0.200
     1.833    50.156     0.200
     2.663    75.094     0.200
     2.687    76.066     0.200
     1.085    35.863     0.200
     1.454    46.504     0.200
     1.825    53.613     0.200
     2.207    62.475     0.200
     2.608    71.104     0.200
     1.492    47.016     0.200
     1.681    49.047     0.200
     2.233    66.078     0.200
     2.777    80.141     0.200
     2.941    83.609     0.200
     3.050    86.180     0.200
     3.064    85.656     0.200
     3.744   102.906     0.200
     4.036   110.039     0.200
     4.238   114.820     0.200
     4.666   122.484     0.200
     6.247   165.695     0.200
     1.007    34.922     0.200
     1.275    40.828     0.200
     1.722    50.352     0.200
     2.489    71.828     0.200
     2.683    74.828     0.200
     2.829    78.438     0.200
     4.048   109.203     0.200
     1.406    42.314     0.200
     2.405    66.705     0.200
     2.567    73.135     0.200
     2.696    77.385     0.200
     2.965    81.725     0.200
     3.626   100.174     0.200
    17.030   424.914     0.200
     1.390    41.096     0.200
     2.373    67.035     0.200
     2.640    74.725     0.200
     2.698    76.475     0.200
     3.741   102.355     0.200
     6.874   180.635     0.200
     2.001    59.020     0.200
     2.247    66.469     0.200
     2.502    73.051     0.200
     2.541    71.379     0.200
    16.777   422.000     0.200
     1.023    34.000     0.200
     1.701    48.250     0.200
     2.809    77.578     0.200
     1.179    41.367     0.200
     1.267    41.984     0.200
     1.034    37.387     0.200
     1.707    52.336     0.200
     1.946    58.547     0.200
     0.758    25.934     0.200
     1.334    38.464     0.200
     1.358    40.004     0.200
     1.443    42.645     0.200
     2.418    64.804     0.200
     2.479    69.764     0.200
     3.544    93.694     0.200
     4.780   124.534     0.200
    23.673   588.164     0.200
     0.752    26.207     0.200
     1.443    42.146     0.200
     1.657    47.106     0.200
     2.473    70.286     0.200
     2.697    74.117     0.200
     2.707    75.207     0.200
     1.112    37.887     0.200
     1.170    39.035     0.200
     1.230    40.297     0.200
     1.354    43.297     0.200
     1.273    42.445     0.200
     2.550    73.273     0.200
     0.711    27.066     0.200
     1.196    38.848     0.200
     1.712    48.996     0.200
     1.881    53.297     0.200
     1.802    51.617     0.200
     1.754    51.820     0.200
     2.002    57.102     0.200
     2.155    61.750     0.200
     2.603    72.129     0.200
     3.311    88.879     0.200
     1.064    32.770     0.200
     1.621    46.949     0.200
     1.889    54.211     0.200
     2.027    57.539     0.200
     2.134    60.559     0.200
     2.732    74.891     0.200
     0.888    30.328     0.200
     1.058    34.930     0.200
     1.262    42.148     0.200
     1.817    51.523     0.200
     2.066    58.906     0.200
     2.428    66.664     0.200
     2.366    68.336     0.200
     3.082    84.430     0.200
     3.586   100.500     0.200
     4.777   124.484     0.200
     0.988    33.727     0.200
     1.008    33.467     0.200
     1.069    35.316     0.200
     1.247    42.377     0.200
     1.308    42.605     0.200
     1.720    48.057     0.200
     2.259    65.146     0.200
     2.373    68.076     0.200
     2.456    69.816     0.200
     0.936    30.469     0.200
     1.482    44.211     0.200
     1.956    55.836     0.200
     1.974    56.383     0.200
     2.718    77.500     0.200
    16.457   415.685     0.200
     3.247    93.076     0.200
     1.237    40.292     0.200
     1.369    43.162     0.200
     2.663    75.766     0.200
     0.886    32.594     0.200
     2.491    72.954     0.200
     1.291    41.667     0.200
     2.531    72.187     0.200
     3.211    87.896     0.200
     2.302    68.515     0.200
     8.758   225.725     0.200
     1.110    37.496     0.200
     2.319    68.186     0.200
     3.263    88.335     0.200
     1.121    38.423     0.200
     3.125    90.433     0.200
     1.199    42.491     0.200
     2.091    63.730     0.200
     2.208    66.091     0.200
     2.605    75.841     0.200
     2.815    81.571     0.200
     3.170    92.321     0.200
     3.195    88.471     0.200
     8.740   224.960     0.200
     1.025    38.132     0.200
     2.344    68.902     0.200
     3.129    90.242     0.200
     3.297    91.152     0.200
     8.513   219.704     0.200
     1.309    43.585     0.200
     2.515    72.815     0.200
     3.141    85.485     0.200
     3.186    84.375     0.200
     1.593    49.022     0.200
     2.492    73.872     0.200
     1.211    39.011     0.200
     1.380    42.621     0.200
     2.252    65.551     0.200
     8.272   212.721     0.200
    10.773   272.461     0.200
     1.368    44.022     0.200
     1.552    46.492     0.200
     2.056    59.672     0.200
     2.894    79.712     0.200
     3.188    85.932     0.200
     3.432    96.432     0.200
     8.538   220.402     0.200
    16.424   411.772     0.200
     1.098    36.657     0.200
     1.267    41.890     0.200
     3.206    86.520     0.200
     1.287    42.048     0.200
     1.584    47.728     0.200
     3.057    85.768     0.200
     3.203    88.098     0.200
     8.623   218.768     0.200
     1.243    40.949     0.200
     1.243    42.609     0.200
     1.564    47.170     0.200
     2.176    64.989     0.200
     2.577    75.000     0.200
     3.790   103.689     0.200
     1.070    38.345     0.200
     1.170    38.994     0.200
     2.337    67.674     0.200
     2.342    67.924     0.200
     2.761    78.725     0.200
     3.110    87.135     0.200
     0.924    31.169     0.200
     3.204    91.661     0.200
     3.204    84.201     0.200
     1.288    43.537     0.200
     2.537    73.298     0.200
     2.851    81.728     0.200
     3.517    99.438     0.200
     8.634   218.947     0.200
    13.870   347.428     0.200
    14.135   355.567     0.200
    16.467   413.327     0.200
     1.375    44.650     0.200
     2.254    66.531     0.200
     2.442    69.961     0.200
     4.626   121.262     0.200
     1.464    47.602     0.200
     1.904    56.602     0.200
     1.972    58.092     0.200
     1.506    47.910     0.200
     1.783    54.500     0.200
     1.079    38.133     0.200
     1.161    38.264     0.200
     1.070    38.492     0.200
     1.152    38.342     0.200
     1.359    44.762     0.200
     1.833    55.223     0.200
     2.470    72.693     0.200
    16.439   417.193     0.200
     1.847    52.541     0.200
     2.585    73.869     0.200
     3.246    85.143     0.200
     1.616    49.025     0.200
     3.239    92.230     0.200
     8.758   228.059     0.200
     1.187    38.854     0.200
     1.383    43.184     0.200
     2.851    79.334     0.200
     8.298   212.244     0.200
    16.262   407.045     0.200
     1.265    42.002     0.200
     3.536    97.443     0.200
     8.624   221.893     0.200
     9.691   247.842     0.200
    15.795   399.104     0.200
    16.416   412.104     0.200
     0.925    32.949     0.200
     1.321    43.020     0.200
     1.606    49.371     0.200
     3.171    90.906     0.200
     3.171    85.133     0.200
     8.606   222.062     0.200
     1.021    37.562     0.200
     1.691    52.242     0.200
     2.137    65.164     0.200
     1.188    40.539     0.200
     1.460    47.398     0.200
     1.683    51.949     0.200
     2.217    64.840     0.200
     1.134    39.012     0.200
     1.403    45.320     0.200
     1.748    53.781     0.200
     0.947    34.434     0.200
     1.410    47.031     0.200
     1.592    48.582     0.200
     3.134    88.648     0.200
     3.134    85.582     0.200
     8.527   220.051     0.200
     1.257    40.020     0.200
     1.376    44.887     0.200
     3.255    89.762     0.200
     0.817    30.145     0.200
     3.296    92.020     0.200
     3.296    90.031     0.200
     8.472   216.832     0.200
    10.924   274.242     0.200
     1.100    38.547     0.200
     1.063    37.332     0.200
     1.160    40.660     0.200
     1.591    47.520     0.200
     0.942    33.496     0.200
     1.318    43.926     0.200
     1.626    50.215     0.200
     1.148    39.758     0.200
     1.416    44.000     0.200
     1.831    52.918     0.200
     5.952   155.277     0.200
    16.295   408.707     0.200
     1.017    36.492     0.200
     1.290    43.520     0.200
     1.555    50.250     0.200
     1.713    53.172     0.200
     0.992    34.109     0.200
     1.410    46.781     0.200
     1.707    51.789     0.200
     2.022    60.340     0.200
     1.145    39.527     0.200
     3.272    90.289     0.200
     1.142    38.359     0.200
     1.125    37.230     0.200
     1.396    45.297     0.200
     2.280    66.629     0.200
     1.116    37.758     0.200
     1.411    45.801     0.200
     1.655    51.820     0.200
     1.780    54.711     0.200
     0.992    35.234     0.200
     1.263    42.273     0.200
     2.146    63.164     0.200
     3.039    85.055     0.200
     1.140    39.055     0.200
     1.382    45.465     0.200
     2.000    60.684     0.200
     2.306    68.043     0.200
     2.507    71.145     0.200
     3.119    90.375     0.200
     3.191    91.332     0.200
     4.192   114.453     0.200
     1.125    37.762     0.200
     1.170    38.961     0.200
     1.433    46.219     0.200
     1.253    41.992     0.200
     1.852    55.656     0.200
     1.288    42.094     0.200
     2.676    76.234     0.200
     3.199    92.234     0.200
     1.090    37.539     0.200
     1.154    39.109     0.200
     1.369    44.961     0.200
     1.987    59.766     0.200
     2.316    68.656     0.200
     2.499    72.531     0.200
     3.266    87.695     0.200
     3.521   100.898     0.200
     1.227    41.438     0.200
     1.432    44.930     0.200
     1.858    55.680     0.200
     3.203    85.836     0.200
     8.250   212.922     0.200
     1.369    45.164     0.200
     1.663    50.617     0.200
     1.782    55.203     0.200
     1.987    57.445     0.200
     2.321    69.031     0.200
     2.315    68.297     0.200
     1.080    36.750     0.200
     2.327    68.570     0.200
     2.487    73.805     0.200
     1.049    37.172     0.200
     1.205    41.406     0.200
     1.484    48.781     0.200
     1.777    52.953     0.200
     1.644    51.016     0.200
     2.608    73.461     0.200
     3.160    89.406     0.200
     1.087    36.797     0.200
     1.176    39.953     0.200
     1.451    45.852     0.200
     3.202    86.852     0.200
     1.395    45.454     0.200
     1.584    45.744     0.200
     1.695    51.984     0.200
     2.041    59.654     0.200
     2.262    66.984     0.200
     1.263    42.576     0.200
     1.387    43.816     0.200
     2.541    71.606     0.200
     2.828    79.426     0.200
     3.289    90.536     0.200
     4.086   109.816     0.200
     8.216   210.306     0.200
     1.161    38.671     0.200
     1.803    54.651     0.200
     2.222    65.521     0.200
     2.665    76.931     0.200
     3.098    81.371     0.200
     3.293    92.371     0.200
     3.672   102.781     0.200
     4.509   121.421     0.200
     8.850   227.811     0.200
     9.580   242.741     0.200
     1.640    51.228     0.200
     1.787    55.768     0.200
     2.217    65.418     0.200
     2.666    77.408     0.200
     2.680    78.258     0.200
     3.107    84.098     0.200
     3.280    91.568     0.200
     3.317    91.058     0.200
     3.376    98.098     0.200
     8.835   230.258     0.200
     1.094    37.229     0.200
     2.063    61.260     0.200
     2.230    65.408     0.200
     2.586    75.148     0.200
     2.719    77.939     0.200
     2.799    79.459     0.200
     3.180    89.549     0.200
     3.214    88.139     0.200
     4.387   118.238     0.200
     1.226    41.963     0.200
     1.434    44.713     0.200
     1.857    55.262     0.200
     1.932    57.102     0.200
     1.042    35.518     0.200
     1.241    41.346     0.200
     1.532    46.756     0.200
     1.687    51.727     0.200
     2.126    63.287     0.200
     2.164    62.846     0.200
     2.658    76.316     0.200
     3.148    86.252     0.200
     3.148    85.777     0.200
     3.211    88.227     0.200
     3.213    93.018     0.200
     4.397   118.057     0.200
     8.726   225.617     0.200
    16.542   418.357     0.200
     1.131    35.543     0.200
     1.300    44.773     0.200
     1.375    43.523     0.200
     1.985    57.793     0.200
     2.531    71.832     0.200
     1.264    41.914     0.200
     1.420    44.553     0.200
     1.968    57.754     0.200
     2.504    71.514     0.200
     1.138    36.709     0.200
     1.262    42.658     0.200
     1.960    55.238     0.200
     2.518    71.389     0.200
     4.106   108.729     0.200
     8.215   212.088     0.200
     1.293    42.418     0.200
     1.981    57.998     0.200
     2.527    71.117     0.200
     4.077   108.648     0.200
     1.001    36.410     0.200
     1.243    41.539     0.200
     1.615    49.719     0.200
     2.168    66.070     0.200
     2.639    76.258     0.200
     2.688    77.719     0.200
     3.149    91.129     0.200
     4.326   117.188     0.200
     1.313    43.457     0.200
     1.380    43.406     0.200
     2.518    72.016     0.200
     2.805    79.164     0.200
     3.268    91.566     0.200
    16.248   411.688     0.200
     1.024    35.117     0.200
     3.019    87.688     0.200
     3.415    97.707     0.200
    16.523   412.145     0.200
     1.280    43.246     0.200
     1.331    41.855     0.200
     1.910    55.555     0.200
     0.998    34.285     0.200
     1.240    42.062     0.200
     1.526    45.812     0.200
     1.593    46.883     0.200
     2.585    74.133     0.200
     2.859    80.695     0.200
     3.128    86.375     0.200
     3.138    88.402     0.200
     3.214    89.992     0.200
     3.565   101.133     0.200
     4.125   114.773     0.200
     4.256   114.703     0.200
     4.314   115.293     0.200
     1.206    40.523     0.200
     1.877    52.922     0.200
     2.841    79.805     0.200
     1.538    44.359     0.200
     1.500    44.266     0.200
     1.582    46.156     0.200
     2.575    72.055     0.200
     2.701    73.117     0.200
     4.111   113.602     0.200
    10.973   274.086     0.200
     1.102    36.297     0.200
     1.259    39.992     0.200
     1.807    53.852     0.200
     1.962    58.422     0.200
     2.944    83.703     0.200
     3.115    86.164     0.200
     3.310    93.609     0.200
     3.755   100.297     0.200
     3.820   101.258     0.200
     4.536   118.258     0.200
    15.197   381.078     0.200
    23.208   575.289     0.200
     2.183    63.378     0.200
     2.585    74.958     0.200
     2.887    82.828     0.200
     2.989    83.308     0.200
     3.410    95.527     0.200
     1.458    45.445     0.200
     1.881    55.176     0.200
     2.195    62.176     0.200
     2.609    73.865     0.200
     1.175    39.768     0.200
     2.541    74.418     0.200
     3.114    89.268     0.200
     1.404    44.906     0.200
     1.518    45.848     0.200
     1.626    48.928     0.200
     1.624    49.018     0.200
     2.253    64.996     0.200
     2.690    77.736     0.200
     2.721    78.836     0.200
     3.286    91.777     0.200
     3.546    96.697     0.200
     4.001   108.027     0.200
     4.052   111.207     0.200
     9.598   244.787     0.200
     1.180    31.602     0.200
     1.898    52.164     0.200
     1.962    54.914     0.200
     2.358    64.684     0.200
     1.037    36.432     0.200
     1.245    41.121     0.200
     1.510    49.021     0.200
     2.160    63.031     0.200
     2.597    76.611     0.200
     2.655    76.201     0.200
    16.540   418.182     0.200
    22.480   556.982     0.200
     1.676    50.504     0.200
     1.853    56.613     0.200
     2.220    66.633     0.200
     2.296    66.453     0.200
     2.436    71.553     0.200
     2.599    73.383     0.200
     2.764    80.924     0.200
     3.157    91.764     0.200
    16.435   413.344     0.200
    22.621   562.443     0.200
     1.034    35.984     0.200
     1.243    41.953     0.200
     2.163    62.885     0.200
     1.674    52.152     0.200
     2.014    60.834     0.200
     2.146    65.732     0.200
     2.437    72.553     0.200
     2.546    74.193     0.200
     2.524    69.625     0.200
     1.290    42.285     0.200
     2.012    57.719     0.200
     2.455    69.535     0.200
     8.183   210.258     0.200
     1.039    34.438     0.200
     1.195    41.488     0.200
     1.553    47.426     0.200
     1.622    45.695     0.200
     2.217    64.988     0.200
     1.090    34.414     0.200
     1.306    43.977     0.200
     1.414    42.508     0.200
     1.802    52.367     0.200
     2.011    58.625     0.200
     2.255    64.016     0.200
     1.135    37.969     0.200
     1.400    45.330     0.200
     1.621    48.840     0.200
     1.679    52.250     0.200
     2.280    65.260     0.200
     2.285    67.979     0.200
     0.808    28.570     0.200
     0.992    34.348     0.200
     2.224    65.238     0.200
     2.565    74.039     0.200
     2.658    76.949     0.200
     1.386    42.992     0.200
     1.710    49.410     0.200
     2.837    79.750     0.200
     1.183    39.785     0.200
     1.347    43.887     0.200
     1.656    49.086     0.200
     2.809    80.566     0.200
     1.185    39.305     0.200
     1.336    43.922     0.200
     1.684    50.039     0.200
     2.834    81.445     0.200
     2.852    81.742     0.200
     3.286    88.305     0.200
     3.755   106.750     0.200
     4.172   112.461     0.200
     2.478    71.289     0.200
    16.299   413.406     0.200
     1.115    37.938     0.200
     1.395    43.609     0.200
     1.691    48.789     0.200
     2.819    79.938     0.200
     2.898    80.008     0.200
     3.303    92.086     0.200
    15.709   396.438     0.200
    16.430   416.039     0.200
    23.203   576.742     0.200
     1.332    44.969     0.200
     1.636    49.547     0.200
     2.787    78.867     0.200
     2.800    80.570     0.200
    23.304   580.805     0.200
     0.994    33.320     0.200
     1.622    49.180     0.200
     2.675    76.648     0.200
     3.191    85.180     0.200
     3.667    99.930     0.200
     3.849   102.359     0.200
     4.114   112.305     0.200
     1.174    38.930     0.200
     1.345    43.477     0.200
     1.964    58.203     0.200
     2.342    68.320     0.200
     2.766    79.391     0.200
     2.830    79.469     0.200
     3.723   103.711     0.200
     3.827   103.930     0.200
    12.913   326.194     0.200
    16.431   412.141     0.200
     1.111    38.598     0.200
     1.389    43.608     0.200
     2.788    78.688     0.200
     3.197    87.818     0.200
     2.020    61.070     0.200
     2.278    69.121     0.200
     2.362    70.934     0.200
     2.688    79.633     0.200
     2.793    79.801     0.200
     3.284    93.543     0.200
     4.213   119.820     0.200
     4.301   117.812     0.200
     1.353    43.535     0.200
     2.031    59.453     0.200
     2.475    72.516     0.200
     2.832    80.715     0.200
     3.186    91.094     0.200
     4.060   109.785     0.200
     1.183    39.664     0.200
     1.569    50.891     0.200
     1.658    51.680     0.200
     2.096    60.250     0.200
     2.437    72.070     0.200
     2.651    77.164     0.200
     2.147    61.053     0.200
     2.650    76.112     0.200
     3.018    87.042     0.200
     3.153    89.247     0.200
     1.503    49.133     0.200
     1.730    52.715     0.200
     2.145    61.734     0.200
     2.594    75.762     0.200
     2.624    75.523     0.200
     3.104    83.383     0.200
     3.953   105.293     0.200
     9.573   242.645     0.200
     1.666    49.305     0.200
     2.727    77.133     0.200
     2.803    79.461     0.200
     2.861    78.742     0.200
    12.949   328.070     0.200
    16.468   415.719     0.200
     1.644    49.086     0.200
     2.001    59.225     0.200
     2.600    73.775     0.200
     1.551    46.047     0.200
     1.568    47.477     0.200
     1.620    49.375     0.200
     2.126    63.164     0.200
     2.543    74.965     0.200
     2.649    76.336     0.200
     1.491    47.441     0.200
     2.106    62.902     0.200
     2.128    62.004     0.200
     2.682    74.652     0.200
     2.611    74.357     0.200
     2.718    76.447     0.200
     1.668    50.278     0.200
     1.993    59.349     0.200
     2.314    65.408     0.200
     2.736    78.059     0.200
     2.808    80.648     0.200
     1.659    49.738     0.200
     1.672    50.109     0.200
     2.066    62.137     0.200
     2.808    80.000     0.200
     3.263    93.930     0.200
     1.556    48.535     0.200
     1.671    50.043     0.200
     2.111    62.727     0.200
     2.125    63.285     0.200
     2.184    64.793     0.200
     2.681    75.465     0.200
     3.129    86.734     0.200
     3.171    88.574     0.200
     3.171    85.855     0.200
     3.657   102.184     0.200
     1.691    52.422     0.200
     2.150    63.215     0.200
     2.125    63.625     0.200
     2.656    76.363     0.200
     3.015    88.215     0.200
     3.145    90.172     0.200
     4.072   115.414     0.200
     1.883    55.859     0.200
     2.559    73.248     0.200
     0.996    35.680     0.200
     1.550    46.012     0.200
     1.543    47.449     0.200
     2.658    75.801     0.200
     2.819    79.402     0.200
    16.499   418.312     0.200
     1.139    38.594     0.200
     1.528    44.801     0.200
     2.107    62.471     0.200
     2.571    73.572     0.200
     1.444    45.750     0.200
     1.637    47.109     0.200
     2.697    77.090     0.200
     1.483    46.617     0.200
     1.574    47.836     0.200
     2.274    66.922     0.200
     2.691    76.422     0.200
     3.095    85.516     0.200
     3.121    85.672     0.200
     3.656   100.711     0.200
     3.691   101.547     0.200
     4.144   111.797     0.200
     1.063    37.406     0.200
     1.196    39.891     0.200
     1.692    51.031     0.200
     2.342    67.578     0.200
     3.149    84.000     0.200
     3.144    89.109     0.200
     1.278    42.359     0.200
     1.469    46.352     0.200
     1.583    48.922     0.200
     1.830    55.422     0.200
     2.138    63.270     0.200
     2.674    76.129     0.200
     2.666    76.250     0.200
     1.665    48.695     0.200
     2.808    80.246     0.200
     1.250    43.090     0.200
     1.873    57.578     0.200
     1.872    57.727     0.200
     2.494    74.289     0.200
     1.634    53.500     0.200
     1.788    54.398     0.200
     2.075    62.727     0.200
     2.147    65.938     0.200
     2.225    65.305     0.200
     2.646    77.164     0.200
     2.642    77.867     0.200
     3.292    92.234     0.200
     1.577    48.992     0.200
     2.033    61.051     0.200
     2.588    74.311     0.200
     1.314    43.008     0.200
     1.562    44.848     0.200
     2.102    61.918     0.200
     2.237    65.129     0.200
     2.643    75.109     0.200
     3.038    87.008     0.200
     3.187    88.230     0.200
     3.187    89.281     0.200
     4.105   115.781     0.200
     8.602   221.590     0.200
     1.398    43.335     0.200
     1.610    48.235     0.200
     2.548    73.375     0.200
     2.546    72.525     0.200
     3.703    95.535     0.200
     1.228    40.591     0.200
     1.362    43.421     0.200
     1.795    53.361     0.200
     1.367    45.736     0.200
     1.699    50.904     0.200
     2.457    71.844     0.200
     2.847    81.064     0.200
     3.097    86.545     0.200
     3.301    95.555     0.200
     1.449    45.420     0.200
     1.570    45.869     0.200
     1.827    55.148     0.200
     2.081    59.840     0.200
     1.701    51.570     0.200
     2.388    70.172     0.200
     1.119    37.508     0.200
     1.529    46.336     0.200
     1.746    52.133     0.200
     2.192    65.078     0.200
     2.213    64.766     0.200
     3.245    88.117     0.200
     3.276    89.188     0.200
     3.578   101.234     0.200
     4.068   112.484     0.200
     4.453   118.883     0.200
     1.305    43.174     0.200
     1.747    53.834     0.200
     2.101    62.443     0.200
     2.578    74.653     0.200
     1.103    39.133     0.200
     1.596    48.594     0.200
     1.750    54.121     0.200
     2.304    69.023     0.200
     2.144    64.152     0.200
     4.131   117.504     0.200
     1.307    42.848     0.200
     1.370    44.389     0.200
     1.440    45.168     0.200
     1.549    44.729     0.200
     3.027    86.027     0.200
     3.120    84.197     0.200
     1.615    49.420     0.200
     1.663    50.740     0.200
     2.184    64.900     0.200
     2.403    68.431     0.200
     1.180    40.980     0.200
     1.613    50.320     0.200
     2.240    65.039     0.200
     3.105    85.852     0.200
     3.385    93.492     0.200
     1.042    36.516     0.200
     1.446    45.977     0.200
     1.542    47.258     0.200
     1.592    47.465     0.200
     2.201    64.266     0.200
     3.076    84.906     0.200
     3.208    90.547     0.200
     3.431    94.855     0.200
     4.135   111.125     0.200
     8.718   225.547     0.200
     1.012    36.586     0.200
     1.227    42.789     0.200
     1.521    49.770     0.200
     1.808    55.996     0.200
     1.610    50.086     0.200
     2.072    63.520     0.200
     2.445    72.457     0.200
     2.705    78.797     0.200
     3.428    97.227     0.200
     1.274    43.105     0.200
     1.620    49.305     0.200
     2.102    61.684     0.200
     1.640    50.414     0.200
     2.308    67.305     0.200
     2.775    80.023     0.200
     1.000    33.658     0.200
     1.250    40.879     0.200
     2.160    61.828     0.200
     2.648    72.059     0.200
     3.162    84.668     0.200
     4.114   109.568     0.200
     1.225    40.783     0.200
     1.559    47.482     0.200
     2.310    68.113     0.200
     0.970    32.766     0.200
     1.382    43.734     0.200
     1.289    42.613     0.200
     1.585    45.773     0.200
     1.352    43.492     0.200
     2.259    65.992     0.200
     2.169    64.406     0.200
     3.416    96.742     0.200
     3.671    99.266     0.200
     4.132   113.695     0.200
     1.294    43.332     0.200
     1.693    49.723     0.200
     1.918    56.891     0.200
     2.492    71.184     0.200
     1.218    41.022     0.200
     1.598    47.442     0.200
     2.220    64.922     0.200
     1.061    35.570     0.200
     1.191    40.730     0.200
     1.612    49.340     0.200
     2.289    66.691     0.200
     2.379    68.070     0.200
     1.908    53.406     0.200
     3.570    99.656     0.200
     1.641    50.252     0.200
     1.668    51.913     0.200
     2.073    62.603     0.200
     2.305    68.823     0.200
     2.297    67.902     0.200
     2.297    68.243     0.200
     3.705   105.843     0.200
     2.281    62.113     0.200
     2.714    75.943     0.200
    17.576   440.854     0.200
     1.293    43.500     0.200
     1.970    59.484     0.200
     2.129    64.375     0.200
     2.600    76.781     0.200
     5.341   142.531     0.200
     1.194    38.066     0.200
    16.602   419.996     0.200
     1.788    51.734     0.200
     2.321    64.586     0.200
     2.608    75.234     0.200
     2.866    80.023     0.200
     2.866    77.711     0.200
     1.269    42.959     0.200
     1.419    45.117     0.200
     2.117    62.639     0.200
     2.654    74.889     0.200
     2.819    79.867     0.200
     0.955    33.910     0.200
     1.274    41.777     0.200
     1.361    42.770     0.200
     2.081    60.637     0.200
     2.681    77.008     0.200
     2.880    81.840     0.200
     1.368    44.898     0.200
     1.310    42.449     0.200
     1.542    44.709     0.200
     2.218    66.139     0.200
     2.873    80.188     0.200
     3.013    81.839     0.200
     1.546    47.309     0.200
     1.704    51.660     0.200
     1.824    54.680     0.200
     1.930    57.488     0.200
     2.262    66.020     0.200
     2.445    71.641     0.200
     1.362    43.823     0.200
     2.219    65.723     0.200
     2.237    66.263     0.200
     2.466    71.163     0.200
     2.643    74.063     0.200
     1.663    50.492     0.200
     1.665    51.453     0.200
     2.059    60.727     0.200
     2.323    69.805     0.200
     2.842    80.602     0.200
     1.295    41.477     0.200
     1.625    47.309     0.200
     2.449    69.449     0.200
     2.776    78.117     0.200
     2.821    75.758     0.200
     1.569    46.145     0.200
     1.600    49.465     0.200
     1.813    55.273     0.200
     2.063    61.715     0.200
     2.132    63.473     0.200
     2.132    62.633     0.200
     2.855    82.273     0.200
     3.049    83.594     0.200
     3.166    87.973     0.200
     1.375    44.660     0.200
     1.564    48.391     0.200
     1.594    48.219     0.200
     2.066    59.090     0.200
     2.080    62.199     0.200
     2.137    63.629     0.200
     2.862    82.051     0.200
     3.056    87.469     0.200
     3.173    89.789     0.200
     1.283    42.383     0.200
     1.465    46.172     0.200
     2.076    61.156     0.200
     2.253    66.766     0.200
     2.476    72.406     0.200
     2.668    76.641     0.200
     2.869    82.164     0.200
     3.203    90.383     0.200
     1.235    40.641     0.200
     1.524    47.582     0.200
     1.572    46.734     0.200
     2.103    62.434     0.200
     2.464    69.434     0.200
     2.689    77.773     0.200
     2.822    80.781     0.200
     3.138    86.043     0.200
     3.169    89.582     0.200
     1.942    58.117     0.200
     2.156    65.789     0.200
     2.749    78.469     0.200
     0.800    28.988     0.200
     0.822    29.467     0.200
     1.030    33.857     0.200
     1.177    38.398     0.200
     1.278    40.107     0.200
     2.201    62.277     0.200
     2.330    65.238     0.200
     2.643    74.568     0.200
     2.734    76.777     0.200
     2.703    76.059     0.200
     3.683   101.367     0.200
     1.376    44.366     0.200
     1.546    45.006     0.200
     1.611    49.396     0.200
     2.063    61.756     0.200
     2.509    73.306     0.200
     2.841    79.006     0.200
     1.371    44.875     0.200
     1.814    52.945     0.200
     2.296    64.805     0.200
     2.240    64.945     0.200
     2.352    68.027     0.200
     2.706    73.633     0.200
     2.484    66.625     0.200
     2.621    75.234     0.200
     2.671    72.699     0.200
     2.795    78.242     0.200
     3.044    86.562     0.200
     0.806    30.332     0.200
     1.252    40.703     0.200
     1.289    42.713     0.200
     1.325    42.652     0.200
     1.332    44.123     0.200
     1.416    44.633     0.200
     1.568    47.193     0.200
     1.486    45.123     0.200
     1.700    51.053     0.200
     2.114    62.312     0.200
     2.505    72.932     0.200
     2.635    71.553     0.200
     2.881    79.883     0.200
     3.186    90.783     0.200
     0.997    34.598     0.200
     1.263    42.277     0.200
     1.265    41.227     0.200
     1.284    41.605     0.200
     1.424    44.648     0.200
     1.487    45.809     0.200
     1.550    46.078     0.200
     1.728    48.766     0.200
     1.880    51.535     0.200
     2.159    63.578     0.200
     2.253    64.875     0.200
     2.492    70.078     0.200
     2.818    79.809     0.200
     3.131    87.387     0.200
     3.170    83.715     0.200
     3.381    92.836     0.200
     3.870   102.477     0.200
     4.094   112.598     0.200
     4.353   116.246     0.200
     1.026    31.684     0.200
     1.058    31.164     0.200
     1.134    31.535     0.200
     1.367    39.324     0.200
     1.493    44.375     0.200
     1.558    44.285     0.200
     1.732    49.945     0.200
     1.820    51.805     0.200
     1.918    54.586     0.200
     1.921    54.062     0.200
     1.999    57.676     0.200
     2.118    61.324     0.200
     2.149    60.742     0.200
     2.124    57.055     0.200
     2.549    70.203     0.200
     2.630    72.754     0.200
     2.697    75.375     0.200
     2.953    83.355     0.200
     3.352    92.125     0.200
     3.362    87.914     0.200
     3.610    94.773     0.200
     3.874   104.645     0.200
     1.281    41.535     0.200
     1.680    47.223     0.200
     1.735    47.914     0.200
     1.953    57.254     0.200
     2.205    63.125     0.200
     2.200    61.652     0.200
     2.286    62.395     0.200
     2.366    68.203     0.200
     2.435    67.895     0.200
     2.522    70.492     0.200
     2.641    74.902     0.200
     2.729    76.395     0.200
     2.804    77.633     0.200
     3.390    92.062     0.200
     3.331    91.145     0.200
     3.764   100.062     0.200
     3.868   100.734     0.200
     4.080   109.184     0.200
     4.554   119.254     0.200
     7.796   205.594     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     5.745   168.103     0.200
     0.848    28.008     0.200
     1.079    35.932     0.200
     0.848    28.789     0.200
     2.479    74.289     0.200
     0.868    30.078     0.200
     0.516    18.613     0.200
     2.073    64.613     0.200
     1.084    34.594     0.200
     2.251    71.594     0.200
     2.468    77.656     0.200
     1.932    60.547     0.200
     2.776    83.547     0.200
     0.911    30.135     0.200
     1.592    49.736     0.200
     2.639    76.736     0.200
     2.849    84.436     0.200
     0.989    32.238     0.200
     1.633    51.238     0.200
     2.628    76.336     0.200
     2.788    83.137     0.200
     1.594    49.727     0.200
     2.834    84.227     0.200
     0.442    15.625     0.200
     0.540    19.926     0.200
     0.666    23.117     0.200
     1.202    36.285     0.200
     1.953    58.934     0.200
     0.292    14.334     0.200
     0.864    27.785     0.200
     1.557    48.805     0.200
     2.678    77.445     0.200
     0.831    26.906     0.200
     0.839    27.395     0.200
     2.927    85.926     0.200
     0.171     7.504     0.200
     0.776    27.895     0.200
     0.891    29.623     0.200
     0.347    12.484     0.200
     0.842    28.953     0.200
     1.011    32.297     0.200
     1.891    58.578     0.200
     1.985    60.680     0.200
     2.114    67.266     0.200
     2.368    70.445     0.200
     3.162    93.023     0.200
     1.016    32.602     0.200
     1.102    35.180     0.200
     1.489    48.609     0.200
     2.383    73.828     0.200
     3.019    88.234     0.200
     0.864    27.755     0.200
     0.865    28.074     0.200
     1.312    41.984     0.200
     1.554    48.814     0.200
     1.859    56.545     0.200
     2.673    77.234     0.200
     2.951    88.574     0.200
     0.827    26.846     0.200
     0.844    27.656     0.200
     1.335    41.615     0.200
     1.888    60.006     0.200
     1.997    60.975     0.200
     0.714    23.949     0.200
     1.940    58.641     0.200
     1.906    58.520     0.200
     1.906    57.879     0.200
     2.001    60.172     0.200
     0.204     9.750     0.200
     0.539    18.340     0.200
     1.036    32.371     0.200
     1.262    39.121     0.200
     1.511    46.879     0.200
     2.233    69.090     0.200
     2.402    71.391     0.200
     0.684    22.590     0.200
     0.862    28.539     0.200
     1.862    56.367     0.200
     2.227    66.648     0.200
     2.570    76.988     0.200
     0.392    14.377     0.200
     1.349    42.166     0.200
     1.894    58.857     0.200
     1.925    58.756     0.200
     2.301    72.377     0.200
     1.260    40.474     0.200
     1.970    59.734     0.200
     0.648    21.967     0.200
     1.471    44.847     0.200
     1.542    46.027     0.200
     1.500    46.145     0.200
     2.237    67.039     0.200
     0.494    17.934     0.200
     0.648    22.355     0.200
     0.763    25.664     0.200
     1.323    38.613     0.200
     1.456    44.676     0.200
     1.042    31.875     0.200
     0.353    14.000     0.200
     0.934    29.750     0.200
     1.041    31.832     0.200
     1.654    49.379     0.200
     1.804    55.609     0.200
     2.145    63.031     0.200
     0.463    17.930     0.200
     1.220    38.441     0.200
     1.520    45.852     0.200
     0.943    30.383     0.200
     1.219    37.883     0.200
     1.639    51.516     0.200
     1.713    52.375     0.200
     1.848    56.859     0.200
     3.135    94.117     0.200
     1.492    46.936     0.200
     2.281    67.037     0.200
     0.237    11.406     0.200
     0.488    17.750     0.200
     1.355    42.430     0.200
     1.346    41.695     0.200
     1.381    43.742     0.200
     2.255    65.516     0.200
     0.293    11.307     0.200
     0.804    26.757     0.200
     0.306    11.398     0.200
     0.764    25.558     0.200
     0.303    10.406     0.200
     0.204     8.062     0.200
     0.636    21.662     0.200
     0.352    13.000     0.200
     0.763    25.190     0.200
     1.965    59.460     0.200
     0.745    26.506     0.200
     1.077    34.097     0.200
     1.793    54.717     0.200
     0.211     7.444     0.200
     0.468    15.864     0.200
     0.911    30.604     0.200
     1.596    50.234     0.200
     0.245    10.161     0.200
     0.833    27.551     0.200
     0.419    14.456     0.200
     0.872    29.667     0.200
     0.938    31.197     0.200
     1.572    48.656     0.200
     1.841    56.056     0.200
     2.128    63.427     0.200
     0.398    13.975     0.200
     0.740    24.955     0.200
     0.336    11.815     0.200
     1.632    50.315     0.200
     1.804    55.956     0.200
     0.344    11.863     0.200
     0.711    24.473     0.200
     0.404    14.121     0.200
     0.745    24.691     0.200
     1.199    38.871     0.200
     1.659    52.571     0.200
     1.659    53.151     0.200
     1.763    55.730     0.200
     2.104    64.230     0.200
     2.249    70.791     0.200
     2.249    69.750     0.200
     3.153    96.721     0.200
     4.149   121.121     0.200
     0.427    15.171     0.200
     0.819    28.492     0.200
     0.422    15.524     0.200
     0.850    28.064     0.200
     0.981    32.354     0.200
     0.326    11.125     0.200
     0.350    12.535     0.200
     1.004    33.064     0.200
     1.563    48.584     0.200
     0.235     7.935     0.200
     0.444    15.425     0.200
     0.872    29.295     0.200
     0.931    31.045     0.200
     1.590    49.415     0.200
     2.107    64.545     0.200
     3.153    91.235     0.200
     0.208     7.602     0.200
     0.591    20.592     0.200
     0.628    21.441     0.200
     0.465    15.602     0.200
     0.886    30.302     0.200
     1.333    43.122     0.200
     2.083    63.842     0.200
     2.219    67.082     0.200
     0.186     7.921     0.200
     0.611    21.161     0.200
     0.615    20.831     0.200
     1.380    42.091     0.200
     1.927    57.561     0.200
     2.065    62.481     0.200
     2.252    66.081     0.200
     2.313    67.971     0.200
     2.840    83.211     0.200
     3.072    88.681     0.200
     3.234    96.231     0.200
     0.170     6.612     0.200
     0.476    16.552     0.200
     0.859    29.472     0.200
     0.942    32.652     0.200
     1.861    57.592     0.200
     2.451    72.882     0.200
     3.142    94.672     0.200
     0.367    12.777     0.200
     0.403    14.247     0.200
     0.276    10.279     0.200
     0.412    14.149     0.200
     0.841    29.079     0.200
     1.593    49.390     0.200
     3.162    93.600     0.200
     3.206    93.839     0.200
     0.423    14.688     0.200
     0.861    28.828     0.200
     0.947    30.798     0.200
     2.129    64.678     0.200
     0.375    13.330     0.200
     0.847    29.930     0.200
     0.978    33.819     0.200
     1.852    57.159     0.200
     0.323    12.074     0.200
     0.678    23.584     0.200
     1.656    51.395     0.200
     1.330    41.089     0.200
     1.799    55.068     0.200
     0.567    20.241     0.200
     0.678    23.381     0.200
     0.847    28.777     0.200
     0.955    30.518     0.200
     1.603    49.298     0.200
     2.125    65.058     0.200
     3.142    93.928     0.200
     3.186    91.622     0.200
     0.471    15.922     0.200
     0.965    32.361     0.200
     1.526    47.752     0.200
     0.756    27.141     0.200
     1.039    34.051     0.200
     1.519    47.432     0.200
     2.352    70.061     0.200
     3.126    93.711     0.200
     0.562    19.330     0.200
     0.734    25.209     0.200
     1.921    59.219     0.200
     1.958    60.570     0.200
     2.225    67.250     0.200
     2.334    70.549     0.200
     3.130    94.160     0.200
     3.178    94.979     0.200
     3.178    93.070     0.200
     0.328    11.514     0.200
     0.683    23.014     0.200
     1.655    52.094     0.200
     0.290    11.152     0.200
     0.712    23.062     0.200
     2.370    74.682     0.200
     3.271    99.023     0.200
     0.587    19.689     0.200
     0.651    22.160     0.200
     0.721    24.639     0.200
     0.460    15.365     0.200
     0.469    16.498     0.200
     3.598   107.979     0.200
     0.589    19.854     0.200
     0.638    22.154     0.200
     1.541    47.875     0.200
     1.858    55.613     0.200
     2.318    69.033     0.200
     3.260    93.414     0.200
     0.388    14.264     0.200
     0.867    28.982     0.200
     0.954    31.623     0.200
     2.156    64.854     0.200
     2.289    67.873     0.200
     2.554    74.572     0.200
     3.194    96.104     0.200
     0.459    15.340     0.200
     0.873    30.262     0.200
     1.600    49.852     0.200
     1.812    57.270     0.200
     2.094    63.672     0.200
     2.221    67.109     0.200
     2.181    68.742     0.200
     0.415    14.770     0.200
     0.720    24.828     0.200
     1.084    35.949     0.200
     2.239    67.680     0.200
     2.652    79.012     0.200
     3.142    93.602     0.200
     3.184    94.121     0.200
     0.384    13.320     0.200
     0.682    23.020     0.200
     1.688    52.949     0.200
     2.019    63.770     0.200
     2.275    68.770     0.200
     2.708    81.090     0.200
     3.176    96.969     0.200
     3.218    95.559     0.200
     0.530    17.121     0.200
     0.842    28.773     0.200
     1.697    53.293     0.200
     2.182    65.812     0.200
     0.559    19.719     0.200
     0.665    22.777     0.200
     1.884    56.930     0.200
     2.084    64.488     0.200
     1.026    32.941     0.200
     1.679    52.473     0.200
     3.249    98.453     0.200
     0.425    14.617     0.200
     0.701    24.156     0.200
     1.182    38.445     0.200
     1.450    46.688     0.200
     1.701    53.906     0.200
     2.223    69.316     0.200
     3.174    93.867     0.200
     0.777    26.750     0.200
     1.837    56.719     0.200
     3.231    97.750     0.200
     0.471    15.984     0.200
     0.852    29.355     0.200
     2.093    63.965     0.200
     0.573    19.887     0.200
     0.668    21.730     0.200
     2.017    62.070     0.200
     3.197    96.098     0.200
     3.281    95.418     0.200
     0.504    16.980     0.200
     0.768    26.441     0.200
     2.115    64.730     0.200
     2.966    91.090     0.200
     3.099    92.598     0.200
     0.502    17.250     0.200
     1.525    47.379     0.200
     0.437    14.750     0.200
     0.654    22.559     0.200
     1.153    38.629     0.200
     1.414    45.660     0.200
     1.737    54.699     0.200
     2.226    70.699     0.200
     2.252    69.980     0.200
     3.052    90.820     0.200
     0.383    13.449     0.200
     0.443    15.547     0.200
     0.676    23.258     0.200
     1.691    52.680     0.200
     1.747    53.891     0.200
     2.011    62.750     0.200
     2.277    68.527     0.200
     0.358    12.168     0.200
     0.423    15.391     0.200
     0.710    24.590     0.200
     1.132    37.988     0.200
     2.028    63.527     0.200
     2.275    68.988     0.200
     2.298    71.391     0.200
     0.292    10.172     0.200
     0.432    14.824     0.200
     0.808    27.125     0.200
     1.544    48.445     0.200
     1.632    50.895     0.200
     1.782    55.434     0.200
     2.229    66.445     0.200
     3.177    92.004     0.200
     0.335    11.844     0.200
     0.450    15.195     0.200
     0.698    24.125     0.200
     1.101    36.832     0.200
     1.650    52.293     0.200
     1.793    55.984     0.200
     3.225    97.254     0.200
     0.420    14.660     0.200
     0.437    15.031     0.200
     0.674    23.172     0.200
     1.703    53.520     0.200
     1.726    54.070     0.200
     2.045    63.891     0.200
     2.235    67.469     0.200
     2.221    67.371     0.200
     0.191     6.891     0.200
     0.549    18.977     0.200
     0.688    23.484     0.200
     1.412    44.336     0.200
     1.952    59.453     0.200
     2.056    62.820     0.200
     2.266    72.625     0.200
     0.255     8.312     0.200
     0.425    14.406     0.200
     0.858    29.273     0.200
     0.949    32.461     0.200
     1.576    49.484     0.200
     1.588    49.656     0.200
     1.825    56.617     0.200
     2.128    65.117     0.200
     2.249    67.188     0.200
     0.338    11.766     0.200
     0.463    16.047     0.200
     0.684    23.391     0.200
     1.786    57.789     0.200
     1.660    52.492     0.200
     2.324    71.258     0.200
     3.225    97.539     0.200
     3.722   109.180     0.200
     0.572    19.227     0.200
     0.675    23.266     0.200
     0.341    12.227     0.200
     0.464    15.914     0.200
     0.682    23.844     0.200
     1.091    37.016     0.200
     1.155    38.648     0.200
     0.322    11.898     0.200
     0.470    16.242     0.200
     0.690    23.430     0.200
     1.157    38.148     0.200
     1.648    52.188     0.200
     2.340    73.023     0.200
     3.823   111.570     0.200
     0.351    12.539     0.200
     0.398    13.820     0.200
     0.761    26.492     0.200
     2.256    68.914     0.200
     2.203    67.781     0.200
     2.101    64.805     0.200
     3.203    94.406     0.200
     0.387    13.531     0.200
     0.397    13.750     0.200
     0.723    24.242     0.200
     1.757    54.773     0.200
     1.670    51.375     0.200
     2.230    66.586     0.200
     0.150     6.534     0.200
     0.481    16.694     0.200
     0.816    27.124     0.200
     0.993    33.294     0.200
     1.506    47.063     0.200
     1.909    58.354     0.200
     0.209     8.446     0.200
     0.547    19.016     0.200
     0.680    23.196     0.200
     1.157    36.136     0.200
     1.868    58.656     0.200
     2.186    64.966     0.200
     0.624    21.791     0.200
     1.189    37.461     0.200
     1.435    43.851     0.200
     1.499    46.891     0.200
     1.594    49.891     0.200
     2.041    63.701     0.200
     2.158    67.711     0.200
     2.620    78.691     0.200
     2.689    79.371     0.200
     0.439    15.078     0.200
     0.497    16.748     0.200
     0.640    22.828     0.200
     1.192    39.308     0.200
     1.147    38.498     0.200
     1.442    43.508     0.200
     1.505    46.408     0.200
     2.166    67.508     0.200
     0.393    14.170     0.200
     0.405    14.430     0.200
     0.713    24.139     0.200
     1.448    44.309     0.200
     1.583    49.629     0.200
     1.681    52.449     0.200
     1.745    53.889     0.200
     2.249    69.430     0.200
     2.664    78.219     0.200
     3.436    99.260     0.200
     0.162     7.271     0.200
     0.572    20.072     0.200
     0.676    22.912     0.200
     2.194    65.062     0.200
     2.249    68.922     0.200
     3.124    90.432     0.200
     0.336    12.197     0.200
     0.453    15.277     0.200
     0.752    25.717     0.200
     1.514    48.426     0.200
     1.512    47.037     0.200
     1.730    53.727     0.200
     2.601    77.096     0.200
     3.377    98.316     0.200
     0.511    18.053     0.200
     0.711    23.953     0.200
     2.155    64.184     0.200
     0.196     8.254     0.200
     0.534    18.773     0.200
     0.706    23.994     0.200
     1.126    35.453     0.200
     2.055    62.363     0.200
     0.199     8.258     0.200
     0.540    18.568     0.200
     0.695    23.879     0.200
     1.408    43.699     0.200
     2.172    65.408     0.200
     2.269    68.758     0.200
     0.233     8.857     0.200
     0.515    18.107     0.200
     0.709    24.117     0.200
     1.131    35.639     0.200
     1.382    43.238     0.200
     2.157    64.598     0.200
     0.305     9.637     0.200
     0.406    14.379     0.200
     0.808    27.000     0.200
     1.527    48.277     0.200
     1.801    56.457     0.200
     2.584    77.660     0.200
     0.249     9.375     0.200
     0.495    18.105     0.200
     0.728    23.914     0.200
     1.114    35.656     0.200
     1.829    57.164     0.200
     2.105    65.258     0.200
     2.290    69.848     0.200
     3.092    91.098     0.200
     0.207     8.098     0.200
     0.771    25.207     0.200
     0.787    26.988     0.200
     1.612    53.047     0.200
     0.086     6.316     0.200
     0.729    25.617     0.200
     0.690    23.926     0.200
     3.238    95.387     0.200
     0.250     9.395     0.200
     0.557    19.273     0.200
     0.655    22.266     0.200
     1.195    37.336     0.200
     3.027    87.984     0.200
     0.305    10.492     0.200
     0.397    13.984     0.200
     0.815    27.402     0.200
     1.604    49.422     0.200
     1.812    55.453     0.200
     2.145    66.152     0.200
     2.172    65.082     0.200
     2.265    68.223     0.200
     3.828   110.523     0.200
     0.186     6.703     0.200
     0.606    20.594     0.200
     0.619    21.586     0.200
     1.227    38.719     0.200
     1.378    42.734     0.200
     1.935    58.203     0.200
     2.064    63.695     0.200
     2.317    68.883     0.200
     2.501    76.367     0.200
     2.885    87.344     0.200
     0.981    32.289     0.200
     1.605    47.539     0.200
     2.277    68.242     0.200
     3.625   109.141     0.200
     3.691   108.648     0.200
     0.569    19.211     0.200
     0.700    25.062     0.200
     1.468    45.188     0.200
     1.502    49.000     0.200
     1.952    60.258     0.200
     2.313    69.992     0.200
     2.429    75.703     0.200
     0.503    17.788     0.200
     0.586    21.678     0.200
     0.625    21.107     0.200
     1.398    43.878     0.200
     1.470    44.418     0.200
     1.914    59.107     0.200
     2.052    62.788     0.200
     2.690    81.728     0.200
     2.949    88.098     0.200
     0.486    16.726     0.200
     0.594    21.216     0.200
     0.590    19.905     0.200
     1.428    42.525     0.200
     2.084    65.556     0.200
     0.127     6.717     0.200
     0.627    21.627     0.200
     1.200    37.387     0.200
     3.740   108.547     0.200
     0.482    16.447     0.200
     0.500    17.477     0.200
     0.598    20.637     0.200
     2.175    65.586     0.200
     1.318    40.082     0.200
     0.297    12.617     0.200
     1.825    55.781     0.200
     3.204    92.977     0.200
     3.398    99.953     0.200
     0.331    12.082     0.200
     0.454    15.652     0.200
     0.757    26.621     0.200
     1.531    45.941     0.200
     1.732    54.482     0.200
     1.684    52.551     0.200
     2.130    69.482     0.200
     0.155     6.033     0.200
     0.155     6.203     0.200
     0.494    17.424     0.200
     0.849    28.572     0.200
     0.948    31.473     0.200
     1.364    43.693     0.200
     1.384    43.652     0.200
     5.318   157.463     0.200
     0.329    12.244     0.200
     0.446    15.273     0.200
     0.762    26.484     0.200
     1.511    47.213     0.200
     1.516    47.254     0.200
     1.539    46.584     0.200
     1.741    54.623     0.200
     2.208    67.244     0.200
     0.175     6.693     0.200
     0.542    17.764     0.200
     0.883    29.652     0.200
     0.902    31.562     0.200
     1.354    43.344     0.200
     1.396    45.133     0.200
     1.470    43.973     0.200
     1.772    57.113     0.200
     0.522    18.145     0.200
     0.705    23.957     0.200
     1.133    33.645     0.200
     1.845    57.227     0.200
     2.086    62.895     0.200
     0.498    17.168     0.200
     0.756    24.945     0.200
     1.075    33.855     0.200
     1.449    44.117     0.200
     2.045    61.508     0.200
     2.114    61.988     0.200
     0.350    12.996     0.200
     0.364    12.637     0.200
     0.785    27.305     0.200
     1.481    45.527     0.200
     1.606    50.246     0.200
     1.816    56.168     0.200
     2.292    69.707     0.200
     2.630    77.137     0.200
     3.106    91.836     0.200
     0.234    10.469     0.200
     2.121    62.789     0.200
     0.437    15.719     0.200
     0.686    23.959     0.200
     1.628    52.699     0.200
     0.290     9.648     0.200
     0.437    15.230     0.200
     1.483    47.559     0.200
     1.636    50.801     0.200
     2.143    65.180     0.200
     0.278    10.992     0.200
     0.447    16.031     0.200
     1.655    52.102     0.200
     0.354    12.266     0.200
     0.489    17.188     0.200
     1.681    52.969     0.200
     2.365    71.598     0.200
     3.145    93.535     0.200
     0.325    11.914     0.200
     0.496    16.945     0.200
     1.694    53.641     0.200
     2.337    70.953     0.200
     3.286    98.773     0.200
     0.212     8.789     0.200
     0.508    18.641     0.200
     0.737    24.516     0.200
     1.095    35.367     0.200
     0.296    11.008     0.200
     0.436    14.969     0.200
     1.643    52.719     0.200
     2.338    70.312     0.200
     0.389    13.148     0.200
     0.511    17.539     0.200
     1.211    39.867     0.200
     1.694    53.977     0.200
     2.383    72.758     0.200
     0.296    11.000     0.200
     0.419    14.719     0.200
     1.494    47.367     0.200
     2.474    74.695     0.200
     0.322    11.852     0.200
     0.486    16.797     0.200
     1.657    52.117     0.200
     1.685    53.398     0.200
     0.347    12.578     0.200
     0.697    24.048     0.200
     1.640    49.788     0.200
     1.657    51.338     0.200
     1.783    55.398     0.200
     2.007    61.868     0.200
     2.064    61.928     0.200
     2.296    68.498     0.200
     2.293    70.638     0.200
     2.311    68.378     0.200
     2.377    72.158     0.200
     0.315    11.543     0.200
     1.425    43.293     0.200
     1.598    50.793     0.200
     1.613    53.352     0.200
     3.242    96.691     0.200
     0.311    11.676     0.200
     1.679    52.094     0.200
     1.810    57.254     0.200
     2.333    70.746     0.200
     3.295    98.887     0.200
     0.393    13.672     0.200
     0.737    25.141     0.200
     1.460    44.875     0.200
     1.767    55.977     0.200
     2.224    67.930     0.200
     2.261    70.820     0.200
     0.309    11.263     0.200
     0.451    15.763     0.200
     1.534    48.072     0.200
     1.666    52.272     0.200
     0.345    12.113     0.200
     0.495    16.773     0.200
     1.522    46.414     0.200
     0.447    16.375     0.200
     1.384    41.523     0.200
     1.640    50.648     0.200
     2.306    68.680     0.200
     2.359    71.445     0.200
     3.707   107.102     0.200
     0.597    20.375     0.200
     1.236    39.256     0.200
     1.868    56.785     0.200
     3.079    91.914     0.200
     0.442    15.234     0.200
     1.463    45.914     0.200
     3.032    91.945     0.200
     0.430    15.395     0.200
     1.555    49.613     0.200
     1.536    49.441     0.200
     1.677    52.133     0.200
     2.621    79.234     0.200
     0.378    13.497     0.200
     1.500    47.297     0.200
     1.534    47.728     0.200
     1.609    51.848     0.200
     1.606    50.027     0.200
     2.119    66.268     0.200
     2.063    61.768     0.200
     0.328    11.539     0.200
     1.646    51.448     0.200
     1.656    51.969     0.200
     2.046    62.688     0.200
     3.155    93.948     0.200
     3.274    97.294     0.200
     3.826   111.209     0.200
     0.345    12.250     0.200
     1.357    43.777     0.200
     0.429    15.055     0.200
     1.496    46.266     0.200
     1.531    47.926     0.200
     4.099   123.543     0.200
     0.456    15.395     0.200
     1.511    47.293     0.200
     0.552    19.598     0.200
     0.669    22.459     0.200
     1.171    36.539     0.200
     1.635    51.789     0.200
     1.370    42.248     0.200
     2.025    61.699     0.200
     3.056    88.609     0.200
     0.438    15.199     0.200
     2.115    63.750     0.200
     3.547   102.562     0.200
     0.314    10.797     0.200
     1.680    51.883     0.200
     2.031    62.133     0.200
     0.527    17.941     0.200
     0.809    26.801     0.200
     1.323    41.311     0.200
     0.399    13.832     0.200
     0.892    30.070     0.200
     2.005    61.109     0.200
     3.109    92.590     0.200
     3.265    94.773     0.200
     0.827    27.822     0.200
     0.973    33.033     0.200
     1.469    46.092     0.200
     1.622    49.453     0.200
     1.791    54.482     0.200
     2.131    63.863     0.200
     2.179    67.922     0.200
     0.853    29.453     0.200
     0.963    32.164     0.200
     1.840    55.727     0.200
     2.056    62.117     0.200
     2.153    64.922     0.200
     3.080    93.664     0.200
     0.356    12.906     0.200
     0.640    22.406     0.200
     1.196    37.898     0.200
     1.696    52.180     0.200
     1.759    53.953     0.200
     2.319    71.812     0.200
     0.415    14.488     0.200
     0.855    29.281     0.200
     0.955    32.969     0.200
     2.071    62.648     0.200
     2.258    67.352     0.200
     3.063    90.238     0.200
     0.333    11.918     0.200
     0.690    23.465     0.200
     1.090    36.535     0.200
     1.660    51.836     0.200
     1.654    51.258     0.200
     1.792    56.156     0.200
     1.988    61.008     0.200
     2.051    62.238     0.200
     2.329    71.496     0.200
     0.161     6.359     0.200
     0.741    24.629     0.200
     0.932    30.957     0.200
     1.547    48.688     0.200
     1.819    58.316     0.200
     1.868    60.918     0.200
     1.956    62.539     0.200
     2.310    72.859     0.200
     0.512    16.156     0.200
     1.218    40.164     0.200
     1.127    37.914     0.200
     1.485    47.797     0.200
     1.560    50.000     0.200
     2.191    67.633     0.200
     2.973    89.594     0.200
     0.503    16.662     0.200
     0.855    29.572     0.200
     0.939    31.742     0.200
     1.361    43.441     0.200
     1.837    56.781     0.200
     2.111    64.311     0.200
     2.205    66.912     0.200
     2.998    89.361     0.200
     0.445    15.570     0.200
     0.879    29.949     0.200
     0.924    30.629     0.200
     1.434    43.328     0.200
     1.585    48.629     0.200
     1.827    55.141     0.200
     2.221    67.258     0.200
     2.509    74.180     0.200
     0.573    19.835     0.200
     0.658    22.245     0.200
     1.883    56.025     0.200
     2.044    61.105     0.200
     0.601    22.271     0.200
     0.619    20.761     0.200
     1.219    37.961     0.200
     1.929    58.141     0.200
     2.084    62.861     0.200
     2.328    70.351     0.200
     0.548    18.037     0.200
     1.881    58.916     0.200
     2.096    64.967     0.200
     0.310    11.055     0.200
     1.653    51.684     0.200
     1.950    61.414     0.200
     2.032    61.854     0.200
     0.433    14.709     0.200
     0.868    29.469     0.200
     1.456    45.420     0.200
     1.585    49.619     0.200
     2.117    64.340     0.200
     0.342    12.270     0.200
     0.545    18.672     0.200
     0.617    20.793     0.200
     1.017    33.160     0.200
     1.237    40.410     0.200
     1.694    53.750     0.200
     2.062    63.352     0.200
     2.351    74.992     0.200
     0.411    14.867     0.200
     0.673    24.047     0.200
     1.193    37.734     0.200
     2.178    66.805     0.200
     3.135    91.656     0.200
     0.321    11.184     0.200
     0.536    17.953     0.200
     0.755    26.594     0.200
     1.028    35.113     0.200
     1.463    45.523     0.200
     3.295    96.794     0.200
     0.423    14.281     0.200
     0.240     8.398     0.200
     0.451    15.348     0.200
     0.859    29.277     0.200
     1.606    49.947     0.200
     1.806    55.568     0.200
     2.106    64.178     0.200
     2.103    63.838     0.200
     2.223    66.758     0.200
     3.174    92.354     0.200
     0.465    15.920     0.200
     0.630    21.980     0.200
     1.163    38.650     0.200
     1.591    50.130     0.200
     1.770    55.051     0.200
     2.202    66.561     0.200
     2.584    78.190     0.200
     0.506    17.672     0.200
     0.607    21.250     0.200
     1.172    39.051     0.200
     1.508    47.031     0.200
     2.225    67.371     0.200
     3.105    94.156     0.200
     0.393    14.098     0.200
     0.769    26.906     0.200
     1.635    51.547     0.200
     2.087    63.426     0.200
     3.664   110.207     0.200
     0.391    13.539     0.200
     0.802    27.809     0.200
     1.413    45.770     0.200
     1.597    50.246     0.200
     3.216    98.152     0.200
     0.433    14.914     0.200
     0.825    27.996     0.200
     0.977    32.965     0.200
     1.400    43.664     0.200
     2.232    66.855     0.200
     0.346    12.227     0.200
     0.722    25.320     0.200
     1.353    41.891     0.200
     1.486    46.070     0.200
     0.302    11.949     0.200
     0.418    14.498     0.200
     0.805    27.789     0.200
     1.499    46.068     0.200
     1.625    50.248     0.200
     2.242    66.559     0.200
     0.839    28.902     0.200
     1.371    43.373     0.200
     2.195    66.043     0.200
     0.414    14.680     0.200
     0.838    28.477     0.200
     1.480    45.406     0.200
     1.597    48.977     0.200
     2.146    64.664     0.200
     2.253    66.984     0.200
     2.470    76.578     0.200
     3.159    94.930     0.200
     0.251     9.352     0.200
     0.419    14.473     0.200
     0.869    29.652     0.200
     1.574    48.422     0.200
     2.090    64.023     0.200
     2.128    64.383     0.200
     2.199    68.941     0.200
     0.401    13.906     0.200
     0.304    10.477     0.200
     0.813    28.117     0.200
     1.404    44.797     0.200
     1.608    50.711     0.200
     2.040    62.695     0.200
     2.260    69.688     0.200
     3.070    90.625     0.200
     0.270    10.160     0.200
     0.656    22.562     0.200
     0.947    30.812     0.200
     2.368    71.402     0.200
     0.481    16.612     0.200
     1.012    33.852     0.200
     1.402    44.132     0.200
     1.486    46.792     0.200
     2.040    62.272     0.200
     2.276    69.532     0.200
     0.615    20.719     0.200
     1.407    44.078     0.200
     1.919    59.449     0.200
     3.241    97.699     0.200
     0.476    16.266     0.200
     0.697    23.266     0.200
     1.220    39.418     0.200
     1.513    47.188     0.200
     1.533    46.508     0.200
     1.682    53.055     0.200
     1.739    53.785     0.200
     2.178    66.547     0.200
     2.186    66.465     0.200
     0.355    12.633     0.200
     0.687    23.413     0.200
     0.687    22.812     0.200
     1.109    36.143     0.200
     1.109    38.002     0.200
     1.521    46.453     0.200
     1.521    47.712     0.200
     1.668    53.062     0.200
     1.773    56.462     0.200
     1.773    57.453     0.200
     2.305    69.942     0.200
     4.811   145.843     0.200
     0.750    24.963     0.200
     1.020    31.293     0.200
     1.104    33.873     0.200
     1.521    48.072     0.200
     1.415    43.312     0.200
     1.694    51.393     0.200
     2.378    68.799     0.200
     2.385    71.953     0.200
     3.344    95.674     0.200
     0.558    19.102     0.200
     0.787    27.891     0.200
     1.002    35.523     0.200
     1.551    48.891     0.200
     2.184    67.180     0.200
     2.184    68.383     0.200
     0.462    17.457     0.200
     0.645    20.906     0.200
     0.803    25.922     0.200
     2.573    76.094     0.200
     0.289    10.498     0.200
     0.441    14.998     0.200
     0.807    27.078     0.200
     0.991    33.598     0.200
     1.639    51.258     0.200
     2.022    61.459     0.200
     2.140    64.469     0.200
     2.219    69.738     0.200
     0.266     9.918     0.200
     0.857    28.848     0.200
     1.473    45.637     0.200
     1.577    49.188     0.200
     1.837    56.090     0.200
     2.063    61.988     0.200
     2.184    67.938     0.200
     2.143    64.277     0.200
     2.266    68.297     0.200
     3.071    89.918     0.200
     0.173     6.879     0.200
     0.399    13.398     0.200
     0.442    14.989     0.200
     0.485    16.719     0.200
     0.770    25.349     0.200
     0.927    31.309     0.200
     1.499    46.778     0.200
     1.572    48.969     0.200
     1.840    57.259     0.200
     2.052    62.739     0.200
     2.127    65.479     0.200
     2.099    63.489     0.200
     0.361    13.000     0.200
     0.656    21.691     0.200
     1.049    33.488     0.200
     1.179    38.180     0.200
     1.319    42.000     0.200
     0.076     3.943     0.200
     0.446    14.783     0.200
     0.663    23.723     0.200
     0.768    24.493     0.200
     0.948    32.003     0.200
     1.001    34.333     0.200
     1.499    46.843     0.200
     0.158     4.875     0.200
     1.531    48.844     0.200
     1.782    56.672     0.200
     0.212     9.738     0.200
     0.338    12.520     0.200
     0.517    19.469     0.200
     0.609    20.469     0.200
     0.730    24.758     0.200
     0.936    31.426     0.200
     1.052    32.938     0.200
     1.457    47.438     0.200
     1.630    49.758     0.200
     1.866    58.699     0.200
     1.808    55.656     0.200
     2.036    61.527     0.200
     2.452    72.098     0.200
     2.693    79.020     0.200
     3.241    95.039     0.200
     0.264     8.652     0.200
     0.352    12.012     0.200
     0.383    13.172     0.200
     0.428    14.492     0.200
     0.856    28.531     0.200
     0.845    28.633     0.200
     0.845    28.473     0.200
     1.378    43.902     0.200
     1.466    45.652     0.200
     2.087    63.262     0.200
     2.186    67.172     0.200
     0.420    14.469     0.200
     0.961    33.461     0.200
     1.471    44.758     0.200
     2.183    68.320     0.200
     2.669    78.559     0.200
     0.260     9.602     0.200
     0.421    14.844     0.200
     0.856    28.484     0.200
     1.366    43.477     0.200
     1.826    56.094     0.200
     2.076    62.594     0.200
     0.281     9.762     0.200
     0.363    12.441     0.200
     0.413    14.293     0.200
     0.590    19.871     0.200
     0.753    25.512     0.200
     0.774    25.812     0.200
     0.915    30.051     0.200
     1.445    44.801     0.200
     1.773    55.164     0.200
     2.122    66.262     0.200
     2.230    70.684     0.200
     2.242    67.633     0.200
     0.345    11.883     0.200
     0.736    25.242     0.200
     0.736    24.953     0.200
     1.053    34.641     0.200
     1.249    41.812     0.200
     2.176    70.773     0.200
     2.175    67.492     0.200
     0.133     7.928     0.200
     0.582    19.688     0.200
     1.068    32.158     0.200
     1.163    35.168     0.200
     1.476    45.648     0.200
     1.459    48.258     0.200
     1.642    49.107     0.200
     1.565    47.938     0.200
     1.818    56.658     0.200
     2.426    71.547     0.200
     0.368    12.776     0.200
     0.453    15.286     0.200
     0.832    26.896     0.200
     0.854    28.986     0.200
     0.944    32.286     0.200
     1.442    44.306     0.200
     2.107    63.706     0.200
     2.107    64.076     0.200
     0.466    15.887     0.200
     0.767    25.066     0.200
     0.846    27.836     0.200
     1.262    39.926     0.200
     1.395    42.625     0.200
     1.528    49.988     0.200
     2.599    76.977     0.200
     0.977    30.805     0.200
     2.535    76.145     0.200
     0.452    15.352     0.200
     0.804    27.303     0.200
     0.854    28.512     0.200
     0.900    30.633     0.200
     0.904    30.453     0.200
     1.690    51.742     0.200
     1.844    56.082     0.200
     2.088    62.283     0.200
     2.242    66.852     0.200
     2.241    70.613     0.200
     2.699    80.473     0.200
     2.748    81.082     0.200
     0.295    10.797     0.200
     0.350    12.816     0.200
     0.438    14.988     0.200
     0.564    20.137     0.200
     0.877    28.219     0.200
     0.882    30.398     0.200
     1.542    47.918     0.200
     1.588    49.758     0.200
     1.773    54.809     0.200
     2.017    60.336     0.200
     2.145    64.445     0.200
     2.225    67.578     0.200
     2.658    80.398     0.200
     2.672    79.875     0.200
     2.874    85.008     0.200
     0.480    17.965     0.200
     0.619    20.883     0.200
     0.663    22.695     0.200
     0.950    29.812     0.200
     1.143    37.152     0.200
     1.194    37.676     0.200
     1.456    44.652     0.200
     1.480    45.742     0.200
     1.682    52.805     0.200
     2.006    58.742     0.200
     2.522    72.555     0.200
     0.236    11.203     0.200
     0.498    17.785     0.200
     0.588    19.703     0.200
     0.894    29.414     0.200
     0.901    29.102     0.200
     1.062    32.953     0.200
     1.067    33.945     0.200
     1.134    35.184     0.200
     1.235    37.742     0.200
     1.511    46.895     0.200
     1.531    47.914     0.200
     1.530    47.574     0.200
     1.819    55.523     0.200
     2.130    65.633     0.200
     2.275    70.203     0.200
     2.453    71.102     0.200
     2.435    71.273     0.200
     3.069    88.914     0.200
     3.343    99.012     0.200
     3.597   102.562     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.101   101.803     0.200
   106.244  2642.678     0.200
     2.855    90.035     0.200
     2.915    90.188     0.200
     2.708    85.129     0.200
     2.618    82.516     0.200
     2.662    83.125     0.200
     2.769    92.383     0.200
     2.862    88.525     0.200
     3.134    98.677     0.200
     2.528    80.156     0.200
     3.140    99.976     0.200
     3.221   100.686     0.200
     4.148   130.022     0.200
     3.002    93.041     0.200
     2.844    93.219     0.200
     4.246   131.312     0.200
     3.239   104.385     0.200
     3.004    97.799     0.200
     3.129    98.707     0.200
     3.086   100.242     0.200
     3.129    99.410     0.200
     3.134    97.797     0.200
     3.052    98.578     0.200
     3.056    97.281     0.200
     3.126    98.777     0.200
     2.539    81.348     0.200
     3.680   116.371     0.200
     3.133    97.895     0.200
     3.547   110.844     0.200
     2.590    86.301     0.200
     3.046   100.551     0.200
     2.500    78.086     0.200
     3.146    99.742     0.200
     3.165   104.891     0.200
     3.282   106.930     0.200
     2.956    96.326     0.200
     3.194   103.965     0.200
     4.075   125.977     0.200
     4.136   133.590     0.200
     3.027   100.387     0.200
     3.002   100.777     0.200
     2.634    85.805     0.200
     3.075   100.742     0.200
     3.170    98.883     0.200
     4.148   130.289     0.200
     3.023    93.047     0.200
     3.296   101.641     0.200
     4.101   128.102     0.200
     3.007    99.967     0.200
     3.104    98.152     0.200
     3.758   123.104     0.200
     3.109   101.350     0.200
     3.196   103.793     0.200
     3.321   102.535     0.200
     3.173   102.328     0.200
     3.245   101.625     0.200
     2.697    89.000     0.200
     3.192   103.727     0.200
     3.052    96.070     0.200
     3.653   118.461     0.200
     3.171   101.430     0.200
     3.135   103.618     0.200
     3.559   111.242     0.200
     3.178   104.066     0.200
     3.079   100.844     0.200
     3.092   101.167     0.200
     2.567    83.129     0.200
     3.033    96.102     0.200
     3.127   101.461     0.200
     3.288   102.398     0.200
     3.180    99.875     0.200
     3.224   102.844     0.200
     3.271   103.996     0.200
     2.535    80.078     0.200
     3.361   105.988     0.200
     2.571    79.496     0.200
     3.301   103.334     0.200
     3.183   104.641     0.200
     3.289   107.738     0.200
     3.066    99.273     0.200
     2.997    94.371     0.200
     3.659   115.750     0.200
     3.165   103.016     0.200
     3.080    99.359     0.200
     3.253   100.523     0.200
     3.828   121.945     0.200
     3.123   100.848     0.200
     2.968    98.570     0.200
     3.137    97.977     0.200
     2.673    86.602     0.200
     2.540    79.164     0.200
     3.203   104.727     0.200
     3.126    97.957     0.200
     3.632   119.598     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     5.745   168.103     0.200
     0.848    28.008     0.200
     1.079    35.932     0.200
     0.848    28.789     0.200
     2.479    74.289     0.200
     0.868    30.078     0.200
     0.516    18.613     0.200
     2.073    64.613     0.200
     1.084    34.594     0.200
     2.251    71.594     0.200
     2.468    77.656     0.200
     1.932    60.547     0.200
     2.776    83.547     0.200
     0.911    30.135     0.200
     1.592    49.736     0.200
     2.639    76.736     0.200
     2.849    84.436     0.200
     0.989    32.238     0.200
     1.633    51.238     0.200
     2.628    76.336     0.200
     2.788    83.137     0.200
     1.594    49.727     0.200
     2.834    84.227     0.200
     0.442    15.625     0.200
     0.540    19.926     0.200
     0.666    23.117     0.200
     1.202    36.285     0.200
     1.953    58.934     0.200
     0.292    14.334     0.200
     0.864    27.785     0.200
     1.557    48.805     0.200
     2.678    77.445     0.200
     0.831    26.906     0.200
     0.839    27.395     0.200
     2.927    85.926     0.200
     0.171     7.504     0.200
     0.776    27.895     0.200
     0.891    29.623     0.200
     0.347    12.484     0.200
     0.842    28.953     0.200
     1.011    32.297     0.200
     1.891    58.578     0.200
     1.985    60.680     0.200
     2.114    67.266     0.200
     2.368    70.445     0.200
     3.162    93.023     0.200
     1.016    32.602     0.200
     1.102    35.180     0.200
     1.489    48.609     0.200
     2.383    73.828     0.200
     3.019    88.234     0.200
     0.864    27.755     0.200
     0.865    28.074     0.200
     1.312    41.984     0.200
     1.554    48.814     0.200
     1.859    56.545     0.200
     2.673    77.234     0.200
     2.951    88.574     0.200
     0.827    26.846     0.200
     0.844    27.656     0.200
     1.335    41.615     0.200
     1.888    60.006     0.200
     1.997    60.975     0.200
     0.714    23.949     0.200
     1.940    58.641     0.200
     1.906    58.520     0.200
     1.906    57.879     0.200
     2.001    60.172     0.200
     0.204     9.750     0.200
     0.539    18.340     0.200
     1.036    32.371     0.200
     1.262    39.121     0.200
     1.511    46.879     0.200
     2.233    69.090     0.200
     2.402    71.391     0.200
     0.684    22.590     0.200
     0.862    28.539     0.200
     1.862    56.367     0.200
     2.227    66.648     0.200
     2.570    76.988     0.200
     0.392    14.377     0.200
     1.349    42.166     0.200
     1.894    58.857     0.200
     1.925    58.756     0.200
     2.301    72.377     0.200
     1.260    40.474     0.200
     1.970    59.734     0.200
     0.648    21.967     0.200
     1.471    44.847     0.200
     1.542    46.027     0.200
     1.500    46.145     0.200
     2.237    67.039     0.200
     0.494    17.934     0.200
     0.648    22.355     0.200
     0.763    25.664     0.200
     1.323    38.613     0.200
     1.456    44.676     0.200
     1.042    31.875     0.200
     0.353    14.000     0.200
     0.934    29.750     0.200
     1.041    31.832     0.200
     1.654    49.379     0.200
     1.804    55.609     0.200
     2.145    63.031     0.200
     0.463    17.930     0.200
     1.220    38.441     0.200
     1.520    45.852     0.200
     0.943    30.383     0.200
     1.219    37.883     0.200
     1.639    51.516     0.200
     1.713    52.375     0.200
     1.848    56.859     0.200
     3.135    94.117     0.200
     1.492    46.936     0.200
     2.281    67.037     0.200
     0.237    11.406     0.200
     0.488    17.750     0.200
     1.355    42.430     0.200
     1.346    41.695     0.200
     1.381    43.742     0.200
     2.255    65.516     0.200
     0.293    11.307     0.200
     0.804    26.757     0.200
     0.306    11.398     0.200
     0.764    25.558     0.200
     0.303    10.406     0.200
     0.204     8.062     0.200
     0.636    21.662     0.200
     0.352    13.000     0.200
     0.763    25.190     0.200
     1.965    59.460     0.200
     0.745    26.506     0.200
     1.077    34.097     0.200
     1.793    54.717     0.200
     0.211     7.444     0.200
     0.468    15.864     0.200
     0.911    30.604     0.200
     1.596    50.234     0.200
     0.245    10.161     0.200
     0.833    27.551     0.200
     0.419    14.456     0.200
     0.872    29.667     0.200
     0.938    31.197     0.200
     1.572    48.656     0.200
     1.841    56.056     0.200
     2.128    63.427     0.200
     0.398    13.975     0.200
     0.740    24.955     0.200
     0.336    11.815     0.200
     1.632    50.315     0.200
     1.804    55.956     0.200
     0.344    11.863     0.200
     0.711    24.473     0.200
     0.404    14.121     0.200
     0.745    24.691     0.200
     1.199    38.871     0.200
     1.659    52.571     0.200
     1.659    53.151     0.200
     1.763    55.730     0.200
     2.104    64.230     0.200
     2.249    70.791     0.200
     2.249    69.750     0.200
     3.153    96.721     0.200
     4.149   121.121     0.200
     0.427    15.171     0.200
     0.819    28.492     0.200
     0.422    15.524     0.200
     0.850    28.064     0.200
     0.981    32.354     0.200
     0.326    11.125     0.200
     0.350    12.535     0.200
     1.004    33.064     0.200
     1.563    48.584     0.200
     0.235     7.935     0.200
     0.444    15.425     0.200
     0.872    29.295     0.200
     0.931    31.045     0.200
     1.590    49.415     0.200
     2.107    64.545     0.200
     3.153    91.235     0.200
     0.208     7.602     0.200
     0.591    20.592     0.200
     0.628    21.441     0.200
     0.465    15.602     0.200
     0.886    30.302     0.200
     1.333    43.122     0.200
     2.083    63.842     0.200
     2.219    67.082     0.200
     0.186     7.921     0.200
     0.611    21.161     0.200
     0.615    20.831     0.200
     1.380    42.091     0.200
     1.927    57.561     0.200
     2.065    62.481     0.200
     2.252    66.081     0.200
     2.313    67.971     0.200
     2.840    83.211     0.200
     3.072    88.681     0.200
     3.234    96.231     0.200
     0.170     6.612     0.200
     0.476    16.552     0.200
     0.859    29.472     0.200
     0.942    32.652     0.200
     1.861    57.592     0.200
     2.451    72.882     0.200
     3.142    94.672     0.200
     0.367    12.777     0.200
     0.403    14.247     0.200
     0.276    10.279     0.200
     0.412    14.149     0.200
     0.841    29.079     0.200
     1.593    49.390     0.200
     3.162    93.600     0.200
     3.206    93.839     0.200
     0.423    14.688     0.200
     0.861    28.828     0.200
     0.947    30.798     0.200
     2.129    64.678     0.200
     0.375    13.330     0.200
     0.847    29.930     0.200
     0.978    33.819     0.200
     1.852    57.159     0.200
     0.323    12.074     0.200
     0.678    23.584     0.200
     1.656    51.395     0.200
     1.330    41.089     0.200
     1.799    55.068     0.200
     0.567    20.241     0.200
     0.678    23.381     0.200
     0.847    28.777     0.200
     0.955    30.518     0.200
     1.603    49.298     0.200
     2.125    65.058     0.200
     3.142    93.928     0.200
     3.186    91.622     0.200
     0.471    15.922     0.200
     0.965    32.361     0.200
     1.526    47.752     0.200
     0.756    27.141     0.200
     1.039    34.051     0.200
     1.519    47.432     0.200
     2.352    70.061     0.200
     3.126    93.711     0.200
     0.562    19.330     0.200
     0.734    25.209     0.200
     1.921    59.219     0.200
     1.958    60.570     0.200
     2.225    67.250     0.200
     2.334    70.549     0.200
     3.130    94.160     0.200
     3.178    94.979     0.200
     3.178    93.070     0.200
     0.328    11.514     0.200
     0.683    23.014     0.200
     1.655    52.094     0.200
     0.290    11.152     0.200
     0.712    23.062     0.200
     2.370    74.682     0.200
     3.271    99.023     0.200
     0.587    19.689     0.200
     0.651    22.160     0.200
     0.721    24.639     0.200
     0.460    15.365     0.200
     0.469    16.498     0.200
     3.598   107.979     0.200
     0.589    19.854     0.200
     0.638    22.154     0.200
     1.541    47.875     0.200
     1.858    55.613     0.200
     2.318    69.033     0.200
     3.260    93.414     0.200
     0.388    14.264     0.200
     0.867    28.982     0.200
     0.954    31.623     0.200
     2.156    64.854     0.200
     2.289    67.873     0.200
     2.554    74.572     0.200
     3.194    96.104     0.200
     0.459    15.340     0.200
     0.873    30.262     0.200
     1.600    49.852     0.200
     1.812    57.270     0.200
     2.094    63.672     0.200
     2.221    67.109     0.200
     2.181    68.742     0.200
     0.415    14.770     0.200
     0.720    24.828     0.200
     1.084    35.949     0.200
     2.239    67.680     0.200
     2.652    79.012     0.200
     3.142    93.602     0.200
     3.184    94.121     0.200
     0.384    13.320     0.200
     0.682    23.020     0.200
     1.688    52.949     0.200
     2.019    63.770     0.200
     2.275    68.770     0.200
     2.708    81.090     0.200
     3.176    96.969     0.200
     3.218    95.559     0.200
     0.530    17.121     0.200
     0.842    28.773     0.200
     1.697    53.293     0.200
     2.182    65.812     0.200
     0.559    19.719     0.200
     0.665    22.777     0.200
     1.884    56.930     0.200
     2.084    64.488     0.200
     1.026    32.941     0.200
     1.679    52.473     0.200
     3.249    98.453     0.200
     0.425    14.617     0.200
     0.701    24.156     0.200
     1.182    38.445     0.200
     1.450    46.688     0.200
     1.701    53.906     0.200
     2.223    69.316     0.200
     3.174    93.867     0.200
     0.777    26.750     0.200
     1.837    56.719     0.200
     3.231    97.750     0.200
     0.471    15.984     0.200
     0.852    29.355     0.200
     2.093    63.965     0.200
     0.573    19.887     0.200
     0.668    21.730     0.200
     2.017    62.070     0.200
     3.197    96.098     0.200
     3.281    95.418     0.200
     0.504    16.980     0.200
     0.768    26.441     0.200
     2.115    64.730     0.200
     2.966    91.090     0.200
     3.099    92.598     0.200
     0.502    17.250     0.200
     1.525    47.379     0.200
     0.437    14.750     0.200
     0.654    22.559     0.200
     1.153    38.629     0.200
     1.414    45.660     0.200
     1.737    54.699     0.200
     2.226    70.699     0.200
     2.252    69.980     0.200
     3.052    90.820     0.200
     0.383    13.449     0.200
     0.443    15.547     0.200
     0.676    23.258     0.200
     1.691    52.680     0.200
     1.747    53.891     0.200
     2.011    62.750     0.200
     2.277    68.527     0.200
     0.358    12.168     0.200
     0.423    15.391     0.200
     0.710    24.590     0.200
     1.132    37.988     0.200
     2.028    63.527     0.200
     2.275    68.988     0.200
     2.298    71.391     0.200
     0.292    10.172     0.200
     0.432    14.824     0.200
     0.808    27.125     0.200
     1.544    48.445     0.200
     1.632    50.895     0.200
     1.782    55.434     0.200
     2.229    66.445     0.200
     3.177    92.004     0.200
     0.335    11.844     0.200
     0.450    15.195     0.200
     0.698    24.125     0.200
     1.101    36.832     0.200
     1.650    52.293     0.200
     1.793    55.984     0.200
     3.225    97.254     0.200
     0.420    14.660     0.200
     0.437    15.031     0.200
     0.674    23.172     0.200
     1.703    53.520     0.200
     1.726    54.070     0.200
     2.045    63.891     0.200
     2.235    67.469     0.200
     2.221    67.371     0.200
     0.191     6.891     0.200
     0.549    18.977     0.200
     0.688    23.484     0.200
     1.412    44.336     0.200
     1.952    59.453     0.200
     2.056    62.820     0.200
     2.266    72.625     0.200
     0.255     8.312     0.200
     0.425    14.406     0.200
     0.858    29.273     0.200
     0.949    32.461     0.200
     1.576    49.484     0.200
     1.588    49.656     0.200
     1.825    56.617     0.200
     2.128    65.117     0.200
     2.249    67.188     0.200
     0.338    11.766     0.200
     0.463    16.047     0.200
     0.684    23.391     0.200
     1.786    57.789     0.200
     1.660    52.492     0.200
     2.324    71.258     0.200
     3.225    97.539     0.200
     3.722   109.180     0.200
     0.572    19.227     0.200
     0.675    23.266     0.200
     0.341    12.227     0.200
     0.464    15.914     0.200
     0.682    23.844     0.200
     1.091    37.016     0.200
     1.155    38.648     0.200
     0.322    11.898     0.200
     0.470    16.242     0.200
     0.690    23.430     0.200
     1.157    38.148     0.200
     1.648    52.188     0.200
     2.340    73.023     0.200
     3.823   111.570     0.200
     0.351    12.539     0.200
     0.398    13.820     0.200
     0.761    26.492     0.200
     2.256    68.914     0.200
     2.203    67.781     0.200
     2.101    64.805     0.200
     3.203    94.406     0.200
     0.387    13.531     0.200
     0.397    13.750     0.200
     0.723    24.242     0.200
     1.757    54.773     0.200
     1.670    51.375     0.200
     2.230    66.586     0.200
     0.150     6.534     0.200
     0.481    16.694     0.200
     0.816    27.124     0.200
     0.993    33.294     0.200
     1.506    47.063     0.200
     1.909    58.354     0.200
     0.209     8.446     0.200
     0.547    19.016     0.200
     0.680    23.196     0.200
     1.157    36.136     0.200
     1.868    58.656     0.200
     2.186    64.966     0.200
     0.624    21.791     0.200
     1.189    37.461     0.200
     1.435    43.851     0.200
     1.499    46.891     0.200
     1.594    49.891     0.200
     2.041    63.701     0.200
     2.158    67.711     0.200
     2.620    78.691     0.200
     2.689    79.371     0.200
     0.439    15.078     0.200
     0.497    16.748     0.200
     0.640    22.828     0.200
     1.192    39.308     0.200
     1.147    38.498     0.200
     1.442    43.508     0.200
     1.505    46.408     0.200
     2.166    67.508     0.200
     0.393    14.170     0.200
     0.405    14.430     0.200
     0.713    24.139     0.200
     1.448    44.309     0.200
     1.583    49.629     0.200
     1.681    52.449     0.200
     1.745    53.889     0.200
     2.249    69.430     0.200
     2.664    78.219     0.200
     3.436    99.260     0.200
     0.162     7.271     0.200
     0.572    20.072     0.200
     0.676    22.912     0.200
     2.194    65.062     0.200
     2.249    68.922     0.200
     3.124    90.432     0.200
     0.336    12.197     0.200
     0.453    15.277     0.200
     0.752    25.717     0.200
     1.514    48.426     0.200
     1.512    47.037     0.200
     1.730    53.727     0.200
     2.601    77.096     0.200
     3.377    98.316     0.200
     0.511    18.053     0.200
     0.711    23.953     0.200
     2.155    64.184     0.200
     0.196     8.254     0.200
     0.534    18.773     0.200
     0.706    23.994     0.200
     1.126    35.453     0.200
     2.055    62.363     0.200
     0.199     8.258     0.200
     0.540    18.568     0.200
     0.695    23.879     0.200
     1.408    43.699     0.200
     2.172    65.408     0.200
     2.269    68.758     0.200
     0.233     8.857     0.200
     0.515    18.107     0.200
     0.709    24.117     0.200
     1.131    35.639     0.200
     1.382    43.238     0.200
     2.157    64.598     0.200
     0.305     9.637     0.200
     0.406    14.379     0.200
     0.808    27.000     0.200
     1.527    48.277     0.200
     1.801    56.457     0.200
     2.584    77.660     0.200
     0.249     9.375     0.200
     0.495    18.105     0.200
     0.728    23.914     0.200
     1.114    35.656     0.200
     1.829    57.164     0.200
     2.105    65.258     0.200
     2.290    69.848     0.200
     3.092    91.098     0.200
     0.207     8.098     0.200
     0.771    25.207     0.200
     0.787    26.988     0.200
     1.612    53.047     0.200
     0.086     6.316     0.200
     0.729    25.617     0.200
     0.690    23.926     0.200
     3.238    95.387     0.200
     0.250     9.395     0.200
     0.557    19.273     0.200
     0.655    22.266     0.200
     1.195    37.336     0.200
     3.027    87.984     0.200
     0.305    10.492     0.200
     0.397    13.984     0.200
     0.815    27.402     0.200
     1.604    49.422     0.200
     1.812    55.453     0.200
     2.145    66.152     0.200
     2.172    65.082     0.200
     2.265    68.223     0.200
     3.828   110.523     0.200
     0.186     6.703     0.200
     0.606    20.594     0.200
     0.619    21.586     0.200
     1.227    38.719     0.200
     1.378    42.734     0.200
     1.935    58.203     0.200
     2.064    63.695     0.200
     2.317    68.883     0.200
     2.501    76.367     0.200
     2.885    87.344     0.200
     0.981    32.289     0.200
     1.605    47.539     0.200
     2.277    68.242     0.200
     3.625   109.141     0.200
     3.691   108.648     0.200
     0.569    19.211     0.200
     0.700    25.062     0.200
     1.468    45.188     0.200
     1.502    49.000     0.200
     1.952    60.258     0.200
     2.313    69.992     0.200
     2.429    75.703     0.200
     0.503    17.788     0.200
     0.586    21.678     0.200
     0.625    21.107     0.200
     1.398    43.878     0.200
     1.470    44.418     0.200
     1.914    59.107     0.200
     2.052    62.788     0.200
     2.690    81.728     0.200
     2.949    88.098     0.200
     0.486    16.726     0.200
     0.594    21.216     0.200
     0.590    19.905     0.200
     1.428    42.525     0.200
     2.084    65.556     0.200
     0.127     6.717     0.200
     0.627    21.627     0.200
     1.200    37.387     0.200
     3.740   108.547     0.200
     0.482    16.447     0.200
     0.500    17.477     0.200
     0.598    20.637     0.200
     2.175    65.586     0.200
     1.318    40.082     0.200
     0.297    12.617     0.200
     1.825    55.781     0.200
     3.204    92.977     0.200
     3.398    99.953     0.200
     0.331    12.082     0.200
     0.454    15.652     0.200
     0.757    26.621     0.200
     1.531    45.941     0.200
     1.732    54.482     0.200
     1.684    52.551     0.200
     2.130    69.482     0.200
     0.155     6.033     0.200
     0.155     6.203     0.200
     0.494    17.424     0.200
     0.849    28.572     0.200
     0.948    31.473     0.200
     1.364    43.693     0.200
     1.384    43.652     0.200
     5.318   157.463     0.200
     0.329    12.244     0.200
     0.446    15.273     0.200
     0.762    26.484     0.200
     1.511    47.213     0.200
     1.516    47.254     0.200
     1.539    46.584     0.200
     1.741    54.623     0.200
     2.208    67.244     0.200
     0.175     6.693     0.200
     0.542    17.764     0.200
     0.883    29.652     0.200
     0.902    31.562     0.200
     1.354    43.344     0.200
     1.396    45.133     0.200
     1.470    43.973     0.200
     1.772    57.113     0.200
     0.522    18.145     0.200
     0.705    23.957     0.200
     1.133    33.645     0.200
     1.845    57.227     0.200
     2.086    62.895     0.200
     0.498    17.168     0.200
     0.756    24.945     0.200
     1.075    33.855     0.200
     1.449    44.117     0.200
     2.045    61.508     0.200
     2.114    61.988     0.200
     0.350    12.996     0.200
     0.364    12.637     0.200
     0.785    27.305     0.200
     1.481    45.527     0.200
     1.606    50.246     0.200
     1.816    56.168     0.200
     2.292    69.707     0.200
     2.630    77.137     0.200
     3.106    91.836     0.200
     0.234    10.469     0.200
     2.121    62.789     0.200
     0.437    15.719     0.200
     0.686    23.959     0.200
     1.628    52.699     0.200
     0.290     9.648     0.200
     0.437    15.230     0.200
     1.483    47.559     0.200
     1.636    50.801     0.200
     2.143    65.180     0.200
     0.278    10.992     0.200
     0.447    16.031     0.200
     1.655    52.102     0.200
     0.354    12.266     0.200
     0.489    17.188     0.200
     1.681    52.969     0.200
     2.365    71.598     0.200
     3.145    93.535     0.200
     0.325    11.914     0.200
     0.496    16.945     0.200
     1.694    53.641     0.200
     2.337    70.953     0.200
     3.286    98.773     0.200
     0.212     8.789     0.200
     0.508    18.641     0.200
     0.737    24.516     0.200
     1.095    35.367     0.200
     0.296    11.008     0.200
     0.436    14.969     0.200
     1.643    52.719     0.200
     2.338    70.312     0.200
     0.389    13.148     0.200
     0.511    17.539     0.200
     1.211    39.867     0.200
     1.694    53.977     0.200
     2.383    72.758     0.200
     0.296    11.000     0.200
     0.419    14.719     0.200
     1.494    47.367     0.200
     2.474    74.695     0.200
     0.322    11.852     0.200
     0.486    16.797     0.200
     1.657    52.117     0.200
     1.685    53.398     0.200
     0.347    12.578     0.200
     0.697    24.048     0.200
     1.640    49.788     0.200
     1.657    51.338     0.200
     1.783    55.398     0.200
     2.007    61.868     0.200
     2.064    61.928     0.200
     2.296    68.498     0.200
     2.293    70.638     0.200
     2.311    68.378     0.200
     2.377    72.158     0.200
     0.315    11.543     0.200
     1.425    43.293     0.200
     1.598    50.793     0.200
     1.613    53.352     0.200
     3.242    96.691     0.200
     0.311    11.676     0.200
     1.679    52.094     0.200
     1.810    57.254     0.200
     2.333    70.746     0.200
     3.295    98.887     0.200
     0.393    13.672     0.200
     0.737    25.141     0.200
     1.460    44.875     0.200
     1.767    55.977     0.200
     2.224    67.930     0.200
     2.261    70.820     0.200
     0.309    11.263     0.200
     0.451    15.763     0.200
     1.534    48.072     0.200
     1.666    52.272     0.200
     0.345    12.113     0.200
     0.495    16.773     0.200
     1.522    46.414     0.200
     0.447    16.375     0.200
     1.384    41.523     0.200
     1.640    50.648     0.200
     2.306    68.680     0.200
     2.359    71.445     0.200
     3.707   107.102     0.200
     0.597    20.375     0.200
     1.236    39.256     0.200
     1.868    56.785     0.200
     3.079    91.914     0.200
     0.442    15.234     0.200
     1.463    45.914     0.200
     3.032    91.945     0.200
     0.430    15.395     0.200
     1.555    49.613     0.200
     1.536    49.441     0.200
     1.677    52.133     0.200
     2.621    79.234     0.200
     0.378    13.497     0.200
     1.500    47.297     0.200
     1.534    47.728     0.200
     1.609    51.848     0.200
     1.606    50.027     0.200
     2.119    66.268     0.200
     2.063    61.768     0.200
     0.328    11.539     0.200
     1.646    51.448     0.200
     1.656    51.969     0.200
     2.046    62.688     0.200
     3.155    93.948     0.200
     3.274    97.294     0.200
     3.826   111.209     0.200
     0.345    12.250     0.200
     1.357    43.777     0.200
     0.429    15.055     0.200
     1.496    46.266     0.200
     1.531    47.926     0.200
     4.099   123.543     0.200
     0.456    15.395     0.200
     1.511    47.293     0.200
     0.552    19.598     0.200
     0.669    22.459     0.200
     1.171    36.539     0.200
     1.635    51.789     0.200
     1.370    42.248     0.200
     2.025    61.699     0.200
     3.056    88.609     0.200
     0.438    15.199     0.200
     2.115    63.750     0.200
     3.547   102.562     0.200
     0.314    10.797     0.200
     1.680    51.883     0.200
     2.031    62.133     0.200
     0.527    17.941     0.200
     0.809    26.801     0.200
     1.323    41.311     0.200
     0.399    13.832     0.200
     0.892    30.070     0.200
     2.005    61.109     0.200
     3.109    92.590     0.200
     3.265    94.773     0.200
     0.827    27.822     0.200
     0.973    33.033     0.200
     1.469    46.092     0.200
     1.622    49.453     0.200
     1.791    54.482     0.200
     2.131    63.863     0.200
     2.179    67.922     0.200
     0.853    29.453     0.200
     0.963    32.164     0.200
     1.840    55.727     0.200
     2.056    62.117     0.200
     2.153    64.922     0.200
     3.080    93.664     0.200
     0.356    12.906     0.200
     0.640    22.406     0.200
     1.196    37.898     0.200
     1.696    52.180     0.200
     1.759    53.953     0.200
     2.319    71.812     0.200
     0.415    14.488     0.200
     0.855    29.281     0.200
     0.955    32.969     0.200
     2.071    62.648     0.200
     2.258    67.352     0.200
     3.063    90.238     0.200
     0.333    11.918     0.200
     0.690    23.465     0.200
     1.090    36.535     0.200
     1.660    51.836     0.200
     1.654    51.258     0.200
     1.792    56.156     0.200
     1.988    61.008     0.200
     2.051    62.238     0.200
     2.329    71.496     0.200
     0.161     6.359     0.200
     0.741    24.629     0.200
     0.932    30.957     0.200
     1.547    48.688     0.200
     1.819    58.316     0.200
     1.868    60.918     0.200
     1.956    62.539     0.200
     2.310    72.859     0.200
     0.512    16.156     0.200
     1.218    40.164     0.200
     1.127    37.914     0.200
     1.485    47.797     0.200
     1.560    50.000     0.200
     2.191    67.633     0.200
     2.973    89.594     0.200
     0.503    16.662     0.200
     0.855    29.572     0.200
     0.939    31.742     0.200
     1.361    43.441     0.200
     1.837    56.781     0.200
     2.111    64.311     0.200
     2.205    66.912     0.200
     2.998    89.361     0.200
     0.445    15.570     0.200
     0.879    29.949     0.200
     0.924    30.629     0.200
     1.434    43.328     0.200
     1.585    48.629     0.200
     1.827    55.141     0.200
     2.221    67.258     0.200
     2.509    74.180     0.200
     0.573    19.835     0.200
     0.658    22.245     0.200
     1.883    56.025     0.200
     2.044    61.105     0.200
     0.601    22.271     0.200
     0.619    20.761     0.200
     1.219    37.961     0.200
     1.929    58.141     0.200
     2.084    62.861     0.200
     2.328    70.351     0.200
     0.548    18.037     0.200
     1.881    58.916     0.200
     2.096    64.967     0.200
     0.310    11.055     0.200
     1.653    51.684     0.200
     1.950    61.414     0.200
     2.032    61.854     0.200
     0.433    14.709     0.200
     0.868    29.469     0.200
     1.456    45.420     0.200
     1.585    49.619     0.200
     2.117    64.340     0.200
     0.342    12.270     0.200
     0.545    18.672     0.200
     0.617    20.793     0.200
     1.017    33.160     0.200
     1.237    40.410     0.200
     1.694    53.750     0.200
     2.062    63.352     0.200
     2.351    74.992     0.200
     0.411    14.867     0.200
     0.673    24.047     0.200
     1.193    37.734     0.200
     2.178    66.805     0.200
     3.135    91.656     0.200
     0.321    11.184     0.200
     0.536    17.953     0.200
     0.755    26.594     0.200
     1.028    35.113     0.200
     1.463    45.523     0.200
     3.295    96.794     0.200
     0.423    14.281     0.200
     0.240     8.398     0.200
     0.451    15.348     0.200
     0.859    29.277     0.200
     1.606    49.947     0.200
     1.806    55.568     0.200
     2.106    64.178     0.200
     2.103    63.838     0.200
     2.223    66.758     0.200
     3.174    92.354     0.200
     0.465    15.920     0.200
     0.630    21.980     0.200
     1.163    38.650     0.200
     1.591    50.130     0.200
     1.770    55.051     0.200
     2.202    66.561     0.200
     2.584    78.190     0.200
     0.506    17.672     0.200
     0.607    21.250     0.200
     1.172    39.051     0.200
     1.508    47.031     0.200
     2.225    67.371     0.200
     3.105    94.156     0.200
     0.393    14.098     0.200
     0.769    26.906     0.200
     1.635    51.547     0.200
     2.087    63.426     0.200
     3.664   110.207     0.200
     0.391    13.539     0.200
     0.802    27.809     0.200
     1.413    45.770     0.200
     1.597    50.246     0.200
     3.216    98.152     0.200
     0.433    14.914     0.200
     0.825    27.996     0.200
     0.977    32.965     0.200
     1.400    43.664     0.200
     2.232    66.855     0.200
     0.346    12.227     0.200
     0.722    25.320     0.200
     1.353    41.891     0.200
     1.486    46.070     0.200
     0.302    11.949     0.200
     0.418    14.498     0.200
     0.805    27.789     0.200
     1.499    46.068     0.200
     1.625    50.248     0.200
     2.242    66.559     0.200
     0.839    28.902     0.200
     1.371    43.373     0.200
     2.195    66.043     0.200
     0.414    14.680     0.200
     0.838    28.477     0.200
     1.480    45.406     0.200
     1.597    48.977     0.200
     2.146    64.664     0.200
     2.253    66.984     0.200
     2.470    76.578     0.200
     3.159    94.930     0.200
     0.251     9.352     0.200
     0.419    14.473     0.200
     0.869    29.652     0.200
     1.574    48.422     0.200
     2.090    64.023     0.200
     2.128    64.383     0.200
     2.199    68.941     0.200
     0.401    13.906     0.200
     0.304    10.477     0.200
     0.813    28.117     0.200
     1.404    44.797     0.200
     1.608    50.711     0.200
     2.040    62.695     0.200
     2.260    69.688     0.200
     3.070    90.625     0.200
     0.270    10.160     0.200
     0.656    22.562     0.200
     0.947    30.812     0.200
     2.368    71.402     0.200
     0.481    16.612     0.200
     1.012    33.852     0.200
     1.402    44.132     0.200
     1.486    46.792     0.200
     2.040    62.272     0.200
     2.276    69.532     0.200
     0.615    20.719     0.200
     1.407    44.078     0.200
     1.919    59.449     0.200
     3.241    97.699     0.200
     0.476    16.266     0.200
     0.697    23.266     0.200
     1.220    39.418     0.200
     1.513    47.188     0.200
     1.533    46.508     0.200
     1.682    53.055     0.200
     1.739    53.785     0.200
     2.178    66.547     0.200
     2.186    66.465     0.200
     0.355    12.633     0.200
     0.687    23.413     0.200
     0.687    22.812     0.200
     1.109    36.143     0.200
     1.109    38.002     0.200
     1.521    46.453     0.200
     1.521    47.712     0.200
     1.668    53.062     0.200
     1.773    56.462     0.200
     1.773    57.453     0.200
     2.305    69.942     0.200
     4.811   145.843     0.200
     0.750    24.963     0.200
     1.020    31.293     0.200
     1.104    33.873     0.200
     1.521    48.072     0.200
     1.415    43.312     0.200
     1.694    51.393     0.200
     2.378    68.799     0.200
     2.385    71.953     0.200
     3.344    95.674     0.200
     0.558    19.102     0.200
     0.787    27.891     0.200
     1.002    35.523     0.200
     1.551    48.891     0.200
     2.184    67.180     0.200
     2.184    68.383     0.200
     0.462    17.457     0.200
     0.645    20.906     0.200
     0.803    25.922     0.200
     2.573    76.094     0.200
     0.289    10.498     0.200
     0.441    14.998     0.200
     0.807    27.078     0.200
     0.991    33.598     0.200
     1.639    51.258     0.200
     2.022    61.459     0.200
     2.140    64.469     0.200
     2.219    69.738     0.200
     0.266     9.918     0.200
     0.857    28.848     0.200
     1.473    45.637     0.200
     1.577    49.188     0.200
     1.837    56.090     0.200
     2.063    61.988     0.200
     2.184    67.938     0.200
     2.143    64.277     0.200
     2.266    68.297     0.200
     3.071    89.918     0.200
     0.173     6.879     0.200
     0.399    13.398     0.200
     0.442    14.989     0.200
     0.485    16.719     0.200
     0.770    25.349     0.200
     0.927    31.309     0.200
     1.499    46.778     0.200
     1.572    48.969     0.200
     1.840    57.259     0.200
     2.052    62.739     0.200
     2.127    65.479     0.200
     2.099    63.489     0.200
     0.361    13.000     0.200
     0.656    21.691     0.200
     1.049    33.488     0.200
     1.179    38.180     0.200
     1.319    42.000     0.200
     0.076     3.943     0.200
     0.446    14.783     0.200
     0.663    23.723     0.200
     0.768    24.493     0.200
     0.948    32.003     0.200
     1.001    34.333     0.200
     1.499    46.843     0.200
     0.158     4.875     0.200
     1.531    48.844     0.200
     1.782    56.672     0.200
     0.212     9.738     0.200
     0.338    12.520     0.200
     0.517    19.469     0.200
     0.609    20.469     0.200
     0.730    24.758     0.200
     0.936    31.426     0.200
     1.052    32.938     0.200
     1.457    47.438     0.200
     1.630    49.758     0.200
     1.866    58.699     0.200
     1.808    55.656     0.200
     2.036    61.527     0.200
     2.452    72.098     0.200
     2.693    79.020     0.200
     3.241    95.039     0.200
     0.264     8.652     0.200
     0.352    12.012     0.200
     0.383    13.172     0.200
     0.428    14.492     0.200
     0.856    28.531     0.200
     0.845    28.633     0.200
     0.845    28.473     0.200
     1.378    43.902     0.200
     1.466    45.652     0.200
     2.087    63.262     0.200
     2.186    67.172     0.200
     0.420    14.469     0.200
     0.961    33.461     0.200
     1.471    44.758     0.200
     2.183    68.320     0.200
     2.669    78.559     0.200
     0.260     9.602     0.200
     0.421    14.844     0.200
     0.856    28.484     0.200
     1.366    43.477     0.200
     1.826    56.094     0.200
     2.076    62.594     0.200
     0.281     9.762     0.200
     0.363    12.441     0.200
     0.413    14.293     0.200
     0.590    19.871     0.200
     0.753    25.512     0.200
     0.774    25.812     0.200
     0.915    30.051     0.200
     1.445    44.801     0.200
     1.773    55.164     0.200
     2.122    66.262     0.200
     2.230    70.684     0.200
     2.242    67.633     0.200
     0.345    11.883     0.200
     0.736    25.242     0.200
     0.736    24.953     0.200
     1.053    34.641     0.200
     1.249    41.812     0.200
     2.176    70.773     0.200
     2.175    67.492     0.200
     0.133     7.928     0.200
     0.582    19.688     0.200
     1.068    32.158     0.200
     1.163    35.168     0.200
     1.476    45.648     0.200
     1.459    48.258     0.200
     1.642    49.107     0.200
     1.565    47.938     0.200
     1.818    56.658     0.200
     2.426    71.547     0.200
     0.368    12.776     0.200
     0.453    15.286     0.200
     0.832    26.896     0.200
     0.854    28.986     0.200
     0.944    32.286     0.200
     1.442    44.306     0.200
     2.107    63.706     0.200
     2.107    64.076     0.200
     0.466    15.887     0.200
     0.767    25.066     0.200
     0.846    27.836     0.200
     1.262    39.926     0.200
     1.395    42.625     0.200
     1.528    49.988     0.200
     2.599    76.977     0.200
     0.977    30.805     0.200
     2.535    76.145     0.200
     0.452    15.352     0.200
     0.804    27.303     0.200
     0.854    28.512     0.200
     0.900    30.633     0.200
     0.904    30.453     0.200
     1.690    51.742     0.200
     1.844    56.082     0.200
     2.088    62.283     0.200
     2.242    66.852     0.200
     2.241    70.613     0.200
     2.699    80.473     0.200
     2.748    81.082     0.200
     0.295    10.797     0.200
     0.350    12.816     0.200
     0.438    14.988     0.200
     0.564    20.137     0.200
     0.877    28.219     0.200
     0.882    30.398     0.200
     1.542    47.918     0.200
     1.588    49.758     0.200
     1.773    54.809     0.200
     2.017    60.336     0.200
     2.145    64.445     0.200
     2.225    67.578     0.200
     2.658    80.398     0.200
     2.672    79.875     0.200
     2.874    85.008     0.200
     0.480    17.965     0.200
     0.619    20.883     0.200
     0.663    22.695     0.200
     0.950    29.812     0.200
     1.143    37.152     0.200
     1.194    37.676     0.200
     1.456    44.652     0.200
     1.480    45.742     0.200
     1.682    52.805     0.200
     2.006    58.742     0.200
     2.522    72.555     0.200
     0.236    11.203     0.200
     0.498    17.785     0.200
     0.588    19.703     0.200
     0.894    29.414     0.200
     0.901    29.102     0.200
     1.062    32.953     0.200
     1.067    33.945     0.200
     1.134    35.184     0.200
     1.235    37.742     0.200
     1.511    46.895     0.200
     1.531    47.914     0.200
     1.530    47.574     0.200
     1.819    55.523     0.200
     2.130    65.633     0.200
     2.275    70.203     0.200
     2.453    71.102     0.200
     2.435    71.273     0.200
     3.069    88.914     0.200
     3.343    99.012     0.200
     3.597   102.562     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
