#!/bin/bash
gmt begin bohol1.86_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source bohol1.86'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.960    -1.021     0.200
     0.917    -0.111     0.200
     0.788    -0.101     0.200
     0.784    -0.104     0.200
     0.848     0.182     0.200
     0.832     0.057     0.200
     0.879    -0.310     0.200
     0.848    -0.138     0.200
     0.868    -0.172     0.200
     0.936    -0.413     0.200
     0.516    -0.152     0.200
     0.999     0.118     0.200
     0.679    -0.970     0.200
     0.825     0.327     0.200
     0.669    -0.562     0.200
     0.862    -0.638     0.200
     0.598    -0.608     0.200
     0.596    -1.274     0.200
     0.704     0.002     0.200
     0.911     0.009     0.200
     0.936     0.074     0.200
     0.586    -1.325     0.200
     0.654     0.258     0.200
     0.956    -0.497     0.200
     0.989    -0.657     0.200
     0.710    -0.445     0.200
     0.909    -0.044     0.200
     0.922     0.332     0.200
     0.442    -0.536     0.200
     0.956    -1.367     0.200
     0.540     0.206     0.200
     0.666    -0.264     0.200
     0.292    -0.369     0.200
     0.316     0.409     0.200
     0.831    -0.434     0.200
     0.839    -0.120     0.200
     0.171    -0.154     0.200
     0.858    -1.834     0.200
     0.776     0.096     0.200
     0.891    -0.929     0.200
     0.347    -0.038     0.200
     0.842     0.111     0.200
     0.864    -0.211     0.200
     0.865     0.040     0.200
     0.327     0.568     0.200
     0.827    -0.375     0.200
     0.844    -0.429     0.200
     0.395     0.530     0.200
     0.714    -0.094     0.200
     0.753     0.094     0.200
     0.204     0.542     0.200
     0.539    -0.255     0.200
     0.527     0.275     0.200
     0.235    -0.078     0.200
     0.684    -0.663     0.200
     0.862    -0.439     0.200
     0.854    -0.736     0.200
     0.392     0.792     0.200
     0.761    -0.414     0.200
     0.797     0.036     0.200
     0.481     0.456     0.200
     0.654    -0.615     0.200
     0.758    -0.329     0.200
     0.485    -0.043     0.200
     0.648    -0.289     0.200
     0.752     0.059     0.200
     0.518    -0.070     0.200
     0.262    -0.684     0.200
     0.494    -0.079     0.200
     0.648    -0.260     0.200
     0.763    -0.416     0.200
     0.550     0.372     0.200
     0.711    -0.219     0.200
     0.736    -0.778     0.200
     0.353     0.560     0.200
     0.934    -0.334     0.200
     0.463    -0.426     0.200
     0.508    -0.338     0.200
     0.888    -0.065     0.200
     0.943    -0.223     0.200
     0.988     0.304     0.200
     0.488    -0.383     0.200
     0.293    -0.018     0.200
     0.437    -0.176     0.200
     0.804    -0.387     0.200
     0.764    -0.068     0.200
     0.303    -0.103     0.200
     0.204    -0.072     0.200
     0.636     0.366     0.200
     0.352    -0.310     0.200
     0.700    -0.185     0.200
     0.763     0.504     0.200
     0.745    -0.602     0.200
     0.211     0.109     0.200
     0.468     0.214     0.200
     0.911     0.419     0.200
     0.245    -0.555     0.200
     0.833     0.193     0.200
     0.938    -0.104     0.200
     0.398     0.096     0.200
     0.740     0.102     0.200
     0.670     0.078     0.200
     0.336    -0.286     0.200
     0.725    -0.738     0.200
     0.344    -0.341     0.200
     0.711    -0.102     0.200
     0.362     0.738     0.200
     0.404    -0.020     0.200
     0.212    -0.895     0.200
     0.427    -0.001     0.200
     0.819     0.787     0.200
     0.422     0.032     0.200
     0.850     0.234     0.200
     0.981    -0.080     0.200
     0.326     0.848     0.200
     0.350    -0.046     0.200
     0.235     0.176     0.200
     0.444     0.188     0.200
     0.872    -0.079     0.200
     0.931     0.729     0.200
     0.208     0.346     0.200
     0.628     0.019     0.200
     0.213     0.809     0.200
     0.465     0.197     0.200
     0.886    -0.230     0.200
     0.186    -0.475     0.200
     0.611    -0.135     0.200
     0.615    -0.251     0.200
     0.859     0.652     0.200
     0.942    -0.615     0.200
     0.367    -0.085     0.200
     0.403     0.234     0.200
     0.276    -0.228     0.200
     0.412    -0.196     0.200
     0.841    -0.138     0.200
     0.423    -0.314     0.200
     0.861    -0.072     0.200
     0.947    -0.129     0.200
     0.375     0.153     0.200
     0.847    -0.692     0.200
     0.978     0.547     0.200
     0.323    -0.401     0.200
     0.678    -0.537     0.200
     0.924     0.489     0.200
     0.567     0.346     0.200
     0.847    -0.216     0.200
     0.955    -0.002     0.200
     0.965     0.087     0.200
     0.756     0.108     0.200
     0.562    -0.123     0.200
     0.734     0.307     0.200
     0.328    -0.413     0.200
     0.683     0.144     0.200
     0.290    -0.073     0.200
     0.712     0.030     0.200
     0.587     0.384     0.200
     0.651     0.396     0.200
     0.538     0.231     0.200
     0.721     0.244     0.200
     0.460     0.098     0.200
     0.362    -0.268     0.200
     0.698    -0.025     0.200
     0.469    -0.749     0.200
     0.589    -0.491     0.200
     0.638    -0.025     0.200
     0.388    -0.284     0.200
     0.867    -0.645     0.200
     0.954    -0.967     0.200
     0.459     0.102     0.200
     0.474    -0.314     0.200
     0.415     0.112     0.200
     0.720     0.007     0.200
     0.384    -0.017     0.200
     0.682    -0.172     0.200
     0.530     0.282     0.200
     0.842     1.021     0.200
     0.665    -0.252     0.200
     0.429     0.372     0.200
     0.817     0.368     0.200
     0.425     0.243     0.200
     0.701    -0.037     0.200
     0.777    -0.781     0.200
     0.471     0.449     0.200
     0.573     0.098     0.200
     0.668    -0.278     0.200
     0.504    -0.181     0.200
     0.768     0.280     0.200
     0.502     0.120     0.200
     0.809     0.854     0.200
     0.992    -0.120     0.200
     0.437    -0.292     0.200
     0.654    -0.480     0.200
     0.383    -0.134     0.200
     0.443    -0.067     0.200
     0.676     0.240     0.200
     0.358    -0.253     0.200
     0.423     0.301     0.200
     0.710     0.231     0.200
     0.292     0.256     0.200
     0.432    -0.176     0.200
     0.808    -0.141     0.200
     0.992     0.539     0.200
     0.335    -0.016     0.200
     0.450     0.352     0.200
     0.698    -0.018     0.200
     0.420     0.169     0.200
     0.437    -0.219     0.200
     0.674    -0.215     0.200
     0.191     0.070     0.200
     0.549     0.360     0.200
     0.688     0.077     0.200
     0.255     0.374     0.200
     0.425     0.030     0.200
     0.858    -0.020     0.200
     0.949     0.791     0.200
     0.338    -0.002     0.200
     0.163    -0.255     0.200
     0.572    -0.074     0.200
     0.675     0.010     0.200
     0.341    -0.003     0.200
     0.464    -0.084     0.200
     0.682     0.044     0.200
     0.322     0.462     0.200
     0.470     0.152     0.200
     0.351    -0.002     0.200
     0.398    -0.227     0.200
     0.761     0.009     0.200
     0.387     0.013     0.200
     0.397    -0.350     0.200
     0.723    -0.062     0.200
     0.150     0.246     0.200
     0.481     0.093     0.200
     0.816     0.782     0.200
     0.993    -0.161     0.200
     0.209    -0.236     0.200
     0.547     0.064     0.200
     0.680    -0.309     0.200
     0.624     0.073     0.200
     0.439     0.932     0.200
     0.497     0.106     0.200
     0.640     0.401     0.200
     0.393     0.009     0.200
     0.713    -0.067     0.200
     0.162    -0.325     0.200
     0.572    -0.054     0.200
     0.676    -0.167     0.200
     0.336     0.248     0.200
     0.453    -0.150     0.200
     0.752     0.163     0.200
     0.241    -0.714     0.200
     0.511     0.009     0.200
     0.711    -0.208     0.200
     0.196    -0.009     0.200
     0.534    -0.394     0.200
     0.706    -0.222     0.200
     0.199    -0.189     0.200
     0.540    -0.136     0.200
     0.695    -0.075     0.200
     0.233    -0.158     0.200
     0.515     0.325     0.200
     0.709    -0.011     0.200
     0.305     0.260     0.200
     0.406    -0.105     0.200
     0.808    -0.280     0.200
     0.249    -0.032     0.200
     0.495     0.752     0.200
     0.728    -0.124     0.200
     0.207     0.214     0.200
     0.771    -0.254     0.200
     0.787     0.418     0.200
     0.086    -0.658     0.200
     0.729     0.839     0.200
     0.690    -0.654     0.200
     0.250    -0.075     0.200
     0.557     0.239     0.200
     0.655    -0.407     0.200
     0.305     0.364     0.200
     0.397     0.134     0.200
     0.815    -0.167     0.200
     0.998     0.415     0.200
     0.186     0.122     0.200
     0.606    -0.000     0.200
     0.619     0.158     0.200
     0.569     0.091     0.200
     0.700     0.437     0.200
     0.503     0.428     0.200
     0.586    -0.167     0.200
     0.625     0.128     0.200
     0.486     0.675     0.200
     0.594    -0.254     0.200
     0.590    -0.224     0.200
     0.127     0.120     0.200
     0.627    -0.767     0.200
     0.482    -0.021     0.200
     0.500    -0.011     0.200
     0.598    -0.520     0.200
     0.530    -0.335     0.200
     0.331    -0.111     0.200
     0.454    -0.147     0.200
     0.757    -0.174     0.200
     0.155    -0.082     0.200
     0.849     0.114     0.200
     0.329     0.215     0.200
     0.446    -0.226     0.200
     0.762    -0.064     0.200
     0.175     0.302     0.200
     0.542    -0.178     0.200
     0.883     0.013     0.200
     0.902     0.556     0.200
     0.215     0.168     0.200
     0.350     0.645     0.200
     0.364    -0.738     0.200
     0.785     0.019     0.200
     0.234    -0.197     0.200
     0.374    -0.046     0.200
     0.437     0.377     0.200
     0.686     0.183     0.200
     0.290     0.323     0.200
     0.437     0.256     0.200
     0.808     0.731     0.200
     0.992     0.772     0.200
     0.278    -0.633     0.200
     0.447    -0.504     0.200
     0.354    -0.303     0.200
     0.489    -0.011     0.200
     0.325    -0.287     0.200
     0.496    -0.441     0.200
     0.212    -0.039     0.200
     0.508    -0.573     0.200
     0.436    -0.062     0.200
     0.389    -0.095     0.200
     0.511    -0.302     0.200
     0.296     0.081     0.200
     0.419     0.030     0.200
     0.322    -0.225     0.200
     0.486    -0.261     0.200
     0.347    -0.527     0.200
     0.697    -0.313     0.200
     0.315     0.350     0.200
     0.311    -0.024     0.200
     0.393     0.247     0.200
     0.737     0.271     0.200
     0.309    -0.227     0.200
     0.451    -0.235     0.200
     0.345    -0.437     0.200
     0.495    -0.218     0.200
     0.447    -0.527     0.200
     0.597     0.148     0.200
     0.442     0.143     0.200
     0.430    -0.094     0.200
     0.378    -0.095     0.200
     0.328    -0.290     0.200
     0.345    -0.367     0.200
     0.429    -0.373     0.200
     0.456    -0.123     0.200
     0.552     0.445     0.200
     0.669    -0.058     0.200
     0.438    -0.674     0.200
     0.996    -0.003     0.200
     0.314    -0.551     0.200
     0.527     0.053     0.200
     0.809     0.357     0.200
     0.399    -0.260     0.200
     0.892     1.013     0.200
     0.827    -0.108     0.200
     0.973    -0.541     0.200
     0.853     0.328     0.200
     0.963    -0.150     0.200
     0.356    -0.297     0.200
     0.640     0.038     0.200
     0.415     0.109     0.200
     0.855     0.092     0.200
     0.955    -0.168     0.200
     0.333    -0.046     0.200
     0.690    -0.179     0.200
     0.161     0.111     0.200
     0.741    -0.414     0.200
     0.512    -0.439     0.200
     0.503    -0.079     0.200
     0.855     0.748     0.200
     0.939     0.242     0.200
     0.445    -0.066     0.200
     0.879     0.128     0.200
     0.924    -0.159     0.200
     0.573     0.468     0.200
     0.658    -0.172     0.200
     0.619     0.283     0.200
     0.548    -0.328     0.200
     0.310    -0.217     0.200
     0.433    -0.037     0.200
     0.868     0.291     0.200
     0.342     0.090     0.200
     0.545    -0.198     0.200
     0.617     0.137     0.200
     0.411     0.259     0.200
     0.673    -0.713     0.200
     0.321     0.196     0.200
     0.536    -0.071     0.200
     0.755     0.175     0.200
     0.613     0.154     0.200
     0.491    -0.484     0.200
     0.423    -0.095     0.200
     0.240     0.476     0.200
     0.451     0.266     0.200
     0.859     0.222     0.200
     0.465     0.109     0.200
     0.630     0.067     0.200
     0.506    -0.180     0.200
     0.607    -0.374     0.200
     0.393    -0.011     0.200
     0.769    -0.816     0.200
     0.391    -0.427     0.200
     0.802    -0.227     0.200
     0.433     0.214     0.200
     0.977     0.381     0.200
     0.346    -0.172     0.200
     0.722    -0.040     0.200
     0.302    -0.492     0.200
     0.418    -0.195     0.200
     0.805     0.088     0.200
     0.357     0.330     0.200
     0.839    -0.243     0.200
     0.414    -0.128     0.200
     0.838    -0.053     0.200
     0.970    -0.064     0.200
     0.251     0.765     0.200
     0.419    -0.450     0.200
     0.869    -0.312     0.200
     0.401     0.042     0.200
     0.304     0.485     0.200
     0.813    -0.352     0.200
     0.270     0.149     0.200
     0.656     0.492     0.200
     0.947    -1.307     0.200
     0.481     0.438     0.200
     0.615     0.438     0.200
     0.476     0.197     0.200
     0.697    -0.170     0.200
     0.355     0.733     0.200
     0.687    -0.246     0.200
     0.696     0.258     0.200
     0.750    -0.167     0.200
     0.558    -0.869     0.200
     0.787    -0.247     0.200
     0.462     0.427     0.200
     0.645    -0.684     0.200
     0.803    -0.885     0.200
     0.861     0.319     0.200
     0.810    -0.328     0.200
     0.289     0.010     0.200
     0.441    -0.114     0.200
     0.807     0.093     0.200
     0.991     0.006     0.200
     0.266    -0.170     0.200
     0.857    -0.076     0.200
     0.955    -0.066     0.200
     0.173     0.023     0.200
     0.399    -0.029     0.200
     0.442    -0.091     0.200
     0.485     0.169     0.200
     0.770    -0.433     0.200
     0.927     0.266     0.200
     0.361     0.345     0.200
     0.656     0.056     0.200
     0.970    -0.083     0.200
     0.446     0.143     0.200
     0.663     0.430     0.200
     0.768    -0.361     0.200
     0.831    -0.763     0.200
     0.158     0.161     0.200
     0.439    -0.166     0.200
     0.339     0.007     0.200
     0.472    -0.047     0.200
     0.677    -0.227     0.200
     0.212    -0.064     0.200
     0.338    -0.196     0.200
     0.517     0.159     0.200
     0.609    -0.127     0.200
     0.730     0.098     0.200
     0.936     0.027     0.200
     0.264     0.180     0.200
     0.352     0.109     0.200
     0.383     0.260     0.200
     0.428     0.124     0.200
     0.856    -0.566     0.200
     0.845    -0.535     0.200
     0.351     0.061     0.200
     0.390     0.008     0.200
     0.420     0.157     0.200
     0.846    -0.560     0.200
     0.860    -0.779     0.200
     0.961    -0.386     0.200
     0.260     0.018     0.200
     0.360     0.145     0.200
     0.396    -0.073     0.200
     0.421     0.302     0.200
     0.856    -0.520     0.200
     0.281     0.062     0.200
     0.331     0.423     0.200
     0.363     0.220     0.200
     0.413     0.211     0.200
     0.774    -0.481     0.200
     0.915    -0.546     0.200
     0.292     0.566     0.200
     0.273     0.034     0.200
     0.345     0.131     0.200
     0.478     0.330     0.200
     0.736    -0.255     0.200
     0.905    -0.694     0.200
     0.133    -0.521     0.200
     0.582    -0.276     0.200
     0.645     0.018     0.200
     0.800     0.255     0.200
     0.822    -0.190     0.200
     0.244     0.039     0.200
     0.368    -0.065     0.200
     0.367     0.164     0.200
     0.453    -0.013     0.200
     0.832    -0.345     0.200
     0.854    -0.486     0.200
     0.944     0.187     0.200
     0.352     0.456     0.200
     0.425     1.000     0.200
     0.466     0.076     0.200
     0.767     0.209     0.200
     0.846    -0.123     0.200
     0.889    -0.458     0.200
     0.977     0.083     0.200
     0.208    -0.274     0.200
     0.462     0.360     0.200
     0.452    -0.145     0.200
     0.405    -0.449     0.200
     0.804     0.075     0.200
     0.806    -0.921     0.200
     0.854    -0.194     0.200
     0.900    -0.356     0.200
     0.904    -0.069     0.200
     0.295    -0.089     0.200
     0.350    -0.257     0.200
     0.438    -0.118     0.200
     0.564     0.363     0.200
     0.789    -0.157     0.200
     0.877    -0.807     0.200
     0.882    -0.117     0.200
     0.997    -0.502     0.200
     0.480    -0.223     0.200
     0.619    -0.574     0.200
     0.663    -0.314     0.200
     0.950    -0.428     0.200
     0.236     0.047     0.200
     0.498    -0.025     0.200
     0.588    -0.443     0.200
     0.894    -0.319     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.864    -1.118     0.200
     0.866    -1.490     0.200
     0.842    -0.831     0.200
     0.913     0.400     0.200
     0.852    -1.433     0.200
     0.942    -0.270     0.200
     0.994    -0.867     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.848    -0.765     0.200
     0.848     0.599     0.200
     0.868     0.988     0.200
     0.516     0.865     0.200
     0.911     0.296     0.200
     0.989     0.307     0.200
     0.442    -0.231     0.200
     0.540     1.092     0.200
     0.666     0.178     0.200
     0.292     0.799     0.200
     0.864    -0.673     0.200
     0.831    -0.292     0.200
     0.839    -0.048     0.200
     0.171     0.347     0.200
     0.776     1.451     0.200
     0.891    -0.131     0.200
     0.347     0.254     0.200
     0.842     0.363     0.200
     0.864    -0.309     0.200
     0.865    -0.020     0.200
     0.827    -0.183     0.200
     0.844     0.129     0.200
     0.714    -0.401     0.200
     0.204     0.794     0.200
     0.539    -0.485     0.200
     0.684    -0.830     0.200
     0.862    -0.376     0.200
     0.392     0.882     0.200
     0.648    -0.215     0.200
     0.494     0.421     0.200
     0.648     0.400     0.200
     0.763     0.387     0.200
     0.353     0.544     0.200
     0.934    -0.297     0.200
     0.463     0.691     0.200
     0.943    -0.062     0.200
     0.237     0.576     0.200
     0.488     0.351     0.200
     0.293     0.014     0.200
     0.804     0.160     0.200
     0.306    -0.766     0.200
     0.764     0.396     0.200
     0.303     0.117     0.200
     0.204    -0.195     0.200
     0.636    -0.234     0.200
     0.352     0.410     0.200
     0.763     0.009     0.200
     0.745     1.595     0.200
     0.211    -0.303     0.200
     0.468    -0.186     0.200
     0.911    -0.256     0.200
     0.245     0.428     0.200
     0.833    -0.043     0.200
     0.419    -0.778     0.200
     0.872     1.260     0.200
     0.938     0.823     0.200
     0.398     0.238     0.200
     0.740    -0.140     0.200
     0.336    -0.267     0.200
     0.344     0.060     0.200
     0.711     0.427     0.200
     0.404     0.376     0.200
     0.745    -0.483     0.200
     0.427     0.392     0.200
     0.819     0.671     0.200
     0.422     0.768     0.200
     0.850    -0.718     0.200
     0.981    -0.111     0.200
     0.326    -0.642     0.200
     0.350     0.017     0.200
     0.235    -1.057     0.200
     0.444    -0.102     0.200
     0.872     0.125     0.200
     0.931     0.106     0.200
     0.208    -0.458     0.200
     0.591     0.264     0.200
     0.628    -0.068     0.200
     0.465    -0.224     0.200
     0.886     0.371     0.200
     0.186    -0.413     0.200
     0.611     0.065     0.200
     0.615    -0.329     0.200
     0.170    -0.032     0.200
     0.476     0.181     0.200
     0.859     0.316     0.200
     0.942     0.972     0.200
     0.367     0.037     0.200
     0.403     0.339     0.200
     0.276     0.054     0.200
     0.412    -0.353     0.200
     0.841     0.799     0.200
     0.423    -0.562     0.200
     0.861     0.583     0.200
     0.947     0.028     0.200
     0.375     0.415     0.200
     0.847     1.291     0.200
     0.978     0.749     0.200
     0.323     0.146     0.200
     0.678     0.284     0.200
     0.567     0.589     0.200
     0.678     0.094     0.200
     0.847     1.081     0.200
     0.955    -0.344     0.200
     0.471    -0.425     0.200
     0.965     0.333     0.200
     0.756     1.347     0.200
     0.562     0.164     0.200
     0.734     0.284     0.200
     0.328    -0.011     0.200
     0.683    -0.239     0.200
     0.290     1.009     0.200
     0.712    -1.070     0.200
     0.587    -0.589     0.200
     0.651    -0.262     0.200
     0.721     0.095     0.200
     0.460    -0.550     0.200
     0.469     0.400     0.200
     0.589    -0.570     0.200
     0.638     0.282     0.200
     0.388     0.206     0.200
     0.867     0.407     0.200
     0.954     0.481     0.200
     0.459    -0.540     0.200
     0.873     0.736     0.200
     0.415     0.526     0.200
     0.720     0.438     0.200
     0.384     0.203     0.200
     0.682    -0.056     0.200
     0.530    -0.928     0.200
     0.842     0.264     0.200
     0.559     0.412     0.200
     0.665     0.002     0.200
     0.425     0.264     0.200
     0.701     0.508     0.200
     0.777     0.296     0.200
     0.471    -0.169     0.200
     0.852     0.502     0.200
     0.573    -0.067     0.200
     0.668    -1.173     0.200
     0.504    -0.060     0.200
     0.768     0.516     0.200
     0.502    -0.111     0.200
     0.437    -0.049     0.200
     0.654     0.471     0.200
     0.383     0.124     0.200
     0.443     0.268     0.200
     0.676     0.257     0.200
     0.358    -0.037     0.200
     0.423     1.032     0.200
     0.710     0.614     0.200
     0.292    -0.413     0.200
     0.432    -0.258     0.200
     0.808    -0.376     0.200
     0.335     0.287     0.200
     0.450    -0.171     0.200
     0.698     0.485     0.200
     0.420     0.263     0.200
     0.437     0.056     0.200
     0.674     0.325     0.200
     0.191    -0.504     0.200
     0.549     0.118     0.200
     0.688     0.020     0.200
     0.255    -0.914     0.200
     0.425    -0.305     0.200
     0.858     0.190     0.200
     0.949     0.540     0.200
     0.338     0.272     0.200
     0.463     0.356     0.200
     0.684     0.281     0.200
     0.572    -0.566     0.200
     0.675     0.079     0.200
     0.341     0.617     0.200
     0.464     0.208     0.200
     0.682     0.827     0.200
     0.322     0.881     0.200
     0.470     0.313     0.200
     0.690     0.120     0.200
     0.351     0.479     0.200
     0.398     0.187     0.200
     0.761     0.755     0.200
     0.387    -0.269     0.200
     0.397    -0.369     0.200
     0.723    -0.495     0.200
     0.150     0.471     0.200
     0.481     0.153     0.200
     0.816    -0.582     0.200
     0.993     0.149     0.200
     0.209     0.210     0.200
     0.547     0.095     0.200
     0.680    -0.080     0.200
     0.624     0.503     0.200
     0.439     0.232     0.200
     0.497    -0.054     0.200
     0.640     1.233     0.200
     0.393     0.453     0.200
     0.405     0.310     0.200
     0.713    -0.144     0.200
     0.162     0.155     0.200
     0.572     0.273     0.200
     0.676    -0.299     0.200
     0.336     0.395     0.200
     0.453    -0.330     0.200
     0.752     0.184     0.200
     0.511     0.148     0.200
     0.711     0.328     0.200
     0.196     0.381     0.200
     0.534     0.264     0.200
     0.706    -0.137     0.200
     0.199     0.138     0.200
     0.540    -0.189     0.200
     0.695     0.041     0.200
     0.233     0.071     0.200
     0.515     0.291     0.200
     0.709    -0.080     0.200
     0.305    -0.720     0.200
     0.406     0.631     0.200
     0.808    -0.249     0.200
     0.249     0.097     0.200
     0.495     0.964     0.200
     0.728    -0.918     0.200
     0.207     0.498     0.200
     0.771    -0.943     0.200
     0.787     0.268     0.200
     0.086     0.108     0.200
     0.729     1.119     0.200
     0.690     0.606     0.200
     0.250    -0.182     0.200
     0.557    -0.034     0.200
     0.655    -0.237     0.200
     0.305    -0.627     0.200
     0.397    -0.034     0.200
     0.815    -0.128     0.200
     0.186    -1.239     0.200
     0.606    -0.379     0.200
     0.619     0.184     0.200
     0.981     0.473     0.200
     0.569    -0.404     0.200
     0.700     1.072     0.200
     0.503     0.626     0.200
     0.586     1.760     0.200
     0.625    -0.108     0.200
     0.486    -0.195     0.200
     0.594     0.763     0.200
     0.590    -0.396     0.200
     0.127     1.272     0.200
     0.627     0.256     0.200
     0.482    -0.198     0.200
     0.500     0.249     0.200
     0.598     0.190     0.200
     0.297     0.350     0.200
     0.331     0.594     0.200
     0.454     0.129     0.200
     0.757     0.993     0.200
     0.155     0.508     0.200
     0.155     0.678     0.200
     0.494     0.673     0.200
     0.849    -0.116     0.200
     0.948    -0.520     0.200
     0.329     1.011     0.200
     0.446     0.130     0.200
     0.762     0.761     0.200
     0.175     0.781     0.200
     0.542    -0.529     0.200
     0.883    -0.132     0.200
     0.902     1.168     0.200
     0.522    -0.091     0.200
     0.705     0.504     0.200
     0.498    -0.376     0.200
     0.756     0.038     0.200
     0.350     0.257     0.200
     0.364    -0.542     0.200
     0.785     0.952     0.200
     0.234     0.397     0.200
     0.437     0.789     0.200
     0.686     0.731     0.200
     0.290    -1.006     0.200
     0.437    -0.073     0.200
     0.278     0.153     0.200
     0.447     0.031     0.200
     0.354    -0.052     0.200
     0.489     0.452     0.200
     0.325     0.267     0.200
     0.496    -0.213     0.200
     0.212     0.472     0.200
     0.508     0.997     0.200
     0.737    -0.647     0.200
     0.296     0.157     0.200
     0.436    -0.318     0.200
     0.389    -0.077     0.200
     0.511     0.215     0.200
     0.296     0.290     0.200
     0.419     0.055     0.200
     0.322     0.303     0.200
     0.486    -0.049     0.200
     0.347    -0.077     0.200
     0.697     0.223     0.200
     0.315     0.887     0.200
     0.311     0.599     0.200
     0.393     0.317     0.200
     0.737     0.264     0.200
     0.309     0.236     0.200
     0.451     0.139     0.200
     0.345     0.245     0.200
     0.495    -0.084     0.200
     0.447     0.356     0.200
     0.597    -0.052     0.200
     0.442     0.086     0.200
     0.430     0.459     0.200
     0.378     0.087     0.200
     0.328     0.150     0.200
     0.345     0.229     0.200
     0.429     0.298     0.200
     0.456    -0.035     0.200
     0.552     0.508     0.200
     0.669    -0.458     0.200
     0.438    -0.139     0.200
     0.314    -0.276     0.200
     0.527    -0.247     0.200
     0.809    -0.742     0.200
     0.399     0.001     0.200
     0.892    -0.170     0.200
     0.827     0.704     0.200
     0.973     1.674     0.200
     0.853     0.667     0.200
     0.963     0.142     0.200
     0.356    -0.039     0.200
     0.640     0.319     0.200
     0.415     0.044     0.200
     0.855     0.273     0.200
     0.955     1.027     0.200
     0.333     0.235     0.200
     0.690     0.001     0.200
     0.161     0.720     0.200
     0.741    -0.392     0.200
     0.932    -0.495     0.200
     0.512    -1.120     0.200
     0.503    -0.465     0.200
     0.855     0.641     0.200
     0.939     0.033     0.200
     0.445    -0.095     0.200
     0.879     0.724     0.200
     0.924     0.051     0.200
     0.573    -0.181     0.200
     0.658    -0.175     0.200
     0.601     1.643     0.200
     0.619    -0.449     0.200
     0.548    -0.616     0.200
     0.310     0.175     0.200
     0.433    -0.329     0.200
     0.868     0.086     0.200
     0.342     0.542     0.200
     0.545     0.180     0.200
     0.617    -0.088     0.200
     0.411     0.615     0.200
     0.673     1.147     0.200
     0.321     0.244     0.200
     0.536    -0.164     0.200
     0.755     1.106     0.200
     0.423    -0.115     0.200
     0.240    -0.616     0.200
     0.451    -0.356     0.200
     0.859     0.306     0.200
     0.465    -0.042     0.200
     0.630     0.556     0.200
     0.506     0.459     0.200
     0.607     0.677     0.200
     0.393     0.436     0.200
     0.769     0.793     0.200
     0.391     0.333     0.200
     0.802     0.783     0.200
     0.433    -0.046     0.200
     0.825     0.028     0.200
     0.977     0.232     0.200
     0.346     0.011     0.200
     0.722     0.732     0.200
     0.302     0.683     0.200
     0.418    -0.387     0.200
     0.805     0.860     0.200
     0.839     0.475     0.200
     0.414    -0.303     0.200
     0.838     0.895     0.200
     0.251    -0.566     0.200
     0.419    -0.554     0.200
     0.869     1.018     0.200
     0.401     0.166     0.200
     0.304    -0.042     0.200
     0.813     0.631     0.200
     0.270     0.361     0.200
     0.656     0.165     0.200
     0.947    -0.859     0.200
     0.481     0.279     0.200
     0.615    -0.207     0.200
     0.476    -0.007     0.200
     0.697    -0.367     0.200
     0.355     0.562     0.200
     0.687     0.216     0.200
     0.687    -0.385     0.200
     0.750     0.164     0.200
     0.558     0.220     0.200
     0.787     1.278     0.200
     0.462     0.730     0.200
     0.645    -0.912     0.200
     0.803    -0.952     0.200
     0.289     0.221     0.200
     0.441    -0.234     0.200
     0.807    -0.312     0.200
     0.991     0.462     0.200
     0.266    -0.015     0.200
     0.857     0.085     0.200
     0.173     0.148     0.200
     0.399    -0.460     0.200
     0.442    -0.265     0.200
     0.485     0.052     0.200
     0.770    -0.781     0.200
     0.927     0.058     0.200
     0.361     0.523     0.200
     0.656    -0.551     0.200
     0.076     0.192     0.200
     0.446    -0.488     0.200
     0.663     1.228     0.200
     0.768    -1.515     0.200
     0.948    -0.035     0.200
     0.158    -0.528     0.200
     0.212     0.545     0.200
     0.338    -0.230     0.200
     0.517     1.276     0.200
     0.609    -0.371     0.200
     0.730     0.426     0.200
     0.936     1.184     0.200
     0.264    -0.740     0.200
     0.352    -0.211     0.200
     0.383    -0.083     0.200
     0.428    -0.226     0.200
     0.856    -0.445     0.200
     0.845     0.018     0.200
     0.845    -0.142     0.200
     0.420    -0.075     0.200
     0.961     1.185     0.200
     0.260     0.241     0.200
     0.421     0.286     0.200
     0.856    -0.528     0.200
     0.281    -0.168     0.200
     0.363    -0.153     0.200
     0.413     0.046     0.200
     0.590    -0.229     0.200
     0.753    -0.029     0.200
     0.774    -0.430     0.200
     0.915    -0.892     0.200
     0.345     0.232     0.200
     0.736     0.446     0.200
     0.736     0.157     0.200
     0.133    -0.212     0.200
     0.582    -0.238     0.200
     0.368    -0.135     0.200
     0.453    -0.395     0.200
     0.832    -1.360     0.200
     0.854     0.004     0.200
     0.944     0.653     0.200
     0.466    -0.274     0.200
     0.767    -1.058     0.200
     0.846    -0.755     0.200
     0.977    -1.543     0.200
     0.452    -0.519     0.200
     0.804     0.153     0.200
     0.854    -0.017     0.200
     0.900     0.747     0.200
     0.904     0.506     0.200
     0.295    -0.132     0.200
     0.350     0.166     0.200
     0.438    -0.440     0.200
     0.564     0.626     0.200
     0.877    -0.959     0.200
     0.882     1.019     0.200
     0.480     0.167     0.200
     0.619    -0.627     0.200
     0.663    -0.050     0.200
     0.950    -0.962     0.200
     0.236     1.090     0.200
     0.498     0.300     0.200
     0.588    -0.387     0.200
     0.894     0.516     0.200
     0.901    -0.000     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.936    -0.372     0.200
     0.758    -0.018     0.200
     0.752     0.135     0.200
     0.711     1.068     0.200
     0.888    -0.766     0.200
     0.988    -0.277     0.200
     0.936    -0.806     0.200
     0.886    -0.302     0.200
     0.924    -0.410     0.200
     0.925    -0.581     0.200
     0.947    -0.181     0.200
     0.817    -0.520     0.200
     0.942    -0.848     0.200
     0.992    -0.787     0.200
     0.992     0.253     0.200
     0.998    -0.630     0.200
     0.808    -1.570     0.200
     0.992    -0.409     0.200
     0.994    -1.696     0.200
     0.996     0.821     0.200
     0.970    -0.644     0.200
     0.955     0.050     0.200
     0.800     0.667     0.200
     0.822     0.590     0.200
     0.806     0.458     0.200
     0.997    -0.090     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.058
 1.00   -0.058
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.801
 1.00   -0.801
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.1
 1.00    0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.3
 1.00   -0.3
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =  -0.1 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.8 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.3 (dashed green line)
EOF
gmt end
