#!/bin/bash
gmt begin bohol1.86_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic bohol1.86'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.912
   138.000     2.011
   138.500     2.112
   139.000     2.217
   139.500     2.326
   140.000     2.439
   140.500     2.556
   141.000     2.677
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.353
   144.000     3.504
   144.500     3.660
   145.000     3.822
   145.500     3.991
   146.000     4.166
   146.500     4.347
   147.000     4.536
   147.500     4.731
   148.000     4.934
   148.500     5.146
   149.000     5.365
   149.500     5.593
   150.000     5.831
   150.500     6.080
   151.000     6.338
   151.500     6.606
   152.000     6.885
   152.500     7.174
   153.000     7.473
   153.500     7.783
   154.000     8.103
   154.500     8.434
   155.000     8.776
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.680
   145.500     0.284
   146.000     1.311
   146.500     2.381
   147.000     3.485
   147.500     4.620
   148.000     5.781
   148.500     6.967
   149.000     8.177
   149.500     9.410
   150.000    10.665
   150.500    11.942
   151.000    13.238
   151.500    14.555
   152.000    15.890
   152.500    17.244
   153.000    18.615
   153.500    20.004
   154.000    21.411
   154.500    22.836
   155.000    24.277
   155.500    25.736
   156.000    27.211
   156.500    28.703
   157.000    30.213
   157.500    31.738
   158.000    33.280
   158.500    34.839
   159.000    36.414
   159.500    38.006
   160.000    39.614
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.684
   145.500     0.081
   146.000     0.774
   146.500     1.415
   147.000     2.014
   147.500     2.573
   148.000     3.098
   148.500     3.590
   149.000     4.056
   149.500     4.501
   150.000     4.932
   150.500     5.349
   151.000     5.755
   151.500     6.152
   152.000     6.541
   152.500     6.922
   153.000     7.297
   153.500     7.669
   154.000     8.037
   154.500     8.404
   155.000     8.769
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   147.606     0.709     0.200
   149.894     2.569     0.200
   152.204     0.024     0.200
   152.302     1.878     0.200
   152.477     2.110     0.200
   152.576     2.012     0.200
   152.824     1.610     0.200
   152.875     1.036     0.200
   153.460    -0.813     0.200
   153.598     1.990     0.200
   155.560     0.267     0.200
   155.844     1.586     0.200
   156.537     1.977     0.200
   157.284     2.022     0.200
   157.295     0.008     0.200
   158.850     1.348     0.200
   151.815    -1.947     0.200
   152.189     1.493     0.200
   152.288     1.347     0.200
   153.646     2.368     0.200
   155.760     2.445     0.200
   155.900     1.159     0.200
   156.594     2.350     0.200
   157.351    -1.616     0.200
   157.338     1.399     0.200
   158.886     0.512     0.200
   151.758    -2.636     0.200
   152.749     1.692     0.200
   146.417    -0.746     0.200
   146.414    -0.850     0.200
   155.065    -0.159     0.200
   137.786     0.358     0.200
   144.649     0.187     0.200
   144.863    -1.059     0.200
   144.863    -1.503     0.200
   145.457    -1.035     0.200
   146.690    -0.121     0.200
   146.690     0.329     0.200
   153.190    -2.954     0.200
   153.263     1.699     0.200
   153.775     2.065     0.200
   154.105     2.418     0.200
   154.445    -0.318     0.200
   154.612     2.980     0.200
   154.784     2.631     0.200
   154.970     2.636     0.200
   155.373    -1.073     0.200
   155.447     0.338     0.200
   155.510     2.142     0.200
   155.687     2.795     0.200
   155.714     2.779     0.200
   155.920     2.874     0.200
   155.930     1.851     0.200
   156.210     2.852     0.200
   156.240     2.812     0.200
   156.294     0.657     0.200
   156.379     2.710     0.200
   156.546     1.008     0.200
   156.792     2.816     0.200
   156.818     3.252     0.200
   157.151     2.837     0.200
   157.503     2.294     0.200
   157.644     0.588     0.200
   157.743     1.816     0.200
   158.260     0.612     0.200
   158.536    -0.930     0.200
   158.645     0.449     0.200
   158.748     2.736     0.200
   159.394     0.234     0.200
   159.741    -0.638     0.200
   159.725    -0.171     0.200
   146.733    -0.943     0.200
   155.267    -0.990     0.200
   155.612    -0.724     0.200
   156.165    -0.930     0.200
   156.188     0.800     0.200
   156.282     1.067     0.200
   157.045    -0.448     0.200
   146.646     0.048     0.200
   146.589    -1.067     0.200
   144.324    -1.086     0.200
   144.897    -0.670     0.200
   146.692     0.318     0.200
   159.694     0.456     0.200
   146.787     0.092     0.200
   146.764     0.847     0.200
   146.693    -2.142     0.200
   151.474    -1.328     0.200
   146.753    -0.404     0.200
   146.732    -1.812     0.200
   146.666     0.790     0.200
   146.675    -1.161     0.200
   147.370    -1.434     0.200
   146.656     0.150     0.200
   144.889    -0.915     0.200
   146.685    -0.681     0.200
   155.399     0.264     0.200
   146.670     1.030     0.200
   147.351    -1.224     0.200
   146.671    -1.744     0.200
   146.622     0.200     0.200
   146.622     0.498     0.200
   146.816     1.632     0.200
   152.482     0.427     0.200
   153.689     1.973     0.200
   154.026     2.675     0.200
   154.359    -0.624     0.200
   155.286     0.300     0.200
   155.347     0.766     0.200
   156.454     0.133     0.200
   156.454     1.178     0.200
   157.060     1.248     0.200
   138.126    -0.655     0.200
   145.190     0.481     0.200
   146.107     0.122     0.200
   146.686     0.222     0.200
   150.625     0.676     0.200
   150.625     0.182     0.200
   151.387    -0.490     0.200
   152.882     0.872     0.200
   153.545     1.301     0.200
   153.560    -0.400     0.200
   153.990     1.887     0.200
   154.020    -0.094     0.200
   154.104     0.797     0.200
   154.425     0.067     0.200
   154.773    -0.026     0.200
   154.949    -0.098     0.200
   155.080     2.373     0.200
   155.119    -0.870     0.200
   155.092     2.356     0.200
   155.172     2.248     0.200
   155.311     0.169     0.200
   155.343     0.355     0.200
   155.352     2.004     0.200
   155.361     1.990     0.200
   155.398     1.941     0.200
   155.703    -0.839     0.200
   155.790    -0.575     0.200
   155.805     0.995     0.200
   155.848     0.098     0.200
   155.863    -0.093     0.200
   156.063    -0.187     0.200
   156.572     0.547     0.200
   156.597     0.515     0.200
   156.596     1.101     0.200
   156.640     1.499     0.200
   156.729    -0.215     0.200
   156.882     1.513     0.200
   157.146     0.091     0.200
   157.486    -0.056     0.200
   157.659     0.178     0.200
   157.983     1.857     0.200
   159.422     0.295     0.200
   159.702    -0.183     0.200
   159.702     0.512     0.200
   136.332     0.070     0.200
   137.804     0.049     0.200
   144.883    -0.461     0.200
   146.721     1.277     0.200
   146.721     1.101     0.200
   147.403     1.269     0.200
   147.557     2.076     0.200
   146.651     0.468     0.200
   146.623     0.232     0.200
   146.684     1.714     0.200
   146.684     1.386     0.200
   146.722     0.568     0.200
   146.751     0.959     0.200
   146.676     1.244     0.200
   146.769     0.316     0.200
   146.634    -0.113     0.200
   146.672     1.666     0.200
   146.672     0.791     0.200
   147.364     2.191     0.200
   146.593    -1.171     0.200
   146.667     0.637     0.200
   159.760     0.704     0.200
   146.613    -0.198     0.200
   146.636     1.077     0.200
   146.636     0.553     0.200
   147.333     1.026     0.200
   151.324    -0.799     0.200
   146.606    -1.237     0.200
   146.694     1.178     0.200
   146.644    -0.795     0.200
   146.613     0.191     0.200
   146.625    -1.178     0.200
   146.693    -0.187     0.200
   146.618     0.695     0.200
   146.618     0.472     0.200
   147.317    -1.288     0.200
   146.468    -0.129     0.200
   146.703     1.139     0.200
   146.703     0.736     0.200
   144.562    -2.094     0.200
   146.641     0.732     0.200
   146.641     0.982     0.200
   147.331     0.762     0.200
   153.177    -2.692     0.200
   146.500     0.006     0.200
   146.623     1.488     0.200
   146.812    -0.185     0.200
   146.643     0.863     0.200
   146.553     0.969     0.200
   146.662     0.543     0.200
   146.764     1.277     0.200
   146.793    -0.634     0.200
   156.067     0.989     0.200
   144.896    -0.861     0.200
   146.697     0.593     0.200
   156.321     0.919     0.200
   146.777     0.244     0.200
   147.452     1.482     0.200
   146.720     0.533     0.200
   146.769    -0.605     0.200
   146.668     0.218     0.200
   146.661    -0.478     0.200
   146.662     0.798     0.200
   146.656     0.720     0.200
   148.534    -1.226     0.200
   146.685     0.269     0.200
   146.752     0.979     0.200
   145.864     0.209     0.200
   145.864    -0.586     0.200
   146.378     0.409     0.200
   146.378    -0.888     0.200
   143.576    -2.467     0.200
   144.079    -2.004     0.200
   146.084    -0.450     0.200
   146.196    -0.648     0.200
   146.196     0.149     0.200
   146.456    -0.752     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   152.859     5.004     0.200
   146.718     1.372     0.200
   146.694     1.366     0.200
   146.782     1.595     0.200
   145.402     0.349     0.200
   150.397     4.194     0.200
   150.397     3.849     0.200
   152.002     5.665     0.200
   152.286     5.331     0.200
   152.420     5.743     0.200
   152.591     4.840     0.200
   153.190     6.746     0.200
   154.147     7.168     0.200
   146.752     1.302     0.200
   145.076    -1.038     0.200
   146.694     1.086     0.200
   146.734     0.961     0.200
   146.734     1.586     0.200
   147.411     2.583     0.200
   151.515     4.008     0.200
   154.506     7.516     0.200
   154.918     8.167     0.200
   146.589     0.963     0.200
   147.374     1.466     0.200
   149.636     3.339     0.200
   146.747     1.138     0.200
   146.732     1.688     0.200
   146.666     1.445     0.200
   146.681     1.356     0.200
   146.675     1.564     0.200
   146.692     1.202     0.200
   146.692     1.502     0.200
   146.685     1.395     0.200
   152.587     6.258     0.200
   146.636     1.112     0.200
   146.671     0.958     0.200
   146.653     1.015     0.200
   146.629     1.140     0.200
   146.629     0.990     0.200
   147.305     1.856     0.200
   149.511     3.984     0.200
   149.511     3.254     0.200
   145.205    -0.436     0.200
   145.205    -0.295     0.200
   145.296     0.088     0.200
   149.939     4.714     0.200
   150.625     5.227     0.200
   150.625     5.081     0.200
   151.387     5.510     0.200
   151.481     4.455     0.200
   146.751     1.502     0.200
   146.667     1.387     0.200
   146.605     1.416     0.200
   146.606     1.262     0.200
   151.410     4.529     0.200
   146.630     1.251     0.200
   146.613     1.536     0.200
   151.301     4.611     0.200
   146.693     1.364     0.200
   150.081     4.414     0.200
   151.297     4.431     0.200
   146.713     1.694     0.200
   150.607     4.266     0.200
   153.163     4.648     0.200
   146.692     1.258     0.200
   151.422     4.727     0.200
   146.622     0.626     0.200
   146.793     1.421     0.200
   146.575     0.537     0.200
   146.803     1.560     0.200
   146.803     1.388     0.200
   146.742     1.383     0.200
   147.348     2.688     0.200
   149.365     4.366     0.200
   146.680     0.986     0.200
   146.697     1.168     0.200
   147.379     2.126     0.200
   150.623     5.248     0.200
   151.455     5.190     0.200
   146.777     1.486     0.200
   151.566     5.061     0.200
   146.619     1.005     0.200
   146.708     1.196     0.200
   146.667     1.082     0.200
   146.667     1.277     0.200
   146.561     0.836     0.200
   146.656     1.230     0.200
   146.689     1.556     0.200
   146.655     1.489     0.200
   146.752     1.439     0.200
   146.422     0.819     0.200
   145.150    -1.142     0.200
   151.106     4.791     0.200
   146.660     1.128     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.970     6.977     0.200
   156.273    29.253     0.200
   149.594     8.045     0.200
   166.055    64.475     0.200
   166.657    66.336     0.200
   163.933    53.172     0.200
   146.290     1.115     0.200
   145.988     0.527     0.200
   163.160    49.984     0.200
   146.374     1.404     0.200
   146.384     1.231     0.200
   146.210     1.147     0.200
   145.732     0.913     0.200
   145.779     0.943     0.200
   151.717    19.413     0.200
   162.294    46.904     0.200
   163.614    51.256     0.200
   164.728    54.108     0.200
   166.560    62.952     0.200
   170.050    73.281     0.200
   170.050    72.156     0.200
   170.383    75.638     0.200
   172.166    83.063     0.200
   156.188    26.900     0.200
   166.530    63.229     0.200
   169.951    75.042     0.200
   163.606    49.780     0.200
   166.584    63.525     0.200
   166.584    61.200     0.200
   166.584    61.430     0.200
   170.073    75.609     0.200
   146.693     1.908     0.200
   166.502    61.747     0.200
   163.494    50.353     0.200
   166.572    64.973     0.200
   163.592    49.246     0.200
   146.783     2.142     0.200
   146.667     1.989     0.200
   146.670     1.966     0.200
   147.511     3.434     0.200
   150.579    10.780     0.200
   155.596    26.822     0.200
   163.587    51.160     0.200
   166.438    62.823     0.200
   170.476    76.339     0.200
   172.071    83.688     0.200
   145.698     1.040     0.200
   145.789     1.413     0.200
   145.904     1.589     0.200
   146.027     1.248     0.200
   150.625    13.282     0.200
   156.573    30.386     0.200
   157.983    36.383     0.200
   157.993    33.695     0.200
   158.505    34.654     0.200
   159.422    38.494     0.200
   159.702    41.118     0.200
   159.702    40.862     0.200
   160.157    41.480     0.200
   162.424    49.311     0.200
   162.424    49.856     0.200
   163.512    50.364     0.200
   163.512    50.915     0.200
   164.773    54.755     0.200
   166.782    66.270     0.200
   166.782    66.133     0.200
   170.045    75.836     0.200
   170.294    76.180     0.200
   172.269    84.324     0.200
   173.150    87.914     0.200
   163.637    50.884     0.200
   166.601    65.368     0.200
   146.651     1.745     0.200
   166.479    63.383     0.200
   146.601     1.729     0.200
   146.601     1.839     0.200
   166.524    64.744     0.200
   146.605     1.713     0.200
   150.713    13.590     0.200
   159.747    40.516     0.200
   163.441    50.696     0.200
   163.441    48.973     0.200
   166.792    66.289     0.200
   146.694     1.905     0.200
   166.482    64.514     0.200
   146.604     1.790     0.200
   150.034     9.174     0.200
   163.410    48.792     0.200
   166.554    65.632     0.200
   166.575    64.314     0.200
   153.177    16.714     0.200
   163.492    50.333     0.200
   166.693    64.650     0.200
   170.271    74.466     0.200
   146.500     1.510     0.200
   146.639     2.024     0.200
   146.639     1.891     0.200
   150.348    12.640     0.200
   150.418    13.331     0.200
   150.446    12.049     0.200
   146.742     2.180     0.200
   166.447    63.320     0.200
   163.611    50.640     0.200
   166.587    64.452     0.200
   163.737    53.098     0.200
   166.532    64.432     0.200
   146.769     2.251     0.200
   166.517    63.801     0.200
   146.626     2.060     0.200
   163.340    50.064     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   152.513     9.014     0.200
   152.525     8.336     0.200
   152.624     8.049     0.200
   150.564     5.561     0.200
   135.201     2.570     0.200
   135.515     1.936     0.200
   135.641     2.567     0.200
   135.944     2.247     0.200
   136.279     3.211     0.200
   136.305     3.199     0.200
   136.707     2.557     0.200
   136.946     3.201     0.200
   137.759     4.159     0.200
   144.893     3.085     0.200
   151.904     7.611     0.200
   152.002     9.365     0.200
   152.079    10.240     0.200
   152.116     9.655     0.200
   152.116    10.015     0.200
   152.293     7.201     0.200
   152.346     8.773     0.200
   152.352     9.194     0.200
   152.833     8.535     0.200
   153.591    10.368     0.200
   153.774     7.936     0.200
   153.799    10.311     0.200
   154.430     8.842     0.200
   154.381     9.930     0.200
   154.874    10.127     0.200
   154.891     9.244     0.200
   154.904    10.237     0.200
   154.904     9.536     0.200
   154.918     9.517     0.200
   154.930    11.390     0.200
   150.510     5.822     0.200
   153.602     7.983     0.200
   150.627     5.713     0.200
   146.753     4.251     0.200
   155.049     8.858     0.200
   150.629     6.560     0.200
   151.416     5.925     0.200
   153.199     7.079     0.200
   153.634     8.142     0.200
   154.946     8.736     0.200
   149.620     4.847     0.200
   150.391     5.433     0.200
   150.599     5.879     0.200
   146.770     3.569     0.200
   147.789     4.033     0.200
   150.813     5.612     0.200
   146.643     3.498     0.200
   149.727     6.628     0.200
   151.384     6.850     0.200
   150.446     6.119     0.200
   151.587     5.984     0.200
   150.417     5.437     0.200
   151.548     6.207     0.200
   147.579     3.364     0.200
   149.635     4.849     0.200
   150.415     6.342     0.200
   150.593     6.156     0.200
   150.648     6.670     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
