#!/bin/bash
gmt begin bohol1.86_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P bohol1.86'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.699
    79.000     8.525
    80.000     7.435
    81.000     6.431
    82.000     5.513
    83.000     4.679
    84.000     3.928
    85.000     3.266
    86.000     2.689
    87.000     2.189
    88.000     1.794
    89.000     1.495
    90.000     1.238
    91.000     1.011
    92.000     0.810
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.199
    97.000     0.106
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    19.604     1.218     0.200
    20.542    -0.280     0.200
    23.051     3.881     0.200
    23.235     1.949     0.200
    23.381    -1.889     0.200
    23.305     3.107     0.200
    24.728     1.050     0.200
    25.608    -0.044     0.200
    25.919     0.739     0.200
    26.084     2.536     0.200
    26.532    -0.507     0.200
    29.719     4.251     0.200
    30.272     0.355     0.200
    30.294    -0.039     0.200
    31.121     0.867     0.200
    31.239    -0.171     0.200
    32.887     2.861     0.200
    34.120     0.617     0.200
    34.352     0.609     0.200
    34.450    -1.240     0.200
    36.359    -1.548     0.200
    36.740    -0.596     0.200
    38.763     2.217     0.200
    38.987     2.137     0.200
    40.203    -1.988     0.200
    41.893     0.704     0.200
    41.984     0.357     0.200
    43.046     2.732     0.200
    44.060     2.559     0.200
    44.140    -0.077     0.200
    44.536    -1.249     0.200
    44.765     0.929     0.200
    45.470    -0.177     0.200
    45.718    -0.637     0.200
    45.794     1.766     0.200
    45.988    -0.768     0.200
    46.146    -0.907     0.200
    46.444    -0.353     0.200
    47.449     0.297     0.200
    48.091     0.819     0.200
    48.740    -0.380     0.200
    49.102     2.344     0.200
    49.379     2.128     0.200
    49.302     1.515     0.200
    49.483     4.536     0.200
    49.662    -0.230     0.200
    50.529     2.398     0.200
    51.047     1.298     0.200
    51.559    -0.543     0.200
    52.271     1.259     0.200
    52.521    -0.701     0.200
    52.650     1.344     0.200
    52.743     0.661     0.200
    53.081    -1.833     0.200
    54.200     0.964     0.200
    53.873    -0.151     0.200
    54.335    -1.014     0.200
    54.664     0.590     0.200
    55.063     1.709     0.200
    55.874     1.076     0.200
    56.015     0.861     0.200
    56.116    -0.859     0.200
    57.053     1.477     0.200
    57.450     0.675     0.200
    58.681     0.057     0.200
    62.076    -1.640     0.200
    63.783     1.208     0.200
    63.783     1.904     0.200
    64.299     1.116     0.200
    64.979     0.683     0.200
    66.731     1.401     0.200
    66.995    -1.281     0.200
    67.434     1.036     0.200
    67.583     0.794     0.200
    69.246    -0.405     0.200
    72.008     1.167     0.200
    74.456     0.324     0.200
    74.483     0.164     0.200
    75.629    -0.441     0.200
    76.599     2.038     0.200
    76.757    -0.851     0.200
    76.894    -0.026     0.200
    78.346     0.271     0.200
    80.108    -1.350     0.200
    80.390     1.132     0.200
    80.646     1.758     0.200
    80.741    -0.751     0.200
    81.439    -0.466     0.200
    84.053    -0.046     0.200
    84.172    -0.447     0.200
    85.750    -1.575     0.200
    86.300    -0.289     0.200
    86.870    -0.984     0.200
    87.467    -0.579     0.200
    87.567    -1.461     0.200
    88.005    -0.549     0.200
    88.208     1.489     0.200
    88.823    -0.413     0.200
    89.852    -1.532     0.200
    90.506     0.715     0.200
    91.143    -2.743     0.200
    91.539     0.919     0.200
    91.605    -1.888     0.200
    91.664     0.340     0.200
    92.560    -0.800     0.200
    94.945    -0.768     0.200
    95.807    -0.702     0.200
    15.775     2.083     0.200
    16.280     7.604     0.200
    16.869     5.149     0.200
    21.027     1.243     0.200
    22.403     0.007     0.200
    22.448     2.029     0.200
    23.327     0.241     0.200
    23.766     0.073     0.200
    23.588     2.203     0.200
    24.171     0.375     0.200
    24.329     0.726     0.200
    25.204     0.870     0.200
    25.701     1.756     0.200
    26.480     0.907     0.200
    26.839     0.371     0.200
    26.788    -0.269     0.200
    27.834     0.652     0.200
    28.420     0.821     0.200
    28.828    -2.601     0.200
    29.543     1.055     0.200
    29.552     1.971     0.200
    29.977     0.210     0.200
    30.662     0.154     0.200
    31.412    -1.855     0.200
    31.416    -1.287     0.200
    32.029     1.620     0.200
    32.559     0.474     0.200
    32.974     0.839     0.200
    33.432     0.842     0.200
    33.984     1.044     0.200
    34.856    -1.504     0.200
    34.767     2.259     0.200
    36.762     1.157     0.200
    36.633     1.153     0.200
    36.932     2.610     0.200
    39.605    -1.788     0.200
    40.065     0.388     0.200
    42.797    -2.019     0.200
    43.546    -1.072     0.200
    43.808     0.021     0.200
    44.841    -0.442     0.200
    45.100     0.292     0.200
    45.100    -0.508     0.200
    45.452     0.700     0.200
    45.671     0.673     0.200
    46.405     0.785     0.200
    46.484     1.371     0.200
    47.845     0.654     0.200
    48.176    -0.599     0.200
    48.196    -0.456     0.200
    48.196    -0.756     0.200
    48.251     0.418     0.200
    48.251    -0.182     0.200
    50.575     1.077     0.200
    51.433     1.029     0.200
    51.661     0.928     0.200
    51.661     1.428     0.200
    51.810    -0.685     0.200
    52.036     1.631     0.200
    52.232     2.071     0.200
    52.764     0.431     0.200
    52.756     0.489     0.200
    52.897    -0.251     0.200
    52.897     0.650     0.200
    52.904    -1.104     0.200
    53.318    -0.851     0.200
    53.318    -1.351     0.200
    54.265    -0.282     0.200
    54.367     1.477     0.200
    54.933     1.473     0.200
    55.255     0.550     0.200
    55.255     1.150     0.200
    55.275    -1.197     0.200
    56.183     0.188     0.200
    56.218     1.843     0.200
    56.384    -1.043     0.200
    57.311     0.880     0.200
    57.646     0.523     0.200
    58.923     0.603     0.200
    61.387    -1.280     0.200
    63.647    -3.374     0.200
    65.282     1.937     0.200
    65.282     2.437     0.200
    65.472     0.707     0.200
    65.472     1.207     0.200
    67.016     1.307     0.200
    67.493    -1.219     0.200
    67.493    -0.419     0.200
    67.638     0.269     0.200
    68.286     0.197     0.200
    68.494    -1.506     0.200
    69.717     0.906     0.200
    74.768     1.726     0.200
    75.149    -0.469     0.200
    75.149    -0.068     0.200
    75.982    -0.343     0.200
    76.019     0.047     0.200
    76.159     4.251     0.200
    76.237     1.304     0.200
    76.237     1.804     0.200
    76.612     2.182     0.200
    76.839     0.600     0.200
    77.089    -0.509     0.200
    77.226    -0.277     0.200
    77.474     0.134     0.200
    79.157    -1.670     0.200
    79.664    -1.735     0.200
    79.664    -1.535     0.200
    80.715    -2.401     0.200
    80.715    -1.701     0.200
    81.063    -0.756     0.200
    81.170    -2.828     0.200
    81.170    -2.229     0.200
    83.179     0.649     0.200
    83.388    -0.428     0.200
    83.522     0.884     0.200
    83.781    -0.447     0.200
    83.961    -0.665     0.200
    84.146     0.596     0.200
    84.809    -0.662     0.200
    84.949    -1.066     0.200
    84.949    -0.066     0.200
    86.031    -1.155     0.200
    86.153    -1.353     0.200
    86.691    -1.997     0.200
    88.342     1.066     0.200
    88.962     0.145     0.200
    88.962     2.145     0.200
    89.159    -1.781     0.200
    89.636    -0.014     0.200
    89.698    -1.105     0.200
    90.575     1.607     0.200
    91.433    -1.379     0.200
    91.586     0.913     0.200
    91.629    -0.285     0.200
    91.729    -1.750     0.200
    91.756     0.124     0.200
    92.171    -2.193     0.200
    93.567    -0.231     0.200
    94.922    -0.455     0.200
    94.922     0.045     0.200
    94.939    -0.629     0.200
    95.830     0.001     0.200
    16.501     2.139     0.200
    20.654    -1.887     0.200
    21.200     2.112     0.200
    21.236     1.129     0.200
    21.782     0.173     0.200
    22.786    -0.708     0.200
    22.830     1.333     0.200
    22.982     2.322     0.200
    23.241    -1.498     0.200
    23.049     0.521     0.200
    23.814     1.140     0.200
    25.240     1.048     0.200
    25.422    -1.605     0.200
    25.361     0.946     0.200
    28.081    -0.745     0.200
    28.372    -0.835     0.200
    30.025     0.601     0.200
    30.530    -2.260     0.200
    30.874    -2.297     0.200
    30.925    -1.943     0.200
    32.168     0.816     0.200
    32.370    -0.350     0.200
    33.178     1.480     0.200
    34.284    -1.335     0.200
    34.377    -0.945     0.200
    35.415    -0.900     0.200
    36.072    -1.427     0.200
    36.724    -0.095     0.200
    36.764     0.164     0.200
    39.028    -1.539     0.200
    40.053    -1.478     0.200
    40.172    -1.065     0.200
    40.073     1.357     0.200
    40.263    -0.816     0.200
    40.352     0.946     0.200
    40.532     0.956     0.200
    40.618     1.045     0.200
    40.866     1.199     0.200
    40.866     1.699     0.200
    41.078    -0.843     0.200
    41.139     0.651     0.200
    41.686    -0.735     0.200
    42.463    -0.566     0.200
    43.365    -0.170     0.200
    44.418    -0.630     0.200
    44.277    -0.500     0.200
    44.277    -0.301     0.200
    44.533     1.449     0.200
    46.295    -0.202     0.200
    46.120    -0.129     0.200
    46.120     0.371     0.200
    46.430     0.941     0.200
    47.597    -0.672     0.200
    48.950    -1.110     0.200
    48.950    -0.309     0.200
    49.436     1.180     0.200
    49.531    -1.545     0.200
    50.445    -0.485     0.200
    52.278     0.894     0.200
    52.359    -0.310     0.200
    53.162    -0.742     0.200
    54.526    -1.714     0.200
    54.526    -0.815     0.200
    54.586    -0.152     0.200
    54.586     0.348     0.200
    55.947     2.743     0.200
    56.038     3.392     0.200
    56.038     3.892     0.200
    62.335    -0.177     0.200
    63.773     1.276     0.200
    64.259     1.082     0.200
    64.886     4.984     0.200
    64.886     5.484     0.200
    65.076     0.754     0.200
    66.951    -1.295     0.200
    67.456    -2.497     0.200
    67.631    -1.605     0.200
    67.631    -1.105     0.200
    69.551    -0.580     0.200
    74.370     0.535     0.200
    74.405     0.329     0.200
    80.534    -0.527     0.200
    80.765    -3.165     0.200
    84.165    -0.792     0.200
    85.216     0.808     0.200
    85.216     1.007     0.200
    86.095    -0.556     0.200
    87.180    -0.869     0.200
    88.175     2.371     0.200
    88.175     2.871     0.200
    89.922    -1.835     0.200
    91.725    -2.217     0.200
    14.746     9.298     0.200
    15.942     4.102     0.200
    16.186     5.370     0.200
    16.957     2.717     0.200
    17.034     3.245     0.200
    21.071     1.404     0.200
    21.423    -1.384     0.200
    22.114     3.215     0.200
    22.505     0.557     0.200
    22.735     1.112     0.200
    22.769     1.060     0.200
    23.418    -2.584     0.200
    23.418    -0.183     0.200
    23.445     0.138     0.200
    23.705     1.740     0.200
    23.731     1.507     0.200
    23.843     0.281     0.200
    23.956     1.251     0.200
    24.529    -0.278     0.200
    24.539     2.133     0.200
    24.939     0.687     0.200
    25.590     0.381     0.200
    25.722     0.384     0.200
    25.708     1.004     0.200
    25.750     2.128     0.200
    25.750     2.439     0.200
    25.926     0.534     0.200
    26.318    -1.012     0.200
    26.379     0.940     0.200
    26.379     0.139     0.200
    26.449     0.305     0.200
    26.539    -1.012     0.200
    26.892     0.809     0.200
    27.150    -0.214     0.200
    27.684     2.706     0.200
    28.082     0.152     0.200
    28.572     1.287     0.200
    29.102     0.078     0.200
    29.349    -1.107     0.200
    29.349    -0.972     0.200
    29.479     1.830     0.200
    29.870     1.270     0.200
    30.795     3.097     0.200
    31.025    -1.436     0.200
    31.078    -1.596     0.200
    31.030    -0.476     0.200
    31.030     0.079     0.200
    31.912    -0.738     0.200
    32.244     1.310     0.200
    32.244     2.968     0.200
    32.944     4.213     0.200
    33.002     0.508     0.200
    33.286     0.227     0.200
    33.880    -0.547     0.200
    33.905     3.841     0.200
    34.378     1.733     0.200
    34.744     0.570     0.200
    34.957    -0.264     0.200
    34.938     3.895     0.200
    35.823    -0.717     0.200
    36.216     1.920     0.200
    36.568    -1.082     0.200
    36.568     0.070     0.200
    36.670    -1.447     0.200
    36.846     0.949     0.200
    36.965     1.639     0.200
    39.547    -0.856     0.200
    39.547     0.964     0.200
    39.547    -0.395     0.200
    40.120     1.041     0.200
    40.585    -1.805     0.200
    40.586     1.384     0.200
    40.894    -0.359     0.200
    40.894     3.641     0.200
    40.880    -3.246     0.200
    40.764     1.216     0.200
    40.875     0.597     0.200
    41.052     0.543     0.200
    41.143     0.593     0.200
    41.672    -1.750     0.200
    41.658     0.164     0.200
    42.307    -1.934     0.200
    43.043    -0.906     0.200
    43.043     3.094     0.200
    43.062    -0.029     0.200
    43.062    -2.170     0.200
    43.050     1.034     0.200
    44.127    -1.638     0.200
    44.127    -1.138     0.200
    44.706     0.730     0.200
    45.282     1.152     0.200
    45.435    -0.060     0.200
    45.822    -1.117     0.200
    45.822     2.883     0.200
    45.974    -2.321     0.200
    45.974     0.679     0.200
    45.984    -0.601     0.200
    46.268    -0.230     0.200
    46.488    -0.863     0.200
    46.585     0.769     0.200
    46.585     2.430     0.200
    46.585     0.191     0.200
    46.998     1.545     0.200
    47.958     5.183     0.200
    48.597    -1.744     0.200
    48.597    -1.244     0.200
    48.825     4.499     0.200
    49.453     0.698     0.200
    49.446     0.750     0.200
    49.758     0.368     0.200
    49.812     1.558     0.200
    49.812     0.658     0.200
    50.464    -0.081     0.200
    50.617    -0.139     0.200
    50.617     3.861     0.200
    50.811     0.402     0.200
    51.131     1.996     0.200
    51.101     0.217     0.200
    51.851     1.607     0.200
    52.268    -2.494     0.200
    52.268    -2.193     0.200
    52.319     3.126     0.200
    52.410    -0.548     0.200
    52.894     1.869     0.200
    52.886     1.928     0.200
    53.004     0.858     0.200
    53.087     1.945     0.200
    53.160    -1.091     0.200
    53.824    -0.965     0.200
    53.824    -0.266     0.200
    54.475    -0.709     0.200
    54.484     1.221     0.200
    54.985     0.492     0.200
    55.344     2.003     0.200
    56.322    -0.008     0.200
    56.322    -0.512     0.200
    56.437     1.277     0.200
    57.369     1.569     0.200
    57.734    -0.999     0.200
    57.734    -0.198     0.200
    58.440    -0.945     0.200
    58.988     0.241     0.200
    61.185    -0.820     0.200
    61.838    -0.728     0.200
    63.270     0.009     0.200
    64.230     0.182     0.200
    65.318     1.796     0.200
    65.507     0.869     0.200
    66.864     0.866     0.200
    67.273     1.766     0.200
    67.061     2.112     0.200
    67.799     1.844     0.200
    67.837     1.502     0.200
    67.712    -1.012     0.200
    68.037    -0.052     0.200
    68.193     0.469     0.200
    68.282    -0.991     0.200
    68.552    -1.381     0.200
    68.555    -1.201     0.200
    68.626    -1.240     0.200
    68.707    -1.645     0.200
    68.754    -1.843     0.200
    68.828     0.303     0.200
    68.802    -1.336     0.200
    68.707    -1.745     0.200
    68.707    -1.430     0.200
    68.707    -1.245     0.200
    69.005    -0.899     0.200
    69.108    -0.240     0.200
    69.180    -2.489     0.200
    70.296     3.441     0.200
    70.720     4.851     0.200
    71.105     0.514     0.200
    71.283     0.941     0.200
    71.354     1.010     0.200
    71.367     0.432     0.200
    71.422     0.500     0.200
    71.499     2.036     0.200
    71.550     2.525     0.200
    71.832     1.129     0.200
    72.122     0.392     0.200
    73.029     1.991     0.200
    73.424     1.859     0.200
    73.940     1.631     0.200
    74.205     3.586     0.200
    74.785    -0.284     0.200
    74.801    -0.379     0.200
    74.801     2.626     0.200
    75.102     1.188     0.200
    75.231     1.144     0.200
    75.539     0.376     0.200
    75.942     2.070     0.200
    75.973     1.891     0.200
    76.510    -0.155     0.200
    76.510     0.044     0.200
    76.548     0.628     0.200
    76.530     2.728     0.200
    76.630     0.162     0.200
    76.906     2.604     0.200
    77.093     1.354     0.200
    77.143     0.177     0.200
    77.388    -1.102     0.200
    77.426     0.989     0.200
    77.750    -1.122     0.200
    77.750    -0.821     0.200
    77.766     1.092     0.200
    78.005    -0.537     0.200
    79.567    -0.124     0.200
    79.686    -1.569     0.200
    79.686    -2.368     0.200
    79.744     1.414     0.200
    80.190    -0.346     0.200
    80.190    -0.897     0.200
    80.072     2.141     0.200
    80.376     5.500     0.200
    80.267    -0.913     0.200
    80.907    -0.142     0.200
    80.907    -0.560     0.200
    80.920    -0.514     0.200
    81.063     0.225     0.200
    81.161     0.303     0.200
    81.156     1.331     0.200
    81.466     0.686     0.200
    82.115     5.321     0.200
    82.546    -0.983     0.200
    83.494    -0.692     0.200
    83.490     0.128     0.200
    83.526    -2.155     0.200
    83.756    -1.236     0.200
    83.747     2.812     0.200
    83.987     1.285     0.200
    84.079    -2.081     0.200
    84.215     0.922     0.200
    84.271     2.137     0.200
    84.412     3.227     0.200
    84.695    -1.006     0.200
    84.918     0.871     0.200
    85.056     1.181     0.200
    85.164     0.916     0.200
    85.164    -1.107     0.200
    85.211    -1.694     0.200
    85.194     0.490     0.200
    85.328    -1.183     0.200
    85.481    -0.446     0.200
    85.997     1.493     0.200
    86.275    -1.778     0.200
    86.293     2.034     0.200
    86.398    -0.178     0.200
    86.817     2.967     0.200
    86.976    -0.311     0.200
    87.260     1.611     0.200
    87.361     0.822     0.200
    87.523    -2.160     0.200
    87.533    -0.009     0.200
    87.544     0.439     0.200
    87.594     0.701     0.200
    87.620     1.575     0.200
    87.629    -0.966     0.200
    87.634     0.509     0.200
    87.765     1.381     0.200
    87.765     2.881     0.200
    87.923     1.129     0.200
    87.939     0.053     0.200
    87.933    -0.917     0.200
    87.973     0.892     0.200
    88.025     4.645     0.200
    88.321     5.244     0.200
    88.380     1.965     0.200
    88.461     0.585     0.200
    88.461     1.085     0.200
    88.749     2.727     0.200
    88.749     3.227     0.200
    88.801    -0.519     0.200
    89.079     0.177     0.200
    89.144    -1.631     0.200
    89.214     1.041     0.200
    89.277     0.747     0.200
    89.297     0.654     0.200
    89.681     0.051     0.200
    89.745     3.557     0.200
    89.752     3.524     0.200
    89.946    -1.085     0.200
    89.990     4.409     0.200
    90.024     4.251     0.200
    90.135     2.935     0.200
    90.150     0.666     0.200
    90.197     2.945     0.200
    90.197     3.445     0.200
    90.326     2.843     0.200
    90.328     3.332     0.200
    90.604     0.547     0.200
    90.432     3.350     0.200
    90.724    -0.008     0.200
    90.738     1.928     0.200
    90.828     0.509     0.200
    91.016     0.635     0.200
    91.052     1.468     0.200
    91.570    -0.935     0.200
    91.689    -2.486     0.200
    91.691     1.506     0.200
    91.745     1.254     0.200
    91.794    -0.071     0.200
    91.863     0.012     0.200
    91.914    -1.526     0.200
    91.991     2.116     0.200
    91.991     3.116     0.200
    92.082     1.698     0.200
    92.113     2.554     0.200
    92.224     2.038     0.200
    92.370     2.365     0.200
    92.438    -1.947     0.200
    92.463     2.536     0.200
    92.477     1.871     0.200
    92.480    -1.142     0.200
    92.859    -2.390     0.200
    92.996     2.476     0.200
    93.121    -1.099     0.200
    93.155     0.742     0.200
    93.335     1.415     0.200
    93.444     2.113     0.200
    93.494    -1.318     0.200
    93.508     2.817     0.200
    93.745    -0.973     0.200
    93.823    -2.930     0.200
    93.918    -1.669     0.200
    94.075     0.508     0.200
    94.055     0.603     0.200
    94.152     3.658     0.200
    94.239     0.255     0.200
    94.429    -0.117     0.200
    94.456    -1.940     0.200
    94.484     0.734     0.200
    94.543     0.363     0.200
    94.557    -0.200     0.200
    94.621     4.002     0.200
    94.669    -0.016     0.200
    94.758     1.577     0.200
    94.803     2.171     0.200
    94.955     1.975     0.200
    95.097    -0.177     0.200
    95.122     0.110     0.200
    95.132     3.664     0.200
    95.503     1.972     0.200
    95.674     4.192     0.200
    96.000     0.805     0.200
    96.003     2.893     0.200
    96.056     0.953     0.200
    96.063     3.821     0.200
    96.070     3.689     0.200
    96.267     3.596     0.200
    96.420     0.499     0.200
    96.487     2.995     0.200
    96.722     2.630     0.200
    96.726    -3.090     0.200
    96.840     2.597     0.200
    97.492    -1.052     0.200
    99.563     1.673     0.200
    16.047     6.390     0.200
    16.226     3.088     0.200
    17.031     3.300     0.200
    17.139     2.151     0.200
    20.961     1.203     0.200
    21.554     0.716     0.200
    22.898    -0.205     0.200
    23.291    -1.747     0.200
    23.801     2.906     0.200
    23.929     1.735     0.200
    25.969    -0.216     0.200
    29.396    -2.097     0.200
    29.472    -2.776     0.200
    30.899    -0.395     0.200
    31.159    -0.686     0.200
    32.355     1.801     0.200
    33.410     0.972     0.200
    34.013    -1.176     0.200
    34.812     0.910     0.200
    36.461    -0.748     0.200
    39.534    -1.680     0.200
    40.246    -0.789     0.200
    40.943     0.650     0.200
    41.120     1.095     0.200
    41.210     0.148     0.200
    41.726    -0.086     0.200
    44.252    -0.235     0.200
    45.315     0.293     0.200
    45.867    -3.079     0.200
    46.109     0.018     0.200
    46.109     0.819     0.200
    46.288     0.705     0.200
    46.691     1.448     0.200
    48.206    -0.342     0.200
    48.728    -0.363     0.200
    48.728    -0.164     0.200
    49.334     2.396     0.200
    50.345     1.305     0.200
    50.499     0.144     0.200
    51.222    -0.299     0.200
    51.770    -0.405     0.200
    52.401    -1.095     0.200
    53.952    -1.521     0.200
    53.952    -1.322     0.200
    54.086     1.204     0.200
    56.408    -0.240     0.200
    56.408     0.560     0.200
    57.453     0.352     0.200
    59.073     0.020     0.200
    59.073     0.821     0.200
    61.294    -0.393     0.200
    61.971    -1.757     0.200
    64.139    -2.755     0.200
    64.307     1.043     0.200
    65.397     0.641     0.200
    65.586     1.414     0.200
    66.752    -0.066     0.200
    67.689     0.190     0.200
    68.817    -0.082     0.200
    74.866     0.989     0.200
    74.885     0.481     0.200
    74.879     1.514     0.200
    77.464    -0.686     0.200
    80.310    -1.510     0.200
    80.871     0.080     0.200
    81.014    -0.680     0.200
    81.588    -0.428     0.200
    83.618    -0.200     0.200
    84.201    -0.874     0.200
    84.982    -0.122     0.200
    85.328    -1.554     0.200
    86.105     0.288     0.200
    86.657    -0.929     0.200
    86.513    -0.919     0.200
    90.824    -0.354     0.200
    91.138    -2.612     0.200
    91.806    -1.607     0.200
    92.556    -1.872     0.200
    14.774     6.546     0.200
    16.124     3.362     0.200
    16.190     3.118     0.200
    16.945     2.959     0.200
    17.040     2.766     0.200
    21.015     1.554     0.200
    21.456     1.408     0.200
    21.504     3.295     0.200
    22.120     2.892     0.200
    22.120     2.693     0.200
    22.103     0.880     0.200
    22.453     1.150     0.200
    22.755     1.949     0.200
    22.798     0.694     0.200
    23.392    -2.768     0.200
    23.392     2.232     0.200
    23.396    -0.812     0.200
    23.681     0.479     0.200
    23.908     0.604     0.200
    24.494     0.054     0.200
    24.987     0.572     0.200
    24.987     0.873     0.200
    25.640    -0.558     0.200
    25.640    -1.359     0.200
    25.690    -0.112     0.200
    25.757    -1.622     0.200
    25.900     0.284     0.200
    26.369    -0.060     0.200
    26.369    -0.961     0.200
    26.356     0.360     0.200
    26.400    -0.535     0.200
    26.589    -0.141     0.200
    26.589    -0.941     0.200
    27.695     3.121     0.200
    27.696    -0.894     0.200
    27.696     0.006     0.200
    28.096    -0.467     0.200
    28.576     0.765     0.200
    29.282    -1.608     0.200
    29.282    -2.008     0.200
    29.287    -0.853     0.200
    29.287    -1.053     0.200
    29.486    -0.317     0.200
    29.401    -1.470     0.200
    29.401    -2.066     0.200
    29.910    -0.570     0.200
    29.893    -0.023     0.200
    30.318    -4.181     0.200
    30.318    -3.581     0.200
    31.001    -0.709     0.200
    31.053    -1.269     0.200
    31.053    -0.769     0.200
    31.059     0.278     0.200
    31.059     0.678     0.200
    31.534     0.495     0.200
    31.534     0.094     0.200
    31.950    -0.063     0.200
    32.254     2.764     0.200
    32.971    -1.513     0.200
    32.971    -0.814     0.200
    32.931     2.842     0.200
    33.026     1.005     0.200
    33.309     3.542     0.200
    33.575    -0.683     0.200
    33.920    -0.285     0.200
    33.893     1.451     0.200
    34.366     0.353     0.200
    34.729    -0.792     0.200
    35.000    -0.130     0.200
    34.926     2.507     0.200
    35.621     1.530     0.200
    35.787    -0.894     0.200
    36.268     1.988     0.200
    36.418    -0.296     0.200
    36.418     0.604     0.200
    36.560    -0.409     0.200
    36.560    -0.316     0.200
    36.857     0.964     0.200
    36.956     1.823     0.200
    37.625    -0.553     0.200
    37.625     0.146     0.200
    37.640     0.316     0.200
    37.640     0.617     0.200
    39.143     3.777     0.200
    39.582    -0.193     0.200
    39.618    -1.786     0.200
    40.170    -0.574     0.200
    40.542     0.047     0.200
    40.571     1.607     0.200
    40.878     0.273     0.200
    40.834    -0.365     0.200
    40.735     0.557     0.200
    40.860     0.723     0.200
    41.037     0.869     0.200
    41.128     1.020     0.200
    41.627    -1.881     0.200
    41.644     0.286     0.200
    42.261    -0.058     0.200
    43.032     1.682     0.200
    43.016    -0.193     0.200
    44.150    -0.325     0.200
    44.661     0.588     0.200
    45.252     0.887     0.200
    45.804    -0.482     0.200
    45.967    -0.764     0.200
    46.007     0.418     0.200
    46.007    -0.082     0.200
    46.462    -0.261     0.200
    46.592     0.822     0.200
    48.125    -0.613     0.200
    48.630     0.493     0.200
    49.436     1.521     0.200
    49.416     0.474     0.200
    49.726     1.106     0.200
    49.783     0.870     0.200
    50.447    -0.459     0.200
    50.600     0.281     0.200
    50.782     3.609     0.200
    51.145     1.882     0.200
    51.154    -0.690     0.200
    51.859     2.036     0.200
    52.309    -0.810     0.200
    52.315     2.643     0.200
    52.422    -0.151     0.200
    52.895     2.351     0.200
    52.887     2.410     0.200
    53.175    -0.715     0.200
    53.873    -0.634     0.200
    53.873    -0.833     0.200
    54.014     1.335     0.200
    54.485    -0.594     0.200
    54.484     1.711     0.200
    54.978     2.133     0.200
    55.341     3.515     0.200
    55.341     4.114     0.200
    56.316     0.962     0.200
    56.429     2.716     0.200
    56.429     3.216     0.200
    57.362     2.103     0.200
    57.730     0.511     0.200
    58.982    -0.233     0.200
    58.982     0.366     0.200
    61.194    -0.401     0.200
    61.878    -2.017     0.200
    63.326    -2.181     0.200
    64.220     0.732     0.200
    65.308     1.334     0.200
    65.498     0.607     0.200
    66.852     1.415     0.200
    67.267    -1.220     0.200
    67.789     1.383     0.200
    67.826     1.846     0.200
    67.724    -1.105     0.200
    68.029     0.172     0.200
    68.549    -0.482     0.200
    68.621     0.268     0.200
    68.852    -0.176     0.200
    68.717    -0.333     0.200
    68.717    -1.013     0.200
    69.086     1.270     0.200
    69.176     1.411     0.200
    70.274    -1.948     0.200
    70.709     5.398     0.200
    71.093     1.064     0.200
    71.270     0.990     0.200
    71.342     0.057     0.200
    71.354     0.982     0.200
    71.400     0.605     0.200
    71.477     2.140     0.200
    71.529     2.329     0.200
    71.811     1.231     0.200
    72.115     0.909     0.200
    73.022     1.505     0.200
    74.192     0.636     0.200
    74.777     0.235     0.200
    74.795     0.133     0.200
    74.791     1.153     0.200
    75.079     0.791     0.200
    75.527     0.416     0.200
    75.936     0.575     0.200
    75.968     0.395     0.200
    76.602     0.192     0.200
    76.516     2.280     0.200
    77.059    -0.283     0.200
    76.901     1.108     0.200
    77.193    -0.235     0.200
    77.175    -0.435     0.200
    77.399     0.307     0.200
    77.803    -1.945     0.200
    77.803    -1.045     0.200
    77.745     1.680     0.200
    78.060     0.626     0.200
    78.060     1.027     0.200
    79.740    -1.594     0.200
    79.611    -0.694     0.200
    80.243    -2.314     0.200
    80.243    -1.814     0.200
    80.276    -1.490     0.200
    80.868    -0.467     0.200
    80.915    -0.515     0.200
    81.117     0.105     0.200
    81.121     0.486     0.200
    81.159    -1.216     0.200
    81.159    -0.716     0.200
    81.486    -0.453     0.200
    83.516    -0.540     0.200
    83.488    -0.395     0.200
    83.769     0.165     0.200
    83.966     1.156     0.200
    84.099    -1.320     0.200
    84.210     0.416     0.200
    84.376     3.570     0.200
    84.726     2.104     0.200
    84.901     0.420     0.200
    85.038     1.037     0.200
    85.157    -0.024     0.200
    85.227    -1.510     0.200
    85.380    -0.975     0.200
    85.187    -0.010     0.200
    85.470     0.077     0.200
    86.005     0.919     0.200
    86.296     1.483     0.200
    86.282    -1.944     0.200
    86.412    -1.083     0.200
    86.574    -0.882     0.200
    86.817    -0.071     0.200
    86.970    -0.816     0.200
    87.251    -1.382     0.200
    87.621     1.534     0.200
    87.623    -1.475     0.200
    87.633    -0.022     0.200
    87.715     1.584     0.200
    87.765     0.345     0.200
    87.894    -0.270     0.200
    87.914     0.638     0.200
    87.940    -0.485     0.200
    87.925    -1.416     0.200
    87.983     3.309     0.200
    88.214    -2.787     0.200
    88.321     2.710     0.200
    88.374     1.459     0.200
    88.461     0.049     0.200
    88.748     1.694     0.200
    89.078    -0.358     0.200
    89.139     1.356     0.200
    89.293     0.133     0.200
    89.648    -0.430     0.200
    89.744     0.022     0.200
    89.751     4.989     0.200
    89.961    -0.291     0.200
    90.022     1.725     0.200
    90.030     0.184     0.200
    90.126     2.236     0.200
    90.199     0.898     0.200
    90.199     2.898     0.200
    90.322     0.324     0.200
    90.318     5.842     0.200
    90.349    -1.500     0.200
    90.727    -0.561     0.200
    90.727    -0.061     0.200
    90.824    -0.010     0.200
    91.040    -2.113     0.200
    91.013    -0.889     0.200
    91.052     2.929     0.200
    91.566    -2.455     0.200
    91.704    -1.895     0.200
    91.688     0.981     0.200
    91.749     0.697     0.200
    91.799    -0.532     0.200
    91.799    -0.131     0.200
    91.783    -2.656     0.200
    91.867    -0.045     0.200
    91.932     0.851     0.200
    91.992    -0.423     0.200
    92.031     0.591     0.200
    92.077     0.683     0.200
    92.112     3.018     0.200
    92.278    -1.949     0.200
    92.454    -2.161     0.200
    92.466    -0.615     0.200
    92.466    -0.415     0.200
    92.476    -1.361     0.200
    92.694    -2.270     0.200
    92.854    -2.505     0.200
    92.996     3.439     0.200
    93.118    -0.924     0.200
    93.158    -0.808     0.200
    93.255    -2.454     0.200
    93.330    -0.001     0.200
    93.490    -2.036     0.200
    93.511     0.566     0.200
    93.511     1.165     0.200
    93.751    -0.541     0.200
    93.819    -1.652     0.200
    93.915    -2.891     0.200
    93.964    -2.019     0.200
    93.985     0.087     0.200
    94.047    -1.899     0.200
    94.155    -0.496     0.200
    94.235    -4.262     0.200
    94.426     0.559     0.200
    94.453    -2.165     0.200
    94.481    -0.792     0.200
    94.553    -1.021     0.200
    94.607    -1.771     0.200
    94.625     1.946     0.200
    94.672     2.830     0.200
    94.753     0.060     0.200
    94.796     2.662     0.200
    95.103    -0.742     0.200
    95.129     0.239     0.200
    95.138     0.098     0.200
    95.510    -1.601     0.200
    95.661     3.214     0.200
    95.676     2.845     0.200
    96.006     1.043     0.200
    95.999     2.173     0.200
    96.060     0.396     0.200
    96.067     0.562     0.200
    96.028    -0.658     0.200
    96.268     1.450     0.200
    96.425     0.537     0.200
    96.484     3.971     0.200
    96.552    -0.340     0.200
    96.579    -0.461     0.200
    96.753     0.753     0.200
    96.728     0.262     0.200
    96.841    -0.848     0.200
    97.470    -0.489     0.200
    97.442    -1.364     0.200
    97.682    -0.848     0.200
    97.800    -1.478     0.200
    98.405    -0.695     0.200
    98.818    -0.346     0.200
    16.839     2.509     0.200
    16.972     2.154     0.200
    20.910     1.315     0.200
    21.462     1.174     0.200
    22.722     1.772     0.200
    22.792     1.027     0.200
    23.625     1.749     0.200
    23.758     1.526     0.200
    25.770     0.129     0.200
    26.230     0.064     0.200
    26.230     0.264     0.200
    27.172     0.589     0.200
    28.050    -0.065     0.200
    28.502     0.611     0.200
    29.483    -2.991     0.200
    29.583    -1.875     0.200
    29.869     0.089     0.200
    31.053    -0.365     0.200
    31.973     0.545     0.200
    32.198     1.572     0.200
    33.006     1.203     0.200
    33.283     1.591     0.200
    33.950     2.784     0.200
    34.617     1.012     0.200
    35.043    -0.660     0.200
    36.502    -0.157     0.200
    36.502     0.244     0.200
    36.625    -0.405     0.200
    36.800     1.504     0.200
    36.855     2.140     0.200
    37.710    -0.412     0.200
    37.710     0.088     0.200
    37.719    -0.485     0.200
    37.719     0.015     0.200
    40.245    -0.600     0.200
    40.460     1.517     0.200
    40.748     0.843     0.200
    40.925     0.786     0.200
    41.015     0.642     0.200
    41.532     0.404     0.200
    42.183     0.684     0.200
    44.126    -0.205     0.200
    44.126     0.596     0.200
    45.117    -0.098     0.200
    45.442     1.327     0.200
    45.442     1.728     0.200
    46.031    -1.327     0.200
    45.981     0.069     0.200
    45.981     0.869     0.200
    46.525     1.896     0.200
    48.011    -0.761     0.200
    48.637    -0.590     0.200
    49.477     1.088     0.200
    50.488     0.222     0.200
    51.243    -0.354     0.200
    51.959    -0.302     0.200
    52.344    -2.558     0.200
    52.344    -2.257     0.200
    52.370     0.443     0.200
    53.131    -0.370     0.200
    53.939    -1.294     0.200
    53.939    -0.595     0.200
    53.887     1.285     0.200
    56.222     0.238     0.200
    56.222     0.638     0.200
    61.134     0.092     0.200
    61.909    -2.132     0.200
    61.909    -1.632     0.200
    64.030    -2.214     0.200
    64.115     1.224     0.200
    65.397     1.379     0.200
    68.659    -0.830     0.200
    68.659    -0.330     0.200
    74.678    -0.006     0.200
    74.698    -0.121     0.200
    77.085     0.269     0.200
    80.213    -0.931     0.200
    80.851    -0.448     0.200
    84.067    -0.410     0.200
    85.183    -0.638     0.200
    85.458    -0.111     0.200
    85.942     0.492     0.200
    86.632    -0.904     0.200
    90.652    -0.931     0.200
    90.652    -0.531     0.200
    91.046    -2.162     0.200
    91.659    -1.404     0.200
    91.728    -0.921     0.200
    91.728    -0.521     0.200
    92.412    -1.685     0.200
    95.035    -0.143     0.200
    95.063     0.328     0.200
    95.446    -1.019     0.200
    95.936     0.247     0.200
    15.779     7.669     0.200
    16.069     7.322     0.200
    17.108     1.948     0.200
    21.484     0.770     0.200
    22.640     1.931     0.200
    22.842    -0.711     0.200
    22.834     1.274     0.200
    23.605     0.900     0.200
    23.842     1.732     0.200
    23.996     0.322     0.200
    24.102     1.757     0.200
    24.700     1.901     0.200
    25.896     2.036     0.200
    26.086     0.215     0.200
    26.271     1.145     0.200
    26.538     1.133     0.200
    26.538     0.133     0.200
    27.226     0.342     0.200
    28.702     0.853     0.200
    29.960    -1.102     0.200
    30.939    -2.352     0.200
    30.992    -1.815     0.200
    31.103     0.103     0.200
    31.956     0.298     0.200
    32.361     2.039     0.200
    33.089    -0.033     0.200
    33.378     1.144     0.200
    33.488    -0.813     0.200
    33.918    -0.350     0.200
    34.408    -0.507     0.200
    34.980     0.255     0.200
    36.445    -0.017     0.200
    36.964     1.355     0.200
    39.583     0.705     0.200
    40.106    -0.439     0.200
    40.106    -0.639     0.200
    40.740     1.516     0.200
    40.925    -0.412     0.200
    41.030     0.925     0.200
    41.206     0.877     0.200
    41.297     0.724     0.200
    41.813     0.501     0.200
    43.117     0.692     0.200
    44.217    -0.165     0.200
    44.217     0.035     0.200
    45.443     2.064     0.200
    45.851    -0.558     0.200
    46.076     0.064     0.200
    46.076     0.564     0.200
    46.407    -0.038     0.200
    46.407    -0.538     0.200
    46.428     0.295     0.200
    46.710     1.583     0.200
    48.657    -1.025     0.200
    48.657    -0.225     0.200
    49.348     2.275     0.200
    49.973     0.912     0.200
    50.360     0.884     0.200
    50.512     1.230     0.200
    51.704    -0.118     0.200
    52.524     0.777     0.200
    53.268    -0.716     0.200
    53.268    -0.616     0.200
    54.198     1.274     0.200
    54.594    -0.407     0.200
    54.621     1.394     0.200
    55.132     0.700     0.200
    55.132     0.800     0.200
    56.467     0.124     0.200
    56.467     0.524     0.200
    57.515     0.702     0.200
    57.875    -0.834     0.200
    59.133    -0.605     0.200
    59.133    -0.205     0.200
    61.305    -0.483     0.200
    61.874    -1.318     0.200
    64.085    -2.019     0.200
    64.381     0.442     0.200
    65.656     0.752     0.200
    66.747     0.751     0.200
    68.786    -0.503     0.200
    68.825    -0.347     0.200
    74.932     0.989     0.200
    76.358     0.828     0.200
    76.684     0.481     0.200
    77.051     0.912     0.200
    77.320    -0.597     0.200
    77.539    -0.325     0.200
    81.030    -0.884     0.200
    81.564    -0.716     0.200
    84.176    -0.967     0.200
    84.917     0.986     0.200
    85.074     1.196     0.200
    85.308    -1.476     0.200
    85.317    -1.622     0.200
    86.509    -1.419     0.200
    88.180     4.512     0.200
    88.598     0.040     0.200
    88.598     0.540     0.200
    89.216     2.134     0.200
    89.216     2.634     0.200
    90.856    -0.520     0.200
    90.856    -0.220     0.200
    91.068    -2.305     0.200
    91.797    -2.687     0.200
    91.875     0.753     0.200
    91.922    -1.467     0.200
    91.922    -1.067     0.200
    92.543    -2.134     0.200
    95.224    -0.657     0.200
    95.247     0.237     0.200
    96.128    -0.277     0.200
    96.128     0.523     0.200
    21.385     1.058     0.200
    22.756     1.336     0.200
    22.778     0.699     0.200
    23.416    -2.026     0.200
    23.847     2.168     0.200
    24.255     1.039     0.200
    26.615    -0.175     0.200
    28.696     0.201     0.200
    29.309    -1.243     0.200
    29.892    -1.214     0.200
    31.013    -1.115     0.200
    31.066    -1.978     0.200
    31.016     0.166     0.200
    31.840     0.711     0.200
    33.018     1.586     0.200
    33.539    -1.260     0.200
    34.846     0.703     0.200
    34.951     0.301     0.200
    36.936     1.098     0.200
    40.790     1.611     0.200
    41.082     1.001     0.200
    41.257     0.963     0.200
    41.350     1.202     0.200
    41.864     0.390     0.200
    43.022     0.772     0.200
    44.149    -0.303     0.200
    45.541     0.605     0.200
    46.486     0.158     0.200
    46.486     0.259     0.200
    46.540     1.840     0.200
    46.694     1.030     0.200
    48.555     0.078     0.200
    48.555     0.277     0.200
    49.398     1.815     0.200
    50.410     0.828     0.200
    51.673    -0.565     0.200
    52.173    -0.285     0.200
    52.477     1.958     0.200
    53.152     1.272     0.200
    53.668    -1.321     0.200
    53.668    -0.520     0.200
    54.567    -0.877     0.200
    54.567    -0.577     0.200
    54.627     0.687     0.200
    54.627     1.187     0.200
    55.159     0.835     0.200
    55.159     0.937     0.200
    55.500     0.377     0.200
    55.500     0.877     0.200
    56.490     0.296     0.200
    56.490     0.397     0.200
    57.429     1.646     0.200
    57.541    -0.142     0.200
    57.541     0.358     0.200
    61.280    -0.469     0.200
    61.750    -2.141     0.200
    61.750    -1.641     0.200
    64.419     1.140     0.200
    65.499     1.114     0.200
    65.689     1.087     0.200
    66.778    -2.095     0.200
    67.799    -0.565     0.200
    67.799    -0.264     0.200
    68.628    -0.761     0.200
    68.797    -0.815     0.200
    74.962     0.181     0.200
    77.074     1.152     0.200
    77.335    -0.316     0.200
    81.010    -3.402     0.200
    84.116    -0.688     0.200
    85.271    -1.515     0.200
    86.386    -0.939     0.200
    86.469    -0.644     0.200
    91.788    -2.262     0.200
    92.495    -2.330     0.200
    16.036     5.510     0.200
    16.122     4.403     0.200
    17.117     2.333     0.200
    17.129     5.679     0.200
    19.969    -2.218     0.200
    19.969    -2.220     0.200
    21.391     1.286     0.200
    22.757     0.516     0.200
    22.770     0.881     0.200
    23.417    -1.933     0.200
    23.643     2.955     0.200
    23.821     2.723     0.200
    24.203     0.542     0.200
    26.573    -0.671     0.200
    28.137    -1.201     0.200
    28.673    -0.074     0.200
    29.888    -0.943     0.200
    31.016    -1.205     0.200
    31.018     0.278     0.200
    31.852     0.734     0.200
    33.014     0.847     0.200
    33.548    -1.212     0.200
    33.308     1.686     0.200
    33.810    -0.489     0.200
    34.490    -0.687     0.200
    34.490     0.414     0.200
    34.865    -0.328     0.200
    34.914    -0.250     0.200
    36.484     0.781     0.200
    36.920     0.370     0.200
    40.754     1.447     0.200
    41.045     1.243     0.200
    41.221     0.999     0.200
    41.313     1.143     0.200
    41.828     1.026     0.200
    44.144    -0.128     0.200
    45.496     0.110     0.200
    46.005     0.086     0.200
    46.005     0.887     0.200
    46.487    -0.703     0.200
    46.487    -0.203     0.200
    46.492    -1.139     0.200
    46.674     1.027     0.200
    48.562     0.172     0.200
    48.562     0.371     0.200
    52.189    -0.956     0.200
    53.125    -0.184     0.200
    53.212    -1.824     0.200
    53.212    -1.324     0.200
    53.695    -2.368     0.200
    53.695    -2.067     0.200
    54.550    -0.605     0.200
    54.601     1.024     0.200
    55.128    -1.289     0.200
    57.510     0.228     0.200
    57.863     0.747     0.200
    57.863     0.946     0.200
    61.263    -0.695     0.200
    61.765    -2.084     0.200
    64.001    -1.957     0.200
    64.386    -0.480     0.200
    65.657     0.559     0.200
    67.784    -1.303     0.200
    68.658    -0.286     0.200
    74.931     0.531     0.200
    76.601    -0.016     0.200
    77.044     1.290     0.200
    77.307     0.011     0.200
    80.027    -1.957     0.200
    80.027    -1.355     0.200
    80.991     1.869     0.200
    81.497    -1.819     0.200
    81.497    -0.920     0.200
    83.514    -1.335     0.200
    84.109    -0.575     0.200
    85.179    -0.778     0.200
    85.260    -1.881     0.200
    86.411    -0.883     0.200
    86.456    -1.803     0.200
    91.742    -1.466     0.200
    92.484    -2.103     0.200
    17.118     4.042     0.200
    21.370     1.526     0.200
    22.738    -1.178     0.200
    22.755     1.140     0.200
    24.105     0.661     0.200
    24.224     1.175     0.200
    26.580     0.791     0.200
    27.122     0.707     0.200
    28.125     0.131     0.200
    29.871     0.819     0.200
    31.033    -1.041     0.200
    31.086    -1.505     0.200
    30.998    -0.534     0.200
    31.829     0.756     0.200
    32.306     0.965     0.200
    32.997     1.306     0.200
    33.562    -1.321     0.200
    34.509    -2.237     0.200
    34.840     0.402     0.200
    34.917     0.435     0.200
    36.909     1.163     0.200
    40.756     1.921     0.200
    41.048     0.514     0.200
    41.223     0.873     0.200
    41.316     1.011     0.200
    41.830     0.497     0.200
    45.506     1.506     0.200
    45.899     0.404     0.200
    46.505     1.633     0.200
    46.505     0.736     0.200
    46.666     1.573     0.200
    49.422     1.754     0.200
    50.434     0.469     0.200
    50.585     0.221     0.200
    64.386     0.954     0.200
    85.151    -1.236     0.200
    86.384    -1.354     0.200
    92.471    -2.049     0.200
    21.429     1.183     0.200
    22.783     0.742     0.200
    22.767     1.908     0.200
    23.398    -2.246     0.200
    23.941     0.704     0.200
    24.053     1.578     0.200
    25.821     3.600     0.200
    26.465    -0.231     0.200
    27.166     0.359     0.200
    28.121     0.409     0.200
    28.628    -0.002     0.200
    29.102    -0.016     0.200
    29.896     0.552     0.200
    31.044     0.511     0.200
    31.002    -1.925     0.200
    31.055    -2.485     0.200
    31.907     0.614     0.200
    32.290     2.055     0.200
    33.556    -1.020     0.200
    33.871    -1.156     0.200
    34.939    -0.001     0.200
    34.823     0.493     0.200
    36.893     1.659     0.200
    40.664     1.439     0.200
    40.955     0.644     0.200
    41.131     0.996     0.200
    41.222     0.844     0.200
    41.737     0.819     0.200
    45.374     1.523     0.200
    46.362     0.226     0.200
    46.469    -0.110     0.200
    46.637     0.570     0.200
    49.417     1.269     0.200
    50.428     0.187     0.200
    56.391     0.594     0.200
    64.305     0.082     0.200
    68.753    -0.347     0.200
    71.182     0.136     0.200
    71.194     1.062     0.200
    71.359     1.066     0.200
    71.430     0.637     0.200
    80.957    -2.728     0.200
    84.079    -2.004     0.200
    84.109    -0.559     0.200
    84.842     0.333     0.200
    84.999     0.543     0.200
    86.499    -0.898     0.200
    91.013    -2.272     0.200
    21.452     0.321     0.200
    22.812    -0.183     0.200
    22.810    -0.158     0.200
    24.129     1.959     0.200
    26.620     2.249     0.200
    28.169    -0.650     0.200
    28.688     0.536     0.200
    29.933    -0.309     0.200
    30.967    -0.543     0.200
    31.020    -0.406     0.200
    31.072    -0.371     0.200
    33.062     0.767     0.200
    33.511    -1.759     0.200
    34.438     0.598     0.200
    34.942    -1.457     0.200
    34.898     0.223     0.200
    36.462    -0.703     0.200
    36.945     1.681     0.200
    40.738     1.798     0.200
    41.205     1.257     0.200
    45.454     1.757     0.200
    46.443     1.961     0.200
    46.694     1.391     0.200
    50.383     0.791     0.200
    64.376     0.873     0.200
    83.559     0.710     0.200
    84.150    -0.512     0.200
    85.267    -1.744     0.200
    85.295    -1.781     0.200
    86.493    -1.514     0.200
    86.487    -1.285     0.200
    92.520    -2.396     0.200
    15.779     1.334     0.200
    16.926     4.401     0.200
    20.968     1.076     0.200
    22.362    -1.011     0.200
    22.448     1.079     0.200
    23.662     1.882     0.200
    23.715     0.396     0.200
    24.542     2.358     0.200
    25.801     2.421     0.200
    26.217     0.663     0.200
    26.631     1.232     0.200
    26.749    -0.932     0.200
    27.852    -0.513     0.200
    28.481     0.586     0.200
    28.614     0.203     0.200
    28.668    -2.280     0.200
    28.668    -2.479     0.200
    29.536     1.621     0.200
    30.620    -0.554     0.200
    31.441    -2.189     0.200
    31.444    -2.221     0.200
    31.393     0.230     0.200
    32.653    -0.825     0.200
    32.961    -0.116     0.200
    33.339    -0.816     0.200
    33.864    -1.777     0.200
    34.375     0.101     0.200
    34.892     1.531     0.200
    36.724    -1.250     0.200
    36.667     0.935     0.200
    40.725     1.538     0.200
    41.023     0.886     0.200
    41.196     0.865     0.200
    41.802     0.700     0.200
    42.611     0.516     0.200
    43.790    -0.995     0.200
    43.790    -0.495     0.200
    44.858    -0.524     0.200
    45.621     1.923     0.200
    46.453     0.884     0.200
    46.665     1.424     0.200
    46.665     2.225     0.200
    46.870     0.718     0.200
    46.811     1.077     0.200
    46.811     1.276     0.200
    47.966     1.106     0.200
    50.027    -0.663     0.200
    50.138     1.494     0.200
    50.883     0.875     0.200
    51.800     0.014     0.200
    51.710    -0.512     0.200
    52.917    -1.266     0.200
    53.177    -0.176     0.200
    54.299    -0.482     0.200
    55.030    -0.676     0.200
    55.030     0.224     0.200
    56.349    -0.127     0.200
    56.349     0.674     0.200
    57.381     1.569     0.200
    61.017    -0.567     0.200
    61.292    -1.422     0.200
    63.606    -1.870     0.200
    64.319     0.446     0.200
    68.133    -0.381     0.200
    71.984    -1.772     0.200
    76.479     0.463     0.200
    77.062     0.578     0.200
    77.214     1.126     0.200
    77.444     0.742     0.200
    78.981    -0.664     0.200
    79.497    -1.476     0.200
    79.497    -0.575     0.200
    82.287    -1.044     0.200
    83.722    -0.964     0.200
    83.774    -1.030     0.200
    84.653    -0.889     0.200
    85.021    -1.338     0.200
    85.274    -1.805     0.200
    86.170    -0.544     0.200
    86.426    -1.203     0.200
    92.178    -2.606     0.200
    95.917    -0.669     0.200
    22.459     1.123     0.200
    27.861     0.075     0.200
    28.484     1.220     0.200
    29.550     0.054     0.200
    31.425    -1.411     0.200
    31.429    -2.044     0.200
    31.415    -0.024     0.200
    32.069     1.324     0.200
    32.668     1.076     0.200
    33.362     3.004     0.200
    33.852    -1.264     0.200
    34.863    -0.421     0.200
    34.863    -0.622     0.200
    34.885     1.787     0.200
    36.674     1.343     0.200
    46.647     1.979     0.200
    51.802     0.339     0.200
    51.733    -1.747     0.200
    83.736    -1.365     0.200
    84.681    -1.672     0.200
    17.024     4.880     0.200
    20.940     1.231     0.200
    22.330     0.813     0.200
    22.410     0.967     0.200
    23.616     1.727     0.200
    25.754     1.855     0.200
    27.811    -0.286     0.200
    28.436     0.949     0.200
    31.370    -0.626     0.200
    32.020     1.052     0.200
    32.925     0.119     0.200
    33.318     0.185     0.200
    33.902    -1.503     0.200
    34.912    -0.547     0.200
    34.912    -0.748     0.200
    34.844     1.041     0.200
    36.625     0.861     0.200
    36.990     3.050     0.200
    40.677     1.598     0.200
    41.078    -0.774     0.200
    40.975     0.742     0.200
    41.148     0.895     0.200
    41.243     0.947     0.200
    41.754     0.662     0.200
    44.893    -1.073     0.200
    45.574     1.520     0.200
    46.409     1.536     0.200
    46.618     2.292     0.200
    51.847     0.387     0.200
    56.302     0.372     0.200
    57.332     1.458     0.200
    79.889    -1.117     0.200
    83.687    -1.842     0.200
    84.648    -1.235     0.200
    20.994     1.039     0.200
    22.471     3.206     0.200
    23.680     3.013     0.200
    27.874    -0.079     0.200
    28.500     0.041     0.200
    30.645     0.527     0.200
    31.416    -2.372     0.200
    31.420    -2.404     0.200
    31.419     0.998     0.200
    32.083     1.858     0.200
    32.678     2.146     0.200
    34.855    -1.395     0.200
    34.855    -1.193     0.200
    34.904     0.578     0.200
    36.307    -0.272     0.200
    36.688     1.477     0.200
    46.667     4.358     0.200
    46.845     0.267     0.200
    51.785    -0.098     0.200
    83.746    -1.427     0.200
    84.678    -1.561     0.200
    15.825     2.591     0.200
    17.061     4.832     0.200
    20.973     2.377     0.200
    22.207     0.926     0.200
    22.364     3.248     0.200
    22.446     0.373     0.200
    23.122    -0.082     0.200
    23.800    -0.562     0.200
    23.654     2.170     0.200
    24.522     0.541     0.200
    25.791     3.504     0.200
    26.171    -1.134     0.200
    26.203     2.582     0.200
    26.617     1.243     0.200
    26.617     0.842     0.200
    27.034     1.081     0.200
    27.034     1.681     0.200
    27.849    -0.731     0.200
    28.474    -0.005     0.200
    29.537     2.060     0.200
    31.450    -1.843     0.200
    31.400    -0.702     0.200
    32.058     0.507     0.200
    32.654     0.680     0.200
    32.961     0.092     0.200
    33.203     0.476     0.200
    33.347     0.223     0.200
    33.865    -2.290     0.200
    34.384     1.810     0.200
    34.877    -0.560     0.200
    34.880     0.914     0.200
    36.728    -1.937     0.200
    36.663     0.221     0.200
    37.027    -0.980     0.200
    39.467    -3.035     0.200
    39.467    -2.735     0.200
    39.913     2.253     0.200
    41.047    -1.131     0.200
    41.011     0.747     0.200
    41.184     0.762     0.200
    41.280     0.378     0.200
    41.790     0.288     0.200
    42.615     1.042     0.200
    43.239    -2.012     0.200
    43.791    -1.462     0.200
    43.791    -0.962     0.200
    44.857    -0.400     0.200
    45.076     3.258     0.200
    45.076     3.457     0.200
    45.606     2.056     0.200
    45.656    -0.343     0.200
    45.656     0.457     0.200
    46.098     1.170     0.200
    46.447     0.618     0.200
    46.648     1.447     0.200
    47.954     0.667     0.200
    48.138    -1.751     0.200
    48.138    -1.152     0.200
    49.723     1.388     0.200
    50.122     0.548     0.200
    50.735    -1.385     0.200
    50.884     1.290     0.200
    51.810     0.353     0.200
    52.200    -2.056     0.200
    52.825     3.814     0.200
    52.817     3.872     0.200
    52.915    -2.855     0.200
    52.915    -2.054     0.200
    53.019    -0.619     0.200
    53.189     1.127     0.200
    53.189     1.627     0.200
    55.021     0.757     0.200
    55.021     1.257     0.200
    56.471     3.345     0.200
    56.471     4.245     0.200
    57.368     1.986     0.200
    57.722     1.497     0.200
    61.013    -1.258     0.200
    61.299    -0.198     0.200
    63.609     1.057     0.200
    64.308     0.753     0.200
    65.375     4.804     0.200
    67.519     1.078     0.200
    71.203     0.277     0.200
    71.446     0.810     0.200
    79.511    -1.893     0.200
    79.596     2.745     0.200
    84.666    -0.548     0.200
    85.019    -1.523     0.200
    85.570     0.222     0.200
    86.167     0.961     0.200
    88.510     5.649     0.200
    90.627    -0.263     0.200
    91.059    -0.272     0.200
    95.351     1.957     0.200
    26.431     2.815     0.200
    30.612     0.051     0.200
    31.973     1.959     0.200
    34.715     0.656     0.200
    34.892    -1.576     0.200
    40.550     1.118     0.200
    40.846     0.431     0.200
    41.020     0.742     0.200
    41.114     0.800     0.200
    41.626    -0.239     0.200
    44.894    -0.558     0.200
    45.407     1.963     0.200
    51.768    -0.992     0.200
    51.952     0.534     0.200
    64.156     1.324     0.200
    84.782    -1.733     0.200
    85.416     0.591     0.200
    85.997    -0.794     0.200
    16.947     4.645     0.200
    21.040     1.188     0.200
    23.586     1.883     0.200
    26.799    -0.021     0.200
    27.838    -0.144     0.200
    28.420    -0.332     0.200
    29.561     0.334     0.200
    30.674    -0.511     0.200
    31.413    -3.130     0.200
    31.493     1.169     0.200
    32.032     2.027     0.200
    32.684     1.414     0.200
    32.983     1.494     0.200
    33.859    -1.649     0.200
    34.830    -1.061     0.200
    34.759     0.460     0.200
    36.236    -0.438     0.200
    36.636     1.144     0.200
    40.595     0.524     0.200
    40.890     0.467     0.200
    41.064     1.175     0.200
    41.158     0.720     0.200
    41.670     0.774     0.200
    43.527    -2.028     0.200
    44.832    -0.491     0.200
    45.437     1.198     0.200
    49.718     1.639     0.200
    51.827    -1.061     0.200
    51.903     0.681     0.200
    76.005    -0.307     0.200
    77.249    -0.137     0.200
    79.181    -1.133     0.200
    80.558     0.098     0.200
    84.832    -1.526     0.200
    86.052    -1.109     0.200
    15.864     4.425     0.200
    20.941     2.006     0.200
    21.993     1.900     0.200
    22.306     2.357     0.200
    23.400     2.288     0.200
    23.811     0.854     0.200
    25.242     1.806     0.200
    25.242     1.806     0.200
    27.261     0.653     0.200
    29.182    -0.379     0.200
    30.458     0.620     0.200
    31.367     1.607     0.200
    31.543    -1.444     0.200
    31.769    -1.730     0.200
    32.334     1.808     0.200
    33.633    -0.152     0.200
    34.398    -1.393     0.200
    34.734     0.301     0.200
    35.128    -1.303     0.200
    35.965     1.506     0.200
    36.255    -0.970     0.200
    39.478     1.205     0.200
    39.764     0.419     0.200
    39.941     0.344     0.200
    40.031     1.598     0.200
    40.548     0.313     0.200
    44.144     1.428     0.200
    45.254    -0.722     0.200
    45.654     2.406     0.200
    46.618    -0.384     0.200
    47.139    -0.462     0.200
    50.370     2.804     0.200
    51.265     0.463     0.200
    51.423     0.279     0.200
    63.142     0.992     0.200
    80.040     0.497     0.200
    80.258     0.216     0.200
    80.457     0.346     0.200
    83.331    -0.981     0.200
    84.443    -1.164     0.200
    85.391    -0.625     0.200
    86.411    -0.679     0.200
    91.440    -1.474     0.200
    95.080    -0.744     0.200
    15.960     6.733     0.200
    16.266     7.602     0.200
    20.025    -0.219     0.200
    20.025     0.082     0.200
    21.139     0.706     0.200
    21.606     0.680     0.200
    21.606     1.579     0.200
    22.529     0.833     0.200
    22.602     1.552     0.200
    23.001     3.533     0.200
    23.076     2.038     0.200
    23.636    -0.860     0.200
    23.767     1.145     0.200
    23.780     1.628     0.200
    24.228     2.935     0.200
    24.498    -0.230     0.200
    24.483    -0.298     0.200
    24.903     2.777     0.200
    25.098     0.006     0.200
    25.098     0.608     0.200
    25.812    -0.472     0.200
    25.812     0.427     0.200
    25.901     0.716     0.200
    26.060     0.279     0.200
    26.915     0.161     0.200
    27.142     0.217     0.200
    27.783    -1.425     0.200
    27.999     0.844     0.200
    28.607     0.628     0.200
    28.704    -1.133     0.200
    28.722    -0.393     0.200
    28.832    -2.474     0.200
    29.696     0.659     0.200
    30.787     0.118     0.200
    30.960    -0.207     0.200
    31.280    -1.834     0.200
    31.567    -0.355     0.200
    32.203     1.158     0.200
    32.390    -1.688     0.200
    32.815     1.293     0.200
    33.120     0.225     0.200
    33.514    -0.608     0.200
    33.710    -1.516     0.200
    34.549     0.105     0.200
    34.973     0.842     0.200
    35.844     2.049     0.200
    36.807     1.021     0.200
    37.046     0.790     0.200
    37.113    -1.783     0.200
    37.079     1.008     0.200
    37.134     2.645     0.200
    39.090     1.651     0.200
    39.209     1.542     0.200
    39.622    -0.084     0.200
    39.908     1.653     0.200
    40.469     1.778     0.200
    40.807    -1.209     0.200
    40.808     1.503     0.200
    41.104     1.004     0.200
    41.278     0.775     0.200
    41.372     0.839     0.200
    41.884     0.708     0.200
    42.698     1.132     0.200
    42.725     1.196     0.200
    42.781     0.142     0.200
    43.308     1.277     0.200
    43.951    -0.799     0.200
    44.694    -0.847     0.200
    45.238    -1.273     0.200
    45.656     1.109     0.200
    46.040     1.883     0.200
    46.586     0.287     0.200
    46.705     0.059     0.200
    46.684     1.023     0.200
    48.304    -0.378     0.200
    50.568     0.138     0.200
    50.568     0.638     0.200
    50.730     2.421     0.200
    51.698     0.259     0.200
    51.884    -1.031     0.200
    61.156    -0.739     0.200
    65.483     1.803     0.200
    67.217     0.501     0.200
    67.665    -0.838     0.200
    68.300    -0.727     0.200
    68.667    -1.625     0.200
    68.667    -1.125     0.200
    74.970    -0.490     0.200
    75.968    -0.507     0.200
    75.998    -0.018     0.200
    76.502     0.749     0.200
    76.646    -0.656     0.200
    76.708     0.585     0.200
    77.224    -0.249     0.200
    77.441    -1.087     0.200
    77.556     0.021     0.200
    77.641    -0.438     0.200
    77.683    -0.969     0.200
    77.765    -0.018     0.200
    78.052     0.385     0.200
    78.574     1.844     0.200
    78.623    -1.959     0.200
    79.030     1.991     0.200
    79.138    -1.945     0.200
    79.136     1.583     0.200
    79.654     3.262     0.200
    79.657    -1.930     0.200
    79.657    -1.157     0.200
    80.518     0.197     0.200
    80.678    -0.946     0.200
    80.893    -1.415     0.200
    81.498    -0.230     0.200
    81.920    -0.157     0.200
    82.042    -0.495     0.200
    82.442    -0.491     0.200
    82.913     0.060     0.200
    83.934     2.308     0.200
    83.958     2.084     0.200
    84.010    -1.685     0.200
    84.266     1.016     0.200
    84.276     2.066     0.200
    84.344     2.221     0.200
    84.343     0.822     0.200
    84.353     1.873     0.200
    84.363     4.521     0.200
    84.407     1.998     0.200
    84.479     1.935     0.200
    84.554     1.951     0.200
    84.695     2.041     0.200
    84.818    -0.275     0.200
    84.999     2.112     0.200
    85.128     0.993     0.200
    85.161     2.101     0.200
    85.171    -1.650     0.200
    85.299     1.708     0.200
    85.302     1.795     0.200
    85.311     1.082     0.200
    85.459     0.015     0.200
    85.673    -0.050     0.200
    85.983    -0.588     0.200
    86.072    -1.027     0.200
    86.318    -1.040     0.200
    87.405    -4.244     0.200
    88.533    -0.914     0.200
    89.862    -1.753     0.200
    90.716    -2.230     0.200
    90.761    -0.139     0.200
    90.893     1.048     0.200
    91.595    -2.209     0.200
    91.806    -2.186     0.200
    91.890    -0.272     0.200
    92.330    -2.807     0.200
    92.590    -1.510     0.200
    93.544    -2.510     0.200
    93.747    -0.142     0.200
    93.931    -2.489     0.200
    94.181    -0.838     0.200
    95.118    -0.330     0.200
    95.492    -1.139     0.200
    96.012    -0.009     0.200
    96.048    -0.775     0.200
    96.564    -0.114     0.200
    96.595    -0.853     0.200
    97.193    -0.360     0.200
    97.950    -1.075     0.200
    97.958    -1.110     0.200
    98.233    -1.348     0.200
    98.247    -1.106     0.200
    15.424     2.216     0.200
    16.354     3.210     0.200
    16.514     1.706     0.200
    21.145     0.474     0.200
    22.013     3.695     0.200
    22.318     2.960     0.200
    22.446     0.405     0.200
    23.153     1.657     0.200
    23.271     1.539     0.200
    23.417     0.601     0.200
    24.153    -1.019     0.200
    24.081    -1.368     0.200
    24.156    -1.347     0.200
    24.903     3.848     0.200
    25.163     2.289     0.200
    25.927     0.766     0.200
    25.657     0.507     0.200
    25.754     2.129     0.200
    26.239     2.243     0.200
    27.623    -0.388     0.200
    28.039     0.409     0.200
    28.855     0.154     0.200
    29.396    -0.345     0.200
    29.483     2.581     0.200
    30.706    -0.725     0.200
    31.458    -2.046     0.200
    31.462    -1.081     0.200
    31.698    -0.958     0.200
    31.756     1.536     0.200
    32.626     0.905     0.200
    33.693    -1.392     0.200
    34.038    -1.085     0.200
    34.843    -1.647     0.200
    34.843    -0.942     0.200
    34.823    -0.173     0.200
    36.064    -1.022     0.200
    36.356     1.181     0.200
    36.371     3.059     0.200
    36.794    -0.348     0.200
    38.258     1.060     0.200
    38.366     0.977     0.200
    39.634     1.476     0.200
    40.127     1.486     0.200
    40.440     0.639     0.200
    40.738    -1.654     0.200
    40.531     1.052     0.200
    40.902    -0.005     0.200
    41.047     0.259     0.200
    41.890     0.559     0.200
    42.465     0.860     0.200
    44.107    -1.514     0.200
    44.927    -1.255     0.200
    44.658     1.185     0.200
    45.065     2.448     0.200
    45.651     3.315     0.200
    46.247    -1.079     0.200
    46.059     0.603     0.200
    46.850    -0.297     0.200
    48.183     0.760     0.200
    49.187     2.353     0.200
    49.757     0.612     0.200
    49.897     1.252     0.200
    50.249     0.786     0.200
    50.908     0.723     0.200
    51.440    -0.160     0.200
    51.440     0.039     0.200
    51.747     2.046     0.200
    52.098    -1.964     0.200
    52.443     1.180     0.200
    52.028     0.453     0.200
    53.928     1.461     0.200
    60.686     0.341     0.200
    63.369    -1.647     0.200
    63.631     1.126     0.200
    64.723     2.970     0.200
    64.723     3.169     0.200
    64.902    -3.994     0.200
    66.470     0.708     0.200
    67.225     0.409     0.200
    68.214    -0.868     0.200
    68.214    -0.317     0.200
    76.011     1.098     0.200
    76.603    -0.058     0.200
    76.662    -0.389     0.200
    76.607    -0.277     0.200
    76.729     0.335     0.200
    76.723     1.316     0.200
    76.870     1.138     0.200
    76.877     0.262     0.200
    76.877     0.401     0.200
    77.809    -1.515     0.200
    77.788     1.159     0.200
    78.300     1.398     0.200
    79.297    -2.201     0.200
    79.297    -1.901     0.200
    79.795    -1.806     0.200
    80.262    -0.428     0.200
    80.397     0.298     0.200
    83.104    -1.337     0.200
    83.655    -0.728     0.200
    83.970    -0.340     0.200
    84.809    -0.481     0.200
    85.050    -0.890     0.200
    85.355    -1.112     0.200
    85.931    -0.269     0.200
    86.456    -1.154     0.200
    86.760     0.758     0.200
    89.482    -1.181     0.200
    90.723    -1.568     0.200
    91.232    -1.029     0.200
    91.228     2.187     0.200
    91.972    -1.056     0.200
    91.990    -1.642     0.200
    94.606     0.416     0.200
    94.904    -1.248     0.200
    95.475     1.145     0.200
    95.506    -0.697     0.200
    95.506    -0.299     0.200
    96.674     0.295     0.200
    16.932     4.765     0.200
    20.967     0.311     0.200
    22.362     2.949     0.200
    22.450    -0.495     0.200
    23.670     2.079     0.200
    24.037    -2.180     0.200
    25.811     4.177     0.200
    26.749    -1.306     0.200
    27.856    -1.145     0.200
    28.264    -0.885     0.200
    28.488    -0.278     0.200
    28.659     0.893     0.200
    30.600     1.392     0.200
    31.440    -1.714     0.200
    31.451    -2.609     0.200
    31.390    -0.371     0.200
    32.655    -0.081     0.200
    34.370    -1.026     0.200
    34.880    -0.742     0.200
    34.880    -1.138     0.200
    34.903    -1.140     0.200
    36.336    -0.151     0.200
    37.047     0.991     0.200
    37.292     0.305     0.200
    39.018     1.745     0.200
    39.139     0.793     0.200
    40.398     1.637     0.200
    40.983    -0.961     0.200
    41.813    -0.132     0.200
    43.238     0.360     0.200
    43.954     0.882     0.200
    44.167    -0.650     0.200
    44.445     0.344     0.200
    44.853    -0.633     0.200
    45.119     0.745     0.200
    45.508    -0.542     0.200
    45.523    -0.977     0.200
    45.635     2.459     0.200
    46.082    -1.875     0.200
    46.449     1.042     0.200
    49.577    -0.376     0.200
    50.067     0.202     0.200
    51.791     0.018     0.200
    52.737     0.789     0.200
    54.014    -1.001     0.200
    68.531    -1.867     0.200
    79.463    -3.433     0.200
    84.644     0.269     0.200
    85.278    -1.319     0.200
    91.066    -1.089     0.200
    24.009    -1.628     0.200
    28.223    -1.428     0.200
    31.411    -2.268     0.200
    31.422    -2.363     0.200
    31.430     1.070     0.200
    34.849    -0.683     0.200
    34.849    -1.083     0.200
    44.827    -0.740     0.200
    50.102     0.316     0.200
    51.794    -0.222     0.200
    54.033     1.641     0.200
    23.586    -1.606     0.200
    26.558     1.672     0.200
    28.765     0.715     0.200
    31.081     0.728     0.200
    31.100     0.047     0.200
    31.926    -0.216     0.200
    34.406     0.480     0.200
    37.011     1.774     0.200
    44.056     0.672     0.200
    44.415    -0.038     0.200
    44.541     0.646     0.200
    45.616     0.244     0.200
    54.705     1.017     0.200
    55.077     1.404     0.200
    64.474    -0.166     0.200
    80.459    -2.300     0.200
    85.225    -0.718     0.200
    89.637    -1.826     0.200
    94.741    -1.004     0.200
    23.292    -1.579     0.200
    23.121     0.922     0.200
    23.166     3.646     0.200
    23.752     0.004     0.200
    24.241     2.083     0.200
    26.309     3.092     0.200
    26.860     0.824     0.200
    27.487    -1.915     0.200
    27.870     0.258     0.200
    28.544    -0.150     0.200
    29.093     0.872     0.200
    31.361     1.127     0.200
    31.380    -0.154     0.200
    32.167     0.728     0.200
    32.729     1.998     0.200
    34.122    -1.452     0.200
    34.122    -1.550     0.200
    35.140     0.648     0.200
    35.318     0.510     0.200
    36.069    -0.581     0.200
    37.333     1.094     0.200
    37.529     2.232     0.200
    37.622     1.044     0.200
    39.832     1.113     0.200
    40.207    -1.615     0.200
    40.173     1.162     0.200
    44.116    -0.510     0.200
    44.374     2.820     0.200
    44.859    -0.308     0.200
    45.547     2.043     0.200
    46.115     0.596     0.200
    45.935     1.659     0.200
    47.081     1.820     0.200
    50.171    -1.058     0.200
    54.710     0.244     0.200
    57.937    -0.110     0.200
    64.459    -1.876     0.200
    68.195    -0.227     0.200
    69.194    -2.054     0.200
    77.140     1.976     0.200
    77.750    -0.128     0.200
    77.997     0.788     0.200
    79.639    -1.328     0.200
    80.569    -1.041     0.200
    81.390    -0.741     0.200
    81.407    -1.530     0.200
    84.459    -0.369     0.200
    85.972    -2.200     0.200
    89.376    -2.052     0.200
    92.886    -2.128     0.200
    96.547    -0.816     0.200
    21.427     1.400     0.200
    22.791     1.252     0.200
    22.789     1.671     0.200
    23.820     1.446     0.200
    26.451     3.208     0.200
    27.173    -1.065     0.200
    27.757    -1.204     0.200
    27.639     0.558     0.200
    28.153    -0.337     0.200
    28.676     0.000     0.200
    29.913     1.033     0.200
    31.049     0.492     0.200
    31.894     0.558     0.200
    32.327     1.255     0.200
    33.041     0.508     0.200
    33.854    -0.282     0.200
    34.460    -1.939     0.200
    34.896     0.593     0.200
    34.913     0.543     0.200
    36.931     0.860     0.200
    37.103     2.490     0.200
    39.019     0.887     0.200
    39.130     1.193     0.200
    40.492    -2.518     0.200
    40.396     1.183     0.200
    40.736     1.811     0.200
    42.618     0.657     0.200
    42.652     1.286     0.200
    44.478    -0.742     0.200
    45.461     0.841     0.200
    46.458     0.677     0.200
    46.671     0.309     0.200
    50.553     0.336     0.200
    52.443     2.592     0.200
    53.967     0.898     0.200
    54.612     0.881     0.200
    55.609    -0.220     0.200
    57.895     0.122     0.200
    61.273    -0.846     0.200
    64.372     1.012     0.200
    68.791    -1.080     0.200
    73.296    -1.637     0.200
    76.401     0.028     0.200
    77.573     0.593     0.200
    77.650     0.021     0.200
    79.573    -1.623     0.200
    85.237    -1.355     0.200
    87.750     0.172     0.200
    92.188    -0.476     0.200
    92.502    -2.230     0.200
    94.757    -1.502     0.200
    95.195    -0.609     0.200
    96.100    -0.733     0.200
    22.821     1.880     0.200
    22.830     1.182     0.200
    23.869     2.149     0.200
    26.504     0.485     0.200
    27.205    -1.003     0.200
    27.734    -1.143     0.200
    28.195    -0.860     0.200
    28.724    -0.069     0.200
    29.949     0.062     0.200
    31.081     0.066     0.200
    31.917    -0.290     0.200
    32.371     0.720     0.200
    33.076     0.850     0.200
    33.875    -1.409     0.200
    34.427     0.502     0.200
    34.930     0.355     0.200
    34.949    -0.206     0.200
    36.975     1.539     0.200
    37.155     2.407     0.200
    39.881     2.072     0.200
    40.449     1.064     0.200
    40.789     1.972     0.200
    41.255     1.192     0.200
    42.671     1.404     0.200
    44.441    -0.487     0.200
    45.207    -0.090     0.200
    46.717     0.805     0.200
    46.922    -0.197     0.200
    48.035    -0.955     0.200
    48.627    -1.320     0.200
    52.254    -0.981     0.200
    52.494     0.779     0.200
    52.531     0.001     0.200
    53.369    -2.481     0.200
    54.016     0.561     0.200
    61.318    -0.089     0.200
    61.846    -2.352     0.200
    64.307    -1.999     0.200
    64.424     0.536     0.200
    67.839     0.109     0.200
    68.836    -1.133     0.200
    77.623    -1.409     0.200
    77.650    -0.481     0.200
    81.045    -0.679     0.200
    85.239    -1.418     0.200
    34.480    -0.316     0.200
    36.912     1.917     0.200
    39.116     0.879     0.200
    39.521    -0.546     0.200
    40.382     0.848     0.200
    40.741     0.420     0.200
    42.605     0.999     0.200
    42.638     0.511     0.200
    44.498    -0.394     0.200
    80.464    -1.579     0.200
    84.078    -0.893     0.200
    85.563    -0.931     0.200
    89.699    -1.986     0.200
    94.741    -0.617     0.200
    24.842    -0.773     0.200
    26.702     1.840     0.200
    27.362    -0.277     0.200
    27.993    -1.914     0.200
    31.167    -1.452     0.200
    35.086     1.335     0.200
    36.466    -1.952     0.200
    39.331     0.730     0.200
    40.921     1.718     0.200
    41.217     1.085     0.200
    41.391     0.856     0.200
    41.485     0.984     0.200
    44.063    -1.127     0.200
    44.581    -0.023     0.200
    48.164    -0.520     0.200
    51.521     0.256     0.200
    51.972    -1.407     0.200
    55.609    -0.629     0.200
    61.571    -2.460     0.200
    68.786    -1.591     0.200
    77.275    -0.118     0.200
    80.098    -2.407     0.200
    84.874    -1.068     0.200
    85.541    -1.608     0.200
    85.788    -0.709     0.200
    88.123     1.155     0.200
    89.875    -2.453     0.200
    94.385    -0.280     0.200
    25.371     1.036     0.200
    31.373    -0.630     0.200
    34.735    -0.099     0.200
    38.140     1.037     0.200
    39.413     1.058     0.200
    39.498    -0.125     0.200
    40.038     0.750     0.200
    40.217     0.669     0.200
    41.625     0.969     0.200
    41.668     0.912     0.200
    44.861    -1.937     0.200
    50.843    -0.074     0.200
    53.817    -0.084     0.200
    60.653     0.442     0.200
    60.738    -0.324     0.200
    83.730    -1.073     0.200
    85.060    -1.096     0.200
    92.016    -1.557     0.200
    31.105    -2.011     0.200
    34.522    -0.924     0.200
    34.824     2.336     0.200
    44.544    -0.063     0.200
    51.428     1.277     0.200
    55.537     0.414     0.200
    61.129     0.250     0.200
    61.201     0.030     0.200
    61.272    -0.413     0.200
    84.032    -0.927     0.200
    85.512    -1.351     0.200
    94.733    -2.645     0.200
    17.214     4.036     0.200
    22.622     1.139     0.200
    24.763     0.550     0.200
    26.353     0.008     0.200
    26.353     0.372     0.200
    27.801    -1.346     0.200
    28.588     0.304     0.200
    29.250    -2.978     0.200
    29.442     0.807     0.200
    31.102    -2.647     0.200
    31.107    -1.910     0.200
    31.111    -1.630     0.200
    30.970     0.053     0.200
    30.990     0.041     0.200
    33.814     0.792     0.200
    34.523    -0.653     0.200
    34.523    -0.751     0.200
    34.799     0.464     0.200
    36.561    -0.080     0.200
    37.008     0.732     0.200
    37.492     0.634     0.200
    39.492    -0.287     0.200
    39.680    -1.438     0.200
    40.639     0.915     0.200
    40.694     0.565     0.200
    40.694    -0.095     0.200
    40.930     1.318     0.200
    41.106     0.371     0.200
    41.198     1.115     0.200
    44.101    -1.253     0.200
    44.548    -0.230     0.200
    44.548    -1.007     0.200
    46.522     0.351     0.200
    51.414     0.574     0.200
    52.198    -2.193     0.200
    53.347    -0.382     0.200
    53.347    -1.800     0.200
    53.793     2.288     0.200
    53.876     1.321     0.200
    54.217     1.303     0.200
    54.357     1.513     0.200
    54.479     0.694     0.200
    54.751     1.045     0.200
    54.891     1.509     0.200
    55.022     1.341     0.200
    55.523    -0.995     0.200
    55.525     0.185     0.200
    55.525     0.056     0.200
    57.430     0.226     0.200
    61.189    -0.457     0.200
    61.261    -0.643     0.200
    64.285    -1.585     0.200
    64.285    -2.182     0.200
    66.167    -0.286     0.200
    67.713    -0.318     0.200
    68.709    -1.958     0.200
    71.796    -2.652     0.200
    76.009     0.690     0.200
    76.043     1.897     0.200
    77.480     0.691     0.200
    79.623    -1.752     0.200
    80.480    -1.706     0.200
    80.914    -1.873     0.200
    81.447    -0.704     0.200
    84.028    -0.790     0.200
    85.231    -0.762     0.200
    85.231    -1.129     0.200
    85.256    -1.813     0.200
    85.503    -1.323     0.200
    87.663     0.871     0.200
    89.732    -2.421     0.200
    92.426    -1.829     0.200
    94.755    -0.752     0.200
    96.047    -0.003     0.200
    98.754     0.103     0.200
    24.463     0.813     0.200
    28.218    -1.166     0.200
    31.479    -1.644     0.200
    34.905    -0.370     0.200
    40.325     0.485     0.200
    44.909    -0.515     0.200
    51.133     0.198     0.200
    53.917    -2.809     0.200
    55.229    -0.498     0.200
    60.823    -0.892     0.200
    61.565    -1.174     0.200
    80.060    -2.180     0.200
    84.388    -1.408     0.200
    84.804    -1.755     0.200
    94.331    -1.679     0.200
    21.149     2.346     0.200
    22.330     2.790     0.200
    22.452    -0.512     0.200
    23.174     1.745     0.200
    23.447     2.267     0.200
    23.859    -0.215     0.200
    24.189     0.080     0.200
    24.291    -0.121     0.200
    25.187     0.492     0.200
    25.329    -0.304     0.200
    25.686     1.562     0.200
    27.638     0.658     0.200
    27.971    -0.911     0.200
    27.971    -1.153     0.200
    29.383     1.619     0.200
    30.692     0.262     0.200
    30.712     0.361     0.200
    31.443    -1.730     0.200
    31.448    -1.862     0.200
    31.452    -1.358     0.200
    31.772     2.226     0.200
    32.635     1.547     0.200
    33.691     1.926     0.200
    34.835    -1.283     0.200
    34.835    -1.135     0.200
    34.819     0.447     0.200
    34.819     0.572     0.200
    36.373     1.601     0.200
    36.395     1.291     0.200
    37.062    -1.990     0.200
    37.062     0.049     0.200
    39.298    -0.294     0.200
    40.290     0.632     0.200
    40.357    -0.016     0.200
    40.467     0.668     0.200
    40.530     1.070     0.200
    40.557     0.723     0.200
    40.735    -1.644     0.200
    41.074     0.363     0.200
    41.880     0.852     0.200
    43.178    -0.106     0.200
    43.749    -0.212     0.200
    44.688     1.562     0.200
    44.765    -0.053     0.200
    44.916    -0.551     0.200
    44.916    -0.231     0.200
    46.077     1.449     0.200
    46.725    -2.242     0.200
    50.910     0.814     0.200
    51.164    -0.793     0.200
    51.770     1.669     0.200
    52.096    -0.855     0.200
    53.229     2.621     0.200
    53.320     1.504     0.200
    53.793     1.844     0.200
    53.812     0.602     0.200
    53.921     1.333     0.200
    53.950     1.766     0.200
    54.194     0.691     0.200
    54.324     2.330     0.200
    54.459     1.473     0.200
    55.042    -0.017     0.200
    55.092    -1.537     0.200
    60.703    -0.536     0.200
    61.366    -2.347     0.200
    61.666    -1.550     0.200
    64.336    -1.700     0.200
    68.231    -1.067     0.200
    68.231    -1.481     0.200
    69.904     1.004     0.200
    70.361    -0.014     0.200
    75.834     0.559     0.200
    76.034     0.123     0.200
    76.723    -2.390     0.200
    76.756    -0.165     0.200
    76.899     0.516     0.200
    77.458     0.465     0.200
    77.853     1.000     0.200
    77.870     0.488     0.200
    78.609     1.388     0.200
    79.573     1.542     0.200
    79.797    -1.713     0.200
    80.415    -1.040     0.200
    81.028     1.085     0.200
    82.351     1.744     0.200
    83.108    -3.547     0.200
    83.136     1.527     0.200
    83.665    -0.839     0.200
    83.956    -0.461     0.200
    83.978    -0.359     0.200
    84.823    -1.097     0.200
    85.065    -0.982     0.200
    85.343    -0.985     0.200
    85.358    -1.805     0.200
    87.004     0.118     0.200
    87.004     0.782     0.200
    89.958    -2.350     0.200
    92.004    -1.825     0.200
    94.891    -0.648     0.200
    95.525    -0.381     0.200
    26.605     1.763     0.200
    26.605     1.661     0.200
    28.070    -0.991     0.200
    31.255    -2.243     0.200
    31.260    -1.863     0.200
    34.697    -0.621     0.200
    36.822     0.992     0.200
    40.549    -0.109     0.200
    40.733     0.238     0.200
    41.114     0.553     0.200
    41.288     0.624     0.200
    41.382     0.450     0.200
    41.894     0.155     0.200
    42.708     0.927     0.200
    42.735     1.005     0.200
    44.678    -0.079     0.200
    51.416     0.201     0.200
    51.900    -1.411     0.200
    61.099    -0.716     0.200
    61.171    -0.609     0.200
    80.064    -2.005     0.200
    83.146     0.439     0.200
    84.697    -0.568     0.200
    85.439    -1.638     0.200
    85.684     0.276     0.200
    89.959    -1.091     0.200
    94.346    -1.003     0.200
    96.063    -1.579     0.200
    17.030     3.326     0.200
    17.203     3.018     0.200
    22.732     0.765     0.200
    22.727     1.221     0.200
    23.708    -0.374     0.200
    23.749     1.949     0.200
    24.102     1.120     0.200
    24.777     1.548     0.200
    25.812     3.069     0.200
    26.383     1.415     0.200
    27.804    -0.380     0.200
    28.086     1.216     0.200
    28.606     0.187     0.200
    31.096    -1.103     0.200
    30.993     0.158     0.200
    31.101    -1.216     0.200
    31.105    -1.435     0.200
    31.847     0.438     0.200
    32.259     2.619     0.200
    32.980     1.106     0.200
    34.519    -0.376     0.200
    34.825    -0.125     0.200
    34.874     0.154     0.200
    34.874    -0.075     0.200
    36.862     0.217     0.200
    37.032     1.563     0.200
    39.490    -0.512     0.200
    39.672    -0.633     0.200
    40.880     0.262     0.200
    40.956     0.431     0.200
    44.108    -1.683     0.200
    44.540     0.356     0.200
    45.111    -0.187     0.200
    46.601     1.252     0.200
    51.431     0.771     0.200
    51.431     0.345     0.200
    52.192    -2.334     0.200
    52.192    -2.084     0.200
    53.813     1.703     0.200
    53.896     1.311     0.200
    54.237     1.640     0.200
    54.377     1.668     0.200
    54.499     0.902     0.200
    54.770     0.994     0.200
    54.911     2.542     0.200
    55.042     1.198     0.200
    55.534    -2.068     0.200
    55.540    -1.011     0.200
    55.540    -0.341     0.200
    57.450    -0.008     0.200
    57.886     0.046     0.200
    60.682    -0.905     0.200
    61.132     0.096     0.200
    61.204    -0.254     0.200
    61.275    -1.437     0.200
    61.275    -0.867     0.200
    66.185    -0.503     0.200
    68.723    -1.155     0.200
    76.302     0.813     0.200
    76.530     0.529     0.200
    77.501     0.558     0.200
    77.501     0.857     0.200
    78.148     0.226     0.200
    78.549     0.655     0.200
    78.574     0.544     0.200
    79.293     1.143     0.200
    79.604    -1.132     0.200
    79.590    -0.956     0.200
    79.934    -0.922     0.200
    80.046    -3.227     0.200
    80.276     1.677     0.200
    80.462    -1.419     0.200
    80.930    -0.974     0.200
    80.930    -1.163     0.200
    81.068     0.759     0.200
    83.477    -2.313     0.200
    83.772    -0.416     0.200
    84.035    -0.847     0.200
    84.603    -0.249     0.200
    84.927     1.061     0.200
    85.108     1.191     0.200
    85.215    -1.517     0.200
    85.515    -1.075     0.200
    85.554     0.290     0.200
    85.905    -1.335     0.200
    87.696     1.189     0.200
    87.696     0.681     0.200
    92.437    -2.654     0.200
    92.437    -1.929     0.200
    93.383    -0.979     0.200
    94.737    -0.694     0.200
    96.064    -1.032     0.200
    17.010     1.746     0.200
    22.727     0.916     0.200
    24.065     0.683     0.200
    24.772     0.767     0.200
    25.795     3.847     0.200
    26.356     1.622     0.200
    27.618     0.777     0.200
    27.789     0.627     0.200
    31.091    -2.396     0.200
    31.097    -1.575     0.200
    31.001    -0.589     0.200
    32.254     1.690     0.200
    32.984     0.396     0.200
    34.512    -0.844     0.200
    34.803     0.789     0.200
    34.894     0.710     0.200
    34.894    -0.109     0.200
    36.552    -1.486     0.200
    36.857     0.991     0.200
    37.014     0.317     0.200
    39.503     0.109     0.200
    39.692    -0.974     0.200
    40.884    -0.220     0.200
    44.111    -2.079     0.200
    44.538    -0.366     0.200
    44.538    -0.831     0.200
    45.115    -0.987     0.200
    46.593     1.350     0.200
    51.423    -0.209     0.200
    51.423     0.641     0.200
    52.210    -0.829     0.200
    53.182     1.443     0.200
    53.800     1.338     0.200
    53.883     1.198     0.200
    54.224     1.552     0.200
    54.364     1.512     0.200
    54.486     0.703     0.200
    54.758     0.823     0.200
    54.898     1.708     0.200
    55.029     1.461     0.200
    55.532    -1.714     0.200
    55.534    -0.938     0.200
    57.918     0.061     0.200
    61.126    -0.093     0.200
    61.198    -0.568     0.200
    61.270    -1.155     0.200
    61.798    -2.124     0.200
    68.718    -0.671     0.200
    68.718    -1.453     0.200
    76.276    -0.087     0.200
    77.487     0.491     0.200
    77.487     0.902     0.200
    79.591    -1.110     0.200
    79.634    -1.733     0.200
    80.075    -1.034     0.200
    80.492    -1.976     0.200
    80.923    -1.483     0.200
    80.923    -1.252     0.200
    81.050     0.837     0.200
    84.038    -1.406     0.200
    84.586    -0.212     0.200
    85.243    -1.629     0.200
    85.513    -1.458     0.200
    85.535     0.364     0.200
    85.895    -1.106     0.200
    87.661     1.306     0.200
    92.436    -1.516     0.200
    94.766    -0.319     0.200
    16.777     1.877     0.200
    16.777     2.299     0.200
    16.953     4.953     0.200
    17.495     2.230     0.200
    21.518     2.816     0.200
    22.740     1.283     0.200
    23.591     0.697     0.200
    23.805    -0.003     0.200
    24.232     0.740     0.200
    24.232     0.741     0.200
    24.711    -0.751     0.200
    25.593     1.456     0.200
    26.042     1.034     0.200
    27.214    -1.685     0.200
    27.616     0.824     0.200
    28.055    -0.009     0.200
    28.478     0.719     0.200
    29.600    -1.466     0.200
    30.949    -2.990     0.200
    31.040    -2.172     0.200
    31.045    -1.886     0.200
    31.078     0.591     0.200
    31.098     0.519     0.200
    32.192     1.893     0.200
    33.036     4.500     0.200
    34.438    -0.653     0.200
    35.130     0.326     0.200
    35.130    -0.796     0.200
    36.793     1.078     0.200
    36.798     2.538     0.200
    36.798     2.140     0.200
    37.834     0.349     0.200
    39.658     0.440     0.200
    40.049     1.393     0.200
    40.391     0.360     0.200
    40.677     0.694     0.200
    40.757     0.027     0.200
    40.854     0.831     0.200
    40.932     0.290     0.200
    40.944     0.791     0.200
    41.461     0.537     0.200
    42.265     0.964     0.200
    42.876     1.872     0.200
    44.153    -0.400     0.200
    44.508     1.007     0.200
    44.508    -2.231     0.200
    45.012     1.841     0.200
    46.006     0.772     0.200
    46.498     3.602     0.200
    47.640     0.285     0.200
    48.693    -1.655     0.200
    51.331     0.413     0.200
    52.423    -1.529     0.200
    54.229    -0.056     0.200
    54.376     0.921     0.200
    54.376     0.702     0.200
    55.462     0.258     0.200
    55.509    -1.177     0.200
    61.051    -0.188     0.200
    61.201    -1.242     0.200
    62.001    -2.338     0.200
    64.596    -3.536     0.200
    67.661     0.280     0.200
    68.651    -1.232     0.200
    75.960    -0.089     0.200
    77.312     0.372     0.200
    78.007    -0.008     0.200
    79.992    -2.096     0.200
    84.072    -1.320     0.200
    84.384    -0.157     0.200
    85.240     0.078     0.200
    85.482    -1.130     0.200
    85.573    -0.978     0.200
    85.778    -1.626     0.200
    87.239     1.229     0.200
    87.239     1.580     0.200
    92.432    -2.212     0.200
    92.420    -1.556     0.200
    92.420    -1.005     0.200
    95.108    -0.615     0.200
    95.946     0.375     0.200
    24.751     0.488     0.200
    31.243    -1.856     0.200
    40.750    -0.342     0.200
    44.660    -2.293     0.200
    51.429     0.134     0.200
    54.191    -1.622     0.200
    61.185    -1.112     0.200
    80.085    -1.354     0.200
    94.368    -0.877     0.200
    27.568    -2.073     0.200
    27.756     3.030     0.200
    30.785    -0.272     0.200
    30.788    -0.937     0.200
    31.269     0.658     0.200
    34.214    -1.425     0.200
    36.168     1.167     0.200
    41.203    -0.781     0.200
    44.211    -1.042     0.200
    52.403     0.709     0.200
    62.247    -0.609     0.200
    24.015     0.086     0.200
    27.147    -0.220     0.200
    28.222    -0.128     0.200
    31.411    -0.475     0.200
    31.417    -2.673     0.200
    31.421    -0.166     0.200
    34.854    -1.683     0.200
    40.577    -1.736     0.200
    44.834    -0.473     0.200
    50.122    -0.639     0.200
    51.270     0.464     0.200
    90.114    -1.941     0.200
    15.199     5.666     0.200
    26.052     0.874     0.200
    27.561     0.046     0.200
    40.981    -0.090     0.200
    51.369     0.255     0.200
    54.271    -1.813     0.200
    55.503    -0.285     0.200
    84.120    -1.453     0.200
    15.101     3.602     0.200
    15.451     4.553     0.200
    15.451     5.334     0.200
    15.451     4.883     0.200
    16.176     6.893     0.200
    16.315     4.831     0.200
    17.323     1.974     0.200
    17.827     2.947     0.200
    20.096     0.700     0.200
    21.428     1.697     0.200
    21.498     2.552     0.200
    21.546     2.130     0.200
    21.819     1.611     0.200
    22.103     3.284     0.200
    22.512     3.129     0.200
    22.769     1.806     0.200
    23.576     0.650     0.200
    23.673     2.464     0.200
    23.779     1.089     0.200
    23.854     3.005     0.200
    23.971    -1.111     0.200
    23.971    -1.111     0.200
    24.017     1.915     0.200
    24.193     1.110     0.200
    25.600     3.114     0.200
    25.710     2.717     0.200
    25.871     2.058     0.200
    26.076     0.300     0.200
    26.202     3.869     0.200
    26.229     1.021     0.200
    26.326     1.244     0.200
    26.326     1.574     0.200
    27.701    -0.117     0.200
    28.064    -0.059     0.200
    28.543     1.582     0.200
    29.387    -1.513     0.200
    29.387    -2.313     0.200
    29.519    -1.760     0.200
    31.078    -1.361     0.200
    31.078    -1.481     0.200
    31.083    -1.749     0.200
    31.083    -1.508     0.200
    31.087    -1.593     0.200
    31.011     0.464     0.200
    31.109    -1.383     0.200
    31.030     0.360     0.200
    31.925     0.590     0.200
    32.222     2.580     0.200
    32.996     1.602     0.200
    34.490    -0.939     0.200
    34.698     0.518     0.200
    34.978     0.601     0.200
    34.978    -0.419     0.200
    36.593    -0.394     0.200
    36.824     1.087     0.200
    36.923     3.464     0.200
    38.822     1.416     0.200
    38.931     1.404     0.200
    39.564    -3.279     0.200
    39.556     0.309     0.200
    39.629     0.982     0.200
    40.154    -1.383     0.200
    40.154    -0.483     0.200
    40.199     1.147     0.200
    40.474    -0.592     0.200
    40.540     1.527     0.200
    40.717     0.373     0.200
    40.829     0.943     0.200
    40.894     0.203     0.200
    41.096     0.740     0.200
    42.419     0.124     0.200
    42.455     0.531     0.200
    43.037    -0.884     0.200
    43.031     0.462     0.200
    44.120    -2.306     0.200
    44.533    -0.339     0.200
    44.533    -0.064     0.200
    45.225     1.182     0.200
    45.976     0.741     0.200
    46.549     1.241     0.200
    46.939    -0.811     0.200
    50.797    -0.853     0.200
    51.142    -0.726     0.200
    51.380     0.308     0.200
    51.380    -0.182     0.200
    51.380     0.419     0.200
    52.286    -0.251     0.200
    52.286    -2.032     0.200
    53.733     2.278     0.200
    53.819     0.906     0.200
    53.819     1.197     0.200
    54.159     1.490     0.200
    54.234    -0.878     0.200
    54.234    -1.158     0.200
    54.297     1.782     0.200
    54.694     0.788     0.200
    54.830     1.335     0.200
    54.963     0.945     0.200
    54.963     1.415     0.200
    55.499     0.789     0.200
    55.499     0.413     0.200
    55.499    -0.030     0.200
    55.499    -0.211     0.200
    55.516    -0.930     0.200
    57.369    -0.227     0.200
    60.639    -1.494     0.200
    61.090    -0.359     0.200
    61.162    -0.246     0.200
    61.162     0.284     0.200
    61.870    -2.135     0.200
    61.870    -2.925     0.200
    64.407    -1.910     0.200
    64.407    -1.051     0.200
    67.691    -0.047     0.200
    68.450     1.181     0.200
    68.685    -1.244     0.200
    69.324     1.083     0.200
    70.259    -0.419     0.200
    73.974    -0.953     0.200
    74.121    -0.616     0.200
    74.229    -1.142     0.200
    75.964     1.422     0.200
    75.964    -0.108     0.200
    77.412     0.953     0.200
    77.412     0.313     0.200
    77.786    -0.262     0.200
    77.998    -1.650     0.200
    78.859    -0.614     0.200
    79.088    -2.059     0.200
    79.473    -1.961     0.200
    79.542    -1.735     0.200
    79.767    -1.279     0.200
    80.206    -1.332     0.200
    80.882     0.447     0.200
    81.455    -1.099     0.200
    82.825    -1.075     0.200
    83.065    -0.672     0.200
    83.934    -0.233     0.200
    84.044    -0.718     0.200
    84.501    -1.116     0.200
    85.249    -1.121     0.200
    85.365    -1.902     0.200
    85.401     0.137     0.200
    85.438     0.395     0.200
    85.843    -2.004     0.200
    85.843    -1.279     0.200
    85.843    -1.049     0.200
    85.854    -1.024     0.200
    88.428     2.411     0.200
    89.045     1.804     0.200
    89.055     0.255     0.200
    92.267    -0.980     0.200
    92.422    -2.005     0.200
    92.422    -2.280     0.200
    93.827    -0.228     0.200
    94.893     0.226     0.200
    95.478     1.259     0.200
    95.973    -1.497     0.200
    96.006    -0.157     0.200
    26.222     3.727     0.200
    27.700     0.018     0.200
    31.087    -2.334     0.200
    34.494    -0.672     0.200
    40.890    -0.381     0.200
    44.537     0.095     0.200
    51.375     0.155     0.200
    51.375     0.219     0.200
    54.229    -1.315     0.200
    55.494    -0.360     0.200
    61.156    -0.611     0.200
    85.838    -1.492     0.200
    24.036     0.045     0.200
    26.447     0.894     0.200
    27.575    -0.807     0.200
    27.830     1.083     0.200
    27.830     1.087     0.200
    30.889    -1.836     0.200
    32.440     1.411     0.200
    34.302    -0.914     0.200
    35.009    -0.422     0.200
    37.043     1.577     0.200
    39.049     1.467     0.200
    39.158     0.861     0.200
    39.855     1.252     0.200
    40.426     1.321     0.200
    40.767     1.406     0.200
    40.912     0.632     0.200
    41.090     0.344     0.200
    41.839     0.406     0.200
    42.645     0.638     0.200
    42.920    -1.290     0.200
    44.333    -0.449     0.200
    44.333    -1.593     0.200
    50.855     0.062     0.200
    51.603     0.324     0.200
    51.603     1.039     0.200
    54.446    -0.889     0.200
    54.446    -0.639     0.200
    55.719     0.273     0.200
    55.721     0.260     0.200
    56.418     0.089     0.200
    57.597    -0.811     0.200
    61.310     0.176     0.200
    61.382    -0.801     0.200
    66.346    -0.402     0.200
    67.821    -0.246     0.200
    68.904    -1.089     0.200
    78.030    -0.856     0.200
    80.679    -1.946     0.200
    84.243    -1.189     0.200
    84.730    -1.475     0.200
    84.730    -0.346     0.200
    85.437    -0.837     0.200
    85.437    -1.237     0.200
    85.707    -1.159     0.200
    86.068    -1.372     0.200
    94.957    -1.017     0.200
    96.230    -0.242     0.200
    26.641     1.512     0.200
    27.514     1.034     0.200
    27.514     1.030     0.200
    31.061     0.416     0.200
    31.066    -1.832     0.200
    34.497    -0.511     0.200
    34.498    -1.019     0.200
    34.674    -0.392     0.200
    37.313     0.543     0.200
    40.923    -0.900     0.200
    44.490    -0.665     0.200
    51.563     0.532     0.200
    51.563     0.059     0.200
    54.343    -1.100     0.200
    55.211     1.279     0.200
    55.659    -0.608     0.200
    57.621     0.138     0.200
    66.336    -0.641     0.200
    77.537    -0.326     0.200
    79.416    -1.508     0.200
    80.279    -2.574     0.200
    81.581    -2.506     0.200
    84.799    -0.273     0.200
    85.051    -1.265     0.200
    85.608    -0.621     0.200
    86.051    -1.747     0.200
    94.564    -1.813     0.200
    26.585     1.885     0.200
    27.136    -0.355     0.200
    27.136    -0.359     0.200
    28.224    -0.431     0.200
    31.392    -0.038     0.200
    31.398    -1.689     0.200
    34.293     0.197     0.200
    34.838    -0.363     0.200
    34.937     1.636     0.200
    40.599     0.928     0.200
    44.810    -2.499     0.200
    50.085    -1.836     0.200
    51.314    -0.336     0.200
    51.754    -0.967     0.200
    54.054    -0.221     0.200
    57.417     1.299     0.200
    79.908    -2.363     0.200
    84.628     1.492     0.200
    90.108    -1.062     0.200
    31.073    -2.803     0.200
    34.480    -1.312     0.200
    44.523    -1.095     0.200
    51.387     0.104     0.200
    55.507    -0.398     0.200
    55.508    -0.414     0.200
    61.097    -0.764     0.200
    84.054    -1.806     0.200
    30.599    -1.862     0.200
    34.026    -2.216     0.200
    44.030    -1.129     0.200
    51.964    -0.008     0.200
    89.269    -1.998     0.200
    25.944     1.574     0.200
    27.348    -0.558     0.200
    28.154     0.460     0.200
    30.853    -1.692     0.200
    34.231    -0.456     0.200
    41.127     0.667     0.200
    44.329    -0.404     0.200
    51.426    -0.125     0.200
    52.021     1.014     0.200
    54.372    -0.697     0.200
    65.322     0.644     0.200
    81.194    -2.796     0.200
    84.256    -1.336     0.200
    84.387    -0.782     0.200
    85.621    -1.599     0.200
    85.853    -1.996     0.200
    89.338    -2.699     0.200
    92.570    -2.711     0.200
    14.303     6.286     0.200
    14.343     7.452     0.200
    14.750     6.253     0.200
    15.160     6.105     0.200
    15.451     8.752     0.200
    15.541     5.284     0.200
    16.813     3.636     0.200
    19.328     0.548     0.200
    20.944     5.495     0.200
    21.105     1.564     0.200
    21.397     3.622     0.200
    21.624     2.781     0.200
    22.019    -2.043     0.200
    22.062     2.803     0.200
    22.289     3.380     0.200
    22.472     1.843     0.200
    23.293     0.446     0.200
    23.493     0.618     0.200
    23.585     0.589     0.200
    23.585     1.440     0.200
    24.013     0.633     0.200
    24.108     0.661     0.200
    24.293     2.475     0.200
    24.413     1.882     0.200
    24.494     3.043     0.200
    24.655     1.572     0.200
    24.778     1.559     0.200
    24.869     2.326     0.200
    24.930     0.718     0.200
    25.062     3.170     0.200
    25.363     2.039     0.200
    25.422     1.406     0.200
    25.464     2.721     0.200
    25.528     2.840     0.200
    25.664     2.707     0.200
    25.717     1.332     0.200
    25.766     0.698     0.200
    25.942     1.054     0.200
    25.967     0.817     0.200
    25.967     1.395     0.200
    26.069     1.438     0.200
    26.073     0.401     0.200
    26.073     1.401     0.200
    26.671     0.605     0.200
    27.218    -1.065     0.200
    27.218    -1.214     0.200
    28.289     0.169     0.200
    28.289     0.169     0.200
    28.303     0.293     0.200
    28.640     0.792     0.200
    30.738    -1.809     0.200
    31.449     1.046     0.200
    32.409     1.819     0.200
    33.352     3.072     0.200
    34.112    -0.529     0.200
    34.113    -1.431     0.200
    34.124    -1.355     0.200
    34.446    -0.427     0.200
    34.547     0.475     0.200
    35.506     0.004     0.200
    36.849     1.102     0.200
    37.007     1.112     0.200
    39.985    -0.899     0.200
    40.395     1.293     0.200
    40.675     1.080     0.200
    40.688     0.177     0.200
    40.855     0.898     0.200
    40.942     1.183     0.200
    41.243     0.977     0.200
    41.252     0.573     0.200
    42.260     1.189     0.200
    42.307     0.806     0.200
    42.874     1.400     0.200
    43.372    -1.125     0.200
    44.218    -0.567     0.200
    44.874     0.240     0.200
    46.679     0.791     0.200
    51.497     0.143     0.200
    51.516     0.082     0.200
    51.516     0.558     0.200
    51.516     0.144     0.200
    51.704    -0.109     0.200
    52.278     3.090     0.200
    52.481     0.467     0.200
    54.475    -0.881     0.200
    54.475    -0.776     0.200
    54.475    -1.061     0.200
    57.365     0.377     0.200
    57.395     0.134     0.200
    57.395     0.196     0.200
    61.324    -0.440     0.200
    62.420    -1.153     0.200
    62.420    -2.032     0.200
    66.201    -0.922     0.200
    68.476    -0.531     0.200
    81.326    -1.907     0.200
    84.369    -0.966     0.200
    84.447    -0.132     0.200
    85.723    -1.048     0.200
    85.935    -1.125     0.200
    85.946    -1.539     0.200
    86.049    -1.506     0.200
    89.212    -1.894     0.200
    89.212    -2.468     0.200
    92.674    -1.808     0.200
    92.674    -2.132     0.200
    95.587    -1.763     0.200
    96.110    -0.067     0.200
    26.169     1.111     0.200
    28.075     0.199     0.200
    34.206    -0.559     0.200
    35.276    -0.834     0.200
    41.163    -1.918     0.200
    44.278     0.566     0.200
    51.542     1.051     0.200
    54.450    -0.445     0.200
    85.705    -1.495     0.200
    31.275    -0.323     0.200
    34.710    -1.073     0.200
    51.392    -0.625     0.200
    34.356     0.127     0.200
    44.328     0.852     0.200
    51.769     0.083     0.200
    51.769     0.115     0.200
    51.769     0.115     0.200
    54.528    -1.244     0.200
    54.531    -1.263     0.200
    55.860    -0.248     0.200
    56.720    -0.166     0.200
    57.844     0.319     0.200
    85.794    -2.069     0.200
    85.794    -2.077     0.200
    14.423     3.620     0.200
    15.286     6.016     0.200
    15.427     3.286     0.200
    15.536     5.949     0.200
    15.767     3.938     0.200
    15.871     5.803     0.200
    16.019     7.687     0.200
    16.306     2.304     0.200
    16.457     5.384     0.200
    16.457     2.694     0.200
    16.626     7.238     0.200
    16.867     3.706     0.200
    17.303     1.721     0.200
    19.187    -0.374     0.200
    19.535    -0.309     0.200
    19.986     0.185     0.200
    20.682     0.046     0.200
    20.608     1.277     0.200
    20.714     0.820     0.200
    20.714    -0.575     0.200
    21.248     1.060     0.200
    21.248     0.771     0.200
    21.581     4.881     0.200
    21.616    -1.607     0.200
    21.629     1.873     0.200
    21.629     0.903     0.200
    21.947     5.257     0.200
    22.041     1.391     0.200
    22.079     3.555     0.200
    22.240     1.669     0.200
    22.218     2.566     0.200
    22.303     5.466     0.200
    22.430     2.819     0.200
    22.552     0.913     0.200
    22.800     2.994     0.200
    22.910     1.625     0.200
    23.042     3.233     0.200
    23.042     1.363     0.200
    23.324     0.442     0.200
    23.263     1.401     0.200
    23.318     2.328     0.200
    23.452     3.117     0.200
    23.399    -0.327     0.200
    23.454     1.501     0.200
    23.454    -0.619     0.200
    23.568     5.709     0.200
    23.628     0.853     0.200
    23.628     0.433     0.200
    23.709     1.618     0.200
    23.914     4.140     0.200
    23.946    -0.329     0.200
    23.946    -0.684     0.200
    23.946     0.096     0.200
    24.092     2.016     0.200
    24.102     3.423     0.200
    24.198    -0.949     0.200
    24.110     0.954     0.200
    24.199     3.436     0.200
    24.144     0.739     0.200
    24.387     0.161     0.200
    24.575     3.409     0.200
    24.627     0.934     0.200
    24.783     1.913     0.200
    24.822     4.058     0.200
    24.953     4.470     0.200
    25.137     1.596     0.200
    25.174     0.460     0.200
    25.341    -0.428     0.200
    25.269     1.395     0.200
    25.269     0.595     0.200
    25.300     2.715     0.200
    25.449     3.060     0.200
    25.472     1.347     0.200
    25.747     1.308     0.200
    25.747     0.098     0.200
    25.747     0.498     0.200
    25.747     0.258     0.200
    25.815     2.041     0.200
    25.845     2.239     0.200
    25.845    -0.130     0.200
    26.087    -0.327     0.200
    25.957     0.081     0.200
    26.522     1.749     0.200
    26.835    -0.374     0.200
    26.927     0.292     0.200
    27.292    -1.846     0.200
    27.276    -0.542     0.200
    27.286    -0.794     0.200
    27.248     3.712     0.200
    27.248    -0.358     0.200
    27.477     1.858     0.200
    27.631    -1.728     0.200
    27.631     0.322     0.200
    27.689    -0.649     0.200
    27.872    -0.731     0.200
    27.872     0.229     0.200
    27.736    -0.363     0.200
    27.736     0.037     0.200
    27.980     4.860     0.200
    28.150     0.440     0.200
    28.523     4.020     0.200
    28.955     0.578     0.200
    29.461    -1.714     0.200
    29.461    -2.214     0.200
    29.461    -2.053     0.200
    29.461    -2.264     0.200
    29.463    -1.768     0.200
    29.593     0.916     0.200
    29.960    -2.157     0.200
    29.960    -1.327     0.200
    30.374    -0.722     0.200
    30.642    -0.708     0.200
    30.787     1.946     0.200
    30.793    -0.189     0.200
    30.813    -0.264     0.200
    31.252    -1.665     0.200
    31.342    -1.635     0.200
    31.342    -1.865     0.200
    31.348    -2.056     0.200
    31.348    -2.791     0.200
    31.373    -2.076     0.200
    31.440    -1.131     0.200
    31.520    -1.017     0.200
    31.535    -1.948     0.200
    31.537    -1.438     0.200
    31.544    -1.549     0.200
    31.554    -1.676     0.200
    31.704     0.649     0.200
    31.724     2.698     0.200
    31.795     0.080     0.200
    31.868     1.639     0.200
    32.257     1.329     0.200
    32.736     1.929     0.200
    32.736     2.329     0.200
    32.912     4.015     0.200
    33.002     4.398     0.200
    33.137     0.524     0.200
    33.746    -0.011     0.200
    33.788     1.351     0.200
    33.787    -0.448     0.200
    34.033    -0.374     0.200
    34.232     0.072     0.200
    34.232    -0.508     0.200
    34.232     1.712     0.200
    34.734    -1.503     0.200
    34.734    -0.843     0.200
    34.852     0.378     0.200
    34.912    -0.188     0.200
    36.124     0.099     0.200
    36.469     1.050     0.200
    36.475     1.896     0.200
    36.475     2.683     0.200
    36.637    -0.085     0.200
    36.968    -0.850     0.200
    36.968    -0.300     0.200
    37.596     0.784     0.200
    38.242     0.686     0.200
    38.358     1.038     0.200
    38.358     1.538     0.200
    38.465     1.241     0.200
    38.910     2.807     0.200
    39.162     1.598     0.200
    39.509    -1.772     0.200
    39.397    -0.962     0.200
    39.397     0.038     0.200
    39.722    -0.774     0.200
    39.734     1.724     0.200
    40.199     0.967     0.200
    40.199    -0.703     0.200
    40.573    -1.063     0.200
    40.573    -0.913     0.200
    40.363     1.007     0.200
    40.375     0.704     0.200
    40.457     0.844     0.200
    40.457     0.624     0.200
    40.636    -0.913     0.200
    40.540     0.942     0.200
    40.630     0.277     0.200
    40.630    -0.703     0.200
    40.630     0.996     0.200
    40.726     1.907     0.200
    41.147     0.637     0.200
    41.998     1.161     0.200
    42.128     0.577     0.200
    42.141     0.571     0.200
    42.144     0.568     0.200
    41.990     1.127     0.200
    42.179    -1.549     0.200
    42.452    -0.592     0.200
    42.460    -0.593     0.200
    42.470    -1.163     0.200
    42.855     0.793     0.200
    42.911     0.507     0.200
    42.911     1.301     0.200
    43.086    -2.683     0.200
    43.086    -0.163     0.200
    43.616     4.339     0.200
    43.787    -1.133     0.200
    43.999    -1.877     0.200
    43.850     0.360     0.200
    44.816    -0.997     0.200
    44.622     0.298     0.200
    44.738     0.845     0.200
    44.866     0.700     0.200
    44.866     0.131     0.200
    44.866    -0.049     0.200
    45.166     4.044     0.200
    45.175     3.573     0.200
    45.701     0.406     0.200
    46.171     0.900     0.200
    46.171     1.500     0.200
    46.403     0.930     0.200
    46.468     4.516     0.200
    47.324     0.727     0.200
    48.277     0.394     0.200
    48.470    -0.507     0.200
    48.422    -0.640     0.200
    49.325    -3.509     0.200
    49.214     4.773     0.200
    49.290     0.627     0.200
    49.913    -0.726     0.200
    50.356     2.757     0.200
    50.380    -0.948     0.200
    50.796     0.375     0.200
    50.889     0.071     0.200
    50.889    -0.104     0.200
    50.889     1.141     0.200
    50.671     2.674     0.200
    51.004     0.204     0.200
    51.004     0.629     0.200
    51.004    -0.166     0.200
    51.007     1.183     0.200
    51.328     0.272     0.200
    51.239    -0.208     0.200
    51.194     0.179     0.200
    51.227     0.450     0.200
    51.619    -1.646     0.200
    51.590     0.269     0.200
    51.593     0.563     0.200
    51.621     0.238     0.200
    51.855     1.933     0.200
    52.338     0.821     0.200
    52.131     0.278     0.200
    52.191    -1.068     0.200
    52.191    -0.398     0.200
    52.465     0.202     0.200
    52.465     0.102     0.200
    52.536    -0.405     0.200
    52.550     0.557     0.200
    52.648     3.380     0.200
    52.866    -0.430     0.200
    53.119    -0.017     0.200
    52.934     0.688     0.200
    53.309     0.224     0.200
    53.317     1.635     0.200
    53.408     1.835     0.200
    53.408     1.295     0.200
    53.485    -0.009     0.200
    53.485     0.972     0.200
    53.502     1.607     0.200
    53.745     1.635     0.200
    53.881     1.563     0.200
    53.908    -0.706     0.200
    53.908    -0.326     0.200
    53.908    -1.326     0.200
    54.010     0.168     0.200
    54.048     1.468     0.200
    54.048     1.124     0.200
    54.048     1.655     0.200
    54.048     0.694     0.200
    54.093    -0.615     0.200
    54.267    -0.526     0.200
    54.412     1.149     0.200
    54.547     0.834     0.200
    55.138    -0.358     0.200
    55.138    -0.038     0.200
    55.232     4.972     0.200
    55.240     3.653     0.200
    55.254     2.583     0.200
    55.734     0.348     0.200
    56.315     0.065     0.200
    56.721     0.505     0.200
    56.709     0.284     0.200
    56.952     0.164     0.200
    56.952    -0.136     0.200
    56.984    -0.163     0.200
    57.754    -2.497     0.200
    57.635     0.442     0.200
    57.885    -2.739     0.200
    58.149    -0.448     0.200
    58.641    -2.303     0.200
    59.995    -0.161     0.200
    60.798    -0.182     0.200
    60.798    -1.453     0.200
    60.798    -0.463     0.200
    61.236    -0.108     0.200
    61.762    -1.920     0.200
    62.906     3.935     0.200
    63.218    -2.370     0.200
    63.502    -2.087     0.200
    63.834    -0.753     0.200
    64.092     0.172     0.200
    64.163     0.726     0.200
    64.260    -0.010     0.200
    64.422    -2.139     0.200
    64.422    -1.229     0.200
    64.759    -3.183     0.200
    64.838    -0.144     0.200
    64.841     0.194     0.200
    64.948     0.494     0.200
    65.008     0.514     0.200
    65.008     0.339     0.200
    65.567     0.484     0.200
    65.723    -0.290     0.200
    65.723    -1.520     0.200
    65.769     0.842     0.200
    65.769     1.182     0.200
    65.850    -0.166     0.200
    65.850    -0.271     0.200
    65.891     1.232     0.200
    65.912     0.032     0.200
    65.916     0.235     0.200
    65.916     0.345     0.200
    65.983    -0.273     0.200
    65.983     0.842     0.200
    66.267    -0.569     0.200
    66.342    -0.858     0.200
    66.342     0.575     0.200
    66.341     1.232     0.200
    66.341     1.652     0.200
    66.406    -0.162     0.200
    66.406     5.085     0.200
    66.580     0.973     0.200
    66.580     1.983     0.200
    66.647     0.000     0.200
    66.647     0.699     0.200
    66.959    -0.813     0.200
    66.959     0.689     0.200
    67.373    -0.388     0.200
    67.520    -1.165     0.200
    67.337    -0.712     0.200
    67.806    -1.092     0.200
    67.922    -1.841     0.200
    68.072    -1.155     0.200
    67.964     1.264     0.200
    68.193    -0.096     0.200
    68.241     1.496     0.200
    68.266    -0.052     0.200
    68.321    -0.843     0.200
    68.321    -0.277     0.200
    68.437    -0.155     0.200
    68.326    -1.541     0.200
    68.326    -0.941     0.200
    68.599     1.078     0.200
    68.621    -0.385     0.200
    68.697     2.548     0.200
    68.749     2.555     0.200
    68.844     1.443     0.200
    68.861     0.184     0.200
    68.861    -0.411     0.200
    68.945     0.481     0.200
    68.962    -1.116     0.200
    69.018    -1.406     0.200
    69.023     0.140     0.200
    68.838     1.754     0.200
    69.127     3.516     0.200
    69.167     1.015     0.200
    69.224     0.685     0.200
    69.229     4.434     0.200
    69.414     0.213     0.200
    69.424     2.110     0.200
    69.505    -0.959     0.200
    69.623     0.232     0.200
    69.675    -0.723     0.200
    70.443     0.545     0.200
    73.471     3.403     0.200
    73.657    -1.588     0.200
    74.728    -0.537     0.200
    75.298     0.478     0.200
    75.521     0.069     0.200
    75.521     0.813     0.200
    75.521    -1.007     0.200
    75.521     0.693     0.200
    75.666    -0.369     0.200
    75.666    -0.539     0.200
    75.836    -2.007     0.200
    75.910     0.569     0.200
    76.118    -2.318     0.200
    76.178     0.640     0.200
    76.334    -0.540     0.200
    76.446     1.320     0.200
    76.629    -1.857     0.200
    76.485    -0.099     0.200
    76.711     3.325     0.200
    76.780     3.632     0.200
    76.837    -0.137     0.200
    77.002    -2.186     0.200
    76.939     0.438     0.200
    76.985    -0.519     0.200
    76.985     0.399     0.200
    76.985    -0.721     0.200
    76.985     0.871     0.200
    77.241     0.538     0.200
    77.454    -3.762     0.200
    77.337    -0.197     0.200
    77.542    -1.644     0.200
    77.774    -2.669     0.200
    77.672     0.928     0.200
    77.837    -1.710     0.200
    77.772    -0.757     0.200
    77.741     4.143     0.200
    77.841    -0.971     0.200
    77.938    -3.210     0.200
    77.791     1.068     0.200
    78.157    -1.297     0.200
    78.157     0.084     0.200
    78.090     2.104     0.200
    78.409    -0.575     0.200
    78.349    -0.730     0.200
    78.466    -0.838     0.200
    78.397     0.005     0.200
    78.705    -0.987     0.200
    78.703     0.614     0.200
    78.961    -0.468     0.200
    78.988    -2.068     0.200
    79.082    -1.334     0.200
    79.078    -1.544     0.200
    79.104    -1.287     0.200
    79.148    -1.426     0.200
    79.149    -0.832     0.200
    79.196     0.511     0.200
    79.290    -2.313     0.200
    79.241    -1.636     0.200
    79.525     0.008     0.200
    79.575    -0.734     0.200
    79.526     0.672     0.200
    79.747    -0.229     0.200
    79.874    -1.775     0.200
    80.297    -1.268     0.200
    80.301    -1.384     0.200
    80.279     0.134     0.200
    80.467    -1.065     0.200
    80.509     0.397     0.200
    80.509    -0.808     0.200
    80.509    -1.723     0.200
    80.513     0.878     0.200
    80.714    -0.029     0.200
    80.718    -2.076     0.200
    80.718    -3.634     0.200
    80.665    -1.237     0.200
    80.703    -1.640     0.200
    80.951     0.135     0.200
    81.198    -1.061     0.200
    81.161    -1.382     0.200
    81.170    -0.534     0.200
    81.227     0.766     0.200
    81.468     0.385     0.200
    81.557    -1.917     0.200
    81.773    -0.124     0.200
    81.794     0.363     0.200
    82.069     0.317     0.200
    82.402     1.077     0.200
    82.470    -0.382     0.200
    82.538    -0.595     0.200
    82.596     1.522     0.200
    82.596     1.964     0.200
    82.764     0.091     0.200
    82.784    -0.214     0.200
    82.878     4.498     0.200
    82.936     0.524     0.200
    83.003     5.251     0.200
    83.135    -0.713     0.200
    83.071    -0.303     0.200
    83.114     2.673     0.200
    83.126     0.525     0.200
    83.224     3.767     0.200
    83.283    -0.996     0.200
    83.319     3.279     0.200
    83.361     3.861     0.200
    83.395     1.526     0.200
    83.395     0.926     0.200
    83.394     2.009     0.200
    83.489     0.459     0.200
    83.489     3.643     0.200
    83.608     4.232     0.200
    83.673     1.496     0.200
    83.673     0.796     0.200
    83.717     1.471     0.200
    83.765    -2.080     0.200
    83.765    -0.576     0.200
    83.766    -0.447     0.200
    83.756    -0.828     0.200
    83.868     6.089     0.200
    83.868     4.329     0.200
    83.938     0.112     0.200
    83.974     6.519     0.200
    83.974     6.019     0.200
    83.974     2.519     0.200
    84.035    -0.251     0.200
    84.060    -0.279     0.200
    84.060    -1.079     0.200
    84.060    -0.779     0.200
    84.060    -1.419     0.200
    84.110     0.766     0.200
    84.140    -0.577     0.200
    84.156     0.328     0.200
    84.225    -0.619     0.200
    84.261     0.096     0.200
    84.261     0.696     0.200
    84.301    -1.006     0.200
    84.386     0.260     0.200
    84.437    -1.094     0.200
    84.458    -0.502     0.200
    84.488    -0.552     0.200
    84.488     1.048     0.200
    84.497    -0.449     0.200
    84.507    -0.153     0.200
    84.507    -0.349     0.200
    84.510    -0.365     0.200
    84.533    -0.484     0.200
    84.683    -0.922     0.200
    84.629    -0.767     0.200
    84.668    -0.113     0.200
    84.675    -0.800     0.200
    84.684    -0.146     0.200
    84.684     2.724     0.200
    84.684    -0.445     0.200
    84.684     2.326     0.200
    84.798    -0.819     0.200
    84.871    -0.987     0.200
    84.981     0.162     0.200
    84.981    -0.539     0.200
    85.163    -1.499     0.200
    85.163    -1.349     0.200
    85.263    -1.753     0.200
    85.306    -0.765     0.200
    85.314     1.689     0.200
    85.314    -1.209     0.200
    85.424    -0.953     0.200
    85.436    -1.515     0.200
    85.436     0.505     0.200
    85.450    -1.711     0.200
    85.450    -1.986     0.200
    85.450    -1.386     0.200
    85.534    -1.002     0.200
    85.600    -0.233     0.200
    85.718    -1.117     0.200
    85.975    -0.450     0.200
    86.084    -1.829     0.200
    86.120    -1.807     0.200
    86.247     0.204     0.200
    86.302    -2.107     0.200
    86.320     0.007     0.200
    86.344     0.691     0.200
    86.351     0.492     0.200
    86.374     1.440     0.200
    86.392     0.682     0.200
    86.408     2.572     0.200
    86.455     1.412     0.200
    86.432     2.257     0.200
    86.474     0.174     0.200
    86.613     1.168     0.200
    86.709     0.025     0.200
    86.761     1.059     0.200
    86.771     0.895     0.200
    86.816     1.173     0.200
    86.902    -1.107     0.200
    86.866     1.929     0.200
    86.887    -1.472     0.200
    87.028     0.866     0.200
    87.028     1.161     0.200
    87.038    -1.510     0.200
    87.125     4.139     0.200
    87.127     0.826     0.200
    87.154     0.695     0.200
    87.154     2.529     0.200
    87.180     1.265     0.200
    87.182    -0.024     0.200
    87.274     1.377     0.200
    87.290    -0.932     0.200
    87.291     1.861     0.200
    87.296    -2.461     0.200
    87.296     2.441     0.200
    87.315     2.445     0.200
    87.325     3.069     0.200
    87.363    -0.944     0.200
    87.420     3.352     0.200
    87.487     2.318     0.200
    87.536     1.079     0.200
    87.561    -0.491     0.200
    87.624     2.878     0.200
    87.674     2.321     0.200
    87.699     1.049     0.200
    87.765     0.983     0.200
    87.806    -0.601     0.200
    87.798     0.128     0.200
    87.811     1.126     0.200
    87.894     2.869     0.200
    87.932    -0.680     0.200
    87.945     0.921     0.200
    87.972     2.498     0.200
    88.014     0.127     0.200
    88.070    -0.396     0.200
    88.078    -2.202     0.200
    88.093     0.416     0.200
    88.093     1.727     0.200
    88.120     0.949     0.200
    88.104    -0.527     0.200
    88.104     2.073     0.200
    88.207     0.626     0.200
    88.242     1.773     0.200
    88.309    -0.737     0.200
    88.298     1.451     0.200
    88.325    -0.092     0.200
    88.326     2.722     0.200
    88.370    -1.187     0.200
    88.409     1.632     0.200
    88.438     4.795     0.200
    88.454     2.517     0.200
    88.615    -2.829     0.200
    88.475     2.520     0.200
    88.544    -1.159     0.200
    88.592     0.814     0.200
    88.606     1.356     0.200
    88.630    -0.214     0.200
    88.638     1.349     0.200
    88.638     3.149     0.200
    88.645     3.480     0.200
    88.646    -0.219     0.200
    88.646    -1.089     0.200
    88.651    -0.550     0.200
    88.653     0.948     0.200
    88.744    -0.928     0.200
    88.769     1.933     0.200
    88.783     2.466     0.200
    88.833     1.934     0.200
    88.847    -3.533     0.200
    88.847    -2.633     0.200
    88.888     1.694     0.200
    88.904     1.525     0.200
    88.942     0.917     0.200
    89.308    -3.069     0.200
    89.003     2.234     0.200
    89.363     2.315     0.200
    89.111    -1.276     0.200
    89.126     2.054     0.200
    89.214     0.330     0.200
    89.242     0.175     0.200
    89.256     1.504     0.200
    89.273     0.966     0.200
    89.310     1.392     0.200
    89.541    -1.412     0.200
    89.340     1.002     0.200
    89.343     1.637     0.200
    89.555    -1.068     0.200
    89.349     1.810     0.200
    89.414     0.602     0.200
    89.414     2.302     0.200
    89.438     0.325     0.200
    89.513     0.728     0.200
    89.564    -0.999     0.200
    89.588    -4.612     0.200
    89.588     1.683     0.200
    89.588     1.488     0.200
    89.649     1.005     0.200
    89.697     1.979     0.200
    89.821    -1.199     0.200
    89.754    -2.987     0.200
    89.772    -0.271     0.200
    89.790     1.046     0.200
    89.845    -0.843     0.200
    89.859     2.022     0.200
    89.886    -1.902     0.200
    89.884    -2.794     0.200
    89.933     0.128     0.200
    90.040     0.881     0.200
    90.041     0.674     0.200
    90.077    -1.597     0.200
    90.366    -3.711     0.200
    90.106     0.168     0.200
    90.129     0.829     0.200
    90.229     0.695     0.200
    90.269    -0.394     0.200
    90.269     3.420     0.200
    90.273     4.690     0.200
    90.296    -1.618     0.200
    90.342    -0.639     0.200
    90.348     2.339     0.200
    90.361     2.479     0.200
    90.430     0.161     0.200
    90.691     5.743     0.200
    90.554     2.181     0.200
    90.786    -0.899     0.200
    90.611    -2.985     0.200
    90.672    -2.766     0.200
    90.712     0.721     0.200
    90.972     6.138     0.200
    90.772     2.467     0.200
    91.012     5.953     0.200
    90.803     1.522     0.200
    90.803     1.886     0.200
    90.820    -0.647     0.200
    90.998    -0.129     0.200
    91.016    -2.347     0.200
    91.065    -0.292     0.200
    91.070     0.984     0.200
    91.091    -0.012     0.200
    91.104     1.425     0.200
    91.143     0.945     0.200
    91.199     0.244     0.200
    91.230    -0.660     0.200
    91.230     2.440     0.200
    91.230     1.307     0.200
    91.222     0.076     0.200
    91.271     1.549     0.200
    91.319    -0.871     0.200
    91.319     2.529     0.200
    91.340    -0.368     0.200
    91.342     0.637     0.200
    91.416    -0.820     0.200
    91.428     0.823     0.200
    91.491     0.829     0.200
    91.502     1.178     0.200
    91.546    -3.425     0.200
    91.548    -0.037     0.200
    91.566    -0.755     0.200
    91.567    -0.220     0.200
    91.595    -0.253     0.200
    91.708     0.369     0.200
    91.722     0.461     0.200
    91.771     0.233     0.200
    91.810     0.354     0.200
    91.815    -2.671     0.200
    91.838    -0.575     0.200
    91.860     4.221     0.200
    91.863    -2.391     0.200
    91.893     0.470     0.200
    91.900     0.735     0.200
    91.914    -2.629     0.200
    91.939     2.157     0.200
    91.944     0.133     0.200
    91.964     1.039     0.200
    91.972     2.505     0.200
    91.995     0.099     0.200
    92.034     0.399     0.200
    92.034     2.232     0.200
    92.041    -0.214     0.200
    92.050     0.345     0.200
    92.084    -0.675     0.200
    92.103    -2.001     0.200
    92.103    -2.318     0.200
    92.227    -1.276     0.200
    92.195    -3.148     0.200
    92.231    -3.993     0.200
    92.233     0.798     0.200
    92.257     0.686     0.200
    92.331     0.345     0.200
    92.374    -1.254     0.200
    92.387    -1.514     0.200
    92.394    -0.344     0.200
    92.440     3.342     0.200
    92.457    -0.536     0.200
    92.478    -3.834     0.200
    92.536     0.397     0.200
    92.559    -0.910     0.200
    92.575    -3.483     0.200
    92.596     0.180     0.200
    92.725     2.092     0.200
    92.789    -0.460     0.200
    92.832     0.631     0.200
    92.935    -0.845     0.200
    92.880    -1.089     0.200
    92.898    -1.574     0.200
    92.906    -1.910     0.200
    92.924    -1.291     0.200
    92.937    -0.511     0.200
    92.936    -3.049     0.200
    92.980    -2.051     0.200
    92.983    -1.413     0.200
    93.102     1.413     0.200
    93.044     0.453     0.200
    93.080     0.788     0.200
    93.083    -2.224     0.200
    93.092    -3.167     0.200
    93.149    -2.332     0.200
    93.150     0.367     0.200
    93.154     3.845     0.200
    93.173     0.961     0.200
    93.174    -3.146     0.200
    93.261     0.885     0.200
    93.254    -3.313     0.200
    93.255     2.626     0.200
    93.260    -4.242     0.200
    93.260     0.859     0.200
    93.303     3.861     0.200
    93.356    -0.283     0.200
    93.353     1.909     0.200
    93.337     0.902     0.200
    93.361    -1.708     0.200
    93.361     0.995     0.200
    93.364     0.580     0.200
    93.367    -0.333     0.200
    93.488     0.111     0.200
    93.395     2.328     0.200
    93.505     3.383     0.200
    93.427    -0.059     0.200
    93.456    -2.942     0.200
    93.482     4.438     0.200
    93.488    -0.292     0.200
    93.497    -0.934     0.200
    93.506     2.525     0.200
    93.528     4.792     0.200
    93.541    -0.296     0.200
    93.540     1.469     0.200
    93.556     0.698     0.200
    93.559     4.182     0.200
    93.567    -1.356     0.200
    93.571    -2.072     0.200
    93.721     4.308     0.200
    93.620    -0.501     0.200
    93.639     4.878     0.200
    93.646     0.583     0.200
    93.653     0.348     0.200
    93.675    -0.334     0.200
    93.691    -0.227     0.200
    93.721    -0.363     0.200
    93.725     1.616     0.200
    93.746     3.482     0.200
    93.778     1.573     0.200
    93.788    -3.770     0.200
    93.980    -0.234     0.200
    93.881     2.800     0.200
    93.966     0.209     0.200
    93.966     0.641     0.200
    94.145     1.880     0.200
    94.159     0.832     0.200
    94.085    -2.039     0.200
    94.085     1.156     0.200
    94.085     1.861     0.200
    94.100     1.792     0.200
    94.104    -2.625     0.200
    94.140    -2.490     0.200
    94.156     1.437     0.200
    94.162     0.511     0.200
    94.162    -1.989     0.200
    94.184     2.606     0.200
    94.193    -2.332     0.200
    94.198     1.744     0.200
    94.208    -2.301     0.200
    94.208     2.099     0.200
    94.211     0.483     0.200
    94.223    -0.521     0.200
    94.231     2.092     0.200
    94.357     4.259     0.200
    94.378     0.331     0.200
    94.267     0.526     0.200
    94.380     1.277     0.200
    94.381     4.149     0.200
    94.287    -1.267     0.200
    94.287     1.023     0.200
    94.289     1.826     0.200
    94.324    -0.737     0.200
    94.360    -0.702     0.200
    94.380     1.909     0.200
    94.544     1.005     0.200
    94.448    -1.902     0.200
    94.448     1.898     0.200
    94.475     4.473     0.200
    94.484     0.030     0.200
    94.489     1.310     0.200
    94.506     3.875     0.200
    94.566     3.153     0.200
    94.707     1.526     0.200
    94.601     3.430     0.200
    94.618    -2.882     0.200
    94.618     1.818     0.200
    94.640    -0.795     0.200
    94.636    -1.368     0.200
    94.773     2.351     0.200
    94.687    -0.401     0.200
    94.718    -0.833     0.200
    94.723     2.937     0.200
    94.794     1.842     0.200
    94.798     1.990     0.200
    94.798     1.166     0.200
    94.803     2.859     0.200
    94.960     4.366     0.200
    94.856     2.236     0.200
    95.003     2.733     0.200
    94.970    -0.865     0.200
    94.970    -0.304     0.200
    94.973    -2.710     0.200
    95.043     1.760     0.200
    95.043    -1.430     0.200
    95.051     3.223     0.200
    95.174     2.911     0.200
    95.103    -1.903     0.200
    95.127     4.186     0.200
    95.238     2.678     0.200
    95.414     4.688     0.200
    95.357    -0.135     0.200
    95.383     2.848     0.200
    95.587     4.377     0.200
    95.566     3.153     0.200
    95.570    -1.174     0.200
    95.587    -1.412     0.200
    95.587    -1.513     0.200
    95.618    -0.954     0.200
    95.618    -1.254     0.200
    95.634     3.669     0.200
    95.672     4.699     0.200
    95.800     4.364     0.200
    95.844     0.016     0.200
    95.899     1.567     0.200
    95.936     4.597     0.200
    96.078     1.752     0.200
    96.091     2.521     0.200
    96.118     2.470     0.200
    96.145     1.747     0.200
    96.206    -1.172     0.200
    96.292    -1.424     0.200
    96.429     2.463     0.200
    96.403     0.273     0.200
    96.457     0.698     0.200
    96.477     3.407     0.200
    96.489     1.246     0.200
    96.517     2.759     0.200
    96.563     1.987     0.200
    96.897    -1.066     0.200
    96.889     0.630     0.200
    97.188    -1.379     0.200
    97.441    -0.533     0.200
    97.687    -0.485     0.200
    97.838    -4.921     0.200
    97.999    -0.978     0.200
    98.028    -2.012     0.200
    98.317    -1.809     0.200
    98.408    -0.567     0.200
    98.500    -0.558     0.200
    98.547    -0.757     0.200
    98.755    -1.206     0.200
    99.037    -0.776     0.200
    99.116    -1.440     0.200
    99.211    -1.536     0.200
    99.385    -0.814     0.200
    99.412    -0.938     0.200
    99.459    -2.232     0.200
    18.931    -1.379     0.200
    23.648    -3.513     0.200
    25.823    -1.190     0.200
    25.991     0.834     0.200
    27.643     0.269     0.200
    31.314    -1.706     0.200
    34.862     0.798     0.200
    40.658     0.222     0.200
    50.368    -0.553     0.200
    51.041     0.854     0.200
    52.173    -1.648     0.200
    56.991    -1.203     0.200
    68.037    -0.408     0.200
    68.285     0.238     0.200
    79.869    -2.253     0.200
    80.213    -0.925     0.200
    80.329    -1.137     0.200
    80.693     0.767     0.200
    82.988     0.525     0.200
    83.482     1.355     0.200
    83.795     0.230     0.200
    83.795     0.229     0.200
    97.186    -4.129     0.200
    25.745     0.133     0.200
    25.745     2.384     0.200
    27.501     0.548     0.200
    34.208     1.662     0.200
    34.720     1.170     0.200
    34.842    -0.150     0.200
    40.526     1.469     0.200
    48.150    -1.974     0.200
    50.931     1.409     0.200
    50.931     1.412     0.200
    51.427    -2.280     0.200
    53.351    -1.925     0.200
    55.061     0.033     0.200
    55.802     0.911     0.200
    64.933    -1.054     0.200
    69.007    -0.301     0.200
    69.033    -1.641     0.200
    77.640    -1.331     0.200
    78.276    -1.781     0.200
    79.614    -1.893     0.200
    80.002    -1.085     0.200
    82.272    -0.899     0.200
    82.469    -1.697     0.200
    82.830    -0.656     0.200
    83.027    -1.436     0.200
    83.353    -1.281     0.200
    83.525    -0.705     0.200
    86.683    -1.045     0.200
    20.026     0.724     0.200
    20.718     0.258     0.200
    20.771    -0.153     0.200
    21.206    -0.075     0.200
    23.052     2.795     0.200
    23.342     3.066     0.200
    23.373     0.243     0.200
    23.448     0.412     0.200
    23.621     0.961     0.200
    23.718    -1.688     0.200
    23.728     0.670     0.200
    24.784     0.848     0.200
    25.719     2.039     0.200
    25.953     0.814     0.200
    25.952    -1.230     0.200
    27.593     0.644     0.200
    34.777    -0.152     0.200
    34.815     0.868     0.200
    44.714     1.738     0.200
    44.859    -0.623     0.200
    50.963     1.216     0.200
    50.963     1.219     0.200
    51.371     0.213     0.200
    51.610    -0.397     0.200
    52.096    -1.473     0.200
    52.152    -2.295     0.200
    53.866     0.434     0.200
    53.868     0.416     0.200
    55.096    -1.411     0.200
    55.097     0.722     0.200
    55.699    -0.927     0.200
    61.202    -0.212     0.200
    63.791    -0.998     0.200
    64.972     0.880     0.200
    68.307    -1.744     0.200
    68.985    -0.061     0.200
    69.217    -0.927     0.200
    69.266    -0.095     0.200
    76.416    -0.999     0.200
    83.521    -1.444     0.200
    23.059     0.740     0.200
    23.237    -0.376     0.200
    25.463     1.818     0.200
    25.559     0.977     0.200
    44.419     2.083     0.200
    50.913    -0.566     0.200
    50.913    -0.568     0.200
    51.917    -1.279     0.200
    53.876    -0.021     0.200
    53.876    -0.419     0.200
    53.878    -0.039     0.200
    55.064     0.804     0.200
    55.521    -1.551     0.200
    55.611    -0.881     0.200
    83.313     0.760     0.200
    83.444     0.239     0.200
    83.870     0.180     0.200
    83.976    -1.050     0.200
    85.704    -1.908     0.200
    85.841    -2.148     0.200
    87.133     0.331     0.200
    88.514     0.134     0.200
    25.814    -2.210     0.200
    27.510     1.648     0.200
    31.414    -0.931     0.200
    31.414    -0.935     0.200
    34.275    -0.710     0.200
    34.807    -0.512     0.200
    34.807    -1.070     0.200
    34.725     0.330     0.200
    50.984    -0.663     0.200
    50.984    -0.660     0.200
    55.112     0.690     0.200
    60.772    -0.106     0.200
    63.755    -1.257     0.200
    75.733    -0.149     0.200
    84.080     1.580     0.200
    84.080     1.576     0.200
    85.122     0.178     0.200
    85.122     0.183     0.200
    85.440    -0.103     0.200
    19.910     0.099     0.200
    21.409     1.200     0.200
    25.738     0.562     0.200
    25.737     0.564     0.200
    27.728    -0.456     0.200
    27.785    -0.963     0.200
    27.812    -0.743     0.200
    31.347    -1.880     0.200
    31.346    -1.878     0.200
    34.721    -0.585     0.200
    34.722    -0.593     0.200
    34.960    -0.177     0.200
    34.960     0.468     0.200
    40.635     2.089     0.200
    40.635     2.090     0.200
    44.824    -0.897     0.200
    44.824     0.178     0.200
    48.120     0.079     0.200
    50.941     0.467     0.200
    50.941     0.472     0.200
    53.877    -0.987     0.200
    53.880    -1.006     0.200
    55.084    -1.222     0.200
    56.513    -0.145     0.200
    60.671     0.250     0.200
    60.671     0.251     0.200
    63.856    -0.893     0.200
    64.887     0.567     0.200
    64.887     1.048     0.200
    80.874    -0.963     0.200
    83.761    -0.409     0.200
    83.761    -0.409     0.200
    83.945    -0.128     0.200
    83.945    -0.132     0.200
    85.127     0.123     0.200
    85.127     0.122     0.200
    85.375    -1.097     0.200
    85.567    -1.146     0.200
    86.818     0.709     0.200
    92.075    -1.970     0.200
    95.119    -1.270     0.200
    95.119    -1.268     0.200
    15.162     6.075     0.200
    15.389     6.191     0.200
    15.716     4.327     0.200
    16.122     7.782     0.200
    16.300     2.809     0.200
    17.213     2.983     0.200
    18.937    -0.130     0.200
    19.609    -1.525     0.200
    20.062     0.466     0.200
    20.624    -0.172     0.200
    20.665    -0.153     0.200
    20.665     0.772     0.200
    20.713     1.244     0.200
    20.845    -1.334     0.200
    21.354     5.135     0.200
    21.463     5.160     0.200
    21.722    -0.082     0.200
    21.726     4.238     0.200
    22.184     4.945     0.200
    22.345     0.255     0.200
    22.310     1.996     0.200
    22.347     3.109     0.200
    22.390     2.751     0.200
    22.466     1.262     0.200
    22.495     1.434     0.200
    22.906     5.079     0.200
    23.146     5.343     0.200
    23.146     1.203     0.200
    23.430     1.382     0.200
    23.430     4.457     0.200
    23.400     5.174     0.200
    23.426     4.597     0.200
    23.447     1.578     0.200
    23.543     0.243     0.200
    23.724    -1.673     0.200
    23.724    -0.789     0.200
    23.715     0.316     0.200
    23.815     2.746     0.200
    23.855     0.352     0.200
    24.002    -1.078     0.200
    24.020     4.870     0.200
    24.091    -1.428     0.200
    24.091    -1.428     0.200
    24.197     2.155     0.200
    24.208     4.558     0.200
    24.172     1.881     0.200
    24.224     2.712     0.200
    24.306     4.566     0.200
    24.364    -2.587     0.200
    24.680     3.151     0.200
    24.881     2.323     0.200
    24.927     4.601     0.200
    24.997     1.568     0.200
    25.053     3.062     0.200
    25.212     1.914     0.200
    25.280     2.992     0.200
    25.280     0.992     0.200
    25.550     4.740     0.200
    25.552     2.129     0.200
    25.790     0.202     0.200
    25.790    -0.013     0.200
    25.790     1.173     0.200
    25.914     2.442     0.200
    25.886    -1.203     0.200
    26.051    -0.555     0.200
    26.049    -0.277     0.200
    26.049     0.123     0.200
    26.048     0.119     0.200
    26.440     0.089     0.200
    27.549     0.513     0.200
    27.549    -1.565     0.200
    27.705     0.209     0.200
    27.705    -0.691     0.200
    27.942    -0.940     0.200
    27.942    -1.733     0.200
    27.942    -1.988     0.200
    29.363    -1.740     0.200
    29.363    -1.752     0.200
    29.948    -1.380     0.200
    29.948    -1.925     0.200
    30.755     0.741     0.200
    31.389    -2.342     0.200
    31.389    -1.972     0.200
    31.394    -2.211     0.200
    31.398    -2.233     0.200
    31.628    -2.578     0.200
    31.638    -1.895     0.200
    31.637    -2.571     0.200
    31.642    -3.032     0.200
    31.643    -1.892     0.200
    31.845     2.939     0.200
    32.688     3.247     0.200
    33.701     1.406     0.200
    33.958    -0.960     0.200
    34.326    -2.153     0.200
    34.258     0.262     0.200
    34.785    -1.044     0.200
    34.785    -1.194     0.200
    34.766    -1.601     0.200
    34.766    -0.627     0.200
    34.766    -0.627     0.200
    34.829     1.127     0.200
    34.829    -1.243     0.200
    35.045    -0.739     0.200
    36.447     1.538     0.200
    36.490     2.835     0.200
    36.490     1.764     0.200
    36.983    -0.634     0.200
    36.983    -1.534     0.200
    37.590     0.196     0.200
    38.383     1.323     0.200
    38.492     1.212     0.200
    39.189     1.468     0.200
    39.328    -0.095     0.200
    39.597    -1.521     0.200
    39.638     0.199     0.200
    39.638     0.024     0.200
    39.760     1.407     0.200
    40.389     0.684     0.200
    40.402     0.581     0.200
    40.410    -0.683     0.200
    40.566     0.723     0.200
    40.583     0.561     0.200
    40.583    -0.219     0.200
    40.703    -1.132     0.200
    40.657     0.772     0.200
    41.173     0.320     0.200
    42.016     0.713     0.200
    43.171     0.176     0.200
    44.052    -0.603     0.200
    44.052    -0.377     0.200
    44.858     0.089     0.200
    44.858    -0.436     0.200
    44.793     1.305     0.200
    44.818     0.723     0.200
    44.818     1.004     0.200
    44.818    -1.365     0.200
    45.415    -0.778     0.200
    45.657     1.350     0.200
    46.169    -0.870     0.200
    46.156     3.010     0.200
    46.156    -0.690     0.200
    48.092    -1.910     0.200
    48.092    -1.675     0.200
    48.358     0.451     0.200
    49.398    -0.543     0.200
    50.789    -0.516     0.200
    50.789    -2.283     0.200
    50.792    -0.538     0.200
    50.984    -1.235     0.200
    50.989     0.514     0.200
    50.989     0.864     0.200
    50.989     0.714     0.200
    51.001     0.121     0.200
    51.139    -0.612     0.200
    51.179     0.387     0.200
    51.179     0.957     0.200
    51.369    -0.733     0.200
    51.369    -1.542     0.200
    51.860     3.090     0.200
    52.017    -0.180     0.200
    52.112    -0.888     0.200
    52.112    -1.128     0.200
    52.150     0.827     0.200
    52.324     0.380     0.200
    52.552     1.043     0.200
    53.004     0.106     0.200
    53.317     2.180     0.200
    53.406     0.445     0.200
    53.877    -0.283     0.200
    53.877    -0.708     0.200
    53.881     2.127     0.200
    54.008     1.055     0.200
    54.047     0.849     0.200
    54.047     1.554     0.200
    54.281     0.865     0.200
    54.547     1.081     0.200
    55.117    -0.320     0.200
    55.117     0.550     0.200
    55.118     0.347     0.200
    55.753     0.701     0.200
    56.952     0.054     0.200
    56.952     0.054     0.200
    57.624     0.412     0.200
    59.961     0.461     0.200
    60.779    -0.929     0.200
    60.779    -0.749     0.200
    61.685    -1.262     0.200
    61.685    -2.371     0.200
    61.685    -1.121     0.200
    63.779    -0.453     0.200
    64.329    -1.141     0.200
    65.023     0.778     0.200
    65.023    -0.102     0.200
    65.023     0.088     0.200
    65.715    -0.351     0.200
    65.715    -0.451     0.200
    65.808     0.321     0.200
    65.891     0.134     0.200
    65.932     0.003     0.200
    65.951     0.249     0.200
    65.957     0.155     0.200
    66.024    -0.172     0.200
    66.309    -0.408     0.200
    66.381     1.138     0.200
    66.383    -0.775     0.200
    66.634     1.040     0.200
    66.688     0.307     0.200
    67.001    -0.148     0.200
    67.315     0.220     0.200
    68.206    -0.460     0.200
    68.286    -0.747     0.200
    68.305    -0.719     0.200
    68.305    -0.859     0.200
    68.976    -0.452     0.200
    69.188    -0.240     0.200
    69.516    -0.901     0.200
    69.861    -0.009     0.200
    74.803    -2.304     0.200
    75.516    -2.491     0.200
    75.533    -0.189     0.200
    75.533    -0.699     0.200
    75.709     0.024     0.200
    75.709    -0.096     0.200
    75.807    -2.256     0.200
    76.126    -0.471     0.200
    76.339     0.614     0.200
    76.456    -1.848     0.200
    76.842     0.170     0.200
    76.990     0.982     0.200
    76.990    -0.061     0.200
    76.990    -2.571     0.200
    77.358    -2.582     0.200
    77.533    -1.107     0.200
    77.741    -1.200     0.200
    77.949    -4.065     0.200
    77.952    -3.844     0.200
    78.053    -0.734     0.200
    78.053    -1.203     0.200
    79.139    -1.591     0.200
    79.230    -1.186     0.200
    79.427    -0.684     0.200
    79.685    -0.847     0.200
    79.771    -1.333     0.200
    79.856    -1.393     0.200
    80.201     0.442     0.200
    80.493    -0.828     0.200
    80.618    -1.891     0.200
    80.618    -2.301     0.200
    80.625    -2.937     0.200
    80.706    -0.570     0.200
    81.121    -0.987     0.200
    81.588    -1.931     0.200
    83.034     0.166     0.200
    83.034     0.373     0.200
    83.722    -0.444     0.200
    84.071    -1.353     0.200
    84.071     0.047     0.200
    84.071    -1.153     0.200
    84.695    -0.517     0.200
    84.840     0.157     0.200
    85.001    -1.245     0.200
    85.133    -1.317     0.200
    85.327    -1.033     0.200
    85.327    -1.683     0.200
    85.412    -1.811     0.200
    85.441    -1.329     0.200
    85.441    -0.655     0.200
    85.441    -1.754     0.200
    86.469    -1.543     0.200
    87.106     0.672     0.200
    87.106     0.890     0.200
    87.106    -0.854     0.200
    88.013     2.391     0.200
    88.354    -1.623     0.200
    88.711    -2.018     0.200
    88.642    -0.903     0.200
    88.646    -1.363     0.200
    90.500     1.319     0.200
    92.070    -2.066     0.200
    92.070    -1.966     0.200
    92.528     3.720     0.200
    94.593    -0.785     0.200
    94.871    -2.013     0.200
    95.043    -0.552     0.200
    95.087    -2.447     0.200
    95.607    -1.134     0.200
    96.491    -0.814     0.200
    97.145    -0.554     0.200
    97.285    -3.433     0.200
    97.495    -1.146     0.200
    97.949    -3.112     0.200
    98.239    -0.810     0.200
    18.876     1.201     0.200
    19.925     1.310     0.200
    20.674     0.569     0.200
    21.576     1.247     0.200
    23.258     1.228     0.200
    23.387     0.680     0.200
    25.739     0.844     0.200
    25.739     0.848     0.200
    25.739     0.594     0.200
    25.910     0.479     0.200
    25.909     0.490     0.200
    27.695    -0.505     0.200
    27.814     0.255     0.200
    29.948     0.314     0.200
    31.302    -1.684     0.200
    31.302    -1.683     0.200
    34.685    -0.021     0.200
    34.686    -0.978     0.200
    34.686    -1.268     0.200
    34.917     0.039     0.200
    34.917     0.702     0.200
    36.939    -2.380     0.200
    39.444    -1.005     0.200
    44.772    -0.369     0.200
    48.037     0.526     0.200
    51.033     0.508     0.200
    51.033     0.197     0.200
    51.033     0.197     0.200
    51.223     0.214     0.200
    52.138     0.623     0.200
    52.327    -0.941     0.200
    53.026     0.436     0.200
    53.946    -0.673     0.200
    53.946    -1.448     0.200
    53.949    -0.688     0.200
    54.068     0.981     0.200
    55.169    -0.516     0.200
    55.170    -0.116     0.200
    55.742    -0.025     0.200
    55.798    -0.497     0.200
    55.861    -0.023     0.200
    60.829    -0.547     0.200
    61.242    -0.059     0.200
    63.619    -0.051     0.200
    63.884    -0.929     0.200
    65.018     0.404     0.200
    65.018     0.874     0.200
    65.747    -0.559     0.200
    68.291    -0.455     0.200
    68.359    -1.501     0.200
    69.479    -1.120     0.200
    76.853    -0.322     0.200
    78.225    -0.472     0.200
    15.347     2.945     0.200
    18.953    -0.391     0.200
    19.440    -4.325     0.200
    21.347    -0.588     0.200
    23.283     2.963     0.200
    23.465     1.634     0.200
    24.783     0.505     0.200
    25.817     0.999     0.200
    25.817     0.998     0.200
    25.817     1.219     0.200
    27.721    -1.484     0.200
    31.246    -0.787     0.200
    31.246    -0.781     0.200
    34.313     0.952     0.200
    34.633    -0.566     0.200
    34.939     0.401     0.200
    36.562     1.314     0.200
    36.870     0.682     0.200
    39.494    -1.328     0.200
    39.811    -0.217     0.200
    40.538    -2.220     0.200
    40.559    -1.219     0.200
    40.732     0.935     0.200
    40.732     0.935     0.200
    44.714    -1.394     0.200
    51.103    -0.045     0.200
    51.103    -0.045     0.200
    51.103     0.085     0.200
    51.292     0.772     0.200
    52.251     0.617     0.200
    54.009    -1.026     0.200
    54.012    -1.046     0.200
    55.238     0.356     0.200
    55.937     0.882     0.200
    60.825     0.436     0.200
    60.825     0.434     0.200
    63.935    -0.858     0.200
    76.773     1.547     0.200
    76.886    -2.377     0.200
    76.953    -1.916     0.200
    83.867    -0.232     0.200
    83.867    -0.233     0.200
    85.263    -0.359     0.200
    85.263    -0.354     0.200
    85.547    -0.138     0.200
    85.547    -1.173     0.200
    88.538    -1.444     0.200
    92.204    -0.280     0.200
    15.149     5.300     0.200
    15.483     5.734     0.200
    15.837     5.627     0.200
    15.985     5.323     0.200
    15.985     4.483     0.200
    17.321     3.786     0.200
    17.542     3.970     0.200
    19.189    -1.622     0.200
    19.525    -0.462     0.200
    20.574     0.931     0.200
    20.703     0.361     0.200
    21.255    -1.622     0.200
    21.593     4.444     0.200
    22.183     2.134     0.200
    22.210     3.252     0.200
    22.420     0.614     0.200
    22.427     3.139     0.200
    22.556     0.962     0.200
    23.008     2.696     0.200
    23.292     0.416     0.200
    23.283     3.083     0.200
    23.371     3.662     0.200
    23.371    -0.818     0.200
    23.418     1.062     0.200
    23.418     0.722     0.200
    23.593     1.365     0.200
    23.593    -0.575     0.200
    23.675    -1.631     0.200
    23.678     0.254     0.200
    23.961     0.476     0.200
    23.965     0.765     0.200
    23.965     0.635     0.200
    24.228    -0.109     0.200
    24.228    -0.114     0.200
    24.379    -1.011     0.200
    24.541     2.013     0.200
    24.748    -1.444     0.200
    25.250     2.659     0.200
    25.250     1.159     0.200
    25.720     1.895     0.200
    25.720     0.995     0.200
    25.842     1.437     0.200
    25.842     1.021     0.200
    25.818    -0.095     0.200
    25.922     0.768     0.200
    26.536    -0.090     0.200
    27.213     1.216     0.200
    27.213     0.516     0.200
    27.441     1.067     0.200
    27.646    -1.568     0.200
    27.646     0.182     0.200
    27.730     0.482     0.200
    27.730    -0.718     0.200
    27.863     0.105     0.200
    27.863    -0.609     0.200
    27.863    -1.498     0.200
    29.485    -4.031     0.200
    29.485     0.889     0.200
    29.485     0.892     0.200
    29.979    -0.836     0.200
    29.979    -2.806     0.200
    30.387    -1.422     0.200
    30.797    -0.731     0.200
    31.348    -2.119     0.200
    31.352    -1.659     0.200
    31.539    -1.410     0.200
    31.544    -0.997     0.200
    31.617    -1.468     0.200
    31.860     2.106     0.200
    32.736     4.118     0.200
    34.067    -0.024     0.200
    34.209     2.683     0.200
    34.209     0.183     0.200
    34.320     1.414     0.200
    34.732    -2.083     0.200
    34.733    -1.046     0.200
    34.733    -1.400     0.200
    34.869     0.751     0.200
    34.869     0.376     0.200
    34.972    -0.648     0.200
    34.927     1.075     0.200
    36.455     3.365     0.200
    36.455    -0.240     0.200
    36.460     1.516     0.200
    36.691    -1.108     0.200
    36.979    -0.177     0.200
    36.979     1.498     0.200
    36.979    -1.272     0.200
    37.710     1.672     0.200
    38.335     1.322     0.200
    38.442     1.128     0.200
    39.139     1.185     0.200
    39.405    -0.040     0.200
    39.405    -0.710     0.200
    39.492     0.166     0.200
    39.711     1.406     0.200
    39.738     0.188     0.200
    39.738    -0.411     0.200
    40.340     0.690     0.200
    40.352     0.687     0.200
    40.458    -1.186     0.200
    40.517     0.724     0.200
    40.628    -1.897     0.200
    40.607     0.879     0.200
    40.630     0.170     0.200
    40.630    -0.670     0.200
    41.078    -1.584     0.200
    41.124     0.518     0.200
    41.243     1.682     0.200
    41.967     0.906     0.200
    43.997    -0.308     0.200
    43.997    -1.358     0.200
    44.709     0.774     0.200
    44.818    -0.147     0.200
    44.818    -0.397     0.200
    44.818    -0.997     0.200
    44.866     1.416     0.200
    44.866     1.122     0.200
    44.866    -1.118     0.200
    45.366     0.317     0.200
    45.700     0.707     0.200
    46.159     2.080     0.200
    46.159     0.580     0.200
    48.079     0.950     0.200
    48.079    -2.535     0.200
    48.429     0.300     0.200
    50.913     0.104     0.200
    50.913    -0.101     0.200
    50.917     0.084     0.200
    50.993     0.803     0.200
    50.993     0.548     0.200
    51.331    -1.654     0.200
    51.332     0.839     0.200
    51.413     1.765     0.200
    51.838     2.353     0.200
    52.110     0.028     0.200
    52.204    -0.772     0.200
    52.204    -0.502     0.200
    52.358     0.045     0.200
    52.358    -0.254     0.200
    52.536    -0.436     0.200
    52.688     1.428     0.200
    52.990     0.206     0.200
    53.302     2.592     0.200
    53.393     1.608     0.200
    53.730     1.929     0.200
    53.865     2.030     0.200
    53.902    -0.505     0.200
    53.995     0.240     0.200
    54.032     0.979     0.200
    54.032     1.971     0.200
    54.032     1.359     0.200
    54.032     2.589     0.200
    54.032    -1.431     0.200
    54.268     0.838     0.200
    54.532     1.439     0.200
    55.128    -0.798     0.200
    55.129     0.321     0.200
    55.713     0.492     0.200
    55.764    -0.278     0.200
    55.829    -1.359     0.200
    56.606    -1.592     0.200
    56.936     0.068     0.200
    56.936    -0.132     0.200
    57.253    -0.374     0.200
    60.717     0.232     0.200
    60.788     0.825     0.200
    60.788    -1.195     0.200
    60.788    -0.275     0.200
    61.214    -0.478     0.200
    61.774    -1.059     0.200
    61.774    -1.768     0.200
    61.774    -2.678     0.200
    63.601    -0.173     0.200
    63.837    -0.504     0.200
    64.065     1.464     0.200
    64.442    -3.378     0.200
    64.988    -0.013     0.200
    64.988     0.162     0.200
    64.988     0.162     0.200
    65.709    -0.662     0.200
    65.709    -0.442     0.200
    65.742     0.690     0.200
    65.865     2.825     0.200
    65.889     0.600     0.200
    65.956    -0.240     0.200
    65.956     1.237     0.200
    66.240     0.046     0.200
    66.316    -0.447     0.200
    66.551     1.310     0.200
    66.620     0.291     0.200
    67.329     0.035     0.200
    68.205    -1.987     0.200
    68.276    -0.351     0.200
    68.331    -0.890     0.200
    68.331    -1.049     0.200
    68.317    -0.692     0.200
    68.317    -0.522     0.200
    68.648    -1.291     0.200
    68.959    -0.204     0.200
    68.974    -1.526     0.200
    69.031    -1.552     0.200
    69.189    -2.156     0.200
    69.427     0.054     0.200
    69.518    -0.858     0.200
    74.711    -1.843     0.200
    75.502     0.496     0.200
    75.502    -0.114     0.200
    75.639    -0.329     0.200
    75.639     0.009     0.200
    75.829    -2.177     0.200
    75.891    -0.228     0.200
    76.101    -1.424     0.200
    76.159     0.245     0.200
    76.428     1.017     0.200
    76.464    -0.589     0.200
    76.819     0.103     0.200
    76.968     0.572     0.200
    76.968    -1.732     0.200
    76.968    -1.532     0.200
    77.318     0.901     0.200
    77.529    -1.979     0.200
    77.652    -0.168     0.200
    77.722    -1.357     0.200
    77.792    -0.950     0.200
    78.070     1.606     0.200
    78.498    -1.161     0.200
    78.684    -0.385     0.200
    78.968    -0.046     0.200
    79.229    -1.378     0.200
    79.495     0.573     0.200
    79.547    -1.113     0.200
    80.259     0.237     0.200
    80.499    -2.454     0.200
    80.686    -1.259     0.200
    80.743    -0.715     0.200
    81.449     0.678     0.200
    82.051    -0.694     0.200
    82.451    -2.387     0.200
    83.764    -0.884     0.200
    84.015    -0.859     0.200
    84.040    -0.137     0.200
    84.040    -0.690     0.200
    84.437    -0.905     0.200
    84.489    -1.567     0.200
    84.654    -0.603     0.200
    84.865     0.533     0.200
    84.960     0.459     0.200
    85.156    -1.325     0.200
    85.156    -1.175     0.200
    85.243    -2.362     0.200
    85.446    -0.673     0.200
    85.446    -2.374     0.200
    85.428    -1.382     0.200
    85.437    -1.216     0.200
    85.437    -0.830     0.200
    85.550    -0.583     0.200
    85.514    -1.813     0.200
    85.699    -1.330     0.200
    86.283    -4.222     0.200
    86.593    -1.044     0.200
    86.994     0.548     0.200
    86.994    -0.102     0.200
    87.018    -1.119     0.200
    87.271    -1.648     0.200
    87.411     0.074     0.200
    87.917    -0.185     0.200
    88.055     0.173     0.200
    88.058    -3.818     0.200
    88.593    -2.460     0.200
    88.632    -0.649     0.200
    89.876    -1.664     0.200
    90.283    -1.463     0.200
    90.816    -1.946     0.200
    92.097    -1.485     0.200
    92.097    -0.909     0.200
    92.244    -1.035     0.200
    94.993    -1.292     0.200
    95.574    -0.664     0.200
    95.606    -0.855     0.200
    98.112    -0.807     0.200
    18.606    -1.030     0.200
    18.935    -0.838     0.200
    19.624    -4.004     0.200
    22.359    -0.627     0.200
    23.737    -1.027     0.200
    23.721     0.336     0.200
    25.456    -0.025     0.200
    25.786     0.835     0.200
    25.786    -0.476     0.200
    26.055     1.773     0.200
    26.055     0.284     0.200
    27.533     2.353     0.200
    27.957    -0.563     0.200
    30.394    -0.878     0.200
    31.411    -1.417     0.200
    34.253    -0.842     0.200
    34.750     1.169     0.200
    34.750    -0.337     0.200
    34.798    -1.718     0.200
    34.799    -1.167     0.200
    34.799    -2.635     0.200
    39.313     0.116     0.200
    39.612    -1.898     0.200
    40.570     0.087     0.200
    40.570     0.087     0.200
    40.570    -0.124     0.200
    40.718    -0.350     0.200
    44.066    -0.462     0.200
    44.871    -1.020     0.200
    50.774     1.393     0.200
    50.774     1.979     0.200
    50.778     1.364     0.200
    50.978    -0.987     0.200
    51.419    -1.092     0.200
    52.144     1.072     0.200
    53.865    -1.313     0.200
    53.868    -1.334     0.200
    55.106    -0.099     0.200
    55.107     0.273     0.200
    55.747    -1.043     0.200
    56.943     0.503     0.200
    60.696     0.035     0.200
    60.696     0.033     0.200
    60.768     0.325     0.200
    60.768     0.615     0.200
    63.765    -0.507     0.200
    65.705    -0.088     0.200
    68.294    -0.744     0.200
    68.294    -0.884     0.200
    68.960     1.048     0.200
    73.538    -1.748     0.200
    77.783    -3.156     0.200
    78.589    -3.582     0.200
    79.803    -2.222     0.200
    80.101    -2.662     0.200
    81.573    -2.040     0.200
    81.928    -3.002     0.200
    85.121    -0.760     0.200
    85.121    -0.765     0.200
    85.431    -0.534     0.200
    92.058    -0.759     0.200
    92.058    -0.762     0.200
    23.532     1.034     0.200
    23.792    -1.006     0.200
    25.818     2.903     0.200
    26.131     2.323     0.200
    26.130     0.989     0.200
    27.461    -0.225     0.200
    31.455    -0.496     0.200
    31.530    -2.083     0.200
    34.845    -0.275     0.200
    34.846    -1.104     0.200
    44.115    -1.463     0.200
    50.961     0.513     0.200
    50.961     0.519     0.200
    50.961     0.023     0.200
    55.086     0.236     0.200
    63.294    -0.777     0.200
    63.715    -0.625     0.200
    65.694     0.040     0.200
    83.454    -2.369     0.200
    83.668    -1.028     0.200
    83.668    -1.033     0.200
    83.668    -1.408     0.200
    16.010     5.423     0.200
    19.647    -0.022     0.200
    20.884    -0.510     0.200
    22.383    -1.823     0.200
    23.448     0.394     0.200
    23.564    -0.244     0.200
    23.735     0.941     0.200
    23.816     1.459     0.200
    23.816    -0.737     0.200
    24.180     3.009     0.200
    24.683     5.318     0.200
    24.907     2.277     0.200
    25.010     2.438     0.200
    25.788     1.440     0.200
    25.788    -0.161     0.200
    25.942     3.487     0.200
    26.071     0.362     0.200
    26.071    -0.912     0.200
    26.946     1.520     0.200
    27.979    -0.673     0.200
    29.323     1.292     0.200
    31.420    -2.131     0.200
    31.425    -2.178     0.200
    31.425    -1.658     0.200
    31.425    -2.179     0.200
    31.429    -1.293     0.200
    34.726     1.597     0.200
    34.817    -0.624     0.200
    34.818    -1.192     0.200
    34.818    -0.652     0.200
    36.422     1.929     0.200
    39.292    -1.222     0.200
    40.552     2.458     0.200
    40.552     2.458     0.200
    44.085    -0.790     0.200
    44.796     0.850     0.200
    44.888    -1.355     0.200
    44.888    -1.859     0.200
    50.966     0.378     0.200
    50.966     0.498     0.200
    50.966     0.498     0.200
    50.966    -0.092     0.200
    52.140    -1.411     0.200
    53.850    -1.247     0.200
    53.850     0.427     0.200
    53.850    -0.957     0.200
    53.853     0.403     0.200
    55.093    -0.417     0.200
    55.095     0.005     0.200
    55.842    -0.565     0.200
    56.935    -0.815     0.200
    60.755    -0.493     0.200
    63.746    -0.706     0.200
    65.011     0.357     0.200
    65.695    -0.671     0.200
    68.281    -0.040     0.200
    75.708    -0.266     0.200
    80.579     0.168     0.200
    83.692    -0.028     0.200
    83.692    -0.028     0.200
    84.058    -0.450     0.200
    84.058    -0.451     0.200
    85.107    -0.500     0.200
    85.107    -0.500     0.200
    85.420    -1.044     0.200
    85.420    -0.759     0.200
    87.120     1.108     0.200
    87.120    -0.502     0.200
    25.802     3.574     0.200
    31.419    -1.740     0.200
    31.419    -1.741     0.200
    34.812    -0.705     0.200
    40.737    -1.903     0.200
    50.976     0.281     0.200
    50.976     0.281     0.200
    50.976    -0.369     0.200
    55.103    -0.255     0.200
    55.104    -0.089     0.200
    56.946     0.760     0.200
    56.946     0.870     0.200
    60.764    -0.348     0.200
    14.801     4.616     0.200
    15.484     3.109     0.200
    15.680     3.848     0.200
    15.820     2.727     0.200
    15.959     4.420     0.200
    17.251     2.164     0.200
    18.551    -0.351     0.200
    18.959    -1.006     0.200
    20.022     1.040     0.200
    20.633     0.870     0.200
    20.814    -1.154     0.200
    21.327     2.776     0.200
    21.720    -0.444     0.200
    21.949    -0.020     0.200
    22.310     2.049     0.200
    22.368     2.929     0.200
    22.430     2.862     0.200
    22.495    -0.469     0.200
    22.536     1.238     0.200
    22.882     2.769     0.200
    23.408     2.220     0.200
    23.469     1.783     0.200
    23.544     0.993     0.200
    23.544     0.123     0.200
    23.718     1.379     0.200
    23.718     0.319     0.200
    23.792     1.699     0.200
    23.892    -0.637     0.200
    24.188     2.083     0.200
    24.231     2.191     0.200
    24.403     0.342     0.200
    24.665     2.131     0.200
    24.700     2.714     0.200
    24.875     0.920     0.200
    25.006     1.927     0.200
    25.237     2.528     0.200
    25.313     1.837     0.200
    25.371     4.607     0.200
    25.559     2.103     0.200
    25.813    -1.241     0.200
    25.813     1.349     0.200
    25.813    -0.701     0.200
    25.907     2.249     0.200
    26.048     0.772     0.200
    26.479    -0.924     0.200
    26.926     0.648     0.200
    27.588     1.199     0.200
    27.745    -0.013     0.200
    27.745    -1.013     0.200
    27.902    -1.386     0.200
    29.396    -0.303     0.200
    29.396    -0.352     0.200
    30.347    -1.266     0.200
    30.797    -0.196     0.200
    31.347    -3.452     0.200
    31.353    -2.148     0.200
    31.353    -1.699     0.200
    31.357    -1.893     0.200
    31.762     2.297     0.200
    31.885     1.521     0.200
    32.729     3.610     0.200
    33.751     2.793     0.200
    34.287     0.732     0.200
    34.287     1.131     0.200
    34.743    -1.602     0.200
    34.744    -1.069     0.200
    34.744    -1.629     0.200
    34.804    -0.838     0.200
    34.804     0.588     0.200
    34.804    -1.257     0.200
    36.486     1.117     0.200
    36.522    -0.795     0.200
    36.945    -1.399     0.200
    37.624     1.443     0.200
    38.413     1.283     0.200
    38.521     0.976     0.200
    39.369    -0.433     0.200
    39.369    -0.714     0.200
    39.676     0.004     0.200
    39.676    -0.796     0.200
    39.789     1.266     0.200
    40.418     0.444     0.200
    40.451     1.418     0.200
    40.451    -0.725     0.200
    40.431     0.441     0.200
    40.595     0.482     0.200
    40.624     0.439     0.200
    40.624    -0.461     0.200
    40.663    -0.706     0.200
    40.686     0.632     0.200
    41.202     0.277     0.200
    42.045     0.569     0.200
    43.748    -0.542     0.200
    43.845    -1.022     0.200
    44.010    -1.320     0.200
    44.817    -0.576     0.200
    44.817    -1.001     0.200
    44.812     1.535     0.200
    44.859     2.359     0.200
    45.698     1.805     0.200
    46.194     2.490     0.200
    48.399    -0.395     0.200
    50.821     0.637     0.200
    50.821    -0.664     0.200
    50.825     0.611     0.200
    51.027     0.289     0.200
    51.027     0.414     0.200
    51.027    -0.811     0.200
    51.038    -0.392     0.200
    51.217    -0.738     0.200
    51.894     4.293     0.200
    52.152     0.775     0.200
    52.181     0.301     0.200
    52.181     0.856     0.200
    52.738     1.938     0.200
    53.442     0.536     0.200
    53.442     1.295     0.200
    53.779     1.609     0.200
    53.917    -1.123     0.200
    53.917     0.152     0.200
    53.917    -0.658     0.200
    53.916     2.131     0.200
    54.082     1.292     0.200
    54.082     1.854     0.200
    54.082    -0.253     0.200
    54.317     0.966     0.200
    54.448     2.272     0.200
    54.582     1.304     0.200
    55.156     0.293     0.200
    55.156    -0.552     0.200
    55.156    -0.682     0.200
    55.157    -0.540     0.200
    55.784    -0.574     0.200
    56.987     0.346     0.200
    56.987    -0.354     0.200
    57.661    -0.311     0.200
    60.817     0.607     0.200
    60.817    -0.662     0.200
    60.817    -0.452     0.200
    61.725    -0.813     0.200
    61.725    -0.573     0.200
    63.382     0.039     0.200
    63.695    -0.729     0.200
    63.821    -0.179     0.200
    64.159     0.276     0.200
    64.184     0.093     0.200
    64.231     0.180     0.200
    64.365     0.144     0.200
    64.330    -0.198     0.200
    64.759     0.022     0.200
    64.908     0.276     0.200
    65.016    -0.177     0.200
    65.055     0.139     0.200
    65.055    -0.271     0.200
    65.634     0.160     0.200
    65.752    -0.072     0.200
    65.752    -0.582     0.200
    65.833     0.687     0.200
    65.833     0.427     0.200
    65.915    -0.549     0.200
    65.915    -0.373     0.200
    65.956     0.291     0.200
    65.981     0.007     0.200
    65.981     0.272     0.200
    66.048    -0.004     0.200
    66.048     0.140     0.200
    66.333    -0.125     0.200
    66.408    -0.224     0.200
    66.408     0.461     0.200
    66.712    -0.031     0.200
    66.712     0.654     0.200
    67.231    -0.335     0.200
    67.354    -0.115     0.200
    68.344    -0.560     0.200
    68.344    -0.253     0.200
    68.344    -0.813     0.200
    68.422     0.070     0.200
    68.912     0.188     0.200
    73.609    -1.423     0.200
    74.769    -0.391     0.200
    75.566    -0.586     0.200
    75.733     0.132     0.200
    75.733    -0.442     0.200
    75.847    -1.294     0.200
    76.159    -0.175     0.200
    76.373    -0.191     0.200
    76.876    -0.186     0.200
    77.018    -0.051     0.200
    77.024     2.851     0.200
    77.024     0.532     0.200
    77.024    -0.358     0.200
    77.570    -1.629     0.200
    77.774     0.072     0.200
    78.081     0.391     0.200
    78.081     0.022     0.200
    79.107    -2.031     0.200
    79.176    -0.612     0.200
    79.267    -0.809     0.200
    79.894    -0.822     0.200
    80.233    -0.853     0.200
    80.531    -0.105     0.200
    80.531    -1.255     0.200
    80.650    -0.246     0.200
    80.650    -0.486     0.200
    83.065    -0.825     0.200
    83.075     0.235     0.200
    83.763    -0.034     0.200
    84.104    -0.200     0.200
    84.104    -0.651     0.200
    84.512     0.280     0.200
    84.880    -0.477     0.200
    85.173     0.276     0.200
    85.173     0.651     0.200
    85.361     0.413     0.200
    85.451     0.760     0.200
    85.478    -1.022     0.200
    85.478     0.327     0.200
    86.506     1.925     0.200
    87.114     1.369     0.200
    87.114     1.193     0.200
    87.114    -0.671     0.200
    87.218     1.065     0.200
    88.048    -0.718     0.200
    88.048    -0.077     0.200
    88.392    -1.044     0.200
    88.665    -0.364     0.200
    88.665    -0.091     0.200
    88.678    -0.564     0.200
    88.676    -2.448     0.200
    88.676    -2.786     0.200
    89.748     1.133     0.200
    90.788    -1.165     0.200
    92.110    -0.570     0.200
    95.644     0.645     0.200
    19.979     1.755     0.200
    25.570    -0.055     0.200
    25.570     1.775     0.200
    25.570    -0.755     0.200
    25.768    -2.074     0.200
    34.784     0.816     0.200
    34.890     0.618     0.200
    34.890    -1.536     0.200
    36.208    -2.417     0.200
    39.753    -0.249     0.200
    40.574    -0.947     0.200
    40.574    -0.942     0.200
    50.894     1.189     0.200
    50.894     1.189     0.200
    50.894    -0.411     0.200
    51.976    -0.189     0.200
    53.823    -0.251     0.200
    53.826    -0.270     0.200
    55.035    -1.577     0.200
    56.820    -0.362     0.200
    56.820    -0.581     0.200
    56.820    -0.322     0.200
    61.772    -1.054     0.200
    61.772    -1.793     0.200
    63.793    -1.051     0.200
    64.857     1.176     0.200
    14.160     4.699     0.200
    18.753    -0.124     0.200
    20.664     0.564     0.200
    20.795     0.856     0.200
    20.795     1.106     0.200
    21.154     4.233     0.200
    22.533     1.164     0.200
    22.695     3.750     0.200
    22.914     0.795     0.200
    23.264    -0.033     0.200
    23.309     0.640     0.200
    23.601     1.133     0.200
    23.992     1.152     0.200
    24.319    -0.888     0.200
    24.447     1.177     0.200
    24.643     1.885     0.200
    24.643     0.715     0.200
    25.045     2.627     0.200
    25.163     2.159     0.200
    25.615    -0.941     0.200
    25.615     0.399     0.200
    25.615    -0.551     0.200
    25.813     1.059     0.200
    25.813    -0.042     0.200
    25.812    -0.006     0.200
    26.690     1.829     0.200
    27.658     0.480     0.200
    27.677     0.858     0.200
    27.715    -2.824     0.200
    27.871     0.276     0.200
    27.871    -0.884     0.200
    30.773    -1.421     0.200
    30.793     0.904     0.200
    31.386    -2.096     0.200
    31.386    -2.093     0.200
    31.800     1.933     0.200
    32.701     3.621     0.200
    34.113    -0.784     0.200
    34.179    -2.049     0.200
    34.764    -0.856     0.200
    34.765    -1.133     0.200
    34.765    -1.233     0.200
    34.888     0.533     0.200
    36.399     1.927     0.200
    39.396    -0.274     0.200
    39.396    -1.094     0.200
    39.752     0.653     0.200
    39.752    -0.447     0.200
    40.594     1.073     0.200
    40.594     1.073     0.200
    40.594    -1.208     0.200
    44.600     2.321     0.200
    44.830     0.981     0.200
    44.830    -1.519     0.200
    44.860    -0.303     0.200
    44.860     0.016     0.200
    46.092    -0.514     0.200
    50.927    -0.853     0.200
    50.927     1.277     0.200
    50.927     1.272     0.200
    50.927    -0.373     0.200
    51.335     0.178     0.200
    51.755     4.436     0.200
    52.017    -0.918     0.200
    52.210    -0.850     0.200
    52.210    -2.570     0.200
    52.456    -0.680     0.200
    53.849    -0.774     0.200
    53.849    -0.219     0.200
    53.849    -0.894     0.200
    53.852    -0.243     0.200
    53.954     1.965     0.200
    53.954     0.795     0.200
    53.954    -1.665     0.200
    55.065    -0.085     0.200
    55.065    -0.445     0.200
    55.066    -0.064     0.200
    55.620    -0.085     0.200
    55.680    -1.015     0.200
    55.743    -0.964     0.200
    56.856    -1.210     0.200
    56.856    -1.410     0.200
    60.725    -1.212     0.200
    61.120    -1.230     0.200
    61.777    -2.026     0.200
    61.777    -0.935     0.200
    61.777    -2.485     0.200
    63.809    -0.677     0.200
    64.473    -2.933     0.200
    64.898    -0.282     0.200
    64.898    -0.767     0.200
    64.898    -0.837     0.200
    65.636    -0.264     0.200
    67.118    -0.115     0.200
    67.268     0.260     0.200
    68.255    -1.295     0.200
    68.255    -1.464     0.200
    68.255    -1.634     0.200
    69.204    -1.095     0.200
    73.525    -0.210     0.200
    75.774    -1.432     0.200
    76.016     0.788     0.200
    76.341    -1.763     0.200
    76.736     0.677     0.200
    76.885    -0.336     0.200
    79.063    -1.040     0.200
    80.373    -3.956     0.200
    80.432    -0.874     0.200
    83.953    -0.571     0.200
    83.953    -1.521     0.200
    83.953    -0.571     0.200
    83.953    -1.521     0.200
    85.102     0.168     0.200
    85.102     0.174     0.200
    85.365    -1.501     0.200
    85.368    -2.366     0.200
    88.536     0.785     0.200
    95.535     0.505     0.200
    25.717     2.202     0.200
    34.796    -0.649     0.200
    50.949     0.544     0.200
    50.949     0.544     0.200
    50.949    -0.356     0.200
    52.089     0.525     0.200
    52.955     0.527     0.200
    53.849    -0.701     0.200
    53.852    -0.721     0.200
    55.082     0.513     0.200
    55.735    -0.167     0.200
    65.670    -1.273     0.200
    68.270    -1.138     0.200
    68.270    -1.981     0.200
    18.790    -0.879     0.200
    18.875     0.529     0.200
    20.683     0.914     0.200
    20.747    -2.630     0.200
    20.700     1.145     0.200
    21.205     1.424     0.200
    22.452     2.572     0.200
    22.756     1.745     0.200
    23.280     3.785     0.200
    23.386     0.921     0.200
    23.421     0.861     0.200
    23.665     0.486     0.200
    24.090     3.987     0.200
    24.612     3.127     0.200
    25.165     1.992     0.200
    25.736    -0.253     0.200
    25.736     1.807     0.200
    25.736     0.107     0.200
    25.777     1.033     0.200
    25.923     0.913     0.200
    25.923     0.313     0.200
    25.922     0.369     0.200
    26.802    -0.132     0.200
    27.669     0.282     0.200
    27.726    -1.528     0.200
    27.755     1.615     0.200
    27.755    -0.985     0.200
    27.839     0.467     0.200
    27.839    -0.564     0.200
    29.504    -3.544     0.200
    29.504    -3.557     0.200
    31.323    -1.549     0.200
    31.323    -1.542     0.200
    31.327    -1.693     0.200
    31.349    -1.754     0.200
    34.228    -0.033     0.200
    34.707    -0.375     0.200
    34.708    -0.133     0.200
    34.708    -0.823     0.200
    34.891     0.532     0.200
    34.891    -0.968     0.200
    36.485     1.654     0.200
    39.430    -1.903     0.200
    39.760    -0.358     0.200
    40.483    -1.254     0.200
    40.604    -0.622     0.200
    40.655     0.322     0.200
    40.655     0.322     0.200
    40.655    -1.378     0.200
    42.885     0.876     0.200
    43.823    -0.296     0.200
    44.722     1.500     0.200
    44.793     0.164     0.200
    44.793    -0.761     0.200
    44.891    -0.445     0.200
    48.454     0.638     0.200
    51.017    -0.677     0.200
    51.017     0.853     0.200
    51.017     0.848     0.200
    51.017     0.723     0.200
    51.017    -0.627     0.200
    51.207    -0.202     0.200
    51.436     0.690     0.200
    51.860     2.912     0.200
    52.026    -0.027     0.200
    52.130    -0.698     0.200
    52.558     0.421     0.200
    53.927    -0.392     0.200
    53.927    -0.227     0.200
    53.927    -1.042     0.200
    53.930    -0.242     0.200
    54.055     0.910     0.200
    54.055    -0.485     0.200
    55.152    -0.654     0.200
    55.152    -0.464     0.200
    55.153     0.490     0.200
    55.733    -0.234     0.200
    55.786    -0.215     0.200
    55.850    -0.665     0.200
    56.959    -0.374     0.200
    56.959    -0.374     0.200
    60.813    -1.348     0.200
    60.813    -0.508     0.200
    61.234    -0.320     0.200
    61.798    -1.658     0.200
    61.798    -2.717     0.200
    61.798    -2.247     0.200
    63.862    -0.486     0.200
    65.009     1.234     0.200
    65.009    -0.676     0.200
    65.009    -0.696     0.200
    65.733    -0.936     0.200
    67.214    -0.557     0.200
    67.353    -0.416     0.200
    68.342    -0.872     0.200
    68.342    -0.441     0.200
    73.609    -0.868     0.200
    75.523     0.170     0.200
    75.655    -0.488     0.200
    75.854    -3.123     0.200
    76.122    -0.453     0.200
    76.338     0.021     0.200
    76.841    -0.277     0.200
    76.990     0.038     0.200
    77.552    -2.216     0.200
    79.159    -1.700     0.200
    79.253    -2.415     0.200
    80.523    -1.992     0.200
    80.761    -1.621     0.200
    82.398     1.292     0.200
    83.178    -1.754     0.200
    83.789     0.262     0.200
    83.789     0.256     0.200
    84.062    -0.230     0.200
    84.062    -0.235     0.200
    84.062    -0.910     0.200
    84.381     0.743     0.200
    85.181    -1.263     0.200
    85.181    -1.238     0.200
    85.461    -1.361     0.200
    87.001     1.473     0.200
    87.001    -0.451     0.200
    92.122    -1.318     0.200
    92.122    -0.868     0.200
    92.122    -0.868     0.200
    95.629     0.717     0.200
    24.318    -0.733     0.200
    25.458    -0.846     0.200
    25.458     1.434     0.200
    25.560     1.359     0.200
    27.750    -0.485     0.200
    27.695    -0.441     0.200
    27.821    -0.385     0.200
    31.332    -0.566     0.200
    31.332    -0.570     0.200
    31.332    -1.665     0.200
    31.336    -1.991     0.200
    34.697    -1.992     0.200
    34.698    -0.500     0.200
    34.698    -1.580     0.200
    38.120     1.430     0.200
    38.222     1.273     0.200
    38.918     1.429     0.200
    39.296    -1.205     0.200
    39.495     1.504     0.200
    39.838     1.850     0.200
    40.121     0.797     0.200
    40.133     0.594     0.200
    40.299     0.717     0.200
    40.388     0.685     0.200
    40.654    -0.934     0.200
    40.654    -0.934     0.200
    40.907     0.499     0.200
    41.750     0.668     0.200
    44.817     0.698     0.200
    44.817    -1.683     0.200
    50.904    -0.058     0.200
    50.904     0.622     0.200
    50.904     0.622     0.200
    50.904    -0.308     0.200
    51.093     0.322     0.200
    51.203    -0.220     0.200
    51.869    -0.457     0.200
    51.911    -0.498     0.200
    53.866    -0.360     0.200
    53.866    -0.880     0.200
    53.869    -0.380     0.200
    53.895     0.078     0.200
    55.055     0.348     0.200
    55.055    -0.152     0.200
    55.514     0.236     0.200
    55.660    -0.645     0.200
    56.795     0.114     0.200
    56.795    -0.336     0.200
    60.641     0.081     0.200
    60.641     0.084     0.200
    60.712    -0.869     0.200
    61.920    -1.935     0.200
    64.800     0.886     0.200
    64.800    -0.894     0.200
    65.594    -0.316     0.200
    67.081    -0.018     0.200
    68.247    -1.135     0.200
    68.247    -0.684     0.200
    73.522    -1.385     0.200
    76.662    -0.372     0.200
    81.012    -0.727     0.200
    81.012    -1.367     0.200
    83.863    -0.606     0.200
    83.863    -0.977     0.200
    83.863    -0.607     0.200
    83.863    -0.167     0.200
    85.113    -1.283     0.200
    85.113    -1.283     0.200
    85.326    -1.475     0.200
    85.326    -1.220     0.200
    85.695    -0.162     0.200
    85.695    -0.458     0.200
    19.928     0.986     0.200
    20.677    -0.104     0.200
    24.011    -0.152     0.200
    24.418    -0.484     0.200
    25.737     1.393     0.200
    25.737    -1.607     0.200
    25.909     0.356     0.200
    27.750     1.282     0.200
    31.304    -1.899     0.200
    31.304    -1.892     0.200
    34.688    -0.434     0.200
    34.915     2.332     0.200
    34.915     0.647     0.200
    34.973     1.283     0.200
    36.942    -0.063     0.200
    36.942    -2.762     0.200
    40.674     2.704     0.200
    40.674     2.704     0.200
    40.674     0.664     0.200
    44.775    -0.457     0.200
    50.959     2.798     0.200
    51.031     0.989     0.200
    51.031     0.099     0.200
    51.031     0.094     0.200
    51.031    -0.821     0.200
    52.136    -1.229     0.200
    52.330     0.113     0.200
    52.330    -1.827     0.200
    52.569    -0.511     0.200
    53.943    -0.929     0.200
    55.167    -0.458     0.200
    55.167    -0.448     0.200
    55.859    -1.198     0.200
    60.827    -0.405     0.200
    61.821    -1.144     0.200
    65.016     1.435     0.200
    65.745    -0.772     0.200
    68.356    -1.645     0.200
    68.924    -1.540     0.200
    75.656    -0.996     0.200
    76.851     1.150     0.200
    80.785     0.909     0.200
    80.785     0.655     0.200
    83.202     0.976     0.200
    84.069     1.744     0.200
    84.070    -0.707     0.200
    85.197     0.400     0.200
    85.473    -1.580     0.200
    14.185     4.653     0.200
    14.515     6.546     0.200
    14.984     6.866     0.200
    15.195     3.016     0.200
    15.401     4.094     0.200
    15.856     2.571     0.200
    17.226     2.583     0.200
    18.605     0.106     0.200
    19.190    -2.863     0.200
    19.399    -0.840     0.200
    19.637     0.409     0.200
    20.451    -1.017     0.200
    20.498     0.137     0.200
    21.265     4.738     0.200
    21.252     2.381     0.200
    21.252    -0.629     0.200
    21.285    -0.667     0.200
    21.353    -0.473     0.200
    21.846     3.007     0.200
    21.914    -0.490     0.200
    22.011     3.244     0.200
    22.285     4.820     0.200
    22.230     0.040     0.200
    22.461     2.848     0.200
    22.433     2.544     0.200
    22.671     2.513     0.200
    22.671     0.503     0.200
    22.627     1.689     0.200
    22.976     1.818     0.200
    23.084     0.853     0.200
    23.084     0.033     0.200
    23.118     2.497     0.200
    23.118     0.537     0.200
    23.262     0.981     0.200
    23.262    -0.069     0.200
    23.365    -0.459     0.200
    23.557     2.855     0.200
    23.645     0.399     0.200
    23.645    -1.436     0.200
    23.790     3.632     0.200
    23.950    -0.087     0.200
    24.205     2.641     0.200
    24.173     0.629     0.200
    24.173    -0.200     0.200
    24.332     4.378     0.200
    24.329    -0.133     0.200
    24.407    -0.193     0.200
    24.456     3.748     0.200
    24.919     2.631     0.200
    25.010     4.103     0.200
    25.074     2.424     0.200
    25.094     2.238     0.200
    25.094     0.138     0.200
    25.439     2.108     0.200
    25.480    -0.675     0.200
    25.480     1.685     0.200
    25.480    -0.065     0.200
    25.584     0.713     0.200
    25.584    -0.213     0.200
    25.584    -0.156     0.200
    25.771     1.042     0.200
    25.771    -1.533     0.200
    26.329     5.043     0.200
    26.465     1.417     0.200
    27.751    -0.726     0.200
    27.751    -1.700     0.200
    27.704     0.479     0.200
    27.704    -0.821     0.200
    27.816     1.325     0.200
    29.734     0.327     0.200
    30.140     1.926     0.200
    30.483    -0.833     0.200
    30.483    -1.723     0.200
    30.864    -0.365     0.200
    30.884     0.559     0.200
    31.321    -1.493     0.200
    31.326    -0.539     0.200
    31.326    -0.537     0.200
    31.326    -1.438     0.200
    31.330    -1.554     0.200
    31.333    -1.309     0.200
    31.349    -2.235     0.200
    31.351    -1.259     0.200
    31.352    -1.776     0.200
    31.358    -1.065     0.200
    31.368    -1.473     0.200
    31.367    -1.625     0.200
    31.387    -2.433     0.200
    31.398    -1.323     0.200
    31.418    -1.619     0.200
    31.808     2.122     0.200
    31.937     0.689     0.200
    32.769     3.688     0.200
    33.956    -1.567     0.200
    33.944     0.645     0.200
    33.993    -0.281     0.200
    34.011    -0.034     0.200
    34.398    -0.988     0.200
    34.693    -1.433     0.200
    34.694    -1.113     0.200
    34.694    -1.450     0.200
    34.879    -0.607     0.200
    35.056     0.024     0.200
    35.056     0.800     0.200
    35.056    -0.375     0.200
    35.098    -0.661     0.200
    36.287    -0.547     0.200
    36.406     1.439     0.200
    36.516    -0.582     0.200
    36.867    -0.091     0.200
    37.059    -0.548     0.200
    37.059    -1.623     0.200
    37.952     0.239     0.200
    38.140     1.429     0.200
    38.242     1.170     0.200
    38.937     1.527     0.200
    39.303     0.319     0.200
    39.514     1.406     0.200
    39.514     0.106     0.200
    39.514    -1.284     0.200
    39.913     0.010     0.200
    40.141     0.800     0.200
    40.153     0.597     0.200
    40.319     0.821     0.200
    40.407     0.988     0.200
    40.527    -0.686     0.200
    40.490    -0.898     0.200
    40.659     1.089     0.200
    40.659     1.089     0.200
    40.659    -0.991     0.200
    40.931    -1.738     0.200
    40.926     0.505     0.200
    41.509    -0.969     0.200
    41.770     0.777     0.200
    42.894     0.322     0.200
    42.894    -0.203     0.200
    43.949    -2.585     0.200
    43.873    -0.977     0.200
    44.439     0.686     0.200
    44.810    -0.350     0.200
    44.810    -0.924     0.200
    44.810    -1.875     0.200
    44.897     0.327     0.200
    44.897    -0.167     0.200
    44.897    -0.427     0.200
    45.335    -0.558     0.200
    45.719     1.014     0.200
    46.159     0.636     0.200
    46.080     2.258     0.200
    46.080     0.658     0.200
    48.523     0.135     0.200
    50.823     0.618     0.200
    50.917    -0.090     0.200
    50.917     0.630     0.200
    50.917     0.635     0.200
    50.917    -0.290     0.200
    51.106    -0.409     0.200
    51.169    -0.212     0.200
    51.169    -1.587     0.200
    51.172    -0.232     0.200
    51.217    -0.149     0.200
    51.325    -3.258     0.200
    51.293    -1.977     0.200
    51.522    -0.928     0.200
    51.699     2.842     0.200
    51.929     0.326     0.200
    52.356    -0.644     0.200
    52.356    -1.014     0.200
    52.410    -0.644     0.200
    52.525     1.058     0.200
    52.525    -0.272     0.200
    52.871    -0.857     0.200
    53.276     1.636     0.200
    53.609     1.667     0.200
    53.741     2.593     0.200
    53.876     1.193     0.200
    53.876    -0.402     0.200
    53.876    -0.142     0.200
    53.876    -0.542     0.200
    53.878    -0.161     0.200
    53.911     1.322     0.200
    53.911    -1.054     0.200
    53.911    -1.398     0.200
    54.151     0.839     0.200
    54.270     1.711     0.200
    54.409     1.866     0.200
    55.066     0.028     0.200
    55.066     0.503     0.200
    55.066    -0.457     0.200
    55.533    -0.260     0.200
    55.620     0.111     0.200
    55.677    -0.149     0.200
    56.810    -0.187     0.200
    56.810    -0.287     0.200
    56.950     0.246     0.200
    57.115    -1.042     0.200
    60.239    -0.294     0.200
    60.652     0.386     0.200
    60.652     0.424     0.200
    60.724    -0.004     0.200
    60.724    -0.574     0.200
    61.027    -0.226     0.200
    61.917    -1.368     0.200
    63.892    -0.469     0.200
    64.658    -1.738     0.200
    64.818     1.168     0.200
    64.818    -0.422     0.200
    64.818    -0.732     0.200
    65.608    -0.506     0.200
    65.608    -0.366     0.200
    67.094    -0.403     0.200
    67.274     0.231     0.200
    68.341    -1.946     0.200
    68.258    -1.003     0.200
    68.258    -0.571     0.200
    68.402    -0.532     0.200
    68.402    -0.381     0.200
    69.013    -1.780     0.200
    69.067    -1.465     0.200
    69.310    -1.754     0.200
    69.611    -1.010     0.200
    73.533    -1.265     0.200
    74.567    -1.359     0.200
    75.337    -0.605     0.200
    75.341    -0.031     0.200
    75.341    -1.752     0.200
    75.397    -0.252     0.200
    75.794    -2.028     0.200
    75.954     0.058     0.200
    76.274    -0.360     0.200
    76.603    -0.927     0.200
    76.603     0.973     0.200
    76.678    -0.902     0.200
    76.828     0.292     0.200
    76.828     0.604     0.200
    76.828    -0.916     0.200
    77.430    -1.481     0.200
    77.483     0.625     0.200
    78.116    -0.709     0.200
    78.158    -1.231     0.200
    78.212     1.366     0.200
    78.467     0.260     0.200
    78.517     0.881     0.200
    78.699    -1.168     0.200
    78.966    -1.686     0.200
    79.037    -1.678     0.200
    79.139    -1.037     0.200
    79.244    -1.002     0.200
    79.334    -1.441     0.200
    79.348    -0.900     0.200
    79.377    -0.626     0.200
    79.560    -0.872     0.200
    79.788     0.590     0.200
    79.792    -1.993     0.200
    80.048    -1.307     0.200
    80.067    -0.982     0.200
    80.085     0.923     0.200
    80.146    -1.407     0.200
    80.157    -1.268     0.200
    80.206    -1.430     0.200
    80.237    -0.690     0.200
    80.424    -2.004     0.200
    80.498    -0.962     0.200
    80.516    -1.420     0.200
    80.552    -0.793     0.200
    80.581    -1.950     0.200
    80.612    -1.486     0.200
    80.891    -0.707     0.200
    80.991    -0.839     0.200
    80.996    -1.026     0.200
    80.996    -2.706     0.200
    80.999    -1.763     0.200
    80.999    -2.283     0.200
    80.999    -2.083     0.200
    81.169    -2.287     0.200
    81.289     0.077     0.200
    81.596     0.550     0.200
    81.601     0.523     0.200
    81.897    -0.038     0.200
    81.973    -0.909     0.200
    82.285    -0.174     0.200
    82.329    -0.931     0.200
    82.564    -1.639     0.200
    83.083    -0.986     0.200
    83.089    -0.556     0.200
    83.110    -0.862     0.200
    83.244     0.211     0.200
    83.260    -1.469     0.200
    83.422    -2.023     0.200
    83.456    -0.847     0.200
    83.782    -2.111     0.200
    83.779    -0.353     0.200
    83.779    -0.354     0.200
    83.851    -1.175     0.200
    83.881    -0.426     0.200
    83.881    -0.426     0.200
    83.881    -0.426     0.200
    83.881    -0.727     0.200
    83.954    -0.361     0.200
    84.041    -0.446     0.200
    84.261    -1.161     0.200
    84.478    -0.863     0.200
    84.507    -0.509     0.200
    84.507    -0.126     0.200
    84.524    -1.216     0.200
    84.613    -2.547     0.200
    84.775    -0.735     0.200
    84.782    -1.900     0.200
    84.954    -0.014     0.200
    84.954    -1.032     0.200
    85.077    -1.079     0.200
    85.123    -1.510     0.200
    85.123    -1.510     0.200
    85.340    -2.422     0.200
    85.340    -1.398     0.200
    85.340    -0.797     0.200
    85.351    -0.652     0.200
    85.377    -0.880     0.200
    85.539    -1.588     0.200
    85.684    -0.486     0.200
    85.684    -1.211     0.200
    85.819    -1.591     0.200
    86.127    -3.204     0.200
    86.147    -0.802     0.200
    86.349    -0.497     0.200
    86.429     1.708     0.200
    86.566     0.639     0.200
    86.573    -1.099     0.200
    86.676     1.474     0.200
    86.676     2.517     0.200
    86.676    -1.201     0.200
    86.846    -0.734     0.200
    87.039    -0.476     0.200
    87.113    -1.432     0.200
    87.111    -0.763     0.200
    87.216    -0.235     0.200
    87.238    -0.143     0.200
    87.798    -0.593     0.200
    87.876     0.394     0.200
    87.933     0.226     0.200
    88.076    -0.288     0.200
    88.286     0.252     0.200
    88.491    -0.418     0.200
    88.491    -0.768     0.200
    88.521    -0.158     0.200
    88.521    -0.487     0.200
    88.525    -0.709     0.200
    88.686    -1.635     0.200
    88.782    -1.290     0.200
    89.292    -0.141     0.200
    89.369    -0.776     0.200
    89.416    -0.565     0.200
    89.894    -0.754     0.200
    89.992    -0.022     0.200
    90.375     0.152     0.200
    90.694    -0.031     0.200
    91.377    -1.001     0.200
    91.654    -0.985     0.200
    92.069    -2.906     0.200
    92.075    -2.034     0.200
    92.075    -1.709     0.200
    92.423     2.560     0.200
    93.241     1.683     0.200
    93.388    -1.382     0.200
    93.774     1.130     0.200
    93.809     1.068     0.200
    93.936    -1.288     0.200
    93.936    -1.093     0.200
    94.256     1.015     0.200
    94.489    -1.088     0.200
    94.626    -1.200     0.200
    95.014    -0.060     0.200
    95.240    -0.096     0.200
    95.240    -0.991     0.200
    95.240    -0.102     0.200
    95.484    -0.607     0.200
    95.514    -0.541     0.200
    95.514    -1.041     0.200
    95.523    -0.202     0.200
    96.385    -1.104     0.200
    97.038    -1.001     0.200
    97.679    -1.140     0.200
    97.696    -0.388     0.200
    98.059    -0.364     0.200
    15.336     4.517     0.200
    15.757     8.142     0.200
    15.907     8.105     0.200
    16.327     2.405     0.200
    18.431    -1.169     0.200
    18.826     0.061     0.200
    19.467    -2.337     0.200
    20.495     1.654     0.200
    20.639    -0.418     0.200
    20.714     0.200     0.200
    20.714     0.775     0.200
    21.140     4.880     0.200
    21.307     0.376     0.200
    21.506     0.253     0.200
    21.521     4.878     0.200
    21.970     2.259     0.200
    22.130     3.249     0.200
    22.115     2.512     0.200
    22.405    -1.910     0.200
    22.460     3.435     0.200
    22.603     2.817     0.200
    22.688     3.211     0.200
    22.929     4.860     0.200
    22.929     1.480     0.200
    23.211     2.335     0.200
    23.254     1.833     0.200
    23.352    -0.159     0.200
    23.337     1.957     0.200
    23.337    -0.323     0.200
    23.636    -1.080     0.200
    23.529     0.545     0.200
    24.036     2.230     0.200
    24.036    -0.185     0.200
    24.033     3.228     0.200
    24.052     3.560     0.200
    24.462     2.610     0.200
    24.400    -0.677     0.200
    24.675     3.174     0.200
    24.675    -0.266     0.200
    24.680     4.626     0.200
    24.843     4.545     0.200
    25.235     5.378     0.200
    25.245     2.790     0.200
    25.245    -0.010     0.200
    25.338     4.440     0.200
    25.794    -0.799     0.200
    25.706     3.605     0.200
    25.691     1.552     0.200
    25.691     1.558     0.200
    25.691    -0.678     0.200
    25.853     0.667     0.200
    25.853     0.767     0.200
    25.790     0.242     0.200
    25.853     0.783     0.200
    26.137    -2.219     0.200
    26.543     5.226     0.200
    26.733     1.312     0.200
    27.808    -0.964     0.200
    27.808    -0.659     0.200
    27.711    -0.070     0.200
    27.711     0.280     0.200
    27.756     0.024     0.200
    27.756    -0.776     0.200
    29.561     0.869     0.200
    29.561    -0.830     0.200
    29.985    -3.089     0.200
    29.985    -1.388     0.200
    30.376    -1.758     0.200
    30.843    -1.166     0.200
    30.862     1.660     0.200
    31.306    -3.148     0.200
    31.306    -1.468     0.200
    31.311    -1.795     0.200
    31.311    -1.794     0.200
    31.311    -2.194     0.200
    31.315    -1.289     0.200
    31.337    -1.780     0.200
    31.454    -0.797     0.200
    31.880     2.097     0.200
    32.775     3.945     0.200
    33.860     3.881     0.200
    34.192     0.197     0.200
    34.691    -1.505     0.200
    34.692    -1.082     0.200
    34.692    -1.432     0.200
    34.936     0.859     0.200
    34.992    -0.061     0.200
    36.447    -0.707     0.200
    36.480     1.107     0.200
    36.965    -0.546     0.200
    36.965    -1.021     0.200
    38.319     1.415     0.200
    38.424     1.130     0.200
    39.424    -1.415     0.200
    39.459     0.062     0.200
    39.459    -0.718     0.200
    39.695     0.997     0.200
    39.803     0.296     0.200
    39.803    -0.805     0.200
    40.037     0.955     0.200
    40.323     0.584     0.200
    40.335     0.582     0.200
    40.575    -0.807     0.200
    40.497     2.612     0.200
    40.497    -0.257     0.200
    40.500     0.514     0.200
    40.590     1.073     0.200
    40.668     0.645     0.200
    40.668     0.645     0.200
    40.668    -1.375     0.200
    41.107     0.006     0.200
    41.951    -0.010     0.200
    43.854    -1.385     0.200
    43.954    -1.623     0.200
    44.784    -0.282     0.200
    44.784    -1.082     0.200
    44.670     1.126     0.200
    44.905     3.324     0.200
    44.905    -1.725     0.200
    46.174     3.207     0.200
    46.174    -0.293     0.200
    48.059    -1.410     0.200
    48.480    -0.161     0.200
    51.001     0.450     0.200
    51.008    -0.505     0.200
    51.008     0.745     0.200
    51.008     0.745     0.200
    51.008    -0.646     0.200
    51.198    -0.229     0.200
    51.198     0.161     0.200
    51.337     0.624     0.200
    51.417    -0.508     0.200
    51.837     4.083     0.200
    52.008    -0.588     0.200
    52.098    -0.559     0.200
    52.366     1.630     0.200
    52.366    -2.170     0.200
    52.266    -0.136     0.200
    52.538     0.869     0.200
    52.994     0.497     0.200
    53.398     1.025     0.200
    53.398     1.265     0.200
    53.734     1.851     0.200
    53.929    -1.103     0.200
    53.929    -0.988     0.200
    53.929    -1.443     0.200
    53.931    -1.013     0.200
    54.009    -0.952     0.200
    54.036     3.573     0.200
    54.036     1.153     0.200
    54.036     2.223     0.200
    54.036     0.312     0.200
    54.613     0.092     0.200
    55.146     0.432     0.200
    55.146    -0.412     0.200
    55.701    -0.907     0.200
    55.762    -0.146     0.200
    55.825    -0.794     0.200
    56.602     0.168     0.200
    56.939     0.164     0.200
    56.939    -0.756     0.200
    56.939    -0.636     0.200
    56.939    -1.606     0.200
    57.252    -1.356     0.200
    57.634     1.552     0.200
    60.806     0.261     0.200
    60.806    -0.609     0.200
    60.806    -0.829     0.200
    61.201    -0.770     0.200
    61.834    -0.460     0.200
    61.834    -1.299     0.200
    63.327    -3.078     0.200
    63.880    -0.993     0.200
    64.514     0.152     0.200
    64.979     0.917     0.200
    64.979    -0.463     0.200
    64.979    -0.742     0.200
    65.718    -0.772     0.200
    65.718    -1.252     0.200
    65.718    -0.642     0.200
    67.349    -0.198     0.200
    68.258    -0.497     0.200
    68.315    -1.145     0.200
    68.336    -1.199     0.200
    68.336    -0.619     0.200
    68.336    -0.869     0.200
    73.605     0.890     0.200
    74.709    -0.051     0.200
    75.485    -1.525     0.200
    75.496     3.115     0.200
    75.496    -0.888     0.200
    75.496    -1.498     0.200
    76.098     0.169     0.200
    76.315     0.138     0.200
    76.423    -1.879     0.200
    76.454     0.849     0.200
    76.756    -1.059     0.200
    76.818     1.137     0.200
    76.967     2.020     0.200
    76.967     0.850     0.200
    76.967    -0.030     0.200
    77.643     4.156     0.200
    78.676     3.533     0.200
    80.402    -0.265     0.200
    80.514     1.236     0.200
    80.687     0.809     0.200
    80.815    -1.779     0.200
    80.820    -0.703     0.200
    81.443     0.482     0.200
    81.791    -2.146     0.200
    82.046     2.799     0.200
    82.733     1.511     0.200
    83.237    -0.824     0.200
    83.799    -0.112     0.200
    83.799    -0.117     0.200
    83.988    -0.513     0.200
    84.034    -0.132     0.200
    84.034    -0.137     0.200
    84.426     0.614     0.200
    84.508     1.203     0.200
    84.644    -1.184     0.200
    84.763    -2.254     0.200
    84.771    -0.925     0.200
    84.947    -0.980     0.200
    84.949    -1.422     0.200
    85.181    -1.285     0.200
    85.181    -1.310     0.200
    85.449     0.977     0.200
    85.447    -0.391     0.200
    85.447    -0.266     0.200
    85.521     0.468     0.200
    85.521    -1.582     0.200
    86.466     0.187     0.200
    86.937     1.114     0.200
    88.618     1.583     0.200
    88.638    -0.861     0.200
    90.291     0.456     0.200
    91.364    -0.421     0.200
    91.364    -0.423     0.200
    92.125     0.536     0.200
    92.125     0.536     0.200
    31.393    -1.284     0.200
    31.393    -1.278     0.200
    31.532    -3.062     0.200
    34.785    -0.258     0.200
    40.584     1.330     0.200
    40.584     1.335     0.200
    50.996    -0.831     0.200
    50.996     0.799     0.200
    50.996     0.802     0.200
    50.996     0.489     0.200
    51.367    -3.104     0.200
    53.882    -0.264     0.200
    55.124    -1.144     0.200
    55.800    -0.234     0.200
    56.963    -0.572     0.200
    56.963     0.369     0.200
    60.785    -0.974     0.200
    63.778    -0.782     0.200
    65.724    -0.697     0.200
    67.202    -0.058     0.200
    85.138    -0.462     0.200
    85.138    -0.465     0.200
    85.450    -0.345     0.200
    15.426     4.757     0.200
    18.508    -1.019     0.200
    19.535     0.028     0.200
    19.535    -2.182     0.200
    19.986     0.112     0.200
    20.306     0.024     0.200
    20.605     1.186     0.200
    20.741    -0.387     0.200
    22.428     4.203     0.200
    22.439    -0.002     0.200
    22.797    -0.311     0.200
    23.321     1.887     0.200
    23.321     0.862     0.200
    23.395     3.377     0.200
    23.395     0.037     0.200
    23.450     0.667     0.200
    24.572    -0.034     0.200
    24.623     4.295     0.200
    24.779     0.623     0.200
    25.170     5.119     0.200
    25.743     0.057     0.200
    25.743     2.667     0.200
    25.743     2.307     0.200
    25.811     1.400     0.200
    25.953     0.942     0.200
    25.952     0.883     0.200
    27.632     0.590     0.200
    27.689     0.079     0.200
    27.872     1.241     0.200
    27.954    -4.008     0.200
    31.349    -1.164     0.200
    31.349    -1.166     0.200
    31.866     1.576     0.200
    32.735     2.157     0.200
    34.229     0.477     0.200
    34.734    -0.549     0.200
    34.735    -0.553     0.200
    34.735    -1.256     0.200
    34.853     0.280     0.200
    34.853    -2.303     0.200
    36.467     1.081     0.200
    36.472    -0.754     0.200
    39.396    -2.371     0.200
    39.723    -0.196     0.200
    40.636    -1.679     0.200
    40.629     0.435     0.200
    40.629     0.435     0.200
    40.629     0.134     0.200
    44.817    -0.432     0.200
    44.735     1.777     0.200
    46.168     1.417     0.200
    51.002     0.863     0.200
    51.002     0.483     0.200
    51.002     0.480     0.200
    51.002     0.364     0.200
    51.192     0.278     0.200
    51.852     1.246     0.200
    52.128     0.963     0.200
    52.549     1.435     0.200
    53.906    -0.325     0.200
    53.906    -1.155     0.200
    53.909    -0.344     0.200
    54.045    -0.967     0.200
    55.135     0.213     0.200
    55.136     0.037     0.200
    55.731    -1.133     0.200
    55.779    -0.090     0.200
    55.844     0.783     0.200
    56.949     0.368     0.200
    56.949    -0.082     0.200
    56.949     0.368     0.200
    60.796    -1.468     0.200
    61.762    -1.343     0.200
    63.833    -0.697     0.200
    65.005     0.609     0.200
    65.005     1.103     0.200
    65.005    -0.387     0.200
    65.720    -1.021     0.200
    67.201    -0.299     0.200
    68.324    -0.939     0.200
    68.324    -1.957     0.200
    73.591    -0.837     0.200
    76.834    -0.359     0.200
    80.720    -1.849     0.200
    82.398     0.939     0.200
    83.764    -0.896     0.200
    83.764    -0.896     0.200
    84.056     1.471     0.200
    84.057     1.474     0.200
    85.161    -0.767     0.200
    85.161    -0.769     0.200
    85.448    -0.592     0.200
    85.448     0.379     0.200
    85.448    -0.591     0.200
    92.101    -1.445     0.200
    92.101    -1.445     0.200
    92.101    -1.445     0.200
    15.263     3.393     0.200
    15.408     5.713     0.200
    15.845     3.208     0.200
    17.321     2.368     0.200
    17.548     2.567     0.200
    18.800    -1.927     0.200
    18.872    -0.607     0.200
    19.522     0.009     0.200
    19.826    -0.566     0.200
    20.312     0.047     0.200
    20.692    -2.370     0.200
    20.720     0.030     0.200
    21.225     2.175     0.200
    21.558     0.694     0.200
    21.592     1.723     0.200
    21.592    -0.007     0.200
    21.604    -1.290     0.200
    21.805     2.747     0.200
    22.065    -0.792     0.200
    22.216     0.954     0.200
    22.216     1.384     0.200
    22.434     2.430     0.200
    22.562     1.575     0.200
    22.775     0.512     0.200
    23.016     1.510     0.200
    23.299     1.513     0.200
    23.299     4.488     0.200
    23.383     1.499     0.200
    23.383    -0.141     0.200
    23.430     1.810     0.200
    23.430    -0.020     0.200
    23.669    -0.353     0.200
    23.605    -1.021     0.200
    23.684     0.695     0.200
    23.684     0.525     0.200
    24.388    -1.351     0.200
    24.758    -0.208     0.200
    24.758    -1.409     0.200
    24.927     0.551     0.200
    25.122     3.180     0.200
    25.160     1.536     0.200
    25.266     1.878     0.200
    25.261     1.918     0.200
    25.261    -0.082     0.200
    25.283     3.916     0.200
    25.424     0.640     0.200
    25.450     2.498     0.200
    25.732     1.494     0.200
    25.790    -0.380     0.200
    25.830    -1.947     0.200
    25.933     1.176     0.200
    25.933    -0.173     0.200
    25.932    -0.148     0.200
    26.538    -0.343     0.200
    26.587     3.415     0.200
    26.811     0.191     0.200
    27.647    -2.021     0.200
    27.647     0.729     0.200
    27.738     0.268     0.200
    27.738    -1.331     0.200
    27.860     1.006     0.200
    27.860    -0.929     0.200
    28.147     0.817     0.200
    29.483     1.649     0.200
    29.482     1.620     0.200
    29.482    -1.150     0.200
    29.968    -1.548     0.200
    29.968    -0.497     0.200
    30.377     0.083     0.200
    30.802    -0.919     0.200
    30.822     0.307     0.200
    31.336    -1.232     0.200
    31.342    -1.458     0.200
    31.342    -1.458     0.200
    31.809     1.112     0.200
    31.869     1.987     0.200
    32.742     2.721     0.200
    33.802     1.477     0.200
    34.221     0.252     0.200
    34.221    -0.561     0.200
    34.726    -0.164     0.200
    34.727    -0.349     0.200
    34.727    -0.041     0.200
    34.869    -0.572     0.200
    34.869     0.672     0.200
    34.869    -1.772     0.200
    34.928    -0.769     0.200
    36.145    -1.334     0.200
    36.466    -0.580     0.200
    36.469     1.598     0.200
    36.969    -2.265     0.200
    38.347     1.579     0.200
    38.454     1.384     0.200
    39.150     1.742     0.200
    39.409    -0.114     0.200
    39.409    -0.334     0.200
    39.739     0.386     0.200
    39.739    -0.463     0.200
    39.723     1.665     0.200
    40.352     0.948     0.200
    40.364     0.845     0.200
    40.464     0.599     0.200
    40.529     0.982     0.200
    40.625    -0.789     0.200
    40.619     1.037     0.200
    40.636     0.913     0.200
    40.636     0.913     0.200
    40.636    -1.307     0.200
    41.136     0.676     0.200
    41.979     1.066     0.200
    43.801    -0.604     0.200
    43.856    -1.340     0.200
    43.991    -0.778     0.200
    44.721     1.529     0.200
    44.811     0.114     0.200
    44.811    -1.286     0.200
    45.706     1.208     0.200
    46.169     2.659     0.200
    48.070     0.138     0.200
    48.433     0.322     0.200
    51.003     0.156     0.200
    51.003     1.011     0.200
    51.003     1.011     0.200
    51.003    -0.790     0.200
    51.192    -0.864     0.200
    51.424    -1.500     0.200
    51.849     2.825     0.200
    52.014    -1.006     0.200
    52.121    -0.906     0.200
    52.206    -0.734     0.200
    52.206    -1.245     0.200
    52.346    -0.248     0.200
    52.546    -0.861     0.200
    52.698     2.004     0.200
    53.001    -1.019     0.200
    53.312     2.227     0.200
    53.404     1.014     0.200
    53.404     1.464     0.200
    53.740     1.585     0.200
    53.876     2.336     0.200
    53.910    -1.569     0.200
    53.910     0.127     0.200
    53.910    -0.199     0.200
    53.910    -0.899     0.200
    53.913     0.102     0.200
    54.005     0.987     0.200
    54.015    -1.167     0.200
    54.043     1.369     0.200
    54.043     1.632     0.200
    54.043     0.235     0.200
    54.043    -0.855     0.200
    54.279     1.015     0.200
    54.407     2.003     0.200
    54.542     1.655     0.200
    54.623    -1.047     0.200
    55.137     0.908     0.200
    55.137    -0.211     0.200
    55.137    -0.432     0.200
    55.138     0.583     0.200
    55.724    -1.139     0.200
    55.775    -0.704     0.200
    55.840    -0.387     0.200
    56.947    -1.154     0.200
    56.947    -1.255     0.200
    57.632     0.003     0.200
    60.797     0.413     0.200
    60.797     0.094     0.200
    60.797    -1.396     0.200
    61.226    -1.646     0.200
    61.776    -1.175     0.200
    61.776    -1.634     0.200
    61.776    -2.924     0.200
    63.842    -0.290     0.200
    64.077     0.651     0.200
    64.441    -1.823     0.200
    64.441    -2.023     0.200
    64.826     0.594     0.200
    64.999     0.987     0.200
    64.999    -1.333     0.200
    64.999    -1.023     0.200
    65.719    -0.627     0.200
    65.719    -1.047     0.200
    65.719    -1.857     0.200
    65.751    -0.727     0.200
    65.755     0.820     0.200
    65.877     1.568     0.200
    65.898     0.753     0.200
    65.901     0.040     0.200
    65.968     0.164     0.200
    65.968     0.353     0.200
    66.252     0.291     0.200
    66.328     0.094     0.200
    66.632     0.224     0.200
    66.944     0.273     0.200
    67.200    -0.702     0.200
    67.338     0.327     0.200
    67.513    -1.232     0.200
    67.806    -1.760     0.200
    68.326    -0.900     0.200
    68.326    -2.000     0.200
    73.593    -0.150     0.200
    75.500    -1.545     0.200
    75.513     1.673     0.200
    75.652     0.358     0.200
    75.652    -1.115     0.200
    75.837    -2.277     0.200
    76.111    -1.340     0.200
    76.327    -0.064     0.200
    76.439    -0.899     0.200
    76.772    -1.585     0.200
    76.830     0.313     0.200
    76.972     1.249     0.200
    76.978     0.554     0.200
    76.978    -1.086     0.200
    77.539    -1.388     0.200
    77.862    -0.821     0.200
    79.075    -0.488     0.200
    79.145    -1.271     0.200
    79.239    -2.484     0.200
    79.507     0.726     0.200
    79.894    -1.547     0.200
    80.323    -1.662     0.200
    80.508    -2.558     0.200
    80.697    -0.970     0.200
    80.740    -1.212     0.200
    80.740    -0.988     0.200
    80.857     0.553     0.200
    81.710    -0.677     0.200
    82.390     1.336     0.200
    83.157    -0.799     0.200
    83.536     0.666     0.200
    83.536     0.666     0.200
    83.771    -0.627     0.200
    83.771    -0.629     0.200
    84.052     0.119     0.200
    84.052     0.617     0.200
    84.052    -0.901     0.200
    84.052     0.121     0.200
    84.052    -1.302     0.200
    84.374     0.558     0.200
    84.971    -0.421     0.200
    85.164    -1.021     0.200
    85.164    -1.068     0.200
    85.164    -2.120     0.200
    85.164    -2.441     0.200
    85.444    -0.518     0.200
    85.444    -1.319     0.200
    85.437    -0.980     0.200
    85.447    -1.174     0.200
    85.447    -1.434     0.200
    85.447    -1.844     0.200
    85.447    -1.335     0.200
    85.547    -0.340     0.200
    86.470    -1.660     0.200
    86.839    -2.221     0.200
    87.006     1.358     0.200
    87.006     1.835     0.200
    87.006    -0.816     0.200
    87.927    -1.542     0.200
    88.595    -1.612     0.200
    88.625     0.517     0.200
    88.625    -0.198     0.200
    88.642    -1.085     0.200
    88.642    -1.283     0.200
    91.346    -0.873     0.200
    91.346    -0.871     0.200
    92.105    -1.977     0.200
    92.105    -1.707     0.200
    92.105    -1.708     0.200
    95.615    -0.926     0.200
    95.615    -0.031     0.200
    95.615    -0.906     0.200
    25.716     1.559     0.200
    31.387    -0.989     0.200
    34.773    -1.215     0.200
    50.964     0.583     0.200
    53.868    -0.910     0.200
    22.443     3.528     0.200
    23.783     0.870     0.200
    25.811    -1.186     0.200
    25.811     1.794     0.200
    31.453    -0.647     0.200
    31.453    -0.646     0.200
    34.264     0.825     0.200
    34.847    -0.637     0.200
    34.848    -0.643     0.200
    44.116    -0.109     0.200
    50.956     0.430     0.200
    50.956     0.435     0.200
    50.956    -0.380     0.200
    51.424    -2.721     0.200
    54.027    -1.222     0.200
    55.081    -0.086     0.200
    56.934    -1.187     0.200
    60.742    -1.657     0.200
    67.446    -3.788     0.200
    84.063     1.815     0.200
    25.756    -0.690     0.200
    25.756     0.925     0.200
    25.756     0.201     0.200
    31.293    -1.298     0.200
    31.293    -1.291     0.200
    31.297    -2.731     0.200
    34.252     0.215     0.200
    34.677    -0.430     0.200
    34.677    -1.111     0.200
    40.574    -1.655     0.200
    42.895     0.595     0.200
    44.762    -0.154     0.200
    44.762    -2.004     0.200
    51.046    -0.164     0.200
    51.046    -0.164     0.200
    52.155     1.043     0.200
    52.586     0.973     0.200
    53.957     0.288     0.200
    53.957    -1.233     0.200
    53.960     0.267     0.200
    55.182    -0.575     0.200
    55.758    -0.649     0.200
    55.877     1.009     0.200
    56.986    -1.433     0.200
    56.986    -1.123     0.200
    60.842    -0.604     0.200
    65.034     2.180     0.200
    65.761     0.485     0.200
    65.761    -0.515     0.200
    85.211     1.304     0.200
    23.146     0.247     0.200
    23.254    -0.445     0.200
    25.571     1.379     0.200
    25.512    -0.340     0.200
    25.512     1.840     0.200
    25.512     0.810     0.200
    25.570     0.430     0.200
    25.699    -3.507     0.200
    27.678    -0.173     0.200
    27.770     0.778     0.200
    31.257    -1.064     0.200
    31.256    -1.058     0.200
    34.622     0.156     0.200
    34.623     0.149     0.200
    39.984     0.604     0.200
    40.729     1.493     0.200
    40.729     1.492     0.200
    40.729     0.313     0.200
    48.074    -1.442     0.200
    50.978     0.324     0.200
    50.978     1.354     0.200
    50.978     1.349     0.200
    50.978    -0.976     0.200
    51.167     0.245     0.200
    51.975    -1.098     0.200
    53.942     0.162     0.200
    53.945     0.146     0.200
    55.129     0.179     0.200
    55.578    -1.065     0.200
    55.728    -1.441     0.200
    56.865    -0.515     0.200
    56.865    -0.606     0.200
    60.787     0.336     0.200
    61.989    -1.135     0.200
    64.866     1.366     0.200
    64.866     0.003     0.200
    64.866    -0.547     0.200
    65.666    -0.478     0.200
    68.230    -2.615     0.200
    83.930    -0.585     0.200
    83.930    -0.495     0.200
    83.930    -0.582     0.200
    83.930    -0.726     0.200
    85.188    -2.058     0.200
    85.188    -2.060     0.200
    85.399    -1.090     0.200
    85.399    -1.090     0.200
    15.404     4.785     0.200
    15.601     4.139     0.200
    15.853     7.473     0.200
    15.846     2.566     0.200
    17.326     4.520     0.200
    18.485    -0.942     0.200
    18.658    -0.095     0.200
    18.892    -1.176     0.200
    19.512    -0.754     0.200
    19.512    -1.974     0.200
    20.293    -0.262     0.200
    20.672     0.772     0.200
    20.672    -0.978     0.200
    20.591     1.308     0.200
    20.720    -1.777     0.200
    21.227     4.429     0.200
    21.271    -1.929     0.200
    21.596    -0.302     0.200
    21.824     2.821     0.200
    22.057     3.026     0.200
    22.219     3.106     0.200
    22.219    -1.234     0.200
    22.208     2.515     0.200
    22.282     3.031     0.200
    22.300     1.141     0.200
    22.449     2.051     0.200
    22.574     1.724     0.200
    22.779     2.750     0.200
    23.026     4.347     0.200
    23.026     0.497     0.200
    23.304     2.965     0.200
    23.304     4.115     0.200
    23.277     2.597     0.200
    23.311     3.437     0.200
    23.402    -1.919     0.200
    23.445     1.438     0.200
    23.445    -0.491     0.200
    23.654    -2.073     0.200
    23.620     1.770     0.200
    23.620    -0.760     0.200
    23.689    -1.219     0.200
    23.896     3.552     0.200
    23.970    -1.856     0.200
    24.075     1.715     0.200
    24.109     1.602     0.200
    24.138     1.533     0.200
    24.180     1.653     0.200
    24.405    -0.784     0.200
    24.559     2.700     0.200
    24.629     1.358     0.200
    24.771     1.269     0.200
    24.771    -1.750     0.200
    24.805     0.957     0.200
    24.916     2.043     0.200
    24.939     4.536     0.200
    25.142     2.594     0.200
    25.179     1.551     0.200
    25.276     3.277     0.200
    25.280     2.234     0.200
    25.280     0.835     0.200
    25.302     3.235     0.200
    25.435     2.532     0.200
    25.467     1.939     0.200
    25.824    -2.756     0.200
    25.824    -3.201     0.200
    25.752     1.870     0.200
    25.752     1.158     0.200
    25.802     2.503     0.200
    25.850    -1.432     0.200
    25.947     1.139     0.200
    25.947    -0.811     0.200
    25.946    -0.814     0.200
    26.080    -0.508     0.200
    26.606     3.232     0.200
    26.826     0.350     0.200
    27.240    -1.479     0.200
    27.655    -2.196     0.200
    27.655     0.855     0.200
    27.712    -1.096     0.200
    27.754    -0.086     0.200
    27.754    -1.785     0.200
    27.849     0.581     0.200
    27.849     0.742     0.200
    27.972     3.376     0.200
    28.165     0.648     0.200
    28.804     0.462     0.200
    29.484     1.475     0.200
    29.484    -0.275     0.200
    29.484    -1.775     0.200
    29.484     1.475     0.200
    29.948    -0.885     0.200
    30.359    -0.384     0.200
    30.815    -0.739     0.200
    30.834     0.487     0.200
    31.322    -0.811     0.200
    31.322    -1.252     0.200
    31.327    -1.469     0.200
    31.327    -1.464     0.200
    31.331    -2.032     0.200
    31.530    -1.936     0.200
    31.819     1.119     0.200
    31.886     2.130     0.200
    32.757    -0.610     0.200
    33.811     1.393     0.200
    33.907    -0.445     0.200
    34.293     0.675     0.200
    34.240     1.382     0.200
    34.240    -1.238     0.200
    34.712    -1.211     0.200
    34.713    -0.378     0.200
    34.713    -1.228     0.200
    34.876     0.817     0.200
    34.876    -1.333     0.200
    34.935     0.451     0.200
    34.935    -1.549     0.200
    36.486     1.646     0.200
    36.486    -0.351     0.200
    36.952    -1.320     0.200
    38.367     1.209     0.200
    38.473     1.315     0.200
    39.170     1.473     0.200
    39.419     0.090     0.200
    39.486    -0.573     0.200
    39.746     0.023     0.200
    39.746     0.372     0.200
    39.743     1.597     0.200
    40.371     0.882     0.200
    40.384     0.678     0.200
    40.478     1.265     0.200
    40.478    -1.605     0.200
    40.613     0.413     0.200
    40.613    -0.933     0.200
    40.548     0.916     0.200
    40.651     1.089     0.200
    40.651     1.089     0.200
    40.651    -1.331     0.200
    40.638     1.071     0.200
    41.155     0.511     0.200
    41.676     2.188     0.200
    41.998     0.901     0.200
    42.191    -0.228     0.200
    43.063     1.125     0.200
    43.063    -1.750     0.200
    43.840    -1.222     0.200
    43.810    -0.078     0.200
    43.870     0.238     0.200
    43.977     0.047     0.200
    44.796     0.430     0.200
    44.796     0.131     0.200
    44.796    -2.070     0.200
    44.740     1.675     0.200
    44.886    -0.197     0.200
    44.886     1.479     0.200
    44.886     0.608     0.200
    44.886    -1.561     0.200
    45.346     1.945     0.200
    45.721     0.988     0.200
    46.116     1.242     0.200
    46.187     1.516     0.200
    46.187    -1.083     0.200
    48.053     1.317     0.200
    48.053    -0.682     0.200
    48.445     0.230     0.200
    50.933     1.429     0.200
    50.912     1.932     0.200
    50.915     1.907     0.200
    51.020     0.125     0.200
    51.020     0.006     0.200
    51.020     0.845     0.200
    51.020     0.850     0.200
    51.020     0.725     0.200
    51.022     0.116     0.200
    51.308     1.268     0.200
    51.308    -2.336     0.200
    51.360     0.674     0.200
    51.443    -0.332     0.200
    51.868     3.082     0.200
    52.033    -1.446     0.200
    52.141    -1.051     0.200
    52.214    -0.698     0.200
    52.214    -2.038     0.200
    52.565    -0.801     0.200
    52.717     1.894     0.200
    53.019    -1.157     0.200
    53.331     2.079     0.200
    53.422    -0.024     0.200
    53.422     1.106     0.200
    53.894     2.138     0.200
    53.927    -0.294     0.200
    53.929    -0.318     0.200
    54.024     0.640     0.200
    54.034    -1.604     0.200
    54.061     0.618     0.200
    54.061     1.964     0.200
    54.061     2.168     0.200
    54.061     0.498     0.200
    54.061     1.828     0.200
    54.061    -0.783     0.200
    54.297     1.258     0.200
    54.425     1.875     0.200
    54.561     1.429     0.200
    54.641    -1.074     0.200
    55.154     0.732     0.200
    55.154    -0.537     0.200
    55.154    -1.247     0.200
    55.155     0.332     0.200
    55.744    -1.679     0.200
    55.794    -1.241     0.200
    55.859    -1.415     0.200
    56.965     0.112     0.200
    56.965    -1.088     0.200
    56.965    -1.487     0.200
    56.965    -1.178     0.200
    57.283    -1.433     0.200
    57.650    -0.324     0.200
    60.743     0.266     0.200
    60.743     0.278     0.200
    60.815     0.495     0.200
    60.815    -0.224     0.200
    60.815    -1.214     0.200
    61.246    -1.667     0.200
    61.785    -1.435     0.200
    61.785    -1.094     0.200
    61.785    -2.023     0.200
    63.318     0.053     0.200
    63.632    -0.406     0.200
    63.855    -0.476     0.200
    64.096     0.624     0.200
    64.120     0.174     0.200
    64.263    -0.258     0.200
    64.445    -1.550     0.200
    64.845     0.439     0.200
    64.952    -0.001     0.200
    65.018     0.679     0.200
    65.571     1.300     0.200
    65.738    -0.843     0.200
    65.738    -1.134     0.200
    65.738    -1.493     0.200
    65.774     0.653     0.200
    65.897     0.480     0.200
    65.918     0.764     0.200
    65.920     0.338     0.200
    65.988     0.124     0.200
    66.271     0.434     0.200
    66.347     0.121     0.200
    66.651     0.495     0.200
    66.964    -0.325     0.200
    67.218    -0.164     0.200
    67.218    -0.914     0.200
    67.355     0.121     0.200
    68.249    -1.403     0.200
    68.344    -0.885     0.200
    68.344    -1.686     0.200
    68.930    -0.325     0.200
    68.946    -1.924     0.200
    69.162    -1.543     0.200
    74.741     0.635     0.200
    75.532     2.293     0.200
    75.532     1.873     0.200
    75.532    -0.688     0.200
    75.671     0.355     0.200
    75.671    -1.622     0.200
    75.854    -2.367     0.200
    76.131    -1.043     0.200
    76.458    -1.103     0.200
    76.849    -0.039     0.200
    76.997     1.021     0.200
    76.997     0.251     0.200
    76.997    -1.579     0.200
    77.557    -1.686     0.200
    77.863    -1.066     0.200
    78.359     0.556     0.200
    78.714     0.198     0.200
    78.983    -0.501     0.200
    79.093    -0.783     0.200
    79.162    -1.558     0.200
    79.257    -1.477     0.200
    79.895    -0.945     0.200
    79.942    -2.401     0.200
    79.890     0.679     0.200
    80.354    -1.295     0.200
    80.289     0.522     0.200
    80.526    -1.747     0.200
    80.741    -1.172     0.200
    80.741    -0.903     0.200
    80.716    -0.567     0.200
    81.237     0.452     0.200
    81.711    -1.026     0.200
    81.805     0.751     0.200
    82.081    -0.100     0.200
    82.481     0.305     0.200
    83.509    -1.257     0.200
    83.681    -1.569     0.200
    83.786    -0.516     0.200
    83.786    -0.520     0.200
    83.766    -0.836     0.200
    84.045    -0.464     0.200
    84.071    -0.163     0.200
    84.071    -0.158     0.200
    84.468    -1.210     0.200
    84.520    -0.472     0.200
    84.545    -0.398     0.200
    84.706    -2.321     0.200
    84.685    -0.109     0.200
    84.695     0.612     0.200
    84.695    -1.558     0.200
    84.990    -2.362     0.200
    84.991    -2.445     0.200
    85.181    -0.797     0.200
    85.181    -0.807     0.200
    85.181    -1.397     0.200
    85.447    -1.825     0.200
    85.465    -0.844     0.200
    85.547    -0.685     0.200
    85.545    -1.213     0.200
    85.617     1.529     0.200
    86.839    -0.655     0.200
    87.023     1.134     0.200
    87.023     1.396     0.200
    87.023     1.829     0.200
    87.049    -1.418     0.200
    88.173    -1.629     0.200
    88.387    -2.222     0.200
    88.592    -1.651     0.200
    88.644    -2.035     0.200
    88.661    -0.515     0.200
    88.661    -2.044     0.200
    88.665    -1.724     0.200
    88.909    -1.681     0.200
    90.311    -0.844     0.200
    90.764    -2.453     0.200
    92.122    -0.714     0.200
    92.122    -0.712     0.200
    92.251    -2.942     0.200
    92.399    -2.626     0.200
    93.582    -1.089     0.200
    94.616     3.775     0.200
    94.993    -1.043     0.200
    94.993    -1.047     0.200
    95.065     1.984     0.200
    95.580     3.435     0.200
    95.633    -0.431     0.200
    95.633    -0.431     0.200
    95.649     3.705     0.200
    98.184    -0.350     0.200
    27.816    -0.391     0.200
    30.398    -2.773     0.200
    31.325    -1.902     0.200
    31.326    -1.907     0.200
    34.705    -0.858     0.200
    44.799    -0.327     0.200
    50.988     1.135     0.200
    51.395    -3.471     0.200
    53.911     0.052     0.200
    53.913     0.034     0.200
    55.127     0.550     0.200
    15.251     4.531     0.200
    18.842    -0.263     0.200
    18.771    -0.126     0.200
    19.723     0.889     0.200
    19.848     1.120     0.200
    20.543     1.123     0.200
    20.742     0.438     0.200
    20.742    -0.886     0.200
    21.423     0.913     0.200
    22.178     3.576     0.200
    22.652     2.637     0.200
    23.108     2.505     0.200
    23.261    -0.241     0.200
    23.283     1.562     0.200
    23.283    -0.098     0.200
    23.439     0.131     0.200
    23.876    -1.781     0.200
    23.965     1.699     0.200
    24.414     0.505     0.200
    24.577     0.380     0.200
    25.077     1.665     0.200
    25.225     2.118     0.200
    25.606    -0.041     0.200
    25.642     1.140     0.200
    25.642     1.140     0.200
    25.642     1.038     0.200
    25.642    -0.411     0.200
    25.745    -0.070     0.200
    25.742     2.228     0.200
    25.760     0.819     0.200
    26.642    -0.609     0.200
    27.785     0.818     0.200
    27.748     1.205     0.200
    27.748     0.285     0.200
    27.785    -0.737     0.200
    27.778    -0.112     0.200
    27.778     0.787     0.200
    28.149     0.274     0.200
    30.911     1.091     0.200
    31.270    -4.478     0.200
    31.275    -1.232     0.200
    31.894     1.932     0.200
    32.814     2.163     0.200
    34.651    -0.274     0.200
    34.651    -0.624     0.200
    35.015    -1.096     0.200
    35.015    -0.162     0.200
    35.067     1.291     0.200
    36.493     1.854     0.200
    36.959     0.208     0.200
    38.286     1.750     0.200
    38.390     0.580     0.200
    39.879    -0.078     0.200
    39.879    -0.976     0.200
    40.004     0.888     0.200
    40.301     0.224     0.200
    40.556     0.418     0.200
    40.706     0.437     0.200
    41.876     0.162     0.200
    42.928     0.145     0.200
    43.930     0.813     0.200
    43.911    -2.355     0.200
    43.922     0.274     0.200
    44.752    -0.868     0.200
    44.752    -0.598     0.200
    44.943     1.615     0.200
    46.179     1.628     0.200
    48.536     0.679     0.200
    51.014     0.014     0.200
    51.014    -0.036     0.200
    51.014     0.315     0.200
    51.203     1.292     0.200
    51.824     3.752     0.200
    52.070     0.414     0.200
    52.336    -0.261     0.200
    52.389     0.104     0.200
    53.391     2.291     0.200
    53.950    -0.755     0.200
    53.992     0.689     0.200
    54.028     1.125     0.200
    54.028     1.779     0.200
    54.028    -0.350     0.200
    55.157    -0.521     0.200
    55.157     0.219     0.200
    55.674    -0.340     0.200
    55.747     1.233     0.200
    55.807    -1.668     0.200
    56.582    -0.487     0.200
    56.929    -0.400     0.200
    56.929    -0.701     0.200
    60.816     0.695     0.200
    60.816     1.334     0.200
    61.171    -1.176     0.200
    61.902    -2.096     0.200
    61.902    -1.455     0.200
    61.902    -0.594     0.200
    63.925    -1.192     0.200
    64.599    -1.734     0.200
    64.955     0.424     0.200
    65.717     0.562     0.200
    67.362     0.694     0.200
    68.348     0.083     0.200
    68.348    -0.086     0.200
    75.560    -1.177     0.200
    76.082     0.339     0.200
    76.405    -0.495     0.200
    76.804    -1.203     0.200
    76.953    -2.494     0.200
    79.073    -0.472     0.200
    80.521    -0.420     0.200
    80.914    -1.773     0.200
    82.327     1.295     0.200
    83.332    -0.201     0.200
    84.014    -0.787     0.200
    84.014     1.494     0.200
    85.447    -0.129     0.200
    95.113     1.285     0.200
    23.238     1.376     0.200
    23.417     0.596     0.200
    24.410    -0.263     0.200
    25.625     0.906     0.200
    25.625     0.906     0.200
    25.625    -0.655     0.200
    25.737     0.535     0.200
    25.736     0.535     0.200
    27.741     0.749     0.200
    34.650    -0.569     0.200
    40.707     0.607     0.200
    44.752     1.100     0.200
    51.008    -0.158     0.200
    51.008     0.572     0.200
    51.008     0.092     0.200
    53.947    -0.999     0.200
    55.152    -0.275     0.200
    55.152    -0.085     0.200
    55.796    -0.071     0.200
    56.920    -0.816     0.200
    56.920    -0.156     0.200
    56.920    -0.267     0.200
    60.739     0.363     0.200
    60.739     0.361     0.200
    61.911    -1.851     0.200
    63.928    -1.033     0.200
    64.943    -0.272     0.200
    65.709    -0.967     0.200
    84.002    -0.457     0.200
    84.002    -0.457     0.200
    84.002    -0.918     0.200
    85.440    -1.902     0.200
    19.681    -1.255     0.200
    23.608     0.608     0.200
    23.778     1.052     0.200
    25.810     0.254     0.200
    25.810    -0.170     0.200
    26.116    -0.429     0.200
    34.265    -0.223     0.200
    34.840    -0.126     0.200
    34.841    -0.134     0.200
    40.531    -1.068     0.200
    40.771    -1.489     0.200
    50.961     0.602     0.200
    50.961     0.602     0.200
    50.961     0.608     0.200
    50.961     0.352     0.200
    51.151    -0.337     0.200
    51.411    -1.236     0.200
    52.151     0.848     0.200
    52.537     1.278     0.200
    55.085     0.049     0.200
    55.087    -0.301     0.200
    55.848    -0.020     0.200
    56.937     0.229     0.200
    56.937    -0.191     0.200
    56.937     0.229     0.200
    60.675    -0.548     0.200
    60.675    -0.550     0.200
    14.615     3.808     0.200
    15.618     5.669     0.200
    15.814     5.571     0.200
    16.050     7.116     0.200
    20.158     0.570     0.200
    20.158     0.746     0.200
    20.787     1.023     0.200
    20.938     0.467     0.200
    21.443     5.549     0.200
    22.309     4.779     0.200
    22.337     3.078     0.200
    22.354     3.703     0.200
    22.405     1.457     0.200
    23.428     3.333     0.200
    23.435     0.047     0.200
    23.512     2.280     0.200
    23.582     0.635     0.200
    23.751     0.899     0.200
    24.249     1.474     0.200
    24.935     0.585     0.200
    25.235     2.494     0.200
    25.342     3.218     0.200
    25.576     2.097     0.200
    25.773     1.087     0.200
    25.773     0.816     0.200
    26.093     0.517     0.200
    26.092     0.523     0.200
    26.964     2.147     0.200
    27.451     0.793     0.200
    27.630     0.869     0.200
    28.037    -1.521     0.200
    28.079     1.057     0.200
    29.267    -2.507     0.200
    29.267    -2.518     0.200
    30.447    -1.904     0.200
    31.473    -1.409     0.200
    31.473    -0.569     0.200
    31.478    -1.480     0.200
    31.482    -1.140     0.200
    31.775     2.238     0.200
    32.603     2.371     0.200
    34.226    -0.084     0.200
    34.667    -2.417     0.200
    34.667    -2.177     0.200
    34.871    -1.086     0.200
    34.872    -0.924     0.200
    34.872    -0.814     0.200
    36.376     2.206     0.200
    37.049    -0.277     0.200
    37.049     0.973     0.200
    38.350     1.267     0.200
    38.460     0.943     0.200
    39.540    -0.577     0.200
    39.727     1.041     0.200
    40.068     0.809     0.200
    40.324    -0.518     0.200
    40.357     0.308     0.200
    40.370     0.305     0.200
    40.498     1.713     0.200
    40.498    -0.361     0.200
    40.533     0.251     0.200
    40.625     0.495     0.200
    40.797    -1.721     0.200
    41.140     0.544     0.200
    41.948     0.521     0.200
    41.983     0.336     0.200
    44.140    -0.736     0.200
    44.733     2.528     0.200
    44.940     0.730     0.200
    46.091     2.366     0.200
    50.923     1.036     0.200
    50.923     0.812     0.200
    50.923     0.617     0.200
    51.809     3.195     0.200
    52.015    -0.640     0.200
    53.801    -0.541     0.200
    53.801    -0.662     0.200
    53.991     0.424     0.200
    53.991     1.178     0.200
    53.991    -1.081     0.200
    54.579     0.129     0.200
    55.048     0.397     0.200
    55.048     0.086     0.200
    55.050     0.263     0.200
    55.715    -0.404     0.200
    55.740    -0.482     0.200
    55.809     0.348     0.200
    56.898    -0.448     0.200
    56.898    -0.348     0.200
    56.898    -0.158     0.200
    60.638     0.070     0.200
    60.710    -0.658     0.200
    60.710     0.114     0.200
    63.691    -0.344     0.200
    64.981     2.020     0.200
    65.655    -0.467     0.200
    67.132    -0.004     0.200
    67.244     0.060     0.200
    68.236    -1.493     0.200
    68.236    -1.183     0.200
    75.692     0.276     0.200
    75.733    -2.155     0.200
    76.792     0.751     0.200
    76.939    -1.404     0.200
    77.472    -0.394     0.200
    79.167    -0.673     0.200
    80.523    -0.933     0.200
    84.026    -0.739     0.200
    85.058    -1.183     0.200
    85.058    -1.201     0.200
    85.058     0.817     0.200
    85.380    -0.316     0.200
    87.129     0.815     0.200
    87.129     1.290     0.200
    87.129     1.040     0.200
    95.544     0.922     0.200
    23.309    -0.401     0.200
    25.520    -0.002     0.200
    27.756    -3.185     0.200
    27.756    -0.519     0.200
    29.706     1.080     0.200
    31.323    -0.500     0.200
    34.689    -1.444     0.200
    43.928    -1.747     0.200
    44.801     0.397     0.200
    50.937     0.697     0.200
    50.937    -0.817     0.200
    51.962     0.094     0.200
    53.889     0.041     0.200
    55.085     0.554     0.200
    55.084    -0.318     0.200
    56.837    -0.384     0.200
    56.837     0.446     0.200
    60.671     0.814     0.200
    64.850    -1.249     0.200
    80.971    -0.391     0.200
    83.911     0.365     0.200
    25.572     1.981     0.200
    25.572     1.463     0.200
    27.779     1.161     0.200
    27.779    -0.523     0.200
    31.322    -1.731     0.200
    31.322    -1.738     0.200
    34.696    -1.502     0.200
    34.696    -1.258     0.200
    34.999    -2.520     0.200
    36.356     1.764     0.200
    39.487    -1.722     0.200
    40.551     0.149     0.200
    43.954    -1.307     0.200
    50.955    -0.137     0.200
    50.955     0.353     0.200
    50.955    -0.198     0.200
    53.896    -0.081     0.200
    53.896    -0.851     0.200
    55.099    -0.134     0.200
    56.865     0.412     0.200
    56.865     0.262     0.200
    65.654    -1.094     0.200
    23.585     0.261     0.200
    25.734     1.863     0.200
    25.734    -0.066     0.200
    27.688    -0.596     0.200
    31.310    -1.217     0.200
    31.310    -1.216     0.200
    31.314    -1.481     0.200
    34.229     0.441     0.200
    34.693    -1.181     0.200
    34.694    -0.429     0.200
    34.694    -1.179     0.200
    34.910     0.815     0.200
    43.957    -1.046     0.200
    44.780     0.042     0.200
    44.780    -1.432     0.200
    51.026    -0.038     0.200
    51.026     0.682     0.200
    51.026    -0.328     0.200
    52.132     0.379     0.200
    55.162    -0.410     0.200
    55.162    -0.181     0.200
    55.735     0.221     0.200
    55.791     0.102     0.200
    55.855    -0.265     0.200
    56.964    -0.374     0.200
    56.964     0.376     0.200
    60.750    -0.362     0.200
    60.750    -0.364     0.200
    60.822    -0.162     0.200
    61.236     0.485     0.200
    63.614    -0.084     0.200
    63.876    -1.015     0.200
    65.011    -0.492     0.200
    65.011    -0.658     0.200
    65.740    -0.387     0.200
    75.653     0.027     0.200
    79.023     0.082     0.200
    83.198    -0.549     0.200
    85.485    -1.500     0.200
    85.468    -0.499     0.200
    23.763     1.734     0.200
    25.820     2.078     0.200
    31.404    -2.904     0.200
    31.408     0.091     0.200
    34.282     0.071     0.200
    34.798    -2.088     0.200
    36.510     0.671     0.200
    44.866    -0.112     0.200
    50.994    -0.286     0.200
    50.994    -0.282     0.200
    52.029    -0.530     0.200
    52.171     0.185     0.200
    55.120    -0.613     0.200
    55.873     0.121     0.200
    56.965    -0.533     0.200
    60.782    -1.399     0.200
    68.308     0.211     0.200
    73.571     0.719     0.200
    14.446     4.571     0.200
    14.764     3.944     0.200
    15.360     2.970     0.200
    15.448     4.189     0.200
    15.964     3.510     0.200
    16.122     4.166     0.200
    16.573     2.002     0.200
    17.291     3.669     0.200
    17.291     0.968     0.200
    17.653     5.064     0.200
    18.505    -0.798     0.200
    19.122    -0.813     0.200
    19.017     0.959     0.200
    20.567    -1.358     0.200
    20.790    -0.963     0.200
    21.281     1.082     0.200
    21.281    -0.389     0.200
    21.586     1.993     0.200
    21.641     4.203     0.200
    21.686    -0.372     0.200
    21.924     0.008     0.200
    21.744     2.303     0.200
    21.744     0.643     0.200
    21.944     2.962     0.200
    22.306    -0.041     0.200
    22.340     1.935     0.200
    22.426     0.524     0.200
    22.495     1.687     0.200
    22.595     0.819     0.200
    22.560    -0.239     0.200
    22.874     2.770     0.200
    23.142     5.236     0.200
    23.142     0.086     0.200
    23.364     1.501     0.200
    23.404     1.807     0.200
    23.620    -0.888     0.200
    23.620    -1.673     0.200
    23.527     0.883     0.200
    23.527    -0.406     0.200
    23.577     0.911     0.200
    23.577     0.020     0.200
    23.898    -0.949     0.200
    23.753     1.299     0.200
    23.753    -0.412     0.200
    23.931    -2.275     0.200
    23.931    -0.506     0.200
    24.122    -2.023     0.200
    24.187     1.640     0.200
    24.240     1.950     0.200
    24.273     2.254     0.200
    24.378     2.092     0.200
    24.470     0.613     0.200
    24.675     2.688     0.200
    24.757     1.144     0.200
    24.898     2.657     0.200
    24.898     0.356     0.200
    24.882     3.202     0.200
    25.050     1.269     0.200
    25.263     1.936     0.200
    25.299     1.212     0.200
    25.380     2.475     0.200
    25.395     4.936     0.200
    25.429     1.931     0.200
    25.806    -0.321     0.200
    25.806    -0.963     0.200
    25.962    -1.157     0.200
    25.874     1.472     0.200
    25.874     1.048     0.200
    25.967     1.651     0.200
    25.971     1.421     0.200
    25.971     0.214     0.200
    26.078     0.444     0.200
    26.078    -0.158     0.200
    26.078    -0.140     0.200
    26.526     2.101     0.200
    26.729     2.764     0.200
    26.972     0.374     0.200
    26.958     1.298     0.200
    27.634    -0.066     0.200
    27.848    -1.310     0.200
    27.918    -0.474     0.200
    27.812    -0.557     0.200
    27.812    -0.358     0.200
    28.245     0.472     0.200
    29.425    -0.816     0.200
    29.425    -1.046     0.200
    29.425    -2.003     0.200
    29.848    -0.565     0.200
    30.279    -1.531     0.200
    30.279    -1.877     0.200
    30.836    -0.098     0.200
    30.856     0.628     0.200
    31.285    -3.749     0.200
    31.285    -1.909     0.200
    31.290    -2.244     0.200
    31.554    -1.732     0.200
    31.814     0.090     0.200
    31.952     1.481     0.200
    32.792     3.114     0.200
    33.132     0.537     0.200
    33.062     3.946     0.200
    33.852    -1.117     0.200
    33.781     1.178     0.200
    33.801     0.510     0.200
    34.220    -0.837     0.200
    34.352     1.283     0.200
    34.352     0.424     0.200
    34.352     0.123     0.200
    34.682    -1.236     0.200
    34.847    -0.299     0.200
    34.947    -1.005     0.200
    34.913     0.868     0.200
    34.913     0.337     0.200
    36.620    -0.777     0.200
    36.553     1.098     0.200
    36.708    -0.758     0.200
    36.589     1.570     0.200
    36.589     2.347     0.200
    36.589     1.193     0.200
    36.878    -0.718     0.200
    36.878    -1.669     0.200
    37.655    -0.640     0.200
    38.477     0.996     0.200
    38.585     0.891     0.200
    39.282     1.151     0.200
    39.424    -0.033     0.200
    39.518    -0.646     0.200
    39.518    -1.175     0.200
    39.721    -0.237     0.200
    39.721     0.788     0.200
    39.854     1.187     0.200
    40.171    -0.946     0.200
    40.195     1.053     0.200
    40.607    -0.840     0.200
    40.607    -1.241     0.200
    40.513     2.556     0.200
    40.513     0.118     0.200
    40.483     0.370     0.200
    40.495     0.168     0.200
    40.687     0.940     0.200
    40.660     0.507     0.200
    40.750     0.459     0.200
    41.080    -0.365     0.200
    41.161    -1.106     0.200
    41.267     0.006     0.200
    41.701     0.710     0.200
    41.989    -0.411     0.200
    42.072     0.606     0.200
    42.109     0.403     0.200
    43.088     1.375     0.200
    43.088    -0.678     0.200
    43.088    -1.155     0.200
    43.040     0.476     0.200
    43.337    -0.257     0.200
    43.766    -1.051     0.200
    43.766    -1.580     0.200
    43.797     0.624     0.200
    43.950    -0.702     0.200
    43.950    -1.608     0.200
    43.908    -0.367     0.200
    44.753    -0.602     0.200
    44.922     1.763     0.200
    44.922     1.025     0.200
    44.922     0.506     0.200
    44.868     0.354     0.200
    45.311     0.428     0.200
    45.761     1.170     0.200
    46.063     0.055     0.200
    46.261     2.323     0.200
    46.261     0.624     0.200
    47.986     0.337     0.200
    47.986    -0.595     0.200
    48.456     1.237     0.200
    49.294    -0.058     0.200
    50.723    -0.648     0.200
    50.849     0.477     0.200
    51.197    -0.219     0.200
    51.197    -0.331     0.200
    51.264     0.772     0.200
    51.264    -0.722     0.200
    51.094     0.351     0.200
    51.094     0.527     0.200
    51.105     0.670     0.200
    51.284     0.425     0.200
    51.447     0.910     0.200
    51.531     1.101     0.200
    51.962     3.262     0.200
    52.225    -0.697     0.200
    52.225    -0.896     0.200
    52.200     0.584     0.200
    52.200     0.245     0.200
    52.120     0.881     0.200
    52.247     1.828     0.200
    52.247     0.440     0.200
    52.655     0.511     0.200
    53.107     1.272     0.200
    53.465    -2.656     0.200
    53.465     0.302     0.200
    53.510     0.311     0.200
    53.983    -0.682     0.200
    54.112     2.315     0.200
    54.150     2.445     0.200
    54.150     3.197     0.200
    54.150     2.627     0.200
    54.150     3.427     0.200
    54.150     1.537     0.200
    54.650     1.188     0.200
    55.223     0.158     0.200
    55.223    -0.162     0.200
    55.223    -0.352     0.200
    55.890     0.545     0.200
    55.957     0.316     0.200
    57.055    -0.156     0.200
    57.055    -0.355     0.200
    57.729     1.090     0.200
    60.885     0.081     0.200
    60.885    -0.637     0.200
    60.885    -0.128     0.200
    61.775    -2.358     0.200
    61.775    -1.067     0.200
    63.033     1.148     0.200
    63.755    -0.585     0.200
    63.881    -0.566     0.200
    64.402    -0.813     0.200
    64.402    -0.544     0.200
    64.219    -0.639     0.200
    64.999    -1.588     0.200
    64.968    -0.325     0.200
    65.076    -0.604     0.200
    65.122     0.820     0.200
    65.694    -0.047     0.200
    65.820    -0.722     0.200
    65.820     0.147     0.200
    65.894     0.364     0.200
    65.894     1.077     0.200
    65.976     0.048     0.200
    66.017     1.393     0.200
    66.038     1.275     0.200
    66.042     0.146     0.200
    66.042    -0.123     0.200
    66.109    -0.420     0.200
    66.109    -0.119     0.200
    66.393    -0.064     0.200
    66.467     1.824     0.200
    66.468    -0.391     0.200
    66.468    -0.126     0.200
    66.710     0.291     0.200
    66.710     1.012     0.200
    66.773     0.535     0.200
    67.311    -1.644     0.200
    67.299    -0.427     0.200
    67.372    -0.065     0.200
    67.421     0.949     0.200
    68.180    -0.614     0.200
    68.093     0.278     0.200
    68.347    -0.091     0.200
    68.411    -0.585     0.200
    68.500     0.352     0.200
    68.968    -0.122     0.200
    73.676     0.677     0.200
    74.836     0.313     0.200
    75.633     2.626     0.200
    75.793     0.152     0.200
    75.793    -0.592     0.200
    76.227    -2.762     0.200
    76.688    -0.616     0.200
    76.556     2.640     0.200
    76.816     1.202     0.200
    76.944     0.880     0.200
    77.091     2.718     0.200
    77.091     1.718     0.200
    77.091    -0.051     0.200
    77.091     2.318     0.200
    77.091     0.769     0.200
    77.118     2.202     0.200
    78.100     0.214     0.200
    78.100    -0.857     0.200
    79.256    -0.751     0.200
    79.962     0.512     0.200
    80.677    -1.841     0.200
    80.599    -0.143     0.200
    80.599     0.482     0.200
    80.599     0.042     0.200
    80.730     0.476     0.200
    80.808    -0.340     0.200
    81.239    -0.926     0.200
    82.231    -0.470     0.200
    83.474     1.781     0.200
    83.827    -1.582     0.200
    83.931     0.204     0.200
    84.105     0.670     0.200
    84.171     1.220     0.200
    84.171     0.562     0.200
    84.795     2.222     0.200
    84.795     0.351     0.200
    85.238    -0.443     0.200
    85.239    -1.129     0.200
    85.239    -0.078     0.200
    85.392    -1.242     0.200
    85.476    -0.381     0.200
    85.518     0.729     0.200
    85.546    -1.632     0.200
    85.546    -0.207     0.200
    85.690     1.778     0.200
    86.574     0.838     0.200
    86.874     0.245     0.200
    86.874     1.274     0.200
    87.157     0.915     0.200
    87.157     1.269     0.200
    87.157     1.935     0.200
    87.157     0.466     0.200
    87.231     1.377     0.200
    87.263     0.868     0.200
    87.286     1.230     0.200
    87.467     1.105     0.200
    87.524     0.985     0.200
    88.116     1.785     0.200
    88.172     1.053     0.200
    88.308     2.649     0.200
    88.459    -0.357     0.200
    88.459     0.082     0.200
    88.643    -1.684     0.200
    88.643    -1.960     0.200
    88.733     1.606     0.200
    88.746     1.050     0.200
    89.413     1.219     0.200
    89.698     0.621     0.200
    90.393     1.977     0.200
    90.604     0.846     0.200
    90.922     1.302     0.200
    91.336     1.112     0.200
    91.510    -0.209     0.200
    92.176    -0.592     0.200
    93.031     1.299     0.200
    93.250     4.452     0.200
    93.353     4.584     0.200
    93.976     1.512     0.200
    94.698     1.356     0.200
    94.934    -0.712     0.200
    94.809     0.676     0.200
    95.148     0.827     0.200
    95.193    -2.868     0.200
    95.663     1.278     0.200
    95.680    -0.592     0.200
    95.680    -0.153     0.200
    95.712     0.738     0.200
    95.730     1.419     0.200
    96.035    -0.146     0.200
    97.219    -1.074     0.200
    98.054     1.285     0.200
    15.010     8.074     0.200
    15.211     2.831     0.200
    15.424     2.646     0.200
    15.494     2.529     0.200
    15.534     3.210     0.200
    16.262     1.905     0.200
    16.471     2.441     0.200
    16.533     4.648     0.200
    17.023     5.068     0.200
    17.253     2.300     0.200
    17.500     3.226     0.200
    18.617    -0.610     0.200
    19.200    -0.959     0.200
    19.200    -0.668     0.200
    19.613     0.319     0.200
    19.858     0.251     0.200
    20.477     0.026     0.200
    20.878     0.619     0.200
    20.878     0.769     0.200
    21.012     2.522     0.200
    21.062     0.353     0.200
    21.062    -0.416     0.200
    21.143     1.709     0.200
    21.292     1.507     0.200
    21.277     3.869     0.200
    21.312     3.087     0.200
    21.312     0.027     0.200
    21.336     1.833     0.200
    21.336    -0.926     0.200
    21.786     1.904     0.200
    21.941     1.847     0.200
    22.002     3.093     0.200
    22.023     1.269     0.200
    22.392    -0.299     0.200
    22.422     1.612     0.200
    22.488     2.716     0.200
    22.608     3.342     0.200
    22.611     0.905     0.200
    22.698     3.286     0.200
    22.698     0.907     0.200
    22.975     3.251     0.200
    23.003     2.436     0.200
    22.980     2.206     0.200
    23.106     0.138     0.200
    23.140     1.817     0.200
    23.129     1.128     0.200
    23.129    -0.202     0.200
    23.134     1.576     0.200
    23.240     3.862     0.200
    23.283     0.434     0.200
    23.392     0.861     0.200
    23.584     2.363     0.200
    23.657    -1.185     0.200
    23.657    -1.445     0.200
    23.767     1.493     0.200
    23.810     1.304     0.200
    23.806     1.434     0.200
    23.875     2.407     0.200
    23.961    -1.381     0.200
    24.004     1.225     0.200
    24.231     1.553     0.200
    24.322    -0.510     0.200
    24.345     1.512     0.200
    24.431     1.424     0.200
    24.431     0.805     0.200
    24.483     0.858     0.200
    24.512    -1.789     0.200
    24.584     0.331     0.200
    24.602     0.774     0.200
    24.592     1.460     0.200
    24.882     1.817     0.200
    24.944     1.260     0.200
    24.928     1.003     0.200
    24.997    -0.229     0.200
    24.997    -0.528     0.200
    25.022     2.543     0.200
    25.099     1.945     0.200
    25.096     1.572     0.200
    25.096     0.671     0.200
    25.139     1.585     0.200
    25.464     0.235     0.200
    25.490     1.888     0.200
    25.490     1.146     0.200
    25.607     1.281     0.200
    25.587     1.114     0.200
    25.591     0.944     0.200
    25.591     0.177     0.200
    25.786    -0.890     0.200
    25.786    -0.775     0.200
    26.329    -0.524     0.200
    26.340     2.499     0.200
    26.488     0.066     0.200
    26.693     0.409     0.200
    26.682     2.112     0.200
    26.881    -0.385     0.200
    26.905     2.101     0.200
    26.905    -0.930     0.200
    26.978    -1.036     0.200
    26.981    -0.379     0.200
    27.125     1.021     0.200
    27.635     0.250     0.200
    27.768    -0.882     0.200
    27.768    -1.246     0.200
    27.768    -1.144     0.200
    27.695    -0.093     0.200
    27.795    -0.281     0.200
    27.795    -0.546     0.200
    28.041     0.121     0.200
    28.174     1.932     0.200
    28.197    -1.732     0.200
    29.708    -1.997     0.200
    29.708    -2.106     0.200
    29.708    -1.997     0.200
    29.708    -2.221     0.200
    29.708    -1.295     0.200
    30.137    -1.599     0.200
    30.137    -1.193     0.200
    30.486    -0.877     0.200
    30.486    -1.092     0.200
    30.473    -0.981     0.200
    30.849     0.121     0.200
    30.869     0.446     0.200
    30.995    -1.552     0.200
    30.995    -1.263     0.200
    31.333    -1.142     0.200
    31.333    -1.722     0.200
    31.338    -1.987     0.200
    31.342    -1.854     0.200
    31.389    -1.546     0.200
    31.496    -0.829     0.200
    31.802     2.133     0.200
    32.757     2.253     0.200
    33.316     0.566     0.200
    33.535     0.129     0.200
    33.964    -1.179     0.200
    33.924    -0.629     0.200
    33.971     0.566     0.200
    34.017     0.356     0.200
    34.017    -0.535     0.200
    34.357    -0.622     0.200
    34.402    -0.279     0.200
    34.706    -0.957     0.200
    34.896    -0.796     0.200
    35.033     0.920     0.200
    35.077     0.098     0.200
    35.077    -0.113     0.200
    36.291     2.138     0.200
    36.291    -0.122     0.200
    36.374    -0.535     0.200
    36.400     1.545     0.200
    36.538    -1.637     0.200
    36.844    -0.438     0.200
    37.063    -0.003     0.200
    37.063    -0.402     0.200
    37.927     0.003     0.200
    38.146     1.533     0.200
    38.248     1.370     0.200
    38.944     1.626     0.200
    39.325    -1.365     0.200
    39.497     0.207     0.200
    39.521     1.808     0.200
    39.863     1.658     0.200
    39.892     0.069     0.200
    39.892    -0.482     0.200
    40.147     1.001     0.200
    40.159     0.798     0.200
    40.325     0.923     0.200
    40.429    -0.133     0.200
    40.429    -0.463     0.200
    40.414     0.990     0.200
    40.544    -1.039     0.200
    40.544    -1.244     0.200
    40.478     1.131     0.200
    40.478     0.060     0.200
    40.647     0.745     0.200
    40.647    -0.835     0.200
    40.810    -0.580     0.200
    40.951    -1.476     0.200
    40.932     0.607     0.200
    40.982     0.495     0.200
    41.282    -0.975     0.200
    41.531    -1.442     0.200
    41.734     1.128     0.200
    41.776     1.080     0.200
    42.139     0.063     0.200
    42.188    -0.384     0.200
    42.582     1.695     0.200
    42.582     1.560     0.200
    42.582     0.107     0.200
    42.916    -1.024     0.200
    42.916    -1.561     0.200
    42.924     0.531     0.200
    43.498    -0.458     0.200
    43.832     4.501     0.200
    43.861    -0.327     0.200
    43.952    -0.941     0.200
    43.952    -1.101     0.200
    43.962    -0.846     0.200
    43.928    -0.664     0.200
    44.356     1.294     0.200
    44.452     0.332     0.200
    44.821    -0.507     0.200
    44.884     0.280     0.200
    44.884     0.655     0.200
    44.884     0.485     0.200
    44.884    -0.233     0.200
    45.348    -0.277     0.200
    45.367     0.047     0.200
    45.707     0.558     0.200
    46.168     0.220     0.200
    46.076     2.245     0.200
    46.076     0.745     0.200
    48.142     0.617     0.200
    48.142    -0.277     0.200
    48.506     0.418     0.200
    49.342    -0.573     0.200
    49.637    -0.110     0.200
    49.705     0.407     0.200
    49.833     0.563     0.200
    50.005    -0.396     0.200
    50.053    -0.486     0.200
    50.831     0.108     0.200
    50.885     0.501     0.200
    50.912     0.597     0.200
    50.912    -0.083     0.200
    50.912     0.921     0.200
    50.912    -0.364     0.200
    51.101    -0.025     0.200
    51.103     1.034     0.200
    51.144     0.183     0.200
    51.336     0.612     0.200
    51.336    -0.183     0.200
    51.496    -0.383     0.200
    51.496    -0.234     0.200
    51.466     1.239     0.200
    51.496     0.389     0.200
    51.700     2.790     0.200
    51.934     1.060     0.200
    51.934     0.446     0.200
    52.335    -1.139     0.200
    52.335    -0.729     0.200
    52.351     0.676     0.200
    52.407     1.291     0.200
    52.522     0.837     0.200
    52.522    -0.022     0.200
    52.520    -0.209     0.200
    52.520     0.391     0.200
    52.567     1.315     0.200
    52.742     0.249     0.200
    53.178     2.183     0.200
    53.184     0.750     0.200
    53.275     0.717     0.200
    53.275     1.088     0.200
    53.466    -0.289     0.200
    53.595    -0.131     0.200
    53.609     1.326     0.200
    53.699    -0.325     0.200
    53.699    -0.595     0.200
    53.699    -1.165     0.200
    53.740     2.069     0.200
    53.867    -0.847     0.200
    53.867    -0.203     0.200
    53.867    -0.927     0.200
    53.875     0.822     0.200
    53.910     1.380     0.200
    53.910     1.140     0.200
    53.910     1.630     0.200
    53.910     0.960     0.200
    53.910     0.181     0.200
    54.135     0.087     0.200
    54.150     0.969     0.200
    54.270     2.016     0.200
    54.409     1.224     0.200
    55.061     0.345     0.200
    55.061     0.615     0.200
    55.061    -0.004     0.200
    55.679     0.311     0.200
    56.173    -1.304     0.200
    56.563     1.021     0.200
    56.700    -0.849     0.200
    56.810     0.169     0.200
    56.810    -0.130     0.200
    56.835     0.890     0.200
    56.927     0.565     0.200
    56.927     0.940     0.200
    57.115     1.707     0.200
    57.529     0.486     0.200
    58.104    -0.490     0.200
    58.055     0.252     0.200
    60.231     1.517     0.200
    60.647    -0.224     0.200
    60.647    -0.212     0.200
    60.719     0.255     0.200
    60.719    -0.114     0.200
    60.719    -0.294     0.200
    61.033     0.262     0.200
    61.897    -1.080     0.200
    61.897    -1.690     0.200
    61.897    -1.510     0.200
    62.639     0.002     0.200
    63.366     0.285     0.200
    63.831     0.803     0.200
    63.850    -0.033     0.200
    63.878    -0.497     0.200
    63.900     0.442     0.200
    63.988    -0.026     0.200
    64.412     0.077     0.200
    64.634    -0.929     0.200
    64.634    -1.300     0.200
    64.580     0.141     0.200
    64.684     0.434     0.200
    64.822     1.023     0.200
    64.822     0.388     0.200
    64.822     1.048     0.200
    65.108    -0.757     0.200
    65.305     0.385     0.200
    65.513    -1.118     0.200
    65.519     0.545     0.200
    65.519     0.996     0.200
    65.596    -0.316     0.200
    65.596    -0.097     0.200
    65.606    -0.338     0.200
    65.661     0.144     0.200
    65.663    -0.262     0.200
    65.727     0.198     0.200
    65.727     0.405     0.200
    66.088    -0.521     0.200
    66.088     0.139     0.200
    66.090     1.074     0.200
    66.090     1.664     0.200
    66.296    -0.163     0.200
    66.296     0.747     0.200
    66.391     1.411     0.200
    66.391     0.638     0.200
    66.957     0.561     0.200
    67.268    -0.177     0.200
    67.439    -0.496     0.200
    67.678     0.484     0.200
    67.996    -1.140     0.200
    68.064    -0.332     0.200
    68.253    -0.782     0.200
    68.253    -0.933     0.200
    68.346    -0.415     0.200
    68.552     0.011     0.200
    69.069    -0.383     0.200
    69.127    -1.312     0.200
    69.285    -1.285     0.200
    69.468    -0.143     0.200
    70.584    -0.002     0.200
    73.462    -0.288     0.200
    73.690     1.312     0.200
    74.245     0.768     0.200
    74.568    -0.913     0.200
    75.344     1.775     0.200
    75.344     1.307     0.200
    75.344     0.807     0.200
    75.408    -0.115     0.200
    75.630     0.164     0.200
    75.649     0.656     0.200
    75.732     1.481     0.200
    75.787    -2.031     0.200
    75.996     0.775     0.200
    76.175     0.056     0.200
    76.276     1.482     0.200
    76.292    -0.212     0.200
    76.474    -2.049     0.200
    76.412     1.111     0.200
    76.561     0.566     0.200
    76.606     1.613     0.200
    76.679     0.095     0.200
    76.752     1.487     0.200
    76.822     0.639     0.200
    76.829     0.621     0.200
    76.829     0.422     0.200
    76.829     0.052     0.200
    76.829     1.002     0.200
    76.854     0.313     0.200
    77.059     1.157     0.200
    77.173    -0.156     0.200
    77.162     1.277     0.200
    77.341     0.202     0.200
    77.428    -1.313     0.200
    77.487     1.759     0.200
    77.563     1.629     0.200
    77.622     0.104     0.200
    77.908     3.210     0.200
    78.125     0.374     0.200
    78.091    -0.466     0.200
    78.161     1.102     0.200
    78.345     0.686     0.200
    78.440    -0.440     0.200
    78.440    -0.280     0.200
    78.520     1.616     0.200
    78.667     0.426     0.200
    78.797     0.691     0.200
    78.963    -1.620     0.200
    78.992    -1.275     0.200
    78.994    -1.485     0.200
    79.008     1.336     0.200
    79.035    -1.511     0.200
    79.136    -1.067     0.200
    79.763    -0.003     0.200
    79.787    -2.013     0.200
    80.089     1.055     0.200
    80.327     1.271     0.200
    80.419    -1.127     0.200
    80.419    -0.916     0.200
    80.551    -1.777     0.200
    80.556    -0.760     0.200
    80.556    -1.149     0.200
    80.553    -1.141     0.200
    80.599    -0.290     0.200
    80.654    -0.985     0.200
    80.721    -1.482     0.200
    80.970    -1.863     0.200
    80.974    -2.142     0.200
    80.996     0.588     0.200
    81.043     0.739     0.200
    81.292     1.016     0.200
    81.599     0.590     0.200
    81.605     0.456     0.200
    81.899     0.604     0.200
    82.185     1.314     0.200
    82.289     0.763     0.200
    82.429     0.176     0.200
    82.440     1.558     0.200
    82.459    -1.029     0.200
    82.547     1.803     0.200
    82.572     0.980     0.200
    82.606     0.202     0.200
    82.731     0.413     0.200
    82.831     1.344     0.200
    82.886    -0.349     0.200
    82.916     1.082     0.200
    82.921     1.469     0.200
    83.011     0.593     0.200
    83.017     0.561     0.200
    83.049    -0.796     0.200
    83.071     1.993     0.200
    83.093     0.478     0.200
    83.101     1.138     0.200
    83.244    -0.408     0.200
    83.324     0.162     0.200
    83.333    -0.063     0.200
    83.336     0.949     0.200
    83.413    -1.260     0.200
    83.564     0.049     0.200
    83.767    -1.068     0.200
    83.854    -0.436     0.200
    83.883    -0.188     0.200
    83.884    -0.336     0.200
    83.916    -0.155     0.200
    83.938     0.833     0.200
    83.995    -1.298     0.200
    84.021    -0.492     0.200
    84.044     0.093     0.200
    84.107     0.171     0.200
    84.159     0.456     0.200
    84.265     0.471     0.200
    84.272    -0.067     0.200
    84.316    -0.087     0.200
    84.356     0.207     0.200
    84.434     0.010     0.200
    84.481    -0.828     0.200
    84.482    -0.232     0.200
    84.509     0.051     0.200
    84.509    -0.268     0.200
    84.526    -0.195     0.200
    84.616    -0.209     0.200
    84.787    -0.068     0.200
    84.831    -1.194     0.200
    84.929    -0.350     0.200
    85.080    -0.743     0.200
    85.115    -1.318     0.200
    85.115    -1.294     0.200
    85.115    -1.419     0.200
    85.115    -0.401     0.200
    85.115     0.183     0.200
    85.121    -1.347     0.200
    85.338    -1.524     0.200
    85.338    -1.231     0.200
    85.354    -0.314     0.200
    85.370    -0.594     0.200
    85.370    -1.344     0.200
    85.511    -1.593     0.200
    85.542    -0.347     0.200
    85.660    -0.735     0.200
    85.907    -0.663     0.200
    86.120     0.826     0.200
    86.130    -0.762     0.200
    86.149    -0.359     0.200
    86.166    -0.813     0.200
    86.240    -0.605     0.200
    86.241    -2.210     0.200
    86.258    -1.313     0.200
    86.260    -1.025     0.200
    86.263    -0.818     0.200
    86.269    -1.241     0.200
    86.316    -0.979     0.200
    86.348    -1.136     0.200
    86.432    -0.254     0.200
    86.566    -0.507     0.200
    86.577    -1.262     0.200
    86.585    -1.302     0.200
    86.695     1.406     0.200
    86.695     0.857     0.200
    86.695    -0.641     0.200
    86.719    -0.860     0.200
    86.850    -0.898     0.200
    86.979    -0.732     0.200
    86.979    -0.413     0.200
    86.985    -1.091     0.200
    87.039    -0.821     0.200
    87.039    -0.688     0.200
    87.117    -0.707     0.200
    87.109    -0.871     0.200
    87.115    -0.591     0.200
    87.124    -1.135     0.200
    87.130    -1.562     0.200
    87.130    -1.363     0.200
    87.130    -1.561     0.200
    87.146    -1.141     0.200
    87.216    -0.582     0.200
    87.274    -0.463     0.200
    87.321    -0.992     0.200
    87.368    -1.216     0.200
    87.475    -0.288     0.200
    87.480    -1.288     0.200
    87.559     0.509     0.200
    87.574    -2.009     0.200
    87.606    -2.263     0.200
    87.730    -0.756     0.200
    87.798     0.636     0.200
    87.797    -0.676     0.200
    87.802    -0.902     0.200
    87.804    -0.692     0.200
    87.876    -0.250     0.200
    87.876    -0.089     0.200
    87.899    -1.359     0.200
    87.915    -1.837     0.200
    87.915    -1.138     0.200
    87.932    -0.518     0.200
    87.939    -0.753     0.200
    87.953     0.556     0.200
    88.279    -3.204     0.200
    88.075    -0.922     0.200
    88.156    -0.080     0.200
    88.157    -1.585     0.200
    88.221    -1.387     0.200
    88.281    -1.474     0.200
    88.281    -0.975     0.200
    88.307    -1.297     0.200
    88.387    -1.561     0.200
    88.387    -2.811     0.200
    88.448    -0.113     0.200
    88.452    -1.081     0.200
    88.452    -0.481     0.200
    88.468    -1.616     0.200
    88.491    -1.142     0.200
    88.491    -0.400     0.200
    88.535    -0.636     0.200
    88.519    -0.098     0.200
    88.519    -0.518     0.200
    88.524    -0.949     0.200
    88.602    -0.187     0.200
    88.602    -0.890     0.200
    88.971    -0.474     0.200
    88.676    -0.837     0.200
    88.687    -1.388     0.200
    88.687    -1.087     0.200
    88.752    -0.994     0.200
    88.752    -0.195     0.200
    89.025    -3.866     0.200
    88.768    -0.587     0.200
    88.780    -1.325     0.200
    88.818    -0.505     0.200
    88.975    -1.041     0.200
    89.085    -3.561     0.200
    89.089    -0.759     0.200
    89.100    -0.833     0.200
    89.117    -1.412     0.200
    89.135    -1.295     0.200
    89.161    -0.316     0.200
    89.170    -1.161     0.200
    89.229    -1.436     0.200
    89.311    -0.656     0.200
    89.369    -1.712     0.200
    89.400    -2.436     0.200
    89.400    -1.237     0.200
    89.418    -1.723     0.200
    89.418    -1.121     0.200
    89.467    -0.952     0.200
    89.519    -1.094     0.200
    89.581    -0.284     0.200
    89.620    -1.466     0.200
    89.652    -1.118     0.200
    89.658    -0.247     0.200
    89.699    -1.338     0.200
    89.721    -2.242     0.200
    89.816     1.195     0.200
    89.820     3.499     0.200
    89.829     3.253     0.200
    89.803    -0.522     0.200
    89.874    -2.358     0.200
    89.894    -0.089     0.200
    89.904    -1.696     0.200
    89.929    -1.711     0.200
    90.031     3.313     0.200
    90.158     3.517     0.200
    90.112    -0.167     0.200
    90.147    -0.860     0.200
    90.177    -1.872     0.200
    90.202    -1.286     0.200
    90.249    -0.006     0.200
    90.261    -2.059     0.200
    90.374    -0.779     0.200
    90.400    -1.010     0.200
    90.447    -1.925     0.200
    90.509    -2.216     0.200
    90.584    -2.368     0.200
    90.710    -1.353     0.200
    90.683    -0.525     0.200
    90.828    -2.403     0.200
    90.828    -1.801     0.200
    90.828    -1.932     0.200
    90.943     3.163     0.200
    90.963     3.372     0.200
    90.888    -2.277     0.200
    90.884    -2.461     0.200
    90.905    -2.056     0.200
    90.906    -1.662     0.200
    90.945    -1.546     0.200
    90.949    -0.561     0.200
    90.969    -2.057     0.200
    91.077    -1.259     0.200
    91.077    -0.821     0.200
    91.060    -0.591     0.200
    91.078    -0.962     0.200
    91.257     3.209     0.200
    91.211    -0.521     0.200
    91.227     0.345     0.200
    91.300    -1.460     0.200
    91.308    -0.730     0.200
    91.308    -0.531     0.200
    91.346    -1.905     0.200
    91.374    -0.334     0.200
    91.379    -1.957     0.200
    91.404    -1.875     0.200
    91.413    -2.615     0.200
    91.413    -2.915     0.200
    91.569    -0.784     0.200
    91.587    -2.420     0.200
    91.644    -1.486     0.200
    91.647    -2.599     0.200
    91.655    -2.338     0.200
    91.722    -2.646     0.200
    91.737    -2.818     0.200
    91.767    -2.654     0.200
    91.786    -2.844     0.200
    91.817    -2.888     0.200
    91.826     0.871     0.200
    91.855    -1.381     0.200
    91.871    -2.635     0.200
    91.913    -1.334     0.200
    91.913    -0.529     0.200
    92.039    -2.292     0.200
    92.042    -1.428     0.200
    92.067    -2.042     0.200
    92.067    -1.860     0.200
    92.067    -1.866     0.200
    92.081    -3.507     0.200
    92.201    -3.361     0.200
    92.203    -1.471     0.200
    92.222    -3.259     0.200
    92.222    -2.058     0.200
    92.263    -1.450     0.200
    92.298    -4.012     0.200
    92.383    -3.003     0.200
    92.405    -0.905     0.200
    92.420    -0.376     0.200
    92.424    -2.091     0.200
    92.505    -1.054     0.200
    92.644    -2.311     0.200
    92.701    -3.573     0.200
    92.723    -3.873     0.200
    92.738    -2.542     0.200
    92.763    -0.958     0.200
    92.794    -2.302     0.200
    92.830    -0.966     0.200
    92.830    -0.231     0.200
    92.830    -0.567     0.200
    92.866    -2.234     0.200
    92.918    -3.274     0.200
    92.941    -1.181     0.200
    92.976    -3.240     0.200
    92.976    -2.840     0.200
    92.993    -2.321     0.200
    92.999    -3.645     0.200
    93.027     0.024     0.200
    93.042     0.454     0.200
    93.080    -2.418     0.200
    93.087    -2.352     0.200
    93.233    -1.626     0.200
    93.238     0.154     0.200
    93.301    -2.339     0.200
    93.358    -1.602     0.200
    93.385    -1.725     0.200
    93.386    -0.427     0.200
    93.391    -2.352     0.200
    93.414    -0.759     0.200
    93.466    -0.500     0.200
    93.468    -1.906     0.200
    93.517    -1.431     0.200
    93.567    -0.293     0.200
    93.567     0.340     0.200
    93.607    -3.445     0.200
    93.771    -0.604     0.200
    93.810    -1.056     0.200
    93.934    -2.551     0.200
    93.936    -1.662     0.200
    93.936    -1.072     0.200
    93.956    -1.651     0.200
    94.019    -2.143     0.200
    94.057    -1.617     0.200
    94.096    -2.494     0.200
    94.124    -1.013     0.200
    94.124    -2.324     0.200
    94.151    -2.350     0.200
    94.253    -0.017     0.200
    94.302    -1.541     0.200
    94.320    -2.525     0.200
    94.464    -0.084     0.200
    94.470    -1.811     0.200
    94.486    -0.582     0.200
    94.490    -1.704     0.200
    94.585    -1.040     0.200
    94.622    -0.489     0.200
    94.664    -0.802     0.200
    94.837    -2.997     0.200
    94.898    -2.374     0.200
    94.932    -0.649     0.200
    95.010    -1.687     0.200
    95.215    -0.528     0.200
    95.197    -1.479     0.200
    95.445    -0.803     0.200
    95.461    -1.147     0.200
    95.481    -0.839     0.200
    95.511    -0.249     0.200
    95.510    -0.953     0.200
    95.521    -0.583     0.200
    95.706    -0.803     0.200
    95.746    -0.647     0.200
    95.816    -0.526     0.200
    95.994    -1.475     0.200
    96.167    -1.464     0.200
    96.358    -0.659     0.200
    96.383    -1.107     0.200
    96.506    -1.801     0.200
    96.726    -0.828     0.200
    96.991    -1.498     0.200
    97.036    -1.591     0.200
    97.392    -0.987     0.200
    97.401    -1.245     0.200
    97.677    -0.862     0.200
    97.693    -0.936     0.200
    97.849    -0.898     0.200
    98.056    -0.649     0.200
    98.061    -0.823     0.200
    98.478    -0.287     0.200
    98.687    -1.332     0.200
    98.986    -1.203     0.200
    99.032    -0.673     0.200
    14.087     8.884     0.200
    14.754     7.793     0.200
    14.873     5.876     0.200
    15.176     4.622     0.200
    15.436     3.016     0.200
    15.436     5.084     0.200
    15.853     6.791     0.200
    15.998     3.707     0.200
    16.416     2.057     0.200
    17.292     5.712     0.200
    17.292     1.676     0.200
    20.005     1.165     0.200
    20.723    -0.314     0.200
    20.723     0.460     0.200
    21.242     4.356     0.200
    21.225     0.568     0.200
    21.467     1.643     0.200
    21.601     4.299     0.200
    21.601     1.260     0.200
    22.073     2.847     0.200
    22.069     0.332     0.200
    22.233     1.525     0.200
    22.256     0.596     0.200
    22.296     5.475     0.200
    22.398     1.789     0.200
    22.401    -0.245     0.200
    22.526     1.824     0.200
    22.790     2.430     0.200
    23.022     4.177     0.200
    23.224     1.843     0.200
    23.301     3.134     0.200
    23.311     1.375     0.200
    23.311     1.725     0.200
    23.358     1.132     0.200
    23.358     0.093     0.200
    23.422     0.096     0.200
    23.595     1.269     0.200
    23.595     0.509     0.200
    23.698     1.834     0.200
    23.698    -0.115     0.200
    23.899     2.391     0.200
    23.936    -1.548     0.200
    23.936    -0.449     0.200
    24.085     1.390     0.200
    24.070     1.127     0.200
    24.109     1.078     0.200
    24.186     3.872     0.200
    24.208    -0.380     0.200
    24.351     0.231     0.200
    24.555     1.908     0.200
    24.587     1.317     0.200
    24.756     1.373     0.200
    24.756     0.134     0.200
    24.804     2.639     0.200
    24.884     1.407     0.200
    24.927     1.615     0.200
    25.096     2.085     0.200
    25.132     0.949     0.200
    25.228     1.679     0.200
    25.269     2.911     0.200
    25.259     2.499     0.200
    25.425     2.790     0.200
    25.437     1.886     0.200
    25.706     1.670     0.200
    25.706     0.965     0.200
    25.706     1.096     0.200
    25.706     0.645     0.200
    25.789     2.289     0.200
    25.800     1.295     0.200
    25.804     1.328     0.200
    25.804     0.058     0.200
    25.872    -0.352     0.200
    25.926     1.047     0.200
    25.926     0.348     0.200
    25.926     0.333     0.200
    26.128    -0.527     0.200
    26.506     2.803     0.200
    26.561     2.612     0.200
    26.803     0.026     0.200
    26.901    -0.352     0.200
    27.616    -0.279     0.200
    27.616     0.020     0.200
    27.702     0.056     0.200
    27.702    -0.245     0.200
    27.894    -1.409     0.200
    28.112     0.493     0.200
    29.458    -2.375     0.200
    29.458    -2.815     0.200
    30.000    -0.355     0.200
    30.412    -0.997     0.200
    30.766     0.056     0.200
    30.786     0.282     0.200
    31.373     1.011     0.200
    31.373    -2.089     0.200
    31.378    -1.984     0.200
    31.382    -2.320     0.200
    31.568    -1.411     0.200
    32.706     2.899     0.200
    34.191     0.741     0.200
    34.191    -0.040     0.200
    34.191    -1.139     0.200
    34.762    -0.933     0.200
    34.763    -1.290     0.200
    34.763    -0.991     0.200
    34.839     0.048     0.200
    34.839     0.799     0.200
    34.839     0.049     0.200
    34.897     0.551     0.200
    36.434     2.550     0.200
    36.434     1.355     0.200
    36.433     1.666     0.200
    36.628    -0.296     0.200
    37.005     0.093     0.200
    37.005    -0.208     0.200
    37.683     0.443     0.200
    38.317     1.293     0.200
    38.424     1.197     0.200
    39.121     1.452     0.200
    39.374     0.131     0.200
    39.374     0.260     0.200
    39.693     1.476     0.200
    39.708     0.026     0.200
    39.708    -0.648     0.200
    40.034     1.436     0.200
    40.322     0.657     0.200
    40.334     0.654     0.200
    40.428     1.345     0.200
    40.428     0.476     0.200
    40.499     0.791     0.200
    40.589     0.945     0.200
    40.600     0.811     0.200
    40.600     0.551     0.200
    40.659    -1.264     0.200
    41.106     0.583     0.200
    41.911     1.083     0.200
    41.949     0.772     0.200
    42.874     0.533     0.200
    42.874     0.772     0.200
    43.100    -0.790     0.200
    43.769    -0.485     0.200
    43.819    -1.291     0.200
    43.894    -1.019     0.200
    44.027    -0.886     0.200
    44.847    -0.343     0.200
    44.847    -0.718     0.200
    44.836     0.391     0.200
    44.836     1.442     0.200
    44.836     0.973     0.200
    45.670     1.153     0.200
    46.133     1.497     0.200
    48.106     0.317     0.200
    48.399     0.246     0.200
    50.829    -0.178     0.200
    50.887    -0.214     0.200
    50.887    -1.115     0.200
    50.887    -0.814     0.200
    50.968     0.175     0.200
    50.967     0.384     0.200
    50.967     0.784     0.200
    50.967     0.325     0.200
    51.157     0.160     0.200
    51.157     0.640     0.200
    51.238    -1.148     0.200
    51.360    -0.264     0.200
    51.815     2.832     0.200
    51.979     1.206     0.200
    52.090     1.144     0.200
    52.090     0.585     0.200
    52.174    -1.038     0.200
    52.174    -0.659     0.200
    52.664     1.534     0.200
    53.278     1.995     0.200
    53.369     0.723     0.200
    53.369     1.303     0.200
    53.706     1.462     0.200
    53.841     2.111     0.200
    53.874    -0.477     0.200
    53.874    -0.278     0.200
    53.971     0.414     0.200
    54.008     0.862     0.200
    54.008     1.710     0.200
    54.008     0.641     0.200
    54.008     1.471     0.200
    54.008     0.352     0.200
    54.244     0.802     0.200
    54.372     1.906     0.200
    54.508     1.460     0.200
    55.101     0.771     0.200
    55.101     0.103     0.200
    55.101     0.283     0.200
    55.102     0.572     0.200
    55.693     0.540     0.200
    56.711     0.220     0.200
    56.912     0.242     0.200
    56.912    -0.059     0.200
    56.912     0.342     0.200
    57.597    -0.395     0.200
    60.690     0.194     0.200
    60.762     0.761     0.200
    60.762     0.191     0.200
    61.195     0.207     0.200
    61.744    -1.452     0.200
    61.744    -1.731     0.200
    62.865     0.049     0.200
    63.273     0.032     0.200
    63.587    -0.237     0.200
    63.806    -0.627     0.200
    64.051     0.338     0.200
    64.075     0.329     0.200
    64.122     0.238     0.200
    64.219     0.001     0.200
    64.414    -2.290     0.200
    64.648    -0.093     0.200
    64.800    -0.346     0.200
    64.907    -0.232     0.200
    64.967     1.049     0.200
    64.967     0.258     0.200
    65.526     0.182     0.200
    65.684    -0.649     0.200
    65.684    -0.369     0.200
    65.724    -0.978     0.200
    65.727     0.858     0.200
    65.727     0.677     0.200
    65.809     0.116     0.200
    65.809    -0.310     0.200
    65.850     0.465     0.200
    65.871     0.308     0.200
    65.874     0.114     0.200
    65.874     0.649     0.200
    65.942     0.241     0.200
    66.226    -0.052     0.200
    66.300     0.978     0.200
    66.300     1.208     0.200
    66.301    -0.388     0.200
    66.301    -0.208     0.200
    66.540     0.781     0.200
    66.605     0.906     0.200
    66.605     0.365     0.200
    66.918     0.233     0.200
    67.165    -0.502     0.200
    67.202     0.641     0.200
    67.302     0.008     0.200
    67.923     0.938     0.200
    68.302    -0.398     0.200
    68.290    -0.802     0.200
    68.290    -1.222     0.200
    68.308    -0.411     0.200
    68.332     0.625     0.200
    68.798     0.364     0.200
    68.983     0.151     0.200
    73.557    -0.838     0.200
    74.688    -2.315     0.200
    75.481     0.860     0.200
    75.481     1.684     0.200
    75.481     1.016     0.200
    75.481     0.735     0.200
    75.625     0.331     0.200
    75.625     0.186     0.200
    75.801    -2.021     0.200
    76.078    -2.601     0.200
    76.406     0.537     0.200
    76.671     3.838     0.200
    76.797    -0.423     0.200
    76.938     0.452     0.200
    76.945     1.254     0.200
    76.945     0.812     0.200
    76.945    -0.207     0.200
    76.945     0.254     0.200
    77.503    -1.642     0.200
    77.594     1.081     0.200
    77.838    -0.339     0.200
    78.160    -0.799     0.200
    79.040    -1.647     0.200
    79.109    -1.526     0.200
    79.110    -1.630     0.200
    79.204    -1.142     0.200
    79.520    -0.641     0.200
    79.837    -2.088     0.200
    80.465    -0.840     0.200
    80.472    -1.191     0.200
    80.472    -0.517     0.200
    80.472    -0.767     0.200
    80.663    -1.640     0.200
    80.712    -1.992     0.200
    80.717    -1.627     0.200
    80.924    -0.633     0.200
    82.360     1.118     0.200
    82.360     1.479     0.200
    82.466    -1.072     0.200
    83.038    -1.448     0.200
    83.134    -0.105     0.200
    83.354     1.424     0.200
    83.506     1.467     0.200
    83.632     1.794     0.200
    83.676     1.168     0.200
    83.734    -1.232     0.200
    83.735    -0.963     0.200
    83.912    -0.859     0.200
    84.019     0.115     0.200
    84.019    -0.385     0.200
    84.019    -0.286     0.200
    84.019    -0.616     0.200
    84.220     0.692     0.200
    84.252     1.328     0.200
    84.345     0.530     0.200
    84.474    -0.798     0.200
    84.644     0.633     0.200
    84.644    -0.554     0.200
    84.661    -0.163     0.200
    84.680    -0.837     0.200
    84.837    -1.530     0.200
    85.128    -1.240     0.200
    85.128    -1.060     0.200
    85.400    -0.953     0.200
    85.412    -1.361     0.200
    85.412    -1.130     0.200
    85.563    -1.963     0.200
    86.419     0.995     0.200
    86.720     0.728     0.200
    86.992     1.350     0.200
    86.992     1.128     0.200
    86.992     1.569     0.200
    86.992     1.001     0.200
    87.974    -0.828     0.200
    88.082     1.110     0.200
    88.621    -2.273     0.200
    88.591    -1.644     0.200
    88.607    -0.623     0.200
    88.607    -0.453     0.200
    88.612    -0.272     0.200
    90.258    -1.054     0.200
    90.786    -1.913     0.200
    91.310    -1.523     0.200
    91.378    -0.961     0.200
    91.506    -2.055     0.200
    91.775    -2.101     0.200
    92.069    -2.060     0.200
    92.069    -1.887     0.200
    92.214    -2.032     0.200
    92.347    -2.445     0.200
    93.450    -0.934     0.200
    93.637    -0.500     0.200
    93.637    -0.195     0.200
    93.843    -0.042     0.200
    94.966    -0.551     0.200
    95.066    -0.649     0.200
    95.549    -0.856     0.200
    95.580    -0.398     0.200
    95.580    -1.049     0.200
    95.580    -0.697     0.200
    95.970    -0.472     0.200
    96.875    -0.681     0.200
    97.193    -0.318     0.200
    97.695     0.628     0.200
    98.007     0.394     0.200
    98.761    -0.482     0.200
    18.883     0.164     0.200
    19.149    -2.083     0.200
    19.486    -3.100     0.200
    20.671     0.321     0.200
    21.195     1.263     0.200
    22.186    -1.658     0.200
    22.597     0.163     0.200
    23.272     3.401     0.200
    23.421     0.606     0.200
    23.394    -0.634     0.200
    23.634    -0.673     0.200
    24.096     5.348     0.200
    24.250    -1.208     0.200
    24.250    -1.207     0.200
    24.418     1.406     0.200
    24.529     0.995     0.200
    24.744     0.914     0.200
    25.801    -0.971     0.200
    25.745     0.641     0.200
    25.745     3.340     0.200
    25.745     0.238     0.200
    25.844    -1.156     0.200
    25.923     0.905     0.200
    25.923     0.331     0.200
    25.922     0.357     0.200
    26.574     0.040     0.200
    27.684     0.262     0.200
    27.824    -0.113     0.200
    27.824    -0.707     0.200
    28.175     0.780     0.200
    29.516     0.454     0.200
    29.516     0.087     0.200
    30.349    -1.829     0.200
    31.302    -0.227     0.200
    31.302    -1.868     0.200
    31.308    -1.196     0.200
    31.308    -1.199     0.200
    31.308    -1.624     0.200
    31.312    -2.027     0.200
    31.899     3.325     0.200
    32.777     2.125     0.200
    33.190     0.314     0.200
    34.691    -2.424     0.200
    34.692     0.010     0.200
    34.692    -0.443     0.200
    34.905    -0.785     0.200
    34.905     0.591     0.200
    34.905    -1.081     0.200
    34.964    -0.293     0.200
    36.179     0.774     0.200
    39.445     0.877     0.200
    39.775    -0.024     0.200
    39.775    -0.172     0.200
    40.671     0.499     0.200
    40.671     0.499     0.200
    40.671    -1.400     0.200
    43.956    -0.311     0.200
    43.838     1.487     0.200
    44.777     0.138     0.200
    44.777    -0.936     0.200
    44.906     0.736     0.200
    46.197     2.014     0.200
    48.040     0.059     0.200
    50.944     0.123     0.200
    50.947     0.098     0.200
    51.032     1.015     0.200
    51.032     0.636     0.200
    51.032     0.640     0.200
    51.032     1.015     0.200
    51.032     0.515     0.200
    51.221     0.692     0.200
    51.873     3.317     0.200
    52.040     0.774     0.200
    52.141     0.516     0.200
    52.571     1.822     0.200
    53.026     1.859     0.200
    53.942    -1.143     0.200
    53.942    -0.014     0.200
    53.942    -0.393     0.200
    53.945    -0.033     0.200
    54.068     1.812     0.200
    54.068     1.316     0.200
    54.068    -0.563     0.200
    55.167     0.440     0.200
    55.167     0.198     0.200
    55.168     0.259     0.200
    55.863     0.481     0.200
    56.640    -1.166     0.200
    56.972    -0.469     0.200
    56.972    -1.172     0.200
    56.972    -0.719     0.200
    60.755    -0.862     0.200
    60.755    -0.851     0.200
    60.827     0.449     0.200
    61.245    -2.453     0.200
    61.813    -1.224     0.200
    61.813    -2.024     0.200
    63.625     0.155     0.200
    63.877    -0.758     0.200
    65.020    -0.750     0.200
    65.020    -1.891     0.200
    65.746    -0.452     0.200
    65.746    -1.132     0.200
    67.228    -0.554     0.200
    68.356    -0.702     0.200
    68.922     0.587     0.200
    75.664     0.450     0.200
    76.135    -2.037     0.200
    77.002     0.053     0.200
    80.537     0.316     0.200
    80.773    -0.689     0.200
    80.773    -0.502     0.200
    83.804    -0.454     0.200
    83.804    -0.454     0.200
    84.074    -0.388     0.200
    85.196    -1.554     0.200
    85.196    -1.530     0.200
    85.478    -1.415     0.200
    85.475    -1.001     0.200
    95.130     0.127     0.200
    19.947     0.570     0.200
    23.705     0.719     0.200
    25.791    -2.940     0.200
    25.841     3.250     0.200
    27.662    -0.690     0.200
    27.827    -1.607     0.200
    31.277    -2.494     0.200
    31.282    -1.881     0.200
    31.282    -1.880     0.200
    31.282    -1.251     0.200
    31.286    -3.028     0.200
    31.525    -2.542     0.200
    34.326     1.780     0.200
    34.671    -1.363     0.200
    34.672    -0.808     0.200
    34.672    -2.257     0.200
    34.878     0.938     0.200
    40.695     2.323     0.200
    40.695     2.327     0.200
    44.747    -1.998     0.200
    51.087    -0.032     0.200
    51.087     0.027     0.200
    51.087     0.023     0.200
    51.087     0.160     0.200
    52.107     2.052     0.200
    53.983    -1.185     0.200
    53.986    -1.204     0.200
    55.218    -0.687     0.200
    55.938    -0.531     0.200
    57.040     0.603     0.200
    65.808     0.171     0.200
    65.808    -0.098     0.200
    83.833    -0.239     0.200
    83.833    -0.239     0.200
    83.833     0.351     0.200
    83.833     0.218     0.200
    83.912    -0.644     0.200
    85.239     0.406     0.200
    85.239     0.410     0.200
    85.535    -1.146     0.200
    14.490     4.416     0.200
    15.492     6.268     0.200
    15.687     3.231     0.200
    18.725     0.235     0.200
    18.984    -0.227     0.200
    19.569     0.781     0.200
    19.569    -3.028     0.200
    19.698     1.074     0.200
    20.023     1.030     0.200
    20.023     0.827     0.200
    20.235     0.122     0.200
    20.612    -0.326     0.200
    20.612     0.225     0.200
    20.718     1.773     0.200
    20.827    -2.090     0.200
    21.343     2.429     0.200
    22.393     4.590     0.200
    22.440     2.887     0.200
    22.541     2.616     0.200
    22.900     1.309     0.200
    23.314     3.446     0.200
    23.427     4.275     0.200
    23.494     2.953     0.200
    23.494     1.382     0.200
    23.675    -2.755     0.200
    23.744     0.662     0.200
    23.885    -0.021     0.200
    23.885     0.163     0.200
    24.214     4.201     0.200
    24.417    -1.648     0.200
    25.261     2.366     0.200
    25.860    -0.092     0.200
    25.838     0.532     0.200
    25.838    -0.066     0.200
    26.074     1.069     0.200
    26.073    -2.269     0.200
    27.584     1.251     0.200
    27.757    -0.566     0.200
    27.757    -0.765     0.200
    28.194     0.440     0.200
    29.385     1.251     0.200
    29.385     0.692     0.200
    29.385     0.689     0.200
    30.331    -1.914     0.200
    31.339    -2.043     0.200
    31.345    -2.270     0.200
    31.345    -2.269     0.200
    31.345    -1.769     0.200
    31.349    -1.874     0.200
    31.370    -1.783     0.200
    31.898     2.160     0.200
    32.737     3.503     0.200
    33.084     0.365     0.200
    34.310    -0.004     0.200
    34.736    -1.412     0.200
    34.737    -1.251     0.200
    34.799     0.418     0.200
    36.500     1.360     0.200
    36.543    -1.212     0.200
    36.930    -0.706     0.200
    39.672     0.601     0.200
    40.458     0.377     0.200
    40.632     1.899     0.200
    40.632     1.899     0.200
    40.632    -0.761     0.200
    44.004    -1.110     0.200
    44.808    -1.209     0.200
    44.808    -0.358     0.200
    44.867    -0.516     0.200
    44.867    -0.133     0.200
    44.867    -0.621     0.200
    46.209     2.638     0.200
    50.810     1.749     0.200
    50.813     1.724     0.200
    51.042     0.651     0.200
    51.042     0.748     0.200
    51.042     0.748     0.200
    51.042     0.248     0.200
    51.481    -1.893     0.200
    51.913     3.327     0.200
    52.071    -0.946     0.200
    52.150     0.164     0.200
    52.203     0.271     0.200
    52.606    -0.722     0.200
    53.929    -1.608     0.200
    53.929    -1.682     0.200
    53.929    -0.557     0.200
    53.932    -1.705     0.200
    54.100     0.689     0.200
    54.100    -1.108     0.200
    55.170    -0.177     0.200
    55.170     0.092     0.200
    55.171     0.115     0.200
    55.806    -1.449     0.200
    55.910    -1.115     0.200
    57.006    -0.402     0.200
    57.006    -0.504     0.200
    57.006    -0.242     0.200
    60.760     0.014     0.200
    60.760     0.049     0.200
    60.832    -0.077     0.200
    60.832     0.192     0.200
    61.724     0.238     0.200
    65.076     2.615     0.200
    65.769    -0.743     0.200
    65.769    -1.602     0.200
    65.980     0.997     0.200
    66.000     0.558     0.200
    66.005    -0.447     0.200
    66.073     1.115     0.200
    66.358    -0.338     0.200
    66.679     2.689     0.200
    66.737     0.251     0.200
    68.358    -0.554     0.200
    68.358    -0.183     0.200
    75.757    -0.061     0.200
    75.757     0.310     0.200
    75.859    -2.171     0.200
    76.895    -0.476     0.200
    77.586    -0.927     0.200
    77.763    -0.852     0.200
    78.880    -1.180     0.200
    78.945    -1.807     0.200
    79.193    -1.506     0.200
    80.546     0.059     0.200
    80.639    -2.214     0.200
    80.639     0.664     0.200
    80.639    -1.636     0.200
    83.053    -2.052     0.200
    83.402    -0.833     0.200
    83.573    -0.709     0.200
    83.772    -1.677     0.200
    83.772    -1.681     0.200
    84.124     0.844     0.200
    84.124     0.844     0.200
    84.124    -0.555     0.200
    85.185    -0.712     0.200
    85.185    -0.689     0.200
    85.351    -0.788     0.200
    85.440     0.189     0.200
    85.495    -1.030     0.200
    87.141     0.664     0.200
    88.685    -3.342     0.200
    94.893    -1.628     0.200
    94.893    -1.625     0.200
    15.743     3.193     0.200
    18.736    -1.032     0.200
    18.993     0.657     0.200
    19.977     1.088     0.200
    20.074     0.351     0.200
    20.074     1.124     0.200
    20.884     0.297     0.200
    22.404     4.228     0.200
    22.497     1.236     0.200
    23.606    -1.237     0.200
    23.779    -0.904     0.200
    25.843     1.147     0.200
    25.843    -0.853     0.200
    25.906     0.354     0.200
    25.939    -1.111     0.200
    26.111    -0.800     0.200
    27.531     1.599     0.200
    27.950    -2.099     0.200
    28.171     0.374     0.200
    31.379    -1.460     0.200
    31.384    -1.983     0.200
    31.384    -1.084     0.200
    31.388    -1.240     0.200
    31.657    -0.472     0.200
    32.697     3.689     0.200
    34.744     1.007     0.200
    34.744     1.449     0.200
    34.778    -1.028     0.200
    34.778    -1.426     0.200
    34.778    -0.626     0.200
    36.471     2.237     0.200
    40.071     1.515     0.200
    40.593     1.495     0.200
    40.709    -0.964     0.200
    43.191     1.951     0.200
    44.047     0.056     0.200
    44.827     0.603     0.200
    44.845    -2.433     0.200
    46.184     2.860     0.200
    51.017     0.161     0.200
    51.017    -0.288     0.200
    51.207     1.354     0.200
    51.898     1.463     0.200
    55.143     0.145     0.200
    55.144    -0.915     0.200
    56.988     0.749     0.200
    60.732    -0.872     0.200
    60.804     0.076     0.200
    65.747    -1.108     0.200
    67.225    -0.845     0.200
    75.763    -0.411     0.200
    77.706     0.340     0.200
    80.581    -0.134     0.200
    84.113    -0.152     0.200
    85.472    -0.852     0.200
    20.671     0.535     0.200
    25.739    -1.118     0.200
    25.724     0.514     0.200
    25.854     0.515     0.200
    25.853     0.236     0.200
    29.605    -1.802     0.200
    29.605    -1.415     0.200
    29.606    -1.956     0.200
    31.255    -0.932     0.200
    31.255    -0.927     0.200
    34.635    -0.358     0.200
    34.636    -0.526     0.200
    43.898    -1.997     0.200
    44.728    -1.604     0.200
    49.385    -1.421     0.200
    51.060     1.215     0.200
    51.060     1.215     0.200
    51.060     0.465     0.200
    52.141    -1.475     0.200
    55.199     0.278     0.200
    55.200    -0.062     0.200
    56.987     0.359     0.200
    56.987     0.359     0.200
    60.787    -0.320     0.200
    60.787    -0.320     0.200
    60.859    -0.481     0.200
    65.768    -0.692     0.200
    84.079    -0.134     0.200
    84.080    -0.131     0.200
    20.891    -0.060     0.200
    23.220     0.679     0.200
    24.343     1.890     0.200
    25.461     1.533     0.200
    25.461     0.686     0.200
    25.461     1.115     0.200
    25.741     0.729     0.200
    27.715    -1.423     0.200
    27.715    -0.829     0.200
    27.915    -0.518     0.200
    29.783    -0.464     0.200
    29.784    -0.363     0.200
    31.303    -0.755     0.200
    31.302    -0.754     0.200
    31.307    -1.021     0.200
    31.328    -1.932     0.200
    34.000     1.069     0.200
    34.667    -0.685     0.200
    34.668    -1.466     0.200
    34.668    -0.555     0.200
    35.099    -0.281     0.200
    35.099    -0.691     0.200
    39.956    -1.263     0.200
    40.684    -1.452     0.200
    40.684    -1.456     0.200
    44.788    -0.000     0.200
    44.788    -2.692     0.200
    50.926    -0.318     0.200
    51.922    -0.185     0.200
    53.893     0.022     0.200
    53.893    -2.127     0.200
    53.893    -0.447     0.200
    53.895    -2.146     0.200
    55.078     0.427     0.200
    55.525     1.602     0.200
    56.812    -0.264     0.200
    56.812     0.509     0.200
    56.812    -0.401     0.200
    60.736     0.031     0.200
    64.813    -0.293     0.200
    64.813     1.172     0.200
    65.175    -1.837     0.200
    65.614    -0.666     0.200
    65.614    -0.494     0.200
    68.271    -0.793     0.200
    68.716    -3.540     0.200
    78.165    -0.303     0.200
    81.049    -3.234     0.200
    83.472    -2.939     0.200
    83.877    -1.042     0.200
    83.877    -0.672     0.200
    83.877    -1.043     0.200
    83.877    -0.266     0.200
    85.347    -2.143     0.200
    15.368     3.493     0.200
    18.485    -1.564     0.200
    18.707    -2.059     0.200
    19.532    -0.407     0.200
    19.977    -0.006     0.200
    20.645    -3.020     0.200
    20.836    -0.532     0.200
    21.129     4.880     0.200
    21.772     4.261     0.200
    22.226     0.598     0.200
    22.283    -0.954     0.200
    22.521     0.977     0.200
    22.666     2.032     0.200
    23.182     1.902     0.200
    23.218     2.598     0.200
    23.218    -0.679     0.200
    23.263    -0.720     0.200
    23.436    -0.045     0.200
    24.291     0.077     0.200
    24.409     2.098     0.200
    24.601    -1.519     0.200
    24.961     3.874     0.200
    25.001     3.011     0.200
    25.120     2.027     0.200
    25.570    -0.342     0.200
    25.570     1.737     0.200
    25.570     0.358     0.200
    25.768     1.169     0.200
    25.767    -0.989     0.200
    25.876     2.276     0.200
    26.644    -0.279     0.200
    27.388    -1.088     0.200
    27.652    -0.778     0.200
    27.660    -0.463     0.200
    27.878     0.795     0.200
    27.878     1.455     0.200
    28.033     0.656     0.200
    30.106     1.229     0.200
    30.491    -0.438     0.200
    30.595     0.748     0.200
    31.400    -0.130     0.200
    31.405    -2.035     0.200
    31.405    -2.030     0.200
    31.405    -0.522     0.200
    31.409    -1.480     0.200
    31.772     2.859     0.200
    32.684     3.855     0.200
    34.781    -0.013     0.200
    34.782    -1.950     0.200
    34.782    -0.431     0.200
    34.892    -0.530     0.200
    34.892    -0.366     0.200
    34.942     0.718     0.200
    36.210     1.396     0.200
    39.755    -0.468     0.200
    40.576    -0.898     0.200
    40.576    -0.898     0.200
    40.576     0.993     0.200
    40.648    -1.329     0.200
    44.042     0.738     0.200
    44.881    -0.442     0.200
    44.881     0.320     0.200
    46.061     1.810     0.200
    48.169     0.321     0.200
    50.896     0.148     0.200
    50.896     1.359     0.200
    50.896     1.359     0.200
    51.085     1.506     0.200
    51.718     3.592     0.200
    51.890     0.885     0.200
    51.976     0.344     0.200
    52.420     0.013     0.200
    53.824    -1.536     0.200
    53.824    -0.201     0.200
    53.827    -1.560     0.200
    53.918     0.505     0.200
    55.036    -0.245     0.200
    55.580    -1.053     0.200
    55.705    -1.662     0.200
    56.481    -1.401     0.200
    56.821    -0.456     0.200
    56.821    -0.718     0.200
    56.821    -0.507     0.200
    60.696    -0.892     0.200
    61.774    -1.194     0.200
    64.858     1.079     0.200
    64.858    -0.159     0.200
    64.858    -2.128     0.200
    65.602     0.388     0.200
    65.602    -0.569     0.200
    68.227    -0.266     0.200
    75.463    -0.821     0.200
    75.489    -1.344     0.200
    80.808    -0.420     0.200
    80.808    -1.987     0.200
    80.808    -0.147     0.200
    83.758     0.701     0.200
    83.914     0.158     0.200
    83.914     0.158     0.200
    83.914    -1.753     0.200
    85.076     0.085     0.200
    85.076     0.089     0.200
    20.022    -0.369     0.200
    25.856     1.251     0.200
    31.337    -2.303     0.200
    34.731    -1.272     0.200
    44.800    -0.539     0.200
    51.054    -0.374     0.200
    84.140     0.962     0.200
    15.480     5.643     0.200
    18.611    -1.529     0.200
    19.634    -0.899     0.200
    20.709    -0.604     0.200
    20.848    -0.852     0.200
    22.342    -1.583     0.200
    22.464     0.975     0.200
    23.421     1.418     0.200
    23.404    -0.900     0.200
    23.512    -1.022     0.200
    23.683     0.416     0.200
    23.758    -0.824     0.200
    24.856    -0.641     0.200
    25.236     3.157     0.200
    25.746     1.529     0.200
    25.746     1.530     0.200
    25.746     0.627     0.200
    26.020     0.880     0.200
    26.020    -0.245     0.200
    26.019    -0.278     0.200
    27.529     0.814     0.200
    27.586     0.303     0.200
    28.098     1.262     0.200
    31.429    -0.198     0.200
    31.429    -0.197     0.200
    31.805     2.848     0.200
    32.654     3.005     0.200
    33.999    -1.306     0.200
    34.214    -0.500     0.200
    34.818    -0.113     0.200
    34.748     0.780     0.200
    34.748    -0.720     0.200
    34.809     0.553     0.200
    34.809    -0.326     0.200
    36.406     1.932     0.200
    39.301     0.048     0.200
    39.619     0.172     0.200
    40.375    -0.852     0.200
    40.549     1.534     0.200
    40.549     1.534     0.200
    40.549     0.815     0.200
    40.731    -1.403     0.200
    44.084    -0.640     0.200
    44.894    -0.323     0.200
    44.894    -1.057     0.200
    46.114     1.774     0.200
    50.948     0.856     0.200
    50.948     1.106     0.200
    50.948     1.106     0.200
    50.948     0.204     0.200
    51.137     0.327     0.200
    51.300     0.207     0.200
    51.385     0.832     0.200
    51.816     2.845     0.200
    51.974    -0.432     0.200
    52.106    -0.917     0.200
    52.090    -2.893     0.200
    52.090    -0.572     0.200
    52.368    -1.838     0.200
    53.839    -1.598     0.200
    53.839    -0.149     0.200
    53.839    -1.738     0.200
    53.841    -0.168     0.200
    54.004     1.540     0.200
    54.004    -0.605     0.200
    55.077    -0.703     0.200
    55.077    -0.441     0.200
    55.078     0.817     0.200
    55.709    -1.060     0.200
    55.745    -1.215     0.200
    55.813    -0.551     0.200
    56.909    -0.717     0.200
    56.909    -0.717     0.200
    60.738    -2.033     0.200
    60.738    -0.806     0.200
    64.979     1.045     0.200
    65.673    -0.807     0.200
    68.265    -0.916     0.200
    73.530    -0.610     0.200
    75.666    -0.447     0.200
    75.768    -2.332     0.200
    76.946    -3.017     0.200
    82.997    -0.440     0.200
    83.687    -0.504     0.200
    83.687    -0.504     0.200
    85.094    -0.329     0.200
    85.094    -0.356     0.200
    85.399    -1.215     0.200
    85.399    -1.254     0.200
    87.070     1.155     0.200
    87.321    -1.606     0.200
    95.046    -3.372     0.200
    25.771     1.281     0.200
    27.690    -1.450     0.200
    27.747    -1.961     0.200
    31.291    -1.759     0.200
    31.291    -1.760     0.200
    34.676    -0.916     0.200
    34.677    -0.314     0.200
    34.677    -0.783     0.200
    43.941    -1.725     0.200
    51.053     0.558     0.200
    51.053     0.421     0.200
    51.053     0.417     0.200
    51.053    -0.052     0.200
    51.243     0.087     0.200
    52.167     0.564     0.200
    53.961    -0.930     0.200
    53.961    -0.637     0.200
    53.964    -0.950     0.200
    55.188    -0.758     0.200
    55.189    -0.650     0.200
    56.995    -0.055     0.200
    63.892    -0.755     0.200
    15.196     6.664     0.200
    15.229     3.943     0.200
    15.566     6.328     0.200
    15.708     7.882     0.200
    15.708     6.811     0.200
    16.295     1.614     0.200
    19.627    -1.115     0.200
    19.680    -0.187     0.200
    19.857     0.699     0.200
    20.664    -0.193     0.200
    20.844     1.723     0.200
    20.844     2.356     0.200
    21.315     2.788     0.200
    21.608     3.230     0.200
    21.965     3.116     0.200
    22.062     2.474     0.200
    22.269     0.481     0.200
    22.515     3.350     0.200
    22.507    -0.255     0.200
    22.619    -0.559     0.200
    22.732     2.845     0.200
    22.732     2.165     0.200
    23.021     3.194     0.200
    23.032     1.629     0.200
    23.147     2.865     0.200
    23.147     0.807     0.200
    23.168     1.740     0.200
    23.168    -0.092     0.200
    23.162     2.204     0.200
    23.324     0.260     0.200
    23.420     1.187     0.200
    23.420     0.597     0.200
    23.615     2.594     0.200
    23.644     0.747     0.200
    23.786     1.333     0.200
    23.847     1.874     0.200
    23.851     2.242     0.200
    23.945    -0.655     0.200
    24.139     0.053     0.200
    24.265     2.152     0.200
    24.344    -1.602     0.200
    24.385     3.666     0.200
    24.470     1.988     0.200
    24.470     1.559     0.200
    24.516     0.670     0.200
    24.965     1.474     0.200
    25.062     3.598     0.200
    25.136     2.225     0.200
    25.128     1.195     0.200
    25.501     4.206     0.200
    25.528     4.037     0.200
    25.528     1.061     0.200
    25.528     1.514     0.200
    25.528    -0.138     0.200
    25.647     0.532     0.200
    25.625     1.584     0.200
    25.629     1.086     0.200
    25.629    -0.254     0.200
    25.647     0.409     0.200
    25.777     1.199     0.200
    25.777    -0.368     0.200
    26.378     4.164     0.200
    26.528    -0.384     0.200
    27.714     0.348     0.200
    27.714    -0.851     0.200
    27.765    -0.619     0.200
    27.765    -1.334     0.200
    27.765    -0.404     0.200
    27.790    -0.855     0.200
    27.847    -1.363     0.200
    28.067    -0.397     0.200
    30.877     0.184     0.200
    31.319    -0.207     0.200
    31.319    -1.149     0.200
    31.324    -1.952     0.200
    31.324    -1.951     0.200
    31.324    -2.072     0.200
    31.328    -2.350     0.200
    31.350    -2.159     0.200
    31.394    -1.135     0.200
    31.823     2.451     0.200
    32.769     1.556     0.200
    33.923     1.995     0.200
    34.052     0.743     0.200
    34.052     0.872     0.200
    34.052    -0.929     0.200
    34.694    -1.135     0.200
    34.694    -1.045     0.200
    34.890    -0.438     0.200
    35.026     0.264     0.200
    35.026    -0.357     0.200
    35.072     1.250     0.200
    36.422     1.769     0.200
    36.543    -0.672     0.200
    37.038    -0.730     0.200
    38.181     1.549     0.200
    38.283     1.281     0.200
    38.979     1.642     0.200
    39.332    -0.239     0.200
    39.500    -2.510     0.200
    39.556     1.624     0.200
    39.886    -0.405     0.200
    40.182     0.819     0.200
    40.194     0.814     0.200
    40.360     0.842     0.200
    40.449     1.006     0.200
    40.490    -0.636     0.200
    40.539    -0.767     0.200
    40.660     1.766     0.200
    40.660     1.766     0.200
    40.660    -1.132     0.200
    40.967     0.828     0.200
    41.811     0.903     0.200
    42.921    -0.217     0.200
    43.926    -0.741     0.200
    43.951    -1.026     0.200
    44.805    -0.052     0.200
    44.805    -1.150     0.200
    44.805    -0.677     0.200
    44.897    -0.238     0.200
    44.897     3.294     0.200
    44.897    -1.179     0.200
    46.101     0.760     0.200
    48.511     0.485     0.200
    50.812     1.155     0.200
    50.937     0.420     0.200
    50.937     0.771     0.200
    50.937     0.771     0.200
    50.937    -0.092     0.200
    51.126     0.183     0.200
    51.129     0.162     0.200
    51.321    -1.977     0.200
    51.730     5.271     0.200
    51.912     0.718     0.200
    51.968     1.216     0.200
    51.968     0.599     0.200
    52.333    -1.697     0.200
    52.489    -0.155     0.200
    53.886    -1.494     0.200
    53.886    -0.810     0.200
    53.886    -1.072     0.200
    53.889    -0.834     0.200
    53.939     1.828     0.200
    53.939     2.175     0.200
    53.939     0.355     0.200
    55.084     0.836     0.200
    55.084    -0.645     0.200
    55.571    -1.876     0.200
    55.711    -0.840     0.200
    56.485    -0.877     0.200
    56.839     0.568     0.200
    56.839    -0.334     0.200
    56.839     0.529     0.200
    60.742     0.234     0.200
    60.742     0.073     0.200
    61.067    -0.406     0.200
    61.896    -1.379     0.200
    61.896    -1.692     0.200
    64.623    -3.855     0.200
    64.855     1.494     0.200
    64.855    -0.284     0.200
    65.632    -1.288     0.200
    65.632    -1.148     0.200
    68.275    -1.520     0.200
    68.275    -2.282     0.200
    75.370    -0.142     0.200
    75.376     1.920     0.200
    75.446    -1.578     0.200
    75.987     0.329     0.200
    76.859    -0.418     0.200
    77.454    -0.163     0.200
    78.074    -0.841     0.200
    78.990    -0.167     0.200
    79.061    -0.855     0.200
    79.162    -0.308     0.200
    79.201    -0.880     0.200
    79.306    -0.984     0.200
    79.516    -0.978     0.200
    79.748    -1.829     0.200
    80.113    -1.979     0.200
    80.162    -1.939     0.200
    80.444     0.543     0.200
    80.455    -2.516     0.200
    80.569    -1.120     0.200
    80.847    -0.937     0.200
    80.953    -1.830     0.200
    80.956    -2.302     0.200
    80.956    -1.150     0.200
    80.956    -2.630     0.200
    81.930    -1.497     0.200
    82.285    -1.828     0.200
    83.063    -2.092     0.200
    83.214    -1.128     0.200
    83.410    -2.540     0.200
    83.782    -0.321     0.200
    83.782    -0.317     0.200
    83.915     0.450     0.200
    83.916    -2.152     0.200
    83.916     0.449     0.200
    83.916    -1.902     0.200
    83.908    -1.095     0.200
    84.541     2.270     0.200
    84.814    -1.191     0.200
    84.912    -1.894     0.200
    85.135    -1.621     0.200
    85.135    -1.644     0.200
    85.364    -1.265     0.200
    85.364    -1.765     0.200
    85.364    -1.504     0.200
    85.364    -2.566     0.200
    85.645    -1.262     0.200
    85.774    -1.112     0.200
    86.737     2.264     0.200
    87.065    -2.511     0.200
    88.547    -1.509     0.200
    92.085    -1.212     0.200
    92.085    -1.208     0.200
    93.966     1.153     0.200
    95.199    -0.756     0.200
    95.199    -0.765     0.200
    95.537     1.093     0.200
    14.200     8.861     0.200
    19.920    -0.212     0.200
    23.344     2.907     0.200
    23.712     0.745     0.200
    25.861     2.209     0.200
    25.861     0.030     0.200
    26.032     0.822     0.200
    27.799    -1.944     0.200
    31.247    -2.130     0.200
    31.252    -2.588     0.200
    31.252    -2.590     0.200
    31.252    -1.637     0.200
    31.256    -1.922     0.200
    31.499    -1.489     0.200
    34.641    -2.279     0.200
    34.642    -1.513     0.200
    40.725     1.011     0.200
    40.725     1.008     0.200
    51.116     0.521     0.200
    51.116     0.212     0.200
    51.116     0.212     0.200
    51.116    -0.038     0.200
    52.249     0.305     0.200
    54.013    -0.827     0.200
    54.013    -2.081     0.200
    54.013    -0.268     0.200
    54.016    -2.108     0.200
    55.247     0.652     0.200
    55.964     0.903     0.200
    57.068     0.666     0.200
    57.068     0.998     0.200
    60.908     0.340     0.200
    80.738    -1.551     0.200
    84.177     1.591     0.200
    84.177     1.591     0.200
    85.564    -1.392     0.200
    21.470     3.950     0.200
    25.658     1.834     0.200
    25.658     1.272     0.200
    25.804     0.729     0.200
    25.803    -0.058     0.200
    27.739     0.559     0.200
    27.796     0.041     0.200
    31.299    -2.625     0.200
    31.304    -1.519     0.200
    31.304    -1.526     0.200
    31.304    -2.838     0.200
    34.683    -0.757     0.200
    51.000     0.511     0.200
    51.000     0.511     0.200
    51.000     0.140     0.200
    53.928    -0.998     0.200
    53.928    -2.111     0.200
    53.931    -1.013     0.200
    55.141    -0.941     0.200
    55.806    -0.988     0.200
    63.892    -0.882     0.200
    14.061    12.066     0.200
    19.164     0.164     0.200
    20.038    -0.220     0.200
    21.222    -1.011     0.200
    23.551     1.958     0.200
    23.551     1.138     0.200
    25.314     4.653     0.200
    25.893     0.664     0.200
    25.893     0.723     0.200
    25.893     0.286     0.200
    31.336    -3.032     0.200
    31.336    -3.031     0.200
    31.336    -2.218     0.200
    34.775    -2.464     0.200
    34.731    -1.475     0.200
    34.732    -1.592     0.200
    34.732    -1.444     0.200
    34.992     0.993     0.200
    40.640    -2.399     0.200
    40.668    -0.617     0.200
    44.796     0.109     0.200
    51.070     0.528     0.200
    51.070     1.286     0.200
    51.070     1.286     0.200
    51.070     0.247     0.200
    51.260     0.967     0.200
    52.248    -0.281     0.200
    53.947    -0.185     0.200
    53.947    -0.052     0.200
    53.950    -0.212     0.200
    55.195     0.375     0.200
    55.196    -0.149     0.200
    57.042     0.178     0.200
    57.042     0.138     0.200
    57.575    -0.801     0.200
    60.785    -0.287     0.200
    60.785    -0.287     0.200
    60.857    -0.155     0.200
    65.800    -0.078     0.200
    31.387    -1.920     0.200
    34.782    -1.113     0.200
    51.016     0.352     0.200
    55.143    -0.339     0.200
    60.731    -0.393     0.200
    20.085     1.148     0.200
    23.470    -0.332     0.200
    23.579    -1.990     0.200
    23.751    -1.499     0.200
    25.811    -1.179     0.200
    25.811     0.770     0.200
    25.811    -1.089     0.200
    26.086     1.605     0.200
    27.821     0.020     0.200
    27.963    -1.332     0.200
    31.400    -2.566     0.200
    31.405    -1.711     0.200
    31.405    -1.710     0.200
    31.405    -1.983     0.200
    31.409    -1.655     0.200
    33.930    -0.918     0.200
    34.798    -1.042     0.200
    40.572     2.152     0.200
    40.572     2.156     0.200
    44.066    -1.573     0.200
    44.867    -1.229     0.200
    44.867    -1.085     0.200
    50.989     0.561     0.200
    50.989    -0.182     0.200
    50.989    -0.182     0.200
    50.989     0.279     0.200
    51.179     0.414     0.200
    52.164    -0.814     0.200
    53.872    -0.863     0.200
    53.874    -0.886     0.200
    55.116    -0.686     0.200
    55.117     0.778     0.200
    55.866    -0.739     0.200
    56.959     0.288     0.200
    68.304    -0.932     0.200
    79.491     0.836     0.200
    84.082    -0.199     0.200
    84.082    -0.200     0.200
    85.129    -0.556     0.200
    85.129    -0.552     0.200
    14.421     3.777     0.200
    14.395     5.397     0.200
    15.111     5.110     0.200
    15.424     4.943     0.200
    15.424     7.400     0.200
    15.424     3.349     0.200
    20.648     0.141     0.200
    21.258     3.749     0.200
    21.655     1.229     0.200
    22.250     2.592     0.200
    22.812     1.248     0.200
    23.338     2.075     0.200
    23.338     1.900     0.200
    23.435     0.555     0.200
    23.484     1.000     0.200
    23.653    -0.904     0.200
    23.659     0.994     0.200
    23.722    -0.105     0.200
    23.951     1.636     0.200
    24.144     3.475     0.200
    24.416     1.812     0.200
    24.663     4.948     0.200
    24.810     1.013     0.200
    24.810     0.193     0.200
    25.209     5.177     0.200
    25.828    -2.105     0.200
    25.783    -1.339     0.200
    25.783     1.173     0.200
    25.783     0.372     0.200
    25.783    -1.389     0.200
    25.841     2.149     0.200
    25.986    -0.070     0.200
    25.985    -0.662     0.200
    27.279    -0.305     0.200
    27.640     0.427     0.200
    27.763     1.031     0.200
    27.857    -0.713     0.200
    27.857    -1.623     0.200
    30.343    -0.636     0.200
    31.319    -1.603     0.200
    31.325    -1.670     0.200
    31.325    -1.673     0.200
    31.329    -1.774     0.200
    34.267     1.214     0.200
    34.712    -0.613     0.200
    34.713    -0.789     0.200
    34.859     0.293     0.200
    34.859     0.605     0.200
    36.498     2.528     0.200
    36.510     1.325     0.200
    39.412     1.028     0.200
    39.730    -0.225     0.200
    40.620    -0.816     0.200
    40.653     0.625     0.200
    40.653     0.625     0.200
    40.653    -0.375     0.200
    43.826    -0.820     0.200
    43.798    -0.712     0.200
    43.978    -0.510     0.200
    44.792     0.205     0.200
    44.792    -0.272     0.200
    51.034     0.574     0.200
    51.034     0.625     0.200
    51.034     0.625     0.200
    51.034     0.375     0.200
    51.224     0.149     0.200
    52.051    -0.430     0.200
    52.202    -1.342     0.200
    52.304    -0.149     0.200
    52.584    -0.692     0.200
    53.935    -0.705     0.200
    53.935    -2.111     0.200
    53.938    -0.720     0.200
    54.661    -0.018     0.200
    55.167    -0.278     0.200
    55.769    -0.009     0.200
    55.881    -0.075     0.200
    56.984    -0.278     0.200
    56.984    -0.560     0.200
    60.827     0.542     0.200
    63.854    -0.734     0.200
    64.425     1.018     0.200
    65.042     0.683     0.200
    65.042     0.171     0.200
    65.754    -1.047     0.200
    65.754    -1.379     0.200
    67.366    -0.120     0.200
    68.355    -1.252     0.200
    68.355    -1.791     0.200
    75.702    -1.482     0.200
    75.863    -1.203     0.200
    77.018    -0.147     0.200
    79.179    -0.741     0.200
    80.539     2.094     0.200
    80.716     0.945     0.200
    81.456     1.115     0.200
    83.131     0.441     0.200
    83.653     0.502     0.200
    83.789    -0.596     0.200
    83.789    -0.597     0.200
    84.093    -1.541     0.200
    84.094    -1.542     0.200
    85.190    -0.533     0.200
    85.190    -0.560     0.200
    85.481    -1.915     0.200
    85.481    -1.681     0.200
    85.520     0.207     0.200
    87.061     0.305     0.200
    87.061     1.731     0.200
    88.614    -2.553     0.200
    95.649     0.150     0.200
    95.649     0.150     0.200
    18.957    -0.067     0.200
    20.117     1.190     0.200
    22.042    -1.671     0.200
    22.355     2.725     0.200
    22.450     3.713     0.200
    23.466     3.369     0.200
    23.466    -1.060     0.200
    23.592     0.121     0.200
    23.764    -1.561     0.200
    23.762     0.567     0.200
    23.880     3.219     0.200
    24.703     4.065     0.200
    24.936     0.709     0.200
    25.372     5.278     0.200
    25.805     0.896     0.200
    25.805    -0.624     0.200
    25.952     0.567     0.200
    26.100     0.707     0.200
    26.099    -0.034     0.200
    27.491     1.547     0.200
    27.548     0.859     0.200
    27.994    -1.726     0.200
    28.123    -0.111     0.200
    29.298    -3.178     0.200
    31.427    -1.484     0.200
    31.432    -1.507     0.200
    31.432    -1.101     0.200
    31.436    -1.378     0.200
    31.820     2.464     0.200
    32.649     2.696     0.200
    33.656     2.598     0.200
    34.264    -0.273     0.200
    34.706     1.588     0.200
    34.706     1.416     0.200
    34.825    -0.622     0.200
    34.826    -0.602     0.200
    34.826    -1.313     0.200
    36.422     2.140     0.200
    40.544     1.724     0.200
    40.544     0.724     0.200
    40.753    -0.663     0.200
    44.094    -0.374     0.200
    46.136     1.036     0.200
    50.968    -0.159     0.200
    50.968     0.572     0.200
    50.968     0.369     0.200
    51.852     2.601     0.200
    52.056     1.044     0.200
    52.151    -0.162     0.200
    53.847    -1.326     0.200
    53.847    -1.123     0.200
    53.847    -1.346     0.200
    54.035     1.281     0.200
    54.035    -0.395     0.200
    54.622    -1.001     0.200
    55.094    -1.511     0.200
    55.095    -0.446     0.200
    55.754    -0.177     0.200
    55.782     0.209     0.200
    55.851    -0.209     0.200
    56.941    -1.503     0.200
    56.941    -0.694     0.200
    60.684    -0.320     0.200
    60.756    -0.908     0.200
    65.022    -1.576     0.200
    65.699    -0.812     0.200
    68.281    -1.242     0.200
    68.281    -1.102     0.200
    85.104     1.249     0.200
    87.146     1.698     0.200
    31.331    -0.545     0.200
    34.725    -1.030     0.200
    25.490     2.070     0.200
    34.629    -2.007     0.200
    40.722     0.117     0.200
    50.965     0.638     0.200
    53.932    -0.875     0.200
    83.912    -0.579     0.200
    19.970     0.853     0.200
    25.736    -0.485     0.200
    31.339    -1.589     0.200
    34.724    -1.262     0.200
    51.007    -0.006     0.200
    18.968    -1.310     0.200
    23.477     0.011     0.200
    23.606    -0.399     0.200
    23.776     0.057     0.200
    25.815     0.780     0.200
    25.956    -1.812     0.200
    25.911     0.461     0.200
    26.113     0.551     0.200
    27.106     0.993     0.200
    27.477    -1.806     0.200
    27.999    -2.344     0.200
    27.999    -1.938     0.200
    31.434    -2.043     0.200
    31.434    -1.879     0.200
    31.434    -2.052     0.200
    31.438    -2.241     0.200
    34.272     0.254     0.200
    34.827    -1.407     0.200
    34.828    -1.891     0.200
    50.971     0.559     0.200
    50.971     0.387     0.200
    50.971     0.387     0.200
    50.971     0.669     0.200
    55.097     0.465     0.200
    19.767     0.557     0.200
    23.078    -0.472     0.200
    23.259     0.689     0.200
    23.320    -0.270     0.200
    25.515     0.926     0.200
    25.515     0.371     0.200
    25.515     1.160     0.200
    25.575    -0.075     0.200
    25.699     0.137     0.200
    27.679    -2.013     0.200
    27.679    -1.177     0.200
    27.771     0.089     0.200
    31.256    -2.355     0.200
    31.256    -2.354     0.200
    31.256    -0.643     0.200
    31.260    -0.273     0.200
    34.055     1.058     0.200
    34.622    -1.626     0.200
    34.623    -1.345     0.200
    34.623    -1.142     0.200
    40.729     0.873     0.200
    40.729     0.873     0.200
    44.741    -2.396     0.200
    44.741    -1.552     0.200
    50.979     0.981     0.200
    50.979     0.606     0.200
    50.979     0.598     0.200
    50.979     0.301     0.200
    51.168     1.070     0.200
    51.978     0.321     0.200
    53.943    -1.133     0.200
    53.943    -0.563     0.200
    53.945    -1.153     0.200
    55.130     0.206     0.200
    55.581     0.484     0.200
    55.730     0.387     0.200
    56.867    -0.302     0.200
    56.867     0.112     0.200
    56.867    -0.162     0.200
    60.788    -0.414     0.200
    64.868    -0.102     0.200
    64.868     0.078     0.200
    65.668    -0.881     0.200
    65.668    -0.334     0.200
    68.323    -1.843     0.200
    79.304    -0.541     0.200
    81.059    -1.617     0.200
    81.787     0.400     0.200
    83.932    -0.769     0.200
    83.932    -0.316     0.200
    83.932    -0.770     0.200
    85.401    -1.210     0.200
    85.747    -0.052     0.200
    85.747     0.088     0.200
    20.121     0.303     0.200
    31.431    -1.487     0.200
    31.431    -1.485     0.200
    31.435     0.136     0.200
    34.275     1.863     0.200
    34.825    -0.648     0.200
    34.826    -1.875     0.200
    34.826    -0.656     0.200
    50.975     0.541     0.200
    50.975     0.096     0.200
    50.975     0.103     0.200
    50.975     0.002     0.200
    51.165     0.408     0.200
    52.162     0.952     0.200
    55.100    -0.566     0.200
    55.101    -0.560     0.200
    68.287    -0.082     0.200
    68.287    -0.879     0.200
    31.444    -0.684     0.200
    31.450    -0.474     0.200
    31.450    -0.473     0.200
    34.843    -0.075     0.200
    34.844    -0.903     0.200
    34.844    -0.481     0.200
    50.955     0.109     0.200
    50.955     0.077     0.200
    50.955     0.085     0.200
    50.955    -0.274     0.200
    55.080    -1.073     0.200
    23.702     1.531     0.200
    25.798     3.568     0.200
    27.738     0.230     0.200
    34.748    -0.370     0.200
    51.017     0.358     0.200
    51.017     0.358     0.200
    51.017    -0.829     0.200
    53.910    -0.071     0.200
    53.912    -0.090     0.200
    55.147    -0.564     0.200
    56.976    -0.462     0.200
    65.741    -1.030     0.200
    83.757    -0.413     0.200
    83.757    -0.413     0.200
    31.363    -2.258     0.200
    31.362    -2.257     0.200
    34.295     1.575     0.200
    34.754    -1.567     0.200
    34.755    -1.575     0.200
    51.025     0.359     0.200
    51.025     0.688     0.200
    51.025     0.688     0.200
    51.025     0.359     0.200
    52.187     1.418     0.200
    53.911    -1.255     0.200
    53.914    -1.275     0.200
    55.153    -0.189     0.200
    56.989     0.460     0.200
    56.989     0.772     0.200
    60.814     0.323     0.200
    63.809    -1.545     0.200
    31.328    -2.110     0.200
    34.707    -0.927     0.200
    50.977     0.629     0.200
    15.132     7.390     0.200
    15.190     5.491     0.200
    15.449     5.491     0.200
    15.445     3.450     0.200
    15.897     3.964     0.200
    16.260     6.294     0.200
    18.440     1.300     0.200
    18.588    -1.619     0.200
    18.975     0.626     0.200
    19.154    -0.946     0.200
    19.154    -1.296     0.200
    19.345     0.164     0.200
    19.345    -1.347     0.200
    19.525     0.200     0.200
    19.784     0.337     0.200
    19.784     0.670     0.200
    20.386    -1.951     0.200
    20.882     0.455     0.200
    21.200     1.810     0.200
    21.199     3.321     0.200
    21.199    -0.429     0.200
    21.220     3.392     0.200
    21.220    -1.548     0.200
    21.694     2.603     0.200
    21.848    -1.386     0.200
    21.910     4.789     0.200
    22.396     3.301     0.200
    22.470     4.509     0.200
    22.611     4.713     0.200
    22.673     0.354     0.200
    22.911     2.196     0.200
    22.911     4.234     0.200
    22.918     4.561     0.200
    23.037    -1.455     0.200
    23.101     2.428     0.200
    23.101     0.299     0.200
    23.301     2.331     0.200
    23.494     2.697     0.200
    23.764     3.496     0.200
    24.144     2.220     0.200
    24.312     3.088     0.200
    24.356     1.193     0.200
    24.353    -1.204     0.200
    24.357    -0.899     0.200
    24.394     1.839     0.200
    24.537     2.639     0.200
    24.859     3.008     0.200
    24.910    -0.683     0.200
    24.909     3.449     0.200
    24.992     4.700     0.200
    24.997     2.553     0.200
    25.017     2.873     0.200
    25.081     3.490     0.200
    25.101     2.000     0.200
    25.384     3.237     0.200
    25.467    -1.351     0.200
    25.535     1.082     0.200
    25.570     0.949     0.200
    26.315     4.598     0.200
    26.418     1.367     0.200
    27.568     3.022     0.200
    27.699    -0.751     0.200
    27.736     0.420     0.200
    27.736    -0.580     0.200
    27.875     0.762     0.200
    30.135    -0.630     0.200
    30.135     0.797     0.200
    30.135    -0.903     0.200
    30.930     0.874     0.200
    31.282    -1.426     0.200
    31.282    -2.036     0.200
    31.287    -1.660     0.200
    31.287    -1.900     0.200
    31.309    -2.475     0.200
    31.835     1.904     0.200
    32.811     3.649     0.200
    34.008     1.107     0.200
    34.652    -1.443     0.200
    34.652    -1.969     0.200
    35.116    -0.774     0.200
    35.116     0.807     0.200
    35.116    -0.773     0.200
    36.433     1.727     0.200
    37.037    -0.314     0.200
    38.138     1.261     0.200
    38.239     1.011     0.200
    38.934     1.269     0.200
    39.512     1.338     0.200
    39.973     0.533     0.200
    39.973    -1.392     0.200
    40.138     0.536     0.200
    40.150     0.233     0.200
    40.317     0.554     0.200
    40.405     0.525     0.200
    40.476    -1.775     0.200
    40.517    -1.303     0.200
    40.532     1.344     0.200
    40.700     0.159     0.200
    40.700    -0.113     0.200
    41.768     0.407     0.200
    43.793     2.098     0.200
    43.906    -1.089     0.200
    44.004    -2.723     0.200
    44.773    -0.221     0.200
    44.773    -1.571     0.200
    45.758     1.513     0.200
    46.103     2.188     0.200
    48.572    -0.343     0.200
    50.791     0.861     0.200
    50.940     0.640     0.200
    50.940    -0.610     0.200
    51.128    -0.479     0.200
    51.289    -0.783     0.200
    51.710     3.063     0.200
    51.931    -0.985     0.200
    52.521     1.329     0.200
    53.907    -0.606     0.200
    53.907    -0.175     0.200
    53.907    -1.055     0.200
    53.925     1.883     0.200
    53.925     0.897     0.200
    53.925     1.486     0.200
    55.092    -0.004     0.200
    55.092     0.284     0.200
    55.092     0.115     0.200
    55.092    -0.045     0.200
    55.534    -0.375     0.200
    56.824    -0.986     0.200
    57.013     0.770     0.200
    60.749     0.171     0.200
    60.749    -0.383     0.200
    60.749    -0.573     0.200
    61.973    -0.751     0.200
    61.973    -1.060     0.200
    63.806     0.555     0.200
    63.823     0.091     0.200
    63.937    -0.631     0.200
    63.959     0.578     0.200
    64.556     0.475     0.200
    64.658     0.773     0.200
    64.822     0.979     0.200
    64.822    -0.651     0.200
    65.280     0.623     0.200
    65.573     0.072     0.200
    65.617     1.033     0.200
    65.626    -0.146     0.200
    65.638    -0.020     0.200
    65.638     0.803     0.200
    65.642     1.364     0.200
    65.704    -0.264     0.200
    65.984     0.100     0.200
    66.066    -0.896     0.200
    66.262     1.942     0.200
    66.368     1.334     0.200
    66.923     1.295     0.200
    67.301    -0.054     0.200
    67.643     1.261     0.200
    68.284    -0.750     0.200
    68.284    -0.560     0.200
    68.517     1.612     0.200
    74.576    -0.735     0.200
    75.347    -0.688     0.200
    75.383     0.729     0.200
    75.383    -0.396     0.200
    75.963    -2.015     0.200
    76.395    -2.672     0.200
    76.610    -0.686     0.200
    76.689    -0.130     0.200
    76.838     0.243     0.200
    76.838     0.993     0.200
    76.838    -1.047     0.200
    76.863    -0.115     0.200
    77.303    -1.523     0.200
    77.449    -2.109     0.200
    78.181    -1.352     0.200
    78.532     0.074     0.200
    79.001    -1.702     0.200
    79.056    -1.906     0.200
    79.160    -1.273     0.200
    79.816    -2.047     0.200
    80.211    -1.485     0.200
    80.349     1.074     0.200
    80.447    -1.254     0.200
    81.064    -1.805     0.200
    81.064    -1.185     0.200
    81.790    -0.811     0.200
    82.897     0.009     0.200
    83.175     0.142     0.200
    83.487    -1.837     0.200
    83.817    -1.363     0.200
    83.887    -0.136     0.200
    83.887    -0.846     0.200
    83.887    -0.186     0.200
    84.513     0.549     0.200
    84.929    -0.189     0.200
    85.153    -1.084     0.200
    85.153    -0.793     0.200
    85.359    -1.518     0.200
    85.359    -1.622     0.200
    85.538    -1.214     0.200
    85.875    -0.156     0.200
    86.578    -0.451     0.200
    86.638     1.742     0.200
    86.638     1.635     0.200
    86.638     2.325     0.200
    86.850     0.468     0.200
    86.970     5.223     0.200
    87.176    -1.482     0.200
    88.299    -2.345     0.200
    88.537    -0.666     0.200
    88.537    -0.426     0.200
    90.197     0.249     0.200
    92.107    -2.117     0.200
    92.107    -1.541     0.200
    92.441     2.942     0.200
    92.441     2.842     0.200
    94.648     0.006     0.200
    95.037     1.103     0.200
    95.305    -0.228     0.200
    95.505    -0.033     0.200
    15.487     6.856     0.200
    15.678     3.601     0.200
    15.903     3.085     0.200
    16.047     2.120     0.200
    16.645     4.280     0.200
    18.527    -0.865     0.200
    18.707    -1.080     0.200
    19.104    -0.397     0.200
    19.529    -2.042     0.200
    19.986     0.915     0.200
    20.016     0.692     0.200
    20.120    -0.245     0.200
    20.497     0.363     0.200
    20.497    -1.536     0.200
    20.847    -1.443     0.200
    21.756     0.852     0.200
    21.838     4.103     0.200
    21.838     0.232     0.200
    22.207     4.253     0.200
    22.374     0.187     0.200
    22.436     2.721     0.200
    22.521     2.814     0.200
    22.513     1.397     0.200
    22.604     2.937     0.200
    22.947     3.504     0.200
    23.421     3.611     0.200
    23.480     2.006     0.200
    23.614     0.985     0.200
    23.861     1.931     0.200
    24.360     1.272     0.200
    24.333     3.020     0.200
    24.461     0.650     0.200
    24.511    -0.595     0.200
    24.762     2.507     0.200
    24.846     3.246     0.200
    24.992     2.918     0.200
    24.992     0.908     0.200
    25.381     2.179     0.200
    25.447     4.084     0.200
    25.517     2.744     0.200
    25.543     3.112     0.200
    25.958     1.046     0.200
    25.958     1.497     0.200
    25.958     0.546     0.200
    26.055    -0.330     0.200
    26.174     0.775     0.200
    26.174    -0.409     0.200
    26.173    -0.403     0.200
    27.612     0.225     0.200
    27.669    -0.285     0.200
    27.855    -0.922     0.200
    27.855    -1.330     0.200
    27.846     0.647     0.200
    27.846    -0.353     0.200
    28.297     1.326     0.200
    30.228    -1.501     0.200
    30.845    -0.358     0.200
    31.265    -1.561     0.200
    31.270    -1.208     0.200
    31.270    -1.978     0.200
    31.993     3.136     0.200
    32.810     3.971     0.200
    34.428     2.302     0.200
    34.428     2.083     0.200
    34.667    -0.441     0.200
    34.819     0.087     0.200
    34.819    -0.898     0.200
    34.891    -1.419     0.200
    36.594     1.461     0.200
    36.658     0.920     0.200
    38.553     0.980     0.200
    38.661     0.769     0.200
    39.359     1.031     0.200
    39.697    -0.748     0.200
    39.929     1.077     0.200
    40.531     1.277     0.200
    40.611    -1.368     0.200
    40.559     0.359     0.200
    40.571     0.256     0.200
    40.706     0.238     0.200
    40.706    -0.261     0.200
    40.735     0.400     0.200
    40.826     0.650     0.200
    41.342     0.203     0.200
    42.185     0.604     0.200
    43.719    -1.331     0.200
    43.781    -2.027     0.200
    44.729    -0.368     0.200
    44.729    -2.188     0.200
    46.309     3.168     0.200
    48.456    -0.146     0.200
    50.691    -1.386     0.200
    50.797    -0.376     0.200
    50.800    -0.402     0.200
    51.142     0.719     0.200
    51.142     0.670     0.200
    51.142    -0.460     0.200
    51.160     0.483     0.200
    51.332     0.094     0.200
    52.183    -0.265     0.200
    52.183    -0.925     0.200
    52.319     1.157     0.200
    52.319    -0.172     0.200
    53.567     2.114     0.200
    53.567     1.185     0.200
    53.905     1.776     0.200
    54.017    -0.295     0.200
    54.017    -1.023     0.200
    54.042     2.214     0.200
    55.267     0.568     0.200
    55.267    -0.051     0.200
    55.267    -0.331     0.200
    55.268    -0.174     0.200
    55.922    -0.560     0.200
    57.114    -0.351     0.200
    60.928     0.707     0.200
    60.928    -0.712     0.200
    60.928    -0.262     0.200
    65.191     1.127     0.200
    65.191    -0.081     0.200
    65.191    -0.731     0.200
    65.873    -0.439     0.200
    65.873    -0.750     0.200
    65.977     1.474     0.200
    66.193     1.079     0.200
    66.799     1.609     0.200
    67.462     0.013     0.200
    68.454    -0.225     0.200
    68.792    -0.945     0.200
    69.057     1.172     0.200
    75.878    -0.647     0.200
    75.949    -2.555     0.200
    76.290     1.104     0.200
    76.646    -1.803     0.200
    77.006     1.047     0.200
    77.154     2.527     0.200
    77.154    -0.913     0.200
    77.690    -0.674     0.200
    77.752    -0.659     0.200
    78.039     0.286     0.200
    79.296    -1.041     0.200
    79.385     0.073     0.200
    80.625    -1.052     0.200
    81.374    -0.636     0.200
    83.036    -0.695     0.200
    83.199     1.225     0.200
    83.849    -0.119     0.200
    84.238     0.430     0.200
    84.238     0.900     0.200
    84.238    -0.500     0.200
    85.275    -0.136     0.200
    85.275     0.374     0.200
    85.598    -0.036     0.200
    85.598    -0.736     0.200
    85.598    -0.936     0.200
    87.253     1.792     0.200
    88.505    -1.245     0.200
    88.686    -1.663     0.200
    88.801    -0.669     0.200
    92.209     0.188     0.200
    95.762    -0.402     0.200
    19.987     0.012     0.200
    25.941    -0.029     0.200
    25.941     0.659     0.200
    31.277    -2.050     0.200
    31.278    -2.056     0.200
    34.412    -0.101     0.200
    34.674    -1.742     0.200
    34.820     2.346     0.200
    44.737    -0.687     0.200
    44.737    -1.031     0.200
    51.130     0.464     0.200
    51.130     0.973     0.200
    51.130     0.976     0.200
    51.130     0.804     0.200
    52.183    -2.146     0.200
    54.008    -1.593     0.200
    55.256    -1.343     0.200
    55.257     0.535     0.200
    56.008    -0.018     0.200
    57.101     0.039     0.200
    57.101     0.909     0.200
    60.917     0.091     0.200
    65.860    -0.279     0.200
    80.631     0.049     0.200
    84.223     0.419     0.200
    84.223     0.412     0.200
    14.822     5.375     0.200
    15.118     3.886     0.200
    15.505     4.141     0.200
    15.991     4.692     0.200
    18.983    -1.247     0.200
    20.036     1.182     0.200
    20.840    -0.714     0.200
    21.355     2.643     0.200
    21.686     0.792     0.200
    21.753     1.192     0.200
    22.392     3.747     0.200
    22.430     2.348     0.200
    22.529     0.589     0.200
    22.912     0.934     0.200
    23.493     2.814     0.200
    23.493     1.423     0.200
    23.576    -0.475     0.200
    23.750     1.026     0.200
    23.823     2.151     0.200
    24.213    -1.816     0.200
    24.216     3.561     0.200
    24.262     3.041     0.200
    24.725     3.513     0.200
    24.908     1.931     0.200
    25.259     1.859     0.200
    25.328     1.933     0.200
    25.836     0.371     0.200
    25.836     3.022     0.200
    25.836     0.063     0.200
    26.080     0.210     0.200
    26.080    -0.290     0.200
    26.080    -0.284     0.200
    26.958     1.991     0.200
    27.571     0.174     0.200
    27.748    -0.001     0.200
    27.748    -0.501     0.200
    27.913    -0.781     0.200
    27.913     0.030     0.200
    28.186    -0.215     0.200
    31.350    -1.841     0.200
    31.356    -1.727     0.200
    31.356    -1.387     0.200
    31.360    -1.252     0.200
    31.889     1.918     0.200
    32.726     1.480     0.200
    34.306     1.210     0.200
    34.306    -0.591     0.200
    34.748    -1.067     0.200
    34.748    -1.218     0.200
    34.785    -0.008     0.200
    36.033     1.333     0.200
    36.491     1.719     0.200
    38.431     1.275     0.200
    38.539     1.265     0.200
    39.237     1.322     0.200
    39.358     0.207     0.200
    39.659    -0.603     0.200
    39.659    -0.904     0.200
    39.808     1.361     0.200
    40.149     1.130     0.200
    40.437     0.639     0.200
    40.449     0.436     0.200
    40.614     0.578     0.200
    40.621     0.396     0.200
    40.621     0.916     0.200
    40.673    -0.280     0.200
    40.705     0.529     0.200
    41.221     0.377     0.200
    42.063     0.571     0.200
    43.150    -0.509     0.200
    43.734    -0.268     0.200
    44.016    -0.354     0.200
    44.818    -0.504     0.200
    44.818    -0.654     0.200
    45.695     0.983     0.200
    46.201     1.695     0.200
    48.048    -0.308     0.200
    50.797     0.280     0.200
    50.800     0.256     0.200
    51.034     0.556     0.200
    51.034     0.326     0.200
    51.224     0.680     0.200
    51.907     3.068     0.200
    52.137     0.358     0.200
    52.198     0.601     0.200
    53.919    -0.565     0.200
    54.093     0.440     0.200
    55.162     0.185     0.200
    55.904     0.716     0.200
    56.999     0.543     0.200
    60.823     0.184     0.200
    63.815    -0.201     0.200
    65.071     0.478     0.200
    65.761    -0.918     0.200
    67.359    -0.251     0.200
    68.349    -1.090     0.200
    68.349    -0.830     0.200
    75.756     0.133     0.200
    75.850    -1.305     0.200
    76.173     0.955     0.200
    77.037    -0.034     0.200
    80.626    -2.601     0.200
    81.369    -0.022     0.200
    83.040    -0.329     0.200
    83.761    -0.809     0.200
    84.119    -0.435     0.200
    84.119     1.090     0.200
    84.119     0.379     0.200
    85.176    -1.145     0.200
    85.176    -1.159     0.200
    85.176    -0.745     0.200
    85.337    -0.754     0.200
    85.456     0.456     0.200
    85.487    -2.011     0.200
    85.487    -0.299     0.200
    86.823     0.406     0.200
    87.144     1.241     0.200
    88.699    -1.747     0.200
    92.112    -1.680     0.200
    92.112    -1.270     0.200
    92.112    -1.266     0.200
    95.132    -0.474     0.200
    95.652    -0.048     0.200
    25.517     2.014     0.200
    25.517     2.014     0.200
    26.884     1.112     0.200
    27.678    -1.024     0.200
    31.255    -1.618     0.200
    31.255    -1.615     0.200
    34.621    -0.766     0.200
    34.621    -2.628     0.200
    38.187     1.240     0.200
    38.288     1.189     0.200
    38.983     1.350     0.200
    39.561     1.622     0.200
    39.904     1.369     0.200
    39.984    -0.717     0.200
    40.187     0.721     0.200
    40.199     0.719     0.200
    40.366     0.739     0.200
    40.454     1.112     0.200
    40.731    -1.819     0.200
    40.731    -1.817     0.200
    41.817     0.798     0.200
    42.567    -3.233     0.200
    50.981     0.891     0.200
    50.981     1.121     0.200
    50.981     1.121     0.200
    50.981     0.272     0.200
    51.979     1.040     0.200
    53.944    -1.101     0.200
    53.947    -1.121     0.200
    55.132     0.279     0.200
    56.869     0.259     0.200
    64.870     1.675     0.200
    81.060    -0.882     0.200
    81.060    -0.882     0.200
    81.788    -0.200     0.200
    83.934    -0.226     0.200
    83.934    -0.226     0.200
    85.402    -1.235     0.200
    85.748    -1.666     0.200
    14.756     3.291     0.200
    15.077     6.033     0.200
    15.431     4.085     0.200
    15.936     4.413     0.200
    19.520    -1.828     0.200
    19.973    -0.088     0.200
    19.973     0.213     0.200
    20.598    -0.256     0.200
    20.775     0.606     0.200
    20.775     0.465     0.200
    20.953    -0.218     0.200
    21.292     1.715     0.200
    21.711     0.751     0.200
    21.985     1.682     0.200
    22.122     2.724     0.200
    22.305     2.166     0.200
    22.479    -0.081     0.200
    22.586     3.283     0.200
    23.379     2.200     0.200
    23.492    -0.296     0.200
    23.542     0.102     0.200
    23.542    -0.308     0.200
    23.633    -1.783     0.200
    23.718     0.493     0.200
    23.718    -0.016     0.200
    23.762     1.786     0.200
    23.762     0.376     0.200
    23.938    -0.241     0.200
    24.159     1.065     0.200
    24.204     4.651     0.200
    24.625     1.112     0.200
    24.646     2.925     0.200
    24.721     3.639     0.200
    24.865     2.227     0.200
    24.865    -0.162     0.200
    25.365     2.683     0.200
    25.350     2.613     0.200
    25.815     0.338     0.200
    25.839     0.407     0.200
    25.839     1.581     0.200
    25.895     2.574     0.200
    26.044    -0.948     0.200
    26.043    -0.436     0.200
    26.923    -0.515     0.200
    27.635    -0.734     0.200
    27.852    -1.775     0.200
    27.793     0.183     0.200
    28.221     1.064     0.200
    31.304    -3.096     0.200
    31.930     1.741     0.200
    32.778     3.803     0.200
    34.320     1.275     0.200
    34.694    -1.468     0.200
    34.694    -0.767     0.200
    34.851    -0.388     0.200
    34.851     1.483     0.200
    36.531     1.654     0.200
    38.445     1.640     0.200
    38.553     1.238     0.200
    39.250     1.397     0.200
    39.724    -0.735     0.200
    39.822     1.328     0.200
    40.163     1.394     0.200
    40.450     0.511     0.200
    40.463     0.008     0.200
    40.627     0.747     0.200
    40.674     0.806     0.200
    40.718     0.100     0.200
    46.238     2.384     0.200
    51.071     0.403     0.200
    51.071     0.132     0.200
    51.071     0.804     0.200
    51.934     5.051     0.200
    52.216     0.548     0.200
    53.964    -1.516     0.200
    53.964    -1.041     0.200
    53.964    -0.690     0.200
    55.201     0.775     0.200
    55.201     0.596     0.200
    57.028    -0.085     0.200
    57.028     0.017     0.200
    60.862     0.493     0.200
    60.862     1.032     0.200
    63.870     0.085     0.200
    65.091    -0.157     0.200
    65.091     0.962     0.200
    65.794    -0.729     0.200
    65.794    -1.688     0.200
    67.274    -0.238     0.200
    68.390    -0.949     0.200
    68.390     0.332     0.200
    75.759     0.591     0.200
    77.613    -0.287     0.200
    79.219    -0.865     0.200
    80.691    -1.181     0.200
    81.435     0.590     0.200
    82.489     1.628     0.200
    83.105    -1.076     0.200
    83.812     0.265     0.200
    84.141    -1.203     0.200
    84.141    -1.203     0.200
    85.220    -0.496     0.200
    85.220    -0.547     0.200
    85.220    -0.195     0.200
    85.521    -0.157     0.200
    87.121     0.701     0.200
    92.158    -0.598     0.200
    25.444     0.703     0.200
    27.683    -0.662     0.200
    31.281    -1.662     0.200
    34.644    -0.461     0.200
    39.995    -0.444     0.200
    50.936     1.267     0.200
    53.909     0.327     0.200
    68.282    -2.244     0.200
    81.095    -1.823     0.200
    83.873    -1.415     0.200
    84.068    -3.014     0.200
    85.353    -2.471     0.200
    25.492     2.177     0.200
    25.492     2.177     0.200
    25.492     1.997     0.200
    31.250    -0.517     0.200
    31.250    -0.520     0.200
    31.254    -0.691     0.200
    34.615    -1.261     0.200
    34.615    -0.990     0.200
    40.737    -0.003     0.200
    40.737     0.001     0.200
    50.975     0.237     0.200
    50.975     0.239     0.200
    50.975     0.707     0.200
    53.944    -0.359     0.200
    53.947    -0.378     0.200
    53.959     1.065     0.200
    55.128    -0.669     0.200
    55.565    -0.129     0.200
    56.858     0.300     0.200
    64.854    -0.798     0.200
    65.661    -0.624     0.200
    81.817     0.331     0.200
    83.512    -0.501     0.200
    83.854    -0.692     0.200
    83.854    -0.692     0.200
    83.919    -0.212     0.200
    83.919    -0.213     0.200
    83.919    -1.283     0.200
    85.394    -2.185     0.200
    85.776    -0.480     0.200
    85.909     0.792     0.200
    88.571    -0.822     0.200
    14.435     6.119     0.200
    15.426     9.029     0.200
    15.439     3.156     0.200
    16.280     1.565     0.200
    18.419     2.670     0.200
    19.762    -0.469     0.200
    20.862     0.436     0.200
    21.540     2.599     0.200
    22.009     4.572     0.200
    22.386     0.754     0.200
    22.494     1.904     0.200
    22.696     1.557     0.200
    22.903    -0.547     0.200
    23.042    -1.139     0.200
    23.117     1.906     0.200
    23.117     1.707     0.200
    23.222     0.860     0.200
    23.174     0.507     0.200
    23.291    -1.212     0.200
    23.759     1.897     0.200
    23.777     2.331     0.200
    24.137    -0.062     0.200
    24.140     1.211     0.200
    24.327     3.105     0.200
    24.254     1.002     0.200
    24.546     2.208     0.200
    24.856     2.188     0.200
    24.927     4.643     0.200
    25.011     1.477     0.200
    25.007     3.114     0.200
    25.123     0.863     0.200
    25.383    -0.408     0.200
    25.539     0.254     0.200
    25.484     0.836     0.200
    25.538     0.897     0.200
    25.701     1.897     0.200
    26.423    -2.420     0.200
    27.676    -0.721     0.200
    27.759     0.465     0.200
    27.759     1.363     0.200
    27.895    -0.762     0.200
    28.087     0.740     0.200
    29.814    -0.708     0.200
    29.814    -0.688     0.200
    30.953     0.926     0.200
    31.258    -0.763     0.200
    31.263    -2.208     0.200
    31.263    -0.208     0.200
    31.263    -1.257     0.200
    31.268    -0.983     0.200
    31.859     1.655     0.200
    32.834     2.799     0.200
    34.028     0.697     0.200
    34.628    -0.560     0.200
    34.628    -0.220     0.200
    35.135     0.788     0.200
    35.135    -0.408     0.200
    35.177     1.954     0.200
    36.456     1.285     0.200
    38.033    -0.869     0.200
    38.157     1.355     0.200
    38.258     1.106     0.200
    38.953     1.466     0.200
    39.532     1.435     0.200
    39.875     1.280     0.200
    39.993    -0.802     0.200
    39.993     0.098     0.200
    40.157     0.635     0.200
    40.170     0.632     0.200
    40.336     0.852     0.200
    40.424     0.925     0.200
    40.555    -0.660     0.200
    40.723     0.591     0.200
    40.723    -0.249     0.200
    40.943     0.436     0.200
    41.743     0.967     0.200
    41.787     0.507     0.200
    43.936    -0.216     0.200
    44.749    -1.924     0.200
    46.126     2.067     0.200
    50.963     0.828     0.200
    50.963     0.498     0.200
    51.151    -0.290     0.200
    51.250     0.234     0.200
    51.253     0.207     0.200
    51.732     2.663     0.200
    51.951     0.926     0.200
    52.433    -0.359     0.200
    53.947     1.896     0.200
    53.947     1.136     0.200
    53.931    -0.785     0.200
    53.931    -0.285     0.200
    55.115     0.409     0.200
    55.115     0.530     0.200
    55.554     0.443     0.200
    56.846     0.420     0.200
    60.772    -0.378     0.200
    60.772     0.163     0.200
    63.960    -1.563     0.200
    64.739     0.186     0.200
    64.843     1.005     0.200
    64.843     1.259     0.200
    65.649    -0.397     0.200
    67.324     0.163     0.200
    68.308    -0.930     0.200
    68.308    -0.721     0.200
    75.400     0.374     0.200
    75.848    -1.890     0.200
    75.985    -1.571     0.200
    76.710     0.489     0.200
    76.860     0.768     0.200
    77.472    -1.267     0.200
    78.196    -0.212     0.200
    78.545     0.668     0.200
    79.007    -2.768     0.200
    79.079    -1.462     0.200
    79.182    -1.331     0.200
    80.585    -2.530     0.200
    80.662     1.361     0.200
    81.080    -1.671     0.200
    81.080    -1.930     0.200
    81.806     0.771     0.200
    83.502    -0.157     0.200
    83.840    -1.805     0.200
    83.908    -0.576     0.200
    83.908    -0.435     0.200
    85.177    -1.266     0.200
    85.177    -1.041     0.200
    85.382    -1.642     0.200
    85.382    -0.866     0.200
    85.427     2.505     0.200
    86.598    -0.682     0.200
    86.646    -1.119     0.200
    86.646     1.381     0.200
    86.646     2.451     0.200
    88.559    -0.501     0.200
    92.131    -2.155     0.200
    92.131    -1.786     0.200
    92.463     0.908     0.200
    94.671    -0.859     0.200
    95.060    -2.532     0.200
    95.321    -0.347     0.200
    95.556    -0.403     0.200
    96.847    -4.664     0.200
    99.555    -2.302     0.200
    22.480     3.381     0.200
    22.689     0.870     0.200
    23.009     0.467     0.200
    23.085     0.047     0.200
    23.269     0.780     0.200
    24.636    -0.570     0.200
    24.636    -0.566     0.200
    25.096     2.221     0.200
    25.452     1.283     0.200
    25.452     1.783     0.200
    25.507     1.388     0.200
    25.506     1.394     0.200
    25.709    -0.050     0.200
    27.680    -0.641     0.200
    27.680    -1.326     0.200
    27.743     0.827     0.200
    27.743     0.226     0.200
    31.271     1.239     0.200
    31.276    -0.736     0.200
    31.276    -0.731     0.200
    31.840     2.533     0.200
    32.823     3.710     0.200
    33.998     0.062     0.200
    34.078    -0.828     0.200
    34.639    -1.194     0.200
    34.639    -1.694     0.200
    35.140    -0.193     0.200
    37.036     0.071     0.200
    38.128     1.011     0.200
    38.229     0.965     0.200
    38.924     1.224     0.200
    39.502     1.488     0.200
    39.585     0.802     0.200
    39.845     1.032     0.200
    39.996    -0.172     0.200
    40.128     0.588     0.200
    40.140     0.384     0.200
    40.307     0.704     0.200
    40.394     0.776     0.200
    40.544    -3.064     0.200
    40.544     0.642     0.200
    40.544    -0.880     0.200
    40.711     0.017     0.200
    40.711     0.757     0.200
    41.713     0.717     0.200
    41.758     0.655     0.200
    44.026     0.569     0.200
    46.105     2.338     0.200
    48.590    -0.511     0.200
    50.942     0.087     0.200
    50.942     0.822     0.200
    50.942     0.988     0.200
    50.942     0.437     0.200
    51.706     3.856     0.200
    51.923     0.839     0.200
    52.434     0.236     0.200
    53.914    -0.212     0.200
    53.914     0.138     0.200
    53.914    -0.542     0.200
    53.923     1.274     0.200
    55.095     0.403     0.200
    55.095     0.251     0.200
    55.095     0.442     0.200
    55.526     1.346     0.200
    55.625    -0.567     0.200
    55.680     0.289     0.200
    56.821    -0.306     0.200
    56.821     0.194     0.200
    60.752     0.255     0.200
    60.752     0.576     0.200
    61.018     0.676     0.200
    61.994    -1.241     0.200
    63.951    -0.880     0.200
    64.815     0.535     0.200
    64.815     1.234     0.200
    64.815     1.314     0.200
    65.626     0.076     0.200
    68.288    -0.946     0.200
    68.288    -1.114     0.200
    68.288    -0.604     0.200
    75.959    -1.632     0.200
    76.179     0.012     0.200
    76.684    -0.352     0.200
    76.834    -1.098     0.200
    77.449    -1.352     0.200
    78.209    -0.294     0.200
    79.056    -0.749     0.200
    79.160    -1.421     0.200
    80.675    -2.522     0.200
    81.093    -1.479     0.200
    81.093    -2.852     0.200
    81.818     0.045     0.200
    83.516    -0.292     0.200
    83.827    -0.754     0.200
    83.877     0.760     0.200
    83.881    -0.299     0.200
    83.881    -0.610     0.200
    85.046    -0.971     0.200
    85.159    -1.117     0.200
    85.359    -1.317     0.200
    85.409    -0.613     0.200
    85.776    -0.441     0.200
    85.914     0.215     0.200
    86.571    -0.062     0.200
    86.613     0.282     0.200
    92.114    -2.170     0.200
    95.039    -0.751     0.200
    95.505    -1.482     0.200
    14.106     7.190     0.200
    14.443     4.252     0.200
    14.763     4.078     0.200
    15.136     5.320     0.200
    15.481     4.486     0.200
    15.643     4.167     0.200
    15.822     3.345     0.200
    15.899     2.844     0.200
    16.472     2.880     0.200
    19.547    -0.158     0.200
    19.649    -1.002     0.200
    19.868    -1.091     0.200
    19.982    -1.438     0.200
    19.999    -1.140     0.200
    19.999    -1.015     0.200
    20.290     0.216     0.200
    20.668    -0.495     0.200
    20.668    -1.093     0.200
    20.766     0.744     0.200
    20.766     0.604     0.200
    20.942    -0.252     0.200
    21.274     3.659     0.200
    21.606    -0.516     0.200
    21.658     0.344     0.200
    22.104     2.952     0.200
    22.247     1.127     0.200
    22.428     1.196     0.200
    22.546     2.447     0.200
    22.826     2.169     0.200
    23.071     1.185     0.200
    23.351    -0.368     0.200
    23.351     1.534     0.200
    23.353     1.911     0.200
    23.420     2.505     0.200
    23.420     0.294     0.200
    23.482     1.055     0.200
    23.482    -0.335     0.200
    23.679    -0.049     0.200
    23.679    -3.189     0.200
    23.656     0.338     0.200
    23.656     0.229     0.200
    23.736     0.612     0.200
    23.736    -0.560     0.200
    23.961     0.320     0.200
    24.130     0.704     0.200
    24.134     2.675     0.200
    24.171     3.634     0.200
    24.227     2.523     0.200
    24.391    -0.339     0.200
    24.604     1.787     0.200
    24.649     3.073     0.200
    24.812     1.389     0.200
    24.851     1.038     0.200
    25.193     4.025     0.200
    25.282     2.120     0.200
    25.282     0.518     0.200
    25.478     3.232     0.200
    25.767     0.618     0.200
    25.767     1.395     0.200
    25.854     0.085     0.200
    25.844     2.311     0.200
    25.865    -0.072     0.200
    25.986    -0.469     0.200
    25.985     0.748     0.200
    26.622     5.076     0.200
    26.863     0.601     0.200
    27.616    -0.165     0.200
    27.616    -0.614     0.200
    27.673    -0.985     0.200
    27.737    -0.348     0.200
    27.737    -0.449     0.200
    27.883     0.186     0.200
    27.883    -1.927     0.200
    27.883    -0.181     0.200
    28.008     3.537     0.200
    28.157     0.602     0.200
    30.367    -0.670     0.200
    30.786    -0.212     0.200
    30.806     1.113     0.200
    31.346    -1.043     0.200
    31.346    -0.676     0.200
    31.351    -2.043     0.200
    31.351    -2.042     0.200
    31.351    -0.889     0.200
    31.351    -1.249     0.200
    31.355    -0.436     0.200
    31.872     1.525     0.200
    32.732     3.476     0.200
    33.924    -0.084     0.200
    34.248     1.159     0.200
    34.738    -0.708     0.200
    34.739    -1.641     0.200
    34.739    -0.056     0.200
    34.835     0.354     0.200
    34.835    -0.021     0.200
    34.897     0.850     0.200
    34.897    -0.861     0.200
    36.473     0.817     0.200
    39.386     0.510     0.200
    39.706    -1.356     0.200
    40.454     0.138     0.200
    40.454     0.958     0.200
    40.646    -1.792     0.200
    40.627     0.066     0.200
    40.627     0.066     0.200
    40.627    -1.594     0.200
    41.235     0.359     0.200
    43.773     1.544     0.200
    44.004    -0.132     0.200
    44.004    -1.035     0.200
    44.818    -0.601     0.200
    44.818    -0.925     0.200
    44.818     0.434     0.200
    44.761     2.329     0.200
    46.134    -1.290     0.200
    46.176     2.411     0.200
    48.066     1.462     0.200
    48.414     0.277     0.200
    51.010    -0.103     0.200
    51.010     0.147     0.200
    51.010     0.147     0.200
    51.010    -0.064     0.200
    51.200    -0.529     0.200
    51.866     3.983     0.200
    52.146     0.299     0.200
    52.177    -0.733     0.200
    52.177    -0.494     0.200
    52.562     0.709     0.200
    53.909     0.462     0.200
    53.909    -1.073     0.200
    53.912     0.439     0.200
    54.057     2.207     0.200
    55.142    -0.571     0.200
    55.142    -0.231     0.200
    55.749    -0.042     0.200
    55.859     1.067     0.200
    56.962     0.906     0.200
    56.962    -0.293     0.200
    60.803     0.412     0.200
    60.803     0.291     0.200
    61.251    -1.675     0.200
    63.828    -0.504     0.200
    65.022    -1.642     0.200
    65.022     0.350     0.200
    65.022    -0.329     0.200
    65.730    -0.500     0.200
    65.730    -0.641     0.200
    68.331    -2.028     0.200
    68.937    -0.850     0.200
    75.686    -0.208     0.200
    76.130    -1.440     0.200
    76.459    -0.705     0.200
    76.996    -0.740     0.200
    76.996    -0.931     0.200
    77.549    -0.344     0.200
    77.818    -1.038     0.200
    78.938    -0.779     0.200
    79.086     0.152     0.200
    79.156    -1.633     0.200
    79.160    -1.757     0.200
    79.248    -2.037     0.200
    79.849    -0.609     0.200
    80.515    -1.400     0.200
    80.696     0.350     0.200
    80.696    -1.072     0.200
    81.436    -0.494     0.200
    81.666    -0.499     0.200
    83.071    -0.479     0.200
    83.112     0.148     0.200
    83.463    -0.112     0.200
    83.635     0.427     0.200
    83.763    -1.372     0.200
    83.763    -1.369     0.200
    84.072     1.079     0.200
    84.072     1.079     0.200
    84.072     0.797     0.200
    84.507    -0.531     0.200
    84.634    -1.724     0.200
    84.661    -0.478     0.200
    84.872    -0.773     0.200
    85.164    -0.642     0.200
    85.164    -0.614     0.200
    85.164     0.261     0.200
    85.164    -0.779     0.200
    85.403    -1.333     0.200
    85.439     0.483     0.200
    85.458     0.002     0.200
    85.458    -0.807     0.200
    85.458    -0.615     0.200
    85.458    -1.307     0.200
    86.872    -0.614     0.200
    87.054     2.323     0.200
    88.655    -1.573     0.200
    92.104    -0.062     0.200
    92.104    -0.058     0.200
    92.544     2.066     0.200
    14.038     5.156     0.200
    14.411     3.956     0.200
    15.090     7.248     0.200
    15.186     3.875     0.200
    15.297     4.014     0.200
    15.392     3.268     0.200
    15.477     4.269     0.200
    15.536     2.897     0.200
    15.536     3.987     0.200
    15.526     3.677     0.200
    18.241     0.380     0.200
    18.402     1.132     0.200
    19.643     0.230     0.200
    20.058     0.600     0.200
    20.337     0.103     0.200
    20.896     1.309     0.200
    20.882     0.961     0.200
    21.150     2.369     0.200
    21.150     2.870     0.200
    21.150     1.429     0.200
    21.169     1.463     0.200
    21.464     1.587     0.200
    21.501     1.088     0.200
    21.529     3.391     0.200
    21.643     1.761     0.200
    21.750     2.412     0.200
    21.798    -0.895     0.200
    21.859     1.451     0.200
    21.966     0.304     0.200
    22.214     0.733     0.200
    22.344     2.669     0.200
    22.487     2.948     0.200
    22.559     2.979     0.200
    22.559     0.819     0.200
    22.699     0.402     0.200
    22.876     1.428     0.200
    22.991     1.207     0.200
    22.991    -0.254     0.200
    23.075     1.326     0.200
    23.075     0.224     0.200
    23.172     2.303     0.200
    23.172     0.725     0.200
    23.249     0.992     0.200
    23.249    -1.508     0.200
    23.442     1.762     0.200
    23.586    -2.007     0.200
    23.612    -0.010     0.200
    23.625     1.572     0.200
    23.709     1.208     0.200
    23.730     1.111     0.200
    24.093     0.100     0.200
    24.093     1.301     0.200
    24.303    -0.124     0.200
    24.283     0.861     0.200
    24.342     0.822     0.200
    24.365    -0.034     0.200
    24.470    -1.045     0.200
    24.497     1.212     0.200
    24.837     2.817     0.200
    24.859     2.816     0.200
    24.859     0.188     0.200
    24.887     1.857     0.200
    24.966     1.643     0.200
    24.963     2.066     0.200
    24.966     0.441     0.200
    25.039     1.376     0.200
    25.092     0.591     0.200
    25.333     0.300     0.200
    25.443     1.958     0.200
    25.443     0.915     0.200
    25.443     0.806     0.200
    25.443     0.306     0.200
    25.488     0.546     0.200
    25.488     0.296     0.200
    25.488     0.341     0.200
    25.542     1.509     0.200
    25.546     0.917     0.200
    25.546     0.171     0.200
    25.700    -1.044     0.200
    26.290     3.133     0.200
    26.372    -1.007     0.200
    26.751     0.368     0.200
    26.796     1.264     0.200
    26.999     0.639     0.200
    27.009     0.342     0.200
    27.523     0.333     0.200
    27.668    -0.772     0.200
    27.668    -1.459     0.200
    27.747     0.124     0.200
    27.747    -0.177     0.200
    27.913     0.585     0.200
    27.970     0.074     0.200
    28.057     0.260     0.200
    28.065     0.086     0.200
    28.333    -0.945     0.200
    28.363     0.527     0.200
    30.146    -1.422     0.200
    30.146    -1.691     0.200
    30.390    -1.130     0.200
    30.465    -0.930     0.200
    30.955     0.861     0.200
    31.264    -0.760     0.200
    31.264    -1.873     0.200
    31.269    -1.758     0.200
    31.269    -1.757     0.200
    31.269    -2.007     0.200
    31.273    -1.672     0.200
    31.271    -2.072     0.200
    31.271    -0.346     0.200
    32.831     2.379     0.200
    33.992     0.566     0.200
    33.992    -0.044     0.200
    33.992     0.257     0.200
    34.035     1.383     0.200
    34.094    -2.129     0.200
    34.631    -1.568     0.200
    34.631    -1.087     0.200
    34.631    -1.486     0.200
    35.156     0.760     0.200
    35.156     0.186     0.200
    35.195     0.747     0.200
    36.440     1.171     0.200
    38.062    -0.245     0.200
    38.122     1.202     0.200
    38.222     1.159     0.200
    38.917     1.416     0.200
    39.202    -1.738     0.200
    39.496     1.578     0.200
    39.597    -0.562     0.200
    40.011    -0.184     0.200
    40.011    -0.309     0.200
    40.121     0.781     0.200
    40.134     0.577     0.200
    40.300     0.695     0.200
    40.388     0.769     0.200
    40.447    -0.942     0.200
    40.552     1.731     0.200
    40.552    -0.586     0.200
    40.719    -0.078     0.200
    40.719    -0.078     0.200
    40.719    -0.371     0.200
    40.907     0.577     0.200
    41.751     0.847     0.200
    42.487     0.346     0.200
    42.796    -1.170     0.200
    43.884    -0.860     0.200
    43.924    -0.736     0.200
    43.931    -1.536     0.200
    44.040    -1.703     0.200
    44.387     1.410     0.200
    44.757    -0.841     0.200
    44.757    -0.739     0.200
    45.776     0.873     0.200
    46.106     1.566     0.200
    46.106    -0.036     0.200
    48.105     0.245     0.200
    48.601     0.040     0.200
    50.779    -1.250     0.200
    50.903    -0.185     0.200
    50.943     0.616     0.200
    50.943    -0.025     0.200
    50.943     0.616     0.200
    50.943     0.616     0.200
    50.943    -0.185     0.200
    51.132    -0.103     0.200
    51.273    -1.565     0.200
    51.282     0.460     0.200
    51.285     0.435     0.200
    51.704     3.113     0.200
    51.918     0.954     0.200
    51.918     0.415     0.200
    52.419     0.592     0.200
    52.448    -1.031     0.200
    52.533     0.463     0.200
    53.620     1.774     0.200
    53.751     2.113     0.200
    53.888     1.167     0.200
    53.918    -0.182     0.200
    53.918    -1.455     0.200
    53.921    -0.198     0.200
    53.921     1.142     0.200
    53.921     1.724     0.200
    53.921     0.372     0.200
    54.163     0.831     0.200
    54.279     2.283     0.200
    54.419     1.529     0.200
    55.097     0.351     0.200
    55.098     0.091     0.200
    55.098    -0.229     0.200
    55.098    -0.936     0.200
    55.521     0.423     0.200
    55.622    -1.307     0.200
    56.819    -0.456     0.200
    56.819    -0.456     0.200
    56.819    -0.335     0.200
    57.055     0.349     0.200
    57.554    -0.449     0.200
    60.683    -0.031     0.200
    60.683    -0.043     0.200
    60.755     0.545     0.200
    60.755    -0.220     0.200
    60.755    -0.412     0.200
    61.013     0.094     0.200
    62.007    -1.096     0.200
    62.996    -0.206     0.200
    63.315    -0.197     0.200
    63.315    -0.029     0.200
    63.781     0.427     0.200
    63.797     0.172     0.200
    63.849     0.957     0.200
    63.931     0.149     0.200
    63.960    -0.579     0.200
    64.530     0.059     0.200
    64.632     0.739     0.200
    64.810     1.172     0.200
    64.810     0.954     0.200
    64.810     0.563     0.200
    65.255     0.718     0.200
    65.475     1.005     0.200
    65.549    -0.104     0.200
    65.626    -0.738     0.200
    65.626    -0.925     0.200
    65.680     0.406     0.200
    66.232     1.356     0.200
    66.343     1.128     0.200
    66.893     0.967     0.200
    67.114    -0.244     0.200
    67.308    -0.299     0.200
    68.001    -0.323     0.200
    68.311    -0.457     0.200
    68.291    -0.925     0.200
    68.291    -1.522     0.200
    68.374    -1.100     0.200
    68.487     0.578     0.200
    68.978    -0.343     0.200
    69.052    -0.613     0.200
    75.337     0.965     0.200
    75.337     0.078     0.200
    75.358    -0.456     0.200
    75.834    -1.983     0.200
    75.956    -1.578     0.200
    76.272     0.022     0.200
    76.682    -0.098     0.200
    76.832     0.254     0.200
    76.832    -0.316     0.200
    77.449    -1.614     0.200
    78.228    -0.397     0.200
    78.582     0.137     0.200
    78.582    -0.105     0.200
    78.582    -0.316     0.200
    78.984    -2.116     0.200
    79.056    -1.511     0.200
    79.161    -1.785     0.200
    79.357    -0.588     0.200
    79.387    -0.493     0.200
    79.461    -0.922     0.200
    79.673    -0.827     0.200
    79.671     0.732     0.200
    79.820    -2.476     0.200
    79.898     0.091     0.200
    79.898     0.274     0.200
    80.180    -0.762     0.200
    80.260    -1.354     0.200
    80.270    -1.109     0.200
    80.319    -1.472     0.200
    80.351    -0.607     0.200
    80.451    -0.779     0.200
    80.591    -0.745     0.200
    80.611    -0.597     0.200
    80.630    -0.742     0.200
    80.694    -0.786     0.200
    80.725    -0.632     0.200
    80.858    -0.228     0.200
    81.005    -0.364     0.200
    81.105    -0.879     0.200
    81.109    -0.769     0.200
    81.109    -1.199     0.200
    81.112    -1.625     0.200
    81.112    -1.614     0.200
    81.660     0.161     0.200
    81.836     0.307     0.200
    81.878    -0.973     0.200
    82.086    -0.785     0.200
    82.442    -0.753     0.200
    82.677    -0.134     0.200
    82.892     0.231     0.200
    83.197     0.329     0.200
    83.224     0.161     0.200
    83.374     0.147     0.200
    83.405     1.108     0.200
    83.535     0.058     0.200
    83.550    -0.688     0.200
    83.570    -0.328     0.200
    83.834    -0.744     0.200
    83.834    -0.748     0.200
    83.896     0.510     0.200
    83.877    -0.442     0.200
    83.877    -0.040     0.200
    83.877    -0.642     0.200
    83.877    -0.443     0.200
    83.877    -0.740     0.200
    83.962     0.595     0.200
    84.068     0.541     0.200
    84.503    -0.027     0.200
    84.738     0.524     0.200
    84.762    -0.205     0.200
    85.065    -1.353     0.200
    85.065    -0.458     0.200
    85.163    -1.651     0.200
    85.163    -1.627     0.200
    85.359    -1.353     0.200
    85.359    -1.728     0.200
    85.412    -1.192     0.200
    85.794    -0.595     0.200
    85.794    -0.891     0.200
    85.933     0.465     0.200
    86.566    -0.802     0.200
    86.597     1.350     0.200
    86.597     2.370     0.200
    86.597     2.049     0.200
    86.597    -0.463     0.200
    87.225    -0.195     0.200
    88.254    -2.850     0.200
    88.501    -1.603     0.200
    88.535    -0.963     0.200
    88.668    -1.801     0.200
    89.837    -2.478     0.200
    90.132     0.048     0.200
    90.196    -0.754     0.200
    92.119    -2.178     0.200
    92.119    -1.877     0.200
    92.119    -1.877     0.200
    92.441     0.036     0.200
    95.351    -0.446     0.200
    95.351    -0.443     0.200
    95.506    -0.445     0.200
    95.535    -1.279     0.200
    95.535    -1.264     0.200
    95.535    -2.178     0.200
    19.621    -0.755     0.200
    21.473     3.030     0.200
    23.351     0.561     0.200
    23.539     0.074     0.200
    25.494    -1.954     0.200
    25.838    -0.924     0.200
    25.837     0.515     0.200
    25.856     1.085     0.200
    27.511    -0.935     0.200
    27.511    -0.794     0.200
    31.009    -3.288     0.200
    31.018    -3.279     0.200
    34.392    -0.367     0.200
    34.393    -0.374     0.200
    34.395     0.318     0.200
    35.216     1.401     0.200
    51.280     0.518     0.200
    51.280     0.514     0.200
    51.280    -0.111     0.200
    52.315     0.207     0.200
    55.424    -0.775     0.200
    55.918     0.383     0.200
    56.061    -0.435     0.200
    57.189    -0.343     0.200
    65.203     0.359     0.200
    65.203    -0.036     0.200
    65.203     0.625     0.200
    81.060    -0.461     0.200
    84.265     0.694     0.200
    84.265     0.694     0.200
    85.711    -0.718     0.200
    85.774     0.138     0.200
    14.118     4.322     0.200
    17.605     2.951     0.200
    18.217     0.140     0.200
    18.387     2.365     0.200
    18.714    -0.625     0.200
    20.233     0.069     0.200
    20.617    -0.030     0.200
    22.270     3.733     0.200
    22.645     1.546     0.200
    22.805     1.654     0.200
    23.175     1.447     0.200
    23.280    -1.244     0.200
    23.378     1.512     0.200
    23.378    -0.519     0.200
    23.464     0.658     0.200
    24.011     1.466     0.200
    24.038     2.114     0.200
    24.288     0.431     0.200
    24.322    -0.270     0.200
    24.570     0.070     0.200
    24.589     2.189     0.200
    24.565     0.912     0.200
    24.801     1.657     0.200
    25.086     0.962     0.200
    25.215     0.195     0.200
    25.273     3.669     0.200
    25.341     1.845     0.200
    25.357    -0.194     0.200
    25.592     0.137     0.200
    25.594     0.260     0.200
    25.771     0.423     0.200
    25.771    -0.452     0.200
    25.770    -0.426     0.200
    25.743     0.306     0.200
    25.743     1.704     0.200
    25.743     0.204     0.200
    25.845    -0.018     0.200
    26.660    -1.089     0.200
    26.810     0.460     0.200
    27.091     1.129     0.200
    27.269    -1.171     0.200
    27.297    -0.419     0.200
    27.598    -1.399     0.200
    27.815    -1.058     0.200
    27.930     0.110     0.200
    28.342    -0.858     0.200
    28.294    -0.131     0.200
    31.115     1.175     0.200
    31.115     0.734     0.200
    31.121    -2.390     0.200
    31.120    -2.397     0.200
    31.064     0.724     0.200
    32.044     2.500     0.200
    34.277     0.514     0.200
    34.496    -0.764     0.200
    34.497    -1.315     0.200
    34.497    -0.994     0.200
    35.151     1.796     0.200
    36.643     1.670     0.200
    38.406     1.645     0.200
    38.508     1.088     0.200
    39.210    -0.012     0.200
    39.203     1.558     0.200
    39.780     1.548     0.200
    40.018     0.347     0.200
    40.018    -0.129     0.200
    40.367    -0.220     0.200
    40.407     0.752     0.200
    40.419     0.649     0.200
    40.585     0.776     0.200
    40.673     1.147     0.200
    40.690     0.710     0.200
    40.860     0.702     0.200
    40.860     0.702     0.200
    40.860     0.104     0.200
    41.192     0.572     0.200
    42.036     1.058     0.200
    42.790    -0.577     0.200
    44.074     1.363     0.200
    44.598    -2.350     0.200
    44.598     1.275     0.200
    46.326     2.480     0.200
    47.898     0.079     0.200
    48.687     0.023     0.200
    51.162     0.523     0.200
    51.162     0.472     0.200
    51.162     0.476     0.200
    51.195     2.372     0.200
    51.351     0.406     0.200
    51.960     3.357     0.200
    52.141     1.408     0.200
    52.195     0.505     0.200
    52.480    -2.109     0.200
    52.668     1.299     0.200
    54.103    -0.648     0.200
    54.103    -0.765     0.200
    54.105    -0.664     0.200
    54.167     0.882     0.200
    54.167     0.152     0.200
    55.306     0.125     0.200
    55.306    -0.437     0.200
    55.798    -0.010     0.200
    55.881     0.591     0.200
    55.940     0.186     0.200
    57.068    -0.258     0.200
    57.068     0.043     0.200
    57.068    -0.219     0.200
    60.965    -0.187     0.200
    60.965    -0.667     0.200
    61.293    -0.282     0.200
    64.080    -0.744     0.200
    65.083     0.891     0.200
    65.083     0.672     0.200
    65.083     1.001     0.200
    65.860    -0.536     0.200
    68.498    -1.515     0.200
    68.498    -1.125     0.200
    75.605     1.410     0.200
    75.659    -0.403     0.200
    76.216    -1.776     0.200
    76.939    -0.516     0.200
    77.088     0.695     0.200
    77.682    -1.628     0.200
    79.217    -2.009     0.200
    79.388    -1.744     0.200
    81.025    -0.023     0.200
    81.025    -0.023     0.200
    81.764     0.220     0.200
    83.441    -0.193     0.200
    83.963     0.266     0.200
    83.987    -0.865     0.200
    84.144    -0.683     0.200
    84.144    -1.515     0.200
    84.144    -0.683     0.200
    84.144    -0.215     0.200
    84.144    -1.484     0.200
    85.041    -1.757     0.200
    85.353    -1.504     0.200
    85.353    -1.550     0.200
    85.591    -1.669     0.200
    85.591    -1.794     0.200
    85.591    -1.693     0.200
    85.730    -1.632     0.200
    86.899     0.039     0.200
    90.367     1.649     0.200
    92.675     0.554     0.200
    95.260    -1.426     0.200
    23.660    -1.947     0.200
    25.418     2.590     0.200
    25.777     1.012     0.200
    27.748    -0.757     0.200
    31.343    -1.179     0.200
    31.343    -1.174     0.200
    34.707    -0.731     0.200
    50.882     0.011     0.200
    50.882     0.890     0.200
    50.882     0.890     0.200
    50.882     0.250     0.200
    51.877     0.107     0.200
    53.850    -1.339     0.200
    53.853    -1.358     0.200
    55.034    -0.324     0.200
    55.034    -0.040     0.200
    55.480     0.685     0.200
    15.897     5.169     0.200
    18.530    -0.617     0.200
    19.555    -0.162     0.200
    20.006     0.846     0.200
    20.006     1.045     0.200
    20.634     0.125     0.200
    20.680     0.728     0.200
    21.275     5.400     0.200
    21.652     2.546     0.200
    21.652     1.335     0.200
    21.967     3.372     0.200
    22.240     1.255     0.200
    22.308     3.237     0.200
    22.826     3.932     0.200
    23.409     1.782     0.200
    23.409     0.255     0.200
    23.475     1.196     0.200
    23.475    -1.023     0.200
    23.649     1.546     0.200
    23.649     0.847     0.200
    23.689    -1.377     0.200
    23.735     1.948     0.200
    24.118     1.862     0.200
    24.124     1.706     0.200
    24.163     1.749     0.200
    24.601     4.158     0.200
    24.807     1.580     0.200
    24.807     0.240     0.200
    25.182     1.569     0.200
    25.316     2.148     0.200
    25.756     0.817     0.200
    25.756     0.755     0.200
    25.756     0.286     0.200
    25.839     2.001     0.200
    25.863     0.921     0.200
    25.979     0.985     0.200
    25.978     0.721     0.200
    26.856     0.213     0.200
    27.610     0.194     0.200
    27.727     0.397     0.200
    27.891    -0.946     0.200
    27.891    -0.411     0.200
    30.378    -0.807     0.200
    31.355    -0.177     0.200
    31.355    -1.365     0.200
    31.361    -1.673     0.200
    31.361    -1.321     0.200
    31.365    -1.786     0.200
    31.861     2.579     0.200
    34.237    -0.178     0.200
    34.747    -0.479     0.200
    34.748    -0.706     0.200
    34.830     0.768     0.200
    34.830    -0.408     0.200
    34.850     1.616     0.200
    36.462     1.478     0.200
    36.477     0.845     0.200
    36.973     0.419     0.200
    36.973    -2.780     0.200
    38.363     1.363     0.200
    38.470     1.064     0.200
    39.167     1.118     0.200
    39.532    -1.810     0.200
    39.700     0.272     0.200
    39.739     1.549     0.200
    40.368     0.728     0.200
    40.380     0.524     0.200
    40.545     0.565     0.200
    40.617     0.449     0.200
    40.617    -0.043     0.200
    40.635     0.818     0.200
    41.152     0.360     0.200
    41.995     0.649     0.200
    43.766    -0.209     0.200
    44.013    -0.889     0.200
    44.750     0.604     0.200
    44.828    -0.739     0.200
    50.999     0.090     0.200
    50.999     0.766     0.200
    50.999     0.180     0.200
    51.188    -0.234     0.200
    51.855     4.083     0.200
    52.134     0.801     0.200
    52.170    -1.569     0.200
    52.336     0.598     0.200
    52.336     0.469     0.200
    53.899    -0.495     0.200
    53.899    -0.616     0.200
    53.899    -1.687     0.200
    55.131     0.231     0.200
    55.131    -0.250     0.200
    55.737     0.064     0.200
    55.848     0.174     0.200
    56.950     0.113     0.200
    56.950    -0.286     0.200
    56.950     0.003     0.200
    60.791    -0.174     0.200
    61.742    -1.012     0.200
    63.819    -0.698     0.200
    65.010     1.055     0.200
    65.010    -0.758     0.200
    65.719    -0.448     0.200
    65.719    -0.780     0.200
    68.319    -1.173     0.200
    68.319    -1.025     0.200
    75.675     0.027     0.200
    76.984     1.797     0.200
    77.538     0.591     0.200
    79.237    -0.096     0.200
    80.503     1.139     0.200
    80.693    -1.006     0.200
    81.432    -0.533     0.200
    83.753    -0.832     0.200
    84.061    -0.326     0.200
    85.154    -1.248     0.200
    85.154    -0.697     0.200
    85.428    -1.469     0.200
    85.446    -1.285     0.200
    85.446    -1.511     0.200
    87.046     1.032     0.200
    87.046     0.657     0.200
    88.640    -2.217     0.200
    95.097    -2.075     0.200
    23.089     0.684     0.200
    23.266     0.776     0.200
    25.480     1.856     0.200
    25.777     1.176     0.200
    34.699    -0.707     0.200
    34.700    -0.737     0.200
    38.139     1.356     0.200
    38.241     0.894     0.200
    38.937     1.449     0.200
    39.514     1.527     0.200
    40.140     0.625     0.200
    40.152     0.420     0.200
    40.318     0.739     0.200
    40.407     0.811     0.200
    40.653     0.487     0.200
    40.653     0.479     0.200
    49.990    -1.051     0.200
    50.913     1.071     0.200
    50.913     1.071     0.200
    51.101     0.205     0.200
    51.928     0.521     0.200
    53.223    -1.074     0.200
    53.870    -0.126     0.200
    53.873    -0.146     0.200
    55.062     0.407     0.200
    55.531    -0.024     0.200
    81.717     0.851     0.200
    81.965    -0.259     0.200
    82.691     0.348     0.200
    83.252     1.297     0.200
    83.283     0.286     0.200
    83.413     0.737     0.200
    83.447     0.242     0.200
    83.773     0.967     0.200
    83.879     0.030     0.200
    83.879     0.029     0.200
    83.946     0.852     0.200
    85.337    -1.561     0.200
    14.443     4.767     0.200
    14.765     7.280     0.200
    15.162     3.159     0.200
    15.503     2.509     0.200
    15.880     5.328     0.200
    18.531    -1.261     0.200
    18.877    -0.503     0.200
    19.649    -1.662     0.200
    19.866     0.164     0.200
    19.985    -0.324     0.200
    20.008     0.758     0.200
    20.008     0.523     0.200
    20.700    -0.178     0.200
    20.700    -1.178     0.200
    20.760    -1.286     0.200
    21.225     0.474     0.200
    21.264     3.840     0.200
    21.597     2.763     0.200
    21.632     3.287     0.200
    21.632    -1.104     0.200
    21.956     0.425     0.200
    22.094     2.245     0.200
    22.219     2.016     0.200
    22.255     1.350     0.200
    22.285     0.210     0.200
    22.407     1.319     0.200
    22.529     1.323     0.200
    22.813     2.217     0.200
    23.315     5.637     0.200
    23.336     1.930     0.200
    23.336     1.109     0.200
    23.387     1.073     0.200
    23.387     0.065     0.200
    23.453     0.065     0.200
    23.627     0.475     0.200
    23.698    -1.292     0.200
    23.722    -0.288     0.200
    23.722    -1.061     0.200
    24.101     1.544     0.200
    24.101     0.846     0.200
    24.140     0.990     0.200
    24.211     1.141     0.200
    24.365     0.492     0.200
    24.576     2.216     0.200
    24.583     0.547     0.200
    24.616     1.550     0.200
    24.787     0.599     0.200
    24.831     2.990     0.200
    24.916     1.424     0.200
    24.957     0.546     0.200
    25.124     3.435     0.200
    25.160     1.402     0.200
    25.251     2.178     0.200
    25.251     1.076     0.200
    25.288     3.836     0.200
    25.298     1.953     0.200
    25.312     3.020     0.200
    25.455     1.325     0.200
    25.469     1.702     0.200
    25.734     2.538     0.200
    25.734     0.733     0.200
    25.734     1.249     0.200
    25.734    -0.103     0.200
    25.828     1.846     0.200
    25.819     1.521     0.200
    25.832     0.614     0.200
    25.870     0.529     0.200
    25.958     0.668     0.200
    26.500     1.870     0.200
    26.589     4.166     0.200
    26.835    -0.648     0.200
    27.237    -1.561     0.200
    27.610     0.695     0.200
    27.610     0.062     0.200
    27.714    -0.135     0.200
    27.714    -1.033     0.200
    27.895     0.839     0.200
    29.978    -0.852     0.200
    30.770    -0.941     0.200
    30.789     0.478     0.200
    31.365    -0.192     0.200
    31.371    -2.043     0.200
    31.371    -1.222     0.200
    31.375    -1.718     0.200
    31.605    -1.293     0.200
    31.846     1.976     0.200
    32.713     3.574     0.200
    34.216     0.590     0.200
    34.216     0.481     0.200
    34.216     0.184     0.200
    34.757    -0.793     0.200
    34.757    -1.027     0.200
    34.831    -0.233     0.200
    34.831     0.549     0.200
    34.831     0.166     0.200
    34.890    -0.666     0.200
    36.447     1.501     0.200
    36.458     2.311     0.200
    38.342     1.348     0.200
    38.449     1.050     0.200
    39.146     1.312     0.200
    39.374    -0.589     0.200
    39.700     0.050     0.200
    39.700    -0.208     0.200
    39.718     1.542     0.200
    40.179     0.114     0.200
    40.347     0.428     0.200
    40.359     0.325     0.200
    40.434    -0.202     0.200
    40.434     0.009     0.200
    40.524     0.761     0.200
    40.607     0.801     0.200
    40.607     0.473     0.200
    40.614     0.812     0.200
    41.131     0.361     0.200
    41.974     0.650     0.200
    43.764    -0.445     0.200
    44.022    -0.990     0.200
    44.728     0.639     0.200
    44.839     0.233     0.200
    46.149     1.883     0.200
    46.149     0.680     0.200
    48.399    -0.336     0.200
    50.983     0.604     0.200
    50.983     0.698     0.200
    50.987     0.280     0.200
    51.173    -0.422     0.200
    51.836     3.424     0.200
    52.114     0.879     0.200
    52.169    -1.450     0.200
    53.886    -0.477     0.200
    53.886    -0.602     0.200
    53.886    -1.134     0.200
    54.028     1.555     0.200
    54.028     0.969     0.200
    54.609     0.350     0.200
    55.116     0.558     0.200
    55.717     0.936     0.200
    55.829    -1.090     0.200
    56.607     0.506     0.200
    56.700     0.126     0.200
    56.932    -0.826     0.200
    56.932    -1.021     0.200
    56.932    -0.154     0.200
    57.614    -0.536     0.200
    60.777    -0.017     0.200
    60.777    -0.775     0.200
    63.811    -0.120     0.200
    64.828     0.524     0.200
    64.936     0.205     0.200
    64.990     1.023     0.200
    64.990    -1.282     0.200
    64.990    -1.969     0.200
    65.554     0.308     0.200
    65.702    -1.046     0.200
    65.702    -1.507     0.200
    65.702    -1.125     0.200
    65.755     1.098     0.200
    65.902     0.579     0.200
    65.970     0.240     0.200
    65.970     0.381     0.200
    66.569     1.756     0.200
    66.633     0.981     0.200
    67.316     0.246     0.200
    67.953     0.976     0.200
    68.305    -1.505     0.200
    68.338     0.204     0.200
    68.827     0.461     0.200
    68.965     0.394     0.200
    75.503    -0.150     0.200
    75.653     0.262     0.200
    75.653    -1.011     0.200
    75.814    -1.325     0.200
    76.100    -0.361     0.200
    76.428    -1.224     0.200
    76.652    -1.598     0.200
    76.966     0.341     0.200
    76.966    -2.104     0.200
    77.521    -0.670     0.200
    77.822    -1.199     0.200
    78.942    -0.419     0.200
    79.128    -1.550     0.200
    80.488    -0.818     0.200
    80.700    -0.970     0.200
    81.438     0.406     0.200
    83.048    -0.907     0.200
    83.117     0.582     0.200
    83.469     0.682     0.200
    83.641    -0.240     0.200
    83.743    -0.072     0.200
    84.484    -0.455     0.200
    84.849    -0.988     0.200
    84.964    -0.199     0.200
    85.140    -0.622     0.200
    85.414     0.182     0.200
    85.430    -1.294     0.200
    85.430    -0.794     0.200
    85.430    -0.997     0.200
    85.441    -0.552     0.200
    85.507     0.689     0.200
    86.799    -0.456     0.200
    87.023     2.060     0.200
    87.023     1.669     0.200
    87.023     1.154     0.200
    87.023     0.146     0.200
    88.626     1.004     0.200
    92.080    -1.493     0.200
    93.860    -0.302     0.200
    94.951    -0.757     0.200
    95.566     1.185     0.200
    95.597     0.667     0.200
    14.999     5.326     0.200
    15.229     7.742     0.200
    15.229     3.641     0.200
    15.197     4.617     0.200
    15.432     2.581     0.200
    15.600     2.392     0.200
    16.347     2.954     0.200
    17.309     3.427     0.200
    17.492     2.235     0.200
    17.492     1.938     0.200
    18.711     0.467     0.200
    18.891     0.205     0.200
    19.149    -0.023     0.200
    19.621    -0.793     0.200
    19.843     0.595     0.200
    20.337     0.819     0.200
    20.376    -2.015     0.200
    20.508    -0.146     0.200
    20.793    -0.303     0.200
    21.093     4.827     0.200
    21.360     1.650     0.200
    21.360     0.931     0.200
    21.360     4.051     0.200
    21.688     3.320     0.200
    21.675     1.367     0.200
    21.662     2.903     0.200
    21.829     4.919     0.200
    21.986    -0.798     0.200
    21.957     2.646     0.200
    22.117     1.039     0.200
    22.367     1.473     0.200
    22.471     1.468     0.200
    22.539     1.940     0.200
    22.643     1.133     0.200
    22.769     2.104     0.200
    22.769     2.823     0.200
    23.059     3.939     0.200
    23.059     2.041     0.200
    23.051     2.521     0.200
    23.073     5.297     0.200
    23.196     1.497     0.200
    23.196     0.809     0.200
    23.223     1.312     0.200
    23.223     0.382     0.200
    23.300     1.002     0.200
    23.374     1.621     0.200
    23.446     0.763     0.200
    23.446    -0.573     0.200
    23.614    -0.205     0.200
    23.646     0.943     0.200
    23.820     0.447     0.200
    23.832    -0.961     0.200
    23.913    -0.139     0.200
    23.933    -0.388     0.200
    23.903     2.090     0.200
    23.902     2.001     0.200
    24.096     0.327     0.200
    24.140     0.677     0.200
    24.140    -1.495     0.200
    24.296     0.498     0.200
    24.302     0.740     0.200
    24.384     0.663     0.200
    24.509     1.055     0.200
    24.440     1.486     0.200
    24.510     0.148     0.200
    24.514     0.910     0.200
    24.514     1.340     0.200
    24.682    -0.615     0.200
    24.687     2.144     0.200
    24.975     2.215     0.200
    25.018     2.024     0.200
    25.020     0.706     0.200
    25.068     2.264     0.200
    25.117     3.025     0.200
    25.128     4.426     0.200
    25.177     1.479     0.200
    25.178     0.868     0.200
    25.178     0.173     0.200
    25.233     1.676     0.200
    25.545     0.640     0.200
    25.583     1.872     0.200
    25.583     0.317     0.200
    25.583     0.794     0.200
    25.583    -0.206     0.200
    25.695     0.813     0.200
    25.753     1.530     0.200
    25.680     0.814     0.200
    25.684     0.722     0.200
    25.684    -0.723     0.200
    26.238    -1.232     0.200
    26.433     3.096     0.200
    26.577    -0.303     0.200
    26.771     0.148     0.200
    26.963    -0.975     0.200
    26.997     1.116     0.200
    27.014    -0.042     0.200
    27.209    -0.794     0.200
    27.747    -0.760     0.200
    27.747    -0.323     0.200
    27.725     0.773     0.200
    27.751     0.141     0.200
    27.751     0.641     0.200
    27.798     0.697     0.200
    28.263    -0.023     0.200
    28.562     3.614     0.200
    30.414    -0.900     0.200
    30.414    -0.720     0.200
    30.569    -0.582     0.200
    30.882     0.567     0.200
    30.902     0.892     0.200
    31.271    -2.289     0.200
    31.288    -0.407     0.200
    31.288    -3.298     0.200
    31.293    -2.148     0.200
    31.293    -0.382     0.200
    31.297    -1.754     0.200
    31.352    -2.026     0.200
    31.367    -1.832     0.200
    31.369    -1.370     0.200
    31.376    -2.256     0.200
    31.385    -2.493     0.200
    31.386    -2.125     0.200
    31.390    -2.225     0.200
    31.391    -2.225     0.200
    31.405    -2.459     0.200
    31.416    -1.774     0.200
    31.437    -2.454     0.200
    31.464    -1.544     0.200
    31.863     1.722     0.200
    31.933     0.509     0.200
    32.799     3.417     0.200
    33.908    -0.921     0.200
    34.105     0.577     0.200
    34.105     0.132     0.200
    34.334     0.390     0.200
    34.665    -1.586     0.200
    34.666    -1.476     0.200
    34.666    -1.828     0.200
    35.031     0.044     0.200
    35.079    -0.334     0.200
    36.374     2.592     0.200
    36.536    -0.595     0.200
    36.462     1.544     0.200
    36.995     0.256     0.200
    36.995    -1.893     0.200
    38.233     1.320     0.200
    38.336     1.055     0.200
    39.032     1.417     0.200
    39.328     0.240     0.200
    39.328    -0.869     0.200
    39.518     0.054     0.200
    39.608     1.403     0.200
    39.893    -0.043     0.200
    39.893     0.738     0.200
    40.235     0.798     0.200
    40.247     0.390     0.200
    40.413     0.618     0.200
    40.520     0.064     0.200
    40.502     0.782     0.200
    40.520     1.556     0.200
    40.520     0.837     0.200
    40.520     1.087     0.200
    40.690     0.458     0.200
    41.020     0.310     0.200
    41.529     3.237     0.200
    41.864     0.684     0.200
    42.183     1.682     0.200
    43.884    -0.953     0.200
    43.884    -0.750     0.200
    43.924    -0.958     0.200
    43.924    -1.169     0.200
    43.905    -0.262     0.200
    44.547     0.593     0.200
    44.772    -0.349     0.200
    45.305     1.796     0.200
    45.752     0.815     0.200
    46.113    -0.153     0.200
    46.144     2.329     0.200
    46.144     0.533     0.200
    48.079    -1.992     0.200
    48.079     0.867     0.200
    48.532    -0.065     0.200
    50.958     0.663     0.200
    50.979     0.908     0.200
    50.979     0.501     0.200
    51.116     0.280     0.200
    51.168     0.885     0.200
    51.368    -0.352     0.200
    51.779     3.010     0.200
    51.959    -0.729     0.200
    52.019     0.843     0.200
    52.344    -0.494     0.200
    52.486     0.750     0.200
    53.254     2.150     0.200
    53.350     1.075     0.200
    53.350     1.685     0.200
    53.684     1.833     0.200
    53.817     2.300     0.200
    53.924    -0.334     0.200
    53.924    -0.630     0.200
    53.951     1.235     0.200
    53.960     0.005     0.200
    53.986     1.463     0.200
    53.986     1.330     0.200
    53.986     2.338     0.200
    53.986     1.713     0.200
    53.986     1.213     0.200
    54.225     1.062     0.200
    54.346     2.248     0.200
    54.485     1.592     0.200
    54.557     0.103     0.200
    55.125     0.390     0.200
    55.125     0.782     0.200
    55.125     0.438     0.200
    55.125     0.579     0.200
    55.623     1.055     0.200
    55.701    -0.010     0.200
    56.887     0.634     0.200
    56.887    -0.171     0.200
    56.887     0.431     0.200
    57.194     1.355     0.200
    57.599    -0.203     0.200
    60.783     0.292     0.200
    60.783     0.120     0.200
    61.909    -1.269     0.200
    61.909    -1.855     0.200
    63.914    -0.801     0.200
    64.622    -0.337     0.200
    64.673     1.318     0.200
    64.906     0.781     0.200
    64.906     1.351     0.200
    65.398     1.347     0.200
    65.611     1.160     0.200
    65.678    -0.403     0.200
    65.678    -0.505     0.200
    65.820    -0.033     0.200
    66.101     0.766     0.200
    66.181     1.053     0.200
    66.391     1.517     0.200
    66.483     0.200     0.200
    67.331     0.220     0.200
    67.932    -1.242     0.200
    68.316    -0.988     0.200
    68.316    -1.824     0.200
    68.657    -0.174     0.200
    68.995    -0.843     0.200
    69.248    -1.339     0.200
    73.390    -0.428     0.200
    74.648    -0.189     0.200
    75.420    -1.042     0.200
    75.427     2.317     0.200
    75.427     1.224     0.200
    75.427     0.083     0.200
    75.501    -0.787     0.200
    75.501     0.197     0.200
    75.845    -2.375     0.200
    76.036     0.035     0.200
    76.280     1.348     0.200
    76.357     0.308     0.200
    76.357     1.824     0.200
    76.369     2.141     0.200
    76.468    -2.202     0.200
    76.688     0.438     0.200
    76.759     0.084     0.200
    76.908     0.813     0.200
    76.908     2.016     0.200
    76.908    -0.109     0.200
    76.908     0.602     0.200
    77.499    -1.124     0.200
    78.009    -0.705     0.200
    78.065    -1.078     0.200
    78.940    -2.207     0.200
    79.106    -1.413     0.200
    79.190    -1.074     0.200
    79.206    -0.959     0.200
    79.741    -0.579     0.200
    79.741     0.233     0.200
    79.853    -1.390     0.200
    80.150    -1.392     0.200
    80.444    -1.366     0.200
    80.458    -1.119     0.200
    80.486    -0.999     0.200
    80.933    -1.787     0.200
    80.942    -1.439     0.200
    80.946    -1.764     0.200
    81.109    -2.040     0.200
    81.677     0.097     0.200
    81.795    -0.674     0.200
    81.918    -2.057     0.200
    81.981     1.858     0.200
    82.273    -1.607     0.200
    82.963    -0.568     0.200
    83.050    -2.147     0.200
    83.102    -1.283     0.200
    83.200    -1.816     0.200
    83.366    -0.008     0.200
    83.396    -0.906     0.200
    83.787    -0.911     0.200
    83.814    -0.190     0.200
    83.966     0.526     0.200
    83.966    -0.693     0.200
    83.966    -0.326     0.200
    83.966    -1.185     0.200
    84.534    -0.511     0.200
    84.563    -0.211     0.200
    84.591    -1.401     0.200
    84.609    -0.761     0.200
    84.896     0.236     0.200
    84.904    -1.571     0.200
    84.888    -1.292     0.200
    85.173    -2.638     0.200
    85.173    -0.326     0.200
    85.173     0.573     0.200
    85.201     2.495     0.200
    85.409    -1.582     0.200
    85.409    -0.739     0.200
    85.420    -1.161     0.200
    85.432    -0.425     0.200
    85.432    -1.215     0.200
    86.231     1.059     0.200
    86.325    -0.006     0.200
    86.334    -0.644     0.200
    86.421    -1.018     0.200
    86.660    -0.393     0.200
    86.660     0.435     0.200
    86.660     0.185     0.200
    86.789     0.960     0.200
    86.789     0.296     0.200
    86.789     1.577     0.200
    86.789    -0.204     0.200
    87.103     0.085     0.200
    87.116     0.188     0.200
    87.545    -0.905     0.200
    87.873    -0.486     0.200
    87.952     0.069     0.200
    88.405    -2.446     0.200
    88.348    -1.012     0.200
    88.518    -1.526     0.200
    88.532    -0.850     0.200
    88.567    -0.147     0.200
    88.567     0.400     0.200
    88.593    -1.271     0.200
    88.593    -0.365     0.200
    88.598    -0.722     0.200
    90.184     2.076     0.200
    90.250    -0.230     0.200
    90.449    -0.961     0.200
    90.915    -1.327     0.200
    91.156    -1.546     0.200
    91.298     0.590     0.200
    91.379    -0.578     0.200
    92.122    -2.450     0.200
    92.404    -1.619     0.200
    92.492     2.668     0.200
    93.306    -0.986     0.200
    93.637    -0.713     0.200
    94.323    -0.663     0.200
    94.690     1.328     0.200
    95.150    -2.521     0.200
    95.191    -0.964     0.200
    95.191    -1.238     0.200
    95.581    -0.667     0.200
    95.581    -0.401     0.200
    95.581    -0.917     0.200
    97.943    -0.669     0.200
    19.447    -2.166     0.200
    21.889    -1.553     0.200
    23.484     2.097     0.200
    23.740    -1.302     0.200
    23.920    -0.858     0.200
    23.956     0.068     0.200
    23.956    -1.147     0.200
    25.041     0.669     0.200
    26.067     1.716     0.200
    26.067    -0.876     0.200
    26.236     0.983     0.200
    26.236     0.989     0.200
    27.684     0.133     0.200
    31.166    -0.461     0.200
    31.166    -0.460     0.200
    34.565    -2.327     0.200
    34.566     0.298     0.200
    34.542     0.840     0.200
    34.885     0.383     0.200
    34.885    -0.372     0.200
    39.767     0.038     0.200
    51.257     0.430     0.200
    51.257     0.780     0.200
    51.257     0.785     0.200
    51.257    -0.819     0.200
    52.435     0.165     0.200
    54.129    -1.106     0.200
    54.129    -1.279     0.200
    54.132    -1.129     0.200
    55.381    -0.492     0.200
    57.232    -0.415     0.200
    57.232    -0.315     0.200
    57.232    -0.175     0.200
    61.043    -0.029     0.200
    65.990    -0.800     0.200
    80.662    -0.221     0.200
    83.583    -0.327     0.200
    83.955    -0.186     0.200
    83.955    -0.181     0.200
    84.355     0.141     0.200
    84.355     0.670     0.200
    84.355     0.143     0.200
    85.392    -0.934     0.200
    85.392    -1.336     0.200
    85.387    -0.532     0.200
    85.387    -0.532     0.200
    85.450    -1.225     0.200
    85.715    -0.592     0.200
    85.715    -1.873     0.200
    85.715    -0.423     0.200
    88.918    -1.738     0.200
    95.879     0.586     0.200
    95.879     0.588     0.200
    23.721     0.370     0.200
    26.035     0.453     0.200
    27.661     0.242     0.200
    30.913     0.816     0.200
    31.198    -0.356     0.200
    31.198    -0.355     0.200
    34.508     0.172     0.200
    34.596    -1.237     0.200
    34.597    -1.992     0.200
    34.597    -2.364     0.200
    34.864     0.373     0.200
    34.864    -1.137     0.200
    40.779    -1.009     0.200
    51.223    -0.727     0.200
    51.223     1.642     0.200
    51.223     1.639     0.200
    51.223     0.182     0.200
    54.095    -0.446     0.200
    54.095    -1.029     0.200
    54.098    -0.469     0.200
    55.347     0.315     0.200
    57.197     0.262     0.200
    57.197    -0.517     0.200
    57.197     0.653     0.200
    61.009    -0.760     0.200
    80.650    -1.856     0.200
    80.650    -1.261     0.200
    83.923    -0.293     0.200
    83.923    -0.293     0.200
    85.377    -0.506     0.200
    85.679    -0.699     0.200
    21.043    -1.978     0.200
    21.287    -1.104     0.200
    22.535    -2.614     0.200
    25.540     1.313     0.200
    27.712    -1.133     0.200
    31.276    -1.782     0.200
    31.276    -1.781     0.200
    34.645    -0.675     0.200
    35.081    -0.677     0.200
    50.975     0.112     0.200
    50.975     0.106     0.200
    51.353    -0.281     0.200
    53.537    -2.528     0.200
    53.930    -0.149     0.200
    53.930     0.082     0.200
    55.123    -0.270     0.200
    56.871    -0.279     0.200
    64.879    -0.000     0.200
    65.667     0.292     0.200
    82.337    -2.861     0.200
    83.430    -2.852     0.200
    84.966    -2.941     0.200
    85.399    -1.261     0.200
    85.699     0.279     0.200
    85.699    -2.223     0.200
    21.703     0.886     0.200
    21.865    -1.693     0.200
    22.105     1.090     0.200
    22.524     3.126     0.200
    22.583    -0.802     0.200
    22.978     0.711     0.200
    23.624     1.842     0.200
    23.624    -2.167     0.200
    23.868    -0.483     0.200
    24.500    -1.394     0.200
    24.857     3.990     0.200
    25.019     0.852     0.200
    25.165     2.286     0.200
    25.388     4.265     0.200
    25.445     0.444     0.200
    25.528     4.493     0.200
    25.557    -2.050     0.200
    25.966     1.243     0.200
    25.966     0.721     0.200
    26.063    -1.962     0.200
    26.199     0.677     0.200
    26.198    -2.367     0.200
    27.584    -1.050     0.200
    27.584     0.606     0.200
    27.641    -1.192     0.200
    27.879    -1.138     0.200
    28.290     0.942     0.200
    30.844    -0.999     0.200
    31.289    -1.160     0.200
    31.288    -1.159     0.200
    31.292     0.316     0.200
    31.981     2.686     0.200
    32.792     0.880     0.200
    33.760     0.826     0.200
    34.431    -0.084     0.200
    34.686     0.850     0.200
    34.687    -0.558     0.200
    34.687    -0.138     0.200
    34.790     0.486     0.200
    34.790     0.107     0.200
    36.005    -3.379     0.200
    36.583     1.606     0.200
    36.658    -1.977     0.200
    36.840    -0.403     0.200
    38.556     1.609     0.200
    38.664     1.492     0.200
    39.362     1.653     0.200
    39.396    -0.491     0.200
    39.932     1.503     0.200
    40.273     1.277     0.200
    40.562     0.783     0.200
    40.574     0.681     0.200
    40.688     1.922     0.200
    40.688     1.923     0.200
    40.688    -1.590     0.200
    40.738     0.726     0.200
    40.829     0.975     0.200
    42.152     0.724     0.200
    44.746     0.390     0.200
    44.746     0.548     0.200
    44.922    -1.435     0.200
    46.300     0.093     0.200
    50.705    -0.361     0.200
    51.132    -1.016     0.200
    51.132     0.775     0.200
    51.132     0.769     0.200
    52.021     1.802     0.200
    53.396     0.301     0.200
    54.004    -0.216     0.200
    54.006    -0.237     0.200
    54.203    -1.232     0.200
    55.256    -0.599     0.200
    55.951    -1.941     0.200
    56.020    -2.076     0.200
    56.636    -0.905     0.200
    57.110    -0.830     0.200
    57.110    -0.281     0.200
    57.110    -1.061     0.200
    61.735    -0.942     0.200
    63.872    -0.146     0.200
    65.191     2.496     0.200
    65.866    -1.545     0.200
    65.866    -1.295     0.200
    68.443    -0.817     0.200
    79.744    -1.316     0.200
    80.594    -0.997     0.200
    81.343    -0.720     0.200
    81.346    -0.614     0.200
    83.005    -1.041     0.200
    83.350    -1.151     0.200
    83.410    -1.830     0.200
    83.521     0.946     0.200
    84.185     0.241     0.200
    84.236     0.710     0.200
    84.237     0.707     0.200
    84.237    -1.230     0.200
    85.262    -0.768     0.200
    85.262    -0.772     0.200
    85.316    -0.511     0.200
    85.316    -0.357     0.200
    85.388    -0.928     0.200
    85.590    -0.754     0.200
    85.590    -1.385     0.200
    85.590    -2.215     0.200
    86.680    -0.388     0.200
    86.755    -0.924     0.200
    87.273     1.528     0.200
    87.287    -1.984     0.200
    88.716    -1.775     0.200
    88.795    -1.687     0.200
    14.473     3.397     0.200
    23.033     2.359     0.200
    23.033     1.988     0.200
    23.165    -1.066     0.200
    23.640    -1.254     0.200
    23.694     3.955     0.200
    24.245     5.020     0.200
    24.840     3.104     0.200
    25.023     1.736     0.200
    25.398     1.460     0.200
    25.398     0.531     0.200
    25.398     0.672     0.200
    25.500    -0.097     0.200
    26.731    -1.217     0.200
    27.741    -0.858     0.200
    27.844     0.642     0.200
    27.901     0.135     0.200
    29.787     1.730     0.200
    34.704    -2.194     0.200
    34.705    -2.201     0.200
    36.454     1.241     0.200
    38.068     1.657     0.200
    38.169     1.209     0.200
    38.864     1.370     0.200
    39.442     1.439     0.200
    39.524     1.360     0.200
    39.943    -1.302     0.200
    39.943    -0.728     0.200
    40.068     0.637     0.200
    40.080     0.534     0.200
    40.247     0.859     0.200
    40.335     1.130     0.200
    40.854     0.544     0.200
    41.654     0.872     0.200
    41.698     0.615     0.200
    43.969     1.609     0.200
    50.874     0.135     0.200
    50.874     0.768     0.200
    50.874     0.760     0.200
    50.874     0.936     0.200
    50.874     0.409     0.200
    51.861    -0.253     0.200
    52.378     1.007     0.200
    53.846    -0.354     0.200
    53.846    -0.842     0.200
    53.849    -0.374     0.200
    53.857    -0.378     0.200
    55.028     0.365     0.200
    55.028     0.414     0.200
    55.028     0.075     0.200
    55.464    -0.432     0.200
    55.616     0.538     0.200
    56.755    -0.453     0.200
    56.755    -1.054     0.200
    56.755     0.836     0.200
    56.991     0.377     0.200
    60.613    -0.281     0.200
    60.613    -0.242     0.200
    60.685     0.327     0.200
    60.685    -1.251     0.200
    60.957    -1.847     0.200
    61.936    -0.734     0.200
    63.886    -0.691     0.200
    64.701    -1.630     0.200
    64.752     0.963     0.200
    64.752     0.615     0.200
    64.752     0.025     0.200
    65.559    -0.887     0.200
    67.238     0.063     0.200
    68.220    -0.931     0.200
    75.763    -2.206     0.200
    76.619     0.700     0.200
    76.769    -1.520     0.200
    77.382    -1.061     0.200
    78.989    -1.458     0.200
    79.093    -1.931     0.200
    81.055    -1.729     0.200
    81.055    -1.729     0.200
    83.480     0.423     0.200
    83.843     0.905     0.200
    83.761    -1.281     0.200
    83.817    -0.125     0.200
    83.817    -0.126     0.200
    85.292    -1.150     0.200
    85.292    -1.177     0.200
    85.341     0.080     0.200
    92.047    -1.920     0.200
    92.047    -1.920     0.200
    19.967     0.568     0.200
    23.034     1.531     0.200
    25.387     2.071     0.200
    27.882    -2.581     0.200
    31.463    -1.320     0.200
    38.032     1.469     0.200
    38.135     1.301     0.200
    38.831     1.648     0.200
    39.407     1.733     0.200
    39.793     0.593     0.200
    40.034     0.518     0.200
    40.046     0.220     0.200
    40.212     0.643     0.200
    40.301     1.008     0.200
    50.785     0.430     0.200
    53.740     0.073     0.200
    54.933     0.608     0.200
    60.519     0.060     0.200
    64.703     0.723     0.200
    68.125    -0.814     0.200
    80.904    -1.326     0.200
    83.642    -1.385     0.200
    83.763    -0.999     0.200
    84.988    -2.836     0.200
    85.211    -1.191     0.200
    14.148     8.763     0.200
    14.930     7.947     0.200
    15.318     3.343     0.200
    20.948    -0.330     0.200
    21.288     3.307     0.200
    22.387     3.435     0.200
    22.588     1.504     0.200
    22.846     2.661     0.200
    23.489     2.084     0.200
    23.537    -0.222     0.200
    23.713     0.188     0.200
    24.200     1.808     0.200
    24.232     2.517     0.200
    24.718     2.290     0.200
    24.860     1.605     0.200
    25.349     0.250     0.200
    25.390     4.375     0.200
    25.561     2.125     0.200
    25.836     0.329     0.200
    25.836     1.829     0.200
    25.836     0.548     0.200
    26.039     0.166     0.200
    26.038     0.668     0.200
    27.639     0.531     0.200
    27.696     1.469     0.200
    27.850    -2.009     0.200
    31.302    -2.066     0.200
    31.930     2.359     0.200
    32.780     1.410     0.200
    34.317     0.874     0.200
    34.692     0.500     0.200
    34.693    -1.799     0.200
    34.693    -0.518     0.200
    34.854    -0.553     0.200
    36.531     0.272     0.200
    40.611    -0.840     0.200
    40.675     0.626     0.200
    40.675     0.401     0.200
    43.959    -0.490     0.200
    46.238     1.598     0.200
    51.071    -0.126     0.200
    51.071     0.214     0.200
    51.071    -0.116     0.200
    51.261     0.429     0.200
    52.214    -0.161     0.200
    53.965    -0.136     0.200
    53.965     0.563     0.200
    55.201     0.422     0.200
    57.027     0.048     0.200
    57.027     0.048     0.200
    60.862     0.185     0.200
    65.794    -0.655     0.200
    68.873     0.494     0.200
    75.756    -0.317     0.200
    80.695    -0.859     0.200
    80.695     0.350     0.200
    83.813    -0.558     0.200
    85.220    -0.905     0.200
    85.220    -0.905     0.200
    85.520    -0.783     0.200
    85.520     0.178     0.200
    14.181     8.292     0.200
    15.318     4.034     0.200
    15.318     5.921     0.200
    15.881     5.282     0.200
    16.315     2.189     0.200
    16.644     6.794     0.200
    17.408     4.870     0.200
    17.408     3.819     0.200
    18.584     0.107     0.200
    19.449     0.416     0.200
    19.517    -0.335     0.200
    19.733     0.711     0.200
    19.897     0.373     0.200
    20.623     1.427     0.200
    20.704     0.335     0.200
    20.704    -0.550     0.200
    21.125     4.898     0.200
    21.514     3.334     0.200
    21.817     1.756     0.200
    22.116     0.760     0.200
    22.239     5.644     0.200
    22.477     2.708     0.200
    22.621     1.581     0.200
    22.675     2.510     0.200
    22.919     2.366     0.200
    23.348    -0.139     0.200
    23.343     4.045     0.200
    23.343     2.166     0.200
    23.526    -0.262     0.200
    23.618    -1.047     0.200
    24.036     3.914     0.200
    24.051     4.282     0.200
    24.452     1.713     0.200
    24.415    -0.286     0.200
    24.668     0.008     0.200
    25.129     2.548     0.200
    25.170     2.581     0.200
    25.256     4.497     0.200
    25.776     2.526     0.200
    25.697     3.215     0.200
    25.697     2.191     0.200
    25.849    -0.166     0.200
    25.848    -0.064     0.200
    26.619     1.158     0.200
    26.730     0.856     0.200
    27.790    -1.855     0.200
    27.790     0.213     0.200
    27.729    -0.024     0.200
    27.729    -0.321     0.200
    27.786     0.206     0.200
    27.772     0.389     0.200
    29.578    -0.272     0.200
    29.578    -0.306     0.200
    31.288    -0.890     0.200
    31.294    -1.687     0.200
    31.294    -1.689     0.200
    31.294    -0.537     0.200
    31.294    -1.236     0.200
    31.298    -0.682     0.200
    31.896     2.266     0.200
    32.793     1.097     0.200
    34.202     1.117     0.200
    34.674    -0.172     0.200
    34.674    -1.693     0.200
    34.674    -0.818     0.200
    34.954    -0.196     0.200
    34.954    -0.549     0.200
    34.954    -0.064     0.200
    35.010     2.244     0.200
    36.458     3.398     0.200
    36.496     1.376     0.200
    36.950    -1.629     0.200
    38.434     1.248     0.200
    39.130     1.405     0.200
    39.406    -0.961     0.200
    39.704     0.913     0.200
    39.821    -1.293     0.200
    39.821    -0.560     0.200
    40.046     0.570     0.200
    40.332     0.499     0.200
    40.344     0.297     0.200
    40.557     0.248     0.200
    40.514     0.892     0.200
    40.599     0.188     0.200
    40.686    -0.285     0.200
    40.686     2.225     0.200
    41.920     0.329     0.200
    42.986     1.854     0.200
    43.936    -1.642     0.200
    43.879    -1.549     0.200
    44.767    -1.609     0.200
    46.188     1.976     0.200
    48.044    -0.330     0.200
    48.498    -0.420     0.200
    51.023     0.262     0.200
    51.023     0.111     0.200
    51.023    -0.139     0.200
    51.351     1.602     0.200
    51.431     2.861     0.200
    51.850     5.067     0.200
    52.021     1.490     0.200
    52.108    -0.060     0.200
    52.355    -0.160     0.200
    52.355     1.530     0.200
    52.284     0.434     0.200
    52.551     0.651     0.200
    53.008     2.776     0.200
    53.945    -1.128     0.200
    53.945    -1.460     0.200
    53.945    -1.048     0.200
    54.049     1.878     0.200
    54.049     2.731     0.200
    54.625     1.873     0.200
    55.162    -1.150     0.200
    55.162    -1.038     0.200
    55.162    -1.179     0.200
    55.712    -0.410     0.200
    55.837    -0.287     0.200
    56.952    -0.558     0.200
    56.952    -0.658     0.200
    56.952    -0.369     0.200
    60.749    -0.645     0.200
    60.821    -0.146     0.200
    60.821    -0.636     0.200
    61.211     2.067     0.200
    61.853    -1.727     0.200
    61.853    -0.829     0.200
    63.898    -0.923     0.200
    64.531    -1.003     0.200
    64.990     0.357     0.200
    64.990    -0.393     0.200
    65.732    -1.162     0.200
    68.352    -2.014     0.200
    68.352    -1.758     0.200
    68.352    -0.008     0.200
    68.938    -0.267     0.200
    73.621     0.200     0.200
    75.507    -0.304     0.200
    75.616    -1.032     0.200
    75.870    -0.982     0.200
    76.110     1.348     0.200
    76.831     0.064     0.200
    76.979    -0.274     0.200
    77.552     0.112     0.200
    79.088    -1.089     0.200
    79.186    -0.834     0.200
    79.159    -1.375     0.200
    79.255     0.299     0.200
    80.529     1.000     0.200
    80.836    -2.642     0.200
    84.046     1.689     0.200
    85.197    -2.426     0.200
    85.197    -2.402     0.200
    85.461    -0.820     0.200
    85.461    -0.348     0.200
    85.538     0.122     0.200
    85.538    -0.928     0.200
    88.502    -1.184     0.200
    95.086    -0.073     0.200
    95.121    -0.005     0.200
    31.310    -0.216     0.200
    34.700    -0.993     0.200
    51.062    -0.196     0.200
    55.194     0.298     0.200
    14.240    10.737     0.200
    23.406     0.808     0.200
    25.778     1.836     0.200
    25.778     1.474     0.200
    25.903     0.896     0.200
    25.902     0.163     0.200
    27.767    -1.343     0.200
    31.228    -0.395     0.200
    31.228    -0.393     0.200
    34.611    -1.307     0.200
    34.611    -1.041     0.200
    34.988     1.390     0.200
    34.988     1.735     0.200
    40.751     1.881     0.200
    40.751     1.883     0.200
    44.699    -2.476     0.200
    44.699    -1.063     0.200
    51.019    -1.410     0.200
    51.023    -1.439     0.200
    51.100     1.318     0.200
    51.100    -0.711     0.200
    51.100    -0.707     0.200
    51.100     0.779     0.200
    55.238    -0.159     0.200
    57.032     0.991     0.200
    65.072     1.490     0.200
    65.811     0.286     0.200
    22.228     0.966     0.200
    25.461    -1.694     0.200
    27.679     0.661     0.200
    27.679    -1.902     0.200
    31.268    -0.428     0.200
    31.273    -0.516     0.200
    31.273    -0.507     0.200
    31.273    -0.272     0.200
    31.287    -2.206     0.200
    34.635     0.778     0.200
    34.636    -1.941     0.200
    34.636    -0.300     0.200
    44.759     1.154     0.200
    44.759     0.454     0.200
    48.102    -2.409     0.200
    50.947     0.159     0.200
    50.947     0.159     0.200
    50.947    -0.580     0.200
    51.931     0.087     0.200
    53.919    -0.050     0.200
    53.921    -0.062     0.200
    55.101     0.862     0.200
    60.686    -0.196     0.200
    60.686    -0.192     0.200
    61.994    -3.242     0.200
    64.823     1.229     0.200
    67.120    -0.657     0.200
    68.294    -0.277     0.200
    76.691     0.625     0.200
    81.089    -3.260     0.200
    81.089    -3.260     0.200
    83.888    -0.460     0.200
    83.888    -0.461     0.200
    83.888     0.711     0.200
    85.043    -2.405     0.200
    85.164     0.005     0.200
    85.365    -0.860     0.200
    85.773    -1.096     0.200
    85.773    -0.936     0.200
    92.119    -1.284     0.200
    95.330    -1.984     0.200
    95.330    -1.981     0.200
    95.540     0.144     0.200
    16.316     5.365     0.200
    19.697     1.210     0.200
    22.553     2.614     0.200
    22.648     0.986     0.200
    22.759     1.726     0.200
    23.025     1.704     0.200
    23.135     2.353     0.200
    23.135     1.044     0.200
    23.208     1.149     0.200
    23.521     0.377     0.200
    23.784     3.040     0.200
    24.342     3.547     0.200
    24.951     3.700     0.200
    25.162     4.185     0.200
    25.505     0.281     0.200
    25.505     1.387     0.200
    25.505    -0.539     0.200
    25.519    -0.047     0.200
    25.609    -1.416     0.200
    25.639     1.073     0.200
    26.826    -1.667     0.200
    27.612    -1.338     0.200
    27.612     0.959     0.200
    27.815     0.142     0.200
    27.815    -1.217     0.200
    27.960     0.502     0.200
    27.960    -0.389     0.200
    28.017     1.456     0.200
    29.877    -1.886     0.200
    31.204    -1.738     0.200
    34.058     0.765     0.200
    34.567    -1.047     0.200
    35.200     0.645     0.200
    35.200     0.490     0.200
    35.200    -0.124     0.200
    36.509     1.121     0.200
    38.189     1.382     0.200
    38.289     1.343     0.200
    38.984     1.507     0.200
    39.563     1.569     0.200
    39.906     1.413     0.200
    40.188     0.777     0.200
    40.200     0.874     0.200
    40.367     0.891     0.200
    40.454     1.068     0.200
    40.784     0.708     0.200
    40.974     0.679     0.200
    41.773     1.118     0.200
    41.818     0.751     0.200
    46.176     1.777     0.200
    51.013     0.501     0.200
    51.013     0.603     0.200
    51.013     0.361     0.200
    51.201    -0.165     0.200
    51.773     2.166     0.200
    51.985     0.705     0.200
    53.987    -0.638     0.200
    53.987    -1.017     0.200
    55.167    -0.480     0.200
    55.589     0.285     0.200
    55.692     0.704     0.200
    55.746    -0.387     0.200
    56.889    -1.151     0.200
    56.889    -0.881     0.200
    56.889    -1.280     0.200
    60.824    -1.026     0.200
    64.879     0.514     0.200
    64.879     0.373     0.200
    65.696    -1.772     0.200
    68.360    -1.547     0.200
    81.140    -1.944     0.200
    81.868    -0.905     0.200
    83.562    -0.072     0.200
    83.946    -0.218     0.200
    85.232    -2.168     0.200
    85.232    -2.168     0.200
    85.429    -1.502     0.200
    85.827    -1.030     0.200
    85.827    -0.339     0.200
    95.110    -3.106     0.200
    25.761     0.000     0.200
    25.761    -0.101     0.200
    25.761     0.410     0.200
    27.567    -0.751     0.200
    31.396    -3.211     0.200
    34.234     0.355     0.200
    34.781    -2.533     0.200
    34.781    -1.439     0.200
    34.786    -0.375     0.200
    34.848    -0.132     0.200
    36.053    -2.506     0.200
    40.692    -2.441     0.200
    42.950     1.314     0.200
    50.979     0.901     0.200
    50.979     1.061     0.200
    50.979     1.061     0.200
    50.979     0.632     0.200
    52.128     0.352     0.200
    55.109    -0.078     0.200
    56.937     0.006     0.200
    56.937     0.006     0.200
    56.937     0.143     0.200
    57.692    -4.551     0.200
    65.702    -0.022     0.200
    74.836    -3.354     0.200
    14.747     7.567     0.200
    25.472     2.256     0.200
    26.811    -0.002     0.200
    27.637    -0.574     0.200
    31.235    -2.081     0.200
    31.235    -2.080     0.200
    33.382    -0.161     0.200
    34.598    -0.566     0.200
    34.598    -1.933     0.200
    37.000    -0.920     0.200
    40.753     0.251     0.200
    40.753     0.251     0.200
    40.753     0.368     0.200
    50.978     0.818     0.200
    50.978     0.521     0.200
    50.978     0.521     0.200
    50.978     0.787     0.200
    51.167     0.440     0.200
    51.950     0.654     0.200
    53.953    -0.363     0.200
    53.953    -0.519     0.200
    53.956    -0.375     0.200
    55.133     0.485     0.200
    55.553     0.955     0.200
    55.710     0.007     0.200
    56.854    -0.220     0.200
    60.790    -0.183     0.200
    65.660    -1.012     0.200
    73.334    -2.384     0.200
    78.214    -0.246     0.200
    78.247    -0.976     0.200
    78.501    -1.474     0.200
    81.022    -1.180     0.200
    81.122    -0.383     0.200
    81.130    -1.083     0.200
    81.130    -1.083     0.200
    81.130    -1.247     0.200
    81.856    -0.387     0.200
    83.553    -0.771     0.200
    83.868    -1.489     0.200
    31.394    -2.623     0.200
    34.788    -1.436     0.200
    51.007     0.388     0.200
    16.495     2.816     0.200
    18.495    -1.397     0.200
    23.438     2.370     0.200
    23.438     0.910     0.200
    23.484     0.111     0.200
    23.648    -3.274     0.200
    25.823    -3.578     0.200
    25.786     0.319     0.200
    25.786     1.273     0.200
    25.786     0.343     0.200
    25.986     2.257     0.200
    27.644    -1.033     0.200
    27.701    -3.052     0.200
    27.853    -1.660     0.200
    31.315    -3.305     0.200
    31.320    -1.829     0.200
    31.320    -1.824     0.200
    31.324    -3.273     0.200
    34.271     1.461     0.200
    34.708    -0.718     0.200
    34.863    -0.300     0.200
    36.513     1.005     0.200
    39.416    -1.657     0.200
    40.657     0.689     0.200
    40.657    -1.541     0.200
    44.787    -0.529     0.200
    51.039     0.016     0.200
    51.039     0.352     0.200
    51.039    -0.152     0.200
    51.228    -0.397     0.200
    52.169     0.733     0.200
    52.589    -0.799     0.200
    53.939    -0.277     0.200
    53.939    -0.676     0.200
    55.171    -0.173     0.200
    55.885     0.482     0.200
    56.989     0.477     0.200
    56.989    -0.163     0.200
    60.832    -0.253     0.200
    63.859    -1.000     0.200
    65.046    -0.325     0.200
    65.758    -0.686     0.200
    75.705    -0.230     0.200
    20.150    -0.560     0.200
    25.743     2.176     0.200
    28.031    -1.848     0.200
    31.482    -2.494     0.200
    34.874    -1.157     0.200
    44.945     0.455     0.200
    20.129    -0.950     0.200
    25.843     1.788     0.200
    27.475     0.993     0.200
    28.002    -2.965     0.200
    34.824    -1.731     0.200
    40.549     0.896     0.200
    44.888    -0.979     0.200
    50.986     0.507     0.200
    55.111     0.143     0.200
    84.096    -0.578     0.200
    14.941     4.552     0.200
    15.200     6.806     0.200
    15.625     3.956     0.200
    15.717     3.853     0.200
    15.819     4.017     0.200
    16.084     5.705     0.200
    16.226     5.979     0.200
    18.686    -0.442     0.200
    18.974    -0.007     0.200
    19.698    -0.002     0.200
    20.051     0.584     0.200
    20.152    -1.288     0.200
    20.152     0.485     0.200
    20.821     1.140     0.200
    20.955     0.088     0.200
    20.955    -0.521     0.200
    21.834     1.534     0.200
    21.834    -0.810     0.200
    21.821     1.675     0.200
    21.821    -0.364     0.200
    22.157     3.074     0.200
    22.150     1.955     0.200
    22.295     0.605     0.200
    22.334     1.796     0.200
    22.398     2.515     0.200
    22.384     0.452     0.200
    22.457    -0.410     0.200
    22.422     2.259     0.200
    22.475    -0.528     0.200
    23.017     0.247     0.200
    23.241     2.187     0.200
    23.483     0.648     0.200
    23.483    -0.273     0.200
    23.528     3.979     0.200
    23.627     1.669     0.200
    23.627     0.271     0.200
    23.789    -0.306     0.200
    23.753    -1.649     0.200
    23.753    -1.196     0.200
    23.797     1.118     0.200
    23.797     0.392     0.200
    23.926    -0.560     0.200
    23.926    -0.138     0.200
    24.225     3.209     0.200
    24.304    -1.616     0.200
    24.296     1.763     0.200
    24.318     1.858     0.200
    24.325    -0.341     0.200
    24.722     2.078     0.200
    24.784     2.213     0.200
    24.976     0.160     0.200
    25.065     1.760     0.200
    25.151     4.377     0.200
    25.277     1.633     0.200
    25.390     3.501     0.200
    25.424     3.796     0.200
    25.623     1.690     0.200
    25.819     0.271     0.200
    25.819     0.029     0.200
    25.981    -0.018     0.200
    25.910     2.180     0.200
    25.914    -0.154     0.200
    26.137    -1.063     0.200
    26.137    -0.165     0.200
    26.136    -0.112     0.200
    26.345     0.658     0.200
    27.009     1.859     0.200
    27.413     0.235     0.200
    27.453     0.373     0.200
    27.453    -0.478     0.200
    27.659    -0.073     0.200
    28.028    -0.892     0.200
    28.028    -1.298     0.200
    29.254    -0.476     0.200
    29.254    -0.498     0.200
    30.411    -1.651     0.200
    31.451    -1.095     0.200
    31.456    -2.141     0.200
    31.456    -1.243     0.200
    31.460    -0.551     0.200
    31.806     2.179     0.200
    32.624     1.603     0.200
    33.897    -0.837     0.200
    34.270     1.636     0.200
    34.270    -0.146     0.200
    34.270     1.854     0.200
    34.667    -0.778     0.200
    34.666    -0.222     0.200
    34.666    -0.683     0.200
    34.851    -0.811     0.200
    34.852    -0.631     0.200
    34.852    -0.350     0.200
    36.408     1.359     0.200
    36.491    -0.041     0.200
    37.015    -0.214     0.200
    37.482     0.371     0.200
    38.394     1.327     0.200
    38.504     1.096     0.200
    39.202     1.248     0.200
    39.245    -0.714     0.200
    39.541     0.023     0.200
    39.771     1.501     0.200
    39.996     0.528     0.200
    40.346     1.553     0.200
    40.346    -0.564     0.200
    40.402     0.770     0.200
    40.414     0.768     0.200
    40.520     0.709     0.200
    40.520    -0.314     0.200
    40.578     0.813     0.200
    40.669     0.861     0.200
    40.786    -0.953     0.200
    41.184     0.411     0.200
    41.992     0.790     0.200
    42.027     0.803     0.200
    43.617    -1.386     0.200
    44.121    -0.596     0.200
    44.916    -0.021     0.200
    44.916    -0.498     0.200
    44.836     0.844     0.200
    46.125     1.431     0.200
    46.125    -0.265     0.200
    48.278     0.545     0.200
    49.363    -0.488     0.200
    50.680     0.967     0.200
    50.680    -1.486     0.200
    50.957     0.324     0.200
    50.957     0.597     0.200
    50.957     1.426     0.200
    50.957     0.222     0.200
    51.147    -0.106     0.200
    51.324     0.774     0.200
    51.849     3.540     0.200
    52.020    -0.927     0.200
    52.020    -0.677     0.200
    52.155     1.323     0.200
    52.155    -0.434     0.200
    52.325    -0.932     0.200
    53.288     0.686     0.200
    53.830    -0.362     0.200
    53.830    -0.963     0.200
    53.830    -0.533     0.200
    54.030    -0.252     0.200
    55.081     0.589     0.200
    55.081     0.308     0.200
    55.081    -0.208     0.200
    55.758     0.034     0.200
    55.850     0.787     0.200
    56.631     0.104     0.200
    56.937     0.025     0.200
    56.937    -0.069     0.200
    60.743     0.728     0.200
    60.743    -0.327     0.200
    61.265     0.157     0.200
    61.595    -0.868     0.200
    63.392     0.152     0.200
    63.704     0.075     0.200
    63.709    -1.108     0.200
    64.344    -0.410     0.200
    64.777     0.585     0.200
    64.915     0.370     0.200
    65.026     0.493     0.200
    65.024     0.453     0.200
    65.024    -0.032     0.200
    65.691    -0.370     0.200
    67.276     0.023     0.200
    68.236    -0.634     0.200
    68.268    -0.729     0.200
    68.444    -0.011     0.200
    68.973    -0.109     0.200
    68.935     0.979     0.200
    75.530     0.870     0.200
    75.739     0.479     0.200
    75.762    -3.152     0.200
    76.806    -2.035     0.200
    76.979    -0.657     0.200
    77.632    -1.142     0.200
    79.045    -1.439     0.200
    79.114    -1.410     0.200
    79.202     0.507     0.200
    80.509    -2.162     0.200
    80.509    -1.177     0.200
    81.251    -0.280     0.200
    82.924    -0.818     0.200
    83.663    -0.932     0.200
    84.068    -0.300     0.200
    84.068    -1.793     0.200
    85.087    -1.704     0.200
    85.087    -0.704     0.200
    85.415    -2.719     0.200
    85.415    -1.383     0.200
    86.448     0.589     0.200
    87.115     1.933     0.200
    87.176     0.441     0.200
    88.621    -0.678     0.200
    88.625    -0.213     0.200
    89.463     1.028     0.200
    90.479     1.345     0.200
    92.021    -2.924     0.200
    92.503     1.263     0.200
    95.579    -0.803     0.200
    15.556     2.930     0.200
    15.569     2.648     0.200
    16.299     2.971     0.200
    21.178     1.432     0.200
    22.266     0.066     0.200
    22.531     3.252     0.200
    22.737     1.067     0.200
    23.026     0.817     0.200
    23.124     1.766     0.200
    23.255     0.461     0.200
    23.208     0.930     0.200
    23.749     1.712     0.200
    23.777     1.759     0.200
    24.013     2.909     0.200
    24.332     2.595     0.200
    24.413     1.475     0.200
    25.080     2.282     0.200
    25.144     1.995     0.200
    25.521     1.421     0.200
    25.493     1.894     0.200
    25.493     1.324     0.200
    25.493     2.121     0.200
    25.493    -0.285     0.200
    25.661     0.433     0.200
    25.593     2.525     0.200
    25.597     1.184     0.200
    26.833    -0.984     0.200
    27.635    -0.572     0.200
    27.793     0.187     0.200
    27.793     0.484     0.200
    31.226    -1.053     0.200
    31.891     1.595     0.200
    32.872     3.988     0.200
    34.043     0.883     0.200
    34.589    -0.806     0.200
    34.590    -0.899     0.200
    34.590    -1.548     0.200
    35.179     0.168     0.200
    35.178     0.591     0.200
    35.178     0.739     0.200
    36.488     1.438     0.200
    38.174     1.347     0.200
    38.274     1.004     0.200
    38.969     1.361     0.200
    39.548     1.423     0.200
    39.630     0.236     0.200
    40.036    -0.231     0.200
    40.036    -1.137     0.200
    40.173     0.633     0.200
    40.185     0.530     0.200
    40.412    -0.709     0.200
    40.352     0.649     0.200
    40.440     0.821     0.200
    40.593     0.550     0.200
    40.593     0.940     0.200
    40.761     0.266     0.200
    40.959     0.431     0.200
    41.758     0.866     0.200
    41.803     0.798     0.200
    44.068     1.851     0.200
    44.436     0.703     0.200
    44.713    -0.837     0.200
    44.999     0.005     0.200
    46.156     2.158     0.200
    50.733    -0.922     0.200
    50.992     0.926     0.200
    50.992     0.622     0.200
    50.992     0.348     0.200
    51.181     0.611     0.200
    51.355     0.110     0.200
    51.755     2.610     0.200
    51.947     0.384     0.200
    51.969     0.215     0.200
    52.481    -1.493     0.200
    52.476    -1.153     0.200
    52.476    -0.653     0.200
    52.470     0.090     0.200
    52.933     0.366     0.200
    53.965    -0.417     0.200
    53.972     1.233     0.200
    53.972     0.615     0.200
    54.537     0.656     0.200
    55.146     0.058     0.200
    55.146    -0.397     0.200
    55.146     0.244     0.200
    55.573     1.030     0.200
    56.501     0.241     0.200
    56.871     0.161     0.200
    58.214    -0.649     0.200
    59.070    -0.359     0.200
    60.217    -0.568     0.200
    60.803    -0.368     0.200
    62.037    -1.800     0.200
    62.037    -1.604     0.200
    64.862     1.250     0.200
    64.862     0.797     0.200
    64.862    -0.070     0.200
    65.600     0.036     0.200
    65.676    -0.425     0.200
    67.356    -0.418     0.200
    68.339    -0.913     0.200
    68.339    -1.351     0.200
    68.652    -0.270     0.200
    69.001    -0.623     0.200
    69.003    -0.563     0.200
    69.394    -1.070     0.200
    75.409     0.240     0.200
    76.331    -1.935     0.200
    76.883    -1.446     0.200
    78.238    -0.970     0.200
    79.119    -0.087     0.200
    79.106    -1.899     0.200
    79.366    -0.498     0.200
    79.470    -0.934     0.200
    79.498    -0.809     0.200
    79.681    -1.167     0.200
    79.683    -0.252     0.200
    79.911    -0.630     0.200
    79.992    -0.609     0.200
    80.279    -0.970     0.200
    80.327    -0.527     0.200
    80.734    -0.360     0.200
    81.012    -0.971     0.200
    81.121    -1.924     0.200
    81.121    -1.393     0.200
    81.848     0.616     0.200
    82.821     0.384     0.200
    83.543     0.299     0.200
    83.877    -0.944     0.200
    83.877    -0.382     0.200
    83.968    -0.733     0.200
    83.929    -0.518     0.200
    83.929    -0.370     0.200
    83.929     0.083     0.200
    83.929    -0.549     0.200
    84.744    -0.615     0.200
    85.076    -1.154     0.200
    85.209    -0.545     0.200
    85.210    -0.973     0.200
    85.210     0.402     0.200
    85.210    -0.551     0.200
    85.410    -1.617     0.200
    85.410    -0.289     0.200
    85.807     0.334     0.200
    86.637    -0.961     0.200
    87.231    -1.490     0.200
    87.315    -0.621     0.200
    88.552    -0.154     0.200
    88.585    -0.516     0.200
    88.590    -0.553     0.200
    90.182     1.101     0.200
    90.868    -2.499     0.200
    92.165    -1.548     0.200
    92.491     2.892     0.200
    95.363    -1.624     0.200
    14.244     4.801     0.200
    14.766     5.394     0.200
    15.047     3.035     0.200
    15.515     2.442     0.200
    15.452     4.597     0.200
    15.589     4.780     0.200
    15.586     6.677     0.200
    15.586     6.317     0.200
    15.586     4.739     0.200
    15.709     2.821     0.200
    15.783     1.961     0.200
    16.013     6.883     0.200
    16.152     7.593     0.200
    16.430     2.838     0.200
    17.146     1.838     0.200
    17.146     1.048     0.200
    18.660    -1.139     0.200
    20.133     0.160     0.200
    20.133     0.480     0.200
    20.903     1.158     0.200
    21.744     0.953     0.200
    21.772     1.117     0.200
    22.098     3.493     0.200
    22.237     2.310     0.200
    22.321     1.809     0.200
    22.318     0.547     0.200
    22.320     2.021     0.200
    22.424     2.023     0.200
    22.397     1.670     0.200
    22.421     1.519     0.200
    22.954     1.304     0.200
    23.203     1.573     0.200
    23.417     0.523     0.200
    23.550     1.068     0.200
    23.550     0.560     0.200
    23.788    -0.440     0.200
    23.788     0.770     0.200
    23.720     1.515     0.200
    23.720     0.726     0.200
    23.861    -0.879     0.200
    23.861     1.175     0.200
    24.153     2.655     0.200
    24.220     1.548     0.200
    24.300     0.476     0.200
    24.256     1.715     0.200
    24.349     2.372     0.200
    24.654     1.490     0.200
    24.900     3.548     0.200
    24.900     1.321     0.200
    24.963     4.177     0.200
    24.989     1.731     0.200
    25.229     2.253     0.200
    25.323     3.004     0.200
    25.354     1.717     0.200
    25.547     1.868     0.200
    25.756     0.576     0.200
    25.756     1.271     0.200
    25.756     0.068     0.200
    25.848     2.042     0.200
    25.852     0.904     0.200
    25.977     0.460     0.200
    26.059     0.680     0.200
    26.059     0.639     0.200
    26.614     3.112     0.200
    27.335     3.423     0.200
    27.335     0.962     0.200
    27.479    -0.271     0.200
    27.479     0.080     0.200
    27.536    -0.080     0.200
    27.445     0.374     0.200
    27.639     0.100     0.200
    27.639     0.295     0.200
    27.792     0.195     0.200
    28.014    -1.054     0.200
    28.080    -0.047     0.200
    29.301    -2.696     0.200
    29.301     0.961     0.200
    29.301     0.961     0.200
    30.445    -1.714     0.200
    30.664     1.737     0.200
    31.458    -2.138     0.200
    31.464    -2.239     0.200
    31.464    -2.513     0.200
    31.707    -1.015     0.200
    31.781     1.694     0.200
    32.618     2.748     0.200
    33.640     0.823     0.200
    33.972    -0.956     0.200
    34.215     1.262     0.200
    34.215     1.528     0.200
    34.697     0.129     0.200
    34.697    -0.348     0.200
    34.855    -1.264     0.200
    34.855    -1.717     0.200
    36.383     0.872     0.200
    37.045    -0.673     0.200
    38.339     1.279     0.200
    38.449     1.063     0.200
    39.146     1.307     0.200
    39.257    -1.211     0.200
    39.568    -1.718     0.200
    39.716     1.356     0.200
    40.339     0.549     0.200
    40.346     0.728     0.200
    40.358     0.524     0.200
    40.513     0.844     0.200
    40.513     0.141     0.200
    40.522     0.769     0.200
    40.614     0.812     0.200
    40.775    -0.379     0.200
    41.129     0.459     0.200
    41.936     0.942     0.200
    41.972     0.854     0.200
    43.638    -0.065     0.200
    43.734    -1.241     0.200
    44.122    -0.679     0.200
    44.748     1.841     0.200
    44.768     0.086     0.200
    44.927    -0.285     0.200
    46.094     1.970     0.200
    48.156    -0.494     0.200
    48.286    -0.524     0.200
    49.295    -1.273     0.200
    50.728     0.643     0.200
    50.728    -0.256     0.200
    50.732     0.617     0.200
    50.896    -0.315     0.200
    50.927     0.428     0.200
    50.927     0.553     0.200
    50.927     0.147     0.200
    51.117     0.625     0.200
    51.438    -0.090     0.200
    51.806     3.263     0.200
    52.042    -1.198     0.200
    52.042    -0.354     0.200
    52.103     0.710     0.200
    52.373    -1.141     0.200
    53.305    -1.298     0.200
    53.261     1.958     0.200
    53.349     0.988     0.200
    53.687     1.506     0.200
    53.811    -1.007     0.200
    53.824     1.939     0.200
    53.990     1.072     0.200
    53.990    -0.866     0.200
    53.990     0.704     0.200
    53.990     0.486     0.200
    54.224     0.701     0.200
    54.357     1.640     0.200
    54.490     1.354     0.200
    55.054     0.303     0.200
    55.054    -0.392     0.200
    55.706     0.501     0.200
    56.896     0.113     0.200
    60.715     0.091     0.200
    60.715    -0.940     0.200
    60.715    -0.018     0.200
    61.615    -1.537     0.200
    63.327     0.046     0.200
    63.708    -0.779     0.200
    63.640    -0.075     0.200
    64.130     0.267     0.200
    64.278    -0.629     0.200
    64.974    -0.173     0.200
    64.974    -0.009     0.200
    64.974    -0.009     0.200
    64.961    -0.167     0.200
    65.656    -0.543     0.200
    65.772     0.395     0.200
    67.251    -0.319     0.200
    68.226    -0.246     0.200
    68.268    -0.387     0.200
    68.241    -1.301     0.200
    68.241    -1.168     0.200
    68.241    -1.605     0.200
    68.349    -0.819     0.200
    68.402    -0.095     0.200
    68.375     0.023     0.200
    68.694    -1.123     0.200
    68.822    -1.123     0.200
    68.867     0.458     0.200
    69.009    -0.398     0.200
    69.037    -0.844     0.200
    69.248    -1.421     0.200
    69.577    -0.982     0.200
    69.691    -0.851     0.200
    73.505    -1.138     0.200
    75.483     0.049     0.200
    75.676    -0.158     0.200
    75.741    -2.431     0.200
    76.072    -2.025     0.200
    76.781    -2.097     0.200
    76.936    -2.414     0.200
    76.936    -0.781     0.200
    77.680     0.126     0.200
    79.010    -2.443     0.200
    79.079    -1.517     0.200
    79.625    -0.704     0.200
    79.711    -1.064     0.200
    79.758    -0.624     0.200
    80.430    -0.653     0.200
    80.558    -1.031     0.200
    82.974    -1.944     0.200
    83.653    -1.552     0.200
    84.020    -0.057     0.200
    84.020    -0.854     0.200
    84.020     0.247     0.200
    85.067    -1.123     0.200
    85.067    -2.045     0.200
    85.263    -0.832     0.200
    85.364    -0.132     0.200
    85.375    -0.888     0.200
    85.381    -1.890     0.200
    85.381    -0.515     0.200
    86.411    -1.617     0.200
    86.656    -0.873     0.200
    87.100     1.812     0.200
    87.873    -1.392     0.200
    88.012     0.928     0.200
    88.573    -0.356     0.200
    88.573    -1.224     0.200
    88.584     0.828     0.200
    88.584     0.227     0.200
    88.588    -0.184     0.200
    88.775    -1.839     0.200
    90.071     1.634     0.200
    90.442     0.524     0.200
    91.248    -0.472     0.200
    94.809    -0.343     0.200
    95.025    -3.128     0.200
    95.546    -0.384     0.200
    95.546    -0.712     0.200
    14.092     9.391     0.200
    14.804     4.145     0.200
    15.142     4.810     0.200
    15.525     6.366     0.200
    15.609     4.322     0.200
    15.585     4.607     0.200
    16.109     3.794     0.200
    17.132     3.822     0.200
    19.817     0.357     0.200
    20.041     0.209     0.200
    20.121    -0.076     0.200
    20.121    -0.350     0.200
    20.125    -0.398     0.200
    20.846     1.173     0.200
    21.144     2.101     0.200
    21.473     4.418     0.200
    21.844     2.727     0.200
    21.844     1.251     0.200
    21.862     2.271     0.200
    22.165     2.692     0.200
    22.302     0.541     0.200
    22.387     2.434     0.200
    22.466     2.291     0.200
    22.465     2.495     0.200
    22.465     1.050     0.200
    22.449     1.477     0.200
    22.541     1.854     0.200
    23.030     1.507     0.200
    23.304     2.420     0.200
    23.557     3.864     0.200
    23.547     1.470     0.200
    23.547     1.119     0.200
    23.740     1.475     0.200
    23.771    -0.426     0.200
    23.771    -0.051     0.200
    23.847     1.433     0.200
    23.941     2.429     0.200
    24.286     3.096     0.200
    24.330     0.889     0.200
    24.383     2.423     0.200
    24.351     2.404     0.200
    24.785     3.343     0.200
    25.017     1.633     0.200
    25.122     2.182     0.200
    25.342     3.284     0.200
    25.454     4.466     0.200
    25.939     0.321     0.200
    25.884     1.062     0.200
    25.884     1.414     0.200
    25.884     1.859     0.200
    25.884     1.055     0.200
    25.976     3.135     0.200
    25.980     0.895     0.200
    26.183     1.029     0.200
    26.183     0.154     0.200
    26.183     0.129     0.200
    26.372    -1.154     0.200
    27.058     0.567     0.200
    27.480     0.277     0.200
    27.480    -0.527     0.200
    27.537     0.733     0.200
    27.464     0.573     0.200
    27.715     1.763     0.200
    27.991    -1.458     0.200
    28.177     0.844     0.200
    29.262    -2.107     0.200
    30.707     0.298     0.200
    31.401    -0.948     0.200
    31.407    -1.893     0.200
    31.407    -0.198     0.200
    31.709    -0.580     0.200
    31.865     1.498     0.200
    32.673     4.404     0.200
    33.652     0.664     0.200
    34.336     0.410     0.200
    34.690     0.032     0.200
    34.690    -0.444     0.200
    34.759     1.166     0.200
    34.804    -1.884     0.200
    34.805    -0.837     0.200
    34.805    -2.142     0.200
    36.467     0.684     0.200
    37.492    -0.512     0.200
    38.460     1.688     0.200
    38.570     1.466     0.200
    39.283    -0.803     0.200
    39.283     1.900     0.200
    39.268     1.619     0.200
    39.566    -0.744     0.200
    39.566    -1.970     0.200
    39.837     1.170     0.200
    40.008    -0.652     0.200
    40.008    -1.371     0.200
    40.395     0.347     0.200
    40.395     1.308     0.200
    40.467     0.245     0.200
    40.480     0.244     0.200
    40.570     1.140     0.200
    40.570     0.694     0.200
    40.644     0.289     0.200
    40.748    -0.680     0.200
    40.735     0.431     0.200
    41.250    -0.017     0.200
    41.949    -0.893     0.200
    42.058     0.567     0.200
    42.093     0.486     0.200
    43.244    -0.071     0.200
    43.647    -1.119     0.200
    43.843    -1.434     0.200
    44.074    -0.186     0.200
    44.865     0.449     0.200
    44.865    -0.075     0.200
    44.804     2.510     0.200
    44.804     0.439     0.200
    44.899    -0.352     0.200
    46.186     3.259     0.200
    48.319    -0.465     0.200
    50.522     0.179     0.200
    50.685     0.042     0.200
    50.685    -0.130     0.200
    50.823     0.127     0.200
    51.017     0.540     0.200
    51.017     0.970     0.200
    51.017    -0.335     0.200
    51.208     0.439     0.200
    51.474     0.663     0.200
    51.913     3.354     0.200
    52.050    -1.356     0.200
    52.050    -1.528     0.200
    52.063     1.343     0.200
    52.260    -0.059     0.200
    52.221     0.270     0.200
    52.601     0.948     0.200
    53.050     1.232     0.200
    53.886    -0.222     0.200
    53.886    -0.433     0.200
    54.093    -0.324     0.200
    54.682     0.678     0.200
    55.140    -1.027     0.200
    55.140     0.005     0.200
    55.141    -0.060     0.200
    55.824     0.952     0.200
    55.844     0.701     0.200
    55.915     0.687     0.200
    57.000     0.359     0.200
    57.000     0.265     0.200
    57.000     0.624     0.200
    60.730    -0.221     0.200
    60.802    -0.750     0.200
    60.802     0.289     0.200
    61.331     0.942     0.200
    61.626    -2.336     0.200
    61.626     0.313     0.200
    63.755    -1.059     0.200
    65.089     1.751     0.200
    65.089     2.447     0.200
    65.753    -0.354     0.200
    67.230    -0.098     0.200
    67.334    -0.581     0.200
    68.175    -1.298     0.200
    68.187    -0.690     0.200
    68.263    -1.425     0.200
    68.314    -0.120     0.200
    68.326    -1.114     0.200
    68.326    -0.832     0.200
    68.910    -0.885     0.200
    69.482    -1.164     0.200
    75.819    -2.526     0.200
    75.804     1.361     0.200
    76.182     1.708     0.200
    76.778    -1.846     0.200
    77.043    -1.267     0.200
    77.570    -0.922     0.200
    79.176    -1.601     0.200
    79.330    -0.066     0.200
    79.263    -2.383     0.200
    80.514    -1.638     0.200
    80.520    -1.989     0.200
    81.259    -1.367     0.200
    81.184     0.359     0.200
    82.928    -0.350     0.200
    83.714    -0.670     0.200
    84.133    -0.686     0.200
    84.133    -0.342     0.200
    84.133     0.712     0.200
    84.133    -0.569     0.200
    85.144    -1.121     0.200
    85.144    -0.894     0.200
    85.477    -1.208     0.200
    85.477    -0.060     0.200
    86.606    -0.701     0.200
    86.511     0.020     0.200
    87.231     1.412     0.200
    87.232     1.502     0.200
    87.975     0.038     0.200
    88.676     0.117     0.200
    88.684     0.989     0.200
    88.684     0.036     0.200
    88.688    -0.242     0.200
    88.805    -2.184     0.200
    89.629    -2.252     0.200
    90.542    -0.814     0.200
    92.076    -2.632     0.200
    92.076    -1.734     0.200
    94.138    -0.739     0.200
    95.641    -0.333     0.200
    95.641     0.135     0.200
    15.434     3.643     0.200
    19.175    -3.132     0.200
    20.629     0.873     0.200
    22.255     2.413     0.200
    22.323     2.964     0.200
    22.466     1.011     0.200
    23.342     2.855     0.200
    23.342     4.886     0.200
    23.425     2.105     0.200
    23.425     0.582     0.200
    23.480    -0.009     0.200
    23.655     0.231     0.200
    23.726     1.318     0.200
    23.726     1.091     0.200
    24.137     3.469     0.200
    24.171     4.060     0.200
    24.403     1.097     0.200
    24.654     2.855     0.200
    24.778     4.922     0.200
    25.773     1.186     0.200
    25.773     1.186     0.200
    25.840     4.080     0.200
    25.983     0.586     0.200
    25.983     0.086     0.200
    25.982     0.131     0.200
    26.520    -0.475     0.200
    27.275     3.411     0.200
    27.630    -0.155     0.200
    27.630     0.345     0.200
    27.750     0.270     0.200
    27.870     0.629     0.200
    31.338    -1.792     0.200
    31.884     1.959     0.200
    34.725    -0.725     0.200
    34.725    -1.225     0.200
    34.849     0.008     0.200
    34.849     0.258     0.200
    34.849    -0.195     0.200
    36.484     0.965     0.200
    36.498     2.557     0.200
    36.951    -1.806     0.200
    38.382     1.180     0.200
    38.489     1.281     0.200
    39.186     1.243     0.200
    39.720    -0.561     0.200
    39.720    -1.015     0.200
    39.758     1.368     0.200
    40.387     0.650     0.200
    40.399     0.344     0.200
    40.467     0.886     0.200
    40.564     0.685     0.200
    40.640     0.339     0.200
    40.640     0.456     0.200
    40.654     0.837     0.200
    41.171     0.384     0.200
    41.976     0.784     0.200
    42.014     0.771     0.200
    42.938     1.519     0.200
    43.786    -0.199     0.200
    44.805    -0.353     0.200
    51.021     0.801     0.200
    51.021     0.676     0.200
    51.021     0.348     0.200
    51.211     0.970     0.200
    51.448     1.564     0.200
    51.876     3.699     0.200
    52.038     1.192     0.200
    52.191    -0.645     0.200
    52.154     0.925     0.200
    52.572     0.526     0.200
    53.922    -0.487     0.200
    53.922    -0.737     0.200
    53.922    -0.612     0.200
    54.067     1.473     0.200
    54.067    -1.472     0.200
    54.067     0.418     0.200
    54.649     0.655     0.200
    55.154    -0.155     0.200
    55.154     0.665     0.200
    55.757     0.696     0.200
    55.803     0.967     0.200
    56.647     1.466     0.200
    56.972     0.339     0.200
    56.972    -0.068     0.200
    60.742    -0.301     0.200
    60.814    -1.158     0.200
    60.814    -0.119     0.200
    61.260     0.038     0.200
    61.763    -3.180     0.200
    61.763    -2.375     0.200
    63.654    -0.417     0.200
    63.841    -0.677     0.200
    65.030     0.565     0.200
    65.030     0.761     0.200
    65.030    -0.310     0.200
    65.741    -0.741     0.200
    67.221    -0.804     0.200
    68.342    -2.244     0.200
    68.342    -0.783     0.200
    68.956    -2.314     0.200
    69.396    -1.016     0.200
    75.692    -0.096     0.200
    79.166    -0.744     0.200
    80.290    -2.549     0.200
    80.708    -1.345     0.200
    80.708    -1.345     0.200
    84.081     0.458     0.200
    85.177    -1.244     0.200
    85.468    -1.702     0.200
    85.468    -1.702     0.200
    95.120    -0.612     0.200
    17.118     2.691     0.200
    19.284    -0.133     0.200
    19.693     0.662     0.200
    21.824     0.081     0.200
    23.475     0.629     0.200
    23.617    -0.447     0.200
    23.759    -2.896     0.200
    23.787     0.557     0.200
    23.787     0.158     0.200
    23.916     1.319     0.200
    25.812     0.877     0.200
    25.979    -0.362     0.200
    27.458     0.067     0.200
    27.515     0.586     0.200
    27.500     0.063     0.200
    28.024     0.064     0.200
    29.262    -0.076     0.200
    29.262    -0.388     0.200
    29.264     0.199     0.200
    29.957    -0.593     0.200
    30.903    -1.904     0.200
    34.851    -0.063     0.200
    38.388     1.526     0.200
    38.498     1.500     0.200
    39.196     1.252     0.200
    39.765     1.301     0.200
    40.395     0.367     0.200
    40.408     0.569     0.200
    40.521     2.685     0.200
    40.572     0.511     0.200
    40.663     0.756     0.200
    41.178     0.508     0.200
    41.986     0.989     0.200
    42.021     0.806     0.200
    44.119     0.067     0.200
    50.955     0.638     0.200
    50.955     0.638     0.200
    51.145     0.451     0.200
    55.079    -0.710     0.200
    55.752     0.777     0.200
    55.845    -0.352     0.200
    56.626    -0.378     0.200
    56.933    -0.620     0.200
    56.933    -0.175     0.200
    61.259    -0.218     0.200
    68.266    -1.164     0.200
    75.732    -0.611     0.200
    76.823     0.242     0.200
    76.975    -0.954     0.200
    83.663    -2.561     0.200
    83.808    -1.101     0.200
    85.087    -2.185     0.200
    92.383    -1.095     0.200
    92.784    -1.494     0.200
    14.045     9.703     0.200
    14.112     9.953     0.200
    15.154     7.412     0.200
    15.411     3.066     0.200
    16.328     1.120     0.200
    17.317     4.683     0.200
    18.499    -0.286     0.200
    19.529     0.500     0.200
    20.708    -0.904     0.200
    20.750    -1.097     0.200
    20.720     0.993     0.200
    21.589    -1.187     0.200
    21.593     4.090     0.200
    21.593    -0.060     0.200
    21.789     2.893     0.200
    21.914     2.852     0.200
    22.053     2.872     0.200
    22.182     2.790     0.200
    22.265     2.610     0.200
    22.422     2.742     0.200
    22.416    -0.492     0.200
    22.552     1.165     0.200
    22.771     3.239     0.200
    23.009    -0.189     0.200
    23.294     2.185     0.200
    23.294     4.128     0.200
    23.282     3.654     0.200
    23.368     1.354     0.200
    23.417     0.729     0.200
    23.417     0.069     0.200
    23.592     1.100     0.200
    23.592     0.060     0.200
    23.680     2.600     0.200
    23.961    -0.737     0.200
    24.226    -0.794     0.200
    24.226    -0.791     0.200
    24.059     1.429     0.200
    24.076     1.982     0.200
    24.108     2.084     0.200
    24.223     2.138     0.200
    24.374     0.620     0.200
    24.595     1.149     0.200
    24.748    -0.186     0.200
    24.885     2.002     0.200
    25.106     4.291     0.200
    25.246     2.027     0.200
    25.246     0.427     0.200
    25.268     5.327     0.200
    25.289     2.331     0.200
    25.415     0.793     0.200
    25.437     2.392     0.200
    25.716     2.685     0.200
    25.716     0.845     0.200
    25.716     0.847     0.200
    25.716     1.255     0.200
    25.716     0.595     0.200
    25.811     2.602     0.200
    25.815    -0.035     0.200
    25.921     1.244     0.200
    25.921    -0.297     0.200
    25.920    -0.251     0.200
    26.571     4.528     0.200
    26.799     2.074     0.200
    27.642     0.005     0.200
    27.642    -0.501     0.200
    27.699     0.294     0.200
    27.725     0.160     0.200
    27.725    -0.240     0.200
    27.868    -1.439     0.200
    27.868    -1.106     0.200
    28.133     0.823     0.200
    29.481    -1.483     0.200
    29.481    -1.463     0.200
    30.792    -0.549     0.200
    30.811     0.576     0.200
    31.348    -1.252     0.200
    31.348    -0.672     0.200
    31.353    -2.369     0.200
    31.353    -2.369     0.200
    31.353    -1.497     0.200
    31.357    -1.463     0.200
    31.855     1.889     0.200
    32.731     3.504     0.200
    33.795     1.023     0.200
    34.205     1.414     0.200
    34.205     0.363     0.200
    34.205    -0.436     0.200
    34.737    -0.969     0.200
    34.738    -1.196     0.200
    34.738    -1.747     0.200
    34.865     0.384     0.200
    34.865    -0.141     0.200
    34.923     0.259     0.200
    34.923     0.049     0.200
    36.455     1.509     0.200
    36.451     2.948     0.200
    36.451     1.748     0.200
    36.653    -0.372     0.200
    36.984     0.557     0.200
    38.331     1.312     0.200
    38.438     1.118     0.200
    39.135     1.376     0.200
    39.400    -1.941     0.200
    39.400    -0.352     0.200
    39.733    -0.916     0.200
    39.707     1.400     0.200
    40.217    -1.430     0.200
    40.336     0.685     0.200
    40.348     0.682     0.200
    40.453     0.889     0.200
    40.453     0.117     0.200
    40.633    -0.774     0.200
    40.513     0.719     0.200
    40.625     0.632     0.200
    40.625     0.293     0.200
    40.603     0.774     0.200
    41.120     0.414     0.200
    41.925     1.019     0.200
    41.963     0.705     0.200
    43.795    -0.835     0.200
    43.844    -1.132     0.200
    44.001    -0.556     0.200
    44.823    -0.688     0.200
    44.706    -0.929     0.200
    44.861     0.404     0.200
    44.861     0.715     0.200
    46.155     2.095     0.200
    46.155     1.195     0.200
    48.084     0.030     0.200
    48.424    -0.079     0.200
    50.989     0.104     0.200
    50.989     0.624     0.200
    50.989     0.684     0.200
    50.989     0.679     0.200
    50.989     0.504     0.200
    50.988    -0.496     0.200
    51.178    -0.220     0.200
    51.178     0.620     0.200
    51.327    -0.536     0.200
    51.833     2.578     0.200
    51.999     0.746     0.200
    52.199    -0.836     0.200
    52.106     0.352     0.200
    52.986     1.235     0.200
    53.297     1.621     0.200
    53.389     0.367     0.200
    53.389     1.177     0.200
    53.860     2.351     0.200
    53.897    -0.509     0.200
    53.897    -0.534     0.200
    53.897    -0.759     0.200
    54.000     0.888     0.200
    54.027     2.015     0.200
    54.027     0.090     0.200
    54.027     0.310     0.200
    54.264     0.709     0.200
    54.391     1.618     0.200
    54.607     0.541     0.200
    55.123     0.397     0.200
    55.123    -0.563     0.200
    55.123     0.256     0.200
    55.709     0.523     0.200
    55.760     0.456     0.200
    56.931    -0.195     0.200
    56.931     0.106     0.200
    60.784    -0.048     0.200
    60.784    -0.648     0.200
    60.784     0.242     0.200
    61.770    -2.422     0.200
    61.770    -1.822     0.200
    63.832    -0.652     0.200
    64.085     0.084     0.200
    64.438    -3.531     0.200
    64.228    -0.172     0.200
    64.656     0.300     0.200
    64.810    -0.027     0.200
    64.917     0.139     0.200
    64.983     0.787     0.200
    64.983     0.432     0.200
    65.536     0.452     0.200
    65.705    -0.858     0.200
    65.705    -0.558     0.200
    65.735    -0.772     0.200
    65.739     0.512     0.200
    65.739     0.856     0.200
    65.820    -0.136     0.200
    65.820    -0.469     0.200
    65.861     1.296     0.200
    65.882     0.566     0.200
    65.952     0.044     0.200
    66.236     0.547     0.200
    66.312     0.061     0.200
    66.616     0.442     0.200
    67.324    -0.307     0.200
    68.312    -1.133     0.200
    68.312    -0.972     0.200
    68.316    -0.265     0.200
    68.963    -0.463     0.200
    75.498     0.864     0.200
    75.636     0.120     0.200
    75.824    -2.505     0.200
    76.620    -1.904     0.200
    76.963     1.239     0.200
    77.524    -0.505     0.200
    77.861    -0.745     0.200
    78.982    -0.475     0.200
    79.130    -1.287     0.200
    79.224    -0.301     0.200
    80.494    -2.876     0.200
    80.740    -1.298     0.200
    80.740    -1.093     0.200
    81.477    -0.565     0.200
    83.157    -0.857     0.200
    83.759    -0.168     0.200
    84.036     0.254     0.200
    85.151    -0.939     0.200
    85.151    -0.961     0.200
    85.547     0.014     0.200
    85.423    -1.497     0.200
    85.433    -1.444     0.200
    85.433    -0.545     0.200
    86.992     1.470     0.200
    88.050     2.187     0.200
    88.355     0.045     0.200
    88.597    -2.229     0.200
    88.610    -1.359     0.200
    88.610     2.487     0.200
    88.627    -0.041     0.200
    92.093    -1.493     0.200
    92.093    -1.464     0.200
    94.702    -0.577     0.200
    94.990    -1.295     0.200
    94.990    -0.724     0.200
    95.087     0.231     0.200
    95.601    -0.621     0.200
    18.964    -2.446     0.200
    19.651    -1.881     0.200
    25.813     1.109     0.200
    27.982     0.785     0.200
    27.982    -0.705     0.200
    31.420    -1.492     0.200
    31.420    -1.214     0.200
    31.424    -0.529     0.200
    34.273    -1.307     0.200
    34.814    -0.600     0.200
    38.397     1.251     0.200
    38.506     1.133     0.200
    39.204     1.486     0.200
    39.774     1.533     0.200
    40.404     0.706     0.200
    40.416     0.604     0.200
    40.671     1.294     0.200
    41.994     1.030     0.200
    42.030     0.940     0.200
    50.980    -1.014     0.200
    50.980     0.916     0.200
    50.980     0.666     0.200
    52.161    -0.356     0.200
    53.859    -0.296     0.200
    53.859    -1.356     0.200
    55.106     0.286     0.200
    56.641    -0.786     0.200
    56.952    -0.293     0.200
    56.952    -0.573     0.200
    60.767    -0.663     0.200
    63.748    -0.498     0.200
    65.710    -0.553     0.200
    85.435    -0.382     0.200
    14.130    10.826     0.200
    14.553     4.459     0.200
    18.632    -0.262     0.200
    18.904    -0.701     0.200
    19.654     1.223     0.200
    22.368     1.613     0.200
    22.447     2.084     0.200
    23.413    -0.717     0.200
    23.532    -1.041     0.200
    23.703    -0.913     0.200
    23.772     0.844     0.200
    25.754     1.004     0.200
    25.754    -0.289     0.200
    25.953    -0.562     0.200
    26.040    -0.104     0.200
    26.040    -1.376     0.200
    27.988    -1.405     0.200
    28.093    -0.147     0.200
    31.442    -1.801     0.200
    32.640     2.868     0.200
    34.218    -0.189     0.200
    34.726     1.005     0.200
    34.726     0.087     0.200
    34.832    -0.705     0.200
    34.833    -1.420     0.200
    34.833    -0.443     0.200
    36.398     2.731     0.200
    39.597     0.881     0.200
    44.906    -1.577     0.200
    44.906     0.298     0.200
    46.108     1.725     0.200
    50.941    -0.278     0.200
    50.941     0.003     0.200
    50.941    -0.501     0.200
    51.815     3.941     0.200
    51.971     0.086     0.200
    52.069     0.334     0.200
    52.108    -1.148     0.200
    55.069    -0.850     0.200
    56.906    -0.709     0.200
    60.730    -1.093     0.200
    61.642    -0.421     0.200
    65.668    -0.896     0.200
    65.668    -0.185     0.200
    95.039    -0.844     0.200
    20.149     1.891     0.200
    22.419     0.660     0.200
    23.459    -0.164     0.200
    23.602    -0.134     0.200
    23.794    -0.245     0.200
    23.771     0.586     0.200
    25.796     1.121     0.200
    25.984     0.419     0.200
    26.111    -0.121     0.200
    26.110    -0.845     0.200
    26.110    -0.115     0.200
    27.458     1.159     0.200
    28.027    -2.146     0.200
    28.100     0.149     0.200
    31.457    -0.817     0.200
    31.462    -2.183     0.200
    31.462    -1.461     0.200
    31.466    -1.366     0.200
    31.794     2.247     0.200
    32.618     2.613     0.200
    34.249     0.726     0.200
    34.856    -1.283     0.200
    34.857    -1.209     0.200
    34.857    -1.100     0.200
    36.396     1.322     0.200
    38.374     1.557     0.200
    38.483     1.032     0.200
    39.181     1.382     0.200
    39.750     1.433     0.200
    40.091     1.102     0.200
    40.381     0.502     0.200
    40.393     0.599     0.200
    40.557     0.646     0.200
    40.786    -1.867     0.200
    41.971     0.920     0.200
    42.006     0.833     0.200
    44.125    -0.485     0.200
    44.923    -0.426     0.200
    46.111     1.197     0.200
    50.944     0.641     0.200
    50.944     1.032     0.200
    50.944     0.309     0.200
    51.832     3.128     0.200
    51.983     0.888     0.200
    52.135    -0.723     0.200
    53.820    -1.089     0.200
    55.068     0.195     0.200
    55.832     0.878     0.200
    56.920     0.560     0.200
    56.920    -0.280     0.200
    60.730    -0.266     0.200
    20.037    -0.745     0.200
    25.813     3.840     0.200
    31.365    -2.660     0.200
    34.757    -1.697     0.200
    51.018    -0.134     0.200
    84.099     1.261     0.200
    19.511    -1.272     0.200
    20.616    -1.134     0.200
    23.633    -3.207     0.200
    25.816     3.098     0.200
    25.816     0.263     0.200
    25.914    -1.603     0.200
    27.274    -0.650     0.200
    30.315    -1.831     0.200
    31.299    -3.079     0.200
    31.305    -1.500     0.200
    31.305    -2.185     0.200
    34.300    -0.436     0.200
    34.694     0.136     0.200
    34.694    -0.994     0.200
    51.062     0.651     0.200
    51.062    -0.229     0.200
    55.193     0.731     0.200
    57.014     1.087     0.200
    80.711    -3.960     0.200
    85.214    -1.586     0.200
    18.474    -0.815     0.200
    19.941    -1.136     0.200
    20.602    -3.218     0.200
    23.533     2.826     0.200
    23.566     2.302     0.200
    25.881    -0.599     0.200
    25.881     3.507     0.200
    26.066     2.032     0.200
    27.665     0.499     0.200
    27.836     1.440     0.200
    29.455     0.228     0.200
    31.262    -0.850     0.200
    31.262    -0.663     0.200
    31.266    -2.061     0.200
    34.654     0.096     0.200
    34.654    -1.916     0.200
    34.878    -2.135     0.200
    34.878    -2.257     0.200
    43.057     0.129     0.200
    43.921     0.674     0.200
    44.726    -0.806     0.200
    44.726    -2.302     0.200
    51.116     0.368     0.200
    51.116    -0.234     0.200
    51.116    -0.702     0.200
    51.306     0.501     0.200
    54.008    -0.231     0.200
    54.008    -0.599     0.200
    55.246     1.069     0.200
    55.973     1.388     0.200
    57.074     0.802     0.200
    57.074     1.411     0.200
    57.074     0.599     0.200
    60.907     0.509     0.200
    65.136    -0.539     0.200
    65.136    -1.590     0.200
    65.840    -0.943     0.200
    75.800     0.995     0.200
    80.707    -1.134     0.200
    80.707     0.749     0.200
    80.707    -1.614     0.200
    83.854     0.020     0.200
    14.006     5.728     0.200
    14.264     4.545     0.200
    14.580     4.337     0.200
    14.786     3.423     0.200
    15.067     5.399     0.200
    15.453     4.490     0.200
    15.490     5.301     0.200
    15.494     5.702     0.200
    15.583     4.215     0.200
    15.583     2.449     0.200
    15.779     4.555     0.200
    16.034     3.660     0.200
    16.177     2.210     0.200
    16.468     3.396     0.200
    17.151     5.676     0.200
    17.151     3.894     0.200
    18.791    -0.615     0.200
    20.675     0.707     0.200
    20.909     0.163     0.200
    21.130    -0.620     0.200
    21.417     4.225     0.200
    21.785    -0.395     0.200
    21.773     2.501     0.200
    21.773     0.313     0.200
    22.109     2.116     0.200
    22.247     1.942     0.200
    22.353     2.318     0.200
    22.348     3.161     0.200
    22.357     0.471     0.200
    22.408     1.837     0.200
    22.460     0.616     0.200
    22.968     2.500     0.200
    22.992     3.043     0.200
    23.201     2.145     0.200
    23.238     2.547     0.200
    23.434     2.093     0.200
    23.491     1.096     0.200
    23.479     3.417     0.200
    23.456     0.551     0.200
    23.456    -0.175     0.200
    23.583     1.453     0.200
    23.583     0.133     0.200
    23.770    -0.728     0.200
    23.770    -1.470     0.200
    23.754     0.894     0.200
    23.754     0.706     0.200
    23.793     2.286     0.200
    23.793    -0.441     0.200
    23.876     3.171     0.200
    23.876    -0.399     0.200
    24.046    -0.952     0.200
    24.030     1.522     0.200
    24.266     2.918     0.200
    24.256     1.408     0.200
    24.331     0.153     0.200
    24.693     2.026     0.200
    24.735     2.842     0.200
    24.929     3.277     0.200
    24.929     1.199     0.200
    25.026     1.688     0.200
    25.103     3.595     0.200
    25.184     3.156     0.200
    25.215     1.677     0.200
    25.267     2.206     0.200
    25.267     0.401     0.200
    25.362     2.940     0.200
    25.394     3.248     0.200
    25.448     4.760     0.200
    25.501     1.824     0.200
    25.583     1.629     0.200
    25.602     1.958     0.200
    25.795     1.215     0.200
    25.795     0.277     0.200
    25.795     0.855     0.200
    25.795     0.012     0.200
    25.957    -0.358     0.200
    25.957    -0.898     0.200
    25.887     1.580     0.200
    25.891     0.644     0.200
    25.964     2.987     0.200
    26.050    -1.036     0.200
    26.091     0.705     0.200
    26.091     0.330     0.200
    26.091     0.313     0.200
    26.654     2.152     0.200
    26.822    -0.068     0.200
    26.965     0.447     0.200
    27.370     2.502     0.200
    27.370     1.307     0.200
    27.489     0.243     0.200
    27.489     1.876     0.200
    27.546    -1.160     0.200
    27.669    -0.174     0.200
    27.669    -0.674     0.200
    27.790    -0.525     0.200
    27.998    -0.622     0.200
    27.998    -1.013     0.200
    27.998    -1.255     0.200
    28.115     0.843     0.200
    29.299     0.316     0.200
    29.299     0.825     0.200
    29.299    -0.878     0.200
    29.962    -2.752     0.200
    30.411    -0.878     0.200
    30.411    -1.823     0.200
    30.686    -0.855     0.200
    31.433    -1.343     0.200
    31.433    -1.718     0.200
    31.439    -1.444     0.200
    31.439    -1.788     0.200
    31.442    -1.744     0.200
    31.464    -1.903     0.200
    31.584    -1.709     0.200
    31.664    -2.383     0.200
    31.679    -2.255     0.200
    31.681    -1.305     0.200
    31.688    -1.977     0.200
    31.698    -2.165     0.200
    31.698    -1.353     0.200
    31.698    -1.849     0.200
    31.702    -2.125     0.200
    31.703    -2.118     0.200
    31.717    -1.577     0.200
    31.727    -1.711     0.200
    31.749    -2.120     0.200
    31.776    -1.847     0.200
    31.813     1.820     0.200
    32.643     3.233     0.200
    32.989     0.604     0.200
    33.653     2.514     0.200
    33.934    -0.020     0.200
    33.996    -0.969     0.200
    34.355     0.063     0.200
    34.254     1.183     0.200
    34.254     0.191     0.200
    34.254    -0.606     0.200
    34.704    -0.107     0.200
    34.704     0.980     0.200
    34.704    -0.005     0.200
    34.831    -0.826     0.200
    34.832    -0.740     0.200
    34.832    -1.107     0.200
    34.769     0.338     0.200
    34.769    -0.318     0.200
    35.098    -0.502     0.200
    36.414     1.309     0.200
    36.479     1.356     0.200
    36.852    -1.329     0.200
    37.012    -1.083     0.200
    37.526     2.184     0.200
    37.527     2.177     0.200
    38.378     1.366     0.200
    38.488     1.142     0.200
    39.185     1.498     0.200
    39.274    -0.445     0.200
    39.577    -0.877     0.200
    39.659    -1.281     0.200
    39.755     1.644     0.200
    40.039     0.485     0.200
    40.039    -1.616     0.200
    40.096     1.415     0.200
    40.364     0.098     0.200
    40.385     0.815     0.200
    40.397     0.611     0.200
    40.538     1.313     0.200
    40.538    -0.804     0.200
    40.561     0.661     0.200
    40.653     0.908     0.200
    40.758    -0.343     0.200
    40.758    -1.694     0.200
    41.227    -1.163     0.200
    41.168     0.557     0.200
    41.304    -0.762     0.200
    41.845    -0.999     0.200
    41.848     2.679     0.200
    41.975     0.942     0.200
    42.011     0.949     0.200
    43.016     0.177     0.200
    43.232    -0.914     0.200
    43.232    -1.570     0.200
    43.459     2.396     0.200
    43.650    -1.444     0.200
    43.900    -0.956     0.200
    44.100    -0.361     0.200
    44.773     1.186     0.200
    44.773     1.061     0.200
    44.900    -0.275     0.200
    44.900    -0.400     0.200
    44.807     0.494     0.200
    45.460    -1.049     0.200
    46.208    -0.496     0.200
    46.127     1.534     0.200
    46.127     0.932     0.200
    48.125    -0.015     0.200
    48.305    -0.940     0.200
    49.335    -0.344     0.200
    49.443    -0.025     0.200
    50.725    -0.195     0.200
    50.725     1.423     0.200
    50.725    -0.195     0.200
    50.867     0.534     0.200
    50.960     0.232     0.200
    50.960     0.810     0.200
    50.960     0.482     0.200
    50.977    -0.095     0.200
    51.150    -0.298     0.200
    51.150     0.467     0.200
    51.411    -0.126     0.200
    51.411     0.546     0.200
    51.321     0.827     0.200
    51.407     0.630     0.200
    51.842     3.825     0.200
    51.996     0.080     0.200
    52.053    -0.950     0.200
    52.053    -0.700     0.200
    52.142     0.495     0.200
    52.336     0.545     0.200
    52.533     0.695     0.200
    52.983     0.367     0.200
    53.159    -0.057     0.200
    53.297     1.844     0.200
    53.385     0.104     0.200
    53.385     1.275     0.200
    53.723     1.684     0.200
    53.840    -0.720     0.200
    53.840     0.077     0.200
    53.840    -1.134     0.200
    53.987     1.097     0.200
    53.998    -0.787     0.200
    54.026     1.251     0.200
    54.026     0.907     0.200
    54.259     0.594     0.200
    54.393     1.858     0.200
    54.526     1.418     0.200
    54.612     0.488     0.200
    55.086     0.326     0.200
    55.086     0.599     0.200
    55.087     0.551     0.200
    55.745     0.467     0.200
    55.772    -0.131     0.200
    55.841     0.233     0.200
    56.789    -0.886     0.200
    56.932     0.201     0.200
    56.932     0.100     0.200
    56.932     0.240     0.200
    57.597     0.505     0.200
    59.961    -2.933     0.200
    60.676     0.015     0.200
    60.748    -0.091     0.200
    61.251    -0.054     0.200
    61.627    -1.773     0.200
    61.627    -2.367     0.200
    63.050    -0.731     0.200
    63.367    -0.113     0.200
    63.679    -0.333     0.200
    63.767    -0.609     0.200
    63.731    -0.275     0.200
    64.266    -0.616     0.200
    64.215     0.816     0.200
    64.749    -0.048     0.200
    64.894    -0.494     0.200
    64.891    -0.360     0.200
    65.001    -0.155     0.200
    65.112    -1.062     0.200
    65.012     0.787     0.200
    65.012    -0.236     0.200
    65.012     0.303     0.200
    65.617    -0.159     0.200
    65.690    -0.379     0.200
    65.690    -0.465     0.200
    65.690    -0.730     0.200
    65.811     0.935     0.200
    66.029     0.352     0.200
    66.647     0.647     0.200
    66.693     0.194     0.200
    67.168    -0.117     0.200
    67.282    -0.160     0.200
    67.310     0.455     0.200
    67.443     0.515     0.200
    68.031     0.221     0.200
    68.193    -0.971     0.200
    68.234     0.167     0.200
    68.242     2.108     0.200
    68.369    -0.031     0.200
    68.273    -0.687     0.200
    68.273    -1.008     0.200
    68.273    -0.476     0.200
    68.415    -0.300     0.200
    68.660    -0.895     0.200
    68.684    -0.760     0.200
    68.788    -0.904     0.200
    68.974    -0.234     0.200
    69.004    -0.338     0.200
    68.906     0.207     0.200
    68.906     1.511     0.200
    69.214    -1.122     0.200
    69.451     0.380     0.200
    69.543    -1.395     0.200
    69.657    -1.254     0.200
    69.798     1.882     0.200
    73.537    -0.604     0.200
    74.718    -2.673     0.200
    75.501    -0.391     0.200
    75.520    -1.398     0.200
    75.715     0.088     0.200
    75.771    -1.936     0.200
    76.109    -2.966     0.200
    76.401     1.862     0.200
    76.441     0.546     0.200
    76.771    -2.472     0.200
    76.825     0.004     0.200
    76.972    -0.545     0.200
    76.972     0.252     0.200
    77.256     2.016     0.200
    77.508    -0.852     0.200
    77.604    -0.946     0.200
    77.677    -1.316     0.200
    77.707     0.024     0.200
    77.811     1.851     0.200
    77.931     1.100     0.200
    77.989     1.269     0.200
    78.244    -2.301     0.200
    79.045    -1.359     0.200
    79.114    -1.636     0.200
    79.137    -1.562     0.200
    79.203    -0.624     0.200
    79.364     1.156     0.200
    79.364     0.711     0.200
    79.341    -1.081     0.200
    79.579     1.644     0.200
    79.720     1.530     0.200
    79.826    -2.015     0.200
    80.463    -0.079     0.200
    80.463    -0.751     0.200
    80.463    -1.782     0.200
    80.549    -0.243     0.200
    80.554    -3.684     0.200
    80.554     0.144     0.200
    80.554    -0.840     0.200
    81.096    -2.438     0.200
    81.295    -0.551     0.200
    81.290     1.630     0.200
    81.879    -1.134     0.200
    82.111    -2.220     0.200
    82.099     1.154     0.200
    82.970    -1.417     0.200
    82.940     2.479     0.200
    82.994     0.494     0.200
    82.954     1.626     0.200
    83.017    -0.216     0.200
    83.511     0.530     0.200
    83.679    -0.658     0.200
    83.679    -1.228     0.200
    83.679    -0.979     0.200
    83.806     0.622     0.200
    83.816     0.405     0.200
    83.830    -1.508     0.200
    83.830     0.062     0.200
    83.927     1.338     0.200
    84.058    -1.267     0.200
    84.058    -0.220     0.200
    84.058    -1.369     0.200
    84.158    -1.708     0.200
    84.520    -0.707     0.200
    84.520    -1.152     0.200
    84.682    -0.930     0.200
    84.993    -0.605     0.200
    85.097    -1.220     0.200
    85.097    -2.119     0.200
    85.263    -1.847     0.200
    85.358    -0.511     0.200
    85.379    -0.129     0.200
    85.415    -0.984     0.200
    85.415    -1.609     0.200
    85.415    -1.906     0.200
    86.650    -0.673     0.200
    86.729    -1.089     0.200
    87.109    -1.554     0.200
    87.137    -0.186     0.200
    88.162    -0.815     0.200
    88.324    -0.865     0.200
    88.609    -0.062     0.200
    88.609    -1.812     0.200
    88.619    -1.577     0.200
    88.623    -1.308     0.200
    88.774    -1.622     0.200
    88.774    -1.927     0.200
    88.774    -2.685     0.200
    90.264    -0.865     0.200
    92.032     0.398     0.200
    92.379    -2.072     0.200
    92.503     3.256     0.200
    92.780    -1.819     0.200
    93.359    -2.590     0.200
    95.580    -0.260     0.200
    95.580    -1.581     0.200
    25.481     1.646     0.200
    25.596     1.479     0.200
    25.595     1.491     0.200
    25.785    -1.035     0.200
    27.766    -1.632     0.200
    31.338    -1.879     0.200
    34.706    -0.351     0.200
    34.706    -0.630     0.200
    40.646     0.648     0.200
    50.909     0.975     0.200
    50.909     0.580     0.200
    51.098    -0.626     0.200
    53.865    -0.302     0.200
    55.058    -0.458     0.200
    55.058    -0.637     0.200
    56.805     0.257     0.200
    60.644    -0.014     0.200
    80.981    -0.974     0.200
    83.404    -1.255     0.200
    83.764    -0.042     0.200
    83.877    -0.621     0.200
    83.877    -1.580     0.200
    85.333    -1.676     0.200
    85.667    -1.378     0.200
    25.769     1.299     0.200
    25.962    -0.299     0.200
    34.704    -0.170     0.200
    51.034     0.328     0.200
    53.938    -0.802     0.200
    55.168    -0.117     0.200
    19.998    -0.093     0.200
    25.830     1.308     0.200
    34.718    -0.535     0.200
    51.052     0.453     0.200
    55.182    -0.038     0.200
    20.029     0.141     0.200
    23.492     2.578     0.200
    34.236     1.292     0.200
    34.767    -0.993     0.200
    34.805    -0.309     0.200
    44.845    -0.873     0.200
    50.988     0.109     0.200
    50.988     0.374     0.200
    50.988    -0.051     0.200
    52.131     0.734     0.200
    53.884    -0.592     0.200
    55.119     0.032     0.200
    56.943    -0.290     0.200
    56.943    -0.290     0.200
    83.736    -1.478     0.200
    20.125     0.141     0.200
    23.463     2.402     0.200
    23.593     0.485     0.200
    23.764     0.656     0.200
    25.802     2.280     0.200
    26.101     2.188     0.200
    28.002    -1.754     0.200
    31.440    -2.109     0.200
    34.259     1.486     0.200
    34.834    -2.196     0.200
    34.834    -0.403     0.200
    50.961     0.186     0.200
    50.961    -0.045     0.200
    50.961     0.177     0.200
    55.087     0.017     0.200
    14.081    10.676     0.200
    20.127     0.226     0.200
    22.393     2.846     0.200
    23.491     2.231     0.200
    23.491     1.340     0.200
    23.623     0.364     0.200
    23.793     0.375     0.200
    24.295     3.121     0.200
    24.329     3.012     0.200
    24.729     3.666     0.200
    25.398     4.482     0.200
    25.622     3.346     0.200
    25.829     2.018     0.200
    25.829     1.420     0.200
    26.131     2.515     0.200
    26.130     2.525     0.200
    26.130     1.498     0.200
    27.478     1.246     0.200
    27.843     0.870     0.200
    28.002    -1.038     0.200
    28.002    -0.816     0.200
    31.432    -2.400     0.200
    31.432    -2.685     0.200
    33.919     0.186     0.200
    34.284     0.071     0.200
    34.692     0.328     0.200
    34.692    -0.297     0.200
    34.826    -0.811     0.200
    34.827    -0.967     0.200
    34.827    -1.338     0.200
    36.430     2.517     0.200
    36.994    -0.166     0.200
    36.994    -0.092     0.200
    38.408     1.249     0.200
    38.518     1.525     0.200
    39.216     1.779     0.200
    39.271     1.165     0.200
    39.785     1.228     0.200
    40.126     1.097     0.200
    40.415     0.397     0.200
    40.545     0.985     0.200
    40.545     0.676     0.200
    40.591     0.240     0.200
    40.760    -0.962     0.200
    40.683     0.388     0.200
    41.198     0.839     0.200
    42.006     0.521     0.200
    42.041     0.531     0.200
    43.882    -0.805     0.200
    44.096    -1.200     0.200
    44.892    -0.889     0.200
    50.703    -0.053     0.200
    50.978    -0.173     0.200
    50.978     0.573     0.200
    50.978    -0.212     0.200
    51.168    -0.310     0.200
    51.403    -1.311     0.200
    51.429    -0.650     0.200
    51.867     2.641     0.200
    52.018     0.051     0.200
    52.170    -0.488     0.200
    53.853    -0.434     0.200
    53.853    -0.613     0.200
    55.102    -0.347     0.200
    55.104     0.147     0.200
    55.867    -0.471     0.200
    56.955     0.643     0.200
    56.955    -0.138     0.200
    56.955    -0.536     0.200
    56.955     0.214     0.200
    60.692    -0.944     0.200
    60.764    -1.930     0.200
    63.734    -0.478     0.200
    68.289    -1.300     0.200
    75.749    -0.197     0.200
    76.849     0.534     0.200
    84.084    -0.278     0.200
    84.084    -0.896     0.200
    84.466    -2.726     0.200
    85.110    -1.595     0.200
    14.123     7.498     0.200
    14.457     4.041     0.200
    19.543    -1.974     0.200
    19.996     0.243     0.200
    20.617     0.770     0.200
    20.792    -1.029     0.200
    21.712     0.409     0.200
    21.894     3.411     0.200
    22.377     1.459     0.200
    22.455     2.730     0.200
    22.510     1.851     0.200
    22.864     4.594     0.200
    23.478     2.013     0.200
    23.478     0.814     0.200
    23.540    -0.122     0.200
    23.715    -0.191     0.200
    23.917     0.844     0.200
    24.194     2.295     0.200
    24.231     2.454     0.200
    24.328     2.864     0.200
    24.426     1.144     0.200
    24.708     3.403     0.200
    25.007     1.379     0.200
    25.249     2.381     0.200
    25.330     2.640     0.200
    25.380     4.690     0.200
    25.559     1.864     0.200
    25.824     1.463     0.200
    25.824     1.061     0.200
    25.917     3.618     0.200
    26.043    -0.045     0.200
    26.042    -0.613     0.200
    26.938    -0.102     0.200
    27.613     0.482     0.200
    27.769     1.140     0.200
    27.876    -0.916     0.200
    27.876    -1.525     0.200
    30.803    -0.142     0.200
    30.822     1.544     0.200
    31.328    -2.509     0.200
    31.332    -0.267     0.200
    31.907     2.489     0.200
    32.754     2.859     0.200
    34.302     0.574     0.200
    34.718    -1.679     0.200
    34.718    -2.043     0.200
    34.829    -1.078     0.200
    34.829     0.532     0.200
    36.508     2.096     0.200
    36.539     1.232     0.200
    38.427     1.833     0.200
    38.535     1.429     0.200
    39.232     1.086     0.200
    39.395    -1.096     0.200
    39.804     1.320     0.200
    40.145     0.884     0.200
    40.433     0.702     0.200
    40.445     0.599     0.200
    40.476    -1.288     0.200
    40.649     1.046     0.200
    40.649    -0.903     0.200
    40.700     0.589     0.200
    42.022     0.731     0.200
    42.059     0.528     0.200
    43.985    -0.826     0.200
    44.792    -1.398     0.200
    44.792    -0.972     0.200
    44.820     1.454     0.200
    44.884     0.335     0.200
    44.884    -0.091     0.200
    46.215     1.403     0.200
    50.844     0.240     0.200
    51.049     0.394     0.200
    51.049    -0.286     0.200
    51.483    -2.414     0.200
    51.913     0.744     0.200
    52.197    -0.392     0.200
    52.607     0.574     0.200
    53.941    -0.471     0.200
    55.178    -0.232     0.200
    55.908    -0.913     0.200
    56.686    -1.194     0.200
    57.007    -0.237     0.200
    57.007    -0.237     0.200
    60.839    -0.793     0.200
    63.846    -1.221     0.200
    65.072     1.301     0.200
    65.072     0.703     0.200
    65.772    -0.550     0.200
    67.252    -0.512     0.200
    68.367    -0.268     0.200
    68.367    -1.409     0.200
    73.632     1.005     0.200
    75.744    -1.201     0.200
    76.895     0.122     0.200
    80.673    -1.212     0.200
    83.788    -0.866     0.200
    84.122     0.876     0.200
    84.122    -0.268     0.200
    85.197    -0.969     0.200
    85.499    -1.564     0.200
    85.499    -1.275     0.200
    87.114     0.188     0.200
    18.986    -0.167     0.200
    19.971     1.177     0.200
    25.843     2.682     0.200
    26.047     1.860     0.200
    26.046     1.870     0.200
    27.850    -2.003     0.200
    31.154    -2.156     0.200
    31.301    -2.293     0.200
    31.301    -1.742     0.200
    31.305     0.454     0.200
    34.692    -1.472     0.200
    34.692     0.458     0.200
    36.535     2.547     0.200
    40.676     1.598     0.200
    43.958    -0.696     0.200
    44.765    -2.370     0.200
    51.075     1.432     0.200
    53.968    -0.026     0.200
    55.205    -0.951     0.200
    57.032     0.434     0.200
    85.525    -1.619     0.200
    23.623     0.204     0.200
    25.453     1.785     0.200
    25.453     0.691     0.200
    25.742     0.623     0.200
    27.716    -1.501     0.200
    27.716    -0.993     0.200
    31.306    -1.954     0.200
    31.306    -0.550     0.200
    34.670    -0.605     0.200
    34.670    -1.117     0.200
    43.924    -0.264     0.200
    44.791    -1.257     0.200
    44.791    -2.027     0.200
    50.921    -0.329     0.200
    50.921     0.600     0.200
    50.921    -0.048     0.200
    53.888    -0.507     0.200
    53.888    -0.776     0.200
    55.073     0.317     0.200
    55.073    -0.379     0.200
    56.806     0.722     0.200
    56.806    -0.507     0.200
    65.608    -0.027     0.200
    14.138     7.074     0.200
    14.419     5.098     0.200
    14.739     4.934     0.200
    14.921     5.401     0.200
    15.104     2.951     0.200
    15.422     2.890     0.200
    15.422     2.347     0.200
    15.619     4.065     0.200
    15.892     2.117     0.200
    16.826     2.094     0.200
    17.310     5.546     0.200
    17.310     3.324     0.200
    18.496    -1.490     0.200
    19.922    -0.048     0.200
    20.640    -0.083     0.200
    20.747     0.896     0.200
    21.259     3.062     0.200
    21.270     1.644     0.200
    21.590     1.698     0.200
    21.629    -1.118     0.200
    21.951     1.928     0.200
    22.340     0.681     0.200
    22.577     1.561     0.200
    22.814     1.853     0.200
    22.952     1.285     0.200
    23.340     1.176     0.200
    23.303     2.493     0.200
    23.442     0.925     0.200
    23.442     0.577     0.200
    23.489     0.904     0.200
    23.647    -0.129     0.200
    23.665     1.197     0.200
    23.724     1.347     0.200
    23.724     1.219     0.200
    23.929    -0.759     0.200
    23.953    -1.295     0.200
    23.953     0.283     0.200
    24.183    -1.670     0.200
    24.114     0.582     0.200
    24.152     1.139     0.200
    24.183     1.954     0.200
    24.414     0.743     0.200
    24.423    -1.544     0.200
    24.583     1.399     0.200
    24.599     2.453     0.200
    24.670     1.512     0.200
    24.814     1.496     0.200
    24.961     1.464     0.200
    25.217     1.434     0.200
    25.310     2.984     0.200
    25.343     4.190     0.200
    25.365     0.692     0.200
    25.512     2.458     0.200
    25.823     1.112     0.200
    25.823    -0.091     0.200
    25.790     1.623     0.200
    25.790     0.631     0.200
    25.790     1.084     0.200
    25.845     1.838     0.200
    25.884     2.280     0.200
    25.888     0.947     0.200
    25.991     0.911     0.200
    25.991     0.610     0.200
    25.991     0.929     0.200
    26.534     2.103     0.200
    26.645     2.901     0.200
    26.953     0.033     0.200
    27.644     0.129     0.200
    27.701    -2.792     0.200
    27.700    -0.374     0.200
    27.700    -0.007     0.200
    27.853    -0.335     0.200
    27.853    -1.647     0.200
    27.853    -0.815     0.200
    27.769    -0.098     0.200
    27.769     0.202     0.200
    28.188     0.862     0.200
    29.461    -2.249     0.200
    29.461    -1.557     0.200
    29.461    -1.647     0.200
    29.461    -1.346     0.200
    29.461    -1.873     0.200
    29.462    -1.661     0.200
    29.918    -1.396     0.200
    29.918    -1.603     0.200
    29.918    -1.896     0.200
    30.336    -0.951     0.200
    30.336    -1.853     0.200
    30.817     0.252     0.200
    30.837     0.379     0.200
    30.828    -1.911     0.200
    31.314    -1.820     0.200
    31.319    -1.366     0.200
    31.319    -2.491     0.200
    31.399    -1.966     0.200
    31.904     2.089     0.200
    32.764     3.441     0.200
    33.892    -0.757     0.200
    33.797     0.727     0.200
    33.803    -0.223     0.200
    34.272    -0.181     0.200
    34.275    -0.223     0.200
    34.706    -1.313     0.200
    34.707    -0.962     0.200
    34.707    -1.692     0.200
    34.862     0.102     0.200
    34.862    -1.202     0.200
    34.958    -0.559     0.200
    34.924     0.165     0.200
    36.505     1.299     0.200
    36.517     2.789     0.200
    36.696    -1.034     0.200
    36.643    -0.383     0.200
    36.931    -2.378     0.200
    36.931    -0.628     0.200
    37.688    -1.280     0.200
    37.689    -1.282     0.200
    38.401     1.432     0.200
    38.508     1.233     0.200
    39.205     1.591     0.200
    39.733     0.081     0.200
    39.777     1.517     0.200
    40.118     1.380     0.200
    40.406     0.703     0.200
    40.418     0.498     0.200
    40.486     1.042     0.200
    40.486    -0.110     0.200
    40.616    -2.533     0.200
    40.583     0.738     0.200
    40.659     0.209     0.200
    40.659    -0.369     0.200
    40.673     0.992     0.200
    41.190     0.332     0.200
    41.995     0.933     0.200
    42.033     0.724     0.200
    42.951     1.572     0.200
    43.075    -2.074     0.200
    43.801    -0.808     0.200
    43.972    -0.637     0.200
    43.879    -0.030     0.200
    44.786    -0.340     0.200
    44.786    -0.715     0.200
    44.781     0.546     0.200
    44.894     0.472     0.200
    44.894     0.949     0.200
    45.338     0.040     0.200
    45.730     0.315     0.200
    46.102     0.347     0.200
    46.208     1.747     0.200
    48.034     0.867     0.200
    48.034     0.765     0.200
    48.444    -0.471     0.200
    49.324    -0.224     0.200
    49.977     1.001     0.200
    50.763     0.656     0.200
    50.887    -0.280     0.200
    50.887    -1.030     0.200
    51.041     0.957     0.200
    51.041     0.707     0.200
    51.041     0.879     0.200
    51.298     0.653     0.200
    51.298    -0.065     0.200
    51.237     0.394     0.200
    51.231     0.934     0.200
    51.469    -0.756     0.200
    51.896     3.263     0.200
    52.058     1.251     0.200
    52.296    -0.417     0.200
    52.296    -0.535     0.200
    52.205    -1.944     0.200
    53.357     1.912     0.200
    53.785     1.864     0.200
    53.921     1.961     0.200
    53.941    -1.031     0.200
    53.941    -0.667     0.200
    54.087     1.275     0.200
    54.087     0.794     0.200
    54.087     0.095     0.200
    54.323     0.789     0.200
    54.452     1.599     0.200
    54.587     1.252     0.200
    54.669     0.501     0.200
    55.174     0.187     0.200
    55.174     0.008     0.200
    55.174     0.437     0.200
    55.776    -0.331     0.200
    55.888     0.808     0.200
    56.992    -0.093     0.200
    57.673    -0.400     0.200
    59.951     0.157     0.200
    60.834     0.179     0.200
    60.834    -0.180     0.200
    60.834     0.070     0.200
    63.357    -0.277     0.200
    63.671    -0.359     0.200
    63.860    -0.881     0.200
    64.206    -0.520     0.200
    64.427    -1.055     0.200
    65.050    -1.369     0.200
    65.050    -0.248     0.200
    65.761    -1.026     0.200
    65.761    -0.334     0.200
    65.761    -1.213     0.200
    65.809    -0.891     0.200
    65.812     0.117     0.200
    65.893    -0.213     0.200
    65.935     0.505     0.200
    65.956     0.481     0.200
    65.959     0.472     0.200
    66.026    -0.051     0.200
    66.026     0.672     0.200
    66.310     0.388     0.200
    66.386    -0.553     0.200
    66.690     0.580     0.200
    66.690     0.260     0.200
    67.373    -0.524     0.200
    68.362    -1.055     0.200
    68.906     0.206     0.200
    68.881     0.100     0.200
    75.710     0.209     0.200
    75.710     0.018     0.200
    75.870    -2.299     0.200
    76.159    -1.449     0.200
    76.878    -0.438     0.200
    77.026     1.752     0.200
    77.580    -0.658     0.200
    77.839    -0.244     0.200
    78.149    -0.625     0.200
    78.783    -1.923     0.200
    78.958    -0.413     0.200
    79.077    -0.778     0.200
    79.117    -0.753     0.200
    79.290    -0.590     0.200
    79.279    -1.345     0.200
    79.445     0.153     0.200
    79.526    -0.234     0.200
    79.847    -2.131     0.200
    79.869    -1.950     0.200
    80.218    -0.869     0.200
    80.299     1.027     0.200
    80.546     0.898     0.200
    80.716    -2.116     0.200
    80.716    -2.514     0.200
    81.457     0.080     0.200
    81.686    -1.026     0.200
    82.041    -1.144     0.200
    82.272    -1.078     0.200
    83.795    -0.907     0.200
    84.101    -1.297     0.200
    85.196    -1.423     0.200
    85.196    -1.599     0.200
    85.425    -1.041     0.200
    85.425    -1.166     0.200
    85.471     2.005     0.200
    85.489    -1.383     0.200
    85.637     0.577     0.200
    87.067     1.702     0.200
    87.067     1.378     0.200
    87.067     0.815     0.200
    88.613    -2.136     0.200
    88.613    -2.800     0.200
    88.613    -3.769     0.200
    88.686    -0.195     0.200
    90.335     1.393     0.200
    92.136    -2.912     0.200
    94.969    -1.506     0.200
    95.656    -1.388     0.200
    20.133     0.314     0.200
    23.581    -0.803     0.200
    23.751     0.111     0.200
    23.883    -1.052     0.200
    25.786     2.333     0.200
    27.476     1.047     0.200
    28.011    -1.927     0.200
    31.453    -2.437     0.200
    34.243     0.623     0.200
    34.692     0.801     0.200
    34.692     1.317     0.200
    34.692     0.942     0.200
    34.846    -1.206     0.200
    34.846    -1.558     0.200
    39.260     1.006     0.200
    40.524     1.608     0.200
    44.914    -0.923     0.200
    50.946     0.618     0.200
    50.946     0.314     0.200
    50.946    -0.132     0.200
    55.072    -0.832     0.200
    56.919    -0.406     0.200
    65.677    -0.863     0.200
    85.083    -1.773     0.200
    23.316     0.513     0.200
    23.328     0.343     0.200
    23.494     0.260     0.200
    25.684     2.402     0.200
    27.764     0.426     0.200
    31.267     1.304     0.200
    31.273    -0.046     0.200
    31.277     0.094     0.200
    31.354    -0.539     0.200
    34.652    -0.056     0.200
    34.652    -2.556     0.200
    34.990    -1.283     0.200
    34.990    -1.879     0.200
    40.707     0.014     0.200
    43.913    -0.528     0.200
    51.047    -0.691     0.200
    51.033     0.088     0.200
    51.033     0.527     0.200
    51.033    -0.053     0.200
    53.960    -0.427     0.200
    55.173    -0.656     0.200
    55.174     0.171     0.200
    56.955     0.107     0.200
    65.739    -0.280     0.200
    15.406     2.813     0.200
    17.318     1.892     0.200
    19.546     0.347     0.200
    23.349     0.459     0.200
    23.523     0.698     0.200
    25.255    -0.905     0.200
    25.643     0.612     0.200
    34.772    -0.755     0.200
    34.773    -0.595     0.200
    34.862     2.575     0.200
    40.588     1.330     0.200
    42.280     0.150     0.200
    43.079    -1.322     0.200
    50.933    -0.872     0.200
    50.933     0.745     0.200
    50.933    -0.962     0.200
    53.850     0.036     0.200
    53.850    -0.288     0.200
    55.071     0.134     0.200
    56.869    -0.106     0.200
    14.140     8.662     0.200
    15.111     3.360     0.200
    17.322     1.532     0.200
    21.636     1.442     0.200
    21.844     2.816     0.200
    22.320     0.730     0.200
    22.458     2.965     0.200
    22.579     2.379     0.200
    23.423     1.074     0.200
    23.423     0.314     0.200
    23.465     0.037     0.200
    23.647    -2.475     0.200
    23.641    -0.726     0.200
    24.130     1.215     0.200
    24.278     1.366     0.200
    24.416     0.084     0.200
    24.650     1.975     0.200
    24.773     2.251     0.200
    24.938     1.755     0.200
    25.199     1.779     0.200
    25.297     2.788     0.200
    25.323     4.254     0.200
    25.344     0.660     0.200
    25.488     2.851     0.200
    25.820     0.174     0.200
    25.771     1.334     0.200
    25.866     3.331     0.200
    25.870     0.595     0.200
    27.653    -0.473     0.200
    27.653     0.626     0.200
    27.765     0.426     0.200
    27.848    -0.913     0.200
    28.179     0.430     0.200
    29.476    -1.099     0.200
    30.839    -0.151     0.200
    31.315    -1.841     0.200
    31.320    -1.875     0.200
    31.324    -1.682     0.200
    31.897     2.032     0.200
    32.764     3.633     0.200
    34.259     1.309     0.200
    34.707    -2.467     0.200
    34.707    -0.717     0.200
    34.873     0.199     0.200
    34.873     0.574     0.200
    36.139    -1.980     0.200
    36.498     1.250     0.200
    38.385     1.360     0.200
    38.492     1.064     0.200
    39.188     1.024     0.200
    39.743    -0.302     0.200
    39.761     1.448     0.200
    40.103     1.213     0.200
    40.215    -1.424     0.200
    40.390     0.733     0.200
    40.402     0.531     0.200
    40.485     0.543     0.200
    40.567     0.668     0.200
    40.657     0.624     0.200
    40.658     1.014     0.200
    40.658     0.629     0.200
    41.174     0.366     0.200
    41.979     0.969     0.200
    42.017     0.756     0.200
    43.809    -0.769     0.200
    44.788    -0.199     0.200
    44.893    -2.642     0.200
    46.200     2.019     0.200
    49.971     0.658     0.200
    51.033     0.733     0.200
    51.033     0.437     0.200
    51.033     0.333     0.200
    51.223     0.707     0.200
    51.884     3.168     0.200
    52.310     0.335     0.200
    52.581    -0.110     0.200
    53.937    -0.564     0.200
    53.937    -0.669     0.200
    54.076     0.492     0.200
    55.167     0.280     0.200
    55.875    -0.048     0.200
    56.653     0.971     0.200
    56.981     0.309     0.200
    56.981     0.309     0.200
    56.981     0.079     0.200
    60.827     0.297     0.200
    61.785    -1.387     0.200
    63.861    -0.608     0.200
    64.440    -2.610     0.200
    65.036     0.456     0.200
    65.036     0.245     0.200
    65.752    -0.660     0.200
    65.752    -0.210     0.200
    68.356    -0.776     0.200
    68.356    -1.215     0.200
    75.691     0.169     0.200
    76.147    -1.232     0.200
    77.013    -1.234     0.200
    77.571    -1.558     0.200
    78.778    -1.448     0.200
    78.778    -1.347     0.200
    79.270    -1.648     0.200
    80.538    -1.512     0.200
    80.733    -1.752     0.200
    81.473    -1.700     0.200
    83.794    -0.226     0.200
    84.088     0.191     0.200
    85.191    -0.639     0.200
    85.479    -0.084     0.200
    85.479    -1.267     0.200
    85.537     1.770     0.200
    87.044     1.911     0.200
    87.044     1.584     0.200
    92.132     0.071     0.200
    92.565    -0.488     0.200
    14.098     9.734     0.200
    15.862     5.451     0.200
    17.296     4.896     0.200
    19.997     0.807     0.200
    19.997     1.362     0.200
    20.744     0.452     0.200
    21.614     2.918     0.200
    21.938     0.198     0.200
    22.202     1.480     0.200
    22.275     3.607     0.200
    22.237     3.382     0.200
    22.419     1.786     0.200
    22.795     1.577     0.200
    23.318     1.491     0.200
    23.377     1.748     0.200
    23.377    -0.245     0.200
    23.437     1.414     0.200
    23.437    -0.109     0.200
    23.611     0.705     0.200
    23.611     0.111     0.200
    23.692    -0.291     0.200
    23.704    -1.075     0.200
    24.125     2.005     0.200
    24.230     1.944     0.200
    24.367     0.844     0.200
    24.605     2.728     0.200
    24.730     3.286     0.200
    24.769     0.389     0.200
    25.151     2.360     0.200
    25.453     2.309     0.200
    25.724    -0.009     0.200
    25.724     0.905     0.200
    25.724     0.171     0.200
    25.818     4.805     0.200
    25.822     0.784     0.200
    25.802    -0.452     0.200
    25.861     0.818     0.200
    25.940     0.404     0.200
    27.622     0.404     0.200
    27.716    -0.651     0.200
    27.885     0.068     0.200
    27.885    -1.354     0.200
    28.129     1.317     0.200
    30.777    -0.522     0.200
    31.365    -1.947     0.200
    31.365    -2.853     0.200
    31.369    -2.521     0.200
    31.848     2.001     0.200
    32.719     3.259     0.200
    33.776     1.527     0.200
    34.209    -0.185     0.200
    34.750    -1.632     0.200
    34.751    -1.022     0.200
    34.751    -1.374     0.200
    34.844     0.087     0.200
    34.844     0.556     0.200
    34.903     0.448     0.200
    36.448     1.499     0.200
    36.452     2.137     0.200
    38.335     1.299     0.200
    38.442     1.104     0.200
    39.139     1.463     0.200
    39.383    -0.752     0.200
    39.713    -0.008     0.200
    39.711     1.382     0.200
    40.053     1.247     0.200
    40.340     0.561     0.200
    40.352     0.560     0.200
    40.517     0.798     0.200
    40.613     0.530     0.200
    40.613     0.249     0.200
    40.607     0.755     0.200
    40.596    -1.207     0.200
    41.124     0.393     0.200
    41.929     0.987     0.200
    41.967     0.582     0.200
    44.015    -0.957     0.200
    44.834    -0.507     0.200
    44.834    -2.280     0.200
    50.887     0.156     0.200
    50.983     0.541     0.200
    50.983     0.759     0.200
    50.983    -0.045     0.200
    51.173     0.357     0.200
    51.407    -0.756     0.200
    51.833     3.349     0.200
    51.997     0.408     0.200
    52.108     0.344     0.200
    52.180    -1.069     0.200
    52.530     0.347     0.200
    53.295     3.116     0.200
    53.386     1.523     0.200
    53.859     2.389     0.200
    53.889    -0.823     0.200
    53.889    -1.018     0.200
    53.889    -0.838     0.200
    54.025     1.982     0.200
    54.390     1.662     0.200
    54.525     1.324     0.200
    54.606     1.113     0.200
    55.117    -0.008     0.200
    55.760     0.232     0.200
    55.825    -0.273     0.200
    56.603     0.101     0.200
    56.930     0.114     0.200
    56.930     0.114     0.200
    56.930    -0.542     0.200
    60.777    -0.469     0.200
    61.213     0.179     0.200
    61.751    -1.462     0.200
    61.751    -1.610     0.200
    63.818    -0.740     0.200
    64.985     0.633     0.200
    64.985     0.023     0.200
    65.701    -1.013     0.200
    65.701    -0.755     0.200
    68.306    -1.384     0.200
    75.499     1.060     0.200
    75.644    -0.499     0.200
    76.814     0.301     0.200
    76.962    -0.002     0.200
    77.838    -0.749     0.200
    79.870    -1.006     0.200
    80.716    -1.125     0.200
    83.133    -2.129     0.200
    83.748    -0.821     0.200
    83.748    -1.126     0.200
    84.037    -0.190     0.200
    84.037    -0.800     0.200
    84.958    -0.820     0.200
    85.143    -1.817     0.200
    85.420    -1.093     0.200
    85.429    -1.348     0.200
    87.008     1.060     0.200
    92.083    -1.259     0.200
    95.596     1.197     0.200
    95.596    -0.092     0.200
    25.851    -0.083     0.200
    31.432    -1.830     0.200
    34.828    -0.698     0.200
    50.987     0.512     0.200
    34.734    -1.502     0.200
    50.998     0.414     0.200
    20.125     0.075     0.200
    23.770    -1.450     0.200
    25.809     0.373     0.200
    25.959     2.154     0.200
    31.433    -0.533     0.200
    31.438    -1.798     0.200
    31.442    -0.364     0.200
    34.831    -0.874     0.200
    34.832    -1.042     0.200
    34.832    -0.729     0.200
    40.539     2.512     0.200
    44.101    -1.453     0.200
    44.899    -0.449     0.200
    44.899     0.051     0.200
    50.966     0.579     0.200
    50.966     0.594     0.200
    50.966     0.438     0.200
    53.843    -1.365     0.200
    55.091     0.154     0.200
    55.092     0.184     0.200
    56.940     0.269     0.200
    65.697    -0.751     0.200
    68.967     1.171     0.200
    14.128     7.734     0.200
    16.325     2.877     0.200
    23.361     1.567     0.200
    23.599     0.033     0.200
    23.596     0.190     0.200
    25.690     0.161     0.200
    25.690    -0.655     0.200
    27.286     1.424     0.200
    31.646    -2.168     0.200
    31.646    -2.715     0.200
    35.041    -1.035     0.200
    35.041    -2.578     0.200
    39.855    -0.119     0.200
    40.157     1.076     0.200
    40.331     0.867     0.200
    40.331     0.758     0.200
    50.774     0.496     0.200
    51.848    -1.901     0.200
    51.997    -0.095     0.200
    53.641     0.159     0.200
    54.895    -0.288     0.200
    55.600    -0.202     0.200
    56.762    -0.738     0.200
    57.535    -2.433     0.200
    19.963     0.434     0.200
    23.597    -0.361     0.200
    23.643     0.643     0.200
    25.942     2.153     0.200
    25.942    -0.214     0.200
    25.942     1.333     0.200
    26.039     0.452     0.200
    31.257    -2.519     0.200
    34.652    -1.394     0.200
    34.653    -2.105     0.200
    34.653    -2.511     0.200
    36.650     1.034     0.200
    36.828    -1.174     0.200
    38.650     1.615     0.200
    39.347     1.775     0.200
    39.919     1.913     0.200
    40.548     1.093     0.200
    40.560     0.990     0.200
    40.719    -0.614     0.200
    40.725     1.031     0.200
    42.137     1.429     0.200
    42.174     1.230     0.200
    44.718    -1.657     0.200
    51.144     0.042     0.200
    52.310     0.026     0.200
    54.025    -2.119     0.200
    55.271    -1.641     0.200
    57.112     0.961     0.200
    84.232    -2.085     0.200
    85.282    -2.436     0.200
    85.598    -2.045     0.200
    14.461     4.756     0.200
    24.677    -0.226     0.200
    31.280    -0.425     0.200
    31.362    -3.321     0.200
    34.662    -1.633     0.200
    34.961     2.407     0.200
    51.038     0.242     0.200
    51.038     1.361     0.200
    55.177    -0.340     0.200
    56.968    -0.232     0.200
    68.922    -1.465     0.200
    22.190     2.599     0.200
    23.274     2.766     0.200
    23.414     0.375     0.200
    23.590     0.555     0.200
    23.991    -0.693     0.200
    24.402    -0.332     0.200
    25.160     4.757     0.200
    25.731    -0.657     0.200
    25.731     3.222     0.200
    25.731    -0.497     0.200
    25.815     0.164     0.200
    25.915     0.203     0.200
    27.624     0.451     0.200
    27.672     0.570     0.200
    27.754    -0.627     0.200
    27.837     0.571     0.200
    31.318    -0.465     0.200
    31.323    -1.713     0.200
    31.323    -1.401     0.200
    31.517    -0.038     0.200
    34.224    -0.393     0.200
    34.706    -0.525     0.200
    34.707    -0.860     0.200
    34.707    -0.392     0.200
    34.895     0.445     0.200
    34.895    -0.360     0.200
    39.431    -0.519     0.200
    40.068     1.106     0.200
    40.354     1.332     0.200
    40.622     1.223     0.200
    40.655     0.341     0.200
    40.655    -0.487     0.200
    43.971    -0.093     0.200
    44.793    -0.566     0.200
    44.793     0.169     0.200
    48.056     0.384     0.200
    49.354    -1.920     0.200
    51.015     0.441     0.200
    51.015     0.464     0.200
    51.015     0.241     0.200
    51.205     0.348     0.200
    52.023     0.281     0.200
    52.126    -0.082     0.200
    52.230    -0.650     0.200
    52.341     0.448     0.200
    53.926    -1.033     0.200
    53.926    -0.572     0.200
    55.151    -0.327     0.200
    55.729    -0.720     0.200
    60.811    -0.828     0.200
    63.863    -0.790     0.200
    65.004    -0.544     0.200
    65.112    -0.746     0.200
    65.730    -0.591     0.200
    68.340    -0.874     0.200
    68.938     0.073     0.200
    75.650    -0.127     0.200
    77.888    -0.761     0.200
    79.009    -1.140     0.200
    79.900    -0.977     0.200
    80.766    -1.820     0.200
    80.766    -0.890     0.200
    81.505    -0.294     0.200
    83.789    -0.264     0.200
    83.789    -0.506     0.200
    85.180    -1.361     0.200
    85.180    -1.224     0.200
    85.470    -1.149     0.200
    95.017    -0.909     0.200
    95.017    -0.628     0.200
    19.356    -1.830     0.200
    27.708    -0.305     0.200
    27.708    -1.220     0.200
    31.328    -3.719     0.200
    34.656     0.660     0.200
    40.809    -1.495     0.200
    48.107    -0.713     0.200
    50.945    -0.605     0.200
    50.945     0.344     0.200
    53.908    -0.784     0.200
    53.908    -0.936     0.200
    55.096    -0.446     0.200
    81.043    -0.832     0.200
    81.043    -1.682     0.200
    85.729    -0.787     0.200
    95.284    -0.631     0.200
    25.460    -0.412     0.200
    27.757    -1.507     0.200
    31.337     0.157     0.200
    34.704    -0.907     0.200
    50.902     0.357     0.200
    53.862    -1.383     0.200
    83.863    -0.073     0.200
    85.687    -1.179     0.200
    89.770    -3.356     0.200
    95.243    -0.346     0.200
    15.144     4.073     0.200
    23.749     2.738     0.200
    24.296     4.742     0.200
    24.295     5.546     0.200
    24.406     3.437     0.200
    24.975     4.255     0.200
    25.449     0.170     0.200
    26.297     2.856     0.200
    27.715    -0.777     0.200
    31.306    -1.306     0.200
    34.670    -1.590     0.200
    37.057     0.741     0.200
    39.959    -0.176     0.200
    40.681     0.778     0.200
    44.792    -0.529     0.200
    50.919    -0.117     0.200
    64.802     0.599     0.200
    81.056    -1.333     0.200
    83.867    -0.509     0.200
    85.339    -1.484     0.200
    89.730    -0.937     0.200
    95.295    -1.278     0.200
    25.550    -2.342     0.200
    26.131    -0.887     0.200
    27.498    -2.389     0.200
    34.867    -0.003     0.200
    39.708     0.404     0.200
    40.506    -0.575     0.200
    43.046    -1.272     0.200
    44.931     1.204     0.200
    44.931     0.060     0.200
    50.942     0.778     0.200
    50.942     0.428     0.200
    23.383     1.479     0.200
    25.733     0.772     0.200
    25.733     3.161     0.200
    27.659    -0.346     0.200
    31.333    -2.718     0.200
    34.223     1.039     0.200
    34.718    -1.162     0.200
    34.718     0.438     0.200
    34.881     0.059     0.200
    51.009     0.472     0.200
    51.009    -0.169     0.200
    51.009     0.113     0.200
    51.199     0.458     0.200
    53.918    -0.928     0.200
    55.144    -0.168     0.200
    56.951     0.131     0.200
    65.725    -0.707     0.200
    95.002    -0.549     0.200
    31.465    -1.445     0.200
    34.863    -1.003     0.200
    44.922    -0.341     0.200
    50.965     0.129     0.200
    23.556     0.798     0.200
    25.901     1.153     0.200
    27.604     1.025     0.200
    31.296     0.606     0.200
    31.301    -2.448     0.200
    34.372     1.719     0.200
    34.696    -0.464     0.200
    37.617     0.533     0.200
    37.617     0.534     0.200
    38.497     1.180     0.200
    38.606     0.873     0.200
    39.303     1.126     0.200
    39.874     1.368     0.200
    40.215     1.138     0.200
    40.503     0.352     0.200
    40.629    -0.360     0.200
    40.516     0.647     0.200
    40.680     0.790     0.200
    40.676     1.444     0.200
    40.771     0.743     0.200
    42.093     0.585     0.200
    43.964    -1.551     0.200
    44.762    -0.577     0.200
    51.097     0.968     0.200
    52.265     1.737     0.200
    55.224     1.110     0.200
    55.225     1.102     0.200
    60.814     0.516     0.200
    60.885     0.715     0.200
    68.411    -0.355     0.200
    68.840    -1.175     0.200
    27.773    -0.205     0.200
    31.215    -1.719     0.200
    31.224    -1.290     0.200
    34.384     1.653     0.200
    34.611    -0.478     0.200
    34.923    -1.494     0.200
    40.757     0.104     0.200
    44.992    -2.078     0.200
    51.151     0.582     0.200
    51.151     0.027     0.200
    54.047    -0.358     0.200
    55.282    -0.708     0.200
    57.103     0.180     0.200
    57.103     0.180     0.200
    60.943     0.495     0.200
    80.750    -1.541     0.200
    95.007    -1.615     0.200
    23.567    -0.212     0.200
    23.848     0.993     0.200
    25.906     1.642     0.200
    26.002     1.997     0.200
    27.518     0.334     0.200
    34.764    -0.876     0.200
    34.765    -1.532     0.200
    51.054     0.219     0.200
    51.054     0.356     0.200
    51.244     0.029     0.200
    52.249     0.880     0.200
    53.924    -0.176     0.200
    55.177    -0.693     0.200
    60.767    -0.761     0.200
    60.839    -0.465     0.200
    84.164     0.804     0.200
    85.512    -0.897     0.200
    94.804    -1.691     0.200
    14.547     7.664     0.200
    21.604     3.305     0.200
    22.590    -0.427     0.200
    23.435    -0.040     0.200
    23.611     0.379     0.200
    24.758     1.616     0.200
    25.752     2.893     0.200
    25.752     1.424     0.200
    25.752     1.063     0.200
    25.808     1.947     0.200
    25.851     2.041     0.200
    25.936     0.108     0.200
    25.935     0.393     0.200
    25.935     0.114     0.200
    27.673    -0.845     0.200
    27.767    -0.033     0.200
    27.832    -0.211     0.200
    27.832     0.728     0.200
    29.503     1.830     0.200
    29.503     0.800     0.200
    31.312    -2.115     0.200
    31.312     0.045     0.200
    31.897     1.690     0.200
    34.244     0.640     0.200
    34.698    -0.788     0.200
    34.698    -1.067     0.200
    34.895    -0.017     0.200
    34.894     0.663     0.200
    34.894    -0.307     0.200
    34.954     0.550     0.200
    38.477     1.137     0.200
    39.173     1.196     0.200
    39.764    -0.158     0.200
    40.088     1.177     0.200
    40.375     0.500     0.200
    40.642     0.590     0.200
    41.963     0.833     0.200
    42.002     0.516     0.200
    46.197     1.372     0.200
    51.031     0.586     0.200
    51.031     0.851     0.200
    51.031     0.445     0.200
    51.875     4.156     0.200
    52.041     0.219     0.200
    52.146     0.581     0.200
    53.939    -0.958     0.200
    53.939    -1.237     0.200
    53.939    -0.817     0.200
    54.069     1.543     0.200
    54.069     1.352     0.200
    55.166    -0.306     0.200
    55.749    -0.483     0.200
    55.866    -0.350     0.200
    56.643     0.049     0.200
    56.973     0.045     0.200
    56.973     0.185     0.200
    56.973     0.045     0.200
    60.826    -0.435     0.200
    63.871    -0.922     0.200
    65.024     1.284     0.200
    65.024     0.444     0.200
    65.747    -1.096     0.200
    68.355    -1.693     0.200
    75.671    -0.261     0.200
    80.760    -0.656     0.200
    80.760    -0.287     0.200
    83.800    -0.992     0.200
    83.800     0.094     0.200
    85.193    -1.045     0.200
    85.193    -1.238     0.200
    85.466    -1.398     0.200
    85.475     0.422     0.200
    85.475    -0.225     0.200
    85.566     0.624     0.200
    87.016     2.023     0.200
    87.016     0.773     0.200
    89.819    -2.720     0.200
    92.135    -1.544     0.200
    95.012    -0.916     0.200
    25.925     1.445     0.200
    34.711    -0.658     0.200
    51.098     0.297     0.200
    20.866     0.085     0.200
    23.613    -0.702     0.200
    23.690     0.233     0.200
    23.866    -0.717     0.200
    24.507     0.130     0.200
    25.966     0.771     0.200
    26.190    -2.089     0.200
    27.868    -0.656     0.200
    31.279    -0.544     0.200
    31.283    -1.219     0.200
    34.677    -0.724     0.200
    50.779     0.449     0.200
    51.139     0.650     0.200
    55.263     1.438     0.200
    68.793     0.807     0.200
    14.090     7.736     0.200
    17.254     3.980     0.200
    20.023     0.471     0.200
    23.692    -0.518     0.200
    25.789     1.961     0.200
    25.871    -0.181     0.200
    26.024     0.482     0.200
    26.024     0.488     0.200
    27.589     0.879     0.200
    27.905    -0.743     0.200
    27.905    -1.602     0.200
    31.362    -1.460     0.200
    31.366     0.392     0.200
    34.751     0.068     0.200
    34.752    -1.338     0.200
    36.471     2.051     0.200
    40.441     0.614     0.200
    43.131    -1.171     0.200
    44.018     0.452     0.200
    44.828    -0.145     0.200
    44.850    -1.256     0.200
    51.011    -0.631     0.200
    52.160    -0.373     0.200
    55.141    -0.226     0.200
    55.142    -0.300     0.200
    60.802    -0.856     0.200
    61.266    -0.620     0.200
    68.329    -0.467     0.200
    83.753    -1.988     0.200
    25.763     1.609     0.200
    27.599    -0.156     0.200
    27.899    -0.640     0.200
    31.366    -1.424     0.200
    34.754    -0.412     0.200
    40.612     1.668     0.200
    44.832    -0.089     0.200
    50.998     0.416     0.200
    53.896    -0.312     0.200
    25.770     1.487     0.200
    27.647    -0.253     0.200
    31.326    -2.163     0.200
    34.713    -0.735     0.200
    51.029     0.394     0.200
    53.931    -0.869     0.200
    20.091    -0.016     0.200
    25.796    -1.270     0.200
    31.415     0.033     0.200
    34.807    -0.202     0.200
    40.562     1.513     0.200
    50.977     0.158     0.200
    53.860    -0.784     0.200
    83.702    -1.668     0.200
    85.117    -1.292     0.200
    27.626    -0.067     0.200
    31.339    -1.372     0.200
    34.727    -0.826     0.200
    40.639     0.818     0.200
    43.992    -1.659     0.200
    51.022     0.338     0.200
    51.022     0.562     0.200
    51.022     0.418     0.200
    53.922    -0.259     0.200
    53.922    -0.640     0.200
    55.154    -0.433     0.200
    56.974    -0.417     0.200
    83.775    -0.580     0.200
    94.955    -0.933     0.200
    20.040     0.174     0.200
    23.731     0.955     0.200
    25.712     0.756     0.200
    27.580    -0.738     0.200
    27.927    -0.469     0.200
    31.484     2.875     0.200
    34.802    -0.649     0.200
    34.790    -1.274     0.200
    39.559     0.894     0.200
    40.574    -0.984     0.200
    44.055    -0.188     0.200
    50.951     0.562     0.200
    50.951    -0.502     0.200
    55.084     0.002     0.200
    55.085    -0.346     0.200
    63.778    -1.465     0.200
    68.273     0.047     0.200
    14.106     5.392     0.200
    14.421     5.703     0.200
    17.305     3.147     0.200
    19.533    -1.376     0.200
    20.741     0.375     0.200
    21.246     2.210     0.200
    21.485     2.042     0.200
    22.431     4.033     0.200
    22.554     1.521     0.200
    23.399    -0.766     0.200
    23.452    -0.366     0.200
    23.674    -1.363     0.200
    23.627    -0.384     0.200
    23.948     0.188     0.200
    23.948     0.406     0.200
    24.200    -0.614     0.200
    24.200    -1.786     0.200
    24.154    -0.588     0.200
    24.412     1.917     0.200
    24.388     0.288     0.200
    24.951     0.905     0.200
    25.256     1.439     0.200
    25.339    -0.770     0.200
    25.270     0.611     0.200
    25.845    -2.324     0.200
    25.747     0.139     0.200
    25.747     0.881     0.200
    25.747     0.772     0.200
    25.845    -0.468     0.200
    25.956     1.381     0.200
    25.956     0.586     0.200
    25.955    -0.253     0.200
    26.075     4.407     0.200
    26.834    -0.144     0.200
    27.290    -4.764     0.200
    27.665    -1.140     0.200
    27.633    -0.436     0.200
    27.633     1.072     0.200
    27.691    -0.736     0.200
    27.870     0.649     0.200
    27.870    -0.773     0.200
    27.737    -0.772     0.200
    27.955    -0.298     0.200
    28.151     0.652     0.200
    29.463    -0.356     0.200
    29.465    -2.174     0.200
    30.795    -0.238     0.200
    30.814     1.143     0.200
    31.346    -1.436     0.200
    32.737    -0.764     0.200
    34.232     1.265     0.200
    34.732    -1.618     0.200
    34.732    -0.618     0.200
    34.732    -0.868     0.200
    34.854    -0.193     0.200
    34.854     0.901     0.200
    34.854     0.409     0.200
    34.914     0.221     0.200
    36.470     1.655     0.200
    36.476     0.030     0.200
    36.967    -3.872     0.200
    39.724     0.575     0.200
    40.459    -1.023     0.200
    40.632     0.644     0.200
    40.632    -1.020     0.200
    44.814    -0.122     0.200
    44.814    -1.770     0.200
    44.738     0.564     0.200
    46.172     2.004     0.200
    49.326    -3.665     0.200
    50.891     0.682     0.200
    50.891    -2.591     0.200
    51.005     0.143     0.200
    51.005     1.034     0.200
    51.005     0.159     0.200
    51.430     1.288     0.200
    51.856     1.642     0.200
    52.020     0.484     0.200
    52.131     0.089     0.200
    53.909    -1.343     0.200
    53.909    -0.335     0.200
    54.048    -0.335     0.200
    54.629    -0.414     0.200
    55.139    -0.274     0.200
    55.140     0.618     0.200
    55.735    -0.602     0.200
    55.783     0.342     0.200
    55.848     1.078     0.200
    56.626    -0.976     0.200
    56.953     0.275     0.200
    56.953    -0.139     0.200
    60.727     0.403     0.200
    60.799    -1.148     0.200
    60.984    -0.871     0.200
    61.237    -1.126     0.200
    63.836    -0.735     0.200
    65.008     0.643     0.200
    65.008     0.479     0.200
    65.008    -0.326     0.200
    65.724    -0.887     0.200
    65.850    -0.030     0.200
    67.204    -0.492     0.200
    68.328    -0.518     0.200
    68.328    -1.495     0.200
    68.413    -3.410     0.200
    68.620    -4.028     0.200
    69.298    -4.174     0.200
    76.447    -0.095     0.200
    76.837    -0.178     0.200
    76.986    -0.660     0.200
    78.750    -1.932     0.200
    78.963    -0.349     0.200
    79.292    -0.653     0.200
    79.874    -1.426     0.200
    80.721    -1.257     0.200
    80.721    -2.507     0.200
    81.479    -1.910     0.200
    83.137    -1.935     0.200
    83.767     0.270     0.200
    83.767    -0.949     0.200
    83.767    -1.434     0.200
    84.060     0.194     0.200
    84.060    -1.017     0.200
    84.981    -1.457     0.200
    85.164    -1.778     0.200
    85.426    -1.438     0.200
    85.451    -0.862     0.200
    85.451    -1.964     0.200
    85.527    -1.565     0.200
    87.027     2.874     0.200
    88.371    -1.533     0.200
    88.647    -0.905     0.200
    88.652    -0.948     0.200
    92.104    -2.604     0.200
    92.104    -2.222     0.200
    94.972     0.183     0.200
    95.619    -0.131     0.200
    95.619    -0.780     0.200
    15.148     3.028     0.200
    19.974    -0.271     0.200
    22.557     1.604     0.200
    23.674    -1.920     0.200
    25.252     1.670     0.200
    25.723     2.152     0.200
    27.634     0.924     0.200
    27.863     0.972     0.200
    27.646     0.515     0.200
    28.328    -0.181     0.200
    31.342    -4.498     0.200
    31.347    -2.344     0.200
    31.346    -4.353     0.200
    31.428    -3.029     0.200
    31.861     3.420     0.200
    32.737     2.137     0.200
    34.731    -1.377     0.200
    34.732    -1.014     0.200
    34.732    -1.604     0.200
    34.868     0.309     0.200
    37.710    -1.093     0.200
    39.737    -0.232     0.200
    43.996    -1.290     0.200
    44.817    -0.790     0.200
    44.817    -1.434     0.200
    46.161     2.386     0.200
    50.995     0.741     0.200
    50.995     0.608     0.200
    51.185     0.578     0.200
    52.112     0.429     0.200
    53.904    -0.519     0.200
    55.130    -0.135     0.200
    55.131     0.090     0.200
    56.938    -0.244     0.200
    63.837    -0.874     0.200
    65.710    -1.234     0.200
    65.711    -0.825     0.200
    68.319    -1.326     0.200
    76.468    -0.934     0.200
    25.760     3.722     0.200
    31.356    -0.023     0.200
    51.004    -0.483     0.200
    24.839     0.378     0.200
    25.325     4.359     0.200
    25.398     2.476     0.200
    25.499     3.285     0.200
    31.358    -2.700     0.200
    34.721    -1.634     0.200
    40.630     1.309     0.200
    50.863     0.893     0.200
    53.833    -0.166     0.200
    55.016     0.253     0.200
    81.035    -1.933     0.200
    14.146     6.028     0.200
    14.418     4.250     0.200
    15.175     3.357     0.200
    19.472    -1.216     0.200
    25.621     1.499     0.200
    25.782     0.758     0.200
    27.716    -0.973     0.200
    31.338    -2.434     0.200
    34.716    -0.725     0.200
    34.946     0.481     0.200
    34.946     0.360     0.200
    40.642    -1.526     0.200
    50.962     0.559     0.200
    50.962     0.039     0.200
    50.962     0.969     0.200
    51.151     0.626     0.200
    53.891    -0.728     0.200
    55.103     0.585     0.200
    69.003    -1.111     0.200
    69.227    -1.943     0.200
    77.968    -0.384     0.200
    83.615    -1.732     0.200
    83.624    -0.666     0.200
    83.975    -0.775     0.200
    85.397    -1.022     0.200
    85.545    -1.815     0.200
    85.545    -0.616     0.200
    95.095    -1.235     0.200
    25.508     0.957     0.200
    25.508     1.157     0.200
    27.313    -0.167     0.200
    27.737    -1.698     0.200
    31.306    -1.717     0.200
    34.674    -0.253     0.200
    34.675    -0.132     0.200
    34.675     0.231     0.200
    35.063     0.797     0.200
    39.922    -0.213     0.200
    40.678    -0.113     0.200
    40.678     0.126     0.200
    49.862    -0.329     0.200
    50.576     0.659     0.200
    50.941     0.627     0.200
    50.941     0.647     0.200
    51.130     0.457     0.200
    51.493     0.451     0.200
    51.495     0.300     0.200
    51.957     0.911     0.200
    52.379     0.313     0.200
    52.434     0.564     0.200
    52.447     1.245     0.200
    52.769    -0.298     0.200
    53.898    -0.591     0.200
    54.048    -0.705     0.200
    55.090    -0.470     0.200
    55.180    -0.390     0.200
    56.837    -0.156     0.200
    56.837    -1.094     0.200
    56.862     0.507     0.200
    58.084    -0.360     0.200
    60.748     0.013     0.200
    61.928    -1.603     0.200
    64.846     0.442     0.200
    64.846     0.204     0.200
    65.633    -0.451     0.200
    76.705    -1.456     0.200
    78.116    -0.993     0.200
    79.244    -0.570     0.200
    79.561     0.088     0.200
    80.999    -1.682     0.200
    81.764    -0.922     0.200
    81.973    -0.693     0.200
    83.154     0.144     0.200
    83.421     0.233     0.200
    83.454     0.533     0.200
    83.780     1.198     0.200
    83.908    -0.917     0.200
    83.908    -0.257     0.200
    83.908    -0.886     0.200
    83.952     0.638     0.200
    84.314    -0.050     0.200
    84.955    -0.697     0.200
    85.145    -1.939     0.200
    85.366    -2.192     0.200
    85.366    -1.458     0.200
    85.686    -0.614     0.200
    87.109     0.511     0.200
    89.747    -1.964     0.200
    95.241    -0.519     0.200
    25.892     2.862     0.200
    31.286    -1.100     0.200
    34.679    -0.375     0.200
    40.691     0.431     0.200
    51.105     0.482     0.200
    55.234     0.467     0.200
    60.822    -0.883     0.200
    68.420    -0.471     0.200
    80.665    -1.186     0.200
    14.570     4.236     0.200
    15.572     4.637     0.200
    17.164     2.747     0.200
    19.648     0.910     0.200
    19.648    -0.850     0.200
    19.778     0.730     0.200
    21.656     1.489     0.200
    22.408     2.933     0.200
    23.494     1.640     0.200
    23.602     0.942     0.200
    23.745    -0.251     0.200
    23.773     1.295     0.200
    24.262    -0.851     0.200
    24.744     2.255     0.200
    24.944     2.478     0.200
    24.944    -0.062     0.200
    25.426     2.055     0.200
    26.116    -0.299     0.200
    27.390     1.710     0.200
    27.395    -1.031     0.200
    27.978    -0.806     0.200
    27.978    -0.926     0.200
    31.266    -1.860     0.200
    31.414    -1.599     0.200
    31.414    -1.719     0.200
    31.418    -0.904     0.200
    31.494    -0.682     0.200
    32.939     1.010     0.200
    34.718     0.045     0.200
    34.718     2.157     0.200
    34.807    -0.420     0.200
    34.808    -0.588     0.200
    34.808    -0.978     0.200
    36.442     1.028     0.200
    40.563     1.409     0.200
    40.563     0.224     0.200
    40.737    -0.918     0.200
    44.076    -0.603     0.200
    44.834     0.900     0.200
    44.875    -0.531     0.200
    44.875    -0.701     0.200
    48.097     1.113     0.200
    50.732     0.295     0.200
    50.988    -0.896     0.200
    50.988     0.488     0.200
    50.988    -0.777     0.200
    51.386     0.366     0.200
    53.131    -0.640     0.200
    53.867    -1.570     0.200
    53.867    -1.058     0.200
    56.961     0.943     0.200
    56.961     0.254     0.200
    60.775     0.333     0.200
    65.719    -0.811     0.200
    68.301    -1.054     0.200
    68.731     1.438     0.200
    68.946     0.462     0.200
    69.628     0.134     0.200
    75.743     0.457     0.200
    77.888     0.485     0.200
    84.087    -0.988     0.200
    84.087     1.401     0.200
    85.124    -1.253     0.200
    85.444    -1.981     0.200
    89.953    -2.951     0.200
    92.059    -0.171     0.200
    95.086    -0.164     0.200
    15.278     4.874     0.200
    17.592     0.990     0.200
    17.576     2.382     0.200
    18.357    -3.283     0.200
    19.834    -2.714     0.200
    20.011     0.059     0.200
    22.422     0.147     0.200
    22.548     0.410     0.200
    22.912    -1.161     0.200
    23.257     1.584     0.200
    23.567     0.776     0.200
    23.894    -1.148     0.200
    24.198    -0.716     0.200
    24.361    -0.498     0.200
    25.191    -1.721     0.200
    26.371     2.088     0.200
    26.877     1.311     0.200
    27.338    -0.868     0.200
    27.428    -2.537     0.200
    28.024    -0.657     0.200
    29.352    -1.010     0.200
    29.180     0.356     0.200
    29.525    -1.940     0.200
    30.410    -2.615     0.200
    30.555    -2.588     0.200
    30.560    -1.012     0.200
    30.560    -3.156     0.200
    30.564    -1.929     0.200
    30.636    -1.926     0.200
    33.524     1.726     0.200
    33.987    -1.404     0.200
    33.987    -0.351     0.200
    33.987    -1.681     0.200
    35.176    -0.680     0.200
    35.176    -0.319     0.200
    35.360    -0.488     0.200
    35.970    -3.002     0.200
    37.778    -1.001     0.200
    41.244     0.518     0.200
    41.425     1.739     0.200
    41.425     0.667     0.200
    43.270    -1.008     0.200
    43.990     0.060     0.200
    43.990    -0.414     0.200
    47.176     2.533     0.200
    50.495    -1.967     0.200
    50.905     0.225     0.200
    50.905    -0.405     0.200
    50.905    -0.245     0.200
    52.005     0.491     0.200
    52.005     0.683     0.200
    52.005    -0.038     0.200
    52.196     0.501     0.200
    52.401     0.862     0.200
    53.677    -1.581     0.200
    55.111     1.258     0.200
    56.943     1.587     0.200
    58.020     0.375     0.200
    58.020    -0.035     0.200
    58.020     0.246     0.200
    61.778    -0.469     0.200
    62.230    -1.487     0.200
    64.615    -1.261     0.200
    66.759    -0.594     0.200
    77.870    -1.074     0.200
    78.951    -0.564     0.200
    79.078    -0.480     0.200
    79.607    -0.545     0.200
    79.663     0.079     0.200
    79.685    -1.587     0.200
    79.855    -0.780     0.200
    80.723    -1.916     0.200
    82.864    -0.884     0.200
    83.109    -0.845     0.200
    83.422    -1.113     0.200
    83.592    -0.719     0.200
    84.029    -0.497     0.200
    84.243    -3.524     0.200
    84.574    -1.691     0.200
    85.462     0.257     0.200
    85.514    -0.950     0.200
    86.084    -1.317     0.200
    86.480    -0.376     0.200
    86.756     0.397     0.200
    88.440    -1.883     0.200
    89.233    -1.020     0.200
    89.233    -2.209     0.200
    95.017    -1.432     0.200
    24.450    -0.187     0.200
    25.722    -0.256     0.200
    25.690     2.157     0.200
    25.690     1.891     0.200
    27.794    -0.914     0.200
    31.246    -1.403     0.200
    34.625    -1.158     0.200
    34.625    -2.501     0.200
    35.021    -1.305     0.200
    35.021    -1.703     0.200
    39.887    -1.245     0.200
    40.563     0.488     0.200
    40.734     0.131     0.200
    51.053     0.259     0.200
    51.053     0.173     0.200
    51.053     0.665     0.200
    51.242     0.806     0.200
    52.116     0.132     0.200
    53.984    -0.509     0.200
    53.984     0.288     0.200
    53.984    -0.509     0.200
    55.851     1.081     0.200
    56.972     0.459     0.200
    56.972     0.240     0.200
    56.972    -0.455     0.200
    60.854     0.525     0.200
    61.217     1.337     0.200
    63.950    -0.675     0.200
    63.950    -1.394     0.200
    65.000     0.672     0.200
    65.000     1.859     0.200
    65.757     0.386     0.200
    65.757    -0.528     0.200
    68.385    -0.434     0.200
    83.862    -0.673     0.200
    85.235     0.501     0.200
    85.487     0.140     0.200
    89.726    -1.632     0.200
    14.339     5.815     0.200
    14.364     4.982     0.200
    14.733     4.982     0.200
    14.781     8.091     0.200
    14.942     4.259     0.200
    16.602     3.106     0.200
    17.893     0.817     0.200
    20.541     1.465     0.200
    20.770     1.788     0.200
    22.989     2.769     0.200
    23.120    -0.005     0.200
    23.218     2.461     0.200
    23.682     1.706     0.200
    25.182    -0.889     0.200
    25.368     0.838     0.200
    25.417     1.168     0.200
    25.417     0.993     0.200
    25.417     1.493     0.200
    25.416    -0.920     0.200
    25.416     1.178     0.200
    25.696     1.818     0.200
    25.696    -1.662     0.200
    28.420     2.053     0.200
    30.035    -1.891     0.200
    30.759    -1.996     0.200
    30.764    -1.430     0.200
    30.764    -1.981     0.200
    30.768    -1.737     0.200
    30.848    -1.396     0.200
    31.454     0.150     0.200
    31.474     0.764     0.200
    32.314     1.382     0.200
    33.342     3.391     0.200
    34.119    -1.072     0.200
    34.120    -0.731     0.200
    34.120    -1.220     0.200
    34.312     0.620     0.200
    35.656    -0.150     0.200
    35.656     1.742     0.200
    35.656     0.441     0.200
    35.702     1.576     0.200
    35.702    -0.396     0.200
    36.590    -0.237     0.200
    36.909     2.064     0.200
    38.703    -0.795     0.200
    39.926    -0.629     0.200
    40.570    -0.799     0.200
    40.517     0.482     0.200
    41.031    -0.812     0.200
    41.062     0.319     0.200
    41.062     1.209     0.200
    41.229     0.963     0.200
    41.229    -0.721     0.200
    42.291    -1.558     0.200
    43.370    -0.867     0.200
    44.257    -0.922     0.200
    46.556     2.057     0.200
    49.993    -0.372     0.200
    50.774    -0.653     0.200
    51.395     0.000     0.200
    51.395     0.746     0.200
    51.395     0.051     0.200
    51.583    -0.055     0.200
    51.726    -1.052     0.200
    52.098     1.824     0.200
    52.261     0.611     0.200
    52.310     0.498     0.200
    54.403    -0.841     0.200
    54.403    -0.833     0.200
    54.403    -1.384     0.200
    56.056    -0.052     0.200
    56.824    -0.640     0.200
    57.227    -0.880     0.200
    57.227    -1.130     0.200
    61.143     0.236     0.200
    61.215    -0.576     0.200
    64.476    -0.818     0.200
    64.476    -1.068     0.200
    68.630    -0.907     0.200
    68.755    -0.941     0.200
    74.484    -0.610     0.200
    77.072    -1.088     0.200
    77.984     0.008     0.200
    81.556    -1.678     0.200
    83.708     0.084     0.200
    84.245    -0.277     0.200
    85.644    -1.318     0.200
    85.792    -1.401     0.200
    85.792    -1.737     0.200
    92.605    -2.079     0.200
    19.911    -0.306     0.200
    24.048    -0.046     0.200
    26.363     1.884     0.200
    26.363    -1.015     0.200
    31.059    -0.431     0.200
    34.473     0.416     0.200
    34.473     0.111     0.200
    34.843    -0.130     0.200
    38.941     1.398     0.200
    39.051     1.075     0.200
    39.735    -0.884     0.200
    39.749     1.252     0.200
    40.318     1.233     0.200
    40.658     0.613     0.200
    40.921     0.065     0.200
    40.921    -0.607     0.200
    40.948     0.524     0.200
    41.731     0.697     0.200
    42.539     1.604     0.200
    43.151     0.843     0.200
    44.501     0.462     0.200
    44.501    -0.507     0.200
    50.709    -1.184     0.200
    51.452     0.696     0.200
    51.452     1.118     0.200
    51.452     0.353     0.200
    51.642     0.512     0.200
    54.284    -1.139     0.200
    54.284    -0.123     0.200
    54.552     0.971     0.200
    54.552    -0.357     0.200
    55.564    -0.010     0.200
    56.385    -0.950     0.200
    57.167     0.248     0.200
    57.461     0.388     0.200
    61.228     0.143     0.200
    61.841    -1.960     0.200
    61.841    -1.178     0.200
    61.810     0.453     0.200
    65.565     0.119     0.200
    65.565    -0.388     0.200
    66.201    -0.284     0.200
    66.201    -0.159     0.200
    77.435    -0.066     0.200
    78.228    -0.067     0.200
    79.143    -2.076     0.200
    80.534    -1.901     0.200
    84.075    -1.610     0.200
    84.605     0.470     0.200
    84.605     0.111     0.200
    85.546    -1.120     0.200
    85.546    -0.963     0.200
    85.922    -1.183     0.200
    85.922    -1.504     0.200
    27.633     0.653     0.200
    31.356    -1.330     0.200
    34.741    -0.466     0.200
    50.990    -1.007     0.200
    31.296    -1.988     0.200
    34.678    -0.874     0.200
    44.768    -1.297     0.200
    51.027     0.417     0.200
    53.945    -0.175     0.200
    25.331     1.269     0.200
    31.655    -2.089     0.200
    35.027    -1.131     0.200
    45.134    -0.987     0.200
    50.628     0.832     0.200
    53.563     0.030     0.200
    54.770    -0.193     0.200
    15.432     4.390     0.200
    20.325     0.046     0.200
    20.841     0.521     0.200
    23.429    -1.302     0.200
    23.540     1.227     0.200
    23.968     1.065     0.200
    24.029    -0.395     0.200
    24.721     1.043     0.200
    25.030     1.104     0.200
    25.354    -0.153     0.200
    25.647    -0.096     0.200
    26.190     0.943     0.200
    26.190     1.365     0.200
    26.190     0.662     0.200
    26.287    -0.726     0.200
    27.725    -0.780     0.200
    27.711     0.271     0.200
    30.944    -1.610     0.200
    31.092    -1.518     0.200
    31.487    -1.131     0.200
    34.496    -0.630     0.200
    34.497    -0.689     0.200
    34.497    -1.329     0.200
    36.805     1.801     0.200
    37.647    -0.420     0.200
    37.648     0.628     0.200
    38.787     1.647     0.200
    38.896     1.441     0.200
    39.593     1.615     0.200
    40.164     1.668     0.200
    40.473    -0.749     0.200
    40.505     1.345     0.200
    40.885    -0.874     0.200
    42.420     0.438     0.200
    42.995     0.568     0.200
    43.770    -0.425     0.200
    44.544    -0.090     0.200
    44.544    -0.468     0.200
    50.821     0.296     0.200
    50.821     0.073     0.200
    51.358     0.952     0.200
    51.358     0.839     0.200
    51.358     0.534     0.200
    51.548     0.668     0.200
    54.218    -0.506     0.200
    54.218    -0.627     0.200
    57.342     0.743     0.200
    61.141    -0.450     0.200
    65.424    -0.770     0.200
    65.424    -0.328     0.200
    66.095    -0.912     0.200
    67.571    -0.306     0.200
    68.665    -0.551     0.200
    74.288    -1.641     0.200
    77.236    -0.618     0.200
    77.501    -1.082     0.200
    77.779    -0.935     0.200
    78.150     0.163     0.200
    78.384    -0.683     0.200
    79.484    -0.236     0.200
    80.647    -1.271     0.200
    84.033    -1.092     0.200
    84.470    -0.530     0.200
    85.477    -1.954     0.200
    85.819    -1.508     0.200
    89.676    -2.984     0.200
    89.676    -2.640     0.200
    92.407    -0.896     0.200
    94.916    -2.428     0.200
    95.456    -1.302     0.200
    34.728     0.044     0.200
    51.003    -0.528     0.200
    53.910    -0.938     0.200
    55.138    -1.207     0.200
    31.231    -0.540     0.200
    34.663    -1.398     0.200
    44.654     0.827     0.200
    51.411     0.269     0.200
    55.508    -1.129     0.200
    14.037     3.954     0.200
    14.544     4.783     0.200
    14.500     4.071     0.200
    14.571     4.931     0.200
    14.571     7.642     0.200
    14.725     3.502     0.200
    14.837     5.134     0.200
    14.837     5.696     0.200
    15.529     2.814     0.200
    16.710     0.806     0.200
    16.710     4.697     0.200
    16.710     5.064     0.200
    17.306     2.793     0.200
    17.304     0.642     0.200
    17.304     1.704     0.200
    17.304     4.603     0.200
    17.975     0.226     0.200
    18.436     0.602     0.200
    18.436    -1.530     0.200
    18.635     1.586     0.200
    19.361    -0.793     0.200
    19.477     0.244     0.200
    19.877    -1.225     0.200
    21.554     1.158     0.200
    22.411     2.232     0.200
    22.787     0.247     0.200
    22.928     0.558     0.200
    22.954     1.778     0.200
    23.243    -1.941     0.200
    23.243    -1.558     0.200
    23.243    -1.050     0.200
    23.301     2.551     0.200
    23.301     0.528     0.200
    23.301     1.739     0.200
    23.482    -1.341     0.200
    23.482    -0.732     0.200
    23.736    -1.860     0.200
    23.736    -0.055     0.200
    23.736    -0.508     0.200
    23.920    -2.135     0.200
    23.920    -1.338     0.200
    23.920     0.458     0.200
    24.014     2.297     0.200
    24.300    -0.343     0.200
    24.300     2.087     0.200
    24.488     0.020     0.200
    25.026    -0.159     0.200
    25.026     1.482     0.200
    25.197    -1.542     0.200
    25.263    -0.208     0.200
    25.263     0.534     0.200
    25.263     0.683     0.200
    25.515    -0.775     0.200
    25.515    -0.017     0.200
    26.084     2.995     0.200
    26.625    -0.666     0.200
    26.625     0.709     0.200
    26.651     0.026     0.200
    26.651    -0.255     0.200
    26.651     0.979     0.200
    26.753     1.268     0.200
    26.786     1.458     0.200
    26.786    -0.441     0.200
    26.746    -0.055     0.200
    26.746     2.860     0.200
    26.785    -0.396     0.200
    27.231     0.958     0.200
    27.313    -0.074     0.200
    27.650    -1.368     0.200
    27.580     1.530     0.200
    27.725    -1.071     0.200
    27.725    -0.056     0.200
    27.783    -2.519     0.200
    27.783    -2.168     0.200
    27.783    -0.675     0.200
    27.783    -1.455     0.200
    28.132    -1.989     0.200
    28.326    -0.119     0.200
    28.481     0.034     0.200
    28.867     0.372     0.200
    29.068     0.290     0.200
    29.212     0.307     0.200
    29.282    -2.000     0.200
    29.282    -0.813     0.200
    29.282    -1.406     0.200
    29.282    -2.296     0.200
    29.282    -1.757     0.200
    29.377     1.341     0.200
    29.670    -1.302     0.200
    29.558     2.216     0.200
    30.068     0.932     0.200
    30.631    -1.139     0.200
    30.631    -2.241     0.200
    30.742    -1.409     0.200
    30.886    -3.587     0.200
    30.886    -4.001     0.200
    30.891    -2.956     0.200
    30.891    -0.987     0.200
    31.168    -0.465     0.200
    31.168     0.176     0.200
    31.188     0.051     0.200
    31.444    -1.465     0.200
    31.444    -0.410     0.200
    32.507     1.960     0.200
    33.127    -0.805     0.200
    33.199    -0.486     0.200
    33.193     0.970     0.200
    33.362    -0.969     0.200
    33.362    -1.172     0.200
    33.362    -0.508     0.200
    33.489     1.892     0.200
    33.818    -0.074     0.200
    33.953    -0.649     0.200
    34.074    -0.745     0.200
    34.317    -1.319     0.200
    34.317    -0.694     0.200
    34.317    -0.600     0.200
    34.328     0.211     0.200
    34.700    -0.605     0.200
    34.888    -0.072     0.200
    34.887     0.171     0.200
    34.912     0.059     0.200
    34.997    -0.481     0.200
    34.997    -0.168     0.200
    34.997     0.832     0.200
    34.997     0.340     0.200
    35.929    -1.374     0.200
    35.950    -0.060     0.200
    36.292    -1.277     0.200
    37.111     2.252     0.200
    37.304     2.286     0.200
    37.304     2.598     0.200
    37.530     0.554     0.200
    37.531     0.275     0.200
    37.978     2.418     0.200
    39.089     0.493     0.200
    39.510    -0.377     0.200
    39.658    -0.518     0.200
    39.658    -0.158     0.200
    39.789    -0.539     0.200
    40.040     0.576     0.200
    40.074    -0.103     0.200
    40.074    -0.970     0.200
    40.074     0.100     0.200
    40.074    -0.806     0.200
    40.074    -0.244     0.200
    40.169     1.464     0.200
    40.169     2.510     0.200
    40.377    -1.044     0.200
    40.457    -0.477     0.200
    40.657     0.279     0.200
    40.912     0.120     0.200
    40.912     0.573     0.200
    40.912     0.354     0.200
    41.094    -0.153     0.200
    41.094     0.043     0.200
    43.043    -1.131     0.200
    43.192    -0.115     0.200
    43.599    -0.212     0.200
    43.536    -0.091     0.200
    43.811     0.500     0.200
    43.935    -0.991     0.200
    44.184     0.109     0.200
    44.322     0.205     0.200
    44.322    -0.350     0.200
    44.322     0.033     0.200
    44.322     0.306     0.200
    44.324    -0.609     0.200
    45.581     0.896     0.200
    45.581     1.200     0.200
    45.656     1.325     0.200
    46.857     2.069     0.200
    47.434    -0.834     0.200
    48.234    -1.021     0.200
    48.723    -0.783     0.200
    50.234     0.158     0.200
    50.573     0.144     0.200
    50.673     0.057     0.200
    50.673    -0.943     0.200
    50.673    -0.614     0.200
    50.826     0.045     0.200
    51.014     0.137     0.200
    51.014    -0.371     0.200
    51.014     0.028     0.200
    51.014    -0.074     0.200
    51.515    -0.984     0.200
    51.686     0.693     0.200
    51.686     0.404     0.200
    51.686     0.873     0.200
    51.741     0.283     0.200
    51.877     0.621     0.200
    51.877     0.964     0.200
    51.965     0.319     0.200
    52.093     1.002     0.200
    52.186     0.399     0.200
    52.328    -1.019     0.200
    52.328    -1.308     0.200
    52.328    -2.175     0.200
    52.326     0.237     0.200
    52.641     2.600     0.200
    52.774     1.069     0.200
    52.975     0.371     0.200
    52.975     1.011     0.200
    53.184     0.196     0.200
    53.318     0.710     0.200
    53.411    -0.939     0.200
    53.411    -0.470     0.200
    53.411    -0.572     0.200
    53.411    -0.212     0.200
    53.392     0.166     0.200
    53.461     1.477     0.200
    53.761     0.815     0.200
    54.049     0.067     0.200
    54.049     0.169     0.200
    54.161     1.243     0.200
    54.491    -0.900     0.200
    54.491    -1.049     0.200
    54.491    -0.705     0.200
    54.502     1.493     0.200
    54.644     2.164     0.200
    54.806     1.525     0.200
    54.806     0.212     0.200
    54.806     1.759     0.200
    55.035     0.853     0.200
    55.178     1.870     0.200
    55.308     1.481     0.200
    55.405     0.404     0.200
    55.683     0.999     0.200
    55.790    -0.091     0.200
    55.790     0.276     0.200
    55.790     0.409     0.200
    55.790     0.534     0.200
    55.793     0.236     0.200
    56.011     0.200     0.200
    56.577    -0.119     0.200
    56.669     0.007     0.200
    56.651     0.565     0.200
    56.651     0.830     0.200
    57.080     0.102     0.200
    57.549    -0.386     0.200
    57.549     0.145     0.200
    57.717     0.175     0.200
    57.717     0.190     0.200
    57.723     0.789     0.200
    57.759     0.117     0.200
    58.114     0.226     0.200
    58.164     0.374     0.200
    58.834     0.117     0.200
    60.604    -0.398     0.200
    61.383    -0.748     0.200
    61.383    -0.169     0.200
    61.455    -0.561     0.200
    61.455    -0.029     0.200
    61.455     0.182     0.200
    61.923    -2.063     0.200
    61.923    -1.281     0.200
    61.923    -1.742     0.200
    63.117    -1.047     0.200
    64.227    -0.920     0.200
    64.227    -0.795     0.200
    64.349    -1.836     0.200
    64.349    -1.265     0.200
    64.349    -1.445     0.200
    64.675    -1.095     0.200
    64.675    -0.994     0.200
    66.446    -0.475     0.200
    66.446    -1.225     0.200
    66.446    -0.569     0.200
    66.446    -0.436     0.200
    66.791     1.256     0.200
    66.809     0.953     0.200
    66.817     0.224     0.200
    66.885     0.223     0.200
    67.171     0.305     0.200
    67.243    -0.060     0.200
    67.549     0.532     0.200
    68.021    -1.521     0.200
    68.021    -0.404     0.200
    68.021    -1.170     0.200
    67.974    -0.406     0.200
    68.213    -1.396     0.200
    68.328    -1.569     0.200
    68.538    -1.701     0.200
    69.057    -1.302     0.200
    69.057    -1.466     0.200
    69.057    -1.091     0.200
    69.280     0.697     0.200
    69.586    -1.487     0.200
    69.586    -0.987     0.200
    69.710    -0.190     0.200
    70.066    -1.197     0.200
    70.066    -0.384     0.200
    71.197    -0.404     0.200
    71.548     0.305     0.200
    71.548    -0.984     0.200
    71.820    -1.462     0.200
    72.284    -1.382     0.200
    72.284    -0.085     0.200
    72.434     0.298     0.200
    72.447    -1.687     0.200
    72.585     0.202     0.200
    72.591    -0.263     0.200
    72.964    -0.144     0.200
    73.084    -0.021     0.200
    73.084     0.205     0.200
    73.169    -0.084     0.200
    73.249    -0.578     0.200
    73.291    -0.475     0.200
    73.291    -1.350     0.200
    73.315    -0.557     0.200
    73.315    -0.143     0.200
    73.322     0.167     0.200
    73.418    -0.195     0.200
    73.559    -0.657     0.200
    73.559    -0.415     0.200
    73.709    -0.255     0.200
    73.736    -0.790     0.200
    73.796     0.157     0.200
    73.921    -1.222     0.200
    73.924    -0.523     0.200
    73.929    -0.419     0.200
    74.029    -0.329     0.200
    74.067    -1.630     0.200
    74.139    -0.372     0.200
    74.143     0.005     0.200
    74.243     0.299     0.200
    74.225    -1.142     0.200
    74.387     0.094     0.200
    74.387    -0.150     0.200
    74.389    -0.655     0.200
    74.389    -0.147     0.200
    74.448     0.381     0.200
    74.554    -1.549     0.200
    74.554    -1.393     0.200
    74.584    -0.020     0.200
    74.661    -0.007     0.200
    74.681    -0.435     0.200
    74.628    -1.086     0.200
    74.748     0.140     0.200
    74.814     0.088     0.200
    74.837     0.355     0.200
    74.959     0.135     0.200
    75.061    -0.193     0.200
    75.070    -0.015     0.200
    75.071     0.446     0.200
    75.084     0.383     0.200
    75.117     0.260     0.200
    75.137    -0.250     0.200
    75.270     0.450     0.200
    75.342     0.398     0.200
    75.340    -0.247     0.200
    75.496     0.324     0.200
    75.592    -0.117     0.200
    75.590     0.567     0.200
    75.621     0.573     0.200
    75.628    -0.421     0.200
    75.641    -0.223     0.200
    75.718    -0.095     0.200
    75.791    -0.190     0.200
    75.795     0.523     0.200
    75.874    -0.098     0.200
    76.030     0.021     0.200
    76.030     0.193     0.200
    76.079    -0.415     0.200
    76.079     0.093     0.200
    76.089    -1.474     0.200
    76.114    -0.870     0.200
    76.146    -0.400     0.200
    76.216    -0.383     0.200
    76.223    -0.041     0.200
    76.272     0.168     0.200
    76.296    -0.173     0.200
    76.371     0.257     0.200
    76.338     0.234     0.200
    76.338     1.515     0.200
    76.407    -0.020     0.200
    76.485     0.228     0.200
    76.535    -2.034     0.200
    76.508    -0.949     0.200
    76.549     0.144     0.200
    76.575    -1.360     0.200
    76.571    -0.273     0.200
    76.571     0.493     0.200
    76.571     0.368     0.200
    76.683    -0.111     0.200
    76.781     0.087     0.200
    76.812    -1.419     0.200
    76.800    -0.097     0.200
    76.883     0.135     0.200
    76.899    -0.088     0.200
    76.917    -0.032     0.200
    76.941     0.032     0.200
    76.970     0.365     0.200
    77.015    -0.318     0.200
    77.082     0.127     0.200
    77.132     0.011     0.200
    77.143    -0.229     0.200
    77.123     0.187     0.200
    77.245     0.157     0.200
    77.298    -1.375     0.200
    77.323     0.166     0.200
    77.344     0.177     0.200
    77.356     0.003     0.200
    77.430    -0.626     0.200
    77.430    -0.431     0.200
    77.507    -0.112     0.200
    77.538    -0.518     0.200
    77.613     0.096     0.200
    77.636    -0.583     0.200
    77.633    -0.011     0.200
    77.677     0.285     0.200
    77.624    -1.890     0.200
    77.624    -0.820     0.200
    77.736    -0.327     0.200
    77.771    -0.037     0.200
    77.823    -1.030     0.200
    77.823    -0.624     0.200
    77.823    -0.468     0.200
    77.770    -0.344     0.200
    77.770    -0.157     0.200
    77.770     0.640     0.200
    77.828    -0.482     0.200
    77.858    -1.140     0.200
    77.940    -0.906     0.200
    78.004     0.189     0.200
    78.094    -0.957     0.200
    78.095    -1.002     0.200
    78.086    -0.316     0.200
    78.133    -0.243     0.200
    78.155    -0.968     0.200
    78.155    -0.382     0.200
    78.220    -0.960     0.200
    78.220    -0.296     0.200
    78.239    -0.016     0.200
    78.283    -1.915     0.200
    78.259    -0.946     0.200
    78.349     0.257     0.200
    78.437    -1.555     0.200
    78.518    -0.002     0.200
    78.500     0.569     0.200
    78.585    -0.412     0.200
    78.601    -0.294     0.200
    78.603     0.311     0.200
    78.726    -0.323     0.200
    78.805    -1.637     0.200
    78.805    -1.184     0.200
    78.848    -1.061     0.200
    78.966     0.325     0.200
    79.018    -0.339     0.200
    79.028    -1.162     0.200
    79.028    -0.841     0.200
    79.033    -0.305     0.200
    79.103    -1.261     0.200
    79.105     0.010     0.200
    79.167     0.216     0.200
    79.293    -1.397     0.200
    79.306    -1.120     0.200
    79.340     0.368     0.200
    79.356     0.187     0.200
    79.362    -0.418     0.200
    79.362     0.074     0.200
    79.357    -2.668     0.200
    79.433    -0.312     0.200
    79.449    -1.697     0.200
    79.449    -0.931     0.200
    79.561    -1.157     0.200
    79.577    -1.070     0.200
    79.577    -1.312     0.200
    79.631    -0.997     0.200
    79.637     0.035     0.200
    79.680    -0.334     0.200
    79.764     0.062     0.200
    79.822    -1.268     0.200
    79.816    -0.562     0.200
    79.981    -1.197     0.200
    79.981    -0.721     0.200
    79.987    -1.197     0.200
    79.937    -1.919     0.200
    79.943    -1.157     0.200
    80.000     0.318     0.200
    80.041    -0.070     0.200
    80.079    -1.942     0.200
    80.079    -0.286     0.200
    80.079    -1.684     0.200
    80.079    -0.934     0.200
    80.105    -1.421     0.200
    80.181    -0.064     0.200
    80.204    -0.608     0.200
    80.240    -1.048     0.200
    80.352    -1.580     0.200
    80.352    -1.049     0.200
    80.428    -0.906     0.200
    80.428    -0.492     0.200
    80.479    -0.471     0.200
    80.484    -1.951     0.200
    80.495    -2.719     0.200
    80.495    -2.469     0.200
    80.506    -0.406     0.200
    80.587    -0.706     0.200
    80.541    -2.570     0.200
    80.724     0.304     0.200
    80.857     0.310     0.200
    80.858     0.461     0.200
    80.864     0.307     0.200
    80.895    -1.588     0.200
    80.906    -1.270     0.200
    80.957     0.109     0.200
    80.988     0.558     0.200
    81.030    -1.046     0.200
    81.045    -1.106     0.200
    81.118    -0.475     0.200
    81.155    -2.022     0.200
    81.225    -0.960     0.200
    81.225    -0.413     0.200
    81.181    -1.802     0.200
    81.183    -1.480     0.200
    81.183    -0.894     0.200
    81.268    -0.149     0.200
    81.268    -0.407     0.200
    81.277    -0.030     0.200
    81.337     0.273     0.200
    81.412    -0.307     0.200
    81.423     0.360     0.200
    81.426     0.095     0.200
    81.450    -1.140     0.200
    81.450    -0.835     0.200
    81.625     0.146     0.200
    81.740    -0.282     0.200
    81.724    -0.840     0.200
    81.794    -0.546     0.200
    81.807    -0.886     0.200
    81.941    -0.982     0.200
    81.983    -0.091     0.200
    81.983     0.010     0.200
    82.025     0.461     0.200
    82.035    -0.975     0.200
    82.185    -0.236     0.200
    82.333     0.148     0.200
    82.413    -0.217     0.200
    82.431     0.260     0.200
    82.476     0.182     0.200
    82.418     0.056     0.200
    82.515    -0.348     0.200
    82.552    -0.229     0.200
    82.598     0.217     0.200
    82.639     0.491     0.200
    82.640     0.201     0.200
    82.891    -1.473     0.200
    82.869     0.232     0.200
    82.832    -0.859     0.200
    82.888    -0.130     0.200
    82.936     0.098     0.200
    83.032     0.068     0.200
    83.056     0.017     0.200
    83.184     0.476     0.200
    83.207    -0.187     0.200
    83.203    -0.041     0.200
    83.293    -0.347     0.200
    83.355     0.403     0.200
    83.376     0.521     0.200
    83.398     0.205     0.200
    83.546    -0.221     0.200
    83.663    -0.305     0.200
    83.678     0.274     0.200
    83.695    -1.701     0.200
    83.803    -0.316     0.200
    83.803     0.067     0.200
    83.807     0.133     0.200
    83.866    -0.043     0.200
    83.880    -0.092     0.200
    83.961     0.596     0.200
    84.034     0.387     0.200
    84.042    -0.294     0.200
    84.084     0.664     0.200
    84.242     0.604     0.200
    84.253    -0.962     0.200
    84.253    -1.361     0.200
    84.253    -1.017     0.200
    84.297    -0.402     0.200
    84.297    -1.996     0.200
    84.297    -1.261     0.200
    84.406     0.106     0.200
    84.494     0.763     0.200
    84.493    -0.728     0.200
    84.524     0.791     0.200
    84.532     0.652     0.200
    84.532     0.386     0.200
    84.505    -0.087     0.200
    84.562    -0.932     0.200
    84.595    -0.294     0.200
    84.606     0.655     0.200
    84.655     0.264     0.200
    84.611    -1.357     0.200
    84.746    -0.341     0.200
    84.814     0.654     0.200
    84.827     0.437     0.200
    84.865    -0.251     0.200
    84.874    -0.766     0.200
    84.874    -0.571     0.200
    85.019     0.125     0.200
    85.229     0.400     0.200
    85.248    -0.157     0.200
    85.248     0.460     0.200
    85.268    -1.153     0.200
    85.268    -0.794     0.200
    85.320     0.518     0.200
    85.324    -1.052     0.200
    85.367     0.539     0.200
    85.400    -0.974     0.200
    85.415    -0.388     0.200
    85.562    -0.812     0.200
    85.654     0.153     0.200
    85.753    -1.318     0.200
    85.755    -1.660     0.200
    85.755    -1.066     0.200
    85.827    -0.223     0.200
    85.928     0.426     0.200
    85.938     0.128     0.200
    85.982    -1.401     0.200
    86.088    -0.127     0.200
    86.064    -1.894     0.200
    86.165    -1.344     0.200
    86.165    -0.992     0.200
    86.176    -1.336     0.200
    86.176    -1.180     0.200
    86.274    -2.154     0.200
    86.404    -0.098     0.200
    86.542    -0.348     0.200
    86.542     0.160     0.200
    86.498    -0.632     0.200
    86.603    -0.143     0.200
    86.603     0.068     0.200
    86.816    -0.678     0.200
    86.788    -0.041     0.200
    86.870     0.252     0.200
    87.159    -0.075     0.200
    87.272     0.011     0.200
    87.213    -0.896     0.200
    87.292    -0.008     0.200
    87.370    -0.117     0.200
    87.344     0.296     0.200
    87.457    -0.132     0.200
    87.475    -1.294     0.200
    87.646    -0.440     0.200
    87.699    -0.046     0.200
    87.898    -1.244     0.200
    87.922     0.822     0.200
    87.922     1.603     0.200
    87.947    -1.117     0.200
    88.252     0.086     0.200
    88.300    -2.305     0.200
    88.489    -2.272     0.200
    88.575    -0.601     0.200
    88.744    -3.124     0.200
    88.744    -0.287     0.200
    88.683    -1.110     0.200
    88.772     0.143     0.200
    88.771    -0.031     0.200
    88.827    -1.163     0.200
    88.909    -0.643     0.200
    89.029    -0.109     0.200
    89.042    -2.151     0.200
    89.042    -1.495     0.200
    89.123    -0.285     0.200
    89.259    -2.853     0.200
    89.376    -0.183     0.200
    89.359    -0.449     0.200
    89.385    -0.806     0.200
    89.385    -0.993     0.200
    89.389    -0.817     0.200
    89.389    -1.138     0.200
    89.389     0.112     0.200
    89.556    -1.728     0.200
    89.556    -2.009     0.200
    89.524    -0.129     0.200
    89.596    -0.200     0.200
    89.724    -2.118     0.200
    89.778    -2.353     0.200
    89.855    -0.259     0.200
    90.475    -0.798     0.200
    90.488    -0.234     0.200
    90.678     0.342     0.200
    90.842    -0.747     0.200
    90.871    -1.477     0.200
    90.951     0.489     0.200
    91.006    -0.448     0.200
    91.464     0.312     0.200
    91.742    -0.794     0.200
    91.809    -0.675     0.200
    91.919    -0.543     0.200
    91.929    -1.749     0.200
    92.053     0.054     0.200
    92.088    -0.762     0.200
    92.120    -0.412     0.200
    92.120    -0.944     0.200
    92.258    -1.471     0.200
    92.420    -2.265     0.200
    92.467    -1.169     0.200
    92.524    -2.184     0.200
    92.653     0.914     0.200
    92.671    -2.270     0.200
    92.671    -2.246     0.200
    93.147    -1.355     0.200
    93.255    -0.463     0.200
    93.369    -1.461     0.200
    93.448     0.048     0.200
    93.524    -1.338     0.200
    93.603     0.438     0.200
    93.641    -1.341     0.200
    93.641    -0.942     0.200
    93.805    -0.092     0.200
    93.868     0.516     0.200
    93.939    -1.075     0.200
    94.028    -0.448     0.200
    94.106    -1.397     0.200
    94.101    -0.409     0.200
    94.175     0.104     0.200
    94.184    -0.335     0.200
    94.256     0.437     0.200
    94.276    -0.453     0.200
    94.314    -0.034     0.200
    94.382    -0.346     0.200
    94.382     0.154     0.200
    94.382    -0.533     0.200
    94.590    -0.493     0.200
    94.780    -1.669     0.200
    94.780    -0.989     0.200
    95.065     0.131     0.200
    95.125    -0.842     0.200
    95.319     0.224     0.200
    95.382    -0.321     0.200
    95.403    -0.330     0.200
    95.525    -1.419     0.200
    95.774     0.213     0.200
    95.781    -1.239     0.200
    95.781    -0.724     0.200
    95.799    -0.320     0.200
    95.960    -0.247     0.200
    96.050    -0.230     0.200
    96.288    -0.543     0.200
    96.293    -0.100     0.200
    96.322    -1.129     0.200
    96.322    -0.105     0.200
    96.322    -0.972     0.200
    96.322    -0.043     0.200
    96.349     0.186     0.200
    96.366    -0.976     0.200
    96.450    -0.337     0.200
    96.665    -0.390     0.200
    96.706    -0.137     0.200
    96.828    -0.868     0.200
    96.765    -0.349     0.200
    96.801    -0.073     0.200
    96.831    -0.021     0.200
    96.851    -0.401     0.200
    96.861     0.039     0.200
    96.922    -0.208     0.200
    97.057    -0.035     0.200
    97.201     0.124     0.200
    97.505    -0.525     0.200
    97.874    -1.843     0.200
    98.074    -0.375     0.200
    98.218    -0.545     0.200
    98.226    -0.512     0.200
    98.293    -0.314     0.200
    98.436    -0.257     0.200
    98.502    -0.224     0.200
    98.516    -0.818     0.200
    98.668    -0.274     0.200
    98.861    -0.130     0.200
    98.882    -0.199     0.200
    99.223    -1.345     0.200
    99.340    -1.132     0.200
    99.512    -0.600     0.200
    23.539     0.589     0.200
    24.921     0.286     0.200
    25.814     0.945     0.200
    25.992     1.077     0.200
    25.992     0.312     0.200
    25.992     1.238     0.200
    26.098     1.238     0.200
    27.251    -0.935     0.200
    30.758    -1.630     0.200
    30.758    -2.368     0.200
    34.134    -0.779     0.200
    34.135    -0.466     0.200
    34.564     1.125     0.200
    39.650     1.536     0.200
    41.223     1.372     0.200
    41.223     0.426     0.200
    51.448    -1.435     0.200
    51.512     0.775     0.200
    51.512     0.615     0.200
    51.512     0.865     0.200
    51.700     0.543     0.200
    52.495     1.112     0.200
    54.463    -0.878     0.200
    54.463    -0.136     0.200
    54.463    -0.468     0.200
    55.660    -0.371     0.200
    55.660    -0.212     0.200
    57.400    -0.574     0.200
    57.400    -0.316     0.200
    62.384    -1.351     0.200
    66.202    -0.927     0.200
    66.202    -1.158     0.200
    81.276    -2.356     0.200
    81.276    -2.110     0.200
    84.350    -1.241     0.200
    84.350    -0.815     0.200
    84.457    -0.077     0.200
    84.457    -0.378     0.200
    84.549    -0.989     0.200
    85.712    -0.816     0.200
    89.241    -2.394     0.200
    89.241    -2.019     0.200
    19.166    -1.459     0.200
    24.396    -2.377     0.200
    25.712     1.898     0.200
    27.830    -0.438     0.200
    27.830    -1.457     0.200
    31.109    -1.781     0.200
    31.387    -0.795     0.200
    31.502    -1.769     0.200
    34.196     0.570     0.200
    34.706    -0.266     0.200
    34.706    -0.748     0.200
    34.907     0.100     0.200
    34.964     0.187     0.200
    51.008    -0.658     0.200
    51.008     0.027     0.200
    51.008    -0.479     0.200
    53.922    -0.650     0.200
    53.922    -0.869     0.200
    55.144    -0.997     0.200
    55.145     0.279     0.200
    56.944    -0.956     0.200
    60.732    -0.346     0.200
    63.865    -0.751     0.200
    63.865    -0.600     0.200
    75.240     0.107     0.200
    75.441    -0.200     0.200
    14.506     4.320     0.200
    17.711     1.970     0.200
    17.727     3.265     0.200
    18.009     1.189     0.200
    18.748    -0.678     0.200
    19.156     0.093     0.200
    19.518    -0.385     0.200
    23.647    -0.480     0.200
    23.771     1.616     0.200
    25.061     1.432     0.200
    25.792     1.810     0.200
    25.823     1.467     0.200
    25.993     1.584     0.200
    27.643    -0.481     0.200
    27.853    -0.371     0.200
    31.319    -1.727     0.200
    34.156    -0.795     0.200
    34.707    -1.072     0.200
    34.707    -0.451     0.200
    34.861    -0.115     0.200
    34.861    -0.595     0.200
    34.923    -0.271     0.200
    36.590     1.614     0.200
    39.206     0.923     0.200
    39.704     0.855     0.200
    39.778     1.350     0.200
    40.120     1.514     0.200
    40.332    -0.644     0.200
    40.407     0.231     0.200
    40.419     1.129     0.200
    40.616    -0.855     0.200
    40.659     0.800     0.200
    42.034     1.257     0.200
    42.608     1.080     0.200
    44.785    -0.067     0.200
    46.102    -0.348     0.200
    51.042     0.067     0.200
    51.042     0.169     0.200
    51.047     0.891     0.200
    51.232     0.693     0.200
    52.059     1.589     0.200
    52.174     0.711     0.200
    53.942    -0.332     0.200
    53.942    -0.621     0.200
    55.174     0.139     0.200
    55.175    -0.032     0.200
    56.993    -0.006     0.200
    57.841    -2.815     0.200
    60.763     0.485     0.200
    63.207    -0.770     0.200
    63.860    -0.732     0.200
    75.711    -0.149     0.200
    76.959    -0.881     0.200
    77.600    -1.410     0.200
    77.923    -2.018     0.200
    79.055    -0.658     0.200
    79.161    -0.438     0.200
    80.715    -2.922     0.200
    83.131    -0.252     0.200
    83.796    -1.613     0.200
    83.796    -1.004     0.200
    85.197    -1.595     0.200
    85.489    -1.474     0.200
    89.836    -3.054     0.200
    89.836    -2.128     0.200
    89.946    -1.231     0.200
    26.645     0.165     0.200
    27.341    -0.842     0.200
    31.207    -1.567     0.200
    34.497    -0.946     0.200
    34.644    -0.548     0.200
    44.623    -0.556     0.200
    50.276    -1.782     0.200
    50.365    -0.918     0.200
    51.469     0.005     0.200
    55.562    -0.934     0.200
    80.097    -2.161     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   100.673     0.953     0.200
    99.732     1.424     0.200
    99.620     2.422     0.200
    99.625     1.999     0.200
    99.761     2.795     0.200
    99.762     4.488     0.200
    99.790     3.066     0.200
    99.824     3.712     0.200
    99.822     1.522     0.200
    99.883     4.751     0.200
    99.889     1.805     0.200
   100.040     1.751     0.200
   100.087     1.667     0.200
   100.342     1.711     0.200
   100.246     2.437     0.200
   100.306     2.971     0.200
   100.501     0.006     0.200
   100.378     2.302     0.200
   100.428     1.328     0.200
   100.611     2.014     0.200
   100.641     1.861     0.200
   100.665    -4.226     0.200
   100.666    -3.228     0.200
   100.798     4.883     0.200
   100.825     2.762     0.200
   100.830     1.741     0.200
   100.906     3.202     0.200
   101.245     4.195     0.200
   101.570     3.450     0.200
   101.737     3.910     0.200
   101.740     3.694     0.200
   101.872    -4.589     0.200
   102.656     2.925     0.200
   102.682     2.810     0.200
   103.034     2.941     0.200
   102.873     2.758     0.200
   102.916     3.469     0.200
   103.075     1.061     0.200
   102.975     3.006     0.200
   103.195     0.528     0.200
   103.194     3.131     0.200
   103.576     0.834     0.200
   103.613     3.072     0.200
   103.947     2.886     0.200
   103.950     3.270     0.200
   104.246    -1.145     0.200
   104.796     1.412     0.200
   104.990     3.745     0.200
   106.784     3.572     0.200
   108.006     2.139     0.200
   121.805     4.664     0.200
    99.628     4.069     0.200
    99.768     0.722     0.200
    99.799     3.587     0.200
    99.895     3.359     0.200
   100.093     0.477     0.200
   100.397     1.428     0.200
   100.310     4.116     0.200
   100.344     3.161     0.200
   100.611    -4.523     0.200
   100.647     0.314     0.200
   100.832     1.095     0.200
   100.839     4.063     0.200
   100.910     3.146     0.200
   101.248     2.644     0.200
   101.571     2.908     0.200
   102.662     4.757     0.200
   102.684     4.561     0.200
   104.954     2.967     0.200
   100.952     0.397     0.200
   104.146     2.440     0.200
   104.339    -0.301     0.200
   110.571    -1.853     0.200
   112.599    -1.465     0.200
    99.623    -0.765     0.200
    99.775    -2.453     0.200
    99.745    -1.024     0.200
   100.047    -2.051     0.200
    99.947    -4.586     0.200
   100.106    -2.065     0.200
   100.238     0.078     0.200
   100.272    -1.205     0.200
   100.324    -0.762     0.200
   100.535    -0.802     0.200
   100.538    -0.637     0.200
   100.612    -1.691     0.200
   100.789    -1.612     0.200
   100.816    -1.677     0.200
   100.973    -0.160     0.200
   100.973    -0.884     0.200
   100.973    -0.599     0.200
   101.000     2.884     0.200
   101.205    -3.928     0.200
   101.275    -3.581     0.200
   101.437    -0.166     0.200
   101.396    -3.458     0.200
   101.971    -3.702     0.200
   102.342     1.293     0.200
   102.369    -3.894     0.200
   102.940    -4.474     0.200
   103.084    -3.410     0.200
   103.124    -3.900     0.200
   103.158    -4.050     0.200
   103.445    -4.097     0.200
   103.557    -0.724     0.200
   103.622    -0.876     0.200
   103.651    -3.653     0.200
   104.638    -0.197     0.200
   104.677     0.485     0.200
   104.648    -4.187     0.200
   105.045    -0.372     0.200
   105.202     1.160     0.200
   105.300     2.862     0.200
   105.319     2.407     0.200
   105.307     1.591     0.200
   105.537     1.079     0.200
   105.498     2.737     0.200
   105.686     1.464     0.200
   105.690     2.615     0.200
   105.728     3.299     0.200
   105.741     0.746     0.200
   105.661    -3.909     0.200
   105.925     0.849     0.200
   105.968     1.887     0.200
   105.977     1.880     0.200
   106.390     0.798     0.200
   106.412     1.526     0.200
   106.419     0.733     0.200
   106.562     1.515     0.200
   106.625     2.510     0.200
   106.625     0.548     0.200
   106.707     0.380     0.200
   106.778     0.978     0.200
   106.791     1.698     0.200
   106.847     3.061     0.200
   106.933     2.517     0.200
   107.113     2.823     0.200
   107.156     1.155     0.200
   107.239     3.271     0.200
   107.222     0.914     0.200
   107.476     2.279     0.200
   107.551     2.479     0.200
   107.624     2.635     0.200
   107.666     2.174     0.200
   107.701     2.468     0.200
   107.919     1.922     0.200
   108.008     2.361     0.200
   108.035     0.745     0.200
   108.102     0.277     0.200
   108.184     0.055     0.200
   108.279     0.987     0.200
   108.356     2.379     0.200
   108.438     0.194     0.200
   108.673    -1.628     0.200
   108.780    -0.684     0.200
   108.837    -0.061     0.200
   108.844    -0.473     0.200
   108.887     0.204     0.200
   108.957     0.012     0.200
   109.488    -0.958     0.200
   109.519    -0.652     0.200
   109.575    -0.395     0.200
   110.264    -1.068     0.200
   110.217     0.735     0.200
   110.260     2.345     0.200
   110.441     2.061     0.200
   110.441     1.352     0.200
   110.441     0.280     0.200
   110.632     0.345     0.200
   110.727     0.040     0.200
   110.737     1.369     0.200
   110.825    -0.573     0.200
   110.940     1.541     0.200
   111.070     1.272     0.200
   111.588     0.693     0.200
   111.641    -0.295     0.200
   112.055     0.627     0.200
   112.177     0.611     0.200
   112.298     1.195     0.200
   112.458     3.364     0.200
   112.484     1.070     0.200
   112.734     3.276     0.200
   112.874    -0.294     0.200
   112.936    -1.184     0.200
   112.896     4.997     0.200
   112.977     2.747     0.200
   113.263    -0.906     0.200
   113.541     4.231     0.200
   113.742    -0.162     0.200
   114.362    -0.662     0.200
   114.670    -2.103     0.200
   114.800     1.834     0.200
   114.845    -0.520     0.200
   115.019     0.154     0.200
   114.901    -0.518     0.200
   115.438    -0.633     0.200
   115.868     1.773     0.200
   116.276    -0.063     0.200
   116.566    -0.781     0.200
   116.684     0.154     0.200
   118.351     2.096     0.200
   119.710     1.529     0.200
   104.592     1.599     0.200
   104.592     1.596     0.200
   100.521     0.385     0.200
   103.732     2.855     0.200
   104.596    -0.559     0.200
    99.651    -1.967     0.200
    99.692     0.093     0.200
    99.778     0.361     0.200
    99.937    -0.004     0.200
   100.054     0.090     0.200
   100.361     0.221     0.200
   100.418    -0.021     0.200
   100.592     0.012     0.200
   100.642    -0.339     0.200
   100.851    -0.237     0.200
   100.859     0.240     0.200
   100.926     0.208     0.200
   101.112     0.356     0.200
   101.134     0.109     0.200
   101.269     0.252     0.200
   101.499    -1.286     0.200
   101.759    -0.454     0.200
   103.453    -0.756     0.200
   103.853    -0.479     0.200
   105.000     0.416     0.200
   105.000    -0.490     0.200
   105.186    -0.833     0.200
   108.659     1.862     0.200
   110.994    -0.255     0.200
   100.605     0.141     0.200
   100.622     0.250     0.200
   100.980     0.041     0.200
   101.508     1.236     0.200
   104.690     0.210     0.200
   125.500    -2.449     0.200
   104.561     1.349     0.200
   104.561     1.354     0.200
   101.133    -1.607     0.200
   123.528    -0.312     0.200
   100.062    -0.562     0.200
   100.320    -0.996     0.200
   100.434     0.256     0.200
   100.434     0.521     0.200
   100.547    -0.647     0.200
   100.903    -0.425     0.200
   101.102    -0.701     0.200
   102.122    -1.392     0.200
   104.157    -0.710     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    80.741     5.249     0.200
    43.808   104.521     0.200
    50.575    78.077     0.200
    56.384    54.957     0.200
    67.493    25.281     0.200
    68.286    27.297     0.200
    68.494    24.694     0.200
    76.237    11.304     0.200
    80.534     6.273     0.200
    45.282    99.152     0.200
    45.435   101.940     0.200
    52.268    72.506     0.200
    54.985    59.592     0.200
    56.437    61.178     0.200
    57.734    54.001     0.200
    65.318    29.796     0.200
    68.802    24.664     0.200
    73.029    19.991     0.200
    75.973    13.491     0.200
    77.178    14.075     0.200
    91.794     2.929     0.200
    93.121     2.501     0.200
    95.097     3.124     0.200
    95.122     3.309     0.200
    96.000     3.706     0.200
    96.550     2.709     0.200
    96.924     2.815     0.200
    96.965     2.129     0.200
    97.169     2.907     0.200
    97.296     3.333     0.200
    97.466     2.664     0.200
    97.510     1.168     0.200
    97.724     3.593     0.200
    97.805     1.540     0.200
    97.919     2.027     0.200
    97.952     2.379     0.200
    98.170     3.897     0.200
    98.241     3.082     0.200
    98.402     2.658     0.200
    98.541     3.634     0.200
    98.584     3.240     0.200
    98.605     2.447     0.200
    98.792     2.113     0.200
    98.653     3.634     0.200
    98.651     4.943     0.200
    98.687     2.581     0.200
    98.707     4.094     0.200
    98.764     1.737     0.200
    98.870     1.763     0.200
    98.901     3.925     0.200
    99.137     2.870     0.200
    99.160     3.970     0.200
    99.213     3.431     0.200
    99.256     2.061     0.200
    99.299     4.350     0.200
    99.348     3.131     0.200
    99.520     1.865     0.200
    45.867    96.921     0.200
    64.139    31.844     0.200
    43.032   109.682     0.200
    44.150   104.675     0.200
    57.730    57.511     0.200
    65.308    29.334     0.200
    75.968    13.395     0.200
    77.175    13.565     0.200
    93.118     2.877     0.200
    93.158    -0.007     0.200
    93.158     3.192     0.200
    95.103     3.457     0.200
    95.138     3.098     0.200
    96.928     0.260     0.200
    96.968    -0.222     0.200
    97.025     5.020     0.200
    97.292     1.311     0.200
    97.503     0.561     0.200
    97.506     0.847     0.200
    97.719     1.496     0.200
    97.916     1.003     0.200
    97.949     1.354     0.200
    98.169     2.366     0.200
    98.235     0.568     0.200
    98.542     1.693     0.200
    98.592     3.268     0.200
    98.604    -0.085     0.200
    98.707     4.201     0.200
    98.763     3.203     0.200
    98.901    -0.415     0.200
    99.137     2.533     0.200
    99.160     3.427     0.200
    99.214     2.188     0.200
    99.264     3.987     0.200
    99.347     4.097     0.200
    30.939   176.948     0.200
    33.488   160.687     0.200
    45.443    99.564     0.200
    57.875    55.166     0.200
    90.856     4.980     0.200
    43.790   105.505     0.200
    63.606    34.130     0.200
    52.915    69.145     0.200
    61.299    43.802     0.200
    63.609    31.358     0.200
    31.413   172.471     0.200
    27.999   195.844     0.200
    43.951   104.701     0.200
    46.586    92.986     0.200
    68.667    24.375     0.200
    25.657   210.408     0.200
    30.706   177.775     0.200
    31.458   171.654     0.200
    34.843   151.754     0.200
    52.098    69.936     0.200
    95.506     1.701     0.200
    95.506     3.102     0.200
    31.440   172.786     0.200
    34.880   152.559     0.200
    31.411   173.431     0.200
    34.849   151.915     0.200
    50.102    77.816     0.200
    54.033    66.141     0.200
    26.860   202.475     0.200
    34.122   156.448     0.200
    97.289    -0.320     0.200
    97.289    -0.320     0.200
    52.531    65.603     0.200
    34.480   153.484     0.200
    51.521    72.854     0.200
    68.709    21.339     0.200
    81.447     5.894     0.200
    26.289   206.868     0.200
    31.479   172.132     0.200
    34.905   151.431     0.200
    34.835   151.560     0.200
    43.749   105.788     0.200
    46.077    97.152     0.200
    68.231    22.832     0.200
    80.415     6.061     0.200
    31.260   173.457     0.200
    34.697   152.629     0.200
    51.416    73.373     0.200
    61.099    41.808     0.200
    34.874   151.755     0.200
    51.431    73.720     0.200
    68.723    22.746     0.200
    44.111   103.523     0.200
    68.718    22.729     0.200
    33.036   164.500     0.200
    44.153   106.503     0.200
    46.498    98.102     0.200
    51.429    73.634     0.200
    23.673   225.064     0.200
    28.543   189.782     0.200
    32.222   169.580     0.200
    39.564   122.921     0.200
    44.120   105.793     0.200
    46.939    91.789     0.200
    52.286    66.869     0.200
    64.407    32.350     0.200
    80.882     7.747     0.200
    30.889   175.049     0.200
    34.302   154.686     0.200
    41.090   118.487     0.200
    44.333   102.813     0.200
    51.603    72.563     0.200
    51.603    72.964     0.200
    61.310    40.977     0.200
    31.066   174.586     0.200
    34.498   154.079     0.200
    30.599   177.442     0.200
    34.026   156.585     0.200
    30.853   174.379     0.200
    34.231   154.118     0.200
    25.967   208.766     0.200
    34.113   155.010     0.200
    41.243   118.173     0.200
    51.516    73.449     0.200
    52.278    73.688     0.200
    34.710   153.648     0.200
    25.747   209.688     0.200
    25.747   209.691     0.200
    27.631   196.116     0.200
    29.461   185.086     0.200
    29.461   185.045     0.200
    30.813   176.136     0.200
    31.348   173.647     0.200
    38.910   127.807     0.200
    40.726   118.707     0.200
    42.855   115.193     0.200
    53.908    63.144     0.200
    64.422    30.861     0.200
    68.326    22.559     0.200
    74.728    14.363     0.200
    79.874     5.225     0.200
    81.161     9.018     0.200
    94.687     3.799     0.200
    94.718     4.997     0.200
    95.103     3.097     0.200
    97.153     2.246     0.200
    97.504     2.798     0.200
    97.513     3.086     0.200
    97.789     3.841     0.200
    97.804     2.874     0.200
    97.959     2.766     0.200
    98.169     2.468     0.200
    98.203     2.348     0.200
    98.588     4.367     0.200
    97.220     1.213     0.200
    31.347   172.130     0.200
    31.346   172.132     0.200
    34.722   151.907     0.200
    23.543   224.353     0.200
    31.394   172.311     0.200
    31.394   172.312     0.200
    64.329    34.459     0.200
    97.779     1.036     0.200
    25.922   208.093     0.200
    29.485   183.539     0.200
    29.485   183.538     0.200
    31.348   172.555     0.200
    31.348   172.556     0.200
    34.733   151.899     0.200
    34.733   151.529     0.200
    39.738   125.688     0.200
    40.630   121.330     0.200
    40.630   121.335     0.200
    50.993    75.658     0.200
    50.993    75.659     0.200
    56.740    53.109     0.200
    64.442    31.922     0.200
    74.711    10.757     0.200
    50.966    74.968     0.200
    50.966    75.538     0.200
    25.813   206.639     0.200
    25.813   210.606     0.200
    25.813   208.099     0.200
    31.353   172.676     0.200
    34.743   152.218     0.200
    34.744   152.836     0.200
    64.365    33.043     0.200
    74.769    14.409     0.200
    25.615   212.794     0.200
    34.764   152.364     0.200
    31.323   172.551     0.200
    31.323   172.557     0.200
    34.708   152.602     0.200
    39.760   125.767     0.200
    51.017    75.543     0.200
    51.017    75.548     0.200
    51.017    75.263     0.200
    64.463    31.594     0.200
    29.734   183.439     0.200
    31.326   172.723     0.200
    34.694   152.770     0.200
    50.917    75.610     0.200
    64.658    32.362     0.200
    74.567    12.641     0.200
    90.180     5.365     0.200
    99.379    -0.214     0.200
    31.311   172.975     0.200
    31.311   172.980     0.200
    34.692   152.562     0.200
    34.692   153.568     0.200
    51.008    75.544     0.200
    51.008    75.539     0.200
    74.709    13.649     0.200
    50.996    75.089     0.200
    31.349   172.126     0.200
    31.349   172.123     0.200
    34.734   152.112     0.200
    34.735   152.104     0.200
    51.002    74.783     0.200
    51.002    74.781     0.200
    25.933   208.426     0.200
    25.933   208.226     0.200
    25.932   208.253     0.200
    27.860   194.706     0.200
    31.342   172.741     0.200
    31.342   172.740     0.200
    34.727   152.509     0.200
    34.727   151.559     0.200
    39.739   125.986     0.200
    40.636   121.303     0.200
    40.636   121.300     0.200
    51.003    75.710     0.200
    51.003    75.710     0.200
    51.003    75.000     0.200
    64.441    32.277     0.200
    68.326    22.600     0.200
    97.167     1.749     0.200
    31.293   173.133     0.200
    31.293   173.134     0.200
    34.677   152.770     0.200
    31.257   172.886     0.200
    31.256   172.884     0.200
    34.622   152.906     0.200
    34.623   152.895     0.200
    25.752   211.509     0.200
    31.327   172.812     0.200
    31.327   172.818     0.200
    34.712   152.419     0.200
    34.713   152.922     0.200
    34.713   153.372     0.200
    39.746   125.523     0.200
    40.651   121.839     0.200
    40.651   121.844     0.200
    43.870   107.438     0.200
    51.020    75.395     0.200
    51.020    75.398     0.200
    51.020    75.145     0.200
    52.214    72.701     0.200
    52.565    71.098     0.200
    68.344    24.195     0.200
    74.741    14.435     0.200
    97.168     0.589     0.200
    97.519     3.545     0.200
    97.820     3.229     0.200
    31.325   172.715     0.200
    31.326   172.712     0.200
    34.705   152.749     0.200
    31.275   173.676     0.200
    34.651   151.979     0.200
    52.336    71.040     0.200
    31.274   172.551     0.200
    34.650   152.067     0.200
    68.236    22.107     0.200
    31.319   173.301     0.200
    34.689   152.976     0.200
    34.696   151.998     0.200
    34.694   152.171     0.200
    25.874   210.648     0.200
    43.908   105.233     0.200
    46.261    97.624     0.200
    52.200    71.286     0.200
    64.402    31.988     0.200
    74.836    14.214     0.200
    79.256     9.150     0.200
    79.962     7.512     0.200
    98.264     0.735     0.200
    98.683     2.288     0.200
    24.150   219.771     0.200
    25.490   212.646     0.200
    25.607   210.156     0.200
    27.795   195.870     0.200
    29.708   183.673     0.200
    29.708   184.205     0.200
    31.333   173.128     0.200
    31.338   172.513     0.200
    34.706   152.392     0.200
    35.033   150.891     0.200
    36.844   141.262     0.200
    37.927   136.052     0.200
    39.892   124.868     0.200
    40.429   122.367     0.200
    40.647   120.784     0.200
    40.647   120.964     0.200
    43.861   105.374     0.200
    46.076    96.245     0.200
    50.912    75.347     0.200
    50.912    75.347     0.200
    51.144    74.782     0.200
    51.147    74.763     0.200
    52.335    70.089     0.200
    52.522    71.017     0.200
    53.699    65.823     0.200
    53.910    65.880     0.200
    56.810    55.469     0.200
    56.927    55.590     0.200
    74.568    12.587     0.200
    78.992     8.826     0.200
    79.787     5.286     0.200
    97.742     0.040     0.200
    97.991     0.266     0.200
    98.300     0.127     0.200
    98.333     0.591     0.200
    98.625     0.586     0.200
    98.714     0.122     0.200
    98.810     0.131     0.200
    98.986    -0.164     0.200
    99.175    -0.369     0.200
    99.352     0.126     0.200
    99.428     0.230     0.200
    25.706   210.545     0.200
    25.926   208.272     0.200
    25.926   208.374     0.200
    27.616   197.371     0.200
    27.894   194.466     0.200
    29.458   185.685     0.200
    31.378   171.690     0.200
    34.763   151.858     0.200
    34.839   152.645     0.200
    37.005   139.468     0.200
    39.374   129.080     0.200
    39.708   126.077     0.200
    40.600   121.291     0.200
    40.600   121.293     0.200
    50.967    75.585     0.200
    50.967    75.585     0.200
    52.174    71.100     0.200
    56.711    54.794     0.200
    60.690    44.091     0.200
    64.414    31.510     0.200
    74.688    11.884     0.200
    79.837     4.412     0.200
    99.048    -0.016     0.200
    31.308   173.175     0.200
    31.308   173.176     0.200
    31.308   172.356     0.200
    34.691   152.596     0.200
    34.692   152.959     0.200
    39.775   125.527     0.200
    68.356    26.060     0.200
    25.838   210.204     0.200
    31.345   172.500     0.200
    31.345   172.505     0.200
    34.737   152.401     0.200
    40.632   122.251     0.200
    40.632   122.247     0.200
    31.384   172.178     0.200
    34.778   151.781     0.200
    31.255   172.998     0.200
    31.255   172.999     0.200
    34.636   153.424     0.200
    31.405   171.298     0.200
    34.782   150.948     0.200
    39.755   125.680     0.200
    50.896    75.328     0.200
    50.896    75.324     0.200
    34.731   151.271     0.200
    31.429   172.153     0.200
    31.429   172.158     0.200
    31.291   173.116     0.200
    31.291   173.119     0.200
    34.676   152.655     0.200
    34.677   152.647     0.200
    51.053    75.190     0.200
    51.053    75.187     0.200
    25.528   213.061     0.200
    25.528   213.061     0.200
    31.324   171.479     0.200
    34.694   152.193     0.200
    34.694   152.189     0.200
    50.937    75.310     0.200
    50.937    75.314     0.200
    31.252   173.980     0.200
    51.116    76.001     0.200
    34.682   152.453     0.200
    34.683   152.446     0.200
    31.325   172.803     0.200
    31.325   172.804     0.200
    34.712   152.219     0.200
    34.713   152.211     0.200
    39.730   125.548     0.200
    40.653   120.907     0.200
    40.653   120.907     0.200
    68.355    23.451     0.200
    34.629   152.383     0.200
    31.339   172.254     0.200
    34.724   152.012     0.200
    31.434   172.481     0.200
    31.434   172.480     0.200
    34.828   150.569     0.200
    31.256   172.645     0.200
    31.256   172.646     0.200
    34.623   152.561     0.200
    50.979    75.754     0.200
    50.979    75.754     0.200
    31.287   173.101     0.200
    31.287   173.099     0.200
    34.651   152.698     0.200
    34.652   153.159     0.200
    43.927   103.840     0.200
    50.940    75.670     0.200
    50.940    75.665     0.200
    50.940    75.520     0.200
    56.824    56.714     0.200
    74.576    13.565     0.200
    79.001     8.798     0.200
    79.816     4.253     0.200
    95.305     3.279     0.200
    43.781   107.973     0.200
    52.183    71.334     0.200
    25.836   209.922     0.200
    27.913   194.370     0.200
    31.356   172.711     0.200
    31.356   172.713     0.200
    34.748   152.083     0.200
    40.621   120.967     0.200
    40.621   120.965     0.200
    50.797    75.977     0.200
    50.800    75.948     0.200
    51.034    75.396     0.200
    51.034    75.392     0.200
    51.907    73.969     0.200
    31.255   172.602     0.200
    34.621   151.925     0.200
    31.304   171.773     0.200
    34.694   151.690     0.200
    31.281   173.693     0.200
    34.644   152.726     0.200
    31.264   172.461     0.200
    31.263   172.464     0.200
    34.628   152.797     0.200
    34.628   152.789     0.200
    40.723   120.971     0.200
    40.723   120.971     0.200
    50.963    75.138     0.200
    50.963    75.132     0.200
    51.250    73.549     0.200
    51.253    73.527     0.200
    53.933    63.225     0.200
    80.585     8.070     0.200
    31.276   172.720     0.200
    34.639   153.210     0.200
    50.942    75.537     0.200
    51.706    77.356     0.200
    53.914    63.197     0.200
    25.443   212.357     0.200
    25.443   212.357     0.200
    31.269   172.945     0.200
    31.269   172.946     0.200
    34.631   152.920     0.200
    34.631   152.913     0.200
    40.011   124.691     0.200
    50.943    75.276     0.200
    50.943    75.272     0.200
    64.764    30.655     0.200
    68.291    25.306     0.200
    80.451     5.420     0.200
    80.558     5.345     0.200
    25.743   207.646     0.200
    51.162    74.676     0.200
    51.162    74.676     0.200
    64.172    36.450     0.200
    64.278    31.773     0.200
    68.709    26.449     0.200
    25.756   211.005     0.200
    31.361   171.928     0.200
    31.361   171.929     0.200
    34.748   151.693     0.200
    50.913    75.672     0.200
    50.913    75.672     0.200
    31.371   172.409     0.200
    31.371   172.411     0.200
    34.757   152.254     0.200
    39.374   128.411     0.200
    40.607   123.012     0.200
    46.149    96.782     0.200
    80.488     6.877     0.200
    25.583   211.981     0.200
    25.583   211.989     0.200
    27.751   200.243     0.200
    27.798   195.182     0.200
    27.798   195.799     0.200
    31.293   172.890     0.200
    31.293   172.892     0.200
    31.293   172.446     0.200
    34.665   152.851     0.200
    34.666   152.844     0.200
    34.666   152.375     0.200
    35.079   153.603     0.200
    52.344    69.303     0.200
    68.316    25.012     0.200
    74.648    15.615     0.200
    80.631     5.226     0.200
    80.946     5.541     0.200
    51.257    75.190     0.200
    51.257    75.194     0.200
    40.688   121.320     0.200
    65.866    28.275     0.200
    65.866    28.005     0.200
    34.705   152.350     0.200
    50.874    76.338     0.200
    50.874    76.338     0.200
    50.785    75.680     0.200
    34.693   151.760     0.200
    79.602     8.320     0.200
    31.294   171.824     0.200
    34.674   153.522     0.200
    64.531    31.198     0.200
    50.947    75.948     0.200
    50.947    75.948     0.200
    51.013    75.501     0.200
    51.013    75.502     0.200
    51.013    74.841     0.200
    56.889    54.810     0.200
    56.889    55.080     0.200
    31.320   172.125     0.200
    34.708   152.329     0.200
    51.039    75.122     0.200
    34.874   152.504     0.200
    31.428   172.183     0.200
    34.824   151.402     0.200
    25.819   210.208     0.200
    51.849    75.844     0.200
    31.226   173.001     0.200
    31.226   173.000     0.200
    34.589   152.709     0.200
    34.590   152.702     0.200
    50.992    75.372     0.200
    50.992    75.372     0.200
    25.756   210.865     0.200
    25.756   210.865     0.200
    34.855   152.001     0.200
    34.855   151.994     0.200
    25.884   209.609     0.200
    25.884   209.609     0.200
    25.884   209.149     0.200
    25.980   209.395     0.200
    34.804   151.545     0.200
    34.805   151.546     0.200
    40.570   121.054     0.200
    40.570   121.054     0.200
    68.326    22.964     0.200
    31.338   172.287     0.200
    31.338   172.293     0.200
    34.725   152.431     0.200
    34.725   152.423     0.200
    39.720   126.360     0.200
    25.716   209.015     0.200
    25.716   209.014     0.200
    27.642   196.804     0.200
    27.699   196.294     0.200
    27.868   194.434     0.200
    31.353   172.031     0.200
    31.353   172.027     0.200
    34.737   151.911     0.200
    34.738   151.904     0.200
    50.989    75.284     0.200
    50.989    75.279     0.200
    52.199    69.854     0.200
    64.438    32.569     0.200
    25.795   210.699     0.200
    25.795   208.387     0.200
    27.998   193.761     0.200
    31.439   171.908     0.200
    31.439   171.408     0.200
    34.832   151.862     0.200
    34.832   151.190     0.200
    40.538   121.446     0.200
    64.266    32.579     0.200
    74.718    10.725     0.200
    74.718    14.327     0.200
    97.518     0.333     0.200
    34.706   152.374     0.200
    50.909    75.455     0.200
    34.718   151.828     0.200
    34.767   151.607     0.200
    25.829   209.920     0.200
    50.921    75.176     0.200
    25.790   209.338     0.200
    27.644   196.145     0.200
    27.769   195.902     0.200
    29.461   184.455     0.200
    31.319   172.536     0.200
    34.707   152.038     0.200
    36.505   144.702     0.200
    40.659   121.010     0.200
    43.801   106.091     0.200
    43.879   105.271     0.200
    51.041    75.589     0.200
    51.896    74.662     0.200
    52.205    71.255     0.200
    64.427    33.445     0.200
    80.546     8.796     0.200
    31.391   172.046     0.200
    34.773   151.491     0.200
    25.771   210.783     0.200
    31.320   172.051     0.200
    34.707   152.331     0.200
    40.658   120.616     0.200
    51.033    75.233     0.200
    64.440    30.991     0.200
    25.724   210.796     0.200
    31.365   172.123     0.200
    34.751   152.079     0.200
    39.713   125.968     0.200
    50.983    75.611     0.200
    31.348   172.118     0.200
    34.734   151.576     0.200
    25.942   207.466     0.200
    34.662   152.002     0.200
    31.323   172.173     0.200
    34.707   152.288     0.200
    40.655   121.040     0.200
    51.015    75.062     0.200
    50.945    75.661     0.200
    31.306   172.067     0.200
    34.670   152.058     0.200
    34.718   151.838     0.200
    31.312   172.336     0.200
    34.698   152.312     0.200
    39.764   125.518     0.200
    51.031    75.125     0.200
    25.747   210.436     0.200
    31.346   172.830     0.200
    34.732   152.531     0.200
    39.724   126.388     0.200
    40.632   121.261     0.200
    51.005    76.002     0.200
    31.347   171.843     0.200
    34.732   151.986     0.200
    34.721   152.186     0.200
    50.863    75.823     0.200
    31.306   172.588     0.200
    34.675   152.020     0.200
    50.941    75.471     0.200
    31.246   172.042     0.200
    34.625   152.288     0.200
    51.395    73.820     0.200
    52.098    73.625     0.200
    34.741   152.182     0.200
    34.678   152.182     0.200
    51.027    75.152     0.200
    26.190   206.393     0.200
    31.092   173.318     0.200
    34.497   153.362     0.200
    40.885   119.360     0.200
    51.358    73.964     0.200
    34.728   151.567     0.200
    51.003    75.301     0.200
    23.243   225.028     0.200
    26.651   202.956     0.200
    26.651   203.081     0.200
    30.891   175.013     0.200
    30.891   175.138     0.200
    34.317   154.494     0.200
    34.888   149.350     0.200
    37.111   140.049     0.200
    41.094   118.339     0.200
    51.686    71.990     0.200
    51.686    72.272     0.200
    51.877    71.394     0.200
    52.093    71.548     0.200
    52.641    70.803     0.200
    53.761    65.737     0.200
    54.491    61.022     0.200
    57.717    51.651     0.200
    61.383    40.956     0.200
    69.057    21.940     0.200
    74.067    12.472     0.200
    99.296     0.079     0.200
    34.135   155.331     0.200
    34.135   155.722     0.200
    51.512    73.564     0.200
    51.512    72.685     0.200
    31.319   172.250     0.200
    34.707   151.729     0.200
    34.707   152.702     0.200
    51.042    75.563     0.200
    51.042    75.786     0.200
    31.207   173.195     0.200
    34.644   153.105     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
