#!/bin/bash
gmt begin bohol1.86_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times bohol1.86'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.246
    25.500   327.788
    26.000   332.320
    26.500   336.840
    27.000   341.348
    27.500   345.839
    28.000   350.310
    28.500   354.766
    29.000   359.211
    29.500   363.647
    30.000   368.075
    30.500   372.496
    31.000   376.909
    31.500   381.314
    32.000   385.711
    32.500   390.098
    33.000   394.475
    33.500   398.839
    34.000   403.189
    34.500   407.524
    35.000   411.843
    35.500   416.148
    36.000   420.438
    36.500   424.712
    37.000   428.971
    37.500   433.215
    38.000   437.442
    38.500   441.653
    39.000   445.848
    39.500   450.026
    40.000   454.187
    40.500   458.330
    41.000   462.457
    41.500   466.567
    42.000   470.659
    42.500   474.734
    43.000   478.792
    43.500   482.833
    44.000   486.855
    44.500   490.860
    45.000   494.847
    45.500   498.816
    46.000   502.767
    46.500   506.700
    47.000   510.615
    47.500   514.512
    48.000   518.391
    48.500   522.251
    49.000   526.094
    49.500   529.918
    50.000   533.724
    50.500   537.511
    51.000   541.281
    51.500   545.032
    52.000   548.765
    52.500   552.480
    53.000   556.178
    53.500   559.857
    54.000   563.519
    54.500   567.162
    55.000   570.787
    55.500   574.393
    56.000   577.981
    56.500   581.550
    57.000   585.101
    57.500   588.634
    58.000   592.149
    58.500   595.645
    59.000   599.124
    59.500   602.584
    60.000   606.026
    60.500   609.449
    61.000   612.854
    61.500   616.241
    62.000   619.610
    62.500   622.960
    63.000   626.292
    63.500   629.607
    64.000   632.904
    64.500   636.182
    65.000   639.443
    65.500   642.686
    66.000   645.911
    66.500   649.118
    67.000   652.307
    67.500   655.477
    68.000   658.630
    68.500   661.764
    69.000   664.880
    69.500   667.978
    70.000   671.058
    70.500   674.120
    71.000   677.163
    71.500   680.189
    72.000   683.196
    72.500   686.185
    73.000   689.156
    73.500   692.108
    74.000   695.041
    74.500   697.956
    75.000   700.852
    75.500   703.729
    76.000   706.588
    76.500   709.429
    77.000   712.252
    77.500   715.057
    78.000   717.844
    78.500   720.612
    79.000   723.363
    79.500   726.095
    80.000   728.808
    80.500   731.502
    81.000   734.177
    81.500   736.833
    82.000   739.469
    82.500   742.087
    83.000   744.686
    83.500   747.266
    84.000   749.827
    84.500   752.368
    85.000   754.887
    85.500   757.387
    86.000   759.869
    86.500   762.333
    87.000   764.779
    87.500   767.201
    88.000   769.590
    88.500   771.956
    89.000   774.310
    89.500   776.655
    90.000   778.993
    90.500   781.324
    91.000   783.649
    91.500   785.968
    92.000   788.283
    92.500   790.594
    93.000   792.901
    93.500   795.204
    94.000   797.504
    94.500   799.800
    95.000   802.090
    95.500   804.375
    96.000   806.652
    96.500   808.924
    97.000   811.189
    97.500   813.448
    98.000   815.699
    98.500   817.943
    99.000   820.179
    99.500   822.408
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.408
   116.000  1122.370
   116.500  1123.332
   117.000  1124.294
   117.500  1125.256
   118.000  1126.218
   118.500  1127.180
   119.000  1128.141
   119.500  1129.103
   120.000  1130.064
   120.500  1131.025
   121.000  1131.986
   121.500  1132.947
   122.000  1133.907
   122.500  1134.867
   123.000  1135.826
   123.500  1136.785
   124.000  1137.744
   124.500  1138.702
   125.000  1139.660
   125.500  1140.617
   126.000  1141.574
   126.500  1142.529
   127.000  1143.485
   127.500  1144.439
   128.000  1145.393
   128.500  1146.345
   129.000  1147.297
   129.500  1148.248
   130.000  1149.198
   130.500  1150.147
   131.000  1151.094
   131.500  1152.041
   132.000  1152.986
   132.500  1153.930
   133.000  1154.872
   133.500  1155.812
   134.000  1156.751
   134.500  1157.688
   135.000  1158.623
   135.500  1159.557
   136.000  1160.488
   136.500  1161.417
   137.000  1162.343
   137.500  1163.267
   138.000  1164.188
   138.500  1165.107
   139.000  1166.023
   139.500  1166.935
   140.000  1167.845
   140.500  1168.751
   141.000  1169.653
   141.500  1170.552
   142.000  1171.447
   142.500  1172.337
   143.000  1173.223
   143.500  1174.104
   144.000  1174.980
   144.500  1175.851
   145.000  1176.717
   145.500  1177.577
   146.000  1178.431
   146.500  1179.278
   147.000  1180.119
   147.500  1180.954
   148.000  1181.781
   148.500  1182.600
   149.000  1183.412
   149.500  1184.214
   150.000  1185.007
   150.500  1185.791
   151.000  1186.564
   151.500  1187.327
   152.000  1188.081
   152.500  1188.824
   153.000  1189.557
   153.500  1190.280
   154.000  1190.993
   154.500  1191.694
   155.000  1192.385
   155.500  1193.063
   156.000  1193.731
   156.500  1194.386
   157.000  1195.030
   157.500  1195.661
   158.000  1196.280
   158.500  1196.887
   159.000  1197.481
   159.500  1198.062
   160.000  1198.631
   160.500  1199.186
   161.000  1199.729
   161.500  1200.258
   162.000  1200.774
   162.500  1201.277
   163.000  1201.766
   163.500  1202.242
   164.000  1202.705
   164.500  1203.153
   165.000  1203.587
   165.500  1204.008
   166.000  1204.415
   166.500  1204.808
   167.000  1205.187
   167.500  1205.552
   168.000  1205.903
   168.500  1206.240
   169.000  1206.563
   169.500  1206.872
   170.000  1207.166
   170.500  1207.447
   171.000  1207.713
   171.500  1207.964
   172.000  1208.202
   172.500  1208.425
   173.000  1208.634
   173.500  1208.829
   174.000  1209.009
   174.500  1209.175
   175.000  1209.326
   175.500  1209.463
   176.000  1209.586
   176.500  1209.694
   177.000  1209.788
   177.500  1209.867
   178.000  1209.932
   178.500  1209.983
   179.000  1210.019
   179.500  1210.041
   180.000  1210.048
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   992.346
     1.000   992.355
     1.500   992.369
     2.000   992.388
     2.500   992.414
     3.000   992.444
     3.500   992.481
     4.000   992.523
     4.500   992.570
     5.000   992.623
     5.500   992.682
     6.000   992.746
     6.500   992.816
     7.000   992.892
     7.500   992.973
     8.000   993.059
     8.500   993.152
     9.000   993.249
     9.500   993.353
    10.000   993.462
    10.500   993.576
    11.000   993.696
    11.500   993.822
    12.000   993.953
    12.500   994.089
    13.000   994.232
    13.500   994.379
    14.000   994.533
    14.500   994.691
    15.000   994.856
    15.500   995.025
    16.000   995.201
    16.500   995.381
    17.000   995.568
    17.500   995.759
    18.000   995.957
    18.500   996.159
    19.000   996.367
    19.500   996.581
    20.000   996.800
    20.500   997.025
    21.000   997.255
    21.500   997.490
    22.000   997.731
    22.500   997.977
    23.000   998.229
    23.500   998.486
    24.000   998.748
    24.500   999.016
    25.000   999.289
    25.500   999.567
    26.000   999.851
    26.500  1000.140
    27.000  1000.435
    27.500  1000.735
    28.000  1001.040
    28.500  1001.350
    29.000  1001.666
    29.500  1001.987
    30.000  1002.313
    30.500  1002.645
    31.000  1002.981
    31.500  1003.323
    32.000  1003.671
    32.500  1004.023
    33.000  1004.381
    33.500  1004.743
    34.000  1005.111
    34.500  1005.484
    35.000  1005.863
    35.500  1006.246
    36.000  1006.635
    36.500  1007.028
    37.000  1007.427
    37.500  1007.831
    38.000  1008.240
    38.500  1008.654
    39.000  1009.073
    39.500  1009.497
    40.000  1009.926
    40.500  1010.359
    41.000  1010.799
    41.500  1011.242
    42.000  1011.691
    42.500  1012.145
    43.000  1012.604
    43.500  1013.068
    44.000  1013.536
    44.500  1014.010
    45.000  1014.488
    45.500  1014.971
    46.000  1015.459
    46.500  1015.952
    47.000  1016.450
    47.500  1016.952
    48.000  1017.459
    48.500  1017.971
    49.000  1018.488
    49.500  1019.009
    50.000  1019.536
    50.500  1020.066
    51.000  1020.602
    51.500  1021.142
    52.000  1021.687
    52.500  1022.236
    53.000  1022.790
    53.500  1023.348
    54.000  1023.912
    54.500  1024.479
    55.000  1025.051
    55.500  1025.628
    56.000  1026.209
    56.500  1026.795
    57.000  1027.385
    57.500  1027.979
    58.000  1028.578
    58.500  1029.182
    59.000  1029.790
    59.500  1030.401
    60.000  1031.018
    60.500  1031.639
    61.000  1032.264
    61.500  1032.893
    62.000  1033.527
    62.500  1034.164
    63.000  1034.807
    63.500  1035.453
    64.000  1036.103
    64.500  1036.758
    65.000  1037.417
    65.500  1038.079
    66.000  1038.746
    66.500  1039.417
    67.000  1040.093
    67.500  1040.772
    68.000  1041.455
    68.500  1042.142
    69.000  1042.833
    69.500  1043.528
    70.000  1044.227
    70.500  1044.930
    71.000  1045.637
    71.500  1046.348
    72.000  1047.063
    72.500  1047.781
    73.000  1048.503
    73.500  1049.229
    74.000  1049.959
    74.500  1050.693
    75.000  1051.430
    75.500  1052.171
    76.000  1052.915
    76.500  1053.664
    77.000  1054.416
    77.500  1055.171
    78.000  1055.930
    78.500  1056.693
    79.000  1057.459
    79.500  1058.229
    80.000  1059.002
    80.500  1059.779
    81.000  1060.559
    81.500  1061.343
    82.000  1062.130
    82.500  1062.920
    83.000  1063.714
    83.500  1064.511
    84.000  1065.312
    84.500  1066.115
    85.000  1066.922
    85.500  1067.733
    86.000  1068.546
    86.500  1069.363
    87.000  1070.183
    87.500  1071.006
    88.000  1071.832
    88.500  1072.661
    89.000  1073.494
    89.500  1074.329
    90.000  1075.168
    90.500  1076.009
    91.000  1076.854
    91.500  1077.701
    92.000  1078.552
    92.500  1079.405
    93.000  1080.261
    93.500  1081.120
    94.000  1081.982
    94.500  1082.847
    95.000  1083.715
    95.500  1084.585
    96.000  1085.458
    96.500  1086.334
    97.000  1087.213
    97.500  1088.094
    98.000  1088.978
    98.500  1089.865
    99.000  1090.754
    99.500  1091.646
   100.000  1092.540
   100.500  1093.437
   101.000  1094.337
   101.500  1095.238
   102.000  1096.143
   102.500  1097.050
   103.000  1097.959
   103.500  1098.871
   104.000  1099.785
   104.500  1100.701
   105.000  1101.620
   105.500  1102.541
   106.000  1103.464
   106.500  1104.390
   107.000  1105.318
   107.500  1106.248
   108.000  1107.180
   108.500  1108.114
   109.000  1109.051
   109.500  1109.989
   110.000  1110.930
   110.500  1111.873
   111.000  1112.817
   111.500  1113.764
   112.000  1114.713
   112.500  1115.664
   113.000  1116.616
   113.500  1117.571
   114.000  1118.527
   114.500  1119.486
   115.000  1120.446
   115.500  1121.408
   116.000  1122.372
   116.500  1123.338
   117.000  1124.305
   117.500  1125.274
   118.000  1126.245
   118.500  1127.217
   119.000  1128.191
   119.500  1129.167
   120.000  1130.144
   120.500  1131.123
   121.000  1132.104
   121.500  1133.086
   122.000  1134.069
   122.500  1135.054
   123.000  1136.041
   123.500  1137.029
   124.000  1138.018
   124.500  1139.009
   125.000  1140.001
   125.500  1140.994
   126.000  1141.989
   126.500  1142.985
   127.000  1143.982
   127.500  1144.981
   128.000  1145.981
   128.500  1146.982
   129.000  1147.984
   129.500  1148.987
   130.000  1149.992
   130.500  1150.997
   131.000  1152.004
   131.500  1153.012
   132.000  1154.021
   132.500  1155.030
   133.000  1156.041
   133.500  1157.053
   134.000  1158.066
   134.500  1159.079
   135.000  1160.094
   135.500  1161.109
   136.000  1162.125
   136.500  1163.143
   137.000  1164.161
   137.500  1165.179
   138.000  1166.199
   138.500  1167.219
   139.000  1168.240
   139.500  1169.261
   140.000  1170.284
   140.500  1171.307
   141.000  1172.330
   141.500  1173.355
   142.000  1174.380
   142.500  1175.405
   143.000  1176.431
   143.500  1177.457
   144.000  1178.484
   144.500  1179.512
   145.000  1180.540
   145.500  1181.568
   146.000  1182.596
   146.500  1183.626
   147.000  1184.655
   147.500  1185.685
   148.000  1186.715
   148.500  1187.746
   149.000  1188.776
   149.500  1189.807
   150.000  1190.839
   150.500  1191.870
   151.000  1192.902
   151.500  1193.934
   152.000  1194.966
   152.500  1195.998
   153.000  1197.031
   153.500  1198.063
   154.000  1199.095
   154.500  1200.128
   155.000  1201.161
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.037
   145.500  1177.861
   146.000  1179.742
   146.500  1181.660
   147.000  1183.605
   147.500  1185.573
   148.000  1187.562
   148.500  1189.568
   149.000  1191.589
   149.500  1193.625
   150.000  1195.672
   150.500  1197.732
   151.000  1199.802
   151.500  1201.882
   152.000  1203.971
   152.500  1206.068
   153.000  1208.172
   153.500  1210.285
   154.000  1212.404
   154.500  1214.530
   155.000  1216.662
   155.500  1218.799
   156.000  1220.942
   156.500  1223.090
   157.000  1225.242
   157.500  1227.399
   158.000  1229.560
   158.500  1231.726
   159.000  1233.895
   159.500  1236.068
   160.000  1238.244
   160.500  1240.424
   161.000  1242.607
   161.500  1244.792
   162.000  1246.980
   162.500  1249.171
   163.000  1251.364
   163.500  1253.560
   164.000  1255.757
   164.500  1257.957
   165.000  1260.158
   165.500  1262.362
   166.000  1264.567
   166.500  1266.774
   167.000  1268.982
   167.500  1271.192
   168.000  1273.402
   168.500  1275.615
   169.000  1277.828
   169.500  1280.043
   170.000  1282.258
   170.500  1284.474
   171.000  1286.692
   171.500  1288.910
   172.000  1291.129
   172.500  1293.348
   173.000  1295.568
   173.500  1297.788
   174.000  1300.009
   174.500  1302.231
   175.000  1304.453
   175.500  1306.675
   176.000  1308.897
   176.500  1311.120
   177.000  1313.342
   177.500  1315.565
   178.000  1317.788
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.033
   145.500  1177.658
   146.000  1179.205
   146.500  1180.694
   147.000  1182.133
   147.500  1183.527
   148.000  1184.879
   148.500  1186.190
   149.000  1187.467
   149.500  1188.716
   150.000  1189.939
   150.500  1191.139
   151.000  1192.319
   151.500  1193.479
   152.000  1194.621
   152.500  1195.746
   153.000  1196.855
   153.500  1197.949
   154.000  1199.030
   154.500  1200.098
   155.000  1201.153
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   509.222
     1.000   509.258
     1.500   509.318
     2.000   509.402
     2.500   509.510
     3.000   509.642
     3.500   509.798
     4.000   509.978
     4.500   510.182
     5.000   510.409
     5.500   510.660
     6.000   510.935
     6.500   511.234
     7.000   511.557
     7.500   511.903
     8.000   512.272
     8.500   512.665
     9.000   513.081
     9.500   513.521
    10.000   513.983
    10.500   514.469
    11.000   514.978
    11.500   515.510
    12.000   516.064
    12.500   516.642
    13.000   517.242
    13.500   517.864
    14.000   518.509
    14.500   519.176
    15.000   519.865
    15.500   520.576
    16.000   521.310
    16.500   522.064
    17.000   522.841
    17.500   523.639
    18.000   524.458
    18.500   525.299
    19.000   526.161
    19.500   527.043
    20.000   527.947
    20.500   528.871
    21.000   529.815
    21.500   530.780
    22.000   531.765
    22.500   532.770
    23.000   533.794
    23.500   534.839
    24.000   535.903
    24.500   536.986
    25.000   538.088
    25.500   539.209
    26.000   540.349
    26.500   541.508
    27.000   542.685
    27.500   543.881
    28.000   545.094
    28.500   546.326
    29.000   547.575
    29.500   548.841
    30.000   550.125
    30.500   551.427
    31.000   552.745
    31.500   554.080
    32.000   555.432
    32.500   556.800
    33.000   558.184
    33.500   559.585
    34.000   561.001
    34.500   562.433
    35.000   563.880
    35.500   565.343
    36.000   566.821
    36.500   568.314
    37.000   569.822
    37.500   571.344
    38.000   572.881
    38.500   574.432
    39.000   575.997
    39.500   577.575
    40.000   579.168
    40.500   580.774
    41.000   582.393
    41.500   584.025
    42.000   585.670
    42.500   587.328
    43.000   588.998
    43.500   590.681
    44.000   592.376
    44.500   594.083
    45.000   595.802
    45.500   597.532
    46.000   599.274
    46.500   601.028
    47.000   602.792
    47.500   604.568
    48.000   606.354
    48.500   608.151
    49.000   609.958
    49.500   611.776
    50.000   613.603
    50.500   615.441
    51.000   617.288
    51.500   619.145
    52.000   621.012
    52.500   622.888
    53.000   624.773
    53.500   626.667
    54.000   628.570
    54.500   630.481
    55.000   632.401
    55.500   634.329
    56.000   636.266
    56.500   638.211
    57.000   640.163
    57.500   642.123
    58.000   644.091
    58.500   646.067
    59.000   648.049
    59.500   650.039
    60.000   652.036
    60.500   654.040
    61.000   656.051
    61.500   658.068
    62.000   660.092
    62.500   662.122
    63.000   664.158
    63.500   666.201
    64.000   668.249
    64.500   670.303
    65.000   672.363
    65.500   674.429
    66.000   676.500
    66.500   678.576
    67.000   680.658
    67.500   682.745
    68.000   684.836
    68.500   686.933
    69.000   689.034
    69.500   691.140
    70.000   693.250
    70.500   695.365
    71.000   697.484
    71.500   699.607
    72.000   701.734
    72.500   703.866
    73.000   706.001
    73.500   708.140
    74.000   710.282
    74.500   712.428
    75.000   714.578
    75.500   716.731
    76.000   718.887
    76.500   721.047
    77.000   723.209
    77.500   725.374
    78.000   727.543
    78.500   729.714
    79.000   731.888
    79.500   734.064
    80.000   736.243
    80.500   738.424
    81.000   740.608
    81.500   742.794
    82.000   744.982
    82.500   747.172
    83.000   749.365
    83.500   751.559
    84.000   753.755
    84.500   755.953
    85.000   758.153
    85.500   760.355
    86.000   762.558
    86.500   764.762
    87.000   766.968
    87.500   769.175
    88.000   771.384
    88.500   773.594
    89.000   775.805
    89.500   778.017
    90.000   780.231
    90.500   782.445
    91.000   784.660
    91.500   786.876
    92.000   789.093
    92.500   791.311
    93.000   793.529
    93.500   795.748
    94.000   797.968
    94.500   800.188
    95.000   802.409
    95.500   804.630
    96.000   806.851
    96.500   809.073
    97.000   811.295
    97.500   813.517
    98.000   815.740
    98.500   817.963
    99.000   820.185
    99.500   822.408
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.125
    29.000   424.682
    29.500   430.239
    30.000   435.795
    30.500   441.350
    31.000   446.904
    31.500   452.456
    32.000   458.005
    32.500   463.553
    33.000   469.097
    33.500   474.638
    34.000   480.175
    34.500   485.708
    35.000   491.237
    35.500   496.760
    36.000   502.278
    36.500   507.790
    37.000   513.295
    37.500   518.793
    38.000   524.283
    38.500   529.765
    39.000   535.238
    39.500   540.702
    40.000   546.155
    40.500   551.598
    41.000   557.030
    41.500   562.450
    42.000   567.858
    42.500   573.253
    43.000   578.634
    43.500   584.002
    44.000   589.355
    44.500   594.693
    45.000   600.016
    45.500   605.324
    46.000   610.615
    46.500   615.889
    47.000   621.147
    47.500   625.867
    48.000   630.438
    48.500   635.004
    49.000   639.565
    49.500   644.122
    50.000   648.673
    50.500   653.219
    51.000   657.760
    51.500   662.295
    52.000   666.825
    52.500   671.349
    53.000   675.867
    53.500   680.379
    54.000   684.884
    54.500   689.381
    55.000   693.869
    55.500   698.347
    56.000   702.814
    56.500   707.274
    57.000   711.727
    57.500   716.175
    58.000   720.619
    58.500   725.057
    59.000   729.492
    59.500   733.922
    60.000   738.349
    60.500   742.772
    61.000   747.191
    61.500   751.607
    62.000   756.018
    62.500   760.426
    63.000   764.829
    63.500   769.229
    64.000   773.624
    64.500   778.015
    65.000   782.400
    65.500   786.781
    66.000   791.155
    66.500   795.523
    67.000   799.885
    67.500   804.240
    68.000   808.587
    68.500   812.927
    69.000   817.259
    69.500   821.583
    70.000   825.901
    70.500   830.210
    71.000   834.512
    71.500   838.807
    72.000   843.094
    72.500   847.373
    73.000   851.644
    73.500   855.908
    74.000   860.164
    74.500   864.413
    75.000   868.653
    75.500   872.886
    76.000   877.110
    76.500   881.326
    77.000   885.535
    77.500   889.734
    78.000   893.926
    78.500   898.109
    79.000   902.284
    79.500   906.450
    80.000   910.607
    80.500   914.756
    81.000   918.897
    81.500   923.029
    82.000   927.152
    82.500   931.267
    83.000   935.373
    83.500   939.471
    84.000   943.561
    84.500   947.641
    85.000   951.713
    85.500   955.777
    86.000   959.831
    86.500   963.877
    87.000   967.914
    87.500   971.942
    88.000   975.961
    88.500   979.972
    89.000   983.973
    89.500   987.966
    90.000   991.949
    90.500   995.924
    91.000   999.889
    91.500  1003.846
    92.000  1007.793
    92.500  1011.732
    93.000  1015.661
    93.500  1019.582
    94.000  1023.493
    94.500  1027.396
    95.000  1031.289
    95.500  1035.174
    96.000  1039.049
    96.500  1042.915
    97.000  1046.772
    97.500  1050.620
    98.000  1054.459
    98.500  1058.289
    99.000  1062.110
    99.500  1065.921
   100.000  1069.724
   100.500  1073.517
   101.000  1077.301
   101.500  1081.076
   102.000  1084.842
   102.500  1088.598
   103.000  1092.346
   103.500  1096.084
   104.000  1099.814
   104.500  1103.535
   105.000  1107.246
   105.500  1110.949
   106.000  1114.644
   106.500  1118.329
   107.000  1122.005
   107.500  1125.672
   108.000  1129.330
   108.500  1132.979
   109.000  1136.618
   109.500  1140.248
   110.000  1143.870
   110.500  1147.481
   111.000  1151.084
   111.500  1154.677
   112.000  1158.261
   112.500  1161.836
   113.000  1165.402
   113.500  1168.958
   114.000  1172.506
   114.500  1176.044
   115.000  1179.573
   115.500  1183.093
   116.000  1186.605
   116.500  1190.107
   117.000  1193.600
   117.500  1197.084
   118.000  1200.559
   118.500  1204.024
   119.000  1207.481
   119.500  1210.928
   120.000  1214.367
   120.500  1217.796
   121.000  1221.215
   121.500  1224.626
   122.000  1228.027
   122.500  1231.419
   123.000  1234.802
   123.500  1238.176
   124.000  1241.541
   124.500  1244.897
   125.000  1248.243
   125.500  1251.581
   126.000  1254.910
   126.500  1258.230
   127.000  1261.541
   127.500  1264.843
   128.000  1268.136
   128.500  1271.420
   129.000  1274.695
   129.500  1277.961
   130.000  1281.219
   130.500  1284.467
   131.000  1287.706
   131.500  1290.936
   132.000  1294.158
   132.500  1297.370
   133.000  1300.573
   133.500  1303.767
   134.000  1306.952
   134.500  1310.128
   135.000  1313.295
   135.500  1316.453
   136.000  1319.601
   136.500  1322.741
   137.000  1325.871
   137.500  1328.993
   138.000  1332.105
   138.500  1335.209
   139.000  1338.303
   139.500  1341.388
   140.000  1344.464
   140.500  1347.531
   141.000  1350.589
   141.500  1353.638
   142.000  1356.678
   142.500  1359.708
   143.000  1362.730
   143.500  1365.743
   144.000  1368.746
   144.500  1371.741
   145.000  1374.726
   145.500  1377.702
   146.000  1380.669
   146.500  1383.627
   147.000  1386.575
   147.500  1389.514
   148.000  1392.444
   148.500  1395.364
   149.000  1398.274
   149.500  1401.176
   150.000  1404.068
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.631
   100.500   826.854
   101.000   829.077
   101.500   831.299
   102.000   833.522
   102.500   835.745
   103.000   837.968
   103.500   840.191
   104.000   842.414
   104.500   844.636
   105.000   846.859
   105.500   849.082
   106.000   851.305
   106.500   853.528
   107.000   855.751
   107.500   857.973
   108.000   860.196
   108.500   862.419
   109.000   864.642
   109.500   866.865
   110.000   869.088
   110.500   871.310
   111.000   873.533
   111.500   875.756
   112.000   877.979
   112.500   880.202
   113.000   882.425
   113.500   884.647
   114.000   886.870
   114.500   889.093
   115.000   891.316
   115.500   893.539
   116.000   895.762
   116.500   897.984
   117.000   900.207
   117.500   902.430
   118.000   904.653
   118.500   906.876
   119.000   909.099
   119.500   911.322
   120.000   913.544
   120.500   915.767
   121.000   917.990
   121.500   920.213
   122.000   922.436
   122.500   924.659
   123.000   926.881
   123.500   929.104
   124.000   931.327
   124.500   933.550
   125.000   935.773
   125.500   937.996
   126.000   940.218
   126.500   942.441
   127.000   944.664
   127.500   946.887
   128.000   949.110
   128.500   951.333
   129.000   953.555
   129.500   955.778
   130.000   958.001
   130.500   960.224
   131.000   962.447
   131.500   964.669
   132.000   966.892
   132.500   969.115
   133.000   971.338
   133.500   973.561
   134.000   975.784
   134.500   978.007
   135.000   980.229
   135.500   982.452
   136.000   984.675
   136.500   986.898
   137.000   989.121
   137.500   991.344
   138.000   993.566
   138.500   995.789
   139.000   998.012
   139.500  1000.235
   140.000  1002.458
   140.500  1004.681
   141.000  1006.903
   141.500  1009.126
   142.000  1011.349
   142.500  1013.572
   143.000  1015.795
   143.500  1018.018
   144.000  1020.240
   144.500  1022.463
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.754
    15.000   394.992
    15.500   405.226
    16.000   415.454
    16.500   425.671
    17.000   435.873
    17.500   446.057
    18.000   456.218
    18.500   466.350
    19.000   476.448
    19.500   486.507
    20.000   496.519
    20.500   506.480
    21.000   516.383
    21.500   526.223
    22.000   535.995
    22.500   545.693
    23.000   554.304
    23.500   562.445
    24.000   570.553
    24.500   578.628
    25.000   586.659
    25.500   594.610
    26.000   602.521
    26.500   610.421
    27.000   618.312
    27.500   626.195
    28.000   634.072
    28.500   641.943
    29.000   649.806
    29.500   657.663
    30.000   665.513
    30.500   673.354
    31.000   681.186
    31.500   689.006
    32.000   696.814
    32.500   704.607
    33.000   712.385
    33.500   720.146
    34.000   727.889
    34.500   735.614
    35.000   743.320
    35.500   751.006
    36.000   758.672
    36.500   766.319
    37.000   773.945
    37.500   781.550
    38.000   789.135
    38.500   796.697
    39.000   804.238
    39.500   811.756
    40.000   819.251
    40.500   826.724
    41.000   834.172
    41.500   841.597
    42.000   848.999
    42.500   856.376
    43.000   863.728
    43.500   871.057
    44.000   878.360
    44.500   885.638
    45.000   892.892
    45.500   900.120
    46.000   907.322
    46.500   914.499
    47.000   921.649
    47.500   928.773
    48.000   935.871
    48.500   942.941
    49.000   949.985
    49.500   957.002
    50.000   963.991
    50.500   970.954
    51.000   977.889
    51.500   984.797
    52.000   991.677
    52.500   998.530
    53.000  1005.355
    53.500  1012.154
    54.000  1018.928
    54.500  1025.675
    55.000  1032.396
    55.500  1039.089
    56.000  1045.755
    56.500  1052.394
    57.000  1059.004
    57.500  1065.586
    58.000  1072.140
    58.500  1078.666
    59.000  1085.164
    59.500  1091.635
    60.000  1098.079
    60.500  1104.494
    61.000  1110.882
    61.500  1117.241
    62.000  1123.573
    62.500  1129.876
    63.000  1136.150
    63.500  1142.396
    64.000  1148.614
    64.500  1154.803
    65.000  1160.964
    65.500  1167.097
    66.000  1173.201
    66.500  1179.278
    67.000  1185.326
    67.500  1191.345
    68.000  1197.336
    68.500  1203.298
    69.000  1209.232
    69.500  1215.136
    70.000  1221.013
    70.500  1226.860
    71.000  1232.679
    71.500  1238.469
    72.000  1244.230
    72.500  1249.961
    73.000  1255.662
    73.500  1261.334
    74.000  1266.975
    74.500  1272.587
    75.000  1278.168
    75.500  1283.721
    76.000  1289.244
    76.500  1294.738
    77.000  1300.202
    77.500  1305.636
    78.000  1311.040
    78.500  1316.413
    79.000  1321.756
    79.500  1327.070
    80.000  1332.355
    80.500  1337.611
    81.000  1342.836
    81.500  1348.030
    82.000  1353.192
    82.500  1358.322
    83.000  1363.420
    83.500  1368.487
    84.000  1373.523
    84.500  1378.528
    85.000  1383.501
    85.500  1388.444
    86.000  1393.354
    86.500  1398.233
    87.000  1403.079
    87.500  1407.893
    88.000  1412.674
    88.500  1417.422
    89.000  1422.137
    89.500  1426.818
    90.000  1431.465
    90.500  1436.079
    91.000  1440.659
    91.500  1445.205
    92.000  1449.717
    92.500  1454.195
    93.000  1458.640
    93.500  1463.050
    94.000  1467.435
    94.500  1471.802
    95.000  1476.157
    95.500  1480.500
    96.000  1484.832
    96.500  1489.150
    97.000  1493.452
    97.500  1497.734
    98.000  1501.995
    98.500  1506.237
    99.000  1510.459
    99.500  1514.662
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   719.596
     1.000   719.643
     1.500   719.721
     2.000   719.830
     2.500   719.970
     3.000   720.141
     3.500   720.343
     4.000   720.576
     4.500   720.840
     5.000   721.135
     5.500   721.460
     6.000   721.817
     6.500   722.204
     7.000   722.621
     7.500   723.069
     8.000   723.547
     8.500   724.055
     9.000   724.593
     9.500   725.161
    10.000   725.760
    10.500   726.387
    11.000   727.044
    11.500   727.731
    12.000   728.446
    12.500   729.191
    13.000   729.965
    13.500   730.767
    14.000   731.597
    14.500   732.456
    15.000   733.343
    15.500   734.258
    16.000   735.200
    16.500   736.170
    17.000   737.167
    17.500   738.191
    18.000   739.242
    18.500   740.319
    19.000   741.423
    19.500   742.552
    20.000   743.708
    20.500   744.889
    21.000   746.095
    21.500   747.326
    22.000   748.582
    22.500   749.862
    23.000   751.166
    23.500   752.495
    24.000   753.846
    24.500   755.221
    25.000   756.620
    25.500   758.041
    26.000   759.484
    26.500   760.949
    27.000   762.437
    27.500   763.945
    28.000   765.475
    28.500   767.026
    29.000   768.598
    29.500   770.189
    30.000   771.801
    30.500   773.432
    31.000   775.083
    31.500   776.752
    32.000   778.440
    32.500   780.147
    33.000   781.872
    33.500   783.614
    34.000   785.373
    34.500   787.150
    35.000   788.943
    35.500   790.753
    36.000   792.578
    36.500   794.419
    37.000   796.276
    37.500   798.148
    38.000   800.034
    38.500   801.934
    39.000   803.849
    39.500   805.777
    40.000   807.719
    40.500   809.673
    41.000   811.641
    41.500   813.620
    42.000   815.612
    42.500   817.615
    43.000   819.629
    43.500   821.655
    44.000   823.691
    44.500   825.737
    45.000   827.794
    45.500   829.860
    46.000   831.936
    46.500   834.020
    47.000   836.114
    47.500   838.215
    48.000   840.325
    48.500   842.443
    49.000   844.568
    49.500   846.700
    50.000   848.839
    50.500   850.984
    51.000   853.136
    51.500   855.294
    52.000   857.457
    52.500   859.626
    53.000   861.799
    53.500   863.978
    54.000   866.161
    54.500   868.349
    55.000   870.540
    55.500   872.735
    56.000   874.933
    56.500   877.135
    57.000   879.340
    57.500   881.547
    58.000   883.757
    58.500   885.969
    59.000   888.183
    59.500   890.399
    60.000   892.616
    60.500   894.835
    61.000   897.055
    61.500   899.276
    62.000   901.498
    62.500   903.720
    63.000   905.943
    63.500   908.165
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.650
     1.000   931.717
     1.500   931.828
     2.000   931.983
     2.500   932.182
     3.000   932.425
     3.500   932.713
     4.000   933.044
     4.500   933.420
     5.000   933.840
     5.500   934.303
     6.000   934.811
     6.500   935.362
     7.000   935.956
     7.500   936.595
     8.000   937.276
     8.500   938.001
     9.000   938.768
     9.500   939.579
    10.000   940.433
    10.500   941.329
    11.000   942.268
    11.500   943.249
    12.000   944.272
    12.500   945.337
    13.000   946.444
    13.500   947.592
    14.000   948.782
    14.500   950.013
    15.000   951.284
    15.500   952.597
    16.000   953.950
    16.500   955.343
    17.000   956.776
    17.500   958.249
    18.000   959.761
    18.500   961.312
    19.000   962.903
    19.500   964.532
    20.000   966.200
    20.500   967.906
    21.000   969.649
    21.500   971.430
    22.000   973.249
    22.500   975.104
    23.000   976.996
    23.500   978.925
    24.000   980.890
    24.500   982.890
    25.000   984.926
    25.500   986.997
    26.000   989.103
    26.500   991.244
    27.000   993.419
    27.500   995.627
    28.000   997.870
    28.500  1000.145
    29.000  1002.453
    29.500  1004.794
    30.000  1007.168
    30.500  1009.573
    31.000  1012.010
    31.500  1014.478
    32.000  1016.977
    32.500  1019.506
    33.000  1022.066
    33.500  1024.656
    34.000  1027.275
    34.500  1029.924
    35.000  1032.601
    35.500  1035.307
    36.000  1038.042
    36.500  1040.804
    37.000  1043.594
    37.500  1046.411
    38.000  1049.255
    38.500  1052.125
    39.000  1055.022
    39.500  1057.945
    40.000  1060.893
    40.500  1063.866
    41.000  1066.864
    41.500  1069.887
    42.000  1072.934
    42.500  1076.005
    43.000  1079.099
    43.500  1082.217
    44.000  1085.358
    44.500  1088.521
    45.000  1091.707
    45.500  1094.914
    46.000  1098.143
    46.500  1101.394
    47.000  1104.665
    47.500  1107.958
    48.000  1111.270
    48.500  1114.603
    49.000  1117.955
    49.500  1121.327
    50.000  1124.718
    50.500  1128.128
    51.000  1131.557
    51.500  1135.004
    52.000  1138.469
    52.500  1141.951
    53.000  1145.451
    53.500  1148.968
    54.000  1152.502
    54.500  1156.053
    55.000  1159.620
    55.500  1163.202
    56.000  1166.801
    56.500  1170.415
    57.000  1174.044
    57.500  1177.688
    58.000  1181.347
    58.500  1185.020
    59.000  1188.707
    59.500  1192.408
    60.000  1196.122
    60.500  1199.850
    61.000  1203.591
    61.500  1207.345
    62.000  1211.112
    62.500  1214.891
    63.000  1218.682
    63.500  1222.484
    64.000  1226.299
    64.500  1230.125
    65.000  1233.962
    65.500  1237.810
    66.000  1241.669
    66.500  1245.538
    67.000  1249.417
    67.500  1253.307
    68.000  1257.206
    68.500  1261.115
    69.000  1265.033
    69.500  1268.960
    70.000  1272.897
    70.500  1276.842
    71.000  1280.796
    71.500  1284.758
    72.000  1288.728
    72.500  1292.706
    73.000  1296.692
    73.500  1300.686
    74.000  1304.687
    74.500  1308.695
    75.000  1312.710
    75.500  1316.732
    76.000  1320.760
    76.500  1324.795
    77.000  1328.837
    77.500  1332.884
    78.000  1336.937
    78.500  1340.996
    79.000  1345.061
    79.500  1349.131
    80.000  1353.206
    80.500  1357.286
    81.000  1361.372
    81.500  1365.462
    82.000  1369.556
    82.500  1373.655
    83.000  1377.759
    83.500  1381.866
    84.000  1385.977
    84.500  1390.093
    85.000  1394.212
    85.500  1398.334
    86.000  1402.460
    86.500  1406.589
    87.000  1410.721
    87.500  1414.857
    88.000  1418.995
    88.500  1423.136
    89.000  1427.279
    89.500  1431.425
    90.000  1435.573
    90.500  1439.724
    91.000  1443.876
    91.500  1448.030
    92.000  1452.187
    92.500  1456.345
    93.000  1460.504
    93.500  1464.665
    94.000  1468.828
    94.500  1472.991
    95.000  1477.156
    95.500  1481.322
    96.000  1485.489
    96.500  1489.656
    97.000  1493.824
    97.500  1497.993
    98.000  1502.162
    98.500  1506.332
    99.000  1510.502
    99.500  1514.672
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.708
    29.500   782.947
    30.000   793.185
    30.500   803.422
    31.000   813.655
    31.500   823.886
    32.000   834.112
    32.500   844.333
    33.000   854.548
    33.500   864.756
    34.000   874.956
    34.500   885.148
    35.000   895.329
    35.500   905.499
    36.000   915.656
    36.500   925.799
    37.000   935.927
    37.500   946.038
    38.000   956.131
    38.500   965.950
    39.000   976.257
    39.500   986.287
    40.000   996.292
    40.500  1006.272
    41.000  1016.224
    41.500  1026.148
    42.000  1036.042
    42.500  1045.905
    43.000  1055.735
    43.500  1065.532
    44.000  1075.293
    44.500  1085.018
    45.000  1094.705
    45.500  1104.017
    46.000  1112.186
    46.500  1120.339
    47.000  1128.474
    47.500  1136.594
    48.000  1144.696
    48.500  1152.782
    49.000  1160.851
    49.500  1168.899
    50.000  1176.921
    50.500  1184.905
    51.000  1192.834
    51.500  1200.750
    52.000  1208.659
    52.500  1216.562
    53.000  1224.460
    53.500  1232.354
    54.000  1240.243
    54.500  1248.129
    55.000  1256.012
    55.500  1263.891
    56.000  1271.766
    56.500  1279.639
    57.000  1287.508
    57.500  1295.374
    58.000  1303.236
    58.500  1311.095
    59.000  1318.951
    59.500  1326.803
    60.000  1334.651
    60.500  1342.495
    61.000  1350.335
    61.500  1358.171
    62.000  1366.000
    62.500  1373.824
    63.000  1381.643
    63.500  1389.454
    64.000  1397.260
    64.500  1405.058
    65.000  1412.849
    65.500  1420.632
    66.000  1428.407
    66.500  1436.173
    67.000  1443.931
    67.500  1451.680
    68.000  1459.420
    68.500  1467.151
    69.000  1474.872
    69.500  1482.584
    70.000  1490.286
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     7.555   215.797     0.150
     8.127   114.797     0.150
    15.370   220.297     0.150
    15.766   401.797     0.150
    19.604   339.594     0.150
    20.128   561.297     0.150
    20.542   505.797     0.150
    23.051   558.797     0.150
    25.919   614.797     0.150
    29.785   363.797     0.150
    34.120   730.797     0.150
    38.987   817.797     0.150
    45.794   665.797     0.150
    45.794   923.797     0.150
    45.794   937.797     0.150
    45.794  1129.797     0.150
    47.449   817.797     0.150
    49.102   817.797     0.150
    49.302   817.797     0.150
    50.304   528.797     0.150
    50.856   528.797     0.150
    51.547   545.797     0.150
    54.234   559.797     0.150
    56.810   581.594     0.150
    57.053  1058.797     0.150
    62.076  1119.297     0.150
    69.211   667.797     0.150
    74.456     7.000     0.150
    83.168   749.797     0.150
    91.539    18.898     0.150
    91.664     6.000     0.150
    91.664   814.797     0.150
    91.664   822.797     0.150
    91.664   841.797     0.150
   100.673  1963.797     0.150
   102.758   842.797     0.150
   114.948  1128.898     0.150
     3.232    76.303     0.150
     3.101    75.803     0.150
     5.022   141.803     0.150
     7.417   196.303     0.150
     8.433   137.303     0.150
     8.746   130.303     0.150
     9.537   247.003     0.150
    15.197   216.303     0.150
    15.775   412.303     0.150
    22.403   534.303     0.150
    28.828   662.303     0.150
    32.029    24.500     0.150
    32.029   462.303     0.150
    32.029   700.303     0.150
    36.762   769.303     0.150
    39.605    22.200     0.150
    39.605   447.402     0.150
    39.605    22.101     0.150
    39.605   810.303     0.150
    40.065   822.303     0.150
    40.065   453.303     0.150
    40.065   822.303     0.150
    43.808   483.503     0.150
    43.808   872.303     0.150
    45.100   598.503     0.150
    45.452     6.000     0.150
    45.671   499.003     0.150
    50.010   531.503     0.150
    50.010   614.703     0.150
    50.737   530.902     0.150
    50.575   537.303     0.150
    50.575   986.303     0.150
    51.810   544.803     0.150
    51.810    21.000     0.150
    51.810   983.803     0.150
    51.810  1008.003     0.150
    52.904   552.503     0.150
    52.904   998.303     0.150
    54.265   563.303     0.150
    54.367   565.803     0.150
    54.367    19.500     0.150
    54.933   569.902     0.150
    54.933  1032.402     0.150
    55.255  1037.902     0.150
    55.275   569.703     0.150
    55.275  1029.902     0.150
    56.183   577.603     0.150
    56.183  1048.303     0.150
    56.384   577.303     0.150
    56.384    16.500     0.150
    57.311  1063.603     0.150
    57.311   586.303     0.150
    57.311  1063.603     0.150
    57.646  1066.303     0.150
    58.923  1084.503     0.150
    58.923   597.303     0.150
    58.923    19.200     0.150
    58.923  1084.503     0.150
    61.387   612.303     0.150
    61.387  1110.303     0.150
    63.647   668.303     0.150
    63.647   625.303     0.150
    63.647    21.000     0.150
    67.016   651.803     0.150
    67.016   800.303     0.150
    67.493  1188.303     0.150
    67.493  1619.303     0.150
    68.286   658.703     0.150
    68.286  1198.803     0.150
    68.494    10.000     0.150
    68.494    18.000     0.150
    68.494   658.303     0.150
    68.494    10.000     0.150
    68.494    18.000     0.150
    68.494  1200.303     0.150
    68.494  1237.303     0.150
    74.739   691.503     0.150
    74.739   691.503     0.150
    76.159   709.803     0.150
    76.612   710.303     0.150
    76.839   710.003     0.150
    77.089   710.303     0.150
    80.535   730.902     0.150
    81.063  1339.803     0.150
    83.388   744.303     0.150
    83.522   746.303     0.150
    85.398   749.303     0.150
    89.159   771.303     0.150
    90.575   781.303     0.150
    90.575    15.000     0.150
    91.002   777.303     0.150
    91.729    13.000     0.150
    91.729   813.303     0.150
    91.729   824.303     0.150
    94.332   803.402     0.150
    94.939   799.203     0.150
    95.830   836.303     0.150
    95.830   803.902     0.150
   153.084  1190.803     0.150
   155.513  1203.402     0.150
     7.657   205.930     0.150
     7.918   119.930     0.150
    16.501   231.031     0.150
    19.970   378.930     0.150
    21.500   296.930     0.150
    21.782    20.301     0.150
    21.782    34.301     0.150
    22.830     7.500     0.150
    22.830   553.930     0.150
    22.982   311.031     0.150
    31.305   375.430     0.150
    43.365   478.930     0.150
    43.365  1069.930     0.150
    44.277   594.930     0.150
    44.533    19.500     0.150
    44.533   516.930     0.150
    45.458   504.828     0.150
    45.510   504.930     0.150
    45.510   505.031     0.150
    45.621   504.930     0.150
    45.621   505.430     0.150
    46.129   506.930     0.150
    52.359   985.828     0.150
    52.359   548.430     0.150
    52.359   985.828     0.150
    52.789   560.930     0.150
    52.789   560.930     0.150
    52.789   629.930     0.150
    53.162   553.930     0.150
    54.205   568.930     0.150
    54.205   568.930     0.150
    54.377   563.930     0.150
    55.012   576.930     0.150
    55.012   576.930     0.150
    56.668   572.031     0.150
    56.978   586.930     0.150
    56.978   587.430     0.150
    57.398   589.430     0.150
    57.398   646.930     0.150
    58.612   600.930     0.150
    58.612   601.230     0.150
    62.335   618.930     0.150
    62.335     9.000     0.150
    64.259    17.000     0.150
    64.259   632.930     0.150
    64.259    17.000     0.150
    64.259   676.930     0.150
    65.076   637.930     0.150
    65.076     8.500     0.150
    69.551     7.000     0.150
    69.551   664.930     0.150
    69.551     7.000     0.150
    69.551   692.430     0.150
    74.370   699.930     0.150
    74.370   694.930     0.150
    74.370   699.930     0.150
    74.405   702.930     0.150
    74.405   694.930     0.150
    74.405   702.930     0.150
    75.807   710.930     0.150
    76.529   712.930     0.150
    76.529   712.930     0.150
    80.136   731.930     0.150
    80.136   731.930     0.150
    81.550   737.930     0.150
    81.550   738.328     0.150
    86.367   764.328     0.150
    88.788   776.930     0.150
    88.788   777.930     0.150
    90.496   785.930     0.150
    90.496   785.930     0.150
    92.453   786.930     0.150
    93.574   795.930     0.150
    94.920   805.930     0.150
    94.961   807.930     0.150
    94.961   807.930     0.150
    95.813   810.129     0.150
   166.594  1198.930     0.150
     1.411    20.678     0.150
     5.902    96.678     0.150
     9.304   140.678     0.150
    11.638   166.178     0.150
    11.638   215.178     0.150
    12.684   184.979     0.150
    13.294   386.678     0.150
    16.102   226.479     0.150
    16.102   226.479     0.150
    16.102   226.479     0.150
    17.355   225.678     0.150
    19.845   433.678     0.150
    20.216  1436.377     0.150
    21.423     6.500     0.150
    21.423   523.678     0.150
    21.517   294.678     0.150
    23.956   375.678     0.150
    24.529   704.178     0.150
    24.529  1777.678     0.150
    24.858   328.678     0.150
    25.750     9.500     0.150
    25.750    14.500     0.150
    26.140   282.678     0.150
    26.140  1346.678     0.150
    26.379   626.678     0.150
    29.349   360.678     0.150
    30.795   620.678     0.150
    31.078   374.578     0.150
    31.118   370.678     0.150
    31.118  2260.678     0.150
    31.912    17.000     0.150
    32.244   396.248     0.150
    32.244    68.369     0.150
    32.944   421.678     0.150
    33.592   395.678     0.150
    33.592   399.678     0.150
    34.744   745.678     0.150
    34.744   408.678     0.150
    34.744   745.678     0.150
    34.957   503.678     0.150
    34.957   734.678     0.150
    34.957   791.678     0.150
    34.938   423.678     0.150
    36.568   427.908     0.150
    36.568   436.018     0.150
    36.846    16.600     0.150
    36.939   433.678     0.150
    36.939   786.678     0.150
    39.547   457.617     0.150
    39.547   461.098     0.150
    39.665   446.678     0.150
    40.050   454.678     0.150
    40.050   548.678     0.150
    40.120   454.678     0.150
    40.120    12.000     0.150
    40.120   568.678     0.150
    40.120   810.678     0.150
    40.120  1016.678     0.150
    40.894   557.678     0.150
    43.050   478.678     0.150
    43.050   862.678     0.150
    44.127   866.678     0.150
    44.127   593.678     0.150
    44.127   630.678     0.150
    44.127   866.678     0.150
    45.282   503.178     0.150
    45.282   521.678     0.150
    45.282   610.678     0.150
    45.282   643.178     0.150
    45.282   788.678     0.150
    45.435   891.678     0.150
    45.435   496.678     0.150
    45.435   891.678     0.150
    45.435  1144.678     0.150
    45.974   510.678     0.150
    45.974   866.678     0.150
    45.984   499.678     0.150
    45.984   918.479     0.150
    46.488   504.178     0.150
    46.585   518.818     0.150
    46.585   692.678     0.150
    46.585  1139.098     0.150
    46.585  1140.639     0.150
    48.141   518.678     0.150
    48.141   518.678     0.150
    48.141   952.678     0.150
    49.758   990.678     0.150
    49.812   712.678     0.150
    49.812  1246.678     0.150
    49.812   973.678     0.150
    50.205   539.678     0.150
    50.205   547.678     0.150
    50.205   583.678     0.150
    50.617   588.377     0.150
    50.617   983.678     0.150
    50.811   538.678     0.150
    50.811   971.678     0.150
    51.101   976.678     0.150
    51.101   540.678     0.150
    51.101   976.678     0.150
    51.101  1286.678     0.150
    51.787   547.678     0.150
    51.787   989.678     0.150
    51.787   547.678     0.150
    51.787   989.678     0.150
    52.268   983.678     0.150
    52.268   671.678     0.150
    52.268   983.678     0.150
    52.268  1128.678     0.150
    52.268  1312.678     0.150
    52.319   733.078     0.150
    52.319  1014.678     0.150
    52.410   999.678     0.150
    52.410   549.678     0.150
    52.410   999.678     0.150
    53.004   555.479     0.150
    53.004   631.678     0.150
    53.004   739.678     0.150
    53.004  1142.678     0.150
    53.087  1009.678     0.150
    53.087   557.178     0.150
    53.087   744.178     0.150
    53.087  1009.678     0.150
    53.160   554.678     0.150
    53.160  1002.678     0.150
    53.824    15.000     0.150
    53.824   631.678     0.150
    53.824  1015.678     0.150
    54.475   564.678     0.150
    54.475   766.678     0.150
    54.475  1025.678     0.150
    54.475  1028.678     0.150
    54.484   566.678     0.150
    54.484  1027.678     0.150
    54.985   569.578     0.150
    54.985   769.678     0.150
    54.985  1033.678     0.150
    54.985  1376.678     0.150
    55.344   573.678     0.150
    55.344  1039.678     0.150
    56.322   578.678     0.150
    56.322  1056.078     0.150
    56.437   580.777     0.150
    57.217   587.678     0.150
    57.217  1077.178     0.150
    57.369  1052.678     0.150
    57.369   587.678     0.150
    57.369  1052.678     0.150
    57.734  1060.678     0.150
    57.734  1060.678     0.150
    57.734  1432.678     0.150
    58.988  1081.078     0.150
    58.988   597.678     0.150
    58.988  1081.078     0.150
    59.978   624.578     0.150
    61.185   746.678     0.150
    61.185   846.678     0.150
    61.185  1112.678     0.150
    61.838   616.178     0.150
    61.838    11.500     0.150
    61.838   661.678     0.150
    61.838   759.678     0.150
    61.838  1120.178     0.150
    64.010   626.678     0.150
    64.010   626.678     0.150
    64.010   660.678     0.150
    64.010   779.678     0.150
    64.010   864.678     0.150
    64.010  1141.678     0.150
    64.230  1164.678     0.150
    65.318   641.678     0.150
    65.318  1161.678     0.150
    65.318  1201.678     0.150
    65.318  1581.678     0.150
    65.507   641.979     0.150
    65.507  1169.678     0.150
    67.061   653.178     0.150
    67.061   808.678     0.150
    67.061   903.678     0.150
    67.061  1191.678     0.150
    67.061  1224.678     0.150
    67.712   654.178     0.150
    67.712   906.678     0.150
    67.712  1190.678     0.150
    68.602   661.898     0.150
    68.602   664.059     0.150
    68.602   670.678     0.150
    68.602   674.148     0.150
    68.802   660.678     0.150
    68.802  1202.678     0.150
    68.707   688.678     0.150
    68.707   914.678     0.150
    68.707  1200.678     0.150
    69.232   670.479     0.150
    72.122   682.678     0.150
    72.122  1250.678     0.150
    73.029   689.678     0.150
    73.029   856.678     0.150
    73.029  1260.678     0.150
    73.940  1266.678     0.150
    73.940   694.678     0.150
    73.940   866.678     0.150
    73.940  1266.678     0.150
    74.813   703.678     0.150
    74.785   697.678     0.150
    74.785  1276.678     0.150
    74.785  1326.678     0.150
    74.801   697.678     0.150
    74.801  1269.678     0.150
    75.231   701.678     0.150
    75.231   974.678     0.150
    75.231  1282.678     0.150
    75.231  1764.678     0.150
    75.539     3.500     0.150
    75.539   733.678     0.150
    75.539   911.678     0.150
    75.539   980.678     0.150
    75.539  1356.178     0.150
    75.539  1390.178     0.150
    75.973  1339.678     0.150
    76.630   708.678     0.150
    76.906   712.678     0.150
    76.906   988.678     0.150
    76.906  1298.678     0.150
    77.093  1296.678     0.150
    77.178   712.678     0.150
    77.178   712.678     0.150
    77.178  1306.678     0.150
    77.178  1329.678     0.150
    77.388   754.178     0.150
    79.567   724.678     0.150
    79.567  1020.678     0.150
    79.567  1317.678     0.150
    79.615   725.678     0.150
    79.615  1325.678     0.150
    79.615   725.678     0.150
    79.615   914.678     0.150
    79.615  1325.678     0.150
    80.190   740.898     0.150
    80.190   727.805     0.150
    80.190   724.678     0.150
    80.376  1367.678     0.150
    80.376  1442.678     0.150
    80.376  1897.678     0.150
    80.267   727.678     0.150
    80.267     9.000     0.150
    80.267  1029.678     0.150
    80.267  1330.678     0.150
    80.907   731.877     0.150
    80.907   912.678     0.150
    80.907  1336.678     0.150
    80.907  1401.678     0.150
    81.161  1345.678     0.150
    81.161   733.678     0.150
    81.161  1345.678     0.150
    81.466   735.678     0.150
    81.466  1031.678     0.150
    81.466  1340.678     0.150
    83.494   910.678     0.150
    83.490   745.678     0.150
    83.490  1060.678     0.150
    83.490  1362.678     0.150
    83.756   745.678     0.150
    83.756     9.000     0.150
    83.756  1366.678     0.150
    83.756  1436.678     0.150
    83.775   754.678     0.150
    83.793   754.578     0.150
    83.823   747.479     0.150
    83.955   755.178     0.150
    83.982   755.479     0.150
    84.812   758.777     0.150
    85.164   766.047     0.150
    85.164   210.711     0.150
    85.997   759.678     0.150
    85.997  1078.678     0.150
    85.997  1382.678     0.150
    85.997  1390.678     0.150
    85.997  1934.678     0.150
    86.527   761.277     0.150
    86.817   765.178     0.150
    86.817  1400.678     0.150
    87.594  1030.678     0.150
    87.737   761.678     0.150
    87.769   762.277     0.150
    87.897   759.678     0.150
    88.064   776.178     0.150
    88.460   757.678     0.150
    88.806   780.777     0.150
    89.000   781.877     0.150
    89.014   781.877     0.150
    89.129   782.479     0.150
    89.343   783.777     0.150
    89.316   775.678     0.150
    89.316   775.678     0.150
    89.316  1099.678     0.150
    89.316  1412.678     0.150
    89.660   767.678     0.150
    90.134   787.078     0.150
    90.159   787.678     0.150
    90.392   788.277     0.150
    90.429   788.277     0.150
    90.354   781.277     0.150
    90.652   789.078     0.150
    90.604  1814.678     0.150
    90.604  2006.678     0.150
    90.604  2211.678     0.150
    90.724  1435.678     0.150
    90.724   780.678     0.150
    90.724     8.500     0.150
    90.724  1115.678     0.150
    90.724  1435.678     0.150
    90.724  1536.678     0.150
    91.007   778.678     0.150
    91.794   785.578     0.150
    91.794  1013.678     0.150
    92.370   936.678     0.150
    93.121   819.777     0.150
    93.121   883.678     0.150
    93.121   354.000     0.150
    93.121  1166.678     0.150
    93.121  1742.678     0.150
    93.155   792.678     0.150
    93.155     7.000     0.150
    93.508   796.377     0.150
    93.508  1026.479     0.150
    93.745  1025.678     0.150
    94.152     4.199     0.150
    94.152   980.979     0.150
    94.152  1004.578     0.150
    94.429  1416.678     0.150
    94.621  1444.678     0.150
    94.621  1869.678     0.150
    94.621   802.678     0.150
    94.621  1030.678     0.150
    94.621  1554.678     0.150
    95.097   825.678     0.150
    95.097  1024.678     0.150
    95.097  1412.678     0.150
    95.097  1490.678     0.150
    95.097   800.678     0.150
    95.122   831.377     0.150
    95.122   888.277     0.150
    95.122  1038.678     0.150
    95.122   801.078     0.150
    95.122  1038.678     0.150
    95.122  1474.678     0.150
    95.503  1445.678     0.150
    95.503   804.678     0.150
    95.503   829.678     0.150
    95.503  1040.678     0.150
    95.503  1169.678     0.150
    95.503  1445.678     0.150
    95.503  1479.678     0.150
    95.503  1532.678     0.150
    95.503  1888.678     0.150
    95.503  2156.678     0.150
    95.503   804.678     0.150
    95.503  1479.678     0.150
    95.659   811.377     0.150
    95.659   975.678     0.150
    96.000  1452.678     0.150
    96.063  1046.777     0.150
    96.063   809.078     0.150
    96.063  1046.777     0.150
    96.550   803.678     0.150
    96.572   810.678     0.150
    96.572   810.678     0.150
    96.572   810.678     0.150
    96.572  1040.678     0.150
    96.572  1166.678     0.150
    96.572  1451.678     0.150
    96.572   810.678     0.150
    96.924   822.578     0.150
    96.924  1009.479     0.150
    96.924  1055.678     0.150
    96.924   811.979     0.150
    96.924   822.578     0.150
    96.924  1435.178     0.150
    97.022   815.178     0.150
    97.507   804.678     0.150
    98.402  1068.178     0.150
    99.118   824.377     0.150
    99.213  1068.248     0.150
    99.520  1182.678     0.150
    99.520  1198.678     0.150
    99.520  1607.678     0.150
    99.520  1962.678     0.150
    99.520  1994.678     0.150
    99.520   822.678     0.150
    99.520  1069.678     0.150
    99.520  1198.678     0.150
    99.520  1607.678     0.150
   100.501  1020.578     0.150
   100.501  2718.877     0.150
   100.342   830.178     0.150
   100.611   832.678     0.150
   100.665  1073.678     0.150
   101.248   834.479     0.150
   101.245  1067.678     0.150
   101.634   837.479     0.150
   101.732   838.678     0.150
   101.732  1330.678     0.150
   101.732  1548.678     0.150
   101.732  1986.678     0.150
   101.884   838.678     0.150
   101.986   839.178     0.150
   103.034  1031.578     0.150
   103.034  2730.277     0.150
   103.576  2729.979     0.150
   103.947  1046.178     0.150
   104.724   836.178     0.150
   104.990  1033.877     0.150
   104.990  1060.877     0.150
   106.244   861.678     0.150
   106.244  1146.678     0.150
   106.244  1266.678     0.150
   106.244  1726.678     0.150
   106.244  2026.678     0.150
   106.244  2216.678     0.150
   106.244  2246.678     0.150
   106.244  2266.678     0.150
   106.283   861.678     0.150
   106.283  1132.678     0.150
   113.426  1106.678     0.150
   113.426  1751.678     0.150
   113.426  2140.678     0.150
   115.666  1166.678     0.150
   120.717  1136.678     0.150
   120.717  1141.479     0.150
   123.592  1127.078     0.150
   125.891   932.809     0.150
   126.665  1263.479     0.150
   127.338  1141.318     0.150
   150.180  1180.678     0.150
   151.830  1189.178     0.150
   152.143  1189.678     0.150
   152.429  1189.877     0.150
   152.528  1191.178     0.150
   152.597  1189.678     0.150
   153.898  1192.377     0.150
   154.132  1186.678     0.150
   154.903  1192.678     0.150
   154.903  2042.678     0.150
   155.257  1193.678     0.150
   155.383  1193.877     0.150
   155.704  1183.678     0.150
   156.937  1197.178     0.150
   157.295  1448.678     0.150
   157.318  1199.197     0.150
   158.481  1200.107     0.150
   158.489  1200.498     0.150
   158.514  1200.059     0.150
   158.721  1198.678     0.150
   158.831  1199.908     0.150
   159.138  1199.178     0.150
   159.080  1201.088     0.150
   161.617  1201.578     0.150
   162.326  1203.178     0.150
   163.784  1211.979     0.150
   163.784  1248.979     0.150
   163.784  1264.078     0.150
   165.961  1208.678     0.150
    22.461   306.072     0.150
    29.234   362.572     0.150
    29.995   364.172     0.150
    30.952   378.973     0.150
    33.473   394.072     0.150
    35.089   408.271     0.150
    40.246   454.873     0.150
    40.655   464.172     0.150
    44.252   488.072     0.150
    51.222   542.072     0.150
    52.401   550.172     0.150
    61.971   617.072     0.150
    61.971  1127.072     0.150
    64.139   630.473     0.150
    65.586   644.072     0.150
    68.927   658.072     0.150
    68.817   663.072     0.150
    74.866   700.473     0.150
    74.885   700.072     0.150
    76.628   705.473     0.150
    77.269   709.172     0.150
    76.992   709.271     0.150
    76.992   709.271     0.150
    77.872   712.373     0.150
    79.803   721.172     0.150
    81.181   729.572     0.150
    84.826   748.072     0.150
    85.453   752.072     0.150
    86.105   760.072     0.150
     5.727   104.584     0.150
     8.324   135.584     0.150
     8.700   135.584     0.150
    11.585   172.084     0.150
    14.774   223.584     0.150
    15.607   228.084     0.150
    15.607   235.084     0.150
    16.945     8.500     0.150
    17.340   221.584     0.150
    20.264  1439.584     0.150
    22.453   315.283     0.150
    22.755     9.000     0.150
    23.706   309.984     0.150
    26.088   342.084     0.150
    26.088  1023.584     0.150
    28.096   627.584     0.150
    28.576   639.584     0.150
    29.137   360.084     0.150
    29.401   625.584     0.150
    29.910   365.684     0.150
    33.735   407.184     0.150
    33.735   406.584     0.150
    36.560   756.584     0.150
    39.405   443.584     0.150
    40.170   453.885     0.150
    40.170   820.584     0.150
    40.878   565.283     0.150
    44.150   486.584     0.150
    44.150   887.584     0.150
    45.252   903.584     0.150
    45.460   502.584     0.150
    45.460    20.500     0.150
    45.460  1159.584     0.150
    45.460   502.584     0.150
    45.460    20.500     0.150
    45.460   896.584     0.150
    45.804     3.000     0.150
    46.462   504.984     0.150
    48.125   517.584     0.150
    48.125   944.584     0.150
    49.783   977.584     0.150
    49.783   999.584     0.150
    49.783  1106.584     0.150
    49.783  1279.584     0.150
    50.191   539.584     0.150
    51.154   540.584     0.150
    52.309   549.084     0.150
    52.309   676.584     0.150
    52.309   989.584     0.150
    52.309  1005.584     0.150
    52.422   550.584     0.150
    52.422   999.584     0.150
    53.175   994.584     0.150
    53.175   555.584     0.150
    53.175   994.584     0.150
    53.873   620.584     0.150
    54.485    16.301     0.150
    54.485   565.283     0.150
    54.485   581.584     0.150
    54.485  1029.984     0.150
    54.484   567.584     0.150
    54.978   571.584     0.150
    55.341  1040.184     0.150
    57.200   590.584     0.150
    57.362  1052.584     0.150
    57.362   588.584     0.150
    57.362  1052.584     0.150
    57.730   589.584     0.150
    57.730  1065.584     0.150
    61.194   757.584     0.150
    61.878   615.584     0.150
    61.878  1122.584     0.150
    65.308   641.584     0.150
    65.308  1157.584     0.150
    65.498   642.084     0.150
    65.498  1171.584     0.150
    67.724   654.584     0.150
    68.852   662.584     0.150
    68.717  1208.584     0.150
    68.717   661.584     0.150
    68.717   691.584     0.150
    68.717  1208.584     0.150
    68.717  1220.584     0.150
    68.717  1247.584     0.150
    72.115   683.584     0.150
    72.115  1248.584     0.150
    73.022   689.584     0.150
    73.022   847.584     0.150
    74.777   698.584     0.150
    74.795   698.584     0.150
    75.968  1348.584     0.150
    76.563   706.584     0.150
    76.563   707.283     0.150
    77.175   711.584     0.150
    77.175  1338.584     0.150
    77.377   708.584     0.150
    79.740   720.484     0.150
    79.611   724.783     0.150
    80.276   727.584     0.150
    80.276    13.000     0.150
    80.276  1331.584     0.150
    80.915   731.984     0.150
    81.486   735.084     0.150
    81.486    14.500     0.150
    83.511   757.184     0.150
    83.769   747.584     0.150
    83.809   753.584     0.150
    83.940   755.584     0.150
    84.745   748.584     0.150
    86.005   759.584     0.150
    87.541   768.184     0.150
    88.833   780.584     0.150
    89.027   781.584     0.150
    89.041   781.584     0.150
    89.156   783.584     0.150
    89.370   785.584     0.150
    90.164   784.584     0.150
    90.422   786.584     0.150
    90.458   786.584     0.150
    90.681   787.584     0.150
    92.466     6.801     0.150
    92.466   813.584     0.150
    92.466   849.584     0.150
    92.466   887.584     0.150
    93.158     7.000     0.150
    93.158   821.584     0.150
    93.158   792.385     0.150
    93.472   800.084     0.150
    93.751  1008.584     0.150
    94.155  1028.484     0.150
    94.155   796.484     0.150
    94.155  1028.484     0.150
    94.625   801.084     0.150
    94.625  1033.184     0.150
    94.950   804.584     0.150
    95.103   831.283     0.150
    95.103   995.084     0.150
    95.103  1037.584     0.150
    95.103   800.584     0.150
    95.103  1037.584     0.150
    95.129   801.684     0.150
    95.510   801.584     0.150
    95.510  1042.584     0.150
    95.510   801.584     0.150
    95.661   988.484     0.150
    96.006   991.584     0.150
    96.006   806.484     0.150
    96.067  1035.283     0.150
    96.067   806.283     0.150
    96.067  1035.283     0.150
    96.579   807.584     0.150
    96.579  1048.584     0.150
    96.579   807.584     0.150
    96.928  1003.584     0.150
    96.928  1057.783     0.150
    96.928   809.885     0.150
    96.928    20.398     0.150
    98.604  1122.084     0.150
    98.848   824.584     0.150
    98.645   822.584     0.150
    99.119   825.584     0.150
    99.302   825.584     0.150
   100.344  1083.584     0.150
   100.611  1080.584     0.150
   100.612   819.084     0.150
   101.900   843.584     0.150
   101.989   824.084     0.150
   101.989  1089.584     0.150
   103.130   842.584     0.150
   102.981   842.484     0.150
   103.140   854.584     0.150
   114.431  1125.885     0.150
   128.077  1137.584     0.150
   152.582  1190.584     0.150
   158.756  1201.584     0.150
   158.880  1189.404     0.150
   159.174  1228.885     0.150
   159.174  1277.084     0.150
   159.128  1189.533     0.150
    19.770   276.035     0.150
    40.245   451.535     0.150
    48.637   518.635     0.150
    51.243   538.535     0.150
    52.370   547.734     0.150
    53.131   552.535     0.150
    54.426   562.535     0.150
    54.426   562.535     0.150
    61.909     9.000     0.150
    61.909     8.500     0.150
    61.909   746.535     0.150
    61.909  1201.535     0.150
    64.030   626.535     0.150
    65.397   639.035     0.150
    68.928   662.535     0.150
    74.678   694.535     0.150
    74.698   694.535     0.150
    76.806   711.535     0.150
    80.213   724.535     0.150
    80.851   728.436     0.150
    85.183   750.635     0.150
    85.942   755.535     0.150
    86.363   741.836     0.150
    95.063   798.135     0.150
    95.446   798.535     0.150
     8.263   115.520     0.150
    15.779   334.020     0.150
    16.193   234.020     0.150
    23.842   588.020     0.150
    33.918    12.800     0.150
    34.408   554.319     0.150
    34.408   405.819     0.150
    34.408   554.319     0.150
    36.445    18.200     0.150
    44.217   598.020     0.150
    44.217   884.020     0.150
    44.217  1087.020     0.150
    45.851   506.020     0.150
    46.710   919.520     0.150
    52.299   546.220     0.150
    52.299   546.020     0.150
    52.461   552.020     0.150
    52.461   991.020     0.150
    52.524   553.020     0.150
    53.820   564.020     0.150
    53.820   564.020     0.150
    54.594   567.020     0.150
    54.594  1027.220     0.150
    54.621    17.800     0.150
    54.621   569.020     0.150
    54.621    17.800     0.150
    55.132  1036.120     0.150
    56.583   595.020     0.150
    56.583   595.319     0.150
    57.875   590.020     0.150
    61.305   844.020     0.150
    61.874    12.000     0.150
    61.874   617.020     0.150
    61.874     5.000     0.150
    61.874    12.000     0.150
    61.874  1119.020     0.150
    61.874  1153.020     0.150
    64.085   631.020     0.150
    65.656   644.020     0.150
    68.786   662.620     0.150
    68.786     7.400     0.150
    68.786   693.020     0.150
    68.825   663.020     0.150
    68.825   681.520     0.150
    74.932   701.020     0.150
    77.051   713.020     0.150
    77.320   713.020     0.150
    81.564   736.020     0.150
    83.586   737.020     0.150
    85.317   754.419     0.150
    86.532   757.020     0.150
    92.622   775.020     0.150
   165.805  1202.020     0.150
    31.013   382.758     0.150
    31.013   558.758     0.150
    32.332   396.457     0.150
    33.539   404.457     0.150
    36.466   430.957     0.150
    44.149   486.457     0.150
    52.173   548.457     0.150
    53.152   557.258     0.150
    53.152  1014.457     0.150
    53.152  1134.457     0.150
    53.224   557.457     0.150
    53.224   557.457     0.150
    57.891   606.457     0.150
    65.689   643.656     0.150
    65.689     9.000     0.150
    68.628   660.457     0.150
    68.628     7.000     0.150
    74.962   699.457     0.150
    77.074   712.457     0.150
    77.335   712.457     0.150
    80.367   738.457     0.150
    81.010   729.457     0.150
    85.271   753.355     0.150
   152.233  1189.457     0.150
    21.391     8.500     0.150
    31.068   378.492     0.150
    32.316   387.191     0.150
    33.308   721.191     0.150
    33.810   727.191     0.150
    44.144   486.191     0.150
    52.189   547.492     0.150
    53.125   555.191     0.150
    53.125  1230.191     0.150
    54.601   567.191     0.150
    54.601    12.000     0.150
    55.128   568.191     0.150
    61.765   614.191     0.150
    61.765     8.000     0.150
    64.386  1173.191     0.150
    65.657   642.492     0.150
    67.784   654.191     0.150
    67.784   682.191     0.150
    68.658   660.691     0.150
    68.658     6.500     0.150
    68.658   678.691     0.150
    74.931   699.191     0.150
    77.044   711.992     0.150
    85.260   752.492     0.150
    21.370     4.898     0.150
    33.562   403.805     0.150
    89.990   768.004     0.150
     5.953    86.051     0.150
    11.685   180.051     0.150
    24.053   324.852     0.150
    26.465   334.551     0.150
    31.055   377.051     0.150
    44.500   492.750     0.150
    44.500   492.750     0.150
    44.500   492.750     0.150
    45.924   496.551     0.150
    77.515   724.750     0.150
    77.515   724.750     0.150
    77.515   724.750     0.150
    83.521   758.051     0.150
    85.286   752.051     0.150
     6.009   109.053     0.150
    26.620   437.053     0.150
    31.920   379.253     0.150
    40.539   447.153     0.150
     0.827     7.545     0.150
     1.080    30.545     0.150
     1.910    26.045     0.150
     4.732    81.545     0.150
     5.512   107.545     0.150
     5.790    92.545     0.150
     5.828   169.545     0.150
     7.444   112.545     0.150
     7.973   121.045     0.150
     8.457   127.545     0.150
     9.333   145.445     0.150
    20.968    22.102     0.150
    28.668   631.545     0.150
    28.668   707.545     0.150
    32.062   381.545     0.150
    33.339   703.545     0.150
    34.880  1882.945     0.150
    34.892   732.045     0.150
    36.724     4.600     0.150
    36.667   438.744     0.150
    44.858   488.545     0.150
    44.858   595.145     0.150
    51.710   541.346     0.150
    52.917   549.545     0.150
    53.177   552.545     0.150
    54.299   560.445     0.150
    57.407   580.545     0.150
    61.017   607.545     0.150
    61.292    13.000     0.150
    61.292   608.545     0.150
    61.292    13.000     0.150
    61.292   741.545     0.150
    63.606   623.545     0.150
    68.133   654.145     0.150
    77.444     4.600     0.150
    77.444  1855.045     0.150
    80.361   726.744     0.150
    83.722   742.346     0.150
    85.021   748.545     0.150
    85.021   748.545     0.150
    85.274     3.898     0.150
    94.169   791.346     0.150
    94.169   792.346     0.150
    95.917   800.445     0.150
   171.788  1200.346     0.150
    22.379   294.008     0.150
    23.663   316.008     0.150
    26.619   344.406     0.150
    28.697   359.008     0.150
    28.697   358.809     0.150
    28.697   366.406     0.150
    30.637   376.508     0.150
    31.425   383.008     0.150
    31.429   382.906     0.150
    33.852   464.008     0.150
    45.606   506.008     0.150
    46.647   510.207     0.150
    83.736   747.508     0.150
    94.199   796.609     0.150
    94.199   797.008     0.150
    94.199   802.207     0.150
    94.199    61.301     0.150
     1.038    36.609     0.150
     1.923    31.109     0.150
     1.923    58.609     0.150
     4.687    89.609     0.150
     5.744    95.609     0.150
    24.504   322.711     0.150
    26.582   341.109     0.150
    29.501   370.109     0.150
    36.625     5.297     0.150
    83.687   747.109     0.150
    94.167   796.508     0.150
    94.167   797.109     0.150
    94.167     3.703     0.150
     0.853    12.932     0.150
     2.375    56.932     0.150
     3.259    56.932     0.150
     7.476   115.932     0.150
    31.416   391.932     0.150
    83.746   752.732     0.150
    83.746   752.732     0.150
    94.194   797.832     0.150
    94.194   797.832     0.150
     4.725    79.553     0.150
     5.504   105.553     0.150
     7.973   146.053     0.150
     8.832   137.053     0.150
    16.919   238.553     0.150
    19.683   279.354     0.150
    20.973   505.553     0.150
    22.446   541.553     0.150
    26.751   335.553     0.150
    26.751   619.553     0.150
    27.849   403.553     0.150
    28.474   647.553     0.150
    28.619   360.553     0.150
    28.619   645.553     0.150
    28.682   350.553     0.150
    28.682   655.553     0.150
    30.622   372.553     0.150
    31.450    30.299     0.150
    32.058     5.500     0.150
    32.058   697.553     0.150
    32.654   701.553     0.150
    33.203   710.553     0.150
    33.203   397.553     0.150
    33.203   478.553     0.150
    33.203   710.553     0.150
    33.203   727.553     0.150
    34.877   411.053     0.150
    34.877   743.553     0.150
    34.880   741.553     0.150
    39.467   561.553     0.150
    39.467   806.553     0.150
    39.913   456.553     0.150
    39.913   815.553     0.150
    39.913  1051.553     0.150
    40.713   463.533     0.150
    43.239   600.553     0.150
    43.791   885.553     0.150
    43.791   885.553     0.150
    45.606   605.053     0.150
    46.447   607.553     0.150
    46.447   910.553     0.150
    46.794   514.553     0.150
    48.291   522.553     0.150
    50.135   541.953     0.150
    50.422   534.553     0.150
    50.422   534.553     0.150
    50.422   975.553     0.150
    50.422  1269.553     0.150
    51.723   552.553     0.150
    51.723   998.553     0.150
    51.723   552.553     0.150
    51.723   998.553     0.150
    52.200   549.053     0.150
    52.200   999.053     0.150
    52.915  1009.553     0.150
    52.915  1009.553     0.150
    53.019   556.553     0.150
    54.295   570.553     0.150
    54.295    17.000     0.150
    54.295   570.553     0.150
    54.295    17.000     0.150
    54.295  1030.453     0.150
    54.432   573.553     0.150
    54.432   573.553     0.150
    55.021  1041.553     0.150
    55.021  1059.553     0.150
    56.471  1051.953     0.150
    57.397   593.553     0.150
    57.397   593.553     0.150
    57.397  1073.553     0.150
    57.722   592.553     0.150
    57.722  1069.553     0.150
    61.013   612.553     0.150
    61.013  1116.553     0.150
    61.299   615.553     0.150
    61.299  1118.553     0.150
    61.299  1198.553     0.150
    63.609   632.252     0.150
    63.609  1141.553     0.150
    63.609  1565.553     0.150
    67.519   658.354     0.150
    71.378   680.553     0.150
    74.829   704.553     0.150
    74.829   704.553     0.150
    74.831   702.553     0.150
    74.831   702.553     0.150
    77.702   712.854     0.150
    80.105   733.553     0.150
    80.105   733.553     0.150
    80.105   918.553     0.150
    80.752   736.553     0.150
    80.752   736.553     0.150
    80.752  1385.553     0.150
    83.774   750.553     0.150
    85.019   754.354     0.150
    85.911   758.553     0.150
    90.627   782.553     0.150
    90.627     9.199     0.150
    92.176   789.752     0.150
    94.978   805.854     0.150
    95.351   982.553     0.150
    95.351   806.553     0.150
    95.351   982.553     0.150
    95.351   806.553     0.150
     0.879    29.289     0.150
    20.978   540.789     0.150
    31.973    12.602     0.150
     0.936    26.078     0.150
     2.421    46.078     0.150
     2.421    73.078     0.150
     5.764    97.078     0.150
     7.991   124.078     0.150
    50.730   544.281     0.150
    64.204   638.078     0.150
    94.354   797.578     0.150
     4.143    69.113     0.150
     4.642   119.613     0.150
     6.825    99.613     0.150
     6.825   194.613     0.150
     7.913   124.613     0.150
     8.276   124.413     0.150
    20.941     4.800     0.150
    22.969   308.613     0.150
    24.687   328.613     0.150
    27.611   353.113     0.150
    31.367     7.500     0.150
    31.367    12.000     0.150
    31.765   366.813     0.150
    35.965    10.400     0.150
    51.265   547.913     0.150
    85.557   761.613     0.150
    94.958   801.213     0.150
     1.738    74.594     0.150
     2.251    71.594     0.150
     9.674   148.395     0.150
    15.937   228.594     0.150
    21.139    19.000     0.150
    23.780   313.195     0.150
    23.780    32.398     0.150
    27.999    14.000     0.150
    27.999   427.594     0.150
    28.832   658.594     0.150
    30.787   374.594     0.150
    32.203   388.094     0.150
    34.713   402.484     0.150
    39.622  1051.594     0.150
    39.622   450.395     0.150
    39.622  1051.594     0.150
    41.130   475.594     0.150
    43.951   883.594     0.150
    43.951  1079.594     0.150
    43.951   485.094     0.150
    43.951   590.594     0.150
    43.951   883.594     0.150
    43.951  1079.594     0.150
    45.238    13.699     0.150
    45.238   494.895     0.150
    45.238    13.699     0.150
    46.586   662.594     0.150
    48.050   514.895     0.150
    48.304   519.793     0.150
    50.177   538.594     0.150
    50.580   540.594     0.150
    51.884   546.293     0.150
    61.156   612.594     0.150
    61.156  1118.594     0.150
    65.483   643.793     0.150
    67.665  1227.594     0.150
    67.665   655.094     0.150
    67.665  1227.594     0.150
    68.300    14.398     0.150
    68.300   659.195     0.150
    68.300    14.398     0.150
    68.300  1201.594     0.150
    77.556   714.793     0.150
    77.556     7.301     0.150
    77.556  1310.992     0.150
    85.983   758.594     0.150
    86.881   771.594     0.150
    86.881   771.594     0.150
    86.881  1383.594     0.150
    90.761   781.793     0.150
    90.761     7.602     0.150
    94.332   797.293     0.150
    95.104   799.895     0.150
    95.104   801.492     0.150
    95.104    15.500     0.150
    95.104   799.895     0.150
    95.104    15.500     0.150
    95.492   802.594     0.150
    95.492   802.594     0.150
    96.012   806.094     0.150
    96.012    11.000     0.150
    96.564   808.492     0.150
    96.564   808.492     0.150
     1.513    20.160     0.150
     1.513    31.160     0.150
     1.694    22.160     0.150
     2.854    41.660     0.150
     5.044   121.160     0.150
     5.180    73.160     0.150
     5.408    65.660     0.150
     7.933   113.160     0.150
     8.245   132.160     0.150
    20.751   264.160     0.150
    20.788   263.961     0.150
    21.145   280.660     0.150
    21.145    16.301     0.150
    21.145    24.000     0.150
    22.446   294.461     0.150
    22.446    14.699     0.150
    23.351   300.160     0.150
    24.081   312.760     0.150
    23.914   323.160     0.150
    25.163   322.160     0.150
    25.163   322.160     0.150
    27.623   626.160     0.150
    28.039    27.000     0.150
    28.039   625.160     0.150
    28.855   636.160     0.150
    30.706   368.660     0.150
    30.706    17.500     0.150
    31.458   373.961     0.150
    31.458   547.660     0.150
    31.698   689.160     0.150
    31.756   380.160     0.150
    31.756   691.160     0.150
    32.626   387.160     0.150
    33.693   394.160     0.150
    33.693    31.000     0.150
    34.823   405.160     0.150
    36.356   419.660     0.150
    37.080   429.160     0.150
    37.080   429.660     0.150
    40.127   451.660     0.150
    40.127    14.400     0.150
    40.127   990.160     0.150
    45.065    11.500     0.150
    45.065   492.660     0.150
    45.065    11.500     0.150
    46.059   498.660     0.150
    46.059   589.160     0.150
    47.527   504.160     0.150
    51.747   543.660     0.150
    51.747   988.160     0.150
    51.747  1010.160     0.150
    52.098   657.160     0.150
    52.098   542.260     0.150
    52.098   614.160     0.150
    52.098   657.160     0.150
    53.928    25.000     0.150
    53.928   559.160     0.150
    53.928    25.000     0.150
    60.686   605.660     0.150
    60.686  1106.160     0.150
    66.470   644.160     0.150
    67.225   648.660     0.150
    74.205   681.160     0.150
    76.011   702.160     0.150
    76.011  1288.160     0.150
    76.731   716.061     0.150
    76.607   704.160     0.150
    76.607    22.000     0.150
    76.877  1303.760     0.150
    80.262   724.260     0.150
    80.397   719.160     0.150
    80.553   729.160     0.150
    80.553   729.260     0.150
    80.553  1328.461     0.150
    81.166   728.859     0.150
    90.185   777.160     0.150
    90.185   777.160     0.150
    90.723   775.061     0.150
    94.575   797.461     0.150
    94.575   797.461     0.150
    96.058   804.160     0.150
    96.058   804.160     0.150
     0.679    20.656     0.150
     2.604    60.156     0.150
     4.532    75.156     0.150
    25.811   336.055     0.150
    27.856     3.500     0.150
    30.620   377.656     0.150
    32.067   387.156     0.150
    36.672   427.355     0.150
    36.672     3.402     0.150
    36.672     6.500     0.150
    42.629   476.406     0.150
    46.449   508.656     0.150
    46.449     9.801     0.150
    46.449    13.699     0.150
   101.491  7594.855     0.150
   165.842  1209.055     0.150
     0.669    17.855     0.150
     2.376    77.855     0.150
     2.480    68.855     0.150
    28.494   353.055     0.150
   101.546  7588.457     0.150
     1.932    37.746     0.150
     3.968    65.746     0.150
    32.408   386.746     0.150
    32.408    11.500     0.150
     0.428    12.933     0.150
     1.176    19.232     0.150
     1.176    33.232     0.150
     1.839    49.732     0.150
     1.600    31.032     0.150
     1.995    38.232     0.150
     3.063    51.433     0.150
     3.142    70.732     0.150
     5.720    93.532     0.150
     8.092   109.633     0.150
    26.860    10.650     0.150
    26.860   555.282     0.150
    27.832   356.053     0.150
    27.870    10.946     0.150
    31.361    10.250     0.150
    31.380    11.000     0.150
    34.122   572.683     0.150
    36.069    11.500     0.150
    37.333    15.200     0.150
    37.622    10.899     0.150
    39.832     9.800     0.150
    39.929   458.232     0.150
    41.115   469.192     0.150
    44.116    11.399     0.150
    48.903   537.032     0.150
    55.988   588.433     0.150
    64.798   650.232     0.150
    69.194    11.560     0.150
    77.140    12.000     0.150
    77.750    11.671     0.150
    85.722   768.133     0.150
    85.972    11.675     0.150
    92.886   800.133     0.150
    92.886    11.228     0.150
    95.607   816.732     0.150
    95.627   816.832     0.150
    96.513   817.232     0.150
    96.547    11.149     0.150
    97.699   825.832     0.150
    97.699   825.832     0.150
   119.146  1141.307     0.150
   145.988  1192.256     0.150
   165.465  1218.545     0.150
     1.347    25.436     0.150
     2.814    83.236     0.150
     2.849    48.936     0.150
     2.760    84.236     0.150
     2.851    36.936     0.150
     3.717    69.635     0.150
     4.653    68.736     0.150
     7.717   122.936     0.150
    21.427   544.936     0.150
    23.820   570.936     0.150
    27.173   624.936     0.150
    27.757   617.535     0.150
    32.327    14.000     0.150
    32.327    23.000     0.150
    36.931    12.900     0.150
    39.828   454.625     0.150
    41.027   463.826     0.150
    42.365   478.135     0.150
    50.984   541.236     0.150
    76.370   705.336     0.150
    80.063   723.635     0.150
    85.334   744.436     0.150
    91.932   785.535     0.150
     0.654    25.438     0.150
     1.633    26.035     0.150
     2.800    52.637     0.150
     5.356    76.336     0.150
    27.734   634.137     0.150
    29.949   672.137     0.150
    32.371    10.000     0.150
    32.371    16.000     0.150
    39.071   446.426     0.150
    39.183   448.746     0.150
    55.642   567.637     0.150
    85.376   751.938     0.150
     0.614     9.023     0.150
     1.382    19.625     0.150
     1.329    25.125     0.150
    26.439   340.273     0.150
    27.776   350.125     0.150
    39.005   445.746     0.150
     0.956    28.742     0.150
    30.875   370.414     0.150
    41.997   469.254     0.150
     1.202    19.637     0.150
     0.762    12.105     0.150
     0.762    20.045     0.150
     0.866    26.115     0.150
     2.227    68.045     0.150
     2.333    68.324     0.150
     2.678    43.025     0.150
     3.915    64.805     0.150
    26.382   340.305     0.150
    85.211   742.275     0.150
    94.733   795.055     0.150
     0.316    14.945     0.150
     1.180    42.273     0.150
    34.799   905.945     0.150
    41.712   464.246     0.150
    42.521   471.047     0.150
    44.101   583.645     0.150
    48.546   517.945     0.150
    51.414   542.945     0.150
    67.713   676.445     0.150
    82.831   739.645     0.150
    83.790   744.785     0.150
    85.256   752.246     0.150
    85.503   753.965     0.150
    87.663   766.695     0.150
    94.755   798.086     0.150
   112.202   872.547     0.150
   112.577   871.145     0.150
     0.858    25.914     0.150
     1.792    59.264     0.150
     2.211    71.244     0.150
     2.793    46.654     0.150
     3.294    79.064     0.150
     3.344    85.975     0.150
    26.289   333.070     0.150
     1.192    43.719     0.150
     5.227   100.570     0.150
    22.452   581.797     0.150
    23.174    10.398     0.150
    23.859   312.977     0.150
    25.187   585.195     0.150
    36.395   429.297     0.150
    40.357   457.570     0.150
    44.688   494.297     0.150
    50.910   541.797     0.150
    61.666  1107.094     0.150
    61.666   616.188     0.150
    82.402   739.000     0.150
    92.004   786.875     0.150
     0.210     6.500     0.150
     0.210    11.672     0.150
     1.289    21.289     0.150
     1.289    44.711     0.150
     2.253    67.719     0.150
     3.019    49.891     0.150
     3.544    59.258     0.150
     3.544   110.250     0.150
     5.917   102.914     0.150
    80.064   727.211     0.150
    94.346   798.148     0.150
     0.763    13.635     0.150
     1.179    42.954     0.150
     2.007    56.094     0.150
     2.228    69.404     0.150
     2.909    50.015     0.150
     5.603    90.727     0.150
     9.241   135.215     0.150
    17.030   239.865     0.150
    21.374   282.615     0.150
    21.374   512.414     0.150
    22.732    28.600     0.150
    22.732   536.814     0.150
    25.812    16.900     0.150
    25.812   627.314     0.150
    28.606   675.314     0.150
    32.980   712.814     0.150
    34.874    16.602     0.150
    40.665   457.615     0.150
    41.132   460.814     0.150
    41.224   462.514     0.150
    41.739   463.615     0.150
    42.548   470.514     0.150
    43.151   481.264     0.150
    44.540   490.215     0.150
    46.601    18.500     0.150
    46.601   909.814     0.150
    46.601   942.314     0.150
    48.546   517.615     0.150
    51.431   543.834     0.150
    51.431   616.795     0.150
    53.195   557.154     0.150
    61.204   612.514     0.150
    68.723   660.484     0.150
    79.668   718.314     0.150
    79.668   901.215     0.150
    79.668  1015.314     0.150
    79.668  1316.314     0.150
    80.930   759.115     0.150
    92.437   786.115     0.150
    92.437   786.834     0.150
    94.737   798.654     0.150
     0.327    15.256     0.150
     0.796    12.996     0.150
     1.192    41.285     0.150
     1.516    49.775     0.150
     2.201    64.314     0.150
     2.652    76.455     0.150
     2.551    74.936     0.150
     2.929    83.195     0.150
     3.281    82.125     0.150
     3.612   101.705     0.150
     3.755   104.096     0.150
     4.354   142.885     0.150
     4.895   130.906     0.150
     6.874   104.645     0.150
    21.385   291.176     0.150
    21.385     8.100     0.150
    23.737   315.576     0.150
    25.795    10.000     0.150
    25.795    40.400     0.150
    26.356   335.525     0.150
    28.596   361.076     0.150
    28.596     9.299     0.150
    28.596   638.375     0.150
    29.435   362.705     0.150
    32.254    26.000     0.150
    32.984   471.176     0.150
    39.503   472.906     0.150
    40.644   457.676     0.150
    40.935   459.076     0.150
    41.110   460.676     0.150
    41.202   460.275     0.150
    42.526   472.676     0.150
    46.593    12.699     0.150
    46.593   911.775     0.150
    51.010   548.975     0.150
    51.010   714.875     0.150
    79.965   723.205     0.150
    83.525   741.775     0.150
    83.802   747.395     0.150
    92.436   786.945     0.150
     0.395    14.762     0.150
     0.753    14.148     0.150
     1.060    51.000     0.150
     1.273    37.930     0.150
     1.940    32.461     0.150
     1.940    58.672     0.150
     2.001    32.980     0.150
     2.247    37.180     0.150
     2.502    40.711     0.150
     2.502    73.070     0.150
     2.760    81.230     0.150
     2.752    48.000     0.150
     2.755    58.000     0.150
     2.859    46.238     0.150
     3.343    52.512     0.150
     3.957    66.371     0.150
     3.957    66.012     0.150
     8.662   132.430     0.150
     8.744   216.738     0.150
    16.777     7.801     0.150
    21.518     8.301     0.150
    22.837   308.000     0.150
    22.837     9.301     0.150
    22.837    13.301     0.150
    23.591     6.699     0.150
    23.591    33.699     0.150
    29.600   359.898     0.150
    29.600   359.941     0.150
    31.040   375.289     0.150
    31.078   378.430     0.150
    33.036    10.801     0.150
    33.036    14.000     0.150
    35.130     9.301     0.150
    35.130    13.500     0.150
    35.130   560.500     0.150
    36.793    10.000     0.150
    36.793    14.500     0.150
    36.798   429.551     0.150
    39.658   451.980     0.150
    39.936   448.000     0.150
    40.677   460.699     0.150
    40.757   460.672     0.150
    40.854   462.301     0.150
    40.932   583.719     0.150
    45.012   497.000     0.150
    45.166   500.801     0.150
    45.166   910.301     0.150
    46.498     9.500     0.150
    46.498    12.500     0.150
    52.423   550.578     0.150
    55.462   574.570     0.150
    61.201   613.180     0.150
    68.651   661.738     0.150
    78.007   718.078     0.150
    79.992   726.922     0.150
    80.836   736.000     0.150
    85.240   756.398     0.150
    85.573   757.039     0.150
    87.239   767.352     0.150
    92.432   788.328     0.150
    92.420   788.898     0.150
    95.108   802.145     0.150
     1.099    32.059     0.150
     1.274    17.758     0.150
     1.274    46.410     0.150
     2.283    60.328     0.150
     2.487    70.859     0.150
     3.387    96.758     0.150
     3.562    58.559     0.150
     3.562   108.148     0.150
    44.660   489.121     0.150
     0.527    20.992     0.150
     0.870    14.133     0.150
     0.870    30.633     0.150
     1.179    23.492     0.150
     1.232    43.773     0.150
     1.469    24.773     0.150
     1.516    21.852     0.150
     1.516    43.023     0.150
     1.820    38.211     0.150
     2.432    42.562     0.150
     2.606    40.031     0.150
    29.019   363.008     0.150
    29.318   366.289     0.150
    51.811   545.812     0.150
    85.305   760.008     0.150
    85.873   761.211     0.150
     1.047    11.848     0.150
     1.047    20.277     0.150
     1.299    46.027     0.150
     2.405    36.598     0.150
     2.929    48.797     0.150
     2.977    65.449     0.150
    34.871   415.309     0.150
     0.761    23.916     0.150
     1.234    20.348     0.150
     1.493    52.797     0.150
     2.842   100.547     0.150
    30.996   379.211     0.150
    30.996   379.207     0.150
    34.388   408.688     0.150
    44.460   495.111     0.150
    44.460   495.107     0.150
    55.503   574.957     0.150
     0.481    20.954     0.150
     0.654    20.834     0.150
     0.957    14.744     0.150
     0.957    25.664     0.150
     1.260    22.895     0.150
     1.443    26.224     0.150
     2.075    60.564     0.150
     2.230    54.224     0.150
     2.817    81.114     0.150
     2.850    46.884     0.150
     3.305    96.895     0.150
     3.700    62.334     0.150
    15.101   217.174     0.150
    15.451   217.824     0.150
    15.451   220.364     0.150
    16.094   398.664     0.150
    17.007   242.764     0.150
    21.428    23.800     0.150
    21.428   523.064     0.150
    21.428   548.264     0.150
    21.428   286.864     0.150
    21.428    23.800     0.150
    21.428   523.064     0.150
    21.428   548.264     0.150
    22.769    17.000     0.150
    22.769    26.000     0.150
    22.769    33.000     0.150
    22.769   540.664     0.150
    23.673    26.500     0.150
    23.673    37.000     0.150
    23.673   615.264     0.150
    25.710    24.800     0.150
    25.710    43.200     0.150
    25.710   329.864     0.150
    25.710    13.200     0.150
    25.710    24.800     0.150
    25.710   385.964     0.150
    25.710   594.064     0.150
    25.710   621.164     0.150
    25.710   664.264     0.150
    25.710   682.364     0.150
    25.710   329.864     0.150
    25.710    13.200     0.150
    25.710   373.064     0.150
    25.710   385.964     0.150
    25.710   594.064     0.150
    25.710   664.264     0.150
    25.710   682.364     0.150
    26.326   334.264     0.150
    28.064   659.164     0.150
    28.543    15.500     0.150
    29.387   645.664     0.150
    29.519   359.464     0.150
    29.519    17.400     0.150
    29.862   370.164     0.150
    31.078   373.564     0.150
    31.011   374.864     0.150
    32.222   387.664     0.150
    32.222     9.500     0.150
    32.222    13.300     0.150
    32.222   456.064     0.150
    32.222   554.664     0.150
    32.222   699.664     0.150
    32.222   714.864     0.150
    32.222   816.664     0.150
    32.222   387.664     0.150
    32.222     9.500     0.150
    32.222    13.300     0.150
    32.222   456.064     0.150
    32.222   554.664     0.150
    32.222   699.664     0.150
    32.222   714.864     0.150
    32.222   816.664     0.150
    32.996    16.101     0.150
    34.490   560.514     0.150
    34.978    16.700     0.150
    34.978    25.300     0.150
    36.593   422.564     0.150
    36.824    18.300     0.150
    36.824    27.200     0.150
    36.824   921.264     0.150
    36.923   429.164     0.150
    39.564   559.664     0.150
    39.564   822.764     0.150
    39.556   448.164     0.150
    39.779   444.664     0.150
    40.717   457.864     0.150
    43.037   475.564     0.150
    45.127   502.964     0.150
    45.127   899.364     0.150
    45.225   495.164     0.150
    46.549    16.000     0.150
    46.549   907.664     0.150
    46.549  1091.664     0.150
    46.939   659.764     0.150
    46.939  1190.464     0.150
    48.603   517.364     0.150
    51.142   546.264     0.150
    51.142   981.964     0.150
    53.819   560.364     0.150
    56.189   578.984     0.150
    56.189   578.964     0.150
    61.162   610.874     0.150
    61.162   610.864     0.150
    68.685   658.964     0.150
    68.685  1459.064     0.150
    77.086   870.664     0.150
    77.086  1299.664     0.150
    77.412   712.764     0.150
    79.767   723.464     0.150
    80.882   731.064     0.150
    82.825   739.864     0.150
    85.249   752.164     0.150
    85.365   751.964     0.150
    85.843   754.234     0.150
    85.854   755.264     0.150
    88.742   772.145     0.150
    88.742   772.164     0.150
    89.051   774.264     0.150
    92.267   785.664     0.150
    92.422   785.084     0.150
    93.827   793.664     0.150
    94.893   798.954     0.150
    95.096   809.064     0.150
    95.096   809.084     0.150
   108.156  1797.715     0.150
   119.440  1126.334     0.150
   119.440  1750.385     0.150
     0.485    20.066     0.150
     0.963    14.707     0.150
     0.963    28.366     0.150
     1.258    42.526     0.150
     1.364    43.837     0.150
     1.334    26.477     0.150
     1.973    59.847     0.150
     2.068    60.297     0.150
     2.698    49.667     0.150
     2.698    69.807     0.150
     2.844    67.687     0.150
     2.900    53.161     0.150
     2.900    89.812     0.150
     5.729    78.767     0.150
    40.890   458.816     0.150
    44.537   488.877     0.150
    51.375   541.896     0.150
    92.427   784.446     0.150
     2.663    80.777     0.150
     2.697    45.055     0.150
     2.854    47.717     0.150
     3.969    67.247     0.150
    27.575   342.907     0.150
    37.043     7.300     0.150
    39.049   444.847     0.150
    39.158   445.146     0.150
    39.855   451.347     0.150
    40.426   456.146     0.150
    40.767   459.047     0.150
    41.055   461.847     0.150
    41.055   461.847     0.150
    41.232   463.447     0.150
    41.232   463.447     0.150
    41.323   463.947     0.150
    41.586  3054.843     0.150
    41.599  3055.924     0.150
    41.602  3056.111     0.150
    41.839   466.847     0.150
    41.924  3077.846     0.150
    41.932  3086.895     0.150
    41.942  3079.204     0.150
    42.645   473.646     0.150
    44.333   589.417     0.150
    55.191   569.737     0.150
    55.719   573.187     0.150
     0.262    14.414     0.150
     1.120    18.656     0.150
     1.857    18.844     0.150
     1.857    52.137     0.150
     2.798    45.434     0.150
     3.161    71.703     0.150
    26.641   338.375     0.150
    31.066   374.398     0.150
    31.066   550.824     0.150
    34.498   405.227     0.150
    34.498   560.324     0.150
    37.313   430.898     0.150
    40.923   459.648     0.150
    44.490   488.824     0.150
    51.563   544.250     0.150
    54.343   563.602     0.150
    77.537   713.574     0.150
    80.279   726.375     0.150
    84.799   752.227     0.150
    85.051   752.500     0.150
    85.608   755.926     0.150
    86.051   757.000     0.150
    94.564   796.895     0.150
   119.250  1125.977     0.150
     1.126    38.109     0.150
     1.371    15.812     0.150
     1.881    22.539     0.150
     1.881    29.691     0.150
     2.078    20.629     0.150
     2.078    50.371     0.150
    20.425   278.801     0.150
    26.585   339.852     0.150
    28.224   352.238     0.150
    31.398   379.090     0.150
    34.838   410.453     0.150
    40.599   460.453     0.150
    41.007  3040.949     0.150
    41.020  3050.059     0.150
    41.024  3048.316     0.150
    41.329  3072.895     0.150
    41.337  3074.074     0.150
    41.347  3075.270     0.150
    44.810   491.211     0.150
    50.085   532.910     0.150
    51.314   543.676     0.150
    51.754   546.340     0.150
    54.054   564.070     0.150
    79.908   726.340     0.150
    90.108   778.828     0.150
     0.961    15.285     0.150
     8.677   123.953     0.150
     9.016   140.977     0.150
    16.356   239.105     0.150
    26.229   338.246     0.150
    26.229   339.074     0.150
    26.327   339.094     0.150
     0.736    29.598     0.150
     0.790     3.121     0.150
     0.790    23.750     0.150
     1.126    32.582     0.150
     1.888    60.480     0.150
     2.465    87.980     0.150
     2.757    54.367     0.150
     3.563   115.891     0.150
     1.042    15.148     0.150
     1.715    26.039     0.150
     2.027    31.039     0.150
     2.615    46.961     0.150
     2.615   104.531     0.150
     2.666    45.613     0.150
     3.276    58.430     0.150
     8.951   136.070     0.150
    12.903   205.570     0.150
    13.523   200.969     0.150
    14.102   220.371     0.150
    15.021   216.590     0.150
    18.879   264.770     0.150
    18.996   255.969     0.150
    32.409    20.199     0.150
    32.409    29.398     0.150
    46.679    35.500     0.150
    51.516   616.039     0.150
    52.278    23.500     0.150
    92.674   786.871     0.150
    95.587    25.277     0.150
     1.042    31.164     0.150
     1.219    28.266     0.150
     1.262    25.539     0.150
     1.378    39.508     0.150
     3.530    52.328     0.150
    19.517   271.383     0.150
    30.814   377.594     0.150
     0.178     5.377     0.150
     0.178    14.127     0.150
     0.576    17.775     0.150
     0.576    26.957     0.150
     0.237     8.641     0.150
     0.936    14.492     0.150
     1.346    20.695     0.150
     1.362    47.117     0.150
     1.761    26.016     0.150
     1.956    27.516     0.150
     2.051    34.578     0.150
     2.709    46.016     0.150
     2.749   101.531     0.150
     2.816   100.891     0.150
     3.040    86.242     0.150
     3.379    47.422     0.150
    30.915   376.820     0.150
    30.915   376.820     0.150
    46.943   507.195     0.150
    56.754   584.336     0.150
    76.682   713.195     0.150
     0.279     4.195     0.150
     0.279    12.205     0.150
     0.413     7.515     0.150
     0.413    16.905     0.150
     0.972    16.785     0.150
     0.972    43.425     0.150
     2.148    70.105     0.150
     2.077    66.895     0.150
     3.062    95.755     0.150
     3.204    53.812     0.150
     3.204    50.285     0.150
     3.204    72.265     0.150
     4.268   138.285     0.150
     5.235   143.905     0.150
     7.015   107.115     0.150
     7.086   111.925     0.150
     8.359   127.495     0.150
     8.648   217.725     0.150
     8.692   136.885     0.150
    10.650  3166.885     0.150
    10.661   162.445     0.150
    10.951   161.785     0.150
    13.179   190.285     0.150
    13.663   194.835     0.150
    13.886   201.885     0.150
    14.506   206.255     0.150
    15.825   403.785     0.150
    16.457    13.700     0.150
    16.457   410.485     0.150
    20.202   276.185     0.150
    20.682   502.060     0.150
    20.682   278.885     0.150
    20.714   278.535     0.150
    21.248   291.385     0.150
    21.248   523.185     0.150
    21.364   291.985     0.150
    21.616   295.185     0.150
    21.618   305.685     0.150
    22.194   296.905     0.150
    22.240   300.985     0.150
    22.297   296.085     0.150
    22.552     5.900     0.150
    22.552     8.700     0.150
    23.324   550.890     0.150
    23.237   314.885     0.150
    23.324   312.985     0.150
    23.263     9.100     0.150
    23.263    17.100     0.150
    23.568   315.485     0.150
    24.453   323.185     0.150
    24.921   322.785     0.150
    25.341   331.585     0.150
    25.269   325.545     0.150
    25.747  2304.035     0.150
    25.747   329.555     0.150
    25.845   332.454     0.150
    25.845   332.454     0.150
    25.845   330.095     0.150
    25.957   538.210     0.150
    26.602   338.385     0.150
    27.043   347.085     0.150
    27.233   347.085     0.150
    27.631   344.565     0.150
    27.631  2293.185     0.150
    27.736   347.315     0.150
    28.150   644.685     0.150
    29.461   547.645     0.150
    29.461   360.845     0.150
    29.461  2289.072     0.150
    29.593   654.185     0.150
    29.960  2286.880     0.150
    29.960   365.645     0.150
    30.787   380.695     0.150
    30.793   374.235     0.150
    31.161   386.055     0.150
    31.161   386.055     0.150
    31.348  2283.709     0.150
    31.553   380.295     0.150
    31.795    11.900     0.150
    31.795   698.485     0.150
    31.868     9.700     0.150
    33.787   716.385     0.150
    34.232   403.975     0.150
    34.734  2268.485     0.150
    34.912     8.600     0.150
    34.912    12.800     0.150
    36.469     7.400     0.150
    36.469    10.700     0.150
    36.469   762.785     0.150
    36.469   907.185     0.150
    36.968   756.235     0.150
    36.968   563.385     0.150
    36.968   427.725     0.150
    36.968   563.345     0.150
    38.465   441.985     0.150
    38.910   554.985     0.150
    38.910   995.885     0.150
    38.910  1044.585     0.150
    40.199   472.885     0.150
    40.457   458.105     0.150
    40.457   458.105     0.150
    40.457   574.585     0.150
    40.457   457.845     0.150
    40.457   574.625     0.150
    40.630   458.015     0.150
    40.726   579.485     0.150
    40.726  1054.385     0.150
    42.128  3076.795     0.150
    42.141  3077.799     0.150
    42.144  3079.880     0.150
    42.452  3104.979     0.150
    42.460  3108.949     0.150
    42.470  3106.315     0.150
    42.855   610.085     0.150
    42.855  1094.985     0.150
    42.911   477.785     0.150
    42.911   477.815     0.150
    43.086   482.254     0.150
    43.086   482.254     0.150
    44.068   492.535     0.150
    44.816   873.735     0.150
    44.738   497.385     0.150
    44.738   846.885     0.150
    44.738   497.375     0.150
    44.866   493.754     0.150
    44.866   493.754     0.150
    44.866   887.685     0.150
    44.866  1136.785     0.150
    45.166   906.985     0.150
    45.175   905.585     0.150
    46.171   504.855     0.150
    48.470   683.185     0.150
    48.470   946.585     0.150
    49.269   532.055     0.150
    49.913   531.585     0.150
    49.913   959.885     0.150
    50.328   532.935     0.150
    50.328   606.215     0.150
    50.796   539.395     0.150
    50.889   539.825     0.150
    50.671   540.685     0.150
    50.671   978.485     0.150
    51.004  2795.610     0.150
    51.328   543.255     0.150
    51.239   544.185     0.150
    51.239   981.385     0.150
    51.194   612.185     0.150
    51.194   542.205     0.150
    51.194   612.225     0.150
    51.227   542.685     0.150
    51.227   985.485     0.150
    51.590   545.185     0.150
    51.590   988.785     0.150
    51.593   545.485     0.150
    51.593   983.485     0.150
    51.621   545.385     0.150
    51.855   983.485     0.150
    52.131   549.255     0.150
    52.191    21.800     0.150
    52.191   661.885     0.150
    52.465  1000.985     0.150
    52.536   551.585     0.150
    52.536  1002.885     0.150
    52.550   552.585     0.150
    52.648   556.185     0.150
    52.648  1007.685     0.150
    52.703   554.165     0.150
    52.866   553.985     0.150
    52.934   555.585     0.150
    53.309   557.885     0.150
    53.309  1014.585     0.150
    53.485   555.755     0.150
    53.908  2806.760     0.150
    54.048   564.254     0.150
    54.048   563.805     0.150
    54.093   562.785     0.150
    54.093  1023.685     0.150
    54.283   565.115     0.150
    55.138  2811.403     0.150
    55.734   575.725     0.150
    56.315   579.485     0.150
    56.702   579.085     0.150
    56.702   579.035     0.150
    56.952   584.235     0.150
    56.952   583.835     0.150
    56.984   584.085     0.150
    56.984  1066.885     0.150
    58.149   591.985     0.150
    58.149  1077.385     0.150
    58.641   593.625     0.150
    60.726  2832.953     0.150
    60.798   610.555     0.150
    61.762  1119.094     0.150
    61.762   615.285     0.150
    61.762   615.385     0.150
    62.906   628.853     0.150
    63.314   631.853     0.150
    63.314   631.853     0.150
    63.502   626.815     0.150
    63.628   630.960     0.150
    64.116   633.853     0.150
    64.116   633.853     0.150
    64.163   633.953     0.150
    64.260   633.853     0.150
    64.422   864.285     0.150
    64.688   641.093     0.150
    64.688   641.093     0.150
    64.841   637.853     0.150
    64.948   638.853     0.150
    65.567   642.853     0.150
    65.766   641.630     0.150
    65.766   646.853     0.150
    65.766   646.853     0.150
    65.769   644.853     0.150
    65.850   648.454     0.150
    65.850   648.454     0.150
    66.342   647.933     0.150
    66.341   649.005     0.150
    66.341   649.005     0.150
    66.580   650.863     0.150
    66.647   650.003     0.150
    67.242   657.863     0.150
    67.242   657.863     0.150
    67.520   663.723     0.150
    67.964   658.913     0.150
    68.348   660.853     0.150
    68.348   660.853     0.150
    68.348   660.853     0.150
    68.621   665.246     0.150
    68.838   664.873     0.150
    69.177   667.918     0.150
    73.471   851.385     0.150
    73.471   957.285     0.150
    75.279   699.885     0.150
    75.279   699.845     0.150
    75.666   703.375     0.150
    76.446   709.701     0.150
    76.985  1297.285     0.150
    76.985   710.745     0.150
    77.542   716.885     0.150
    77.791   717.004     0.150
    79.148   725.185     0.150
    79.149    11.500     0.150
    79.241   726.085     0.150
    79.241   911.685     0.150
    79.526   728.535     0.150
    79.526   731.035     0.150
    79.526   731.105     0.150
    79.526   731.105     0.150
    79.526  1333.215     0.150
    79.874   746.185     0.150
    79.874   905.885     0.150
    79.874  1334.385     0.150
    80.509   749.985     0.150
    80.509  1019.585     0.150
    80.509  1341.285     0.150
    80.509  1848.285     0.150
    80.951   733.325     0.150
    81.161  1025.885     0.150
    82.402   741.885     0.150
    82.500   741.085     0.150
    82.621   747.885     0.150
    82.837   750.335     0.150
    83.034   746.985     0.150
    83.034  1045.885     0.150
    83.393   743.185     0.150
    83.628   738.285     0.150
    83.765   747.285     0.150
    83.868   752.715     0.150
    83.868  1384.305     0.150
    83.974   754.945     0.150
    84.386   751.285     0.150
    84.507   751.465     0.150
    84.507   751.465     0.150
    84.507   751.505     0.150
    84.684   752.075     0.150
    85.600   756.885     0.150
    85.600   954.885     0.150
    85.600  1066.885     0.150
    85.600  1370.885     0.150
    85.600  1728.885     0.150
    85.600  1954.885     0.150
    85.600  2586.885     0.150
    85.600   756.885     0.150
    85.600   954.885     0.150
    85.600  1066.885     0.150
    85.600  1370.885     0.150
    85.600  1386.885     0.150
    85.600  1450.885     0.150
    85.600  1728.885     0.150
    86.120   981.885     0.150
    86.120  1478.885     0.150
    86.120  1748.885     0.150
    86.120  2000.885     0.150
    86.374   981.885     0.150
    86.374  1075.885     0.150
    86.374  1428.885     0.150
    86.374  1648.885     0.150
    86.374  1828.885     0.150
    86.374   762.385     0.150
    86.374  1075.885     0.150
    86.374  1377.885     0.150
    86.374  1398.885     0.150
    86.374  1478.885     0.150
    86.374   767.253     0.150
    87.028   765.004     0.150
    87.028   764.985     0.150
    87.028   768.715     0.150
    87.028   775.465     0.150
    87.028   775.465     0.150
    87.028   764.955     0.150
    87.127   765.451     0.150
    87.296   768.185     0.150
    88.036   762.637     0.150
    88.078   772.285     0.150
    88.370   769.335     0.150
    88.370   769.335     0.150
    88.370  1416.145     0.150
    88.370  1416.145     0.150
    88.744  1786.585     0.150
    88.893   777.185     0.150
    88.893  1494.485     0.150
    89.545   782.685     0.150
    89.555   782.385     0.150
    89.454   781.934     0.150
    89.755   783.485     0.150
    89.884   784.285     0.150
    89.763   784.271     0.150
    89.772   776.835     0.150
    89.772   776.835     0.150
    89.772  1427.395     0.150
    89.772  1427.395     0.150
    89.845   773.285     0.150
    90.229   779.985     0.150
    90.269  1448.922     0.150
    90.269  1812.896     0.150
    90.296   792.985     0.150
    90.296   801.485     0.150
    90.296  1405.085     0.150
    90.348   782.155     0.150
    90.348   782.155     0.150
    90.348  1429.625     0.150
    90.348  1429.625     0.150
    90.678   787.885     0.150
    90.572   787.385     0.150
    90.786   780.945     0.150
    90.810   781.285     0.150
    90.810   781.285     0.150
    90.882  1452.944     0.150
    90.882  1832.919     0.150
    91.016   782.885     0.150
    91.035   774.685     0.150
    91.230   783.275     0.150
    91.340   784.035     0.150
    91.340   784.035     0.150
    91.340  1436.425     0.150
    91.340  1436.425     0.150
    91.340  1816.905     0.150
    91.340  1816.905     0.150
    91.416   783.935     0.150
    91.416   783.935     0.150
    91.416  1435.915     0.150
    91.416  1435.915     0.150
    91.416  1808.145     0.150
    91.416  1808.145     0.150
    91.491   785.985     0.150
    91.491  1014.685     0.150
    91.566  1836.875     0.150
    91.937   796.044     0.150
    91.939   789.385     0.150
    91.972   789.835     0.150
    91.972   789.835     0.150
    91.972  1439.185     0.150
    91.972  1439.185     0.150
    92.014   785.555     0.150
    92.034  1467.922     0.150
    92.034  1837.947     0.150
    92.084  1847.515     0.150
    92.103   785.985     0.150
    92.536   790.385     0.150
    92.536  1026.185     0.150
    92.536  1846.385     0.150
    92.546   787.685     0.150
    92.546   787.685     0.150
    92.546  1856.185     0.150
    92.547   785.185     0.150
    92.611   797.585     0.150
    92.611   797.585     0.150
    92.659   793.415     0.150
    92.725   795.930     0.150
    92.865   784.685     0.150
    93.022   797.361     0.150
    92.937   794.785     0.150
    92.937  2681.385     0.150
    93.102  1471.467     0.150
    93.044   792.785     0.150
    93.080   793.285     0.150
    93.154  2694.685     0.150
    93.303   797.385     0.150
    93.303  1848.685     0.150
    93.356   793.495     0.150
    93.337   794.615     0.150
    93.337   794.615     0.150
    93.337  1446.225     0.150
    93.337  1446.225     0.150
    93.361   799.951     0.150
    93.505  1437.458     0.150
    93.456   796.915     0.150
    93.488   803.085     0.150
    93.488   794.085     0.150
    93.488  1836.585     0.150
    93.534   789.785     0.150
    93.541  1867.195     0.150
    93.559   798.885     0.150
    93.721  1859.868     0.150
    93.620   794.485     0.150
    93.620  1835.685     0.150
    93.675   798.085     0.150
    93.675  2699.985     0.150
    93.703   802.085     0.150
    93.703   802.085     0.150
    93.727  1034.185     0.150
    93.727  1858.285     0.150
    93.782   801.892     0.150
    93.782  1503.910     0.150
    93.980  1442.484     0.150
    93.980  1868.824     0.150
    93.881  2702.685     0.150
    93.966   784.665     0.150
    94.145  1865.242     0.150
    94.159  1868.824     0.150
    94.357  1529.565     0.150
    94.378  1884.947     0.150
    94.380  1875.990     0.150
    94.381  1872.407     0.150
    94.360   797.685     0.150
    94.360  1860.885     0.150
    94.544  1886.738     0.150
    94.475   803.385     0.150
    94.475  1846.085     0.150
    94.489   787.685     0.150
    94.506  1484.910     0.150
    94.506  1870.903     0.150
    94.566   802.485     0.150
    94.566  1846.985     0.150
    94.707  1576.327     0.150
    94.707  1883.155     0.150
    94.707  2083.786     0.150
    94.601  1034.018     0.150
    94.773  1872.407     0.150
    94.687   799.485     0.150
    94.687  1466.485     0.150
    94.718   820.885     0.150
    94.718  1017.885     0.150
    94.718   799.185     0.150
    94.718   820.885     0.150
    94.718  1470.885     0.150
    94.718  1542.885     0.150
    94.718  1848.885     0.150
    94.723   802.985     0.150
    94.723  1851.585     0.150
    95.003  1892.112     0.150
    95.040   808.385     0.150
    95.040   808.385     0.150
    95.174  1879.572     0.150
    95.103   799.885     0.150
    95.103   835.885     0.150
    95.103  1037.885     0.150
    95.103  1053.885     0.150
    95.103  1172.885     0.150
    95.103  1274.885     0.150
    95.103  1473.885     0.150
    95.103  1636.885     0.150
    95.103  1674.885     0.150
    95.103  1810.885     0.150
    95.103  1841.885     0.150
    95.103  2090.885     0.150
    95.103  2210.885     0.150
    95.103  2318.885     0.150
    95.103  2534.885     0.150
    95.393   811.248     0.150
    95.393  2096.325     0.150
    95.632   810.291     0.150
    95.632  1581.995     0.150
    95.632  1899.277     0.150
    95.566  1041.709     0.150
    95.670   816.037     0.150
    95.670  1583.412     0.150
    95.587   802.485     0.150
    95.618   802.935     0.150
    95.634  1042.763     0.150
    95.672   809.085     0.150
    95.672  1054.685     0.150
    95.653   812.775     0.150
    95.800  1890.321     0.150
    95.844   815.885     0.150
    95.844   805.185     0.150
    95.844  1874.085     0.150
    95.937   808.877     0.150
    96.118   808.975     0.150
    96.118  1283.015     0.150
    96.118  1506.005     0.150
    96.118  1576.905     0.150
    96.118  2158.655     0.150
    96.262   816.995     0.150
    96.262  1899.277     0.150
    96.477  1048.785     0.150
    96.517   810.985     0.150
    96.499   811.393     0.150
    96.499  1045.684     0.150
    96.897   808.885     0.150
    97.188    11.000     0.150
    97.153  1052.035     0.150
    97.513  1054.849     0.150
    97.804  1057.578     0.150
    98.836   812.955     0.150
   100.296   818.405     0.150
   100.973   827.605     0.150
   101.000   831.185     0.150
   100.974   823.055     0.150
   101.200   821.715     0.150
   101.280   824.195     0.150
   101.284   823.105     0.150
   101.573   825.885     0.150
   101.793   825.665     0.150
   101.848   824.455     0.150
   101.963   827.225     0.150
   102.000   827.325     0.150
   102.174   827.795     0.150
   102.416   825.485     0.150
   102.842   828.775     0.150
   103.021   831.445     0.150
   103.028   832.505     0.150
   103.337   833.665     0.150
   103.357   832.025     0.150
   103.421   833.125     0.150
   103.449   833.185     0.150
   105.056   840.255     0.150
   108.673   860.785     0.150
   111.570   880.985     0.150
   112.074  1117.945     0.150
   112.074   880.476     0.150
   112.125   884.685     0.150
   112.125  1118.885     0.150
   112.471   873.135     0.150
   112.380   887.885     0.150
   112.393  1119.585     0.150
   112.460   888.885     0.150
   112.472  1119.285     0.150
   113.381   891.585     0.150
   113.381  2130.785     0.150
   113.687   890.985     0.150
   113.747   893.045     0.150
   114.087   894.105     0.150
   114.114   893.485     0.150
   114.280  1127.785     0.150
   114.303   898.515     0.150
   114.330   902.645     0.150
   114.330  1767.485     0.150
   114.781   898.285     0.150
   114.838   896.385     0.150
   114.845   889.285     0.150
   114.845  1118.985     0.150
   114.845  1177.485     0.150
   114.845  2133.084     0.150
   114.853   898.085     0.150
   114.879   895.685     0.150
   114.879  1183.385     0.150
   114.901   889.585     0.150
   114.901  1177.885     0.150
   114.901  2133.785     0.150
   115.013   897.185     0.150
   115.013  1126.685     0.150
   115.210   900.805     0.150
   115.210  1775.985     0.150
   115.438   891.785     0.150
   115.438  1120.085     0.150
   115.438  1181.485     0.150
   121.817  1134.305     0.150
   122.004  1132.375     0.150
   123.373  1137.929     0.150
   123.614  1141.185     0.150
   123.688   936.285     0.150
   123.688  2271.985     0.150
   124.360  1135.695     0.150
   124.846  1139.625     0.150
   125.243  1140.741     0.150
   125.243  1137.785     0.150
   125.243  1137.785     0.150
   144.863  1174.195     0.150
   145.494  1187.625     0.150
   145.779  1178.205     0.150
   149.603  1185.715     0.150
   149.603  1185.715     0.150
   150.397  1187.755     0.150
   150.397  1187.755     0.150
   150.397  1188.725     0.150
   151.455  1189.485     0.150
   151.455  1189.475     0.150
   151.717  1190.455     0.150
   152.286  1193.045     0.150
   152.420  1193.655     0.150
   152.562  1191.185     0.150
   152.562  1191.185     0.150
   153.190  1186.085     0.150
   153.190  1195.775     0.150
   153.229  1192.355     0.150
   153.229  1192.355     0.150
   153.263  1190.845     0.150
   153.708  1192.935     0.150
   153.708  1192.935     0.150
   153.775  1191.945     0.150
   154.105  1192.765     0.150
   154.103  1195.155     0.150
   154.430  1199.645     0.150
   154.445  1190.505     0.150
   154.612  1194.035     0.150
   154.784  1193.925     0.150
   154.970  1194.185     0.150
   155.050  1185.985     0.150
   155.050  1977.685     0.150
   155.050  2955.385     0.150
   155.024  1195.425     0.150
   155.024  1195.425     0.150
   154.983  1199.115     0.150
   154.983  1200.375     0.150
   155.164  1198.045     0.150
   155.195  1202.395     0.150
   155.210  1200.845     0.150
   155.373  1191.025     0.150
   155.322  1199.525     0.150
   155.454  1196.485     0.150
   155.454  1196.485     0.150
   155.447  1192.535     0.150
   155.510  1194.425     0.150
   155.538  1195.145     0.150
   155.538  1195.145     0.150
   155.687  1195.315     0.150
   155.714  1195.335     0.150
   155.720  1196.695     0.150
   155.720  1196.695     0.150
   155.710  1195.855     0.150
   155.710  1200.915     0.150
   155.920  1195.705     0.150
   155.930  1194.695     0.150
   155.886  1202.465     0.150
   156.008  1197.465     0.150
   156.008  1197.465     0.150
   156.021  1195.935     0.150
   156.021  1200.915     0.150
   156.093  1197.135     0.150
   156.093  1197.135     0.150
   156.224  1200.515     0.150
   156.224  1200.515     0.150
   156.210  1196.065     0.150
   156.240  1196.065     0.150
   156.293  1197.435     0.150
   156.293  1197.435     0.150
   156.272  1197.005     0.150
   156.272  1197.005     0.150
   156.294  1196.545     0.150
   156.294  1196.545     0.150
   156.294  1192.215     0.150
   156.387  1196.365     0.150
   156.387  1196.365     0.150
   156.402  1201.035     0.150
   156.546  1197.855     0.150
   156.546  1197.855     0.150
   156.792  1196.785     0.150
   156.818  1197.255     0.150
   156.820  1205.195     0.150
   156.822  1202.455     0.150
   156.915  1199.285     0.150
   156.915  1199.285     0.150
   156.875  1206.325     0.150
   157.151  1197.265     0.150
   157.311  1197.915     0.150
   157.311  1197.915     0.150
   157.365  1197.985     0.150
   157.365  1197.985     0.150
   157.384  1201.485     0.150
   157.384  1231.955     0.150
   157.503  1197.165     0.150
   157.666  1203.315     0.150
   157.666  1203.315     0.150
   158.447  1200.055     0.150
   158.447  1205.965     0.150
   158.536  1195.205     0.150
   158.645  1196.715     0.150
   158.651  1201.495     0.150
   158.748  1199.125     0.150
   163.614  1200.415     0.150
   170.383  1278.785     0.150
   170.383  1205.075     0.150
   170.383  1278.745     0.150
   172.809  1207.355     0.150
     0.437    18.067     0.150
     0.995    23.117     0.150
     1.264    24.227     0.150
    14.526   200.797     0.150
    27.769   345.317     0.150
    34.707   410.475     0.150
     0.306     2.188     0.150
     1.589    38.098     0.150
    11.081   154.048     0.150
    26.034   334.298     0.150
    56.582   584.188     0.150
    78.827   719.018     0.150
     0.370    14.316     0.150
     0.370    23.986     0.150
     0.841    20.736     0.150
     1.236    39.416     0.150
    10.989   155.316     0.150
    21.629   288.826     0.150
    31.394   383.486     0.150
    13.231   183.662     0.150
    14.478   199.732     0.150
    19.826   272.352     0.150
    21.890   287.622     0.150
    25.558   325.002     0.150
   146.671  1182.377     0.150
     1.130     9.950     0.150
     1.130    18.880     0.150
     0.700    22.930     0.150
     2.289    45.610     0.150
    15.565   224.389     0.150
    21.774   284.960     0.150
    23.483   313.945     0.150
    25.814   333.534     0.150
    26.096   336.620     0.150
    26.096   330.260     0.150
     1.056    25.510     0.150
     1.431    48.990     0.150
     8.430   212.730     0.150
     0.364     7.376     0.150
     0.364    13.597     0.150
     1.166    40.737     0.150
     2.066    65.807     0.150
     3.235    80.497     0.150
     9.705   137.167     0.150
    11.034   164.536     0.150
    13.990   202.437     0.150
    14.174   204.737     0.150
    14.517   210.737     0.150
    14.837   214.636     0.150
    15.520   227.237     0.150
    15.520   218.156     0.150
    15.976   233.036     0.150
    17.213   236.077     0.150
    18.591   252.646     0.150
    18.937   263.136     0.150
    20.062   277.937     0.150
    20.665   279.536     0.150
    21.020   286.036     0.150
    21.722   294.636     0.150
    21.858   298.136     0.150
    22.345   301.737     0.150
    22.737   307.737     0.150
    23.815   308.817     0.150
    24.679   324.636     0.150
    25.178   330.636     0.150
    25.280   579.537     0.150
    25.280   645.037     0.150
    25.280   326.267     0.150
    25.351   335.937     0.150
    25.790   331.027     0.150
    25.886   329.566     0.150
    26.925   343.537     0.150
    27.549   346.277     0.150
    27.573   350.037     0.150
    27.705   346.477     0.150
    29.363   360.126     0.150
    29.948   365.086     0.150
    30.736   371.437     0.150
    30.736   371.396     0.150
    31.845    11.500     0.150
    31.845    15.000     0.150
    34.258   405.167     0.150
    34.785   408.227     0.150
    34.766   408.656     0.150
    34.766   408.667     0.150
    36.447     7.300     0.150
    36.447    11.000     0.150
    36.490   425.797     0.150
    36.791   427.707     0.150
    36.983   426.737     0.150
    39.328   447.886     0.150
    40.410   456.316     0.150
    40.583   458.227     0.150
    41.169   465.182     0.150
    44.858   492.737     0.150
    46.156   502.747     0.150
    50.829   543.937     0.150
    50.789   536.866     0.150
    51.369   541.937     0.150
    52.017   548.136     0.150
    52.112   728.136     0.150
    52.112   989.937     0.150
    52.150   550.126     0.150
    52.324   551.027     0.150
    52.552   553.366     0.150
    53.004   555.707     0.150
    53.877   561.336     0.150
    54.413   572.757     0.150
    55.753   576.307     0.150
    56.952   584.267     0.150
    56.952   584.336     0.150
    56.952   584.267     0.150
    64.958   639.697     0.150
    65.806   645.696     0.150
    68.305  1455.437     0.150
    75.516   700.687     0.150
    75.709   704.257     0.150
    76.456   706.727     0.150
    78.053   716.326     0.150
    78.860   720.146     0.150
    79.771   725.636     0.150
    84.071   748.287     0.150
    84.071   748.447     0.150
    84.695   752.287     0.150
    85.327   754.217     0.150
    85.441   755.797     0.150
    85.441   754.787     0.150
    86.469   760.028     0.150
    87.106   763.826     0.150
    87.930   770.146     0.150
    88.013   771.402     0.150
    88.069   774.037     0.150
    88.069   774.069     0.150
    88.204   774.097     0.150
    88.354   769.017     0.150
    88.711   770.324     0.150
    88.711   770.336     0.150
    88.630   775.836     0.150
    88.630   775.831     0.150
    88.642   773.537     0.150
    88.642   773.552     0.150
    90.263   770.149     0.150
    90.289   784.737     0.150
    90.289   797.636     0.150
    90.500   782.031     0.150
    91.707   776.252     0.150
    92.070   785.937     0.150
    92.528   793.836     0.150
    92.528   845.136     0.150
    93.971   799.836     0.150
    93.971   799.876     0.150
    95.087   799.437     0.150
    95.087  1026.437     0.150
    95.625   800.856     0.150
    95.931   803.513     0.150
    97.285   816.237     0.150
    97.779  1084.121     0.150
    98.159   811.698     0.150
   121.711  1132.336     0.150
   125.140  1138.947     0.150
   146.734  1180.586     0.150
   151.515  1190.707     0.150
   153.602  1197.787     0.150
   154.506  1198.596     0.150
   154.918  1199.816     0.150
   155.267  1191.136     0.150
   155.405  1201.987     0.150
   155.405  1201.987     0.150
   155.612  1191.866     0.150
   155.986  1203.537     0.150
   155.986  1203.537     0.150
   156.165  1192.396     0.150
   156.190  1197.957     0.150
   156.190  1197.957     0.150
   156.282  1194.547     0.150
   157.045  1194.017     0.150
   158.431  1199.197     0.150
   158.431  1199.197     0.150
     0.886    18.454     0.150
    30.348   373.324     0.150
    34.917   409.534     0.150
    34.917   412.474     0.150
    69.388   666.264     0.150
     0.513     8.331     0.150
     0.513    14.611     0.150
     1.337    22.001     0.150
     3.104    41.021     0.150
     9.559   130.211     0.150
    18.418   249.221     0.150
    22.524   302.791     0.150
    52.251   546.771     0.150
    55.237   574.011     0.150
    61.319   616.801     0.150
    92.204   791.391     0.150
     0.250     3.716     0.150
     0.250     6.546     0.150
     0.419     7.626     0.150
     0.872    16.396     0.150
     3.211    79.177     0.150
     6.353    97.776     0.150
     8.613   218.466     0.150
    10.936   161.976     0.150
    14.725   216.076     0.150
    15.407   216.937     0.150
    15.443   211.616     0.150
    15.825   226.876     0.150
    21.587   286.216     0.150
    21.792   301.876     0.150
    22.229   289.956     0.150
    22.268   301.476     0.150
    25.250   581.376     0.150
    25.250   325.956     0.150
    25.271   331.476     0.150
    25.720   332.802     0.150
    25.720   330.066     0.150
    25.818   329.906     0.150
    26.574   344.776     0.150
    27.646   344.846     0.150
    27.730    12.800     0.150
    27.730   346.486     0.150
    29.979   364.366     0.150
    30.387   372.121     0.150
    30.797   373.656     0.150
    31.522   381.216     0.150
    31.860     9.000     0.150
    31.860    12.600     0.150
    33.805   397.476     0.150
    33.931   402.396     0.150
    34.209   404.496     0.150
    34.869   407.476     0.150
    34.869   407.486     0.150
    34.869   410.326     0.150
    34.927   408.496     0.150
    36.455   423.406     0.150
    36.460     4.300     0.150
    36.460     7.300     0.150
    40.458   456.126     0.150
    43.868   486.375     0.150
    44.818   491.667     0.150
    46.159   503.826     0.150
    50.913   537.476     0.150
    50.913   537.516     0.150
    50.993   614.266     0.150
    51.183   540.576     0.150
    51.183   540.626     0.150
    51.264   537.876     0.150
    51.331   541.356     0.150
    51.332   543.836     0.150
    51.838   984.177     0.150
    52.110   548.826     0.150
    52.536   551.576     0.150
    52.990   555.536     0.150
    54.396   564.726     0.150
    55.128   570.096     0.150
    55.713   575.706     0.150
    55.764   575.306     0.150
    56.740   584.177     0.150
    56.740   579.677     0.150
    56.936   584.006     0.150
    56.936   583.776     0.150
    57.253   585.766     0.150
    64.442   867.076     0.150
    75.639   703.816     0.150
    76.316   706.376     0.150
    76.428   709.266     0.150
    76.694   699.876     0.150
    79.135   720.177     0.150
    80.499  1023.677     0.150
    81.158   738.776     0.150
    84.040   748.566     0.150
    85.446   753.996     0.150
    86.994   764.568     0.150
    86.994   763.927     0.150
    88.593   769.177     0.150
    88.618   767.677     0.150
    90.816   780.076     0.150
    91.692   774.818     0.150
    92.097   787.076     0.150
    95.574   803.276     0.150
   121.848  1132.056     0.150
   144.897  1175.096     0.150
   149.636  1186.996     0.150
   166.584  1202.976     0.150
   166.584  1202.996     0.150
     2.302    39.615     0.150
    50.978   540.405     0.150
    50.978   540.402     0.150
    50.978   539.935     0.150
    50.978   539.995     0.150
    51.168   541.795     0.150
    55.106   572.125     0.150
    77.726   713.885     0.150
    79.158   720.915     0.150
    79.756   723.495     0.150
     0.670    28.468     0.150
     0.422     6.756     0.150
     0.422    12.815     0.150
     1.126    42.365     0.150
     2.048    63.406     0.150
     2.283    37.565     0.150
     3.114    90.966     0.150
     3.221    58.125     0.150
    14.557   208.236     0.150
    18.791   259.135     0.150
    25.567   334.635     0.150
    36.422     7.200     0.150
    36.422    11.100     0.150
    39.599   452.760     0.150
    51.156   540.816     0.150
    80.579   732.736     0.150
     0.430    14.853     0.150
     2.312    74.993     0.150
     3.255    49.143     0.150
    13.574   189.383     0.150
    14.033   208.803     0.150
    27.510   339.663     0.150
    34.811   408.073     0.150
     0.362    10.271     0.150
     0.404     1.611     0.150
     0.404     7.541     0.150
     0.745     7.861     0.150
     1.062    24.291     0.150
     1.199    16.471     0.150
     1.763    51.531     0.150
     2.208    66.061     0.150
     2.249    37.841     0.150
     2.605    75.881     0.150
     3.170    93.041     0.150
     5.321    84.730     0.150
    10.573  3924.201     0.150
    15.484   216.331     0.150
    16.110   235.201     0.150
    18.746   261.901     0.150
    20.633   282.201     0.150
    20.991   288.701     0.150
    21.658   296.701     0.150
    21.720   300.201     0.150
    21.883   299.000     0.150
    23.132   305.980     0.150
    25.202   331.500     0.150
    25.313     5.600     0.150
    25.313     8.800     0.150
    25.813   331.201     0.150
    25.813   539.951     0.150
    26.669   344.901     0.150
    27.745   348.341     0.150
    29.396   363.651     0.150
    30.797     5.400     0.150
    30.797    10.800     0.150
    31.353   379.571     0.150
    31.885     8.600     0.150
    31.885    10.700     0.150
    34.804   410.621     0.150
    34.868   409.371     0.150
    36.486     5.200     0.150
    36.486     8.500     0.150
    36.522   425.371     0.150
    36.945   432.601     0.150
    36.945   428.411     0.150
    39.676   579.926     0.150
    40.451   458.471     0.150
    40.624   460.161     0.150
    46.194     4.500     0.150
    50.821   540.621     0.150
    51.027   542.041     0.150
    51.217   543.521     0.150
    51.894     6.200     0.150
    51.894    10.400     0.150
    53.352   564.131     0.150
    54.082   566.746     0.150
    54.082   565.161     0.150
    55.784   577.221     0.150
    56.665   583.301     0.150
    56.987   585.951     0.150
    64.365   869.601     0.150
    68.344   912.201     0.150
    68.344  1469.500     0.150
    74.769   870.401     0.150
    75.733   706.031     0.150
    78.081   719.710     0.150
    80.531   912.701     0.150
    80.531  1024.000     0.150
    80.531   731.851     0.150
    80.740   737.201     0.150
    84.104   751.081     0.150
    85.478   757.641     0.150
    87.218   771.264     0.150
    87.966   772.854     0.150
    88.678   776.971     0.150
    88.676   771.411     0.150
    91.354   786.683     0.150
    92.110   789.401     0.150
   121.733  1132.841     0.150
   125.170  1138.601     0.150
   125.170  1138.641     0.150
   146.693  1178.911     0.150
   147.370  1178.671     0.150
   149.515  1185.261     0.150
   151.474  1187.361     0.150
   166.502  1204.301     0.150
   166.502  1204.311     0.150
   166.502  1267.980     0.150
     0.212     6.152     0.150
    31.406   381.683     0.150
    31.406   381.682     0.150
     0.208     3.264     0.150
     0.208     5.134     0.150
     2.315    80.384     0.150
    13.436   194.494     0.150
    14.081   217.494     0.150
    14.371   206.694     0.150
    25.163     4.700     0.150
    25.163     8.400     0.150
    25.615   328.444     0.150
    27.677     9.700     0.150
    27.677    14.600     0.150
    27.677   345.594     0.150
    27.677   345.604     0.150
    30.773   373.724     0.150
    30.793     7.000     0.150
    31.800     5.600     0.150
    31.800     8.700     0.150
    34.113   403.554     0.150
    34.765   563.744     0.150
    34.765   408.754     0.150
    36.399     5.700     0.150
    36.399     8.300     0.150
    46.092   508.494     0.150
    46.092     6.500     0.150
    46.092   503.165     0.150
    50.927   540.074     0.150
    51.116   541.294     0.150
    51.116   541.334     0.150
    51.255   542.094     0.150
    51.255   542.074     0.150
    51.755     6.700     0.150
    51.755     9.900     0.150
    52.017   548.244     0.150
    52.456   551.674     0.150
    55.620   575.395     0.150
    55.680   574.915     0.150
    56.856   583.074     0.150
    56.856   582.844     0.150
    60.725   610.074     0.150
    64.473   664.794     0.150
    64.473   869.294     0.150
    67.118   653.194     0.150
    68.255  1466.895     0.150
    75.414   700.694     0.150
    75.535   702.494     0.150
    75.535   702.544     0.150
    76.341   707.044     0.150
    77.885   711.804     0.150
    80.432  1024.094     0.150
    82.282   743.583     0.150
    83.953   748.254     0.150
    83.953   748.254     0.150
    84.264   752.844     0.150
    85.102   755.804     0.150
    95.535   803.234     0.150
   118.218  1128.279     0.150
   118.219  1128.284     0.150
   146.732  1178.114     0.150
     0.829    20.185     0.150
    23.632   316.275     0.150
    23.737   306.215     0.150
    34.851   400.995     0.150
    48.127   510.455     0.150
    50.949   539.245     0.150
    53.427   549.485     0.150
    53.849   558.795     0.150
    55.081   569.035     0.150
    56.902   581.045     0.150
    79.732   716.155     0.150
     2.236    75.435     0.150
     3.832   116.275     0.150
     8.610   224.395     0.150
    20.747   277.635     0.150
    22.283   303.995     0.150
    25.736   330.085     0.150
    27.755   347.165     0.150
    29.504   360.185     0.150
    31.323   378.315     0.150
    33.827   396.995     0.150
    34.228   405.175     0.150
    34.891   409.495     0.150
    34.891   409.475     0.150
    34.891   410.035     0.150
    36.485     5.000     0.150
    36.485     7.200     0.150
    39.760   449.595     0.150
    40.483   457.035     0.150
    40.655   458.265     0.150
    42.885   478.835     0.150
    44.793   492.525     0.150
    51.017   540.755     0.150
    51.207   542.685     0.150
    51.860   986.295     0.150
    52.026   549.035     0.150
    52.130   549.065     0.150
    52.558   553.415     0.150
    54.055   563.535     0.150
    55.733   575.915     0.150
    55.786   576.295     0.150
    56.959   584.475     0.150
    56.959   584.505     0.150
    64.463   629.395     0.150
    64.463   864.595     0.150
    67.214   653.195     0.150
    68.342   806.495     0.150
    68.342  1465.495     0.150
    68.342   660.305     0.150
    75.655   704.195     0.150
    76.841   711.195     0.150
    79.089   720.995     0.150
    80.523   919.595     0.150
    80.523  1026.895     0.150
    84.062   749.335     0.150
    85.181   754.625     0.150
    87.001   764.355     0.150
    88.573   773.383     0.150
     0.208     1.642     0.150
     0.208     3.501     0.150
     0.591     1.122     0.150
    25.559   325.901     0.150
    27.750   344.892     0.150
     0.213     9.402     0.150
     0.911    19.082     0.150
     0.911    34.342     0.150
     1.333    23.472     0.150
     3.125    63.622     0.150
     3.125   106.422     0.150
     3.171    46.952     0.150
     8.592   119.732     0.150
     9.618   133.752     0.150
    13.827   190.112     0.150
    15.362   212.012     0.150
    18.448   248.232     0.150
    19.478   259.822     0.150
    20.676   274.922     0.150
    21.550   281.692     0.150
    23.408   304.682     0.150
    23.643   306.762     0.150
    24.011   318.377     0.150
    24.730   316.972     0.150
    25.737   327.882     0.150
    25.909   327.682     0.150
    27.693   352.837     0.150
    27.771   354.702     0.150
    30.351   367.922     0.150
    31.304   376.722     0.150
    34.233   404.622     0.150
    34.687   406.132     0.150
    34.688   406.512     0.150
    36.499   430.502     0.150
    36.499     5.200     0.150
    36.499     8.900     0.150
    39.784   455.877     0.150
    43.952   483.242     0.150
    44.775   490.732     0.150
    50.956   544.940     0.150
    53.943   566.602     0.150
    53.946   566.602     0.150
    55.739   574.922     0.150
    55.795   576.382     0.150
    56.969   584.132     0.150
    56.969   584.102     0.150
    60.755   614.142     0.150
    60.755   614.140     0.150
    61.240   613.382     0.150
    61.821   621.411     0.150
    63.882   634.877     0.150
    65.016   638.962     0.150
    67.226   656.077     0.150
    68.356   663.421     0.150
    83.807   752.542     0.150
    83.808   752.544     0.150
    84.070   753.152     0.150
    85.473   759.852     0.150
    92.139   792.025     0.150
   118.340  1130.102     0.150
   119.774  1134.477     0.150
     1.211    41.291     0.150
     1.568    53.421     0.150
     1.568    50.971     0.150
     1.927    57.521     0.150
     2.313    38.711     0.150
     2.840    44.981     0.150
     4.292    68.661     0.150
     4.887    70.681     0.150
     4.887   126.161     0.150
     6.308    97.191     0.150
    10.773   159.091     0.150
    10.773   150.961     0.150
    10.962  4183.491     0.150
    11.008   162.091     0.150
    14.030   202.091     0.150
    15.195   211.351     0.150
    18.335   255.391     0.150
    18.335   250.951     0.150
    20.243   277.691     0.150
    21.561   292.591     0.150
    22.976   309.591     0.150
    22.959   309.291     0.150
    24.407   322.991     0.150
    24.573   324.991     0.150
    24.872   334.491     0.150
    25.119   328.491     0.150
    25.094     6.300     0.150
    25.094    10.800     0.150
    25.094   323.651     0.150
    25.480   327.011     0.150
    27.751   346.766     0.150
    27.704   346.311     0.150
    28.044   353.791     0.150
    30.864   374.821     0.150
    30.884     7.600     0.150
    30.884     9.900     0.150
    31.326   377.821     0.150
    31.808     5.700     0.150
    31.808    10.200     0.150
    33.511   399.875     0.150
    33.511   397.541     0.150
    34.011   402.721     0.150
    34.694   407.151     0.150
    35.056   411.741     0.150
    35.056   411.381     0.150
    36.287   421.771     0.150
    36.406     5.500     0.150
    36.406     9.000     0.150
    37.059   431.891     0.150
    37.059   427.250     0.150
    39.913   449.891     0.150
    40.490   456.781     0.150
    40.659   458.091     0.150
    44.810   490.851     0.150
    46.080   503.481     0.150
    50.917   539.981     0.150
    50.917   539.821     0.150
    50.917   615.731     0.150
    51.106   541.061     0.150
    51.169   540.381     0.150
    51.217   542.181     0.150
    51.325   539.901     0.150
    51.699     5.800     0.150
    51.699    10.200     0.150
    51.929   548.021     0.150
    52.356   568.491     0.150
    52.356   996.291     0.150
    52.410   550.591     0.150
    52.871   553.761     0.150
    53.876   561.441     0.150
    53.911   561.261     0.150
    55.533   573.781     0.150
    55.620   574.831     0.150
    56.810   582.981     0.150
    56.810   582.891     0.150
    56.950   582.391     0.150
    57.115   584.321     0.150
    60.652   610.331     0.150
    61.917   617.091     0.150
    61.917   617.191     0.150
    64.658   641.691     0.150
    64.658   867.391     0.150
    65.503   646.142     0.150
    65.509   645.002     0.150
    65.586   647.216     0.150
    65.651   647.325     0.150
    65.654   647.316     0.150
    65.717   646.700     0.150
    66.078   650.836     0.150
    68.258   659.141     0.150
    75.337   701.611     0.150
    75.397   702.301     0.150
    76.174   705.891     0.150
    76.274   707.161     0.150
    76.288   710.991     0.150
    76.603   708.500     0.150
    78.397   718.771     0.150
    80.146   727.621     0.150
    80.157   727.821     0.150
    80.206   727.891     0.150
    80.424  1021.691     0.150
    80.477   727.821     0.150
    80.746   733.055     0.150
    80.991   732.701     0.150
    80.999   731.491     0.150
    81.158   739.791     0.150
    83.881   748.211     0.150
    83.881   747.901     0.150
    84.507   751.281     0.150
    85.123   753.391     0.150
    85.340   754.601     0.150
    85.340   755.201     0.150
    85.684   756.461     0.150
    86.349   760.509     0.150
    86.566   762.712     0.150
    86.573   760.958     0.150
    86.676   761.361     0.150
    87.039   763.939     0.150
    87.216   764.964     0.150
    87.876   768.790     0.150
    87.933   768.874     0.150
    88.491   770.911     0.150
    88.521   771.282     0.150
    89.416   775.133     0.150
    89.661   778.291     0.150
    90.180   769.991     0.150
    90.180   779.191     0.150
    90.375   780.249     0.150
    92.075   785.991     0.150
    92.423   792.191     0.150
    93.570   796.291     0.150
    94.626   798.591     0.150
    95.014   805.491     0.150
    95.240   801.581     0.150
    95.484   803.091     0.150
    95.514   804.791     0.150
    95.514   802.841     0.150
    98.018   816.516     0.150
   146.675  1177.831     0.150
   166.789  1207.391     0.150
     0.170     2.792     0.150
     0.476     8.852     0.150
     1.552    23.192     0.150
     2.056    29.652     0.150
     2.236    61.012     0.150
     2.451    36.752     0.150
     3.188    90.317     0.150
     3.188    52.217     0.150
     4.653   128.482     0.150
     6.310   102.772     0.150
    10.723  4100.872     0.150
    10.872   160.872     0.150
    14.654   208.472     0.150
    15.336   214.082     0.150
    18.819   261.572     0.150
    21.506   296.672     0.150
    21.766   298.172     0.150
    23.254     4.400     0.150
    23.254   601.272     0.150
    23.529   312.872     0.150
    23.597   315.172     0.150
    23.597   308.702     0.150
    23.801   327.472     0.150
    24.709   335.072     0.150
    24.832   334.572     0.150
    25.245   325.992     0.150
    25.381   335.272     0.150
    25.691   335.347     0.150
    25.790   331.202     0.150
    27.711   348.162     0.150
    27.756    12.100     0.150
    27.756    18.200     0.150
    27.756   347.902     0.150
    29.561   363.922     0.150
    30.843   374.862     0.150
    30.862     5.600     0.150
    31.311   378.002     0.150
    31.864   388.972     0.150
    31.880     5.400     0.150
    31.880     8.400     0.150
    34.192   405.562     0.150
    34.692   408.312     0.150
    34.692   563.252     0.150
    34.936   410.972     0.150
    34.936   410.932     0.150
    36.447   424.072     0.150
    36.480     4.600     0.150
    36.480     7.100     0.150
    36.965   428.122     0.150
    40.497   458.542     0.150
    40.668   458.922     0.150
    43.860   489.872     0.150
    43.886   488.772     0.150
    44.784   492.542     0.150
    44.905   497.972     0.150
    45.736   504.372     0.150
    46.174     2.400     0.150
    46.174    11.600     0.150
    46.174   504.352     0.150
    51.008   541.362     0.150
    51.337   544.992     0.150
    51.837     5.700     0.150
    51.837     8.800     0.150
    52.008   548.772     0.150
    52.098   549.432     0.150
    52.266   553.172     0.150
    52.266   998.272     0.150
    52.538   554.222     0.150
    52.994   557.172     0.150
    53.868   566.482     0.150
    54.009   563.222     0.150
    54.273   568.572     0.150
    54.399   570.452     0.150
    54.535   570.622     0.150
    55.146   572.002     0.150
    55.701   575.472     0.150
    55.762   576.652     0.150
    56.939   584.612     0.150
    57.252   586.042     0.150
    61.834   620.372     0.150
    67.201   653.422     0.150
    68.336  1467.472     0.150
    75.485   702.652     0.150
    75.609   703.572     0.150
    75.609   703.592     0.150
    75.854   706.972     0.150
    76.423   707.722     0.150
    76.756   710.332     0.150
    77.538   718.272     0.150
    77.941   715.632     0.150
    79.062   722.202     0.150
    79.074   726.272     0.150
    79.145   725.372     0.150
    79.241   727.372     0.150
    79.879   734.172     0.150
    81.199   738.372     0.150
    85.181   755.052     0.150
    85.521   756.482     0.150
    87.009   766.772     0.150
    87.169   770.571     0.150
    88.638   776.072     0.150
    88.638   775.654     0.150
    90.291   794.772     0.150
    92.125   789.272     0.150
    95.617   808.097     0.150
   118.293  1201.222     0.150
   119.823  1131.547     0.150
   126.596  1145.272     0.150
     1.098    25.847     0.150
    11.043   154.757     0.150
     3.063   111.140     0.150
    14.743   209.169     0.150
    20.198   284.669     0.150
    22.293   305.069     0.150
    22.552   297.869     0.150
    24.106   323.369     0.150
    27.734   345.579     0.150
    31.866     7.200     0.150
    31.866     8.900     0.150
    34.853   408.149     0.150
    36.467     6.300     0.150
    36.467     9.000     0.150
    53.906   560.329     0.150
    61.233   616.489     0.150
     0.255     4.607     0.150
     0.255     7.908     0.150
     3.158    88.838     0.150
     3.139    93.758     0.150
     4.133    67.188     0.150
     4.843    78.828     0.150
     5.155   141.763     0.150
    10.668  3948.088     0.150
    15.408   216.958     0.150
    16.313   225.188     0.150
    20.583   276.488     0.150
    22.432   293.618     0.150
    23.259   306.488     0.150
    23.259     5.399     0.150
    24.550   317.288     0.150
    25.261     5.000     0.150
    25.261     8.600     0.150
    25.261   324.968     0.150
    25.830   328.258     0.150
    27.647   344.618     0.150
    27.738   346.118     0.150
    27.860   543.138     0.150
    29.483   364.558     0.150
    29.482   361.828     0.150
    30.802   373.698     0.150
    31.809   684.388     0.150
    31.869     5.899     0.150
    31.869     9.399     0.150
    34.221   404.008     0.150
    34.727   408.888     0.150
    34.727   560.508     0.150
    34.869   409.568     0.150
    34.869   408.338     0.150
    36.145   419.828     0.150
    36.466   423.298     0.150
    36.469     4.899     0.150
    36.469     7.000     0.150
    36.969   425.897     0.150
    40.464   454.488     0.150
    40.464   454.518     0.150
    40.636   457.638     0.150
    44.811   491.498     0.150
    46.169     8.700     0.150
    51.003   539.288     0.150
    51.003   539.308     0.150
    51.192   541.278     0.150
    51.342   540.588     0.150
    51.342   540.558     0.150
    51.849     8.200     0.150
    51.849    11.500     0.150
    52.014   547.298     0.150
    52.121   548.188     0.150
    52.206   993.988     0.150
    52.546   551.408     0.150
    53.001   554.598     0.150
    54.015   561.878     0.150
    54.043   564.698     0.150
    55.724   574.298     0.150
    55.775   575.078     0.150
    56.947   582.978     0.150
    56.947   582.848     0.150
    65.836   642.864     0.150
    65.836   642.978     0.150
    68.326  1454.788     0.150
    75.500   701.598     0.150
    75.513   704.888     0.150
    75.652   702.878     0.150
    76.439   707.538     0.150
    76.772   708.788     0.150
    78.982   720.368     0.150
    79.894   726.138     0.150
    79.872   736.488     0.150
    80.508   909.388     0.150
    84.052   748.568     0.150
    84.052   748.208     0.150
    85.164   754.038     0.150
    85.444   755.168     0.150
    85.447   755.218     0.150
    87.006   763.348     0.150
    88.595   772.151     0.150
    88.595   770.188     0.150
    90.293   776.788     0.150
    90.293   788.988     0.150
    90.293   796.588     0.150
    95.615   803.408     0.150
   118.336  1192.588     0.150
   118.337  1192.588     0.150
   119.735  1127.658     0.150
   121.842  1131.838     0.150
   125.266  1137.768     0.150
   144.889  1174.998     0.150
   146.685  1178.238     0.150
   152.587  1194.588     0.150
   154.130  1194.448     0.150
   154.130  1194.448     0.150
   155.049  1200.688     0.150
   155.399  1192.568     0.150
     3.089    82.140     0.150
     3.103    81.779     0.150
     4.804   116.454     0.150
    13.027   179.265     0.150
    25.811   335.728     0.150
    40.524   455.574     0.150
    56.934   582.324     0.150
    84.063   751.692     0.150
   119.509  1130.579     0.150
     3.156    44.929     0.150
    17.368   235.669     0.150
    19.922   271.219     0.150
    27.696   350.331     0.150
    51.046   540.329     0.150
    85.211   756.023     0.150
     0.678    10.091     0.150
    10.701   148.271     0.150
    20.838   286.791     0.150
    27.770    11.400     0.150
    27.770    16.900     0.150
    27.770   345.321     0.150
    34.623   405.491     0.150
    36.470   430.241     0.150
    36.470     4.100     0.150
    36.470     6.600     0.150
    81.062   736.171     0.150
    81.062   736.175     0.150
   146.605  1179.516     0.150
     2.093    63.458     0.150
     3.042    93.987     0.150
     3.042    94.178     0.150
     3.186    80.558     0.150
     4.288    59.537     0.150
     5.230    84.317     0.150
     5.230   144.857     0.150
     9.100   139.728     0.150
    10.649  3999.728     0.150
    12.309   188.827     0.150
    14.018   202.628     0.150
    14.104   190.628     0.150
    14.400   204.327     0.150
    15.264   225.327     0.150
    15.404   214.478     0.150
    16.294   223.827     0.150
    19.963   272.628     0.150
    20.426   285.628     0.150
    21.616   293.728     0.150
    21.616   287.077     0.150
    22.451   294.857     0.150
    22.611   307.728     0.150
    23.304   312.428     0.150
    23.277     5.399     0.150
    23.277    31.699     0.150
    23.277   601.128     0.150
    23.970   315.853     0.150
    24.084   322.027     0.150
    25.280     3.801     0.150
    25.280     8.200     0.150
    25.280   599.628     0.150
    25.280   325.907     0.150
    25.850   328.808     0.150
    27.655   344.357     0.150
    27.754    12.200     0.150
    27.754   345.607     0.150
    28.165   639.728     0.150
    29.484   362.487     0.150
    29.948   366.008     0.150
    30.359   370.562     0.150
    30.815   373.867     0.150
    30.834     6.900     0.150
    30.834     9.300     0.150
    31.327   380.928     0.150
    31.327   374.787     0.150
    31.886     7.399     0.150
    31.886    11.399     0.150
    34.240   403.367     0.150
    34.713   407.468     0.150
    34.713   562.027     0.150
    34.876   408.428     0.150
    34.876   408.428     0.150
    34.876   408.697     0.150
    34.957   412.298     0.150
    36.486     4.500     0.150
    36.486     7.000     0.150
    36.486   423.478     0.150
    36.683   428.048     0.150
    36.661   423.527     0.150
    36.952   426.478     0.150
    39.419   448.827     0.150
    39.486   451.594     0.150
    40.478   455.857     0.150
    40.651   457.508     0.150
    41.067   464.416     0.150
    43.063   476.867     0.150
    43.977   483.208     0.150
    44.796   490.468     0.150
    44.886   494.697     0.150
    46.187     8.500     0.150
    46.187   502.388     0.150
    49.332   529.397     0.150
    50.912   538.628     0.150
    50.912   538.598     0.150
    51.020   539.518     0.150
    51.308   540.478     0.150
    51.210   540.628     0.150
    51.210   540.607     0.150
    51.360   543.947     0.150
    51.868     7.600     0.150
    51.868    10.899     0.150
    52.033   546.817     0.150
    52.141   547.997     0.150
    52.214    13.700     0.150
    52.214   987.128     0.150
    52.565   551.378     0.150
    52.565   623.338     0.150
    53.019   554.397     0.150
    54.034   561.407     0.150
    55.744   573.688     0.150
    55.794   574.577     0.150
    56.965   582.628     0.150
    57.283   584.947     0.150
    60.743   610.638     0.150
    64.120   633.116     0.150
    64.167   636.827     0.150
    64.445   670.427     0.150
    65.571   643.696     0.150
    65.855   645.024     0.150
    65.855   642.778     0.150
    65.920   645.007     0.150
    65.988   645.124     0.150
    67.356   651.157     0.150
    68.344   659.128     0.150
    68.344   805.028     0.150
    75.671   702.337     0.150
    76.458   707.368     0.150
    79.163   722.728     0.150
    79.162  1329.728     0.150
    79.895   726.528     0.150
    79.942   725.317     0.150
    80.526   910.728     0.150
    84.071   752.052     0.150
    84.071   751.728     0.150
    84.695   750.978     0.150
    85.181   754.218     0.150
    85.274   757.628     0.150
    85.447   754.478     0.150
    85.617   758.728     0.150
    86.899   758.528     0.150
    87.023   766.028     0.150
    87.023   762.368     0.150
    88.387   768.417     0.150
    88.644   769.808     0.150
    90.311   790.628     0.150
    90.764   779.337     0.150
    92.122   787.228     0.150
    92.122   787.228     0.150
    92.251   785.688     0.150
    92.399   786.757     0.150
    94.734   803.858     0.150
    94.734   803.827     0.150
    95.119   796.728     0.150
    95.119   810.728     0.150
    97.804   818.132     0.150
    98.603  1057.108     0.150
   118.355  1123.837     0.150
   126.796  1140.327     0.150
   149.621  1182.288     0.150
     0.471     9.102     0.150
     0.842    29.781     0.150
     3.160    61.271     0.150
     3.160   101.742     0.150
     3.207    45.301     0.150
     3.207    82.611     0.150
     8.517   116.701     0.150
    10.875   149.551     0.150
    13.755   185.311     0.150
    20.632   272.682     0.150
    23.197   312.361     0.150
    24.653   315.432     0.150
    25.664   334.426     0.150
    27.816   344.502     0.150
    27.738   345.492     0.150
    50.988   542.539     0.150
    50.988   539.051     0.150
    52.073   546.131     0.150
    53.330   553.391     0.150
    53.911   559.301     0.150
    53.911   560.771     0.150
    53.911   625.461     0.150
    55.127   569.102     0.150
     0.550     8.051     0.150
     0.550    15.910     0.150
     1.039    16.332     0.150
     1.464    23.771     0.150
     1.763    27.900     0.150
     1.763    50.182     0.150
     9.595   138.172     0.150
    10.788  4255.121     0.150
    14.244   202.521     0.150
    14.570   209.320     0.150
    15.251   214.691     0.150
    20.392   276.121     0.150
    21.271   286.721     0.150
    22.491   296.521     0.150
    22.491     6.500     0.150
    23.249   306.021     0.150
    25.077   323.922     0.150
    25.225     4.801     0.150
    31.275   373.721     0.150
    31.894     5.600     0.150
    31.894     8.500     0.150
    34.158   402.422     0.150
    34.651   408.461     0.150
    35.015   412.041     0.150
    36.493     7.801     0.150
    36.493    10.801     0.150
    39.662   452.021     0.150
    40.288   456.320     0.150
    40.467   458.422     0.150
    41.917   469.521     0.150
    51.014   541.672     0.150
    51.014   541.910     0.150
    52.070   549.941     0.150
    52.336  1309.721     0.150
    52.684   556.932     0.150
    53.296   562.102     0.150
    53.726   564.650     0.150
    53.859   566.332     0.150
    54.266   568.012     0.150
    54.527   570.320     0.150
    55.674   575.512     0.150
    55.747   577.672     0.150
    56.929   584.471     0.150
    56.929   584.201     0.150
    56.929   584.121     0.150
    64.955   639.701     0.150
    68.348   807.021     0.150
    75.560   703.111     0.150
    75.873   702.320     0.150
    76.405   708.611     0.150
    79.144   723.820     0.150
    85.447   759.121     0.150
     1.482    54.910     0.150
     3.130    60.719     0.150
    18.348   256.309     0.150
    25.741   334.070     0.150
    27.741   350.779     0.150
   118.223  1128.404     0.150
   118.224  1128.410     0.150
     1.161    25.883     0.150
     1.655    25.963     0.150
     1.655    52.184     0.150
     2.752    40.223     0.150
     4.212    68.604     0.150
    18.668   254.473     0.150
     2.754    40.963     0.150
     3.313    94.387     0.150
    14.165   206.092     0.150
    20.041   270.193     0.150
    23.204   306.693     0.150
    25.017   327.092     0.150
    25.235     5.299     0.150
    25.235   605.793     0.150
    25.773   331.873     0.150
    26.093   334.492     0.150
    27.630    12.100     0.150
    29.267   359.883     0.150
    29.267   359.893     0.150
    31.478   380.533     0.150
    31.775     5.000     0.150
    31.775     7.699     0.150
    34.226   405.912     0.150
    36.376     6.500     0.150
    36.376     9.199     0.150
    37.049   431.162     0.150
    40.324   457.223     0.150
    40.498   458.812     0.150
    44.940   495.893     0.150
    50.923   542.582     0.150
    51.809     6.801     0.150
    51.809     9.400     0.150
    55.715   576.422     0.150
    55.740   576.502     0.150
    56.898   584.783     0.150
    56.898   584.943     0.150
    65.655   644.143     0.150
    75.692   706.012     0.150
    79.078   722.092     0.150
    85.058   754.873     0.150
   119.525  1132.270     0.150
    31.173   378.971     0.150
    31.319   375.701     0.150
    40.665   462.787     0.150
    53.889   566.268     0.150
     0.538    23.258     0.150
     1.782    28.098     0.150
     0.362    12.701     0.150
     1.772    41.820     0.150
     3.239    58.535     0.150
    34.797   411.271     0.150
    44.065   488.900     0.150
    44.866   495.061     0.150
     1.072    38.037     0.150
     1.494    24.268     0.150
     1.494    44.738     0.150
     3.087    95.418     0.150
     3.129    52.258     0.150
     3.598    58.238     0.150
     9.600   137.338     0.150
    10.950   155.969     0.150
    13.236   193.037     0.150
    13.236   184.338     0.150
    15.339   234.438     0.150
    15.448   218.338     0.150
    15.883   225.838     0.150
    15.883   404.938     0.150
    16.573   423.139     0.150
    18.679   258.639     0.150
    19.972   273.639     0.150
    20.356   285.338     0.150
    20.567   280.037     0.150
    20.591   279.438     0.150
    20.591   279.469     0.150
    20.969   289.139     0.150
    21.281   527.238     0.150
    21.312   292.639     0.150
    22.141   301.838     0.150
    22.306   305.738     0.150
    22.595     7.701     0.150
    23.364     5.400     0.150
    23.404   310.938     0.150
    23.430   315.537     0.150
    23.786   319.139     0.150
    24.001   322.738     0.150
    24.194   326.238     0.150
    24.282   323.838     0.150
    24.917   338.438     0.150
    25.064   337.139     0.150
    25.380     4.801     0.150
    25.380     7.000     0.150
    25.557   336.639     0.150
    25.874   332.938     0.150
    25.874   542.537     0.150
    25.928   339.639     0.150
    25.971   332.969     0.150
    27.634   347.639     0.150
    27.812   348.938     0.150
    28.105   366.338     0.150
    28.245     7.199     0.150
    29.425   361.639     0.150
    29.848   370.383     0.150
    29.848   366.787     0.150
    30.836   376.037     0.150
    30.856     5.701     0.150
    31.290   377.938     0.150
    31.952     5.400     0.150
    33.062   710.338     0.150
    34.352   407.299     0.150
    34.682   408.537     0.150
    34.847   410.938     0.150
    34.913     8.000     0.150
    34.913    11.299     0.150
    36.553     5.201     0.150
    36.553     8.701     0.150
    36.589   427.377     0.150
    36.878   427.938     0.150
    36.878   426.969     0.150
    37.655   434.537     0.150
    39.424   450.078     0.150
    40.513   459.197     0.150
    40.687   461.537     0.150
    43.088   478.988     0.150
    44.753   492.889     0.150
    44.753   492.938     0.150
    44.868   883.838     0.150
    45.229   494.438     0.150
    46.261    10.600     0.150
    46.261   506.188     0.150
    48.427   515.938     0.150
    48.427   929.639     0.150
    50.723   539.277     0.150
    50.849   541.338     0.150
    51.197   979.639     0.150
    51.264   543.248     0.150
    51.094   543.238     0.150
    51.284   544.537     0.150
    51.447   546.229     0.150
    51.962     6.701     0.150
    51.962     8.701     0.150
    52.225   550.418     0.150
    52.200   996.238     0.150
    52.120   551.248     0.150
    52.247   551.748     0.150
    52.655   554.848     0.150
    52.805   558.389     0.150
    53.107   558.898     0.150
    53.420   565.117     0.150
    53.510   563.268     0.150
    53.847   566.258     0.150
    53.983   563.438     0.150
    53.984   567.719     0.150
    54.384   569.357     0.150
    54.515   568.527     0.150
    55.890   578.438     0.150
    57.055   585.857     0.150
    61.775   616.438     0.150
    63.441   629.361     0.150
    63.881   632.238     0.150
    64.402   785.338     0.150
    64.244   634.420     0.150
    64.290   634.137     0.150
    64.388   634.859     0.150
    64.817   638.027     0.150
    65.976   647.258     0.150
    65.976   646.479     0.150
    66.773   653.816     0.150
    67.299   654.537     0.150
    68.411   682.438     0.150
    68.411   661.428     0.150
    68.478   661.285     0.150
    68.500   665.111     0.150
    73.579   687.338     0.150
    73.579   854.438     0.150
    73.579  1252.139     0.150
    73.676   694.537     0.150
    75.793   705.527     0.150
    75.913   706.139     0.150
    76.944   713.537     0.150
    77.638   717.838     0.150
    79.175   725.238     0.150
    79.244   726.037     0.150
    79.335   727.338     0.150
    80.677   731.338     0.150
    80.599  1027.938     0.150
    83.827   748.139     0.150
    84.171   752.037     0.150
    84.795   756.871     0.150
    84.795   754.918     0.150
    85.239   755.738     0.150
    85.392   756.377     0.150
    85.690   760.838     0.150
    86.208  1085.838     0.150
    87.157   766.729     0.150
    88.459   772.578     0.150
    88.459   772.088     0.150
    88.643   771.438     0.150
    89.413   778.238     0.150
    89.868   776.037     0.150
    89.868   776.018     0.150
    89.868   776.018     0.150
    90.326   786.838     0.150
    90.393   799.537     0.150
    91.435   790.139     0.150
    91.435   790.117     0.150
    91.435   790.117     0.150
    91.510   788.188     0.150
    91.510   788.188     0.150
    91.510   786.498     0.150
    92.176   788.938     0.150
    92.176   788.938     0.150
    92.176   789.238     0.150
    92.632   801.139     0.150
    92.823   799.844     0.150
    93.031   795.338     0.150
    93.581   801.537     0.150
    93.770   798.881     0.150
    93.770   798.938     0.150
    94.934   803.938     0.150
    94.809   802.639     0.150
    95.193   810.838     0.150
    95.193   800.838     0.150
    95.193   810.838     0.150
    95.193  1470.838     0.150
    95.193  1585.838     0.150
    95.193  2089.838     0.150
    95.193  2275.838     0.150
    95.663  1036.301     0.150
    95.680   823.338     0.150
    95.680   805.338     0.150
    95.712   806.838     0.150
    96.596   813.957     0.150
    97.600   817.582     0.150
   111.167  1144.713     0.150
   118.479  1208.188     0.150
   119.625  1128.479     0.150
   121.738  1133.908     0.150
   125.190  1140.049     0.150
   126.629  1143.139     0.150
   126.629  1143.127     0.150
   146.629  1181.268     0.150
   149.511  1188.969     0.150
   149.511  1188.238     0.150
   152.482  1189.979     0.150
   153.199  1197.678     0.150
   153.634  1199.367     0.150
   153.689  1193.277     0.150
   154.026  1194.457     0.150
   154.359  1191.627     0.150
   154.519  1196.787     0.150
   154.519  1196.787     0.150
   154.946  1201.799     0.150
   155.286  1193.828     0.150
   155.347  1194.377     0.150
   155.417  1201.518     0.150
   155.417  1201.518     0.150
   155.455  1203.889     0.150
   155.455  1203.889     0.150
   155.607  1203.889     0.150
   155.607  1203.889     0.150
   155.596  1220.768     0.150
   155.903  1207.438     0.150
   155.903  1207.438     0.150
   156.105  1198.828     0.150
   156.105  1198.828     0.150
   156.188  1200.979     0.150
   156.188  1200.979     0.150
   156.188  1204.207     0.150
   156.188  1204.207     0.150
   156.695  1205.537     0.150
   156.695  1205.537     0.150
   157.060  1197.107     0.150
   163.587  1203.838     0.150
   166.438  1206.139     0.150
   170.476  1207.238     0.150
   172.683  1209.238     0.150
     2.869    96.324     0.150
     3.077    96.033     0.150
     3.220    99.084     0.150
     3.270   109.988     0.150
     5.077   139.895     0.150
     6.321   100.943     0.150
     8.775   134.244     0.150
    10.793   158.545     0.150
    10.947  2959.244     0.150
    11.910   162.943     0.150
    12.045   177.244     0.150
    14.041   203.244     0.150
    15.218   213.514     0.150
    16.262     7.701     0.150
    18.975   260.744     0.150
    21.571   290.844     0.150
    22.611     4.600     0.150
    22.611     9.699     0.150
    22.611   550.145     0.150
    23.003   306.244     0.150
    23.134   549.045     0.150
    23.240   310.045     0.150
    25.096     6.199     0.150
    25.096   366.145     0.150
    25.096   598.045     0.150
    25.096   324.205     0.150
    25.591   329.012     0.150
    25.591   328.215     0.150
    27.125   345.045     0.150
    27.695   346.904     0.150
    27.795   347.674     0.150
    29.708   363.645     0.150
    30.137   367.564     0.150
    30.849   375.104     0.150
    30.869     7.400     0.150
    30.869     9.000     0.150
    30.995   374.756     0.150
    31.802     6.000     0.150
    31.802     9.299     0.150
    33.535   397.254     0.150
    34.017   402.215     0.150
    34.357   405.033     0.150
    35.077     8.500     0.150
    35.077    11.000     0.150
    35.077   745.244     0.150
    36.291   424.504     0.150
    36.291   422.264     0.150
    36.400     5.400     0.150
    36.400     9.400     0.150
    36.400   770.045     0.150
    37.063   428.574     0.150
    40.429   475.943     0.150
    40.478   458.715     0.150
    40.478   457.625     0.150
    40.647   458.174     0.150
    40.647   579.924     0.150
    40.810   459.734     0.150
    40.982   826.744     0.150
    42.582   474.924     0.150
    42.916   475.982     0.150
    42.916   476.545     0.150
    42.916   476.555     0.150
    42.924   487.244     0.150
    43.962   485.164     0.150
    44.821   492.369     0.150
    44.821   593.170     0.150
    45.199   492.145     0.150
    46.076     3.500     0.150
    46.076   916.045     0.150
    46.076   503.533     0.150
    49.833   532.344     0.150
    49.833   962.545     0.150
    50.831   539.564     0.150
    51.101   541.424     0.150
    51.103   542.443     0.150
    51.103   981.744     0.150
    51.216   544.744     0.150
    51.336   543.064     0.150
    51.466   545.443     0.150
    51.466   985.045     0.150
    51.467   545.125     0.150
    51.467   545.045     0.150
    51.467   983.844     0.150
    51.496   544.744     0.150
    51.700     7.301     0.150
    51.700    10.400     0.150
    51.934   548.758     0.150
    51.934   548.104     0.150
    52.335   735.645     0.150
    52.351   551.443     0.150
    52.407   552.443     0.150
    52.407   998.844     0.150
    52.522  1001.344     0.150
    52.520   987.844     0.150
    52.742   553.943     0.150
    53.184   557.645     0.150
    53.184  1006.943     0.150
    53.867   561.074     0.150
    53.910   563.914     0.150
    53.910   563.645     0.150
    55.061   571.264     0.150
    55.061   570.625     0.150
    56.173   577.244     0.150
    56.700   581.514     0.150
    56.810   583.334     0.150
    56.810   638.664     0.150
    56.810   583.074     0.150
    56.835   584.244     0.150
    58.055   592.145     0.150
    60.647   609.654     0.150
    60.719   610.613     0.150
    62.639   623.303     0.150
    63.049   626.621     0.150
    63.049   626.621     0.150
    63.850   631.297     0.150
    63.900   632.104     0.150
    63.988   632.213     0.150
    64.412   635.096     0.150
    64.684   637.232     0.150
    65.305   641.223     0.150
    65.596   642.621     0.150
    65.596   642.443     0.150
    65.661   643.377     0.150
    65.661   643.377     0.150
    66.088   646.029     0.150
    66.296   647.973     0.150
    66.957   652.008     0.150
    67.678   656.496     0.150
    68.064   658.113     0.150
    68.552   661.510     0.150
    69.468   667.004     0.150
    73.310   686.545     0.150
    73.310  1248.545     0.150
    75.344   703.965     0.150
    75.344   703.965     0.150
    75.408   702.545     0.150
    75.408   702.574     0.150
    75.630   704.014     0.150
    75.649   704.664     0.150
    75.956   701.145     0.150
    76.276   709.074     0.150
    76.829   711.113     0.150
    76.829   710.693     0.150
    77.622   715.297     0.150
    78.215   712.645     0.150
    78.992   728.145     0.150
    78.992  1318.645     0.150
    78.992  1824.545     0.150
    80.419  1019.145     0.150
    80.419  1651.545     0.150
    80.419  1856.045     0.150
    80.599   731.184     0.150
    82.886  1042.244     0.150
    82.886  1895.244     0.150
    83.324   745.844     0.150
    84.509   751.863     0.150
    84.509   751.904     0.150
    84.509   751.494     0.150
    85.115   753.564     0.150
    85.338   754.465     0.150
    85.511   755.244     0.150
    85.660   756.885     0.150
    86.241  1469.244     0.150
    86.241   758.244     0.150
    86.241  1374.244     0.150
    86.241  1391.244     0.150
    86.241  1469.244     0.150
    86.348   759.938     0.150
    86.566   761.596     0.150
    86.577   760.850     0.150
    86.695   764.164     0.150
    86.695   764.264     0.150
    86.695   764.264     0.150
    86.695   763.594     0.150
    86.979   763.662     0.150
    86.985   763.045     0.150
    87.109   763.844     0.150
    87.216   764.732     0.150
    87.274   765.105     0.150
    87.932   768.234     0.150
    88.281   768.805     0.150
    88.281   768.805     0.150
    88.519   771.348     0.150
    88.780  1413.045     0.150
    89.229   773.344     0.150
    89.418   774.588     0.150
    89.658   776.584     0.150
    89.658   776.584     0.150
    89.803   776.945     0.150
    90.112   778.744     0.150
    90.177  1411.346     0.150
    90.249   779.555     0.150
    90.249   779.555     0.150
    90.387   777.443     0.150
    90.710   780.375     0.150
    90.888   780.244     0.150
    91.227   784.455     0.150
    91.227   784.455     0.150
    91.308   783.943     0.150
    91.308   783.693     0.150
    91.374   784.443     0.150
    91.826   787.744     0.150
    91.913   785.984     0.150
    92.067   785.943     0.150
    92.222   786.674     0.150
    92.405   788.635     0.150
    92.420   789.244     0.150
    92.420  1360.943     0.150
    92.830   790.533     0.150
    92.866   789.465     0.150
    93.027   792.475     0.150
    93.095   785.244     0.150
    93.238   793.574     0.150
    93.238   793.574     0.150
    93.385   792.305     0.150
    93.386   793.645     0.150
    93.567   794.545     0.150
    94.253   798.045     0.150
    94.464   798.943     0.150
    94.585   798.545     0.150
    94.664   799.084     0.150
    95.010   799.844     0.150
    95.010  1025.244     0.150
    95.010  1034.443     0.150
    95.010  1153.244     0.150
    95.010  1475.244     0.150
    95.010  1851.244     0.150
    95.010  2085.244     0.150
    95.481   802.844     0.150
    95.481  1480.846     0.150
    95.746   804.244     0.150
    96.358  1034.889     0.150
    96.383  1034.016     0.150
    96.952   811.244     0.150
    96.991   809.045     0.150
    97.401  1047.006     0.150
    97.693  1049.320     0.150
    97.849  1057.949     0.150
    99.032   819.074     0.150
   105.186   846.225     0.150
   110.950  1152.619     0.150
   114.764  1175.145     0.150
   118.416  1125.514     0.150
   119.086  1126.533     0.150
   122.285  1133.145     0.150
   122.285  1133.184     0.150
   124.628  1137.994     0.150
   125.160  1139.914     0.150
   125.522  1139.834     0.150
   146.107  1178.113     0.150
   146.686  1179.244     0.150
   149.939  1189.004     0.150
   150.625  1185.523     0.150
   150.625  1190.414     0.150
   150.625  1198.625     0.150
   151.387  1186.023     0.150
   151.387  1192.033     0.150
   152.882  1189.635     0.150
   153.545  1191.023     0.150
   153.560  1189.344     0.150
   154.020  1190.305     0.150
   154.104  1191.314     0.150
   154.425  1191.033     0.150
   154.773  1191.424     0.150
   154.949  1191.594     0.150
   155.063  1202.244     0.150
   155.119  1191.055     0.150
   155.119  1198.244     0.150
   155.311  1192.354     0.150
   155.343  1192.584     0.150
   155.703  1191.875     0.150
   155.790  1192.254     0.150
   155.805  1193.875     0.150
   155.848  1193.004     0.150
   155.863  1192.834     0.150
   155.898  1199.244     0.150
   156.022  1188.805     0.150
   156.022  1188.805     0.150
   156.063  1193.004     0.150
   156.572  1194.404     0.150
   156.597  1194.404     0.150
   156.640  1195.443     0.150
   156.729  1193.844     0.150
   157.133  1185.955     0.150
   157.133  1185.955     0.150
   157.146  1194.684     0.150
   157.486  1194.965     0.150
   157.659  1195.414     0.150
   157.993  1229.344     0.150
   159.422  1197.684     0.150
   159.422  1235.834     0.150
   163.512  1201.744     0.150
   163.512  1252.564     0.150
   173.150  1207.824     0.150
     1.559    50.373     0.150
     1.555    49.203     0.150
     3.648   101.453     0.150
     3.708    61.033     0.150
     4.236    66.293     0.150
    10.966   161.303     0.150
    12.326   182.002     0.150
    14.431   212.104     0.150
    15.436   215.912     0.150
    15.634   227.203     0.150
    16.346   219.902     0.150
    18.832   249.203     0.150
    19.636   273.703     0.150
    20.723   280.002     0.150
    21.777   292.104     0.150
    22.233   300.104     0.150
    23.224     5.100     0.150
    23.224   550.104     0.150
    25.228     4.100     0.150
    25.706   329.873     0.150
    25.804   330.242     0.150
    25.926   539.604     0.150
    27.616   346.223     0.150
    27.702   346.973     0.150
    27.894   347.613     0.150
    29.458   364.803     0.150
    30.766   374.492     0.150
    30.786     5.000     0.150
    31.378   377.863     0.150
    33.124   396.703     0.150
    34.191   404.402     0.150
    34.763   408.402     0.150
    34.839   410.082     0.150
    34.839   410.092     0.150
    34.897     9.100     0.150
    34.897   732.803     0.150
    34.897   749.604     0.150
    36.434   425.104     0.150
    36.433     9.000     0.150
    36.433    12.400     0.150
    37.005   428.383     0.150
    40.193   458.104     0.150
    40.428   457.764     0.150
    40.600   459.283     0.150
    44.847   492.463     0.150
    44.836   493.604     0.150
    46.133     5.900     0.150
    46.133     8.900     0.150
    46.133   505.002     0.150
    46.133   504.982     0.150
    50.829   539.383     0.150
    50.887   539.764     0.150
    50.887   539.213     0.150
    50.967   541.023     0.150
    50.967   616.143     0.150
    51.360   543.342     0.150
    51.815     7.301     0.150
    51.815     9.801     0.150
    51.979   549.443     0.150
    52.090   550.162     0.150
    52.090   549.572     0.150
    52.174   571.303     0.150
    52.174   618.104     0.150
    53.874   561.803     0.150
    53.874   561.713     0.150
    54.008   564.842     0.150
    54.008   564.842     0.150
    55.101   571.871     0.150
    55.693   575.893     0.150
    56.912   583.953     0.150
    60.690   654.416     0.150
    60.762   611.572     0.150
    60.762   610.963     0.150
    61.744   616.104     0.150
    62.865   625.018     0.150
    63.273   627.711     0.150
    64.051   633.152     0.150
    64.075   633.301     0.150
    64.122   633.520     0.150
    64.219   633.920     0.150
    64.414   771.703     0.150
    64.648   636.629     0.150
    64.800   637.369     0.150
    64.907   638.184     0.150
    65.526   642.609     0.150
    65.684   643.152     0.150
    65.727   644.406     0.150
    65.809   643.945     0.150
    65.809   643.963     0.150
    65.874   645.326     0.150
    65.942   645.381     0.150
    65.942   645.381     0.150
    66.300   648.621     0.150
    66.301   647.211     0.150
    66.540   649.773     0.150
    66.540   649.773     0.150
    66.605   649.730     0.150
    66.918   651.568     0.150
    66.918   651.568     0.150
    67.165   651.902     0.150
    67.202   653.805     0.150
    67.923   658.658     0.150
    68.290   659.223     0.150
    68.308   659.725     0.150
    68.798   663.559     0.150
    75.481   704.773     0.150
    75.625   704.172     0.150
    76.406   709.043     0.150
    76.945   712.322     0.150
    78.160   717.482     0.150
    79.109  1831.904     0.150
    80.924   732.742     0.150
    84.019   749.053     0.150
    84.644   753.291     0.150
    84.644   752.082     0.150
    86.992   765.871     0.150
    86.992   765.312     0.150
    88.621   769.803     0.150
    88.621   769.773     0.150
    90.191   777.703     0.150
    90.191   777.703     0.150
    90.258   795.803     0.150
    90.786   780.303     0.150
    92.069   786.104     0.150
    94.563  1024.928     0.150
    94.681   796.613     0.150
    94.681   796.604     0.150
    95.012  1028.439     0.150
    95.066   801.303     0.150
    95.549   803.303     0.150
    95.580   803.953     0.150
    95.580   803.613     0.150
    95.596  1030.545     0.150
    96.875   809.502     0.150
    97.921  1048.248     0.150
   119.724  1129.232     0.150
   124.856  1139.361     0.150
   125.246  1139.502     0.150
   125.246  1139.475     0.150
   125.628  1139.732     0.150
   144.883  1175.553     0.150
   146.721  1180.252     0.150
   149.620  1188.842     0.150
   150.391  1190.572     0.150
   151.481  1191.283     0.150
   166.601  1205.623     0.150
     0.873    17.062     0.150
     0.925    18.461     0.150
     1.812    28.051     0.150
     2.711    38.551     0.150
     3.023   100.742     0.150
     3.126    89.473     0.150
     3.686    60.633     0.150
    10.662  4109.211     0.150
    10.899   271.242     0.150
    11.990   171.410     0.150
    14.369   221.910     0.150
    14.555   204.902     0.150
    18.457   251.621     0.150
    18.883   266.812     0.150
    23.272   313.109     0.150
    23.394   314.109     0.150
    23.598   309.051     0.150
    25.283   322.711     0.150
    25.283   322.691     0.150
    25.745   330.582     0.150
    25.844   330.082     0.150
    26.085   329.320     0.150
    27.770   352.012     0.150
    31.308   382.211     0.150
    31.899     3.598     0.150
    31.899     6.801     0.150
    34.692   409.109     0.150
    34.905   410.641     0.150
    34.905   410.270     0.150
    36.499   430.312     0.150
    40.570   461.383     0.150
    40.671   458.730     0.150
    44.777   492.461     0.150
    48.525   525.012     0.150
    51.032   542.859     0.150
    51.221   544.039     0.150
    51.873     5.199     0.150
    51.873     7.699     0.150
    52.040   550.211     0.150
    52.141   550.680     0.150
    52.571   555.211     0.150
    53.026   558.621     0.150
    53.942   566.609     0.150
    56.972   584.832     0.150
    56.972   584.152     0.150
    60.755   610.723     0.150
    60.827   609.891     0.150
    64.476   638.512     0.150
    68.356   664.012     0.150
    68.356  1207.812     0.150
    75.664   705.562     0.150
    75.869   698.211     0.150
    76.854   709.211     0.150
    84.074   747.262     0.150
    84.074   747.262     0.150
    84.074   747.910     0.150
    85.196   754.742     0.150
    85.475   758.910     0.150
    95.130   803.211     0.150
   124.033  1134.852     0.150
   146.651  1180.359     0.150
     0.474    14.812     0.150
     1.724    48.684     0.150
     2.575    38.191     0.150
    34.878   413.125     0.150
    43.938   485.535     0.150
    44.747   492.992     0.150
     3.184    45.719     0.150
     3.184    79.359     0.150
     5.195    94.625     0.150
     8.764   123.969     0.150
     8.764   221.820     0.150
    10.999   154.719     0.150
    12.864   179.523     0.150
    14.000   194.680     0.150
    20.612   279.602     0.150
    22.336   295.379     0.150
    23.570   307.859     0.150
    24.258   324.898     0.150
    25.838   331.570     0.150
    26.074   331.500     0.150
    27.757    14.602     0.150
    27.757   348.238     0.150
    27.901   346.824     0.150
    31.339   373.699     0.150
    31.345   378.949     0.150
    31.898     5.301     0.150
    31.898     9.000     0.150
    34.310   406.660     0.150
    34.799   408.801     0.150
    34.799   408.750     0.150
    36.500     4.500     0.150
    36.500     6.902     0.150
    36.543   424.719     0.150
    39.672   454.051     0.150
    40.458   459.199     0.150
    40.661   457.090     0.150
    40.632   459.551     0.150
    44.808   596.926     0.150
    44.808   493.770     0.150
    51.042   543.070     0.150
    51.042   542.711     0.150
    51.232   542.102     0.150
    51.232   542.078     0.150
    51.397   543.301     0.150
    51.397   543.328     0.150
    51.913     6.199     0.150
    51.913     8.500     0.150
    52.071   549.172     0.150
    52.150   989.602     0.150
    52.203   551.410     0.150
    52.606   553.359     0.150
    53.929   563.340     0.150
    54.100   564.000     0.150
    55.806   576.031     0.150
    57.006   585.621     0.150
    57.006   585.480     0.150
    60.760   612.141     0.150
    61.724   620.102     0.150
    63.826   633.000     0.150
    64.357   638.898     0.150
    65.857   644.473     0.150
    65.940   648.129     0.150
    68.897   661.672     0.150
    75.757   706.359     0.150
    76.179   701.000     0.150
    80.639   731.512     0.150
    84.124   750.750     0.150
    85.185   756.031     0.150
    85.351   756.699     0.150
    85.351   756.660     0.150
   146.684  1181.941     0.150
   166.479  1203.699     0.150
   166.479  1264.500     0.150
   166.479  1203.699     0.150
   166.479  1264.480     0.150
     3.218    93.770     0.150
     4.840    69.910     0.150
     8.810   124.109     0.150
     8.810   219.520     0.150
    18.993   267.941     0.150
    19.620   271.000     0.150
    23.502   314.840     0.150
    23.502   308.070     0.150
    29.329   365.789     0.150
    31.869   390.738     0.150
    31.869     4.102     0.150
    31.869     6.402     0.150
    36.471     5.301     0.150
    36.471     8.301     0.150
    43.843   490.211     0.150
    44.845   497.691     0.150
    51.017   541.398     0.150
    79.733   729.781     0.150
     2.133    47.273     0.150
     3.134    46.504     0.150
    65.768   643.102     0.150
   118.325  1130.180     0.150
   118.326  1130.184     0.150
     0.559     5.887     0.150
     1.620    53.719     0.150
     2.304    73.996     0.150
     3.051    63.027     0.150
     3.255    57.387     0.150
     3.255    81.816     0.150
     8.224   214.348     0.150
    19.801   272.719     0.150
    31.302   374.617     0.150
    31.309   378.340     0.150
    50.926   539.477     0.150
     0.429    16.434     0.150
     1.026    17.703     0.150
     1.430    46.961     0.150
     2.343    66.234     0.150
     8.472   119.844     0.150
    13.718   190.922     0.150
    15.713   231.473     0.150
    18.940   263.871     0.150
    19.562   272.773     0.150
    19.977   275.273     0.150
    21.321   290.473     0.150
    21.445   285.102     0.150
    22.115   301.473     0.150
    25.665   335.672     0.150
    27.652   354.773     0.150
    31.405   551.984     0.150
    31.430   381.102     0.150
    31.772     4.199     0.150
    31.772     7.598     0.150
    34.942   412.254     0.150
    36.371   426.773     0.150
    36.371     5.500     0.150
    36.371     8.598     0.150
    51.220   541.992     0.150
    51.718     7.898     0.150
    51.718     9.602     0.150
    53.824   562.934     0.150
    55.643   573.023     0.150
    63.795   629.996     0.150
    76.605   709.164     0.150
     1.725    51.488     0.150
     2.230    68.309     0.150
   118.462  1126.297     0.150
     1.450    48.609     0.150
     3.142   115.719     0.150
    10.632  3974.160     0.150
    14.410   206.590     0.150
    23.404   312.559     0.150
    25.236     4.297     0.150
    25.236     6.398     0.150
    25.746   330.840     0.150
    29.355   357.762     0.150
    31.805     5.102     0.150
    31.805     8.500     0.150
    34.214   404.730     0.150
    34.818   407.262     0.150
    34.818   407.250     0.150
    34.748   409.180     0.150
    36.406     9.602     0.150
    36.406    13.402     0.150
    39.301   445.461     0.150
    39.619   447.160     0.150
    40.375   456.691     0.150
    40.549   459.719     0.150
    44.894   493.160     0.150
    50.948   541.961     0.150
    51.137   542.871     0.150
    51.300   543.941     0.150
    51.974   548.359     0.150
    52.106   548.891     0.150
    54.004   563.141     0.150
    55.709   575.070     0.150
    55.745   575.172     0.150
    56.909   583.988     0.150
    56.909   583.988     0.150
    56.909   583.941     0.150
    63.747   631.934     0.150
    68.265   656.359     0.150
    68.265  1195.359     0.150
    75.666   704.410     0.150
    80.452   727.262     0.150
    85.094   755.238     0.150
    85.399   755.898     0.150
    87.070   766.461     0.150
   119.615  1129.910     0.150
     2.093    29.945     0.150
     2.201    32.316     0.150
     4.894    81.184     0.150
     8.625   132.613     0.150
     1.518    51.578     0.150
     2.298    69.539     0.150
     3.281    48.539     0.150
     8.809   134.309     0.150
    10.797   168.309     0.150
    10.907  4229.309     0.150
    11.005   169.309     0.150
    13.576   200.309     0.150
    14.025   209.809     0.150
    14.549   219.609     0.150
    15.229   218.078     0.150
    18.358   265.609     0.150
    18.942   263.309     0.150
    19.857   270.910     0.150
    21.909   297.309     0.150
    21.965   303.508     0.150
    22.438   312.809     0.150
    22.438     6.398     0.150
    23.162     5.301     0.150
    23.162   603.910     0.150
    23.786     4.500     0.150
    24.633   326.609     0.150
    25.128     8.402     0.150
    25.128    34.000     0.150
    25.180   331.609     0.150
    25.528   327.539     0.150
    25.647   329.309     0.150
    25.629   328.277     0.150
    27.714   346.539     0.150
    31.324   550.840     0.150
    31.823     5.602     0.150
    31.823     8.902     0.150
    34.052   400.949     0.150
    35.026   410.109     0.150
    35.026   410.148     0.150
    35.026   411.277     0.150
    36.422     5.797     0.150
    36.422     8.898     0.150
    37.912   434.145     0.150
    39.886   449.609     0.150
    40.490   457.219     0.150
    40.660   458.109     0.150
    44.805   492.180     0.150
    50.812   540.559     0.150
    50.937   540.770     0.150
    51.126   540.410     0.150
    51.126   540.410     0.150
    51.730     5.301     0.150
    51.730     9.000     0.150
    51.912   548.398     0.150
    51.968   548.730     0.150
    52.333   546.410     0.150
    52.333    16.098     0.150
    52.333   672.707     0.150
    52.438   548.809     0.150
    52.438   548.828     0.150
    53.939   562.980     0.150
    55.084   573.277     0.150
    55.571   572.617     0.150
    56.839   584.070     0.150
    56.839   583.168     0.150
    63.087   632.711     0.150
    63.404   634.516     0.150
    63.870   638.047     0.150
    63.889   638.461     0.150
    63.888   633.285     0.150
    63.888   633.309     0.150
    63.939   638.805     0.150
    64.619   642.797     0.150
    64.723   643.426     0.150
    65.344   647.109     0.150
    65.557   648.504     0.150
    65.634   649.316     0.150
    65.765   649.863     0.150
    66.336   654.344     0.150
    66.429   655.074     0.150
    67.290   655.508     0.150
    75.370   702.387     0.150
    75.446   701.430     0.150
    75.807   704.508     0.150
    76.710   712.484     0.150
    79.022   727.008     0.150
    79.022  1337.508     0.150
    80.113   727.027     0.150
    80.162   727.328     0.150
    83.916   746.770     0.150
    84.541   754.438     0.150
    85.135   753.488     0.150
    85.364   753.688     0.150
    85.645   756.430     0.150
    86.609   769.707     0.150
    86.609   769.688     0.150
    86.737   765.309     0.150
    87.016   775.762     0.150
    87.826   776.523     0.150
    87.904   774.207     0.150
    87.904   774.207     0.150
    87.961   774.809     0.150
    87.961   774.848     0.150
    88.519   774.910     0.150
    88.519   774.918     0.150
    88.547   775.309     0.150
    88.547   775.285     0.150
    89.450   762.270     0.150
    90.402   788.309     0.150
    90.402   788.324     0.150
    94.647   806.750     0.150
    94.647   806.707     0.150
    95.537   805.207     0.150
    95.537   805.199     0.150
   120.008  1123.809     0.150
   120.008  1123.859     0.150
   120.008  1123.859     0.150
   125.500   935.098     0.150
   146.672  1179.949     0.150
    13.800   206.930     0.150
    13.933   209.250     0.150
    31.252   554.539     0.150
    34.641   561.172     0.150
    34.642   561.172     0.150
    34.903   408.891     0.150
    51.116   619.637     0.150
     0.809    28.680     0.150
    55.141   570.535     0.150
     2.154    33.219     0.150
    40.640   458.555     0.150
    57.042   587.078     0.150
    20.079   277.668     0.150
     1.132    19.609     0.150
     3.120   114.590     0.150
     4.814    68.219     0.150
     8.788   124.430     0.150
    14.040   209.438     0.150
    14.417   214.688     0.150
    60.706   613.938     0.150
    60.706   613.938     0.150
    63.765   633.773     0.150
    80.467   733.758     0.150
    12.018   172.035     0.150
    12.869   189.883     0.150
    14.522   209.934     0.150
    14.522   209.973     0.150
    15.889   215.434     0.150
    18.757   259.332     0.150
    18.924   266.934     0.150
    22.454   313.234     0.150
    23.435   314.035     0.150
    24.177   321.434     0.150
    24.288   328.234     0.150
    25.877   337.332     0.150
    25.881   338.234     0.150
    27.763    19.301     0.150
    30.812   378.234     0.150
    31.319   378.293     0.150
    31.325   378.254     0.150
    33.799   407.734     0.150
    34.267   406.914     0.150
    36.510   426.324     0.150
    39.412   450.523     0.150
    39.730   455.535     0.150
    40.653   459.383     0.150
    44.792   493.082     0.150
    51.034   542.363     0.150
    51.034   615.785     0.150
    51.034   615.785     0.150
    51.224   543.305     0.150
    51.888   554.332     0.150
    52.051   548.922     0.150
    52.166   548.234     0.150
    52.166   548.223     0.150
    52.202   552.734     0.150
    52.584   552.613     0.150
    53.935   561.012     0.150
    53.935   565.832     0.150
    55.167   571.883     0.150
    55.769   576.535     0.150
    56.984   584.895     0.150
    60.827   614.234     0.150
    64.425   781.133     0.150
    68.355  1197.535     0.150
    75.702   703.605     0.150
    76.152   712.133     0.150
    76.870   713.758     0.150
    77.573   718.234     0.150
    79.109   726.133     0.150
    84.094   754.934     0.150
    85.190   755.512     0.150
    85.190   758.633     0.150
    85.481   760.434     0.150
    88.614   770.113     0.150
    95.649   805.434     0.150
   119.694  1129.832     0.150
   146.667  1180.445     0.150
     2.324    75.965     0.150
     3.147   114.184     0.150
     3.709   100.332     0.150
    13.349   178.113     0.150
    22.367   304.074     0.150
    27.676   350.875     0.150
    27.676    16.699     0.150
    31.820   458.273     0.150
    36.422     4.602     0.150
    36.422     7.102     0.150
    39.579   453.348     0.150
    44.894   496.875     0.150
    44.894   496.664     0.150
    56.941   583.793     0.150
    85.104   757.723     0.150
   118.414  1129.543     0.150
   118.413  1129.539     0.150
     1.170    20.660     0.150
     2.045    35.590     0.150
     2.045    63.891     0.150
     2.590    50.148     0.150
     2.590    50.148     0.150
     2.590    86.301     0.150
     3.218    54.191     0.150
    25.881   329.758     0.150
    34.725   565.203     0.150
    51.069   541.125     0.150
     1.639    56.773     0.150
     2.676    39.625     0.150
     3.391    56.312     0.150
     3.391    56.312     0.150
     0.463    12.883     0.150
     0.684     9.461     0.150
     1.090    16.172     0.150
     3.149   107.688     0.150
    14.008   204.891     0.150
    14.065   205.516     0.150
     0.163     6.383     0.150
     1.622    55.422     0.150
     2.031    65.188     0.150
     2.251    77.711     0.150
     8.169   114.883     0.150
     3.263    49.281     0.150
    11.098   165.242     0.150
   118.426  1130.688     0.150
   118.427  1130.688     0.150
     1.362    45.320     0.150
     1.800    46.211     0.150
     1.980    54.375     0.150
     2.487    35.250     0.150
     3.823   114.922     0.150
     4.777    77.375     0.150
    27.098   352.172     0.150
     1.049    20.133     0.150
     1.049    37.172     0.150
     3.203    43.633     0.150
     3.203    76.195     0.150
     3.203    43.375     0.150
    51.017   540.672     0.150
     1.087    20.852     0.150
     1.087    36.797     0.150
     3.077   107.852     0.150
     4.851    79.984     0.150
     0.150     3.604     0.150
     0.150     6.524     0.150
     1.909    27.264     0.150
    25.641   334.631     0.150
     1.617    63.606     0.150
     1.634    53.876     0.150
     2.079    68.346     0.150
     9.617   142.826     0.150
    10.715   158.626     0.150
    10.715   150.496     0.150
    10.970   162.526     0.150
    14.056   203.326     0.150
    14.056   202.626     0.150
    14.122   203.526     0.150
    14.919   225.526     0.150
    15.132   211.366     0.150
    15.897   396.826     0.150
    16.260   238.726     0.150
    21.551   295.226     0.150
    21.848   296.526     0.150
    21.993   299.026     0.150
    22.611   299.256     0.150
    22.891   309.326     0.150
    23.152   311.826     0.150
    23.784   322.326     0.150
    24.353   323.126     0.150
    24.521   325.226     0.150
    25.101     7.700     0.150
    25.101    11.000     0.150
    25.101   645.326     0.150
    25.467   331.914     0.150
    25.570   329.376     0.150
    26.611   337.326     0.150
    27.736   347.406     0.150
    28.064   353.026     0.150
    30.930     6.600     0.150
    30.930     9.100     0.150
    31.835     5.100     0.150
    34.008   407.411     0.150
    34.652   406.917     0.150
    35.116   412.096     0.150
    35.116   412.126     0.150
    36.433     9.300     0.150
    36.433    13.300     0.150
    36.433   775.826     0.150
    40.700   459.876     0.150
    43.927   483.746     0.150
    44.773   491.566     0.150
    46.103     5.500     0.150
    46.103     8.100     0.150
    51.128   541.806     0.150
    51.289   542.776     0.150
    51.710     7.500     0.150
    51.710     9.800     0.150
    51.931   547.346     0.150
    52.412   554.826     0.150
    53.925   564.913     0.150
    55.534   574.336     0.150
    56.824   582.976     0.150
    56.824   640.646     0.150
    60.749   611.380     0.150
    63.341   629.503     0.150
    63.806   632.245     0.150
    63.823   631.891     0.150
    63.959   633.271     0.150
    66.262   649.600     0.150
    66.923   653.173     0.150
    67.643   657.705     0.150
    68.030   659.915     0.150
    68.030   659.915     0.150
    68.517   663.545     0.150
    69.402   672.534     0.150
    75.347   702.226     0.150
    75.383   702.696     0.150
    75.824   701.526     0.150
    76.610   709.456     0.150
    76.838   712.396     0.150
    76.838   711.726     0.150
    80.211   728.556     0.150
    80.447  1339.526     0.150
    80.564   728.626     0.150
    84.513   753.045     0.150
    84.513   749.326     0.150
    84.513   749.366     0.150
    85.359   755.116     0.150
    85.538   756.426     0.150
    86.638   765.396     0.150
    86.638   761.226     0.150
    86.638   761.256     0.150
    87.285   761.646     0.150
    88.299   771.189     0.150
    88.299   768.746     0.150
    90.132   785.926     0.150
    90.197   800.726     0.150
    92.107   786.726     0.150
    94.648   800.526     0.150
    95.037   803.426     0.150
    95.037  1027.426     0.150
    95.037  2099.426     0.150
    95.505   804.426     0.150
   146.636  1180.126     0.150
   150.028  1189.086     0.150
   151.324  1186.316     0.150
   159.747  1238.886     0.150
   163.441  1251.206     0.150
   166.792  1203.626     0.150
   166.792  1203.616     0.150
   173.213  1206.586     0.150
     0.453     8.571     0.150
     0.453    15.351     0.150
     0.509     8.741     0.150
     0.509    16.061     0.150
     1.189    20.091     0.150
     1.435    24.071     0.150
     3.373   101.281     0.150
     4.035   115.091     0.150
     4.359   107.561     0.150
     5.478    81.391     0.150
     9.271   140.801     0.150
    10.428  3917.501     0.150
    10.974   162.901     0.150
    14.487   204.901     0.150
    15.487   217.081     0.150
    15.903   416.101     0.150
    20.786   280.901     0.150
    21.379   294.001     0.150
    22.027   299.701     0.150
    22.374   307.501     0.150
    23.421     7.500     0.150
    23.421   565.801     0.150
    25.146   328.401     0.150
    25.347   337.501     0.150
    25.447     6.899     0.150
    25.447    11.399     0.150
    25.484   333.801     0.150
    25.698   334.701     0.150
    25.958   333.051     0.150
    26.055   333.001     0.150
    26.815   347.201     0.150
    27.846   349.071     0.150
    30.845   375.671     0.150
    30.865   379.501     0.150
    30.865   685.301     0.150
    31.265   378.221     0.150
    31.270   378.601     0.150
    31.993     4.101     0.150
    34.819   409.201     0.150
    34.819   409.161     0.150
    34.819   409.911     0.150
    36.658   427.491     0.150
    40.706   460.321     0.150
    43.937   484.151     0.150
    45.783   504.401     0.150
    46.309     5.399     0.150
    46.309     8.399     0.150
    50.691   538.101     0.150
    51.332   544.361     0.150
    52.024   555.301     0.150
    52.024     3.800     0.150
    52.024     6.000     0.150
    52.024   999.801     0.150
    52.183  1132.901     0.150
    52.319   551.511     0.150
    54.575   572.741     0.150
    54.709   573.391     0.150
    55.922   577.371     0.150
    57.114   586.131     0.150
    63.892   633.214     0.150
    64.476   638.417     0.150
    68.567   664.956     0.150
    75.878   705.811     0.150
    85.598   757.741     0.150
    85.598   757.471     0.150
    88.505   771.341     0.150
    90.379   787.501     0.150
    90.379   787.501     0.150
    92.209   789.601     0.150
    92.685   800.801     0.150
    92.685   800.801     0.150
    94.857   812.931     0.150
    94.857   812.901     0.150
   119.546  1128.281     0.150
   146.606  1178.811     0.150
   151.410  1192.271     0.150
     1.442    24.838     0.150
     1.640    24.918     0.150
     4.043    66.308     0.150
    85.265   759.436     0.150
     0.405     4.750     0.150
     4.124   132.020     0.150
    11.012   163.219     0.150
    14.043   213.619     0.150
    14.503   213.420     0.150
    18.730   262.219     0.150
    22.185   293.920     0.150
    25.036   327.719     0.150
    25.396   334.619     0.150
    25.590   333.619     0.150
    25.929   337.520     0.150
    27.748   347.949     0.150
    31.356   379.020     0.150
    31.889     3.100     0.150
    31.889     5.900     0.150
    34.306   407.439     0.150
    34.748   408.859     0.150
    36.491     4.201     0.150
    36.491     7.301     0.150
    40.621   460.670     0.150
    44.818   493.170     0.150
    46.201     5.299     0.150
    46.201     8.000     0.150
    51.224   543.979     0.150
    51.907     5.199     0.150
    52.198   551.209     0.150
    55.162   572.539     0.150
    56.645   580.119     0.150
    56.999   585.988     0.150
    75.756   705.738     0.150
    79.185   725.818     0.150
    85.176   755.010     0.150
    85.337   756.219     0.150
   118.442  1125.109     0.150
   118.443  1125.109     0.150
   119.593  1129.789     0.150
   126.598  1141.830     0.150
     1.574    62.803     0.150
     2.029    65.271     0.150
     3.201    46.422     0.150
     4.134   113.072     0.150
     4.875    69.152     0.150
     3.908   129.166     0.150
    10.555  4089.557     0.150
    10.948   162.457     0.150
    10.948   154.707     0.150
    14.437   212.057     0.150
    15.440   217.256     0.150
    19.645   273.857     0.150
    22.390   305.957     0.150
    22.851   312.557     0.150
    23.379   307.131     0.150
    23.492   315.256     0.150
    25.350     5.301     0.150
    29.878   370.756     0.150
    31.298   382.057     0.150
    31.304   382.816     0.150
    31.930     5.199     0.150
    31.930     8.500     0.150
    34.320   407.727     0.150
    34.694   408.916     0.150
    34.851   412.566     0.150
    36.531     4.500     0.150
    36.531     7.500     0.150
    39.724   454.457     0.150
    40.674   457.527     0.150
    42.040   470.357     0.150
    42.077   471.557     0.150
    44.768   490.207     0.150
    46.238     5.801     0.150
    51.071   542.787     0.150
    51.071   543.166     0.150
    51.934     6.500     0.150
    52.200   552.957     0.150
    52.216   551.457     0.150
    57.028   585.736     0.150
    57.028   585.807     0.150
    57.028   585.736     0.150
    68.390  1459.957     0.150
    75.759   706.346     0.150
    85.220   756.006     0.150
   119.650  1129.727     0.150
     0.241     8.383     0.150
     1.667    26.623     0.150
     1.667    57.443     0.150
     2.103    67.912     0.150
     3.036    54.453     0.150
     4.843    61.832     0.150
    50.936   616.594     0.150
     1.594    62.898     0.150
     1.646    53.879     0.150
     1.848    28.439     0.150
     1.848    50.619     0.150
     2.063    65.998     0.150
     2.269    36.268     0.150
     2.845    43.168     0.150
     3.013   104.848     0.150
     3.219    47.488     0.150
     4.106    60.529     0.150
    10.694   159.928     0.150
    11.887   173.529     0.150
    13.214   193.129     0.150
    13.970   208.029     0.150
    15.114   214.289     0.150
    15.167   222.629     0.150
    18.604   259.969     0.150
    18.954   265.328     0.150
    19.323   271.328     0.150
    19.762   274.828     0.150
    19.762   268.908     0.150
    20.862   281.729     0.150
    20.862   281.758     0.150
    21.569   296.729     0.150
    22.903   302.629     0.150
    22.903   302.609     0.150
    22.926   309.328     0.150
    23.291   304.729     0.150
    23.487   306.629     0.150
    24.002   319.029     0.150
    24.350   313.928     0.150
    24.254   317.359     0.150
    25.089   327.928     0.150
    25.123     4.199     0.150
    25.123     7.100     0.150
    25.539   328.328     0.150
    25.484   328.428     0.150
    25.484   328.418     0.150
    25.583   334.428     0.150
    27.759   349.398     0.150
    27.895   348.529     0.150
    29.814   365.648     0.150
    29.814   365.629     0.150
    30.953     3.701     0.150
    31.859     5.799     0.150
    31.859     9.000     0.150
    34.028   403.988     0.150
    34.628   408.029     0.150
    34.628   561.328     0.150
    35.135   413.729     0.150
    36.456     4.100     0.150
    36.456     7.000     0.150
    36.456   425.629     0.150
    36.456     4.100     0.150
    36.456     7.000     0.150
    37.014   426.428     0.150
    37.014   426.428     0.150
    38.033   436.729     0.150
    39.993   453.229     0.150
    40.555   458.049     0.150
    40.723   459.859     0.150
    44.749   490.828     0.150
    44.749   490.828     0.150
    46.126     5.900     0.150
    46.126    10.500     0.150
    48.595   518.928     0.150
    50.963   538.428     0.150
    50.963   538.418     0.150
    50.963   541.729     0.150
    50.963   616.029     0.150
    51.151   542.029     0.150
    51.250   543.328     0.150
    51.250   616.629     0.150
    51.732     6.701     0.150
    51.732    10.500     0.150
    51.951   549.219     0.150
    53.931   626.158     0.150
    53.931   562.598     0.150
    55.554   575.168     0.150
    56.846   584.299     0.150
    61.994   621.729     0.150
    63.960   631.029     0.150
    75.400   703.469     0.150
    76.710   711.029     0.150
    81.080   732.828     0.150
    83.840   747.129     0.150
    83.908   751.229     0.150
    85.382   755.828     0.150
    88.559   771.629     0.150
    92.131   787.029     0.150
    92.463   791.229     0.150
    94.671   799.629     0.150
    95.060   799.729     0.150
    95.060  1026.729     0.150
    95.321   803.129     0.150
    95.556   804.129     0.150
   118.078  1123.953     0.150
   120.136  1130.539     0.150
   120.136  1130.529     0.150
   126.199  1140.154     0.150
   126.199  1140.129     0.150
   126.199  1140.148     0.150
   146.613  1179.529     0.150
   150.034  1194.148     0.150
   151.301  1191.549     0.150
     1.617    63.188     0.150
     1.664    55.719     0.150
     2.095    67.488     0.150
     2.291    82.268     0.150
     3.089    93.639     0.150
    25.452   329.389     0.150
    25.507   329.447     0.150
    27.743   348.447     0.150
    31.840     6.500     0.150
    31.840    10.500     0.150
    33.998   403.469     0.150
    34.639   407.287     0.150
    39.585   451.777     0.150
    40.544   459.578     0.150
    40.711   461.018     0.150
    46.105     7.100     0.150
    46.105     9.900     0.150
    50.942   541.158     0.150
    51.706     6.900     0.150
    51.923   549.268     0.150
    53.923   560.709     0.150
    55.526   576.139     0.150
    55.625   574.969     0.150
    56.821   583.709     0.150
    56.821   584.219     0.150
    79.161   724.424     0.150
    81.093   732.037     0.150
    85.359   755.688     0.150
    85.776   758.578     0.150
   120.160  1128.979     0.150
     1.243    22.320     0.150
     1.583    53.297     0.150
     2.145    74.777     0.150
     2.254    65.688     0.150
     2.584    40.547     0.150
     3.139    45.047     0.150
     3.149    48.598     0.150
     3.664    97.059     0.150
     4.126   117.258     0.150
     4.136    59.410     0.150
     4.326    64.379     0.150
     6.284   154.590     0.150
     9.663   140.570     0.150
    10.626  3916.898     0.150
    10.966   164.000     0.150
    14.496   206.770     0.150
    15.446   218.859     0.150
    15.822   407.199     0.150
    16.048   227.637     0.150
    16.472   420.199     0.150
    20.636   280.297     0.150
    21.658   295.898     0.150
    21.966   292.598     0.150
    22.318   305.000     0.150
    22.428   535.500     0.150
    25.282     5.699     0.150
    25.282     8.199     0.150
    25.282   597.297     0.150
    25.282   660.398     0.150
    25.282   327.898     0.150
    25.320   339.398     0.150
    25.321   334.598     0.150
    25.370   331.598     0.150
    25.499   333.898     0.150
    25.854   332.609     0.150
    25.860   337.598     0.150
    25.865   332.590     0.150
    27.616   348.297     0.150
    27.616   347.898     0.150
    27.737   349.047     0.150
    30.786   376.367     0.150
    30.806     4.801     0.150
    30.806     6.801     0.150
    31.872     5.598     0.150
    31.872     9.500     0.150
    34.248   408.078     0.150
    34.835   411.969     0.150
    34.988   413.445     0.150
    36.473     4.801     0.150
    36.473     7.801     0.150
    39.386   451.250     0.150
    40.454   459.727     0.150
    40.627   459.379     0.150
    43.851   487.379     0.150
    46.176     5.801     0.150
    46.176    11.500     0.150
    51.010   542.930     0.150
    51.200   543.949     0.150
    51.866     5.500     0.150
    51.866     8.301     0.150
    52.146   551.820     0.150
    52.562   555.297     0.150
    55.749   577.840     0.150
    56.962   587.430     0.150
    56.962   586.199     0.150
    68.331   662.898     0.150
    75.686   706.309     0.150
    75.838   706.898     0.150
    76.459   710.250     0.150
    79.160   901.297     0.150
    79.160  1012.398     0.150
    79.849   729.070     0.150
    80.515  1656.398     0.150
    80.696   733.227     0.150
    84.072   753.598     0.150
    85.164   756.820     0.150
    85.403   757.328     0.150
    85.458   757.609     0.150
    92.544   794.598     0.150
   119.682  1131.277     0.150
   146.693  1181.188     0.150
     1.684    56.395     0.150
     3.120    94.066     0.150
     3.240    51.156     0.150
    11.885   170.086     0.150
    13.291   190.484     0.150
    13.978   207.387     0.150
    15.090   213.066     0.150
    18.241   254.586     0.150
    25.092     5.699     0.150
    25.092     9.199     0.150
    25.092   591.484     0.150
    25.443   327.746     0.150
    25.546   328.617     0.150
    26.560   338.688     0.150
    27.747     6.500     0.150
    27.747   348.105     0.150
    30.146   367.867     0.150
    30.955     4.301     0.150
    30.955     7.301     0.150
    31.269   377.445     0.150
    31.843   384.484     0.150
    33.406   397.125     0.150
    33.992   403.277     0.150
    34.631   407.387     0.150
    35.156   413.555     0.150
    36.440     7.500     0.150
    36.440    10.500     0.150
    39.597   450.516     0.150
    40.552   458.426     0.150
    40.719   459.957     0.150
    42.487   475.156     0.150
    42.796   476.176     0.150
    44.757   593.711     0.150
    44.757   593.688     0.150
    44.757   492.375     0.150
    46.106     6.000     0.150
    46.106     8.199     0.150
    46.106   503.777     0.150
    50.779   538.535     0.150
    50.943   540.867     0.150
    51.132   542.375     0.150
    51.273   542.008     0.150
    51.704     6.500     0.150
    51.704     9.500     0.150
    51.704   991.887     0.150
    51.918   548.777     0.150
    52.419   552.688     0.150
    52.448   551.207     0.150
    53.188   562.598     0.150
    53.918   561.676     0.150
    53.921   564.984     0.150
    55.521   575.145     0.150
    55.622   574.176     0.150
    56.819   583.574     0.150
    56.819   583.555     0.150
    57.055   585.285     0.150
    60.683   610.875     0.150
    64.352   636.215     0.150
    64.764   633.887     0.150
    65.549   644.348     0.150
    65.626   642.895     0.150
    68.291   659.688     0.150
    68.374   660.008     0.150
    75.358   702.727     0.150
    76.272   708.375     0.150
    76.358   705.555     0.150
    80.260   729.086     0.150
    80.270   729.336     0.150
    80.319   729.305     0.150
    80.558   726.586     0.150
    80.558  1329.086     0.150
    80.630   731.645     0.150
    81.105   734.125     0.150
    81.878   738.125     0.150
    83.877   748.766     0.150
    83.877   748.715     0.150
    84.503   752.605     0.150
    85.163   754.305     0.150
    85.359   755.484     0.150
    85.359   755.445     0.150
    85.359   755.215     0.150
    85.794   758.164     0.150
    88.254   768.188     0.150
    88.254   768.188     0.150
    88.501   770.566     0.150
    88.535   771.387     0.150
    89.680   776.785     0.150
    89.680   776.758     0.150
    90.132   779.887     0.150
    90.196   789.285     0.150
    90.196   797.188     0.150
    92.441   790.586     0.150
    95.040   805.586     0.150
    95.040   805.586     0.150
    95.535   803.508     0.150
    95.535   802.566     0.150
    98.134   818.160     0.150
   118.036  1124.340     0.150
   120.181  1130.645     0.150
   125.663  1139.957     0.150
   146.618  1180.164     0.150
   150.081  1189.805     0.150
   151.297  1191.656     0.150
     1.275    36.027     0.150
     1.691    55.379     0.150
     1.765    56.168     0.150
    34.395   397.418     0.150
     2.846    71.137     0.150
     3.238    52.234     0.150
    10.056   147.246     0.150
    11.779   162.848     0.150
    11.886   173.047     0.150
    12.877   186.047     0.150
    13.166   189.848     0.150
    13.232   193.047     0.150
    14.781   209.207     0.150
    19.702   266.871     0.150
    19.702   271.746     0.150
    20.203   283.047     0.150
    20.617   278.246     0.150
    21.417   284.996     0.150
    24.327   315.645     0.150
    25.357     8.801     0.150
    25.743   537.082     0.150
    25.743   331.047     0.150
    25.841   336.348     0.150
    25.845   330.367     0.150
    26.074   334.887     0.150
    27.598   342.973     0.150
    27.930   349.246     0.150
    27.930   349.297     0.150
    29.877   370.145     0.150
    29.877   370.066     0.150
    30.232   371.617     0.150
    31.064     6.500     0.150
    32.044     3.500     0.150
    32.044     6.500     0.150
    34.277   405.555     0.150
    34.497   405.977     0.150
    35.151   416.145     0.150
    35.151   416.105     0.150
    36.643     4.301     0.150
    36.643     7.500     0.150
    40.690   460.047     0.150
    40.860   460.855     0.150
    42.790   475.938     0.150
    44.598   492.324     0.150
    46.326     6.500     0.150
    46.326    10.801     0.150
    51.162   542.477     0.150
    51.195   544.508     0.150
    51.351   543.746     0.150
    51.960     5.000     0.150
    51.960     8.398     0.150
    52.141   550.625     0.150
    52.195   550.125     0.150
    52.668   554.484     0.150
    55.798   575.984     0.150
    55.881   577.168     0.150
    57.068   584.695     0.150
    57.068   585.027     0.150
    75.659   703.656     0.150
    79.267   726.566     0.150
    79.288   721.848     0.150
    80.178   730.348     0.150
    80.178   730.305     0.150
    80.668   734.145     0.150
    80.668   918.445     0.150
    81.995   739.574     0.150
    84.144   748.477     0.150
    85.353   754.496     0.150
    85.591   755.566     0.150
    85.730   756.246     0.150
    86.899   767.246     0.150
    90.367   781.746     0.150
    92.675   791.348     0.150
    95.260   801.246     0.150
     1.615    52.793     0.150
    27.748   347.273     0.150
    35.075   409.094     0.150
     4.833    77.852     0.150
     6.276    89.234     0.150
     9.293   142.922     0.150
     9.622   151.422     0.150
    10.973   164.922     0.150
    14.447   212.523     0.150
    15.491   228.125     0.150
    18.530   260.824     0.150
    20.301   285.922     0.150
    23.735   319.023     0.150
    27.727    11.500     0.150
    31.361   378.793     0.150
    31.861     5.898     0.150
    31.861    10.500     0.150
    34.237   405.152     0.150
    34.830   410.074     0.150
    36.462     4.500     0.150
    36.462     7.902     0.150
    36.477   425.395     0.150
    36.973   426.012     0.150
    44.828   490.273     0.150
    50.999   541.465     0.150
    51.188   542.574     0.150
    51.855     6.301     0.150
    51.855     8.801     0.150
    52.134   550.602     0.150
    55.737   576.223     0.150
    56.950   584.934     0.150
    56.950   584.512     0.150
    60.791   611.363     0.150
    75.675   704.773     0.150
    75.827   702.125     0.150
    79.144   724.223     0.150
    84.061   752.023     0.150
    85.154   754.562     0.150
    87.046   765.633     0.150
   119.684  1129.773     0.150
   146.703  1180.395     0.150
     1.560    51.664     0.150
     3.052    45.086     0.150
     0.390     4.375     0.150
     0.390    10.445     0.150
     0.836    12.125     0.150
     0.836    25.070     0.150
     0.981    15.266     0.150
     1.605    21.195     0.150
     1.833    52.992     0.150
     2.157    61.430     0.150
     2.168    62.680     0.150
     2.701    39.727     0.150
     3.085   106.625     0.150
     3.122    45.758     0.150
     3.122    94.820     0.150
     3.625    60.188     0.150
     3.809    55.602     0.150
     4.111   113.602     0.150
     4.148    57.867     0.150
     4.293    61.477     0.150
     4.293   105.766     0.150
     6.255   152.070     0.150
     8.654   213.352     0.150
     9.684   148.398     0.150
    10.381   145.500     0.150
    13.894   198.398     0.150
    14.061   200.297     0.150
    15.448   212.555     0.150
    20.321   273.398     0.150
    20.618   275.695     0.150
    20.935   280.297     0.150
    21.805   294.195     0.150
    23.453   306.359     0.150
    24.787   319.188     0.150
    25.251     4.000     0.150
    25.251   323.781     0.150
    25.734   327.039     0.150
    25.832   328.586     0.150
    27.480   339.297     0.150
    27.610   344.680     0.150
    27.714   343.898     0.150
    29.978   364.250     0.150
    30.770   371.109     0.150
    30.770   439.109     0.150
    30.789     9.703     0.150
    31.396   376.297     0.150
    31.846     4.500     0.150
    31.846     8.195     0.150
    34.756   407.688     0.150
    34.831   407.320     0.150
    34.831   407.750     0.150
    36.447     9.102     0.150
    36.447    13.797     0.150
    39.374   445.461     0.150
    39.374   574.492     0.150
    40.434   454.680     0.150
    40.607   579.336     0.150
    40.607   456.805     0.150
    40.659   457.570     0.150
    44.839   490.898     0.150
    44.839   490.891     0.150
    46.149     8.000     0.150
    46.149    11.797     0.150
    46.149   832.797     0.150
    46.149   501.742     0.150
    50.983   538.797     0.150
    51.173   539.242     0.150
    51.836     6.500     0.150
    51.836     9.000     0.150
    52.114   547.602     0.150
    52.114   547.586     0.150
    53.886   558.008     0.150
    55.116   569.102     0.150
    55.116   569.188     0.150
    55.717   573.867     0.150
    56.932   580.781     0.150
    56.932   580.547     0.150
    60.777   608.297     0.150
    65.755   642.383     0.150
    68.305   654.500     0.150
    68.305   675.695     0.150
    75.653   700.469     0.150
    76.428   704.711     0.150
    79.221   719.000     0.150
    79.854   721.695     0.150
    79.854   721.695     0.150
    84.042   749.297     0.150
    85.140   753.297     0.150
    85.430   752.875     0.150
    88.635   769.836     0.150
    89.752   775.898     0.150
   119.699  1126.719     0.150
   125.227  1135.180     0.150
   166.575  1199.398     0.150
   166.575  1260.102     0.150
   166.575  1199.422     0.150
   166.575  1260.102     0.150
   166.575  1199.867     0.150
   166.575  1259.867     0.150
     1.574    52.570     0.150
     2.853    57.547     0.150
     3.156    90.391     0.150
     3.205    80.180     0.150
     3.709   121.219     0.150
     4.140    93.812     0.150
     4.178   109.000     0.150
     5.140    77.281     0.150
     5.259   122.938     0.150
     6.002   161.219     0.150
     8.377   208.070     0.150
    13.240   191.602     0.150
    13.685   186.289     0.150
    13.992   202.492     0.150
    14.548   206.594     0.150
    15.229   218.172     0.150
    16.944   233.391     0.150
    20.793   280.391     0.150
    20.793   280.391     0.150
    21.360   284.008     0.150
    21.986   306.992     0.150
    22.322   293.961     0.150
    22.643     7.500     0.150
    22.643    12.500     0.150
    23.208   311.992     0.150
    23.208     6.500     0.150
    23.300   308.492     0.150
    24.550   318.289     0.150
    25.178    10.602     0.150
    25.178    15.398     0.150
    25.178   592.688     0.150
    25.178   608.688     0.150
    25.178   325.078     0.150
    25.583   542.789     0.150
    25.583   328.430     0.150
    25.583   542.820     0.150
    25.695   330.391     0.150
    25.684   330.234     0.150
    25.684   328.750     0.150
    27.751   348.820     0.150
    27.798   349.289     0.150
    27.798   544.391     0.150
    29.079   364.188     0.150
    30.055   372.289     0.150
    30.882   376.484     0.150
    30.992   379.227     0.150
    30.992   379.227     0.150
    31.293   380.289     0.150
    31.318   379.930     0.150
    31.863    13.203     0.150
    31.863   693.891     0.150
    33.314   399.688     0.150
    33.967   407.594     0.150
    34.666   407.234     0.150
    34.666   486.594     0.150
    34.666   561.422     0.150
    34.869   411.586     0.150
    35.031   412.289     0.150
    35.079   416.688     0.150
    35.079    10.500     0.150
    35.079    14.805     0.150
    35.079   791.188     0.150
    36.462     9.695     0.150
    36.462    13.398     0.150
    36.833   430.688     0.150
    36.995   429.289     0.150
    36.995   427.078     0.150
    39.518   450.297     0.150
    40.520   462.008     0.150
    40.520   460.109     0.150
    40.520   459.398     0.150
    40.690   460.391     0.150
    40.690   460.500     0.150
    40.940   466.047     0.150
    42.140   476.133     0.150
    42.914   481.203     0.150
    42.914   481.750     0.150
    44.772   492.688     0.150
    44.772   492.688     0.150
    44.772   492.742     0.150
    46.144     9.898     0.150
    46.144    17.000     0.150
    46.144   827.891     0.150
    46.144  1104.789     0.150
    46.144   504.469     0.150
    50.979   622.422     0.150
    50.979   541.742     0.150
    51.116   542.453     0.150
    51.168   543.531     0.150
    51.779    10.500     0.150
    51.779    15.203     0.150
    51.959   547.812     0.150
    52.019   549.812     0.150
    52.019   549.789     0.150
    52.019   549.781     0.150
    52.344    11.602     0.150
    52.344   738.992     0.150
    52.344  1017.391     0.150
    52.344  1320.289     0.150
    52.344   550.969     0.150
    52.486   553.211     0.150
    53.924   562.414     0.150
    53.960   563.320     0.150
    53.986   565.812     0.150
    53.986   564.859     0.150
    55.125   572.531     0.150
    55.623   576.414     0.150
    55.701   575.914     0.150
    56.887   584.172     0.150
    56.916   587.594     0.150
    57.194   587.883     0.150
    60.783   611.734     0.150
    60.783   611.688     0.150
    61.909   621.391     0.150
    63.914   631.594     0.150
    64.082   638.172     0.150
    64.082   638.172     0.150
    64.622   639.289     0.150
    64.673   638.695     0.150
    65.398   643.438     0.150
    65.753   645.648     0.150
    65.753   646.500     0.150
    65.753   646.500     0.150
    65.820   647.195     0.150
    67.163   652.391     0.150
    67.773   661.633     0.150
    67.773   661.633     0.150
    68.316   910.594     0.150
    68.647   667.461     0.150
    68.647   667.461     0.150
    69.543   668.359     0.150
    75.420   702.273     0.150
    75.427   708.164     0.150
    75.427   708.164     0.150
    75.501   703.961     0.150
    76.254   708.891     0.150
    76.357   709.000     0.150
    76.639   703.992     0.150
    76.688   711.031     0.150
    76.759   710.992     0.150
    76.908   713.812     0.150
    76.908   712.539     0.150
    78.401   724.789     0.150
    79.071   730.188     0.150
    79.296   722.969     0.150
    79.504   723.664     0.150
    79.853   906.992     0.150
    80.150   728.312     0.150
    80.486  1343.492     0.150
    80.528   734.891     0.150
    80.631   727.391     0.150
    80.631  1329.391     0.150
    80.933   732.070     0.150
    80.946   732.141     0.150
    83.814   748.789     0.150
    84.591   751.453     0.150
    85.409   755.391     0.150
    86.421   760.992     0.150
    86.789   770.008     0.150
    86.789   770.008     0.150
    87.952   769.578     0.150
    88.405   769.094     0.150
    88.348   770.289     0.150
    88.348   770.289     0.150
    88.593   771.250     0.150
    89.730   778.492     0.150
    89.730   778.469     0.150
    89.730   778.469     0.150
    90.184   781.992     0.150
    90.250   792.094     0.150
    90.250   797.094     0.150
    90.449   780.227     0.150
    91.156   782.898     0.150
    91.298   785.719     0.150
    91.298   785.719     0.150
    92.122   785.492     0.150
    92.122   785.492     0.150
    92.404   788.547     0.150
    92.492   793.289     0.150
    93.306   793.352     0.150
    93.306   793.352     0.150
    94.690   802.094     0.150
    95.078   805.891     0.150
    95.078   805.891     0.150
    95.078  1638.891     0.150
    95.078  2105.891     0.150
    95.078  2315.891     0.150
    95.191   801.828     0.150
    95.551   809.891     0.150
    95.551   809.891     0.150
    95.581   805.789     0.150
    95.581   803.914     0.150
    96.973   818.891     0.150
   118.181  1124.297     0.150
   119.978  1129.914     0.150
   119.978  1128.234     0.150
   126.293  1145.492     0.150
   126.605  1145.992     0.150
   146.641  1180.289     0.150
   149.874  1187.391     0.150
   150.607  1190.273     0.150
   151.358  1189.992     0.150
   151.358  1189.961     0.150
   153.177  1187.234     0.150
   153.177  1206.617     0.150
   163.492  1199.188     0.150
   163.492  1250.492     0.150
   163.492  1199.148     0.150
   163.492  1250.492     0.150
   166.693  1263.992     0.150
   166.693  1205.359     0.150
   166.693  1263.992     0.150
     1.398    16.147     0.150
     5.077    65.668     0.150
    65.990   645.938     0.150
     2.917    98.296     0.150
     3.022    44.036     0.150
     3.022    77.586     0.150
     5.043    67.596     0.150
    65.955   646.605     0.150
    85.377   756.296     0.150
     1.441    43.207     0.150
     1.578    57.396     0.150
     1.901    61.928     0.150
     1.878    51.348     0.150
     2.255    64.338     0.150
     3.014   115.387     0.150
     3.208    46.457     0.150
     3.208    82.438     0.150
     4.860    67.947     0.150
    20.443   273.188     0.150
    50.975   540.268     0.150
     3.074   102.807     0.150
     3.114    89.037     0.150
     3.546    58.938     0.150
     4.952    79.416     0.150
    18.612   260.598     0.150
    19.114   258.986     0.150
    22.505   305.197     0.150
    23.697   308.797     0.150
    23.873   311.607     0.150
    25.718   336.297     0.150
    29.783   369.396     0.150
    30.844     6.801     0.150
    31.288   380.537     0.150
    31.314   379.537     0.150
    31.981     5.799     0.150
    31.981     9.299     0.150
    36.583     7.400     0.150
    36.583    10.500     0.150
    42.188   472.297     0.150
    46.300     5.500     0.150
    51.132   540.877     0.150
    51.322   541.746     0.150
    52.021     7.299     0.150
    52.021    10.000     0.150
    52.320   549.656     0.150
    54.004   561.428     0.150
    54.004   561.428     0.150
    55.923   574.438     0.150
    60.918   610.117     0.150
    65.191   638.508     0.150
    75.886   704.277     0.150
    77.721   712.477     0.150
    87.273   764.557     0.150
     0.676     9.352     0.150
     0.676    20.211     0.150
     1.180    16.852     0.150
     1.307    18.504     0.150
     1.307    38.402     0.150
     1.684    20.102     0.150
     1.684    58.641     0.150
     1.898    25.383     0.150
     2.358    32.254     0.150
     2.592    36.531     0.150
     2.592    67.453     0.150
     3.021    79.043     0.150
     3.628   100.004     0.150
     4.067   113.203     0.150
    15.422   226.602     0.150
    16.190   221.844     0.150
    21.926   298.301     0.150
    23.915   316.301     0.150
    24.924   326.004     0.150
    25.496   330.504     0.150
    25.500   324.703     0.150
    31.343   377.434     0.150
    31.343   377.430     0.150
    34.704   558.602     0.150
    50.874   537.324     0.150
    51.861   544.344     0.150
    55.464   570.504     0.150
    56.755   579.730     0.150
    56.755   579.082     0.150
    60.613   606.742     0.150
    68.220   655.703     0.150
    81.055   729.402     0.150
    83.817   748.504     0.150
    85.292   756.203     0.150
    85.292   751.832     0.150
   146.692  1177.402     0.150
     0.297     1.227     0.150
     0.530    21.195     0.150
     1.332    17.359     0.150
     1.768    59.500     0.150
     3.204    45.758     0.150
    34.830   405.500     0.150
     2.130    69.482     0.150
     3.016   104.361     0.150
     3.147    82.727     0.150
    15.077   207.281     0.150
    22.480   309.682     0.150
    27.793   351.482     0.150
    27.793   405.482     0.150
    27.850   347.881     0.150
    31.302   381.152     0.150
    31.930     6.500     0.150
    31.930    10.201     0.150
    36.531     4.600     0.150
    36.531     7.199     0.150
    51.932   554.982     0.150
    51.932     5.500     0.150
    51.932     8.100     0.150
    63.872   631.006     0.150
    79.847   730.012     0.150
    85.520   757.582     0.150
     0.155     3.004     0.150
     0.494     9.213     0.150
     0.948    17.072     0.150
     1.384    24.703     0.150
     1.543    44.832     0.150
     1.561    48.623     0.150
     2.599    41.553     0.150
     3.012   105.184     0.150
     3.699   128.174     0.150
     4.083   125.104     0.150
     4.275   109.633     0.150
     4.658   127.674     0.150
     5.177    86.965     0.150
     6.292    91.543     0.150
    10.719  4066.043     0.150
    14.636   209.143     0.150
    15.318   222.613     0.150
    15.881   414.043     0.150
    18.413   246.143     0.150
    21.325   295.643     0.150
    21.325   527.344     0.150
    21.773   304.943     0.150
    22.621     5.900     0.150
    22.621     9.301     0.150
    24.565   329.043     0.150
    25.088   339.844     0.150
    25.240   337.943     0.150
    25.256   338.844     0.150
    25.256     2.500     0.150
    25.256     4.000     0.150
    25.380   331.742     0.150
    25.697   333.072     0.150
    25.793   341.943     0.150
    26.550   353.844     0.150
    27.729   349.162     0.150
    27.772   350.043     0.150
    27.772   350.023     0.150
    28.162   359.844     0.150
    29.578   365.312     0.150
    31.294   552.604     0.150
    31.896     6.699     0.150
    31.896    10.000     0.150
    34.202   407.354     0.150
    34.674   563.844     0.150
    34.954   412.594     0.150
    36.458   429.004     0.150
    36.496     4.299     0.150
    36.496     7.500     0.150
    36.745   432.242     0.150
    38.329   443.543     0.150
    39.477   453.344     0.150
    39.477   453.383     0.150
    40.514   460.633     0.150
    41.960   471.242     0.150
    42.986   481.812     0.150
    44.767   492.742     0.150
    44.767   492.773     0.150
    51.023   543.023     0.150
    51.023   542.604     0.150
    51.212   546.242     0.150
    51.212   546.232     0.150
    51.351   546.803     0.150
    51.850     5.301     0.150
    51.850     8.400     0.150
    52.021   551.773     0.150
    52.108   550.793     0.150
    52.551   554.844     0.150
    53.008   560.393     0.150
    54.049   567.934     0.150
    55.712   576.883     0.150
    56.952   585.594     0.150
    56.952   585.412     0.150
    67.215   655.854     0.150
    68.352   682.443     0.150
    68.352  1200.043     0.150
    75.507   704.873     0.150
    75.616   704.732     0.150
    77.957   720.924     0.150
    79.079   728.033     0.150
    79.639   731.492     0.150
    80.529  1329.941     0.150
    80.836   737.393     0.150
    81.573   741.174     0.150
    82.162   743.723     0.150
    83.254   749.822     0.150
    83.816   751.543     0.150
    83.816   751.582     0.150
    84.046   753.363     0.150
    84.046   753.184     0.150
    85.197   754.863     0.150
    85.197   759.443     0.150
    85.461   759.443     0.150
    85.461   758.223     0.150
    85.538   758.014     0.150
    95.121   804.043     0.150
    95.121  2066.043     0.150
    95.121  2300.043     0.150
   118.299  1206.395     0.150
   118.299  1129.484     0.150
   119.835  1132.164     0.150
   146.639  1182.863     0.150
   149.727  1192.621     0.150
   151.384  1195.473     0.150
     1.741    42.805     0.150
     1.470    43.973     0.150
     2.172    35.703     0.150
    31.223   375.754     0.150
    43.875   488.863     0.150
    63.959   635.463     0.150
   118.379  1132.115     0.150
   118.379  1132.111     0.150
   146.572  1181.893     0.150
     0.224     3.355     0.150
     0.224    14.656     0.150
     0.522     8.297     0.150
     0.705    11.918     0.150
     1.133    18.195     0.150
     1.285    43.996     0.150
     1.611    59.176     0.150
     1.659    54.645     0.150
     2.284    79.027     0.150
     2.524    38.055     0.150
     3.026   113.066     0.150
     3.235    79.738     0.150
    12.780   173.555     0.150
    13.431   186.285     0.150
    19.325   257.418     0.150
    29.823   360.727     0.150
    29.825   360.727     0.150
    36.293   416.855     0.150
    37.030   422.707     0.150
    83.512   735.867     0.150
     0.498     8.648     0.150
     0.756    12.316     0.150
     1.548    60.816     0.150
     1.702    55.578     0.150
     2.220    77.855     0.150
     2.958    69.438     0.150
     3.096   103.855     0.150
     4.920    59.148     0.150
    25.162    11.102     0.150
    27.815   384.648     0.150
    32.895   398.348     0.150
    34.567   408.586     0.150
    34.567   408.367     0.150
    36.509     4.398     0.150
    36.509     7.500     0.150
    65.696   640.855     0.150
    31.392   376.355     0.150
     0.746    12.406     0.150
     0.746    23.164     0.150
     1.583    52.820     0.150
     2.255    37.547     0.150
     2.992    71.656     0.150
    14.578   213.055     0.150
    83.868   745.281     0.150
     0.374     9.490     0.150
     1.679    26.850     0.150
     2.314    42.869     0.150
     3.157    83.760     0.150
   118.442  1129.871     0.150
     1.546    50.160     0.150
    13.907   206.379     0.150
    19.970   269.309     0.150
    24.147   322.508     0.150
    24.665   328.508     0.150
    34.707   406.031     0.150
    34.863   407.371     0.150
    34.925   408.949     0.150
    44.787   490.211     0.150
    53.939   560.797     0.150
     1.120    39.312     0.150
    50.909   541.918     0.150
     3.257    93.027     0.150
    25.262   333.355     0.150
    27.688   351.559     0.150
    27.688   411.457     0.150
     2.303    60.984     0.150
     4.651    56.133     0.150
     6.483    99.805     0.150
     9.438   145.203     0.150
     9.766   140.242     0.150
    11.131   155.500     0.150
    12.175   167.703     0.150
    14.142   210.500     0.150
    15.625   218.602     0.150
    15.717   402.703     0.150
    20.288   282.000     0.150
    21.465   294.305     0.150
    21.797   298.000     0.150
    21.884   298.703     0.150
    23.540   306.977     0.150
    24.416   325.703     0.150
    24.976   327.000     0.150
    25.819   328.703     0.150
    25.914   331.594     0.150
    26.799   347.398     0.150
    26.799    11.703     0.150
    26.799   612.500     0.150
    27.413   350.102     0.150
    27.453   345.969     0.150
    27.659   349.500     0.150
    27.659   347.375     0.150
    29.254   361.180     0.150
    31.451   379.961     0.150
    31.456   379.922     0.150
    31.806     5.805     0.150
    34.270   405.633     0.150
    34.667   408.359     0.150
    36.408     4.398     0.150
    36.408     7.602     0.150
    36.442   427.500     0.150
    36.491   424.844     0.150
    37.015   429.148     0.150
    39.245   447.359     0.150
    40.346   456.695     0.150
    40.520   458.352     0.150
    44.755   490.500     0.150
    44.916   493.898     0.150
    46.125   503.680     0.150
    50.680   537.703     0.150
    50.680   537.703     0.150
    50.957   541.539     0.150
    51.147   542.500     0.150
    51.324   544.742     0.150
    51.849     7.305     0.150
    51.849     9.602     0.150
    52.020  1011.602     0.150
    52.155   549.664     0.150
    54.030   563.641     0.150
    55.758   576.484     0.150
    56.526   585.398     0.150
    56.937   584.859     0.150
    56.937   584.773     0.150
    60.743   610.930     0.150
    61.595   617.898     0.150
    68.268   659.742     0.150
    75.739   705.828     0.150
    77.942   722.102     0.150
    80.092   732.703     0.150
    80.509   730.633     0.150
    83.663   743.422     0.150
    83.663   747.453     0.150
    84.068   750.062     0.150
    85.427   758.602     0.150
    86.448   762.859     0.150
    87.115   767.484     0.150
    87.176   766.312     0.150
    88.184   781.844     0.150
    88.613   784.500     0.150
    88.621   774.602     0.150
    88.621   774.570     0.150
    89.239   782.398     0.150
    89.239   782.391     0.150
    90.479   782.805     0.150
    91.319   776.844     0.150
    92.503   792.102     0.150
   119.494  1129.203     0.150
     0.737    13.398     0.150
     0.737     4.492     0.150
     0.737    11.133     0.150
     1.567    62.992     0.150
     2.980   104.531     0.150
    13.333   192.828     0.150
    21.580   294.109     0.150
    25.012   329.906     0.150
    25.593   331.211     0.150
    25.597   329.891     0.150
    27.635   346.531     0.150
    27.793   349.008     0.150
    29.856   360.312     0.150
    29.856   360.352     0.150
    29.856   360.406     0.150
    29.856   360.383     0.150
    29.858   360.789     0.150
    31.891    15.805     0.150
    31.891    23.203     0.150
    34.043   404.469     0.150
    34.590   406.820     0.150
    35.179   413.648     0.150
    40.593   459.727     0.150
    40.761   460.898     0.150
    43.974   477.008     0.150
    44.713   491.812     0.150
    48.636   518.008     0.150
    50.733   538.438     0.150
    50.992   542.180     0.150
    51.181   543.297     0.150
    51.755    16.000     0.150
    51.755    22.297     0.150
    51.947   548.812     0.150
    51.969   548.836     0.150
    52.470   552.422     0.150
    52.933   556.070     0.150
    55.573   575.977     0.150
    56.871   584.383     0.150
    58.178   591.750     0.150
    59.070   599.336     0.150
    60.217   607.031     0.150
    60.803   611.148     0.150
    62.037   618.211     0.150
    68.339  1458.406     0.150
    69.394   666.312     0.150
    75.409   703.492     0.150
    80.189   730.133     0.150
    80.279   729.422     0.150
    80.327   730.109     0.150
    83.929   748.977     0.150
    86.637   762.078     0.150
    88.552   772.141     0.150
    88.585   771.867     0.150
    90.182   781.008     0.150
    92.491   793.508     0.150
     0.296     5.000     0.150
     1.395    22.398     0.150
     3.178   113.188     0.150
     3.261   107.484     0.150
     3.698    56.422     0.150
     3.698   105.664     0.150
     5.080    74.383     0.150
     6.482   100.844     0.150
     9.419   146.141     0.150
    10.523   153.641     0.150
    13.023   187.641     0.150
    13.985   203.469     0.150
    14.151   210.844     0.150
    14.244   213.539     0.150
    20.337   282.242     0.150
    21.406   293.242     0.150
    21.772   298.844     0.150
    21.822   296.641     0.150
    22.397   307.938     0.150
    24.233   322.641     0.150
    24.711   333.938     0.150
    25.229    13.602     0.150
    25.229    20.297     0.150
    25.229   614.242     0.150
    25.576   338.641     0.150
    25.852   331.891     0.150
    26.059   333.539     0.150
    26.370   331.844     0.150
    26.932   345.039     0.150
    27.479   345.492     0.150
    27.639    16.695     0.150
    27.639   392.438     0.150
    27.639   653.938     0.150
    27.639   347.398     0.150
    28.080    13.398     0.150
    28.080    19.102     0.150
    28.080   630.641     0.150
    28.080   659.539     0.150
    30.664   375.719     0.150
    31.458   376.438     0.150
    31.464   378.562     0.150
    31.781    20.102     0.150
    34.697   408.961     0.150
    34.855   408.984     0.150
    36.383    12.297     0.150
    36.383    17.297     0.150
    36.383   750.438     0.150
    37.045   428.750     0.150
    40.039   459.242     0.150
    40.339   457.609     0.150
    40.513   458.648     0.150
    45.587   502.641     0.150
    46.094    18.703     0.150
    46.094    21.000     0.150
    50.728   539.039     0.150
    50.896   540.203     0.150
    51.117   542.859     0.150
    51.438   544.570     0.150
    51.806    15.297     0.150
    51.806    21.102     0.150
    51.806   986.641     0.150
    52.042   985.938     0.150
    52.103   550.344     0.150
    52.103   550.359     0.150
    55.054   571.562     0.150
    55.706   576.430     0.150
    56.896   584.562     0.150
    61.615   617.938     0.150
    75.483   703.664     0.150
    75.676   704.602     0.150
    77.473   716.039     0.150
    79.169   726.539     0.150
    79.711   726.281     0.150
    79.758   726.961     0.150
    80.651   724.141     0.150
    84.020   749.914     0.150
    84.020   750.203     0.150
    85.263   755.469     0.150
    85.381   756.344     0.150
    85.392   754.141     0.150
    86.411   760.312     0.150
    87.127   769.539     0.150
    87.127   769.555     0.150
    87.100   767.164     0.150
    88.012   770.656     0.150
    88.573   771.172     0.150
    88.584   773.242     0.150
    88.775   771.438     0.150
    90.230   784.344     0.150
    90.442   781.602     0.150
    95.546   803.992     0.150
   119.562  1129.492     0.150
   146.803  1181.211     0.150
   166.571  1206.242     0.150
     3.125   111.125     0.150
     6.439   108.609     0.150
     9.772   149.609     0.150
    11.105   163.758     0.150
    13.067   189.750     0.150
    13.574   197.898     0.150
    13.632   198.578     0.150
    14.391   207.328     0.150
    15.609   222.805     0.150
    18.716   258.508     0.150
    18.659   260.508     0.150
    20.138   270.906     0.150
    20.953   287.609     0.150
    20.953   286.586     0.150
    23.304   346.609     0.150
    24.434   327.305     0.150
    25.017   326.234     0.150
    25.487   339.406     0.150
    25.980   334.305     0.150
    25.980   542.781     0.150
    27.480   347.250     0.150
    30.707   375.867     0.150
    31.401   376.305     0.150
    31.407   556.281     0.150
    31.865    14.203     0.150
    31.865    21.500     0.150
    34.690   410.031     0.150
    34.805   409.352     0.150
    40.395   459.086     0.150
    40.570   460.906     0.150
    44.865   495.016     0.150
    46.186    13.500     0.150
    46.186    22.000     0.150
    50.685   541.305     0.150
    50.685   541.359     0.150
    50.685   540.141     0.150
    50.823   541.414     0.150
    51.208   544.648     0.150
    51.913    15.203     0.150
    51.913    22.805     0.150
    51.913   990.109     0.150
    52.050    13.898     0.150
    52.050   616.609     0.150
    52.050  1017.211     0.150
    52.063   551.906     0.150
    52.221   552.000     0.150
    52.601   555.555     0.150
    53.050   559.086     0.150
    54.093   565.211     0.150
    55.824   579.055     0.150
    55.844   578.930     0.150
    57.000   586.836     0.150
    57.000   586.727     0.150
    68.326  1468.711     0.150
    68.326   660.914     0.150
    75.804   708.195     0.150
    77.639   715.148     0.150
    80.520   745.008     0.150
    80.520   751.008     0.150
    84.133   751.188     0.150
    85.144   756.188     0.150
    85.477   759.727     0.150
    85.488   759.008     0.150
    86.511   763.805     0.150
    87.179   774.508     0.150
    87.179   774.547     0.150
    87.231   768.672     0.150
    87.232   768.828     0.150
    88.059   778.305     0.150
    88.059   778.305     0.150
    88.684   775.172     0.150
    88.805   772.641     0.150
    89.629   776.367     0.150
    90.302   792.219     0.150
    90.542   782.117     0.150
    92.076   787.406     0.150
    93.699   796.352     0.150
   121.584  1134.859     0.150
   125.028  1140.180     0.150
   146.742  1183.359     0.150
   149.365  1189.758     0.150
     1.538    50.352     0.150
     2.155    60.188     0.150
     3.191    46.711     0.150
     4.114    66.656     0.150
     6.348    90.055     0.150
    10.953   168.859     0.150
    11.013   169.055     0.150
    12.031   165.656     0.150
    13.909   205.047     0.150
    15.434   218.039     0.150
    17.298   236.656     0.150
    20.755   289.859     0.150
    21.264   300.656     0.150
    21.956   300.555     0.150
    22.441   310.055     0.150
    22.817   308.656     0.150
    25.500   334.055     0.150
    25.866   336.656     0.150
    25.870   336.555     0.150
    26.861   345.359     0.150
    27.630   347.055     0.150
    31.333   367.961     0.150
    31.338   574.258     0.150
    31.884     4.398     0.150
    31.884     6.898     0.150
    34.725   583.555     0.150
    34.725   408.445     0.150
    34.849   410.727     0.150
    34.849   410.578     0.150
    36.484     4.500     0.150
    36.484     7.500     0.150
    36.498   427.414     0.150
    36.951   426.906     0.150
    40.467   459.125     0.150
    40.632   460.289     0.150
    40.640   460.148     0.150
    42.938   480.055     0.150
    44.805   493.156     0.150
    51.021   542.406     0.150
    51.021    21.000     0.150
    51.211   544.078     0.150
    51.876     4.898     0.150
    51.876     6.102     0.150
    52.038   550.469     0.150
    52.154   551.031     0.150
    52.572   553.805     0.150
    55.757   577.188     0.150
    55.803   577.781     0.150
    56.972   585.445     0.150
    56.972   585.109     0.150
    63.841   652.906     0.150
    69.487   666.227     0.150
    75.692   705.000     0.150
    85.468   755.758     0.150
    95.120   802.258     0.150
   119.691  1130.227     0.150
   146.680  1202.211     0.150
    11.193   168.250     0.150
    23.007   296.852     0.150
     6.358    99.641     0.150
    10.941   167.141     0.150
    10.994   166.641     0.150
    12.036   163.741     0.150
    13.852   206.741     0.150
    13.852   199.201     0.150
    14.407   211.241     0.150
    14.511   204.571     0.150
    15.411   212.951     0.150
    15.838   243.641     0.150
    18.499   271.441     0.150
    19.979   266.141     0.150
    20.576   276.041     0.150
    21.556   296.541     0.150
    22.213   302.241     0.150
    22.552     7.300     0.150
    23.244   310.041     0.150
    23.244   561.241     0.150
    24.169   325.741     0.150
    24.790   331.941     0.150
    25.246     3.300     0.150
    25.246     6.800     0.150
    25.246   601.641     0.150
    25.246   324.111     0.150
    25.780   335.941     0.150
    25.815   328.841     0.150
    27.642   345.381     0.150
    27.725   398.341     0.150
    27.725   345.841     0.150
    28.133   640.041     0.150
    28.133   646.241     0.150
    29.481   360.221     0.150
    30.792   372.791     0.150
    31.353   376.711     0.150
    31.855     5.500     0.150
    33.795     8.900     0.150
    34.205   403.551     0.150
    34.738   406.011     0.150
    34.865   408.761     0.150
    34.923     6.500     0.150
    34.923   742.841     0.150
    36.455     4.100     0.150
    36.455     7.200     0.150
    36.451   424.261     0.150
    40.453   456.231     0.150
    40.625   457.831     0.150
    44.823   490.941     0.150
    44.823   490.981     0.150
    44.861   492.341     0.150
    45.695   496.141     0.150
    46.155     4.800     0.150
    46.155     9.000     0.150
    46.155   503.311     0.150
    50.989   539.811     0.150
    51.327   541.371     0.150
    51.833     5.800     0.150
    51.833     9.800     0.150
    51.999   547.651     0.150
    52.199   544.441     0.150
    52.199    15.700     0.150
    52.199   983.141     0.150
    52.199  1009.241     0.150
    52.106   548.071     0.150
    52.683   549.241     0.150
    52.986   555.461     0.150
    53.897   560.141     0.150
    54.000   562.591     0.150
    55.709   574.491     0.150
    55.760   574.851     0.150
    56.931   582.861     0.150
    63.597   629.855     0.150
    65.820   642.781     0.150
    65.952   643.709     0.150
    68.312  1200.841     0.150
    75.636   702.741     0.150
    75.636   702.761     0.150
    79.858   730.441     0.150
    80.740   729.781     0.150
    84.036   750.741     0.150
    85.151   752.721     0.150
    85.151   755.741     0.150
    85.433   754.561     0.150
    86.992   764.191     0.150
    87.162   760.341     0.150
    87.162   760.350     0.150
    87.912   764.412     0.150
    87.994   773.941     0.150
    87.994   773.904     0.150
    88.050   770.015     0.150
    88.355   769.321     0.150
    88.597   768.241     0.150
    88.597   768.191     0.150
    88.610   769.111     0.150
    88.627   770.533     0.150
    88.627   770.601     0.150
    92.093   785.241     0.150
    94.702   798.141     0.150
    95.087   800.741     0.150
   119.741  1127.641     0.150
   121.846  1131.941     0.150
   125.267  1137.911     0.150
   126.467  1139.931     0.150
   144.896  1173.631     0.150
   146.697  1178.721     0.150
   149.635  1187.211     0.150
   166.587  1203.431     0.150
   172.845  1207.111     0.150
    25.813   328.458     0.150
    56.952   583.988     0.150
    83.698   749.941     0.150
     1.425    23.523     0.150
     3.156    86.031     0.150
     3.284    95.129     0.150
     3.559    54.641     0.150
     9.727   148.332     0.150
    11.075   168.934     0.150
    11.136   167.633     0.150
    23.688   325.832     0.150
    23.688   325.832     0.150
    27.507   350.508     0.150
    27.657   353.730     0.150
    31.797   384.332     0.150
    31.797     6.000     0.150
    31.797     8.898     0.150
    36.398     5.102     0.150
    36.398     8.000     0.150
    46.108     6.500     0.150
    56.906   585.531     0.150
     4.060    65.887     0.150
     9.772   135.645     0.150
    31.794     5.699     0.150
    31.794     8.801     0.150
    36.396     5.801     0.150
    36.396     8.699     0.150
    46.111     6.102     0.150
     3.079    54.453     0.150
    63.807   630.531     0.150
     1.535    50.992     0.150
     2.578    67.332     0.150
     3.153    81.343     0.150
    10.936   152.643     0.150
    18.492   251.973     0.150
    31.309   376.152     0.150
    51.062   544.053     0.150
   118.421  1128.269     0.150
     1.490    53.465     0.150
     2.133    69.082     0.150
     2.356    40.465     0.150
     2.976    91.645     0.150
     3.713    96.285     0.150
     4.033   104.523     0.150
    10.518  4056.684     0.150
    24.494   322.973     0.150
    52.261   554.172     0.150
     1.647    52.078     0.150
     2.003    66.492     0.150
     2.276    79.633     0.150
     3.153    98.742     0.150
     3.232    93.828     0.150
     3.274    53.742     0.150
     3.274    92.445     0.150
     3.274    53.461     0.150
     3.822    96.805     0.150
     4.206   117.555     0.150
     4.186   105.055     0.150
     4.783    94.750     0.150
     5.114    82.945     0.150
     6.461    87.922     0.150
    10.575  3935.922     0.150
    13.045   193.539     0.150
    13.554   196.461     0.150
    13.608   196.133     0.150
    14.125   213.219     0.150
    16.584   240.523     0.150
    18.947   263.078     0.150
    21.084   284.820     0.150
    21.861   295.023     0.150
    22.445   302.820     0.150
    23.201   311.320     0.150
    24.366   324.125     0.150
    24.945   333.422     0.150
    24.984   327.320     0.150
    25.267    14.695     0.150
    25.267   654.820     0.150
    25.267   325.250     0.150
    25.795   330.422     0.150
    25.891   331.125     0.150
    27.381   355.125     0.150
    27.489   345.078     0.150
    27.669   345.844     0.150
    28.115    12.500     0.150
    28.115   659.719     0.150
    29.299   361.344     0.150
    29.299   360.109     0.150
    29.300   361.344     0.150
    29.962   364.094     0.150
    30.686   372.398     0.150
    31.439   378.164     0.150
    31.439   551.320     0.150
    31.813    13.695     0.150
    31.813    20.195     0.150
    31.813   817.922     0.150
    34.254   404.680     0.150
    34.704   408.281     0.150
    34.704   408.422     0.150
    34.832   408.422     0.150
    34.832   560.750     0.150
    34.769    15.203     0.150
    36.414    15.102     0.150
    36.479   425.000     0.150
    37.012   427.078     0.150
    39.274   446.781     0.150
    39.659   449.125     0.150
    40.039   469.320     0.150
    40.364   456.430     0.150
    40.364   456.523     0.150
    40.364   456.555     0.150
    43.016   478.172     0.150
    43.232   478.172     0.150
    43.760   499.625     0.150
    43.900   484.203     0.150
    44.100   486.492     0.150
    44.773   493.312     0.150
    44.900   492.719     0.150
    44.900   492.750     0.150
    46.127   503.812     0.150
    50.725   538.148     0.150
    50.725   538.148     0.150
    50.867   539.898     0.150
    50.960   540.359     0.150
    51.411   544.000     0.150
    51.321   543.664     0.150
    51.996   547.883     0.150
    52.053   615.625     0.150
    52.053  1123.820     0.150
    52.142   549.375     0.150
    52.533   552.492     0.150
    52.983   555.484     0.150
    53.840   560.328     0.150
    53.998   561.820     0.150
    54.026   564.062     0.150
    54.026   563.664     0.150
    55.086   570.820     0.150
    55.745   575.719     0.150
    55.772   575.281     0.150
    56.789   581.859     0.150
    56.932   583.961     0.150
    56.932   583.820     0.150
    60.748   610.141     0.150
    60.748   610.125     0.150
    60.748   610.219     0.150
    64.266   650.625     0.150
    64.169   632.562     0.150
    64.215   634.219     0.150
    64.318   633.500     0.150
    64.318   633.500     0.150
    64.749   636.852     0.150
    66.647   649.789     0.150
    67.310   653.812     0.150
    67.431   654.039     0.150
    68.031   658.133     0.150
    68.317   660.453     0.150
    68.415   660.016     0.150
    68.906   663.586     0.150
    68.906   664.891     0.150
    74.718    23.797     0.150
    75.501   702.391     0.150
    75.520   701.539     0.150
    75.715   704.164     0.150
    76.441   708.695     0.150
    77.989   718.078     0.150
    79.137  1007.922     0.150
    79.137  1310.125     0.150
    79.137  1823.719     0.150
    80.463  1642.625     0.150
    80.554   730.039     0.150
    80.687   733.219     0.150
    81.096   731.289     0.150
    83.679   746.000     0.150
    84.058   747.953     0.150
    84.058   747.812     0.150
    84.682   751.375     0.150
    85.097   752.320     0.150
    85.263   753.422     0.150
    85.415   754.414     0.150
    85.415   754.141     0.150
    86.745   767.008     0.150
    87.109   762.805     0.150
    87.137   764.359     0.150
    88.150   773.047     0.150
    88.324   769.328     0.150
    88.609   769.672     0.150
    88.774   769.664     0.150
    91.278   784.125     0.150
    92.032   788.125     0.150
    92.032   788.125     0.150
    92.032   787.922     0.150
    92.379   787.055     0.150
    92.503   792.922     0.150
    92.780   789.148     0.150
    94.675   803.773     0.150
    94.675   803.820     0.150
    95.580   802.211     0.150
   118.403  1191.703     0.150
   118.403  1191.414     0.150
   121.650  1132.023     0.150
   151.566  1191.484     0.150
   166.532  1204.211     0.150
   172.688  1206.828     0.150
     8.287   127.836     0.150
    13.209   196.016     0.150
    27.567   349.135     0.150
    81.708   735.365     0.150
     3.856   109.895     0.150
    31.317   381.211     0.150
     2.188    60.734     0.150
     2.306    75.262     0.150
     3.041   107.324     0.150
     2.198    61.018     0.150
     3.822    98.107     0.150
    25.759   336.147     0.150
    27.913   353.322     0.150
    31.378   381.348     0.150
    31.378   554.997     0.150
     1.375    41.589     0.150
     3.233   110.499     0.150
    22.358   296.809     0.150
    36.430     9.801     0.150
    36.430    14.000     0.150
    40.545   582.328     0.150
    44.892   493.758     0.150
     2.300    84.715     0.150
     2.681    42.406     0.150
     3.042   107.145     0.150
     8.730   124.906     0.150
    14.776   230.855     0.150
    18.728   262.953     0.150
    19.543   288.754     0.150
    21.307   292.754     0.150
    24.167   320.855     0.150
    30.822   422.355     0.150
    31.907    29.000     0.150
    31.907   433.555     0.150
    33.777   399.055     0.150
    36.508    26.801     0.150
    36.508   763.555     0.150
    40.610   461.355     0.150
    41.216   466.254     0.150
    57.007   585.656     0.150
    81.416   733.156     0.150
     1.529    45.941     0.150
     2.164    59.082     0.150
     2.319    87.125     0.150
     4.072    68.555     0.150
    15.074   217.742     0.150
    36.535     3.699     0.150
    36.535     6.199     0.150
    65.798   646.941     0.150
     3.261    45.488     0.150
     8.216   131.359     0.150
    13.456   201.348     0.150
    27.716   539.438     0.150
    40.681   464.102     0.150
    53.888   565.902     0.150
     2.492    47.301     0.150
     2.492    80.422     0.150
    10.583   145.637     0.150
    10.607  4168.711     0.150
    12.862   311.109     0.150
    13.687   200.633     0.150
    13.736   203.832     0.150
    14.097   203.211     0.150
    15.449   219.312     0.150
    16.499   233.410     0.150
    19.970   272.637     0.150
    21.862   294.910     0.150
    22.577    13.500     0.150
    22.577   551.109     0.150
    23.303    15.000     0.150
    23.303   603.512     0.150
    25.180   330.410     0.150
    25.310    10.402     0.150
    25.310    14.500     0.150
    25.310   608.609     0.150
    25.310   660.312     0.150
    25.888   332.352     0.150
    27.769   400.609     0.150
    27.769   627.910     0.150
    27.769   348.461     0.150
    28.188   644.312     0.150
    29.461   547.781     0.150
    29.461   362.020     0.150
    30.817   375.621     0.150
    30.837    10.199     0.150
    30.837    13.902     0.150
    31.314   378.000     0.150
    31.319   552.344     0.150
    31.319   378.410     0.150
    31.542   378.211     0.150
    31.904    17.699     0.150
    31.904   695.012     0.150
    31.904   715.711     0.150
    31.904   816.012     0.150
    33.147   395.812     0.150
    34.275   405.422     0.150
    34.707   561.387     0.150
    34.707   408.449     0.150
    34.862   410.820     0.150
    34.924   411.500     0.150
    36.505     9.301     0.150
    36.505    13.402     0.150
    36.505   774.410     0.150
    36.931   427.781     0.150
    40.659   580.672     0.150
    40.659   459.871     0.150
    41.203   458.426     0.150
    43.075   476.980     0.150
    43.972   485.973     0.150
    44.786   492.473     0.150
    46.208     9.898     0.150
    50.763   540.160     0.150
    50.887   541.512     0.150
    50.887   541.492     0.150
    50.887   540.262     0.150
    51.041   542.582     0.150
    51.298   543.512     0.150
    51.231   544.051     0.150
    51.896   987.812     0.150
    52.058   550.492     0.150
    52.205    14.902     0.150
    52.205   988.512     0.150
    52.205  1132.812     0.150
    53.941   629.945     0.150
    55.776   576.152     0.150
    56.727   585.109     0.150
    64.427   869.512     0.150
    65.812   643.590     0.150
    65.893   643.750     0.150
    68.362   659.812     0.150
    75.710   705.051     0.150
    78.783   720.410     0.150
    79.187   723.910     0.150
    79.847   725.941     0.150
    79.869   726.211     0.150
    80.546  1025.410     0.150
    80.716   730.582     0.150
    80.743   725.910     0.150
    85.196   754.551     0.150
    85.637   758.711     0.150
    90.335   791.012     0.150
    92.575   797.711     0.150
    92.575   797.711     0.150
     1.377    42.156     0.150
    27.760   351.271     0.150
    31.273   380.971     0.150
    56.955   582.182     0.150
    56.955   582.182     0.150
    81.636   734.951     0.150
     3.265    59.988     0.150
    25.643   334.676     0.150
    31.391   382.121     0.150
    34.862   414.176     0.150
     0.439     8.053     0.150
     0.439    14.633     0.150
     1.280    42.113     0.150
     2.226    65.223     0.150
     2.676    82.963     0.150
     3.176    52.873     0.150
    13.888   200.443     0.150
    19.511   271.432     0.150
    20.730   276.953     0.150
    22.231   298.832     0.150
    22.231   296.592     0.150
    23.332   313.633     0.150
    25.870   331.072     0.150
    26.626   342.133     0.150
    27.653   346.072     0.150
    27.765   348.332     0.150
    27.765   348.352     0.150
    31.897    19.000     0.150
    31.897    26.400     0.150
    34.259   406.062     0.150
    34.707   560.883     0.150
    34.707   406.113     0.150
    34.873   410.252     0.150
    36.498    14.900     0.150
    36.498    21.801     0.150
    40.658   579.568     0.150
    40.658   459.963     0.150
    44.788   492.283     0.150
    51.033   541.553     0.150
    51.223   542.973     0.150
    51.884  1019.232     0.150
    52.581   552.283     0.150
    55.167   571.623     0.150
    56.981   584.512     0.150
    56.981   584.512     0.150
    60.827   611.203     0.150
    75.691   704.271     0.150
    75.865   701.232     0.150
    79.107   723.432     0.150
    79.177   719.932     0.150
    85.191   755.732     0.150
    87.044   766.152     0.150
    92.565   789.633     0.150
     0.398     8.195     0.150
     0.398    14.586     0.150
     1.264    43.227     0.150
     1.601    56.141     0.150
     2.175    72.523     0.150
     2.650    97.195     0.150
     2.691    43.102     0.150
     3.180    53.016     0.150
     3.418    98.312     0.150
     4.113   117.047     0.150
     6.291   100.945     0.150
     9.678   134.586     0.150
    10.671  4335.484     0.150
    10.960   164.688     0.150
    11.015   157.281     0.150
    13.542   191.781     0.150
    14.428   223.984     0.150
    20.326   281.281     0.150
    20.599   282.383     0.150
    21.246   291.883     0.150
    21.796   298.188     0.150
    22.237   298.484     0.150
    22.411   293.586     0.150
    24.901   327.484     0.150
    26.579   344.383     0.150
    27.716   352.984     0.150
    31.360   375.031     0.150
    34.844   411.406     0.150
    36.448    14.000     0.150
    36.448    21.297     0.150
    55.711   577.031     0.150
    87.008   766.133     0.150
     2.479    80.766     0.150
     1.584    55.969     0.150
    31.348   380.754     0.150
     2.498    79.258     0.150
     8.818   122.387     0.150
    18.962   267.227     0.150
    23.771   308.406     0.150
    40.539   461.676     0.150
    67.175   655.453     0.150
    73.981   689.488     0.150
     0.932    16.406     0.150
     0.657    13.414     0.150
     0.657    24.219     0.150
     2.225    36.469     0.150
     3.089    81.938     0.150
     8.816   133.500     0.150
    15.539   214.797     0.150
    38.542   446.258     0.150
    40.260   460.359     0.150
    40.815   464.555     0.150
    51.144   542.562     0.150
    54.025   563.570     0.150
    55.913   581.430     0.150
    57.112   589.625     0.150
   118.547  1127.531     0.150
   146.594  1182.023     0.150
     1.528    44.592     0.150
     2.192    67.201     0.150
     3.157    46.021     0.150
    10.846   151.582     0.150
    51.038   545.211     0.150
    53.959   565.760     0.150
    63.910   634.947     0.150
     2.207    33.539     0.150
    10.674  4129.859     0.150
    19.948   275.035     0.150
    34.895   409.551     0.150
    38.350   443.961     0.150
    38.456   445.359     0.150
    39.153   451.461     0.150
    39.726   454.160     0.150
    40.367   458.461     0.150
    40.532   460.059     0.150
    41.943   470.059     0.150
    41.982   469.758     0.150
    46.181   502.871     0.150
    50.945   538.350     0.150
    50.945   611.125     0.150
     0.601    12.991     0.150
     3.081    43.241     0.150
     4.165    86.521     0.150
     0.672    13.176     0.150
     0.672    24.656     0.150
     1.168    18.105     0.150
     1.168    33.617     0.150
     1.270    22.047     0.150
     1.270    45.037     0.150
     1.881    27.957     0.150
     2.312    80.287     0.150
     3.263    99.332     0.150
    20.901   287.262     0.150
    24.891   328.836     0.150
     1.327    38.924     0.150
     2.457    35.033     0.150
     3.187    81.164     0.150
    40.331   454.404     0.150
    56.922   580.965     0.150
    56.922   581.244     0.150
     2.245    74.109     0.150
     3.048    74.809     0.150
    40.512   462.836     0.150
     0.466     8.008     0.150
     0.466    14.805     0.150
     1.193    19.867     0.150
    13.687   195.961     0.150
    42.130   472.031     0.150
    51.097   544.203     0.150
    51.287   545.977     0.150
    53.979   564.906     0.150
    61.749   620.047     0.150
     1.449    54.834     0.150
     1.666    26.754     0.150
     2.118    76.014     0.150
     3.295    48.644     0.150
    25.894   337.378     0.150
    27.710   354.892     0.150
    27.875   351.794     0.150
     0.613    21.941     0.150
     0.491    18.223     0.150
     2.386    87.953     0.150
     2.228    87.648     0.150
     3.129    81.348     0.150
     3.174    52.812     0.150
     3.174    53.758     0.150
     4.162    59.188     0.150
     4.162    89.107     0.150
     4.872    66.408     0.150
     5.184    76.527     0.150
    13.855   206.049     0.150
    16.471   411.408     0.150
    19.153   269.107     0.150
    23.286   305.908     0.150
    23.639   314.088     0.150
    31.897     4.199     0.150
    31.897     8.699     0.150
    34.954     8.500     0.150
    34.954    12.199     0.150
    34.954   789.908     0.150
    46.197     6.301     0.150
    51.875     4.500     0.150
    51.875     6.699     0.150
    81.499   734.479     0.150
     0.456    11.931     0.150
     0.456    19.620     0.150
     1.157    19.771     0.150
     1.157    40.301     0.150
    27.575   351.870     0.150
    80.599   735.442     0.150
     0.472    12.492     0.150
     0.472    20.391     0.150
     3.539    94.320     0.150
    52.025   542.012     0.150
    52.025    15.398     0.150
     0.345     9.867     0.150
     0.345    16.258     0.150
     1.207    41.926     0.150
     1.377    40.855     0.150
     3.165    57.535     0.150
     3.208   106.582     0.150
    36.471     8.602     0.150
    36.471    12.801     0.150
    40.615   462.953     0.150
    44.828   493.957     0.150
    51.011   539.410     0.150
     0.319    10.449     0.150
     0.319    16.008     0.150
     4.141   119.828     0.150
    23.364   313.484     0.150
     0.277     8.703     0.150
     0.277    13.414     0.150
     0.825    15.926     0.150
     0.418    11.914     0.150
     0.418    19.492     0.150
     1.642    56.547     0.150
    34.735   415.023     0.150
     1.416    40.770     0.150
     3.148    81.189     0.150
    25.777   336.791     0.150
     0.357    13.562     0.150
     0.314     4.803     0.150
     0.314     8.732     0.150
     0.992    17.693     0.150
     0.992    37.332     0.150
     1.638    58.223     0.150
    27.927   352.953     0.150
    40.691   461.934     0.150
    43.909   488.803     0.150
    44.872   496.293     0.150
     0.277     8.297     0.150
     0.277    13.141     0.150
     1.268    43.391     0.150
     2.470    46.414     0.150
     3.402    83.180     0.150
     7.225   103.617     0.150
     9.659   134.625     0.150
    13.665   191.641     0.150
    22.431     7.297     0.150
    22.431   549.156     0.150
    25.270   330.859     0.150
    27.288   339.469     0.150
    27.737   355.359     0.150
    27.737    18.695     0.150
    36.470     5.102     0.150
    36.470     8.703     0.150
    43.997   482.250     0.150
    46.172     5.703     0.150
    51.195   540.500     0.150
    51.347   543.234     0.150
    56.953   584.008     0.150
    65.065   636.258     0.150
    65.724     0.148     0.150
    82.046   732.156     0.150
    87.027   762.461     0.150
   119.712  1129.930     0.150
    13.668   202.711     0.150
    13.715   204.000     0.150
    25.252     4.598     0.150
    31.351   375.531     0.150
    31.861     4.602     0.150
    31.861     7.801     0.150
    34.732   561.090     0.150
     1.588    53.164     0.150
    34.744   411.734     0.150
     1.618    53.934     0.150
    25.388   337.676     0.150
    25.398   337.359     0.150
    26.247   347.402     0.150
     2.100    38.732     0.150
     2.100    73.142     0.150
     3.229    91.647     0.150
     4.135   108.982     0.150
    13.698   201.512     0.150
    53.891   561.202     0.150
    83.770   744.462     0.150
    88.498   767.692     0.150
     1.563    51.988     0.150
     2.001    67.730     0.150
     8.290   123.531     0.150
    10.763   160.621     0.150
    78.724   718.730     0.150
    81.727   734.410     0.150
     3.001    73.727     0.150
     0.687    12.513     0.150
     1.109    19.422     0.150
     1.521    26.683     0.150
     1.668    28.633     0.150
     1.942    31.243     0.150
     2.073    40.252     0.150
     2.297    37.363     0.150
     2.303    60.893     0.150
     3.705    60.212     0.150
     4.105   109.133     0.150
     8.294   118.542     0.150
    14.888   220.593     0.150
    21.785   290.453     0.150
    22.467   312.893     0.150
    27.504   350.711     0.150
    32.667   405.692     0.150
    36.442     9.500     0.150
    36.442    13.700     0.150
    43.872   487.583     0.150
    46.156   516.192     0.150
    50.732   544.113     0.150
    64.895   640.933     0.150
    83.704   747.240     0.150
    95.086   809.893     0.150
     0.696    25.393     0.150
     6.176    96.004     0.150
     9.405   142.553     0.150
    26.371     8.699     0.150
    26.371    12.898     0.150
    26.877   343.570     0.150
    27.338   338.562     0.150
    28.655   366.652     0.150
    28.655   397.053     0.150
    28.655   651.053     0.150
    37.435   430.152     0.150
    37.435    14.701     0.150
    37.435    23.301     0.150
    41.298  3056.402     0.150
    41.312  3057.990     0.150
    41.314  3058.451     0.150
    41.646  3082.980     0.150
    41.654  3090.848     0.150
    41.665  3081.875     0.150
    54.820   569.072     0.150
    54.820   569.428     0.150
    66.118   648.447     0.150
    66.759   648.562     0.150
    69.296   665.803     0.150
    85.162   756.533     0.150
    86.084   759.432     0.150
    86.480   761.754     0.150
     3.137    47.242     0.150
     4.912    72.164     0.150
   118.289  1129.000     0.150
     1.907    46.285     0.150
     2.317    70.594     0.150
     2.557    92.414     0.150
     2.808    51.516     0.150
     2.808    86.266     0.150
     2.808    49.727     0.150
     2.808    48.797     0.150
     9.106   134.855     0.150
     9.106   133.895     0.150
     9.527   138.594     0.150
    11.368   164.395     0.150
    13.257   191.297     0.150
    17.729   247.594     0.150
    36.909    22.203     0.150
    44.257   486.336     0.150
    52.098    25.801     0.150
    66.056   641.957     0.150
    82.473   740.121     0.150
    84.245   746.836     0.150
     0.861    30.172     0.150
     2.814    81.609     0.150
     2.842    48.680     0.150
     5.262    74.500     0.150
     4.091    67.789     0.150
     4.091   138.508     0.150
     0.408     9.859     0.150
     0.408    16.207     0.150
     2.438    53.749     0.150
     0.970    29.828     0.150
     1.175    26.441     0.150
     3.276    83.891     0.150
     0.076    -0.867     0.150
     0.831    26.053     0.150
     0.948    17.593     0.150
     1.001    14.603     0.150
     1.650    46.093     0.150
     2.132    60.783     0.150
     0.439    16.945     0.150
     0.339    11.633     0.150
     0.472    16.234     0.150
     1.059    33.250     0.150
     1.391    45.527     0.150
     1.457    26.566     0.150
     2.553    74.918     0.150
     2.907    82.691     0.150
     3.700   121.828     0.150
     3.804   106.918     0.150
    31.092   375.398     0.150
    36.805     5.598     0.150
    40.421   461.898     0.150
    40.793   461.598     0.150
    40.806   461.598     0.150
    78.884   720.309     0.150
     0.845    15.215     0.150
     1.436    42.773     0.150
     1.813    38.805     0.150
     2.186    33.613     0.150
     0.351    16.109     0.150
     0.390    11.988     0.150
     0.846    26.410     0.150
     0.860    28.141     0.150
     1.439    42.668     0.150
     1.577    55.148     0.150
     2.267    42.938     0.150
     1.449    44.133     0.150
     1.579    54.570     0.150
     1.572    51.016     0.150
     3.058    88.055     0.150
    19.975   275.938     0.150
    25.735   335.367     0.150
    27.644   344.711     0.150
    31.343   381.453     0.150
     0.331    12.242     0.150
     0.590    13.953     0.150
     0.753    14.523     0.150
     1.374    23.102     0.150
     1.505    44.684     0.150
     0.292    11.102     0.150
     0.273     9.961     0.150
     0.478    16.258     0.150
     0.736    13.414     0.150
     0.905    28.742     0.150
     1.249    23.320     0.150
     1.498    46.703     0.150
     1.514    48.203     0.150
     2.175    35.984     0.150
     0.645    21.947     0.150
     1.642    27.588     0.150
     1.650    48.537     0.150
     1.879    65.078     0.150
     2.327    68.898     0.150
     2.419    75.797     0.150
     2.621    54.979     0.150
     2.943    48.197     0.150
     3.063    77.297     0.150
     0.244     9.526     0.150
     0.367    10.156     0.150
     1.435    43.556     0.150
     1.590    45.666     0.150
     2.509    54.806     0.150
     0.352    14.895     0.150
     0.425    17.727     0.150
     0.889    28.305     0.150
     1.951    44.988     0.150
     6.023    86.523     0.150
     7.829   116.914     0.150
     7.829   118.625     0.150
     9.138   128.117     0.150
     9.209   129.422     0.150
     9.395   136.328     0.150
     9.507   139.312     0.150
    11.063   167.719     0.150
    11.739   159.016     0.150
    12.247   171.195     0.150
    13.400   185.328     0.150
    13.706   189.445     0.150
    14.037   198.227     0.150
    14.037   196.039     0.150
    15.251   209.477     0.150
    15.529   218.719     0.150
    16.303   230.016     0.150
    17.304    10.297     0.150
    19.361   267.922     0.150
    21.030   282.812     0.150
    22.954    16.203     0.150
    23.243   302.453     0.150
    24.014    18.297     0.150
    24.014   568.812     0.150
    24.488   317.617     0.150
    26.746   339.312     0.150
    26.746   335.414     0.150
    27.231    20.500     0.150
    27.725   343.219     0.150
    28.481   354.219     0.150
    29.282   356.625     0.150
    29.377    14.203     0.150
    29.377    19.703     0.150
    29.670   365.906     0.150
    30.068   656.312     0.150
    31.168   376.312     0.150
    31.168   374.312     0.150
    31.168    11.578     0.150
    32.507    16.500     0.150
    33.193    12.297     0.150
    33.193    17.500     0.150
    33.193   707.516     0.150
    33.489    15.000     0.150
    33.489    22.297     0.150
    33.953    17.797     0.150
    34.888   407.219     0.150
    34.888   556.617     0.150
    34.912    16.500     0.150
    36.292   418.016     0.150
    36.592   417.516     0.150
    37.111    16.500     0.150
    37.304   430.219     0.150
    39.658   449.719     0.150
    39.658   447.117     0.150
    40.912   458.578     0.150
    41.658  3069.898     0.150
    41.665  3069.945     0.150
    41.676  3072.453     0.150
    41.761   457.219     0.150
    43.043   474.312     0.150
    43.177   474.406     0.150
    43.192   494.719     0.150
    50.234   531.914     0.150
    50.573   534.484     0.150
    50.673   535.117     0.150
    50.826   536.219     0.150
    51.014   984.812     0.150
    51.014   537.633     0.150
    51.515   967.312     0.150
    51.877   544.719     0.150
    51.877   615.414     0.150
    51.877   544.797     0.150
    51.965   545.039     0.150
    52.093   546.617     0.150
    52.186   546.719     0.150
    52.328    20.000     0.150
    52.328   990.414     0.150
    52.328   546.125     0.150
    52.326   547.672     0.150
    52.641    16.000     0.150
    52.774   551.812     0.150
    52.975   552.516     0.150
    53.184   553.977     0.150
    53.318   555.414     0.150
    53.411   554.906     0.150
    53.392   555.508     0.150
    53.761   558.812     0.150
    53.761   623.719     0.150
    54.806   567.117     0.150
    55.405   570.312     0.150
    55.683   572.914     0.150
    56.011   574.445     0.150
    56.577   578.117     0.150
    56.577   579.258     0.150
    57.080   582.008     0.150
    57.717   586.516     0.150
    57.717   586.516     0.150
    57.717   637.914     0.150
    57.759   586.812     0.150
    58.114   589.336     0.150
    58.164   589.844     0.150
    58.834   594.266     0.150
    61.455   611.984     0.150
    63.117   622.117     0.150
    67.917   652.414     0.150
    73.736   688.633     0.150
    74.387   693.391     0.150
    77.430   710.297     0.150
    77.770   712.219     0.150
    78.437   714.672     0.150
    78.848   718.289     0.150
    79.797   720.016     0.150
    79.905   723.531     0.150
    79.865   719.812     0.150
    79.937   902.312     0.150
    79.937  1838.016     0.150
    80.428   726.219     0.150
    80.541   739.914     0.150
    81.225   730.414     0.150
    81.181   729.312     0.150
    81.183   746.617     0.150
    81.681   729.914     0.150
    81.724   733.117     0.150
    81.794   733.883     0.150
    83.695   742.516     0.150
    84.874   749.516     0.150
    85.268   751.016     0.150
    86.165   755.289     0.150
    86.176   755.312     0.150
    86.274   754.992     0.150
    86.274   754.992     0.150
    86.274    20.422     0.150
    86.274   966.906     0.150
    86.274  1075.367     0.150
    86.274  1349.938     0.150
    86.274  1420.922     0.150
    86.274  1741.094     0.150
    86.274  1884.922     0.150
    86.274   754.914     0.150
    86.274    14.602     0.150
    86.274    20.500     0.150
    86.274  1075.312     0.150
    86.274  1376.117     0.150
    87.213   760.812     0.150
    87.475   761.617     0.150
    87.898   763.812     0.150
    87.922   765.914     0.150
    87.947   764.117     0.150
    88.771   769.016     0.150
    88.827   768.219     0.150
    89.042   768.914     0.150
    89.385   771.016     0.150
    89.389   772.117     0.150
    89.556   771.117     0.150
    90.475   776.312     0.150
    90.678   778.312     0.150
    90.951   779.719     0.150
    91.464   782.016     0.150
    92.120   783.812     0.150
    92.258   783.914     0.150
    92.653   788.117     0.150
    92.671   785.016     0.150
    93.255   789.516     0.150
    93.641   790.734     0.150
    93.641   790.719     0.150
    93.805   792.414     0.150
    94.175   794.312     0.150
    94.184   793.914     0.150
    94.276   794.219     0.150
    94.314   794.812     0.150
    95.065   798.414     0.150
    95.382   799.414     0.150
    95.403   799.477     0.150
    95.781   800.312     0.150
    95.781  1046.516     0.150
    95.781  1264.516     0.150
    95.781  1552.516     0.150
    95.781  1864.516     0.150
    95.960   802.117     0.150
    96.288   803.312     0.150
    96.322   803.016     0.150
   124.925  1134.312     0.150
   151.106  1187.312     0.150
   170.963  1201.516     0.150
     1.042    31.473     0.150
     1.507    31.016     0.150
     1.718    47.402     0.150
     2.671    39.414     0.150
    64.440   634.004     0.150
    64.440   634.062     0.150
     0.208     6.893     0.150
     0.462    20.623     0.150
     0.405    13.762     0.150
     1.565    58.002     0.150
     1.623    45.262     0.150
     2.283    77.672     0.150
     2.334    61.623     0.150
     2.715    48.783     0.150
     2.715    90.273     0.150
     3.147    76.803     0.150
     3.192    50.422     0.150
     4.282    62.352     0.150
   102.002   100.453     0.150
   114.763   191.473     0.150
    16.437   226.072     0.150
    27.186   340.193     0.150
    31.323   381.037     0.150
    52.111   547.342     0.150
     0.789    29.668     0.150
     1.390    34.398     0.150
     2.222    72.938     0.150
     2.664    65.219     0.150
     3.032    68.496     0.150
     3.170    82.727     0.150
     4.877    68.406     0.150
   101.921   107.688     0.150
   101.921   107.195     0.150
     9.631   142.695     0.150
    10.939   161.996     0.150
    63.644   353.586     0.150
    28.974   361.496     0.150
    36.590     3.801     0.150
    44.785   492.969     0.150
    51.042   541.566     0.150
    51.042   617.066     0.150
    60.763   611.625     0.150
    63.860   630.246     0.150
    65.762   645.648     0.150
    80.176   728.938     0.150
    82.650   743.445     0.150
     0.815    12.742     0.150
     0.815    22.535     0.150
     0.937    16.695     0.150
     0.937    29.434     0.150
     1.359    44.145     0.150
     1.919    31.664     0.150
     1.919    62.945     0.150
     2.016    67.625     0.150
     2.291    31.953     0.150
     2.291    58.625     0.150
     2.549    39.375     0.150
     2.819    79.355     0.150
     3.262    51.973     0.150
     3.262    92.754     0.150
     3.352    53.363     0.150
     0.753    13.324     0.150
     0.753    23.395     0.150
     0.901    16.145     0.150
     1.134    19.453     0.150
     1.235    20.363     0.150
     1.583    49.785     0.150
     1.780    63.363     0.150
     1.981    67.363     0.150
     2.979    48.613     0.150
     3.335   103.543     0.150
     3.597   102.562     0.150
     3.987    57.273     0.150
     4.080    63.703     0.150
     4.587    75.953     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     2.953    45.797     0.150
     7.555   111.297     0.150
    15.766   221.797     0.150
    19.604   267.094     0.150
    20.128   275.695     0.150
    20.542   275.797     0.150
    23.051   306.797     0.150
    23.235   306.797     0.150
    23.235   577.797     0.150
    23.381   304.500     0.150
    23.305   308.695     0.150
    23.305   565.500     0.150
    24.728   319.797     0.150
    25.608   326.695     0.150
    25.919   330.297     0.150
    26.084   333.594     0.150
    26.532   334.594     0.150
    29.719   367.797     0.150
    30.272   368.797     0.150
    30.294   368.594     0.150
    31.121   376.797     0.150
    31.239   376.797     0.150
    31.239   687.797     0.150
    32.887   394.297     0.150
    34.120   402.797     0.150
    34.352   404.797     0.150
    34.450   403.797     0.150
    36.359   419.898     0.150
    36.740   424.094     0.150
    36.740   762.797     0.150
    38.763   444.000     0.150
    38.987   445.797     0.150
    40.203   451.797     0.150
    41.893   468.398     0.150
    41.893   817.797     0.150
    41.984   468.797     0.150
    43.046   479.797     0.150
    43.046   817.797     0.150
    44.060   487.797     0.150
    44.140   485.797     0.150
    44.536   487.797     0.150
    44.765   491.797     0.150
    45.470   496.297     0.150
    45.718   497.797     0.150
    45.794   500.797     0.150
    45.794   613.797     0.150
    45.988   499.797     0.150
    46.146   500.898     0.150
    46.146     6.898     0.150
    46.146   609.797     0.150
    46.146  1115.797     0.150
    46.444   503.797     0.150
    47.449   512.297     0.150
    48.091   517.797     0.150
    48.740   521.594     0.150
    49.102   527.094     0.150
    49.379   529.000     0.150
    49.302   527.797     0.150
    49.483   532.195     0.150
    49.662   528.797     0.150
    50.304   968.797     0.150
    50.529   538.000     0.150
    51.047   540.797     0.150
    51.559   542.797     0.150
    52.271   549.898     0.150
    52.521   549.797     0.150
    52.650   552.797     0.150
    52.743   552.797     0.150
    53.081   552.797     0.150
    53.081   999.797     0.150
    54.200   563.797     0.150
    53.873   560.297     0.150
    54.335   562.797     0.150
    54.664   566.797     0.150
    55.063   570.797     0.150
    55.874   576.000     0.150
    56.015   576.797     0.150
    56.116   575.797     0.150
    57.053   584.797     0.150
    57.450   586.797     0.150
    58.681   594.797     0.150
    62.076   616.297     0.150
    62.076     9.000     0.150
    63.783   630.500     0.150
    63.783   631.195     0.150
    64.299   633.797     0.150
    64.979   637.797     0.150
    66.731   649.797     0.150
    66.731  1184.797     0.150
    66.995   648.797     0.150
    67.434   653.898     0.150
    67.583   654.594     0.150
    67.583  1192.797     0.150
    69.211  1211.797     0.150
    69.246   663.797     0.150
    72.008   682.195     0.150
    74.456   695.797     0.150
    74.456  1272.797     0.150
    74.483   695.797     0.150
    75.629   701.797     0.150
    76.599   709.797     0.150
    76.757   707.797     0.150
    76.757     8.000     0.150
    76.894   709.398     0.150
    78.346   717.797     0.150
    80.108   725.797     0.150
    80.390   729.797     0.150
    80.646   731.797     0.150
    80.741   729.797     0.150
    80.741   735.797     0.150
    80.741    13.000     0.150
    81.439   733.797     0.150
    84.053   747.797     0.150
    84.172   748.000     0.150
    85.750   754.797     0.150
    86.300   758.797     0.150
    86.300    10.000     0.150
    86.300  1389.797     0.150
    86.870   760.898     0.150
    87.467   764.195     0.150
    87.567   763.797     0.150
    88.005   766.797     0.150
    88.208   769.797     0.150
    88.823   770.797     0.150
    88.823   983.797     0.150
    89.852   774.500     0.150
    90.506   779.797     0.150
    90.506    10.000     0.150
    91.143   779.297     0.150
    91.539   784.797     0.150
    91.605   782.297     0.150
    91.664   784.797     0.150
    91.664    14.000     0.150
    92.560   787.797     0.150
    94.945   798.797     0.150
    95.807   802.797     0.150
   100.673   826.297     0.150
   126.511  1140.594     0.150
   131.182  1151.594     0.150
   166.359  1204.797     0.150
     0.960    16.703     0.150
     0.917    16.902     0.150
     1.790    27.303     0.150
     1.790    50.303     0.150
     2.711    41.003     0.150
     3.232    50.303     0.150
     3.101    47.303     0.150
     3.101   101.803     0.150
     5.022    76.703     0.150
     5.728    90.303     0.150
     5.745    86.303     0.150
     5.745   168.103     0.150
     7.417   109.303     0.150
     9.537   135.103     0.150
    14.231   203.303     0.150
    15.775   222.303     0.150
    15.790   221.803     0.150
    15.790   399.303     0.150
    16.280   234.303     0.150
    16.869   239.303     0.150
    19.838   275.303     0.150
    19.838   494.303     0.150
    19.876   274.303     0.150
    20.225   274.803     0.150
    20.225   506.303     0.150
    21.027   282.803     0.150
    21.027   520.303     0.150
    22.403   296.303     0.150
    22.448   298.803     0.150
    23.327   306.303     0.150
    23.766   310.303     0.150
    23.588   310.803     0.150
    24.171   314.303     0.150
    24.329   316.103     0.150
    25.204   324.203     0.150
    25.701   329.603     0.150
    26.480   335.803     0.150
    26.839   338.503     0.150
    26.788   337.402     0.150
    27.834   347.703     0.150
    28.420   353.103     0.150
    28.828   353.303     0.150
    29.543   363.303     0.150
    29.552   364.303     0.150
    29.977   366.303     0.150
    30.662   372.303     0.150
    31.412   376.902     0.150
    31.416   377.503     0.150
    32.029   385.803     0.150
    32.559   389.303     0.150
    32.974   393.303     0.150
    33.432   397.303     0.150
    33.984   402.303     0.150
    34.856   407.303     0.150
    34.767   410.303     0.150
    36.762   426.303     0.150
    36.633   425.203     0.150
    36.633   768.303     0.150
    36.932   429.203     0.150
    36.932   769.902     0.150
    39.605   447.303     0.150
    39.605   810.303     0.150
    39.605   546.303     0.150
    40.065   453.303     0.150
    42.797   473.303     0.150
    43.546   480.303     0.150
    43.808   483.503     0.150
    43.808   872.303     0.150
    43.808   588.003     0.150
    44.841   491.303     0.150
    45.100   494.103     0.150
    45.100    20.200     0.150
    45.100   493.303     0.150
    45.100    21.000     0.150
    45.452   497.303     0.150
    45.671   499.003     0.150
    46.405   504.902     0.150
    46.405   909.303     0.150
    46.484   506.103     0.150
    47.845   516.003     0.150
    48.176   517.303     0.150
    48.196   517.603     0.150
    48.196   517.303     0.150
    48.251   518.902     0.150
    48.251   936.703     0.150
    48.251   518.303     0.150
    50.737    19.400     0.150
    50.575   537.303     0.150
    50.575   614.303     0.150
    51.433   543.703     0.150
    51.661   545.303     0.150
    51.661   545.803     0.150
    51.810   544.803     0.150
    51.810    21.000     0.150
    51.810   983.803     0.150
    51.810  1008.003     0.150
    51.810   661.603     0.150
    52.036   548.803     0.150
    52.232   550.703     0.150
    52.232   990.303     0.150
    52.764   553.003     0.150
    52.764   999.303     0.150
    52.756   553.003     0.150
    52.756   999.303     0.150
    52.756  1213.303     0.150
    52.897   553.303     0.150
    52.897   554.203     0.150
    52.904   552.503     0.150
    52.904   998.303     0.150
    53.318   555.803     0.150
    53.318    12.500     0.150
    53.318   555.303     0.150
    53.318    13.000     0.150
    54.265   563.303     0.150
    54.265  1022.503     0.150
    54.367   565.803     0.150
    54.367    19.500     0.150
    54.367   691.902     0.150
    54.367  1035.803     0.150
    54.933   569.902     0.150
    54.933  1032.402     0.150
    55.255   571.303     0.150
    55.255  1037.902     0.150
    55.255   571.902     0.150
    55.275   569.703     0.150
    55.275  1029.902     0.150
    56.183   577.603     0.150
    56.183  1048.303     0.150
    56.183   704.303     0.150
    56.218   579.503     0.150
    56.384   577.803     0.150
    56.384    16.000     0.150
    56.384   633.803     0.150
    56.384  1043.803     0.150
    57.311   586.303     0.150
    57.646   588.303     0.150
    57.646   716.303     0.150
    58.923   597.303     0.150
    58.923    19.200     0.150
    61.387   612.303     0.150
    61.387  1110.303     0.150
    63.647   625.303     0.150
    63.647    21.000     0.150
    65.282   641.303     0.150
    65.282   641.803     0.150
    65.472   641.303     0.150
    65.472   641.803     0.150
    67.016   651.803     0.150
    67.493   652.303     0.150
    67.493  1188.303     0.150
    67.493   653.103     0.150
    67.493   678.803     0.150
    67.638   654.703     0.150
    68.286   658.703     0.150
    68.286  1198.803     0.150
    68.286   685.803     0.150
    68.494   658.303     0.150
    68.494  1200.303     0.150
    68.494   684.503     0.150
    69.717   668.303     0.150
    74.768   699.303     0.150
    75.149   699.303     0.150
    75.149   699.703     0.150
    75.149  1279.703     0.150
    75.982   704.203     0.150
    76.019   704.803     0.150
    76.159   709.803     0.150
    76.159  1307.303     0.150
    76.237   707.303     0.150
    76.237   707.803     0.150
    76.237   717.303     0.150
    76.612   710.303     0.150
    76.839   710.003     0.150
    77.089   710.303     0.150
    77.089   891.303     0.150
    77.089  1300.303     0.150
    77.226   711.303     0.150
    77.474   713.103     0.150
    79.157   720.603     0.150
    79.664   723.303     0.150
    79.664   723.503     0.150
    80.715   728.303     0.150
    80.715   729.003     0.150
    81.063   731.803     0.150
    81.170   730.303     0.150
    81.170   730.902     0.150
    81.170  1345.303     0.150
    83.179   744.303     0.150
    83.179  1362.303     0.150
    83.179  1410.303     0.150
    83.388   744.303     0.150
    83.522   746.303     0.150
    83.781   746.303     0.150
    83.781    21.600     0.150
    83.961   747.003     0.150
    83.961  1368.303     0.150
    84.146   749.203     0.150
    84.809   751.303     0.150
    84.949   751.603     0.150
    84.949   752.603     0.150
    86.031   756.902     0.150
    86.153   757.303     0.150
    86.153  1392.303     0.150
    86.691   759.303     0.150
    88.342   770.303     0.150
    88.962   772.303     0.150
    88.962   774.303     0.150
    89.159   771.303     0.150
    89.159   986.303     0.150
    89.636   775.303     0.150
    89.698   774.503     0.150
    90.575   781.303     0.150
    90.575    15.000     0.150
    91.433   782.303     0.150
    91.586   785.303     0.150
    91.629   784.303     0.150
    91.729   783.303     0.150
    91.756   785.303     0.150
    92.171   784.902     0.150
    93.567   793.303     0.150
    94.922   799.303     0.150
    94.922   799.803     0.150
    94.939   799.203     0.150
    95.830   803.902     0.150
   113.854  1118.303     0.150
   127.184  1142.503     0.150
   147.606  1179.803     0.150
   148.970  1188.303     0.150
   156.273  1221.303     0.150
   165.919  1204.303     0.150
     2.934    44.930     0.150
     7.657   112.930     0.150
     8.075   116.930     0.150
     8.075   203.930     0.150
    16.265   225.930     0.150
    16.265   413.930     0.150
    16.501   231.031     0.150
    16.501   421.930     0.150
    19.970   271.031     0.150
    20.654   274.930     0.150
    21.200   284.828     0.150
    21.236   284.230     0.150
    21.782   289.129     0.150
    22.786   298.930     0.150
    22.830   301.430     0.150
    22.982   304.031     0.150
    23.241   302.930     0.150
    23.049   302.930     0.150
    23.814   311.031     0.150
    25.240   323.930     0.150
    25.422   322.930     0.150
    25.361   324.930     0.150
    28.081   347.730     0.150
    28.081   633.930     0.150
    28.372   350.230     0.150
    30.025   366.328     0.150
    30.530   367.930     0.150
    30.874   370.930     0.150
    30.925   371.730     0.150
    32.168   385.430     0.150
    32.370   386.031     0.150
    33.178   394.930     0.150
    34.284   401.730     0.150
    34.377   402.930     0.150
    35.415   411.930     0.150
    36.072   417.031     0.150
    36.724   423.930     0.150
    36.764   424.531     0.150
    39.028   441.930     0.150
    40.053   450.531     0.150
    40.172   451.930     0.150
    40.073   453.531     0.150
    40.263   452.930     0.150
    40.352   455.430     0.150
    40.532   456.930     0.150
    40.618   457.730     0.150
    40.866   459.930     0.150
    40.866   460.430     0.150
    41.078   459.629     0.150
    41.139   461.629     0.150
    41.686   464.730     0.150
    42.463   471.230     0.150
    43.365   478.930     0.150
    44.418   486.930     0.150
    44.277   485.930     0.150
    44.277   486.129     0.150
    44.533   489.930     0.150
    46.295   502.230     0.150
    46.120   500.930     0.150
    46.120   501.430     0.150
    46.430   504.430     0.150
    46.430   907.930     0.150
    47.597   511.930     0.150
    48.950   521.930     0.150
    48.950   522.730     0.150
    49.436   527.930     0.150
    49.531   525.930     0.150
    50.445   533.930     0.150
    52.278   549.031     0.150
    52.359   548.430     0.150
    53.162   553.930     0.150
    54.526   562.930     0.150
    54.526    15.000     0.150
    54.526   563.828     0.150
    54.526    14.102     0.150
    54.586   564.930     0.150
    54.586   565.430     0.150
    55.947   577.629     0.150
    56.038   578.930     0.150
    56.038   579.430     0.150
    56.978  1068.930     0.150
    62.335   618.930     0.150
    62.335     9.000     0.150
    63.773   629.930     0.150
    64.259   632.930     0.150
    64.259   772.930     0.150
    64.886   640.930     0.150
    64.886   641.430     0.150
    65.076   637.930     0.150
    65.076     8.500     0.150
    66.951   647.930     0.150
    67.456   649.930     0.150
    67.631   651.930     0.150
    67.631   652.430     0.150
    69.551   664.930     0.150
    74.370   694.930     0.150
    74.405   694.930     0.150
    80.534   728.328     0.150
    80.534   735.129     0.150
    80.765   726.930     0.150
    84.165   747.031     0.150
    85.216   753.930     0.150
    85.216   754.129     0.150
    86.095   756.930     0.150
    87.180   761.930     0.150
    88.175   769.930     0.150
    88.175   770.430     0.150
    89.922   773.930     0.150
    91.725   781.930     0.150
   166.435  1202.930     0.150
   166.484  1200.930     0.150
   166.484  1211.930     0.150
     0.788    14.678     0.150
     2.887    43.678     0.150
     5.115    78.678     0.150
     5.768    84.678     0.150
     5.920    90.678     0.150
     7.639   113.678     0.150
     8.300   124.678     0.150
     8.617   124.678     0.150
     8.684   129.678     0.150
     9.089   132.377     0.150
    13.294   189.877     0.150
    14.746   216.178     0.150
    15.576   214.678     0.150
    15.576   400.678     0.150
    15.942   226.678     0.150
    16.102   226.479     0.150
    16.186   231.078     0.150
    16.957   238.178     0.150
    17.034   239.678     0.150
    18.889   259.877     0.150
    19.845   280.678     0.150
    20.188   273.678     0.150
    20.216   277.178     0.150
    20.216   277.178     0.150
    20.252   277.678     0.150
    20.252   290.979     0.150
    20.252   500.678     0.150
    20.459   280.178     0.150
    21.071   283.678     0.150
    21.423   284.678     0.150
    21.423   530.678     0.150
    22.114   296.678     0.150
    22.505   298.178     0.150
    22.735   301.178     0.150
    22.769   301.479     0.150
    23.418   304.678     0.150
    23.418   307.078     0.150
    23.445   307.678     0.150
    23.705   311.678     0.150
    23.731   311.678     0.150
    23.843   311.479     0.150
    23.843   576.877     0.150
    23.956   313.479     0.150
    23.956   341.777     0.150
    24.529   317.178     0.150
    24.539   319.678     0.150
    24.939   321.877     0.150
    25.590   327.479     0.150
    25.722   328.678     0.150
    25.708   329.178     0.150
    25.750   330.678     0.150
    25.750   330.988     0.150
    25.926   330.678     0.150
    26.318   332.678     0.150
    26.379   335.178     0.150
    26.379   334.377     0.150
    26.449   335.178     0.150
    26.539   334.678     0.150
    26.892   339.678     0.150
    27.150   340.979     0.150
    27.150   616.678     0.150
    27.684   348.678     0.150
    28.082   349.678     0.150
    28.082   632.678     0.150
    28.572   355.178     0.150
    28.572   405.678     0.150
    28.572   642.678     0.150
    29.102   358.678     0.150
    29.349   359.688     0.150
    29.349   359.822     0.150
    29.479   363.777     0.150
    29.870   366.678     0.150
    30.795   376.678     0.150
    31.025   374.178     0.150
    31.078   374.479     0.150
    31.030   375.178     0.150
    31.030   682.678     0.150
    31.030   375.732     0.150
    31.912   382.678     0.150
    31.912   453.678     0.150
    31.912   692.678     0.150
    32.244   387.639     0.150
    32.244   389.297     0.150
    32.244   454.688     0.150
    32.244   698.678     0.150
    32.944   396.678     0.150
    33.002   393.479     0.150
    33.002     5.199     0.150
    33.002   713.678     0.150
    33.286   395.678     0.150
    33.880   400.078     0.150
    33.880   477.678     0.150
    33.880   724.678     0.150
    33.905   404.678     0.150
    34.378   406.678     0.150
    34.744   408.678     0.150
    34.957   409.678     0.150
    34.957     5.000     0.150
    34.938   413.678     0.150
    35.823   416.678     0.150
    36.216   422.678     0.150
    36.216   757.678     0.150
    36.568   422.678     0.150
    36.568   764.678     0.150
    36.568   507.088     0.150
    36.568   423.830     0.150
    36.670   423.178     0.150
    36.846   427.078     0.150
    36.965   428.777     0.150
    36.965    10.900     0.150
    36.965   776.678     0.150
    39.547   448.018     0.150
    39.547   449.838     0.150
    39.547   545.797     0.150
    39.547   820.398     0.150
    39.547  1000.498     0.150
    39.547   448.479     0.150
    40.120   454.678     0.150
    40.120    12.000     0.150
    40.120   810.678     0.150
    40.585   455.678     0.150
    40.586   458.877     0.150
    40.894   459.678     0.150
    40.894   463.678     0.150
    40.880   456.678     0.150
    40.764   460.178     0.150
    40.764   564.678     0.150
    40.875   460.479     0.150
    41.052   461.877     0.150
    41.143   462.678     0.150
    41.672   464.678     0.150
    41.658   466.479     0.150
    42.307   469.678     0.150
    43.043   476.678     0.150
    43.043   480.678     0.150
    43.043   581.678     0.150
    43.062   477.707     0.150
    43.062   571.678     0.150
    43.062   475.566     0.150
    43.050   478.678     0.150
    43.050   862.678     0.150
    44.127   484.678     0.150
    44.127   485.178     0.150
    44.706   491.678     0.150
    45.282   496.678     0.150
    45.282    12.500     0.150
    45.282   594.678     0.150
    45.282   826.678     0.150
    45.282   898.678     0.150
    45.282  1096.678     0.150
    45.435   496.678     0.150
    45.435   598.678     0.150
    45.435  1095.678     0.150
    45.822   498.678     0.150
    45.822   502.678     0.150
    45.974   498.678     0.150
    45.974   501.678     0.150
    45.974   607.678     0.150
    45.974   835.678     0.150
    45.984     6.000     0.150
    45.984   500.479     0.150
    45.984     5.199     0.150
    46.268   503.078     0.150
    46.488   504.178     0.150
    46.585   506.568     0.150
    46.585   508.229     0.150
    46.585   614.047     0.150
    46.585   614.607     0.150
    46.585   917.777     0.150
    46.585   505.990     0.150
    46.998   510.578     0.150
    47.958   521.678     0.150
    48.597   519.678     0.150
    48.597   520.178     0.150
    48.825   527.678     0.150
    49.453   528.678     0.150
    49.446   528.678     0.150
    49.758   530.678     0.150
    49.812   532.277     0.150
    49.812   962.678     0.150
    49.812   531.377     0.150
    50.205   650.678     0.150
    50.205   970.678     0.150
    50.464   535.578     0.150
    50.617   536.678     0.150
    50.617   540.678     0.150
    50.811   538.678     0.150
    50.811   971.678     0.150
    51.131   542.678     0.150
    51.101   540.678     0.150
    51.851   547.678     0.150
    51.787  1132.678     0.150
    52.268   546.678     0.150
    52.268   546.979     0.150
    52.268   621.678     0.150
    52.319   552.678     0.150
    52.319   672.678     0.150
    52.319   996.678     0.150
    52.410   549.678     0.150
    52.894   555.678     0.150
    52.894  1004.678     0.150
    52.886   555.678     0.150
    52.886  1004.678     0.150
    53.004   555.479     0.150
    53.004   674.678     0.150
    53.087   557.178     0.150
    53.087   684.678     0.150
    53.160   554.678     0.150
    53.160  1002.678     0.150
    53.824   559.678     0.150
    53.824     7.699     0.150
    53.824  1015.678     0.150
    53.824   560.377     0.150
    53.824     7.000     0.150
    53.824    14.301     0.150
    53.824   680.678     0.150
    53.824  1143.678     0.150
    54.475   564.678     0.150
    54.475  1025.678     0.150
    54.475  1028.678     0.150
    54.475   686.678     0.150
    54.484   566.678     0.150
    54.484  1027.678     0.150
    54.985   569.578     0.150
    54.985  1033.678     0.150
    54.985   628.678     0.150
    54.985   689.678     0.150
    54.985  1160.678     0.150
    54.985  1256.678     0.150
    55.344   573.678     0.150
    55.344  1039.678     0.150
    56.322   578.678     0.150
    56.322  1056.078     0.150
    56.322   578.174     0.150
    56.437   580.777     0.150
    56.437   640.678     0.150
    56.437  1063.178     0.150
    57.369   587.678     0.150
    57.369  1087.678     0.150
    57.734   587.678     0.150
    57.734   588.479     0.150
    57.734   642.678     0.150
    57.734   721.678     0.150
    58.440   592.678     0.150
    58.988   597.678     0.150
    58.988   734.678     0.150
    61.185   611.678     0.150
    61.185  1198.678     0.150
    61.838   616.178     0.150
    61.838    11.500     0.150
    61.838  1120.178     0.150
    61.838  1144.678     0.150
    61.838  1203.678     0.150
    63.270   626.479     0.150
    64.010  1141.678     0.150
    64.230   632.979     0.150
    65.318   641.678     0.150
    65.318  1161.678     0.150
    65.318   669.678     0.150
    65.318   787.678     0.150
    65.507   641.979     0.150
    65.507  1169.678     0.150
    65.507   792.678     0.150
    66.864   650.678     0.150
    67.273   654.178     0.150
    67.061   653.178     0.150
    67.061  1191.678     0.150
    67.061  1248.678     0.150
    67.799   657.578     0.150
    67.837   657.479     0.150
    67.712   654.178     0.150
    67.712  1190.678     0.150
    67.712   806.678     0.150
    68.037   657.178     0.150
    68.193   658.678     0.150
    68.282   657.777     0.150
    68.552   659.078     0.150
    68.555   659.277     0.150
    68.626   659.678     0.150
    68.626  1198.678     0.150
    68.626  1254.678     0.150
    68.626  1460.678     0.150
    68.707   659.777     0.150
    68.754   659.877     0.150
    68.828   662.479     0.150
    68.802   660.678     0.150
    68.802  1202.678     0.150
    68.802   686.678     0.150
    68.802  1258.678     0.150
    68.707   659.678     0.150
    68.707  1200.678     0.150
    68.707   659.992     0.150
    68.707   660.178     0.150
    68.707   810.678     0.150
    68.707  1250.678     0.150
    69.005   662.377     0.150
    69.108   663.678     0.150
    69.180   661.877     0.150
    70.296   674.678     0.150
    70.720   678.678     0.150
    71.105   676.678     0.150
    71.283   678.178     0.150
    71.354   678.678     0.150
    71.367   678.178     0.150
    71.422   678.578     0.150
    71.499   680.578     0.150
    71.550   681.377     0.150
    71.832   681.678     0.150
    72.122   682.678     0.150
    72.122  1250.678     0.150
    73.029   689.678     0.150
    73.029  1260.678     0.150
    73.029   707.678     0.150
    73.029  1293.678     0.150
    73.424   691.877     0.150
    73.940   694.678     0.150
    73.940    11.400     0.150
    73.940  1296.678     0.150
    73.940  1312.678     0.150
    74.205   698.178     0.150
    74.785   697.678     0.150
    74.785  1276.678     0.150
    74.785    13.000     0.150
    74.785  1315.678     0.150
    74.785  1568.678     0.150
    74.801   697.678     0.150
    74.801  1269.678     0.150
    74.801  1309.678     0.150
    74.801   700.678     0.150
    75.102   700.979     0.150
    75.231   701.678     0.150
    75.231  1282.678     0.150
    75.231    10.000     0.150
    75.231   876.678     0.150
    75.539   702.678     0.150
    75.539   884.178     0.150
    75.539  1280.678     0.150
    75.539  1330.678     0.150
    75.942   706.678     0.150
    75.942  1292.678     0.150
    75.973   706.678     0.150
    75.973   718.277     0.150
    75.973  1292.678     0.150
    75.973  1304.678     0.150
    76.510   707.678     0.150
    76.510   707.877     0.150
    76.548   708.678     0.150
    76.530   710.678     0.150
    76.530  1296.678     0.150
    76.530  1326.678     0.150
    76.630   708.678     0.150
    76.630    10.000     0.150
    76.906   712.678     0.150
    76.906  1298.678     0.150
    76.906  1339.678     0.150
    77.093   712.479     0.150
    77.093   881.678     0.150
    77.143   711.578     0.150
    77.178  1306.678     0.150
    77.178   725.678     0.150
    77.388   711.678     0.150
    77.388     8.500     0.150
    77.388  1300.678     0.150
    77.388  1343.178     0.150
    77.426   713.979     0.150
    77.750   713.678     0.150
    77.750   713.979     0.150
    77.766   715.979     0.150
    78.005   715.678     0.150
    79.567   724.678     0.150
    79.567  1317.678     0.150
    79.567  1366.678     0.150
    79.686   723.877     0.150
    79.686   723.078     0.150
    79.615  1368.678     0.150
    79.615  1380.678     0.150
    79.744   727.178     0.150
    80.190   727.828     0.150
    80.190     8.270     0.150
    80.190  1330.777     0.150
    80.190  1353.197     0.150
    80.190   727.277     0.150
    80.072   729.678     0.150
    80.376   734.678     0.150
    80.376  1346.678     0.150
    80.376  1649.678     0.150
    80.267   727.678     0.150
    80.267     9.000     0.150
    80.267  1330.678     0.150
    80.267   910.678     0.150
    80.267  1384.678     0.150
    80.907   731.877     0.150
    80.907  1336.678     0.150
    80.907   731.459     0.150
    80.907     7.801     0.150
    80.907  1650.678     0.150
    80.920   731.578     0.150
    81.063   733.078     0.150
    81.161   733.678     0.150
    81.161   915.678     0.150
    81.161  1386.678     0.150
    81.156   734.678     0.150
    81.466   735.678     0.150
    81.466  1340.678     0.150
    82.115   743.729     0.150
    82.546   739.678     0.150
    83.494   744.877     0.150
    83.494  1366.678     0.150
    83.490   745.678     0.150
    83.490  1362.678     0.150
    83.526   743.578     0.150
    83.756   745.678     0.150
    83.756     9.000     0.150
    83.756  1366.678     0.150
    83.756   944.678     0.150
    83.756  1413.678     0.150
    83.756  1696.678     0.150
    83.747   749.678     0.150
    83.987   749.377     0.150
    84.079   746.479     0.150
    84.215   750.178     0.150
    84.271   751.678     0.150
    84.412   753.479     0.150
    84.695   750.678     0.150
    84.918   753.678     0.150
    85.056   754.678     0.150
    85.164   754.957     0.150
    85.164     8.111     0.150
    85.164   964.848     0.150
    85.164   752.934     0.150
    85.211   752.578     0.150
    85.194   754.678     0.150
    85.328   753.678     0.150
    85.481   755.178     0.150
    85.997   759.678     0.150
    85.997  1390.678     0.150
    85.997   962.678     0.150
    85.997  1448.678     0.150
    86.275   757.777     0.150
    86.293   761.678     0.150
    86.398   759.979     0.150
    86.398     7.500     0.150
    86.398   966.678     0.150
    86.398  1390.678     0.150
    86.398  1458.678     0.150
    86.817   765.178     0.150
    86.817  1400.678     0.150
    86.976   762.678     0.150
    87.260   765.979     0.150
    87.361   765.678     0.150
    87.523   763.479     0.150
    87.533   765.678     0.150
    87.544   766.178     0.150
    87.594   766.678     0.150
    87.620   767.678     0.150
    87.629   765.178     0.150
    87.634   766.678     0.150
    87.765   768.178     0.150
    87.765   769.678     0.150
    87.923   768.678     0.150
    87.939   767.678     0.150
    87.933   766.678     0.150
    87.973   768.678     0.150
    87.973  1406.678     0.150
    88.025   772.678     0.150
    88.064  1409.979     0.150
    88.321   774.678     0.150
    88.380   771.678     0.150
    88.461   770.678     0.150
    88.461   771.178     0.150
    88.749   774.178     0.150
    88.749   774.678     0.150
    88.801   771.178     0.150
    89.079   773.178     0.150
    89.144   771.678     0.150
    89.214   774.678     0.150
    89.277   774.678     0.150
    89.277  1414.678     0.150
    89.297   774.678     0.150
    89.316  1412.678     0.150
    89.316   986.678     0.150
    89.316  1397.678     0.150
    89.316  1496.678     0.150
    89.681   775.877     0.150
    89.745   779.678     0.150
    89.752   779.678     0.150
    89.946   775.979     0.150
    89.990   781.678     0.150
    90.024   781.678     0.150
    90.135   780.877     0.150
    90.150   778.678     0.150
    90.197   781.178     0.150
    90.197   781.678     0.150
    90.326   781.678     0.150
    90.328   782.178     0.150
    90.604   780.678     0.150
    90.604  1410.678     0.150
    90.432   782.678     0.150
    90.724   780.678     0.150
    90.724     8.500     0.150
    90.724  1504.678     0.150
    90.738   782.678     0.150
    90.828   781.678     0.150
    91.016   782.678     0.150
    91.052   783.678     0.150
    91.570   783.678     0.150
    91.689   782.678     0.150
    91.691   786.678     0.150
    91.745   786.678     0.150
    91.745  1017.678     0.150
    91.794   785.578     0.150
    91.794   788.578     0.150
    91.794  1013.678     0.150
    91.794  1427.678     0.150
    91.794    14.000     0.150
    91.863   785.979     0.150
    91.863  1009.777     0.150
    91.914   784.678     0.150
    91.991   788.678     0.150
    91.991   789.678     0.150
    92.082   788.678     0.150
    92.113   789.678     0.150
    92.224   789.678     0.150
    92.370   790.678     0.150
    92.438   786.678     0.150
    92.438  1828.877     0.150
    92.463   791.277     0.150
    92.477   790.678     0.150
    92.477  1022.678     0.150
    92.477  1426.678     0.150
    92.480   787.678     0.150
    92.859   788.178     0.150
    92.996   793.678     0.150
    93.121   790.678     0.150
    93.121   794.277     0.150
    93.121  1012.678     0.150
    93.121  1426.678     0.150
    93.121  1434.678     0.150
    93.121  1542.678     0.150
    93.121  1846.678     0.150
    93.155   792.678     0.150
    93.155     7.000     0.150
    93.335   794.178     0.150
    93.444   795.377     0.150
    93.494   792.178     0.150
    93.508   796.377     0.150
    93.508  1026.479     0.150
    93.745   793.678     0.150
    93.823   792.078     0.150
    93.823  1823.479     0.150
    93.918   793.777     0.150
    94.075   796.678     0.150
    94.055   796.678     0.150
    94.152   800.178     0.150
    94.239   797.178     0.150
    94.429   797.678     0.150
    94.456   795.979     0.150
    94.484   798.777     0.150
    94.543   798.678     0.150
    94.543  1426.678     0.150
    94.557   798.178     0.150
    94.621   802.678     0.150
    94.621  1030.678     0.150
    94.621  1554.678     0.150
    94.669   798.877     0.150
    94.758   800.877     0.150
    94.803   801.678     0.150
    94.955   802.178     0.150
    95.097   800.678     0.150
    95.097   803.979     0.150
    95.122   801.078     0.150
    95.122   804.277     0.150
    95.122  1442.678     0.150
    95.122  1474.678     0.150
    95.132   804.678     0.150
    95.132  1030.678     0.150
    95.132  1562.678     0.150
    95.503   804.678     0.150
    95.503  1479.678     0.150
    95.674   807.678     0.150
    96.000   805.777     0.150
    96.000   808.678     0.150
    96.000  1046.678     0.150
    96.003   807.877     0.150
    96.056   806.178     0.150
    96.063   809.078     0.150
    96.070   808.979     0.150
    96.267   809.777     0.150
    96.420   807.377     0.150
    96.487   810.178     0.150
    96.550   810.178     0.150
    96.550  1044.178     0.150
    96.550  1448.678     0.150
    96.572  1891.678     0.150
    96.722   810.877     0.150
    96.726   805.178     0.150
    96.840   811.377     0.150
    96.924   811.979     0.150
    96.924   817.479     0.150
    96.924  1435.178     0.150
    96.924  1472.178     0.150
    96.965   811.479     0.150
    97.169   813.178     0.150
    97.169  1053.678     0.150
    97.296   814.178     0.150
    97.466   814.277     0.150
    97.492   810.678     0.150
    97.510   812.979     0.150
    97.724   816.367     0.150
    97.805   814.678     0.150
    97.919   815.678     0.150
    97.952   816.178     0.150
    98.170   818.678     0.150
    98.241   818.178     0.150
    98.241  1052.578     0.150
    98.402   818.479     0.150
    98.541   820.078     0.150
    98.541  1065.178     0.150
    98.584   819.877     0.150
    98.584  1057.877     0.150
    98.605   819.178     0.150
    98.605  1060.678     0.150
    98.792   819.678     0.150
    98.653   820.578     0.150
    98.651   821.877     0.150
    98.687   819.678     0.150
    98.707   821.277     0.150
    98.764   819.178     0.150
    98.764  1066.678     0.150
    98.870   819.678     0.150
    98.901   821.979     0.150
    98.901  1064.678     0.150
    99.118  1067.678     0.150
    99.137   821.979     0.150
    99.160   823.178     0.150
    99.213   822.877     0.150
    99.213  1068.078     0.150
    99.256   821.697     0.150
    99.299   824.178     0.150
    99.348   823.178     0.150
    99.520   822.678     0.150
    99.520  1069.678     0.150
    99.563   822.678     0.150
    99.563  1069.678     0.150
    99.732   823.178     0.150
    99.620   823.678     0.150
    99.625   823.277     0.150
    99.761   824.678     0.150
    99.762   826.377     0.150
    99.790   825.078     0.150
    99.824   825.877     0.150
    99.822   823.678     0.150
    99.822  1064.178     0.150
    99.883   827.178     0.150
    99.889   824.258     0.150
   100.040   824.877     0.150
   100.087   824.998     0.150
   100.342   826.178     0.150
   100.246   826.479     0.150
   100.306   827.277     0.150
   100.501   825.178     0.150
   100.342  1072.678     0.150
   100.378   826.928     0.150
   100.428   826.178     0.150
   100.611   827.678     0.150
   100.611  1471.678     0.150
   100.641   827.658     0.150
   100.665   821.678     0.150
   100.666   822.678     0.150
   100.666  1072.678     0.150
   100.798   831.377     0.150
   100.825   829.377     0.150
   100.830   828.377     0.150
   100.830  1473.678     0.150
   100.906   830.178     0.150
   101.245   832.678     0.150
   101.732  1618.678     0.150
   101.570   833.377     0.150
   101.737   834.578     0.150
   101.740   834.377     0.150
   101.872   826.678     0.150
   101.986  1084.678     0.150
   102.656   837.678     0.150
   102.682   837.678     0.150
   103.034   839.377     0.150
   103.034  1797.979     0.150
   102.873   838.479     0.150
   102.916   839.377     0.150
   103.075   837.678     0.150
   102.975   839.178     0.150
   103.195   837.678     0.150
   103.195  1091.678     0.150
   103.194   840.277     0.150
   103.576   839.678     0.150
   103.613   842.078     0.150
   103.947   843.377     0.150
   103.947  1792.178     0.150
   103.950   843.777     0.150
   104.246   840.678     0.150
   104.796   845.678     0.150
   104.990   848.877     0.150
   106.244  1496.678     0.150
   106.244  1566.678     0.150
   106.244  1670.678     0.150
   106.244  1778.678     0.150
   106.244  2006.678     0.150
   106.244  2642.678     0.150
   106.283  1777.678     0.150
   106.784   856.678     0.150
   106.784  1117.678     0.150
   106.784  1801.678     0.150
   108.006   860.678     0.150
   108.006  1124.678     0.150
   111.070  1112.277     0.150
   112.436  1115.678     0.150
   112.634  1114.678     0.150
   112.818  1111.678     0.150
   112.913  1113.178     0.150
   113.012  1114.678     0.150
   113.426  1166.678     0.150
   113.840  1173.678     0.150
   114.375  1115.178     0.150
   115.666  1122.678     0.150
   118.590  1129.178     0.150
   118.590  1211.078     0.150
   120.717  1131.479     0.150
   120.717  1225.578     0.150
   121.805   924.547     0.150
   121.805  1550.008     0.150
   121.805  1813.197     0.150
   122.293  1131.277     0.150
   122.663  1136.678     0.150
   122.663  1231.678     0.150
   122.702  1135.678     0.150
   122.814  1132.678     0.150
   122.814  1229.678     0.150
   122.871  1137.678     0.150
   122.871  1230.678     0.150
   122.907  1132.678     0.150
   123.224  1134.277     0.150
   123.206  1136.277     0.150
   125.891  1570.729     0.150
   126.622  1139.479     0.150
   126.665  1143.479     0.150
   126.816  1142.338     0.150
   127.025  1140.797     0.150
   127.683  1142.678     0.150
   128.025  1145.678     0.150
   134.915  1162.377     0.150
   149.594  1190.678     0.150
   149.894  1185.678     0.150
   152.204  1186.678     0.150
   152.302  1188.678     0.150
   152.477  1189.168     0.150
   152.576  1189.217     0.150
   152.824  1189.178     0.150
   152.875  1188.678     0.150
   153.460  1187.678     0.150
   153.598  1190.678     0.150
   154.903  1426.678     0.150
   155.560  1191.678     0.150
   155.844  1193.377     0.150
   156.537  1194.678     0.150
   157.284  1195.678     0.150
   157.295  1193.678     0.150
   158.850  1196.918     0.150
   160.093  1198.178     0.150
   163.011  1202.178     0.150
   163.784  1198.377     0.150
   163.784  1207.578     0.150
   163.784  1259.078     0.150
   164.340  1202.678     0.150
   165.961  1204.678     0.150
   166.055  1204.178     0.150
   166.055  1267.197     0.150
   166.055  1491.707     0.150
   166.055  1492.188     0.150
   170.722  1204.178     0.150
     7.753   115.072     0.150
     8.533   124.973     0.150
    16.047   231.072     0.150
    16.226   230.072     0.150
    17.031   240.473     0.150
    17.139   240.672     0.150
    20.961   283.172     0.150
    21.554   289.072     0.150
    22.898   302.473     0.150
    23.291   305.072     0.150
    23.801   314.672     0.150
    23.929   314.672     0.150
    25.969   331.271     0.150
    29.396   360.072     0.150
    29.472   360.072     0.150
    30.899   375.072     0.150
    31.159   377.072     0.150
    32.355   390.072     0.150
    33.410   398.473     0.150
    34.013   401.572     0.150
    34.812   410.572     0.150
    36.461   423.072     0.150
    39.534   448.072     0.150
    40.246   454.873     0.150
    40.943   462.072     0.150
    41.120   463.973     0.150
    41.210   463.771     0.150
    41.726   467.771     0.150
    44.252   488.072     0.150
    45.315   497.072     0.150
    45.867   498.072     0.150
    45.867     7.000     0.150
    45.867   598.072     0.150
    46.109   503.072     0.150
    46.109   503.873     0.150
    46.288   505.172     0.150
    46.691   509.072     0.150
    48.206   519.072     0.150
    48.728   523.072     0.150
    48.728   523.271     0.150
    49.334   530.473     0.150
    50.345   537.072     0.150
    50.499   537.072     0.150
    51.222   542.072     0.150
    51.770   546.072     0.150
    52.401   550.072     0.150
    53.952   561.072     0.150
    53.952     5.199     0.150
    53.952   561.271     0.150
    53.952     5.000     0.150
    54.086   564.771     0.150
    56.408   580.072     0.150
    56.408   580.873     0.150
    57.453   588.072     0.150
    59.073   599.072     0.150
    59.073   599.873     0.150
    61.294   613.873     0.150
    61.971   617.072     0.150
    61.971   756.072     0.150
    64.139   630.473     0.150
    64.139   665.072     0.150
    64.307   635.373     0.150
    65.397   642.072     0.150
    65.586   644.072     0.150
    66.752   650.072     0.150
    67.689   656.271     0.150
    68.817   663.072     0.150
    74.866   700.473     0.150
    74.885   700.072     0.150
    74.879   701.072     0.150
    77.464   713.572     0.150
    80.310   728.373     0.150
    80.871   732.973     0.150
    81.014   732.973     0.150
    81.588   736.271     0.150
    83.618   747.072     0.150
    84.201   749.373     0.150
    84.982   754.072     0.150
    85.328   754.373     0.150
    86.105   760.072     0.150
    86.657   761.572     0.150
    86.513   760.873     0.150
    90.824   781.873     0.150
    91.138   781.072     0.150
    91.806   785.172     0.150
    92.556   788.373     0.150
   126.859  1144.213     0.150
   127.060  1143.672     0.150
   127.372  1144.072     0.150
     0.784    14.584     0.150
     5.115    78.084     0.150
     7.652   113.584     0.150
     8.560   123.684     0.150
     9.036   131.283     0.150
     9.323   139.783     0.150
    14.774   214.084     0.150
    15.948   224.984     0.150
    16.124   228.584     0.150
    16.190   229.184     0.150
    16.945   238.584     0.150
    17.040   239.584     0.150
    18.867   260.885     0.150
    19.803   283.084     0.150
    20.198   274.584     0.150
    20.265   280.684     0.150
    20.264   280.584     0.150
    20.301   281.184     0.150
    20.301   504.584     0.150
    20.447   280.584     0.150
    21.015   283.584     0.150
    21.456   288.184     0.150
    21.504   290.584     0.150
    22.120   296.783     0.150
    22.120   296.584     0.150
    22.103   294.584     0.150
    22.453   298.584     0.150
    22.755   302.584     0.150
    22.798   301.783     0.150
    23.392   304.584     0.150
    23.392   309.584     0.150
    23.396   306.584     0.150
    23.681   310.584     0.150
    23.908   312.783     0.150
    24.494   317.584     0.150
    24.987   322.584     0.150
    24.987   322.885     0.150
    25.640   327.385     0.150
    25.640   326.584     0.150
    25.690   328.283     0.150
    25.757   327.385     0.150
    25.900   330.584     0.150
    26.369   334.484     0.150
    26.369   333.584     0.150
    26.356   334.783     0.150
    26.400   334.283     0.150
    26.589   336.385     0.150
    26.589   335.584     0.150
    27.695   349.584     0.150
    27.696   345.584     0.150
    27.696   346.484     0.150
    28.096   349.584     0.150
    28.576   355.084     0.150
    29.282   358.984     0.150
    29.282   358.584     0.150
    29.287   359.783     0.150
    29.287   359.584     0.150
    29.486   362.084     0.150
    29.401   360.180     0.150
    29.401   359.584     0.150
    29.910   365.584     0.150
    29.893   365.984     0.150
    30.318   365.584     0.150
    30.318   366.184     0.150
    31.001   375.084     0.150
    31.053   374.984     0.150
    31.053   375.484     0.150
    31.059   376.584     0.150
    31.059   679.584     0.150
    31.059   376.984     0.150
    31.534   380.984     0.150
    31.534   380.584     0.150
    31.950   384.084     0.150
    31.950   694.584     0.150
    32.254   389.584     0.150
    32.971   391.584     0.150
    32.971   392.283     0.150
    32.931   395.584     0.150
    33.026   394.584     0.150
    33.309   399.584     0.150
    33.575   397.684     0.150
    33.920   401.084     0.150
    33.893   402.584     0.150
    34.366   405.584     0.150
    34.729   407.584     0.150
    35.000   410.584     0.150
    34.926   412.584     0.150
    35.621   417.584     0.150
    35.787   416.584     0.150
    36.268   423.584     0.150
    36.268   760.584     0.150
    36.418   422.584     0.150
    36.418   423.484     0.150
    36.560   423.684     0.150
    36.560   423.777     0.150
    36.857   427.584     0.150
    36.956   429.283     0.150
    36.956    10.301     0.150
    37.625   432.584     0.150
    37.625   433.283     0.150
    37.640   433.584     0.150
    37.640   433.885     0.150
    39.143   449.684     0.150
    39.582   449.379     0.150
    39.618   448.084     0.150
    40.170   453.885     0.150
    40.170   820.584     0.150
    40.542   457.584     0.150
    40.571   459.385     0.150
    40.878   460.584     0.150
    40.878     8.000     0.150
    40.834   459.584     0.150
    40.735   459.684     0.150
    40.860   460.885     0.150
    41.037   462.484     0.150
    41.128   463.385     0.150
    41.627   464.584     0.150
    41.644   466.885     0.150
    42.261   471.584     0.150
    43.032   479.584     0.150
    43.032   587.584     0.150
    43.016   477.584     0.150
    44.150   486.584     0.150
    44.150   591.584     0.150
    44.661   491.584     0.150
    45.252   496.584     0.150
    45.460   608.584     0.150
    45.460   896.584     0.150
    45.804   499.584     0.150
    45.967   500.584     0.150
    45.967     9.000     0.150
    45.967   607.584     0.150
    46.007   502.084     0.150
    46.007   501.584     0.150
    46.462   504.984     0.150
    46.592   507.084     0.150
    48.125   517.584     0.150
    48.125   944.584     0.150
    48.630   522.584     0.150
    49.436   529.783     0.150
    49.416   528.584     0.150
    49.726   531.584     0.150
    49.783   531.783     0.150
    50.191    15.000     0.150
    50.447   535.484     0.150
    50.600   537.385     0.150
    50.600     8.199     0.150
    50.782   542.084     0.150
    51.145   543.084     0.150
    51.154   540.584     0.150
    51.154   985.584     0.150
    51.859   548.584     0.150
    52.309   549.084     0.150
    52.309   989.584     0.150
    52.315   552.584     0.150
    52.422   550.584     0.150
    52.422   999.584     0.150
    52.895   556.584     0.150
    52.895  1007.584     0.150
    52.887   556.584     0.150
    52.887   677.584     0.150
    52.887  1007.584     0.150
    53.175   555.584     0.150
    53.873   560.783     0.150
    53.873    12.801     0.150
    53.873   560.584     0.150
    53.873    13.000     0.150
    54.014   563.783     0.150
    54.485   565.283     0.150
    54.485  1029.984     0.150
    54.484   567.584     0.150
    54.978   571.584     0.150
    54.978  1039.584     0.150
    55.341   575.584     0.150
    55.341  1040.184     0.150
    55.341   576.184     0.150
    56.316   580.025     0.150
    56.429   582.584     0.150
    56.429   583.084     0.150
    57.200  1071.584     0.150
    57.362   588.584     0.150
    57.730   589.584     0.150
    57.730   646.584     0.150
    57.730  1065.584     0.150
    58.982   597.584     0.150
    58.982   598.184     0.150
    61.194   612.584     0.150
    61.194  1116.584     0.150
    61.878   615.584     0.150
    61.878  1122.584     0.150
    61.878   754.584     0.150
    61.878  1206.584     0.150
    63.326   625.084     0.150
    64.220   633.885     0.150
    65.308   641.584     0.150
    65.308  1157.584     0.150
    65.308   669.584     0.150
    65.498   642.084     0.150
    65.498  1171.584     0.150
    66.852   651.584     0.150
    67.267   651.584     0.150
    67.789   657.484     0.150
    67.826   658.184     0.150
    67.724   654.584     0.150
    68.029   657.783     0.150
    68.549   660.385     0.150
    68.621   661.584     0.150
    68.852   662.584     0.150
    68.852  1259.584     0.150
    68.717   661.584     0.150
    68.717   660.904     0.150
    69.086   665.484     0.150
    69.176   666.184     0.150
    70.274   669.584     0.150
    70.709   679.584     0.150
    71.093   677.584     0.150
    71.270   678.584     0.150
    71.342   678.084     0.150
    71.354   679.084     0.150
    71.400   678.984     0.150
    71.477   680.984     0.150
    71.529   681.484     0.150
    71.811   682.084     0.150
    72.115   683.584     0.150
    72.115  1248.584     0.150
    73.022   689.584     0.150
    74.192   695.584     0.150
    74.777   698.584     0.150
    74.795   698.584     0.150
    74.791   699.584     0.150
    75.079   700.885     0.150
    75.527   703.084     0.150
    75.936   705.584     0.150
    75.968   705.584     0.150
    75.968   718.584     0.150
    75.968   880.584     0.150
    75.968  1316.584     0.150
    76.602   708.984     0.150
    76.516   710.584     0.150
    76.516  1329.584     0.150
    77.059   711.084     0.150
    76.901   711.584     0.150
    77.193   711.885     0.150
    77.175   711.584     0.150
    77.175   725.584     0.150
    77.399   713.584     0.150
    77.803   713.584     0.150
    77.803   714.484     0.150
    77.745   716.885     0.150
    78.060   717.584     0.150
    78.060   717.984     0.150
    79.740   724.584     0.150
    79.611   724.783     0.150
    79.611  1333.584     0.150
    80.243   726.584     0.150
    80.243   727.084     0.150
    80.276   727.584     0.150
    80.276    13.000     0.150
    80.276  1331.584     0.150
    80.276   913.584     0.150
    80.868   731.783     0.150
    80.915   731.984     0.150
    81.117   733.684     0.150
    81.121   734.084     0.150
    81.159   732.584     0.150
    81.159   733.084     0.150
    81.486   735.084     0.150
    81.486    14.500     0.150
    83.516   745.584     0.150
    83.516    14.100     0.150
    83.488   745.584     0.150
    83.769   747.584     0.150
    83.966   749.584     0.150
    84.099   747.783     0.150
    84.210   750.084     0.150
    84.376   754.084     0.150
    84.726   754.385     0.150
    84.901   753.584     0.150
    85.038   754.885     0.150
    85.157   754.424     0.150
    85.227   753.283     0.150
    85.380   754.584     0.150
    85.187   754.584     0.150
    85.470   756.084     0.150
    86.005   759.584     0.150
    86.296   761.584     0.150
    86.282   758.084     0.150
    86.412   759.584     0.150
    86.412    14.199     0.150
    86.574   760.584     0.150
    86.817   762.584     0.150
    86.970   762.584     0.150
    87.251   763.385     0.150
    87.621   768.084     0.150
    87.623   765.084     0.150
    87.633   766.584     0.150
    87.715   768.584     0.150
    87.765   767.584     0.150
    87.894   767.584     0.150
    87.914   768.584     0.150
    87.940   767.584     0.150
    87.925   766.584     0.150
    87.983   771.584     0.150
    88.214   766.584     0.150
    88.321   772.584     0.150
    88.374   771.584     0.150
    88.461   770.584     0.150
    88.748   773.584     0.150
    89.078   773.084     0.150
    89.139   775.084     0.150
    89.293   774.584     0.150
    89.648   775.684     0.150
    89.744   776.584     0.150
    89.751   781.584     0.150
    89.961   777.283     0.150
    90.022   779.584     0.150
    90.030   778.084     0.150
    90.126   780.584     0.150
    90.199   779.584     0.150
    90.199   781.584     0.150
    90.322   779.584     0.150
    90.318   785.084     0.150
    90.349   777.885     0.150
    90.727   780.584     0.150
    90.727   781.084     0.150
    90.824   781.584     0.150
    91.040   780.484     0.150
    91.013   781.584     0.150
    91.052   785.584     0.150
    91.566   782.584     0.150
    91.704   783.783     0.150
    91.688   786.584     0.150
    91.749   786.584     0.150
    91.799   785.584     0.150
    91.799    13.000     0.150
    91.799   785.984     0.150
    91.799    12.600     0.150
    91.783   783.385     0.150
    91.867   786.385     0.150
    91.867  1014.283     0.150
    91.932   787.584     0.150
    91.992   786.584     0.150
    92.031   787.783     0.150
    92.077   788.084     0.150
    92.112   790.584     0.150
    92.278   786.385     0.150
    92.454   786.984     0.150
    92.454  1004.584     0.150
    92.466   788.584     0.150
    92.466   788.783     0.150
    92.476   787.885     0.150
    92.694   787.984     0.150
    92.854   788.484     0.150
    92.996   795.084     0.150
    93.118   791.283     0.150
    93.118   795.084     0.150
    93.158   791.584     0.150
    93.158    15.000     0.150
    93.158   792.385     0.150
    93.158   795.584     0.150
    93.158    14.199     0.150
    93.255   790.385     0.150
    93.330   793.184     0.150
    93.490   791.885     0.150
    93.511   794.584     0.150
    93.511   795.184     0.150
    93.751   794.584     0.150
    93.819   793.783     0.150
    93.915   792.984     0.150
    93.964   794.084     0.150
    93.985   796.283     0.150
    94.047   794.584     0.150
    94.155   796.484     0.150
    94.235   793.084     0.150
    94.426   798.783     0.150
    94.453   796.184     0.150
    94.481   797.684     0.150
    94.553   797.783     0.150
    94.607   797.283     0.150
    94.625   801.084     0.150
    94.625  1033.184     0.150
    94.672   802.184     0.150
    94.753   799.783     0.150
    94.796   802.584     0.150
    95.103   800.584     0.150
    95.103   804.783     0.150
    95.129   801.684     0.150
    95.138   801.584     0.150
    95.138   804.584     0.150
    95.510   801.584     0.150
    95.661   807.084     0.150
    95.676   806.783     0.150
    96.006   806.484     0.150
    96.006  1047.584     0.150
    95.999   807.584     0.150
    96.060   806.084     0.150
    96.067   806.283     0.150
    96.028   804.885     0.150
    96.268   808.084     0.150
    96.425   807.885     0.150
    96.484   811.584     0.150
    96.552   807.584     0.150
    96.579   807.584     0.150
    96.753   809.584     0.150
    96.728   808.984     0.150
    96.841   808.385     0.150
    96.928   809.885     0.150
    96.928   830.283     0.150
    96.968   809.584     0.150
    97.025   815.084     0.150
    97.292   812.584     0.150
    97.470   811.584     0.150
    97.442   810.584     0.150
    97.442  1042.584     0.150
    97.503   812.783     0.150
    97.506   813.084     0.150
    97.682   812.184     0.150
    97.682  1061.084     0.150
    97.719   814.693     0.150
    97.800   812.084     0.150
    97.916   815.084     0.150
    97.949   815.584     0.150
    98.169   817.584     0.150
    98.235   816.084     0.150
    98.405   815.584     0.150
    98.405  1061.584     0.150
    98.542   818.584     0.150
    98.592   820.385     0.150
    98.604   817.084     0.150
    98.707   821.834     0.150
    98.763   821.084     0.150
    98.818   817.783     0.150
    98.901   818.084     0.150
    99.137   822.084     0.150
    99.160   823.084     0.150
    99.214   822.084     0.150
    99.264   824.104     0.150
    99.347   824.584     0.150
    99.628   825.805     0.150
    99.768   823.084     0.150
    99.768  1063.584     0.150
    99.799   826.084     0.150
    99.895   826.283     0.150
   100.093   824.283     0.150
   100.397   826.584     0.150
   100.310   828.885     0.150
   100.344   828.084     0.150
   100.611   821.584     0.150
   100.647   826.584     0.150
   100.832   828.184     0.150
   100.839   831.184     0.150
   100.910   830.584     0.150
   101.248   831.584     0.150
   101.571   833.283     0.150
   102.662   839.984     0.150
   102.684   839.885     0.150
   104.954   848.385     0.150
   118.587  1129.584     0.150
   118.587  1209.084     0.150
   120.570  1128.584     0.150
   120.773  1131.283     0.150
   122.348  1132.584     0.150
   122.784  1136.584     0.150
   122.840  1135.584     0.150
   122.876  1132.584     0.150
   122.994  1134.584     0.150
   123.280  1133.584     0.150
   123.280  1133.984     0.150
   123.335  1134.584     0.150
   126.790  1143.465     0.150
   126.996  1142.203     0.150
   127.176  1142.545     0.150
   127.308  1142.725     0.150
   151.815  1184.584     0.150
   152.189  1188.584     0.150
   152.288  1188.584     0.150
   152.513  1196.584     0.150
   152.525  1195.924     0.150
   152.624  1195.783     0.150
   152.859  1193.084     0.150
   153.646  1191.584     0.150
   155.760  1194.584     0.150
   155.900  1193.484     0.150
   156.594  1195.584     0.150
   157.351  1192.584     0.150
   157.338  1195.584     0.150
   158.886  1196.584     0.150
   158.886  1205.584     0.150
   163.032  1203.283     0.150
   163.736  1200.984     0.150
   165.977  1204.584     0.150
   166.072  1204.584     0.150
   170.666  1207.084     0.150
     2.897    42.535     0.150
     7.603   110.535     0.150
     8.430   118.535     0.150
     8.890   127.535     0.150
    15.880   222.035     0.150
    16.100   223.535     0.150
    16.839   234.836     0.150
    16.972   236.135     0.150
    18.896   259.135     0.150
    20.910   279.734     0.150
    21.462   285.535     0.150
    22.722   299.535     0.150
    22.792   299.535     0.150
    23.625   308.535     0.150
    23.758   309.535     0.150
    25.770   326.436     0.150
    26.230   330.535     0.150
    26.230   330.734     0.150
    27.172   339.535     0.150
    28.050   346.734     0.150
    28.502   351.436     0.150
    29.483   356.535     0.150
    29.583   358.535     0.150
    29.869   363.035     0.150
    31.053   373.035     0.150
    31.973   382.035     0.150
    32.198   385.035     0.150
    33.006   391.734     0.150
    33.283   394.535     0.150
    33.950   401.535     0.150
    34.617   405.535     0.150
    35.043   407.535     0.150
    36.502   420.535     0.150
    36.502   420.936     0.150
    36.625   421.336     0.150
    36.800   424.734     0.150
    36.855   425.836     0.150
    37.710   430.535     0.150
    37.710   431.035     0.150
    37.719   430.535     0.150
    37.719   431.035     0.150
    40.245   451.535     0.150
    40.460   455.436     0.150
    40.748   457.135     0.150
    40.925   458.535     0.150
    41.015   459.135     0.150
    41.532   463.135     0.150
    42.183   468.734     0.150
    44.126   483.535     0.150
    44.126   484.336     0.150
    45.117   491.535     0.150
    45.117    20.000     0.150
    45.442   495.535     0.150
    45.442    18.801     0.150
    45.442   495.936     0.150
    45.442    18.400     0.150
    46.031   497.535     0.150
    46.031   605.535     0.150
    45.981   498.535     0.150
    45.981   499.336     0.150
    46.525   504.635     0.150
    48.011   513.535     0.150
    48.637   518.535     0.150
    49.477   526.635     0.150
    50.488   533.436     0.150
    51.243   538.535     0.150
    51.959   543.936     0.150
    52.344   544.535     0.150
    52.344   544.836     0.150
    52.370   547.734     0.150
    53.131   552.535     0.150
    53.939   557.535     0.150
    53.939    12.000     0.150
    53.939   558.234     0.150
    53.939    11.301     0.150
    53.887   559.734     0.150
    56.222   575.535     0.150
    56.222   575.936     0.150
    61.134   609.535     0.150
    61.909   612.535     0.150
    61.909    19.000     0.150
    61.909   613.035     0.150
    61.909    18.500     0.150
    64.030   626.535     0.150
    64.115   630.535     0.150
    65.397   639.035     0.150
    68.659   657.535     0.150
    68.659   658.035     0.150
    74.678   694.535     0.150
    74.698   694.535     0.150
    77.085   708.535     0.150
    80.213   724.535     0.150
    80.851   728.436     0.150
    84.067   745.234     0.150
    85.183   750.635     0.150
    85.458   752.535     0.150
    85.942   755.535     0.150
    86.632   757.535     0.150
    90.652   776.535     0.150
    90.652   776.936     0.150
    91.046   777.135     0.150
    91.659   780.734     0.150
    91.728   781.535     0.150
    91.728   781.936     0.150
    92.412   783.936     0.150
    95.035   797.535     0.150
    95.063   798.135     0.150
    95.446   798.535     0.150
    95.936   802.035     0.150
     2.799    46.020     0.150
     6.026    95.020     0.150
     7.753   116.020     0.150
     8.715   127.419     0.150
     9.217   134.819     0.150
    15.779   229.020     0.150
    16.069   232.419     0.150
    16.193   411.520     0.150
    17.108   240.220     0.150
    17.162   245.020     0.150
    21.484   288.520     0.150
    21.484   540.020     0.150
    22.640   302.020     0.150
    22.842   301.520     0.150
    22.834   303.419     0.150
    22.834   550.020     0.150
    23.605   311.020     0.150
    23.842   314.020     0.150
    23.996   314.020     0.150
    24.102   316.419     0.150
    24.700   322.020     0.150
    25.896   333.020     0.150
    26.086   332.919     0.150
    26.271   335.520     0.150
    26.538   337.919     0.150
    26.538   336.919     0.150
    27.226   343.319     0.150
    28.702   357.020     0.150
    29.960   366.220     0.150
    30.939   373.620     0.150
    30.939   552.919     0.150
    30.992   374.620     0.150
    31.103   377.520     0.150
    31.103   680.020     0.150
    31.956   385.220     0.150
    32.361   390.520     0.150
    33.089   394.819     0.150
    33.378   398.520     0.150
    33.488   397.520     0.150
    33.488   559.020     0.150
    33.918   401.720     0.150
    34.408   405.819     0.150
    34.980   411.520     0.150
    36.445   423.819     0.150
    36.445     7.400     0.150
    36.964   429.620     0.150
    39.583   451.020     0.150
    40.106   454.220     0.150
    40.106   454.020     0.150
    40.740   461.419     0.150
    40.925   461.020     0.150
    41.030   463.220     0.150
    41.206   464.620     0.150
    41.297   465.220     0.150
    41.813   469.220     0.150
    43.117   480.020     0.150
    44.217   488.020     0.150
    44.217   884.020     0.150
    44.217   488.220     0.150
    45.443   500.020     0.150
    45.443   597.520     0.150
    45.851   500.620     0.150
    46.076   503.020     0.150
    46.076   503.520     0.150
    46.407   505.520     0.150
    46.407   505.020     0.150
    46.428   506.020     0.150
    46.710   509.520     0.150
    48.657   522.020     0.150
    48.657   522.819     0.150
    49.348   530.620     0.150
    49.973   534.020     0.150
    50.360   536.919     0.150
    50.512   538.419     0.150
    51.704   546.020     0.150
    52.524   553.020     0.150
    53.268   557.020     0.150
    53.268   557.120     0.150
    54.198   565.819     0.150
    54.594   567.020     0.150
    54.594  1027.220     0.150
    54.594   687.020     0.150
    54.621   569.020     0.150
    55.132   572.020     0.150
    55.132  1036.120     0.150
    55.132   572.120     0.150
    55.132  1039.020     0.150
    56.467   581.020     0.150
    56.467   581.419     0.150
    57.515   589.020     0.150
    57.875   590.020     0.150
    57.875   646.020     0.150
    59.133   599.020     0.150
    59.133   599.419     0.150
    61.305   614.020     0.150
    61.305  1115.020     0.150
    61.305  1128.319     0.150
    61.874   617.020     0.150
    61.874     5.000     0.150
    61.874  1119.020     0.150
    64.085   631.020     0.150
    64.381   635.419     0.150
    64.381  1166.020     0.150
    65.656   644.020     0.150
    66.747   651.020     0.150
    68.786   662.620     0.150
    68.786     7.400     0.150
    68.825   663.020     0.150
    74.932   701.020     0.150
    76.358   709.020     0.150
    76.684   710.520     0.150
    77.051   713.020     0.150
    77.320   713.020     0.150
    77.539   714.520     0.150
    81.030   733.020     0.150
    81.564   736.020     0.150
    84.176   749.319     0.150
    84.917   755.020     0.150
    85.074   756.020     0.150
    85.308   754.520     0.150
    85.317   754.419     0.150
    86.509   760.520     0.150
    88.180   774.520     0.150
    88.598   772.020     0.150
    88.598   772.520     0.150
    89.216   777.020     0.150
    89.216   777.520     0.150
    90.856   782.020     0.150
    90.856   787.520     0.150
    90.856   782.319     0.150
    90.856     5.200     0.150
    91.068   781.220     0.150
    91.797   784.220     0.150
    91.875   788.020     0.150
    91.922   786.020     0.150
    91.922   786.419     0.150
    92.543   788.220     0.150
    95.224   802.020     0.150
    95.247   803.020     0.150
    96.128   806.520     0.150
    96.128   807.319     0.150
   100.952   828.819     0.150
   126.976  1144.819     0.150
   127.187  1143.419     0.150
   127.366  1143.819     0.150
   127.499  1144.120     0.150
   165.899  1204.819     0.150
     2.879    45.457     0.150
     6.010    92.457     0.150
     7.721   114.457     0.150
    17.151   244.457     0.150
    17.151   437.457     0.150
    21.385   286.957     0.150
    22.756   301.855     0.150
    22.778   301.457     0.150
    23.416   305.457     0.150
    23.847   313.656     0.150
    24.255   316.258     0.150
    26.615   336.457     0.150
    28.696   355.457     0.150
    29.309   359.457     0.150
    29.892   364.656     0.150
    31.013   374.656     0.150
    31.066   374.258     0.150
    31.016   375.957     0.150
    31.840   383.758     0.150
    33.018   394.957     0.150
    33.539   396.656     0.150
    34.846   409.957     0.150
    34.951   410.457     0.150
    36.936   428.258     0.150
    40.790   461.059     0.150
    41.082   462.855     0.150
    41.257   464.258     0.150
    41.350   465.258     0.150
    41.864   468.656     0.150
    43.022   478.457     0.150
    44.149   486.457     0.150
    45.541   498.457     0.150
    45.541     9.500     0.150
    46.486   505.457     0.150
    46.486   505.559     0.150
    46.540   507.559     0.150
    46.694   507.957     0.150
    48.555   521.457     0.150
    48.555   521.656     0.150
    49.398   529.656     0.150
    49.398     8.402     0.150
    50.410   536.355     0.150
    50.410     8.102     0.150
    51.673   544.457     0.150
    52.173   548.457     0.150
    52.477   552.957     0.150
    53.152   557.258     0.150
    53.152  1014.457     0.150
    53.668   558.457     0.150
    53.668     9.000     0.150
    53.668   559.258     0.150
    53.668     8.199     0.150
    54.567   565.457     0.150
    54.567    10.000     0.150
    54.567   565.758     0.150
    54.567     9.699     0.150
    54.627   567.457     0.150
    54.627    10.000     0.150
    54.627   567.957     0.150
    54.627     9.500     0.150
    55.159   571.457     0.150
    55.159   571.559     0.150
    55.500   573.457     0.150
    55.500     9.500     0.150
    55.500   573.957     0.150
    55.500     9.000     0.150
    56.490   580.457     0.150
    56.490   580.559     0.150
    57.429   588.457     0.150
    57.541   587.457     0.150
    57.541   587.957     0.150
    61.280   612.957     0.150
    61.750   614.457     0.150
    61.750   614.957     0.150
    64.419   635.457     0.150
    65.499   642.457     0.150
    65.689   643.656     0.150
    65.689     9.000     0.150
    66.778   647.457     0.150
    67.799   655.457     0.150
    67.799   655.758     0.150
    68.628   660.457     0.150
    68.628     7.000     0.150
    68.797   661.457     0.150
    74.962   699.457     0.150
    77.074   712.457     0.150
    77.335   712.457     0.150
    77.335    10.000     0.150
    81.010   729.457     0.150
    84.116   748.355     0.150
    85.271   753.355     0.150
    86.386   759.457     0.150
    86.469   760.156     0.150
    91.788   783.656     0.150
    92.495   786.855     0.150
   151.758  1183.656     0.150
   152.749  1189.457     0.150
     2.878    42.191     0.150
     5.990    89.191     0.150
     7.705   113.191     0.150
    16.036   229.191     0.150
    16.122   229.191     0.150
    17.117   239.691     0.150
    17.129   243.191     0.150
    19.969   267.992     0.150
    19.969   267.992     0.150
    19.969   497.691     0.150
    21.391   286.891     0.150
    22.757   300.691     0.150
    22.770   301.191     0.150
    23.417   305.191     0.150
    23.643   312.191     0.150
    23.821   313.590     0.150
    24.203   314.891     0.150
    26.573   335.191     0.150
    28.137   348.691     0.150
    28.673   354.590     0.150
    29.888   364.492     0.150
    29.888   670.191     0.150
    31.016   374.191     0.150
    31.018   375.691     0.150
    31.018   683.191     0.150
    31.852   383.492     0.150
    33.014   393.793     0.150
    33.548   396.391     0.150
    33.308   397.191     0.150
    33.308   844.191     0.150
    33.810   399.391     0.150
    33.810     9.000     0.150
    34.490   405.090     0.150
    34.490   406.191     0.150
    34.865   408.691     0.150
    34.914   409.191     0.150
    36.484   423.691     0.150
    36.920   426.992     0.150
    40.754   460.191     0.150
    41.045   462.391     0.150
    41.221   463.590     0.150
    41.313   464.492     0.150
    41.828   468.590     0.150
    44.144   486.191     0.150
    45.496   497.191     0.150
    46.005   501.191     0.150
    46.005   501.992     0.150
    46.487   504.191     0.150
    46.487   504.691     0.150
    46.492   503.793     0.150
    46.674   507.391     0.150
    48.562   521.191     0.150
    48.562   521.391     0.150
    52.189   547.492     0.150
    53.125   555.191     0.150
    53.212   554.191     0.150
    53.212   554.691     0.150
    53.695   557.191     0.150
    53.695   557.492     0.150
    54.550   565.191     0.150
    54.601   567.191     0.150
    54.601    12.000     0.150
    55.128   568.691     0.150
    57.510   587.191     0.150
    57.863   590.191     0.150
    57.863   590.391     0.150
    61.263   612.191     0.150
    61.765   614.191     0.150
    61.765     8.000     0.150
    64.001   629.191     0.150
    64.386   633.191     0.150
    65.657   642.492     0.150
    67.784   654.191     0.150
    68.658   660.691     0.150
    68.658     6.500     0.150
    74.931   699.191     0.150
    76.601   708.191     0.150
    77.044   711.992     0.150
    77.307   712.191     0.150
    80.027   725.191     0.150
    80.027   725.793     0.150
    80.991   734.191     0.150
    81.497   733.191     0.150
    81.497   734.090     0.150
    83.514   744.191     0.150
    84.109   747.992     0.150
    85.179   753.191     0.150
    85.260   752.492     0.150
    86.411   759.191     0.150
    86.456   758.492     0.150
    91.742   783.793     0.150
    92.484   786.590     0.150
   127.237  1141.891     0.150
   165.877  1203.191     0.150
     2.897    45.805     0.150
     7.694   115.805     0.150
    17.118   242.305     0.150
    21.370   287.906     0.150
    22.738   299.805     0.150
    22.755   302.305     0.150
    24.105   315.203     0.150
    24.224   316.805     0.150
    26.580   337.805     0.150
    27.122   342.605     0.150
    28.125   351.004     0.150
    29.871   367.203     0.150
    31.033   375.605     0.150
    31.086   375.605     0.150
    30.998   375.805     0.150
    31.829   384.406     0.150
    32.306   388.805     0.150
    32.306     6.500     0.150
    32.997   395.203     0.150
    33.562   397.504     0.150
    34.509   404.805     0.150
    34.840   410.305     0.150
    34.917   411.004     0.150
    36.909   428.805     0.150
    40.756   461.805     0.150
    41.048   462.805     0.150
    41.223   464.605     0.150
    41.316   465.504     0.150
    41.830   469.203     0.150
    45.506   499.805     0.150
    45.899   501.805     0.150
    46.505   507.805     0.150
    46.505   506.906     0.150
    46.666   509.004     0.150
    49.422   530.504     0.150
    50.434   536.906     0.150
    50.585   537.805     0.150
    64.386   635.805     0.150
    85.151   753.805     0.150
    86.384   759.805     0.150
    92.471   787.805     0.150
     2.862    43.051     0.150
     5.177    79.852     0.150
     5.865    87.051     0.150
     7.682   112.051     0.150
     8.311   123.152     0.150
    17.033   234.551     0.150
    20.119   279.652     0.150
    20.119   509.051     0.150
    20.156   279.852     0.150
    21.429   287.551     0.150
    21.429   519.051     0.150
    21.429   533.051     0.150
    22.783   301.551     0.150
    22.767   302.551     0.150
    23.398   305.051     0.150
    23.941   313.051     0.150
    24.053   314.949     0.150
    25.821   333.051     0.150
    26.465   335.051     0.150
    27.166   341.949     0.150
    28.121   350.551     0.150
    28.628   354.652     0.150
    29.102   358.852     0.150
    29.896   366.449     0.150
    31.044   376.551     0.150
    31.002   373.750     0.150
    31.055   373.652     0.150
    31.907   384.250     0.150
    32.290   389.051     0.150
    32.290     7.000     0.150
    33.556   397.051     0.150
    33.871   399.652     0.150
    33.871     9.398     0.150
    34.939   410.051     0.150
    34.823   409.551     0.150
    36.893   428.449     0.150
    40.664   459.852     0.150
    40.955   461.449     0.150
    41.131   463.250     0.150
    41.222   463.852     0.150
    41.737   468.051     0.150
    45.374   498.051     0.150
    46.362   504.551     0.150
    46.469   505.051     0.150
    46.637   507.051     0.150
    49.417   529.250     0.150
    50.428   535.852     0.150
    56.391   580.051     0.150
    64.305   633.652     0.150
    68.753   661.652     0.150
    71.182   677.051     0.150
    71.194   678.051     0.150
    71.359   679.051     0.150
    71.430   679.051     0.150
    80.957   729.852     0.150
    84.079   746.852     0.150
    84.109   748.449     0.150
    84.842   753.051     0.150
    84.999   754.051     0.150
    86.499   760.051     0.150
    91.013   780.051     0.150
   165.973  1203.949     0.150
     2.828    46.053     0.150
     5.242    80.053     0.150
     5.945    89.053     0.150
     7.733   115.053     0.150
    21.452   287.053     0.150
    22.812   301.053     0.150
    22.810   301.053     0.150
    24.129   316.153     0.150
    26.620   339.053     0.150
    28.169   350.053     0.150
    28.688   355.853     0.150
    29.933   366.053     0.150
    30.967   374.953     0.150
    30.967     8.300     0.150
    31.020   375.553     0.150
    31.072   376.053     0.150
    33.062   394.653     0.150
    33.511   396.053     0.150
    33.511     8.900     0.150
    34.438   406.453     0.150
    34.942   408.753     0.150
    34.898   410.053     0.150
    36.462   422.553     0.150
    36.462     8.000     0.150
    36.945   429.053     0.150
    40.738   460.953     0.150
    41.205   464.253     0.150
    45.454   499.053     0.150
    46.443   507.053     0.150
    46.694   508.453     0.150
    50.383   536.253     0.150
    50.383     8.400     0.150
    64.376   635.053     0.150
    83.559   747.053     0.150
    84.150   748.853     0.150
    85.267   753.253     0.150
    85.295   753.353     0.150
    86.493   759.553     0.150
    86.487   759.753     0.150
    92.520   787.053     0.150
     1.080    14.545     0.150
     1.910    49.545     0.150
     3.285    48.545     0.150
     5.117    75.045     0.150
     5.512    82.045     0.150
     5.828    90.045     0.150
     6.277    90.545     0.150
     7.455   108.545     0.150
    15.779   220.045     0.150
    16.926   237.545     0.150
    17.072   234.945     0.150
    20.968   279.744     0.150
    22.362   292.545     0.150
    22.448   295.545     0.150
    23.662   308.545     0.150
    23.715   307.545     0.150
    24.542   317.045     0.150
    25.801   328.545     0.150
    26.217   330.545     0.150
    26.631   334.846     0.150
    26.749   333.744     0.150
    27.852   344.045     0.150
    28.481   350.744     0.150
    28.614   351.545     0.150
    28.668   349.545     0.150
    28.668   349.346     0.150
    29.536   361.145     0.150
    29.536   653.545     0.150
    30.620   368.545     0.150
    31.441   374.145     0.150
    31.444   374.145     0.150
    31.393   376.145     0.150
    32.062   455.545     0.150
    32.653   386.145     0.150
    32.961   389.545     0.150
    33.339   392.145     0.150
    33.339    15.400     0.150
    33.864   395.744     0.150
    34.375   402.045     0.150
    34.892   407.945     0.150
    36.724   420.846     0.150
    36.667   422.545     0.150
    40.725   457.145     0.150
    41.023   458.945     0.150
    41.196   460.346     0.150
    41.802   465.145     0.150
    42.611   471.545     0.150
    43.790   479.545     0.150
    43.790   480.045     0.150
    43.790   586.045     0.150
    44.858   488.545     0.150
    44.858   595.145     0.150
    45.621   497.045     0.150
    46.453   502.545     0.150
    46.453    20.000     0.150
    46.665   504.744     0.150
    46.665   505.545     0.150
    46.870   505.645     0.150
    46.811   505.545     0.150
    46.811   505.744     0.150
    47.966   514.545     0.150
    50.027   528.545     0.150
    50.138   531.545     0.150
    50.883   536.545     0.150
    51.800   542.545     0.150
    51.710   541.346     0.150
    52.917   549.545     0.150
    52.917  1127.545     0.150
    53.177   552.545     0.150
    54.299   560.445     0.150
    54.299   683.545     0.150
    55.030   565.545     0.150
    55.030   566.445     0.150
    56.349   575.545     0.150
    56.349   576.346     0.150
    57.381   584.545     0.150
    61.017   607.545     0.150
    61.292   608.545     0.150
    63.606   623.545     0.150
    63.606   659.545     0.150
    64.319   630.545     0.150
    68.133   654.145     0.150
    68.133    19.400     0.150
    71.984   676.346     0.150
    76.479   704.744     0.150
    77.062   708.145     0.150
    77.214   709.545     0.150
    77.444   710.445     0.150
    77.444  1832.945     0.150
    78.981   717.545     0.150
    79.497   719.545     0.150
    79.497   720.445     0.150
    82.287   734.846     0.150
    83.722   742.346     0.150
    83.774   742.545     0.150
    84.653   747.145     0.150
    85.021   748.545     0.150
    85.274   749.346     0.150
    86.170   755.045     0.150
    86.426   755.645     0.150
    92.178   781.346     0.150
    95.917   800.445     0.150
   113.651  1112.545     0.150
   165.785  1198.545     0.150
     0.848    16.008     0.150
     0.848    28.008     0.150
     1.059    19.508     0.150
     1.059    36.008     0.150
     1.883    31.008     0.150
     1.883    55.008     0.150
     3.266    53.008     0.150
     5.115    79.508     0.150
     5.512    86.008     0.150
     5.792   112.008     0.150
     7.450   114.008     0.150
     7.461   112.008     0.150
     7.986   120.008     0.150
    22.459   300.008     0.150
    27.861   349.508     0.150
    28.484   356.207     0.150
    29.550   364.508     0.150
    31.425   379.609     0.150
    31.429   379.008     0.150
    31.429   442.309     0.150
    31.415   380.906     0.150
    32.069   388.008     0.150
    32.668   393.008     0.150
    33.362   401.008     0.150
    33.852   401.008     0.150
    34.863   410.609     0.150
    34.863   410.406     0.150
    34.885   413.008     0.150
    36.674   427.906     0.150
    46.647   510.207     0.150
    51.802   548.008     0.150
    51.733   545.406     0.150
    83.736   747.508     0.150
    84.681   752.008     0.150
     1.038    19.109     0.150
     2.437    44.609     0.150
     3.247    56.609     0.150
     3.313    54.508     0.150
     5.069    79.109     0.150
     5.465    87.109     0.150
     7.412   111.609     0.150
     7.936   119.609     0.150
    17.024   243.008     0.150
    20.940   284.109     0.150
    22.330   298.609     0.150
    22.410   299.609     0.150
    23.616   313.008     0.150
    25.754   332.609     0.150
    27.811   349.008     0.150
    28.436   355.812     0.150
    31.370   380.211     0.150
    32.020   387.609     0.150
    32.020    13.500     0.150
    32.020   456.609     0.150
    32.925   394.609     0.150
    33.318   398.109     0.150
    33.318    15.000     0.150
    33.902   401.508     0.150
    34.912   411.211     0.150
    34.912   411.008     0.150
    34.844   412.211     0.150
    36.625   427.312     0.150
    36.990   432.609     0.150
    40.677   462.070     0.150
    41.078   463.008     0.150
    40.975   463.672     0.150
    41.148   465.250     0.150
    41.243   466.086     0.150
    41.754   469.992     0.150
    44.893   493.609     0.150
    45.574   501.609     0.150
    46.409   508.211     0.150
    46.618   510.609     0.150
    51.847   548.711     0.150
    56.302   581.211     0.150
    57.332   589.609     0.150
    79.889   727.812     0.150
    83.687   747.109     0.150
    84.648   752.609     0.150
     1.079    19.932     0.150
     1.079    35.932     0.150
     2.375    41.932     0.150
    20.994   284.932     0.150
    22.471   302.932     0.150
    23.680   315.332     0.150
    27.874   350.232     0.150
    28.500   355.932     0.150
    30.645   375.432     0.150
    31.416   379.332     0.150
    31.420   379.332     0.150
    31.419   382.732     0.150
    32.083   389.432     0.150
    32.678   394.932     0.150
    34.855   410.332     0.150
    34.855     3.400     0.150
    34.855   410.531     0.150
    34.904   412.732     0.150
    36.307   423.932     0.150
    36.688   428.932     0.150
    46.667   513.531     0.150
    46.845   510.832     0.150
    51.785   548.232     0.150
    83.746   748.330     0.150
    84.678   752.932     0.150
     0.832    15.553     0.150
     1.062    19.553     0.150
     1.899    30.553     0.150
     2.400    40.553     0.150
     3.225    50.553     0.150
     3.281    51.553     0.150
     5.107    78.553     0.150
     5.504    89.053     0.150
     6.258    95.553     0.150
     7.439   111.553     0.150
     7.451   110.553     0.150
     7.973   119.553     0.150
     9.315   139.553     0.150
    15.152   215.553     0.150
    15.779   223.553     0.150
    15.825   225.553     0.150
    17.061   243.553     0.150
    19.645   279.354     0.150
    20.973   285.752     0.150
    20.973   517.553     0.150
    20.973   549.553     0.150
    22.207   297.553     0.150
    22.364   301.553     0.150
    22.446   299.553     0.150
    23.122   306.252     0.150
    23.800   312.553     0.150
    23.654   313.953     0.150
    23.654   565.553     0.150
    24.522   320.252     0.150
    25.791   334.752     0.150
    26.171   333.553     0.150
    26.203   337.553     0.150
    26.617   339.953     0.150
    26.617   339.553     0.150
    27.034   343.553     0.150
    27.034   344.152     0.150
    27.849   349.053     0.150
    27.849   635.553     0.150
    28.474   355.354     0.150
    29.537   366.854     0.150
    29.537   660.553     0.150
    31.450   379.854     0.150
    31.400   380.553     0.150
    32.058   387.553     0.150
    32.058   452.053     0.150
    32.654   392.953     0.150
    32.961   395.053     0.150
    32.961    12.500     0.150
    33.203   397.553     0.150
    33.203   727.553     0.150
    33.347   398.553     0.150
    33.347     8.000     0.150
    33.865   400.553     0.150
    34.384   409.152     0.150
    34.877   411.053     0.150
    34.877   743.553     0.150
    34.880   412.553     0.150
    36.728   425.553     0.150
    36.663   427.152     0.150
    36.663   774.553     0.150
    37.027   429.053     0.150
    39.467   447.553     0.150
    39.467   806.553     0.150
    39.467   447.854     0.150
    39.913   456.553     0.150
    39.913   815.553     0.150
    41.047   462.553     0.150
    41.011   464.133     0.150
    41.184   465.572     0.150
    41.280   465.973     0.150
    41.790   470.072     0.150
    42.615   477.553     0.150
    43.239   479.553     0.150
    43.791   484.553     0.150
    43.791   485.053     0.150
    43.791  1071.553     0.150
    44.857   494.152     0.150
    44.857   602.953     0.150
    45.076   499.553     0.150
    45.076   499.752     0.150
    45.606   502.553     0.150
    45.656   500.553     0.150
    45.656   501.354     0.150
    46.098   505.553     0.150
    46.447   507.752     0.150
    46.648   510.152     0.150
    47.954   519.553     0.150
    48.138   518.553     0.150
    48.138   519.152     0.150
    49.723   533.854     0.150
    50.122   536.053     0.150
    50.422   975.553     0.150
    50.735   538.752     0.150
    50.884   542.553     0.150
    51.810   548.553     0.150
    52.200   549.053     0.150
    52.200   999.053     0.150
    52.825   559.553     0.150
    52.817   559.553     0.150
    52.915   553.553     0.150
    52.915   554.354     0.150
    52.915   625.553     0.150
    53.019   556.553     0.150
    53.189   559.553     0.150
    53.189    12.000     0.150
    53.189   560.053     0.150
    53.189    11.500     0.150
    53.189   680.553     0.150
    54.295  1030.453     0.150
    54.432   693.553     0.150
    55.021   572.553     0.150
    55.021  1041.553     0.150
    55.021   573.053     0.150
    55.021   695.553     0.150
    56.471   585.553     0.150
    56.471  1051.953     0.150
    56.471   586.453     0.150
    57.368   590.553     0.150
    57.397  1073.553     0.150
    57.722   592.553     0.150
    57.722  1069.553     0.150
    61.013   612.553     0.150
    61.013  1116.553     0.150
    61.299   615.553     0.150
    61.299  1118.553     0.150
    61.299   659.553     0.150
    61.299   753.553     0.150
    63.609   632.252     0.150
    63.609  1141.553     0.150
    63.609   662.553     0.150
    63.609   770.553     0.150
    63.609  1167.553     0.150
    63.609  1221.553     0.150
    64.308   636.553     0.150
    65.375   647.553     0.150
    67.519   657.553     0.150
    71.203   679.553     0.150
    71.446   681.553     0.150
    79.511   725.152     0.150
    79.596   730.252     0.150
    80.752  1385.553     0.150
    84.666   753.553     0.150
    85.019   754.354     0.150
    85.570   758.854     0.150
    86.167   762.553     0.150
    88.510   778.553     0.150
    90.627   782.553     0.150
    90.627     9.199     0.150
    91.059   784.553     0.150
    95.351   806.553     0.150
   113.669  1119.553     0.150
     0.879    16.188     0.150
     0.848    15.789     0.150
     0.848    28.789     0.150
     1.830    27.789     0.150
     1.830    51.789     0.150
     2.479    43.289     0.150
     2.479    74.289     0.150
     3.136    54.789     0.150
     3.282    53.789     0.150
     7.362   109.789     0.150
    20.978   283.789     0.150
    26.431   338.789     0.150
    30.612   373.289     0.150
    31.973   387.188     0.150
    34.715   409.789     0.150
    34.892   409.086     0.150
    40.550   459.609     0.150
    40.846   461.367     0.150
    41.020   463.109     0.150
    41.114   463.945     0.150
    41.626   467.109     0.150
    44.894   493.188     0.150
    45.407   499.789     0.150
    51.768   545.789     0.150
    51.952   548.688     0.150
    64.156   634.992     0.150
    84.782   751.789     0.150
    85.416   757.289     0.150
    85.997   758.789     0.150
     0.868    16.078     0.150
     0.868    30.078     0.150
     0.936    17.078     0.150
     1.772    28.078     0.150
     1.772    49.078     0.150
     5.432    86.078     0.150
     7.420   111.078     0.150
    16.947   241.281     0.150
    21.040   284.578     0.150
    21.040   522.078     0.150
    23.586   312.281     0.150
    26.799   339.578     0.150
    27.838   348.781     0.150
    28.420   353.781     0.150
    29.561   364.578     0.150
    30.674   373.578     0.150
    31.413   377.477     0.150
    31.413   553.078     0.150
    31.493   382.477     0.150
    32.032   388.078     0.150
    32.032     6.500     0.150
    32.032    11.000     0.150
    32.684   393.180     0.150
    32.983   395.875     0.150
    33.859   400.375     0.150
    34.830   409.375     0.150
    34.759   410.281     0.150
    36.236   422.078     0.150
    36.636   427.078     0.150
    40.595   459.695     0.150
    40.890   462.078     0.150
    41.064   464.219     0.150
    41.158   464.539     0.150
    41.670   468.797     0.150
    43.527   481.078     0.150
    44.832   493.078     0.150
    45.437   499.578     0.150
    49.718   533.281     0.150
    51.827   546.477     0.150
    51.903   548.781     0.150
    76.005   706.375     0.150
    77.249   713.578     0.150
    79.181   723.281     0.150
    80.558   731.977     0.150
    84.832   752.578     0.150
    86.052   759.078     0.150
     0.516     9.613     0.150
     0.516    18.613     0.150
     1.778    31.813     0.150
     1.778    51.613     0.150
     2.073    32.613     0.150
     2.073    64.613     0.150
     3.025    48.613     0.150
     3.704    58.613     0.150
     4.642    78.113     0.150
     4.698    71.613     0.150
     4.698   126.613     0.150
     5.054    79.613     0.150
     8.058   120.613     0.150
    15.864   227.513     0.150
    20.941   284.613     0.150
    21.993   295.813     0.150
    22.306   299.613     0.150
    23.400   311.113     0.150
    23.811   313.613     0.150
    25.242   327.613     0.150
    25.242   327.613     0.150
    27.261   344.713     0.150
    29.182   360.813     0.150
    30.458   373.113     0.150
    30.458   676.613     0.150
    31.367   382.113     0.150
    31.367   691.613     0.150
    31.543   380.613     0.150
    31.769   382.313     0.150
    32.334   390.813     0.150
    33.633   400.213     0.150
    34.398   405.613     0.150
    34.734   410.213     0.150
    34.734     6.700     0.150
    35.128   412.013     0.150
    35.128   750.213     0.150
    35.965   422.013     0.150
    35.965     6.600     0.150
    36.255   422.013     0.150
    39.478   451.413     0.150
    39.764   453.013     0.150
    39.941   454.413     0.150
    40.031   456.413     0.150
    40.548   459.413     0.150
    44.144   489.813     0.150
    45.254   496.513     0.150
    45.654   502.813     0.150
    45.654  1098.613     0.150
    46.618   507.613     0.150
    47.139   511.613     0.150
    50.370   539.713     0.150
    51.265   544.113     0.150
    51.423   545.113     0.150
    63.142   628.613     0.150
    80.040   729.913     0.150
    80.258   730.813     0.150
    80.457   732.013     0.150
    83.331   745.813     0.150
    84.443   751.313     0.150
    85.391   756.613     0.150
    86.411   761.613     0.150
    91.440   784.613     0.150
    95.080   802.113     0.150
     0.999    18.594     0.150
     1.084    19.594     0.150
     1.084    34.594     0.150
     1.738    29.594     0.150
     2.251    37.094     0.150
     3.067    48.594     0.150
     5.220    79.594     0.150
     6.257    93.594     0.150
     8.130   123.594     0.150
     9.217   136.094     0.150
    10.648   150.594     0.150
    15.960   230.293     0.150
    15.960   413.594     0.150
    16.266   235.094     0.150
    17.159   239.195     0.150
    19.670   274.594     0.150
    19.670   275.395     0.150
    19.707   274.594     0.150
    19.707   275.395     0.150
    20.025   271.594     0.150
    20.025   271.895     0.150
    21.139   284.594     0.150
    21.606   289.594     0.150
    21.606   290.492     0.150
    22.529   299.594     0.150
    22.602   301.094     0.150
    23.001   307.293     0.150
    23.076   306.594     0.150
    23.636   309.395     0.150
    23.767   312.594     0.150
    23.780   313.195     0.150
    24.228   318.594     0.150
    24.498   317.895     0.150
    24.483   317.695     0.150
    24.903   324.594     0.150
    25.098   323.594     0.150
    25.098   324.195     0.150
    25.812   329.594     0.150
    25.812   330.492     0.150
    25.901   331.594     0.150
    26.060   332.594     0.150
    26.915   340.195     0.150
    27.142   342.293     0.150
    27.783   346.395     0.150
    27.999   350.594     0.150
    27.999   399.594     0.150
    27.999   545.594     0.150
    27.999   708.594     0.150
    28.607   355.793     0.150
    28.607   414.594     0.150
    28.704   354.895     0.150
    28.722   355.793     0.150
    28.832   354.695     0.150
    29.696   365.492     0.150
    30.787   374.594     0.150
    30.960   375.793     0.150
    31.280   376.992     0.150
    31.567   380.992     0.150
    32.203   388.094     0.150
    32.203   719.594     0.150
    32.390   386.895     0.150
    32.815   393.594     0.150
    32.815   710.094     0.150
    33.120   395.195     0.150
    33.120     6.398     0.150
    33.120   466.594     0.150
    33.120   713.594     0.150
    33.514   397.793     0.150
    33.514    10.801     0.150
    33.710   398.594     0.150
    34.549   407.492     0.150
    34.973   411.895     0.150
    34.973   789.594     0.150
    35.844   420.594     0.150
    36.807   427.793     0.150
    36.807     7.301     0.150
    36.807   515.594     0.150
    37.046   429.594     0.150
    37.113   427.594     0.150
    37.079   430.094     0.150
    37.134   432.195     0.150
    39.090   447.695     0.150
    39.209   448.574     0.150
    39.622   450.395     0.150
    39.908   454.516     0.150
    40.469   459.293     0.150
    40.807   459.094     0.150
    40.807     5.699     0.150
    40.808   461.812     0.150
    41.104   463.754     0.150
    41.278   464.953     0.150
    41.372   465.793     0.150
    41.884   469.855     0.150
    42.698   476.914     0.150
    42.725   477.195     0.150
    42.781   476.594     0.150
    43.308   481.992     0.150
    43.951   485.094     0.150
    43.951   590.594     0.150
    44.694   490.992     0.150
    45.238   494.895     0.150
    45.656   500.594     0.150
    46.040   504.395     0.150
    46.586   507.094     0.150
    46.586   599.793     0.150
    46.586   616.594     0.150
    46.586   916.094     0.150
    46.705   507.793     0.150
    46.684   508.594     0.150
    48.304   519.793     0.150
    50.580    10.301     0.150
    50.568   537.594     0.150
    50.568   538.094     0.150
    50.730   541.094     0.150
    51.698   546.195     0.150
    51.884   546.293     0.150
    61.156   612.594     0.150
    61.156  1118.594     0.150
    65.483   643.793     0.150
    67.217   653.594     0.150
    67.665   655.094     0.150
    68.300   659.195     0.150
    68.300  1201.594     0.150
    68.667   660.594     0.150
    68.667   661.094     0.150
    68.667   686.594     0.150
    74.970   699.594     0.150
    75.968   705.305     0.150
    75.998   705.965     0.150
    76.502   709.594     0.150
    76.646   709.004     0.150
    76.708   710.594     0.150
    77.224   712.664     0.150
    77.441   713.043     0.150
    77.556   714.793     0.150
    77.556     7.301     0.150
    77.556  1310.992     0.150
    77.641   714.812     0.150
    77.683   714.516     0.150
    77.765   715.922     0.150
    78.052   717.922     0.150
    78.574   722.266     0.150
    78.623   718.734     0.150
    79.030   724.922     0.150
    79.138   721.574     0.150
    79.136   725.094     0.150
    79.654   729.594     0.150
    79.657   724.422     0.150
    79.657   725.195     0.150
    80.518   731.195     0.150
    80.678   730.914     0.150
    80.893   731.594     0.150
    81.498   735.992     0.150
    81.920   738.293     0.150
    82.042   738.594     0.150
    82.442   740.695     0.150
    82.913   743.695     0.150
    83.934   751.195     0.150
    83.958   751.094     0.150
    84.010   747.594     0.150
    84.266   751.594     0.150
    84.276   752.695     0.150
    84.344   753.195     0.150
    84.343   751.793     0.150
    84.353   752.895     0.150
    84.363   755.594     0.150
    84.407   753.293     0.150
    84.479   753.594     0.150
    84.554   753.992     0.150
    84.695   754.793     0.150
    84.818   753.094     0.150
    84.999   756.395     0.150
    85.128   755.922     0.150
    85.161   757.195     0.150
    85.171   753.492     0.150
    85.299   757.492     0.150
    85.302   757.594     0.150
    85.311   756.922     0.150
    85.459   756.594     0.150
    85.673   757.594     0.150
    85.983   758.594     0.150
    86.072   758.594     0.150
    86.318   759.793     0.150
    86.881  1383.594     0.150
    87.405   761.895     0.150
    88.533   770.594     0.150
    89.862   775.992     0.150
    90.716   779.492     0.150
    90.761   781.793     0.150
    90.761     7.602     0.150
    90.893   783.594     0.150
    91.595   783.594     0.150
    91.806   784.594     0.150
    91.890   786.895     0.150
    92.330   786.395     0.150
    92.590   788.895     0.150
    93.544   792.293     0.150
    93.747   795.594     0.150
    93.931   794.094     0.150
    94.181   796.895     0.150
    95.118   801.695     0.150
    95.492   802.594     0.150
    96.012   806.094     0.150
    96.012     6.000     0.150
    96.012    11.000     0.150
    96.048   805.492     0.150
    96.564   808.492     0.150
    96.595   807.895     0.150
    97.193   811.094     0.150
    97.950   813.793     0.150
    97.958   813.793     0.150
    98.233   814.793     0.150
    98.247   815.094     0.150
   104.146   844.895     0.150
   127.389  1144.082     0.150
   127.702  1144.684     0.150
   164.918  1205.094     0.150
   165.784  1204.594     0.150
   171.673  1207.395     0.150
     1.694    43.660     0.150
     2.854    72.160     0.150
     2.796    40.160     0.150
     3.317    48.160     0.150
     4.156    60.160     0.150
     4.568    67.160     0.150
     5.044    74.660     0.150
     7.169   103.160     0.150
     7.169   180.160     0.150
     7.176   104.160     0.150
     8.639   123.660     0.150
     8.889   128.160     0.150
    10.556   148.160     0.150
    15.424   216.160     0.150
    16.354   228.961     0.150
    16.514   229.461     0.150
    19.057   258.961     0.150
    20.751   282.061     0.150
    21.145   280.660     0.150
    21.145   512.160     0.150
    21.145   528.160     0.150
    22.013   293.160     0.150
    22.318   295.660     0.150
    22.446   294.461     0.150
    23.153   303.160     0.150
    23.153   550.160     0.150
    23.271   304.160     0.150
    23.417   304.561     0.150
    24.153   309.660     0.150
    24.081   308.660     0.150
    24.156   309.359     0.150
    24.903   321.359     0.150
    25.163   322.160     0.150
    25.927   327.561     0.150
    25.657   324.859     0.150
    25.657   534.760     0.150
    25.754   327.359     0.150
    26.239   331.859     0.150
    27.623   341.660     0.150
    28.039   346.160     0.150
    28.039   653.160     0.150
    28.039   715.160     0.150
    28.855   353.160     0.150
    29.396   357.461     0.150
    29.483   361.160     0.150
    30.706   368.660     0.150
    30.706   547.160     0.150
    30.706   669.160     0.150
    30.706   775.160     0.150
    31.458   373.961     0.150
    31.458   547.660     0.150
    31.462   374.961     0.150
    31.698   377.160     0.150
    31.756   380.160     0.150
    31.756    13.000     0.150
    31.756   450.160     0.150
    31.756   712.160     0.150
    32.626   387.160     0.150
    33.693   394.160     0.150
    33.693    22.500     0.150
    34.038   397.461     0.150
    34.843   403.859     0.150
    34.843   557.260     0.150
    34.843   404.561     0.150
    34.823   405.160     0.150
    36.064   414.961     0.150
    36.356   419.660     0.150
    36.356   760.160     0.150
    36.371   421.660     0.150
    36.794   421.859     0.150
    38.258   435.641     0.150
    38.366   436.461     0.150
    39.634   447.561     0.150
    40.127   451.660     0.150
    40.127    14.400     0.150
    40.127   990.160     0.150
    40.440   453.400     0.150
    40.738   453.561     0.150
    40.531   454.561     0.150
    40.902   456.561     0.150
    41.047   458.020     0.150
    41.890   465.221     0.150
    42.465   470.199     0.150
    44.107   481.061     0.150
    44.927   487.859     0.150
    44.658   488.160     0.150
    45.065   492.660     0.150
    45.651   498.160     0.150
    46.247   498.461     0.150
    46.059   498.660     0.150
    46.059    14.000     0.150
    46.059   609.160     0.150
    46.059   822.660     0.150
    46.059   829.160     0.150
    46.059   904.160     0.150
    46.059  1088.160     0.150
    46.850   503.961     0.150
    48.183   515.359     0.150
    49.187   524.660     0.150
    49.757   527.260     0.150
    49.897   528.961     0.150
    50.249   531.160     0.150
    50.908   536.061     0.150
    51.440   539.160     0.150
    51.440   539.359     0.150
    51.747   543.660     0.150
    51.747   661.160     0.150
    51.747   848.160     0.150
    52.098   542.260     0.150
    52.098   614.160     0.150
    52.443   547.961     0.150
    52.028   544.160     0.150
    53.928   559.160     0.150
    60.686   605.660     0.150
    60.686  1106.160     0.150
    63.369   621.660     0.150
    63.631   626.160     0.150
    64.723   635.160     0.150
    64.723   635.359     0.150
    64.902   629.359     0.150
    66.470   644.160     0.150
    67.225   648.660     0.150
    68.214   653.609     0.150
    68.214   654.160     0.150
    76.011   702.160     0.150
    76.011  1288.160     0.150
    76.011   881.160     0.150
    76.011  1320.160     0.150
    76.603   704.359     0.150
    76.662   704.359     0.150
    76.607   704.160     0.150
    76.607    22.000     0.150
    76.729   705.461     0.150
    76.723   706.412     0.150
    76.870   707.061     0.150
    76.877   706.221     0.150
    76.877   706.359     0.150
    77.809   709.660     0.150
    77.788   712.217     0.150
    78.300   715.291     0.150
    79.297   717.160     0.150
    79.297   717.461     0.150
    79.795   720.260     0.150
    80.262   724.160     0.150
    80.397   725.609     0.150
    80.553  1328.461     0.150
    80.553   913.660     0.150
    83.104   738.221     0.150
    83.655   741.660     0.150
    83.970   743.660     0.150
    84.809   747.760     0.150
    85.050   748.561     0.150
    85.355   749.859     0.150
    85.931   753.561     0.150
    86.456   755.260     0.150
    86.760   758.660     0.150
    89.482   769.660     0.150
    90.723   775.061     0.150
    91.232   777.961     0.150
    91.228   781.160     0.150
    91.972   781.359     0.150
    91.990   780.859     0.150
    94.606   794.961     0.150
    94.904   794.660     0.150
    95.475   799.660     0.150
    95.506   797.961     0.150
    95.506   800.359     0.150
    95.506   801.760     0.150
    95.506   798.359     0.150
    96.674   804.260     0.150
   104.339   837.859     0.150
   119.688  1124.160     0.150
   123.169  1130.359     0.150
   124.115  1132.660     0.150
   124.917  1132.359     0.150
   126.418  1136.961     0.150
   166.575  1200.359     0.150
   166.657  1200.061     0.150
   166.657  1265.260     0.150
   170.395  1201.760     0.150
     0.679    11.656     0.150
     0.825    15.656     0.150
     1.110    20.656     0.150
     1.375    25.156     0.150
     1.916    30.656     0.150
     2.082    35.656     0.150
     2.393    42.156     0.150
     2.451    39.156     0.150
     2.468    40.156     0.150
     2.468    77.656     0.150
     2.604    43.656     0.150
     3.013    49.555     0.150
     3.099    51.156     0.150
     3.264    54.656     0.150
     3.244    55.656     0.150
     3.286    51.656     0.150
     3.286    56.055     0.150
     3.312    53.656     0.150
     4.230    69.656     0.150
     5.110    81.656     0.150
     5.126    79.656     0.150
     5.520    96.656     0.150
     7.449   111.656     0.150
    16.932   242.258     0.150
    20.967   284.055     0.150
    22.362   301.656     0.150
    22.362   545.656     0.150
    22.450   299.156     0.150
    23.670   314.457     0.150
    23.670   567.656     0.150
    24.037   313.555     0.150
    25.811   336.055     0.150
    26.749   339.055     0.150
    27.856   349.156     0.150
    28.264   353.055     0.150
    28.488   355.656     0.150
    28.659   358.355     0.150
    30.600   376.055     0.150
    31.440   380.355     0.150
    31.440   554.855     0.150
    31.451   379.555     0.150
    31.390   381.258     0.150
    32.655   392.656     0.150
    34.370   406.656     0.150
    34.880   411.355     0.150
    34.880   564.656     0.150
    34.880   410.957     0.150
    34.903   411.156     0.150
    34.903   747.656     0.150
    36.336   424.457     0.150
    37.047   431.656     0.150
    37.292   433.055     0.150
    39.018   449.047     0.150
    39.139   449.105     0.150
    40.398   460.426     0.150
    40.983   462.656     0.150
    41.813   470.305     0.150
    43.238   482.387     0.150
    43.954   488.676     0.150
    44.167   488.855     0.150
    44.445   492.078     0.150
    44.853   494.355     0.150
    45.119   497.855     0.150
    45.508   499.656     0.150
    45.523   499.336     0.150
    45.635   503.656     0.150
    46.082   502.855     0.150
    46.449   508.656     0.150
    49.577   531.457     0.150
    50.067   535.758     0.150
    51.791   548.555     0.150
    52.737   556.355     0.150
    54.014   563.957     0.150
    68.531   661.457     0.150
    79.463   723.848     0.150
    84.644   754.758     0.150
    85.278   756.355     0.150
    91.066   784.266     0.150
   118.650  1129.258     0.150
   146.718  1182.457     0.150
   163.933  1205.656     0.150
   163.933  1257.258     0.150
     0.669    11.855     0.150
     0.862    15.355     0.150
     1.072    19.855     0.150
     1.323    24.855     0.150
     1.868    30.855     0.150
     1.868    55.855     0.150
     2.030    35.855     0.150
     2.376    40.855     0.150
     2.395    39.855     0.150
     2.480    40.355     0.150
     2.591    43.855     0.150
     2.999    48.855     0.150
     3.064    51.355     0.150
     3.271    53.855     0.150
     4.188    78.855     0.150
     7.462   112.855     0.150
    24.009   314.156     0.150
    28.223   352.457     0.150
    31.411   379.855     0.150
    31.411   555.555     0.150
    31.422   379.855     0.150
    31.430   383.355     0.150
    34.849   411.457     0.150
    34.849   564.055     0.150
    34.849   411.055     0.150
    44.827   494.355     0.150
    50.102   536.457     0.150
    50.102   613.957     0.150
    51.794   548.656     0.150
    54.033   567.055     0.150
    54.033   631.555     0.150
   146.694  1182.754     0.150
     0.598    10.746     0.150
     1.011    18.746     0.150
     1.041    18.846     0.150
     1.041    36.746     0.150
     1.364    25.746     0.150
     1.364    42.746     0.150
     1.685    28.746     0.150
     1.932    60.547     0.150
     2.064    34.746     0.150
     2.064    59.746     0.150
     2.167    34.746     0.150
     2.167    59.746     0.150
     2.765    45.746     0.150
     2.776    46.746     0.150
     2.776    83.547     0.150
     2.736    45.146     0.150
     2.959    47.246     0.150
     3.123    53.945     0.150
    23.586   308.646     0.150
    26.558   338.945     0.150
    28.765   357.746     0.150
    31.081   378.256     0.150
    31.100   377.746     0.150
    31.926   384.746     0.150
    34.406   407.096     0.150
    37.011   430.746     0.150
    44.056   487.877     0.150
    44.415   490.047     0.150
    44.541   491.736     0.150
    45.616   499.877     0.150
    54.705   569.566     0.150
    55.077   572.646     0.150
    64.474   635.746     0.150
    80.459   728.881     0.150
    85.225   755.195     0.150
    89.637   775.369     0.150
    94.741   799.797     0.150
   146.290  1179.932     0.150
     1.244    22.732     0.150
     1.360    26.433     0.150
     1.360    44.433     0.150
     1.839    31.232     0.150
     1.868    32.832     0.150
     2.479    41.832     0.150
     3.455    57.232     0.150
     3.240    60.732     0.150
     3.979    60.732     0.150
     8.117   121.232     0.150
    17.526   251.032     0.150
    23.292   306.832     0.150
    23.121   307.532     0.150
    23.166   310.732     0.150
    23.752   312.982     0.150
    24.241   319.532     0.150
    26.309   339.332     0.150
    26.860   342.032     0.150
    26.860   543.683     0.150
    27.487   344.933     0.150
    27.870   350.536     0.150
    28.544   356.133     0.150
    29.093   362.032     0.150
    31.361   382.343     0.150
    31.380   381.232     0.150
    32.167   389.032     0.150
    32.729   395.232     0.150
    34.122   403.933     0.150
    34.122    12.450     0.150
    34.122   561.832     0.150
    34.122   403.832     0.150
    35.140   414.832     0.150
    35.318   416.232     0.150
    36.069   421.582     0.150
    37.333   434.032     0.150
    37.529   436.832     0.150
    37.622   436.433     0.150
    39.832   455.054     0.150
    40.207   455.433     0.150
    39.929  1052.232     0.150
    40.173   457.933     0.150
    40.173     9.500     0.150
    44.116   488.433     0.150
    44.116   590.782     0.150
    44.374   493.832     0.150
    44.859   494.572     0.150
    45.547   502.393     0.150
    46.115   505.433     0.150
    45.935   505.072     0.150
    47.081   514.232     0.150
    50.171   535.133     0.150
    50.171     9.399     0.150
    54.710   570.107     0.150
    54.710     9.750     0.150
    57.937   592.782     0.150
    64.459   635.232     0.150
    68.195   660.832     0.150
    69.194   665.232     0.150
    77.140   716.232     0.150
    77.750   717.542     0.150
    77.997   719.832     0.150
    77.997     9.801     0.150
    79.639   726.742     0.150
    80.569   732.052     0.150
    81.390   736.732     0.150
    81.407   736.032     0.150
    84.459   753.021     0.150
    84.459    10.725     0.150
    85.972   758.758     0.150
    89.376   775.257     0.150
    92.886   791.482     0.150
    96.547   809.558     0.150
   119.146  1129.623     0.150
   145.988  1180.205     0.150
   163.160  1203.328     0.150
   163.160  1253.176     0.150
   165.465  1206.945     0.150
     0.596    10.135     0.150
     0.704    13.336     0.150
     0.911    17.035     0.150
     0.911    30.135     0.150
     0.936    17.535     0.150
     0.936    32.336     0.150
     1.363    22.436     0.150
     1.592    27.436     0.150
     1.592    49.736     0.150
     1.870    30.135     0.150
     2.260    35.936     0.150
     2.639    42.936     0.150
     2.639    76.736     0.150
     2.638    43.436     0.150
     2.814    46.035     0.150
     2.849    84.436     0.150
     2.760    45.035     0.150
     3.022    49.436     0.150
     3.915    58.736     0.150
     5.309    83.035     0.150
    21.427   288.535     0.150
    22.791   302.936     0.150
    22.789   303.336     0.150
    23.820   313.535     0.150
    26.451   339.205     0.150
    27.173   341.436     0.150
    27.757   346.535     0.150
    27.639   347.246     0.150
    28.153   350.936     0.150
    28.676   355.936     0.150
    29.913   367.936     0.150
    31.049   377.436     0.150
    31.894   384.936     0.150
    32.327   389.436     0.150
    32.327   706.936     0.150
    33.041   394.936     0.150
    33.854   401.236     0.150
    34.460   404.836     0.150
    34.896   411.135     0.150
    34.913   411.236     0.150
    36.931   428.836     0.150
    37.103   431.936     0.150
    39.019   446.486     0.150
    39.130   447.725     0.150
    40.492   455.336     0.150
    40.396   458.246     0.150
    40.736   461.686     0.150
    42.618   475.945     0.150
    42.652   476.846     0.150
    44.478   489.535     0.150
    44.478   883.537     0.150
    45.461   498.936     0.150
    46.458   506.635     0.150
    46.671   507.936     0.150
    50.553   537.836     0.150
    52.443   554.236     0.150
    53.967   563.756     0.150
    54.612   568.436     0.150
    55.609   574.535     0.150
    57.895   591.115     0.150
    61.273   613.436     0.150
    64.372   635.936     0.150
    68.791   662.076     0.150
    73.296   688.836     0.150
    76.401   708.465     0.150
    77.573   715.625     0.150
    77.650   715.486     0.150
    79.573   724.436     0.150
    85.237   754.285     0.150
    87.750   768.135     0.150
    92.188   788.236     0.150
    92.502   787.936     0.150
    94.757   799.037     0.150
    95.195   801.936     0.150
    96.100   805.936     0.150
    97.289   811.736     0.150
    97.289   829.936     0.150
    97.289   811.736     0.150
    97.289   829.936     0.150
   127.203  1143.076     0.150
   127.382  1143.955     0.150
   127.515  1143.596     0.150
     0.586     9.938     0.150
     0.654    12.738     0.150
     0.956    17.238     0.150
     0.989    17.637     0.150
     0.989    32.238     0.150
     1.345    22.035     0.150
     1.362    25.035     0.150
     1.633    51.238     0.150
     1.893    29.738     0.150
     2.211    35.137     0.150
     2.628    41.738     0.150
     2.628    76.336     0.150
     2.689    43.637     0.150
     2.689    76.738     0.150
     2.788    44.238     0.150
     2.788    83.137     0.150
     2.815    44.938     0.150
     3.074    49.637     0.150
     3.693    60.137     0.150
     3.934    57.836     0.150
     4.695    72.836     0.150
    22.821   303.738     0.150
    22.830   303.137     0.150
    23.869   314.535     0.150
    26.504   336.809     0.150
    27.205   341.637     0.150
    27.734   346.238     0.150
    28.195   350.637     0.150
    28.724   356.137     0.150
    29.949   367.137     0.150
    31.081   377.137     0.150
    31.917   384.137     0.150
    32.371   389.137     0.150
    33.076   395.438     0.150
    33.875   400.137     0.150
    34.427   406.836     0.150
    34.930   411.035     0.150
    34.949   410.637     0.150
    36.975   429.738     0.150
    37.155   432.137     0.150
    39.881   454.707     0.150
    40.449   458.406     0.150
    40.789   462.125     0.150
    41.255   465.188     0.150
    42.671   476.965     0.150
    44.441   489.336     0.150
    45.207   495.836     0.150
    46.717   508.637     0.150
    46.922   509.238     0.150
    48.035   517.137     0.150
    48.627   521.336     0.150
    52.254   549.098     0.150
    52.494   552.637     0.150
    52.531   552.137     0.150
    52.531   617.738     0.150
    53.369   555.836     0.150
    54.016   563.617     0.150
    61.318   614.336     0.150
    61.846   615.637     0.150
    64.307   632.336     0.150
    64.424   635.637     0.150
    67.839   657.137     0.150
    68.836   662.137     0.150
    77.623   713.738     0.150
    77.623    10.699     0.150
    77.650   714.816     0.150
    81.045   733.137     0.150
    85.239   754.066     0.150
     0.710    13.023     0.150
     0.909    16.824     0.150
     0.922    17.426     0.150
     1.594    27.625     0.150
     1.594    49.727     0.150
     1.879    30.023     0.150
     2.277    35.625     0.150
     2.657    42.625     0.150
     2.657    73.824     0.150
     2.622    43.227     0.150
     2.834    45.023     0.150
     2.834    84.227     0.150
     2.838    43.227     0.150
     2.741    45.625     0.150
     2.842    48.625     0.150
    26.439   761.824     0.150
    34.480   406.324     0.150
    34.480   560.125     0.150
    36.912   429.426     0.150
    39.116   446.984     0.150
    39.521   448.941     0.150
    40.382   457.484     0.150
    40.741   460.023     0.150
    42.605   475.863     0.150
    42.638   475.645     0.150
    44.498   489.727     0.150
    80.464   728.965     0.150
    84.078   748.562     0.150
    85.563   756.000     0.150
    89.699   774.828     0.150
    94.741   799.516     0.150
   119.216  1128.258     0.150
   146.374  1179.676     0.150
     0.442     8.293     0.150
     0.442    15.625     0.150
     0.956    16.254     0.150
     1.190    21.074     0.150
     1.190    37.523     0.150
     1.668    26.754     0.150
     1.668    48.113     0.150
     2.020    33.492     0.150
     2.225    35.766     0.150
     2.309    36.223     0.150
     2.309    63.703     0.150
     2.787    44.805     0.150
     3.189    50.344     0.150
    24.842   320.184     0.150
    26.702   339.652     0.150
    27.362   343.473     0.150
    27.993   347.480     0.150
    31.167   376.066     0.150
    35.086   413.055     0.150
    36.466   421.605     0.150
    39.331   448.473     0.150
    40.921   462.652     0.150
    41.217   464.453     0.150
    41.391   465.652     0.150
    41.485   466.555     0.150
    44.063   485.355     0.150
    44.581   490.605     0.150
    48.164   518.254     0.150
    51.521   544.555     0.150
    51.521   617.152     0.150
    51.972   546.254     0.150
    55.609   573.652     0.150
    61.571   613.355     0.150
    68.786   661.043     0.150
    77.275   712.754     0.150
    80.098   726.004     0.150
    84.874   752.254     0.150
    85.541   755.047     0.150
    85.788   757.176     0.150
    88.123   770.391     0.150
    89.875   775.016     0.150
    94.385   798.051     0.150
     0.540    10.586     0.150
     0.540    19.926     0.150
     0.666    12.355     0.150
     0.666    23.117     0.150
     1.202    36.285     0.150
     1.211    22.645     0.150
     1.211    40.734     0.150
     1.715    28.355     0.150
     1.953    33.125     0.150
     1.953    58.934     0.150
     2.248    39.004     0.150
    25.371   327.406     0.150
    31.373   379.316     0.150
    34.735   409.207     0.150
    38.140   439.406     0.150
    39.413   450.105     0.150
    39.498   449.629     0.150
    40.038   455.004     0.150
    40.217   456.406     0.150
    41.625   468.305     0.150
    41.668   468.605     0.150
    44.861   491.547     0.150
    50.843   539.766     0.150
    53.817   561.840     0.150
    60.653   610.676     0.150
    60.738   610.484     0.150
    83.730   747.105     0.150
    85.060   753.824     0.150
    92.016   786.527     0.150
     0.292     7.314     0.150
     0.292    14.334     0.150
     0.864    14.965     0.150
     0.864    27.785     0.150
     0.866    14.615     0.150
     1.175    20.975     0.150
     1.264    19.686     0.150
     1.308    22.775     0.150
     1.557    24.805     0.150
     1.557    48.805     0.150
     1.855    30.436     0.150
     2.227    34.984     0.150
     2.333    34.805     0.150
     2.565    40.715     0.150
     2.621    43.035     0.150
     2.678    77.445     0.150
     2.870    45.314     0.150
     2.949    44.795     0.150
     2.949    74.145     0.150
    31.105   372.988     0.150
    34.522   403.941     0.150
    34.824   409.805     0.150
    44.544   488.230     0.150
    51.428   542.805     0.150
    55.537   572.084     0.150
    61.129   610.959     0.150
    61.201   611.225     0.150
    61.272   611.266     0.150
    84.032   745.926     0.150
    85.512   752.955     0.150
    94.733   795.061     0.150
     0.316     7.727     0.150
     0.831    15.137     0.150
     0.831    26.906     0.150
     0.839    15.594     0.150
     0.839    27.395     0.150
     1.282    19.875     0.150
     1.180    21.004     0.150
     1.402    21.977     0.150
     1.323    23.547     0.150
     1.323    38.246     0.150
     1.522    28.246     0.150
     1.833    29.004     0.150
     1.833    50.156     0.150
     1.876    30.887     0.150
     2.198    35.414     0.150
     2.383    36.914     0.150
     2.663    41.914     0.150
     2.663    75.094     0.150
     2.545    41.547     0.150
     2.629    41.766     0.150
     2.866    46.066     0.150
     2.687    42.457     0.150
     2.687    76.066     0.150
     2.915    45.746     0.150
     2.927    45.617     0.150
     2.927    85.926     0.150
     3.605    55.125     0.150
     3.739    56.844     0.150
     3.744    58.125     0.150
     4.348    66.266     0.150
     4.528    68.164     0.150
     4.892    73.215     0.150
     5.224    79.707     0.150
     5.342    78.977     0.150
     5.584    83.957     0.150
     5.803    87.727     0.150
     5.871    86.824     0.150
     7.567   111.094     0.150
    15.332   212.164     0.150
    17.214   242.395     0.150
    22.622   299.645     0.150
    24.763   319.746     0.150
    26.353   333.625     0.150
    26.353   333.988     0.150
    27.801   345.281     0.150
    28.588   353.945     0.150
    29.250   356.547     0.150
    29.442   362.027     0.150
    31.102   373.246     0.150
    31.107   374.031     0.150
    31.111   374.344     0.150
    30.970   374.785     0.150
    30.990   374.945     0.150
    33.814   400.445     0.150
    33.814   722.445     0.150
    34.523   405.145     0.150
    34.523   405.047     0.150
    34.799   408.645     0.150
    36.561   423.219     0.150
    37.008   427.836     0.150
    37.492   431.844     0.150
    39.492   447.727     0.150
    39.680   448.145     0.150
    40.639   458.445     0.150
    40.694   458.547     0.150
    40.694   457.887     0.150
    40.930   461.246     0.150
    41.106   461.746     0.150
    41.198   463.246     0.150
    44.101   484.445     0.150
    44.548   489.047     0.150
    44.548   488.270     0.150
    46.522   505.246     0.150
    51.414   542.969     0.150
    52.198   546.047     0.150
    52.198     8.500     0.150
    53.347   556.344     0.150
    53.347   554.926     0.150
    53.793   562.285     0.150
    53.876   561.926     0.150
    54.217   564.395     0.150
    54.357   565.625     0.150
    54.479   565.695     0.150
    54.751   568.016     0.150
    54.891   569.496     0.150
    55.022   570.273     0.150
    55.523   571.547     0.150
    55.525   572.746     0.150
    55.525   572.617     0.150
    57.430   586.344     0.150
    61.189   611.645     0.150
    61.261   611.945     0.150
    64.285   631.145     0.150
    64.285   630.547     0.150
    66.167   644.645     0.150
    67.713   654.445     0.150
    68.709   659.047     0.150
    68.709   682.344     0.150
    68.709   810.547     0.150
    68.709  1201.844     0.150
    71.796   677.246     0.150
    76.009   705.246     0.150
    76.043   706.645     0.150
    77.480   713.547     0.150
    79.623   722.914     0.150
    80.480   727.594     0.150
    80.914   729.746     0.150
    80.914  1343.246     0.150
    81.447   733.746     0.150
    81.447   740.344     0.150
    84.028   747.070     0.150
    85.231   753.172     0.150
    85.231   752.805     0.150
    85.256   752.246     0.150
    85.503   753.969     0.150
    87.663   766.734     0.150
    89.732   773.195     0.150
    92.426   786.297     0.150
    94.755   798.090     0.150
    96.047   804.734     0.150
    98.754   817.055     0.150
   110.571   867.645     0.150
   112.599   877.047     0.150
   165.982  1203.445     0.150
     0.171     3.783     0.150
     0.171     7.504     0.150
     0.858    14.225     0.150
     0.776    14.664     0.150
     0.776    27.895     0.150
     0.891    15.744     0.150
     0.891    29.623     0.150
     1.085    20.113     0.150
     1.085    35.863     0.150
     1.454    24.623     0.150
     1.454    46.504     0.150
     1.550    28.574     0.150
     1.825    30.793     0.150
     1.825    53.613     0.150
     1.792    32.264     0.150
     2.211    36.814     0.150
     2.207    36.814     0.150
     2.207    62.475     0.150
     2.367    40.064     0.150
     2.608    41.994     0.150
     2.608    71.104     0.150
     2.770    44.264     0.150
     2.797    45.264     0.150
     3.344    54.395     0.150
    14.938   211.904     0.150
    24.463   319.225     0.150
    26.289   541.863     0.150
    28.218   351.150     0.150
    31.479   379.547     0.150
    31.479   553.322     0.150
    34.905   410.713     0.150
    34.905   562.514     0.150
    40.325   457.424     0.150
    44.909   493.664     0.150
    51.133   542.539     0.150
    53.917   560.164     0.150
    55.229   572.004     0.150
    55.229   689.363     0.150
    60.823   610.818     0.150
    61.565   615.564     0.150
    80.060   727.014     0.150
    84.388   750.455     0.150
    84.804   752.213     0.150
    94.331   797.408     0.150
   146.782  1181.414     0.150
     0.347     6.695     0.150
     0.347    12.484     0.150
     0.842    15.836     0.150
     0.842    28.953     0.150
     1.011    19.297     0.150
     1.011    32.297     0.150
     1.192    21.586     0.150
     1.492    26.695     0.150
     1.492    47.016     0.150
     1.681    28.945     0.150
     1.681    49.047     0.150
     1.891    32.391     0.150
     1.891    58.578     0.150
     1.985    34.141     0.150
     1.985    60.680     0.150
     2.078    35.797     0.150
     2.114    35.477     0.150
     2.114    67.266     0.150
     2.233    37.445     0.150
     2.233    66.078     0.150
     2.368    39.984     0.150
     2.368    70.445     0.150
     2.569    41.594     0.150
     2.777    45.500     0.150
     2.777    80.141     0.150
     2.941    48.336     0.150
     2.941    83.609     0.150
     3.050    49.789     0.150
     3.050    86.180     0.150
     3.064    48.930     0.150
     3.064    85.656     0.150
     3.162    52.969     0.150
     3.162    93.023     0.150
     3.548    66.727     0.150
     3.571    55.609     0.150
     3.744    59.453     0.150
     3.744   102.906     0.150
     4.036    68.797     0.150
     4.036   110.039     0.150
     4.238    65.484     0.150
     4.238   114.820     0.150
     4.666    71.117     0.150
     4.666   122.484     0.150
     5.062    87.711     0.150
     5.227    81.727     0.150
     6.247    95.250     0.150
     6.247   165.695     0.150
     8.667   127.695     0.150
    16.380   227.898     0.150
    16.380   228.758     0.150
    17.214   246.398     0.150
    21.149   287.195     0.150
    21.149   515.797     0.150
    22.330   300.297     0.150
    22.452   298.297     0.150
    23.174   308.195     0.150
    23.174   558.094     0.150
    23.174   601.594     0.150
    23.447   311.594     0.150
    23.859   312.984     0.150
    24.189   316.297     0.150
    24.291   317.023     0.150
    25.187   325.797     0.150
    25.329   326.297     0.150
    25.686   331.398     0.150
    27.638   348.094     0.150
    27.971   349.500     0.150
    27.971   349.258     0.150
    29.383   364.594     0.150
    30.692   374.820     0.150
    30.712   375.094     0.150
    31.443   379.445     0.150
    31.448   379.359     0.150
    31.452   379.898     0.150
    31.772   386.297     0.150
    31.772   452.398     0.150
    31.772   693.797     0.150
    31.772   805.898     0.150
    32.635   393.195     0.150
    33.691   402.797     0.150
    33.691   723.797     0.150
    34.835   409.500     0.150
    34.835   409.648     0.150
    34.835   562.344     0.150
    34.819   411.094     0.150
    34.819   411.219     0.150
    36.373   425.594     0.150
    36.395   425.477     0.150
    37.062   427.875     0.150
    37.062   429.914     0.150
    39.298   448.414     0.150
    40.290   457.594     0.150
    40.357   457.500     0.150
    40.467   459.094     0.150
    40.530   460.016     0.150
    40.557   459.898     0.150
    40.735   459.000     0.150
    41.074   463.797     0.150
    41.880   470.898     0.150
    43.178   480.500     0.150
    43.749   485.000     0.150
    43.749   591.000     0.150
    44.688   494.297     0.150
    44.765   493.297     0.150
    44.916   494.000     0.150
    44.916   494.320     0.150
    46.077   505.195     0.150
    46.077   600.898     0.150
    46.077   613.398     0.150
    46.077   907.797     0.150
    46.725   506.594     0.150
    46.725  1120.695     0.150
    50.910   541.797     0.150
    51.164   542.094     0.150
    51.770   549.094     0.150
    52.096   549.000     0.150
    53.229   560.867     0.150
    53.320   560.414     0.150
    53.793   564.227     0.150
    53.812   563.125     0.150
    53.921   564.656     0.150
    53.950   565.297     0.150
    54.194   566.008     0.150
    54.324   568.594     0.150
    54.459   568.719     0.150
    55.042   571.453     0.150
    55.092   570.297     0.150
    60.703   610.680     0.150
    61.366   613.375     0.150
    61.666   616.195     0.150
    64.336   633.797     0.150
    68.231   659.398     0.150
    68.231   683.297     0.150
    68.231   809.398     0.150
    68.231  1199.000     0.150
    68.231   658.984     0.150
    69.904   671.859     0.150
    70.361   673.648     0.150
    75.834   706.594     0.150
    76.034   707.297     0.150
    76.723   708.695     0.150
    76.756   711.102     0.150
    76.899   712.594     0.150
    77.458   715.680     0.150
    77.853   718.422     0.150
    77.870   718.000     0.150
    78.609   722.992     0.150
    79.573   728.430     0.150
    79.797   726.391     0.150
    80.415   730.398     0.150
    80.415   737.500     0.150
    80.415  1334.500     0.150
    81.028   735.805     0.150
    82.351   743.445     0.150
    83.108   742.094     0.150
    83.136   747.312     0.150
    83.665   747.672     0.150
    83.956   749.539     0.150
    83.978   749.750     0.150
    84.823   753.297     0.150
    85.065   754.625     0.150
    85.343   756.016     0.150
    85.358   755.273     0.150
    87.004   765.312     0.150
    87.004   765.977     0.150
    89.958   776.844     0.150
    92.004   786.875     0.150
    94.891   801.344     0.150
    95.525   804.508     0.150
     1.007    19.508     0.150
     1.007    34.922     0.150
     1.016    19.461     0.150
     1.016    32.602     0.150
     1.102    20.531     0.150
     1.102    35.180     0.150
     1.275    23.391     0.150
     1.275    40.828     0.150
     1.489    27.242     0.150
     1.489    48.609     0.150
     1.722    28.531     0.150
     1.722    50.352     0.150
     2.253    37.180     0.150
     2.383    40.070     0.150
     2.383    73.828     0.150
     2.489    41.062     0.150
     2.489    71.828     0.150
     2.683    44.438     0.150
     2.683    74.828     0.150
     2.829    45.312     0.150
     2.829    78.438     0.150
     3.019    88.234     0.150
     3.118    50.219     0.150
     3.086    49.320     0.150
     3.389    53.312     0.150
     3.715    58.602     0.150
     3.934    67.555     0.150
     4.048    62.969     0.150
     4.048   109.203     0.150
     4.508    69.812     0.150
     5.127    78.258     0.150
     5.649    85.281     0.150
     5.639    85.750     0.150
     5.917    91.391     0.150
     7.458   112.531     0.150
    26.605   339.609     0.150
    26.605   339.508     0.150
    28.070   350.000     0.150
    31.255   376.969     0.150
    31.260   377.398     0.150
    31.260   552.719     0.150
    34.697   408.664     0.150
    34.697   561.914     0.150
    36.822   428.508     0.150
    36.822   770.008     0.150
    40.549   458.688     0.150
    40.733   460.555     0.150
    41.114   464.008     0.150
    41.288   465.508     0.150
    41.382   466.109     0.150
    41.894   470.008     0.150
    42.708   477.414     0.150
    42.735   477.711     0.150
    44.678   492.258     0.150
    51.416   544.664     0.150
    51.416   617.836     0.150
    51.900   546.672     0.150
    61.099   612.875     0.150
    61.099   655.398     0.150
    61.171   613.469     0.150
    80.064   727.211     0.150
    83.146   745.945     0.150
    84.697   752.859     0.150
    85.439   755.508     0.150
    85.684   758.641     0.150
    89.959   777.773     0.150
    94.346   798.156     0.150
    96.063   805.422     0.150
     0.864    15.854     0.150
     0.864    27.755     0.150
     0.865    16.124     0.150
     0.865    28.074     0.150
     1.262    21.624     0.150
     1.179    21.975     0.150
     1.312    23.984     0.150
     1.312    41.984     0.150
     1.406    22.604     0.150
     1.406    42.314     0.150
     1.554    26.314     0.150
     1.554    48.814     0.150
     1.859    31.685     0.150
     1.859    56.545     0.150
     2.007    33.435     0.150
     2.331    36.314     0.150
     2.228    36.185     0.150
     2.405    38.135     0.150
     2.405    66.705     0.150
     2.567    41.324     0.150
     2.567    73.135     0.150
     2.673    42.515     0.150
     2.673    77.234     0.150
     2.625    42.734     0.150
     2.696    43.265     0.150
     2.696    77.385     0.150
     2.866    44.994     0.150
     2.787    45.814     0.150
     2.965    47.034     0.150
     2.965    81.725     0.150
     2.951    46.055     0.150
     2.951    88.574     0.150
     3.279    51.004     0.150
     3.626    56.254     0.150
     3.626   100.174     0.150
     4.920    74.145     0.150
     5.240    80.354     0.150
     6.671   101.404     0.150
    17.030   239.814     0.150
    17.030   424.914     0.150
    17.203   241.664     0.150
    22.732   300.914     0.150
    22.727   301.314     0.150
    23.708   309.715     0.150
    23.749   312.414     0.150
    24.102   314.814     0.150
    24.777   321.395     0.150
    25.812   332.314     0.150
    25.812   595.014     0.150
    25.812   663.914     0.150
    26.383   335.818     0.150
    27.804   346.801     0.150
    28.086   350.914     0.150
    28.606   354.514     0.150
    31.096   375.264     0.150
    30.993   375.615     0.150
    31.101   375.199     0.150
    31.105   375.014     0.150
    31.847   383.414     0.150
    32.259   389.215     0.150
    32.980   394.014     0.150
    32.980   465.414     0.150
    34.519   405.914     0.150
    34.825   408.814     0.150
    34.874   409.514     0.150
    34.874   561.115     0.150
    34.874   736.014     0.150
    34.874   766.314     0.150
    34.874   779.615     0.150
    34.874   785.514     0.150
    34.874   409.285     0.150
    36.862   426.615     0.150
    37.032   429.404     0.150
    39.490   448.025     0.150
    39.672   449.414     0.150
    40.880   460.314     0.150
    40.956   461.115     0.150
    44.108   484.615     0.150
    44.108   589.414     0.150
    44.540   490.115     0.150
    45.111   494.115     0.150
    46.601   507.314     0.150
    46.601   617.814     0.150
    51.431   543.840     0.150
    51.431   616.789     0.150
    51.431   543.414     0.150
    52.192   546.414     0.150
    52.192   546.664     0.150
    53.813   562.404     0.150
    53.896   562.615     0.150
    54.237   565.434     0.150
    54.377   566.484     0.150
    54.499   566.604     0.150
    54.770   568.664     0.150
    54.911   571.234     0.150
    55.042   570.834     0.150
    55.534   571.115     0.150
    55.540   572.215     0.150
    55.540   572.885     0.150
    57.450   586.814     0.150
    57.886   589.934     0.150
    60.682   608.314     0.150
    61.132   612.377     0.150
    61.204   612.514     0.150
    61.275   611.814     0.150
    61.275   612.385     0.150
    66.185   645.115     0.150
    68.723   660.514     0.150
    68.723   684.414     0.150
    68.723   812.414     0.150
    68.723  1202.715     0.150
    76.302   707.615     0.150
    76.530   708.619     0.150
    77.501   714.115     0.150
    77.501   714.414     0.150
    78.148   717.381     0.150
    78.549   720.025     0.150
    78.574   720.053     0.150
    79.293   724.600     0.150
    79.604   724.014     0.150
    79.590   724.115     0.150
    79.668    19.301     0.150
    79.668  1342.414     0.150
    79.668  1633.215     0.150
    79.934   726.014     0.150
    79.934     9.900     0.150
    80.046   724.314     0.150
    80.276   730.463     0.150
    80.462   728.365     0.150
    80.930   731.314     0.150
    80.930   731.125     0.150
    81.068   733.785     0.150
    83.477   743.314     0.150
    83.772   746.725     0.150
    83.772    10.750     0.150
    84.035   747.639     0.150
    84.603   751.115     0.150
    84.927   754.059     0.150
    85.108   755.098     0.150
    85.215   752.924     0.150
    85.215    11.201     0.150
    85.515   754.865     0.150
    85.554   756.424     0.150
    85.905   756.539     0.150
    87.696   767.803     0.150
    87.696   767.295     0.150
    92.437   786.115     0.150
    92.437   786.840     0.150
    93.383   792.154     0.150
    94.737   798.660     0.150
    96.064   804.377     0.150
   119.236  1127.064     0.150
   146.417  1176.814     0.150
     0.327     7.875     0.150
     0.827    15.086     0.150
     0.827    26.846     0.150
     0.844    15.326     0.150
     0.844    27.656     0.150
     1.275    20.305     0.150
     1.192    21.465     0.150
     1.390    21.895     0.150
     1.390    41.096     0.150
     1.335    23.025     0.150
     1.335    41.615     0.150
     1.516    26.275     0.150
     1.888    31.225     0.150
     1.888    60.006     0.150
     1.997    32.475     0.150
     1.997    60.975     0.150
     2.201    35.395     0.150
     2.373    37.145     0.150
     2.373    67.035     0.150
     2.652    42.115     0.150
     2.551    40.795     0.150
     2.640    43.145     0.150
     2.640    74.725     0.150
     2.698    43.326     0.150
     2.698    76.475     0.150
     2.855    45.045     0.150
     2.855    90.035     0.150
     2.904    49.975     0.150
     2.929    46.426     0.150
     3.281    50.555     0.150
     3.612    56.135     0.150
     3.741    57.545     0.150
     3.741   102.355     0.150
     3.755    58.336     0.150
     4.354    66.564     0.150
     4.536    71.736     0.150
     4.895    73.545     0.150
     5.233    79.516     0.150
     5.344    79.135     0.150
     5.592    86.338     0.150
     5.810    88.156     0.150
     6.666   101.775     0.150
     6.874   180.635     0.150
     9.202   133.375     0.150
    17.010   237.775     0.150
    21.385   520.375     0.150
    22.727   300.775     0.150
    24.065   313.775     0.150
    24.772   320.305     0.150
    25.795   332.676     0.150
    25.795   598.875     0.150
    26.356   335.525     0.150
    27.618   346.035     0.150
    27.789   347.412     0.150
    31.091   373.666     0.150
    31.097   374.535     0.150
    31.001   374.676     0.150
    32.254   387.975     0.150
    32.254   457.076     0.150
    32.254   698.775     0.150
    32.984   393.076     0.150
    34.512   405.125     0.150
    34.803   409.275     0.150
    34.894   409.975     0.150
    34.894   409.156     0.150
    36.552   422.006     0.150
    36.857   427.076     0.150
    37.014   427.736     0.150
    39.503   448.486     0.150
    39.692   448.975     0.150
    40.884   459.596     0.150
    44.111   483.975     0.150
    44.111   589.576     0.150
    44.538   489.100     0.150
    44.538   488.635     0.150
    45.115   493.076     0.150
    45.115   600.875     0.150
    46.593   507.076     0.150
    46.593   616.775     0.150
    51.010   976.176     0.150
    51.423   542.525     0.150
    51.423   543.375     0.150
    52.210   547.775     0.150
    53.182   557.236     0.150
    53.800   561.666     0.150
    53.883   562.135     0.150
    54.224   564.975     0.150
    54.364   565.955     0.150
    54.486   566.035     0.150
    54.758   568.125     0.150
    54.898   570.025     0.150
    55.029   570.725     0.150
    55.532   571.176     0.150
    55.534   571.965     0.150
    57.918   589.895     0.150
    57.918     9.301     0.150
    61.126   611.863     0.150
    61.198   611.875     0.150
    61.270   611.775     0.150
    61.798   614.375     0.150
    68.718   660.676     0.150
    68.718   684.076     0.150
    68.718   813.275     0.150
    68.718  1204.076     0.150
    68.718   659.895     0.150
    76.276   706.275     0.150
    77.487   713.676     0.150
    77.487   714.086     0.150
    79.591   723.676     0.150
    79.634   723.285     0.150
    80.075   726.375     0.150
    80.492   727.676     0.150
    80.923   730.475     0.150
    80.923   730.705     0.150
    81.050   733.475     0.150
    84.038   746.801     0.150
    84.586   750.773     0.150
    85.243   752.656     0.150
    85.513   754.176     0.150
    85.535   756.105     0.150
    85.895   756.426     0.150
    87.661   767.455     0.150
    92.436   786.951     0.150
    94.766   798.871     0.150
   119.273  1127.275     0.150
   146.414  1176.400     0.150
     0.395     8.172     0.150
     0.714    13.301     0.150
     0.714    23.949     0.150
     0.753    14.199     0.150
     1.060    20.500     0.150
     1.273    21.871     0.150
     1.508    25.410     0.150
     1.508    25.281     0.150
     1.940    32.441     0.150
     1.940    58.641     0.150
     1.906    31.930     0.150
     1.906    58.520     0.150
     1.906    32.922     0.150
     1.906    57.879     0.150
     2.001    32.980     0.150
     2.001    60.172     0.150
     2.001    59.020     0.150
     2.247    37.262     0.150
     2.247    66.469     0.150
     2.502    40.762     0.150
     2.502    73.051     0.150
     2.541    40.539     0.150
     2.541    71.379     0.150
     2.760    46.590     0.150
     2.886    47.500     0.150
     2.859    46.211     0.150
     3.343    52.578     0.150
     3.404    53.020     0.150
     3.404    53.129     0.150
     3.459    53.500     0.150
     3.470    55.270     0.150
     3.470    55.039     0.150
     3.912    60.629     0.150
     3.912    60.520     0.150
     4.154    64.828     0.150
     4.154    64.488     0.150
     4.577    70.219     0.150
     4.620    70.039     0.150
     4.620    69.930     0.150
     4.999    75.250     0.150
     4.999    75.090     0.150
     5.643    86.719     0.150
     5.643    86.512     0.150
     6.436    95.281     0.150
     6.436    95.051     0.150
     6.586   102.910     0.150
     6.586    99.969     0.150
     7.618   116.520     0.150
     7.618   115.820     0.150
     7.909   118.641     0.150
     8.744   127.102     0.150
    16.777   236.500     0.150
    16.777   422.000     0.150
    16.777   236.922     0.150
    16.953   241.801     0.150
    17.495   245.852     0.150
    21.518   291.500     0.150
    22.740   303.000     0.150
    22.837   572.000     0.150
    23.591   311.301     0.150
    23.591   563.000     0.150
    23.805   312.551     0.150
    24.232   317.199     0.150
    24.232   317.199     0.150
    24.711   320.070     0.150
    25.593   330.301     0.150
    25.593   597.500     0.150
    26.042   333.941     0.150
    27.214   341.801     0.150
    27.616   347.910     0.150
    28.055   351.000     0.150
    28.478   355.500     0.150
    29.600   363.277     0.150
    30.949   373.680     0.150
    31.040   375.301     0.150
    31.045   375.633     0.150
    31.078   378.398     0.150
    31.098   378.500     0.150
    31.098   685.500     0.150
    32.192   389.500     0.150
    33.036   399.500     0.150
    33.036   559.500     0.150
    33.036   715.801     0.150
    33.036   733.500     0.150
    34.438   406.551     0.150
    35.130   413.500     0.150
    35.130   491.500     0.150
    35.130   741.000     0.150
    35.130   786.000     0.150
    35.130   792.301     0.150
    35.130  1026.500     0.150
    35.130   412.379     0.150
    36.793   428.500     0.150
    36.793   516.000     0.150
    36.793   772.500     0.150
    36.793   790.500     0.150
    36.798   430.000     0.150
    36.798   429.602     0.150
    37.834   436.602     0.150
    39.658   452.000     0.150
    40.049   456.199     0.150
    40.391   458.000     0.150
    40.677   460.699     0.150
    40.757   460.699     0.150
    40.854   462.301     0.150
    40.932   462.398     0.150
    40.944   463.000     0.150
    41.461   467.000     0.150
    42.265   474.000     0.150
    42.876   479.875     0.150
    44.153   487.898     0.150
    44.153   594.801     0.150
    44.508   492.148     0.150
    44.508   488.910     0.150
    45.012   497.000     0.150
    46.006   503.801     0.150
    46.498   510.500     0.150
    46.498   605.000     0.150
    46.498   917.000     0.150
    46.498   934.000     0.150
    47.640   516.102     0.150
    48.693   522.301     0.150
    51.331   544.398     0.150
    52.423   550.602     0.150
    54.229   565.352     0.150
    54.376   567.398     0.150
    54.376   567.180     0.150
    55.462   574.602     0.150
    55.509   573.500     0.150
    61.051   613.238     0.150
    61.201   613.199     0.150
    62.001   617.500     0.150
    64.596   633.500     0.150
    67.661   657.000     0.150
    68.651   661.699     0.150
    75.960   706.500     0.150
    77.312   714.602     0.150
    78.007   718.102     0.150
    79.992   726.898     0.150
    84.072   749.102     0.150
    84.384   751.852     0.150
    85.240   756.398     0.150
    85.482   756.398     0.150
    85.573   757.000     0.150
    85.778   757.375     0.150
    87.239   767.398     0.150
    87.239   767.750     0.150
    92.432   788.301     0.150
    92.420   788.898     0.150
    92.420   789.449     0.150
    95.108   802.199     0.150
    95.946   807.012     0.150
   119.711  1130.102     0.150
   126.777  1144.301     0.150
   146.384  1180.551     0.150
     0.204     5.469     0.150
     0.204     9.750     0.150
     0.539    10.219     0.150
     0.539    18.340     0.150
     1.023    18.641     0.150
     1.023    34.000     0.150
     1.036    18.199     0.150
     1.036    32.371     0.150
     1.099    19.539     0.150
     1.262    22.469     0.150
     1.262    39.121     0.150
     1.511    26.488     0.150
     1.511    46.879     0.150
     1.701    27.148     0.150
     1.701    48.250     0.150
     2.233    36.238     0.150
     2.233    69.090     0.150
     2.283    36.090     0.150
     2.402    39.250     0.150
     2.402    71.391     0.150
     2.487    40.438     0.150
     2.688    44.527     0.150
     2.809    45.070     0.150
     2.809    77.578     0.150
     3.387    52.109     0.150
     3.947    60.961     0.150
     4.045    62.168     0.150
     4.513    67.898     0.150
     5.128    77.898     0.150
    24.751   320.770     0.150
    31.243   376.484     0.150
    40.750   459.340     0.150
    44.660   489.125     0.150
    51.429   543.898     0.150
    51.429   617.398     0.150
    54.191   562.551     0.150
    61.185   612.250     0.150
    80.085   727.148     0.150
    94.368   797.543     0.150
     0.527    10.109     0.150
     1.179    41.367     0.150
     1.232    22.859     0.150
     1.267    23.055     0.150
     1.267    41.984     0.150
     1.751    30.008     0.150
     4.029    61.859     0.150
     4.029    60.328     0.150
     4.024    62.898     0.150
    14.825   211.391     0.150
    15.624   221.500     0.150
    27.568   345.500     0.150
    27.756   352.281     0.150
    30.785   375.867     0.150
    30.788   375.234     0.150
    31.269   381.070     0.150
    34.214   404.758     0.150
    36.168   424.180     0.150
    41.203   464.492     0.150
    44.211   488.664     0.150
    52.403   553.641     0.150
    62.247   621.852     0.150
     0.235     4.859     0.150
     0.684    12.219     0.150
     0.684    22.590     0.150
     0.862    15.699     0.150
     0.862    28.539     0.150
     0.854    15.258     0.150
     1.299    23.078     0.150
     1.444    25.430     0.150
     1.862    28.699     0.150
     1.862    56.367     0.150
     2.007    36.809     0.150
     2.227    36.379     0.150
     2.227    66.648     0.150
     2.570    42.070     0.150
     2.570    76.988     0.150
     3.387    54.559     0.150
     3.545    57.277     0.150
     3.593    55.887     0.150
     3.982    61.848     0.150
     4.396    67.738     0.150
     5.034    76.168     0.150
     5.581    83.570     0.150
     7.304   108.777     0.150
     8.367   126.988     0.150
    24.015   314.410     0.150
    27.147   342.508     0.150
    28.222   352.219     0.150
    31.411   380.117     0.150
    31.417   377.969     0.150
    31.421   380.508     0.150
    34.854   408.957     0.150
    40.577   457.289     0.150
    44.834   493.109     0.150
    50.122   534.070     0.150
    51.270   543.832     0.150
    90.114   777.648     0.150
     0.392     8.217     0.150
     0.392    14.377     0.150
     0.761    13.756     0.150
     0.797    14.877     0.150
     1.034    19.387     0.150
     1.034    37.387     0.150
     1.349    23.627     0.150
     1.349    42.166     0.150
     1.493    25.637     0.150
     1.479    27.076     0.150
     1.707    29.857     0.150
     1.707    52.336     0.150
     1.894    32.367     0.150
     1.894    58.857     0.150
     1.925    32.416     0.150
     1.925    58.756     0.150
     1.946    32.938     0.150
     1.946    58.547     0.150
     2.301    39.496     0.150
     2.301    72.377     0.150
     2.369    39.477     0.150
     2.442    39.996     0.150
     2.453    40.797     0.150
     2.519    40.127     0.150
     2.788    45.188     0.150
     2.842    47.723     0.150
     2.915    48.236     0.150
     2.915    90.188     0.150
     3.414    54.326     0.150
     3.506    55.486     0.150
     3.967    63.057     0.150
     4.639    70.857     0.150
     5.006    76.037     0.150
    15.199   220.445     0.150
    19.690   270.688     0.150
    26.052   334.486     0.150
    27.561   347.248     0.150
    40.981   463.047     0.150
    51.369   545.162     0.150
    54.271   564.537     0.150
    55.503   574.986     0.150
    84.120   749.879     0.150
   118.651  1127.438     0.150
     0.481    10.584     0.150
     0.654    12.224     0.150
     0.758    14.194     0.150
     0.758    25.934     0.150
     1.334    20.334     0.150
     1.334    38.464     0.150
     1.358    21.384     0.150
     1.358    40.004     0.150
     1.260    40.474     0.150
     1.339    22.664     0.150
     1.443    42.645     0.150
     1.970    31.754     0.150
     1.970    59.734     0.150
     2.017    34.084     0.150
     2.075    33.434     0.150
     2.230    35.484     0.150
     2.418    36.234     0.150
     2.418    64.804     0.150
     2.479    39.434     0.150
     2.479    69.764     0.150
     2.711    42.914     0.150
     2.817    43.324     0.150
     2.896    46.187     0.150
     2.896    45.823     0.150
     2.896    45.694     0.150
     3.305    52.094     0.150
     3.544    53.645     0.150
     3.544    93.694     0.150
     3.603    54.784     0.150
     3.803    57.874     0.150
     4.265    65.374     0.150
     4.780    71.274     0.150
     4.780   124.534     0.150
     5.204    76.614     0.150
     5.735    85.764     0.150
     6.577    99.304     0.150
     6.703    98.284     0.150
     7.582   111.834     0.150
     7.594   110.734     0.150
    15.101   214.444     0.150
    15.451   219.964     0.150
    15.451   220.745     0.150
    15.451   217.804     0.150
    15.451   220.294     0.150
    16.094   224.764     0.150
    16.176   231.664     0.150
    16.315   231.364     0.150
    16.913   236.264     0.150
    16.913   252.464     0.150
    16.913   428.864     0.150
    17.323   241.164     0.150
    17.827   248.364     0.150
    19.754   270.364     0.150
    19.879   270.189     0.150
    19.879   270.364     0.150
    20.096   271.464     0.150
    20.916   282.264     0.150
    21.428   286.864     0.150
    21.498   288.464     0.150
    21.546   288.564     0.150
    21.819   290.964     0.150
    22.103   295.664     0.150
    22.512   299.864     0.150
    22.769   301.264     0.150
    23.576   308.364     0.150
    23.673   311.064     0.150
    23.673   533.664     0.150
    23.673   558.664     0.150
    23.673   588.164     0.150
    23.673   743.964     0.150
    23.673   752.564     0.150
    23.779   310.664     0.150
    23.854   313.264     0.150
    23.971   310.214     0.150
    23.971   310.214     0.150
    24.017   313.664     0.150
    24.193   314.464     0.150
    25.600   329.264     0.150
    25.710   329.864     0.150
    25.710   594.064     0.150
    25.710   621.164     0.150
    25.710   664.264     0.150
    25.710   373.064     0.150
    25.871   330.664     0.150
    26.076   330.764     0.150
    26.202   335.464     0.150
    26.229   332.864     0.150
    26.326   333.964     0.150
    26.326   334.294     0.150
    27.701   344.964     0.150
    28.064   348.264     0.150
    28.543   354.164     0.150
    28.543   409.164     0.150
    28.543   542.364     0.150
    28.543   638.164     0.150
    28.543   729.164     0.150
    28.543   764.364     0.150
    29.387   358.564     0.150
    29.387   357.764     0.150
    29.519   359.484     0.150
    29.519    17.380     0.150
    31.078   373.664     0.150
    31.078   373.544     0.150
    31.083   373.323     0.150
    31.083   373.564     0.150
    31.087   373.514     0.150
    31.011   374.895     0.150
    31.109   373.914     0.150
    31.030   374.964     0.150
    31.030   677.064     0.150
    31.925   383.064     0.150
    31.925   455.664     0.150
    31.925   692.864     0.150
    32.222   387.664     0.150
    32.222   456.064     0.150
    32.222   554.664     0.150
    32.222   699.664     0.150
    32.222   816.664     0.150
    32.996   393.464     0.150
    32.996   466.564     0.150
    32.996   708.064     0.150
    32.996   831.764     0.150
    34.490   403.914     0.150
    34.698   407.164     0.150
    34.698   735.164     0.150
    34.978   409.664     0.150
    34.978   490.164     0.150
    34.978   736.664     0.150
    34.978   767.064     0.150
    34.978   779.164     0.150
    34.978   786.864     0.150
    34.978   408.645     0.150
    36.593   422.514     0.150
    36.824   425.964     0.150
    36.824   515.064     0.150
    36.824   766.464     0.150
    36.824   798.064     0.150
    36.923   429.184     0.150
    38.822   443.164     0.150
    38.931   444.064     0.150
    39.564   444.664     0.150
    39.564    13.900     0.150
    39.564   570.864     0.150
    39.564   806.264     0.150
    39.564  1004.764     0.150
    39.564  1049.664     0.150
    39.556   448.184     0.150
    39.629   449.464     0.150
    40.154   451.464     0.150
    40.154   452.364     0.150
    40.154   814.664     0.150
    40.199   454.364     0.150
    40.474   454.904     0.150
    40.540   457.564     0.150
    40.717   457.874     0.150
    40.829   459.364     0.150
    40.894   459.164     0.150
    41.096   461.364     0.150
    42.419   471.564     0.150
    42.455   472.264     0.150
    43.037   475.574     0.150
    43.031   476.864     0.150
    44.120   482.864     0.150
    44.120   590.964     0.150
    44.533   488.139     0.150
    44.533   488.414     0.150
    45.225   495.164     0.150
    45.976   500.664     0.150
    46.549   505.664     0.150
    46.549   615.664     0.150
    46.549  1107.664     0.150
    46.939   506.664     0.150
    46.939    10.100     0.150
    46.939   599.264     0.150
    46.939   615.264     0.150
    46.939   916.064     0.150
    50.797   536.214     0.150
    51.142   538.934     0.150
    51.380   541.754     0.150
    51.380   541.264     0.150
    51.380   541.864     0.150
    52.286   547.944     0.150
    52.286   546.164     0.150
    52.286    10.600     0.150
    52.286   615.064     0.150
    52.286   985.864     0.150
    52.286  1132.364     0.150
    53.733   561.145     0.150
    53.819   560.404     0.150
    53.819   560.694     0.150
    54.159   563.464     0.150
    54.234   561.645     0.150
    54.234   561.364     0.150
    54.297   564.764     0.150
    54.694   566.654     0.150
    54.830   568.184     0.150
    54.963   568.754     0.150
    54.963   569.224     0.150
    55.499   572.464     0.150
    55.499   572.088     0.150
    55.499   571.645     0.150
    55.499   571.464     0.150
    55.516   570.864     0.150
    57.369   584.764     0.150
    60.639   606.164     0.150
    61.090   610.364     0.150
    61.162   610.964     0.150
    61.162   611.494     0.150
    61.870   613.854     0.150
    61.870   613.064     0.150
    64.407   630.904     0.150
    64.407   631.764     0.150
    64.407   665.164     0.150
    67.691   653.864     0.150
    67.691  1449.863     0.150
    68.450   659.855     0.150
    68.685   658.895     0.150
    68.685  1198.864     0.150
    69.324   665.194     0.150
    70.259   669.444     0.150
    73.974   691.134     0.150
    74.121   692.334     0.150
    74.229   692.434     0.150
    75.964   704.994     0.150
    75.964   703.464     0.150
    77.086  1591.664     0.150
    77.412   712.704     0.150
    77.412   712.064     0.150
    77.786   713.574     0.150
    77.998   713.364     0.150
    78.859   719.154     0.150
    79.088   718.964     0.150
    79.473   721.164     0.150
    79.542   721.764     0.150
    79.767   723.444     0.150
    80.206   725.764     0.150
    80.882   731.164     0.150
    80.882   738.464     0.150
    80.882   915.964     0.150
    81.455   732.664     0.150
    81.455    19.000     0.150
    82.825   739.864     0.150
    83.065   741.514     0.150
    83.934   746.414     0.150
    84.044   746.489     0.150
    84.501   748.414     0.150
    85.249   752.164     0.150
    85.365   751.964     0.150
    85.401   754.184     0.150
    85.438   754.624     0.150
    85.843   754.239     0.150
    85.843   754.964     0.150
    85.843   755.194     0.150
    85.854   755.274     0.150
    88.428   771.164     0.150
    89.056  1416.664     0.150
    89.045   773.464     0.150
    89.055   771.964     0.150
    92.267   785.674     0.150
    92.422   785.364     0.150
    92.422   785.089     0.150
    93.827   793.614     0.150
    94.893   798.959     0.150
    95.478   802.664     0.150
    95.973   802.164     0.150
    96.006   803.652     0.150
    96.682  1573.465     0.150
   104.422  1800.139     0.150
   118.835  1124.214     0.150
   119.440  1126.339     0.150
   119.440  1750.389     0.150
   121.570  1129.794     0.150
   125.099  1136.184     0.150
   126.968  1141.164     0.150
   126.986  1140.739     0.150
   126.986  1140.564     0.150
   127.149  1141.364     0.150
   127.281  1140.864     0.150
   150.564  1188.494     0.150
   155.065  1189.354     0.150
   166.089  1202.364     0.150
   166.089  1201.764     0.150
   170.678  1204.744     0.150
     0.485     9.996     0.150
     0.648    12.356     0.150
     0.648    21.967     0.150
     0.752    14.406     0.150
     0.752    26.207     0.150
     1.258    21.047     0.150
     1.364    21.007     0.150
     1.334    23.477     0.150
     1.443    24.316     0.150
     1.443    42.146     0.150
     1.657    26.366     0.150
     1.657    47.106     0.150
     1.973    32.196     0.150
     2.068    32.767     0.150
     2.228    35.807     0.150
     2.473    39.526     0.150
     2.473    70.286     0.150
     2.709    43.387     0.150
     2.762    43.667     0.150
     4.259    65.087     0.150
     5.197    76.727     0.150
    26.222   335.771     0.150
    27.700   345.350     0.150
    31.087   373.035     0.150
    34.494   404.477     0.150
    40.890   458.817     0.150
    44.537   488.877     0.150
    51.375   541.837     0.150
    51.375   541.901     0.150
    54.229   561.451     0.150
    55.494   571.557     0.150
    61.156   610.847     0.150
    85.838   755.018     0.150
   118.828  1123.824     0.150
     0.518    10.747     0.150
     1.129    17.507     0.150
     1.406    24.396     0.150
     1.471    24.957     0.150
     1.471    44.847     0.150
     1.542    25.037     0.150
     1.542    46.027     0.150
     1.785    28.497     0.150
     2.203    33.617     0.150
     2.296    36.117     0.150
     2.663    41.757     0.150
     2.697    43.227     0.150
     2.697    74.117     0.150
     2.707    42.637     0.150
     2.707    75.207     0.150
     2.792    42.827     0.150
     3.089    47.566     0.150
     3.772    57.896     0.150
     3.816    57.367     0.150
     5.415    79.337     0.150
    15.367   214.972     0.150
    24.036   311.707     0.150
    26.447   334.447     0.150
    27.575   342.884     0.150
    27.830   347.057     0.150
    27.830   347.061     0.150
    30.889   371.262     0.150
    30.889   548.146     0.150
    32.440   388.146     0.150
    34.302   402.047     0.150
    34.302   557.646     0.150
    35.009   408.644     0.150
    37.043   428.047     0.150
    39.049   444.847     0.150
    39.158   445.146     0.150
    39.855   451.347     0.150
    40.426   456.146     0.150
    40.767   459.047     0.150
    40.912   459.467     0.150
    41.090   460.646     0.150
    41.090   578.790     0.150
    41.839   466.847     0.150
    42.645   473.646     0.150
    42.920   473.947     0.150
    44.333   486.160     0.150
    44.333   589.422     0.150
    44.333   485.017     0.150
    50.855   537.294     0.150
    51.603   543.157     0.150
    51.603   615.396     0.150
    51.603   543.872     0.150
    51.603   615.797     0.150
    54.446   562.896     0.150
    54.446   563.146     0.150
    55.719   573.247     0.150
    55.721   573.247     0.150
    56.418   578.057     0.150
    57.597   585.507     0.150
    61.310   612.108     0.150
    61.310   652.909     0.150
    61.382   611.617     0.150
    66.346   644.677     0.150
    67.821   654.197     0.150
    68.904   660.127     0.150
    78.030   714.047     0.150
    80.679   727.396     0.150
    84.243   746.738     0.150
    84.730   748.917     0.150
    84.730   750.047     0.150
    85.437   753.097     0.150
    85.437   752.697     0.150
    85.707   754.114     0.150
    86.068   755.690     0.150
    94.957   797.715     0.150
    96.230   804.291     0.150
   119.051  1124.197     0.150
   146.210  1176.674     0.150
     0.262     5.434     0.150
     1.112    19.664     0.150
     1.112    37.887     0.150
     1.170    21.215     0.150
     1.170    39.035     0.150
     1.189    21.895     0.150
     1.230    21.453     0.150
     1.230    40.297     0.150
     1.500    23.797     0.150
     1.500    46.145     0.150
     2.036    32.645     0.150
     2.496    40.324     0.150
     2.591    42.156     0.150
     2.628    41.535     0.150
     2.766    44.215     0.150
     2.892    51.375     0.150
     3.813    59.285     0.150
    26.641   338.375     0.150
    27.514   345.754     0.150
    27.514   345.750     0.150
    31.061   376.605     0.150
    31.066   374.406     0.150
    31.066   550.824     0.150
    34.497   405.727     0.150
    34.498   405.227     0.150
    34.498   560.324     0.150
    34.674   407.375     0.150
    37.313   430.906     0.150
    40.923   459.645     0.150
    44.490   488.824     0.150
    51.563   544.727     0.150
    51.563   544.254     0.150
    54.343   563.605     0.150
    55.211   572.273     0.150
    55.659   573.613     0.150
    57.621   588.305     0.150
    66.336   646.086     0.150
    77.537   713.574     0.150
    79.416   722.766     0.150
    80.279   726.375     0.150
    81.581   733.387     0.150
    84.799   752.227     0.150
    85.051   752.504     0.150
    85.608   755.926     0.150
    86.051   756.996     0.150
    94.564   796.895     0.150
   119.250  1125.977     0.150
     1.126    20.562     0.150
     2.237    36.172     0.150
     2.237    67.039     0.150
     2.435    38.852     0.150
     2.637    43.289     0.150
     3.245    50.109     0.150
     3.404    53.801     0.150
     3.656    57.180     0.150
     3.833    69.180     0.150
     4.462    69.301     0.150
    20.425   278.801     0.150
    26.585   339.852     0.150
    27.136   342.582     0.150
    27.136   342.578     0.150
    28.224   352.242     0.150
    31.392   380.691     0.150
    31.398   379.090     0.150
    34.293   406.297     0.150
    34.838   410.449     0.150
    34.937   413.301     0.150
    40.599   460.449     0.150
    44.810   491.211     0.150
    50.085   532.910     0.150
    51.314   543.680     0.150
    51.754   546.340     0.150
    54.054   564.070     0.150
    57.417   589.730     0.150
    79.908   726.340     0.150
    84.628   754.902     0.150
    90.108   778.832     0.150
     0.494     9.594     0.150
     0.494    17.934     0.150
     0.648    12.145     0.150
     0.648    22.355     0.150
     0.763    13.965     0.150
     0.763    25.664     0.150
     1.323    21.664     0.150
     1.323    38.613     0.150
     1.354    22.797     0.150
     1.354    43.297     0.150
     1.273    23.406     0.150
     1.273    42.445     0.150
     1.456    24.965     0.150
     1.456    44.676     0.150
     1.959    32.547     0.150
     2.075    34.594     0.150
     2.216    36.305     0.150
     2.550    41.016     0.150
     2.550    73.273     0.150
     2.484    40.484     0.150
     2.753    44.297     0.150
     2.886    44.586     0.150
    19.402   266.746     0.150
    31.073   374.043     0.150
    34.480   405.324     0.150
    44.523   489.227     0.150
    51.387   543.559     0.150
    55.507   573.305     0.150
    55.508   573.301     0.150
    61.097   612.008     0.150
    84.054   747.527     0.150
     0.550    11.117     0.150
     0.711    13.246     0.150
     0.711    27.066     0.150
     0.736    13.105     0.150
     1.042    17.367     0.150
     1.042    31.875     0.150
     1.196    20.598     0.150
     1.196    38.848     0.150
     1.554    26.406     0.150
     1.655    27.668     0.150
     1.712    27.676     0.150
     1.712    48.996     0.150
     1.881    30.715     0.150
     1.881    53.297     0.150
     1.802    30.105     0.150
     1.802    51.617     0.150
     2.286    36.395     0.150
     2.346    39.605     0.150
     2.692    42.418     0.150
     2.754    44.668     0.150
     2.950    46.285     0.150
    30.599   370.125     0.150
    30.599   549.430     0.150
    34.026   399.805     0.150
    34.026   558.605     0.150
    44.030   484.543     0.150
    51.964   547.043     0.150
    89.269   772.043     0.150
   119.444  1127.328     0.150
     0.353     8.062     0.150
     0.353    14.000     0.150
     0.934    16.902     0.150
     0.934    29.750     0.150
     1.041    18.531     0.150
     1.041    31.832     0.150
     1.126    18.332     0.150
     1.654    28.082     0.150
     1.654    49.379     0.150
     1.804    30.422     0.150
     1.804    55.609     0.150
     1.754    29.262     0.150
     1.754    51.820     0.150
     1.888    31.090     0.150
     2.002    32.941     0.150
     2.002    57.102     0.150
     2.145    35.582     0.150
     2.145    63.031     0.150
     2.155    35.320     0.150
     2.155    61.750     0.150
     2.465    40.910     0.150
     2.511    40.469     0.150
     2.577    41.859     0.150
     2.603    41.352     0.150
     2.603    72.129     0.150
     2.708    47.039     0.150
     2.708    85.129     0.150
     3.311    51.109     0.150
     3.311    88.879     0.150
     3.563    54.902     0.150
     4.192    63.602     0.150
     4.192    62.832     0.150
     4.584    68.641     0.150
    25.944   332.141     0.150
    27.348   342.672     0.150
    28.154   350.891     0.150
    30.853   372.664     0.150
    30.853   548.734     0.150
    34.231   403.477     0.150
    34.231   558.051     0.150
    41.127   462.895     0.150
    44.329   487.801     0.150
    51.426   543.051     0.150
    52.021   548.629     0.150
    54.372   564.219     0.150
    65.322   640.840     0.150
    81.194   731.043     0.150
    84.256   748.418     0.150
    84.387   749.641     0.150
    85.621   755.016     0.150
    85.853   755.766     0.150
    89.338   771.816     0.150
    92.570   786.820     0.150
   118.531  1124.809     0.150
   120.064  1128.492     0.150
     0.463     9.359     0.150
     0.463    17.930     0.150
     1.064    18.051     0.150
     1.064    32.770     0.150
     1.220    20.559     0.150
     1.220    38.441     0.150
     1.621    25.281     0.150
     1.621    46.949     0.150
     1.520    24.602     0.150
     1.520    45.852     0.150
     1.889    30.109     0.150
     1.889    54.211     0.150
     2.027    57.539     0.150
     2.134    33.309     0.150
     2.134    60.559     0.150
     2.666    42.570     0.150
     2.611    40.961     0.150
     2.732    41.648     0.150
     2.732    74.891     0.150
     2.762    43.102     0.150
     3.658    55.898     0.150
     4.325    63.969     0.150
     8.350   121.461     0.150
    14.303   206.480     0.150
    14.343   208.199     0.150
    14.750   212.551     0.150
    15.160   217.820     0.150
    15.451   224.270     0.150
    15.541   221.969     0.150
    16.813   236.570     0.150
    16.813   424.172     0.150
    18.025   249.770     0.150
    19.328   263.059     0.150
    19.328   264.371     0.150
    20.944   285.570     0.150
    21.105   283.371     0.150
    21.397   288.570     0.150
    21.624   290.172     0.150
    22.019   289.570     0.150
    22.062   294.871     0.150
    22.289   297.871     0.150
    22.472   298.270     0.150
    23.293   305.551     0.150
    23.493   307.699     0.150
    23.585   308.520     0.150
    23.585   309.371     0.150
    24.013   312.469     0.150
    24.108   313.371     0.150
    24.293   316.871     0.150
    24.413   317.371     0.150
    24.494   319.270     0.150
    24.655   319.270     0.150
    24.778   320.371     0.150
    24.869   321.969     0.150
    24.930   320.910     0.150
    25.062   324.570     0.150
    25.363   326.172     0.150
    25.422   326.070     0.150
    25.464   327.770     0.150
    25.528   328.469     0.150
    25.664   329.570     0.150
    25.717   328.672     0.150
    25.766   328.480     0.150
    25.942   330.430     0.150
    25.967   330.422     0.150
    25.967   331.000     0.150
    25.967   538.371     0.150
    26.069   331.969     0.150
    26.073   330.969     0.150
    26.073   331.969     0.150
    26.671   336.570     0.150
    27.218   339.820     0.150
    27.218   339.672     0.150
    28.289   350.621     0.150
    28.289   350.621     0.150
    28.303   350.871     0.150
    28.640   354.371     0.150
    30.738   370.352     0.150
    31.449   379.469     0.150
    32.409   388.672     0.150
    32.409   459.871     0.150
    33.352   398.172     0.150
    34.112   401.180     0.150
    34.113   400.285     0.150
    34.113   556.727     0.150
    34.124   400.461     0.150
    34.446   404.172     0.150
    34.547   405.949     0.150
    35.506   413.742     0.150
    36.849   426.320     0.150
    37.007   427.672     0.150
    39.985   450.680     0.150
    40.395   456.270     0.150
    40.675   458.371     0.150
    40.688   457.570     0.150
    40.855   459.672     0.150
    40.942   460.672     0.150
    41.243   462.945     0.150
    41.243   580.141     0.150
    41.252   462.609     0.150
    42.260   471.469     0.150
    42.307   471.469     0.150
    42.874   476.672     0.150
    43.372   478.172     0.150
    44.218   485.523     0.150
    44.874   491.570     0.150
    46.679   506.371     0.150
    51.497   542.602     0.150
    51.516   542.680     0.150
    51.516   543.156     0.150
    51.516   616.047     0.150
    51.516   542.742     0.150
    51.704   543.898     0.150
    52.278   551.371     0.150
    52.278   621.969     0.150
    52.278   988.871     0.150
    52.278  1030.969     0.150
    52.481   550.250     0.150
    54.475   563.531     0.150
    54.475   563.637     0.150
    54.475   563.352     0.150
    57.365   585.477     0.150
    57.395   585.449     0.150
    57.395   585.512     0.150
    61.324   612.012     0.150
    62.420   618.668     0.150
    62.420   617.789     0.150
    66.201   643.660     0.150
    68.476   658.449     0.150
    81.326   731.320     0.150
    84.369   748.039     0.150
    84.447   749.270     0.150
    85.723   754.746     0.150
    85.935   755.719     0.150
    85.946   755.359     0.150
    86.049   755.902     0.150
    89.212   770.695     0.150
    89.212   770.121     0.150
    92.674   786.871     0.150
    92.674   786.547     0.150
    95.587   800.289     0.150
    96.110   804.363     0.150
   118.548  1122.102     0.150
   118.548  1123.137     0.150
     0.508     9.586     0.150
     0.888    16.438     0.150
     0.888    30.328     0.150
     0.943    17.219     0.150
     0.943    30.383     0.150
     1.042    17.562     0.150
     1.058    20.000     0.150
     1.058    34.930     0.150
     1.219    37.883     0.150
     1.262    42.148     0.150
     1.378    22.938     0.150
     1.639    27.906     0.150
     1.639    51.516     0.150
     1.713    28.469     0.150
     1.713    52.375     0.150
     1.848    30.844     0.150
     1.848    56.859     0.150
     1.817    29.734     0.150
     1.817    51.523     0.150
     2.066    34.258     0.150
     2.066    58.906     0.150
     2.428    37.648     0.150
     2.428    66.664     0.150
     2.366    38.797     0.150
     2.366    68.336     0.150
     2.618    43.789     0.150
     2.618    82.516     0.150
     2.662    50.773     0.150
     2.662    83.125     0.150
     2.901    44.555     0.150
     3.082    48.727     0.150
     3.082    84.430     0.150
     3.135    48.773     0.150
     3.135    94.117     0.150
     3.586    54.336     0.150
     3.586   100.500     0.150
     4.777    72.297     0.150
     4.777   124.484     0.150
    26.169   334.258     0.150
    28.075   350.477     0.150
    34.206   403.703     0.150
    35.276   412.680     0.150
    41.163   461.164     0.150
    44.278   488.930     0.150
    51.542   545.664     0.150
    54.450   565.617     0.150
    85.705   756.141     0.150
     0.988    18.656     0.150
     0.988    33.727     0.150
     1.008    17.686     0.150
     1.008    33.467     0.150
     1.069    19.926     0.150
     1.069    35.316     0.150
     1.247    22.807     0.150
     1.247    42.377     0.150
     1.308    22.637     0.150
     1.308    42.605     0.150
     1.492    26.506     0.150
     1.492    46.936     0.150
     1.720    27.707     0.150
     1.720    48.057     0.150
     1.951    34.586     0.150
     2.259    36.256     0.150
     2.259    65.146     0.150
     2.281    39.746     0.150
     2.281    67.037     0.150
     2.373    40.105     0.150
     2.373    68.076     0.150
     2.456    39.047     0.150
     2.456    69.816     0.150
    31.275   378.607     0.150
    34.710   407.865     0.150
    34.710   562.586     0.150
    51.392   543.186     0.150
     0.237    11.406     0.150
     0.488     9.430     0.150
     0.488    17.750     0.150
     0.936    30.469     0.150
     1.355    22.922     0.150
     1.355    42.430     0.150
     1.346    41.695     0.150
     1.362    23.148     0.150
     1.381    23.633     0.150
     1.381    43.742     0.150
     1.482    23.383     0.150
     1.482    44.211     0.150
     1.956    55.836     0.150
     1.974    30.062     0.150
     1.974    56.383     0.150
     2.255    36.727     0.150
     2.255    65.516     0.150
     2.718    41.500     0.150
     2.718    77.500     0.150
     2.749    49.062     0.150
     2.785    42.852     0.150
     2.769    49.031     0.150
     2.769    92.383     0.150
     2.816    43.648     0.150
     3.002    47.562     0.150
     3.040    47.766     0.150
     3.737    58.602     0.150
     3.887    58.781     0.150
     4.045    62.289     0.150
    34.356   404.742     0.150
    44.328   488.641     0.150
    51.769   545.406     0.150
    51.769   545.438     0.150
    51.769   545.438     0.150
    54.528   564.391     0.150
    54.531   564.391     0.150
    55.860   574.992     0.150
    56.720   581.211     0.150
    57.844   589.633     0.150
    85.794   754.961     0.150
    85.794   754.953     0.150
     1.266    22.585     0.150
     1.597    27.155     0.150
     1.817    29.805     0.150
     2.148    33.955     0.150
     2.171    36.405     0.150
     2.077    35.145     0.150
     2.559    41.195     0.150
     2.657    42.185     0.150
     2.862    44.585     0.150
     2.862    88.525     0.150
     3.062    47.235     0.150
     3.204    50.355     0.150
     3.204    50.530     0.150
     3.117    48.815     0.150
     3.142    49.725     0.150
     3.404    51.565     0.150
     3.670    56.035     0.150
     3.667    56.605     0.150
     3.828    60.445     0.150
     4.126    62.455     0.150
     4.133    65.515     0.150
     4.268    65.435     0.150
     4.308    65.055     0.150
     4.718    71.145     0.150
     4.842    74.795     0.150
     5.157    80.085     0.150
     5.157    82.855     0.150
     5.212    82.685     0.150
     5.235    77.255     0.150
     5.315    81.345     0.150
     6.356    94.085     0.150
     6.256    94.595     0.150
     6.275    95.415     0.150
     7.318   112.065     0.150
     8.345   124.835     0.150
     8.648   125.125     0.150
     9.273   138.285     0.150
     9.599   139.485     0.150
     9.661   139.085     0.150
     9.661   136.665     0.150
    10.951   157.635     0.150
    11.028   156.785     0.150
    11.008   161.085     0.150
    12.036   167.185     0.150
    12.189   170.685     0.150
    12.330   178.285     0.150
    12.898   182.360     0.150
    13.179   186.655     0.150
    13.151   185.675     0.150
    13.411   186.685     0.150
    13.537   194.485     0.150
    13.711   195.775     0.150
    13.886   197.395     0.150
    14.038   199.785     0.150
    14.125   197.585     0.150
    14.113   201.915     0.150
    14.423   206.685     0.150
    14.377   202.625     0.150
    14.506   206.285     0.150
    14.745   210.285     0.150
    14.898   212.785     0.150
    15.140   213.585     0.150
    15.140   210.475     0.150
    15.286   220.685     0.150
    15.180   213.425     0.150
    15.364   217.085     0.150
    15.427   216.629     0.150
    15.427   219.805     0.150
    15.427   217.915     0.150
    15.480   219.085     0.150
    15.406   215.735     0.150
    15.444   217.985     0.150
    15.625   220.885     0.150
    15.536   223.885     0.150
    15.536   218.615     0.150
    15.767   224.885     0.150
    15.871   228.085     0.150
    15.825   224.185     0.150
    15.825   233.185     0.150
    16.019   231.885     0.150
    16.019   224.245     0.150
    16.306   230.185     0.150
    16.457   235.185     0.150
    16.457   415.685     0.150
    16.457   232.495     0.150
    16.626   239.185     0.150
    16.867   238.685     0.150
    17.303   242.160     0.150
    17.303   241.195     0.150
    17.573   249.785     0.150
    18.509   257.085     0.150
    18.509   256.095     0.150
    18.682   258.885     0.150
    18.791   259.185     0.150
    18.888   261.885     0.150
    18.888   262.045     0.150
    19.187   265.885     0.150
    19.187   262.145     0.150
    19.535   269.785     0.150
    19.535   266.025     0.150
    19.629   270.185     0.150
    19.802   272.785     0.150
    19.847   271.285     0.150
    19.919   273.185     0.150
    19.986   271.435     0.150
    19.986   484.610     0.150
    19.986   273.685     0.150
    20.303   277.285     0.150
    20.295   277.685     0.150
    20.449   281.085     0.150
    20.603   281.985     0.150
    20.682   278.860     0.150
    20.682   280.885     0.150
    20.608   279.285     0.150
    20.714   279.980     0.150
    20.714   504.830     0.150
    20.714   278.585     0.150
    20.743   283.285     0.150
    20.743   280.625     0.150
    20.918   286.385     0.150
    21.248   285.985     0.150
    21.248   285.695     0.150
    21.581   293.385     0.150
    21.616   287.275     0.150
    21.629   290.885     0.150
    21.629   289.915     0.150
    21.947   297.685     0.150
    22.041   294.815     0.150
    22.079   297.385     0.150
    22.240   297.215     0.150
    22.218   297.885     0.150
    22.303   301.685     0.150
    22.430   300.385     0.150
    22.552   299.785     0.150
    22.552   543.885     0.150
    22.552   555.885     0.150
    22.552   587.385     0.150
    22.800   304.485     0.150
    22.910   304.285     0.150
    23.042   307.285     0.150
    23.042   305.415     0.150
    23.324   307.460     0.150
    23.324  1906.110     0.150
    23.263   307.785     0.150
    23.318   309.285     0.150
    23.452   311.485     0.150
    23.399   307.485     0.150
    23.454   309.885     0.150
    23.454   307.765     0.150
    23.568   315.185     0.150
    23.628   310.885     0.150
    23.628   310.465     0.150
    23.709   312.385     0.150
    23.914   316.785     0.150
    23.946   312.610     0.150
    23.946   560.810     0.150
    23.946   312.255     0.150
    23.946   313.035     0.150
    24.092   316.285     0.150
    24.102   317.785     0.150
    24.198   314.285     0.150
    24.198   573.235     0.150
    24.110   315.385     0.150
    24.199   318.685     0.150
    24.144   315.485     0.150
    24.387   317.125     0.150
    24.575   322.085     0.150
    24.627   320.085     0.150
    24.783   322.485     0.150
    24.822   324.985     0.150
    24.953   326.585     0.150
    25.137   325.385     0.150
    25.174   324.585     0.150
    25.341   325.215     0.150
    25.269   326.385     0.150
    25.269   366.285     0.150
    25.269   325.585     0.150
    25.300   327.985     0.150
    25.449   329.685     0.150
    25.472   328.185     0.150
    25.747   330.635     0.150
    25.747   329.425     0.150
    25.747   539.015     0.150
    25.747   329.825     0.150
    25.747   539.018     0.150
    25.747   599.010     0.150
    25.747   329.585     0.150
    25.815   331.985     0.150
    25.845   332.454     0.150
    25.845   330.085     0.150
    26.087   332.075     0.150
    25.957   331.310     0.150
    25.957   602.310     0.150
    26.522   338.085     0.150
    26.835   338.785     0.150
    26.927   340.285     0.150
    27.292   341.425     0.150
    27.276   342.585     0.150
    27.286   342.425     0.150
    27.248   346.585     0.150
    27.248   342.515     0.150
    27.477   346.785     0.150
    27.631   344.585     0.150
    27.631   346.635     0.150
    27.631   542.429     0.150
    27.631   628.410     0.150
    27.689   346.175     0.150
    27.872   347.735     0.150
    27.872   631.010     0.150
    27.872   348.695     0.150
    27.736   346.885     0.150
    27.736   347.285     0.150
    27.980   354.285     0.150
    28.150   351.385     0.150
    28.523   358.285     0.150
    28.955   358.685     0.150
    28.955   651.485     0.150
    29.461   360.885     0.150
    29.461   547.685     0.150
    29.461   360.385     0.150
    29.461   660.685     0.150
    29.461   360.546     0.150
    29.461   547.644     0.150
    29.461   659.235     0.150
    29.461   360.335     0.150
    29.463   360.845     0.150
    29.593   364.685     0.150
    29.960   364.855     0.150
    29.960   664.055     0.150
    29.960   365.685     0.150
    30.374   369.955     0.150
    30.642   372.335     0.150
    30.787   376.265     0.150
    30.793   374.185     0.150
    30.813   374.285     0.150
    30.813   550.685     0.150
    30.813   681.285     0.150
    31.252   376.760     0.150
    31.342   377.585     0.150
    31.342   377.355     0.150
    31.348   377.210     0.150
    31.348   552.913     0.150
    31.348   680.585     0.150
    31.348   376.475     0.150
    31.373   377.415     0.150
    31.440   378.945     0.150
    31.440   442.665     0.150
    31.520   379.765     0.150
    31.520   443.495     0.150
    31.535   378.965     0.150
    31.537   379.495     0.150
    31.544   379.445     0.150
    31.544   444.305     0.150
    31.554   379.405     0.150
    31.554   443.665     0.150
    31.704   383.055     0.150
    31.724   385.275     0.150
    31.795   383.285     0.150
    31.868   385.485     0.150
    31.868   455.285     0.150
    31.868   808.985     0.150
    32.257   388.585     0.150
    32.736   393.385     0.150
    32.736   709.785     0.150
    32.736   393.785     0.150
    32.736   465.985     0.150
    32.736   706.785     0.150
    32.912   397.015     0.150
    33.002   398.185     0.150
    33.002   714.985     0.150
    33.137   395.485     0.150
    33.746   400.265     0.150
    33.788   401.985     0.150
    33.787   400.185     0.150
    33.787   476.685     0.150
    34.033   402.395     0.150
    34.232   404.565     0.150
    34.232   403.985     0.150
    34.232   406.205     0.150
    34.734   407.335     0.150
    34.734   407.995     0.150
    34.852   410.235     0.150
    34.852   738.460     0.150
    34.912   410.185     0.150
    36.124   420.885     0.150
    36.469   424.785     0.150
    36.469   777.685     0.150
    36.475   425.685     0.150
    36.475   426.472     0.150
    36.637   425.085     0.150
    36.968   427.135     0.150
    36.968   427.685     0.150
    37.596   434.095     0.150
    38.242   439.455     0.150
    38.358   440.785     0.150
    38.358   441.285     0.150
    38.465   441.885     0.150
    38.910   447.185     0.150
    38.910   535.985     0.150
    38.910   572.185     0.150
    38.910   801.785     0.150
    39.162   448.085     0.150
    39.509   447.615     0.150
    39.397   447.485     0.150
    39.397   448.485     0.150
    39.722   450.385     0.150
    39.734   452.985     0.150
    40.199   456.085     0.150
    40.199   820.085     0.150
    40.199   454.415     0.150
    40.573   457.155     0.150
    40.573   826.630     0.150
    40.573   457.305     0.150
    40.363   457.485     0.150
    40.375   457.285     0.150
    40.457   458.105     0.150
    40.457   457.885     0.150
    40.636   457.825     0.150
    40.636   546.095     0.150
    40.540   458.885     0.150
    40.630   458.965     0.150
    40.630   457.985     0.150
    40.630   459.685     0.150
    40.726   461.385     0.150
    40.726   551.685     0.150
    40.726   578.185     0.150
    40.726   829.785     0.150
    41.147   463.585     0.150
    41.998   471.085     0.150
    41.998   570.885     0.150
    42.128   471.559     0.150
    42.141   471.664     0.150
    42.144   471.686     0.150
    41.990   470.985     0.150
    42.179   469.855     0.150
    42.452   473.032     0.150
    42.460   473.092     0.150
    42.470   472.608     0.150
    42.855   477.685     0.150
    42.855   592.085     0.150
    42.911   477.854     0.150
    42.911   864.804     0.150
    42.911   478.648     0.150
    43.086   476.085     0.150
    43.086   856.010     0.150
    43.086   478.605     0.150
    43.616   487.385     0.150
    43.787   483.285     0.150
    43.999   484.245     0.150
    43.850   485.285     0.150
    44.816   491.660     0.150
    44.816   598.185     0.150
    44.622   491.405     0.150
    44.738   492.885     0.150
    44.738   886.885     0.150
    44.866   493.754     0.150
    44.866   493.185     0.150
    44.866   493.005     0.150
    45.166   499.485     0.150
    45.166   605.385     0.150
    45.175   499.085     0.150
    45.701   500.085     0.150
    46.171   504.285     0.150
    46.171   504.885     0.150
    46.403   506.145     0.150
    46.468   510.235     0.150
    47.324   513.145     0.150
    48.277   520.195     0.150
    48.470   520.785     0.150
    48.470   637.685     0.150
    48.422   520.285     0.150
    49.325   524.345     0.150
    49.214   531.775     0.150
    49.290   528.215     0.150
    49.913   531.605     0.150
    49.913   959.935     0.150
    50.356   538.445     0.150
    50.380   534.925     0.150
    50.796   539.385     0.150
    50.889   539.785     0.150
    50.889   539.610     0.150
    50.889   540.855     0.150
    50.671   540.745     0.150
    50.671   978.495     0.150
    51.004   540.785     0.150
    51.004   541.210     0.150
    51.004   972.610     0.150
    51.004  2382.060     0.150
    51.004  2399.709     0.150
    51.004   540.415     0.150
    51.007   541.785     0.150
    51.328   543.285     0.150
    51.239  1130.385     0.150
    51.239   542.135     0.150
    51.194   542.185     0.150
    51.227   542.705     0.150
    51.227   985.505     0.150
    51.619   543.545     0.150
    51.590   545.245     0.150
    51.590   988.855     0.150
    51.593   545.555     0.150
    51.593   983.555     0.150
    51.621   545.445     0.150
    51.855   548.885     0.150
    51.855   668.685     0.150
    52.338  1002.485     0.150
    52.338   551.365     0.150
    52.131   549.285     0.150
    52.191   548.385     0.150
    52.191   991.485     0.150
    52.191   549.055     0.150
    52.465   551.685     0.150
    52.465  1001.005     0.150
    52.465   551.585     0.150
    52.536   551.605     0.150
    52.536  1002.945     0.150
    52.550   552.675     0.150
    52.648   556.225     0.150
    52.648  1007.695     0.150
    52.866   554.025     0.150
    53.119   556.305     0.150
    52.934   555.645     0.150
    53.309   557.945     0.150
    53.309  1014.605     0.150
    53.317   559.415     0.150
    53.408   560.285     0.150
    53.408   559.745     0.150
    53.485   559.004     0.150
    53.485   559.985     0.150
    53.502   560.745     0.150
    53.745   562.555     0.150
    53.881   563.475     0.150
    53.908   561.405     0.150
    53.908   625.255     0.150
    53.908   561.785     0.150
    53.908  2380.135     0.150
    53.908   560.785     0.150
    54.010   563.025     0.150
    54.048  2393.380     0.150
    54.048   564.598     0.150
    54.048   564.254     0.150
    54.048   564.785     0.150
    54.048   563.825     0.150
    54.093   562.845     0.150
    54.093  1023.765     0.150
    54.267   564.205     0.150
    54.267  1029.835     0.150
    54.412   566.935     0.150
    54.547   567.605     0.150
    55.138   570.685     0.150
    55.138   571.005     0.150
    55.138  2388.010     0.150
    55.232   576.695     0.150
    55.240   575.439     0.150
    55.254   574.467     0.150
    55.734   575.685     0.150
    56.315   579.555     0.150
    56.721  2387.084     0.150
    56.721   582.885     0.150
    56.709   582.585     0.150
    56.709  1062.785     0.150
    56.952   584.185     0.150
    56.952   583.885     0.150
    56.984   584.085     0.150
    56.984  1066.945     0.150
    57.339  1071.725     0.150
    57.397  1069.075     0.150
    57.754   587.185     0.150
    57.635   589.285     0.150
    57.885   587.865     0.150
    58.149   592.005     0.150
    58.149  1077.445     0.150
    58.641   593.585     0.150
    59.995   605.085     0.150
    60.726  2376.348     0.150
    60.798   610.555     0.150
    60.798   609.285     0.150
    60.798   610.275     0.150
    61.236   613.605     0.150
    61.762   615.344     0.150
    61.762  2372.094     0.150
    62.906   628.853     0.150
    63.218   624.625     0.150
    63.502   626.785     0.150
    63.628  2370.610     0.150
    63.834   630.310     0.150
    63.834  1139.935     0.150
    63.834  2373.510     0.150
    64.092   632.933     0.150
    64.163   633.953     0.150
    64.260   633.853     0.150
    64.422   632.785     0.150
    64.422   665.785     0.150
    64.422   774.885     0.150
    64.422  1154.185     0.150
    64.422  1404.685     0.150
    64.422   633.695     0.150
    64.759   633.945     0.150
    64.838   637.495     0.150
    64.841   637.853     0.150
    64.948   638.853     0.150
    65.008   639.260     0.150
    65.008  1156.610     0.150
    65.008  2362.010     0.150
    65.008   639.085     0.150
    65.567   642.853     0.150
    65.723   643.085     0.150
    65.723   641.855     0.150
    65.769   644.513     0.150
    65.769   644.853     0.150
    65.850   644.030     0.150
    65.850   643.925     0.150
    65.891   645.695     0.150
    65.912   644.628     0.150
    65.916   644.853     0.150
    65.916   644.963     0.150
    65.983   644.778     0.150
    65.983   645.893     0.150
    66.267   646.305     0.150
    66.342   646.500     0.150
    66.342   647.933     0.150
    66.341   648.585     0.150
    66.341   649.005     0.150
    66.406   647.606     0.150
    66.406   652.853     0.150
    66.580   649.853     0.150
    66.580   650.863     0.150
    66.647   649.304     0.150
    66.647   650.003     0.150
    66.959   650.482     0.150
    66.959   651.985     0.150
    67.373   653.535     0.150
    67.520   653.685     0.150
    67.337   652.985     0.150
    67.337   801.685     0.150
    67.337  1191.985     0.150
    67.806   655.565     0.150
    67.922   655.545     0.150
    68.072   657.175     0.150
    67.964   658.913     0.150
    68.193   658.995     0.150
    68.241   660.887     0.150
    68.266   659.495     0.150
    68.321   659.049     0.150
    68.321   659.615     0.150
    68.437   660.465     0.150
    68.326   658.385     0.150
    68.326   682.485     0.150
    68.326  1198.085     0.150
    68.326  1258.085     0.150
    68.326  1459.485     0.150
    68.326   658.985     0.150
    68.599   662.708     0.150
    68.621   661.385     0.150
    68.697   664.791     0.150
    68.749   665.118     0.150
    68.844   664.603     0.150
    68.861   663.450     0.150
    68.861   662.855     0.150
    68.945   664.265     0.150
    68.962   662.775     0.150
    69.018   662.835     0.150
    69.018   813.765     0.150
    69.023   664.413     0.150
    68.838   664.873     0.150
    69.127   668.433     0.150
    69.167   666.178     0.150
    69.224   666.205     0.150
    69.229   669.985     0.150
    69.414   666.908     0.150
    69.424   668.863     0.150
    69.505   666.298     0.150
    69.623   668.214     0.150
    69.675   667.584     0.150
    70.443   673.565     0.150
    73.471   694.585     0.150
    73.471  1264.885     0.150
    73.657   690.685     0.150
    74.728   697.985     0.150
    74.728   712.885     0.150
    74.728   866.285     0.150
    75.298   702.285     0.150
    75.521   703.161     0.150
    75.521   703.905     0.150
    75.521   702.085     0.150
    75.521   703.785     0.150
    75.666   703.555     0.150
    75.666   703.385     0.150
    75.836   702.885     0.150
    75.910   705.885     0.150
    76.118   704.185     0.150
    76.178   707.485     0.150
    76.334   707.185     0.150
    76.446   709.685     0.150
    76.629   707.545     0.150
    76.485   708.485     0.150
    76.711   713.185     0.150
    76.711  1315.085     0.150
    76.780   713.885     0.150
    76.837   710.435     0.150
    76.837  1299.585     0.150
    76.837  2343.860     0.150
    77.002   709.315     0.150
    76.939   711.585     0.150
    76.985   710.887     0.150
    76.985   711.805     0.150
    76.985   710.685     0.150
    76.985   884.985     0.150
    76.985  1596.585     0.150
    76.985   712.277     0.150
    76.985   882.615     0.150
    77.241   713.385     0.150
    77.454   710.275     0.150
    77.337   713.185     0.150
    77.542   712.885     0.150
    77.542  1303.085     0.150
    77.542  1608.285     0.150
    77.774   713.155     0.150
    77.672   716.185     0.150
    77.837   714.465     0.150
    77.772   715.055     0.150
    77.741   719.785     0.150
    77.841   715.225     0.150
    77.938   713.525     0.150
    77.791   716.985     0.150
    78.157   716.654     0.150
    78.157   718.035     0.150
    78.090   719.685     0.150
    78.409   718.775     0.150
    78.349   718.285     0.150
    78.466   718.825     0.150
    78.397   719.285     0.150
    78.705   719.995     0.150
    78.703   721.585     0.150
    78.961   721.915     0.150
    78.988   720.465     0.150
    79.082   721.715     0.150
    79.078   721.485     0.150
    79.078  1314.585     0.150
    79.104   721.885     0.150
    79.148   721.985     0.150
    79.148   907.685     0.150
    79.148  1321.185     0.150
    79.148  1624.685     0.150
    79.149   722.585     0.150
    79.196   724.185     0.150
    79.290   721.875     0.150
    79.290   895.235     0.150
    79.241   722.285     0.150
    79.241  1318.385     0.150
    79.241  1636.085     0.150
    79.525   725.474     0.150
    79.575   725.005     0.150
    79.526  1339.905     0.150
    79.526  1333.215     0.150
    79.526   726.145     0.150
    79.747   726.445     0.150
    79.874   725.585     0.150
    79.874   732.585     0.150
    80.297   728.376     0.150
    80.301   728.285     0.150
    80.279   729.685     0.150
    80.467   729.495     0.150
    80.509   731.185     0.150
    80.509   914.085     0.150
    80.509   729.980     0.150
    80.509   729.065     0.150
    80.513   731.685     0.150
    80.714   731.854     0.150
    80.718   729.833     0.150
    80.718   914.133     0.150
    80.718  1338.435     0.150
    80.718  1842.985     0.150
    80.718  1855.435     0.150
    80.718  2336.285     0.150
    80.718   728.275     0.150
    80.665   730.385     0.150
    80.703   730.185     0.150
    80.703  1337.785     0.150
    80.951   733.285     0.150
    81.198   733.405     0.150
    81.161   732.885     0.150
    81.161   743.285     0.150
    81.161   923.885     0.150
    81.161  1337.885     0.150
    81.161  1397.885     0.150
    81.170   733.785     0.150
    81.227   735.385     0.150
    81.468   736.285     0.150
    81.557   734.455     0.150
    81.773   737.385     0.150
    81.794   737.985     0.150
    82.069   739.385     0.150
    82.402   741.885     0.150
    82.470   740.785     0.150
    82.538   740.925     0.150
    82.538  1358.785     0.150
    82.596   743.343     0.150
    82.596   743.785     0.150
    82.764   742.785     0.150
    82.784   742.585     0.150
    82.837  1381.335     0.150
    82.878   747.785     0.150
    82.936   744.115     0.150
    83.003   749.185     0.150
    83.034   936.885     0.150
    83.034  1362.485     0.150
    83.135   743.905     0.150
    83.071   743.985     0.150
    83.114   747.185     0.150
    83.126   745.095     0.150
    83.224   748.845     0.150
    83.283   744.385     0.150
    83.319   748.845     0.150
    83.361   749.645     0.150
    83.395   747.485     0.150
    83.395   746.885     0.150
    83.394   747.964     0.150
    83.489   746.901     0.150
    83.489   750.085     0.150
    83.608   751.285     0.150
    83.673   748.885     0.150
    83.673   748.185     0.150
    83.717   749.085     0.150
    83.765   745.781     0.150
    83.765  1367.010     0.150
    83.765   747.285     0.150
    83.765   934.365     0.150
    83.766   747.415     0.150
    83.766  1367.525     0.150
    83.756   746.985     0.150
    83.868   754.475     0.150
    83.868  1391.735     0.150
    83.868   752.715     0.150
    83.868  1384.305     0.150
    83.938   748.855     0.150
    83.938  1367.345     0.150
    83.974   755.445     0.150
    83.974  1391.735     0.150
    83.974   754.945     0.150
    83.974  1384.915     0.150
    83.974   751.445     0.150
    84.035   748.985     0.150
    84.060   749.085     0.150
    84.060   748.285     0.150
    84.060   944.404     0.150
    84.060  1845.885     0.150
    84.060  2327.885     0.150
    84.060   748.585     0.150
    84.060   747.945     0.150
    84.110   750.385     0.150
    84.140   749.195     0.150
    84.140  1370.595     0.150
    84.156   750.185     0.150
    84.225   749.585     0.150
    84.261   750.485     0.150
    84.261   751.085     0.150
    84.301   749.585     0.150
    84.386   751.285     0.150
    84.437   750.185     0.150
    84.458   750.885     0.150
    84.488   750.985     0.150
    84.488   752.585     0.150
    84.488  1368.505     0.150
    84.488  1707.145     0.150
    84.497   751.135     0.150
    84.497  1369.895     0.150
    84.497  1703.405     0.150
    84.507   751.485     0.150
    84.507  1373.855     0.150
    84.507   751.285     0.150
    84.510   751.285     0.150
    84.533   751.285     0.150
    84.683   751.601     0.150
    84.629   751.485     0.150
    84.668   752.335     0.150
    84.668  1372.565     0.150
    84.675   751.685     0.150
    84.684   752.385     0.150
    84.684   755.254     0.150
    84.684   752.085     0.150
    84.684   754.856     0.150
    84.798   752.285     0.150
    84.871   752.485     0.150
    84.981   754.185     0.150
    84.981   753.485     0.150
    85.163   753.435     0.150
    85.163   952.808     0.150
    85.163  1841.810     0.150
    85.163   753.585     0.150
    85.263   753.685     0.150
    85.306   754.885     0.150
    85.314   757.383     0.150
    85.314   754.485     0.150
    85.424   755.285     0.150
    85.424  1841.735     0.150
    85.436   754.785     0.150
    85.436   756.805     0.150
    85.450   754.660     0.150
    85.450   955.010     0.150
    85.450  1383.060     0.150
    85.450  2326.334     0.150
    85.450   754.385     0.150
    85.450   754.985     0.150
    85.534   755.785     0.150
    85.600   756.885     0.150
    85.600  1386.885     0.150
    85.600  1396.885     0.150
    85.600  1450.885     0.150
    85.718   756.585     0.150
    85.975   758.525     0.150
    85.975  1381.395     0.150
    85.975  1736.705     0.150
    86.084   757.685     0.150
    86.120   757.885     0.150
    86.120  1064.885     0.150
    86.120  1394.885     0.150
    86.247   760.525     0.150
    86.302   758.485     0.150
    86.320   760.685     0.150
    86.344   761.485     0.150
    86.351   761.325     0.150
    86.374   762.385     0.150
    86.374  1377.885     0.150
    86.374  1398.885     0.150
    86.392   761.716     0.150
    86.408   763.685     0.150
    86.455   762.754     0.150
    86.432   763.485     0.150
    86.474   761.611     0.150
    86.613   763.285     0.150
    86.709   762.614     0.150
    86.761   763.901     0.150
    86.771   763.785     0.150
    86.816   764.285     0.150
    86.902   762.423     0.150
    86.866   765.285     0.150
    86.887   761.985     0.150
    87.028   765.010     0.150
    87.028  1392.535     0.150
    87.028  2324.459     0.150
    87.028   765.305     0.150
    87.028  1415.655     0.150
    87.028  1411.195     0.150
    87.038   762.685     0.150
    87.125   768.754     0.150
    87.127   765.451     0.150
    87.154   765.451     0.150
    87.154   767.285     0.150
    87.180   766.147     0.150
    87.182   764.870     0.150
    87.274   766.716     0.150
    87.290   764.485     0.150
    87.291   767.285     0.150
    87.296   762.985     0.150
    87.296   767.885     0.150
    87.315   767.985     0.150
    87.325   768.654     0.150
    87.363   764.824     0.150
    87.420   769.397     0.150
    87.487   768.685     0.150
    87.536   767.685     0.150
    87.561   766.235     0.150
    87.624   769.905     0.150
    87.674   769.585     0.150
    87.699   768.434     0.150
    87.765   768.685     0.150
    87.806   767.295     0.150
    87.806  1401.065     0.150
    87.806  1769.885     0.150
    87.798   767.985     0.150
    87.811   769.044     0.150
    87.894   771.185     0.150
    87.932   767.815     0.150
    87.945   769.480     0.150
    87.972   771.185     0.150
    88.014   769.011     0.150
    88.070   768.755     0.150
    88.078   766.985     0.150
    88.093   769.674     0.150
    88.093   770.985     0.150
    88.120   770.335     0.150
    88.104   768.785     0.150
    88.104   771.385     0.150
    88.207   770.425     0.150
    88.242   771.736     0.150
    88.309   769.546     0.150
    88.298   771.682     0.150
    88.325   770.265     0.150
    88.325   976.735     0.150
    88.325  1416.935     0.150
    88.325  1778.605     0.150
    88.326   773.085     0.150
    88.370   769.385     0.150
    88.370  1416.185     0.150
    88.409   772.385     0.150
    88.438   775.685     0.150
    88.454   773.485     0.150
    88.615   768.898     0.150
    88.615  1397.998     0.150
    88.615  1834.473     0.150
    88.615  2320.598     0.150
    88.475   773.585     0.150
    88.544   770.235     0.150
    88.592   772.433     0.150
    88.606   773.038     0.150
    88.630   771.584     0.150
    88.638   773.185     0.150
    88.638   774.985     0.150
    88.645   775.348     0.150
    88.646   771.655     0.150
    88.646   770.785     0.150
    88.646   979.465     0.150
    88.651   771.345     0.150
    88.653   772.852     0.150
    88.744   771.405     0.150
    88.744   978.375     0.150
    88.744  1405.985     0.150
    88.769   774.385     0.150
    88.783   774.985     0.150
    88.833   774.685     0.150
    88.847   769.285     0.150
    88.847   770.185     0.150
    88.888   774.704     0.150
    88.893  1408.885     0.150
    88.904   774.613     0.150
    88.942   774.185     0.150
    89.308   771.915     0.150
    89.003   775.785     0.150
    89.363   777.555     0.150
    89.111   772.785     0.150
    89.111  1408.455     0.150
    89.126   776.185     0.150
    89.214   774.875     0.150
    89.214  1407.455     0.150
    89.242   774.851     0.150
    89.256   776.246     0.150
    89.273   775.785     0.150
    89.310   776.385     0.150
    89.541   774.665     0.150
    89.340   776.137     0.150
    89.343   776.785     0.150
    89.555   775.075     0.150
    89.349   776.985     0.150
    89.414   776.085     0.150
    89.414   777.785     0.150
    89.438   775.920     0.150
    89.513   776.674     0.150
    89.564   775.185     0.150
    89.588   771.685     0.150
    89.588   777.980     0.150
    89.588   777.785     0.150
    89.649   777.585     0.150
    89.697   778.785     0.150
    89.821   776.185     0.150
    89.821  1830.935     0.150
    89.754   774.085     0.150
    89.772   776.885     0.150
    89.772  1427.385     0.150
    89.790   778.285     0.150
    89.845   776.655     0.150
    89.859   779.585     0.150
    89.886   775.785     0.150
    89.884   774.885     0.150
    89.933   778.038     0.150
    90.040   779.289     0.150
    90.041   779.085     0.150
    90.077   776.985     0.150
    90.366   776.215     0.150
    90.106   778.885     0.150
    90.129   779.653     0.150
    90.229   779.985     0.150
    90.229  1007.385     0.150
    90.229  1442.085     0.150
    90.229  1801.785     0.150
    90.269   779.082     0.150
    90.269   782.896     0.150
    90.273   784.185     0.150
    90.296   777.985     0.150
    90.296  1428.485     0.150
    90.296  1793.985     0.150
    90.342   779.175     0.150
    90.342   991.455     0.150
    90.342  1412.715     0.150
    90.348   782.185     0.150
    90.348  1429.585     0.150
    90.361   782.385     0.150
    90.430   780.385     0.150
    90.691   787.185     0.150
    90.691  1442.585     0.150
    90.554   782.985     0.150
    90.786   780.985     0.150
    90.611   778.085     0.150
    90.672   778.585     0.150
    90.712   782.259     0.150
    90.972   788.885     0.150
    90.772   784.285     0.150
    91.012   788.885     0.150
    90.803   783.485     0.150
    90.803   783.849     0.150
    90.820   781.392     0.150
    90.998   782.738     0.150
    91.016   780.603     0.150
    91.065   782.885     0.150
    91.070   784.185     0.150
    91.091   783.285     0.150
    91.104   784.785     0.150
    91.143   784.485     0.150
    91.199   784.045     0.150
    91.230   783.285     0.150
    91.230   786.385     0.150
    91.230   785.252     0.150
    91.222   783.985     0.150
    91.271   785.685     0.150
    91.319   783.485     0.150
    91.319   786.885     0.150
    91.340   784.085     0.150
    91.340  1436.385     0.150
    91.340  1816.885     0.150
    91.342   785.102     0.150
    91.416   783.985     0.150
    91.416  1435.885     0.150
    91.416  1808.185     0.150
    91.428   785.685     0.150
    91.491   785.985     0.150
    91.502   786.385     0.150
    91.546   781.985     0.150
    91.548   785.379     0.150
    91.566   784.745     0.150
    91.566  1424.005     0.150
    91.567   785.285     0.150
    91.595   785.385     0.150
    91.708   786.528     0.150
    91.722   786.685     0.150
    91.771   786.685     0.150
    91.810   786.985     0.150
    91.815   783.985     0.150
    91.838   786.185     0.150
    91.860   791.085     0.150
    91.863   784.485     0.150
    91.893   787.485     0.150
    91.900   787.785     0.150
    91.914   784.485     0.150
    91.939   789.385     0.150
    91.944   787.385     0.150
    91.964   788.385     0.150
    91.972   789.885     0.150
    91.972  1439.185     0.150
    91.995   787.585     0.150
    92.034   788.065     0.150
    92.034   789.898     0.150
    92.041   787.485     0.150
    92.050   788.085     0.150
    92.084   787.225     0.150
    92.084  1427.435     0.150
    92.103   785.985     0.150
    92.103   785.668     0.150
    92.103  1007.360     0.150
    92.103  1824.835     0.150
    92.227   787.285     0.150
    92.227  1008.135     0.150
    92.195   785.265     0.150
    92.231   784.585     0.150
    92.233   789.385     0.150
    92.257   789.385     0.150
    92.331   789.385     0.150
    92.374   787.985     0.150
    92.387   787.785     0.150
    92.394   788.985     0.150
    92.440   792.885     0.150
    92.440  1420.985     0.150
    92.457   789.085     0.150
    92.478   785.885     0.150
    92.536   790.385     0.150
    92.536  1463.785     0.150
    92.546     8.000     0.150
    92.559   789.185     0.150
    92.575   786.685     0.150
    92.596   790.445     0.150
    92.596  1426.115     0.150
    92.596  1836.625     0.150
    92.725   792.951     0.150
    92.789   790.695     0.150
    92.789  1432.605     0.150
    92.832   791.985     0.150
    92.935   790.985     0.150
    92.935  1821.785     0.150
    92.880   790.485     0.150
    92.898   790.085     0.150
    92.906   789.785     0.150
    93.022  1445.960     0.150
    93.022  1528.148     0.150
    92.924   790.485     0.150
    92.937   791.327     0.150
    92.937  1024.585     0.150
    92.937  1462.785     0.150
    92.937  1836.485     0.150
    92.936   788.785     0.150
    92.980   789.985     0.150
    92.983   790.635     0.150
    92.983  1020.395     0.150
    92.983  1434.085     0.150
    93.102   794.009     0.150
    93.102  1539.484     0.150
    93.044   792.785     0.150
    93.080   793.285     0.150
    93.083   790.285     0.150
    93.092   789.385     0.150
    93.149   790.485     0.150
    93.150   793.185     0.150
    93.154   796.685     0.150
    93.154  1024.585     0.150
    93.154  1468.885     0.150
    93.154  1838.685     0.150
    93.173   793.885     0.150
    93.174   789.785     0.150
    93.261   794.215     0.150
    93.261  1430.425     0.150
    93.254   789.985     0.150
    93.255   795.930     0.150
    93.260   789.085     0.150
    93.260   794.185     0.150
    93.303   797.385     0.150
    93.303  1848.685     0.150
    93.303     4.600     0.150
    93.356   793.485     0.150
    93.353   795.665     0.150
    93.337   794.585     0.150
    93.337  1446.185     0.150
    93.361   792.085     0.150
    93.361  1461.889     0.150
    93.361  1839.923     0.150
    93.361   794.785     0.150
    93.364   794.385     0.150
    93.367   793.485     0.150
    93.488   794.488     0.150
    93.488  1530.982     0.150
    93.395   796.275     0.150
    93.395  1432.905     0.150
    93.395  1847.005     0.150
    93.505   797.840     0.150
    93.505  1529.565     0.150
    93.427   794.035     0.150
    93.427  1015.565     0.150
    93.427  1439.625     0.150
    93.427  1851.345     0.150
    93.456   791.285     0.150
    93.482   798.785     0.150
    93.488   794.085     0.150
    93.488  1836.585     0.150
    93.488     9.000     0.150
    93.488  1440.085     0.150
    93.497   793.485     0.150
    93.506   796.985     0.150
    93.528   799.355     0.150
    93.541   794.325     0.150
    93.541  1436.995     0.150
    93.540   796.085     0.150
    93.556   795.385     0.150
    93.559   798.885     0.150
    93.559  1832.885     0.150
    93.559  1028.985     0.150
    93.559  1465.585     0.150
    93.559  1845.485     0.150
    93.567   793.385     0.150
    93.567  1442.185     0.150
    93.567  1837.485     0.150
    93.571   792.685     0.150
    93.721   799.756     0.150
    93.721  1461.547     0.150
    93.721  1533.816     0.150
    93.620   794.485     0.150
    93.620  1835.685     0.150
    93.620     5.400     0.150
    93.639   799.951     0.150
    93.639  1473.955     0.150
    93.646   795.685     0.150
    93.653   795.485     0.150
    93.675   794.905     0.150
    93.675  1028.685     0.150
    93.675  1469.785     0.150
    93.675  1844.785     0.150
    93.691   795.085     0.150
    93.721   795.085     0.150
    93.725   797.085     0.150
    93.727  1456.085     0.150
    93.746   799.045     0.150
    93.778   797.285     0.150
    93.788   791.985     0.150
    93.980   796.404     0.150
    93.980  1533.816     0.150
    93.881   798.985     0.150
    93.881  1029.085     0.150
    93.881  1468.885     0.150
    93.881  1848.585     0.150
    93.966   796.785     0.150
    93.966   797.217     0.150
    94.145   799.277     0.150
    94.145  1457.296     0.150
    94.145  1535.233     0.150
    94.159   798.295     0.150
    94.159  1535.233     0.150
    94.085   795.085     0.150
    94.085   798.280     0.150
    94.085   798.985     0.150
    94.100   798.985     0.150
    94.104   794.585     0.150
    94.140   794.885     0.150
    94.156   798.885     0.150
    94.162   797.985     0.150
    94.162   795.485     0.150
    94.184   800.185     0.150
    94.193   795.285     0.150
    94.198   799.385     0.150
    94.208   795.385     0.150
    94.208   799.785     0.150
    94.211   798.185     0.150
    94.223   797.235     0.150
    94.223  1023.865     0.150
    94.231   799.885     0.150
    94.357   802.629     0.150
    94.378   798.798     0.150
    94.378  1461.547     0.150
    94.378  1538.067     0.150
    94.267   798.485     0.150
    94.380   799.756     0.150
    94.380  1465.799     0.150
    94.380  1538.067     0.150
    94.381   802.629     0.150
    94.381  1467.216     0.150
    94.381  1543.735     0.150
    94.287   796.785     0.150
    94.287   799.075     0.150
    94.289   799.885     0.150
    94.324   797.485     0.150
    94.360   797.685     0.150
    94.360  1860.885     0.150
    94.360     5.800     0.150
    94.380   800.385     0.150
    94.544   800.235     0.150
    94.544  1468.633     0.150
    94.544  1538.067     0.150
    94.448   796.885     0.150
    94.448   800.685     0.150
    94.475   803.385     0.150
    94.475  1846.085     0.150
    94.475     5.100     0.150
    94.484   798.985     0.150
    94.489   800.285     0.150
    94.506   802.932     0.150
    94.566   802.485     0.150
    94.566  1846.985     0.150
    94.707   801.504     0.150
    94.707  1481.386     0.150
    94.601   802.922     0.150
    94.618   796.685     0.150
    94.618   801.385     0.150
    94.640   798.875     0.150
    94.636   798.285     0.150
    94.773   802.629     0.150
    94.773  1471.467     0.150
    94.687   799.485     0.150
    94.687  1466.485     0.150
    94.687   803.685     0.150
    94.687  1870.885     0.150
    94.718   799.195     0.150
    94.718   805.025     0.150
    94.718  1470.885     0.150
    94.718  1542.885     0.150
    94.718  1812.555     0.150
    94.718  1848.885     0.150
    94.718  2311.595     0.150
    94.723   802.985     0.150
    94.723  1851.585     0.150
    94.794   802.215     0.150
    94.798   802.385     0.150
    94.798   801.561     0.150
    94.803   803.275     0.150
    94.960   805.502     0.150
    94.960  1470.050     0.150
    94.856   802.895     0.150
    94.856  1448.255     0.150
    95.003   804.066     0.150
    95.003  1468.633     0.150
    94.970   800.314     0.150
    94.970  1029.964     0.150
    94.970  1815.080     0.150
    94.970   800.875     0.150
    94.973   798.485     0.150
    95.043   803.275     0.150
    95.043  1030.605     0.150
    95.043   800.085     0.150
    95.051   804.772     0.150
    95.051  1036.431     0.150
    95.174   805.023     0.150
    95.174  1484.220     0.150
    95.174  1560.740     0.150
    95.103   799.885     0.150
    95.103  1473.885     0.150
    95.103   804.885     0.150
    95.103     9.000     0.150
    95.103  1457.885     0.150
    95.103  1551.885     0.150
    95.103  1858.885     0.150
    95.103  2304.885     0.150
    95.127   806.085     0.150
    95.127  1455.385     0.150
    95.127  1876.185     0.150
    95.238   805.085     0.150
    95.393  1480.103     0.150
    95.393  1564.991     0.150
    95.414   807.896     0.150
    95.414  1462.964     0.150
    95.357   802.815     0.150
    95.383   805.915     0.150
    95.587   808.375     0.150
    95.587  1563.574     0.150
    95.566   807.053     0.150
    95.670  1879.572     0.150
    95.570   802.745     0.150
    95.587   802.585     0.150
    95.587     7.200     0.150
    95.587  1865.485     0.150
    95.587   802.485     0.150
    95.618   803.185     0.150
    95.618  1034.898     0.150
    95.618  1813.735     0.150
    95.618  2309.610     0.150
    95.618   802.885     0.150
    95.634   807.882     0.150
    95.672   809.085     0.150
    95.653  1030.185     0.150
    95.800   809.333     0.150
    95.800  1475.718     0.150
    95.800  1564.991     0.150
    95.844   805.185     0.150
    95.844  1874.085     0.150
    95.899   806.985     0.150
    95.936   810.185     0.150
    95.937  1042.291     0.150
    96.078   807.985     0.150
    96.091   808.815     0.150
    96.091  1043.105     0.150
    96.118   808.885     0.150
    96.118  1043.625     0.150
    96.118  1451.575     0.150
    96.118  1479.355     0.150
    96.118  1882.075     0.150
    96.145   808.285     0.150
    96.262  1572.076     0.150
    96.206   805.645     0.150
    96.292   805.785     0.150
    96.429   810.291     0.150
    96.429  1482.803     0.150
    96.429  1570.659     0.150
    96.403   807.985     0.150
    96.457   808.653     0.150
    96.477   811.452     0.150
    96.489   809.345     0.150
    96.517   810.985     0.150
    96.563   810.425     0.150
    96.897   808.885     0.150
    96.889   810.545     0.150
    97.165  1499.285     0.150
    97.188   809.885     0.150
    97.153   813.353     0.150
    97.441   811.877     0.150
    97.504   815.491     0.150
    97.504  1053.483     0.150
    97.513   815.820     0.150
    97.687   813.030     0.150
    97.789   817.816     0.150
    97.789  1056.737     0.150
    97.804   816.920     0.150
    97.838   809.275     0.150
    97.999   813.944     0.150
    98.028   813.039     0.150
    97.959   817.507     0.150
    97.959  1058.262     0.150
    98.169   818.152     0.150
    98.169  1059.307     0.150
    98.203   818.185     0.150
    98.317   814.541     0.150
    98.408   816.190     0.150
    98.500   816.610     0.150
    98.547   816.623     0.150
    98.588   821.930     0.150
    98.588  1062.040     0.150
    98.720   824.755     0.150
    98.755   817.105     0.150
    99.037   818.796     0.150
    99.116   818.483     0.150
    99.211   818.809     0.150
    99.385   820.309     0.150
    99.412   820.305     0.150
    99.459   819.221     0.150
    99.623   821.416     0.150
    99.775   820.405     0.150
    99.775  1802.505     0.150
    99.775  2296.655     0.150
    99.745   821.699     0.150
   100.047   822.013     0.150
    99.947   819.035     0.150
   100.106   822.264     0.150
   100.238   824.993     0.150
   100.272   823.860     0.150
   100.324   824.536     0.150
   100.535   825.431     0.150
   100.538   825.611     0.150
   100.612   824.885     0.150
   100.789   825.752     0.150
   100.816   825.808     0.150
   100.973   828.024     0.150
   100.973  1074.147     0.150
   100.973  2297.731     0.150
   100.973   827.300     0.150
   100.973   827.585     0.150
   101.000   831.185     0.150
   101.205   825.285     0.150
   101.275   825.945     0.150
   101.437   830.079     0.150
   101.396   826.605     0.150
   101.971   828.915     0.150
   102.342   835.560     0.150
   102.342  1095.260     0.150
   102.342  1798.285     0.150
   102.342  2295.785     0.150
   102.369   830.495     0.150
   102.940   832.455     0.150
   103.084   834.155     0.150
   103.124   833.845     0.150
   103.158   833.845     0.150
   103.445   835.075     0.150
   103.557   838.945     0.150
   103.622   839.085     0.150
   103.622  1096.935     0.150
   103.651   836.435     0.150
   104.638   844.278     0.150
   104.677   845.135     0.150
   104.677  1102.735     0.150
   104.677  1790.560     0.150
   104.648   840.335     0.150
   105.045   845.914     0.150
   105.202   848.145     0.150
   105.202  1101.539     0.150
   105.300   850.280     0.150
   105.319   849.911     0.150
   105.307   849.039     0.150
   105.537   849.553     0.150
   105.498   851.035     0.150
   105.498  1673.175     0.150
   105.686   850.598     0.150
   105.690   851.766     0.150
   105.728   852.621     0.150
   105.741   850.124     0.150
   105.741  1112.072     0.150
   105.661   845.115     0.150
   105.925   851.045     0.150
   105.968   852.275     0.150
   105.977   852.306     0.150
   106.390   853.065     0.150
   106.412   853.889     0.150
   106.419   853.125     0.150
   106.373  1783.704     0.150
   106.562   854.546     0.150
   106.625   855.817     0.150
   106.625   853.855     0.150
   106.707   854.055     0.150
   106.778   854.968     0.150
   106.791   855.745     0.150
   106.847   857.356     0.150
   106.933   857.195     0.150
   107.113   858.302     0.150
   107.156   856.826     0.150
   107.239   859.311     0.150
   107.222   856.877     0.150
   107.476   859.372     0.150
   107.551   859.906     0.150
   107.624   860.385     0.150
   107.666   860.112     0.150
   107.701   860.562     0.150
   107.919   860.986     0.150
   108.008   861.819     0.150
   108.035   860.323     0.150
   108.102   860.151     0.150
   108.184   860.297     0.150
   108.279   861.648     0.150
   108.356   863.385     0.150
   108.356  1106.087     0.150
   108.356  1128.087     0.150
   108.356  1779.235     0.150
   108.438   861.564     0.150
   108.643  1776.105     0.150
   108.673   860.785     0.150
   108.780   862.204     0.150
   108.837   863.084     0.150
   108.844   862.703     0.150
   108.887   863.572     0.150
   108.957   863.689     0.150
   109.488   865.081     0.150
   109.519   865.525     0.150
   109.575   866.028     0.150
   110.264   868.417     0.150
   110.217   870.015     0.150
   110.217  1720.705     0.150
   110.260   871.815     0.150
   110.260  1719.175     0.150
   110.441   872.336     0.150
   110.441   871.627     0.150
   110.441  1108.502     0.150
   110.441  1145.227     0.150
   110.441  1771.277     0.150
   110.441  2000.652     0.150
   110.441   870.555     0.150
   110.632   871.468     0.150
   110.727   871.584     0.150
   110.737   872.960     0.150
   110.737  1109.135     0.150
   110.737  1769.510     0.150
   110.825   871.410     0.150
   110.940   874.033     0.150
   111.070   874.342     0.150
   111.070  1110.946     0.150
   111.070  1151.185     0.150
   111.070  1768.635     0.150
   111.588   876.066     0.150
   111.641   875.314     0.150
   111.570  1115.385     0.150
   111.570  1162.185     0.150
   111.570  2096.185     0.150
   112.055   878.078     0.150
   112.177   878.603     0.150
   112.125  1165.985     0.150
   112.125  2106.385     0.150
   112.298   879.723     0.150
   112.458  1113.971     0.150
   112.458   882.606     0.150
   112.471  1116.479     0.150
   112.380  1114.685     0.150
   112.380  1167.685     0.150
   112.380  2108.385     0.150
   112.484   880.428     0.150
   112.393  1167.685     0.150
   112.460  1112.385     0.150
   112.460  1167.585     0.150
   112.460  2114.584     0.150
   112.472  1168.185     0.150
   112.734   883.745     0.150
   112.734  1733.175     0.150
   112.874   880.796     0.150
   112.936   880.181     0.150
   112.896   886.185     0.150
   112.896  1119.985     0.150
   112.896  1171.785     0.150
   112.896  2118.084     0.150
   112.919  1119.985     0.150
   112.919  1171.085     0.150
   112.977   884.295     0.150
   112.977  1744.125     0.150
   113.263   881.915     0.150
   113.189  1116.885     0.150
   113.189  1169.185     0.150
   113.381  1116.685     0.150
   113.381  1174.185     0.150
   113.541   888.285     0.150
   113.541  1116.485     0.150
   113.541  1178.185     0.150
   113.541  2122.485     0.150
   113.742   884.787     0.150
   113.687  1117.085     0.150
   113.687  1176.785     0.150
   113.687  2122.985     0.150
   113.747  1751.785     0.150
   113.898  1117.685     0.150
   113.898  1174.885     0.150
   114.087  1751.985     0.150
   114.114  1118.185     0.150
   114.114  1177.285     0.150
   114.114  2127.084     0.150
   114.280  1183.585     0.150
   114.362   887.043     0.150
   114.303  1119.485     0.150
   114.303  1178.885     0.150
   114.303  1755.295     0.150
   114.510  1120.785     0.150
   114.510  1180.685     0.150
   114.670   886.973     0.150
   114.800   891.488     0.150
   114.781  1123.685     0.150
   114.781  1185.685     0.150
   114.781  2144.485     0.150
   114.859  1118.635     0.150
   114.859  1764.260     0.150
   114.838  1117.485     0.150
   114.838  1177.885     0.150
   114.838  2137.084     0.150
   114.845   889.335     0.150
   114.845  1119.025     0.150
   114.845  1177.505     0.150
   114.845  2133.095     0.150
   114.853  1119.785     0.150
   114.853  1182.785     0.150
   114.853  2136.285     0.150
   114.879  1119.585     0.150
   114.879  2144.385     0.150
   115.019   890.778     0.150
   114.901   889.585     0.150
   114.901  1177.895     0.150
   114.901  2133.834     0.150
   115.013  1186.585     0.150
   115.013  2145.985     0.150
   115.342  1120.985     0.150
   115.342  1184.185     0.150
   115.438   891.855     0.150
   115.438  1120.125     0.150
   115.438  1181.565     0.150
   115.868   896.172     0.150
   116.276   896.152     0.150
   116.566   896.722     0.150
   116.684   898.181     0.150
   117.010  1121.790     0.150
   117.188  1123.228     0.150
   117.462  1124.240     0.150
   117.679  1126.253     0.150
   117.731  1126.484     0.150
   117.917  1126.508     0.150
   118.141  1127.182     0.150
   118.152  1127.150     0.150
   118.313  1126.579     0.150
   118.342  1127.509     0.150
   118.351   907.536     0.150
   118.351  1125.177     0.150
   118.351  1198.085     0.150
   118.351  1747.185     0.150
   118.351  1125.355     0.150
   118.351  1196.925     0.150
   118.440  1126.712     0.150
   118.499  1126.533     0.150
   118.615  1126.441     0.150
   118.662  1127.191     0.150
   118.797  1126.778     0.150
   118.821  1125.581     0.150
   119.011  1128.516     0.150
   119.094  1126.718     0.150
   119.164  1126.194     0.150
   119.173  1127.507     0.150
   119.284  1126.764     0.150
   119.324  1128.093     0.150
   119.570  1128.575     0.150
   119.710   913.010     0.150
   119.710  1128.487     0.150
   119.710  1208.937     0.150
   119.710  1741.085     0.150
   119.710  1129.005     0.150
   119.678  1128.147     0.150
   119.681  1127.837     0.150
   119.689  1126.899     0.150
   119.690  1126.575     0.150
   119.695  1127.204     0.150
   119.829  1129.069     0.150
   119.881  1128.010     0.150
   119.861  1129.484     0.150
   119.931  1129.567     0.150
   119.998  1129.379     0.150
   120.029  1128.821     0.150
   120.046  1130.105     0.150
   120.089  1129.263     0.150
   120.116  1129.641     0.150
   120.218  1131.147     0.150
   120.273  1129.575     0.150
   120.401  1130.793     0.150
   120.467  1129.682     0.150
   120.478  1130.936     0.150
   120.497  1128.764     0.150
   120.571  1130.496     0.150
   120.634  1132.351     0.150
   120.692  1129.418     0.150
   120.709  1131.060     0.150
   120.780  1133.109     0.150
   120.808  1132.215     0.150
   120.871  1132.633     0.150
   120.926  1131.823     0.150
   120.958  1133.251     0.150
   120.984  1131.940     0.150
   120.999  1131.934     0.150
   121.035  1130.129     0.150
   121.097  1131.860     0.150
   121.114  1132.492     0.150
   121.133  1131.238     0.150
   121.268  1132.432     0.150
   121.676  1133.152     0.150
   121.279  1132.765     0.150
   121.315  1132.256     0.150
   121.324  1132.586     0.150
   121.359  1132.312     0.150
   121.450  1130.548     0.150
   121.450  1133.109     0.150
   121.478  1131.581     0.150
   121.488  1132.889     0.150
   121.531  1132.629     0.150
   121.547  1132.985     0.150
   121.572  1132.735     0.150
   121.565  1132.364     0.150
   121.578  1131.764     0.150
   121.596  1131.765     0.150
   121.691  1131.397     0.150
   121.748  1131.090     0.150
   121.807  1131.291     0.150
   121.840  1131.934     0.150
   121.853  1134.229     0.150
   121.867  1133.249     0.150
   121.891  1133.007     0.150
   121.877  1131.338     0.150
   121.955  1133.446     0.150
   122.004  1133.612     0.150
   122.004  1132.385     0.150
   121.991  1133.498     0.150
   122.035  1134.553     0.150
   122.035  1134.537     0.150
   122.080  1134.632     0.150
   122.139  1135.432     0.150
   122.161  1134.505     0.150
   122.150  1134.118     0.150
   122.156  1134.126     0.150
   122.184  1134.538     0.150
   122.209  1133.904     0.150
   122.271  1134.092     0.150
   122.296  1136.040     0.150
   122.286  1135.004     0.150
   122.284  1133.068     0.150
   122.357  1135.265     0.150
   122.370  1136.800     0.150
   122.388  1134.902     0.150
   122.398  1134.613     0.150
   122.423  1135.328     0.150
   122.476  1135.541     0.150
   122.427  1135.590     0.150
   122.474  1133.124     0.150
   122.498  1135.799     0.150
   122.491  1135.738     0.150
   122.555  1136.159     0.150
   122.576  1135.275     0.150
   122.637  1136.452     0.150
   122.614  1135.322     0.150
   122.640  1135.071     0.150
   122.641  1135.384     0.150
   122.651  1135.424     0.150
   122.734  1135.269     0.150
   122.726  1133.619     0.150
   122.742  1136.252     0.150
   122.759  1136.225     0.150
   122.806  1135.742     0.150
   122.825  1136.435     0.150
   122.826  1136.346     0.150
   122.892  1136.842     0.150
   122.917  1136.243     0.150
   122.931  1136.545     0.150
   122.977  1139.485     0.150
   122.977  1236.685     0.150
   123.054  1134.918     0.150
   123.056  1136.505     0.150
   122.991  1139.485     0.150
   122.991  1237.085     0.150
   123.094  1136.561     0.150
   123.147  1136.511     0.150
   123.115  1136.006     0.150
   123.107  1135.632     0.150
   123.102  1136.887     0.150
   123.182  1135.486     0.150
   123.170  1136.062     0.150
   123.178  1136.095     0.150
   123.212  1137.871     0.150
   123.244  1135.297     0.150
   123.313  1136.744     0.150
   123.300  1136.298     0.150
   123.335  1137.356     0.150
   123.381  1136.460     0.150
   123.379  1137.722     0.150
   123.397  1137.757     0.150
   123.453  1136.615     0.150
   123.465  1136.944     0.150
   123.499  1137.656     0.150
   123.545  1137.534     0.150
   123.585  1137.532     0.150
   123.577  1138.105     0.150
   123.577  1137.085     0.150
   123.577  1243.585     0.150
   123.657  1137.364     0.150
   123.690  1138.139     0.150
   123.671  1137.703     0.150
   123.614  1244.185     0.150
   123.708  1137.402     0.150
   123.727  1136.516     0.150
   123.732  1137.160     0.150
   123.745  1135.888     0.150
   123.751  1138.150     0.150
   123.688  1137.085     0.150
   123.688  1243.685     0.150
   123.772  1137.591     0.150
   123.777  1137.568     0.150
   123.783  1136.571     0.150
   123.852  1138.020     0.150
   123.861  1138.381     0.150
   123.868  1138.056     0.150
   123.863  1138.968     0.150
   123.884  1138.391     0.150
   123.896  1138.707     0.150
   123.918  1139.080     0.150
   123.922  1138.780     0.150
   123.997  1138.329     0.150
   124.029  1134.872     0.150
   124.062  1137.827     0.150
   124.055  1137.737     0.150
   124.072  1137.812     0.150
   124.121  1138.208     0.150
   124.124  1139.161     0.150
   124.137  1138.871     0.150
   124.158  1138.563     0.150
   124.193  1138.698     0.150
   124.195  1138.007     0.150
   124.216  1138.715     0.150
   124.224  1139.068     0.150
   124.213  1137.072     0.150
   124.231  1138.401     0.150
   124.261  1139.745     0.150
   124.360  1139.362     0.150
   124.360  1135.685     0.150
   124.345  1139.593     0.150
   124.368  1139.038     0.150
   124.381  1139.392     0.150
   124.383  1138.720     0.150
   124.434  1139.584     0.150
   124.396  1139.342     0.150
   124.420  1139.449     0.150
   124.418  1138.754     0.150
   124.567  1141.099     0.150
   124.527  1139.588     0.150
   124.550  1138.707     0.150
   124.557  1138.419     0.150
   124.500  1236.985     0.150
   124.579  1140.035     0.150
   124.603  1139.410     0.150
   124.679  1140.528     0.150
   124.680  1137.324     0.150
   124.737  1140.672     0.150
   124.742  1139.727     0.150
   124.682  1237.485     0.150
   124.758  1140.091     0.150
   124.758  1139.406     0.150
   124.795  1139.272     0.150
   124.729  1239.285     0.150
   124.846  1139.585     0.150
   124.800  1139.811     0.150
   124.787  1239.385     0.150
   124.892  1140.341     0.150
   124.885  1138.682     0.150
   124.902  1140.015     0.150
   124.922  1140.417     0.150
   124.924  1139.745     0.150
   124.945  1140.165     0.150
   124.991  1140.182     0.150
   125.006  1137.620     0.150
   125.047  1140.011     0.150
   125.047  1140.003     0.150
   125.190  1140.939     0.150
   125.174  1137.618     0.150
   125.180  1140.523     0.150
   125.228  1141.004     0.150
   125.157  1240.185     0.150
   125.216  1140.600     0.150
   125.266  1141.361     0.150
   125.273  1141.383     0.150
   125.282  1140.091     0.150
   125.302  1140.754     0.150
   125.334  1140.182     0.150
   125.389  1140.311     0.150
   125.409  1142.265     0.150
   125.474  1141.132     0.150
   125.545  1140.962     0.150
   125.476  1244.485     0.150
   125.559  1141.620     0.150
   125.594  1141.652     0.150
   125.624  1141.802     0.150
   125.620  1142.401     0.150
   125.605  1141.013     0.150
   125.654  1141.782     0.150
   125.687  1141.880     0.150
   125.693  1140.543     0.150
   125.701  1141.521     0.150
   125.704  1140.890     0.150
   125.729  1140.342     0.150
   125.760  1141.003     0.150
   125.756  1141.938     0.150
   125.781  1141.375     0.150
   125.781  1140.115     0.150
   125.789  1141.709     0.150
   125.868  1142.506     0.150
   125.836  1248.185     0.150
   125.924  1141.357     0.150
   125.930  1141.672     0.150
   125.954  1141.406     0.150
   125.973  1141.795     0.150
   125.992  1142.092     0.150
   126.018  1142.193     0.150
   126.061  1142.293     0.150
   126.068  1142.254     0.150
   126.086  1142.313     0.150
   126.089  1142.897     0.150
   126.127  1141.412     0.150
   126.199  1141.833     0.150
   126.224  1142.563     0.150
   126.225  1142.530     0.150
   126.247  1142.901     0.150
   126.282  1142.043     0.150
   126.414  1142.594     0.150
   126.442  1142.959     0.150
   126.478  1143.704     0.150
   126.461  1144.571     0.150
   126.475  1140.759     0.150
   126.503  1142.807     0.150
   126.503  1142.477     0.150
   126.515  1143.383     0.150
   126.482  1141.985     0.150
   126.500  1141.360     0.150
   126.500  1256.310     0.150
   126.500  1940.235     0.150
   126.568  1142.868     0.150
   126.579  1143.189     0.150
   126.662  1142.513     0.150
   126.632  1141.039     0.150
   126.642  1143.325     0.150
   126.695  1143.143     0.150
   126.703  1143.750     0.150
   126.718  1143.486     0.150
   126.663  1141.185     0.150
   126.750  1143.223     0.150
   126.760  1143.880     0.150
   126.797  1143.984     0.150
   126.829  1143.752     0.150
   126.824  1143.982     0.150
   126.838  1143.357     0.150
   126.794  1141.485     0.150
   126.885  1144.104     0.150
   126.897  1143.796     0.150
   126.923  1144.232     0.150
   126.908  1143.487     0.150
   126.943  1143.015     0.150
   126.941  1143.605     0.150
   126.975  1144.019     0.150
   127.005  1143.744     0.150
   127.006  1144.023     0.150
   127.012  1141.812     0.150
   127.032  1143.080     0.150
   127.101  1144.880     0.150
   127.103  1143.864     0.150
   127.187  1144.702     0.150
   127.193  1144.695     0.150
   127.213  1144.778     0.150
   127.231  1143.539     0.150
   127.245  1144.856     0.150
   127.272  1144.841     0.150
   127.299  1144.280     0.150
   127.353  1144.348     0.150
   127.359  1145.337     0.150
   127.453  1145.222     0.150
   127.549  1145.109     0.150
   127.557  1145.756     0.150
   127.596  1145.500     0.150
   127.619  1145.837     0.150
   127.664  1145.902     0.150
   127.734  1145.476     0.150
   127.741  1145.443     0.150
   127.757  1145.144     0.150
   127.788  1146.146     0.150
   127.801  1145.884     0.150
   127.812  1145.255     0.150
   127.811  1146.518     0.150
   127.924  1146.419     0.150
   127.938  1147.068     0.150
   127.975  1145.920     0.150
   128.007  1146.614     0.150
   128.053  1146.089     0.150
   128.062  1146.709     0.150
   128.128  1147.134     0.150
   128.124  1146.788     0.150
   128.151  1147.506     0.150
   128.152  1147.166     0.150
   128.220  1147.288     0.150
   128.309  1148.463     0.150
   128.352  1147.528     0.150
   128.366  1147.920     0.150
   128.399  1147.048     0.150
   128.397  1147.311     0.150
   128.419  1147.397     0.150
   128.459  1147.171     0.150
   128.468  1147.454     0.150
   128.858  1147.266     0.150
   128.565  1147.645     0.150
   128.627  1148.090     0.150
   128.786  1148.729     0.150
   128.798  1148.073     0.150
   128.832  1148.806     0.150
   129.170  1148.755     0.150
   128.930  1147.727     0.150
   128.925  1148.960     0.150
   128.974  1150.024     0.150
   129.149  1148.732     0.150
   129.173  1148.184     0.150
   129.171  1148.801     0.150
   129.189  1147.882     0.150
   129.189  1149.757     0.150
   129.212  1147.906     0.150
   129.257  1147.086     0.150
   129.272  1148.331     0.150
   129.289  1148.732     0.150
   129.301  1149.015     0.150
   129.435  1148.714     0.150
   129.508  1149.113     0.150
   129.546  1149.221     0.150
   129.565  1149.852     0.150
   129.589  1149.611     0.150
   129.602  1149.309     0.150
   129.603  1149.273     0.150
   129.642  1149.393     0.150
   129.738  1149.524     0.150
   129.747  1149.562     0.150
   129.849  1149.443     0.150
   129.932  1150.568     0.150
   129.943  1149.598     0.150
   130.008  1150.423     0.150
   130.037  1149.813     0.150
   130.064  1149.563     0.150
   130.125  1150.572     0.150
   130.181  1150.378     0.150
   130.288  1151.227     0.150
   130.309  1150.956     0.150
   130.330  1150.700     0.150
   130.322  1150.630     0.150
   130.366  1151.096     0.150
   130.380  1150.748     0.150
   130.390  1151.757     0.150
   130.410  1150.842     0.150
   130.535  1151.055     0.150
   130.536  1150.729     0.150
   130.539  1151.685     0.150
   130.557  1152.031     0.150
   130.583  1151.516     0.150
   130.667  1151.953     0.150
   130.719  1153.022     0.150
   130.772  1152.765     0.150
   130.830  1152.560     0.150
   130.846  1151.997     0.150
   130.852  1152.962     0.150
   130.949  1150.548     0.150
   130.944  1150.841     0.150
   130.998  1151.931     0.150
   131.082  1152.068     0.150
   131.102  1152.475     0.150
   131.161  1153.529     0.150
   131.178  1152.945     0.150
   131.218  1152.011     0.150
   131.278  1153.437     0.150
   131.368  1152.942     0.150
   131.377  1151.047     0.150
   131.396  1153.320     0.150
   131.480  1154.103     0.150
   131.524  1153.576     0.150
   131.557  1153.326     0.150
   131.635  1153.168     0.150
   131.654  1153.516     0.150
   131.683  1152.891     0.150
   131.700  1153.572     0.150
   131.938  1153.396     0.150
   131.948  1154.384     0.150
   131.945  1152.117     0.150
   132.175  1155.118     0.150
   132.476  1155.368     0.150
   132.795  1155.964     0.150
   133.091  1297.680     0.150
   133.296  1156.272     0.150
   133.916  1157.742     0.150
   134.110  1155.110     0.150
   134.880  1160.183     0.150
   135.201  1160.776     0.150
   135.515  1160.728     0.150
   135.641  1161.594     0.150
   135.944  1161.839     0.150
   136.279  1163.425     0.150
   136.319  1321.133     0.150
   136.305  1163.461     0.150
   136.707  1163.565     0.150
   136.946  1164.651     0.150
   137.786  1163.360     0.150
   137.786  1330.935     0.150
   137.759  1167.111     0.150
   144.649  1175.505     0.150
   144.863  1174.629     0.150
   144.863  1373.779     0.150
   144.863  1174.185     0.150
   144.893  1178.825     0.150
   145.402  1176.965     0.150
   145.457  1175.675     0.150
   145.732  1178.095     0.150
   145.779  1178.205     0.150
   146.690  1178.685     0.150
   146.690  1179.135     0.150
   150.397  1189.030     0.150
   150.397  1188.685     0.150
   151.717  1206.275     0.150
   151.904  1194.755     0.150
   152.002  1192.955     0.150
   152.002  1196.655     0.150
   152.079  1197.645     0.150
   152.116  1197.115     0.150
   152.116  1197.475     0.150
   152.286  1193.045     0.150
   152.293  1194.925     0.150
   152.346  1196.575     0.150
   152.420  1193.655     0.150
   152.352  1197.005     0.150
   152.591  1193.005     0.150
   152.833  1197.055     0.150
   153.190  1186.085     0.150
   153.190  1195.785     0.150
   153.263  1190.845     0.150
   153.591  1199.985     0.150
   153.775  1191.945     0.150
   153.774  1197.815     0.150
   153.799  1200.225     0.150
   154.105  1192.765     0.150
   154.147  1197.575     0.150
   154.430  1199.645     0.150
   154.445  1190.505     0.150
   154.381  1200.665     0.150
   154.612  1194.035     0.150
   154.784  1193.925     0.150
   154.874  1201.545     0.150
   154.970  1194.185     0.150
   154.891  1200.685     0.150
   154.904  1201.695     0.150
   154.904  1200.995     0.150
   155.050  1408.285     0.150
   155.050  2609.084     0.150
   154.918  1200.995     0.150
   154.930  1202.885     0.150
   155.373  1191.025     0.150
   155.447  1192.535     0.150
   155.510  1194.425     0.150
   155.687  1195.315     0.150
   155.714  1195.335     0.150
   155.920  1195.705     0.150
   155.930  1194.695     0.150
   156.210  1196.065     0.150
   156.240  1196.065     0.150
   156.294  1193.980     0.150
   156.379  1196.145     0.150
   156.546  1194.660     0.150
   156.546  1447.360     0.150
   156.792  1196.785     0.150
   156.818  1197.255     0.150
   157.151  1197.265     0.150
   157.503  1197.165     0.150
   157.644  1195.635     0.150
   157.743  1196.985     0.150
   158.260  1196.415     0.150
   158.260  1449.705     0.150
   158.536  1195.205     0.150
   158.645  1196.715     0.150
   158.748  1199.125     0.150
   159.394  1197.379     0.150
   159.741  1196.905     0.150
   159.725  1197.354     0.150
   162.294  1200.780     0.150
   162.294  1247.180     0.150
   162.294  1471.130     0.150
   163.614  1201.110     0.150
   163.614  1252.810     0.150
   163.614  1477.485     0.150
   163.614  1200.385     0.150
   164.728  1201.805     0.150
   164.728  1256.665     0.150
   164.728  1483.245     0.150
   166.560  1204.835     0.150
   166.560  1267.010     0.150
   166.560  1495.610     0.150
   170.050  1206.130     0.150
   170.050  1279.680     0.150
   170.050  1512.130     0.150
   170.050  1204.675     0.150
   170.050  1278.555     0.150
   170.383  1208.025     0.150
   170.383  1282.225     0.150
   170.383  1513.595     0.150
   170.383  1205.085     0.150
   172.166  1207.185     0.150
   172.166  1290.545     0.150
   172.166  1524.565     0.150
   172.809  1207.385     0.150
     0.293     6.197     0.150
     0.293    11.307     0.150
     0.437     8.467     0.150
     0.804    14.747     0.150
     0.804    26.757     0.150
     1.639    27.287     0.150
     3.171    48.817     0.150
     8.677   127.177     0.150
    13.187   183.377     0.150
    13.911   195.557     0.150
    15.422   216.527     0.150
    15.573   218.377     0.150
    18.931   258.477     0.150
    23.648   306.847     0.150
    25.823   328.977     0.150
    25.991   332.522     0.150
    27.643   346.841     0.150
    31.314   377.417     0.150
    34.862   410.891     0.150
    40.658   459.297     0.150
    50.368   535.387     0.150
    51.041   541.868     0.150
    52.173   547.827     0.150
    56.991   583.257     0.150
    68.037   657.867     0.150
    68.285   660.067     0.150
    79.869   725.247     0.150
    80.213   728.437     0.150
    80.329   728.847     0.150
    80.693   732.707     0.150
    82.988   744.547     0.150
    83.482   747.927     0.150
    83.795   748.407     0.150
    83.795   748.406     0.150
    97.186   807.297     0.150
   118.394  1126.400     0.150
   118.395  1126.397     0.150
     0.306    11.398     0.150
     0.764    14.278     0.150
     0.764    25.558     0.150
     1.132    21.258     0.150
    14.782   207.048     0.150
    15.561   218.858     0.150
    18.895   261.648     0.150
    20.112   273.363     0.150
    25.745   328.898     0.150
    25.745   331.149     0.150
    27.501   345.149     0.150
    34.208   405.398     0.150
    34.720   409.335     0.150
    34.842   409.064     0.150
    40.526   458.738     0.150
    48.150   516.278     0.150
    50.931   540.868     0.150
    50.931   540.871     0.150
    51.427   540.898     0.150
    53.351   555.528     0.150
    55.061   569.943     0.150
    55.802   576.158     0.150
    64.933   636.618     0.150
    69.007   663.278     0.150
    69.033   662.098     0.150
    77.640   713.148     0.150
    78.276   716.228     0.150
    79.614   723.458     0.150
    80.002   726.368     0.150
    82.272   738.628     0.150
    82.469   738.858     0.150
    82.830   741.778     0.150
    83.027   742.018     0.150
    83.353   743.858     0.150
    83.525   745.318     0.150
    86.683   760.808     0.150
     0.303     5.556     0.150
     0.303    10.406     0.150
     3.247    51.206     0.150
     3.247    93.076     0.150
    14.465   205.036     0.150
    15.462   220.296     0.150
    18.862   262.456     0.150
    20.026   274.536     0.150
    20.718   281.586     0.150
    20.771   281.756     0.150
    21.206   286.536     0.150
    23.052   309.106     0.150
    23.342   312.436     0.150
    23.373   309.936     0.150
    23.448   310.896     0.150
    23.621   313.196     0.150
    23.718   311.436     0.150
    23.728   313.886     0.150
    24.784   323.706     0.150
    25.719   333.386     0.150
    25.953   334.286     0.150
    25.952   332.236     0.150
    27.593   348.897     0.150
    34.777   411.362     0.150
    34.815   412.711     0.150
    44.714   495.936     0.150
    44.859   494.726     0.150
    50.963   543.866     0.150
    50.963   543.869     0.150
    51.371   545.926     0.150
    51.610   547.106     0.150
    52.096   549.656     0.150
    52.152   549.246     0.150
    53.866   564.624     0.150
    53.868   564.626     0.150
    55.096   571.726     0.150
    55.097   573.866     0.150
    55.699   576.556     0.150
    61.202   615.686     0.150
    63.791   632.211     0.150
    64.972   641.825     0.150
    68.307   660.506     0.150
    68.985   666.416     0.150
    69.217   666.996     0.150
    69.266   668.126     0.150
    76.416   709.666     0.150
    83.521   747.656     0.150
    97.220   815.136     0.150
   146.733  1180.511     0.150
     0.204     4.472     0.150
     0.204     8.062     0.150
     0.636    12.412     0.150
     0.636    21.662     0.150
     1.237    22.672     0.150
     1.237    40.292     0.150
     1.369    43.162     0.150
     3.269    51.652     0.150
    15.065   211.242     0.150
    19.826   272.352     0.150
    23.059   305.542     0.150
    23.237   306.302     0.150
    25.463   329.175     0.150
    25.559   329.202     0.150
    44.419   492.202     0.150
    50.913   539.962     0.150
    50.913   539.960     0.150
    51.917   546.772     0.150
    53.876   562.490     0.150
    53.876   562.092     0.150
    53.878   562.492     0.150
    55.064   571.952     0.150
    55.521   572.892     0.150
    55.611   574.212     0.150
    83.313   746.962     0.150
    83.444   747.112     0.150
    83.870   749.242     0.150
    83.976   748.552     0.150
    85.704   756.392     0.150
    85.841   756.832     0.150
    87.133   765.652     0.150
    88.514   772.052     0.150
     0.352     6.620     0.150
     0.352    13.000     0.150
     0.700    12.980     0.150
     3.249    49.500     0.150
    20.098   274.795     0.150
    25.814   328.480     0.150
    27.510   347.633     0.150
    31.414   379.683     0.150
    31.414   379.680     0.150
    34.275   404.920     0.150
    34.807   409.720     0.150
    34.807   409.170     0.150
    34.725   409.854     0.150
    50.984   540.560     0.150
    50.984   540.563     0.150
    55.112   572.345     0.150
    60.772   611.260     0.150
    63.755   630.095     0.150
    75.733   704.980     0.150
    84.080   751.880     0.150
    84.080   751.877     0.150
    85.122   755.740     0.150
    85.122   755.745     0.150
    85.440   757.047     0.150
   118.421  1126.795     0.150
   118.422  1126.790     0.150
   119.551  1129.618     0.150
   146.752  1181.070     0.150
     0.763    14.860     0.150
     0.763    25.190     0.150
     1.965    32.540     0.150
     1.965    59.460     0.150
     2.782    44.760     0.150
     3.247    49.865     0.150
     3.247    48.290     0.150
     8.430   123.020     0.150
     9.666   138.470     0.150
    19.910   270.145     0.150
    20.580   280.380     0.150
    21.409   287.470     0.150
    25.738   329.395     0.150
    25.737   329.390     0.150
    27.728   346.308     0.150
    27.785   346.310     0.150
    27.812   346.770     0.150
    31.347   376.960     0.150
    31.347   550.970     0.150
    31.346   376.960     0.150
    31.346   550.970     0.150
    34.721   407.720     0.150
    34.722   407.720     0.150
    34.722   560.220     0.150
    34.960   410.195     0.150
    34.960   410.840     0.150
    40.635   460.390     0.150
    40.635   460.391     0.150
    44.824   491.395     0.150
    44.824   492.470     0.150
    48.120   518.240     0.150
    50.941   540.140     0.150
    50.941   540.145     0.150
    53.877   560.460     0.150
    53.880   560.460     0.150
    55.084   568.999     0.150
    56.513   580.320     0.150
    60.671   609.680     0.150
    60.671   609.681     0.150
    63.856   629.870     0.150
    64.887   638.079     0.150
    64.887   638.560     0.150
    80.874   731.320     0.150
    83.761   746.970     0.150
    83.761   746.970     0.150
    83.945   748.190     0.150
    83.945   748.186     0.150
    85.127   754.420     0.150
    85.127   754.419     0.150
    85.375   754.436     0.150
    85.567   755.345     0.150
    86.818   763.370     0.150
    92.075   785.422     0.150
    95.119   800.127     0.150
    95.119   800.130     0.150
   118.184  1124.380     0.150
   118.183  1124.382     0.150
   145.076  1174.539     0.150
   146.694  1179.420     0.150
     0.745    13.516     0.150
     0.745    26.506     0.150
     1.077    18.896     0.150
     1.077    34.097     0.150
     1.166    21.567     0.150
     1.634    28.227     0.150
     1.793    29.817     0.150
     1.793    54.717     0.150
     2.066    35.427     0.150
     2.290    36.947     0.150
     2.568    40.536     0.150
     2.663    42.697     0.150
     2.663    75.766     0.150
     3.108    49.347     0.150
     3.235    50.906     0.150
     3.235    51.477     0.150
     3.134    50.687     0.150
     3.134    98.677     0.150
     3.836    61.227     0.150
     4.110    64.126     0.150
     4.339    65.906     0.150
     4.816    74.817     0.150
     5.142    80.687     0.150
     6.411    97.036     0.150
     8.749   127.506     0.150
     9.705   139.036     0.150
    11.034   162.136     0.150
    11.075   159.337     0.150
    11.098   162.636     0.150
    12.098   168.437     0.150
    12.435   182.237     0.150
    12.917   184.011     0.150
    13.467   188.136     0.150
    13.632   196.737     0.150
    13.656   192.207     0.150
    13.990   198.857     0.150
    14.082   201.636     0.150
    14.056   198.447     0.150
    14.316   201.286     0.150
    14.837   207.776     0.150
    15.162   219.237     0.150
    15.162   212.786     0.150
    15.389   222.337     0.150
    15.520   219.181     0.150
    15.520   218.136     0.150
    15.716   224.737     0.150
    16.122   233.437     0.150
    16.122   224.337     0.150
    16.300   230.737     0.150
    17.213   242.437     0.150
    18.591   258.136     0.150
    18.778   258.937     0.150
    18.766   259.937     0.150
    18.937   259.797     0.150
    19.609   271.437     0.150
    19.609   265.756     0.150
    19.724   273.237     0.150
    19.889   284.737     0.150
    19.944   272.237     0.150
    20.020   275.337     0.150
    20.062   272.687     0.150
    20.288   277.136     0.150
    20.243   278.536     0.150
    20.400   281.036     0.150
    20.624   278.156     0.150
    20.665   278.612     0.150
    20.665   279.536     0.150
    20.713   280.536     0.150
    20.845   284.536     0.150
    20.845   279.376     0.150
    21.354   291.337     0.150
    21.463   292.536     0.150
    21.722   290.077     0.150
    21.726   294.437     0.150
    22.184   300.036     0.150
    22.345   297.067     0.150
    22.310   298.437     0.150
    22.347   299.937     0.150
    22.390   300.036     0.150
    22.466   299.357     0.150
    22.495   299.837     0.150
    22.906   307.837     0.150
    23.146   310.636     0.150
    23.146   306.497     0.150
    23.430   309.662     0.150
    23.430   312.737     0.150
    23.400   313.136     0.150
    23.426   312.836     0.150
    23.447   310.037     0.150
    23.543   309.646     0.150
    23.543   533.757     0.150
    23.724   309.384     0.150
    23.724   310.267     0.150
    23.715   311.297     0.150
    23.815   314.636     0.150
    23.855   312.612     0.150
    24.002   312.523     0.150
    24.020   318.636     0.150
    24.091   312.987     0.150
    24.091   312.987     0.150
    24.197   317.537     0.150
    24.208   320.037     0.150
    24.172   317.037     0.150
    24.224   318.336     0.150
    24.306   320.937     0.150
    24.364   314.316     0.150
    24.680   322.937     0.150
    24.881   323.937     0.150
    24.927   326.636     0.150
    24.997   324.237     0.150
    25.053   326.237     0.150
    25.212   326.537     0.150
    25.280   328.237     0.150
    25.280   326.237     0.150
    25.550   332.437     0.150
    25.552   329.836     0.150
    25.790   330.066     0.150
    25.790   329.851     0.150
    25.790   331.037     0.150
    25.914   333.437     0.150
    25.886   329.537     0.150
    26.051   331.677     0.150
    26.049   331.937     0.150
    26.049   332.336     0.150
    26.048   332.326     0.150
    26.440   335.836     0.150
    27.549   346.237     0.150
    27.549   344.159     0.150
    27.705   347.336     0.150
    27.705   346.437     0.150
    27.942   348.304     0.150
    27.942   347.511     0.150
    27.942   347.257     0.150
    29.363   360.136     0.150
    29.363   360.124     0.150
    29.948   365.682     0.150
    29.948   365.136     0.150
    30.755   374.937     0.150
    31.389   377.437     0.150
    31.389   377.807     0.150
    31.394   552.136     0.150
    31.394   377.614     0.150
    31.394   552.136     0.150
    31.398   377.626     0.150
    31.628   379.307     0.150
    31.638   380.076     0.150
    31.637   379.396     0.150
    31.642   378.977     0.150
    31.643   380.126     0.150
    31.845   386.737     0.150
    32.688   394.437     0.150
    33.701   401.437     0.150
    33.958   401.307     0.150
    34.326   403.304     0.150
    34.258   405.136     0.150
    34.785   408.386     0.150
    34.785   408.237     0.150
    34.766   407.662     0.150
    34.766   408.636     0.150
    34.766   408.636     0.150
    34.829   410.937     0.150
    34.829   408.566     0.150
    35.045   410.932     0.150
    36.447   425.237     0.150
    36.490   426.907     0.150
    36.490   425.836     0.150
    36.983   427.636     0.150
    36.983   426.737     0.150
    37.590   433.612     0.150
    38.383   441.437     0.150
    38.492   442.237     0.150
    39.189   448.336     0.150
    39.328   447.937     0.150
    39.597   448.752     0.150
    39.638   450.812     0.150
    39.638   450.636     0.150
    39.760   453.037     0.150
    40.389   457.537     0.150
    40.402   457.537     0.150
    40.410   456.336     0.150
    40.566   459.037     0.150
    40.583   459.017     0.150
    40.583   458.237     0.150
    40.703   458.316     0.150
    40.657   459.836     0.150
    41.173   463.636     0.150
    42.016   470.937     0.150
    43.171   479.787     0.150
    44.052   486.101     0.150
    44.052   486.326     0.150
    44.858   493.237     0.150
    44.858   492.711     0.150
    44.793   493.937     0.150
    44.818   493.555     0.150
    44.818   493.836     0.150
    44.818   491.467     0.150
    45.415   496.792     0.150
    45.657   500.836     0.150
    46.169   502.659     0.150
    46.156   506.437     0.150
    46.156   502.737     0.150
    48.092   516.622     0.150
    48.092   516.856     0.150
    48.358   521.037     0.150
    49.398   528.028     0.150
    50.789   538.604     0.150
    50.789   536.836     0.150
    50.792   538.606     0.150
    50.984   539.351     0.150
    50.989   541.136     0.150
    50.989   541.487     0.150
    50.989   541.336     0.150
    51.001   540.836     0.150
    51.139   541.136     0.150
    51.179   542.437     0.150
    51.179   543.007     0.150
    51.369   542.746     0.150
    51.369   541.937     0.150
    51.860   550.237     0.150
    51.860   985.237     0.150
    52.017   548.136     0.150
    52.112   548.136     0.150
    52.112   547.896     0.150
    52.150   550.136     0.150
    52.324   550.977     0.150
    52.552   553.336     0.150
    53.004   555.737     0.150
    53.317   560.116     0.150
    53.406   559.037     0.150
    53.877   561.761     0.150
    53.877   561.336     0.150
    53.881   564.197     0.150
    54.008   564.057     0.150
    54.047   564.132     0.150
    54.047   564.836     0.150
    54.281   565.856     0.150
    54.547   568.007     0.150
    55.117   570.737     0.150
    55.117   571.606     0.150
    55.118   571.412     0.150
    55.753   576.336     0.150
    56.952   584.237     0.150
    56.952   584.237     0.150
    57.624   589.336     0.150
    59.961   605.636     0.150
    60.779   609.836     0.150
    60.779   610.017     0.150
    61.685   615.646     0.150
    61.685   614.537     0.150
    61.685   615.787     0.150
    63.779   630.412     0.150
    64.329   633.336     0.150
    64.329   668.937     0.150
    64.329   775.037     0.150
    65.023   639.787     0.150
    65.023   638.906     0.150
    65.023   639.096     0.150
    65.715   643.136     0.150
    65.715   643.037     0.150
    65.808   644.406     0.150
    65.891   644.757     0.150
    65.932   644.886     0.150
    65.951   645.258     0.150
    65.957   645.200     0.150
    66.024   645.308     0.150
    66.309   646.902     0.150
    66.381   648.908     0.150
    66.383   647.008     0.150
    66.634   650.424     0.150
    66.688   650.039     0.150
    67.001   651.574     0.150
    67.315   653.937     0.150
    68.206   658.876     0.150
    68.286   659.086     0.150
    68.305   659.237     0.150
    68.305  1195.937     0.150
    68.305   659.096     0.150
    68.976   663.687     0.150
    69.188   665.217     0.150
    69.516   666.586     0.150
    69.861   669.606     0.150
    74.803   696.816     0.150
    75.516   700.737     0.150
    75.533   703.136     0.150
    75.533   702.626     0.150
    75.709   704.356     0.150
    75.709   704.237     0.150
    75.807   702.636     0.150
    76.126   706.237     0.150
    76.339   708.537     0.150
    76.456   706.737     0.150
    76.842   710.937     0.150
    76.990   712.580     0.150
    76.990   711.537     0.150
    76.990   709.027     0.150
    77.358   711.086     0.150
    77.533   713.537     0.150
    77.741   714.606     0.150
    77.949   712.896     0.150
    77.952   713.136     0.150
    78.053   716.805     0.150
    78.053   716.336     0.150
    79.139   721.937     0.150
    79.230   722.836     0.150
    79.427   724.417     0.150
    79.685   725.656     0.150
    79.771   725.636     0.150
    79.856   726.037     0.150
    80.201   729.737     0.150
    80.493   730.037     0.150
    80.618   729.646     0.150
    80.618   729.237     0.150
    80.625   728.636     0.150
    80.706   731.437     0.150
    81.121   733.237     0.150
    81.588   734.767     0.150
    83.034   744.427     0.150
    83.034   744.636     0.150
    83.722   747.362     0.150
    84.071   748.237     0.150
    84.071   749.636     0.150
    84.071   748.437     0.150
    84.695   752.237     0.150
    84.840   753.636     0.150
    85.001   753.047     0.150
    85.133   753.636     0.150
    85.327   754.886     0.150
    85.327   754.237     0.150
    85.412   754.537     0.150
    85.441   755.162     0.150
    85.441   755.836     0.150
    85.441   754.737     0.150
    86.469   760.037     0.150
    87.106   765.362     0.150
    87.106   765.580     0.150
    87.106   763.836     0.150
    88.013   771.437     0.150
    88.354   769.037     0.150
    88.711   770.326     0.150
    88.642   771.116     0.150
    88.646   770.677     0.150
    90.500   782.037     0.150
    92.070   785.937     0.150
    92.070   786.037     0.150
    92.528   793.836     0.150
    94.593   798.834     0.150
    94.593  1079.509     0.150
    94.871   798.882     0.150
    95.043   801.130     0.150
    95.087   799.437     0.150
    95.607   803.122     0.150
    95.625  1083.965     0.150
    96.491   807.464     0.150
    97.145   810.684     0.150
    97.285   808.437     0.150
    97.495   811.672     0.150
    97.495  1084.600     0.150
    97.504  1087.662     0.150
    97.779   815.135     0.150
    97.795  1089.151     0.150
    97.949   811.750     0.150
    97.949  1087.172     0.150
    98.159  1088.592     0.150
    98.239   815.356     0.150
   118.397  1126.267     0.150
   118.396  1126.271     0.150
   119.604  1128.912     0.150
   121.711  1132.336     0.150
   122.253  1132.717     0.150
   123.266  1135.777     0.150
   125.140  1138.937     0.150
   125.889  1140.307     0.150
   126.535  1141.537     0.150
   126.715  1141.836     0.150
   126.848  1141.937     0.150
   132.987  1154.731     0.150
   146.734  1180.011     0.150
   146.734  1180.636     0.150
   147.411  1182.767     0.150
   150.510  1191.007     0.150
   151.515  1190.737     0.150
   153.602  1197.787     0.150
   154.506  1198.596     0.150
   154.918  1199.816     0.150
   155.267  1191.136     0.150
   155.612  1191.866     0.150
   156.165  1192.396     0.150
   156.188  1194.156     0.150
   156.188  1220.257     0.150
   156.282  1194.547     0.150
   157.045  1194.017     0.150
   166.530  1206.037     0.150
   166.530  1267.437     0.150
   169.951  1281.557     0.150
   172.175  1207.376     0.150
     0.211     4.374     0.150
     0.211     7.444     0.150
     0.468     9.044     0.150
     0.468    15.864     0.150
     0.911    17.394     0.150
     0.911    30.604     0.150
     0.886    32.594     0.150
     1.596    50.234     0.150
     2.491    72.954     0.150
     3.105    49.244     0.150
     3.169    50.604     0.150
     3.168    52.819     0.150
     8.592   126.854     0.150
    13.826   196.594     0.150
    18.446   255.394     0.150
    18.876   261.584     0.150
    19.925   273.174     0.150
    20.674   280.574     0.150
    21.576   290.984     0.150
    23.258   308.849     0.150
    23.387   309.664     0.150
    25.739   331.464     0.150
    25.739   331.468     0.150
    25.739   331.214     0.150
    25.910   332.649     0.150
    25.909   332.654     0.150
    27.695   347.747     0.150
    27.814   349.574     0.150
    29.948   368.594     0.150
    31.302   378.554     0.150
    31.302   378.554     0.150
    34.685   409.774     0.150
    34.686   408.824     0.150
    34.686   408.534     0.150
    34.917   411.841     0.150
    34.917   412.504     0.150
    36.939   426.749     0.150
    39.444   449.234     0.150
    44.772   493.349     0.150
    48.037   519.894     0.150
    51.033   542.734     0.150
    51.033   542.424     0.150
    51.033   542.424     0.150
    51.223   543.864     0.150
    52.138   551.114     0.150
    52.327   550.954     0.150
    53.026   557.504     0.150
    53.946   563.149     0.150
    53.946   562.374     0.150
    53.949   563.154     0.150
    54.068   565.694     0.150
    55.169   572.194     0.150
    55.170   572.599     0.150
    55.742   576.804     0.150
    55.798   576.734     0.150
    55.861   577.664     0.150
    60.829   611.854     0.150
    61.242   615.144     0.150
    63.619   631.049     0.150
    63.884   631.924     0.150
    65.018   640.674     0.150
    65.018   641.144     0.150
    65.747   644.434     0.150
    68.291   660.713     0.150
    68.359   660.094     0.150
    69.479   667.444     0.150
    76.853   711.824     0.150
    78.225   719.343     0.150
   118.342  1126.924     0.150
   118.342  1126.924     0.150
   119.775  1130.788     0.150
   146.646  1180.324     0.150
     0.245     4.801     0.150
     0.245    10.161     0.150
     0.833    15.871     0.150
     0.833    27.551     0.150
    13.812   194.331     0.150
    14.213   201.681     0.150
    15.347   218.660     0.150
    15.347   214.071     0.150
    17.387   239.041     0.150
    18.953   259.851     0.150
    19.440   261.251     0.150
    19.892   272.691     0.150
    20.597   279.166     0.150
    21.347   285.681     0.150
    23.283   309.841     0.150
    23.465   310.421     0.150
    24.783   321.381     0.150
    25.817   331.261     0.150
    25.817   331.260     0.150
    25.817   331.481     0.150
    27.721   345.938     0.150
    31.246   377.891     0.150
    31.246   377.896     0.150
    34.313   406.451     0.150
    34.633   407.704     0.150
    34.939   411.316     0.150
    36.562   426.151     0.150
    36.870   428.141     0.150
    39.494   448.241     0.150
    39.811   451.991     0.150
    40.538   456.021     0.150
    40.559   457.191     0.150
    40.732   460.771     0.150
    40.732   460.771     0.150
    44.714   490.766     0.150
    51.103   541.591     0.150
    51.103   541.591     0.150
    51.103   541.721     0.150
    51.292   543.831     0.150
    52.251   550.831     0.150
    54.009   562.141     0.150
    54.012   562.141     0.150
    55.238   572.441     0.150
    55.937   577.991     0.150
    60.825   611.681     0.150
    60.825   611.679     0.150
    63.935   631.191     0.150
    76.773   712.091     0.150
    76.886   708.801     0.150
    76.953   709.641     0.150
    83.867   748.481     0.150
    83.867   748.480     0.150
    85.263   755.411     0.150
    85.263   755.416     0.150
    85.547   757.046     0.150
    85.547   756.011     0.150
    88.538   770.254     0.150
    92.204   788.508     0.150
   118.419  1126.491     0.150
   118.420  1126.491     0.150
   119.746  1129.180     0.150
   146.589  1179.941     0.150
   146.589  1177.911     0.150
     0.419    14.456     0.150
     0.872    29.667     0.150
     0.938    17.296     0.150
     0.938    31.197     0.150
     1.291    23.506     0.150
     1.291    41.667     0.150
     1.572    27.126     0.150
     1.572    48.656     0.150
     1.841    30.786     0.150
     1.841    56.056     0.150
     2.128    36.427     0.150
     2.128    63.427     0.150
     2.531    41.236     0.150
     2.531    72.187     0.150
     3.089    48.336     0.150
     3.211    51.447     0.150
     3.211    87.896     0.150
     3.211    48.947     0.150
     3.211    47.386     0.150
     3.130    49.846     0.150
     4.284    64.766     0.150
     8.613   125.486     0.150
     9.662   137.677     0.150
     9.662   136.836     0.150
    10.936   159.956     0.150
    10.990   161.876     0.150
    11.029   161.276     0.150
    12.031   168.076     0.150
    12.303   179.177     0.150
    12.908   184.226     0.150
    13.152   187.667     0.150
    13.408   186.376     0.150
    13.516   194.476     0.150
    13.852   198.076     0.150
    13.852   194.106     0.150
    14.040   199.776     0.150
    14.125   198.776     0.150
    14.403   205.177     0.150
    14.903   210.187     0.150
    15.149   218.177     0.150
    15.149   214.937     0.150
    15.407   218.220     0.150
    15.407   216.976     0.150
    15.483   222.976     0.150
    15.837   227.476     0.150
    15.985   229.076     0.150
    15.985   228.236     0.150
    16.324   229.177     0.150
    17.321   244.451     0.150
    17.542   247.376     0.150
    18.495   256.976     0.150
    18.495   256.536     0.150
    18.811   259.976     0.150
    18.860   262.976     0.150
    18.860   260.376     0.150
    19.189   260.927     0.150
    19.525   265.756     0.150
    19.608   269.177     0.150
    19.894   271.177     0.150
    19.974   271.927     0.150
    19.974   272.376     0.150
    20.175   279.976     0.150
    20.574   278.576     0.150
    20.703   279.401     0.150
    20.717   281.776     0.150
    20.717   281.286     0.150
    20.891   283.076     0.150
    21.255   283.376     0.150
    21.593   293.076     0.150
    22.183   297.076     0.150
    22.210   298.486     0.150
    22.420   298.076     0.150
    22.427   300.677     0.150
    22.556   299.876     0.150
    23.008   306.386     0.150
    23.292   307.101     0.150
    23.283   309.677     0.150
    23.371   311.177     0.150
    23.371   306.697     0.150
    23.418   309.076     0.150
    23.418   308.736     0.150
    23.593   311.076     0.150
    23.593   309.136     0.150
    23.675   308.826     0.150
    23.678   310.736     0.150
    23.961   313.546     0.150
    23.965   313.876     0.150
    23.965   313.746     0.150
    24.228   315.406     0.150
    24.228   315.401     0.150
    24.379   315.876     0.150
    24.541   320.376     0.150
    24.748   318.806     0.150
    25.250   327.476     0.150
    25.250   325.976     0.150
    25.720   330.976     0.150
    25.720   330.076     0.150
    25.842   331.622     0.150
    25.842   331.206     0.150
    25.818   329.876     0.150
    25.922   331.677     0.150
    25.922   539.001     0.150
    26.536   336.376     0.150
    27.213   343.776     0.150
    27.213   343.076     0.150
    27.441   345.677     0.150
    27.646   344.876     0.150
    27.646   346.626     0.150
    27.730   347.677     0.150
    27.730   346.476     0.150
    27.863   348.490     0.150
    27.863   347.776     0.150
    27.863   346.886     0.150
    29.485   358.776     0.150
    29.485   363.697     0.150
    29.485   546.346     0.150
    29.485   363.698     0.150
    29.485   546.345     0.150
    29.979   366.346     0.150
    29.979   364.376     0.150
    30.387   369.366     0.150
    30.797   373.677     0.150
    31.348   551.826     0.150
    31.348   377.151     0.150
    31.348   551.826     0.150
    31.352   377.646     0.150
    31.539   379.536     0.150
    31.544   379.996     0.150
    31.617   380.167     0.150
    31.860   385.876     0.150
    31.860   452.876     0.150
    32.736   395.576     0.150
    34.067   403.032     0.150
    34.209   406.976     0.150
    34.209   404.476     0.150
    34.320   406.671     0.150
    34.732   406.736     0.150
    34.733   407.781     0.150
    34.733   560.726     0.150
    34.733   407.427     0.150
    34.733   560.356     0.150
    34.869   410.751     0.150
    34.869   410.376     0.150
    34.972   410.246     0.150
    34.927   411.576     0.150
    36.455   426.981     0.150
    36.455   423.376     0.150
    36.460   425.177     0.150
    36.691   424.521     0.150
    36.979   427.901     0.150
    36.979   429.576     0.150
    36.979   426.806     0.150
    37.710   435.951     0.150
    38.335   440.876     0.150
    38.442   441.576     0.150
    39.139   447.476     0.150
    39.405   448.476     0.150
    39.405   447.806     0.150
    39.492   449.409     0.150
    39.711   452.476     0.150
    39.738   451.476     0.150
    39.738   576.976     0.150
    39.738   450.876     0.150
    40.340   456.976     0.150
    40.352   457.076     0.150
    40.458   456.076     0.150
    40.517   458.476     0.150
    40.628   456.776     0.150
    40.607   459.376     0.150
    40.630   580.016     0.150
    40.630   458.856     0.150
    40.630   580.021     0.150
    40.630   458.016     0.150
    41.078   460.796     0.150
    41.124   463.276     0.150
    41.243   465.417     0.150
    41.967   470.576     0.150
    43.997   485.796     0.150
    43.997   484.746     0.150
    44.709   492.576     0.150
    44.818   492.526     0.150
    44.818   492.276     0.150
    44.818   491.677     0.150
    44.866   494.470     0.150
    44.866   494.177     0.150
    44.866   491.937     0.150
    45.366   497.346     0.150
    45.700   500.376     0.150
    46.159   505.376     0.150
    46.159   503.876     0.150
    48.079   519.221     0.150
    48.079   515.736     0.150
    48.429   521.276     0.150
    50.913   540.001     0.150
    50.913   539.796     0.150
    50.917   540.006     0.150
    50.993   616.156     0.150
    50.993   541.302     0.150
    50.993   616.157     0.150
    50.993   541.046     0.150
    51.331   541.376     0.150
    51.332   543.876     0.150
    51.413   545.417     0.150
    51.838   549.177     0.150
    52.110   548.876     0.150
    52.204   548.776     0.150
    52.204   549.046     0.150
    52.358   550.736     0.150
    52.358   550.437     0.150
    52.536   551.576     0.150
    52.688   554.566     0.150
    52.990   555.576     0.150
    53.302   560.256     0.150
    53.393   559.947     0.150
    53.730   562.736     0.150
    53.865   563.826     0.150
    53.902   561.563     0.150
    53.995   562.986     0.150
    54.032   563.996     0.150
    54.032   564.989     0.150
    54.032   564.376     0.150
    54.032   565.606     0.150
    54.032   561.586     0.150
    54.268   565.576     0.150
    54.532   568.096     0.150
    55.128   570.177     0.150
    55.129   571.302     0.150
    55.713   575.677     0.150
    55.764   575.276     0.150
    55.829   574.656     0.150
    56.606   579.976     0.150
    56.740   635.626     0.150
    56.936   583.976     0.150
    56.936   583.776     0.150
    57.253   585.776     0.150
    60.717   610.414     0.150
    60.788   611.496     0.150
    60.788   609.476     0.150
    60.788   610.396     0.150
    61.214   613.086     0.150
    61.774   616.285     0.150
    61.774   615.576     0.150
    61.774   614.667     0.150
    63.601   629.351     0.150
    63.837   630.576     0.150
    64.065   634.044     0.150
    64.442   631.677     0.150
    64.442   666.976     0.150
    64.442   774.576     0.150
    64.988   638.601     0.150
    64.988   638.776     0.150
    64.988   638.776     0.150
    65.709   642.626     0.150
    65.709   642.846     0.150
    65.742   644.191     0.150
    65.865   647.116     0.150
    65.889   645.044     0.150
    65.956   644.637     0.150
    65.956   646.115     0.150
    66.240   646.746     0.150
    66.316   646.740     0.150
    66.551   650.001     0.150
    66.620   649.422     0.150
    67.329   653.677     0.150
    68.205   657.177     0.150
    68.276   659.256     0.150
    68.331   659.065     0.150
    68.331   658.906     0.150
    68.317   659.177     0.150
    68.317  1200.076     0.150
    68.317  1461.776     0.150
    68.317   659.346     0.150
    68.648   660.646     0.150
    68.959   663.667     0.150
    68.974   662.437     0.150
    69.031   662.766     0.150
    69.189   663.146     0.150
    69.427   666.826     0.150
    69.518   666.476     0.150
    74.711   696.576     0.150
    74.711   709.177     0.150
    74.711   862.376     0.150
    74.711  1264.976     0.150
    75.502   703.476     0.150
    75.502   702.866     0.150
    75.639   703.438     0.150
    75.639   703.776     0.150
    75.829   702.677     0.150
    75.891   704.976     0.150
    76.101   704.976     0.150
    76.159   706.976     0.150
    76.428   709.276     0.150
    76.464   707.876     0.150
    76.819   710.576     0.150
    76.968   711.880     0.150
    76.968   709.576     0.150
    76.968   709.776     0.150
    77.318   714.177     0.150
    77.529   712.476     0.150
    77.652   714.976     0.150
    77.722   714.177     0.150
    77.792   714.976     0.150
    78.070   719.076     0.150
    78.498   718.677     0.150
    78.684   720.476     0.150
    78.968   722.376     0.150
    79.229   722.476     0.150
    79.495   725.876     0.150
    79.547   724.476     0.150
    80.259   729.677     0.150
    80.499   728.276     0.150
    80.499   911.876     0.150
    80.686   730.476     0.150
    80.743   731.324     0.150
    81.449   736.476     0.150
    82.051   738.276     0.150
    82.451   738.677     0.150
    83.764   746.969     0.150
    84.015   748.276     0.150
    84.040   749.129     0.150
    84.040   748.576     0.150
    84.437   750.376     0.150
    84.489   749.976     0.150
    84.654   751.776     0.150
    84.865   753.976     0.150
    84.960   754.376     0.150
    85.156   753.576     0.150
    85.156   753.726     0.150
    85.243   752.976     0.150
    85.446   755.677     0.150
    85.446   753.976     0.150
    85.428   754.876     0.150
    85.437   755.090     0.150
    85.437   755.476     0.150
    85.550   756.286     0.150
    85.514   754.876     0.150
    85.699   756.276     0.150
    86.283   756.276     0.150
    86.593   760.976     0.150
    86.994   764.526     0.150
    86.994   763.876     0.150
    87.018   762.976     0.150
    87.271   763.677     0.150
    87.411   766.076     0.150
    87.917   768.239     0.150
    88.055   769.250     0.150
    88.058   765.276     0.150
    88.593   769.164     0.150
    88.632   771.157     0.150
    89.876   775.976     0.150
    90.283   778.076     0.150
    90.816   780.076     0.150
    92.097   786.476     0.150
    92.097   787.052     0.150
    92.244   787.601     0.150
    94.993   799.993     0.150
    95.092  1030.076     0.150
    95.574   803.276     0.150
    95.606   803.227     0.150
    98.112   814.621     0.150
   118.324  1125.598     0.150
   118.324  1744.601     0.150
   118.324  1124.516     0.150
   118.325  1125.596     0.150
   119.742  1128.901     0.150
   119.742  1738.826     0.150
   121.848  1132.076     0.150
   122.385  1133.447     0.150
   126.453  1141.177     0.150
   126.633  1141.576     0.150
   126.765  1141.776     0.150
   144.324  1173.667     0.150
   144.897  1175.076     0.150
   146.692  1179.126     0.150
   147.374  1181.417     0.150
   149.636  1186.976     0.150
   150.627  1190.906     0.150
   159.694  1197.945     0.150
   163.606  1251.326     0.150
   166.584  1205.251     0.150
   166.584  1267.601     0.150
   166.584  1204.136     0.150
   166.584  1265.276     0.150
   166.584  1265.506     0.150
   170.073  1282.021     0.150
   172.178  1207.556     0.150
     0.398     7.655     0.150
     0.398    13.975     0.150
     0.740    13.905     0.150
     0.740    24.955     0.150
     2.258    38.045     0.150
     2.302    68.515     0.150
     3.121    52.745     0.150
     3.248    53.955     0.150
     3.248    50.635     0.150
     8.758   127.665     0.150
     8.758   225.725     0.150
    11.049   160.005     0.150
    12.928   185.060     0.150
    14.000   198.575     0.150
    15.173   214.405     0.150
    15.535   219.304     0.150
    15.535   218.015     0.150
    15.511   216.905     0.150
    17.198   240.505     0.150
    18.606   256.385     0.150
    18.935   260.195     0.150
    19.624   264.575     0.150
    20.077   274.585     0.150
    20.671   281.935     0.150
    22.359   297.475     0.150
    23.737   311.365     0.150
    23.721   312.575     0.150
    25.456   328.025     0.150
    25.786   331.885     0.150
    25.786   330.575     0.150
    26.055   335.260     0.150
    26.055   333.765     0.150
    27.533   349.159     0.150
    27.957   350.035     0.150
    30.394   371.355     0.150
    31.411   379.785     0.150
    34.253   405.215     0.150
    34.750   411.531     0.150
    34.750   410.025     0.150
    34.798   409.055     0.150
    34.799   409.613     0.150
    34.799   408.145     0.150
    39.313   449.265     0.150
    39.612   449.745     0.150
    40.570   459.675     0.150
    40.570   459.675     0.150
    40.570   459.465     0.150
    40.718   460.465     0.150
    44.066   487.605     0.150
    44.871   493.485     0.150
    50.774   541.669     0.150
    50.774   542.255     0.150
    50.778   541.665     0.150
    50.978   540.825     0.150
    51.419   544.025     0.150
    52.144   551.605     0.150
    53.865   561.917     0.150
    53.868   561.915     0.150
    55.106   572.155     0.150
    55.107   572.535     0.150
    55.747   575.825     0.150
    56.943   585.905     0.150
    60.696   611.525     0.150
    60.696   611.523     0.150
    60.768   612.305     0.150
    60.768   612.595     0.150
    63.765   631.560     0.150
    65.705   644.635     0.150
    68.294   660.445     0.150
    68.294   660.305     0.150
    68.960   666.395     0.150
    73.538   691.305     0.150
    77.783   714.205     0.150
    78.589   718.245     0.150
    79.803   726.245     0.150
    80.101   727.415     0.150
    81.573   735.905     0.150
    81.928   736.815     0.150
    85.121   755.465     0.150
    85.121   755.460     0.150
    85.431   757.239     0.150
    92.058   788.525     0.150
    92.058   788.522     0.150
   118.393  1127.499     0.150
   118.394  1127.495     0.150
   146.747  1181.585     0.150
     0.670    12.548     0.150
     3.281    51.728     0.150
     8.842   128.348     0.150
    13.386   187.558     0.150
    20.145   276.323     0.150
    23.532   311.973     0.150
    23.792   312.338     0.150
    25.818   334.698     0.150
    26.131   336.948     0.150
    26.130   335.608     0.150
    27.461   346.386     0.150
    31.455   381.548     0.150
    31.530   380.627     0.150
    34.845   411.368     0.150
    34.846   410.547     0.150
    44.115   487.468     0.150
    50.961   542.667     0.150
    50.961   542.673     0.150
    50.961   542.177     0.150
    55.086   572.823     0.150
    63.294   628.657     0.150
    63.715   631.598     0.150
    65.694   645.177     0.150
    83.454   745.887     0.150
    83.668   748.328     0.150
    83.668   748.323     0.150
    83.668   747.948     0.150
   118.426  1127.318     0.150
   118.427  1127.318     0.150
   119.502  1130.153     0.150
   146.787  1181.123     0.150
     0.336     6.365     0.150
     0.336    11.815     0.150
     0.725    12.896     0.150
     1.110    21.315     0.150
     1.110    37.496     0.150
     1.126    20.775     0.150
     1.632    50.315     0.150
     1.804    30.545     0.150
     1.804    55.956     0.150
     2.048    35.125     0.150
     2.283    37.565     0.150
     2.319    37.746     0.150
     2.319    68.186     0.150
     2.528    42.456     0.150
     2.528    80.156     0.150
     2.702    44.396     0.150
     3.140    52.835     0.150
     3.140    99.976     0.150
     3.114    49.775     0.150
     3.221   100.686     0.150
     3.263    49.605     0.150
     3.263    88.335     0.150
     8.778   125.785     0.150
     9.736   138.746     0.150
    11.073   161.135     0.150
    11.073   157.795     0.150
    11.137   162.936     0.150
    12.133   169.936     0.150
    12.941   184.686     0.150
    13.672   195.635     0.150
    14.021   197.186     0.150
    15.560   218.845     0.150
    16.010   230.135     0.150
    18.805   261.236     0.150
    18.938   264.635     0.150
    18.938   261.406     0.150
    19.647   270.736     0.150
    19.647   268.236     0.150
    20.100   274.510     0.150
    20.100   274.635     0.150
    20.747   281.736     0.150
    20.884   281.196     0.150
    22.383   295.966     0.150
    23.448   309.436     0.150
    23.564   309.956     0.150
    23.735   312.706     0.150
    23.816   313.960     0.150
    23.816   311.765     0.150
    24.180   318.836     0.150
    24.683   325.736     0.150
    24.907   324.736     0.150
    25.010   325.836     0.150
    25.788   331.897     0.150
    25.788   330.296     0.150
    25.942   335.336     0.150
    26.071   333.385     0.150
    26.071   332.106     0.150
    26.071   603.216     0.150
    26.946   342.435     0.150
    27.979   349.510     0.150
    29.323   363.426     0.150
    31.420   378.535     0.150
    31.425   378.535     0.150
    31.425   379.055     0.150
    31.425   378.535     0.150
    31.429   379.455     0.150
    34.726   411.135     0.150
    34.817   409.696     0.150
    34.818   409.135     0.150
    34.818   409.676     0.150
    36.422   426.035     0.150
    39.292   447.126     0.150
    40.552   461.276     0.150
    40.552   461.276     0.150
    44.085   486.805     0.150
    44.796   494.135     0.150
    44.888   492.660     0.150
    44.888   492.156     0.150
    50.966   541.466     0.150
    50.966   616.055     0.150
    50.966   541.586     0.150
    50.966   541.586     0.150
    50.966   540.995     0.150
    50.966   616.626     0.150
    52.140   548.455     0.150
    53.850   561.236     0.150
    53.850   562.910     0.150
    53.850   561.526     0.150
    53.853   562.906     0.150
    55.093   571.106     0.150
    55.095   571.535     0.150
    55.842   576.345     0.150
    56.935   583.885     0.150
    60.755   610.756     0.150
    63.746   630.586     0.150
    65.011   639.935     0.150
    65.695   643.336     0.150
    68.281   660.415     0.150
    75.708   704.716     0.150
    80.579   732.156     0.150
    83.692   748.285     0.150
    83.692   748.285     0.150
    84.058   749.736     0.150
    84.058   749.736     0.150
    85.107   754.986     0.150
    85.107   754.986     0.150
    85.420   756.010     0.150
    85.420   756.296     0.150
    87.120   766.535     0.150
    87.120   764.926     0.150
   118.395  1126.651     0.150
   118.396  1126.645     0.150
   119.569  1129.986     0.150
   146.764  1180.635     0.150
     0.344     6.153     0.150
     0.344    11.863     0.150
     0.711    13.123     0.150
     0.711    24.473     0.150
     1.121    21.433     0.150
     1.121    38.423     0.150
     1.646    29.593     0.150
     2.312    38.883     0.150
     2.527    43.333     0.150
     3.125    50.963     0.150
     3.125    90.433     0.150
    14.285   200.333     0.150
    20.099   275.377     0.150
    25.802   335.223     0.150
    31.419   379.993     0.150
    31.419   379.990     0.150
    34.812   410.653     0.150
    40.737   459.533     0.150
    50.976   542.553     0.150
    50.976   542.553     0.150
    50.976   541.903     0.150
    55.103   572.453     0.150
    55.104   572.627     0.150
    56.946   586.663     0.150
    56.946   586.772     0.150
    60.764   612.093     0.150
     0.362     7.521     0.150
     0.404     7.541     0.150
     0.404    14.121     0.150
     0.745    24.691     0.150
     1.062    21.001     0.150
     1.199    38.871     0.150
     1.199    22.291     0.150
     1.199    42.491     0.150
     1.659    52.571     0.150
     1.659    30.161     0.150
     1.659    53.151     0.150
     1.763    28.941     0.150
     1.763    30.401     0.150
     1.763    55.730     0.150
     2.091    35.211     0.150
     2.091    63.730     0.150
     2.104    35.581     0.150
     2.104    64.230     0.150
     2.208    66.091     0.150
     2.208    39.511     0.150
     2.249    37.781     0.150
     2.249    70.791     0.150
     2.249    69.750     0.150
     2.605    41.721     0.150
     2.605    75.841     0.150
     2.605    41.851     0.150
     2.636    44.331     0.150
     2.815    46.291     0.150
     2.815    81.571     0.150
     3.153    55.210     0.150
     3.153    96.721     0.150
     3.170    51.281     0.150
     3.170    51.471     0.150
     3.170    92.321     0.150
     3.195    53.371     0.150
     3.195    50.571     0.150
     3.195    88.471     0.150
     3.189    51.210     0.150
     3.189    51.391     0.150
     3.648    59.241     0.150
     4.149    64.451     0.150
     4.149   121.121     0.150
     4.268    66.341     0.150
     4.367    67.391     0.150
     4.367    68.641     0.150
     4.856    76.121     0.150
     5.179    82.875     0.150
     6.370    94.401     0.150
     8.473   126.601     0.150
     8.740   128.431     0.150
     8.740   224.960     0.150
     8.740   129.351     0.150
     9.207   139.201     0.150
     9.308   140.701     0.150
     9.664   140.701     0.150
     9.664   138.921     0.150
     9.652   141.801     0.150
    10.995   157.701     0.150
    10.995   158.051     0.150
    11.034   158.801     0.150
    11.061   164.601     0.150
    12.056   169.000     0.150
    12.407   182.000     0.150
    12.879   185.101     0.150
    13.597   197.801     0.150
    13.645   193.801     0.150
    13.977   202.201     0.150
    13.977   198.031     0.150
    14.097   198.891     0.150
    14.133   199.901     0.150
    14.133   202.901     0.150
    14.481   208.301     0.150
    14.801   214.401     0.150
    14.878   211.671     0.150
    15.123   216.210     0.150
    15.441   217.421     0.150
    15.479   221.101     0.150
    15.484   221.295     0.150
    15.484   222.009     0.150
    15.484   216.301     0.150
    15.485   219.091     0.150
    15.680   225.301     0.150
    15.820   226.000     0.150
    15.959   229.500     0.150
    16.110   227.341     0.150
    17.251   243.651     0.150
    18.551   260.101     0.150
    18.551   257.031     0.150
    18.727   261.901     0.150
    18.959   265.201     0.150
    18.959   260.851     0.150
    19.569   270.901     0.150
    19.689   272.701     0.150
    19.910   274.301     0.150
    19.988   275.301     0.150
    20.022   274.526     0.150
    20.022   275.500     0.150
    20.256   277.901     0.150
    20.267   281.500     0.150
    20.633   282.151     0.150
    20.633   281.000     0.150
    20.697   282.701     0.150
    20.814   286.101     0.150
    20.814   280.931     0.150
    21.327   290.401     0.150
    21.720   291.411     0.150
    21.949   294.281     0.150
    22.310   300.201     0.150
    22.368   301.701     0.150
    22.430   302.301     0.150
    22.495   299.661     0.150
    22.536   301.801     0.150
    22.882   307.000     0.150
    23.408   312.000     0.150
    23.469   312.201     0.150
    23.544   312.201     0.150
    23.544   311.331     0.150
    23.718   314.201     0.150
    23.718   313.141     0.150
    23.792   315.201     0.150
    23.892   313.776     0.150
    24.188   319.201     0.150
    24.231   319.701     0.150
    24.403   319.421     0.150
    24.665   323.601     0.150
    24.700   324.500     0.150
    24.875   324.301     0.150
    25.006   326.500     0.150
    25.237   329.201     0.150
    25.313   329.201     0.150
    25.371   332.500     0.150
    25.559   331.701     0.150
    25.813   330.661     0.150
    25.813   538.541     0.150
    25.813   333.250     0.150
    25.813   542.508     0.150
    25.813   331.201     0.150
    25.813   540.000     0.150
    25.907   335.000     0.150
    26.048   334.801     0.150
    26.479   337.000     0.150
    26.926   342.601     0.150
    27.588   349.101     0.150
    27.745   349.301     0.150
    27.745   348.301     0.150
    27.902   349.326     0.150
    29.396   363.701     0.150
    29.396   363.651     0.150
    30.347   371.161     0.150
    30.797   376.201     0.150
    31.347   377.801     0.150
    31.353   379.151     0.150
    31.353   553.976     0.150
    31.353   379.601     0.150
    31.357   379.441     0.150
    31.762   387.201     0.150
    31.885   387.500     0.150
    31.885   455.301     0.150
    32.729   397.000     0.150
    33.751   405.101     0.150
    34.287   407.702     0.150
    34.287   408.101     0.150
    34.743   409.311     0.150
    34.743   563.131     0.150
    34.744   409.851     0.150
    34.744   563.756     0.150
    34.744   409.291     0.150
    34.804   410.601     0.150
    34.804   412.026     0.150
    34.804   410.181     0.150
    36.486   427.000     0.150
    36.522   425.401     0.150
    36.945   428.401     0.150
    37.624   437.000     0.150
    38.413   443.500     0.150
    38.521   444.101     0.150
    39.369   449.801     0.150
    39.369   449.521     0.150
    39.676   452.801     0.150
    39.676   452.000     0.150
    39.789   455.000     0.150
    40.418   459.401     0.150
    40.451   460.644     0.150
    40.451   458.500     0.150
    40.431   459.500     0.150
    40.595   460.901     0.150
    40.624   461.101     0.150
    40.624   460.201     0.150
    40.663   460.271     0.150
    40.686   461.801     0.150
    41.202   465.701     0.150
    42.045   472.901     0.150
    43.748   485.601     0.150
    43.845   485.901     0.150
    44.010   486.931     0.150
    44.817   494.125     0.150
    44.817   493.701     0.150
    44.812   496.201     0.150
    44.859   497.401     0.150
    45.698   503.500     0.150
    46.194   508.101     0.150
    48.399   522.401     0.150
    50.821   541.901     0.150
    50.821   540.601     0.150
    50.825   541.901     0.150
    51.027   543.101     0.150
    51.027   543.226     0.150
    51.027   542.000     0.150
    51.038   542.500     0.150
    51.217   543.500     0.150
    51.894   553.601     0.150
    51.894   994.201     0.150
    52.152   552.000     0.150
    52.181   551.746     0.150
    52.181   552.301     0.150
    52.738   557.511     0.150
    53.442   561.301     0.150
    53.442   562.061     0.150
    53.779   564.851     0.150
    53.917   563.125     0.150
    53.917   564.401     0.150
    53.917   563.591     0.150
    53.916   566.371     0.150
    54.082   566.746     0.150
    54.082   567.308     0.150
    54.082   565.201     0.150
    54.317   568.131     0.150
    54.448   570.391     0.150
    54.582   570.401     0.150
    55.156   573.546     0.150
    55.156   572.701     0.150
    55.156   572.571     0.150
    55.157   572.721     0.150
    55.784   577.201     0.150
    56.987   586.701     0.150
    56.987   586.000     0.150
    57.661   590.801     0.150
    60.817   613.570     0.150
    60.817   612.301     0.150
    60.817   612.511     0.150
    61.725   618.301     0.150
    61.725   618.541     0.150
    63.382   630.221     0.150
    63.695   631.526     0.150
    63.821   632.901     0.150
    64.159   635.582     0.150
    64.184   635.564     0.150
    64.231   635.957     0.150
    64.365   636.801     0.150
    64.365   669.701     0.150
    64.365   778.601     0.150
    64.330   636.229     0.150
    64.759   639.257     0.150
    64.908   640.479     0.150
    65.016   640.731     0.150
    65.055   641.301     0.150
    65.055   640.891     0.150
    65.634   645.073     0.150
    65.752   645.601     0.150
    65.752   645.091     0.150
    65.833   646.882     0.150
    65.833   646.622     0.150
    65.915   646.179     0.150
    65.915   646.354     0.150
    65.956   647.282     0.150
    65.981   647.157     0.150
    65.981   647.422     0.150
    66.048   647.580     0.150
    66.048   647.724     0.150
    66.333   649.287     0.150
    66.408   649.664     0.150
    66.408   650.349     0.150
    66.712   651.805     0.150
    66.712   652.490     0.150
    67.231   654.801     0.150
    67.354   655.801     0.150
    68.344   661.595     0.150
    68.344   661.901     0.150
    68.344  1206.401     0.150
    68.344   661.341     0.150
    68.422   662.709     0.150
    68.912   665.886     0.150
    73.609   692.701     0.150
    74.769   700.500     0.150
    74.769   715.301     0.150
    74.769  1271.201     0.150
    75.566   704.901     0.150
    75.733   706.575     0.150
    75.733   706.000     0.150
    75.847   705.801     0.150
    76.159   708.701     0.150
    76.373   709.901     0.150
    76.876   712.750     0.150
    77.018   713.682     0.150
    77.024   716.620     0.150
    77.024   714.301     0.150
    77.024   713.411     0.150
    77.570   715.201     0.150
    77.774   718.041     0.150
    78.081   720.070     0.150
    78.081   719.701     0.150
    79.107   723.301     0.150
    79.176   725.101     0.150
    79.267   725.401     0.150
    79.894   728.801     0.150
    80.233   730.601     0.150
    80.531   732.951     0.150
    80.531   731.801     0.150
    80.650   733.451     0.150
    80.650   733.210     0.150
    83.065   745.591     0.150
    83.075   746.701     0.150
    83.763   749.976     0.150
    84.104   751.551     0.150
    84.104   751.101     0.150
    84.512   754.101     0.150
    84.880   755.201     0.150
    85.173   757.426     0.150
    85.173   757.801     0.150
    85.361   758.500     0.150
    85.451   759.301     0.150
    85.478   757.651     0.150
    85.478   759.000     0.150
    86.506   765.683     0.150
    87.114   768.101     0.150
    87.114   767.924     0.150
    87.114   766.061     0.150
    87.218   768.301     0.150
    88.048   770.500     0.150
    88.048   771.142     0.150
    88.392   771.801     0.150
    88.665   773.771     0.150
    88.665   774.043     0.150
    88.678   773.631     0.150
    88.676   771.739     0.150
    88.676   771.401     0.150
    89.748   780.351     0.150
    90.788   782.901     0.150
    92.110   789.625     0.150
    95.644   807.081     0.150
   104.592   848.051     0.150
   104.592   848.047     0.150
   118.419  1126.951     0.150
   118.419  1128.000     0.150
   118.420  1128.000     0.150
   119.624  1130.651     0.150
   119.624  1129.041     0.150
   121.733  1132.801     0.150
   122.280  1134.391     0.150
   126.555  1146.201     0.150
   126.573  1144.026     0.150
   126.735  1145.500     0.150
   126.868  1146.701     0.150
   146.693  1182.951     0.150
   146.693  1178.901     0.150
   151.474  1187.401     0.150
   166.502  1207.375     0.150
   166.502  1271.451     0.150
   166.502  1268.000     0.150
     0.212     3.452     0.150
     0.427     8.132     0.150
     0.427    15.171     0.150
     0.819    16.092     0.150
     0.819    28.492     0.150
     1.025    18.731     0.150
     1.025    38.132     0.150
     1.969    34.992     0.150
     2.344    38.352     0.150
     2.344    68.902     0.150
     2.450    41.481     0.150
     3.129    50.302     0.150
     3.129    90.242     0.150
     3.297    52.532     0.150
     3.297    91.152     0.150
     8.473   123.481     0.150
    19.979   274.062     0.150
    25.570   328.882     0.150
    25.570   330.711     0.150
    25.570   328.182     0.150
    25.768   328.662     0.150
    34.784   411.312     0.150
    34.890   412.037     0.150
    34.890   409.882     0.150
    36.208   420.322     0.150
    39.753   452.412     0.150
    40.574   458.521     0.150
    40.574   458.527     0.150
    50.894   542.211     0.150
    50.894   542.211     0.150
    50.894   540.612     0.150
    51.976   548.932     0.150
    53.823   562.512     0.150
    53.826   562.512     0.150
    55.035   570.001     0.150
    56.820   584.001     0.150
    56.820   583.782     0.150
    56.820   584.042     0.150
    61.772   617.571     0.150
    61.772   616.832     0.150
    63.793   631.037     0.150
    64.857   640.237     0.150
   146.753  1184.537     0.150
   146.753  1179.882     0.150
     0.422     8.154     0.150
     0.422    15.524     0.150
     0.850    16.154     0.150
     0.850    28.064     0.150
     0.981    18.204     0.150
     0.981    32.354     0.150
     2.000    34.404     0.150
     2.315    37.304     0.150
     2.470    43.004     0.150
     3.268    50.504     0.150
     8.513   123.694     0.150
     8.513   219.704     0.150
    10.925   159.594     0.150
    10.925   155.844     0.150
    12.051   169.395     0.150
    13.483   194.694     0.150
    13.757   195.814     0.150
    14.160   204.895     0.150
    15.377   216.524     0.150
    17.345   241.165     0.150
    18.485   256.274     0.150
    18.654   259.594     0.150
    18.753   258.484     0.150
    18.900   261.994     0.150
    19.528   270.294     0.150
    19.528   267.665     0.150
    19.573   271.694     0.150
    19.785   271.794     0.150
    19.974   273.044     0.150
    19.974   273.194     0.150
    20.485   279.494     0.150
    20.664   282.494     0.150
    20.664   280.034     0.150
    20.795   281.744     0.150
    20.795   281.994     0.150
    21.154   288.994     0.150
    22.533   300.694     0.150
    22.695   304.994     0.150
    22.914   304.354     0.150
    23.264   307.224     0.150
    23.309   308.364     0.150
    23.601   311.824     0.150
    23.992   315.419     0.150
    24.319   316.364     0.150
    24.447   319.594     0.150
    24.643   322.094     0.150
    24.643   320.924     0.150
    25.045   326.494     0.150
    25.163   327.094     0.150
    25.615   328.104     0.150
    25.615   329.444     0.150
    25.615   541.839     0.150
    25.615   328.494     0.150
    25.813   331.895     0.150
    25.813   330.794     0.150
    25.812   330.824     0.150
    26.690   340.594     0.150
    27.658   347.949     0.150
    27.677   348.494     0.150
    27.715   345.154     0.150
    27.871   349.645     0.150
    27.871   348.484     0.150
    30.773   373.694     0.150
    30.793   376.194     0.150
    31.386   378.424     0.150
    31.386   378.425     0.150
    31.800   386.094     0.150
    31.800   449.194     0.150
    32.701   395.694     0.150
    34.113   403.594     0.150
    34.179   402.904     0.150
    34.764   409.165     0.150
    34.764   562.384     0.150
    34.765   408.895     0.150
    34.765   408.794     0.150
    34.888   411.619     0.150
    36.399   425.994     0.150
    39.396   449.094     0.150
    39.396   448.274     0.150
    39.752   452.994     0.150
    39.752   451.895     0.150
    40.594   460.395     0.150
    40.594   460.395     0.150
    40.594   458.114     0.150
    44.600   494.194     0.150
    44.830   494.694     0.150
    44.830   492.194     0.150
    44.860   493.645     0.150
    44.860   493.964     0.150
    46.092   503.194     0.150
    50.927   540.094     0.150
    50.927   542.224     0.150
    50.927   542.219     0.150
    50.927   540.574     0.150
    51.335   544.194     0.150
    51.755   551.594     0.150
    51.755   991.094     0.150
    52.017   548.194     0.150
    52.210   549.694     0.150
    52.210   547.974     0.150
    52.456   551.694     0.150
    53.849   561.864     0.150
    53.849   562.419     0.150
    53.849   561.744     0.150
    53.852   562.415     0.150
    53.954   565.364     0.150
    53.954   564.194     0.150
    53.954   561.734     0.150
    55.065   571.395     0.150
    55.065   571.034     0.150
    55.066   571.419     0.150
    55.620   575.395     0.150
    55.680   574.895     0.150
    55.743   575.395     0.150
    56.856   583.094     0.150
    56.856   582.895     0.150
    60.725   609.994     0.150
    61.120   612.665     0.150
    61.777   616.303     0.150
    61.777   617.395     0.150
    61.777   615.844     0.150
    63.809   631.194     0.150
    64.473   633.294     0.150
    64.473   776.494     0.150
    64.898   638.719     0.150
    64.898   638.234     0.150
    64.898   638.165     0.150
    65.636   643.524     0.150
    67.118   653.169     0.150
    67.268   654.494     0.150
    68.255   659.164     0.150
    68.255   658.994     0.150
    68.255  1202.594     0.150
    68.255   658.824     0.150
    69.204   665.274     0.150
    73.525   692.270     0.150
    75.774   704.094     0.150
    76.016   707.694     0.150
    76.341   706.994     0.150
    76.736   711.669     0.150
    76.885   711.494     0.150
    79.063   722.895     0.150
    80.373   727.094     0.150
    80.432   730.494     0.150
    80.432   914.094     0.150
    83.953   749.244     0.150
    83.953   748.294     0.150
    83.953   749.244     0.150
    83.953   748.294     0.150
    85.102   755.794     0.150
    85.102   755.800     0.150
    85.365   755.444     0.150
    85.368   754.594     0.150
    88.536   773.139     0.150
    95.535   805.270     0.150
   146.732  1181.594     0.150
   146.732  1178.094     0.150
     0.326     7.325     0.150
     0.326    11.125     0.150
     0.350     6.845     0.150
     0.350    12.535     0.150
     1.004    18.645     0.150
     1.004    33.064     0.150
     1.563    48.584     0.150
     2.023    34.615     0.150
     2.314    37.545     0.150
    20.048   274.330     0.150
    25.717   332.015     0.150
    34.796   409.496     0.150
    50.949   541.505     0.150
    50.949   541.505     0.150
    50.949   540.604     0.150
    52.089   550.015     0.150
    52.955   556.435     0.150
    53.849   561.776     0.150
    53.852   561.775     0.150
    55.082   571.955     0.150
    55.735   575.975     0.150
    65.670   642.575     0.150
    68.270   659.249     0.150
    68.270   658.405     0.150
     0.235     5.125     0.150
     0.235     7.935     0.150
     0.444     8.735     0.150
     0.444    15.425     0.150
     0.872    16.225     0.150
     0.872    29.295     0.150
     0.931    18.145     0.150
     0.931    31.045     0.150
     1.309    23.465     0.150
     1.309    43.585     0.150
     1.590    26.615     0.150
     1.590    49.415     0.150
     2.090    35.325     0.150
     2.107    33.755     0.150
     2.107    64.545     0.150
     2.236    36.095     0.150
     2.515    41.435     0.150
     2.515    72.815     0.150
     3.141    49.685     0.150
     3.141    85.485     0.150
     3.104    49.685     0.150
     3.186    49.440     0.150
     3.186    47.605     0.150
     3.186    84.375     0.150
     3.153    52.475     0.150
     3.153    91.235     0.150
     3.832    60.155     0.150
     4.859    73.775     0.150
     8.610   125.335     0.150
     9.559   138.095     0.150
    10.913   156.395     0.150
    10.913   156.025     0.150
    12.006   169.295     0.150
    12.884   182.470     0.150
    13.383   187.195     0.150
    13.496   192.795     0.150
    13.846   197.315     0.150
    14.015   197.795     0.150
    14.382   204.595     0.150
    14.928   209.615     0.150
    18.471   255.765     0.150
    18.644   258.595     0.150
    18.790   257.995     0.150
    18.875   264.595     0.150
    18.875   260.335     0.150
    19.950   273.145     0.150
    19.950   272.695     0.150
    20.566   280.395     0.150
    20.683   280.445     0.150
    20.747   277.595     0.150
    20.700   280.995     0.150
    20.700   280.855     0.150
    21.205   286.595     0.150
    22.452   301.095     0.150
    22.756   303.495     0.150
    23.280   311.070     0.150
    23.386   309.315     0.150
    23.421   309.625     0.150
    23.665   311.615     0.150
    24.090   318.995     0.150
    24.612   322.895     0.150
    25.165   326.795     0.150
    25.736   329.735     0.150
    25.736   331.795     0.150
    25.736   330.095     0.150
    25.777   331.395     0.150
    25.923   332.595     0.150
    25.923   331.995     0.150
    25.922   332.045     0.150
    26.802   339.495     0.150
    27.669   347.695     0.150
    27.726   346.395     0.150
    27.755   349.795     0.150
    27.755   347.195     0.150
    27.839   349.395     0.150
    27.839   348.365     0.150
    29.504   360.195     0.150
    29.504   360.182     0.150
    31.323   378.265     0.150
    31.323   552.365     0.150
    31.323   378.270     0.150
    31.323   552.370     0.150
    31.327   378.155     0.150
    31.349   378.285     0.150
    34.228   405.195     0.150
    34.707   408.995     0.150
    34.708   409.245     0.150
    34.708   561.980     0.150
    34.708   408.555     0.150
    34.891   411.495     0.150
    34.891   409.995     0.150
    36.485   426.295     0.150
    39.430   447.595     0.150
    39.760   451.895     0.150
    39.760   578.020     0.150
    40.483   456.995     0.150
    40.604   458.625     0.150
    40.655   459.995     0.150
    40.655   459.995     0.150
    40.655   458.295     0.150
    42.885   478.795     0.150
    43.823   485.195     0.150
    44.722   494.195     0.150
    44.793   493.420     0.150
    44.793   492.495     0.150
    44.891   493.595     0.150
    48.454   522.595     0.150
    51.017   540.795     0.150
    51.017   542.325     0.150
    51.017   617.015     0.150
    51.017   542.320     0.150
    51.017   617.020     0.150
    51.017   542.195     0.150
    51.017   540.845     0.150
    51.017   616.735     0.150
    51.207   542.695     0.150
    51.436   545.305     0.150
    51.860   550.695     0.150
    52.026   548.995     0.150
    52.130   549.095     0.150
    52.558   553.395     0.150
    53.927   562.655     0.150
    53.927   562.820     0.150
    53.927   562.005     0.150
    53.930   562.825     0.150
    54.055   564.890     0.150
    54.055   563.495     0.150
    55.152   571.295     0.150
    55.152   571.485     0.150
    55.153   572.445     0.150
    55.733   575.895     0.150
    55.786   576.295     0.150
    55.850   576.305     0.150
    56.959   584.495     0.150
    56.959   584.495     0.150
    60.813   610.295     0.150
    60.813   611.135     0.150
    61.234   614.185     0.150
    61.798   616.654     0.150
    61.798   615.595     0.150
    61.798   616.065     0.150
    63.862   631.570     0.150
    64.463   667.595     0.150
    64.463   774.995     0.150
    65.009   640.795     0.150
    65.009   638.885     0.150
    65.009   638.865     0.150
    65.733   643.315     0.150
    67.214   653.170     0.150
    67.353   654.195     0.150
    68.342   659.964     0.150
    68.342   660.395     0.150
    68.342  1201.495     0.150
    73.609   691.945     0.150
    75.523   704.095     0.150
    75.655   704.195     0.150
    75.854   702.695     0.150
    76.122   706.895     0.150
    76.338   708.595     0.150
    76.841   711.145     0.150
    76.990   712.295     0.150
    77.552   713.195     0.150
    79.159   722.595     0.150
    79.253   722.395     0.150
    80.523   729.695     0.150
    80.761   731.345     0.150
    82.398   742.908     0.150
    83.178   743.915     0.150
    83.789   749.075     0.150
    83.789   749.070     0.150
    84.062   749.975     0.150
    84.062   749.970     0.150
    84.062   749.295     0.150
    84.381   752.570     0.150
    85.181   754.595     0.150
    85.181   754.620     0.150
    85.461   755.895     0.150
    87.001   766.320     0.150
    87.001   764.395     0.150
    92.122   787.595     0.150
    92.122   788.045     0.150
    92.122   788.045     0.150
    95.629   805.745     0.150
   118.339  1125.769     0.150
   118.340  1125.765     0.150
   119.753  1130.270     0.150
   146.666  1181.070     0.150
   146.666  1180.415     0.150
     0.208     4.782     0.150
     0.208     7.602     0.150
     0.591    20.592     0.150
     0.628    11.852     0.150
     0.628    21.441     0.150
     3.278    48.622     0.150
     8.250   117.151     0.150
    24.318   316.512     0.150
    25.458   326.771     0.150
    25.458   329.052     0.150
    25.560   329.901     0.150
    27.750   347.802     0.150
    27.695   347.352     0.150
    27.821   348.542     0.150
    31.332   379.481     0.150
    31.332   379.477     0.150
    31.332   378.381     0.150
    31.336   378.092     0.150
    34.697   407.452     0.150
    34.698   408.952     0.150
    34.698   407.872     0.150
    38.120   440.102     0.150
    38.222   440.802     0.150
    38.918   446.802     0.150
    39.296   447.332     0.150
    39.495   451.702     0.150
    39.838   454.901     0.150
    40.121   456.202     0.150
    40.133   456.102     0.150
    40.299   457.602     0.150
    40.388   458.302     0.150
    40.654   458.881     0.150
    40.654   458.881     0.150
    40.907   462.401     0.150
    41.750   469.501     0.150
    44.817   494.302     0.150
    44.817   491.921     0.150
    50.904   540.722     0.150
    50.904   541.401     0.150
    50.904   541.401     0.150
    50.904   540.472     0.150
    51.093   542.521     0.150
    51.203   542.802     0.150
    51.869   547.552     0.150
    51.911   547.822     0.150
    53.866   562.401     0.150
    53.866   561.881     0.150
    53.869   562.401     0.150
    53.895   563.052     0.150
    55.055   571.751     0.150
    55.055   571.251     0.150
    55.514   574.952     0.150
    55.660   575.122     0.150
    56.795   583.981     0.150
    56.795   583.532     0.150
    60.641   610.711     0.150
    60.641   610.714     0.150
    60.712   610.251     0.150
    61.920   617.360     0.150
    64.800   639.251     0.150
    64.800   637.472     0.150
    65.594   643.202     0.150
    67.081   653.026     0.150
    68.247   659.271     0.150
    68.247   659.722     0.150
    73.522   691.077     0.150
    76.662   710.202     0.150
    81.012   733.742     0.150
    81.012   733.102     0.150
    83.863   748.751     0.150
    83.863   748.381     0.150
    83.863   748.751     0.150
    83.863   749.191     0.150
    85.113   754.401     0.150
    85.113   754.401     0.150
    85.326   755.276     0.150
    85.326   755.532     0.150
    85.695   758.427     0.150
    85.695   758.131     0.150
   118.054  1125.227     0.150
   118.055  1125.231     0.150
   146.681  1181.177     0.150
     0.213     4.922     0.150
     0.465     8.902     0.150
     0.465    15.602     0.150
     0.886    16.232     0.150
     0.886    30.302     0.150
     1.333    43.122     0.150
     1.593    26.682     0.150
     1.593    49.022     0.150
     1.818    30.892     0.150
     2.083    36.322     0.150
     2.083    63.842     0.150
     2.219    36.482     0.150
     2.219    67.082     0.150
     2.492    41.532     0.150
     2.492    73.872     0.150
     2.721    46.752     0.150
     2.721    47.292     0.150
     2.855    47.172     0.150
     4.875    76.562     0.150
    14.163   202.622     0.150
    19.928   273.302     0.150
    20.677   280.352     0.150
    24.011   315.192     0.150
    24.418   318.582     0.150
    25.737   332.452     0.150
    25.737   329.452     0.150
    25.909   332.977     0.150
    27.750   350.482     0.150
    31.304   378.822     0.150
    31.304   378.827     0.150
    34.688   409.852     0.150
    34.915   414.577     0.150
    34.915   412.892     0.150
    34.973   414.032     0.150
    36.942   429.552     0.150
    36.942   426.852     0.150
    40.674   463.622     0.150
    40.674   463.622     0.150
    40.674   461.582     0.150
    44.775   493.752     0.150
    50.959   544.942     0.150
    51.031   543.672     0.150
    51.031   542.782     0.150
    51.031   542.777     0.150
    51.031   541.862     0.150
    52.136   549.722     0.150
    52.330   552.502     0.150
    52.330   550.562     0.150
    52.569   553.652     0.150
    53.943   563.352     0.150
    55.167   572.712     0.150
    55.167   572.727     0.150
    55.859   576.952     0.150
    60.827   612.462     0.150
    61.821   618.452     0.150
    65.016   642.177     0.150
    65.745   644.692     0.150
    68.356   660.422     0.150
    68.924   664.072     0.150
    75.656   704.842     0.150
    76.851   713.777     0.150
    80.785   735.162     0.150
    80.785   734.908     0.150
    83.202   747.932     0.150
    84.069   753.152     0.150
    84.070   750.702     0.150
    85.197   757.502     0.150
    85.473   756.902     0.150
     0.186     4.111     0.150
     0.186     7.921     0.150
     0.611    11.591     0.150
     0.611    21.161     0.150
     0.615    11.521     0.150
     0.615    20.831     0.150
     1.211    22.581     0.150
     1.211    39.011     0.150
     1.211    22.721     0.150
     1.380    23.500     0.150
     1.380    42.621     0.150
     1.380    23.931     0.150
     1.380    42.091     0.150
     1.568    27.551     0.150
     1.568    27.681     0.150
     1.927    32.391     0.150
     1.927    57.561     0.150
     1.927    33.511     0.150
     2.065    34.701     0.150
     2.065    62.481     0.150
     2.252    37.281     0.150
     2.252    65.551     0.150
     2.252    38.161     0.150
     2.252    66.081     0.150
     2.313    67.971     0.150
     2.840    44.931     0.150
     2.840    83.211     0.150
     3.072    88.681     0.150
     3.057    49.701     0.150
     3.234    50.271     0.150
     3.234    96.231     0.150
     3.265    55.186     0.150
     3.265    47.951     0.150
     3.332    52.331     0.150
     3.680    57.411     0.150
     3.781    57.851     0.150
     4.086    62.241     0.150
     8.272   118.641     0.150
     8.272   212.721     0.150
     8.749   130.491     0.150
     9.133   132.891     0.150
     9.387   136.391     0.150
     9.653   139.091     0.150
     9.653   135.921     0.150
    10.773   272.461     0.150
    10.796   156.491     0.150
    10.935   152.352     0.150
    11.956   169.391     0.150
    12.980   185.816     0.150
    13.295   190.891     0.150
    13.356   186.291     0.150
    13.514   193.491     0.150
    13.514   190.671     0.150
    13.775   194.691     0.150
    14.096   198.091     0.150
    14.185   204.591     0.150
    14.515   210.991     0.150
    14.984   217.691     0.150
    15.195   216.610     0.150
    15.195   211.391     0.150
    15.214   214.591     0.150
    15.214   211.371     0.150
    15.401   220.391     0.150
    15.484   218.091     0.150
    15.647   219.341     0.150
    15.856   224.791     0.150
    17.226   242.191     0.150
    18.498   258.991     0.150
    18.605   261.691     0.150
    18.605   256.381     0.150
    18.978   261.991     0.150
    19.190   264.691     0.150
    19.190   259.831     0.150
    19.383   267.491     0.150
    19.399   267.991     0.150
    19.399   264.141     0.150
    19.637   267.991     0.150
    19.838   270.866     0.150
    19.838   271.691     0.150
    19.979   284.391     0.150
    19.939   283.991     0.150
    20.324   279.391     0.150
    20.451   279.291     0.150
    20.451   275.431     0.150
    20.498   277.091     0.150
    20.618   282.791     0.150
    20.883   282.416     0.150
    20.883   282.791     0.150
    20.927   284.291     0.150
    21.265   289.991     0.150
    21.252   287.491     0.150
    21.252   284.481     0.150
    21.285   284.801     0.150
    21.353   285.721     0.150
    21.846   294.491     0.150
    21.914   291.721     0.150
    22.011   296.491     0.150
    22.285   300.991     0.150
    22.230   295.621     0.150
    22.461   300.891     0.150
    22.433   300.291     0.150
    22.671   302.791     0.150
    22.671   300.781     0.150
    22.627   301.491     0.150
    22.976   305.316     0.150
    23.084   305.491     0.150
    23.084   304.671     0.150
    23.118   307.491     0.150
    23.118   305.531     0.150
    23.262   307.491     0.150
    23.262   306.441     0.150
    23.365   307.141     0.150
    23.557   312.391     0.150
    23.645   310.736     0.150
    23.645   308.901     0.150
    23.790   315.291     0.150
    23.950   313.036     0.150
    24.205   318.091     0.150
    24.173   315.791     0.150
    24.173   314.961     0.150
    24.332   320.991     0.150
    24.329   316.451     0.150
    24.407   317.101     0.150
    24.456   321.491     0.150
    24.919   324.591     0.150
    25.010   326.891     0.150
    25.074   325.791     0.150
    25.094   325.791     0.150
    25.094   323.691     0.150
    25.439   328.791     0.150
    25.480   326.381     0.150
    25.480   328.741     0.150
    25.480   326.991     0.150
    25.584   328.716     0.150
    25.584   327.791     0.150
    25.584   327.841     0.150
    25.771   330.736     0.150
    25.771   328.161     0.150
    26.329   339.791     0.150
    26.465   337.391     0.150
    27.751   346.804     0.150
    27.751   345.831     0.150
    27.704   347.591     0.150
    27.704   346.291     0.150
    27.816   349.441     0.150
    29.734   365.491     0.150
    29.734   548.603     0.150
    30.140   370.691     0.150
    30.483   370.961     0.150
    30.483   370.071     0.150
    30.864   374.791     0.150
    30.884   375.891     0.150
    31.321   377.691     0.150
    31.326   378.691     0.150
    31.326   378.691     0.150
    31.326   551.951     0.150
    31.326   377.791     0.150
    31.330   377.711     0.150
    31.333   377.981     0.150
    31.349   377.191     0.150
    31.351   378.191     0.150
    31.352   377.681     0.150
    31.358   378.441     0.150
    31.368   378.121     0.150
    31.367   377.961     0.150
    31.387   377.331     0.150
    31.398   378.541     0.150
    31.418   378.421     0.150
    31.808   385.591     0.150
    31.808   446.391     0.150
    31.937   385.291     0.150
    32.769   395.591     0.150
    33.956   400.680     0.150
    33.944   402.791     0.150
    33.993   402.291     0.150
    34.011   402.691     0.150
    34.398   405.095     0.150
    34.693   407.201     0.150
    34.694   407.528     0.150
    34.694   561.411     0.150
    34.694   407.191     0.150
    34.879   409.636     0.150
    35.056   411.791     0.150
    35.056   412.566     0.150
    35.056   411.391     0.150
    35.098   411.471     0.150
    36.287   421.791     0.150
    36.406   424.791     0.150
    36.516   423.711     0.150
    36.867   427.191     0.150
    37.059   428.366     0.150
    37.059   427.291     0.150
    37.952   436.716     0.150
    38.140   439.491     0.150
    38.242   440.091     0.150
    38.937   446.291     0.150
    39.303   448.136     0.150
    39.514   450.991     0.150
    39.514   449.691     0.150
    39.514   448.301     0.150
    39.913   452.916     0.150
    40.141   455.591     0.150
    40.153   455.491     0.150
    40.319   457.091     0.150
    40.407   457.991     0.150
    40.527   457.301     0.150
    40.490   456.791     0.150
    40.659   460.171     0.150
    40.659   460.171     0.150
    40.659   458.091     0.150
    40.931   459.588     0.150
    40.926   461.791     0.150
    41.509   465.111     0.150
    41.770   468.991     0.150
    42.894   477.691     0.150
    42.894   477.166     0.150
    43.949   483.291     0.150
    43.873   484.291     0.150
    44.439   490.491     0.150
    44.810   492.416     0.150
    44.810   491.841     0.150
    44.810   490.891     0.150
    44.897   493.785     0.150
    44.897   493.291     0.150
    44.897   493.031     0.150
    45.335   496.386     0.150
    45.719   500.991     0.150
    46.159   504.086     0.150
    46.080   505.091     0.150
    46.080   503.491     0.150
    48.523   521.991     0.150
    50.823   539.991     0.150
    50.917   539.991     0.150
    50.917   540.711     0.150
    50.917   540.716     0.150
    50.917   539.791     0.150
    50.917   615.691     0.150
    51.106   541.091     0.150
    51.169   541.766     0.150
    51.169   540.391     0.150
    51.172   541.771     0.150
    51.217   542.191     0.150
    51.325   539.891     0.150
    51.293   540.931     0.150
    51.522   543.691     0.150
    51.699   548.791     0.150
    51.699   988.991     0.150
    51.929   547.991     0.150
    52.356   550.191     0.150
    52.356   549.821     0.150
    52.410   550.591     0.150
    52.525   553.151     0.150
    52.525   551.821     0.150
    52.871   553.791     0.150
    53.276   559.271     0.150
    53.609   561.750     0.150
    53.741   563.641     0.150
    53.876   563.231     0.150
    53.876   561.631     0.150
    53.876   561.891     0.150
    53.876   561.491     0.150
    53.878   561.891     0.150
    53.911   563.611     0.150
    53.911   561.235     0.150
    53.911   560.891     0.150
    54.151   564.881     0.150
    54.270   566.621     0.150
    54.409   567.791     0.150
    55.066   570.716     0.150
    55.066   571.191     0.150
    55.066   570.231     0.150
    55.533   573.791     0.150
    55.620   574.791     0.150
    55.677   574.941     0.150
    56.810   582.991     0.150
    56.810   582.891     0.150
    56.950   584.416     0.150
    57.115   584.291     0.150
    60.239   606.791     0.150
    60.652   610.291     0.150
    60.652   610.329     0.150
    60.724   610.391     0.150
    60.724   609.821     0.150
    61.027   612.231     0.150
    61.917   617.100     0.150
    63.892   631.141     0.150
    64.658   634.891     0.150
    64.658   668.991     0.150
    64.658   777.091     0.150
    64.818   638.841     0.150
    64.818   637.250     0.150
    64.818   636.941     0.150
    65.608   642.291     0.150
    65.608   642.431     0.150
    67.094   651.916     0.150
    67.274   653.691     0.150
    68.341   658.231     0.150
    68.258   658.660     0.150
    68.258   659.091     0.150
    68.402   660.030     0.150
    68.402   660.181     0.150
    69.013   662.591     0.150
    69.067   663.241     0.150
    69.310   664.461     0.150
    69.611   667.061     0.150
    73.533   690.441     0.150
    74.567   696.391     0.150
    74.567   710.391     0.150
    74.567  1266.091     0.150
    75.337   701.591     0.150
    75.341   702.191     0.150
    75.341   700.471     0.150
    75.397   702.291     0.150
    75.794   702.791     0.150
    75.954   705.791     0.150
    76.274   707.191     0.150
    76.603   708.491     0.150
    76.603   710.391     0.150
    76.678   708.941     0.150
    76.828   710.979     0.150
    76.828   711.291     0.150
    76.828   709.771     0.150
    77.430   712.591     0.150
    77.483   714.991     0.150
    78.116   717.181     0.150
    78.158   716.891     0.150
    78.212   719.791     0.150
    78.467   720.091     0.150
    78.517   720.991     0.150
    78.699   719.941     0.150
    78.966   720.891     0.150
    79.037   721.291     0.150
    79.139   722.491     0.150
    79.244   723.101     0.150
    79.334   723.151     0.150
    79.348   723.771     0.150
    79.377   724.201     0.150
    79.560   724.951     0.150
    79.788   727.650     0.150
    79.792   725.091     0.150
    80.048   727.161     0.150
    80.067   727.591     0.150
    80.085   729.591     0.150
    80.146   727.591     0.150
    80.157   727.791     0.150
    80.206   727.891     0.150
    80.237   728.801     0.150
    80.424   728.491     0.150
    80.424   912.691     0.150
    80.498   729.931     0.150
    80.516   729.571     0.150
    80.552   730.391     0.150
    80.581   729.391     0.150
    80.612   730.021     0.150
    80.891   732.291     0.150
    80.991   732.691     0.150
    80.996   732.531     0.150
    80.996   730.851     0.150
    80.999   731.811     0.150
    80.999   731.291     0.150
    80.999   731.491     0.150
    81.169   732.191     0.150
    81.289   735.191     0.150
    81.596   737.291     0.150
    81.601   737.291     0.150
    81.897   738.291     0.150
    81.973   737.821     0.150
    82.285   740.191     0.150
    82.329   739.661     0.150
    82.564   740.181     0.150
    83.083   743.531     0.150
    83.089   743.991     0.150
    83.110   743.791     0.150
    83.244   745.556     0.150
    83.260   743.961     0.150
    83.422   744.241     0.150
    83.456   745.591     0.150
    83.782   746.000     0.150
    83.779   747.741     0.150
    83.779   747.741     0.150
    83.851   747.291     0.150
    83.881   748.191     0.150
    83.881   748.191     0.150
    83.881   748.191     0.150
    83.881   747.891     0.150
    83.954   748.631     0.150
    84.041   748.991     0.150
    84.261   749.391     0.150
    84.478   750.791     0.150
    84.507   751.291     0.150
    84.507   751.674     0.150
    84.524   750.671     0.150
    84.613   749.791     0.150
    84.775   752.421     0.150
    84.782   751.291     0.150
    84.954   754.039     0.150
    84.954   753.021     0.150
    85.077   753.591     0.150
    85.123   753.391     0.150
    85.123   753.391     0.150
    85.340   753.566     0.150
    85.340   754.591     0.150
    85.340   755.191     0.150
    85.351   755.391     0.150
    85.377   755.291     0.150
    85.539   755.391     0.150
    85.684   757.216     0.150
    85.684   756.491     0.150
    85.819   756.781     0.150
    86.127   756.691     0.150
    86.147   759.191     0.150
    86.349   760.491     0.150
    86.429   763.091     0.150
    86.566   762.691     0.150
    86.573   760.991     0.150
    86.676   764.066     0.150
    86.676   765.109     0.150
    86.676   761.391     0.150
    86.846   762.691     0.150
    87.039   763.891     0.150
    87.113   763.291     0.150
    87.111   763.951     0.150
    87.216   764.991     0.150
    87.238   765.191     0.150
    87.798   767.434     0.150
    87.876   768.791     0.150
    87.933   768.891     0.150
    88.076   769.060     0.150
    88.286   770.591     0.150
    88.491   770.891     0.150
    88.491   770.541     0.150
    88.521   771.291     0.150
    88.521   770.961     0.150
    88.525   770.761     0.150
    88.686   770.591     0.150
    88.782   771.391     0.150
    89.292   774.934     0.150
    89.369   774.663     0.150
    89.416   775.091     0.150
    89.894   777.138     0.150
    89.992   778.329     0.150
    90.180   784.591     0.150
    90.375   780.291     0.150
    90.694   781.591     0.150
    91.377   783.791     0.150
    91.654   785.091     0.150
    92.069   785.091     0.150
    92.075   785.991     0.150
    92.075   786.316     0.150
    92.075  1006.591     0.150
    92.423   792.191     0.150
    93.241   795.091     0.150
    93.388   792.701     0.150
    93.774   796.991     0.150
    93.809   797.091     0.150
    93.936   795.315     0.150
    93.936   795.511     0.150
    94.256   799.091     0.150
    94.489   798.054     0.150
    94.626   798.571     0.150
    95.014   801.491     0.150
    95.014  1030.491     0.150
    95.240   802.486     0.150
    95.240   801.591     0.150
    95.240   802.481     0.150
    95.484   803.091     0.150
    95.514   803.291     0.150
    95.514   802.791     0.150
    95.523   803.672     0.150
    96.385   806.694     0.150
    96.928   816.791     0.150
    97.038   809.755     0.150
    97.679   812.509     0.150
    97.696   813.336     0.150
    98.059   814.994     0.150
    99.379   821.048     0.150
   118.077  1124.439     0.150
   118.077  1197.141     0.150
   118.077  1124.441     0.150
   118.077  1197.141     0.150
   120.065  1129.541     0.150
   146.675  1180.516     0.150
   146.675  1177.791     0.150
   147.370  1178.681     0.150
   163.494  1251.966     0.150
     0.170     6.612     0.150
     0.476    16.552     0.150
     0.859    16.692     0.150
     0.859    29.472     0.150
     0.942    16.932     0.150
     0.942    32.652     0.150
     1.368    23.942     0.150
     1.368    44.022     0.150
     1.552    46.492     0.150
     1.861    31.342     0.150
     1.861    57.592     0.150
     2.056    59.672     0.150
     2.236    36.612     0.150
     2.081    34.902     0.150
     2.451    72.882     0.150
     2.894    46.442     0.150
     2.894    79.712     0.150
     3.142    53.412     0.150
     3.142    94.672     0.150
     3.188    52.242     0.150
     3.188    52.375     0.150
     3.188    48.742     0.150
     3.188    85.932     0.150
     3.432    53.872     0.150
     3.432    96.432     0.150
     4.148    65.052     0.150
     4.148   130.022     0.150
     4.653    69.442     0.150
     4.858    76.652     0.150
     8.538   123.462     0.150
     8.538   220.402     0.150
     9.512   142.272     0.150
     9.627   138.572     0.150
     9.627   137.282     0.150
    10.872   155.482     0.150
    10.921   162.072     0.150
    10.991   160.072     0.150
    11.983   168.972     0.150
    12.891   185.872     0.150
    13.072   184.172     0.150
    13.364   187.972     0.150
    13.444   195.172     0.150
    13.774   197.872     0.150
    13.774   194.742     0.150
    14.164   200.052     0.150
    14.330   205.572     0.150
    14.952   212.392     0.150
    15.131   211.882     0.150
    15.336   220.841     0.150
    15.336   214.072     0.150
    15.757   229.972     0.150
    15.907   231.872     0.150
    15.907   222.892     0.150
    16.327   231.572     0.150
    16.424   228.372     0.150
    16.424   411.772     0.150
    18.431   257.572     0.150
    18.431   254.182     0.150
    18.602   259.172     0.150
    18.826   263.572     0.150
    18.826   259.752     0.150
    19.467   270.872     0.150
    19.467   264.382     0.150
    19.535   269.472     0.150
    19.750   270.872     0.150
    19.817   274.872     0.150
    19.915   272.372     0.150
    19.915   272.572     0.150
    20.147   280.572     0.150
    20.333   278.472     0.150
    20.495   279.572     0.150
    20.639   283.872     0.150
    20.639   279.062     0.150
    20.714   280.497     0.150
    20.714   281.072     0.150
    20.812   285.272     0.150
    21.140   289.772     0.150
    21.307   287.072     0.150
    21.506   289.092     0.150
    21.521   293.872     0.150
    21.970   296.072     0.150
    22.130   298.772     0.150
    22.115   297.872     0.150
    22.405   296.542     0.150
    22.460   302.472     0.150
    22.603   303.372     0.150
    22.688   304.672     0.150
    22.929   308.872     0.150
    22.929   305.492     0.150
    23.211   309.322     0.150
    23.254   309.272     0.150
    23.254   557.672     0.150
    23.352   308.312     0.150
    23.337   310.272     0.150
    23.337   307.992     0.150
    23.636   310.232     0.150
    23.529   310.872     0.150
    24.036   317.197     0.150
    24.036   314.782     0.150
    24.033   318.172     0.150
    24.052   318.672     0.150
    24.462   321.472     0.150
    24.400   317.612     0.150
    24.675   323.972     0.150
    24.675   320.532     0.150
    24.680   325.472     0.150
    24.843   326.872     0.150
    25.235   331.272     0.150
    25.245   328.772     0.150
    25.245   325.972     0.150
    25.338   331.272     0.150
    25.794   330.172     0.150
    25.706   333.772     0.150
    25.691   331.582     0.150
    25.691   331.588     0.150
    25.691   329.352     0.150
    25.853   332.172     0.150
    25.853   332.272     0.150
    25.790   331.172     0.150
    25.853   332.282     0.150
    26.137   331.852     0.150
    26.543   342.972     0.150
    26.733   340.772     0.150
    27.808   348.147     0.150
    27.808   348.452     0.150
    27.711   348.172     0.150
    27.711   348.522     0.150
    27.756   348.672     0.150
    27.756   347.872     0.150
    29.561   365.572     0.150
    29.561   363.872     0.150
    29.985   365.372     0.150
    29.985   367.072     0.150
    30.376   370.162     0.150
    30.843   374.872     0.150
    30.862   377.872     0.150
    31.306   376.972     0.150
    31.306   378.652     0.150
    31.311   378.372     0.150
    31.311   553.142     0.150
    31.311   378.372     0.150
    31.311   553.146     0.150
    31.311   377.972     0.150
    31.315   378.912     0.150
    31.337   378.612     0.150
    31.454   380.632     0.150
    31.880   387.272     0.150
    31.880   451.472     0.150
    32.775   396.972     0.150
    33.860   406.372     0.150
    34.192   405.572     0.150
    34.691   408.192     0.150
    34.692   408.622     0.150
    34.692   562.266     0.150
    34.692   408.272     0.150
    34.692   563.272     0.150
    34.936   412.672     0.150
    34.992   412.232     0.150
    36.447   424.072     0.150
    36.480   426.172     0.150
    36.965   428.647     0.150
    36.965   428.172     0.150
    38.319   442.072     0.150
    38.424   442.672     0.150
    39.424   448.502     0.150
    39.459   450.272     0.150
    39.459   449.492     0.150
    39.695   453.172     0.150
    39.803   453.372     0.150
    39.803   452.272     0.150
    40.037   455.972     0.150
    40.323   457.972     0.150
    40.335   458.072     0.150
    40.575   458.672     0.150
    40.497   461.441     0.150
    40.497   458.572     0.150
    40.500   459.372     0.150
    40.590   460.672     0.150
    40.668   460.892     0.150
    40.668   460.892     0.150
    40.668   458.872     0.150
    41.107   463.872     0.150
    41.951   470.772     0.150
    43.854   484.822     0.150
    43.954   485.392     0.150
    44.784   493.372     0.150
    44.784   492.572     0.150
    44.670   493.872     0.150
    44.905   497.941     0.150
    44.905   492.892     0.150
    46.174   507.872     0.150
    46.174   504.372     0.150
    48.059   517.972     0.150
    48.480   522.472     0.150
    51.001   542.272     0.150
    51.008   541.372     0.150
    51.008   542.622     0.150
    51.008   617.422     0.150
    51.008   542.622     0.150
    51.008   617.417     0.150
    51.008   541.232     0.150
    51.198   543.072     0.150
    51.198   543.462     0.150
    51.337   544.972     0.150
    51.417   544.442     0.150
    51.837   552.172     0.150
    51.837   992.272     0.150
    52.008   548.772     0.150
    52.098   549.472     0.150
    52.366   553.652     0.150
    52.366   549.852     0.150
    52.266    10.300     0.150
    52.266   551.142     0.150
    52.538   554.172     0.150
    52.994   557.172     0.150
    53.398   560.672     0.150
    53.398   560.912     0.150
    53.734   563.962     0.150
    53.929   562.432     0.150
    53.929   562.547     0.150
    53.929   562.092     0.150
    53.931   562.542     0.150
    54.009   563.172     0.150
    54.036   567.892     0.150
    54.036   565.472     0.150
    54.036   566.542     0.150
    54.036   564.632     0.150
    54.613   568.612     0.150
    55.146   572.816     0.150
    55.146   571.972     0.150
    55.701   575.472     0.150
    55.762   576.672     0.150
    55.825   576.472     0.150
    56.602   582.982     0.150
    56.939   585.372     0.150
    56.939   584.452     0.150
    56.939   584.572     0.150
    56.939   583.602     0.150
    57.252   586.072     0.150
    57.634   591.672     0.150
    60.806   612.342     0.150
    60.806   611.472     0.150
    60.806   611.252     0.150
    61.201   613.992     0.150
    61.834   618.581     0.150
    61.834   617.742     0.150
    63.327   625.932     0.150
    63.880   631.672     0.150
    64.514   636.972     0.150
    64.979   640.772     0.150
    64.979   639.392     0.150
    64.979   639.112     0.150
    65.718   643.872     0.150
    65.718   643.392     0.150
    65.718   644.002     0.150
    67.349   654.872     0.150
    68.258   660.302     0.150
    68.315   660.011     0.150
    68.336   660.091     0.150
    68.336   660.672     0.150
    68.336  1201.972     0.150
    68.336   660.422     0.150
    73.605   694.172     0.150
    74.709   699.672     0.150
    74.709   713.372     0.150
    74.709  1278.872     0.150
    75.485   702.672     0.150
    75.496   707.375     0.150
    75.496   703.372     0.150
    75.496   702.762     0.150
    76.098   707.872     0.150
    76.315   709.072     0.150
    76.423   707.672     0.150
    76.454   710.572     0.150
    76.756   710.372     0.150
    76.818   712.922     0.150
    76.967   714.642     0.150
    76.967   713.472     0.150
    76.967   712.592     0.150
    77.643   720.572     0.150
    78.676   725.672     0.150
    80.402   731.272     0.150
    80.514   733.372     0.150
    80.687   733.872     0.150
    80.815   731.972     0.150
    80.820   733.072     0.150
    81.443   737.572     0.150
    81.791   736.782     0.150
    82.046   743.072     0.150
    82.733   745.372     0.150
    83.237   745.652     0.150
    83.799   749.252     0.150
    83.799   749.247     0.150
    83.988   749.817     0.150
    84.034   750.432     0.150
    84.034   750.427     0.150
    84.426   753.172     0.150
    84.508   754.172     0.150
    84.644   752.472     0.150
    84.763   752.002     0.150
    84.771   753.372     0.150
    84.947   754.202     0.150
    84.949   753.772     0.150
    85.181   755.072     0.150
    85.181   755.047     0.150
    85.449   758.672     0.150
    85.447   757.297     0.150
    85.447   757.422     0.150
    85.521   758.522     0.150
    85.521   756.472     0.150
    86.466   762.918     0.150
    86.937   766.147     0.150
    88.618   774.660     0.150
    88.638   772.312     0.150
    90.291   781.372     0.150
    91.364   785.482     0.150
    91.364   785.480     0.150
    92.125   789.962     0.150
    92.125   789.962     0.150
   118.292  1127.205     0.150
   118.292  1201.222     0.150
   118.292  1126.582     0.150
   118.293  1127.202     0.150
   126.415  1144.772     0.150
   126.727  1144.472     0.150
   146.656  1180.272     0.150
     0.367     6.927     0.150
     0.367    12.777     0.150
     0.403     7.887     0.150
     0.403    14.247     0.150
     1.098    36.657     0.150
     2.076    35.097     0.150
     3.231    48.396     0.150
    15.402   217.487     0.150
    31.393   379.757     0.150
    31.393   379.762     0.150
    31.532   379.207     0.150
    34.785   410.403     0.150
    40.584   461.037     0.150
    40.584   461.042     0.150
    50.996   541.117     0.150
    50.996   542.747     0.150
    50.996   542.750     0.150
    50.996   542.437     0.150
    50.996   617.037     0.150
    51.367   541.627     0.150
    53.882   563.087     0.150
    55.124   571.237     0.150
    55.800   577.017     0.150
    56.963   584.967     0.150
    56.963   585.907     0.150
    60.785   611.127     0.150
    63.778   631.372     0.150
    65.724   644.146     0.150
    67.202   654.247     0.150
    85.138   755.847     0.150
    85.138   755.844     0.150
    85.450   757.521     0.150
     0.276     5.399     0.150
     0.276    10.279     0.150
     0.412     7.789     0.150
     0.412    14.149     0.150
     0.841    15.600     0.150
     0.841    29.079     0.150
     1.267    23.239     0.150
     1.267    41.890     0.150
     1.593    26.600     0.150
     1.593    49.390     0.150
     1.821    30.899     0.150
     2.075    34.699     0.150
     2.147    35.789     0.150
     2.257    37.350     0.150
     2.556    42.270     0.150
     2.658    42.699     0.150
     3.063    51.149     0.150
     3.162    51.199     0.150
     3.162    93.600     0.150
     3.206    56.765     0.150
     3.206    93.839     0.150
     3.206    48.079     0.150
     3.206    86.520     0.150
     3.140    51.369     0.150
     4.840    76.779     0.150
     8.645   127.339     0.150
    10.950   157.869     0.150
    10.950   156.819     0.150
    12.037   170.770     0.150
    13.150   184.319     0.150
    13.412   190.869     0.150
    13.536   194.169     0.150
    13.883   198.079     0.150
    15.426   221.889     0.150
    16.016   226.359     0.150
    18.508   254.760     0.150
    18.681   258.069     0.150
    18.885   265.369     0.150
    18.885   261.399     0.150
    19.535   267.069     0.150
    19.535   264.859     0.150
    19.986   273.619     0.150
    19.986   272.069     0.150
    20.306   275.470     0.150
    20.605   279.869     0.150
    20.741   279.770     0.150
    20.741   281.800     0.150
    22.428   302.470     0.150
    22.439   298.379     0.150
    22.797   301.869     0.150
    23.321   309.595     0.150
    23.321   308.569     0.150
    23.395   311.869     0.150
    23.395   308.529     0.150
    23.450   309.729     0.150
    24.572   319.369     0.150
    24.623   324.169     0.150
    24.779   321.919     0.150
    25.170   329.970     0.150
    25.743   330.109     0.150
    25.743   332.720     0.150
    25.743   332.359     0.150
    25.811   332.069     0.150
    25.953   332.895     0.150
    25.952   332.829     0.150
    27.632   347.669     0.150
    27.689   347.669     0.150
    27.872   350.470     0.150
    27.954   345.949     0.150
    31.349   378.879     0.150
    31.349   552.169     0.150
    31.349   378.875     0.150
    31.349   552.164     0.150
    31.866   386.169     0.150
    31.866   452.369     0.150
    32.735   394.369     0.150
    34.229   405.709     0.150
    34.734   409.060     0.150
    34.734   561.720     0.150
    34.735   409.062     0.150
    34.735   561.720     0.150
    34.735   408.359     0.150
    34.853   410.913     0.150
    34.853   408.329     0.150
    36.467   425.569     0.150
    36.472   423.779     0.150
    39.396   446.850     0.150
    39.723   451.744     0.150
    40.636   457.839     0.150
    40.629   459.890     0.150
    40.629   459.890     0.150
    40.629   459.589     0.150
    44.817   493.020     0.150
    44.735   494.569     0.150
    46.168   505.569     0.150
    51.002   542.220     0.150
    51.002   541.839     0.150
    51.002   616.140     0.150
    51.002   541.836     0.150
    51.002   616.138     0.150
    51.002   541.720     0.150
    51.192   543.060     0.150
    51.852   548.970     0.150
    52.128   550.739     0.150
    52.549   554.339     0.150
    53.906   562.569     0.150
    53.906   561.739     0.150
    53.909   562.569     0.150
    54.045   562.939     0.150
    55.135   572.039     0.150
    55.136   571.869     0.150
    55.731   574.979     0.150
    55.779   576.369     0.150
    55.844   577.709     0.150
    56.949   585.169     0.150
    56.949   584.720     0.150
    56.949   585.169     0.150
    60.796   610.060     0.150
    61.762   616.729     0.150
    63.833   631.169     0.150
    65.005   640.146     0.150
    65.005   640.640     0.150
    65.005   639.149     0.150
    65.720   643.149     0.150
    67.201   653.345     0.150
    68.324   659.788     0.150
    68.324   658.770     0.150
    73.591   691.869     0.150
    76.834   711.020     0.150
    80.720   730.896     0.150
    82.398   742.558     0.150
    83.764   747.789     0.150
    83.764   747.789     0.150
    84.056   751.649     0.150
    84.057   751.653     0.150
    85.161   754.989     0.150
    85.161   754.987     0.150
    85.448   756.599     0.150
    85.448   757.569     0.150
    85.448   756.600     0.150
    92.101   787.369     0.150
    92.101   787.369     0.150
    92.101   787.369     0.150
   118.348  1125.745     0.150
   118.348  1125.749     0.150
   119.713  1128.901     0.150
   146.692  1180.869     0.150
   146.692  1181.169     0.150
     0.423     8.078     0.150
     0.423    14.688     0.150
     0.861    16.038     0.150
     0.861    28.828     0.150
     0.947    17.478     0.150
     0.947    30.798     0.150
     1.287    23.228     0.150
     1.287    42.048     0.150
     1.584    27.308     0.150
     1.584    47.728     0.150
     1.829    30.298     0.150
     2.129    34.338     0.150
     2.129    64.678     0.150
     2.075    34.918     0.150
     2.196    36.738     0.150
     2.252    36.278     0.150
     2.535    41.518     0.150
     2.675    42.418     0.150
     3.057    48.147     0.150
     3.057    85.768     0.150
     3.158    52.678     0.150
     3.101    48.328     0.150
     3.203    51.633     0.150
     3.203    51.883     0.150
     3.203    49.048     0.150
     3.203    88.098     0.150
     3.139    50.698     0.150
     3.393    53.107     0.150
     4.122    62.458     0.150
     4.296    65.228     0.150
     5.155    82.088     0.150
     6.348    91.488     0.150
     8.623   122.308     0.150
     8.623   218.768     0.150
     9.581   137.588     0.150
     9.655   137.388     0.150
     9.655   138.018     0.150
    10.935   158.388     0.150
    10.935   154.578     0.150
    10.990   158.888     0.150
    11.022   155.988     0.150
    12.026   168.688     0.150
    12.899   184.562     0.150
    13.403   186.988     0.150
    13.518   194.088     0.150
    13.719   191.098     0.150
    13.861   193.938     0.150
    14.033   198.088     0.150
    14.118   197.288     0.150
    14.122   199.068     0.150
    14.404   205.388     0.150
    14.726   209.988     0.150
    14.908   208.058     0.150
    15.140   212.788     0.150
    15.140   211.678     0.150
    15.263   217.888     0.150
    15.408   222.106     0.150
    15.408   216.988     0.150
    15.845   225.288     0.150
    15.994   222.688     0.150
    17.321   243.163     0.150
    17.321   239.348     0.150
    17.548   246.188     0.150
    18.493   255.488     0.150
    18.493   254.928     0.150
    18.666   257.388     0.150
    18.800   256.488     0.150
    18.872   262.688     0.150
    18.872   258.607     0.150
    19.522   267.688     0.150
    19.522   266.338     0.150
    19.609   268.688     0.150
    19.826   269.088     0.150
    19.972   272.913     0.150
    19.972   272.488     0.150
    20.187   278.288     0.150
    20.312   274.988     0.150
    20.692   279.938     0.150
    20.692   281.888     0.150
    20.692   276.688     0.150
    20.720   281.688     0.150
    20.720   279.397     0.150
    21.225   286.988     0.150
    21.558   289.088     0.150
    21.592   290.488     0.150
    21.592   288.758     0.150
    21.604   287.598     0.150
    21.805   293.788     0.150
    22.065   293.038     0.150
    22.216   296.388     0.150
    22.216   296.818     0.150
    22.434   300.188     0.150
    22.562   300.688     0.150
    22.775   301.888     0.150
    23.016   305.438     0.150
    23.299   308.413     0.150
    23.299   311.388     0.150
    23.259   337.488     0.150
    23.259   554.388     0.150
    23.259   570.588     0.150
    23.259   599.088     0.150
    23.383   309.288     0.150
    23.383   307.647     0.150
    23.430   310.088     0.150
    23.430   308.258     0.150
    23.669   310.198     0.150
    23.605   308.948     0.150
    23.684   311.388     0.150
    23.684   311.218     0.150
    24.388   315.768     0.150
    24.758   320.288     0.150
    24.758   319.088     0.150
    24.927   322.588     0.150
    25.122   326.988     0.150
    25.160   325.688     0.150
    25.266   326.988     0.150
    25.261   326.988     0.150
    25.261   324.988     0.150
    25.283   329.188     0.150
    25.424   327.188     0.150
    25.450   329.288     0.150
    25.732   330.839     0.150
    25.790   329.488     0.150
    25.830   328.288     0.150
    25.933   332.338     0.150
    25.933   539.588     0.150
    25.933   330.988     0.150
    25.933   539.388     0.150
    25.932   331.008     0.150
    25.932   539.408     0.150
    26.538   336.288     0.150
    26.587   340.488     0.150
    26.811   339.288     0.150
    27.647   344.588     0.150
    27.647   347.338     0.150
    27.738   347.688     0.150
    27.738   346.088     0.150
    27.860   349.513     0.150
    27.860   543.213     0.150
    27.860   347.578     0.150
    28.147   351.888     0.150
    29.483   364.588     0.150
    29.482   364.559     0.150
    29.482   361.788     0.150
    29.968   365.688     0.150
    29.968   366.738     0.150
    30.377   370.938     0.150
    30.802   373.688     0.150
    30.822   375.088     0.150
    31.336   378.088     0.150
    31.342   377.908     0.150
    31.342   552.107     0.150
    31.342   377.907     0.150
    31.342   552.105     0.150
    31.809   384.588     0.150
    31.869   385.988     0.150
    32.742   394.388     0.150
    33.802   402.388     0.150
    34.221   404.802     0.150
    34.221   403.988     0.150
    34.726   408.758     0.150
    34.727   408.580     0.150
    34.727   561.438     0.150
    34.727   408.888     0.150
    34.727   560.488     0.150
    34.869   409.588     0.150
    34.869   410.831     0.150
    34.869   408.388     0.150
    34.928   409.897     0.150
    36.145   419.788     0.150
    36.466   423.288     0.150
    36.469   425.488     0.150
    36.969   425.888     0.150
    38.347   441.388     0.150
    38.454   442.088     0.150
    39.150   448.288     0.150
    39.409   448.588     0.150
    39.409   448.368     0.150
    39.739   451.838     0.150
    39.739   577.438     0.150
    39.739   450.988     0.150
    39.723   452.988     0.150
    40.352   457.488     0.150
    40.364   457.488     0.150
    40.464   458.069     0.150
    40.529   458.988     0.150
    40.625   458.008     0.150
    40.619   459.788     0.150
    40.636   459.808     0.150
    40.636   580.198     0.150
    40.636   459.808     0.150
    40.636   580.195     0.150
    40.636   457.588     0.150
    41.136   463.688     0.150
    41.979   470.988     0.150
    43.801   484.088     0.150
    43.856   483.788     0.150
    43.991   485.438     0.150
    44.721   493.588     0.150
    44.811   492.888     0.150
    44.811   491.488     0.150
    45.706   501.088     0.150
    46.169   506.188     0.150
    48.070   518.498     0.150
    48.433   521.488     0.150
    51.003   540.888     0.150
    51.003   541.738     0.150
    51.003   616.438     0.150
    51.003   541.738     0.150
    51.003   616.438     0.150
    51.003   539.938     0.150
    51.003   615.728     0.150
    51.192   541.288     0.150
    51.424   542.388     0.150
    51.849   549.888     0.150
    51.849   990.488     0.150
    52.014   547.288     0.150
    52.121   548.188     0.150
    52.206   548.988     0.150
    52.206    10.899     0.150
    52.206   548.478     0.150
    52.346   550.518     0.150
    52.546   551.388     0.150
    52.698   555.378     0.150
    53.001   554.588     0.150
    53.312   560.128     0.150
    53.404   559.588     0.150
    53.404   560.038     0.150
    53.740   562.628     0.150
    53.876   564.368     0.150
    53.910   560.718     0.150
    53.910   562.413     0.150
    53.910   562.088     0.150
    53.910   561.388     0.150
    53.913   562.408     0.150
    54.005   563.968     0.150
    54.015   561.888     0.150
    54.043   564.622     0.150
    54.043   564.885     0.150
    54.043   563.488     0.150
    54.043   562.397     0.150
    54.279   565.988     0.150
    54.407   567.908     0.150
    54.542   568.548     0.150
    54.623   566.428     0.150
    55.137   572.107     0.150
    55.137   570.988     0.150
    55.137   570.768     0.150
    55.138   571.788     0.150
    55.724   574.288     0.150
    55.775   575.088     0.150
    55.840   575.868     0.150
    56.947   582.988     0.150
    56.947   582.888     0.150
    57.632   588.988     0.150
    60.797   611.308     0.150
    60.797   610.988     0.150
    60.797   609.498     0.150
    61.226   612.158     0.150
    61.776   616.347     0.150
    61.776   615.888     0.150
    61.776   614.598     0.150
    63.842   630.988     0.150
    64.077   633.475     0.150
    64.441   633.388     0.150
    64.441   667.488     0.150
    64.441   633.188     0.150
    64.826   638.316     0.150
    64.999   639.838     0.150
    64.999   637.518     0.150
    64.999   637.828     0.150
    65.719   642.888     0.150
    65.719   642.468     0.150
    65.719   641.658     0.150
    65.751   642.995     0.150
    65.755   644.562     0.150
    65.877   646.102     0.150
    65.898   645.421     0.150
    65.901   644.727     0.150
    65.968   645.283     0.150
    65.968   645.473     0.150
    66.252   647.232     0.150
    66.328   647.522     0.150
    66.632   649.597     0.150
    66.944   651.638     0.150
    67.200   652.288     0.150
    67.338   654.188     0.150
    67.513   653.738     0.150
    67.806   655.058     0.150
    68.326   659.188     0.150
    68.326   682.688     0.150
    68.326  1198.488     0.150
    68.326   658.088     0.150
    73.593   691.913     0.150
    75.500   701.588     0.150
    75.513   704.883     0.150
    75.652   704.361     0.150
    75.652   702.888     0.150
    75.837   702.788     0.150
    76.111   705.288     0.150
    76.327   707.788     0.150
    76.439   707.588     0.150
    76.772   708.788     0.150
    76.830   711.013     0.150
    76.972   712.747     0.150
    76.978   712.088     0.150
    76.978   710.448     0.150
    77.539   713.288     0.150
    77.862   715.658     0.150
    79.075   722.688     0.150
    79.145   722.288     0.150
    79.239   721.588     0.150
    79.507   726.263     0.150
    79.894   726.088     0.150
    80.323   728.288     0.150
    80.508   728.388     0.150
    80.697   730.988     0.150
    80.740   730.978     0.150
    80.740   731.202     0.150
    80.857   733.368     0.150
    81.710   736.668     0.150
    82.390   742.251     0.150
    83.157   744.098     0.150
    83.536   747.518     0.150
    83.536   747.518     0.150
    83.771   747.428     0.150
    83.771   747.426     0.150
    84.052   749.607     0.150
    84.052   750.106     0.150
    84.052   748.588     0.150
    84.052   749.610     0.150
    84.052   748.188     0.150
    84.374   751.688     0.150
    84.971   753.718     0.150
    85.164   754.088     0.150
    85.164   754.041     0.150
    85.164   752.988     0.150
    85.164   752.668     0.150
    85.444   755.988     0.150
    85.444   755.188     0.150
    85.437   755.488     0.150
    85.447   755.348     0.150
    85.447   755.088     0.150
    85.447   754.678     0.150
    85.447   755.188     0.150
    85.547   756.678     0.150
    86.470   759.923     0.150
    86.839   761.168     0.150
    87.006   765.562     0.150
    87.006   766.039     0.150
    87.006   763.388     0.150
    87.927   767.098     0.150
    88.595   770.188     0.150
    88.625   772.458     0.150
    88.625   771.743     0.150
    88.642   770.937     0.150
    88.642   770.738     0.150
    91.346   783.778     0.150
    91.346   783.780     0.150
    92.105   786.188     0.150
    92.105   786.458     0.150
    92.105   786.457     0.150
    95.615  1034.558     0.150
    95.615   803.368     0.150
    95.615   804.263     0.150
    95.615  1034.562     0.150
    95.615   803.388     0.150
    97.167   813.088     0.150
   118.336  1126.139     0.150
   118.336  1743.295     0.150
   118.336  1125.438     0.150
   118.337  1126.138     0.150
   119.734  1127.838     0.150
   119.735  1127.748     0.150
   119.735  1129.132     0.150
   119.735  1127.688     0.150
   121.842  1131.888     0.150
   122.381  1131.748     0.150
   125.266  1137.788     0.150
   144.889  1174.988     0.150
   146.685  1180.363     0.150
   146.685  1178.288     0.150
   152.587  1194.588     0.150
   155.049  1200.688     0.150
   155.399  1192.568     0.150
   166.572  1269.213     0.150
     0.375     7.260     0.150
     0.375    13.330     0.150
     0.847    15.060     0.150
     0.847    29.930     0.150
     0.978    18.739     0.150
     0.978    33.819     0.150
     1.243    22.550     0.150
     1.243    40.949     0.150
     1.243    23.020     0.150
     1.243    42.609     0.150
     1.564    26.270     0.150
     1.564    47.170     0.150
     1.564    27.430     0.150
     1.852    32.090     0.150
     1.852    57.159     0.150
     2.038    34.819     0.150
     2.176    35.520     0.150
     2.176    64.989     0.150
     2.176    36.960     0.150
     2.577    42.600     0.150
     2.577    75.000     0.150
     3.089    48.800     0.150
     3.103    49.760     0.150
     3.102    52.529     0.150
     3.790    60.630     0.150
     3.790   103.689     0.150
     4.690    70.109     0.150
    20.021   275.574     0.150
    25.716   332.123     0.150
    31.387   380.156     0.150
    34.773   409.500     0.150
    50.964   542.449     0.150
    53.868   562.500     0.150
   118.321  1127.356     0.150
     0.323     6.164     0.150
     0.323    12.074     0.150
     0.678    12.305     0.150
     0.678    23.584     0.150
     1.070    20.484     0.150
     1.070    38.345     0.150
     1.170    20.914     0.150
     1.170    38.994     0.150
     1.656    26.574     0.150
     1.656    51.395     0.150
     2.044    35.564     0.150
     2.337    36.034     0.150
     2.337    67.674     0.150
     2.342    37.294     0.150
     2.342    67.924     0.150
     2.761    43.254     0.150
     2.761    78.725     0.150
     3.110    50.555     0.150
     3.110    87.135     0.150
     3.200    48.954     0.150
     4.804    70.714     0.150
     8.834   128.975     0.150
    18.965   261.464     0.150
    20.144   275.329     0.150
    22.443   301.664     0.150
    23.783   312.774     0.150
    25.811   329.174     0.150
    25.811   332.154     0.150
    31.453   380.004     0.150
    31.453   380.004     0.150
    34.264   406.055     0.150
    34.847   409.635     0.150
    34.848   409.637     0.150
    44.116   487.424     0.150
    50.956   541.124     0.150
    50.956   541.129     0.150
    50.956   540.314     0.150
    51.424   541.484     0.150
    54.027   562.234     0.150
    55.081   571.024     0.150
    56.934   583.185     0.150
    60.742   609.185     0.150
    67.446   651.084     0.150
    84.063   751.694     0.150
   118.419  1126.900     0.150
   118.419  1126.904     0.150
     0.924    17.579     0.150
     0.924    31.169     0.150
     1.330    23.559     0.150
     1.330    41.089     0.150
     1.799    30.759     0.150
     1.799    55.068     0.150
     2.118    34.039     0.150
     2.723    42.869     0.150
     3.182    49.909     0.150
    18.893   260.648     0.150
    19.922   271.224     0.150
    25.756   328.309     0.150
    25.756   329.924     0.150
    25.756   329.199     0.150
    31.293   377.068     0.150
    31.293   551.499     0.150
    31.293   377.074     0.150
    31.293   551.499     0.150
    31.297   375.669     0.150
    34.252   404.459     0.150
    34.677   407.499     0.150
    34.677   560.699     0.150
    34.677   406.818     0.150
    40.574   456.148     0.150
    42.895   477.389     0.150
    44.762   491.648     0.150
    44.762   489.799     0.150
    51.046   540.299     0.150
    51.046   540.299     0.150
    52.155   549.789     0.150
    52.586   552.919     0.150
    53.957   562.320     0.150
    53.957   560.799     0.150
    53.960   562.318     0.150
    55.182   570.349     0.150
    55.758   574.419     0.150
    55.877   576.929     0.150
    56.986   582.389     0.150
    56.986   582.699     0.150
    60.842   609.989     0.150
    65.034   640.647     0.150
    65.761   643.659     0.150
    65.761   642.659     0.150
    85.211   756.019     0.150
   118.359  1125.549     0.150
   118.360  1125.549     0.150
   146.636  1179.349     0.150
     0.567    11.171     0.150
     0.567    20.241     0.150
     0.678    23.381     0.150
     2.034    35.321     0.150
     3.002    50.681     0.150
     3.002    93.041     0.150
     3.204    54.786     0.150
     3.204    91.661     0.150
     3.204    46.591     0.150
     3.204    84.201     0.150
     8.245   118.041     0.150
    19.766   271.541     0.150
    23.146   305.971     0.150
    23.254   306.421     0.150
    25.571   329.716     0.150
    25.512   327.461     0.150
    25.512   329.641     0.150
    25.512   328.610     0.150
    25.570   328.761     0.150
    25.699   325.991     0.150
    27.678   347.166     0.150
    27.770   348.940     0.150
    31.257   378.011     0.150
    31.257   551.961     0.150
    31.256   378.016     0.150
    31.256   551.958     0.150
    34.622   408.641     0.150
    34.622   561.391     0.150
    34.623   408.641     0.150
    34.623   561.387     0.150
    39.984   454.565     0.150
    40.729   461.621     0.150
    40.729   461.620     0.150
    40.729   460.440     0.150
    48.074   517.421     0.150
    50.978   541.341     0.150
    50.978   542.371     0.150
    50.978   542.366     0.150
    50.978   540.041     0.150
    51.167   542.681     0.150
    51.975   547.381     0.150
    53.942   563.157     0.150
    53.945   563.161     0.150
    55.129   571.801     0.150
    55.578   573.791     0.150
    55.728   574.491     0.150
    56.865   583.531     0.150
    56.865   583.440     0.150
    60.787   611.641     0.150
    61.989   618.301     0.150
    64.866   639.834     0.150
    64.866   638.471     0.150
    64.866   637.921     0.150
    65.666   643.181     0.150
    68.230   657.360     0.150
    83.930   748.781     0.150
    83.930   748.871     0.150
    83.930   748.784     0.150
    83.930   748.641     0.150
    85.188   753.671     0.150
    85.188   753.669     0.150
    85.399   755.690     0.150
    85.399   755.690     0.150
   118.106  1126.003     0.150
   118.107  1126.001     0.150
     0.847    15.598     0.150
     0.847    28.777     0.150
     0.955    17.688     0.150
     0.955    30.518     0.150
     1.288    23.268     0.150
     1.288    43.537     0.150
     1.603    27.178     0.150
     1.603    49.298     0.150
     1.809    29.838     0.150
     2.125    35.088     0.150
     2.125    65.058     0.150
     2.093    34.617     0.150
     2.537    41.178     0.150
     2.537    73.298     0.150
     2.681    40.947     0.150
     2.851    45.117     0.150
     2.851    81.728     0.150
     3.042    47.357     0.150
     3.042    47.768     0.150
     3.142    51.918     0.150
     3.142    93.928     0.150
     3.186    51.798     0.150
     3.186    91.622     0.150
     3.186    51.372     0.150
     3.186    53.298     0.150
     3.186    47.857     0.150
     3.120    48.808     0.150
     3.158    50.228     0.150
     3.381    52.838     0.150
     3.517    54.037     0.150
     3.517    99.438     0.150
     3.690    56.718     0.150
     3.840    59.947     0.150
     4.106    62.487     0.150
     4.316    65.338     0.150
     4.720    70.058     0.150
     4.860    74.298     0.150
     5.173    83.077     0.150
     5.329    81.997     0.150
     6.334    93.327     0.150
     8.634   124.157     0.150
     8.634   218.947     0.150
     9.249   134.128     0.150
     9.576   137.728     0.150
     9.640   136.428     0.150
     9.640   136.027     0.150
    10.927   158.228     0.150
    10.927   154.268     0.150
    11.008   156.327     0.150
    10.985   158.327     0.150
    12.014   167.628     0.150
    12.881   185.027     0.150
    13.390   187.527     0.150
    13.514   193.027     0.150
    13.823   196.827     0.150
    13.870   200.728     0.150
    13.870   194.218     0.150
    13.870   347.428     0.150
    14.135   200.008     0.150
    14.135   355.567     0.150
    14.721   209.827     0.150
    14.920   211.197     0.150
    15.123   211.827     0.150
    15.123   211.997     0.150
    15.340   216.827     0.150
    15.404   220.996     0.150
    15.404   214.527     0.150
    15.460   215.327     0.150
    15.406   214.168     0.150
    15.465   215.598     0.150
    15.601   222.928     0.150
    15.853   229.527     0.150
    15.846   224.527     0.150
    16.003   223.287     0.150
    16.467   231.628     0.150
    16.467   413.327     0.150
    17.326   245.253     0.150
    17.326   240.407     0.150
    18.485   255.827     0.150
    18.485   253.878     0.150
    18.658   256.628     0.150
    18.780   258.928     0.150
    18.892   262.527     0.150
    18.892   258.107     0.150
    19.167   262.628     0.150
    19.512   265.327     0.150
    19.512   264.107     0.150
    19.606   268.928     0.150
    19.824   271.527     0.150
    19.896   272.827     0.150
    19.963   272.678     0.150
    20.293   274.327     0.150
    20.207   278.027     0.150
    20.274   277.228     0.150
    20.672   279.478     0.150
    20.672   279.827     0.150
    20.672   277.728     0.150
    20.591   279.128     0.150
    20.720   282.327     0.150
    20.720   277.447     0.150
    20.895   285.327     0.150
    21.227   289.128     0.150
    21.271   283.237     0.150
    21.596   288.357     0.150
    21.824   293.928     0.150
    22.057   296.628     0.150
    22.219   298.428     0.150
    22.219   294.088     0.150
    22.208   297.728     0.150
    22.282   299.027     0.150
    22.300   297.327     0.150
    22.449   299.827     0.150
    22.449   544.027     0.150
    22.574   300.827     0.150
    22.779   304.027     0.150
    23.026   308.228     0.150
    23.026   304.378     0.150
    23.304   309.777     0.150
    23.304   310.928     0.150
    23.277   309.128     0.150
    23.277   568.027     0.150
    23.311   310.327     0.150
    23.402   305.928     0.150
    23.445   309.728     0.150
    23.445   307.798     0.150
    23.654   308.197     0.150
    23.620   311.728     0.150
    23.620   309.197     0.150
    23.689   309.367     0.150
    23.896   316.027     0.150
    23.970   311.298     0.150
    24.075   315.827     0.150
    24.109   316.027     0.150
    24.138   316.228     0.150
    24.180   316.728     0.150
    24.405   316.338     0.150
    24.559   321.228     0.150
    24.629   320.527     0.150
    24.771   321.728     0.150
    24.771   318.708     0.150
    24.805   321.728     0.150
    24.916   323.827     0.150
    24.939   326.527     0.150
    25.142   326.428     0.150
    25.179   325.728     0.150
    25.276   328.327     0.150
    25.280   327.327     0.150
    25.280   363.827     0.150
    25.280   586.628     0.150
    25.280   325.928     0.150
    25.302   328.527     0.150
    25.435   329.027     0.150
    25.467   328.728     0.150
    25.824   327.272     0.150
    25.824   326.827     0.150
    25.752   331.239     0.150
    25.752   330.527     0.150
    25.752   540.878     0.150
    25.802   332.327     0.150
    25.850   328.827     0.150
    25.947   332.277     0.150
    25.947   330.327     0.150
    25.946   330.317     0.150
    26.080   331.838     0.150
    26.606   340.327     0.150
    26.826   339.428     0.150
    27.240   341.327     0.150
    27.655   344.327     0.150
    27.655   347.378     0.150
    27.712   345.938     0.150
    27.754   347.327     0.150
    27.754   345.628     0.150
    27.849   348.842     0.150
    27.849   349.003     0.150
    27.972   352.728     0.150
    28.165   351.728     0.150
    28.804   357.228     0.150
    29.484   364.277     0.150
    29.484   362.527     0.150
    29.484   361.027     0.150
    29.484   364.277     0.150
    29.948   366.027     0.150
    30.359   370.157     0.150
    30.815   373.827     0.150
    30.834   375.228     0.150
    31.322   378.228     0.150
    31.322   377.787     0.150
    31.327   377.617     0.150
    31.327   551.897     0.150
    31.327   377.621     0.150
    31.327   551.902     0.150
    31.331   377.088     0.150
    31.530   378.938     0.150
    31.819   384.527     0.150
    31.886   386.128     0.150
    31.886   696.028     0.150
    32.757   391.027     0.150
    33.811   402.228     0.150
    33.907   401.223     0.150
    34.293   405.697     0.150
    34.240   405.947     0.150
    34.240   403.327     0.150
    34.712   407.438     0.150
    34.712   561.067     0.150
    34.713   408.277     0.150
    34.713   561.577     0.150
    34.713   407.428     0.150
    34.713   562.027     0.150
    34.876   410.878     0.150
    34.876   408.728     0.150
    34.935   411.027     0.150
    34.935   409.027     0.150
    36.486   425.527     0.150
    36.486   423.527     0.150
    36.952   426.527     0.150
    38.367   441.027     0.150
    38.473   442.027     0.150
    39.170   448.027     0.150
    39.419   448.728     0.150
    39.486   448.617     0.150
    39.746   451.378     0.150
    39.746   576.878     0.150
    39.746   451.728     0.150
    39.743   452.928     0.150
    40.371   457.428     0.150
    40.384   457.327     0.150
    40.478   458.697     0.150
    40.478   455.827     0.150
    40.613   458.963     0.150
    40.613   457.617     0.150
    40.548   458.928     0.150
    40.651   459.947     0.150
    40.651   580.697     0.150
    40.651   810.167     0.150
    40.651   459.947     0.150
    40.651   580.702     0.150
    40.651   810.167     0.150
    40.651   457.527     0.150
    40.638   459.827     0.150
    41.155   463.527     0.150
    41.676   469.478     0.150
    41.998   470.827     0.150
    42.191   471.268     0.150
    43.063   479.702     0.150
    43.063   476.827     0.150
    43.840   483.628     0.150
    43.810   484.527     0.150
    43.870   485.327     0.150
    43.870   592.527     0.150
    43.977   485.997     0.150
    44.796   492.928     0.150
    44.796   492.628     0.150
    44.796   490.428     0.150
    44.740   493.728     0.150
    44.886   493.021     0.150
    44.886   494.697     0.150
    44.886   493.827     0.150
    44.886   491.657     0.150
    45.346   498.812     0.150
    45.721   500.827     0.150
    46.116   504.197     0.150
    46.187   505.027     0.150
    46.187   502.428     0.150
    48.053   519.387     0.150
    48.053   517.388     0.150
    48.445   521.327     0.150
    50.933   541.471     0.150
    50.912   541.817     0.150
    50.915   541.817     0.150
    51.020   540.827     0.150
    51.020   540.708     0.150
    51.020   541.548     0.150
    51.020   616.098     0.150
    51.020   541.553     0.150
    51.020   616.101     0.150
    51.020   541.428     0.150
    51.020   615.848     0.150
    51.022   540.827     0.150
    51.308   544.132     0.150
    51.308   540.527     0.150
    51.360   543.928     0.150
    51.443   543.537     0.150
    51.868   550.128     0.150
    51.868   989.628     0.150
    52.033   546.827     0.150
    52.141   548.027     0.150
    52.214   548.928     0.150
    52.214   622.327     0.150
    52.214   668.528     0.150
    52.214   547.588     0.150
    52.565   551.428     0.150
    52.565   623.327     0.150
    52.717   555.247     0.150
    53.019   554.428     0.150
    53.331   559.958     0.150
    53.422   558.527     0.150
    53.422   559.657     0.150
    53.894   564.147     0.150
    53.927   561.952     0.150
    53.929   561.947     0.150
    54.024   563.598     0.150
    54.034   561.428     0.150
    54.061   563.848     0.150
    54.061   565.193     0.150
    54.061   565.397     0.150
    54.061   563.728     0.150
    54.061   565.058     0.150
    54.061   562.447     0.150
    54.297   566.208     0.150
    54.425   567.758     0.150
    54.561   568.298     0.150
    54.641   566.378     0.150
    55.154   571.897     0.150
    55.154   570.628     0.150
    55.154   569.918     0.150
    55.155   571.503     0.150
    55.744   573.728     0.150
    55.794   574.527     0.150
    55.859   574.817     0.150
    56.965   584.228     0.150
    56.965   583.027     0.150
    56.965   582.628     0.150
    56.965   582.938     0.150
    57.283   584.928     0.150
    57.650   588.628     0.150
    60.743   610.628     0.150
    60.743   610.641     0.150
    60.815   611.347     0.150
    60.815   610.628     0.150
    60.815   609.638     0.150
    61.246   612.107     0.150
    61.785   615.986     0.150
    61.785   616.327     0.150
    61.785   615.397     0.150
    63.318   627.706     0.150
    63.632   629.327     0.150
    63.855   630.728     0.150
    64.096   633.413     0.150
    64.120   633.116     0.150
    64.263   633.625     0.150
    64.445   633.527     0.150
    64.445   772.628     0.150
    64.845   638.126     0.150
    64.952   638.384     0.150
    65.018   639.493     0.150
    65.571   643.696     0.150
    65.738   642.628     0.150
    65.738   642.337     0.150
    65.738   641.978     0.150
    65.774   644.358     0.150
    65.897   644.976     0.150
    65.918   645.396     0.150
    65.920   644.987     0.150
    65.988   645.206     0.150
    66.271   647.337     0.150
    66.347   647.511     0.150
    66.651   649.829     0.150
    66.964   651.001     0.150
    67.218   652.778     0.150
    67.218   652.028     0.150
    67.355   653.927     0.150
    68.249   658.038     0.150
    68.344   659.147     0.150
    68.344   684.228     0.150
    68.344  1200.528     0.150
    68.344  1461.128     0.150
    68.344   658.347     0.150
    68.930   663.368     0.150
    68.946   661.868     0.150
    69.162   663.587     0.150
    74.741   699.228     0.150
    74.741   713.028     0.150
    75.532   705.448     0.150
    75.532   705.028     0.150
    75.532   702.468     0.150
    75.671   704.304     0.150
    75.671   702.327     0.150
    75.854   702.628     0.150
    76.131   705.528     0.150
    76.458   707.327     0.150
    76.849   710.603     0.150
    76.997   712.497     0.150
    76.997   711.728     0.150
    76.997   709.897     0.150
    77.557   712.927     0.150
    77.863   715.257     0.150
    78.359   719.628     0.150
    78.714   721.228     0.150
    78.983   722.007     0.150
    79.093   722.327     0.150
    79.162   721.927     0.150
    79.257   722.528     0.150
    79.895   726.528     0.150
    79.942   725.327     0.150
    79.890   728.128     0.150
    80.354   728.657     0.150
    80.289   730.128     0.150
    80.526   729.128     0.150
    80.741   730.858     0.150
    80.741   731.128     0.150
    80.716   731.327     0.150
    81.237   735.128     0.150
    81.711   736.157     0.150
    81.805   738.427     0.150
    82.081   739.028     0.150
    82.481   741.528     0.150
    83.509   745.288     0.150
    83.681   745.858     0.150
    83.786   747.448     0.150
    83.786   747.444     0.150
    83.766   747.028     0.150
    84.045   748.827     0.150
    84.071   749.257     0.150
    84.071   943.927     0.150
    84.071   749.263     0.150
    84.071   943.927     0.150
    84.468   750.228     0.150
    84.520   751.228     0.150
    84.545   751.427     0.150
    84.706   750.317     0.150
    84.685   752.427     0.150
    84.695   753.198     0.150
    84.695   751.028     0.150
    84.990   751.708     0.150
    84.991   751.628     0.150
    85.181   754.228     0.150
    85.181   754.218     0.150
    85.181   753.628     0.150
    85.447   754.528     0.150
    85.465   755.603     0.150
    85.547   756.167     0.150
    85.545   755.628     0.150
    85.617   758.728     0.150
    86.839   762.567     0.150
    87.023   765.253     0.150
    87.023   765.515     0.150
    87.023   765.948     0.150
    87.049   762.827     0.150
    88.173   768.007     0.150
    88.387   768.427     0.150
    88.592   769.966     0.150
    88.644   769.827     0.150
    88.661   771.427     0.150
    88.661   769.897     0.150
    88.665   770.237     0.150
    88.909   771.427     0.150
    90.311   778.827     0.150
    90.764   779.327     0.150
    92.122   787.358     0.150
    92.122   787.360     0.150
    92.251   785.728     0.150
    92.399   786.728     0.150
    93.582   793.718     0.150
    94.616   803.335     0.150
    94.616  1028.739     0.150
    94.993   800.241     0.150
    94.993   800.237     0.150
    95.065   803.601     0.150
    95.065  1033.575     0.150
    95.119  1030.728     0.150
    95.580   807.401     0.150
    95.580  1034.897     0.150
    95.633   803.778     0.150
    95.633   803.778     0.150
    95.649   807.985     0.150
    96.491  1040.503     0.150
    97.168   811.763     0.150
    97.519   816.306     0.150
    97.820   817.343     0.150
    97.974  1053.425     0.150
    98.184   815.401     0.150
   118.355  1124.507     0.150
   118.355  1125.978     0.150
   118.356  1125.978     0.150
   119.729  1129.214     0.150
   126.484  1141.728     0.150
   126.502  1142.427     0.150
   126.502  1142.558     0.150
   126.665  1142.728     0.150
   146.670  1179.802     0.150
   147.351  1178.688     0.150
   150.629  1191.757     0.150
   163.592  1250.778     0.150
     0.471    15.922     0.150
     0.842    17.111     0.150
     0.965    18.092     0.150
     0.965    32.361     0.150
     1.375    24.521     0.150
     1.375    44.650     0.150
     1.526    26.061     0.150
     1.526    47.752     0.150
     2.061    35.221     0.150
     2.254    36.951     0.150
     2.254    66.531     0.150
     2.442    40.551     0.150
     2.442    69.961     0.150
     3.045    50.400     0.150
     4.626    68.922     0.150
     4.626   121.262     0.150
     4.840    87.650     0.150
    14.562   203.932     0.150
    15.302   211.730     0.150
    19.921   272.887     0.150
    27.816   348.486     0.150
    30.398   369.031     0.150
    31.325   378.086     0.150
    31.325   552.703     0.150
    31.326   378.082     0.150
    31.326   552.701     0.150
    34.705   408.654     0.150
    34.705   562.262     0.150
    44.799   493.137     0.150
    50.988   542.541     0.150
    51.395   540.992     0.150
    53.911   563.139     0.150
    53.913   563.141     0.150
    55.127   572.477     0.150
   118.266  1126.201     0.150
   118.267  1126.201     0.150
   146.671  1180.762     0.150
   146.671  1178.061     0.150
     0.756    14.301     0.150
     0.756    27.141     0.150
     1.039    34.051     0.150
     1.464    47.602     0.150
     1.519    25.922     0.150
     1.519    47.432     0.150
     1.904    30.701     0.150
     1.904    56.602     0.150
     1.972    32.771     0.150
     1.972    58.092     0.150
     2.092    34.102     0.150
     2.352    39.451     0.150
     2.352    70.061     0.150
     2.830    44.570     0.150
     3.126    53.281     0.150
     3.126    93.711     0.150
     3.174    51.391     0.150
     3.174    50.381     0.150
     3.148    50.381     0.150
     3.300    52.502     0.150
     3.798    61.131     0.150
     4.075    61.801     0.150
     4.878    73.150     0.150
     6.267    94.121     0.150
     8.437   122.141     0.150
     9.138   134.320     0.150
     9.431   138.621     0.150
     9.595   138.121     0.150
    10.798   157.521     0.150
    10.798   155.131     0.150
    10.840   156.221     0.150
    11.932   168.121     0.150
    13.357   190.422     0.150
    13.671   193.910     0.150
    13.973   199.721     0.150
    15.251   219.490     0.150
    15.251   214.721     0.150
    18.358   253.521     0.150
    18.527   257.621     0.150
    18.842   259.320     0.150
    18.771   262.721     0.150
    18.771   258.682     0.150
    19.447   267.721     0.150
    19.723   270.121     0.150
    19.848   272.422     0.150
    19.848   271.721     0.150
    20.543   280.221     0.150
    20.543   279.281     0.150
    20.742   280.746     0.150
    20.742   279.422     0.150
    21.423   288.570     0.150
    22.178   299.320     0.150
    22.652   303.422     0.150
    23.108   308.121     0.150
    23.261   306.980     0.150
    23.283   309.021     0.150
    23.283   307.361     0.150
    23.439   309.230     0.150
    23.876   311.422     0.150
    23.965   315.721     0.150
    24.414   318.621     0.150
    24.577   319.980     0.150
    25.077   325.820     0.150
    25.225   327.621     0.150
    25.606   328.922     0.150
    25.642   330.422     0.150
    25.642   330.422     0.150
    25.642   330.320     0.150
    25.642   328.871     0.150
    25.745   330.150     0.150
    25.742   332.422     0.150
    25.760   331.172     0.150
    26.642   337.721     0.150
    27.785   349.422     0.150
    27.748   349.471     0.150
    27.748   348.551     0.150
    27.785   347.867     0.150
    27.778   348.422     0.150
    27.778   349.320     0.150
    28.149   352.121     0.150
    30.911   377.422     0.150
    31.270   375.021     0.150
    31.275   378.312     0.150
    31.275   553.221     0.150
    31.894   386.922     0.150
    31.894   451.121     0.150
    32.814   395.221     0.150
    34.651   408.771     0.150
    34.651   561.025     0.150
    34.651   408.422     0.150
    35.015   411.088     0.150
    35.015   412.021     0.150
    35.067   413.922     0.150
    36.493   426.721     0.150
    36.959   429.047     0.150
    38.286   441.820     0.150
    38.390   441.521     0.150
    39.879   453.320     0.150
    39.879   452.422     0.150
    40.004   455.320     0.150
    40.301   457.121     0.150
    40.556   459.422     0.150
    40.706   460.682     0.150
    41.876   470.021     0.150
    42.928   478.570     0.150
    43.930   487.320     0.150
    43.911   484.002     0.150
    43.922   486.721     0.150
    44.752   492.221     0.150
    44.752   492.490     0.150
    44.943   496.221     0.150
    46.179   506.021     0.150
    48.536   523.422     0.150
    51.014   541.621     0.150
    51.014   541.570     0.150
    51.014   541.922     0.150
    51.203   544.320     0.150
    51.824   551.422     0.150
    52.070   549.922     0.150
    52.336   551.221     0.150
    52.336     6.100     0.150
    52.336   622.521     0.150
    52.336   995.320     0.150
    52.389   551.980     0.150
    53.391   561.570     0.150
    53.950   562.617     0.150
    53.992   564.371     0.150
    54.028   565.066     0.150
    54.028   565.721     0.150
    54.028   563.592     0.150
    55.157   571.621     0.150
    55.157   572.361     0.150
    55.674   575.521     0.150
    55.747   577.621     0.150
    55.807   575.150     0.150
    56.582   581.871     0.150
    56.929   584.422     0.150
    56.929   584.121     0.150
    60.816   612.521     0.150
    60.816   613.160     0.150
    61.171   613.061     0.150
    61.902   617.080     0.150
    61.902   617.721     0.150
    61.902   618.582     0.150
    63.925   631.445     0.150
    64.599   635.320     0.150
    64.599   777.422     0.150
    64.955   639.799     0.150
    65.717   644.871     0.150
    67.362   655.521     0.150
    68.348   661.121     0.150
    68.348  1202.922     0.150
    68.348  1463.221     0.150
    68.348   660.951     0.150
    75.560   703.121     0.150
    76.082   707.621     0.150
    76.405   708.621     0.150
    76.804   710.172     0.150
    76.953   709.721     0.150
    79.073   723.521     0.150
    80.521   731.422     0.150
    80.521   916.121     0.150
    80.914   732.172     0.150
    82.327   742.709     0.150
    83.332   746.432     0.150
    84.014   749.340     0.150
    84.014   751.621     0.150
    85.447   757.225     0.150
    95.113   804.121     0.150
   118.241  1125.512     0.150
   118.242  1125.512     0.150
   146.622  1179.922     0.150
     0.562    10.420     0.150
     0.562    19.330     0.150
     0.734    14.020     0.150
     0.734    25.209     0.150
     1.482    26.539     0.150
     1.506    25.930     0.150
     1.506    47.910     0.150
     1.783    30.840     0.150
     1.783    54.500     0.150
     1.921    32.809     0.150
     1.921    59.219     0.150
     1.958    32.270     0.150
     1.958    60.570     0.150
     2.088    35.109     0.150
     2.225    36.430     0.150
     2.225    67.250     0.150
     2.334    39.529     0.150
     2.334    70.549     0.150
     2.844    52.680     0.150
     2.844    93.219     0.150
     3.130    94.160     0.150
     3.143    51.369     0.150
     3.178    56.580     0.150
     3.178    94.979     0.150
     3.178    51.689     0.150
     3.178    54.010     0.150
     3.178    93.070     0.150
     4.078    62.750     0.150
     8.414   122.520     0.150
    10.788   157.270     0.150
    19.840   272.635     0.150
    23.238   308.789     0.150
    23.417   309.889     0.150
    24.410   318.270     0.150
    25.625   330.490     0.150
    25.625   330.490     0.150
    25.625   328.930     0.150
    25.737   331.135     0.150
    25.736   331.129     0.150
    27.741   349.410     0.150
    31.274   552.549     0.150
    34.650   408.922     0.150
    34.650   561.559     0.150
    40.707   461.328     0.150
    44.752   494.660     0.150
    51.008   541.879     0.150
    51.008   542.609     0.150
    51.008   542.129     0.150
    53.947   562.832     0.150
    55.152   572.312     0.150
    55.152   572.500     0.150
    55.796   577.148     0.150
    56.920   584.420     0.150
    56.920   585.080     0.150
    56.920   584.969     0.150
    60.739   612.148     0.150
    60.739   612.146     0.150
    61.911   617.869     0.150
    63.928   632.109     0.150
    64.943   639.510     0.150
    65.709   643.779     0.150
    84.002   750.109     0.150
    84.002   750.109     0.150
    84.002   749.648     0.150
    85.440   755.914     0.150
   146.622  1180.734     0.150
     0.328     5.934     0.150
     0.328    11.514     0.150
     0.683    12.934     0.150
     0.683    23.014     0.150
     1.079    20.004     0.150
     1.079    38.133     0.150
     1.161    38.264     0.150
     1.655    52.094     0.150
     1.794    30.434     0.150
     2.047    34.723     0.150
     2.336    38.393     0.150
     2.328    36.113     0.150
     2.487    40.133     0.150
     3.114    50.023     0.150
     3.199    50.963     0.150
     3.278    52.963     0.150
     4.180    61.492     0.150
     8.827   127.254     0.150
    11.112   159.684     0.150
    14.071   199.453     0.150
    15.604   219.934     0.150
    18.964   262.793     0.150
    19.681   267.803     0.150
    23.608   311.664     0.150
    23.778   313.664     0.150
    25.810   331.367     0.150
    25.810   330.943     0.150
    26.116   333.453     0.150
    34.265   405.783     0.150
    34.840   410.854     0.150
    34.841   410.854     0.150
    40.531   458.043     0.150
    40.771   459.604     0.150
    50.961   542.123     0.150
    50.961   542.123     0.150
    50.961   542.129     0.150
    50.961   541.873     0.150
    51.151   542.613     0.150
    51.411   543.664     0.150
    52.151   551.273     0.150
    52.537   554.572     0.150
    55.085   571.992     0.150
    55.087   571.652     0.150
    55.848   577.414     0.150
    56.937   585.424     0.150
    56.937   585.004     0.150
    56.937   585.424     0.150
    60.675   610.643     0.150
    60.675   610.641     0.150
   118.418  1127.922     0.150
   118.419  1127.924     0.150
   119.518  1129.527     0.150
   146.783  1182.479     0.150
     0.290     5.512     0.150
     0.290    11.152     0.150
     0.712    13.303     0.150
     0.712    23.062     0.150
     1.070    19.393     0.150
     1.070    38.492     0.150
     1.152    21.043     0.150
     1.152    38.342     0.150
     1.359    24.223     0.150
     1.359    44.762     0.150
     1.833    31.863     0.150
     1.833    55.223     0.150
     2.009    34.742     0.150
     2.340    39.422     0.150
     2.370    39.104     0.150
     2.370    74.682     0.150
     2.470    40.572     0.150
     2.470    72.693     0.150
     3.075    50.213     0.150
     3.163    50.682     0.150
     3.271    56.223     0.150
     3.271    99.023     0.150
     3.313    52.162     0.150
     3.313    54.539     0.150
     3.313    51.992     0.150
     3.313    52.432     0.150
     4.246    66.162     0.150
     4.246   131.312     0.150
     8.810   128.752     0.150
     9.789   142.893     0.150
     9.789   142.303     0.150
     9.787   144.393     0.150
    11.132   164.193     0.150
    11.132   164.412     0.150
    11.196   165.492     0.150
    12.189   171.592     0.150
    13.730   196.592     0.150
    14.057   201.703     0.150
    14.615   210.693     0.150
    15.618   225.938     0.150
    15.814   228.393     0.150
    16.050   232.992     0.150
    16.439   230.992     0.150
    16.439   417.193     0.150
    18.688   260.492     0.150
    18.688   260.303     0.150
    18.863   262.592     0.150
    18.927   264.793     0.150
    18.927   263.363     0.150
    19.705   272.893     0.150
    19.705   272.104     0.150
    20.158   275.117     0.150
    20.158   275.293     0.150
    20.225   281.793     0.150
    20.787   282.393     0.150
    20.938   284.793     0.150
    20.938   283.473     0.150
    21.443   293.992     0.150
    22.309   302.492     0.150
    22.337   301.092     0.150
    22.354   301.893     0.150
    22.405   300.193     0.150
    23.428   312.893     0.150
    23.435   309.682     0.150
    23.512   312.717     0.150
    23.582   311.762     0.150
    23.751   313.572     0.150
    24.249   318.693     0.150
    24.935   324.053     0.150
    25.235   328.693     0.150
    25.235   366.193     0.150
    25.235   592.693     0.150
    25.342   330.393     0.150
    25.576   331.393     0.150
    25.773   332.164     0.150
    25.773   331.893     0.150
    26.093   334.492     0.150
    26.092   334.492     0.150
    26.964   343.992     0.150
    27.451   347.012     0.150
    27.630   348.693     0.150
    28.037   349.943     0.150
    28.079   352.893     0.150
    28.079   637.992     0.150
    29.267   359.893     0.150
    29.267   359.881     0.150
    30.447   370.943     0.150
    31.473   380.492     0.150
    31.473   381.332     0.150
    31.478   380.467     0.150
    31.482   380.842     0.150
    31.775   386.793     0.150
    32.603   394.193     0.150
    34.226   405.893     0.150
    34.667   407.383     0.150
    34.667   407.623     0.150
    34.871   410.473     0.150
    34.872   410.643     0.150
    34.872   410.752     0.150
    36.376   426.693     0.150
    37.049   429.943     0.150
    37.049   431.193     0.150
    38.350   442.492     0.150
    38.460   443.092     0.150
    39.540   450.617     0.150
    39.727   453.793     0.150
    40.068   456.393     0.150
    40.324   457.193     0.150
    40.357   458.293     0.150
    40.370   458.393     0.150
    40.498   460.867     0.150
    40.498   458.793     0.150
    40.533   459.693     0.150
    40.625   460.693     0.150
    40.797   459.902     0.150
    41.140   464.992     0.150
    41.948   471.592     0.150
    41.983   471.693     0.150
    44.140   488.082     0.150
    44.733   496.092     0.150
    44.940   495.943     0.150
    46.091   506.693     0.150
    50.923   542.592     0.150
    50.923   542.367     0.150
    50.923   542.172     0.150
    51.809   551.393     0.150
    51.809   991.293     0.150
    52.015   549.092     0.150
    53.801   562.383     0.150
    53.801   562.262     0.150
    53.991   564.738     0.150
    53.991   565.492     0.150
    53.991   563.232     0.150
    54.579   568.723     0.150
    55.048   572.393     0.150
    55.048   572.082     0.150
    55.050   572.268     0.150
    55.715   576.393     0.150
    55.740   576.492     0.150
    55.809   577.822     0.150
    56.898   584.793     0.150
    56.898   584.893     0.150
    56.898   585.082     0.150
    60.638   611.330     0.150
    60.710   611.092     0.150
    60.710   611.863     0.150
    63.691   631.393     0.150
    64.981   642.215     0.150
    65.655   644.092     0.150
    67.132   654.018     0.150
    67.244   654.793     0.150
    68.236   659.492     0.150
    68.236   683.092     0.150
    68.236  1199.793     0.150
    68.236  1462.592     0.150
    68.236   659.803     0.150
    75.692   705.992     0.150
    75.733   703.793     0.150
    76.792   712.717     0.150
    76.939   711.393     0.150
    77.472   715.393     0.150
    79.167   724.492     0.150
    80.523   731.584     0.150
    84.026   750.117     0.150
    85.058   754.893     0.150
    85.058   754.875     0.150
    85.058   756.893     0.150
    85.380   757.367     0.150
    87.129   767.117     0.150
    87.129   767.592     0.150
    87.129   767.342     0.150
    95.544   806.398     0.150
   118.380  1127.992     0.150
   118.381  1127.992     0.150
   146.816  1182.367     0.150
     0.587    11.541     0.150
     0.587    19.689     0.150
     0.651    12.740     0.150
     0.651    22.160     0.150
     1.847    31.010     0.150
     1.847    52.541     0.150
     2.025    33.699     0.150
     2.585    52.199     0.150
     2.585    73.869     0.150
     3.246    52.754     0.150
     3.246    85.143     0.150
     3.246    51.359     0.150
     8.318   118.600     0.150
     9.644   138.420     0.150
    10.786   153.939     0.150
    14.466   203.680     0.150
    15.195   215.199     0.150
    18.347   253.580     0.150
    23.309   307.041     0.150
    25.520   327.869     0.150
    27.756   344.854     0.150
    27.756   347.520     0.150
    29.706   366.461     0.150
    31.319   552.926     0.150
    31.323   379.160     0.150
    34.689   407.617     0.150
    34.689   562.037     0.150
    43.928   484.430     0.150
    44.801   493.561     0.150
    50.937   541.404     0.150
    50.937   539.891     0.150
    51.962   548.480     0.150
    53.889   562.650     0.150
    55.085   571.854     0.150
    55.084   570.980     0.150
    56.837   583.461     0.150
    56.837   584.291     0.150
    60.671   611.328     0.150
    64.850   637.117     0.150
    80.971   733.527     0.150
    83.911   749.637     0.150
   118.117  1126.359     0.150
   146.667  1181.443     0.150
     0.538    10.367     0.150
     0.721    13.748     0.150
     0.721    24.639     0.150
     3.231    47.027     0.150
     8.392   124.268     0.150
    10.819   155.318     0.150
    25.572   330.936     0.150
    25.572   330.418     0.150
    27.779   350.012     0.150
    27.779   348.328     0.150
    31.322   378.533     0.150
    31.322   378.527     0.150
    34.696   408.234     0.150
    34.696   561.734     0.150
    34.696   408.479     0.150
    34.999   409.838     0.150
    36.356   425.768     0.150
    39.487   448.717     0.150
    40.551   459.428     0.150
    43.954   485.707     0.150
    50.955   541.338     0.150
    50.955   541.828     0.150
    50.955   541.277     0.150
    53.896   563.217     0.150
    53.896   562.447     0.150
    55.099   571.908     0.150
    56.865   585.098     0.150
    56.865   584.947     0.150
    65.654   643.139     0.150
   146.670  1182.111     0.150
     0.460     8.855     0.150
     0.460    15.365     0.150
     0.913    19.445     0.150
     1.616    27.916     0.150
     1.616    49.025     0.150
     2.098    35.984     0.150
     3.025    50.605     0.150
     3.176    49.686     0.150
     4.870    76.916     0.150
     8.594   122.246     0.150
     9.624   136.475     0.150
    23.585   310.955     0.150
    25.734   332.135     0.150
    25.734   330.205     0.150
    27.688   347.285     0.150
    31.310   378.785     0.150
    31.310   378.785     0.150
    31.314   378.555     0.150
    34.229   405.984     0.150
    34.693   408.375     0.150
    34.694   409.135     0.150
    34.694   561.734     0.150
    34.694   408.385     0.150
    34.910   412.248     0.150
    43.957   485.836     0.150
    44.780   493.510     0.150
    44.780   492.035     0.150
    51.026   541.814     0.150
    51.026   542.535     0.150
    51.026   541.525     0.150
    52.132   550.506     0.150
    55.162   571.926     0.150
    55.162   572.160     0.150
    55.735   576.686     0.150
    55.791   576.965     0.150
    55.855   577.055     0.150
    56.964   584.855     0.150
    56.964   585.605     0.150
    60.750   611.176     0.150
    60.750   611.174     0.150
    60.822   611.865     0.150
    61.236   615.324     0.150
    63.614   630.660     0.150
    63.876   631.461     0.150
    65.011   639.412     0.150
    65.011   639.246     0.150
    65.740   644.234     0.150
    75.653   705.025     0.150
    79.023   723.965     0.150
    83.198   745.555     0.150
    85.485   756.211     0.150
    85.468   757.127     0.150
   118.337  1126.918     0.150
   118.338  1126.916     0.150
   119.771  1130.746     0.150
   119.771  1130.748     0.150
   146.653  1180.961     0.150
     0.362     6.570     0.150
     0.698    12.971     0.150
     1.125    21.080     0.150
     1.665    29.021     0.150
     2.077    36.000     0.150
     2.296    37.250     0.150
     2.281    38.621     0.150
     2.534    42.531     0.150
     2.709    45.361     0.150
     3.239   104.385     0.150
     3.239    53.891     0.150
     3.239    92.230     0.150
     4.817    77.250     0.150
    23.763   314.660     0.150
    25.820   333.740     0.150
    31.404   378.541     0.150
    31.408   381.570     0.150
    34.282   406.691     0.150
    34.798   408.990     0.150
    36.510   426.451     0.150
    44.866   494.666     0.150
    50.994   541.961     0.150
    50.994   541.965     0.150
    52.029   549.461     0.150
    52.171   551.240     0.150
    55.120   572.061     0.150
    55.873   578.211     0.150
    56.965   585.340     0.150
    60.782   611.000     0.150
    68.308   661.811     0.150
    73.571   694.291     0.150
     0.469     8.107     0.150
     0.469    16.498     0.150
     1.072    20.957     0.150
     2.172    38.627     0.150
     3.004    47.918     0.150
     3.004    97.799     0.150
     3.087    53.277     0.150
     3.129    52.232     0.150
     3.129    98.707     0.150
     3.129    49.334     0.150
     3.129    48.598     0.150
     3.598   107.979     0.150
     4.332    66.408     0.150
     4.923    74.918     0.150
     5.247    82.062     0.150
     6.310    95.338     0.150
     8.418   125.537     0.150
     8.758   128.309     0.150
     8.758   228.059     0.150
     9.257   138.438     0.150
     9.216   136.838     0.150
     9.600   137.438     0.150
     9.612   142.238     0.150
    10.496   150.066     0.150
    10.972   155.938     0.150
    10.950   161.139     0.150
    11.021   162.838     0.150
    11.999   168.338     0.150
    12.811   181.938     0.150
    13.195   188.088     0.150
    13.365   190.537     0.150
    13.563   196.537     0.150
    13.704   195.078     0.150
    13.758   196.338     0.150
    13.977   200.838     0.150
    14.071   198.838     0.150
    13.988   201.838     0.150
    13.988   199.908     0.150
    14.157   201.969     0.150
    14.415   205.357     0.150
    14.446   209.037     0.150
    14.764   212.738     0.150
    15.055   213.537     0.150
    15.055   211.398     0.150
    14.937   211.889     0.150
    15.415   218.139     0.150
    15.360   219.738     0.150
    15.448   222.107     0.150
    15.448   218.338     0.150
    15.504   219.559     0.150
    15.642   222.139     0.150
    15.537   220.428     0.150
    15.627   221.229     0.150
    15.964   228.139     0.150
    16.198   226.537     0.150
    16.122   230.838     0.150
    16.122   227.088     0.150
    16.573   234.438     0.150
    17.291   245.139     0.150
    17.291   242.438     0.150
    17.653   251.037     0.150
    18.505   258.838     0.150
    18.505   255.508     0.150
    18.682   260.738     0.150
    19.122   262.268     0.150
    19.017   264.838     0.150
    19.017   262.889     0.150
    19.517   270.738     0.150
    19.517   267.598     0.150
    19.655   272.537     0.150
    19.879   273.938     0.150
    19.972   273.639     0.150
    19.962   275.238     0.150
    20.189   276.938     0.150
    20.567   277.488     0.150
    20.567   280.037     0.150
    20.591   281.658     0.150
    20.328   281.738     0.150
    20.644   286.037     0.150
    20.702   282.438     0.150
    20.790   286.639     0.150
    20.790   280.299     0.150
    21.281   287.639     0.150
    21.281   286.168     0.150
    21.586   291.838     0.150
    21.641   294.639     0.150
    21.686   290.537     0.150
    21.924   293.469     0.150
    21.744   293.838     0.150
    21.744   292.178     0.150
    21.944   296.639     0.150
    22.306   297.498     0.150
    22.340   299.838     0.150
    22.426   299.338     0.150
    22.495   301.238     0.150
    22.495   544.639     0.150
    22.595   301.438     0.150
    22.595   332.838     0.150
    22.595   547.438     0.150
    22.560   300.008     0.150
    22.874   306.338     0.150
    23.142   311.639     0.150
    23.142   306.488     0.150
    23.364   310.238     0.150
    23.364   341.938     0.150
    23.364   561.139     0.150
    23.364   566.438     0.150
    23.364   607.838     0.150
    23.404   310.963     0.150
    23.620   310.434     0.150
    23.620   309.648     0.150
    23.527   311.338     0.150
    23.527   310.049     0.150
    23.577   311.838     0.150
    23.577   310.947     0.150
    23.898   312.908     0.150
    23.753   313.838     0.150
    23.753   312.127     0.150
    23.931   311.889     0.150
    23.931   313.658     0.150
    24.122   313.889     0.150
    24.187   318.139     0.150
    24.240   318.938     0.150
    24.273   319.537     0.150
    24.378   320.338     0.150
    24.470   319.697     0.150
    24.675   323.639     0.150
    24.757   322.838     0.150
    24.898   325.639     0.150
    24.898   323.338     0.150
    24.882   326.037     0.150
    25.050   325.639     0.150
    25.263   328.238     0.150
    25.299   327.838     0.150
    25.380   329.838     0.150
    25.380   595.438     0.150
    25.380   654.639     0.150
    25.395   332.438     0.150
    25.429   329.738     0.150
    25.806   330.910     0.150
    25.806   330.268     0.150
    25.962   331.488     0.150
    25.874   333.312     0.150
    25.874   332.889     0.150
    25.874   542.488     0.150
    25.967   334.338     0.150
    25.971   334.145     0.150
    25.971   332.938     0.150
    26.078   334.139     0.150
    26.078   333.537     0.150
    26.078   333.549     0.150
    26.526   339.838     0.150
    26.729   342.338     0.150
    26.972   342.139     0.150
    26.972   621.338     0.150
    26.958   342.938     0.150
    27.634   347.639     0.150
    27.848   348.312     0.150
    27.918   349.768     0.150
    27.812   348.738     0.150
    27.812   633.639     0.150
    27.812   348.938     0.150
    28.245   353.639     0.150
    28.245   639.838     0.150
    29.425   362.838     0.150
    29.425   362.607     0.150
    29.425   361.650     0.150
    29.848   366.838     0.150
    30.279   369.684     0.150
    30.279   369.338     0.150
    30.836   376.037     0.150
    30.856   376.938     0.150
    30.856   679.139     0.150
    31.285   376.338     0.150
    31.285   378.178     0.150
    31.290   377.889     0.150
    31.554   380.729     0.150
    31.814   384.838     0.150
    31.814   698.338     0.150
    31.952   387.438     0.150
    31.952   454.738     0.150
    31.952   700.238     0.150
    32.792   396.438     0.150
    33.132   396.838     0.150
    33.062   399.639     0.150
    33.852   401.457     0.150
    33.781   403.139     0.150
    33.801   402.639     0.150
    33.801   725.838     0.150
    34.220   404.934     0.150
    34.352   408.197     0.150
    34.352   407.338     0.150
    34.352   407.037     0.150
    34.682   408.537     0.150
    34.682  2405.139     0.150
    34.847   410.895     0.150
    34.947   411.059     0.150
    34.913   412.639     0.150
    34.913  1029.139     0.150
    34.913   412.107     0.150
    36.620   425.639     0.150
    36.553   426.938     0.150
    36.553   770.338     0.150
    36.553   783.338     0.150
    36.708   426.408     0.150
    36.589   427.715     0.150
    36.589   428.492     0.150
    36.589   427.338     0.150
    36.878   427.889     0.150
    36.878   426.938     0.150
    37.655   434.562     0.150
    38.477   443.139     0.150
    38.585   443.938     0.150
    39.282   450.037     0.150
    39.424   450.037     0.150
    39.518   450.207     0.150
    39.518   449.678     0.150
    39.721   452.312     0.150
    39.721   453.338     0.150
    39.854   454.838     0.150
    40.171   455.338     0.150
    40.195   457.537     0.150
    40.607   459.059     0.150
    40.607   458.658     0.150
    40.513   461.676     0.150
    40.513   459.238     0.150
    40.483   459.238     0.150
    40.495   459.139     0.150
    40.687   461.498     0.150
    40.660   460.838     0.150
    40.750   461.537     0.150
    41.080   463.434     0.150
    41.161   463.357     0.150
    41.267   465.338     0.150
    41.701   469.607     0.150
    41.989   470.838     0.150
    42.072   472.537     0.150
    42.109   472.639     0.150
    43.088   481.566     0.150
    43.088   479.514     0.150
    43.088   479.037     0.150
    43.040   480.279     0.150
    43.337   481.943     0.150
    43.766   484.607     0.150
    43.766   484.078     0.150
    43.797   486.537     0.150
    43.950   486.434     0.150
    43.950   485.527     0.150
    43.908   486.438     0.150
    43.908   592.037     0.150
    44.753   492.963     0.150
    44.922   496.676     0.150
    44.922   495.938     0.150
    44.922   894.838     0.150
    44.922   495.418     0.150
    44.868   494.838     0.150
    45.311   498.434     0.150
    45.761   502.738     0.150
    46.063   504.008     0.150
    46.261   507.838     0.150
    46.261   603.139     0.150
    46.261   615.139     0.150
    46.261   913.738     0.150
    46.261   923.639     0.150
    46.261   506.139     0.150
    47.986   519.309     0.150
    47.986   518.377     0.150
    48.456   523.838     0.150
    49.294   528.982     0.150
    50.723   539.238     0.150
    50.849   541.312     0.150
    51.197   543.238     0.150
    51.197   543.127     0.150
    51.264   544.732     0.150
    51.264   543.238     0.150
    51.094   543.037     0.150
    51.094   543.213     0.150
    51.105   543.438     0.150
    51.284   544.537     0.150
    51.447   546.238     0.150
    51.531   547.059     0.150
    51.962   552.438     0.150
    51.962   993.838     0.150
    52.225   550.438     0.150
    52.225   550.238     0.150
    52.200   551.537     0.150
    52.200     7.400     0.150
    52.200   622.238     0.150
    52.200   551.197     0.150
    52.120   551.238     0.150
    52.247   553.127     0.150
    52.247   551.738     0.150
    52.655   554.838     0.150
    53.107   558.938     0.150
    53.465   557.639     0.150
    53.465   560.598     0.150
    53.510   560.938     0.150
    53.983   563.412     0.150
    54.112   567.348     0.150
    54.150   567.756     0.150
    54.150   568.508     0.150
    54.150   567.938     0.150
    54.150   568.738     0.150
    54.150   566.848     0.150
    54.650   570.139     0.150
    55.223   573.258     0.150
    55.223   572.938     0.150
    55.223   572.748     0.150
    55.890   578.438     0.150
    55.957   578.688     0.150
    57.055   586.037     0.150
    57.055   585.838     0.150
    57.729   592.037     0.150
    60.885   612.857     0.150
    60.885   612.139     0.150
    60.885   612.648     0.150
    61.775   616.447     0.150
    61.775   617.738     0.150
    63.033   628.371     0.150
    63.755   631.416     0.150
    63.881   632.264     0.150
    64.402   635.438     0.150
    64.402   668.238     0.150
    64.402   635.707     0.150
    64.219   634.412     0.150
    64.999   638.559     0.150
    64.968   639.619     0.150
    65.076   640.043     0.150
    65.122   641.764     0.150
    65.694   644.604     0.150
    65.820   644.738     0.150
    65.820   645.607     0.150
    65.894   646.305     0.150
    65.894   647.018     0.150
    65.976   646.518     0.150
    66.017   648.127     0.150
    66.038   648.139     0.150
    66.042   647.037     0.150
    66.042   646.768     0.150
    66.109   646.904     0.150
    66.109   647.205     0.150
    66.393   649.084     0.150
    66.467   651.443     0.150
    66.468   649.236     0.150
    66.468   649.502     0.150
    66.710   651.461     0.150
    66.710   652.182     0.150
    66.773   652.107     0.150
    67.311   653.348     0.150
    67.299   654.488     0.150
    67.372   655.314     0.150
    67.421   656.639     0.150
    68.180   659.857     0.150
    68.093   660.207     0.150
    68.347   661.428     0.150
    68.411   661.338     0.150
    68.411   808.438     0.150
    68.411  1202.438     0.150
    68.500   662.832     0.150
    68.968   665.271     0.150
    73.676   694.537     0.150
    74.836   700.938     0.150
    74.836   714.838     0.150
    74.836   867.438     0.150
    75.633   707.838     0.150
    75.793   706.281     0.150
    75.793   705.537     0.150
    76.227   705.838     0.150
    76.688   710.598     0.150
    76.556   713.109     0.150
    76.816   713.139     0.150
    76.944   713.537     0.150
    77.091   716.207     0.150
    77.091   715.207     0.150
    77.091   713.438     0.150
    77.091   715.807     0.150
    77.091   714.258     0.150
    77.118   715.838     0.150
    78.100   719.338     0.150
    78.100   718.268     0.150
    79.256   724.738     0.150
    79.256   734.639     0.150
    79.256   903.537     0.150
    79.256  1319.037     0.150
    79.962   729.838     0.150
    79.962   736.838     0.150
    80.677   731.338     0.150
    80.599   732.613     0.150
    80.599   733.238     0.150
    80.599   917.338     0.150
    80.599   732.799     0.150
    80.730   733.938     0.150
    80.808   733.537     0.150
    81.239   735.248     0.150
    82.231   740.938     0.150
    83.474   749.639     0.150
    83.827   748.088     0.150
    83.931   750.408     0.150
    84.105   751.758     0.150
    84.171   752.646     0.150
    84.171   751.988     0.150
    84.795   756.809     0.150
    84.795   754.938     0.150
    85.238   756.367     0.150
    85.239   755.688     0.150
    85.239   756.738     0.150
    85.392   756.338     0.150
    85.476   757.617     0.150
    85.518   758.938     0.150
    85.546   756.713     0.150
    85.546   758.139     0.150
    85.690   760.838     0.150
    86.574   764.262     0.150
    86.874   765.139     0.150
    86.874   766.168     0.150
    87.157   767.188     0.150
    87.157   767.541     0.150
    87.157   768.207     0.150
    87.157   766.738     0.150
    87.231   768.010     0.150
    87.263   767.656     0.150
    87.286   768.127     0.150
    87.467   768.877     0.150
    87.524   769.033     0.150
    88.116   772.656     0.150
    88.172   772.191     0.150
    88.308   774.428     0.150
    88.459   772.139     0.150
    88.459   772.578     0.150
    88.643   771.676     0.150
    88.643   771.400     0.150
    88.733   775.391     0.150
    88.746   774.896     0.150
    89.413   778.197     0.150
    89.416  1422.338     0.150
    89.698   778.938     0.150
    90.565  1432.438     0.150
    90.393   783.537     0.150
    90.604   783.385     0.150
    90.922   785.320     0.150
    91.336   787.053     0.150
    91.510   786.537     0.150
    92.176   789.238     0.150
    93.031   795.076     0.150
    93.250   799.238     0.150
    93.353   799.844     0.150
    93.976   799.639     0.150
    94.698   802.795     0.150
    94.698  1032.615     0.150
    94.934   801.809     0.150
    94.809   802.627     0.150
    94.809  1474.838     0.150
    94.809  1856.838     0.150
    95.148   804.326     0.150
    95.193   800.838     0.150
    95.193  1470.838     0.150
    95.193  1033.838     0.150
    95.663   807.131     0.150
    95.680   805.338     0.150
    95.680   805.777     0.150
    95.712   806.812     0.150
    95.730   807.574     0.150
    96.035   807.400     0.150
    96.035  1041.619     0.150
    96.596  1042.031     0.150
    97.219   811.838     0.150
    97.219   815.139     0.150
    97.249  1047.650     0.150
    97.884  1054.959     0.150
    98.054   817.961     0.150
    98.054  1056.762     0.150
    98.264   818.355     0.150
    98.264  1057.164     0.150
    98.683   821.783     0.150
    98.683  1060.932     0.150
   100.521   828.068     0.150
   103.732   844.812     0.150
   103.732  1102.113     0.150
   104.596   845.238     0.150
   104.596  1102.537     0.150
   104.596  1792.064     0.150
   108.288  1127.088     0.150
   108.288  1793.338     0.150
   118.479  1127.447     0.150
   118.479  1127.488     0.150
   118.479  1127.377     0.150
   119.624  1128.219     0.150
   119.625  1129.988     0.150
   119.625  1210.234     0.150
   119.625  1128.438     0.150
   121.738  1133.938     0.150
   125.190  1140.037     0.150
   125.937  1141.367     0.150
   126.612  1145.037     0.150
   126.629  1143.889     0.150
   126.792  1145.238     0.150
   126.924  1145.639     0.150
   146.629  1181.389     0.150
   146.629  1181.238     0.150
   147.305  1183.238     0.150
   147.511  1185.158     0.150
   149.511  1188.969     0.150
   149.511  1188.238     0.150
   150.579  1197.447     0.150
   151.416  1193.877     0.150
   152.482  1189.979     0.150
   153.199  1197.678     0.150
   153.634  1199.367     0.150
   153.689  1193.277     0.150
   154.026  1194.457     0.150
   154.359  1191.627     0.150
   154.946  1201.799     0.150
   155.286  1193.828     0.150
   155.347  1194.377     0.150
   155.596  1220.768     0.150
   156.454  1195.213     0.150
   156.454  1196.258     0.150
   157.060  1197.107     0.150
   163.587  1203.812     0.150
   163.587  1254.238     0.150
   166.438  1206.863     0.150
   166.438  1268.338     0.150
   166.438  1206.139     0.150
   170.476  1207.207     0.150
   170.476  1284.527     0.150
   172.071  1292.678     0.150
   172.683  1209.238     0.150
     0.589    10.824     0.150
     0.589    19.854     0.150
     0.638    12.184     0.150
     0.638    22.154     0.150
     1.187    22.074     0.150
     1.187    38.854     0.150
     1.383    23.523     0.150
     1.383    43.184     0.150
     1.541    26.484     0.150
     1.541    47.875     0.150
     1.858    30.895     0.150
     1.858    55.613     0.150
     1.949    32.404     0.150
     2.055    34.693     0.150
     2.003    33.424     0.150
     2.278    37.434     0.150
     2.318    37.555     0.150
     2.318    69.033     0.150
     2.482    40.604     0.150
     2.869    44.943     0.150
     2.851    44.854     0.150
     2.851    79.334     0.150
     3.077    48.715     0.150
     3.051    47.443     0.150
     3.220    56.344     0.150
     3.270    52.814     0.150
     3.270    50.885     0.150
     3.260    52.064     0.150
     3.260    93.414     0.150
     3.661    57.783     0.150
     3.679    57.014     0.150
     3.783    58.994     0.150
     3.815    58.135     0.150
     4.084    62.705     0.150
     4.091    61.955     0.150
     4.279    65.004     0.150
     4.797    73.955     0.150
     5.077    77.818     0.150
     7.013   106.465     0.150
     7.350   108.715     0.150
     7.527   113.754     0.150
     8.298   118.734     0.150
     8.298   212.244     0.150
     9.152   134.844     0.150
     9.410   136.545     0.150
     9.664   138.744     0.150
     9.664   138.215     0.150
    10.793   153.854     0.150
    10.819   157.244     0.150
    11.019   159.744     0.150
    11.972   169.045     0.150
    12.897   183.545     0.150
    12.897   181.004     0.150
    12.985   182.443     0.150
    13.208   185.484     0.150
    13.318   190.844     0.150
    13.370   188.045     0.150
    13.541   194.244     0.150
    13.541   191.004     0.150
    13.728   193.064     0.150
    13.761   194.434     0.150
    14.108   199.045     0.150
    14.209   202.443     0.150
    14.173   199.654     0.150
    14.453   202.844     0.150
    14.539   207.645     0.150
    15.010   219.244     0.150
    14.971   209.344     0.150
    15.102   211.744     0.150
    15.219   215.744     0.150
    15.219   213.635     0.150
    15.211   216.645     0.150
    15.218   216.088     0.150
    15.218   213.545     0.150
    15.424   219.244     0.150
    15.494   220.045     0.150
    15.445   215.783     0.150
    15.455   216.295     0.150
    15.534   221.244     0.150
    15.673   220.084     0.150
    15.664   218.244     0.150
    15.843   222.645     0.150
    15.843   407.045     0.150
    16.262   229.344     0.150
    16.262   407.045     0.150
    16.262   228.135     0.150
    16.471   232.545     0.150
    16.533   235.545     0.150
    17.023   242.145     0.150
    17.253   242.244     0.150
    17.500   246.244     0.150
    17.500   242.693     0.150
    18.355   254.744     0.150
    18.355   253.184     0.150
    18.519   256.344     0.150
    18.617   259.645     0.150
    18.617   255.795     0.150
    19.200   261.844     0.150
    19.200   262.135     0.150
    19.417   266.443     0.150
    19.417   265.885     0.150
    19.407   266.545     0.150
    19.613   267.645     0.150
    19.662   268.844     0.150
    19.858   271.594     0.150
    19.858   270.244     0.150
    19.949   275.844     0.150
    20.005   273.645     0.150
    20.195   276.943     0.150
    20.270   276.045     0.150
    20.349   276.844     0.150
    20.493   278.943     0.150
    20.477   277.844     0.150
    20.477   276.754     0.150
    20.644   281.045     0.150
    20.878   281.693     0.150
    20.878   281.844     0.150
    20.953   285.244     0.150
    21.012   285.045     0.150
    21.062   283.414     0.150
    21.062   282.645     0.150
    21.143   285.645     0.150
    21.292   287.045     0.150
    21.277   289.244     0.150
    21.312   288.844     0.150
    21.312   285.783     0.150
    21.336   287.844     0.150
    21.336   285.084     0.150
    21.786   292.744     0.150
    21.941   294.344     0.150
    22.002   296.244     0.150
    22.023   294.645     0.150
    22.392   297.014     0.150
    22.422   299.244     0.150
    22.488   301.045     0.150
    22.608   302.943     0.150
    22.611   300.545     0.150
    22.698   303.844     0.150
    22.698   301.465     0.150
    22.975   306.744     0.150
    23.003   306.219     0.150
    22.980   305.744     0.150
    23.106   305.014     0.150
    23.140   307.045     0.150
    23.129   306.244     0.150
    23.129   304.914     0.150
    23.134   306.744     0.150
    23.240   310.145     0.150
    23.283   307.174     0.150
    23.392   308.744     0.150
    23.584   312.145     0.150
    23.657   309.264     0.150
    23.657   309.004     0.150
    23.767   312.943     0.150
    23.810   313.145     0.150
    23.806   313.244     0.150
    23.875   314.844     0.150
    23.961   311.840     0.150
    24.004   314.844     0.150
    24.150   534.719     0.150
    24.231   317.244     0.150
    24.322   316.014     0.150
    24.345   318.244     0.150
    24.431   318.943     0.150
    24.431   318.324     0.150
    24.483   318.844     0.150
    24.512   316.469     0.150
    24.584   319.244     0.150
    24.602   319.844     0.150
    24.592   320.443     0.150
    24.882   323.443     0.150
    24.944   323.443     0.150
    24.928   323.045     0.150
    24.997   322.443     0.150
    24.997   322.145     0.150
    25.022   325.443     0.150
    25.099   325.545     0.150
    25.096   325.145     0.150
    25.096   584.045     0.150
    25.096   324.244     0.150
    25.139   325.545     0.150
    25.464   327.145     0.150
    25.490   329.037     0.150
    25.490   328.295     0.150
    25.490   539.795     0.150
    25.607   329.494     0.150
    25.607   538.369     0.150
    25.587   329.145     0.150
    25.591   329.012     0.150
    25.591   328.244     0.150
    25.786   328.939     0.150
    25.786   329.055     0.150
    26.329   334.225     0.150
    26.340   337.344     0.150
    26.488   336.244     0.150
    26.693   338.443     0.150
    26.682   340.045     0.150
    26.881   339.344     0.150
    26.905   342.045     0.150
    26.905   339.014     0.150
    26.978   339.564     0.150
    26.981   340.244     0.150
    27.125   342.943     0.150
    27.635   346.744     0.150
    27.768   346.807     0.150
    27.768   346.443     0.150
    27.768   346.545     0.150
    27.695   346.943     0.150
    27.795   347.645     0.150
    27.795   347.379     0.150
    27.795   543.795     0.150
    28.041   350.244     0.150
    28.041   635.645     0.150
    28.174   353.244     0.150
    28.197   349.783     0.150
    29.708   362.943     0.150
    29.708   362.834     0.150
    29.708   548.613     0.150
    29.708   362.943     0.150
    29.708   661.443     0.150
    29.708   362.719     0.150
    29.708   549.145     0.150
    29.708  2410.209     0.150
    29.708   363.645     0.150
    30.137   367.139     0.150
    30.137   367.545     0.150
    30.486   370.939     0.150
    30.486   370.725     0.150
    30.473   370.725     0.150
    30.849   375.145     0.150
    30.869   375.645     0.150
    30.869   680.045     0.150
    30.995   374.756     0.150
    30.995   375.045     0.150
    31.333   378.145     0.150
    31.333   377.564     0.150
    31.333   552.414     0.150
    31.338   377.344     0.150
    31.338   551.844     0.150
    31.342   377.514     0.150
    31.389   378.234     0.150
    31.496   379.895     0.150
    31.802   385.545     0.150
    32.757   394.045     0.150
    33.316   397.244     0.150
    33.535   398.715     0.150
    33.964   401.139     0.150
    33.924   401.344     0.150
    33.971   402.943     0.150
    34.017   403.135     0.150
    34.017   402.244     0.150
    34.357   405.105     0.150
    34.402   405.840     0.150
    34.706   407.795     0.150
    34.706   561.145     0.150
    34.706   785.744     0.150
    34.896   409.590     0.150
    35.033   412.494     0.150
    35.033   562.465     0.150
    35.077   412.045     0.150
    35.077   788.045     0.150
    35.077   411.834     0.150
    36.291   424.504     0.150
    36.291   422.244     0.150
    36.374   422.545     0.150
    36.400   424.844     0.150
    36.538   422.840     0.150
    36.844   426.645     0.150
    36.844   568.344     0.150
    37.063   428.943     0.150
    37.063   428.545     0.150
    37.927   436.270     0.150
    37.927   572.318     0.150
    38.146   439.645     0.150
    38.248   440.344     0.150
    38.944   446.443     0.150
    39.325   446.639     0.150
    39.497   449.645     0.150
    39.521   451.443     0.150
    39.863   454.145     0.150
    39.892   452.795     0.150
    39.892   577.594     0.150
    39.892   452.244     0.150
    40.147   455.844     0.150
    40.159   455.744     0.150
    40.325   457.244     0.150
    40.429   457.045     0.150
    40.429   579.545     0.150
    40.429   456.715     0.150
    40.414   458.045     0.150
    40.544   457.090     0.150
    40.544   456.885     0.150
    40.478   458.715     0.150
    40.478   457.645     0.150
    40.647   459.725     0.150
    40.647   579.764     0.150
    40.647   458.145     0.150
    40.647   579.943     0.150
    40.810   459.744     0.150
    40.951   460.014     0.150
    40.932   461.943     0.150
    40.982   462.244     0.150
    41.282   463.238     0.150
    41.531   464.814     0.150
    41.734   469.045     0.150
    41.776   469.344     0.150
    42.139   471.289     0.150
    42.188   471.244     0.150
    42.582   476.531     0.150
    42.582   476.396     0.150
    42.582   474.943     0.150
    42.916   476.520     0.150
    42.916   475.982     0.150
    42.924   478.145     0.150
    43.498   481.789     0.150
    43.832   489.443     0.150
    43.861   484.844     0.150
    43.861   590.545     0.150
    43.952   484.965     0.150
    43.952   484.805     0.150
    43.962   485.139     0.150
    43.928   485.045     0.150
    44.356   490.434     0.150
    44.452   490.244     0.150
    44.821   492.344     0.150
    44.884   493.639     0.150
    44.884   494.014     0.150
    44.884   493.844     0.150
    44.884   493.125     0.150
    45.199   603.943     0.150
    45.348   496.764     0.150
    45.367   497.244     0.150
    45.707   500.443     0.150
    46.168   503.738     0.150
    46.076   505.045     0.150
    46.076   599.045     0.150
    46.076   503.545     0.150
    48.142   519.539     0.150
    48.142   518.645     0.150
    48.506   522.145     0.150
    49.342   527.564     0.150
    49.637   530.283     0.150
    49.705   531.314     0.150
    49.833   532.443     0.150
    49.833   962.574     0.150
    50.005   532.795     0.150
    50.053   533.064     0.150
    50.831   539.545     0.150
    50.885   540.344     0.150
    50.912   540.645     0.150
    50.912   539.965     0.150
    50.912   615.395     0.150
    50.912   540.969     0.150
    50.912   615.395     0.150
    50.912  2378.670     0.150
    50.912   539.684     0.150
    51.101   541.443     0.150
    51.103   542.514     0.150
    51.103   981.764     0.150
    51.144   541.969     0.150
    51.144   616.568     0.150
    51.147   616.574     0.150
    51.336   543.840     0.150
    51.336   543.045     0.150
    51.496   544.045     0.150
    51.496   544.193     0.150
    51.466   545.443     0.150
    51.466   985.104     0.150
    51.467   983.895     0.150
    51.496   544.814     0.150
    51.700   548.744     0.150
    51.700   987.145     0.150
    51.934   548.758     0.150
    51.934   548.145     0.150
    52.335   549.545     0.150
    52.335    11.500     0.150
    52.335   991.943     0.150
    52.335   549.955     0.150
    52.335   620.773     0.150
    52.351   551.475     0.150
    52.407   552.504     0.150
    52.407   998.904     0.150
    52.522   552.904     0.150
    52.522   623.084     0.150
    52.522   552.045     0.150
    52.520   551.844     0.150
    52.520   552.443     0.150
    52.567   553.715     0.150
    52.742   553.943     0.150
    53.178   559.094     0.150
    53.184   557.705     0.150
    53.184  1006.943     0.150
    53.275   558.344     0.150
    53.275   558.715     0.150
    53.466   558.744     0.150
    53.595   559.844     0.150
    53.609   561.404     0.150
    53.699   560.414     0.150
    53.699   626.562     0.150
    53.699   560.145     0.150
    53.699   559.574     0.150
    53.740   563.113     0.150
    53.867   561.125     0.150
    53.867   561.770     0.150
    53.867   561.045     0.150
    53.875   562.854     0.150
    53.910   563.664     0.150
    53.910   628.164     0.150
    53.910   563.424     0.150
    53.910   563.914     0.150
    53.910   563.244     0.150
    53.910   562.465     0.150
    54.135   564.014     0.150
    54.135  1021.465     0.150
    54.150   565.004     0.150
    54.270   566.924     0.150
    54.409   567.145     0.150
    55.061   570.994     0.150
    55.061   571.264     0.150
    55.061   570.645     0.150
    55.679   575.414     0.150
    56.173   577.334     0.150
    56.563   582.443     0.150
    56.700   581.545     0.150
    56.810   583.344     0.150
    56.810   638.645     0.150
    56.810   583.045     0.150
    56.835   584.244     0.150
    56.927   584.568     0.150
    56.927   639.594     0.150
    56.927  2391.545     0.150
    56.927   584.943     0.150
    57.115   587.045     0.150
    57.529   588.744     0.150
    58.104   591.805     0.150
    58.055   592.205     0.150
    60.231   608.545     0.150
    60.647   609.645     0.150
    60.647   609.656     0.150
    60.719   610.613     0.150
    60.719   610.244     0.150
    60.719   610.064     0.150
    61.033   612.754     0.150
    61.897   617.254     0.150
    61.897   616.645     0.150
    61.897   616.824     0.150
    62.639   623.303     0.150
    63.366   628.420     0.150
    63.831   632.010     0.150
    63.850   631.297     0.150
    63.878   631.020     0.150
    63.878  2369.494     0.150
    63.900   632.104     0.150
    63.988   632.213     0.150
    64.412   635.096     0.150
    64.634   635.545     0.150
    64.634   635.174     0.150
    64.580   636.262     0.150
    64.684   637.232     0.150
    64.822   638.719     0.150
    64.822  2368.670     0.150
    64.822   638.084     0.150
    64.822   638.744     0.150
    65.108   638.805     0.150
    65.305   641.223     0.150
    65.513   641.064     0.150
    65.519   642.766     0.150
    65.519   643.217     0.150
    65.596   642.402     0.150
    65.596   642.621     0.150
    65.606   642.443     0.150
    65.661   643.281     0.150
    65.663   642.891     0.150
    65.727   643.766     0.150
    65.727   643.973     0.150
    66.088   645.369     0.150
    66.088   646.029     0.150
    66.090   646.975     0.150
    66.090   647.564     0.150
    66.296   647.062     0.150
    66.296   647.973     0.150
    66.391   649.242     0.150
    66.391   648.469     0.150
    66.957   652.008     0.150
    67.268   653.244     0.150
    67.439   654.004     0.150
    67.678   656.496     0.150
    67.996   656.875     0.150
    68.064   658.113     0.150
    68.253   658.844     0.150
    68.253   658.693     0.150
    68.346   659.795     0.150
    68.552   661.510     0.150
    69.069   664.334     0.150
    69.127   663.764     0.150
    69.285   664.773     0.150
    69.468   667.045     0.150
    70.584   674.039     0.150
    73.462   691.004     0.150
    73.690   693.943     0.150
    74.245   696.645     0.150
    74.568   696.844     0.150
    74.568   710.344     0.150
    74.568   861.244     0.150
    75.344   704.014     0.150
    75.344   703.545     0.150
    75.344   703.045     0.150
    75.408   702.488     0.150
    75.630   704.045     0.150
    75.649   704.645     0.150
    75.732   705.943     0.150
    75.787   702.744     0.150
    75.996   706.744     0.150
    76.175   707.045     0.150
    76.276   709.045     0.150
    76.292   707.443     0.150
    76.474   706.635     0.150
    76.412   709.443     0.150
    76.561   709.744     0.150
    76.561  1295.344     0.150
    76.606   711.045     0.150
    76.679   709.943     0.150
    76.752   711.744     0.150
    76.822   711.295     0.150
    76.829   711.312     0.150
    76.829   711.113     0.150
    76.829   710.744     0.150
    76.829   711.693     0.150
    76.854   711.145     0.150
    77.059   713.145     0.150
    77.173   712.475     0.150
    77.162   713.844     0.150
    77.341   713.773     0.150
    77.428   712.744     0.150
    77.487   716.145     0.150
    77.563   716.443     0.150
    77.622   715.244     0.150
    77.908   719.943     0.150
    78.125   718.314     0.150
    78.091   717.283     0.150
    78.161   719.244     0.150
    78.345   719.844     0.150
    78.440   719.244     0.150
    78.440   719.404     0.150
    78.520   721.744     0.150
    78.667   721.363     0.150
    78.797   722.344     0.150
    78.963   720.943     0.150
    78.992   721.443     0.150
    78.992   731.545     0.150
    78.992   903.344     0.150
    78.994   721.244     0.150
    79.008   724.145     0.150
    79.035   721.443     0.150
    79.136   722.443     0.150
    79.763   726.922     0.150
    79.787   725.045     0.150
    79.787   732.344     0.150
    79.787   906.844     0.150
    80.089   729.744     0.150
    80.327   731.244     0.150
    80.419   729.344     0.150
    80.419   913.145     0.150
    80.419  1334.145     0.150
    80.419   729.555     0.150
    80.551   729.402     0.150
    80.556   730.443     0.150
    80.556   730.055     0.150
    80.553   730.045     0.150
    80.553  1335.244     0.150
    80.599   731.145     0.150
    80.654   730.744     0.150
    80.721   730.604     0.150
    80.970   731.557     0.150
    80.974   731.295     0.150
    80.974  1854.943     0.150
    80.974  2330.795     0.150
    80.996   734.145     0.150
    81.043   734.545     0.150
    81.292   736.145     0.150
    81.599   737.344     0.150
    81.605   737.244     0.150
    81.899   738.943     0.150
    82.185   741.156     0.150
    82.289   741.145     0.150
    82.429   741.293     0.150
    82.440   742.734     0.150
    82.459   740.244     0.150
    82.547   743.533     0.150
    82.572   742.844     0.150
    82.606   742.244     0.150
    82.731   743.104     0.150
    82.831   744.555     0.150
    82.886   743.145     0.150
    82.886  1358.744     0.150
    82.886  1687.244     0.150
    82.916   744.734     0.150
    82.921   745.145     0.150
    83.011   744.734     0.150
    83.017   744.734     0.150
    83.049   743.545     0.150
    83.071   746.443     0.150
    83.093   745.045     0.150
    83.101   745.744     0.150
    83.244   744.939     0.150
    83.324   745.924     0.150
    83.333   745.744     0.150
    83.336   746.770     0.150
    83.413   744.955     0.150
    83.564   747.045     0.150
    83.767   746.969     0.150
    83.854   748.045     0.150
    83.883   748.443     0.150
    83.884   748.295     0.150
    83.884   944.943     0.150
    83.884  1837.893     0.150
    83.884  1844.244     0.150
    83.884  2326.045     0.150
    83.916   748.645     0.150
    83.938   749.744     0.150
    83.995   747.904     0.150
    84.021   748.844     0.150
    84.044   749.545     0.150
    84.107   749.943     0.150
    84.159   750.494     0.150
    84.265   751.045     0.150
    84.272   750.545     0.150
    84.316   750.744     0.150
    84.356   751.244     0.150
    84.434   751.443     0.150
    84.481   750.844     0.150
    84.482   751.443     0.150
    84.509   751.863     0.150
    84.509   751.545     0.150
    84.526   751.705     0.150
    84.616   752.145     0.150
    84.787   753.145     0.150
    84.831   752.244     0.150
    84.929   753.576     0.150
    85.080   753.943     0.150
    85.115   753.545     0.150
    85.115   753.568     0.150
    85.115   753.443     0.150
    85.115   754.461     0.150
    85.115   755.045     0.150
    85.121   753.545     0.150
    85.338   754.451     0.150
    85.338   954.227     0.150
    85.338   754.744     0.150
    85.354   755.744     0.150
    85.370   755.545     0.150
    85.370   754.795     0.150
    85.511   755.244     0.150
    85.542   756.645     0.150
    85.660   756.844     0.150
    85.907   758.145     0.150
    86.120   760.686     0.150
    86.130   759.145     0.150
    86.149   759.645     0.150
    86.166   759.273     0.150
    86.240   759.844     0.150
    86.241   758.244     0.150
    86.241   951.244     0.150
    86.241  1391.244     0.150
    86.258   759.229     0.150
    86.260   759.523     0.150
    86.260   959.975     0.150
    86.263   759.744     0.150
    86.269   759.354     0.150
    86.316   759.844     0.150
    86.348   759.844     0.150
    86.432   761.145     0.150
    86.566   761.545     0.150
    86.577   760.844     0.150
    86.585   760.844     0.150
    86.695   764.094     0.150
    86.695   763.545     0.150
    86.695   762.045     0.150
    86.719   761.943     0.150
    86.850   762.545     0.150
    86.979   763.344     0.150
    86.979   763.662     0.150
    86.985   763.010     0.150
    87.039   763.545     0.150
    87.039   763.678     0.150
    87.117   764.037     0.150
    87.109   763.834     0.150
    87.115   764.145     0.150
    87.124   763.645     0.150
    87.130   763.244     0.150
    87.130   763.443     0.150
    87.130   763.244     0.150
    87.146   763.744     0.150
    87.216   764.645     0.150
    87.274   765.045     0.150
    87.321   764.744     0.150
    87.368   764.744     0.150
    87.475   766.191     0.150
    87.480   765.215     0.150
    87.559   767.393     0.150
    87.574   764.943     0.150
    87.606   764.844     0.150
    87.730   766.943     0.150
    87.798   768.662     0.150
    87.797   767.346     0.150
    87.802   767.145     0.150
    87.804   767.363     0.150
    87.876   768.145     0.150
    87.876   768.305     0.150
    87.899   767.145     0.150
    87.915   766.744     0.150
    87.915   767.443     0.150
    87.932   768.145     0.150
    87.939   767.943     0.150
    87.953   769.316     0.150
    88.279   767.104     0.150
    88.075   768.420     0.150
    88.156   769.645     0.150
    88.157   768.145     0.150
    88.221   768.645     0.150
    88.281   768.844     0.150
    88.281   769.344     0.150
    88.307   769.145     0.150
    88.387   769.258     0.150
    88.387   768.008     0.150
    88.387  1832.932     0.150
    88.448   770.992     0.150
    88.452   770.045     0.150
    88.452   770.645     0.150
    88.468   769.584     0.150
    88.491   770.164     0.150
    88.491   770.906     0.150
    88.535   770.881     0.150
    88.519   771.344     0.150
    88.519   770.924     0.150
    88.524   770.514     0.150
    88.602   771.645     0.150
    88.602   770.943     0.150
    88.971   773.094     0.150
    88.676   771.344     0.150
    88.687   770.844     0.150
    88.687   771.145     0.150
    88.752   771.545     0.150
    88.752   772.344     0.150
    89.025   769.955     0.150
    88.768   772.025     0.150
    88.780   771.344     0.150
    88.818   772.344     0.150
    88.975   772.545     0.150
    89.085   770.545     0.150
    89.089   773.363     0.150
    89.100   773.344     0.150
    89.117   772.844     0.150
    89.135   773.045     0.150
    89.161   774.145     0.150
    89.170   773.344     0.150
    89.229   773.344     0.150
    89.311   774.510     0.150
    89.369   773.727     0.150
    89.400   773.145     0.150
    89.400   774.344     0.150
    89.418   773.943     0.150
    89.418   774.545     0.150
    89.467   774.943     0.150
    89.519   775.045     0.150
    89.581   776.145     0.150
    89.620   775.145     0.150
    89.652   775.645     0.150
    89.658   776.545     0.150
    89.699   775.645     0.150
    89.721   774.844     0.150
    89.816   778.725     0.150
    89.820   781.045     0.150
    89.829   780.844     0.150
    89.803   776.943     0.150
    89.874   775.443     0.150
    89.894   777.803     0.150
    89.904   776.244     0.150
    89.929   776.344     0.150
    90.031   781.844     0.150
    90.158   782.645     0.150
    90.112   778.744     0.150
    90.147   778.215     0.150
    90.177   777.344     0.150
    90.177  1426.346     0.150
    90.202   778.045     0.150
    90.249   779.545     0.150
    90.261   777.545     0.150
    90.374   779.354     0.150
    90.400   779.244     0.150
    90.447   778.545     0.150
    90.509   778.545     0.150
    90.584   778.744     0.150
    90.710   780.344     0.150
    90.683   781.043     0.150
    90.828   779.844     0.150
    90.828   780.445     0.150
    90.828   780.314     0.150
    90.943   785.943     0.150
    90.963   786.244     0.150
    90.888   780.244     0.150
    90.884   780.045     0.150
    90.905   780.545     0.150
    90.906   780.943     0.150
    90.945   781.244     0.150
    90.949   782.244     0.150
    90.969   780.844     0.150
    91.077   782.145     0.150
    91.077   782.582     0.150
    91.060   782.729     0.150
    91.078   782.443     0.150
    91.257   787.443     0.150
    91.211   783.502     0.150
    91.227   784.443     0.150
    91.300   782.977     0.150
    91.308   783.744     0.150
    91.308   783.943     0.150
    91.346   782.744     0.150
    91.374   784.443     0.150
    91.379   782.844     0.150
    91.404   783.045     0.150
    91.413   782.344     0.150
    91.413   782.045     0.150
    91.569   784.896     0.150
    91.587   783.344     0.150
    91.644   784.545     0.150
    91.647   783.443     0.150
    91.655   783.744     0.150
    91.722   783.744     0.150
    91.737   783.645     0.150
    91.767   783.943     0.150
    91.786   783.844     0.150
    91.817   783.943     0.150
    91.826   787.744     0.150
    91.855   785.625     0.150
    91.871   784.443     0.150
    91.913   785.943     0.150
    91.913   786.748     0.150
    92.039   785.564     0.150
    92.042   786.443     0.150
    92.067   785.943     0.150
    92.067   786.125     0.150
    92.067   786.119     0.150
    92.067  1007.568     0.150
    92.067  1826.795     0.150
    92.081   784.545     0.150
    92.201   785.244     0.150
    92.203   787.145     0.150
    92.222   785.443     0.150
    92.222   786.645     0.150
    92.263   787.443     0.150
    92.298   785.045     0.150
    92.383   786.443     0.150
    92.405   788.645     0.150
    92.420   789.244     0.150
    92.424   787.545     0.150
    92.505   788.955     0.150
    92.644   788.344     0.150
    92.701   787.344     0.150
    92.723   787.145     0.150
    92.738   788.545     0.150
    92.763   790.244     0.150
    92.794   789.045     0.150
    92.830   790.545     0.150
    92.830   791.279     0.150
    92.830   790.943     0.150
    92.830  1019.045     0.150
    92.866   789.443     0.150
    92.918   788.645     0.150
    92.941   790.844     0.150
    92.976   788.943     0.150
    92.976   789.344     0.150
    92.993   789.943     0.150
    92.999   788.645     0.150
    93.027   792.443     0.150
    93.042   792.943     0.150
    93.080   790.244     0.150
    93.087   790.344     0.150
    93.233   791.744     0.150
    93.238   793.545     0.150
    93.301   791.344     0.150
    93.358   792.344     0.150
    93.385   792.344     0.150
    93.386   793.645     0.150
    93.386  1466.443     0.150
    93.391   791.744     0.150
    93.414   793.443     0.150
    93.466   793.943     0.150
    93.468   792.545     0.150
    93.517   793.244     0.150
    93.567   794.613     0.150
    93.567  1021.639     0.150
    93.567   795.246     0.150
    93.607   791.645     0.150
    93.771   795.244     0.150
    93.771  1022.943     0.150
    93.810   794.971     0.150
    93.934   794.045     0.150
    93.936   794.943     0.150
    93.936   795.533     0.150
    93.956   795.045     0.150
    94.019   794.844     0.150
    94.057   795.545     0.150
    94.096   794.844     0.150
    94.124   796.455     0.150
    94.124   795.145     0.150
    94.151   795.244     0.150
    94.253   798.045     0.150
    94.302   796.744     0.150
    94.320   795.844     0.150
    94.464   798.943     0.150
    94.470   797.244     0.150
    94.486   798.549     0.150
    94.486  1028.814     0.150
    94.490   797.443     0.150
    94.585   798.545     0.150
    94.622   799.264     0.150
    94.622  1025.045     0.150
    94.664   799.145     0.150
    94.837   797.744     0.150
    94.898   798.645     0.150
    94.932   800.525     0.150
    94.932  1033.113     0.150
    95.010   799.844     0.150
    95.010  1475.244     0.150
    95.010  1550.244     0.150
    95.215   801.939     0.150
    95.215  1813.139     0.150
    95.197   800.904     0.150
    95.445   802.713     0.150
    95.445  1036.570     0.150
    95.461   802.443     0.150
    95.481   802.844     0.150
    95.481  1480.846     0.150
    95.511   803.568     0.150
    95.511  1036.420     0.150
    95.511  1813.193     0.150
    95.510   802.863     0.150
    95.510  1039.744     0.150
    95.521   803.279     0.150
    95.521  1032.783     0.150
    95.706   803.904     0.150
    95.746   804.244     0.150
    95.816   804.684     0.150
    95.816  1039.668     0.150
    95.994   804.545     0.150
    96.167   805.344     0.150
    96.358   807.012     0.150
    96.383   806.680     0.150
    96.506   806.545     0.150
    96.726   808.516     0.150
    96.991   809.045     0.150
    97.036   809.154     0.150
    97.036  1048.750     0.150
    97.392   811.365     0.150
    97.392  1049.471     0.150
    97.474  1494.744     0.150
    97.401   811.150     0.150
    97.677   812.775     0.150
    97.677  1050.885     0.150
    97.693   812.775     0.150
    97.742   813.971     0.150
    97.849   813.516     0.150
    97.991   815.316     0.150
    98.056   814.697     0.150
    98.056  1054.611     0.150
    98.061   814.545     0.150
    98.300   816.568     0.150
    98.333   817.178     0.150
    98.478   816.951     0.150
    98.478  1062.369     0.150
    98.625   818.482     0.150
    98.714   818.418     0.150
    98.687   816.840     0.150
    98.687  1059.480     0.150
    98.810   818.855     0.150
    98.986   819.344     0.150
    98.986   818.305     0.150
    99.032   819.045     0.150
    99.175   819.982     0.150
    99.352   821.268     0.150
    99.428   821.711     0.150
    99.651   820.504     0.150
    99.692   822.750     0.150
    99.778   823.398     0.150
    99.937   823.738     0.150
   100.054   824.354     0.150
   100.361   825.852     0.150
   100.418   825.859     0.150
   100.592   826.666     0.150
   100.642   826.537     0.150
   100.851   827.568     0.150
   100.859   828.082     0.150
   100.926   828.348     0.150
   101.112   829.322     0.150
   101.134   829.176     0.150
   101.269   829.920     0.150
   101.499   829.404     0.150
   101.499  1796.346     0.150
   101.759   831.389     0.150
   101.992  1808.096     0.150
   103.453   838.619     0.150
   103.453  1099.418     0.150
   103.853   840.676     0.150
   105.000   846.670     0.150
   105.000  1107.770     0.150
   105.000  1788.096     0.150
   105.000  1804.893     0.150
   105.000   845.764     0.150
   105.186   846.244     0.150
   105.377  1102.479     0.150
   106.719  1104.715     0.150
   107.442  1106.410     0.150
   107.937  1106.822     0.150
   108.322  1107.373     0.150
   108.433  1107.914     0.150
   108.513  1108.408     0.150
   108.609  1108.238     0.150
   108.659   864.381     0.150
   108.659  1107.395     0.150
   108.659  1132.295     0.150
   108.659  1775.045     0.150
   108.659  1787.846     0.150
   108.771  1108.193     0.150
   109.113  1109.309     0.150
   109.168  1109.404     0.150
   109.174  1109.412     0.150
   109.818  1110.029     0.150
   110.141  1112.434     0.150
   110.232  1770.818     0.150
   110.562  1111.479     0.150
   110.940  1112.209     0.150
   110.950  1113.760     0.150
   110.950  1769.670     0.150
   110.994   872.645     0.150
   110.994  1110.619     0.150
   110.994  1767.018     0.150
   111.116  1112.391     0.150
   111.263  1112.855     0.150
   111.468  1156.744     0.150
   111.866  1764.967     0.150
   111.866  1112.137     0.150
   111.920  1113.893     0.150
   111.944  1113.625     0.150
   112.021  1162.344     0.150
   112.254  1764.053     0.150
   112.254  1111.031     0.150
   112.263  1764.580     0.150
   112.263  1113.008     0.150
   112.295  1162.045     0.150
   112.371  1115.650     0.150
   112.620  1116.260     0.150
   112.789  1116.066     0.150
   112.790  1168.545     0.150
   112.815  1168.145     0.150
   113.080  1165.943     0.150
   113.186  1117.195     0.150
   113.269  1167.943     0.150
   113.582  1170.545     0.150
   114.003  1172.844     0.150
   114.052  1118.490     0.150
   114.392  1181.244     0.150
   114.660  1178.943     0.150
   114.892  1179.545     0.150
   114.989  1120.303     0.150
   115.022  1118.869     0.150
   115.062  1120.295     0.150
   115.062  1179.670     0.150
   115.062  1757.518     0.150
   115.111  1120.174     0.150
   115.224  1186.645     0.150
   115.344  1121.004     0.150
   115.370  1120.238     0.150
   115.370  1119.854     0.150
   115.634  1120.027     0.150
   116.132  1120.988     0.150
   116.168  1120.807     0.150
   116.168  1121.135     0.150
   116.525  1121.947     0.150
   116.826  1122.482     0.150
   116.982  1122.842     0.150
   117.268  1123.324     0.150
   117.268  1122.863     0.150
   117.513  1123.754     0.150
   117.513  1124.305     0.150
   117.708  1124.150     0.150
   117.833  1124.014     0.150
   117.922  1124.555     0.150
   118.047  1124.984     0.150
   118.047  1125.545     0.150
   118.088  1125.047     0.150
   118.088  1125.295     0.150
   118.088  1124.129     0.150
   118.088  1192.344     0.150
   118.088  1744.744     0.150
   118.088  1974.619     0.150
   118.088  1984.045     0.150
   118.388  1125.727     0.150
   118.416  1125.543     0.150
   118.489  1125.293     0.150
   118.575  1125.857     0.150
   118.604  1125.992     0.150
   118.648  1125.514     0.150
   118.737  1126.396     0.150
   118.737  1126.523     0.150
   118.859  1126.232     0.150
   118.920  1126.139     0.150
   119.032  1126.957     0.150
   119.086  1126.422     0.150
   119.086  1126.545     0.150
   119.281  1126.729     0.150
   119.340  1127.213     0.150
   119.396  1127.646     0.150
   119.416  1127.400     0.150
   119.532  1127.639     0.150
   119.547  1127.182     0.150
   119.758  1127.758     0.150
   119.805  1128.357     0.150
   119.918  1128.580     0.150
   119.922  1128.648     0.150
   119.925  1128.383     0.150
   120.038  1129.994     0.150
   120.038  1211.693     0.150
   120.038  1736.721     0.150
   120.038  1129.824     0.150
   120.062  1128.750     0.150
   120.121  1128.551     0.150
   120.148  1128.625     0.150
   120.188  1129.223     0.150
   120.220  1128.842     0.150
   120.261  1128.713     0.150
   120.272  1129.160     0.150
   120.337  1129.006     0.150
   120.485  1128.889     0.150
   120.518  1129.455     0.150
   120.626  1129.545     0.150
   120.644  1129.758     0.150
   120.699  1129.496     0.150
   120.709  1129.928     0.150
   120.748  1130.137     0.150
   120.813  1130.307     0.150
   120.908  1130.002     0.150
   120.921  1130.316     0.150
   120.948  1131.148     0.150
   120.933  1130.277     0.150
   120.995  1129.865     0.150
   121.036  1130.318     0.150
   121.075  1130.834     0.150
   121.174  1131.139     0.150
   121.179  1130.594     0.150
   121.224  1130.760     0.150
   121.227  1130.744     0.150
   121.227  1130.994     0.150
   121.237  1130.615     0.150
   121.256  1131.127     0.150
   121.289  1130.615     0.150
   121.298  1131.260     0.150
   121.354  1131.166     0.150
   121.366  1130.711     0.150
   121.366  1131.467     0.150
   121.475  1131.074     0.150
   121.476  1131.371     0.150
   121.918  1131.596     0.150
   121.571  1131.543     0.150
   121.575  1131.531     0.150
   121.667  1131.748     0.150
   121.670  1131.832     0.150
   121.715  1132.307     0.150
   121.731  1131.832     0.150
   121.754  1131.920     0.150
   121.776  1131.959     0.150
   121.808  1132.180     0.150
   121.820  1132.068     0.150
   121.935  1132.389     0.150
   121.964  1132.604     0.150
   122.061  1132.877     0.150
   122.076  1132.465     0.150
   122.067  1132.574     0.150
   122.067  1132.314     0.150
   122.098  1132.422     0.150
   122.137  1133.318     0.150
   122.125  1133.012     0.150
   122.206  1132.553     0.150
   122.242  1132.717     0.150
   122.259  1132.809     0.150
   122.285  1133.059     0.150
   122.298  1132.951     0.150
   122.361  1132.844     0.150
   122.364  1133.145     0.150
   122.396  1133.174     0.150
   122.412  1133.354     0.150
   122.413  1133.098     0.150
   122.463  1133.293     0.150
   122.479  1133.281     0.150
   122.535  1133.529     0.150
   122.544  1133.453     0.150
   122.600  1133.762     0.150
   122.609  1133.473     0.150
   122.616  1133.914     0.150
   122.630  1133.674     0.150
   122.648  1133.641     0.150
   122.676  1133.705     0.150
   122.673  1133.820     0.150
   122.711  1133.965     0.150
   122.756  1133.646     0.150
   122.751  1133.875     0.150
   122.788  1134.713     0.150
   122.810  1134.109     0.150
   122.824  1133.949     0.150
   122.841  1134.443     0.150
   122.862  1133.969     0.150
   122.862  1237.943     0.150
   122.891  1134.039     0.150
   122.933  1134.346     0.150
   122.942  1133.881     0.150
   122.951  1134.703     0.150
   122.979  1133.930     0.150
   122.992  1134.305     0.150
   123.007  1134.207     0.150
   123.023  1134.104     0.150
   123.062  1134.150     0.150
   123.091  1134.670     0.150
   123.109  1134.699     0.150
   123.129  1134.490     0.150
   123.149  1134.590     0.150
   123.286  1134.840     0.150
   123.304  1134.711     0.150
   123.307  1135.021     0.150
   123.327  1134.992     0.150
   123.368  1135.178     0.150
   123.379  1135.082     0.150
   123.406  1135.072     0.150
   123.430  1135.076     0.150
   123.463  1135.723     0.150
   123.489  1135.318     0.150
   123.509  1135.820     0.150
   123.502  1135.291     0.150
   123.495  1135.271     0.150
   123.563  1135.373     0.150
   123.561  1135.561     0.150
   123.591  1135.713     0.150
   123.581  1135.602     0.150
   123.586  1135.398     0.150
   123.575  1239.545     0.150
   123.673  1135.791     0.150
   123.697  1136.652     0.150
   123.677  1135.664     0.150
   123.714  1135.801     0.150
   123.768  1135.963     0.150
   123.837  1135.988     0.150
   123.830  1135.666     0.150
   123.913  1136.070     0.150
   123.910  1136.164     0.150
   123.921  1136.305     0.150
   123.969  1136.211     0.150
   123.968  1136.203     0.150
   123.966  1136.285     0.150
   123.986  1136.557     0.150
   123.969  1136.715     0.150
   123.980  1136.096     0.150
   124.014  1136.168     0.150
   124.033  1136.309     0.150
   124.051  1136.723     0.150
   124.079  1136.506     0.150
   124.080  1136.627     0.150
   124.100  1136.551     0.150
   124.101  1136.689     0.150
   124.108  1136.357     0.150
   124.116  1137.002     0.150
   124.135  1136.750     0.150
   124.250  1136.787     0.150
   124.251  1136.996     0.150
   124.288  1136.715     0.150
   124.311  1136.736     0.150
   124.326  1137.316     0.150
   124.332  1137.420     0.150
   124.337  1137.188     0.150
   124.345  1137.158     0.150
   124.352  1137.164     0.150
   124.395  1137.533     0.150
   124.403  1137.395     0.150
   124.444  1137.227     0.150
   124.437  1137.916     0.150
   124.445  1137.057     0.150
   124.469  1137.266     0.150
   124.472  1137.613     0.150
   124.566  1137.650     0.150
   124.583  1137.512     0.150
   124.619  1137.691     0.150
   124.624  1137.199     0.150
   124.628  1137.672     0.150
   124.628  1138.045     0.150
   124.619  1137.814     0.150
   124.642  1137.393     0.150
   124.670  1137.654     0.150
   124.709  1138.049     0.150
   124.742  1138.539     0.150
   124.776  1137.980     0.150
   124.781  1138.033     0.150
   124.800  1138.115     0.150
   124.796  1138.311     0.150
   124.867  1138.471     0.150
   124.874  1138.666     0.150
   124.876  1138.375     0.150
   124.966  1138.625     0.150
   124.969  1138.430     0.150
   124.980  1138.383     0.150
   125.006  1138.365     0.150
   125.014  1138.404     0.150
   125.042  1138.145     0.150
   125.086  1138.814     0.150
   125.089  1139.006     0.150
   125.126  1138.719     0.150
   125.137  1138.686     0.150
   125.160  1139.943     0.150
   125.155  1138.707     0.150
   125.180  1138.195     0.150
   125.196  1138.979     0.150
   125.218  1138.807     0.150
   125.212  1138.879     0.150
   125.297  1138.773     0.150
   125.303  1138.717     0.150
   125.380  1139.857     0.150
   125.394  1139.600     0.150
   125.427  1139.879     0.150
   125.456  1139.098     0.150
   125.489  1138.930     0.150
   125.501  1139.369     0.150
   125.499  1139.795     0.150
   125.500  1139.859     0.150
   125.515  1139.777     0.150
   125.522  1139.332     0.150
   125.522  1139.844     0.150
   125.542  1139.873     0.150
   125.622  1139.596     0.150
   125.636  1139.842     0.150
   125.722  1139.729     0.150
   125.804  1139.674     0.150
   125.811  1139.828     0.150
   125.808  1140.301     0.150
   125.818  1140.109     0.150
   125.888  1140.146     0.150
   125.892  1140.340     0.150
   125.911  1140.072     0.150
   125.899  1140.324     0.150
   125.911  1140.426     0.150
   125.918  1140.664     0.150
   125.950  1140.107     0.150
   125.956  1140.504     0.150
   125.973  1140.586     0.150
   125.980  1140.562     0.150
   126.012  1140.375     0.150
   126.012  1140.764     0.150
   126.019  1140.424     0.150
   126.103  1140.887     0.150
   126.172  1140.875     0.150
   126.179  1140.531     0.150
   126.204  1140.797     0.150
   126.198  1141.045     0.150
   126.218  1140.947     0.150
   126.218  1141.344     0.150
   126.218  1257.193     0.150
   126.244  1141.051     0.150
   126.284  1140.598     0.150
   126.295  1141.062     0.150
   126.310  1140.914     0.150
   126.338  1140.418     0.150
   126.346  1141.006     0.150
   126.374  1141.043     0.150
   126.380  1141.244     0.150
   126.415  1141.090     0.150
   126.448  1141.230     0.150
   126.476  1141.316     0.150
   126.478  1141.373     0.150
   126.510  1141.443     0.150
   126.541  1141.373     0.150
   126.659  1141.877     0.150
   126.674  1141.727     0.150
   126.680  1141.986     0.150
   126.695  1141.549     0.150
   126.718  1141.803     0.150
   126.742  1141.912     0.150
   126.771  1142.123     0.150
   126.777  1141.693     0.150
   126.797  1141.975     0.150
   126.831  1142.240     0.150
   126.867  1141.881     0.150
   126.917  1142.266     0.150
   126.951  1142.371     0.150
   126.959  1142.500     0.150
   126.958  1141.994     0.150
   126.995  1142.355     0.150
   127.000  1141.844     0.150
   127.041  1142.771     0.150
   127.043  1142.311     0.150
   127.057  1142.504     0.150
   127.106  1142.174     0.150
   127.108  1142.482     0.150
   127.109  1142.670     0.150
   127.109  1142.621     0.150
   127.189  1142.709     0.150
   127.193  1142.604     0.150
   127.224  1142.182     0.150
   127.231  1142.664     0.150
   127.238  1142.965     0.150
   127.246  1142.506     0.150
   127.249  1142.918     0.150
   127.269  1143.359     0.150
   127.360  1143.193     0.150
   127.422  1143.309     0.150
   127.431  1143.490     0.150
   127.476  1143.379     0.150
   127.499  1143.281     0.150
   127.497  1143.074     0.150
   127.518  1143.176     0.150
   127.548  1143.195     0.150
   127.572  1143.211     0.150
   127.594  1143.717     0.150
   127.708  1143.359     0.150
   127.821  1144.045     0.150
   127.823  1144.115     0.150
   127.856  1143.873     0.150
   127.859  1144.150     0.150
   127.993  1144.215     0.150
   128.003  1144.109     0.150
   128.015  1143.904     0.150
   128.019  1144.469     0.150
   128.049  1144.508     0.150
   128.058  1144.230     0.150
   128.062  1144.322     0.150
   128.167  1144.705     0.150
   128.166  1144.973     0.150
   128.249  1144.844     0.150
   128.276  1145.277     0.150
   128.326  1145.289     0.150
   128.338  1144.898     0.150
   128.359  1145.242     0.150
   128.378  1144.920     0.150
   128.391  1144.932     0.150
   128.406  1145.055     0.150
   128.455  1145.525     0.150
   128.575  1145.914     0.150
   128.584  1145.646     0.150
   128.626  1145.479     0.150
   128.638  1145.773     0.150
   128.675  1145.541     0.150
   128.690  1146.062     0.150
   128.715  1145.688     0.150
   128.740  1145.803     0.150
   129.095  1146.268     0.150
   128.818  1145.947     0.150
   128.885  1145.965     0.150
   129.041  1146.318     0.150
   129.055  1146.676     0.150
   129.404  1146.783     0.150
   129.095  1146.816     0.150
   129.173  1146.424     0.150
   129.203  1147.188     0.150
   129.229  1146.760     0.150
   129.388  1147.566     0.150
   129.419  1147.572     0.150
   129.430  1146.924     0.150
   129.445  1147.418     0.150
   129.454  1147.500     0.150
   129.464  1147.051     0.150
   129.517  1147.367     0.150
   129.543  1147.607     0.150
   129.566  1147.992     0.150
   129.725  1148.561     0.150
   129.765  1147.861     0.150
   129.814  1147.824     0.150
   129.825  1148.008     0.150
   129.845  1147.875     0.150
   129.861  1147.826     0.150
   129.870  1148.076     0.150
   129.915  1148.648     0.150
   129.977  1148.240     0.150
   130.002  1148.186     0.150
   130.110  1148.656     0.150
   130.189  1148.887     0.150
   130.197  1149.168     0.150
   130.284  1148.764     0.150
   130.308  1148.785     0.150
   130.345  1149.232     0.150
   130.362  1149.084     0.150
   130.434  1148.996     0.150
   130.545  1149.334     0.150
   130.564  1149.590     0.150
   130.573  1149.635     0.150
   130.609  1149.605     0.150
   130.629  1149.600     0.150
   130.649  1149.809     0.150
   130.658  1150.043     0.150
   130.683  1150.217     0.150
   130.794  1150.045     0.150
   130.932  1150.312     0.150
   130.990  1150.432     0.150
   131.081  1150.094     0.150
   131.127  1151.064     0.150
   131.129  1150.699     0.150
   131.187  1150.523     0.150
   131.260  1151.287     0.150
   131.330  1150.918     0.150
   131.381  1151.418     0.150
   131.429  1151.852     0.150
   131.551  1152.090     0.150
   131.627  1152.689     0.150
   131.643  1152.729     0.150
   132.227  1153.605     0.150
   133.433  1154.840     0.150
   138.126  1163.145     0.150
   145.190  1176.904     0.150
   145.205  1176.014     0.150
   145.205  1176.154     0.150
   145.296  1176.693     0.150
   145.698  1178.334     0.150
   145.789  1178.863     0.150
   145.904  1179.234     0.150
   146.027  1179.104     0.150
   146.107  1178.113     0.150
   146.686  1179.193     0.150
   149.939  1189.004     0.150
   150.625  1186.039     0.150
   150.625  1190.590     0.150
   150.625  1185.545     0.150
   150.625  1190.443     0.150
   150.625  1198.645     0.150
   151.387  1186.045     0.150
   151.387  1192.045     0.150
   152.882  1189.635     0.150
   153.545  1191.023     0.150
   153.560  1189.344     0.150
   153.990  1192.244     0.150
   154.020  1190.305     0.150
   154.104  1191.314     0.150
   154.425  1191.033     0.150
   154.773  1191.424     0.150
   154.949  1191.594     0.150
   155.080  1194.244     0.150
   155.119  1191.055     0.150
   155.092  1194.244     0.150
   155.172  1194.244     0.150
   155.311  1192.354     0.150
   155.343  1192.584     0.150
   155.352  1194.244     0.150
   155.361  1194.244     0.150
   155.398  1194.244     0.150
   155.703  1191.875     0.150
   155.790  1192.254     0.150
   155.805  1193.844     0.150
   155.848  1193.004     0.150
   155.863  1192.834     0.150
   156.063  1193.004     0.150
   156.572  1194.404     0.150
   156.597  1194.404     0.150
   156.573  1224.244     0.150
   156.596  1194.988     0.150
   156.596  1439.389     0.150
   156.640  1195.443     0.150
   156.729  1193.844     0.150
   156.882  1195.770     0.150
   156.882  1442.693     0.150
   157.146  1194.684     0.150
   157.486  1194.965     0.150
   157.659  1195.414     0.150
   157.983  1197.494     0.150
   157.983  1232.020     0.150
   157.993  1229.344     0.150
   158.505  1230.924     0.150
   159.422  1197.645     0.150
   159.422  1235.844     0.150
   159.702  1197.488     0.150
   159.702  1238.789     0.150
   159.702  1198.184     0.150
   159.702  1238.533     0.150
   160.157  1198.625     0.150
   160.157  1239.664     0.150
   162.424  1200.389     0.150
   162.424  1249.889     0.150
   162.424  1473.064     0.150
   162.424  1200.613     0.150
   162.424  1250.434     0.150
   163.512  1201.594     0.150
   163.512  1251.994     0.150
   163.512  1475.693     0.150
   163.512  1201.744     0.150
   163.512  1252.545     0.150
   164.773  1203.045     0.150
   164.773  1257.523     0.150
   164.773  1482.244     0.150
   166.782  1205.494     0.150
   166.782  1270.670     0.150
   166.782  1495.193     0.150
   166.782  1205.234     0.150
   166.782  1270.533     0.150
   170.045  1205.283     0.150
   170.045  1282.404     0.150
   170.045  1205.965     0.150
   170.294  1206.389     0.150
   170.294  1282.889     0.150
   170.294  1512.713     0.150
   172.269  1207.484     0.150
   172.269  1292.023     0.150
   172.269  1521.764     0.150
   173.150  1207.844     0.150
   173.150  1295.984     0.150
     0.388     7.453     0.150
     0.388    14.264     0.150
     0.867    15.633     0.150
     0.867    28.982     0.150
     0.954    16.832     0.150
     0.954    31.623     0.150
     1.265    23.104     0.150
     1.265    42.002     0.150
     1.559    27.143     0.150
     1.555    26.613     0.150
     1.859    30.373     0.150
     2.040    33.973     0.150
     2.156    34.604     0.150
     2.156    64.854     0.150
     2.180    36.543     0.150
     2.289    36.732     0.150
     2.289    67.873     0.150
     2.554    40.732     0.150
     2.554    74.572     0.150
     2.647    41.752     0.150
     3.093    48.553     0.150
     3.077    47.652     0.150
     3.104    49.863     0.150
     3.194    53.363     0.150
     3.194    96.104     0.150
     3.239    51.273     0.150
     3.239    51.648     0.150
     3.239    51.143     0.150
     3.536    55.062     0.150
     3.536    97.443     0.150
     3.648    56.043     0.150
     3.788    59.312     0.150
     4.097    62.172     0.150
     4.267    64.752     0.150
     4.807    74.213     0.150
     5.120    86.127     0.150
     6.383    94.502     0.150
     8.469   124.203     0.150
     8.624   124.652     0.150
     8.624   221.893     0.150
     9.610   142.604     0.150
     9.691   138.104     0.150
     9.691   138.264     0.150
     9.691   247.842     0.150
    10.966   156.633     0.150
    11.019   163.402     0.150
    12.061   168.902     0.150
    12.935   181.229     0.150
    13.176   184.713     0.150
    13.438   187.002     0.150
    13.544   195.703     0.150
    13.637   194.633     0.150
    13.865   198.303     0.150
    13.865   196.842     0.150
    14.069   198.803     0.150
    14.087   207.604     0.150
    14.155   198.902     0.150
    14.754   215.604     0.150
    14.873   215.312     0.150
    15.176   218.104     0.150
    15.176   212.322     0.150
    15.367   216.592     0.150
    15.436   219.896     0.150
    15.436   221.965     0.150
    15.436   215.902     0.150
    15.414   215.902     0.150
    15.512   218.402     0.150
    15.795   223.604     0.150
    15.795   399.104     0.150
    15.853   229.104     0.150
    15.998   227.883     0.150
    16.416   229.604     0.150
    16.416   238.703     0.150
    16.416   412.104     0.150
    16.416   231.592     0.150
    17.292   246.277     0.150
    17.292   242.242     0.150
    18.525   259.002     0.150
    18.525   256.082     0.150
    18.697   259.502     0.150
    18.848   262.203     0.150
    18.848   261.434     0.150
    19.555   270.303     0.150
    19.555   267.992     0.150
    19.852   273.203     0.150
    19.920   275.002     0.150
    20.005   273.127     0.150
    20.005   272.902     0.150
    20.161   277.303     0.150
    20.290   281.002     0.150
    20.344   278.104     0.150
    20.590   281.002     0.150
    20.605   282.104     0.150
    20.723   279.229     0.150
    20.723   280.002     0.150
    20.742   283.104     0.150
    20.742   282.104     0.150
    20.916   286.303     0.150
    21.242   289.502     0.150
    21.225   285.523     0.150
    21.467   289.203     0.150
    21.601   293.303     0.150
    21.601   290.264     0.150
    22.073   296.902     0.150
    22.069   294.342     0.150
    22.233   297.283     0.150
    22.256   296.604     0.150
    22.296   301.902     0.150
    22.398   299.303     0.150
    22.401   297.303     0.150
    22.526   300.703     0.150
    22.790   304.104     0.150
    23.022   308.303     0.150
    23.224   308.104     0.150
    23.301   310.203     0.150
    23.311   308.553     0.150
    23.311   308.902     0.150
    23.358   308.803     0.150
    23.358   307.764     0.150
    23.422   308.434     0.150
    23.595   311.303     0.150
    23.595   310.543     0.150
    23.698   312.803     0.150
    23.698   310.854     0.150
    23.899   315.203     0.150
    23.936   311.604     0.150
    23.936   312.703     0.150
    24.085   315.902     0.150
    24.070   315.502     0.150
    24.109   315.803     0.150
    24.186   319.303     0.150
    24.208   315.252     0.150
    24.351   317.172     0.150
    24.555   320.703     0.150
    24.587   320.402     0.150
    24.756   322.002     0.150
    24.756   320.764     0.150
    24.804   323.703     0.150
    24.884   323.203     0.150
    24.927   323.803     0.150
    25.096   325.803     0.150
    25.132   325.002     0.150
    25.228   326.604     0.150
    25.269   328.203     0.150
    25.259   327.703     0.150
    25.425   329.502     0.150
    25.437   328.703     0.150
    25.706   330.928     0.150
    25.706   330.223     0.150
    25.706   330.354     0.150
    25.706   539.803     0.150
    25.706   329.902     0.150
    25.789   332.303     0.150
    25.800   331.402     0.150
    25.804   331.473     0.150
    25.804   330.203     0.150
    25.872   330.412     0.150
    25.926   332.303     0.150
    25.926   539.527     0.150
    25.926   331.604     0.150
    25.926   331.582     0.150
    25.926   539.623     0.150
    26.128   332.553     0.150
    26.506   339.303     0.150
    26.561   339.604     0.150
    26.803   339.203     0.150
    26.901   339.703     0.150
    27.616   346.203     0.150
    27.616   346.502     0.150
    27.616   543.854     0.150
    27.702   347.303     0.150
    27.702   347.002     0.150
    27.894   347.553     0.150
    27.894   543.428     0.150
    28.112   351.402     0.150
    28.112   637.303     0.150
    29.458   360.502     0.150
    29.458   655.303     0.150
    29.458   360.061     0.150
    29.458   548.561     0.150
    30.000   367.322     0.150
    30.412   370.322     0.150
    30.766   374.502     0.150
    30.786   374.902     0.150
    31.373   380.803     0.150
    31.373   377.703     0.150
    31.378   377.854     0.150
    31.378   551.527     0.150
    31.382   377.553     0.150
    31.568   380.104     0.150
    32.706   394.402     0.150
    34.191   405.184     0.150
    34.191   404.402     0.150
    34.191   403.303     0.150
    34.762   408.453     0.150
    34.763   408.104     0.150
    34.763   484.652     0.150
    34.763   561.252     0.150
    34.763   408.402     0.150
    34.839   410.104     0.150
    34.839   410.854     0.150
    34.839   562.699     0.150
    34.839   410.104     0.150
    34.897   411.104     0.150
    36.434   426.299     0.150
    36.434   425.104     0.150
    36.433   425.402     0.150
    36.628   425.104     0.150
    36.628   506.203     0.150
    37.005   428.703     0.150
    37.005   568.078     0.150
    37.005   428.402     0.150
    37.683   434.803     0.150
    38.317   441.002     0.150
    38.424   441.803     0.150
    39.121   447.902     0.150
    39.374   448.703     0.150
    39.374   448.832     0.150
    39.374   577.652     0.150
    39.693   452.703     0.150
    39.708   451.377     0.150
    39.708   577.428     0.150
    39.708   450.703     0.150
    40.034   455.502     0.150
    40.322   457.104     0.150
    40.334   457.203     0.150
    40.428   458.672     0.150
    40.428   457.803     0.150
    40.499   458.703     0.150
    40.589   459.604     0.150
    40.600   580.043     0.150
    40.600   459.562     0.150
    40.600   580.045     0.150
    40.600   459.303     0.150
    40.659   457.973     0.150
    41.106   463.502     0.150
    41.911   470.604     0.150
    41.949   470.604     0.150
    42.874   477.896     0.150
    42.874   478.135     0.150
    43.100   478.402     0.150
    43.769   484.104     0.150
    43.819   483.703     0.150
    43.894   484.572     0.150
    44.027   485.773     0.150
    44.847   492.877     0.150
    44.847   597.604     0.150
    44.847   492.502     0.150
    44.836   493.521     0.150
    44.836   494.572     0.150
    44.836   494.104     0.150
    45.670   500.902     0.150
    46.133   504.902     0.150
    48.106   519.113     0.150
    48.399   521.303     0.150
    50.829   539.402     0.150
    50.887   539.803     0.150
    50.887   538.902     0.150
    50.887   539.203     0.150
    50.968   540.803     0.150
    50.967   541.002     0.150
    50.967   616.203     0.150
    50.967   541.402     0.150
    50.967   616.203     0.150
    50.967   540.943     0.150
    51.157   542.203     0.150
    51.157   542.684     0.150
    51.238   541.502     0.150
    51.360   543.303     0.150
    51.815   549.803     0.150
    51.815   990.404     0.150
    51.979   549.402     0.150
    52.090   550.162     0.150
    52.090   549.604     0.150
    52.174   548.604     0.150
    52.174   992.701     0.150
    52.174   548.982     0.150
    52.174   620.742     0.150
    52.664   554.812     0.150
    53.278   559.803     0.150
    53.369   559.203     0.150
    53.369   559.783     0.150
    53.706   562.412     0.150
    53.841   564.053     0.150
    53.874   561.703     0.150
    53.874   561.902     0.150
    53.971   563.303     0.150
    54.008   564.023     0.150
    54.008   564.871     0.150
    54.008   563.803     0.150
    54.008   564.633     0.150
    54.008   563.514     0.150
    54.244   565.684     0.150
    54.372   567.723     0.150
    54.508   568.264     0.150
    55.101   571.871     0.150
    55.101   571.203     0.150
    55.101   571.383     0.150
    55.102   571.678     0.150
    55.693   575.902     0.150
    56.711   582.854     0.150
    56.711   637.428     0.150
    56.912   584.303     0.150
    56.912   584.002     0.150
    56.912   584.402     0.150
    57.597   588.502     0.150
    60.690   654.412     0.150
    60.690   610.516     0.150
    60.762   611.572     0.150
    60.762   611.002     0.150
    61.195   613.963     0.150
    61.744   616.012     0.150
    61.744   615.732     0.150
    62.865   625.018     0.150
    63.273   627.711     0.150
    63.587   629.521     0.150
    63.806   630.578     0.150
    64.051   633.152     0.150
    64.075   633.301     0.150
    64.122   633.520     0.150
    64.219   633.920     0.150
    64.414   632.902     0.150
    64.414   666.703     0.150
    64.648   636.629     0.150
    64.800   637.369     0.150
    64.907   638.184     0.150
    64.967   639.854     0.150
    64.967   639.062     0.150
    65.526   642.609     0.150
    65.684   642.803     0.150
    65.684   643.082     0.150
    65.724   642.732     0.150
    65.727   644.588     0.150
    65.727   644.406     0.150
    65.809   644.371     0.150
    65.809   643.945     0.150
    65.850   644.986     0.150
    65.871   644.963     0.150
    65.874   644.791     0.150
    65.874   645.326     0.150
    65.942   645.352     0.150
    66.226   646.883     0.150
    66.300   648.391     0.150
    66.300   648.621     0.150
    66.301   647.031     0.150
    66.301   647.211     0.150
    66.540   649.729     0.150
    66.605   650.271     0.150
    66.605   649.730     0.150
    66.918   651.592     0.150
    67.165   652.428     0.150
    67.202   653.805     0.150
    67.302   653.803     0.150
    67.923   658.658     0.150
    68.302   659.703     0.150
    68.290   659.223     0.150
    68.290   658.803     0.150
    68.308   659.725     0.150
    68.332   660.912     0.150
    68.798   663.559     0.150
    68.983   664.502     0.150
    73.557   691.178     0.150
    74.688   696.303     0.150
    74.688   710.502     0.150
    74.688   862.502     0.150
    75.481   704.047     0.150
    75.481   704.871     0.150
    75.481   704.203     0.150
    75.481   703.922     0.150
    75.625   704.348     0.150
    75.625   704.203     0.150
    75.801   703.002     0.150
    76.078   704.002     0.150
    76.406   709.002     0.150
    76.671   713.803     0.150
    76.797   710.252     0.150
    76.938   711.926     0.150
    76.945   712.764     0.150
    76.945   712.322     0.150
    76.945   711.303     0.150
    76.945   711.764     0.150
    77.503   713.002     0.150
    77.594   716.232     0.150
    77.838   716.172     0.150
    78.160   717.502     0.150
    79.040   721.502     0.150
    79.109   722.002     0.150
    79.109  1318.701     0.150
    79.110   721.902     0.150
    79.204   722.902     0.150
    79.520   725.131     0.150
    79.837   725.402     0.150
    79.837   731.902     0.150
    79.837   910.803     0.150
    80.465   730.041     0.150
    80.472   729.729     0.150
    80.472   730.402     0.150
    80.472   912.502     0.150
    80.472   730.152     0.150
    80.663   730.303     0.150
    80.663  1333.604     0.150
    80.712   730.215     0.150
    80.717   730.604     0.150
    80.924   732.703     0.150
    82.360   742.041     0.150
    82.360   742.402     0.150
    82.466   740.402     0.150
    83.038   743.002     0.150
    83.134   744.842     0.150
    83.354   747.502     0.150
    83.506   748.328     0.150
    83.632   749.303     0.150
    83.676   748.902     0.150
    83.734   746.803     0.150
    83.735   747.072     0.150
    83.912   748.082     0.150
    84.019   749.604     0.150
    84.019   749.104     0.150
    84.019   749.203     0.150
    84.019   946.154     0.150
    84.019   748.873     0.150
    84.220   751.203     0.150
    84.252   752.002     0.150
    84.345   751.678     0.150
    84.474   751.002     0.150
    84.644   753.291     0.150
    84.644   752.104     0.150
    84.661   752.582     0.150
    84.680   752.002     0.150
    84.837   752.104     0.150
    85.128   753.854     0.150
    85.128   754.033     0.150
    85.400   755.502     0.150
    85.412   755.152     0.150
    85.412   755.383     0.150
    85.563   755.303     0.150
    86.419   762.496     0.150
    86.720   763.703     0.150
    86.992   765.652     0.150
    86.992   765.430     0.150
    86.992   765.871     0.150
    86.992   765.303     0.150
    87.974   768.203     0.150
    88.082   770.652     0.150
    88.621   769.816     0.150
    88.591   770.303     0.150
    88.607   771.402     0.150
    88.607   771.572     0.150
    88.612   771.773     0.150
    90.258   778.703     0.150
    90.786   780.303     0.150
    91.310   783.127     0.150
    91.378   784.002     0.150
    91.506   783.502     0.150
    91.775   784.703     0.150
    92.069   786.104     0.150
    92.069   786.277     0.150
    92.214   786.803     0.150
    92.347   787.002     0.150
    93.450   793.604     0.150
    93.637   794.898     0.150
    93.637   795.203     0.150
    93.843   796.303     0.150
    94.966   800.947     0.150
    95.066   801.303     0.150
    95.066  1030.303     0.150
    95.527  1035.678     0.150
    95.549   803.303     0.150
    95.580   803.902     0.150
    95.580   803.252     0.150
    95.580   803.604     0.150
    95.899  1039.943     0.150
    95.970   805.604     0.150
    96.461  1040.947     0.150
    96.875   809.502     0.150
    97.114  1045.771     0.150
    97.193   811.303     0.150
    97.695   814.514     0.150
    98.007   815.684     0.150
    98.761   818.189     0.150
    99.048   819.938     0.150
   100.605   827.023     0.150
   100.622   827.207     0.150
   100.980   828.588     0.150
   101.508   832.131     0.150
   103.582  1099.826     0.150
   104.690   845.252     0.150
   104.690  1789.771     0.150
   104.690  1805.529     0.150
   106.299  1104.861     0.150
   111.031  1112.729     0.150
   117.202  1124.334     0.150
   118.282  1125.139     0.150
   118.310  1126.123     0.150
   118.310  1125.951     0.150
   118.310  1743.826     0.150
   118.310  1125.643     0.150
   118.337  1125.494     0.150
   118.792  1126.971     0.150
   118.821  1126.150     0.150
   119.012  1126.525     0.150
   119.159  1127.592     0.150
   119.318  1127.209     0.150
   119.530  1127.311     0.150
   119.674  1128.357     0.150
   119.689  1127.693     0.150
   119.724  1129.334     0.150
   119.724  1129.428     0.150
   119.724  1739.479     0.150
   119.724  1129.201     0.150
   119.824  1128.791     0.150
   119.991  1128.795     0.150
   120.038  1127.596     0.150
   120.265  1128.252     0.150
   120.645  1129.873     0.150
   120.684  1129.740     0.150
   120.705  1129.920     0.150
   120.861  1130.143     0.150
   120.923  1130.830     0.150
   120.953  1130.557     0.150
   120.982  1131.021     0.150
   120.992  1130.486     0.150
   121.020  1130.971     0.150
   121.672  1131.592     0.150
   121.322  1131.064     0.150
   121.443  1131.490     0.150
   121.443  1131.412     0.150
   121.525  1131.877     0.150
   121.569  1131.686     0.150
   121.572  1132.127     0.150
   121.693  1132.104     0.150
   121.829  1133.131     0.150
   121.833  1132.389     0.150
   121.886  1132.576     0.150
   122.007  1132.717     0.150
   122.029  1131.479     0.150
   122.072  1130.951     0.150
   122.159  1132.963     0.150
   122.271  1133.041     0.150
   122.362  1133.408     0.150
   122.381  1133.436     0.150
   122.415  1133.326     0.150
   122.486  1134.217     0.150
   122.484  1133.100     0.150
   122.544  1133.424     0.150
   122.571  1134.639     0.150
   122.644  1134.334     0.150
   122.719  1133.545     0.150
   122.748  1134.568     0.150
   122.813  1134.006     0.150
   122.918  1135.189     0.150
   123.100  1135.033     0.150
   123.113  1133.350     0.150
   123.162  1133.174     0.150
   123.172  1133.889     0.150
   123.218  1135.432     0.150
   123.243  1135.342     0.150
   123.367  1135.514     0.150
   123.371  1135.838     0.150
   123.386  1135.963     0.150
   123.446  1135.771     0.150
   123.456  1135.854     0.150
   123.492  1135.623     0.150
   123.550  1134.846     0.150
   123.656  1135.822     0.150
   123.669  1135.994     0.150
   123.771  1136.506     0.150
   123.773  1136.330     0.150
   123.771  1136.514     0.150
   123.851  1136.518     0.150
   123.858  1136.350     0.150
   123.862  1136.119     0.150
   123.877  1136.811     0.150
   123.884  1136.045     0.150
   123.907  1137.236     0.150
   123.914  1136.502     0.150
   123.995  1136.693     0.150
   124.028  1136.838     0.150
   124.062  1136.455     0.150
   124.067  1136.592     0.150
   124.114  1135.908     0.150
   124.115  1136.807     0.150
   124.129  1137.291     0.150
   124.191  1136.990     0.150
   124.210  1136.775     0.150
   124.222  1137.459     0.150
   124.253  1137.146     0.150
   124.338  1137.389     0.150
   124.361  1137.635     0.150
   124.367  1137.252     0.150
   124.378  1137.252     0.150
   124.381  1137.439     0.150
   124.384  1137.154     0.150
   124.417  1137.721     0.150
   124.514  1138.002     0.150
   124.543  1138.014     0.150
   124.571  1138.287     0.150
   124.590  1138.072     0.150
   124.670  1137.701     0.150
   124.732  1138.451     0.150
   124.738  1138.396     0.150
   124.756  1137.908     0.150
   124.856  1139.404     0.150
   124.888  1138.611     0.150
   124.895  1138.377     0.150
   124.919  1138.580     0.150
   124.984  1139.072     0.150
   124.994  1138.693     0.150
   125.045  1138.615     0.150
   125.167  1139.346     0.150
   125.228  1139.127     0.150
   125.246  1139.486     0.150
   125.261  1139.236     0.150
   125.269  1139.639     0.150
   125.384  1139.314     0.150
   125.403  1139.799     0.150
   125.471  1140.104     0.150
   125.544  1139.877     0.150
   125.557  1139.666     0.150
   125.587  1140.451     0.150
   125.628  1140.229     0.150
   125.628  1139.701     0.150
   125.649  1140.053     0.150
   125.687  1139.928     0.150
   125.684  1140.244     0.150
   125.692  1140.486     0.150
   125.725  1140.139     0.150
   125.746  1140.205     0.150
   125.753  1140.232     0.150
   125.775  1140.135     0.150
   125.783  1140.072     0.150
   125.863  1140.455     0.150
   125.927  1140.584     0.150
   125.951  1140.564     0.150
   125.974  1140.709     0.150
   125.986  1139.775     0.150
   125.996  1140.314     0.150
   126.018  1140.861     0.150
   126.064  1140.736     0.150
   126.065  1140.998     0.150
   126.085  1140.604     0.150
   126.124  1140.963     0.150
   126.191  1141.213     0.150
   126.222  1141.459     0.150
   126.241  1141.322     0.150
   126.442  1141.502     0.150
   126.453  1141.783     0.150
   126.459  1142.127     0.150
   126.468  1141.666     0.150
   126.478  1141.658     0.150
   126.503  1141.787     0.150
   126.505  1141.725     0.150
   126.562  1142.080     0.150
   126.622  1142.322     0.150
   126.622  1142.201     0.150
   126.635  1142.217     0.150
   126.714  1141.701     0.150
   126.747  1141.986     0.150
   126.754  1142.104     0.150
   126.796  1142.561     0.150
   126.832  1142.350     0.150
   126.878  1142.373     0.150
   126.939  1142.143     0.150
   126.946  1142.193     0.150
   126.976  1142.615     0.150
   127.001  1143.217     0.150
   127.005  1143.037     0.150
   127.232  1142.943     0.150
   127.247  1143.205     0.150
   127.354  1143.666     0.150
   127.452  1143.799     0.150
   127.550  1143.854     0.150
   127.558  1143.936     0.150
   127.595  1143.775     0.150
   127.737  1143.693     0.150
   128.008  1145.174     0.150
   128.057  1145.064     0.150
   128.062  1145.568     0.150
   128.126  1145.295     0.150
   128.148  1144.115     0.150
   128.150  1144.287     0.150
   128.309  1145.662     0.150
   128.365  1145.838     0.150
   128.420  1145.955     0.150
   128.462  1146.127     0.150
   128.972  1145.842     0.150
   129.210  1147.045     0.150
   133.110  1153.975     0.150
   136.332  1160.725     0.150
   137.804  1163.428     0.150
   144.883  1175.604     0.150
   146.721  1180.479     0.150
   146.721  1180.303     0.150
   147.403  1181.611     0.150
   147.557  1182.674     0.150
   149.620  1188.803     0.150
   150.391  1190.604     0.150
   150.599  1191.373     0.150
   151.481  1191.303     0.150
   163.637  1201.752     0.150
   163.637  1252.803     0.150
   166.601  1205.928     0.150
   166.601  1269.803     0.150
   166.601  1205.604     0.150
     0.459     8.840     0.150
     0.459    15.340     0.150
     0.873    30.262     0.150
     0.925    32.949     0.150
     1.321    24.070     0.150
     1.321    43.020     0.150
     1.606    28.512     0.150
     1.606    49.371     0.150
     1.600    27.492     0.150
     1.600    49.852     0.150
     1.812    57.270     0.150
     2.094    36.852     0.150
     2.094    63.672     0.150
     2.221    37.883     0.150
     2.221    67.109     0.150
     2.104    35.500     0.150
     2.225    37.102     0.150
     2.505    42.922     0.150
     3.023    50.652     0.150
     3.126    56.852     0.150
     3.171    53.055     0.150
     3.171    90.906     0.150
     3.171    48.672     0.150
     3.171    85.133     0.150
     3.112    49.609     0.150
     3.167    50.770     0.150
     4.089    63.480     0.150
     4.874    75.562     0.150
     5.184    89.961     0.150
     8.606   123.121     0.150
     8.606   222.062     0.150
    10.899   154.539     0.150
    13.483   193.512     0.150
    13.841   194.020     0.150
    14.158   200.602     0.150
    14.423   202.770     0.150
    14.555   204.910     0.150
    15.111   211.730     0.150
    18.629   258.109     0.150
    18.778   259.812     0.150
    18.883   260.340     0.150
    19.149   261.012     0.150
    19.486   263.680     0.150
    19.935   273.438     0.150
    19.935   272.609     0.150
    20.291   276.109     0.150
    20.671   280.512     0.150
    20.671   281.512     0.150
    20.671   280.012     0.150
    21.195   286.609     0.150
    22.186   294.320     0.150
    22.597   300.512     0.150
    23.272   310.887     0.150
    23.421   309.660     0.150
    23.394   308.133     0.150
    23.634   310.473     0.150
    24.096   320.711     0.150
    24.250   315.562     0.150
    24.250   315.562     0.150
    24.418   319.711     0.150
    24.529   320.312     0.150
    24.744   322.191     0.150
    25.801   329.910     0.150
    25.745   331.012     0.150
    25.745   333.711     0.150
    25.745   330.609     0.150
    25.844   330.109     0.150
    25.923   332.887     0.150
    25.923   332.312     0.150
    25.922   332.332     0.150
    26.574   337.910     0.150
    27.684   348.109     0.150
    27.824   348.984     0.150
    27.824   348.391     0.150
    28.175   353.012     0.150
    29.516   364.609     0.150
    29.516   364.242     0.150
    30.349   369.699     0.150
    31.302   379.711     0.150
    31.302   378.070     0.150
    31.308   378.789     0.150
    31.308   553.160     0.150
    31.308   378.785     0.150
    31.308   553.160     0.150
    31.308   378.359     0.150
    31.308   552.340     0.150
    31.312   377.992     0.150
    31.899   388.512     0.150
    31.899   448.211     0.150
    32.777   395.012     0.150
    33.190   396.812     0.150
    34.691   407.121     0.150
    34.691   562.141     0.150
    34.692   409.562     0.150
    34.692   562.512     0.150
    34.692   409.109     0.150
    34.905   410.609     0.150
    34.905   411.984     0.150
    34.905   410.312     0.150
    34.964   411.609     0.150
    36.179   423.109     0.150
    39.445   450.812     0.150
    39.775   452.660     0.150
    39.775   578.211     0.150
    39.775   452.512     0.150
    40.671   460.609     0.150
    40.671   460.609     0.150
    40.671   458.711     0.150
    43.956   486.562     0.150
    43.838   487.410     0.150
    44.777   493.586     0.150
    44.777   492.512     0.150
    44.906   495.211     0.150
    46.197   506.711     0.150
    48.040   519.133     0.150
    50.944   541.359     0.150
    50.947   541.359     0.150
    51.032   542.910     0.150
    51.032   542.531     0.150
    51.032   542.535     0.150
    51.032   542.910     0.150
    51.032   542.410     0.150
    51.221   544.012     0.150
    51.873   551.512     0.150
    51.873   992.512     0.150
    52.040   550.211     0.150
    52.141   550.711     0.150
    52.571   555.211     0.150
    53.026   558.609     0.150
    53.942   562.332     0.150
    53.942   563.461     0.150
    53.942   563.082     0.150
    53.945   563.461     0.150
    54.068   566.207     0.150
    54.068   565.711     0.150
    54.068   563.832     0.150
    55.167   572.812     0.150
    55.167   572.570     0.150
    55.168   572.637     0.150
    55.863   577.859     0.150
    56.640   581.762     0.150
    56.972   584.812     0.150
    56.972   584.109     0.150
    56.972   584.562     0.150
    60.755   610.711     0.150
    60.755   610.723     0.150
    60.827   612.512     0.150
    61.245   612.449     0.150
    61.813   617.512     0.150
    61.813   616.711     0.150
    63.625   630.973     0.150
    63.877   631.723     0.150
    65.020   639.211     0.150
    65.020   638.070     0.150
    65.746   644.211     0.150
    65.746   643.531     0.150
    67.228   653.586     0.150
    68.356   687.312     0.150
    68.356  1466.910     0.150
    68.356   660.551     0.150
    68.922   665.371     0.150
    75.664   705.512     0.150
    76.135   705.711     0.150
    77.002   712.711     0.150
    80.537   732.410     0.150
    80.773   732.672     0.150
    80.773   732.859     0.150
    83.804   748.770     0.150
    83.804   748.770     0.150
    84.074   750.211     0.150
    85.196   754.711     0.150
    85.196   754.734     0.150
    85.478   756.262     0.150
    85.475   756.656     0.150
    95.130   803.211     0.150
    95.130  1032.211     0.150
   118.348  1126.910     0.150
   118.348  1127.391     0.150
   118.349  1126.910     0.150
   119.760  1130.688     0.150
   126.492  1143.762     0.150
   146.651  1181.688     0.150
   146.651  1180.410     0.150
     0.474     8.473     0.150
     1.021    20.742     0.150
     1.021    37.562     0.150
     1.268    22.934     0.150
     1.691    29.984     0.150
     1.691    52.242     0.150
     2.181    40.602     0.150
     2.181    68.742     0.150
     2.137    37.852     0.150
     2.137    65.164     0.150
     2.575    44.953     0.150
     3.086    57.504     0.150
     3.086   100.242     0.150
     3.129    49.457     0.150
     3.129    99.410     0.150
     8.707   130.594     0.150
    10.921   156.293     0.150
    18.982   265.273     0.150
    19.947   274.090     0.150
    23.705   314.332     0.150
    25.791   329.672     0.150
    25.841   336.312     0.150
    27.662   348.793     0.150
    27.827   349.352     0.150
    31.277   379.055     0.150
    31.282   379.715     0.150
    31.282   379.715     0.150
    31.282   380.344     0.150
    31.286   378.602     0.150
    31.525   381.191     0.150
    34.326   410.004     0.150
    34.671   409.852     0.150
    34.672   410.414     0.150
    34.672   408.965     0.150
    34.878   413.938     0.150
    40.695   464.504     0.150
    40.695   464.508     0.150
    44.747   493.090     0.150
    51.087   544.184     0.150
    51.087   544.242     0.150
    51.087   544.238     0.150
    51.087   544.375     0.150
    52.107   553.895     0.150
    53.983   564.504     0.150
    53.986   564.504     0.150
    55.218   573.973     0.150
    55.938   579.305     0.150
    57.040   588.293     0.150
    65.808   647.184     0.150
    65.808   646.914     0.150
    83.833   751.125     0.150
    83.833   751.125     0.150
    83.833   751.715     0.150
    83.833   751.582     0.150
    83.912   751.125     0.150
    85.239   758.883     0.150
    85.239   758.887     0.150
    85.535   758.812     0.150
   118.445  1128.012     0.150
   118.446  1128.012     0.150
   119.674  1131.305     0.150
   146.623  1182.188     0.150
     0.415     7.949     0.150
     0.415    14.770     0.150
     0.720    13.422     0.150
     0.720    24.828     0.150
     1.084    20.840     0.150
     1.084    35.949     0.150
     1.188    21.391     0.150
     1.188    40.539     0.150
     1.460    26.281     0.150
     1.460    47.398     0.150
     1.741    30.031     0.150
     1.683    29.070     0.150
     1.683    51.949     0.150
     2.217    36.859     0.150
     2.217    64.840     0.150
     2.239    37.328     0.150
     2.239    67.680     0.150
     2.121    35.691     0.150
     2.652    43.469     0.150
     2.652    79.012     0.150
     2.600    41.891     0.150
     3.059    50.898     0.150
     3.142    56.852     0.150
     3.142    93.602     0.150
     3.184    54.594     0.150
     3.184    94.121     0.150
     3.187    51.441     0.150
     3.424    56.051     0.150
     3.889    61.441     0.150
     4.114    64.109     0.150
     4.869    75.461     0.150
     6.364   109.102     0.150
     9.658   139.102     0.150
    10.999   161.301     0.150
    11.067   164.301     0.150
    12.053   170.000     0.150
    13.606   196.102     0.150
    13.650   195.570     0.150
    13.703   195.031     0.150
    14.032   202.500     0.150
    14.490   209.602     0.150
    14.808   212.500     0.150
    14.883   211.441     0.150
    15.492   224.895     0.150
    15.687   224.398     0.150
    18.725   259.102     0.150
    18.731   260.602     0.150
    18.984   266.102     0.150
    18.984   261.480     0.150
    19.569   268.898     0.150
    19.569   265.090     0.150
    19.698   270.602     0.150
    19.920   273.602     0.150
    20.000   275.801     0.150
    20.023   274.102     0.150
    20.023   273.898     0.150
    20.235   275.500     0.150
    20.612   279.148     0.150
    20.612   279.699     0.150
    20.718   282.398     0.150
    20.827   279.711     0.150
    21.343   289.801     0.150
    22.393   303.199     0.150
    22.440   302.000     0.150
    22.541   302.801     0.150
    22.900   305.301     0.150
    23.314   311.801     0.150
    23.427   313.824     0.150
    23.494   313.199     0.150
    23.494   311.629     0.150
    23.675   309.219     0.150
    23.744   313.270     0.150
    23.885   313.875     0.150
    23.885   314.059     0.150
    24.214   321.102     0.150
    24.417   317.102     0.150
    25.261   328.801     0.150
    25.860   331.781     0.150
    25.838   332.199     0.150
    25.838   541.871     0.150
    25.838   331.602     0.150
    26.074   334.875     0.150
    26.073   331.531     0.150
    27.584   348.664     0.150
    27.757   348.398     0.150
    27.757   348.199     0.150
    28.194   353.301     0.150
    29.385   364.699     0.150
    29.385   364.141     0.150
    29.385   364.137     0.150
    30.331   369.910     0.150
    31.339   378.680     0.150
    31.345   378.500     0.150
    31.345   553.270     0.150
    31.345   378.500     0.150
    31.345   553.273     0.150
    31.345   379.000     0.150
    31.349   378.930     0.150
    31.370   379.211     0.150
    31.898   387.801     0.150
    32.737   396.500     0.150
    33.084   396.398     0.150
    34.310   406.699     0.150
    34.736   408.980     0.150
    34.737   409.148     0.150
    34.737   562.801     0.150
    34.799   411.352     0.150
    36.500   426.898     0.150
    36.543   424.699     0.150
    36.930   428.500     0.150
    39.672   452.898     0.150
    40.458   459.199     0.150
    40.632   462.160     0.150
    40.632   582.512     0.150
    40.632   462.160     0.150
    40.632   582.508     0.150
    40.632   459.500     0.150
    44.004   486.621     0.150
    44.808   492.949     0.150
    44.808   493.801     0.150
    44.867   494.117     0.150
    44.867   494.500     0.150
    44.867   494.012     0.150
    46.209   507.898     0.150
    50.810   542.449     0.150
    50.813   542.449     0.150
    51.042   543.102     0.150
    51.042   543.199     0.150
    51.042   660.539     0.150
    51.042   543.199     0.150
    51.042   660.543     0.150
    51.042   542.699     0.150
    51.481   543.852     0.150
    51.913   552.301     0.150
    51.913   993.301     0.150
    52.071   549.199     0.150
    52.150   550.898     0.150
    52.150    12.602     0.150
    52.203   551.398     0.150
    52.606   553.398     0.150
    53.929   562.250     0.150
    53.929   562.176     0.150
    53.929   563.301     0.150
    53.932   562.172     0.150
    54.100   565.797     0.150
    54.100   564.000     0.150
    55.170   572.699     0.150
    55.170   572.969     0.150
    55.171   573.000     0.150
    55.806   576.000     0.150
    55.910   577.078     0.150
    57.006   585.602     0.150
    57.006   585.500     0.150
    57.006   585.762     0.150
    60.760   612.102     0.150
    60.760   612.137     0.150
    60.832   612.500     0.150
    60.832   612.770     0.150
    61.724   618.859     0.150
    65.076   643.426     0.150
    65.769   644.551     0.150
    65.769   643.691     0.150
    65.980   647.656     0.150
    66.000   647.344     0.150
    66.005   646.371     0.150
    66.073   648.367     0.150
    66.358   648.742     0.150
    66.679   653.824     0.150
    66.737   651.754     0.150
    68.358   661.199     0.150
    68.358   808.699     0.150
    68.358  1205.000     0.150
    68.358   661.570     0.150
    75.757   706.027     0.150
    75.757   706.398     0.150
    75.859   704.500     0.150
    76.895   712.074     0.150
    77.586   715.500     0.150
    77.763   716.559     0.150
    78.880   722.410     0.150
    78.945   722.141     0.150
    79.193   723.801     0.150
    80.546   732.699     0.150
    80.639   730.922     0.150
    80.639   733.801     0.150
    80.639   731.500     0.150
    83.053   743.801     0.150
    83.402   746.820     0.150
    83.573   747.828     0.150
    83.772   747.879     0.150
    83.772   747.875     0.150
    84.124   752.199     0.150
    84.124   752.199     0.150
    84.124   750.801     0.150
    85.185   756.000     0.150
    85.185   756.023     0.150
    85.351   756.750     0.150
    85.440   758.172     0.150
    85.495   757.227     0.150
    87.141   767.023     0.150
    88.685   770.387     0.150
    94.893   800.875     0.150
    94.893   800.879     0.150
   118.444  1127.574     0.150
   118.444  1126.770     0.150
   118.444  1127.578     0.150
   119.604  1129.676     0.150
   126.598  1143.926     0.150
   146.684  1182.227     0.150
   146.684  1181.898     0.150
   163.640  1202.977     0.150
   166.479  1206.773     0.150
   166.479  1269.102     0.150
     0.384     7.199     0.150
     0.384    13.320     0.150
     0.682    12.520     0.150
     0.682    23.020     0.150
     1.134    22.398     0.150
     1.134    39.012     0.150
     1.131    20.000     0.150
     1.403    25.250     0.150
     1.403    45.320     0.150
     1.688    30.020     0.150
     1.688    52.949     0.150
     1.748    29.719     0.150
     1.748    53.781     0.150
     2.019    33.250     0.150
     2.019    63.770     0.150
     2.100    36.102     0.150
     2.274    37.840     0.150
     2.275    38.641     0.150
     2.275    68.770     0.150
     2.545    38.871     0.150
     2.708    45.520     0.150
     2.708    81.090     0.150
     3.167    51.520     0.150
     3.176    55.129     0.150
     3.176    96.969     0.150
     3.218    56.109     0.150
     3.218    95.559     0.150
     3.218    53.930     0.150
     4.151    68.371     0.150
     9.694   142.750     0.150
    11.053   159.441     0.150
    11.053   159.852     0.150
    12.099   170.340     0.150
    13.662   196.441     0.150
    14.546   209.039     0.150
    14.864   212.840     0.150
    15.548   220.910     0.150
    15.743   225.340     0.150
    18.608   259.941     0.150
    18.736   258.238     0.150
    18.785   262.441     0.150
    18.993   262.750     0.150
    19.620   271.039     0.150
    19.977   273.941     0.150
    20.074   274.266     0.150
    20.074   275.039     0.150
    20.884   285.340     0.150
    20.884   283.000     0.150
    22.404   303.238     0.150
    22.497   301.238     0.150
    23.606   310.410     0.150
    23.779   312.320     0.150
    25.843   333.168     0.150
    25.843   331.168     0.150
    25.906   332.941     0.150
    25.939   331.781     0.150
    26.111   333.648     0.150
    27.531   348.840     0.150
    27.950   348.891     0.150
    28.171   353.340     0.150
    31.379   379.918     0.150
    31.384   379.441     0.150
    31.384   553.602     0.150
    31.384   380.340     0.150
    31.388   380.219     0.150
    31.657   383.352     0.150
    31.869   454.141     0.150
    32.697   396.641     0.150
    34.744   411.777     0.150
    34.744   412.219     0.150
    34.778   410.031     0.150
    34.778   409.641     0.150
    34.778   562.848     0.150
    34.778   410.441     0.150
    36.471   427.840     0.150
    40.071   457.441     0.150
    40.593   461.738     0.150
    40.709   460.238     0.150
    43.191   483.441     0.150
    44.047   488.441     0.150
    44.827   495.230     0.150
    44.845   492.340     0.150
    46.184   508.238     0.150
    51.017   542.738     0.150
    51.017   542.289     0.150
    51.207   545.359     0.150
    51.898   550.641     0.150
    55.143   573.141     0.150
    55.144   572.090     0.150
    56.988   586.949     0.150
    60.732   611.352     0.150
    60.804   612.789     0.150
    65.747   644.371     0.150
    67.225   654.090     0.150
    75.763   706.039     0.150
    77.706   717.762     0.150
    80.581   733.027     0.150
    84.113   751.477     0.150
    85.472   757.625     0.150
   118.450  1127.664     0.150
   146.722  1181.488     0.150
     0.530    10.211     0.150
     0.530    17.121     0.150
     0.842    16.703     0.150
     0.842    28.773     0.150
     0.947    34.434     0.150
     1.410    26.281     0.150
     1.410    47.031     0.150
     1.592    48.582     0.150
     1.697    30.094     0.150
     1.697    53.293     0.150
     2.008    35.102     0.150
     2.182    38.754     0.150
     2.182    65.812     0.150
     2.415    41.641     0.150
     3.134    50.699     0.150
     3.134    88.648     0.150
     3.134    97.797     0.150
     3.134    85.582     0.150
     8.527   125.832     0.150
     8.527   220.051     0.150
    19.861   272.301     0.150
    20.671   280.652     0.150
    25.739   329.652     0.150
    25.724   331.152     0.150
    25.854   332.328     0.150
    25.853   332.043     0.150
    29.605   363.594     0.150
    29.605   363.980     0.150
    29.606   363.453     0.150
    31.255   379.051     0.150
    31.255   552.980     0.150
    31.255   379.055     0.150
    31.255   552.980     0.150
    34.635   409.164     0.150
    34.636   409.004     0.150
    34.636   562.953     0.150
    43.898   484.883     0.150
    44.728   491.922     0.150
    49.385   528.473     0.150
    51.060   543.801     0.150
    51.060   543.801     0.150
    51.060   543.051     0.150
    52.141   549.191     0.150
    55.199   573.363     0.150
    55.200   573.027     0.150
    56.987   586.230     0.150
    56.987   586.230     0.150
    60.787   611.953     0.150
    60.787   611.953     0.150
    60.859   612.281     0.150
    65.768   644.602     0.150
    84.079   750.992     0.150
    84.080   750.996     0.150
   146.601  1182.102     0.150
   146.601  1182.211     0.150
     0.559    19.719     0.150
     0.665    12.277     0.150
     0.665    22.777     0.150
     1.257    23.109     0.150
     1.257    40.020     0.150
     1.376    24.496     0.150
     1.376    44.887     0.150
     1.620    28.020     0.150
     1.884    32.008     0.150
     1.884    56.930     0.150
     1.937    32.797     0.150
     2.084    35.559     0.150
     2.084    64.488     0.150
     2.029    35.188     0.150
     2.304    41.270     0.150
     2.940    44.699     0.150
     3.255    89.762     0.150
     3.255    49.496     0.150
     3.070    50.656     0.150
     3.683    57.379     0.150
     8.224   121.328     0.150
    20.891   281.719     0.150
    23.220   307.328     0.150
    24.343   319.207     0.150
    25.461   329.027     0.150
    25.461   328.180     0.150
    25.461   328.609     0.150
    25.741   330.758     0.150
    27.715   346.402     0.150
    27.715   346.996     0.150
    27.915   349.090     0.150
    29.783   365.746     0.150
    29.784   365.859     0.150
    31.303   378.879     0.150
    31.302   378.879     0.150
    31.307   378.648     0.150
    31.328   377.930     0.150
    34.000   404.316     0.150
    34.667   408.340     0.150
    34.668   407.566     0.150
    34.668   408.477     0.150
    35.099   412.477     0.150
    35.099   412.066     0.150
    39.956   452.617     0.150
    40.684   458.457     0.150
    40.684   458.453     0.150
    44.788   493.219     0.150
    44.788   490.527     0.150
    50.926   540.469     0.150
    51.922   548.059     0.150
    53.893   562.816     0.150
    53.893   560.668     0.150
    53.893   562.348     0.150
    53.895   560.668     0.150
    55.078   571.840     0.150
    55.525   576.238     0.150
    56.812   583.566     0.150
    56.812   584.340     0.150
    56.812   583.430     0.150
    60.736   611.148     0.150
    64.813   637.992     0.150
    64.813   639.457     0.150
    65.175   638.809     0.150
    65.614   642.816     0.150
    65.614   642.988     0.150
    68.271   659.598     0.150
    68.716   659.637     0.150
    78.165   718.520     0.150
    81.049   731.266     0.150
    83.472   744.246     0.150
    83.877   748.219     0.150
    83.877   748.590     0.150
    83.877   748.219     0.150
    83.877   748.996     0.150
    85.347   754.543     0.150
     0.429     8.621     0.150
     0.817    15.684     0.150
     0.817    30.145     0.150
     1.026    32.941     0.150
     1.367    24.562     0.150
     1.430    26.113     0.150
     1.679    29.332     0.150
     1.679    52.473     0.150
     1.983    31.781     0.150
     1.970    34.551     0.150
     2.091    33.961     0.150
     2.343    36.953     0.150
     2.448    40.164     0.150
     2.714    43.582     0.150
     3.030    51.102     0.150
     3.249    56.062     0.150
     3.249    98.453     0.150
     3.296    54.793     0.150
     3.296    92.020     0.150
     3.296    52.031     0.150
     3.296    90.031     0.150
     3.431    56.242     0.150
     3.690    59.754     0.150
     4.144    65.203     0.150
     4.202    65.344     0.150
     4.753    73.312     0.150
     8.472   216.832     0.150
     9.723   140.914     0.150
    10.924   157.773     0.150
    10.924   156.543     0.150
    10.924   274.242     0.150
    10.962   161.973     0.150
    12.063   169.574     0.150
    13.472   195.172     0.150
    14.361   206.172     0.150
    15.368   219.992     0.150
    15.368   216.223     0.150
    17.353   239.863     0.150
    18.485   254.094     0.150
    18.652   261.773     0.150
    18.707   256.043     0.150
    19.532   272.473     0.150
    19.532   266.742     0.150
    19.977   271.996     0.150
    20.026   279.074     0.150
    20.450   278.672     0.150
    20.645   282.973     0.150
    20.645   276.242     0.150
    20.836   280.797     0.150
    20.836   283.672     0.150
    21.129   289.371     0.150
    21.772   295.672     0.150
    22.226   296.852     0.150
    22.283   295.914     0.150
    22.521   300.371     0.150
    22.666   302.973     0.150
    23.182   308.297     0.150
    23.218   309.371     0.150
    23.218   306.094     0.150
    23.263   306.523     0.150
    23.436   309.023     0.150
    24.291   317.074     0.150
    24.409   320.172     0.150
    24.601   318.301     0.150
    24.961   326.973     0.150
    25.001   326.473     0.150
    25.120   326.574     0.150
    25.570   328.293     0.150
    25.570   330.371     0.150
    25.570   328.992     0.150
    25.768   331.598     0.150
    25.767   329.434     0.150
    25.876   333.684     0.150
    26.644   338.074     0.150
    27.388   343.961     0.150
    27.652   346.633     0.150
    27.660   347.023     0.150
    27.878   350.223     0.150
    27.878   350.883     0.150
    28.033   351.473     0.150
    30.106   370.453     0.150
    30.491   372.191     0.150
    30.595   374.293     0.150
    31.400   380.512     0.150
    31.405   378.652     0.150
    31.405   378.656     0.150
    31.405   551.984     0.150
    31.405   380.164     0.150
    31.409   379.242     0.150
    31.772   386.773     0.150
    32.684   395.773     0.150
    34.781   410.152     0.150
    34.782   408.223     0.150
    34.782   561.121     0.150
    34.782   409.742     0.150
    34.892   410.598     0.150
    34.892   410.762     0.150
    34.942   412.273     0.150
    36.210   423.844     0.150
    39.755   451.898     0.150
    39.755   578.047     0.150
    40.576   458.273     0.150
    40.576   458.273     0.150
    40.576   460.164     0.150
    40.648   458.441     0.150
    44.042   488.145     0.150
    44.881   493.672     0.150
    44.881   494.434     0.150
    46.061   505.273     0.150
    48.169   520.234     0.150
    50.896   540.863     0.150
    50.896   542.074     0.150
    50.896   616.043     0.150
    50.896   542.074     0.150
    50.896   616.039     0.150
    51.085   543.645     0.150
    51.718   550.473     0.150
    51.718   991.473     0.150
    51.890   549.051     0.150
    51.976   549.152     0.150
    52.420   552.121     0.150
    53.824   560.918     0.150
    53.824   562.254     0.150
    53.827   560.914     0.150
    53.918   563.645     0.150
    55.036   571.023     0.150
    55.580   574.133     0.150
    55.705   574.422     0.150
    56.481   580.234     0.150
    56.821   583.594     0.150
    56.821   583.332     0.150
    56.821   583.543     0.150
    60.696   610.113     0.150
    61.774   617.121     0.150
    64.858   639.820     0.150
    64.858   638.582     0.150
    64.858   636.613     0.150
    65.602   643.961     0.150
    65.602   643.004     0.150
    68.227   660.012     0.150
    75.463   702.922     0.150
    75.489   702.551     0.150
    80.808   732.961     0.150
    80.808   731.395     0.150
    80.808   733.234     0.150
    83.758   749.523     0.150
    83.914   749.773     0.150
    83.914   749.773     0.150
    83.914   747.863     0.150
    85.076   755.582     0.150
    85.076   755.586     0.150
   118.173  1126.574     0.150
   118.174  1126.574     0.150
   146.751  1180.898     0.150
   146.751  1181.441     0.150
     0.425     8.137     0.150
     0.425    14.617     0.150
     0.701    12.969     0.150
     0.701    24.156     0.150
     1.182    20.969     0.150
     1.182    38.445     0.150
     1.100    22.367     0.150
     1.100    38.547     0.150
     1.450    26.156     0.150
     1.450    46.688     0.150
     1.701    29.828     0.150
     1.701    53.906     0.150
     1.725    31.266     0.150
     2.134    36.766     0.150
     2.230    38.387     0.150
     2.223    37.676     0.150
     2.223    69.316     0.150
     2.597    42.195     0.150
     3.052    51.496     0.150
     3.052    98.578     0.150
     3.201    54.578     0.150
     3.174    59.516     0.150
     3.174    93.867     0.150
     3.905    64.285     0.150
    20.022   273.547     0.150
    25.856   333.996     0.150
    31.337   379.320     0.150
    34.731   409.996     0.150
    34.731   562.539     0.150
    44.800   494.496     0.150
    51.054   543.121     0.150
    84.140   753.395     0.150
   119.590  1130.332     0.150
   146.676  1182.773     0.150
     0.777    13.770     0.150
     0.777    26.750     0.150
     1.063    19.090     0.150
     1.063    37.332     0.150
     1.160    20.832     0.150
     1.160    40.660     0.150
     1.450    26.109     0.150
     1.591    26.230     0.150
     1.591    47.520     0.150
     1.837    31.000     0.150
     1.837    56.719     0.150
     2.025    34.070     0.150
     2.254    37.031     0.150
     2.552    41.480     0.150
     3.142    52.852     0.150
     3.091    49.871     0.150
     3.126    49.281     0.150
     3.231    55.641     0.150
     3.231    97.750     0.150
     3.274    50.766     0.150
     3.274    50.551     0.150
     3.496    56.219     0.150
     4.777    74.539     0.150
     8.727   127.699     0.150
     9.740   137.770     0.150
    11.054   157.430     0.150
    13.971   199.238     0.150
    14.024   200.398     0.150
    14.410   206.559     0.150
    15.480   223.609     0.150
    16.433   229.961     0.150
    16.433   421.059     0.150
    18.611   255.520     0.150
    18.895   264.059     0.150
    18.895   263.441     0.150
    19.634   267.359     0.150
    20.085   274.066     0.150
    20.709   279.348     0.150
    20.848   280.609     0.150
    22.342   295.910     0.150
    22.464   299.762     0.150
    23.421   310.324     0.150
    23.404   307.832     0.150
    23.512   308.840     0.150
    23.683   311.859     0.150
    23.758   311.301     0.150
    24.856   321.500     0.150
    25.236   328.762     0.150
    25.236   366.762     0.150
    25.236   590.160     0.150
    25.236   602.160     0.150
    25.746   331.762     0.150
    25.746   331.762     0.150
    25.746   330.859     0.150
    26.020   333.586     0.150
    26.020   332.461     0.150
    26.019   332.422     0.150
    27.529   347.121     0.150
    27.586   347.121     0.150
    28.098   352.660     0.150
    31.429   380.699     0.150
    31.429   553.051     0.150
    31.429   380.699     0.150
    31.429   553.055     0.150
    31.805   387.059     0.150
    31.805   455.461     0.150
    32.654   394.660     0.150
    33.999   402.082     0.150
    34.214   404.762     0.150
    34.818   410.375     0.150
    34.748   410.660     0.150
    34.748   409.160     0.150
    34.809   410.961     0.150
    34.809   410.082     0.150
    36.406   426.059     0.150
    39.301   448.629     0.150
    39.619   451.402     0.150
    40.375   456.660     0.150
    40.549   460.480     0.150
    40.549   460.480     0.150
    40.549   459.762     0.150
    40.731   459.051     0.150
    44.084   487.109     0.150
    44.894   493.895     0.150
    44.894   493.160     0.150
    46.114   505.660     0.150
    50.948   541.961     0.150
    50.948   542.211     0.150
    50.948   542.211     0.150
    50.948   541.309     0.150
    51.137   542.859     0.150
    51.300   543.961     0.150
    51.385   545.219     0.150
    51.816   550.461     0.150
    51.816   987.660     0.150
    51.974   548.359     0.150
    52.106   548.859     0.150
    52.090   546.762     0.150
    52.090   549.082     0.150
    52.368   549.879     0.150
    53.839   560.961     0.150
    53.839   562.410     0.150
    53.839   560.820     0.150
    53.841   562.410     0.150
    54.004   565.305     0.150
    54.004   563.160     0.150
    55.077   570.859     0.150
    55.077   571.121     0.150
    55.078   572.387     0.150
    55.709   575.059     0.150
    55.745   575.160     0.150
    55.813   576.309     0.150
    56.909   583.961     0.150
    56.909   583.961     0.150
    60.738   609.262     0.150
    60.738   610.488     0.150
    64.979   640.578     0.150
    65.673   643.219     0.150
    68.265   659.602     0.150
    73.530   691.898     0.150
    75.666   704.461     0.150
    75.768   703.160     0.150
    76.946   709.160     0.150
    82.997   744.461     0.150
    83.687   747.949     0.150
    83.687   747.949     0.150
    85.094   755.262     0.150
    85.094   755.234     0.150
    85.399   755.898     0.150
    85.399   755.859     0.150
    87.070   766.504     0.150
    87.321   764.961     0.150
    95.046   799.160     0.150
   118.353  1127.512     0.150
   118.354  1127.512     0.150
   119.615  1129.961     0.150
   119.615  1129.910     0.150
   146.769  1180.285     0.150
     0.471     9.336     0.150
     0.471    15.984     0.150
     0.852    16.934     0.150
     0.852    29.355     0.150
     0.942    19.387     0.150
     0.942    33.496     0.150
     1.318    24.316     0.150
     1.318    43.926     0.150
     1.626    28.516     0.150
     1.626    50.215     0.150
     2.093    63.965     0.150
     3.190    51.484     0.150
     3.869    60.195     0.150
    19.927   273.562     0.150
    25.771   332.195     0.150
    27.690   346.754     0.150
    27.747   346.754     0.150
    31.291   378.387     0.150
    31.291   553.262     0.150
    31.291   378.387     0.150
    31.291   553.266     0.150
    34.676   408.805     0.150
    34.676   562.375     0.150
    34.677   409.414     0.150
    34.677   562.375     0.150
    34.677   408.945     0.150
    43.941   485.344     0.150
    51.053   542.934     0.150
    51.053   542.797     0.150
    51.053   617.566     0.150
    51.053   542.793     0.150
    51.053   617.562     0.150
    51.053   542.324     0.150
    51.243   543.887     0.150
    52.167   551.266     0.150
    53.961   563.004     0.150
    53.961   563.297     0.150
    53.964   563.004     0.150
    55.188   572.086     0.150
    55.189   572.199     0.150
    56.995   585.715     0.150
    63.892   632.145     0.150
   118.374  1127.062     0.150
   118.375  1127.066     0.150
   126.518  1142.520     0.150
   146.634  1180.145     0.150
     0.573    11.078     0.150
     0.573    19.887     0.150
     0.668    12.438     0.150
     0.668    21.730     0.150
     1.148    21.359     0.150
     1.148    39.758     0.150
     1.416    24.430     0.150
     1.416    44.000     0.150
     1.518    26.668     0.150
     1.831    31.449     0.150
     1.831    52.918     0.150
     1.956    32.578     0.150
     2.017    34.219     0.150
     2.017    62.070     0.150
     2.298    37.609     0.150
     2.294    37.820     0.150
     2.856    45.008     0.150
     2.889    45.230     0.150
     3.074    49.047     0.150
     3.197    55.098     0.150
     3.197    96.098     0.150
     3.247    50.930     0.150
     3.247    50.504     0.150
     3.247    48.188     0.150
     3.281    95.418     0.150
     3.336    52.367     0.150
     3.707    57.637     0.150
     3.755    58.688     0.150
     3.811    58.457     0.150
     4.103    63.270     0.150
     4.126    61.699     0.150
     4.139    63.918     0.150
     4.481    66.777     0.150
     4.815    72.777     0.150
     5.952    88.930     0.150
     5.952   155.277     0.150
     8.335   120.848     0.150
     8.355   122.207     0.150
     9.150   134.609     0.150
     9.417   136.508     0.150
     9.648   139.309     0.150
     9.648   137.750     0.150
    10.797   157.008     0.150
    11.964   168.809     0.150
    12.960   184.109     0.150
    13.330   192.207     0.150
    13.359   187.008     0.150
    13.576   193.238     0.150
    14.094   198.309     0.150
    14.181   200.059     0.150
    14.220   201.508     0.150
    15.196   220.398     0.150
    15.229   218.109     0.150
    15.566   224.910     0.150
    15.708   228.309     0.150
    15.708   227.238     0.150
    16.295   229.609     0.150
    16.295   408.707     0.150
    18.358   253.570     0.150
    18.523   257.809     0.150
    18.656   260.410     0.150
    18.656   258.359     0.150
    19.416   269.008     0.150
    19.416   267.438     0.150
    19.627   266.508     0.150
    19.680   268.008     0.150
    19.857   270.832     0.150
    19.987   277.508     0.150
    20.303   275.910     0.150
    20.460   279.910     0.150
    20.496   280.309     0.150
    20.496   278.297     0.150
    20.664   278.707     0.150
    20.844   282.574     0.150
    20.844   283.207     0.150
    20.977   285.609     0.150
    21.315   288.719     0.150
    21.608   292.309     0.150
    21.965   296.020     0.150
    22.062   296.410     0.150
    22.269   296.629     0.150
    22.515   302.109     0.150
    22.507   298.418     0.150
    22.619   299.309     0.150
    22.732   303.910     0.150
    22.732   303.230     0.150
    23.021   307.309     0.150
    23.032   305.859     0.150
    23.147   308.309     0.150
    23.147   306.250     0.150
    23.168   307.410     0.150
    23.168   305.578     0.150
    23.162   307.809     0.150
    23.162   554.809     0.150
    23.162   562.609     0.150
    23.324   307.570     0.150
    23.420   309.508     0.150
    23.420   308.918     0.150
    23.615   312.809     0.150
    23.644   311.227     0.150
    23.786   313.109     0.150
    23.847   314.207     0.150
    23.851   314.609     0.150
    23.945   312.578     0.150
    24.139   315.059     0.150
    24.265   318.309     0.150
    24.344   315.270     0.150
    24.385   320.910     0.150
    24.470   320.008     0.150
    24.470   319.578     0.150
    24.516   319.109     0.150
    24.965   324.008     0.150
    25.062   327.008     0.150
    25.136   326.309     0.150
    25.128   325.207     0.150
    25.128   586.809     0.150
    25.501   331.609     0.150
    25.528   331.684     0.150
    25.528   328.707     0.150
    25.528   540.707     0.150
    25.528   329.160     0.150
    25.528   540.707     0.150
    25.528   327.508     0.150
    25.647   329.258     0.150
    25.625   330.109     0.150
    25.629   329.648     0.150
    25.629   328.309     0.150
    25.647   329.129     0.150
    25.777   331.105     0.150
    25.777   329.539     0.150
    26.378   339.508     0.150
    26.528   336.309     0.150
    27.714   347.707     0.150
    27.714   346.508     0.150
    27.765   347.195     0.150
    27.765   346.480     0.150
    27.765   347.410     0.150
    27.790   347.180     0.150
    27.847   347.180     0.150
    28.067   350.109     0.150
    28.067   635.207     0.150
    30.877   375.609     0.150
    31.319   379.109     0.150
    31.319   378.168     0.150
    31.324   377.410     0.150
    31.324   377.410     0.150
    31.324   550.840     0.150
    31.324   377.289     0.150
    31.328   377.047     0.150
    31.350   377.430     0.150
    31.394   378.840     0.150
    31.823   386.207     0.150
    32.769   393.609     0.150
    33.923   404.109     0.150
    34.052   403.980     0.150
    34.052   404.109     0.150
    34.052   402.309     0.150
    34.694   407.660     0.150
    34.694   560.988     0.150
    34.694   407.758     0.150
    34.694   560.992     0.150
    34.890   410.055     0.150
    35.026   411.930     0.150
    35.026   411.309     0.150
    35.072   413.309     0.150
    36.422   425.410     0.150
    36.543   424.004     0.150
    37.038   428.160     0.150
    38.181   440.109     0.150
    38.283   440.707     0.150
    38.979   446.910     0.150
    39.332   447.980     0.150
    39.500   447.109     0.150
    39.556   451.707     0.150
    39.886   452.430     0.150
    40.182   456.109     0.150
    40.194   456.207     0.150
    40.360   457.609     0.150
    40.449   458.508     0.150
    40.490   457.207     0.150
    40.539   457.480     0.150
    40.660   461.008     0.150
    40.660   461.008     0.150
    40.660   458.109     0.150
    40.967   462.609     0.150
    41.811   469.609     0.150
    42.921   477.527     0.150
    43.926   485.109     0.150
    43.951   485.027     0.150
    44.805   492.832     0.150
    44.805   491.734     0.150
    44.805   492.207     0.150
    44.897   493.379     0.150
    44.897   496.910     0.150
    44.897   492.438     0.150
    46.101   503.910     0.150
    48.511   522.410     0.150
    50.812   540.609     0.150
    50.937   540.809     0.150
    50.937   541.160     0.150
    50.937   615.699     0.150
    50.937   541.160     0.150
    50.937   615.703     0.150
    50.937   540.297     0.150
    51.126   541.996     0.150
    51.129   542.000     0.150
    51.321   541.297     0.150
    51.730   551.609     0.150
    51.730   991.809     0.150
    51.912   548.410     0.150
    51.968   549.324     0.150
    51.968   548.707     0.150
    52.333   990.707     0.150
    52.333   549.129     0.150
    52.489   998.910     0.150
    52.489   551.828     0.150
    53.886   560.777     0.150
    53.886   561.461     0.150
    53.886   561.199     0.150
    53.889   561.457     0.150
    53.939   564.480     0.150
    53.939   564.828     0.150
    53.939   563.008     0.150
    55.084   571.809     0.150
    55.084   570.328     0.150
    55.571   572.609     0.150
    55.711   574.648     0.150
    56.485   580.148     0.150
    56.839   584.109     0.150
    56.839   583.207     0.150
    56.839   584.070     0.150
    60.742   610.910     0.150
    60.742   610.750     0.150
    61.067   612.480     0.150
    61.896   617.109     0.150
    61.896   616.797     0.150
    64.623   632.707     0.150
    64.855   639.566     0.150
    64.855   637.789     0.150
    65.632   641.828     0.150
    65.632   641.969     0.150
    68.275   658.410     0.150
    68.275   806.207     0.150
    68.275  1200.508     0.150
    68.275  1460.309     0.150
    68.275   657.648     0.150
    75.370   702.410     0.150
    75.376   704.508     0.150
    75.446   701.410     0.150
    75.987   706.410     0.150
    76.859   710.609     0.150
    77.454   714.207     0.150
    78.074   716.980     0.150
    78.990   722.707     0.150
    79.022   900.508     0.150
    79.061   722.410     0.150
    79.162   723.508     0.150
    79.201   723.148     0.150
    79.306   723.617     0.150
    79.516   724.770     0.150
    79.748   725.180     0.150
    80.113   727.008     0.150
    80.162   727.309     0.150
    80.444   731.309     0.150
    80.455   728.309     0.150
    80.569   730.320     0.150
    80.847   731.988     0.150
    80.953   731.660     0.150
    80.956   731.207     0.150
    80.956   732.359     0.150
    80.956   730.879     0.150
    81.930   737.168     0.150
    82.285   738.699     0.150
    83.063   742.488     0.150
    83.214   744.230     0.150
    83.410   743.828     0.150
    83.782   747.957     0.150
    83.782   747.961     0.150
    83.915   749.410     0.150
    83.916   746.809     0.150
    83.916   749.410     0.150
    83.916   747.059     0.150
    83.908   747.828     0.150
    84.541   754.410     0.150
    84.814   752.328     0.150
    84.912   752.117     0.150
    85.135   753.508     0.150
    85.135   753.484     0.150
    85.364   755.008     0.150
    85.364   754.508     0.150
    85.364   754.770     0.150
    85.364   753.707     0.150
    85.645   756.410     0.150
    85.774   757.199     0.150
    86.737   765.320     0.150
    87.065   762.148     0.150
    88.547   770.230     0.150
    92.085   787.027     0.150
    92.085   787.031     0.150
    93.966   798.062     0.150
    95.199   801.805     0.150
    95.199   801.797     0.150
    95.537   805.195     0.150
   118.126  1125.758     0.150
   118.126  1197.285     0.150
   118.127  1125.758     0.150
   118.127  1197.277     0.150
   125.500   935.109     0.150
   126.287  1141.609     0.150
   146.672  1180.785     0.150
   146.672  1179.910     0.150
   147.364  1182.469     0.150
     0.504     9.191     0.150
     0.504    16.980     0.150
     0.768    14.539     0.150
     0.768    26.441     0.150
     1.017    19.281     0.150
     1.017    36.492     0.150
     1.290    22.609     0.150
     1.290    43.520     0.150
     1.555    27.730     0.150
     1.555    50.250     0.150
     1.700    30.449     0.150
     1.713    29.859     0.150
     1.713    53.172     0.150
     2.115    35.320     0.150
     2.115    64.730     0.150
     2.190    36.859     0.150
     2.966    48.410     0.150
     2.966    91.090     0.150
     3.056    55.172     0.150
     3.056    97.281     0.150
     3.099    47.672     0.150
     3.099    92.598     0.150
     3.256    52.473     0.150
     3.323    55.129     0.150
     3.945    62.090     0.150
     4.949    77.602     0.150
     8.706   128.660     0.150
     9.564   136.441     0.150
    13.933   201.512     0.150
    14.200   210.570     0.150
    15.389   220.520     0.150
    19.001   265.191     0.150
    19.920   272.301     0.150
    23.344   312.152     0.150
    23.712   313.660     0.150
    25.861   334.699     0.150
    25.861   332.520     0.150
    26.032   334.859     0.150
    27.799   348.000     0.150
    31.247   378.391     0.150
    31.252   377.980     0.150
    31.252   377.977     0.150
    31.252   554.547     0.150
    31.252   378.930     0.150
    31.256   378.680     0.150
    31.499   381.250     0.150
    34.641   407.910     0.150
    34.642   408.684     0.150
    40.725   462.660     0.150
    40.725   462.656     0.150
    51.116   544.160     0.150
    51.116   543.852     0.150
    51.116   619.641     0.150
    51.116   543.852     0.150
    51.116   543.602     0.150
    52.249   552.410     0.150
    54.013   564.281     0.150
    54.013   563.027     0.150
    54.013   564.840     0.150
    54.016   563.020     0.150
    55.247   574.723     0.150
    55.964   580.129     0.150
    57.068   587.750     0.150
    57.068   588.082     0.150
    60.908   614.082     0.150
    80.738   732.781     0.150
    84.177   753.879     0.150
    84.177   753.879     0.150
    85.564   757.875     0.150
   146.593  1179.875     0.150
     0.502     9.672     0.150
     0.502    17.250     0.150
     0.809    16.020     0.150
     0.992    18.379     0.150
     0.992    34.109     0.150
     1.410    25.320     0.150
     1.410    46.781     0.150
     1.525    26.781     0.150
     1.525    47.379     0.150
     1.707    30.102     0.150
     1.707    51.789     0.150
     1.891    32.262     0.150
     2.022    33.961     0.150
     2.022    60.340     0.150
     2.075    35.449     0.150
     2.328    38.430     0.150
     3.020    48.082     0.150
     3.134    51.910     0.150
    21.470   292.121     0.150
    25.658   331.262     0.150
    25.658   330.699     0.150
    25.804   331.484     0.150
    25.803   330.691     0.150
    27.739   348.746     0.150
    27.796   348.738     0.150
    31.299   377.129     0.150
    31.304   378.281     0.150
    31.304   378.273     0.150
    31.304   376.961     0.150
    34.682   561.762     0.150
    34.683   408.559     0.150
    34.683   561.762     0.150
    51.000   542.012     0.150
    51.000   542.012     0.150
    51.000   541.641     0.150
    53.928   562.215     0.150
    53.928   561.102     0.150
    53.931   562.219     0.150
    55.141   571.082     0.150
    55.806   575.820     0.150
    63.892   631.535     0.150
     0.437     7.848     0.150
     0.437    14.750     0.150
     0.654    11.668     0.150
     0.654    22.559     0.150
     1.153    21.129     0.150
     1.153    38.629     0.150
     1.145    22.457     0.150
     1.145    39.527     0.150
     1.414    25.801     0.150
     1.414    45.660     0.150
     1.695    30.090     0.150
     1.737    29.859     0.150
     1.737    54.699     0.150
     2.226    37.988     0.150
     2.226    70.699     0.150
     2.252    36.949     0.150
     2.252    69.980     0.150
     2.575    41.520     0.150
     3.052    50.539     0.150
     3.052    90.820     0.150
     3.126    56.668     0.150
     3.126    98.777     0.150
     3.167    52.625     0.150
     3.167    52.859     0.150
     3.220    52.410     0.150
     3.272    51.469     0.150
     3.272    90.289     0.150
     3.430    56.059     0.150
     3.930    64.508     0.150
     4.892    75.957     0.150
     8.828   129.648     0.150
     9.646   140.039     0.150
    11.020   161.688     0.150
    14.061   211.891     0.150
    19.041   268.480     0.150
    19.041   265.500     0.150
    19.164   264.418     0.150
    20.038   273.578     0.150
    21.222   285.629     0.150
    23.551   313.379     0.150
    23.551   312.559     0.150
    25.314   332.180     0.150
    25.893   333.438     0.150
    25.893   333.496     0.150
    25.893   333.059     0.150
    31.336   378.277     0.150
    31.336   378.277     0.150
    31.336   379.090     0.150
    34.775   408.879     0.150
    34.731   409.488     0.150
    34.732   409.379     0.150
    34.732   409.527     0.150
    34.992   414.207     0.150
    40.640   458.551     0.150
    40.668   460.559     0.150
    44.796   494.805     0.150
    51.070   543.820     0.150
    51.070   544.578     0.150
    51.070   544.578     0.150
    51.070   543.539     0.150
    51.260   545.688     0.150
    52.248   551.820     0.150
    53.947   564.445     0.150
    53.947   564.578     0.150
    53.950   564.438     0.150
    55.195   574.070     0.150
    55.196   573.555     0.150
    57.042   587.078     0.150
    57.042   587.039     0.150
    57.575   589.867     0.150
    60.785   612.617     0.150
    60.785   612.617     0.150
    60.857   613.238     0.150
    65.800   646.070     0.150
     0.383     7.199     0.150
     0.383    13.449     0.150
     0.443     8.340     0.150
     0.443    15.547     0.150
     0.676    12.891     0.150
     0.676    23.258     0.150
     1.142    21.488     0.150
     1.142    38.359     0.150
     1.125    20.238     0.150
     1.125    37.230     0.150
     1.396    25.207     0.150
     1.396    45.297     0.150
     1.691    29.547     0.150
     1.691    52.680     0.150
     1.747    30.148     0.150
     1.747    53.891     0.150
     2.011    34.070     0.150
     2.011    62.750     0.150
     2.100    35.230     0.150
     2.277    38.070     0.150
     2.277    68.527     0.150
     2.280    37.277     0.150
     2.280    66.629     0.150
     2.539    43.027     0.150
     3.103    49.988     0.150
    31.387   378.918     0.150
    34.782   409.367     0.150
    51.016   542.289     0.150
    55.143   572.020     0.150
    60.731   611.180     0.150
   118.453  1127.613     0.150
     0.358     6.461     0.150
     0.358    12.168     0.150
     0.423     8.199     0.150
     0.423    15.391     0.150
     0.710    13.418     0.150
     0.710    24.590     0.150
     1.116    20.898     0.150
     1.116    37.758     0.150
     1.132    37.988     0.150
     1.411    25.180     0.150
     1.411    45.801     0.150
     1.655    28.738     0.150
     1.655    51.820     0.150
     1.780    30.359     0.150
     1.780    54.711     0.150
     2.028    34.258     0.150
     2.028    63.527     0.150
     2.071    34.910     0.150
     2.275    37.871     0.150
     2.275    68.988     0.150
     2.298    38.469     0.150
     2.298    71.391     0.150
     2.539    41.938     0.150
     2.539    81.348     0.150
     3.120    49.719     0.150
     3.138    52.008     0.150
     3.193    50.289     0.150
     3.242    54.895     0.150
     3.486    59.258     0.150
     3.680    58.699     0.150
     3.680   116.371     0.150
     3.846    62.109     0.150
     4.218    65.328     0.150
    12.918   183.074     0.150
    20.085   275.324     0.150
    23.470   310.098     0.150
    23.579   309.559     0.150
    23.751   311.621     0.150
    25.811   330.699     0.150
    25.811   332.648     0.150
    25.811   330.789     0.150
    26.086   335.973     0.150
    27.821   350.008     0.150
    27.963   349.930     0.150
    31.400   379.148     0.150
    31.405   380.051     0.150
    31.405   380.051     0.150
    31.405   379.777     0.150
    31.409   380.141     0.150
    33.930   402.949     0.150
    34.798   410.348     0.150
    40.572   462.379     0.150
    40.572   462.383     0.150
    44.066   487.121     0.150
    44.867   493.875     0.150
    44.867   494.020     0.150
    50.989   543.090     0.150
    50.989   542.348     0.150
    50.989   542.348     0.150
    50.989   542.809     0.150
    51.179   544.371     0.150
    52.164   550.500     0.150
    53.872   563.055     0.150
    53.874   563.051     0.150
    55.116   572.277     0.150
    55.117   573.750     0.150
    55.866   577.621     0.150
    56.959   586.438     0.150
    68.304   660.969     0.150
    79.491   728.270     0.150
    84.082   751.438     0.150
    84.082   751.438     0.150
    85.129   756.371     0.150
    85.129   756.375     0.150
   118.418  1129.004     0.150
   118.418  1129.008     0.150
     0.292     6.082     0.150
     0.292    10.172     0.150
     0.432     8.125     0.150
     0.432    14.824     0.150
     0.808    14.984     0.150
     0.808    27.125     0.150
     0.992    19.062     0.150
     0.992    35.234     0.150
     1.263    22.465     0.150
     1.263    42.273     0.150
     1.544    27.652     0.150
     1.544    48.445     0.150
     1.632    27.402     0.150
     1.632    50.895     0.150
     1.782    29.902     0.150
     1.782    55.434     0.150
     2.146    35.672     0.150
     2.146    63.164     0.150
     2.108    35.383     0.150
     2.161    36.262     0.150
     2.229    37.445     0.150
     2.229    66.445     0.150
     2.662    42.523     0.150
     3.039    49.824     0.150
     3.039    85.055     0.150
     3.133    56.344     0.150
     3.133    97.895     0.150
     3.177    53.004     0.150
     3.177    92.004     0.150
     3.153    49.613     0.150
     3.173    51.195     0.150
     3.386    53.285     0.150
     3.547    55.383     0.150
     3.547   110.844     0.150
     3.861    60.902     0.150
     4.292    65.633     0.150
     4.870    72.262     0.150
     6.335   122.133     0.150
     8.673   126.785     0.150
     9.637   137.582     0.150
    11.006   161.832     0.150
    13.391   190.035     0.150
    13.536   196.434     0.150
    14.421   207.535     0.150
    14.395   208.805     0.150
    14.916   210.465     0.150
    15.111   218.234     0.150
    15.424   222.176     0.150
    15.424   224.633     0.150
    15.424   220.582     0.150
    18.673   260.535     0.150
    18.924   262.715     0.150
    19.162   264.332     0.150
    19.522   270.035     0.150
    19.522   269.023     0.150
    19.922   273.734     0.150
    19.974   273.484     0.150
    19.974   273.234     0.150
    20.269   277.133     0.150
    20.648   279.434     0.150
    20.627   280.535     0.150
    20.747   282.332     0.150
    21.258   289.633     0.150
    21.655   291.383     0.150
    22.250   299.105     0.150
    22.812   303.734     0.150
    23.338   310.109     0.150
    23.338   309.934     0.150
    23.435   309.605     0.150
    23.484   310.562     0.150
    23.653   310.262     0.150
    23.659   312.215     0.150
    23.722   311.695     0.150
    23.951   315.523     0.150
    24.144   319.133     0.150
    24.416   319.945     0.150
    24.663   325.332     0.150
    24.810   322.734     0.150
    24.810   321.914     0.150
    25.209   330.535     0.150
    25.828   328.863     0.150
    25.783   329.223     0.150
    25.783   331.734     0.150
    25.783   330.934     0.150
    25.783   329.172     0.150
    25.841   333.234     0.150
    25.986   332.332     0.150
    25.985   331.734     0.150
    27.279   343.762     0.150
    27.640   347.734     0.150
    27.763   349.434     0.150
    27.857   348.535     0.150
    27.857   347.625     0.150
    30.343   370.684     0.150
    31.319   378.332     0.150
    31.325   378.312     0.150
    31.325   552.785     0.150
    31.325   378.309     0.150
    31.325   552.785     0.150
    31.329   378.242     0.150
    34.267   406.934     0.150
    34.712   561.785     0.150
    34.712   408.953     0.150
    34.713   408.785     0.150
    34.713   561.785     0.150
    34.859   411.133     0.150
    34.859   411.445     0.150
    36.498   427.434     0.150
    36.510   426.332     0.150
    39.412   450.535     0.150
    39.730   451.934     0.150
    39.730   577.707     0.150
    40.620   458.723     0.150
    40.653   460.434     0.150
    40.653   580.715     0.150
    40.653   460.434     0.150
    40.653   580.715     0.150
    40.653   459.434     0.150
    43.826   484.855     0.150
    43.798   484.734     0.150
    43.978   486.383     0.150
    44.792   493.609     0.150
    44.792   493.133     0.150
    51.034   542.332     0.150
    51.034   542.383     0.150
    51.034   542.383     0.150
    51.034   542.133     0.150
    51.224   543.332     0.150
    52.051   548.934     0.150
    52.202   549.145     0.150
    52.304   551.094     0.150
    52.584   552.633     0.150
    53.935   562.559     0.150
    53.935   561.152     0.150
    53.938   562.562     0.150
    54.661   568.535     0.150
    55.167   571.934     0.150
    55.769   576.535     0.150
    55.881   577.273     0.150
    56.984   584.934     0.150
    56.984   584.652     0.150
    60.827   612.445     0.150
    63.854   631.434     0.150
    64.425   636.934     0.150
    65.042   640.625     0.150
    65.042   640.113     0.150
    65.754   643.504     0.150
    65.754   643.172     0.150
    67.366   654.734     0.150
    68.355   659.832     0.150
    68.355   684.535     0.150
    68.355   659.293     0.150
    75.702   703.633     0.150
    75.863   704.832     0.150
    77.018   712.434     0.150
    79.179   723.832     0.150
    80.539   734.035     0.150
    80.539   916.332     0.150
    80.716   733.832     0.150
    81.456   737.945     0.150
    83.131   746.035     0.150
    83.653   748.785     0.150
    83.789   748.383     0.150
    83.789   748.383     0.150
    84.093   748.992     0.150
    84.094   748.992     0.150
    85.190   755.535     0.150
    85.190   755.508     0.150
    85.481   755.609     0.150
    85.481   755.844     0.150
    85.520   757.922     0.150
    87.061   765.609     0.150
    87.061   767.035     0.150
    88.614   770.172     0.150
    95.649   805.434     0.150
    95.649   805.434     0.150
   118.387  1126.859     0.150
   118.388  1126.863     0.150
   119.694  1129.832     0.150
   119.694  1129.832     0.150
   146.667  1181.184     0.150
   146.667  1180.434     0.150
   159.760  1199.301     0.150
   166.524  1205.559     0.150
   166.524  1269.809     0.150
     0.335     6.344     0.150
     0.335    11.844     0.150
     0.450     8.805     0.150
     0.450    15.195     0.150
     0.698    12.984     0.150
     0.698    24.125     0.150
     1.101    19.555     0.150
     1.101    36.832     0.150
     1.140    21.184     0.150
     1.140    39.055     0.150
     1.382    25.523     0.150
     1.382    45.465     0.150
     1.650    28.555     0.150
     1.650    52.293     0.150
     1.793    30.832     0.150
     1.793    55.984     0.150
     2.000    34.484     0.150
     2.000    60.684     0.150
     2.053    34.863     0.150
     2.324    37.992     0.150
     2.306    38.332     0.150
     2.306    68.043     0.150
     2.507    40.422     0.150
     2.507    71.145     0.150
     3.147    50.293     0.150
     3.119    50.535     0.150
     3.119    90.375     0.150
     3.225    56.805     0.150
     3.225    97.254     0.150
     3.191    49.754     0.150
     3.191    91.332     0.150
     3.267    57.043     0.150
     3.267    58.656     0.150
     3.267    54.352     0.150
     3.516    54.492     0.150
     3.709    58.715     0.150
     3.832    60.113     0.150
     4.192    63.723     0.150
     4.192   114.453     0.150
     4.791    74.875     0.150
     8.807   127.844     0.150
     9.743   139.363     0.150
    11.092   159.902     0.150
    12.941   183.348     0.150
    13.559   195.914     0.150
    13.613   193.102     0.150
    14.051   201.574     0.150
    18.957   264.875     0.150
    18.957   261.492     0.150
    19.663   273.574     0.150
    20.117   275.422     0.150
    22.042   293.344     0.150
    22.355   301.074     0.150
    22.450   303.074     0.150
    23.466   313.473     0.150
    23.466   309.043     0.150
    23.592   311.484     0.150
    23.764   311.375     0.150
    23.762   313.492     0.150
    23.880   317.223     0.150
    24.703   325.574     0.150
    24.936   324.344     0.150
    25.372   332.875     0.150
    25.805   332.422     0.150
    25.805   330.902     0.150
    25.952   333.422     0.150
    26.100   334.898     0.150
    26.099   334.152     0.150
    27.491   348.277     0.150
    27.548   348.102     0.150
    27.994   349.504     0.150
    28.123   352.273     0.150
    29.298   359.652     0.150
    31.427   380.164     0.150
    31.432   380.188     0.150
    31.432   380.594     0.150
    31.436   380.352     0.150
    31.820   387.574     0.150
    32.649   395.074     0.150
    33.656   403.773     0.150
    34.264   406.184     0.150
    34.706   411.875     0.150
    34.706   411.703     0.150
    34.825   410.695     0.150
    34.826   410.723     0.150
    34.826   410.012     0.150
    36.422   427.172     0.150
    40.544   461.414     0.150
    40.544   460.414     0.150
    40.753   460.754     0.150
    44.094   488.234     0.150
    46.136   505.875     0.150
    50.968   541.895     0.150
    50.968   542.625     0.150
    50.968   542.422     0.150
    51.852   551.273     0.150
    52.056   551.242     0.150
    52.151   550.742     0.150
    53.847   562.094     0.150
    53.847   562.297     0.150
    53.847   562.074     0.150
    54.035   566.070     0.150
    54.035   564.395     0.150
    54.622   568.062     0.150
    55.094   570.973     0.150
    55.095   572.047     0.150
    55.754   577.062     0.150
    55.782   577.645     0.150
    55.851   577.723     0.150
    56.941   584.203     0.150
    56.941   585.012     0.150
    60.684   611.410     0.150
    60.756   611.312     0.150
    65.022   639.043     0.150
    65.699   644.195     0.150
    68.281   660.191     0.150
    68.281   660.332     0.150
    85.104   757.723     0.150
    87.146   768.250     0.150
   146.770  1184.398     0.150
     0.420     8.090     0.150
     0.420    14.660     0.150
     0.437     8.020     0.150
     0.437    15.031     0.150
     0.674    12.352     0.150
     0.674    23.172     0.150
     1.125    21.641     0.150
     1.125    37.762     0.150
     1.170    38.961     0.150
     1.433    26.172     0.150
     1.433    46.219     0.150
     1.703    29.410     0.150
     1.703    53.520     0.150
     1.726    29.461     0.150
     1.726    54.070     0.150
     2.045    35.590     0.150
     2.045    63.891     0.150
     2.151    36.289     0.150
     2.235    37.602     0.150
     2.235    67.469     0.150
     2.221    37.180     0.150
     2.221    67.371     0.150
     2.590    86.301     0.150
     3.046    48.039     0.150
     3.046   100.551     0.150
    31.331   380.102     0.150
    34.725   409.270     0.150
     0.191     4.141     0.150
     0.191     6.891     0.150
     0.549    10.742     0.150
     0.549    18.977     0.150
     0.688    12.984     0.150
     0.688    23.484     0.150
     1.253    23.297     0.150
     1.253    41.992     0.150
     1.412    24.633     0.150
     1.412    44.336     0.150
     1.639    28.273     0.150
     1.852    32.930     0.150
     1.852    55.656     0.150
     1.952    33.281     0.150
     1.952    59.453     0.150
     2.056    35.312     0.150
     2.056    62.820     0.150
     2.068    35.250     0.150
     2.266    36.500     0.150
     2.266    72.625     0.150
     2.575    41.141     0.150
    25.490   330.133     0.150
    34.629   407.000     0.150
    34.629   561.391     0.150
    40.722   460.656     0.150
    50.965   542.031     0.150
    53.932   562.523     0.150
    83.912   749.195     0.150
   146.613  1179.680     0.150
     0.255     5.453     0.150
     0.255     8.312     0.150
     0.425     8.125     0.150
     0.425    14.406     0.150
     0.858    15.977     0.150
     0.858    29.273     0.150
     0.949    18.477     0.150
     0.949    32.461     0.150
     1.288    23.422     0.150
     1.288    42.094     0.150
     1.576    27.953     0.150
     1.576    49.484     0.150
     1.588    27.117     0.150
     1.588    49.656     0.150
     1.825    30.758     0.150
     1.825    56.617     0.150
     2.079    35.227     0.150
     2.128    35.641     0.150
     2.128    65.117     0.150
     2.195    36.703     0.150
     2.249    36.961     0.150
     2.249    67.188     0.150
     2.676    76.234     0.150
     3.143    50.805     0.150
     3.199    92.234     0.150
     3.825    60.484     0.150
     4.846    77.352     0.150
    19.970   273.062     0.150
    25.736   329.961     0.150
    31.339   378.820     0.150
    31.339   552.664     0.150
    34.724   408.719     0.150
    34.724   561.992     0.150
    51.007   541.859     0.150
   118.340  1126.578     0.150
     0.338     6.320     0.150
     0.338    11.766     0.150
     0.463    16.047     0.150
     0.684    23.391     0.150
     1.090    37.539     0.150
     1.154    22.352     0.150
     1.154    39.109     0.150
     1.369    24.789     0.150
     1.369    44.961     0.150
     1.786    30.016     0.150
     1.786    57.789     0.150
     1.660    52.492     0.150
     1.987    34.617     0.150
     1.987    59.766     0.150
     2.057    35.008     0.150
     2.324    39.383     0.150
     2.324    71.258     0.150
     2.316    68.656     0.150
     2.499    40.578     0.150
     2.499    72.531     0.150
     3.149    51.281     0.150
     3.123    50.383     0.150
     3.225    55.156     0.150
     3.225    97.539     0.150
     3.266    53.656     0.150
     3.266    87.695     0.150
     3.266    53.422     0.150
     3.266    54.781     0.150
     3.202    50.836     0.150
     3.521    55.438     0.150
     3.521   100.898     0.150
     3.722    59.781     0.150
     3.722   109.180     0.150
     3.838    61.961     0.150
     4.793    74.680     0.150
     8.822   130.828     0.150
     9.744   138.719     0.150
    11.100   162.430     0.150
    18.655   259.391     0.150
    18.968   260.789     0.150
    19.668   271.141     0.150
    20.123   275.688     0.150
    23.477   310.656     0.150
    23.606   311.547     0.150
    23.776   313.562     0.150
    25.815   332.852     0.150
    25.956   331.531     0.150
    25.911   333.398     0.150
    26.113   335.320     0.150
    27.106   344.727     0.150
    27.477   345.258     0.150
    27.999   349.391     0.150
    27.999   349.797     0.150
    31.434   380.125     0.150
    31.434   554.648     0.150
    31.434   380.289     0.150
    31.434   380.117     0.150
    31.434   554.648     0.150
    31.438   379.961     0.150
    34.272   407.242     0.150
    34.827   410.391     0.150
    34.828   409.914     0.150
    34.828   562.375     0.150
    50.971   543.109     0.150
    50.971   542.938     0.150
    50.971   542.938     0.150
    50.971   543.219     0.150
    55.097   573.453     0.150
   118.423  1127.945     0.150
   118.424  1127.938     0.150
     0.163     3.680     0.150
     0.572    10.828     0.150
     0.572    19.227     0.150
     0.675    12.766     0.150
     0.675    23.266     0.150
     1.227    22.680     0.150
     1.227    41.438     0.150
     1.432    25.117     0.150
     1.432    44.930     0.150
     1.622    28.422     0.150
     1.858    30.656     0.150
     1.858    55.680     0.150
     1.932    32.883     0.150
     2.031    35.867     0.150
     2.079    35.391     0.150
     2.251    40.617     0.150
     2.876    45.531     0.150
     2.957    54.242     0.150
     3.122    50.570     0.150
     3.203    85.836     0.150
     3.203    52.000     0.150
     3.262    55.156     0.150
     3.738    59.516     0.150
     4.874    75.516     0.150
     8.250   120.883     0.150
     8.250   212.922     0.150
     9.584   138.992     0.150
    10.703   156.266     0.150
    13.485   191.711     0.150
    18.636   258.789     0.150
    19.767   269.992     0.150
    23.078   304.539     0.150
    23.259   307.602     0.150
    23.320   307.281     0.150
    25.515   328.758     0.150
    25.515   328.203     0.150
    25.515   328.992     0.150
    25.575   328.297     0.150
    25.699   329.641     0.150
    27.679   345.336     0.150
    27.679   346.172     0.150
    27.771   348.258     0.150
    31.256   376.719     0.150
    31.256   551.719     0.150
    31.256   376.719     0.150
    31.256   551.719     0.150
    31.256   378.430     0.150
    31.260   378.836     0.150
    34.055   404.633     0.150
    34.622   406.859     0.150
    34.623   407.148     0.150
    34.623   561.055     0.150
    34.623   407.352     0.150
    40.729   461.000     0.150
    40.729   461.000     0.150
    44.741   490.289     0.150
    44.741   491.133     0.150
    50.979   542.008     0.150
    50.979   541.633     0.150
    50.979   616.781     0.150
    50.979   541.625     0.150
    50.979   616.781     0.150
    50.979   541.328     0.150
    51.168   543.516     0.150
    51.978   548.820     0.150
    53.943   561.867     0.150
    53.943   562.438     0.150
    53.945   561.867     0.150
    55.130   571.836     0.150
    55.581   575.359     0.150
    55.730   576.336     0.150
    56.867   583.758     0.150
    56.867   584.172     0.150
    56.867   583.898     0.150
    60.788   610.898     0.150
    64.868   638.383     0.150
    64.868   638.562     0.150
    65.668   642.789     0.150
    65.668   643.336     0.150
    68.323   658.711     0.150
    79.304   724.383     0.150
    81.059   732.773     0.150
    81.787   738.648     0.150
    83.932   748.609     0.150
    83.932   749.062     0.150
    83.932   748.609     0.150
    85.401   755.578     0.150
    85.747   758.461     0.150
    85.747   758.602     0.150
   146.605  1180.766     0.150
   146.605  1181.062     0.150
     0.341     6.383     0.150
     0.341    12.227     0.150
     0.464     8.555     0.150
     0.464    15.914     0.150
     0.682    12.703     0.150
     0.682    23.844     0.150
     1.091    19.516     0.150
     1.091    37.016     0.150
     1.155    21.633     0.150
     1.155    38.648     0.150
     1.369    24.828     0.150
     1.369    45.164     0.150
     1.663    28.086     0.150
     1.663    50.617     0.150
     1.782    30.836     0.150
     1.782    55.203     0.150
     1.987    33.594     0.150
     1.987    57.445     0.150
     2.061    34.945     0.150
     2.321    38.578     0.150
     2.321    69.031     0.150
     2.315    38.625     0.150
     2.315    68.297     0.150
     2.500    40.383     0.150
     2.500    78.086     0.150
     3.146    52.336     0.150
     3.146    99.742     0.150
     3.127    51.281     0.150
     3.518    60.211     0.150
     3.842    61.844     0.150
     4.796    76.844     0.150
     9.741   139.562     0.150
    13.050   183.492     0.150
    20.121   275.008     0.150
    31.431   380.656     0.150
    31.431   380.656     0.150
    31.435   382.312     0.150
    34.275   408.883     0.150
    34.825   411.125     0.150
    34.826   409.906     0.150
    34.826   411.125     0.150
    50.975   543.117     0.150
    50.975   542.672     0.150
    50.975   542.680     0.150
    50.975   542.578     0.150
    51.165   544.414     0.150
    52.162   552.414     0.150
    55.100   572.438     0.150
    55.101   572.453     0.150
    68.287   661.875     0.150
    68.287   661.078     0.150
     0.322     6.523     0.150
     0.322    11.898     0.150
     0.470     8.914     0.150
     0.470    16.242     0.150
     0.690    23.430     0.150
     1.080    36.750     0.150
     1.157    22.078     0.150
     1.157    38.148     0.150
     1.362    25.281     0.150
     1.648    28.250     0.150
     1.648    52.188     0.150
     1.980    34.172     0.150
     2.042    35.039     0.150
     2.327    37.992     0.150
     2.327    68.570     0.150
     2.340    38.320     0.150
     2.340    73.023     0.150
     2.487    73.805     0.150
     3.108    51.914     0.150
     3.165    51.875     0.150
     3.165   104.891     0.150
     3.282    55.078     0.150
     3.282   106.930     0.150
     3.282    56.461     0.150
     3.823    64.234     0.150
     3.823    67.602     0.150
     3.823   111.570     0.150
    31.444   381.422     0.150
    31.450   381.680     0.150
    31.450   381.680     0.150
    34.843   411.703     0.150
    34.844   410.883     0.150
    34.844   411.305     0.150
    50.955   542.383     0.150
    50.955   542.352     0.150
    50.955   542.359     0.150
    50.955   542.000     0.150
    55.080   571.633     0.150
     0.351     6.633     0.150
     0.351    12.539     0.150
     0.398     7.273     0.150
     0.398    13.820     0.150
     0.761    14.164     0.150
     0.761    26.492     0.150
     1.049    20.133     0.150
     1.049    37.172     0.150
     1.205    22.016     0.150
     1.205    41.406     0.150
     1.484    26.656     0.150
     1.484    48.781     0.150
     1.777    32.352     0.150
     1.777    52.953     0.150
     1.644    28.000     0.150
     1.644    51.016     0.150
     2.256    37.883     0.150
     2.256    68.914     0.150
     2.203    38.500     0.150
     2.203    67.781     0.150
     2.101    35.414     0.150
     2.101    64.805     0.150
     2.094    35.375     0.150
     2.608    44.000     0.150
     2.608    73.461     0.150
     3.072    50.664     0.150
     3.203    48.180     0.150
     3.203    94.406     0.150
     3.160    50.789     0.150
     3.160    89.406     0.150
     4.847    85.766     0.150
    18.944   262.789     0.150
    23.702   313.906     0.150
    25.798   335.031     0.150
    27.738   349.172     0.150
    34.748   410.281     0.150
    51.017   542.781     0.150
    51.017   542.781     0.150
    51.017   541.594     0.150
    53.910   563.805     0.150
    53.912   563.805     0.150
    55.147   572.305     0.150
    56.976   585.492     0.150
    65.741   644.250     0.150
    83.757   749.234     0.150
    83.757   749.234     0.150
   118.404  1127.062     0.150
   118.405  1127.062     0.150
     0.387     7.609     0.150
     0.387    13.531     0.150
     0.397     7.422     0.150
     0.397    13.750     0.150
     0.723    13.555     0.150
     0.723    24.242     0.150
     1.087    20.852     0.150
     1.087    36.797     0.150
     1.176    21.859     0.150
     1.176    39.953     0.150
     1.451    26.391     0.150
     1.451    45.852     0.150
     1.757    29.992     0.150
     1.757    54.773     0.150
     1.670    29.445     0.150
     1.670    51.375     0.150
     2.067    34.922     0.150
     2.104    35.320     0.150
     2.230    36.797     0.150
     2.230    66.586     0.150
     3.077    50.484     0.150
     3.202    47.602     0.150
     3.202    86.852     0.150
     3.170    51.680     0.150
     3.873    60.031     0.150
    31.363   377.750     0.150
    31.362   377.750     0.150
    34.295   407.227     0.150
    34.754   408.055     0.150
    34.755   408.055     0.150
    51.025   541.727     0.150
    51.025   542.055     0.150
    51.025   542.055     0.150
    51.025   541.727     0.150
    52.187   551.477     0.150
    53.911   561.516     0.150
    53.914   561.516     0.150
    55.153   571.602     0.150
    56.989   585.383     0.150
    56.989   585.695     0.150
    60.814   611.812     0.150
    63.809   630.000     0.150
   118.431  1126.875     0.150
   118.432  1126.883     0.150
     0.150     3.583     0.150
     0.150     6.534     0.150
     0.481     9.194     0.150
     0.481    16.694     0.150
     0.816    16.024     0.150
     0.816    27.124     0.150
     0.993    18.324     0.150
     0.993    33.294     0.150
     1.395    24.664     0.150
     1.395    45.454     0.150
     1.506    26.444     0.150
     1.506    47.063     0.150
     1.584    27.294     0.150
     1.584    45.744     0.150
     1.695    29.934     0.150
     1.695    51.984     0.150
     1.909    58.354     0.150
     2.041    32.764     0.150
     2.041    59.654     0.150
     2.051    34.804     0.150
     2.262    36.504     0.150
     2.262    66.984     0.150
     2.623    43.083     0.150
     3.111    49.313     0.150
    31.328   378.206     0.150
    34.707   408.903     0.150
    50.977   542.274     0.150
     0.209     4.296     0.150
     0.209     8.446     0.150
     0.547    10.486     0.150
     0.547    19.016     0.150
     0.680    12.496     0.150
     0.680    23.196     0.150
     1.157    21.286     0.150
     1.157    36.136     0.150
     1.263    22.926     0.150
     1.263    42.576     0.150
     1.387    24.316     0.150
     1.387    43.816     0.150
     1.617    26.206     0.150
     1.634    28.456     0.150
     1.868    30.076     0.150
     1.868    58.656     0.150
     2.044    34.646     0.150
     2.079    35.016     0.150
     2.186    36.276     0.150
     2.186    64.966     0.150
     2.541    40.646     0.150
     2.541    71.606     0.150
     2.574    42.306     0.150
     2.828    44.996     0.150
     2.828    79.426     0.150
     2.956    46.596     0.150
     2.956    96.326     0.150
     3.084    49.276     0.150
     3.242    53.170     0.150
     3.242    54.074     0.150
     3.242    49.586     0.150
     3.289    50.096     0.150
     3.289    90.536     0.150
     3.695    57.096     0.150
     3.717    60.646     0.150
     3.895    58.816     0.150
     4.086    62.086     0.150
     4.086   109.816     0.150
     4.122    63.066     0.150
     4.126    60.516     0.150
     4.414    66.026     0.150
     4.839    74.606     0.150
     8.216   118.326     0.150
     8.216   210.306     0.150
     9.327   137.426     0.150
     9.617   136.226     0.150
    10.736   157.826     0.150
    11.910   168.526     0.150
    12.805   178.816     0.150
    13.232   192.026     0.150
    13.313   187.526     0.150
    13.455   192.426     0.150
    13.455   189.306     0.150
    13.994   197.726     0.150
    15.132   220.668     0.150
    15.132   211.326     0.150
    15.190   219.526     0.150
    15.190   212.336     0.150
    15.449   222.926     0.150
    15.445   220.826     0.150
    15.587   217.896     0.150
    15.897   227.226     0.150
    16.260   234.226     0.150
    16.260   419.826     0.150
    18.277   251.796     0.150
    18.440   256.326     0.150
    18.588   255.036     0.150
    18.975   261.526     0.150
    19.154   261.926     0.150
    19.154   261.576     0.150
    19.345   265.126     0.150
    19.345   263.616     0.150
    19.525   267.126     0.150
    19.572   269.526     0.150
    19.784   270.093     0.150
    19.784   270.426     0.150
    19.913   274.226     0.150
    19.928   279.626     0.150
    20.181   276.326     0.150
    20.259   278.026     0.150
    20.386   278.726     0.150
    20.386   274.356     0.150
    20.495   282.126     0.150
    20.861   285.726     0.150
    20.882   282.136     0.150
    20.882   285.326     0.150
    21.200   286.926     0.150
    21.199   288.426     0.150
    21.199   284.676     0.150
    21.220   288.726     0.150
    21.220   283.786     0.150
    21.694   293.026     0.150
    21.848   290.696     0.150
    21.910   297.526     0.150
    22.396   301.226     0.150
    22.470   303.226     0.150
    22.470   543.326     0.150
    22.611   304.926     0.150
    22.673   301.226     0.150
    22.911   305.588     0.150
    22.911   307.626     0.150
    22.918   308.026     0.150
    23.037   303.266     0.150
    23.101   307.826     0.150
    23.101   305.696     0.150
    23.152   338.826     0.150
    23.301   309.826     0.150
    23.494   312.226     0.150
    23.764   315.526     0.150
    24.144   317.726     0.150
    24.312   320.126     0.150
    24.356   318.626     0.150
    24.353   316.206     0.150
    24.357   316.546     0.150
    24.394   319.626     0.150
    24.537   321.726     0.150
    24.859   325.026     0.150
    24.910   321.806     0.150
    24.909   325.926     0.150
    24.992   327.926     0.150
    24.997   325.826     0.150
    25.017   326.326     0.150
    25.081   327.526     0.150
    25.101   326.226     0.150
    25.101   589.226     0.150
    25.101   603.726     0.150
    25.384   330.026     0.150
    25.467   326.196     0.150
    25.535   329.250     0.150
    25.570   329.426     0.150
    26.315   339.826     0.150
    26.418   337.526     0.150
    27.568   349.526     0.150
    27.699   346.926     0.150
    27.736   348.426     0.150
    27.736   633.726     0.150
    27.736   347.426     0.150
    27.875   350.011     0.150
    28.064   636.826     0.150
    30.135   368.699     0.150
    30.135   370.126     0.150
    30.135   368.426     0.150
    30.930   377.226     0.150
    30.930   681.226     0.150
    31.282   378.026     0.150
    31.282   377.417     0.150
    31.287   377.836     0.150
    31.287   552.597     0.150
    31.287   377.596     0.150
    31.287   552.596     0.150
    31.309   377.216     0.150
    31.835   386.226     0.150
    31.835   698.526     0.150
    32.811   396.526     0.150
    34.008   404.426     0.150
    34.651   561.586     0.150
    34.652   407.452     0.150
    34.652   562.054     0.150
    34.652   406.926     0.150
    35.116   412.126     0.150
    35.116   413.707     0.150
    35.116   412.126     0.150
    36.433   425.926     0.150
    37.037   429.032     0.150
    38.138   439.926     0.150
    38.239   440.526     0.150
    38.934   446.626     0.150
    39.512   451.526     0.150
    39.973   454.551     0.150
    39.973   452.626     0.150
    40.138   455.926     0.150
    40.150   455.726     0.150
    40.317   457.426     0.150
    40.405   458.126     0.150
    40.476   456.417     0.150
    40.517   457.226     0.150
    40.532   459.995     0.150
    40.700   460.198     0.150
    40.700   459.926     0.150
    41.768   469.226     0.150
    43.793   487.346     0.150
    43.793   878.167     0.150
    43.906   485.066     0.150
    43.927   590.167     0.150
    44.004   484.226     0.150
    44.773   492.876     0.150
    44.773   597.525     0.150
    44.773   491.526     0.150
    45.758   502.426     0.150
    46.103   505.826     0.150
    48.572   522.526     0.150
    50.791   540.626     0.150
    50.940   616.556     0.150
    50.940   541.526     0.150
    50.940   616.551     0.150
    50.940   540.276     0.150
    50.940   616.406     0.150
    51.128   541.826     0.150
    51.289   542.726     0.150
    51.710   549.726     0.150
    51.710   989.726     0.150
    51.931   547.326     0.150
    52.521   554.026     0.150
    53.907   562.295     0.150
    53.907   562.726     0.150
    53.907   561.846     0.150
    53.925   564.913     0.150
    53.925   563.926     0.150
    53.925   564.516     0.150
    55.092   571.506     0.150
    55.092   571.795     0.150
    55.092   571.626     0.150
    55.092   571.466     0.150
    55.534   574.326     0.150
    56.824   582.926     0.150
    56.824   640.626     0.150
    57.013   586.021     0.150
    60.749   611.380     0.150
    60.749   610.826     0.150
    60.749   610.636     0.150
    61.973   618.735     0.150
    61.973   618.426     0.150
    63.806   632.245     0.150
    63.823   631.891     0.150
    63.937   631.919     0.150
    63.959   633.271     0.150
    64.556   637.082     0.150
    64.658   638.048     0.150
    64.822   639.326     0.150
    64.822   637.696     0.150
    65.280   641.946     0.150
    65.573   643.293     0.150
    65.617   644.539     0.150
    65.626   643.417     0.150
    65.638   643.620     0.150
    65.638   644.442     0.150
    65.642   645.033     0.150
    65.704   643.804     0.150
    65.984   645.973     0.150
    66.066   645.500     0.150
    66.262   649.600     0.150
    66.368   649.667     0.150
    66.923   653.173     0.150
    67.301   654.226     0.150
    67.643   657.705     0.150
    68.284   659.726     0.150
    68.284   806.726     0.150
    68.284  1200.026     0.150
    68.284  1460.026     0.150
    68.284   659.917     0.150
    68.517   663.545     0.150
    74.576   697.726     0.150
    74.576   712.026     0.150
    74.576  1271.626     0.150
    75.347   702.226     0.150
    75.383   703.851     0.150
    75.383   702.726     0.150
    75.963   704.426     0.150
    76.395   706.226     0.150
    76.610   709.426     0.150
    76.689   710.428     0.150
    76.838   711.646     0.150
    76.838   712.396     0.150
    76.838   710.356     0.150
    76.863   711.426     0.150
    77.303   712.496     0.150
    77.449   712.726     0.150
    78.181   717.556     0.150
    78.532   720.926     0.150
    79.001   721.726     0.150
    79.001   732.226     0.150
    79.056   721.826     0.150
    79.160   723.026     0.150
    79.816   725.826     0.150
    79.816   732.126     0.150
    80.211   728.526     0.150
    80.349   731.826     0.150
    80.447   730.026     0.150
    80.447   915.426     0.150
    80.564  1332.426     0.150
    80.564  1644.726     0.150
    81.064   732.776     0.150
    81.064   733.396     0.150
    81.790   737.616     0.150
    82.897   744.226     0.150
    83.175   745.796     0.150
    83.487   745.426     0.150
    83.817   747.591     0.150
    83.887   749.176     0.150
    83.887   748.466     0.150
    83.887   749.126     0.150
    84.513   753.045     0.150
    84.929   754.406     0.150
    85.153   754.635     0.150
    85.153   754.926     0.150
    85.359   755.229     0.150
    85.359   755.126     0.150
    85.538   756.426     0.150
    85.875   759.156     0.150
    86.578   762.326     0.150
    86.638   764.813     0.150
    86.638   764.707     0.150
    86.638   765.396     0.150
    86.850   764.576     0.150
    86.970   769.917     0.150
    87.176   764.216     0.150
    88.299   768.726     0.150
    88.537   771.526     0.150
    88.537   771.766     0.150
    89.850  1427.326     0.150
    90.197   780.226     0.150
    90.965  1438.426     0.150
    92.107   786.726     0.150
    92.107   787.301     0.150
    92.441   793.326     0.150
    92.441   793.226     0.150
    94.648   800.546     0.150
    95.037   803.426     0.150
    95.037  1859.426     0.150
    95.305   803.318     0.150
    95.305   806.825     0.150
    95.505   804.426     0.150
   118.061  1125.651     0.150
   118.062  1125.646     0.150
   129.477  1145.736     0.150
   146.636  1180.650     0.150
   146.636  1180.126     0.150
   147.333  1181.766     0.150
   150.713  1199.776     0.150
   151.324  1186.326     0.150
   159.747  1238.926     0.150
   163.441  1252.949     0.150
   163.441  1251.226     0.150
   166.792  1206.051     0.150
   166.792  1271.386     0.150
   173.213  1206.626     0.150
     0.624    11.781     0.150
     0.624    21.791     0.150
     1.161    21.461     0.150
     1.161    38.671     0.150
     1.189    37.461     0.150
     1.435    43.851     0.150
     1.499    25.621     0.150
     1.499    46.891     0.150
     1.625    28.351     0.150
     1.594    30.051     0.150
     1.594    49.891     0.150
     1.803    30.271     0.150
     1.803    54.651     0.150
     2.041    33.791     0.150
     2.041    63.701     0.150
     2.158    36.271     0.150
     2.158    67.711     0.150
     2.222    35.701     0.150
     2.222    65.521     0.150
     2.226    36.131     0.150
     2.620    41.381     0.150
     2.620    78.691     0.150
     2.665    43.051     0.150
     2.665    76.931     0.150
     2.689    44.111     0.150
     2.689    79.371     0.150
     3.098    52.620     0.150
     3.098    49.258     0.150
     3.098    47.121     0.150
     3.098    81.371     0.150
     3.373    50.641     0.150
     3.293    51.741     0.150
     3.293    92.371     0.150
     3.334    51.651     0.150
     3.535    54.701     0.150
     3.672    55.521     0.150
     3.672   102.781     0.150
     4.035    61.911     0.150
     4.002    61.251     0.150
     4.258    63.551     0.150
     4.359    66.571     0.150
     4.509    67.731     0.150
     4.509   121.421     0.150
     4.936    73.021     0.150
     4.963    74.881     0.150
     6.302    95.101     0.150
     7.392   110.361     0.150
     8.850   128.601     0.150
     8.850   227.811     0.150
     9.580   137.401     0.150
     9.580   137.571     0.150
     9.580   242.741     0.150
     9.646   140.901     0.150
    10.954   159.401     0.150
    10.974   156.361     0.150
    11.055   163.901     0.150
    11.996   168.201     0.150
    12.768   181.922     0.150
    13.356   186.001     0.150
    13.605   195.701     0.150
    13.712   194.091     0.150
    13.956   199.401     0.150
    14.076   201.501     0.150
    14.076   200.011     0.150
    14.166   199.351     0.150
    15.014   212.501     0.150
    15.014   209.061     0.150
    15.487   225.160     0.150
    15.487   217.101     0.150
    15.678   224.401     0.150
    15.903   226.801     0.150
    16.047   227.701     0.150
    16.135   226.601     0.150
    16.211   225.981     0.150
    16.645   237.501     0.150
    16.645   426.001     0.150
    16.645   234.091     0.150
    18.527   257.701     0.150
    18.527   255.541     0.150
    18.611   258.401     0.150
    18.707   257.301     0.150
    19.104   265.401     0.150
    19.104   262.351     0.150
    19.529   269.401     0.150
    19.529   265.351     0.150
    19.698   270.501     0.150
    19.925   273.501     0.150
    19.986   273.851     0.150
    19.986   273.301     0.150
    20.016   273.401     0.150
    20.120   273.601     0.150
    20.497   278.301     0.150
    20.497   276.401     0.150
    20.412   282.501     0.150
    20.697   286.501     0.150
    20.847   284.601     0.150
    20.847   280.291     0.150
    21.756   292.371     0.150
    21.838   296.501     0.150
    21.838   292.631     0.150
    22.207   300.601     0.150
    22.374   298.311     0.150
    22.436   301.501     0.150
    22.521   302.501     0.150
    22.521   549.001     0.150
    22.513   301.001     0.150
    22.604   303.501     0.150
    22.947   307.701     0.150
    23.421   312.801     0.150
    23.421   609.301     0.150
    23.480   311.822     0.150
    23.614   312.101     0.150
    23.861   315.301     0.150
    24.360   319.201     0.150
    24.333   320.701     0.150
    24.461   319.501     0.150
    24.511   318.711     0.150
    24.762   324.101     0.150
    24.846   325.601     0.150
    24.992   326.601     0.150
    24.992   324.591     0.150
    25.381   329.401     0.150
    25.447   331.901     0.150
    25.447   596.001     0.150
    25.447   609.401     0.150
    25.517   331.201     0.150
    25.543   331.801     0.150
    25.958   333.501     0.150
    25.958   333.951     0.150
    25.958   333.001     0.150
    26.055   333.001     0.150
    26.174   335.185     0.150
    26.174   334.001     0.150
    26.173   334.001     0.150
    27.612   347.579     0.150
    27.669   347.581     0.150
    27.855   348.608     0.150
    27.855   348.201     0.150
    27.846   350.101     0.150
    27.846   634.401     0.150
    27.846   349.101     0.150
    28.297   354.801     0.150
    28.297   642.501     0.150
    30.228   369.111     0.150
    30.845   375.701     0.150
    31.265   378.201     0.150
    31.270   378.601     0.150
    31.270   377.831     0.150
    31.993   389.301     0.150
    32.810   397.301     0.150
    34.428   409.721     0.150
    34.428   409.501     0.150
    34.667   409.051     0.150
    34.819   410.887     0.150
    34.819   409.901     0.150
    34.891   410.001     0.150
    36.594   427.501     0.150
    36.658   427.501     0.150
    38.553   443.601     0.150
    38.661   444.301     0.150
    39.359   450.401     0.150
    39.697   451.442     0.150
    39.929   455.201     0.150
    40.531   460.393     0.150
    40.611   458.401     0.150
    40.559   459.701     0.150
    40.571   459.701     0.150
    40.706   460.800     0.150
    40.706   460.301     0.150
    40.735   461.201     0.150
    40.826   462.201     0.150
    41.342   466.001     0.150
    42.185   473.301     0.150
    43.719   483.791     0.150
    43.781   483.601     0.150
    43.781   593.601     0.150
    44.729   492.852     0.150
    44.729   491.031     0.150
    46.309   508.901     0.150
    48.456   522.301     0.150
    50.691   538.101     0.150
    50.797   539.912     0.150
    50.800   539.911     0.150
    51.142   543.601     0.150
    51.142   543.551     0.150
    51.142   542.421     0.150
    51.160   543.501     0.150
    51.332   544.401     0.150
    52.183   550.401     0.150
    52.183    10.199     0.150
    52.183   622.001     0.150
    52.183   666.901     0.150
    52.183   990.901     0.150
    52.183  1007.801     0.150
    52.183   549.741     0.150
    52.319   552.830     0.150
    52.319   551.501     0.150
    53.567   563.001     0.150
    53.567   562.071     0.150
    53.905   565.141     0.150
    54.017   563.890     0.150
    54.017   563.161     0.150
    54.042   566.581     0.150
    55.267   573.820     0.150
    55.267   573.201     0.150
    55.267   572.921     0.150
    55.268   573.088     0.150
    55.922   577.401     0.150
    57.114   586.101     0.150
    60.928   613.620     0.150
    60.928   612.201     0.150
    60.928   612.651     0.150
    65.191   642.359     0.150
    65.191   641.151     0.150
    65.191   640.501     0.150
    65.873   645.201     0.150
    65.873   644.891     0.150
    65.977   647.786     0.150
    66.193   648.780     0.150
    66.799   653.187     0.150
    67.462   655.801     0.150
    68.454   661.801     0.150
    68.454   809.501     0.150
    68.454  1202.501     0.150
    68.454  1465.201     0.150
    68.792   663.191     0.150
    69.057   666.960     0.150
    75.878   705.801     0.150
    75.949   704.301     0.150
    76.290   709.901     0.150
    76.646   709.011     0.150
    77.006   713.892     0.150
    77.154   716.201     0.150
    77.154   712.761     0.150
    77.690   716.001     0.150
    77.752   716.361     0.150
    78.039   718.901     0.150
    79.296   724.501     0.150
    79.385   726.101     0.150
    80.625   731.683     0.150
    81.374   736.091     0.150
    83.036   744.741     0.150
    83.199   747.501     0.150
    83.849   749.501     0.150
    84.238   752.030     0.150
    84.238   752.501     0.150
    84.238   751.101     0.150
    85.275   756.691     0.150
    85.275   757.201     0.150
    85.598   758.401     0.150
    85.598   757.701     0.150
    85.598   757.501     0.150
    87.253   768.364     0.150
    88.505   771.301     0.150
    88.686   771.734     0.150
    88.801   773.271     0.150
    92.209   790.002     0.150
    95.762   805.735     0.150
   118.564  1126.771     0.150
   118.564  1127.310     0.150
   118.564  1126.981     0.150
   118.565  1127.311     0.150
   119.545  1127.891     0.150
   119.545  1128.781     0.150
   119.546  1130.189     0.150
   119.546  1128.301     0.150
   122.232  1133.951     0.150
   126.701  1144.201     0.150
   126.718  1144.099     0.150
   126.881  1146.001     0.150
   127.013  1143.701     0.150
   146.606  1181.300     0.150
   146.606  1178.801     0.150
   151.410  1192.301     0.150
     0.439     9.098     0.150
     0.439    15.078     0.150
     0.497     9.348     0.150
     0.497    16.748     0.150
     0.640    12.278     0.150
     0.640    22.828     0.150
     1.192    20.938     0.150
     1.192    39.308     0.150
     1.147    21.928     0.150
     1.147    38.498     0.150
     1.442    43.508     0.150
     1.505    27.038     0.150
     1.505    46.408     0.150
     1.585    29.028     0.150
     1.640    51.228     0.150
     1.787    30.878     0.150
     1.787    55.768     0.150
     2.166    36.928     0.150
     2.166    67.508     0.150
     2.213    36.878     0.150
     2.217    36.358     0.150
     2.217    65.418     0.150
     2.621    41.448     0.150
     2.666    44.018     0.150
     2.666    77.408     0.150
     2.680    44.208     0.150
     2.680    78.258     0.150
     3.107    47.118     0.150
     3.107    84.098     0.150
     3.280    51.448     0.150
     3.280    91.568     0.150
     3.317    51.738     0.150
     3.317    91.058     0.150
     3.376    55.388     0.150
     3.376    98.098     0.150
     4.952    79.118     0.150
     8.835   130.498     0.150
     8.835   230.258     0.150
     9.587   135.618     0.150
    19.087   265.038     0.150
    19.987   273.402     0.150
    25.941   333.338     0.150
    25.941   334.025     0.150
    31.277   378.893     0.150
    31.278   378.888     0.150
    34.412   408.258     0.150
    34.674   408.881     0.150
    34.820   414.234     0.150
    44.737   493.691     0.150
    44.737   493.348     0.150
    51.130   544.368     0.150
    51.130   544.878     0.150
    51.130   544.881     0.150
    51.130   544.708     0.150
    52.183   549.628     0.150
    54.008   563.638     0.150
    55.256   572.948     0.150
    55.257   574.835     0.150
    56.008   579.678     0.150
    57.101   587.518     0.150
    57.101   588.388     0.150
    60.917   614.058     0.150
    65.860   646.418     0.150
    80.631   733.975     0.150
    84.223   753.108     0.150
    84.223   753.103     0.150
     0.393     7.559     0.150
     0.393    14.170     0.150
     0.405    14.430     0.150
     0.713    13.289     0.150
     0.713    24.139     0.150
     1.094    20.930     0.150
     1.094    37.229     0.150
     1.448    25.309     0.150
     1.448    44.309     0.150
     1.579    28.959     0.150
     1.583    27.170     0.150
     1.583    49.629     0.150
     1.681    28.680     0.150
     1.681    52.449     0.150
     1.745    29.520     0.150
     1.745    53.889     0.150
     2.063    34.619     0.150
     2.063    61.260     0.150
     2.113    34.949     0.150
     2.230    35.068     0.150
     2.230    65.408     0.150
     2.249    37.170     0.150
     2.249    69.430     0.150
     2.586    41.840     0.150
     2.586    75.148     0.150
     2.664    43.170     0.150
     2.664    78.219     0.150
     2.719    43.738     0.150
     2.719    77.939     0.150
     2.799    45.430     0.150
     2.799    79.459     0.150
     3.070    48.760     0.150
     3.180    50.359     0.150
     3.180    89.549     0.150
     3.194    54.889     0.150
     3.194   103.965     0.150
     3.194    50.926     0.150
     3.194    49.670     0.150
     3.194    49.449     0.150
     3.214    50.289     0.150
     3.214    88.139     0.150
     3.436    54.709     0.150
     3.436    99.260     0.150
     3.648    57.080     0.150
     4.124    61.869     0.150
     4.154    65.889     0.150
     4.387    66.129     0.150
     4.387   118.238     0.150
     4.860    74.250     0.150
     5.187    83.920     0.150
     8.773   126.719     0.150
     9.671   140.020     0.150
     9.666   139.619     0.150
    11.012   157.238     0.150
    11.080   161.818     0.150
    12.065   170.520     0.150
    13.619   198.219     0.150
    14.009   197.020     0.150
    14.822   214.719     0.150
    15.118   217.219     0.150
    15.505   222.562     0.150
    15.991   229.420     0.150
    18.744   260.318     0.150
    18.983   265.719     0.150
    18.983   260.029     0.150
    19.582   271.719     0.150
    19.582   269.619     0.150
    19.711   270.920     0.150
    19.933   274.219     0.150
    20.036   273.969     0.150
    20.036   274.520     0.150
    20.038   277.020     0.150
    20.240   276.818     0.150
    20.617   281.645     0.150
    20.696   283.318     0.150
    20.729   282.020     0.150
    20.840   283.920     0.150
    20.840   280.799     0.150
    21.355   289.719     0.150
    21.686   291.420     0.150
    21.753   292.539     0.150
    22.392   301.920     0.150
    22.430   300.920     0.150
    22.529   300.219     0.150
    22.912   304.619     0.150
    23.493   312.619     0.150
    23.493   311.229     0.150
    23.576   310.139     0.150
    23.750   313.229     0.150
    23.823   315.020     0.150
    24.213   314.619     0.150
    24.216   320.020     0.150
    24.262   319.920     0.150
    24.725   324.619     0.150
    24.908   324.699     0.150
    25.259   327.818     0.150
    25.328   328.520     0.150
    25.836   331.568     0.150
    25.836   541.119     0.150
    25.836   334.219     0.150
    25.836   331.260     0.150
    26.080   333.619     0.150
    26.080   333.119     0.150
    26.080   333.119     0.150
    26.958   343.318     0.150
    27.571   347.014     0.150
    27.748   348.420     0.150
    27.748   347.920     0.150
    27.913   349.119     0.150
    27.913   544.270     0.150
    27.913   349.930     0.150
    28.186   352.119     0.150
    31.350   378.520     0.150
    31.356   553.119     0.150
    31.356   378.680     0.150
    31.356   553.119     0.150
    31.356   379.020     0.150
    31.360   379.189     0.150
    31.889   387.020     0.150
    32.726   393.920     0.150
    34.306   407.420     0.150
    34.306   405.619     0.150
    34.748   408.969     0.150
    34.748   562.119     0.150
    34.748   408.818     0.150
    34.785   410.350     0.150
    36.033   422.420     0.150
    36.491   426.719     0.150
    38.431   442.719     0.150
    38.539   443.619     0.150
    39.237   449.520     0.150
    39.358   449.420     0.150
    39.659   451.119     0.150
    39.659   450.818     0.150
    39.808   454.318     0.150
    40.149   456.920     0.150
    40.437   458.818     0.150
    40.449   458.719     0.150
    40.614   460.219     0.150
    40.621   580.670     0.150
    40.621   460.100     0.150
    40.621   580.668     0.150
    40.621   460.619     0.150
    40.673   459.850     0.150
    40.705   460.920     0.150
    41.221   465.020     0.150
    42.063   472.119     0.150
    43.150   479.869     0.150
    43.734   484.818     0.150
    44.016   487.000     0.150
    44.818   493.270     0.150
    44.818   493.119     0.150
    45.695   501.719     0.150
    46.201   506.420     0.150
    48.048   518.830     0.150
    50.797   540.406     0.150
    50.797   616.104     0.150
    50.800   540.408     0.150
    50.800   616.100     0.150
    51.034   617.309     0.150
    51.034   542.469     0.150
    51.034   617.305     0.150
    51.034   542.238     0.150
    51.224   544.020     0.150
    51.907   551.520     0.150
    51.907   622.420     0.150
    51.907   993.420     0.150
    52.137   550.520     0.150
    52.198   551.219     0.150
    53.919   562.744     0.150
    54.093   565.020     0.150
    55.162   572.520     0.150
    55.904   578.389     0.150
    56.999   586.020     0.150
    60.823   612.219     0.150
    63.815   631.869     0.150
    65.071   640.770     0.150
    65.761   643.840     0.150
    67.359   654.719     0.150
    68.349   660.119     0.150
    68.349  1200.219     0.150
    68.349   660.379     0.150
    75.756   705.719     0.150
    75.850   704.818     0.150
    76.173   708.920     0.150
    77.037   712.818     0.150
    80.626   729.969     0.150
    81.369   736.510     0.150
    83.040   744.959     0.150
    83.761   748.193     0.150
    84.119   750.395     0.150
    84.119   751.920     0.150
    84.119   751.209     0.150
    85.176   755.020     0.150
    85.176   755.006     0.150
    85.176   755.420     0.150
    85.337   756.219     0.150
    85.456   758.020     0.150
    85.487   755.707     0.150
    85.487   757.420     0.150
    86.823   764.719     0.150
    87.144   767.119     0.150
    88.699   771.543     0.150
    92.112   787.520     0.150
    92.112   787.930     0.150
    92.112   787.934     0.150
    95.132   802.619     0.150
    95.652   805.420     0.150
   104.561   846.658     0.150
   104.561   846.662     0.150
   119.593  1129.818     0.150
   119.593  1129.795     0.150
   121.702  1133.920     0.150
   125.143  1140.020     0.150
   126.581  1143.619     0.150
   126.598  1143.670     0.150
   126.598  1141.818     0.150
   126.760  1143.818     0.150
   126.893  1144.119     0.150
   146.694  1181.193     0.150
   146.694  1181.920     0.150
   166.482  1206.170     0.150
   166.482  1269.719     0.150
     0.162     3.592     0.150
     0.162     7.271     0.150
     0.572    10.852     0.150
     0.572    20.072     0.150
     0.676    12.602     0.150
     0.676    22.912     0.150
     1.152    20.902     0.150
     1.226    22.482     0.150
     1.226    41.963     0.150
     1.434    24.643     0.150
     1.434    44.713     0.150
     1.574    29.941     0.150
     1.857    29.771     0.150
     1.857    55.262     0.150
     1.932    32.201     0.150
     1.932    57.102     0.150
     2.029    35.152     0.150
     2.080    35.062     0.150
     2.194    35.361     0.150
     2.194    65.062     0.150
     2.249    36.752     0.150
     2.249    68.922     0.150
     2.513    40.941     0.150
     2.513    42.902     0.150
     3.124    48.213     0.150
     3.124    90.432     0.150
     4.134    61.521     0.150
     8.250   120.242     0.150
    25.517   329.861     0.150
    25.517   329.861     0.150
    26.884   341.322     0.150
    27.678   346.312     0.150
    31.255   377.441     0.150
    31.255   377.443     0.150
    31.255   551.660     0.150
    34.621   407.713     0.150
    34.621   560.404     0.150
    34.621   405.852     0.150
    38.187   440.162     0.150
    38.288   440.963     0.150
    38.983   446.963     0.150
    39.561   452.062     0.150
    39.904   454.662     0.150
    39.984   453.236     0.150
    40.187   456.361     0.150
    40.199   456.463     0.150
    40.366   457.861     0.150
    40.454   458.963     0.150
    40.731   458.322     0.150
    40.731   458.324     0.150
    41.817   469.861     0.150
    42.567   471.951     0.150
    50.981   541.932     0.150
    50.981   542.162     0.150
    50.981   542.162     0.150
    50.981   541.312     0.150
    51.979   549.553     0.150
    53.944   561.912     0.150
    53.947   561.912     0.150
    55.132   571.922     0.150
    56.869   584.332     0.150
    64.870   640.172     0.150
    81.060   733.512     0.150
    81.060   733.512     0.150
    81.788   738.053     0.150
    83.934   749.162     0.150
    83.934   749.162     0.150
    85.402   755.562     0.150
    85.748   756.852     0.150
   118.111  1126.254     0.150
   118.112  1126.252     0.150
   146.604  1181.137     0.150
     0.336     6.746     0.150
     0.336    12.197     0.150
     0.453     8.438     0.150
     0.453    15.277     0.150
     0.752    14.207     0.150
     0.752    25.717     0.150
     1.042    19.387     0.150
     1.042    35.518     0.150
     1.241    21.916     0.150
     1.241    41.346     0.150
     1.532    25.916     0.150
     1.532    46.756     0.150
     1.514    27.557     0.150
     1.514    48.426     0.150
     1.512    25.857     0.150
     1.512    47.037     0.150
     1.730    29.426     0.150
     1.730    53.727     0.150
     1.687    28.617     0.150
     1.687    51.727     0.150
     2.126    35.277     0.150
     2.126    63.287     0.150
     2.164    36.137     0.150
     2.164    62.846     0.150
     2.147    35.727     0.150
     2.601    42.957     0.150
     2.601    77.096     0.150
     2.658    43.207     0.150
     2.658    76.316     0.150
     3.018    48.197     0.150
     3.148    50.176     0.150
     3.148    86.252     0.150
     3.148    54.838     0.150
     3.148    49.537     0.150
     3.148    49.217     0.150
     3.148    85.777     0.150
     3.211    50.637     0.150
     3.211    88.227     0.150
     3.213    51.326     0.150
     3.213    93.018     0.150
     3.377    52.826     0.150
     3.377    98.316     0.150
     3.908    59.057     0.150
     4.075    62.727     0.150
     4.075   125.977     0.150
     4.397    65.846     0.150
     4.397   118.057     0.150
     4.902    76.396     0.150
     8.726   126.926     0.150
     8.726   225.617     0.150
     9.615   138.256     0.150
     9.615   137.846     0.150
     9.606   138.756     0.150
    10.985   159.256     0.150
    11.015   161.557     0.150
    12.007   170.156     0.150
    12.833   184.807     0.150
    13.553   195.857     0.150
    13.958   199.557     0.150
    13.958   199.768     0.150
    14.756   211.857     0.150
    15.077   218.957     0.150
    15.077   212.697     0.150
    15.431   221.656     0.150
    15.440   217.250     0.150
    15.936   228.557     0.150
    16.227   228.156     0.150
    16.542   232.557     0.150
    16.542   418.357     0.150
    18.679   259.557     0.150
    18.709   260.357     0.150
    18.982   265.156     0.150
    18.982   261.727     0.150
    19.520   268.957     0.150
    19.520   265.467     0.150
    19.973   272.156     0.150
    19.973   272.457     0.150
    19.972   273.057     0.150
    20.220   278.357     0.150
    20.598   278.781     0.150
    20.674   281.457     0.150
    20.775   281.557     0.150
    20.775   281.416     0.150
    20.953   282.656     0.150
    21.292   288.256     0.150
    21.711   291.787     0.150
    21.985   295.656     0.150
    22.122   298.156     0.150
    22.305   299.557     0.150
    22.479   299.156     0.150
    22.586   303.656     0.150
    23.379   310.957     0.150
    23.492   309.646     0.150
    23.542   310.557     0.150
    23.542   310.146     0.150
    23.633   309.506     0.150
    23.718   312.557     0.150
    23.718   312.047     0.150
    23.762   314.256     0.150
    23.762   312.846     0.150
    23.938   313.832     0.150
    24.159   317.156     0.150
    24.204   321.156     0.150
    24.625   321.457     0.150
    24.646   323.457     0.150
    24.721   324.857     0.150
    24.865   324.756     0.150
    24.865   322.367     0.150
    25.365   329.756     0.150
    25.350   329.557     0.150
    25.815   331.496     0.150
    25.839   331.783     0.150
    25.839   332.957     0.150
    25.895   334.457     0.150
    26.044   332.281     0.150
    26.043   332.787     0.150
    26.923   340.656     0.150
    27.635   346.834     0.150
    27.852   347.732     0.150
    27.793   349.156     0.150
    28.221   353.857     0.150
    31.304   377.006     0.150
    31.304   551.875     0.150
    31.930   387.357     0.150
    32.778   396.857     0.150
    34.320   407.756     0.150
    34.694   408.256     0.150
    34.694   561.414     0.150
    34.694   408.957     0.150
    34.851   410.686     0.150
    34.851   412.557     0.150
    36.531   427.156     0.150
    38.445   443.357     0.150
    38.553   443.857     0.150
    39.250   449.857     0.150
    39.724   451.682     0.150
    39.822   454.557     0.150
    40.163   457.457     0.150
    40.450   458.957     0.150
    40.463   458.557     0.150
    40.627   460.656     0.150
    40.674   461.096     0.150
    40.718   460.756     0.150
    46.238   507.557     0.150
    51.071   542.756     0.150
    51.071   542.484     0.150
    51.071   543.156     0.150
    51.934   553.857     0.150
    51.934   994.857     0.150
    52.216   551.457     0.150
    53.964   562.281     0.150
    53.964   562.756     0.150
    53.964   563.107     0.150
    55.201   573.557     0.150
    55.201   573.377     0.150
    57.028   585.756     0.150
    57.028   585.857     0.150
    60.862   612.957     0.150
    60.862   613.496     0.150
    63.870   632.682     0.150
    65.091   640.428     0.150
    65.091   641.547     0.150
    65.794   644.406     0.150
    65.794   643.447     0.150
    67.274   654.357     0.150
    68.390   660.676     0.150
    68.390   661.957     0.150
    68.390  1203.156     0.150
    75.759   706.357     0.150
    77.613   715.957     0.150
    79.219   724.256     0.150
    80.691   731.906     0.150
    81.435   737.637     0.150
    82.489   744.219     0.150
    83.105   744.717     0.150
    83.812   749.693     0.150
    84.141   749.906     0.150
    84.141   749.906     0.150
    85.220   756.057     0.150
    85.220   756.006     0.150
    85.220   756.357     0.150
    85.521   757.898     0.150
    87.121   766.631     0.150
    92.158   788.980     0.150
   118.444  1126.990     0.150
   118.445  1126.986     0.150
   119.650  1129.756     0.150
   119.651  1129.730     0.150
   146.644  1179.307     0.150
     0.241     4.863     0.150
     0.511    10.053     0.150
     0.511    18.053     0.150
     0.711    13.223     0.150
     0.711    23.953     0.150
     1.131    20.412     0.150
     1.131    35.543     0.150
     1.300    23.373     0.150
     1.300    44.773     0.150
     1.375    24.223     0.150
     1.375    43.523     0.150
     1.845    31.162     0.150
     1.985    32.633     0.150
     1.985    57.793     0.150
     2.047    34.832     0.150
     2.103    33.893     0.150
     2.155    34.023     0.150
     2.155    64.184     0.150
     2.531    43.752     0.150
     2.531    71.832     0.150
    25.444   327.133     0.150
    27.683   345.957     0.150
    31.281   376.859     0.150
    31.281   552.215     0.150
    34.644   407.439     0.150
    34.644   560.627     0.150
    39.995   452.832     0.150
    50.936   541.172     0.150
    53.909   562.283     0.150
    68.282   657.242     0.150
    81.095   731.928     0.150
    83.873   746.832     0.150
    84.068   746.227     0.150
    85.353   753.246     0.150
   118.038  1124.113     0.150
   146.630  1179.783     0.150
     0.196     4.324     0.150
     0.196     8.254     0.150
     0.534     9.803     0.150
     0.534    18.773     0.150
     0.706    13.053     0.150
     0.706    23.994     0.150
     1.126    35.453     0.150
     1.264    22.973     0.150
     1.264    41.914     0.150
     1.420    24.613     0.150
     1.420    44.553     0.150
     1.835    30.383     0.150
     1.968    32.652     0.150
     1.968    57.754     0.150
     2.055    32.773     0.150
     2.055    62.363     0.150
     2.081    35.123     0.150
     2.256    37.312     0.150
     2.504    40.344     0.150
     2.504    71.514     0.150
     3.000    56.383     0.150
     4.877    77.402     0.150
    18.612   259.693     0.150
    25.492   329.953     0.150
    25.492   329.953     0.150
    25.492   329.773     0.150
    31.250   378.652     0.150
    31.250   378.648     0.150
    31.254   378.514     0.150
    34.615   407.312     0.150
    34.615   407.584     0.150
    40.737   460.344     0.150
    40.737   460.348     0.150
    50.975   541.393     0.150
    50.975   541.395     0.150
    50.975   541.863     0.150
    53.944   562.812     0.150
    53.947   562.812     0.150
    53.959   564.344     0.150
    55.128   571.104     0.150
    55.565   574.793     0.150
    56.858   584.453     0.150
    64.854   637.754     0.150
    65.661   643.164     0.150
    81.817   738.902     0.150
    83.512   746.893     0.150
    83.854   748.453     0.150
    83.854   748.453     0.150
    83.919   749.264     0.150
    83.919   749.264     0.150
    83.919   748.193     0.150
    85.394   754.738     0.150
    85.776   758.344     0.150
    85.909   760.273     0.150
    88.571   771.533     0.150
     0.199     4.279     0.150
     0.199     8.258     0.150
     0.540    10.199     0.150
     0.540    18.568     0.150
     0.695    13.039     0.150
     0.695    23.879     0.150
     1.138    20.559     0.150
     1.138    36.709     0.150
     1.262    22.598     0.150
     1.262    42.658     0.150
     1.408    24.578     0.150
     1.408    43.699     0.150
     1.594    26.008     0.150
     1.646    28.518     0.150
     1.960    32.738     0.150
     1.960    55.238     0.150
     2.063    34.678     0.150
     2.172    35.498     0.150
     2.172    65.408     0.150
     2.067    34.898     0.150
     2.269    68.758     0.150
     2.518    40.428     0.150
     2.518    71.389     0.150
     3.013    47.869     0.150
     3.107    50.049     0.150
     3.219    51.664     0.150
     3.219    50.811     0.150
     3.266    49.709     0.150
     4.106   108.729     0.150
     4.863    74.539     0.150
     8.215   120.088     0.150
     8.215   212.088     0.150
     9.308   139.229     0.150
    10.694   152.039     0.150
    10.716   158.529     0.150
    13.451   189.588     0.150
    13.593   195.828     0.150
    14.104   202.029     0.150
    14.435   209.828     0.150
    15.114   214.328     0.150
    15.167   212.678     0.150
    15.426   226.029     0.150
    15.439   220.328     0.150
    16.280   229.629     0.150
    16.280   415.529     0.150
    18.419   257.328     0.150
    18.604   259.928     0.150
    19.302   265.629     0.150
    19.556   269.229     0.150
    19.762   268.908     0.150
    19.945   279.129     0.150
    20.176   276.428     0.150
    20.371   280.828     0.150
    20.475   279.428     0.150
    20.849   283.428     0.150
    20.862   281.760     0.150
    21.540   291.229     0.150
    22.009   298.229     0.150
    22.386   298.428     0.150
    22.494   300.729     0.150
    22.696   302.529     0.150
    22.903   302.607     0.150
    23.042   303.488     0.150
    23.117   307.328     0.150
    23.117   307.129     0.150
    23.222   307.389     0.150
    23.174   306.529     0.150
    23.291   306.039     0.150
    23.759   313.729     0.150
    23.777   314.328     0.150
    24.137   315.229     0.150
    24.140   316.529     0.150
    24.327   320.129     0.150
    24.254   317.354     0.150
    24.546   321.229     0.150
    24.856   324.029     0.150
    24.927   327.129     0.150
    25.011   324.729     0.150
    25.007   326.328     0.150
    25.123   325.129     0.150
    25.383   326.229     0.150
    25.539   328.303     0.150
    25.484   328.385     0.150
    25.538   328.939     0.150
    25.701   331.418     0.150
    26.423   333.629     0.150
    27.676   346.604     0.150
    27.759   348.529     0.150
    27.759   349.428     0.150
    27.895   348.518     0.150
    28.087   351.729     0.150
    29.814   365.629     0.150
    29.814   365.648     0.150
    30.953   377.328     0.150
    31.258   378.328     0.150
    31.264   551.598     0.150
    31.263   376.928     0.150
    31.263   551.600     0.150
    31.263   378.928     0.150
    31.263   377.879     0.150
    31.268   378.189     0.150
    31.859   386.029     0.150
    31.859   452.029     0.150
    32.834   395.729     0.150
    34.028   404.029     0.150
    34.628   561.328     0.150
    34.628   407.979     0.150
    34.628   561.328     0.150
    34.628   408.318     0.150
    35.135   413.703     0.150
    35.135   412.508     0.150
    35.177   415.229     0.150
    36.456   425.529     0.150
    38.033   436.754     0.150
    38.157   440.029     0.150
    38.258   440.629     0.150
    38.953   446.828     0.150
    39.532   451.629     0.150
    39.875   454.328     0.150
    39.993   453.229     0.150
    39.993   454.129     0.150
    40.157   456.029     0.150
    40.170   456.129     0.150
    40.336   457.729     0.150
    40.424   458.529     0.150
    40.555   458.029     0.150
    40.723   581.049     0.150
    40.723   460.668     0.150
    40.723   581.049     0.150
    40.723   459.828     0.150
    40.943   462.328     0.150
    41.743   469.428     0.150
    41.787   469.328     0.150
    43.936   486.029     0.150
    44.749   490.828     0.150
    46.126   505.729     0.150
    50.963   616.039     0.150
    50.963   541.729     0.150
    50.963   616.033     0.150
    50.963   541.398     0.150
    51.151   542.029     0.150
    51.250   543.291     0.150
    51.250   616.605     0.150
    51.253   543.289     0.150
    51.253   616.609     0.150
    51.732   549.328     0.150
    51.732   989.629     0.150
    51.951   549.229     0.150
    52.433   551.529     0.150
    53.947   564.928     0.150
    53.947   564.168     0.150
    53.931   562.129     0.150
    53.931   562.629     0.150
    53.933   626.158     0.150
    55.115   571.928     0.150
    55.115   572.049     0.150
    55.554   575.129     0.150
    56.846   584.328     0.150
    60.772   610.828     0.150
    60.772   611.369     0.150
    63.960   630.979     0.150
    64.739   637.828     0.150
    64.843   639.324     0.150
    64.843   639.578     0.150
    65.649   643.148     0.150
    67.324   654.428     0.150
    68.308   659.529     0.150
    68.308   659.738     0.150
    75.400   703.428     0.150
    75.848   703.729     0.150
    75.985   704.828     0.150
    76.710   711.004     0.150
    76.860   712.129     0.150
    77.472   713.529     0.150
    78.196   718.619     0.150
    78.545   721.428     0.150
    79.007   720.529     0.150
    79.079   722.229     0.150
    79.182   722.928     0.150
    80.585   729.328     0.150
    80.585   739.928     0.150
    80.585   912.529     0.150
    80.585  1334.828     0.150
    80.662   733.629     0.150
    81.080   732.828     0.150
    81.080   732.568     0.150
    81.806   739.119     0.150
    83.502   747.018     0.150
    83.840   747.104     0.150
    83.908   748.678     0.150
    83.908   748.818     0.150
    85.177   754.404     0.150
    85.177   754.629     0.150
    85.382   755.053     0.150
    85.382   755.828     0.150
    85.427   759.428     0.150
    86.598   762.029     0.150
    86.646   761.828     0.150
    86.646   764.328     0.150
    86.646   765.398     0.150
    88.559   771.629     0.150
    92.131   786.629     0.150
    92.131   786.998     0.150
    92.463   791.229     0.150
    94.671   799.619     0.150
    95.060   799.729     0.150
    95.321   803.105     0.150
    95.556   804.125     0.150
    96.847   805.729     0.150
    99.555   820.248     0.150
   118.078  1125.098     0.150
   118.079  1123.949     0.150
   120.136  1130.529     0.150
   120.136  1130.543     0.150
   146.613  1179.553     0.150
   146.613  1180.898     0.150
   150.034  1194.129     0.150
   151.301  1191.529     0.150
     0.233     4.678     0.150
     0.233     8.857     0.150
     0.515    10.139     0.150
     0.515    18.107     0.150
     0.709    13.299     0.150
     0.709    24.117     0.150
     1.131    20.518     0.150
     1.131    35.639     0.150
     1.293    23.438     0.150
     1.293    42.418     0.150
     1.382    24.438     0.150
     1.382    43.238     0.150
     1.617    26.617     0.150
     1.664    28.559     0.150
     1.844    30.617     0.150
     1.981    32.658     0.150
     1.981    57.998     0.150
     2.095    34.908     0.150
     2.052    34.979     0.150
     2.157    36.068     0.150
     2.157    64.598     0.150
     2.291    37.809     0.150
     2.527    40.969     0.150
     2.527    71.117     0.150
     3.089    50.668     0.150
     3.241    51.178     0.150
     4.077    61.787     0.150
     4.077   108.648     0.150
     4.848    74.549     0.150
     8.185   118.299     0.150
    10.693   151.848     0.150
    13.423   193.648     0.150
    15.187   212.098     0.150
    18.572   257.488     0.150
    20.890   284.314     0.150
    22.480   302.348     0.150
    22.689   302.049     0.150
    23.009   305.037     0.150
    23.085   305.418     0.150
    23.269   308.088     0.150
    24.636   319.568     0.150
    24.636   319.572     0.150
    25.096   326.549     0.150
    25.452   328.848     0.150
    25.452   329.348     0.150
    25.507   329.447     0.150
    25.506   329.447     0.150
    25.709   329.848     0.150
    27.680   347.023     0.150
    27.680   346.338     0.150
    27.743   349.049     0.150
    27.743   348.447     0.150
    31.271   380.748     0.150
    31.276   378.818     0.150
    31.276   378.822     0.150
    31.276   552.273     0.150
    31.840   387.049     0.150
    32.823   396.848     0.150
    33.998   403.447     0.150
    34.078   403.248     0.150
    34.639   407.748     0.150
    34.639   562.152     0.150
    34.639   407.248     0.150
    35.140   413.070     0.150
    37.036   429.559     0.150
    38.128   439.748     0.150
    38.229   440.549     0.150
    38.924   446.648     0.150
    39.502   451.748     0.150
    39.585   451.748     0.150
    39.845   454.148     0.150
    39.996   454.197     0.150
    40.128   456.049     0.150
    40.140   455.947     0.150
    40.307   457.648     0.150
    40.394   458.447     0.150
    40.544   455.848     0.150
    40.544   459.549     0.150
    40.544   458.027     0.150
    40.711   460.309     0.150
    40.711   461.049     0.150
    41.713   469.248     0.150
    41.758   469.549     0.150
    44.026   487.848     0.150
    46.105   506.148     0.150
    48.590   522.648     0.150
    50.942   541.148     0.150
    50.942   541.883     0.150
    50.942   616.598     0.150
    50.942   542.049     0.150
    50.942   541.498     0.150
    51.706   550.648     0.150
    51.706   624.148     0.150
    51.706   989.549     0.150
    51.923   549.248     0.150
    52.434   552.447     0.150
    53.914   562.898     0.150
    53.914   626.307     0.150
    53.914   563.248     0.150
    53.914   562.568     0.150
    53.923   564.447     0.150
    55.095   572.098     0.150
    55.095   571.947     0.150
    55.095   572.139     0.150
    55.526   576.148     0.150
    55.625   574.947     0.150
    55.680   576.197     0.150
    56.821   583.748     0.150
    56.821   584.248     0.150
    60.752   611.648     0.150
    60.752   611.969     0.150
    61.018   613.879     0.150
    61.994   618.549     0.150
    63.951   631.924     0.150
    64.815   638.998     0.150
    64.815   639.697     0.150
    64.815   639.777     0.150
    65.626   643.799     0.150
    68.288   659.717     0.150
    68.288   659.549     0.150
    68.288  1198.447     0.150
    68.288  1458.848     0.150
    68.288   660.059     0.150
    75.959   704.947     0.150
    76.179   707.848     0.150
    76.684   710.348     0.150
    76.834   710.447     0.150
    77.449   713.648     0.150
    78.209   718.938     0.150
    79.056   723.148     0.150
    79.160   723.049     0.150
    80.675   730.148     0.150
    81.093   733.422     0.150
    81.093   732.049     0.150
    81.818   738.787     0.150
    83.516   747.287     0.150
    83.827   748.420     0.150
    83.877   750.188     0.150
    83.881   749.148     0.150
    83.881   748.838     0.150
    85.046   754.379     0.150
    85.159   754.799     0.150
    85.359   755.598     0.150
    85.409   756.549     0.150
    85.776   758.549     0.150
    85.914   759.889     0.150
    86.571   762.848     0.150
    86.613   763.398     0.150
    92.114   786.873     0.150
    95.039   801.748     0.150
    95.505   803.148     0.150
   118.046  1125.611     0.150
   118.047  1125.607     0.150
   120.160  1128.947     0.150
   120.160  1128.975     0.150
   146.625  1178.549     0.150
     0.305     5.957     0.150
     0.305     9.637     0.150
     0.406     7.457     0.150
     0.406    14.379     0.150
     0.808    14.707     0.150
     0.808    27.000     0.150
     1.001    19.090     0.150
     1.001    36.410     0.150
     1.243    41.539     0.150
     1.505    28.789     0.150
     1.527    26.777     0.150
     1.527    48.277     0.150
     1.583    27.848     0.150
     1.615    27.887     0.150
     1.615    49.719     0.150
     1.801    30.270     0.150
     1.801    56.457     0.150
     2.084    35.098     0.150
     2.145    36.109     0.150
     2.168    35.430     0.150
     2.168    66.070     0.150
     2.254    37.820     0.150
     2.584    77.660     0.150
     2.639    42.668     0.150
     2.639    76.258     0.150
     2.688    43.680     0.150
     2.688    77.719     0.150
     3.065    48.969     0.150
     3.203    51.820     0.150
     3.203    54.965     0.150
     3.203    53.098     0.150
     3.149    91.129     0.150
     3.412    53.359     0.150
     3.664    55.789     0.150
     3.839    60.547     0.150
     4.126    63.477     0.150
     4.136   133.590     0.150
     4.326   117.188     0.150
     4.844    74.398     0.150
     5.325    81.660     0.150
     8.677   127.879     0.150
     9.146   137.898     0.150
     9.617   142.598     0.150
     9.663   140.598     0.150
    10.966   162.078     0.150
    11.032   157.500     0.150
    11.026   163.898     0.150
    12.044   171.500     0.150
    13.417   189.699     0.150
    13.557   196.699     0.150
    13.915   199.289     0.150
    14.040   205.199     0.150
    14.129   200.898     0.150
    14.106   207.750     0.150
    14.443   209.398     0.150
    14.496   206.797     0.150
    14.763   213.598     0.150
    15.136   219.898     0.150
    15.136   214.609     0.150
    15.446   218.898     0.150
    15.481   223.598     0.150
    15.431   219.500     0.150
    15.643   225.398     0.150
    15.822   226.898     0.150
    15.899   227.398     0.150
    16.295   229.098     0.150
    16.472   234.797     0.150
    16.856   236.898     0.150
    18.524   260.500     0.150
    18.524   257.637     0.150
    18.697   261.297     0.150
    18.778   261.699     0.150
    18.910   266.199     0.150
    18.910   263.180     0.150
    19.188   265.598     0.150
    19.547   272.398     0.150
    19.547   268.430     0.150
    19.649   268.699     0.150
    19.868   271.000     0.150
    19.942   274.000     0.150
    19.982   271.898     0.150
    19.999   272.375     0.150
    19.999   272.500     0.150
    20.290   276.898     0.150
    20.221   281.699     0.150
    20.668   280.297     0.150
    20.668   279.699     0.150
    20.766   282.598     0.150
    20.766   282.457     0.150
    20.942   283.500     0.150
    21.274   291.000     0.150
    21.606   290.398     0.150
    21.658   291.809     0.150
    22.104   299.199     0.150
    22.247   298.898     0.150
    22.428   300.898     0.150
    22.546   303.398     0.150
    22.826   306.098     0.150
    23.071   307.699     0.150
    23.351   309.098     0.150
    23.351   311.000     0.150
    23.353   311.398     0.150
    23.420   312.699     0.150
    23.420   310.488     0.150
    23.482   311.898     0.150
    23.482   310.508     0.150
    23.679   312.719     0.150
    23.679   309.578     0.150
    23.656   312.898     0.150
    23.656   312.789     0.150
    23.736   313.898     0.150
    23.736   312.727     0.150
    23.961   315.668     0.150
    24.130   317.598     0.150
    24.134   319.598     0.150
    24.171   320.898     0.150
    24.227   320.297     0.150
    24.391   318.930     0.150
    24.604   323.000     0.150
    24.649   324.699     0.150
    24.812   324.500     0.150
    24.851   324.500     0.150
    25.193   330.598     0.150
    25.282   329.500     0.150
    25.282   327.898     0.150
    25.478   332.398     0.150
    25.767   332.402     0.150
    25.767   333.180     0.150
    25.854   332.656     0.150
    25.844   334.797     0.150
    25.865   332.598     0.150
    25.986   333.297     0.150
    25.985   334.508     0.150
    26.622   344.598     0.150
    26.863   342.297     0.150
    27.616   348.297     0.150
    27.616   347.848     0.150
    27.673   347.988     0.150
    27.737   349.199     0.150
    27.737   349.098     0.150
    27.883   351.035     0.150
    27.883   348.922     0.150
    27.883   350.668     0.150
    28.008   355.500     0.150
    28.157   353.898     0.150
    28.157   640.000     0.150
    30.367   372.238     0.150
    30.786   376.398     0.150
    30.806   377.898     0.150
    31.346   380.500     0.150
    31.346   380.867     0.150
    31.351   379.547     0.150
    31.351   379.547     0.150
    31.351   380.699     0.150
    31.351   380.340     0.150
    31.355   381.188     0.150
    31.872   387.699     0.150
    31.872   454.199     0.150
    32.732   397.199     0.150
    33.924   404.043     0.150
    34.248   408.098     0.150
    34.738   410.469     0.150
    34.739   409.543     0.150
    34.739   411.129     0.150
    34.835   412.375     0.150
    34.835   412.000     0.150
    34.897   413.398     0.150
    34.897   411.688     0.150
    36.473   426.898     0.150
    39.386   451.199     0.150
    39.706   452.000     0.150
    40.454   459.699     0.150
    40.454   460.520     0.150
    40.646   459.359     0.150
    40.627   461.059     0.150
    40.627   461.059     0.150
    40.627   459.398     0.150
    41.235   466.367     0.150
    43.773   488.199     0.150
    44.004   488.379     0.150
    44.004   487.477     0.150
    44.818   494.422     0.150
    44.818   494.098     0.150
    44.818   495.457     0.150
    44.761   496.898     0.150
    46.134   504.168     0.150
    46.176   508.199     0.150
    48.066   522.000     0.150
    48.414   523.500     0.150
    51.010   542.898     0.150
    51.010   543.148     0.150
    51.010   543.148     0.150
    51.010   542.938     0.150
    51.200   543.898     0.150
    51.866   553.398     0.150
    51.866   995.898     0.150
    52.146   551.797     0.150
    52.177   551.000     0.150
    52.177   551.238     0.150
    52.562   555.297     0.150
    53.909   564.973     0.150
    53.909   563.438     0.150
    53.912   564.969     0.150
    54.057   567.797     0.150
    55.142   572.898     0.150
    55.142   573.238     0.150
    55.749   577.797     0.150
    55.859   579.699     0.150
    56.962   587.398     0.150
    56.962   586.199     0.150
    60.803   613.598     0.150
    60.803   613.477     0.150
    61.251   614.559     0.150
    63.828   632.949     0.150
    65.022   639.625     0.150
    65.022   641.617     0.150
    65.022   640.938     0.150
    65.730   645.359     0.150
    65.730   645.219     0.150
    68.331   810.199     0.150
    68.331  1203.898     0.150
    68.331  1463.797     0.150
    68.331   660.367     0.150
    68.937   665.328     0.150
    75.686   706.297     0.150
    76.130   707.598     0.150
    76.459   710.199     0.150
    76.996   713.199     0.150
    76.996   713.008     0.150
    77.549   716.699     0.150
    77.818   717.508     0.150
    78.938   723.957     0.150
    79.086   725.699     0.150
    79.156   724.297     0.150
    79.160   724.199     0.150
    79.248   724.398     0.150
    79.849   729.098     0.150
    80.515   731.898     0.150
    80.696   734.621     0.150
    80.696   733.199     0.150
    81.436   737.719     0.150
    81.666   738.930     0.150
    83.071   746.297     0.150
    83.112   747.137     0.150
    83.463   748.688     0.150
    83.635   750.109     0.150
    83.763   748.969     0.150
    83.763   748.973     0.150
    84.072   753.000     0.150
    84.072   753.000     0.150
    84.072   752.719     0.150
    84.507   753.598     0.150
    84.634   753.047     0.150
    84.661   754.430     0.150
    84.872   755.199     0.150
    85.164   756.797     0.150
    85.164   756.824     0.150
    85.164   757.699     0.150
    85.164   756.660     0.150
    85.403   757.297     0.150
    85.439   759.297     0.150
    85.458   758.906     0.150
    85.458   758.098     0.150
    85.458   758.289     0.150
    85.458   757.598     0.150
    86.872   765.270     0.150
    87.054   769.098     0.150
    88.655   772.848     0.150
    92.104   790.438     0.150
    92.104   790.441     0.150
    92.544   794.598     0.150
   118.372  1128.098     0.150
   118.373  1128.098     0.150
   119.682  1131.297     0.150
   119.682  1131.273     0.150
   146.693  1182.750     0.150
   146.693  1181.199     0.150
     0.249     5.074     0.150
     0.249     9.375     0.150
     0.495    10.195     0.150
     0.495    18.105     0.150
     0.728    13.535     0.150
     0.728    23.914     0.150
     1.114    20.547     0.150
     1.114    35.656     0.150
     1.313    23.316     0.150
     1.313    43.457     0.150
     1.380    24.246     0.150
     1.380    43.406     0.150
     1.618    27.176     0.150
     1.684    28.965     0.150
     1.829    30.496     0.150
     1.829    57.164     0.150
     2.002    33.156     0.150
     2.105    34.906     0.150
     2.105    65.258     0.150
     2.057    35.145     0.150
     2.290    37.098     0.150
     2.290    69.848     0.150
     2.518    40.527     0.150
     2.518    72.016     0.150
     2.625    44.145     0.150
     2.805    45.047     0.150
     2.805    79.164     0.150
     3.027    48.117     0.150
     3.027   100.387     0.150
     3.002    47.906     0.150
     3.002   100.777     0.150
     3.120    49.145     0.150
     3.092    50.406     0.150
     3.092    91.098     0.150
     3.187    56.246     0.150
     3.240    51.207     0.150
     3.240    52.406     0.150
     3.268    51.867     0.150
     3.268    91.566     0.150
     3.694    58.125     0.150
     4.356    64.875     0.150
     4.853    74.605     0.150
     5.119    80.609     0.150
     8.165   119.395     0.150
     8.636   127.586     0.150
     9.048   132.086     0.150
     9.287   135.086     0.150
     9.602   139.688     0.150
     9.602   137.215     0.150
    10.679   155.285     0.150
    10.696   155.887     0.150
    10.953   158.387     0.150
    12.955   185.762     0.150
    13.188   189.887     0.150
    13.403   192.586     0.150
    13.403   191.375     0.150
    13.846   197.457     0.150
    14.038   203.688     0.150
    14.038   200.484     0.150
    14.079   199.887     0.150
    14.411   207.586     0.150
    15.026   213.957     0.150
    15.090   213.430     0.150
    15.090   220.090     0.150
    15.090   213.086     0.150
    15.186   216.484     0.150
    15.186   217.977     0.150
    15.297   219.586     0.150
    15.392   220.086     0.150
    15.435   219.086     0.150
    15.477   222.195     0.150
    15.536   221.586     0.150
    15.536   222.676     0.150
    15.526   222.246     0.150
    16.248   226.387     0.150
    16.248   411.688     0.150
    16.474   231.586     0.150
    17.626   245.758     0.150
    18.241   253.195     0.150
    18.402   255.887     0.150
    18.561   259.586     0.150
    18.561   257.625     0.150
    18.987   262.887     0.150
    19.276   266.086     0.150
    19.313   266.086     0.150
    19.313   266.746     0.150
    19.479   267.586     0.150
    19.524   268.086     0.150
    19.643   268.586     0.150
    19.751   270.484     0.150
    19.751   271.484     0.150
    19.863   272.285     0.150
    19.904   276.984     0.150
    20.058   273.484     0.150
    20.129   275.688     0.150
    20.212   275.887     0.150
    20.337   277.785     0.150
    20.337   276.027     0.150
    20.508   280.785     0.150
    20.503   279.086     0.150
    20.810   282.586     0.150
    20.896   283.285     0.150
    20.896   284.688     0.150
    20.882   282.785     0.150
    21.150   287.086     0.150
    21.150   287.586     0.150
    21.150   286.145     0.150
    21.169   286.387     0.150
    21.464   289.688     0.150
    21.501   289.586     0.150
    21.529   292.188     0.150
    21.643   291.785     0.150
    21.750   293.586     0.150
    21.798   290.785     0.150
    21.859   293.785     0.150
    21.966   293.785     0.150
    22.214   296.867     0.150
    22.344   300.188     0.150
    22.487   301.984     0.150
    22.559   302.785     0.150
    22.559   300.625     0.150
    22.699   301.688     0.150
    22.876   304.586     0.150
    22.991   305.586     0.150
    22.991   304.125     0.150
    23.075   306.586     0.150
    23.075   305.484     0.150
    23.172   308.586     0.150
    23.172   307.008     0.150
    23.249   308.086     0.150
    23.249   305.586     0.150
    23.442   310.887     0.150
    23.586   308.547     0.150
    23.612   310.785     0.150
    23.625   312.484     0.150
    23.709   312.887     0.150
    23.730   312.984     0.150
    24.093   315.285     0.150
    24.093   316.484     0.150
    24.303   316.984     0.150
    24.283   317.785     0.150
    24.342   318.285     0.150
    24.365   317.637     0.150
    24.470   317.586     0.150
    24.497   320.086     0.150
    24.837   324.785     0.150
    24.859   324.984     0.150
    24.859   322.355     0.150
    24.887   324.285     0.150
    24.966   324.785     0.150
    24.963   325.188     0.150
    24.966   323.586     0.150
    25.039   325.188     0.150
    25.092   324.887     0.150
    25.092   602.586     0.150
    25.092   647.387     0.150
    25.333   326.785     0.150
    25.443   329.438     0.150
    25.443   328.395     0.150
    25.443   539.836     0.150
    25.443   328.285     0.150
    25.443   539.836     0.150
    25.443   327.785     0.150
    25.488   328.438     0.150
    25.488   328.188     0.150
    25.488   328.227     0.150
    25.542   329.887     0.150
    25.546   329.332     0.150
    25.546   328.586     0.150
    25.700   328.766     0.150
    26.290   338.285     0.150
    26.372   334.887     0.150
    26.751   339.688     0.150
    26.796   340.984     0.150
    26.999   342.188     0.150
    27.009   341.984     0.150
    27.523   346.586     0.150
    27.668   346.785     0.150
    27.668   346.098     0.150
    27.747   348.387     0.150
    27.747   348.086     0.150
    27.913   350.328     0.150
    27.970   350.324     0.150
    28.057   351.285     0.150
    28.065   351.188     0.150
    28.065   636.688     0.150
    28.333   352.547     0.150
    28.363   354.285     0.150
    30.146   368.156     0.150
    30.146   367.887     0.150
    30.390   370.605     0.150
    30.465   371.465     0.150
    30.955   377.586     0.150
    31.264   378.688     0.150
    31.264   377.574     0.150
    31.269   377.734     0.150
    31.269   552.438     0.150
    31.269   377.734     0.150
    31.269   552.438     0.150
    31.269   377.484     0.150
    31.273   377.855     0.150
    31.271   377.438     0.150
    31.271   379.164     0.150
    32.831   395.586     0.150
    33.992   403.895     0.150
    33.992   403.285     0.150
    33.992   403.586     0.150
    34.035   405.086     0.150
    34.035   726.188     0.150
    34.094   402.086     0.150
    34.631   407.297     0.150
    34.631   561.785     0.150
    34.631   785.234     0.150
    34.631   407.785     0.150
    34.631   561.785     0.150
    34.631   785.234     0.150
    34.631   407.387     0.150
    35.156   414.160     0.150
    35.156   413.586     0.150
    35.195   414.484     0.150
    36.440   425.586     0.150
    38.062   437.938     0.150
    38.122   439.887     0.150
    38.222   440.688     0.150
    38.917   446.785     0.150
    39.202   446.016     0.150
    39.496   451.785     0.150
    39.597   450.484     0.150
    40.011   454.312     0.150
    40.011   579.188     0.150
    40.011   454.188     0.150
    40.121   456.188     0.150
    40.134   456.086     0.150
    40.300   457.586     0.150
    40.388   458.387     0.150
    40.447   457.164     0.150
    40.552   460.703     0.150
    40.552   458.387     0.150
    40.719   460.277     0.150
    40.719   460.277     0.150
    40.719   459.984     0.150
    40.907   462.484     0.150
    41.751   469.688     0.150
    42.487   475.188     0.150
    42.796   476.188     0.150
    43.884   485.277     0.150
    43.924   485.727     0.150
    43.931   484.984     0.150
    44.040   485.688     0.150
    44.387   491.586     0.150
    44.757   492.285     0.150
    44.757   492.387     0.150
    45.776   502.086     0.150
    46.106   505.387     0.150
    46.106   503.785     0.150
    48.105   519.664     0.150
    48.601   523.285     0.150
    50.779   538.586     0.150
    50.903   540.586     0.150
    50.943   541.688     0.150
    50.943   541.047     0.150
    50.943   541.688     0.150
    50.943   616.348     0.150
    50.943   541.688     0.150
    50.943   616.344     0.150
    50.943   540.887     0.150
    51.132   542.387     0.150
    51.273   541.984     0.150
    51.282   544.074     0.150
    51.285   544.074     0.150
    51.704   549.887     0.150
    51.918   549.324     0.150
    51.918   548.785     0.150
    52.419   552.688     0.150
    52.448   551.285     0.150
    52.533   553.406     0.150
    53.620   562.734     0.150
    53.751   564.027     0.150
    53.888   564.086     0.150
    53.918   562.961     0.150
    53.918   561.688     0.150
    53.921   562.965     0.150
    53.921   564.305     0.150
    53.921   564.887     0.150
    53.921   563.535     0.150
    54.163   565.758     0.150
    54.279   568.055     0.150
    54.419   568.324     0.150
    55.097   572.062     0.150
    55.098   571.805     0.150
    55.098   571.484     0.150
    55.098   570.777     0.150
    55.521   575.188     0.150
    55.622   574.188     0.150
    56.819   583.586     0.150
    56.819   583.586     0.150
    56.819   583.707     0.150
    57.055   586.062     0.150
    57.554   588.785     0.150
    60.683   610.887     0.150
    60.683   610.875     0.150
    60.755   611.953     0.150
    60.755   611.188     0.150
    60.755   610.996     0.150
    61.013   613.258     0.150
    62.007   618.785     0.150
    62.996   626.285     0.150
    63.315   628.410     0.150
    63.315   628.578     0.150
    63.781   632.113     0.150
    63.797   631.961     0.150
    63.849   633.090     0.150
    63.931   632.824     0.150
    63.960   632.285     0.150
    64.530   636.664     0.150
    64.632   638.008     0.150
    64.764   668.785     0.150
    64.764   780.586     0.150
    64.810   639.605     0.150
    64.810   639.387     0.150
    64.810   638.996     0.150
    65.255   642.039     0.150
    65.475   643.754     0.150
    65.549   643.125     0.150
    65.626   642.984     0.150
    65.626   642.797     0.150
    65.680   644.480     0.150
    66.232   648.984     0.150
    66.343   649.469     0.150
    66.893   652.816     0.150
    67.114   653.012     0.150
    67.308   654.188     0.150
    68.001   658.535     0.150
    68.311   660.348     0.150
    68.291   659.754     0.150
    68.291   685.984     0.150
    68.291  1199.887     0.150
    68.291  1462.586     0.150
    68.291   659.156     0.150
    68.374   660.102     0.150
    68.487   662.484     0.150
    68.978   664.625     0.150
    69.052   664.816     0.150
    75.337   703.984     0.150
    75.337   703.098     0.150
    75.358   702.688     0.150
    75.834   703.887     0.150
    75.956   704.984     0.150
    76.272   708.387     0.150
    76.682   710.586     0.150
    76.832   711.785     0.150
    76.832   711.215     0.150
    77.449   713.387     0.150
    78.228   718.938     0.150
    78.582   721.430     0.150
    78.582   721.188     0.150
    78.582   720.977     0.150
    78.984   721.387     0.150
    79.056   722.387     0.150
    79.161   722.688     0.150
    79.357   724.957     0.150
    79.387   725.215     0.150
    79.461   725.188     0.150
    79.673   726.438     0.150
    79.671   727.984     0.150
    79.820   725.586     0.150
    79.898   728.574     0.150
    79.898   728.758     0.150
    80.180   729.246     0.150
    80.260   729.086     0.150
    80.270   729.387     0.150
    80.319   729.285     0.150
    80.351   730.324     0.150
    80.451   730.688     0.150
    80.451   736.887     0.150
    80.451   915.586     0.150
    80.451  1647.586     0.150
    80.558   737.387     0.150
    80.558  1646.188     0.150
    80.591   731.477     0.150
    80.611   731.727     0.150
    80.630   731.688     0.150
    80.694   731.984     0.150
    80.725   732.305     0.150
    80.858   733.422     0.150
    81.005   734.066     0.150
    81.105   734.086     0.150
    81.109   734.215     0.150
    81.109   733.785     0.150
    81.112   733.375     0.150
    81.112   733.387     0.150
    81.660   738.066     0.150
    81.836   739.145     0.150
    81.878   738.086     0.150
    82.086   739.367     0.150
    82.442   741.258     0.150
    82.677   743.105     0.150
    82.892   744.586     0.150
    83.197   746.266     0.150
    83.224   746.234     0.150
    83.374   746.996     0.150
    83.405   748.117     0.150
    83.535   747.734     0.150
    83.550   747.066     0.150
    83.570   747.527     0.150
    83.834   748.465     0.150
    83.834   748.461     0.150
    83.896   750.035     0.150
    83.877   748.984     0.150
    83.877   749.387     0.150
    83.877   748.785     0.150
    83.877   748.984     0.150
    83.877   748.688     0.150
    83.962   750.457     0.150
    84.068   750.945     0.150
    84.503   752.586     0.150
    84.738   754.324     0.150
    84.762   753.715     0.150
    85.065   754.090     0.150
    85.065   754.984     0.150
    85.163   754.285     0.150
    85.163   754.309     0.150
    85.359   755.562     0.150
    85.359   755.188     0.150
    85.412   755.984     0.150
    85.794   758.484     0.150
    85.794   758.188     0.150
    85.933   760.234     0.150
    86.566   762.086     0.150
    86.597   764.387     0.150
    86.597   765.406     0.150
    86.597   765.086     0.150
    86.597   762.574     0.150
    87.225   765.906     0.150
    88.254   768.176     0.150
    88.501   770.586     0.150
    88.535   771.387     0.150
    88.668   771.176     0.150
    89.837   775.984     0.150
    90.132   779.887     0.150
    90.196   779.387     0.150
    92.119   786.887     0.150
    92.119   787.188     0.150
    92.119   787.188     0.150
    92.441   790.586     0.150
    95.351   803.480     0.150
    95.351   803.484     0.150
    95.506   804.188     0.150
    95.535   803.484     0.150
    95.535   803.500     0.150
    95.535   802.586     0.150
   118.036  1125.426     0.150
   118.036  1125.426     0.150
   118.036  1124.348     0.150
   120.181  1130.688     0.150
   120.181  1130.648     0.150
   122.790  1135.125     0.150
   125.663  1139.984     0.150
   146.618  1180.410     0.150
   146.618  1180.188     0.150
   147.317  1179.598     0.150
   150.081  1189.785     0.150
   151.297  1191.688     0.150
   163.410  1251.188     0.150
   166.810  1205.660     0.150
     0.207     4.398     0.150
     0.207     8.098     0.150
     0.771    14.129     0.150
     0.771    25.207     0.150
     0.787    15.117     0.150
     0.787    26.988     0.150
     1.024    19.246     0.150
     1.024    35.117     0.150
     1.153    21.707     0.150
     1.612    28.438     0.150
     1.612    53.047     0.150
     1.691    30.680     0.150
     1.765    29.859     0.150
     1.794    31.238     0.150
     1.874    31.746     0.150
     1.953    33.066     0.150
     2.318    38.039     0.150
     2.359    39.387     0.150
     3.019    50.258     0.150
     3.019    87.688     0.150
     3.415    59.020     0.150
     3.415    97.707     0.150
     4.057    62.988     0.150
     8.467   125.668     0.150
    13.500   193.316     0.150
    19.621   267.793     0.150
    21.473   291.656     0.150
    23.351   309.168     0.150
    23.539   310.656     0.150
    25.494   326.449     0.150
    25.838   330.594     0.150
    25.837   332.027     0.150
    25.856   332.770     0.150
    27.511   345.668     0.150
    27.511   345.809     0.150
    31.009   374.367     0.150
    31.018   374.457     0.150
    34.392   406.898     0.150
    34.393   406.898     0.150
    34.395   407.609     0.150
    35.216   415.781     0.150
    51.280   544.598     0.150
    51.280   544.594     0.150
    51.280   543.969     0.150
    52.315   552.008     0.150
    55.424   573.770     0.150
    55.918   578.477     0.150
    56.061   578.680     0.150
    57.189   586.797     0.150
    65.203   641.832     0.150
    65.203   641.438     0.150
    65.203   642.098     0.150
    81.060   734.762     0.150
    84.265   752.598     0.150
    84.265   752.598     0.150
    85.711   758.449     0.150
    85.774   759.617     0.150
   118.450  1126.332     0.150
   118.451  1126.328     0.150
     0.086     2.758     0.150
     0.086     6.316     0.150
     0.729    14.688     0.150
     0.729    25.617     0.150
     0.690    12.465     0.150
     0.690    23.926     0.150
     2.975    49.008     0.150
     3.024    51.117     0.150
     3.024    49.746     0.150
     3.238    95.387     0.150
     8.419   119.324     0.150
     8.975   131.246     0.150
     8.991   133.547     0.150
     9.298   137.645     0.150
     9.440   138.348     0.150
     9.440   136.918     0.150
    10.657   156.547     0.150
    10.707   157.348     0.150
    10.801   156.547     0.150
    12.727   181.547     0.150
    13.402   190.227     0.150
    14.118   203.348     0.150
    14.781   209.246     0.150
    16.523   231.348     0.150
    16.523   412.145     0.150
    17.605   247.270     0.150
    18.217   251.996     0.150
    18.387   256.246     0.150
    18.714   256.848     0.150
    18.865   262.645     0.150
    18.973   261.758     0.150
    19.255   264.645     0.150
    19.255   266.016     0.150
    19.662   269.945     0.150
    20.233   274.145     0.150
    20.617   278.223     0.150
    22.270   299.746     0.150
    22.645   301.547     0.150
    22.645   554.047     0.150
    22.805   303.348     0.150
    23.175   307.047     0.150
    23.280   305.457     0.150
    23.378   309.246     0.150
    23.378   307.215     0.150
    23.464   309.297     0.150
    24.011   315.145     0.150
    24.038   316.047     0.150
    24.288   316.645     0.150
    24.322   316.246     0.150
    24.570   318.848     0.150
    24.589   321.145     0.150
    24.565   319.645     0.150
    24.801   322.547     0.150
    25.086   324.445     0.150
    25.215   324.848     0.150
    25.273   328.848     0.150
    25.341   327.645     0.150
    25.357   325.746     0.150
    25.592   328.207     0.150
    25.594   328.348     0.150
    25.771   330.121     0.150
    25.771   329.246     0.150
    25.770   329.266     0.150
    25.743   329.746     0.150
    25.743   537.086     0.150
    25.743   331.145     0.150
    25.743   329.645     0.150
    25.845   330.348     0.150
    26.660   336.645     0.150
    26.810   339.547     0.150
    27.091   342.746     0.150
    27.269   342.047     0.150
    27.297   343.047     0.150
    27.598   344.766     0.150
    27.815   347.047     0.150
    27.930   349.246     0.150
    28.342   351.945     0.150
    28.294   352.246     0.150
    31.115   378.547     0.150
    31.115   378.105     0.150
    31.121   375.027     0.150
    31.120   375.020     0.150
    31.064   377.645     0.150
    32.044   388.047     0.150
    34.277   405.547     0.150
    34.496   406.168     0.150
    34.497   405.625     0.150
    34.497   405.945     0.150
    35.151   414.383     0.150
    36.643   427.047     0.150
    38.406   441.945     0.150
    38.508   442.246     0.150
    39.210   447.027     0.150
    39.203   448.547     0.150
    39.780   453.348     0.150
    40.018   454.121     0.150
    40.018   453.645     0.150
    40.367   456.445     0.150
    40.407   457.746     0.150
    40.419   457.746     0.150
    40.585   459.246     0.150
    40.673   460.348     0.150
    40.690   460.047     0.150
    40.860   461.445     0.150
    40.860   461.445     0.150
    40.860   460.848     0.150
    41.192   464.047     0.150
    42.036   471.445     0.150
    42.790   475.945     0.150
    44.074   488.246     0.150
    44.598   488.723     0.150
    44.598   492.348     0.150
    46.326   507.246     0.150
    47.898   517.105     0.150
    48.687   523.145     0.150
    51.162   542.445     0.150
    51.162   542.395     0.150
    51.162   616.598     0.150
    51.162   542.398     0.150
    51.162   616.598     0.150
    51.195   544.547     0.150
    51.351   543.746     0.150
    51.960   551.246     0.150
    51.960   992.246     0.150
    52.141   550.645     0.150
    52.195   550.145     0.150
    52.480   549.645     0.150
    52.668   554.445     0.150
    54.103   563.043     0.150
    54.103   562.926     0.150
    54.105   563.047     0.150
    54.167   565.047     0.150
    54.167   564.316     0.150
    55.306   572.547     0.150
    55.306   571.984     0.150
    55.798   575.945     0.150
    55.881   577.145     0.150
    55.940   577.156     0.150
    57.068   584.746     0.150
    57.068   585.047     0.150
    57.068   584.785     0.150
    60.965   611.848     0.150
    60.965   611.367     0.150
    61.293   613.977     0.150
    64.080   632.098     0.150
    64.172   669.895     0.150
    64.278   665.918     0.150
    65.083   640.285     0.150
    65.083   640.066     0.150
    65.083   640.395     0.150
    65.860   643.887     0.150
    68.498   659.645     0.150
    68.498  1200.547     0.150
    68.498  1463.445     0.150
    68.498   660.035     0.150
    68.709   688.926     0.150
    75.605   705.145     0.150
    75.659   703.645     0.150
    76.216   705.445     0.150
    76.939   710.797     0.150
    77.088   712.848     0.150
    77.682   713.848     0.150
    79.217   721.945     0.150
    79.388   723.145     0.150
    81.025   733.688     0.150
    81.025   733.688     0.150
    81.764   737.848     0.150
    83.441   746.168     0.150
    83.963   749.305     0.150
    83.987   748.297     0.150
    84.144   749.277     0.150
    84.144   748.445     0.150
    84.144   749.277     0.150
    84.144   749.746     0.150
    84.144   748.477     0.150
    85.041   752.734     0.150
    85.353   754.547     0.150
    85.353   754.500     0.150
    85.591   755.570     0.150
    85.591   755.445     0.150
    85.591   755.547     0.150
    85.730   756.297     0.150
    86.899   763.723     0.150
    90.367   781.746     0.150
    92.675   791.348     0.150
    95.260   801.246     0.150
   110.137  1108.109     0.150
   118.338  1124.223     0.150
   118.338  1125.305     0.150
   118.339  1124.215     0.150
   119.988  1129.188     0.150
   119.988  1129.188     0.150
   146.468  1178.473     0.150
     0.250     5.195     0.150
     0.250     9.395     0.150
     0.557    10.875     0.150
     0.557    19.273     0.150
     0.655    11.973     0.150
     0.655    22.266     0.150
     1.195    21.684     0.150
     1.195    37.336     0.150
     1.280    24.023     0.150
     1.280    43.246     0.150
     1.331    23.516     0.150
     1.331    41.855     0.150
     1.615    28.473     0.150
     1.910    31.234     0.150
     1.910    55.555     0.150
     1.987    34.195     0.150
     3.027    52.445     0.150
     3.027    87.984     0.150
     8.207   120.812     0.150
    17.546   242.504     0.150
    19.831   271.086     0.150
    23.660   308.984     0.150
    25.418   329.543     0.150
    25.777   331.223     0.150
    27.748   347.211     0.150
    31.343   378.656     0.150
    31.343   378.660     0.150
    34.707   408.484     0.150
    50.882   540.305     0.150
    50.882   541.184     0.150
    50.882   541.184     0.150
    50.882   540.543     0.150
    51.877   547.855     0.150
    53.850   560.984     0.150
    53.853   560.984     0.150
    55.034   570.609     0.150
    55.034   570.895     0.150
    55.480   574.836     0.150
     0.305     6.484     0.150
     0.305    10.492     0.150
     0.397     7.852     0.150
     0.397    13.984     0.150
     0.815    15.094     0.150
     0.815    27.402     0.150
     0.998    19.062     0.150
     0.998    34.285     0.150
     1.240    22.133     0.150
     1.240    42.062     0.150
     1.526    26.613     0.150
     1.526    45.812     0.150
     1.508    28.012     0.150
     1.593    27.734     0.150
     1.593    46.883     0.150
     1.604    27.832     0.150
     1.604    49.422     0.150
     1.812    30.164     0.150
     1.812    55.453     0.150
     2.072    35.164     0.150
     2.145    35.742     0.150
     2.145    66.152     0.150
     2.172    35.992     0.150
     2.172    65.082     0.150
     2.265    37.102     0.150
     2.265    68.223     0.150
     2.585    42.312     0.150
     2.585    74.133     0.150
     2.634    41.254     0.150
     2.634    85.805     0.150
     2.696    43.184     0.150
     2.859    46.395     0.150
     2.859    80.695     0.150
     3.075    48.754     0.150
     3.075   100.742     0.150
     3.128    49.242     0.150
     3.128    86.375     0.150
     3.138    50.602     0.150
     3.138    88.402     0.150
     3.170    52.504     0.150
     3.170    98.883     0.150
     3.214    52.195     0.150
     3.214    89.992     0.150
     3.214    50.434     0.150
     3.421    51.344     0.150
     3.565    55.465     0.150
     3.565   101.133     0.150
     3.636    61.484     0.150
     3.676    55.773     0.150
     3.828    59.754     0.150
     3.828   110.523     0.150
     4.125    66.113     0.150
     4.125   114.773     0.150
     4.137    62.223     0.150
     4.256    62.703     0.150
     4.256   114.703     0.150
     4.314    66.074     0.150
     4.314   115.293     0.150
     4.729    70.395     0.150
     8.673   124.484     0.150
     9.673   139.523     0.150
     9.673   137.172     0.150
    10.973   156.203     0.150
    12.053   168.625     0.150
    13.426   188.523     0.150
    13.562   194.523     0.150
    13.911   199.805     0.150
    14.139   198.422     0.150
    15.897   228.422     0.150
    18.530   255.402     0.150
    18.704   261.523     0.150
    18.790   260.625     0.150
    18.899   263.523     0.150
    18.899   263.043     0.150
    19.555   271.523     0.150
    19.555   267.094     0.150
    19.872   272.625     0.150
    19.988   277.824     0.150
    20.006   273.023     0.150
    20.006   273.223     0.150
    20.634   279.125     0.150
    20.680   280.223     0.150
    21.275   291.324     0.150
    21.652   292.523     0.150
    21.652   291.312     0.150
    21.967   296.723     0.150
    22.240   297.523     0.150
    22.308   300.223     0.150
    22.826   306.422     0.150
    23.409   310.422     0.150
    23.409   308.895     0.150
    23.475   310.523     0.150
    23.475   308.305     0.150
    23.649   312.523     0.150
    23.649   311.824     0.150
    23.689   309.965     0.150
    23.735   313.715     0.150
    24.118   317.125     0.150
    24.124   317.023     0.150
    24.163   317.422     0.150
    24.601   323.824     0.150
    24.807   323.125     0.150
    24.807   321.785     0.150
    25.182   326.523     0.150
    25.316   328.324     0.150
    25.756   330.984     0.150
    25.756   330.922     0.150
    25.756   541.172     0.150
    25.756   330.453     0.150
    25.839   332.922     0.150
    25.863   332.055     0.150
    25.979   333.172     0.150
    25.978   332.902     0.150
    26.856   340.324     0.150
    27.610   347.074     0.150
    27.727   348.324     0.150
    27.891   348.449     0.150
    27.891   348.984     0.150
    30.378   370.672     0.150
    31.355   379.922     0.150
    31.355   378.734     0.150
    31.361   552.074     0.150
    31.361   378.473     0.150
    31.361   552.074     0.150
    31.361   378.824     0.150
    31.365   378.395     0.150
    31.861   387.125     0.150
    34.237   405.125     0.150
    34.747   409.242     0.150
    34.748   409.023     0.150
    34.748   561.422     0.150
    34.830   411.199     0.150
    34.830   410.023     0.150
    34.850   412.223     0.150
    36.462   425.922     0.150
    36.477   425.422     0.150
    36.973   429.223     0.150
    36.973   426.023     0.150
    38.363   441.922     0.150
    38.470   442.523     0.150
    39.167   448.422     0.150
    39.532   448.543     0.150
    39.700   452.023     0.150
    39.739   453.625     0.150
    40.368   458.023     0.150
    40.380   457.922     0.150
    40.545   459.324     0.150
    40.617   459.805     0.150
    40.617   459.312     0.150
    40.635   460.324     0.150
    41.152   464.125     0.150
    41.995   471.324     0.150
    43.766   484.824     0.150
    44.013   486.133     0.150
    44.750   493.523     0.150
    44.828   492.797     0.150
    50.999   541.422     0.150
    50.999   542.098     0.150
    50.999   541.512     0.150
    51.188   542.523     0.150
    51.855   551.824     0.150
    51.855   993.824     0.150
    52.134   550.625     0.150
    52.170   548.523     0.150
    52.336   551.922     0.150
    52.336   551.793     0.150
    53.899   562.344     0.150
    53.899   562.223     0.150
    53.899   561.152     0.150
    55.131   572.023     0.150
    55.131   571.543     0.150
    55.737   576.223     0.150
    55.848   577.125     0.150
    56.950   584.922     0.150
    56.950   584.523     0.150
    56.950   584.812     0.150
    60.791   611.324     0.150
    61.742   616.922     0.150
    63.819   631.074     0.150
    65.010   640.625     0.150
    65.010   638.812     0.150
    65.719   643.715     0.150
    65.719   643.383     0.150
    68.319   659.523     0.150
    68.319   659.672     0.150
    75.675   704.824     0.150
    76.984   714.023     0.150
    77.538   715.922     0.150
    79.237   724.625     0.150
    80.503   732.723     0.150
    80.503   917.324     0.150
    80.693   731.594     0.150
    81.432   736.004     0.150
    83.753   747.797     0.150
    84.061   749.875     0.150
    85.154   754.473     0.150
    85.154   755.023     0.150
    85.428   755.625     0.150
    85.446   755.898     0.150
    85.446   755.672     0.150
    87.046   766.098     0.150
    87.046   765.723     0.150
    88.640   770.461     0.150
    95.097   800.523     0.150
   101.133   828.125     0.150
   118.361  1126.574     0.150
   118.362  1126.574     0.150
   119.684  1129.824     0.150
   119.684  1129.773     0.150
   146.703  1180.824     0.150
   146.703  1180.422     0.150
   166.554  1206.422     0.150
   166.554  1270.547     0.150
     0.186     4.492     0.150
     0.186     6.703     0.150
     0.606    11.539     0.150
     0.606    20.594     0.150
     0.619    11.945     0.150
     0.619    21.586     0.150
     1.206    22.383     0.150
     1.206    40.523     0.150
     1.227    22.094     0.150
     1.227    38.719     0.150
     1.378    24.156     0.150
     1.378    42.734     0.150
     1.560    26.883     0.150
     1.877    30.617     0.150
     1.877    52.922     0.150
     1.935    32.109     0.150
     1.935    58.203     0.150
     2.006    33.805     0.150
     2.064    34.625     0.150
     2.064    63.695     0.150
     2.317    37.289     0.150
     2.317    68.883     0.150
     2.501    41.625     0.150
     2.501    76.367     0.150
     2.592    41.547     0.150
     2.841    44.898     0.150
     2.841    79.805     0.150
     2.885    42.984     0.150
     2.885    87.344     0.150
     3.270    51.883     0.150
    23.089   305.664     0.150
    23.266   307.625     0.150
    25.480   329.219     0.150
    25.777   331.234     0.150
    34.699   408.289     0.150
    34.700   408.266     0.150
    38.139   439.719     0.150
    38.241   440.117     0.150
    38.937   446.516     0.150
    39.514   451.414     0.150
    40.140   455.719     0.150
    40.152   455.617     0.150
    40.318   457.312     0.150
    40.407   458.117     0.150
    40.653   459.828     0.150
    40.653   459.820     0.150
    49.990   532.344     0.150
    50.913   541.438     0.150
    50.913   616.039     0.150
    50.913   541.438     0.150
    50.913   616.039     0.150
    51.101   541.992     0.150
    51.928   548.492     0.150
    53.223   556.492     0.150
    53.870   562.188     0.150
    53.873   562.188     0.150
    55.062   571.383     0.150
    55.531   574.336     0.150
    81.717   738.562     0.150
    81.965   738.758     0.150
    82.691   743.164     0.150
    83.252   747.016     0.150
    83.283   746.164     0.150
    83.413   747.289     0.150
    83.447   746.969     0.150
    83.773   749.367     0.150
    83.879   748.969     0.150
    83.879   748.969     0.150
    83.946   750.133     0.150
    85.337   754.742     0.150
     0.981    32.289     0.150
     1.538    23.438     0.150
     1.538    44.359     0.150
     1.500    23.766     0.150
     1.500    44.266     0.150
     1.582    24.109     0.150
     1.582    46.156     0.150
     1.605    47.539     0.150
     1.833    27.547     0.150
     2.056    31.586     0.150
     2.157    32.672     0.150
     2.168    31.992     0.150
     2.277    34.031     0.150
     2.277    68.242     0.150
     2.575    39.211     0.150
     2.575    72.055     0.150
     2.636    39.359     0.150
     2.701    73.117     0.150
     3.085    45.789     0.150
     3.183    52.000     0.150
     3.227    48.195     0.150
     3.227    51.445     0.150
     3.227    50.461     0.150
     3.227    48.727     0.150
     3.427    48.750     0.150
     3.625   109.141     0.150
     3.691    53.289     0.150
     3.691   108.648     0.150
     4.111    59.695     0.150
     4.148   130.289     0.150
     4.707    66.688     0.150
     4.820    71.742     0.150
     6.255    89.445     0.150
     6.379    93.797     0.150
     8.654   120.609     0.150
     9.295   132.797     0.150
     9.684   136.641     0.150
    10.973   158.500     0.150
    10.973   155.906     0.150
    10.973   274.086     0.150
    11.029   159.797     0.150
    11.051   156.797     0.150
    12.059   165.195     0.150
    13.557   192.297     0.150
    13.869   194.695     0.150
    13.894   194.109     0.150
    14.090   197.281     0.150
    14.443   206.602     0.150
    14.765   213.500     0.150
    15.162   214.602     0.150
    15.162   210.469     0.150
    15.448   212.602     0.150
    15.503   218.398     0.150
    15.880   226.102     0.150
    18.531   255.195     0.150
    18.531   252.156     0.150
    18.704   256.195     0.150
    18.809   257.195     0.150
    18.877   256.711     0.150
    19.558   266.195     0.150
    19.558   265.938     0.150
    19.649   264.000     0.150
    19.866   268.195     0.150
    19.937   270.195     0.150
    19.985   269.000     0.150
    20.008   270.336     0.150
    20.008   270.102     0.150
    20.188   275.695     0.150
    20.700   276.898     0.150
    20.700   275.898     0.150
    20.760   280.398     0.150
    20.760   276.445     0.150
    21.225   283.219     0.150
    21.264   287.000     0.150
    21.597   289.500     0.150
    21.632   290.398     0.150
    21.632   286.008     0.150
    21.956   291.000     0.150
    22.094   294.297     0.150
    22.219   295.398     0.150
    22.255   295.109     0.150
    22.285   294.297     0.150
    22.407   296.695     0.150
    22.529   298.000     0.150
    22.813   301.898     0.150
    23.315   310.602     0.150
    23.336   307.117     0.150
    23.336   306.297     0.150
    23.387   306.797     0.150
    23.387   305.789     0.150
    23.453   306.398     0.150
    23.627   308.398     0.150
    23.698   307.281     0.150
    23.722   308.500     0.150
    23.722   307.727     0.150
    24.101   313.797     0.150
    24.101   313.102     0.150
    24.140   313.602     0.150
    24.211   314.398     0.150
    24.365   315.156     0.150
    24.576   318.797     0.150
    24.583   317.195     0.150
    24.616   318.500     0.150
    24.787   319.102     0.150
    24.831   321.898     0.150
    24.916   321.102     0.150
    24.957   320.602     0.150
    25.124   325.000     0.150
    25.160   323.297     0.150
    25.251   324.898     0.150
    25.251   323.797     0.150
    25.288   326.898     0.150
    25.298   325.102     0.150
    25.312   326.297     0.150
    25.455   325.898     0.150
    25.469   326.398     0.150
    25.734   329.641     0.150
    25.734   327.836     0.150
    25.734   328.352     0.150
    25.734   327.000     0.150
    25.828   329.797     0.150
    25.819   329.398     0.150
    25.832   328.602     0.150
    25.870   328.859     0.150
    25.958   329.797     0.150
    26.500   335.898     0.150
    26.589   339.000     0.150
    26.835   336.398     0.150
    27.237   339.102     0.150
    27.610   344.695     0.150
    27.610   344.062     0.150
    27.714   344.797     0.150
    27.714   343.898     0.150
    27.895   347.391     0.150
    29.978   364.195     0.150
    30.770   371.102     0.150
    30.770   439.102     0.150
    30.789   372.695     0.150
    31.365   377.102     0.150
    31.371   549.750     0.150
    31.371   375.297     0.150
    31.371   549.750     0.150
    31.371   376.117     0.150
    31.375   375.656     0.150
    31.605   378.109     0.150
    31.846   383.500     0.150
    32.713   392.695     0.150
    34.216   402.805     0.150
    34.216   402.695     0.150
    34.216   402.398     0.150
    34.757   406.102     0.150
    34.757   559.148     0.150
    34.757   405.867     0.150
    34.831   407.297     0.150
    34.831   408.078     0.150
    34.831   407.695     0.150
    34.890   407.375     0.150
    36.447   422.898     0.150
    36.458   423.797     0.150
    38.342   438.797     0.150
    38.449   439.398     0.150
    39.146   445.500     0.150
    39.374   445.500     0.150
    39.374   574.500     0.150
    39.700   448.859     0.150
    39.700   448.602     0.150
    39.718   450.500     0.150
    40.179   452.898     0.150
    40.347   454.602     0.150
    40.359   454.602     0.150
    40.434   454.695     0.150
    40.434   454.906     0.150
    40.524   456.398     0.150
    40.607   579.336     0.150
    40.607   457.125     0.150
    40.607   456.797     0.150
    40.614   457.195     0.150
    41.131   461.000     0.150
    41.974   468.195     0.150
    43.764   481.602     0.150
    43.764   581.500     0.150
    44.022   483.125     0.150
    44.728   490.398     0.150
    44.839   490.875     0.150
    46.149   502.898     0.150
    46.149   597.797     0.150
    46.149   501.695     0.150
    48.399   518.195     0.150
    50.983   538.797     0.150
    50.983   538.891     0.150
    50.987   538.500     0.150
    51.173   539.195     0.150
    51.836   548.000     0.150
    51.836   988.195     0.150
    52.114   547.523     0.150
    52.169   545.602     0.150
    53.886   559.227     0.150
    53.886   559.102     0.150
    53.886   558.570     0.150
    54.028   562.297     0.150
    54.028   561.711     0.150
    54.609   565.320     0.150
    55.116   569.195     0.150
    55.717   573.898     0.150
    55.829   572.672     0.150
    56.607   579.820     0.150
    56.700   580.102     0.150
    56.932   580.797     0.150
    56.932   580.602     0.150
    56.932   581.469     0.150
    57.614   585.898     0.150
    60.777   608.297     0.150
    60.777   607.539     0.150
    63.811   628.500     0.150
    64.828   635.805     0.150
    64.936   636.188     0.150
    64.990   637.359     0.150
    64.990   635.055     0.150
    64.990   634.367     0.150
    65.554   640.297     0.150
    65.702   639.898     0.150
    65.702   639.438     0.150
    65.702   639.820     0.150
    65.755   642.383     0.150
    65.902   642.812     0.150
    65.970   642.906     0.150
    65.970   643.047     0.150
    66.569   648.266     0.150
    66.633   647.898     0.150
    67.316   651.500     0.150
    67.953   656.250     0.150
    68.305  1194.195     0.150
    68.305   655.977     0.150
    68.338   657.891     0.150
    68.827   661.203     0.150
    68.965   661.992     0.150
    75.503   700.500     0.150
    75.653   701.773     0.150
    75.653   700.500     0.150
    75.814   701.102     0.150
    76.100   703.695     0.150
    76.428   704.695     0.150
    76.652   705.586     0.150
    76.966   709.297     0.150
    76.966   706.852     0.150
    77.521   711.398     0.150
    77.822   712.547     0.150
    78.942   719.516     0.150
    79.128   719.398     0.150
    80.488   727.500     0.150
    80.488   735.195     0.150
    80.488   913.797     0.150
    80.700   728.484     0.150
    81.438   733.789     0.150
    83.048   740.898     0.150
    83.117   742.742     0.150
    83.469   744.656     0.150
    83.641   744.617     0.150
    83.743   745.305     0.150
    84.484   748.695     0.150
    84.849   750.000     0.150
    84.964   751.367     0.150
    85.140   751.828     0.150
    85.414   754.000     0.150
    85.430   752.602     0.150
    85.430   753.102     0.150
    85.430   752.898     0.150
    85.441   753.398     0.150
    85.507   754.969     0.150
    86.799   760.195     0.150
    87.023   763.805     0.150
    87.023   763.414     0.150
    87.023   762.898     0.150
    87.023   761.891     0.150
    88.626   770.398     0.150
    92.080   784.000     0.150
    93.860   793.398     0.150
    94.951   797.945     0.150
    95.566   802.695     0.150
    95.597   802.320     0.150
   118.339  1123.453     0.150
   118.339  1122.680     0.150
   118.340  1123.445     0.150
   119.699  1126.695     0.150
   119.699  1126.719     0.150
   125.227  1135.195     0.150
   126.068  1138.148     0.150
   146.713  1178.070     0.150
   166.575  1203.969     0.150
   166.575  1265.906     0.150
     0.569    10.883     0.150
     0.569    19.211     0.150
     0.700    13.641     0.150
     0.700    25.062     0.150
     1.102    19.898     0.150
     1.102    36.297     0.150
     1.259    23.117     0.150
     1.259    39.992     0.150
     1.468    25.547     0.150
     1.468    45.188     0.150
     1.502    26.414     0.150
     1.502    49.000     0.150
     1.574    25.328     0.150
     1.807    30.508     0.150
     1.807    53.852     0.150
     1.962    32.930     0.150
     1.962    58.422     0.150
     1.952    32.508     0.150
     1.952    60.258     0.150
     2.062    34.711     0.150
     2.313    37.289     0.150
     2.313    69.992     0.150
     2.429    39.070     0.150
     2.429    75.703     0.150
     2.853    44.992     0.150
     3.023    48.297     0.150
     3.023    93.047     0.150
     2.944    46.461     0.150
     2.944    83.703     0.150
     3.156    55.203     0.150
     3.205    51.914     0.150
     3.205    52.742     0.150
     3.205    53.992     0.150
     3.205    53.070     0.150
     3.115    48.250     0.150
     3.115    86.164     0.150
     3.310    50.203     0.150
     3.310    93.609     0.150
     3.296    51.414     0.150
     3.296   101.641     0.150
     3.709    56.133     0.150
     3.702    58.578     0.150
     3.755    58.320     0.150
     3.755   100.297     0.150
     3.820    57.047     0.150
     3.820   101.258     0.150
     4.101    61.961     0.150
     4.101   128.102     0.150
     4.140    63.164     0.150
     4.178    63.742     0.150
     4.321    63.812     0.150
     4.536    67.602     0.150
     4.536   118.258     0.150
     4.852    74.672     0.150
     5.140    78.859     0.150
     5.259    79.578     0.150
     6.002    86.078     0.150
     6.281    92.891     0.150
     7.035   103.734     0.150
     7.388   108.789     0.150
     8.377   120.188     0.150
     9.135   136.594     0.150
     9.414   138.992     0.150
     9.615   138.094     0.150
     9.615   138.664     0.150
    10.142   144.891     0.150
    10.787   158.594     0.150
    10.787   157.500     0.150
    10.823   156.094     0.150
    10.973   157.188     0.150
    11.940   168.094     0.150
    12.918   182.664     0.150
    13.332   186.891     0.150
    13.333   192.094     0.150
    13.613   194.891     0.150
    13.613   195.203     0.150
    13.758   198.484     0.150
    13.795   196.398     0.150
    14.064   199.992     0.150
    14.221   203.188     0.150
    14.204   203.602     0.150
    14.480   204.711     0.150
    14.999   216.844     0.150
    15.154   214.492     0.150
    15.154   214.750     0.150
    15.204   214.789     0.150
    15.229   222.289     0.150
    15.229   218.188     0.150
    15.197   218.750     0.150
    15.197   381.078     0.150
    15.443   218.289     0.150
    15.432   219.789     0.150
    15.600   221.789     0.150
    15.746   221.688     0.150
    15.885   224.789     0.150
    15.885   408.891     0.150
    16.390   229.391     0.150
    16.347   231.992     0.150
    16.347   419.891     0.150
    17.309   244.594     0.150
    17.492   245.680     0.150
    17.492   245.383     0.150
    18.348   254.789     0.150
    18.348   255.953     0.150
    18.515   256.094     0.150
    18.711   261.289     0.150
    18.711   258.469     0.150
    18.891   260.188     0.150
    19.149   262.789     0.150
    19.149   263.422     0.150
    19.400   267.891     0.150
    19.423   266.492     0.150
    19.621   267.188     0.150
    19.633   269.188     0.150
    19.690   270.594     0.150
    19.775   270.492     0.150
    19.843   271.000     0.150
    19.843   271.594     0.150
    20.047   276.094     0.150
    20.041   276.992     0.150
    20.337   276.594     0.150
    20.376   274.188     0.150
    20.409   278.391     0.150
    20.508   277.492     0.150
    20.678   283.289     0.150
    20.793   280.414     0.150
    20.997   284.688     0.150
    21.093   288.789     0.150
    21.360   288.492     0.150
    21.360   287.773     0.150
    21.360   290.891     0.150
    21.688   293.688     0.150
    21.675   291.594     0.150
    21.662   292.992     0.150
    21.829   296.789     0.150
    21.986   292.758     0.150
    21.957   295.891     0.150
    22.117   295.992     0.150
    22.367   299.094     0.150
    22.471   300.188     0.150
    22.471   546.289     0.150
    22.539   301.391     0.150
    22.643   301.688     0.150
    22.643   550.688     0.150
    22.769   303.992     0.150
    22.769   304.711     0.150
    23.059   308.891     0.150
    23.059   306.992     0.150
    23.051   307.391     0.150
    23.073   310.391     0.150
    23.196   307.891     0.150
    23.196   307.203     0.150
    23.208   341.891     0.150
    23.208   559.789     0.150
    23.208   575.289     0.150
    23.223   307.992     0.150
    23.223   307.062     0.150
    23.300   308.492     0.150
    23.374   309.891     0.150
    23.446   309.789     0.150
    23.446   308.453     0.150
    23.614   310.453     0.150
    23.646   311.891     0.150
    23.820   312.992     0.150
    23.832   311.688     0.150
    23.913   313.250     0.150
    23.933   313.188     0.150
    23.903   315.391     0.150
    23.902   315.289     0.150
    24.096   315.391     0.150
    24.140   316.141     0.150
    24.140   313.969     0.150
    24.296   317.391     0.150
    24.302   317.688     0.150
    24.384   318.352     0.150
    24.509   319.891     0.150
    24.440   319.688     0.150
    24.510   318.992     0.150
    24.514   319.789     0.150
    24.514   320.219     0.150
    24.682   319.789     0.150
    24.687   322.594     0.150
    24.975   325.289     0.150
    25.018   325.492     0.150
    25.020   324.188     0.150
    25.068   326.188     0.150
    25.117   327.391     0.150
    25.128   328.891     0.150
    25.177   326.391     0.150
    25.178   325.789     0.150
    25.178   325.094     0.150
    25.233   327.094     0.150
    25.545   328.891     0.150
    25.583   330.469     0.150
    25.583   328.914     0.150
    25.583   540.578     0.150
    25.583   329.391     0.150
    25.583   540.586     0.150
    25.583   328.391     0.150
    25.695   330.430     0.150
    25.753   331.672     0.150
    25.680   330.289     0.150
    25.684   330.234     0.150
    25.684   328.789     0.150
    26.238   333.297     0.150
    26.433   339.391     0.150
    26.577   337.289     0.150
    26.771   339.492     0.150
    26.963   340.094     0.150
    26.997   342.492     0.150
    27.014   341.492     0.150
    27.209   342.492     0.150
    27.747   347.352     0.150
    27.747   347.789     0.150
    27.725   348.688     0.150
    27.751   348.289     0.150
    27.751   396.492     0.150
    27.751   548.391     0.150
    27.751   989.188     0.150
    27.751   348.789     0.150
    27.798   543.742     0.150
    27.798   349.258     0.150
    27.798   544.359     0.150
    28.263   352.688     0.150
    28.562   358.992     0.150
    29.079   654.188     0.150
    30.414   370.898     0.150
    30.414   371.078     0.150
    30.569   372.578     0.150
    30.882   376.492     0.150
    30.902   376.992     0.150
    30.902   681.492     0.150
    31.271   377.070     0.150
    31.288   379.094     0.150
    31.288   376.203     0.150
    31.293   552.438     0.150
    31.293   377.398     0.150
    31.293   552.438     0.150
    31.293   379.164     0.150
    31.293   551.992     0.150
    31.297   377.828     0.150
    31.352   378.039     0.150
    31.352   441.594     0.150
    31.367   378.367     0.150
    31.369   378.852     0.150
    31.376   378.023     0.150
    31.385   377.867     0.150
    31.386   378.242     0.150
    31.390   378.180     0.150
    31.391   378.188     0.150
    31.405   378.078     0.150
    31.416   378.859     0.150
    31.437   378.359     0.150
    31.464   379.508     0.150
    31.863   386.289     0.150
    31.863   709.789     0.150
    31.933   385.688     0.150
    32.799   396.188     0.150
    33.908   401.523     0.150
    34.105   404.734     0.150
    34.105   404.289     0.150
    34.334   406.539     0.150
    34.665   407.422     0.150
    34.665   561.859     0.150
    34.666   407.539     0.150
    34.666   561.859     0.150
    34.666   407.188     0.150
    34.666   486.594     0.150
    34.666   561.391     0.150
    35.031   412.211     0.150
    35.079   494.688     0.150
    35.079   566.188     0.150
    35.079   746.289     0.150
    35.079   762.891     0.150
    35.079   884.688     0.150
    35.079   412.250     0.150
    36.374   426.289     0.150
    36.536   424.484     0.150
    36.462   425.992     0.150
    36.462   767.688     0.150
    36.995   429.242     0.150
    36.995   427.094     0.150
    38.233   440.789     0.150
    38.336   441.391     0.150
    39.032   447.594     0.150
    39.328   448.891     0.150
    39.328   447.781     0.150
    39.518   450.289     0.150
    39.608   452.391     0.150
    39.893   453.312     0.150
    39.893   454.094     0.150
    40.235   456.992     0.150
    40.247   456.688     0.150
    40.413   458.289     0.150
    40.520   458.617     0.150
    40.502   459.188     0.150
    40.520   460.109     0.150
    40.520   459.391     0.150
    40.520   459.641     0.150
    40.690   460.414     0.150
    41.020   462.992     0.150
    41.529   470.102     0.150
    41.864   470.289     0.150
    42.183   473.891     0.150
    43.884   485.031     0.150
    43.884   485.234     0.150
    43.924   485.344     0.150
    43.924   485.133     0.150
    43.905   485.891     0.150
    44.547   491.891     0.150
    44.772   492.742     0.150
    44.772   599.633     0.150
    45.305   499.125     0.150
    45.752   501.688     0.150
    46.113   503.562     0.150
    46.144   506.289     0.150
    46.144   911.391     0.150
    46.144   928.492     0.150
    46.144   504.492     0.150
    48.079   517.070     0.150
    48.079   519.930     0.150
    48.532   522.492     0.150
    50.958   541.688     0.150
    50.979   542.094     0.150
    50.979   541.688     0.150
    51.116   542.492     0.150
    51.168   543.492     0.150
    51.368   543.750     0.150
    51.779   550.188     0.150
    51.779   988.391     0.150
    51.959   547.789     0.150
    52.019   549.812     0.150
    52.344   550.891     0.150
    52.344   620.688     0.150
    52.344   669.492     0.150
    52.344   995.391     0.150
    52.344  1137.391     0.150
    52.344  1214.391     0.150
    52.486   553.188     0.150
    53.254   560.258     0.150
    53.350   559.891     0.150
    53.350   560.500     0.150
    53.684   563.102     0.150
    53.817   564.539     0.150
    53.924   562.688     0.150
    53.924   562.391     0.150
    53.951   564.453     0.150
    53.960   563.289     0.150
    53.986   564.938     0.150
    53.986   564.805     0.150
    53.986   565.812     0.150
    53.986   565.188     0.150
    53.986   564.688     0.150
    54.225   566.281     0.150
    54.346   568.352     0.150
    54.485   568.703     0.150
    54.557   567.742     0.150
    55.125   572.141     0.150
    55.125   572.531     0.150
    55.125   572.188     0.150
    55.125   572.328     0.150
    55.623   576.391     0.150
    55.701   575.891     0.150
    56.887   584.992     0.150
    56.887   584.188     0.150
    56.887   584.789     0.150
    57.194   587.891     0.150
    57.599   589.188     0.150
    60.783   611.734     0.150
    60.783   611.562     0.150
    61.909   617.789     0.150
    61.909   617.203     0.150
    61.909   758.531     0.150
    63.914   631.602     0.150
    64.622   636.703     0.150
    64.673   638.695     0.150
    64.906   639.672     0.150
    64.906   640.242     0.150
    65.398   643.438     0.150
    65.611   644.625     0.150
    65.678   643.492     0.150
    65.678   643.391     0.150
    65.678   777.828     0.150
    65.820   644.781     0.150
    66.101   647.391     0.150
    66.181   648.188     0.150
    66.391   650.000     0.150
    66.483   649.273     0.150
    67.331   654.688     0.150
    67.932   657.023     0.150
    68.316   659.688     0.150
    68.316   685.688     0.150
    68.316  1199.688     0.150
    68.316   658.852     0.150
    68.657   662.633     0.150
    68.995   664.070     0.150
    69.248   665.141     0.150
    73.390   691.094     0.150
    73.390  1258.094     0.150
    74.648   698.688     0.150
    74.648   714.492     0.150
    74.648   865.094     0.150
    75.420   702.289     0.150
    75.427   705.688     0.150
    75.427   704.594     0.150
    75.427   703.453     0.150
    75.501   703.008     0.150
    75.501   703.992     0.150
    75.845   703.391     0.150
    76.036   706.891     0.150
    76.280   709.594     0.150
    76.357   708.992     0.150
    76.357   710.508     0.150
    76.369   710.891     0.150
    76.468   707.109     0.150
    76.688   710.992     0.150
    76.759   711.039     0.150
    76.908   712.609     0.150
    76.908   713.812     0.150
    76.908   711.688     0.150
    76.908   712.398     0.150
    77.499   713.992     0.150
    78.009   717.250     0.150
    78.065   717.188     0.150
    78.940   720.891     0.150
    79.071  1335.594     0.150
    79.106   722.594     0.150
    79.190   723.391     0.150
    79.206   723.594     0.150
    79.741   726.891     0.150
    79.741   727.703     0.150
    79.853   726.688     0.150
    80.150   728.289     0.150
    80.444   729.898     0.150
    80.458   730.219     0.150
    80.486   730.492     0.150
    80.486   916.391     0.150
    80.631   737.492     0.150
    80.933   732.094     0.150
    80.942   732.492     0.150
    80.946   739.492     0.150
    80.946   732.188     0.150
    81.109   732.781     0.150
    81.677   737.930     0.150
    81.795   737.781     0.150
    81.918   737.047     0.150
    81.981   741.289     0.150
    82.273   739.359     0.150
    82.963   743.992     0.150
    82.963  1361.891     0.150
    83.050   742.859     0.150
    83.102   743.992     0.150
    83.200   743.969     0.150
    83.366   746.633     0.150
    83.396   745.891     0.150
    83.787   747.891     0.150
    83.814   748.750     0.150
    83.966   750.242     0.150
    83.966   749.023     0.150
    83.966   749.391     0.150
    83.966   748.531     0.150
    84.534   752.094     0.150
    84.563   752.539     0.150
    84.591   751.492     0.150
    84.609   752.219     0.150
    84.896   754.664     0.150
    84.904   752.898     0.150
    84.888   753.094     0.150
    85.173   753.180     0.150
    85.173   755.492     0.150
    85.173   756.391     0.150
    85.201   758.453     0.150
    85.409   755.414     0.150
    85.409   756.258     0.150
    85.420   755.891     0.150
    85.432   756.688     0.150
    85.432   755.898     0.150
    86.231   762.133     0.150
    86.325   761.531     0.150
    86.334   760.938     0.150
    86.421   760.992     0.150
    86.660   762.789     0.150
    86.660   763.617     0.150
    86.660   763.367     0.150
    86.789   764.773     0.150
    86.789   764.109     0.150
    86.789   765.391     0.150
    86.789   763.609     0.150
    87.103   765.430     0.150
    87.116   765.594     0.150
    87.545   766.578     0.150
    87.873   768.562     0.150
    87.952   769.492     0.150
    88.405   769.125     0.150
    88.348   770.289     0.150
    88.518   770.578     0.150
    88.532   771.320     0.150
    88.567   772.188     0.150
    88.567   772.734     0.150
    88.593   771.188     0.150
    88.593   772.094     0.150
    88.598   771.758     0.150
    89.726  1424.594     0.150
    90.184   781.992     0.150
    90.250   779.992     0.150
    90.449   780.188     0.150
    90.915   781.992     0.150
    91.156   782.891     0.150
    91.298   785.688     0.150
    91.379   784.891     0.150
    92.122   786.461     0.150
    92.404   788.594     0.150
    92.492   793.289     0.150
    93.306   793.391     0.150
    93.637   795.188     0.150
    94.323   798.391     0.150
    94.690   802.062     0.150
    95.078  1554.891     0.150
    95.150   800.320     0.150
    95.191   802.062     0.150
    95.191   801.789     0.150
    95.581   804.141     0.150
    95.581   804.406     0.150
    95.581   803.891     0.150
    97.943   814.836     0.150
   118.181  1125.938     0.150
   118.181  1752.352     0.150
   118.182  1125.938     0.150
   119.978  1129.891     0.150
   119.978  1129.914     0.150
   119.978  1744.617     0.150
   119.978  1128.188     0.150
   122.606  1133.953     0.150
   126.475  1141.891     0.150
   144.562  1173.930     0.150
   146.641  1180.312     0.150
   146.641  1180.562     0.150
   147.331  1181.500     0.150
   147.789  1185.531     0.150
   150.607  1190.289     0.150
   150.813  1191.953     0.150
   153.163  1194.508     0.150
   153.177  1187.188     0.150
   153.177  1206.594     0.150
   163.492  1252.633     0.150
   166.693  1205.938     0.150
   166.693  1269.672     0.150
   166.693  1205.391     0.150
   170.271  1205.883     0.150
   170.271  1281.852     0.150
     0.503     9.868     0.150
     0.503    17.788     0.150
     0.586    10.788     0.150
     0.586    21.678     0.150
     0.625    11.798     0.150
     0.625    21.107     0.150
     1.248    21.548     0.150
     1.398    43.878     0.150
     1.470    25.728     0.150
     1.470    44.418     0.150
     1.509    27.138     0.150
     1.914    32.647     0.150
     1.914    59.107     0.150
     2.052    33.918     0.150
     2.052    62.788     0.150
     2.183    34.748     0.150
     2.183    63.378     0.150
     2.343    39.218     0.150
     2.585    42.088     0.150
     2.585    74.958     0.150
     2.690    45.048     0.150
     2.690    81.728     0.150
     2.887    46.857     0.150
     2.887    82.828     0.150
     2.949    50.228     0.150
     2.949    88.098     0.150
     2.989    47.375     0.150
     2.989    46.298     0.150
     2.989    83.308     0.150
     3.410    53.308     0.150
     3.410    95.527     0.150
     3.439    53.508     0.150
     8.892   129.578     0.150
    14.107   201.258     0.150
    19.447   264.618     0.150
    19.907   273.519     0.150
    21.889   291.678     0.150
    23.484   312.238     0.150
    23.740   311.268     0.150
    23.920   313.357     0.150
    23.956   314.612     0.150
    23.956   313.397     0.150
    25.041   325.107     0.150
    26.067   335.460     0.150
    26.067   332.868     0.150
    26.236   336.258     0.150
    26.236   336.258     0.150
    27.684   348.438     0.150
    31.166   378.737     0.150
    31.166   378.736     0.150
    34.565   406.588     0.150
    34.566   409.221     0.150
    34.542   409.558     0.150
    34.885   412.062     0.150
    34.885   411.308     0.150
    39.767   453.119     0.150
    51.257   544.498     0.150
    51.257   544.848     0.150
    51.257   619.258     0.150
    51.257   544.853     0.150
    51.257   619.262     0.150
    51.257   543.248     0.150
    52.435   553.018     0.150
    54.129   564.212     0.150
    54.129   564.038     0.150
    54.132   564.208     0.150
    55.381   573.907     0.150
    57.232   587.188     0.150
    57.232   587.288     0.150
    57.232   587.428     0.150
    61.043   613.987     0.150
    65.990   645.918     0.150
    80.662   733.042     0.150
    83.583   748.258     0.150
    83.955   750.308     0.150
    83.955   750.312     0.150
    84.355   752.668     0.150
    84.355   753.197     0.150
    84.355   752.671     0.150
    85.392   756.810     0.150
    85.392   756.407     0.150
    85.387   757.188     0.150
    85.387   757.188     0.150
    85.450   756.808     0.150
    85.715   758.758     0.150
    85.715   757.478     0.150
    85.715   758.928     0.150
    88.918   773.088     0.150
    95.879   807.588     0.150
    95.879   807.591     0.150
   146.500  1181.713     0.150
   146.500  1180.208     0.150
     0.486     9.985     0.150
     0.486    16.726     0.150
     0.594    10.996     0.150
     0.594    21.216     0.150
     0.590    10.945     0.150
     0.590    19.905     0.150
     1.428    23.876     0.150
     1.428    42.525     0.150
     1.458    24.886     0.150
     1.458    45.445     0.150
     1.881    31.476     0.150
     1.881    55.176     0.150
     2.084    33.896     0.150
     2.084    65.556     0.150
     2.195    34.006     0.150
     2.195    62.176     0.150
     2.308    38.436     0.150
     2.609    42.296     0.150
     2.609    73.865     0.150
     2.917    47.786     0.150
    10.927   154.746     0.150
    13.779   193.025     0.150
    23.721   312.006     0.150
    26.035   333.146     0.150
    27.661   347.585     0.150
    30.913   377.016     0.150
    31.198   378.355     0.150
    31.198   378.355     0.150
    34.508   407.825     0.150
    34.596   407.176     0.150
    34.597   406.428     0.150
    34.597   406.056     0.150
    34.864   411.105     0.150
    34.864   409.596     0.150
    40.779   459.686     0.150
    51.223   542.286     0.150
    51.223   544.655     0.150
    51.223   544.652     0.150
    51.223   543.195     0.150
    54.095   563.829     0.150
    54.095   563.246     0.150
    54.098   563.825     0.150
    55.347   573.666     0.150
    57.197   586.815     0.150
    57.197   586.036     0.150
    57.197   587.206     0.150
    61.009   612.216     0.150
    80.650   730.516     0.150
    80.650   731.110     0.150
    83.923   749.206     0.150
    83.923   749.206     0.150
    85.377   756.333     0.150
    85.679   757.645     0.150
     0.127     3.117     0.150
     0.127     6.717     0.150
     0.627    10.988     0.150
     0.627    21.627     0.150
     1.200    21.848     0.150
     1.200    37.387     0.150
     1.175    21.828     0.150
     1.175    39.768     0.150
     1.441    23.658     0.150
     1.578    26.508     0.150
     1.901    29.988     0.150
     1.878    31.547     0.150
     2.066    34.168     0.150
     2.255    38.508     0.150
     2.541    41.297     0.150
     2.541    74.418     0.150
     3.014    48.867     0.150
     3.114    51.168     0.150
     3.114    89.268     0.150
     3.740    59.367     0.150
     3.740   108.547     0.150
     8.302   119.967     0.150
    21.043   281.877     0.150
    21.287   285.377     0.150
    22.535   297.217     0.150
    25.540   329.975     0.150
    27.712   347.119     0.150
    31.276   378.078     0.150
    31.276   378.078     0.150
    34.645   408.627     0.150
    35.081   412.387     0.150
    50.975   541.738     0.150
    50.975   541.732     0.150
    51.353   544.188     0.150
    53.537   558.137     0.150
    53.930   563.396     0.150
    53.930   563.627     0.150
    55.123   571.947     0.150
    56.871   584.447     0.150
    64.879   639.207     0.150
    65.667   644.607     0.150
    82.337   738.938     0.150
    83.430   744.617     0.150
    84.966   752.338     0.150
    85.399   756.188     0.150
    85.699   759.219     0.150
    85.699   756.717     0.150
     0.482     9.137     0.150
     0.482    16.447     0.150
     0.500     9.467     0.150
     0.500    17.477     0.150
     0.598    10.727     0.150
     0.598    20.637     0.150
     1.404    24.938     0.150
     1.404    44.906     0.150
     1.518    25.258     0.150
     1.518    45.848     0.150
     1.626    28.717     0.150
     1.626    48.928     0.150
     1.624    28.727     0.150
     1.624    49.018     0.150
     2.175    35.816     0.150
     2.175    65.586     0.150
     2.220    37.236     0.150
     2.253    35.727     0.150
     2.253    64.996     0.150
     2.592    43.777     0.150
     2.690    43.707     0.150
     2.690    77.736     0.150
     2.721    44.258     0.150
     2.721    78.836     0.150
     3.007    50.057     0.150
     3.007    99.967     0.150
     3.074    52.576     0.150
     3.114    53.244     0.150
     3.114    49.236     0.150
     3.286    52.727     0.150
     3.286    91.777     0.150
     3.546    96.697     0.150
     4.001    62.678     0.150
     4.001   108.027     0.150
     4.052    62.066     0.150
     4.052   111.207     0.150
     9.598   138.777     0.150
     9.598   244.787     0.150
    13.331   186.197     0.150
    13.635   194.496     0.150
    13.691   191.666     0.150
    14.106   197.217     0.150
    14.145   198.666     0.150
    14.517   208.197     0.150
    15.509   215.967     0.150
    15.517   216.977     0.150
    15.645   218.486     0.150
    15.667   217.758     0.150
    16.240   225.518     0.150
    17.230   239.146     0.150
    19.114   266.197     0.150
    20.419   284.598     0.150
    21.703   291.697     0.150
    21.865   290.848     0.150
    22.105   296.197     0.150
    22.524   302.697     0.150
    22.583   299.396     0.150
    22.978   305.098     0.150
    23.624   312.896     0.150
    23.624   308.887     0.150
    23.868   312.797     0.150
    24.500   317.656     0.150
    24.857   326.297     0.150
    25.019   324.627     0.150
    25.165   327.396     0.150
    25.388   331.396     0.150
    25.445   328.098     0.150
    25.528   332.896     0.150
    25.557   326.617     0.150
    25.966   333.619     0.150
    25.966   333.098     0.150
    26.063   331.287     0.150
    26.199   335.158     0.150
    26.198   332.107     0.150
    27.584   345.906     0.150
    27.584   347.562     0.150
    27.641   346.277     0.150
    27.879   348.459     0.150
    28.290   354.197     0.150
    30.844   374.896     0.150
    31.289   378.656     0.150
    31.288   378.656     0.150
    31.292   380.166     0.150
    31.981   388.598     0.150
    32.792   393.896     0.150
    33.760   402.297     0.150
    34.431   407.207     0.150
    34.686   410.348     0.150
    34.687   408.947     0.150
    34.687   409.367     0.150
    34.790   410.887     0.150
    34.790   410.508     0.150
    36.005   417.467     0.150
    36.583   427.396     0.150
    36.658   424.447     0.150
    36.840   427.576     0.150
    38.556   444.098     0.150
    38.664   444.896     0.150
    39.362   450.896     0.150
    39.396   449.037     0.150
    39.932   455.496     0.150
    40.273   458.098     0.150
    40.562   459.996     0.150
    40.574   459.996     0.150
    40.688   462.178     0.150
    40.688   462.180     0.150
    40.688   581.576     0.150
    40.688   458.666     0.150
    40.738   461.396     0.150
    40.829   462.396     0.150
    42.152   472.996     0.150
    44.746   493.588     0.150
    44.746   493.746     0.150
    44.922   493.166     0.150
    46.300   505.598     0.150
    50.705   539.076     0.150
    51.132   541.637     0.150
    51.132   543.428     0.150
    51.132   543.422     0.150
    52.021   551.098     0.150
    52.021   991.098     0.150
    53.396   559.777     0.150
    54.004   563.709     0.150
    54.006   563.707     0.150
    54.203   564.146     0.150
    55.256   572.416     0.150
    55.951   576.066     0.150
    56.020   576.428     0.150
    56.636   581.996     0.150
    57.110   585.428     0.150
    57.110   585.977     0.150
    57.110   585.197     0.150
    61.735   617.268     0.150
    63.872   632.301     0.150
    65.191   643.564     0.150
    65.866   643.887     0.150
    65.866   673.707     0.150
    65.866   644.137     0.150
    65.866   673.438     0.150
    68.443   660.977     0.150
    79.744   726.496     0.150
    80.594   731.404     0.150
    81.343   735.678     0.150
    81.346   735.797     0.150
    83.005   744.066     0.150
    83.350   745.736     0.150
    83.410   745.367     0.150
    83.521   748.717     0.150
    84.185   751.406     0.150
    84.236   752.137     0.150
    84.237   752.135     0.150
    84.237   750.197     0.150
    85.262   755.826     0.150
    85.262   755.822     0.150
    85.316   756.354     0.150
    85.316   756.508     0.150
    85.388   756.297     0.150
    85.590   757.479     0.150
    85.590   756.848     0.150
    85.590   756.018     0.150
    86.680   763.227     0.150
    86.755   763.057     0.150
    87.273   768.029     0.150
    87.287   764.586     0.150
    88.716   771.598     0.150
    88.795   772.057     0.150
   118.573  1127.621     0.150
   118.574  1127.627     0.150
   123.528   929.316     0.150
   146.623  1181.383     0.150
     1.180    31.602     0.150
     1.318    19.453     0.150
     1.318    40.082     0.150
     1.898    52.164     0.150
     1.962    29.230     0.150
     1.962    54.914     0.150
     1.984    31.254     0.150
     2.358    64.684     0.150
     3.021    45.824     0.150
     3.308    47.699     0.150
     3.628    54.441     0.150
     4.067    59.742     0.150
     4.780    70.621     0.150
     8.180   117.082     0.150
    13.745   191.504     0.150
    14.473   205.602     0.150
    15.557   217.742     0.150
    18.520   256.402     0.150
    18.520   256.172     0.150
    19.822   269.828     0.150
    19.822   270.203     0.150
    23.033   304.203     0.150
    23.033   303.832     0.150
    23.165   302.164     0.150
    23.640   306.602     0.150
    23.694   312.301     0.150
    24.245   318.402     0.150
    24.840   321.902     0.150
    25.023   322.203     0.150
    25.398   325.332     0.150
    25.398   324.402     0.150
    25.398   324.543     0.150
    25.500   324.703     0.150
    26.731   334.703     0.150
    27.741   344.129     0.150
    27.844   346.551     0.150
    27.901   346.551     0.150
    29.787   364.902     0.150
    34.704   404.051     0.150
    34.705   404.051     0.150
    34.705   558.602     0.150
    36.454   422.504     0.150
    38.068   436.602     0.150
    38.169   437.004     0.150
    38.864   443.004     0.150
    39.442   447.902     0.150
    39.524   448.504     0.150
    39.943   449.328     0.150
    39.943   449.902     0.150
    40.068   452.301     0.150
    40.080   452.301     0.150
    40.247   454.004     0.150
    40.335   455.004     0.150
    40.854   458.703     0.150
    41.654   465.602     0.150
    41.698   465.703     0.150
    43.969   485.102     0.150
    50.874   537.301     0.150
    50.874   537.934     0.150
    50.874   613.504     0.150
    50.874   537.926     0.150
    50.874   613.504     0.150
    50.874   538.102     0.150
    50.874   537.574     0.150
    51.861   544.301     0.150
    52.378   549.402     0.150
    53.846   558.852     0.150
    53.846   558.363     0.150
    53.849   558.852     0.150
    53.857   558.902     0.150
    55.028   568.152     0.150
    55.028   568.203     0.150
    55.028   567.863     0.150
    55.464   570.504     0.150
    55.616   572.562     0.150
    56.755   579.703     0.150
    56.755   579.102     0.150
    56.755   580.992     0.150
    56.991   582.203     0.150
    60.613   606.703     0.150
    60.613   606.742     0.150
    60.685   607.801     0.150
    60.685   606.223     0.150
    60.957   607.480     0.150
    61.936   615.203     0.150
    63.886   628.207     0.150
    64.701   632.602     0.150
    64.752   635.531     0.150
    64.752   635.184     0.150
    64.752   634.594     0.150
    65.559   638.914     0.150
    67.238   650.602     0.150
    68.220   655.801     0.150
    68.220   804.102     0.150
    68.220  1195.301     0.150
    75.763   699.703     0.150
    76.619   707.477     0.150
    76.769   706.102     0.150
    77.382   710.004     0.150
    78.989   718.504     0.150
    79.093   718.602     0.150
    81.055   729.391     0.150
    81.055   729.391     0.150
    83.480   744.223     0.150
    83.843   746.562     0.150
    83.761   743.957     0.150
    83.817   745.402     0.150
    83.817   745.402     0.150
    85.292   751.828     0.150
    85.292   751.801     0.150
    85.341   753.301     0.150
    92.047   783.184     0.150
    92.047   783.184     0.150
   117.993  1122.254     0.150
   117.994  1122.254     0.150
   146.692  1177.352     0.150
     0.297    12.617     0.150
     0.530    10.164     0.150
     1.768    28.461     0.150
     1.825    29.516     0.150
     1.825    55.781     0.150
     1.876    32.391     0.150
     3.204    92.977     0.150
     3.398    57.305     0.150
     3.398    99.953     0.150
    19.967   270.758     0.150
    23.034   304.633     0.150
    25.387   327.203     0.150
    27.882   345.031     0.150
    31.463   378.016     0.150
    38.032   437.508     0.150
    38.135   438.211     0.150
    38.831   444.406     0.150
    39.407   449.305     0.150
    39.793   451.383     0.150
    40.034   453.305     0.150
    40.046   453.109     0.150
    40.212   454.906     0.150
    40.301   456.008     0.150
    50.785   538.375     0.150
    50.785   613.625     0.150
    53.740   559.961     0.150
    54.933   569.180     0.150
    60.519   607.891     0.150
    64.703   636.469     0.150
    68.125   656.828     0.150
    80.904   730.531     0.150
    83.642   744.797     0.150
    83.763   745.805     0.150
    84.988   750.172     0.150
    85.211   752.938     0.150
   117.988  1122.906     0.150
   146.812  1177.734     0.150
     0.331     6.211     0.150
     0.331    12.082     0.150
     0.454     8.393     0.150
     0.454    15.652     0.150
     0.757    13.922     0.150
     0.757    26.621     0.150
     1.037    19.111     0.150
     1.037    36.432     0.150
     1.245    22.182     0.150
     1.245    41.121     0.150
     1.531    25.971     0.150
     1.531    45.941     0.150
     1.510    26.982     0.150
     1.510    49.021     0.150
     1.732    31.082     0.150
     1.732    54.482     0.150
     1.684    29.402     0.150
     1.684    52.551     0.150
     2.130    36.062     0.150
     2.146    36.162     0.150
     2.160    35.432     0.150
     2.160    63.031     0.150
     2.597    43.232     0.150
     2.597    76.611     0.150
     2.655    43.432     0.150
     2.655    43.332     0.150
     2.655    76.201     0.150
     3.016    47.791     0.150
     3.104    60.371     0.150
     3.104    98.152     0.150
     3.147    51.777     0.150
     3.147    53.068     0.150
     3.147    50.182     0.150
     3.212    51.801     0.150
     3.682    55.871     0.150
     3.906    64.031     0.150
     4.074    65.893     0.150
     8.721   126.732     0.150
     9.614   140.881     0.150
    13.549   194.582     0.150
    14.148   209.291     0.150
    14.930   219.131     0.150
    15.318   219.682     0.150
    16.540   232.281     0.150
    16.540   418.182     0.150
    18.978   264.781     0.150
    18.978   264.602     0.150
    20.669   282.082     0.150
    20.770   283.582     0.150
    20.770   284.572     0.150
    20.948   282.781     0.150
    21.288   290.082     0.150
    22.387   301.982     0.150
    22.480   556.982     0.150
    22.588   302.182     0.150
    22.846   306.082     0.150
    23.489   312.281     0.150
    23.537   310.482     0.150
    23.713   312.512     0.150
    24.200   318.582     0.150
    24.232   319.582     0.150
    24.718   323.781     0.150
    24.860   324.393     0.150
    25.349   327.482     0.150
    25.390   331.982     0.150
    25.561   331.281     0.150
    25.836   331.982     0.150
    25.836   333.482     0.150
    25.836   332.201     0.150
    26.039   333.656     0.150
    26.038   334.152     0.150
    27.639   348.432     0.150
    27.696   349.881     0.150
    27.850   347.781     0.150
    31.302   378.332     0.150
    31.930   388.281     0.150
    32.780   394.781     0.150
    34.317   407.643     0.150
    34.692   410.512     0.150
    34.693   408.221     0.150
    34.693   561.779     0.150
    34.693   409.502     0.150
    34.854   410.857     0.150
    36.531   426.082     0.150
    40.611   459.242     0.150
    40.675   461.236     0.150
    40.675   461.012     0.150
    43.959   486.881     0.150
    46.238   507.082     0.150
    51.071   542.541     0.150
    51.071   542.881     0.150
    51.071   542.551     0.150
    51.261   544.521     0.150
    51.932   996.781     0.150
    52.214   551.051     0.150
    53.965   563.982     0.150
    53.965   564.682     0.150
    55.201   573.521     0.150
    57.027   586.201     0.150
    57.027   586.201     0.150
    60.862   612.971     0.150
    65.794   644.801     0.150
    68.873   665.461     0.150
    75.756   705.762     0.150
    79.602   735.861     0.150
    80.695   732.582     0.150
    80.695   733.791     0.150
    83.813   749.207     0.150
    85.220   755.982     0.150
    85.220   755.982     0.150
    85.520   757.602     0.150
    85.520   758.562     0.150
   118.442  1126.262     0.150
   118.441  1126.258     0.150
   119.655  1128.672     0.150
   119.655  1128.674     0.150
   146.643  1181.307     0.150
   146.643  1183.941     0.150
   151.422  1192.861     0.150
     0.155     2.963     0.150
     0.155     6.033     0.150
     0.155     6.203     0.150
     0.494    17.424     0.150
     0.849    15.893     0.150
     0.849    28.572     0.150
     0.948    31.473     0.150
     1.364    24.582     0.150
     1.364    43.693     0.150
     1.384    43.652     0.150
     1.543    24.863     0.150
     1.561    27.053     0.150
     1.676    29.322     0.150
     1.676    50.504     0.150
     1.853    30.854     0.150
     1.853    56.613     0.150
     2.038    33.443     0.150
     2.096    35.363     0.150
     2.220    36.203     0.150
     2.220    66.633     0.150
     2.296    38.963     0.150
     2.296    66.453     0.150
     2.436    40.893     0.150
     2.436    71.553     0.150
     2.599    73.383     0.150
     2.764    43.533     0.150
     2.764    80.924     0.150
     3.012    47.754     0.150
     3.126    52.094     0.150
     3.172    53.238     0.150
     3.172    53.092     0.150
     3.172    48.812     0.150
     3.157    50.793     0.150
     3.157    91.764     0.150
     3.331    52.693     0.150
     3.699    61.973     0.150
     3.758    58.184     0.150
     3.758   123.104     0.150
     3.822    60.412     0.150
     4.083    63.463     0.150
     4.163    73.844     0.150
     4.275    65.662     0.150
     4.658    70.754     0.150
     4.874    75.424     0.150
     5.318    82.354     0.150
     5.318   157.463     0.150
     6.153    94.152     0.150
     7.053   103.434     0.150
     8.530   125.113     0.150
     9.610   140.943     0.150
     9.610   140.662     0.150
    10.247   149.344     0.150
    10.903   159.543     0.150
    11.965   168.943     0.150
    13.057   184.303     0.150
    13.426   191.742     0.150
    13.764   197.232     0.150
    13.988   201.844     0.150
    14.181   209.633     0.150
    14.313   205.143     0.150
    15.318   220.756     0.150
    15.318   222.643     0.150
    15.517   220.742     0.150
    15.881   229.344     0.150
    16.315   231.844     0.150
    16.435   231.643     0.150
    16.435   413.344     0.150
    16.644   240.643     0.150
    16.644   433.043     0.150
    17.408   248.324     0.150
    17.408   247.273     0.150
    18.413   258.133     0.150
    18.584   257.844     0.150
    18.807   261.742     0.150
    18.832   264.643     0.150
    18.832   261.863     0.150
    19.449   267.643     0.150
    19.449   269.123     0.150
    19.517   267.643     0.150
    19.733   271.043     0.150
    19.801   282.643     0.150
    19.897   272.492     0.150
    19.897   273.143     0.150
    20.322   279.943     0.150
    20.484   280.543     0.150
    20.623   281.443     0.150
    20.623   283.633     0.150
    20.704   281.229     0.150
    20.704   280.344     0.150
    21.125   290.344     0.150
    21.514   292.973     0.150
    21.817   294.643     0.150
    22.116   296.844     0.150
    22.239   303.043     0.150
    22.477   302.643     0.150
    22.477   332.344     0.150
    22.477   547.344     0.150
    22.621   303.043     0.150
    22.621   552.043     0.150
    22.621   562.443     0.150
    22.675   304.543     0.150
    22.919   306.992     0.150
    23.348   309.014     0.150
    23.343   313.143     0.150
    23.343   311.264     0.150
    23.526   310.754     0.150
    23.618   310.863     0.150
    24.036   319.643     0.150
    24.051   320.143     0.150
    24.452   321.242     0.150
    24.415   318.902     0.150
    24.668   321.504     0.150
    25.129   328.242     0.150
    25.170   328.643     0.150
    25.256   331.344     0.150
    25.256   593.143     0.150
    25.256   656.344     0.150
    25.776   334.094     0.150
    25.697   334.066     0.150
    25.697   333.043     0.150
    25.849   332.057     0.150
    25.848   332.152     0.150
    26.619   340.344     0.150
    26.730   341.043     0.150
    27.790   347.855     0.150
    27.790   349.924     0.150
    27.729   349.143     0.150
    27.729   348.846     0.150
    27.786   349.883     0.150
    27.772   349.943     0.150
    27.772   636.344     0.150
    27.772   768.943     0.150
    29.578   365.344     0.150
    29.578   365.309     0.150
    31.288   379.844     0.150
    31.294   379.094     0.150
    31.294   379.090     0.150
    31.294   552.604     0.150
    31.294   380.242     0.150
    31.294   379.543     0.150
    31.298   380.133     0.150
    31.896   388.344     0.150
    31.896   456.443     0.150
    32.793   395.043     0.150
    34.202   407.344     0.150
    34.674   410.143     0.150
    34.674   408.629     0.150
    34.674   563.844     0.150
    34.674   409.504     0.150
    34.954   412.543     0.150
    34.954   412.189     0.150
    34.954   412.674     0.150
    35.010   415.463     0.150
    36.458   429.043     0.150
    36.496   427.344     0.150
    36.950   428.211     0.150
    38.434   443.643     0.150
    39.130   449.643     0.150
    39.406   449.582     0.150
    39.704   453.943     0.150
    39.821   452.711     0.150
    39.821   453.443     0.150
    40.046   456.443     0.150
    40.332   458.742     0.150
    40.344   458.643     0.150
    40.557   460.354     0.150
    40.514   460.643     0.150
    40.599   460.643     0.150
    40.686   460.883     0.150
    40.686   463.393     0.150
    41.920   471.643     0.150
    42.986   481.844     0.150
    43.936   486.014     0.150
    43.879   485.643     0.150
    44.767   492.693     0.150
    46.188   507.543     0.150
    48.044   519.723     0.150
    48.498   523.143     0.150
    51.023   543.043     0.150
    51.023   542.893     0.150
    51.023   542.643     0.150
    51.351   546.844     0.150
    51.431   548.703     0.150
    51.850   554.043     0.150
    51.850   995.844     0.150
    52.021   551.742     0.150
    52.108   550.844     0.150
    52.355   552.574     0.150
    52.355   554.264     0.150
    52.284   552.643     0.150
    52.551   554.844     0.150
    53.008   560.344     0.150
    53.945   563.322     0.150
    53.945   562.990     0.150
    53.945   563.402     0.150
    54.049   567.090     0.150
    54.049   567.943     0.150
    54.625   571.283     0.150
    55.162   572.143     0.150
    55.162   572.254     0.150
    55.162   572.117     0.150
    55.712   576.844     0.150
    55.837   577.863     0.150
    56.952   585.543     0.150
    56.952   585.443     0.150
    56.952   585.732     0.150
    60.749   611.855     0.150
    60.821   612.844     0.150
    60.821   612.354     0.150
    61.211   617.703     0.150
    61.853   618.244     0.150
    61.853   619.143     0.150
    63.898   632.668     0.150
    64.531   636.742     0.150
    64.531   668.943     0.150
    64.990   641.094     0.150
    64.990   640.344     0.150
    65.732   644.383     0.150
    68.352   660.188     0.150
    68.352   660.443     0.150
    68.352   662.193     0.150
    68.938   665.594     0.150
    73.621   694.393     0.150
    75.507   704.844     0.150
    75.616   704.742     0.150
    75.870   706.242     0.150
    76.110   709.943     0.150
    76.831   712.742     0.150
    76.979   713.242     0.150
    77.552   716.844     0.150
    79.088   724.143     0.150
    79.186   724.934     0.150
    79.159   724.242     0.150
    79.255   726.443     0.150
    80.529   734.043     0.150
    80.836   732.049     0.150
    84.046   753.143     0.150
    85.197   754.844     0.150
    85.197   754.867     0.150
    85.461   757.770     0.150
    85.461   758.242     0.150
    85.538   759.094     0.150
    85.538   758.043     0.150
    88.502   772.184     0.150
    95.086   803.812     0.150
    95.121   804.043     0.150
    95.121  1556.043     0.150
    95.121  1862.043     0.150
   118.299  1127.012     0.150
   118.300  1127.012     0.150
   119.835  1132.145     0.150
   119.835  1132.164     0.150
   146.639  1182.977     0.150
   146.639  1182.844     0.150
   149.727  1192.645     0.150
   150.348  1199.633     0.150
   150.418  1200.434     0.150
   151.384  1195.441     0.150
     0.329     6.395     0.150
     0.329    12.244     0.150
     0.446     8.104     0.150
     0.446    15.273     0.150
     0.762    14.084     0.150
     0.762    26.484     0.150
     1.034    19.055     0.150
     1.034    35.984     0.150
     1.243    23.184     0.150
     1.243    41.953     0.150
     1.511    27.244     0.150
     1.511    47.213     0.150
     1.516    27.543     0.150
     1.516    47.254     0.150
     1.539    28.463     0.150
     1.539    46.584     0.150
     1.741    54.623     0.150
     2.138    35.754     0.150
     2.130    36.604     0.150
     2.163    36.543     0.150
     2.163    62.885     0.150
     2.208    37.254     0.150
     2.208    67.244     0.150
     2.597    43.373     0.150
     3.204    51.314     0.150
    31.310   380.705     0.150
    34.700   409.549     0.150
    51.062   542.883     0.150
    55.194   573.824     0.150
     0.175     3.553     0.150
     0.175     6.693     0.150
     0.542     9.883     0.150
     0.542    17.764     0.150
     0.883    16.393     0.150
     0.883    29.652     0.150
     0.902    17.273     0.150
     0.902    31.562     0.150
     1.354    25.133     0.150
     1.354    43.344     0.150
     1.396    25.303     0.150
     1.396    45.133     0.150
     1.470    25.443     0.150
     1.674    29.232     0.150
     1.674    52.152     0.150
     1.772    31.674     0.150
     1.772    57.113     0.150
     2.014    34.594     0.150
     2.014    60.834     0.150
     2.146    36.383     0.150
     2.146    65.732     0.150
     2.290    39.084     0.150
     2.437    42.004     0.150
     2.437    72.553     0.150
     2.546    41.973     0.150
     2.546    74.193     0.150
     3.098    50.893     0.150
     3.141    57.322     0.150
     3.234    52.373     0.150
     4.947    79.312     0.150
    14.240   213.482     0.150
    23.406   311.283     0.150
    25.778   334.174     0.150
    25.778   333.812     0.150
    25.903   334.371     0.150
    25.902   333.633     0.150
    27.767   348.926     0.150
    31.228   380.572     0.150
    31.228   380.572     0.150
    34.611   409.238     0.150
    34.611   409.504     0.150
    34.988   415.188     0.150
    34.988   415.533     0.150
    40.751   464.363     0.150
    40.751   464.365     0.150
    44.699   492.070     0.150
    44.699   493.482     0.150
    51.019   542.137     0.150
    51.023   542.133     0.150
    51.100   545.473     0.150
    51.100   543.443     0.150
    51.100   543.447     0.150
    51.100   544.934     0.150
    55.238   574.484     0.150
    57.032   588.463     0.150
    65.072   643.570     0.150
    65.811   647.152     0.150
     0.522    18.145     0.150
     0.705    23.957     0.150
     1.133    33.645     0.150
     1.285    21.598     0.150
     1.611    26.867     0.150
     1.659    27.418     0.150
     1.845    28.418     0.150
     1.845    57.227     0.150
     1.975    31.887     0.150
     2.086    33.336     0.150
     2.086    62.895     0.150
     2.056    34.168     0.150
     2.161    34.117     0.150
     2.284    35.578     0.150
     2.524    69.625     0.150
     3.026    56.266     0.150
     2.981    45.797     0.150
     3.094    49.578     0.150
     3.235    47.336     0.150
     3.701    57.867     0.150
     4.111    63.266     0.150
     4.085    61.348     0.150
     4.852    70.848     0.150
     8.193   118.707     0.150
    13.810   192.367     0.150
    14.704   204.977     0.150
    15.054   209.328     0.150
    19.763   270.168     0.150
    22.228   296.125     0.150
    25.461   324.758     0.150
    27.679   347.117     0.150
    27.679   344.555     0.150
    31.268   377.848     0.150
    31.273   377.805     0.150
    31.273   377.812     0.150
    31.273   378.047     0.150
    31.287   376.238     0.150
    34.635   408.477     0.150
    34.636   405.766     0.150
    34.636   407.406     0.150
    44.759   493.066     0.150
    44.759   492.367     0.150
    48.102   515.746     0.150
    50.947   540.016     0.150
    50.947   615.805     0.150
    50.947   540.016     0.150
    50.947   615.805     0.150
    50.947   539.277     0.150
    51.931   547.305     0.150
    53.919   561.840     0.150
    53.921   561.848     0.150
    55.101   571.340     0.150
    60.686   609.477     0.150
    60.686   609.480     0.150
    61.994   615.277     0.150
    64.823   638.465     0.150
    67.120   651.355     0.150
    68.294   659.137     0.150
    76.691   710.066     0.150
    81.089   730.316     0.150
    81.089   730.316     0.150
    83.888   747.715     0.150
    83.888   747.715     0.150
    83.888   748.887     0.150
    85.043   751.617     0.150
    85.164   754.633     0.150
    85.365   754.773     0.150
    85.773   756.566     0.150
    85.773   756.727     0.150
    92.119   786.461     0.150
    95.330   800.523     0.150
    95.330   800.527     0.150
    95.540   803.613     0.150
   118.055  1125.352     0.150
   118.056  1125.355     0.150
   120.154  1127.805     0.150
   120.154  1127.805     0.150
   146.622  1178.992     0.150
     0.215  