#!/bin/bash
gmt begin bohol1.86_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-31/31/-31/31
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation bohol1.86'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000    11.040    11.040
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.548     0.333
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.990   -10.962
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.990   -10.962 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.768   -11.987
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.768   -11.987 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.274    -5.195
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.274    -5.195 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    29.357     3.085
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    29.357     3.085 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.903    -2.797
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.903    -2.797 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.650     2.059
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.650     2.059 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    17.017     2.089
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    17.017     2.089 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.386   -11.649
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.386   -11.649 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.378   -12.907
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.378   -12.907 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.455    -1.775
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.455    -1.775 11
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.643     7.294
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.643     7.294 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    24.257    -3.409
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    24.257    -3.409 13
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.537    -4.929
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.577    -9.833
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.577    -9.833 15
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.916   -17.499
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.916   -17.499 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.755   -28.018
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.755   -28.018 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.092    -4.401
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.092    -4.401 18
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.260    -1.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.943    -2.098
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.573     6.329
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.573     6.329 21
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.612    -3.456
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    29.579    -0.516
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    29.579    -0.516 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.107    -7.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.784    -2.985
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.731    -1.661
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.361   -17.291
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.361   -17.291 27
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.139   -10.836
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.279    -1.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.764    -9.040
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.422    -5.660
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.336    -3.148
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.250     2.152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.300   -10.485
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.300   -10.485 34
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.128    -2.179
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.183    -2.866
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.759    -4.791
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.241    -4.014
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.248    -6.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.832    -1.570
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.940    -2.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.189     4.355
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.189     4.355 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.755    -3.084
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.755    -3.084 43
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.902    -0.730
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.361    -5.151
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.359     0.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.503    -0.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.965    -2.171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.723    -6.108
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.680    -5.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.625    -5.649
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.625    -5.649 51
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.041    -4.683
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.237     1.134
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.883     2.819
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.600     0.765
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.248     4.708
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.989    -8.382
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.989    -8.382 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.769     2.717
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.769     2.717 58
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.260    -5.492
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.260    -5.492 59
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.075    -5.056
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.852     5.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -16.821   -21.530
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -16.821   -21.530 62
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.986    -1.260
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.986    -1.260 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.405    -5.067
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.491    -0.236
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.068    -6.821
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.068    -6.821 66
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.973    -3.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.869    -1.568
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.875    -6.201
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.523    -4.370
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.586     3.537
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.301     1.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.790     5.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.793    -0.392
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.433    -0.482
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.760     0.810
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.115    -8.557
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.047    -0.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.866    -5.467
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.033    -6.792
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.358    -0.805
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.358    -0.805 81
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.985    -1.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.927    -3.792
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.018     1.022
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.482    -5.529
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.341    -1.734
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.341    -1.734 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.829    -8.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.247    -3.379
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.846   -12.082
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.846   -12.082 89
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.992     2.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.552     0.345
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.134     3.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.923    -1.122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.034    -0.784
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    24.262    -0.847
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    24.262    -0.847 95
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.687    -6.787
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.222    -3.839
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.893    -2.802
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.893    -2.802 98
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.470    -3.721
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.207    -2.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.405    -6.674
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.394     4.620
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.273    -6.601
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.976     0.052
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.394    -3.205
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.171    -4.027
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.171    -4.027 106
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.114    -2.902
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.701     5.235
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.846    -4.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.353   -11.930
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.353   -11.930 110
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.181    -0.957
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.262     0.813
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.280    -3.380
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.854     3.033
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.376    -1.506
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.772    -2.352
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.222    -3.698
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.645    -0.448
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.460    -2.931
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.172    -3.172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.755     2.702
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.615     0.602
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.443    -2.794
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.490    -3.742
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.768    -0.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.189   -16.189
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.189   -16.189 126
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.340    -2.605
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.476    -2.849
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.970    -1.824
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.092    -2.841
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.013     1.227
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.906    -0.635
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.497     0.623
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.978    -3.426
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.000     0.280
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.299    -2.846
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.876    -6.775
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.549    -3.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.535    -2.664
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.052    -2.217
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.597    -1.267
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.710    -6.383
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.283    -1.426
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.698     0.721
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.951    -0.083
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.595     1.322
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.138    -4.164
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.323    -0.174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.898    -1.233
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.793    -3.102
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.793    -0.154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.787    -6.740
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.787    -6.740 152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.704    -2.181
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.250     0.092
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.818    -3.953
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.269     0.089
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.883    -0.508
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.738    -3.263
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.849     0.710
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.734    -1.816
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.748    -0.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.657     1.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.754    -1.274
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.154     1.712
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.731    -0.994
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.494    -4.990
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.115    -6.871
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.774     1.706
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.867    -0.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.047     0.423
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.028     0.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.476    -0.288
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.476    -0.288 172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.105    -1.202
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.055     3.916
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.506     1.676
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.362     4.143
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.265    -1.948
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.610     1.198
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.701    -3.807
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.763     0.823
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.763     0.823 180
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.444    -1.488
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.736    -3.379
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.172     1.394
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.406     0.786
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.694    -5.686
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.694    -5.686 185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.295    -1.389
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.422     1.483
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    13.331    -8.992
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    13.331    -8.992 188
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.681    -5.147
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.323    -0.654
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.937     1.859
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.653    -2.747
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.736    -3.766
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.637     4.534
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.628    -5.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.414    -2.864
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.852    -2.754
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.559    -1.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.777     5.485
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.285    -2.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.099     2.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.198     1.228
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.045    -7.632
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.876    -7.229
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.616     2.257
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.411    -2.999
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.038    -2.196
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.325    -7.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.823    -1.239
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.069    -8.353
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.069    -8.353 210
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.774    -0.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.719    -0.150
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.327    -0.920
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.481    -0.104
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.325     0.751
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.325     0.751 215
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.802    -9.845
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.158    -0.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.560    -0.451
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.101     4.434
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.833    -9.673
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.833    -9.673 220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.267   -13.625
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.267   -13.625 221
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.754     6.185
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.369    -4.215
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.156     2.891
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.569    -3.536
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.278    -5.677
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.355     1.424
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.811    -5.722
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.132    -4.293
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.687    -5.924
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.687    -5.924 230
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.265     7.016
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.475    -3.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.041     3.632
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.743    -2.075
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.282     1.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.030     3.169
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.835    -7.947
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.150    -4.220
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.484    -1.491
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.634    -1.692
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.006    -2.550
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.903     0.586
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.875    -2.862
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.777    -7.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.095     0.398
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.711    -6.984
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.524    -4.400
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.553    -4.755
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.553    -4.755 248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.695     1.171
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.407     1.264
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.365    -4.762
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.010    -5.009
EOF
gmt plot $proj $reg -SE -Gred << EOF
     4.156    -2.523     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -29.000    29.000 Author: all ( 252 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -29.000   -29.000 Average =   4.9 km at 121.3 deg; median =    5.5 km
EOF
gmt end
