#!/bin/bash
gmt begin bohol1.86_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-23/36/0/32
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya25f5+lCounts -BWeSn+t'Focal Depth Mislocation bohol1.86' << EOF
    -3.400
    15.400
    13.400
     2.500
    -1.000
     5.200
    -1.900
    26.900
     3.400
    -2.400
    12.000
     7.900
     0.700
     0.100
    -2.000
    21.400
    28.000
    10.500
    -1.000
    21.000
     5.000
    12.500
    -6.500
     7.100
     6.000
     5.900
    26.500
    23.300
    17.000
    11.000
     8.800
     4.000
     0.700
    -2.100
     1.000
     4.100
    19.200
    23.100
     6.500
    23.800
     7.200
    -5.100
    -2.700
    -7.400
    18.200
    12.000
    17.200
     5.800
    18.000
    -2.900
   -17.700
     7.700
    22.200
    -5.500
    -0.800
    -8.600
     4.200
    -8.000
   -13.000
     6.000
     2.000
    -4.000
   -12.000
    30.700
    -0.000
    -7.000
     5.500
    -0.000
     3.000
    -2.400
     3.000
     0.900
    -1.000
     1.900
    -4.000
     3.700
    -1.200
     2.400
     4.900
     5.800
    -0.000
     2.700
     7.000
    -0.900
    -3.300
   -12.000
    -5.000
     7.300
    -5.000
     0.300
    -0.500
     3.200
    -0.600
    -5.000
    -1.000
    -2.000
     2.000
     6.900
     7.800
    -0.600
    -5.200
     6.000
     5.400
     3.800
     1.100
     2.400
    -0.000
    -0.400
     4.400
    -4.200
    -0.000
     2.500
     0.500
     2.800
    -0.300
    -0.200
     3.100
    -0.500
     7.300
    -0.900
     0.300
     1.300
     3.500
     0.400
     9.200
    -2.500
     0.300
     2.600
     4.200
     8.200
     1.400
    -3.200
    -0.500
     0.800
     3.200
     1.400
     0.200
     5.700
     7.100
     5.600
     0.600
    -0.000
    -0.500
     1.000
     0.100
     0.300
    10.800
    -0.100
     2.200
    -1.000
     3.400
    -0.200
    -9.000
     0.200
     8.400
    -0.000
     9.000
     8.600
     7.800
    -2.700
     6.900
     2.300
     1.400
     2.600
    -0.300
     2.700
     6.500
     3.500
     2.500
     1.200
     1.300
     7.000
    -0.500
     2.200
    -2.000
    -0.800
     5.300
     2.000
    10.900
    -2.000
    -2.800
    -2.000
     5.300
    -3.100
    -5.100
     1.400
     4.300
     2.800
     3.300
    -2.600
    -2.800
     0.100
    11.300
    19.300
   -10.800
     1.000
    -3.300
     2.700
     3.000
     0.700
    -2.200
    -0.900
    -8.000
     7.500
     3.400
     4.700
     0.100
    -9.800
    -1.700
    -2.600
     2.000
    -0.000
    -6.500
     0.500
    -1.600
    -7.200
     3.100
    -2.300
    -6.700
    -2.600
    -4.900
    -5.500
     1.900
    18.100
     5.500
     1.300
     1.900
    -7.700
    -0.600
    17.700
     5.300
    -5.000
     0.600
     4.200
    -6.900
    -8.000
    -2.000
     4.900
    -7.000
    -6.000
     1.900
    -7.000
     4.000
    -3.200
    -9.000
   -12.000
     3.800
    -0.200
     0.200
     3.300
   -10.000
    -4.100
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     1.050    28.680 Median =   1.1 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  1.1  0.
  1.1  28.1
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -22.000    30.320 Author: all ( 252 samples)
EOF
gmt end
