#!/bin/bash
gmt begin bohol1.86_dcal pdf,ps
proj=-JM16.0c+
reg=-R121.6/127.2/7.3/12.3
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration bohol1.86'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   123.906    10.331
   124.878    10.247
>
   124.979    11.165
   124.878    10.247
>
   123.981    10.323
   124.582     9.801
>
   123.981    10.323
   124.540     9.761
>
   124.979    11.165
   125.057    10.316
>
   124.979    11.165
   125.057    10.316
>
   124.979    11.165
   125.060    10.331
>
   124.979    11.165
   124.842    10.291
>
   123.981    10.323
   124.842    10.291
>
   123.981    10.323
   124.842    10.291
>
   123.981    10.323
   124.857    10.231
>
   123.981    10.323
   124.857    10.231
>
   124.979    11.165
   124.857    10.231
>
   123.981    10.323
   123.483    10.160
>
   123.981    10.323
   123.483    10.160
>
   124.979    11.165
   125.070    10.163
>
   125.489     9.782
   125.093    10.342
>
   124.979    11.165
   125.093    10.342
>
   125.489     9.782
   125.056    10.301
>
   124.979    11.165
   125.056    10.301
>
   125.489     9.782
   124.882     9.796
>
   124.672     9.233
   124.776     9.824
>
   125.489     9.782
   124.776     9.824
>
   123.862     9.691
   124.776     9.824
>
   123.862     9.691
   124.776     9.824
>
   123.966    10.317
   124.776     9.824
>
   123.966    10.317
   124.776     9.824
>
   124.672     9.233
   124.825     9.803
>
   125.489     9.782
   124.825     9.803
>
   123.862     9.691
   124.825     9.803
>
   123.966    10.317
   124.825     9.803
>
   123.966    10.317
   124.825     9.803
>
   125.489     9.782
   124.771     9.843
>
   123.862     9.691
   124.771     9.843
>
   123.966    10.317
   124.771     9.843
>
   125.489     9.782
   125.149    10.071
>
   125.489     9.782
   125.149    10.071
>
   124.672     9.233
   125.149    10.071
>
   123.236     9.343
   123.571     9.772
>
   123.236     9.343
   123.571     9.772
>
   123.966    10.317
   123.571     9.772
>
   123.966    10.317
   123.571     9.772
>
   124.859    10.134
   124.721     9.874
>
   124.859    10.134
   124.721     9.874
>
   123.966    10.317
   124.721     9.874
>
   123.966    10.317
   124.721     9.874
>
   123.862     9.691
   124.721     9.874
>
   124.859    10.134
   124.686     9.866
>
   123.862     9.691
   124.686     9.866
>
   123.862     9.691
   124.686     9.866
>
   123.966    10.317
   124.686     9.866
>
   123.966    10.317
   124.686     9.866
>
   124.859    10.134
   124.784    10.289
>
   124.859    10.134
   124.784    10.289
>
   125.489     9.782
   124.784    10.289
>
   124.609    11.051
   124.784    10.289
>
   124.609    11.051
   124.784    10.289
>
   124.979    11.165
   124.784    10.289
>
   124.979    11.165
   124.784    10.289
>
   123.862     9.691
   124.013    10.006
>
   123.862     9.691
   124.013    10.006
>
   124.859    10.134
   124.013    10.006
>
   124.859    10.134
   124.013    10.006
>
   123.862     9.691
   124.720     9.870
>
   123.862     9.691
   124.720     9.870
>
   123.966    10.317
   124.720     9.870
>
   123.966    10.317
   124.720     9.870
>
   124.859    10.134
   124.685     9.854
>
   123.862     9.691
   124.685     9.854
>
   123.862     9.691
   124.685     9.854
>
   123.966    10.317
   124.685     9.854
>
   123.966    10.317
   124.685     9.854
>
   123.862     9.691
   124.262     9.662
>
   123.966    10.317
   124.262     9.662
>
   123.966    10.317
   124.262     9.662
>
   124.859    10.134
   124.262     9.662
>
   124.859    10.134
   125.066    10.126
>
   124.859    10.134
   125.066    10.126
>
   125.489     9.782
   125.066    10.126
>
   125.489     9.782
   125.066    10.126
>
   124.859    10.134
   125.056     9.641
>
   124.859    10.134
   125.030    10.299
>
   125.489     9.782
   125.030    10.299
>
   125.489     9.782
   125.030    10.299
>
   124.979    11.165
   125.030    10.299
>
   124.979    11.165
   125.030    10.299
>
   124.609    11.051
   125.030    10.299
>
   123.862     9.691
   124.250     9.606
>
   123.862     9.691
   124.250     9.606
>
   123.966    10.317
   124.250     9.606
>
   124.859    10.134
   124.250     9.606
>
   124.859    10.134
   124.518     9.786
>
   123.862     9.691
   124.518     9.786
>
   123.966    10.317
   124.518     9.786
>
   123.966    10.317
   124.518     9.786
>
   124.859    10.134
   124.512     9.788
>
   123.862     9.691
   124.512     9.788
>
   123.862     9.691
   124.512     9.788
>
   123.966    10.317
   124.512     9.788
>
   123.966    10.317
   124.512     9.788
>
   124.859    10.134
   124.697     9.638
>
   124.859    10.134
   125.025     9.928
>
   124.859    10.134
   124.514     9.774
>
   124.859    10.134
   124.514     9.774
>
   123.862     9.691
   124.514     9.774
>
   123.862     9.691
   124.514     9.774
>
   123.966    10.317
   124.514     9.774
>
   123.966    10.317
   124.514     9.774
>
   125.489     9.782
   125.048     9.443
>
   124.859    10.134
   125.048     9.443
>
   124.859    10.134
   125.048     9.443
>
   125.621     8.969
   125.048     9.443
>
   123.862     9.691
   124.036     9.380
>
   123.862     9.691
   124.036     9.380
>
   123.966    10.317
   124.036     9.380
>
   123.966    10.317
   124.036     9.380
>
   123.862     9.691
   124.004     9.247
>
   123.862     9.691
   124.004     9.247
>
   123.862     9.691
   124.304     9.430
>
   124.859    10.134
   124.304     9.430
>
   124.859    10.134
   124.304     9.430
>
   123.966    10.317
   124.304     9.430
>
   123.966    10.317
   124.304     9.430
>
   124.609    11.051
   125.039    10.152
>
   124.609    11.051
   125.039    10.152
>
   125.489     9.782
   125.255     9.838
>
   124.859    10.134
   125.255     9.838
>
   124.859    10.134
   125.255     9.838
>
   125.621     8.969
   125.255     9.838
>
   123.862     9.691
   124.080     9.892
>
   123.862     9.691
   124.080     9.892
>
   123.966    10.317
   124.080     9.892
>
   124.859    10.134
   124.080     9.892
>
   124.859    10.134
   124.080     9.892
>
   123.966    10.317
   124.090    10.035
>
   124.859    10.134
   124.090    10.035
>
   124.859    10.134
   124.090    10.035
>
   123.862     9.691
   124.026     9.949
>
   123.862     9.691
   124.026     9.949
>
   123.862     9.691
   123.664     9.751
>
   123.862     9.691
   123.664     9.751
>
   123.966    10.317
   123.664     9.751
>
   123.966    10.317
   123.664     9.751
>
   123.966    10.317
   124.158    10.018
>
   123.966    10.317
   124.158    10.018
>
   124.859    10.134
   124.158    10.018
>
   123.236     9.343
   123.830     9.835
>
   123.236     9.343
   123.830     9.835
>
   124.859    10.134
   124.118     9.983
>
   124.859    10.134
   124.118     9.983
>
   123.862     9.691
   124.007     9.848
>
   123.862     9.691
   124.007     9.848
>
   123.966    10.317
   124.007     9.848
>
   123.966    10.317
   124.007     9.848
>
   123.236     9.343
   124.007     9.848
>
   123.236     9.343
   124.007     9.848
>
   124.859    10.134
   124.007     9.848
>
   123.862     9.691
   124.078     9.813
>
   123.862     9.691
   124.078     9.813
>
   124.859    10.134
   124.078     9.813
>
   124.859    10.134
   124.078     9.813
>
   123.966    10.317
   124.006     9.897
>
   124.859    10.134
   124.006     9.897
>
   123.236     9.343
   124.006     9.897
>
   123.236     9.343
   124.006     9.897
>
   123.862     9.691
   124.120     9.999
>
   123.862     9.691
   124.120     9.999
>
   124.859    10.134
   124.120     9.999
>
   124.859    10.134
   124.120     9.999
>
   124.859    10.134
   124.182    10.065
>
   123.966    10.317
   124.131    10.021
>
   123.966    10.317
   124.131    10.021
>
   124.859    10.134
   124.131    10.021
>
   123.966    10.317
   124.146    10.020
>
   123.966    10.317
   124.146    10.020
>
   124.859    10.134
   124.146    10.020
>
   124.859    10.134
   124.146    10.020
>
   123.862     9.691
   124.127     9.943
>
   123.966    10.317
   124.127     9.943
>
   123.966    10.317
   124.127     9.943
>
   124.859    10.134
   124.127     9.943
>
   123.862     9.691
   123.845     9.904
>
   123.966    10.317
   123.845     9.904
>
   123.966    10.317
   123.845     9.904
>
   123.236     9.343
   123.845     9.904
>
   123.236     9.343
   123.845     9.904
>
   123.966    10.317
   123.892     9.898
>
   123.966    10.317
   123.892     9.898
>
   123.236     9.343
   123.892     9.898
>
   123.236     9.343
   123.892     9.898
>
   124.859    10.134
   123.892     9.898
>
   124.859    10.134
   123.892     9.898
>
   123.862     9.691
   124.033     9.971
>
   123.862     9.691
   124.033     9.971
>
   123.966    10.317
   124.033     9.971
>
   123.966    10.317
   124.033     9.971
>
   123.862     9.691
   124.014     9.873
>
   123.862     9.691
   124.014     9.873
>
   123.966    10.317
   124.014     9.873
>
   123.966    10.317
   124.014     9.873
>
   124.859    10.134
   124.014     9.873
>
   124.859    10.134
   124.014     9.873
>
   123.236     9.343
   124.014     9.873
>
   123.236     9.343
   124.014     9.873
>
   123.862     9.691
   123.663     9.761
>
   123.862     9.691
   123.663     9.761
>
   123.236     9.343
   123.663     9.761
>
   123.966    10.317
   123.663     9.761
>
   123.966    10.317
   123.663     9.761
>
   123.862     9.691
   124.005     9.850
>
   123.966    10.317
   124.005     9.850
>
   123.966    10.317
   124.005     9.850
>
   124.859    10.134
   124.005     9.850
>
   124.859    10.134
   124.005     9.850
>
   123.862     9.691
   123.688     9.763
>
   123.862     9.691
   123.688     9.763
>
   123.236     9.343
   123.688     9.763
>
   123.236     9.343
   123.688     9.763
>
   123.966    10.317
   123.688     9.763
>
   123.966    10.317
   123.688     9.763
>
   123.862     9.691
   123.950     9.838
>
   123.966    10.317
   123.950     9.838
>
   123.236     9.343
   123.950     9.838
>
   123.236     9.343
   123.950     9.838
>
   124.859    10.134
   123.950     9.838
>
   124.859    10.134
   123.950     9.838
>
   123.966    10.317
   124.139     9.989
>
   123.966    10.317
   124.139     9.989
>
   123.862     9.691
   124.139     9.989
>
   123.862     9.691
   124.139     9.989
>
   123.862     9.691
   124.036     9.908
>
   123.862     9.691
   124.036     9.908
>
   123.966    10.317
   124.036     9.908
>
   123.966    10.317
   124.036     9.908
>
   124.859    10.134
   124.036     9.908
>
   124.859    10.134
   124.036     9.908
>
   123.966    10.317
   124.019     9.895
>
   123.966    10.317
   124.019     9.895
>
   124.859    10.134
   124.019     9.895
>
   124.859    10.134
   124.019     9.895
>
   123.236     9.343
   124.019     9.895
>
   123.236     9.343
   124.019     9.895
>
   123.966    10.317
   124.021     9.944
>
   123.966    10.317
   124.021     9.944
>
   124.859    10.134
   124.021     9.944
>
   124.859    10.134
   124.021     9.944
>
   123.236     9.343
   124.021     9.944
>
   123.236     9.343
   124.021     9.944
>
   123.966    10.317
   124.174    10.065
>
   123.966    10.317
   124.174    10.065
>
   124.859    10.134
   124.174    10.065
>
   124.859    10.134
   124.174    10.065
>
   123.236     9.343
   124.025     9.845
>
   123.236     9.343
   124.025     9.845
>
   123.236     9.343
   123.692     9.691
>
   123.236     9.343
   123.692     9.691
>
   123.966    10.317
   123.692     9.691
>
   124.859    10.134
   124.036     9.885
>
   124.859    10.134
   124.036     9.885
>
   123.236     9.343
   124.036     9.885
>
   123.236     9.343
   124.036     9.885
>
   123.966    10.317
   123.923     9.845
>
   123.236     9.343
   123.923     9.845
>
   124.859    10.134
   123.923     9.845
>
   124.859    10.134
   123.923     9.845
>
   123.236     9.343
   123.869     9.772
>
   123.236     9.343
   123.869     9.772
>
   123.966    10.317
   123.847     9.764
>
   123.966    10.317
   123.847     9.764
>
   123.236     9.343
   123.847     9.764
>
   123.236     9.343
   123.847     9.764
>
   123.966    10.317
   124.169    10.056
>
   123.966    10.317
   124.169    10.056
>
   124.859    10.134
   124.169    10.056
>
   124.859    10.134
   124.169    10.056
>
   123.966    10.317
   124.138    10.080
>
   123.966    10.317
   124.138    10.080
>
   124.859    10.134
   124.138    10.080
>
   124.859    10.134
   124.138    10.080
>
   123.966    10.317
   123.735     9.773
>
   123.966    10.317
   123.735     9.773
>
   123.236     9.343
   123.735     9.773
>
   123.236     9.343
   123.735     9.773
>
   123.966    10.317
   123.804     9.800
>
   123.236     9.343
   123.804     9.800
>
   123.236     9.343
   123.804     9.800
>
   123.966    10.317
   124.005     9.856
>
   123.966    10.317
   124.005     9.856
>
   123.236     9.343
   124.005     9.856
>
   123.966    10.317
   124.162    10.009
>
   124.859    10.134
   124.162    10.009
>
   123.966    10.317
   124.172     9.891
>
   123.966    10.317
   124.172     9.891
>
   123.966    10.317
   123.707     9.783
>
   123.966    10.317
   123.707     9.783
>
   123.236     9.343
   123.707     9.783
>
   123.236     9.343
   123.707     9.783
>
   123.966    10.317
   124.003     9.928
>
   123.966    10.317
   124.003     9.928
>
   124.859    10.134
   124.003     9.928
>
   124.859    10.134
   124.003     9.928
>
   123.236     9.343
   124.003     9.928
>
   123.236     9.343
   124.003     9.928
>
   123.966    10.317
   124.018     9.858
>
   123.966    10.317
   124.018     9.858
>
   124.859    10.134
   124.018     9.858
>
   123.236     9.343
   124.018     9.858
>
   123.966    10.317
   124.126     9.867
>
   123.966    10.317
   124.154     9.943
>
   123.966    10.317
   124.154     9.943
>
   124.859    10.134
   124.154     9.943
>
   124.859    10.134
   124.154     9.943
>
   123.966    10.317
   124.181     9.994
>
   123.966    10.317
   124.181     9.994
>
   124.859    10.134
   124.181     9.994
>
   124.859    10.134
   124.181     9.994
>
   123.966    10.317
   123.964     9.784
>
   123.966    10.317
   123.964     9.784
>
   123.236     9.343
   123.964     9.784
>
   123.236     9.343
   123.964     9.784
>
   124.859    10.134
   123.964     9.784
>
   123.236     9.343
   123.651     9.725
>
   123.966    10.317
   123.651     9.725
>
   123.966    10.317
   123.651     9.725
>
   123.966    10.317
   123.844     9.902
>
   123.236     9.343
   123.844     9.902
>
   123.236     9.343
   123.844     9.902
>
   123.966    10.317
   124.174     9.943
>
   123.966    10.317
   124.174     9.943
>
   124.859    10.134
   124.174     9.943
>
   124.859    10.134
   124.174     9.943
>
   124.859    10.134
   124.080    10.008
>
   124.859    10.134
   124.080    10.008
>
   123.966    10.317
   124.043     9.849
>
   123.966    10.317
   124.043     9.849
>
   124.859    10.134
   124.043     9.849
>
   124.859    10.134
   124.043     9.849
>
   123.236     9.343
   124.043     9.849
>
   123.236     9.343
   124.043     9.849
>
   123.966    10.317
   123.749     9.782
>
   123.966    10.317
   123.749     9.782
>
   123.236     9.343
   123.749     9.782
>
   123.236     9.343
   123.749     9.782
>
   123.966    10.317
   124.138     9.840
>
   123.966    10.317
   124.138     9.840
>
   124.859    10.134
   124.138     9.840
>
   124.859    10.134
   124.138     9.840
>
   123.966    10.317
   123.904     9.815
>
   123.966    10.317
   123.904     9.815
>
   123.236     9.343
   123.904     9.815
>
   124.859    10.134
   123.904     9.815
>
   124.859    10.134
   123.904     9.815
>
   123.966    10.317
   124.219     9.956
>
   123.966    10.317
   124.219     9.956
>
   124.859    10.134
   124.219     9.956
>
   124.859    10.134
   124.219     9.956
>
   123.966    10.317
   124.186     9.999
>
   123.966    10.317
   124.186     9.999
>
   123.862     9.691
   124.186     9.999
>
   123.862     9.691
   124.186     9.999
>
   124.859    10.134
   124.186     9.999
>
   124.859    10.134
   124.186     9.999
>
   123.966    10.317
   124.150    10.006
>
   123.966    10.317
   124.150    10.006
>
   123.862     9.691
   124.150    10.006
>
   123.862     9.691
   124.150    10.006
>
   124.859    10.134
   124.150    10.006
>
   124.859    10.134
   124.150    10.006
>
   123.862     9.691
   124.074     9.895
>
   123.862     9.691
   124.074     9.895
>
   123.966    10.317
   124.074     9.895
>
   123.966    10.317
   124.074     9.895
>
   124.859    10.134
   124.074     9.895
>
   124.859    10.134
   124.074     9.895
>
   123.236     9.343
   124.074     9.895
>
   123.236     9.343
   124.074     9.895
>
   123.966    10.317
   124.157    10.037
>
   123.966    10.317
   124.157    10.037
>
   123.862     9.691
   124.157    10.037
>
   123.862     9.691
   124.157    10.037
>
   124.859    10.134
   124.157    10.037
>
   124.859    10.134
   124.157    10.037
>
   123.862     9.691
   124.202     9.945
>
   123.862     9.691
   124.202     9.945
>
   123.966    10.317
   124.202     9.945
>
   123.966    10.317
   124.202     9.945
>
   124.859    10.134
   124.202     9.945
>
   124.859    10.134
   124.202     9.945
>
   123.862     9.691
   123.669     9.690
>
   123.862     9.691
   123.669     9.690
>
   123.236     9.343
   123.669     9.690
>
   123.236     9.343
   123.669     9.690
>
   123.966    10.317
   123.669     9.690
>
   123.966    10.317
   123.669     9.690
>
   123.862     9.691
   124.023     9.893
>
   123.862     9.691
   124.023     9.893
>
   123.966    10.317
   124.023     9.893
>
   123.966    10.317
   124.023     9.893
>
   124.859    10.134
   124.023     9.893
>
   124.859    10.134
   124.023     9.893
>
   123.236     9.343
   124.023     9.893
>
   123.236     9.343
   124.023     9.893
>
   123.966    10.317
   124.170    10.043
>
   123.966    10.317
   124.170    10.043
>
   123.862     9.691
   124.170    10.043
>
   124.859    10.134
   124.170    10.043
>
   123.862     9.691
   123.697     9.692
>
   123.236     9.343
   123.697     9.692
>
   123.236     9.343
   123.697     9.692
>
   123.966    10.317
   123.697     9.692
>
   123.966    10.317
   123.697     9.692
>
   123.966    10.317
   124.173    10.041
>
   123.966    10.317
   124.173    10.041
>
   123.862     9.691
   124.173    10.041
>
   123.862     9.691
   124.173    10.041
>
   124.859    10.134
   124.173    10.041
>
   124.859    10.134
   124.173    10.041
>
   123.966    10.317
   124.163    10.058
>
   123.966    10.317
   124.163    10.058
>
   123.862     9.691
   124.163    10.058
>
   123.862     9.691
   124.163    10.058
>
   124.859    10.134
   124.163    10.058
>
   123.862     9.691
   124.111     9.943
>
   123.862     9.691
   124.111     9.943
>
   123.966    10.317
   124.111     9.943
>
   123.966    10.317
   124.111     9.943
>
   124.859    10.134
   124.111     9.943
>
   124.859    10.134
   124.111     9.943
>
   123.862     9.691
   124.146     9.960
>
   123.862     9.691
   124.146     9.960
>
   123.966    10.317
   124.146     9.960
>
   123.966    10.317
   124.146     9.960
>
   124.859    10.134
   124.146     9.960
>
   124.859    10.134
   124.146     9.960
>
   123.862     9.691
   123.896     9.838
>
   123.862     9.691
   123.896     9.838
>
   123.966    10.317
   123.896     9.838
>
   123.966    10.317
   123.896     9.838
>
   123.236     9.343
   123.896     9.838
>
   123.236     9.343
   123.896     9.838
>
   124.859    10.134
   123.896     9.838
>
   124.859    10.134
   123.896     9.838
>
   123.862     9.691
   123.651     9.709
>
   123.862     9.691
   123.651     9.709
>
   123.236     9.343
   123.651     9.709
>
   123.236     9.343
   123.651     9.709
>
   123.966    10.317
   123.651     9.709
>
   123.966    10.317
   123.651     9.709
>
   124.859    10.134
   124.269     9.903
>
   124.859    10.134
   124.269     9.903
>
   123.862     9.691
   124.252     9.905
>
   123.862     9.691
   124.252     9.905
>
   123.966    10.317
   124.252     9.905
>
   123.966    10.317
   124.252     9.905
>
   124.859    10.134
   124.252     9.905
>
   124.859    10.134
   124.252     9.905
>
   123.862     9.691
   124.158     9.956
>
   123.862     9.691
   124.158     9.956
>
   123.966    10.317
   124.158     9.956
>
   124.859    10.134
   124.158     9.956
>
   124.859    10.134
   124.158     9.956
>
   123.862     9.691
   123.698     9.691
>
   123.862     9.691
   123.698     9.691
>
   123.236     9.343
   123.698     9.691
>
   123.236     9.343
   123.698     9.691
>
   123.966    10.317
   123.698     9.691
>
   123.966    10.317
   123.698     9.691
>
   123.862     9.691
   124.135     9.894
>
   123.862     9.691
   124.135     9.894
>
   123.966    10.317
   124.135     9.894
>
   123.966    10.317
   124.135     9.894
>
   124.859    10.134
   124.135     9.894
>
   124.859    10.134
   124.135     9.894
>
   123.862     9.691
   123.618     9.690
>
   123.236     9.343
   123.618     9.690
>
   123.236     9.343
   123.618     9.690
>
   123.966    10.317
   123.618     9.690
>
   123.966    10.317
   123.618     9.690
>
   123.862     9.691
   123.664     9.673
>
   123.862     9.691
   123.664     9.673
>
   123.236     9.343
   123.664     9.673
>
   123.236     9.343
   123.664     9.673
>
   123.966    10.317
   123.664     9.673
>
   123.966    10.317
   123.664     9.673
>
   123.862     9.691
   123.660     9.687
>
   123.862     9.691
   123.660     9.687
>
   123.236     9.343
   123.660     9.687
>
   123.236     9.343
   123.660     9.687
>
   123.966    10.317
   123.660     9.687
>
   123.966    10.317
   123.660     9.687
>
   123.862     9.691
   123.626     9.688
>
   123.862     9.691
   123.626     9.688
>
   123.236     9.343
   123.626     9.688
>
   123.236     9.343
   123.626     9.688
>
   123.966    10.317
   123.626     9.688
>
   123.966    10.317
   123.626     9.688
>
   123.862     9.691
   124.067     9.921
>
   123.862     9.691
   124.067     9.921
>
   123.966    10.317
   124.067     9.921
>
   123.966    10.317
   124.067     9.921
>
   124.859    10.134
   124.067     9.921
>
   124.859    10.134
   124.067     9.921
>
   123.862     9.691
   123.610     9.675
>
   123.862     9.691
   123.610     9.675
>
   123.236     9.343
   123.610     9.675
>
   123.236     9.343
   123.610     9.675
>
   123.966    10.317
   123.610     9.675
>
   123.966    10.317
   123.610     9.675
>
   123.862     9.691
   124.008     9.542
>
   123.862     9.691
   124.008     9.542
>
   123.966    10.317
   124.008     9.542
>
   123.966    10.317
   124.008     9.542
>
   123.236     9.343
   124.008     9.542
>
   123.236     9.343
   124.008     9.542
>
   123.862     9.691
   123.918     9.625
>
   123.862     9.691
   123.918     9.625
>
   123.236     9.343
   123.918     9.625
>
   123.236     9.343
   123.918     9.625
>
   123.966    10.317
   123.918     9.625
>
   123.966    10.317
   123.918     9.625
>
   123.862     9.691
   123.617     9.756
>
   123.862     9.691
   123.617     9.756
>
   123.236     9.343
   123.617     9.756
>
   123.236     9.343
   123.617     9.756
>
   123.966    10.317
   123.617     9.756
>
   123.966    10.317
   123.617     9.756
>
   123.862     9.691
   124.058     9.928
>
   123.862     9.691
   124.058     9.928
>
   123.966    10.317
   124.058     9.928
>
   123.966    10.317
   124.058     9.928
>
   124.859    10.134
   124.058     9.928
>
   124.859    10.134
   124.058     9.928
>
   123.236     9.343
   124.058     9.928
>
   123.236     9.343
   124.058     9.928
>
   123.862     9.691
   123.691     9.771
>
   123.862     9.691
   123.691     9.771
>
   123.966    10.317
   123.691     9.771
>
   123.966    10.317
   123.691     9.771
>
   123.236     9.343
   123.691     9.771
>
   123.236     9.343
   123.691     9.771
>
   123.236     9.343
   124.036     9.931
>
   123.966    10.317
   123.803     9.768
>
   123.966    10.317
   123.803     9.768
>
   123.236     9.343
   123.803     9.768
>
   123.236     9.343
   123.803     9.768
>
   123.862     9.691
   124.355     9.821
>
   123.862     9.691
   124.355     9.821
>
   124.859    10.134
   124.355     9.821
>
   124.859    10.134
   124.355     9.821
>
   123.966    10.317
   124.355     9.821
>
   123.966    10.317
   124.355     9.821
>
   123.862     9.691
   124.330     9.846
>
   123.862     9.691
   124.330     9.846
>
   124.859    10.134
   124.330     9.846
>
   124.859    10.134
   124.330     9.846
>
   123.966    10.317
   124.330     9.846
>
   123.966    10.317
   124.330     9.846
>
   123.862     9.691
   123.739     9.728
>
   123.862     9.691
   123.739     9.728
>
   123.966    10.317
   123.739     9.728
>
   123.966    10.317
   123.739     9.728
>
   123.862     9.691
   124.289     9.929
>
   123.862     9.691
   124.289     9.929
>
   123.966    10.317
   124.289     9.929
>
   123.966    10.317
   124.289     9.929
>
   124.859    10.134
   124.289     9.929
>
   124.859    10.134
   124.289     9.929
>
   123.862     9.691
   123.640     9.893
>
   123.966    10.317
   123.640     9.893
>
   123.862     9.691
   124.131     9.891
>
   123.862     9.691
   124.131     9.891
>
   123.966    10.317
   124.131     9.891
>
   123.966    10.317
   124.131     9.891
>
   124.859    10.134
   124.131     9.891
>
   124.859    10.134
   124.131     9.891
>
   123.862     9.691
   123.950     9.820
>
   123.862     9.691
   123.950     9.820
>
   123.862     9.691
   123.950     9.820
>
   123.966    10.317
   123.950     9.820
>
   123.236     9.343
   123.950     9.820
>
   123.236     9.343
   123.950     9.820
>
   124.859    10.134
   123.950     9.820
>
   123.862     9.691
   124.124     9.896
>
   123.862     9.691
   124.124     9.896
>
   123.966    10.317
   124.124     9.896
>
   123.966    10.317
   124.124     9.896
>
   124.859    10.134
   124.124     9.896
>
   124.859    10.134
   124.124     9.896
>
   123.862     9.691
   124.019     9.774
>
   123.862     9.691
   124.019     9.774
>
   123.966    10.317
   124.019     9.774
>
   123.966    10.317
   124.019     9.774
>
   123.236     9.343
   124.019     9.774
>
   123.236     9.343
   124.019     9.774
>
   124.859    10.134
   124.019     9.774
>
   124.859    10.134
   124.019     9.774
>
   123.236     9.343
   123.635     9.688
>
   123.966    10.317
   123.635     9.688
>
   123.862     9.691
   123.656     9.622
>
   123.236     9.343
   123.656     9.622
>
   123.966    10.317
   123.656     9.622
>
   123.862     9.691
   124.080     9.969
>
   123.862     9.691
   124.080     9.969
>
   123.966    10.317
   124.080     9.969
>
   123.966    10.317
   124.080     9.969
>
   124.859    10.134
   124.080     9.969
>
   124.859    10.134
   124.080     9.969
>
   123.862     9.691
   123.629     9.645
>
   123.862     9.691
   123.629     9.645
>
   123.966    10.317
   124.175    10.003
>
   123.862     9.691
   124.175    10.003
>
   123.862     9.691
   124.175    10.003
>
   124.859    10.134
   124.175    10.003
>
   124.859    10.134
   124.175    10.003
>
   123.862     9.691
   124.076     9.891
>
   123.862     9.691
   124.076     9.891
>
   123.966    10.317
   124.076     9.891
>
   123.966    10.317
   124.076     9.891
>
   124.859    10.134
   124.076     9.891
>
   124.859    10.134
   124.076     9.891
>
   123.236     9.343
   124.076     9.891
>
   123.236     9.343
   124.076     9.891
>
   123.966    10.317
   124.102    10.072
>
   123.966    10.317
   124.102    10.072
>
   123.862     9.691
   124.102    10.072
>
   123.862     9.691
   124.102    10.072
>
   123.966    10.317
   124.203    10.048
>
   123.966    10.317
   124.203    10.048
>
   123.862     9.691
   124.203    10.048
>
   123.862     9.691
   124.203    10.048
>
   123.966    10.317
   124.186    10.073
>
   123.966    10.317
   124.186    10.073
>
   123.862     9.691
   124.186    10.073
>
   123.862     9.691
   124.186    10.073
>
   123.862     9.691
   123.652     9.644
>
   123.862     9.691
   123.652     9.644
>
   123.236     9.343
   123.652     9.644
>
   123.236     9.343
   123.652     9.644
>
   123.966    10.317
   123.652     9.644
>
   123.966    10.317
   124.110    10.055
>
   123.862     9.691
   124.110    10.055
>
   123.862     9.691
   124.110    10.055
>
   123.966    10.317
   124.244    10.039
>
   123.966    10.317
   124.244    10.039
>
   123.862     9.691
   124.244    10.039
>
   123.862     9.691
   124.244    10.039
>
   123.862     9.691
   124.068     9.907
>
   123.862     9.691
   124.068     9.907
>
   123.966    10.317
   124.068     9.907
>
   123.966    10.317
   124.068     9.907
>
   123.236     9.343
   124.068     9.907
>
   123.236     9.343
   124.068     9.907
>
   123.966    10.317
   124.176    10.068
>
   123.966    10.317
   124.176    10.068
>
   123.862     9.691
   124.176    10.068
>
   123.862     9.691
   124.176    10.068
>
   123.966    10.317
   124.160    10.025
>
   123.966    10.317
   124.160    10.025
>
   124.859    10.134
   124.160    10.025
>
   124.859    10.134
   124.160    10.025
>
   123.966    10.317
   124.097    10.028
>
   123.966    10.317
   124.097    10.028
>
   123.966    10.317
   124.160    10.070
>
   123.966    10.317
   124.160    10.070
>
   123.966    10.317
   124.133     9.958
>
   123.966    10.317
   124.133     9.958
>
   124.859    10.134
   124.133     9.958
>
   124.859    10.134
   124.133     9.958
>
   123.862     9.691
   124.107     9.885
>
   123.862     9.691
   124.107     9.885
>
   123.966    10.317
   124.107     9.885
>
   123.966    10.317
   124.107     9.885
>
   123.862     9.691
   124.167     9.860
>
   123.862     9.691
   124.167     9.860
>
   123.966    10.317
   124.167     9.860
>
   123.966    10.317
   124.167     9.860
>
   123.862     9.691
   124.147    10.041
>
   123.862     9.691
   124.147    10.041
>
   123.966    10.317
   123.696     9.779
>
   123.966    10.317
   123.696     9.779
>
   123.966    10.317
   124.053     9.880
>
   123.966    10.317
   124.053     9.880
>
   123.966    10.317
   124.136     9.918
>
   123.966    10.317
   124.136     9.918
>
   123.966    10.317
   124.072     9.952
>
   123.966    10.317
   124.072     9.952
>
   123.966    10.317
   124.156    10.046
>
   123.966    10.317
   124.156    10.046
>
   123.966    10.317
   124.187    10.047
>
   123.966    10.317
   124.187    10.047
>
   123.966    10.317
   124.128     9.917
>
   123.966    10.317
   124.128     9.917
>
   123.966    10.317
   124.139     9.892
>
   123.966    10.317
   124.139     9.892
>
   123.236     9.343
   123.642     9.725
>
   123.236     9.343
   123.642     9.725
>
   123.966    10.317
   123.642     9.725
>
   123.966    10.317
   123.642     9.725
>
   123.966    10.317
   124.081     9.891
>
   123.966    10.317
   124.081     9.891
>
   123.236     9.343
   124.081     9.891
>
   123.236     9.343
   124.081     9.891
>
   123.966    10.317
   124.142    10.054
>
   123.966    10.317
   124.142    10.054
>
   123.966    10.317
   123.922     9.788
>
   123.966    10.317
   123.922     9.788
>
   123.236     9.343
   123.922     9.788
>
   123.236     9.343
   123.922     9.788
>
   123.966    10.317
   123.930     9.918
>
   123.966    10.317
   123.930     9.918
>
   123.236     9.343
   123.930     9.918
>
   123.236     9.343
   123.930     9.918
>
   124.859    10.134
   124.058     9.884
>
   124.859    10.134
   124.058     9.884
>
   123.236     9.343
   124.058     9.884
>
   123.236     9.343
   124.058     9.884
>
   124.859    10.134
   124.021     9.920
>
   124.859    10.134
   124.021     9.920
>
   123.236     9.343
   124.021     9.920
>
   123.236     9.343
   124.021     9.920
>
   123.966    10.317
   124.214    10.055
>
   123.966    10.317
   124.214    10.055
>
   124.859    10.134
   124.214    10.055
>
   124.859    10.134
   124.214    10.055
>
   123.966    10.317
   124.023     9.903
>
   123.966    10.317
   124.023     9.903
>
   124.859    10.134
   124.023     9.903
>
   124.859    10.134
   124.023     9.903
>
   123.236     9.343
   124.023     9.903
>
   123.236     9.343
   124.023     9.903
>
   123.966    10.317
   124.164    10.046
>
   123.966    10.317
   124.164    10.046
>
   124.859    10.134
   124.164    10.046
>
   124.859    10.134
   124.164    10.046
>
   123.966    10.317
   124.115    10.249
>
   123.966    10.317
   124.115    10.249
>
   124.859    10.134
   124.115    10.249
>
   124.859    10.134
   124.115    10.249
>
   124.609    11.051
   124.115    10.249
>
   123.966    10.317
   124.243     9.880
>
   123.966    10.317
   124.243     9.880
>
   123.966    10.317
   123.964     9.811
>
   123.966    10.317
   123.964     9.811
>
   123.236     9.343
   123.964     9.811
>
   123.236     9.343
   123.964     9.811
>
   124.859    10.134
   123.964     9.811
>
   124.859    10.134
   123.964     9.811
>
   123.966    10.317
   124.007     9.871
>
   123.966    10.317
   124.007     9.871
>
   124.859    10.134
   124.007     9.871
>
   124.859    10.134
   124.007     9.871
>
   123.236     9.343
   124.007     9.871
>
   123.236     9.343
   124.007     9.871
>
   123.236     9.343
   123.676     9.720
>
   123.236     9.343
   123.676     9.720
>
   123.966    10.317
   123.676     9.720
>
   123.966    10.317
   123.676     9.720
>
   123.236     9.343
   123.668     9.769
>
   123.966    10.317
   123.668     9.769
>
   123.966    10.317
   123.668     9.769
>
   123.236     9.343
   123.637     9.724
>
   123.236     9.343
   123.637     9.724
>
   123.966    10.317
   124.177    10.086
>
   123.966    10.317
   124.177    10.086
>
   123.966    10.317
   124.015     9.884
>
   123.966    10.317
   124.015     9.884
>
   124.859    10.134
   124.015     9.884
>
   124.859    10.134
   124.015     9.884
>
   123.966    10.317
   124.234    10.097
>
   123.966    10.317
   124.234    10.097
>
   123.862     9.691
   124.234    10.097
>
   123.862     9.691
   124.234    10.097
>
   124.859    10.134
   124.234    10.097
>
   124.859    10.134
   124.234    10.097
>
   123.862     9.691
   124.212     9.917
>
   123.862     9.691
   124.212     9.917
>
   124.859    10.134
   124.212     9.917
>
   124.859    10.134
   124.212     9.917
>
   123.862     9.691
   124.163     9.815
>
   123.862     9.691
   124.163     9.815
>
   123.966    10.317
   124.163     9.815
>
   123.966    10.317
   124.163     9.815
>
   124.859    10.134
   124.163     9.815
>
   124.859    10.134
   124.163     9.815
>
   124.859    10.134
   124.251     9.999
>
   123.862     9.691
   124.251     9.999
>
   123.966    10.317
   124.251     9.999
>
   123.966    10.317
   124.251     9.999
>
   123.862     9.691
   124.029     9.867
>
   123.862     9.691
   124.029     9.867
>
   123.966    10.317
   124.029     9.867
>
   123.966    10.317
   124.029     9.867
>
   124.859    10.134
   124.029     9.867
>
   124.859    10.134
   124.029     9.867
>
   123.966    10.317
   124.249     9.942
>
   123.966    10.317
   124.249     9.942
>
   124.859    10.134
   124.249     9.942
>
   124.859    10.134
   124.249     9.942
>
   123.966    10.317
   124.283     9.917
>
   123.966    10.317
   124.283     9.917
>
   124.859    10.134
   124.283     9.917
>
   124.859    10.134
   124.283     9.917
>
   123.966    10.317
   124.102     9.945
>
   123.966    10.317
   124.102     9.945
>
   124.859    10.134
   124.102     9.945
>
   124.859    10.134
   124.102     9.945
>
   123.966    10.317
   124.070     9.937
>
   123.966    10.317
   124.070     9.937
>
   124.859    10.134
   124.070     9.937
>
   124.859    10.134
   124.070     9.937
>
   123.966    10.317
   124.058     9.891
>
   123.966    10.317
   124.058     9.891
>
   124.859    10.134
   124.058     9.891
>
   123.236     9.343
   124.058     9.891
>
   123.236     9.343
   124.058     9.891
>
   123.966    10.317
   124.136    10.012
>
   123.966    10.317
   124.136    10.012
>
   124.859    10.134
   124.136    10.012
>
   124.859    10.134
   124.136    10.012
>
   123.862     9.691
   124.074     9.910
>
   123.862     9.691
   124.074     9.910
>
   123.966    10.317
   124.074     9.910
>
   123.966    10.317
   124.074     9.910
>
   124.859    10.134
   124.074     9.910
>
   124.859    10.134
   124.074     9.910
>
   123.966    10.317
   124.024     9.963
>
   124.859    10.134
   124.024     9.963
>
   124.859    10.134
   124.024     9.963
>
   123.966    10.317
   124.040     9.906
>
   123.966    10.317
   124.040     9.906
>
   124.859    10.134
   124.040     9.906
>
   124.859    10.134
   124.040     9.906
>
   123.236     9.343
   124.040     9.906
>
   123.236     9.343
   124.040     9.906
>
   123.862     9.691
   124.009     9.897
>
   123.862     9.691
   124.009     9.897
>
   123.966    10.317
   124.009     9.897
>
   123.966    10.317
   124.009     9.897
>
   124.859    10.134
   124.009     9.897
>
   124.859    10.134
   124.009     9.897
>
   123.966    10.317
   124.061     9.924
>
   123.966    10.317
   124.061     9.924
>
   123.862     9.691
   124.061     9.924
>
   123.862     9.691
   124.061     9.924
>
   124.859    10.134
   124.061     9.924
>
   124.859    10.134
   124.061     9.924
>
   123.862     9.691
   123.599     9.766
>
   123.862     9.691
   123.599     9.766
>
   123.966    10.317
   123.599     9.766
>
   123.966    10.317
   123.599     9.766
>
   122.639     9.828
   123.599     9.766
>
   122.639     9.828
   123.599     9.766
>
   123.966    10.317
   123.875     9.842
>
   123.966    10.317
   123.875     9.842
>
   123.966    10.317
   123.713     9.751
>
   123.966    10.317
   123.713     9.751
>
   123.966    10.317
   124.194     9.894
>
   123.966    10.317
   124.194     9.894
>
   124.859    10.134
   124.194     9.894
>
   124.859    10.134
   124.194     9.894
>
   123.966    10.317
   124.170    10.022
>
   123.966    10.317
   124.170    10.022
>
   124.859    10.134
   124.170    10.022
>
   124.859    10.134
   124.170    10.022
>
   124.859    10.134
   124.170    10.022
>
   125.621     8.969
   125.073     9.410
>
   124.859    10.134
   125.073     9.410
>
   124.859    10.134
   125.073     9.410
>
   123.966    10.317
   123.916     9.758
>
   123.966    10.317
   123.916     9.758
>
   123.236     9.343
   123.916     9.758
>
   123.236     9.343
   123.916     9.758
>
   123.236     9.343
   123.663     9.154
>
   123.236     9.343
   123.663     9.154
>
   123.352     8.583
   123.663     9.154
>
   123.352     8.583
   123.663     9.154
>
   125.489     9.782
   124.675     9.811
>
   125.489     9.782
   124.675     9.811
>
   123.966    10.317
   124.675     9.811
>
   123.862     9.691
   124.675     9.811
>
   123.862     9.691
   124.078     9.887
>
   123.862     9.691
   124.078     9.887
>
   123.966    10.317
   124.078     9.887
>
   123.966    10.317
   124.078     9.887
>
   124.859    10.134
   124.078     9.887
>
   124.859    10.134
   124.078     9.887
>
   123.236     9.343
   124.078     9.887
>
   123.236     9.343
   124.078     9.887
>
   123.862     9.691
   124.018     9.910
>
   123.862     9.691
   124.018     9.910
>
   124.859    10.134
   124.018     9.910
>
   124.859    10.134
   124.018     9.910
>
   123.236     9.343
   124.018     9.910
>
   123.236     9.343
   124.018     9.910
>
   123.862     9.691
   123.969     9.829
>
   123.862     9.691
   123.969     9.829
>
   124.321     9.630
   123.969     9.829
>
   124.321     9.630
   123.969     9.829
>
   124.332    10.091
   123.969     9.829
>
   124.332    10.091
   123.969     9.829
>
   123.966    10.317
   123.969     9.829
>
   123.966    10.317
   123.969     9.829
>
   123.631     9.131
   123.969     9.829
>
   123.631     9.131
   123.969     9.829
>
   124.859    10.134
   123.969     9.829
>
   124.859    10.134
   123.969     9.829
>
   123.966    10.317
   123.666    10.107
>
   123.966    10.317
   123.666    10.107
>
   124.332    10.091
   123.666    10.107
>
   124.332    10.091
   123.666    10.107
>
   123.631     9.131
   123.666    10.107
>
   124.859    10.134
   124.785    10.113
>
   124.332    10.091
   124.785    10.113
>
   124.332    10.091
   124.785    10.113
>
   124.321     9.630
   124.785    10.113
>
   124.321     9.630
   124.785    10.113
>
   125.489     9.782
   124.785    10.113
>
   125.489     9.782
   124.785    10.113
>
   123.966    10.317
   124.785    10.113
>
   124.609    11.051
   124.785    10.113
>
   124.332    10.091
   124.178    10.048
>
   124.332    10.091
   124.178    10.048
>
   124.321     9.630
   124.178    10.048
>
   123.966    10.317
   124.178    10.048
>
   123.862     9.691
   124.178    10.048
>
   124.859    10.134
   124.178    10.048
>
   124.321     9.630
   124.473     9.781
>
   124.321     9.630
   124.473     9.781
>
   124.332    10.091
   124.473     9.781
>
   124.332    10.091
   124.473     9.781
>
   124.859    10.134
   124.473     9.781
>
   124.859    10.134
   124.473     9.781
>
   123.862     9.691
   124.473     9.781
>
   123.862     9.691
   124.473     9.781
>
   123.966    10.317
   124.473     9.781
>
   123.966    10.317
   124.473     9.781
>
   123.524     9.770
   124.473     9.781
>
   123.524     9.770
   124.473     9.781
>
   123.862     9.691
   124.036     9.892
>
   123.862     9.691
   124.036     9.892
>
   124.332    10.091
   124.036     9.892
>
   124.332    10.091
   124.036     9.892
>
   124.321     9.630
   124.036     9.892
>
   124.321     9.630
   124.036     9.892
>
   123.966    10.317
   124.036     9.892
>
   123.966    10.317
   124.036     9.892
>
   123.631     9.131
   124.036     9.892
>
   123.631     9.131
   124.036     9.892
>
   124.859    10.134
   124.036     9.892
>
   124.859    10.134
   124.036     9.892
>
   124.859    10.134
   124.036     9.892
>
   124.332    10.091
   124.033     9.899
>
   124.321     9.630
   124.033     9.899
>
   123.966    10.317
   124.033     9.899
>
   123.966    10.317
   124.033     9.899
>
   124.859    10.134
   124.033     9.899
>
   123.631     9.131
   124.033     9.899
>
   123.236     9.343
   124.033     9.899
>
   123.236     9.343
   124.033     9.899
>
   123.862     9.691
   124.023     9.898
>
   123.862     9.691
   124.023     9.898
>
   124.332    10.091
   124.023     9.898
>
   124.321     9.630
   124.023     9.898
>
   123.966    10.317
   124.023     9.898
>
   123.966    10.317
   124.023     9.898
>
   124.859    10.134
   124.023     9.898
>
   124.859    10.134
   124.023     9.898
>
   124.332    10.091
   124.102     9.924
>
   124.332    10.091
   124.102     9.924
>
   123.862     9.691
   124.102     9.924
>
   124.321     9.630
   124.102     9.924
>
   124.321     9.630
   124.102     9.924
>
   123.966    10.317
   124.102     9.924
>
   123.966    10.317
   124.102     9.924
>
   123.524     9.770
   124.102     9.924
>
   124.360    10.637
   124.102     9.924
>
   124.859    10.134
   124.102     9.924
>
   124.859    10.134
   124.102     9.924
>
   123.631     9.131
   124.102     9.924
>
   123.631     9.131
   124.102     9.924
>
   124.321     9.630
   124.159     9.876
>
   124.332    10.091
   124.159     9.876
>
   123.862     9.691
   124.159     9.876
>
   123.862     9.691
   124.159     9.876
>
   123.966    10.317
   124.159     9.876
>
   124.859    10.134
   124.159     9.876
>
   124.859    10.134
   124.159     9.876
>
   124.859    10.134
   124.159     9.876
>
   123.631     9.131
   124.159     9.876
>
   124.859    10.134
   124.987    10.090
>
   124.859    10.134
   124.987    10.090
>
   125.489     9.782
   124.987    10.090
>
   125.489     9.782
   124.987    10.090
>
   124.332    10.091
   124.987    10.090
>
   124.321     9.630
   124.987    10.090
>
   124.321     9.630
   124.987    10.090
>
   124.360    10.637
   124.987    10.090
>
   124.360    10.637
   124.987    10.090
>
   123.862     9.691
   124.035     9.866
>
   124.332    10.091
   124.035     9.866
>
   124.332    10.091
   124.035     9.866
>
   124.321     9.630
   124.035     9.866
>
   123.966    10.317
   124.035     9.866
>
   123.966    10.317
   124.035     9.866
>
   123.631     9.131
   124.035     9.866
>
   123.631     9.131
   124.035     9.866
>
   124.859    10.134
   124.035     9.866
>
   124.859    10.134
   124.035     9.866
>
   123.236     9.343
   124.035     9.866
>
   123.236     9.343
   124.035     9.866
>
   124.859    10.134
   124.711     9.811
>
   124.321     9.630
   124.711     9.811
>
   124.332    10.091
   124.711     9.811
>
   124.332    10.091
   124.711     9.811
>
   125.489     9.782
   124.711     9.811
>
   125.489     9.782
   124.711     9.811
>
   123.862     9.691
   124.711     9.811
>
   123.862     9.691
   124.711     9.811
>
   123.966    10.317
   124.711     9.811
>
   123.352     8.583
   124.047     9.282
>
   123.352     8.583
   124.047     9.282
>
   123.862     9.691
   123.983     9.863
>
   123.524     9.770
   123.983     9.863
>
   123.966    10.317
   123.983     9.863
>
   123.966    10.317
   123.983     9.863
>
   124.321     9.630
   123.983     9.863
>
   123.253    10.225
   123.983     9.863
>
   123.253    10.225
   123.983     9.863
>
   123.631     9.131
   123.983     9.863
>
   123.631     9.131
   123.983     9.863
>
   124.360    10.637
   123.983     9.863
>
   124.360    10.637
   123.983     9.863
>
   123.236     9.343
   123.983     9.863
>
   123.236     9.343
   123.983     9.863
>
   124.859    10.134
   123.983     9.863
>
   124.859    10.134
   123.983     9.863
>
   123.862     9.691
   124.083     9.892
>
   123.862     9.691
   124.083     9.892
>
   124.321     9.630
   124.083     9.892
>
   124.321     9.630
   124.083     9.892
>
   123.966    10.317
   124.083     9.892
>
   123.966    10.317
   124.083     9.892
>
   123.524     9.770
   124.083     9.892
>
   123.524     9.770
   124.083     9.892
>
   124.360    10.637
   124.083     9.892
>
   123.631     9.131
   124.083     9.892
>
   123.631     9.131
   124.083     9.892
>
   123.253    10.225
   124.083     9.892
>
   123.253    10.225
   124.083     9.892
>
   123.236     9.343
   124.083     9.892
>
   123.236     9.343
   124.083     9.892
>
   124.321     9.630
   124.258     9.151
>
   124.321     9.630
   124.258     9.151
>
   123.631     9.131
   124.258     9.151
>
   123.631     9.131
   124.258     9.151
>
   123.862     9.691
   124.258     9.151
>
   123.862     9.691
   124.258     9.151
>
   123.524     9.770
   124.258     9.151
>
   123.524     9.770
   124.258     9.151
>
   124.859    10.134
   125.096    10.098
>
   124.859    10.134
   125.096    10.098
>
   125.489     9.782
   125.096    10.098
>
   125.489     9.782
   125.096    10.098
>
   125.614    10.394
   125.096    10.098
>
   125.614    10.394
   125.096    10.098
>
   124.321     9.630
   125.096    10.098
>
   124.321     9.630
   125.096    10.098
>
   124.360    10.637
   125.096    10.098
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   123.906    10.331     0.300
   124.979    11.165     0.300
   123.981    10.323     0.300
   125.489     9.782     0.300
   124.672     9.233     0.300
   123.862     9.691     0.300
   123.966    10.317     0.300
   123.236     9.343     0.300
   124.859    10.134     0.300
   124.609    11.051     0.300
   125.621     8.969     0.300
   122.639     9.828     0.300
   123.352     8.583     0.300
   124.321     9.630     0.300
   124.332    10.091     0.300
   123.631     9.131     0.300
   123.524     9.770     0.300
   124.360    10.637     0.300
   123.253    10.225     0.300
   125.614    10.394     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   123.979     9.579     0.200
>
   124.878    10.247     0.200
>
   123.668     9.328     0.200
>
   124.582     9.801     0.200
>
   124.581     9.667     0.200
>
   124.540     9.761     0.200
>
   124.391     9.735     0.200
>
   124.741     9.761     0.200
>
   124.875     9.882     0.200
>
   124.824     9.867     0.200
>
   124.841     9.892     0.200
>
   124.681     9.808     0.200
>
   124.760     9.796     0.200
>
   125.078    10.338     0.200
>
   125.057    10.316     0.200
>
   125.035    10.361     0.200
>
   125.077    10.312     0.200
>
   125.060    10.331     0.200
>
   124.842    10.291     0.200
>
   124.857    10.231     0.200
>
   123.483    10.160     0.200
>
   125.070    10.163     0.200
>
   123.982    10.006     0.200
>
   125.093    10.342     0.200
>
   125.056    10.301     0.200
>
   124.882     9.796     0.200
>
   125.117     9.561     0.200
>
   124.776     9.824     0.200
>
   124.825     9.803     0.200
>
   124.771     9.843     0.200
>
   125.149    10.071     0.200
>
   123.571     9.772     0.200
>
   124.721     9.874     0.200
>
   124.686     9.866     0.200
>
   124.784    10.289     0.200
>
   124.013    10.006     0.200
>
   125.072    10.147     0.200
>
   124.720     9.870     0.200
>
   124.685     9.854     0.200
>
   124.262     9.662     0.200
>
   125.066    10.126     0.200
>
   125.056     9.641     0.200
>
   125.030    10.299     0.200
>
   124.250     9.606     0.200
>
   124.518     9.786     0.200
>
   124.512     9.788     0.200
>
   124.697     9.638     0.200
>
   125.025     9.928     0.200
>
   125.110    10.303     0.200
>
   124.514     9.774     0.200
>
   125.048     9.443     0.200
>
   124.036     9.380     0.200
>
   124.004     9.247     0.200
>
   124.304     9.430     0.200
>
   125.039    10.152     0.200
>
   125.255     9.838     0.200
>
   124.040     9.908     0.200
>
   124.080     9.892     0.200
>
   124.090    10.035     0.200
>
   124.026     9.949     0.200
>
   123.664     9.751     0.200
>
   124.158    10.018     0.200
>
   123.830     9.835     0.200
>
   124.118     9.983     0.200
>
   124.007     9.848     0.200
>
   124.078     9.813     0.200
>
   124.006     9.897     0.200
>
   124.120     9.999     0.200
>
   124.182    10.065     0.200
>
   124.131    10.021     0.200
>
   124.146    10.020     0.200
>
   124.127     9.943     0.200
>
   123.845     9.904     0.200
>
   123.892     9.898     0.200
>
   124.033     9.971     0.200
>
   124.014     9.873     0.200
>
   123.663     9.761     0.200
>
   124.005     9.850     0.200
>
   123.688     9.763     0.200
>
   123.950     9.838     0.200
>
   124.139     9.989     0.200
>
   124.036     9.908     0.200
>
   124.019     9.895     0.200
>
   124.021     9.944     0.200
>
   124.174    10.065     0.200
>
   124.025     9.845     0.200
>
   123.692     9.691     0.200
>
   124.036     9.885     0.200
>
   123.923     9.845     0.200
>
   123.869     9.772     0.200
>
   123.847     9.764     0.200
>
   124.169    10.056     0.200
>
   124.138    10.080     0.200
>
   123.735     9.773     0.200
>
   123.804     9.800     0.200
>
   124.005     9.856     0.200
>
   124.162    10.009     0.200
>
   124.172     9.891     0.200
>
   123.707     9.783     0.200
>
   124.003     9.928     0.200
>
   124.018     9.858     0.200
>
   124.126     9.867     0.200
>
   124.154     9.943     0.200
>
   124.181     9.994     0.200
>
   123.964     9.784     0.200
>
   123.651     9.725     0.200
>
   123.844     9.902     0.200
>
   124.174     9.943     0.200
>
   124.080    10.008     0.200
>
   124.043     9.849     0.200
>
   123.749     9.782     0.200
>
   124.138     9.840     0.200
>
   123.904     9.815     0.200
>
   124.219     9.956     0.200
>
   124.186     9.999     0.200
>
   124.150    10.006     0.200
>
   124.074     9.895     0.200
>
   124.157    10.037     0.200
>
   124.202     9.945     0.200
>
   123.669     9.690     0.200
>
   124.023     9.893     0.200
>
   124.170    10.043     0.200
>
   123.697     9.692     0.200
>
   124.173    10.041     0.200
>
   124.163    10.058     0.200
>
   124.111     9.943     0.200
>
   124.146     9.960     0.200
>
   123.896     9.838     0.200
>
   123.651     9.709     0.200
>
   124.269     9.903     0.200
>
   124.252     9.905     0.200
>
   124.158     9.956     0.200
>
   123.698     9.691     0.200
>
   124.135     9.894     0.200
>
   123.618     9.690     0.200
>
   123.664     9.673     0.200
>
   123.660     9.687     0.200
>
   123.626     9.688     0.200
>
   124.067     9.921     0.200
>
   123.610     9.675     0.200
>
   124.008     9.542     0.200
>
   123.918     9.625     0.200
>
   123.617     9.756     0.200
>
   124.058     9.928     0.200
>
   123.691     9.771     0.200
>
   124.036     9.931     0.200
>
   123.803     9.768     0.200
>
   124.355     9.821     0.200
>
   124.330     9.846     0.200
>
   123.739     9.728     0.200
>
   124.289     9.929     0.200
>
   123.591     9.747     0.200
>
   123.640     9.893     0.200
>
   124.131     9.891     0.200
>
   123.950     9.820     0.200
>
   124.124     9.896     0.200
>
   124.019     9.774     0.200
>
   123.635     9.688     0.200
>
   123.656     9.622     0.200
>
   124.080     9.969     0.200
>
   123.629     9.645     0.200
>
   124.175    10.003     0.200
>
   124.076     9.891     0.200
>
   124.102    10.072     0.200
>
   124.203    10.048     0.200
>
   124.186    10.073     0.200
>
   123.652     9.644     0.200
>
   124.110    10.055     0.200
>
   124.244    10.039     0.200
>
   124.068     9.907     0.200
>
   124.176    10.068     0.200
>
   124.004     9.902     0.200
>
   124.160    10.025     0.200
>
   124.097    10.028     0.200
>
   124.160    10.070     0.200
>
   124.133     9.958     0.200
>
   124.107     9.885     0.200
>
   124.167     9.860     0.200
>
   124.147    10.041     0.200
>
   123.696     9.779     0.200
>
   124.053     9.880     0.200
>
   124.136     9.918     0.200
>
   124.072     9.952     0.200
>
   124.156    10.046     0.200
>
   124.187    10.047     0.200
>
   124.128     9.917     0.200
>
   124.139     9.892     0.200
>
   123.642     9.725     0.200
>
   124.081     9.891     0.200
>
   124.142    10.054     0.200
>
   123.922     9.788     0.200
>
   123.930     9.918     0.200
>
   124.058     9.884     0.200
>
   124.021     9.920     0.200
>
   124.214    10.055     0.200
>
   124.023     9.903     0.200
>
   124.164    10.046     0.200
>
   124.115    10.249     0.200
>
   124.243     9.880     0.200
>
   123.964     9.811     0.200
>
   124.007     9.871     0.200
>
   123.676     9.720     0.200
>
   123.668     9.769     0.200
>
   123.637     9.724     0.200
>
   124.177    10.086     0.200
>
   124.015     9.884     0.200
>
   124.234    10.097     0.200
>
   124.212     9.917     0.200
>
   124.163     9.815     0.200
>
   124.251     9.999     0.200
>
   124.029     9.867     0.200
>
   124.249     9.942     0.200
>
   124.283     9.917     0.200
>
   124.102     9.945     0.200
>
   124.070     9.937     0.200
>
   124.058     9.891     0.200
>
   124.136    10.012     0.200
>
   124.074     9.910     0.200
>
   124.024     9.963     0.200
>
   124.040     9.906     0.200
>
   124.009     9.897     0.200
>
   124.061     9.924     0.200
>
   123.599     9.766     0.200
>
   123.875     9.842     0.200
>
   123.713     9.751     0.200
>
   124.194     9.894     0.200
>
   124.170    10.022     0.200
>
   125.073     9.410     0.200
>
   123.916     9.758     0.200
>
   123.663     9.154     0.200
>
   124.675     9.811     0.200
>
   124.078     9.887     0.200
>
   124.018     9.910     0.200
>
   123.969     9.829     0.200
>
   123.666    10.107     0.200
>
   124.785    10.113     0.200
>
   124.178    10.048     0.200
>
   124.473     9.781     0.200
>
   124.036     9.892     0.200
>
   124.033     9.899     0.200
>
   124.023     9.898     0.200
>
   124.102     9.924     0.200
>
   124.159     9.876     0.200
>
   124.987    10.090     0.200
>
   124.035     9.866     0.200
>
   124.711     9.811     0.200
>
   124.954     9.722     0.200
>
   124.047     9.282     0.200
>
   123.983     9.863     0.200
>
   124.083     9.892     0.200
>
   124.258     9.151     0.200
>
   125.096    10.098     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   124.185     9.886     0.000   222.000   222.000
   124.185     9.886     0.000   444.000   444.000
EOF
gmt end
