#!/bin/bash
gmt begin bohol1.86_base pdf,ps
proj=-JM16.0c+
reg=-R123.4/125.4/9.1/10.5
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map bohol1.86'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   123.979     9.579 1
   124.878    10.247 2
   123.668     9.328 3
   124.582     9.801 4
   124.581     9.667 5
   124.540     9.761 6
   124.391     9.735 7
   124.741     9.761 8
   124.875     9.882 9
   124.824     9.867 10
   124.841     9.892 11
   124.681     9.808 12
   124.760     9.796 13
   125.078    10.338 14
   125.057    10.316 15
   125.035    10.361 16
   125.077    10.312 17
   125.060    10.331 18
   124.842    10.291 19
   124.857    10.231 20
   123.483    10.160 21
   125.070    10.163 22
   123.982    10.006 23
   125.093    10.342 24
   125.056    10.301 25
   124.882     9.796 26
   125.117     9.561 27
   124.776     9.824 28
   124.825     9.803 29
   124.771     9.843 30
   125.149    10.071 31
   123.571     9.772 32
   124.721     9.874 33
   124.686     9.866 34
   124.784    10.289 35
   124.013    10.006 36
   125.072    10.147 37
   124.720     9.870 38
   124.685     9.854 39
   124.262     9.662 40
   125.066    10.126 41
   125.056     9.641 42
   125.030    10.299 43
   124.250     9.606 44
   124.518     9.786 45
   124.512     9.788 46
   124.697     9.638 47
   125.025     9.928 48
   125.110    10.303 49
   124.514     9.774 50
   125.048     9.443 51
   124.036     9.380 52
   124.004     9.247 53
   124.304     9.430 54
   125.039    10.152 55
   125.255     9.838 56
   124.040     9.908 57
   124.080     9.892 58
   124.090    10.035 59
   124.026     9.949 60
   123.664     9.751 61
   124.158    10.018 62
   123.830     9.835 63
   124.118     9.983 64
   124.007     9.848 65
   124.078     9.813 66
   124.006     9.897 67
   124.120     9.999 68
   124.182    10.065 69
   124.131    10.021 70
   124.146    10.020 71
   124.127     9.943 72
   123.845     9.904 73
   123.892     9.898 74
   124.033     9.971 75
   124.014     9.873 76
   123.663     9.761 77
   124.005     9.850 78
   123.688     9.763 79
   123.950     9.838 80
   124.139     9.989 81
   124.036     9.908 82
   124.019     9.895 83
   124.021     9.944 84
   124.174    10.065 85
   124.025     9.845 86
   123.692     9.691 87
   124.036     9.885 88
   123.923     9.845 89
   123.869     9.772 90
   123.847     9.764 91
   124.169    10.056 92
   124.138    10.080 93
   123.735     9.773 94
   123.804     9.800 95
   124.005     9.856 96
   124.162    10.009 97
   124.172     9.891 98
   123.707     9.783 99
   124.003     9.928 100
   124.018     9.858 101
   124.126     9.867 102
   124.154     9.943 103
   124.181     9.994 104
   123.964     9.784 105
   123.651     9.725 106
   123.844     9.902 107
   124.174     9.943 108
   124.080    10.008 109
   124.043     9.849 110
   123.749     9.782 111
   124.138     9.840 112
   123.904     9.815 113
   124.219     9.956 114
   124.186     9.999 115
   124.150    10.006 116
   124.074     9.895 117
   124.157    10.037 118
   124.202     9.945 119
   123.669     9.690 120
   124.023     9.893 121
   124.170    10.043 122
   123.697     9.692 123
   124.173    10.041 124
   124.163    10.058 125
   124.111     9.943 126
   124.146     9.960 127
   123.896     9.838 128
   123.651     9.709 129
   124.269     9.903 130
   124.252     9.905 131
   124.158     9.956 132
   123.698     9.691 133
   124.135     9.894 134
   123.618     9.690 135
   123.664     9.673 136
   123.660     9.687 137
   123.626     9.688 138
   124.067     9.921 139
   123.610     9.675 140
   124.008     9.542 141
   123.918     9.625 142
   123.617     9.756 143
   124.058     9.928 144
   123.691     9.771 145
   124.036     9.931 146
   123.803     9.768 147
   124.355     9.821 148
   124.330     9.846 149
   123.739     9.728 150
   124.289     9.929 151
   123.591     9.747 152
   123.640     9.893 153
   124.131     9.891 154
   123.950     9.820 155
   124.124     9.896 156
   124.019     9.774 157
   123.635     9.688 158
   123.656     9.622 159
   124.080     9.969 160
   123.629     9.645 161
   124.175    10.003 162
   124.076     9.891 163
   124.102    10.072 164
   124.203    10.048 165
   124.186    10.073 166
   123.652     9.644 167
   124.110    10.055 168
   124.244    10.039 169
   124.068     9.907 170
   124.176    10.068 171
   124.004     9.902 172
   124.160    10.025 173
   124.097    10.028 174
   124.160    10.070 175
   124.133     9.958 176
   124.107     9.885 177
   124.167     9.860 178
   124.147    10.041 179
   123.696     9.779 180
   124.053     9.880 181
   124.136     9.918 182
   124.072     9.952 183
   124.156    10.046 184
   124.187    10.047 185
   124.128     9.917 186
   124.139     9.892 187
   123.642     9.725 188
   124.081     9.891 189
   124.142    10.054 190
   123.922     9.788 191
   123.930     9.918 192
   124.058     9.884 193
   124.021     9.920 194
   124.214    10.055 195
   124.023     9.903 196
   124.164    10.046 197
   124.115    10.249 198
   124.243     9.880 199
   123.964     9.811 200
   124.007     9.871 201
   123.676     9.720 202
   123.668     9.769 203
   123.637     9.724 204
   124.177    10.086 205
   124.015     9.884 206
   124.234    10.097 207
   124.212     9.917 208
   124.163     9.815 209
   124.251     9.999 210
   124.029     9.867 211
   124.249     9.942 212
   124.283     9.917 213
   124.102     9.945 214
   124.070     9.937 215
   124.058     9.891 216
   124.136    10.012 217
   124.074     9.910 218
   124.024     9.963 219
   124.040     9.906 220
   124.009     9.897 221
   124.061     9.924 222
   123.599     9.766 223
   123.875     9.842 224
   123.713     9.751 225
   124.194     9.894 226
   124.170    10.022 227
   125.073     9.410 228
   123.916     9.758 229
   123.663     9.154 230
   124.675     9.811 231
   124.078     9.887 232
   124.018     9.910 233
   123.969     9.829 234
   123.666    10.107 235
   124.785    10.113 236
   124.178    10.048 237
   124.473     9.781 238
   124.036     9.892 239
   124.033     9.899 240
   124.023     9.898 241
   124.102     9.924 242
   124.159     9.876 243
   124.987    10.090 244
   124.035     9.866 245
   124.711     9.811 246
   124.954     9.722 247
   124.047     9.282 248
   123.983     9.863 249
   124.083     9.892 250
   124.258     9.151 251
   125.096    10.098 252
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   124.066     9.582
   123.979     9.579
>
   124.914    10.148
   124.878    10.247
>
   123.693     9.219
   123.668     9.328
>
   124.713     9.755
   124.582     9.801
>
   124.849     9.693
   124.581     9.667
>
   124.722     9.735
   124.540     9.761
>
   124.525     9.752
   124.391     9.735
>
   124.896     9.780
   124.741     9.761
>
   125.052     9.776
   124.875     9.882
>
   124.909     9.750
   124.824     9.867
>
   124.973     9.875
   124.841     9.892
>
   124.824     9.873
   124.681     9.808
>
   124.981     9.764
   124.760     9.796
>
   125.157    10.294
   125.078    10.338
>
   125.191    10.227
   125.057    10.316
>
   125.117    10.203
   125.035    10.361
>
   124.980    10.058
   125.077    10.312
>
   125.171    10.292
   125.060    10.331
>
   124.899    10.281
   124.842    10.291
>
   124.903    10.212
   124.857    10.231
>
   123.608    10.216
   123.483    10.160
>
   125.085    10.132
   125.070    10.163
>
   124.252    10.000
   123.982    10.006
>
   125.140    10.271
   125.093    10.342
>
   125.081    10.274
   125.056    10.301
>
   124.916     9.781
   124.882     9.796
>
   125.146     9.404
   125.117     9.561
>
   124.787     9.726
   124.776     9.824
>
   124.828     9.785
   124.825     9.803
>
   124.797     9.762
   124.771     9.843
>
   125.189    10.020
   125.149    10.071
>
   123.559     9.744
   123.571     9.772
>
   124.778     9.894
   124.721     9.874
>
   124.743     9.770
   124.686     9.866
>
   124.849    10.270
   124.784    10.289
>
   124.043     9.980
   124.013    10.006
>
   125.079    10.103
   125.072    10.147
>
   124.786     9.833
   124.720     9.870
>
   124.742     9.796
   124.685     9.854
>
   124.288     9.647
   124.262     9.662
>
   125.083    10.099
   125.066    10.126
>
   125.194     9.680
   125.056     9.641
>
   125.128    10.270
   125.030    10.299
>
   124.268     9.599
   124.250     9.606
>
   124.577     9.740
   124.518     9.786
>
   124.552     9.789
   124.512     9.788
>
   124.711     9.634
   124.697     9.638
>
   125.079     9.908
   125.025     9.928
>
   125.189    10.247
   125.110    10.303
>
   124.556     9.723
   124.514     9.774
>
   124.951     9.392
   125.048     9.443
>
   124.008     9.338
   124.036     9.380
>
   124.088     9.258
   124.004     9.247
>
   124.349     9.455
   124.304     9.430
>
   125.072    10.159
   125.039    10.152
>
   125.198     9.881
   125.255     9.838
>
   124.123     9.833
   124.040     9.908
>
   124.188     9.917
   124.080     9.892
>
   124.192     9.985
   124.090    10.035
>
   124.035     9.903
   124.026     9.949
>
   123.656     9.800
   123.664     9.751
>
   124.004     9.824
   124.158    10.018
>
   123.939     9.824
   123.830     9.835
>
   124.158     9.937
   124.118     9.983
>
   123.993     9.846
   124.007     9.848
>
   124.225     9.752
   124.078     9.813
>
   124.043     9.869
   124.006     9.897
>
   124.128     9.984
   124.120     9.999
>
   124.217    10.009
   124.182    10.065
>
   124.154     9.982
   124.131    10.021
>
   124.216    10.052
   124.146    10.020
>
   124.157     9.953
   124.127     9.943
>
   123.852     9.955
   123.845     9.904
>
   123.918     9.895
   123.892     9.898
>
   124.065     9.967
   124.033     9.971
>
   124.067     9.881
   124.014     9.873
>
   123.691     9.684
   123.663     9.761
>
   124.005     9.842
   124.005     9.850
>
   123.696     9.714
   123.688     9.763
>
   124.015     9.778
   123.950     9.838
>
   124.279     9.983
   124.139     9.989
>
   124.100     9.893
   124.036     9.908
>
   124.054     9.860
   124.019     9.895
>
   124.021     9.953
   124.021     9.944
>
   124.160    10.015
   124.174    10.065
>
   124.137     9.829
   124.025     9.845
>
   123.718     9.612
   123.692     9.691
>
   124.102     9.854
   124.036     9.885
>
   123.852     9.735
   123.923     9.845
>
   123.942     9.791
   123.869     9.772
>
   123.842     9.767
   123.847     9.764
>
   124.189    10.091
   124.169    10.056
>
   124.165    10.070
   124.138    10.080
>
   123.698     9.766
   123.735     9.773
>
   124.025     9.794
   123.804     9.800
>
   124.084     9.794
   124.005     9.856
>
   124.191     9.974
   124.162    10.009
>
   124.317     9.865
   124.172     9.891
>
   123.739     9.749
   123.707     9.783
>
   124.015     9.908
   124.003     9.928
>
   124.067     9.798
   124.018     9.858
>
   124.193     9.910
   124.126     9.867
>
   124.175     9.884
   124.154     9.943
>
   124.154     9.995
   124.181     9.994
>
   123.961     9.755
   123.964     9.784
>
   123.771     9.688
   123.651     9.725
>
   123.834     9.876
   123.844     9.902
>
   124.190     9.990
   124.174     9.943
>
   124.072     9.969
   124.080    10.008
>
   124.120     9.742
   124.043     9.849
>
   123.738     9.774
   123.749     9.782
>
   124.168     9.847
   124.138     9.840
>
   123.925     9.785
   123.904     9.815
>
   124.264     9.983
   124.219     9.956
>
   124.183     9.986
   124.186     9.999
>
   124.166     9.985
   124.150    10.006
>
   124.094     9.862
   124.074     9.895
>
   124.190    10.033
   124.157    10.037
>
   124.180     9.918
   124.202     9.945
>
   123.640     9.662
   123.669     9.690
>
   124.038     9.917
   124.023     9.893
>
   124.249    10.049
   124.170    10.043
>
   123.701     9.667
   123.697     9.692
>
   124.205    10.007
   124.173    10.041
>
   124.146    10.054
   124.163    10.058
>
   124.258     9.796
   124.111     9.943
>
   124.195     9.936
   124.146     9.960
>
   123.919     9.812
   123.896     9.838
>
   123.659     9.692
   123.651     9.709
>
   124.325     9.877
   124.269     9.903
>
   124.288     9.916
   124.252     9.905
>
   124.149     9.950
   124.158     9.956
>
   123.675     9.696
   123.698     9.691
>
   124.163     9.863
   124.135     9.894
>
   123.581     9.693
   123.618     9.690
>
   123.666     9.648
   123.664     9.673
>
   123.633     9.626
   123.660     9.687
>
   123.640     9.658
   123.626     9.688
>
   124.100     9.897
   124.067     9.921
>
   123.638     9.655
   123.610     9.675
>
   124.032     9.531
   124.008     9.542
>
   123.903     9.567
   123.918     9.625
>
   123.596     9.743
   123.617     9.756
>
   124.074     9.935
   124.058     9.928
>
   123.683     9.770
   123.691     9.771
>
   124.059     9.943
   124.036     9.931
>
   123.831     9.730
   123.803     9.768
>
   124.385     9.819
   124.355     9.821
>
   124.348     9.835
   124.330     9.846
>
   123.713     9.700
   123.739     9.728
>
   124.282     9.927
   124.289     9.929
>
   123.689     9.686
   123.591     9.747
>
   123.656     9.873
   123.640     9.893
>
   124.179     9.891
   124.131     9.891
>
   123.985     9.784
   123.950     9.820
>
   124.112     9.897
   124.124     9.896
>
   123.992     9.769
   124.019     9.774
>
   123.660     9.658
   123.635     9.688
>
   123.639     9.628
   123.656     9.622
>
   124.087     9.952
   124.080     9.969
>
   123.654     9.637
   123.629     9.645
>
   124.151    10.015
   124.175    10.003
>
   124.119     9.880
   124.076     9.891
>
   124.113    10.088
   124.102    10.072
>
   124.228    10.039
   124.203    10.048
>
   124.218    10.028
   124.186    10.073
>
   123.718     9.583
   123.652     9.644
>
   124.208    10.071
   124.110    10.055
>
   124.334    10.035
   124.244    10.039
>
   124.123     9.911
   124.068     9.907
>
   124.186    10.073
   124.176    10.068
>
   124.155     9.899
   124.004     9.902
>
   124.161    10.015
   124.160    10.025
>
   124.134    10.063
   124.097    10.028
>
   124.247    10.086
   124.160    10.070
>
   124.129     9.996
   124.133     9.958
>
   124.096     9.867
   124.107     9.885
>
   124.162     9.871
   124.167     9.860
>
   124.190    10.007
   124.147    10.041
>
   123.803     9.786
   123.696     9.779
>
   124.112     9.867
   124.053     9.880
>
   124.161     9.888
   124.136     9.918
>
   124.137     9.965
   124.072     9.952
>
   124.187    10.053
   124.156    10.046
>
   124.284     9.995
   124.187    10.047
>
   124.126     9.904
   124.128     9.917
>
   124.080     9.905
   124.139     9.892
>
   123.763     9.644
   123.642     9.725
>
   124.170     9.845
   124.081     9.891
>
   124.191    10.048
   124.142    10.054
>
   123.986     9.805
   123.922     9.788
>
   123.954     9.892
   123.930     9.918
>
   124.082     9.850
   124.058     9.884
>
   124.026     9.961
   124.021     9.920
>
   124.189    10.009
   124.214    10.055
>
   123.992     9.877
   124.023     9.903
>
   124.190    10.021
   124.164    10.046
>
   124.156    10.238
   124.115    10.249
>
   124.323     9.930
   124.243     9.880
>
   123.966     9.792
   123.964     9.811
>
   123.988     9.893
   124.007     9.871
>
   123.646     9.731
   123.676     9.720
>
   123.650     9.700
   123.668     9.769
>
   123.593     9.659
   123.637     9.724
>
   124.274    10.106
   124.177    10.086
>
   124.064     9.857
   124.015     9.884
>
   124.233    10.078
   124.234    10.097
>
   124.242     9.852
   124.212     9.917
>
   124.235     9.803
   124.163     9.815
>
   124.389     9.924
   124.251     9.999
>
   124.064     9.867
   124.029     9.867
>
   124.265     9.941
   124.249     9.942
>
   124.323     9.908
   124.283     9.917
>
   124.088     9.944
   124.102     9.945
>
   124.200     9.945
   124.070     9.937
>
   124.103     9.802
   124.058     9.891
>
   124.125    10.010
   124.136    10.012
>
   124.051     9.906
   124.074     9.910
>
   123.978    10.003
   124.024     9.963
>
   124.111     9.818
   124.040     9.906
>
   124.104     9.775
   124.009     9.897
>
   124.087     9.980
   124.061     9.924
>
   123.602     9.728
   123.599     9.766
>
   123.940     9.868
   123.875     9.842
>
   123.737     9.719
   123.713     9.751
>
   124.224     9.843
   124.194     9.894
>
   124.201    10.035
   124.170    10.022
>
   125.153     9.358
   125.073     9.410
>
   123.971     9.719
   123.916     9.758
>
   123.760     9.100
   123.663     9.154
>
   124.741     9.875
   124.675     9.811
>
   124.074     9.852
   124.078     9.887
>
   124.009     9.943
   124.018     9.910
>
   124.040     9.810
   123.969     9.829
>
   123.664    10.117
   123.666    10.107
>
   124.794    10.142
   124.785    10.113
>
   124.185     9.976
   124.178    10.048
>
   124.493     9.743
   124.473     9.781
>
   124.032     9.879
   124.036     9.892
>
   124.048     9.884
   124.033     9.899
>
   124.087     9.874
   124.023     9.898
>
   124.094     9.929
   124.102     9.924
>
   124.151     9.850
   124.159     9.876
>
   124.943    10.021
   124.987    10.090
>
   124.045     9.870
   124.035     9.866
>
   124.754     9.748
   124.711     9.811
>
   125.013     9.682
   124.954     9.722
>
   124.188     9.239
   124.047     9.282
>
   123.940     9.873
   123.983     9.863
>
   124.123     9.903
   124.083     9.892
>
   124.245     9.108
   124.258     9.151
>
   125.124    10.052
   125.096    10.098
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   123.977     9.590
   123.979     9.579
>
   124.873    10.247
   124.878    10.247
>
   123.665     9.323
   123.668     9.328
>
   124.581     9.800
   124.582     9.801
>
   124.579     9.674
   124.581     9.667
>
   124.540     9.762
   124.540     9.761
>
   124.390     9.738
   124.391     9.735
>
   124.740     9.759
   124.741     9.761
>
   124.874     9.881
   124.875     9.882
>
   124.819     9.872
   124.824     9.867
>
   124.842     9.894
   124.841     9.892
>
   124.677     9.809
   124.681     9.808
>
   124.772     9.809
   124.760     9.796
>
   125.074    10.333
   125.078    10.338
>
   125.055    10.315
   125.057    10.316
>
   125.029    10.368
   125.035    10.361
>
   125.074    10.318
   125.077    10.312
>
   125.060    10.328
   125.060    10.331
>
   124.842    10.284
   124.842    10.291
>
   124.858    10.227
   124.857    10.231
>
   123.484    10.161
   123.483    10.160
>
   125.069    10.163
   125.070    10.163
>
   123.983    10.004
   123.982    10.006
>
   125.085    10.340
   125.093    10.342
>
   125.055    10.303
   125.056    10.301
>
   124.881     9.795
   124.882     9.796
>
   125.116     9.562
   125.117     9.561
>
   124.776     9.823
   124.776     9.824
>
   124.826     9.802
   124.825     9.803
>
   124.771     9.842
   124.771     9.843
>
   125.149    10.071
   125.149    10.071
>
   123.571     9.772
   123.571     9.772
>
   124.719     9.874
   124.721     9.874
>
   124.686     9.866
   124.686     9.866
>
   124.784    10.291
   124.784    10.289
>
   124.013    10.005
   124.013    10.006
>
   125.070    10.146
   125.072    10.147
>
   124.720     9.869
   124.720     9.870
>
   124.685     9.854
   124.685     9.854
>
   124.261     9.662
   124.262     9.662
>
   125.070    10.129
   125.066    10.126
>
   125.062     9.644
   125.056     9.641
>
   125.032    10.298
   125.030    10.299
>
   124.250     9.605
   124.250     9.606
>
   124.519     9.786
   124.518     9.786
>
   124.512     9.789
   124.512     9.788
>
   124.696     9.638
   124.697     9.638
>
   125.025     9.928
   125.025     9.928
>
   125.110    10.302
   125.110    10.303
>
   124.514     9.774
   124.514     9.774
>
   125.049     9.443
   125.048     9.443
>
   124.034     9.380
   124.036     9.380
>
   124.004     9.247
   124.004     9.247
>
   124.303     9.431
   124.304     9.430
>
   125.039    10.152
   125.039    10.152
>
   125.253     9.833
   125.255     9.838
>
   124.040     9.908
   124.040     9.908
>
   124.079     9.892
   124.080     9.892
>
   124.089    10.036
   124.090    10.035
>
   124.025     9.949
   124.026     9.949
>
   123.664     9.752
   123.664     9.751
>
   124.157    10.017
   124.158    10.018
>
   123.829     9.833
   123.830     9.835
>
   124.118     9.984
   124.118     9.983
>
   124.007     9.848
   124.007     9.848
>
   124.077     9.813
   124.078     9.813
>
   124.006     9.897
   124.006     9.897
>
   124.120     9.999
   124.120     9.999
>
   124.182    10.065
   124.182    10.065
>
   124.131    10.021
   124.131    10.021
>
   124.147    10.020
   124.146    10.020
>
   124.127     9.943
   124.127     9.943
>
   123.843     9.905
   123.845     9.904
>
   123.888     9.893
   123.892     9.898
>
   124.033     9.972
   124.033     9.971
>
   124.014     9.874
   124.014     9.873
>
   123.663     9.761
   123.663     9.761
>
   124.005     9.850
   124.005     9.850
>
   123.688     9.764
   123.688     9.763
>
   123.950     9.838
   123.950     9.838
>
   124.138     9.989
   124.139     9.989
>
   124.037     9.908
   124.036     9.908
>
   124.019     9.895
   124.019     9.895
>
   124.030     9.944
   124.021     9.944
>
   124.172    10.060
   124.174    10.065
>
   124.025     9.844
   124.025     9.845
>
   123.691     9.691
   123.692     9.691
>
   124.036     9.885
   124.036     9.885
>
   123.922     9.846
   123.923     9.845
>
   123.868     9.772
   123.869     9.772
>
   123.847     9.764
   123.847     9.764
>
   124.172    10.063
   124.169    10.056
>
   124.138    10.080
   124.138    10.080
>
   123.735     9.773
   123.735     9.773
>
   123.803     9.800
   123.804     9.800
>
   124.013     9.856
   124.005     9.856
>
   124.162    10.009
   124.162    10.009
>
   124.172     9.890
   124.172     9.891
>
   123.707     9.783
   123.707     9.783
>
   124.003     9.928
   124.003     9.928
>
   124.021     9.853
   124.018     9.858
>
   124.125     9.867
   124.126     9.867
>
   124.154     9.943
   124.154     9.943
>
   124.181     9.994
   124.181     9.994
>
   123.962     9.784
   123.964     9.784
>
   123.654     9.728
   123.651     9.725
>
   123.843     9.903
   123.844     9.902
>
   124.174     9.942
   124.174     9.943
>
   124.080    10.007
   124.080    10.008
>
   124.043     9.849
   124.043     9.849
>
   123.748     9.783
   123.749     9.782
>
   124.138     9.839
   124.138     9.840
>
   123.904     9.815
   123.904     9.815
>
   124.219     9.957
   124.219     9.956
>
   124.186     9.999
   124.186     9.999
>
   124.150    10.005
   124.150    10.006
>
   124.074     9.895
   124.074     9.895
>
   124.157    10.037
   124.157    10.037
>
   124.202     9.944
   124.202     9.945
>
   123.669     9.691
   123.669     9.690
>
   124.022     9.893
   124.023     9.893
>
   124.170    10.043
   124.170    10.043
>
   123.696     9.693
   123.697     9.692
>
   124.173    10.041
   124.173    10.041
>
   124.163    10.057
   124.163    10.058
>
   124.111     9.942
   124.111     9.943
>
   124.146     9.960
   124.146     9.960
>
   123.895     9.838
   123.896     9.838
>
   123.650     9.708
   123.651     9.709
>
   124.268     9.904
   124.269     9.903
>
   124.252     9.905
   124.252     9.905
>
   124.157     9.957
   124.158     9.956
>
   123.698     9.691
   123.698     9.691
>
   124.135     9.893
   124.135     9.894
>
   123.619     9.689
   123.618     9.690
>
   123.664     9.674
   123.664     9.673
>
   123.660     9.687
   123.660     9.687
>
   123.626     9.688
   123.626     9.688
>
   124.068     9.920
   124.067     9.921
>
   123.610     9.675
   123.610     9.675
>
   124.008     9.543
   124.008     9.542
>
   123.917     9.624
   123.918     9.625
>
   123.617     9.756
   123.617     9.756
>
   124.059     9.928
   124.058     9.928
>
   123.691     9.771
   123.691     9.771
>
   124.039     9.931
   124.036     9.931
>
   123.803     9.768
   123.803     9.768
>
   124.355     9.821
   124.355     9.821
>
   124.330     9.846
   124.330     9.846
>
   123.739     9.728
   123.739     9.728
>
   124.289     9.929
   124.289     9.929
>
   123.592     9.747
   123.591     9.747
>
   123.640     9.893
   123.640     9.893
>
   124.128     9.893
   124.131     9.891
>
   123.950     9.819
   123.950     9.820
>
   124.123     9.896
   124.124     9.896
>
   124.019     9.773
   124.019     9.774
>
   123.637     9.687
   123.635     9.688
>
   123.656     9.622
   123.656     9.622
>
   124.080     9.969
   124.080     9.969
>
   123.629     9.645
   123.629     9.645
>
   124.175    10.002
   124.175    10.003
>
   124.077     9.892
   124.076     9.891
>
   124.102    10.072
   124.102    10.072
>
   124.202    10.048
   124.203    10.048
>
   124.187    10.073
   124.186    10.073
>
   123.653     9.645
   123.652     9.644
>
   124.110    10.055
   124.110    10.055
>
   124.244    10.039
   124.244    10.039
>
   124.069     9.907
   124.068     9.907
>
   124.178    10.070
   124.176    10.068
>
   124.004     9.902
   124.004     9.902
>
   124.160    10.025
   124.160    10.025
>
   124.097    10.028
   124.097    10.028
>
   124.162    10.071
   124.160    10.070
>
   124.134     9.958
   124.133     9.958
>
   124.107     9.885
   124.107     9.885
>
   124.167     9.861
   124.167     9.860
>
   124.146    10.041
   124.147    10.041
>
   123.696     9.779
   123.696     9.779
>
   124.052     9.881
   124.053     9.880
>
   124.138     9.918
   124.136     9.918
>
   124.072     9.951
   124.072     9.952
>
   124.157    10.044
   124.156    10.046
>
   124.186    10.047
   124.187    10.047
>
   124.128     9.916
   124.128     9.917
>
   124.138     9.892
   124.139     9.892
>
   123.643     9.726
   123.642     9.725
>
   124.082     9.892
   124.081     9.891
>
   124.143    10.055
   124.142    10.054
>
   123.922     9.788
   123.922     9.788
>
   123.929     9.918
   123.930     9.918
>
   124.057     9.884
   124.058     9.884
>
   124.020     9.917
   124.021     9.920
>
   124.214    10.056
   124.214    10.055
>
   124.023     9.904
   124.023     9.903
>
   124.164    10.046
   124.164    10.046
>
   124.115    10.250
   124.115    10.249
>
   124.242     9.881
   124.243     9.880
>
   123.963     9.811
   123.964     9.811
>
   124.011     9.869
   124.007     9.871
>
   123.676     9.720
   123.676     9.720
>
   123.669     9.768
   123.668     9.769
>
   123.638     9.725
   123.637     9.724
>
   124.177    10.085
   124.177    10.086
>
   124.014     9.884
   124.015     9.884
>
   124.234    10.097
   124.234    10.097
>
   124.211     9.917
   124.212     9.917
>
   124.163     9.814
   124.163     9.815
>
   124.252    10.000
   124.251     9.999
>
   124.029     9.868
   124.029     9.867
>
   124.250     9.943
   124.249     9.942
>
   124.284     9.917
   124.283     9.917
>
   124.102     9.945
   124.102     9.945
>
   124.069     9.937
   124.070     9.937
>
   124.058     9.891
   124.058     9.891
>
   124.136    10.012
   124.136    10.012
>
   124.073     9.910
   124.074     9.910
>
   124.023     9.963
   124.024     9.963
>
   124.039     9.906
   124.040     9.906
>
   124.010     9.898
   124.009     9.897
>
   124.061     9.924
   124.061     9.924
>
   123.598     9.769
   123.599     9.766
>
   123.875     9.842
   123.875     9.842
>
   123.715     9.751
   123.713     9.751
>
   124.194     9.894
   124.194     9.894
>
   124.170    10.022
   124.170    10.022
>
   125.072     9.409
   125.073     9.410
>
   123.916     9.758
   123.916     9.758
>
   123.663     9.154
   123.663     9.154
>
   124.675     9.811
   124.675     9.811
>
   124.078     9.887
   124.078     9.887
>
   124.018     9.910
   124.018     9.910
>
   123.969     9.830
   123.969     9.829
>
   123.668    10.105
   123.666    10.107
>
   124.781    10.108
   124.785    10.113
>
   124.179    10.049
   124.178    10.048
>
   124.475     9.776
   124.473     9.781
>
   124.037     9.894
   124.036     9.892
>
   124.034     9.899
   124.033     9.899
>
   124.024     9.898
   124.023     9.898
>
   124.102     9.924
   124.102     9.924
>
   124.159     9.877
   124.159     9.876
>
   124.986    10.089
   124.987    10.090
>
   124.035     9.866
   124.035     9.866
>
   124.711     9.814
   124.711     9.811
>
   124.956     9.722
   124.954     9.722
>
   124.047     9.282
   124.047     9.282
>
   123.983     9.863
   123.983     9.863
>
   124.083     9.892
   124.083     9.892
>
   124.259     9.154
   124.258     9.151
>
   125.095    10.097
   125.096    10.098
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   123.979     9.579   -33.099     4.280     8.861
   124.878    10.247   -34.861     3.873     5.436
   123.668     9.328   -21.127     4.374     8.193
   124.582     9.801   -37.812     2.282     3.790
   124.581     9.667    -9.149     4.877     6.737
   124.540     9.761   -37.109     1.896     3.195
   124.391     9.735    -9.819     4.707     5.482
   124.741     9.761   -31.516     4.960     7.355
   124.875     9.882   -43.149     4.909     7.743
   124.824     9.867   -78.902     5.861     8.991
   124.841     9.892   -43.260     8.081    11.438
   124.681     9.808   -36.962     6.916     8.789
   124.760     9.796    64.997     9.712    11.093
   125.078    10.338   -29.982     4.489     6.540
   125.057    10.316   -76.134     4.938     5.886
   125.035    10.361   -78.454     3.131     5.643
   125.077    10.312   -86.054     3.584     9.360
   125.060    10.331   -47.580     4.580     5.471
   124.842    10.291   -76.877     5.124     7.096
   124.857    10.231   -75.233     3.037     5.125
   123.483    10.160    82.321     3.235     5.356
   125.070    10.163   -85.271     3.075     4.295
   123.982    10.006   -38.585     4.160     5.873
   125.093    10.342   -32.963     5.229     8.346
   125.056    10.301   -60.890     5.462     6.679
   124.882     9.796   -40.639     4.137     6.864
   125.117     9.561   -32.130     4.745     5.826
   124.776     9.824     4.448     2.245     4.027
   124.825     9.803    -0.218     2.759     5.755
   124.771     9.843   -52.073     5.205     7.136
   125.149    10.071    -7.819     3.714     5.367
   123.571     9.772    23.018     3.390     5.118
   124.721     9.874     2.269     3.205     6.862
   124.686     9.866    -9.163     3.666     4.055
   124.784    10.289   -12.722     4.597     6.991
   124.013    10.006   -19.934     2.202     2.479
   125.072    10.147     1.099     2.574     5.229
   124.720     9.870     2.004     1.916     3.224
   124.685     9.854     3.596     3.344     3.695
   124.262     9.662   -41.302     2.708     3.678
   125.066    10.126   -23.110     5.042     5.345
   125.056     9.641    61.764     2.218     7.344
   125.030    10.299   -34.914     4.442     7.140
   124.250     9.606    61.114     3.983     4.198
   124.518     9.786   -29.239     2.998     3.666
   124.512     9.788    51.028     5.017     6.422
   124.697     9.638   -18.644     3.620     4.673
   125.025     9.928   -18.126     5.701     7.208
   125.110    10.303   -44.840     9.371    11.347
   124.514     9.774    -7.393     4.222     4.435
   125.048     9.443    -9.487     4.015     6.593
   124.036     9.380     0.506     2.638     4.950
   124.004     9.247     8.911     2.579     3.261
   124.304     9.430    -6.998     3.674     4.328
   125.039    10.152    -6.062     4.578     7.058
   125.255     9.838   -33.672     4.440     6.802
   124.040     9.908   -24.075     1.438     2.048
   124.080     9.892    53.830     4.889     7.972
   124.090    10.035   -56.029     6.136     8.805
   124.026     9.949    17.900     5.237    10.813
   123.664     9.751    80.386     5.778     6.627
   124.158    10.018   -39.286     6.391    12.659
   123.830     9.835   -26.698     4.690     5.432
   124.118     9.983   -38.806     2.262     2.909
   124.007     9.848     3.103     2.409     3.323
   124.078     9.813    61.039     4.537     7.030
   124.006     9.897   -28.746     2.044     3.008
   124.120     9.999    26.724     3.936     4.498
   124.182    10.065   -78.198     7.563    10.072
   124.131    10.021   -33.036     2.657     4.373
   124.146    10.020   -47.921     4.432     6.615
   124.127     9.943   -34.347     2.119     2.947
   123.845     9.904    10.137     4.164     6.467
   123.892     9.898    10.612     3.132     4.494
   124.033     9.971     4.705     3.461     6.579
   124.014     9.873     0.132     2.408     3.139
   123.663     9.761    82.752     3.316     3.629
   124.005     9.850    10.678     4.344     5.827
   123.688     9.763   -19.868     1.576     1.938
   123.950     9.838   -11.598     2.497     3.186
   124.139     9.989     5.681     4.276     8.378
   124.036     9.908   -20.348     2.745     3.595
   124.019     9.895   -22.130     2.158     2.855
   124.021     9.944     7.703     3.298     3.927
   124.174    10.065   -47.821     4.168     5.677
   124.025     9.845   -37.470     6.134     7.845
   123.692     9.691    12.052     4.746     6.704
   124.036     9.885   -30.257     2.255     2.947
   123.923     9.845   -34.996     3.852     4.416
   123.869     9.772   -21.808     3.770     4.410
   123.847     9.764    17.922     2.241     3.863
   124.169    10.056   -59.075     3.033     4.718
   124.138    10.080   -41.714     2.759     3.707
   123.735     9.773    22.186     4.622     9.300
   123.804     9.800    18.511     6.130    10.335
   124.005     9.856    -7.603     3.669     7.983
   124.162    10.009   -42.919     7.011     8.885
   124.172     9.891   -25.753     2.155     3.299
   123.707     9.783   -14.343     1.199     1.452
   124.003     9.928   -26.987     1.477     1.587
   124.018     9.858   -11.741     2.507     3.648
   124.126     9.867    -8.706     5.500     9.642
   124.154     9.943   -11.973     2.389     3.280
   124.181     9.994   -20.240     3.140     3.865
   123.964     9.784    10.756     2.990     5.283
   123.651     9.725    18.015     3.913     5.302
   123.844     9.902     6.013     4.064     5.206
   124.174     9.943   -51.842     3.491     4.103
   124.080    10.008   -57.799     3.801     4.371
   124.043     9.849     3.255     2.921     4.173
   123.749     9.782    -6.973     2.383     3.053
   124.138     9.840    -4.449     3.946     4.731
   123.904     9.815    15.838     3.835     4.376
   124.219     9.956   -46.843     3.299     4.116
   124.186     9.999   -87.977     2.332     2.522
   124.150    10.006    -2.274     3.113     3.751
   124.074     9.895    -6.728     2.550     2.994
   124.157    10.037   -26.278     2.633     3.123
   124.202     9.945   -89.939     2.594     2.847
   123.669     9.690    59.256     3.483     3.795
   124.023     9.893    24.862     2.527     2.976
   124.170    10.043   -35.101     3.066     3.749
   123.697     9.692    12.889     2.362     3.716
   124.173    10.041    -9.382     2.689     3.258
   124.163    10.058   -36.881     2.783     4.191
   124.111     9.943    21.684     3.182     3.797
   124.146     9.960    57.949     3.456     3.573
   123.896     9.838     6.362     2.835     3.743
   123.651     9.709    18.124     2.326     2.636
   124.269     9.903   -30.189     2.489     3.036
   124.252     9.905    28.664     3.791     4.158
   124.158     9.956   -32.369     1.820     2.103
   123.698     9.691    17.916     3.067     3.482
   124.135     9.894     7.776     2.407     2.911
   123.618     9.690    32.952     4.422     7.653
   123.664     9.673    35.472     2.710     3.280
   123.660     9.687    34.908     2.628     2.857
   123.626     9.688    55.126     2.354     2.615
   124.067     9.921    -3.180     2.224     2.867
   123.610     9.675   -25.574     1.771     1.839
   124.008     9.542     2.897     3.603     4.566
   123.918     9.625   -25.141     3.104     4.169
   123.617     9.756    33.685     2.777     3.559
   124.058     9.928   -29.651     1.615     2.245
   123.691     9.771    86.426     2.781     2.988
   124.036     9.931   -17.346     2.871     3.858
   123.803     9.768    -7.478     1.647     2.184
   124.355     9.821   -45.933     3.321     3.754
   124.330     9.846   -23.029     4.214     4.277
   123.739     9.728   -40.031     3.202     5.469
   124.289     9.929   -35.345     3.124     3.588
   123.591     9.747   -39.477     4.049     6.414
   123.640     9.893   -57.782     5.053     6.772
   124.131     9.891     3.357     2.465     2.770
   123.950     9.820     3.740     2.593     3.585
   124.124     9.896    29.987     3.177     3.989
   124.019     9.774    27.188     3.462     4.693
   123.635     9.688     8.261     5.061     7.104
   123.656     9.622    13.907     3.161     3.590
   124.080     9.969     5.812     3.071     3.688
   123.629     9.645     5.550     2.646     3.650
   124.175    10.003    45.596     3.371     4.168
   124.076     9.891    -3.827     2.994     3.995
   124.102    10.072    -3.305     4.171     8.058
   124.203    10.048    -5.053     3.360     5.275
   124.186    10.073   -12.970     2.061     3.231
   123.652     9.644    40.006     2.486     2.747
   124.110    10.055   -16.033     1.943     3.013
   124.244    10.039   -24.828     2.329     3.285
   124.068     9.907   -15.145     2.237     3.294
   124.176    10.068    -4.561     3.190     4.299
   124.004     9.902   -38.964     2.018     3.496
   124.160    10.025   -43.614     2.579     3.658
   124.097    10.028   -23.035     3.282     6.663
   124.160    10.070   -32.182     2.558     5.283
   124.133     9.958   -29.232     4.012     4.672
   124.107     9.885    -9.779     4.038     6.044
   124.167     9.860    -3.933     4.213     6.917
   124.147    10.041   -22.192     1.574     2.457
   123.696     9.779    12.660     3.210     6.444
   124.053     9.880    -2.673     3.275     7.542
   124.136     9.918   -12.888     3.810     6.144
   124.072     9.952   -17.373     2.945     5.044
   124.156    10.046   -33.252     2.546     5.726
   124.187    10.047   -29.293     2.988     6.329
   124.128     9.917   -18.449     3.042     5.326
   124.139     9.892   -18.386     4.547    10.813
   123.642     9.725    -0.228     2.959     4.484
   124.081     9.891   -20.019     1.718     2.780
   124.142    10.054   -23.226     3.743     7.000
   123.922     9.788     4.507     3.803     6.837
   123.930     9.918    -3.191     3.565     7.272
   124.058     9.884   -66.397     2.508     3.079
   124.021     9.920   -32.604     1.789     2.890
   124.214    10.055   -61.384     2.875     3.939
   124.023     9.903   -17.763     2.280     2.961
   124.164    10.046   -46.059     2.090     3.432
   124.115    10.249   -64.911     3.202     4.708
   124.243     9.880   -19.454     4.161     7.395
   123.964     9.811   -13.605     3.114     3.990
   124.007     9.871   -10.478     2.112     2.632
   123.676     9.720     2.165     3.236     5.255
   123.668     9.769    42.211     4.048     5.227
   123.637     9.724   -50.427     5.116     5.701
   124.177    10.086   -39.820     3.805     8.431
   124.015     9.884   -35.610     2.660     3.429
   124.234    10.097   -46.096     2.537     3.007
   124.212     9.917   -45.004     3.602     4.203
   124.163     9.815    32.659     2.862     3.493
   124.251     9.999   -36.298     3.697     4.764
   124.029     9.867   -31.522     2.196     2.626
   124.249     9.942   -71.208     2.356     3.462
   124.283     9.917   -40.360     2.693     4.075
   124.102     9.945   -40.502     2.657     3.551
   124.070     9.937    -9.937     2.779     3.227
   124.058     9.891    -3.115     2.387     2.932
   124.136    10.012   -46.165     3.297     5.101
   124.074     9.910    10.999     2.661     2.974
   124.024     9.963   -54.782     4.840     5.385
   124.040     9.906   -10.242     2.950     3.341
   124.009     9.897   -10.887     2.886     3.387
   124.061     9.924   -15.779     3.900     3.941
   123.599     9.766    38.975     5.105     5.352
   123.875     9.842    32.237     3.697     3.806
   123.713     9.751   -46.443     2.912     3.283
   124.194     9.894   -35.110     3.070     4.137
   124.170    10.022   -32.948     2.163     2.750
   125.073     9.410   -21.389     2.921     4.362
   123.916     9.758    10.035     3.863     4.835
   123.663     9.154    -2.010     2.914     4.826
   124.675     9.811   -48.226     4.017     6.388
   124.078     9.887    36.188     2.577     2.866
   124.018     9.910   -60.944     2.543     2.678
   123.969     9.829    36.504     1.530     2.001
   123.666    10.107   -88.731     2.136     3.968
   124.785    10.113   -79.818     3.103     5.585
   124.178    10.048    70.322     2.089     3.937
   124.473     9.781   -28.325     1.415     2.107
   124.036     9.892    39.403     1.450     2.072
   124.033     9.899    15.080     1.791     2.925
   124.023     9.898    25.343     2.388     2.645
   124.102     9.924    16.413     1.293     1.933
   124.159     9.876    50.899     2.124     3.429
   124.987    10.090   -47.041     2.502     3.753
   124.035     9.866    45.659     1.719     2.795
   124.711     9.811   -70.570     3.622     4.336
   124.954     9.722   -25.072     1.910     2.665
   124.047     9.282   -48.399     3.405     6.042
   123.983     9.863     7.559     1.486     1.739
   124.083     9.892   -15.007     1.518     1.850
   124.258     9.151     6.137     1.952     2.107
   125.096    10.098   -48.332     1.869     2.735
EOF

# User-defined stars
gmt plot $proj $reg -Sa -Wthicker,red -Gred << EOF
   124.582     9.801     0.200
   124.540     9.761     0.200
   124.040     9.908     0.300
EOF


# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   123.438     9.105    68.676     1.262     1.483
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   123.460     9.105   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   123.438     9.105     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   123.438     9.105     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   123.438     9.060   5 km
EOF
gmt end
