#!/bin/bash
gmt begin bandung1.79_xsec_1 pdf,ps
proj=-JX18.0/-4.1
reg=-R-122.0/143.2/0/61.0
gmt basemap $proj $reg -Bxa10f10+l'Distance (km)' -Bya10f10+l'Depth (km)' -BWesN+t'Cross-section bandung1.79'
# Event    1 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -96.802    45.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -96.802    42.000
   -96.802    48.000
EOF
# Event    2 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -10.917    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -10.917    12.000
   -10.917    18.000
EOF
# Event    3 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -100.035    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -100.035    37.000
  -100.035    43.000
EOF
# Event    4 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -101.536    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -101.536    33.000
  -101.536    39.000
EOF
# Event    5 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -94.084    48.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -94.084    45.000
   -94.084    51.000
EOF
# Event    6 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     7.526     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     7.526     0.000
     7.526     7.000
EOF
# Event    7 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -117.008    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -117.008    36.000
  -117.008    44.000
EOF
# Event    8 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -74.156    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -74.156    21.000
   -74.156    29.000
EOF
# Event    9 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -110.761    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -110.761    30.000
  -110.761    36.000
EOF
# Event   10 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.722     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.722     2.000
    -2.722    10.000
EOF
# Event   11 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    30.549    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    30.549    13.000
    30.549    21.000
EOF
# Event   12 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    46.090    21.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    46.090    18.000
    46.090    24.000
EOF
# Event   13 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.622    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.622    10.000
    64.622    16.000
EOF
# Event   14 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.783    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.783    12.000
     0.783    18.000
EOF
# Event   15 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.223    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.223    12.000
    18.223    18.000
EOF
# Event   16 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -98.831    33.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -98.831    30.000
   -98.831    36.000
EOF
# Event   17 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.743    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.743    10.000
    65.743    16.000
EOF
# Event   18 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.503    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.503    12.000
    51.503    18.000
EOF
# Event   19 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    68.269    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    68.269    12.000
    68.269    18.000
EOF
# Event   20 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -14.750    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -14.750    11.000
   -14.750    17.000
EOF
# Event   21 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    56.958    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    56.958    12.000
    56.958    18.000
EOF
# Event   22 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     2.123    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     2.123     7.000
     2.123    15.000
EOF
# Event   23 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.918    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.918     8.000
    -4.918    14.000
EOF
# Event   24 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    35.890    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    35.890    11.000
    35.890    17.000
EOF
# Event   25 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.617    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.617     7.000
     3.617    13.000
EOF
# Event   26 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -9.322    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -9.322     6.000
    -9.322    14.000
EOF
# Event   27 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -40.777    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -40.777    16.000
   -40.777    22.000
EOF
# Event   28 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -39.510    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -39.510    13.000
   -39.510    19.000
EOF
# Event   29 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.027     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.027     6.000
    -5.027    12.000
EOF
# Event   30 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     0.743     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.743     5.000
     0.743    13.000
EOF
# Event   31 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -1.254     5.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -1.254     2.000
    -1.254     8.000
EOF
# Event   32 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -99.201    41.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -99.201    38.000
   -99.201    44.000
EOF
# Event   33 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -105.747    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -105.747    15.000
  -105.747    23.000
EOF
# Event   34 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -41.022    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -41.022    11.000
   -41.022    19.000
EOF
# Event   35 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -32.914    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -32.914    14.000
   -32.914    20.000
EOF
# Event   36 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.428     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.428     2.000
   -97.428    10.000
EOF
# Event   37 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.511    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.511    13.000
     1.511    19.000
EOF
# Event   38 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -0.145    20.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -0.145    17.000
    -0.145    23.000
EOF
# Event   39 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    31.155    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    31.155    11.000
    31.155    17.000
EOF
# Event   40 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    32.578    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    32.578     8.000
    32.578    14.000
EOF
# Event   41 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    33.643    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    33.643     9.000
    33.643    15.000
EOF
# Event   42 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.376     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.376     0.000
    -3.376     7.000
EOF
# Event   43 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.468    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.468    12.000
    12.468    18.000
EOF
# Event   44 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.320    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.320    13.000
    12.320    19.000
EOF
# Event   45 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.893    15.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.893    12.000
    13.893    18.000
EOF
# Event   46 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.024    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.024    11.000
    11.024    17.000
EOF
# Event   47 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.321    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.321    10.000
    11.321    16.000
EOF
# Event   48 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -97.152    35.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -97.152    32.000
   -97.152    38.000
EOF
# Event   49 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.591    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.591     7.000
    11.591    13.000
EOF
# Event   50 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.134    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.134     8.000
    15.134    14.000
EOF
# Event   51 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.929    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.929     8.000
    11.929    14.000
EOF
# Event   52 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.522     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.522     6.000
    10.522    12.000
EOF
# Event   53 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.928     6.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.928     2.000
    10.928    10.000
EOF
# Event   54 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.120     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.120     6.000
    -2.120    12.000
EOF
# Event   55 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.346    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.346     9.000
    12.346    15.000
EOF
# Event   56 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    10.985    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    10.985    11.000
    10.985    17.000
EOF
# Event   57 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.307    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.307     9.000
    11.307    15.000
EOF
# Event   58 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.138    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.138     8.000
    11.138    14.000
EOF
# Event   59 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.514    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.514     9.000
    17.514    15.000
EOF
# Event   60 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.500     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.500     6.000
    17.500    12.000
EOF
# Event   61 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    12.489    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    12.489     7.000
    12.489    13.000
EOF
# Event   62 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    15.287    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    15.287    10.000
    15.287    16.000
EOF
# Event   63 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.067    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.067     8.000
    14.067    14.000
EOF
# Event   64 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.007    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.007    15.000
    17.007    21.000
EOF
# Event   65 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -7.819    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -7.819    14.000
    -7.819    20.000
EOF
# Event   66 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    13.633    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    13.633    10.000
    13.633    16.000
EOF
# Event   67 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    68.273    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    68.273    14.000
    68.273    20.000
EOF
# Event   68 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    17.800    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    17.800    15.000
    17.800    21.000
EOF
# Event   69 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    37.931    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    37.931    11.000
    37.931    17.000
EOF
# Event   70 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.154    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.154     8.000
    14.154    14.000
EOF
# Event   71 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     1.868     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     1.868     0.000
     1.868     6.000
EOF
# Event   72 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    34.799    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    34.799    11.000
    34.799    17.000
EOF
# Event   73 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -4.959     2.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -4.959     0.000
    -4.959     6.000
EOF
# Event   74 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   138.164    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   138.164    10.000
   138.164    18.000
EOF
# Event   75 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   121.933    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   121.933    10.000
   121.933    18.000
EOF
# Event   76 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.739    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.739    11.000
    11.739    17.000
EOF
# Event   77 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.347    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.347     7.000
   -49.347    15.000
EOF
# Event   78 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.037     3.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.037     0.000
    14.037     7.000
EOF
# Event   79 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    73.958    25.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    73.958    22.000
    73.958    28.000
EOF
# Event   80 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -49.292    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -49.292    12.000
   -49.292    20.000
EOF
# Event   81 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -73.881    56.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -73.881    53.000
   -73.881    59.000
EOF
# Event   82 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -103.910    36.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -103.910    33.000
  -103.910    39.000
EOF
# Event   83 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    11.956    11.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    11.956     8.000
    11.956    14.000
EOF
# Event   84 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -18.141    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -18.141     9.000
   -18.141    15.000
EOF
# Event   85 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -16.085    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -16.085    10.000
   -16.085    16.000
EOF
# Event   86 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -20.007     8.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -20.007     4.000
   -20.007    12.000
EOF
# Event   87 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -2.321    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -2.321    19.000
    -2.321    25.000
EOF
# Event   88 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -5.016    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -5.016    10.000
    -5.016    16.000
EOF
# Event   89 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    14.224    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    14.224    13.000
    14.224    19.000
EOF
# Event   90 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     4.282    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     4.282    11.000
     4.282    17.000
EOF
# Event   91 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
     3.881    10.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     3.881     6.000
     3.881    14.000
EOF
# Event   92 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    66.386    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    66.386    11.000
    66.386    17.000
EOF
# Event   93 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    68.932    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    68.932     9.000
    68.932    15.000
EOF
# Event   94 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    66.961    18.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    66.961    15.000
    66.961    21.000
EOF
# Event   95 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    65.416    16.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    65.416    13.000
    65.416    19.000
EOF
# Event   96 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    64.861    17.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    64.861    14.000
    64.861    20.000
EOF
# Event   97 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    51.876    13.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    51.876    10.000
    51.876    16.000
EOF
# Event   98 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.106     9.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.106     6.000
    53.106    12.000
EOF
# Event   99 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    50.639    12.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    50.639     8.000
    50.639    16.000
EOF
# Event  100 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    53.581    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    53.581    11.000
    53.581    17.000
EOF
# Event  101 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    -3.341    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    -3.341    11.000
    -3.341    17.000
EOF
# Event  102 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    18.236    19.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    18.236    16.000
    18.236    22.000
EOF
# Event  103 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -89.138    49.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -89.138    46.000
   -89.138    52.000
EOF
# Event  104 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
    24.777    22.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
    24.777    19.000
    24.777    25.000
EOF
# Event  105 fixed depth, contraint code l
gmt plot $proj $reg  -Sc -Wthick,black << EOF
  -105.327    40.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
  -105.327    36.000
  -105.327    44.000
EOF
# Event  106 fixed depth, contraint code n
gmt plot $proj $reg  -Sc -Wthick,black << EOF
   -29.693    14.000     0.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
   -29.693    11.000
   -29.693    17.000
EOF

# Event numbers
gmt text $proj $reg -F+f8p,Helvetica,black+a0.+jBL << EOF
   -96.602    45.000 1
   -10.717    15.000 2
   -99.835    40.000 3
  -101.336    36.000 4
   -93.884    48.000 5
     7.726     3.000 6
  -116.808    40.000 7
   -73.956    25.000 8
  -110.561    33.000 9
    -2.522     6.000 10
    30.749    17.000 11
    46.290    21.000 12
    64.822    13.000 13
     0.983    15.000 14
    18.423    15.000 15
   -98.631    33.000 16
    65.943    13.000 17
    51.703    15.000 18
    68.469    15.000 19
   -14.550    14.000 20
    57.158    15.000 21
     2.323    11.000 22
    -4.718    11.000 23
    36.090    14.000 24
     3.817    10.000 25
    -9.122    10.000 26
   -40.577    19.000 27
   -39.310    16.000 28
    -4.827     9.000 29
     0.943     9.000 30
    -1.054     5.000 31
   -99.001    41.000 32
  -105.547    19.000 33
   -40.822    15.000 34
   -32.714    17.000 35
   -97.228     6.000 36
     1.711    16.000 37
     0.055    20.000 38
    31.355    14.000 39
    32.778    11.000 40
    33.843    12.000 41
    -3.176     3.000 42
    12.668    15.000 43
    12.520    16.000 44
    14.093    15.000 45
    11.224    14.000 46
    11.521    13.000 47
   -96.952    35.000 48
    11.791    10.000 49
    15.334    11.000 50
    12.129    11.000 51
    10.722     9.000 52
    11.128     6.000 53
    -1.920     9.000 54
    12.546    12.000 55
    11.185    14.000 56
    11.507    12.000 57
    11.338    11.000 58
    17.714    12.000 59
    17.700     9.000 60
    12.689    10.000 61
    15.487    13.000 62
    14.267    11.000 63
    17.207    18.000 64
    -7.619    17.000 65
    13.833    13.000 66
    68.473    17.000 67
    18.000    18.000 68
    38.131    14.000 69
    14.354    11.000 70
     2.068     2.000 71
    34.999    14.000 72
    -4.759     2.000 73
   138.364    14.000 74
   122.133    14.000 75
    11.939    14.000 76
   -49.147    11.000 77
    14.237     3.000 78
    74.158    25.000 79
   -49.092    16.000 80
   -73.681    56.000 81
  -103.710    36.000 82
    12.156    11.000 83
   -17.941    12.000 84
   -15.885    13.000 85
   -19.807     8.000 86
    -2.121    22.000 87
    -4.816    13.000 88
    14.424    16.000 89
     4.482    14.000 90
     4.081    10.000 91
    66.586    14.000 92
    69.132    12.000 93
    67.161    18.000 94
    65.616    16.000 95
    65.061    17.000 96
    52.076    13.000 97
    53.306     9.000 98
    50.839    12.000 99
    53.781    14.000 100
    -3.141    14.000 101
    18.436    19.000 102
   -88.938    49.000 103
    24.977    22.000 104
  -105.127    40.000 105
   -29.493    14.000 106
EOF

# Azimuth of the projection plane
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
   143.064     0.100 Azimuth =   26
EOF
gmt end
