#!/bin/bash
gmt begin bandung1.79_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases bandung1.79'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     1.658
     1.500    -1.852
     2.000    -5.361
     2.500    -8.871
     3.000   -12.380
     3.500   -15.894
     4.000   -19.410
     4.500   -22.928
     5.000   -26.449
     5.500   -29.976
     6.000   -33.505
     6.500   -37.039
     7.000   -40.578
     7.500   -44.121
     8.000   -47.672
     8.500   -51.227
     9.000   -54.790
     9.500   -58.359
    10.000   -61.936
    10.500   -65.520
    11.000   -69.112
    11.500   -72.713
    12.000   -76.323
    12.500   -79.943
    13.000   -83.573
    13.500   -87.212
    14.000   -90.862
    14.500   -94.523
    15.000   -98.197
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -80.573 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     1.442
     1.000     0.561
     1.500    -0.894
     2.000    -2.349
     2.500    -3.806
     3.000    -5.263
     3.500    -6.721
     4.000    -8.182
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -11.182 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.095     5.899     0.200
     2.932    -0.612     0.200
     3.620    -1.903     0.200
     2.550     3.443     0.200
     2.608     2.948     0.200
     3.138    -2.659     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.229    -0.225     0.200
     0.732    -0.619     0.200
     1.302    -2.598     0.200
     1.760    -3.453     0.200
     1.859    -8.367     0.200
     2.369   -10.721     0.200
     4.564   -27.401     0.200
     0.643     0.425     0.200
     1.029    -1.429     0.200
     1.267    -1.500     0.200
     1.267    -0.875     0.200
     1.736    -5.737     0.200
     2.005    -6.472     0.200
     2.166    -9.870     0.200
     2.358   -10.236     0.200
     3.457   -18.175     0.200
     3.527   -17.996     0.200
     3.492   -20.984     0.200
     0.576     1.998     0.200
     1.201    -1.060     0.200
     1.415    -6.789     0.200
     1.960    -5.361     0.200
     3.467   -22.135     0.200
     3.488   -17.485     0.200
     4.737   -30.695     0.200
     5.346   -35.852     0.200
     1.415    -2.704     0.200
     3.649   -23.001     0.200
     7.251   -47.281     0.200
    18.042  -123.857     0.200
     2.507    -7.014     0.200
     3.880   -17.148     0.200
     4.012   -18.309     0.200
     3.504   -21.400     0.200
     1.038     2.369     0.200
     1.042     1.221     0.200
     1.018     2.693     0.200
     1.074     1.333     0.200
     1.224     1.983     0.200
     1.210     1.177     0.200
     1.899    -3.259     0.200
     2.126    -4.467     0.200
     2.842    -8.567     0.200
     0.618     0.948     0.200
     0.747     0.461     0.200
     1.247    -0.159     0.200
     1.063     0.023     0.200
     1.088     0.225     0.200
     1.154     0.258     0.200
     1.454    -5.181     0.200
     1.505    -3.981     0.200
     1.644    -4.290     0.200
     2.769   -13.558     0.200
     3.496   -18.892     0.200
     0.991     1.417     0.200
     1.092     1.023     0.200
     1.115     0.198     0.200
     1.133     0.920     0.200
     1.170    -0.045     0.200
     1.254    -0.007     0.200
     1.590    -2.476     0.200
     2.315    -6.856     0.200
     2.390    -6.836     0.200
     2.419    -7.055     0.200
     2.487    -7.015     0.200
     3.084   -11.913     0.200
     3.691   -15.655     0.200
     1.230     1.813     0.200
     3.201   -13.156     0.200
     3.124    -9.538     0.200
     1.199     0.212     0.200
     0.798     1.727     0.200
     0.936     1.268     0.200
     1.031     1.153     0.200
     1.190     0.426     0.200
     1.200    -0.516     0.200
     0.874     2.306     0.200
     0.989     1.645     0.200
     0.870     2.735     0.200
    11.301   -64.156     0.200
     1.178     0.782     0.200
     1.154     1.780     0.200
     1.318    -3.234     0.200
     1.608    -4.823     0.200
     1.608    -5.337     0.200
     1.164     2.461     0.200
     1.165     2.402     0.200
     1.386     0.310     0.200
     2.956    -7.256     0.200
     1.155     1.909     0.200
     1.156     2.826     0.200
     1.190     0.333     0.200
     1.176     0.345     0.200
     0.681     3.203     0.200
     0.862     3.677     0.200
     0.971     2.723     0.200
     0.978     1.589     0.200
     1.147     1.745     0.200
     1.138     1.875     0.200
     1.242     0.274     0.200
     1.254    -0.095     0.200
     1.948    -5.243     0.200
     2.236    -8.107     0.200
     1.413    -2.229     0.200
     0.851     2.904     0.200
     1.020     2.653     0.200
     1.076     1.591     0.200
     1.250     2.371     0.200
     1.172     0.762     0.200
     1.058     2.774     0.200
     1.154     2.631     0.200
     1.187     3.175     0.200
     3.592   -16.036     0.200
     4.295   -18.130     0.200
     0.880     2.604     0.200
     0.998     1.579     0.200
     1.099     1.564     0.200
     1.182     3.940     0.200
     1.175     1.853     0.200
     1.496     0.185     0.200
     2.855    -7.513     0.200
     0.732     1.949     0.200
     1.001     3.015     0.200
     1.042     1.899     0.200
     1.186     1.554     0.200
     1.156     1.207     0.200
     1.212     1.217     0.200
     1.240     0.629     0.200
     1.062     1.534     0.200
     1.114     1.577     0.200
     1.292     0.131     0.200
     1.290     1.092     0.200
     1.023     1.524     0.200
     1.169     0.584     0.200
     1.062     1.975     0.200
     1.163     1.177     0.200
     0.678     1.943     0.200
     0.706     1.855     0.200
     0.749     1.692     0.200
     0.859     1.397     0.200
     0.861     0.736     0.200
     1.225     0.719     0.200
     1.226     0.908     0.200
     0.500     3.337     0.200
     0.509     3.844     0.200
     0.735     2.675     0.200
     0.790     1.149     0.200
     0.865     1.058     0.200
     0.867     0.692     0.200
     0.875     0.535     0.200
     0.952    -0.187     0.200
     0.959     0.188     0.200
     0.986     0.036     0.200
     1.030     0.019     0.200
     1.064    -1.263     0.200
     1.096    -1.179     0.200
     1.139    -1.920     0.200
     1.162    -2.452     0.200
     1.318    -2.910     0.200
     1.319    -2.624     0.200
     1.344    -2.719     0.200
     1.533    -4.118     0.200
     1.705    -6.171     0.200
     1.705    -6.165     0.200
     1.880    -7.102     0.200
     2.049    -7.478     0.200
     2.362   -11.185     0.200
     2.799   -13.245     0.200
     3.219   -18.060     0.200
     3.286   -18.286     0.200
     4.442   -24.240     0.200
     0.667     0.158     0.200
     0.815    -2.481     0.200
     0.815    -2.311     0.200
     0.794     0.531     0.200
     0.955    -1.772     0.200
     0.927    -0.785     0.200
     1.026    -0.396     0.200
     1.089    -2.805     0.200
     1.075    -1.473     0.200
     1.139    -2.180     0.200
     1.288    -2.662     0.200
     1.348    -4.409     0.200
     1.428    -2.856     0.200
     1.487    -3.612     0.200
     1.630    -5.256     0.200
     1.630    -5.571     0.200
     1.711    -4.423     0.200
     2.165   -10.006     0.200
     2.363    -9.408     0.200
     3.108   -15.707     0.200
     3.102   -14.012     0.200
     3.529   -18.043     0.200
     1.657    -3.519     0.200
     0.960     2.112     0.200
     0.960     2.002     0.200
     0.919     2.192     0.200
     1.040     1.051     0.200
     1.143     1.663     0.200
     1.730    -1.927     0.200
     2.913    -8.938     0.200
     2.946    -8.990     0.200
     3.001   -10.220     0.200
     3.057    -9.710     0.200
     3.292   -11.446     0.200
     3.690   -14.276     0.200
     0.905     0.801     0.200
     0.906     0.985     0.200
     0.928     1.699     0.200
     1.159     0.594     0.200
     1.225    -0.198     0.200
     1.283    -0.644     0.200
     1.296     0.050     0.200
     1.184     0.580     0.200
     3.483   -14.703     0.200
     0.743     3.997     0.200
     1.133     0.480     0.200
     1.223     1.034     0.200
     0.931     2.249     0.200
     1.166     1.505     0.200
     1.231    -0.963     0.200
     0.750     2.314     0.200
     0.853     1.744     0.200
     0.863     2.128     0.200
     0.998     1.433     0.200
     1.010     0.660     0.200
     1.049     3.042     0.200
     1.122     1.008     0.200
     1.233     0.408     0.200
     1.218     1.174     0.200
     1.198     0.227     0.200
     1.189     1.617     0.200
     1.211     1.236     0.200
     1.198     0.622     0.200
     1.257     0.275     0.200
     1.315    -0.177     0.200
     0.916     1.948     0.200
     1.076     0.983     0.200
     1.134     0.534     0.200
     1.117     1.117     0.200
     0.780     2.457     0.200
     0.872     2.823     0.200
     1.128     1.921     0.200
     1.161     1.282     0.200
     1.167     1.887     0.200
     1.190     0.182     0.200
     1.219     0.777     0.200
     2.861   -10.069     0.200
     2.918    -9.649     0.200
     2.919   -10.149     0.200
     3.508   -14.480     0.200
     3.515   -13.936     0.200
     0.512     3.947     0.200
     0.518     2.245     0.200
     0.678     1.815     0.200
     0.768     1.936     0.200
     0.779    -0.152     0.200
     0.856    -0.165     0.200
     0.918     0.998     0.200
     0.907    -0.884     0.200
     1.181    -0.886     0.200
     1.161    -0.009     0.200
     1.299    -1.749     0.200
     1.301    -2.651     0.200
     1.382    -2.822     0.200
     1.333    -2.938     0.200
     1.467    -2.284     0.200
     1.592    -5.508     0.200
     1.413    -3.614     0.200
     1.754    -3.280     0.200
     1.569    -5.323     0.200
     1.733    -4.926     0.200
     1.599    -7.771     0.200
     1.825    -4.576     0.200
     1.724    -5.769     0.200
     1.847    -5.175     0.200
     2.222    -6.641     0.200
     2.600    -8.976     0.200
     2.314   -10.078     0.200
     2.440    -9.704     0.200
     2.921   -16.810     0.200
     2.921   -15.294     0.200
     3.641   -20.312     0.200
     5.113   -32.417     0.200
     0.991     1.480     0.200
     1.145    -0.382     0.200
     1.143    -4.064     0.200
     5.281   -28.165     0.200
     3.464   -12.242     0.200
     5.281   -23.804     0.200
     6.645   -41.978     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.892     1.792     0.200
     1.437     0.705     0.200
     0.417     1.192     0.200
     0.417     1.042     0.200
     0.693     1.452     0.200
     0.881     1.191     0.200
     1.055     0.082     0.200
     0.464     1.493     0.200
     0.561     2.466     0.200
     0.622     1.936     0.200
     0.746     1.714     0.200
     1.364    -0.093     0.200
     1.678    -0.636     0.200
     1.851    -3.022     0.200
     0.180     2.607     0.200
     0.211     2.370     0.200
     0.432     1.272     0.200
     0.768     1.206     0.200
     0.987     0.775     0.200
     0.485     1.331     0.200
     0.602     2.219     0.200
     0.634     1.906     0.200
     0.943     2.187     0.200
     1.044    -0.613     0.200
     1.310     1.770     0.200
     1.425     1.227     0.200
     1.998    -1.950     0.200
     2.393    -2.680     0.200
     0.149     2.944     0.200
     0.296     1.868     0.200
     0.630     2.384     0.200
     0.733     1.015     0.200
     0.767     1.552     0.200
     0.752     2.510     0.200
     0.772     2.103     0.200
     0.905     1.981     0.200
     1.312    -0.016     0.200
     1.481    -1.591     0.200
     0.157     1.898     0.200
     0.184     1.426     0.200
     0.267     0.682     0.200
     0.282     0.308     0.200
     0.391     1.256     0.200
     0.437     1.510     0.200
     0.506     0.209     0.200
     0.527     1.950     0.200
     0.536     0.555     0.200
     0.642     2.107     0.200
     0.685     1.639     0.200
     0.702     1.097     0.200
     0.712     0.682     0.200
     0.735     1.159     0.200
     0.028     2.708     0.200
     0.227     1.649     0.200
     0.257     0.100     0.200
     0.414     2.244     0.200
     0.414     1.119     0.200
     0.447     0.158     0.200
     0.085     3.099     0.200
     0.217     0.895     0.200
     0.270     1.861     0.200
     0.634     2.479     0.200
     0.646     2.412     0.200
     0.857     2.024     0.200
     0.920     1.005     0.200
     1.017     1.032     0.200
     1.369    -0.022     0.200
     1.361     1.749     0.200
     1.496    -0.250     0.200
     0.057     2.184     0.200
     0.140     1.453     0.200
     0.178     1.055     0.200
     0.238     1.152     0.200
     0.332     1.173     0.200
     0.373     1.669     0.200
     0.503     1.662     0.200
     0.604     1.653     0.200
     0.667     0.859     0.200
     0.744     0.899     0.200
     0.223    -0.001     0.200
     0.189     2.477     0.200
     0.503     1.322     0.200
     0.627     1.996     0.200
     1.003    -0.231     0.200
     1.036     1.112     0.200
     0.245     2.610     0.200
     0.342     1.245     0.200
     0.427     1.142     0.200
     0.491     1.228     0.200
     0.550     0.142     0.200
     0.640     0.998     0.200
     0.655     1.035     0.200
     0.682     1.256     0.200
     0.721     1.619     0.200
     0.766     1.405     0.200
     0.793     0.457     0.200
     0.862     1.469     0.200
     0.323     1.925     0.200
     0.494     1.208     0.200
     0.545     0.383     0.200
     0.667     1.334     0.200
     0.689     1.034     0.200
     0.867     1.996     0.200
     0.108     1.418     0.200
     0.271     0.636     0.200
     0.331     1.048     0.200
     0.408    -0.281     0.200
     0.656     0.546     0.200
     0.207     2.876     0.200
     0.294     0.516     0.200
     0.445     1.028     0.200
     0.485     0.363     0.200
     0.482     2.559     0.200
     0.538     0.790     0.200
     0.583     0.761     0.200
     0.598     1.982     0.200
     0.648     1.695     0.200
     0.786     1.132     0.200
     0.834     0.804     0.200
     0.818     1.791     0.200
     0.858     1.722     0.200
     0.899     1.451     0.200
     0.893     0.417     0.200
     1.184     0.386     0.200
     1.481    -0.422     0.200
     1.502    -0.274     0.200
     1.912    -2.691     0.200
     0.187     1.003     0.200
     0.319     1.130     0.200
     0.472     0.507     0.200
     0.468     1.690     0.200
     0.511     1.436     0.200
     0.561     2.151     0.200
     0.611     1.872     0.200
     0.634     1.220     0.200
     0.667    -0.025     0.200
     0.814     1.243     0.200
     0.804     1.134     0.200
     0.856     1.907     0.200
     1.041     1.043     0.200
     1.197     0.076     0.200
     1.484     0.592     0.200
     0.682    -0.202     0.200
     0.800     1.176     0.200
     0.938    -0.026     0.200
     0.970    -0.522     0.200
     1.036     0.184     0.200
     1.105    -1.589     0.200
     1.856    -3.121     0.200
     0.371     1.970     0.200
     0.550     1.096     0.200
     0.597     0.102     0.200
     0.582     0.899     0.200
     0.665     0.971     0.200
     0.665     1.154     0.200
     0.974     0.554     0.200
     1.362    -0.530     0.200
     1.382     0.922     0.200
     1.371    -0.121     0.200
     1.471    -0.701     0.200
     1.499    -1.173     0.200
     1.607    -1.813     0.200
     1.634    -0.558     0.200
     1.759    -1.512     0.200
     0.229     1.978     0.200
     0.510     1.265     0.200
     0.635     0.598     0.200
     0.643     1.175     0.200
     0.662     1.568     0.200
     0.780     1.513     0.200
     0.830     0.336     0.200
     0.899     0.345     0.200
     0.964     0.645     0.200
     0.945     2.050     0.200
     0.937     2.799     0.200
     1.068     0.441     0.200
     1.053     0.824     0.200
     1.088     1.627     0.200
     1.455     0.388     0.200
     1.507     0.524     0.200
     1.508     0.610     0.200
     1.739     0.062     0.200
     1.887    -1.508     0.200
     0.213     1.989     0.200
     0.445     1.734     0.200
     0.471     2.693     0.200
     0.491     1.167     0.200
     0.808     1.119     0.200
     0.886     0.049     0.200
     1.195    -0.557     0.200
     0.198     1.867     0.200
     0.305     1.154     0.200
     0.497     1.382     0.200
     0.475     3.282     0.200
     0.586     0.873     0.200
     0.605     0.754     0.200
     0.614     0.977     0.200
     0.629     1.289     0.200
     0.967     0.382     0.200
     0.098     2.884     0.200
     0.262     2.125     0.200
     0.646     1.623     0.200
     0.650     2.783     0.200
     0.613     2.173     0.200
     0.565     2.791     0.200
     0.931     0.988     0.200
     1.467     0.690     0.200
     0.094     2.937     0.200
     0.249    -0.178     0.200
     0.323     2.074     0.200
     0.577     2.506     0.200
     0.640     1.808     0.200
     0.658     2.555     0.200
     0.650     2.789     0.200
     0.824     1.781     0.200
     0.926     0.756     0.200
     0.996     1.427     0.200
     1.659    -0.196     0.200
     0.093     3.519     0.200
     0.237     0.934     0.200
     0.479     1.146     0.200
     0.493     0.918     0.200
     0.661     1.579     0.200
     0.794     1.381     0.200
     0.168     1.874     0.200
     0.264     0.751     0.200
     0.395     1.605     0.200
     0.455     1.384     0.200
     0.447     1.959     0.200
     0.459     1.477     0.200
     0.603     1.012     0.200
     0.748     0.709     0.200
     0.192     1.273     0.200
     0.345     2.345     0.200
     0.369     1.778     0.200
     0.425     2.011     0.200
     0.460     1.383     0.200
     0.473     1.695     0.200
     0.197     0.973     0.200
     0.360     2.111     0.200
     0.383     1.867     0.200
     0.427     1.687     0.200
     0.445     1.119     0.200
     0.481     0.774     0.200
     0.649     0.666     0.200
     0.630     1.357     0.200
     0.748     0.718     0.200
     0.847     0.590     0.200
     1.032     0.812     0.200
     1.396    -1.313     0.200
     1.656     0.035     0.200
     0.170     2.071     0.200
     0.215     1.948     0.200
     0.282     0.612     0.200
     0.374     1.597     0.200
     0.377     2.886     0.200
     0.446     1.501     0.200
     0.452     1.409     0.200
     0.532     1.778     0.200
     0.621     1.777     0.200
     0.729     0.928     0.200
     1.040     0.889     0.200
     1.401    -0.154     0.200
     1.639    -0.903     0.200
     0.122     1.841     0.200
     0.141     1.237     0.200
     0.210     1.335     0.200
     0.285     1.377     0.200
     0.373     1.868     0.200
     0.442     1.483     0.200
     0.456     1.238     0.200
     0.463     1.036     0.200
     0.540     1.489     0.200
     0.829     0.927     0.200
     0.600     1.902     0.200
     0.740     1.185     0.200
     0.860     0.668     0.200
     0.888     0.293     0.200
     0.934    -0.072     0.200
     0.959     0.830     0.200
     0.992    -0.022     0.200
     1.028    -0.261     0.200
     1.025    -0.849     0.200
     1.097    -1.034     0.200
     1.229    -0.041     0.200
     1.360    -0.488     0.200
     1.421    -0.920     0.200
     1.503    -2.796     0.200
     1.643    -2.643     0.200
     0.120     1.364     0.200
     0.180     0.959     0.200
     0.204     0.472     0.200
     0.290     1.068     0.200
     0.436     1.423     0.200
     0.461     1.428     0.200
     0.462     1.496     0.200
     0.463     1.096     0.200
     0.731     1.295     0.200
     0.146     1.892     0.200
     0.183     2.636     0.200
     0.212     0.812     0.200
     0.300     1.218     0.200
     0.367     0.100     0.200
     0.386    -0.116     0.200
     0.416     1.243     0.200
     0.480     0.920     0.200
     0.164     1.206     0.200
     0.469     0.660     0.200
     0.477     0.904     0.200
     0.113     1.387     0.200
     0.174     0.646     0.200
     0.292     1.289     0.200
     0.438     1.553     0.200
     0.454     1.670     0.200
     0.721     1.380     0.200
     1.390     0.281     0.200
     1.648    -0.485     0.200
     0.111     1.330     0.200
     0.335     2.122     0.200
     0.363     2.055     0.200
     0.297     1.027     0.200
     0.432     1.643     0.200
     0.460     1.475     0.200
     0.471     0.928     0.200
     0.662     0.858     0.200
     0.697     0.650     0.200
     0.722     1.240     0.200
     1.537     2.325     0.200
     1.654     0.123     0.200
     1.795     0.659     0.200
     3.165    -3.088     0.200
     0.070     1.482     0.200
     0.150     0.559     0.200
     0.283     1.339     0.200
     0.282     0.756     0.200
     0.650     0.813     0.200
     1.575    -1.007     0.200
     0.119     1.504     0.200
     0.149     1.441     0.200
     0.191     2.140     0.200
     0.194     1.220     0.200
     0.370     1.939     0.200
     0.426     1.857     0.200
     0.459     2.015     0.200
     0.694     0.694     0.200
     1.387     0.097     0.200
     0.141     1.553     0.200
     0.171     1.793     0.200
     0.284     1.224     0.200
     0.445     1.607     0.200
     0.465     1.388     0.200
     0.622     1.690     0.200
     0.710     0.395     0.200
     1.399    -0.646     0.200
     1.640    -0.588     0.200
     0.143     0.742     0.200
     0.175     1.606     0.200
     0.287     0.974     0.200
     0.441     1.594     0.200
     0.464     1.368     0.200
     0.706     0.472     0.200
     1.396    -0.704     0.200
     1.644    -0.466     0.200
     0.111     1.688     0.200
     0.154     0.998     0.200
     0.429     1.486     0.200
     0.463     1.620     0.200
     0.470     1.405     0.200
     1.384     0.412     0.200
     1.656     0.185     0.200
     0.174     1.289     0.200
     0.147     0.962     0.200
     0.231     1.109     0.200
     0.159     1.092     0.200
     0.134     0.868     0.200
     0.187     0.194     0.200
     0.223     0.571     0.200
     0.291     0.492     0.200
     0.352     1.774     0.200
     0.389     0.086     0.200
     0.408    -0.096     0.200
     0.420     1.518     0.200
     0.416     1.645     0.200
     0.475     1.062     0.200
     0.509     1.079     0.200
     1.620    -1.034     0.200
     0.207     1.574     0.200
     0.291     1.111     0.200
     0.424     1.765     0.200
     0.433     1.679     0.200
     0.471     1.701     0.200
     0.642     0.873     0.200
     0.760     1.044     0.200
     1.399     0.460     0.200
     0.137     1.638     0.200
     0.195     1.498     0.200
     0.135     1.798     0.200
     0.199     0.483     0.200
     0.527     1.208     0.200
     0.285     2.466     0.200
     0.285     2.656     0.200
     0.469     1.452     0.200
     0.599     2.230     0.200
     0.592     2.153     0.200
     0.646     2.032     0.200
     1.269     0.263     0.200
     1.338     0.484     0.200
     1.379    -0.124     0.200
     1.463    -0.260     0.200
     1.710    -1.293     0.200
     0.240     0.779     0.200
     0.243     1.505     0.200
     0.266     1.256     0.200
     0.320     1.353     0.200
     0.350     2.105     0.200
     0.410     2.406     0.200
     0.556     1.678     0.200
     0.567     2.440     0.200
     0.579     1.856     0.200
     0.629     1.656     0.200
     0.654     0.574     0.200
     1.490    -1.938     0.200
     1.495    -0.898     0.200
     0.120     1.770     0.200
     0.146     1.162     0.200
     0.181     1.348     0.200
     0.397     2.483     0.200
     0.450     1.721     0.200
     0.608     1.517     0.200
     0.755     0.655     0.200
     0.206     3.023     0.200
     0.242     3.168     0.200
     0.404     2.147     0.200
     0.404     2.161     0.200
     0.453     2.200     0.200
     0.700     1.958     0.200
     0.126     2.260     0.200
     0.165     2.325     0.200
     0.195     1.784     0.200
     0.283     2.377     0.200
     0.395     2.148     0.200
     0.410     3.063     0.200
     0.427     2.018     0.200
     0.508     1.662     0.200
     0.576     1.712     0.200
     0.703     0.981     0.200
     0.783     1.039     0.200
     1.117    -0.741     0.200
     0.088     3.713     0.200
     0.198     1.931     0.200
     0.183     1.698     0.200
     0.209     3.081     0.200
     0.258     2.107     0.200
     0.277     2.109     0.200
     0.277     2.234     0.200
     0.382     2.284     0.200
     0.444     2.310     0.200
     0.628     2.092     0.200
     0.627     1.014     0.200
     0.647     1.100     0.200
     0.757     1.007     0.200
     0.791     1.510     0.200
     0.846     1.783     0.200
     0.893     0.972     0.200
     0.914     0.709     0.200
     0.898     1.033     0.200
     1.029     1.079     0.200
     1.328     0.107     0.200
     1.511    -0.900     0.200
     1.659    -2.184     0.200
     2.369    -4.306     0.200
     0.181     1.168     0.200
     0.152     1.381     0.200
     0.208     1.816     0.200
     0.357     2.696     0.200
     0.414     1.681     0.200
     0.304     1.161     0.200
     0.543     0.789     0.200
     0.448     1.097     0.200
     0.490     1.176     0.200
     0.637     1.023     0.200
     0.684     0.628     0.200
     0.745     1.582     0.200
     0.642     1.836     0.200
     0.769     0.933     0.200
     0.740     1.945     0.200
     1.020     1.583     0.200
     1.384     0.438     0.200
     1.534     1.291     0.200
     1.669     0.196     0.200
     2.319    -2.094     0.200
     3.696    -4.147     0.200
     0.186     0.115     0.200
     0.269     0.805     0.200
     0.357     0.318     0.200
     0.369     1.741     0.200
     0.477     1.496     0.200
     0.508     0.014     0.200
     0.611     0.159     0.200
     0.606     1.531     0.200
     0.686     0.188     0.200
     0.152     2.097     0.200
     0.191     3.065     0.200
     0.224     0.807     0.200
     0.294     1.594     0.200
     0.336     1.962     0.200
     0.399     1.651     0.200
     0.397     1.317     0.200
     0.610     2.177     0.200
     0.616     1.884     0.200
     0.600     0.871     0.200
     0.749     1.856     0.200
     0.795     1.715     0.200
     0.896     0.604     0.200
     1.515     0.976     0.200
     1.636    -1.741     0.200
     1.981    -0.797     0.200
     0.495     0.718     0.200
     0.517    -0.098     0.200
     0.487     1.966     0.200
     0.591    -1.243     0.200
     0.635     2.057     0.200
     0.832     0.115     0.200
     0.821     1.962     0.200
     0.822     2.352     0.200
     0.852     1.987     0.200
     0.982     1.581     0.200
     1.215     1.587     0.200
     1.549     0.589     0.200
     1.795    -0.300     0.200
     0.616     1.226     0.200
     0.633     0.774     0.200
     0.659     1.745     0.200
     0.920     1.283     0.200
     1.406     0.163     0.200
     1.483    -0.372     0.200
     1.556     0.815     0.200
     1.607    -1.483     0.200
     1.627    -1.041     0.200
     1.732     0.040     0.200
     1.813    -1.322     0.200
     1.885    -1.716     0.200
     1.895    -1.421     0.200
     2.122    -2.131     0.200
     2.087    -3.324     0.200
     0.665     2.518     0.200
     0.983     2.243     0.200
     1.047     0.493     0.200
     1.066     1.287     0.200
     1.555    -1.212     0.200
     1.693    -0.282     0.200
     1.766    -0.890     0.200
     1.887    -1.839     0.200
     0.114     1.830     0.200
     0.195     1.865     0.200
     0.188     1.583     0.200
     0.340     2.556     0.200
     0.365     2.654     0.200
     0.403     1.558     0.200
     0.427     1.516     0.200
     0.299     1.147     0.200
     0.530     1.327     0.200
     0.468     0.906     0.200
     0.465     1.101     0.200
     0.472     1.963     0.200
     0.655     1.284     0.200
     0.693     0.682     0.200
     0.728     0.764     0.200
     0.638     1.109     0.200
     0.786     0.815     0.200
     0.845     0.831     0.200
     0.845     0.460     0.200
     0.941     1.416     0.200
     1.385    -0.350     0.200
     1.542     0.842     0.200
     1.658    -0.433     0.200
     1.912    -0.977     0.200
     0.241     1.596     0.200
     0.424     1.709     0.200
     0.504     1.252     0.200
     0.518     1.420     0.200
     0.610     1.124     0.200
     0.633     1.077     0.200
     0.672     1.448     0.200
     0.683     0.598     0.200
     0.692     1.518     0.200
     0.729     0.730     0.200
     0.847     0.704     0.200
     0.875     1.200     0.200
     1.235    -0.715     0.200
     0.196    -0.012     0.200
     0.346     1.036     0.200
     0.324     1.308     0.200
     0.399     2.026     0.200
     0.444     1.316     0.200
     0.515    -0.031     0.200
     0.566     0.742     0.200
     0.673     0.346     0.200
     0.686     0.958     0.200
     0.689     0.150     0.200
     0.872     1.456     0.200
     0.074     4.891     0.200
     0.079     4.542     0.200
     0.239     3.349     0.200
     0.265     3.736     0.200
     0.471     2.902     0.200
     0.505     2.215     0.200
     0.617     2.076     0.200
     1.051     0.116     0.200
     1.114    -0.372     0.200
     1.131     0.090     0.200
     0.319     2.443     0.200
     0.350     2.951     0.200
     0.578     1.438     0.200
     0.638     1.023     0.200
     0.651     2.117     0.200
     0.721     0.896     0.200
     0.765     1.320     0.200
     0.822     0.188     0.200
     1.144    -0.603     0.200
     1.621    -2.025     0.200
     0.116     1.214     0.200
     0.188     1.751     0.200
     0.196     1.501     0.200
     0.297     2.279     0.200
     0.343     2.243     0.200
     0.368     1.439     0.200
     0.406     0.949     0.200
     0.385     2.317     0.200
     0.428     1.447     0.200
     0.469     1.354     0.200
     0.471     1.681     0.200
     0.463     1.845     0.200
     0.636     1.740     0.200
     0.655     1.140     0.200
     0.694     0.299     0.200
     0.730     0.653     0.200
     0.844     0.559     0.200
     0.117     2.719     0.200
     0.305     0.672     0.200
     0.437     0.976     0.200
     0.493     0.315     0.200
     0.555     0.638     0.200
     0.553     2.091     0.200
     0.773     0.731     0.200
     0.823     1.162     0.200
     0.926     1.883     0.200
     0.963     0.497     0.200
     1.036     0.088     0.200
     1.088     0.857     0.200
     0.131     2.061     0.200
     0.286     0.736     0.200
     0.349     0.642     0.200
     0.436     0.701     0.200
     0.475     0.540     0.200
     0.543     1.287     0.200
     0.627     1.847     0.200
     0.816     1.140     0.200
     0.958     1.230     0.200
     0.959     1.122     0.200
     0.971     0.140     0.200
     1.037     0.047     0.200
     0.307     0.478     0.200
     0.383     0.649     0.200
     0.416     1.597     0.200
     0.491     0.337     0.200
     0.543     1.071     0.200
     0.564     1.330     0.200
     0.628     0.399     0.200
     0.653     1.807     0.200
     0.761     1.182     0.200
     0.805     0.682     0.200
     0.817     0.799     0.200
     0.909     1.977     0.200
     0.982     0.956     0.200
     0.983     1.048     0.200
     1.034     0.927     0.200
     1.014     0.850     0.200
     1.070     1.184     0.200
     1.393     0.133     0.200
     1.639     0.337     0.200
     1.938    -0.724     0.200
     0.183     1.986     0.200
     0.284     1.598     0.200
     0.457     2.012     0.200
     0.478     1.750     0.200
     0.507     2.318     0.200
     0.552     2.089     0.200
     0.560     0.247     0.200
     0.602     1.522     0.200
     0.615     0.908     0.200
     0.674     1.750     0.200
     0.792     0.289     0.200
     0.844     0.558     0.200
     1.236    -0.690     0.200
     0.106     2.360     0.200
     0.271     1.450     0.200
     0.333     1.374     0.200
     0.346     1.168     0.200
     0.340     1.738     0.200
     0.407     1.017     0.200
     0.563     1.272     0.200
     0.583     1.156     0.200
     0.650    -0.379     0.200
     0.744     0.544     0.200
     0.925     0.796     0.200
     1.011     0.780     0.200
     2.187    -3.500     0.200
     0.150     1.746     0.200
     0.184     1.783     0.200
     0.217     2.245     0.200
     0.373     1.979     0.200
     0.350     3.022     0.200
     0.402     1.468     0.200
     0.440     0.680     0.200
     0.450     2.149     0.200
     0.433     1.975     0.200
     0.445     1.795     0.200
     0.471     1.569     0.200
     0.509     1.876     0.200
     0.532     1.845     0.200
     0.568     1.526     0.200
     0.570     1.438     0.200
     0.606     2.219     0.200
     0.721     0.664     0.200
     0.760     1.221     0.200
     0.825     0.951     0.200
     1.420    -0.382     0.200
     0.193     1.048     0.200
     0.243     1.653     0.200
     0.261     1.979     0.200
     0.403     2.503     0.200
     0.499     2.628     0.200
     0.574     0.776     0.200
     0.593     1.853     0.200
     0.927     0.284     0.200
     0.215     1.093     0.200
     0.234     2.408     0.200
     0.296     0.756     0.200
     0.483     0.615     0.200
     0.512     1.084     0.200
     0.468     1.895     0.200
     0.570     0.968     0.200
     0.600     1.105     0.200
     0.627     1.550     0.200
     1.203     0.382     0.200
     0.269     3.155     0.200
     0.368     1.432     0.200
     0.536     2.108     0.200
     0.195     2.836     0.200
     0.277     0.540     0.200
     0.404     0.827     0.200
     0.763     1.035     0.200
     1.256    -0.372     0.200
     1.556    -0.513     0.200
     0.272     2.860     0.200
     0.541     2.628     0.200
     0.744     1.593     0.200
     0.717     2.153     0.200
     1.581    -2.444     0.200
     1.768    -3.387     0.200
     2.076    -4.135     0.200
     0.268     0.634     0.200
     0.380     1.377     0.200
     0.530     2.229     0.200
     0.704     2.113     0.200
     1.210    -0.845     0.200
     1.347     0.120     0.200
     1.601     0.086     0.200
     1.783    -0.987     0.200
     0.046     4.012     0.200
     0.411     2.641     0.200
     0.601     1.623     0.200
     0.613     1.466     0.200
     0.599     1.588     0.200
     0.595     2.808     0.200
     0.628     1.561     0.200
     0.680     2.324     0.200
     0.839     0.681     0.200
     0.844     1.520     0.200
     0.871     1.084     0.200
     1.343    -0.996     0.200
     1.351     0.061     0.200
     1.398     0.152     0.200
     1.638    -1.534     0.200
     0.142     1.597     0.200
     0.167     1.095     0.200
     0.296     1.595     0.200
     0.357     1.891     0.200
     0.362     0.729     0.200
     0.444     1.932     0.200
     0.515     1.781     0.200
     0.502     0.574     0.200
     0.532     1.334     0.200
     0.570     2.130     0.200
     0.599     0.418     0.200
     0.662     2.304     0.200
     0.687     2.412     0.200
     0.698     0.860     0.200
     0.786     2.081     0.200
     0.796     2.672     0.200
     0.909     1.276     0.200
     0.996     1.328     0.200
     1.133     0.366     0.200
     1.471    -0.343     0.200
     0.136     1.415     0.200
     0.146     2.002     0.200
     0.362     1.238     0.200
     0.436     0.093     0.200
     0.474     1.282     0.200
     0.525     0.888     0.200
     0.554     1.172     0.200
     0.579     0.472     0.200
     0.674     1.254     0.200
     0.807     1.848     0.200
     0.908     2.237     0.200
     0.310     1.701     0.200
     0.291     1.400     0.200
     0.359     1.017     0.200
     0.359     1.919     0.200
     0.495     0.821     0.200
     0.519     1.942     0.200
     0.570     1.239     0.200
     0.607     0.558     0.200
     0.651     1.378     0.200
     0.700     2.206     0.200
     0.776     1.512     0.200
     0.958     1.548     0.200
     1.000     1.217     0.200
     1.046     1.159     0.200
     1.497    -0.747     0.200
     1.473    -0.174     0.200
     1.759    -2.542     0.200
     1.788    -1.958     0.200
     0.129     1.079     0.200
     0.303     2.507     0.200
     0.305     2.904     0.200
     0.354     2.075     0.200
     0.516     1.634     0.200
     0.508     2.468     0.200
     0.586     1.490     0.200
     0.570     2.323     0.200
     0.689     2.747     0.200
     0.695     0.643     0.200
     0.678     2.298     0.200
     0.797     1.224     0.200
     0.800     1.825     0.200
     0.800     1.624     0.200
     0.954     1.334     0.200
     0.195     2.181     0.200
     0.433     0.785     0.200
     0.438     1.640     0.200
     0.503     0.750     0.200
     0.642     1.560     0.200
     0.725     1.274     0.200
     0.957     0.568     0.200
     1.106     0.260     0.200
     1.394    -0.791     0.200
     0.144     2.517     0.200
     0.160     2.697     0.200
     0.177     2.426     0.200
     0.234     2.744     0.200
     0.301     1.759     0.200
     0.356     3.505     0.200
     0.392     2.162     0.200
     0.409     1.982     0.200
     0.407     2.555     0.200
     0.414     2.535     0.200
     0.486     2.140     0.200
     0.520     1.253     0.200
     0.527     1.015     0.200
     0.565     2.114     0.200
     0.571     1.844     0.200
     0.637     1.539     0.200
     0.719     1.754     0.200
     0.753     0.620     0.200
     1.374     0.754     0.200
     1.397    -1.055     0.200
     1.516    -0.756     0.200
     1.543    -0.547     0.200
     1.624    -1.348     0.200
     1.673    -1.295     0.200
     1.782    -1.801     0.200
     3.387    -6.265     0.200
     0.254     2.839     0.200
     0.508     0.766     0.200
     0.524     0.599     0.200
     0.650     0.946     0.200
     0.654     1.172     0.200
     1.169     0.447     0.200
     1.749    -2.268     0.200
     0.131     1.396     0.200
EOF
gmt end
