#!/bin/bash
gmt begin bandung1.79_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional bandung1.79'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    42.096
    14.500    41.818
    15.000    41.539
    15.500    41.258
    16.000    40.973
    16.500    40.683
    17.000    40.387
    17.500    40.081
    18.000    39.766
    18.500    39.438
    19.000    39.095
    19.500    38.735
    20.000    38.356
    20.500    37.956
    21.000    37.532
    21.500    37.082
    22.000    36.605
    22.500    36.097
    23.000    35.557
    23.500    34.984
    24.000    33.727
    24.500    32.455
    25.000    31.173
    25.500    29.880
    26.000    28.577
    26.500    27.262
    27.000    25.934
    27.500    24.590
    28.000    23.226
    28.500    21.846
    29.000    20.456
    29.500    19.057
    30.000    17.650
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    20.226 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     7.622
     1.500     8.662
     2.000     9.703
     2.500    10.744
     3.000    11.780
     3.500    12.814
     4.000    13.844
     4.500    14.870
     5.000    15.892
     5.500    16.909
     6.000    17.920
     6.500    18.925
     7.000    19.923
     7.500    20.913
     8.000    21.895
     8.500    22.869
     9.000    23.834
     9.500    24.789
    10.000    25.734
    10.500    26.673
    11.000    27.604
    11.500    28.525
    12.000    29.436
    12.500    30.337
    13.000    31.227
    13.500    32.105
    14.000    32.972
    14.500    33.829
    15.000    34.685
    15.500    35.537
    16.000    36.384
    16.500    37.224
    17.000    38.002
    17.500    38.992
    18.000    39.335
    18.500    39.619
    19.000    39.845
    19.500    40.013
    20.000    40.123
    20.500    40.174
    21.000    40.165
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    28.227 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.153
     1.000     7.221
     1.500     9.912
     2.000    12.604
     2.500    15.294
     3.000    17.984
     3.500    20.673
     4.000    23.361
     4.500    26.048
     5.000    28.733
     5.500    31.418
     6.000    34.100
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.733 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    21.688
     1.500    28.193
     2.000    34.699
     2.500    41.204
     3.000    47.710
     3.500    54.211
     4.000    60.710
     4.500    67.207
     5.000    73.701
     5.500    80.189
     6.000    86.675
     6.500    93.156
     7.000    99.632
     7.500   106.104
     8.000   112.568
     8.500   119.028
     9.000   125.480
     9.500   131.926
    10.000   138.364
    10.500   144.795
    11.000   151.218
    11.500   157.632
    12.000   164.037
    12.500   170.432
    13.000   176.817
    13.500   183.193
    14.000   189.558
    14.500   195.912
    15.000   202.253
    15.500   208.584
    16.000   214.903
    16.500   221.208
    17.000   227.500
    17.500   233.453
    18.000   239.723
    18.500   245.981
    19.000   252.226
    19.500   258.457
    20.000   264.674
    20.500   270.877
    21.000   277.065
    21.500   283.238
    22.000   289.395
    22.500   295.536
    23.000   301.661
    23.500   307.768
    24.000   313.859
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    58.710 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    11.457
     1.000    20.591
     1.500    29.151
     2.000    37.711
     2.500    46.269
     3.000    54.827
     3.500    63.384
     4.000    71.938
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    61.384 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    26.887   293.622     0.150
    27.339   220.542     0.150
    27.339   435.495     0.150
    27.677   433.849     0.150
    29.096   204.045     0.150
    29.096   421.092     0.150
    26.223   235.131     0.150
    29.935   200.893     0.150
    29.935   200.881     0.150
    26.558   294.243     0.150
    26.558   313.345     0.150
    26.583   227.786     0.150
    26.622   227.435     0.150
    26.622   227.599     0.150
    26.622   443.044     0.150
    27.461   220.285     0.150
    29.037   205.314     0.150
    16.595   225.011     0.150
    27.357   220.171     0.150
    29.044   204.262     0.150
    26.590   295.843     0.150
    27.439   219.861     0.150
    29.141   203.566     0.150
    28.686   209.271     0.150
    20.788   257.521     0.150
    29.073   205.502     0.150
    26.236   304.303     0.150
    29.965   199.691     0.150
    29.288   205.248     0.150
    27.398   221.332     0.150
    29.029   205.425     0.150
    20.775   253.790     0.150
    26.922   298.079     0.150
    27.383   220.359     0.150
    27.383   435.785     0.150
    29.053   205.440     0.150
    29.053   420.022     0.150
    29.523   199.710     0.150
    29.265   205.683     0.150
    18.713   257.769     0.150
    25.984   303.807     0.150
    26.492   234.506     0.150
    29.470   206.809     0.150
    29.053   204.307     0.150
    29.479   204.672     0.150
    26.264   303.795     0.150
    29.936   203.344     0.150
    20.740   254.433     0.150
    26.972   294.649     0.150
    27.436   219.744     0.150
    29.021   205.090     0.150
    29.104   207.132     0.150
    27.795   219.778     0.150
    29.118   207.853     0.150
    29.118   207.626     0.150
    28.731   210.564     0.150
    27.170   221.077     0.150
    29.273   201.281     0.150
    26.814   295.204     0.150
    27.103   222.647     0.150
    27.103   439.225     0.150
    29.530   200.236     0.150
    29.530   418.142     0.150
    27.121   225.963     0.150
    29.996   200.793     0.150
    29.996   199.303     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.577    35.468     0.200
    16.049    37.104     0.200
    16.187    37.391     0.200
    16.436    37.374     0.200
    16.625    36.759     0.200
    16.867    36.665     0.200
    17.083    36.425     0.200
    17.152    36.829     0.200
    17.152    36.579     0.200
    17.340    38.587     0.200
    17.200    37.065     0.200
    17.687    37.286     0.200
    17.872    42.120     0.200
    18.065    35.002     0.200
    18.441    33.977     0.200
    19.749    35.111     0.200
    19.809    34.513     0.200
    20.559    34.770     0.200
    21.535    36.473     0.200
    21.693    32.428     0.200
    21.900    31.715     0.200
    22.084    32.070     0.200
    22.084    30.312     0.200
    22.312    28.409     0.200
    22.625    33.276     0.200
    23.414    29.549     0.200
    23.770    29.773     0.200
    23.885    29.703     0.200
    24.246    28.953     0.200
    24.227    27.704     0.200
    24.272    28.353     0.200
    24.885    27.915     0.200
    25.252    25.150     0.200
    25.192    24.999     0.200
    25.196    23.746     0.200
    25.642    23.654     0.200
    25.642    22.849     0.200
    26.887    20.318     0.200
    26.887    19.013     0.200
    26.682    25.957     0.200
    27.339    18.097     0.200
    27.677    17.099     0.200
    27.835    21.454     0.200
    28.568    11.866     0.200
    29.184    13.210     0.200
    29.096    15.318     0.200
    29.102    15.868     0.200
    29.102    15.665     0.200
    29.102    16.462     0.200
    29.784    16.312     0.200
    15.086    38.896     0.200
    16.149    39.590     0.200
    16.097    42.806     0.200
    16.970    40.114     0.200
    17.239    39.583     0.200
    17.239    40.981     0.200
    19.114    37.022     0.200
    21.183    37.557     0.200
    21.708    37.549     0.200
    21.708    35.846     0.200
    22.087    33.686     0.200
    23.310    35.832     0.200
    23.784    34.391     0.200
    23.895    31.421     0.200
    24.623    34.210     0.200
    24.922    29.310     0.200
    25.105    32.480     0.200
    26.184    25.624     0.200
    26.223    24.498     0.200
    26.223    25.638     0.200
    26.561    24.754     0.200
    29.935    17.346     0.200
    29.935    17.342     0.200
    29.946    17.152     0.200
    14.400    37.228     0.200
    16.631    38.599     0.200
    17.907    37.604     0.200
    18.265    35.828     0.200
    18.685    35.030     0.200
    19.399    33.293     0.200
    19.083    37.398     0.200
    19.446    37.250     0.200
    19.976    35.213     0.200
    20.667    33.392     0.200
    21.147    34.795     0.200
    21.639    31.751     0.200
    21.921    35.217     0.200
    21.921    34.077     0.200
    22.427    33.241     0.200
    22.660    32.631     0.200
    22.852    31.007     0.200
    22.864    30.589     0.200
    22.864    31.362     0.200
    22.593    34.906     0.200
    23.070    32.417     0.200
    23.054    28.208     0.200
    23.148    31.878     0.200
    23.336    31.576     0.200
    23.498    28.959     0.200
    23.546    30.457     0.200
    23.859    30.732     0.200
    23.545    33.192     0.200
    23.545    32.262     0.200
    23.940    29.828     0.200
    23.958    31.300     0.200
    23.795    31.237     0.200
    24.000    28.503     0.200
    24.203    26.359     0.200
    24.313    26.850     0.200
    24.336    26.193     0.200
    24.336    26.576     0.200
    24.301    30.059     0.200
    24.301    25.957     0.200
    24.301    26.965     0.200
    24.376    29.205     0.200
    24.409    28.002     0.200
    24.443    25.931     0.200
    24.496    26.207     0.200
    24.779    27.398     0.200
    24.849    27.413     0.200
    25.147    26.017     0.200
    25.194    27.003     0.200
    25.131    25.723     0.200
    25.328    26.678     0.200
    25.469    23.258     0.200
    25.484    25.955     0.200
    25.562    24.477     0.200
    25.186    30.552     0.200
    25.363    26.329     0.200
    25.363    25.900     0.200
    25.666    24.654     0.200
    26.047    25.464     0.200
    26.066    24.246     0.200
    26.108    29.356     0.200
    26.065    23.371     0.200
    26.558    23.642     0.200
    26.583    20.958     0.200
    26.622    20.427     0.200
    26.622    22.364     0.200
    26.622    19.997     0.200
    26.242    25.928     0.200
    26.568    22.038     0.200
    26.568    23.428     0.200
    26.628    22.692     0.200
    26.457    24.771     0.200
    26.961    20.039     0.200
    26.964    18.922     0.200
    26.964    20.531     0.200
    26.964    20.015     0.200
    27.073    19.071     0.200
    27.461    23.285     0.200
    27.461    22.598     0.200
    27.623    21.892     0.200
    28.096    20.709     0.200
    28.642    15.549     0.200
    29.098    18.996     0.200
    29.098    18.504     0.200
    29.098    19.176     0.200
    29.312    14.144     0.200
    15.265    36.350     0.200
    16.609    37.265     0.200
    17.084    37.523     0.200
    19.795    34.394     0.200
    20.539    36.310     0.200
    22.631    32.149     0.200
    22.674    35.118     0.200
    24.224    30.379     0.200
    25.619    23.541     0.200
    27.410    18.127     0.200
    27.748    15.915     0.200
    29.024    17.895     0.200
    29.037    17.113     0.200
    29.037    18.007     0.200
    29.048    17.843     0.200
    29.221    17.614     0.200
    16.371    36.625     0.200
    16.595    38.261     0.200
    18.046    35.279     0.200
    18.025    33.980     0.200
    18.025    35.820     0.200
    18.394    34.288     0.200
    19.754    34.850     0.200
    19.754    32.650     0.200
    20.502    33.420     0.200
    21.467    31.858     0.200
    21.662    34.476     0.200
    22.632    30.800     0.200
    22.632    32.761     0.200
    22.723    32.522     0.200
    24.215    27.661     0.200
    24.215    29.583     0.200
    25.483    25.589     0.200
    25.584    22.177     0.200
    25.584    25.607     0.200
    26.523    24.551     0.200
    27.054    18.804     0.200
    27.357    18.171     0.200
    27.357    17.499     0.200
    27.695    15.648     0.200
    28.687    13.626     0.200
    29.030    15.161     0.200
    29.044    16.738     0.200
    29.044    14.847     0.200
    29.050    16.304     0.200
    29.050    17.061     0.200
    29.054    16.683     0.200
    29.227    15.967     0.200
    22.213    38.788     0.200
    28.685    22.929     0.200
    28.704    23.645     0.200
    28.704    23.036     0.200
    28.714    23.213     0.200
    29.946    20.968     0.200
    13.828    35.368     0.200
    15.876    37.167     0.200
    15.822    36.703     0.200
    17.320    37.119     0.200
    18.523    33.382     0.200
    18.408    36.733     0.200
    19.900    33.198     0.200
    19.900    34.908     0.200
    19.967    34.430     0.200
    19.967    34.230     0.200
    20.708    35.778     0.200
    20.852    36.276     0.200
    20.852    35.581     0.200
    21.629    35.753     0.200
    21.629    35.533     0.200
    21.855    33.200     0.200
    22.251    32.933     0.200
    22.251    33.773     0.200
    22.251    30.673     0.200
    22.856    29.814     0.200
    22.658    34.851     0.200
    22.658    33.311     0.200
    22.748    33.142     0.200
    22.748    31.892     0.200
    22.748    34.572     0.200
    23.189    29.305     0.200
    23.189    31.425     0.200
    23.185    29.981     0.200
    23.507    28.419     0.200
    23.955    28.825     0.200
    24.056    26.281     0.200
    24.221    27.675     0.200
    24.221    28.085     0.200
    24.359    30.523     0.200
    24.359    28.838     0.200
    24.359    30.678     0.200
    24.302    31.465     0.200
    24.302    31.645     0.200
    25.348    24.836     0.200
    25.382    27.859     0.200
    25.382    27.739     0.200
    25.629    25.423     0.200
    25.629    26.253     0.200
    25.563    27.788     0.200
    25.563    29.018     0.200
    26.173    21.307     0.200
    26.563    24.728     0.200
    26.563    25.058     0.200
    26.590    24.413     0.200
    26.590    24.198     0.200
    26.590    25.438     0.200
    26.590    23.983     0.200
    26.590    24.963     0.200
    27.041    23.280     0.200
    27.066    21.783     0.200
    27.137    23.873     0.200
    27.439    17.868     0.200
    27.439    17.528     0.200
    27.778    16.058     0.200
    27.778    16.778     0.200
    28.784    14.571     0.200
    29.313    12.475     0.200
    29.130    15.593     0.200
    29.141    16.826     0.200
    29.141    17.141     0.200
    29.148    17.329     0.200
    29.152    16.650     0.200
    29.325    16.329     0.200
    20.425    38.078     0.200
    20.425    37.969     0.200
    28.672    22.114     0.200
    28.686    21.171     0.200
    28.697    20.742     0.200
    28.869    20.699     0.200
    29.837    17.969     0.200
    17.221    37.547     0.200
    20.788    34.427     0.200
    20.788    36.146     0.200
    22.675    33.346     0.200
    24.279    29.676     0.200
    24.279    30.379     0.200
    25.549    26.256     0.200
    26.512    25.617     0.200
    27.147    20.914     0.200
    27.444    19.772     0.200
    27.444    18.694     0.200
    29.061    16.722     0.200
    29.073    16.690     0.200
    29.073    17.307     0.200
    29.080    17.153     0.200
    29.084    17.463     0.200
    29.257    17.521     0.200
    20.521    39.420     0.200
    20.521    40.504     0.200
    21.869    38.928     0.200
    26.236    31.104     0.200
    26.998    24.787     0.200
    28.734    22.794     0.200
    29.965    19.838     0.200
    21.095    37.626     0.200
    26.409    24.968     0.200
    29.288    19.263     0.200
    19.683    39.154     0.200
    27.851    23.031     0.200
    29.150    20.455     0.200
    15.079    41.283     0.200
    17.996    37.165     0.200
    20.750    34.461     0.200
    20.750    34.164     0.200
    21.564    28.732     0.200
    22.621    32.312     0.200
    22.621    34.077     0.200
    22.684    35.123     0.200
    22.910    26.965     0.200
    24.211    28.533     0.200
    25.598    23.095     0.200
    25.598    23.454     0.200
    27.398    16.941     0.200
    27.398    18.730     0.200
    27.398    17.332     0.200
    27.735    16.218     0.200
    29.029    18.972     0.200
    29.175    16.645     0.200
    29.284    19.884     0.200
    20.492    40.966     0.200
    20.492    38.782     0.200
    22.220    38.675     0.200
    28.704    24.302     0.200
    28.710    22.188     0.200
    29.936    20.335     0.200
    29.936    19.195     0.200
    14.814    39.676     0.200
    15.036    36.083     0.200
    15.256    36.016     0.200
    15.666    36.030     0.200
    15.844    37.057     0.200
    15.897    36.832     0.200
    16.029    37.490     0.200
    16.177    36.274     0.200
    16.416    36.281     0.200
    17.140    36.629     0.200
    17.355    36.619     0.200
    17.348    37.399     0.200
    17.771    37.266     0.200
    18.018    37.533     0.200
    18.018    36.842     0.200
    18.018    36.591     0.200
    18.018    36.989     0.200
    18.488    34.103     0.200
    19.528    32.464     0.200
    19.785    32.972     0.200
    19.785    35.162     0.200
    19.792    34.477     0.200
    19.792    34.277     0.200
    20.010    35.634     0.200
    20.538    35.071     0.200
    20.775    36.265     0.200
    20.775    35.640     0.200
    20.775    34.225     0.200
    20.775    36.114     0.200
    21.196    34.499     0.200
    21.502    32.328     0.200
    21.502    32.022     0.200
    21.651    32.081     0.200
    21.678    33.673     0.200
    21.777    30.613     0.200
    21.645    35.677     0.200
    21.645    35.502     0.200
    22.072    30.528     0.200
    22.072    29.118     0.200
    22.072    31.678     0.200
    22.072    31.778     0.200
    22.298    29.941     0.200
    22.371    32.182     0.200
    22.543    31.378     0.200
    22.793    29.063     0.200
    22.646    32.504     0.200
    22.646    32.839     0.200
    22.646    31.710     0.200
    22.896    30.653     0.200
    22.927    27.009     0.200
    22.927    29.899     0.200
    22.887    28.060     0.200
    22.700    33.528     0.200
    22.700    34.001     0.200
    22.700    34.841     0.200
    22.700    34.351     0.200
    23.021    29.708     0.200
    23.308    26.648     0.200
    23.459    28.915     0.200
    23.459    29.684     0.200
    23.486    29.073     0.200
    23.771    29.862     0.200
    23.771    29.093     0.200
    24.073    27.688     0.200
    24.235    30.677     0.200
    24.235    30.518     0.200
    24.235    30.117     0.200
    24.344    31.925     0.200
    24.344    31.397     0.200
    24.344    30.996     0.200
    25.048    23.743     0.200
    25.174    25.669     0.200
    25.504    26.148     0.200
    25.620    23.481     0.200
    25.620    23.252     0.200
    25.620    24.071     0.200
    25.620    24.471     0.200
    25.637    26.376     0.200
    25.657    25.837     0.200
    25.889    20.425     0.200
    25.603    30.229     0.200
    25.603    28.895     0.200
    26.520    25.116     0.200
    26.520    24.817     0.200
    26.922    18.869     0.200
    26.922    21.279     0.200
    26.922    20.879     0.200
    26.637    25.205     0.200
    26.637    26.546     0.200
    26.902    20.908     0.200
    27.112    21.153     0.200
    27.259    21.040     0.200
    27.383    18.077     0.200
    27.383    18.039     0.200
    27.383    17.759     0.200
    27.432    20.926     0.200
    27.721    16.866     0.200
    27.721    17.106     0.200
    27.721    16.546     0.200
    27.719    16.872     0.200
    27.815    20.454     0.200
    27.828    21.300     0.200
    27.868    18.529     0.200
    28.716    14.434     0.200
    29.054    17.400     0.200
    29.053    16.905     0.200
    29.060    17.230     0.200
    29.060    16.940     0.200
    29.523    12.090     0.200
    29.523    12.560     0.200
    29.704    14.581     0.200
    29.704    15.211     0.200
    29.908    13.233     0.200
    20.741    36.781     0.200
    29.023    20.303     0.200
    18.642    39.167     0.200
    19.021    39.692     0.200
    21.072    38.112     0.200
    21.072    37.237     0.200
    22.758    35.117     0.200
    24.177    32.161     0.200
    26.422    28.259     0.200
    29.265    19.409     0.200
    29.265    18.722     0.200
    15.585    40.163     0.200
    15.781    41.273     0.200
    16.166    40.777     0.200
    16.497    40.917     0.200
    17.512    40.973     0.200
    18.485    38.820     0.200
    18.508    40.350     0.200
    18.846    37.141     0.200
    18.846    39.911     0.200
    18.713    39.828     0.200
    18.713    39.459     0.200
    18.956    40.523     0.200
    19.121    37.397     0.200
    19.088    39.641     0.200
    19.526    39.970     0.200
    19.650    37.623     0.200
    19.660    38.412     0.200
    20.140    39.206     0.200
    20.729    37.431     0.200
    21.251    38.037     0.200
    21.309    38.561     0.200
    21.331    38.305     0.200
    21.251    39.434     0.200
    21.251    39.835     0.200
    21.251    39.985     0.200
    21.251    40.134     0.200
    21.251    37.405     0.200
    21.373    39.322     0.200
    21.455    39.058     0.200
    21.593    36.354     0.200
    21.617    35.769     0.200
    21.710    35.334     0.200
    21.710    37.283     0.200
    21.819    36.114     0.200
    21.926    36.560     0.200
    22.033    37.411     0.200
    22.157    37.364     0.200
    22.442    35.844     0.200
    22.535    36.357     0.200
    22.584    34.325     0.200
    22.584    37.286     0.200
    22.457    40.865     0.200
    22.457    41.461     0.200
    22.457    39.166     0.200
    22.711    33.699     0.200
    22.898    35.321     0.200
    23.088    35.707     0.200
    22.988    38.065     0.200
    22.988    38.234     0.200
    22.988    35.465     0.200
    22.988    38.965     0.200
    22.988    37.363     0.200
    23.179    37.687     0.200
    23.179    36.640     0.200
    23.179    36.441     0.200
    23.142    31.670     0.200
    23.571    39.664     0.200
    23.571    35.052     0.200
    23.571    37.763     0.200
    24.081    31.719     0.200
    24.094    33.127     0.200
    24.094    32.758     0.200
    24.369    30.553     0.200
    24.449    34.422     0.200
    24.449    34.840     0.200
    24.449    32.651     0.200
    24.449    33.821     0.200
    25.217    36.189     0.200
    25.217    33.554     0.200
    25.450    29.186     0.200
    25.450    29.035     0.200
    25.582    29.197     0.200
    25.572    30.410     0.200
    25.593    30.267     0.200
    25.703    31.056     0.200
    25.984    31.208     0.200
    25.984    29.708     0.200
    26.439    29.000     0.200
    26.449    28.978     0.200
    26.492    29.273     0.200
    26.492    25.004     0.200
    26.492    29.599     0.200
    26.492    26.824     0.200
    26.492    25.404     0.200
    26.492    29.174     0.200
    26.317    33.041     0.200
    26.470    31.149     0.200
    26.769    26.352     0.200
    26.829    27.146     0.200
    26.829    27.855     0.200
    26.829    24.675     0.200
    26.829    26.545     0.200
    26.827    25.871     0.200
    27.069    26.341     0.200
    27.056    25.394     0.200
    27.199    26.125     0.200
    27.611    24.523     0.200
    27.516    29.424     0.200
    27.516    24.725     0.200
    27.516    26.825     0.200
    27.970    26.819     0.200
    27.970    28.054     0.200
    27.970    25.335     0.200
    28.657    19.429     0.200
    28.998    25.964     0.200
    28.998    26.859     0.200
    28.998    23.128     0.200
    29.308    23.160     0.200
    29.308    21.410     0.200
    29.470    22.198     0.200
    29.470    18.872     0.200
    29.471    21.668     0.200
    29.471    22.017     0.200
    29.820    21.582     0.200
    29.820    20.230     0.200
    29.820    20.742     0.200
    20.776    34.906     0.200
    20.776    34.480     0.200
    26.904    20.345     0.200
    27.370    17.928     0.200
    29.053    16.889     0.200
    29.053    16.014     0.200
    21.276    38.377     0.200
    26.393    29.184     0.200
    29.485    19.425     0.200
    21.273    37.301     0.200
    29.479    19.054     0.200
    28.209    23.258     0.200
    29.528    19.218     0.200
    21.107    37.899     0.200
    29.295    20.663     0.200
    21.291    38.465     0.200
    21.291    37.879     0.200
    23.003    35.257     0.200
    23.937    33.212     0.200
    26.365    26.079     0.200
    26.365    25.852     0.200
    29.497    20.046     0.200
    29.504    19.436     0.200
    20.648    40.293     0.200
    22.373    39.350     0.200
    23.167    39.001     0.200
    23.836    34.675     0.200
    26.883    27.248     0.200
    26.883    26.619     0.200
    28.859    23.299     0.200
    14.579    41.057     0.200
    16.792    42.233     0.200
    16.850    41.750     0.200
    17.074    41.538     0.200
    17.197    42.405     0.200
    18.393    41.018     0.200
    20.493    40.753     0.200
    20.493    39.601     0.200
    20.642    39.506     0.200
    21.836    40.518     0.200
    21.836    42.170     0.200
    22.226    38.544     0.200
    22.226    38.684     0.200
    23.701    35.627     0.200
    24.499    34.025     0.200
    25.475    29.667     0.200
    26.264    28.693     0.200
    27.031    26.146     0.200
    27.031    27.263     0.200
    27.031    26.376     0.200
    27.363    27.573     0.200
    27.349    27.382     0.200
    28.707    23.605     0.200
    28.714    23.909     0.200
    29.936    20.895     0.200
    29.936    19.793     0.200
    21.281    35.572     0.200
    27.621    22.029     0.200
    29.489    19.206     0.200
    17.150    37.498     0.200
    17.972    37.376     0.200
    18.340    36.874     0.200
    18.340    37.216     0.200
    19.836    35.245     0.200
    19.797    34.958     0.200
    19.797    33.378     0.200
    20.740    37.108     0.200
    21.594    37.506     0.200
    22.617    33.480     0.200
    22.617    32.859     0.200
    22.617    32.369     0.200
    24.214    30.110     0.200
    25.067    24.556     0.200
    25.619    27.040     0.200
    25.942    21.959     0.200
    26.972    20.649     0.200
    27.436    18.085     0.200
    27.774    17.852     0.200
    29.021    18.117     0.200
    29.736    18.912     0.200
    19.630    40.249     0.200
    19.630    37.319     0.200
    22.630    36.073     0.200
    27.261    25.968     0.200
    27.778    25.211     0.200
    27.778    24.078     0.200
    27.784    24.343     0.200
    29.104    20.933     0.200
    29.104    20.683     0.200
    19.645    39.153     0.200
    22.651    35.711     0.200
    27.260    25.032     0.200
    27.260    25.985     0.200
    27.260    24.813     0.200
    27.795    23.911     0.200
    27.795    23.786     0.200
    27.800    23.726     0.200
    29.118    21.056     0.200
    29.118    20.728     0.200
    20.568    38.669     0.200
    20.568    38.048     0.200
    22.217    36.266     0.200
    26.667    28.148     0.200
    26.667    28.037     0.200
    26.667    28.718     0.200
    28.740    20.601     0.200
    28.740    20.412     0.200
    28.745    21.353     0.200
    20.559    39.117     0.200
    20.559    39.292     0.200
    20.830    37.526     0.200
    22.136    39.184     0.200
    22.210    38.500     0.200
    22.210    37.469     0.200
    22.210    38.321     0.200
    23.610    34.599     0.200
    24.086    31.557     0.200
    26.256    29.269     0.200
    26.680    27.204     0.200
    26.680    26.704     0.200
    27.333    26.702     0.200
    27.333    25.515     0.200
    28.731    21.615     0.200
    28.737    21.656     0.200
    18.256    40.337     0.200
    18.624    40.549     0.200
    18.639    40.664     0.200
    20.580    39.159     0.200
    20.580    38.280     0.200
    22.166    38.099     0.200
    22.228    37.115     0.200
    22.228    37.974     0.200
    23.403    36.323     0.200
    23.624    36.660     0.200
    24.054    33.831     0.200
    24.054    31.382     0.200
    24.544    33.461     0.200
    26.649    26.339     0.200
    26.649    24.339     0.200
    26.981    25.837     0.200
    26.979    25.954     0.200
    28.751    21.256     0.200
    28.751    21.698     0.200
    17.346    36.038     0.200
    21.000    35.003     0.200
    21.000    34.792     0.200
    22.857    32.875     0.200
    22.857    31.476     0.200
    25.745    24.155     0.200
    27.170    16.624     0.200
    27.170    17.983     0.200
    27.508    16.528     0.200
    27.506    16.654     0.200
    29.273    15.360     0.200
    29.273    15.211     0.200
    29.280    15.339     0.200
    15.568    36.951     0.200
    16.718    36.681     0.200
    18.164    33.125     0.200
    18.440    36.532     0.200
    18.440    37.133     0.200
    20.187    33.590     0.200
    20.187    34.649     0.200
    21.246    34.959     0.200
    21.246    35.423     0.200
    22.435    31.751     0.200
    22.008    35.200     0.200
    22.008    37.301     0.200
    23.161    29.741     0.200
    23.161    30.331     0.200
    23.127    31.441     0.200
    23.127    32.562     0.200
    23.127    32.241     0.200
    23.013    35.037     0.200
    24.817    24.147     0.200
    24.817    25.256     0.200
    24.715    27.800     0.200
    25.578    24.313     0.200
    26.042    22.802     0.200
    26.042    23.782     0.200
    26.042    24.224     0.200
    25.982    23.717     0.200
    26.814    21.704     0.200
    27.103    18.439     0.200
    27.103    18.150     0.200
    27.103    19.451     0.200
    27.442    17.881     0.200
    27.442    17.401     0.200
    27.440    17.445     0.200
    27.216    22.367     0.200
    27.514    22.929     0.200
    29.517    16.148     0.200
    29.530    15.439     0.200
    29.537    14.937     0.200
    29.537    15.426     0.200
    29.537    15.726     0.200
    29.537    16.137     0.200
    14.621    40.528     0.200
    16.714    40.895     0.200
    18.305    40.577     0.200
    18.011    39.332     0.200
    18.387    37.288     0.200
    19.173    39.706     0.200
    20.564    38.884     0.200
    20.564    38.089     0.200
    20.564    37.214     0.200
    21.426    37.065     0.200
    21.426    34.645     0.200
    22.334    35.704     0.200
    23.228    32.064     0.200
    22.932    35.318     0.200
    23.839    34.737     0.200
    23.839    31.807     0.200
    24.633    29.831     0.200
    24.633    28.360     0.200
    25.035    29.306     0.200
    25.099    30.433     0.200
    25.826    31.290     0.200
    27.121    25.141     0.200
    27.121    22.313     0.200
    27.121    22.521     0.200
    26.882    26.945     0.200
    26.883    27.804     0.200
    27.456    21.429     0.200
    27.456    21.920     0.200
    27.454    21.946     0.200
    27.295    26.726     0.200
    28.796    21.915     0.200
    28.802    21.818     0.200
    28.802    20.238     0.200
    29.996    17.643     0.200
    27.121    23.091     0.200
    14.621    41.519     0.200
    15.742    40.335     0.200
    16.408    39.699     0.200
    16.714    40.240     0.200
    18.387    39.773     0.200
    19.173    38.151     0.200
    19.311    40.113     0.200
    20.564    38.645     0.200
    21.426    36.849     0.200
    21.782    39.275     0.200
    22.334    36.793     0.200
    22.334    38.504     0.200
    22.932    37.334     0.200
    23.839    34.574     0.200
    24.690    33.062     0.200
    25.035    30.232     0.200
    25.099    30.080     0.200
    25.685    30.758     0.200
    25.689    32.022     0.200
    25.826    30.898     0.200
    26.440    28.763     0.200
    26.631    26.473     0.200
    26.882    27.066     0.200
    26.883    28.286     0.200
    27.295    26.162     0.200
    27.456    21.733     0.200
    28.802    20.504     0.200
    29.996    19.788     0.200
    29.972    18.662     0.200
    29.996    19.112     0.200
    28.726    23.049     0.200
    24.579    35.405     0.200
    28.119    23.553     0.200
    25.207    32.530     0.200
    25.471    31.619     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.589     5.020     0.200
     0.957     6.416     0.200
     0.902     4.263     0.200
     1.229     7.241     0.200
     1.473     5.697     0.200
     1.725     9.163     0.200
     1.781     8.010     0.200
     1.933     9.127     0.200
     2.193     8.797     0.200
     2.365     9.695     0.200
     3.023    11.113     0.200
     3.388    11.648     0.200
     3.544    12.531     0.200
     3.544    11.906     0.200
     3.655    12.632     0.200
     3.525    10.944     0.200
     3.923    11.810     0.200
     4.051    13.011     0.200
     4.362    13.883     0.200
     4.486    14.935     0.200
     4.761    13.937     0.200
     4.796    13.223     0.200
     4.957    15.940     0.200
     5.134    15.874     0.200
     5.284    15.427     0.200
     5.301    15.328     0.200
     5.381    16.790     0.200
     5.442    16.382     0.200
     5.553    15.389     0.200
     5.738    17.423     0.200
     6.001    18.058     0.200
     6.045    16.846     0.200
     6.652    18.159     0.200
     6.571    19.105     0.200
     6.953    20.540     0.200
     7.031    20.133     0.200
     6.992    19.395     0.200
     7.140    19.470     0.200
     7.140    17.696     0.200
     7.203    19.933     0.200
     7.327    19.988     0.200
     7.725    21.737     0.200
     8.149    21.691     0.200
     8.172    21.823     0.200
     8.199    21.605     0.200
     8.588    20.867     0.200
     8.571    22.660     0.200
     9.070    24.644     0.200
     9.083    24.583     0.200
     9.055    23.411     0.200
     9.870    25.084     0.200
     9.859    22.939     0.200
    10.094    26.010     0.200
    10.066    24.620     0.200
    10.066    24.362     0.200
    10.194    23.031     0.200
    10.479    26.934     0.200
    11.334    25.018     0.200
    11.521    29.444     0.200
    11.634    25.624     0.200
    13.020    29.458     0.200
    13.020    32.240     0.200
    13.020    31.740     0.200
    13.072    26.443     0.200
    13.072    25.389     0.200
    13.215    26.597     0.200
    13.215    26.871     0.200
    13.315    33.204     0.200
    13.315    32.804     0.200
    13.297    28.007     0.200
    13.631    31.267     0.200
    13.664    33.047     0.200
    13.535    32.629     0.200
    13.664    33.829     0.200
    13.644    32.463     0.200
    14.071    33.479     0.200
    16.625    35.673     0.200
    17.212    33.528     0.200
    17.200    32.362     0.200
    18.930    37.668     0.200
     1.955     9.745     0.200
     2.097    10.288     0.200
     2.402    11.333     0.200
     2.429    11.101     0.200
     3.073    14.502     0.200
     3.323    13.376     0.200
     3.854    13.978     0.200
     3.854    13.798     0.200
     4.071    15.642     0.200
     4.265    16.784     0.200
     4.248    18.182     0.200
     4.347    17.922     0.200
     4.347    17.625     0.200
     4.439    16.062     0.200
     4.653    14.657     0.200
     4.771    17.582     0.200
     5.330    18.859     0.200
     5.653    18.482     0.200
     5.873    17.620     0.200
     6.529    21.567     0.200
     6.970    21.419     0.200
     7.695    23.647     0.200
     7.678    22.761     0.200
     7.779    23.077     0.200
     7.957    23.003     0.200
     8.459    24.139     0.200
     8.666    25.127     0.200
     8.992    25.918     0.200
     8.992    26.254     0.200
    10.291    27.062     0.200
    10.656    27.001     0.200
    12.071    27.689     0.200
    12.149    26.676     0.200
    12.149    27.527     0.200
    13.564    35.467     0.200
    13.517    31.416     0.200
    13.690    35.399     0.200
    15.634    36.128     0.200
    17.153    35.283     0.200
    17.756    37.370     0.200
    20.420    43.953     0.200
    20.782    39.928     0.200
     0.732     4.742     0.200
     1.302     6.984     0.200
     1.420     7.607     0.200
     1.420     7.404     0.200
     1.760     8.737     0.200
     1.859     7.230     0.200
     1.859     6.777     0.200
     2.152     8.760     0.200
     2.369     9.034     0.200
     2.399    10.087     0.200
     2.759    10.483     0.200
     3.033    11.077     0.200
     3.401    12.087     0.200
     4.250    11.219     0.200
     4.250    13.875     0.200
     4.305    14.737     0.200
     4.330    13.148     0.200
     4.611    15.365     0.200
     4.475    14.040     0.200
     4.564    13.635     0.200
     4.564    14.315     0.200
     4.933    13.806     0.200
     4.953    17.079     0.200
     5.225    16.207     0.200
     5.241    16.710     0.200
     5.837    17.958     0.200
     6.847    20.968     0.200
     6.924    18.069     0.200
     7.478    21.209     0.200
     7.967    21.309     0.200
     8.196    21.994     0.200
     8.196    23.533     0.200
     9.116    20.721     0.200
     9.116    23.088     0.200
     9.127    20.069     0.200
     9.382    23.495     0.200
     9.382    24.089     0.200
     9.208    25.125     0.200
     9.260    24.120     0.200
     9.846    22.024     0.200
     9.846    24.673     0.200
    10.338    21.533     0.200
    10.152    24.491     0.200
    10.152    25.108     0.200
    11.631    28.821     0.200
    11.631    29.844     0.200
    11.797    27.408     0.200
    12.032    22.834     0.200
    12.032    23.263     0.200
    12.246    24.264     0.200
    12.246    24.522     0.200
    13.194    35.709     0.200
    13.684    28.564     0.200
    13.684    28.885     0.200
    13.689    28.724     0.200
    13.748    26.343     0.200
    13.931    30.705     0.200
    13.931    34.056     0.200
    14.176    34.946     0.200
    14.243    34.664     0.200
    14.499    34.471     0.200
    15.441    28.791     0.200
    15.645    30.698     0.200
    16.179    33.169     0.200
    16.385    32.658     0.200
    16.846    35.697     0.200
    16.942    37.065     0.200
    17.112    34.894     0.200
    17.112    34.636     0.200
    17.726    35.049     0.200
    17.928    34.886     0.200
    19.663    37.909     0.200
     0.643     4.798     0.200
     1.029     6.288     0.200
     1.267     7.234     0.200
     1.794     8.966     0.200
     1.736     8.737     0.200
     2.005     9.695     0.200
     2.166     8.519     0.200
     2.358     9.786     0.200
     3.457    13.460     0.200
     3.527    12.742     0.200
     3.492    10.852     0.200
     3.727    14.105     0.200
     4.120    15.218     0.200
     4.145    12.721     0.200
     5.368    17.253     0.200
     5.405    15.220     0.200
     5.807    17.537     0.200
     7.101    17.833     0.200
     7.101    19.935     0.200
     7.796    22.315     0.200
     7.880    22.439     0.200
     8.136    23.049     0.200
     8.652    20.723     0.200
     9.812    24.892     0.200
    10.700    25.728     0.200
    11.701    26.744     0.200
    13.001    31.398     0.200
    13.140    26.201     0.200
    13.287    25.094     0.200
    13.293    31.867     0.200
    13.509    30.844     0.200
    15.097    33.630     0.200
    16.188    34.681     0.200
    16.426    32.101     0.200
    17.146    33.130     0.200
    17.158    36.709     0.200
    17.158    35.759     0.200
    17.365    31.925     0.200
    18.097    38.010     0.200
    17.995    38.058     0.200
    18.363    37.964     0.200
     0.576     5.046     0.200
     0.747     4.464     0.200
     0.984     5.888     0.200
     1.201     7.438     0.200
     1.201     7.262     0.200
     1.415     5.660     0.200
     1.823     7.899     0.200
     1.960     9.399     0.200
     1.967     8.215     0.200
     3.057    11.395     0.200
     3.242     9.741     0.200
     3.432    12.329     0.200
     3.467    10.574     0.200
     3.467    10.913     0.200
     3.467    10.113     0.200
     3.488    10.385     0.200
     3.488    12.572     0.200
     3.488    11.873     0.200
     3.690    14.113     0.200
     4.094    14.297     0.200
     4.400    15.124     0.200
     4.428    15.094     0.200
     4.737    13.591     0.200
     4.900    12.289     0.200
     5.346    13.190     0.200
     5.346    16.093     0.200
     5.346    14.690     0.200
     5.406    17.485     0.200
     5.406    16.684     0.200
     5.748    17.393     0.200
     6.370    15.140     0.200
     6.513    16.672     0.200
     6.695    17.648     0.200
     7.082    18.523     0.200
     7.082    18.933     0.200
     7.082    19.234     0.200
     7.145    23.996     0.200
     7.745    21.795     0.200
     8.636    19.494     0.200
     8.872    19.341     0.200
     9.087    21.225     0.200
     9.794    23.784     0.200
    10.682    26.321     0.200
    10.682    25.618     0.200
    10.908    25.658     0.200
    11.496    25.128     0.200
    11.678    23.788     0.200
    13.115    26.595     0.200
    13.115    25.825     0.200
    13.258    32.260     0.200
    14.545    29.944     0.200
    15.211    34.960     0.200
    16.235    31.983     0.200
    16.235    33.413     0.200
    16.371    33.844     0.200
    16.594    32.286     0.200
    17.033    34.703     0.200
    17.099    33.623     0.200
    17.099    33.834     0.200
    17.142    32.577     0.200
    17.142    36.027     0.200
    17.142    32.226     0.200
    18.394    36.917     0.200
    20.768    35.710     0.200
     2.142    11.214     0.200
     2.580    12.604     0.200
     2.663    14.333     0.200
     2.822    13.919     0.200
     2.822    12.480     0.200
     4.084    16.745     0.200
     6.451    21.648     0.200
     0.975     4.361     0.200
     1.415     6.834     0.200
     1.415     6.659     0.200
     1.460     6.505     0.200
     1.611     6.050     0.200
     2.182     8.380     0.200
     2.667     8.117     0.200
     3.075    10.557     0.200
     3.428     9.838     0.200
     3.705    12.010     0.200
     3.649    10.526     0.200
     3.649    10.956     0.200
     3.649    10.256     0.200
     4.067    12.488     0.200
     4.626    14.463     0.200
     5.314    15.628     0.200
     5.304    12.536     0.200
     5.304    13.146     0.200
     5.304    14.046     0.200
     5.463    17.095     0.200
     5.862    16.930     0.200
     6.164    18.707     0.200
     6.697    17.387     0.200
     7.251    18.466     0.200
     7.251    19.626     0.200
     7.251    18.826     0.200
     7.328    23.428     0.200
     7.823    21.946     0.200
     8.291    22.087     0.200
     8.308    22.391     0.200
     8.308    23.591     0.200
     8.573    18.797     0.200
     9.157    26.182     0.200
     9.268    25.692     0.200
     9.500    20.474     0.200
    10.045    23.308     0.200
    10.045    23.718     0.200
     9.961    23.896     0.200
    10.109    22.435     0.200
    10.109    21.375     0.200
    10.192    24.359     0.200
    10.685    24.637     0.200
    10.849    26.136     0.200
    10.849    25.036     0.200
    11.637    22.841     0.200
    11.704    28.453     0.200
    11.704    30.863     0.200
    13.082    25.942     0.200
    13.082    25.672     0.200
    13.170    30.575     0.200
    13.170    31.514     0.200
    13.254    26.096     0.200
    13.253    26.186     0.200
    13.473    32.417     0.200
    13.462    32.449     0.200
    13.739    31.109     0.200
    14.593    29.966     0.200
    14.741    28.715     0.200
    14.710    28.775     0.200
    16.184    33.997     0.200
    16.184    33.127     0.200
    16.184    34.177     0.200
    16.450    32.493     0.200
    16.599    35.959     0.200
    16.599    36.329     0.200
    16.811    34.867     0.200
    16.811    35.457     0.200
    17.259    36.429     0.200
    17.320    34.609     0.200
    17.320    36.418     0.200
    17.304    33.864     0.200
    17.304    35.804     0.200
    17.304    35.704     0.200
    17.528    34.327     0.200
    18.013    32.190     0.200
    18.013    33.930     0.200
    18.042    35.513     0.200
    18.042    38.393     0.200
    18.042    36.460     0.200
    18.408    37.823     0.200
    19.103    37.916     0.200
     1.013     5.495     0.200
     1.013     5.655     0.200
     1.582     8.046     0.200
     1.582     8.277     0.200
     1.865    10.751     0.200
     1.941     9.940     0.200
     2.171    10.972     0.200
     2.838     9.791     0.200
     2.838     9.970     0.200
     3.064    10.480     0.200
     3.096    12.613     0.200
     3.096    12.383     0.200
     3.127    11.545     0.200
     3.127    11.346     0.200
     3.736    14.312     0.200
     3.736    14.422     0.200
     3.778    13.120     0.200
     4.027    15.654     0.200
     4.299    14.956     0.200
     4.334    13.435     0.200
     4.334    13.615     0.200
     5.098    15.625     0.200
     5.098    15.474     0.200
     5.584    18.164     0.200
     5.657    18.716     0.200
     5.657    18.497     0.200
     5.701    17.761     0.200
     6.680    19.348     0.200
     6.680    18.659     0.200
     6.680    19.649     0.200
     7.710    21.035     0.200
     8.966    22.786     0.200
     8.966    22.505     0.200
    11.983    28.711     0.200
     0.893     4.592     0.200
     1.522     6.355     0.200
     2.768     9.919     0.200
     2.768    10.114     0.200
     3.103    12.399     0.200
     3.341    10.529     0.200
     3.447    13.495     0.200
     3.562    11.402     0.200
     3.562    11.238     0.200
     3.609    13.390     0.200
     3.609    13.499     0.200
     3.609    12.796     0.200
     4.111    14.037     0.200
     4.537    13.567     0.200
     4.829    13.953     0.200
     6.610    17.077     0.200
     7.166    20.605     0.200
     7.166    20.988     0.200
     7.166    20.285     0.200
     7.241    23.310     0.200
     8.205    23.763     0.200
     8.630    22.102     0.200
     9.877    25.549     0.200
    10.198    26.006     0.200
    10.243    23.780     0.200
    10.765    26.094     0.200
    10.765    26.891     0.200
    11.687    26.626     0.200
    12.425    26.623     0.200
    13.130    27.447     0.200
    13.130    29.588     0.200
    16.166    35.501     0.200
    16.166    35.157     0.200
    16.516    33.990     0.200
    17.221    34.258     0.200
    17.221    37.149     0.200
     2.635    12.427     0.200
     2.739    13.210     0.200
     2.876    13.918     0.200
     2.876    13.568     0.200
     3.571    15.007     0.200
     3.571    15.468     0.200
     3.707    15.613     0.200
     3.741    15.120     0.200
     4.257    16.693     0.200
     4.467    17.249     0.200
     4.502    17.640     0.200
     4.767    17.847     0.200
     5.323    18.561     0.200
     5.785    19.272     0.200
     6.508    20.829     0.200
     6.507    21.037     0.200
     1.364     8.438     0.200
     1.678     9.676     0.200
     1.851     9.851     0.200
     2.507    11.003     0.200
     3.085    13.759     0.200
     3.097    13.517     0.200
     3.321    12.303     0.200
     3.358    13.175     0.200
     3.699    15.096     0.200
     3.880    14.974     0.200
     4.012    15.341     0.200
     4.062    14.855     0.200
     4.138    15.261     0.200
     1.176     6.944     0.200
     1.736     7.970     0.200
     1.903     9.626     0.200
     1.856     9.764     0.200
     2.263     9.618     0.200
     2.607    12.308     0.200
     2.812    11.604     0.200
     3.068    13.120     0.200
     3.064    12.266     0.200
     3.152    10.642     0.200
     3.154    12.425     0.200
     3.761    12.435     0.200
     5.297    16.102     0.200
     0.951     7.718     0.200
     1.328     8.309     0.200
     1.697     9.612     0.200
     1.841     9.823     0.200
     1.977    10.634     0.200
     1.983    10.267     0.200
     2.175    11.233     0.200
     2.383    11.399     0.200
     2.790    11.452     0.200
     2.922    12.714     0.200
     2.977    13.070     0.200
     3.626    13.598     0.200
     3.683    14.835     0.200
     4.199    16.809     0.200
     0.869     8.222     0.200
     0.900     8.558     0.200
     1.002     8.676     0.200
     1.229     7.721     0.200
     1.437     8.698     0.200
     1.498     8.782     0.200
     1.932    10.119     0.200
     3.742    13.099     0.200
     1.159     9.118     0.200
     1.288     8.110     0.200
     1.614     9.101     0.200
     1.842     9.648     0.200
     2.042    10.411     0.200
     2.444    11.216     0.200
     2.614    11.534     0.200
     2.978    12.292     0.200
     3.196    12.747     0.200
     3.663    13.695     0.200
     0.777     5.090     0.200
     1.315     7.118     0.200
     1.425     7.287     0.200
     1.425     6.834     0.200
     1.602     8.269     0.200
     1.710     9.301     0.200
     1.802     9.531     0.200
     1.780     8.692     0.200
     1.779     8.698     0.200
     1.835     9.449     0.200
     1.873     9.895     0.200
     1.850     8.545     0.200
     1.850     8.170     0.200
     1.964    10.234     0.200
     1.986     9.091     0.200
     1.986     8.982     0.200
     1.997    10.154     0.200
     2.146     8.563     0.200
     2.146     9.922     0.200
     2.248    10.732     0.200
     2.635    10.317     0.200
     2.649    11.238     0.200
     2.954    12.282     0.200
     2.975    12.145     0.200
     3.081    11.205     0.200
     3.184    13.305     0.200
     3.249    12.344     0.200
     3.365    10.882     0.200
     3.444    10.962     0.200
     3.473    11.230     0.200
     3.473    13.160     0.200
     3.504    13.670     0.200
     3.458    13.354     0.200
     3.458    13.908     0.200
     3.568    14.818     0.200
     3.741    12.599     0.200
     3.936    15.427     0.200
     4.128    13.170     0.200
     4.128    13.787     0.200
     4.217    13.846     0.200
     4.259    15.758     0.200
     4.431    15.857     0.200
     4.505    15.291     0.200
     4.700    16.408     0.200
     5.057    17.745     0.200
     5.173    15.892     0.200
     5.352    15.227     0.200
     5.352    17.399     0.200
     5.382    18.157     0.200
     5.367    20.833     0.200
     5.370    15.658     0.200
     5.370    17.291     0.200
     5.444    14.897     0.200
     5.571    17.349     0.200
     5.592    17.699     0.200
     5.723    16.875     0.200
     5.896    17.844     0.200
     5.938    18.356     0.200
     6.162    19.245     0.200
     6.276    17.517     0.200
     6.373    16.277     0.200
     6.665    19.381     0.200
     6.721    18.694     0.200
     6.758    20.692     0.200
     7.008    18.180     0.200
     7.084    19.085     0.200
     7.084    20.288     0.200
     7.084    20.398     0.200
     7.084    22.491     0.200
     7.151    23.610     0.200
     7.325    22.271     0.200
     7.828    23.402     0.200
     7.918    20.149     0.200
     8.091    20.440     0.200
     8.091    23.635     0.200
     8.118    23.021     0.200
     8.164    23.484     0.200
     8.458    23.863     0.200
     8.865    23.900     0.200
     9.128    26.230     0.200
     9.445    25.035     0.200
     9.420    23.325     0.200
     9.741    25.482     0.200
     9.795    25.847     0.200
    10.263    25.073     0.200
    10.683    25.553     0.200
    11.195    26.365     0.200
    12.979    32.195     0.200
    13.141    25.493     0.200
    13.141    28.915     0.200
    13.283    26.490     0.200
    14.641    31.922     0.200
    15.079    32.986     0.200
    15.079    32.736     0.200
    16.197    33.457     0.200
    16.634    31.296     0.200
    17.142    32.982     0.200
    17.142    34.638     0.200
    17.689    34.795     0.200
    17.996    38.228     0.200
    17.996    40.548     0.200
    20.750    37.156     0.200
     2.545    13.222     0.200
     2.970    12.163     0.200
     1.712     9.717     0.200
     1.732    10.585     0.200
     1.743     9.952     0.200
     1.761    10.445     0.200
     1.804    11.038     0.200
     1.846    10.044     0.200
     1.894    10.394     0.200
     1.957    10.256     0.200
     1.998    11.272     0.200
     2.023    10.278     0.200
     2.027    10.031     0.200
     2.113    11.129     0.200
     2.125    11.296     0.200
     2.139    10.923     0.200
     2.262    10.793     0.200
     2.312    11.610     0.200
     2.393    11.959     0.200
     3.022    12.930     0.200
     3.108    14.219     0.200
     3.112    12.575     0.200
     4.107    15.960     0.200
     5.566    19.129     0.200
     0.905     7.304     0.200
     2.035    10.919     0.200
     1.175     7.243     0.200
     2.404    12.206     0.200
     1.104     8.021     0.200
     1.835    10.195     0.200
     1.969    10.534     0.200
     2.376    10.184     0.200
     2.377    10.972     0.200
     2.396    10.754     0.200
     2.737    11.066     0.200
     3.066    13.123     0.200
     3.230    12.312     0.200
     3.330    13.446     0.200
     3.424    13.351     0.200
     4.093    15.135     0.200
    12.433    31.713     0.200
     1.160     8.801     0.200
     1.239     7.780     0.200
     1.421     9.351     0.200
     1.467     9.915     0.200
     1.503     9.689     0.200
     1.535     9.821     0.200
     1.827    10.111     0.200
     1.834    10.831     0.200
     1.903    10.225     0.200
     1.880    11.693     0.200
     1.942     9.973     0.200
     2.074    11.333     0.200
     2.269    12.452     0.200
     2.281    11.818     0.200
     2.518    11.444     0.200
     2.650    12.511     0.200
     2.740    13.961     0.200
     2.811    12.831     0.200
     2.891    12.792     0.200
     2.943    13.290     0.200
     2.997    13.764     0.200
     3.022    12.972     0.200
     3.188    13.930     0.200
     3.289    13.050     0.200
     3.265    14.636     0.200
     3.598    14.543     0.200
     3.588    14.562     0.200
     4.074    16.287     0.200
     4.155    15.140     0.200
     1.146     9.832     0.200
     1.143     8.271     0.200
     1.830    10.658     0.200
     1.896    10.479     0.200
     1.949    10.267     0.200
     2.654    13.234     0.200
     2.807    12.456     0.200
     2.890    14.586     0.200
     3.584    14.484     0.200
     1.369     8.201     0.200
     1.317     8.203     0.200
     1.361     8.504     0.200
     1.496     9.321     0.200
     1.661    10.004     0.200
     1.830    10.822     0.200
     2.244    12.091     0.200
     2.362    11.712     0.200
     3.281    13.492     0.200
     3.347    13.430     0.200
     3.388    13.248     0.200
     3.651    14.372     0.200
     4.051    15.003     0.200
     1.351     8.828     0.200
     1.487     8.736     0.200
     1.524     8.903     0.200
     2.474    12.423     0.200
     1.172     6.514     0.200
     1.222     8.229     0.200
     1.222     7.725     0.200
     1.512     9.038     0.200
     1.619     9.796     0.200
     1.788     9.727     0.200
     1.819     8.963     0.200
     1.858    10.409     0.200
     1.865     9.822     0.200
     2.308    10.860     0.200
     4.424    17.054     0.200
     4.490    16.593     0.200
     1.155     7.197     0.200
     1.300     7.698     0.200
     1.494     8.740     0.200
     1.903    10.065     0.200
     2.289    11.262     0.200
     1.828    10.504     0.200
     1.912    10.717     0.200
     2.107    11.444     0.200
     2.796    12.999     0.200
     0.863     8.659     0.200
     1.484    10.114     0.200
     1.783    11.423     0.200
     1.899    10.374     0.200
     2.126    12.419     0.200
     2.706    13.208     0.200
     2.760    13.420     0.200
     2.781    13.381     0.200
     2.842    12.913     0.200
     2.842    14.562     0.200
     3.218    14.782     0.200
     3.537    15.848     0.200
     4.030    18.307     0.200
     4.108    16.187     0.200
    16.016    36.358     0.200
    16.542    39.846     0.200
     0.618     4.937     0.200
     0.747     5.432     0.200
     0.792     4.405     0.200
     0.875     5.847     0.200
     0.906     5.787     0.200
     0.952     5.938     0.200
     1.023     6.515     0.200
     1.043     5.980     0.200
     1.004     6.141     0.200
     1.090     6.437     0.200
     1.040     6.420     0.200
     1.127     6.602     0.200
     1.212     7.311     0.200
     1.249     8.472     0.200
     1.247     7.299     0.200
     1.386     8.285     0.200
     1.375     7.705     0.200
     1.332     6.806     0.200
     1.440     8.153     0.200
     1.429     8.075     0.200
     1.515     7.870     0.200
     1.478     7.101     0.200
     1.448     5.960     0.200
     1.536     7.331     0.200
     1.658     8.504     0.200
     1.621     7.633     0.200
     1.767     8.834     0.200
     1.844     9.137     0.200
     1.828     7.725     0.200
     1.889     9.411     0.200
     1.980     9.448     0.200
     1.981     9.539     0.200
     2.006     8.442     0.200
     2.168     7.850     0.200
     2.268     9.591     0.200
     2.352    10.005     0.200
     2.457     9.686     0.200
     2.450     8.759     0.200
     2.670    10.395     0.200
     2.657     9.252     0.200
     2.836    10.264     0.200
     2.997    10.783     0.200
     3.070    11.422     0.200
     3.060    10.546     0.200
     3.101    11.168     0.200
     2.827     8.464     0.200
     3.162    11.053     0.200
     3.146    10.036     0.200
     3.242    10.619     0.200
     3.272    10.266     0.200
     3.364    12.191     0.200
     3.435    12.267     0.200
     3.467    12.790     0.200
     3.470    10.561     0.200
     3.525    10.636     0.200
     3.525    12.515     0.200
     3.547    12.665     0.200
     3.496    10.610     0.200
     3.496    10.450     0.200
     3.566    11.239     0.200
     3.703    13.542     0.200
     3.679    13.220     0.200
     3.773    13.129     0.200
     3.916    13.554     0.200
     3.926    13.139     0.200
     3.894    11.507     0.200
     4.098    13.527     0.200
     4.196    13.488     0.200
     4.152    12.299     0.200
     4.237    14.308     0.200
     4.410    14.993     0.200
     4.387    14.158     0.200
     4.462    14.682     0.200
     4.724    15.630     0.200
     4.733    15.319     0.200
     4.782    15.546     0.200
     4.766    14.238     0.200
     4.810    14.817     0.200
     4.869    16.731     0.200
     4.937    14.843     0.200
     4.937    15.537     0.200
     5.035    16.194     0.200
     5.168    15.643     0.200
     5.113    16.681     0.200
     5.331    16.241     0.200
     5.341    16.119     0.200
     5.347    16.191     0.200
     5.427    14.087     0.200
     5.493    20.445     0.200
     5.594    17.371     0.200
     5.780    18.199     0.200
     5.726    19.734     0.200
     5.986    18.493     0.200
     6.253    18.080     0.200
     6.314    18.269     0.200
     6.543    19.298     0.200
     6.699    18.774     0.200
     7.108    18.976     0.200
     7.108    20.407     0.200
     7.175    23.926     0.200
     7.303    19.625     0.200
     7.448    20.335     0.200
     7.993    21.473     0.200
     8.074    20.626     0.200
     8.171    20.797     0.200
     8.116    22.742     0.200
     8.142    23.038     0.200
     8.140    22.866     0.200
     8.154    22.697     0.200
     8.167    22.648     0.200
     8.188    23.200     0.200
     8.492    21.248     0.200
     8.526    21.355     0.200
     8.482    23.371     0.200
     8.633    17.904     0.200
     8.780    21.695     0.200
     8.897    23.428     0.200
     8.882    21.804     0.200
     9.102    24.432     0.200
     9.114    25.488     0.200
     9.132    22.679     0.200
     9.237    21.461     0.200
     9.396    23.298     0.200
     9.339    24.963     0.200
     9.397    21.994     0.200
     9.424    23.777     0.200
     9.528    22.265     0.200
     9.469    23.949     0.200
     9.765    24.896     0.200
     9.819    24.561     0.200
     9.906    22.548     0.200
    10.113    23.153     0.200
    10.113    23.733     0.200
    10.215    28.042     0.200
    10.131    26.231     0.200
    10.216    24.428     0.200
    10.240    22.654     0.200
    10.335    24.242     0.200
    10.392    23.774     0.200
    10.500    25.214     0.200
    10.684    25.172     0.200
    10.708    24.497     0.200
    10.708    25.497     0.200
    10.868    23.729     0.200
    10.890    25.768     0.200
    10.866    24.849     0.200
    10.866    25.949     0.200
    11.197    25.787     0.200
    11.488    26.492     0.200
    11.680    25.613     0.200
    11.680    25.243     0.200
    11.877    31.454     0.200
    11.782    27.656     0.200
    12.681    32.868     0.200
    12.778    30.533     0.200
    12.948    32.546     0.200
    12.933    32.122     0.200
    13.030    25.494     0.200
    13.000    30.251     0.200
    13.000    31.941     0.200
    13.119    25.798     0.200
    13.119    26.057     0.200
    13.228    32.984     0.200
    13.262    26.983     0.200
    13.262    26.783     0.200
    13.260    33.206     0.200
    13.273    29.561     0.200
    13.298    32.668     0.200
    13.292    32.142     0.200
    13.293    32.620     0.200
    13.262    26.608     0.200
    13.332    31.272     0.200
    13.263    28.670     0.200
    13.362    31.016     0.200
    13.466    28.810     0.200
    13.511    31.877     0.200
    13.539    32.957     0.200
    13.538    30.263     0.200
    13.677    31.540     0.200
    13.650    34.656     0.200
    13.703    28.336     0.200
    13.846    30.777     0.200
    13.863    29.571     0.200
    13.977    28.141     0.200
    13.986    34.035     0.200
    13.995    33.229     0.200
    14.012    34.431     0.200
    14.119    32.290     0.200
    14.135    33.696     0.200
    14.368    34.983     0.200
    14.537    34.806     0.200
    14.605    34.812     0.200
    14.620    29.139     0.200
    14.566    29.365     0.200
    14.589    29.402     0.200
    14.761    32.599     0.200
    14.802    27.514     0.200
    14.834    35.047     0.200
    14.797    35.470     0.200
    14.821    33.492     0.200
    14.884    35.458     0.200
    14.970    35.555     0.200
    14.883    30.467     0.200
    15.064    34.662     0.200
    15.103    33.898     0.200
    15.103    32.197     0.200
    15.274    35.010     0.200
    15.336    35.480     0.200
    15.372    35.363     0.200
    15.568    32.977     0.200
    15.657    35.135     0.200
    15.816    35.882     0.200
    15.852    33.260     0.200
    16.278    32.279     0.200
    16.300    32.737     0.200
    16.416    33.571     0.200
    16.214    33.553     0.200
    16.214    33.292     0.200
    16.214    31.588     0.200
    16.630    35.779     0.200
    16.722    32.413     0.200
    16.969    36.228     0.200
    17.076    35.771     0.200
    17.140    34.009     0.200
    17.167    32.269     0.200
    17.167    33.949     0.200
    17.167    33.419     0.200
    17.451    33.599     0.200
    17.557    35.259     0.200
    17.698    35.820     0.200
    17.981    32.331     0.200
    18.094    33.993     0.200
    18.018    36.269     0.200
     1.277     8.620     0.200
     1.304     8.506     0.200
     1.310     9.832     0.200
     1.362     8.327     0.200
     1.454     7.550     0.200
     1.505     8.662     0.200
     1.583     8.756     0.200
     1.644     9.644     0.200
     1.644     9.440     0.200
     1.658    10.976     0.200
     1.856    10.860     0.200
     1.875     9.145     0.200
     1.894    10.821     0.200
     2.025    10.387     0.200
     2.039    10.928     0.200
     2.176    10.534     0.200
     2.288    11.619     0.200
     2.668    11.589     0.200
     2.769    11.027     0.200
     3.496    12.810     0.200
     3.481    14.504     0.200
     3.541    11.642     0.200
     3.895    15.765     0.200
    10.701    28.205     0.200
     1.133     7.715     0.200
     1.759     9.113     0.200
     2.315    10.720     0.200
     2.390    10.843     0.200
     2.419    11.304     0.200
     2.487    11.809     0.200
     3.084    13.352     0.200
     3.691    14.468     0.200
     1.145     6.783     0.200
     2.324    11.426     0.200
     1.230     9.348     0.200
     1.277     9.195     0.200
     1.312     8.490     0.200
     1.456     9.803     0.200
     1.455    10.425     0.200
     1.507     9.913     0.200
     1.508    10.707     0.200
     1.741     9.686     0.200
     1.739    12.102     0.200
     1.887    12.183     0.200
     2.033    12.573     0.200
     2.242    12.733     0.200
     2.312    12.618     0.200
     2.526    13.020     0.200
     2.850     9.342     0.200
     2.968    11.469     0.200
     3.005    12.828     0.200
     3.201    12.551     0.200
     3.124    16.141     0.200
     3.425    14.531     0.200
     4.007    14.742     0.200
     4.583    19.020     0.200
     1.902    10.139     0.200
     2.442    11.232     0.200
     2.563    10.727     0.200
     2.901    11.677     0.200
     1.478     7.693     0.200
     1.388     8.310     0.200
     1.299     8.938     0.200
     1.299     9.038     0.200
     1.467     9.580     0.200
     2.005    10.802     0.200
     2.352    11.652     0.200
     2.596    13.211     0.200
     2.794    13.000     0.200
     2.660    13.365     0.200
     2.800    13.331     0.200
     2.831    13.163     0.200
     3.073    13.944     0.200
     3.089    12.957     0.200
     3.342    14.096     0.200
     3.253    12.638     0.200
     3.266    14.384     0.200
     3.376    13.808     0.200
     3.376    13.607     0.200
     3.397    13.763     0.200
     3.505    13.794     0.200
     3.586    14.054     0.200
     3.722    16.968     0.200
     3.832    17.184     0.200
     4.015    16.544     0.200
     3.838    15.313     0.200
     3.857    15.087     0.200
     4.465    18.193     0.200
     4.566    15.515     0.200
     4.475    16.674     0.200
     4.477    17.252     0.200
     4.753    16.130     0.200
     4.578    17.380     0.200
     4.902    16.390     0.200
     5.000    16.458     0.200
     5.249    17.448     0.200
     5.675    17.777     0.200
     5.703    19.152     0.200
     5.886    19.613     0.200
     6.074    19.125     0.200
     6.213    19.795     0.200
     6.262    20.131     0.200
     6.450    20.831     0.200
     6.419    20.295     0.200
     6.568    19.859     0.200
     6.520    21.109     0.200
     1.659     9.643     0.200
     2.357    11.106     0.200
     2.521    11.586     0.200
     2.663    12.925     0.200
     2.795    12.700     0.200
     2.834    13.936     0.200
     3.144    13.415     0.200
     3.226    14.856     0.200
     3.258    14.589     0.200
     3.272    14.217     0.200
     3.333    16.312     0.200
     3.378    14.887     0.200
     3.506    14.993     0.200
     3.585    14.471     0.200
     3.644    14.691     0.200
     3.894    16.464     0.200
     4.002    16.911     0.200
     4.481    17.312     0.200
     1.666     9.723     0.200
     1.834    10.163     0.200
     2.007    10.646     0.200
     2.313    10.263     0.200
     2.363    11.684     0.200
     2.780    13.226     0.200
     2.788    12.923     0.200
     2.838    12.340     0.200
     3.128    13.254     0.200
     3.136    13.258     0.200
     3.264    12.970     0.200
     1.129     8.765     0.200
     1.217     9.133     0.200
     1.421     8.657     0.200
     1.364     9.720     0.200
     1.551    10.138     0.200
     1.688    10.235     0.200
     1.817    10.632     0.200
     1.931    11.707     0.200
     2.149    10.864     0.200
     2.140    12.560     0.200
     2.246    12.528     0.200
     2.549    12.394     0.200
     2.545    12.842     0.200
     2.558    12.592     0.200
     2.584    12.482     0.200
     2.636    12.579     0.200
     2.925    12.702     0.200
     2.956    14.647     0.200
     2.956    14.148     0.200
     3.146    13.919     0.200
     3.397    14.367     0.200
     3.397    14.797     0.200
     3.369    14.326     0.200
     3.408    15.071     0.200
     3.440    15.390     0.200
     3.504    15.443     0.200
     3.529    16.250     0.200
     3.521    16.548     0.200
     3.526    14.991     0.200
     3.598    16.246     0.200
     3.598    17.554     0.200
     3.598    13.224     0.200
     3.598    17.045     0.200
     3.598    15.945     0.200
     3.646    15.088     0.200
     3.692    15.558     0.200
     3.689    16.289     0.200
     3.752    14.549     0.200
     3.850    13.514     0.200
     3.847    15.946     0.200
     3.967    16.347     0.200
     4.158    16.319     0.200
     4.183    16.721     0.200
     4.283    16.559     0.200
     4.298    17.687     0.200
     4.407    15.511     0.200
     4.375    16.787     0.200
     4.425    17.497     0.200
     4.410    18.072     0.200
     4.598    16.478     0.200
     4.675    15.683     0.200
     4.736    18.972     0.200
     4.770    17.974     0.200
     4.769    18.879     0.200
     4.797    16.562     0.200
     4.857    16.257     0.200
     4.803    18.984     0.200
     4.803    20.493     0.200
     4.803    18.784     0.200
     4.877    17.030     0.200
     4.858    19.049     0.200
     4.969    19.045     0.200
     4.982    17.802     0.200
     5.169    20.013     0.200
     5.144    20.406     0.200
     5.285    18.859     0.200
     5.421    17.780     0.200
     5.463    24.281     0.200
     5.492    20.043     0.200
     5.508    22.057     0.200
     5.504    20.312     0.200
     5.618    20.678     0.200
     5.713    22.073     0.200
     5.663    20.147     0.200
     5.756    20.364     0.200
     5.902    19.965     0.200
     6.003    20.691     0.200
     6.170    21.931     0.200
     6.278    18.972     0.200
     6.426    21.252     0.200
     6.499    21.698     0.200
     6.567    21.599     0.200
     6.683    22.544     0.200
     6.723    22.881     0.200
     6.761    21.241     0.200
     6.896    20.458     0.200
     6.987    20.995     0.200
     7.203    25.386     0.200
     7.224    20.244     0.200
     7.224    24.535     0.200
     7.224    23.235     0.200
     7.291    25.355     0.200
     7.304    22.500     0.200
     7.360    22.651     0.200
     7.377    23.451     0.200
     7.539    24.356     0.200
     7.611    21.923     0.200
     7.648    25.192     0.200
     7.925    25.451     0.200
     7.990    24.699     0.200
     8.110    22.192     0.200
     8.068    27.682     0.200
     8.146    24.577     0.200
     8.221    24.496     0.200
     8.170    23.689     0.200
     8.189    23.276     0.200
     8.199    24.263     0.200
     8.260    25.544     0.200
     8.256    25.586     0.200
     8.267    25.062     0.200
     8.290    25.590     0.200
     8.509    24.743     0.200
     8.604    24.927     0.200
     8.606    26.806     0.200
     8.841    23.699     0.200
     8.803    25.712     0.200
     8.887    25.128     0.200
     8.872    25.202     0.200
     9.015    27.829     0.200
     9.109    27.332     0.200
     9.259    27.690     0.200
     9.262    26.352     0.200
     9.354    28.279     0.200
     9.402    28.915     0.200
     9.538    28.234     0.200
     9.566    26.102     0.200
     9.560    28.378     0.200
     9.566    26.107     0.200
     9.692    27.134     0.200
     9.723    26.977     0.200
     9.812    27.329     0.200
     9.877    27.277     0.200
     9.886    28.165     0.200
     9.927    28.785     0.200
     9.969    27.703     0.200
    10.023    27.777     0.200
    10.025    27.550     0.200
    10.133    28.586     0.200
    10.174    27.703     0.200
    10.225    27.818     0.200
    10.255    30.358     0.200
    10.701    28.864     0.200
    10.617    27.945     0.200
    10.819    30.377     0.200
    10.814    26.948     0.200
    10.814    30.837     0.200
    10.814    29.638     0.200
    10.997    29.507     0.200
    11.031    28.210     0.200
    11.099    27.612     0.200
    11.207    29.050     0.200
    11.289    30.096     0.200
    11.301    27.748     0.200
    11.301    31.459     0.200
    11.562    30.906     0.200
    11.584    31.054     0.200
    11.681    27.820     0.200
    11.838    31.994     0.200
    11.850    28.351     0.200
    11.876    30.147     0.200
    11.993    30.979     0.200
    12.336    33.282     0.200
    12.343    28.693     0.200
    12.502    34.638     0.200
    12.505    28.410     0.200
    12.505    30.209     0.200
    12.505    28.109     0.200
    12.526    32.257     0.200
    12.548    28.867     0.200
    12.548    30.007     0.200
    12.548    30.706     0.200
    12.566    32.090     0.200
    12.548    31.132     0.200
    12.800    33.667     0.200
    12.784    34.353     0.200
    12.811    35.835     0.200
    12.811    35.974     0.200
    12.811    34.330     0.200
    12.811    33.154     0.200
    12.811    34.035     0.200
    12.777    29.730     0.200
    12.801    35.048     0.200
    12.851    33.971     0.200
    12.854    34.935     0.200
    12.926    34.695     0.200
    12.932    34.118     0.200
    12.913    31.549     0.200
    13.037    33.794     0.200
    13.055    34.590     0.200
    13.010    29.607     0.200
    13.075    34.661     0.200
    13.130    35.108     0.200
    13.113    30.010     0.200
    13.167    31.983     0.200
    13.195    29.257     0.200
    13.270    35.777     0.200
    13.271    31.162     0.200
    13.332    36.058     0.200
    13.350    35.448     0.200
    13.394    34.929     0.200
    13.432    34.984     0.200
    13.500    35.492     0.200
    13.574    35.527     0.200
    13.708    36.162     0.200
    13.699    36.767     0.200
    13.789    35.026     0.200
    13.919    36.700     0.200
    13.928    37.095     0.200
    13.922    32.366     0.200
    13.944    35.018     0.200
    13.957    37.665     0.200
    14.130    38.344     0.200
    14.151    36.396     0.200
    14.146    37.359     0.200
    14.250    36.837     0.200
    14.167    32.513     0.200
    14.350    37.069     0.200
    14.361    36.753     0.200
    14.422    37.530     0.200
    14.495    36.588     0.200
    14.554    37.288     0.200
    14.650    37.980     0.200
    14.671    37.126     0.200
    14.641    34.483     0.200
    14.654    35.427     0.200
    14.757    37.322     0.200
    14.825    36.933     0.200
    14.964    37.306     0.200
    15.047    37.846     0.200
    15.105    37.866     0.200
    15.066    34.721     0.200
    15.168    35.524     0.200
    15.168    36.024     0.200
    15.272    39.118     0.200
    15.299    38.900     0.200
    15.428    34.158     0.200
    15.428    37.389     0.200
    15.413    36.274     0.200
    15.469    39.514     0.200
    15.529    39.910     0.200
    15.609    39.178     0.200
    15.872    39.913     0.200
    15.907    37.501     0.200
    15.907    35.603     0.200
    15.907    38.202     0.200
    15.893    38.868     0.200
    15.995    33.876     0.200
    16.040    36.550     0.200
    16.129    37.909     0.200
    16.162    38.334     0.200
    15.736    43.602     0.200
    16.298    38.340     0.200
    16.355    36.882     0.200
    16.498    40.106     0.200
    16.642    39.730     0.200
    16.598    38.943     0.200
    16.775    38.467     0.200
    16.775    40.178     0.200
    17.014    37.988     0.200
    17.233    39.627     0.200
    17.063    39.220     0.200
    17.063    40.310     0.200
    17.282    40.059     0.200
    17.287    38.984     0.200
    17.287    36.605     0.200
    17.410    39.962     0.200
    17.390    36.094     0.200
    17.451    37.586     0.200
    17.654    40.021     0.200
    17.595    37.601     0.200
    17.583    37.341     0.200
    17.640    37.277     0.200
    17.665    37.688     0.200
    17.794    36.478     0.200
    17.994    37.852     0.200
    18.713    42.257     0.200
    18.713    42.629     0.200
    18.713    42.404     0.200
    19.115    43.484     0.200
    20.338    41.495     0.200
     1.133     8.094     0.200
     1.209     7.805     0.200
     1.825     9.919     0.200
     0.847     6.990     0.200
     1.023     7.436     0.200
     2.561    11.085     0.200
     1.178     7.178     0.200
     2.606    11.918     0.200
     3.097    14.279     0.200
     2.598    12.132     0.200
     1.398     8.589     0.200
     1.898    10.458     0.200
     0.600     5.231     0.200
     0.740     5.605     0.200
     0.860     6.199     0.200
     0.888     6.076     0.200
     0.934     6.136     0.200
     0.959     6.641     0.200
     0.992     6.454     0.200
     1.028     6.637     0.200
     1.097     6.636     0.200
     1.196     7.784     0.200
     1.229     7.797     0.200
     1.229     7.598     0.200
     1.231     8.669     0.200
     1.318     6.760     0.200
     1.360     8.159     0.200
     1.367     8.684     0.200
     1.438     5.655     0.200
     1.411     8.371     0.200
     1.421     8.549     0.200
     1.503     8.000     0.200
     1.530     6.980     0.200
     1.608     7.677     0.200
     1.607     7.782     0.200
     1.608     7.473     0.200
     1.594     9.038     0.200
     1.643     8.862     0.200
     1.822     7.774     0.200
     1.826     9.130     0.200
     1.969     9.363     0.200
     1.994     8.371     0.200
     2.158     7.948     0.200
     2.255     9.426     0.200
     2.338     9.850     0.200
     2.441     9.348     0.200
     2.646     9.161     0.200
     2.658    11.225     0.200
     2.986     9.395     0.200
     3.055    11.986     0.200
     3.088     9.999     0.200
     3.156    12.708     0.200
     3.238    12.445     0.200
     3.458    11.781     0.200
     3.461    12.049     0.200
     3.488    10.619     0.200
     3.488    13.728     0.200
     3.513    12.137     0.200
     3.540    13.721     0.200
     3.558    11.721     0.200
     3.669    12.917     0.200
     3.761    11.940     0.200
     3.907    14.040     0.200
     4.402    15.663     0.200
     4.715    15.215     0.200
     7.101    19.229     0.200
    10.701    26.178     0.200
    16.226    32.797     0.200
    17.161    35.122     0.200
     1.394     8.791     0.200
     1.390     8.597     0.200
     1.785     9.690     0.200
     2.508    12.653     0.200
     2.557    12.679     0.200
     2.612    12.836     0.200
     3.102    14.617     0.200
     0.756     6.592     0.200
     0.951     7.414     0.200
     1.163     8.337     0.200
     1.373     8.392     0.200
     0.745     6.468     0.200
     1.164     8.372     0.200
     1.206     8.773     0.200
     1.390     8.432     0.200
     2.609    13.214     0.200
     1.386     8.272     0.200
     1.537    10.610     0.200
     1.641    10.994     0.200
     1.654    10.248     0.200
     1.795     9.901     0.200
     1.910    11.655     0.200
     2.242    12.786     0.200
     2.566    12.102     0.200
     2.513    12.617     0.200
     2.539    13.317     0.200
     2.613    13.246     0.200
     2.879    13.348     0.200
     2.956    12.849     0.200
     2.927    13.978     0.200
     3.108    13.866     0.200
     3.503    17.459     0.200
     3.483    15.797     0.200
     3.511    14.970     0.200
     3.620    17.000     0.200
     3.586    16.000     0.200
     3.632    15.167     0.200
     3.653    15.708     0.200
     3.713    17.515     0.200
     3.794    14.565     0.200
     3.948    15.872     0.200
     4.109    16.693     0.200
     4.287    16.911     0.200
     4.749    16.317     0.200
     4.744    17.978     0.200
     4.839    18.776     0.200
     4.991    18.595     0.200
     6.645    25.691     0.200
     1.205     8.748     0.200
     1.423     8.491     0.200
     1.575     9.726     0.200
     1.387     8.387     0.200
     1.791     9.868     0.200
     2.563    12.964     0.200
     0.930     8.065     0.200
     1.194     7.875     0.200
     1.808    10.017     0.200
     3.095    14.293     0.200
     3.178    13.533     0.200
     1.190     7.571     0.200
     1.396     8.665     0.200
     0.943     7.991     0.200
     1.166     8.787     0.200
     1.384     8.441     0.200
     1.792     9.978     0.200
     2.615    13.075     0.200
     3.110    14.403     0.200
     3.162    15.489     0.200
     0.921     7.068     0.200
     1.134     8.488     0.200
     2.612    12.635     0.200
     1.405     8.435     0.200
     2.600    11.385     0.200
     3.150    12.569     0.200
     1.214     7.769     0.200
     2.575    13.281     0.200
     3.431    12.887     0.200
     1.176     7.098     0.200
     1.399     8.389     0.200
     0.921     7.733     0.200
     1.401     8.330     0.200
     1.623    10.437     0.200
     1.800     9.074     0.200
     2.497    12.536     0.200
     2.529    12.264     0.200
     2.572    11.861     0.200
     2.600    12.133     0.200
     2.861    12.191     0.200
     2.937    13.599     0.200
     2.913    13.083     0.200
     3.092    14.097     0.200
     3.164    13.053     0.200
     3.508    13.638     0.200
     3.499    14.646     0.200
     3.574    14.070     0.200
     3.624    15.392     0.200
     3.620    14.236     0.200
     3.714    15.842     0.200
     3.774    14.929     0.200
     4.084    15.717     0.200
     4.731    17.068     0.200
     4.826    18.363     0.200
     5.621    21.779     0.200
     6.646    23.017     0.200
     0.599     5.819     0.200
     0.592     5.701     0.200
     0.757     6.375     0.200
     0.809     6.766     0.200
     0.816     6.680     0.200
     0.862     6.845     0.200
     0.929     7.457     0.200
     0.971     7.772     0.200
     0.978     6.887     0.200
     1.002     9.310     0.200
     1.269     7.391     0.200
     1.710     9.453     0.200
     1.490     8.713     0.200
     1.818     9.568     0.200
     3.182    12.946     0.200
     1.116     7.830     0.200
     1.138     7.976     0.200
     1.508     9.457     0.200
     1.893    10.170     0.200
     1.853    10.727     0.200
     1.948     9.636     0.200
     1.948    10.113     0.200
     1.991    10.116     0.200
     2.143    11.245     0.200
     2.183    11.179     0.200
     2.236     9.669     0.200
     2.236    11.356     0.200
     2.248    10.921     0.200
     2.270    11.262     0.200
     2.406    10.982     0.200
     2.509    12.473     0.200
     2.789    13.008     0.200
     2.942    13.224     0.200
     3.350    13.561     0.200
     3.353    13.822     0.200
     3.461    14.371     0.200
     3.529    13.972     0.200
     5.308    18.207     0.200
     5.754    18.113     0.200
     5.818    15.735     0.200
     5.818    18.259     0.200
     9.394    24.292     0.200
     0.902     7.035     0.200
     1.046     7.147     0.200
     1.117     7.130     0.200
     1.501     8.340     0.200
     1.608     8.894     0.200
     2.084    10.748     0.200
     2.331    10.355     0.200
     2.573    12.337     0.200
     2.592    12.218     0.200
     1.285     8.399     0.200
     1.328    10.102     0.200
     1.364     7.878     0.200
     1.511     9.763     0.200
     1.659    10.339     0.200
     1.674    10.453     0.200
     1.834     8.896     0.200
     1.996    10.000     0.200
     2.249    10.452     0.200
     2.369    11.548     0.200
     2.838    11.771     0.200
     3.304    13.240     0.200
     3.289    13.807     0.200
     3.354    12.651     0.200
     3.501    13.132     0.200
     4.059    16.024     0.200
     1.187     8.749     0.200
     1.221     8.755     0.200
     1.384     8.453     0.200
     1.360     8.733     0.200
     1.534     9.705     0.200
     1.548     9.846     0.200
     1.548     9.946     0.200
     1.639    10.377     0.200
     1.782     9.911     0.200
     1.669    10.227     0.200
     2.194    10.702     0.200
     2.106    11.432     0.200
     2.111    11.367     0.200
     2.251    11.743     0.200
     2.545    11.812     0.200
     2.554    12.003     0.200
     2.514    12.164     0.200
     2.547    11.678     0.200
     2.618    12.458     0.200
     2.919    12.944     0.200
     2.877    12.928     0.200
     2.930    12.607     0.200
     3.109    13.727     0.200
     3.353    12.969     0.200
     3.353    13.969     0.200
     3.490    17.178     0.200
     3.368    13.498     0.200
     3.605    14.432     0.200
     3.517    15.064     0.200
     3.520    15.520     0.200
     3.696    13.972     0.200
     3.592    14.783     0.200
     3.592    15.783     0.200
     3.637    14.059     0.200
     3.654    14.664     0.200
     3.817    16.562     0.200
     3.790    14.073     0.200
     3.872    16.327     0.200
     3.953    16.172     0.200
     4.078    15.819     0.200
     4.241    19.107     0.200
     4.295    16.289     0.200
     4.720    16.725     0.200
     4.769    14.904     0.200
     4.769    18.256     0.200
     4.747    18.912     0.200
     4.748    17.195     0.200
     4.843    18.781     0.200
     5.232    20.845     0.200
     5.603    21.416     0.200
     6.628    24.155     0.200
     7.208    21.267     0.200
     9.139    24.967     0.200
    10.792    30.356     0.200
     1.634    10.352     0.200
     1.631    10.395     0.200
     1.978    11.547     0.200
     2.034    12.092     0.200
     2.744    14.101     0.200
     2.907    14.507     0.200
     2.986    14.107     0.200
     2.986    14.877     0.200
     6.616    22.639     0.200
     1.437     7.341     0.200
     1.515     8.122     0.200
     1.636     8.320     0.200
     1.855    10.157     0.200
     1.981     9.387     0.200
     2.046    10.530     0.200
     2.269    11.028     0.200
     2.393    10.587     0.200
     2.387    11.253     0.200
     2.621    11.619     0.200
     2.754    11.065     0.200
     2.764    11.548     0.200
     2.860    11.433     0.200
     3.110    11.408     0.200
     3.099    12.540     0.200
     3.296    12.638     0.200
     1.412     9.613     0.200
     1.499     9.503     0.200
     1.496    10.141     0.200
     1.549     8.727     0.200
     1.549    10.418     0.200
     1.795    11.649     0.200
     1.864    11.238     0.200
     1.866    11.121     0.200
     1.916    10.537     0.200
     2.246    12.081     0.200
     2.273    11.866     0.200
     2.464    13.046     0.200
     2.498    13.642     0.200
     2.576    14.235     0.200
     2.615    12.981     0.200
     2.615    13.680     0.200
     2.619    14.229     0.200
     2.702    13.767     0.200
     2.727    12.798     0.200
     2.727    13.266     0.200
     2.776    13.799     0.200
     2.772    12.549     0.200
     2.795    12.874     0.200
     2.855    13.024     0.200
     2.855    13.555     0.200
     2.909    13.646     0.200
     2.987    15.833     0.200
     2.970    13.936     0.200
     3.004    13.936     0.200
     3.119    12.331     0.200
     3.119    14.593     0.200
     3.150    14.540     0.200
     3.222    13.202     0.200
     3.232    13.875     0.200
     3.320    14.547     0.200
     3.345    16.555     0.200
     3.341    14.511     0.200
     3.474    15.854     0.200
     3.549    15.007     0.200
     3.714    14.849     0.200
     3.946    14.450     0.200
     3.946    15.048     0.200
     4.045    17.087     0.200
     4.048    16.650     0.200
     4.087    19.200     0.200
     4.072    16.180     0.200
     4.122    15.069     0.200
     4.122    16.487     0.200
     4.142    16.261     0.200
     4.191    17.582     0.200
     4.232    17.502     0.200
     4.285    17.288     0.200
     4.285    20.487     0.200
     4.403    20.413     0.200
     4.444    18.833     0.200
     4.497    15.990     0.200
     4.497    17.823     0.200
     4.497    20.022     0.200
     4.755    17.709     0.200
     4.772    18.502     0.200
     4.903    20.274     0.200
     5.039    20.285     0.200
     5.013    19.093     0.200
     5.134    18.486     0.200
     5.159    21.884     0.200
     5.284    19.930     0.200
     5.355    18.102     0.200
     5.355    20.902     0.200
     5.378    19.934     0.200
     5.436    19.756     0.200
     5.487    21.055     0.200
     5.563    19.071     0.200
     5.765    20.115     0.200
     5.855    19.266     0.200
     6.032    21.299     0.200
     6.032    23.698     0.200
     6.391    20.515     0.200
     6.391    22.117     0.200
     6.403    22.569     0.200
     6.488    19.458     0.200
     7.062    27.179     0.200
     7.429    28.396     0.200
     8.615    29.560     0.200
     8.910    24.836     0.200
     9.197    26.531     0.200
    12.500    33.281     0.200
    12.597    32.684     0.200
    13.247    32.392     0.200
    13.247    31.392     0.200
    13.885    35.958     0.200
    14.636    35.244     0.200
    14.857    34.917     0.200
    15.501    38.854     0.200
    16.556    40.083     0.200
    16.556    41.122     0.200
    17.190    40.285     0.200
    20.493    41.519     0.200
    20.493    42.543     0.200
     1.292     7.813     0.200
     1.343     7.824     0.200
     1.555     8.242     0.200
     1.730     9.400     0.200
     1.887    10.066     0.200
     2.067    10.971     0.200
     2.173    11.138     0.200
     2.381    10.203     0.200
     2.433    11.701     0.200
     2.715    11.307     0.200
     3.055    12.335     0.200
     3.258    12.571     0.200
     1.169     7.597     0.200
     1.215     8.560     0.200
     1.385     8.481     0.200
     1.537     9.006     0.200
     1.641     9.690     0.200
     1.790     9.946     0.200
     2.202    10.936     0.200
     2.107    10.652     0.200
     2.245    12.043     0.200
     2.562    12.641     0.200
     2.514    12.698     0.200
     2.542    11.575     0.200
     2.615    12.020     0.200
     2.928    13.968     0.200
     2.879    13.339     0.200
     2.929    13.359     0.200
     3.159    13.768     0.200
     3.109    14.055     0.200
     3.355    13.542     0.200
     3.513    15.138     0.200
     3.588    14.167     0.200
     3.634    13.933     0.200
     3.794    15.464     0.200
     4.100    15.988     0.200
     4.290    16.574     0.200
     1.235     8.029     0.200
     1.284     7.756     0.200
     1.435     9.537     0.200
     1.826    10.281     0.200
     1.139     6.852     0.200
     0.939     7.595     0.200
     0.967     7.869     0.200
     1.872    10.008     0.200
     2.302    11.094     0.200
     0.500     5.347     0.200
     0.509     5.539     0.200
     0.735     6.100     0.200
     0.790     5.764     0.200
     0.865     6.484     0.200
     0.867     5.959     0.200
     0.875     5.965     0.200
     0.882     6.183     0.200
     0.952     6.473     0.200
     0.959     6.390     0.200
     0.986     7.076     0.200
     1.025     7.121     0.200
     1.030     6.855     0.200
     1.064     8.062     0.200
     1.064     6.456     0.200
     1.096     6.583     0.200
     1.139     5.689     0.200
     1.146     7.506     0.200
     1.162     6.319     0.200
     1.174     5.973     0.200
     1.175     6.561     0.200
     1.269     7.172     0.200
     1.280     7.443     0.200
     1.318     7.295     0.200
     1.319     7.589     0.200
     1.337     7.972     0.200
     1.344     6.797     0.200
     1.526     7.972     0.200
     1.533     7.888     0.200
     1.581     7.822     0.200
     1.657     7.844     0.200
     1.678     8.900     0.200
     1.705     7.881     0.200
     1.705     7.983     0.200
     1.880     7.545     0.200
     1.964     7.560     0.200
     2.049     8.766     0.200
     2.166     8.904     0.200
     2.362     8.918     0.200
     2.369     8.730     0.200
     2.549    10.527     0.200
     2.799     9.916     0.200
     2.952    11.133     0.200
     2.943    10.029     0.200
     3.063    10.728     0.200
     3.115    10.821     0.200
     3.181    11.451     0.200
     3.187    11.291     0.200
     3.219    10.314     0.200
     3.226    11.133     0.200
     3.286    11.231     0.200
     3.283    12.567     0.200
     3.391    12.306     0.200
     3.493    12.016     0.200
     3.614    12.200     0.200
     3.753    11.777     0.200
     3.883    11.959     0.200
     3.994    13.571     0.200
     4.442    14.138     0.200
     4.491    13.472     0.200
     4.508    13.968     0.200
     5.071    14.497     0.200
     5.530    15.046     0.200
     0.667     4.925     0.200
     0.815     4.567     0.200
     0.815     3.827     0.200
     0.794     6.042     0.200
     0.955     5.864     0.200
     0.927     6.291     0.200
     0.993     5.925     0.200
     1.026     6.745     0.200
     1.089     6.006     0.200
     1.075     6.664     0.200
     1.055     6.223     0.200
     1.055     6.604     0.200
     1.139     6.626     0.200
     1.151     6.684     0.200
     1.091     6.981     0.200
     1.179     5.749     0.200
     1.264     7.581     0.200
     1.288     7.484     0.200
     1.288     7.283     0.200
     1.295     8.404     0.200
     1.348     7.085     0.200
     1.428     7.848     0.200
     1.428     8.037     0.200
     1.467     7.896     0.200
     1.487     8.165     0.200
     1.444     6.568     0.200
     1.630     7.791     0.200
     1.630     7.785     0.200
     1.579     7.781     0.200
     1.711     8.747     0.200
     1.664     8.090     0.200
     1.751     9.172     0.200
     1.820     9.246     0.200
     1.820     8.877     0.200
     1.878     8.799     0.200
     1.872     8.372     0.200
     1.974     8.778     0.200
     1.999     9.385     0.200
     2.012     8.638     0.200
     2.165     8.652     0.200
     2.363     9.932     0.200
     2.444     9.488     0.200
     2.656     9.415     0.200
     2.675    10.692     0.200
     2.881    11.086     0.200
     3.108    11.444     0.200
     3.119    12.107     0.200
     3.102    11.717     0.200
     3.207    11.892     0.200
     3.253    12.652     0.200
     3.232    11.200     0.200
     3.264    10.788     0.200
     3.264    11.019     0.200
     3.378    10.288     0.200
     3.463    11.104     0.200
     3.529    12.995     0.200
     3.557    11.597     0.200
     3.591    13.404     0.200
     3.674    13.035     0.200
     3.773    12.684     0.200
     3.753    12.312     0.200
     3.886    12.587     0.200
     3.886    12.167     0.200
     3.964    14.903     0.200
     3.977    14.799     0.200
     4.062    12.811     0.200
     4.142    15.579     0.200
     4.205    13.338     0.200
     4.139    12.972     0.200
     4.139    12.812     0.200
     4.281    14.455     0.200
     4.429    14.927     0.200
     4.456    15.622     0.200
     4.715    16.087     0.200
     4.755    13.865     0.200
     4.755    14.125     0.200
     4.909    15.722     0.200
     5.080    16.830     0.200
     5.389    17.385     0.200
     5.389    13.504     0.200
     5.366    16.891     0.200
     5.918    17.855     0.200
     5.953    17.644     0.200
     6.384    18.309     0.200
     6.534    18.057     0.200
     6.528    17.935     0.200
     6.681    18.645     0.200
     7.094    19.949     0.200
     7.094    18.179     0.200
     7.094    19.529     0.200
     7.094    17.829     0.200
     7.165    20.192     0.200
     7.289    18.753     0.200
     7.284    20.707     0.200
     7.546    21.656     0.200
     7.615    20.341     0.200
     7.823    22.624     0.200
     8.100    23.816     0.200
     8.928    22.561     0.200
    10.693    26.568     0.200
    10.693    25.148     0.200
    10.693    25.328     0.200
    10.854    27.277     0.200
    13.162    29.684     0.200
    13.162    28.315     0.200
    13.293    33.600     0.200
    13.309    26.873     0.200
    14.553    30.972     0.200
    15.090    32.199     0.200
    15.090    33.209     0.200
    16.436    34.470     0.200
    16.436    32.710     0.200
    16.163    34.916     0.200
    17.150    34.680     0.200
    17.150    35.469     0.200
    17.972    36.495     0.200
     0.938     7.357     0.200
     1.213     7.750     0.200
     1.361     8.328     0.200
     1.387     8.623     0.200
     1.657     9.869     0.200
     1.792     9.393     0.200
     2.204    10.884     0.200
     2.564    11.689     0.200
     3.161    12.822     0.200
     3.394    12.802     0.200
     1.649     9.193     0.200
     2.011    10.472     0.200
     2.052    10.589     0.200
     1.214     8.634     0.200
     1.366     9.058     0.200
     1.393     9.239     0.200
     1.379     9.305     0.200
     1.621    10.286     0.200
     1.639    10.369     0.200
     1.673    10.579     0.200
     1.730    10.516     0.200
     1.938    11.186     0.200
     1.990    10.671     0.200
     2.074    11.391     0.200
     2.407    13.704     0.200
     2.445    13.265     0.200
     2.480    12.551     0.200
     2.644    12.949     0.200
     2.762    13.065     0.200
     2.913    13.306     0.200
     2.946    13.319     0.200
     3.001    13.682     0.200
     3.057    13.422     0.200
     3.126    14.014     0.200
     3.169    13.911     0.200
     3.292    14.585     0.200
     3.690    14.835     0.200
     4.234    16.289     0.200
     4.310    15.907     0.200
     4.271    17.460     0.200
     1.444     7.443     0.200
     1.511     8.163     0.200
     1.837     9.564     0.200
     1.283     7.752     0.200
     1.296     8.204     0.200
     1.829     9.480     0.200
     3.732    14.781     0.200
     1.201     7.696     0.200
     2.581    11.791     0.200
     3.074    12.748     0.200
     3.483    13.968     0.200
     4.088    13.905     0.200
     0.743     7.090     0.200
     0.806     6.559     0.200
     0.923     7.898     0.200
     1.426     8.416     0.200
     1.928    10.362     0.200
     3.475    13.207     0.200
     0.840     6.926     0.200
     0.832     7.920     0.200
     0.870     7.068     0.200
     0.940     8.555     0.200
     0.957     7.461     0.200
     1.033     8.670     0.200
     1.034     9.258     0.200
     1.136     8.368     0.200
     1.189     9.350     0.200
     1.203     8.380     0.200
     1.791    10.525     0.200
     1.898    10.378     0.200
     2.435    12.605     0.200
     2.767    12.625     0.200
     2.783    14.040     0.200
     1.223     7.626     0.200
     1.774     8.990     0.200
     1.828    10.163     0.200
     1.864    10.447     0.200
     1.874    10.021     0.200
     1.885    10.090     0.200
     2.029    11.120     0.200
     2.084     9.576     0.200
     2.214    11.262     0.200
     2.311    11.430     0.200
     1.133     7.903     0.200
     1.111     8.461     0.200
     1.189     7.954     0.200
     1.256     7.473     0.200
     1.256     7.673     0.200
     1.299     9.174     0.200
     1.339     8.795     0.200
     1.390     8.806     0.200
     1.523     9.157     0.200
     1.571     9.498     0.200
     1.556     9.375     0.200
     1.556     9.762     0.200
     1.558     9.645     0.200
     1.668     9.761     0.200
     1.676    10.769     0.200
     1.727    10.479     0.200
     1.711    10.455     0.200
     1.740     9.925     0.200
     1.751    10.789     0.200
     1.803    10.683     0.200
     1.838    10.279     0.200
     1.843    10.919     0.200
     1.848    10.660     0.200
     1.916    10.473     0.200
     1.977    10.857     0.200
     2.060    11.387     0.200
     2.051    10.197     0.200
     2.112    11.185     0.200
     2.141    11.439     0.200
     2.145    11.102     0.200
     2.180    10.481     0.200
     2.306    11.921     0.200
     2.315    11.507     0.200
     2.343    11.185     0.200
     2.575    12.874     0.200
     2.836    12.636     0.200
     2.917    12.585     0.200
     2.927    12.170     0.200
     2.929    13.247     0.200
     2.969    12.380     0.200
     3.031    12.752     0.200
     3.203    13.444     0.200
     3.552    14.176     0.200
     3.585    13.695     0.200
     3.770    14.029     0.200
     3.961    14.808     0.200
     4.322    13.985     0.200
     4.526    16.313     0.200
     4.549    13.700     0.200
     4.587    16.603     0.200
     4.665    16.288     0.200
     4.784    16.796     0.200
     5.054    16.248     0.200
     5.392    17.636     0.200
     5.392    18.906     0.200
     5.798    17.471     0.200
     8.970    25.550     0.200
     8.973    25.116     0.200
     9.655    27.757     0.200
     9.714    28.462     0.200
     9.740    27.861     0.200
    10.197    26.795     0.200
    17.445    38.322     0.200
     1.133     8.049     0.200
     1.125     6.639     0.200
     1.166     8.158     0.200
     1.322     8.538     0.200
     1.552     9.460     0.200
     1.581     8.858     0.200
     1.696     9.369     0.200
     1.768     9.631     0.200
     1.857     9.994     0.200
     1.866     9.789     0.200
     2.076     9.347     0.200
     2.130    11.014     0.200
     2.165    10.810     0.200
     2.196    10.736     0.200
     2.205    10.333     0.200
     2.860    11.792     0.200
     2.940    11.451     0.200
     2.949    13.159     0.200
     2.950    13.336     0.200
     2.993    12.036     0.200
     3.052    12.650     0.200
     3.181    13.445     0.200
     3.609    13.252     0.200
     3.793    13.609     0.200
     4.527    13.825     0.200
     4.527    16.036     0.200
     4.611    15.858     0.200
     4.686    18.081     0.200
     5.078    15.610     0.200
     5.413    18.543     0.200
     6.488    16.227     0.200
     8.995    24.714     0.200
    11.045    27.602     0.200
    19.645    39.481     0.200
     1.145     6.761     0.200
     1.747     9.733     0.200
     1.873     9.969     0.200
     2.096    10.264     0.200
     3.069    12.706     0.200
     3.163    13.715     0.200
     1.122     6.486     0.200
     1.343     7.708     0.200
     1.351     8.119     0.200
     1.638     9.071     0.200
     1.816     9.886     0.200
     2.815    11.727     0.200
     1.307     8.535     0.200
     1.367     8.740     0.200
     1.371     8.896     0.200
     1.440     8.687     0.200
     1.482     9.403     0.200
     1.471     9.124     0.200
     1.492     9.081     0.200
     1.672     9.587     0.200
     1.767     9.571     0.200
     1.794    10.359     0.200
     1.860    11.190     0.200
     1.928    11.198     0.200
     2.028    11.321     0.200
     2.095    11.041     0.200
     2.230    11.570     0.200
     2.263    11.287     0.200
     2.505    11.563     0.200
     2.537    12.184     0.200
     2.662    12.031     0.200
     2.696    13.133     0.200
     2.722    12.830     0.200
     2.782    13.421     0.200
     2.807    12.833     0.200
     2.821    12.573     0.200
     2.945    12.429     0.200
     3.488    14.889     0.200
     3.913    16.332     0.200
     4.017    16.411     0.200
     4.200    13.864     0.200
     6.377    19.073     0.200
     9.954    26.255     0.200
     1.242     8.524     0.200
     1.273     8.269     0.200
     1.255     8.463     0.200
     1.315     8.364     0.200
     1.448     8.852     0.200
     1.448     8.113     0.200
     1.469     9.172     0.200
     1.497     8.740     0.200
     1.473     9.626     0.200
     1.667     9.555     0.200
     1.759     9.686     0.200
     1.788     9.950     0.200
     1.864    10.463     0.200
     2.022    10.413     0.200
     2.026    10.170     0.200
     2.090    11.422     0.200
     2.233    10.648     0.200
     2.259    11.348     0.200
     2.502    11.426     0.200
     2.530    12.240     0.200
     2.530    12.681     0.200
     2.656    12.318     0.200
     2.690    12.221     0.200
     2.714    12.732     0.200
     2.776    13.420     0.200
     2.814    12.866     0.200
     2.944    11.961     0.200
     2.984    13.190     0.200
     3.847    13.851     0.200
     6.372    20.072     0.200
     9.950    27.647     0.200
     9.950    27.377     0.200
    11.905    35.026     0.200
    11.905    30.155     0.200
    13.076    29.828     0.200
    13.139    28.982     0.200
    15.080    37.841     0.200
    15.080    36.333     0.200
     1.297     8.148     0.200
     1.429     6.854     0.200
     1.429     8.604     0.200
     1.485     8.954     0.200
     1.678     9.701     0.200
     1.779     9.322     0.200
     1.803     9.944     0.200
     2.032    10.265     0.200
     2.103    10.443     0.200
     2.225    11.112     0.200
     2.268    11.312     0.200
     2.509    11.622     0.200
     2.509    11.403     0.200
     2.547    12.412     0.200
     2.670    11.922     0.200
     2.705    12.519     0.200
     2.732    12.299     0.200
     2.792    12.998     0.200
     2.830    12.556     0.200
     2.946    12.096     0.200
     2.968    12.147     0.200
     3.138    14.354     0.200
     3.498    13.963     0.200
     3.826    14.286     0.200
     3.920    15.037     0.200
     4.214    13.338     0.200
     5.521    15.341     0.200
     6.384    21.646     0.200
     6.384    21.314     0.200
     9.961    28.915     0.200
    13.116    31.002     0.200
    14.683    34.184     0.200
    15.067    36.804     0.200
    16.237    36.609     0.200
     1.328     8.243     0.200
     1.394     8.345     0.200
     1.695     9.246     0.200
     1.990    10.048     0.200
     2.531    11.689     0.200
     1.624     8.856     0.200
     1.782     9.280     0.200
     2.091    10.300     0.200
     2.100    10.319     0.200
     2.194    10.589     0.200
     2.247    10.756     0.200
     2.502    11.472     0.200
     2.550    11.022     0.200
     2.608    11.385     0.200
     2.861    12.103     0.200
     2.918    11.991     0.200
     2.919    12.026     0.200
     3.138    12.542     0.200
     3.387    12.762     0.200
     3.508    13.446     0.200
     3.515    13.281     0.200
     3.603    13.093     0.200
     3.585    13.636     0.200
     3.597    13.552     0.200
     3.630    13.618     0.200
     4.736    15.692     0.200
     0.512     6.141     0.200
     0.518     4.997     0.200
     0.678     5.653     0.200
     0.768     6.160     0.200
     0.780     6.578     0.200
     0.817     6.392     0.200
     0.779     5.285     0.200
     0.856     5.753     0.200
     0.918     6.411     0.200
     0.969     5.941     0.200
     0.907     5.514     0.200
     1.039     6.779     0.200
     0.853     4.768     0.200
     0.853     4.589     0.200
     0.853     4.979     0.200
     1.181     7.126     0.200
     1.097     5.923     0.200
     1.299     7.387     0.200
     1.301     7.502     0.200
     1.382     7.695     0.200
     1.333     7.207     0.200
     1.316     7.268     0.200
     1.467     8.141     0.200
     1.392     7.461     0.200
     1.568     8.199     0.200
     1.592     8.167     0.200
     1.413     7.513     0.200
     1.531     8.113     0.200
     1.754     9.205     0.200
     1.614     7.988     0.200
     1.569     7.445     0.200
     1.733     8.774     0.200
     1.599     6.913     0.200
     1.825     8.112     0.200
     1.724     8.496     0.200
     1.847     8.698     0.200
     1.996     9.452     0.200
     2.222    10.002     0.200
     2.117     8.984     0.200
     2.600    10.590     0.200
     2.314     9.390     0.200
     2.440     9.860     0.200
     2.826    11.321     0.200
     2.926    11.427     0.200
     2.780    10.858     0.200
     2.788     9.933     0.200
     3.311    12.877     0.200
     2.921     9.992     0.200
     2.921    10.179     0.200
     3.127    11.593     0.200
     3.203    11.156     0.200
     3.305    11.472     0.200
     3.370    12.537     0.200
     3.682    14.213     0.200
     3.697    14.186     0.200
     3.429    10.512     0.200
     3.429    12.090     0.200
     3.556    12.012     0.200
     3.641    10.704     0.200
     3.641    11.970     0.200
     3.617    12.583     0.200
     3.623    12.840     0.200
     3.658    12.279     0.200
     4.001    14.029     0.200
     3.724    12.734     0.200
     3.824    12.614     0.200
     3.900    13.130     0.200
     4.174    15.078     0.200
     3.933    12.924     0.200
     4.052    14.107     0.200
     4.157    14.575     0.200
     4.324    13.512     0.200
     4.631    15.202     0.200
     4.799    15.320     0.200
     5.017    14.572     0.200
     5.113    16.193     0.200
     5.113    15.928     0.200
     4.887    15.924     0.200
     4.949    14.951     0.200
     4.930    15.431     0.200
     5.036    14.922     0.200
     5.466    13.154     0.200
     5.639    17.138     0.200
     5.748    16.964     0.200
     5.792    17.108     0.200
     6.250    17.756     0.200
     6.751    17.986     0.200
     6.567    18.592     0.200
     7.068    20.300     0.200
     6.848    19.239     0.200
     6.861    19.360     0.200
     7.176    17.980     0.200
     7.281    18.960     0.200
     7.281    20.538     0.200
     7.281    19.562     0.200
    10.882    26.881     0.200
    10.882    26.272     0.200
    12.884    25.537     0.200
    17.346    35.296     0.200
     1.143     5.235     0.200
     2.803     8.096     0.200
     3.937    13.545     0.200
     4.904    15.204     0.200
     5.108    17.273     0.200
     7.575    21.778     0.200
    10.519    28.805     0.200
    12.683    27.243     0.200
    12.683    26.720     0.200
    12.861    25.217     0.200
    12.861    25.416     0.200
    12.861    27.795     0.200
    13.414    29.988     0.200
    13.414    31.234     0.200
    15.568    34.752     0.200
    16.551    34.373     0.200
     2.930    10.917     0.200
     5.281    15.514     0.200
     5.492    16.448     0.200
     6.645    18.660     0.200
     9.908    26.481     0.200
    10.244    28.113     0.200
    10.244    25.933     0.200
    12.404    31.387     0.200
    12.404    33.047     0.200
    12.404    30.230     0.200
    12.404    29.997     0.200
    13.207    29.285     0.200
    13.207    30.285     0.200
    13.251    31.419     0.200
    13.251    31.629     0.200
    14.621    32.839     0.200
    15.742    38.145     0.200
    16.092    33.765     0.200
    16.092    33.275     0.200
    16.492    35.717     0.200
    16.714    37.805     0.200
    18.011    39.014     0.200
     3.464    13.962     0.200
     5.281    16.808     0.200
     5.492    19.529     0.200
     6.645    18.183     0.200
     6.645    19.300     0.200
     9.908    25.885     0.200
    10.244    28.822     0.200
    13.207    29.413     0.200
    13.207    32.216     0.200
    13.251    31.135     0.200
    15.742    35.946     0.200
    16.492    37.973     0.200
    18.011    38.634     0.200
    19.173    40.396     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.529    17.685     0.200
     2.787    18.881     0.200
     4.109    28.795     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.179     2.366     0.200
     1.045     6.039     0.200
     0.892     5.853     0.200
     2.586    14.074     0.200
     0.417     2.742     0.200
     0.417     2.967     0.200
     0.634     4.906     0.200
     0.881     6.032     0.200
     0.972     6.765     0.200
     0.466     4.187     0.200
     0.639     5.560     0.200
     1.060     7.667     0.200
     1.060     7.142     0.200
     1.226     7.709     0.200
     1.226     8.020     0.200
     1.478     9.361     0.200
     1.478     9.572     0.200
     1.404     8.730     0.200
     1.404     8.989     0.200
     1.865    10.950     0.200
     2.171    11.654     0.200
     0.715     5.669     0.200
     1.055     7.309     0.200
     1.352     7.841     0.200
     1.448     8.918     0.200
     0.178     2.458     0.200
     0.464     2.937     0.200
     0.464     2.661     0.200
     0.557     4.378     0.200
     0.557     4.657     0.200
     1.160     8.838     0.200
     1.231     8.307     0.200
     1.936    11.781     0.200
     2.093    12.448     0.200
     0.561     4.607     0.200
     0.622     4.396     0.200
     0.746     5.748     0.200
     0.913     6.207     0.200
     0.913     6.106     0.200
     0.225     2.396     0.200
     0.600     6.331     0.200
     1.063     8.013     0.200
     1.658     9.778     0.200
     0.069     1.609     0.200
     0.180     2.009     0.200
     0.227     2.464     0.200
     0.239     2.628     0.200
     0.351     3.318     0.200
     0.356     4.657     0.200
     0.398     2.774     0.200
     0.424     2.866     0.200
     0.470     3.620     0.200
     0.510     4.763     0.200
     0.596     4.459     0.200
     0.654     4.877     0.200
     0.738     5.993     0.200
     0.761     5.827     0.200
     0.806     7.103     0.200
     0.855     6.134     0.200
     0.856     6.726     0.200
     0.920     7.078     0.200
     1.009     7.038     0.200
     1.044     7.426     0.200
     1.061     7.934     0.200
     1.112     7.433     0.200
     1.106     7.697     0.200
     1.273     8.648     0.200
     1.276     8.723     0.200
     1.287     8.586     0.200
     1.309     8.436     0.200
     1.421     8.930     0.200
     1.427     9.058     0.200
     1.459     9.584     0.200
     1.741    10.796     0.200
     0.211     2.201     0.200
     0.432     3.425     0.200
     0.465     3.542     0.200
     0.501     4.214     0.200
     0.563     4.297     0.200
     0.532     3.758     0.200
     0.589     4.888     0.200
     0.656     5.812     0.200
     0.770     5.482     0.200
     0.813     6.880     0.200
     0.838     6.885     0.200
     0.907     6.676     0.200
     1.156     7.673     0.200
     1.166     7.754     0.200
     1.168     8.134     0.200
     1.873    12.211     0.200
     0.084     1.858     0.200
     0.194     1.784     0.200
     0.202     2.184     0.200
     0.236     2.285     0.200
     0.242     2.722     0.200
     0.308     2.648     0.200
     0.391     1.572     0.200
     0.445     4.047     0.200
     0.428     4.048     0.200
     0.468     3.877     0.200
     0.471     3.640     0.200
     0.493     4.295     0.200
     0.609     4.829     0.200
     0.613     4.789     0.200
     0.671     4.115     0.200
     0.668     5.042     0.200
     0.745     5.651     0.200
     0.803     5.571     0.200
     0.818     6.294     0.200
     0.864     6.660     0.200
     0.986     7.136     0.200
     1.083     7.498     0.200
     1.848    12.675     0.200
     0.621     5.609     0.200
     0.768     5.690     0.200
     0.948     6.403     0.200
     0.987     7.044     0.200
     1.043     6.396     0.200
     1.032     7.218     0.200
     1.021     7.163     0.200
     1.093     6.906     0.200
     1.057     7.229     0.200
     1.242     8.861     0.200
     1.242     7.369     0.200
     1.242     7.759     0.200
     1.221     7.877     0.200
     1.248     8.689     0.200
     1.387     8.171     0.200
     1.422     8.262     0.200
     1.440     8.551     0.200
     1.534     9.164     0.200
     1.531     8.394     0.200
     1.600     9.583     0.200
     1.558     9.177     0.200
     1.669     9.277     0.200
     0.203     2.349     0.200
     0.264     2.440     0.200
     0.334     2.028     0.200
     0.380     2.192     0.200
     0.361     3.506     0.200
     0.409     3.247     0.200
     0.527     3.777     0.200
     0.621     4.170     0.200
     0.650     5.437     0.200
     0.744     6.444     0.200
     0.731     5.294     0.200
     0.848     7.032     0.200
     0.865     5.827     0.200
     0.913     7.473     0.200
     1.146     7.355     0.200
     1.152     8.876     0.200
     1.210     8.298     0.200
     1.302     9.633     0.200
     1.346     9.014     0.200
     1.480    10.151     0.200
     1.601     9.634     0.200
     1.683    11.281     0.200
     1.694    11.148     0.200
     1.785    11.189     0.200
     1.839    11.557     0.200
     2.098    13.243     0.200
     2.272    14.010     0.200
     0.277     2.856     0.200
     0.310     2.075     0.200
     0.358     2.813     0.200
     0.420     3.392     0.200
     0.485     3.435     0.200
     0.483     3.353     0.200
     0.486     4.519     0.200
     0.602     4.670     0.200
     0.705     5.169     0.200
     0.815     6.680     0.200
     0.872     6.312     0.200
     0.943     6.183     0.200
     0.976     6.197     0.200
     0.986     7.582     0.200
     1.044     6.403     0.200
     1.121     8.013     0.200
     1.189     8.514     0.200
     1.294     8.990     0.200
     1.311     9.198     0.200
     1.310     8.304     0.200
     1.340     8.750     0.200
     1.425     8.866     0.200
     0.149     1.926     0.200
     0.220     1.291     0.200
     0.296     2.204     0.200
     0.348     3.201     0.200
     0.444     4.079     0.200
     0.470     4.176     0.200
     0.543     4.727     0.200
     0.633     4.679     0.200
     0.630     4.707     0.200
     0.733     4.906     0.200
     0.767     5.316     0.200
     0.752     5.883     0.200
     0.772     5.460     0.200
     1.038     7.554     0.200
     1.042     6.800     0.200
     1.018     7.182     0.200
     1.312     8.557     0.200
     1.481     9.878     0.200
     1.459     9.743     0.200
     1.550     9.276     0.200
     1.594    10.259     0.200
     1.674    10.127     0.200
     1.726    10.619     0.200
     1.774    11.059     0.200
     1.803    11.125     0.200
     2.069    12.621     0.200
     2.211    14.165     0.200
     0.157     2.033     0.200
     0.184     1.813     0.200
     0.267     2.141     0.200
     0.282     1.965     0.200
     0.391     3.094     0.200
     0.437     3.562     0.200
     0.489     5.149     0.200
     0.506     3.551     0.200
     0.527     4.110     0.200
     0.536     4.701     0.200
     0.560     4.324     0.200
     0.642     5.667     0.200
     0.676     4.675     0.200
     0.685     5.465     0.200
     0.702     5.265     0.200
     0.712     5.047     0.200
     0.735     6.281     0.200
     0.782     5.836     0.200
     0.974     7.993     0.200
     1.021     6.748     0.200
     1.026     7.088     0.200
     1.267     9.374     0.200
     1.701    10.514     0.200
     0.028     1.176     0.200
     0.200     3.373     0.200
     0.248     3.109     0.200
     0.341     3.331     0.200
     0.383     4.038     0.200
     0.480     3.904     0.200
     0.453     4.426     0.200
     0.530     4.115     0.200
     0.546     4.241     0.200
     0.543     4.877     0.200
     0.640     5.332     0.200
     0.641     5.127     0.200
     0.700     4.740     0.200
     0.777     5.742     0.200
     0.789     5.801     0.200
     0.788     5.515     0.200
     0.801     5.862     0.200
     0.920     6.563     0.200
     0.938     6.766     0.200
     0.948     6.737     0.200
     0.944     6.786     0.200
     1.068     7.649     0.200
     1.165     7.815     0.200
     1.226     8.094     0.200
     1.239     8.445     0.200
     1.365     9.278     0.200
     1.391     9.381     0.200
     1.614    10.076     0.200
     1.691     9.972     0.200
     1.714     9.905     0.200
     0.227     2.089     0.200
     0.257     2.039     0.200
     0.414     3.031     0.200
     0.414     3.406     0.200
     0.447     3.015     0.200
     0.517     3.998     0.200
     0.512     3.761     0.200
     0.547     5.451     0.200
     0.557     4.436     0.200
     0.571     4.667     0.200
     0.584     4.213     0.200
     0.589     4.360     0.200
     0.604     4.982     0.200
     0.649     4.763     0.200
     0.751     5.069     0.200
     0.798     6.521     0.200
     0.848     6.532     0.200
     0.867     6.313     0.200
     0.896     7.578     0.200
     0.891     6.542     0.200
     0.918     7.217     0.200
     0.931     5.474     0.200
     0.963     7.395     0.200
     0.989     8.289     0.200
     1.075     8.292     0.200
     1.145     8.274     0.200
     1.151     7.797     0.200
     1.160     7.901     0.200
     0.162     3.021     0.200
     0.289     1.940     0.200
     0.475     3.371     0.200
     0.519     3.754     0.200
     0.582     3.320     0.200
     0.539     4.520     0.200
     0.600     4.915     0.200
     0.633     5.825     0.200
     0.650     4.629     0.200
     0.638     5.468     0.200
     0.806     4.901     0.200
     0.855     7.039     0.200
     0.912     7.469     0.200
     0.951     6.815     0.200
     0.946     6.766     0.200
     0.906     5.637     0.200
     0.995     7.695     0.200
     1.180     8.045     0.200
     1.248     8.443     0.200
     1.444     9.455     0.200
     1.527    10.089     0.200
     1.531     9.949     0.200
     2.952    15.766     0.200
     0.085     1.591     0.200
     0.170     1.897     0.200
     0.217     1.348     0.200
     0.188     2.188     0.200
     0.270     2.838     0.200
     0.270     3.487     0.200
     0.350     2.997     0.200
     0.362     3.155     0.200
     0.424     2.933     0.200
     0.420     3.278     0.200
     0.634     4.984     0.200
     0.608     4.683     0.200
     0.637     4.951     0.200
     0.646     5.144     0.200
     0.672     5.044     0.200
     0.770     5.098     0.200
     0.770     6.002     0.200
     0.772     6.170     0.200
     0.836     6.230     0.200
     0.840     6.280     0.200
     0.857     5.784     0.200
     0.920     6.142     0.200
     1.017     7.011     0.200
     1.008     7.518     0.200
     1.074     8.043     0.200
     1.224     7.998     0.200
     2.005    11.387     0.200
     0.057     1.027     0.200
     0.140     1.259     0.200
     0.178     1.518     0.200
     0.238     1.517     0.200
     0.309     2.587     0.200
     0.332     2.820     0.200
     0.350     3.806     0.200
     0.373     3.040     0.200
     0.456     3.575     0.200
     0.457     5.364     0.200
     0.503     3.528     0.200
     0.604     4.147     0.200
     0.623     4.819     0.200
     0.667     4.913     0.200
     0.744     5.407     0.200
     0.863     5.619     0.200
     0.854     6.328     0.200
     1.106     8.386     0.200
     1.260     8.684     0.200
     1.395    10.209     0.200
     1.959    11.431     0.200
     0.223     1.559     0.200
     0.189     2.660     0.200
     0.415     2.711     0.200
     0.432     4.116     0.200
     0.466     3.011     0.200
     0.503     3.993     0.200
     0.560     3.623     0.200
     0.561     4.311     0.200
     0.609     5.256     0.200
     0.627     5.547     0.200
     0.705     5.932     0.200
     0.721     5.541     0.200
     0.771     5.858     0.200
     0.860     6.616     0.200
     1.006     7.213     0.200
     1.003     6.658     0.200
     1.041     7.410     0.200
     1.036     7.168     0.200
     1.058     7.808     0.200
     1.096     8.770     0.200
     1.352     9.175     0.200
     1.637    11.556     0.200
     1.936    12.064     0.200
     1.977    11.982     0.200
     2.057    12.155     0.200
     0.245     3.324     0.200
     0.342     3.297     0.200
     0.427     3.601     0.200
     0.491     4.060     0.200
     0.550     3.966     0.200
     0.640     4.819     0.200
     0.655     5.047     0.200
     0.682     5.325     0.200
     0.721     5.870     0.200
     0.748     6.356     0.200
     0.766     5.850     0.200
     0.793     5.336     0.200
     0.862     6.630     0.200
     0.882     5.999     0.200
     0.908     6.195     0.200
     0.898     6.707     0.200
     0.952     7.277     0.200
     1.060     7.117     0.200
     0.257     3.177     0.200
     0.323     3.501     0.200
     0.417     3.607     0.200
     0.494     4.206     0.200
     0.545     3.909     0.200
     0.639     5.212     0.200
     0.667     5.390     0.200
     0.689     5.332     0.200
     0.710     5.081     0.200
     0.778     5.895     0.200
     0.810     5.613     0.200
     0.867     6.256     0.200
     0.879     6.812     0.200
     0.921     7.021     0.200
     1.041     7.921     0.200
     1.298     8.320     0.200
     1.388     9.167     0.200
     1.533     9.587     0.200
     1.600     9.700     0.200
     1.840    10.705     0.200
     1.833    10.674     0.200
     0.108     1.482     0.200
     0.271     2.472     0.200
     0.345     3.213     0.200
     0.331     2.976     0.200
     0.408     3.786     0.200
     0.340     3.571     0.200
     0.563     4.072     0.200
     0.548     4.153     0.200
     0.585     3.616     0.200
     0.656     3.888     0.200
     0.702     4.855     0.200
     0.743     5.872     0.200
     0.720     6.540     0.200
     0.759     5.983     0.200
     0.898     7.267     0.200
     0.913     7.290     0.200
     0.934     6.044     0.200
     0.924     6.162     0.200
     1.095     9.159     0.200
     1.193     7.317     0.200
     1.178     9.089     0.200
     1.159     7.211     0.200
     1.484    10.419     0.200
     2.188    12.602     0.200
     0.207     2.719     0.200
     0.294     2.402     0.200
     0.445     3.042     0.200
     0.485     3.275     0.200
     0.482     4.112     0.200
     0.538     4.160     0.200
     0.583     3.934     0.200
     0.602     5.613     0.200
     0.598     5.156     0.200
     0.619     4.905     0.200
     0.642     5.243     0.200
     0.648     5.072     0.200
     0.834     6.703     0.200
     0.818     5.386     0.200
     0.818     5.582     0.200
     0.899     7.050     0.200
     0.928     6.607     0.200
     0.893     6.310     0.200
     0.956     6.180     0.200
     1.022     8.403     0.200
     1.189     8.960     0.200
     1.184     8.213     0.200
     1.192     8.625     0.200
     1.210     8.113     0.200
     1.458     9.722     0.200
     1.481     9.948     0.200
     1.502     9.807     0.200
     1.855    12.190     0.200
     0.187     2.017     0.200
     0.187     2.150     0.200
     0.472     1.820     0.200
     0.468     3.368     0.200
     0.561     3.084     0.200
     0.611     4.604     0.200
     0.634     4.326     0.200
     0.667     4.642     0.200
     0.814     5.338     0.200
     0.804     5.547     0.200
     0.804     5.243     0.200
     0.869     5.484     0.200
     0.915     7.456     0.200
     0.945     6.904     0.200
     0.980     7.494     0.200
     1.041     8.286     0.200
     1.056     8.713     0.200
     1.193     8.303     0.200
     1.210     8.514     0.200
     1.197     7.558     0.200
     0.830     5.786     0.200
     0.938     7.071     0.200
     0.970     6.806     0.200
     1.009     7.047     0.200
     1.036     7.635     0.200
     1.088     7.723     0.200
     1.105     7.134     0.200
     1.099     7.694     0.200
     1.154     7.664     0.200
     0.550     4.616     0.200
     0.597     4.666     0.200
     0.582     4.950     0.200
     0.665     5.282     0.200
     0.665     5.275     0.200
     0.974     7.168     0.200
     0.991     7.671     0.200
     1.100     8.399     0.200
     1.092     7.595     0.200
     1.115     8.428     0.200
     1.170     8.386     0.200
     1.254     8.505     0.200
     1.321     9.423     0.200
     1.362     8.746     0.200
     1.382     9.407     0.200
     1.371     8.739     0.200
     1.471     9.569     0.200
     1.590     9.578     0.200
     1.607    10.482     0.200
     1.634    10.369     0.200
     0.229     3.369     0.200
     0.510     4.986     0.200
     0.635     5.428     0.200
     0.662     5.419     0.200
     0.780     6.439     0.200
     0.830     6.457     0.200
     0.899     6.751     0.200
     0.976     7.655     0.200
     1.055     6.731     0.200
     1.166     8.533     0.200
     1.205     7.986     0.200
     1.302     8.351     0.200
     1.361     9.460     0.200
     1.406     8.832     0.200
     1.513     9.884     0.200
     1.654     9.939     0.200
     1.830    10.183     0.200
     2.011    11.168     0.200
     2.415    12.961     0.200
     0.714     6.764     0.200
     0.880     6.432     0.200
     1.068     7.736     0.200
     1.053     8.013     0.200
     1.088     8.109     0.200
     1.151     7.965     0.200
     1.120     8.531     0.200
     1.233     8.417     0.200
     1.398    10.786     0.200
     0.234     1.704     0.200
     0.213     2.552     0.200
     0.301     2.521     0.200
     0.439     3.813     0.200
     0.445     4.144     0.200
     0.471     4.034     0.200
     0.491     3.703     0.200
     0.590     4.747     0.200
     0.648     5.366     0.200
     0.787     6.449     0.200
     0.808     5.804     0.200
     0.886     6.195     0.200
     0.963     6.401     0.200
     1.195     7.886     0.200
     1.202     8.710     0.200
     1.199     8.237     0.200
     0.198     2.729     0.200
     0.247     1.655     0.200
     0.305     2.673     0.200
     0.497     3.737     0.200
     0.475     5.095     0.200
     0.548     5.442     0.200
     0.586     4.303     0.200
     0.596     4.486     0.200
     0.605     2.975     0.200
     0.614     6.173     0.200
     0.654     5.007     0.200
     0.798     6.719     0.200
     0.882     5.045     0.200
     0.967     7.252     0.200
     1.031     6.905     0.200
     1.190     7.654     0.200
     1.200     7.631     0.200
     1.204     9.090     0.200
     1.391     8.301     0.200
     1.493     8.513     0.200
     1.906    11.499     0.200
     0.262     2.543     0.200
     0.098     1.055     0.200
     0.282     2.413     0.200
     0.145     1.712     0.200
     0.143     2.540     0.200
     0.262     2.724     0.200
     0.262     2.947     0.200
     0.428     2.808     0.200
     0.313     2.848     0.200
     0.404     3.795     0.200
     0.646     4.965     0.200
     0.796     5.914     0.200
     0.650     5.612     0.200
     0.613     4.351     0.200
     0.654     4.464     0.200
     0.565     4.410     0.200
     0.773     5.786     0.200
     0.933     5.612     0.200
     0.874     5.507     0.200
     0.822     5.914     0.200
     0.931     6.837     0.200
     0.824     6.291     0.200
     0.989     6.858     0.200
     0.985     7.902     0.200
     1.291     8.631     0.200
     1.250     8.617     0.200
     1.359     8.948     0.200
     1.456     9.210     0.200
     1.654    10.402     0.200
     1.827    10.581     0.200
     2.020    11.825     0.200
     2.239    13.874     0.200
     3.903    20.858     0.200
     0.094     1.313     0.200
     0.150     1.757     0.200
     0.156     2.386     0.200
     0.249     0.807     0.200
     0.265     2.812     0.200
     0.277     2.478     0.200
     0.323     2.637     0.200
     0.425     2.754     0.200
     0.413     3.591     0.200
     0.577     4.472     0.200
     0.618     4.494     0.200
     0.640     4.339     0.200
     0.658     4.730     0.200
     0.650     5.019     0.200
     0.773     6.288     0.200
     0.824     5.695     0.200
     0.827     5.862     0.200
     0.870     5.457     0.200
     0.926     6.006     0.200
     0.996     6.686     0.200
     0.994     7.811     0.200
     1.251     8.613     0.200
     1.306     9.966     0.200
     1.380     8.899     0.200
     1.477     9.667     0.200
     1.659    10.644     0.200
     1.830    10.860     0.200
     2.014    12.310     0.200
     2.012    12.425     0.200
     0.093     1.378     0.200
     0.154     1.866     0.200
     0.169     2.490     0.200
     0.237     0.792     0.200
     0.275     2.753     0.200
     0.270     3.103     0.200
     0.331     2.803     0.200
     0.420     3.057     0.200
     0.422     4.532     0.200
     0.588     4.497     0.200
     0.634     4.665     0.200
     0.622     4.703     0.200
     0.652     4.847     0.200
     0.659     5.064     0.200
     0.825     5.735     0.200
     0.868     5.725     0.200
     0.914     6.696     0.200
     0.920     7.024     0.200
     1.003     8.261     0.200
     1.001     7.074     0.200
     1.254     9.126     0.200
     1.284     8.474     0.200
     1.488     9.397     0.200
     0.283     1.637     0.200
     0.337     2.210     0.200
     0.479     2.946     0.200
     0.493     3.589     0.200
     0.468     4.181     0.200
     0.611     4.591     0.200
     0.611     4.812     0.200
     0.663     4.207     0.200
     0.661     4.922     0.200
     0.729     5.132     0.200
     0.821     5.261     0.200
     0.875     5.029     0.200
     0.794     7.241     0.200
     0.794     6.411     0.200
     0.794     6.971     0.200
     1.010     6.657     0.200
     1.018     8.059     0.200
     1.126     7.597     0.200
     1.551    11.240     0.200
     1.632    11.198     0.200
     0.119     1.628     0.200
     0.168     2.249     0.200
     0.226     1.781     0.200
     0.264     2.036     0.200
     0.362     3.389     0.200
     0.357     4.352     0.200
     0.395     3.609     0.200
     0.438     4.001     0.200
     0.455     3.902     0.200
     0.447     3.404     0.200
     0.459     3.464     0.200
     0.562     4.361     0.200
     0.563     4.440     0.200
     0.603     5.083     0.200
     0.727     4.932     0.200
     0.748     5.288     0.200
     0.815     6.208     0.200
     1.058     7.267     0.200
     1.420     8.945     0.200
     1.625    10.153     0.200
     0.151     1.709     0.200
     0.192     2.027     0.200
     0.192     2.237     0.200
     0.299     2.484     0.200
     0.345     3.051     0.200
     0.369     2.868     0.200
     0.384     4.492     0.200
     0.425     3.018     0.200
     0.460     3.603     0.200
     0.473     3.460     0.200
     0.473     4.050     0.200
     0.533     4.151     0.200
     0.537     4.312     0.200
     0.566     5.070     0.200
     0.638     5.531     0.200
     0.692     4.601     0.200
     0.733     5.425     0.200
     1.175     8.065     0.200
     1.160     8.241     0.200
     1.215     8.694     0.200
     1.386     8.604     0.200
     1.660    10.305     0.200
     1.912    11.465     0.200
     0.194     1.962     0.200
     0.197     2.323     0.200
     0.291     2.325     0.200
     0.360     3.623     0.200
     0.383     3.849     0.200
     0.370     4.501     0.200
     0.445     3.631     0.200
     0.481     4.011     0.200
     0.469     3.453     0.200
     0.547     4.041     0.200
     0.551     4.096     0.200
     0.532     5.915     0.200
     0.552     5.287     0.200
     0.649     4.556     0.200
     0.630     4.575     0.200
     0.697     4.992     0.200
     0.748     5.499     0.200
     0.730     6.800     0.200
     0.847     6.046     0.200
     1.032     7.684     0.200
     1.146     8.154     0.200
     1.208     9.222     0.200
     1.396     8.839     0.200
     1.656    10.302     0.200
     1.795    10.180     0.200
     1.903    11.518     0.200
     2.095    11.982     0.200
     0.170     2.069     0.200
     0.215     1.547     0.200
     0.282     2.162     0.200
     0.343     3.150     0.200
     0.374     3.686     0.200
     0.377     3.646     0.200
     0.446     3.443     0.200
     0.452     3.674     0.200
     0.453     3.665     0.200
     0.464     3.236     0.200
     0.541     4.339     0.200
     0.543     3.916     0.200
     0.532     5.339     0.200
     0.560     5.115     0.200
     0.621     5.006     0.200
     0.712     4.844     0.200
     0.729     5.238     0.200
     0.825     6.123     0.200
     1.040     6.916     0.200
     1.154     8.287     0.200
     1.197     8.087     0.200
     1.401     8.806     0.200
     1.639     9.725     0.200
     1.895    12.538     0.200
     0.122     1.483     0.200
     0.141     1.362     0.200
     0.174     1.976     0.200
     0.210     1.751     0.200
     0.285     2.281     0.200
     0.344     3.094     0.200
     0.373     3.247     0.200
     0.378     3.994     0.200
     0.442     3.345     0.200
     0.456     3.982     0.200
     0.457     3.877     0.200
     0.463     3.505     0.200
     0.540     3.707     0.200
     0.542     4.381     0.200
     0.534     5.374     0.200
     0.561     4.562     0.200
     0.624     4.731     0.200
     0.708     4.839     0.200
     0.731     5.080     0.200
     0.829     6.232     0.200
     1.037     7.207     0.200
     1.051     7.846     0.200
     1.154     8.538     0.200
     1.192     8.195     0.200
     1.200     8.308     0.200
     1.643    10.537     0.200
     2.601    15.155     0.200
     0.120     1.057     0.200
     0.180     1.559     0.200
     0.204     1.169     0.200
     0.290     2.172     0.200
     0.343     2.751     0.200
     0.381     3.011     0.200
     0.436     3.063     0.200
     0.461     3.170     0.200
     0.462     4.361     0.200
     0.463     2.555     0.200
     0.537     4.786     0.200
     0.538     5.576     0.200
     0.563     5.282     0.200
     0.629     5.218     0.200
     0.703     4.754     0.200
     0.738     6.836     0.200
     1.157     8.260     0.200
     1.648    10.520     0.200
     1.903    11.248     0.200
     0.146     1.317     0.200
     0.183     0.891     0.200
     0.212     2.151     0.200
     0.300     1.923     0.200
     0.367     3.343     0.200
     0.386     3.417     0.200
     0.371     3.294     0.200
     0.416     2.969     0.200
     0.438     2.704     0.200
     0.480     3.826     0.200
     0.495     3.741     0.200
     0.548     4.130     0.200
     0.552     4.476     0.200
     0.536     4.970     0.200
     0.551     4.990     0.200
     0.638     4.779     0.200
     0.755     5.311     0.200
     0.859     6.793     0.200
     0.928     6.791     0.200
     1.025     6.855     0.200
     1.050     7.967     0.200
     1.145     8.161     0.200
     1.179     8.360     0.200
     1.167     7.201     0.200
     1.217     8.417     0.200
     1.667    10.672     0.200
     1.910    12.132     0.200
     2.922    16.822     0.200
     0.107     1.159     0.200
     0.164     1.494     0.200
     0.182     1.184     0.200
     0.199     2.089     0.200
     0.312     2.370     0.200
     0.336     3.085     0.200
     0.358     2.834     0.200
     0.396     2.988     0.200
     0.414     3.384     0.200
     0.469     3.142     0.200
     0.477     3.649     0.200
     0.486     4.443     0.200
     0.521     3.824     0.200
     0.525     3.782     0.200
     0.557     4.813     0.200
     0.577     4.773     0.200
     0.643     4.104     0.200
     0.651     5.515     0.200
     0.680     4.679     0.200
     0.725     5.054     0.200
     0.857     6.505     0.200
     1.010     7.224     0.200
     1.171     7.641     0.200
     1.228     9.781     0.200
     1.672    10.403     0.200
     1.925    12.348     0.200
     0.113     0.640     0.200
     0.174     1.721     0.200
     0.150     1.202     0.200
     0.207     1.236     0.200
     0.334     2.753     0.200
     0.292     2.143     0.200
     0.364     3.104     0.200
     0.388     3.133     0.200
     0.438     3.133     0.200
     0.454     3.658     0.200
     0.462     3.658     0.200
     0.531     3.964     0.200
     0.533     3.941     0.200
     0.543     6.015     0.200
     0.570     5.096     0.200
     0.631     4.793     0.200
     0.721     4.932     0.200
     1.648    10.426     0.200
     1.905    12.421     0.200
     0.111     0.847     0.200
     0.201     1.100     0.200
     0.153     1.158     0.200
     0.180     1.537     0.200
     0.335     2.731     0.200
     0.363     2.910     0.200
     0.297     1.978     0.200
     0.432     3.003     0.200
     0.389     3.698     0.200
     0.460     3.479     0.200
     0.528     3.880     0.200
     0.531     3.649     0.200
     0.468     3.380     0.200
     0.471     3.150     0.200
     0.546     5.072     0.200
     0.572     5.070     0.200
     0.662     4.517     0.200
     0.636     4.525     0.200
     0.697     4.414     0.200
     0.722     4.913     0.200
     0.793     5.087     0.200
     0.747     5.625     0.200
     0.942     7.151     0.200
     1.025     6.682     0.200
     1.063     8.342     0.200
     1.169     6.803     0.200
     1.181     7.356     0.200
     1.165     7.744     0.200
     1.212     8.703     0.200
     1.540    10.875     0.200
     1.540    10.874     0.200
     2.109    13.030     0.200
     2.336    13.884     0.200
     2.554    14.246     0.200
     2.932    16.022     0.200
     3.165    18.205     0.200
     3.354    19.999     0.200
     0.070     1.089     0.200
     0.150     0.854     0.200
     0.201     1.457     0.200
     0.283     2.301     0.200
     0.282     2.113     0.200
     0.318     2.590     0.200
     0.350     2.923     0.200
     0.326     2.705     0.200
     0.408     3.242     0.200
     0.438     4.697     0.200
     0.517     3.970     0.200
     0.524     4.083     0.200
     0.538     3.925     0.200
     0.564     4.121     0.200
     0.559     6.178     0.200
     0.603     4.371     0.200
     0.619     5.575     0.200
     0.650     4.520     0.200
     0.782     4.972     0.200
     0.771     6.309     0.200
     1.077     7.239     0.200
     1.188     7.546     0.200
     0.119     1.190     0.200
     0.149     1.529     0.200
     0.191     1.956     0.200
     0.194     1.414     0.200
     0.346     2.942     0.200
     0.370     3.357     0.200
     0.383     3.410     0.200
     0.426     3.297     0.200
     0.459     2.717     0.200
     0.472     3.769     0.200
     0.535     4.133     0.200
     0.538     4.096     0.200
     0.542     3.252     0.200
     0.564     5.594     0.200
     0.636     5.453     0.200
     0.694     4.484     0.200
     0.733     5.120     0.200
     1.025     6.812     0.200
     1.158     6.860     0.200
     1.658    10.832     0.200
     0.122     1.496     0.200
     0.141     1.373     0.200
     0.171     1.920     0.200
     0.213     1.825     0.200
     0.284     2.309     0.200
     0.342     3.217     0.200
     0.373     3.359     0.200
     0.379     3.894     0.200
     0.445     3.519     0.200
     0.453     3.828     0.200
     0.455     3.709     0.200
     0.465     3.492     0.200
     0.540     4.217     0.200
     0.542     4.195     0.200
     0.534     5.186     0.200
     0.561     5.067     0.200
     0.622     4.754     0.200
     0.673     4.566     0.200
     0.710     4.726     0.200
     0.729     5.206     0.200
     0.735     5.630     0.200
     0.804     5.630     0.200
     1.038     7.094     0.200
     1.155     7.938     0.200
     1.182     8.021     0.200
     1.399     8.686     0.200
     1.640    10.473     0.200
     1.897    12.782     0.200
     2.567    14.352     0.200
     2.579    14.515     0.200
     2.600    13.974     0.200
     0.121     1.461     0.200
     0.143     1.397     0.200
     0.175     1.915     0.200
     0.209     1.829     0.200
     0.287     2.318     0.200
     0.343     3.063     0.200
     0.372     3.322     0.200
     0.380     3.836     0.200
     0.441     3.420     0.200
     0.457     3.624     0.200
     0.459     3.609     0.200
     0.464     3.356     0.200
     0.538     4.178     0.200
     0.541     4.152     0.200
     0.536     5.311     0.200
     0.562     5.104     0.200
     0.625     4.662     0.200
     0.706     4.623     0.200
     0.730     5.149     0.200
     0.737     5.463     0.200
     0.931     7.998     0.200
     1.035     6.881     0.200
     1.156     7.779     0.200
     1.353     9.172     0.200
     1.644    10.270     0.200
     1.900    12.698     0.200
     0.111     1.099     0.200
     0.154     1.293     0.200
     0.198     1.183     0.200
     0.183     1.750     0.200
     0.299     2.103     0.200
     0.336     2.972     0.200
     0.362     3.061     0.200
     0.390     2.240     0.200
     0.429     3.279     0.200
     0.463     3.694     0.200
     0.470     3.513     0.200
     0.471     3.701     0.200
     0.528     4.130     0.200
     0.530     4.005     0.200
     0.547     5.605     0.200
     0.572     5.419     0.200
     0.638     4.751     0.200
     0.694     4.390     0.200
     0.723     5.050     0.200
     1.023     6.854     0.200
     1.178     7.638     0.200
     1.214     9.426     0.200
     1.656    10.458     0.200
     1.912    12.179     0.200
     0.153     1.733     0.200
     0.174     1.784     0.200
     0.147     1.508     0.200
     0.231     1.929     0.200
     0.304     2.573     0.200
     0.385     3.432     0.200
     0.400     3.555     0.200
     0.362     4.195     0.200
     0.407     2.369     0.200
     0.421     3.707     0.200
     0.488     3.828     0.200
     0.516     3.901     0.200
     0.559     4.496     0.200
     0.565     3.830     0.200
     0.531     5.619     0.200
     0.620     4.089     0.200
     0.640     5.149     0.200
     0.682     4.263     0.200
     0.773     5.597     0.200
     1.026     7.349     0.200
     1.347     9.101     0.200
     1.393     8.971     0.200
     1.675    11.077     0.200
     1.911    12.720     0.200
     0.159     1.472     0.200
     0.134     1.758     0.200
     0.187     1.042     0.200
     0.223     2.029     0.200
     0.291     2.326     0.200
     0.352     3.320     0.200
     0.389     2.783     0.200
     0.408     3.569     0.200
     0.420     3.227     0.200
     0.416     3.573     0.200
     0.475     4.180     0.200
     0.509     3.982     0.200
     0.520     5.661     0.200
     0.568     4.797     0.200
     0.573     4.535     0.200
     0.628     4.402     0.200
     0.695     4.418     0.200
     1.038     6.211     0.200
     1.125     7.201     0.200
     1.172     7.354     0.200
     1.662    10.328     0.200
     1.898    12.172     0.200
     0.147     1.215     0.200
     0.115     1.492     0.200
     0.166     1.795     0.200
     0.230     1.846     0.200
     0.259     2.406     0.200
     0.365     3.077     0.200
     0.353     3.908     0.200
     0.398     3.186     0.200
     0.463     3.528     0.200
     0.445     2.038     0.200
     0.434     3.270     0.200
     0.453     3.642     0.200
     0.508     5.106     0.200
     0.565     4.032     0.200
     0.567     3.715     0.200
     0.598     5.151     0.200
     0.732     4.895     0.200
     0.710     5.152     0.200
     0.750     5.279     0.200
     0.811     5.873     0.200
     1.130     7.548     0.200
     1.175     7.517     0.200
     1.424     9.309     0.200
     1.502     9.799     0.200
     1.620    10.821     0.200
     1.872    12.485     0.200
     0.143     1.356     0.200
     0.137     1.324     0.200
     0.191     1.289     0.200
     0.207     2.010     0.200
     0.291     2.230     0.200
     0.371     3.385     0.200
     0.363     4.088     0.200
     0.393     4.134     0.200
     0.424     3.167     0.200
     0.433     3.262     0.200
     0.471     3.728     0.200
     0.492     3.682     0.200
     0.527     5.274     0.200
     0.555     4.239     0.200
     0.560     4.789     0.200
     0.628     4.687     0.200
     0.696     3.994     0.200
     0.724     5.677     0.200
     0.760     5.357     0.200
     0.919     7.291     0.200
     1.035     6.746     0.200
     1.137     8.450     0.200
     1.208     9.124     0.200
     1.658    10.975     0.200
     1.901    11.839     0.200
     0.137     1.481     0.200
     0.195     1.904     0.200
     0.135     1.401     0.200
     0.199     1.861     0.200
     0.286     2.239     0.200
     0.364     2.935     0.200
     0.388     3.447     0.200
     0.365     3.814     0.200
     0.432     3.336     0.200
     0.464     3.765     0.200
     0.442     3.324     0.200
     0.552     4.135     0.200
     0.556     4.196     0.200
     0.527     5.228     0.200
     0.527     5.079     0.200
     0.547     5.094     0.200
     0.625     4.790     0.200
     0.652     4.469     0.200
     0.702     4.386     0.200
     0.751     5.309     0.200
     0.725     5.412     0.200
     0.785     5.319     0.200
     1.037     6.770     0.200
     1.188     7.514     0.200
     1.141     7.970     0.200
     1.183     7.478     0.200
     1.203     8.334     0.200
     1.530    10.627     0.200
     1.530    10.828     0.200
     1.518    10.368     0.200
     1.651    10.109     0.200
     1.898    12.035     0.200
     2.233    12.923     0.200
     2.563    14.374     0.200
     0.063     1.470     0.200
     0.285     3.078     0.200
     0.285     2.974     0.200
     0.469     3.937     0.200
     0.646     5.168     0.200
     0.681     5.352     0.200
     1.136     8.146     0.200
     1.147     7.619     0.200
     1.162     8.445     0.200
     1.338     8.788     0.200
     1.355     8.486     0.200
     1.379     8.506     0.200
     1.456    10.214     0.200
     1.463     9.636     0.200
     1.555    10.553     0.200
     1.685    10.435     0.200
     1.711    10.540     0.200
     1.726    11.659     0.200
     1.934    11.940     0.200
     0.238     2.117     0.200
     0.240     2.296     0.200
     0.243     2.567     0.200
     0.266     2.495     0.200
     0.320     2.764     0.200
     0.350     3.316     0.200
     0.406     3.556     0.200
     0.410     4.014     0.200
     0.556     4.514     0.200
     0.567     4.686     0.200
     0.579     4.749     0.200
     0.605     5.231     0.200
     0.629     4.353     0.200
     0.654     4.769     0.200
     0.758     7.450     0.200
     0.869     5.858     0.200
     0.937     6.669     0.200
     1.495     9.653     0.200
     1.813    10.947     0.200
     0.120     1.676     0.200
     0.146     1.478     0.200
     0.181     1.969     0.200
     0.217     1.950     0.200
     0.269     2.538     0.200
     0.368     2.984     0.200
     0.355     3.241     0.200
     0.397     3.242     0.200
     0.450     3.329     0.200
     0.439     2.956     0.200
     0.446     3.472     0.200
     0.468     3.822     0.200
     0.513     4.594     0.200
     0.537     5.113     0.200
     0.563     4.908     0.200
     0.566     4.278     0.200
     0.608     4.987     0.200
     0.720     4.179     0.200
     0.755     5.472     0.200
     0.825     6.053     0.200
     1.330     9.056     0.200
     1.633    10.222     0.200
     1.881    12.725     0.200
     0.206     2.049     0.200
     0.242     2.125     0.200
     0.404     3.137     0.200
     0.404     3.142     0.200
     0.396     3.939     0.200
     0.453     3.567     0.200
     0.515     5.246     0.200
     0.581     4.674     0.200
     0.700     4.781     0.200
     0.719     4.768     0.200
     0.702     5.067     0.200
     0.818     4.902     0.200
     0.794     5.991     0.200
     0.866     8.343     0.200
     0.866     8.147     0.200
     0.908     7.159     0.200
     1.050     8.503     0.200
     1.111     7.190     0.200
     1.242     7.955     0.200
     1.254     7.921     0.200
     1.254     8.623     0.200
     1.331     8.921     0.200
     1.384     9.202     0.200
     1.476     9.038     0.200
     1.556     9.896     0.200
     1.703     9.881     0.200
     1.669    10.582     0.200
     1.742    10.519     0.200
     1.765    10.457     0.200
     1.910    11.868     0.200
     1.917    12.188     0.200
     2.052    11.612     0.200
     0.126     2.091     0.200
     0.165     1.830     0.200
     0.195     1.687     0.200
     0.220     2.394     0.200
     0.283     3.154     0.200
     0.344     2.653     0.200
     0.395     3.455     0.200
     0.410     3.777     0.200
     0.427     3.475     0.200
     0.508     4.332     0.200
     0.511     6.197     0.200
     0.523     4.057     0.200
     0.576     4.641     0.200
     0.581     4.684     0.200
     0.619     5.334     0.200
     0.703     5.158     0.200
     0.706     4.326     0.200
     0.783     5.620     0.200
     1.525     9.462     0.200
     1.525     9.766     0.200
     1.655    10.649     0.200
     1.800    10.158     0.200
     2.212    12.347     0.200
     0.088     1.970     0.200
     0.198     1.889     0.200
     0.183     2.261     0.200
     0.209     2.661     0.200
     0.258     3.181     0.200
     0.277     2.361     0.200
     0.277     3.060     0.200
     0.366     3.027     0.200
     0.422     2.569     0.200
     0.382     3.536     0.200
     0.449     4.158     0.200
     0.444     3.411     0.200
     0.628     5.068     0.200
     0.627     4.777     0.200
     0.647     4.747     0.200
     0.647     4.449     0.200
     0.771     6.397     0.200
     0.791     5.560     0.200
     0.841     6.077     0.200
     0.846     6.424     0.200
     0.851     6.058     0.200
     0.893     6.169     0.200
     0.914     5.724     0.200
     0.898     6.516     0.200
     1.029     6.987     0.200
     1.020     7.389     0.200
     1.076     8.339     0.200
     0.181     1.294     0.200
     0.152     1.029     0.200
     0.208     1.980     0.200
     0.357     3.039     0.200
     0.414     3.075     0.200
     0.304     2.051     0.200
     0.379     3.581     0.200
     0.539     4.017     0.200
     0.543     4.263     0.200
     0.448     2.676     0.200
     0.490     3.588     0.200
     0.637     3.977     0.200
     0.543     4.821     0.200
     0.543     4.969     0.200
     0.684     4.325     0.200
     0.745     5.210     0.200
     0.642     4.408     0.200
     0.769     4.832     0.200
     0.740     5.066     0.200
     1.020     6.608     0.200
     0.936     6.586     0.200
     1.172     7.029     0.200
     1.058     7.859     0.200
     1.154     7.638     0.200
     1.915    11.655     0.200
     2.319    13.043     0.200
     2.938    17.125     0.200
     3.146    18.290     0.200
     4.359    26.636     0.200
     0.269     1.288     0.200
     0.357     1.965     0.200
     0.369     2.277     0.200
     0.369     2.124     0.200
     0.477     3.355     0.200
     0.488     3.533     0.200
     0.476     4.069     0.200
     0.512     4.154     0.200
     0.508     3.993     0.200
     0.611     4.999     0.200
     0.606     4.262     0.200
     0.686     5.224     0.200
     0.701     5.041     0.200
     0.802     5.866     0.200
     0.824     6.016     0.200
     0.911     6.291     0.200
     0.926     6.518     0.200
     0.942     6.536     0.200
     1.051     7.765     0.200
     1.057     7.494     0.200
     1.083     8.187     0.200
     1.148     9.226     0.200
     1.330     9.009     0.200
     1.554    10.489     0.200
     1.585    10.629     0.200
     0.110     2.025     0.200
     0.152     1.534     0.200
     0.191     2.581     0.200
     0.224     1.293     0.200
     0.287     3.362     0.200
     0.294     3.376     0.200
     0.336     2.886     0.200
     0.399     3.049     0.200
     0.397     2.971     0.200
     0.450     4.259     0.200
     0.473     3.783     0.200
     0.610     4.790     0.200
     0.616     4.618     0.200
     0.600     4.699     0.200
     0.671     5.278     0.200
     0.749     4.862     0.200
     0.812     6.228     0.200
     0.816     5.380     0.200
     0.783     6.168     0.200
     0.795     6.031     0.200
     0.896     6.051     0.200
     0.880     6.333     0.200
     0.922     7.042     0.200
     0.998     6.962     0.200
     1.029     7.393     0.200
     1.099     7.681     0.200
     1.263     8.468     0.200
     1.273     8.547     0.200
     1.340     8.665     0.200
     1.340     9.868     0.200
     1.690    11.280     0.200
     0.495     3.133     0.200
     0.487     3.816     0.200
     0.591     3.496     0.200
     0.571     4.632     0.200
     0.627     4.776     0.200
     0.648     4.234     0.200
     0.653     4.180     0.200
     0.635     4.481     0.200
     0.672     4.455     0.200
     0.697     5.861     0.200
     0.801     5.902     0.200
     0.832     5.983     0.200
     0.821     5.810     0.200
     0.822     6.006     0.200
     0.852     6.854     0.200
     0.895     6.455     0.200
     0.948     6.331     0.200
     0.870     6.038     0.200
     0.982     6.639     0.200
     1.038     7.986     0.200
     1.084     8.652     0.200
     1.182     8.708     0.200
     1.175     7.986     0.200
     1.215     8.820     0.200
     1.199     9.310     0.200
     1.216     8.505     0.200
     1.216     7.306     0.200
     1.780    12.623     0.200
     2.117    13.296     0.200
     0.343     3.540     0.200
     0.616     4.659     0.200
     0.633     5.854     0.200
     0.659     5.448     0.200
     0.728     5.950     0.200
     0.732     5.704     0.200
     0.822     6.957     0.200
     0.920     7.007     0.200
     0.925     7.295     0.200
     0.925     6.943     0.200
     1.001     7.961     0.200
     1.042     7.178     0.200
     1.186     8.608     0.200
     1.156     8.653     0.200
     1.212     8.402     0.200
     1.344    10.660     0.200
     1.426     9.496     0.200
     1.406     9.034     0.200
     1.434     9.406     0.200
     1.483     9.537     0.200
     1.556    10.583     0.200
     1.607     9.892     0.200
     1.649    11.398     0.200
     1.627    10.555     0.200
     1.732    10.529     0.200
     1.813    11.291     0.200
     1.885    12.140     0.200
     1.895    11.233     0.200
     1.870    11.319     0.200
     2.122    12.680     0.200
     2.154    12.506     0.200
     2.216    12.690     0.200
     2.337    13.066     0.200
     2.652    14.893     0.200
     2.719    14.217     0.200
     0.558     4.681     0.200
     0.627     5.577     0.200
     0.665     4.935     0.200
     0.739     6.468     0.200
     0.764     6.982     0.200
     0.784     7.041     0.200
     0.924     6.606     0.200
     0.964     5.442     0.200
     0.945     7.562     0.200
     0.996     6.465     0.200
     0.983     7.726     0.200
     1.047     7.671     0.200
     1.066     7.848     0.200
     1.056     7.670     0.200
     1.062     7.602     0.200
     1.110     8.037     0.200
     1.114     7.592     0.200
     1.290     8.536     0.200
     1.364    10.281     0.200
     1.378     9.008     0.200
     1.413    10.101     0.200
     1.463     9.823     0.200
     1.693     9.933     0.200
     1.766    10.884     0.200
     0.114     1.511     0.200
     0.195     1.866     0.200
     0.153     1.453     0.200
     0.188     1.747     0.200
     0.340     3.069     0.200
     0.365     3.274     0.200
     0.403     2.834     0.200
     0.427     3.461     0.200
     0.299     2.244     0.200
     0.387     3.621     0.200
     0.530     4.251     0.200
     0.468     3.778     0.200
     0.465     3.213     0.200
     0.472     3.725     0.200
     0.655     4.199     0.200
     0.546     5.550     0.200
     0.546     5.269     0.200
     0.693     4.655     0.200
     0.569     5.097     0.200
     0.728     5.345     0.200
     0.638     4.691     0.200
     0.786     5.563     0.200
     0.746     6.736     0.200
     0.845     5.970     0.200
     1.023     6.907     0.200
     0.941     7.361     0.200
     1.163     8.068     0.200
     1.192     8.434     0.200
     1.363     9.331     0.200
     1.542    10.038     0.200
     1.658    10.285     0.200
     1.912    11.724     0.200
     2.550    13.775     0.200
     0.241     2.630     0.200
     0.424     4.102     0.200
     0.504     3.457     0.200
     0.518     4.399     0.200
     0.610     4.528     0.200
     0.633     5.161     0.200
     0.672     5.606     0.200
     0.692     5.670     0.200
     0.729     5.335     0.200
     0.745     5.049     0.200
     0.799     5.516     0.200
     0.812     5.262     0.200
     0.847     5.962     0.200
     0.877     5.905     0.200
     0.875     6.528     0.200
     0.894     5.916     0.200
     0.196     1.107     0.200
     0.346     2.457     0.200
     0.324     2.805     0.200
     0.399     2.828     0.200
     0.405     3.860     0.200
     0.444     3.408     0.200
     0.478     3.314     0.200
     0.515     2.982     0.200
     0.566     3.582     0.200
     0.673     5.133     0.200
     0.686     5.390     0.200
     0.689     5.249     0.200
     0.731     5.064     0.200
     0.754     6.097     0.200
     0.738     5.881     0.200
     0.738     5.677     0.200
     0.776     5.532     0.200
     0.891     6.991     0.200
     0.872     6.016     0.200
     1.010     7.707     0.200
     1.121     8.408     0.200
     1.270     8.864     0.200
     2.177    13.981     0.200
     0.074     2.778     0.200
     0.079     2.120     0.200
     0.239     3.042     0.200
     0.265     1.844     0.200
     0.471     4.838     0.200
     0.505     4.337     0.200
     0.617     5.735     0.200
     0.678     4.923     0.200
     0.706     4.996     0.200
     0.749     6.094     0.200
     0.859     6.510     0.200
     0.861     5.683     0.200
     1.051     7.967     0.200
     1.114     7.235     0.200
     1.131     7.944     0.200
     0.319     3.634     0.200
     0.350     4.568     0.200
     0.578     4.912     0.200
     0.638     3.908     0.200
     0.651     4.558     0.200
     0.721     5.240     0.200
     0.729     4.746     0.200
     0.765     5.734     0.200
     0.822     5.860     0.200
     1.156     7.662     0.200
     1.144     8.009     0.200
     1.225     7.859     0.200
     1.226     8.354     0.200
     1.378     8.480     0.200
     1.621     9.342     0.200
     0.116     1.047     0.200
     0.151     1.449     0.200
     0.188     2.014     0.200
     0.196     2.022     0.200
     0.297     2.336     0.200
     0.343     2.907     0.200
     0.368     3.011     0.200
     0.406     2.673     0.200
     0.385     4.218     0.200
     0.428     3.214     0.200
     0.469     3.339     0.200
     0.471     3.612     0.200
     0.463     3.409     0.200
     0.533     3.788     0.200
     0.536     4.152     0.200
     0.566     5.295     0.200
     0.636     4.883     0.200
     0.655     4.362     0.200
     0.694     4.205     0.200
     0.730     5.383     0.200
     0.743     5.633     0.200
     0.844     5.760     0.200
     1.025     6.748     0.200
     1.171     7.437     0.200
     1.160     7.967     0.200
     1.371     9.006     0.200
     1.910    11.416     0.200
     0.117     2.668     0.200
     0.305     2.878     0.200
     0.368     3.137     0.200
     0.437     3.934     0.200
     0.493     3.885     0.200
     0.555     4.358     0.200
     0.553     4.977     0.200
     0.633     5.150     0.200
     0.646     5.102     0.200
     0.630     5.888     0.200
     0.773     5.214     0.200
     0.823     6.337     0.200
     0.922     7.370     0.200
     0.926     7.330     0.200
     0.960     6.436     0.200
     0.960     6.332     0.200
     0.963     6.993     0.200
     1.036     7.244     0.200
     1.068     7.876     0.200
     1.088     7.843     0.200
     1.356     9.208     0.200
     1.406     9.232     0.200
     1.618    11.348     0.200
     1.683    10.096     0.200
     0.131     2.285     0.200
     0.286     2.768     0.200
     0.349     3.437     0.200
     0.475     3.265     0.200
     0.534     4.984     0.200
     0.543     4.069     0.200
     0.617     5.511     0.200
     0.627     5.199     0.200
     0.671     5.581     0.200
     0.691     5.243     0.200
     0.762     5.523     0.200
     0.816     5.687     0.200
     0.909     7.304     0.200
     0.919     7.389     0.200
     0.958     7.425     0.200
     0.959     6.922     0.200
     0.971     7.083     0.200
     1.040     7.276     0.200
     1.037     7.214     0.200
     0.307     2.320     0.200
     0.383     2.726     0.200
     0.491     3.570     0.200
     0.543     4.255     0.200
     0.564     4.621     0.200
     0.628     4.973     0.200
     0.649     4.919     0.200
     0.653     5.381     0.200
     0.705     5.568     0.200
     0.721     5.585     0.200
     0.761     5.520     0.200
     0.794     6.129     0.200
     0.805     6.004     0.200
     0.862     7.245     0.200
     0.817     5.963     0.200
     0.913     7.142     0.200
     0.909     6.987     0.200
     0.982     7.133     0.200
     0.983     7.231     0.200
     1.034     7.234     0.200
     1.049     7.351     0.200
     1.069     8.428     0.200
     1.070     7.814     0.200
     1.096     8.208     0.200
     1.143     8.258     0.200
     2.034    12.864     0.200
     0.183     2.962     0.200
     0.284     2.787     0.200
     0.457     3.869     0.200
     0.478     3.720     0.200
     0.507     4.182     0.200
     0.552     4.850     0.200
     0.560     4.363     0.200
     0.615     4.622     0.200
     0.633     5.508     0.200
     0.674     4.741     0.200
     0.792     6.655     0.200
     0.843     5.862     0.200
     0.844     5.859     0.200
     0.891     6.607     0.200
     0.905     5.732     0.200
     0.906     5.826     0.200
     0.928     7.074     0.200
     0.944     6.184     0.200
     1.038     6.993     0.200
     1.089     7.588     0.200
     1.156     7.402     0.200
     1.170     8.048     0.200
     1.236     8.276     0.200
     1.938    10.283     0.200
     0.106     1.487     0.200
     0.271     2.372     0.200
     0.333     3.044     0.200
     0.346     3.096     0.200
     0.340     3.160     0.200
     0.407     3.676     0.200
     0.400     4.164     0.200
     0.563     3.151     0.200
     0.583     4.729     0.200
     0.650     5.047     0.200
     0.744     6.144     0.200
     0.758     5.189     0.200
     0.899     6.542     0.200
     0.914     6.764     0.200
     0.925     6.630     0.200
     1.011     8.131     0.200
     1.159     7.907     0.200
     1.225     8.838     0.200
     2.187    12.407     0.200
     0.117     1.653     0.200
     0.150     1.760     0.200
     0.184     2.169     0.200
     0.217     2.185     0.200
     0.267     2.598     0.200
     0.373     3.556     0.200
     0.350     4.232     0.200
     0.402     3.823     0.200
     0.440     2.783     0.200
     0.450     3.866     0.200
     0.433     3.657     0.200
     0.445     3.919     0.200
     0.471     4.013     0.200
     0.509     4.375     0.200
     0.532     5.106     0.200
     0.568     4.694     0.200
     0.570     4.861     0.200
     0.606     5.051     0.200
     0.721     4.705     0.200
     0.760     5.645     0.200
     0.825     5.984     0.200
     0.904     6.270     0.200
     1.056     7.588     0.200
     1.126     8.377     0.200
     1.184     8.798     0.200
     1.326     8.737     0.200
     1.420     8.950     0.200
     1.605     9.487     0.200
     1.632    10.465     0.200
     1.819    10.291     0.200
     0.193     1.710     0.200
     0.243     2.426     0.200
     0.261     2.512     0.200
     0.403     3.466     0.200
     0.449     3.424     0.200
     0.499     4.539     0.200
     0.500     4.728     0.200
     0.574     4.571     0.200
     0.593     4.442     0.200
     0.607     5.378     0.200
     0.836     6.014     0.200
     0.927     6.551     0.200
     1.155     7.977     0.200
     1.176     8.145     0.200
     1.171     7.895     0.200
     1.225     7.973     0.200
     1.486    10.419     0.200
     0.215     1.611     0.200
     0.234     2.993     0.200
     0.296     2.773     0.200
     0.483     3.588     0.200
     0.512     4.146     0.200
     0.468     4.366     0.200
     0.571     5.559     0.200
     0.570     4.478     0.200
     0.600     4.822     0.200
     0.627     5.106     0.200
     0.641     5.345     0.200
     0.771     6.322     0.200
     0.804     6.338     0.200
     0.804     5.636     0.200
     0.893     6.105     0.200
     1.203     9.479     0.200
     1.194     8.086     0.200
     1.423    10.117     0.200
     1.461     9.579     0.200
     1.461    10.081     0.200
     1.492    10.116     0.200
     1.836    11.493     0.200
     0.198     1.887     0.200
     0.269     2.149     0.200
     0.321     1.447     0.200
     0.368     2.300     0.200
     0.372     3.053     0.200
     0.373     3.446     0.200
     0.536     3.641     0.200
     0.615     4.819     0.200
     0.662     5.664     0.200
     0.731     5.063     0.200
     0.738     5.585     0.200
     1.133     7.673     0.200
     1.313     8.966     0.200
     1.696    11.004     0.200
     0.195     2.350     0.200
     0.277     2.593     0.200
     0.335     2.919     0.200
     0.404     3.213     0.200
     0.404     3.308     0.200
     0.426     3.453     0.200
     0.554     3.963     0.200
     0.607     5.638     0.200
     0.696     5.110     0.200
     0.700     5.664     0.200
     0.763     4.922     0.200
     0.828     6.067     0.200
     0.810     5.976     0.200
     0.841     5.915     0.200
     0.943     6.326     0.200
     0.948     7.161     0.200
     1.100     7.292     0.200
     1.475    10.012     0.200
     0.196     2.282     0.200
     0.272     2.596     0.200
     0.380     3.539     0.200
     0.380     3.728     0.200
     0.360     2.168     0.200
     0.419     3.482     0.200
     0.541     4.058     0.200
     0.612     5.424     0.200
     0.671     5.143     0.200
     0.744     5.190     0.200
     0.723     5.030     0.200
     0.717     5.208     0.200
     0.829     5.092     0.200
     0.852     5.630     0.200
     0.810     6.308     0.200
     0.930     7.513     0.200
     0.931     6.399     0.200
     1.114     8.068     0.200
     1.231     7.816     0.200
     1.320     8.962     0.200
     1.367     8.919     0.200
     1.454    10.293     0.200
     1.500     9.563     0.200
     1.576     9.269     0.200
     1.646    10.455     0.200
     1.704    10.886     0.200
     1.715    10.553     0.200
     1.731     9.668     0.200
     1.821    10.407     0.200
     1.869    10.255     0.200
     1.893    11.071     0.200
     1.955    11.649     0.200
     2.118    12.251     0.200
     0.200     2.098     0.200
     0.268     2.601     0.200
     0.380     2.289     0.200
     0.361     3.815     0.200
     0.360     3.423     0.200
     0.413     3.510     0.200
     0.530     4.247     0.200
     0.618     5.617     0.200
     0.650     5.742     0.200
     0.704     5.214     0.200
     0.743     5.357     0.200
     0.728     5.228     0.200
     0.845     5.759     0.200
     0.862     5.871     0.200
     0.915     6.446     0.200
     0.921     6.474     0.200
     1.151     8.197     0.200
     1.147     8.543     0.200
     1.210     8.203     0.200
     1.304     9.713     0.200
     1.342     8.864     0.200
     1.347     9.606     0.200
     1.482     9.335     0.200
     1.601     9.843     0.200
     1.628     9.629     0.200
     1.684    10.969     0.200
     1.695    10.843     0.200
     1.783    10.321     0.200
     1.837    10.288     0.200
     1.887    11.405     0.200
     2.017    12.086     0.200
     0.046     2.142     0.200
     0.255     3.604     0.200
     0.256     3.301     0.200
     0.411     3.581     0.200
     0.448     4.252     0.200
     0.450     4.734     0.200
     0.613     4.334     0.200
     0.599     4.990     0.200
     0.595     5.033     0.200
     0.628     4.850     0.200
     0.712     5.070     0.200
     0.750     5.233     0.200
     0.839     5.490     0.200
     0.844     5.530     0.200
     0.853     6.929     0.200
     0.863     6.313     0.200
     0.955     6.439     0.200
     0.998     7.032     0.200
     1.010     7.193     0.200
     0.994     6.679     0.200
     1.049     7.745     0.200
     1.233     7.898     0.200
     1.398     8.963     0.200
     1.398     8.964     0.200
     1.731     9.877     0.200
     0.142     1.237     0.200
     0.167     1.644     0.200
     0.296     3.134     0.200
     0.307     3.162     0.200
     0.357     2.831     0.200
     0.362     3.373     0.200
     0.444     3.316     0.200
     0.515     3.987     0.200
     0.490     4.876     0.200
     0.502     4.333     0.200
     0.532     5.086     0.200
     0.570     4.643     0.200
     0.599     4.608     0.200
     0.662     5.566     0.200
     0.662     5.816     0.200
     0.687     5.175     0.200
     0.698     5.546     0.200
     0.786     6.320     0.200
     0.786     6.122     0.200
     0.791     6.167     0.200
     0.796     6.008     0.200
     0.909     6.585     0.200
     0.956     6.534     0.200
     0.996     7.073     0.200
     1.058     7.042     0.200
     1.105     8.394     0.200
     1.133     7.868     0.200
     1.198     8.216     0.200
     1.205     8.426     0.200
     1.259     8.507     0.200
     1.254     8.354     0.200
     0.136     1.235     0.200
     0.146     2.120     0.200
     0.232     2.913     0.200
     0.362     2.794     0.200
     0.436     3.330     0.200
     0.474     5.284     0.200
     0.500     4.182     0.200
     0.525     3.796     0.200
     0.554     4.860     0.200
     0.561     4.478     0.200
     0.579     4.665     0.200
     0.674     5.255     0.200
     0.698     4.977     0.200
     0.686     5.312     0.200
     0.788     6.226     0.200
     0.807     7.606     0.200
     0.807     7.006     0.200
     0.908     6.724     0.200
     0.981     7.469     0.200
     1.080     6.617     0.200
     1.124     8.405     0.200
     1.125     8.392     0.200
     1.189     7.841     0.200
     1.188     8.759     0.200
     1.357     9.780     0.200
     1.361     9.443     0.200
     1.466     9.713     0.200
     1.476     9.496     0.200
     0.310     2.966     0.200
     0.291     3.219     0.200
     0.291     3.320     0.200
     0.370     3.089     0.200
     0.359     2.915     0.200
     0.359     2.716     0.200
     0.453     3.023     0.200
     0.495     4.536     0.200
     0.498     4.099     0.200
     0.498     4.400     0.200
     0.514     3.907     0.200
     0.519     5.148     0.200
     0.570     4.557     0.200
     0.607     4.423     0.200
     0.686     5.100     0.200
     0.700     5.638     0.200
     0.795     6.133     0.200
     0.788     6.319     0.200
     0.776     6.655     0.200
     0.776     6.156     0.200
     0.904     6.760     0.200
     0.958     6.733     0.200
     1.000     6.844     0.200
     1.046     7.205     0.200
     1.098     8.199     0.200
     1.133     7.888     0.200
     1.211     8.283     0.200
     1.198     8.226     0.200
     1.257     8.445     0.200
     1.372     9.102     0.200
     1.934    11.738     0.200
     0.129     1.071     0.200
     0.152     2.006     0.200
     0.303     3.322     0.200
     0.305     3.418     0.200
     0.354     2.855     0.200
     0.350     3.395     0.200
     0.431     3.257     0.200
     0.483     4.641     0.200
     0.516     3.865     0.200
     0.508     4.548     0.200
     0.549     5.174     0.200
     0.586     4.636     0.200
     0.570     4.734     0.200
     0.689     5.044     0.200
     0.695     5.667     0.200
     0.678     5.615     0.200
     0.678     5.775     0.200
     0.795     6.107     0.200
     0.797     6.085     0.200
     0.800     6.348     0.200
     0.800     6.048     0.200
     0.916     6.792     0.200
     0.954     6.748     0.200
     0.990     6.924     0.200
     1.076     7.029     0.200
     1.116     8.162     0.200
     1.134     8.048     0.200
     1.198     8.299     0.200
     1.197     8.416     0.200
     1.251     8.178     0.200
     1.264     8.437     0.200
     1.366     9.035     0.200
     1.370     8.900     0.200
     1.474     9.375     0.200
     1.494     9.043     0.200
     1.918    11.596     0.200
     2.017    11.741     0.200
     0.195     2.756     0.200
     0.241     2.563     0.200
     0.238     2.413     0.200
     0.433     3.644     0.200
     0.438     3.751     0.200
     0.503     4.246     0.200
     0.554     4.083     0.200
     0.560     3.689     0.200
     0.550     4.814     0.200
     0.559     5.214     0.200
     0.587     5.642     0.200
     0.597     4.139     0.200
     0.642     4.645     0.200
     0.725     5.484     0.200
     0.766     6.679     0.200
     0.818     6.093     0.200
     0.852     6.133     0.200
     0.895     6.381     0.200
     0.926     6.768     0.200
     0.944     6.994     0.200
     0.948     6.713     0.200
     0.957     6.877     0.200
     1.101     7.591     0.200
     1.106     7.400     0.200
     1.117     7.973     0.200
     1.288     8.311     0.200
     1.576    11.896     0.200
     0.144     1.897     0.200
     0.160     1.680     0.200
     0.177     1.534     0.200
     0.301     2.817     0.200
     0.356     4.546     0.200
     0.392     3.566     0.200
     0.409     3.413     0.200
     0.407     3.840     0.200
     0.414     2.961     0.200
     0.486     4.681     0.200
     0.520     4.028     0.200
     0.527     3.791     0.200
     0.535     5.544     0.200
     0.565     5.308     0.200
     0.571     4.428     0.200
     0.619     3.865     0.200
     0.637     5.231     0.200
     0.685     4.494     0.200
     0.719     5.212     0.200
     0.753     5.364     0.200
     0.916     6.666     0.200
     1.128     8.553     0.200
     1.161     7.430     0.200
     1.167     7.641     0.200
     1.190     7.964     0.200
     1.219     8.075     0.200
     1.342     8.316     0.200
     1.374     8.459     0.200
     1.543     8.862     0.200
     1.673     9.489     0.200
     0.089     1.964     0.200
     0.083     2.119     0.200
     0.254     3.505     0.200
     0.508     4.393     0.200
     0.650     5.216     0.200
     0.654     5.694     0.200
     0.734     6.052     0.200
     0.812     7.478     0.200
     0.829     5.789     0.200
     0.916     7.004     0.200
     0.991     7.012     0.200
     1.145     8.023     0.200
     1.147     7.630     0.200
     1.345     8.569     0.200
     1.374     8.671     0.200
     1.467     8.955     0.200
     1.491     9.442     0.200
     1.581     9.301     0.200
     1.749    10.475     0.200
     1.753    10.300     0.200
     1.889    11.381     0.200
     0.131     1.479     0.200
     0.131     1.378     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.229    24.397     0.200
     0.732    14.038     0.200
     1.302    23.484     0.200
     1.760    31.808     0.200
     1.859    28.878     0.200
     2.369    36.729     0.200
     4.564    64.018     0.200
     0.643    13.298     0.200
     1.029    19.186     0.200
     1.267    23.884     0.200
     1.267    24.509     0.200
     1.736    29.038     0.200
     2.005    33.695     0.200
     2.166    33.519     0.200
     2.358    36.986     0.200
     3.457    51.060     0.200
     3.527    52.643     0.200
     3.492    48.951     0.200
     0.576    13.546     0.200
     1.201    22.989     0.200
     1.415    21.558     0.200
     1.960    33.899     0.200
     3.467    47.312     0.200
     3.488    52.373     0.200
     4.737    64.192     0.200
     5.346    71.222     0.200
     1.415    25.634     0.200
     3.649    50.096     0.200
     7.251    97.956     0.200
    18.042   237.527     0.200
     2.507    43.198     0.200
     3.880    60.576     0.200
     4.012    62.044     0.200
     3.504    48.787     0.200
     1.038    23.155     0.200
     1.042    22.101     0.200
     1.018    23.084     0.200
     1.074    22.848     0.200
     1.224    26.498     0.200
     1.210    25.414     0.200
     1.899    34.772     0.200
     2.126    38.118     0.200
     2.842    48.363     0.200
     0.618    13.336     0.200
     0.747    15.432     0.200
     1.247    24.823     0.200
     1.063    21.318     0.200
     1.088    22.024     0.200
     1.154    23.363     0.200
     1.454    23.951     0.200
     1.505    26.162     0.200
     1.644    28.639     0.200
     2.769    41.908     0.200
     3.496    51.141     0.200
     0.991    21.271     0.200
     1.092    22.894     0.200
     1.115    22.528     0.200
     1.133    23.615     0.200
     1.170    23.386     0.200
     1.254    25.106     0.200
     1.590    29.378     0.200
     2.315    39.518     0.200
     2.390    41.042     0.200
     2.419    41.403     0.200
     2.487    42.809     0.200
     3.084    49.852     0.200
     3.691    58.268     0.200
     1.230    26.448     0.200
     3.201    50.950     0.200
     3.124    53.041     0.200
     1.199    24.237     0.200
     0.798    17.719     0.200
     0.936    20.015     0.200
     1.031    21.805     0.200
     1.190    24.254     0.200
     1.200    23.528     0.200
     0.874    19.807     0.200
     0.989    21.459     0.200
     0.870    20.160     0.200
    11.301   162.199     0.200
     1.178    24.377     0.200
     1.154    24.888     0.200
     1.318    23.158     0.200
     1.608    27.376     0.200
     1.608    26.871     0.200
     1.164    25.771     0.200
     1.165    25.744     0.200
     1.386    28.069     0.200
     2.956    51.950     0.200
     1.155    25.039     0.200
     1.156    25.974     0.200
     1.190    24.173     0.200
     1.176    23.898     0.200
     0.681    16.852     0.200
     0.862    20.945     0.200
     0.971    22.173     0.200
     0.978    21.187     0.200
     1.147    24.719     0.200
     1.138    24.671     0.200
     1.242    25.158     0.200
     1.254    25.022     0.200
     1.948    33.785     0.200
     2.236    36.684     0.200
     1.413    26.073     0.200
     0.851    19.958     0.200
     1.020    23.088     0.200
     1.076    23.140     0.200
     1.250    27.407     0.200
     1.172    24.232     0.200
     1.058    23.961     0.200
     1.154    25.739     0.200
     1.187    26.952     0.200
     3.592    55.915     0.200
     4.295    67.890     0.200
     0.880    20.235     0.200
     0.998    21.563     0.200
     1.099    23.579     0.200
     1.182    27.606     0.200
     1.175    25.384     0.200
     1.496    30.141     0.200
     2.855    49.676     0.200
     0.732    16.603     0.200
     1.001    23.062     0.200
     1.042    22.780     0.200
     1.186    25.303     0.200
     1.156    24.356     0.200
     1.212    25.496     0.200
     1.240    25.471     0.200
     1.062    22.802     0.200
     1.114    23.892     0.200
     1.292    26.013     0.200
     1.290    26.936     0.200
     1.023    22.006     0.200
     1.169    23.997     0.200
     1.062    23.246     0.200
     1.163    24.469     0.200
     0.678    15.524     0.200
     0.706    15.996     0.200
     0.749    16.696     0.200
     0.859    18.611     0.200
     0.861    17.988     0.200
     1.225    25.259     0.200
     1.226    25.456     0.200
     0.500    13.347     0.200
     0.509    14.039     0.200
     0.735    17.400     0.200
     0.790    16.964     0.200
     0.865    18.384     0.200
     0.867    18.060     0.200
     0.875    18.065     0.200
     0.952    18.874     0.200
     0.959    19.390     0.200
     0.986    19.777     0.200
     1.030    20.655     0.200
     1.064    20.057     0.200
     1.096    20.783     0.200
     1.139    20.889     0.200
     1.162    20.819     0.200
     1.318    23.494     0.200
     1.319    23.790     0.200
     1.344    24.196     0.200
     1.533    26.588     0.200
     1.705    27.980     0.200
     1.705    27.983     0.200
     1.880    30.545     0.200
     2.049    33.566     0.200
     2.362    36.118     0.200
     2.799    42.816     0.200
     3.219    46.414     0.200
     3.286    47.531     0.200
     4.442    64.738     0.200
     0.667    13.525     0.200
     0.815    13.837     0.200
     0.815    14.007     0.200
     0.794    16.443     0.200
     0.955    17.364     0.200
     0.927    17.791     0.200
     1.026    20.145     0.200
     1.089    19.006     0.200
     1.075    20.065     0.200
     1.139    20.626     0.200
     1.288    23.134     0.200
     1.348    22.585     0.200
     1.428    25.748     0.200
     1.487    26.165     0.200
     1.630    27.392     0.200
     1.630    27.086     0.200
     1.711    29.846     0.200
     2.165    33.352     0.200
     2.363    37.932     0.200
     3.108    46.544     0.200
     3.102    48.115     0.200
     3.529    52.634     0.200
     1.657    29.670     0.200
     0.960    21.336     0.200
     0.960    21.232     0.200
     0.919    20.592     0.200
     1.040    21.878     0.200
     1.143    24.559     0.200
     1.730    32.715     0.200
     2.913    49.406     0.200
     2.946    50.019     0.200
     3.001    49.882     0.200
     3.057    51.523     0.200
     3.292    54.485     0.200
     3.690    59.636     0.200
     0.905    18.935     0.200
     0.906    19.131     0.200
     0.928    20.277     0.200
     1.159    23.805     0.200
     1.225    24.338     0.200
     1.283    25.057     0.200
     1.296    26.009     0.200
     1.184    24.298     0.200
     3.483    55.066     0.200
     0.743    18.887     0.200
     1.133    23.173     0.200
     1.223    25.524     0.200
     0.931    20.899     0.200
     1.166    24.861     0.200
     1.231    23.691     0.200
     0.750    17.332     0.200
     0.853    18.829     0.200
     0.863    19.412     0.200
     0.998    21.431     0.200
     1.010    20.894     0.200
     1.049    24.046     0.200
     1.122    23.486     0.200
     1.233    25.098     0.200
     1.218    25.569     0.200
     1.198    24.216     0.200
     1.189    25.440     0.200
     1.211    25.483     0.200
     1.198    24.625     0.200
     1.257    25.445     0.200
     1.315    26.164     0.200
     0.916    20.292     0.200
     1.076    22.529     0.200
     1.134    23.247     0.200
     1.117    23.493     0.200
     0.780    18.082     0.200
     0.872    20.289     0.200
     1.128    24.513     0.200
     1.161    24.530     0.200
     1.167    25.271     0.200
     1.190    24.024     0.200
     1.219    25.185     0.200
     2.861    47.243     0.200
     2.918    48.801     0.200
     2.919    48.326     0.200
     3.508    55.786     0.200
     3.515    56.460     0.200
     0.512    14.204     0.200
     0.518    12.615     0.200
     0.678    15.403     0.200
     0.768    17.309     0.200
     0.779    15.449     0.200
     0.856    16.980     0.200
     0.918    19.387     0.200
     0.907    17.288     0.200
     1.181    22.767     0.200
     1.161    23.237     0.200
     1.299    24.270     0.200
     1.301    23.400     0.200
     1.382    24.867     0.200
     1.333    23.754     0.200
     1.467    27.094     0.200
     1.592    26.386     0.200
     1.413    24.684     0.200
     1.754    31.861     0.200
     1.569    26.109     0.200
     1.733    29.790     0.200
     1.599    24.265     0.200
     1.825    31.972     0.200
     1.724    28.754     0.200
     1.847    31.830     0.200
     2.222    37.861     0.200
     2.600    43.098     0.200
     2.314    36.265     0.200
     2.440    39.172     0.200
     2.921    41.695     0.200
     2.921    43.210     0.200
     3.641    52.618     0.200
     5.113    70.006     0.200
     0.991    21.332     0.200
     1.145    22.562     0.200
     1.143    18.837     0.200
     5.281    77.613     0.200
     3.464    57.135     0.200
     5.281    81.974     0.200
     6.645    91.113     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.095    67.884     0.200
     2.932    58.123     0.200
     3.620    70.601     0.200
     2.550    54.511     0.200
     2.608    55.195     0.200
     3.138    60.201     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.892    19.650     0.200
     1.437    29.488     0.200
     0.417     9.543     0.200
     0.417     9.392     0.200
     0.693    15.325     0.200
     0.881    18.830     0.200
     1.055    21.208     0.200
     0.464    10.786     0.200
     0.561    13.708     0.200
     0.622    14.396     0.200
     0.746    16.655     0.200
     1.364    27.234     0.200
     1.678    32.973     0.200
     1.851    34.054     0.200
     0.180     6.212     0.200
     0.211     6.601     0.200
     0.432     9.925     0.200
     0.768    16.596     0.200
     0.987    20.544     0.200
     0.485    11.037     0.200
     0.602    14.271     0.200
     0.634    14.598     0.200
     0.943    21.081     0.200
     1.044    20.305     0.200
     1.310    28.007     0.200
     1.425    29.764     0.200
     1.998    38.072     0.200
     2.393    45.260     0.200
     0.149     5.926     0.200
     0.296     7.806     0.200
     0.630    15.008     0.200
     0.733    15.706     0.200
     0.767    16.913     0.200
     0.752    17.582     0.200
     0.772    17.558     0.200
     0.905    20.105     0.200
     1.312    26.256     0.200
     1.481    28.078     0.200
     0.157     5.033     0.200
     0.184     5.113     0.200
     0.267     6.039     0.200
     0.282     5.965     0.200
     0.391     9.094     0.200
     0.437    10.261     0.200
     0.506    10.352     0.200
     0.527    12.508     0.200
     0.536    11.299     0.200
     0.642    14.968     0.200
     0.685    15.363     0.200
     0.702    15.164     0.200
     0.712    14.949     0.200
     0.735    15.883     0.200
     0.028     3.277     0.200
     0.227     6.189     0.200
     0.257     5.239     0.200
     0.414    10.531     0.200
     0.414     9.406     0.200
     0.447     9.115     0.200
     0.085     4.794     0.200
     0.217     5.246     0.200
     0.270     7.260     0.200
     0.634    15.179     0.200
     0.646    15.347     0.200
     0.857    19.182     0.200
     0.920    19.439     0.200
     1.017    21.409     0.200
     1.369    27.404     0.200
     1.361    29.004     0.200
     1.496    29.719     0.200
     0.057     3.327     0.200
     0.140     4.259     0.200
     0.178     4.618     0.200
     0.238     5.917     0.200
     0.332     7.820     0.200
     0.373     9.140     0.200
     0.503    11.728     0.200
     0.604    13.747     0.200
     0.667    14.213     0.200
     0.744    15.807     0.200
     0.223     4.457     0.200
     0.189     6.253     0.200
     0.503    11.391     0.200
     0.627    14.547     0.200
     1.003    19.853     0.200
     1.036    21.863     0.200
     0.245     7.525     0.200
     0.342     8.096     0.200
     0.427     9.701     0.200
     0.491    11.060     0.200
     0.550    11.165     0.200
     0.640    13.819     0.200
     0.655    14.149     0.200
     0.682    14.925     0.200
     0.721    16.069     0.200
     0.766    16.748     0.200
     0.793    16.336     0.200
     0.862    18.731     0.200
     0.323     8.400     0.200
     0.494    11.105     0.200
     0.545    11.307     0.200
     0.667    14.691     0.200
     0.689    14.832     0.200
     0.867    19.357     0.200
     0.108     3.580     0.200
     0.271     6.074     0.200
     0.331     7.679     0.200
     0.408     7.884     0.200
     0.656    13.685     0.200
     0.207     7.020     0.200
     0.294     6.402     0.200
     0.445     9.940     0.200
     0.485    10.076     0.200
     0.482    12.210     0.200
     0.538    11.558     0.200
     0.583    12.434     0.200
     0.598    13.957     0.200
     0.648    14.673     0.200
     0.786    16.867     0.200
     0.834    17.504     0.200
     0.818    18.184     0.200
     0.858    18.916     0.200
     0.899    19.448     0.200
     0.893    18.310     0.200
     1.184    24.111     0.200
     1.481    29.248     0.200
     1.502    29.807     0.200
     1.912    35.615     0.200
     0.187     4.748     0.200
     0.319     7.512     0.200
     0.472     9.968     0.200
     0.468    11.068     0.200
     0.511    11.668     0.200
     0.561    13.385     0.200
     0.611    14.104     0.200
     0.634    13.928     0.200
     0.667    13.341     0.200
     0.814    17.537     0.200
     0.804    17.243     0.200
     0.856    19.046     0.200
     1.041    21.887     0.200
     1.197    24.058     0.200
     1.484    30.313     0.200
     0.682    13.462     0.200
     0.800    17.192     0.200
     0.938    18.772     0.200
     0.970    18.905     0.200
     1.036    20.934     0.200
     1.105    20.534     0.200
     1.856    34.061     0.200
     0.371     9.406     0.200
     0.550    12.116     0.200
     0.597    12.066     0.200
     0.582    12.550     0.200
     0.665    14.282     0.200
     0.665    14.476     0.200
     0.974    20.068     0.200
     1.362    26.746     0.200
     1.382    28.608     0.200
     1.371    27.339     0.200
     1.471    28.768     0.200
     1.499    28.847     0.200
     1.607    30.380     0.200
     1.634    32.170     0.200
     1.759    33.714     0.200
     0.229     6.568     0.200
     0.510    11.486     0.200
     0.635    13.326     0.200
     0.643    14.045     0.200
     0.662    14.821     0.200
     0.780    17.138     0.200
     0.830    16.957     0.200
     0.899    18.352     0.200
     0.964    19.952     0.200
     0.945    20.975     0.200
     0.937    21.566     0.200
     1.068    21.836     0.200
     1.053    21.914     0.200
     1.088    23.410     0.200
     1.455    29.525     0.200
     1.507    30.712     0.200
     1.508    30.807     0.200
     1.739    34.902     0.200
     1.887    36.283     0.200
     0.213     6.251     0.200
     0.445    10.644     0.200
     0.471    12.136     0.200
     0.491    11.003     0.200
     0.808    17.304     0.200
     0.886    17.796     0.200
     1.195    23.386     0.200
     0.198     5.829     0.200
     0.305     7.272     0.200
     0.497    11.337     0.200
     0.475    12.795     0.200
     0.586    12.603     0.200
     0.605    12.875     0.200
     0.614    13.273     0.200
     0.629    13.893     0.200
     0.967    19.752     0.200
     0.098     4.855     0.200
     0.262     7.373     0.200
     0.646    14.563     0.200
     0.650    15.811     0.200
     0.613    14.449     0.200
     0.565    14.109     0.200
     0.931    19.638     0.200
     1.467    30.080     0.200
     0.094     4.813     0.200
     0.249     4.807     0.200
     0.323     8.543     0.200
     0.577    14.073     0.200
     0.640    14.635     0.200
     0.658    15.730     0.200
     0.650    15.816     0.200
     0.824    18.288     0.200
     0.926    19.303     0.200
     0.996    21.382     0.200
     1.659    33.041     0.200
     0.093     5.378     0.200
     0.237     5.690     0.200
     0.479    10.746     0.200
     0.493    10.788     0.200
     0.661    14.823     0.200
     0.794    17.290     0.200
     0.168     5.249     0.200
     0.264     6.036     0.200
     0.395     9.510     0.200
     0.455    10.503     0.200
     0.447    10.904     0.200
     0.459    10.663     0.200
     0.603    13.083     0.200
     0.748    15.688     0.200
     0.192     5.129     0.200
     0.345     9.250     0.200
     0.369     9.169     0.200
     0.425    10.518     0.200
     0.460    10.603     0.200
     0.473    11.160     0.200
     0.197     4.924     0.200
     0.360     9.322     0.200
     0.383     9.548     0.200
     0.427    10.242     0.200
     0.445    10.033     0.200
     0.481    10.409     0.200
     0.649    13.657     0.200
     0.630    13.973     0.200
     0.748    15.698     0.200
     0.847    17.546     0.200
     1.032    21.481     0.200
     1.396    26.640     0.200
     1.656    33.200     0.200
     0.170     5.472     0.200
     0.215     6.246     0.200
     0.282     6.260     0.200
     0.374     9.089     0.200
     0.377    10.447     0.200
     0.446    10.443     0.200
     0.452    10.471     0.200
     0.532    12.440     0.200
     0.621    14.210     0.200
     0.729    15.538     0.200
     1.040    21.717     0.200
     1.401    27.903     0.200
     1.639    31.925     0.200
     0.122     4.284     0.200
     0.141     4.061     0.200
     0.210     5.551     0.200
     0.285     7.082     0.200
     0.373     9.349     0.200
     0.442    10.345     0.200
     0.456    10.380     0.200
     0.463    10.306     0.200
     0.540    12.304     0.200
     0.829    17.532     0.200
     0.600    13.930     0.200
     0.740    16.003     0.200
     0.860    17.898     0.200
     0.888    18.076     0.200
     0.934    18.636     0.200
     0.959    20.044     0.200
     0.992    19.856     0.200
     1.028    20.336     0.200
     1.025    19.678     0.200
     1.097    20.937     0.200
     1.229    24.571     0.200
     1.360    26.761     0.200
     1.421    27.549     0.200
     1.503    27.301     0.200
     1.643    30.264     0.200
     0.120     3.760     0.200
     0.180     4.559     0.200
     0.204     4.567     0.200
     0.290     6.875     0.200
     0.436    10.165     0.200
     0.461    10.670     0.200
     0.462    10.759     0.200
     0.463    10.360     0.200
     0.731    15.928     0.200
     0.146     4.817     0.200
     0.183     6.292     0.200
     0.212     5.051     0.200
     0.300     7.222     0.200
     0.367     7.443     0.200
     0.386     7.616     0.200
     0.416     9.570     0.200
     0.480    10.525     0.200
     0.164     4.494     0.200
     0.469    10.044     0.200
     0.477    10.450     0.200
     0.113     3.640     0.200
     0.174     4.128     0.200
     0.292     7.143     0.200
     0.438    10.336     0.200
     0.454    10.759     0.200
     0.721    15.831     0.200
     1.390    28.127     0.200
     1.648    32.520     0.200
     0.111     3.550     0.200
     0.335     8.832     0.200
     0.363     9.316     0.200
     0.297     6.978     0.200
     0.432    10.300     0.200
     0.460    10.683     0.200
     0.471    10.353     0.200
     0.662    14.118     0.200
     0.697    14.609     0.200
     0.722    15.710     0.200
     1.537    33.110     0.200
     1.654    33.248     0.200
     1.795    36.604     0.200
     3.165    60.307     0.200
     0.070     2.886     0.200
     0.150     3.558     0.200
     0.283     7.004     0.200
     0.282     6.409     0.200
     0.650    13.825     0.200
     1.575    30.531     0.200
     0.119     3.886     0.200
     0.149     4.435     0.200
     0.191     5.956     0.200
     0.194     5.109     0.200
     0.370     9.357     0.200
     0.426    10.398     0.200
     0.459    11.217     0.200
     0.694    14.586     0.200
     1.387    27.887     0.200
     0.141     4.373     0.200
     0.171     5.217     0.200
     0.284     6.902     0.200
     0.445    10.519     0.200
     0.465    10.695     0.200
     0.622    14.153     0.200
     0.710    14.624     0.200
     1.399    27.381     0.200
     1.640    32.270     0.200
     0.143     3.600     0.200
     0.175     5.118     0.200
     0.287     6.717     0.200
     0.441    10.420     0.200
     0.464    10.653     0.200
     0.706    14.623     0.200
     1.396    27.266     0.200
     1.644    32.473     0.200
     0.111     3.904     0.200
     0.154     4.090     0.200
     0.429    10.084     0.200
     0.463    10.889     0.200
     0.470    10.810     0.200
     1.384    28.136     0.200
     1.656    33.364     0.200
     0.174     4.784     0.200
     0.147     3.906     0.200
     0.231     5.730     0.200
     0.159     4.273     0.200
     0.134     3.558     0.200
     0.187     3.942     0.200
     0.223     5.029     0.200
     0.291     6.326     0.200
     0.352     8.820     0.200
     0.389     7.883     0.200
     0.408     8.069     0.200
     0.420     9.927     0.200
     0.416     9.973     0.200
     0.475    10.580     0.200
     0.509    11.281     0.200
     1.620    31.422     0.200
     0.207     5.710     0.200
     0.291     6.930     0.200
     0.424    10.267     0.200
     0.433    10.362     0.200
     0.471    11.128     0.200
     0.642    13.729     0.200
     0.760    16.257     0.200
     1.399    28.490     0.200
     0.137     4.379     0.200
     0.195     5.404     0.200
     0.135     4.502     0.200
     0.199     4.463     0.200
     0.527    11.759     0.200
     0.285     8.177     0.200
     0.285     8.374     0.200
     0.469    10.837     0.200
     0.599    14.219     0.200
     0.592    14.002     0.200
     0.646    14.968     0.200
     1.269    25.690     0.200
     1.338    27.288     0.200
     1.379    27.506     0.200
     1.463    29.036     0.200
     1.710    32.953     0.200
     0.240     5.593     0.200
     0.243     6.364     0.200
     0.266     6.588     0.200
     0.320     7.764     0.200
     0.350     9.113     0.200
     0.410    10.615     0.200
     0.556    12.811     0.200
     0.567    13.787     0.200
     0.579    13.444     0.200
     0.629    14.259     0.200
     0.654    13.668     0.200
     1.490    27.908     0.200
     1.495    29.051     0.200
     0.120     4.176     0.200
     0.146     4.079     0.200
     0.181     4.969     0.200
     0.397    10.441     0.200
     0.450    10.730     0.200
     0.608    13.688     0.200
     0.755    15.771     0.200
     0.206     7.150     0.200
     0.242     8.023     0.200
     0.404    10.239     0.200
     0.404    10.244     0.200
     0.453    11.270     0.200
     0.700    15.984     0.200
     0.126     4.786     0.200
     0.165     5.634     0.200
     0.195     5.687     0.200
     0.283     8.052     0.200
     0.395    10.056     0.200
     0.410    11.277     0.200
     0.427    10.576     0.200
     0.508    11.832     0.200
     0.576    13.243     0.200
     0.703    15.057     0.200
     0.783    16.722     0.200
     1.117    21.630     0.200
     0.088     5.470     0.200
     0.198     5.889     0.200
     0.183     5.360     0.200
     0.209     7.260     0.200
     0.258     7.281     0.200
     0.277     7.660     0.200
     0.277     7.785     0.200
     0.382     9.936     0.200
     0.444    11.210     0.200
     0.628    14.667     0.200
     0.627    13.576     0.200
     0.647    14.051     0.200
     0.757    16.163     0.200
     0.791    17.361     0.200
     0.846    18.725     0.200
     0.893    18.868     0.200
     0.914    19.024     0.200
     0.898    19.016     0.200
     1.029    21.688     0.200
     1.328    26.701     0.200
     1.511    29.362     0.200
     1.659    31.038     0.200
     2.369    43.147     0.200
     0.181     4.794     0.200
     0.152     4.428     0.200
     0.208     5.980     0.200
     0.357     9.844     0.200
     0.414     9.973     0.200
     0.304     7.255     0.200
     0.543    11.669     0.200
     0.448    10.074     0.200
     0.490    10.987     0.200
     0.637    13.774     0.200
     0.684    14.325     0.200
     0.745    16.507     0.200
     0.642    14.705     0.200
     0.769    16.332     0.200
     0.740    16.769     0.200
     1.020    22.007     0.200
     1.384    28.156     0.200
     1.534    32.009     0.200
     1.669    33.625     0.200
     2.319    44.348     0.200
     3.696    69.878     0.200
     0.186     3.851     0.200
     0.269     6.190     0.200
     0.357     7.465     0.200
     0.369     9.124     0.200
     0.477    11.058     0.200
     0.508    10.196     0.200
     0.611    12.397     0.200
     0.606    13.660     0.200
     0.686    13.923     0.200
     0.152     5.136     0.200
     0.191     6.882     0.200
     0.224     5.293     0.200
     0.294     7.478     0.200
     0.336     8.687     0.200
     0.399     9.647     0.200
     0.397     9.272     0.200
     0.610    14.391     0.200
     0.616    14.219     0.200
     0.600    12.899     0.200
     0.749    16.862     0.200
     0.795    17.632     0.200
     0.896    18.551     0.200
     1.515    31.326     0.200
     1.636    31.019     0.200
     1.981    38.887     0.200
     0.495    10.641     0.200
     0.517    10.261     0.200
     0.487    11.715     0.200
     0.591    10.597     0.200
     0.635    14.782     0.200
     0.832    16.784     0.200
     0.821    18.412     0.200
     0.822    18.807     0.200
     0.852    19.053     0.200
     0.982    21.241     0.200
     1.215    25.918     0.200
     1.549    31.617     0.200
     1.795    35.649     0.200
     0.616    13.557     0.200
     0.633    13.455     0.200
     0.659    14.948     0.200
     0.920    19.710     0.200
     1.406    28.331     0.200
     1.483    29.334     0.200
     1.556    31.982     0.200
     1.607    30.697     0.200
     1.627    31.555     0.200
     1.732    34.732     0.200
     1.813    34.986     0.200
     1.885    36.046     0.200
     1.895    36.530     0.200
     2.122    40.375     0.200
     2.087    38.485     0.200
     0.665    15.835     0.200
     0.983    21.925     0.200
     1.047    21.471     0.200
     1.066    22.648     0.200
     1.555    29.942     0.200
     1.693    33.633     0.200
     1.766    34.484     0.200
     1.887    35.966     0.200
     0.114     4.110     0.200
     0.195     5.766     0.200
     0.188     5.346     0.200
     0.340     9.370     0.200
     0.365     9.973     0.200
     0.403     9.634     0.200
     0.427    10.061     0.200
     0.299     7.144     0.200
     0.530    11.950     0.200
     0.468    10.278     0.200
     0.465    10.414     0.200
     0.472    11.426     0.200
     0.655    14.398     0.200
     0.693    14.556     0.200
     0.728    15.345     0.200
     0.638    13.892     0.200
     0.786    16.563     0.200
     0.845    17.751     0.200
     0.845    17.380     0.200
     0.941    20.259     0.200
     1.385    27.382     0.200
     1.542    31.738     0.200
     1.658    32.785     0.200
     1.912    37.324     0.200
     0.241     6.427     0.200
     0.424    10.196     0.200
     0.504    11.356     0.200
     0.518    11.797     0.200
     0.610    13.332     0.200
     0.633    13.754     0.200
     0.672    14.903     0.200
     0.683    14.274     0.200
     0.692    15.373     0.200
     0.729    15.335     0.200
     0.847    17.665     0.200
     0.875    18.731     0.200
     1.235    24.029     0.200
     0.196     3.906     0.200
     0.346     7.957     0.200
     0.324     7.805     0.200
     0.399    10.027     0.200
     0.444    10.209     0.200
     0.515    10.281     0.200
     0.566    12.082     0.200
     0.673    13.832     0.200
     0.686    14.689     0.200
     0.689    13.950     0.200
     0.872    18.917     0.200
     0.074     6.372     0.200
     0.079     6.120     0.200
     0.239     8.144     0.200
     0.265     9.047     0.200
     0.471    12.338     0.200
     0.505    12.337     0.200
     0.617    14.438     0.200
     1.051    21.170     0.200
     1.114    21.939     0.200
     1.131    22.741     0.200
     0.319     8.833     0.200
     0.350     9.968     0.200
     0.578    13.014     0.200
     0.638    13.808     0.200
     0.651    15.159     0.200
     0.721    15.342     0.200
     0.765    16.634     0.200
     0.822    16.660     0.200
     1.144    22.308     0.200
     1.621    30.442     0.200
     0.116     3.547     0.200
     0.188     5.514     0.200
     0.196     5.422     0.200
     0.297     8.235     0.200
     0.343     9.107     0.200
     0.368     8.811     0.200
     0.406     9.073     0.200
     0.385    10.019     0.200
     0.428    10.015     0.200
     0.469    10.738     0.200
     0.471    11.112     0.200
     0.463    11.109     0.200
     0.636    14.482     0.200
     0.655    14.261     0.200
     0.694    14.205     0.200
     0.730    15.283     0.200
     0.844    17.460     0.200
     0.117     5.067     0.200
     0.305     6.778     0.200
     0.437     9.734     0.200
     0.493    10.185     0.200
     0.555    11.757     0.200
     0.553    13.177     0.200
     0.773    16.214     0.200
     0.823    17.637     0.200
     0.926    20.430     0.200
     0.963    19.794     0.200
     1.036    20.843     0.200
     1.088    22.643     0.200
     0.131     4.683     0.200
     0.286     6.471     0.200
     0.349     7.636     0.200
     0.436     9.427     0.200
     0.475    10.062     0.200
     0.543    12.170     0.200
     0.627    14.398     0.200
     0.816    17.487     0.200
     0.958    20.425     0.200
     0.959    20.324     0.200
     0.971    19.583     0.200
     1.037    20.812     0.200
     0.307     6.620     0.200
     0.383     8.326     0.200
     0.416     9.939     0.200
     0.491    10.170     0.200
     0.543    11.956     0.200
     0.564    12.621     0.200
     0.628    12.973     0.200
     0.653    14.881     0.200
     0.761    16.421     0.200
     0.805    16.805     0.200
     0.817    17.164     0.200
     0.909    20.188     0.200
     0.982    20.633     0.200
     0.983    20.731     0.200
     1.034    21.635     0.200
     1.014    21.163     0.200
     1.070    22.613     0.200
     1.393    28.040     0.200
     1.639    33.170     0.200
     1.938    38.087     0.200
     0.183     5.657     0.200
     0.284     7.287     0.200
     0.457    11.166     0.200
     0.478    11.322     0.200
     0.507    12.479     0.200
     0.552    13.155     0.200
     0.560    11.465     0.200
     0.602    13.577     0.200
     0.615    13.223     0.200
     0.674    15.241     0.200
     0.792    16.155     0.200
     0.844    17.453     0.200
     1.236    24.073     0.200
     0.106     4.487     0.200
     0.271     6.872     0.200
     0.333     8.044     0.200
     0.346     8.096     0.200
     0.340     8.558     0.200
     0.407     9.176     0.200
     0.563    12.558     0.200
     0.583    12.831     0.200
     0.650    12.641     0.200
     0.744    15.449     0.200
     0.925    19.333     0.200
     1.011    21.030     0.200
     2.187    40.306     0.200
     0.150     4.760     0.200
     0.184     5.469     0.200
     0.217     6.587     0.200
     0.373     9.458     0.200
     0.350    10.033     0.200
     0.402     9.522     0.200
     0.440     9.486     0.200
     0.450    11.162     0.200
     0.433    10.657     0.200
     0.445    10.716     0.200
     0.471    11.013     0.200
     0.509    12.074     0.200
     0.532    12.504     0.200
     0.568    12.893     0.200
     0.570    12.861     0.200
     0.606    14.348     0.200
     0.721    15.103     0.200
     0.760    16.446     0.200
     0.825    17.484     0.200
     1.420    28.051     0.200
     0.193     4.913     0.200
     0.243     6.527     0.200
     0.261     7.215     0.200
     0.403    10.567     0.200
     0.499    12.632     0.200
     0.574    12.266     0.200
     0.593    13.739     0.200
     0.927    18.848     0.200
     0.215     5.408     0.200
     0.234     7.094     0.200
     0.296     6.676     0.200
     0.483    10.287     0.200
     0.512    11.346     0.200
     0.468    11.264     0.200
     0.570    12.377     0.200
     0.600    13.123     0.200
     0.627    14.106     0.200
     1.203    24.482     0.200
     0.269     8.551     0.200
     0.368     8.800     0.200
     0.536    12.841     0.200
     0.195     6.748     0.200
     0.277     6.093     0.200
     0.404     8.916     0.200
     0.763    16.321     0.200
     1.256    24.782     0.200
     1.556    30.664     0.200
     0.272     8.300     0.200
     0.541    13.457     0.200
     0.744    16.487     0.200
     0.717    16.505     0.200
     1.581    29.217     0.200
     1.768    32.030     0.200
     2.076    37.441     0.200
     0.268     5.999     0.200
     0.380     8.993     0.200
     0.530    12.841     0.200
     0.704    16.214     0.200
     1.210    23.399     0.200
     1.347    27.106     0.200
     1.601    32.148     0.200
     1.783    34.720     0.200
     0.046     4.941     0.200
     0.411    10.882     0.200
     0.601    13.667     0.200
     0.613    13.735     0.200
     0.599    13.590     0.200
     0.595    14.735     0.200
     0.628    14.149     0.200
     0.680    15.946     0.200
     0.839    17.490     0.200
     0.844    18.431     0.200
     0.871    18.523     0.200
     1.343    25.907     0.200
     1.351    27.119     0.200
     1.398    28.163     0.200
     1.638    31.270     0.200
     0.142     4.438     0.200
     0.167     4.442     0.200
     0.296     7.533     0.200
     0.357     9.033     0.200
     0.362     7.973     0.200
     0.444    10.816     0.200
     0.515    12.088     0.200
     0.502    10.632     0.200
     0.532    11.987     0.200
     0.570    13.544     0.200
     0.599    12.407     0.200
     0.662    15.566     0.200
     0.687    16.175     0.200
     0.698    14.845     0.200
     0.786    17.821     0.200
     0.796    18.608     0.200
     0.909    19.485     0.200
     0.996    21.272     0.200
     1.133    23.067     0.200
     1.471    29.124     0.200
     0.136     4.136     0.200
     0.146     4.921     0.200
     0.362     8.493     0.200
     0.436     8.830     0.200
     0.474    10.784     0.200
     0.525    11.398     0.200
     0.554    12.260     0.200
     0.579    12.066     0.200
     0.674    14.755     0.200
     0.807    18.006     0.200
     0.908    20.425     0.200
     0.310     7.915     0.200
     0.291     7.219     0.200
     0.359     8.216     0.200
     0.359     9.118     0.200
     0.495    10.735     0.200
     0.519    12.348     0.200
     0.570    12.659     0.200
     0.607    12.724     0.200
     0.651    14.416     0.200
     0.700    16.236     0.200
     0.776    17.054     0.200
     0.958    20.733     0.200
     1.000    21.243     0.200
     1.046    22.107     0.200
     1.497    29.240     0.200
     1.473    29.325     0.200
     1.759    32.686     0.200
     1.788    33.849     0.200
     0.129     3.672     0.200
     0.303     8.572     0.200
     0.305     9.019     0.200
     0.354     9.156     0.200
     0.516    11.963     0.200
     0.508    12.650     0.200
     0.586    13.238     0.200
     0.570    13.734     0.200
     0.689    16.544     0.200
     0.695    14.570     0.200
     0.678    15.873     0.200
     0.797    17.183     0.200
     0.800    17.848     0.200
     0.800    17.646     0.200
     0.954    20.447     0.200
     0.195     6.086     0.200
     0.433     9.464     0.200
     0.438    10.411     0.200
     0.503    10.816     0.200
     0.642    14.425     0.200
     0.725    15.805     0.200
     0.957    19.728     0.200
     1.106    22.419     0.200
     1.394    27.125     0.200
     0.144     5.397     0.200
     0.160     5.899     0.200
     0.177     5.964     0.200
     0.234     7.427     0.200
     0.301     7.797     0.200
     0.356    10.645     0.200
     0.392    10.006     0.200
     0.409    10.173     0.200
     0.407    10.700     0.200
     0.414    10.831     0.200
     0.486    11.880     0.200
     0.520    11.668     0.200
     0.527    11.561     0.200
     0.565    13.438     0.200
     0.571    13.288     0.200
     0.637    14.300     0.200
     0.719    16.161     0.200
     0.753    15.693     0.200
     1.374    28.279     0.200
     1.397    26.930     0.200
     1.516    29.606     0.200
     1.543    30.353     0.200
     1.624    31.176     0.200
     1.673    32.219     0.200
     1.782    33.891     0.200
     3.387    61.572     0.200
     0.254     7.927     0.200
     0.508    10.940     0.200
     0.524    11.088     0.200
     0.650    13.958     0.200
     0.654    14.276     0.200
     1.169    23.872     0.200
     1.749    32.772     0.200
     0.131     4.029     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
