#!/bin/bash
gmt begin bandung1.79_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance bandung1.79'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.7  0.000
  0.7 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.600    13.791
     0.700    15.166
     0.800    16.541
     0.900    17.916
     1.000    19.292
     1.100    20.667
     1.200    22.042
     1.300    23.417
     1.400    24.792
     1.500    26.167
     1.600    27.542
     1.700    28.918
     1.800    30.293
     1.900    31.668
     2.000    33.043
     2.100    34.418
     2.200    35.793
     2.300    37.168
     2.400    38.544
     2.500    39.919
     2.600    41.293
     2.700    42.668
     2.800    44.042
     2.900    45.416
     3.000    46.790
     3.100    48.164
     3.200    49.538
     3.300    50.912
     3.400    52.286
     3.500    53.659
     3.600    55.032
     3.700    56.405
     3.800    57.778
     3.900    59.151
     4.000    60.524
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    53.032 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     3.431
     0.200     4.771
     0.300     6.411
     0.400     8.171
     0.500     9.988
     0.600    11.835
     0.700    13.702
     0.800    15.480
     0.900    17.186
     1.000    18.891
     1.100    20.596
     1.200    22.302
     1.300    24.007
     1.400    25.712
     1.500    27.417
     1.600    29.123
     1.700    30.828
     1.800    32.533
     1.900    34.238
     2.000    35.944
     2.100    37.649
     2.200    39.354
     2.300    41.059
     2.400    42.764
     2.500    44.469
     2.600    46.174
     2.700    47.879
     2.800    49.584
     2.900    51.289
     3.000    52.994
     3.100    54.699
     3.200    56.404
     3.300    58.109
     3.400    59.813
     3.500    61.518
     3.600    63.222
     3.700    64.927
     3.800    66.632
     3.900    68.336
     4.000    70.041
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    62.222 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.700    25.954
     0.800    28.422
     0.900    30.890
     1.000    33.358
     1.100    35.826
     1.200    38.294
     1.300    40.762
     1.400    43.230
     1.500    45.698
     1.600    48.167
     1.700    50.635
     1.800    53.103
     1.900    55.571
     2.000    58.039
     2.100    60.507
     2.200    62.975
     2.300    65.443
     2.400    67.911
     2.500    70.379
     2.600    72.847
     2.700    75.315
     2.800    77.784
     2.900    80.252
     3.000    82.720
     3.100    85.188
     3.200    87.655
     3.300    90.123
     3.400    92.590
     3.500    95.056
     3.600    97.523
     3.700    99.990
     3.800   102.457
     3.900   104.924
     4.000   107.390
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    95.523 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     5.939
     0.200     8.261
     0.300    11.099
     0.400    14.146
     0.500    17.292
     0.600    20.491
     0.700    23.624
     0.800    26.503
     0.900    29.382
     1.000    32.261
     1.100    35.140
     1.200    38.019
     1.300    40.898
     1.400    43.777
     1.500    46.656
     1.600    49.535
     1.700    52.414
     1.800    55.293
     1.900    58.172
     2.000    61.051
     2.100    63.930
     2.200    66.808
     2.300    69.687
     2.400    72.566
     2.500    75.444
     2.600    78.323
     2.700    81.202
     2.800    84.080
     2.900    86.959
     3.000    89.837
     3.100    92.715
     3.200    95.594
     3.300    98.472
     3.400   101.350
     3.500   104.229
     3.600   107.106
     3.700   109.984
     3.800   112.862
     3.900   115.740
     4.000   118.618
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   106.106 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.800    18.282
     0.900    19.657
     1.000    21.032
     1.100    22.407
     1.200    23.782
     1.300    25.157
     1.400    26.532
     1.500    27.908
     1.600    29.283
     1.700    30.658
     1.800    32.033
     1.900    33.408
     2.000    34.783
     2.100    36.158
     2.200    37.533
     2.300    38.909
     2.400    40.284
     2.500    41.659
     2.600    43.034
     2.700    44.409
     2.800    45.783
     2.900    47.158
     3.000    48.532
     3.100    49.906
     3.200    51.280
     3.300    52.654
     3.400    54.028
     3.500    55.402
     3.600    56.775
     3.700    58.148
     3.800    59.521
     3.900    60.894
     4.000    62.267
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     1.948
     0.200     3.849
     0.300     5.761
     0.400     7.675
     0.500     9.590
     0.600    11.506
     0.700    13.422
     0.800    15.338
     0.900    17.255
     1.000    19.171
     1.100    21.088
     1.200    23.004
     1.300    24.921
     1.400    26.838
     1.500    28.554
     1.600    30.259
     1.700    31.965
     1.800    33.670
     1.900    35.375
     2.000    37.080
     2.100    38.785
     2.200    40.491
     2.300    42.196
     2.400    43.901
     2.500    45.607
     2.600    47.312
     2.700    49.017
     2.800    50.722
     2.900    52.427
     3.000    54.132
     3.100    55.836
     3.200    57.542
     3.300    59.246
     3.400    60.951
     3.500    62.656
     3.600    64.361
     3.700    66.066
     3.800    67.771
     3.900    69.475
     4.000    71.180
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    33.781
     1.000    36.249
     1.100    38.717
     1.200    41.185
     1.300    43.653
     1.400    46.121
     1.500    48.589
     1.600    51.058
     1.700    53.526
     1.800    55.994
     1.900    58.462
     2.000    60.930
     2.100    63.398
     2.200    65.866
     2.300    68.334
     2.400    70.802
     2.500    73.270
     2.600    75.738
     2.700    78.206
     2.800    80.674
     2.900    83.143
     3.000    85.611
     3.100    88.079
     3.200    90.547
     3.300    93.015
     3.400    95.482
     3.500    97.949
     3.600   100.416
     3.700   102.883
     3.800   105.349
     3.900   107.816
     4.000   110.283
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.372
     0.200     6.664
     0.300     9.974
     0.400    13.288
     0.500    16.604
     0.600    19.921
     0.700    23.239
     0.800    26.556
     0.900    29.874
     1.000    33.192
     1.100    36.510
     1.200    39.828
     1.300    43.044
     1.400    45.923
     1.500    48.802
     1.600    51.681
     1.700    54.560
     1.800    57.439
     1.900    60.318
     2.000    63.197
     2.100    66.076
     2.200    68.955
     2.300    71.834
     2.400    74.713
     2.500    77.591
     2.600    80.470
     2.700    83.349
     2.800    86.228
     2.900    89.106
     3.000    91.985
     3.100    94.863
     3.200    97.742
     3.300   100.620
     3.400   103.498
     3.500   106.376
     3.600   109.255
     3.700   112.133
     3.800   115.010
     3.900   117.888
     4.000   120.766
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.521
     0.200     8.978
     0.300     9.688
     0.400    10.592
     0.500    11.639
     0.600    12.786
     0.700    14.000
     0.800    15.259
     0.900    16.548
     1.000    17.858
     1.100    19.181
     1.200    20.515
     1.300    21.856
     1.400    23.202
     1.500    24.552
     1.600    25.905
     1.700    27.261
     1.800    28.618
     1.900    29.977
     2.000    31.337
     2.100    32.699
     2.200    34.061
     2.300    35.424
     2.400    36.787
     2.500    38.151
     2.600    39.515
     2.700    40.880
     2.800    42.245
     2.900    43.610
     3.000    44.975
     3.100    46.341
     3.200    47.707
     3.300    49.072
     3.400    50.438
     3.500    51.804
     3.600    53.170
     3.700    54.535
     3.800    55.901
     3.900    57.267
     4.000    58.632
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    14.828
     0.200    15.628
     0.300    16.871
     0.400    18.459
     0.500    20.303
     0.600    22.328
     0.700    24.480
     0.800    26.719
     0.900    29.018
     1.000    31.358
     1.100    33.727
     1.200    36.116
     1.300    38.520
     1.400    40.934
     1.500    43.357
     1.600    45.786
     1.700    48.220
     1.800    50.658
     1.900    53.100
     2.000    55.544
     2.100    57.989
     2.200    60.437
     2.300    62.886
     2.400    65.337
     2.500    67.788
     2.600    70.241
     2.700    72.694
     2.800    75.148
     2.900    77.603
     3.000    80.057
     3.100    82.512
     3.200    84.968
     3.300    87.424
     3.400    89.880
     3.500    92.337
     3.600    94.794
     3.700    97.251
     3.800    99.708
     3.900   102.165
     4.000   104.623
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     0.589    11.891     0.200
     0.957    17.586     0.200
     0.902    14.789     0.200
     1.229    21.586     0.200
     1.473    22.891     0.200
     1.725    29.289     0.200
     1.781    28.789     0.200
     1.933    31.688     0.200
     2.193    34.391     0.200
     2.365    37.289     0.200
     3.023    46.391     0.200
     3.388    51.188     0.200
     3.544    53.891     0.200
     3.544    53.266     0.200
     3.655    55.289     0.200
     3.525    52.086     0.200
     3.923    57.586     0.200
     4.051    60.289     0.200
     4.362    64.789     0.200
     4.486    67.289     0.200
     4.761    69.492     0.200
     4.796    69.188     0.200
     4.957    73.789     0.200
     5.134    75.789     0.200
     5.284    77.086     0.200
     5.301    77.188     0.200
     5.381    79.586     0.200
     5.442    79.891     0.200
     5.553    80.188     0.200
     5.738    84.391     0.200
     6.001    88.086     0.200
     6.045    87.391     0.200
     6.652    95.789     0.200
     6.571    95.789     0.200
     6.953   101.688     0.200
     7.031   102.188     0.200
     6.992   100.992     0.200
     7.140   102.789     0.200
     7.140   101.016     0.200
     7.203   103.992     0.200
     7.327   105.492     0.200
     7.725   111.891     0.200
     8.149   116.789     0.200
     8.172   117.188     0.200
     8.199   117.289     0.200
     8.588   121.086     0.200
     8.571   122.688     0.200
     9.070   130.492     0.200
     9.083   130.586     0.200
     9.055   129.086     0.200
     9.870   140.266     0.200
     9.859   137.992     0.200
    10.094   143.805     0.200
    10.066   142.086     0.200
    10.066   141.828     0.200
    10.194   141.992     0.200
    10.479   149.227     0.200
    11.334   157.289     0.200
    11.521   163.898     0.200
    11.634   161.391     0.200
    13.020   181.406     0.200
    13.020   184.188     0.200
    13.020   183.688     0.200
    13.072   178.992     0.200
    13.072   177.938     0.200
    13.215   180.812     0.200
    13.215   181.086     0.200
    13.315   188.586     0.200
    13.315   188.188     0.200
    13.297   183.188     0.200
    13.631   190.336     0.200
    13.664   192.500     0.200
    13.535   190.586     0.200
    13.664   193.289     0.200
    13.644   191.688     0.200
    14.071   197.688     0.200
    16.625   229.688     0.200
    17.212   234.391     0.200
    17.200   233.086     0.200
    18.930   258.586     0.200
     1.955    32.555     0.200
     2.097    34.758     0.200
     2.402    39.359     0.200
     2.429    39.453     0.200
     3.073    50.359     0.200
     3.323    52.156     0.200
     3.854    58.953     0.200
     3.854    58.773     0.200
     4.071    63.156     0.200
     4.265    66.555     0.200
     4.248    67.758     0.200
     4.347    68.656     0.200
     4.347    68.359     0.200
     4.439    67.859     0.200
     4.653    68.953     0.200
     4.771    73.258     0.200
     5.330    81.055     0.200
     5.653    84.453     0.200
     5.873    86.156     0.200
     6.529    97.758     0.200
     6.970   102.758     0.200
     7.695   113.453     0.200
     7.678   112.359     0.200
     7.779   113.859     0.200
     7.957   115.859     0.200
     8.459   122.859     0.200
     8.666   126.258     0.200
     8.992   130.859     0.200
     8.992   131.195     0.200
    10.291   147.156     0.200
    10.656   151.359     0.200
    12.071   168.555     0.200
    12.149   168.453     0.200
    12.149   169.305     0.200
    13.564   193.758     0.200
    13.517   189.156     0.200
    13.690   195.156     0.200
    15.634   218.578     0.200
    17.153   235.453     0.200
    17.756   244.586     0.200
    20.420   282.258     0.200
    20.782   282.453     0.200
     0.732    13.281     0.200
     1.302    22.180     0.200
     1.420    24.180     0.200
     1.420    23.977     0.200
     1.760    29.281     0.200
     1.859    28.930     0.200
     1.859    28.477     0.200
     2.152    33.875     0.200
     2.369    36.680     0.200
     2.399    38.078     0.200
     2.759    42.680     0.200
     3.033    46.477     0.200
     3.401    51.781     0.200
     4.250    60.820     0.200
     4.250    63.477     0.200
     4.305    64.977     0.200
     4.330    63.680     0.200
     4.611    69.180     0.200
     4.475    66.266     0.200
     4.564    66.898     0.200
     4.564    67.578     0.200
     4.933    71.375     0.200
     4.953    74.875     0.200
     5.225    77.180     0.200
     5.241    77.875     0.200
     5.837    86.078     0.200
     6.847   100.875     0.200
     6.924    98.875     0.200
     7.478   108.477     0.200
     7.967   114.281     0.200
     8.196   117.641     0.200
     8.196   119.180     0.200
     9.116   127.109     0.200
     9.116   129.477     0.200
     9.127   126.578     0.200
     9.382   132.984     0.200
     9.382   133.578     0.200
     9.208   132.578     0.200
     9.260   132.180     0.200
     9.846   136.930     0.200
     9.846   139.578     0.200
    10.338   142.180     0.200
    10.152   142.961     0.200
    10.152   143.578     0.200
    11.631   164.555     0.200
    11.631   165.578     0.200
    11.797   165.078     0.200
    12.032   163.250     0.200
    12.032   163.680     0.200
    12.246   167.180     0.200
    12.246   167.438     0.200
    13.194   189.680     0.200
    13.684   188.258     0.200
    13.684   188.578     0.200
    13.689   188.477     0.200
    13.748   186.781     0.200
    13.931   193.281     0.200
    13.931   196.633     0.200
    14.176   200.375     0.200
    14.243   200.875     0.200
    14.499   203.680     0.200
    15.441   208.984     0.200
    15.645   213.281     0.200
    16.179   221.977     0.200
    16.385   223.875     0.200
    16.846   232.289     0.200
    16.942   234.781     0.200
    17.112   234.594     0.200
    17.112   234.336     0.200
    17.726   241.914     0.200
    17.928   244.109     0.200
    19.663   267.375     0.200
     0.643    12.299     0.200
     1.029    18.299     0.200
     1.267    22.023     0.200
     1.794    29.898     0.200
     1.736    28.998     0.200
     2.005    33.098     0.200
     2.166    33.799     0.200
     2.358    37.299     0.200
     3.457    53.799     0.200
     3.527    53.898     0.200
     3.492    51.598     0.200
     3.727    57.598     0.200
     4.120    63.299     0.200
     4.145    61.098     0.200
     5.368    79.898     0.200
     5.405    78.299     0.200
     5.807    85.299     0.200
     7.101   100.697     0.200
     7.101   102.799     0.200
     7.796   113.299     0.200
     7.880   114.398     0.200
     8.136   117.998     0.200
     8.652   121.697     0.200
     9.812   139.398     0.200
    10.700   150.598     0.200
    11.701   163.299     0.200
    13.001   183.117     0.200
    13.140   179.549     0.200
    13.287   180.148     0.200
    13.293   186.998     0.200
    13.509   188.498     0.200
    15.097   209.809     0.200
    16.188   223.598     0.200
    16.426   223.787     0.200
    17.146   233.219     0.200
    17.158   236.947     0.200
    17.158   235.998     0.200
    17.365   234.578     0.200
    18.097   249.197     0.200
    17.995   248.059     0.200
    18.363   252.258     0.200
     0.576    11.773     0.200
     0.747    13.176     0.200
     0.984    17.375     0.200
     1.201    21.449     0.200
     1.201    21.273     0.200
     1.415    22.176     0.200
     1.823    29.176     0.200
     1.960    32.273     0.200
     1.967    31.176     0.200
     3.057    47.074     0.200
     3.242    47.574     0.200
     3.432    52.375     0.200
     3.467    51.035     0.200
     3.467    51.375     0.200
     3.467    50.574     0.200
     3.488    51.086     0.200
     3.488    53.273     0.200
     3.488    52.574     0.200
     3.690    57.176     0.200
     4.094    62.074     0.200
     4.400    66.477     0.200
     4.428    66.773     0.200
     4.737    68.875     0.200
     4.900    69.477     0.200
     5.346    75.574     0.200
     5.346    78.477     0.200
     5.346    77.074     0.200
     5.406    80.574     0.200
     5.406    79.773     0.200
     5.748    84.477     0.200
     6.370    89.477     0.200
     6.513    92.676     0.200
     6.695    95.773     0.200
     7.082   101.164     0.200
     7.082   101.574     0.200
     7.082   101.875     0.200
     7.145   107.375     0.200
     7.745   112.176     0.200
     8.636   120.273     0.200
     8.872   122.875     0.200
     9.087   127.273     0.200
     9.794   138.074     0.200
    10.682   150.977     0.200
    10.682   150.273     0.200
    10.908   152.953     0.200
    11.496   159.285     0.200
    11.678   160.074     0.200
    13.115   179.645     0.200
    13.115   178.875     0.200
    13.258   186.977     0.200
    14.545   199.684     0.200
    15.211   212.477     0.200
    16.235   221.445     0.200
    16.235   222.875     0.200
    16.371   224.895     0.200
    16.594   225.934     0.200
    17.033   233.477     0.200
    17.099   233.164     0.200
    17.099   233.375     0.200
    17.142   232.625     0.200
    17.142   236.074     0.200
    17.142   232.273     0.200
    18.394   251.574     0.200
    20.768   278.074     0.200
     2.142    36.207     0.200
     2.580    42.707     0.200
     2.663    45.408     0.200
     2.822    46.848     0.200
     2.822    45.408     0.200
     4.084    64.408     0.200
     6.451    96.928     0.200
     0.975    15.745     0.200
     1.415    23.344     0.200
     1.415    23.169     0.200
     1.460    23.544     0.200
     1.611    24.844     0.200
     2.182    33.844     0.200
     2.667    39.245     0.200
     3.075    46.444     0.200
     3.428    49.844     0.200
     3.705    55.245     0.200
     3.649    53.115     0.200
     3.649    53.544     0.200
     3.649    52.844     0.200
     4.067    59.944     0.200
     4.626    68.444     0.200
     5.314    77.644     0.200
     5.304    74.434     0.200
     5.304    75.044     0.200
     5.304    75.944     0.200
     5.463    80.844     0.200
     5.862    85.344     0.200
     6.164    90.644     0.200
     6.697    95.544     0.200
     7.251   103.084     0.200
     7.251   104.245     0.200
     7.251   103.444     0.200
     7.328   108.944     0.200
     7.823   113.245     0.200
     8.291   118.844     0.200
     8.308   119.344     0.200
     8.308   120.544     0.200
     8.573   118.844     0.200
     9.157   133.044     0.200
     9.268   133.844     0.200
     9.500   131.344     0.200
    10.045   140.534     0.200
    10.045   140.944     0.200
     9.961   140.144     0.200
    10.109   140.404     0.200
    10.109   139.344     0.200
    10.192   143.294     0.200
    10.685   149.334     0.200
    10.849   152.745     0.200
    10.849   151.644     0.200
    11.637   158.644     0.200
    11.704   165.034     0.200
    11.704   167.444     0.200
    13.082   178.615     0.200
    13.082   178.344     0.200
    13.170   184.274     0.200
    13.170   185.214     0.200
    13.254   180.764     0.200
    13.253   180.844     0.200
    13.473   189.644     0.200
    13.462   189.544     0.200
    13.739   191.444     0.200
    14.593   200.264     0.200
    14.741   200.745     0.200
    14.710   200.444     0.200
    16.184   222.865     0.200
    16.184   221.995     0.200
    16.184   223.044     0.200
    16.450   224.464     0.200
    16.599   229.674     0.200
    16.599   230.044     0.200
    16.811   231.054     0.200
    16.811   231.644     0.200
    17.259   237.844     0.200
    17.320   236.734     0.200
    17.320   238.544     0.200
    17.304   235.804     0.200
    17.304   237.745     0.200
    17.304   237.644     0.200
    17.528   238.875     0.200
    18.013   242.404     0.200
    18.013   244.144     0.200
    18.042   246.064     0.200
    18.042   248.944     0.200
    18.042   247.011     0.200
    18.408   252.644     0.200
    19.103   260.844     0.200
     1.013    17.312     0.200
     1.013    17.473     0.200
     1.582    26.514     0.200
     1.582    26.744     0.200
     1.865    32.514     0.200
     1.941    32.594     0.200
     2.171    36.312     0.200
     2.838    42.914     0.200
     2.838    43.094     0.200
     3.064    46.232     0.200
     3.096    48.744     0.200
     3.096    48.514     0.200
     3.127    48.033     0.200
     3.127    47.834     0.200
     3.736    57.914     0.200
     3.736    58.023     0.200
     3.778    57.213     0.200
     4.027    62.652     0.200
     4.299    65.123     0.200
     4.334    64.014     0.200
     4.334    64.193     0.200
     5.098    75.113     0.200
     5.098    74.963     0.200
     5.584    83.334     0.200
     5.657    84.732     0.200
     5.657    84.514     0.200
     5.701    84.293     0.200
     6.680    97.303     0.200
     6.680    96.613     0.200
     6.680    97.604     0.200
     7.710   111.014     0.200
     8.966   127.414     0.200
     8.966   127.133     0.200
    11.983   168.553     0.200
     0.893    15.016     0.200
     1.522    24.117     0.200
     2.768    42.219     0.200
     2.768    42.414     0.200
     3.103    48.617     0.200
     3.341    49.516     0.200
     3.447    53.719     0.200
     3.562    52.977     0.200
     3.562    52.812     0.200
     3.609    55.508     0.200
     3.609    55.617     0.200
     3.609    54.914     0.200
     4.111    62.016     0.200
     4.537    66.516     0.200
     4.829    70.312     0.200
     6.610    94.219     0.200
     7.166   104.234     0.200
     7.166   104.617     0.200
     7.166   103.914     0.200
     7.241   107.812     0.200
     8.205   119.516     0.200
     8.630   122.812     0.200
     9.877   140.812     0.200
    10.198   145.016     0.200
    10.243   143.312     0.200
    10.765   151.719     0.200
    10.765   152.516     0.200
    11.687   163.016     0.200
    12.425   171.617     0.200
    13.130   180.672     0.200
    13.130   182.812     0.200
    16.166   224.156     0.200
    16.166   223.812     0.200
    16.516   226.727     0.200
    17.221   235.227     0.200
    17.221   238.117     0.200
     2.635    43.176     0.200
     2.739    45.176     0.200
     2.876    47.477     0.200
     2.876    47.127     0.200
     3.571    56.676     0.200
     3.571    57.137     0.200
     3.707    58.877     0.200
     3.741    58.777     0.200
     4.257    66.377     0.200
     4.467    69.377     0.200
     4.502    70.176     0.200
     4.767    73.477     0.200
     5.323    80.676     0.200
     5.785    86.777     0.200
     6.508    96.777     0.200
     6.507    96.977     0.200
     1.364    24.359     0.200
     1.678    29.258     0.200
     1.851    31.453     0.200
     2.507    40.258     0.200
     3.085    49.758     0.200
     3.097    49.656     0.200
     3.321    51.055     0.200
     3.358    52.359     0.200
     3.699    58.258     0.200
     3.880    60.258     0.200
     4.012    62.156     0.200
     4.062    62.258     0.200
     4.138    63.555     0.200
     1.176    20.672     0.200
     1.736    28.227     0.200
     1.903    31.828     0.200
     1.856    31.422     0.200
     2.263    36.023     0.200
     2.607    42.727     0.200
     2.812    44.422     0.200
     3.068    48.922     0.200
     3.064    48.023     0.200
     3.152    47.422     0.200
     3.154    49.227     0.200
     3.761    56.328     0.200
     5.297    77.922     0.200
     0.951    18.812     0.200
     1.328    23.812     0.200
     1.697    29.414     0.200
     1.841    31.312     0.200
     1.977    33.711     0.200
     1.983    33.414     0.200
     2.175    36.609     0.200
     2.383    39.211     0.200
     2.790    44.008     0.200
     2.922    46.812     0.200
     2.977    47.812     0.200
     3.626    55.914     0.200
     3.683    57.812     0.200
     4.199    65.812     0.200
     0.869    18.365     0.200
     0.900    19.066     0.200
     1.002    20.365     0.200
     1.229    22.066     0.200
     1.437    25.467     0.200
     1.498    26.266     0.200
     1.932    32.666     0.200
     3.742    56.766     0.200
     1.159    22.641     0.200
     1.288    23.141     0.200
     1.614    27.941     0.200
     1.842    31.141     0.200
     2.042    34.242     0.200
     2.444    39.742     0.200
     2.614    42.043     0.200
     2.978    47.043     0.200
     3.196    50.043     0.200
     3.663    56.441     0.200
     0.777    14.156     0.200
     1.315    22.461     0.200
     1.425    23.914     0.200
     1.425    23.461     0.200
     1.602    26.961     0.200
     1.710    29.258     0.200
     1.802    30.562     0.200
     1.780    29.461     0.200
     1.779    29.461     0.200
     1.835    30.859     0.200
     1.873    31.758     0.200
     1.850    30.133     0.200
     1.850    29.758     0.200
     1.964    33.156     0.200
     1.986    32.266     0.200
     1.986    32.156     0.200
     1.997    33.461     0.200
     2.146    33.602     0.200
     2.146    34.961     0.200
     2.248    36.961     0.200
     2.635    41.062     0.200
     2.649    42.156     0.200
     2.954    46.758     0.200
     2.975    46.859     0.200
     3.081    47.156     0.200
     3.184    50.461     0.200
     3.249    50.258     0.200
     3.365    50.156     0.200
     3.444    51.156     0.200
     3.473    51.758     0.200
     3.473    53.688     0.200
     3.504    54.562     0.200
     3.458    53.703     0.200
     3.458    54.258     0.200
     3.568    56.461     0.200
     3.741    56.258     0.200
     3.936    61.359     0.200
     4.128    61.344     0.200
     4.128    61.961     0.200
     4.217    63.062     0.200
     4.259    65.461     0.200
     4.431    67.562     0.200
     4.505    67.859     0.200
     4.700    71.258     0.200
     5.057    76.758     0.200
     5.173    76.258     0.200
     5.352    77.688     0.200
     5.352    79.859     0.200
     5.382    80.961     0.200
     5.367    83.461     0.200
     5.370    78.328     0.200
     5.370    79.961     0.200
     5.444    78.430     0.200
     5.571    82.359     0.200
     5.592    82.961     0.200
     5.723    83.656     0.200
     5.896    86.656     0.200
     5.938    87.656     0.200
     6.162    91.156     0.200
     6.276    90.758     0.200
     6.373    90.648     0.200
     6.665    97.156     0.200
     6.721    97.133     0.200
     6.758    99.562     0.200
     7.008    99.961     0.200
     7.084   101.750     0.200
     7.084   102.953     0.200
     7.084   103.062     0.200
     7.084   105.156     0.200
     7.151   107.062     0.200
     7.325   107.758     0.200
     7.828   114.758     0.200
     7.918   112.547     0.200
     8.091   114.867     0.200
     8.091   118.062     0.200
     8.118   117.758     0.200
     8.164   118.758     0.200
     8.458   122.562     0.200
     8.865   127.359     0.200
     9.128   132.758     0.200
     9.445   135.258     0.200
     9.420   133.258     0.200
     9.741   139.156     0.200
     9.795   140.156     0.200
    10.263   144.844     0.200
    10.683   150.227     0.200
    11.195   157.008     0.200
    12.979   183.656     0.200
    13.141   178.852     0.200
    13.141   182.273     0.200
    13.283   181.500     0.200
    14.641   202.781     0.200
    15.079   208.961     0.200
    15.079   208.711     0.200
    16.197   222.477     0.200
    16.634   225.414     0.200
    17.142   233.031     0.200
    17.142   234.688     0.200
    17.689   241.227     0.200
    17.996   248.242     0.200
    17.996   250.562     0.200
    20.750   279.312     0.200
     2.545    42.923     0.200
     2.970    46.823     0.200
     1.712    29.691     0.200
     1.732    30.793     0.200
     1.743    30.293     0.200
     1.761    30.992     0.200
     1.804    32.090     0.200
     1.846    31.590     0.200
     1.894    32.492     0.200
     1.957    33.090     0.200
     1.998    34.590     0.200
     2.023    33.891     0.200
     2.027    33.691     0.200
     2.113    35.793     0.200
     2.125    36.090     0.200
     2.139    35.891     0.200
     2.262    37.191     0.200
     2.312    38.590     0.200
     2.393    39.891     0.200
     3.022    48.191     0.200
     3.108    50.492     0.200
     3.112    48.891     0.200
     4.107    63.891     0.200
     5.566    84.090     0.200
     0.905    17.863     0.200
     2.035    34.664     0.200
     1.175    20.961     0.200
     2.404    40.262     0.200
     1.104    20.906     0.200
     1.835    31.609     0.200
     1.969    33.508     0.200
     2.376    37.906     0.200
     2.377    38.711     0.200
     2.396    38.711     0.200
     2.737    43.008     0.200
     3.066    48.906     0.200
     3.230    50.008     0.200
     3.330    52.305     0.200
     3.424    53.305     0.200
     4.093    62.906     0.200
    12.433   176.805     0.200
     1.160    22.334     0.200
     1.239    22.234     0.200
     1.421    25.934     0.200
     1.467    27.034     0.200
     1.503    27.234     0.200
     1.535    27.734     0.200
     1.827    31.434     0.200
     1.834    32.234     0.200
     1.903    32.434     0.200
     1.880    33.634     0.200
     1.942    32.634     0.200
     2.074    35.534     0.200
     2.269    38.934     0.200
     2.281    38.434     0.200
     2.518    40.834     0.200
     2.650    43.434     0.200
     2.740    45.934     0.200
     2.811    45.634     0.200
     2.891    46.534     0.200
     2.943    47.634     0.200
     2.997    48.734     0.200
     3.022    48.234     0.200
     3.188    51.134     0.200
     3.289    51.434     0.200
     3.265    52.734     0.200
     3.598    56.534     0.200
     3.588    56.434     0.200
     4.074    63.834     0.200
     4.155    63.634     0.200
     1.146    23.211     0.200
     1.143    21.611     0.200
     1.830    32.011     0.200
     1.896    32.611     0.200
     1.949    33.011     0.200
     2.654    44.211     0.200
     2.807    45.211     0.200
     2.890    48.311     0.200
     3.584    56.311     0.200
     1.369    24.180     0.200
     1.317    23.578     0.200
     1.361    24.383     0.200
     1.496    26.781     0.200
     1.661    29.383     0.200
     1.830    32.180     0.200
     2.244    38.281     0.200
     2.362    39.281     0.200
     3.281    51.781     0.200
     3.347    52.484     0.200
     3.388    52.781     0.200
     3.651    56.984     0.200
     4.051    62.281     0.200
     1.351    24.593     0.200
     1.487    26.093     0.200
     1.524    26.693     0.200
     2.474    41.293     0.200
     1.172    20.188     0.200
     1.222    22.488     0.200
     1.222    21.988     0.200
     1.512    26.688     0.200
     1.619    28.688     0.200
     1.788    30.588     0.200
     1.819    30.188     0.200
     1.858    32.088     0.200
     1.865    31.588     0.200
     2.308    37.789     0.200
     4.424    68.688     0.200
     4.490    68.988     0.200
     1.155    20.672     0.200
     1.300    22.871     0.200
     1.494    26.172     0.200
     1.903    32.273     0.200
     2.289    37.973     0.200
     1.828    31.840     0.200
     1.912    33.035     0.200
     2.107    36.035     0.200
     2.796    45.633     0.200
     0.863    18.730     0.200
     1.484    27.430     0.200
     1.783    32.230     0.200
     1.899    32.531     0.200
     2.126    37.230     0.200
     2.706    44.781     0.200
     2.760    45.629     0.200
     2.781    45.832     0.200
     2.842    46.082     0.200
     2.842    47.730     0.200
     3.218    52.332     0.200
     3.537    57.129     0.200
     4.030    65.332     0.200
     4.108    64.129     0.200
    16.016   223.270     0.200
    16.542   232.891     0.200
     0.618    12.154     0.200
     0.747    14.154     0.200
     0.792    13.645     0.200
     0.875    16.054     0.200
     0.906    16.354     0.200
     0.952    17.054     0.200
     1.023    18.454     0.200
     1.043    18.154     0.200
     1.004    17.854     0.200
     1.090    19.154     0.200
     1.040    18.554     0.200
     1.127    19.754     0.200
     1.212    21.454     0.200
     1.249    23.054     0.200
     1.247    21.854     0.200
     1.386    24.454     0.200
     1.375    23.754     0.200
     1.332    22.354     0.200
     1.440    24.954     0.200
     1.429    24.754     0.200
     1.515    25.554     0.200
     1.478    24.354     0.200
     1.448    22.854     0.200
     1.536    25.254     0.200
     1.658    27.854     0.200
     1.621    26.554     0.200
     1.767    29.454     0.200
     1.844    30.654     0.200
     1.828    29.054     0.200
     1.889    31.454     0.200
     1.980    32.554     0.200
     1.981    32.654     0.200
     2.006    31.854     0.200
     2.168    33.154     0.200
     2.268    36.054     0.200
     2.352    37.454     0.200
     2.457    38.354     0.200
     2.450    37.354     0.200
     2.670    41.554     0.200
     2.657    40.254     0.200
     2.836    43.354     0.200
     2.997    45.754     0.200
     3.070    47.254     0.200
     3.060    46.254     0.200
     3.101    47.354     0.200
     2.827    41.454     0.200
     3.162    47.954     0.200
     3.146    46.754     0.200
     3.242    48.454     0.200
     3.272    48.454     0.200
     3.364    51.454     0.200
     3.435    52.354     0.200
     3.467    53.254     0.200
     3.470    51.054     0.200
     3.525    51.774     0.200
     3.525    53.654     0.200
     3.547    54.054     0.200
     3.496    51.414     0.200
     3.496    51.254     0.200
     3.566    52.854     0.200
     3.703    56.754     0.200
     3.679    56.154     0.200
     3.773    57.154     0.200
     3.916    59.254     0.200
     3.926    58.954     0.200
     3.894    56.954     0.200
     4.098    61.354     0.200
     4.196    62.454     0.200
     4.152    60.754     0.200
     4.237    63.754     0.200
     4.410    66.454     0.200
     4.387    65.354     0.200
     4.462    66.754     0.200
     4.724    70.754     0.200
     4.733    70.554     0.200
     4.782    71.354     0.200
     4.766    69.854     0.200
     4.810    70.954     0.200
     4.869    73.554     0.200
     4.937    72.454     0.200
     4.937    73.154     0.200
     5.035    74.954     0.200
     5.168    75.954     0.200
     5.113    76.354     0.200
     5.331    78.454     0.200
     5.341    78.454     0.200
     5.347    78.594     0.200
     5.427    77.424     0.200
     5.493    84.554     0.200
     5.594    82.654     0.200
     5.780    85.654     0.200
     5.726    86.554     0.200
     5.986    88.354     0.200
     6.253    91.054     0.200
     6.314    91.954     0.200
     6.543    95.654     0.200
     6.699    96.954     0.200
     7.108   101.924     0.200
     7.108   103.354     0.200
     7.175   107.654     0.200
     7.303   104.854     0.200
     7.448   107.254     0.200
     7.993   114.754     0.200
     8.074   114.854     0.200
     8.171   116.154     0.200
     8.116   117.454     0.200
     8.142   118.054     0.200
     8.140   117.854     0.200
     8.154   117.854     0.200
     8.167   117.954     0.200
     8.188   118.754     0.200
     8.492   120.354     0.200
     8.526   120.854     0.200
     8.482   122.354     0.200
     8.633   118.654     0.200
     8.780   124.154     0.200
     8.897   127.254     0.200
     8.882   125.454     0.200
     9.102   130.654     0.200
     9.114   131.854     0.200
     9.132   129.254     0.200
     9.237   129.254     0.200
     9.396   132.954     0.200
     9.339   133.954     0.200
     9.397   131.654     0.200
     9.424   133.754     0.200
     9.528   133.454     0.200
     9.469   134.454     0.200
     9.765   138.854     0.200
     9.819   139.154     0.200
     9.906   138.154     0.200
    10.113   141.174     0.200
    10.113   141.754     0.200
    10.215   147.254     0.200
    10.131   144.454     0.200
    10.216   143.654     0.200
    10.240   142.154     0.200
    10.335   144.854     0.200
    10.392   145.054     0.200
    10.500   147.754     0.200
    10.684   149.854     0.200
    10.708   149.454     0.200
    10.708   150.454     0.200
    10.868   150.554     0.200
    10.890   152.854     0.200
    10.866   151.654     0.200
    10.866   152.754     0.200
    11.197   156.454     0.200
    11.488   160.554     0.200
    11.680   161.924     0.200
    11.680   161.554     0.200
    11.877   170.054     0.200
    11.782   165.154     0.200
    12.681   180.854     0.200
    12.778   179.654     0.200
    12.948   183.654     0.200
    12.933   183.054     0.200
    13.030   177.554     0.200
    13.000   181.964     0.200
    13.000   183.654     0.200
    13.119   178.895     0.200
    13.119   179.154     0.200
    13.228   187.354     0.200
    13.262   181.754     0.200
    13.262   181.554     0.200
    13.260   187.954     0.200
    13.273   184.454     0.200
    13.298   187.854     0.200
    13.292   187.254     0.200
    13.293   187.754     0.200
    13.262   181.379     0.200
    13.332   186.854     0.200
    13.263   183.454     0.200
    13.362   186.954     0.200
    13.466   185.954     0.200
    13.511   189.554     0.200
    13.539   190.954     0.200
    13.538   188.254     0.200
    13.677   191.154     0.200
    13.650   193.954     0.200
    13.703   188.254     0.200
    13.846   192.354     0.200
    13.863   191.354     0.200
    13.977   191.254     0.200
    13.986   197.254     0.200
    13.995   196.554     0.200
    14.012   197.954     0.200
    14.119   197.054     0.200
    14.135   198.654     0.200
    14.368   202.654     0.200
    14.537   204.454     0.200
    14.605   205.254     0.200
    14.620   199.754     0.200
    14.566   199.354     0.200
    14.589   199.654     0.200
    14.761   204.854     0.200
    14.802   200.254     0.200
    14.834   208.154     0.200
    14.797   208.154     0.200
    14.821   206.454     0.200
    14.884   209.154     0.200
    14.970   210.254     0.200
    14.883   204.154     0.200
    15.064   210.454     0.200
    15.103   210.154     0.200
    15.103   208.454     0.200
    15.274   213.254     0.200
    15.336   214.454     0.200
    15.372   214.754     0.200
    15.568   214.654     0.200
    15.657   217.854     0.200
    15.816   220.454     0.200
    15.852   218.254     0.200
    16.278   222.244     0.200
    16.300   222.954     0.200
    16.416   225.145     0.200
    16.214   222.769     0.200
    16.214   222.508     0.200
    16.214   220.804     0.200
    16.630   229.854     0.200
    16.722   227.554     0.200
    16.969   234.254     0.200
    17.076   235.054     0.200
    17.140   234.034     0.200
    17.167   232.604     0.200
    17.167   234.284     0.200
    17.167   233.754     0.200
    17.451   237.254     0.200
    17.557   240.154     0.200
    17.698   242.354     0.200
    17.981   242.164     0.200
    18.094   245.154     0.200
    18.018   246.534     0.200
     1.277    23.523     0.200
     1.304    23.725     0.200
     1.310    25.125     0.200
     1.362    24.225     0.200
     1.454    24.523     0.200
     1.505    26.225     0.200
     1.583    27.225     0.200
     1.644    28.824     0.200
     1.644    28.625     0.200
     1.658    30.324     0.200
     1.856    32.523     0.200
     1.875    31.023     0.200
     1.894    32.924     0.200
     2.025    34.023     0.200
     2.039    34.725     0.200
     2.176    35.924     0.200
     2.288    38.324     0.200
     2.668    42.725     0.200
     2.769    43.344     0.200
     3.496    53.613     0.200
     3.481    55.125     0.200
     3.541    52.965     0.200
     3.895    61.225     0.200
    10.701   153.084     0.200
     1.133    20.938     0.200
     1.759    29.637     0.200
     2.315    37.738     0.200
     2.390    38.738     0.200
     2.419    39.537     0.200
     2.487    40.838     0.200
     3.084    49.338     0.200
     3.691    57.537     0.200
     1.145    20.141     0.200
     2.324    38.543     0.200
     1.230    23.701     0.200
     1.277    24.102     0.200
     1.312    23.801     0.200
     1.456    26.801     0.200
     1.455    27.401     0.200
     1.507    27.501     0.200
     1.508    28.301     0.200
     1.741    30.001     0.200
     1.739    32.401     0.200
     1.887    34.201     0.200
     2.033    36.301     0.200
     2.242    38.901     0.200
     2.312    39.602     0.200
     2.526    42.501     0.200
     2.850    42.602     0.200
     2.968    46.102     0.200
     3.005    47.901     0.200
     3.201    49.901     0.200
     3.124    52.602     0.200
     3.425    54.501     0.200
     4.007    61.501     0.200
     4.583    72.501     0.200
     1.902    32.336     0.200
     2.442    39.734     0.200
     2.563    40.637     0.200
     2.901    45.535     0.200
     1.478    24.937     0.200
     1.388    24.504     0.200
     1.299    24.102     0.200
     1.299    24.203     0.200
     1.467    26.703     0.200
     2.005    34.203     0.200
     2.352    39.102     0.200
     2.596    43.504     0.200
     2.794    45.602     0.200
     2.660    44.402     0.200
     2.800    46.004     0.200
     2.831    46.203     0.200
     3.073    49.805     0.200
     3.089    49.004     0.200
     3.342    53.102     0.200
     3.253    50.602     0.200
     3.266    52.504     0.200
     3.376    53.203     0.200
     3.376    53.004     0.200
     3.397    53.402     0.200
     3.505    54.703     0.200
     3.586    55.902     0.200
     3.722    60.402     0.200
     3.832    61.902     0.200
     4.015    63.402     0.200
     3.838    60.102     0.200
     3.857    60.102     0.200
     4.465    70.305     0.200
     4.566    68.805     0.200
     4.475    68.902     0.200
     4.477    69.504     0.200
     4.753    71.602     0.200
     4.578    70.805     0.200
     4.902    73.602     0.200
     5.000    74.805     0.200
     5.249    78.703     0.200
     5.675    84.004     0.200
     5.703    85.703     0.200
     5.886    88.305     0.200
     6.074    90.004     0.200
     6.213    92.305     0.200
     6.262    93.203     0.200
     6.450    96.102     0.200
     6.419    95.203     0.200
     6.568    96.504     0.200
     6.520    97.203     0.200
     1.659    29.008     0.200
     2.357    38.609     0.200
     2.521    41.008     0.200
     2.663    44.008     0.200
     2.795    45.312     0.200
     2.834    47.008     0.200
     3.144    50.109     0.200
     3.226    52.508     0.200
     3.258    52.609     0.200
     3.272    52.406     0.200
     3.333    55.211     0.200
     3.378    54.312     0.200
     3.506    55.906     0.200
     3.585    56.312     0.200
     3.644    57.211     0.200
     3.894    61.906     0.200
     4.002    63.609     0.200
     4.481    69.609     0.200
     1.666    29.164     0.200
     1.834    31.562     0.200
     2.007    34.062     0.200
     2.313    37.258     0.200
     2.363    39.258     0.200
     2.780    45.664     0.200
     2.788    45.461     0.200
     2.838    45.461     0.200
     3.128    49.758     0.200
     3.136    49.859     0.200
     3.264    51.062     0.200
     1.129    21.939     0.200
     1.217    23.340     0.200
     1.421    25.240     0.200
     1.364    25.639     0.200
     1.551    28.240     0.200
     1.688    29.939     0.200
     1.817    31.840     0.200
     1.931    34.240     0.200
     2.149    35.939     0.200
     2.140    37.539     0.200
     2.246    38.740     0.200
     2.549    42.139     0.200
     2.545    42.539     0.200
     2.558    42.439     0.200
     2.584    42.639     0.200
     2.636    43.340     0.200
     2.925    46.840     0.200
     2.956    49.139     0.200
     2.956    48.639     0.200
     3.146    50.639     0.200
     3.397    54.010     0.200
     3.397    54.439     0.200
     3.369    53.639     0.200
     3.408    54.840     0.200
     3.440    55.539     0.200
     3.504    56.340     0.200
     3.529    57.439     0.200
     3.521    57.639     0.200
     3.526    56.139     0.200
     3.598    58.240     0.200
     3.598    59.549     0.200
     3.598    55.219     0.200
     3.598    59.039     0.200
     3.598    57.939     0.200
     3.646    57.639     0.200
     3.692    58.639     0.200
     3.689    59.340     0.200
     3.752    58.340     0.200
     3.850    58.439     0.200
     3.847    60.840     0.200
     3.967    62.639     0.200
     4.158    64.840     0.200
     4.183    65.539     0.200
     4.283    66.539     0.200
     4.298    67.840     0.200
     4.407    66.939     0.200
     4.375    67.840     0.200
     4.425    69.139     0.200
     4.410    69.539     0.200
     4.598    70.139     0.200
     4.675    70.240     0.200
     4.736    74.240     0.200
     4.770    73.639     0.200
     4.769    74.539     0.200
     4.797    72.539     0.200
     4.857    72.939     0.200
     4.803    75.039     0.200
     4.803    76.549     0.200
     4.803    74.840     0.200
     4.877    73.939     0.200
     4.858    75.740     0.200
     4.969    77.039     0.200
     4.982    75.939     0.200
     5.169    80.340     0.200
     5.144    80.439     0.200
     5.285    80.539     0.200
     5.421    81.039     0.200
     5.463    88.039     0.200
     5.492    84.139     0.200
     5.508    86.340     0.200
     5.504    84.539     0.200
     5.618    86.240     0.200
     5.713    88.740     0.200
     5.663    86.240     0.200
     5.756    87.539     0.200
     5.902    88.840     0.200
     6.003    90.740     0.200
     6.170    93.939     0.200
     6.278    92.240     0.200
     6.426    96.240     0.200
     6.499    97.539     0.200
     6.567    98.240     0.200
     6.683   100.539     0.200
     6.723   101.340     0.200
     6.761   100.139     0.200
     6.896   100.939     0.200
     6.987   102.539     0.200
     7.203   109.439     0.200
     7.224   104.549     0.200
     7.224   108.840     0.200
     7.224   107.539     0.200
     7.291   110.439     0.200
     7.304   107.740     0.200
     7.360   108.539     0.200
     7.377   109.539     0.200
     7.539   112.340     0.200
     7.611   110.740     0.200
     7.648   114.439     0.200
     7.925   117.939     0.200
     7.990   117.939     0.200
     8.110   116.840     0.200
     8.068   121.840     0.200
     8.146   119.639     0.200
     8.221   120.439     0.200
     8.170   119.039     0.200
     8.189   118.840     0.200
     8.199   119.939     0.200
     8.260   121.939     0.200
     8.256   121.939     0.200
     8.267   121.539     0.200
     8.290   122.340     0.200
     8.509   124.039     0.200
     8.604   125.340     0.200
     8.606   127.240     0.200
     8.841   126.879     0.200
     8.803   128.439     0.200
     8.887   128.840     0.200
     8.872   128.740     0.200
     9.015   133.039     0.200
     9.109   133.639     0.200
     9.259   135.740     0.200
     9.262   134.439     0.200
     9.354   137.439     0.200
     9.402   138.639     0.200
     9.538   139.539     0.200
     9.566   137.740     0.200
     9.560   139.939     0.200
     9.566   137.740     0.200
     9.692   140.240     0.200
     9.723   140.439     0.200
     9.812   141.840     0.200
     9.877   142.539     0.200
     9.886   143.539     0.200
     9.927   144.639     0.200
     9.969   144.039     0.200
    10.023   144.740     0.200
    10.025   144.539     0.200
    10.133   146.840     0.200
    10.174   146.439     0.200
    10.225   147.139     0.200
    10.255   150.039     0.200
    10.701   153.740     0.200
    10.617   151.840     0.200
    10.819   156.639     0.200
    10.814   153.150     0.200
    10.814   157.039     0.200
    10.814   155.840     0.200
    10.997   157.840     0.200
    11.031   156.939     0.200
    11.099   157.139     0.200
    11.207   159.840     0.200
    11.289   161.840     0.200
    11.301   159.629     0.200
    11.301   163.340     0.200
    11.562   165.840     0.200
    11.584   166.240     0.200
    11.681   164.139     0.200
    11.838   170.139     0.200
    11.850   166.639     0.200
    11.876   168.740     0.200
    11.993   170.939     0.200
    12.336   177.240     0.200
    12.343   172.740     0.200
    12.502   180.539     0.200
    12.505   174.340     0.200
    12.505   176.139     0.200
    12.505   174.039     0.200
    12.526   178.439     0.200
    12.548   175.299     0.200
    12.548   176.439     0.200
    12.548   177.139     0.200
    12.566   178.740     0.200
    12.548   177.564     0.200
    12.800   183.039     0.200
    12.784   183.539     0.200
    12.811   185.340     0.200
    12.811   185.479     0.200
    12.811   183.834     0.200
    12.811   182.658     0.200
    12.811   183.539     0.200
    12.777   178.840     0.200
    12.801   184.439     0.200
    12.851   183.939     0.200
    12.854   184.939     0.200
    12.926   185.539     0.200
    12.932   185.039     0.200
    12.913   182.240     0.200
    13.037   185.939     0.200
    13.055   186.939     0.200
    13.010   181.439     0.200
    13.075   187.240     0.200
    13.130   188.340     0.200
    13.113   183.039     0.200
    13.167   185.639     0.200
    13.195   183.240     0.200
    13.270   190.639     0.200
    13.271   186.039     0.200
    13.332   191.639     0.200
    13.350   191.240     0.200
    13.394   191.240     0.200
    13.432   191.740     0.200
    13.500   193.039     0.200
    13.574   193.939     0.200
    13.708   196.139     0.200
    13.699   196.639     0.200
    13.789   195.939     0.200
    13.919   199.139     0.200
    13.928   199.639     0.200
    13.922   194.840     0.200
    13.944   197.740     0.200
    13.957   200.539     0.200
    14.130   203.240     0.200
    14.151   201.539     0.200
    14.146   202.439     0.200
    14.250   203.139     0.200
    14.167   197.840     0.200
    14.350   204.539     0.200
    14.361   204.340     0.200
    14.422   205.840     0.200
    14.495   205.740     0.200
    14.554   207.139     0.200
    14.650   208.939     0.200
    14.671   208.340     0.200
    14.641   205.340     0.200
    14.654   206.439     0.200
    14.757   209.539     0.200
    14.825   209.939     0.200
    14.964   211.939     0.200
    15.047   213.439     0.200
    15.105   214.139     0.200
    15.066   210.539     0.200
    15.168   212.539     0.200
    15.168   213.039     0.200
    15.272   217.340     0.200
    15.299   217.439     0.200
    15.428   214.209     0.200
    15.428   217.439     0.200
    15.413   216.139     0.200
    15.469   220.039     0.200
    15.529   221.139     0.200
    15.609   221.340     0.200
    15.872   225.139     0.200
    15.907   223.139     0.200
    15.907   221.240     0.200
    15.907   223.840     0.200
    15.893   224.340     0.200
    15.995   220.539     0.200
    16.040   223.740     0.200
    16.129   226.139     0.200
    16.162   226.939     0.200
    15.736   227.240     0.200
    16.298   228.539     0.200
    16.355   227.740     0.200
    16.498   232.639     0.200
    16.642   233.939     0.200
    16.598   232.639     0.200
    16.775   234.229     0.200
    16.775   235.939     0.200
    17.014   236.539     0.200
    17.233   240.740     0.200
    17.063   238.340     0.200
    17.063   239.430     0.200
    17.282   241.740     0.200
    17.287   240.719     0.200
    17.287   238.340     0.200
    17.410   243.139     0.200
    17.390   239.039     0.200
    17.451   241.240     0.200
    17.654   246.039     0.200
    17.595   242.939     0.200
    17.583   242.539     0.200
    17.640   243.139     0.200
    17.665   243.840     0.200
    17.794   244.139     0.200
    17.994   247.840     0.200
    18.713   260.639     0.200
    18.713   261.010     0.200
    18.713   260.785     0.200
    19.115   266.561     0.200
    20.338   278.840     0.200
     1.133    21.316     0.200
     1.209    21.916     0.200
     1.825    31.215     0.200
     0.847    16.875     0.200
     1.023    19.375     0.200
     2.561    40.975     0.200
     1.178    20.926     0.200
     2.606    42.324     0.200
     3.097    50.426     0.200
     2.598    42.453     0.200
     1.398    24.906     0.200
     1.898    32.605     0.200
     0.600    12.238     0.200
     0.740    14.238     0.200
     0.860    16.238     0.200
     0.888    16.438     0.200
     0.934    17.035     0.200
     0.959    17.836     0.200
     0.992    18.035     0.200
     1.028    18.637     0.200
     1.097    19.438     0.200
     1.196    21.738     0.200
     1.229    22.137     0.200
     1.229    21.938     0.200
     1.231    23.035     0.200
     1.318    22.137     0.200
     1.360    24.035     0.200
     1.367    24.637     0.200
     1.438    22.438     0.200
     1.411    24.836     0.200
     1.421    25.137     0.200
     1.503    25.535     0.200
     1.530    24.836     0.200
     1.608    26.438     0.200
     1.607    26.535     0.200
     1.608    26.238     0.200
     1.594    27.637     0.200
     1.643    28.035     0.200
     1.822    29.035     0.200
     1.826    30.438     0.200
     1.969    32.336     0.200
     1.994    31.637     0.200
     2.158    33.137     0.200
     2.255    35.738     0.200
     2.338    37.137     0.200
     2.441    37.836     0.200
     2.646    40.035     0.200
     2.658    42.238     0.200
     2.986    44.238     0.200
     3.055    47.637     0.200
     3.088    46.035     0.200
     3.156    49.535     0.200
     3.238    50.238     0.200
     3.458    52.137     0.200
     3.461    52.438     0.200
     3.488    51.328     0.200
     3.488    54.438     0.200
     3.513    53.137     0.200
     3.540    55.035     0.200
     3.558    53.238     0.200
     3.669    55.738     0.200
     3.761    55.836     0.200
     3.907    59.637     0.200
     4.402    67.035     0.200
     4.715    70.238     0.200
     7.101   102.098     0.200
    10.701   151.059     0.200
    16.226   222.148     0.200
    17.161   235.387     0.200
     1.394    25.055     0.200
     1.390    24.820     0.200
     1.785    30.521     0.200
     2.508    41.922     0.200
     2.557    42.521     0.200
     2.612    43.320     0.200
     3.102    50.820     0.200
     0.756    15.410     0.200
     0.951    18.512     0.200
     1.163    21.910     0.200
     1.373    24.410     0.200
     0.745    15.156     0.200
     1.164    21.953     0.200
     1.206    22.852     0.200
     1.390    24.656     0.200
     2.609    43.656     0.200
     1.386    24.445     0.200
     1.537    28.547     0.200
     1.641    30.141     0.200
     1.654    29.547     0.200
     1.795    30.844     0.200
     1.910    33.945     0.200
     2.242    38.945     0.200
     2.566    42.047     0.200
     2.513    41.945     0.200
     2.539    42.945     0.200
     2.613    43.742     0.200
     2.879    46.945     0.200
     2.956    47.344     0.200
     2.927    48.141     0.200
     3.108    50.141     0.200
     3.503    58.344     0.200
     3.483    56.445     0.200
     3.511    55.945     0.200
     3.620    59.242     0.200
     3.586    57.844     0.200
     3.632    57.547     0.200
     3.653    58.344     0.200
     3.713    60.844     0.200
     3.794    58.844     0.200
     3.948    61.945     0.200
     4.109    64.641     0.200
     4.287    66.945     0.200
     4.749    71.742     0.200
     4.744    73.344     0.200
     4.839    75.242     0.200
     4.991    76.844     0.200
     6.645   103.242     0.200
     1.205    22.805     0.200
     1.423    25.102     0.200
     1.575    28.102     0.200
     1.387    24.578     0.200
     1.791    30.773     0.200
     2.563    42.875     0.200
     0.930    18.914     0.200
     1.194    21.812     0.200
     1.808    31.117     0.200
     3.095    50.414     0.200
     3.178    50.617     0.200
     1.190    21.461     0.200
     1.396    24.961     0.200
     0.943    18.992     0.200
     1.166    22.391     0.200
     1.384    24.594     0.200
     1.792    30.891     0.200
     2.615    43.594     0.200
     3.110    50.695     0.200
     3.162    52.391     0.200
     0.921    17.820     0.200
     1.134    21.723     0.200
     2.612    43.121     0.200
     1.405    24.826     0.200
     2.600    41.726     0.200
     3.150    49.326     0.200
     1.214    21.932     0.200
     2.575    43.332     0.200
     3.431    52.932     0.200
     1.176    20.820     0.200
     1.399    24.720     0.200
     0.921    18.477     0.200
     1.401    24.680     0.200
     1.623    29.375     0.200
     1.800    30.078     0.200
     2.497    41.680     0.200
     2.529    41.781     0.200
     2.572    41.875     0.200
     2.600    42.477     0.200
     2.861    45.578     0.200
     2.937    47.875     0.200
     2.913    47.078     0.200
     3.092    50.180     0.200
     3.164    49.977     0.200
     3.508    54.578     0.200
     3.499    55.477     0.200
     3.574    55.781     0.200
     3.624    57.680     0.200
     3.620    56.477     0.200
     3.714    59.180     0.200
     3.774    58.977     0.200
     4.084    63.375     0.200
     4.731    72.281     0.200
     4.826    74.680     0.200
     5.621    87.375     0.200
     6.646   100.578     0.200
     0.599    12.805     0.200
     0.592    12.604     0.200
     0.757    15.205     0.200
     0.809    16.205     0.200
     0.816    16.205     0.200
     0.862    16.905     0.200
     0.929    18.305     0.200
     0.971    19.104     0.200
     0.978    18.305     0.200
     1.002    21.005     0.200
     1.269    22.205     0.200
     1.710    29.405     0.200
     1.490    26.102     0.200
     1.818    30.779     0.200
     3.182    50.078     0.200
     1.116    20.852     0.200
     1.138    21.258     0.200
     1.508    27.055     0.200
     1.893    32.258     0.200
     1.853    32.352     0.200
     1.948    32.375     0.200
     1.948    32.852     0.200
     1.991    33.352     0.200
     2.143    36.258     0.200
     2.183    36.656     0.200
     2.236    35.766     0.200
     2.236    37.453     0.200
     2.248    37.156     0.200
     2.270    37.758     0.200
     2.406    39.055     0.200
     2.509    41.758     0.200
     2.789    45.555     0.200
     2.942    47.555     0.200
     3.350    52.656     0.200
     3.353    52.953     0.200
     3.461    54.758     0.200
     3.529    55.156     0.200
     5.308    80.156     0.200
     5.754    85.258     0.200
     5.818    83.633     0.200
     5.818    86.156     0.200
     9.394   133.922     0.200
     0.902    17.562     0.200
     1.046    19.359     0.200
     1.117    20.164     0.200
     1.501    25.859     0.200
     1.608    27.664     0.200
     2.084    35.062     0.200
     2.331    37.562     0.200
     2.573    42.359     0.200
     2.592    42.461     0.200
     1.285    23.395     0.200
     1.328    25.596     0.200
     1.364    23.795     0.200
     1.511    27.395     0.200
     1.659    29.695     0.200
     1.674    29.994     0.200
     1.834    30.295     0.200
     1.996    33.295     0.200
     2.249    36.695     0.200
     2.369    39.195     0.200
     2.838    44.895     0.200
     3.304    51.795     0.200
     3.289    52.195     0.200
     3.354    51.795     0.200
     3.501    53.994     0.200
     4.059    63.395     0.200
     1.187    22.602     0.200
     1.221    23.008     0.200
     1.384    24.602     0.200
     1.360    24.602     0.200
     1.534    27.602     0.200
     1.548    27.906     0.200
     1.548    28.008     0.200
     1.639    29.508     0.200
     1.782    30.703     0.200
     1.669    29.703     0.200
     2.194    36.305     0.200
     2.106    36.008     0.200
     2.111    36.008     0.200
     2.251    38.008     0.200
     2.545    41.508     0.200
     2.554    41.805     0.200
     2.514    41.508     0.200
     2.547    41.406     0.200
     2.618    43.008     0.200
     2.919    47.008     0.200
     2.877    46.508     0.200
     2.930    46.805     0.200
     3.109    50.008     0.200
     3.353    52.102     0.200
     3.353    53.102     0.200
     3.490    57.906     0.200
     3.368    52.805     0.200
     3.605    56.508     0.200
     3.517    56.102     0.200
     3.520    56.602     0.200
     3.696    57.102     0.200
     3.592    56.703     0.200
     3.592    57.703     0.200
     3.637    56.508     0.200
     3.654    57.305     0.200
     3.817    61.102     0.200
     3.790    58.305     0.200
     3.872    61.508     0.200
     3.953    62.305     0.200
     4.078    63.406     0.200
     4.241    68.602     0.200
     4.295    66.406     0.200
     4.720    71.805     0.200
     4.769    70.555     0.200
     4.769    73.906     0.200
     4.747    74.305     0.200
     4.748    72.602     0.200
     4.843    75.305     0.200
     5.232    81.906     0.200
     5.603    86.805     0.200
     6.628   101.508     0.200
     7.208   105.383     0.200
     9.139   131.625     0.200
    10.792   156.305     0.200
     1.634    29.426     0.200
     1.631    29.426     0.200
     1.978    34.629     0.200
     2.034    35.828     0.200
     2.744    46.129     0.200
     2.907    48.426     0.200
     2.986    48.957     0.200
     2.986    49.727     0.200
     6.616    99.848     0.200
     1.437    24.105     0.200
     1.515    25.805     0.200
     1.636    27.406     0.200
     1.855    31.805     0.200
     1.981    32.508     0.200
     2.046    34.406     0.200
     2.269    37.508     0.200
     2.393    38.508     0.200
     2.387    39.105     0.200
     2.621    42.207     0.200
     2.754    43.207     0.200
     2.764    43.805     0.200
     2.860    44.805     0.200
     3.110    47.707     0.200
     3.099    48.707     0.200
     3.296    51.105     0.200
     1.412    26.094     0.200
     1.499    26.996     0.200
     1.496    27.594     0.200
     1.549    26.805     0.200
     1.549    28.496     0.200
     1.795    32.594     0.200
     1.864    32.996     0.200
     1.866    32.895     0.200
     1.916    32.895     0.200
     2.246    38.297     0.200
     2.273    38.395     0.200
     2.464    41.797     0.200
     2.498    42.797     0.200
     2.576    44.297     0.200
     2.615    43.496     0.200
     2.615    44.195     0.200
     2.619    44.797     0.200
     2.702    45.297     0.200
     2.727    44.625     0.200
     2.727    45.094     0.200
     2.776    46.195     0.200
     2.772    44.895     0.200
     2.795    45.496     0.200
     2.855    46.344     0.200
     2.855    46.875     0.200
     2.909    47.594     0.200
     2.987    50.695     0.200
     2.970    48.594     0.200
     3.004    48.996     0.200
     3.119    48.734     0.200
     3.119    50.996     0.200
     3.150    51.297     0.200
     3.222    50.797     0.200
     3.232    51.594     0.200
     3.320    53.297     0.200
     3.345    55.594     0.200
     3.341    53.496     0.200
     3.474    56.395     0.200
     3.549    56.426     0.200
     3.714    58.195     0.200
     3.946    60.496     0.200
     3.946    61.094     0.200
     4.045    64.297     0.200
     4.048    63.895     0.200
     4.087    66.895     0.200
     4.072    63.695     0.200
     4.122    63.176     0.200
     4.122    64.594     0.200
     4.142    64.594     0.200
     4.191    66.496     0.200
     4.232    66.895     0.200
     4.285    67.297     0.200
     4.285    70.496     0.200
     4.403    71.797     0.200
     4.444    70.695     0.200
     4.497    68.465     0.200
     4.497    70.297     0.200
     4.497    72.496     0.200
     4.755    73.195     0.200
     4.772    74.195     0.200
     4.903    77.496     0.200
     5.039    79.094     0.200
     5.013    77.594     0.200
     5.134    78.395     0.200
     5.159    82.094     0.200
     5.284    81.594     0.200
     5.355    80.594     0.200
     5.355    83.395     0.200
     5.378    82.695     0.200
     5.436    83.195     0.200
     5.487    85.094     0.200
     5.563    83.996     0.200
     5.765    87.395     0.200
     5.855    87.594     0.200
     6.032    91.695     0.200
     6.032    94.094     0.200
     6.391    95.094     0.200
     6.391    96.695     0.200
     6.403    97.297     0.200
     6.488    95.176     0.200
     7.062   109.594     0.200
     7.429   115.094     0.200
     8.615   130.094     0.200
     8.910   128.816     0.200
     9.197   133.855     0.200
    12.500   179.156     0.200
    12.597   179.695     0.200
    13.247   186.984     0.200
    13.247   185.984     0.200
    13.885   197.996     0.200
    14.636   206.047     0.200
    14.857   208.297     0.200
    15.501   219.754     0.200
    16.556   233.297     0.200
    16.556   234.336     0.200
    17.190   240.895     0.200
    20.493   280.672     0.200
    20.493   281.695     0.200
     1.292    22.893     0.200
     1.343    23.493     0.200
     1.555    26.393     0.200
     1.730    29.593     0.200
     1.887    32.093     0.200
     2.067    35.093     0.200
     2.173    36.493     0.200
     2.381    37.993     0.200
     2.433    40.093     0.200
     2.715    42.993     0.200
     3.055    47.993     0.200
     3.258    50.593     0.200
     1.169    21.238     0.200
     1.215    22.738     0.200
     1.385    24.639     0.200
     1.537    26.939     0.200
     1.641    28.840     0.200
     1.790    30.840     0.200
     2.202    36.639     0.200
     2.107    35.238     0.200
     2.245    38.238     0.200
     2.562    42.539     0.200
     2.514    42.039     0.200
     2.542    41.238     0.200
     2.615    42.539     0.200
     2.928    48.139     0.200
     2.879    46.939     0.200
     2.929    47.539     0.200
     3.159    50.639     0.200
     3.109    50.340     0.200
     3.355    52.689     0.200
     3.513    56.139     0.200
     3.588    56.039     0.200
     3.634    56.340     0.200
     3.794    59.738     0.200
     4.100    63.840     0.200
     4.290    66.639     0.200
     1.235    22.445     0.200
     1.284    22.742     0.200
     1.435    26.289     0.200
     1.826    31.590     0.200
     1.139    20.141     0.200
     0.939    18.557     0.200
     0.967    19.156     0.200
     1.872    31.857     0.200
     2.302    37.957     0.200
     0.500    11.179     0.200
     0.509    11.479     0.200
     0.735    14.679     0.200
     0.790    14.979     0.200
     0.865    16.578     0.200
     0.867    16.078     0.200
     0.875    16.179     0.200
     0.882    16.479     0.200
     0.952    17.578     0.200
     0.959    17.578     0.200
     0.986    18.578     0.200
     1.025    19.078     0.200
     1.030    18.878     0.200
     1.064    20.479     0.200
     1.064    18.878     0.200
     1.096    19.378     0.200
     1.139    18.979     0.200
     1.146    20.878     0.200
     1.162    19.878     0.200
     1.174    19.679     0.200
     1.175    20.278     0.200
     1.269    21.979     0.200
     1.280    22.378     0.200
     1.318    22.679     0.200
     1.319    22.979     0.200
     1.337    23.578     0.200
     1.344    22.479     0.200
     1.526    25.778     0.200
     1.533    25.778     0.200
     1.581    26.278     0.200
     1.657    27.179     0.200
     1.678    28.479     0.200
     1.705    27.778     0.200
     1.705    27.878     0.200
     1.880    29.479     0.200
     1.964    30.479     0.200
     2.049    32.679     0.200
     2.166    34.179     0.200
     2.362    36.479     0.200
     2.369    36.378     0.200
     2.549    40.278     0.200
     2.799    42.578     0.200
     2.952    45.578     0.200
     2.943    44.378     0.200
     3.063    46.479     0.200
     3.115    47.179     0.200
     3.181    48.578     0.200
     3.187    48.479     0.200
     3.219    47.878     0.200
     3.226    48.778     0.200
     3.286    49.578     0.200
     3.283    50.878     0.200
     3.391    51.878     0.200
     3.493    52.778     0.200
     3.614    54.378     0.200
     3.753    55.578     0.200
     3.883    57.278     0.200
     3.994    60.179     0.200
     4.442    65.979     0.200
     4.491    65.878     0.200
     4.508    66.578     0.200
     5.071    73.679     0.200
     5.530    79.578     0.200
     0.667    12.713     0.200
     0.815    14.074     0.200
     0.815    13.334     0.200
     0.794    15.312     0.200
     0.955    17.014     0.200
     0.927    17.113     0.200
     0.993    17.514     0.200
     1.026    18.713     0.200
     1.089    18.713     0.200
     1.075    19.213     0.200
     1.055    18.533     0.200
     1.055    18.914     0.200
     1.139    19.914     0.200
     1.151    20.113     0.200
     1.091    19.713     0.200
     1.179    19.514     0.200
     1.264    22.334     0.200
     1.288    22.514     0.200
     1.288    22.312     0.200
     1.295    23.514     0.200
     1.348    22.812     0.200
     1.428    24.514     0.200
     1.428    24.703     0.200
     1.467    25.014     0.200
     1.487    25.514     0.200
     1.444    23.414     0.200
     1.630    26.812     0.200
     1.630    26.812     0.200
     1.579    26.213     0.200
     1.711    28.713     0.200
     1.664    27.514     0.200
     1.751    29.604     0.200
     1.820    30.482     0.200
     1.820    30.113     0.200
     1.878    30.713     0.200
     1.872    30.213     0.200
     1.974    31.812     0.200
     1.999    32.713     0.200
     2.012    32.123     0.200
     2.165    33.914     0.200
     2.363    37.514     0.200
     2.444    38.014     0.200
     2.656    40.414     0.200
     2.675    41.914     0.200
     2.881    44.713     0.200
     3.108    47.713     0.200
     3.119    48.504     0.200
     3.102    47.914     0.200
     3.207    49.312     0.200
     3.253    50.613     0.200
     3.232    48.914     0.200
     3.264    48.883     0.200
     3.264    49.113     0.200
     3.378    49.713     0.200
     3.463    51.514     0.200
     3.529    54.174     0.200
     3.557    53.113     0.200
     3.591    55.312     0.200
     3.674    55.914     0.200
     3.773    56.713     0.200
     3.753    56.113     0.200
     3.886    57.934     0.200
     3.886    57.514     0.200
     3.964    61.164     0.200
     3.977    61.213     0.200
     4.062    60.213     0.200
     4.142    63.914     0.200
     4.205    62.414     0.200
     4.139    61.273     0.200
     4.139    61.113     0.200
     4.281    64.414     0.200
     4.429    66.613     0.200
     4.456    67.623     0.200
     4.715    71.113     0.200
     4.755    69.354     0.200
     4.755    69.613     0.200
     4.909    73.014     0.200
     5.080    76.113     0.200
     5.389    80.273     0.200
     5.389    76.393     0.200
     5.366    79.514     0.200
     5.918    86.914     0.200
     5.953    87.113     0.200
     6.384    92.812     0.200
     6.534    94.312     0.200
     6.528    94.113     0.200
     6.681    96.613     0.200
     7.094   102.732     0.200
     7.094   100.963     0.200
     7.094   102.312     0.200
     7.094   100.613     0.200
     7.165   103.812     0.200
     7.289   103.812     0.200
     7.284   105.713     0.200
     7.546   109.713     0.200
     7.615   109.213     0.200
     7.823   113.914     0.200
     8.100   118.344     0.200
     8.928   126.754     0.200
    10.693   151.354     0.200
    10.693   149.934     0.200
    10.693   150.113     0.200
    10.854   153.943     0.200
    13.162   183.283     0.200
    13.162   181.914     0.200
    13.293   188.732     0.200
    13.309   182.193     0.200
    14.553   200.803     0.200
    15.090   208.303     0.200
    15.090   209.312     0.200
    16.436   226.273     0.200
    16.436   224.514     0.200
    16.163   223.533     0.200
    17.150   234.824     0.200
    17.150   235.613     0.200
    17.972   246.232     0.200
     0.938    18.307     0.200
     1.213    21.906     0.200
     1.361    24.206     0.200
     1.387    24.807     0.200
     1.657    29.206     0.200
     1.792    30.307     0.200
     2.204    36.606     0.200
     2.564    41.606     0.200
     3.161    49.706     0.200
     3.394    52.406     0.200
     1.649    28.436     0.200
     2.011    33.936     0.200
     2.052    34.536     0.200
     1.214    22.799     0.200
     1.366    24.998     0.200
     1.393    25.498     0.200
     1.379    25.398     0.200
     1.621    29.199     0.200
     1.639    29.498     0.200
     1.673    30.098     0.200
     1.730    30.699     0.200
     1.938    33.799     0.200
     1.990    33.898     0.200
     2.074    35.598     0.200
     2.407    41.799     0.200
     2.445    41.799     0.200
     2.480    41.498     0.200
     2.644    43.799     0.200
     2.762    45.299     0.200
     2.913    47.299     0.200
     2.946    47.699     0.200
     3.001    48.699     0.200
     3.057    49.098     0.200
     3.126    50.498     0.200
     3.169    50.898     0.200
     3.292    52.998     0.200
     3.690    57.898     0.200
     4.234    65.699     0.200
     4.310    66.199     0.200
     4.271    67.299     0.200
     1.444    24.297     0.200
     1.511    25.797     0.200
     1.837    31.000     0.200
     1.283    22.727     0.200
     1.296    23.328     0.200
     1.829    30.828     0.200
     3.732    58.328     0.200
     1.201    21.715     0.200
     2.581    41.914     0.200
     3.074    48.617     0.200
     3.483    54.617     0.200
     4.088    61.617     0.200
     0.743    15.766     0.200
     0.806    15.961     0.200
     0.923    18.664     0.200
     1.426    25.062     0.200
     1.928    32.867     0.200
     3.475    53.766     0.200
     0.840    16.723     0.200
     0.832    17.625     0.200
     0.870    17.223     0.200
     0.940    19.523     0.200
     0.957    18.625     0.200
     1.033    20.723     0.200
     1.034    21.324     0.200
     1.136    21.625     0.200
     1.189    23.223     0.200
     1.203    22.422     0.200
     1.791    31.422     0.200
     1.898    32.523     0.200
     2.435    41.023     0.200
     2.767    44.922     0.200
     2.783    46.523     0.200
     1.223    21.895     0.200
     1.774    29.695     0.200
     1.828    31.496     0.200
     1.864    32.195     0.200
     1.874    31.895     0.200
     1.885    32.094     0.200
     2.029    34.793     0.200
     2.084    33.895     0.200
     2.214    37.094     0.200
     2.311    38.395     0.200
     1.133    21.129     0.200
     1.111    21.426     0.200
     1.189    21.828     0.200
     1.256    22.129     0.200
     1.256    22.328     0.200
     1.299    24.328     0.200
     1.339    24.426     0.200
     1.390    25.027     0.200
     1.523    26.926     0.200
     1.571    27.828     0.200
     1.556    27.539     0.200
     1.556    27.926     0.200
     1.558    27.828     0.200
     1.668    29.227     0.200
     1.676    30.328     0.200
     1.727    30.629     0.200
     1.711    30.426     0.200
     1.740    30.227     0.200
     1.751    31.227     0.200
     1.803    31.727     0.200
     1.838    31.727     0.200
     1.843    32.426     0.200
     1.848    32.227     0.200
     1.916    32.828     0.200
     1.977    33.926     0.200
     2.060    35.426     0.200
     2.051    34.129     0.200
     2.112    35.828     0.200
     2.141    36.426     0.200
     2.145    36.129     0.200
     2.180    35.926     0.200
     2.306    38.828     0.200
     2.315    38.527     0.200
     2.343    38.527     0.200
     2.575    42.926     0.200
     2.836    45.727     0.200
     2.917    46.629     0.200
     2.927    46.328     0.200
     2.929    47.426     0.200
     2.969    47.027     0.200
     3.031    48.129     0.200
     3.203    50.828     0.200
     3.552    55.629     0.200
     3.585    55.527     0.200
     3.770    58.027     0.200
     3.961    61.027     0.200
     4.322    64.426     0.200
     4.526    69.129     0.200
     4.549    66.789     0.200
     4.587    70.129     0.200
     4.665    70.727     0.200
     4.784    72.629     0.200
     5.054    75.227     0.200
     5.392    80.559     0.200
     5.392    81.828     0.200
     5.798    85.129     0.200
     8.970   130.227     0.200
     8.973   129.828     0.200
     9.655   140.426     0.200
     9.714   141.828     0.200
     9.740   141.527     0.200
    10.197   145.797     0.200
    17.445   241.906     0.200
     1.133    21.266     0.200
     1.125    19.766     0.200
     1.166    21.766     0.200
     1.322    23.969     0.200
     1.552    27.570     0.200
     1.581    27.305     0.200
     1.696    29.164     0.200
     1.768    30.266     0.200
     1.857    31.664     0.200
     1.866    31.570     0.200
     2.076    33.570     0.200
     2.130    35.867     0.200
     2.165    36.070     0.200
     2.196    36.367     0.200
     2.205    36.070     0.200
     2.860    45.164     0.200
     2.940    45.766     0.200
     2.949    47.570     0.200
     2.950    47.766     0.200
     2.993    46.969     0.200
     3.052    48.266     0.200
     3.181    50.570     0.200
     3.609    55.367     0.200
     3.793    57.867     0.200
     4.527    66.656     0.200
     4.527    68.867     0.200
     4.611    69.664     0.200
     4.686    72.766     0.200
     5.078    74.867     0.200
     5.413    81.711     0.200
     6.488    91.945     0.200
     8.995   129.680     0.200
    11.045   156.500     0.200
    19.645   268.734     0.200
     1.145    20.125     0.200
     1.747    30.125     0.200
     1.873    31.828     0.200
     2.096    34.727     0.200
     3.069    48.523     0.200
     3.163    50.625     0.200
     1.122    19.582     0.200
     1.343    23.383     0.200
     1.351    23.883     0.200
     1.638    28.184     0.200
     1.816    31.082     0.200
     2.815    44.582     0.200
     1.307    23.793     0.200
     1.367    24.693     0.200
     1.371    24.893     0.200
     1.440    25.492     0.200
     1.482    26.693     0.200
     1.471    26.293     0.200
     1.492    26.492     0.200
     1.672    29.094     0.200
     1.767    30.193     0.200
     1.794    31.293     0.200
     1.860    32.893     0.200
     1.928    33.693     0.200
     2.028    34.992     0.200
     2.095    35.492     0.200
     2.230    37.594     0.200
     2.263    37.693     0.200
     2.505    40.793     0.200
     2.537    41.793     0.200
     2.662    43.094     0.200
     2.696    44.594     0.200
     2.722    44.594     0.200
     2.782    45.893     0.200
     2.807    45.594     0.200
     2.821    45.492     0.200
     2.945    46.793     0.200
     3.488    55.594     0.200
     3.913    61.992     0.200
     4.017    63.293     0.200
     4.200    62.873     0.200
     6.377    93.492     0.200
     9.954   142.424     0.200
     1.242    23.021     0.200
     1.273    23.121     0.200
     1.255    23.109     0.200
     1.315    23.711     0.200
     1.448    25.750     0.200
     1.448    25.012     0.200
     1.469    26.312     0.200
     1.497    26.211     0.200
     1.473    26.812     0.200
     1.667    29.012     0.200
     1.759    30.211     0.200
     1.788    30.812     0.200
     1.864    32.211     0.200
     2.022    34.012     0.200
     2.026    33.812     0.200
     2.090    35.812     0.200
     2.233    36.711     0.200
     2.259    37.711     0.200
     2.502    40.621     0.200
     2.530    41.770     0.200
     2.530    42.211     0.200
     2.656    43.312     0.200
     2.690    43.609     0.200
     2.714    44.410     0.200
     2.776    45.812     0.200
     2.814    45.711     0.200
     2.944    46.312     0.200
     2.984    48.012     0.200
     3.847    58.750     0.200
     6.372    94.430     0.200
     9.950   143.762     0.200
     9.950   143.492     0.200
    11.905   173.953     0.200
    11.905   169.082     0.200
    13.076   182.430     0.200
    13.139   182.312     0.200
    15.080   213.820     0.200
    15.080   212.312     0.200
     1.297    23.281     0.200
     1.429    23.531     0.200
     1.429    25.281     0.200
     1.485    26.281     0.200
     1.678    29.281     0.200
     1.779    30.082     0.200
     1.803    30.980     0.200
     2.032    33.980     0.200
     2.103    34.980     0.200
     2.225    37.082     0.200
     2.268    37.781     0.200
     2.509    40.902     0.200
     2.509    40.684     0.200
     2.547    42.133     0.200
     2.670    43.082     0.200
     2.705    44.082     0.200
     2.732    44.184     0.200
     2.792    45.582     0.200
     2.830    45.582     0.200
     2.946    46.480     0.200
     2.968    46.781     0.200
     3.138    50.980     0.200
     3.498    54.781     0.200
     3.826    58.934     0.200
     3.920    60.781     0.200
     4.214    62.512     0.200
     5.521    79.773     0.200
     6.384    96.152     0.200
     6.384    95.820     0.200
     9.961   145.160     0.200
    13.116   184.062     0.200
    14.683   205.531     0.200
    15.067   212.641     0.200
    16.237   226.094     0.200
     1.328    23.740     0.200
     1.394    24.610     0.200
     1.695    29.030     0.200
     1.990    33.271     0.200
     2.531    41.230     0.200
     1.624    27.805     0.200
     1.782    30.075     0.200
     2.091    34.706     0.200
     2.100    34.825     0.200
     2.194    36.195     0.200
     2.247    36.975     0.200
     2.502    40.666     0.200
     2.550    40.775     0.200
     2.608    41.825     0.200
     2.861    45.495     0.200
     2.918    46.045     0.200
     2.919    46.095     0.200
     3.138    49.166     0.200
     3.387    52.285     0.200
     3.508    54.385     0.200
     3.515    54.295     0.200
     3.603    55.146     0.200
     3.585    55.475     0.200
     3.597    55.525     0.200
     3.630    55.975     0.200
     4.736    70.956     0.200
     0.512    12.117     0.200
     0.518    11.039     0.200
     0.678    13.570     0.200
     0.768    15.117     0.200
     0.780    15.680     0.200
     0.817    15.922     0.200
     0.779    14.375     0.200
     0.856    15.742     0.200
     0.918    17.125     0.200
     0.969    17.250     0.200
     0.907    16.102     0.200
     1.039    18.906     0.200
     0.853    14.727     0.200
     0.853    14.547     0.200
     0.853    14.938     0.200
     1.181    20.906     0.200
     1.097    18.727     0.200
     1.299    22.547     0.200
     1.301    22.680     0.200
     1.382    23.828     0.200
     1.333    22.758     0.200
     1.316    22.625     0.200
     1.467    25.258     0.200
     1.392    23.711     0.200
     1.568    26.500     0.200
     1.592    26.750     0.200
     1.413    24.000     0.200
     1.531    25.977     0.200
     1.754    29.680     0.200
     1.614    26.820     0.200
     1.569    25.758     0.200
     1.733    29.000     0.200
     1.599    25.578     0.200
     1.825    29.406     0.200
     1.724    28.609     0.200
     1.847    30.258     0.200
     1.996    32.742     0.200
     2.222    35.930     0.200
     2.117    33.688     0.200
     2.600    40.930     0.200
     2.314    36.391     0.200
     2.440    38.336     0.200
     2.826    44.297     0.200
     2.926    45.578     0.200
     2.780    43.305     0.200
     2.788    42.469     0.200
     3.311    51.516     0.200
     2.921    44.078     0.200
     2.921    44.266     0.200
     3.127    48.086     0.200
     3.203    48.539     0.200
     3.305    50.039     0.200
     3.370    51.859     0.200
     3.682    57.180     0.200
     3.697    57.328     0.200
     3.429    50.531     0.200
     3.429    52.109     0.200
     3.556    53.508     0.200
     3.641    53.195     0.200
     3.641    54.461     0.200
     3.617    54.789     0.200
     3.623    55.125     0.200
     3.658    54.969     0.200
     4.001    60.727     0.200
     3.724    56.195     0.200
     3.824    57.242     0.200
     3.900    58.641     0.200
     4.174    63.789     0.200
     3.933    58.828     0.200
     4.052    61.398     0.200
     4.157    63.086     0.200
     4.324    63.977     0.200
     4.631    69.242     0.200
     4.799    71.328     0.200
     5.017    73.117     0.200
     5.113    75.867     0.200
     5.113    75.602     0.200
     4.887    72.961     0.200
     4.949    72.711     0.200
     4.930    72.969     0.200
     5.036    73.688     0.200
     5.466    76.938     0.200
     5.639    82.945     0.200
     5.748    84.047     0.200
     5.792    84.695     0.200
     6.250    90.695     0.200
     6.751    96.766     0.200
     6.567    95.227     0.200
     7.068   102.781     0.200
     6.848    99.156     0.200
     6.861    99.430     0.200
     7.176   101.727     0.200
     7.281   103.930     0.200
     7.281   105.508     0.200
     7.281   104.531     0.200
    10.882   153.875     0.200
    10.882   153.266     0.200
    12.884   175.891     0.200
    17.346   237.719     0.200
     1.143    18.578     0.200
     2.803    40.809     0.200
     3.937    59.488     0.200
     4.904    72.430     0.200
     5.108    76.887     0.200
     7.575   110.180     0.200
    10.519   151.566     0.200
    12.683   175.250     0.200
    12.683   174.727     0.200
    12.861   175.309     0.200
    12.861   175.508     0.200
    12.861   177.887     0.200
    13.414   186.527     0.200
    13.414   187.773     0.200
    15.568   216.430     0.200
    16.551   227.527     0.200
     2.930    45.112     0.200
     5.281    77.143     0.200
     5.492    80.543     0.200
     6.645    96.202     0.200
     9.908   142.103     0.200
    10.244   147.662     0.200
    10.244   145.482     0.200
    12.404   176.143     0.200
    12.404   177.803     0.200
    12.404   174.986     0.200
    12.404   174.753     0.200
    13.207   183.412     0.200
    13.207   184.412     0.200
    13.251   186.053     0.200
    13.251   186.263     0.200
    14.621   203.463     0.200
    15.742   221.853     0.200
    16.092   221.562     0.200
    16.092   221.072     0.200
    16.492   228.183     0.200
    16.714   232.862     0.200
    18.011   249.202     0.200
     3.464    54.383     0.200
     5.281    78.437     0.200
     5.492    83.624     0.200
     6.645    95.726     0.200
     6.645    96.843     0.200
     9.908   141.506     0.200
    10.244   148.371     0.200
    13.207   183.540     0.200
    13.207   186.343     0.200
    13.251   185.769     0.200
    15.742   219.653     0.200
    16.492   230.438     0.200
    18.011   248.822     0.200
    19.173   264.143     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.529    47.203     0.200
     2.787    51.406     0.200
     4.109    76.742     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.179     4.453     0.200
     1.045    18.234     0.200
     0.892    16.258     0.200
     2.586    44.258     0.200
     0.417     7.607     0.200
     0.417     7.832     0.200
     0.634    12.309     0.200
     0.881    16.309     0.200
     0.972    18.107     0.200
     0.466     9.623     0.200
     0.639    13.014     0.200
     1.060    20.039     0.200
     1.060    19.514     0.200
     1.226    22.014     0.200
     1.226    22.324     0.200
     1.478    26.613     0.200
     1.478    26.824     0.200
     1.404    25.113     0.200
     1.404    25.373     0.200
     1.865    32.713     0.200
     2.171    36.994     0.200
     0.715    14.016     0.200
     1.055    19.617     0.200
     1.352    23.617     0.200
     1.448    25.812     0.200
     0.178     4.537     0.200
     0.464     8.352     0.200
     0.464     8.076     0.200
     0.557    10.877     0.200
     0.557    11.156     0.200
     1.160    22.377     0.200
     1.231    22.676     0.200
     1.936    34.377     0.200
     2.093    36.877     0.200
     0.561    11.156     0.200
     0.622    11.656     0.200
     0.746    14.453     0.200
     0.913    16.859     0.200
     0.913    16.758     0.200
     0.225     5.023     0.200
     0.600    13.328     0.200
     1.063    20.422     0.200
     1.658    29.125     0.200
     0.069     2.414     0.200
     0.180     4.109     0.200
     0.227     5.109     0.200
     0.239     5.414     0.200
     0.351     7.414     0.200
     0.356     8.812     0.200
     0.398     7.414     0.200
     0.424     7.812     0.200
     0.470     9.109     0.200
     0.510    10.711     0.200
     0.596    11.414     0.200
     0.654    12.508     0.200
     0.738    14.609     0.200
     0.761    14.711     0.200
     0.806    16.508     0.200
     0.855    16.109     0.200
     0.856    16.711     0.200
     0.920    17.812     0.200
     1.009    18.812     0.200
     1.044    19.609     0.200
     1.061    20.312     0.200
     1.112    20.414     0.200
     1.106    20.609     0.200
     1.273    23.508     0.200
     1.276    23.609     0.200
     1.287    23.609     0.200
     1.309    23.711     0.200
     1.421    25.508     0.200
     1.427    25.711     0.200
     1.459    26.609     0.200
     1.741    31.109     0.200
     0.211     4.666     0.200
     0.432     8.467     0.200
     0.465     8.967     0.200
     0.501    10.066     0.200
     0.563    10.865     0.200
     0.532     9.967     0.200
     0.589    11.766     0.200
     0.656    13.467     0.200
     0.770    14.467     0.200
     0.813    16.365     0.200
     0.838    16.666     0.200
     0.907    17.266     0.200
     1.156    21.166     0.200
     1.166    21.365     0.200
     1.168    21.766     0.200
     1.873    34.066     0.200
     0.084     2.840     0.200
     0.194     4.043     0.200
     0.202     4.543     0.200
     0.236     5.043     0.200
     0.242     5.543     0.200
     0.308     6.242     0.200
     0.391     6.141     0.200
     0.445     9.242     0.200
     0.428     9.043     0.200
     0.468     9.340     0.200
     0.471     9.141     0.200
     0.493    10.043     0.200
     0.609    11.941     0.200
     0.613    11.941     0.200
     0.671    11.941     0.200
     0.668    12.840     0.200
     0.745    14.340     0.200
     0.803    14.941     0.200
     0.818    15.840     0.200
     0.864    16.742     0.200
     0.986    18.641     0.200
     1.083    20.141     0.200
     1.848    34.242     0.200
     0.621    12.859     0.200
     0.768    14.656     0.200
     0.948    17.461     0.200
     0.987    18.562     0.200
     1.043    18.562     0.200
     1.032    19.258     0.200
     1.021    19.078     0.200
     1.093    19.656     0.200
     1.057    19.562     0.200
     1.242    23.359     0.200
     1.242    21.867     0.200
     1.242    22.258     0.200
     1.221    22.125     0.200
     1.248    23.258     0.200
     1.387    24.359     0.200
     1.422    24.859     0.200
     1.440    25.359     0.200
     1.534    27.062     0.200
     1.531    26.258     0.200
     1.600    28.258     0.200
     1.558    27.359     0.200
     1.669    28.758     0.200
     0.203     4.723     0.200
     0.264     5.522     0.200
     0.334     5.923     0.200
     0.380     6.623     0.200
     0.361     7.723     0.200
     0.409     8.022     0.200
     0.527     9.923     0.200
     0.621    11.423     0.200
     0.650    13.022     0.200
     0.744    15.123     0.200
     0.731    13.823     0.200
     0.848    16.923     0.200
     0.865    15.923     0.200
     0.913    18.123     0.200
     1.146    20.723     0.200
     1.152    22.323     0.200
     1.210    22.423     0.200
     1.302    24.823     0.200
     1.346    24.723     0.200
     1.480    27.423     0.200
     1.601    28.323     0.200
     1.683    30.923     0.200
     1.694    30.923     0.200
     1.785    32.022     0.200
     1.839    33.022     0.200
     2.098    37.723     0.200
     2.272    40.522     0.200
     0.277     6.090     0.200
     0.310     5.691     0.200
     0.358     6.992     0.200
     0.420     8.293     0.200
     0.485     9.090     0.200
     0.483     8.992     0.200
     0.486    10.191     0.200
     0.602    11.691     0.200
     0.705    13.391     0.200
     0.815    16.191     0.200
     0.872    16.492     0.200
     0.943    17.191     0.200
     0.976    17.590     0.200
     0.986    19.090     0.200
     1.044    18.590     0.200
     1.121    21.090     0.200
     1.189    22.391     0.200
     1.294    24.090     0.200
     1.311    24.492     0.200
     1.310    23.590     0.200
     1.340    24.391     0.200
     1.425    25.492     0.200
     0.149     3.664     0.200
     0.220     3.863     0.200
     0.296     5.664     0.200
     0.348     7.266     0.200
     0.444     9.266     0.200
     0.470     9.664     0.200
     0.543    11.062     0.200
     0.633    12.062     0.200
     0.630    12.062     0.200
     0.733    13.465     0.200
     0.767    14.266     0.200
     0.752    14.664     0.200
     0.772    14.465     0.200
     1.038    19.664     0.200
     1.042    18.965     0.200
     1.018    19.062     0.200
     1.312    23.863     0.200
     1.481    27.164     0.200
     1.459    26.766     0.200
     1.550    27.363     0.200
     1.594    28.863     0.200
     1.674    29.664     0.200
     1.726    30.766     0.200
     1.774    31.766     0.200
     1.803    32.164     0.200
     2.069    36.766     0.200
     2.211    39.965     0.200
     0.157     3.859     0.200
     0.184     3.961     0.200
     0.267     5.262     0.200
     0.282     5.262     0.200
     0.391     7.660     0.200
     0.437     8.660     0.200
     0.489    10.859     0.200
     0.506     9.461     0.200
     0.527    10.262     0.200
     0.536    10.961     0.200
     0.560    10.859     0.200
     0.642    13.160     0.200
     0.676    12.559     0.200
     0.685    13.461     0.200
     0.702    13.461     0.200
     0.712    13.359     0.200
     0.735    14.859     0.200
     0.782    14.961     0.200
     0.974    19.359     0.200
     1.021    18.660     0.200
     1.026    19.059     0.200
     1.267    24.160     0.200
     1.701    30.359     0.200
     0.028     1.508     0.200
     0.200     5.711     0.200
     0.248     6.008     0.200
     0.341     7.305     0.200
     0.383     8.508     0.200
     0.480     9.508     0.200
     0.453     9.711     0.200
     0.530    10.305     0.200
     0.546    10.609     0.200
     0.543    11.211     0.200
     0.640    12.805     0.200
     0.641    12.609     0.200
     0.700    12.906     0.200
     0.777    14.805     0.200
     0.789    15.008     0.200
     0.788    14.711     0.200
     0.801    15.211     0.200
     0.920    17.305     0.200
     0.938    17.711     0.200
     0.948    17.805     0.200
     0.944    17.805     0.200
     1.068    20.109     0.200
     1.165    21.406     0.200
     1.226    22.406     0.200
     1.239    22.906     0.200
     1.365    25.211     0.200
     1.391    25.609     0.200
     1.614    28.906     0.200
     1.691    29.711     0.200
     1.714    29.906     0.200
     0.227     4.734     0.200
     0.257     5.034     0.200
     0.414     7.859     0.200
     0.414     8.234     0.200
     0.447     8.234     0.200
     0.517    10.034     0.200
     0.512     9.734     0.200
     0.547    11.834     0.200
     0.557    10.934     0.200
     0.571    11.334     0.200
     0.584    11.034     0.200
     0.589    11.234     0.200
     0.604    12.034     0.200
     0.649    12.334     0.200
     0.751    13.834     0.200
     0.798    15.834     0.200
     0.848    16.434     0.200
     0.867    16.434     0.200
     0.896    18.034     0.200
     0.891    16.934     0.200
     0.918    17.934     0.200
     0.931    16.334     0.200
     0.963    18.634     0.200
     0.989    19.834     0.200
     1.075    20.834     0.200
     1.145    21.634     0.200
     1.151    21.234     0.200
     1.160    21.434     0.200
     0.162     4.911     0.200
     0.289     5.311     0.200
     0.475     8.911     0.200
     0.519     9.811     0.200
     0.582    10.111     0.200
     0.539    10.811     0.200
     0.600    11.911     0.200
     0.633    13.211     0.200
     0.650    12.211     0.200
     0.638    12.911     0.200
     0.806    14.311     0.200
     0.855    17.011     0.200
     0.912    18.111     0.200
     0.951    17.911     0.200
     0.946    17.811     0.200
     0.906    16.211     0.200
     0.995    19.311     0.200
     1.180    21.811     0.200
     1.248    23.011     0.200
     1.444    26.311     0.200
     1.527    27.911     0.200
     1.531    27.811     0.200
     2.952    50.211     0.200
     0.085     2.578     0.200
     0.170     3.883     0.200
     0.217     3.883     0.200
     0.188     4.383     0.200
     0.270     5.984     0.200
     0.270     6.633     0.200
     0.350     7.078     0.200
     0.362     7.383     0.200
     0.424     7.883     0.200
     0.420     8.180     0.200
     0.634    12.383     0.200
     0.608    11.781     0.200
     0.637    12.383     0.200
     0.646    12.680     0.200
     0.672    12.883     0.200
     0.770    14.078     0.200
     0.770    14.984     0.200
     0.772    15.180     0.200
     0.836    15.984     0.200
     0.840    16.078     0.200
     0.857    15.781     0.200
     0.920    16.883     0.200
     1.017    18.883     0.200
     1.008    19.281     0.200
     1.074    20.578     0.200
     1.224    22.281     0.200
     2.005    34.781     0.200
     0.057     1.693     0.200
     0.140     2.893     0.200
     0.178     3.593     0.200
     0.238     4.293     0.200
     0.309     6.193     0.200
     0.332     6.693     0.200
     0.350     7.893     0.200
     0.373     7.393     0.200
     0.456     8.893     0.200
     0.457    10.693     0.200
     0.503     9.393     0.200
     0.604    11.193     0.200
     0.623    12.093     0.200
     0.667    12.693     0.200
     0.744    14.093     0.200
     0.863    15.693     0.200
     0.854    16.293     0.200
     1.106    21.293     0.200
     1.260    23.393     0.200
     1.395    26.493     0.200
     1.959    34.293     0.200
     0.223     4.156     0.200
     0.189     4.859     0.200
     0.415     7.555     0.200
     0.432     9.156     0.200
     0.466     8.453     0.200
     0.503     9.859     0.200
     0.560    10.156     0.200
     0.561    10.859     0.200
     0.609    12.359     0.200
     0.627    12.859     0.200
     0.705    14.156     0.200
     0.721    13.953     0.200
     0.771    14.859     0.200
     0.860    16.656     0.200
     1.006    18.953     0.200
     1.003    18.359     0.200
     1.041    19.555     0.200
     1.036    19.258     0.200
     1.058    20.156     0.200
     1.096    21.555     0.200
     1.352    24.953     0.200
     1.637    30.656     0.200
     1.936    34.656     0.200
     1.977    35.055     0.200
     2.057    36.156     0.200
     0.245     6.188     0.200
     0.342     7.289     0.200
     0.427     8.588     0.200
     0.491     9.789     0.200
     0.550    10.389     0.200
     0.640    12.289     0.200
     0.655    12.688     0.200
     0.682    13.289     0.200
     0.721    14.289     0.200
     0.748    15.088     0.200
     0.766    14.789     0.200
     0.793    14.588     0.200
     0.862    16.688     0.200
     0.882    16.289     0.200
     0.908    16.789     0.200
     0.898    17.188     0.200
     0.952    18.389     0.200
     1.060    19.488     0.200
     0.257     6.172     0.200
     0.323     7.273     0.200
     0.417     8.473     0.200
     0.494     9.973     0.200
     0.545    10.273     0.200
     0.639    12.672     0.200
     0.667    13.172     0.200
     0.689    13.371     0.200
     0.710    13.371     0.200
     0.778    14.973     0.200
     0.810    15.070     0.200
     0.867    16.371     0.200
     0.879    17.070     0.200
     0.921    17.773     0.200
     1.041    20.070     0.200
     1.298    23.473     0.200
     1.388    25.371     0.200
     1.533    27.473     0.200
     1.600    28.371     0.200
     1.840    32.172     0.200
     1.833    32.070     0.200
     0.108     2.742     0.200
     0.271     5.641     0.200
     0.345     7.242     0.200
     0.331     6.840     0.200
     0.408     8.543     0.200
     0.340     7.543     0.200
     0.563    10.641     0.200
     0.548    10.543     0.200
     0.585    10.441     0.200
     0.656    11.543     0.200
     0.702    13.043     0.200
     0.743    14.543     0.200
     0.720    14.941     0.200
     0.759    14.840     0.200
     0.898    17.742     0.200
     0.913    17.941     0.200
     0.934    16.941     0.200
     0.924    16.941     0.200
     1.095    21.941     0.200
     1.193    21.242     0.200
     1.178    22.840     0.200
     1.159    20.742     0.200
     1.484    27.742     0.200
     2.188    38.141     0.200
     0.207     5.133     0.200
     0.294     5.832     0.200
     0.445     8.234     0.200
     0.485     8.934     0.200
     0.482     9.734     0.200
     0.538    10.434     0.200
     0.583    10.734     0.200
     0.602    12.633     0.200
     0.598    12.133     0.200
     0.619    12.133     0.200
     0.642    12.734     0.200
     0.648    12.633     0.200
     0.834    16.434     0.200
     0.818    14.934     0.200
     0.818    15.133     0.200
     0.899    17.535     0.200
     0.928    17.434     0.200
     0.893    16.734     0.200
     0.956    17.332     0.200
     1.022    20.332     0.200
     1.189    22.832     0.200
     1.184    22.035     0.200
     1.192    22.535     0.200
     1.210    22.234     0.200
     1.458    26.734     0.200
     1.481    27.234     0.200
     1.502    27.332     0.200
     1.855    33.832     0.200
     0.187     4.199     0.200
     0.187     4.332     0.200
     0.472     7.332     0.200
     0.468     8.832     0.200
     0.561     9.629     0.200
     0.611    11.730     0.200
     0.634    11.730     0.200
     0.667    12.430     0.200
     0.814    14.832     0.200
     0.804    14.930     0.200
     0.804    14.629     0.200
     0.869    15.629     0.200
     0.915    18.129     0.200
     0.945    17.930     0.200
     0.980    18.930     0.200
     1.041    20.430     0.200
     1.056    21.031     0.200
     1.193    22.230     0.200
     1.210    22.629     0.200
     1.197    21.531     0.200
     0.830    15.475     0.200
     0.938    18.023     0.200
     0.970    18.125     0.200
     1.009    18.824     0.200
     1.036    19.725     0.200
     1.088    20.424     0.200
     1.105    20.023     0.200
     1.099    20.523     0.200
     1.154    21.125     0.200
     0.550    11.037     0.200
     0.597    11.637     0.200
     0.582    11.738     0.200
     0.665    13.037     0.200
     0.665    13.037     0.200
     0.974    18.537     0.200
     0.991    19.238     0.200
     1.100    21.238     0.200
     1.092    20.338     0.200
     1.115    21.438     0.200
     1.170    22.037     0.200
     1.254    23.137     0.200
     1.321    24.838     0.200
     1.362    24.637     0.200
     1.382    25.537     0.200
     1.371    24.738     0.200
     1.471    26.738     0.200
     1.590    28.137     0.200
     1.607    29.238     0.200
     1.634    29.438     0.200
     0.229     6.043     0.200
     0.510    10.941     0.200
     0.635    12.844     0.200
     0.662    13.141     0.200
     0.780    15.543     0.200
     0.830    16.141     0.200
     0.899    17.242     0.200
     0.976    19.043     0.200
     1.055    19.043     0.200
     1.166    22.141     0.200
     1.205    22.043     0.200
     1.302    23.543     0.200
     1.361    25.344     0.200
     1.406    25.242     0.200
     1.513    27.543     0.200
     1.654    29.242     0.200
     1.830    31.543     0.200
     2.011    34.641     0.200
     2.415    41.141     0.200
     0.714    15.102     0.200
     0.880    16.701     0.200
     1.068    20.201     0.200
     1.053    20.301     0.200
     1.088    20.801     0.200
     1.151    21.401     0.200
     1.120    21.602     0.200
     1.233    22.801     0.200
     1.398    27.102     0.200
     0.234     4.434     0.200
     0.213     5.035     0.200
     0.301     6.035     0.200
     0.439     8.934     0.200
     0.445     9.336     0.200
     0.471     9.535     0.200
     0.491     9.434     0.200
     0.590    11.637     0.200
     0.648    12.934     0.200
     0.787    15.637     0.200
     0.808    15.234     0.200
     0.886    16.535     0.200
     0.963    17.637     0.200
     1.195    21.836     0.200
     1.202    22.734     0.200
     1.199    22.234     0.200
     0.198     5.037     0.200
     0.247     4.537     0.200
     0.305     6.237     0.200
     0.497     9.537     0.200
     0.475    10.637     0.200
     0.548    11.837     0.200
     0.586    11.137     0.200
     0.596    11.437     0.200
     0.605    10.037     0.200
     0.614    13.337     0.200
     0.654    12.637     0.200
     0.798    16.037     0.200
     0.882    15.337     0.200
     0.967    18.537     0.200
     1.031    18.937     0.200
     1.190    21.537     0.200
     1.200    21.637     0.200
     1.204    23.137     0.200
     1.391    24.537     0.200
     1.493    25.937     0.200
     1.906    33.737     0.200
     0.262     5.602     0.200
     0.098     2.203     0.200
     0.282     5.703     0.200
     0.145     3.402     0.200
     0.143     4.203     0.200
     0.262     5.781     0.200
     0.262     6.004     0.200
     0.428     7.805     0.200
     0.313     6.504     0.200
     0.404     8.504     0.200
     0.646    12.504     0.200
     0.796    15.203     0.200
     0.650    13.203     0.200
     0.613    11.504     0.200
     0.654    12.102     0.200
     0.565    11.004     0.200
     0.773    14.805     0.200
     0.933    16.504     0.200
     0.874    15.703     0.200
     0.822    15.504     0.200
     0.931    17.703     0.200
     0.824    15.902     0.200
     0.989    18.402     0.200
     0.985    19.402     0.200
     1.291    23.703     0.200
     1.250    23.203     0.200
     1.359    24.805     0.200
     1.456    26.203     0.200
     1.654    29.703     0.200
     1.827    31.902     0.200
     2.020    35.402     0.200
     2.239    40.004     0.200
     3.903    66.402     0.200
     0.094     2.406     0.200
     0.150     3.508     0.200
     0.156     4.211     0.200
     0.249     3.711     0.200
     0.265     5.906     0.200
     0.277     5.711     0.200
     0.323     6.406     0.200
     0.425     7.711     0.200
     0.413     8.406     0.200
     0.577    11.211     0.200
     0.618    11.711     0.200
     0.640    11.812     0.200
     0.658    12.406     0.200
     0.650    12.609     0.200
     0.773    15.312     0.200
     0.824    15.312     0.200
     0.827    15.508     0.200
     0.870    15.609     0.200
     0.926    16.812     0.200
     0.996    18.312     0.200
     0.994    19.406     0.200
     1.251    23.211     0.200
     1.306    25.211     0.200
     1.380    25.008     0.200
     1.477    26.906     0.200
     1.659    30.008     0.200
     1.830    32.211     0.200
     2.014    35.812     0.200
     2.012    35.906     0.200
     0.093     2.461     0.200
     0.154     3.664     0.200
     0.169     4.461     0.200
     0.237     3.562     0.200
     0.275     5.961     0.200
     0.270     6.258     0.200
     0.331     6.664     0.200
     0.420     7.961     0.200
     0.422     9.461     0.200
     0.588    11.359     0.200
     0.634    12.062     0.200
     0.622    11.961     0.200
     0.652    12.461     0.200
     0.659    12.758     0.200
     0.825    15.359     0.200
     0.868    15.859     0.200
     0.914    17.359     0.200
     0.920    17.758     0.200
     1.003    19.961     0.200
     1.001    18.758     0.200
     1.254    23.758     0.200
     1.284    23.461     0.200
     1.488    26.758     0.200
     0.283     4.939     0.200
     0.337     6.139     0.200
     0.479     8.539     0.200
     0.493     9.340     0.200
     0.468     9.639     0.200
     0.611    11.719     0.200
     0.611    11.939     0.200
     0.663    11.939     0.200
     0.661    12.639     0.200
     0.729    13.639     0.200
     0.821    14.840     0.200
     0.875    15.240     0.200
     0.794    16.510     0.200
     0.794    15.680     0.200
     0.794    16.240     0.200
     1.010    18.439     0.200
     1.018    19.939     0.200
     1.126    20.740     0.200
     1.551    29.340     0.200
     1.632    30.240     0.200
     0.119     3.016     0.200
     0.168     4.215     0.200
     0.226     4.416     0.200
     0.264     5.115     0.200
     0.362     7.615     0.200
     0.357     8.516     0.200
     0.395     8.215     0.200
     0.438     9.115     0.200
     0.455     9.215     0.200
     0.447     8.615     0.200
     0.459     8.816     0.200
     0.562    10.916     0.200
     0.563    11.016     0.200
     0.603    12.115     0.200
     0.727    13.416     0.200
     0.748    14.016     0.200
     0.815    15.715     0.200
     1.058    19.615     0.200
     1.420    25.516     0.200
     1.625    29.115     0.200
     0.151     3.475     0.200
     0.192     4.273     0.200
     0.192     4.475     0.200
     0.299     5.975     0.200
     0.345     7.074     0.200
     0.369     7.174     0.200
     0.384     8.975     0.200
     0.425     7.975     0.200
     0.460     8.975     0.200
     0.473     8.975     0.200
     0.473     9.574     0.200
     0.533    10.375     0.200
     0.537    10.574     0.200
     0.566    11.674     0.200
     0.638    12.975     0.200
     0.692    12.674     0.200
     0.733    13.975     0.200
     1.175    21.773     0.200
     1.160    21.773     0.200
     1.215    22.875     0.200
     1.386    24.773     0.200
     1.660    29.674     0.200
     1.912    33.773     0.200
     0.194     4.227     0.200
     0.197     4.625     0.200
     0.291     5.727     0.200
     0.360     7.824     0.200
     0.383     8.324     0.200
     0.370     8.824     0.200
     0.445     8.824     0.200
     0.481     9.625     0.200
     0.469     8.926     0.200
     0.547    10.426     0.200
     0.551    10.523     0.200
     0.532    12.125     0.200
     0.552    11.727     0.200
     0.649    12.125     0.200
     0.630    11.926     0.200
     0.697    13.125     0.200
     0.748    14.227     0.200
     0.730    15.324     0.200
     0.847    15.926     0.200
     1.032    19.727     0.200
     1.146    21.523     0.200
     1.208    23.324     0.200
     1.396    25.125     0.200
     1.656    29.625     0.200
     1.795    31.125     0.200
     1.903    33.727     0.200
     2.095    36.426     0.200
     0.170     4.051     0.200
     0.215     4.051     0.200
     0.282     5.453     0.200
     0.343     7.152     0.200
     0.374     8.051     0.200
     0.377     8.051     0.200
     0.446     8.652     0.200
     0.452     8.953     0.200
     0.453     8.953     0.200
     0.464     8.652     0.200
     0.541    10.652     0.200
     0.543    10.250     0.200
     0.532    11.551     0.200
     0.560    11.652     0.200
     0.621    12.250     0.200
     0.712    13.152     0.200
     0.729    13.750     0.200
     0.825    15.750     0.200
     1.040    19.051     0.200
     1.154    21.750     0.200
     1.197    22.051     0.200
     1.401    25.152     0.200
     1.639    28.852     0.200
     1.895    34.652     0.200
     0.122     2.906     0.200
     0.141     3.008     0.200
     0.174     4.008     0.200
     0.210     4.207     0.200
     0.285     5.605     0.200
     0.344     7.105     0.200
     0.373     7.605     0.200
     0.378     8.406     0.200
     0.442     8.508     0.200
     0.456     9.309     0.200
     0.457     9.207     0.200
     0.463     8.906     0.200
     0.540    10.008     0.200
     0.542    10.707     0.200
     0.534    11.605     0.200
     0.561    11.105     0.200
     0.624    12.008     0.200
     0.708    13.105     0.200
     0.731    13.605     0.200
     0.829    15.906     0.200
     1.037    19.309     0.200
     1.051    20.105     0.200
     1.154    22.008     0.200
     1.192    22.105     0.200
     1.200    22.309     0.200
     1.643    29.707     0.200
     2.601    45.508     0.200
     0.120     2.453     0.200
     0.180     3.656     0.200
     0.204     3.555     0.200
     0.290     5.555     0.200
     0.343     6.758     0.200
     0.381     7.453     0.200
     0.436     8.156     0.200
     0.461     8.555     0.200
     0.462     9.758     0.200
     0.463     7.953     0.200
     0.537    11.055     0.200
     0.538    11.852     0.200
     0.563    11.852     0.200
     0.629    12.555     0.200
     0.703    12.953     0.200
     0.738    15.453     0.200
     1.157    21.758     0.200
     1.648    29.758     0.200
     1.903    33.453     0.200
     0.146     3.021     0.200
     0.183     3.021     0.200
     0.212     4.621     0.200
     0.300     5.422     0.200
     0.367     7.621     0.200
     0.386     7.922     0.200
     0.371     7.621     0.200
     0.416     7.820     0.200
     0.438     7.820     0.200
     0.480     9.422     0.200
     0.495     9.521     0.200
     0.548    10.521     0.200
     0.552    10.922     0.200
     0.536    11.221     0.200
     0.551    11.422     0.200
     0.638    12.221     0.200
     0.755    14.121     0.200
     0.859    16.820     0.200
     0.928    17.621     0.200
     1.025    18.820     0.200
     1.050    20.221     0.200
     1.145    21.521     0.200
     1.179    22.121     0.200
     1.167    20.820     0.200
     1.217    22.621     0.200
     1.667    30.121     0.200
     1.910    34.422     0.200
     2.922    50.922     0.200
     0.107     2.410     0.200
     0.164     3.410     0.200
     0.182     3.309     0.200
     0.199     4.410     0.200
     0.312     6.012     0.200
     0.336     7.012     0.200
     0.358     7.012     0.200
     0.396     7.609     0.200
     0.414     8.211     0.200
     0.469     8.609     0.200
     0.477     9.211     0.200
     0.486    10.109     0.200
     0.521     9.910     0.200
     0.525     9.910     0.200
     0.557    11.309     0.200
     0.577    11.512     0.200
     0.643    11.609     0.200
     0.651    13.109     0.200
     0.680    12.609     0.200
     0.725    13.512     0.200
     0.857    16.512     0.200
     1.010    19.012     0.200
     1.171    21.309     0.200
     1.228    24.109     0.200
     1.672    29.910     0.200
     1.925    34.809     0.200
     0.113     1.953     0.200
     0.174     3.750     0.200
     0.150     2.953     0.200
     0.207     3.656     0.200
     0.334     6.656     0.200
     0.292     5.555     0.200
     0.364     7.352     0.200
     0.388     7.656     0.200
     0.438     8.250     0.200
     0.454     8.953     0.200
     0.462     9.055     0.200
     0.531    10.156     0.200
     0.533    10.156     0.200
     0.543    12.352     0.200
     0.570    11.750     0.200
     0.631    12.156     0.200
     0.721    13.352     0.200
     1.648    29.656     0.200
     1.905    34.656     0.200
     0.111     2.141     0.200
     0.201     3.445     0.200
     0.153     2.945     0.200
     0.180     3.641     0.200
     0.335     6.641     0.200
     0.363     7.141     0.200
     0.297     5.445     0.200
     0.432     8.047     0.200
     0.389     8.242     0.200
     0.460     8.844     0.200
     0.528    10.047     0.200
     0.531     9.844     0.200
     0.468     8.844     0.200
     0.471     8.641     0.200
     0.546    11.445     0.200
     0.572    11.742     0.200
     0.662    12.242     0.200
     0.636    11.945     0.200
     0.697    12.547     0.200
     0.722    13.344     0.200
     0.793    14.344     0.200
     0.747    14.344     0.200
     0.942    18.141     0.200
     1.025    18.641     0.200
     1.063    20.742     0.200
     1.169    20.445     0.200
     1.181    21.141     0.200
     1.165    21.344     0.200
     1.212    22.844     0.200
     1.540    28.844     0.200
     1.540    28.844     0.200
     2.109    37.641     0.200
     2.336    41.141     0.200
     2.554    44.047     0.200
     2.932    50.242     0.200
     3.165    55.141     0.200
     3.354    59.141     0.200
     0.070     1.906     0.200
     0.150     2.602     0.200
     0.201     3.805     0.200
     0.283     5.602     0.200
     0.282     5.406     0.200
     0.318     6.305     0.200
     0.350     7.008     0.200
     0.326     6.508     0.200
     0.408     8.008     0.200
     0.438     9.805     0.200
     0.517    10.008     0.200
     0.524    10.203     0.200
     0.538    10.203     0.200
     0.564    10.703     0.200
     0.559    12.703     0.200
     0.603    11.406     0.200
     0.619    12.805     0.200
     0.650    12.102     0.200
     0.782    14.102     0.200
     0.771    15.305     0.200
     1.077    19.805     0.200
     1.188    21.406     0.200
     0.119     2.578     0.200
     0.149     3.273     0.200
     0.191     4.180     0.200
     0.194     3.680     0.200
     0.346     6.977     0.200
     0.370     7.680     0.200
     0.383     7.875     0.200
     0.426     8.273     0.200
     0.459     8.078     0.200
     0.472     9.273     0.200
     0.535    10.375     0.200
     0.538    10.375     0.200
     0.542     9.578     0.200
     0.564    12.180     0.200
     0.636    12.875     0.200
     0.694    12.578     0.200
     0.733    13.680     0.200
     1.025    18.773     0.200
     1.158    20.375     0.200
     1.658    30.180     0.200
     0.122     2.914     0.200
     0.141     3.016     0.200
     0.171     3.914     0.200
     0.213     4.312     0.200
     0.284     5.617     0.200
     0.342     7.211     0.200
     0.373     7.711     0.200
     0.379     8.312     0.200
     0.445     8.711     0.200
     0.453     9.117     0.200
     0.455     9.016     0.200
     0.465     8.914     0.200
     0.540    10.516     0.200
     0.542    10.516     0.200
     0.534    11.414     0.200
     0.561    11.617     0.200
     0.622    12.016     0.200
     0.673    12.414     0.200
     0.710    13.016     0.200
     0.729    13.711     0.200
     0.735    14.211     0.200
     0.804    15.016     0.200
     1.038    19.211     0.200
     1.155    21.414     0.200
     1.182    21.812     0.200
     1.399    25.016     0.200
     1.640    29.617     0.200
     1.897    34.914     0.200
     2.567    44.312     0.200
     2.579    44.617     0.200
     2.600    44.312     0.200
     0.121     2.867     0.200
     0.143     3.062     0.200
     0.175     3.961     0.200
     0.209     4.266     0.200
     0.287     5.664     0.200
     0.343     7.062     0.200
     0.372     7.664     0.200
     0.380     8.266     0.200
     0.441     8.562     0.200
     0.457     8.961     0.200
     0.459     8.961     0.200
     0.464     8.766     0.200
     0.538    10.461     0.200
     0.541    10.461     0.200
     0.536    11.562     0.200
     0.562    11.664     0.200
     0.625    11.961     0.200
     0.706    12.867     0.200
     0.730    13.664     0.200
     0.737    14.062     0.200
     0.931    18.867     0.200
     1.035    18.961     0.200
     1.156    21.266     0.200
     1.353    24.961     0.200
     1.644    29.461     0.200
     1.900    34.867     0.200
     0.111     2.391     0.200
     0.154     3.094     0.200
     0.198     3.492     0.200
     0.183     3.891     0.200
     0.299     5.594     0.200
     0.336     6.891     0.200
     0.362     7.289     0.200
     0.390     6.789     0.200
     0.429     8.289     0.200
     0.463     9.094     0.200
     0.470     8.992     0.200
     0.471     9.195     0.200
     0.528    10.289     0.200
     0.530    10.195     0.200
     0.547    11.992     0.200
     0.572    12.094     0.200
     0.638    12.195     0.200
     0.694    12.492     0.200
     0.723    13.492     0.200
     1.023    18.789     0.200
     1.178    21.391     0.200
     1.214    23.594     0.200
     1.656    29.789     0.200
     1.912    34.492     0.200
     0.153     3.520     0.200
     0.174     3.820     0.200
     0.147     3.223     0.200
     0.231     4.621     0.200
     0.304     6.121     0.200
     0.385     7.922     0.200
     0.400     8.223     0.200
     0.362     8.422     0.200
     0.407     7.121     0.200
     0.421     8.621     0.200
     0.488     9.520     0.200
     0.516     9.922     0.200
     0.559    11.020     0.200
     0.565    10.422     0.200
     0.531    11.820     0.200
     0.620    11.320     0.200
     0.640    12.621     0.200
     0.682    12.223     0.200
     0.773    14.621     0.200
     1.026    19.320     0.200
     1.347    24.820     0.200
     1.393    25.223     0.200
     1.675    30.621     0.200
     1.911    35.020     0.200
     0.159     3.326     0.200
     0.134     3.326     0.200
     0.187     3.226     0.200
     0.223     4.626     0.200
     0.291     5.726     0.200
     0.352     7.426     0.200
     0.389     7.326     0.200
     0.408     8.326     0.200
     0.420     8.126     0.200
     0.416     8.426     0.200
     0.475     9.726     0.200
     0.509     9.926     0.200
     0.520    11.726     0.200
     0.568    11.426     0.200
     0.573    11.226     0.200
     0.628    11.726     0.200
     0.695    12.526     0.200
     1.038    18.326     0.200
     1.125    20.326     0.200
     1.172    21.026     0.200
     1.662    29.726     0.200
     1.898    34.326     0.200
     0.147     2.932     0.200
     0.115     2.832     0.200
     0.166     3.730     0.200
     0.230     4.531     0.200
     0.259     5.432     0.200
     0.365     7.332     0.200
     0.353     8.031     0.200
     0.398     7.832     0.200
     0.463     8.932     0.200
     0.445     7.230     0.200
     0.434     8.332     0.200
     0.453     8.932     0.200
     0.508    11.031     0.200
     0.565    10.631     0.200
     0.567    10.332     0.200
     0.598    12.131     0.200
     0.732    13.432     0.200
     0.710    13.432     0.200
     0.750    14.031     0.200
     0.811    15.332     0.200
     1.130    20.730     0.200
     1.175    21.230     0.200
     1.424    25.932     0.200
     1.502    27.332     0.200
     1.620    29.730     0.200
     1.872    34.332     0.200
     0.143     3.020     0.200
     0.137     2.920     0.200
     0.191     3.520     0.200
     0.207     4.420     0.200
     0.291     5.620     0.200
     0.371     7.720     0.200
     0.363     8.320     0.200
     0.393     8.720     0.200
     0.424     8.120     0.200
     0.433     8.320     0.200
     0.471     9.220     0.200
     0.492     9.420     0.200
     0.527    11.420     0.200
     0.555    10.720     0.200
     0.560    11.320     0.200
     0.628    12.020     0.200
     0.696    12.120     0.200
     0.724    14.120     0.200
     0.760    14.220     0.200
     0.919    18.020     0.200
     1.035    18.820     0.200
     1.137    21.720     0.200
     1.208    23.220     0.200
     1.658    30.320     0.200
     1.901    34.020     0.200
     0.137     3.078     0.200
     0.195     4.180     0.200
     0.135     2.977     0.200
     0.199     4.180     0.200
     0.286     5.578     0.200
     0.364     7.180     0.200
     0.388     7.977     0.200
     0.365     8.078     0.200
     0.432     8.375     0.200
     0.464     9.180     0.200
     0.442     8.477     0.200
     0.552    10.578     0.200
     0.556    10.680     0.200
     0.527    11.375     0.200
     0.527    11.227     0.200
     0.547    11.477     0.200
     0.625    12.078     0.200
     0.652    12.078     0.200
     0.702    12.578     0.200
     0.751    14.078     0.200
     0.725    13.875     0.200
     0.785    14.477     0.200
     1.037    18.875     0.200
     1.188    21.375     0.200
     1.141    21.281     0.200
     1.183    21.281     0.200
     1.203    22.375     0.200
     1.530    28.477     0.200
     1.530    28.680     0.200
     1.518    28.078     0.200
     1.651    29.375     0.200
     1.898    34.180     0.200
     2.233    38.977     0.200
     2.563    44.281     0.200
     0.063     2.205     0.200
     0.285     6.405     0.200
     0.285     6.305     0.200
     0.469     9.405     0.200
     0.646    12.705     0.200
     0.681    13.305     0.200
     1.136    21.405     0.200
     1.147    21.005     0.200
     1.162    22.005     0.200
     1.338    24.405     0.200
     1.355    24.305     0.200
     1.379    24.604     0.200
     1.456    27.205     0.200
     1.463    26.705     0.200
     1.555    28.705     0.200
     1.685    30.104     0.200
     1.711    30.505     0.200
     1.726    31.805     0.200
     1.934    34.505     0.200
     0.238     4.898     0.200
     0.240     5.102     0.200
     0.243     5.398     0.200
     0.266     5.602     0.200
     0.320     6.500     0.200
     0.350     7.398     0.200
     0.406     8.297     0.200
     0.410     8.797     0.200
     0.556    11.000     0.200
     0.567    11.297     0.200
     0.579    11.500     0.200
     0.605    12.297     0.200
     0.629    11.695     0.200
     0.654    12.398     0.200
     0.758    16.297     0.200
     0.869    16.000     0.200
     0.937    17.602     0.200
     1.495    27.102     0.200
     1.813    32.102     0.200
     0.120     3.078     0.200
     0.146     3.178     0.200
     0.181     4.078     0.200
     0.217     4.479     0.200
     0.269     5.678     0.200
     0.368     7.279     0.200
     0.355     7.379     0.200
     0.397     7.879     0.200
     0.450     8.578     0.200
     0.439     8.078     0.200
     0.446     8.678     0.200
     0.468     9.279     0.200
     0.513    10.578     0.200
     0.537    11.379     0.200
     0.563    11.479     0.200
     0.566    10.879     0.200
     0.608    12.078     0.200
     0.720    12.578     0.200
     0.755    14.279     0.200
     0.825    15.678     0.200
     1.330    24.578     0.200
     1.633    29.279     0.200
     1.881    34.678     0.200
     0.206     4.453     0.200
     0.242     4.953     0.200
     0.404     7.852     0.200
     0.404     7.852     0.200
     0.396     8.555     0.200
     0.453     8.852     0.200
     0.515    11.258     0.200
     0.581    11.453     0.200
     0.700    12.953     0.200
     0.719    13.156     0.200
     0.702    13.258     0.200
     0.818    14.453     0.200
     0.794    15.258     0.200
     0.866    18.453     0.200
     0.866    18.258     0.200
     0.908    17.758     0.200
     1.050    20.758     0.200
     1.111    20.156     0.200
     1.242    22.453     0.200
     1.254    22.555     0.200
     1.254    23.258     0.200
     1.331    24.453     0.200
     1.384    25.352     0.200
     1.476    26.258     0.200
     1.556    28.055     0.200
     1.703    29.758     0.200
     1.669    30.055     0.200
     1.742    30.852     0.200
     1.765    31.055     0.200
     1.910    34.156     0.200
     1.917    34.555     0.200
     2.052    35.555     0.200
     0.126     3.562     0.200
     0.165     3.758     0.200
     0.195     3.961     0.200
     0.220     4.961     0.200
     0.283     6.461     0.200
     0.344     6.664     0.200
     0.395     8.062     0.200
     0.410     8.562     0.200
     0.427     8.461     0.200
     0.508    10.258     0.200
     0.511    12.164     0.200
     0.523    10.164     0.200
     0.576    11.359     0.200
     0.581    11.461     0.200
     0.619    12.562     0.200
     0.703    13.359     0.200
     0.706    12.562     0.200
     0.783    14.758     0.200
     1.525    27.258     0.200
     1.525    27.562     0.200
     1.655    29.961     0.200
     1.800    31.164     0.200
     2.212    38.164     0.200
     0.088     2.994     0.200
     0.198     4.195     0.200
     0.183     4.395     0.200
     0.209     5.096     0.200
     0.258     6.195     0.200
     0.277     5.596     0.200
     0.277     6.295     0.200
     0.366     7.295     0.200
     0.422     7.494     0.200
     0.382     7.994     0.200
     0.449     9.395     0.200
     0.444     8.596     0.200
     0.628    12.395     0.200
     0.627    12.096     0.200
     0.647    12.295     0.200
     0.647    11.994     0.200
     0.771    15.395     0.200
     0.791    14.795     0.200
     0.841    15.895     0.200
     0.846    16.295     0.200
     0.851    15.994     0.200
     0.893    16.596     0.200
     0.914    16.395     0.200
     0.898    16.994     0.200
     1.029    18.994     0.200
     1.020    19.295     0.200
     1.076    20.895     0.200
     0.181     3.406     0.200
     0.152     2.805     0.200
     0.208     4.406     0.200
     0.357     7.203     0.200
     0.414     7.906     0.200
     0.304     5.602     0.200
     0.379     8.008     0.200
     0.539    10.305     0.200
     0.543    10.602     0.200
     0.448     7.906     0.200
     0.490     9.305     0.200
     0.637    11.406     0.200
     0.543    11.156     0.200
     0.543    11.305     0.200
     0.684    12.305     0.200
     0.745    13.906     0.200
     0.642    11.906     0.200
     0.769    13.805     0.200
     0.740    13.703     0.200
     1.020    18.508     0.200
     0.936    17.508     0.200
     1.172    20.703     0.200
     1.058    20.203     0.200
     1.154    21.102     0.200
     1.915    34.008     0.200
     2.319    40.102     0.200
     2.938    51.406     0.200
     3.146    55.008     0.200
     4.359    77.508     0.200
     0.269     4.426     0.200
     0.357     6.129     0.200
     0.369     6.578     0.200
     0.369     6.426     0.200
     0.477     8.926     0.200
     0.488     9.227     0.200
     0.476     9.629     0.200
     0.512    10.129     0.200
     0.508     9.926     0.200
     0.611    12.129     0.200
     0.606    11.328     0.200
     0.686    13.227     0.200
     0.701    13.227     0.200
     0.802    15.227     0.200
     0.824    15.629     0.200
     0.911    16.926     0.200
     0.926    17.328     0.200
     0.942    17.527     0.200
     1.051    20.027     0.200
     1.057    19.828     0.200
     1.083    20.828     0.200
     1.148    22.629     0.200
     1.330    24.527     0.200
     1.554    28.629     0.200
     1.585    29.129     0.200
     0.110     3.305     0.200
     0.152     3.305     0.200
     0.191     4.805     0.200
     0.224     3.906     0.200
     0.287     6.707     0.200
     0.294     6.805     0.200
     0.336     6.805     0.200
     0.399     7.707     0.200
     0.397     7.605     0.200
     0.450     9.508     0.200
     0.473     9.305     0.200
     0.610    11.906     0.200
     0.616    11.805     0.200
     0.600    11.707     0.200
     0.671    13.105     0.200
     0.749    13.605     0.200
     0.812    15.707     0.200
     0.816    14.906     0.200
     0.783    15.305     0.200
     0.795    15.305     0.200
     0.896    16.508     0.200
     0.880    16.605     0.200
     0.922    17.805     0.200
     0.998    18.605     0.200
     1.029    19.406     0.200
     1.099    20.508     0.200
     1.263    23.207     0.200
     1.273    23.406     0.200
     1.340    24.305     0.200
     1.340    25.508     0.200
     1.690    31.008     0.200
     0.495     8.914     0.200
     0.487     9.496     0.200
     0.591    10.395     0.200
     0.571    11.297     0.200
     0.627    12.094     0.200
     0.648    11.797     0.200
     0.653    11.797     0.200
     0.635    11.895     0.200
     0.672    12.297     0.200
     0.697    13.996     0.200
     0.801    15.254     0.200
     0.832    15.695     0.200
     0.821    15.395     0.200
     0.822    15.594     0.200
     0.852    16.797     0.200
     0.895    16.895     0.200
     0.948    17.395     0.200
     0.870    16.195     0.200
     0.982    18.094     0.200
     1.038    20.094     0.200
     1.084    21.297     0.200
     1.182    22.496     0.200
     1.175    21.695     0.200
     1.215    22.996     0.200
     1.199    23.297     0.200
     1.216    22.695     0.200
     1.216    21.496     0.200
     1.780    33.395     0.200
     2.117    37.996     0.200
     0.343     7.547     0.200
     0.616    11.844     0.200
     0.633    13.242     0.200
     0.659    13.141     0.200
     0.728    14.445     0.200
     0.732    14.242     0.200
     0.822    16.547     0.200
     0.920    17.742     0.200
     0.925    18.094     0.200
     0.925    17.742     0.200
     1.001    19.641     0.200
     1.042    19.344     0.200
     1.186    22.445     0.200
     1.156    22.141     0.200
     1.212    22.547     0.200
     1.344    26.344     0.200
     1.426    26.141     0.200
     1.406    25.445     0.200
     1.434    26.141     0.200
     1.483    26.844     0.200
     1.556    28.742     0.200
     1.607    28.641     0.200
     1.649    30.641     0.200
     1.627    29.547     0.200
     1.732    30.742     0.200
     1.813    32.445     0.200
     1.885    34.141     0.200
     1.895    33.344     0.200
     1.870    33.141     0.200
     2.122    37.445     0.200
     2.154    37.641     0.200
     2.216    38.547     0.200
     2.337    40.344     0.200
     2.652    45.844     0.200
     2.719    45.945     0.200
     0.558    11.193     0.200
     0.627    12.893     0.200
     0.665    12.693     0.200
     0.739    15.093     0.200
     0.764    15.893     0.200
     0.784    16.193     0.200
     0.924    17.393     0.200
     0.964    16.693     0.200
     0.945    18.593     0.200
     0.996    18.093     0.200
     0.983    19.193     0.200
     1.047    19.893     0.200
     1.066    20.293     0.200
     1.056    19.993     0.200
     1.062    19.993     0.200
     1.110    20.993     0.200
     1.114    20.593     0.200
     1.290    23.593     0.200
     1.364    26.193     0.200
     1.378    25.093     0.200
     1.413    26.593     0.200
     1.463    26.893     0.200
     1.693    29.693     0.200
     1.766    31.493     0.200
     0.114     2.840     0.200
     0.195     4.139     0.200
     0.153     3.238     0.200
     0.188     3.939     0.200
     0.340     7.039     0.200
     0.365     7.539     0.200
     0.403     7.539     0.200
     0.427     8.439     0.200
     0.299     5.738     0.200
     0.387     8.139     0.200
     0.530    10.439     0.200
     0.468     9.238     0.200
     0.465     8.639     0.200
     0.472     9.238     0.200
     0.655    11.840     0.200
     0.546    11.920     0.200
     0.546    11.639     0.200
     0.693    12.738     0.200
     0.569    11.738     0.200
     0.728    13.840     0.200
     0.638    12.139     0.200
     0.786    14.738     0.200
     0.746    15.439     0.200
     0.845    15.828     0.200
     1.023    18.840     0.200
     0.941    18.340     0.200
     1.163    21.639     0.200
     1.192    22.340     0.200
     1.363    25.238     0.200
     1.542    28.039     0.200
     1.658    29.639     0.200
     1.912    34.039     0.200
     2.550    43.539     0.200
     0.241     5.445     0.200
     0.424     9.047     0.200
     0.504     9.344     0.200
     0.518    10.445     0.200
     0.610    11.641     0.200
     0.633    12.547     0.200
     0.672    13.445     0.200
     0.692    13.742     0.200
     0.729    13.844     0.200
     0.745    13.742     0.200
     0.799    14.844     0.200
     0.812    14.742     0.200
     0.847    15.844     0.200
     0.877    16.141     0.200
     0.875    16.742     0.200
     0.894    16.344     0.200
     0.196     3.391     0.200
     0.346     6.490     0.200
     0.324     6.590     0.200
     0.399     7.490     0.200
     0.405     8.590     0.200
     0.444     8.590     0.200
     0.478     8.891     0.200
     0.515     8.990     0.200
     0.566    10.189     0.200
     0.673    12.990     0.200
     0.686    13.391     0.200
     0.689    13.289     0.200
     0.731    13.590     0.200
     0.754    14.891     0.200
     0.738    14.490     0.200
     0.738    14.289     0.200
     0.776    14.590     0.200
     0.891    17.391     0.200
     0.872    16.189     0.200
     1.010    19.490     0.200
     1.121    21.490     0.200
     1.270    23.689     0.200
     2.177    39.391     0.200
     0.074     3.641     0.200
     0.079     3.039     0.200
     0.239     5.836     0.200
     0.265     4.938     0.200
     0.471    10.336     0.200
     0.505    10.234     0.200
     0.617    12.938     0.200
     0.678    12.836     0.200
     0.706    13.234     0.200
     0.749    14.836     0.200
     0.859    16.539     0.200
     0.861    15.734     0.200
     1.051    20.234     0.200
     1.114    20.234     0.200
     1.131    21.141     0.200
     0.319     7.357     0.200
     0.350     8.656     0.200
     0.578    11.656     0.200
     0.638    11.357     0.200
     0.651    12.156     0.200
     0.721    13.656     0.200
     0.729    13.258     0.200
     0.765    14.656     0.200
     0.822    15.457     0.200
     1.156    21.156     0.200
     1.144    21.357     0.200
     1.225    22.156     0.200
     1.226    22.656     0.200
     1.378    24.557     0.200
     1.621    28.258     0.200
     0.116     2.406     0.200
     0.151     3.206     0.200
     0.188     4.206     0.200
     0.196     4.307     0.200
     0.297     5.807     0.200
     0.343     6.906     0.200
     0.368     7.307     0.200
     0.406     7.406     0.200
     0.385     8.706     0.200
     0.428     8.206     0.200
     0.469     8.807     0.200
     0.471     9.106     0.200
     0.463     8.807     0.200
     0.533    10.007     0.200
     0.536    10.406     0.200
     0.566    11.906     0.200
     0.636    12.307     0.200
     0.655    12.007     0.200
     0.694    12.307     0.200
     0.730    13.906     0.200
     0.743    14.307     0.200
     0.844    15.606     0.200
     1.025    18.706     0.200
     1.171    21.106     0.200
     1.160    21.507     0.200
     1.371    25.007     0.200
     1.910    33.706     0.200
     0.117     4.036     0.200
     0.305     6.436     0.200
     0.368     7.436     0.200
     0.437     9.036     0.200
     0.493     9.636     0.200
     0.555    10.836     0.200
     0.553    11.436     0.200
     0.633    12.536     0.200
     0.646    12.636     0.200
     0.630    13.235     0.200
     0.773    14.235     0.200
     0.823    15.936     0.200
     0.922    18.136     0.200
     0.926    18.136     0.200
     0.960    17.636     0.200
     0.960    17.536     0.200
     0.963    18.235     0.200
     1.036    19.336     0.200
     1.068    20.336     0.200
     1.088    20.536     0.200
     1.356    25.036     0.200
     1.406    25.636     0.200
     1.618    30.235     0.200
     1.683    29.735     0.200
     0.131     3.812     0.200
     0.286     6.109     0.200
     0.349     7.512     0.200
     0.475     8.812     0.200
     0.534    11.211     0.200
     0.543    10.410     0.200
     0.617    12.711     0.200
     0.627    12.512     0.200
     0.671    13.410     0.200
     0.691    13.312     0.200
     0.762    14.410     0.200
     0.816    15.211     0.200
     0.909    17.910     0.200
     0.919    18.109     0.200
     0.958    18.609     0.200
     0.959    18.109     0.200
     0.971    18.410     0.200
     1.040    19.410     0.200
     1.037    19.312     0.200
     0.307     5.898     0.200
     0.383     7.199     0.200
     0.491     9.299     0.200
     0.543    10.598     0.200
     0.564    11.199     0.200
     0.628    12.299     0.200
     0.649    12.498     0.200
     0.653    12.998     0.200
     0.705    13.799     0.200
     0.721    13.998     0.200
     0.761    14.398     0.200
     0.794    15.398     0.200
     0.805    15.398     0.200
     0.862    17.299     0.200
     0.817    15.498     0.200
     0.913    17.799     0.200
     0.909    17.598     0.200
     0.982    18.598     0.200
     0.983    18.699     0.200
     1.034    19.299     0.200
     1.049    19.598     0.200
     1.069    20.898     0.200
     1.070    20.299     0.200
     1.096    20.998     0.200
     1.143    21.598     0.200
     2.034    36.598     0.200
     0.183     5.102     0.200
     0.284     6.102     0.200
     0.457     9.203     0.200
     0.478     9.297     0.200
     0.507    10.102     0.200
     0.552    11.297     0.200
     0.560    10.898     0.200
     0.615    11.797     0.200
     0.633    12.898     0.200
     0.674    12.602     0.200
     0.792    15.898     0.200
     0.843    15.703     0.200
     0.844    15.703     0.200
     0.891    17.000     0.200
     0.905    16.297     0.200
     0.906    16.398     0.200
     0.928    17.898     0.200
     0.944    17.203     0.200
     1.038    19.102     0.200
     1.089    20.297     0.200
     1.156    20.898     0.200
     1.170    21.703     0.200
     1.236    22.703     0.200
     1.938    32.898     0.200
     0.106     2.727     0.200
     0.271     5.531     0.200
     0.333     6.930     0.200
     0.346     7.133     0.200
     0.340     7.133     0.200
     0.407     8.430     0.200
     0.400     8.828     0.200
     0.563     9.727     0.200
     0.583    11.531     0.200
     0.650    12.633     0.200
     0.744    14.828     0.200
     0.758    14.031     0.200
     0.899    17.031     0.200
     0.914    17.430     0.200
     0.925    17.430     0.200
     1.011    19.930     0.200
     1.159    21.430     0.200
     1.225    23.133     0.200
     2.187    37.930     0.200
     0.117     3.016     0.200
     0.150     3.516     0.200
     0.184     4.316     0.200
     0.217     4.715     0.200
     0.267     5.715     0.200
     0.373     7.914     0.200
     0.350     8.316     0.200
     0.402     8.516     0.200
     0.440     7.914     0.200
     0.450     9.117     0.200
     0.433     8.715     0.200
     0.445     9.117     0.200
     0.471     9.516     0.200
     0.509    10.316     0.200
     0.532    11.316     0.200
     0.568    11.316     0.200
     0.570    11.516     0.200
     0.606    12.117     0.200
     0.721    13.117     0.200
     0.760    14.516     0.200
     0.825    15.617     0.200
     0.904    16.816     0.200
     1.056    19.914     0.200
     1.126    21.516     0.200
     1.184    22.617     0.200
     1.326    24.215     0.200
     1.420    25.516     0.200
     1.605    28.215     0.200
     1.632    29.516     0.200
     1.819    31.516     0.200
     0.193     3.961     0.200
     0.243     5.266     0.200
     0.261     5.562     0.200
     0.403     8.164     0.200
     0.449     8.664     0.200
     0.499    10.367     0.200
     0.500    10.562     0.200
     0.574    11.266     0.200
     0.593    11.367     0.200
     0.607    12.461     0.200
     0.836    15.766     0.200
     0.927    17.367     0.200
     1.155    21.461     0.200
     1.176    21.867     0.200
     1.171    21.562     0.200
     1.225    22.266     0.200
     1.486    27.766     0.200
     0.215     4.125     0.200
     0.234     5.723     0.200
     0.296     6.223     0.200
     0.483     9.223     0.200
     0.512    10.125     0.200
     0.468     9.824     0.200
     0.571    12.223     0.200
     0.570    11.125     0.200
     0.600    11.824     0.200
     0.627    12.422     0.200
     0.641    12.824     0.200
     0.771    15.324     0.200
     0.804    15.723     0.200
     0.804    15.023     0.200
     0.893    16.523     0.200
     1.203    23.523     0.200
     1.194    22.023     0.200
     1.423    26.723     0.200
     1.461    26.625     0.200
     1.461    27.125     0.200
     1.492    27.523     0.200
     1.836    32.922     0.200
     0.198     4.195     0.200
     0.269     5.293     0.200
     0.321     5.195     0.200
     0.368     6.594     0.200
     0.372     7.395     0.200
     0.373     7.793     0.200
     0.536     9.895     0.200
     0.615    11.996     0.200
     0.662    13.395     0.200
     0.731    13.594     0.200
     0.738    14.195     0.200
     1.133    20.895     0.200
     1.313    24.293     0.200
     1.696    30.793     0.200
     0.195     4.629     0.200
     0.277     5.828     0.200
     0.335     6.828     0.200
     0.404     7.926     0.200
     0.404     8.027     0.200
     0.426     8.426     0.200
     0.554    10.426     0.200
     0.607    12.727     0.200
     0.696    13.227     0.200
     0.700    13.828     0.200
     0.763    13.828     0.200
     0.828    15.727     0.200
     0.810    15.426     0.200
     0.841    15.727     0.200
     0.943    17.328     0.200
     0.948    18.227     0.200
     1.100    20.129     0.200
     1.475    27.227     0.200
     0.196     4.570     0.200
     0.272     5.766     0.200
     0.380     7.969     0.200
     0.380     8.164     0.200
     0.360     6.367     0.200
     0.419     8.367     0.200
     0.541    10.367     0.200
     0.612    12.570     0.200
     0.671    12.969     0.200
     0.744    13.867     0.200
     0.723    13.469     0.200
     0.717    13.570     0.200
     0.829    14.766     0.200
     0.852    15.570     0.200
     0.810    15.766     0.200
     0.930    18.367     0.200
     0.931    17.266     0.200
     1.114    21.070     0.200
     1.231    22.180     0.200
     1.320    24.367     0.200
     1.367    24.867     0.200
     1.454    27.266     0.200
     1.500    27.070     0.200
     1.576    27.664     0.200
     1.646    29.664     0.200
     1.704    30.766     0.200
     1.715    30.570     0.200
     1.731    29.867     0.200
     1.821    31.664     0.200
     1.869    32.070     0.200
     1.893    33.164     0.200
     1.955    34.469     0.200
     2.118    36.969     0.200
     0.200     4.430     0.200
     0.268     5.727     0.200
     0.380     6.727     0.200
     0.361     8.023     0.200
     0.360     7.625     0.200
     0.413     8.328     0.200
     0.530    10.430     0.200
     0.618    12.828     0.200
     0.650    13.328     0.200
     0.704    13.430     0.200
     0.743    14.023     0.200
     0.728    13.727     0.200
     0.845    15.625     0.200
     0.862    15.930     0.200
     0.915    17.125     0.200
     0.921    17.227     0.200
     1.151    21.625     0.200
     1.147    21.930     0.200
     1.210    22.328     0.200
     1.304    24.930     0.200
     1.342    24.523     0.200
     1.347    25.328     0.200
     1.482    26.625     0.200
     1.601    28.523     0.200
     1.628    28.625     0.200
     1.684    30.625     0.200
     1.695    30.625     0.200
     1.783    31.125     0.200
     1.837    31.727     0.200
     1.887    33.430     0.200
     2.017    35.625     0.200
     0.046     2.684     0.200
     0.255     6.582     0.200
     0.256     6.283     0.200
     0.411     8.383     0.200
     0.448     9.482     0.200
     0.450     9.982     0.200
     0.613    11.482     0.200
     0.599    11.982     0.200
     0.595    11.982     0.200
     0.628    12.184     0.200
     0.712    13.383     0.200
     0.750    13.982     0.200
     0.839    15.283     0.200
     0.844    15.383     0.200
     0.853    16.883     0.200
     0.863    16.383     0.200
     0.955    17.582     0.200
     0.998    18.684     0.200
     1.010    18.982     0.200
     0.994    18.283     0.200
     1.049    19.982     0.200
     1.233    22.283     0.200
     1.398    25.283     0.200
     1.398    25.283     0.200
     1.731    30.082     0.200
     0.142     2.893     0.200
     0.167     3.594     0.200
     0.296     6.594     0.200
     0.307     6.742     0.200
     0.357     6.992     0.200
     0.362     7.594     0.200
     0.444     8.492     0.200
     0.515     9.992     0.200
     0.490    10.594     0.200
     0.502    10.193     0.200
     0.532    11.293     0.200
     0.570    11.293     0.200
     0.599    11.594     0.200
     0.662    13.293     0.200
     0.662    13.543     0.200
     0.687    13.193     0.200
     0.698    13.693     0.200
     0.786    15.492     0.200
     0.786    15.293     0.200
     0.791    15.393     0.200
     0.796    15.293     0.200
     0.909    17.193     0.200
     0.956    17.693     0.200
     0.996    18.693     0.200
     1.058    19.393     0.200
     1.105    21.293     0.200
     1.133    21.094     0.200
     1.198    22.193     0.200
     1.205    22.492     0.200
     1.259    23.193     0.200
     1.254    22.992     0.200
     0.136     2.820     0.200
     0.146     3.820     0.200
     0.232     5.621     0.200
     0.362     7.021     0.200
     0.436     8.420     0.200
     0.474    10.820     0.200
     0.500    10.021     0.200
     0.525     9.920     0.200
     0.554    11.320     0.200
     0.561    11.021     0.200
     0.579    11.420     0.200
     0.674    13.121     0.200
     0.698    13.121     0.200
     0.686    13.320     0.200
     0.788    15.420     0.200
     0.807    17.021     0.200
     0.807    16.420     0.200
     0.908    17.320     0.200
     0.981    18.920     0.200
     1.080    19.221     0.200
     1.124    21.521     0.200
     1.125    21.521     0.200
     1.189    21.721     0.200
     1.188    22.621     0.200
     1.357    25.621     0.200
     1.361    25.320     0.200
     1.466    26.820     0.200
     1.476    26.721     0.200
     0.310     6.586     0.200
     0.291     6.609     0.200
     0.291     6.711     0.200
     0.370     7.410     0.200
     0.359     7.109     0.200
     0.359     6.910     0.200
     0.453     8.312     0.200
     0.495    10.312     0.200
     0.498     9.910     0.200
     0.498    10.211     0.200
     0.514     9.910     0.200
     0.519    11.211     0.200
     0.570    11.211     0.200
     0.607    11.512     0.200
     0.686    13.109     0.200
     0.700    13.812     0.200
     0.795    15.410     0.200
     0.788    15.512     0.200
     0.776    15.711     0.200
     0.776    15.211     0.200
     0.904    17.312     0.200
     0.958    17.910     0.200
     1.000    18.512     0.200
     1.046    19.410     0.200
     1.098    21.012     0.200
     1.133    21.109     0.200
     1.211    22.410     0.200
     1.198    22.211     0.200
     1.257    23.109     0.200
     1.372    25.109     0.200
     1.934    34.312     0.200
     0.129     2.582     0.200
     0.152     3.781     0.200
     0.303     6.855     0.200
     0.305     6.980     0.200
     0.354     6.980     0.200
     0.350     7.480     0.200
     0.431     8.281     0.200
     0.483    10.281     0.200
     0.516     9.883     0.200
     0.508    10.480     0.200
     0.549    11.582     0.200
     0.586    11.480     0.200
     0.570    11.383     0.200
     0.689    13.082     0.200
     0.695    13.781     0.200
     0.678    13.523     0.200
     0.678    13.684     0.200
     0.795    15.383     0.200
     0.797    15.383     0.200
     0.800    15.684     0.200
     0.800    15.383     0.200
     0.916    17.480     0.200
     0.954    17.883     0.200
     0.990    18.480     0.200
     1.076    19.582     0.200
     1.116    21.184     0.200
     1.134    21.281     0.200
     1.198    22.281     0.200
     1.197    22.383     0.200
     1.251    22.781     0.200
     1.264    23.184     0.200
     1.366    24.980     0.200
     1.370    24.883     0.200
     1.474    26.582     0.200
     1.494    26.480     0.200
     1.918    33.980     0.200
     2.017    35.281     0.200
     0.195     5.030     0.200
     0.241     5.370     0.200
     0.238     5.190     0.200
     0.433     8.700     0.200
     0.438     8.860     0.200
     0.503    10.110     0.200
     0.554    10.550     0.200
     0.560    10.221     0.200
     0.550    11.230     0.200
     0.559    11.740     0.200
     0.587    12.490     0.200
     0.597    11.101     0.200
     0.642    12.141     0.200
     0.725    13.950     0.200
     0.766    15.620     0.200
     0.818    15.641     0.200
     0.852    16.080     0.200
     0.895    16.830     0.200
     0.926    17.580     0.200
     0.944    18.010     0.200
     0.948    17.780     0.200
     0.957    18.040     0.200
     1.101    20.440     0.200
     1.106    20.311     0.200
     1.117    21.010     0.200
     1.288    23.340     0.200
     1.576    30.290     0.200
     0.144     3.575     0.200
     0.160     3.545     0.200
     0.177     3.595     0.200
     0.301     6.335     0.200
     0.356     8.706     0.200
     0.392     8.135     0.200
     0.409     8.186     0.200
     0.407     8.585     0.200
     0.414     7.795     0.200
     0.486    10.355     0.200
     0.520    10.095     0.200
     0.527     9.936     0.200
     0.535    11.785     0.200
     0.565    11.905     0.200
     0.571    11.095     0.200
     0.619    11.085     0.200
     0.637    12.666     0.200
     0.685    12.485     0.200
     0.719    13.605     0.200
     0.753    14.146     0.200
     0.916    17.355     0.200
     1.128    21.715     0.200
     1.161    20.975     0.200
     1.167    21.265     0.200
     1.190    21.855     0.200
     1.219    22.295     0.200
     1.342    23.975     0.200
     1.374    24.495     0.200
     1.543    26.865     0.200
     1.673    29.015     0.200
     0.089     3.008     0.200
     0.083     3.090     0.200
     0.254     6.469     0.200
     0.508    10.320     0.200
     0.650    12.797     0.200
     0.654    13.328     0.200
     0.734    14.617     0.200
     0.812    16.949     0.200
     0.829    15.469     0.200
     0.916    17.688     0.200
     0.991    18.578     0.200
     1.145    21.391     0.200
     1.147    21.020     0.200
     1.345    24.270     0.200
     1.374    24.707     0.200
     1.467    26.070     0.200
     1.491    26.840     0.200
     1.581    27.750     0.200
     1.749    30.891     0.200
     1.753    30.758     0.200
     1.889    33.430     0.200
     0.131     3.013     0.200
     0.131     2.912     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
     1.229    38.742     0.200
     0.732    22.578     0.200
     1.302    38.680     0.200
     1.760    52.352     0.200
     1.859    50.578     0.200
     2.369    64.375     0.200
     4.564   117.281     0.200
     0.643    20.799     0.200
     1.029    31.197     0.200
     1.267    38.674     0.200
     1.267    39.299     0.200
     1.736    49.299     0.200
     2.005    57.098     0.200
     2.166    58.799     0.200
     2.358    64.498     0.200
     3.457    91.398     0.200
     3.527    93.799     0.200
     3.492    89.697     0.200
     0.576    20.273     0.200
     1.201    37.000     0.200
     1.415    38.074     0.200
     1.960    56.773     0.200
     3.467    87.773     0.200
     3.488    93.074     0.200
     4.737   119.477     0.200
     5.346   133.605     0.200
     1.415    42.144     0.200
     3.649    92.684     0.200
     7.251   182.574     0.200
    18.042   448.078     0.200
     2.507    72.453     0.200
     3.880   105.859     0.200
     4.012   108.859     0.200
     3.504    89.680     0.200
     1.038    35.266     0.200
     1.042    34.266     0.200
     1.018    34.965     0.200
     1.074    35.383     0.200
     1.224    40.781     0.200
     1.210    39.535     0.200
     1.899    56.930     0.200
     2.126    62.930     0.200
     2.842    81.531     0.200
     0.618    20.554     0.200
     0.747    24.154     0.200
     1.247    39.379     0.200
     1.063    33.725     0.200
     1.088    34.725     0.200
     1.154    36.824     0.200
     1.454    40.924     0.200
     1.505    43.725     0.200
     1.644    47.824     0.200
     2.769    74.225     0.200
     3.496    91.943     0.200
     0.991    32.838     0.200
     1.092    35.637     0.200
     1.115    35.537     0.200
     1.133    36.838     0.200
     1.170    37.037     0.200
     1.254    39.738     0.200
     1.590    47.938     0.200
     2.315    66.537     0.200
     2.390    68.938     0.200
     2.419    69.637     0.200
     2.487    71.838     0.200
     3.084    85.838     0.200
     3.691   101.338     0.200
     1.230    40.801     0.200
     3.201    88.301     0.200
     3.124    89.501     0.200
     1.199    38.234     0.200
     0.798    27.037     0.200
     0.936    30.937     0.200
     1.031    33.837     0.200
     1.190    38.137     0.200
     1.200    37.537     0.200
     0.874    30.004     0.200
     0.989    33.004     0.200
     0.870    30.312     0.200
    11.301   294.080     0.200
     1.178    38.125     0.200
     1.154    38.352     0.200
     1.318    38.535     0.200
     1.608    46.137     0.200
     1.608    45.637     0.200
     1.164    39.352     0.200
     1.165    39.344     0.200
     1.386    44.242     0.200
     2.956    86.445     0.200
     1.155    38.516     0.200
     1.156    39.461     0.200
     1.190    38.062     0.200
     1.176    37.620     0.200
     0.681    24.805     0.200
     0.862    31.005     0.200
     0.971    33.505     0.200
     0.978    32.604     0.200
     1.147    38.104     0.200
     1.138    37.953     0.200
     1.242    39.656     0.200
     1.254    39.656     0.200
     1.948    56.523     0.200
     2.236    62.781     0.200
     1.413    42.562     0.200
     0.851    29.895     0.200
     1.020    34.994     0.200
     1.076    35.695     0.200
     1.250    41.994     0.200
     1.172    37.906     0.200
     1.058    36.305     0.200
     1.154    39.203     0.200
     1.187    40.805     0.200
     3.592    97.836     0.200
     4.295   118.008     0.200
     0.880    30.508     0.200
     0.998    33.207     0.200
     1.099    36.406     0.200
     1.182    41.395     0.200
     1.175    39.094     0.200
     1.496    47.594     0.200
     2.855    82.996     0.200
     0.732    25.141     0.200
     1.001    34.742     0.200
     1.042    34.945     0.200
     1.186    39.141     0.200
     1.156    37.844     0.200
     1.212    39.641     0.200
     1.240    39.945     0.200
     1.062    35.193     0.200
     1.114    36.893     0.200
     1.292    41.093     0.200
     1.290    41.993     0.200
     1.023    33.939     0.200
     1.169    37.639     0.200
     1.062    35.639     0.200
     1.163    38.039     0.200
     0.678    23.438     0.200
     0.706    24.234     0.200
     0.749    25.438     0.200
     0.859    28.641     0.200
     0.861    28.039     0.200
     1.225    39.557     0.200
     1.226    39.758     0.200
     0.500    19.179     0.200
     0.509    19.979     0.200
     0.735    25.979     0.200
     0.790    26.179     0.200
     0.865    28.479     0.200
     0.867    28.179     0.200
     0.875    28.278     0.200
     0.952    29.979     0.200
     0.959    30.578     0.200
     0.986    31.278     0.200
     1.030    32.679     0.200
     1.064    32.479     0.200
     1.096    33.578     0.200
     1.139    34.179     0.200
     1.162    34.378     0.200
     1.318    38.878     0.200
     1.319    39.179     0.200
     1.344    39.878     0.200
     1.533    44.479     0.200
     1.705    47.878     0.200
     1.705    47.878     0.200
     1.880    52.479     0.200
     2.049    57.479     0.200
     2.362    63.679     0.200
     2.799    75.479     0.200
     3.219    83.979     0.200
     3.286    85.878     0.200
     4.442   116.578     0.200
     0.667    21.312     0.200
     0.815    23.344     0.200
     0.815    23.514     0.200
     0.794    25.713     0.200
     0.955    28.514     0.200
     0.927    28.613     0.200
     1.026    32.113     0.200
     1.089    31.713     0.200
     1.075    32.613     0.200
     1.139    33.914     0.200
     1.288    38.164     0.200
     1.348    38.312     0.200
     1.428    42.414     0.200
     1.487    43.514     0.200
     1.630    46.414     0.200
     1.630    46.113     0.200
     1.711    49.812     0.200
     2.165    58.613     0.200
     2.363    65.514     0.200
     3.108    82.812     0.200
     3.102    84.312     0.200
     3.529    93.812     0.200
     1.657    49.007     0.200
     0.960    32.536     0.200
     0.960    32.436     0.200
     0.919    31.312     0.200
     1.040    34.012     0.200
     1.143    37.898     0.200
     1.730    52.898     0.200
     2.913    83.398     0.200
     2.946    84.398     0.200
     3.001    84.898     0.200
     3.057    87.199     0.200
     3.292    92.898     0.200
     3.690   102.699     0.200
     0.905    29.500     0.200
     0.906    29.703     0.200
     0.928    31.102     0.200
     1.159    37.328     0.200
     1.225    38.633     0.200
     1.283    40.031     0.200
     1.296    41.133     0.200
     1.184    38.117     0.200
     3.483    95.715     0.200
     0.743    27.562     0.200
     1.133    36.395     0.200
     1.223    39.793     0.200
     0.931    31.766     0.200
     1.166    38.469     0.200
     1.231    38.055     0.200
     0.750    26.082     0.200
     0.853    28.783     0.200
     0.863    29.482     0.200
     0.998    33.082     0.200
     1.010    32.684     0.200
     1.049    36.283     0.200
     1.122    36.582     0.200
     1.233    39.482     0.200
     1.218    39.783     0.200
     1.198    38.193     0.200
     1.189    39.320     0.200
     1.211    39.609     0.200
     1.198    38.609     0.200
     1.257    40.109     0.200
     1.315    41.512     0.200
     0.916    30.980     0.200
     1.076    35.082     0.200
     1.134    36.480     0.200
     1.117    36.530     0.200
     0.780    27.186     0.200
     0.872    30.465     0.200
     1.128    37.675     0.200
     1.161    38.075     0.200
     1.167    38.896     0.200
     1.190    37.916     0.200
     1.219    39.405     0.200
     2.861    80.635     0.200
     2.918    82.855     0.200
     2.919    82.396     0.200
     3.508    96.725     0.200
     3.515    97.475     0.200
     0.512    20.180     0.200
     0.518    18.656     0.200
     0.678    23.320     0.200
     0.768    26.266     0.200
     0.779    24.539     0.200
     0.856    26.969     0.200
     0.918    30.102     0.200
     0.907    27.875     0.200
     1.181    36.547     0.200
     1.161    36.781     0.200
     1.299    39.430     0.200
     1.301    38.578     0.200
     1.382    41.000     0.200
     1.333    39.305     0.200
     1.467    44.211     0.200
     1.592    44.969     0.200
     1.413    41.172     0.200
     1.754    52.336     0.200
     1.569    44.422     0.200
     1.733    50.016     0.200
     1.599    42.930     0.200
     1.825    53.266     0.200
     1.724    48.867     0.200
     1.847    53.391     0.200
     2.222    63.789     0.200
     2.600    73.438     0.200
     2.314    63.266     0.200
     2.440    67.648     0.200
     2.921    75.781     0.200
     2.921    77.297     0.200
     3.641    95.109     0.200
     5.113   129.680     0.200
     0.991    32.898     0.200
     1.145    35.930     0.200
     1.143    32.180     0.200
     5.281   139.242     0.200
     3.464    97.556     0.200
     5.281   143.603     0.200
     6.645   168.655     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.892    30.055     0.200
     1.437    46.258     0.200
     0.417    14.408     0.200
     0.417    14.258     0.200
     0.693    23.408     0.200
     0.881    29.107     0.200
     1.055    33.516     0.200
     0.464    16.201     0.200
     0.561    20.258     0.200
     0.622    21.656     0.200
     0.746    25.359     0.200
     1.364    43.156     0.200
     1.678    52.555     0.200
     1.851    55.656     0.200
     0.180     8.312     0.200
     0.211     9.066     0.200
     0.432    14.967     0.200
     0.768    25.562     0.200
     0.987    32.062     0.200
     0.485    16.691     0.200
     0.602    21.293     0.200
     0.634    21.992     0.200
     0.943    32.090     0.200
     1.044    32.492     0.200
     1.310    43.293     0.200
     1.425    46.391     0.200
     1.998    61.391     0.200
     2.393    73.191     0.200
     0.149     7.664     0.200
     0.296    11.266     0.200
     0.630    22.363     0.200
     0.733    24.266     0.200
     0.767    25.863     0.200
     0.752    26.363     0.200
     0.772    26.562     0.200
     0.905    30.664     0.200
     1.312    41.562     0.200
     1.481    45.363     0.200
     0.157     6.859     0.200
     0.184     7.262     0.200
     0.267     9.160     0.200
     0.282     9.262     0.200
     0.391    13.660     0.200
     0.437    15.359     0.200
     0.506    16.262     0.200
     0.527    18.660     0.200
     0.536    17.559     0.200
     0.642    22.461     0.200
     0.685    23.359     0.200
     0.702    23.359     0.200
     0.712    23.262     0.200
     0.735    24.461     0.200
     0.028     3.609     0.200
     0.227     8.834     0.200
     0.257     8.234     0.200
     0.414    15.359     0.200
     0.414    14.234     0.200
     0.447    14.334     0.200
     0.085     5.781     0.200
     0.217     7.781     0.200
     0.270    10.406     0.200
     0.634    22.578     0.200
     0.646    22.883     0.200
     0.857    29.180     0.200
     0.920    30.180     0.200
     1.017    33.281     0.200
     1.369    43.383     0.200
     1.361    44.883     0.200
     1.496    47.180     0.200
     0.057     3.993     0.200
     0.140     5.893     0.200
     0.178     6.693     0.200
     0.238     8.693     0.200
     0.332    11.693     0.200
     0.373    13.493     0.200
     0.503    17.593     0.200
     0.604    20.793     0.200
     0.667    21.993     0.200
     0.744    24.493     0.200
     0.223     7.055     0.200
     0.189     8.453     0.200
     0.503    17.258     0.200
     0.627    21.859     0.200
     1.003    31.555     0.200
     1.036    33.953     0.200
     0.245    10.389     0.200
     0.342    12.088     0.200
     0.427    14.688     0.200
     0.491    16.789     0.200
     0.550    17.588     0.200
     0.640    21.289     0.200
     0.655    21.789     0.200
     0.682    22.889     0.200
     0.721    24.488     0.200
     0.766    25.688     0.200
     0.793    25.588     0.200
     0.862    28.789     0.200
     0.323    12.172     0.200
     0.494    16.871     0.200
     0.545    17.672     0.200
     0.667    22.473     0.200
     0.689    22.871     0.200
     0.867    29.473     0.200
     0.108     4.840     0.200
     0.271     9.242     0.200
     0.331    11.543     0.200
     0.408    12.641     0.200
     0.656    21.340     0.200
     0.207     9.434     0.200
     0.294     9.832     0.200
     0.445    15.133     0.200
     0.485    15.734     0.200
     0.482    17.832     0.200
     0.538    17.832     0.200
     0.583    19.234     0.200
     0.598    20.934     0.200
     0.648    22.234     0.200
     0.786    26.035     0.200
     0.834    27.234     0.200
     0.818    27.734     0.200
     0.858    28.934     0.200
     0.899    29.934     0.200
     0.893    28.734     0.200
     1.184    37.934     0.200
     1.481    46.535     0.200
     1.502    47.332     0.200
     1.912    57.934     0.200
     0.187     6.930     0.200
     0.319    11.230     0.200
     0.472    15.480     0.200
     0.468    16.531     0.200
     0.511    17.629     0.200
     0.561    19.930     0.200
     0.611    21.230     0.200
     0.634    21.332     0.200
     0.667    21.129     0.200
     0.814    27.031     0.200
     0.804    26.629     0.200
     0.856    29.031     0.200
     1.041    34.031     0.200
     1.197    38.031     0.200
     1.484    47.629     0.200
     0.682    21.424     0.200
     0.800    26.523     0.200
     0.938    29.725     0.200
     0.970    30.225     0.200
     1.036    33.023     0.200
     1.105    33.424     0.200
     1.856    55.725     0.200
     0.371    13.738     0.200
     0.550    18.537     0.200
     0.597    19.037     0.200
     0.582    19.338     0.200
     0.665    22.037     0.200
     0.665    22.238     0.200
     0.974    31.438     0.200
     1.362    42.637     0.200
     1.382    44.738     0.200
     1.371    43.338     0.200
     1.471    45.938     0.200
     1.499    46.338     0.200
     1.607    49.137     0.200
     1.634    51.238     0.200
     1.759    54.238     0.200
     0.229     9.242     0.200
     0.510    17.441     0.200
     0.635    20.742     0.200
     0.643    21.543     0.200
     0.662    22.543     0.200
     0.780    26.242     0.200
     0.830    26.641     0.200
     0.899    28.844     0.200
     0.964    31.201     0.200
     0.945    32.001     0.200
     0.937    32.501     0.200
     1.068    34.301     0.200
     1.053    34.201     0.200
     1.088    36.102     0.200
     1.455    46.501     0.200
     1.507    48.301     0.200
     1.508    48.401     0.200
     1.739    55.201     0.200
     1.887    58.301     0.200
     0.213     8.734     0.200
     0.445    15.836     0.200
     0.471    17.637     0.200
     0.491    16.734     0.200
     0.808    26.734     0.200
     0.886    28.137     0.200
     1.195    37.336     0.200
     0.198     8.137     0.200
     0.305    10.837     0.200
     0.497    17.137     0.200
     0.475    18.337     0.200
     0.586    19.437     0.200
     0.605    19.937     0.200
     0.614    20.437     0.200
     0.629    21.237     0.200
     0.967    31.037     0.200
     0.098     6.004     0.200
     0.262    10.430     0.200
     0.646    22.102     0.200
     0.650    23.402     0.200
     0.613    21.602     0.200
     0.565    20.703     0.200
     0.931    30.504     0.200
     1.467    47.203     0.200
     0.094     5.906     0.200
     0.249     7.711     0.200
     0.323    12.312     0.200
     0.577    20.812     0.200
     0.640    22.109     0.200
     0.658    23.406     0.200
     0.650    23.406     0.200
     0.824    27.906     0.200
     0.926    30.109     0.200
     0.996    33.008     0.200
     1.659    52.406     0.200
     0.093     6.461     0.200
     0.237     8.461     0.200
     0.479    16.340     0.200
     0.493    16.539     0.200
     0.661    22.539     0.200
     0.794    26.559     0.200
     0.168     7.215     0.200
     0.264     9.115     0.200
     0.395    14.115     0.200
     0.455    15.816     0.200
     0.447    16.115     0.200
     0.459    16.016     0.200
     0.603    20.115     0.200
     0.748    24.416     0.200
     0.192     7.375     0.200
     0.345    13.273     0.200
     0.369    13.475     0.200
     0.425    15.475     0.200
     0.460    15.975     0.200
     0.473    16.674     0.200
     0.197     7.227     0.200
     0.360    13.523     0.200
     0.383    14.023     0.200
     0.427    15.227     0.200
     0.445    15.227     0.200
     0.481    16.023     0.200
     0.649    21.227     0.200
     0.630    21.324     0.200
     0.748    24.426     0.200
     0.847    27.426     0.200
     1.032    33.523     0.200
     1.396    42.926     0.200
     1.656    52.523     0.200
     0.170     7.453     0.200
     0.215     8.750     0.200
     0.282     9.551     0.200
     0.374    13.453     0.200
     0.377    14.852     0.200
     0.446    15.652     0.200
     0.452    15.750     0.200
     0.532    18.652     0.200
     0.621    21.453     0.200
     0.729    24.051     0.200
     1.040    33.852     0.200
     1.401    44.250     0.200
     1.639    51.051     0.200
     0.122     5.707     0.200
     0.141     5.707     0.200
     0.210     8.008     0.200
     0.285    10.406     0.200
     0.373    13.707     0.200
     0.442    15.508     0.200
     0.456    15.707     0.200
     0.463    15.707     0.200
     0.540    18.605     0.200
     0.829    27.207     0.200
     0.600    20.938     0.200
     0.740    24.637     0.200
     0.860    27.938     0.200
     0.888    28.438     0.200
     0.934    29.535     0.200
     0.959    31.238     0.200
     0.992    31.438     0.200
     1.028    32.336     0.200
     1.025    31.637     0.200
     1.097    33.738     0.200
     1.229    38.910     0.200
     1.360    42.637     0.200
     1.421    44.137     0.200
     1.503    44.836     0.200
     1.643    49.438     0.200
     0.120     5.156     0.200
     0.180     6.656     0.200
     0.204     6.953     0.200
     0.290    10.258     0.200
     0.436    15.258     0.200
     0.461    16.055     0.200
     0.462    16.156     0.200
     0.463    15.758     0.200
     0.731    24.453     0.200
     0.146     6.521     0.200
     0.183     8.422     0.200
     0.212     7.521     0.200
     0.300    10.721     0.200
     0.367    11.721     0.200
     0.386    12.121     0.200
     0.416    14.422     0.200
     0.480    16.121     0.200
     0.164     6.410     0.200
     0.469    15.512     0.200
     0.477    16.012     0.200
     0.113     4.953     0.200
     0.174     6.156     0.200
     0.292    10.555     0.200
     0.438    15.453     0.200
     0.454    16.055     0.200
     0.721    24.250     0.200
     1.390    44.352     0.200
     1.648    51.750     0.200
     0.111     4.844     0.200
     0.335    12.742     0.200
     0.363    13.547     0.200
     0.297    10.445     0.200
     0.432    15.344     0.200
     0.460    16.047     0.200
     0.471    15.844     0.200
     0.662    21.844     0.200
     0.697    22.742     0.200
     0.722    24.141     0.200
     1.537    51.047     0.200
     1.654    52.547     0.200
     1.795    57.547     0.200
     3.165    97.242     0.200
     0.070     3.703     0.200
     0.150     5.305     0.200
     0.283    10.305     0.200
     0.282     9.703     0.200
     0.650    21.406     0.200
     1.575    48.906     0.200
     0.119     5.273     0.200
     0.149     6.180     0.200
     0.191     8.180     0.200
     0.194     7.375     0.200
     0.370    13.680     0.200
     0.426    15.375     0.200
     0.459    16.578     0.200
     0.694    22.680     0.200
     1.387    44.078     0.200
     0.141     6.016     0.200
     0.171     7.211     0.200
     0.284    10.211     0.200
     0.445    15.711     0.200
     0.465    16.117     0.200
     0.622    21.414     0.200
     0.710    22.914     0.200
     1.399    43.711     0.200
     1.640    51.414     0.200
     0.143     5.266     0.200
     0.175     7.164     0.200
     0.287    10.062     0.200
     0.441    15.562     0.200
     0.464    16.062     0.200
     0.706    22.867     0.200
     1.396    43.562     0.200
     1.644    51.664     0.200
     0.111     5.195     0.200
     0.154     5.891     0.200
     0.429    15.094     0.200
     0.463    16.289     0.200
     0.470    16.289     0.200
     1.384    44.289     0.200
     1.656    52.695     0.200
     0.174     6.820     0.200
     0.147     5.621     0.200
     0.231     8.422     0.200
     0.159     6.126     0.200
     0.134     5.126     0.200
     0.187     6.126     0.200
     0.223     7.626     0.200
     0.291     9.726     0.200
     0.352    12.926     0.200
     0.389    12.426     0.200
     0.408    12.826     0.200
     0.420    14.826     0.200
     0.416    14.826     0.200
     0.475    16.126     0.200
     0.509    17.226     0.200
     1.620    50.332     0.200
     0.207     8.120     0.200
     0.291    10.320     0.200
     0.424    15.220     0.200
     0.433    15.420     0.200
     0.471    16.620     0.200
     0.642    21.220     0.200
     0.760    25.120     0.200
     1.399    44.820     0.200
     0.137     5.977     0.200
     0.195     7.680     0.200
     0.135     6.078     0.200
     0.199     6.781     0.200
     0.527    17.906     0.200
     0.285    11.505     0.200
     0.285    11.705     0.200
     0.469    16.305     0.200
     0.599    21.205     0.200
     0.592    20.905     0.200
     0.646    22.505     0.200
     1.269    40.505     0.200
     1.338    42.905     0.200
     1.379    43.604     0.200
     1.463    46.104     0.200
     1.710    52.905     0.200
     0.240     8.398     0.200
     0.243     9.195     0.200
     0.266     9.695     0.200
     0.320    11.500     0.200
     0.350    13.195     0.200
     0.410    15.398     0.200
     0.556    19.297     0.200
     0.567    20.398     0.200
     0.579    20.195     0.200
     0.629    21.602     0.200
     0.654    21.297     0.200
     1.490    45.297     0.200
     1.495    46.500     0.200
     0.120     5.578     0.200
     0.146     5.779     0.200
     0.181     7.078     0.200
     0.397    15.078     0.200
     0.450    15.979     0.200
     0.608    20.779     0.200
     0.755    24.578     0.200
     0.206     9.555     0.200
     0.242    10.852     0.200
     0.404    14.953     0.200
     0.404    14.953     0.200
     0.453    16.555     0.200
     0.700    24.156     0.200
     0.126     6.258     0.200
     0.165     7.562     0.200
     0.195     7.961     0.200
     0.283    11.359     0.200
     0.395    14.664     0.200
     0.410    16.062     0.200
     0.427    15.562     0.200
     0.508    17.758     0.200
     0.576    19.961     0.200
     0.703    23.258     0.200
     0.783    25.859     0.200
     1.117    34.664     0.200
     0.088     6.494     0.200
     0.198     8.195     0.200
     0.183     7.494     0.200
     0.209     9.695     0.200
     0.258    10.295     0.200
     0.277    10.895     0.200
     0.277    11.020     0.200
     0.382    14.395     0.200
     0.444    16.395     0.200
     0.628    21.994     0.200
     0.627    20.895     0.200
     0.647    21.596     0.200
     0.757    24.994     0.200
     0.791    26.596     0.200
     0.846    28.596     0.200
     0.893    29.295     0.200
     0.914    29.695     0.200
     0.898    29.494     0.200
     1.029    33.695     0.200
     1.328    42.195     0.200
     1.511    46.994     0.200
     1.659    50.395     0.200
     2.369    70.795     0.200
     0.181     6.906     0.200
     0.152     6.203     0.200
     0.208     8.406     0.200
     0.357    14.008     0.200
     0.414    14.805     0.200
     0.304    10.805     0.200
     0.543    18.008     0.200
     0.448    15.305     0.200
     0.490    16.703     0.200
     0.637    21.203     0.200
     0.684    22.305     0.200
     0.745    25.203     0.200
     0.642    22.203     0.200
     0.769    25.305     0.200
     0.740    25.406     0.200
     1.020    33.906     0.200
     1.384    44.305     0.200
     1.534    49.906     0.200
     1.669    53.102     0.200
     2.319    71.406     0.200
     3.696   113.008     0.200
     0.186     6.027     0.200
     0.269     9.328     0.200
     0.357    11.629     0.200
     0.369    13.426     0.200
     0.477    16.629     0.200
     0.508    16.129     0.200
     0.611    19.527     0.200
     0.606    20.727     0.200
     0.686    21.926     0.200
     0.152     6.906     0.200
     0.191     9.105     0.200
     0.224     7.906     0.200
     0.294    10.906     0.200
     0.336    12.605     0.200
     0.399    14.305     0.200
     0.397    13.906     0.200
     0.610    21.508     0.200
     0.616    21.406     0.200
     0.600    19.906     0.200
     0.749    25.605     0.200
     0.795    26.906     0.200
     0.896    29.008     0.200
     1.515    49.008     0.200
     1.636    50.105     0.200
     1.981    62.008     0.200
     0.495    16.422     0.200
     0.517    16.297     0.200
     0.487    17.395     0.200
     0.591    17.496     0.200
     0.635    22.195     0.200
     0.832    26.496     0.200
     0.821    27.996     0.200
     0.822    28.395     0.200
     0.852    28.996     0.200
     0.982    32.695     0.200
     1.215    40.094     0.200
     1.549    49.695     0.200
     1.795    56.594     0.200
     0.616    20.742     0.200
     0.633    20.844     0.200
     0.659    22.641     0.200
     0.920    30.445     0.200
     1.406    44.742     0.200
     1.483    46.641     0.200
     1.556    50.141     0.200
     1.607    49.445     0.200
     1.627    50.547     0.200
     1.732    54.945     0.200
     1.813    56.141     0.200
     1.885    58.047     0.200
     1.895    58.641     0.200
     2.122    65.141     0.200
     2.087    62.844     0.200
     0.665    23.593     0.200
     0.983    33.393     0.200
     1.047    33.693     0.200
     1.066    35.093     0.200
     1.555    48.093     0.200
     1.693    53.393     0.200
     1.766    55.093     0.200
     1.887    57.993     0.200
     0.114     5.439     0.200
     0.195     8.039     0.200
     0.188     7.539     0.200
     0.340    13.340     0.200
     0.365    14.238     0.200
     0.403    14.340     0.200
     0.427    15.039     0.200
     0.299    10.639     0.200
     0.530    18.139     0.200
     0.468    15.738     0.200
     0.465    15.840     0.200
     0.472    16.939     0.200
     0.655    22.039     0.200
     0.693    22.639     0.200
     0.728    23.840     0.200
     0.638    21.340     0.200
     0.786    25.738     0.200
     0.845    27.609     0.200
     0.845    27.238     0.200
     0.941    31.238     0.200
     1.385    43.539     0.200
     1.542    49.738     0.200
     1.658    52.139     0.200
     1.912    59.639     0.200
     0.241     9.242     0.200
     0.424    15.141     0.200
     0.504    17.242     0.200
     0.518    17.844     0.200
     0.610    20.445     0.200
     0.633    21.141     0.200
     0.672    22.742     0.200
     0.683    22.242     0.200
     0.692    23.445     0.200
     0.729    23.844     0.200
     0.847    27.547     0.200
     0.875    28.945     0.200
     1.235    38.445     0.200
     0.196     6.189     0.200
     0.346    11.990     0.200
     0.324    11.590     0.200
     0.399    14.689     0.200
     0.444    15.391     0.200
     0.515    16.289     0.200
     0.566    18.689     0.200
     0.673    21.689     0.200
     0.686    22.689     0.200
     0.689    21.990     0.200
     0.872    29.090     0.200
     0.074     7.234     0.200
     0.079     7.039     0.200
     0.239    10.938     0.200
     0.265    12.141     0.200
     0.471    17.836     0.200
     0.505    18.234     0.200
     0.617    21.641     0.200
     1.051    33.438     0.200
     1.114    34.938     0.200
     1.131    35.938     0.200
     0.319    12.557     0.200
     0.350    14.057     0.200
     0.578    19.758     0.200
     0.638    21.258     0.200
     0.651    22.758     0.200
     0.721    23.758     0.200
     0.765    25.557     0.200
     0.822    26.258     0.200
     1.144    35.656     0.200
     1.621    49.357     0.200
     0.116     4.906     0.200
     0.188     7.706     0.200
     0.196     7.706     0.200
     0.297    11.706     0.200
     0.343    13.106     0.200
     0.368    13.106     0.200
     0.406    13.807     0.200
     0.385    14.507     0.200
     0.428    15.007     0.200
     0.469    16.206     0.200
     0.471    16.606     0.200
     0.463    16.507     0.200
     0.636    21.906     0.200
     0.655    21.906     0.200
     0.694    22.307     0.200
     0.730    23.807     0.200
     0.844    27.307     0.200
     0.117     6.436     0.200
     0.305    10.336     0.200
     0.437    14.836     0.200
     0.493    15.936     0.200
     0.555    18.235     0.200
     0.553    19.636     0.200
     0.773    25.235     0.200
     0.823    27.235     0.200
     0.926    31.235     0.200
     0.963    31.036     0.200
     1.036    32.936     0.200
     1.088    35.336     0.200
     0.131     6.211     0.200
     0.286     9.812     0.200
     0.349    11.711     0.200
     0.436    14.512     0.200
     0.475    15.609     0.200
     0.543    18.512     0.200
     0.627    21.711     0.200
     0.816    27.012     0.200
     0.958    31.609     0.200
     0.959    31.512     0.200
     0.971    30.910     0.200
     1.037    32.910     0.200
     0.307    10.199     0.200
     0.383    12.799     0.200
     0.416    14.799     0.200
     0.491    15.898     0.200
     0.543    18.299     0.200
     0.564    19.199     0.200
     0.628    20.299     0.200
     0.653    22.498     0.200
     0.761    25.299     0.200
     0.805    26.199     0.200
     0.817    26.699     0.200
     0.909    30.799     0.200
     0.982    32.098     0.200
     0.983    32.199     0.200
     1.034    33.699     0.200
     1.014    32.998     0.200
     1.070    35.098     0.200
     1.393    44.299     0.200
     1.639    52.299     0.200
     1.938    60.699     0.200
     0.183     7.797     0.200
     0.284    10.602     0.200
     0.457    16.500     0.200
     0.478    16.898     0.200
     0.507    18.398     0.200
     0.552    19.602     0.200
     0.560    18.000     0.200
     0.602    20.602     0.200
     0.615    20.398     0.200
     0.674    23.102     0.200
     0.792    25.398     0.200
     0.844    27.297     0.200
     1.236    38.500     0.200
     0.106     5.727     0.200
     0.271    10.031     0.200
     0.333    11.930     0.200
     0.346    12.133     0.200
     0.340    12.531     0.200
     0.407    13.930     0.200
     0.563    19.133     0.200
     0.583    19.633     0.200
     0.650    20.227     0.200
     0.744    24.133     0.200
     0.925    30.133     0.200
     1.011    32.828     0.200
     2.187    65.828     0.200
     0.150     6.516     0.200
     0.184     7.617     0.200
     0.217     9.117     0.200
     0.373    13.816     0.200
     0.350    14.117     0.200
     0.402    14.215     0.200
     0.440    14.617     0.200
     0.450    16.414     0.200
     0.433    15.715     0.200
     0.445    15.914     0.200
     0.471    16.516     0.200
     0.509    18.016     0.200
     0.532    18.715     0.200
     0.568    19.516     0.200
     0.570    19.516     0.200
     0.606    21.414     0.200
     0.721    23.516     0.200
     0.760    25.316     0.200
     0.825    27.117     0.200
     1.420    44.617     0.200
     0.193     7.164     0.200
     0.243     9.367     0.200
     0.261    10.266     0.200
     0.403    15.266     0.200
     0.499    18.461     0.200
     0.574    18.961     0.200
     0.593    20.664     0.200
     0.927    29.664     0.200
     0.215     7.922     0.200
     0.234     9.824     0.200
     0.296    10.125     0.200
     0.483    15.922     0.200
     0.512    17.324     0.200
     0.468    16.723     0.200
     0.570    19.023     0.200
     0.600    20.125     0.200
     0.627    21.422     0.200
     1.203    38.523     0.200
     0.269    11.695     0.200
     0.368    13.094     0.200
     0.536    19.094     0.200
     0.195     9.027     0.200
     0.277     9.328     0.200
     0.404    13.629     0.200
     0.763    25.227     0.200
     1.256    39.438     0.200
     1.556    48.828     0.200
     0.272    11.469     0.200
     0.541    19.766     0.200
     0.744    25.164     0.200
     0.717    24.867     0.200
     1.581    47.664     0.200
     1.768    52.664     0.200
     2.076    61.664     0.200
     0.268     9.125     0.200
     0.380    13.430     0.200
     0.530    19.023     0.200
     0.704    24.430     0.200
     1.210    37.523     0.200
     1.347    42.828     0.200
     1.601    50.828     0.200
     1.783    55.523     0.200
     0.046     5.482     0.200
     0.411    15.684     0.200
     0.601    20.684     0.200
     0.613    20.883     0.200
     0.599    20.582     0.200
     0.595    21.684     0.200
     0.628    21.482     0.200
     0.680    23.883     0.200
     0.839    27.283     0.200
     0.844    28.283     0.200
     0.871    28.684     0.200
     1.343    41.582     0.200
     1.351    42.883     0.200
     1.398    44.482     0.200
     1.638    50.383     0.200
     0.142     6.094     0.200
     0.167     6.393     0.200
     0.296    10.992     0.200
     0.357    13.193     0.200
     0.362    12.193     0.200
     0.444    15.992     0.200
     0.515    18.094     0.200
     0.502    16.492     0.200
     0.532    18.193     0.200
     0.570    20.193     0.200
     0.599    19.393     0.200
     0.662    23.293     0.200
     0.687    24.193     0.200
     0.698    22.992     0.200
     0.786    26.992     0.200
     0.796    27.893     0.200
     0.909    30.094     0.200
     0.996    32.893     0.200
     1.133    36.293     0.200
     1.471    46.293     0.200
     0.136     5.721     0.200
     0.146     6.621     0.200
     0.362    12.721     0.200
     0.436    13.920     0.200
     0.474    16.320     0.200
     0.525    17.521     0.200
     0.554    18.721     0.200
     0.579    18.820     0.200
     0.674    22.621     0.200
     0.807    27.420     0.200
     0.908    31.021     0.200
     0.310    11.535     0.200
     0.291    10.609     0.200
     0.359    12.410     0.200
     0.359    13.312     0.200
     0.495    16.512     0.200
     0.519    18.410     0.200
     0.570    19.312     0.200
     0.607    19.812     0.200
     0.651    22.012     0.200
     0.700    24.410     0.200
     0.776    26.109     0.200
     0.958    31.910     0.200
     1.000    32.910     0.200
     1.046    34.312     0.200
     1.497    46.711     0.200
     1.473    46.512     0.200
     1.759    53.211     0.200
     1.788    54.711     0.200
     0.129     5.184     0.200
     0.303    12.105     0.200
     0.305    12.582     0.200
     0.354    13.281     0.200
     0.516    17.980     0.200
     0.508    18.582     0.200
     0.586    20.082     0.200
     0.570    20.383     0.200
     0.689    24.582     0.200
     0.695    22.684     0.200
     0.678    23.781     0.200
     0.797    26.480     0.200
     0.800    27.184     0.200
     0.800    26.980     0.200
     0.954    31.582     0.200
     0.195     8.360     0.200
     0.433    14.521     0.200
     0.438    15.521     0.200
     0.503    16.681     0.200
     0.642    21.920     0.200
     0.725    24.271     0.200
     0.957    30.891     0.200
     1.106    35.330     0.200
     1.394    43.391     0.200
     0.144     7.075     0.200
     0.160     7.765     0.200
     0.177     8.025     0.200
     0.234    10.155     0.200
     0.301    11.315     0.200
     0.356    14.805     0.200
     0.392    14.575     0.200
     0.409    14.945     0.200
     0.407    15.445     0.200
     0.414    15.666     0.200
     0.486    17.555     0.200
     0.520    17.735     0.200
     0.527    17.706     0.200
     0.565    20.035     0.200
     0.571    19.956     0.200
     0.637    21.735     0.200
     0.719    24.555     0.200
     0.753    24.475     0.200
     1.374    44.315     0.200
     1.397    43.235     0.200
     1.516    47.295     0.200
     1.543    48.355     0.200
     1.624    50.125     0.200
     1.673    51.745     0.200
     1.782    54.686     0.200
     3.387   101.095     0.200
     0.254    10.891     0.200
     0.508    16.867     0.200
     0.524    17.199     0.200
     0.650    21.539     0.200
     0.654    21.910     0.200
     1.169    37.520     0.200
     1.749    53.188     0.200
     0.131     5.562     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     3.095   103.998     0.200
     2.932    92.344     0.200
     3.620   112.844     0.200
     2.550    84.265     0.200
     2.608    85.635     0.200
     3.138    96.825     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.892    30.055     0.200
     1.437    46.258     0.200
     0.417    14.408     0.200
     0.417    14.258     0.200
     0.693    23.408     0.200
     0.881    29.107     0.200
     1.055    33.516     0.200
     0.464    16.201     0.200
     0.561    20.258     0.200
     0.622    21.656     0.200
     0.746    25.359     0.200
     1.364    43.156     0.200
     1.678    52.555     0.200
     1.851    55.656     0.200
     0.180     8.312     0.200
     0.211     9.066     0.200
     0.432    14.967     0.200
     0.768    25.562     0.200
     0.987    32.062     0.200
     0.485    16.691     0.200
     0.602    21.293     0.200
     0.634    21.992     0.200
     0.943    32.090     0.200
     1.044    32.492     0.200
     1.310    43.293     0.200
     1.425    46.391     0.200
     1.998    61.391     0.200
     2.393    73.191     0.200
     0.149     7.664     0.200
     0.296    11.266     0.200
     0.630    22.363     0.200
     0.733    24.266     0.200
     0.767    25.863     0.200
     0.752    26.363     0.200
     0.772    26.562     0.200
     0.905    30.664     0.200
     1.312    41.562     0.200
     1.481    45.363     0.200
     0.157     6.859     0.200
     0.184     7.262     0.200
     0.267     9.160     0.200
     0.282     9.262     0.200
     0.391    13.660     0.200
     0.437    15.359     0.200
     0.506    16.262     0.200
     0.527    18.660     0.200
     0.536    17.559     0.200
     0.642    22.461     0.200
     0.685    23.359     0.200
     0.702    23.359     0.200
     0.712    23.262     0.200
     0.735    24.461     0.200
     0.028     3.609     0.200
     0.227     8.834     0.200
     0.257     8.234     0.200
     0.414    15.359     0.200
     0.414    14.234     0.200
     0.447    14.334     0.200
     0.085     5.781     0.200
     0.217     7.781     0.200
     0.270    10.406     0.200
     0.634    22.578     0.200
     0.646    22.883     0.200
     0.857    29.180     0.200
     0.920    30.180     0.200
     1.017    33.281     0.200
     1.369    43.383     0.200
     1.361    44.883     0.200
     1.496    47.180     0.200
     0.057     3.993     0.200
     0.140     5.893     0.200
     0.178     6.693     0.200
     0.238     8.693     0.200
     0.332    11.693     0.200
     0.373    13.493     0.200
     0.503    17.593     0.200
     0.604    20.793     0.200
     0.667    21.993     0.200
     0.744    24.493     0.200
     0.223     7.055     0.200
     0.189     8.453     0.200
     0.503    17.258     0.200
     0.627    21.859     0.200
     1.003    31.555     0.200
     1.036    33.953     0.200
     0.245    10.389     0.200
     0.342    12.088     0.200
     0.427    14.688     0.200
     0.491    16.789     0.200
     0.550    17.588     0.200
     0.640    21.289     0.200
     0.655    21.789     0.200
     0.682    22.889     0.200
     0.721    24.488     0.200
     0.766    25.688     0.200
     0.793    25.588     0.200
     0.862    28.789     0.200
     0.323    12.172     0.200
     0.494    16.871     0.200
     0.545    17.672     0.200
     0.667    22.473     0.200
     0.689    22.871     0.200
     0.867    29.473     0.200
     0.108     4.840     0.200
     0.271     9.242     0.200
     0.331    11.543     0.200
     0.408    12.641     0.200
     0.656    21.340     0.200
     0.207     9.434     0.200
     0.294     9.832     0.200
     0.445    15.133     0.200
     0.485    15.734     0.200
     0.482    17.832     0.200
     0.538    17.832     0.200
     0.583    19.234     0.200
     0.598    20.934     0.200
     0.648    22.234     0.200
     0.786    26.035     0.200
     0.834    27.234     0.200
     0.818    27.734     0.200
     0.858    28.934     0.200
     0.899    29.934     0.200
     0.893    28.734     0.200
     1.184    37.934     0.200
     1.481    46.535     0.200
     1.502    47.332     0.200
     1.912    57.934     0.200
     0.187     6.930     0.200
     0.319    11.230     0.200
     0.472    15.480     0.200
     0.468    16.531     0.200
     0.511    17.629     0.200
     0.561    19.930     0.200
     0.611    21.230     0.200
     0.634    21.332     0.200
     0.667    21.129     0.200
     0.814    27.031     0.200
     0.804    26.629     0.200
     0.856    29.031     0.200
     1.041    34.031     0.200
     1.197    38.031     0.200
     1.484    47.629     0.200
     0.682    21.424     0.200
     0.800    26.523     0.200
     0.938    29.725     0.200
     0.970    30.225     0.200
     1.036    33.023     0.200
     1.105    33.424     0.200
     1.856    55.725     0.200
     0.371    13.738     0.200
     0.550    18.537     0.200
     0.597    19.037     0.200
     0.582    19.338     0.200
     0.665    22.037     0.200
     0.665    22.238     0.200
     0.974    31.438     0.200
     1.362    42.637     0.200
     1.382    44.738     0.200
     1.371    43.338     0.200
     1.471    45.938     0.200
     1.499    46.338     0.200
     1.607    49.137     0.200
     1.634    51.238     0.200
     1.759    54.238     0.200
     0.229     9.242     0.200
     0.510    17.441     0.200
     0.635    20.742     0.200
     0.643    21.543     0.200
     0.662    22.543     0.200
     0.780    26.242     0.200
     0.830    26.641     0.200
     0.899    28.844     0.200
     0.964    31.201     0.200
     0.945    32.001     0.200
     0.937    32.501     0.200
     1.068    34.301     0.200
     1.053    34.201     0.200
     1.088    36.102     0.200
     1.455    46.501     0.200
     1.507    48.301     0.200
     1.508    48.401     0.200
     1.739    55.201     0.200
     1.887    58.301     0.200
     0.213     8.734     0.200
     0.445    15.836     0.200
     0.471    17.637     0.200
     0.491    16.734     0.200
     0.808    26.734     0.200
     0.886    28.137     0.200
     1.195    37.336     0.200
     0.198     8.137     0.200
     0.305    10.837     0.200
     0.497    17.137     0.200
     0.475    18.337     0.200
     0.586    19.437     0.200
     0.605    19.937     0.200
     0.614    20.437     0.200
     0.629    21.237     0.200
     0.967    31.037     0.200
     0.098     6.004     0.200
     0.262    10.430     0.200
     0.646    22.102     0.200
     0.650    23.402     0.200
     0.613    21.602     0.200
     0.565    20.703     0.200
     0.931    30.504     0.200
     1.467    47.203     0.200
     0.094     5.906     0.200
     0.249     7.711     0.200
     0.323    12.312     0.200
     0.577    20.812     0.200
     0.640    22.109     0.200
     0.658    23.406     0.200
     0.650    23.406     0.200
     0.824    27.906     0.200
     0.926    30.109     0.200
     0.996    33.008     0.200
     1.659    52.406     0.200
     0.093     6.461     0.200
     0.237     8.461     0.200
     0.479    16.340     0.200
     0.493    16.539     0.200
     0.661    22.539     0.200
     0.794    26.559     0.200
     0.168     7.215     0.200
     0.264     9.115     0.200
     0.395    14.115     0.200
     0.455    15.816     0.200
     0.447    16.115     0.200
     0.459    16.016     0.200
     0.603    20.115     0.200
     0.748    24.416     0.200
     0.192     7.375     0.200
     0.345    13.273     0.200
     0.369    13.475     0.200
     0.425    15.475     0.200
     0.460    15.975     0.200
     0.473    16.674     0.200
     0.197     7.227     0.200
     0.360    13.523     0.200
     0.383    14.023     0.200
     0.427    15.227     0.200
     0.445    15.227     0.200
     0.481    16.023     0.200
     0.649    21.227     0.200
     0.630    21.324     0.200
     0.748    24.426     0.200
     0.847    27.426     0.200
     1.032    33.523     0.200
     1.396    42.926     0.200
     1.656    52.523     0.200
     0.170     7.453     0.200
     0.215     8.750     0.200
     0.282     9.551     0.200
     0.374    13.453     0.200
     0.377    14.852     0.200
     0.446    15.652     0.200
     0.452    15.750     0.200
     0.532    18.652     0.200
     0.621    21.453     0.200
     0.729    24.051     0.200
     1.040    33.852     0.200
     1.401    44.250     0.200
     1.639    51.051     0.200
     0.122     5.707     0.200
     0.141     5.707     0.200
     0.210     8.008     0.200
     0.285    10.406     0.200
     0.373    13.707     0.200
     0.442    15.508     0.200
     0.456    15.707     0.200
     0.463    15.707     0.200
     0.540    18.605     0.200
     0.829    27.207     0.200
     0.600    20.938     0.200
     0.740    24.637     0.200
     0.860    27.938     0.200
     0.888    28.438     0.200
     0.934    29.535     0.200
     0.959    31.238     0.200
     0.992    31.438     0.200
     1.028    32.336     0.200
     1.025    31.637     0.200
     1.097    33.738     0.200
     1.229    38.910     0.200
     1.360    42.637     0.200
     1.421    44.137     0.200
     1.503    44.836     0.200
     1.643    49.438     0.200
     0.120     5.156     0.200
     0.180     6.656     0.200
     0.204     6.953     0.200
     0.290    10.258     0.200
     0.436    15.258     0.200
     0.461    16.055     0.200
     0.462    16.156     0.200
     0.463    15.758     0.200
     0.731    24.453     0.200
     0.146     6.521     0.200
     0.183     8.422     0.200
     0.212     7.521     0.200
     0.300    10.721     0.200
     0.367    11.721     0.200
     0.386    12.121     0.200
     0.416    14.422     0.200
     0.480    16.121     0.200
     0.164     6.410     0.200
     0.469    15.512     0.200
     0.477    16.012     0.200
     0.113     4.953     0.200
     0.174     6.156     0.200
     0.292    10.555     0.200
     0.438    15.453     0.200
     0.454    16.055     0.200
     0.721    24.250     0.200
     1.390    44.352     0.200
     1.648    51.750     0.200
     0.111     4.844     0.200
     0.335    12.742     0.200
     0.363    13.547     0.200
     0.297    10.445     0.200
     0.432    15.344     0.200
     0.460    16.047     0.200
     0.471    15.844     0.200
     0.662    21.844     0.200
     0.697    22.742     0.200
     0.722    24.141     0.200
     1.537    51.047     0.200
     1.654    52.547     0.200
     1.795    57.547     0.200
     3.165    97.242     0.200
     0.070     3.703     0.200
     0.150     5.305     0.200
     0.283    10.305     0.200
     0.282     9.703     0.200
     0.650    21.406     0.200
     1.575    48.906     0.200
     0.119     5.273     0.200
     0.149     6.180     0.200
     0.191     8.180     0.200
     0.194     7.375     0.200
     0.370    13.680     0.200
     0.426    15.375     0.200
     0.459    16.578     0.200
     0.694    22.680     0.200
     1.387    44.078     0.200
     0.141     6.016     0.200
     0.171     7.211     0.200
     0.284    10.211     0.200
     0.445    15.711     0.200
     0.465    16.117     0.200
     0.622    21.414     0.200
     0.710    22.914     0.200
     1.399    43.711     0.200
     1.640    51.414     0.200
     0.143     5.266     0.200
     0.175     7.164     0.200
     0.287    10.062     0.200
     0.441    15.562     0.200
     0.464    16.062     0.200
     0.706    22.867     0.200
     1.396    43.562     0.200
     1.644    51.664     0.200
     0.111     5.195     0.200
     0.154     5.891     0.200
     0.429    15.094     0.200
     0.463    16.289     0.200
     0.470    16.289     0.200
     1.384    44.289     0.200
     1.656    52.695     0.200
     0.174     6.820     0.200
     0.147     5.621     0.200
     0.231     8.422     0.200
     0.159     6.126     0.200
     0.134     5.126     0.200
     0.187     6.126     0.200
     0.223     7.626     0.200
     0.291     9.726     0.200
     0.352    12.926     0.200
     0.389    12.426     0.200
     0.408    12.826     0.200
     0.420    14.826     0.200
     0.416    14.826     0.200
     0.475    16.126     0.200
     0.509    17.226     0.200
     1.620    50.332     0.200
     0.207     8.120     0.200
     0.291    10.320     0.200
     0.424    15.220     0.200
     0.433    15.420     0.200
     0.471    16.620     0.200
     0.642    21.220     0.200
     0.760    25.120     0.200
     1.399    44.820     0.200
     0.137     5.977     0.200
     0.195     7.680     0.200
     0.135     6.078     0.200
     0.199     6.781     0.200
     0.527    17.906     0.200
     0.285    11.505     0.200
     0.285    11.705     0.200
     0.469    16.305     0.200
     0.599    21.205     0.200
     0.592    20.905     0.200
     0.646    22.505     0.200
     1.269    40.505     0.200
     1.338    42.905     0.200
     1.379    43.604     0.200
     1.463    46.104     0.200
     1.710    52.905     0.200
     0.240     8.398     0.200
     0.243     9.195     0.200
     0.266     9.695     0.200
     0.320    11.500     0.200
     0.350    13.195     0.200
     0.410    15.398     0.200
     0.556    19.297     0.200
     0.567    20.398     0.200
     0.579    20.195     0.200
     0.629    21.602     0.200
     0.654    21.297     0.200
     1.490    45.297     0.200
     1.495    46.500     0.200
     0.120     5.578     0.200
     0.146     5.779     0.200
     0.181     7.078     0.200
     0.397    15.078     0.200
     0.450    15.979     0.200
     0.608    20.779     0.200
     0.755    24.578     0.200
     0.206     9.555     0.200
     0.242    10.852     0.200
     0.404    14.953     0.200
     0.404    14.953     0.200
     0.453    16.555     0.200
     0.700    24.156     0.200
     0.126     6.258     0.200
     0.165     7.562     0.200
     0.195     7.961     0.200
     0.283    11.359     0.200
     0.395    14.664     0.200
     0.410    16.062     0.200
     0.427    15.562     0.200
     0.508    17.758     0.200
     0.576    19.961     0.200
     0.703    23.258     0.200
     0.783    25.859     0.200
     1.117    34.664     0.200
     0.088     6.494     0.200
     0.198     8.195     0.200
     0.183     7.494     0.200
     0.209     9.695     0.200
     0.258    10.295     0.200
     0.277    10.895     0.200
     0.277    11.020     0.200
     0.382    14.395     0.200
     0.444    16.395     0.200
     0.628    21.994     0.200
     0.627    20.895     0.200
     0.647    21.596     0.200
     0.757    24.994     0.200
     0.791    26.596     0.200
     0.846    28.596     0.200
     0.893    29.295     0.200
     0.914    29.695     0.200
     0.898    29.494     0.200
     1.029    33.695     0.200
     1.328    42.195     0.200
     1.511    46.994     0.200
     1.659    50.395     0.200
     2.369    70.795     0.200
     0.181     6.906     0.200
     0.152     6.203     0.200
     0.208     8.406     0.200
     0.357    14.008     0.200
     0.414    14.805     0.200
     0.304    10.805     0.200
     0.543    18.008     0.200
     0.448    15.305     0.200
     0.490    16.703     0.200
     0.637    21.203     0.200
     0.684    22.305     0.200
     0.745    25.203     0.200
     0.642    22.203     0.200
     0.769    25.305     0.200
     0.740    25.406     0.200
     1.020    33.906     0.200
     1.384    44.305     0.200
     1.534    49.906     0.200
     1.669    53.102     0.200
     2.319    71.406     0.200
     3.696   113.008     0.200
     0.186     6.027     0.200
     0.269     9.328     0.200
     0.357    11.629     0.200
     0.369    13.426     0.200
     0.477    16.629     0.200
     0.508    16.129     0.200
     0.611    19.527     0.200
     0.606    20.727     0.200
     0.686    21.926     0.200
     0.152     6.906     0.200
     0.191     9.105     0.200
     0.224     7.906     0.200
     0.294    10.906     0.200
     0.336    12.605     0.200
     0.399    14.305     0.200
     0.397    13.906     0.200
     0.610    21.508     0.200
     0.616    21.406     0.200
     0.600    19.906     0.200
     0.749    25.605     0.200
     0.795    26.906     0.200
     0.896    29.008     0.200
     1.515    49.008     0.200
     1.636    50.105     0.200
     1.981    62.008     0.200
     0.495    16.422     0.200
     0.517    16.297     0.200
     0.487    17.395     0.200
     0.591    17.496     0.200
     0.635    22.195     0.200
     0.832    26.496     0.200
     0.821    27.996     0.200
     0.822    28.395     0.200
     0.852    28.996     0.200
     0.982    32.695     0.200
     1.215    40.094     0.200
     1.549    49.695     0.200
     1.795    56.594     0.200
     0.616    20.742     0.200
     0.633    20.844     0.200
     0.659    22.641     0.200
     0.920    30.445     0.200
     1.406    44.742     0.200
     1.483    46.641     0.200
     1.556    50.141     0.200
     1.607    49.445     0.200
     1.627    50.547     0.200
     1.732    54.945     0.200
     1.813    56.141     0.200
     1.885    58.047     0.200
     1.895    58.641     0.200
     2.122    65.141     0.200
     2.087    62.844     0.200
     0.665    23.593     0.200
     0.983    33.393     0.200
     1.047    33.693     0.200
     1.066    35.093     0.200
     1.555    48.093     0.200
     1.693    53.393     0.200
     1.766    55.093     0.200
     1.887    57.993     0.200
     0.114     5.439     0.200
     0.195     8.039     0.200
     0.188     7.539     0.200
     0.340    13.340     0.200
     0.365    14.238     0.200
     0.403    14.340     0.200
     0.427    15.039     0.200
     0.299    10.639     0.200
     0.530    18.139     0.200
     0.468    15.738     0.200
     0.465    15.840     0.200
     0.472    16.939     0.200
     0.655    22.039     0.200
     0.693    22.639     0.200
     0.728    23.840     0.200
     0.638    21.340     0.200
     0.786    25.738     0.200
     0.845    27.609     0.200
     0.845    27.238     0.200
     0.941    31.238     0.200
     1.385    43.539     0.200
     1.542    49.738     0.200
     1.658    52.139     0.200
     1.912    59.639     0.200
     0.241     9.242     0.200
     0.424    15.141     0.200
     0.504    17.242     0.200
     0.518    17.844     0.200
     0.610    20.445     0.200
     0.633    21.141     0.200
     0.672    22.742     0.200
     0.683    22.242     0.200
     0.692    23.445     0.200
     0.729    23.844     0.200
     0.847    27.547     0.200
     0.875    28.945     0.200
     1.235    38.445     0.200
     0.196     6.189     0.200
     0.346    11.990     0.200
     0.324    11.590     0.200
     0.399    14.689     0.200
     0.444    15.391     0.200
     0.515    16.289     0.200
     0.566    18.689     0.200
     0.673    21.689     0.200
     0.686    22.689     0.200
     0.689    21.990     0.200
     0.872    29.090     0.200
     0.074     7.234     0.200
     0.079     7.039     0.200
     0.239    10.938     0.200
     0.265    12.141     0.200
     0.471    17.836     0.200
     0.505    18.234     0.200
     0.617    21.641     0.200
     1.051    33.438     0.200
     1.114    34.938     0.200
     1.131    35.938     0.200
     0.319    12.557     0.200
     0.350    14.057     0.200
     0.578    19.758     0.200
     0.638    21.258     0.200
     0.651    22.758     0.200
     0.721    23.758     0.200
     0.765    25.557     0.200
     0.822    26.258     0.200
     1.144    35.656     0.200
     1.621    49.357     0.200
     0.116     4.906     0.200
     0.188     7.706     0.200
     0.196     7.706     0.200
     0.297    11.706     0.200
     0.343    13.106     0.200
     0.368    13.106     0.200
     0.406    13.807     0.200
     0.385    14.507     0.200
     0.428    15.007     0.200
     0.469    16.206     0.200
     0.471    16.606     0.200
     0.463    16.507     0.200
     0.636    21.906     0.200
     0.655    21.906     0.200
     0.694    22.307     0.200
     0.730    23.807     0.200
     0.844    27.307     0.200
     0.117     6.436     0.200
     0.305    10.336     0.200
     0.437    14.836     0.200
     0.493    15.936     0.200
     0.555    18.235     0.200
     0.553    19.636     0.200
     0.773    25.235     0.200
     0.823    27.235     0.200
     0.926    31.235     0.200
     0.963    31.036     0.200
     1.036    32.936     0.200
     1.088    35.336     0.200
     0.131     6.211     0.200
     0.286     9.812     0.200
     0.349    11.711     0.200
     0.436    14.512     0.200
     0.475    15.609     0.200
     0.543    18.512     0.200
     0.627    21.711     0.200
     0.816    27.012     0.200
     0.958    31.609     0.200
     0.959    31.512     0.200
     0.971    30.910     0.200
     1.037    32.910     0.200
     0.307    10.199     0.200
     0.383    12.799     0.200
     0.416    14.799     0.200
     0.491    15.898     0.200
     0.543    18.299     0.200
     0.564    19.199     0.200
     0.628    20.299     0.200
     0.653    22.498     0.200
     0.761    25.299     0.200
     0.805    26.199     0.200
     0.817    26.699     0.200
     0.909    30.799     0.200
     0.982    32.098     0.200
     0.983    32.199     0.200
     1.034    33.699     0.200
     1.014    32.998     0.200
     1.070    35.098     0.200
     1.393    44.299     0.200
     1.639    52.299     0.200
     1.938    60.699     0.200
     0.183     7.797     0.200
     0.284    10.602     0.200
     0.457    16.500     0.200
     0.478    16.898     0.200
     0.507    18.398     0.200
     0.552    19.602     0.200
     0.560    18.000     0.200
     0.602    20.602     0.200
     0.615    20.398     0.200
     0.674    23.102     0.200
     0.792    25.398     0.200
     0.844    27.297     0.200
     1.236    38.500     0.200
     0.106     5.727     0.200
     0.271    10.031     0.200
     0.333    11.930     0.200
     0.346    12.133     0.200
     0.340    12.531     0.200
     0.407    13.930     0.200
     0.563    19.133     0.200
     0.583    19.633     0.200
     0.650    20.227     0.200
     0.744    24.133     0.200
     0.925    30.133     0.200
     1.011    32.828     0.200
     2.187    65.828     0.200
     0.150     6.516     0.200
     0.184     7.617     0.200
     0.217     9.117     0.200
     0.373    13.816     0.200
     0.350    14.117     0.200
     0.402    14.215     0.200
     0.440    14.617     0.200
     0.450    16.414     0.200
     0.433    15.715     0.200
     0.445    15.914     0.200
     0.471    16.516     0.200
     0.509    18.016     0.200
     0.532    18.715     0.200
     0.568    19.516     0.200
     0.570    19.516     0.200
     0.606    21.414     0.200
     0.721    23.516     0.200
     0.760    25.316     0.200
     0.825    27.117     0.200
     1.420    44.617     0.200
     0.193     7.164     0.200
     0.243     9.367     0.200
     0.261    10.266     0.200
     0.403    15.266     0.200
     0.499    18.461     0.200
     0.574    18.961     0.200
     0.593    20.664     0.200
     0.927    29.664     0.200
     0.215     7.922     0.200
     0.234     9.824     0.200
     0.296    10.125     0.200
     0.483    15.922     0.200
     0.512    17.324     0.200
     0.468    16.723     0.200
     0.570    19.023     0.200
     0.600    20.125     0.200
     0.627    21.422     0.200
     1.203    38.523     0.200
     0.269    11.695     0.200
     0.368    13.094     0.200
     0.536    19.094     0.200
     0.195     9.027     0.200
     0.277     9.328     0.200
     0.404    13.629     0.200
     0.763    25.227     0.200
     1.256    39.438     0.200
     1.556    48.828     0.200
     0.272    11.469     0.200
     0.541    19.766     0.200
     0.744    25.164     0.200
     0.717    24.867     0.200
     1.581    47.664     0.200
     1.768    52.664     0.200
     2.076    61.664     0.200
     0.268     9.125     0.200
     0.380    13.430     0.200
     0.530    19.023     0.200
     0.704    24.430     0.200
     1.210    37.523     0.200
     1.347    42.828     0.200
     1.601    50.828     0.200
     1.783    55.523     0.200
     0.046     5.482     0.200
     0.411    15.684     0.200
     0.601    20.684     0.200
     0.613    20.883     0.200
     0.599    20.582     0.200
     0.595    21.684     0.200
     0.628    21.482     0.200
     0.680    23.883     0.200
     0.839    27.283     0.200
     0.844    28.283     0.200
     0.871    28.684     0.200
     1.343    41.582     0.200
     1.351    42.883     0.200
     1.398    44.482     0.200
     1.638    50.383     0.200
     0.142     6.094     0.200
     0.167     6.393     0.200
     0.296    10.992     0.200
     0.357    13.193     0.200
     0.362    12.193     0.200
     0.444    15.992     0.200
     0.515    18.094     0.200
     0.502    16.492     0.200
     0.532    18.193     0.200
     0.570    20.193     0.200
     0.599    19.393     0.200
     0.662    23.293     0.200
     0.687    24.193     0.200
     0.698    22.992     0.200
     0.786    26.992     0.200
     0.796    27.893     0.200
     0.909    30.094     0.200
     0.996    32.893     0.200
     1.133    36.293     0.200
     1.471    46.293     0.200
     0.136     5.721     0.200
     0.146     6.621     0.200
     0.362    12.721     0.200
     0.436    13.920     0.200
     0.474    16.320     0.200
     0.525    17.521     0.200
     0.554    18.721     0.200
     0.579    18.820     0.200
     0.674    22.621     0.200
     0.807    27.420     0.200
     0.908    31.021     0.200
     0.310    11.535     0.200
     0.291    10.609     0.200
     0.359    12.410     0.200
     0.359    13.312     0.200
     0.495    16.512     0.200
     0.519    18.410     0.200
     0.570    19.312     0.200
     0.607    19.812     0.200
     0.651    22.012     0.200
     0.700    24.410     0.200
     0.776    26.109     0.200
     0.958    31.910     0.200
     1.000    32.910     0.200
     1.046    34.312     0.200
     1.497    46.711     0.200
     1.473    46.512     0.200
     1.759    53.211     0.200
     1.788    54.711     0.200
     0.129     5.184     0.200
     0.303    12.105     0.200
     0.305    12.582     0.200
     0.354    13.281     0.200
     0.516    17.980     0.200
     0.508    18.582     0.200
     0.586    20.082     0.200
     0.570    20.383     0.200
     0.689    24.582     0.200
     0.695    22.684     0.200
     0.678    23.781     0.200
     0.797    26.480     0.200
     0.800    27.184     0.200
     0.800    26.980     0.200
     0.954    31.582     0.200
     0.195     8.360     0.200
     0.433    14.521     0.200
     0.438    15.521     0.200
     0.503    16.681     0.200
     0.642    21.920     0.200
     0.725    24.271     0.200
     0.957    30.891     0.200
     1.106    35.330     0.200
     1.394    43.391     0.200
     0.144     7.075     0.200
     0.160     7.765     0.200
     0.177     8.025     0.200
     0.234    10.155     0.200
     0.301    11.315     0.200
     0.356    14.805     0.200
     0.392    14.575     0.200
     0.409    14.945     0.200
     0.407    15.445     0.200
     0.414    15.666     0.200
     0.486    17.555     0.200
     0.520    17.735     0.200
     0.527    17.706     0.200
     0.565    20.035     0.200
     0.571    19.956     0.200
     0.637    21.735     0.200
     0.719    24.555     0.200
     0.753    24.475     0.200
     1.374    44.315     0.200
     1.397    43.235     0.200
     1.516    47.295     0.200
     1.543    48.355     0.200
     1.624    50.125     0.200
     1.673    51.745     0.200
     1.782    54.686     0.200
     3.387   101.095     0.200
     0.254    10.891     0.200
     0.508    16.867     0.200
     0.524    17.199     0.200
     0.650    21.539     0.200
     0.654    21.910     0.200
     1.169    37.520     0.200
     1.749    53.188     0.200
     0.131     5.562     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
