#!/bin/bash
gmt begin bandung1.79_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source bandung1.79'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.7 -10.0
  0.7 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.179     0.152     0.200
     0.892    -0.902     0.200
     0.417    -0.417     0.200
     0.417    -0.192     0.200
     0.634     0.139     0.200
     0.881    -0.578     0.200
     0.972    -0.537     0.200
     0.466    -0.059     0.200
     0.639     0.500     0.200
     0.715    -0.034     0.200
     0.178     0.938     0.200
     0.464    -0.628     0.200
     0.464    -0.903     0.200
     0.557     0.155     0.200
     0.557     0.434     0.200
     0.561     0.018     0.200
     0.622    -0.619     0.200
     0.746    -0.115     0.200
     0.913    -0.507     0.200
     0.913    -0.609     0.200
     0.225    -0.574     0.200
     0.600     1.531     0.200
     0.069    -0.250     0.200
     0.180    -0.065     0.200
     0.227     0.195     0.200
     0.239     0.223     0.200
     0.351     0.323     0.200
     0.356     1.599     0.200
     0.398    -0.532     0.200
     0.424    -0.611     0.200
     0.470    -0.177     0.200
     0.510     0.668     0.200
     0.596    -0.230     0.200
     0.654    -0.224     0.200
     0.738     0.291     0.200
     0.761    -0.051     0.200
     0.806     0.893     0.200
     0.855    -0.441     0.200
     0.856     0.150     0.200
     0.920     0.054     0.200
     0.211    -0.193     0.200
     0.432    -0.270     0.200
     0.465    -0.336     0.200
     0.501     0.102     0.200
     0.563    -0.218     0.200
     0.532    -0.564     0.200
     0.589     0.160     0.200
     0.656     0.640     0.200
     0.770    -0.507     0.200
     0.813     0.561     0.200
     0.838     0.411     0.200
     0.907    -0.206     0.200
     0.084    -0.255     0.200
     0.194    -0.560     0.200
     0.202    -0.117     0.200
     0.236    -0.256     0.200
     0.242     0.183     0.200
     0.308    -0.244     0.200
     0.391    -1.798     0.200
     0.445     0.318     0.200
     0.428     0.391     0.200
     0.468    -0.000     0.200
     0.471    -0.313     0.200
     0.493     0.264     0.200
     0.609    -0.021     0.200
     0.613    -0.080     0.200
     0.671    -1.161     0.200
     0.668    -0.230     0.200
     0.745    -0.155     0.200
     0.803    -0.654     0.200
     0.818    -0.055     0.200
     0.864     0.025     0.200
     0.986    -0.133     0.200
     0.621     0.338     0.200
     0.768    -0.281     0.200
     0.948    -0.537     0.200
     0.987    -0.030     0.200
     0.203     0.228     0.200
     0.264    -0.057     0.200
     0.334    -0.906     0.200
     0.380    -0.992     0.200
     0.361     0.444     0.200
     0.409    -0.161     0.200
     0.527    -0.421     0.200
     0.621    -0.690     0.200
     0.650     0.359     0.200
     0.744     0.679     0.200
     0.731    -0.352     0.200
     0.848     0.527     0.200
     0.865    -0.798     0.200
     0.913     0.493     0.200
     0.277     0.187     0.200
     0.310    -0.827     0.200
     0.358    -0.358     0.200
     0.420    -0.190     0.200
     0.485    -0.562     0.200
     0.483    -0.629     0.200
     0.486     0.486     0.200
     0.602    -0.117     0.200
     0.705    -0.348     0.200
     0.815     0.360     0.200
     0.872    -0.344     0.200
     0.943    -0.855     0.200
     0.976    -1.042     0.200
     0.986     0.285     0.200
     0.149    -0.185     0.200
     0.220    -1.172     0.200
     0.296    -0.582     0.200
     0.348     0.070     0.200
     0.444     0.367     0.200
     0.470     0.278     0.200
     0.543     0.349     0.200
     0.633    -0.358     0.200
     0.630    -0.292     0.200
     0.733    -0.828     0.200
     0.767    -0.648     0.200
     0.752     0.011     0.200
     0.772    -0.535     0.200
     0.157     0.011     0.200
     0.184    -0.316     0.200
     0.267    -0.482     0.200
     0.282    -0.710     0.200
     0.391    -0.258     0.200
     0.437    -0.074     0.200
     0.489     1.154     0.200
     0.506    -0.559     0.200
     0.527    -0.173     0.200
     0.536     0.396     0.200
     0.560    -0.174     0.200
     0.642     0.606     0.200
     0.676    -0.606     0.200
     0.685     0.116     0.200
     0.702    -0.210     0.200
     0.712    -0.498     0.200
     0.735     0.564     0.200
     0.782    -0.213     0.200
     0.974     0.683     0.200
     0.028    -1.160     0.200
     0.200     1.021     0.200
     0.248     0.539     0.200
     0.341     0.269     0.200
     0.383     0.690     0.200
     0.480    -0.093     0.200
     0.453     0.640     0.200
     0.530    -0.178     0.200
     0.546    -0.192     0.200
     0.543     0.453     0.200
     0.640     0.266     0.200
     0.641     0.049     0.200
     0.700    -0.743     0.200
     0.777    -0.307     0.200
     0.789    -0.328     0.200
     0.788    -0.600     0.200
     0.801    -0.345     0.200
     0.920    -0.360     0.200
     0.938    -0.254     0.200
     0.948    -0.332     0.200
     0.944    -0.302     0.200
     0.227    -0.047     0.200
     0.257    -0.303     0.200
     0.414    -0.344     0.200
     0.414     0.031     0.200
     0.447    -0.566     0.200
     0.517    -0.067     0.200
     0.512    -0.267     0.200
     0.547     1.165     0.200
     0.557     0.102     0.200
     0.571     0.206     0.200
     0.584    -0.322     0.200
     0.589    -0.217     0.200
     0.604     0.294     0.200
     0.649    -0.239     0.200
     0.751    -0.680     0.200
     0.798     0.410     0.200
     0.848     0.069     0.200
     0.867    -0.293     0.200
     0.896     0.755     0.200
     0.891    -0.230     0.200
     0.918     0.219     0.200
     0.931    -1.591     0.200
     0.963     0.082     0.200
     0.989     0.783     0.200
     0.162     1.219     0.200
     0.289    -0.600     0.200
     0.475    -0.426     0.200
     0.519    -0.324     0.200
     0.582    -1.209     0.200
     0.539     0.312     0.200
     0.600     0.252     0.200
     0.633     0.921     0.200
     0.650    -0.388     0.200
     0.638     0.538     0.200
     0.806    -1.255     0.200
     0.855     0.531     0.200
     0.912     0.535     0.200
     0.951    -0.401     0.200
     0.946    -0.439     0.200
     0.906    -1.249     0.200
     0.995     0.145     0.200
     0.085    -0.422     0.200
     0.170    -0.206     0.200
     0.217    -0.940     0.200
     0.188    -0.019     0.200
     0.270     0.189     0.200
     0.270     0.838     0.200
     0.350    -0.044     0.200
     0.362    -0.027     0.200
     0.424    -0.642     0.200
     0.420    -0.262     0.200
     0.634    -0.004     0.200
     0.608    -0.114     0.200
     0.637    -0.068     0.200
     0.646     0.067     0.200
     0.672    -0.216     0.200
     0.770    -0.858     0.200
     0.770     0.047     0.200
     0.772     0.180     0.200
     0.836    -0.210     0.200
     0.840    -0.184     0.200
     0.857    -0.802     0.200
     0.920    -0.858     0.200
     0.057    -0.356     0.200
     0.140    -0.327     0.200
     0.178    -0.279     0.200
     0.238    -0.631     0.200
     0.309    -0.027     0.200
     0.332     0.106     0.200
     0.350     0.937     0.200
     0.373     0.000     0.200
     0.456    -0.016     0.200
     0.457     1.732     0.200
     0.503    -0.392     0.200
     0.604    -0.507     0.200
     0.623     0.025     0.200
     0.667    -0.210     0.200
     0.744    -0.272     0.200
     0.863    -0.936     0.200
     0.854    -0.164     0.200
     0.223    -0.515     0.200
     0.189     0.812     0.200
     0.415    -0.607     0.200
     0.432     0.704     0.200
     0.466    -0.690     0.200
     0.503     0.074     0.200
     0.560    -0.725     0.200
     0.561    -0.038     0.200
     0.609     0.561     0.200
     0.627     0.721     0.200
     0.705     0.538     0.200
     0.721     0.016     0.200
     0.771    -0.020     0.200
     0.860     0.064     0.200
     0.245     0.461     0.200
     0.342    -0.081     0.200
     0.427    -0.295     0.200
     0.491    -0.165     0.200
     0.550    -0.694     0.200
     0.640    -0.296     0.200
     0.655    -0.163     0.200
     0.682    -0.059     0.200
     0.721     0.241     0.200
     0.748     0.634     0.200
     0.766     0.058     0.200
     0.793    -0.587     0.200
     0.862     0.268     0.200
     0.882    -0.399     0.200
     0.908    -0.352     0.200
     0.898     0.196     0.200
     0.952     0.496     0.200
     0.257     0.537     0.200
     0.323     0.453     0.200
     0.417    -0.037     0.200
     0.494     0.115     0.200
     0.545    -0.559     0.200
     0.639     0.112     0.200
     0.667     0.089     0.200
     0.689    -0.137     0.200
     0.710    -0.555     0.200
     0.778    -0.195     0.200
     0.810    -0.640     0.200
     0.867    -0.367     0.200
     0.879     0.169     0.200
     0.921     0.168     0.200
     0.108     0.044     0.200
     0.271     0.179     0.200
     0.345     0.447     0.200
     0.331     0.310     0.200
     0.408     0.569     0.200
     0.340     0.815     0.200
     0.563    -0.276     0.200
     0.548    -0.079     0.200
     0.585    -0.881     0.200
     0.656    -1.123     0.200
     0.702    -0.511     0.200
     0.743     0.217     0.200
     0.720     1.054     0.200
     0.759     0.208     0.200
     0.898     0.475     0.200
     0.913     0.383     0.200
     0.934    -1.019     0.200
     0.924    -0.826     0.200
     0.207     0.838     0.200
     0.294    -0.059     0.200
     0.445    -0.473     0.200
     0.485    -0.506     0.200
     0.482     0.362     0.200
     0.538     0.006     0.200
     0.583    -0.554     0.200
     0.602     0.988     0.200
     0.598     0.565     0.200
     0.619     0.164     0.200
     0.642     0.331     0.200
     0.648     0.118     0.200
     0.834     0.368     0.200
     0.818    -0.819     0.200
     0.818    -0.624     0.200
     0.899     0.251     0.200
     0.928    -0.417     0.200
     0.893    -0.449     0.200
     0.956    -1.059     0.200
     0.187     0.488     0.200
     0.187     0.621     0.200
     0.472    -1.785     0.200
     0.468    -0.189     0.200
     0.561    -1.160     0.200
     0.611    -0.014     0.200
     0.634    -0.462     0.200
     0.667    -0.393     0.200
     0.814    -0.784     0.200
     0.804    -0.503     0.200
     0.804    -0.809     0.200
     0.869    -1.052     0.200
     0.915     0.581     0.200
     0.945    -0.203     0.200
     0.980     0.118     0.200
     0.830    -0.375     0.200
     0.938     0.334     0.200
     0.970    -0.063     0.200
     0.550     0.170     0.200
     0.597    -0.099     0.200
     0.582     0.278     0.200
     0.665     0.049     0.200
     0.665     0.038     0.200
     0.974    -0.118     0.200
     0.991     0.379     0.200
     0.229     0.707     0.200
     0.510     0.719     0.200
     0.635     0.282     0.200
     0.662     0.138     0.200
     0.780     0.433     0.200
     0.830     0.137     0.200
     0.899     0.107     0.200
     0.976     0.576     0.200
     0.714     1.363     0.200
     0.880    -0.195     0.200
     0.234    -0.896     0.200
     0.213     0.055     0.200
     0.301    -0.438     0.200
     0.439     0.079     0.200
     0.445     0.311     0.200
     0.471     0.075     0.200
     0.491    -0.400     0.200
     0.590    -0.014     0.200
     0.648     0.201     0.200
     0.787     0.321     0.200
     0.808    -0.430     0.200
     0.886    -0.453     0.200
     0.963    -0.739     0.200
     0.198    -0.156     0.200
     0.247    -1.393     0.200
     0.305    -0.647     0.200
     0.497    -0.558     0.200
     0.475     0.939     0.200
     0.548     0.893     0.200
     0.586    -0.415     0.200
     0.596    -0.338     0.200
     0.605    -1.877     0.200
     0.614     1.250     0.200
     0.654    -0.104     0.200
     0.798     0.843     0.200
     0.882    -1.269     0.200
     0.967     0.401     0.200
     0.262     0.020     0.200
     0.098    -0.948     0.200
     0.282    -0.258     0.200
     0.145    -0.311     0.200
     0.143     0.481     0.200
     0.262     0.116     0.200
     0.262     0.339     0.200
     0.428    -0.793     0.200
     0.313     0.034     0.200
     0.404     0.367     0.200
     0.646    -0.108     0.200
     0.796    -0.233     0.200
     0.650     0.502     0.200
     0.613    -0.498     0.200
     0.654    -0.672     0.200
     0.565    -0.083     0.200
     0.773    -0.193     0.200
     0.933    -1.452     0.200
     0.874    -1.204     0.200
     0.822    -0.423     0.200
     0.931    -0.221     0.200
     0.824    -0.056     0.200
     0.989    -0.514     0.200
     0.985     0.530     0.200
     0.094    -0.286     0.200
     0.150     0.033     0.200
     0.156     0.602     0.200
     0.249    -1.429     0.200
     0.265     0.406     0.200
     0.277     0.037     0.200
     0.323    -0.067     0.200
     0.425    -0.684     0.200
     0.413     0.247     0.200
     0.577    -0.012     0.200
     0.618    -0.301     0.200
     0.640    -0.607     0.200
     0.658    -0.344     0.200
     0.650    -0.003     0.200
     0.773     0.378     0.200
     0.824    -0.592     0.200
     0.827    -0.441     0.200
     0.870    -1.163     0.200
     0.926    -1.029     0.200
     0.996    -0.867     0.200
     0.994     0.271     0.200
     0.093    -0.352     0.200
     0.154     0.027     0.200
     0.169     0.557     0.200
     0.237    -1.444     0.200
     0.275     0.262     0.200
     0.270     0.597     0.200
     0.331    -0.004     0.200
     0.420    -0.394     0.200
     0.422     1.077     0.200
     0.588    -0.092     0.200
     0.634    -0.261     0.200
     0.622    -0.147     0.200
     0.652    -0.216     0.200
     0.659    -0.048     0.200
     0.825    -0.577     0.200
     0.868    -0.903     0.200
     0.914    -0.265     0.200
     0.920     0.017     0.200
     0.283    -0.527     0.200
     0.337    -0.345     0.200
     0.479    -0.670     0.200
     0.493    -0.122     0.200
     0.468     0.647     0.200
     0.611    -0.012     0.200
     0.611     0.209     0.200
     0.663    -0.777     0.200
     0.661    -0.053     0.200
     0.729    -0.344     0.200
     0.821    -0.905     0.200
     0.875    -1.539     0.200
     0.794     1.272     0.200
     0.794     0.442     0.200
     0.794     1.003     0.200
     0.119    -0.473     0.200
     0.168     0.075     0.200
     0.226    -0.712     0.200
     0.264    -0.615     0.200
     0.362     0.182     0.200
     0.357     1.170     0.200
     0.395     0.210     0.200
     0.438     0.276     0.200
     0.455     0.121     0.200
     0.447    -0.327     0.200
     0.459    -0.350     0.200
     0.562    -0.155     0.200
     0.563    -0.084     0.200
     0.603     0.259     0.200
     0.727    -0.748     0.200
     0.748    -0.542     0.200
     0.815    -0.116     0.200
     0.151    -0.565     0.200
     0.192    -0.435     0.200
     0.192    -0.123     0.200
     0.299    -0.435     0.200
     0.345    -0.116     0.200
     0.369    -0.430     0.200
     0.384     1.079     0.200
     0.425    -0.625     0.200
     0.460    -0.269     0.200
     0.473    -0.484     0.200
     0.473     0.043     0.200
     0.533    -0.212     0.200
     0.537    -0.068     0.200
     0.566     0.464     0.200
     0.638     0.422     0.200
     0.692    -0.861     0.200
     0.733    -0.327     0.200
     0.194    -0.401     0.200
     0.197     0.042     0.200
     0.291    -0.475     0.200
     0.360     0.428     0.200
     0.383     0.520     0.200
     0.370     1.234     0.200
     0.445    -0.089     0.200
     0.481     0.057     0.200
     0.469    -0.473     0.200
     0.547    -0.373     0.200
     0.551    -0.340     0.200
     0.532     1.554     0.200
     0.552     0.819     0.200
     0.649    -0.564     0.200
     0.630    -0.440     0.200
     0.697    -0.473     0.200
     0.748    -0.331     0.200
     0.730     1.086     0.200
     0.847    -0.515     0.200
     0.170    -0.004     0.200
     0.215    -0.804     0.200
     0.282    -0.511     0.200
     0.343     0.123     0.200
     0.374     0.475     0.200
     0.377     0.393     0.200
     0.446    -0.241     0.200
     0.452    -0.040     0.200
     0.453    -0.107     0.200
     0.464    -0.565     0.200
     0.541     0.007     0.200
     0.543    -0.425     0.200
     0.532     1.020     0.200
     0.560     0.630     0.200
     0.621     0.092     0.200
     0.712    -0.698     0.200
     0.729    -0.431     0.200
     0.825    -0.249     0.200
     0.122    -0.432     0.200
     0.141    -0.538     0.200
     0.174    -0.014     0.200
     0.210    -0.491     0.200
     0.285    -0.337     0.200
     0.344     0.121     0.200
     0.373     0.093     0.200
     0.378     0.792     0.200
     0.442    -0.267     0.200
     0.456     0.284     0.200
     0.457     0.128     0.200
     0.463    -0.243     0.200
     0.540    -0.582     0.200
     0.542     0.083     0.200
     0.534     1.085     0.200
     0.561     0.111     0.200
     0.624    -0.170     0.200
     0.708    -0.648     0.200
     0.731    -0.568     0.200
     0.829    -0.145     0.200
     0.120    -0.502     0.200
     0.180    -0.198     0.200
     0.204    -0.796     0.200
     0.290    -0.296     0.200
     0.343    -0.065     0.200
     0.381    -0.066     0.200
     0.436    -0.388     0.200
     0.461    -0.451     0.200
     0.462     0.694     0.200
     0.463    -1.079     0.200
     0.537     0.616     0.200
     0.538     1.367     0.200
     0.563     0.911     0.200
     0.629     0.368     0.200
     0.703    -0.619     0.200
     0.738     1.193     0.200
     0.146    -0.390     0.200
     0.183    -1.039     0.200
     0.212     0.142     0.200
     0.300    -0.663     0.200
     0.367     0.323     0.200
     0.386     0.274     0.200
     0.371     0.240     0.200
     0.416    -0.375     0.200
     0.438    -0.795     0.200
     0.480     0.002     0.200
     0.495    -0.155     0.200
     0.548    -0.146     0.200
     0.552     0.170     0.200
     0.536     0.743     0.200
     0.551     0.674     0.200
     0.638    -0.162     0.200
     0.755    -0.467     0.200
     0.859     0.238     0.200
     0.928    -0.264     0.200
     0.107    -0.484     0.200
     0.164    -0.292     0.200
     0.182    -0.745     0.200
     0.199     0.151     0.200
     0.312    -0.295     0.200
     0.336     0.268     0.200
     0.358    -0.118     0.200
     0.396    -0.238     0.200
     0.414     0.055     0.200
     0.469    -0.569     0.200
     0.477    -0.113     0.200
     0.486     0.578     0.200
     0.521    -0.264     0.200
     0.525    -0.330     0.200
     0.557     0.437     0.200
     0.577     0.269     0.200
     0.643    -0.858     0.200
     0.651     0.478     0.200
     0.680    -0.549     0.200
     0.725    -0.503     0.200
     0.857    -0.037     0.200
     0.113    -0.788     0.200
     0.174     0.073     0.200
     0.150    -0.340     0.200
     0.207    -0.673     0.200
     0.334     0.041     0.200
     0.292    -0.288     0.200
     0.364     0.196     0.200
     0.388     0.047     0.200
     0.438    -0.300     0.200
     0.454     0.122     0.200
     0.462     0.026     0.200
     0.531    -0.133     0.200
     0.533    -0.167     0.200
     0.543     1.799     0.200
     0.570     0.699     0.200
     0.631    -0.050     0.200
     0.721    -0.560     0.200
     0.111    -0.286     0.200
     0.201    -0.588     0.200
     0.153    -0.185     0.200
     0.180     0.033     0.200
     0.335     0.123     0.200
     0.363     0.109     0.200
     0.297    -0.363     0.200
     0.432    -0.304     0.200
     0.389     0.693     0.200
     0.460    -0.025     0.200
     0.528    -0.135     0.200
     0.531    -0.382     0.200
     0.468    -0.211     0.200
     0.471    -0.438     0.200
     0.546     0.904     0.200
     0.572     0.726     0.200
     0.662    -0.487     0.200
     0.636    -0.296     0.200
     0.697    -0.850     0.200
     0.722    -0.541     0.200
     0.793    -0.893     0.200
     0.747    -0.016     0.200
     0.942     0.061     0.200
     0.070    -0.152     0.200
     0.150    -0.729     0.200
     0.201    -0.372     0.200
     0.283    -0.060     0.200
     0.282    -0.252     0.200
     0.318    -0.032     0.200
     0.350     0.112     0.200
     0.326     0.075     0.200
     0.408    -0.007     0.200
     0.438     1.256     0.200
     0.517    -0.028     0.200
     0.524     0.031     0.200
     0.538    -0.226     0.200
     0.564    -0.218     0.200
     0.559     1.844     0.200
     0.603    -0.266     0.200
     0.619     0.819     0.200
     0.650    -0.444     0.200
     0.782    -0.969     0.200
     0.771     0.447     0.200
     0.119    -0.597     0.200
     0.149    -0.292     0.200
     0.191    -0.019     0.200
     0.194    -0.661     0.200
     0.346     0.012     0.200
     0.370     0.275     0.200
     0.383     0.230     0.200
     0.426    -0.162     0.200
     0.459    -0.967     0.200
     0.472     0.005     0.200
     0.535    -0.084     0.200
     0.538    -0.140     0.200
     0.542    -1.056     0.200
     0.564     1.151     0.200
     0.636     0.494     0.200
     0.694    -0.871     0.200
     0.733    -0.525     0.200
     0.122    -0.544     0.200
     0.141    -0.641     0.200
     0.171    -0.158     0.200
     0.213    -0.519     0.200
     0.284    -0.373     0.200
     0.342     0.195     0.200
     0.373     0.155     0.200
     0.379     0.635     0.200
     0.445    -0.155     0.200
     0.453     0.109     0.200
     0.455    -0.073     0.200
     0.465    -0.313     0.200
     0.540    -0.107     0.200
     0.542    -0.138     0.200
     0.534     0.859     0.200
     0.561     0.574     0.200
     0.622    -0.171     0.200
     0.673    -0.692     0.200
     0.710    -0.806     0.200
     0.729    -0.458     0.200
     0.735    -0.090     0.200
     0.804    -0.576     0.200
     0.121    -0.330     0.200
     0.143    -0.400     0.200
     0.175     0.012     0.200
     0.209    -0.317     0.200
     0.287    -0.246     0.200
     0.343     0.151     0.200
     0.372     0.228     0.200
     0.380     0.675     0.200
     0.441    -0.137     0.200
     0.457    -0.039     0.200
     0.459    -0.109     0.200
     0.464    -0.357     0.200
     0.538    -0.065     0.200
     0.541    -0.101     0.200
     0.536     1.048     0.200
     0.562     0.678     0.200
     0.625    -0.221     0.200
     0.706    -0.825     0.200
     0.730    -0.468     0.200
     0.737    -0.214     0.200
     0.931     0.900     0.200
     0.111    -0.551     0.200
     0.154    -0.449     0.200
     0.198    -0.825     0.200
     0.183    -0.106     0.200
     0.299    -0.480     0.200
     0.336     0.158     0.200
     0.362     0.080     0.200
     0.390    -0.943     0.200
     0.429    -0.158     0.200
     0.463     0.029     0.200
     0.470    -0.205     0.200
     0.471    -0.061     0.200
     0.528    -0.004     0.200
     0.530    -0.144     0.200
     0.547     1.296     0.200
     0.572     0.953     0.200
     0.638    -0.192     0.200
     0.694    -0.946     0.200
     0.723    -0.498     0.200
     0.153    -0.153     0.200
     0.174    -0.202     0.200
     0.147    -0.304     0.200
     0.231    -0.261     0.200
     0.304    -0.098     0.200
     0.385     0.242     0.200
     0.400     0.272     0.200
     0.362     1.150     0.200
     0.407    -0.958     0.200
     0.421     0.289     0.200
     0.488    -0.091     0.200
     0.516    -0.174     0.200
     0.559     0.108     0.200
     0.565    -0.596     0.200
     0.531     1.387     0.200
     0.620    -0.729     0.200
     0.640     0.161     0.200
     0.682    -1.009     0.200
     0.773    -0.338     0.200
     0.159    -0.156     0.200
     0.134     0.291     0.200
     0.187    -0.751     0.200
     0.223     0.086     0.200
     0.291    -0.099     0.200
     0.352     0.483     0.200
     0.389    -0.311     0.200
     0.408     0.353     0.200
     0.420    -0.072     0.200
     0.416     0.305     0.200
     0.475     0.457     0.200
     0.509     0.045     0.200
     0.520     1.612     0.200
     0.568     0.428     0.200
     0.573     0.131     0.200
     0.628    -0.417     0.200
     0.695    -0.878     0.200
     0.147    -0.448     0.200
     0.115     0.002     0.200
     0.166     0.112     0.200
     0.230    -0.266     0.200
     0.259     0.134     0.200
     0.365     0.115     0.200
     0.353     1.018     0.200
     0.398     0.001     0.200
     0.463    -0.111     0.200
     0.445    -1.470     0.200
     0.434    -0.195     0.200
     0.453     0.079     0.200
     0.508     1.111     0.200
     0.565    -0.344     0.200
     0.567    -0.669     0.200
     0.598     0.523     0.200
     0.732    -0.691     0.200
     0.710    -0.279     0.200
     0.750    -0.443     0.200
     0.811    -0.303     0.200
     0.143    -0.605     0.200
     0.137    -0.564     0.200
     0.191    -0.865     0.200
     0.207    -0.130     0.200
     0.291    -0.423     0.200
     0.371     0.233     0.200
     0.363     0.987     0.200
     0.393     0.851     0.200
     0.424    -0.322     0.200
     0.433    -0.286     0.200
     0.471    -0.116     0.200
     0.492    -0.260     0.200
     0.527     1.036     0.200
     0.555    -0.158     0.200
     0.560     0.366     0.200
     0.628    -0.247     0.200
     0.696    -1.408     0.200
     0.724     0.070     0.200
     0.760    -0.502     0.200
     0.919     0.261     0.200
     0.137    -0.243     0.200
     0.195    -0.013     0.200
     0.135    -0.264     0.200
     0.199    -0.150     0.200
     0.286    -0.261     0.200
     0.364    -0.065     0.200
     0.388     0.289     0.200
     0.365     0.796     0.200
     0.432    -0.119     0.200
     0.464     0.050     0.200
     0.442    -0.197     0.200
     0.552    -0.172     0.200
     0.556    -0.134     0.200
     0.527     1.064     0.200
     0.527     0.916     0.200
     0.547     0.809     0.200
     0.625    -0.057     0.200
     0.652    -0.557     0.200
     0.702    -1.005     0.200
     0.751    -0.443     0.200
     0.725    -0.155     0.200
     0.785    -0.676     0.200
     0.063    -1.192     0.200
     0.285     0.119     0.200
     0.285     0.013     0.200
     0.469    -0.086     0.200
     0.646    -0.091     0.200
     0.681    -0.038     0.200
     0.238    -0.604     0.200
     0.240    -0.385     0.200
     0.243    -0.094     0.200
     0.266    -0.337     0.200
     0.320    -0.333     0.200
     0.350     0.010     0.200
     0.406    -0.035     0.200
     0.410     0.358     0.200
     0.556    -0.075     0.200
     0.567     0.057     0.200
     0.579     0.033     0.200
     0.605     0.333     0.200
     0.629    -0.712     0.200
     0.654    -0.463     0.200
     0.758     1.537     0.200
     0.869    -0.631     0.200
     0.937    -0.202     0.200
     0.120    -0.173     0.200
     0.146    -0.492     0.200
     0.181    -0.050     0.200
     0.217    -0.320     0.200
     0.269     0.011     0.200
     0.368    -0.147     0.200
     0.355     0.191     0.200
     0.397    -0.069     0.200
     0.450    -0.332     0.200
     0.439    -0.628     0.200
     0.446    -0.205     0.200
     0.468     0.048     0.200
     0.513     0.452     0.200
     0.537     0.829     0.200
     0.563     0.457     0.200
     0.566    -0.187     0.200
     0.608     0.200     0.200
     0.720    -1.391     0.200
     0.755    -0.352     0.200
     0.825    -0.292     0.200
     0.206    -0.528     0.200
     0.242    -0.595     0.200
     0.404    -0.425     0.200
     0.404    -0.417     0.200
     0.396     0.430     0.200
     0.453    -0.324     0.200
     0.515     0.949     0.200
     0.581    -0.049     0.200
     0.700    -0.775     0.200
     0.719    -0.975     0.200
     0.702    -0.513     0.200
     0.818    -1.304     0.200
     0.794    -0.144     0.200
     0.866     1.777     0.200
     0.866     1.582     0.200
     0.908     0.418     0.200
     0.126    -0.414     0.200
     0.165    -0.775     0.200
     0.195    -1.003     0.200
     0.220    -0.275     0.200
     0.283     0.152     0.200
     0.344    -0.660     0.200
     0.395    -0.144     0.200
     0.410     0.111     0.200
     0.427    -0.301     0.200
     0.508     0.054     0.200
     0.511     1.825     0.200
     0.523    -0.360     0.200
     0.576    -0.100     0.200
     0.581    -0.086     0.200
     0.619     0.269     0.200
     0.703    -0.358     0.200
     0.706    -1.228     0.200
     0.783    -0.329     0.200
     0.088    -0.039     0.200
     0.198    -0.307     0.200
     0.183     0.109     0.200
     0.209     0.366     0.200
     0.258     0.641     0.200
     0.277    -0.329     0.200
     0.277     0.370     0.200
     0.366    -0.116     0.200
     0.422    -0.993     0.200
     0.382     0.230     0.200
     0.449     0.448     0.200
     0.444    -0.286     0.200
     0.628     0.124     0.200
     0.627    -0.155     0.200
     0.647    -0.343     0.200
     0.647    -0.633     0.200
     0.771     0.432     0.200
     0.791    -0.570     0.200
     0.841    -0.401     0.200
     0.846    -0.085     0.200
     0.851    -0.490     0.200
     0.893    -0.681     0.200
     0.914    -1.244     0.200
     0.898    -0.358     0.200
     0.181    -0.630     0.200
     0.152    -0.703     0.200
     0.208    -0.008     0.200
     0.357     0.085     0.200
     0.414    -0.256     0.200
     0.304    -0.563     0.200
     0.379     0.470     0.200
     0.539    -0.195     0.200
     0.543     0.022     0.200
     0.448    -0.892     0.200
     0.490    -0.268     0.200
     0.637    -0.936     0.200
     0.543     0.543     0.200
     0.543     0.691     0.200
     0.684    -0.934     0.200
     0.745    -0.496     0.200
     0.642    -0.568     0.200
     0.769    -1.046     0.200
     0.740    -0.610     0.200
     0.936    -0.527     0.200
     0.269    -0.747     0.200
     0.357    -0.726     0.200
     0.369    -0.509     0.200
     0.369    -0.661     0.200
     0.477    -0.231     0.200
     0.488    -0.133     0.200
     0.476     0.484     0.200
     0.512     0.306     0.200
     0.508     0.172     0.200
     0.611     0.409     0.200
     0.606    -0.287     0.200
     0.686     0.076     0.200
     0.701    -0.228     0.200
     0.802    -0.156     0.200
     0.824    -0.171     0.200
     0.911    -0.546     0.200
     0.926    -0.434     0.200
     0.942    -0.529     0.200
     0.110     0.021     0.200
     0.152    -0.509     0.200
     0.191     0.364     0.200
     0.224    -1.028     0.200
     0.287     0.665     0.200
     0.294     0.593     0.200
     0.336    -0.066     0.200
     0.399    -0.363     0.200
     0.397    -0.419     0.200
     0.450     0.526     0.200
     0.473    -0.092     0.200
     0.610    -0.026     0.200
     0.616    -0.253     0.200
     0.600    -0.043     0.200
     0.671     0.023     0.200
     0.749    -0.946     0.200
     0.812    -0.039     0.200
     0.816    -0.915     0.200
     0.783     0.100     0.200
     0.795    -0.106     0.200
     0.896    -0.818     0.200
     0.880    -0.425     0.200
     0.922     0.037     0.200
     0.998    -0.455     0.200
     0.495    -0.599     0.200
     0.487     0.157     0.200
     0.591    -0.945     0.200
     0.571     0.345     0.200
     0.627     0.064     0.200
     0.648    -0.634     0.200
     0.653    -0.724     0.200
     0.635    -0.288     0.200
     0.672    -0.590     0.200
     0.697     0.630     0.200
     0.801    -0.111     0.200
     0.832    -0.262     0.200
     0.821    -0.352     0.200
     0.822    -0.158     0.200
     0.852     0.456     0.200
     0.895    -0.259     0.200
     0.948    -0.781     0.200
     0.870    -0.492     0.200
     0.982    -0.730     0.200
     0.343     0.540     0.200
     0.616    -0.194     0.200
     0.633     0.867     0.200
     0.659     0.278     0.200
     0.728     0.284     0.200
     0.732     0.004     0.200
     0.822     0.607     0.200
     0.920     0.009     0.200
     0.925     0.177     0.200
     0.925    -0.174     0.200
     0.558     0.231     0.200
     0.627     0.622     0.200
     0.665    -0.267     0.200
     0.739     0.714     0.200
     0.764     1.060     0.200
     0.784     0.942     0.200
     0.924    -0.430     0.200
     0.964    -1.788     0.200
     0.945     0.386     0.200
     0.996    -1.012     0.200
     0.983     0.341     0.200
     0.114    -0.521     0.200
     0.195    -0.399     0.200
     0.153    -0.594     0.200
     0.188    -0.398     0.200
     0.340     0.059     0.200
     0.365     0.118     0.200
     0.403    -0.551     0.200
     0.427    -0.090     0.200
     0.299    -0.529     0.200
     0.387     0.306     0.200
     0.530    -0.008     0.200
     0.468    -0.042     0.200
     0.465    -0.594     0.200
     0.472    -0.176     0.200
     0.655    -0.932     0.200
     0.546     1.139     0.200
     0.546     0.857     0.200
     0.693    -0.749     0.200
     0.569     0.550     0.200
     0.728    -0.313     0.200
     0.638    -0.347     0.200
     0.786    -0.513     0.200
     0.746     0.941     0.200
     0.845    -0.546     0.200
     0.941     0.234     0.200
     0.241     0.451     0.200
     0.424     0.687     0.200
     0.504    -0.541     0.200
     0.518     0.340     0.200
     0.610    -0.208     0.200
     0.633     0.260     0.200
     0.672     0.417     0.200
     0.692     0.334     0.200
     0.729    -0.255     0.200
     0.745    -0.660     0.200
     0.799    -0.615     0.200
     0.812    -0.950     0.200
     0.847    -0.489     0.200
     0.877    -0.790     0.200
     0.875    -0.135     0.200
     0.894    -0.877     0.200
     0.196    -0.414     0.200
     0.346    -0.170     0.200
     0.324     0.342     0.200
     0.399    -0.201     0.200
     0.405     0.799     0.200
     0.444     0.059     0.200
     0.478    -0.287     0.200
     0.515    -0.898     0.200
     0.566    -0.682     0.200
     0.673     0.072     0.200
     0.686     0.240     0.200
     0.689     0.074     0.200
     0.731    -0.425     0.200
     0.754     0.438     0.200
     0.738     0.340     0.200
     0.738     0.135     0.200
     0.776    -0.296     0.200
     0.891     0.295     0.200
     0.872    -0.527     0.200
     0.074    -0.857     0.200
     0.079    -1.440     0.200
     0.239    -0.315     0.200
     0.265    -1.614     0.200
     0.471     0.506     0.200
     0.505    -0.113     0.200
     0.617     0.751     0.200
     0.678    -0.356     0.200
     0.706    -0.506     0.200
     0.749     0.400     0.200
     0.859     0.260     0.200
     0.861    -0.600     0.200
     0.319     0.655     0.200
     0.350     1.362     0.200
     0.578     0.250     0.200
     0.638    -1.200     0.200
     0.651    -0.643     0.200
     0.721    -0.445     0.200
     0.729    -0.989     0.200
     0.765    -0.270     0.200
     0.822    -0.457     0.200
     0.116    -0.616     0.200
     0.151    -0.277     0.200
     0.188     0.135     0.200
     0.196     0.026     0.200
     0.297    -0.235     0.200
     0.343     0.048     0.200
     0.368    -0.008     0.200
     0.406    -0.591     0.200
     0.385     1.071     0.200
     0.428    -0.213     0.200
     0.469    -0.366     0.200
     0.471    -0.151     0.200
     0.463    -0.259     0.200
     0.533    -0.383     0.200
     0.536    -0.036     0.200
     0.566     0.869     0.200
     0.636    -0.048     0.200
     0.655    -0.686     0.200
     0.694    -1.130     0.200
     0.730    -0.216     0.200
     0.743    -0.067     0.200
     0.844    -0.681     0.200
     0.117     0.911     0.200
     0.305     0.177     0.200
     0.368     0.045     0.200
     0.437     0.410     0.200
     0.493    -0.053     0.200
     0.555     0.003     0.200
     0.553     0.589     0.200
     0.633     0.229     0.200
     0.646     0.078     0.200
     0.630     0.988     0.200
     0.773    -0.737     0.200
     0.823     0.033     0.200
     0.922     0.323     0.200
     0.926     0.273     0.200
     0.960    -0.864     0.200
     0.960    -0.970     0.200
     0.963    -0.332     0.200
     0.131     0.379     0.200
     0.286     0.113     0.200
     0.349     0.416     0.200
     0.475    -0.593     0.200
     0.534     0.698     0.200
     0.543    -0.237     0.200
     0.617     0.673     0.200
     0.627     0.289     0.200
     0.671     0.353     0.200
     0.691    -0.139     0.200
     0.762    -0.371     0.200
     0.816    -0.594     0.200
     0.909     0.334     0.200
     0.919     0.366     0.200
     0.958     0.148     0.200
     0.959    -0.357     0.200
     0.971    -0.255     0.200
     0.307    -0.181     0.200
     0.383    -0.298     0.200
     0.491    -0.225     0.200
     0.543     0.093     0.200
     0.564     0.280     0.200
     0.628     0.186     0.200
     0.649    -0.036     0.200
     0.653     0.407     0.200
     0.705     0.207     0.200
     0.721     0.104     0.200
     0.761    -0.259     0.200
     0.794     0.111     0.200
     0.805    -0.096     0.200
     0.862     0.733     0.200
     0.817    -0.221     0.200
     0.913     0.232     0.200
     0.909     0.118     0.200
     0.982    -0.276     0.200
     0.983    -0.180     0.200
     0.183    -0.091     0.200
     0.284    -0.565     0.200
     0.457    -0.288     0.200
     0.478    -0.495     0.200
     0.507    -0.166     0.200
     0.552     0.297     0.200
     0.560    -0.264     0.200
     0.615    -0.317     0.200
     0.633     0.497     0.200
     0.674    -0.476     0.200
     0.792     0.807     0.200
     0.843    -0.254     0.200
     0.844    -0.259     0.200
     0.891     0.220     0.200
     0.905    -0.754     0.200
     0.906    -0.620     0.200
     0.928     0.508     0.200
     0.944    -0.549     0.200
     0.106    -0.440     0.200
     0.271    -0.164     0.200
     0.333     0.170     0.200
     0.346     0.137     0.200
     0.340     0.202     0.200
     0.407     0.297     0.200
     0.400     0.787     0.200
     0.563    -1.326     0.200
     0.583     0.130     0.200
     0.650    -0.034     0.200
     0.744     0.392     0.200
     0.758    -0.664     0.200
     0.899    -0.331     0.200
     0.914    -0.222     0.200
     0.925    -0.439     0.200
     0.117    -0.579     0.200
     0.150    -0.574     0.200
     0.184    -0.164     0.200
     0.217    -0.366     0.200
     0.267    -0.153     0.200
     0.373     0.217     0.200
     0.350     1.025     0.200
     0.402     0.318     0.200
     0.440    -0.945     0.200
     0.450     0.058     0.200
     0.433    -0.039     0.200
     0.445     0.094     0.200
     0.471     0.076     0.200
     0.509     0.122     0.200
     0.532     0.729     0.200
     0.568     0.096     0.200
     0.570     0.249     0.200
     0.606     0.167     0.200
     0.721    -0.964     0.200
     0.760    -0.303     0.200
     0.825    -0.385     0.200
     0.904    -0.500     0.200
     0.193    -0.525     0.200
     0.243    -0.032     0.200
     0.261    -0.078     0.200
     0.403     0.016     0.200
     0.449    -0.301     0.200
     0.499     0.484     0.200
     0.500     0.670     0.200
     0.574     0.018     0.200
     0.593    -0.252     0.200
     0.607     0.577     0.200
     0.836    -0.421     0.200
     0.927    -0.472     0.200
     0.215    -0.399     0.200
     0.234     0.882     0.200
     0.296     0.248     0.200
     0.483    -0.210     0.200
     0.512     0.147     0.200
     0.468     0.685     0.200
     0.571     1.129     0.200
     0.570     0.068     0.200
     0.600     0.202     0.200
     0.627     0.289     0.200
     0.641     0.418     0.200
     0.771     0.444     0.200
     0.804     0.220     0.200
     0.804    -0.483     0.200
     0.893    -0.666     0.200
     0.198    -0.297     0.200
     0.269    -0.451     0.200
     0.321    -1.473     0.200
     0.368    -0.860     0.200
     0.372    -0.132     0.200
     0.373     0.257     0.200
     0.536    -0.659     0.200
     0.615    -0.028     0.200
     0.662     0.467     0.200
     0.731    -0.639     0.200
     0.738    -0.138     0.200
     0.195     0.354     0.200
     0.277     0.088     0.200
     0.335     0.082     0.200
     0.404    -0.085     0.200
     0.404     0.007     0.200
     0.426    -0.022     0.200
     0.554    -0.392     0.200
     0.607     0.908     0.200
     0.696    -0.268     0.200
     0.700     0.246     0.200
     0.763    -0.934     0.200
     0.828    -0.264     0.200
     0.810    -0.230     0.200
     0.841    -0.511     0.200
     0.943    -0.848     0.200
     0.948    -0.060     0.200
     0.196    -0.300     0.200
     0.272    -0.347     0.200
     0.380     0.061     0.200
     0.380     0.247     0.200
     0.360    -1.197     0.200
     0.419    -0.268     0.200
     0.541    -0.453     0.200
     0.612     0.441     0.200
     0.671    -0.222     0.200
     0.744    -0.535     0.200
     0.723    -0.651     0.200
     0.717    -0.377     0.200
     0.829    -1.121     0.200
     0.852    -0.682     0.200
     0.810     0.217     0.200
     0.930     0.755     0.200
     0.931    -0.338     0.200
     0.200    -0.287     0.200
     0.268    -0.150     0.200
     0.380    -1.065     0.200
     0.361     0.583     0.200
     0.360     0.194     0.200
     0.413    -0.082     0.200
     0.530    -0.097     0.200
     0.618     0.678     0.200
     0.650     0.562     0.200
     0.704    -0.332     0.200
     0.743    -0.492     0.200
     0.728    -0.488     0.200
     0.845    -0.697     0.200
     0.862    -0.651     0.200
     0.915    -0.386     0.200
     0.921    -0.367     0.200
     0.046    -0.404     0.200
     0.255     0.827     0.200
     0.256     0.521     0.200
     0.411    -0.043     0.200
     0.448     0.375     0.200
     0.450     0.862     0.200
     0.613    -0.643     0.200
     0.599     0.093     0.200
     0.595     0.176     0.200
     0.628    -0.216     0.200
     0.712    -0.571     0.200
     0.750    -0.607     0.200
     0.839    -0.833     0.200
     0.844    -0.856     0.200
     0.853     0.512     0.200
     0.863    -0.139     0.200
     0.955    -0.512     0.200
     0.998    -0.158     0.200
     0.994    -0.522     0.200
     0.142    -0.669     0.200
     0.167    -0.355     0.200
     0.296     0.440     0.200
     0.307     0.372     0.200
     0.357    -0.199     0.200
     0.362     0.278     0.200
     0.444    -0.295     0.200
     0.515    -0.127     0.200
     0.490     0.919     0.200
     0.502     0.274     0.200
     0.532     0.847     0.200
     0.570     0.127     0.200
     0.599    -0.092     0.200
     0.662     0.396     0.200
     0.662     0.646     0.200
     0.687    -0.176     0.200
     0.698     0.125     0.200
     0.786     0.272     0.200
     0.786     0.074     0.200
     0.791     0.070     0.200
     0.796    -0.109     0.200
     0.909    -0.361     0.200
     0.956    -0.791     0.200
     0.996    -0.478     0.200
     0.136    -0.242     0.200
     0.146     0.591     0.200
     0.232     0.908     0.200
     0.362    -0.093     0.200
     0.436    -0.080     0.200
     0.474     1.580     0.200
     0.500     0.278     0.200
     0.525    -0.260     0.200
     0.554     0.591     0.200
     0.561     0.149     0.200
     0.579     0.219     0.200
     0.674     0.101     0.200
     0.698    -0.353     0.200
     0.686     0.075     0.200
     0.788     0.246     0.200
     0.807     1.486     0.200
     0.807     0.886     0.200
     0.908    -0.144     0.200
     0.981     0.039     0.200
     0.310     0.219     0.200
     0.291     0.626     0.200
     0.291     0.727     0.200
     0.370    -0.011     0.200
     0.359    -0.083     0.200
     0.359    -0.282     0.200
     0.453    -0.614     0.200
     0.495     0.584     0.200
     0.498     0.109     0.200
     0.498     0.410     0.200
     0.514    -0.168     0.200
     0.519     1.032     0.200
     0.570     0.073     0.200
     0.607    -0.310     0.200
     0.686    -0.216     0.200
     0.700     0.229     0.200
     0.795     0.044     0.200
     0.788     0.266     0.200
     0.776     0.702     0.200
     0.776     0.204     0.200
     0.904    -0.130     0.200
     0.958    -0.571     0.200
     1.000    -0.807     0.200
     0.129    -0.922     0.200
     0.152    -0.048     0.200
     0.303     0.487     0.200
     0.305     0.604     0.200
     0.354    -0.212     0.200
     0.350     0.316     0.200
     0.431    -0.312     0.200
     0.483     0.687     0.200
     0.516    -0.295     0.200
     0.508     0.403     0.200
     0.549     0.776     0.200
     0.586    -0.013     0.200
     0.570     0.182     0.200
     0.689    -0.350     0.200
     0.695     0.238     0.200
     0.678     0.302     0.200
     0.678     0.462     0.200
     0.795    -0.049     0.200
     0.797    -0.066     0.200
     0.800     0.173     0.200
     0.800    -0.127     0.200
     0.916    -0.172     0.200
     0.954    -0.489     0.200
     0.990    -0.520     0.200
     0.195     0.527     0.200
     0.241     0.108     0.200
     0.238    -0.056     0.200
     0.433     0.024     0.200
     0.438     0.071     0.200
     0.503     0.188     0.200
     0.554    -0.359     0.200
     0.560    -0.784     0.200
     0.550     0.426     0.200
     0.559     0.746     0.200
     0.587     0.983     0.200
     0.597    -0.601     0.200
     0.642    -0.407     0.200
     0.725    -0.158     0.200
     0.766     0.724     0.200
     0.818    -0.215     0.200
     0.852    -0.436     0.200
     0.895    -0.552     0.200
     0.926    -0.276     0.200
     0.944    -0.125     0.200
     0.948    -0.451     0.200
     0.957    -0.306     0.200
     0.144    -0.747     0.200
     0.160    -1.044     0.200
     0.177    -1.234     0.200
     0.301    -0.359     0.200
     0.356     1.087     0.200
     0.392    -0.082     0.200
     0.409    -0.315     0.200
     0.407     0.119     0.200
     0.414    -0.794     0.200
     0.486     0.422     0.200
     0.520    -0.383     0.200
     0.527    -0.734     0.200
     0.535     1.000     0.200
     0.565     0.605     0.200
     0.571    -0.300     0.200
     0.619    -1.115     0.200
     0.637     0.097     0.200
     0.685    -0.847     0.200
     0.719    -0.337     0.200
     0.753    -0.337     0.200
     0.916     0.063     0.200
     0.089    -1.178     0.200
     0.083    -1.018     0.200
     0.254     0.361     0.200
     0.508     0.076     0.200
     0.650     0.095     0.200
     0.654     0.536     0.200
     0.734     0.495     0.200
     0.812     1.435     0.200
     0.829    -0.335     0.200
     0.916     0.453     0.200
     0.991     0.053     0.200
     0.131    -0.548     0.200
     0.131    -0.649     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.589    -0.223     0.200
     0.957     0.529     0.200
     0.902    -1.558     0.200
     0.732    -0.615     0.200
     0.643    -0.337     0.200
     0.576    -0.319     0.200
     0.747    -1.179     0.200
     0.984    -0.108     0.200
     0.975    -1.550     0.200
     0.893    -1.310     0.200
     0.951    -0.326     0.200
     0.869     0.632     0.200
     0.900     0.929     0.200
     0.777    -0.568     0.200
     0.905    -0.334     0.200
     0.863    -0.117     0.200
     0.618    -0.223     0.200
     0.747     0.017     0.200
     0.792    -1.147     0.200
     0.875     0.128     0.200
     0.906     0.063     0.200
     0.952    -0.002     0.200
     0.847    -0.479     0.200
     0.600     0.186     0.200
     0.740     0.257     0.200
     0.860     0.547     0.200
     0.888     0.424     0.200
     0.934     0.265     0.200
     0.959     0.809     0.200
     0.992     0.579     0.200
     0.756    -1.254     0.200
     0.951    -0.834     0.200
     0.745    -1.595     0.200
     0.930     0.221     0.200
     0.943    -0.240     0.200
     0.921    -0.999     0.200
     0.921    -0.452     0.200
     0.599    -0.883     0.200
     0.592    -0.954     0.200
     0.757    -0.639     0.200
     0.809    -0.433     0.200
     0.816    -0.562     0.200
     0.862    -0.349     0.200
     0.929     0.053     0.200
     0.971     0.357     0.200
     0.978    -0.619     0.200
     0.902    -0.272     0.200
     0.939     0.001     0.200
     0.967     0.203     0.200
     0.500    -0.571     0.200
     0.509    -0.300     0.200
     0.735     0.055     0.200
     0.790    -0.199     0.200
     0.865     0.345     0.200
     0.867    -0.177     0.200
     0.875    -0.154     0.200
     0.882     0.115     0.200
     0.952     0.267     0.200
     0.959     0.112     0.200
     0.986     0.831     0.200
     0.667    -0.262     0.200
     0.815    -0.992     0.200
     0.815    -1.732     0.200
     0.794     0.577     0.200
     0.955     0.069     0.200
     0.927     0.496     0.200
     0.993    -0.072     0.200
     0.938    -0.865     0.200
     0.743    -0.344     0.200
     0.806    -1.083     0.200
     0.923    -0.010     0.200
     0.840    -1.267     0.200
     0.832    -0.191     0.200
     0.870    -1.096     0.200
     0.940     0.189     0.200
     0.957    -0.998     0.200
     0.512     0.753     0.200
     0.518    -0.373     0.200
     0.678     0.062     0.200
     0.768     0.473     0.200
     0.780     0.901     0.200
     0.817     0.645     0.200
     0.779    -0.383     0.200
     0.856    -0.141     0.200
     0.918     0.517     0.200
     0.969    -0.080     0.200
     0.907    -0.485     0.200
     0.853    -1.071     0.200
     0.853    -1.251     0.200
     0.853    -0.860     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.892     0.693     0.200
     0.417     0.455     0.200
     0.417     0.304     0.200
     0.693     0.401     0.200
     0.881    -0.130     0.200
     0.464     0.623     0.200
     0.561     0.974     0.200
     0.622     0.417     0.200
     0.746     0.407     0.200
     0.180     1.098     0.200
     0.211     0.666     0.200
     0.432    -0.110     0.200
     0.768     0.061     0.200
     0.987     0.377     0.200
     0.485    -0.001     0.200
     0.602     0.848     0.200
     0.634     0.510     0.200
     0.943     1.231     0.200
     0.149     1.000     0.200
     0.296     0.454     0.200
     0.630     0.984     0.200
     0.733    -0.475     0.200
     0.767     0.082     0.200
     0.752     0.999     0.200
     0.772     0.654     0.200
     0.905     0.911     0.200
     0.157     0.196     0.200
     0.184    -0.143     0.200
     0.267    -0.758     0.200
     0.282    -1.060     0.200
     0.391    -0.019     0.200
     0.437     0.260     0.200
     0.506    -1.048     0.200
     0.527     0.671     0.200
     0.536    -0.716     0.200
     0.642     0.739     0.200
     0.685     0.256     0.200
     0.702    -0.307     0.200
     0.712    -0.729     0.200
     0.735    -0.287     0.200
     0.028    -1.009     0.200
     0.227     0.573     0.200
     0.257    -0.974     0.200
     0.414     1.228     0.200
     0.414     0.103     0.200
     0.447    -0.877     0.200
     0.085     0.594     0.200
     0.217    -0.566     0.200
     0.270     0.404     0.200
     0.634     1.137     0.200
     0.646     1.053     0.200
     0.857     0.670     0.200
     0.920    -0.177     0.200
     0.057     0.447     0.200
     0.140     0.324     0.200
     0.178     0.005     0.200
     0.238     0.193     0.200
     0.332     0.289     0.200
     0.373     0.750     0.200
     0.503     0.652     0.200
     0.604     0.535     0.200
     0.667    -0.355     0.200
     0.744    -0.381     0.200
     0.223    -1.001     0.200
     0.189     1.459     0.200
     0.503     0.317     0.200
     0.627     0.840     0.200
     0.245     0.474     0.200
     0.342    -0.658     0.200
     0.427    -0.662     0.200
     0.491    -0.444     0.200
     0.550    -1.448     0.200
     0.640    -0.285     0.200
     0.655    -0.232     0.200
     0.682     0.030     0.200
     0.721     0.448     0.200
     0.766     0.490     0.200
     0.793    -0.359     0.200
     0.862     0.744     0.200
     0.323     0.379     0.200
     0.494    -0.194     0.200
     0.545    -1.049     0.200
     0.667    -0.159     0.200
     0.689    -0.488     0.200
     0.867     0.843     0.200
     0.108     0.185     0.200
     0.271    -0.186     0.200
     0.331     0.238     0.200
     0.408    -1.158     0.200
     0.656    -0.592     0.200
     0.207     2.015     0.200
     0.294    -0.315     0.200
     0.445     0.070     0.200
     0.485    -0.607     0.200
     0.482     1.606     0.200
     0.538    -0.225     0.200
     0.583    -0.319     0.200
     0.598     0.901     0.200
     0.648     0.563     0.200
     0.786    -0.170     0.200
     0.834    -0.605     0.200
     0.818     0.451     0.200
     0.858     0.316     0.200
     0.899     0.007     0.200
     0.893    -1.017     0.200
     0.187     0.535     0.200
     0.319     0.490     0.200
     0.472    -0.348     0.200
     0.468     0.898     0.200
     0.511     0.570     0.200
     0.561     1.233     0.200
     0.611     0.869     0.200
     0.634     0.214     0.200
     0.667    -1.085     0.200
     0.814    -0.013     0.200
     0.804    -0.104     0.200
     0.856     0.544     0.200
     0.682    -1.321     0.200
     0.800     0.379     0.200
     0.938    -0.467     0.200
     0.970    -0.810     0.200
     0.371     0.642     0.200
     0.550    -0.249     0.200
     0.597    -1.272     0.200
     0.582    -0.472     0.200
     0.665    -0.448     0.200
     0.665    -0.266     0.200
     0.974    -0.445     0.200
     0.229     0.015     0.200
     0.510    -0.240     0.200
     0.635    -0.928     0.200
     0.643    -0.354     0.200
     0.662     0.095     0.200
     0.780     0.373     0.200
     0.830    -0.735     0.200
     0.899    -0.444     0.200
     0.964    -0.865     0.200
     0.945     0.601     0.200
     0.937     1.289     0.200
     0.213     0.122     0.200
     0.445     0.258     0.200
     0.471     1.275     0.200
     0.491    -0.263     0.200
     0.808    -0.086     0.200
     0.886    -0.919     0.200
     0.198    -0.845     0.200
     0.305    -1.062     0.200
     0.497    -0.216     0.200
     0.475     1.653     0.200
     0.586    -0.380     0.200
     0.605    -0.488     0.200
     0.614    -0.279     0.200
     0.629     0.157     0.200
     0.967     0.110     0.200
     0.098     0.557     0.200
     0.262     0.651     0.200
     0.646     0.270     0.200
     0.650     1.420     0.200
     0.613     0.836     0.200
     0.565     1.508     0.200
     0.931    -0.163     0.200
     0.094     1.253     0.200
     0.249    -1.184     0.200
     0.323     1.106     0.200
     0.577     1.382     0.200
     0.640     0.606     0.200
     0.658     1.329     0.200
     0.650     1.569     0.200
     0.824     0.365     0.200
     0.926    -0.784     0.200
     0.996     0.022     0.200
     0.093     1.599     0.200
     0.237    -0.204     0.200
     0.479     0.364     0.200
     0.493     0.147     0.200
     0.661     0.525     0.200
     0.794     0.143     0.200
     0.168     0.048     0.200
     0.264    -0.790     0.200
     0.395     0.266     0.200
     0.455     0.073     0.200
     0.447     0.640     0.200
     0.459     0.155     0.200
     0.603    -0.380     0.200
     0.748    -0.786     0.200
     0.192    -0.761     0.200
     0.345     0.840     0.200
     0.369     0.318     0.200
     0.425     0.593     0.200
     0.460    -0.023     0.200
     0.473     0.298     0.200
     0.197    -0.707     0.200
     0.360     0.734     0.200
     0.383     0.523     0.200
     0.427     0.363     0.200
     0.445    -0.200     0.200
     0.481    -0.542     0.200
     0.649    -0.740     0.200
     0.630    -0.058     0.200
     0.748    -0.777     0.200
     0.847    -0.720     0.200
     0.170     0.434     0.200
     0.215     0.365     0.200
     0.282    -0.758     0.200
     0.374     0.348     0.200
     0.377     1.617     0.200
     0.446     0.264     0.200
     0.452     0.179     0.200
     0.532     0.493     0.200
     0.621     0.424     0.200
     0.729    -0.500     0.200
     0.122    -0.060     0.200
     0.141    -0.427     0.200
     0.210    -0.105     0.200
     0.285     0.135     0.200
     0.373     0.713     0.200
     0.442     0.327     0.200
     0.456     0.083     0.200
     0.463    -0.124     0.200
     0.540     0.279     0.200
     0.829    -0.589     0.200
     0.600    -0.080     0.200
     0.740    -0.204     0.200
     0.860    -0.307     0.200
     0.888    -0.511     0.200
     0.934    -0.858     0.200
     0.959     0.244     0.200
     0.992    -0.461     0.200
     0.120     0.053     0.200
     0.180    -0.016     0.200
     0.204    -0.553     0.200
     0.290     0.156     0.200
     0.436     0.470     0.200
     0.461     0.463     0.200
     0.462     0.483     0.200
     0.463     0.123     0.200
     0.731     0.032     0.200
     0.146     0.621     0.200
     0.183     1.412     0.200
     0.212    -0.233     0.200
     0.300     0.210     0.200
     0.367    -0.889     0.200
     0.386    -1.102     0.200
     0.416     0.245     0.200
     0.480    -0.160     0.200
     0.164     0.007     0.200
     0.469    -0.375     0.200
     0.477    -0.131     0.200
     0.113     0.222     0.200
     0.174    -0.210     0.200
     0.292     0.471     0.200
     0.438     0.653     0.200
     0.454     0.766     0.200
     0.721     0.161     0.200
     0.111     0.662     0.200
     0.335     1.455     0.200
     0.363     1.369     0.200
     0.297     0.394     0.200
     0.432     0.880     0.200
     0.460     0.692     0.200
     0.471     0.121     0.200
     0.662    -0.198     0.200
     0.697    -0.459     0.200
     0.722     0.096     0.200
     0.070     0.141     0.200
     0.150    -0.444     0.200
     0.283     0.526     0.200
     0.282    -0.063     0.200
     0.650    -0.317     0.200
     0.119    -0.211     0.200
     0.149     0.012     0.200
     0.191     0.911     0.200
     0.194    -0.120     0.200
     0.370     0.872     0.200
     0.426     0.784     0.200
     0.459     0.925     0.200
     0.694    -0.605     0.200
     0.141    -0.310     0.200
     0.171     0.162     0.200
     0.284    -0.143     0.200
     0.445     0.370     0.200
     0.465     0.149     0.200
     0.622     0.335     0.200
     0.710    -1.014     0.200
     0.143    -0.723     0.200
     0.175     0.328     0.200
     0.287    -0.150     0.200
     0.441     0.516     0.200
     0.464     0.275     0.200
     0.706    -0.840     0.200
     0.111     0.115     0.200
     0.154    -0.238     0.200
     0.429     0.479     0.200
     0.463     0.596     0.200
     0.470     0.370     0.200
     0.174    -0.125     0.200
     0.147    -0.480     0.200
     0.231    -0.030     0.200
     0.159     0.117     0.200
     0.134    -0.121     0.200
     0.187    -0.732     0.200
     0.223    -0.233     0.200
     0.291    -0.326     0.200
     0.352     0.934     0.200
     0.389    -0.782     0.200
     0.408    -0.972     0.200
     0.420     0.636     0.200
     0.416     0.768     0.200
     0.475     0.081     0.200
     0.509     0.119     0.200
     0.207     0.243     0.200
     0.291    -0.123     0.200
     0.424     0.613     0.200
     0.433     0.527     0.200
     0.471     0.527     0.200
     0.642    -0.418     0.200
     0.760    -0.369     0.200
     0.137     0.240     0.200
     0.195     0.421     0.200
     0.135     0.473     0.200
     0.199    -0.693     0.200
     0.527     0.073     0.200
     0.285     0.623     0.200
     0.285     0.814     0.200
     0.469    -0.129     0.200
     0.599     0.641     0.200
     0.592     0.586     0.200
     0.646     0.562     0.200
     0.240    -1.095     0.200
     0.243    -0.314     0.200
     0.266    -0.573     0.200
     0.320    -0.319     0.200
     0.350     0.431     0.200
     0.410     0.818     0.200
     0.556     0.158     0.200
     0.567     0.943     0.200
     0.579     0.352     0.200
     0.629     0.135     0.200
     0.654    -0.942     0.200
     0.120    -0.047     0.200
     0.146    -0.561     0.200
     0.181    -0.069     0.200
     0.397     1.330     0.200
     0.450     0.564     0.200
     0.608     0.227     0.200
     0.755    -0.753     0.200
     0.206     0.940     0.200
     0.242     1.257     0.200
     0.404     0.626     0.200
     0.404     0.640     0.200
     0.453     0.683     0.200
     0.700     0.584     0.200
     0.126    -0.623     0.200
     0.165    -0.275     0.200
     0.195    -0.618     0.200
     0.283     0.450     0.200
     0.395     0.470     0.200
     0.410     1.434     0.200
     0.427     0.399     0.200
     0.508     0.091     0.200
     0.576     0.129     0.200
     0.703    -0.245     0.200
     0.783     0.046     0.200
     0.088     1.251     0.200
     0.198     0.402     0.200
     0.183     0.081     0.200
     0.209     1.520     0.200
     0.258     0.693     0.200
     0.277     0.669     0.200
     0.277     0.794     0.200
     0.382     0.990     0.200
     0.444     1.051     0.200
     0.628     0.754     0.200
     0.627    -0.315     0.200
     0.647    -0.259     0.200
     0.757    -0.444     0.200
     0.791    -0.005     0.200
     0.846     0.390     0.200
     0.893    -0.279     0.200
     0.914    -0.490     0.200
     0.898    -0.206     0.200
     0.181    -0.060     0.200
     0.152     0.136     0.200
     0.208     0.765     0.200
     0.357     1.709     0.200
     0.414     0.684     0.200
     0.304     0.155     0.200
     0.543    -0.308     0.200
     0.448     0.078     0.200
     0.490     0.130     0.200
     0.637    -0.167     0.200
     0.684    -0.618     0.200
     0.745     0.265     0.200
     0.642     0.602     0.200
     0.769    -0.408     0.200
     0.740     0.619     0.200
     0.186    -0.242     0.200
     0.269     0.343     0.200
     0.357    -0.275     0.200
     0.369     1.087     0.200
     0.477     0.775     0.200
     0.508    -0.783     0.200
     0.611    -0.784     0.200
     0.606     0.592     0.200
     0.686    -0.851     0.200
     0.152     0.309     0.200
     0.191     1.430     0.200
     0.224    -0.634     0.200
     0.294     0.186     0.200
     0.336     0.711     0.200
     0.399     0.371     0.200
     0.397     0.045     0.200
     0.610     0.854     0.200
     0.616     0.544     0.200
     0.600    -0.437     0.200
     0.749     0.413     0.200
     0.795     0.225     0.200
     0.896    -0.648     0.200
     0.495    -0.122     0.200
     0.517    -0.926     0.200
     0.487     1.201     0.200
     0.591    -2.161     0.200
     0.635     1.101     0.200
     0.832    -1.140     0.200
     0.821     0.729     0.200
     0.822     1.118     0.200
     0.852     0.653     0.200
     0.982     0.044     0.200
     0.616    -0.097     0.200
     0.633    -0.574     0.200
     0.659     0.377     0.200
     0.920     0.100     0.200
     0.665     1.156     0.200
     0.983     1.163     0.200
     0.114    -0.369     0.200
     0.195     0.201     0.200
     0.188     0.030     0.200
     0.340     1.271     0.200
     0.365     1.401     0.200
     0.403     0.333     0.200
     0.427     0.281     0.200
     0.299    -0.195     0.200
     0.530     0.062     0.200
     0.468    -0.329     0.200
     0.465    -0.138     0.200
     0.472     0.695     0.200
     0.655    -0.071     0.200
     0.693    -0.710     0.200
     0.728    -0.663     0.200
     0.638    -0.260     0.200
     0.786    -0.666     0.200
     0.845    -0.631     0.200
     0.845    -1.002     0.200
     0.941     0.266     0.200
     0.241     0.595     0.200
     0.424     0.696     0.200
     0.504     0.148     0.200
     0.518     0.348     0.200
     0.610    -0.069     0.200
     0.633    -0.134     0.200
     0.672     0.181     0.200
     0.683    -0.657     0.200
     0.692     0.224     0.200
     0.729    -0.569     0.200
     0.847    -0.733     0.200
     0.875    -0.279     0.200
     0.196    -0.411     0.200
     0.346     0.414     0.200
     0.324     0.747     0.200
     0.399     1.313     0.200
     0.444     0.600     0.200
     0.515    -0.866     0.200
     0.566    -0.166     0.200
     0.673    -0.695     0.200
     0.686    -0.081     0.200
     0.689    -0.890     0.200
     0.872     0.149     0.200
     0.074    -0.514     0.200
     0.079    -0.680     0.200
     0.239     0.344     0.200
     0.265     0.863     0.200
     0.471     0.965     0.200
     0.505     0.480     0.200
     0.617     0.767     0.200
     0.319     0.952     0.200
     0.350     1.445     0.200
     0.578     0.013     0.200
     0.638    -0.452     0.200
     0.651     0.629     0.200
     0.721    -0.619     0.200
     0.765    -0.109     0.200
     0.822    -0.985     0.200
     0.116    -0.314     0.200
     0.188     0.658     0.200
     0.196     0.317     0.200
     0.297     1.269     0.200
     0.343     1.255     0.200
     0.368     0.457     0.200
     0.406    -0.040     0.200
     0.385     1.325     0.200
     0.428     0.440     0.200
     0.469     0.325     0.200
     0.471     0.610     0.200
     0.463     0.815     0.200
     0.636     0.514     0.200
     0.655    -0.070     0.200
     0.694    -0.958     0.200
     0.730    -0.646     0.200
     0.844    -0.905     0.200
     0.117     1.033     0.200
     0.305    -0.465     0.200
     0.437    -0.099     0.200
     0.493    -0.814     0.200
     0.555    -0.520     0.200
     0.553     0.881     0.200
     0.773    -0.695     0.200
     0.823    -0.305     0.200
     0.926     0.402     0.200
     0.963    -0.836     0.200
     0.131     0.274     0.200
     0.286    -0.539     0.200
     0.349    -0.548     0.200
     0.436    -0.447     0.200
     0.475    -0.628     0.200
     0.543     0.079     0.200
     0.627     0.555     0.200
     0.816    -0.356     0.200
     0.958     0.020     0.200
     0.959    -0.087     0.200
     0.971    -1.024     0.200
     0.307    -0.277     0.200
     0.383    -0.173     0.200
     0.416     0.780     0.200
     0.491    -0.598     0.200
     0.543     0.111     0.200
     0.564     0.270     0.200
     0.628    -0.681     0.200
     0.653     0.688     0.200
     0.761    -0.105     0.200
     0.805    -0.644     0.200
     0.817    -0.522     0.200
     0.909     0.524     0.200
     0.982    -0.582     0.200
     0.983    -0.491     0.200
     0.183    -1.166     0.200
     0.284    -0.892     0.200
     0.457     0.180     0.200
     0.478     0.065     0.200
     0.507     0.758     0.200
     0.552     0.721     0.200
     0.560    -1.153     0.200
     0.602     0.295     0.200
     0.615    -0.361     0.200
     0.674     0.713     0.200
     0.792    -0.391     0.200
     0.844     0.037     0.200
     0.106     0.259     0.200
     0.271     0.188     0.200
     0.333     0.226     0.200
     0.346     0.022     0.200
     0.340     0.553     0.200
     0.407    -0.137     0.200
     0.563     0.021     0.200
     0.583    -0.096     0.200
     0.650    -1.699     0.200
     0.744    -0.861     0.200
     0.925    -0.519     0.200
     0.150    -0.553     0.200
     0.184    -0.139     0.200
     0.217     0.338     0.200
     0.373     0.505     0.200
     0.350     1.512     0.200
     0.402     0.032     0.200
     0.440    -0.721     0.200
     0.450     0.738     0.200
     0.433     0.564     0.200
     0.445     0.331     0.200
     0.471     0.172     0.200
     0.509     0.423     0.200
     0.532     0.416     0.200
     0.568     0.101     0.200
     0.570     0.015     0.200
     0.606     0.771     0.200
     0.721    -0.803     0.200
     0.760    -0.132     0.200
     0.825    -0.272     0.200
     0.193    -0.589     0.200
     0.243     0.209     0.200
     0.261     0.525     0.200
     0.403     1.208     0.200
     0.499     1.375     0.200
     0.574    -0.513     0.200
     0.593     0.549     0.200
     0.927    -0.860     0.200
     0.215     0.110     0.200
     0.234     1.462     0.200
     0.296    -0.175     0.200
     0.483    -0.400     0.200
     0.512     0.052     0.200
     0.468     0.906     0.200
     0.570    -0.121     0.200
     0.600     0.002     0.200
     0.627     0.415     0.200
     0.269     1.766     0.200
     0.368     0.193     0.200
     0.536     0.838     0.200
     0.195     1.626     0.200
     0.277    -0.591     0.200
     0.404    -0.236     0.200
     0.763    -0.332     0.200
     0.272     0.898     0.200
     0.541     1.044     0.200
     0.744     0.505     0.200
     0.717     0.976     0.200
     0.268    -1.037     0.200
     0.380    -0.058     0.200
     0.530     0.812     0.200
     0.704     0.605     0.200
     0.046     0.138     0.200
     0.411     1.106     0.200
     0.601     0.116     0.200
     0.613    -0.061     0.200
     0.599     0.057     0.200
     0.595     1.285     0.200
     0.628     0.038     0.200
     0.680     0.877     0.200
     0.839    -0.285     0.200
     0.844     0.511     0.200
     0.871     0.219     0.200
     0.142    -0.068     0.200
     0.167    -0.438     0.200
     0.296     0.361     0.200
     0.357     0.746     0.200
     0.362    -0.449     0.200
     0.444     0.781     0.200
     0.515     0.587     0.200
     0.502    -0.628     0.200
     0.532     0.123     0.200
     0.570     0.879     0.200
     0.599    -0.837     0.200
     0.662     0.969     0.200
     0.687     1.050     0.200
     0.698    -0.497     0.200
     0.786     0.643     0.200
     0.796     1.226     0.200
     0.909    -0.067     0.200
     0.996     0.107     0.200
     0.136     0.427     0.200
     0.146     1.039     0.200
     0.362     0.406     0.200
     0.436    -0.797     0.200
     0.474     0.324     0.200
     0.525    -0.105     0.200
     0.554     0.140     0.200
     0.579    -0.574     0.200
     0.674     0.066     0.200
     0.807     0.523     0.200
     0.908     0.784     0.200
     0.310     0.555     0.200
     0.291     0.273     0.200
     0.359    -0.039     0.200
     0.359     0.863     0.200
     0.495    -0.310     0.200
     0.519     0.799     0.200
     0.570     0.040     0.200
     0.607    -0.653     0.200
     0.651     0.100     0.200
     0.700     0.891     0.200
     0.776     0.126     0.200
     0.958     0.091     0.200
     1.000    -0.139     0.200
     0.129    -0.878     0.200
     0.303     1.114     0.200
     0.305     1.563     0.200
     0.354     0.832     0.200
     0.516     0.379     0.200
     0.508     1.204     0.200
     0.586     0.187     0.200
     0.570     1.017     0.200
     0.689     1.335     0.200
     0.695    -0.760     0.200
     0.678     0.899     0.200
     0.797    -0.267     0.200
     0.800     0.329     0.200
     0.800     0.128     0.200
     0.954     0.162     0.200
     0.195     0.575     0.200
     0.433    -0.471     0.200
     0.438     0.359     0.200
     0.503    -0.498     0.200
     0.642     0.204     0.200
     0.725    -0.153     0.200
     0.957    -0.489     0.200
     0.144    -0.404     0.200
     0.160    -0.170     0.200
     0.177    -0.322     0.200
     0.234     0.545     0.200
     0.301    -0.261     0.200
     0.356     1.629     0.200
     0.392     0.361     0.200
     0.409     0.234     0.200
     0.407     0.795     0.200
     0.414     0.798     0.200
     0.486     0.393     0.200
     0.520    -0.338     0.200
     0.527    -0.723     0.200
     0.565     0.629     0.200
     0.571     0.390     0.200
     0.637     0.191     0.200
     0.719     0.689     0.200
     0.753    -0.304     0.200
     0.254     0.345     0.200
     0.508    -0.736     0.200
     0.524    -0.894     0.200
     0.650    -0.214     0.200
     0.654     0.006     0.200
     0.131    -0.595     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.732    -1.605     0.200
     0.643    -1.094     0.200
     0.576    -0.737     0.200
     0.618    -0.905     0.200
     0.747    -0.455     0.200
     0.991    -0.649     0.200
     0.798    -0.724     0.200
     0.936    -0.288     0.200
     0.874    -0.789     0.200
     0.989    -0.668     0.200
     0.870    -0.983     0.200
     0.681    -0.433     0.200
     0.862     1.293     0.200
     0.971     1.101     0.200
     0.978    -0.096     0.200
     0.851    -0.347     0.200
     0.880    -0.446     0.200
     0.998    -0.675     0.200
     0.732    -2.263     0.200
     0.678    -0.680     0.200
     0.706    -0.752     0.200
     0.749    -0.535     0.200
     0.859     0.008     0.200
     0.861    -0.702     0.200
     0.500    -1.299     0.200
     0.509    -0.541     0.200
     0.735     0.444     0.200
     0.790    -0.363     0.200
     0.865     0.066     0.200
     0.867    -0.266     0.200
     0.875    -0.322     0.200
     0.952    -0.361     0.200
     0.959    -0.030     0.200
     0.986     0.146     0.200
     0.667    -1.188     0.200
     0.815    -2.907     0.200
     0.815    -2.738     0.200
     0.794     0.048     0.200
     0.955    -1.111     0.200
     0.927    -0.409     0.200
     0.960    -0.786     0.200
     0.960    -0.895     0.200
     0.919    -0.836     0.200
     0.905    -0.702     0.200
     0.906    -0.422     0.200
     0.928     0.439     0.200
     0.743    -0.031     0.200
     0.931     0.350     0.200
     0.750    -1.052     0.200
     0.853    -0.955     0.200
     0.863    -0.456     0.200
     0.998    -0.228     0.200
     0.916    -0.850     0.200
     0.780    -0.327     0.200
     0.872     0.596     0.200
     0.512     0.437     0.200
     0.518    -1.173     0.200
     0.678    -0.196     0.200
     0.768     0.723     0.200
     0.779    -1.218     0.200
     0.856    -0.771     0.200
     0.918     1.041     0.200
     0.907    -1.135     0.200
     0.991     0.549     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.042
 0.70   -0.042
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00   -0.265
 0.70   -0.265
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.2
 0.70    0.2
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.7
 0.70   -0.7
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.7)
     0.050     7.000   Pg = red x; average =  -0.0 (solid red line)
     0.050     5.000   Pn = green x; average =  -0.3 (solid green line)
     0.050    -7.500   Sg = red circles; average =   0.2 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.7 (dashed green line)
EOF
gmt end
