#!/bin/bash
gmt begin bandung1.79_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic bandung1.79'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.471
   135.500     1.553
   136.000     1.638
   136.500     1.726
   137.000     1.818
   137.500     1.913
   138.000     2.011
   138.500     2.113
   139.000     2.218
   139.500     2.327
   140.000     2.439
   140.500     2.556
   141.000     2.678
   141.500     2.803
   142.000     2.933
   142.500     3.068
   143.000     3.208
   143.500     3.354
   144.000     3.504
   144.500     3.661
   145.000     3.823
   145.500     3.991
   146.000     4.166
   146.500     4.348
   147.000     4.536
   147.500     4.732
   148.000     4.935
   148.500     5.146
   149.000     5.366
   149.500     5.594
   150.000     5.832
   150.500     6.080
   151.000     6.339
   151.500     6.608
   152.000     6.886
   152.500     7.175
   153.000     7.474
   153.500     7.784
   154.000     8.104
   154.500     8.435
   155.000     8.777
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.675
   145.500     0.290
   146.000     1.317
   146.500     2.387
   147.000     3.492
   147.500     4.626
   148.000     5.788
   148.500     6.974
   149.000     8.185
   149.500     9.418
   150.000    10.673
   150.500    11.949
   151.000    13.246
   151.500    14.562
   152.000    15.898
   152.500    17.251
   153.000    18.623
   153.500    20.012
   154.000    21.419
   154.500    22.844
   155.000    24.286
   155.500    25.744
   156.000    27.220
   156.500    28.712
   157.000    30.221
   157.500    31.747
   158.000    33.289
   158.500    34.848
   159.000    36.423
   159.500    38.015
   160.000    39.623
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.679
   145.500     0.085
   146.000     0.777
   146.500     1.418
   147.000     2.016
   147.500     2.576
   148.000     3.100
   148.500     3.592
   149.000     4.058
   149.500     4.503
   150.000     4.933
   150.500     5.350
   151.000     5.757
   151.500     6.154
   152.000     6.542
   152.500     6.923
   153.000     7.299
   153.500     7.670
   154.000     8.039
   154.500     8.405
   155.000     8.770
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   135.065     0.214     0.200
   135.126     0.116     0.200
   135.162    -0.124     0.200
   135.210    -0.056     0.200
   135.207    -0.036     0.200
   135.244    -0.113     0.200
   135.323    -0.198     0.200
   135.323    -1.229     0.200
   135.451    -0.077     0.200
   135.540     0.024     0.200
   135.542     0.167     0.200
   135.577    -0.124     0.200
   135.582     0.093     0.200
   135.696     0.006     0.200
   135.772     0.013     0.200
   135.961     0.083     0.200
   135.978     0.224     0.200
   135.998     0.256     0.200
   135.967     0.282     0.200
   136.020     0.270     0.200
   136.049     0.060     0.200
   136.040     0.101     0.200
   136.298    -0.215     0.200
   136.349    -0.036     0.200
   136.439    -0.126     0.200
   136.448    -0.625     0.200
   136.545    -0.134     0.200
   136.571    -0.049     0.200
   136.732     0.168     0.200
   136.836     0.202     0.200
   136.843     0.016     0.200
   136.850     0.190     0.200
   136.883     0.185     0.200
   137.103     0.340     0.200
   137.103    -0.332     0.200
   137.217     0.340     0.200
   137.238     0.333     0.200
   137.285     0.067     0.200
   137.298     0.253     0.200
   137.672     0.361     0.200
   137.762     0.116     0.200
   137.779     0.312     0.200
   137.790     0.228     0.200
   137.947     0.541     0.200
   138.002     0.269     0.200
   138.145     0.232     0.200
   138.155     0.095     0.200
   138.183     0.326     0.200
   138.192     0.240     0.200
   138.209     0.310     0.200
   138.211    -2.008     0.200
   138.378     0.085     0.200
   138.824     0.649     0.200
   139.159     0.585     0.200
   139.353     0.644     0.200
   139.429     0.694     0.200
   139.473    -4.566     0.200
   139.662     0.707     0.200
   139.861     0.149     0.200
   139.864     0.589     0.200
   139.896     0.546     0.200
   140.081     0.829     0.200
   140.139     0.809     0.200
   140.712     0.781     0.200
   140.934     0.043     0.200
   142.245    -2.758     0.200
   143.296    -3.142     0.200
   143.382    -2.661     0.200
   143.447    -2.643     0.200
   143.481    -2.711     0.200
   143.529    -3.779     0.200
   143.528    -3.425     0.200
   143.535    -2.680     0.200
   143.599    -3.769     0.200
   143.611    -4.673     0.200
   143.622    -3.691     0.200
   143.638    -2.743     0.200
   143.649    -2.552     0.200
   143.766    -3.491     0.200
   143.750    -2.752     0.200
   143.763    -2.713     0.200
   143.852    -3.213     0.200
   143.852    -3.369     0.200
   143.872    -3.871     0.200
   143.891    -2.694     0.200
   143.944    -3.536     0.200
   144.033    -3.318     0.200
   144.067    -2.970     0.200
   144.076    -2.182     0.200
   144.165    -1.564     0.200
   144.207    -2.527     0.200
   144.212    -2.138     0.200
   144.234    -1.808     0.200
   144.297    -2.910     0.200
   144.291    -2.596     0.200
   144.291    -2.432     0.200
   144.279    -2.019     0.200
   144.303    -3.140     0.200
   144.305    -2.628     0.200
   144.347    -2.607     0.200
   144.374    -3.209     0.200
   144.374    -2.740     0.200
   144.375    -2.038     0.200
   144.383    -2.084     0.200
   144.456    -3.493     0.200
   144.565    -1.931     0.200
   144.608    -2.029     0.200
   144.603    -1.278     0.200
   144.616    -1.511     0.200
   144.729    -1.980     0.200
   144.748    -2.218     0.200
   144.781    -1.150     0.200
   144.811    -1.014     0.200
   144.821    -1.062     0.200
   144.842    -1.200     0.200
   144.874    -1.732     0.200
   144.889    -1.399     0.200
   145.116    -0.562     0.200
   145.138    -0.476     0.200
   145.138    -0.164     0.200
   145.157    -0.517     0.200
   145.279    -0.382     0.200
   145.417    -0.127     0.200
   145.455    -0.240     0.200
   145.445     0.293     0.200
   145.523    -0.692     0.200
   145.546    -0.919     0.200
   145.572    -0.745     0.200
   145.619    -0.552     0.200
   145.674    -1.388     0.200
   145.976    -0.333     0.200
   146.074    -0.070     0.200
   146.414     0.035     0.200
   146.566    -0.003     0.200
   146.579    -0.378     0.200
   146.702    -0.343     0.200
   146.876    -0.134     0.200
   146.905     0.122     0.200
   147.003     0.161     0.200
   147.095    -0.095     0.200
   147.162    -0.566     0.200
   147.351     0.399     0.200
   147.420     0.169     0.200
   147.883     0.119     0.200
   148.023     0.670     0.200
   149.509    -0.145     0.200
   149.555    -0.359     0.200
   149.899     0.049     0.200
   150.039    -0.179     0.200
   151.817     0.172     0.200
   151.821    -0.234     0.200
   143.523    -1.211     0.200
   143.523    -0.914     0.200
   145.859    -1.108     0.200
   145.896    -1.140     0.200
   146.993    -0.447     0.200
   147.906    -0.042     0.200
   149.654     0.764     0.200
   135.045    -1.161     0.200
   135.045    -0.185     0.200
   135.261    -0.229     0.200
   135.341    -0.698     0.200
   135.341     0.115     0.200
   136.465     0.070     0.200
   136.975     0.391     0.200
   137.647     0.398     0.200
   137.841     0.299     0.200
   138.428     0.572     0.200
   138.667     0.626     0.200
   138.975    -0.218     0.200
   138.975    -0.212     0.200
   139.210    -0.063     0.200
   139.342    -0.530     0.200
   139.343    -0.219     0.200
   139.460    -0.221     0.200
   139.550     0.185     0.200
   139.551     0.215     0.200
   139.551    -0.098     0.200
   139.552     0.524     0.200
   139.618    -0.080     0.200
   139.666    -0.229     0.200
   139.751    -0.697     0.200
   139.776    -0.539     0.200
   139.834     0.230     0.200
   139.910    -0.079     0.200
   139.953     0.421     0.200
   139.965     0.235     0.200
   141.529    -0.408     0.200
   142.730    -2.142     0.200
   144.062    -4.273     0.200
   144.069    -4.168     0.200
   143.640    -2.177     0.200
   144.099    -4.026     0.200
   144.124    -4.086     0.200
   144.143    -4.290     0.200
   144.187    -3.866     0.200
   144.195    -4.092     0.200
   144.194    -3.708     0.200
   144.229    -3.940     0.200
   144.236    -4.054     0.200
   144.294    -4.171     0.200
   144.272    -2.218     0.200
   144.349    -4.047     0.200
   144.397    -3.303     0.200
   144.407    -3.328     0.200
   144.430    -2.586     0.200
   144.430    -3.492     0.200
   144.439    -3.235     0.200
   144.469    -3.257     0.200
   144.539    -3.222     0.200
   144.550    -2.045     0.200
   144.550    -2.889     0.200
   144.613    -2.741     0.200
   144.656    -3.151     0.200
   144.655    -3.392     0.200
   144.624    -0.783     0.200
   144.624    -0.548     0.200
   144.625    -1.081     0.200
   144.625    -1.089     0.200
   144.669    -3.244     0.200
   144.776    -2.477     0.200
   144.776    -2.789     0.200
   144.789    -2.920     0.200
   144.799    -2.804     0.200
   144.828    -1.926     0.200
   144.966     0.868     0.200
   144.966     1.305     0.200
   144.966     1.524     0.200
   145.437    -1.668     0.200
   145.437    -1.848     0.200
   145.001     1.464     0.200
   145.462    -2.079     0.200
   145.450    -0.637     0.200
   145.485    -1.274     0.200
   145.495    -1.582     0.200
   145.508    -1.432     0.200
   145.569    -1.692     0.200
   145.570    -1.358     0.200
   145.593    -1.648     0.200
   145.658    -1.454     0.200
   145.688    -1.396     0.200
   145.688    -1.513     0.200
   145.745    -1.079     0.200
   145.747    -0.942     0.200
   145.757    -1.271     0.200
   145.811    -1.347     0.200
   145.826    -1.436     0.200
   145.825    -1.364     0.200
   145.834    -1.184     0.200
   145.833    -0.893     0.200
   145.874    -1.580     0.200
   145.874    -0.901     0.200
   145.500     1.880     0.200
   145.500     1.442     0.200
   145.943    -0.776     0.200
   145.969    -0.648     0.200
   146.009    -0.810     0.200
   146.057    -1.438     0.200
   146.097    -0.529     0.200
   146.097    -0.889     0.200
   146.149    -0.759     0.200
   146.181    -1.126     0.200
   146.181    -0.970     0.200
   146.180    -0.422     0.200
   146.206    -0.731     0.200
   146.236    -0.406     0.200
   146.304    -0.616     0.200
   146.328    -0.617     0.200
   146.363    -0.950     0.200
   146.363    -0.442     0.200
   146.432    -0.082     0.200
   146.451    -0.497     0.200
   146.467    -0.290     0.200
   146.473    -0.394     0.200
   146.488    -0.372     0.200
   146.499    -0.805     0.200
   146.524    -0.174     0.200
   146.554    -0.936     0.200
   146.554    -0.225     0.200
   146.586     0.737     0.200
   146.608     0.637     0.200
   146.608     0.395     0.200
   146.619    -0.045     0.200
   146.645    -0.198     0.200
   146.678     0.207     0.200
   146.687    -0.700     0.200
   146.697     0.213     0.200
   146.705     0.177     0.200
   146.705    -1.182     0.200
   146.709    -0.096     0.200
   146.747     0.302     0.200
   146.747     0.200     0.200
   146.775    -0.199     0.200
   146.851     0.447     0.200
   146.855     0.221     0.200
   146.873    -1.700     0.200
   146.889     0.337     0.200
   146.908     0.312     0.200
   146.905     0.223     0.200
   146.939     0.712     0.200
   146.946    -1.204     0.200
   146.946     0.398     0.200
   146.981     0.175     0.200
   147.014     0.181     0.200
   147.013     0.277     0.200
   147.042    -0.944     0.200
   147.042     0.720     0.200
   147.065     0.072     0.200
   147.114    -0.048     0.200
   147.119     0.614     0.200
   147.184    -1.790     0.200
   147.183    -1.469     0.200
   147.244     0.579     0.200
   147.255     0.662     0.200
   147.247     1.003     0.200
   147.358     0.912     0.200
   147.388     1.018     0.200
   147.397     0.745     0.200
   147.397     0.979     0.200
   147.419     0.404     0.200
   147.436     0.962     0.200
   147.436     0.688     0.200
   147.433     1.232     0.200
   147.457     0.504     0.200
   147.481     1.215     0.200
   147.494    -0.619     0.200
   147.562    -0.388     0.200
   147.562     1.604     0.200
   147.607     1.077     0.200
   147.601     1.048     0.200
   147.631     1.387     0.200
   147.661     1.019     0.200
   147.678     0.951     0.200
   147.678     1.381     0.200
   147.715     0.468     0.200
   147.715     0.835     0.200
   147.723     1.275     0.200
   147.734     1.022     0.200
   147.783     0.973     0.200
   147.899     0.960     0.200
   147.933     1.796     0.200
   147.981     1.560     0.200
   147.985     1.585     0.200
   147.987     1.542     0.200
   147.982     1.636     0.200
   147.992    -1.693     0.200
   147.979     2.266     0.200
   148.049     1.534     0.200
   148.070     1.085     0.200
   148.096     1.886     0.200
   148.099     1.084     0.200
   148.254     1.588     0.200
   148.256     2.030     0.200
   148.256     1.912     0.200
   148.293     0.650     0.200
   148.382     2.058     0.200
   148.407     2.041     0.200
   148.436     2.454     0.200
   148.446     1.477     0.200
   148.656     1.612     0.200
   148.617     1.980     0.200
   148.694     1.886     0.200
   148.694     2.175     0.200
   148.738     2.104     0.200
   148.768     2.640     0.200
   148.782     2.290     0.200
   148.787     2.680     0.200
   148.411     3.261     0.200
   148.879     2.734     0.200
   148.940     2.292     0.200
   148.952     2.515     0.200
   148.969    -2.146     0.200
   149.125     2.775     0.200
   149.151     2.343     0.200
   149.222     2.502     0.200
   149.239     2.818     0.200
   149.437     2.853     0.200
   149.480     2.308     0.200
   149.480     2.988     0.200
   149.688     2.617     0.200
   149.768     3.060     0.200
   149.771     3.095     0.200
   149.783     3.124     0.200
   149.856     3.156     0.200
   149.980     3.234     0.200
   149.734     3.240     0.200
   150.181     3.276     0.200
   150.135    -1.307     0.200
   150.260     3.317     0.200
   150.551    -1.614     0.200
   151.608    -2.281     0.200
   151.808    -0.840     0.200
   151.364     1.152     0.200
   151.823    -0.956     0.200
   152.104    -0.173     0.200
   152.263    -0.582     0.200
   152.452    -0.354     0.200
   152.705    -0.406     0.200
   152.991    -0.700     0.200
   152.648     0.192     0.200
   152.663     1.491     0.200
   153.256    -0.124     0.200
   154.065     1.558     0.200
   155.729     1.719     0.200
   155.729     0.422     0.200
   155.729     2.586     0.200
   144.181    -2.040     0.200
   144.122    -0.806     0.200
   137.373    -0.434     0.200
   138.943     0.271     0.200
   143.109    -1.504     0.200
   143.619    -3.231     0.200
   143.904    -2.612     0.200
   144.178    -2.850     0.200
   144.207    -2.903     0.200
   144.251    -3.218     0.200
   144.252    -3.056     0.200
   144.346    -2.803     0.200
   144.350    -1.399     0.200
   144.351    -1.561     0.200
   144.351    -1.419     0.200
   144.240     0.943     0.200
   144.492    -1.520     0.200
   144.492    -1.819     0.200
   144.551    -2.315     0.200
   144.551    -2.935     0.200
   144.572    -0.905     0.200
   144.623    -1.218     0.200
   144.663    -2.398     0.200
   144.676    -2.423     0.200
   144.459     0.981     0.200
   144.472     0.749     0.200
   144.751    -2.353     0.200
   144.773    -2.765     0.200
   144.774    -2.177     0.200
   144.810    -2.407     0.200
   145.418    -1.752     0.200
   145.426    -1.107     0.200
   145.428    -1.872     0.200
   145.446    -1.524     0.200
   145.460    -1.288     0.200
   145.485    -0.781     0.200
   145.510    -1.975     0.200
   145.617    -2.076     0.200
   145.624    -0.748     0.200
   145.624    -1.103     0.200
   145.624    -0.368     0.200
   145.707    -1.383     0.200
   145.707    -1.004     0.200
   145.731    -0.609     0.200
   145.801    -1.403     0.200
   145.799    -1.196     0.200
   145.869    -1.136     0.200
   145.869    -2.054     0.200
   145.873    -0.852     0.200
   145.929    -1.817     0.200
   145.921    -0.584     0.200
   145.921    -0.783     0.200
   146.058    -0.911     0.200
   146.102    -0.301     0.200
   146.158    -0.837     0.200
   146.158    -0.421     0.200
   146.203    -0.643     0.200
   146.229    -0.666     0.200
   146.229    -0.441     0.200
   146.330    -0.075     0.200
   146.394     0.044     0.200
   146.448    -0.040     0.200
   146.522    -0.982     0.200
   146.564    -0.174     0.200
   146.642     0.235     0.200
   146.817     0.391     0.200
   146.989    -1.027     0.200
   147.146     0.520     0.200
   147.250    -0.024     0.200
   147.250     0.548     0.200
   147.439     0.491     0.200
   147.451     0.831     0.200
   147.511     0.901     0.200
   147.604     0.857     0.200
   147.811     0.740     0.200
   152.049     2.523     0.200
   152.781     2.280     0.200
   154.488     2.372     0.200
   154.555     2.279     0.200
   155.507     2.248     0.200
   156.782     2.040     0.200
   143.813    -1.267     0.200
   146.271     1.084     0.200
   144.272    -1.532     0.200
   143.237    -2.440     0.200
   144.155    -1.813     0.200
   145.758    -1.001     0.200
   141.291    -0.263     0.200
   141.709     0.177     0.200
   143.221    -1.560     0.200
   143.374    -1.189     0.200
   144.168    -1.595     0.200
   144.480    -1.131     0.200
   144.635     0.789     0.200
   144.637    -0.304     0.200
   146.223    -0.145     0.200
   146.953    -0.574     0.200
   147.050    -0.937     0.200
   147.594     0.947     0.200
   148.511     0.630     0.200
   149.681     0.236     0.200
   150.295    -1.312     0.200
   152.965    -0.785     0.200
   153.023    -0.469     0.200
   154.667    -0.013     0.200
   154.732    -1.102     0.200
   155.472     2.537     0.200
   155.472    -0.322     0.200
   142.452    -2.766     0.200
   144.210    -2.255     0.200
   146.393    -1.620     0.200
   146.456    -1.907     0.200
   148.884     0.354     0.200
   141.377    -1.120     0.200
   144.904     0.735     0.200
   154.320     0.180     0.200
   156.399     0.778     0.200
   144.151    -2.465     0.200
   143.245    -1.312     0.200
   143.534    -1.270     0.200
   146.852     1.448     0.200
   142.665    -1.608     0.200
   144.195    -1.647     0.200
   144.195    -2.553     0.200
   144.132    -1.990     0.200
   147.804     3.060     0.200
   142.788    -0.721     0.200
   142.788    -3.166     0.200
   144.030    -1.931     0.200
   144.030    -1.571     0.200
   145.106     1.204     0.200
   147.318     1.780     0.200
   143.349    -0.942     0.200
   144.058    -1.240     0.200
   144.058    -0.865     0.200
   144.936    -1.668     0.200
   141.446     0.616     0.200
   141.224    -0.399     0.200
   144.173    -1.904     0.200
   144.173    -1.443     0.200
   144.384    -3.451     0.200
   145.524    -2.512     0.200
   145.494    -1.977     0.200
   145.672    -1.562     0.200
   145.958    -1.567     0.200
   146.385     1.054     0.200
   135.033    -0.284     0.200
   139.399    -1.649     0.200
   141.534    -3.709     0.200
   142.670    -1.160     0.200
   144.000     0.025     0.200
   144.406    -0.681     0.200
   144.408    -0.884     0.200
   144.409    -1.187     0.200
   147.521     0.718     0.200
   155.534     1.706     0.200
   138.524    -0.954     0.200
   138.524    -1.684     0.200
   141.011    -1.406     0.200
   143.488    -2.706     0.200
   143.723    -2.898     0.200
   143.317    -0.705     0.200
   143.317    -1.446     0.200
   144.505    -1.042     0.200
   146.629    -0.689     0.200
   146.932    -1.777     0.200
   147.692    -1.025     0.200
   148.213    -2.724     0.200
   148.686    -0.817     0.200
   156.001     1.520     0.200
   143.652    -0.069     0.200
   143.556     1.156     0.200
   146.629    -1.150     0.200
   146.932    -1.008     0.200
   148.213     0.490     0.200
   156.001     2.720     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   144.969    -1.193     0.200
   145.144    -1.081     0.200
   145.192    -1.186     0.200
   145.200    -1.154     0.200
   145.200    -1.029     0.200
   145.209    -0.880     0.200
   145.286    -1.316     0.200
   145.754     0.163     0.200
   145.860     0.092     0.200
   145.925    -0.011     0.200
   145.971     0.309     0.200
   146.190     0.820     0.200
   146.340     0.379     0.200
   146.375     0.959     0.200
   146.404     0.871     0.200
   146.517     1.040     0.200
   146.647     1.453     0.200
   146.664     1.566     0.200
   146.705     1.208     0.200
   146.728     1.436     0.200
   146.878     1.910     0.200
   146.960     2.084     0.200
   147.115     2.115     0.200
   147.183     1.883     0.200
   147.217     2.287     0.200
   147.252     1.753     0.200
   147.249     1.414     0.200
   147.261     2.049     0.200
   147.306     1.827     0.200
   147.378     2.972     0.200
   147.420     1.950     0.200
   147.442     2.600     0.200
   147.552     2.386     0.200
   147.527     2.552     0.200
   147.539     2.728     0.200
   147.590     2.425     0.200
   147.597     2.179     0.200
   147.605     3.119     0.200
   147.659     2.717     0.200
   147.721     3.348     0.200
   147.773     1.598     0.200
   147.750     2.958     0.200
   148.074     2.306     0.200
   148.063     3.324     0.200
   148.084     2.860     0.200
   148.143     3.606     0.200
   148.420     2.325     0.200
   148.763     2.961     0.200
   150.093     3.915     0.200
   150.654     4.657     0.200
   150.833     5.404     0.200
   151.817     5.750     0.200
   152.406     6.331     0.200
   154.574     7.784     0.200
   149.654     3.920     0.200
   144.944    -2.859     0.200
   144.973    -2.652     0.200
   144.985    -2.235     0.200
   144.985    -2.376     0.200
   144.994    -2.360     0.200
   145.040    -2.408     0.200
   145.046    -2.207     0.200
   145.046    -3.137     0.200
   145.095    -1.879     0.200
   145.099    -2.737     0.200
   145.092    -1.959     0.200
   145.132    -2.411     0.200
   145.161    -2.242     0.200
   145.169    -2.803     0.200
   145.168    -2.278     0.200
   145.168    -2.028     0.200
   145.225    -2.227     0.200
   145.225    -2.727     0.200
   145.249    -1.862     0.200
   145.291    -2.583     0.200
   145.304    -1.722     0.200
   145.319    -1.740     0.200
   145.360    -1.835     0.200
   145.360    -1.702     0.200
   145.360    -1.538     0.200
   145.405    -1.779     0.200
   145.001     1.027     0.200
   145.450    -0.379     0.200
   147.982     2.527     0.200
   147.979     2.867     0.200
   148.189     2.514     0.200
   148.293     3.697     0.200
   148.473     2.926     0.200
   148.685     2.713     0.200
   148.768     2.859     0.200
   148.962     3.725     0.200
   148.969     3.573     0.200
   148.995     3.070     0.200
   149.086     3.588     0.200
   149.204     3.186     0.200
   149.349     3.198     0.200
   149.395     3.194     0.200
   149.501     3.204     0.200
   149.549     3.143     0.200
   149.549     3.330     0.200
   149.574     3.470     0.200
   149.636     3.271     0.200
   149.656     4.003     0.200
   149.709     3.350     0.200
   149.741     3.338     0.200
   149.741     3.502     0.200
   149.809     3.558     0.200
   149.931     3.725     0.200
   150.027     3.714     0.200
   150.112     3.642     0.200
   150.154     3.678     0.200
   150.177     3.713     0.200
   150.177     3.806     0.200
   150.215     3.677     0.200
   150.215     4.075     0.200
   150.234     3.647     0.200
   150.314     4.248     0.200
   150.326     4.010     0.200
   150.355     4.177     0.200
   150.390     3.723     0.200
   150.390     4.355     0.200
   150.410     4.340     0.200
   150.479     3.725     0.200
   150.479     4.038     0.200
   150.514     4.303     0.200
   150.551     3.683     0.200
   150.689     4.407     0.200
   150.758     4.480     0.200
   150.758     4.714     0.200
   150.760     4.375     0.200
   150.862     4.530     0.200
   150.867     4.788     0.200
   150.950     4.684     0.200
   150.953     5.359     0.200
   150.953     5.156     0.200
   150.982     4.104     0.200
   150.998     4.891     0.200
   150.999     4.889     0.200
   151.042     4.300     0.200
   151.132     4.655     0.200
   151.140     5.385     0.200
   151.184     4.794     0.200
   151.207     4.672     0.200
   151.207     4.813     0.200
   151.316     4.748     0.200
   151.368     4.982     0.200
   151.467     4.995     0.200
   151.467     5.339     0.200
   151.527     5.287     0.200
   151.530     4.870     0.200
   151.608     5.250     0.200
   151.608     5.086     0.200
   151.610     4.724     0.200
   151.610     5.232     0.200
   151.666     5.484     0.200
   151.730     5.669     0.200
   151.751     5.113     0.200
   151.770     5.179     0.200
   151.808     5.207     0.200
   151.823     5.255     0.200
   151.863     5.344     0.200
   151.863     5.429     0.200
   151.933     5.847     0.200
   151.930     5.603     0.200
   152.037     5.388     0.200
   152.088     5.343     0.200
   152.088     5.609     0.200
   152.090     5.598     0.200
   152.104     6.233     0.200
   152.119     5.616     0.200
   152.186     5.368     0.200
   152.245     5.757     0.200
   152.256     6.062     0.200
   152.289     5.950     0.200
   152.292     5.828     0.200
   152.299     5.615     0.200
   152.452     5.748     0.200
   152.501     6.276     0.200
   152.558     5.856     0.200
   152.579     6.153     0.200
   152.615     6.484     0.200
   152.642     6.162     0.200
   152.654     5.958     0.200
   152.705     6.188     0.200
   152.705     6.344     0.200
   152.731     6.227     0.200
   152.796     6.500     0.200
   152.891     5.947     0.200
   152.907     6.555     0.200
   152.912     6.291     0.200
   152.991     6.698     0.200
   152.991     6.464     0.200
   153.048     6.818     0.200
   153.136     6.590     0.200
   153.265     6.411     0.200
   153.268     6.649     0.200
   153.291     6.881     0.200
   153.344     6.758     0.200
   153.521     6.878     0.200
   153.556     6.070     0.200
   153.556     6.758     0.200
   153.597     7.222     0.200
   153.664     7.040     0.200
   153.731     7.188     0.200
   153.745     7.237     0.200
   154.383     7.206     0.200
   150.637     5.034     0.200
   145.009    -1.919     0.200
   145.202    -1.626     0.200
   145.267    -1.783     0.200
   145.275    -1.670     0.200
   145.275    -2.159     0.200
   145.303    -2.093     0.200
   145.326    -0.638     0.200
   145.386    -1.115     0.200
   145.386    -0.878     0.200
   146.112     0.104     0.200
   146.377     0.729     0.200
   146.527     0.998     0.200
   146.591     0.859     0.200
   146.635     0.403     0.200
   146.643     0.568     0.200
   146.658     1.368     0.200
   146.737     0.559     0.200
   146.746     0.460     0.200
   146.746     0.579     0.200
   146.817     0.535     0.200
   146.954     0.667     0.200
   147.051     1.021     0.200
   147.055     1.042     0.200
   147.058     1.225     0.200
   147.101     1.514     0.200
   147.111     1.498     0.200
   147.111     0.823     0.200
   147.113     1.575     0.200
   147.113     1.049     0.200
   146.883     1.010     0.200
   146.883     1.690     0.200
   147.146     1.179     0.200
   147.146     0.865     0.200
   147.166     1.146     0.200
   147.148     1.635     0.200
   147.148     2.174     0.200
   147.250     1.031     0.200
   147.291     1.008     0.200
   147.332     1.580     0.200
   147.343     0.931     0.200
   147.343     1.356     0.200
   147.439     1.143     0.200
   147.511     1.422     0.200
   147.528     1.326     0.200
   147.604     1.092     0.200
   147.605     1.806     0.200
   147.605     1.916     0.200
   147.605     2.107     0.200
   147.670     1.309     0.200
   147.670     1.828     0.200
   147.429     2.457     0.200
   147.689     1.857     0.200
   147.752     1.915     0.200
   147.799     1.726     0.200
   147.799     1.563     0.200
   147.846     2.973     0.200
   147.887     2.266     0.200
   147.672     2.485     0.200
   147.934     2.175     0.200
   147.940     2.176     0.200
   147.970     1.664     0.200
   148.059     3.330     0.200
   148.122     1.993     0.200
   148.122     1.613     0.200
   148.150     2.207     0.200
   148.164     1.858     0.200
   148.229     1.446     0.200
   148.268     1.791     0.200
   148.372     2.340     0.200
   148.408     2.744     0.200
   148.408     2.504     0.200
   148.500     2.727     0.200
   148.572     2.334     0.200
   148.643     2.566     0.200
   148.797     2.687     0.200
   148.594     2.441     0.200
   148.980     2.831     0.200
   148.786     2.758     0.200
   149.035     2.506     0.200
   149.035     2.757     0.200
   149.034     4.129     0.200
   149.224     3.431     0.200
   149.242     3.254     0.200
   149.074     2.294     0.200
   149.395     3.677     0.200
   149.449     3.461     0.200
   149.273     2.613     0.200
   149.691     3.915     0.200
   149.710     3.785     0.200
   149.711     3.755     0.200
   149.887     4.249     0.200
   149.932     4.409     0.200
   150.071     4.335     0.200
   150.203     4.427     0.200
   150.203     4.027     0.200
   150.513     4.746     0.200
   150.553     4.457     0.200
   150.627     4.622     0.200
   150.710     5.101     0.200
   150.742     4.725     0.200
   150.755     4.201     0.200
   150.827     5.013     0.200
   150.605     3.032     0.200
   150.905     5.067     0.200
   150.734     2.832     0.200
   151.018     5.305     0.200
   151.045     5.412     0.200
   151.097     4.947     0.200
   151.300     5.408     0.200
   151.336     4.789     0.200
   151.396     5.090     0.200
   151.474     4.697     0.200
   151.527     4.863     0.200
   151.696     6.006     0.200
   151.825     5.832     0.200
   151.984     5.660     0.200
   151.984     5.848     0.200
   152.002     5.953     0.200
   152.002     6.070     0.200
   152.167     5.372     0.200
   152.278     5.062     0.200
   152.383     5.513     0.200
   152.565     6.211     0.200
   152.601     6.042     0.200
   152.665     5.701     0.200
   152.988     5.638     0.200
   152.995     6.847     0.200
   152.995     6.215     0.200
   153.223     6.658     0.200
   153.231     6.343     0.200
   153.550     6.789     0.200
   153.569     7.244     0.200
   154.209     6.941     0.200
   145.942     0.271     0.200
   148.822     2.895     0.200
   145.275    -0.315     0.200
   146.852     1.184     0.200
   149.893     3.522     0.200
   145.028    -3.106     0.200
   145.286    -3.252     0.200
   148.857     3.027     0.200
   149.537     3.037     0.200
   145.274     1.079     0.200
   145.139    -0.984     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   145.594     0.421     0.200
   145.621     0.617     0.200
   145.659     0.451     0.200
   145.839     1.096     0.200
   146.008     1.098     0.200
   146.001     1.446     0.200
   146.181     1.351     0.200
   145.935     1.776     0.200
   146.340     1.504     0.200
   146.405     1.448     0.200
   146.474     1.503     0.200
   146.514     1.615     0.200
   146.614     1.892     0.200
   146.918     2.460     0.200
   147.225     2.844     0.200
   147.469     3.251     0.200
   160.807    42.161     0.200
   168.833    69.998     0.200
   177.421   105.532     0.200
   161.293    46.160     0.200
   146.709     1.920     0.200
   149.422     8.056     0.200
   149.734     7.779     0.200
   153.745    18.253     0.200
   153.815    18.365     0.200
   153.852    18.711     0.200
   153.925    19.513     0.200
   153.942    18.723     0.200
   153.955    18.823     0.200
   153.996    19.631     0.200
   154.051    19.281     0.200
   154.122    19.517     0.200
   154.170    20.082     0.200
   154.368    20.546     0.200
   154.383    20.089     0.200
   154.453    19.983     0.200
   154.453    21.007     0.200
   154.466    21.464     0.200
   154.495    20.433     0.200
   154.495    21.002     0.200
   154.781    22.731     0.200
   154.781    22.036     0.200
   154.816    21.690     0.200
   155.047    21.921     0.200
   155.061    22.277     0.200
   155.128    22.381     0.200
   155.148    22.955     0.200
   155.321    23.181     0.200
   155.341    22.958     0.200
   155.706    24.562     0.200
   155.914    25.746     0.200
   155.914    24.675     0.200
   156.203    25.934     0.200
   156.379    26.854     0.200
   156.392    26.626     0.200
   156.750    28.537     0.200
   156.750    27.662     0.200
   156.756    26.748     0.200
   157.085    27.328     0.200
   157.295    29.155     0.200
   157.535    29.612     0.200
   157.869    30.542     0.200
   158.193    31.802     0.200
   158.472    32.949     0.200
   158.655    33.637     0.200
   158.982    34.328     0.200
   159.127    34.337     0.200
   159.424    35.399     0.200
   159.424    34.571     0.200
   159.590    35.372     0.200
   159.913    37.326     0.200
   160.128    38.014     0.200
   160.248    40.584     0.200
   168.194    66.969     0.200
   168.145    67.479     0.200
   168.860    68.656     0.200
   176.312   100.470     0.200
   145.916     1.566     0.200
   145.326     0.014     0.200
   145.749     2.030     0.200
   146.321     1.247     0.200
   146.527     1.672     0.200
   149.273     7.193     0.200
   145.532     1.833     0.200
   145.930     2.194     0.200
   155.472    28.912     0.200
   146.589     1.697     0.200
   154.320    23.659     0.200
   156.399    31.153     0.200
   159.689    37.163     0.200
   145.901     1.895     0.200
   155.423    29.118     0.200
   147.336     3.785     0.200
   145.313    -0.660     0.200
   146.609     2.685     0.200
   156.001    29.895     0.200
   147.930     7.333     0.200
   148.686     6.544     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   135.074     0.479     0.200
   135.074     0.736     0.200
   136.883     0.654     0.200
   137.347     0.561     0.200
   137.363     0.782     0.200
   137.946     0.793     0.200
   138.211     0.633     0.200
   138.453     0.775     0.200
   138.496     0.860     0.200
   138.630     0.833     0.200
   138.677     1.068     0.200
   138.691     0.791     0.200
   138.762     0.724     0.200
   138.839     0.716     0.200
   138.903     0.873     0.200
   138.990     0.854     0.200
   139.029     0.752     0.200
   139.044     0.764     0.200
   139.136     0.916     0.200
   139.269     0.806     0.200
   139.407     0.842     0.200
   139.476     0.920     0.200
   139.483     1.103     0.200
   139.499     0.988     0.200
   139.507     1.333     0.200
   139.535     1.040     0.200
   139.554     0.919     0.200
   139.700     1.168     0.200
   139.759     1.053     0.200
   139.826     1.345     0.200
   140.175     1.087     0.200
   140.197     1.157     0.200
   140.187     1.331     0.200
   140.271     1.218     0.200
   140.274     1.235     0.200
   140.371     1.358     0.200
   140.415     1.395     0.200
   140.530     1.593     0.200
   140.540     1.661     0.200
   140.552     1.194     0.200
   140.625     1.116     0.200
   140.660     1.101     0.200
   140.714     1.223     0.200
   140.704     1.981     0.200
   140.964     1.748     0.200
   140.978     1.589     0.200
   141.003     1.193     0.200
   141.097     1.274     0.200
   141.113     1.605     0.200
   141.119     1.040     0.200
   141.149     1.476     0.200
   141.422     1.690     0.200
   141.447     1.613     0.200
   141.510     1.087     0.200
   141.511     1.413     0.200
   141.573     1.670     0.200
   141.776     1.742     0.200
   141.831     1.989     0.200
   141.873     1.913     0.200
   141.915     2.010     0.200
   141.930     1.913     0.200
   141.976     2.027     0.200
   142.167     1.873     0.200
   142.272     2.295     0.200
   142.293     2.305     0.200
   142.346     1.977     0.200
   142.375     1.956     0.200
   142.379     2.294     0.200
   142.561     2.524     0.200
   142.650     2.358     0.200
   142.661     2.496     0.200
   142.908     2.253     0.200
   143.040     2.558     0.200
   143.166     2.298     0.200
   143.192     2.799     0.200
   143.232     2.963     0.200
   147.872     3.794     0.200
   147.959     3.847     0.200
   147.986     3.716     0.200
   148.185     4.029     0.200
   148.174     4.031     0.200
   148.352     3.880     0.200
   148.354     4.683     0.200
   148.404     4.039     0.200
   148.406     4.598     0.200
   148.401     4.349     0.200
   148.454     4.183     0.200
   148.571     4.390     0.200
   148.596     4.733     0.200
   148.698     4.903     0.200
   148.736     4.630     0.200
   148.782     4.430     0.200
   148.834     5.253     0.200
   148.852     4.435     0.200
   148.852     4.786     0.200
   148.916     5.549     0.200
   148.948     5.021     0.200
   149.020     5.460     0.200
   149.048     4.970     0.200
   149.093     5.670     0.200
   149.153     5.629     0.200
   149.216     4.809     0.200
   149.349     5.689     0.200
   149.392     5.785     0.200
   149.405     6.787     0.200
   149.462     5.438     0.200
   149.557     5.099     0.200
   149.595     6.141     0.200
   149.702     6.322     0.200
   149.430     6.146     0.200
   149.882     6.185     0.200
   149.900     6.423     0.200
   149.958     6.511     0.200
   149.992     6.168     0.200
   150.191     6.464     0.200
   153.387     8.330     0.200
   154.426     8.279     0.200
   146.350     3.526     0.200
   136.903     0.508     0.200
   136.975     0.618     0.200
   137.122     0.672     0.200
   137.209     0.613     0.200
   137.663     0.681     0.200
   137.508     1.820     0.200
   138.160     0.634     0.200
   138.347     0.752     0.200
   138.591     1.016     0.200
   138.635     0.762     0.200
   139.535     2.314     0.200
   140.531     0.990     0.200
   140.616     1.149     0.200
   140.714     0.987     0.200
   141.167     2.367     0.200
   141.920     1.432     0.200
   141.536     1.555     0.200
   141.670     3.426     0.200
   141.734     1.951     0.200
   141.778     2.623     0.200
   142.187     2.807     0.200
   143.640     2.933     0.200
   145.787     2.997     0.200
   146.987     4.515     0.200
   147.327     4.339     0.200
   148.617     5.066     0.200
   149.086     4.448     0.200
   149.235     6.576     0.200
   149.681     6.753     0.200
   150.187     6.189     0.200
   150.415     7.590     0.200
   150.587     8.214     0.200
   150.999     6.187     0.200
   150.750     7.742     0.200
   151.364     6.707     0.200
   151.364     7.910     0.200
   152.194     9.310     0.200
   152.700     6.828     0.200
   152.648     8.528     0.200
   152.648     9.091     0.200
   152.663     9.475     0.200
   153.212     7.457     0.200
   153.253     7.185     0.200
   153.276     7.230     0.200
   153.429     7.596     0.200
   153.256     9.822     0.200
   153.710     7.577     0.200
   145.977     2.997     0.200
   135.100     0.861     0.200
   135.500     0.694     0.200
   135.639     1.059     0.200
   136.152     1.272     0.200
   136.185     0.879     0.200
   136.757     1.413     0.200
   137.001     1.077     0.200
   137.070     1.348     0.200
   137.276     0.983     0.200
   137.556     1.232     0.200
   137.872     1.345     0.200
   138.399     1.733     0.200
   138.943     1.187     0.200
   139.221     1.633     0.200
   139.693     1.775     0.200
   140.045     1.528     0.200
   139.904     2.799     0.200
   141.217     2.117     0.200
   141.507     2.646     0.200
   142.062     2.234     0.200
   142.557     2.423     0.200
   143.548     2.083     0.200
   143.616     2.134     0.200
   145.348     2.605     0.200
   145.749     2.549     0.200
   145.818     3.071     0.200
   146.678     4.354     0.200
   148.059     3.955     0.200
   148.173     3.978     0.200
   149.039     4.432     0.200
   149.039     4.710     0.200
   149.537     5.692     0.200
   150.166     5.215     0.200
   151.407     6.513     0.200
   151.484     5.912     0.200
   153.569     7.506     0.200
   154.205     7.972     0.200
   154.751     8.791     0.200
   145.826     2.759     0.200
   144.152     3.966     0.200
   148.705     5.354     0.200
   144.161     3.024     0.200
   154.320     9.079     0.200
   145.901     3.004     0.200
   146.890     5.265     0.200
   145.707     2.154     0.200
   148.297     4.939     0.200
   150.632     6.414     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
