#!/bin/bash
gmt begin bandung1.79_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P bandung1.79'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.693
    79.000     8.519
    80.000     7.429
    81.000     6.426
    82.000     5.508
    83.000     4.675
    84.000     3.925
    85.000     3.263
    86.000     2.686
    87.000     2.187
    88.000     1.793
    89.000     1.494
    90.000     1.236
    91.000     1.010
    92.000     0.809
    93.000     0.628
    94.000     0.463
    95.000     0.318
    96.000     0.198
    97.000     0.105
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.577     2.186     0.200
    16.049     1.918     0.200
    16.187     2.064     0.200
    16.436     1.807     0.200
    16.625     1.021     0.200
    16.867     0.724     0.200
    17.083     0.314     0.200
    17.152     0.667     0.200
    17.152     0.417     0.200
    17.340     2.289     0.200
    17.200     0.868     0.200
    17.687     0.760     0.200
    17.872     5.483     0.200
    18.065    -1.727     0.200
    18.441    -2.500     0.200
    19.749    -0.413     0.200
    19.809    -0.965     0.200
    20.559    -0.095     0.200
    21.535     2.492     0.200
    21.693    -1.400     0.200
    21.900    -1.908     0.200
    22.084    -1.367     0.200
    22.084    -3.125     0.200
    22.312    -4.792     0.200
    22.625     0.412     0.200
    23.414    -2.256     0.200
    23.770    -1.131     0.200
    23.885    -0.911     0.200
    24.246    -0.742     0.200
    24.227    -2.038     0.200
    24.272    -1.275     0.200
    24.885    -0.140     0.200
    25.252    -1.958     0.200
    25.192    -2.263     0.200
    25.196    -3.505     0.200
    25.642    -2.440     0.200
    25.642    -3.245     0.200
    26.887    -2.488     0.200
    26.887    -3.793     0.200
    26.682     2.605     0.200
    27.339    -3.493     0.200
    27.677    -3.570     0.200
    27.835     1.219     0.200
    28.568    -6.344     0.200
    29.184    -3.279     0.200
    29.096    -1.418     0.200
    29.102    -0.850     0.200
    29.102    -1.053     0.200
    29.102    -0.256     0.200
    29.784     1.509     0.200
    30.203     1.421     0.200
    30.203     3.101     0.200
    30.203     2.944     0.200
    30.136     0.734     0.200
    30.217    -0.770     0.200
    32.149    -1.933     0.200
    33.058    -1.188     0.200
    33.465    -2.540     0.200
    34.132    -3.129     0.200
    34.007    -2.848     0.200
    34.311    -1.737     0.200
    34.534    -2.308     0.200
    34.545    -0.519     0.200
    34.614    -2.323     0.200
    35.366    -1.766     0.200
    35.641    -0.821     0.200
    36.162    -1.418     0.200
    36.033    -0.880     0.200
    36.338    -3.199     0.200
    36.581    -1.503     0.200
    36.606    -2.096     0.200
    36.636     1.120     0.200
    37.169    -0.982     0.200
    37.683    -1.623     0.200
    37.685    -1.561     0.200
    38.007    -3.177     0.200
    38.082    -0.460     0.200
    38.688    -3.784     0.200
    38.853    -2.164     0.200
    38.805    -5.951     0.200
    39.405    -3.370     0.200
    39.542    -1.038     0.200
    39.675    -2.923     0.200
    39.855    -3.216     0.200
    39.753    -1.067     0.200
    39.900    -0.190     0.200
    40.220    -2.096     0.200
    40.340    -2.938     0.200
    40.340    -3.235     0.200
    40.086     0.625     0.200
    40.953    -3.389     0.200
    40.964    -3.583     0.200
    41.007    -2.831     0.200
    41.077    -1.113     0.200
    41.134    -3.280     0.200
    41.198    -3.301     0.200
    41.728    -3.447     0.200
    41.693    -3.560     0.200
    41.903    -1.675     0.200
    42.032    -3.230     0.200
    42.419    -3.280     0.200
    43.256    -4.555     0.200
    43.827    -2.053     0.200
    44.883    -3.290     0.200
    44.814    -2.985     0.200
    45.099    -1.241     0.200
    45.640    -4.289     0.200
    45.456     1.145     0.200
    46.005    -1.965     0.200
    46.097    -3.676     0.200
    46.219    -3.394     0.200
    46.312    -4.482     0.200
    46.362    -3.195     0.200
    46.386    -3.872     0.200
    46.689    -3.891     0.200
    46.689    -3.305     0.200
    47.068    -2.245     0.200
    47.149     0.373     0.200
    47.513    -2.457     0.200
    47.370     3.221     0.200
    48.012    -2.523     0.200
    48.045    -2.295     0.200
    48.106    -2.341     0.200
    48.149    -3.245     0.200
    48.285    -1.958     0.200
    48.323    -3.022     0.200
    48.342    -2.299     0.200
    48.431    -2.662     0.200
    48.499    -3.582     0.200
    48.500    -1.937     0.200
    48.532    -3.038     0.200
    48.539    -3.283     0.200
    48.636    -1.619     0.200
    48.656    -2.442     0.200
    48.669    -1.685     0.200
    48.680    -2.336     0.200
    48.714    -4.886     0.200
    48.714    -5.330     0.200
    48.866    -2.910     0.200
    49.091    -1.957     0.200
    49.137    -2.634     0.200
    49.147    -2.847     0.200
    49.147    -2.863     0.200
    49.331    -2.618     0.200
    49.418    -1.850     0.200
    49.432    -2.007     0.200
    49.580    -1.423     0.200
    49.712    -1.956     0.200
    49.862    -1.282     0.200
    50.013    -2.186     0.200
    50.131    -1.852     0.200
    51.753    -3.728     0.200
    52.363    -0.951     0.200
    53.029    -4.980     0.200
    53.029    -4.628     0.200
    53.029    -4.784     0.200
    53.030    -4.802     0.200
    54.097    -3.609     0.200
    54.331    -2.402     0.200
    54.854    -3.600     0.200
    55.205    -4.634     0.200
    55.471    -2.765     0.200
    55.499    -3.147     0.200
    55.592    -3.216     0.200
    55.905     1.186     0.200
    56.098    -3.340     0.200
    56.098    -3.770     0.200
    56.559    -3.600     0.200
    56.511     1.047     0.200
    56.864     1.174     0.200
    57.238    -3.269     0.200
    57.554    -2.735     0.200
    57.705     1.182     0.200
    57.900     1.414     0.200
    58.063    -3.117     0.200
    58.063    -3.523     0.200
    58.106    -2.733     0.200
    58.147    -2.752     0.200
    58.323    -2.790     0.200
    58.245     0.882     0.200
    58.340    -2.687     0.200
    58.340    -2.367     0.200
    58.340    -3.203     0.200
    58.437    -4.838     0.200
    58.505    -3.665     0.200
    58.695    -3.586     0.200
    58.692    -2.801     0.200
    58.692    -3.114     0.200
    58.654     1.156     0.200
    58.830    -3.414     0.200
    58.831    -1.042     0.200
    59.218    -0.396     0.200
    59.219     0.653     0.200
    59.223     0.358     0.200
    59.387    -3.562     0.200
    59.387    -2.328     0.200
    59.527    -1.792     0.200
    59.668    -3.760     0.200
    59.668    -2.963     0.200
    59.668    -4.088     0.200
    59.626     0.323     0.200
    59.677     0.224     0.200
    59.882    -3.433     0.200
    59.789     0.563     0.200
    59.927    -2.543     0.200
    59.926    -3.434     0.200
    60.323    -0.648     0.200
    60.599    -4.033     0.200
    60.764    -0.890     0.200
    60.954    -4.074     0.200
    61.314    -5.089     0.200
    62.497    -8.534     0.200
    62.838    -0.955     0.200
    63.172    -3.727     0.200
    63.172    -3.500     0.200
    63.259    -3.622     0.200
    63.308    -3.922     0.200
    63.453    -1.265     0.200
    63.674     1.434     0.200
    63.936     0.666     0.200
    64.358    -3.124     0.200
    64.369    -4.197     0.200
    64.369    -4.525     0.200
    64.393    -2.058     0.200
    64.394    -1.063     0.200
    64.397    -0.580     0.200
    64.724    -3.321     0.200
    64.838     0.474     0.200
    65.572    -3.517     0.200
    65.722    -3.785     0.200
    65.870    -1.350     0.200
    65.934     1.859     0.200
    65.942    -0.270     0.200
    65.942     1.434     0.200
    66.531    -1.019     0.200
    66.568    -0.400     0.200
    66.591    -0.497     0.200
    66.624    -0.709     0.200
    66.864    -0.136     0.200
    66.851    -1.195     0.200
    66.520     0.633     0.200
    67.039    -0.029     0.200
    67.192    -5.078     0.200
    67.293    -0.067     0.200
    67.348    -0.278     0.200
    67.450    -0.864     0.200
    67.709    -0.456     0.200
    67.470     0.671     0.200
    68.026    -0.057     0.200
    68.157    -3.144     0.200
    68.223    -2.871     0.200
    68.225    -0.307     0.200
    68.380    -0.080     0.200
    68.787    -0.283     0.200
    69.026    -0.672     0.200
    69.206     0.386     0.200
    69.584     1.434     0.200
    69.751     2.045     0.200
    69.751     2.342     0.200
    70.145    -2.581     0.200
    71.895    -4.282     0.200
    71.895    -3.977     0.200
    73.913    -5.027     0.200
    74.372    -3.281     0.200
    74.548    -0.826     0.200
    74.548    -0.622     0.200
    74.548    -0.474     0.200
    74.662    -0.307     0.200
    74.782    -3.286     0.200
    74.782    -3.490     0.200
    74.791    -2.028     0.200
    74.671    -1.438     0.200
    75.212    -0.981     0.200
    75.394    -2.307     0.200
    75.394    -2.003     0.200
    75.394    -2.831     0.200
    75.116     0.117     0.200
    75.719    -2.564     0.200
    75.871     0.642     0.200
    75.930    -0.676     0.200
    75.930    -0.066     0.200
    76.219    -0.912     0.200
    76.438    -0.674     0.200
    76.489    -1.021     0.200
    76.192     1.041     0.200
    76.716    -0.625     0.200
    77.196    -0.123     0.200
    77.274    -0.785     0.200
    77.414    -0.913     0.200
    77.414    -0.444     0.200
    77.188     1.923     0.200
    77.506    -1.260     0.200
    77.506    -0.940     0.200
    77.504     0.931     0.200
    77.724    -2.071     0.200
    77.925    -0.425     0.200
    78.080    -1.143     0.200
    78.399    -0.119     0.200
    78.636    -2.798     0.200
    78.636    -2.923     0.200
    78.524    -0.199     0.200
    78.729     0.096     0.200
    78.757     1.083     0.200
    78.874     1.159     0.200
    79.018     0.629     0.200
    79.025    -0.387     0.200
    79.139     0.609     0.200
    79.147     0.952     0.200
    78.921     1.568     0.200
    79.019     1.599     0.200
    79.345    -3.605     0.200
    81.085    -1.469     0.200
    81.314    -2.388     0.200
    81.280     0.173     0.200
    81.280    -0.210     0.200
    82.385    -1.716     0.200
    82.383    -0.953     0.200
    82.117    -0.126     0.200
    82.554    -1.902     0.200
    82.731    -2.720     0.200
    82.599     3.013     0.200
    83.048    -0.565     0.200
    83.048    -0.401     0.200
    83.217    -1.533     0.200
    83.593    -0.371     0.200
    83.841    -2.232     0.200
    84.217    -1.248     0.200
    85.101    -2.307     0.200
    85.439    -1.491     0.200
    85.439    -1.241     0.200
    85.699    -0.389     0.200
    86.109    -1.213     0.200
    86.400    -3.744     0.200
    86.400    -3.525     0.200
    86.319     0.155     0.200
    87.103     0.220     0.200
    86.868     1.464     0.200
    87.271    -0.291     0.200
    87.356    -1.005     0.200
    87.376    -0.704     0.200
    87.376    -0.579     0.200
    87.586     0.194     0.200
    87.664    -0.483     0.200
    87.706    -1.583     0.200
    87.702    -0.358     0.200
    87.736    -0.521     0.200
    87.758    -1.033     0.200
    87.776     0.085     0.200
    87.787    -0.364     0.200
    87.803    -0.244     0.200
    87.884    -0.531     0.200
    87.919    -0.596     0.200
    87.981    -0.889     0.200
    88.071    -1.813     0.200
    88.083     0.806     0.200
    88.083    -0.874     0.200
    88.097    -0.038     0.200
    88.230    -0.465     0.200
    88.285    -1.329     0.200
    88.285    -1.430     0.200
    88.296    -0.983     0.200
    88.356    -2.209     0.200
    88.364    -2.302     0.200
    88.364    -1.951     0.200
    88.471     0.796     0.200
    88.480     0.548     0.200
    88.581     1.677     0.200
    88.594    -1.183     0.200
    88.647     0.637     0.200
    88.660     0.803     0.200
    88.723    -0.495     0.200
    88.723    -1.097     0.200
    88.822     0.439     0.200
    88.855    -0.015     0.200
    88.864    -0.657     0.200
    88.905    -0.249     0.200
    88.907    -0.359     0.200
    88.929     0.435     0.200
    88.957    -1.095     0.200
    89.047    -0.519     0.200
    88.683     1.248     0.200
    89.313    -0.161     0.200
    89.388    -2.770     0.200
    89.419    -0.865     0.200
    89.435    -0.031     0.200
    89.454    -0.822     0.200
    89.452    -1.017     0.200
    89.462     0.037     0.200
    89.524    -0.947     0.200
    89.729    -1.507     0.200
    89.791    -0.398     0.200
    89.791    -0.695     0.200
    89.798    -1.636     0.200
    89.812    -1.398     0.200
    89.845    -1.353     0.200
    89.854    -1.794     0.200
    89.919    -0.896     0.200
    89.899    -1.105     0.200
    89.998    -0.763     0.200
    90.095    -1.820     0.200
    90.086    -1.980     0.200
    90.098    -2.433     0.200
    90.145    -1.448     0.200
    90.161    -1.422     0.200
    90.151    -2.479     0.200
    90.180    -1.613     0.200
    90.233    -0.061     0.200
    90.452    -0.686     0.200
    90.448    -2.064     0.200
    90.505    -2.625     0.200
    90.570     0.173     0.200
    90.695    -3.214     0.200
    90.695    -2.910     0.200
    90.668    -1.386     0.200
    90.329     1.561     0.200
    90.702    -0.441     0.200
    90.702    -0.745     0.200
    90.702    -2.542     0.200
    90.707    -0.169     0.200
    90.737    -2.104     0.200
    90.773    -2.272     0.200
    90.807    -0.631     0.200
    90.801    -2.107     0.200
    90.892    -1.201     0.200
    90.849    -2.830     0.200
    90.874    -2.740     0.200
    90.902    -1.974     0.200
    91.039    -2.210     0.200
    91.000    -0.930     0.200
    90.709     1.153     0.200
    91.065    -0.536     0.200
    91.149     0.076     0.200
    91.188    -1.215     0.200
    91.259    -1.262     0.200
    91.288    -1.164     0.200
    91.272    -0.494     0.200
    91.387    -0.120     0.200
    91.480    -0.053     0.200
    91.486    -0.484     0.200
    91.574    -1.793     0.200
    91.763    -0.567     0.200
    92.234    -0.448     0.200
    92.234    -0.346     0.200
    92.327    -0.968     0.200
    92.327    -1.070     0.200
    92.341    -1.035     0.200
    92.402    -0.521     0.200
    92.397    -0.494     0.200
    92.523    -1.953     0.200
    92.671    -1.965     0.200
    92.671    -1.864     0.200
    92.735    -2.297     0.200
    93.192    -0.833     0.200
    93.252    -0.542     0.200
    93.252    -1.643     0.200
    93.507    -1.910     0.200
    93.754    -0.853     0.200
    93.772    -0.832     0.200
    93.871    -2.993     0.200
    93.871    -2.829     0.200
    93.824    -1.970     0.200
    93.824    -0.993     0.200
    93.824    -1.173     0.200
    94.180    -1.309     0.200
    94.180    -1.176     0.200
    94.255    -2.449     0.200
    94.342    -2.702     0.200
    94.342    -2.554     0.200
    94.465    -1.616     0.200
    94.465    -1.116     0.200
    94.597    -1.323     0.200
    94.718    -2.489     0.200
    94.804    -3.042     0.200
    94.770    -1.709     0.200
    95.194    -1.148     0.200
    95.578    -1.000     0.200
    95.578    -0.821     0.200
    95.777    -0.215     0.200
    95.922    -2.718     0.200
    96.095    -0.853     0.200
    96.137    -0.976     0.200
    96.411    -1.894     0.200
    96.469    -1.356     0.200
    96.534    -0.747     0.200
    96.699    -0.955     0.200
    96.755    -1.014     0.200
    96.993    -0.940     0.200
    97.299    -0.738     0.200
    97.314    -1.111     0.200
    97.529    -2.050     0.200
    97.542    -0.506     0.200
    97.779    -3.098     0.200
    97.876    -2.721     0.200
    97.893    -2.398     0.200
    97.957    -1.351     0.200
    97.957    -1.172     0.200
    98.017    -1.043     0.200
    98.017    -0.747     0.200
    98.017    -1.559     0.200
    98.112    -1.172     0.200
    98.112    -1.718     0.200
    98.172    -3.401     0.200
    98.609    -2.047     0.200
    98.572    -1.132     0.200
    98.707    -1.704     0.200
    98.749    -2.329     0.200
    99.064    -2.839     0.200
    15.086     2.407     0.200
    16.149     1.669     0.200
    16.097     4.947     0.200
    16.970     1.356     0.200
    17.239     0.596     0.200
    17.239     1.995     0.200
    19.114    -2.206     0.200
    21.183    -0.030     0.200
    21.708     0.447     0.200
    21.708    -1.256     0.200
    22.087    -3.049     0.200
    23.310     0.409     0.200
    23.784    -0.111     0.200
    23.895    -2.801     0.200
    24.623     1.839     0.200
    24.922    -2.292     0.200
    25.105     1.348     0.200
    26.184    -2.700     0.200
    26.223    -3.723     0.200
    26.223    -2.582     0.200
    26.561    -2.575     0.200
    29.935    -0.717     0.200
    29.935    -0.721     0.200
    29.946    -0.882     0.200
    31.141    -0.258     0.200
    31.140    -0.644     0.200
    31.177     0.020     0.200
    31.205    -0.082     0.200
    31.973     0.881     0.200
    33.085     0.237     0.200
    33.306    -1.276     0.200
    33.513    -0.493     0.200
    34.122    -0.174     0.200
    35.220    -3.859     0.200
    36.663    -2.488     0.200
    36.622    -0.609     0.200
    37.616    -1.049     0.200
    39.222    -2.359     0.200
    40.253    -2.693     0.200
    40.398    -2.129     0.200
    40.665     0.066     0.200
    40.940    -0.411     0.200
    41.077     0.437     0.200
    45.283    -1.668     0.200
    45.956    -3.268     0.200
    46.425    -1.557     0.200
    47.661    -0.609     0.200
    48.332    -2.847     0.200
    48.332    -2.847     0.200
    53.210    -1.572     0.200
    54.098    -0.879     0.200
    54.423    -4.016     0.200
    54.423    -4.008     0.200
    55.553    -1.748     0.200
    57.553    -3.773     0.200
    57.577    -3.356     0.200
    57.577    -4.231     0.200
    57.577    -4.224     0.200
    57.577    -3.091     0.200
    57.577    -2.919     0.200
    58.294    -0.546     0.200
    58.710    -3.453     0.200
    59.421    -0.687     0.200
    60.005    -2.505     0.200
    62.190    -0.799     0.200
    62.419    -3.030     0.200
    63.258    -4.964     0.200
    63.258    -4.168     0.200
    63.261    -4.990     0.200
    63.296     0.845     0.200
    65.210     1.168     0.200
    66.786    -1.395     0.200
    66.958     0.158     0.200
    67.407     1.157     0.200
    67.407     1.375     0.200
    68.088    -0.537     0.200
    69.043    -3.912     0.200
    69.327     2.474     0.200
    69.327     1.146     0.200
    69.327     3.052     0.200
    75.517     1.931     0.200
    76.217    -0.066     0.200
    76.217     0.403     0.200
    77.056     1.690     0.200
    79.154     2.029     0.200
    80.333    -0.504     0.200
    81.390    -2.446     0.200
    81.390    -2.110     0.200
    81.390    -2.446     0.200
    81.390    -1.696     0.200
    83.163     1.909     0.200
    86.641     0.634     0.200
    86.708    -0.891     0.200
    86.831     2.203     0.200
    87.290    -2.679     0.200
    87.824    -0.493     0.200
    87.874    -0.528     0.200
    88.012    -1.283     0.200
    88.285    -0.977     0.200
    88.285    -0.836     0.200
    89.194    -1.274     0.200
    89.207    -1.139     0.200
    89.701    -1.131     0.200
    89.563     2.589     0.200
    89.563     2.346     0.200
    89.835    -1.963     0.200
    91.586     2.449     0.200
    91.736     1.402     0.200
    14.400     4.112     0.200
    16.631     2.605     0.200
    17.907     0.666     0.200
    18.265    -1.140     0.200
    18.685    -1.653     0.200
    19.399    -2.876     0.200
    19.083     0.998     0.200
    19.446     1.116     0.200
    19.976    -0.512     0.200
    20.667    -1.763     0.200
    21.147     0.063     0.200
    21.639    -2.520     0.200
    21.921     1.223     0.200
    21.921     0.082     0.200
    22.427    -0.233     0.200
    22.660    -0.591     0.200
    22.852    -2.004     0.200
    22.864    -2.409     0.200
    22.864    -1.636     0.200
    22.593     1.611     0.200
    23.070    -0.348     0.200
    23.054    -4.574     0.200
    23.148    -0.796     0.200
    23.336    -0.879     0.200
    23.498    -3.098     0.200
    23.546    -1.479     0.200
    23.859    -0.410     0.200
    23.545     1.254     0.200
    23.545     0.324     0.200
    23.940    -1.109     0.200
    23.958     0.408     0.200
    23.795    -0.069     0.200
    24.000    -2.284     0.200
    24.203    -3.910     0.200
    24.313    -3.139     0.200
    24.336    -3.736     0.200
    24.336    -3.353     0.200
    24.301     0.041     0.200
    24.301    -4.061     0.200
    24.301    -3.053     0.200
    24.376    -0.623     0.200
    24.409    -1.741     0.200
    24.443    -3.725     0.200
    24.496    -3.313     0.200
    24.779    -1.396     0.200
    24.849    -1.201     0.200
    25.147    -1.830     0.200
    25.194    -0.721     0.200
    25.131    -2.163     0.200
    25.328    -0.698     0.200
    25.469    -3.754     0.200
    25.484    -1.017     0.200
    25.562    -2.293     0.200
    25.186     2.806     0.200
    25.363    -0.956     0.200
    25.363    -1.385     0.200
    25.666    -1.843     0.200
    26.047    -0.036     0.200
    26.066    -1.204     0.200
    26.108     4.016     0.200
    26.065    -2.080     0.200
    26.558    -0.508     0.200
    26.583    -3.127     0.200
    26.622    -3.554     0.200
    26.622    -1.616     0.200
    26.622    -3.983     0.200
    26.242     0.941     0.200
    26.568    -2.087     0.200
    26.568    -0.697     0.200
    26.628    -1.272     0.200
    26.457     0.352     0.200
    26.961    -3.037     0.200
    26.964    -4.149     0.200
    26.964    -2.540     0.200
    26.964    -3.055     0.200
    27.073    -3.706     0.200
    27.461     1.554     0.200
    27.461     0.867     0.200
    27.623     0.603     0.200
    28.096     0.719     0.200
    28.642    -2.929     0.200
    29.098     1.792     0.200
    29.098     1.300     0.200
    29.098     1.971     0.200
    29.312    -2.462     0.200
    30.204     0.411     0.200
    30.204     0.422     0.200
    30.210    -0.479     0.200
    30.210    -0.049     0.200
    30.214    -0.079     0.200
    31.123     0.948     0.200
    31.123     0.510     0.200
    31.310     0.034     0.200
    31.309     0.608     0.200
    31.347    -0.545     0.200
    32.494    -2.247     0.200
    32.649    -0.790     0.200
    32.940     0.848     0.200
    33.680    -1.502     0.200
    33.737    -2.679     0.200
    34.101    -2.095     0.200
    34.305    -2.606     0.200
    34.415    -1.673     0.200
    34.957    -2.851     0.200
    34.957    -2.258     0.200
    35.262    -2.506     0.200
    35.084     0.717     0.200
    35.524    -3.710     0.200
    35.524    -4.514     0.200
    35.524    -2.436     0.200
    35.791    -3.103     0.200
    36.628    -0.871     0.200
    36.628    -1.691     0.200
    36.691    -2.797     0.200
    37.121    -0.399     0.200
    37.121    -0.681     0.200
    37.626    -3.280     0.200
    37.663     0.264     0.200
    37.663    -0.049     0.200
    38.166    -3.794     0.200
    38.531    -3.168     0.200
    38.595    -2.604     0.200
    38.775    -2.286     0.200
    38.971    -2.854     0.200
    38.825     0.840     0.200
    39.125    -0.973     0.200
    39.552    -2.701     0.200
    39.552    -3.099     0.200
    39.552    -2.451     0.200
    39.764    -2.768     0.200
    40.058    -3.310     0.200
    40.069    -3.401     0.200
    40.121    -2.833     0.200
    40.236    -3.080     0.200
    39.999     1.004     0.200
    40.304    -3.139     0.200
    40.346    -1.389     0.200
    40.346    -2.553     0.200
    40.831    -0.385     0.200
    40.802    -0.187     0.200
    40.802    -0.726     0.200
    41.136    -2.309     0.200
    41.117    -2.743     0.200
    41.008     0.991     0.200
    41.008     0.726     0.200
    41.325    -3.759     0.200
    41.306    -2.296     0.200
    41.147     1.133     0.200
    41.511    -2.887     0.200
    41.697    -2.804     0.200
    41.604    -0.834     0.200
    41.840     2.969     0.200
    43.316    -2.562     0.200
    43.816     1.556     0.200
    44.123     1.332     0.200
    44.650    -3.760     0.200
    44.853     1.391     0.200
    45.302    -2.940     0.200
    45.341    -3.542     0.200
    46.091    -2.110     0.200
    46.077    -1.674     0.200
    46.768    -2.904     0.200
    46.563     1.419     0.200
    46.563     0.732     0.200
    46.776    -0.904     0.200
    46.935    -2.481     0.200
    46.724     2.913     0.200
    46.724     0.311     0.200
    47.199    -2.634     0.200
    47.332     1.618     0.200
    47.931    -2.616     0.200
    47.982    -1.819     0.200
    48.134    -2.841     0.200
    48.156    -3.266     0.200
    48.305    -2.504     0.200
    48.208     0.990     0.200
    48.529    -2.534     0.200
    48.462     2.171     0.200
    48.462     0.757     0.200
    48.476     1.720     0.200
    49.113    -2.441     0.200
    49.113    -2.769     0.200
    49.113    -2.769     0.200
    49.147    -2.824     0.200
    48.994     2.441     0.200
    49.064     2.657     0.200
    50.342     2.389     0.200
    50.671     1.436     0.200
    51.283    -2.437     0.200
    51.644    -4.412     0.200
    53.177    -4.629     0.200
    53.177    -5.004     0.200
    53.177    -4.694     0.200
    53.177    -4.767     0.200
    53.415    -1.086     0.200
    53.602    -2.421     0.200
    53.602    -2.600     0.200
    53.954    -4.097     0.200
    54.318    -3.852     0.200
    54.388    -1.908     0.200
    55.012    -2.679     0.200
    55.012    -2.679     0.200
    55.050    -2.577     0.200
    55.050    -2.850     0.200
    55.050    -2.741     0.200
    55.281    -2.195     0.200
    55.378     0.126     0.200
    55.655    -1.807     0.200
    55.633    -2.645     0.200
    55.831    -2.852     0.200
    55.876    -1.353     0.200
    55.958    -3.082     0.200
    56.010    -3.604     0.200
    55.919     0.727     0.200
    56.360    -3.449     0.200
    56.377    -3.091     0.200
    56.510    -3.688     0.200
    56.510    -3.438     0.200
    56.684    -2.460     0.200
    56.706    -3.111     0.200
    56.777    -3.311     0.200
    56.909    -3.844     0.200
    56.792     1.243     0.200
    57.136    -2.307     0.200
    57.203    -3.042     0.200
    57.279    -2.650     0.200
    57.293    -2.285     0.200
    57.440    -1.572     0.200
    57.327     0.237     0.200
    57.468    -2.477     0.200
    57.468    -2.727     0.200
    57.468    -1.954     0.200
    57.543    -2.685     0.200
    57.607    -3.670     0.200
    57.496    -0.184     0.200
    57.639    -3.057     0.200
    57.546     0.956     0.200
    57.671    -3.721     0.200
    57.723    -3.542     0.200
    57.732    -3.756     0.200
    57.815    -2.551     0.200
    57.905    -3.474     0.200
    57.929    -3.565     0.200
    57.929    -3.487     0.200
    57.929    -3.487     0.200
    57.963    -3.165     0.200
    58.043    -3.553     0.200
    58.101    -0.052     0.200
    58.129     0.021     0.200
    58.133     0.042     0.200
    58.212    -1.204     0.200
    58.212    -1.079     0.200
    58.079    -0.078     0.200
    58.094     2.670     0.200
    58.352    -0.186     0.200
    58.535     0.209     0.200
    58.535     0.061     0.200
    58.587     0.013     0.200
    58.587    -0.175     0.200
    58.682    -0.094     0.200
    58.697     0.293     0.200
    58.697     0.090     0.200
    58.894    -4.468     0.200
    58.894    -2.163     0.200
    58.894    -2.483     0.200
    59.001    -2.802     0.200
    59.038    -2.559     0.200
    58.949    -0.272     0.200
    58.949    -0.467     0.200
    59.230    -2.695     0.200
    58.854    -0.833     0.200
    59.441    -3.254     0.200
    59.561    -3.077     0.200
    59.569    -4.032     0.200
    59.701    -3.454     0.200
    59.701    -3.493     0.200
    59.939     0.325     0.200
    62.489    -3.260     0.200
    62.540    -3.619     0.200
    62.540    -3.276     0.200
    63.224    -3.574     0.200
    63.224    -3.324     0.200
    63.384    -1.284     0.200
    63.384    -1.706     0.200
    63.529    -2.938     0.200
    63.661    -4.307     0.200
    63.680    -3.751     0.200
    63.680    -4.032     0.200
    63.680    -3.931     0.200
    63.684    -4.058     0.200
    64.063    -3.360     0.200
    64.828     2.252     0.200
    65.344    -4.704     0.200
    65.023     1.799     0.200
    65.335     0.401     0.200
    65.335     1.041     0.200
    65.468     1.443     0.200
    65.814     0.965     0.200
    66.066    -0.565     0.200
    66.519     0.332     0.200
    66.668     1.580     0.200
    66.668     1.681     0.200
    66.668     1.236     0.200
    67.138    -3.497     0.200
    66.984    -0.440     0.200
    66.984     0.583     0.200
    66.988     0.064     0.200
    67.346    -3.021     0.200
    67.346    -3.052     0.200
    67.060     0.389     0.200
    67.412    -2.797     0.200
    67.412    -3.031     0.200
    67.133     0.932     0.200
    67.518     2.254     0.200
    67.505     1.487     0.200
    67.606    -0.323     0.200
    67.606     0.239     0.200
    67.668     0.336     0.200
    67.668     0.625     0.200
    67.946     0.081     0.200
    67.946     0.628     0.200
    68.072     1.940     0.200
    68.118     1.006     0.200
    68.205    -0.582     0.200
    68.352     1.580     0.200
    68.388     2.489     0.200
    68.447     2.152     0.200
    68.523     0.457     0.200
    68.523    -0.270     0.200
    68.543    -0.597     0.200
    68.728     2.121     0.200
    68.872    -0.978     0.200
    68.932     0.313     0.200
    68.932     2.149     0.200
    68.937     1.195     0.200
    69.238    -2.360     0.200
    69.238    -2.118     0.200
    69.196    -0.078     0.200
    69.206    -0.812     0.200
    69.293     0.304     0.200
    69.440     1.724     0.200
    69.446     0.133     0.200
    69.568     1.752     0.200
    69.593     1.477     0.200
    69.597     1.603     0.200
    69.739     0.760     0.200
    69.769     0.092     0.200
    69.779     0.607     0.200
    69.980     0.247     0.200
    70.275    -0.216     0.200
    70.275     1.073     0.200
    70.280     0.472     0.200
    70.663     0.340     0.200
    70.951    -2.203     0.200
    71.644    -4.342     0.200
    71.539     0.431     0.200
    73.134    -1.429     0.200
    73.512    -0.633     0.200
    73.512    -1.203     0.200
    73.512    -0.352     0.200
    73.512    -0.821     0.200
    73.674    -1.299     0.200
    73.794    -0.501     0.200
    73.959    -1.471     0.200
    74.018    -0.417     0.200
    74.128    -3.263     0.200
    74.187    -2.036     0.200
    74.466    -3.225     0.200
    74.468    -3.240     0.200
    74.549    -1.997     0.200
    74.549    -2.106     0.200
    74.884    -3.229     0.200
    74.884    -3.346     0.200
    74.790    -0.606     0.200
    74.866    -0.443     0.200
    74.866    -2.271     0.200
    74.849     1.712     0.200
    74.849     1.485     0.200
    75.245    -0.926     0.200
    75.348    -0.819     0.200
    75.253     0.630     0.200
    75.439     0.760     0.200
    75.474    -0.545     0.200
    75.664    -2.987     0.200
    75.664    -3.128     0.200
    75.787    -0.429     0.200
    75.719     2.139     0.200
    75.719     1.663     0.200
    75.753     1.143     0.200
    75.753    -0.341     0.200
    75.753     0.362     0.200
    76.178    -0.151     0.200
    76.202    -1.892     0.200
    76.198    -0.973     0.200
    76.259    -1.021     0.200
    76.422    -0.841     0.200
    76.486     0.199     0.200
    76.492    -1.606     0.200
    76.492    -1.114     0.200
    76.317     1.776     0.200
    76.317     0.307     0.200
    76.317     1.510     0.200
    76.538     0.960     0.200
    76.667    -0.728     0.200
    76.720    -1.126     0.200
    76.748    -0.789     0.200
    76.840    -0.401     0.200
    76.833     0.031     0.200
    77.364     0.559     0.200
    77.412     0.288     0.200
    77.412    -0.517     0.200
    77.637    -2.816     0.200
    77.868    -0.353     0.200
    77.993     1.027     0.200
    78.125    -1.080     0.200
    78.210    -0.856     0.200
    78.323    -3.171     0.200
    78.544    -3.195     0.200
    78.336     2.615     0.200
    78.336     1.826     0.200
    78.336     0.841     0.200
    78.336     2.279     0.200
    78.851    -0.388     0.200
    78.928    -0.811     0.200
    78.926    -0.592     0.200
    79.012    -1.065     0.200
    79.428    -1.234     0.200
    79.530    -1.094     0.200
    79.791    -1.634     0.200
    79.819    -1.161     0.200
    80.063    -1.678     0.200
    80.117    -2.069     0.200
    80.199    -0.222     0.200
    80.199     1.387     0.200
    80.199    -0.409     0.200
    80.346    -4.008     0.200
    80.346    -4.407     0.200
    80.295    -0.232     0.200
    80.281    -0.850     0.200
    80.319    -0.655     0.200
    80.345     1.700     0.200
    80.496     1.890     0.200
    80.589     0.493     0.200
    80.734    -1.087     0.200
    80.829     0.805     0.200
    80.894    -1.168     0.200
    80.966    -1.520     0.200
    81.325    -1.028     0.200
    81.325    -1.068     0.200
    81.325    -1.028     0.200
    81.591    -2.336     0.200
    81.599    -0.680     0.200
    81.745    -1.849     0.200
    81.728    -0.558     0.200
    81.728    -0.965     0.200
    81.990    -1.176     0.200
    81.990    -0.340     0.200
    81.995    -1.571     0.200
    82.267    -1.688     0.200
    82.569    -0.768     0.200
    82.575     0.780     0.200
    83.001    -3.611     0.200
    84.178    -2.441     0.200
    84.507    -1.560     0.200
    84.507    -1.208     0.200
    84.507    -1.708     0.200
    84.700    -0.084     0.200
    84.738     0.025     0.200
    84.810    -0.146     0.200
    85.277    -2.078     0.200
    85.277    -1.977     0.200
    85.234     0.277     0.200
    85.234     0.535     0.200
    86.297    -3.779     0.200
    86.242    -0.259     0.200
    86.267    -0.781     0.200
    86.059     0.580     0.200
    86.311    -0.097     0.200
    86.341    -0.897     0.200
    86.341    -0.452     0.200
    86.629    -0.365     0.200
    86.690    -2.458     0.200
    86.687    -0.241     0.200
    86.706    -0.238     0.200
    86.731     0.044     0.200
    86.758     0.006     0.200
    86.756    -1.814     0.200
    86.756    -0.182     0.200
    86.801    -0.001     0.200
    86.840    -0.396     0.200
    86.997     0.624     0.200
    87.241    -4.341     0.200
    87.237    -1.432     0.200
    87.237    -0.722     0.200
    87.310     0.323     0.200
    87.370    -2.060     0.200
    87.370    -1.764     0.200
    87.378    -1.802     0.200
    87.378    -1.505     0.200
    87.378    -1.966     0.200
    87.378    -2.099     0.200
    87.399    -2.082     0.200
    87.437     0.812     0.200
    87.453     0.636     0.200
    87.455     0.125     0.200
    87.550     0.268     0.200
    87.570    -0.523     0.200
    87.581     1.119     0.200
    87.573     0.556     0.200
    87.665    -0.780     0.200
    87.777    -1.926     0.200
    87.678    -1.638     0.200
    87.789     0.931     0.200
    87.818    -0.411     0.200
    87.828     0.341     0.200
    87.853    -0.577     0.200
    87.878     0.308     0.200
    87.893     0.633     0.200
    87.992    -0.633     0.200
    88.025    -0.094     0.200
    88.100     0.651     0.200
    88.164    -0.754     0.200
    88.237    -0.294     0.200
    88.282    -0.162     0.200
    88.282     0.096     0.200
    88.304     0.083     0.200
    88.379    -0.064     0.200
    88.393    -0.431     0.200
    88.484    -0.163     0.200
    88.493    -0.308     0.200
    88.518    -0.521     0.200
    88.664    -1.013     0.200
    88.719    -1.569     0.200
    88.752    -0.529     0.200
    88.763    -0.273     0.200
    88.765    -1.285     0.200
    88.778    -1.150     0.200
    88.817    -1.128     0.200
    88.835    -0.615     0.200
    88.887    -0.858     0.200
    88.946    -0.636     0.200
    88.944    -1.225     0.200
    89.054    -0.143     0.200
    89.074    -1.238     0.200
    89.087    -0.500     0.200
    89.100    -1.462     0.200
    89.097    -1.445     0.200
    89.106    -1.887     0.200
    89.114    -1.822     0.200
    89.200    -2.633     0.200
    89.160    -0.345     0.200
    88.818     1.810     0.200
    88.818     0.458     0.200
    89.234    -0.149     0.200
    89.224    -1.245     0.200
    89.374    -1.746     0.200
    89.368    -0.614     0.200
    89.389     1.187     0.200
    89.430    -1.606     0.200
    89.480    -0.239     0.200
    89.492    -0.698     0.200
    89.612    -0.755     0.200
    89.624    -1.619     0.200
    89.650    -0.636     0.200
    89.650     0.067     0.200
    89.650    -0.535     0.200
    89.686     0.497     0.200
    89.660    -0.583     0.200
    89.685    -1.403     0.200
    89.692    -0.124     0.200
    89.746    -1.089     0.200
    89.773    -0.410     0.200
    89.774    -0.717     0.200
    89.828    -2.867     0.200
    89.794    -0.609     0.200
    89.826     2.039     0.200
    89.895    -1.050     0.200
    89.946    -1.456     0.200
    89.929     0.262     0.200
    89.988     0.183     0.200
    90.017    -1.752     0.200
    90.068    -0.092     0.200
    90.125     0.645     0.200
    90.147     0.440     0.200
    90.242    -1.200     0.200
    90.241    -1.335     0.200
    90.195     0.217     0.200
    90.243    -2.194     0.200
    90.238     0.218     0.200
    90.343    -1.382     0.200
    90.370     0.106     0.200
    90.421    -1.134     0.200
    90.451     0.327     0.200
    90.576    -1.456     0.200
    90.615    -0.832     0.200
    90.660    -1.643     0.200
    90.697    -1.310     0.200
    90.739    -0.214     0.200
    90.732    -0.181     0.200
    90.774    -0.798     0.200
    90.839    -1.209     0.200
    90.885    -1.360     0.200
    90.886    -0.896     0.200
    90.912    -0.518     0.200
    90.919     0.150     0.200
    90.936    -0.129     0.200
    91.084    -1.669     0.200
    91.084    -0.614     0.200
    91.092     0.046     0.200
    90.839     1.143     0.200
    91.180    -1.200     0.200
    91.232    -1.050     0.200
    91.293    -0.583     0.200
    91.297    -0.600     0.200
    91.330     0.244     0.200
    90.994     1.359     0.200
    91.367    -0.428     0.200
    91.532    -1.590     0.200
    91.640    -2.036     0.200
    91.641    -1.899     0.200
    91.641    -1.899     0.200
    91.708    -2.255     0.200
    91.708    -1.919     0.200
    91.731    -0.415     0.200
    92.511    -0.421     0.200
    92.511    -1.218     0.200
    92.511    -0.866     0.200
    92.531    -1.114     0.200
    92.748    -0.664     0.200
    92.827    -1.635     0.200
    92.786    -1.207     0.200
    92.806    -1.038     0.200
    92.806    -0.679     0.200
    92.806    -1.632     0.200
    92.949    -1.440     0.200
    93.072    -1.908     0.200
    93.096    -1.314     0.200
    93.226    -2.014     0.200
    93.180    -0.943     0.200
    93.252    -0.937     0.200
    93.432    -1.363     0.200
    93.432    -1.527     0.200
    93.561    -2.661     0.200
    93.561    -2.661     0.200
    93.561    -2.489     0.200
    93.582    -1.359     0.200
    94.000     0.722     0.200
    94.027    -1.264     0.200
    94.190    -2.151     0.200
    94.260    -2.731     0.200
    94.199    -0.090     0.200
    94.284    -0.974     0.200
    94.284    -0.279     0.200
    94.380    -1.743     0.200
    94.392    -0.477     0.200
    94.486    -2.752     0.200
    94.573    -2.056     0.200
    94.573    -0.806     0.200
    94.573    -1.306     0.200
    94.600    -1.432     0.200
    94.698     1.118     0.200
    94.945    -3.191     0.200
    95.047    -3.041     0.200
    95.092    -0.681     0.200
    95.112    -2.479     0.200
    95.248    -1.398     0.200
    95.411    -0.739     0.200
    95.472    -0.910     0.200
    95.502    -0.742     0.200
    95.600    -0.105     0.200
    95.622    -0.202     0.200
    95.673    -0.844     0.200
    95.717    -1.112     0.200
    95.858    -3.020     0.200
    95.902    -1.469     0.200
    95.963    -1.012     0.200
    96.075    -1.913     0.200
    96.029    -1.166     0.200
    96.276    -2.678     0.200
    96.264    -0.820     0.200
    96.283    -1.006     0.200
    96.525    -1.205     0.200
    96.567    -2.569     0.200
    96.576    -1.648     0.200
    96.960    -1.715     0.200
    97.003    -1.760     0.200
    97.003    -0.990     0.200
    97.003    -1.044     0.200
    97.085    -2.818     0.200
    97.122    -3.048     0.200
    97.122    -2.930     0.200
    97.122    -3.345     0.200
    97.100    -3.107     0.200
    97.257    -3.621     0.200
    97.269    -2.613     0.200
    97.340    -3.238     0.200
    97.500    -2.340     0.200
    97.573    -0.445     0.200
    97.729    -2.638     0.200
    97.698    -1.209     0.200
    97.880    -2.301     0.200
    97.919    -2.284     0.200
    98.360    -2.441     0.200
    98.490    -1.500     0.200
    98.576    -2.166     0.200
    98.657    -1.820     0.200
    98.682    -1.165     0.200
    98.733    -2.552     0.200
    98.733    -2.591     0.200
    98.946    -1.682     0.200
    98.950    -0.869     0.200
    98.929    -1.154     0.200
    99.241    -2.716     0.200
    99.508    -1.013     0.200
    15.265     1.739     0.200
    16.609     1.090     0.200
    17.084     0.937     0.200
    19.795    -1.778     0.200
    20.539     0.738     0.200
    22.631    -1.422     0.200
    22.674     1.593     0.200
    24.224    -0.208     0.200
    25.619    -3.452     0.200
    27.410    -4.119     0.200
    27.748    -5.411     0.200
    29.024     0.104     0.200
    29.037    -0.643     0.200
    29.037     0.252     0.200
    29.048     0.117     0.200
    29.221     0.372     0.200
    30.065     1.216     0.200
    30.153     0.112     0.200
    30.153     0.498     0.200
    34.617     0.409     0.200
    35.986    -0.534     0.200
    36.566     0.754     0.200
    39.845     0.753     0.200
    40.018     0.773     0.200
    40.018     1.148     0.200
    45.397     0.477     0.200
    47.081     2.169     0.200
    48.730    -0.874     0.200
    49.194    -2.829     0.200
    54.402    -1.060     0.200
    55.277    -0.894     0.200
    55.535    -3.088     0.200
    56.607    -4.558     0.200
    56.607    -3.288     0.200
    58.298     0.725     0.200
    58.766    -4.005     0.200
    58.766    -4.361     0.200
    63.379    -3.657     0.200
    64.439    -4.404     0.200
    64.439    -5.035     0.200
    64.439    -4.674     0.200
    64.464    -3.771     0.200
    68.295    -2.902     0.200
    69.140     0.688     0.200
    70.217    -2.616     0.200
    75.047     0.057     0.200
    75.047     0.313     0.200
    75.466    -3.726     0.200
    75.909    -3.150     0.200
    76.123     1.641     0.200
    77.344    -2.290     0.200
    82.450    -1.435     0.200
    82.450    -2.846     0.200
    88.427    -1.289     0.200
    88.632    -0.118     0.200
    92.595    -2.282     0.200
    94.414    -3.226     0.200
    16.371     1.266     0.200
    16.595     2.701     0.200
    18.046    -1.240     0.200
    18.025    -2.552     0.200
    18.025    -0.712     0.200
    18.394    -1.997     0.200
    19.754    -0.444     0.200
    19.754    -2.643     0.200
    20.502    -1.263     0.200
    21.467    -1.955     0.200
    21.662     0.851     0.200
    22.632    -1.819     0.200
    22.632     0.142     0.200
    22.723     0.004     0.200
    24.215    -1.832     0.200
    24.215     0.089     0.200
    25.483    -0.638     0.200
    25.584    -3.786     0.200
    25.584    -0.356     0.200
    26.523     1.057     0.200
    27.054    -3.272     0.200
    27.357    -3.087     0.200
    27.357    -3.759     0.200
    27.695    -4.689     0.200
    28.687    -3.966     0.200
    29.030    -1.474     0.200
    29.044     0.140     0.200
    29.044    -1.750     0.200
    29.050    -0.276     0.200
    29.050     0.482     0.200
    29.054     0.116     0.200
    29.227    -0.116     0.200
    30.099     2.392     0.200
    30.168     0.368     0.200
    30.168     0.435     0.200
    30.168     0.615     0.200
    33.564     1.177     0.200
    33.725    -3.039     0.200
    33.731     1.227     0.200
    33.922     1.268     0.200
    34.290    -4.572     0.200
    34.889    -3.086     0.200
    36.362    -3.958     0.200
    36.595    -1.474     0.200
    36.595     0.788     0.200
    36.820     1.368     0.200
    37.496     1.642     0.200
    37.665     1.413     0.200
    39.695    -0.053     0.200
    39.695    -0.729     0.200
    39.846     0.646     0.200
    39.846    -1.854     0.200
    39.846     1.247     0.200
    40.041     1.424     0.200
    40.041     0.955     0.200
    40.363    -2.787     0.200
    42.754     2.184     0.200
    43.000     1.694     0.200
    47.521    -1.531     0.200
    49.126    -3.457     0.200
    55.406    -2.257     0.200
    55.472    -1.932     0.200
    55.472    -3.233     0.200
    55.500    -2.529     0.200
    56.539    -2.525     0.200
    58.716    -3.608     0.200
    58.716    -3.268     0.200
    58.716    -3.608     0.200
    58.833    -2.904     0.200
    63.147    -3.934     0.200
    63.329    -2.679     0.200
    64.384    -4.049     0.200
    64.384    -4.049     0.200
    64.433    -0.758     0.200
    68.247    -2.926     0.200
    70.175    -2.709     0.200
    71.885    -5.246     0.200
    71.887    -1.535     0.200
    75.104     0.536     0.200
    75.420    -2.919     0.200
    80.671    -3.966     0.200
    82.116    -1.298     0.200
    82.427    -0.605     0.200
    82.427    -2.675     0.200
    86.382    -3.512     0.200
    88.393    -1.328     0.200
    90.272    -0.010     0.200
    90.289    -0.146     0.200
    92.552    -2.141     0.200
    22.213     0.462     0.200
    28.685    -0.468     0.200
    28.704     0.301     0.200
    28.704    -0.308     0.200
    28.714    -0.101     0.200
    29.946     1.101     0.200
    39.933     0.122     0.200
    39.933    -0.237     0.200
    47.958     0.445     0.200
    53.945    -0.024     0.200
    55.664    -1.954     0.200
    58.351    -2.583     0.200
    58.351    -2.198     0.200
    62.918    -2.397     0.200
    69.990    -3.156     0.200
    13.828     3.374     0.200
    15.876     1.943     0.200
    15.822     1.542     0.200
    17.320     0.566     0.200
    18.523    -3.411     0.200
    18.408    -0.138     0.200
    19.900    -2.587     0.200
    19.900    -0.877     0.200
    19.967    -1.303     0.200
    19.967    -1.503     0.200
    20.708     0.658     0.200
    20.852     1.281     0.200
    20.852     0.586     0.200
    21.629     1.472     0.200
    21.629     1.252     0.200
    21.855    -0.860     0.200
    22.251    -0.725     0.200
    22.251     0.115     0.200
    22.251    -2.985     0.200
    22.856    -3.192     0.200
    22.658     1.625     0.200
    22.658     0.085     0.200
    22.748     0.016     0.200
    22.748    -1.234     0.200
    22.748     1.446     0.200
    23.189    -3.321     0.200
    23.189    -1.201     0.200
    23.185    -2.651     0.200
    23.507    -3.615     0.200
    23.955    -2.076     0.200
    24.056    -4.362     0.200
    24.221    -2.548     0.200
    24.221    -2.138     0.200
    24.359     0.652     0.200
    24.359    -1.033     0.200
    24.359     0.807     0.200
    24.302     1.447     0.200
    24.302     1.627     0.200
    25.348    -2.490     0.200
    25.382     0.621     0.200
    25.382     0.501     0.200
    25.629    -1.171     0.200
    25.629    -0.340     0.200
    25.563     1.024     0.200
    25.563     2.254     0.200
    26.173    -3.862     0.200
    26.563     0.589     0.200
    26.563     0.919     0.200
    26.590     0.347     0.200
    26.590     0.132     0.200
    26.590     1.372     0.200
    26.590    -0.083     0.200
    26.590     0.897     0.200
    27.041     0.416     0.200
    27.066    -1.013     0.200
    27.137     1.269     0.200
    27.439    -3.920     0.200
    27.439    -4.260     0.200
    27.778    -4.807     0.200
    27.778    -4.087     0.200
    28.784    -3.512     0.200
    29.313    -4.128     0.200
    29.130    -1.524     0.200
    29.141    -0.258     0.200
    29.141     0.057     0.200
    29.148     0.264     0.200
    29.152    -0.403     0.200
    29.325    -0.239     0.200
    30.165     2.216     0.200
    30.165     2.346     0.200
    30.101     0.929     0.200
    30.101     0.104     0.200
    30.101     1.784     0.200
    30.239    -0.025     0.200
    30.239     0.691     0.200
    30.239     0.110     0.200
    30.277     1.131     0.200
    31.648    -1.761     0.200
    33.669    -2.191     0.200
    33.614     1.037     0.200
    33.834     0.825     0.200
    33.925    -2.849     0.200
    33.761     0.964     0.200
    34.026     0.952     0.200
    34.026     0.757     0.200
    34.076     3.039     0.200
    34.076     2.596     0.200
    34.273    -2.977     0.200
    34.272    -3.888     0.200
    34.272    -2.868     0.200
    34.254    -1.311     0.200
    34.490    -2.897     0.200
    34.490    -2.057     0.200
    34.672    -3.829     0.200
    36.419    -3.616     0.200
    36.419    -2.399     0.200
    36.467    -2.736     0.200
    36.618    -0.023     0.200
    36.618    -0.318     0.200
    36.618     0.482     0.200
    36.863     0.994     0.200
    37.687    -0.559     0.200
    37.560     2.081     0.200
    37.789     1.240     0.200
    38.156    -3.088     0.200
    38.156    -2.888     0.200
    38.820    -0.923     0.200
    38.948     0.977     0.200
    39.472    -4.071     0.200
    39.745    -3.739     0.200
    39.920    -3.093     0.200
    39.863    -0.879     0.200
    39.863     0.581     0.200
    39.863     0.981     0.200
    39.863    -1.019     0.200
    39.863    -0.649     0.200
    39.962     0.107     0.200
    39.962     2.657     0.200
    39.962     1.217     0.200
    39.980     1.906     0.200
    39.980     3.411     0.200
    40.085     0.963     0.200
    40.085     0.348     0.200
    40.085     1.138     0.200
    40.404    -3.734     0.200
    40.404    -1.704     0.200
    40.427    -3.356     0.200
    40.427    -2.351     0.200
    40.304     2.525     0.200
    40.712    -3.451     0.200
    41.015    -3.841     0.200
    41.026    -3.232     0.200
    41.071    -3.603     0.200
    40.932     1.341     0.200
    41.195    -3.325     0.200
    41.251    -2.379     0.200
    41.466     0.058     0.200
    41.753    -3.895     0.200
    41.874    -4.188     0.200
    42.088    -3.633     0.200
    42.478    -3.801     0.200
    42.672    -1.382     0.200
    42.671    -3.473     0.200
    42.774     1.539     0.200
    42.774     2.194     0.200
    43.055     1.537     0.200
    43.961     1.122     0.200
    44.077     1.092     0.200
    45.046    -3.541     0.200
    45.414    -2.957     0.200
    45.499     0.098     0.200
    45.499    -1.049     0.200
    45.499     1.371     0.200
    45.777    -3.225     0.200
    45.623     1.093     0.200
    45.677     0.723     0.200
    45.677    -0.774     0.200
    45.677     0.966     0.200
    46.872    -3.282     0.200
    47.014     1.971     0.200
    47.147    -1.097     0.200
    47.147     2.133     0.200
    47.147     1.783     0.200
    47.396    -2.644     0.200
    47.335     1.264     0.200
    47.392     0.591     0.200
    47.392    -0.556     0.200
    47.392     1.224     0.200
    47.415    -0.105     0.200
    47.415    -0.252     0.200
    47.637    -3.279     0.200
    48.190    -2.817     0.200
    48.190    -2.657     0.200
    48.471    -0.824     0.200
    48.569    -5.015     0.200
    48.569    -2.075     0.200
    48.569    -3.255     0.200
    48.591    -2.649     0.200
    48.668    -3.240     0.200
    48.820     0.793     0.200
    48.811    -3.288     0.200
    48.811    -2.938     0.200
    48.906    -3.173     0.200
    48.906    -3.306     0.200
    48.901    -2.136     0.200
    49.325    -2.646     0.200
    49.325    -2.666     0.200
    49.371    -2.809     0.200
    50.928    -0.914     0.200
    50.928     2.281     0.200
    50.928     2.135     0.200
    51.129    -1.170     0.200
    51.129    -1.945     0.200
    51.923    -4.258     0.200
    52.286    -2.763     0.200
    52.286    -1.983     0.200
    52.286    -2.603     0.200
    52.350    -2.826     0.200
    53.214    -4.073     0.200
    53.214    -4.753     0.200
    53.215    -4.690     0.200
    53.215    -3.359     0.200
    54.268    -4.121     0.200
    54.430    -2.798     0.200
    55.165    -3.190     0.200
    55.269    -4.768     0.200
    55.309     1.432     0.200
    55.405    -2.775     0.200
    55.405    -1.862     0.200
    55.479     1.476     0.200
    55.567    -4.609     0.200
    55.611    -3.597     0.200
    55.611    -3.087     0.200
    55.641    -3.019     0.200
    55.641    -2.588     0.200
    55.641    -2.139     0.200
    55.641    -2.759     0.200
    55.882     1.178     0.200
    55.989     0.392     0.200
    56.273    -3.890     0.200
    56.273    -3.460     0.200
    56.273    -3.010     0.200
    56.449     1.142     0.200
    56.486     2.125     0.200
    56.570    -2.688     0.200
    56.603    -3.811     0.200
    56.532    -3.238     0.200
    56.736    -3.845     0.200
    56.736    -1.955     0.200
    56.736    -3.755     0.200
    56.842     1.059     0.200
    56.786    -1.667     0.200
    56.989     1.141     0.200
    57.043    -3.540     0.200
    57.121    -3.263     0.200
    57.267    -3.792     0.200
    57.400     0.920     0.200
    57.623    -0.857     0.200
    57.638    -3.436     0.200
    57.697    -3.672     0.200
    57.683     1.071     0.200
    57.829    -3.914     0.200
    57.890    -3.901     0.200
    57.853     0.916     0.200
    58.079    -3.578     0.200
    58.113    -2.614     0.200
    58.134    -3.733     0.200
    58.134    -4.103     0.200
    58.154    -3.845     0.200
    58.168    -4.680     0.200
    58.216    -3.187     0.200
    58.242    -3.857     0.200
    58.233    -2.995     0.200
    58.221     0.758     0.200
    58.270    -2.900     0.200
    58.293    -3.253     0.200
    58.388    -2.966     0.200
    58.408    -1.569     0.200
    58.408    -2.329     0.200
    58.408    -3.317     0.200
    58.408    -2.895     0.200
    58.408    -1.419     0.200
    58.408    -3.009     0.200
    58.389     0.251     0.200
    58.225     0.080     0.200
    58.482    -2.599     0.200
    58.565    -3.732     0.200
    58.575    -2.718     0.200
    58.591    -4.370     0.200
    58.566    -0.600     0.200
    58.566     0.423     0.200
    58.656    -3.626     0.200
    58.605     0.614     0.200
    58.759    -2.888     0.200
    58.787    -4.034     0.200
    58.787    -4.254     0.200
    58.787    -3.894     0.200
    58.787    -3.785     0.200
    58.904    -3.324     0.200
    58.745     1.809     0.200
    58.986    -3.187     0.200
    58.896    -1.080     0.200
    58.896     0.690     0.200
    58.922     0.332     0.200
    59.172     0.142     0.200
    59.172     0.821     0.200
    59.198    -2.385     0.200
    59.198    -0.683     0.200
    59.198     0.239     0.200
    59.198     0.065     0.200
    59.199     0.065     0.200
    59.199     0.724     0.200
    59.203     0.365     0.200
    59.203     0.761     0.200
    59.287    -0.219     0.200
    59.384     2.552     0.200
    59.422     0.385     0.200
    59.427     0.561     0.200
    59.370    -1.861     0.200
    59.567    -1.556     0.200
    59.659    -0.485     0.200
    59.605     0.654     0.200
    59.650    -2.701     0.200
    59.657     0.102     0.200
    59.657     0.835     0.200
    59.751     0.623     0.200
    59.767     0.260     0.200
    59.767     0.910     0.200
    59.928    -3.430     0.200
    60.542    -2.960     0.200
    60.660    -3.418     0.200
    60.660    -4.148     0.200
    60.660    -3.708     0.200
    60.730    -3.714     0.200
    61.043    -4.339     0.200
    61.138    -2.581     0.200
    61.139    -2.598     0.200
    62.604    -3.024     0.200
    62.782    -0.352     0.200
    63.351    -4.494     0.200
    63.351    -3.519     0.200
    63.354    -3.257     0.200
    63.354    -3.517     0.200
    63.354    -3.377     0.200
    63.400    -3.459     0.200
    63.400    -3.709     0.200
    63.537     0.497     0.200
    63.902    -3.132     0.200
    63.907    -4.064     0.200
    64.419    -1.929     0.200
    64.419    -1.318     0.200
    64.419    -1.818     0.200
    64.419    -1.779     0.200
    64.476    -3.810     0.200
    64.476    -4.490     0.200
    64.476    -4.290     0.200
    64.290    -0.387     0.200
    64.965    -2.662     0.200
    65.872    -4.044     0.200
    65.931    -0.701     0.200
    66.003    -0.567     0.200
    66.073    -0.567     0.200
    66.315    -1.585     0.200
    66.349     1.008     0.200
    66.349    -0.645     0.200
    66.542    -2.192     0.200
    66.442     0.269     0.200
    66.551    -0.284     0.200
    66.611    -0.282     0.200
    66.713    -0.438     0.200
    66.886     0.560     0.200
    67.695     1.478     0.200
    67.849     0.119     0.200
    67.864    -0.898     0.200
    68.240    -4.076     0.200
    68.240    -3.401     0.200
    68.306    -2.890     0.200
    68.144    -1.458     0.200
    68.144     0.342     0.200
    68.273     0.089     0.200
    68.283    -1.265     0.200
    68.681    -0.464     0.200
    68.681     1.947     0.200
    68.705     0.109     0.200
    69.211    -0.475     0.200
    69.530    -0.346     0.200
    69.632    -0.196     0.200
    69.632     2.044     0.200
    69.632     2.304     0.200
    69.632     1.074     0.200
    69.632     1.399     0.200
    69.957    -0.883     0.200
    70.204    -3.235     0.200
    70.204    -2.155     0.200
    70.204    -2.575     0.200
    70.470    -0.693     0.200
    71.121    -0.921     0.200
    71.916    -2.808     0.200
    72.058    -4.157     0.200
    72.058    -4.457     0.200
    72.058    -4.277     0.200
    72.297    -2.186     0.200
    72.192     2.287     0.200
    73.221    -0.571     0.200
    73.341    -1.077     0.200
    73.624    -0.640     0.200
    73.684    -0.096     0.200
    73.920    -0.579     0.200
    73.939    -7.085     0.200
    74.194    -1.174     0.200
    74.555    -2.946     0.200
    74.555    -3.536     0.200
    74.555    -3.751     0.200
    74.727    -0.273     0.200
    74.869    -1.491     0.200
    74.844    -0.248     0.200
    74.966    -3.253     0.200
    74.778    -0.509     0.200
    75.075     1.419     0.200
    75.150    -1.182     0.200
    75.000    -0.456     0.200
    75.000     0.254     0.200
    75.469    -2.364     0.200
    75.469    -2.084     0.200
    75.557    -0.151     0.200
    75.702     0.021     0.200
    75.847    -0.009     0.200
    75.847    -1.459     0.200
    75.895    -2.701     0.200
    75.916     0.301     0.200
    75.916    -0.739     0.200
    76.240    -1.242     0.200
    76.304    -0.509     0.200
    76.398     0.058     0.200
    76.459    -0.282     0.200
    76.459    -1.182     0.200
    76.495     0.313     0.200
    76.606    -0.516     0.200
    76.993    -0.296     0.200
    77.011     0.103     0.200
    77.035     0.149     0.200
    77.035     1.980     0.200
    77.297    -2.303     0.200
    77.297    -1.503     0.200
    77.529    -0.117     0.200
    77.529    -1.311     0.200
    77.529    -1.494     0.200
    77.529    -0.801     0.200
    77.751    -0.039     0.200
    77.811     0.030     0.200
    77.693    -1.006     0.200
    78.400    -2.634     0.200
    78.689     0.072     0.200
    78.735     0.020     0.200
    78.735    -2.130     0.200
    78.810    -2.694     0.200
    78.932     0.140     0.200
    78.932    -0.970     0.200
    78.844    -0.602     0.200
    78.844     1.243     0.200
    79.063     1.044     0.200
    79.186     0.147     0.200
    79.274    -0.132     0.200
    79.365    -2.829     0.200
    79.461     0.451     0.200
    79.793    -1.656     0.200
    79.907    -0.273     0.200
    79.986     0.101     0.200
    79.991     0.776     0.200
    80.076     0.315     0.200
    80.489     0.394     0.200
    80.489    -1.536     0.200
    80.595     0.627     0.200
    80.404     1.037     0.200
    80.722    -1.955     0.200
    80.764     0.320     0.200
    80.832    -5.162     0.200
    80.832    -4.342     0.200
    81.062    -0.769     0.200
    81.118    -2.063     0.200
    81.197     1.117     0.200
    81.268     0.041     0.200
    81.268    -1.149     0.200
    81.348    -1.984     0.200
    81.385     0.417     0.200
    81.658     0.676     0.200
    81.737     0.461     0.200
    81.937    -0.093     0.200
    82.036     0.286     0.200
    81.975     0.045     0.200
    82.385    -1.370     0.200
    82.385    -0.520     0.200
    82.385    -0.941     0.200
    82.385    -0.660     0.200
    82.385    -0.840     0.200
    82.427    -2.356     0.200
    82.597    -2.541     0.200
    82.420     2.909     0.200
    82.726    -0.213     0.200
    82.747    -2.025     0.200
    82.907    -0.253     0.200
    83.050    -1.166     0.200
    83.050     0.072     0.200
    83.056    -1.593     0.200
    83.094     0.180     0.200
    83.458     0.705     0.200
    83.612    -2.088     0.200
    83.878    -0.245     0.200
    83.917    -3.048     0.200
    84.010     0.580     0.200
    84.199    -0.081     0.200
    84.211    -2.354     0.200
    84.138    -0.072     0.200
    84.375    -0.474     0.200
    84.391    -0.158     0.200
    84.391    -1.868     0.200
    84.417    -0.997     0.200
    84.701    -0.422     0.200
    84.884     1.558     0.200
    85.156    -2.004     0.200
    85.491    -1.357     0.200
    85.491    -1.774     0.200
    86.212    -3.447     0.200
    86.212    -3.547     0.200
    86.706    -1.409     0.200
    87.288     0.081     0.200
    87.391    -0.332     0.200
    87.391    -0.687     0.200
    87.713    -1.542     0.200
    87.713    -1.015     0.200
    87.752    -0.340     0.200
    87.780    -0.200     0.200
    87.947    -0.760     0.200
    87.984     0.310     0.200
    88.311    -1.324     0.200
    88.390    -2.093     0.200
    88.390    -1.953     0.200
    88.390    -2.233     0.200
    88.390    -1.453     0.200
    88.398    -1.546     0.200
    88.398    -2.421     0.200
    88.398    -1.719     0.200
    88.425    -0.108     0.200
    88.454     0.504     0.200
    88.527     0.004     0.200
    88.626     0.650     0.200
    88.511    -0.705     0.200
    88.511     1.148     0.200
    88.511    -0.825     0.200
    88.511     0.442     0.200
    88.725    -1.603     0.200
    88.837     0.445     0.200
    88.845    -0.070     0.200
    88.873     0.075     0.200
    88.943     0.804     0.200
    89.067    -0.769     0.200
    89.074     0.611     0.200
    89.226    -0.771     0.200
    89.329    -0.044     0.200
    89.329    -1.066     0.200
    89.399    -0.432     0.200
    89.803    -0.184     0.200
    89.808     0.378     0.200
    89.836     0.227     0.200
    89.884    -0.303     0.200
    89.935    -0.575     0.200
    90.139    -4.425     0.200
    90.209    -0.815     0.200
    90.255    -0.069     0.200
    90.783    -3.150     0.200
    90.536     1.924     0.200
    90.751    -1.903     0.200
    90.825    -0.216     0.200
    90.822    -0.384     0.200
    91.125    -3.341     0.200
    91.497     0.032     0.200
    91.497     0.138     0.200
    91.500     0.834     0.200
    91.666    -0.452     0.200
    91.621    -1.080     0.200
    92.263    -1.365     0.200
    92.341    -0.917     0.200
    92.589    -1.114     0.200
    92.589    -2.138     0.200
    92.714    -2.527     0.200
    92.922    -1.632     0.200
    92.952     0.313     0.200
    94.432    -1.114     0.200
    94.432    -2.932     0.200
    94.442    -2.010     0.200
    95.138    -2.985     0.200
    95.269    -1.451     0.200
    95.605    -2.207     0.200
    95.918    -1.819     0.200
    96.229    -1.833     0.200
    96.346    -1.444     0.200
    96.580    -3.201     0.200
    96.580    -1.872     0.200
    96.635    -2.311     0.200
    96.635    -1.406     0.200
    96.835    -1.982     0.200
    96.887    -1.630     0.200
    97.205    -2.549     0.200
    97.395    -2.518     0.200
    97.475    -2.868     0.200
    97.475    -2.499     0.200
    97.523    -1.768     0.200
    97.568    -2.795     0.200
    97.568    -2.256     0.200
    97.582    -2.252     0.200
    97.638    -1.073     0.200
    97.889    -3.220     0.200
    97.892    -3.314     0.200
    97.892    -3.639     0.200
    97.928    -2.558     0.200
    97.944    -3.216     0.200
    97.977    -3.224     0.200
    98.059    -2.521     0.200
    98.041    -1.407     0.200
    98.063    -2.220     0.200
    98.130    -2.863     0.200
    98.130    -2.287     0.200
    98.145    -2.262     0.200
    98.136    -1.712     0.200
    98.230    -2.175     0.200
    98.250    -3.153     0.200
    98.257    -2.287     0.200
    98.283    -2.189     0.200
    98.333    -2.313     0.200
    98.333    -1.978     0.200
    98.427    -1.708     0.200
    98.465    -2.214     0.200
    98.586    -1.596     0.200
    98.715    -2.985     0.200
    98.715    -2.013     0.200
    98.754    -1.582     0.200
    98.997    -2.149     0.200
    99.110    -2.188     0.200
    99.243    -1.631     0.200
    99.262    -1.933     0.200
    99.304    -2.175     0.200
    99.311    -1.994     0.200
    99.444    -1.789     0.200
    99.541    -1.954     0.200
    20.425     1.149     0.200
    20.425     1.040     0.200
    28.672     1.933     0.200
    28.686     1.030     0.200
    28.697     0.630     0.200
    28.869     1.068     0.200
    29.837     1.049     0.200
    37.285     0.558     0.200
    39.740     0.531     0.200
    39.740     0.880     0.200
    39.740     0.761     0.200
    58.850    -2.766     0.200
    58.850    -3.141     0.200
    63.416    -3.276     0.200
    64.483    -3.904     0.200
    68.336    -3.254     0.200
    70.380    -2.947     0.200
    70.380    -3.396     0.200
    74.579    -1.736     0.200
    75.032    -0.078     0.200
    75.032     0.098     0.200
    82.117    -0.008     0.200
    82.117     0.435     0.200
    88.821     1.110     0.200
    88.821     0.688     0.200
    88.821     1.311     0.200
    90.468     1.209     0.200
    94.503    -3.216     0.200
    17.221     0.592     0.200
    20.788    -1.246     0.200
    20.788     0.472     0.200
    22.675    -0.498     0.200
    24.279    -1.124     0.200
    24.279    -0.421     0.200
    25.549    -1.274     0.200
    26.512     0.614     0.200
    27.147    -2.396     0.200
    27.444    -2.736     0.200
    27.444    -3.814     0.200
    29.061    -1.323     0.200
    29.073    -1.321     0.200
    29.073    -0.704     0.200
    29.080    -0.840     0.200
    29.084    -0.518     0.200
    29.257     0.024     0.200
    30.063    -0.949     0.200
    30.063     1.347     0.200
    30.179     0.928     0.200
    30.179     0.076     0.200
    30.179     0.080     0.200
    30.216     0.797     0.200
    33.561     0.433     0.200
    33.714     1.195     0.200
    36.042    -1.337     0.200
    36.812     1.542     0.200
    37.502     1.590     0.200
    39.889    -0.671     0.200
    39.917     1.736     0.200
    40.033    -0.171     0.200
    40.033     1.071     0.200
    40.033     0.595     0.200
    43.000     1.462     0.200
    46.216     1.498     0.200
    47.959     2.903     0.200
    53.152    -3.914     0.200
    55.591    -2.979     0.200
    56.686    -3.863     0.200
    58.285    -3.730     0.200
    58.797    -3.014     0.200
    58.797    -3.686     0.200
    58.797    -3.280     0.200
    63.361    -3.191     0.200
    63.410    -2.741     0.200
    64.477    -2.877     0.200
    64.477    -4.033     0.200
    67.669    -1.124     0.200
    68.254    -2.459     0.200
    69.159     0.352     0.200
    70.230    -1.693     0.200
    75.536    -1.432     0.200
    79.121     0.560     0.200
    81.996    -0.387     0.200
    81.996     0.371     0.200
    82.436    -1.105     0.200
    88.428    -2.388     0.200
    88.557     1.122     0.200
    90.298    -0.230     0.200
    90.863    -0.486     0.200
    92.612    -3.356     0.200
    20.521    -0.012     0.200
    20.521     1.072     0.200
    21.869     0.693     0.200
    26.236     1.549     0.200
    26.998    -2.751     0.200
    28.734    -0.007     0.200
    29.965     0.482     0.200
    33.583    -0.270     0.200
    39.940     0.409     0.200
    39.940     0.813     0.200
    42.855     0.777     0.200
    54.894    -1.817     0.200
    62.956    -2.754     0.200
    67.899    -2.127     0.200
    70.010    -1.483     0.200
    79.324    -2.870     0.200
    82.530    -3.325     0.200
    82.920     1.145     0.200
    21.095     0.247     0.200
    26.409    -2.459     0.200
    29.288    -0.313     0.200
    30.548    -0.211     0.200
    40.542     0.436     0.200
    54.385    -4.544     0.200
    57.795    -3.435     0.200
    19.683     1.167     0.200
    27.851     0.059     0.200
    29.150     1.082     0.200
    39.197     0.987     0.200
    54.922    -0.625     0.200
    58.746    -1.544     0.200
    15.079     6.702     0.200
    17.996    -0.320     0.200
    20.750    -1.245     0.200
    20.750    -1.542     0.200
    21.564    -6.239     0.200
    22.621    -1.591     0.200
    22.621     0.174     0.200
    22.684     1.288     0.200
    22.910    -6.620     0.200
    24.211    -2.442     0.200
    25.598    -4.309     0.200
    25.598    -3.949     0.200
    27.398    -5.694     0.200
    27.398    -3.904     0.200
    27.398    -5.303     0.200
    27.735    -5.497     0.200
    29.029     0.835     0.200
    29.175    -1.082     0.200
    30.068     0.958     0.200
    30.148     0.500     0.200
    30.148    -0.313     0.200
    30.185     1.315     0.200
    34.932    -4.119     0.200
    36.567    -1.010     0.200
    37.097    -6.181     0.200
    38.738    -1.977     0.200
    39.835    -1.663     0.200
    39.835    -1.530     0.200
    39.835     1.563     0.200
    40.016     1.205     0.200
    40.016     0.041     0.200
    40.016    -0.521     0.200
    40.016     1.057     0.200
    42.977     1.592     0.200
    47.079     0.289     0.200
    47.079    -1.219     0.200
    48.710     1.059     0.200
    49.170    -2.814     0.200
    54.390    -1.797     0.200
    55.154    -4.251     0.200
    55.437    -3.279     0.200
    55.517    -3.154     0.200
    56.460    -2.986     0.200
    56.583    -3.416     0.200
    56.583    -5.314     0.200
    56.794    -4.022     0.200
    56.813    -4.300     0.200
    58.312    -2.744     0.200
    58.316     0.335     0.200
    58.755    -2.134     0.200
    58.755    -4.088     0.200
    58.755    -4.705     0.200
    60.665    -3.881     0.200
    63.320    -4.101     0.200
    63.369    -4.135     0.200
    64.426    -4.629     0.200
    66.820    -1.101     0.200
    67.005    -0.235     0.200
    68.219    -3.373     0.200
    68.263    -3.246     0.200
    68.856    -0.252     0.200
    69.451    -1.147     0.200
    69.805     2.988     0.200
    70.211    -2.299     0.200
    70.211    -3.284     0.200
    72.357     1.644     0.200
    75.062    -0.745     0.200
    75.062    -0.339     0.200
    75.506    -3.036     0.200
    75.506    -2.598     0.200
    76.138     1.164     0.200
    77.343    -2.581     0.200
    77.343    -0.706     0.200
    78.579     0.233     0.200
    78.818     0.991     0.200
    79.044     1.451     0.200
    80.716    -4.448     0.200
    82.071    -0.181     0.200
    82.071    -0.298     0.200
    82.452    -1.205     0.200
    82.452    -1.345     0.200
    82.452    -2.454     0.200
    84.042     0.441     0.200
    86.903     2.611     0.200
    86.953     1.844     0.200
    88.424    -1.902     0.200
    88.424    -1.277     0.200
    88.432    -2.690     0.200
    88.655    -1.178     0.200
    88.655     0.174     0.200
    88.655     0.830     0.200
    89.382    -2.309     0.200
    89.382     1.917     0.200
    89.382     1.620     0.200
    91.740    -0.205     0.200
    92.588    -2.276     0.200
    92.588    -1.276     0.200
    94.403    -2.834     0.200
    97.835    -3.148     0.200
    98.425    -3.726     0.200
    98.471    -2.081     0.200
    29.284    -0.160     0.200
    30.550    -0.361     0.200
    40.549     0.423     0.200
    20.492     1.368     0.200
    20.492    -0.816     0.200
    22.220     0.642     0.200
    28.704     1.264     0.200
    28.710    -0.833     0.200
    29.936     0.746     0.200
    29.936    -0.394     0.200
    50.605    -3.596     0.200
    14.814     5.899     0.200
    15.036     1.986     0.200
    15.256     1.615     0.200
    15.666     1.100     0.200
    15.844     1.915     0.200
    15.897     1.628     0.200
    16.029     2.140     0.200
    16.177     0.767     0.200
    16.416     0.536     0.200
    17.140     0.263     0.200
    17.355     0.095     0.200
    17.348     0.880     0.200
    17.771     0.466     0.200
    18.018     0.588     0.200
    18.018    -0.102     0.200
    18.018    -0.354     0.200
    18.018     0.044     0.200
    18.488    -2.640     0.200
    19.528    -3.533     0.200
    19.785    -2.827     0.200
    19.785    -0.638     0.200
    19.792    -1.317     0.200
    19.792    -1.517     0.200
    20.010     0.012     0.200
    20.538    -0.117     0.200
    20.775     1.279     0.200
    20.775     0.654     0.200
    20.775    -0.761     0.200
    20.775     1.129     0.200
    21.196    -0.111     0.200
    21.502    -1.996     0.200
    21.502    -2.302     0.200
    21.651    -2.100     0.200
    21.678    -0.482     0.200
    21.777    -3.445     0.200
    21.645     1.489     0.200
    21.645     1.315     0.200
    22.072    -3.235     0.200
    22.072    -4.646     0.200
    22.072    -2.086     0.200
    22.072    -1.985     0.200
    22.298    -3.590     0.200
    22.371    -1.271     0.200
    22.543    -1.892     0.200
    22.793    -3.934     0.200
    22.646    -0.655     0.200
    22.646    -0.320     0.200
    22.646    -1.450     0.200
    22.896    -2.229     0.200
    22.927    -5.838     0.200
    22.927    -2.949     0.200
    22.887    -4.831     0.200
    22.700     0.428     0.200
    22.700     0.901     0.200
    22.700     1.741     0.200
    22.700     1.251     0.200
    23.021    -3.032     0.200
    23.308    -5.760     0.200
    23.459    -3.146     0.200
    23.459    -2.377     0.200
    23.486    -2.921     0.200
    23.771    -1.410     0.200
    23.771    -2.180     0.200
    24.073    -2.820     0.200
    24.235     0.584     0.200
    24.235     0.424     0.200
    24.235     0.024     0.200
    24.344     2.110     0.200
    24.344     1.582     0.200
    24.344     1.180     0.200
    25.048    -4.265     0.200
    25.174    -2.013     0.200
    25.504    -0.678     0.200
    25.620    -3.043     0.200
    25.620    -3.273     0.200
    25.620    -2.453     0.200
    25.620    -2.053     0.200
    25.637    -0.105     0.200
    25.657    -0.590     0.200
    25.889    -5.395     0.200
    25.603     3.662     0.200
    25.603     2.328     0.200
    26.520     0.958     0.200
    26.520     0.659     0.200
    26.922    -4.220     0.200
    26.922    -1.810     0.200
    26.922    -2.210     0.200
    26.637     1.356     0.200
    26.637     2.697     0.200
    26.902    -2.233     0.200
    27.112    -1.424     0.200
    27.259    -1.142     0.200
    27.383    -3.768     0.200
    27.383    -3.806     0.200
    27.383    -4.087     0.200
    27.432    -0.789     0.200
    27.721    -4.059     0.200
    27.721    -3.819     0.200
    27.721    -4.379     0.200
    27.719    -4.059     0.200
    27.815    -0.214     0.200
    27.828     0.668     0.200
    27.868    -1.993     0.200
    28.716    -3.741     0.200
    29.054     0.166     0.200
    29.053    -0.331     0.200
    29.060     0.012     0.200
    29.060    -0.278     0.200
    29.523    -3.828     0.200
    29.523    -3.358     0.200
    29.704    -0.828     0.200
    29.704    -0.197     0.200
    29.908    -1.601     0.200
    30.247     1.882     0.200
    30.247     2.053     0.200
    30.088     1.751     0.200
    30.088     1.645     0.200
    30.088     0.701     0.200
    30.088     1.301     0.200
    30.172     0.364     0.200
    30.172     0.064     0.200
    30.209     1.832     0.200
    30.944     2.432     0.200
    30.944    -0.538     0.200
    30.944     1.742     0.200
    32.440    -3.208     0.200
    33.123    -1.876     0.200
    33.983    -2.561     0.200
    34.115    -3.118     0.200
    34.115    -4.518     0.200
    34.115    -2.709     0.200
    33.933     0.444     0.200
    33.933    -0.895     0.200
    34.170    -2.983     0.200
    34.335    -2.351     0.200
    34.335    -4.621     0.200
    34.486     0.491     0.200
    34.612     2.126     0.200
    35.294    -2.000     0.200
    35.294    -3.950     0.200
    35.589    -2.334     0.200
    35.774    -3.922     0.200
    35.774    -1.902     0.200
    36.341    -1.856     0.200
    36.384    -2.871     0.200
    36.384    -4.219     0.200
    36.384    -4.118     0.200
    36.588     3.032     0.200
    36.588     2.071     0.200
    36.588     1.738     0.200
    36.588     2.638     0.200
    37.498     1.215     0.200
    37.730    -2.775     0.200
    37.680     0.946     0.200
    37.680    -1.197     0.200
    37.680     0.473     0.200
    38.043    -2.979     0.200
    38.043    -3.290     0.200
    38.543    -3.455     0.200
    38.728    -3.647     0.200
    38.885    -2.161     0.200
    38.827    -2.961     0.200
    38.914     1.122     0.200
    39.722    -2.042     0.200
    39.721    -0.137     0.200
    39.844    -2.486     0.200
    39.859    -0.133     0.200
    39.859    -2.034     0.200
    39.859     0.617     0.200
    39.859     1.117     0.200
    39.859     0.367     0.200
    39.907     1.919     0.200
    39.907     1.762     0.200
    39.907    -0.514     0.200
    39.907     1.026     0.200
    40.238    -1.924     0.200
    40.238    -2.094     0.200
    40.238    -4.073     0.200
    40.238    -2.424     0.200
    40.039     0.703     0.200
    40.039     0.928     0.200
    40.039     0.328     0.200
    40.386    -2.547     0.200
    40.695    -2.997     0.200
    40.619    -0.872     0.200
    41.000    -3.511     0.200
    41.011    -3.702     0.200
    40.985    -0.003     0.200
    41.054    -3.052     0.200
    41.182    -3.404     0.200
    41.245    -3.104     0.200
    41.325    -1.283     0.200
    41.764    -3.279     0.200
    41.740    -3.679     0.200
    42.187     0.260     0.200
    42.467    -3.702     0.200
    42.552    -2.193     0.200
    42.664    -3.701     0.200
    42.747     1.719     0.200
    43.001     1.288     0.200
    43.001     1.077     0.200
    43.001    -0.301     0.200
    43.001     0.669     0.200
    43.001     1.468     0.200
    43.867    -3.715     0.200
    44.914    -3.179     0.200
    45.169    -2.285     0.200
    45.169    -4.474     0.200
    45.350    -3.235     0.200
    45.652    -3.124     0.200
    45.413     2.356     0.200
    45.413     1.353     0.200
    45.413    -1.908     0.200
    45.413     1.062     0.200
    45.413     2.461     0.200
    45.674    -0.905     0.200
    45.784    -1.260     0.200
    45.646     2.618     0.200
    45.646     2.301     0.200
    45.646     1.348     0.200
    46.419    -1.083     0.200
    46.221     1.814     0.200
    46.221     1.233     0.200
    46.221     0.689     0.200
    46.709    -3.815     0.200
    47.237    -3.018     0.200
    47.102     1.994     0.200
    47.102     1.685     0.200
    47.102     0.684     0.200
    47.102    -0.206     0.200
    47.325     3.635     0.200
    47.636    -2.559     0.200
    47.369     4.245     0.200
    47.369     0.103     0.200
    47.369     3.112     0.200
    47.899    -3.816     0.200
    48.037    -3.771     0.200
    47.870     2.765     0.200
    48.442    -3.664     0.200
    48.509    -2.804     0.200
    48.490    -3.054     0.200
    48.528    -2.352     0.200
    48.474    -2.233     0.200
    48.586    -3.186     0.200
    48.645    -3.692     0.200
    48.705    -1.507     0.200
    48.755    -3.393     0.200
    49.172    -2.825     0.200
    49.172    -2.585     0.200
    50.527    -3.819     0.200
    51.280     1.782     0.200
    51.513    -4.087     0.200
    51.884    -3.752     0.200
    52.225    -2.888     0.200
    52.291    -2.794     0.200
    52.291    -3.263     0.200
    52.291    -1.818     0.200
    53.047    -4.785     0.200
    53.047    -4.105     0.200
    53.047    -4.653     0.200
    53.047    -3.687     0.200
    54.126    -3.969     0.200
    54.376    -2.287     0.200
    54.376    -2.477     0.200
    55.137    -3.568     0.200
    55.137    -3.248     0.200
    55.160    -4.066     0.200
    55.417    -2.425     0.200
    55.417    -1.586     0.200
    55.417    -3.015     0.200
    55.377     0.184     0.200
    55.509    -2.657     0.200
    55.509    -2.476     0.200
    55.537    -2.347     0.200
    55.537    -3.268     0.200
    55.537    -2.578     0.200
    55.537    -2.788     0.200
    55.950     0.594     0.200
    55.979     0.847     0.200
    56.125    -3.289     0.200
    56.125    -4.088     0.200
    56.100    -2.522     0.200
    56.063     0.527     0.200
    56.179    -2.333     0.200
    56.460    -3.374     0.200
    56.584    -3.062     0.200
    56.584    -3.561     0.200
    56.556     0.401     0.200
    56.776    -2.564     0.200
    56.776    -2.224     0.200
    56.833    -3.023     0.200
    56.880    -0.154     0.200
    56.880     0.919     0.200
    56.909     0.387     0.200
    57.012    -3.096     0.200
    57.055     0.386     0.200
    57.235    -3.267     0.200
    57.324    -2.338     0.200
    57.362     0.901     0.200
    57.470     0.510     0.200
    57.611    -2.916     0.200
    57.669    -2.929     0.200
    57.801    -3.251     0.200
    58.026    -3.733     0.200
    58.026    -3.173     0.200
    57.943     0.924     0.200
    58.146    -3.668     0.200
    58.308    -3.421     0.200
    58.263    -2.845     0.200
    58.290     0.355     0.200
    58.387    -2.613     0.200
    58.387    -3.315     0.200
    58.387    -3.155     0.200
    58.387    -3.055     0.200
    58.387    -1.795     0.200
    58.355     0.091     0.200
    58.419     0.830     0.200
    58.478     0.792     0.200
    58.622    -2.986     0.200
    58.324     0.626     0.200
    58.324     1.285     0.200
    58.324     1.586     0.200
    58.324     1.926     0.200
    58.633    -0.082     0.200
    58.633     0.053     0.200
    58.740    -3.812     0.200
    58.740    -3.762     0.200
    58.740    -3.333     0.200
    58.697     0.874     0.200
    58.858    -3.928     0.200
    58.858    -3.638     0.200
    58.858    -4.268     0.200
    58.791     0.735     0.200
    58.791     1.114     0.200
    59.172    -3.466     0.200
    58.921     1.795     0.200
    58.921     0.436     0.200
    59.155     0.187     0.200
    59.240     0.215     0.200
    59.263    -0.488     0.200
    59.263    -0.339     0.200
    59.263    -0.593     0.200
    59.263    -0.734     0.200
    59.263    -2.334     0.200
    59.265     0.119     0.200
    59.265     0.264     0.200
    59.268     0.156     0.200
    59.268     0.303     0.200
    59.427    -2.995     0.200
    59.427    -1.965     0.200
    59.346    -0.918     0.200
    59.282    -1.586     0.200
    59.282     0.735     0.200
    59.567    -2.435     0.200
    59.485     0.051     0.200
    59.491     0.165     0.200
    59.563     2.047     0.200
    59.671     0.154     0.200
    59.722     0.467     0.200
    59.722     0.094     0.200
    59.866    -3.286     0.200
    59.813     0.126     0.200
    59.834     0.436     0.200
    59.834     0.260     0.200
    59.965    -3.270     0.200
    59.961     0.671     0.200
    59.961     0.123     0.200
    60.086    -2.758     0.200
    60.087    -0.284     0.200
    60.087     0.152     0.200
    60.188    -2.896     0.200
    60.531    -2.642     0.200
    60.591    -3.650     0.200
    60.646    -2.775     0.200
    60.662     0.314     0.200
    60.686     0.545     0.200
    60.897    -3.763     0.200
    60.897    -3.931     0.200
    60.974    -3.553     0.200
    60.974    -3.153     0.200
    60.975    -3.171     0.200
    60.975    -3.011     0.200
    60.929    -3.348     0.200
    62.007     0.210     0.200
    63.193    -3.335     0.200
    63.193    -3.465     0.200
    63.193    -3.085     0.200
    63.305    -3.521     0.200
    63.353    -3.494     0.200
    63.353    -3.664     0.200
    63.609     0.210     0.200
    63.767    -3.121     0.200
    64.376    -3.117     0.200
    64.413    -4.085     0.200
    64.413    -4.390     0.200
    64.532    -2.737     0.200
    66.158    -2.666     0.200
    66.659     1.532     0.200
    66.659    -0.398     0.200
    66.492     2.324     0.200
    66.492     1.449     0.200
    66.492     1.955     0.200
    66.492     1.090     0.200
    66.492     2.500     0.200
    67.685    -0.003     0.200
    67.685    -0.431     0.200
    67.685    -0.111     0.200
    67.685    -0.971     0.200
    67.685    -0.221     0.200
    67.786     1.294     0.200
    67.786     1.964     0.200
    68.203    -3.101     0.200
    68.099     0.230     0.200
    68.657     0.750     0.200
    68.832     0.958     0.200
    68.832     0.498     0.200
    68.832     2.384     0.200
    68.832     1.248     0.200
    69.160     0.725     0.200
    69.160     0.314     0.200
    69.475     0.126     0.200
    69.538     0.967     0.200
    69.640     0.845     0.200
    69.640    -0.715     0.200
    69.640     0.645     0.200
    69.781     2.156     0.200
    69.781     1.910     0.200
    69.781     0.961     0.200
    69.781    -0.219     0.200
    69.781     1.580     0.200
    69.781     2.351     0.200
    70.192    -2.072     0.200
    71.927    -4.058     0.200
    71.927    -3.743     0.200
    71.927    -3.892     0.200
    71.927    -4.352     0.200
    72.131    -1.673     0.200
    72.332     0.514     0.200
    72.332     1.907     0.200
    72.332     2.024     0.200
    73.134    -1.133     0.200
    73.960    -3.690     0.200
    74.285    -0.796     0.200
    74.391    -1.901     0.200
    74.391    -3.164     0.200
    74.391    -2.870     0.200
    74.517    -1.234     0.200
    74.595    -1.033     0.200
    74.595    -1.653     0.200
    74.595    -0.283     0.200
    74.595    -0.675     0.200
    74.802    -3.280     0.200
    74.837    -1.685     0.200
    75.073     0.301     0.200
    75.073    -0.089     0.200
    75.073     0.551     0.200
    75.489    -1.937     0.200
    75.489    -2.137     0.200
    75.744    -3.324     0.200
    75.744    -2.993     0.200
    75.744    -2.793     0.200
    76.304     1.259     0.200
    76.304     1.919     0.200
    76.304     2.519     0.200
    76.304     2.129     0.200
    76.304     2.889     0.200
    76.541    -1.685     0.200
    76.547    -0.944     0.200
    77.263    -0.089     0.200
    77.321    -1.016     0.200
    77.321    -1.616     0.200
    77.484    -1.128     0.200
    77.553    -1.121     0.200
    77.553    -2.291     0.200
    77.553    -0.811     0.200
    77.672     1.223     0.200
    77.771    -1.628     0.200
    77.584     1.875     0.200
    78.105     1.320     0.200
    78.251    -3.514     0.200
    78.223     2.267     0.200
    78.394    -2.180     0.200
    78.488     1.101     0.200
    78.502    -1.064     0.200
    78.502     0.927     0.200
    78.662    -3.182     0.200
    78.662    -2.957     0.200
    78.554     1.240     0.200
    78.555    -0.907     0.200
    78.555    -0.367     0.200
    78.555     0.234     0.200
    78.555     0.734     0.200
    78.675    -0.690     0.200
    78.675     1.571     0.200
    78.722    -1.554     0.200
    78.378     3.107     0.200
    78.777    -1.639     0.200
    78.770    -1.192     0.200
    78.791     1.237     0.200
    78.663     2.026     0.200
    78.799     0.993     0.200
    78.799     2.194     0.200
    79.026    -0.373     0.200
    79.026     1.447     0.200
    79.119    -1.661     0.200
    79.126     0.707     0.200
    78.931     1.615     0.200
    78.931     0.166     0.200
    78.931     1.865     0.200
    79.027     1.042     0.200
    79.393    -2.056     0.200
    79.687    -1.858     0.200
    79.764     0.056     0.200
    80.711    -3.931     0.200
    80.711    -4.654     0.200
    80.711    -4.372     0.200
    80.698    -1.899     0.200
    80.475     1.632     0.200
    80.550     1.929     0.200
    81.121    -1.856     0.200
    81.326     0.346     0.200
    81.326     0.155     0.200
    81.326     0.455     0.200
    81.361    -1.231     0.200
    82.052    -0.321     0.200
    82.079     0.031     0.200
    82.079     0.328     0.200
    82.079     0.947     0.200
    82.079     1.588     0.200
    82.433    -1.462     0.200
    82.191     2.238     0.200
    82.429    -1.367     0.200
    82.429    -1.045     0.200
    82.429    -1.386     0.200
    82.429    -1.145     0.200
    82.602    -1.643     0.200
    82.751    -1.120     0.200
    82.603     2.988     0.200
    83.095    -1.198     0.200
    83.095    -2.529     0.200
    83.095    -0.819     0.200
    82.977     0.087     0.200
    83.265    -1.778     0.200
    83.250     0.147     0.200
    83.250     1.118     0.200
    83.640    -1.007     0.200
    84.023     2.248     0.200
    84.787    -0.690     0.200
    85.149    -1.743     0.200
    85.416    -1.081     0.200
    85.486    -1.311     0.200
    85.486    -1.625     0.200
    85.745     0.557     0.200
    86.189    -4.805     0.200
    86.427    -3.675     0.200
    86.260    -0.717     0.200
    86.402    -3.877     0.200
    86.935    -0.433     0.200
    86.920    -1.631     0.200
    86.883     0.862     0.200
    86.883     0.512     0.200
    86.883     2.392     0.200
    86.883     1.692     0.200
    86.883     2.152     0.200
    87.150    -0.183     0.200
    87.175    -0.526     0.200
    87.319    -1.005     0.200
    87.351    -0.993     0.200
    87.424    -0.812     0.200
    87.424    -0.579     0.200
    87.470    -1.255     0.200
    87.513    -0.613     0.200
    87.833    -2.856     0.200
    87.783    -0.661     0.200
    87.812    -0.159     0.200
    87.871    -1.876     0.200
    87.913    -0.520     0.200
    87.976    -0.563     0.200
    87.995    -0.335     0.200
    88.060     0.893     0.200
    88.146    -0.320     0.200
    88.143    -1.225     0.200
    88.199     0.448     0.200
    88.210    -0.469     0.200
    88.333    -1.498     0.200
    88.355     0.059     0.200
    88.343    -2.073     0.200
    88.404    -2.314     0.200
    88.404    -2.099     0.200
    88.404    -1.889     0.200
    88.462    -0.550     0.200
    88.518     1.258     0.200
    88.617     0.470     0.200
    88.628     0.864     0.200
    88.656     0.892     0.200
    88.692    -1.131     0.200
    88.770    -0.715     0.200
    88.884    -0.507     0.200
    88.901     0.319     0.200
    88.902    -0.332     0.200
    88.902    -0.919     0.200
    88.902    -0.440     0.200
    88.891     0.806     0.200
    88.952    -0.802     0.200
    88.655     2.215     0.200
    88.976     0.618     0.200
    89.095    -0.921     0.200
    89.105    -0.021     0.200
    89.129    -1.705     0.200
    89.229    -0.438     0.200
    89.289    -0.321     0.200
    89.360    -0.069     0.200
    89.360    -1.425     0.200
    89.557    -1.084     0.200
    89.658    -1.783     0.200
    89.838    -1.046     0.200
    89.838    -1.290     0.200
    89.874    -0.308     0.200
    89.916     0.423     0.200
    89.930    -1.840     0.200
    89.966    -1.303     0.200
    90.141    -1.908     0.200
    90.143    -0.597     0.200
    90.241    -0.918     0.200
    90.241    -0.790     0.200
    90.280     0.111     0.200
    90.280    -0.073     0.200
    90.333    -0.910     0.200
    90.579    -1.678     0.200
    90.614    -1.439     0.200
    90.741    -2.938     0.200
    90.741    -3.529     0.200
    90.819    -0.621     0.200
    90.854    -0.743     0.200
    90.854    -1.346     0.200
    90.860    -0.800     0.200
    91.085    -4.326     0.200
    91.067    -0.935     0.200
    91.109     0.493     0.200
    91.434    -1.786     0.200
    91.528     0.172     0.200
    91.528    -1.158     0.200
    91.621    -2.723     0.200
    91.621    -1.513     0.200
    91.621    -1.614     0.200
    91.700    -1.991     0.200
    91.979    -3.667     0.200
    92.005    -0.605     0.200
    92.044    -0.811     0.200
    92.056    -2.046     0.200
    92.146    -2.280     0.200
    92.206    -1.478     0.200
    92.178    -0.294     0.200
    92.287    -2.301     0.200
    92.282    -2.028     0.200
    92.282    -0.678     0.200
    92.374    -0.933     0.200
    92.374    -1.116     0.200
    92.450    -1.353     0.200
    92.450    -0.343     0.200
    92.453    -0.877     0.200
    92.491    -1.653     0.200
    92.528    -2.244     0.200
    92.527    -1.609     0.200
    92.527    -1.498     0.200
    92.570    -1.698     0.200
    92.638    -1.013     0.200
    92.719    -1.785     0.200
    93.009    -0.813     0.200
    93.030    -1.162     0.200
    93.171    -1.230     0.200
    93.210    -2.339     0.200
    93.382    -2.453     0.200
    93.608    -2.043     0.200
    93.637    -1.926     0.200
    93.614    -0.598     0.200
    93.614    -0.708     0.200
    93.614    -0.944     0.200
    93.737    -1.508     0.200
    93.748    -1.186     0.200
    93.802    -0.333     0.200
    93.802    -1.244     0.200
    93.819    -1.164     0.200
    93.819    -1.324     0.200
    93.917    -2.703     0.200
    93.871    -1.205     0.200
    94.227    -1.849     0.200
    94.227    -0.899     0.200
    94.388    -2.275     0.200
    94.388    -2.940     0.200
    94.388    -2.545     0.200
    94.511    -1.458     0.200
    94.511    -1.150     0.200
    94.553    -1.634     0.200
    94.644    -2.031     0.200
    94.644    -0.542     0.200
    94.872    -0.984     0.200
    94.902    -0.660     0.200
    94.916    -0.244     0.200
    95.096    -2.975     0.200
    95.120     0.042     0.200
    95.241    -0.862     0.200
    95.312    -1.575     0.200
    95.370    -1.779     0.200
    95.373    -0.815     0.200
    95.452    -0.872     0.200
    95.625    -1.033     0.200
    95.625    -1.372     0.200
    95.625    -1.623     0.200
    95.664    -0.200     0.200
    95.701    -0.737     0.200
    95.968    -2.524     0.200
    96.163    -2.270     0.200
    96.142    -0.835     0.200
    96.198    -0.830     0.200
    96.307    -1.426     0.200
    96.459    -0.654     0.200
    96.516    -0.723     0.200
    96.543    -0.555     0.200
    96.648    -1.170     0.200
    96.687    -2.480     0.200
    96.701    -1.462     0.200
    96.993    -2.644     0.200
    97.178    -2.640     0.200
    97.322    -2.220     0.200
    97.398    -1.492     0.200
    97.577    -1.208     0.200
    97.590    -0.625     0.200
    97.636    -1.117     0.200
    97.636    -1.325     0.200
    97.662    -0.973     0.200
    97.822    -3.034     0.200
    97.822    -3.461     0.200
    97.793    -1.581     0.200
    97.874    -2.205     0.200
    97.894    -2.876     0.200
    97.908    -2.137     0.200
    97.939    -2.458     0.200
    98.005    -0.983     0.200
    97.993    -1.483     0.200
    98.036    -2.365     0.200
    98.218    -2.802     0.200
    98.065    -1.463     0.200
    98.065    -2.373     0.200
    98.159    -2.188     0.200
    98.159    -0.888     0.200
    98.266    -1.867     0.200
    98.383    -2.430     0.200
    98.452    -2.302     0.200
    98.479    -1.872     0.200
    98.614    -1.627     0.200
    98.692    -2.212     0.200
    98.689    -1.733     0.200
    98.757    -1.916     0.200
    98.795    -1.606     0.200
    98.808    -0.975     0.200
    98.913    -2.170     0.200
    99.135    -2.593     0.200
    99.146    -1.601     0.200
    99.259    -1.885     0.200
    99.391    -1.412     0.200
    99.434    -1.897     0.200
    20.741    -0.620     0.200
    29.023     0.291     0.200
    36.541     0.978     0.200
    39.995     0.492     0.200
    42.960     0.921     0.200
    56.645    -4.819     0.200
    58.802    -5.182     0.200
    63.366    -4.353     0.200
    63.415    -4.673     0.200
    68.263    -4.156     0.200
    70.248    -3.511     0.200
    75.548    -4.101     0.200
    18.642    -0.529     0.200
    19.021     0.257     0.200
    21.072     0.286     0.200
    21.072    -0.589     0.200
    22.758    -1.066     0.200
    24.177    -1.497     0.200
    26.422     0.409     0.200
    29.265    -0.690     0.200
    29.265    -1.377     0.200
    30.525    -0.223     0.200
    37.169    -0.672     0.200
    40.521     0.292     0.200
    40.521    -0.165     0.200
    43.427    -1.084     0.200
    52.606    -3.253     0.200
    66.353    -3.473     0.200
    67.670    -0.032     0.200
    69.889    -1.013     0.200
    76.110    -0.400     0.200
    83.200    -0.262     0.200
    83.200    -0.473     0.200
    15.585     1.445     0.200
    15.781     2.288     0.200
    16.166     1.303     0.200
    16.497     1.066     0.200
    17.512     0.200     0.200
    18.485    -2.534     0.200
    18.508    -0.988     0.200
    18.846    -3.969     0.200
    18.846    -1.199     0.200
    18.713    -1.373     0.200
    18.713    -1.742     0.200
    18.956    -0.511     0.200
    19.121    -3.522     0.200
    19.088    -1.301     0.200
    19.526    -0.657     0.200
    19.650    -2.913     0.200
    19.660    -2.117     0.200
    20.140    -0.957     0.200
    20.729    -2.255     0.200
    21.251    -1.197     0.200
    21.309    -0.622     0.200
    21.331    -0.858     0.200
    21.251     0.200     0.200
    21.251     0.600     0.200
    21.251     0.751     0.200
    21.251     0.899     0.200
    21.251    -1.829     0.200
    21.373     0.196     0.200
    21.455     0.007     0.200
    21.593    -2.571     0.200
    21.617    -3.132     0.200
    21.710    -3.480     0.200
    21.710    -1.531     0.200
    21.819    -2.597     0.200
    21.926    -2.048     0.200
    22.033    -1.093     0.200
    22.157    -1.018     0.200
    22.442    -2.250     0.200
    22.535    -1.641     0.200
    22.584    -3.621     0.200
    22.584    -0.661     0.200
    22.457     2.787     0.200
    22.457     3.383     0.200
    22.457     1.088     0.200
    22.711    -4.114     0.200
    22.898    -2.290     0.200
    23.088    -1.696     0.200
    22.988     0.552     0.200
    22.988     0.722     0.200
    22.988    -2.048     0.200
    22.988     1.452     0.200
    22.988    -0.149     0.200
    23.179     0.386     0.200
    23.179    -0.661     0.200
    23.179    -0.860     0.200
    23.142    -5.672     0.200
    23.571     2.815     0.200
    23.571    -1.796     0.200
    23.571     0.915     0.200
    24.081    -3.851     0.200
    24.094    -2.407     0.200
    24.094    -2.776     0.200
    24.369    -4.284     0.200
    24.449    -0.211     0.200
    24.449     0.207     0.200
    24.449    -1.982     0.200
    24.449    -0.812     0.200
    25.217     3.527     0.200
    25.217     0.892     0.200
    25.450    -2.874     0.200
    25.450    -3.025     0.200
    25.582    -2.521     0.200
    25.572    -1.333     0.200
    25.593    -1.422     0.200
    25.703    -0.347     0.200
    25.984     0.536     0.200
    25.984    -0.964     0.200
    26.439    -0.478     0.200
    26.449    -0.472     0.200
    26.492    -0.063     0.200
    26.492    -4.332     0.200
    26.492     0.264     0.200
    26.492    -2.512     0.200
    26.492    -3.932     0.200
    26.492    -0.162     0.200
    26.317     3.243     0.200
    26.470     1.754     0.200
    26.769    -2.254     0.200
    26.829    -1.299     0.200
    26.829    -0.590     0.200
    26.829    -3.769     0.200
    26.829    -1.900     0.200
    26.827    -2.580     0.200
    27.069    -1.463     0.200
    27.056    -2.446     0.200
    27.199    -1.332     0.200
    27.611    -1.825     0.200
    27.516     2.820     0.200
    27.516    -1.879     0.200
    27.516     0.221     0.200
    27.970     1.450     0.200
    27.970     2.684     0.200
    27.970    -0.035     0.200
    28.657    -4.043     0.200
    28.998     3.440     0.200
    28.998     4.335     0.200
    28.998     0.605     0.200
    29.308     1.503     0.200
    29.308    -0.247     0.200
    29.470     0.993     0.200
    29.470    -2.333     0.200
    29.471     0.464     0.200
    29.471     0.814     0.200
    29.820     1.359     0.200
    29.820     0.008     0.200
    29.820     0.520     0.200
    30.492    -0.967     0.200
    30.690     1.208     0.200
    30.690     0.276     0.200
    30.817     2.775     0.200
    30.817    -1.590     0.200
    30.817     1.900     0.200
    30.817     0.701     0.200
    31.117     0.360     0.200
    32.193     2.188     0.200
    32.231     0.858     0.200
    32.371    -3.174     0.200
    32.896    -3.389     0.200
    32.864     1.505     0.200
    33.247    -0.240     0.200
    33.230     0.306     0.200
    33.462    -0.202     0.200
    33.462    -3.821     0.200
    33.462    -0.612     0.200
    33.669     2.284     0.200
    33.665     0.219     0.200
    34.320     0.384     0.200
    34.293     4.020     0.200
    34.293     0.460     0.200
    35.409     0.125     0.200
    35.533    -2.346     0.200
    35.533    -3.147     0.200
    36.190    -0.552     0.200
    36.412    -0.881     0.200
    37.103    -3.489     0.200
    37.260     2.149     0.200
    37.260     1.664     0.200
    37.260    -1.945     0.200
    37.260     1.805     0.200
    37.260    -0.095     0.200
    37.977     0.238     0.200
    37.977    -0.473     0.200
    38.037    -1.384     0.200
    38.037     1.827     0.200
    38.901    -2.746     0.200
    39.414    -0.837     0.200
    39.414    -2.618     0.200
    39.414    -2.237     0.200
    39.789    -2.064     0.200
    40.206     1.579     0.200
    40.194     0.437     0.200
    40.194    -2.123     0.200
    40.194    -0.223     0.200
    40.412     0.065     0.200
    40.445    -3.201     0.200
    40.395     2.537     0.200
    40.395     1.400     0.200
    40.395     2.012     0.200
    40.395    -0.289     0.200
    40.646     1.021     0.200
    40.646     0.584     0.200
    40.646     1.535     0.200
    40.646    -0.166     0.200
    40.824    -0.738     0.200
    41.615    -0.243     0.200
    41.883    -2.336     0.200
    42.931     2.431     0.200
    43.427     1.998     0.200
    43.427     0.218     0.200
    43.571     2.454     0.200
    43.571     2.046     0.200
    43.571     0.257     0.200
    44.163     1.298     0.200
    44.333     0.230     0.200
    44.333    -3.670     0.200
    44.718    -0.546     0.200
    44.737    -2.694     0.200
    45.836     0.664     0.200
    45.836     2.787     0.200
    45.836     2.078     0.200
    45.836    -0.223     0.200
    46.378    -3.490     0.200
    46.311     1.228     0.200
    46.311    -0.466     0.200
    46.819     2.180     0.200
    46.819     0.150     0.200
    47.157     0.305     0.200
    47.157     0.616     0.200
    47.577    -0.867     0.200
    47.549     0.551     0.200
    47.821    -3.910     0.200
    47.712     3.287     0.200
    47.712     3.088     0.200
    47.712     1.988     0.200
    47.839     3.733     0.200
    47.839     4.340     0.200
    47.839     2.100     0.200
    47.839    -0.199     0.200
    48.055    -0.308     0.200
    47.977     3.165     0.200
    47.977     3.484     0.200
    47.977    -0.067     0.200
    48.291    -1.947     0.200
    48.336    -0.241     0.200
    48.356     0.102     0.200
    48.435     3.626     0.200
    48.435     0.095     0.200
    48.712     4.069     0.200
    48.712     4.518     0.200
    48.976    -0.320     0.200
    50.363    -0.296     0.200
    50.355    -1.379     0.200
    51.469     2.047     0.200
    51.469    -1.316     0.200
    51.469    -0.266     0.200
    52.233    -1.608     0.200
    52.233    -2.771     0.200
    52.233    -3.171     0.200
    52.250     0.006     0.200
    52.290    -0.990     0.200
    53.485     0.180     0.200
    54.568    -0.934     0.200
    54.569    -3.179     0.200
    54.569    -3.359     0.200
    54.574    -1.477     0.200
    54.597    -3.529     0.200
    54.597    -1.066     0.200
    54.597    -1.939     0.200
    54.597    -2.340     0.200
    54.695    -3.302     0.200
    54.695     0.103     0.200
    54.695    -0.952     0.200
    54.881     0.245     0.200
    55.449     0.224     0.200
    55.530     0.637     0.200
    55.700    -3.930     0.200
    55.700    -2.760     0.200
    55.700    -3.790     0.200
    55.715    -1.119     0.200
    55.647    -0.633     0.200
    55.947    -3.584     0.200
    56.473     1.103     0.200
    56.547     0.273     0.200
    56.461    -0.156     0.200
    56.776    -0.698     0.200
    56.834    -0.706     0.200
    56.965    -1.038     0.200
    56.968    -1.978     0.200
    57.078    -1.337     0.200
    57.296    -2.978     0.200
    57.377    -3.202     0.200
    57.554     1.007     0.200
    57.770    -0.420     0.200
    57.864    -2.180     0.200
    57.864    -2.680     0.200
    57.795    -0.005     0.200
    57.983    -3.884     0.200
    58.013    -1.300     0.200
    58.158    -3.845     0.200
    58.085    -1.283     0.200
    58.379    -3.868     0.200
    58.316    -0.575     0.200
    58.739    -0.773     0.200
    58.739    -0.228     0.200
    58.747    -0.302     0.200
    58.747    -0.153     0.200
    58.747    -1.352     0.200
    58.753    -0.284     0.200
    58.754    -0.162     0.200
    58.754     0.205     0.200
    59.107    -0.057     0.200
    59.162    -0.555     0.200
    59.162    -1.024     0.200
    59.209    -0.015     0.200
    59.209     0.370     0.200
    59.328     0.229     0.200
    59.328    -0.062     0.200
    59.230     0.591     0.200
    59.263     0.662     0.200
    59.476    -2.362     0.200
    59.476     0.189     0.200
    59.676    -3.389     0.200
    59.846    -4.198     0.200
    59.997    -2.697     0.200
    59.925     1.413     0.200
    59.925    -0.001     0.200
    60.133    -0.529     0.200
    60.079    -2.353     0.200
    62.430    -4.940     0.200
    62.478    -4.480     0.200
    62.478    -2.146     0.200
    62.478    -5.211     0.200
    63.508    -4.014     0.200
    63.508    -3.664     0.200
    63.751     0.732     0.200
    64.082    -1.244     0.200
    64.818    -1.965     0.200
    64.930    -1.825     0.200
    66.551    -3.480     0.200
    66.536    -1.728     0.200
    66.536     0.643     0.200
    67.347    -4.047     0.200
    67.399     2.148     0.200
    67.399     1.722     0.200
    67.399     0.947     0.200
    68.077    -1.440     0.200
    68.721     1.240     0.200
    68.852     1.096     0.200
    68.852     0.026     0.200
    69.731     1.679     0.200
    69.781     1.294     0.200
    69.781     1.191     0.200
    69.781     0.568     0.200
    69.781     1.669     0.200
    69.877     0.682     0.200
    70.999    -3.529     0.200
    70.999    -2.980     0.200
    71.107    -2.387     0.200
    72.458     0.439     0.200
    73.270    -3.881     0.200
    73.557    -0.369     0.200
    73.557    -2.219     0.200
    73.557    -3.478     0.200
    73.991    -1.420     0.200
    73.946    -1.161     0.200
    73.946    -0.655     0.200
    74.431    -2.796     0.200
    74.652    -3.676     0.200
    74.652    -3.171     0.200
    74.652    -1.469     0.200
    74.717    -3.687     0.200
    75.537     0.727     0.200
    75.910     0.876     0.200
    75.993     0.643     0.200
    75.993     1.217     0.200
    75.993    -0.283     0.200
    76.310     1.016     0.200
    76.310     1.559     0.200
    76.587     1.041     0.200
    76.640    -2.683     0.200
    76.640    -1.857     0.200
    76.640    -1.157     0.200
    76.804    -1.384     0.200
    76.864    -1.106     0.200
    76.905    -3.403     0.200
    76.908    -3.029     0.200
    77.076    -0.814     0.200
    77.152    -0.890     0.200
    77.152     1.559     0.200
    77.321    -2.465     0.200
    77.321    -4.051     0.200
    77.321    -1.391     0.200
    77.321    -1.190     0.200
    77.616    -1.544     0.200
    77.459     1.594     0.200
    77.459     0.436     0.200
    77.767    -2.585     0.200
    78.007     0.981     0.200
    78.050    -0.862     0.200
    78.075    -1.623     0.200
    78.075    -1.097     0.200
    78.075    -1.998     0.200
    78.164    -3.341     0.200
    78.164    -1.591     0.200
    78.599    -0.849     0.200
    79.337     1.251     0.200
    79.775    -4.120     0.200
    79.869    -2.365     0.200
    79.931    -3.100     0.200
    80.780     0.054     0.200
    80.780    -1.747     0.200
    81.451     1.390     0.200
    81.689     0.521     0.200
    81.816    -1.646     0.200
    81.822    -1.039     0.200
    81.822    -1.582     0.200
    81.822    -1.383     0.200
    81.856    -3.261     0.200
    81.788    -2.201     0.200
    82.001    -1.124     0.200
    82.045    -2.117     0.200
    82.507    -1.773     0.200
    82.971     2.313     0.200
    83.019     0.484     0.200
    83.019    -1.994     0.200
    83.119     3.057     0.200
    83.119     2.846     0.200
    83.825    -3.066     0.200
    83.741    -2.025     0.200
    84.174     0.297     0.200
    84.366    -0.641     0.200
    84.711    -1.817     0.200
    85.181     3.748     0.200
    85.529    -4.217     0.200
    86.773    -0.243     0.200
    86.857     0.346     0.200
    87.125    -0.325     0.200
    87.160    -0.189     0.200
    87.211    -1.475     0.200
    87.211     1.536     0.200
    87.600    -0.103     0.200
    87.600    -2.560     0.200
    87.641    -0.810     0.200
    87.648    -1.874     0.200
    87.676     0.090     0.200
    87.683    -2.317     0.200
    87.683    -1.741     0.200
    87.691    -2.280     0.200
    87.691    -1.777     0.200
    87.691    -0.579     0.200
    87.857     0.820     0.200
    88.239     0.169     0.200
    88.239     0.417     0.200
    88.239     0.495     0.200
    88.256     0.724     0.200
    88.289     0.131     0.200
    88.334    -1.433     0.200
    88.420    -1.538     0.200
    88.424    -0.152     0.200
    88.447     0.850     0.200
    88.561    -0.878     0.200
    88.696    -1.143     0.200
    88.702    -0.599     0.200
    88.702     0.704     0.200
    88.965    -1.009     0.200
    89.175     0.442     0.200
    89.242    -0.485     0.200
    89.386    -0.553     0.200
    89.586     0.202     0.200
    89.599     0.059     0.200
    89.615    -3.319     0.200
    89.615     0.142     0.200
    89.561     1.140     0.200
    89.561     1.998     0.200
    89.859     0.303     0.200
    89.891    -0.148     0.200
    89.898    -0.082     0.200
    90.068    -0.083     0.200
    90.220    -0.285     0.200
    90.678     0.610     0.200
    90.847    -0.101     0.200
    90.881     0.182     0.200
    91.054     0.247     0.200
    91.375     0.141     0.200
    91.388     0.833     0.200
    91.206     1.228     0.200
    91.534    -0.323     0.200
    91.755    -1.213     0.200
    91.758     1.372     0.200
    91.585     1.710     0.200
    91.729     1.253     0.200
    92.679    -2.598     0.200
    95.394    -3.304     0.200
    97.257    -2.907     0.200
    97.380    -1.675     0.200
    97.653    -2.233     0.200
    97.903    -4.229     0.200
    99.016    -1.202     0.200
    99.089    -1.213     0.200
    20.776    -0.540     0.200
    20.776    -0.966     0.200
    26.904    -3.355     0.200
    27.370    -4.520     0.200
    29.053    -0.916     0.200
    29.053    -1.791     0.200
    30.174    -0.897     0.200
    30.174    -1.296     0.200
    35.755    -2.934     0.200
    40.044    -0.326     0.200
    58.727    -5.033     0.200
    63.292    -3.807     0.200
    67.474    -4.317     0.200
    70.182    -3.664     0.200
    70.182    -3.746     0.200
    21.276    -0.408     0.200
    26.393     0.044     0.200
    29.485    -1.280     0.200
    30.720    -0.527     0.200
    40.690    -0.461     0.200
    76.101    -0.528     0.200
    81.779    -1.721     0.200
    83.138    -0.830     0.200
    21.273    -0.775     0.200
    29.479    -0.902     0.200
    30.718     0.078     0.200
    40.691     0.245     0.200
    57.754    -1.229     0.200
    83.160    -2.233     0.200
    28.209     0.683     0.200
    29.528     0.314     0.200
    39.586     0.866     0.200
    39.586    -0.251     0.200
    42.249    -0.832     0.200
    58.359    -0.969     0.200
    58.359    -1.509     0.200
    89.999     0.136     0.200
    21.107     0.104     0.200
    29.295     0.647     0.200
    30.562     0.540     0.200
    40.563     0.532     0.200
    66.287    -2.562     0.200
    21.291     0.406     0.200
    21.291    -0.180     0.200
    23.003    -1.089     0.200
    23.937    -1.509     0.200
    26.365    -2.377     0.200
    26.365    -2.603     0.200
    29.497     0.140     0.200
    29.504    -0.453     0.200
    30.736     1.059     0.200
    30.736     0.317     0.200
    40.709     0.749     0.200
    40.709    -0.134     0.200
    43.626    -0.136     0.200
    54.420    -1.008     0.200
    57.741    -1.182     0.200
    66.399    -1.263     0.200
    67.229    -2.031     0.200
    81.761    -1.147     0.200
    83.169    -1.472     0.200
    20.648     0.397     0.200
    22.373     1.042     0.200
    23.167     1.543     0.200
    23.836    -1.666     0.200
    26.883    -1.204     0.200
    26.883    -1.833     0.200
    28.859     0.233     0.200
    30.092     0.491     0.200
    30.092     0.190     0.200
    30.433     2.033     0.200
    33.706     0.318     0.200
    40.069     0.267     0.200
    40.069     0.603     0.200
    42.984     1.301     0.200
    54.802    -1.926     0.200
    58.272    -1.089     0.200
    58.272    -0.945     0.200
    69.885    -0.738     0.200
    82.793     1.477     0.200
    14.579     3.946     0.200
    16.792     1.952     0.200
    16.850     1.413     0.200
    17.074     0.995     0.200
    17.197     1.755     0.200
    18.393    -0.471     0.200
    20.493     0.731     0.200
    20.493    -0.422     0.200
    20.642    -0.395     0.200
    21.836     1.680     0.200
    21.836     3.332     0.200
    22.226     0.088     0.200
    22.226     0.228     0.200
    23.701    -1.055     0.200
    24.499    -0.631     0.200
    25.475    -2.480     0.200
    26.264    -1.396     0.200
    27.031    -1.914     0.200
    27.031    -0.797     0.200
    27.031    -1.684     0.200
    27.363     0.402     0.200
    27.349     0.176     0.200
    28.707     0.119     0.200
    28.714     0.440     0.200
    29.936     0.846     0.200
    29.936    -0.256     0.200
    30.071    -1.283     0.200
    32.628     2.880     0.200
    33.514    -0.991     0.200
    33.514    -1.605     0.200
    33.557    -0.846     0.200
    38.296    -0.081     0.200
    39.433    -0.560     0.200
    39.433    -0.228     0.200
    39.433     0.635     0.200
    39.636     0.052     0.200
    39.910     0.674     0.200
    39.910    -0.064     0.200
    39.910     1.834     0.200
    42.826     0.985     0.200
    42.826    -0.367     0.200
    54.020    -0.241     0.200
    54.923    -0.252     0.200
    54.923    -1.662     0.200
    54.945    -1.309     0.200
    55.775    -1.580     0.200
    55.775    -1.521     0.200
    56.541    -1.912     0.200
    57.061     0.284     0.200
    58.421    -1.464     0.200
    58.421    -2.152     0.200
    62.989    -2.067     0.200
    64.014    -2.307     0.200
    64.014    -2.795     0.200
    66.863    -1.749     0.200
    67.932    -1.947     0.200
    70.043    -2.570     0.200
    70.043    -2.449     0.200
    75.259    -2.090     0.200
    75.529     0.160     0.200
    75.529    -0.430     0.200
    76.997    -1.020     0.200
    82.560    -0.960     0.200
    82.560     0.040     0.200
    82.560    -1.612     0.200
    88.478    -1.464     0.200
    21.281    -2.068     0.200
    27.621    -2.614     0.200
    29.489    -0.265     0.200
    30.725    -0.182     0.200
    40.696     1.085     0.200
    17.150     0.860     0.200
    17.972     0.175     0.200
    18.340    -0.342     0.200
    18.340    -0.000     0.200
    19.836    -0.894     0.200
    19.797    -1.211     0.200
    19.797    -2.791     0.200
    20.740     1.708     0.200
    21.594     2.881     0.200
    22.617    -0.106     0.200
    22.617    -0.727     0.200
    22.617    -1.218     0.200
    24.214    -0.504     0.200
    25.067    -3.870     0.200
    25.619     0.046     0.200
    25.942    -4.191     0.200
    26.972    -2.775     0.200
    27.436    -4.089     0.200
    27.774    -3.402     0.200
    29.021     0.317     0.200
    29.736     3.119     0.200
    30.041     2.218     0.200
    30.134     0.578     0.200
    30.134    -0.232     0.200
    30.172    -0.255     0.200
    30.980     2.224     0.200
    33.902    -0.161     0.200
    34.379    -2.335     0.200
    36.544     2.348     0.200
    36.544    -0.312     0.200
    37.460     0.420     0.200
    37.460    -0.791     0.200
    37.654     0.706     0.200
    39.773    -6.399     0.200
    39.831     1.207     0.200
    39.831    -0.594     0.200
    39.831    -0.985     0.200
    39.871     2.049     0.200
    39.871    -0.912     0.200
    39.997     1.737     0.200
    39.997     1.389     0.200
    39.997     0.936     0.200
    40.700    -3.591     0.200
    40.745    -4.549     0.200
    42.516    -4.847     0.200
    42.713    -3.343     0.200
    42.961     2.029     0.200
    42.961     0.639     0.200
    42.961    -0.252     0.200
    47.060     2.077     0.200
    47.060    -0.123     0.200
    47.060     1.827     0.200
    47.288     3.404     0.200
    47.288     0.234     0.200
    49.216    -3.324     0.200
    52.338    -2.532     0.200
    52.338    -2.683     0.200
    54.173    -3.279     0.200
    54.428    -3.338     0.200
    55.464    -2.384     0.200
    55.464    -2.612     0.200
    55.561    -3.301     0.200
    55.589    -2.171     0.200
    55.589    -3.062     0.200
    56.506    -3.479     0.200
    56.254     0.301     0.200
    56.629    -3.827     0.200
    56.629    -4.173     0.200
    56.827    -3.278     0.200
    56.827    -3.858     0.200
    58.302    -4.014     0.200
    58.312    -2.745     0.200
    58.438    -4.484     0.200
    58.272     0.574     0.200
    58.792    -4.103     0.200
    58.792    -4.462     0.200
    58.910    -2.796     0.200
    58.910    -3.427     0.200
    59.301    -0.444     0.200
    59.301    -1.124     0.200
    59.301    -1.974     0.200
    60.019    -3.099     0.200
    60.639    -3.755     0.200
    60.696    -3.006     0.200
    62.793     0.071     0.200
    63.235    -3.489     0.200
    63.357    -4.001     0.200
    63.406    -2.664     0.200
    63.406    -4.324     0.200
    63.406    -2.914     0.200
    64.465    -4.058     0.200
    64.487    -3.231     0.200
    64.487    -3.061     0.200
    65.851     2.799     0.200
    66.354     1.721     0.200
    66.445     1.988     0.200
    67.733     1.821     0.200
    68.255    -3.543     0.200
    68.298    -3.026     0.200
    68.842     2.148     0.200
    69.120     1.347     0.200
    69.498     1.674     0.200
    69.617     0.953     0.200
    69.792     2.614     0.200
    69.792     1.539     0.200
    69.792    -1.185     0.200
    74.432    -3.716     0.200
    74.328    -0.787     0.200
    75.021     1.030     0.200
    75.021     0.376     0.200
    75.021    -0.089     0.200
    75.540    -2.636     0.200
    75.540    -3.335     0.200
    75.540    -2.175     0.200
    75.701     0.502     0.200
    76.097     1.276     0.200
    76.315     3.010     0.200
    77.367    -2.327     0.200
    77.204     2.374     0.200
    78.304    -5.015     0.200
    78.539     0.171     0.200
    78.591     0.445     0.200
    78.591    -2.276     0.200
    78.819    -1.092     0.200
    78.919     1.221     0.200
    79.805    -0.290     0.200
    80.762    -4.715     0.200
    80.762    -4.555     0.200
    81.365    -0.147     0.200
    82.027     0.614     0.200
    82.027    -1.896     0.200
    82.027    -0.125     0.200
    82.471    -1.429     0.200
    82.471    -1.730     0.200
    82.850    -2.117     0.200
    85.535    -1.549     0.200
    86.300     0.114     0.200
    86.875     2.876     0.200
    86.906    -0.435     0.200
    88.415    -3.365     0.200
    88.450    -2.788     0.200
    88.450    -3.034     0.200
    88.458    -2.222     0.200
    88.458    -2.482     0.200
    88.458    -3.072     0.200
    88.458    -2.683     0.200
    88.510    -3.019     0.200
    88.529    -3.106     0.200
    88.552    -3.013     0.200
    88.581    -3.052     0.200
    88.812     0.353     0.200
    88.609     1.617     0.200
    88.609     1.484     0.200
    88.609     0.609     0.200
    88.609     0.049     0.200
    88.609    -0.582     0.200
    89.404     0.154     0.200
    89.404    -1.917     0.200
    90.342    -2.317     0.200
    90.342    -2.198     0.200
    90.858    -0.638     0.200
    90.898    -1.043     0.200
    91.572    -0.679     0.200
    91.671    -2.099     0.200
    92.030    -2.371     0.200
    92.339    -2.446     0.200
    92.495     0.910     0.200
    92.580    -2.659     0.200
    92.575    -1.478     0.200
    92.620    -3.508     0.200
    92.767    -1.083     0.200
    93.433    -2.486     0.200
    93.689    -2.289     0.200
    94.901    -2.965     0.200
    94.916    -1.483     0.200
    96.521    -2.854     0.200
    97.681    -0.794     0.200
    97.875    -3.626     0.200
    99.522    -3.036     0.200
    19.630     0.971     0.200
    19.630    -1.958     0.200
    22.630    -0.533     0.200
    27.261     0.047     0.200
    27.778     0.690     0.200
    27.778    -0.443     0.200
    27.784    -0.163     0.200
    29.104     0.079     0.200
    29.104    -0.171     0.200
    32.598    -0.746     0.200
    39.175     0.847     0.200
    39.175    -0.095     0.200
    42.043     0.253     0.200
    54.783     0.192     0.200
    54.783    -0.140     0.200
    58.670    -1.462     0.200
    58.670    -1.649     0.200
    63.284    -0.616     0.200
    65.116    -0.377     0.200
    66.644    -2.876     0.200
    68.239    -2.589     0.200
    68.283    -1.545     0.200
    68.413    -0.432     0.200
    70.500    -2.269     0.200
    70.500    -2.378     0.200
    75.489    -0.126     0.200
    82.844    -0.529     0.200
    82.844    -1.036     0.200
    83.316    -1.838     0.200
    89.940    -0.217     0.200
    89.940    -0.815     0.200
    19.645     0.736     0.200
    22.651    -0.012     0.200
    27.260     0.022     0.200
    27.260     0.975     0.200
    27.260    -0.197     0.200
    27.795     0.349     0.200
    27.795     0.224     0.200
    27.800     0.181     0.200
    29.118     1.158     0.200
    29.118     0.830     0.200
    38.450     0.534     0.200
    39.187     1.088     0.200
    54.790     0.543     0.200
    54.790     0.083     0.200
    58.669    -1.064     0.200
    59.043    -0.843     0.200
    63.238    -1.234     0.200
    63.283    -1.540     0.200
    66.653    -1.101     0.200
    68.407     0.549     0.200
    68.503     0.130     0.200
    75.485     0.397     0.200
    75.485    -0.150     0.200
    82.837     0.176     0.200
    82.837     0.606     0.200
    20.568     0.270     0.200
    20.568    -0.351     0.200
    22.217    -0.624     0.200
    26.667     0.795     0.200
    26.667     0.684     0.200
    26.667     1.365     0.200
    28.740    -1.116     0.200
    28.740    -1.305     0.200
    28.745    -0.347     0.200
    30.031    -0.717     0.200
    30.031    -0.258     0.200
    30.374     0.116     0.200
    33.568    -1.873     0.200
    36.742    -0.627     0.200
    40.060     0.070     0.200
    40.060     0.635     0.200
    42.950     0.128     0.200
    54.469     0.447     0.200
    20.559     0.568     0.200
    20.559     0.744     0.200
    20.830    -0.795     0.200
    22.136     2.070     0.200
    22.210     1.460     0.200
    22.210     0.429     0.200
    22.210     1.280     0.200
    23.610    -0.796     0.200
    24.086    -2.635     0.200
    26.256     0.678     0.200
    26.680    -0.266     0.200
    26.680    -0.766     0.200
    27.333     0.975     0.200
    27.333    -0.212     0.200
    28.731    -0.278     0.200
    28.737    -0.220     0.200
    30.022     0.280     0.200
    30.022    -0.149     0.200
    30.058     0.956     0.200
    30.363    -0.685     0.200
    30.574     3.387     0.200
    33.561     0.127     0.200
    36.731    -0.100     0.200
    39.700     0.631     0.200
    40.050     0.595     0.200
    40.050     0.462     0.200
    40.050     0.845     0.200
    42.781    -0.255     0.200
    42.940     0.101     0.200
    47.117     1.812     0.200
    47.117    -1.079     0.200
    54.482    -1.162     0.200
    54.482    -1.561     0.200
    54.501    -0.821     0.200
    55.280    -1.225     0.200
    55.280    -1.417     0.200
    57.129    -1.011     0.200
    58.080    -2.257     0.200
    58.080    -2.753     0.200
    60.801     0.936     0.200
    62.648    -2.799     0.200
    62.695    -3.195     0.200
    63.640    -3.406     0.200
    63.640    -3.257     0.200
    66.407    -2.126     0.200
    67.610    -3.449     0.200
    68.754    -0.742     0.200
    69.775    -3.694     0.200
    69.775    -3.205     0.200
    74.738     1.443     0.200
    74.954    -3.977     0.200
    75.928     0.092     0.200
    75.928    -0.307     0.200
    77.209     1.142     0.200
    78.357     0.655     0.200
    78.785     2.457     0.200
    80.201     1.385     0.200
    80.201     0.424     0.200
    80.201     1.724     0.200
    80.331     1.374     0.200
    80.331    -0.724     0.200
    80.331    -0.294     0.200
    82.429     0.496     0.200
    82.429    -1.742     0.200
    83.119    -0.694     0.200
    83.119     0.173     0.200
    88.096     1.337     0.200
    88.096    -0.105     0.200
    88.849    -0.139     0.200
    89.924     1.232     0.200
    89.924     0.240     0.200
    89.924     0.622     0.200
    89.924     1.775     0.200
    91.571     1.047     0.200
    92.085     1.226     0.200
    18.256     0.517     0.200
    18.624     0.841     0.200
    18.639     0.966     0.200
    20.580     0.913     0.200
    20.580     0.034     0.200
    22.166     1.301     0.200
    22.228     0.378     0.200
    22.228     1.238     0.200
    23.403     0.863     0.200
    23.624     1.602     0.200
    24.054    -0.139     0.200
    24.054    -2.588     0.200
    24.544     0.739     0.200
    26.649    -0.910     0.200
    26.649    -2.910     0.200
    26.981    -0.528     0.200
    26.979    -0.417     0.200
    28.751    -0.276     0.200
    28.751     0.165     0.200
    30.044     0.409     0.200
    32.741    -0.198     0.200
    33.585     0.077     0.200
    36.758     0.543     0.200
    36.758     0.024     0.200
    39.721     0.492     0.200
    40.074     0.738     0.200
    40.074     0.277     0.200
    42.932     0.749     0.200
    42.964     1.322     0.200
    42.964     0.201     0.200
    46.237     1.391     0.200
    47.141     1.225     0.200
    54.451    -0.281     0.200
    54.451    -1.832     0.200
    58.049    -2.545     0.200
    59.591    -1.351     0.200
    60.808    -0.329     0.200
    62.039     0.089     0.200
    62.617    -2.647     0.200
    63.608    -3.677     0.200
    66.376    -2.203     0.200
    67.579    -3.156     0.200
    67.787     1.451     0.200
    69.746    -3.436     0.200
    69.746    -3.604     0.200
    74.748     1.137     0.200
    75.960     0.263     0.200
    75.960    -0.237     0.200
    75.960     0.052     0.200
    77.031     0.946     0.200
    78.360     0.718     0.200
    80.210     1.181     0.200
    80.341    -0.203     0.200
    80.341    -0.867     0.200
    83.151    -1.103     0.200
    83.151     0.233     0.200
    88.102     1.343     0.200
    89.230     0.217     0.200
    89.953     1.053     0.200
    89.953     0.612     0.200
    89.953    -1.216     0.200
    96.368     0.320     0.200
    99.369    -0.158     0.200
    51.376     3.832     0.200
    17.346    -0.046     0.200
    21.000     0.833     0.200
    21.000     0.622     0.200
    22.857     0.586     0.200
    22.857    -0.812     0.200
    25.745    -1.294     0.200
    27.170    -5.046     0.200
    27.170    -3.687     0.200
    27.508    -4.224     0.200
    27.506    -4.104     0.200
    29.273    -0.500     0.200
    29.273    -0.648     0.200
    29.280    -0.502     0.200
    30.719     1.556     0.200
    30.400     0.847     0.200
    30.400    -0.301     0.200
    33.933    -7.360     0.200
    34.150     1.952     0.200
    34.150    -0.603     0.200
    40.273     1.079     0.200
    40.273     1.485     0.200
    40.757    -0.924     0.200
    43.233     2.697     0.200
    43.233     2.384     0.200
    47.441    -2.632     0.200
    52.056    -1.914     0.200
    52.979    -5.949     0.200
    52.979    -4.496     0.200
    54.910    -3.594     0.200
    56.572    -4.407     0.200
    57.092    -1.188     0.200
    58.030    -2.982     0.200
    58.161    -5.226     0.200
    58.161    -4.226     0.200
    58.522    -4.118     0.200
    58.941    -2.026     0.200
    58.941    -3.253     0.200
    59.033     0.058     0.200
    59.033    -0.950     0.200
    60.462    -4.110     0.200
    60.779    -4.852     0.200
    63.086    -3.929     0.200
    63.135    -2.254     0.200
    63.135    -3.183     0.200
    63.107    -3.411     0.200
    63.137    -3.891     0.200
    64.203    -4.904     0.200
    64.203    -5.099     0.200
    64.205    -2.158     0.200
    67.324    -5.238     0.200
    67.462    -0.033     0.200
    67.980    -3.740     0.200
    68.023    -3.629     0.200
    67.974     1.088     0.200
    69.392     0.607     0.200
    69.960    -3.547     0.200
    69.960    -3.336     0.200
    71.784    -4.545     0.200
    71.536    -0.472     0.200
    74.681    -1.539     0.200
    75.151    -1.014     0.200
    75.263    -3.446     0.200
    75.637    -3.355     0.200
    75.653    -0.997     0.200
    76.143     2.440     0.200
    77.086    -2.142     0.200
    77.097     2.218     0.200
    78.240     0.307     0.200
    78.328     0.432     0.200
    78.487    -0.484     0.200
    78.548    -4.251     0.200
    80.555    -4.747     0.200
    81.095     0.156     0.200
    82.195    -1.311     0.200
    82.195    -1.552     0.200
    82.195    -1.310     0.200
    82.574    -0.506     0.200
    82.255     0.845     0.200
    82.255     1.548     0.200
    82.255    -0.452     0.200
    87.548    -1.147     0.200
    87.639    -1.196     0.200
    88.168    -1.901     0.200
    88.176    -1.330     0.200
    88.176    -2.166     0.200
    88.463     0.309     0.200
    91.910    -1.177     0.200
    92.217    -1.266     0.200
    93.559    -1.784     0.200
    94.168    -3.434     0.200
    94.168    -2.755     0.200
    97.618    -3.057     0.200
    99.254    -1.785     0.200
    15.568     2.101     0.200
    16.718     0.609     0.200
    18.164    -3.910     0.200
    18.440    -0.318     0.200
    18.440     0.283     0.200
    20.187    -1.966     0.200
    20.187    -0.908     0.200
    21.246     0.318     0.200
    21.246     0.783     0.200
    22.435    -1.714     0.200
    22.008     1.292     0.200
    22.008     3.394     0.200
    23.161    -2.919     0.200
    23.161    -2.329     0.200
    23.127    -1.259     0.200
    23.127    -0.138     0.200
    23.127    -0.458     0.200
    23.013     2.208     0.200
    24.817    -4.551     0.200
    24.817    -3.442     0.200
    24.715    -1.161     0.200
    25.578    -2.414     0.200
    26.042    -2.712     0.200
    26.042    -1.732     0.200
    26.042    -1.291     0.200
    25.982    -1.953     0.200
    26.814    -1.765     0.200
    27.103    -4.258     0.200
    27.103    -4.547     0.200
    27.103    -3.246     0.200
    27.442    -3.900     0.200
    27.442    -4.380     0.200
    27.440    -4.342     0.200
    27.216    -0.026     0.200
    27.514     1.344     0.200
    29.517     0.120     0.200
    29.530    -0.554     0.200
    29.537    -1.037     0.200
    29.537    -0.549     0.200
    29.537    -0.248     0.200
    29.537     0.162     0.200
    30.473    -0.461     0.200
    30.495     0.228     0.200
    30.495     1.087     0.200
    30.495     0.587     0.200
    30.637     0.830     0.200
    30.637    -0.264     0.200
    30.637     0.916     0.200
    30.674     0.801     0.200
    34.157    -2.673     0.200
    34.015    -0.139     0.200
    34.414    -3.070     0.200
    34.412     0.012     0.200
    34.412     0.211     0.200
    35.328    -0.300     0.200
    35.829    -2.244     0.200
    36.475    -1.380     0.200
    36.475    -0.970     0.200
    37.179    -6.128     0.200
    37.286    -1.543     0.200
    37.016     0.003     0.200
    37.016     0.503     0.200
    37.959     0.813     0.200
    37.959     1.114     0.200
    37.959     1.395     0.200
    38.162    -0.042     0.200
    39.271     0.242     0.200
    39.271     0.664     0.200
    40.298    -2.812     0.200
    40.188     0.069     0.200
    40.188    -0.521     0.200
    40.340     0.545     0.200
    40.340     0.467     0.200
    40.340     0.897     0.200
    40.340     1.604     0.200
    40.376     0.953     0.200
    40.376     2.016     0.200
    40.485    -0.193     0.200
    40.485     0.381     0.200
    41.055    -0.947     0.200
    41.055    -0.455     0.200
    43.172     1.657     0.200
    43.455     0.840     0.200
    43.455     1.071     0.200
    45.249    -3.000     0.200
    45.564    -0.961     0.200
    46.076     2.365     0.200
    46.669     1.095     0.200
    48.063    -3.292     0.200
    48.063    -2.753     0.200
    47.547     1.349     0.200
    47.547     1.822     0.200
    47.790     2.578     0.200
    47.790     1.641     0.200
    47.790     2.821     0.200
    48.428    -2.104     0.200
    48.356     1.546     0.200
    48.585    -0.511     0.200
    48.738    -3.529     0.200
    49.196    -1.784     0.200
    49.197    -3.089     0.200
    51.617    -4.532     0.200
    51.617    -4.271     0.200
    51.617    -3.892     0.200
    51.988    -4.638     0.200
    51.988    -4.318     0.200
    51.896    -2.832     0.200
    51.896    -2.372     0.200
    51.423     0.949     0.200
    53.150    -2.354     0.200
    53.150    -5.251     0.200
    53.150    -5.167     0.200
    53.150    -4.405     0.200
    54.103    -4.137     0.200
    54.091    -0.448     0.200
    54.831    -2.823     0.200
    54.798    -3.880     0.200
    55.347    -3.146     0.200
    55.380    -2.698     0.200
    55.380    -2.480     0.200
    55.392    -2.580     0.200
    55.750    -1.777     0.200
    55.837    -3.083     0.200
    56.126    -3.431     0.200
    56.171    -3.403     0.200
    56.442    -3.681     0.200
    56.434    -3.100     0.200
    56.434    -2.331     0.200
    56.434    -1.323     0.200
    56.469    -2.773     0.200
    56.603    -3.963     0.200
    56.603    -3.017     0.200
    56.502    -3.106     0.200
    56.679    -3.053     0.200
    56.758    -1.739     0.200
    56.904    -3.369     0.200
    56.949    -2.060     0.200
    57.268    -0.753     0.200
    57.330    -2.813     0.200
    57.508    -2.505     0.200
    57.816    -3.942     0.200
    57.735    -2.364     0.200
    57.966    -2.843     0.200
    57.887    -1.794     0.200
    58.036    -4.132     0.200
    58.036    -2.101     0.200
    58.036    -2.351     0.200
    58.229    -4.151     0.200
    58.296    -3.157     0.200
    58.168    -0.838     0.200
    58.439    -4.046     0.200
    58.439    -3.608     0.200
    58.593    -1.365     0.200
    58.774    -0.062     0.200
    58.800    -0.217     0.200
    58.800     0.201     0.200
    58.800     1.540     0.200
    58.800    -0.464     0.200
    58.804     0.505     0.200
    58.884    -0.948     0.200
    58.497     0.154     0.200
    58.497     0.533     0.200
    59.023    -0.634     0.200
    59.207    -0.065     0.200
    59.259    -0.022     0.200
    59.352     0.128     0.200
    59.598    -3.382     0.200
    59.585    -2.646     0.200
    59.195     1.524     0.200
    59.724    -3.097     0.200
    59.818    -2.784     0.200
    60.127    -3.534     0.200
    60.161    -2.526     0.200
    60.556    -3.839     0.200
    60.562    -3.346     0.200
    60.890    -4.217     0.200
    60.890    -4.366     0.200
    61.055    -3.155     0.200
    62.258    -2.900     0.200
    63.001    -3.860     0.200
    63.051    -2.826     0.200
    63.051    -3.443     0.200
    63.256    -2.984     0.200
    63.256    -3.527     0.200
    63.256    -3.086     0.200
    63.286    -5.181     0.200
    64.147    -3.596     0.200
    64.147    -4.654     0.200
    64.147    -4.166     0.200
    64.022    -1.486     0.200
    64.022    -1.076     0.200
    64.604    -2.835     0.200
    65.347    -1.876     0.200
    66.513     1.180     0.200
    66.513     0.720     0.200
    67.357    -4.363     0.200
    67.457    -0.841     0.200
    67.588    -0.747     0.200
    67.881    -3.463     0.200
    67.924    -2.609     0.200
    67.924    -2.730     0.200
    68.143    -1.300     0.200
    67.981     2.354     0.200
    69.322     1.613     0.200
    69.824    -2.001     0.200
    69.614    -0.246     0.200
    70.121    -0.415     0.200
    70.121     1.155     0.200
    69.994     0.892     0.200
    69.994     1.630     0.200
    71.859    -4.181     0.200
    71.859    -4.501     0.200
    71.859    -3.880     0.200
    74.162    -0.706     0.200
    74.473    -3.791     0.200
    74.473    -3.103     0.200
    74.505    -1.900     0.200
    74.494    -0.235     0.200
    74.887    -3.320     0.200
    74.960     0.063     0.200
    75.150    -2.229     0.200
    75.157    -0.599     0.200
    75.761    -2.994     0.200
    75.761    -2.771     0.200
    75.842    -0.994     0.200
    75.314     0.502     0.200
    76.111    -0.463     0.200
    76.341    -1.734     0.200
    76.839    -0.348     0.200
    76.899    -0.886     0.200
    76.899    -1.312     0.200
    76.392     1.399     0.200
    76.392     1.739     0.200
    77.132    -1.493     0.200
    77.132    -1.184     0.200
    77.210    -0.114     0.200
    78.039    -2.752     0.200
    78.039    -3.303     0.200
    78.036     0.320     0.200
    78.086     0.076     0.200
    78.086    -0.553     0.200
    78.086     0.685     0.200
    78.280    -0.625     0.200
    78.334    -0.208     0.200
    78.664    -1.606     0.200
    78.664    -3.751     0.200
    78.664    -0.336     0.200
    78.786    -1.155     0.200
    78.581     1.953     0.200
    78.698     2.580     0.200
    78.698     2.447     0.200
    78.698     2.916     0.200
    79.315    -0.393     0.200
    79.507    -0.579     0.200
    80.352    -1.887     0.200
    80.608    -3.982     0.200
    80.608    -4.822     0.200
    80.868    -0.089     0.200
    80.868     0.852     0.200
    80.947     0.017     0.200
    81.985    -1.258     0.200
    82.361    -0.221     0.200
    82.238     0.354     0.200
    82.238     0.550     0.200
    84.285     2.162     0.200
    85.841    -2.030     0.200
    85.806    -0.095     0.200
    86.399    -4.605     0.200
    86.568     1.088     0.200
    86.504     2.823     0.200
    87.353    -0.921     0.200
    87.989     0.133     0.200
    87.997    -2.581     0.200
    87.997    -1.506     0.200
    88.005    -2.545     0.200
    88.005    -1.673     0.200
    88.098    -1.289     0.200
    88.474    -0.387     0.200
    88.930    -0.031     0.200
    88.930    -0.492     0.200
    88.672     1.283     0.200
    88.672     1.045     0.200
    88.672     2.002     0.200
    89.751    -1.257     0.200
    89.809    -1.250     0.200
    90.429    -3.029     0.200
    90.361    -0.733     0.200
    91.097    -0.676     0.200
    91.250    -1.884     0.200
    91.652    -2.769     0.200
    91.839    -0.985     0.200
    91.959    -2.780     0.200
    92.031    -0.513     0.200
    92.211    -2.954     0.200
    92.214    -2.789     0.200
    92.214    -1.808     0.200
    92.323    -1.311     0.200
    91.842     0.672     0.200
    92.780    -0.580     0.200
    93.047    -2.614     0.200
    93.288    -2.241     0.200
    93.398    -1.247     0.200
    94.080    -3.293     0.200
    94.080    -1.727     0.200
    94.534    -3.097     0.200
    94.441    -1.421     0.200
    95.208    -0.976     0.200
    95.656    -2.966     0.200
    97.572    -3.620     0.200
    97.643    -1.637     0.200
    98.085    -2.518     0.200
    99.314    -2.722     0.200
    56.581    -2.331     0.200
    81.985    -0.411     0.200
    81.985    -0.640     0.200
    57.219    -1.919     0.200
    58.229    -3.147     0.200
    67.357    -3.465     0.200
    56.603    -3.478     0.200
    14.621     4.789     0.200
    16.714     2.243     0.200
    18.305     0.729     0.200
    18.011    -0.341     0.200
    18.387    -2.579     0.200
    19.173     0.379     0.200
    20.564     0.624     0.200
    20.564    -0.171     0.200
    20.564    -1.046     0.200
    21.426    -0.444     0.200
    21.426    -2.864     0.200
    22.334    -0.924     0.200
    23.228    -3.598     0.200
    22.932    -0.675     0.200
    23.839     0.223     0.200
    23.839    -2.707     0.200
    24.633    -2.665     0.200
    24.633    -4.136     0.200
    25.035    -2.157     0.200
    25.099    -0.864     0.200
    25.826     1.878     0.200
    27.121    -0.851     0.200
    27.121    -3.680     0.200
    27.121    -3.472     0.200
    26.882     0.316     0.200
    26.883     1.176     0.200
    27.456    -3.661     0.200
    27.456    -3.171     0.200
    27.454    -3.151     0.200
    27.295     1.202     0.200
    28.796     0.509     0.200
    28.802     0.428     0.200
    28.802    -1.152     0.200
    29.996    -0.403     0.200
    30.119     2.457     0.200
    30.119    -0.393     0.200
    33.449     1.261     0.200
    33.654    -0.195     0.200
    35.590     0.160     0.200
    36.555     1.469     0.200
    36.555    -1.281     0.200
    37.339     1.303     0.200
    37.340     2.097     0.200
    37.828    -2.668     0.200
    39.245    -1.352     0.200
    39.245    -1.812     0.200
    39.544     0.144     0.200
    39.544     0.154     0.200
    39.544    -1.156     0.200
    39.706     1.781     0.200
    39.942     0.476     0.200
    39.942     0.646     0.200
    40.511    -2.436     0.200
    41.307    -2.501     0.200
    42.723     2.586     0.200
    42.870     1.142     0.200
    42.870    -0.558     0.200
    43.481     2.075     0.200
    45.162     1.410     0.200
    45.162    -1.069     0.200
    46.116     1.922     0.200
    47.273    -2.661     0.200
    47.008    -1.227     0.200
    47.435    -1.725     0.200
    47.435    -1.465     0.200
    47.435    -3.314     0.200
    47.146     3.286     0.200
    47.994    -3.163     0.200
    47.970    -3.075     0.200
    48.027    -2.220     0.200
    48.571    -2.746     0.200
    48.571    -2.725     0.200
    48.571    -3.466     0.200
    52.402    -3.970     0.200
    52.402    -4.322     0.200
    53.559    -2.111     0.200
    55.077    -4.281     0.200
    55.077    -3.729     0.200
    55.100    -3.226     0.200
    55.100    -2.917     0.200
    55.100    -3.356     0.200
    55.100    -2.307     0.200
    55.889    -4.004     0.200
    56.209     1.113     0.200
    56.698    -0.069     0.200
    57.098    -0.384     0.200
    57.231    -1.992     0.200
    57.142     0.417     0.200
    57.238     1.766     0.200
    57.487    -2.112     0.200
    57.735    -2.108     0.200
    57.937     1.098     0.200
    58.217    -0.104     0.200
    58.504    -3.789     0.200
    58.504    -3.355     0.200
    58.681    -1.031     0.200
    58.750    -1.749     0.200
    58.748    -0.415     0.200
    59.429     0.698     0.200
    59.439     0.229     0.200
    59.439     0.720     0.200
    59.445     0.723     0.200
    59.662     1.123     0.200
    59.793    -1.371     0.200
    59.853     0.532     0.200
    59.901     0.987     0.200
    60.140    -3.304     0.200
    60.318    -3.326     0.200
    62.569    -3.239     0.200
    63.071    -5.209     0.200
    63.119    -4.599     0.200
    63.119    -5.210     0.200
    63.119    -3.799     0.200
    63.814     0.110     0.200
    64.118    -3.101     0.200
    64.118    -4.626     0.200
    64.118    -3.981     0.200
    64.126    -0.554     0.200
    64.457    -1.672     0.200
    64.457    -3.023     0.200
    65.831     0.506     0.200
    65.831    -2.094     0.200
    67.028    -3.951     0.200
    67.063     0.042     0.200
    68.003    -3.165     0.200
    68.046    -2.639     0.200
    68.212    -0.135     0.200
    68.183     0.061     0.200
    69.262     0.278     0.200
    69.262     1.068     0.200
    70.081    -2.208     0.200
    70.288     2.695     0.200
    70.288    -0.825     0.200
    70.288     3.009     0.200
    71.398    -3.591     0.200
    71.792    -2.539     0.200
    74.374    -1.954     0.200
    75.319    -2.416     0.200
    75.663    -1.382     0.200
    75.409    -0.248     0.200
    76.483     0.308     0.200
    76.814     0.875     0.200
    77.292    -0.611     0.200
    77.344     0.396     0.200
    77.344    -0.180     0.200
    77.879    -2.693     0.200
    78.076    -1.088     0.200
    78.688    -0.757     0.200
    78.761    -0.568     0.200
    78.809    -2.496     0.200
    78.843    -0.833     0.200
    78.862    -0.124     0.200
    79.293    -1.236     0.200
    79.257     0.049     0.200
    79.257    -2.121     0.200
    79.257    -1.073     0.200
    79.877    -1.024     0.200
    79.691     2.472     0.200
    79.691    -0.124     0.200
    80.540    -1.635     0.200
    80.540    -2.661     0.200
    81.477    -1.281     0.200
    82.526    -1.681     0.200
    82.526    -2.740     0.200
    82.517    -0.046     0.200
    82.912    -1.912     0.200
    83.191    -1.997     0.200
    83.676     0.810     0.200
    86.034    -2.558     0.200
    85.975    -1.247     0.200
    87.030    -0.006     0.200
    87.517    -0.684     0.200
    88.023    -2.258     0.200
    88.115     1.344     0.200
    88.109    -0.329     0.200
    88.384    -1.753     0.200
    88.384    -2.078     0.200
    89.406    -1.293     0.200
    89.229     1.587     0.200
    89.229    -0.335     0.200
    90.833    -1.854     0.200
    92.431    -1.206     0.200
    92.431    -3.178     0.200
    70.081    -2.468     0.200
    82.526    -2.581     0.200
    27.121    -2.901     0.200
    72.321    -2.768     0.200
    14.621     5.779     0.200
    15.742     2.795     0.200
    16.408     1.359     0.200
    16.714     1.589     0.200
    18.387    -0.094     0.200
    19.173    -1.176     0.200
    19.311     0.885     0.200
    20.564     0.385     0.200
    21.426    -0.660     0.200
    21.782     2.101     0.200
    22.334     0.165     0.200
    22.334     1.876     0.200
    22.932     1.340     0.200
    23.839     0.060     0.200
    24.690     0.714     0.200
    25.035    -1.231     0.200
    25.099    -1.218     0.200
    25.685     0.979     0.200
    25.689     2.253     0.200
    25.826     1.486     0.200
    26.440     0.961     0.200
    26.631    -0.825     0.200
    26.882     0.437     0.200
    26.883     1.659     0.200
    27.295     0.637     0.200
    27.456    -3.358     0.200
    28.802    -0.885     0.200
    29.996     1.744     0.200
    29.972     0.551     0.200
    30.119     2.079     0.200
    30.119     3.556     0.200
    32.756    -0.660     0.200
    33.475    -1.034     0.200
    33.449     0.865     0.200
    33.654    -0.416     0.200
    33.672     0.451     0.200
    35.590    -0.016     0.200
    36.555     1.296     0.200
    36.726    -0.042     0.200
    37.339     1.013     0.200
    37.340     3.027     0.200
    37.563     0.455     0.200
    38.191     1.203     0.200
    38.335     0.317     0.200
    38.425     0.738     0.200
    39.245    -1.685     0.200
    39.544    -0.287     0.200
    39.763     0.797     0.200
    42.723     2.206     0.200
    42.870     0.967     0.200
    44.382    -1.531     0.200
    45.142    -1.796     0.200
    45.162     1.906     0.200
    45.162     2.950     0.200
    46.116     1.280     0.200
    47.008     1.845     0.200
    47.146     2.877     0.200
    47.173     0.794     0.200
    47.435    -1.230     0.200
    52.402    -3.756     0.200
    54.112    -0.957     0.200
    55.100    -1.057     0.200
    58.748     1.193     0.200
    59.439     1.219     0.200
    59.548     4.600     0.200
    60.205     4.234     0.200
    63.145     1.076     0.200
    65.831     1.471     0.200
    66.494     1.540     0.200
    66.751     1.757     0.200
    67.063     2.487     0.200
    67.063     3.273     0.200
    67.339     0.822     0.200
    68.183     2.566     0.200
    69.262     1.978     0.200
    70.288     3.555     0.200
    75.319    -4.340     0.200
    78.761    -0.169     0.200
    78.761     0.932     0.200
    79.585     2.597     0.200
    81.477     1.369     0.200
    83.191    -2.190     0.200
    87.517     3.566     0.200
    89.229     3.006     0.200
    29.996     1.067     0.200
    28.726     1.446     0.200
    24.579     2.771     0.200
    79.691     3.746     0.200
    28.119     0.271     0.200
    25.207     1.511     0.200
    25.471     1.283     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
    99.628    -1.444     0.200
    99.628    -2.085     0.200
    99.667    -0.913     0.200
   100.273    -0.238     0.200
   100.540    -0.644     0.200
   100.721     0.651     0.200
   100.921    -1.955     0.200
   101.859    -2.376     0.200
   101.905    -1.684     0.200
   101.914    -2.388     0.200
   102.186    -1.496     0.200
   102.196    -2.133     0.200
   102.308    -2.029     0.200
   102.702    -1.648     0.200
   103.258    -2.081     0.200
   103.282    -2.657     0.200
   103.558    -1.540     0.200
   103.589    -2.911     0.200
   103.842    -2.073     0.200
   103.953    -3.520     0.200
   103.998    -2.985     0.200
   104.063    -1.496     0.200
   105.043    -1.713     0.200
   105.174    -0.604     0.200
   105.299    -0.446     0.200
   105.763    -1.094     0.200
   106.332    -2.100     0.200
   106.555     0.856     0.200
   107.278    -1.828     0.200
   107.930    -3.103     0.200
   109.143     0.001     0.200
    99.564    -2.436     0.200
    99.630    -1.074     0.200
    99.630    -0.933     0.200
    99.736    -2.222     0.200
   100.168    -2.253     0.200
   100.931    -2.029     0.200
   102.134    -2.202     0.200
   102.340    -2.245     0.200
   102.354    -1.861     0.200
   102.835    -2.516     0.200
   103.365    -2.747     0.200
   103.520    -2.794     0.200
   103.664    -2.498     0.200
   103.965    -4.275     0.200
   103.965    -3.017     0.200
   104.018    -2.585     0.200
   105.072    -2.384     0.200
   105.474    -0.027     0.200
   105.477    -0.041     0.200
   106.901    -0.653     0.200
   107.842    -2.702     0.200
    99.633    -1.939     0.200
    99.691    -2.054     0.200
    99.731    -0.978     0.200
    99.744    -1.655     0.200
    99.804    -2.057     0.200
    99.987    -2.173     0.200
   100.033    -1.815     0.200
   100.064    -2.245     0.200
   100.203    -2.086     0.200
   100.240    -2.401     0.200
   100.348    -2.031     0.200
   100.432    -2.308     0.200
   100.451    -2.891     0.200
   100.451    -2.653     0.200
   100.468    -1.930     0.200
   100.503    -1.571     0.200
   100.688    -1.835     0.200
   100.786    -1.759     0.200
   100.792    -2.124     0.200
   101.098    -2.316     0.200
   101.102    -2.406     0.200
   101.160    -1.843     0.200
   101.202    -1.834     0.200
   101.213    -4.442     0.200
   101.213    -2.142     0.200
   101.533    -1.636     0.200
   101.568    -1.765     0.200
   101.625    -2.010     0.200
   101.807    -2.029     0.200
   101.902    -2.010     0.200
   101.919    -2.129     0.200
   101.933    -2.127     0.200
   102.087    -1.712     0.200
   102.090    -1.997     0.200
   102.365    -1.752     0.200
   102.369    -2.029     0.200
   102.452    -2.317     0.200
   102.470    -2.581     0.200
   102.482    -2.041     0.200
   102.489    -2.227     0.200
   102.514    -2.588     0.200
   102.545    -2.834     0.200
   102.866    -2.750     0.200
   103.030    -2.704     0.200
   103.196    -1.219     0.200
   103.242    -1.796     0.200
   103.365    -2.078     0.200
   103.440    -1.478     0.200
   103.519    -1.362     0.200
   103.555    -1.769     0.200
   103.682    -1.896     0.200
   103.721    -1.816     0.200
   103.928    -2.227     0.200
   104.024    -1.792     0.200
   104.030    -1.685     0.200
   104.133    -4.752     0.200
   104.168    -1.921     0.200
   104.311    -2.182     0.200
   104.554    -2.664     0.200
   104.879    -1.530     0.200
   105.505    -3.900     0.200
    99.584    -3.059     0.200
    99.675    -1.558     0.200
    99.675    -2.358     0.200
    99.675    -2.312     0.200
    99.681    -1.655     0.200
   100.279    -2.781     0.200
   100.766     0.293     0.200
   102.210    -1.427     0.200
   102.481    -3.149     0.200
   103.279    -2.580     0.200
   103.975    -3.872     0.200
   105.379    -1.715     0.200
   105.433    -3.002     0.200
   105.433    -2.852     0.200
   107.957    -3.173     0.200
    99.698    -1.296     0.200
   100.277    -2.105     0.200
   101.282    -2.572     0.200
    99.690    -1.466     0.200
   102.099    -0.506     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    27.339   198.952     0.200
    29.096   187.309     0.200
    30.217   179.434     0.200
    33.058   163.406     0.200
    34.132   156.067     0.200
    41.077   121.692     0.200
    47.513    89.246     0.200
    53.030    66.901     0.200
    54.331    62.395     0.200
    55.471    58.056     0.200
    55.592    56.784     0.200
    58.106    49.471     0.200
    59.387    46.180     0.200
    59.927    42.058     0.200
    61.314    37.309     0.200
    64.369    31.100     0.200
    65.572    28.483     0.200
    71.895    15.124     0.200
    26.223   206.910     0.200
    29.935   182.829     0.200
    29.935   182.818     0.200
    31.140   175.606     0.200
    31.177   173.340     0.200
    41.077   119.867     0.200
    26.583   203.701     0.200
    26.622   203.454     0.200
    26.622   203.618     0.200
    27.461   198.554     0.200
    30.204   180.473     0.200
    30.204   180.485     0.200
    31.123   175.534     0.200
    31.309   174.054     0.200
    37.663   137.318     0.200
    41.008   120.171     0.200
    41.147   119.281     0.200
    43.316   107.938     0.200
    46.935    91.417     0.200
    48.335    85.262     0.200
    49.113    81.880     0.200
    49.113    81.879     0.200
    49.147    81.512     0.200
    53.177    66.645     0.200
    53.177    66.642     0.200
    53.602    65.275     0.200
    53.954    63.403     0.200
    55.012    59.782     0.200
    55.012    59.782     0.200
    56.010    55.052     0.200
    56.510    54.438     0.200
    57.468    53.320     0.200
    57.607    50.525     0.200
    59.038    46.441     0.200
    59.561    45.423     0.200
    62.489    37.287     0.200
    72.233    13.728     0.200
    74.128    12.042     0.200
    78.323     6.329     0.200
    80.295    10.072     0.200
    99.513    -0.262     0.200
    29.037   187.558     0.200
    30.153   180.148     0.200
    55.535    58.092     0.200
    27.357   198.913     0.200
    29.044   187.664     0.200
    30.168   181.334     0.200
    55.472    58.795     0.200
    27.439   198.073     0.200
    29.141   186.482     0.200
    37.687   134.851     0.200
    45.777    97.275     0.200
    55.611    57.264     0.200
    28.686   189.130     0.200
    55.475    56.765     0.200
    29.073   187.491     0.200
    30.179   180.631     0.200
    29.965   180.336     0.200
    29.288   185.672     0.200
    27.398   198.697     0.200
    29.029   187.288     0.200
    30.148   180.843     0.200
    30.148   181.140     0.200
    55.517    58.401     0.200
    63.369    33.842     0.200
    27.383   198.514     0.200
    29.053   188.204     0.200
    29.523   183.792     0.200
    30.172   180.765     0.200
    30.172   180.444     0.200
    37.730   135.385     0.200
    39.859   126.047     0.200
    39.859   124.707     0.200
    41.245   117.605     0.200
    42.552   111.407     0.200
    44.914   100.420     0.200
    45.350    98.464     0.200
    46.709    92.285     0.200
    47.636    88.341     0.200
    47.899    87.653     0.200
    49.172    81.915     0.200
    52.225    69.912     0.200
    53.047    67.558     0.200
    53.047    66.383     0.200
    54.126    63.930     0.200
    54.376    63.412     0.200
    55.509    58.444     0.200
    55.509    58.244     0.200
    55.537    58.062     0.200
    58.026    49.667     0.200
    58.308    49.729     0.200
    58.387    50.145     0.200
    58.858    45.982     0.200
    60.646    42.126     0.200
    63.305    35.276     0.200
    63.353    34.096     0.200
    63.353    33.867     0.200
    64.413    31.740     0.200
    67.685    26.729     0.200
    71.927    15.547     0.200
    73.134    14.967     0.200
    75.489     9.863     0.200
    97.040    -0.393     0.200
    97.577    -0.267     0.200
    97.662     0.047     0.200
    29.265   185.583     0.200
    30.525   177.418     0.200
    26.492   205.170     0.200
    29.470   185.605     0.200
    30.690   176.676     0.200
    30.690   176.786     0.200
    40.194   123.101     0.200
    72.458    18.638     0.200
    75.537     8.528     0.200
    84.711     4.115     0.200
    96.227     1.004     0.200
    97.334    -0.117     0.200
    97.472    -0.188     0.200
    97.903    -0.229     0.200
    29.053   186.502     0.200
    30.174   179.396     0.200
    29.479   184.715     0.200
    30.736   177.708     0.200
    29.936   183.295     0.200
    54.923    62.084     0.200
    27.436   197.569     0.200
    29.021   187.289     0.200
    30.134   180.448     0.200
    55.561    57.398     0.200
    29.104   186.278     0.200
    27.795   196.217     0.200
    29.118   187.955     0.200
    29.118   187.728     0.200
    28.731   188.672     0.200
    30.022   181.331     0.200
    30.022   181.941     0.200
    99.255    -0.454     0.200
    27.170   199.407     0.200
    29.273   185.422     0.200
    30.400   178.605     0.200
    47.441    88.173     0.200
    55.332    58.236     0.200
    63.086    35.321     0.200
    64.203    31.252     0.200
    27.103   199.949     0.200
    29.530   184.243     0.200
    30.637   177.584     0.200
    47.420    88.890     0.200
    49.197    81.344     0.200
    53.150    65.206     0.200
    54.103    62.863     0.200
    54.091    63.454     0.200
    55.347    58.163     0.200
    58.036    49.313     0.200
    60.890    40.599     0.200
    63.001    36.229     0.200
    64.147    32.303     0.200
    67.357    23.738     0.200
    27.121   199.971     0.200
    29.996   182.748     0.200
    29.996   181.258     0.200
    37.828   133.422     0.200
    39.942   125.277     0.200
    52.402    69.517     0.200
    52.402    67.348     0.200
    63.071    36.076     0.200
    63.119    33.790     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
