#!/bin/bash
gmt begin bandung1.79_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times bandung1.79'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   322.923
    25.500   327.465
    26.000   331.997
    26.500   336.517
    27.000   341.024
    27.500   345.515
    28.000   349.986
    28.500   354.441
    29.000   358.886
    29.500   363.322
    30.000   367.750
    30.500   372.170
    31.000   376.583
    31.500   380.988
    32.000   385.385
    32.500   389.772
    33.000   394.148
    33.500   398.512
    34.000   402.862
    34.500   407.196
    35.000   411.516
    35.500   415.820
    36.000   420.110
    36.500   424.384
    37.000   428.643
    37.500   432.886
    38.000   437.113
    38.500   441.324
    39.000   445.518
    39.500   449.696
    40.000   453.856
    40.500   457.999
    41.000   462.126
    41.500   466.235
    42.000   470.327
    42.500   474.402
    43.000   478.460
    43.500   482.500
    44.000   486.522
    44.500   490.527
    45.000   494.513
    45.500   498.482
    46.000   502.433
    46.500   506.365
    47.000   510.280
    47.500   514.177
    48.000   518.055
    48.500   521.915
    49.000   525.757
    49.500   529.581
    50.000   533.387
    50.500   537.174
    51.000   540.943
    51.500   544.694
    52.000   548.427
    52.500   552.142
    53.000   555.839
    53.500   559.518
    54.000   563.180
    54.500   566.823
    55.000   570.447
    55.500   574.053
    56.000   577.640
    56.500   581.209
    57.000   584.760
    57.500   588.293
    58.000   591.807
    58.500   595.304
    59.000   598.782
    59.500   602.242
    60.000   605.684
    60.500   609.107
    61.000   612.511
    61.500   615.898
    62.000   619.266
    62.500   622.616
    63.000   625.948
    63.500   629.263
    64.000   632.559
    64.500   635.838
    65.000   639.098
    65.500   642.341
    66.000   645.565
    66.500   648.772
    67.000   651.960
    67.500   655.131
    68.000   658.283
    68.500   661.417
    69.000   664.533
    69.500   667.631
    70.000   670.710
    70.500   673.772
    71.000   676.815
    71.500   679.840
    72.000   682.847
    72.500   685.836
    73.000   688.807
    73.500   691.759
    74.000   694.692
    74.500   697.606
    75.000   700.502
    75.500   703.379
    76.000   706.238
    76.500   709.079
    77.000   711.902
    77.500   714.706
    78.000   717.493
    78.500   720.261
    79.000   723.011
    79.500   725.743
    80.000   728.456
    80.500   731.150
    81.000   733.825
    81.500   736.480
    82.000   739.117
    82.500   741.734
    83.000   744.333
    83.500   746.913
    84.000   749.474
    84.500   752.014
    85.000   754.533
    85.500   757.033
    86.000   759.514
    86.500   761.978
    87.000   764.424
    87.500   766.846
    88.000   769.234
    88.500   771.600
    89.000   773.954
    89.500   776.300
    90.000   778.637
    90.500   780.968
    91.000   783.293
    91.500   785.612
    92.000   787.927
    92.500   790.237
    93.000   792.544
    93.500   794.848
    94.000   797.148
    94.500   799.444
    95.000   801.734
    95.500   804.018
    96.000   806.296
    96.500   808.568
    97.000   810.833
    97.500   813.091
    98.000   815.342
    98.500   817.586
    99.000   819.823
    99.500   822.051
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1121.043
   116.000  1122.005
   116.500  1122.967
   117.000  1123.929
   117.500  1124.891
   118.000  1125.853
   118.500  1126.815
   119.000  1127.776
   119.500  1128.738
   120.000  1129.699
   120.500  1130.660
   121.000  1131.621
   121.500  1132.582
   122.000  1133.542
   122.500  1134.502
   123.000  1135.461
   123.500  1136.420
   124.000  1137.379
   124.500  1138.337
   125.000  1139.295
   125.500  1140.252
   126.000  1141.208
   126.500  1142.164
   127.000  1143.119
   127.500  1144.074
   128.000  1145.027
   128.500  1145.980
   129.000  1146.932
   129.500  1147.883
   130.000  1148.833
   130.500  1149.782
   131.000  1150.729
   131.500  1151.676
   132.000  1152.621
   132.500  1153.564
   133.000  1154.506
   133.500  1155.447
   134.000  1156.386
   134.500  1157.323
   135.000  1158.258
   135.500  1159.191
   136.000  1160.123
   136.500  1161.051
   137.000  1161.978
   137.500  1162.902
   138.000  1163.823
   138.500  1164.742
   139.000  1165.657
   139.500  1166.570
   140.000  1167.479
   140.500  1168.386
   141.000  1169.288
   141.500  1170.187
   142.000  1171.081
   142.500  1171.972
   143.000  1172.858
   143.500  1173.739
   144.000  1174.615
   144.500  1175.486
   145.000  1176.352
   145.500  1177.212
   146.000  1178.065
   146.500  1178.913
   147.000  1179.754
   147.500  1180.588
   148.000  1181.415
   148.500  1182.235
   149.000  1183.046
   149.500  1183.848
   150.000  1184.642
   150.500  1185.425
   151.000  1186.198
   151.500  1186.962
   152.000  1187.715
   152.500  1188.458
   153.000  1189.192
   153.500  1189.915
   154.000  1190.627
   154.500  1191.328
   155.000  1192.018
   155.500  1192.697
   156.000  1193.365
   156.500  1194.020
   157.000  1194.664
   157.500  1195.295
   158.000  1195.914
   158.500  1196.521
   159.000  1197.115
   159.500  1197.696
   160.000  1198.264
   160.500  1198.820
   161.000  1199.362
   161.500  1199.891
   162.000  1200.407
   162.500  1200.910
   163.000  1201.400
   163.500  1201.876
   164.000  1202.338
   164.500  1202.786
   165.000  1203.221
   165.500  1203.641
   166.000  1204.048
   166.500  1204.441
   167.000  1204.820
   167.500  1205.186
   168.000  1205.536
   168.500  1205.874
   169.000  1206.196
   169.500  1206.505
   170.000  1206.800
   170.500  1207.080
   171.000  1207.346
   171.500  1207.598
   172.000  1207.835
   172.500  1208.058
   173.000  1208.267
   173.500  1208.462
   174.000  1208.642
   174.500  1208.808
   175.000  1208.959
   175.500  1209.096
   176.000  1209.219
   176.500  1209.327
   177.000  1209.421
   177.500  1209.500
   178.000  1209.565
   178.500  1209.616
   179.000  1209.652
   179.500  1209.674
   180.000  1209.681
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   991.979
     1.000   991.988
     1.500   992.002
     2.000   992.021
     2.500   992.047
     3.000   992.077
     3.500   992.114
     4.000   992.156
     4.500   992.203
     5.000   992.256
     5.500   992.315
     6.000   992.380
     6.500   992.449
     7.000   992.525
     7.500   992.606
     8.000   992.693
     8.500   992.785
     9.000   992.883
     9.500   992.986
    10.000   993.095
    10.500   993.209
    11.000   993.329
    11.500   993.455
    12.000   993.586
    12.500   993.722
    13.000   993.865
    13.500   994.012
    14.000   994.166
    14.500   994.324
    15.000   994.489
    15.500   994.658
    16.000   994.834
    16.500   995.014
    17.000   995.201
    17.500   995.393
    18.000   995.590
    18.500   995.792
    19.000   996.001
    19.500   996.214
    20.000   996.433
    20.500   996.658
    21.000   996.888
    21.500   997.123
    22.000   997.364
    22.500   997.610
    23.000   997.862
    23.500   998.119
    24.000   998.381
    24.500   998.649
    25.000   998.922
    25.500   999.201
    26.000   999.484
    26.500   999.774
    27.000  1000.068
    27.500  1000.368
    28.000  1000.673
    28.500  1000.984
    29.000  1001.299
    29.500  1001.620
    30.000  1001.946
    30.500  1002.278
    31.000  1002.615
    31.500  1002.957
    32.000  1003.304
    32.500  1003.656
    33.000  1004.014
    33.500  1004.377
    34.000  1004.745
    34.500  1005.118
    35.000  1005.496
    35.500  1005.879
    36.000  1006.268
    36.500  1006.661
    37.000  1007.060
    37.500  1007.464
    38.000  1007.873
    38.500  1008.287
    39.000  1008.706
    39.500  1009.130
    40.000  1009.559
    40.500  1009.993
    41.000  1010.432
    41.500  1010.876
    42.000  1011.325
    42.500  1011.779
    43.000  1012.237
    43.500  1012.701
    44.000  1013.170
    44.500  1013.643
    45.000  1014.122
    45.500  1014.605
    46.000  1015.093
    46.500  1015.586
    47.000  1016.083
    47.500  1016.586
    48.000  1017.093
    48.500  1017.605
    49.000  1018.122
    49.500  1018.643
    50.000  1019.169
    50.500  1019.700
    51.000  1020.235
    51.500  1020.776
    52.000  1021.320
    52.500  1021.870
    53.000  1022.424
    53.500  1022.982
    54.000  1023.545
    54.500  1024.113
    55.000  1024.685
    55.500  1025.262
    56.000  1025.843
    56.500  1026.429
    57.000  1027.019
    57.500  1027.613
    58.000  1028.212
    58.500  1028.815
    59.000  1029.423
    59.500  1030.035
    60.000  1030.652
    60.500  1031.272
    61.000  1031.897
    61.500  1032.527
    62.000  1033.161
    62.500  1033.798
    63.000  1034.440
    63.500  1035.087
    64.000  1035.737
    64.500  1036.392
    65.000  1037.050
    65.500  1037.713
    66.000  1038.380
    66.500  1039.052
    67.000  1039.727
    67.500  1040.406
    68.000  1041.089
    68.500  1041.776
    69.000  1042.467
    69.500  1043.162
    70.000  1043.861
    70.500  1044.565
    71.000  1045.271
    71.500  1045.982
    72.000  1046.697
    72.500  1047.415
    73.000  1048.137
    73.500  1048.863
    74.000  1049.593
    74.500  1050.327
    75.000  1051.064
    75.500  1051.805
    76.000  1052.550
    76.500  1053.298
    77.000  1054.050
    77.500  1054.805
    78.000  1055.564
    78.500  1056.327
    79.000  1057.094
    79.500  1057.863
    80.000  1058.636
    80.500  1059.413
    81.000  1060.193
    81.500  1060.977
    82.000  1061.764
    82.500  1062.555
    83.000  1063.348
    83.500  1064.146
    84.000  1064.946
    84.500  1065.750
    85.000  1066.557
    85.500  1067.367
    86.000  1068.181
    86.500  1068.997
    87.000  1069.817
    87.500  1070.640
    88.000  1071.467
    88.500  1072.296
    89.000  1073.128
    89.500  1073.964
    90.000  1074.802
    90.500  1075.644
    91.000  1076.488
    91.500  1077.336
    92.000  1078.186
    92.500  1079.040
    93.000  1079.896
    93.500  1080.755
    94.000  1081.617
    94.500  1082.482
    95.000  1083.349
    95.500  1084.220
    96.000  1085.093
    96.500  1085.969
    97.000  1086.848
    97.500  1087.729
    98.000  1088.613
    98.500  1089.499
    99.000  1090.389
    99.500  1091.281
   100.000  1092.175
   100.500  1093.072
   101.000  1093.971
   101.500  1094.873
   102.000  1095.778
   102.500  1096.684
   103.000  1097.594
   103.500  1098.505
   104.000  1099.419
   104.500  1100.336
   105.000  1101.255
   105.500  1102.176
   106.000  1103.099
   106.500  1104.025
   107.000  1104.952
   107.500  1105.882
   108.000  1106.815
   108.500  1107.749
   109.000  1108.685
   109.500  1109.624
   110.000  1110.565
   110.500  1111.507
   111.000  1112.452
   111.500  1113.399
   112.000  1114.348
   112.500  1115.298
   113.000  1116.251
   113.500  1117.206
   114.000  1118.162
   114.500  1119.121
   115.000  1120.081
   115.500  1121.043
   116.000  1122.007
   116.500  1122.972
   117.000  1123.940
   117.500  1124.909
   118.000  1125.880
   118.500  1126.852
   119.000  1127.826
   119.500  1128.802
   120.000  1129.779
   120.500  1130.758
   121.000  1131.739
   121.500  1132.721
   122.000  1133.704
   122.500  1134.689
   123.000  1135.676
   123.500  1136.664
   124.000  1137.653
   124.500  1138.644
   125.000  1139.636
   125.500  1140.629
   126.000  1141.624
   126.500  1142.620
   127.000  1143.617
   127.500  1144.616
   128.000  1145.616
   128.500  1146.617
   129.000  1147.619
   129.500  1148.622
   130.000  1149.627
   130.500  1150.632
   131.000  1151.639
   131.500  1152.647
   132.000  1153.656
   132.500  1154.666
   133.000  1155.676
   133.500  1156.688
   134.000  1157.701
   134.500  1158.714
   135.000  1159.729
   135.500  1160.744
   136.000  1161.761
   136.500  1162.778
   137.000  1163.796
   137.500  1164.814
   138.000  1165.834
   138.500  1166.854
   139.000  1167.875
   139.500  1168.897
   140.000  1169.919
   140.500  1170.942
   141.000  1171.966
   141.500  1172.990
   142.000  1174.015
   142.500  1175.040
   143.000  1176.066
   143.500  1177.092
   144.000  1178.119
   144.500  1179.147
   145.000  1180.175
   145.500  1181.203
   146.000  1182.232
   146.500  1183.261
   147.000  1184.290
   147.500  1185.320
   148.000  1186.350
   148.500  1187.381
   149.000  1188.412
   149.500  1189.443
   150.000  1190.474
   150.500  1191.505
   151.000  1192.537
   151.500  1193.569
   152.000  1194.601
   152.500  1195.633
   153.000  1196.666
   153.500  1197.698
   154.000  1198.731
   154.500  1199.763
   155.000  1200.796
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.677
   145.500  1177.501
   146.000  1179.383
   146.500  1181.300
   147.000  1183.246
   147.500  1185.214
   148.000  1187.203
   148.500  1189.209
   149.000  1191.230
   149.500  1193.266
   150.000  1195.314
   150.500  1197.374
   151.000  1199.444
   151.500  1201.524
   152.000  1203.613
   152.500  1205.710
   153.000  1207.815
   153.500  1209.927
   154.000  1212.046
   154.500  1214.172
   155.000  1216.304
   155.500  1218.442
   156.000  1220.584
   156.500  1222.732
   157.000  1224.885
   157.500  1227.042
   158.000  1229.203
   158.500  1231.368
   159.000  1233.538
   159.500  1235.711
   160.000  1237.887
   160.500  1240.067
   161.000  1242.249
   161.500  1244.435
   162.000  1246.623
   162.500  1248.814
   163.000  1251.007
   163.500  1253.202
   164.000  1255.400
   164.500  1257.600
   165.000  1259.801
   165.500  1262.005
   166.000  1264.210
   166.500  1266.417
   167.000  1268.625
   167.500  1270.834
   168.000  1273.045
   168.500  1275.258
   169.000  1277.471
   169.500  1279.686
   170.000  1281.901
   170.500  1284.117
   171.000  1286.335
   171.500  1288.553
   172.000  1290.772
   172.500  1292.991
   173.000  1295.211
   173.500  1297.432
   174.000  1299.652
   174.500  1301.874
   175.000  1304.096
   175.500  1306.318
   176.000  1308.540
   176.500  1310.763
   177.000  1312.985
   177.500  1315.208
   178.000  1317.431
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1175.672
   145.500  1177.297
   146.000  1178.842
   146.500  1180.331
   147.000  1181.770
   147.500  1183.164
   148.000  1184.515
   148.500  1185.827
   149.000  1187.104
   149.500  1188.352
   150.000  1189.575
   150.500  1190.775
   151.000  1191.955
   151.500  1193.115
   152.000  1194.257
   152.500  1195.382
   153.000  1196.490
   153.500  1197.585
   154.000  1198.666
   154.500  1199.734
   155.000  1200.788
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   508.855
     1.000   508.891
     1.500   508.951
     2.000   509.035
     2.500   509.143
     3.000   509.275
     3.500   509.431
     4.000   509.611
     4.500   509.815
     5.000   510.042
     5.500   510.294
     6.000   510.569
     6.500   510.867
     7.000   511.190
     7.500   511.536
     8.000   511.905
     8.500   512.298
     9.000   512.715
     9.500   513.154
    10.000   513.617
    10.500   514.103
    11.000   514.612
    11.500   515.143
    12.000   515.698
    12.500   516.276
    13.000   516.875
    13.500   517.498
    14.000   518.143
    14.500   518.810
    15.000   519.499
    15.500   520.210
    16.000   520.944
    16.500   521.699
    17.000   522.475
    17.500   523.273
    18.000   524.093
    18.500   524.933
    19.000   525.795
    19.500   526.678
    20.000   527.581
    20.500   528.505
    21.000   529.450
    21.500   530.415
    22.000   531.400
    22.500   532.405
    23.000   533.429
    23.500   534.474
    24.000   535.538
    24.500   536.621
    25.000   537.723
    25.500   538.845
    26.000   539.985
    26.500   541.144
    27.000   542.321
    27.500   543.517
    28.000   544.730
    28.500   545.962
    29.000   547.211
    29.500   548.478
    30.000   549.762
    30.500   551.063
    31.000   552.381
    31.500   553.717
    32.000   555.068
    32.500   556.437
    33.000   557.821
    33.500   559.222
    34.000   560.638
    34.500   562.070
    35.000   563.518
    35.500   564.981
    36.000   566.459
    36.500   567.952
    37.000   569.460
    37.500   570.982
    38.000   572.519
    38.500   574.070
    39.000   575.635
    39.500   577.213
    40.000   578.806
    40.500   580.412
    41.000   582.031
    41.500   583.663
    42.000   585.309
    42.500   586.966
    43.000   588.637
    43.500   590.320
    44.000   592.015
    44.500   593.722
    45.000   595.441
    45.500   597.172
    46.000   598.914
    46.500   600.667
    47.000   602.432
    47.500   604.207
    48.000   605.993
    48.500   607.790
    49.000   609.598
    49.500   611.415
    50.000   613.243
    50.500   615.081
    51.000   616.928
    51.500   618.785
    52.000   620.652
    52.500   622.528
    53.000   624.413
    53.500   626.307
    54.000   628.210
    54.500   630.122
    55.000   632.042
    55.500   633.970
    56.000   635.907
    56.500   637.851
    57.000   639.804
    57.500   641.764
    58.000   643.732
    58.500   645.708
    59.000   647.691
    59.500   649.681
    60.000   651.678
    60.500   653.681
    61.000   655.692
    61.500   657.709
    62.000   659.733
    62.500   661.763
    63.000   663.800
    63.500   665.842
    64.000   667.891
    64.500   669.945
    65.000   672.005
    65.500   674.071
    66.000   676.142
    66.500   678.218
    67.000   680.300
    67.500   682.386
    68.000   684.478
    68.500   686.575
    69.000   688.676
    69.500   690.782
    70.000   692.892
    70.500   695.007
    71.000   697.126
    71.500   699.249
    72.000   701.377
    72.500   703.508
    73.000   705.643
    73.500   707.782
    74.000   709.925
    74.500   712.071
    75.000   714.220
    75.500   716.373
    76.000   718.530
    76.500   720.689
    77.000   722.852
    77.500   725.017
    78.000   727.185
    78.500   729.356
    79.000   731.530
    79.500   733.707
    80.000   735.885
    80.500   738.067
    81.000   740.251
    81.500   742.437
    82.000   744.625
    82.500   746.815
    83.000   749.008
    83.500   751.202
    84.000   753.398
    84.500   755.596
    85.000   757.796
    85.500   759.997
    86.000   762.201
    86.500   764.405
    87.000   766.611
    87.500   768.818
    88.000   771.027
    88.500   773.237
    89.000   775.448
    89.500   777.660
    90.000   779.874
    90.500   782.088
    91.000   784.303
    91.500   786.519
    92.000   788.736
    92.500   790.954
    93.000   793.172
    93.500   795.391
    94.000   797.611
    94.500   799.831
    95.000   802.052
    95.500   804.273
    96.000   806.494
    96.500   808.716
    97.000   810.938
    97.500   813.160
    98.000   815.383
    98.500   817.606
    99.000   819.828
    99.500   822.051
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   418.826
    29.000   424.384
    29.500   429.941
    30.000   435.497
    30.500   441.052
    31.000   446.605
    31.500   452.157
    32.000   457.707
    32.500   463.254
    33.000   468.798
    33.500   474.339
    34.000   479.876
    34.500   485.409
    35.000   490.937
    35.500   496.461
    36.000   501.978
    36.500   507.490
    37.000   512.995
    37.500   518.493
    38.000   523.983
    38.500   529.464
    39.000   534.937
    39.500   540.400
    40.000   545.854
    40.500   551.296
    41.000   556.728
    41.500   562.148
    42.000   567.555
    42.500   572.950
    43.000   578.331
    43.500   583.698
    44.000   589.051
    44.500   594.389
    45.000   599.711
    45.500   605.018
    46.000   610.309
    46.500   615.583
    47.000   620.840
    47.500   625.545
    48.000   630.116
    48.500   634.681
    49.000   639.243
    49.500   643.799
    50.000   648.350
    50.500   652.896
    51.000   657.437
    51.500   661.972
    52.000   666.502
    52.500   671.026
    53.000   675.544
    53.500   680.056
    54.000   684.560
    54.500   689.057
    55.000   693.545
    55.500   698.022
    56.000   702.490
    56.500   706.949
    57.000   711.403
    57.500   715.851
    58.000   720.294
    58.500   724.732
    59.000   729.167
    59.500   733.597
    60.000   738.024
    60.500   742.447
    61.000   746.866
    61.500   751.281
    62.000   755.693
    62.500   760.100
    63.000   764.504
    63.500   768.903
    64.000   773.298
    64.500   777.689
    65.000   782.074
    65.500   786.454
    66.000   790.829
    66.500   795.197
    67.000   799.558
    67.500   803.913
    68.000   808.260
    68.500   812.599
    69.000   816.932
    69.500   821.256
    70.000   825.573
    70.500   829.882
    71.000   834.184
    71.500   838.479
    72.000   842.765
    72.500   847.045
    73.000   851.316
    73.500   855.580
    74.000   859.836
    74.500   864.084
    75.000   868.324
    75.500   872.557
    76.000   876.781
    76.500   880.997
    77.000   885.205
    77.500   889.405
    78.000   893.596
    78.500   897.779
    79.000   901.954
    79.500   906.120
    80.000   910.277
    80.500   914.426
    81.000   918.566
    81.500   922.698
    82.000   926.821
    82.500   930.936
    83.000   935.042
    83.500   939.140
    84.000   943.229
    84.500   947.309
    85.000   951.381
    85.500   955.444
    86.000   959.499
    86.500   963.544
    87.000   967.581
    87.500   971.609
    88.000   975.628
    88.500   979.638
    89.000   983.640
    89.500   987.632
    90.000   991.615
    90.500   995.590
    91.000   999.555
    91.500  1003.512
    92.000  1007.459
    92.500  1011.397
    93.000  1015.327
    93.500  1019.247
    94.000  1023.159
    94.500  1027.061
    95.000  1030.954
    95.500  1034.838
    96.000  1038.713
    96.500  1042.579
    97.000  1046.436
    97.500  1050.284
    98.000  1054.123
    98.500  1057.953
    99.000  1061.773
    99.500  1065.585
   100.000  1069.387
   100.500  1073.180
   101.000  1076.964
   101.500  1080.739
   102.000  1084.504
   102.500  1088.261
   103.000  1092.008
   103.500  1095.747
   104.000  1099.476
   104.500  1103.197
   105.000  1106.908
   105.500  1110.611
   106.000  1114.305
   106.500  1117.990
   107.000  1121.666
   107.500  1125.333
   108.000  1128.990
   108.500  1132.639
   109.000  1136.279
   109.500  1139.909
   110.000  1143.530
   110.500  1147.141
   111.000  1150.744
   111.500  1154.337
   112.000  1157.921
   112.500  1161.495
   113.000  1165.061
   113.500  1168.617
   114.000  1172.165
   114.500  1175.703
   115.000  1179.232
   115.500  1182.752
   116.000  1186.263
   116.500  1189.765
   117.000  1193.258
   117.500  1196.742
   118.000  1200.217
   118.500  1203.682
   119.000  1207.139
   119.500  1210.586
   120.000  1214.024
   120.500  1217.453
   121.000  1220.873
   121.500  1224.283
   122.000  1227.684
   122.500  1231.076
   123.000  1234.459
   123.500  1237.833
   124.000  1241.197
   124.500  1244.553
   125.000  1247.900
   125.500  1251.237
   126.000  1254.566
   126.500  1257.885
   127.000  1261.196
   127.500  1264.498
   128.000  1267.791
   128.500  1271.075
   129.000  1274.350
   129.500  1277.616
   130.000  1280.874
   130.500  1284.122
   131.000  1287.361
   131.500  1290.591
   132.000  1293.812
   132.500  1297.024
   133.000  1300.227
   133.500  1303.421
   134.000  1306.606
   134.500  1309.782
   135.000  1312.948
   135.500  1316.106
   136.000  1319.255
   136.500  1322.394
   137.000  1325.525
   137.500  1328.646
   138.000  1331.758
   138.500  1334.861
   139.000  1337.956
   139.500  1341.041
   140.000  1344.117
   140.500  1347.184
   141.000  1350.241
   141.500  1353.290
   142.000  1356.330
   142.500  1359.360
   143.000  1362.382
   143.500  1365.395
   144.000  1368.398
   144.500  1371.392
   145.000  1374.378
   145.500  1377.354
   146.000  1380.320
   146.500  1383.278
   147.000  1386.226
   147.500  1389.165
   148.000  1392.094
   148.500  1395.014
   149.000  1397.925
   149.500  1400.826
   150.000  1403.718
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   824.274
   100.500   826.497
   101.000   828.720
   101.500   830.943
   102.000   833.165
   102.500   835.388
   103.000   837.611
   103.500   839.834
   104.000   842.057
   104.500   844.280
   105.000   846.502
   105.500   848.725
   106.000   850.948
   106.500   853.171
   107.000   855.394
   107.500   857.617
   108.000   859.839
   108.500   862.062
   109.000   864.285
   109.500   866.508
   110.000   868.731
   110.500   870.954
   111.000   873.176
   111.500   875.399
   112.000   877.622
   112.500   879.845
   113.000   882.068
   113.500   884.291
   114.000   886.513
   114.500   888.736
   115.000   890.959
   115.500   893.182
   116.000   895.405
   116.500   897.628
   117.000   899.850
   117.500   902.073
   118.000   904.296
   118.500   906.519
   119.000   908.742
   119.500   910.965
   120.000   913.187
   120.500   915.410
   121.000   917.633
   121.500   919.856
   122.000   922.079
   122.500   924.302
   123.000   926.524
   123.500   928.747
   124.000   930.970
   124.500   933.193
   125.000   935.416
   125.500   937.639
   126.000   939.861
   126.500   942.084
   127.000   944.307
   127.500   946.530
   128.000   948.753
   128.500   950.976
   129.000   953.198
   129.500   955.421
   130.000   957.644
   130.500   959.867
   131.000   962.090
   131.500   964.313
   132.000   966.536
   132.500   968.758
   133.000   970.981
   133.500   973.204
   134.000   975.427
   134.500   977.650
   135.000   979.872
   135.500   982.095
   136.000   984.318
   136.500   986.541
   137.000   988.764
   137.500   990.987
   138.000   993.209
   138.500   995.432
   139.000   997.655
   139.500   999.878
   140.000  1002.101
   140.500  1004.324
   141.000  1006.547
   141.500  1008.769
   142.000  1010.992
   142.500  1013.215
   143.000  1015.438
   143.500  1017.661
   144.000  1019.884
   144.500  1022.106
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   384.280
    15.000   394.519
    15.500   404.753
    16.000   414.980
    16.500   425.196
    17.000   435.398
    17.500   445.582
    18.000   455.742
    18.500   465.873
    19.000   475.970
    19.500   486.027
    20.000   496.038
    20.500   505.997
    21.000   515.898
    21.500   525.736
    22.000   535.506
    22.500   545.203
    23.000   553.774
    23.500   561.915
    24.000   570.022
    24.500   578.096
    25.000   586.126
    25.500   594.075
    26.000   601.986
    26.500   609.885
    27.000   617.776
    27.500   625.660
    28.000   633.536
    28.500   641.406
    29.000   649.270
    29.500   657.127
    30.000   664.976
    30.500   672.818
    31.000   680.649
    31.500   688.469
    32.000   696.276
    32.500   704.069
    33.000   711.847
    33.500   719.607
    34.000   727.350
    34.500   735.075
    35.000   742.780
    35.500   750.466
    36.000   758.132
    36.500   765.778
    37.000   773.404
    37.500   781.009
    38.000   788.593
    38.500   796.155
    39.000   803.695
    39.500   811.213
    40.000   818.707
    40.500   826.179
    41.000   833.627
    41.500   841.052
    42.000   848.453
    42.500   855.829
    43.000   863.182
    43.500   870.509
    44.000   877.812
    44.500   885.090
    45.000   892.343
    45.500   899.570
    46.000   906.772
    46.500   913.949
    47.000   921.098
    47.500   928.222
    48.000   935.319
    48.500   942.389
    49.000   949.432
    49.500   956.448
    50.000   963.437
    50.500   970.399
    51.000   977.334
    51.500   984.242
    52.000   991.121
    52.500   997.973
    53.000  1004.798
    53.500  1011.597
    54.000  1018.370
    54.500  1025.117
    55.000  1031.837
    55.500  1038.530
    56.000  1045.196
    56.500  1051.833
    57.000  1058.443
    57.500  1065.025
    58.000  1071.578
    58.500  1078.104
    59.000  1084.602
    59.500  1091.072
    60.000  1097.515
    60.500  1103.930
    61.000  1110.318
    61.500  1116.677
    62.000  1123.008
    62.500  1129.310
    63.000  1135.584
    63.500  1141.829
    64.000  1148.047
    64.500  1154.235
    65.000  1160.396
    65.500  1166.528
    66.000  1172.632
    66.500  1178.708
    67.000  1184.756
    67.500  1190.775
    68.000  1196.765
    68.500  1202.727
    69.000  1208.660
    69.500  1214.564
    70.000  1220.440
    70.500  1226.287
    71.000  1232.106
    71.500  1237.895
    72.000  1243.655
    72.500  1249.386
    73.000  1255.087
    73.500  1260.758
    74.000  1266.399
    74.500  1272.010
    75.000  1277.592
    75.500  1283.144
    76.000  1288.666
    76.500  1294.160
    77.000  1299.623
    77.500  1305.057
    78.000  1310.460
    78.500  1315.833
    79.000  1321.176
    79.500  1326.490
    80.000  1331.774
    80.500  1337.029
    81.000  1342.254
    81.500  1347.448
    82.000  1352.609
    82.500  1357.739
    83.000  1362.837
    83.500  1367.903
    84.000  1372.939
    84.500  1377.943
    85.000  1382.916
    85.500  1387.858
    86.000  1392.769
    86.500  1397.647
    87.000  1402.493
    87.500  1407.306
    88.000  1412.087
    88.500  1416.834
    89.000  1421.548
    89.500  1426.229
    90.000  1430.876
    90.500  1435.489
    91.000  1440.069
    91.500  1444.615
    92.000  1449.126
    92.500  1453.604
    93.000  1458.048
    93.500  1462.458
    94.000  1466.843
    94.500  1471.210
    95.000  1475.565
    95.500  1479.908
    96.000  1484.239
    96.500  1488.557
    97.000  1492.859
    97.500  1497.141
    98.000  1501.402
    98.500  1505.643
    99.000  1509.866
    99.500  1514.068
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   718.981
     1.000   719.028
     1.500   719.106
     2.000   719.215
     2.500   719.355
     3.000   719.526
     3.500   719.728
     4.000   719.961
     4.500   720.225
     5.000   720.520
     5.500   720.845
     6.000   721.202
     6.500   721.589
     7.000   722.006
     7.500   722.454
     8.000   722.932
     8.500   723.440
     9.000   723.978
     9.500   724.547
    10.000   725.145
    10.500   725.772
    11.000   726.430
    11.500   727.116
    12.000   727.832
    12.500   728.577
    13.000   729.350
    13.500   730.152
    14.000   730.983
    14.500   731.842
    15.000   732.729
    15.500   733.644
    16.000   734.586
    16.500   735.556
    17.000   736.553
    17.500   737.577
    18.000   738.628
    18.500   739.706
    19.000   740.809
    19.500   741.939
    20.000   743.094
    20.500   744.275
    21.000   745.481
    21.500   746.713
    22.000   747.968
    22.500   749.249
    23.000   750.553
    23.500   751.881
    24.000   753.233
    24.500   754.609
    25.000   756.007
    25.500   757.428
    26.000   758.871
    26.500   760.337
    27.000   761.824
    27.500   763.333
    28.000   764.863
    28.500   766.414
    29.000   767.985
    29.500   769.577
    30.000   771.189
    30.500   772.820
    31.000   774.471
    31.500   776.141
    32.000   777.829
    32.500   779.535
    33.000   781.260
    33.500   783.002
    34.000   784.762
    34.500   786.539
    35.000   788.332
    35.500   790.141
    36.000   791.967
    36.500   793.808
    37.000   795.665
    37.500   797.537
    38.000   799.423
    38.500   801.324
    39.000   803.238
    39.500   805.167
    40.000   807.108
    40.500   809.063
    41.000   811.030
    41.500   813.010
    42.000   815.001
    42.500   817.005
    43.000   819.019
    43.500   821.045
    44.000   823.081
    44.500   825.127
    45.000   827.184
    45.500   829.250
    46.000   831.326
    46.500   833.410
    47.000   835.504
    47.500   837.605
    48.000   839.715
    48.500   841.833
    49.000   843.958
    49.500   846.090
    50.000   848.229
    50.500   850.375
    51.000   852.526
    51.500   854.684
    52.000   856.847
    52.500   859.016
    53.000   861.190
    53.500   863.369
    54.000   865.552
    54.500   867.739
    55.000   869.930
    55.500   872.126
    56.000   874.324
    56.500   876.526
    57.000   878.730
    57.500   880.938
    58.000   883.148
    58.500   885.360
    59.000   887.574
    59.500   889.790
    60.000   892.007
    60.500   894.226
    61.000   896.446
    61.500   898.667
    62.000   900.889
    62.500   903.111
    63.000   905.333
    63.500   907.556
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   931.035
     1.000   931.102
     1.500   931.212
     2.000   931.367
     2.500   931.567
     3.000   931.810
     3.500   932.098
     4.000   932.429
     4.500   932.805
     5.000   933.225
     5.500   933.689
     6.000   934.196
     6.500   934.747
     7.000   935.342
     7.500   935.980
     8.000   936.661
     8.500   937.386
     9.000   938.154
     9.500   938.965
    10.000   939.819
    10.500   940.715
    11.000   941.654
    11.500   942.635
    12.000   943.658
    12.500   944.723
    13.000   945.830
    13.500   946.979
    14.000   948.168
    14.500   949.399
    15.000   950.671
    15.500   951.984
    16.000   953.337
    16.500   954.730
    17.000   956.163
    17.500   957.636
    18.000   959.149
    18.500   960.700
    19.000   962.291
    19.500   963.920
    20.000   965.588
    20.500   967.294
    21.000   969.038
    21.500   970.819
    22.000   972.638
    22.500   974.493
    23.000   976.386
    23.500   978.315
    24.000   980.279
    24.500   982.280
    25.000   984.316
    25.500   986.388
    26.000   988.494
    26.500   990.634
    27.000   992.809
    27.500   995.018
    28.000   997.260
    28.500   999.536
    29.000  1001.845
    29.500  1004.186
    30.000  1006.559
    30.500  1008.965
    31.000  1011.402
    31.500  1013.870
    32.000  1016.369
    32.500  1018.899
    33.000  1021.459
    33.500  1024.049
    34.000  1026.668
    34.500  1029.317
    35.000  1031.995
    35.500  1034.701
    36.000  1037.436
    36.500  1040.198
    37.000  1042.988
    37.500  1045.805
    38.000  1048.650
    38.500  1051.520
    39.000  1054.417
    39.500  1057.340
    40.000  1060.288
    40.500  1063.262
    41.000  1066.260
    41.500  1069.283
    42.000  1072.330
    42.500  1075.401
    43.000  1078.496
    43.500  1081.614
    44.000  1084.755
    44.500  1087.918
    45.000  1091.104
    45.500  1094.312
    46.000  1097.541
    46.500  1100.792
    47.000  1104.063
    47.500  1107.355
    48.000  1110.668
    48.500  1114.001
    49.000  1117.354
    49.500  1120.726
    50.000  1124.117
    50.500  1127.527
    51.000  1130.956
    51.500  1134.403
    52.000  1137.868
    52.500  1141.351
    53.000  1144.851
    53.500  1148.368
    54.000  1151.902
    54.500  1155.453
    55.000  1159.020
    55.500  1162.603
    56.000  1166.201
    56.500  1169.815
    57.000  1173.445
    57.500  1177.089
    58.000  1180.748
    58.500  1184.421
    59.000  1188.108
    59.500  1191.809
    60.000  1195.524
    60.500  1199.252
    61.000  1202.993
    61.500  1206.747
    62.000  1210.514
    62.500  1214.293
    63.000  1218.084
    63.500  1221.887
    64.000  1225.701
    64.500  1229.527
    65.000  1233.365
    65.500  1237.213
    66.000  1241.072
    66.500  1244.941
    67.000  1248.820
    67.500  1252.710
    68.000  1256.609
    68.500  1260.518
    69.000  1264.437
    69.500  1268.364
    70.000  1272.301
    70.500  1276.246
    71.000  1280.200
    71.500  1284.162
    72.000  1288.132
    72.500  1292.111
    73.000  1296.097
    73.500  1300.090
    74.000  1304.091
    74.500  1308.099
    75.000  1312.115
    75.500  1316.137
    76.000  1320.165
    76.500  1324.200
    77.000  1328.241
    77.500  1332.289
    78.000  1336.342
    78.500  1340.401
    79.000  1344.466
    79.500  1348.536
    80.000  1352.611
    80.500  1356.692
    81.000  1360.777
    81.500  1364.867
    82.000  1368.962
    82.500  1373.061
    83.000  1377.164
    83.500  1381.271
    84.000  1385.383
    84.500  1389.498
    85.000  1393.617
    85.500  1397.740
    86.000  1401.865
    86.500  1405.995
    87.000  1410.127
    87.500  1414.262
    88.000  1418.401
    88.500  1422.541
    89.000  1426.685
    89.500  1430.831
    90.000  1434.979
    90.500  1439.129
    91.000  1443.282
    91.500  1447.436
    92.000  1451.593
    92.500  1455.750
    93.000  1459.910
    93.500  1464.071
    94.000  1468.234
    94.500  1472.397
    95.000  1476.562
    95.500  1480.728
    96.000  1484.895
    96.500  1489.062
    97.000  1493.230
    97.500  1497.399
    98.000  1501.568
    98.500  1505.738
    99.000  1509.908
    99.500  1514.078
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   772.234
    29.500   782.474
    30.000   792.712
    30.500   802.948
    31.000   813.182
    31.500   823.412
    32.000   833.638
    32.500   843.859
    33.000   854.074
    33.500   864.282
    34.000   874.482
    34.500   884.673
    35.000   894.853
    35.500   905.023
    36.000   915.180
    36.500   925.322
    37.000   935.450
    37.500   945.560
    38.000   955.653
    38.500   965.524
    39.000   975.777
    39.500   985.806
    40.000   995.811
    40.500  1005.790
    41.000  1015.742
    41.500  1025.665
    42.000  1035.558
    42.500  1045.420
    43.000  1055.249
    43.500  1065.044
    44.000  1074.804
    44.500  1084.528
    45.000  1094.215
    45.500  1103.488
    46.000  1111.657
    46.500  1119.809
    47.000  1127.944
    47.500  1136.063
    48.000  1144.165
    48.500  1152.251
    49.000  1160.319
    49.500  1168.367
    50.000  1176.388
    50.500  1184.371
    51.000  1192.300
    51.500  1200.215
    52.000  1208.124
    52.500  1216.027
    53.000  1223.925
    53.500  1231.818
    54.000  1239.708
    54.500  1247.594
    55.000  1255.476
    55.500  1263.355
    56.000  1271.231
    56.500  1279.103
    57.000  1286.972
    57.500  1294.837
    58.000  1302.700
    58.500  1310.559
    59.000  1318.415
    59.500  1326.267
    60.000  1334.115
    60.500  1341.959
    61.000  1349.799
    61.500  1357.634
    62.000  1365.464
    62.500  1373.287
    63.000  1381.105
    63.500  1388.917
    64.000  1396.722
    64.500  1404.520
    65.000  1412.311
    65.500  1420.094
    66.000  1427.869
    66.500  1435.635
    67.000  1443.393
    67.500  1451.142
    68.000  1458.881
    68.500  1466.612
    69.000  1474.333
    69.500  1482.045
    70.000  1489.747
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.589    25.188     0.150
     0.957    32.688     0.150
     0.902    32.086     0.150
     0.902    13.500     0.150
     1.229    40.391     0.150
     1.229    21.516     0.150
     1.473    45.492     0.150
     1.725    29.289     0.150
     1.725    51.688     0.150
     1.725    51.789     0.150
     1.781    51.188     0.150
     1.933    56.391     0.150
     2.193    63.492     0.150
     2.365    67.586     0.150
     2.892    41.391     0.150
     5.301    77.258     0.150
    10.094   143.852     0.150
    11.880   170.992     0.150
    13.215   181.102     0.150
    13.631   192.852     0.150
    14.572   203.992     0.150
    14.598   202.289     0.150
    15.260   214.492     0.150
    15.135   212.391     0.150
    15.135   205.750     0.150
    16.413   221.070     0.150
    25.727   335.891     0.150
    26.887     8.500     0.150
    27.677   340.086     0.150
    27.673  2117.031     0.150
    27.686  2116.336     0.150
    27.687  2119.578     0.150
    29.096  2285.938     0.150
    30.203   367.492     0.150
    30.203   369.000     0.150
    30.217  2280.289     0.150
    33.058    17.398     0.150
    33.058   718.992     0.150
    34.132    11.898     0.150
    34.151  2541.062     0.150
    34.161  2535.133     0.150
    34.169  2540.766     0.150
    35.641     8.852     0.150
    38.688     9.703     0.150
    38.688    13.906     0.150
    38.688   805.992     0.150
    39.753   447.172     0.150
    39.900   449.297     0.150
    40.340   449.852     0.150
    40.340   801.508     0.150
    40.086   451.688     0.150
    40.086   451.641     0.150
    41.077     9.406     0.150
    41.077    12.805     0.150
    41.296   452.891     0.150
    41.296    15.102     0.150
    41.296   819.789     0.150
    41.728     9.805     0.150
    41.728    13.805     0.150
    41.728   828.891     0.150
    41.728   845.086     0.150
    43.256   472.352     0.150
    43.827    11.398     0.150
    43.827    15.000     0.150
    45.099   490.453     0.150
    45.640    15.305     0.150
    45.640   889.586     0.150
    45.640   906.391     0.150
    46.005   496.891     0.150
    47.068   504.938     0.150
    47.149   508.188     0.150
    47.513     9.602     0.150
    47.513    13.898     0.150
    47.513   933.789     0.150
    47.513  1117.891     0.150
    48.045   512.477     0.150
    48.106   512.898     0.150
    48.149   512.328     0.150
    48.285   514.664     0.150
    48.342   514.758     0.150
    48.499   927.891     0.150
    48.500   516.336     0.150
    48.532   515.492     0.150
    48.669    10.602     0.150
    48.669    14.602     0.150
    48.680   517.320     0.150
    49.091   520.852     0.150
    49.147   520.383     0.150
    49.147   520.391     0.150
    51.530   664.289     0.150
    52.363   546.508     0.150
    54.331     9.398     0.150
    54.331    15.898     0.150
    55.205    10.406     0.150
    55.205    12.805     0.150
    55.205  1015.992     0.150
    55.499   567.219     0.150
    57.994   581.492     0.150
    57.994   581.500     0.150
    58.063   584.992     0.150
    58.692   589.797     0.150
    59.387   812.391     0.150
    59.387  1059.086     0.150
    59.387   594.156     0.150
    59.387   643.898     0.150
    59.366   606.289     0.150
    60.599   601.938     0.150
    60.870   601.289     0.150
    61.314    26.297     0.150
    61.314   741.086     0.150
    61.314   826.289     0.150
    61.314  1131.492     0.150
    61.314  1190.492     0.150
    62.497  1106.891     0.150
    63.172   637.289     0.150
    62.889   624.289     0.150
    62.889  1109.289     0.150
    62.889  1367.289     0.150
    63.308   620.266     0.150
    64.358   764.586     0.150
    64.358   859.586     0.150
    64.358  1144.188     0.150
    65.572  1172.789     0.150
    65.572  1220.086     0.150
    66.520  2351.328     0.150
    68.223   652.688     0.150
    68.223   652.250     0.150
    69.209   659.438     0.150
    69.751   667.727     0.150
    71.895  2338.141     0.150
    71.895   828.992     0.150
    71.895   943.289     0.150
    71.895  1223.586     0.150
    71.895  1492.289     0.150
    71.895   674.469     0.150
    71.895  2338.141     0.150
    72.112   675.289     0.150
    73.913   857.289     0.150
    73.913  1249.586     0.150
    74.671   702.086     0.150
    75.212   696.789     0.150
    75.394   969.789     0.150
    75.394  1551.086     0.150
    75.930   701.891     0.150
    77.188   711.000     0.150
    77.506   709.492     0.150
    77.506   709.422     0.150
    78.399   715.688     0.150
    78.921   720.289     0.150
    79.345  1005.289     0.150
    79.345  1613.188     0.150
    82.383   736.289     0.150
    82.599   742.188     0.150
    83.048   740.086     0.150
    83.841    27.000     0.150
    84.217   745.391     0.150
    85.439   953.992     0.150
    85.439  1375.289     0.150
    85.439   752.188     0.150
    85.699   753.688     0.150
    85.699   753.688     0.150
    86.109   754.891     0.150
    86.109   754.891     0.150
    86.319   757.289     0.150
    87.271   761.492     0.150
    87.376   761.586     0.150
    87.586   763.492     0.150
    87.664   763.188     0.150
    87.706   762.289     0.150
    87.706   782.289     0.150
    87.706   962.289     0.150
    87.706  1087.289     0.150
    87.706  1395.289     0.150
    87.706  1497.289     0.150
    87.736   763.492     0.150
    87.776   764.289     0.150
    87.787   763.891     0.150
    87.787   763.891     0.150
    87.884   764.188     0.150
    87.919   764.289     0.150
    87.981   764.289     0.150
    88.097   765.688     0.150
    88.296   765.688     0.150
    88.296   765.688     0.150
    88.609   774.086     0.150
    88.594   766.891     0.150
    88.660   769.188     0.150
    88.660   769.188     0.150
    88.822   769.586     0.150
    88.855   769.289     0.150
    88.905   769.289     0.150
    88.683   769.789     0.150
    88.683   769.766     0.150
    89.313   771.289     0.150
    89.419   771.086     0.150
    89.454   771.289     0.150
    89.452   771.086     0.150
    89.462   772.188     0.150
    89.729   771.891     0.150
    89.729   771.891     0.150
    89.729   771.891     0.150
    89.798   772.086     0.150
    89.854   772.188     0.150
    89.919   773.391     0.150
    89.899   773.086     0.150
    90.086   773.086     0.150
    90.098   772.688     0.150
    90.098   772.688     0.150
    90.145   773.891     0.150
    90.161   773.992     0.150
    90.161   773.992     0.150
    90.161   773.992     0.150
    90.180   773.891     0.150
    90.233   775.688     0.150
    90.448   774.688     0.150
    90.448   774.688     0.150
    90.505   774.391     0.150
    90.570   777.492     0.150
    90.695   774.719     0.150
    90.668   776.391     0.150
    90.702   777.492     0.150
    90.702   775.391     0.150
    90.737   775.992     0.150
    90.773   775.992     0.150
    90.773   775.992     0.150
    90.801   776.289     0.150
    90.874   775.992     0.150
    90.902   776.891     0.150
    91.000   778.391     0.150
    91.149   780.086     0.150
    91.272   780.086     0.150
    91.387   780.992     0.150
    91.480   781.492     0.150
    91.486   781.086     0.150
    91.763   782.289     0.150
    92.402   785.289     0.150
    93.507   788.992     0.150
    93.507    13.000     0.150
    93.754   791.188     0.150
    93.772   791.289     0.150
    93.871   789.539     0.150
    93.824   790.391     0.150
    94.180   792.688     0.150
    94.465   793.688     0.150
    94.597   794.586     0.150
    94.597    12.906     0.150
    95.194   797.492     0.150
    95.194  1026.188     0.150
    95.578   799.391     0.150
    96.095    11.695     0.150
    96.095   801.891     0.150
    96.095  1034.188     0.150
    96.411  1037.992     0.150
    96.411   802.289     0.150
    96.411  1037.992     0.150
    96.469   803.086     0.150
    97.529    13.398     0.150
    97.529   807.188     0.150
    97.529  1044.188     0.150
    97.542   808.789     0.150
    97.957  1031.289     0.150
    97.957  1877.289     0.150
    97.957   809.789     0.150
    98.017   810.695     0.150
    98.112  1054.188     0.150
    98.112   810.688     0.150
    98.112  1054.188     0.150
    98.567   808.289     0.150
    98.567  1047.289     0.150
    98.567   808.289     0.150
    98.567  1047.289     0.150
    98.567  1496.289     0.150
    98.567  1579.289     0.150
    98.567  1632.289     0.150
    98.567  1969.289     0.150
    98.567  2197.289     0.150
    99.628   817.188     0.150
   102.196   827.891     0.150
   102.196   827.922     0.150
   103.258   832.641     0.150
   103.842   835.320     0.150
   114.366  1171.891     0.150
   123.217  1131.672     0.150
   124.265  1132.961     0.150
   124.761  1134.961     0.150
   125.225  1135.188     0.150
   125.225  1135.180     0.150
   125.225  1135.156     0.150
   125.326  1135.852     0.150
   126.731  1136.883     0.150
   127.205  1139.992     0.150
   127.867  1139.688     0.150
   127.847  1140.961     0.150
   129.067  1144.352     0.150
   129.190  1339.062     0.150
   129.239  1339.148     0.150
   129.422  1340.109     0.150
   129.837  1144.344     0.150
   129.837  1144.328     0.150
   130.111  1145.680     0.150
   130.111  1342.602     0.150
   130.173  1146.430     0.150
   130.173  1342.766     0.150
   130.589  1146.250     0.150
   130.589  1340.742     0.150
   131.030  1148.289     0.150
   131.146  1147.750     0.150
   131.312  1147.969     0.150
   131.567  1148.961     0.150
   131.745  1148.992     0.150
   132.124  1144.086     0.150
   132.124  1144.102     0.150
   132.492  1150.086     0.150
   132.492  1150.086     0.150
   132.492  1350.211     0.150
   132.913  1149.258     0.150
   132.913  1352.820     0.150
   132.970  1144.531     0.150
   133.673  1150.461     0.150
   133.673  1150.641     0.150
   133.673  1353.938     0.150
   134.197  1153.352     0.150
   134.546  1153.008     0.150
   134.915  1152.438     0.150
   136.883  1158.328     0.150
   138.762  1153.398     0.150
   139.193  1155.992     0.150
   139.193  1373.586     0.150
   139.193  1156.289     0.150
   139.193  1155.992     0.150
   139.193  1156.250     0.150
   139.193  1373.500     0.150
   139.473  1345.328     0.150
   139.861  1156.102     0.150
   140.934  1165.047     0.150
   141.962  1161.391     0.150
   141.962  1161.383     0.150
   142.732  1165.367     0.150
   143.766  1166.586     0.150
   144.305  1168.352     0.150
   144.456  1167.820     0.150
   144.565  1169.539     0.150
   145.674  1171.969     0.150
   146.340  1174.883     0.150
   146.566  1174.852     0.150
   146.960  1176.242     0.150
   147.003  1175.797     0.150
   147.420  1176.445     0.150
   149.509  1179.602     0.150
   150.039  1180.383     0.150
     0.655     9.055     0.150
     0.824    13.258     0.150
     1.045    18.156     0.150
     1.437    23.656     0.150
     1.437    23.336     0.150
     1.437    41.805     0.150
     1.689    28.156     0.150
     2.586    44.258     0.150
     4.071    63.148     0.150
     4.889    78.859     0.150
     6.608    97.258     0.150
     7.695   108.078     0.150
    12.071   168.648     0.150
    12.149   169.359     0.150
    14.483   213.656     0.150
    17.756   248.859     0.150
    21.638   292.359     0.150
    23.031   305.453     0.150
    23.895   313.758     0.150
    26.561   334.758     0.150
    26.561   340.156     0.150
    29.354   360.695     0.150
    29.354   360.656     0.150
    35.220   409.758     0.150
    39.222   445.258     0.150
    40.253   453.453     0.150
    40.665   459.656     0.150
    41.077   463.414     0.150
    41.077   463.453     0.150
    43.101   480.609     0.150
    43.101   480.656     0.150
    46.425     3.602     0.150
    46.425     6.703     0.150
    47.661   923.859     0.150
    48.332   518.055     0.150
    54.098     4.297     0.150
    54.098     9.297     0.150
    57.577   585.758     0.150
    62.419   621.258     0.150
    63.258   625.766     0.150
    63.258   626.859     0.150
    63.296   628.953     0.150
    66.786   649.453     0.150
    67.106   651.758     0.150
    67.407   656.156     0.150
    75.517   718.453     0.150
    76.217   708.156     0.150
    77.056   714.156     0.150
    79.687   726.953     0.150
    84.345   746.156     0.150
    86.641   763.555     0.150
    86.708   762.359     0.150
    87.824   768.156     0.150
    87.874   768.359     0.150
    88.285   769.953     0.150
    88.893   770.859     0.150
    88.893   770.859     0.150
    89.190   774.258     0.150
    89.190   774.258     0.150
    89.701   776.359     0.150
    89.563   779.156     0.150
    89.835   776.156     0.150
   143.523  1173.156     0.150
   145.859  1176.953     0.150
   161.293  1246.055     0.150
     1.760    29.375     0.150
     2.963    46.680     0.150
     3.057    43.070     0.150
     4.475    67.781     0.150
     6.503    96.477     0.150
    12.246   167.477     0.150
    12.512   191.375     0.150
    12.797   177.648     0.150
    13.488   206.078     0.150
    13.931   193.281     0.150
    14.369   202.477     0.150
    15.012   201.875     0.150
    15.906   223.477     0.150
    16.179   219.734     0.150
    16.846   233.578     0.150
    16.936   235.875     0.150
    17.777   244.680     0.150
    17.726   441.453     0.150
    17.726   244.375     0.150
    17.928   248.078     0.150
    18.265   251.781     0.150
    20.357   283.078     0.150
    21.921   527.375     0.150
    21.921   291.086     0.150
    21.921   527.375     0.150
    25.131   321.281     0.150
    26.558    19.797     0.150
    26.964   333.578     0.150
    28.354  2129.688     0.150
    28.368  2131.391     0.150
    28.368  2131.203     0.150
    29.098   358.578     0.150
    30.204  2282.727     0.150
    30.204  2282.727     0.150
    31.309   682.281     0.150
    31.309  2276.875     0.150
    31.309  2352.578     0.150
    32.494    11.305     0.150
    32.494    16.203     0.150
    32.494   816.078     0.150
    33.160  2520.961     0.150
    33.170  2522.086     0.150
    33.178  2528.969     0.150
    33.680    14.602     0.150
    35.524   409.281     0.150
    35.791   412.180     0.150
    38.166    22.797     0.150
    38.166   937.781     0.150
    39.552   443.977     0.150
    40.802   457.180     0.150
    41.136    10.305     0.150
    41.136    16.305     0.150
    41.008   459.875     0.150
    41.325    12.898     0.150
    41.325   833.375     0.150
    41.325   856.375     0.150
    41.325   457.945     0.150
    41.325   457.977     0.150
    41.147   461.352     0.150
    41.147   461.484     0.150
    41.147   579.547     0.150
    41.147   461.477     0.150
    41.147   579.578     0.150
    43.316    10.000     0.150
    43.316    13.805     0.150
    45.302    13.203     0.150
    45.302    20.203     0.150
    45.341    14.000     0.150
    46.768   502.430     0.150
    46.935    11.898     0.150
    46.935    17.000     0.150
    46.724   505.281     0.150
    48.134   513.180     0.150
    48.305    18.500     0.150
    48.305  1134.977     0.150
    48.335   520.375     0.150
    48.208   517.578     0.150
    49.113   520.781     0.150
    49.113   605.375     0.150
    50.671   536.781     0.150
    51.283   537.477     0.150
    53.177   549.375     0.150
    53.177   620.680     0.150
    53.602    11.000     0.150
    53.602    21.297     0.150
    53.602   554.477     0.150
    54.318    12.203     0.150
    54.318  1004.680     0.150
    54.388   560.977     0.150
    55.012  2801.477     0.150
    55.012  2801.477     0.150
    55.655   570.180     0.150
    55.633   569.188     0.150
    55.831   570.375     0.150
    55.876   572.180     0.150
    55.958   571.172     0.150
    56.010   572.578     0.150
    56.010    11.602     0.150
    56.010    16.602     0.150
    56.010  1040.375     0.150
    56.360   573.602     0.150
    56.613   577.641     0.150
    56.777   576.727     0.150
    56.909   577.125     0.150
    57.293   581.375     0.150
    57.468   582.359     0.150
    57.468   638.195     0.150
    57.468   582.352     0.150
    57.543   582.680     0.150
    57.671   582.656     0.150
    57.723   583.180     0.150
    57.732   583.070     0.150
    57.929   584.578     0.150
    57.929  2815.531     0.150
    57.929  2815.531     0.150
    58.043   585.375     0.150
    58.129   589.562     0.150
    58.133   589.594     0.150
    58.079   589.078     0.150
    59.230   594.508     0.150
    59.561   616.375     0.150
    59.569   595.555     0.150
    59.701   596.977     0.150
    59.701   596.875     0.150
    62.540   616.367     0.150
    63.224   639.180     0.150
    64.063   626.469     0.150
    67.412   648.367     0.150
    68.595   653.633     0.150
    71.644   691.578     0.150
    71.644   697.180     0.150
    71.644  1229.281     0.150
    71.644  1269.078     0.150
    72.233   667.875     0.150
    73.512   687.883     0.150
    74.187   690.477     0.150
    74.549   853.680     0.150
    74.549   963.680     0.150
    74.549  1266.375     0.150
    74.884  1262.680     0.150
    74.866   694.180     0.150
    74.849   697.805     0.150
    75.199   695.578     0.150
    75.253   699.281     0.150
    75.719   702.984     0.150
    76.492   704.578     0.150
    76.492   704.555     0.150
    76.317   705.078     0.150
    76.317   706.211     0.150
    76.317   706.211     0.150
    76.833   707.680     0.150
    78.323  1308.875     0.150
    78.323  1802.375     0.150
    78.336  1854.125     0.150
    78.336   718.305     0.150
    80.295  1328.578     0.150
    81.325   731.195     0.150
    81.990   734.578     0.150
    82.267  1345.578     0.150
    84.178   757.375     0.150
    84.507   747.078     0.150
    84.507   758.281     0.150
    84.507  1357.477     0.150
    84.738   749.875     0.150
    85.277   750.578     0.150
    85.277   750.578     0.150
    85.277  1369.578     0.150
    85.277  1369.578     0.150
    86.297   752.477     0.150
    86.297   772.578     0.150
    86.341   756.977     0.150
    86.690   757.078     0.150
    86.690   768.578     0.150
    86.690   779.578     0.150
    87.237   760.781     0.150
    87.370   761.078     0.150
    87.573   764.375     0.150
    87.573   764.375     0.150
    87.665   763.477     0.150
    88.393   767.281     0.150
    88.664   767.977     0.150
    88.664   767.977     0.150
    88.719   767.680     0.150
    88.817   768.578     0.150
    88.817   768.578     0.150
    88.944   769.078     0.150
    89.074   769.680     0.150
    89.100   769.578     0.150
    89.100   769.578     0.150
    89.097   769.578     0.150
    89.106   769.180     0.150
    88.818   770.180     0.150
    89.217   772.078     0.150
    89.224   770.375     0.150
    89.374   770.578     0.150
    89.368   771.680     0.150
    89.389   773.578     0.150
    89.430   770.977     0.150
    89.492   772.180     0.150
    89.624   771.875     0.150
    89.624   771.875     0.150
    89.650   772.977     0.150
    89.660   773.078     0.150
    89.685   772.375     0.150
    89.685   772.375     0.150
    89.746   772.977     0.150
    89.746   772.977     0.150
    89.826   776.477     0.150
    90.068   775.477     0.150
    90.195   776.375     0.150
    90.660   776.609     0.150
    90.697   777.180     0.150
    90.461   779.289     0.150
    90.936   779.477     0.150
    91.232   779.977     0.150
    91.297   780.680     0.150
    91.297   780.680     0.150
    91.330   796.078     0.150
    91.532   780.781     0.150
    91.532   780.781     0.150
    91.641   780.977     0.150
    91.641   999.375     0.150
    91.708   781.281     0.150
    92.511   786.078     0.150
    92.748   787.375     0.150
    92.748  1008.375     0.150
    92.786   786.977     0.150
    92.806   787.180     0.150
    93.180   789.078     0.150
    93.252   789.375     0.150
    93.252  1012.477     0.150
    93.582   790.477     0.150
    94.190   792.477     0.150
    94.190  1019.078     0.150
    94.284   794.180     0.150
    94.573   794.375     0.150
    94.600   795.078     0.150
    94.600  1021.781     0.150
    94.698   798.078     0.150
    95.092   798.078     0.150
    95.092  1025.578     0.150
    95.112   796.375     0.150
    95.411   812.180     0.150
    95.411   799.477     0.150
    95.411  1028.680     0.150
    95.472   799.578     0.150
    95.502   799.891     0.150
    95.622  1027.875     0.150
    95.622   800.977     0.150
    95.622  1027.875     0.150
    96.075   801.375     0.150
    96.525   804.078     0.150
    96.525  1035.680     0.150
    96.960   805.578     0.150
    96.960  1039.578     0.150
    97.003   806.477     0.150
    97.100   821.680     0.150
    97.100   804.781     0.150
    97.100  1040.281     0.150
    97.573  1051.578     0.150
    97.573  1065.578     0.150
    97.573   809.578     0.150
    97.573    17.703     0.150
    98.733   812.680     0.150
   102.134   828.148     0.150
   107.842  1776.281     0.150
   107.842   853.078     0.150
   123.476  1131.375     0.150
   125.716  1136.281     0.150
   130.030  1144.172     0.150
   130.030  1144.180     0.150
   130.578  1145.281     0.150
   131.981  1352.227     0.150
   132.946  1150.453     0.150
   132.946  1146.625     0.150
   133.381  1151.281     0.150
   135.045  1153.680     0.150
   136.415  1158.672     0.150
   139.939  1164.406     0.150
   140.616  1156.266     0.150
   140.417  1158.586     0.150
   140.802  1158.805     0.150
   141.337  1158.422     0.150
   142.071  1160.016     0.150
   142.217  1161.086     0.150
   142.298  1161.602     0.150
   142.430  1161.086     0.150
   142.529  1161.617     0.150
   142.884  1161.375     0.150
   142.730  1166.852     0.150
   143.590  1165.906     0.150
   143.618  1165.758     0.150
   143.640  1168.281     0.150
   144.305  1167.852     0.150
   144.550  1169.977     0.150
   144.625  1386.570     0.150
   144.985  1170.578     0.150
   145.092  1171.078     0.150
   145.319  1171.570     0.150
   144.966  1174.305     0.150
   145.613  1171.625     0.150
   145.658  1172.477     0.150
   145.745  1173.117     0.150
   145.757  1172.875     0.150
   145.757  1172.828     0.150
   145.826  1172.758     0.150
   146.149  1174.078     0.150
   146.554  1174.578     0.150
   146.923  1177.781     0.150
   147.388  1177.875     0.150
   147.562  1176.781     0.150
   148.293  1182.047     0.150
   148.656  1180.570     0.150
   148.768  1181.781     0.150
   149.395  1183.383     0.150
   149.549  1183.578     0.150
   149.783  1183.875     0.150
   150.999  1187.531     0.150
   152.037  1189.711     0.150
   152.104  1190.562     0.150
   152.452  1184.477     0.150
   152.705  1184.875     0.150
   153.429  1193.961     0.150
   171.628  1203.875     0.150
     1.267    21.998     0.150
     1.794    33.697     0.150
     3.527    50.678     0.150
     3.492    51.498     0.150
     9.919   133.277     0.150
    13.001   179.168     0.150
    15.097   211.799     0.150
    16.484   222.078     0.150
    18.363   252.248     0.150
    27.603  2115.164     0.150
    27.616  2125.338     0.150
    27.617  2114.941     0.150
    30.153   366.898     0.150
    34.182  2648.539     0.150
    34.192  2651.541     0.150
    34.201  2650.387     0.150
    54.402    10.199     0.150
    54.402    14.000     0.150
    55.535   861.139     0.150
    59.558   595.697     0.150
    64.464   629.027     0.150
     0.984    31.074     0.150
     1.823    49.773     0.150
     2.873    41.977     0.150
     4.155    59.176     0.150
     5.495    75.875     0.150
     6.915    94.477     0.150
     9.522   129.977     0.150
    22.030   284.586     0.150
    27.659  2115.133     0.150
    27.672  2125.688     0.150
    27.673  2120.883     0.150
    34.209  2635.805     0.150
    34.219  2636.664     0.150
    34.228  2637.312     0.150
    34.261   400.375     0.150
    40.041   452.574     0.150
    47.521     4.500     0.150
    47.521     7.500     0.150
    64.384   629.148     0.150
    72.358   678.645     0.150
    74.345   690.926     0.150
    76.332   701.453     0.150
    82.427   734.266     0.150
     0.634    22.107     0.150
     0.693    12.309     0.150
     1.164    20.908     0.150
     3.853    60.088     0.150
     4.691    68.707     0.150
    34.970  2630.605     0.150
    34.980  2630.014     0.150
    34.989  2632.227     0.150
    51.434   549.107     0.150
    51.434   992.309     0.150
     0.763    12.844     0.150
     1.047    16.745     0.150
     1.803    26.944     0.150
     2.016    31.245     0.150
     2.711    39.365     0.150
     2.711    67.615     0.150
     2.711    39.444     0.150
     3.401    49.844     0.150
     5.463    77.255     0.150
     7.100   100.144     0.150
     9.175   134.944     0.150
    10.671   155.844     0.150
    10.682  3998.444     0.150
    10.685   149.344     0.150
    13.082   178.544     0.150
    13.170   184.245     0.150
    13.253   180.745     0.150
    15.248   208.875     0.150
    15.248   212.844     0.150
    15.248   208.844     0.150
    18.042   247.011     0.150
    18.042   448.078     0.150
    18.408   251.654     0.150
    22.658   299.344     0.150
    23.185   303.644     0.150
    24.221   313.745     0.150
    26.590   334.719     0.150
    26.590   334.484     0.150
    26.590   631.769     0.150
    27.041   617.844     0.150
    27.137   340.644     0.150
    27.439   338.125     0.150
    27.439   337.844     0.150
    27.439   756.367     0.150
    27.778   341.034     0.150
    27.778   340.245     0.150
    27.562  2121.563     0.150
    27.576  2120.861     0.150
    27.577  2119.556     0.150
    29.148   357.444     0.150
    30.165   368.444     0.150
    33.184   398.844     0.150
    33.605   397.245     0.150
    33.834     4.200     0.150
    33.834   722.245     0.150
    33.834   728.245     0.150
    34.023  2544.583     0.150
    34.033  2534.944     0.150
    34.042  2538.390     0.150
    34.076   398.574     0.150
    34.076   398.544     0.150
    34.147   402.144     0.150
    34.672   740.245     0.150
    36.419   417.044     0.150
    37.687    10.520     0.150
    37.687   534.294     0.150
    37.789   433.544     0.150
    38.156   433.745     0.150
    39.014   448.245     0.150
    38.948   442.944     0.150
    39.962   450.644     0.150
    40.085   450.745     0.150
    40.085   452.544     0.150
    40.427   451.990     0.150
    40.427   450.944     0.150
    41.466     2.900     0.150
    41.466     4.000     0.150
    41.874     6.900     0.150
    41.874   840.844     0.150
    41.874  1025.745     0.150
    43.055   477.444     0.150
    43.655   478.894     0.150
    43.961     8.500     0.150
    43.961   872.844     0.150
    45.414   884.944     0.150
    45.677   496.044     0.150
    46.872   506.245     0.150
    47.147   507.245     0.150
    47.637   604.745     0.150
    48.190   513.544     0.150
    48.569   514.344     0.150
    48.591   941.745     0.150
    48.820   945.844     0.150
    48.820   952.545     0.150
    48.906   518.745     0.150
    49.325   522.444     0.150
    49.325   522.394     0.150
    51.129   537.644     0.150
    52.286   545.414     0.150
    52.286   544.644     0.150
    53.214   550.144     0.150
    54.430     4.900     0.150
    54.430    11.900     0.150
    55.269     5.500     0.150
    55.309   570.929     0.150
    55.405  1032.964     0.150
    55.405   567.444     0.150
    55.611  2367.364     0.150
    55.641   569.295     0.150
    55.882   574.789     0.150
    55.989   574.769     0.150
    55.989  1036.545     0.150
    56.273   868.344     0.150
    56.486   580.049     0.150
    56.486  1046.591     0.150
    56.570   575.844     0.150
    56.532   574.944     0.150
    56.865   577.144     0.150
    56.865   577.044     0.150
    56.842   581.506     0.150
    56.842  1054.697     0.150
    57.043   578.245     0.150
    57.121   579.144     0.150
    57.267   579.644     0.150
    57.273   582.178     0.150
    57.273   582.178     0.150
    57.400   585.316     0.150
    57.638   582.544     0.150
    57.697   582.745     0.150
    57.683   587.455     0.150
    57.829   583.444     0.150
    57.853   588.491     0.150
    57.853  1063.831     0.150
    58.113   586.745     0.150
    58.154   584.334     0.150
    58.154   585.854     0.150
    58.168   585.144     0.150
    58.221   590.914     0.150
    58.270   587.644     0.150
    58.293   587.344     0.150
    58.296   583.564     0.150
    58.408   588.568     0.150
    58.389   591.578     0.150
    58.389  1068.882     0.150
    58.482   589.344     0.150
    58.565   588.745     0.150
    58.591   588.344     0.150
    58.566   592.984     0.150
    58.566  1073.065     0.150
    58.656   589.544     0.150
    58.605   593.448     0.150
    58.787   590.144     0.150
    58.787  1065.239     0.150
    58.904   591.544     0.150
    58.745   591.984     0.150
    58.745   591.944     0.150
    58.986   592.245     0.150
    59.172   597.586     0.150
    59.172  1080.246     0.150
    59.203   597.741     0.150
    59.203  1082.747     0.150
    59.384   595.574     0.150
    59.427   599.092     0.150
    59.370   596.255     0.150
    59.605   600.445     0.150
    59.605   600.445     0.150
    59.767   601.782     0.150
    60.542   603.144     0.150
    60.390  4570.702     0.150
    60.404  4598.654     0.150
    60.408  4569.666     0.150
    60.660   603.544     0.150
    60.660   603.245     0.150
    60.564  4578.054     0.150
    60.579  4581.438     0.150
    60.581  4580.334     0.150
    62.604   617.044     0.150
    63.400   621.844     0.150
    64.965   632.944     0.150
    66.349   645.532     0.150
    66.349  2359.507     0.150
    68.306   653.194     0.150
    68.306   654.044     0.150
    68.306   653.944     0.150
    68.306   653.574     0.150
    69.213   661.125     0.150
    69.632   667.474     0.150
    69.632   667.125     0.150
    72.058   698.745     0.150
    72.058   833.745     0.150
    72.192   679.814     0.150
    73.939   850.245     0.150
    74.555   691.644     0.150
    74.555   691.044     0.150
    74.562   692.904     0.150
    74.562   695.794     0.150
    74.562   695.794     0.150
    74.562   692.944     0.150
    74.966   693.384     0.150
    74.966   859.144     0.150
    75.469   697.545     0.150
    75.469   861.944     0.150
    75.469  1276.944     0.150
    75.469  1567.245     0.150
    75.895   700.344     0.150
    75.916   701.745     0.150
    76.077   702.765     0.150
    76.077   702.745     0.150
    76.459   704.344     0.150
    77.035   710.755     0.150
    77.035   708.944     0.150
    77.529   711.486     0.150
    77.529   711.486     0.150
    77.529  1301.245     0.150
    78.751   717.545     0.150
    78.751   717.545     0.150
    79.365   896.644     0.150
    79.365  1005.245     0.150
    79.365  1320.545     0.150
    79.793   722.344     0.150
    82.385   736.859     0.150
    82.420   736.834     0.150
    82.420   740.874     0.150
    83.050   741.312     0.150
    83.050   740.045     0.150
    83.264   739.745     0.150
    83.612  1345.944     0.150
    83.917  1361.545     0.150
    84.211   744.844     0.150
    84.417   747.245     0.150
    85.156   769.144     0.150
    85.491  1357.045     0.150
    86.113   759.344     0.150
    86.304   755.265     0.150
    87.288   762.444     0.150
    87.391   762.545     0.150
    87.713   762.944     0.150
    87.752   764.245     0.150
    87.780   764.545     0.150
    87.984   766.045     0.150
    88.311   765.944     0.150
    88.390   765.592     0.150
    88.398   766.144     0.150
    88.837   770.245     0.150
    88.873   770.045     0.150
    89.329   772.045     0.150
    89.884   774.344     0.150
    89.935   774.344     0.150
    90.139   771.474     0.150
    90.139   771.474     0.150
    90.139   982.924     0.150
    90.139  1099.664     0.150
    90.139  1999.174     0.150
    90.139   771.444     0.150
    90.139   982.844     0.150
    90.139  1782.545     0.150
    90.139  1999.144     0.150
    90.255   775.785     0.150
    90.255   776.344     0.150
    90.272   774.874     0.150
    90.751   776.844     0.150
    91.450   768.745     0.150
    91.500   783.045     0.150
    92.263   784.344     0.150
    92.341   785.245     0.150
    92.714   785.344     0.150
    92.952   789.245     0.150
    94.620   798.844     0.150
    94.620   798.844     0.150
    95.605   798.944     0.150
    96.123   800.644     0.150
    96.123   800.644     0.150
    96.123   823.444     0.150
    96.206   802.555     0.150
    97.638   809.245     0.150
    97.638   828.144     0.150
    97.892   807.795     0.150
    98.136   810.844     0.150
    99.286   810.025     0.150
    99.261  1920.344     0.150
   128.043  1141.144     0.150
   129.258  1144.644     0.150
   129.377  1144.073     0.150
   129.377  1340.819     0.150
   133.044  1148.920     0.150
   132.990  1150.444     0.150
   133.848  1356.019     0.150
   135.262  1156.403     0.150
   138.943  1152.974     0.150
   139.380  1157.984     0.150
   139.380  1160.844     0.150
   139.288  1156.954     0.150
   142.553  1165.194     0.150
   143.109  1168.045     0.150
   144.251  1168.322     0.150
   144.300  1171.834     0.150
   144.663  1169.859     0.150
   144.676  1169.857     0.150
   144.751  1170.056     0.150
   144.774  1170.272     0.150
   144.810  1170.104     0.150
   145.428  1171.703     0.150
   145.485  1172.892     0.150
   145.617  1171.824     0.150
   145.624  1173.067     0.150
   145.801  1172.811     0.150
   145.799  1173.014     0.150
   145.929  1172.614     0.150
   145.921  1173.661     0.150
   145.921  1173.844     0.150
   146.158  1173.984     0.150
   146.229  1174.500     0.150
   146.448  1175.272     0.150
   146.564  1175.334     0.150
   146.635  1176.030     0.150
   146.643  1176.209     0.150
   146.817  1176.468     0.150
   146.954  1176.872     0.150
   147.113  1177.479     0.150
   147.146  1177.644     0.150
   147.166  1177.663     0.150
   147.332  1178.374     0.150
   147.439  1178.117     0.150
   147.605  1179.045     0.150
   147.670  1178.730     0.150
   147.670  1178.644     0.150
   147.799  1179.131     0.150
   147.811  1178.329     0.150
   147.934  1179.964     0.150
   147.970  1179.516     0.150
   148.122  1179.714     0.150
   148.229  1179.724     0.150
   148.372  1180.851     0.150
   148.408  1181.074     0.150
   148.643  1181.518     0.150
   148.797  1181.891     0.150
   148.980  1181.785     0.150
   148.980  1183.011     0.150
   148.980  1181.745     0.150
   149.035  1182.345     0.150
   149.224  1183.322     0.150
   149.242  1183.174     0.150
   149.449  1183.714     0.150
   149.273  1187.144     0.150
   149.537  1186.045     0.150
   149.691  1184.619     0.150
   149.887  1185.196     0.150
   149.932  1185.428     0.150
   150.071  1185.525     0.150
   150.553  1186.448     0.150
   150.627  1186.728     0.150
   150.551  1184.684     0.150
   150.905  1187.603     0.150
   151.018  1188.072     0.150
   151.045  1188.162     0.150
   151.097  1187.778     0.150
   151.336  1187.984     0.150
   151.474  1188.102     0.150
   151.484  1189.333     0.150
   151.825  1189.767     0.150
   152.278  1189.673     0.150
   152.383  1190.281     0.150
   152.988  1191.294     0.150
   152.856  1188.065     0.150
   153.550  1193.256     0.150
   158.702  1195.224     0.150
   166.234  1202.815     0.150
     1.060    31.539     0.150
     1.060    19.943     0.150
     3.064    46.312     0.150
     3.064    46.232     0.150
     3.096    48.674     0.150
    27.575  2121.301     0.150
    27.588  2117.568     0.150
    27.589  2119.482     0.150
    33.567   397.174     0.150
    34.612  2625.723     0.150
    34.623  2608.180     0.150
    34.631  2609.799     0.150
    45.918   499.393     0.150
    60.882  4610.506     0.150
    60.896  4611.600     0.150
    60.899  4609.432     0.150
    61.051  4607.748     0.150
    61.066  4607.051     0.150
    61.068  4608.617     0.150
    63.416   661.107     0.150
     0.715    22.812     0.150
     3.562    52.914     0.150
    15.163   213.312     0.150
    27.563  2122.109     0.150
    27.576  2126.930     0.150
    27.577  2129.625     0.150
    34.110  2536.461     0.150
    34.120  2543.016     0.150
    34.129  2540.562     0.150
    60.463  4577.102     0.150
    60.476  4577.359     0.150
    60.480  4576.000     0.150
    60.636  4601.234     0.150
    60.650  4596.680     0.150
    60.653  4598.148     0.150
    88.557   767.562     0.150
    94.443   792.266     0.150
     0.178     9.617     0.150
     0.898    15.477     0.150
     1.518    27.576     0.150
     1.518    27.477     0.150
     2.739    45.236     0.150
     3.758    58.236     0.150
    10.420   150.477     0.150
    34.895  2673.287     0.150
    34.905  2667.871     0.150
    34.914  2674.729     0.150
    47.031   514.477     0.150
    48.335   521.838     0.150
    61.493  4632.676     0.150
    61.507  4639.738     0.150
    61.510  4634.439     0.150
    63.982   632.883     0.150
    88.345   769.283     0.150
     0.913    29.359     0.150
     0.707    10.625     0.150
     0.707    20.023     0.150
     0.554    13.227     0.150
     0.554    24.625     0.150
     1.176    37.047     0.150
     2.154    36.625     0.150
     4.625    66.828     0.150
    27.338   343.000     0.150
    35.903  2648.898     0.150
    35.913  2650.758     0.150
    35.922  2659.250     0.150
    62.154  4640.500     0.150
    62.168  4641.977     0.150
    62.171  4635.727     0.150
     0.239    11.008     0.150
     2.089    35.812     0.150
     0.598     8.666     0.150
     0.599    14.266     0.150
     0.765    16.666     0.150
     0.914    15.467     0.150
     1.172    22.865     0.150
     0.490    11.543     0.150
     1.454    26.641     0.150
     0.621    20.656     0.150
     0.777    13.859     0.150
     0.777    22.859     0.150
     0.777    23.758     0.150
     0.910    16.461     0.150
     0.910    29.656     0.150
     1.021    19.062     0.150
     1.242    39.109     0.150
     1.242    23.359     0.150
     1.242    39.109     0.150
     1.221    22.156     0.150
     1.382    24.656     0.150
     2.427    39.758     0.150
     2.477    40.258     0.150
     2.831    42.758     0.150
     3.473    87.492     0.150
     3.473    53.758     0.150
     3.473    55.461     0.150
     3.504    50.320     0.150
     3.543    54.758     0.150
     4.959    73.461     0.150
     5.090    75.859     0.150
     6.335    98.562     0.150
     6.493    95.859     0.150
     6.507    97.562     0.150
     6.667    98.461     0.150
     6.721    98.461     0.150
     7.785   112.961     0.150
    50.683   124.359     0.150
     9.097   124.523     0.150
     9.128   126.445     0.150
     9.795   140.156     0.150
    10.683   153.961     0.150
   139.204   157.641     0.150
   139.204   157.797     0.150
    13.272   183.641     0.150
    13.283   187.891     0.150
    13.283   187.883     0.150
    15.079   217.258     0.150
    15.079   217.258     0.150
    16.400   222.211     0.150
    16.400   234.156     0.150
    16.634   223.852     0.150
   126.134   231.977     0.150
    19.791   260.852     0.150
    20.517   272.414     0.150
    20.750   504.484     0.150
    20.750   504.492     0.150
    21.626   286.617     0.150
    21.626   299.258     0.150
    25.158   315.977     0.150
    60.990   362.703     0.150
    30.148   367.258     0.150
    30.969   369.320     0.150
    33.961   394.484     0.150
    40.016   452.859     0.150
    45.164   484.914     0.150
    59.287   594.961     0.150
    60.578  4593.844     0.150
    60.592  4590.086     0.150
    60.595  4591.125     0.150
    63.320   659.836     0.150
    64.426   628.250     0.150
    71.930   674.836     0.150
    78.579   718.461     0.150
    78.579   718.461     0.150
    78.579   718.461     0.150
    78.579   718.461     0.150
    78.579   718.461     0.150
    78.579   718.461     0.150
    79.044   722.242     0.150
    82.452   737.656     0.150
    87.446   762.031     0.150
   117.718  1120.461     0.150
   145.942  1175.648     0.150
     1.873    38.323     0.150
     2.355    35.923     0.150
     0.420    15.992     0.150
     0.634    11.391     0.150
     1.340    44.293     0.150
     1.535    27.090     0.150
     1.537    27.293     0.150
     1.537    50.492     0.150
     1.951    34.492     0.150
     2.309    39.590     0.150
     0.348    14.965     0.150
     0.444    17.465     0.150
     0.470    18.664     0.150
     0.543    20.363     0.150
     1.987    34.363     0.150
     2.265    41.664     0.150
     1.354    22.461     0.150
     1.341    23.334     0.150
     3.490    54.734     0.150
    28.762   360.789     0.150
    29.998   372.265     0.150
    39.977   457.034     0.150
     0.484     7.911     0.150
     0.599    12.511     0.150
     0.816    17.511     0.150
     0.898    18.311     0.150
     1.000    22.011     0.150
     1.163    23.111     0.150
     2.081    36.311     0.150
     1.317    44.484     0.150
     3.812    62.883     0.150
    34.598  2535.398     0.150
    34.608  2535.398     0.150
    34.617  2537.109     0.150
     0.630    13.093     0.150
     0.892     9.859     0.150
     1.090    26.889     0.150
     9.281   123.988     0.150
     0.896     0.172     0.150
     0.649    11.340     0.150
     0.702    21.043     0.150
     0.786    12.535     0.150
     0.858    18.133     0.150
     1.176    20.434     0.150
     2.241    35.535     0.150
     2.911    48.633     0.150
     0.187     8.719     0.150
     0.319     4.832     0.150
     0.472     6.805     0.150
     0.472     6.809     0.150
     0.511     8.332     0.150
     0.640    11.129     0.150
     0.856    17.129     0.150
     0.869    27.332     0.150
     1.195    21.031     0.150
     1.195    36.730     0.150
     1.965    36.531     0.150
    39.914   453.004     0.150
    39.914   453.012     0.150
     0.792    23.324     0.150
     0.792    13.654     0.150
     0.792    23.054     0.150
     1.247    18.735     0.150
     1.247    18.734     0.150
     1.543    26.854     0.150
     1.611    28.054     0.150
     1.621    27.054     0.150
     1.816    30.454     0.150
     1.952    32.154     0.150
     2.827    41.224     0.150
   168.693    50.954     0.150
     3.389    49.954     0.150
     3.765    55.154     0.150
     4.239    65.154     0.150
     4.946    76.854     0.150
     5.347    78.654     0.150
     7.770   113.654     0.150
    50.688   123.854     0.150
     8.757   116.254     0.150
   130.953   139.354     0.150
    10.708   150.454     0.150
    10.866   151.654     0.150
   139.215   163.234     0.150
    12.399   164.594     0.150
    12.645   181.654     0.150
    13.000   181.954     0.150
    13.119   178.854     0.150
    13.262   324.354     0.150
    13.262   324.354     0.150
    12.871   191.154     0.150
    13.677   187.264     0.150
    13.887   187.754     0.150
    46.372   199.145     0.150
    46.372   198.524     0.150
    46.372   200.654     0.150
    15.103   206.324     0.150
    15.103   206.324     0.150
    16.278   222.154     0.150
    17.981   242.254     0.150
    18.018   242.474     0.150
    20.775   277.987     0.150
    20.775   278.154     0.150
   175.425   282.054     0.150
   175.425   283.954     0.150
    21.645   288.054     0.150
    21.645   288.154     0.150
    22.646   296.854     0.150
    22.646   297.154     0.150
   141.873   295.084     0.150
   141.873   297.454     0.150
    23.021   298.354     0.150
    23.771   294.306     0.150
    24.235   312.854     0.150
    25.431   327.680     0.150
    26.637   336.044     0.150
    27.383   537.154     0.150
    27.383   754.384     0.150
    27.721   340.354     0.150
    27.721   340.367     0.150
    27.629  2124.393     0.150
    27.643  2123.555     0.150
    27.644  2125.580     0.150
    12.777   347.354     0.150
   102.581   353.784     0.150
   102.581   354.754     0.150
    29.060   354.884     0.150
    29.060   356.054     0.150
    60.968   362.034     0.150
    60.968   544.704     0.150
    30.247   368.754     0.150
    30.088   367.014     0.150
    30.088   367.204     0.150
    30.172   367.754     0.150
    30.172   657.054     0.150
    30.172   763.884     0.150
    33.123    17.601     0.150
   120.922   390.944     0.150
    33.770   392.474     0.150
    33.983   398.304     0.150
    33.983   395.154     0.150
    33.933   399.554     0.150
    34.170   715.754     0.150
    34.178  2546.028     0.150
    34.188  2537.563     0.150
    34.197  2538.288     0.150
   102.118   428.864     0.150
   102.118   431.454     0.150
    37.730   530.924     0.150
    38.043   429.124     0.150
    38.728    14.800     0.150
    38.914   443.545     0.150
    39.721   448.244     0.150
    39.859   575.579     0.150
    39.859   449.454     0.150
    39.859   450.204     0.150
    39.907   451.654     0.150
    40.039   451.904     0.150
    40.039   450.074     0.150
    40.039   451.754     0.150
    40.619   453.974     0.150
    41.325    15.600     0.150
    42.747   476.779     0.150
    43.001   476.474     0.150
    43.867    12.700     0.150
    43.867    19.700     0.150
    44.914   885.754     0.150
    45.350   895.454     0.150
    45.413   496.004     0.150
    45.646   497.754     0.150
    45.646   499.054     0.150
    46.409   498.564     0.150
    47.102   509.454     0.150
    47.102   508.554     0.150
    47.102   509.424     0.150
    48.509   939.254     0.150
    48.528   935.454     0.150
    48.705     8.700     0.150
    48.705    15.000     0.150
    48.705   932.854     0.150
    49.172   521.054     0.150
    51.280   541.554     0.150
    52.291   544.554     0.150
    54.376  1145.254     0.150
    55.160    10.500     0.150
    55.417   567.645     0.150
    55.417   567.754     0.150
    55.509   568.354     0.150
    55.537   568.654     0.150
    55.537   565.681     0.150
    56.584   574.994     0.150
    56.833   577.344     0.150
    57.012   578.534     0.150
    57.235   579.935     0.150
    57.611   582.874     0.150
    57.669   583.344     0.150
    57.801   583.935     0.150
    57.750   587.131     0.150
    58.026   584.974     0.150
    58.387   588.514     0.150
    58.387   588.654     0.150
    58.622   589.874     0.150
    58.740   590.354     0.150
    58.858   590.554     0.150
    59.240   597.432     0.150
    59.263   596.984     0.150
    59.427   595.414     0.150
    59.346   597.606     0.150
    59.563   601.354     0.150
    59.671   600.326     0.150
    59.813   601.147     0.150
    60.188   600.824     0.150
    60.531   603.384     0.150
    60.646   604.054     0.150
    60.686   607.602     0.150
    60.568  4597.472     0.150
    60.582  4588.097     0.150
    60.585  4590.116     0.150
    60.929   605.384     0.150
    60.741  4595.232     0.150
    60.756  4583.695     0.150
    60.758  4597.106     0.150
    63.193   757.654     0.150
    63.193   620.584     0.150
    63.193   620.754     0.150
    63.353   621.514     0.150
    63.353   621.554     0.150
    63.353   621.454     0.150
    64.413   663.654     0.150
    64.413   627.454     0.150
    66.492   646.824     0.150
    66.492   646.754     0.150
    67.423   653.454     0.150
    67.685   652.954     0.150
    69.160     9.970     0.150
    69.640   665.854     0.150
    69.640   665.935     0.150
    69.640    10.590     0.150
    69.781   668.151     0.150
    71.927   832.254     0.150
    71.927   937.254     0.150
    71.927  1699.854     0.150
    71.927   674.854     0.150
    71.927   675.254     0.150
    73.134  1248.154     0.150
    73.960   850.554     0.150
    73.960   960.954     0.150
    74.391   690.654     0.150
    74.595   693.654     0.150
    74.802   693.264     0.150
    74.802   693.254     0.150
    75.073   697.454     0.150
    75.073   697.754     0.150
    75.073   698.114     0.150
    75.489   697.954     0.150
    75.489  1275.654     0.150
    75.489   697.814     0.150
    75.744   698.514     0.150
    75.744   698.554     0.150
    76.304    10.890     0.150
    77.553   709.364     0.150
    77.553   709.254     0.150
    78.251   711.854     0.150
    78.931    10.341     0.150
    78.931   720.704     0.150
    79.393  1004.154     0.150
    79.393  1823.254     0.150
    82.079   736.304     0.150
    83.095   740.154     0.150
    83.095   740.093     0.150
    85.149   763.654     0.150
    85.486   751.804     0.150
    85.486   750.854     0.150
    85.486   751.954     0.150
    87.319   761.454     0.150
    87.424   762.154     0.150
    87.424   762.354     0.150
    87.833   762.054     0.150
    87.833   762.044     0.150
    87.783   764.054     0.150
    87.812   764.654     0.150
    87.913   764.754     0.150
    88.333   765.854     0.150
    88.404   765.554     0.150
    88.404   765.754     0.150
    88.902   769.654     0.150
    88.891    11.930     0.150
    88.952   769.454     0.150
    89.360   772.127     0.150
    89.360   772.054     0.150
    89.360   772.054     0.150
    89.966   773.654     0.150
    90.141   773.884     0.150
    90.141   773.884     0.150
    90.141  1102.204     0.150
    90.141  1998.924     0.150
    90.141   773.854     0.150
    90.141   985.954     0.150
    90.141  1102.154     0.150
    90.141  1400.854     0.150
    90.141  1493.754     0.150
    90.141  1781.954     0.150
    90.141  1998.854     0.150
    90.280   776.554     0.150
    90.741   775.714     0.150
    91.085   989.354     0.150
    91.109   780.754     0.150
    91.528   782.454     0.150
    92.282    11.440     0.150
    92.282   783.654     0.150
    92.374   785.054     0.150
    92.450   786.111     0.150
    92.570   785.294     0.150
    92.570   785.254     0.150
    92.719   785.884     0.150
    92.719   785.954     0.150
    93.802   791.454     0.150
    93.819   791.454     0.150
    93.917   790.544     0.150
    93.871   791.895     0.150
    93.871   791.854     0.150
    94.227   792.854     0.150
    94.388   792.854     0.150
    94.644   796.040     0.150
    94.849   795.254     0.150
    95.452   799.354     0.150
    95.625   799.754     0.150
    95.664   801.088     0.150
    96.142   801.854     0.150
    96.142   801.854     0.150
    96.516   804.494     0.150
    96.516   804.454     0.150
    96.648   804.554     0.150
    96.746   803.914     0.150
    97.577   809.654     0.150
    97.662   810.354     0.150
    98.065   809.784     0.150
    98.614   812.954     0.150
    98.614  1050.954     0.150
    99.077   814.854     0.150
   103.858  1098.645     0.150
   117.719  1119.954     0.150
   142.708  1165.929     0.150
   150.778  1182.824     0.150
     0.682    14.023     0.150
     0.800    16.125     0.150
     0.830    24.545     0.150
     0.830    15.523     0.150
     1.063    20.023     0.150
     1.099    34.324     0.150
     1.190    22.725     0.150
     1.583    45.523     0.150
     1.875    52.324     0.150
     3.473    51.523     0.150
    30.134   371.043     0.150
    30.134   371.045     0.150
    34.176  2537.113     0.150
    34.187  2554.217     0.150
    34.195  2544.025     0.150
    39.995   453.924     0.150
    58.802   591.824     0.150
    68.263   655.375     0.150
    70.248   667.984     0.150
    75.548   698.768     0.150
     0.371     8.637     0.150
     0.643    13.043     0.150
     0.714    26.401     0.150
     0.880    27.901     0.150
     0.964    18.602     0.150
     0.945    18.602     0.150
     0.937    18.901     0.150
     1.151    35.901     0.150
     1.456    46.102     0.150
     0.234     7.637     0.150
     0.628    11.137     0.150
     0.247     8.337     0.150
     0.629    12.837     0.150
     0.936    16.137     0.150
     1.200    23.937     0.150
     0.143     8.703     0.150
     0.262     5.777     0.150
     1.662    28.902     0.150
     3.073    45.332     0.150
     3.334    37.602     0.150
     5.000    70.645     0.150
     5.088    77.203     0.150
     6.094    91.305     0.150
    26.422     0.000     0.150
    29.265   547.203     0.150
    30.525   372.555     0.150
    30.525   550.191     0.150
    57.808   587.078     0.150
    57.808   587.074     0.150
    67.554   654.793     0.150
    69.413   663.473     0.150
    76.110   706.805     0.150
     0.150     7.609     0.150
     0.156    10.609     0.150
     1.289    24.406     0.150
     0.777    16.562     0.150
     0.828    17.258     0.150
     1.656    29.164     0.150
     0.129     4.639     0.150
     0.233     8.139     0.150
     0.293     8.740     0.150
     0.293    15.939     0.150
     0.589     9.240     0.150
     0.354     9.939     0.150
     0.611    12.039     0.150
     0.611    11.715     0.150
     0.467    11.539     0.150
     0.461    11.439     0.150
     0.750    12.939     0.150
     0.610    14.840     0.150
     0.875    27.139     0.150
     1.251    21.840     0.150
     1.222    22.240     0.150
     1.593    27.939     0.150
     3.356    55.139     0.150
     3.397    51.850     0.150
     3.648    59.039     0.150
     3.940    59.840     0.150
     4.233    62.939     0.150
     4.157    64.340     0.150
     4.598    66.760     0.150
     4.803    69.279     0.150
     5.442    79.039     0.150
     6.263    96.539     0.150
     6.433    92.340     0.150
     6.335    93.240     0.150
     6.803   103.840     0.150
     6.892   101.039     0.150
    49.867   126.840     0.150
   167.458   131.740     0.150
     9.262   135.600     0.150
     9.262   130.299     0.150
     9.387   131.760     0.150
   138.535   153.699     0.150
   138.535   149.559     0.150
   138.535   153.139     0.150
    11.724   160.039     0.150
    11.364   160.160     0.150
    11.301   165.139     0.150
    11.301   166.779     0.150
    11.301   165.291     0.150
    11.301   167.139     0.150
    12.548   178.350     0.150
    12.811   180.100     0.150
    12.811   321.572     0.150
    12.811   180.139     0.150
    12.851   185.240     0.150
    12.851   186.299     0.150
    12.851   179.760     0.150
    13.738   196.039     0.150
    45.530   197.150     0.150
    45.530   191.289     0.150
    45.530   195.539     0.150
    15.285   208.840     0.150
    15.420   212.139     0.150
   167.881   224.740     0.150
   125.343   238.350     0.150
   125.343   230.150     0.150
   125.343   233.539     0.150
    16.624   234.539     0.150
    17.063   240.312     0.150
   121.723   243.240     0.150
    18.846   265.150     0.150
    18.713   262.400     0.150
    18.713   261.840     0.150
   176.250   275.789     0.150
   176.250   280.039     0.150
    21.251   522.639     0.150
    21.251   288.139     0.150
    22.112   291.539     0.150
    22.457   303.629     0.150
    22.457   303.439     0.150
    22.988   306.277     0.150
    23.179   312.879     0.150
    23.571   316.039     0.150
    23.571   315.279     0.150
    24.922   320.939     0.150
    25.984   330.100     0.150
    26.492   760.840     0.150
    26.492  2299.939     0.150
    26.492   540.590     0.150
    26.470   340.129     0.150
    26.829   341.551     0.150
    26.829   337.740     0.150
    27.144   346.109     0.150
    27.516   351.076     0.150
    27.516   351.559     0.150
    27.516   351.080     0.150
    27.516   345.869     0.150
   101.761   356.049     0.150
   101.761   350.420     0.150
   101.761   352.639     0.150
    28.657   362.430     0.150
    28.542  2170.328     0.150
    28.555  2169.760     0.150
    28.556  2168.623     0.150
    60.328   359.600     0.150
    29.470   661.240     0.150
    29.470   548.250     0.150
    29.470   362.840     0.150
    29.470   548.240     0.150
    29.820   364.949     0.150
    29.820   367.039     0.150
    30.492   370.559     0.150
    30.690   377.039     0.150
    30.690   374.729     0.150
    30.817   379.809     0.150
    32.896   399.049     0.150
    32.864     3.801     0.150
    32.864     6.201     0.150
    32.864   715.939     0.150
    33.230   714.539     0.150
    33.665   723.240     0.150
    34.320   405.559     0.150
    34.247  2542.262     0.150
    34.257  2542.994     0.150
    34.266  2542.713     0.150
    35.533   420.070     0.150
    36.412   422.459     0.150
    37.103   429.439     0.150
    37.126   426.479     0.150
    37.126   567.150     0.150
    37.793   439.439     0.150
    37.793   789.740     0.150
    37.955   438.939     0.150
    37.955   794.539     0.150
    39.050   445.629     0.150
    39.789   452.160     0.150
    40.206   826.340     0.150
    40.247   453.539     0.150
    40.194   458.039     0.150
    40.194   455.439     0.150
    40.412     3.900     0.150
    40.412   829.740     0.150
    40.384   459.539     0.150
    40.445   456.479     0.150
    40.646   463.410     0.150
    40.646   462.939     0.150
    40.824  1004.240     0.150
    41.295   467.539     0.150
    41.676   465.139     0.150
    42.931     7.500     0.150
    43.571   483.379     0.150
    43.571   487.240     0.150
    43.988   486.439     0.150
    45.836   500.660     0.150
    46.311   504.539     0.150
    46.311   504.539     0.150
    46.708   508.240     0.150
    47.549     4.500     0.150
    47.615   518.039     0.150
    47.766   520.939     0.150
    47.712   515.930     0.150
    47.712   515.939     0.150
    47.839   517.219     0.150
    48.291   519.049     0.150
    48.291   518.920     0.150
    48.291   518.939     0.150
    50.355   536.840     0.150
    50.871   542.539     0.150
    50.871   977.439     0.150
    51.291   545.539     0.150
    51.291     2.701     0.150
    51.291     8.801     0.150
    51.546   548.000     0.150
    51.546   548.039     0.150
    52.233   550.639     0.150
    52.233   549.139     0.150
    53.217   558.740     0.150
    53.217     5.600     0.150
    54.357   570.240     0.150
    54.569   566.139     0.150
    54.695   567.139     0.150
    55.230   576.240     0.150
    55.553   575.840     0.150
    55.553     2.000     0.150
    55.553  1041.240     0.150
    55.700   573.740     0.150
    55.700   574.939     0.150
    55.647   576.670     0.150
    55.947   575.879     0.150
    55.987   578.740     0.150
    55.987   578.799     0.150
    56.170   580.039     0.150
    56.170   580.119     0.150
    56.389   581.439     0.150
    56.389   581.490     0.150
    56.461   587.789     0.150
    56.776   584.660     0.150
    56.834   585.070     0.150
    56.965   585.660     0.150
    56.965   585.416     0.150
    57.078   586.219     0.150
    57.296   586.059     0.150
    57.247   587.705     0.150
    12.529   586.520     0.150
    57.568   592.139     0.150
    57.770   591.969     0.150
    57.864   588.115     0.150
    57.864  2380.840     0.150
    57.864   588.199     0.150
    57.864   588.240     0.150
    57.983   589.939     0.150
    58.158   591.240     0.150
    58.379   592.740     0.150
    58.747   596.309     0.150
    58.962   599.740     0.150
    58.969   603.023     0.150
    59.230   599.859     0.150
    59.230   599.840     0.150
    59.263   600.139     0.150
    59.263   605.740     0.150
    59.676  1097.740     0.150
    59.640   606.439     0.150
    59.640   606.459     0.150
    59.741   605.240     0.150
    59.741   605.340     0.150
    59.846   602.639     0.150
    59.997  1086.439     0.150
    60.133   608.299     0.150
    61.297  4592.193     0.150
    61.311  4593.240     0.150
    61.314  4590.697     0.150
    61.478  4606.291     0.150
    61.492  4603.871     0.150
    61.495  4604.438     0.150
    62.342   621.240     0.150
    62.478   625.639     0.150
    62.846   626.139     0.150
    63.508   627.840     0.150
    64.082   634.080     0.150
    67.347   652.320     0.150
    67.391   656.639     0.150
    67.399   653.979     0.150
    67.399   653.939     0.150
    67.399   658.840     0.150
    67.666   656.150     0.150
    68.852   663.379     0.150
    69.397   665.209     0.150
    69.397   664.449     0.150
    69.781   669.299     0.150
    69.781   672.814     0.150
    69.781   672.139     0.150
    69.877   669.639     0.150
    69.877   669.650     0.150
    70.999   694.139     0.150
    70.999   831.340     0.150
    70.999  1271.939     0.150
    73.270  1254.139     0.150
    73.270  1739.840     0.150
    73.683   693.029     0.150
    73.970   699.139     0.150
    73.970  1261.340     0.150
    73.946   693.529     0.150
    74.652   696.600     0.150
    75.993   705.900     0.150
    75.993   705.939     0.150
    76.310   707.150     0.150
    76.310   707.139     0.150
    76.870   713.840     0.150
    77.068   712.070     0.150
    77.068   712.039     0.150
    77.459   714.699     0.150
    77.459   714.740     0.150
    78.075   719.039     0.150
    78.723   725.340     0.150
    78.723  1008.539     0.150
    78.723  1324.139     0.150
    78.723  1624.240     0.150
    78.723  1827.639     0.150
    79.179   723.969     0.150
    79.775   725.340     0.150
    79.869   729.240     0.150
    80.178   728.930     0.150
    80.369   733.240     0.150
    80.780   731.619     0.150
    81.822   736.820     0.150
    81.822   737.389     0.150
    81.822   737.119     0.150
    50.355   738.080     0.150
    82.488   740.389     0.150
    82.488   740.439     0.150
    82.971  1368.340     0.150
    83.119   744.979     0.150
    83.606   747.330     0.150
    84.366  1061.539     0.150
    84.711   757.240     0.150
    84.711  1374.139     0.150
    85.362   761.539     0.150
    85.362  1385.439     0.150
    86.773   765.240     0.150
    87.125   766.939     0.150
    87.160   767.240     0.150
    87.641   768.939     0.150
    87.683   766.410     0.150
    87.683   770.939     0.150
    87.691   766.299     0.150
    87.691   766.340     0.150
    88.186   772.783     0.150
    88.239   772.740     0.150
    88.289   772.939     0.150
    88.702   771.850     0.150
    88.702   771.840     0.150
    89.310   778.105     0.150
    89.310   778.039     0.150
    89.386   777.469     0.150
    89.386   777.469     0.150
    89.386  1104.100     0.150
    89.386  1998.299     0.150
    89.386   777.439     0.150
    89.386   987.840     0.150
    89.386  1104.039     0.150
    89.386  1406.939     0.150
    89.386  1780.039     0.150
    89.386  1998.240     0.150
    89.599   779.039     0.150
    89.561   776.289     0.150
    89.561   776.340     0.150
    90.272   778.650     0.150
    90.272   778.639     0.150
    90.881   785.139     0.150
    91.755   785.180     0.150
    91.758   790.404     0.150
    93.043   790.639     0.150
    93.043   790.609     0.150
    94.765   804.840     0.150
    94.928   805.740     0.150
    95.507   809.039     0.150
    96.380   811.754     0.150
    97.380   811.039     0.150
    97.472   815.039     0.150
    97.903  1268.939     0.150
    97.903  1460.939     0.150
    97.903  1628.939     0.150
    97.903  2132.939     0.150
    97.903  2450.939     0.150
    97.903  2810.939     0.150
    97.903  2930.939     0.150
   111.238  1153.340     0.150
   116.828  1124.939     0.150
   143.533  1173.064     0.150
   156.399  1227.359     0.150
     0.427     7.227     0.150
     0.378    15.605     0.150
     1.025    18.238     0.150
     1.229    22.137     0.150
     1.229    38.918     0.150
     1.525    27.035     0.150
    27.370   337.336     0.150
    27.644  2114.996     0.150
    27.657  2116.355     0.150
    27.658  2115.363     0.150
    30.174   546.176     0.150
    34.187  2538.008     0.150
    34.197  2539.711     0.150
    34.206  2539.711     0.150
    97.847   449.418     0.150
    58.727   589.188     0.150
    60.586  4568.359     0.150
    60.600  4568.359     0.150
    60.603  4567.793     0.150
    60.759  4585.008     0.150
    60.774  4583.453     0.150
    60.776  4585.160     0.150
    69.788   659.676     0.150
   144.151  1169.516     0.150
     0.540     9.258     0.150
     0.731    14.258     0.150
     1.032    17.555     0.150
     0.635    12.621     0.150
     0.687    11.721     0.150
     0.732     6.721     0.150
     2.105    23.922     0.150
     0.546    11.391     0.150
     0.546    23.047     0.150
     4.351    70.445     0.150
     5.144    77.742     0.150
     6.285    99.344     0.150
     7.850   114.547     0.150
    34.302  2531.531     0.150
    34.312  2536.062     0.150
    34.321  2542.516     0.150
    61.419  4589.398     0.150
    61.432  4591.203     0.150
    61.436  4587.961     0.150
     0.472     8.180     0.150
     1.050    20.414     0.150
     1.526    25.617     0.150
     0.380    16.062     0.150
     0.143     7.620     0.150
     0.363    16.020     0.150
     1.658    54.120     0.150
     3.156    53.120     0.150
     1.042    20.281     0.150
     3.935    60.375     0.150
     4.101    53.078     0.150
     4.730    77.375     0.150
     6.223    75.281     0.150
     7.994   -56.125     0.150
     9.325    19.477     0.150
    26.378   338.344     0.150
    34.323  2540.305     0.150
    34.332  2540.945     0.150
    34.341  2541.719     0.150
    61.448  4593.078     0.150
    61.462  4591.805     0.150
    61.465  4584.281     0.150
    61.630  4600.508     0.150
    61.644  4594.617     0.150
    61.647  4601.055     0.150
    81.779   739.453     0.150
     0.656    13.805     0.150
     0.816    28.805     0.150
     1.355    43.405     0.150
     1.555    49.705     0.150
     1.711    30.005     0.150
     0.050     1.398     0.150
     0.050     3.000     0.150
     0.544    13.398     0.150
     1.047    16.898     0.150
     1.198    23.398     0.150
     0.866    32.477     0.150
     1.978    34.352     0.150
    23.119   302.648     0.150
    26.952   342.703     0.150
     1.201    20.062     0.150
     1.327    22.062     0.150
     1.413    25.664     0.150
     0.366    14.695     0.150
     0.757    12.494     0.150
     1.250    21.795     0.150
     3.395    54.395     0.150
    26.360   337.096     0.150
     0.379    15.602     0.150
     0.539    20.406     0.150
     0.543    21.805     0.150
     0.543    11.156     0.150
     0.543    22.305     0.150
     0.936    31.906     0.150
     1.221    42.602     0.150
     1.360    45.508     0.150
     1.548    51.703     0.150
     1.639    55.203     0.150
     2.251    74.305     0.150
     3.289    52.703     0.150
     3.667    60.906     0.150
     3.894    59.602     0.150
     4.337    68.805     0.150
    29.497   364.281     0.150
    30.736   552.805     0.150
    54.420   566.117     0.150
    57.741   587.102     0.150
    61.444  4601.312     0.150
    61.458  4579.406     0.150
    61.461  4589.148     0.150
    67.229   652.273     0.150
    83.169   744.648     0.150
     0.186     2.129     0.150
     0.369    11.453     0.150
     0.369     6.578     0.150
     0.488    17.227     0.150
     0.512    19.828     0.150
     0.701    21.328     0.150
     1.057    34.828     0.150
     1.065    21.629     0.150
     1.076    19.629     0.150
     1.025    17.727     0.150
     2.825    44.367     0.150
    20.648   281.289     0.150
    28.859   360.078     0.150
    54.802   569.398     0.150
    58.393   596.316     0.150
    69.885   671.758     0.150
    75.666   709.551     0.150
    82.793   747.145     0.150
     0.110     7.406     0.150
     0.450    17.805     0.150
     0.812    25.707     0.150
     1.340    47.707     0.150
     1.340    47.305     0.150
     0.287     4.094     0.150
     0.287     7.297     0.150
     0.495     8.914     0.150
     0.495     8.297     0.150
     0.495    15.195     0.150
     0.517     8.594     0.150
     0.627    19.195     0.150
     0.801    15.297     0.150
     0.870    17.496     0.150
     1.031    20.996     0.150
     1.182    22.176     0.150
     1.480    26.395     0.150
     1.780    60.496     0.150
     2.727    44.637     0.150
     2.855    46.395     0.150
     3.549    56.395     0.150
     4.285    64.445     0.150
     4.531    73.297     0.150
     5.355    79.254     0.150
     8.281   126.094     0.150
     8.553   129.996     0.150
     8.910   133.496     0.150
     9.345   138.695     0.150
     9.834   140.316     0.150
    10.893   161.695     0.150
    12.448   170.156     0.150
    13.247   188.094     0.150
    13.911   197.297     0.150
    14.343   201.504     0.150
    16.556   238.797     0.150
    18.245   256.996     0.150
   175.588   283.895     0.150
   175.588   291.094     0.150
    22.226   301.695     0.150
    24.651   324.395     0.150
    27.365   346.984     0.150
   102.207   437.297     0.150
    39.910   456.094     0.150
    42.826   480.395     0.150
    47.145   515.195     0.150
    48.357   523.723     0.150
    52.172   550.594     0.150
    54.020   635.297     0.150
    55.775   577.621     0.150
    61.480  4609.387     0.150
    61.494  4609.387     0.150
    61.497  4609.387     0.150
    75.259   702.266     0.150
    79.818   728.844     0.150
   143.245  1174.496     0.150
   146.852  1183.445     0.150
     0.343    14.047     0.150
     0.575    12.141     0.150
     0.575    20.141     0.150
     0.925    32.367     0.150
     1.245    24.445     0.150
     1.426    46.344     0.150
     2.087    36.141     0.150
     3.130    51.844     0.150
    28.798   363.422     0.150
    30.184   374.844     0.150
    57.536   593.945     0.150
     1.336    23.493     0.150
     1.336    42.293     0.150
     1.778    33.493     0.150
     0.153     8.238     0.150
     0.387    15.738     0.150
     0.533     9.139     0.150
     0.546    11.914     0.150
     0.546    21.090     0.150
     0.845    15.840     0.150
     1.062    20.738     0.150
     1.537    50.639     0.150
     2.107    62.939     0.150
     3.299    52.238     0.150
     3.355    54.439     0.150
     3.890    62.039     0.150
     4.290   118.238     0.150
    29.489   363.340     0.150
    30.725   374.359     0.150
    34.303  2541.676     0.150
    34.313  2540.453     0.150
    34.322  2541.135     0.150
    40.696   457.859     0.150
    61.425  4592.082     0.150
    61.439  4588.449     0.150
    61.442  4589.500     0.150
     0.405    15.391     0.150
     0.738    23.990     0.150
     1.098    21.689     0.150
     1.289    22.391     0.150
     0.833    14.857     0.150
     1.612    25.578     0.150
     3.187    81.979     0.150
     0.815    14.113     0.150
     1.091    33.514     0.150
     1.264    22.312     0.150
     1.288    22.514     0.150
     1.288    38.164     0.150
     1.288    22.312     0.150
     1.428    24.713     0.150
     1.577    27.014     0.150
     1.841    30.713     0.150
     1.974    56.613     0.150
     2.012    32.213     0.150
     2.012    56.613     0.150
     3.119    48.414     0.150
     3.529    50.764     0.150
     3.529    54.213     0.150
     3.964    61.213     0.150
     4.456    67.713     0.150
     4.979    73.812     0.150
     5.389    80.213     0.150
     5.602    80.914     0.150
    13.002   185.682     0.150
    13.002   185.684     0.150
    13.309   186.438     0.150
    17.972   246.152     0.150
    20.740   279.143     0.150
    27.436   338.264     0.150
    27.436   539.924     0.150
    27.577  2112.199     0.150
    27.590  2118.258     0.150
    27.591  2119.502     0.150
    29.021   356.783     0.150
    29.021   543.764     0.150
    34.186  2631.094     0.150
    34.196  2629.934     0.150
    34.205  2630.662     0.150
    39.997   450.613     0.150
    40.438   450.043     0.150
    40.438    14.781     0.150
    40.438    22.430     0.150
    41.104   454.514     0.150
    41.816   459.014     0.150
    43.920   472.312     0.150
    47.060   508.014     0.150
    55.561   568.434     0.150
    55.561   629.133     0.150
    13.291   587.453     0.150
    58.910   592.494     0.150
    59.301   597.664     0.150
    60.535  4622.354     0.150
    60.549  4622.596     0.150
    60.552  4619.816     0.150
    60.708  4604.127     0.150
    60.723  4605.178     0.150
    60.725  4602.326     0.150
    63.235   620.514     0.150
    64.465   628.744     0.150
    69.792   668.143     0.150
    74.432   690.643     0.150
    75.021   697.613     0.150
    75.021   698.094     0.150
    76.097   706.053     0.150
    81.365   730.414     0.150
    88.450   765.664     0.150
    88.458   765.414     0.150
    88.947   768.094     0.150
    88.947   768.113     0.150
    89.176   768.514     0.150
    90.775   782.174     0.150
    90.775   777.617     0.150
    92.418   783.643     0.150
    92.620   784.363     0.150
    94.440   791.957     0.150
    94.440   791.953     0.150
   117.764  1120.334     0.150
   133.006  1150.414     0.150
   142.665  1167.643     0.150
   155.423  1218.693     0.150
     1.387    42.307     0.150
     1.049    18.136     0.150
     1.153    20.436     0.150
     0.436     9.211     0.150
     0.416     8.898     0.150
     1.014    18.598     0.150
     1.379    45.098     0.150
     1.990    59.498     0.150
     0.602    10.500     0.150
     1.110    20.602     0.150
     0.400    15.828     0.150
     0.117     7.215     0.150
     1.359    23.793     0.150
     1.707    29.996     0.150
     2.136    33.895     0.150
     0.732    13.426     0.150
     2.310    30.328     0.150
    27.261   344.828     0.150
    32.038   386.379     0.150
    40.403   457.117     0.150
    41.551   466.605     0.150
    47.780   516.398     0.150
    47.780   516.656     0.150
    63.239   628.309     0.150
    75.489   702.398     0.150
     1.231    22.266     0.150
     1.552    49.969     0.150
     1.581    27.367     0.150
     2.036    35.367     0.150
     2.292    39.766     0.150
     2.319    39.867     0.150
     2.334    30.570     0.150
     4.527   113.586     0.150
     5.413   147.469     0.150
    39.187   448.805     0.150
    58.669   595.180     0.150
     0.360    14.828     0.150
     0.413    16.328     0.150
     2.299    38.930     0.150
     0.255    12.582     0.150
     0.256    12.582     0.150
     0.536     8.283     0.150
     0.536    18.982     0.150
     0.601    11.184     0.150
     0.680    11.982     0.150
     0.871    15.783     0.150
     1.218    23.482     0.150
     0.307    13.018     0.150
     2.505    40.773     0.150
    13.066   186.803     0.150
    51.666   548.693     0.150
    54.469   569.453     0.150
    55.170   573.184     0.150
    58.067   594.318     0.150
     0.698    22.221     0.150
     0.152     2.812     0.150
     0.152     3.012     0.150
     0.152     5.609     0.150
     0.152     5.609     0.150
     0.178     3.711     0.150
     0.178     6.512     0.150
     0.178     7.711     0.150
     0.370    12.012     0.150
     0.453    14.711     0.150
     0.453    15.512     0.150
     0.498    17.211     0.150
     0.514     9.812     0.150
     0.514    17.012     0.150
     0.651    13.191     0.150
     0.651    13.211     0.150
     0.651    12.742     0.150
     0.686    22.512     0.150
     0.788    26.312     0.150
     0.904    30.711     0.150
     1.133    37.609     0.150
     1.255    39.910     0.150
     1.448    46.211     0.150
     1.469    45.812     0.150
     1.934    57.711     0.150
     2.502    40.609     0.150
     2.502    40.520     0.150
     4.189    61.789     0.150
     5.021    72.270     0.150
     6.372   106.312     0.150
     9.518   139.812     0.150
   137.825   149.781     0.150
   137.825   145.281     0.150
    45.020   196.840     0.150
    15.080   216.312     0.150
   175.797   278.531     0.150
    21.991   297.922     0.150
    27.013   345.070     0.150
    27.011   344.973     0.150
    28.731   356.910     0.150
    30.022   371.609     0.150
    39.700   457.711     0.150
    47.862   518.211     0.150
    54.501   566.973     0.150
    55.662   578.672     0.150
    61.961  4648.066     0.150
    61.975  4643.582     0.150
    61.978  4641.441     0.150
    70.730   673.320     0.150
    70.730   678.312     0.150
    75.928   706.281     0.150
    79.569   726.859     0.150
    80.331   732.312     0.150
    83.119   747.410     0.150
    88.096   774.410     0.150
    90.927   785.410     0.150
   147.966  1191.109     0.150
     0.303     6.863     0.150
     0.678    13.523     0.150
     2.509    40.980     0.150
     2.547    42.082     0.150
     9.961   145.102     0.150
   137.806   145.473     0.150
    21.993   295.312     0.150
    11.970   346.461     0.150
    30.044   368.961     0.150
    40.074   455.508     0.150
    54.470   567.133     0.150
    55.167   572.082     0.150
    58.049   589.941     0.150
    67.579   652.883     0.150
    87.653   770.141     0.150
    92.254   790.301     0.150
    39.709  1178.094     0.150
   147.471  1181.941     0.150
   149.659  1187.172     0.150
     0.896    15.760     0.150
     0.234     5.045     0.150
     0.619    21.615     0.150
     0.685    23.125     0.150
     0.780    16.125     0.150
     0.872    17.535     0.150
     0.916    31.646     0.150
     1.342    42.535     0.150
     1.397    25.615     0.150
     1.516    26.535     0.150
     2.091    68.905     0.150
     2.100    69.555     0.150
     2.194    72.485     0.150
     2.247    74.305     0.150
     2.502    82.695     0.150
     3.287    51.105     0.150
     3.287   107.735     0.150
     3.338   110.146     0.150
     3.603   118.456     0.150
     3.585   118.465     0.150
     3.597   118.825     0.150
     3.630   119.905     0.150
     4.102    54.396     0.150
     4.102   117.385     0.150
     5.578    89.885     0.150
     6.681    83.005     0.150
     8.729   142.885     0.150
     0.817    27.336     0.150
     0.955    16.352     0.150
     0.955    28.656     0.150
     1.039    32.727     0.150
     0.853    24.352     0.150
     0.853    25.172     0.150
     1.161    20.992     0.150
     4.880    69.672     0.150
     9.926   142.398     0.150
   139.204   161.109     0.150
    21.000   504.898     0.150
    27.836  2115.414     0.150
    27.849  2118.188     0.150
    27.850  2116.180     0.150
    34.028  2530.680     0.150
    34.038  2530.125     0.150
    34.046  2532.930     0.150
    47.441     7.500     0.150
    49.068   517.398     0.150
    54.910   562.008     0.150
    58.522   587.180     0.150
    60.599  4570.961     0.150
    60.612  4572.023     0.150
    60.616  4569.992     0.150
    60.775  4598.969     0.150
    60.789  4607.117     0.150
    60.792  4601.312     0.150
    64.205   627.617     0.150
    67.324   643.281     0.150
    67.980   650.156     0.150
    71.784   672.742     0.150
    80.555   722.398     0.150
    88.667   765.609     0.150
     0.089     5.039     0.150
     0.524     7.898     0.150
     0.562    12.188     0.150
     0.618    13.418     0.150
     0.808    16.340     0.150
     0.938    18.789     0.150
     1.169    22.449     0.150
     7.575   110.129     0.150
     9.857   140.469     0.150
   139.427   165.219     0.150
    46.446   196.629     0.150
    18.805   258.180     0.150
    21.246   509.777     0.150
    23.739   597.559     0.150
    24.715   316.270     0.150
    13.241   344.668     0.150
    27.887  2112.590     0.150
    27.901  2121.082     0.150
    27.901  2116.027     0.150
    34.157   403.227     0.150
    33.730  2538.387     0.150
    33.740  2539.133     0.150
    33.748  2524.594     0.150
    34.370   399.828     0.150
    40.188   452.449     0.150
    41.627   458.930     0.150
    43.681   474.430     0.150
    44.179   482.598     0.150
    45.249   490.430     0.150
    47.420   506.930     0.150
    49.197   522.457     0.150
    52.135   546.727     0.150
    54.091    18.203     0.150
    54.091  1004.629     0.150
    12.844   584.656     0.150
    58.229   637.602     0.150
    58.439   587.629     0.150
    60.282   603.047     0.150
    60.556    45.000     0.150
    60.391  4559.891     0.150
    60.405  4555.168     0.150
    60.409  4563.199     0.150
    60.571  4579.004     0.150
    60.585  4586.355     0.150
    60.588  4583.125     0.150
    61.310   612.840     0.150
    64.147   625.629     0.150
    66.513   646.809     0.150
    71.859   674.500     0.150
    74.887   693.758     0.150
    74.887   693.828     0.150
    75.761   697.727     0.150
    75.314   699.555     0.150
    77.261   608.645     0.150
    78.086   714.656     0.150
    78.581   719.680     0.150
    78.698   720.629     0.150
    80.608   724.328     0.150
    82.300   741.930     0.150
    82.238  1842.047     0.150
    85.106   752.027     0.150
    87.961   765.629     0.150
    87.997   766.027     0.150
    88.005   765.727     0.150
    88.004   765.527     0.150
    88.128   765.227     0.150
    88.474   770.629     0.150
    51.561   767.930     0.150
    89.874   777.027     0.150
    90.429   775.430     0.150
    90.695   777.543     0.150
    92.139   785.148     0.150
   104.023  1092.836     0.150
   129.412  1144.328     0.150
    97.705   681.359     0.150
    97.705   674.688     0.150
     2.930    43.123     0.150
     2.930    77.593     0.150
     3.464    54.692     0.150
     3.464    95.583     0.150
     6.645    94.223     0.150
     9.908   138.612     0.150
    45.742   204.652     0.150
    45.742   202.683     0.150
    15.742   217.513     0.150
    16.408   229.662     0.150
    18.011   249.520     0.150
   175.563   285.312     0.150
   175.563   282.603     0.150
    21.782   294.183     0.150
    22.334   296.322     0.150
    26.436   333.143     0.150
    26.436   607.143     0.150
    27.121   541.062     0.150
    26.883   341.530     0.150
    26.883   342.803     0.150
    12.292   348.662     0.150
    28.796   357.973     0.150
    28.802   358.883     0.150
    29.996   366.492     0.150
    30.492   375.858     0.150
    34.715  2619.155     0.150
    34.725  2617.327     0.150
    34.734  2617.833     0.150
    39.245   446.093     0.150
    39.942   453.593     0.150
    39.942   452.713     0.150
    39.942   576.702     0.150
    47.273    12.500     0.150
    47.273   627.942     0.150
    47.994   934.643     0.150
    48.228   510.942     0.150
    52.402   547.553     0.150
    56.278   578.605     0.150
    57.667   591.335     0.150
    58.484   594.309     0.150
    58.748   599.003     0.150
    59.439   598.963     0.150
    59.446   603.610     0.150
    59.574   598.543     0.150
    59.517   602.934     0.150
    59.548   607.433     0.150
    60.035   592.942     0.150
    59.976   608.189     0.150
    60.205   611.343     0.150
    61.240  4607.688     0.150
    61.254  4607.946     0.150
    61.257  4606.644     0.150
    61.412  4619.110     0.150
    61.427  4619.998     0.150
    61.429  4619.953     0.150
    63.119   622.520     0.150
    67.063   655.612     0.150
    67.063   655.418     0.150
    74.653   695.343     0.150
    75.319   697.732     0.150
    75.409   705.293     0.150
    75.409   705.043     0.150
    76.296   708.343     0.150
    76.483   712.303     0.150
    82.526   739.492     0.150
    82.517   744.012     0.150
    84.872   757.942     0.150
    89.229   777.742     0.150
    90.875   786.177     0.150
    91.256   788.270     0.150
    91.391   788.490     0.150
   165.389  1140.192     0.150
   132.000  1154.673     0.150
   143.488  1171.412     0.150
   145.139  1174.202     0.150
   156.001  1219.893     0.150
    67.423   678.062     0.150
    97.425   678.463     0.150
     2.930    43.363     0.150
     6.645   168.655     0.150
    12.404   176.167     0.150
    45.742   204.754     0.150
    14.621   203.366     0.150
    16.714   237.643     0.150
    21.426   289.442     0.150
    21.782   300.942     0.150
    12.292   348.973     0.150
    28.802   359.043     0.150
    30.033   372.643     0.150
    37.340   434.026     0.150
    38.864   445.226     0.150
    39.706   457.442     0.150
    39.942   454.168     0.150
    39.942   455.442     0.150
    43.481   484.859     0.150
    13.232   589.388     0.150
    59.439   602.844     0.150
    63.119   621.630     0.150
    68.046   653.636     0.150
    69.031   669.343     0.150
    69.262   667.688     0.150
    70.288   675.662     0.150
    75.409   705.317     0.150
    76.483   712.338     0.150
    73.743  1211.213     0.150
    59.914   165.087     0.150
    82.526   739.793     0.150
    27.121   344.362     0.150
    97.425   223.618     0.150
    33.438   227.534     0.150
   132.279   209.795     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.589    11.891     0.150
     0.957    17.586     0.150
     0.902    14.789     0.150
     1.229    21.586     0.150
     1.229    38.742     0.150
     1.473    22.891     0.150
     1.725    29.289     0.150
     1.781    28.789     0.150
     1.933    31.688     0.150
     2.193    34.391     0.150
     2.365    37.289     0.150
     3.023    46.391     0.150
     3.388    51.188     0.150
     3.544    53.891     0.150
     3.544    53.266     0.150
     3.655    55.289     0.150
     3.525    52.086     0.150
     3.923    57.586     0.150
     4.051    60.289     0.150
     4.362    64.789     0.150
     4.486    67.289     0.150
     4.761    69.492     0.150
     4.796    69.188     0.150
     4.957    73.789     0.150
     5.134    75.789     0.150
     5.284    77.086     0.150
     5.301    77.188     0.150
     5.381    79.586     0.150
     5.442    79.891     0.150
     5.553    80.188     0.150
     5.738    84.391     0.150
     6.001    88.086     0.150
     6.045    87.391     0.150
     6.652    95.789     0.150
     6.571    95.789     0.150
     6.953   101.688     0.150
     7.031   102.188     0.150
     6.992   100.992     0.150
     7.140   102.789     0.150
     7.140   101.016     0.150
     7.203   103.992     0.150
     7.327   105.492     0.150
     7.725   111.891     0.150
     8.149   116.789     0.150
     8.172   117.188     0.150
     8.199   117.289     0.150
     8.588   121.086     0.150
     8.571   122.688     0.150
     9.070   130.492     0.150
     9.083   130.586     0.150
     9.055   129.086     0.150
     9.870   140.266     0.150
     9.859   137.992     0.150
    10.094   143.805     0.150
    10.066   142.086     0.150
    10.066   141.828     0.150
    10.194   141.992     0.150
    10.479   149.227     0.150
    11.334   157.289     0.150
    11.521   163.898     0.150
    11.634   161.391     0.150
    13.020   181.406     0.150
    13.020   184.188     0.150
    13.020   183.688     0.150
    13.072   178.992     0.150
    13.072   177.938     0.150
    13.215   180.812     0.150
    13.215   181.086     0.150
    13.315   188.586     0.150
    13.315   188.188     0.150
    13.297   183.188     0.150
    13.631   190.336     0.150
    13.664   192.500     0.150
    13.535   190.586     0.150
    13.664   193.289     0.150
    13.644   191.688     0.150
    14.071   197.688     0.150
    14.577   205.586     0.150
    16.049   224.391     0.150
    16.187   226.289     0.150
    16.436   229.180     0.150
    16.625   230.773     0.150
    16.625   229.688     0.150
    16.867   233.500     0.150
    17.083   235.789     0.150
    17.212   234.391     0.150
    17.152   236.992     0.150
    17.152   236.742     0.150
    17.340   240.945     0.150
    17.200   237.789     0.150
    17.200   233.086     0.150
    17.687   243.688     0.150
    17.872   250.688     0.150
    18.065   245.820     0.150
    18.441   249.188     0.150
    18.930   258.586     0.150
    19.749   265.586     0.150
    19.809   265.688     0.150
    20.559   274.688     0.150
    21.535   287.789     0.150
    21.693   285.586     0.150
    21.900   287.289     0.150
    22.084   289.789     0.150
    22.084   288.031     0.150
    22.312   288.789     0.150
    22.625   297.312     0.150
    23.414   302.789     0.150
    23.770   307.172     0.150
    23.885   308.438     0.150
    24.246   311.898     0.150
    24.227   310.438     0.150
    24.272   311.609     0.150
    24.885   318.328     0.150
    25.252   319.836     0.150
    25.192   318.992     0.150
    25.196   317.789     0.150
    25.642   322.891     0.150
    25.642   322.086     0.150
    26.887   334.086     0.150
    26.887   607.391     0.150
    26.887   332.781     0.150
    26.682   337.336     0.150
    27.339   337.141     0.150
    27.339   539.586     0.150
    27.339   754.539     0.150
    27.677   340.086     0.150
    27.677   756.836     0.150
    27.835   346.289     0.150
    28.568   345.250     0.150
    29.184   353.789     0.150
    29.096   354.867     0.150
    29.096   543.594     0.150
    29.096   760.641     0.150
    29.102   355.492     0.150
    29.102   355.289     0.150
    29.102   356.086     0.150
    29.784   363.891     0.150
    30.203   367.508     0.150
    30.203   369.188     0.150
    30.203   369.031     0.150
    30.136   366.227     0.150
    30.217   365.438     0.150
    30.217   545.641     0.150
    30.217   764.289     0.150
    32.149   381.289     0.150
    33.058   407.391     0.150
    33.058   389.992     0.150
    33.058   554.586     0.150
    33.058   706.391     0.150
    33.465   392.188     0.150
    34.132   397.391     0.150
    34.132   473.992     0.150
    34.132   556.586     0.150
    34.132   721.086     0.150
    34.132   737.789     0.150
    34.132   779.289     0.150
    34.132  1020.086     0.150
    34.007   396.586     0.150
    34.311   400.336     0.150
    34.534   401.688     0.150
    34.534   723.586     0.150
    34.545   403.578     0.150
    34.614   402.367     0.150
    34.614   727.461     0.150
    35.366   409.406     0.150
    35.366   740.109     0.150
    35.641   412.711     0.150
    35.641   743.516     0.150
    36.162   416.570     0.150
    36.162   752.766     0.150
    36.033   416.008     0.150
    36.338   416.289     0.150
    36.581   420.062     0.150
    36.581   756.977     0.150
    36.606   419.680     0.150
    36.606   758.977     0.150
    36.636   423.148     0.150
    36.636   787.602     0.150
    37.169   425.578     0.150
    37.169   767.609     0.150
    37.683   429.289     0.150
    37.683    16.000     0.150
    37.683   519.289     0.150
    37.683   773.289     0.150
    37.685   429.367     0.150
    37.685   774.008     0.150
    38.007   430.469     0.150
    38.082   433.820     0.150
    38.082   780.609     0.150
    38.688   435.586     0.150
    38.688   523.289     0.150
    38.688   789.586     0.150
    38.853   438.586     0.150
    38.853   790.188     0.150
    38.805   434.398     0.150
    39.405   441.992     0.150
    39.542   445.461     0.150
    39.542   799.586     0.150
    39.675   444.688     0.150
    39.855   445.891     0.150
    39.753   447.188     0.150
    39.900   449.289     0.150
    40.220   450.031     0.150
    40.340   450.188     0.150
    40.340   449.891     0.150
    40.340   801.492     0.150
    40.086   451.641     0.150
    40.953   454.789     0.150
    40.964   454.688     0.150
    41.007   455.789     0.150
    41.077   458.086     0.150
    41.077   580.891     0.150
    41.077   824.992     0.150
    41.077   840.391     0.150
    41.134   456.391     0.150
    41.198   456.891     0.150
    41.728   461.086     0.150
    41.728   558.992     0.150
    41.693   460.688     0.150
    41.903   464.289     0.150
    42.032   463.789     0.150
    42.419   466.891     0.150
    43.256   472.391     0.150
    43.827   479.492     0.150
    43.827   583.789     0.150
    43.827   867.289     0.150
    43.827  1054.289     0.150
    44.883   486.688     0.150
    44.814   486.445     0.150
    45.099   490.453     0.150
    45.640   491.688     0.150
    45.456   495.672     0.150
    46.005   496.891     0.150
    46.097   495.906     0.150
    46.219   497.148     0.150
    46.312   496.789     0.150
    46.362   498.469     0.150
    46.386   497.977     0.150
    46.689   500.336     0.150
    46.689   500.922     0.150
    47.068   504.938     0.150
    47.149   508.188     0.150
    47.513   508.188     0.150
    47.513   599.891     0.150
    47.513   830.891     0.150
    47.513   918.391     0.150
    47.513  1095.891     0.150
    47.370   512.758     0.150
    48.012   511.992     0.150
    48.045   512.477     0.150
    48.106   512.898     0.150
    48.149   512.328     0.150
    48.285   514.664     0.150
    48.323   513.891     0.150
    48.342   514.758     0.150
    48.431   515.086     0.150
    48.431   931.086     0.150
    48.499   514.688     0.150
    48.499   837.492     0.150
    48.500   516.336     0.150
    48.532   515.484     0.150
    48.539   515.289     0.150
    48.636   517.703     0.150
    48.656   517.031     0.150
    48.669   517.891     0.150
    48.669   631.789     0.150
    48.669   934.289     0.150
    48.669   951.789     0.150
    48.669  1106.586     0.150
    48.680   517.320     0.150
    48.714   515.031     0.150
    48.714   514.586     0.150
    48.866   518.172     0.150
    49.091   520.852     0.150
    49.137   520.523     0.150
    49.147   520.391     0.150
    49.147   835.266     0.150
    49.147   520.375     0.150
    49.147   835.273     0.150
    49.331   522.023     0.150
    49.418   523.453     0.150
    49.432   523.406     0.150
    49.580   525.117     0.150
    49.712   525.586     0.150
    49.862   527.398     0.150
    50.013   527.641     0.150
    50.131   528.875     0.150
    51.753   539.188     0.150
    51.753   975.391     0.150
    51.530   978.289     0.150
    52.363   546.492     0.150
    53.029   547.391     0.150
    53.029   547.742     0.150
    53.029   547.586     0.150
    53.029   991.492     0.150
    53.030   547.570     0.150
    53.030   619.273     0.150
    53.030   851.180     0.150
    54.097   556.586     0.150
    54.097  1010.391     0.150
    54.331   559.492     0.150
    54.331   624.289     0.150
    54.331  1011.492     0.150
    54.331  1142.688     0.150
    54.331  1232.391     0.150
    54.854   562.086     0.150
    55.205   563.586     0.150
    55.205   689.086     0.150
    55.471   567.367     0.150
    55.471   628.188     0.150
    55.471   861.711     0.150
    55.499   567.188     0.150
    55.499   862.609     0.150
    55.592   567.789     0.150
    55.592   627.789     0.150
    55.592   691.891     0.150
    55.592  1027.391     0.150
    55.905   574.430     0.150
    56.098   571.289     0.150
    56.098   570.859     0.150
    56.559   574.312     0.150
    56.511   578.617     0.150
    56.864   581.250     0.150
    57.238   579.445     0.150
    57.554   582.211     0.150
    57.705   587.188     0.150
    57.900   588.789     0.150
    58.063   585.398     0.150
    58.063   584.992     0.150
    58.106   586.086     0.150
    58.106   638.289     0.150
    58.147   586.352     0.150
    58.323   587.539     0.150
    58.245   590.672     0.150
    58.340   587.766     0.150
    58.340   588.086     0.150
    58.340   587.250     0.150
    58.437   586.289     0.150
    58.505   587.938     0.150
    58.695   589.336     0.150
    58.695   876.469     0.150
    58.695  1176.867     0.150
    58.692   590.102     0.150
    58.692   589.789     0.150
    58.654   593.797     0.150
    58.830   590.445     0.150
    58.831   592.828     0.150
    59.218   596.148     0.150
    59.219   597.211     0.150
    59.223   596.938     0.150
    59.387   594.156     0.150
    59.387   643.898     0.150
    59.387   595.391     0.150
    59.387   725.789     0.150
    59.527   596.891     0.150
    59.668   595.891     0.150
    59.668   596.688     0.150
    59.668   595.562     0.150
    59.626   599.688     0.150
    59.677   599.938     0.150
    59.882   597.688     0.150
    59.789   601.047     0.150
    59.927   598.891     0.150
    59.927   643.492     0.150
    59.926   597.992     0.150
    60.323   603.492     0.150
    60.599   601.992     0.150
    60.764   606.258     0.150
    60.954   604.367     0.150
    61.314   605.789     0.150
    61.314    18.203     0.150
    61.314   648.188     0.150
    61.314  1100.289     0.150
    61.314  1121.492     0.150
    62.497   610.289     0.150
    62.497    23.602     0.150
    62.497  1349.492     0.150
    62.838   620.141     0.150
    63.172   619.586     0.150
    63.172   619.812     0.150
    63.259   620.266     0.150
    63.259  2361.891     0.150
    63.308   620.289     0.150
    63.308  2361.891     0.150
    63.453   623.906     0.150
    63.674   628.062     0.150
    63.936   629.016     0.150
    64.358   627.992     0.150
    64.358    16.297     0.150
    64.369   626.992     0.150
    64.369   626.664     0.150
    64.369   662.289     0.150
    64.393   629.289     0.150
    64.394   630.289     0.150
    64.397   630.797     0.150
    64.724   630.188     0.150
    64.838   634.727     0.150
    65.572   635.492     0.150
    65.572   667.492     0.150
    65.572  1148.492     0.150
    65.722   636.188     0.150
    65.870   639.578     0.150
    65.934   643.195     0.150
    65.942   641.117     0.150
    65.942   642.820     0.150
    66.531   644.141     0.150
    66.568   645.000     0.150
    66.591   645.047     0.150
    66.624   645.047     0.150
    66.864   647.148     0.150
    66.851   646.008     0.150
    66.520   645.727     0.150
    67.039   648.367     0.150
    67.192   644.289     0.150
    67.293   649.938     0.150
    67.348   650.078     0.150
    67.450   650.133     0.150
    67.709   652.180     0.150
    67.470   651.797     0.150
    68.026   654.570     0.150
    68.157   652.305     0.150
    68.223   652.992     0.150
    68.225   655.570     0.150
    68.380   656.766     0.150
    68.787   659.102     0.150
    69.026   660.195     0.150
    69.206   662.367     0.150
    69.584   665.750     0.150
    69.751   667.391     0.150
    69.751   667.688     0.150
    70.145   665.180     0.150
    71.895   674.086     0.150
    71.895   674.391     0.150
    71.895   693.492     0.150
    71.895  1261.188     0.150
    73.913   685.289     0.150
    74.372   689.711     0.150
    74.548   693.188     0.150
    74.548   693.391     0.150
    74.548   693.539     0.150
    74.662   694.367     0.150
    74.782   692.086     0.150
    74.782  1263.789     0.150
    74.782   691.883     0.150
    74.791   693.391     0.150
    74.791  1261.492     0.150
    74.791  1304.289     0.150
    74.671   693.289     0.150
    75.212   696.867     0.150
    75.394   696.586     0.150
    75.394    19.102     0.150
    75.394  1270.391     0.150
    75.394   696.891     0.150
    75.394   696.062     0.150
    75.116   697.414     0.150
    75.719   698.188     0.150
    75.871   702.266     0.150
    75.930   701.281     0.150
    75.930   701.891     0.150
    76.219   702.688     0.150
    76.438   704.172     0.150
    76.489   704.109     0.150
    76.192   704.492     0.150
    76.716   705.789     0.150
    77.196   708.992     0.150
    77.274   708.766     0.150
    77.414   709.422     0.150
    77.414   709.891     0.150
    77.188   710.992     0.150
    77.506   709.586     0.150
    77.506   885.789     0.150
    77.506  1295.188     0.150
    77.506   709.906     0.150
    77.504   711.766     0.150
    77.724   709.992     0.150
    77.925   712.758     0.150
    78.080   712.898     0.150
    78.399   715.688     0.150
    78.636   714.312     0.150
    78.636   714.188     0.150
    78.524   716.297     0.150
    78.729   717.719     0.150
    78.757   718.859     0.150
    78.874   719.578     0.150
    79.018   719.836     0.150
    79.025   718.859     0.150
    79.139   720.477     0.150
    79.147   720.867     0.150
    78.921   720.242     0.150
    79.019   720.812     0.150
    79.345   717.391     0.150
    79.345    19.398     0.150
    79.345   898.289     0.150
    79.345  1311.289     0.150
    81.085   728.891     0.150
    81.314   729.188     0.150
    81.314    19.203     0.150
    81.314  1332.688     0.150
    81.280   731.570     0.150
    81.280   731.188     0.150
    82.385   735.492     0.150
    82.383   736.242     0.150
    82.383  1843.188     0.150
    82.117   735.680     0.150
    82.554   736.188     0.150
    82.731   736.289     0.150
    82.599   741.336     0.150
    83.048   740.086     0.150
    83.048   740.250     0.150
    83.217   739.992     0.150
    83.593   743.086     0.150
    83.841   742.492     0.150
    83.841  1357.891     0.150
    84.217   745.391     0.150
    85.101   748.789     0.150
    85.101  1370.891     0.150
    85.439   751.289     0.150
    85.439   751.539     0.150
    85.699   753.688     0.150
    86.109   754.891     0.150
    86.400   753.789     0.150
    86.400   955.289     0.150
    86.400  1371.586     0.150
    86.400   754.008     0.150
    86.319   757.289     0.150
    87.103   761.188     0.150
    86.868   761.289     0.150
    87.271   761.492     0.150
    87.356   761.188     0.150
    87.376   761.586     0.150
    87.376   761.711     0.150
    87.586   763.492     0.150
    87.664   763.188     0.150
    87.706   762.289     0.150
    87.706  1395.289     0.150
    87.702   763.492     0.150
    87.736   763.492     0.150
    87.758   763.086     0.150
    87.776   764.289     0.150
    87.787   763.891     0.150
    87.803   764.086     0.150
    87.884   764.188     0.150
    87.919   764.289     0.150
    87.981   764.289     0.150
    88.071   763.789     0.150
    88.071   968.188     0.150
    88.071  1384.586     0.150
    88.083   766.469     0.150
    88.083   764.789     0.150
    88.097   765.688     0.150
    88.230   765.891     0.150
    88.285   765.289     0.150
    88.285   765.188     0.150
    88.296   765.688     0.150
    88.356   764.742     0.150
    88.356   973.039     0.150
    88.364   764.688     0.150
    88.364   765.039     0.150
    88.471   768.289     0.150
    88.480   768.086     0.150
    88.581   769.688     0.150
    88.594   766.891     0.150
    88.647   768.961     0.150
    88.660   769.188     0.150
    88.723   768.188     0.150
    88.723   767.586     0.150
    88.822   769.586     0.150
    88.855   769.289     0.150
    88.864   768.688     0.150
    88.905   769.289     0.150
    88.907   769.188     0.150
    88.929   770.086     0.150
    88.957   768.688     0.150
    89.047   769.688     0.150
    88.683   769.742     0.150
    89.313   771.289     0.150
    89.388   769.031     0.150
    89.419   771.086     0.150
    89.435   771.992     0.150
    89.454   771.289     0.150
    89.452   771.086     0.150
    89.462   772.188     0.150
    89.524   771.492     0.150
    89.729   771.891     0.150
    89.791   773.289     0.150
    89.791   772.992     0.150
    89.798   772.086     0.150
    89.812   772.391     0.150
    89.845   772.586     0.150
    89.854   772.188     0.150
    89.919   773.391     0.150
    89.899   773.086     0.150
    89.998   773.891     0.150
    90.095   773.289     0.150
    90.086   773.086     0.150
    90.098   772.688     0.150
    90.145   773.891     0.150
    90.161   773.992     0.150
    90.151   772.891     0.150
    90.180   773.891     0.150
    90.233   775.688     0.150
    90.452   776.086     0.150
    90.448   774.688     0.150
    90.505   774.391     0.150
    90.570   777.492     0.150
    90.695   774.688     0.150
    90.695   774.992     0.150
    90.668   776.391     0.150
    90.329   777.758     0.150
    90.702   777.492     0.150
    90.702   777.188     0.150
    90.702   775.391     0.150
    90.707   777.789     0.150
    90.737   775.992     0.150
    90.773   775.992     0.150
    90.807   777.789     0.150
    90.801   776.289     0.150
    90.892   777.617     0.150
    90.849   775.789     0.150
    90.874   775.992     0.150
    90.902   776.891     0.150
    91.039   777.289     0.150
    91.000   778.391     0.150
    90.709   779.117     0.150
    91.065   779.086     0.150
    91.149   780.086     0.150
    91.188   778.977     0.150
    91.259   779.258     0.150
    91.288   779.492     0.150
    91.272   780.086     0.150
    91.387   780.992     0.150
    91.480   781.492     0.150
    91.486   781.086     0.150
    91.574   780.188     0.150
    91.763   782.289     0.150
    92.234   784.586     0.150
    92.234   784.688     0.150
    92.327   784.492     0.150
    92.327   784.391     0.150
    92.341   784.492     0.150
    92.402   785.289     0.150
    92.402  1005.789     0.150
    92.397   785.289     0.150
    92.523   784.414     0.150
    92.523  1074.039     0.150
    92.671   785.086     0.150
    92.671   785.188     0.150
    92.735   785.047     0.150
    93.192   788.617     0.150
    93.252   789.188     0.150
    93.252   788.086     0.150
    93.507   788.992     0.150
    93.507    17.594     0.150
    93.754   791.188     0.150
    93.772   791.289     0.150
    93.871   789.586     0.150
    93.871   789.750     0.150
    93.824   790.391     0.150
    93.824   791.367     0.150
    93.824   791.188     0.150
    94.180   792.688     0.150
    94.180   792.820     0.150
    94.255   791.891     0.150
    94.342   792.039     0.150
    94.342   792.188     0.150
    94.465   793.688     0.150
    94.465   794.188     0.150
    94.597   794.586     0.150
    94.597    17.305     0.150
    94.597  1021.891     0.150
    94.718   793.977     0.150
    94.804   793.812     0.150
    94.770   794.992     0.150
    95.194   797.492     0.150
    95.194  1026.188     0.150
    95.578   799.391     0.150
    95.578   799.570     0.150
    95.777   801.086     0.150
    95.922   799.242     0.150
    96.095   801.891     0.150
    96.095  1034.188     0.150
    96.137   801.961     0.150
    96.411   802.289     0.150
    96.469   803.086     0.150
    96.534   803.992     0.150
    96.699   804.531     0.150
    96.755   804.727     0.150
    96.993   805.875     0.150
    97.299   807.461     0.150
    97.299  1044.211     0.150
    97.314   807.156     0.150
    97.367  1043.992     0.150
    97.529   807.188     0.150
    97.529  1044.188     0.150
    97.542   808.789     0.150
    97.779   807.266     0.150
    97.876   808.078     0.150
    97.893   808.477     0.150
    97.957   809.812     0.150
    97.957   809.992     0.150
    97.957  1044.891     0.150
    98.017   810.391     0.150
    98.017  1049.188     0.150
    98.017   810.688     0.150
    98.017   809.875     0.150
    98.112   810.688     0.150
    98.112   810.141     0.150
    98.172   808.727     0.150
    98.567  1496.289     0.150
    98.567  1903.289     0.150
    98.609   812.039     0.150
    98.572   812.789     0.150
    98.572  1053.492     0.150
    98.573  1052.492     0.150
    98.707   812.820     0.150
    98.749   812.383     0.150
    99.064   813.281     0.150
    99.210  1917.188     0.150
    99.427  1059.492     0.150
    99.628   817.188     0.150
    99.628   816.547     0.150
    99.667   817.891     0.150
    99.667  1062.391     0.150
   100.273   821.258     0.150
   100.314  1931.688     0.150
   100.540   822.039     0.150
   100.721   824.141     0.150
   100.921   822.422     0.150
   100.994  1071.586     0.150
   101.456  1074.688     0.150
   101.576  1073.188     0.150
   101.859   826.172     0.150
   101.905   827.070     0.150
   101.914   826.406     0.150
   102.186   828.508     0.150
   102.196   827.914     0.150
   102.159  1080.492     0.150
   102.308   828.516     0.150
   102.702   830.648     0.150
   102.959  1086.289     0.150
   103.258   832.688     0.150
   103.282   832.219     0.150
   103.558   834.562     0.150
   103.589   833.328     0.150
   103.589  1092.547     0.150
   103.842   835.289     0.150
   103.953   834.336     0.150
   103.953  1092.867     0.150
   103.953  1787.391     0.150
   103.998   835.070     0.150
   104.063   836.852     0.150
   105.043   840.992     0.150
   105.174   842.680     0.150
   105.299   843.398     0.150
   105.763   844.812     0.150
   106.332   846.336     0.150
   106.555   850.281     0.150
   106.555  1099.984     0.150
   106.555  1779.062     0.150
   107.278   850.812     0.150
   107.930   852.438     0.150
   109.143   860.930     0.150
   111.081  1108.383     0.150
   111.081  1766.586     0.150
   112.062  1108.312     0.150
   112.426  1111.086     0.150
   113.558  1112.438     0.150
   113.659  1113.789     0.150
   113.688  1114.188     0.150
   113.698  1113.891     0.150
   113.698  1168.492     0.150
   113.894  1112.789     0.150
   113.894  1168.492     0.150
   113.935  1113.789     0.150
   113.984  1114.289     0.150
   114.318  1112.891     0.150
   114.318  1171.086     0.150
   114.366  1114.789     0.150
   114.482  1115.289     0.150
   114.642  1115.789     0.150
   114.837  1115.688     0.150
   115.235  1114.992     0.150
   115.269  1170.891     0.150
   117.160  1118.742     0.150
   117.693  1119.234     0.150
   117.693  1742.383     0.150
   121.586  1129.445     0.150
   122.046  1130.586     0.150
   122.223  1130.461     0.150
   122.589  1130.258     0.150
   122.605  1130.141     0.150
   122.908  1131.758     0.150
   122.811  1129.586     0.150
   122.978  1131.578     0.150
   123.217  1131.688     0.150
   123.259  1131.578     0.150
   123.546  1132.422     0.150
   123.609  1132.992     0.150
   123.707  1132.477     0.150
   123.916  1132.742     0.150
   123.982  1133.141     0.150
   124.139  1131.641     0.150
   124.126  1132.766     0.150
   124.204  1133.148     0.150
   124.265  1132.992     0.150
   124.246  1133.539     0.150
   124.377  1135.062     0.150
   124.556  1134.344     0.150
   124.590  1134.016     0.150
   124.708  1134.977     0.150
   124.772  1133.047     0.150
   124.761  1134.992     0.150
   124.811  1134.586     0.150
   124.794  1135.320     0.150
   124.917  1134.570     0.150
   125.060  1135.195     0.150
   125.116  1136.031     0.150
   125.225  1135.164     0.150
   125.225  1135.461     0.150
   125.326  1135.891     0.150
   125.338  1135.844     0.150
   125.582  1136.859     0.150
   125.655  1136.711     0.150
   125.957  1136.273     0.150
   126.534  1137.352     0.150
   126.731  1136.891     0.150
   126.759  1137.812     0.150
   126.902  1138.508     0.150
   127.098  1138.789     0.150
   127.180  1138.508     0.150
   127.205  1139.992     0.150
   127.392  1137.836     0.150
   127.815  1139.320     0.150
   127.815  1140.156     0.150
   127.827  1139.633     0.150
   127.867  1139.688     0.150
   127.847  1140.992     0.150
   128.152  1140.211     0.150
   128.348  1142.758     0.150
   128.536  1142.680     0.150
   129.059  1143.391     0.150
   129.067  1144.391     0.150
   129.190  1143.812     0.150
   129.239  1143.117     0.150
   129.347  1142.945     0.150
   129.347  1142.797     0.150
   129.338  1144.117     0.150
   129.338  1144.547     0.150
   129.422  1144.266     0.150
   129.439  1143.930     0.150
   129.582  1144.211     0.150
   129.837  1144.289     0.150
   129.890  1144.914     0.150
   130.111  1145.688     0.150
   130.105  1145.305     0.150
   130.173  1146.391     0.150
   130.173  1144.914     0.150
   130.249  1145.766     0.150
   130.249  1343.016     0.150
   130.404  1147.133     0.150
   130.404  1343.812     0.150
   130.463  1146.195     0.150
   130.589  1146.289     0.150
   130.767  1148.312     0.150
   130.767  1346.156     0.150
   130.754  1146.883     0.150
   130.809  1145.477     0.150
   130.809  1345.297     0.150
   130.833  1146.672     0.150
   130.902  1347.820     0.150
   130.970  1149.547     0.150
   130.970  1348.211     0.150
   130.951  1346.328     0.150
   131.030  1148.289     0.150
   131.030  1345.602     0.150
   131.049  1147.172     0.150
   131.050  1147.352     0.150
   131.153  1148.508     0.150
   131.153  1348.633     0.150
   131.146  1147.828     0.150
   131.146  1346.930     0.150
   131.238  1347.727     0.150
   131.268  1348.352     0.150
   131.293  1147.750     0.150
   131.312  1147.992     0.150
   131.312  1347.820     0.150
   131.338  1148.016     0.150
   131.338  1347.750     0.150
   131.332  1147.992     0.150
   131.439  1149.039     0.150
   131.439  1348.281     0.150
   131.447  1147.539     0.150
   131.447  1148.930     0.150
   131.447  1348.039     0.150
   131.469  1149.242     0.150
   131.469  1347.852     0.150
   131.567  1148.992     0.150
   131.567  1148.164     0.150
   131.567  1347.102     0.150
   131.601  1148.922     0.150
   131.601  1348.133     0.150
   131.601  1148.227     0.150
   131.602  1148.500     0.150
   131.602  1349.891     0.150
   131.603  1147.930     0.150
   131.603  1348.016     0.150
   131.623  1147.609     0.150
   131.745  1147.688     0.150
   131.745  1348.383     0.150
   131.717  1148.305     0.150
   131.886  1148.195     0.150
   131.885  1148.367     0.150
   131.962  1148.125     0.150
   131.927  1148.484     0.150
   132.030  1148.984     0.150
   132.030  1146.586     0.150
   132.124  1148.875     0.150
   132.124  1350.742     0.150
   132.110  1149.180     0.150
   132.165  1148.828     0.150
   132.165  1350.406     0.150
   132.170  1149.281     0.150
   132.274  1149.102     0.150
   132.274  1150.609     0.150
   132.274  1351.641     0.150
   132.360  1149.211     0.150
   132.384  1148.742     0.150
   132.492  1150.086     0.150
   132.492  1350.211     0.150
   132.492  1149.664     0.150
   132.548  1149.227     0.150
   132.549  1151.367     0.150
   132.635  1150.414     0.150
   132.714  1149.805     0.150
   132.730  1149.906     0.150
   132.719  1148.891     0.150
   132.719  1350.391     0.150
   132.694  1150.539     0.150
   132.732  1151.469     0.150
   132.732  1353.258     0.150
   132.817  1149.609     0.150
   132.792  1150.867     0.150
   132.913  1149.266     0.150
   132.913  1352.812     0.150
   132.913  1149.758     0.150
   132.913  1352.961     0.150
   132.980  1150.531     0.150
   133.111  1150.328     0.150
   133.118  1149.938     0.150
   133.169  1150.555     0.150
   133.216  1150.758     0.150
   133.247  1151.156     0.150
   133.257  1151.195     0.150
   133.280  1150.891     0.150
   133.373  1150.719     0.150
   133.371  1150.469     0.150
   133.439  1150.797     0.150
   133.411  1355.891     0.150
   133.470  1150.820     0.150
   133.516  1151.008     0.150
   133.525  1150.820     0.150
   133.545  1151.266     0.150
   133.582  1151.117     0.150
   133.610  1151.250     0.150
   133.673  1150.633     0.150
   133.673  1353.914     0.150
   133.673  1150.492     0.150
   133.764  1151.383     0.150
   133.841  1151.219     0.150
   133.877  1151.219     0.150
   133.860  1153.289     0.150
   133.860  1359.367     0.150
   133.880  1151.391     0.150
   133.917  1152.016     0.150
   133.965  1151.844     0.150
   133.998  1151.648     0.150
   134.010  1151.938     0.150
   133.968  1152.062     0.150
   133.968  1356.398     0.150
   133.975  1152.117     0.150
   134.080  1151.781     0.150
   134.214  1151.891     0.150
   134.197  1153.391     0.150
   134.226  1151.875     0.150
   134.226  1357.047     0.150
   134.262  1152.383     0.150
   134.272  1152.391     0.150
   134.366  1152.797     0.150
   134.457  1153.211     0.150
   134.475  1152.492     0.150
   134.546  1152.914     0.150
   134.546  1358.352     0.150
   134.595  1152.805     0.150
   134.659  1153.016     0.150
   134.741  1153.094     0.150
   134.785  1153.469     0.150
   134.803  1153.453     0.150
   134.805  1153.359     0.150
   134.846  1153.602     0.150
   134.915  1152.492     0.150
   134.915  1358.539     0.150
   134.983  1153.906     0.150
   135.065  1154.469     0.150
   135.074  1154.750     0.150
   135.074  1155.008     0.150
   135.074  1360.883     0.150
   135.126  1154.484     0.150
   135.162  1154.312     0.150
   135.210  1154.469     0.150
   135.207  1154.484     0.150
   135.244  1154.477     0.150
   135.323  1154.539     0.150
   135.323  1153.508     0.150
   135.323  1359.797     0.150
   135.451  1154.898     0.150
   135.540  1155.164     0.150
   135.542  1155.312     0.150
   135.577  1155.086     0.150
   135.582  1155.312     0.150
   135.648  1362.102     0.150
   135.696  1155.438     0.150
   135.772  1155.586     0.150
   135.961  1156.008     0.150
   135.978  1156.180     0.150
   135.998  1156.250     0.150
   135.967  1156.219     0.150
   136.020  1156.305     0.150
   136.049  1156.148     0.150
   136.040  1156.172     0.150
   136.298  1156.336     0.150
   136.349  1156.609     0.150
   136.439  1156.688     0.150
   136.448  1156.203     0.150
   136.545  1156.875     0.150
   136.571  1157.008     0.150
   136.732  1157.523     0.150
   136.836  1157.750     0.150
   136.843  1157.578     0.150
   136.850  1157.766     0.150
   136.883  1158.289     0.150
   136.883  1157.820     0.150
   137.103  1158.383     0.150
   137.103  1157.711     0.150
   137.103  1365.539     0.150
   137.217  1158.594     0.150
   137.238  1158.625     0.150
   137.285  1158.445     0.150
   137.298  1158.656     0.150
   137.347  1159.055     0.150
   137.363  1159.305     0.150
   137.371  1367.141     0.150
   137.672  1159.453     0.150
   137.762  1159.375     0.150
   137.779  1159.602     0.150
   137.790  1159.539     0.150
   137.947  1160.141     0.150
   137.946  1160.391     0.150
   138.002  1159.969     0.150
   138.145  1160.195     0.150
   138.155  1160.078     0.150
   138.183  1160.359     0.150
   138.192  1160.289     0.150
   138.209  1160.391     0.150
   138.211  1160.719     0.150
   138.211  1158.078     0.150
   138.378  1160.477     0.150
   138.453  1161.305     0.150
   138.496  1161.469     0.150
   138.630  1161.688     0.150
   138.677  1162.008     0.150
   138.691  1161.758     0.150
   138.762  1161.820     0.150
   138.762  1370.438     0.150
   138.839  1161.953     0.150
   138.824  1161.859     0.150
   138.903  1162.227     0.150
   138.990  1162.367     0.150
   139.029  1162.336     0.150
   139.044  1162.375     0.150
   139.044  1371.352     0.150
   139.136  1162.695     0.150
   139.159  1162.406     0.150
   139.269  1162.828     0.150
   139.353  1162.820     0.150
   139.407  1163.117     0.150
   139.429  1163.008     0.150
   139.473  1157.828     0.150
   139.476  1163.320     0.150
   139.483  1163.516     0.150
   139.499  1163.430     0.150
   139.507  1163.789     0.150
   139.535  1163.547     0.150
   139.554  1163.461     0.150
   139.662  1163.445     0.150
   139.700  1163.977     0.150
   139.759  1163.969     0.150
   139.826  1164.383     0.150
   139.861  1163.250     0.150
   139.864  1163.695     0.150
   139.896  1163.711     0.150
   140.081  1164.328     0.150
   140.139  1164.414     0.150
   140.175  1164.758     0.150
   140.197  1164.867     0.150
   140.187  1165.023     0.150
   140.271  1165.062     0.150
   140.274  1165.086     0.150
   140.371  1165.383     0.150
   140.415  1165.500     0.150
   140.530  1165.906     0.150
   140.540  1165.992     0.150
   140.552  1165.547     0.150
   140.625  1165.602     0.150
   140.660  1165.648     0.150
   140.714  1165.867     0.150
   140.704  1166.609     0.150
   140.712  1165.422     0.150
   140.934  1165.086     0.150
   140.964  1166.844     0.150
   140.978  1166.711     0.150
   141.003  1166.359     0.150
   141.097  1166.609     0.150
   141.113  1166.969     0.150
   141.119  1166.414     0.150
   141.149  1166.906     0.150
   141.422  1167.609     0.150
   141.447  1167.578     0.150
   141.510  1167.164     0.150
   141.511  1167.492     0.150
   141.573  1167.859     0.150
   141.776  1168.297     0.150
   141.831  1168.641     0.150
   141.873  1168.641     0.150
   141.915  1168.812     0.150
   141.930  1168.742     0.150
   141.976  1168.938     0.150
   142.167  1169.125     0.150
   142.245  1164.633     0.150
   142.272  1169.734     0.150
   142.293  1169.781     0.150
   142.346  1169.547     0.150
   142.375  1169.578     0.150
   142.379  1169.922     0.150
   142.561  1170.477     0.150
   142.650  1170.469     0.150
   142.661  1170.625     0.150
   142.908  1170.820     0.150
   143.040  1171.359     0.150
   143.166  1171.320     0.150
   143.192  1171.867     0.150
   143.232  1172.102     0.150
   143.296  1166.109     0.150
   143.382  1166.742     0.150
   143.447  1166.875     0.150
   143.481  1166.867     0.150
   143.529  1165.883     0.150
   143.528  1166.234     0.150
   143.535  1166.992     0.150
   143.599  1166.016     0.150
   143.611  1165.133     0.150
   143.622  1166.133     0.150
   143.638  1167.109     0.150
   143.649  1167.320     0.150
   143.766  1166.586     0.150
   143.750  1167.297     0.150
   143.763  1167.359     0.150
   143.852  1167.016     0.150
   143.852  1166.859     0.150
   143.872  1166.391     0.150
   143.891  1167.602     0.150
   143.944  1166.852     0.150
   144.033  1167.227     0.150
   144.067  1167.633     0.150
   144.076  1168.438     0.150
   144.165  1169.211     0.150
   144.165  1382.203     0.150
   144.207  1168.320     0.150
   144.212  1168.719     0.150
   144.234  1169.086     0.150
   144.297  1168.094     0.150
   144.291  1168.398     0.150
   144.291  1168.562     0.150
   144.279  1168.953     0.150
   144.303  1167.875     0.150
   144.305  1168.391     0.150
   144.347  1168.484     0.150
   144.374  1167.930     0.150
   144.374  1168.398     0.150
   144.375  1169.102     0.150
   144.383  1169.070     0.150
   144.456  1167.789     0.150
   144.565  1169.539     0.150
   144.608  1169.516     0.150
   144.603  1170.258     0.150
   144.616  1170.047     0.150
   144.729  1169.773     0.150
   144.748  1169.570     0.150
   144.781  1170.695     0.150
   144.811  1170.883     0.150
   144.821  1170.852     0.150
   144.842  1170.750     0.150
   144.874  1170.273     0.150
   144.889  1170.633     0.150
   144.969  1170.977     0.150
   145.116  1171.859     0.150
   145.144  1171.391     0.150
   145.138  1171.984     0.150
   145.138  1172.297     0.150
   145.157  1171.977     0.150
   145.192  1171.367     0.150
   145.200  1171.414     0.150
   145.200  1171.539     0.150
   145.209  1171.703     0.150
   145.286  1171.398     0.150
   145.279  1172.320     0.150
   145.417  1172.812     0.150
   145.455  1172.766     0.150
   145.445  1173.281     0.150
   145.523  1172.430     0.150
   145.546  1172.242     0.150
   145.572  1172.461     0.150
   145.594  1173.664     0.150
   145.619  1172.734     0.150
   145.621  1173.906     0.150
   145.674  1171.992     0.150
   145.659  1173.805     0.150
   145.754  1173.680     0.150
   145.839  1174.758     0.150
   145.860  1173.789     0.150
   145.925  1173.797     0.150
   145.971  1174.195     0.150
   145.976  1173.562     0.150
   146.008  1175.047     0.150
   146.001  1175.383     0.150
   146.074  1173.992     0.150
   146.181  1175.594     0.150
   146.190  1175.078     0.150
   145.935  1175.602     0.150
   146.340  1174.891     0.150
   146.340  1176.016     0.150
   146.375  1175.531     0.150
   146.414  1174.672     0.150
   146.404  1175.492     0.150
   146.405  1176.070     0.150
   146.474  1176.242     0.150
   146.517  1175.852     0.150
   146.514  1176.422     0.150
   146.566  1174.891     0.150
   146.579  1174.539     0.150
   146.614  1176.867     0.150
   146.647  1176.484     0.150
   146.664  1176.625     0.150
   146.702  1174.781     0.150
   146.705  1176.336     0.150
   146.728  1176.602     0.150
   146.876  1175.281     0.150
   146.905  1175.586     0.150
   146.878  1177.328     0.150
   146.918  1177.945     0.150
   146.960  1177.641     0.150
   147.003  1175.789     0.150
   147.095  1175.688     0.150
   147.115  1177.930     0.150
   147.162  1175.328     0.150
   147.183  1177.812     0.150
   147.217  1178.273     0.150
   147.252  1177.797     0.150
   147.249  1177.453     0.150
   147.225  1178.844     0.150
   147.261  1178.109     0.150
   147.306  1177.961     0.150
   147.351  1176.609     0.150
   147.378  1179.227     0.150
   147.420  1176.492     0.150
   147.420  1178.273     0.150
   147.442  1178.961     0.150
   147.469  1179.656     0.150
   147.552  1178.930     0.150
   147.527  1179.055     0.150
   147.539  1179.250     0.150
   147.590  1179.031     0.150
   147.597  1178.797     0.150
   147.605  1179.750     0.150
   147.659  1179.438     0.150
   147.721  1180.172     0.150
   147.773  1178.508     0.150
   147.750  1179.828     0.150
   147.883  1177.211     0.150
   147.872  1180.867     0.150
   147.959  1181.062     0.150
   147.986  1180.977     0.150
   148.023  1177.992     0.150
   148.074  1179.711     0.150
   148.063  1180.711     0.150
   148.084  1180.281     0.150
   148.143  1181.125     0.150
   148.185  1181.617     0.150
   148.174  1181.602     0.150
   148.352  1181.742     0.150
   148.354  1182.547     0.150
   148.420  1180.297     0.150
   148.404  1181.984     0.150
   148.406  1182.547     0.150
   148.401  1182.289     0.150
   148.454  1182.211     0.150
   148.571  1182.609     0.150
   148.596  1182.992     0.150
   148.698  1183.328     0.150
   148.736  1183.117     0.150
   148.763  1181.492     0.150
   148.782  1182.992     0.150
   148.834  1183.898     0.150
   148.852  1183.109     0.150
   148.852  1183.461     0.150
   148.916  1184.328     0.150
   148.948  1183.852     0.150
   149.020  1184.406     0.150
   149.048  1183.961     0.150
   149.093  1184.734     0.150
   149.153  1184.789     0.150
   149.216  1184.070     0.150
   149.349  1185.164     0.150
   149.392  1185.328     0.150
   149.405  1186.352     0.150
   149.462  1185.094     0.150
   149.509  1179.586     0.150
   149.555  1179.445     0.150
   149.557  1184.906     0.150
   149.595  1186.008     0.150
   149.702  1186.359     0.150
   149.430  1185.750     0.150
   149.899  1180.398     0.150
   149.882  1186.508     0.150
   149.900  1186.773     0.150
   149.958  1186.953     0.150
   149.992  1186.664     0.150
   150.039  1180.391     0.150
   150.093  1184.570     0.150
   150.191  1187.273     0.150
   150.654  1186.188     0.150
   150.833  1187.211     0.150
   151.817  1189.055     0.150
   151.817  1183.477     0.150
   151.821  1183.078     0.150
   152.406  1190.516     0.150
   153.387  1193.945     0.150
   154.426  1195.367     0.150
   154.574  1195.078     0.150
   160.807  1237.172     0.150
   160.615  1195.156     0.150
   168.833  1271.938     0.150
   170.686  1204.469     0.150
   177.248  1204.602     0.150
   177.421  1310.867     0.150
   178.027  1205.438     0.150
   178.714  1204.172     0.150
   178.982  1207.391     0.150
     0.179     4.453     0.150
     1.045    18.234     0.150
     0.892    16.258     0.150
     0.892    30.055     0.150
     1.437    46.258     0.150
     1.955    32.555     0.150
     2.097    34.758     0.150
     2.402    39.359     0.150
     2.429    39.453     0.150
     2.586    44.258     0.150
     3.073    50.359     0.150
     3.323    52.156     0.150
     3.854    58.953     0.150
     3.854    58.773     0.150
     4.071    63.156     0.150
     4.265    66.555     0.150
     4.248    67.758     0.150
     4.347    68.656     0.150
     4.347    68.359     0.150
     4.439    67.859     0.150
     4.653    68.953     0.150
     4.771    73.258     0.150
     5.330    81.055     0.150
     5.653    84.453     0.150
     5.873    86.156     0.150
     6.529    97.758     0.150
     6.970   102.758     0.150
     7.695   113.453     0.150
     7.678   112.359     0.150
     7.779   113.859     0.150
     7.957   115.859     0.150
     8.459   122.859     0.150
     8.666   126.258     0.150
     8.992   130.859     0.150
     8.992   131.195     0.150
    10.291   147.156     0.150
    10.656   151.359     0.150
    12.071   168.555     0.150
    12.149   168.453     0.150
    12.149   169.305     0.150
    13.564   193.758     0.150
    13.517   189.156     0.150
    13.690   195.156     0.150
    15.086   214.953     0.150
    15.634   218.578     0.150
    16.149   228.055     0.150
    16.097   230.656     0.150
    16.970   238.156     0.150
    17.153   235.453     0.150
    17.239   240.758     0.150
    17.239   242.156     0.150
    17.756   244.586     0.150
    19.114   260.078     0.150
    20.420   282.258     0.150
    20.782   282.453     0.150
    21.183   284.758     0.150
    21.708   290.883     0.150
    21.708   289.180     0.150
    22.087   291.438     0.150
    23.310   307.859     0.150
    23.784   311.953     0.150
    23.895   310.273     0.150
    24.623   321.555     0.150
    24.922   320.148     0.150
    25.105   325.453     0.150
    26.184   331.188     0.150
    26.223   330.523     0.150
    26.223   331.664     0.150
    26.223   541.156     0.150
    26.561   334.727     0.150
    29.935   366.688     0.150
    29.935   550.234     0.150
    29.935   366.688     0.150
    29.935   550.227     0.150
    29.946   366.617     0.150
    31.141   377.797     0.150
    31.140   377.406     0.150
    31.140   553.656     0.150
    31.177   378.398     0.150
    31.177   551.719     0.150
    31.205   378.539     0.150
    31.973   386.258     0.150
    33.085   395.359     0.150
    33.306   395.773     0.150
    33.513   398.367     0.150
    34.122   403.977     0.150
    35.220   409.789     0.150
    36.663   423.516     0.150
    36.622   425.047     0.150
    37.616   433.055     0.150
    39.222   445.250     0.150
    40.253   453.500     0.150
    40.398   455.258     0.150
    40.665   459.664     0.150
    40.940   461.453     0.150
    41.077   463.430     0.150
    41.077   582.859     0.150
    45.283   495.328     0.150
    45.956   499.055     0.150
    46.425   504.453     0.150
    46.425   912.156     0.150
    46.425  1110.359     0.150
    47.661   515.055     0.150
    48.332   518.008     0.150
    48.332   518.008     0.150
    53.210   556.055     0.150
    54.098   563.258     0.150
    54.423   562.484     0.150
    54.423   562.492     0.150
    55.553   572.930     0.150
    57.553   585.133     0.150
    57.577   585.719     0.150
    57.577   584.844     0.150
    57.577   584.852     0.150
    57.577   585.984     0.150
    57.577   586.156     0.150
    58.294   593.562     0.150
    58.710   593.555     0.150
    59.421   601.250     0.150
    60.005   603.453     0.150
    62.190   619.984     0.150
    62.419   619.289     0.150
    63.258   622.938     0.150
    63.258   623.734     0.150
    63.261   622.938     0.150
    63.296   629.000     0.150
    65.210   641.875     0.150
    66.786   649.445     0.150
    66.958   652.094     0.150
    67.407   655.945     0.150
    67.407   656.164     0.150
    68.088   658.547     0.150
    69.043   661.133     0.150
    69.327   669.281     0.150
    69.327   667.953     0.150
    69.327   669.859     0.150
    75.517   705.656     0.150
    75.517     4.398     0.150
    76.217   707.656     0.150
    76.217   708.125     0.150
    77.056   714.156     0.150
    79.154   726.133     0.150
    80.333   730.000     0.150
    81.390   733.703     0.150
    81.390   734.039     0.150
    81.390   733.703     0.150
    81.390   734.453     0.150
    83.163   747.336     0.150
    86.641   763.555     0.150
    86.708   762.359     0.150
    86.831   766.055     0.150
    87.290   763.406     0.150
    87.824   768.156     0.150
    87.874   768.359     0.150
    88.012   768.258     0.150
    88.285   769.859     0.150
    88.285   770.000     0.150
    89.194   773.844     0.150
    89.207   774.039     0.150
    89.701   776.359     0.150
    89.563   779.438     0.150
    89.563   779.195     0.150
    89.835   776.156     0.150
    91.586   788.711     0.150
    91.736   788.359     0.150
   143.523  1172.828     0.150
   143.523  1173.125     0.150
   145.859  1176.977     0.150
   145.896  1177.008     0.150
   146.350  1182.445     0.150
   146.993  1179.555     0.150
   147.906  1181.477     0.150
   149.654  1185.117     0.150
   149.654  1188.273     0.150
   161.293  1246.094     0.150
     0.732    13.281     0.150
     0.732    22.578     0.150
     1.302    22.180     0.150
     1.302    38.680     0.150
     1.420    24.180     0.150
     1.420    23.977     0.150
     1.760    29.281     0.150
     1.760    52.352     0.150
     1.859    28.930     0.150
     1.859    28.477     0.150
     1.859    50.578     0.150
     2.152    33.875     0.150
     2.369    36.680     0.150
     2.369    64.375     0.150
     2.399    38.078     0.150
     2.759    42.680     0.150
     3.033    46.477     0.150
     3.401    51.781     0.150
     4.250    60.820     0.150
     4.250    63.477     0.150
     4.305    64.977     0.150
     4.330    63.680     0.150
     4.611    69.180     0.150
     4.475    66.266     0.150
     4.564    66.898     0.150
     4.564    67.578     0.150
     4.564   117.281     0.150
     4.933    71.375     0.150
     4.953    74.875     0.150
     5.225    77.180     0.150
     5.241    77.875     0.150
     5.837    86.078     0.150
     6.847   100.875     0.150
     6.924    98.875     0.150
     7.478   108.477     0.150
     7.967   114.281     0.150
     8.196   117.641     0.150
     8.196   119.180     0.150
     9.116   127.109     0.150
     9.116   129.477     0.150
     9.127   126.578     0.150
     9.382   132.984     0.150
     9.382   133.578     0.150
     9.208   132.578     0.150
     9.260   132.180     0.150
     9.846   136.930     0.150
     9.846   139.578     0.150
    10.338   142.180     0.150
    10.152   142.961     0.150
    10.152   143.578     0.150
    11.631   164.555     0.150
    11.631   165.578     0.150
    11.797   165.078     0.150
    12.032   163.250     0.150
    12.032   163.680     0.150
    12.246   167.180     0.150
    12.246   167.438     0.150
    13.194   189.680     0.150
    13.684   188.258     0.150
    13.684   188.578     0.150
    13.689   188.477     0.150
    13.748   186.781     0.150
    13.931   193.281     0.150
    13.931   196.633     0.150
    14.176   200.375     0.150
    14.243   200.875     0.150
    14.400   205.281     0.150
    14.499   203.680     0.150
    15.441   208.984     0.150
    15.645   213.281     0.150
    16.179   221.977     0.150
    16.385   223.875     0.150
    16.631   232.680     0.150
    16.846   232.289     0.150
    16.942   234.781     0.150
    17.112   234.594     0.150
    17.112   234.336     0.150
    17.907   246.578     0.150
    17.726   241.914     0.150
    17.928   244.109     0.150
    18.265   248.977     0.150
    18.685   253.078     0.150
    19.399   259.680     0.150
    19.083   260.102     0.150
    19.663   267.375     0.150
    19.446   264.188     0.150
    19.976   268.336     0.150
    20.667   274.578     0.150
    21.147   281.578     0.150
    21.639   284.281     0.150
    21.921   291.031     0.150
    21.921   289.891     0.150
    22.427   294.961     0.150
    22.660   297.078     0.150
    22.852   297.688     0.150
    22.864   297.406     0.150
    22.864   298.180     0.150
    22.593   298.570     0.150
    23.070   301.641     0.150
    23.054   297.250     0.150
    23.148   302.016     0.150
    23.336   303.906     0.150
    23.498   303.180     0.150
    23.546   305.234     0.150
    23.859   309.172     0.150
    23.545   307.961     0.150
    23.545   307.031     0.150
    23.940   309.211     0.150
    23.958   310.891     0.150
    23.795   308.922     0.150
    24.000   308.578     0.150
    24.203   308.805     0.150
    24.313   310.578     0.150
    24.336   310.195     0.150
    24.336   310.578     0.150
    24.301   313.656     0.150
    24.301   309.555     0.150
    24.301   310.562     0.150
    24.376   313.672     0.150
    24.409   312.859     0.150
    24.443   311.180     0.150
    24.496   312.078     0.150
    24.779   316.570     0.150
    24.849   317.406     0.150
    25.147   319.477     0.150
    25.194   321.016     0.150
    25.131   319.008     0.150
    25.328   322.258     0.150
    25.469   320.477     0.150
    25.484   323.352     0.150
    25.562   322.781     0.150
    25.186   324.469     0.150
    25.363   322.320     0.150
    25.363   321.891     0.150
    25.666   324.180     0.150
    26.047   329.430     0.150
    26.066   328.438     0.150
    26.108   334.031     0.150
    26.065   327.555     0.150
    26.558   333.578     0.150
    26.558   604.180     0.150
    26.558   623.281     0.150
    26.583   331.180     0.150
    26.583   538.008     0.150
    26.622   331.109     0.150
    26.622   538.117     0.150
    26.622   333.047     0.150
    26.622   330.680     0.150
    26.622   538.281     0.150
    26.622   753.727     0.150
    26.242   332.172     0.150
    26.568   332.086     0.150
    26.568   333.477     0.150
    26.628   333.445     0.150
    26.457   333.523     0.150
    26.961   334.680     0.150
    26.964   333.586     0.150
    26.964   335.195     0.150
    26.964   334.680     0.150
    27.073   335.016     0.150
    27.461   343.750     0.150
    27.461   540.750     0.150
    27.461   343.062     0.150
    27.623   344.250     0.150
    28.096   348.586     0.150
    28.642   349.797     0.150
    29.098   358.570     0.150
    29.098   358.078     0.150
    29.098   358.750     0.150
    29.312   356.211     0.150
    30.204   366.984     0.150
    30.204   547.047     0.150
    30.204   663.047     0.150
    30.204   366.992     0.150
    30.204   547.055     0.150
    30.204   663.055     0.150
    30.210   366.148     0.150
    30.210   366.578     0.150
    30.214   366.586     0.150
    31.123   375.625     0.150
    31.123   375.188     0.150
    31.123   550.211     0.150
    31.310   376.359     0.150
    31.309   376.930     0.150
    31.309   550.375     0.150
    31.309   997.977     0.150
    31.347   376.109     0.150
    32.494   384.477     0.150
    32.494   698.375     0.150
    32.494   719.180     0.150
    32.649   387.297     0.150
    32.940   391.477     0.150
    33.680   395.578     0.150
    33.680   471.281     0.150
    33.680   714.375     0.150
    33.680   737.578     0.150
    33.680   841.977     0.150
    33.737   394.898     0.150
    34.101   398.641     0.150
    34.305   399.891     0.150
    34.415   401.781     0.150
    34.957   405.281     0.150
    34.957   405.875     0.150
    35.262   408.250     0.150
    35.084   409.945     0.150
    35.524   409.305     0.150
    35.524   408.500     0.150
    35.524   410.578     0.150
    35.524   740.578     0.150
    35.791   412.195     0.150
    36.628   421.578     0.150
    36.628   756.578     0.150
    36.628   420.758     0.150
    36.691   420.188     0.150
    37.121   426.242     0.150
    37.121   425.961     0.150
    37.626   427.641     0.150
    37.663   431.500     0.150
    37.663   431.188     0.150
    37.663   568.555     0.150
    38.166   431.680     0.150
    38.166   521.781     0.150
    38.166   778.977     0.150
    38.166   801.078     0.150
    38.531   435.375     0.150
    38.595   436.477     0.150
    38.595   788.781     0.150
    38.775   438.305     0.150
    38.971   439.375     0.150
    38.825   441.852     0.150
    39.125   442.547     0.150
    39.552   444.375     0.150
    39.552   443.977     0.150
    39.552   444.625     0.150
    39.764   446.078     0.150
    40.058   447.977     0.150
    40.069   447.977     0.150
    40.121   448.977     0.150
    40.236   449.680     0.150
    39.999   451.797     0.150
    40.304   450.180     0.150
    40.346   452.281     0.150
    40.346   451.117     0.150
    40.831   457.289     0.150
    40.802   457.250     0.150
    40.802   456.711     0.150
    41.136   457.875     0.150
    41.136   826.477     0.150
    41.136   847.078     0.150
    41.117   457.281     0.150
    41.008   460.125     0.150
    41.008   579.305     0.150
    41.008   459.859     0.150
    41.325   457.977     0.150
    41.325  1057.781     0.150
    41.306   459.281     0.150
    41.147   461.406     0.150
    41.147   579.555     0.150
    41.511   460.375     0.150
    41.697   461.977     0.150
    41.604   463.188     0.150
    41.840   468.922     0.150
    43.316   475.375     0.150
    43.316   585.875     0.150
    43.816   483.516     0.150
    44.123   485.750     0.150
    44.650   484.875     0.150
    44.853   491.641     0.150
    45.302   490.875     0.150
    45.302   885.875     0.150
    45.341   490.578     0.150
    46.091   497.938     0.150
    46.077   498.258     0.150
    46.768   502.453     0.150
    46.563   505.172     0.150
    46.563   504.484     0.150
    46.776   504.516     0.150
    46.935   504.180     0.150
    46.935   598.078     0.150
    46.935   830.578     0.150
    46.935  1091.977     0.150
    46.724   507.922     0.150
    46.724   505.320     0.150
    47.199   506.086     0.150
    47.332   511.375     0.150
    47.931   511.781     0.150
    47.982   512.977     0.150
    48.134   513.125     0.150
    48.156   512.875     0.150
    48.156   928.578     0.150
    48.305   514.781     0.150
    48.305   930.281     0.150
    48.335   602.781     0.150
    48.208   517.531     0.150
    48.529   516.477     0.150
    48.462   520.672     0.150
    48.462   519.258     0.150
    48.476   520.328     0.150
    49.113   521.055     0.150
    49.113   520.727     0.150
    49.113   605.375     0.150
    49.113   835.727     0.150
    49.113   520.727     0.150
    49.113   605.375     0.150
    49.113   835.727     0.150
    49.147   520.930     0.150
    49.147   605.266     0.150
    48.994   525.023     0.150
    49.064   525.773     0.150
    50.342   535.227     0.150
    50.671   536.758     0.150
    51.283   537.484     0.150
    51.644   538.211     0.150
    53.177   549.352     0.150
    53.177   620.625     0.150
    53.177   548.977     0.150
    53.177   549.289     0.150
    53.177   620.625     0.150
    53.177   549.219     0.150
    53.415   554.648     0.150
    53.602   554.680     0.150
    53.602   622.375     0.150
    53.602  1000.977     0.150
    53.602   554.500     0.150
    53.954   555.578     0.150
    53.954   623.078     0.150
    53.954  1004.781     0.150
    54.318   558.477     0.150
    54.318   685.781     0.150
    54.388   560.930     0.150
    55.012   564.680     0.150
    55.012   627.141     0.150
    55.012   860.617     0.150
    55.012   564.680     0.150
    55.012   627.141     0.150
    55.012   860.617     0.150
    55.050   565.055     0.150
    55.050   564.781     0.150
    55.050   564.891     0.150
    55.281   567.102     0.150
    55.378   570.125     0.150
    55.655   570.180     0.150
    55.633   569.180     0.150
    55.831   570.398     0.150
    55.876   572.219     0.150
    55.958   571.078     0.150
    56.010   629.578     0.150
    56.010   698.180     0.150
    56.010   865.180     0.150
    56.010   570.922     0.150
    55.919   574.602     0.150
    56.360   573.578     0.150
    56.377   574.055     0.150
    56.510   574.406     0.150
    56.510   574.656     0.150
    56.510   632.531     0.150
    56.684   576.867     0.150
    56.706   576.375     0.150
    56.777   576.680     0.150
    56.909   577.078     0.150
    56.792   581.336     0.150
    57.136   580.227     0.150
    57.203   579.961     0.150
    57.279   580.891     0.150
    57.293   581.352     0.150
    57.440   583.102     0.150
    57.327   584.117     0.150
    57.468   582.398     0.150
    57.468   638.195     0.150
    57.468   582.148     0.150
    57.468   582.922     0.150
    57.543   582.719     0.150
    57.607   582.180     0.150
    57.607   636.375     0.150
    57.496   584.883     0.150
    57.639   583.016     0.150
    57.546   586.375     0.150
    57.671   582.578     0.150
    57.723   583.125     0.150
    57.732   582.977     0.150
    57.815   584.758     0.150
    57.905   584.469     0.150
    57.929   584.547     0.150
    57.929   584.625     0.150
    57.929   584.625     0.150
    57.963   585.188     0.150
    58.043   585.359     0.150
    58.101   589.266     0.150
    58.129   589.531     0.150
    58.133   589.578     0.150
    58.212   588.891     0.150
    58.212   589.016     0.150
    58.079   589.086     0.150
    58.094   591.938     0.150
    58.352   590.883     0.150
    58.535   592.555     0.150
    58.535   592.406     0.150
    58.587   592.719     0.150
    58.587   592.531     0.150
    58.682   593.273     0.150
    58.697   593.766     0.150
    58.697   593.562     0.150
    58.894   590.375     0.150
    58.894   592.680     0.150
    58.894   592.359     0.150
    59.001   592.781     0.150
    59.038   593.281     0.150
    59.038   642.281     0.150
    58.949   594.953     0.150
    58.949   594.758     0.150
    59.230   594.477     0.150
    58.854   593.734     0.150
    59.441   595.375     0.150
    59.561   596.375     0.150
    59.561   644.875     0.150
    59.569   595.477     0.150
    59.701   596.961     0.150
    59.701   596.922     0.150
    59.939   602.375     0.150
    62.489   616.055     0.150
    62.489   656.602     0.150
    62.540   616.031     0.150
    62.540   616.375     0.150
    63.224   620.625     0.150
    63.224   620.875     0.150
    63.384   623.977     0.150
    63.384  2370.125     0.150
    63.384   623.555     0.150
    63.529   623.281     0.150
    63.661   622.781     0.150
    63.680   623.461     0.150
    63.680   623.180     0.150
    63.680  2361.656     0.150
    63.680  2367.656     0.150
    63.680   623.281     0.150
    63.684   623.180     0.150
    63.684  2361.656     0.150
    63.684  2367.648     0.150
    64.063   626.375     0.150
    64.828   636.984     0.150
    65.344   633.375     0.150
    65.023   637.797     0.150
    65.335   638.422     0.150
    65.335   639.062     0.150
    65.468   640.328     0.150
    65.814   642.078     0.150
    66.066   642.172     0.150
    66.519   645.969     0.150
    66.668   648.164     0.150
    66.668   648.266     0.150
    66.668   647.820     0.150
    67.138   646.078     0.150
    66.984   648.156     0.150
    66.984   649.180     0.150
    66.988   648.688     0.150
    67.346   647.875     0.150
    67.346   647.844     0.150
    67.060   649.469     0.150
    67.412   648.516     0.150
    67.412   648.281     0.150
    67.133   650.477     0.150
    67.518   654.234     0.150
    67.505   653.383     0.150
    67.606   652.211     0.150
    67.606   652.773     0.150
    67.668   653.266     0.150
    67.668   653.555     0.150
    67.946   654.758     0.150
    67.946   655.305     0.150
    68.072   657.406     0.150
    68.118   656.766     0.150
    68.205   655.719     0.150
    68.352   658.805     0.150
    68.388   659.938     0.150
    68.447   659.969     0.150
    68.523   658.750     0.150
    68.523   658.023     0.150
    68.543   657.820     0.150
    68.728   661.688     0.150
    68.872   659.484     0.150
    68.932   661.148     0.150
    68.932   662.984     0.150
    68.937   662.062     0.150
    69.238   660.375     0.150
    69.238   660.617     0.150
    69.196   662.398     0.150
    69.206   661.727     0.150
    69.293   663.383     0.150
    69.440   665.711     0.150
    69.446   664.156     0.150
    69.568   666.523     0.150
    69.593   666.406     0.150
    69.597   666.555     0.150
    69.739   666.586     0.150
    69.769   666.102     0.150
    69.779   666.680     0.150
    69.980   667.555     0.150
    70.275   668.898     0.150
    70.275   670.188     0.150
    70.280   669.617     0.150
    70.663   671.820     0.150
    70.951   671.031     0.150
    71.644   673.078     0.150
    71.644   832.375     0.150
    71.644  1263.375     0.150
    71.539   677.219     0.150
    72.233   694.680     0.150
    73.134   684.875     0.150
    73.512   687.898     0.150
    73.512   687.328     0.150
    73.512   688.180     0.150
    73.512   687.711     0.150
    73.674   688.180     0.150
    73.794   689.680     0.150
    73.959   689.680     0.150
    74.018   691.078     0.150
    74.128   688.875     0.150
    74.128   704.180     0.150
    74.128   855.078     0.150
    74.128  1255.977     0.150
    74.187   690.445     0.150
    74.466   690.875     0.150
    74.468   690.875     0.150
    74.549   692.586     0.150
    74.549   692.477     0.150
    74.549    12.500     0.150
    74.549  1548.781     0.150
    74.884   693.297     0.150
    74.884   693.180     0.150
    74.790   695.375     0.150
    74.866   695.977     0.150
    74.866   694.148     0.150
    74.849   698.031     0.150
    74.849   697.805     0.150
    75.245   697.680     0.150
    75.348   698.375     0.150
    75.253   699.281     0.150
    75.439   700.477     0.150
    75.474   699.375     0.150
    75.664   698.016     0.150
    75.664   697.875     0.150
    75.787   701.281     0.150
    75.719   703.461     0.150
    75.719   702.984     0.150
    75.753   702.656     0.150
    75.753   701.172     0.150
    75.753   701.875     0.150
    76.178   703.781     0.150
    76.202   702.180     0.150
    76.198   703.078     0.150
    76.259   703.375     0.150
    76.422   704.477     0.150
    76.486   705.883     0.150
    76.492   704.109     0.150
    76.492   704.602     0.150
    76.317   706.500     0.150
    76.317   705.031     0.150
    76.317   706.234     0.150
    76.538   706.938     0.150
    76.667   705.977     0.150
    76.720   705.875     0.150
    76.748   706.375     0.150
    76.840   707.281     0.150
    76.833   707.672     0.150
    77.364   711.180     0.150
    77.412   711.180     0.150
    77.412   710.375     0.150
    77.637   709.328     0.150
    77.868   713.078     0.150
    77.993   715.156     0.150
    78.125   713.781     0.150
    78.210   714.477     0.150
    78.323   712.781     0.150
    78.323   722.281     0.150
    78.544   713.977     0.150
    78.336   718.641     0.150
    78.336   717.852     0.150
    78.336  1854.125     0.150
    78.336   716.867     0.150
    78.336   718.305     0.150
    78.851   718.477     0.150
    78.928   718.477     0.150
    78.926   718.680     0.150
    79.012   718.680     0.150
    79.428   720.781     0.150
    79.530   721.477     0.150
    79.791   722.352     0.150
    79.819   722.977     0.150
    80.063   723.781     0.150
    80.117   723.680     0.150
    80.117  1320.875     0.150
    80.199   725.969     0.150
    80.199   727.578     0.150
    80.199   725.781     0.150
    80.346   722.977     0.150
    80.346   722.578     0.150
    80.295   726.477     0.150
    80.295   736.781     0.150
    80.281   725.781     0.150
    80.319   726.180     0.150
    80.345   728.680     0.150
    80.496   729.680     0.150
    80.589   728.781     0.150
    80.734   727.977     0.150
    80.829   730.375     0.150
    80.894   728.750     0.150
    80.966   728.781     0.150
    81.325   731.180     0.150
    81.325   917.047     0.150
    81.325  1848.180     0.150
    81.325   731.141     0.150
    81.325   731.180     0.150
    81.325   917.055     0.150
    81.325  1848.180     0.150
    81.591   731.281     0.150
    81.591  1334.875     0.150
    81.599   732.977     0.150
    81.745   732.578     0.150
    81.728   733.781     0.150
    81.728   733.375     0.150
    81.990   734.539     0.150
    81.990   735.375     0.150
    81.995   734.172     0.150
    82.267   735.477     0.150
    82.569   737.977     0.150
    82.575   739.555     0.150
    83.001   737.375     0.150
    83.001  1349.875     0.150
    84.178   744.578     0.150
    84.178  1361.875     0.150
    84.507   747.125     0.150
    84.507   747.477     0.150
    84.507   746.977     0.150
    84.700   749.578     0.150
    84.738   749.875     0.150
    84.810   750.070     0.150
    85.277   750.477     0.150
    85.277  1369.578     0.150
    85.277   750.578     0.150
    85.234   752.617     0.150
    85.234   752.875     0.150
    86.297   753.828     0.150
    86.242   757.078     0.150
    86.267   756.680     0.150
    86.059   757.016     0.150
    86.311   757.578     0.150
    86.341   756.930     0.150
    86.341   757.375     0.150
    86.629   758.875     0.150
    86.690   757.078     0.150
    86.687   759.281     0.150
    86.706   759.375     0.150
    86.731   759.781     0.150
    86.758   759.875     0.150
    86.756   758.047     0.150
    86.756   759.680     0.150
    86.801   760.078     0.150
    86.840   759.875     0.150
    86.997   761.656     0.150
    87.241   757.875     0.150
    87.237   760.766     0.150
    87.237   761.477     0.150
    87.310   762.875     0.150
    87.370   760.781     0.150
    87.370   964.477     0.150
    87.370  1835.281     0.150
    87.370   761.078     0.150
    87.378   761.078     0.150
    87.378   761.375     0.150
    87.378   760.914     0.150
    87.378   760.781     0.150
    87.399   760.898     0.150
    87.437   763.977     0.150
    87.453   763.875     0.150
    87.455   763.375     0.150
    87.550   763.977     0.150
    87.570   763.281     0.150
    87.581   764.977     0.150
    87.573   764.375     0.150
    87.665   763.477     0.150
    87.777   762.867     0.150
    87.678   762.680     0.150
    87.789   765.781     0.150
    87.818   764.578     0.150
    87.828   765.375     0.150
    87.853   764.578     0.150
    87.878   765.578     0.150
    87.893   765.977     0.150
    87.992   765.180     0.150
    88.025   765.875     0.150
    88.100   766.977     0.150
    88.164   765.875     0.150
    88.237   766.680     0.150
    88.282   767.023     0.150
    88.282   972.422     0.150
    88.282   767.281     0.150
    88.304   767.375     0.150
    88.379   767.578     0.150
    88.393   767.281     0.150
    88.484   767.977     0.150
    88.493   767.875     0.150
    88.518   767.781     0.150
    88.664   767.977     0.150
    88.719   767.680     0.150
    88.752   768.875     0.150
    88.763   769.180     0.150
    88.765   768.180     0.150
    88.778   768.375     0.150
    88.817   768.578     0.150
    88.835   769.180     0.150
    88.887   769.180     0.150
    88.946   769.680     0.150
    88.944   769.078     0.150
    89.054   770.680     0.150
    89.074   769.680     0.150
    89.087   770.477     0.150
    89.100   769.578     0.150
    89.097   769.578     0.150
    89.106   769.180     0.150
    89.114   769.281     0.150
    89.200   768.875     0.150
    89.160   770.977     0.150
    88.818   771.523     0.150
    88.818   770.172     0.150
    89.234   771.516     0.150
    89.224   770.375     0.150
    89.374   770.578     0.150
    89.368   771.680     0.150
    89.389   773.578     0.150
    89.430   770.977     0.150
    89.480   772.578     0.150
    89.492   772.180     0.150
    89.612   772.680     0.150
    89.624   771.875     0.150
    89.650   772.977     0.150
    89.650   773.680     0.150
    89.650   773.078     0.150
    89.686   774.281     0.150
    89.660   773.078     0.150
    89.685   772.375     0.150
    89.692   773.688     0.150
    89.746   772.977     0.150
    89.773   773.781     0.150
    89.774   773.477     0.150
    89.828   771.578     0.150
    89.794   773.680     0.150
    89.826   776.477     0.150
    89.895   773.711     0.150
    89.946   773.539     0.150
    89.929   775.180     0.150
    89.988   775.375     0.150
    90.017   773.578     0.150
    90.068   775.477     0.150
    90.125   776.477     0.150
    90.147   776.375     0.150
    90.242   775.180     0.150
    90.241   775.039     0.150
    90.195   776.375     0.150
    90.243   774.188     0.150
    90.238   776.578     0.150
    90.343   775.469     0.150
    90.370   777.078     0.150
    90.421   776.078     0.150
    90.451   777.680     0.150
    90.576   776.477     0.150
    90.615   777.281     0.150
    90.660   776.680     0.150
    90.697   777.188     0.150
    90.739   778.477     0.150
    90.732   778.477     0.150
    90.774   778.055     0.150
    90.839   777.945     0.150
    90.885   778.008     0.150
    90.886   778.477     0.150
    90.912   778.977     0.150
    90.919   779.680     0.150
    90.936   779.477     0.150
    91.084   778.625     0.150
    91.084   779.680     0.150
    91.092   780.375     0.150
    90.839   780.297     0.150
    91.180   779.539     0.150
    91.232   779.930     0.150
    91.293   780.680     0.150
    91.297   780.680     0.150
    91.330   781.680     0.150
    90.994   781.234     0.150
    91.367   781.180     0.150
    91.532   780.781     0.150
    91.640   780.836     0.150
    91.641   780.977     0.150
    91.641   999.367     0.150
    91.641  1822.477     0.150
    91.641   780.977     0.150
    91.641   999.367     0.150
    91.641  1822.477     0.150
    91.708   780.930     0.150
    91.708   781.266     0.150
    91.731   782.875     0.150
    92.511   786.477     0.150
    92.511   785.680     0.150
    92.511   786.031     0.150
    92.531   785.875     0.150
    92.748   787.328     0.150
    92.748  1008.391     0.150
    92.827   786.719     0.150
    92.786   786.961     0.150
    92.806   787.219     0.150
    92.806   787.578     0.150
    92.806   786.625     0.150
    92.949   787.477     0.150
    93.072   787.578     0.150
    93.096   788.281     0.150
    93.226   788.180     0.150
    93.180   789.039     0.150
    93.252   789.375     0.150
    93.252  1012.477     0.150
    93.432   789.781     0.150
    93.432   789.617     0.150
    93.561   789.078     0.150
    93.561   789.078     0.150
    93.561   789.250     0.150
    93.582   790.477     0.150
    93.582  1014.977     0.150
    94.000   794.477     0.150
    94.027   792.617     0.150
    94.190   792.477     0.150
    94.190  1019.078     0.150
    94.260   792.219     0.150
    94.260  1019.258     0.150
    94.199   794.578     0.150
    94.284   794.086     0.150
    94.284   794.781     0.150
    94.380   793.758     0.150
    94.392   795.078     0.150
    94.392  1021.977     0.150
    94.486   793.234     0.150
    94.573   794.328     0.150
    94.573   795.578     0.150
    94.573   795.078     0.150
    94.573  1022.578     0.150
    94.600   795.078     0.150
    94.600  1021.781     0.150
    94.698   798.078     0.150
    94.945   794.898     0.150
    95.047   795.516     0.150
    95.092   798.078     0.150
    95.092  1025.578     0.150
    95.112   796.375     0.150
    95.142  1027.227     0.150
    95.142  1027.078     0.150
    95.248   798.078     0.150
    95.248  1027.875     0.150
    95.411   799.477     0.150
    95.411  1028.680     0.150
    95.411    12.703     0.150
    95.472   799.586     0.150
    95.502   799.891     0.150
    95.502  1029.828     0.150
    95.600   800.977     0.150
    95.622   800.977     0.150
    95.673   800.570     0.150
    95.673  1031.734     0.150
    95.717   800.500     0.150
    95.717  1034.078     0.150
    95.858   799.234     0.150
    95.858  1031.578     0.150
    95.862  1031.680     0.150
    95.902   800.984     0.150
    95.902  1034.852     0.150
    95.963   801.719     0.150
    95.963  1032.359     0.150
    96.075   801.328     0.150
    96.029   801.867     0.150
    96.029  1036.516     0.150
    96.276   801.477     0.150
    96.264   803.281     0.150
    96.283   803.180     0.150
    96.283  1037.531     0.150
    96.362  1036.078     0.150
    96.525   804.078     0.150
    96.525  1035.680     0.150
    96.567   802.906     0.150
    96.567  1037.750     0.150
    96.576   803.867     0.150
    96.576  1040.180     0.150
    96.915  1040.562     0.150
    96.960   805.539     0.150
    96.960  1039.578     0.150
    97.003   805.688     0.150
    97.003   806.461     0.150
    97.003   806.406     0.150
    97.003  1041.680     0.150
    97.085   805.000     0.150
    97.085  1040.547     0.150
    97.122   804.938     0.150
    97.122   805.055     0.150
    97.122   804.641     0.150
    97.100   804.781     0.150
    97.100  1040.281     0.150
    97.100    16.898     0.150
    97.145  1043.594     0.150
    97.257   804.977     0.150
    97.269   806.039     0.150
    97.340   805.734     0.150
    97.340  1040.141     0.150
    97.500   807.352     0.150
    97.500  1044.133     0.150
    97.500  1806.195     0.150
    97.573   809.578     0.150
    97.573    17.703     0.150
    97.729   808.086     0.150
    97.729    16.633     0.150
    97.698   809.375     0.150
    97.698  1046.328     0.150
    97.880   809.102     0.150
    97.919   809.297     0.150
    98.360   811.117     0.150
    98.490   812.641     0.150
    98.576   812.359     0.150
    98.657   813.070     0.150
    98.682   813.836     0.150
    98.682  1053.680     0.150
    98.733   812.680     0.150
    98.733   812.641     0.150
    98.733  1054.234     0.150
    98.733  1803.727     0.150
    98.946   814.500     0.150
    98.950   815.328     0.150
    98.929   814.953     0.150
    98.929  1055.234     0.150
    99.241   814.781     0.150
    99.508   817.672     0.150
    99.513   818.445     0.150
    99.564   816.500     0.150
    99.630   818.156     0.150
    99.630   818.297     0.150
    99.736   817.477     0.150
    99.736  1058.328     0.150
   100.168   819.367     0.150
   100.931   822.984     0.150
   101.419  1948.180     0.150
   102.134   828.156     0.150
   102.340   829.031     0.150
   102.354   829.477     0.150
   102.835   830.961     0.150
   103.365   833.086     0.150
   103.520   833.727     0.150
   103.664   834.664     0.150
   103.965   834.227     0.150
   103.965  1093.875     0.150
   103.965  1788.477     0.150
   103.965   835.484     0.150
   104.018   836.148     0.150
   105.072   841.039     0.150
   105.474   845.180     0.150
   105.474  1098.352     0.150
   105.474  1783.555     0.150
   105.477   845.180     0.150
   105.477  1098.359     0.150
   105.477  1783.547     0.150
   106.901   850.898     0.150
   107.514  1101.109     0.150
   107.842  1776.281     0.150
   107.842   853.031     0.150
   110.010  1106.758     0.150
   110.010  1139.680     0.150
   110.010  1770.656     0.150
   110.010  1781.375     0.150
   117.611  1119.477     0.150
   117.611  1743.320     0.150
   117.611  1747.172     0.150
   117.611  1119.250     0.150
   117.611  1743.320     0.150
   117.611  1747.180     0.150
   122.337  1129.703     0.150
   122.580  1130.422     0.150
   123.106  1131.633     0.150
   123.476  1131.406     0.150
   123.878  1133.188     0.150
   123.912  1132.469     0.150
   123.917  1133.258     0.150
   124.085  1133.656     0.150
   124.125  1133.328     0.150
   124.449  1134.336     0.150
   124.490  1134.469     0.150
   124.597  1133.250     0.150
   124.889  1135.367     0.150
   124.895  1135.375     0.150
   125.021  1134.078     0.150
   125.170  1135.922     0.150
   125.199  1135.906     0.150
   125.393  1136.398     0.150
   125.417  1135.734     0.150
   125.442  1136.484     0.150
   125.442  1136.242     0.150
   125.698  1136.656     0.150
   125.704  1136.812     0.150
   125.716  1136.305     0.150
   125.923  1136.820     0.150
   125.917  1138.180     0.150
   126.347  1137.562     0.150
   126.607  1138.625     0.150
   126.683  1138.617     0.150
   127.153  1139.938     0.150
   127.531  1140.367     0.150
   127.792  1139.680     0.150
   127.792  1139.875     0.150
   128.007  1139.977     0.150
   128.007  1140.711     0.150
   128.271  1140.906     0.150
   128.278  1140.789     0.150
   128.395  1142.234     0.150
   129.473  1143.836     0.150
   129.473  1143.578     0.150
   129.600  1145.227     0.150
   129.600  1145.047     0.150
   129.594  1145.422     0.150
   130.030  1145.375     0.150
   130.578  1145.289     0.150
   130.977  1145.797     0.150
   131.202  1147.734     0.150
   131.528  1148.125     0.150
   131.564  1147.648     0.150
   131.623  1147.836     0.150
   131.659  1147.602     0.150
   131.697  1148.117     0.150
   131.797  1148.711     0.150
   131.823  1147.859     0.150
   131.831  1148.328     0.150
   132.025  1149.023     0.150
   132.365  1148.852     0.150
   132.365  1349.805     0.150
   131.981  1150.203     0.150
   131.981  1352.227     0.150
   131.981  1148.484     0.150
   131.981  1151.602     0.150
   132.439  1148.852     0.150
   132.946  1150.406     0.150
   132.946  1148.297     0.150
   132.946  1150.281     0.150
   132.946  1293.047     0.150
   132.946  1352.625     0.150
   132.946  1740.875     0.150
   133.583  1150.906     0.150
   133.583  1353.953     0.150
   133.381  1151.266     0.150
   134.226  1153.031     0.150
   134.259  1152.422     0.150
   134.459  1154.102     0.150
   134.755  1152.211     0.150
   135.045  1153.672     0.150
   135.045  1154.648     0.150
   135.261  1155.008     0.150
   135.341  1154.688     0.150
   135.341  1155.500     0.150
   136.465  1157.547     0.150
   136.903  1158.797     0.150
   136.975  1159.039     0.150
   136.975  1158.812     0.150
   137.122  1159.367     0.150
   137.209  1159.469     0.150
   137.647  1160.062     0.150
   137.663  1160.375     0.150
   137.841  1160.320     0.150
   137.508  1161.227     0.150
   138.160  1161.242     0.150
   138.347  1161.703     0.150
   138.428  1161.672     0.150
   138.591  1162.414     0.150
   138.635  1162.242     0.150
   138.667  1162.164     0.150
   138.975  1161.883     0.150
   138.975  1161.891     0.150
   139.210  1162.469     0.150
   139.342  1162.242     0.150
   139.343  1162.555     0.150
   139.460  1162.766     0.150
   139.550  1163.336     0.150
   139.551  1163.367     0.150
   139.551  1163.055     0.150
   139.552  1163.680     0.150
   139.618  1163.195     0.150
   139.666  1163.133     0.150
   139.751  1162.820     0.150
   139.776  1163.023     0.150
   139.834  1163.898     0.150
   139.910  1163.727     0.150
   139.953  1164.305     0.150
   139.965  1164.141     0.150
   139.535  1165.438     0.150
   140.531  1165.922     0.150
   140.616  1166.234     0.150
   140.714  1166.250     0.150
   141.167  1168.445     0.150
   141.529  1166.320     0.150
   141.920  1168.859     0.150
   141.536  1168.297     0.150
   141.670  1170.406     0.150
   141.734  1169.047     0.150
   141.778  1169.797     0.150
   142.187  1170.711     0.150
   142.730  1166.727     0.150
   144.062  1166.938     0.150
   144.069  1167.055     0.150
   143.640  1168.297     0.150
   143.640  1173.406     0.150
   144.099  1167.250     0.150
   144.124  1167.234     0.150
   144.143  1167.062     0.150
   144.187  1167.562     0.150
   144.195  1167.352     0.150
   144.194  1167.734     0.150
   144.229  1167.562     0.150
   144.236  1167.461     0.150
   144.294  1167.445     0.150
   144.272  1169.359     0.150
   144.349  1167.664     0.150
   144.397  1168.492     0.150
   144.407  1168.484     0.150
   144.430  1169.266     0.150
   144.430  1168.359     0.150
   144.439  1168.633     0.150
   144.469  1168.664     0.150
   144.539  1168.820     0.150
   144.550  1170.016     0.150
   144.550  1169.172     0.150
   144.613  1169.430     0.150
   144.656  1169.094     0.150
   144.655  1168.852     0.150
   144.624  1171.406     0.150
   144.624  1171.641     0.150
   144.625  1171.109     0.150
   144.625  1171.102     0.150
   144.669  1169.023     0.150
   144.776  1169.977     0.150
   144.776  1169.664     0.150
   144.789  1169.555     0.150
   144.799  1169.688     0.150
   144.828  1170.617     0.150
   144.944  1169.883     0.150
   144.973  1170.141     0.150
   144.985  1170.578     0.150
   144.985  1170.438     0.150
   144.994  1170.469     0.150
   145.040  1170.500     0.150
   145.046  1170.711     0.150
   145.046  1169.781     0.150
   145.095  1171.125     0.150
   145.099  1170.273     0.150
   145.092  1171.039     0.150
   145.132  1170.656     0.150
   145.161  1170.875     0.150
   145.169  1170.328     0.150
   145.168  1170.852     0.150
   145.168  1171.102     0.150
   145.225  1171.000     0.150
   145.225  1170.500     0.150
   145.249  1171.406     0.150
   145.291  1170.758     0.150
   145.304  1171.641     0.150
   145.319  1171.648     0.150
   145.360  1171.625     0.150
   145.360  1171.758     0.150
   145.360  1171.922     0.150
   145.405  1171.758     0.150
   144.966  1173.648     0.150
   144.966  1174.086     0.150
   144.966  1174.305     0.150
   145.437  1171.922     0.150
   145.437  1171.742     0.150
   145.001  1174.305     0.150
   145.001  1173.867     0.150
   145.462  1171.555     0.150
   145.450  1172.977     0.150
   145.450  1173.234     0.150
   145.485  1172.398     0.150
   145.495  1172.109     0.150
   145.508  1172.281     0.150
   145.569  1172.125     0.150
   145.570  1172.461     0.150
   145.593  1172.211     0.150
   145.658  1172.516     0.150
   145.688  1172.625     0.150
   145.688  1172.508     0.150
   145.745  1173.039     0.150
   145.747  1173.180     0.150
   145.757  1172.867     0.150
   145.811  1172.883     0.150
   145.826  1172.820     0.150
   145.825  1172.891     0.150
   145.834  1173.086     0.150
   145.833  1173.375     0.150
   145.874  1172.758     0.150
   145.874  1173.438     0.150
   145.500  1175.578     0.150
   145.500  1175.141     0.150
   145.943  1173.680     0.150
   145.969  1173.852     0.150
   146.009  1173.758     0.150
   146.057  1173.211     0.150
   146.097  1174.188     0.150
   146.097  1173.828     0.150
   146.149  1174.047     0.150
   146.181  1173.734     0.150
   146.181  1173.891     0.150
   146.180  1174.438     0.150
   146.206  1174.172     0.150
   145.787  1177.188     0.150
   146.236  1174.547     0.150
   146.304  1174.453     0.150
   146.328  1174.492     0.150
   146.363  1174.219     0.150
   146.363  1174.727     0.150
   146.432  1175.203     0.150
   146.451  1174.820     0.150
   146.467  1175.055     0.150
   146.473  1174.961     0.150
   146.488  1175.008     0.150
   146.499  1174.594     0.150
   146.524  1175.266     0.150
   146.554  1174.555     0.150
   146.554  1175.266     0.150
   146.586  1176.281     0.150
   146.608  1176.219     0.150
   146.608  1175.977     0.150
   146.619  1175.555     0.150
   146.645  1175.445     0.150
   146.678  1175.906     0.150
   146.687  1175.016     0.150
   146.697  1175.945     0.150
   146.705  1175.922     0.150
   146.705  1174.562     0.150
   146.709  1177.672     0.150
   146.709  1175.656     0.150
   146.747  1176.117     0.150
   146.747  1176.016     0.150
   146.775  1175.664     0.150
   146.851  1176.438     0.150
   146.855  1176.219     0.150
   146.873  1174.328     0.150
   146.889  1176.391     0.150
   146.908  1176.398     0.150
   146.905  1176.305     0.150
   146.939  1176.852     0.150
   146.946  1174.945     0.150
   146.946  1176.547     0.150
   146.981  1176.383     0.150
   147.014  1176.445     0.150
   147.013  1176.539     0.150
   147.042  1175.367     0.150
   147.042  1177.031     0.150
   147.065  1176.422     0.150
   147.114  1176.383     0.150
   147.119  1177.055     0.150
   147.184  1174.758     0.150
   147.183  1175.078     0.150
   147.244  1177.227     0.150
   147.255  1177.328     0.150
   147.247  1177.656     0.150
   147.358  1177.750     0.150
   147.388  1177.906     0.150
   147.397  1177.648     0.150
   147.397  1177.883     0.150
   147.419  1177.344     0.150
   146.987  1180.734     0.150
   147.436  1177.930     0.150
   147.436  1177.656     0.150
   147.433  1178.195     0.150
   147.457  1177.508     0.150
   147.481  1178.258     0.150
   147.494  1176.445     0.150
   147.562  1176.789     0.150
   147.562  1178.781     0.150
   147.607  1178.328     0.150
   147.601  1178.289     0.150
   147.631  1178.680     0.150
   147.661  1178.359     0.150
   147.678  1178.320     0.150
   147.678  1178.750     0.150
   147.715  1177.898     0.150
   147.715  1178.266     0.150
   147.723  1178.719     0.150
   147.734  1178.484     0.150
   147.327  1181.125     0.150
   147.783  1178.516     0.150
   147.899  1178.695     0.150
   147.933  1179.586     0.150
   147.981  1179.430     0.150
   147.985  1179.461     0.150
   147.987  1179.422     0.150
   147.982  1180.398     0.150
   147.982  1179.508     0.150
   147.992  1176.195     0.150
   147.979  1180.734     0.150
   147.979  1180.133     0.150
   148.049  1179.516     0.150
   148.070  1179.102     0.150
   148.096  1179.945     0.150
   148.099  1179.148     0.150
   148.189  1180.727     0.150
   148.254  1179.906     0.150
   148.256  1180.352     0.150
   148.256  1180.234     0.150
   148.293  1179.031     0.150
   148.293  1182.078     0.150
   148.382  1180.586     0.150
   148.407  1180.609     0.150
   148.436  1181.070     0.150
   148.446  1180.109     0.150
   148.473  1181.602     0.150
   148.656  1180.586     0.150
   148.617  1180.891     0.150
   148.617  1183.977     0.150
   148.685  1181.734     0.150
   148.694  1180.922     0.150
   148.694  1181.211     0.150
   148.738  1181.211     0.150
   148.768  1181.797     0.150
   148.768  1182.016     0.150
   148.782  1181.469     0.150
   148.787  1181.867     0.150
   148.411  1181.836     0.150
   148.879  1182.070     0.150
   148.940  1181.727     0.150
   148.952  1181.969     0.150
   148.962  1183.195     0.150
   148.969  1177.336     0.150
   148.969  1183.055     0.150
   148.995  1182.594     0.150
   149.086  1184.117     0.150
   149.086  1183.258     0.150
   149.125  1182.508     0.150
   149.151  1182.117     0.150
   149.204  1183.047     0.150
   149.222  1182.391     0.150
   149.239  1182.734     0.150
   149.349  1183.289     0.150
   149.395  1183.359     0.150
   149.437  1183.086     0.150
   149.480  1182.609     0.150
   149.480  1183.289     0.150
   149.501  1183.539     0.150
   149.549  1183.555     0.150
   149.549  1183.742     0.150
   149.574  1183.922     0.150
   149.636  1183.820     0.150
   149.235  1186.484     0.150
   149.656  1184.586     0.150
   149.688  1183.250     0.150
   149.709  1184.016     0.150
   149.741  1184.055     0.150
   149.741  1184.219     0.150
   149.768  1183.820     0.150
   149.771  1183.859     0.150
   149.783  1183.906     0.150
   149.809  1184.383     0.150
   149.856  1184.055     0.150
   149.422  1188.266     0.150
   149.931  1184.742     0.150
   149.980  1184.328     0.150
   150.027  1184.883     0.150
   150.112  1184.945     0.150
   149.681  1187.375     0.150
   150.154  1185.047     0.150
   150.177  1185.117     0.150
   150.177  1185.211     0.150
   149.734  1188.484     0.150
   149.734  1183.945     0.150
   150.181  1184.688     0.150
   150.135  1180.031     0.150
   150.215  1185.141     0.150
   150.215  1185.539     0.150
   150.234  1185.141     0.150
   150.260  1184.852     0.150
   150.314  1185.867     0.150
   150.326  1185.648     0.150
   150.355  1185.859     0.150
   150.390  1185.461     0.150
   150.390  1186.094     0.150
   150.410  1186.109     0.150
   150.479  1185.602     0.150
   150.479  1185.914     0.150
   150.514  1186.234     0.150
   150.551  1180.375     0.150
   150.551  1185.672     0.150
   150.187  1187.609     0.150
   150.689  1186.609     0.150
   150.758  1186.789     0.150
   150.758  1187.023     0.150
   150.760  1186.688     0.150
   150.415  1189.367     0.150
   150.862  1187.000     0.150
   150.867  1187.266     0.150
   150.950  1187.289     0.150
   150.953  1187.969     0.150
   150.953  1187.766     0.150
   150.982  1186.758     0.150
   150.998  1187.570     0.150
   150.999  1187.570     0.150
   150.587  1190.258     0.150
   151.042  1187.047     0.150
   150.999  1188.867     0.150
   151.132  1187.539     0.150
   151.140  1188.281     0.150
   151.184  1187.758     0.150
   150.750  1190.039     0.150
   151.207  1187.672     0.150
   151.207  1187.812     0.150
   151.316  1187.914     0.150
   151.368  1188.227     0.150
   151.467  1188.391     0.150
   151.467  1188.734     0.150
   151.527  1188.773     0.150
   151.530  1188.359     0.150
   151.608  1181.328     0.150
   151.608  1188.859     0.150
   151.608  1188.695     0.150
   151.610  1188.336     0.150
   151.610  1188.844     0.150
   151.666  1189.180     0.150
   151.730  1189.461     0.150
   151.751  1188.938     0.150
   151.770  1189.031     0.150
   151.808  1183.070     0.150
   151.808  1189.117     0.150
   151.364  1184.391     0.150
   151.364  1189.945     0.150
   151.364  1191.148     0.150
   151.823  1182.977     0.150
   151.823  1189.188     0.150
   151.863  1189.336     0.150
   151.863  1189.422     0.150
   151.933  1189.945     0.150
   151.930  1189.695     0.150
   152.037  1189.641     0.150
   152.088  1189.672     0.150
   152.088  1189.938     0.150
   152.090  1189.930     0.150
   152.104  1184.180     0.150
   152.104  1190.586     0.150
   152.119  1189.992     0.150
   152.186  1189.844     0.150
   152.245  1190.320     0.150
   152.256  1190.641     0.150
   152.263  1184.008     0.150
   152.289  1190.578     0.150
   152.292  1190.461     0.150
   152.299  1190.258     0.150
   152.452  1184.516     0.150
   152.452  1190.617     0.150
   152.501  1191.219     0.150
   152.558  1190.883     0.150
   152.579  1191.211     0.150
   152.615  1191.594     0.150
   152.194  1193.797     0.150
   152.642  1191.312     0.150
   152.654  1191.125     0.150
   152.700  1192.062     0.150
   152.705  1184.836     0.150
   152.705  1191.430     0.150
   152.705  1191.586     0.150
   152.731  1191.508     0.150
   152.796  1191.875     0.150
   152.891  1191.461     0.150
   152.907  1192.094     0.150
   152.912  1191.836     0.150
   152.991  1184.961     0.150
   152.991  1192.359     0.150
   152.991  1192.125     0.150
   153.048  1192.562     0.150
   152.648  1185.352     0.150
   152.648  1193.688     0.150
   152.648  1194.250     0.150
   152.663  1186.672     0.150
   152.663  1194.656     0.150
   153.136  1192.461     0.150
   153.212  1193.438     0.150
   153.253  1193.227     0.150
   153.265  1192.469     0.150
   153.268  1192.711     0.150
   153.276  1193.305     0.150
   153.291  1192.977     0.150
   153.344  1192.930     0.150
   153.429  1193.891     0.150
   153.521  1193.305     0.150
   153.556  1192.547     0.150
   153.556  1193.234     0.150
   153.597  1193.758     0.150
   153.664  1193.672     0.150
   153.256  1185.922     0.150
   153.256  1195.867     0.150
   153.710  1194.273     0.150
   153.731  1193.914     0.150
   153.745  1193.984     0.150
   153.745  1205.000     0.150
   153.815  1205.211     0.150
   153.852  1205.609     0.150
   153.925  1206.516     0.150
   153.942  1205.750     0.150
   153.955  1205.867     0.150
   153.996  1206.734     0.150
   154.051  1206.461     0.150
   154.122  1206.797     0.150
   154.065  1188.758     0.150
   154.170  1207.430     0.150
   154.368  1208.172     0.150
   154.383  1194.852     0.150
   154.383  1208.477     0.150
   154.383  1207.734     0.150
   154.453  1207.727     0.150
   154.453  1208.750     0.150
   154.466  1209.227     0.150
   154.495  1208.234     0.150
   154.495  1208.805     0.150
   154.781  1210.930     0.150
   154.781  1210.234     0.150
   154.816  1209.938     0.150
   155.047  1210.484     0.150
   155.061  1210.859     0.150
   155.128  1211.055     0.150
   155.148  1211.656     0.150
   155.321  1212.117     0.150
   155.341  1211.922     0.150
   155.706  1214.016     0.150
   155.914  1215.477     0.150
   155.914  1214.406     0.150
   155.729  1191.203     0.150
   155.729  1189.906     0.150
   155.729  1192.070     0.150
   156.203  1216.047     0.150
   156.379  1217.195     0.150
   156.392  1216.984     0.150
   156.750  1219.359     0.150
   156.750  1218.484     0.150
   156.756  1217.578     0.150
   157.085  1218.578     0.150
   157.295  1220.672     0.150
   157.535  1221.430     0.150
   157.869  1222.773     0.150
   158.193  1224.430     0.150
   158.472  1225.914     0.150
   158.655  1226.820     0.150
   158.982  1227.898     0.150
   159.127  1228.078     0.150
   159.424  1229.484     0.150
   159.424  1228.656     0.150
   159.590  1229.648     0.150
   159.913  1231.969     0.150
   160.128  1232.898     0.150
   160.248  1235.602     0.150
   168.194  1269.109     0.150
   168.145  1269.586     0.150
   168.860  1271.234     0.150
   171.628  1203.859     0.150
   171.628  1206.211     0.150
   176.312  1306.227     0.150
     0.643    12.299     0.150
     0.643    20.799     0.150
     1.029    18.299     0.150
     1.029    31.197     0.150
     1.267    22.023     0.150
     1.267    38.674     0.150
     1.267    39.299     0.150
     1.794    29.898     0.150
     1.736    28.998     0.150
     1.736    49.299     0.150
     2.005    33.098     0.150
     2.005    57.098     0.150
     2.166    33.799     0.150
     2.166    58.799     0.150
     2.358    37.299     0.150
     2.358    64.498     0.150
     3.095   103.998     0.150
     3.457    53.799     0.150
     3.457    91.398     0.150
     3.527    53.898     0.150
     3.527    93.799     0.150
     3.492    51.598     0.150
     3.492    89.697     0.150
     3.727    57.598     0.150
     4.120    63.299     0.150
     4.145    61.098     0.150
     5.368    79.898     0.150
     5.405    78.299     0.150
     5.807    85.299     0.150
     7.101   100.697     0.150
     7.101   102.799     0.150
     7.796   113.299     0.150
     7.880   114.398     0.150
     8.136   117.998     0.150
     8.652   121.697     0.150
     9.812   139.398     0.150
    10.700   150.598     0.150
    11.701   163.299     0.150
    13.001   183.117     0.150
    13.140   179.549     0.150
    13.287   180.148     0.150
    13.293   186.998     0.150
    13.509   188.498     0.150
    15.097   209.809     0.150
    15.265   214.498     0.150
    16.188   223.598     0.150
    16.426   223.787     0.150
    16.609   231.098     0.150
    17.084   236.898     0.150
    17.146   233.219     0.150
    17.158   236.947     0.150
    17.158   235.998     0.150
    17.365   234.578     0.150
    18.097   249.197     0.150
    17.995   248.059     0.150
    18.363   252.258     0.150
    19.795   265.398     0.150
    20.539   275.998     0.150
    22.631   296.258     0.150
    22.674   299.719     0.150
    24.224   313.078     0.150
    25.619   322.518     0.150
    27.410   337.998     0.150
    27.748   339.729     0.150
    29.024   356.607     0.150
    29.037   355.973     0.150
    29.037   544.174     0.150
    29.037   356.867     0.150
    29.048   356.828     0.150
    29.221   358.617     0.150
    30.065   366.938     0.150
    30.153   366.617     0.150
    30.153   366.998     0.150
    30.153   546.648     0.150
    34.617   405.998     0.150
    35.986   416.828     0.150
    36.566   423.068     0.150
    39.845   450.668     0.150
    40.018   452.123     0.150
    40.018   452.498     0.150
    45.397   495.447     0.150
    47.081   510.379     0.150
    48.730   520.098     0.150
    49.194   521.695     0.150
    54.402   562.299     0.150
    55.277   568.799     0.150
    55.535   568.459     0.150
    55.535   629.639     0.150
    56.607   574.648     0.150
    56.607   575.918     0.150
    58.298   591.848     0.150
    58.766   590.379     0.150
    58.766   590.023     0.150
    63.379   622.008     0.150
    64.439   628.229     0.150
    64.439   627.598     0.150
    64.439   627.959     0.150
    64.464   629.023     0.150
    68.295   654.408     0.150
    69.140   663.258     0.150
    70.217   666.588     0.150
    75.047   697.973     0.150
    75.047   698.229     0.150
    75.466   696.598     0.150
    75.909   699.709     0.150
    76.123   705.719     0.150
    77.344   708.674     0.150
    82.450   737.148     0.150
    82.450   735.738     0.150
    88.427   767.049     0.150
    88.632   769.188     0.150
    92.595   785.473     0.150
    94.414   792.898     0.150
   129.210  1143.848     0.150
   132.750  1150.447     0.150
   144.181  1169.873     0.150
   145.916  1176.469     0.150
     0.576    11.773     0.150
     0.576    20.273     0.150
     0.747    13.176     0.150
     0.984    17.375     0.150
     1.201    21.449     0.150
     1.201    37.000     0.150
     1.201    21.273     0.150
     1.415    22.176     0.150
     1.415    38.074     0.150
     1.823    29.176     0.150
     1.960    32.273     0.150
     1.960    56.773     0.150
     1.967    31.176     0.150
     3.057    47.074     0.150
     3.242    47.574     0.150
     3.432    52.375     0.150
     3.467    51.035     0.150
     3.467    51.375     0.150
     3.467    50.574     0.150
     3.467    87.773     0.150
     3.488    51.086     0.150
     3.488    53.273     0.150
     3.488    52.574     0.150
     3.488    93.074     0.150
     3.690    57.176     0.150
     4.094    62.074     0.150
     4.400    66.477     0.150
     4.428    66.773     0.150
     4.737    68.875     0.150
     4.737   119.477     0.150
     4.900    69.477     0.150
     5.346    75.574     0.150
     5.346   133.605     0.150
     5.346    78.477     0.150
     5.346    77.074     0.150
     5.406    80.574     0.150
     5.406    79.773     0.150
     5.748    84.477     0.150
     6.370    89.477     0.150
     6.513    92.676     0.150
     6.695    95.773     0.150
     7.082   101.164     0.150
     7.082   101.574     0.150
     7.082   101.875     0.150
     7.145   107.375     0.150
     7.745   112.176     0.150
     8.636   120.273     0.150
     8.872   122.875     0.150
     9.087   127.273     0.150
     9.794   138.074     0.150
    10.682   150.977     0.150
    10.682   150.273     0.150
    10.908   152.953     0.150
    11.496   159.285     0.150
    11.678   160.074     0.150
    13.115   179.645     0.150
    13.115   178.875     0.150
    13.258   186.977     0.150
    14.545   199.684     0.150
    15.211   212.477     0.150
    16.235   221.445     0.150
    16.235   222.875     0.150
    16.371   224.895     0.150
    16.371   227.676     0.150
    16.594   225.934     0.150
    16.595   231.926     0.150
    16.595   418.676     0.150
    17.033   233.477     0.150
    17.099   233.164     0.150
    17.099   233.375     0.150
    17.142   232.625     0.150
    17.142   236.074     0.150
    17.142   232.273     0.150
    18.046   245.875     0.150
    18.025   244.336     0.150
    18.025   246.176     0.150
    18.394   248.945     0.150
    18.394   251.574     0.150
    19.754   265.375     0.150
    19.754   263.176     0.150
    20.502   272.676     0.150
    20.768   278.074     0.150
    21.467   282.375     0.150
    21.662   287.273     0.150
    22.632   294.914     0.150
    22.632   296.875     0.150
    22.723   297.703     0.150
    24.215   310.254     0.150
    24.215   312.176     0.150
    25.483   322.977     0.150
    25.584   320.746     0.150
    25.584   324.176     0.150
    26.523   334.074     0.150
    27.054   334.523     0.150
    27.357   337.426     0.150
    27.357   539.426     0.150
    27.357   336.754     0.150
    27.695   338.844     0.150
    28.687   348.406     0.150
    29.030   353.945     0.150
    29.044   355.676     0.150
    29.044   543.199     0.150
    29.044   353.785     0.150
    29.050   355.316     0.150
    29.050   356.074     0.150
    29.054   355.746     0.150
    29.227   357.047     0.150
    30.099   367.273     0.150
    30.168   365.863     0.150
    30.168   365.926     0.150
    30.168   546.824     0.150
    30.168   366.105     0.150
    33.564   396.477     0.150
    33.725   393.656     0.150
    33.731   397.977     0.150
    33.922   399.676     0.150
    34.290   397.023     0.150
    34.889   403.684     0.150
    36.362   415.445     0.150
    36.595   419.914     0.150
    36.595   422.176     0.150
    36.820   424.676     0.150
    37.496   430.676     0.150
    37.665   431.875     0.150
    39.695   447.422     0.150
    39.695   446.746     0.150
    39.846   449.375     0.150
    39.846   446.875     0.150
    39.846   449.977     0.150
    40.041   451.773     0.150
    40.041   451.305     0.150
    40.363   450.227     0.150
    42.754   474.773     0.150
    43.000   476.273     0.150
    47.521   508.875     0.150
    49.126   519.312     0.150
    55.406   567.094     0.150
    55.472   567.895     0.150
    55.472   628.621     0.150
    55.472   862.215     0.150
    55.472   566.594     0.150
    55.500   567.496     0.150
    56.539   574.926     0.150
    58.716   589.137     0.150
    58.716   589.477     0.150
    58.716   589.137     0.150
    58.833   590.656     0.150
    63.147   618.887     0.150
    63.329   621.344     0.150
    64.384   626.914     0.150
    64.384   626.914     0.150
    64.433   630.523     0.150
    68.247   652.754     0.150
    70.175   664.906     0.150
    71.885   672.727     0.150
    71.887   676.449     0.150
    75.104   697.426     0.150
    75.420   695.785     0.150
    80.671   723.844     0.150
    82.116   734.156     0.150
    82.427   736.477     0.150
    82.427   734.406     0.150
    86.382   753.586     0.150
    88.393   765.449     0.150
    90.272   775.574     0.150
    90.289   775.516     0.150
    92.552   784.008     0.150
   129.149  1143.477     0.150
   132.685  1149.629     0.150
   144.122  1169.523     0.150
   145.977  1176.523     0.150
   150.637  1186.168     0.150
     0.417     7.607     0.150
     0.417    14.408     0.150
     0.417     7.832     0.150
     0.417    14.258     0.150
     0.634    12.309     0.150
     0.693    23.408     0.150
     0.881    16.309     0.150
     0.881    29.107     0.150
     0.972    18.107     0.150
     2.142    36.207     0.150
     2.580    42.707     0.150
     2.663    45.408     0.150
     2.822    46.848     0.150
     2.822    45.408     0.150
     4.084    64.408     0.150
     6.451    96.928     0.150
    22.213   298.018     0.150
    28.685   357.678     0.150
    28.704   358.617     0.150
    28.704   358.008     0.150
    28.714   358.309     0.150
    29.946   370.439     0.150
    39.933   455.518     0.150
    39.933   455.158     0.150
    47.958   520.309     0.150
    53.945   564.908     0.150
    55.664   575.438     0.150
    58.351   593.848     0.150
    58.351   594.232     0.150
    62.918   625.191     0.150
    69.990   669.697     0.150
     0.975    15.745     0.150
     1.415    23.344     0.150
     1.415    23.169     0.150
     1.415    42.144     0.150
     1.460    23.544     0.150
     1.611    24.844     0.150
     2.182    33.844     0.150
     2.667    39.245     0.150
     3.075    46.444     0.150
     3.428    49.844     0.150
     3.705    55.245     0.150
     3.649    53.115     0.150
     3.649    92.684     0.150
     3.649    53.544     0.150
     3.649    52.844     0.150
     4.067    59.944     0.150
     4.626    68.444     0.150
     5.314    77.644     0.150
     5.304    74.434     0.150
     5.304    75.044     0.150
     5.304    75.944     0.150
     5.463    80.844     0.150
     5.862    85.344     0.150
     6.164    90.644     0.150
     6.697    95.544     0.150
     7.251   103.084     0.150
     7.251   182.574     0.150
     7.251   104.245     0.150
     7.251   103.444     0.150
     7.328   108.944     0.150
     7.823   113.245     0.150
     8.291   118.844     0.150
     8.308   119.344     0.150
     8.308   120.544     0.150
     8.573   118.844     0.150
     9.157   133.044     0.150
     9.268   133.844     0.150
     9.500   131.344     0.150
    10.045   140.534     0.150
    10.045   140.944     0.150
     9.961   140.144     0.150
    10.109   140.404     0.150
    10.109   139.344     0.150
    10.192   143.294     0.150
    10.685   149.334     0.150
    10.849   152.745     0.150
    10.849   151.644     0.150
    11.637   158.644     0.150
    11.704   165.034     0.150
    11.704   167.444     0.150
    13.082   178.615     0.150
    13.082   178.344     0.150
    13.170   184.274     0.150
    13.170   185.214     0.150
    13.254   180.764     0.150
    13.253   180.844     0.150
    13.473   189.644     0.150
    13.462   189.544     0.150
    13.739   191.444     0.150
    13.828   196.745     0.150
    14.593   200.264     0.150
    14.741   200.745     0.150
    14.710   200.444     0.150
    15.876   222.444     0.150
    15.822   221.344     0.150
    16.184   222.865     0.150
    16.184   221.995     0.150
    16.184   223.044     0.150
    16.450   224.464     0.150
    16.599   229.674     0.150
    16.599   230.044     0.150
    16.811   231.054     0.150
    16.811   231.644     0.150
    17.259   237.844     0.150
    17.320   236.734     0.150
    17.320   238.544     0.150
    17.320   239.245     0.150
    17.304   235.804     0.150
    17.304   237.745     0.150
    17.304   237.644     0.150
    17.528   238.875     0.150
    18.013   242.404     0.150
    18.013   244.144     0.150
    18.042   246.064     0.150
    18.042   248.944     0.150
    18.042   247.011     0.150
    18.042   448.078     0.150
    18.523   249.544     0.150
    18.408   251.554     0.150
    18.408   252.644     0.150
    19.103   260.844     0.150
    19.900   265.434     0.150
    19.900   267.144     0.150
    19.967   267.444     0.150
    19.967   267.245     0.150
    20.708   277.444     0.150
    20.852   279.620     0.150
    20.852   278.924     0.150
    21.629   288.164     0.150
    21.629   287.944     0.150
    21.855   288.245     0.150
    22.251   292.604     0.150
    22.251   293.444     0.150
    22.251   290.344     0.150
    22.856   296.544     0.150
    22.658   299.264     0.150
    22.658   297.724     0.150
    22.748   298.615     0.150
    22.748   297.365     0.150
    22.748   300.044     0.150
    23.189   299.924     0.150
    23.189   302.044     0.150
    23.185   300.544     0.150
    23.507   302.745     0.150
    23.955   308.375     0.150
    24.056   307.014     0.150
    24.221   310.334     0.150
    24.221   310.745     0.150
    24.359   314.789     0.150
    24.359   313.104     0.150
    24.359   314.944     0.150
    24.302   315.064     0.150
    24.302   315.245     0.150
    25.348   320.644     0.150
    25.382   324.064     0.150
    25.382   323.944     0.150
    25.629   324.514     0.150
    25.629   325.344     0.150
    25.563   326.115     0.150
    25.563   327.344     0.150
    26.173   326.745     0.150
    26.563   334.714     0.150
    26.563   335.044     0.150
    26.590   334.719     0.150
    26.590   334.505     0.150
    26.590   335.745     0.150
    26.590   334.289     0.150
    26.590   606.149     0.150
    26.590   335.269     0.150
    27.041   338.844     0.150
    27.066   337.644     0.150
    27.137   340.564     0.150
    27.439   338.084     0.150
    27.439   337.745     0.150
    27.439   540.078     0.150
    27.778   340.224     0.150
    27.778   340.944     0.150
    28.784   350.474     0.150
    29.313   354.554     0.150
    29.130   355.534     0.150
    29.141   356.904     0.150
    29.141   357.219     0.150
    29.141   543.644     0.150
    29.148   357.484     0.150
    29.152   356.854     0.150
    29.325   358.554     0.150
    30.165   368.444     0.150
    30.165   368.574     0.150
    30.101   366.589     0.150
    30.101   365.764     0.150
    30.101   367.444     0.150
    30.239   366.854     0.150
    30.239   367.570     0.150
    30.239   366.995     0.150
    30.277   368.344     0.150
    31.648   377.544     0.150
    33.669   394.794     0.150
    33.614   397.544     0.150
    33.834   399.245     0.150
    33.925   396.354     0.150
    33.761   398.745     0.150
    34.026   401.039     0.150
    34.026   400.844     0.150
    34.076   403.557     0.150
    34.076   403.115     0.150
    34.273   399.245     0.150
    34.272   398.324     0.150
    34.272   399.344     0.150
    34.254   400.745     0.150
    34.490   401.204     0.150
    34.490   402.044     0.150
    34.672   401.844     0.150
    36.419   417.054     0.150
    36.419   418.271     0.150
    36.467   418.344     0.150
    36.467   758.844     0.150
    36.618   422.339     0.150
    36.618   422.044     0.150
    36.618   422.844     0.150
    36.863   425.444     0.150
    37.687   430.875     0.150
    37.687   566.284     0.150
    37.687   776.664     0.150
    37.560   432.444     0.150
    37.789   433.539     0.150
    38.156   432.304     0.150
    38.156   432.505     0.150
    38.820   440.044     0.150
    38.948   443.014     0.150
    39.472   442.344     0.150
    39.745   444.944     0.150
    39.920   447.044     0.150
    39.863   448.784     0.150
    39.863   450.245     0.150
    39.863   450.644     0.150
    39.863   448.644     0.150
    39.863   449.014     0.150
    39.863    13.420     0.150
    39.962   450.594     0.150
    39.962   453.144     0.150
    39.962   451.704     0.150
    39.962    13.740     0.150
    39.962    18.930     0.150
    39.980   452.539     0.150
    39.980   454.044     0.150
    40.085   452.469     0.150
    40.085   451.854     0.150
    40.085   452.644     0.150
    40.404   450.414     0.150
    40.404   452.444     0.150
    40.427   450.984     0.150
    40.427   451.990     0.150
    40.304   455.844     0.150
    40.712   453.245     0.150
    41.015   455.344     0.150
    41.026   456.044     0.150
    41.071   456.044     0.150
    40.932   459.844     0.150
    41.195   457.344     0.150
    41.251   458.745     0.150
    41.251   828.944     0.150
    41.466   462.944     0.150
    41.753   461.344     0.150
    41.874   462.044     0.150
    42.088   464.344     0.150
    42.478   467.344     0.150
    42.672   471.344     0.150
    42.671   469.245     0.150
    42.774   475.089     0.150
    42.774   475.745     0.150
    43.055   477.365     0.150
    43.961   484.245     0.150
    44.077   485.144     0.150
    45.046   488.245     0.150
    45.414   491.745     0.150
    45.499   495.471     0.150
    45.499   494.324     0.150
    45.499   496.745     0.150
    45.777   494.344     0.150
    45.777   594.844     0.150
    45.777   823.545     0.150
    45.777   893.444     0.150
    45.777  1086.545     0.150
    45.623   497.444     0.150
    45.677   497.501     0.150
    45.677   496.005     0.150
    45.677   497.745     0.150
    46.872   502.884     0.150
    47.014   509.245     0.150
    47.147   507.214     0.150
    47.147   510.444     0.150
    47.147   510.094     0.150
    47.396   507.604     0.150
    47.335   511.044     0.150
    47.392   510.811     0.150
    47.392   509.664     0.150
    47.392   511.444     0.150
    47.415   510.292     0.150
    47.415   510.144     0.150
    47.637   508.844     0.150
    47.637   832.045     0.150
    47.637   921.045     0.150
    47.637  1098.045     0.150
    48.190   513.584     0.150
    48.190   513.745     0.150
    48.471   517.745     0.150
    48.471   934.245     0.150
    48.471  1137.245     0.150
    48.569   514.304     0.150
    48.569   517.245     0.150
    48.569   516.064     0.150
    48.591   516.844     0.150
    48.591   835.344     0.150
    48.668   516.844     0.150
    48.668   934.745     0.150
    48.820   522.044     0.150
    48.811   517.894     0.150
    48.811   518.245     0.150
    48.906   518.734     0.150
    48.906   518.601     0.150
    48.901   519.734     0.150
    49.325   522.464     0.150
    49.325   522.444     0.150
    49.371   522.654     0.150
    50.928   536.344     0.150
    50.928   539.540     0.150
    50.928   539.394     0.150
    50.928    12.500     0.150
    50.928    19.160     0.150
    51.129   537.594     0.150
    51.129   536.819     0.150
    51.923   540.444     0.150
    52.286   544.634     0.150
    52.286   545.414     0.150
    52.286   544.794     0.150
    52.286    12.800     0.150
    52.286    18.220     0.150
    52.350   545.044     0.150
    52.350   985.045     0.150
    53.214   550.184     0.150
    53.214   549.505     0.150
    53.215   549.569     0.150
    53.215   854.141     0.150
    53.215   550.904     0.150
    54.268   557.844     0.150
    54.430   560.344     0.150
    54.430   860.745     0.150
    54.430  1011.045     0.150
    55.165   565.274     0.150
    55.269   564.444     0.150
    55.269  1021.944     0.150
    55.309   570.929     0.150
    55.405   567.414     0.150
    55.405   568.328     0.150
    55.479   572.194     0.150
    55.567   566.745     0.150
    55.611   568.074     0.150
    55.611   568.584     0.150
    55.611   628.935     0.150
    55.611   864.796     0.150
    55.641   568.865     0.150
    55.641   569.295     0.150
    55.641   569.745     0.150
    55.641   569.125     0.150
    55.882   574.789     0.150
    55.989   574.769     0.150
    55.989  1036.545     0.150
    56.273   572.514     0.150
    56.273   572.944     0.150
    56.273   699.745     0.150
    56.273  1042.745     0.150
    56.273  1269.245     0.150
    56.273   573.394     0.150
    56.449   578.799     0.150
    56.486   580.049     0.150
    56.486  1046.591     0.150
    56.570   575.834     0.150
    56.603   574.944     0.150
    56.603  1040.245     0.150
    56.532   575.014     0.150
    56.736   575.854     0.150
    56.736   577.745     0.150
    56.736   575.944     0.150
    56.842   581.506     0.150
    56.842  1054.697     0.150
    56.786   578.384     0.150
    56.989   582.632     0.150
    56.989  1053.734     0.150
    57.043   578.334     0.150
    57.121   579.164     0.150
    57.267   579.664     0.150
    57.400   585.316     0.150
    57.623   585.104     0.150
    57.638   582.634     0.150
    57.697   582.814     0.150
    57.683   587.455     0.150
    57.829   583.495     0.150
    57.890   583.934     0.150
    57.853   588.491     0.150
    57.853  1063.831     0.150
    58.079   585.584     0.150
    58.113   586.784     0.150
    58.134   585.814     0.150
    58.134   585.444     0.150
    58.154   585.844     0.150
    58.168   585.104     0.150
    58.216   586.934     0.150
    58.242   586.444     0.150
    58.233   587.245     0.150
    58.221   590.914     0.150
    58.270   587.594     0.150
    58.293   587.404     0.150
    58.388   588.354     0.150
    58.408   589.894     0.150
    58.408   589.134     0.150
    58.408   588.146     0.150
    58.408   588.568     0.150
    58.408   590.044     0.150
    58.408   588.454     0.150
    58.389   591.578     0.150
    58.389  1068.882     0.150
    58.225   590.264     0.150
    58.225    12.470     0.150
    58.225    18.780     0.150
    58.482   589.375     0.150
    58.565   588.824     0.150
    58.575   589.904     0.150
    58.591   588.365     0.150
    58.566   591.961     0.150
    58.566   592.984     0.150
    58.566  1073.065     0.150
    58.656   589.564     0.150
    58.605   593.448     0.150
    58.759   591.014     0.150
    58.787   590.064     0.150
    58.787   589.844     0.150
    58.787   590.204     0.150
    58.787   590.313     0.150
    58.904   591.584     0.150
    58.745   595.615     0.150
    58.745    13.880     0.150
    58.986   592.294     0.150
    58.896   593.774     0.150
    58.896   595.544     0.150
    58.896  1073.844     0.150
    58.922   595.365     0.150
    59.172   596.907     0.150
    59.172   597.586     0.150
    59.172  1080.246     0.150
    59.198   594.564     0.150
    59.198   596.266     0.150
    59.198   597.188     0.150
    59.198  1081.050     0.150
    59.198   597.014     0.150
    59.199   597.019     0.150
    59.199   597.678     0.150
    59.203   597.345     0.150
    59.203   597.741     0.150
    59.203  1082.747     0.150
    59.287   597.344     0.150
    59.384   600.784     0.150
    59.422   598.878     0.150
    59.427   599.092     0.150
    59.370   596.276     0.150
    59.370    20.730     0.150
    59.567   597.940     0.150
    59.659   599.644     0.150
    59.605   600.412     0.150
    59.650   597.365     0.150
    59.657   600.216     0.150
    59.657   600.949     0.150
    59.751   601.386     0.150
    59.767   601.132     0.150
    59.767   601.782     0.150
    59.928   598.544     0.150
    60.542   603.214     0.150
    60.660   603.564     0.150
    60.660   602.834     0.150
    60.660   603.274     0.150
    60.730   603.745     0.150
    61.043   605.245     0.150
    61.138   607.644     0.150
    61.139   607.634     0.150
    62.604   617.054     0.150
    62.782   620.914     0.150
    63.351   620.544     0.150
    63.351   621.519     0.150
    63.351  1125.858     0.150
    63.351  2368.594     0.150
    63.354   621.804     0.150
    63.354   621.544     0.150
    63.354   621.684     0.150
    63.400   621.904     0.150
    63.400   621.654     0.150
    63.400    20.820     0.150
    63.537   626.764     0.150
    63.537  1134.930     0.150
    63.902   625.544     0.150
    63.907   624.644     0.150
    64.419   630.134     0.150
    64.419   630.745     0.150
    64.419   630.245     0.150
    64.419   630.284     0.150
    64.476   628.625     0.150
    64.476   627.944     0.150
    64.476   628.144     0.150
    64.476  1138.746     0.150
    64.476  2364.895     0.150
    64.290   630.834     0.150
    64.965   632.964     0.150
    65.872   637.444     0.150
    65.931   641.164     0.150
    66.003   641.764     0.150
    66.073   642.214     0.150
    66.315   642.745     0.150
    66.349   645.557     0.150
    66.349   643.904     0.150
    66.542   643.594     0.150
    66.442   645.414     0.150
    66.551   645.554     0.150
    66.611   645.944     0.150
    66.713   646.434     0.150
    66.886   648.534     0.150
    67.695   654.574     0.150
    67.849   654.184     0.150
    67.864   653.264     0.150
    68.240   652.444     0.150
    68.240   653.120     0.150
    68.306   654.044     0.150
    68.144   654.464     0.150
    68.144   656.264     0.150
    68.144    13.860     0.150
    68.273   656.814     0.150
    68.283   655.524     0.150
    68.681   658.814     0.150
    68.681   661.225     0.150
    68.705   659.534     0.150
    69.211   662.094     0.150
    69.530   664.194     0.150
    69.632   664.974     0.150
    69.632   667.214     0.150
    69.632   667.474     0.150
    69.632   666.245     0.150
    69.632   666.569     0.150
    69.957   666.284     0.150
    70.204   665.444     0.150
    70.204   666.524     0.150
    70.204   666.104     0.150
    70.470   669.615     0.150
    71.121   673.344     0.150
    71.916   676.245     0.150
    72.058   675.745     0.150
    72.058   675.444     0.150
    72.058  1230.844     0.150
    72.058  1259.045     0.150
    72.058  1507.344     0.150
    72.058   675.625     0.150
    72.297   679.144     0.150
    72.192   682.995     0.150
    73.221   686.245     0.150
    73.341   686.444     0.150
    73.624   688.544     0.150
    73.684   689.444     0.150
    73.920   690.344     0.150
    73.939   683.944     0.150
    73.939  1253.745     0.150
    73.939  1539.344     0.150
    74.194   691.344     0.150
    74.555   691.674     0.150
    74.555   691.084     0.150
    74.555   690.870     0.150
    74.727   695.344     0.150
    74.869   694.944     0.150
    74.869  1266.644     0.150
    74.844   696.044     0.150
    74.966   693.745     0.150
    74.966    20.600     0.150
    74.966  1265.245     0.150
    74.778   695.404     0.150
    75.075   699.045     0.150
    75.150   696.874     0.150
    75.000   696.734     0.150
    75.000   697.444     0.150
    75.469   697.525     0.150
    75.469   697.805     0.150
    75.557   700.245     0.150
    75.702   701.245     0.150
    75.847   702.045     0.150
    75.847   700.594     0.150
    75.895   699.624     0.150
    75.916   702.745     0.150
    75.916   701.704     0.150
    76.240   703.045     0.150
    76.304   704.144     0.150
    76.398   705.245     0.150
    76.459   705.245     0.150
    76.459   704.344     0.150
    76.495   706.045     0.150
    76.606   705.844     0.150
    76.993   708.245     0.150
    77.011   708.745     0.150
    77.035   708.924     0.150
    77.035   710.755     0.150
    77.297   707.944     0.150
    77.297   708.745     0.150
    77.529   711.428     0.150
    77.529   710.234     0.150
    77.529   710.051     0.150
    77.529   710.745     0.150
    77.751   712.745     0.150
    77.811   713.144     0.150
    77.693   711.454     0.150
    78.400   713.745     0.150
    78.689   718.045     0.150
    78.735   718.245     0.150
    78.735   716.094     0.150
    78.810   715.944     0.150
    78.932   719.444     0.150
    78.932   718.334     0.150
    78.844   718.224     0.150
    78.844   720.069     0.150
    79.063   721.069     0.150
    79.186   720.844     0.150
    79.274   721.045     0.150
    79.365   718.844     0.150
    79.365  1616.144     0.150
    79.461   722.644     0.150
    79.793   722.344     0.150
    79.907   724.344     0.150
    79.986   725.144     0.150
    79.991   725.844     0.150
    80.076   725.844     0.150
    80.489   728.144     0.150
    80.489   726.214     0.150
    80.595   728.944     0.150
    80.404   728.334     0.150
    80.722   727.045     0.150
    80.764   729.545     0.150
    80.832   724.424     0.150
    80.832   725.245     0.150
    81.062   730.045     0.150
    81.118   729.045     0.150
    81.197   732.644     0.150
    81.268   731.944     0.150
    81.268   730.755     0.150
    81.348   730.344     0.150
    81.385   732.944     0.150
    81.658   734.644     0.150
    81.737   734.844     0.150
    81.937   735.344     0.150
    82.036   736.245     0.150
    81.975   735.684     0.150
    82.385   736.414     0.150
    82.385   737.265     0.150
    82.385   736.844     0.150
    82.385   737.124     0.150
    82.385   736.944     0.150
    82.427   735.644     0.150
    82.597   736.344     0.150
    82.420   740.874     0.150
    82.726   739.344     0.150
    82.747   737.644     0.150
    82.907   740.245     0.150
    83.050   740.074     0.150
    83.050   741.312     0.150
    83.056   739.674     0.150
    83.094   741.644     0.150
    83.458   744.045     0.150
    83.612   742.045     0.150
    83.878   745.245     0.150
    83.917   742.644     0.150
    84.010   746.745     0.150
    84.199   747.045     0.150
    84.211   744.834     0.150
    84.138   746.745     0.150
    84.375   747.545     0.150
    84.391   747.944     0.150
    84.391   746.234     0.150
    84.417   747.234     0.150
    84.701   749.245     0.150
    84.884   752.144     0.150
    85.156   749.944     0.150
    85.156  1372.245     0.150
    85.491   752.261     0.150
    85.491   751.844     0.150
    85.491   954.245     0.150
    86.212   753.745     0.150
    86.212   753.644     0.150
    86.706   758.204     0.150
    87.288   762.527     0.150
    87.391   762.609     0.150
    87.391   762.255     0.150
    87.713   762.944     0.150
    87.713   763.472     0.150
    87.752   764.334     0.150
    87.780   764.605     0.150
    87.947   764.839     0.150
    87.984   766.083     0.150
    88.311   765.999     0.150
    88.390   765.604     0.150
    88.390   765.745     0.150
    88.390   973.267     0.150
    88.390   765.464     0.150
    88.390   766.245     0.150
    88.398   766.190     0.150
    88.398   765.315     0.150
    88.398   766.016     0.150
    88.425   767.751     0.150
    88.454   768.500     0.150
    88.527   768.348     0.150
    88.626   769.461     0.150
    88.511   767.565     0.150
    88.511   769.417     0.150
    88.511   767.444     0.150
    88.511   768.712     0.150
    88.725   767.674     0.150
    88.837   770.248     0.150
    88.845   769.768     0.150
    88.873   770.047     0.150
    88.943   771.103     0.150
    89.067   770.115     0.150
    89.074   771.528     0.150
    89.226   770.857     0.150
    89.329   772.067     0.150
    89.329   771.045     0.150
    89.399   772.005     0.150
    89.803   774.147     0.150
    89.808   774.732     0.150
    89.836   774.709     0.150
    89.884   774.403     0.150
    89.935   774.370     0.150
    90.139   771.474     0.150
    90.139  1401.704     0.150
    90.139  1782.614     0.150
    90.209   775.407     0.150
    90.255   776.370     0.150
    90.783   775.745     0.150
    90.536   779.672     0.150
    90.751   776.844     0.150
    90.825   778.874     0.150
    90.822   778.692     0.150
    91.125   777.144     0.150
    91.497   782.238     0.150
    91.497   782.344     0.150
    91.500   783.057     0.150
    91.666   782.537     0.150
    91.621   781.704     0.150
    92.263   784.384     0.150
    92.341   785.197     0.150
    92.589   786.144     0.150
    92.589   785.120     0.150
    92.714   785.305     0.150
    92.922   787.161     0.150
    92.952   789.245     0.150
    94.432   794.624     0.150
    94.432   792.807     0.150
    94.442   793.774     0.150
    95.138   795.984     0.150
    95.269   798.117     0.150
    95.605   798.894     0.150
    95.918   800.708     0.150
    96.229   802.110     0.150
    96.232  1037.549     0.150
    96.346   803.029     0.150
    96.543  1037.923     0.150
    96.580   802.334     0.150
    96.580   803.663     0.150
    96.635   803.474     0.150
    96.635   804.380     0.150
    96.835   804.707     0.150
    96.887   805.296     0.150
    97.009  1042.295     0.150
    97.205   805.811     0.150
    97.395   806.703     0.150
    97.475   806.714     0.150
    97.475   807.083     0.150
    97.523   808.029     0.150
    97.568   807.204     0.150
    97.568   807.744     0.150
    97.582   807.812     0.150
    97.609  1045.940     0.150
    97.638   809.245     0.150
    97.889   808.224     0.150
    97.892   808.144     0.150
    97.892   807.819     0.150
    97.928   809.062     0.150
    97.944   808.474     0.150
    97.977   808.614     0.150
    98.059   809.685     0.150
    98.041   810.720     0.150
    98.041  1048.470     0.150
    98.063   810.005     0.150
    98.130   809.664     0.150
    98.130   810.240     0.150
    98.145   810.334     0.150
    98.136   810.844     0.150
    98.230   810.801     0.150
    98.250   809.914     0.150
    98.257   810.812     0.150
    98.283   811.025     0.150
    98.333   811.124     0.150
    98.333   811.459     0.150
    98.427   812.150     0.150
    98.465   811.815     0.150
    98.465  1053.289     0.150
    98.586   812.978     0.150
    98.660  1056.066     0.150
    98.715   812.164     0.150
    98.715   813.136     0.150
    98.754   813.742     0.150
    98.745  1056.532     0.150
    98.997   814.261     0.150
    99.110   814.725     0.150
    99.243   815.874     0.150
    99.262   815.659     0.150
    99.304   815.601     0.150
    99.311   815.817     0.150
    99.362  1059.709     0.150
    99.444   816.612     0.150
    99.541   816.880     0.150
    99.633   817.300     0.150
    99.691   817.444     0.150
    99.691  1062.370     0.150
    99.731   818.698     0.150
    99.744   818.078     0.150
    99.726  1062.926     0.150
    99.804   817.943     0.150
    99.987   818.640     0.150
   100.033   819.205     0.150
   100.064   818.912     0.150
   100.203   819.692     0.150
   100.240   819.536     0.150
   100.348   820.390     0.150
   100.432   820.484     0.150
   100.451   819.984     0.150
   100.451   820.223     0.150
   100.468   821.025     0.150
   100.503   821.536     0.150
   100.383  1930.144     0.150
   100.688   822.097     0.150
   100.786   822.607     0.150
   100.792   822.268     0.150
   101.098   823.438     0.150
   101.102   823.367     0.150
   101.160   824.187     0.150
   101.202   824.380     0.150
   101.213   821.824     0.150
   101.213   824.124     0.150
   101.533   826.050     0.150
   101.568   826.077     0.150
   101.625   826.088     0.150
   101.807   826.876     0.150
   101.902   827.319     0.150
   101.919   827.274     0.150
   101.933   827.339     0.150
   102.087   828.438     0.150
   102.090   828.164     0.150
   102.365   829.632     0.150
   102.369   829.376     0.150
   102.452   829.454     0.150
   102.470   829.270     0.150
   102.482   829.865     0.150
   102.489   829.712     0.150
   102.514   829.461     0.150
   102.545   829.353     0.150
   102.866   830.865     0.150
   103.030   831.638     0.150
   103.196   833.860     0.150
   103.242   833.489     0.150
   103.365   833.755     0.150
   103.440   834.685     0.150
   103.519   835.155     0.150
   103.555   834.907     0.150
   103.682   835.348     0.150
   103.721   835.599     0.150
   103.928   836.107     0.150
   104.024   836.973     0.150
   104.030   837.104     0.150
   104.133   834.495     0.150
   104.133  1094.230     0.150
   104.133  1788.295     0.150
   104.168   837.482     0.150
   104.311   837.857     0.150
   104.554   838.453     0.150
   104.879   841.035     0.150
   105.505   841.444     0.150
   105.727  1097.865     0.150
   105.937  1099.035     0.150
   105.944  1098.640     0.150
   105.961  1098.285     0.150
   106.142  1098.737     0.150
   106.262  1098.988     0.150
   106.339  1099.094     0.150
   106.462  1100.301     0.150
   106.716  1100.052     0.150
   106.773  1100.161     0.150
   106.804  1100.081     0.150
   107.163  1100.855     0.150
   107.458  1101.068     0.150
   107.478  1101.333     0.150
   107.691  1101.601     0.150
   107.735  1101.384     0.150
   108.105  1102.589     0.150
   108.137  1102.714     0.150
   108.287  1102.694     0.150
   108.300  1103.008     0.150
   108.312  1102.654     0.150
   108.370  1102.883     0.150
   108.395  1103.026     0.150
   108.421  1103.184     0.150
   108.541  1103.172     0.150
   108.727  1103.390     0.150
   109.057  1104.141     0.150
   109.306  1105.591     0.150
   109.325  1104.786     0.150
   111.076  1147.016     0.150
   113.148  1111.984     0.150
   113.426  1112.763     0.150
   113.574  1113.028     0.150
   114.209  1114.276     0.150
   114.242  1113.819     0.150
   117.868  1120.184     0.150
   117.868  1120.370     0.150
   117.868  1742.870     0.150
   117.868  1969.109     0.150
   125.411  1135.274     0.150
   128.001  1140.743     0.150
   128.043  1141.184     0.150
   129.258  1144.664     0.150
   129.532  1143.716     0.150
   129.525  1143.759     0.150
   129.624  1144.501     0.150
   130.023  1144.895     0.150
   130.350  1145.806     0.150
   130.359  1146.213     0.150
   130.649  1146.628     0.150
   130.940  1147.336     0.150
   131.019  1146.661     0.150
   131.025  1147.463     0.150
   131.236  1147.391     0.150
   131.234  1147.992     0.150
   131.340  1148.281     0.150
   131.333  1148.119     0.150
   131.480  1148.522     0.150
   131.517  1148.396     0.150
   131.633  1148.655     0.150
   131.431  1147.495     0.150
   131.431  1350.120     0.150
   131.752  1148.597     0.150
   131.777  1148.634     0.150
   131.928  1148.980     0.150
   132.214  1149.310     0.150
   132.295  1149.462     0.150
   132.312  1149.807     0.150
   132.444  1150.256     0.150
   132.676  1150.453     0.150
   132.682  1150.920     0.150
   132.821  1150.708     0.150
   132.879  1151.397     0.150
   132.906  1151.217     0.150
   132.906  1149.589     0.150
   132.906  1353.745     0.150
   132.976  1151.732     0.150
   133.044  1353.495     0.150
   132.990  1150.484     0.150
   133.311  1152.077     0.150
   133.441  1152.973     0.150
   133.465  1153.360     0.150
   133.848  1150.069     0.150
   134.160  1154.050     0.150
   134.406  1154.375     0.150
   134.733  1155.233     0.150
   135.100  1155.797     0.150
   135.500  1156.378     0.150
   135.639  1157.000     0.150
   136.152  1158.167     0.150
   136.185  1157.837     0.150
   136.757  1159.432     0.150
   137.001  1159.547     0.150
   137.070  1159.945     0.150
   137.276  1159.962     0.150
   137.373  1158.724     0.150
   137.556  1160.727     0.150
   137.872  1161.422     0.150
   138.399  1162.779     0.150
   138.943  1162.315     0.150
   138.943  1163.230     0.150
   139.221  1164.183     0.150
   139.693  1165.186     0.150
   140.045  1165.579     0.150
   139.904  1166.594     0.150
   141.217  1168.285     0.150
   141.507  1169.334     0.150
   142.062  1169.914     0.150
   142.557  1170.984     0.150
   143.109  1168.035     0.150
   143.619  1167.205     0.150
   143.548  1172.394     0.150
   143.616  1172.565     0.150
   143.904  1168.324     0.150
   144.178  1168.563     0.150
   144.207  1168.560     0.150
   144.251  1168.322     0.150
   144.252  1168.487     0.150
   144.346  1168.903     0.150
   144.350  1170.315     0.150
   144.351  1170.154     0.150
   144.351  1170.297     0.150
   144.351  1387.545     0.150
   144.240  1172.464     0.150
   144.492  1170.441     0.150
   144.492  1170.141     0.150
   144.551  1169.747     0.150
   144.551  1169.128     0.150
   144.572  1171.194     0.150
   144.623  1170.969     0.150
   144.663  1169.859     0.150
   144.676  1169.857     0.150
   144.459  1172.884     0.150
   144.472  1172.674     0.150
   144.751  1170.056     0.150
   144.773  1169.682     0.150
   144.774  1170.272     0.150
   144.810  1170.104     0.150
   145.009  1170.936     0.150
   145.202  1171.561     0.150
   145.267  1171.517     0.150
   145.275  1171.643     0.150
   145.275  1171.153     0.150
   145.303  1171.267     0.150
   145.326  1172.763     0.150
   145.326  1173.414     0.150
   145.386  1172.390     0.150
   145.386  1172.626     0.150
   145.418  1171.807     0.150
   145.426  1172.465     0.150
   145.428  1171.703     0.150
   145.446  1172.082     0.150
   145.460  1172.342     0.150
   145.485  1172.892     0.150
   145.510  1171.740     0.150
   145.348  1176.045     0.150
   145.617  1171.824     0.150
   145.624  1173.164     0.150
   145.624  1172.809     0.150
   145.624  1173.545     0.150
   145.707  1172.672     0.150
   145.707  1173.050     0.150
   145.731  1173.485     0.150
   145.801  1172.811     0.150
   145.799  1173.014     0.150
   145.869  1173.193     0.150
   145.869  1172.276     0.150
   145.873  1173.485     0.150
   145.929  1172.614     0.150
   145.921  1173.834     0.150
   145.921  1173.635     0.150
   145.749  1176.154     0.150
   145.749  1176.674     0.150
   146.058  1173.740     0.150
   145.818  1177.315     0.150
   146.102  1174.424     0.150
   146.112  1174.847     0.150
   146.158  1173.984     0.150
   146.158  1174.401     0.150
   146.203  1174.255     0.150
   146.229  1174.275     0.150
   146.229  1174.500     0.150
   146.321  1176.344     0.150
   146.330  1175.037     0.150
   146.394  1175.265     0.150
   146.377  1175.922     0.150
   146.448  1175.272     0.150
   146.522  1174.455     0.150
   146.527  1177.118     0.150
   146.527  1176.443     0.150
   146.564  1175.334     0.150
   146.591  1176.411     0.150
   146.635  1176.030     0.150
   146.642  1175.874     0.150
   146.643  1176.209     0.150
   146.658  1177.035     0.150
   146.737  1176.358     0.150
   146.746  1176.275     0.150
   146.746  1176.393     0.150
   146.817  1176.324     0.150
   146.817  1176.468     0.150
   146.678  1180.055     0.150
   146.954  1176.830     0.150
   146.989  1175.194     0.150
   147.051  1177.347     0.150
   147.055  1177.374     0.150
   147.058  1177.563     0.150
   147.101  1177.923     0.150
   147.111  1177.924     0.150
   147.111  1177.249     0.150
   147.113  1178.005     0.150
   147.113  1177.479     0.150
   146.883  1177.055     0.150
   146.883  1177.734     0.150
   147.146  1177.664     0.150
   147.146  1177.350     0.150
   147.146  1177.005     0.150
   147.166  1177.663     0.150
   147.148  1178.122     0.150
   147.148  1178.661     0.150
   147.250  1176.634     0.150
   147.250  1177.690     0.150
   147.250  1177.206     0.150
   147.291  1177.734     0.150
   147.332  1178.374     0.150
   147.343  1177.745     0.150
   147.343  1178.170     0.150
   147.439  1177.464     0.150
   147.439  1178.117     0.150
   147.451  1177.824     0.150
   147.511  1178.515     0.150
   147.511  1177.994     0.150
   147.528  1178.446     0.150
   147.604  1178.104     0.150
   147.604  1178.339     0.150
   147.605  1179.055     0.150
   147.605  1179.164     0.150
   147.605  1179.355     0.150
   147.670  1178.664     0.150
   147.670  1179.183     0.150
   147.429  1179.414     0.150
   147.689  1179.245     0.150
   147.752  1179.406     0.150
   147.799  1179.295     0.150
   147.799  1179.131     0.150
   147.811  1178.329     0.150
   147.846  1180.620     0.150
   147.887  1179.980     0.150
   147.672  1179.844     0.150
   147.934  1179.966     0.150
   147.940  1179.978     0.150
   147.970  1179.516     0.150
   148.059  1181.328     0.150
   148.059  1181.953     0.150
   148.122  1180.094     0.150
   148.122  1179.714     0.150
   148.150  1180.354     0.150
   148.164  1180.028     0.150
   148.173  1182.163     0.150
   148.229  1179.724     0.150
   148.268  1180.133     0.150
   148.372  1180.851     0.150
   148.408  1181.315     0.150
   148.408  1181.074     0.150
   148.500  1181.447     0.150
   148.572  1181.172     0.150
   148.643  1181.518     0.150
   148.797  1181.891     0.150
   148.594  1181.315     0.150
   148.980  1182.330     0.150
   148.786  1181.944     0.150
   149.035  1182.094     0.150
   149.035  1182.345     0.150
   149.034  1183.714     0.150
   149.039  1184.026     0.150
   149.039  1184.305     0.150
   149.224  1183.322     0.150
   149.242  1183.174     0.150
   149.074  1181.944     0.150
   149.395  1183.843     0.150
   149.449  1183.714     0.150
   149.273  1187.164     0.150
   149.273  1182.584     0.150
   149.537  1186.084     0.150
   149.691  1184.553     0.150
   149.710  1184.453     0.150
   149.711  1184.424     0.150
   149.887  1185.196     0.150
   149.932  1185.428     0.150
   150.071  1185.572     0.150
   150.166  1186.602     0.150
   150.203  1185.871     0.150
   150.203  1185.472     0.150
   150.513  1186.675     0.150
   150.553  1186.448     0.150
   150.627  1186.728     0.150
   150.710  1187.337     0.150
   150.742  1187.009     0.150
   150.755  1186.505     0.150
   150.827  1187.428     0.150
   150.605  1185.104     0.150
   150.905  1187.603     0.150
   150.734  1185.104     0.150
   151.018  1188.015     0.150
   151.045  1188.162     0.150
   151.097  1187.778     0.150
   151.300  1188.549     0.150
   151.336  1187.984     0.150
   151.396  1188.376     0.150
   151.407  1189.818     0.150
   151.474  1188.102     0.150
   151.484  1189.333     0.150
   151.527  1188.349     0.150
   151.696  1189.746     0.150
   151.825  1189.767     0.150
   151.984  1189.834     0.150
   151.984  1190.022     0.150
   152.002  1190.154     0.150
   152.002  1190.271     0.150
   152.167  1189.818     0.150
   152.278  1189.673     0.150
   152.049  1186.795     0.150
   152.383  1190.281     0.150
   152.565  1191.247     0.150
   152.601  1191.131     0.150
   152.665  1190.884     0.150
   152.988  1191.294     0.150
   152.781  1187.634     0.150
   152.995  1192.514     0.150
   152.995  1191.881     0.150
   153.223  1192.656     0.150
   153.231  1192.352     0.150
   153.550  1193.256     0.150
   153.569  1194.001     0.150
   153.569  1193.739     0.150
   154.205  1195.369     0.150
   154.209  1194.343     0.150
   154.488  1190.164     0.150
   154.751  1196.947     0.150
   154.555  1190.164     0.150
   155.507  1191.434     0.150
   156.782  1192.904     0.150
   160.430  1197.545     0.150
   160.978  1198.594     0.150
   163.319  1200.914     0.150
   165.735  1202.815     0.150
   167.536  1282.424     0.150
   167.448  1204.295     0.150
     0.466     9.623     0.150
     0.639    13.014     0.150
     1.013    17.312     0.150
     1.013    17.473     0.150
     1.060    20.039     0.150
     1.060    19.514     0.150
     1.226    22.014     0.150
     1.226    22.324     0.150
     1.478    26.613     0.150
     1.478    26.824     0.150
     1.582    26.514     0.150
     1.582    26.744     0.150
     1.404    25.113     0.150
     1.404    25.373     0.150
     1.865    32.514     0.150
     1.865    32.713     0.150
     1.941    32.594     0.150
     2.171    36.312     0.150
     2.171    36.994     0.150
     2.838    42.914     0.150
     2.838    43.094     0.150
     3.064    46.232     0.150
     3.096    48.744     0.150
     3.096    48.514     0.150
     3.127    48.033     0.150
     3.127    47.834     0.150
     3.736    57.914     0.150
     3.736    58.023     0.150
     3.778    57.213     0.150
     4.027    62.652     0.150
     4.299    65.123     0.150
     4.334    64.014     0.150
     4.334    64.193     0.150
     5.098    75.113     0.150
     5.098    74.963     0.150
     5.584    83.334     0.150
     5.657    84.732     0.150
     5.657    84.514     0.150
     5.701    84.293     0.150
     6.680    97.303     0.150
     6.680    96.613     0.150
     6.680    97.604     0.150
     7.710   111.014     0.150
     8.966   127.414     0.150
     8.966   127.133     0.150
    11.983   168.553     0.150
    20.425   276.434     0.150
    20.425   276.324     0.150
    28.672   356.713     0.150
    28.686   355.938     0.150
    28.686   544.037     0.150
    28.697   355.633     0.150
    28.869   357.604     0.150
    29.837   366.164     0.150
    37.285   430.414     0.150
    39.740   451.014     0.150
    39.740   451.363     0.150
    39.740   451.244     0.150
    55.475   629.383     0.150
    58.850   593.713     0.150
    58.850   593.338     0.150
    63.416   624.158     0.150
    64.483   630.547     0.150
    68.336   655.854     0.150
    70.380   668.803     0.150
    70.380   668.354     0.150
    74.579   695.033     0.150
    75.032   699.312     0.150
    75.032   699.488     0.150
    82.117   738.414     0.150
    82.117   738.857     0.150
    88.821   772.902     0.150
    88.821   772.480     0.150
    88.821   773.104     0.150
    90.468   780.703     0.150
    94.503   794.914     0.150
   143.813  1171.656     0.150
   146.271  1178.244     0.150
     0.715    14.016     0.150
     0.893    15.016     0.150
     1.055    19.617     0.150
     1.055    33.516     0.150
     1.352    23.617     0.150
     1.448    25.812     0.150
     1.522    24.117     0.150
     2.768    42.219     0.150
     2.768    42.414     0.150
     3.103    48.617     0.150
     3.341    49.516     0.150
     3.447    53.719     0.150
     3.562    52.977     0.150
     3.562    52.812     0.150
     3.609    55.508     0.150
     3.609    55.617     0.150
     3.609    54.914     0.150
     4.111    62.016     0.150
     4.537    66.516     0.150
     4.829    70.312     0.150
     6.610    94.219     0.150
     7.166   104.234     0.150
     7.166   104.617     0.150
     7.166   103.914     0.150
     7.241   107.812     0.150
     8.205   119.516     0.150
     8.630   122.812     0.150
     9.877   140.812     0.150
    10.198   145.016     0.150
    10.243   143.312     0.150
    10.765   151.719     0.150
    10.765   152.516     0.150
    11.687   163.016     0.150
    12.425   171.617     0.150
    13.130   180.672     0.150
    13.130   182.812     0.150
    16.166   224.156     0.150
    16.166   223.812     0.150
    16.516   226.727     0.150
    17.221   235.227     0.150
    17.221   238.516     0.150
    17.221   238.117     0.150
    20.788   277.023     0.150
    20.788   278.742     0.150
    20.788   500.117     0.150
    22.675   297.969     0.150
    24.279   313.016     0.150
    24.279   313.719     0.150
    25.549   324.414     0.150
    26.512   335.016     0.150
    27.147   337.719     0.150
    27.444   340.047     0.150
    27.444   338.969     0.150
    29.061   355.867     0.150
    29.073   355.977     0.150
    29.073   356.594     0.150
    29.073   544.789     0.150
    29.080   356.516     0.150
    29.084   356.875     0.150
    29.257   358.953     0.150
    30.063   365.117     0.150
    30.063   367.414     0.150
    30.179   368.016     0.150
    30.179   367.164     0.150
    30.179   547.719     0.150
    30.179   367.172     0.150
    30.216   368.219     0.150
    33.561   397.219     0.150
    33.714   399.312     0.150
    36.042   416.867     0.150
    36.812   426.312     0.150
    37.502   432.219     0.150
    39.889   449.977     0.150
    39.917   452.617     0.150
    40.033   451.672     0.150
    40.033   452.914     0.150
    40.033   452.438     0.150
    43.000   477.617     0.150
    46.216   503.312     0.150
    47.959   518.312     0.150
    53.152   550.688     0.150
    55.591   569.359     0.150
    56.686   576.289     0.150
    58.285   587.688     0.150
    58.797   591.969     0.150
    58.797   591.297     0.150
    58.797   591.703     0.150
    63.361   622.742     0.150
    63.410   623.516     0.150
    64.477   630.398     0.150
    64.477   629.242     0.150
    67.669   652.648     0.150
    68.254   654.992     0.150
    69.159   663.438     0.150
    70.230   667.992     0.150
    75.536   699.695     0.150
    79.121   721.766     0.150
    81.996   736.227     0.150
    81.996   736.984     0.150
    82.436   737.812     0.150
    88.428   766.367     0.150
    88.557   770.484     0.150
    90.298   777.289     0.150
    90.863   779.664     0.150
    92.612   784.891     0.150
   144.272  1170.969     0.150
   145.826  1177.938     0.150
     0.178     4.537     0.150
     0.464     8.352     0.150
     0.464    16.201     0.150
     0.464     8.076     0.150
     0.557    10.877     0.150
     0.557    11.156     0.150
     1.160    22.377     0.150
     1.231    22.676     0.150
     1.936    34.377     0.150
     2.093    36.877     0.150
     2.635    43.176     0.150
     2.739    45.176     0.150
     2.876    47.477     0.150
     2.876    47.127     0.150
     3.571    56.676     0.150
     3.571    57.137     0.150
     3.707    58.877     0.150
     3.741    58.777     0.150
     4.257    66.377     0.150
     4.467    69.377     0.150
     4.502    70.176     0.150
     4.767    73.477     0.150
     5.323    80.676     0.150
     5.785    86.777     0.150
     6.508    96.777     0.150
     6.507    96.977     0.150
    20.521   278.902     0.150
    20.521   279.986     0.150
    21.869   294.137     0.150
    26.236   337.277     0.150
    26.236   610.477     0.150
    26.998   339.855     0.150
    28.734   358.123     0.150
    29.965   369.527     0.150
    29.965   549.381     0.150
    33.583   400.576     0.150
    39.940   455.402     0.150
    39.940   455.807     0.150
    42.855   479.707     0.150
    54.894   569.539     0.150
    62.956   624.602     0.150
    67.899   657.232     0.150
    70.010   671.006     0.150
    79.324   723.652     0.150
    82.530   740.309     0.150
    82.920   746.807     0.150
   128.265  1146.951     0.150
   143.237  1172.641     0.150
     0.561    11.156     0.150
     0.561    20.258     0.150
     0.622    11.656     0.150
     0.622    21.656     0.150
     0.746    14.453     0.150
     0.746    25.359     0.150
     0.913    16.859     0.150
     0.913    16.758     0.150
     1.364    24.359     0.150
     1.364    43.156     0.150
     1.678    29.258     0.150
     1.678    52.555     0.150
     1.851    31.453     0.150
     1.851    55.656     0.150
     2.507    40.258     0.150
     2.507    72.453     0.150
     3.085    49.758     0.150
     3.097    49.656     0.150
     3.321    51.055     0.150
     3.358    52.359     0.150
     3.699    58.258     0.150
     3.880    60.258     0.150
     3.880   105.859     0.150
     4.012    62.156     0.150
     4.012   108.859     0.150
     4.062    62.258     0.150
     4.138    63.555     0.150
    21.095   283.805     0.150
    26.409   333.164     0.150
    29.288   361.055     0.150
    29.288   547.039     0.150
    30.548   372.305     0.150
    40.542   458.703     0.150
    54.385   561.367     0.150
    57.795   586.852     0.150
     0.225     5.023     0.150
     0.600    13.328     0.150
     1.176    20.672     0.150
     1.063    20.422     0.150
     1.736    28.227     0.150
     1.658    29.125     0.150
     1.903    31.828     0.150
     1.856    31.422     0.150
     2.263    36.023     0.150
     2.607    42.727     0.150
     2.812    44.422     0.150
     3.068    48.922     0.150
     3.064    48.023     0.150
     3.152    47.422     0.150
     3.154    49.227     0.150
     3.761    56.328     0.150
     5.297    77.922     0.150
    19.683   268.852     0.150
    27.851   348.047     0.150
    29.150   360.633     0.150
    39.197   447.477     0.150
    54.922   568.562     0.150
    58.746   594.773     0.150
     0.069     2.414     0.150
     0.180     4.109     0.150
     0.180     8.312     0.150
     0.227     5.109     0.150
     0.239     5.414     0.150
     0.351     7.414     0.150
     0.356     8.812     0.150
     0.398     7.414     0.150
     0.424     7.812     0.150
     0.470     9.109     0.150
     0.510    10.711     0.150
     0.596    11.414     0.150
     0.654    12.508     0.150
     0.738    14.609     0.150
     0.761    14.711     0.150
     0.806    16.508     0.150
     0.855    16.109     0.150
     0.856    16.711     0.150
     0.920    17.812     0.150
     0.951    18.812     0.150
     1.009    18.812     0.150
     1.044    19.609     0.150
     1.061    20.312     0.150
     1.112    20.414     0.150
     1.106    20.609     0.150
     1.273    23.508     0.150
     1.276    23.609     0.150
     1.287    23.609     0.150
     1.309    23.711     0.150
     1.328    23.812     0.150
     1.421    25.508     0.150
     1.427    25.711     0.150
     1.459    26.609     0.150
     1.697    29.414     0.150
     1.741    31.109     0.150
     1.841    31.312     0.150
     1.977    33.711     0.150
     1.983    33.414     0.150
     2.175    36.609     0.150
     2.383    39.211     0.150
     2.790    44.008     0.150
     2.922    46.812     0.150
     2.977    47.812     0.150
     3.626    55.914     0.150
     3.683    57.812     0.150
     4.199    65.812     0.150
     0.211     4.666     0.150
     0.211     9.066     0.150
     0.432     8.467     0.150
     0.432    14.967     0.150
     0.465     8.967     0.150
     0.501    10.066     0.150
     0.563    10.865     0.150
     0.532     9.967     0.150
     0.589    11.766     0.150
     0.656    13.467     0.150
     0.770    14.467     0.150
     0.813    16.365     0.150
     0.838    16.666     0.150
     0.907    17.266     0.150
     0.869    18.365     0.150
     0.900    19.066     0.150
     1.002    20.365     0.150
     1.156    21.166     0.150
     1.166    21.365     0.150
     1.168    21.766     0.150
     1.229    22.066     0.150
     1.437    25.467     0.150
     1.498    26.266     0.150
     1.873    34.066     0.150
     1.932    32.666     0.150
     3.742    56.766     0.150
     0.084     2.840     0.150
     0.194     4.043     0.150
     0.202     4.543     0.150
     0.236     5.043     0.150
     0.242     5.543     0.150
     0.308     6.242     0.150
     0.391     6.141     0.150
     0.445     9.242     0.150
     0.428     9.043     0.150
     0.468     9.340     0.150
     0.471     9.141     0.150
     0.493    10.043     0.150
     0.609    11.941     0.150
     0.613    11.941     0.150
     0.671    11.941     0.150
     0.668    12.840     0.150
     0.745    14.340     0.150
     0.803    14.941     0.150
     0.818    15.840     0.150
     0.864    16.742     0.150
     0.986    18.641     0.150
     1.083    20.141     0.150
     1.159    22.641     0.150
     1.288    23.141     0.150
     1.614    27.941     0.150
     1.842    31.141     0.150
     1.848    34.242     0.150
     2.042    34.242     0.150
     2.444    39.742     0.150
     2.614    42.043     0.150
     2.978    47.043     0.150
     3.196    50.043     0.150
     3.663    56.441     0.150
     0.621    12.859     0.150
     0.777    14.156     0.150
     0.768    14.656     0.150
     0.768    25.562     0.150
     0.948    17.461     0.150
     0.987    18.562     0.150
     0.987    32.062     0.150
     1.043    18.562     0.150
     1.032    19.258     0.150
     1.021    19.078     0.150
     1.093    19.656     0.150
     1.057    19.562     0.150
     1.242    23.359     0.150
     1.242    21.867     0.150
     1.242    22.258     0.150
     1.221    22.125     0.150
     1.248    23.258     0.150
     1.315    22.461     0.150
     1.387    24.359     0.150
     1.422    24.859     0.150
     1.440    25.359     0.150
     1.425    23.914     0.150
     1.425    23.461     0.150
     1.534    27.062     0.150
     1.531    26.258     0.150
     1.600    28.258     0.150
     1.602    26.961     0.150
     1.558    27.359     0.150
     1.669    28.758     0.150
     1.710    29.258     0.150
     1.802    30.562     0.150
     1.780    29.461     0.150
     1.779    29.461     0.150
     1.835    30.859     0.150
     1.873    31.758     0.150
     1.850    30.133     0.150
     1.850    29.758     0.150
     1.964    33.156     0.150
     1.986    32.266     0.150
     1.986    32.156     0.150
     1.997    33.461     0.150
     2.146    33.602     0.150
     2.146    34.961     0.150
     2.248    36.961     0.150
     2.635    41.062     0.150
     2.649    42.156     0.150
     2.954    46.758     0.150
     2.975    46.859     0.150
     3.081    47.156     0.150
     3.184    50.461     0.150
     3.249    50.258     0.150
     3.365    50.156     0.150
     3.444    51.156     0.150
     3.473    51.758     0.150
     3.473    53.688     0.150
     3.504    89.680     0.150
     3.504    54.562     0.150
     3.458    53.703     0.150
     3.458    54.258     0.150
     3.568    56.461     0.150
     3.741    56.258     0.150
     3.936    61.359     0.150
     4.128    61.344     0.150
     4.128    61.961     0.150
     4.217    63.062     0.150
     4.259    65.461     0.150
     4.431    67.562     0.150
     4.505    67.859     0.150
     4.700    71.258     0.150
     5.057    76.758     0.150
     5.173    76.258     0.150
     5.352    77.688     0.150
     5.352    79.859     0.150
     5.382    80.961     0.150
     5.367    83.461     0.150
     5.370    78.328     0.150
     5.370    79.961     0.150
     5.444    78.430     0.150
     5.571    82.359     0.150
     5.592    82.961     0.150
     5.723    83.656     0.150
     5.896    86.656     0.150
     5.938    87.656     0.150
     6.162    91.156     0.150
     6.276    90.758     0.150
     6.373    90.648     0.150
     6.665    97.156     0.150
     6.721    97.133     0.150
     6.758    99.562     0.150
     7.008    99.961     0.150
     7.084   101.750     0.150
     7.084   102.953     0.150
     7.084   103.062     0.150
     7.084   105.156     0.150
     7.151   107.062     0.150
     7.325   107.758     0.150
     7.828   114.758     0.150
     7.918   112.547     0.150
     8.091   114.867     0.150
     8.091   118.062     0.150
     8.118   117.758     0.150
     8.164   118.758     0.150
     8.458   122.562     0.150
     8.865   127.359     0.150
     9.128   132.758     0.150
     9.445   135.258     0.150
     9.420   133.258     0.150
     9.741   139.156     0.150
     9.795   140.156     0.150
    10.263   144.844     0.150
    10.683   150.227     0.150
    11.195   157.008     0.150
    12.979   183.656     0.150
    13.141   178.852     0.150
    13.141   182.273     0.150
    13.283   181.500     0.150
    14.641   202.781     0.150
    15.079   208.961     0.150
    15.079   208.711     0.150
    15.079   217.258     0.150
    16.197   222.477     0.150
    16.634   225.414     0.150
    17.142   233.031     0.150
    17.142   234.688     0.150
    17.689   241.227     0.150
    17.996   247.180     0.150
    17.996   248.242     0.150
    17.996   250.562     0.150
    20.750   279.312     0.150
    20.750   276.617     0.150
    20.750   276.320     0.150
    21.564   280.383     0.150
    22.621   296.297     0.150
    22.621   298.062     0.150
    22.684   299.844     0.150
    22.910   294.328     0.150
    24.211   311.070     0.150
    25.598   321.820     0.150
    25.598   322.180     0.150
    27.398   336.672     0.150
    27.398   338.461     0.150
    27.398   541.062     0.150
    27.398   337.062     0.150
    27.735   339.891     0.150
    29.029   357.734     0.150
    29.029   544.188     0.150
    29.175   357.117     0.150
    30.068   367.062     0.150
    30.148   367.312     0.150
    30.148   547.656     0.150
    30.148   366.500     0.150
    30.148   547.953     0.150
    30.185   368.461     0.150
    34.932   404.547     0.150
    36.567   421.672     0.150
    37.097   421.016     0.150
    38.738   439.062     0.150
    39.835   448.531     0.150
    39.835   448.664     0.150
    39.835   451.758     0.150
    40.016   452.906     0.150
    40.016   451.742     0.150
    40.016   451.180     0.150
    40.016   452.758     0.150
    42.977   477.562     0.150
    47.079   508.859     0.150
    47.079   507.352     0.150
    48.710   522.258     0.150
    49.170   521.906     0.150
    54.390   561.859     0.150
    55.154   564.938     0.150
    55.437   567.953     0.150
    55.517   568.648     0.150
    55.517   630.203     0.150
    56.460   575.562     0.150
    56.583   576.008     0.150
    56.583   574.109     0.150
    56.794   576.898     0.150
    56.813   576.758     0.150
    58.312   588.859     0.150
    58.316   591.969     0.150
    58.755   592.562     0.150
    58.755   590.609     0.150
    58.755   589.992     0.150
    60.665   603.953     0.150
    63.320   621.562     0.150
    63.369   621.852     0.150
    63.369   659.828     0.150
    64.426   628.312     0.150
    66.820   647.289     0.150
    67.005   649.336     0.150
    68.219   653.859     0.150
    68.263   654.258     0.150
    68.856   660.953     0.150
    69.451   663.750     0.150
    69.805   670.062     0.150
    70.211   667.266     0.150
    70.211   666.281     0.150
    72.357   684.180     0.150
    75.062   697.656     0.150
    75.062   698.062     0.150
    75.506   697.922     0.150
    75.506   698.359     0.150
    76.138   705.727     0.150
    77.343   708.781     0.150
    77.343   710.656     0.150
    78.579   718.461     0.150
    78.818   720.531     0.150
    79.044   722.234     0.150
    80.716   725.383     0.150
    82.071   736.828     0.150
    82.071   736.711     0.150
    82.452   737.797     0.150
    82.452   737.656     0.150
    82.452   736.547     0.150
    84.042   747.641     0.150
    86.903   764.062     0.150
    86.953   763.539     0.150
    88.424   766.836     0.150
    88.424   767.461     0.150
    88.432   766.086     0.150
    88.655   768.648     0.150
    88.655   770.000     0.150
    88.655   770.656     0.150
    89.382   770.930     0.150
    89.382   775.156     0.150
    89.382   774.859     0.150
    91.740   784.008     0.150
    92.588   785.859     0.150
    92.588   786.859     0.150
    94.403   793.656     0.150
    97.835   808.938     0.150
    98.425   811.008     0.150
    98.471   812.859     0.150
    99.584   816.852     0.150
   117.718  1120.461     0.150
   132.724  1149.711     0.150
   144.152  1176.258     0.150
   144.155  1170.484     0.150
   145.758  1174.062     0.150
   145.942  1175.648     0.150
   148.822  1183.062     0.150
     0.203     4.723     0.150
     0.264     5.522     0.150
     0.334     5.923     0.150
     0.380     6.623     0.150
     0.361     7.723     0.150
     0.409     8.022     0.150
     0.527     9.923     0.150
     0.621    11.423     0.150
     0.650    13.022     0.150
     0.744    15.123     0.150
     0.731    13.823     0.150
     0.848    16.923     0.150
     0.865    15.923     0.150
     0.913    18.123     0.150
     1.146    20.723     0.150
     1.152    22.323     0.150
     1.210    22.423     0.150
     1.302    24.823     0.150
     1.346    24.723     0.150
     1.480    27.423     0.150
     1.601    28.323     0.150
     1.683    30.923     0.150
     1.694    30.923     0.150
     1.785    32.022     0.150
     1.839    33.022     0.150
     2.098    37.723     0.150
     2.272    40.522     0.150
     2.545    42.923     0.150
     2.970    46.823     0.150
     0.277     6.090     0.150
     0.310     5.691     0.150
     0.358     6.992     0.150
     0.420     8.293     0.150
     0.485     9.090     0.150
     0.485    16.691     0.150
     0.483     8.992     0.150
     0.486    10.191     0.150
     0.602    11.691     0.150
     0.602    21.293     0.150
     0.634    21.992     0.150
     0.705    13.391     0.150
     0.815    16.191     0.150
     0.872    16.492     0.150
     0.943    17.191     0.150
     0.943    32.090     0.150
     0.976    17.590     0.150
     0.986    19.090     0.150
     1.044    18.590     0.150
     1.044    32.492     0.150
     1.121    21.090     0.150
     1.189    22.391     0.150
     1.294    24.090     0.150
     1.311    24.492     0.150
     1.310    23.590     0.150
     1.310    43.293     0.150
     1.340    24.391     0.150
     1.425    25.492     0.150
     1.425    46.391     0.150
     1.712    29.691     0.150
     1.732    30.793     0.150
     1.743    30.293     0.150
     1.761    30.992     0.150
     1.804    32.090     0.150
     1.846    31.590     0.150
     1.894    32.492     0.150
     1.957    33.090     0.150
     1.998    34.590     0.150
     1.998    61.391     0.150
     2.023    33.891     0.150
     2.027    33.691     0.150
     2.113    35.793     0.150
     2.125    36.090     0.150
     2.139    35.891     0.150
     2.262    37.191     0.150
     2.312    38.590     0.150
     2.393    39.891     0.150
     2.393    73.191     0.150
     3.022    48.191     0.150
     3.108    50.492     0.150
     3.112    48.891     0.150
     4.107    63.891     0.150
     5.566    84.090     0.150
     0.149     3.664     0.150
     0.149     7.664     0.150
     0.220     3.863     0.150
     0.296     5.664     0.150
     0.296    11.266     0.150
     0.348     7.266     0.150
     0.444     9.266     0.150
     0.470     9.664     0.150
     0.543    11.062     0.150
     0.633    12.062     0.150
     0.630    12.062     0.150
     0.630    22.363     0.150
     0.733    13.465     0.150
     0.733    24.266     0.150
     0.767    14.266     0.150
     0.767    25.863     0.150
     0.752    14.664     0.150
     0.752    26.363     0.150
     0.772    14.465     0.150
     0.772    26.562     0.150
     0.905    17.863     0.150
     0.905    30.664     0.150
     1.038    19.664     0.150
     1.038    35.266     0.150
     1.042    18.965     0.150
     1.042    34.266     0.150
     1.018    19.062     0.150
     1.018    34.965     0.150
     1.312    23.863     0.150
     1.312    41.562     0.150
     1.481    27.164     0.150
     1.481    45.363     0.150
     1.459    26.766     0.150
     1.550    27.363     0.150
     1.594    28.863     0.150
     1.674    29.664     0.150
     1.726    30.766     0.150
     1.774    31.766     0.150
     1.803    32.164     0.150
     2.035    34.664     0.150
     2.069    36.766     0.150
     2.211    39.965     0.150
     0.157     3.859     0.150
     0.157     6.859     0.150
     0.184     3.961     0.150
     0.184     7.262     0.150
     0.267     5.262     0.150
     0.267     9.160     0.150
     0.282     5.262     0.150
     0.282     9.262     0.150
     0.391     7.660     0.150
     0.391    13.660     0.150
     0.437     8.660     0.150
     0.437    15.359     0.150
     0.489    10.859     0.150
     0.506     9.461     0.150
     0.506    16.262     0.150
     0.527    10.262     0.150
     0.527    18.660     0.150
     0.536    10.961     0.150
     0.536    17.559     0.150
     0.560    10.859     0.150
     0.642    13.160     0.150
     0.642    22.461     0.150
     0.676    12.559     0.150
     0.685    13.461     0.150
     0.685    23.359     0.150
     0.702    13.461     0.150
     0.702    23.359     0.150
     0.712    13.359     0.150
     0.712    23.262     0.150
     0.735    14.859     0.150
     0.735    24.461     0.150
     0.782    14.961     0.150
     0.974    19.359     0.150
     1.021    18.660     0.150
     1.026    19.059     0.150
     1.175    20.961     0.150
     1.267    24.160     0.150
     1.701    30.359     0.150
     2.404    40.262     0.150
     0.028     1.508     0.150
     0.028     3.609     0.150
     0.200     5.711     0.150
     0.248     6.008     0.150
     0.341     7.305     0.150
     0.383     8.508     0.150
     0.480     9.508     0.150
     0.453     9.711     0.150
     0.530    10.305     0.150
     0.546    10.609     0.150
     0.543    11.211     0.150
     0.640    12.805     0.150
     0.641    12.609     0.150
     0.700    12.906     0.150
     0.777    14.805     0.150
     0.789    15.008     0.150
     0.788    14.711     0.150
     0.801    15.211     0.150
     0.920    17.305     0.150
     0.938    17.711     0.150
     0.948    17.805     0.150
     0.944    17.805     0.150
     1.068    20.109     0.150
     1.104    20.906     0.150
     1.165    21.406     0.150
     1.226    22.406     0.150
     1.239    22.906     0.150
     1.365    25.211     0.150
     1.391    25.609     0.150
     1.614    28.906     0.150
     1.691    29.711     0.150
     1.714    29.906     0.150
     1.835    31.609     0.150
     1.969    33.508     0.150
     2.376    37.906     0.150
     2.377    38.711     0.150
     2.396    38.711     0.150
     2.737    43.008     0.150
     3.066    48.906     0.150
     3.230    50.008     0.150
     3.330    52.305     0.150
     3.424    53.305     0.150
     4.093    62.906     0.150
    12.433   176.805     0.150
     0.227     4.734     0.150
     0.227     8.834     0.150
     0.257     5.034     0.150
     0.257     8.234     0.150
     0.414     7.859     0.150
     0.414    15.359     0.150
     0.414     8.234     0.150
     0.414    14.234     0.150
     0.447     8.234     0.150
     0.447    14.334     0.150
     0.517    10.034     0.150
     0.512     9.734     0.150
     0.547    11.834     0.150
     0.557    10.934     0.150
     0.571    11.334     0.150
     0.584    11.034     0.150
     0.589    11.234     0.150
     0.604    12.034     0.150
     0.649    12.334     0.150
     0.751    13.834     0.150
     0.798    15.834     0.150
     0.848    16.434     0.150
     0.867    16.434     0.150
     0.896    18.034     0.150
     0.891    16.934     0.150
     0.918    17.934     0.150
     0.931    16.334     0.150
     0.963    18.634     0.150
     0.989    19.834     0.150
     1.075    20.834     0.150
     1.145    21.634     0.150
     1.151    21.234     0.150
     1.160    22.334     0.150
     1.160    21.434     0.150
     1.239    22.234     0.150
     1.421    25.934     0.150
     1.467    27.034     0.150
     1.503    27.234     0.150
     1.535    27.734     0.150
     1.827    31.434     0.150
     1.834    32.234     0.150
     1.903    32.434     0.150
     1.880    33.634     0.150
     1.942    32.634     0.150
     2.074    35.534     0.150
     2.269    38.934     0.150
     2.281    38.434     0.150
     2.518    40.834     0.150
     2.650    43.434     0.150
     2.740    45.934     0.150
     2.811    45.634     0.150
     2.891    46.534     0.150
     2.943    47.634     0.150
     2.997    48.734     0.150
     3.022    48.234     0.150
     3.188    51.134     0.150
     3.289    51.434     0.150
     3.265    52.734     0.150
     3.598    56.534     0.150
     3.588    56.434     0.150
     4.074    63.834     0.150
     4.155    63.634     0.150
     0.162     4.911     0.150
     0.289     5.311     0.150
     0.475     8.911     0.150
     0.519     9.811     0.150
     0.582    10.111     0.150
     0.539    10.811     0.150
     0.600    11.911     0.150
     0.633    13.211     0.150
     0.650    12.211     0.150
     0.638    12.911     0.150
     0.806    14.311     0.150
     0.855    17.011     0.150
     0.912    18.111     0.150
     0.951    17.911     0.150
     0.946    17.811     0.150
     0.906    16.211     0.150
     0.995    19.311     0.150
     1.146    23.211     0.150
     1.143    21.611     0.150
     1.180    21.811     0.150
     1.248    23.011     0.150
     1.444    26.311     0.150
     1.527    27.911     0.150
     1.531    27.811     0.150
     1.830    32.011     0.150
     1.896    32.611     0.150
     1.949    33.011     0.150
     2.654    44.211     0.150
     2.807    45.211     0.150
     2.890    48.311     0.150
     2.952    50.211     0.150
     3.584    56.311     0.150
     0.085     2.578     0.150
     0.085     5.781     0.150
     0.170     3.883     0.150
     0.217     3.883     0.150
     0.217     7.781     0.150
     0.188     4.383     0.150
     0.270     5.984     0.150
     0.270     6.633     0.150
     0.270    10.406     0.150
     0.350     7.078     0.150
     0.362     7.383     0.150
     0.424     7.883     0.150
     0.420     8.180     0.150
     0.634    12.383     0.150
     0.634    22.578     0.150
     0.608    11.781     0.150
     0.637    12.383     0.150
     0.646    12.680     0.150
     0.646    22.883     0.150
     0.672    12.883     0.150
     0.770    14.078     0.150
     0.770    14.984     0.150
     0.772    15.180     0.150
     0.836    15.984     0.150
     0.840    16.078     0.150
     0.857    15.781     0.150
     0.857    29.180     0.150
     0.920    16.883     0.150
     0.920    30.180     0.150
     1.017    18.883     0.150
     1.017    33.281     0.150
     1.008    19.281     0.150
     1.074    20.578     0.150
     1.074    35.383     0.150
     1.224    22.281     0.150
     1.224    40.781     0.150
     1.369    24.180     0.150
     1.369    43.383     0.150
     1.317    23.578     0.150
     1.361    24.383     0.150
     1.361    44.883     0.150
     1.496    26.781     0.150
     1.496    47.180     0.150
     1.661    29.383     0.150
     1.830    32.180     0.150
     2.005    34.781     0.150
     2.244    38.281     0.150
     2.362    39.281     0.150
     3.281    51.781     0.150
     3.347    52.484     0.150
     3.388    52.781     0.150
     3.651    56.984     0.150
     4.051    62.281     0.150
    29.284   361.633     0.150
    30.550   372.633     0.150
    40.549   459.219     0.150
     0.057     1.693     0.150
     0.057     3.993     0.150
     0.140     2.893     0.150
     0.140     5.893     0.150
     0.178     3.593     0.150
     0.178     6.693     0.150
     0.238     4.293     0.150
     0.238     8.693     0.150
     0.309     6.193     0.150
     0.332     6.693     0.150
     0.332    11.693     0.150
     0.350     7.893     0.150
     0.373     7.393     0.150
     0.373    13.493     0.150
     0.456     8.893     0.150
     0.457    10.693     0.150
     0.503     9.393     0.150
     0.503    17.593     0.150
     0.604    11.193     0.150
     0.604    20.793     0.150
     0.623    12.093     0.150
     0.667    12.693     0.150
     0.667    21.993     0.150
     0.744    14.093     0.150
     0.744    24.493     0.150
     0.863    15.693     0.150
     0.854    16.293     0.150
     1.106    21.293     0.150
     1.260    23.393     0.150
     1.351    24.593     0.150
     1.395    26.493     0.150
     1.487    26.093     0.150
     1.524    26.693     0.150
     1.959    34.293     0.150
     2.474    41.293     0.150
     0.223     4.156     0.150
     0.223     7.055     0.150
     0.189     4.859     0.150
     0.189     8.453     0.150
     0.415     7.555     0.150
     0.432     9.156     0.150
     0.466     8.453     0.150
     0.503     9.859     0.150
     0.503    17.258     0.150
     0.560    10.156     0.150
     0.561    10.859     0.150
     0.609    12.359     0.150
     0.627    12.859     0.150
     0.627    21.859     0.150
     0.705    14.156     0.150
     0.721    13.953     0.150
     0.771    14.859     0.150
     0.860    16.656     0.150
     1.006    18.953     0.150
     1.003    18.359     0.150
     1.003    31.555     0.150
     1.041    19.555     0.150
     1.036    19.258     0.150
     1.036    33.953     0.150
     1.058    20.156     0.150
     1.096    21.555     0.150
     1.352    24.953     0.150
     1.637    30.656     0.150
     1.936    34.656     0.150
     1.977    35.055     0.150
     2.057    36.156     0.150
     0.245     6.188     0.150
     0.245    10.389     0.150
     0.342     7.289     0.150
     0.342    12.088     0.150
     0.427     8.588     0.150
     0.427    14.688     0.150
     0.491     9.789     0.150
     0.491    16.789     0.150
     0.550    10.389     0.150
     0.550    17.588     0.150
     0.640    12.289     0.150
     0.640    21.289     0.150
     0.655    12.688     0.150
     0.655    21.789     0.150
     0.682    13.289     0.150
     0.682    22.889     0.150
     0.721    14.289     0.150
     0.721    24.488     0.150
     0.748    15.088     0.150
     0.766    14.789     0.150
     0.766    25.688     0.150
     0.793    14.588     0.150
     0.793    25.588     0.150
     0.862    16.688     0.150
     0.862    28.789     0.150
     0.882    16.289     0.150
     0.908    16.789     0.150
     0.898    17.188     0.150
     0.952    18.389     0.150
     1.060    19.488     0.150
     1.172    20.188     0.150
     1.222    22.488     0.150
     1.222    21.988     0.150
     1.512    26.688     0.150
     1.619    28.688     0.150
     1.788    30.588     0.150
     1.819    30.188     0.150
     1.858    32.088     0.150
     1.865    31.588     0.150
     2.308    37.789     0.150
     4.424    68.688     0.150
     4.490    68.988     0.150
     0.257     6.172     0.150
     0.323     7.273     0.150
     0.323    12.172     0.150
     0.417     8.473     0.150
     0.494     9.973     0.150
     0.494    16.871     0.150
     0.545    10.273     0.150
     0.545    17.672     0.150
     0.639    12.672     0.150
     0.667    13.172     0.150
     0.667    22.473     0.150
     0.689    13.371     0.150
     0.689    22.871     0.150
     0.710    13.371     0.150
     0.778    14.973     0.150
     0.810    15.070     0.150
     0.867    16.371     0.150
     0.867    29.473     0.150
     0.879    17.070     0.150
     0.921    17.773     0.150
     1.041    20.070     0.150
     1.155    20.672     0.150
     1.300    22.871     0.150
     1.298    23.473     0.150
     1.388    25.371     0.150
     1.494    26.172     0.150
     1.533    27.473     0.150
     1.600    28.371     0.150
     1.840    32.172     0.150
     1.833    32.070     0.150
     1.903    32.273     0.150
     2.289    37.973     0.150
     0.108     2.742     0.150
     0.108     4.840     0.150
     0.271     5.641     0.150
     0.271     9.242     0.150
     0.345     7.242     0.150
     0.331     6.840     0.150
     0.331    11.543     0.150
     0.408     8.543     0.150
     0.408    12.641     0.150
     0.340     7.543     0.150
     0.563    10.641     0.150
     0.548    10.543     0.150
     0.585    10.441     0.150
     0.656    11.543     0.150
     0.656    21.340     0.150
     0.702    13.043     0.150
     0.743    14.543     0.150
     0.720    14.941     0.150
     0.759    14.840     0.150
     0.898    17.742     0.150
     0.913    17.941     0.150
     0.934    16.941     0.150
     0.924    16.941     0.150
     1.095    21.941     0.150
     1.193    21.242     0.150
     1.178    22.840     0.150
     1.159    20.742     0.150
     1.484    27.742     0.150
     1.828    31.840     0.150
     2.188    38.141     0.150
     0.207     5.133     0.150
     0.207     9.434     0.150
     0.294     5.832     0.150
     0.294     9.832     0.150
     0.445     8.234     0.150
     0.445    15.133     0.150
     0.485     8.934     0.150
     0.485    15.734     0.150
     0.482     9.734     0.150
     0.482    17.832     0.150
     0.538    10.434     0.150
     0.538    17.832     0.150
     0.583    10.734     0.150
     0.583    19.234     0.150
     0.602    12.633     0.150
     0.598    12.133     0.150
     0.598    20.934     0.150
     0.619    12.133     0.150
     0.642    12.734     0.150
     0.648    12.633     0.150
     0.648    22.234     0.150
     0.786    26.035     0.150
     0.834    16.434     0.150
     0.834    27.234     0.150
     0.818    14.934     0.150
     0.818    15.133     0.150
     0.818    27.734     0.150
     0.858    28.934     0.150
     0.899    17.535     0.150
     0.899    29.934     0.150
     0.928    17.434     0.150
     0.893    16.734     0.150
     0.893    28.734     0.150
     0.956    17.332     0.150
     1.022    20.332     0.150
     1.189    22.832     0.150
     1.184    22.035     0.150
     1.184    37.934     0.150
     1.192    22.535     0.150
     1.210    22.234     0.150
     1.210    39.535     0.150
     1.458    26.734     0.150
     1.481    27.234     0.150
     1.481    46.535     0.150
     1.502    27.332     0.150
     1.502    47.332     0.150
     1.855    33.832     0.150
     1.912    33.035     0.150
     1.912    57.934     0.150
     2.107    36.035     0.150
     2.796    45.633     0.150
     0.187     4.199     0.150
     0.187     4.332     0.150
     0.187     6.930     0.150
     0.319    11.230     0.150
     0.472    15.480     0.150
     0.472     7.332     0.150
     0.468     8.832     0.150
     0.468    16.531     0.150
     0.511    17.629     0.150
     0.561     9.629     0.150
     0.561    19.930     0.150
     0.611    11.730     0.150
     0.611    21.230     0.150
     0.634    11.730     0.150
     0.634    21.332     0.150
     0.667    12.430     0.150
     0.667    21.129     0.150
     0.814    14.832     0.150
     0.814    27.031     0.150
     0.804    14.930     0.150
     0.804    14.629     0.150
     0.804    26.629     0.150
     0.856    29.031     0.150
     0.863    18.730     0.150
     0.869    15.629     0.150
     0.915    18.129     0.150
     0.945    17.930     0.150
     0.980    18.930     0.150
     1.041    20.430     0.150
     1.041    34.031     0.150
     1.056    21.031     0.150
     1.193    22.230     0.150
     1.210    22.629     0.150
     1.197    21.531     0.150
     1.197    38.031     0.150
     1.484    27.430     0.150
     1.484    47.629     0.150
     1.783    32.230     0.150
     1.899    32.531     0.150
     1.899    56.930     0.150
     2.126    37.230     0.150
     2.126    62.930     0.150
     2.706    44.781     0.150
     2.760    45.629     0.150
     2.781    45.832     0.150
     2.842    46.082     0.150
     2.842    47.730     0.150
     2.842    81.531     0.150
     3.218    52.332     0.150
     3.537    57.129     0.150
     4.030    65.332     0.150
     4.108    64.129     0.150
    16.016   223.270     0.150
    16.542   232.891     0.150
    20.492   280.105     0.150
    20.492   277.922     0.150
    22.220   297.980     0.150
    28.704   359.273     0.150
    28.710   357.230     0.150
    29.936   369.691     0.150
    29.936   368.551     0.150
    50.605   536.191     0.150
     0.618    12.154     0.150
     0.618    20.554     0.150
     0.747    14.154     0.150
     0.747    24.154     0.150
     0.792    13.645     0.150
     0.875    16.054     0.150
     0.906    16.354     0.150
     0.952    17.054     0.150
     1.023    18.454     0.150
     1.043    18.154     0.150
     1.004    17.854     0.150
     1.090    19.154     0.150
     1.040    18.554     0.150
     1.127    19.754     0.150
     1.212    21.454     0.150
     1.249    23.054     0.150
     1.247    39.379     0.150
     1.247    21.854     0.150
     1.386    24.454     0.150
     1.375    23.754     0.150
     1.332    22.354     0.150
     1.440    24.954     0.150
     1.429    24.754     0.150
     1.515    25.554     0.150
     1.478    24.354     0.150
     1.448    22.854     0.150
     1.536    25.254     0.150
     1.658    27.854     0.150
     1.621    26.554     0.150
     1.767    29.454     0.150
     1.844    30.654     0.150
     1.828    29.054     0.150
     1.889    31.454     0.150
     1.980    32.554     0.150
     1.981    32.654     0.150
     2.006    31.854     0.150
     2.168    33.154     0.150
     2.268    36.054     0.150
     2.352    37.454     0.150
     2.457    38.354     0.150
     2.450    37.354     0.150
     2.670    41.554     0.150
     2.657    40.254     0.150
     2.836    43.354     0.150
     2.997    45.754     0.150
     3.070    47.254     0.150
     3.060    46.254     0.150
     3.101    47.354     0.150
     2.827    41.454     0.150
     3.162    47.954     0.150
     3.146    46.754     0.150
     3.242    48.454     0.150
     3.272    48.454     0.150
     3.364    51.454     0.150
     3.435    52.354     0.150
     3.467    53.254     0.150
     3.470    51.054     0.150
     3.525    51.774     0.150
     3.525    53.654     0.150
     3.547    54.054     0.150
     3.496    51.414     0.150
     3.496    51.254     0.150
     3.566    52.854     0.150
     3.703    56.754     0.150
     3.679    56.154     0.150
     3.773    57.154     0.150
     3.916    59.254     0.150
     3.926    58.954     0.150
     3.894    56.954     0.150
     4.098    61.354     0.150
     4.196    62.454     0.150
     4.152    60.754     0.150
     4.237    63.754     0.150
     4.410    66.454     0.150
     4.387    65.354     0.150
     4.462    66.754     0.150
     4.724    70.754     0.150
     4.733    70.554     0.150
     4.782    71.354     0.150
     4.766    69.854     0.150
     4.810    70.954     0.150
     4.869    73.554     0.150
     4.937    72.454     0.150
     4.937    73.154     0.150
     5.035    74.954     0.150
     5.168    75.954     0.150
     5.113    76.354     0.150
     5.331    78.454     0.150
     5.341    78.454     0.150
     5.347    78.594     0.150
     5.427    77.424     0.150
     5.493    84.554     0.150
     5.594    82.654     0.150
     5.780    85.654     0.150
     5.726    86.554     0.150
     5.986    88.354     0.150
     6.253    91.054     0.150
     6.314    91.954     0.150
     6.543    95.654     0.150
     6.699    96.954     0.150
     7.108   101.924     0.150
     7.108   103.354     0.150
     7.175   107.654     0.150
     7.303   104.854     0.150
     7.448   107.254     0.150
     7.993   114.754     0.150
     8.074   114.854     0.150
     8.171   116.154     0.150
     8.116   117.454     0.150
     8.142   118.054     0.150
     8.140   117.854     0.150
     8.154   117.854     0.150
     8.167   117.954     0.150
     8.188   118.754     0.150
     8.492   120.354     0.150
     8.526   120.854     0.150
     8.482   122.354     0.150
     8.633   118.654     0.150
     8.780   124.154     0.150
     8.897   127.254     0.150
     8.882   125.454     0.150
     9.102   130.654     0.150
     9.114   131.854     0.150
     9.132   129.254     0.150
     9.237   129.254     0.150
     9.396   132.954     0.150
     9.339   133.954     0.150
     9.397   131.654     0.150
     9.424   133.754     0.150
     9.528   133.454     0.150
     9.469   134.454     0.150
     9.765   138.854     0.150
     9.819   139.154     0.150
     9.906   138.154     0.150
    10.113   141.174     0.150
    10.113   141.754     0.150
    10.215   147.254     0.150
    10.131   144.454     0.150
    10.216   143.654     0.150
    10.240   142.154     0.150
    10.335   144.854     0.150
    10.392   145.054     0.150
    10.500   147.754     0.150
    10.684   149.854     0.150
    10.708   149.454     0.150
    10.708   150.454     0.150
    10.868   150.554     0.150
    10.890   152.854     0.150
    10.866   151.654     0.150
    10.866   152.754     0.150
    11.197   156.454     0.150
    11.488   160.554     0.150
    11.680   161.924     0.150
    11.680   161.554     0.150
    11.877   170.054     0.150
    11.782   165.154     0.150
    12.681   180.854     0.150
    12.778   179.654     0.150
    12.948   183.654     0.150
    12.933   183.054     0.150
    13.030   177.554     0.150
    13.000   181.964     0.150
    13.000   183.654     0.150
    13.119   178.895     0.150
    13.119   179.154     0.150
    13.228   187.354     0.150
    13.262   181.754     0.150
    13.262   181.554     0.150
    13.260   187.954     0.150
    13.273   184.454     0.150
    13.298   187.854     0.150
    13.292   187.254     0.150
    13.293   187.754     0.150
    13.262   181.379     0.150
    13.332   186.854     0.150
    13.263   183.454     0.150
    13.362   186.954     0.150
    13.466   185.954     0.150
    13.511   189.554     0.150
    13.539   190.954     0.150
    13.538   188.254     0.150
    13.677   191.154     0.150
    13.650   193.954     0.150
    13.703   188.254     0.150
    13.846   192.354     0.150
    13.863   191.354     0.150
    13.977   191.254     0.150
    13.986   197.254     0.150
    13.995   196.554     0.150
    14.012   197.954     0.150
    14.119   197.054     0.150
    14.135   198.654     0.150
    14.814   212.554     0.150
    14.368   202.654     0.150
    14.537   204.454     0.150
    14.605   205.254     0.150
    14.620   199.754     0.150
    14.566   199.354     0.150
    14.589   199.654     0.150
    14.761   204.854     0.150
    14.802   200.254     0.150
    14.834   208.154     0.150
    14.797   208.154     0.150
    14.821   206.454     0.150
    14.884   209.154     0.150
    14.970   210.254     0.150
    14.883   204.154     0.150
    15.036   211.554     0.150
    15.064   210.454     0.150
    15.103   210.154     0.150
    15.103   208.454     0.150
    15.256   214.054     0.150
    15.274   213.254     0.150
    15.336   214.454     0.150
    15.372   214.754     0.150
    15.568   214.654     0.150
    15.666   218.854     0.150
    15.657   217.854     0.150
    15.816   220.454     0.150
    15.844   221.954     0.150
    15.897   222.354     0.150
    15.852   218.254     0.150
    16.029   224.554     0.150
    16.177   225.054     0.150
    16.278   222.244     0.150
    16.300   222.954     0.150
    16.416   225.145     0.150
    16.416   227.854     0.150
    16.214   222.769     0.150
    16.214   222.508     0.150
    16.214   220.804     0.150
    16.630   229.854     0.150
    16.722   227.554     0.150
    16.969   234.254     0.150
    17.076   235.054     0.150
    17.140   234.034     0.150
    17.140   236.654     0.150
    17.167   232.604     0.150
    17.167   234.284     0.150
    17.167   233.754     0.150
    17.355   239.154     0.150
    17.348   239.854     0.150
    17.451   237.254     0.150
    17.557   240.154     0.150
    17.698   242.354     0.150
    17.771   244.654     0.150
    17.981   242.164     0.150
    18.094   245.154     0.150
    18.018   247.798     0.150
    18.018   247.107     0.150
    18.018   246.534     0.150
    18.018   246.855     0.150
    18.018   247.254     0.150
    18.488   249.854     0.150
    19.528   260.354     0.150
    19.785   263.864     0.150
    19.785   266.054     0.150
    19.792   265.454     0.150
    19.792   265.254     0.150
    20.010   269.154     0.150
    20.538   274.754     0.150
    20.775   278.704     0.150
    20.775   278.079     0.150
    20.775   496.229     0.150
    20.775   276.664     0.150
    20.775   278.554     0.150
    21.196   281.854     0.150
    21.502   283.254     0.150
    21.502   282.954     0.150
    21.651   284.754     0.150
    21.678   286.654     0.150
    21.777   284.754     0.150
    21.645   288.269     0.150
    21.645   288.094     0.150
    22.072   288.104     0.150
    22.072   286.694     0.150
    22.072   289.254     0.150
    22.072   289.354     0.150
    22.298   290.154     0.150
    22.371   293.254     0.150
    22.543   294.454     0.150
    22.793   295.054     0.150
    22.646   296.779     0.150
    22.646   297.114     0.150
    22.646   295.984     0.150
    22.896   297.854     0.150
    22.927   294.564     0.150
    22.927   297.454     0.150
    22.887   295.154     0.150
    22.700   298.432     0.150
    22.700   298.904     0.150
    22.700   299.744     0.150
    22.700   299.254     0.150
    23.021   298.364     0.150
    23.308   298.654     0.150
    23.459   302.685     0.150
    23.459   303.454     0.150
    23.486   303.154     0.150
    23.771   307.273     0.150
    23.771   306.504     0.150
    24.073   308.614     0.150
    24.235   313.504     0.150
    24.235   313.345     0.150
    24.235   312.944     0.150
    24.344   316.023     0.150
    24.344   315.495     0.150
    24.344   315.094     0.150
    25.048   316.054     0.150
    25.174   319.454     0.150
    25.504   323.777     0.150
    25.620   322.464     0.150
    25.620   322.234     0.150
    25.620   323.054     0.150
    25.620   323.454     0.150
    25.637   325.554     0.150
    25.657   325.254     0.150
    25.889   322.554     0.150
    25.603   329.019     0.150
    25.603   327.685     0.150
    26.520   334.604     0.150
    26.520   334.306     0.150
    26.922   333.044     0.150
    26.922   335.454     0.150
    26.922   612.254     0.150
    26.922   335.054     0.150
    26.637   336.054     0.150
    26.637   337.395     0.150
    26.902   334.854     0.150
    27.112   337.554     0.150
    27.259   339.154     0.150
    27.383   337.643     0.150
    27.383   337.604     0.150
    27.383   539.925     0.150
    27.383   755.351     0.150
    27.383   337.324     0.150
    27.432   341.054     0.150
    27.721   340.374     0.150
    27.721   340.614     0.150
    27.721   340.054     0.150
    27.719   340.354     0.150
    27.815   345.054     0.150
    27.828   346.054     0.150
    27.868   343.754     0.150
    28.716   349.554     0.150
    29.054   356.454     0.150
    29.053   355.954     0.150
    29.053   544.489     0.150
    29.053   759.071     0.150
    29.060   356.354     0.150
    29.060   356.064     0.150
    29.523   356.624     0.150
    29.523   544.244     0.150
    29.523   357.094     0.150
    29.704   361.224     0.150
    29.704   361.854     0.150
    29.908   362.254     0.150
    30.247   368.734     0.150
    30.247   368.905     0.150
    30.088   367.204     0.150
    30.088   367.098     0.150
    30.088   366.154     0.150
    30.088   366.754     0.150
    30.172   366.554     0.150
    30.172   546.954     0.150
    30.172   764.625     0.150
    30.172   366.254     0.150
    30.172   546.634     0.150
    30.209   368.354     0.150
    30.944   375.444     0.150
    30.944   372.474     0.150
    30.944   374.754     0.150
    32.440   382.954     0.150
    33.123   390.254     0.150
    33.983   397.054     0.150
    34.115   397.645     0.150
    34.115   396.244     0.150
    34.115   398.054     0.150
    33.933   399.623     0.150
    33.933   398.284     0.150
    34.170   398.254     0.150
    34.335   400.314     0.150
    34.335   398.044     0.150
    34.486   404.464     0.150
    34.612   407.185     0.150
    35.294   408.935     0.150
    35.294   406.984     0.150
    35.589   411.134     0.150
    35.774   411.134     0.150
    35.774   413.154     0.150
    36.341   418.054     0.150
    36.341   758.054     0.150
    36.384   417.401     0.150
    36.384   416.054     0.150
    36.384   416.154     0.150
    36.588   425.048     0.150
    36.588   424.087     0.150
    36.588   423.754     0.150
    36.588   424.654     0.150
    37.498   430.954     0.150
    37.730   428.924     0.150
    37.730    14.471     0.150
    37.730   567.084     0.150
    37.730   776.614     0.150
    37.730  1038.204     0.150
    37.680   432.228     0.150
    37.680   430.084     0.150
    37.680   431.754     0.150
    38.043   431.364     0.150
    38.043   431.054     0.150
    38.543   435.094     0.150
    38.728   436.454     0.150
    38.728   788.254     0.150
    38.885   439.254     0.150
    38.827   437.964     0.150
    38.914   442.779     0.150
    39.722   797.754     0.150
    39.722   446.354     0.150
    39.721   448.248     0.150
    39.844   446.924     0.150
    39.859   575.584     0.150
    39.859   449.404     0.150
    39.859   447.504     0.150
    39.859   450.154     0.150
    39.859   450.654     0.150
    39.859   449.904     0.150
    39.859    19.340     0.150
    39.859   574.244     0.150
    39.907   451.848     0.150
    39.907   451.690     0.150
    39.907   449.414     0.150
    39.907   450.954     0.150
    40.238   450.754     0.150
    40.238   450.584     0.150
    40.238   448.604     0.150
    40.238   450.254     0.150
    40.039   451.729     0.150
    40.039   805.029     0.150
    40.039   451.954     0.150
    40.039   451.354     0.150
    40.386   451.354     0.150
    40.695   453.454     0.150
    40.619   454.954     0.150
    41.000   803.454     0.150
    41.000   455.454     0.150
    41.011   455.354     0.150
    40.985   458.834     0.150
    41.054   803.654     0.150
    41.054   456.354     0.150
    41.182   802.754     0.150
    41.182   457.054     0.150
    41.245   457.874     0.150
    41.245   578.584     0.150
    41.325   460.354     0.150
    41.325   831.954     0.150
    41.764   461.954     0.150
    41.764   834.254     0.150
    41.740   461.354     0.150
    42.079   805.754     0.150
    42.187   468.944     0.150
    42.467   808.754     0.150
    42.467   467.254     0.150
    42.552   469.454     0.150
    42.552   583.054     0.150
    42.552   809.254     0.150
    42.664   809.754     0.150
    42.664   468.854     0.150
    42.747   474.954     0.150
    43.001   476.573     0.150
    43.001   476.362     0.150
    43.001   474.984     0.150
    43.001   475.954     0.150
    43.001   476.754     0.150
    43.867   478.554     0.150
    43.867   820.954     0.150
    44.914   487.454     0.150
    44.914   591.054     0.150
    44.914   818.754     0.150
    45.169   490.374     0.150
    45.169   488.185     0.150
    45.350   490.854     0.150
    45.350   592.554     0.150
    45.652   493.354     0.150
    45.413   496.948     0.150
    45.413   495.945     0.150
    45.413   492.685     0.150
    45.413   495.654     0.150
    45.413   497.054     0.150
    45.674   495.754     0.150
    45.784   496.264     0.150
    45.646   499.054     0.150
    45.646   498.737     0.150
    45.646   497.784     0.150
    46.419   501.435     0.150
    46.221   502.779     0.150
    46.221   502.198     0.150
    46.221   501.654     0.150
    46.709   500.979     0.150
    46.709   597.079     0.150
    47.237   505.895     0.150
    47.102   509.854     0.150
    47.102   509.545     0.150
    47.102   508.544     0.150
    47.102   507.654     0.150
    47.102    13.630     0.150
    47.325   513.231     0.150
    47.636   509.454     0.150
    47.636   600.354     0.150
    47.636   833.754     0.150
    47.636  1096.954     0.150
    47.369   514.187     0.150
    47.369   510.044     0.150
    47.369   513.054     0.150
    47.899   510.234     0.150
    47.899   601.704     0.150
    47.899   927.054     0.150
    48.037   511.344     0.150
    47.870   516.594     0.150
    48.442   514.574     0.150
    48.509   515.954     0.150
    48.490   515.554     0.150
    48.490   932.854     0.150
    48.490   951.954     0.150
    48.528   516.554     0.150
    48.474   516.254     0.150
    48.586   516.164     0.150
    48.645   516.114     0.150
    48.705   518.754     0.150
    48.755   517.254     0.150
    49.172   521.014     0.150
    49.172   521.254     0.150
    49.172   605.754     0.150
    49.172   836.314     0.150
    50.527   530.314     0.150
    51.280   541.574     0.150
    51.513   537.454     0.150
    51.884   540.554     0.150
    52.225   543.954     0.150
    52.225   616.754     0.150
    52.225   982.554     0.150
    52.291   544.534     0.150
    52.291   544.064     0.150
    52.291   545.510     0.150
    53.047   548.134     0.150
    53.047   548.814     0.150
    53.047   548.268     0.150
    53.047   620.479     0.150
    53.047   852.714     0.150
    53.047   549.234     0.150
    53.047   619.304     0.150
    53.047   853.444     0.150
    54.126   556.854     0.150
    54.126   624.754     0.150
    54.376   560.354     0.150
    54.376   626.054     0.150
    54.376   860.254     0.150
    54.376   560.164     0.150
    55.137   564.584     0.150
    55.137    14.851     0.150
    55.137   564.904     0.150
    55.160   564.254     0.150
    55.160  1022.754     0.150
    55.417   567.744     0.150
    55.417   568.583     0.150
    55.417  1024.020     0.150
    55.417   567.154     0.150
    55.377   570.069     0.150
    55.509   568.174     0.150
    55.509   629.274     0.150
    55.509   863.132     0.150
    55.509   568.354     0.150
    55.509   629.074     0.150
    55.509   862.444     0.150
    55.537   568.685     0.150
    55.537   567.764     0.150
    55.537   568.454     0.150
    55.537   568.244     0.150
    55.537   629.094     0.150
    55.950   574.584     0.150
    55.979   575.049     0.150
    55.979  1041.536     0.150
    56.125   571.954     0.150
    56.125   571.154     0.150
    56.100   572.544     0.150
    56.063   575.330     0.150
    56.179   573.294     0.150
    56.460   574.254     0.150
    56.584   575.454     0.150
    56.584   574.954     0.150
    56.556   578.715     0.150
    56.776   577.314     0.150
    56.776   577.654     0.150
    56.833   577.254     0.150
    56.880   580.457     0.150
    56.880   581.529     0.150
    56.909   581.207     0.150
    57.012   578.454     0.150
    57.055   582.238     0.150
    57.235   579.854     0.150
    57.324   581.414     0.150
    57.362   584.919     0.150
    57.470   585.292     0.150
    57.611   582.854     0.150
    57.669   583.254     0.150
    57.801   583.854     0.150
    58.026   584.954     0.150
    58.026   638.354     0.150
    58.026   585.514     0.150
    57.943   589.024     0.150
    58.146   585.854     0.150
    58.308   587.234     0.150
    58.308   640.384     0.150
    58.308   874.034     0.150
    58.263   587.494     0.150
    58.290   590.887     0.150
    58.387   588.596     0.150
    58.387   587.895     0.150
    58.387   588.054     0.150
    58.387   588.154     0.150
    58.387   589.414     0.150
    58.387   641.354     0.150
    58.355   591.072     0.150
    58.419   592.263     0.150
    58.478   592.634     0.150
    58.622   589.854     0.150
    58.324   591.395     0.150
    58.324   592.054     0.150
    58.324   592.354     0.150
    58.324   592.694     0.150
    58.324    14.390     0.150
    58.633   592.835     0.150
    58.633   592.970     0.150
    58.740   589.854     0.150
    58.740   589.904     0.150
    58.740   877.468     0.150
    58.740  2370.579     0.150
    58.740   590.334     0.150
    58.740   877.664     0.150
    58.697   594.238     0.150
    58.858   590.554     0.150
    58.858   590.844     0.150
    58.858   590.214     0.150
    58.858    14.730     0.150
    58.858   640.464     0.150
    58.791   594.754     0.150
    58.791   595.134     0.150
    59.172   593.194     0.150
    58.921   596.714     0.150
    58.921   595.354     0.150
    59.155   596.731     0.150
    59.240   597.343     0.150
    59.263   596.800     0.150
    59.263   596.948     0.150
    59.263   596.694     0.150
    59.263   596.554     0.150
    59.263   594.954     0.150
    59.265   597.419     0.150
    59.265   597.564     0.150
    59.268   597.479     0.150
    59.268   597.625     0.150
    59.268  1082.310     0.150
    59.427   595.424     0.150
    59.427   596.454     0.150
    59.346   596.942     0.150
    59.282   595.834     0.150
    59.282   598.154     0.150
    59.567   596.954     0.150
    59.485   598.874     0.150
    59.491   599.025     0.150
    59.563   601.404     0.150
    59.671   600.260     0.150
    59.722   600.922     0.150
    59.722   600.549     0.150
    59.866   598.154     0.150
    59.813   601.203     0.150
    59.834   601.660     0.150
    59.834   601.483     0.150
    59.965   598.854     0.150
    59.961   602.765     0.150
    59.961   602.217     0.150
    60.086   600.194     0.150
    60.087   602.676     0.150
    60.087   603.112     0.150
    60.188   600.754     0.150
    60.531   603.354     0.150
    60.591   602.754     0.150
    60.646   604.004     0.150
    60.646   648.904     0.150
    60.662   607.200     0.150
    60.686   607.596     0.150
    60.897   604.722     0.150
    60.897   604.554     0.150
    60.974   605.454     0.150
    60.974   605.854     0.150
    60.975   605.844     0.150
    60.975   606.004     0.150
    60.929   605.354     0.150
    62.007   616.185     0.150
    63.193   620.554     0.150
    63.193  1122.854     0.150
    63.193   620.424     0.150
    63.193   620.804     0.150
    63.305   621.104     0.150
    63.305   659.901     0.150
    63.353   621.454     0.150
    63.353   659.044     0.150
    63.353   621.284     0.150
    63.353    14.790     0.150
    63.353    20.790     0.150
    63.353   658.814     0.150
    63.609   626.845     0.150
    63.767   624.554     0.150
    64.376   628.554     0.150
    64.413   627.829     0.150
    64.413   663.654     0.150
    64.413  1135.554     0.150
    64.413  1214.079     0.150
    64.413   627.524     0.150
    64.532   629.954     0.150
    66.158   640.554     0.150
    66.659   647.954     0.150
    66.659   646.024     0.150
    66.492   647.679     0.150
    66.492   646.804     0.150
    66.492  2357.404     0.150
    66.492   647.310     0.150
    66.492   646.444     0.150
    66.492   647.854     0.150
    67.685   652.922     0.150
    67.685   652.494     0.150
    67.685   652.814     0.150
    67.685   651.954     0.150
    67.685   652.704     0.150
    67.685    13.890     0.150
    67.685    19.950     0.150
    67.685   679.654     0.150
    67.786   654.854     0.150
    67.786   655.524     0.150
    67.786    19.890     0.150
    68.203   653.079     0.150
    68.203  1186.804     0.150
    68.203  1245.379     0.150
    68.099   655.754     0.150
    68.657   659.764     0.150
    68.832   661.064     0.150
    68.832   660.604     0.150
    68.832   662.490     0.150
    68.832   661.354     0.150
    69.160   662.864     0.150
    69.160   662.454     0.150
    69.475   664.214     0.150
    69.538   665.444     0.150
    69.640   665.954     0.150
    69.640    14.580     0.150
    69.640   664.395     0.150
    69.640   665.754     0.150
    69.781   668.129     0.150
    69.781   667.884     0.150
    69.781   666.935     0.150
    69.781   665.754     0.150
    69.781   667.554     0.150
    69.781   668.324     0.150
    70.192   666.424     0.150
    71.927   674.948     0.150
    71.927   675.264     0.150
    71.927   675.114     0.150
    71.927   674.654     0.150
    71.927    15.399     0.150
    71.927   694.554     0.150
    71.927  1228.354     0.150
    71.927  1260.854     0.150
    71.927  1273.054     0.150
    71.927  1507.154     0.150
    72.131   678.554     0.150
    72.332   681.944     0.150
    72.332   683.337     0.150
    72.332   683.454     0.150
    73.134   685.054     0.150
    73.134   701.154     0.150
    73.134   845.954     0.150
    73.960   687.354     0.150
    73.960  1255.254     0.150
    74.285   692.145     0.150
    74.391   691.654     0.150
    74.391   690.391     0.150
    74.391   690.685     0.150
    74.517   693.050     0.150
    74.595   693.704     0.150
    74.595   693.084     0.150
    74.595   694.454     0.150
    74.595   694.062     0.150
    74.802   692.654     0.150
    74.802  1266.454     0.150
    74.837   694.454     0.150
    75.073   697.804     0.150
    75.073   697.414     0.150
    75.073   698.054     0.150
    75.073    14.760     0.150
    75.073    20.340     0.150
    75.489   697.954     0.150
    75.489   709.754     0.150
    75.489  1561.454     0.150
    75.489   697.754     0.150
    75.744   698.023     0.150
    75.744   698.354     0.150
    75.744   698.554     0.150
    76.304   705.794     0.150
    76.304   706.454     0.150
    76.304   707.054     0.150
    76.304   706.664     0.150
    76.304    20.120     0.150
    76.304   707.424     0.150
    76.541   704.194     0.150
    76.547   704.972     0.150
    77.263   709.854     0.150
    77.321   709.254     0.150
    77.321   708.654     0.150
    77.484   710.054     0.150
    77.553   710.444     0.150
    77.553   709.274     0.150
    77.553  1297.254     0.150
    77.553   710.754     0.150
    77.672   713.454     0.150
    77.771   711.154     0.150
    77.584   713.614     0.150
    78.105   715.954     0.150
    78.251   711.929     0.150
    78.223   717.554     0.150
    78.394   714.054     0.150
    78.488   717.854     0.150
    78.502   715.764     0.150
    78.502   717.754     0.150
    78.662   714.529     0.150
    78.662   714.754     0.150
    78.554   718.354     0.150
    78.555   716.214     0.150
    78.555   716.754     0.150
    78.555   717.354     0.150
    78.555   717.854     0.150
    78.675   717.094     0.150
    78.675   719.354     0.150
    78.722   716.484     0.150
    78.378   719.254     0.150
    78.777   716.704     0.150
    78.770   717.114     0.150
    78.791   719.654     0.150
    78.663   719.744     0.150
    78.799   719.454     0.150
    78.799   720.654     0.150
    79.026   719.334     0.150
    79.026   721.154     0.150
    79.119   718.554     0.150
    79.126   720.961     0.150
    78.931   720.804     0.150
    78.931   719.354     0.150
    78.931   721.054     0.150
    79.027   720.754     0.150
    79.393   719.654     0.150
    79.393   903.654     0.150
    79.393  1316.554     0.150
    79.687   721.454     0.150
    79.764   723.784     0.150
    80.711   724.895     0.150
    80.711   724.172     0.150
    80.711   724.454     0.150
    80.698   726.854     0.150
    80.475   729.194     0.150
    80.550   729.895     0.150
    81.121   729.154     0.150
    81.326   732.444     0.150
    81.326   732.254     0.150
    81.326   732.554     0.150
    81.361   731.054     0.150
    82.052   735.605     0.150
    82.079   736.098     0.150
    82.079  2329.423     0.150
    82.079   736.395     0.150
    82.079   737.014     0.150
    82.079   737.654     0.150
    82.079    14.351     0.150
    82.433   736.454     0.150
    82.191   738.895     0.150
    82.429   736.533     0.150
    82.429   736.854     0.150
    82.429   736.514     0.150
    82.429   736.754     0.150
    82.602   737.154     0.150
    82.751   738.454     0.150
    82.603   741.794     0.150
    83.095   740.155     0.150
    83.095   738.824     0.150
    83.095   740.534     0.150
    83.095    14.740     0.150
    83.095    20.200     0.150
    82.977   740.834     0.150
    83.265   740.454     0.150
    83.250   742.304     0.150
    83.250   743.274     0.150
    83.640   743.154     0.150
    84.023   748.364     0.150
    84.787   749.293     0.150
    85.149   750.054     0.150
    85.149  1370.954     0.150
    85.416   752.049     0.150
    85.486   752.169     0.150
    85.486   751.854     0.150
    85.745   755.324     0.150
    86.189   752.154     0.150
    86.427   754.454     0.150
    86.260   756.594     0.150
    86.402   754.129     0.150
    86.935   760.185     0.150
    86.920   758.914     0.150
    86.883   761.224     0.150
    86.883   760.874     0.150
    86.883   762.754     0.150
    86.883   762.054     0.150
    86.883   762.514     0.150
    87.150   761.478     0.150
    87.175   761.256     0.150
    87.319   761.473     0.150
    87.351   761.641     0.150
    87.424   762.171     0.150
    87.424   762.404     0.150
    87.470   761.954     0.150
    87.513   762.799     0.150
    87.833   762.084     0.150
    87.783   764.044     0.150
    87.812   764.685     0.150
    87.871   763.244     0.150
    87.913   764.800     0.150
    87.976   765.057     0.150
    87.995   765.375     0.150
    88.060   766.911     0.150
    88.146   766.107     0.150
    88.143   765.185     0.150
    88.199   767.126     0.150
    88.210   766.260     0.150
    88.333   765.811     0.150
    88.355   767.474     0.150
    88.343   765.284     0.150
    88.404   765.329     0.150
    88.404   973.529     0.150
    88.404   765.544     0.150
    88.404   765.754     0.150
    88.462   767.368     0.150
    88.518   769.440     0.150
    88.617   769.121     0.150
    88.628   769.564     0.150
    88.656   769.726     0.150
    88.692   767.874     0.150
    88.770   768.654     0.150
    88.884   769.397     0.150
    88.901   770.306     0.150
    88.902   769.661     0.150
    88.902   769.074     0.150
    88.902   769.554     0.150
    88.891   770.744     0.150
    88.952   769.426     0.150
    88.655   771.046     0.150
    88.976   770.958     0.150
    89.095   769.976     0.150
    89.105   770.926     0.150
    89.129   769.354     0.150
    89.229   771.090     0.150
    89.289   771.486     0.150
    89.360   772.070     0.150
    89.360   770.714     0.150
    89.557   771.979     0.150
    89.658   771.754     0.150
    89.838   773.329     0.150
    89.838   773.085     0.150
    89.874   774.235     0.150
    89.916   775.165     0.150
    89.930   772.964     0.150
    89.966   773.672     0.150
    90.141   773.884     0.150
    90.141   985.984     0.150
    90.141  1400.924     0.150
    90.141  1493.824     0.150
    90.141  1782.044     0.150
    90.143   775.205     0.150
    90.241   775.336     0.150
    90.241   775.464     0.150
    90.280   776.549     0.150
    90.280   776.364     0.150
    90.333   775.774     0.150
    90.579   776.154     0.150
    90.614   776.554     0.150
    90.741   775.645     0.150
    90.741   775.054     0.150
    90.819   778.324     0.150
    90.854   778.364     0.150
    90.854   777.762     0.150
    90.860   778.334     0.150
    91.085   775.854     0.150
    91.067   779.164     0.150
    91.109   780.785     0.150
    91.434   780.014     0.150
    91.528   782.404     0.150
    91.528   781.074     0.150
    91.621   779.944     0.150
    91.621   781.154     0.150
    91.621   781.054     0.150
    91.700   781.040     0.150
    91.979   780.654     0.150
    92.005   783.839     0.150
    92.044   783.810     0.150
    92.056   782.634     0.150
    92.146   782.814     0.150
    92.206   783.895     0.150
    92.178   784.948     0.150
    92.287   783.444     0.150
    92.282   783.694     0.150
    92.282   785.044     0.150
    92.374   785.214     0.150
    92.374   785.030     0.150
    92.450   785.145     0.150
    92.450   786.154     0.150
    92.453   785.634     0.150
    92.491   785.034     0.150
    92.528   784.614     0.150
    92.527   785.244     0.150
    92.527   785.354     0.150
    92.570   785.354     0.150
    92.638   786.354     0.150
    92.719   785.954     0.150
    93.009   788.264     0.150
    93.030   788.014     0.150
    93.171   788.594     0.150
    93.210   787.664     0.150
    93.382   788.344     0.150
    93.608   789.794     0.150
    93.637   790.044     0.150
    93.614   791.264     0.150
    93.614   791.154     0.150
    93.614   790.918     0.150
    93.737   790.924     0.150
    93.748   791.294     0.150
    93.802   792.395     0.150
    93.802   791.484     0.150
    93.819   791.645     0.150
    93.819   791.484     0.150
    93.917   790.554     0.150
    93.871   791.842     0.150
    94.227   792.834     0.150
    94.227   793.784     0.150
    94.388   793.145     0.150
    94.388   792.479     0.150
    94.388   792.874     0.150
    94.511   794.526     0.150
    94.511   794.834     0.150
    94.553   794.544     0.150
    94.644   794.564     0.150
    94.644   796.054     0.150
    94.872   796.654     0.150
    94.902   797.114     0.150
    94.916   797.594     0.150
    95.096   795.685     0.150
    95.120   798.814     0.150
    95.241   798.464     0.150
    95.312   798.074     0.150
    95.370   798.134     0.150
    95.373   799.114     0.150
    95.452   799.414     0.150
    95.625   800.044     0.150
    95.625   799.705     0.150
    95.625   799.454     0.150
    95.664   801.054     0.150
    95.701   800.685     0.150
    95.968   800.114     0.150
    96.163   801.254     0.150
    96.142   802.594     0.150
    96.198   802.854     0.150
    96.307   802.754     0.150
    96.459   804.214     0.150
    96.516   804.404     0.150
    96.543   804.694     0.150
    96.648   804.554     0.150
    96.687   803.424     0.150
    96.701   804.504     0.150
    96.746  1039.094     0.150
    96.993   804.645     0.150
    97.040   807.105     0.150
    97.040  1042.695     0.150
    97.178   805.484     0.150
    97.322   806.554     0.150
    97.388  1045.738     0.150
    97.398   807.624     0.150
    97.577   808.714     0.150
    97.577   809.654     0.150
    97.590   809.354     0.150
    97.636   809.072     0.150
    97.636  1046.375     0.150
    97.636   808.864     0.150
    97.662   809.334     0.150
    97.662   810.354     0.150
    97.822   807.994     0.150
    97.822   807.567     0.150
    97.793   809.314     0.150
    97.874   809.054     0.150
    97.894   808.474     0.150
    97.908   809.274     0.150
    97.939   809.094     0.150
    98.005   810.864     0.150
    97.993   810.313     0.150
    98.036   809.624     0.150
    98.218   810.004     0.150
    98.065   810.654     0.150
    98.065  1049.404     0.150
    98.065   809.744     0.150
    98.159   810.354     0.150
    98.159   811.654     0.150
    98.266   811.154     0.150
    98.383   811.114     0.150
    98.452   811.553     0.150
    98.479   812.104     0.150
    98.614   812.954     0.150
    98.692   812.714     0.150
    98.689   813.182     0.150
    98.689  1052.605     0.150
    98.757   813.304     0.150
    98.795   813.784     0.150
    98.808   814.474     0.150
    98.913   813.744     0.150
    99.135   814.314     0.150
    99.146   815.354     0.150
    99.259   815.574     0.150
    99.391   816.635     0.150
    99.434   816.340     0.150
    99.675   817.754     0.150
    99.675   816.954     0.150
    99.675   817.000     0.150
    99.675  1059.229     0.150
    99.681   817.683     0.150
    99.755  1060.790     0.150
   100.005  1064.484     0.150
   100.279   819.214     0.150
   100.766   824.454     0.150
   102.210   829.154     0.150
   102.481   828.634     0.150
   103.279   832.754     0.150
   103.975   834.554     0.150
   103.975  1093.804     0.150
   103.975  1789.054     0.150
   105.379   842.954     0.150
   105.433   841.904     0.150
   105.433   842.054     0.150
   106.591  1100.923     0.150
   107.957   852.954     0.150
   111.128  1148.704     0.150
   115.253  1115.494     0.150
   117.719  1119.904     0.150
   117.719  1743.854     0.150
   119.065  1122.604     0.150
   123.050  1130.804     0.150
   123.709  1131.824     0.150
   127.892  1140.554     0.150
   129.196  1144.474     0.150
   131.541  1148.629     0.150
   131.541  1350.129     0.150
   132.732  1148.204     0.150
   132.732  1351.504     0.150
   132.954  1149.954     0.150
   132.954  1352.404     0.150
   133.699  1150.629     0.150
   133.699  1353.529     0.150
   134.932  1152.754     0.150
   141.291  1165.914     0.150
   141.709  1167.104     0.150
   143.221  1168.054     0.150
   143.374  1168.694     0.150
   144.168  1169.679     0.150
   144.168  1385.923     0.150
   144.480  1170.685     0.150
   144.635  1172.874     0.150
   144.637  1171.784     0.150
   145.275  1172.874     0.150
   145.532  1175.464     0.150
   145.930  1176.504     0.150
   146.223  1174.664     0.150
   146.852  1177.054     0.150
   146.953  1175.464     0.150
   147.050  1175.264     0.150
   147.594  1178.054     0.150
   148.705  1184.284     0.150
   148.511  1179.244     0.150
   149.681  1180.734     0.150
   150.295  1180.154     0.150
   152.965  1184.714     0.150
   153.023  1185.114     0.150
   154.667  1187.904     0.150
   154.732  1186.904     0.150
   155.472  1191.554     0.150
   155.472  1217.929     0.150
   155.472  1188.694     0.150
   164.455  1198.104     0.150
     0.682    21.424     0.150
     0.800    26.523     0.150
     0.830    15.475     0.150
     0.938    18.023     0.150
     0.938    29.725     0.150
     0.970    18.125     0.150
     0.970    30.225     0.150
     1.009    18.824     0.150
     1.036    19.725     0.150
     1.036    33.023     0.150
     1.063    33.725     0.150
     1.088    20.424     0.150
     1.088    34.725     0.150
     1.105    20.023     0.150
     1.105    33.424     0.150
     1.099    20.523     0.150
     1.154    21.125     0.150
     1.154    36.824     0.150
     1.277    23.523     0.150
     1.304    23.725     0.150
     1.310    25.125     0.150
     1.362    24.225     0.150
     1.454    24.523     0.150
     1.454    40.924     0.150
     1.505    26.225     0.150
     1.505    43.725     0.150
     1.583    27.225     0.150
     1.644    28.824     0.150
     1.644    28.625     0.150
     1.644    47.824     0.150
     1.658    30.324     0.150
     1.856    32.523     0.150
     1.856    55.725     0.150
     1.875    31.023     0.150
     1.894    32.924     0.150
     2.025    34.023     0.150
     2.039    34.725     0.150
     2.176    35.924     0.150
     2.288    38.324     0.150
     2.668    42.725     0.150
     2.769    43.344     0.150
     2.769    74.225     0.150
     3.496    53.613     0.150
     3.496    91.943     0.150
     3.481    55.125     0.150
     3.541    52.965     0.150
     3.895    61.225     0.150
    10.701   153.084     0.150
    20.741   278.824     0.150
    29.023   359.000     0.150
    36.541   425.324     0.150
    39.995   453.924     0.150
    42.960   478.664     0.150
    56.645   577.023     0.150
    58.802   591.824     0.150
    63.366   623.621     0.150
    63.415   623.625     0.150
    68.263   655.375     0.150
    70.248   668.314     0.150
    75.548   699.145     0.150
   117.780  1122.205     0.150
   142.452  1168.693     0.150
   144.210  1172.299     0.150
   146.393  1176.684     0.150
   146.456  1176.504     0.150
   148.884  1182.785     0.150
     0.371    13.738     0.150
     0.550    11.037     0.150
     0.550    18.537     0.150
     0.597    11.637     0.150
     0.597    19.037     0.150
     0.582    11.738     0.150
     0.582    19.338     0.150
     0.665    13.037     0.150
     0.665    22.037     0.150
     0.665    13.037     0.150
     0.665    22.238     0.150
     0.974    18.537     0.150
     0.974    31.438     0.150
     0.991    19.238     0.150
     0.991    32.838     0.150
     1.100    21.238     0.150
     1.092    20.338     0.150
     1.092    35.637     0.150
     1.115    21.438     0.150
     1.115    35.537     0.150
     1.133    20.938     0.150
     1.133    36.838     0.150
     1.170    22.037     0.150
     1.170    37.037     0.150
     1.254    23.137     0.150
     1.254    39.738     0.150
     1.321    24.838     0.150
     1.362    24.637     0.150
     1.362    42.637     0.150
     1.382    25.537     0.150
     1.382    44.738     0.150
     1.371    24.738     0.150
     1.371    43.338     0.150
     1.471    26.738     0.150
     1.471    45.938     0.150
     1.499    46.338     0.150
     1.590    28.137     0.150
     1.590    47.938     0.150
     1.607    29.238     0.150
     1.607    49.137     0.150
     1.634    29.438     0.150
     1.634    51.238     0.150
     1.759    29.637     0.150
     1.759    54.238     0.150
     2.315    37.738     0.150
     2.315    66.537     0.150
     2.390    38.738     0.150
     2.390    68.938     0.150
     2.419    39.537     0.150
     2.419    69.637     0.150
     2.487    40.838     0.150
     2.487    71.838     0.150
     3.084    49.338     0.150
     3.084    85.838     0.150
     3.691    57.537     0.150
     3.691   101.338     0.150
     0.229     6.043     0.150
     0.229     9.242     0.150
     0.510    10.941     0.150
     0.510    17.441     0.150
     0.635    12.844     0.150
     0.635    20.742     0.150
     0.643    21.543     0.150
     0.662    13.141     0.150
     0.662    22.543     0.150
     0.780    15.543     0.150
     0.780    26.242     0.150
     0.830    16.141     0.150
     0.830    26.641     0.150
     0.899    17.242     0.150
     0.899    28.844     0.150
     0.976    19.043     0.150
     1.055    19.043     0.150
     1.145    20.141     0.150
     1.166    22.141     0.150
     1.205    22.043     0.150
     1.302    23.543     0.150
     1.361    25.344     0.150
     1.406    25.242     0.150
     1.513    27.543     0.150
     1.654    29.242     0.150
     1.830    31.543     0.150
     2.011    34.641     0.150
     2.324    38.543     0.150
     2.415    41.141     0.150
     0.714    15.102     0.150
     0.880    16.701     0.150
     0.964    31.201     0.150
     0.945    32.001     0.150
     0.937    32.501     0.150
     1.068    20.201     0.150
     1.068    34.301     0.150
     1.053    20.301     0.150
     1.053    34.201     0.150
     1.088    20.801     0.150
     1.088    36.102     0.150
     1.151    21.401     0.150
     1.120    21.602     0.150
     1.230    23.701     0.150
     1.230    40.801     0.150
     1.277    24.102     0.150
     1.233    22.801     0.150
     1.312    23.801     0.150
     1.456    26.801     0.150
     1.398    27.102     0.150
     1.455    27.401     0.150
     1.455    46.501     0.150
     1.507    27.501     0.150
     1.507    48.301     0.150
     1.508    28.301     0.150
     1.508    48.401     0.150
     1.741    30.001     0.150
     1.739    32.401     0.150
     1.739    55.201     0.150
     1.887    34.201     0.150
     1.887    58.301     0.150
     2.033    36.301     0.150
     2.242    38.901     0.150
     2.312    39.602     0.150
     2.526    42.501     0.150
     2.850    42.602     0.150
     2.968    46.102     0.150
     3.005    47.901     0.150
     3.201    49.901     0.150
     3.201    88.301     0.150
     3.124    52.602     0.150
     3.124    89.501     0.150
     3.425    54.501     0.150
     4.007    61.501     0.150
     4.583    72.501     0.150
     0.234     4.434     0.150
     0.213     5.035     0.150
     0.213     8.734     0.150
     0.301     6.035     0.150
     0.439     8.934     0.150
     0.445     9.336     0.150
     0.445    15.836     0.150
     0.471     9.535     0.150
     0.471    17.637     0.150
     0.491     9.434     0.150
     0.491    16.734     0.150
     0.590    11.637     0.150
     0.648    12.934     0.150
     0.787    15.637     0.150
     0.808    15.234     0.150
     0.808    26.734     0.150
     0.886    16.535     0.150
     0.886    28.137     0.150
     0.963    17.637     0.150
     1.195    21.836     0.150
     1.195    37.336     0.150
     1.202    22.734     0.150
     1.199    22.234     0.150
     1.199    38.234     0.150
     1.902    32.336     0.150
     2.442    39.734     0.150
     2.563    40.637     0.150
     2.901    45.535     0.150
     0.198     5.037     0.150
     0.198     8.137     0.150
     0.247     4.537     0.150
     0.305     6.237     0.150
     0.305    10.837     0.150
     0.497     9.537     0.150
     0.497    17.137     0.150
     0.475    10.637     0.150
     0.475    18.337     0.150
     0.548    11.837     0.150
     0.586    11.137     0.150
     0.586    19.437     0.150
     0.596    11.437     0.150
     0.605    10.037     0.150
     0.605    19.937     0.150
     0.614    13.337     0.150
     0.614    20.437     0.150
     0.629    21.237     0.150
     0.654    12.637     0.150
     0.798    16.037     0.150
     0.798    27.037     0.150
     0.882    15.337     0.150
     0.936    30.937     0.150
     0.967    18.537     0.150
     0.967    31.037     0.150
     1.031    18.937     0.150
     1.031    33.837     0.150
     1.190    21.537     0.150
     1.190    38.137     0.150
     1.200    21.637     0.150
     1.200    37.537     0.150
     1.204    23.137     0.150
     1.391    24.537     0.150
     1.478    24.937     0.150
     1.493    25.937     0.150
     1.906    33.737     0.150
     0.262     5.602     0.150
     0.098     2.203     0.150
     0.098     6.004     0.150
     0.282     5.703     0.150
     0.145     3.402     0.150
     0.143     4.203     0.150
     0.262     5.781     0.150
     0.262     6.004     0.150
     0.262    10.430     0.150
     0.428     7.805     0.150
     0.313     6.504     0.150
     0.404     8.504     0.150
     0.646    12.504     0.150
     0.646    22.102     0.150
     0.796    15.203     0.150
     0.650    13.203     0.150
     0.650    23.402     0.150
     0.613    11.504     0.150
     0.613    21.602     0.150
     0.654    12.102     0.150
     0.565    11.004     0.150
     0.565    20.703     0.150
     0.773    14.805     0.150
     0.933    16.504     0.150
     0.874    15.703     0.150
     0.874    30.004     0.150
     0.822    15.504     0.150
     0.931    17.703     0.150
     0.931    30.504     0.150
     0.824    15.902     0.150
     0.989    18.402     0.150
     0.989    33.004     0.150
     0.985    19.402     0.150
     1.291    23.703     0.150
     1.250    23.203     0.150
     1.388    24.504     0.150
     1.359    24.805     0.150
     1.299    24.102     0.150
     1.299    24.203     0.150
     1.456    26.203     0.150
     1.467    26.703     0.150
     1.467    47.203     0.150
     1.654    29.703     0.150
     1.827    31.902     0.150
     2.020    35.402     0.150
     2.005    34.203     0.150
     2.239    40.004     0.150
     2.529    47.203     0.150
     2.352    39.102     0.150
     2.596    43.504     0.150
     2.794    45.602     0.150
     2.660    44.402     0.150
     2.800    46.004     0.150
     2.831    46.203     0.150
     3.073    49.805     0.150
     3.089    49.004     0.150
     3.342    53.102     0.150
     3.253    50.602     0.150
     3.266    52.504     0.150
     3.376    53.203     0.150
     3.376    53.004     0.150
     3.397    53.402     0.150
     3.505    54.703     0.150
     3.586    55.902     0.150
     3.722    60.402     0.150
     3.832    61.902     0.150
     3.903    66.402     0.150
     4.015    63.402     0.150
     3.838    60.102     0.150
     3.857    60.102     0.150
     4.465    70.305     0.150
     4.566    68.805     0.150
     4.475    68.902     0.150
     4.477    69.504     0.150
     4.753    71.602     0.150
     4.578    70.805     0.150
     4.902    73.602     0.150
     5.000    74.805     0.150
     5.249    78.703     0.150
     5.675    84.004     0.150
     5.703    85.703     0.150
     5.886    88.305     0.150
     6.074    90.004     0.150
     6.213    92.305     0.150
     6.262    93.203     0.150
     6.450    96.102     0.150
     6.419    95.203     0.150
     6.568    96.504     0.150
     6.520    97.203     0.150
    18.642   256.715     0.150
    19.021   261.664     0.150
    21.072   284.027     0.150
    21.072   283.152     0.150
    22.758   300.703     0.150
    24.177   314.305     0.150
    26.422   336.602     0.150
    29.265   360.930     0.150
    29.265   547.203     0.150
    29.265   360.242     0.150
    30.525   372.555     0.150
    30.525   550.195     0.150
    37.169   429.793     0.150
    40.521   458.852     0.150
    40.521   458.395     0.150
    43.427   481.223     0.150
    52.606   550.074     0.150
    66.353   644.766     0.150
    67.670   656.582     0.150
    69.889   669.422     0.150
    76.110   706.879     0.150
    83.200   745.523     0.150
    83.200   745.312     0.150
     0.094     2.406     0.150
     0.094     5.906     0.150
     0.150     3.508     0.150
     0.156     4.211     0.150
     0.249     3.711     0.150
     0.249     7.711     0.150
     0.265     5.906     0.150
     0.277     5.711     0.150
     0.323     6.406     0.150
     0.323    12.312     0.150
     0.425     7.711     0.150
     0.413     8.406     0.150
     0.577    11.211     0.150
     0.577    20.812     0.150
     0.618    11.711     0.150
     0.640    11.812     0.150
     0.640    22.109     0.150
     0.658    12.406     0.150
     0.658    23.406     0.150
     0.650    12.609     0.150
     0.650    23.406     0.150
     0.773    15.312     0.150
     0.824    15.312     0.150
     0.824    27.906     0.150
     0.827    15.508     0.150
     0.870    15.609     0.150
     0.870    30.312     0.150
     0.926    16.812     0.150
     0.926    30.109     0.150
     0.996    18.312     0.150
     0.996    33.008     0.150
     0.994    19.406     0.150
     1.251    23.211     0.150
     1.306    25.211     0.150
     1.380    25.008     0.150
     1.477    26.906     0.150
     1.659    29.008     0.150
     1.659    52.406     0.150
     1.659    30.008     0.150
     1.830    32.211     0.150
     2.014    35.812     0.150
     2.012    35.906     0.150
     2.357    38.609     0.150
     2.521    41.008     0.150
     2.663    44.008     0.150
     2.787    51.406     0.150
     2.795    45.312     0.150
     2.834    47.008     0.150
     3.144    50.109     0.150
     3.226    52.508     0.150
     3.258    52.609     0.150
     3.272    52.406     0.150
     3.333    55.211     0.150
     3.378    54.312     0.150
     3.506    55.906     0.150
     3.585    56.312     0.150
     3.644    57.211     0.150
     3.894    61.906     0.150
     4.002    63.609     0.150
     4.481    69.609     0.150
     0.093     2.461     0.150
     0.093     6.461     0.150
     0.154     3.664     0.150
     0.169     4.461     0.150
     0.237     3.562     0.150
     0.237     8.461     0.150
     0.275     5.961     0.150
     0.270     6.258     0.150
     0.331     6.664     0.150
     0.420     7.961     0.150
     0.422     9.461     0.150
     0.588    11.359     0.150
     0.634    12.062     0.150
     0.622    11.961     0.150
     0.652    12.461     0.150
     0.659    12.758     0.150
     0.825    15.359     0.150
     0.868    15.859     0.150
     0.914    17.359     0.150
     0.920    17.758     0.150
     1.003    19.961     0.150
     1.001    18.758     0.150
     1.254    23.758     0.150
     1.284    23.461     0.150
     1.488    26.758     0.150
     1.666    29.164     0.150
     1.834    31.562     0.150
     2.007    34.062     0.150
     2.313    37.258     0.150
     2.363    39.258     0.150
     2.780    45.664     0.150
     2.788    45.461     0.150
     2.838    45.461     0.150
     3.128    49.758     0.150
     3.136    49.859     0.150
     3.264    51.062     0.150
     0.283     4.939     0.150
     0.337     6.139     0.150
     0.479     8.539     0.150
     0.479    16.340     0.150
     0.493     9.340     0.150
     0.493    16.539     0.150
     0.468     9.639     0.150
     0.611    11.719     0.150
     0.611    11.939     0.150
     0.663    11.939     0.150
     0.661    12.639     0.150
     0.661    22.539     0.150
     0.729    13.639     0.150
     0.821    14.840     0.150
     0.875    15.240     0.150
     0.794    16.510     0.150
     0.794    15.680     0.150
     0.794    26.559     0.150
     0.794    16.240     0.150
     1.010    18.439     0.150
     1.018    19.939     0.150
     1.126    20.740     0.150
     1.129    21.939     0.150
     1.217    23.340     0.150
     1.421    25.240     0.150
     1.364    25.639     0.150
     1.551    29.340     0.150
     1.551    28.240     0.150
     1.688    29.939     0.150
     1.632    30.240     0.150
     1.817    31.840     0.150
     1.931    34.240     0.150
     2.149    35.939     0.150
     2.140    37.539     0.150
     2.246    38.740     0.150
     2.549    42.139     0.150
     2.545    42.539     0.150
     2.558    42.439     0.150
     2.584    42.639     0.150
     2.636    43.340     0.150
     2.925    46.840     0.150
     2.956    49.139     0.150
     2.956    48.639     0.150
     3.146    50.639     0.150
     3.397    54.010     0.150
     3.397    54.439     0.150
     3.369    53.639     0.150
     3.408    54.840     0.150
     3.440    55.539     0.150
     3.504    56.340     0.150
     3.529    57.439     0.150
     3.521    57.639     0.150
     3.526    56.139     0.150
     3.598    58.240     0.150
     3.598    59.549     0.150
     3.598    55.219     0.150
     3.598    59.039     0.150
     3.598    57.939     0.150
     3.646    57.639     0.150
     3.692    58.639     0.150
     3.689    59.340     0.150
     3.752    58.340     0.150
     3.850    58.439     0.150
     3.847    60.840     0.150
     3.967    62.639     0.150
     4.158    64.840     0.150
     4.183    65.539     0.150
     4.283    66.539     0.150
     4.298    67.840     0.150
     4.407    66.939     0.150
     4.375    67.840     0.150
     4.425    69.139     0.150
     4.410    69.539     0.150
     4.598    70.139     0.150
     4.675    70.240     0.150
     4.736    74.240     0.150
     4.770    73.639     0.150
     4.769    74.539     0.150
     4.797    72.539     0.150
     4.857    72.939     0.150
     4.803    75.039     0.150
     4.803    76.549     0.150
     4.803    74.840     0.150
     4.877    73.939     0.150
     4.858    75.740     0.150
     4.969    77.039     0.150
     4.982    75.939     0.150
     5.169    80.340     0.150
     5.144    80.439     0.150
     5.285    80.539     0.150
     5.421    81.039     0.150
     5.463    88.039     0.150
     5.492    84.139     0.150
     5.508    86.340     0.150
     5.504    84.539     0.150
     5.618    86.240     0.150
     5.713    88.740     0.150
     5.663    86.240     0.150
     5.756    87.539     0.150
     5.902    88.840     0.150
     6.003    90.740     0.150
     6.170    93.939     0.150
     6.278    92.240     0.150
     6.426    96.240     0.150
     6.499    97.539     0.150
     6.567    98.240     0.150
     6.683   100.539     0.150
     6.723   101.340     0.150
     6.761   100.139     0.150
     6.896   100.939     0.150
     6.987   102.539     0.150
     7.203   109.439     0.150
     7.224   104.549     0.150
     7.224   108.840     0.150
     7.224   107.539     0.150
     7.291   110.439     0.150
     7.304   107.740     0.150
     7.360   108.539     0.150
     7.377   109.539     0.150
     7.539   112.340     0.150
     7.611   110.740     0.150
     7.648   114.439     0.150
     7.925   117.939     0.150
     7.990   117.939     0.150
     8.110   116.840     0.150
     8.068   121.840     0.150
     8.146   119.639     0.150
     8.221   120.439     0.150
     8.170   119.039     0.150
     8.189   118.840     0.150
     8.199   119.939     0.150
     8.260   121.939     0.150
     8.256   121.939     0.150
     8.267   121.539     0.150
     8.290   122.340     0.150
     8.509   124.039     0.150
     8.604   125.340     0.150
     8.606   127.240     0.150
     8.841   126.879     0.150
     8.803   128.439     0.150
     8.887   128.840     0.150
     8.872   128.740     0.150
     9.015   133.039     0.150
     9.109   133.639     0.150
     9.259   135.740     0.150
     9.262   134.439     0.150
     9.354   137.439     0.150
     9.402   138.639     0.150
     9.538   139.539     0.150
     9.566   137.740     0.150
     9.560   139.939     0.150
     9.566   137.740     0.150
     9.692   140.240     0.150
     9.723   140.439     0.150
     9.812   141.840     0.150
     9.877   142.539     0.150
     9.886   143.539     0.150
     9.927   144.639     0.150
     9.969   144.039     0.150
    10.023   144.740     0.150
    10.025   144.539     0.150
    10.133   146.840     0.150
    10.174   146.439     0.150
    10.225   147.139     0.150
    10.255   150.039     0.150
    10.701   153.740     0.150
    10.617   151.840     0.150
    10.819   156.639     0.150
    10.814   153.150     0.150
    10.814   157.039     0.150
    10.814   155.840     0.150
    10.997   157.840     0.150
    11.031   156.939     0.150
    11.099   157.139     0.150
    11.207   159.840     0.150
    11.289   161.840     0.150
    11.301   159.629     0.150
    11.301   294.080     0.150
    11.301   163.340     0.150
    11.562   165.840     0.150
    11.584   166.240     0.150
    11.681   164.139     0.150
    11.838   170.139     0.150
    11.850   166.639     0.150
    11.876   168.740     0.150
    11.993   170.939     0.150
    12.336   177.240     0.150
    12.343   172.740     0.150
    12.502   180.539     0.150
    12.505   174.340     0.150
    12.505   176.139     0.150
    12.505   174.039     0.150
    12.526   178.439     0.150
    12.548   175.299     0.150
    12.548   176.439     0.150
    12.548   177.139     0.150
    12.566   178.740     0.150
    12.548   177.564     0.150
    12.800   183.039     0.150
    12.784   183.539     0.150
    12.811   185.340     0.150
    12.811   185.479     0.150
    12.811   183.834     0.150
    12.811   182.658     0.150
    12.811   183.539     0.150
    12.777   178.840     0.150
    12.801   184.439     0.150
    12.851   183.939     0.150
    12.854   184.939     0.150
    12.926   185.539     0.150
    12.932   185.039     0.150
    12.913   182.240     0.150
    13.037   185.939     0.150
    13.055   186.939     0.150
    13.010   181.439     0.150
    13.075   187.240     0.150
    13.130   188.340     0.150
    13.113   183.039     0.150
    13.167   185.639     0.150
    13.195   183.240     0.150
    13.270   190.639     0.150
    13.271   186.039     0.150
    13.332   191.639     0.150
    13.350   191.240     0.150
    13.394   191.240     0.150
    13.432   191.740     0.150
    13.500   193.039     0.150
    13.574   193.939     0.150
    13.708   196.139     0.150
    13.699   196.639     0.150
    13.789   195.939     0.150
    13.919   199.139     0.150
    13.928   199.639     0.150
    13.922   194.840     0.150
    13.944   197.740     0.150
    13.957   200.539     0.150
    14.130   203.240     0.150
    14.151   201.539     0.150
    14.146   202.439     0.150
    14.250   203.139     0.150
    14.167   197.840     0.150
    14.350   204.539     0.150
    14.361   204.340     0.150
    14.422   205.840     0.150
    14.495   205.740     0.150
    14.554   207.139     0.150
    14.650   208.939     0.150
    14.671   208.340     0.150
    14.641   205.340     0.150
    14.654   206.439     0.150
    14.757   209.539     0.150
    14.825   209.939     0.150
    14.964   211.939     0.150
    15.047   213.439     0.150
    15.105   214.139     0.150
    15.066   210.539     0.150
    15.168   212.539     0.150
    15.168   213.039     0.150
    15.272   217.340     0.150
    15.299   217.439     0.150
    15.428   214.209     0.150
    15.428   217.439     0.150
    15.413   216.139     0.150
    15.469   220.039     0.150
    15.529   221.139     0.150
    15.585   222.039     0.150
    15.609   221.340     0.150
    15.781   225.439     0.150
    15.872   225.139     0.150
    15.907   223.139     0.150
    15.907   221.240     0.150
    15.907   223.840     0.150
    15.893   224.340     0.150
    15.995   220.539     0.150
    16.040   223.740     0.150
    16.166   229.439     0.150
    16.129   226.139     0.150
    16.162   226.939     0.150
    15.736   227.240     0.150
    16.298   228.539     0.150
    16.355   227.740     0.150
    16.497   233.439     0.150
    16.498   232.639     0.150
    16.642   233.939     0.150
    16.598   232.639     0.150
    16.775   234.229     0.150
    16.775   235.939     0.150
    17.014   236.539     0.150
    17.233   240.740     0.150
    17.063   238.340     0.150
    17.063   239.430     0.150
    17.282   241.740     0.150
    17.287   240.719     0.150
    17.287   238.340     0.150
    17.410   243.139     0.150
    17.390   239.039     0.150
    17.512   245.340     0.150
    17.451   241.240     0.150
    17.654   246.039     0.150
    17.595   242.939     0.150
    17.583   242.539     0.150
    17.640   243.139     0.150
    17.665   243.840     0.150
    17.794   244.139     0.150
    17.994   247.840     0.150
    18.485   254.539     0.150
    18.508   256.340     0.150
    18.846   257.070     0.150
    18.846   259.840     0.150
    18.713   260.639     0.150
    18.713   261.010     0.150
    18.713   258.209     0.150
    18.713   260.785     0.150
    18.713   476.150     0.150
    18.713   257.840     0.150
    18.956   261.740     0.150
    19.121   260.539     0.150
    19.088   262.400     0.150
    19.115   266.561     0.150
    19.526   267.840     0.150
    19.650   266.939     0.150
    19.660   267.840     0.150
    20.140   274.240     0.150
    20.338   278.840     0.150
    20.729   279.340     0.150
    21.251   286.039     0.150
    21.309   287.240     0.150
    21.331   287.240     0.150
    21.251   287.439     0.150
    21.251   287.840     0.150
    21.251   287.990     0.150
    21.251   288.139     0.150
    21.251   285.410     0.150
    21.373   288.740     0.150
    21.455   289.439     0.150
    21.593   288.340     0.150
    21.617   288.039     0.150
    21.710   288.689     0.150
    21.710   290.639     0.150
    21.819   290.740     0.150
    21.926   292.439     0.150
    22.033   294.539     0.150
    22.157   295.939     0.150
    22.442   297.740     0.150
    22.535   299.340     0.150
    22.584   297.879     0.150
    22.584   300.840     0.150
    22.457   302.939     0.150
    22.457   303.535     0.150
    22.457   301.240     0.150
    22.711   298.740     0.150
    22.898   302.539     0.150
    23.088   305.139     0.150
    22.988   306.340     0.150
    22.988   306.510     0.150
    22.988   303.740     0.150
    22.988   307.240     0.150
    22.988   305.639     0.150
    23.179   308.186     0.150
    23.179   307.139     0.150
    23.179   306.939     0.150
    23.142   301.740     0.150
    23.571   314.740     0.150
    23.571   310.129     0.150
    23.571   312.840     0.150
    24.081   312.740     0.150
    24.094   314.309     0.150
    24.094   313.939     0.150
    24.369   314.939     0.150
    24.449   319.740     0.150
    24.449   320.158     0.150
    24.449   317.969     0.150
    24.449   319.139     0.150
    25.217   330.475     0.150
    25.217   327.840     0.150
    25.450   326.189     0.150
    25.450   326.039     0.150
    25.582   327.740     0.150
    25.572   328.840     0.150
    25.593   328.939     0.150
    25.703   331.010     0.150
    25.984   334.439     0.150
    25.984   607.039     0.150
    25.984   332.939     0.150
    26.439   337.539     0.150
    26.449   337.639     0.150
    26.492   338.439     0.150
    26.492   334.170     0.150
    26.492   338.766     0.150
    26.492   335.990     0.150
    26.492   543.672     0.150
    26.492   334.570     0.150
    26.492   338.340     0.150
    26.317   340.158     0.150
    26.470   340.055     0.150
    26.769   338.740     0.150
    26.829   340.240     0.150
    26.829   340.949     0.150
    26.829   337.770     0.150
    26.829   339.639     0.150
    26.827   338.939     0.150
    27.069   342.240     0.150
    27.056   341.139     0.150
    27.199   343.539     0.150
    27.611   346.740     0.150
    27.516   350.539     0.150
    27.516   345.840     0.150
    27.516   347.939     0.150
    27.970   353.225     0.150
    27.970   354.459     0.150
    27.970   351.740     0.150
    28.657   353.859     0.150
    28.998   364.375     0.150
    28.998   365.270     0.150
    28.998   361.539     0.150
    29.308   365.189     0.150
    29.308   363.439     0.150
    29.470   366.115     0.150
    29.470   550.727     0.150
    29.470   362.789     0.150
    29.471   365.590     0.150
    29.471   365.939     0.150
    29.820   369.580     0.150
    29.820   368.229     0.150
    29.820   368.740     0.150
    30.492   373.199     0.150
    30.690   377.125     0.150
    30.690   376.189     0.150
    30.690   552.590     0.150
    30.690   677.340     0.150
    30.690   776.658     0.150
    30.690   552.699     0.150
    30.817   379.814     0.150
    30.817   375.449     0.150
    30.817   378.939     0.150
    30.817   377.740     0.150
    31.117   380.039     0.150
    31.117   684.740     0.150
    32.193   391.340     0.150
    32.193   703.340     0.150
    32.231   390.340     0.150
    32.231   705.039     0.150
    32.371   387.539     0.150
    32.896   391.920     0.150
    32.864   396.539     0.150
    32.864   831.939     0.150
    33.247   398.139     0.150
    33.230   398.539     0.150
    33.462   400.049     0.150
    33.462   396.430     0.150
    33.462   399.639     0.150
    33.669   404.340     0.150
    33.669   720.340     0.150
    33.665   402.240     0.150
    33.665   850.439     0.150
    34.320   408.096     0.150
    34.293   411.500     0.150
    34.293   407.939     0.150
    35.409   417.240     0.150
    35.409   753.240     0.150
    35.533   415.840     0.150
    35.533   415.039     0.150
    36.190   423.270     0.150
    36.412   424.840     0.150
    37.103   428.119     0.150
    37.126   511.900     0.150
    37.126   774.010     0.150
    37.260   435.084     0.150
    37.260   434.600     0.150
    37.260   430.990     0.150
    37.260   434.740     0.150
    37.260   432.840     0.150
    37.977   439.250     0.150
    37.977   438.539     0.150
    38.037   438.129     0.150
    38.037   441.340     0.150
    38.901   444.039     0.150
    39.414   450.240     0.150
    39.414   448.459     0.150
    39.414   448.840     0.150
    39.789   452.139     0.150
    40.206   459.240     0.150
    40.194   458.000     0.150
    40.194   455.439     0.150
    40.194   457.340     0.150
    40.194   580.664     0.150
    40.412   459.439     0.150
    40.445   456.439     0.150
    40.395   461.766     0.150
    40.395   460.629     0.150
    40.395   461.240     0.150
    40.395   458.939     0.150
    40.646   462.326     0.150
    40.646   461.889     0.150
    40.646   462.840     0.150
    40.646   461.139     0.150
    40.824   462.039     0.150
    40.824   830.340     0.150
    40.824   841.939     0.150
    41.615   469.039     0.150
    41.615   570.740     0.150
    41.615   845.539     0.150
    41.883   469.139     0.150
    42.931   482.439     0.150
    42.931   578.240     0.150
    42.931   863.439     0.150
    43.427   486.020     0.150
    43.427   484.240     0.150
    43.571   487.637     0.150
    43.571   487.229     0.150
    43.571   485.439     0.150
    43.988   879.039     0.150
    44.163   491.244     0.150
    44.333   491.539     0.150
    44.333   487.639     0.150
    44.718   493.840     0.150
    44.718   889.840     0.150
    44.737   491.840     0.150
    44.737   890.539     0.150
    45.836   503.926     0.150
    45.836   506.049     0.150
    45.836   505.340     0.150
    45.836   503.039     0.150
    46.378   504.039     0.150
    46.311   508.232     0.150
    46.311   506.539     0.150
    46.708   622.539     0.150
    46.708   914.939     0.150
    46.708  1101.439     0.150
    46.819   513.168     0.150
    46.819   511.139     0.150
    47.157   513.939     0.150
    47.157   514.250     0.150
    47.577   516.039     0.150
    47.577   931.039     0.150
    47.549   517.240     0.150
    47.549   930.939     0.150
    47.766   933.439     0.150
    47.766  1137.340     0.150
    47.821   514.889     0.150
    47.712   521.238     0.150
    47.712   521.039     0.150
    47.712   519.939     0.150
    47.839   522.672     0.150
    47.839   523.279     0.150
    47.839   521.039     0.150
    47.839   518.740     0.150
    48.055   520.299     0.150
    48.055   937.529     0.150
    47.977   523.172     0.150
    47.977   523.490     0.150
    47.977   519.939     0.150
    48.291   520.490     0.150
    48.336   522.539     0.150
    48.356   523.039     0.150
    48.435   527.170     0.150
    48.435   523.639     0.150
    48.712   529.750     0.150
    48.712   530.199     0.150
    48.976   527.389     0.150
    48.976   949.689     0.150
    50.363   537.979     0.150
    50.355   536.840     0.150
    51.291   981.539     0.150
    51.469   548.652     0.150
    51.469   545.289     0.150
    51.469   546.340     0.150
    52.233   550.699     0.150
    52.233   549.539     0.150
    52.233   549.139     0.150
    52.250   552.439     0.150
    52.290   551.740     0.150
    53.217  1008.539     0.150
    53.217  1014.439     0.150
    53.485   561.740     0.150
    53.485   684.740     0.150
    53.485   867.340     0.150
    54.357  1033.439     0.150
    54.568   568.539     0.150
    54.569   566.299     0.150
    54.569  2382.020     0.150
    54.569   566.119     0.150
    54.574   568.039     0.150
    54.597   566.150     0.150
    54.597   568.613     0.150
    54.597   567.740     0.150
    54.597   567.340     0.150
    54.695   567.090     0.150
    54.695   570.494     0.150
    54.695   569.439     0.150
    54.881   571.984     0.150
    55.230  1037.240     0.150
    55.230  1263.240     0.150
    55.553   698.439     0.150
    55.553  1046.240     0.150
    55.553  1265.939     0.150
    55.449   576.068     0.150
    55.530   577.062     0.150
    55.700   573.719     0.150
    55.700   574.889     0.150
    55.700   573.859     0.150
    55.715   576.639     0.150
    55.647   576.639     0.150
    55.947   575.840     0.150
    56.473   584.285     0.150
    56.547   583.979     0.150
    56.461   582.939     0.150
    56.776   584.639     0.150
    56.834   585.039     0.150
    56.965   585.639     0.150
    56.968   584.719     0.150
    57.078   586.139     0.150
    57.296   586.039     0.150
    57.377   586.389     0.150
    57.554   591.844     0.150
    57.770   591.939     0.150
    57.864   590.840     0.150
    57.864   590.340     0.150
    57.795   592.533     0.150
    57.983   589.969     0.150
    58.013   592.764     0.150
    58.158   591.240     0.150
    58.085   593.287     0.150
    58.379   592.760     0.150
    58.316   595.609     0.150
    58.739   598.367     0.150
    58.739   598.912     0.150
    58.747   598.891     0.150
    58.747   599.039     0.150
    58.747   597.840     0.150
    58.753   598.953     0.150
    58.754   599.080     0.150
    58.754   599.447     0.150
    59.107   601.639     0.150
    59.107   733.340     0.150
    59.107  1085.139     0.150
    59.107  1317.240     0.150
    59.162   601.521     0.150
    59.162   601.053     0.150
    59.209   602.387     0.150
    59.209   602.771     0.150
    59.328   603.455     0.150
    59.328   603.164     0.150
    59.230   603.139     0.150
    59.263   603.439     0.150
    59.476   601.889     0.150
    59.476   604.439     0.150
    59.676   602.240     0.150
    59.846   602.600     0.150
    59.997   605.139     0.150
    59.997  1333.439     0.150
    59.925   608.754     0.150
    59.925   607.340     0.150
    60.133   608.240     0.150
    60.079   606.049     0.150
    62.342   756.639     0.150
    62.342  1121.039     0.150
    62.342  1368.139     0.150
    62.430   619.389     0.150
    62.430  2370.564     0.150
    62.478   620.170     0.150
    62.478   622.504     0.150
    62.478   619.439     0.150
    62.846  1134.740     0.150
    63.508   627.490     0.150
    63.508  2368.889     0.150
    63.508   627.840     0.150
    63.751   633.840     0.150
    64.082   634.039     0.150
    64.818   638.139     0.150
    64.930   639.010     0.150
    66.551   647.814     0.150
    66.551  2365.314     0.150
    66.536   649.469     0.150
    66.536   651.840     0.150
    67.347   652.314     0.150
    67.347  2363.014     0.150
    67.399   658.840     0.150
    67.399   658.414     0.150
    67.399   657.639     0.150
    68.077   659.527     0.150
    68.721   666.240     0.150
    68.852   666.910     0.150
    68.852   665.840     0.150
    69.731   672.939     0.150
    69.781   672.865     0.150
    69.781   672.762     0.150
    69.781   672.139     0.150
    69.781   673.240     0.150
    69.877   672.840     0.150
    70.999   675.490     0.150
    70.999   676.039     0.150
    70.999     7.301     0.150
    70.999  1229.939     0.150
    71.107   677.289     0.150
    72.458   688.240     0.150
    72.458   706.439     0.150
    72.458   848.639     0.150
    72.458  1296.939     0.150
    73.270   688.740     0.150
    73.557   693.939     0.150
    73.557   692.090     0.150
    73.557   690.830     0.150
    73.991   695.439     0.150
    73.946   695.434     0.150
    73.946   695.939     0.150
    74.431   696.629     0.150
    74.652   697.033     0.150
    74.652   697.539     0.150
    74.652  1270.840     0.150
    74.652   699.240     0.150
    74.717   697.400     0.150
    75.537   706.539     0.150
    75.537   714.340     0.150
    75.537   869.539     0.150
    75.910   708.826     0.150
    75.993   709.064     0.150
    75.993   709.639     0.150
    75.993   708.139     0.150
    76.310   711.240     0.150
    76.310   711.783     0.150
    76.587   712.840     0.150
    76.640   709.414     0.150
    76.640   710.240     0.150
    76.640   710.939     0.150
    76.804   711.639     0.150
    76.864   712.258     0.150
    76.870  1301.639     0.150
    76.905   710.189     0.150
    76.908   710.580     0.150
    77.076   713.740     0.150
    77.076  1304.240     0.150
    77.152   714.090     0.150
    77.152   716.539     0.150
    77.321   713.465     0.150
    77.321   711.879     0.150
    77.321   714.539     0.150
    77.321   714.740     0.150
    77.616   716.039     0.150
    77.459   718.297     0.150
    77.459   717.139     0.150
    77.767   715.840     0.150
    78.007   720.740     0.150
    78.050   719.139     0.150
    78.075   718.514     0.150
    78.075   719.039     0.150
    78.075   718.139     0.150
    78.164   717.289     0.150
    78.164   719.039     0.150
    78.599   722.188     0.150
    78.723   901.439     0.150
    79.337   728.340     0.150
    79.775   725.350     0.150
    79.869   727.615     0.150
    79.931   727.219     0.150
    80.780   734.939     0.150
    80.780   733.139     0.150
    81.451   739.850     0.150
    81.689   740.240     0.150
    81.816   738.740     0.150
    81.822   739.383     0.150
    81.822   738.840     0.150
    81.822   739.039     0.150
    81.856   737.340     0.150
    81.788   738.039     0.150
    82.001   740.240     0.150
    82.045   739.479     0.150
    82.507   742.240     0.150
    82.971   748.740     0.150
    83.019   747.158     0.150
    83.019   744.680     0.150
    83.119   750.250     0.150
    83.119   750.039     0.150
    83.825   747.760     0.150
    83.741   748.369     0.150
    84.174   752.900     0.150
    84.366   752.939     0.150
    84.366   947.340     0.150
    84.366  1373.439     0.150
    84.711   753.508     0.150
    84.711   759.439     0.150
    84.711     3.699     0.150
    85.181   761.439     0.150
    85.181  1381.639     0.150
    85.529   755.209     0.150
    86.773   765.324     0.150
    86.857   766.326     0.150
    87.125   766.959     0.150
    87.160   767.266     0.150
    87.211   766.229     0.150
    87.211   769.240     0.150
    87.600   769.477     0.150
    87.600   767.020     0.150
    87.641   768.969     0.150
    87.648   767.939     0.150
    87.676   770.039     0.150
    87.683   767.664     0.150
    87.683   768.240     0.150
    87.691   767.740     0.150
    87.691   768.240     0.150
    87.691   769.441     0.150
    87.857   771.631     0.150
    88.239   772.791     0.150
    88.239   773.039     0.150
    88.239   773.119     0.150
    88.256   773.426     0.150
    88.289   772.990     0.150
    88.334   771.639     0.150
    88.420   771.939     0.150
    88.424   773.346     0.150
    88.447   774.459     0.150
    88.561   773.266     0.150
    88.696   773.639     0.150
    88.702   774.209     0.150
    88.702   775.512     0.150
    88.965   775.039     0.150
    89.175   777.477     0.150
    89.242   776.865     0.150
    89.386   777.469     0.150
    89.386   987.930     0.150
    89.386  1406.969     0.150
    89.386  1780.039     0.150
    89.586   779.162     0.150
    89.599   779.080     0.150
    89.615   775.779     0.150
    89.615   779.240     0.150
    89.561   779.982     0.150
    89.561   780.840     0.150
    89.859   780.539     0.150
    89.891   780.240     0.150
    89.898   780.340     0.150
    90.068   781.129     0.150
    90.220   781.639     0.150
    90.220   994.740     0.150
    90.678   784.664     0.150
    90.847   784.742     0.150
    90.881   785.180     0.150
    91.054   786.051     0.150
    91.375   787.436     0.150
    91.388   788.186     0.150
    91.206   787.736     0.150
    91.534   787.709     0.150
    91.755   787.840     0.150
    91.758   790.439     0.150
    91.585   789.977     0.150
    91.729   790.186     0.150
    92.679   790.729     0.150
    95.394   802.490     0.150
    96.227   810.596     0.150
    97.334   814.490     0.150
    97.257   811.350     0.150
    97.380   813.139     0.150
    97.472   815.039     0.150
    97.653   813.812     0.150
    97.903   816.939     0.150
    97.903   812.939     0.150
    97.903  1500.939     0.150
    99.016   820.957     0.150
    99.089   821.270     0.150
   100.562  1525.139     0.150
   100.562  1942.439     0.150
   103.112  1092.340     0.150
   103.112  1796.490     0.150
   110.549  1148.314     0.150
   111.238  1578.439     0.150
   111.238  2084.240     0.150
   116.828  1124.889     0.150
   116.828  1753.590     0.150
   128.522  1148.115     0.150
   128.522  1941.789     0.150
   131.960  1154.539     0.150
   131.960  1358.436     0.150
   131.960  1930.539     0.150
   132.482  1156.990     0.150
   132.482  1300.639     0.150
   132.482  1363.465     0.150
   132.807  1154.689     0.150
   132.807  1361.414     0.150
   141.377  1171.164     0.150
   141.377  1356.115     0.150
   143.533  1394.439     0.150
   144.161  1180.240     0.150
   144.904  1179.240     0.150
   146.589  1183.080     0.150
   154.320  1193.580     0.150
   154.320  1202.479     0.150
   154.320  1217.059     0.150
   154.320  1427.420     0.150
   156.399  1196.990     0.150
   156.399  1227.365     0.150
   156.399  1442.990     0.150
   159.689  1237.400     0.150
   164.984  1206.164     0.150
   176.995  1213.234     0.150
   177.508  1213.014     0.150
   177.508  1321.414     0.150
     0.119     3.016     0.150
     0.168     4.215     0.150
     0.168     7.215     0.150
     0.226     4.416     0.150
     0.264     5.115     0.150
     0.264     9.115     0.150
     0.362     7.615     0.150
     0.357     8.516     0.150
     0.395     8.215     0.150
     0.395    14.115     0.150
     0.438     9.115     0.150
     0.455     9.215     0.150
     0.455    15.816     0.150
     0.447     8.615     0.150
     0.447    16.115     0.150
     0.459     8.816     0.150
     0.459    16.016     0.150
     0.562    10.916     0.150
     0.563    11.016     0.150
     0.603    12.115     0.150
     0.603    20.115     0.150
     0.727    13.416     0.150
     0.748    14.016     0.150
     0.748    24.416     0.150
     0.815    15.715     0.150
     1.058    19.615     0.150
     1.133    21.316     0.150
     1.209    21.916     0.150
     1.420    25.516     0.150
     1.625    29.115     0.150
     1.825    31.215     0.150
     0.151     3.475     0.150
     0.192     4.273     0.150
     0.192     7.375     0.150
     0.192     4.475     0.150
     0.299     5.975     0.150
     0.345     7.074     0.150
     0.345    13.273     0.150
     0.369     7.174     0.150
     0.369    13.475     0.150
     0.384     8.975     0.150
     0.425     7.975     0.150
     0.425    15.475     0.150
     0.460     8.975     0.150
     0.460    15.975     0.150
     0.473     8.975     0.150
     0.473    16.674     0.150
     0.473     9.574     0.150
     0.533    10.375     0.150
     0.537    10.574     0.150
     0.566    11.674     0.150
     0.638    12.975     0.150
     0.692    12.674     0.150
     0.733    13.975     0.150
     0.847    16.875     0.150
     1.023    19.375     0.150
     1.175    21.773     0.150
     1.160    21.773     0.150
     1.215    22.875     0.150
     1.386    24.773     0.150
     1.660    29.674     0.150
     1.912    33.773     0.150
     2.561    40.975     0.150
     0.194     4.227     0.150
     0.197     4.625     0.150
     0.197     7.227     0.150
     0.291     5.727     0.150
     0.360     7.824     0.150
     0.360    13.523     0.150
     0.383     8.324     0.150
     0.383    14.023     0.150
     0.370     8.824     0.150
     0.427    15.227     0.150
     0.445     8.824     0.150
     0.445    15.227     0.150
     0.481     9.625     0.150
     0.481    16.023     0.150
     0.469     8.926     0.150
     0.547    10.426     0.150
     0.551    10.523     0.150
     0.532    12.125     0.150
     0.552    11.727     0.150
     0.649    12.125     0.150
     0.649    21.227     0.150
     0.630    11.926     0.150
     0.630    21.324     0.150
     0.697    13.125     0.150
     0.748    14.227     0.150
     0.748    24.426     0.150
     0.730    15.324     0.150
     0.847    15.926     0.150
     0.847    27.426     0.150
     1.032    19.727     0.150
     1.032    33.523     0.150
     1.178    20.926     0.150
     1.178    38.125     0.150
     1.146    21.523     0.150
     1.208    23.324     0.150
     1.396    25.125     0.150
     1.396    42.926     0.150
     1.656    29.625     0.150
     1.656    52.523     0.150
     1.795    31.125     0.150
     1.903    33.727     0.150
     2.095    36.426     0.150
     2.606    42.324     0.150
     3.097    50.426     0.150
     0.170     4.051     0.150
     0.170     7.453     0.150
     0.215     4.051     0.150
     0.215     8.750     0.150
     0.282     5.453     0.150
     0.282     9.551     0.150
     0.343     7.152     0.150
     0.374     8.051     0.150
     0.374    13.453     0.150
     0.377     8.051     0.150
     0.377    14.852     0.150
     0.446     8.652     0.150
     0.446    15.652     0.150
     0.452     8.953     0.150
     0.452    15.750     0.150
     0.453     8.953     0.150
     0.464     8.652     0.150
     0.541    10.652     0.150
     0.543    10.250     0.150
     0.532    11.551     0.150
     0.532    18.652     0.150
     0.560    11.652     0.150
     0.621    12.250     0.150
     0.621    21.453     0.150
     0.712    13.152     0.150
     0.729    13.750     0.150
     0.729    24.051     0.150
     0.825    15.750     0.150
     1.040    19.051     0.150
     1.040    33.852     0.150
     1.154    21.750     0.150
     1.154    38.352     0.150
     1.197    22.051     0.150
     1.401    25.152     0.150
     1.401    44.250     0.150
     1.639    28.852     0.150
     1.639    51.051     0.150
     1.895    34.652     0.150
     2.598    42.453     0.150
     0.122     2.906     0.150
     0.122     5.707     0.150
     0.141     3.008     0.150
     0.141     5.707     0.150
     0.174     4.008     0.150
     0.210     4.207     0.150
     0.210     8.008     0.150
     0.285     5.605     0.150
     0.285    10.406     0.150
     0.344     7.105     0.150
     0.373     7.605     0.150
     0.373    13.707     0.150
     0.378     8.406     0.150
     0.442     8.508     0.150
     0.442    15.508     0.150
     0.456     9.309     0.150
     0.456    15.707     0.150
     0.457     9.207     0.150
     0.463     8.906     0.150
     0.463    15.707     0.150
     0.540    10.008     0.150
     0.540    18.605     0.150
     0.542    10.707     0.150
     0.534    11.605     0.150
     0.561    11.105     0.150
     0.624    12.008     0.150
     0.708    13.105     0.150
     0.731    13.605     0.150
     0.829    15.906     0.150
     0.829    27.207     0.150
     1.037    19.309     0.150
     1.051    20.105     0.150
     1.154    22.008     0.150
     1.192    22.105     0.150
     1.200    22.309     0.150
     1.398    24.906     0.150
     1.643    29.707     0.150
     1.898    32.605     0.150
     2.601    45.508     0.150
     0.600    12.238     0.150
     0.600    20.938     0.150
     0.740    14.238     0.150
     0.740    24.637     0.150
     0.860    16.238     0.150
     0.860    27.938     0.150
     0.888    16.438     0.150
     0.888    28.438     0.150
     0.934    17.035     0.150
     0.934    29.535     0.150
     0.959    17.836     0.150
     0.959    31.238     0.150
     0.992    18.035     0.150
     0.992    31.438     0.150
     1.028    18.637     0.150
     1.028    32.336     0.150
     1.025    31.637     0.150
     1.097    19.438     0.150
     1.097    33.738     0.150
     1.196    21.738     0.150
     1.229    22.137     0.150
     1.229    38.910     0.150
     1.229    21.938     0.150
     1.231    23.035     0.150
     1.318    22.137     0.150
     1.318    38.535     0.150
     1.360    24.035     0.150
     1.360    42.637     0.150
     1.367    24.637     0.150
     1.438    22.438     0.150
     1.411    24.836     0.150
     1.421    25.137     0.150
     1.421    44.137     0.150
     1.503    25.535     0.150
     1.503    44.836     0.150
     1.530    24.836     0.150
     1.608    26.438     0.150
     1.608    46.137     0.150
     1.607    26.535     0.150
     1.608    26.238     0.150
     1.608    45.637     0.150
     1.594    27.637     0.150
     1.643    28.035     0.150
     1.643    49.438     0.150
     1.822    29.035     0.150
     1.826    30.438     0.150
     1.969    32.336     0.150
     1.994    31.637     0.150
     2.158    33.137     0.150
     2.255    35.738     0.150
     2.338    37.137     0.150
     2.441    37.836     0.150
     2.646    40.035     0.150
     2.658    42.238     0.150
     2.986    44.238     0.150
     3.055    47.637     0.150
     3.088    46.035     0.150
     3.156    49.535     0.150
     3.238    50.238     0.150
     3.458    52.137     0.150
     3.461    52.438     0.150
     3.488    51.328     0.150
     3.488    54.438     0.150
     3.513    53.137     0.150
     3.540    55.035     0.150
     3.558    53.238     0.150
     3.669    55.738     0.150
     3.761    55.836     0.150
     3.907    59.637     0.150
     4.402    67.035     0.150
     4.715    70.238     0.150
     7.101   102.098     0.150
    10.701   151.059     0.150
    16.226   222.148     0.150
    17.161   235.387     0.150
    20.776   277.363     0.150
    20.776   276.938     0.150
    26.904   334.316     0.150
    27.370   337.336     0.150
    29.053   355.941     0.150
    29.053   543.359     0.150
    29.053   355.066     0.150
    30.174   365.887     0.150
    30.174   546.180     0.150
    30.174   365.488     0.150
    35.755   412.547     0.150
    40.044   451.336     0.150
    58.727   589.188     0.150
    63.292   621.387     0.150
    67.474   647.941     0.150
    70.182   665.438     0.150
    70.182   665.355     0.150
   144.151  1169.520     0.150
     0.120     2.453     0.150
     0.120     5.156     0.150
     0.180     3.656     0.150
     0.180     6.656     0.150
     0.204     3.555     0.150
     0.204     6.953     0.150
     0.290     5.555     0.150
     0.290    10.258     0.150
     0.343     6.758     0.150
     0.381     7.453     0.150
     0.436     8.156     0.150
     0.436    15.258     0.150
     0.461     8.555     0.150
     0.461    16.055     0.150
     0.462     9.758     0.150
     0.462    16.156     0.150
     0.463     7.953     0.150
     0.463    15.758     0.150
     0.537    11.055     0.150
     0.538    11.852     0.150
     0.563    11.852     0.150
     0.629    12.555     0.150
     0.703    12.953     0.150
     0.731    24.453     0.150
     0.738    15.453     0.150
     1.157    21.758     0.150
     1.394    25.055     0.150
     1.648    29.758     0.150
     1.903    33.453     0.150
     0.146     3.021     0.150
     0.146     6.521     0.150
     0.183     3.021     0.150
     0.183     8.422     0.150
     0.212     4.621     0.150
     0.212     7.521     0.150
     0.300     5.422     0.150
     0.300    10.721     0.150
     0.367     7.621     0.150
     0.367    11.721     0.150
     0.386     7.922     0.150
     0.386    12.121     0.150
     0.371     7.621     0.150
     0.416     7.820     0.150
     0.416    14.422     0.150
     0.438     7.820     0.150
     0.480     9.422     0.150
     0.480    16.121     0.150
     0.495     9.521     0.150
     0.548    10.521     0.150
     0.552    10.922     0.150
     0.536    11.221     0.150
     0.551    11.422     0.150
     0.638    12.221     0.150
     0.755    14.121     0.150
     0.859    16.820     0.150
     0.928    17.621     0.150
     1.025    18.820     0.150
     1.050    20.221     0.150
     1.145    21.521     0.150
     1.179    22.121     0.150
     1.167    20.820     0.150
     1.217    22.621     0.150
     1.390    24.820     0.150
     1.667    30.121     0.150
     1.785    30.521     0.150
     1.910    34.422     0.150
     2.508    41.922     0.150
     2.557    42.521     0.150
     2.612    43.320     0.150
     2.922    50.922     0.150
     3.102    50.820     0.150
     0.107     2.410     0.150
     0.164     3.410     0.150
     0.164     6.410     0.150
     0.182     3.309     0.150
     0.199     4.410     0.150
     0.312     6.012     0.150
     0.336     7.012     0.150
     0.358     7.012     0.150
     0.396     7.609     0.150
     0.414     8.211     0.150
     0.469     8.609     0.150
     0.469    15.512     0.150
     0.477     9.211     0.150
     0.477    16.012     0.150
     0.486    10.109     0.150
     0.521     9.910     0.150
     0.525     9.910     0.150
     0.557    11.309     0.150
     0.577    11.512     0.150
     0.643    11.609     0.150
     0.651    13.109     0.150
     0.680    12.609     0.150
     0.725    13.512     0.150
     0.756    15.410     0.150
     0.857    16.512     0.150
     0.951    18.512     0.150
     1.010    19.012     0.150
     1.163    21.910     0.150
     1.171    21.309     0.150
     1.228    24.109     0.150
     1.373    24.410     0.150
     1.672    29.910     0.150
     1.925    34.809     0.150
     0.113     1.953     0.150
     0.113     4.953     0.150
     0.174     3.750     0.150
     0.174     6.156     0.150
     0.150     2.953     0.150
     0.207     3.656     0.150
     0.334     6.656     0.150
     0.292     5.555     0.150
     0.292    10.555     0.150
     0.364     7.352     0.150
     0.388     7.656     0.150
     0.438     8.250     0.150
     0.438    15.453     0.150
     0.454     8.953     0.150
     0.454    16.055     0.150
     0.462     9.055     0.150
     0.531    10.156     0.150
     0.533    10.156     0.150
     0.543    12.352     0.150
     0.570    11.750     0.150
     0.631    12.156     0.150
     0.721    13.352     0.150
     0.721    24.250     0.150
     0.745    15.156     0.150
     1.164    21.953     0.150
     1.164    39.352     0.150
     1.206    22.852     0.150
     1.390    24.656     0.150
     1.390    44.352     0.150
     1.648    29.656     0.150
     1.648    51.750     0.150
     1.905    34.656     0.150
     2.609    43.656     0.150
     0.111     2.141     0.150
     0.111     4.844     0.150
     0.201     3.445     0.150
     0.153     2.945     0.150
     0.180     3.641     0.150
     0.335     6.641     0.150
     0.335    12.742     0.150
     0.363     7.141     0.150
     0.363    13.547     0.150
     0.297     5.445     0.150
     0.297    10.445     0.150
     0.432     8.047     0.150
     0.432    15.344     0.150
     0.389     8.242     0.150
     0.460     8.844     0.150
     0.460    16.047     0.150
     0.528    10.047     0.150
     0.531     9.844     0.150
     0.468     8.844     0.150
     0.471     8.641     0.150
     0.471    15.844     0.150
     0.546    11.445     0.150
     0.572    11.742     0.150
     0.662    12.242     0.150
     0.662    21.844     0.150
     0.636    11.945     0.150
     0.697    12.547     0.150
     0.697    22.742     0.150
     0.722    13.344     0.150
     0.722    24.141     0.150
     0.793    14.344     0.150
     0.747    14.344     0.150
     0.942    18.141     0.150
     1.025    18.641     0.150
     1.063    20.742     0.150
     1.169    20.445     0.150
     1.181    21.141     0.150
     1.165    21.344     0.150
     1.165    39.344     0.150
     1.212    22.844     0.150
     1.386    24.445     0.150
     1.386    44.242     0.150
     1.540    28.844     0.150
     1.540    28.844     0.150
     1.537    28.547     0.150
     1.537    51.047     0.150
     1.641    30.141     0.150
     1.654    29.547     0.150
     1.654    52.547     0.150
     1.795    30.844     0.150
     1.795    57.547     0.150
     1.910    33.945     0.150
     2.109    37.641     0.150
     2.242    38.945     0.150
     2.336    41.141     0.150
     2.554    44.047     0.150
     2.566    42.047     0.150
     2.513    41.945     0.150
     2.539    42.945     0.150
     2.613    43.742     0.150
     2.932    50.242     0.150
     2.932    92.344     0.150
     2.879    46.945     0.150
     2.956    47.344     0.150
     2.956    86.445     0.150
     2.927    48.141     0.150
     3.108    50.141     0.150
     3.165    55.141     0.150
     3.165    97.242     0.150
     3.354    59.141     0.150
     3.503    58.344     0.150
     3.483    56.445     0.150
     3.511    55.945     0.150
     3.620    59.242     0.150
     3.620   112.844     0.150
     3.586    57.844     0.150
     3.632    57.547     0.150
     3.653    58.344     0.150
     3.713    60.844     0.150
     3.794    58.844     0.150
     3.948    61.945     0.150
     4.109    64.641     0.150
     4.109    76.742     0.150
     4.287    66.945     0.150
     4.749    71.742     0.150
     4.744    73.344     0.150
     4.839    75.242     0.150
     4.991    76.844     0.150
     6.645   103.242     0.150
    21.276   286.672     0.150
    26.393   337.195     0.150
    29.485   363.516     0.150
    30.720   375.195     0.150
    40.690   460.742     0.150
    76.101   708.016     0.150
    81.779   737.977     0.150
    83.138   745.961     0.150
     0.070     1.906     0.150
     0.070     3.703     0.150
     0.150     2.602     0.150
     0.150     5.305     0.150
     0.201     3.805     0.150
     0.283     5.602     0.150
     0.283    10.305     0.150
     0.282     5.406     0.150
     0.282     9.703     0.150
     0.318     6.305     0.150
     0.350     7.008     0.150
     0.326     6.508     0.150
     0.408     8.008     0.150
     0.438     9.805     0.150
     0.517    10.008     0.150
     0.524    10.203     0.150
     0.538    10.203     0.150
     0.564    10.703     0.150
     0.559    12.703     0.150
     0.603    11.406     0.150
     0.619    12.805     0.150
     0.650    12.102     0.150
     0.650    21.406     0.150
     0.782    14.102     0.150
     0.771    15.305     0.150
     1.077    19.805     0.150
     1.188    21.406     0.150
     1.205    22.805     0.150
     1.423    25.102     0.150
     1.575    28.102     0.150
     1.575    48.906     0.150
     0.119     2.578     0.150
     0.119     5.273     0.150
     0.149     3.273     0.150
     0.149     6.180     0.150
     0.191     4.180     0.150
     0.191     8.180     0.150
     0.194     3.680     0.150
     0.194     7.375     0.150
     0.346     6.977     0.150
     0.370     7.680     0.150
     0.370    13.680     0.150
     0.383     7.875     0.150
     0.426     8.273     0.150
     0.426    15.375     0.150
     0.459     8.078     0.150
     0.459    16.578     0.150
     0.472     9.273     0.150
     0.535    10.375     0.150
     0.538    10.375     0.150
     0.542     9.578     0.150
     0.564    12.180     0.150
     0.636    12.875     0.150
     0.694    12.578     0.150
     0.694    22.680     0.150
     0.733    13.680     0.150
     1.025    18.773     0.150
     1.158    20.375     0.150
     1.387    24.578     0.150
     1.387    44.078     0.150
     1.658    30.180     0.150
     1.791    30.773     0.150
     2.563    42.875     0.150
     0.122     2.914     0.150
     0.141     3.016     0.150
     0.141     6.016     0.150
     0.171     3.914     0.150
     0.171     7.211     0.150
     0.213     4.312     0.150
     0.284     5.617     0.150
     0.284    10.211     0.150
     0.342     7.211     0.150
     0.373     7.711     0.150
     0.379     8.312     0.150
     0.445     8.711     0.150
     0.445    15.711     0.150
     0.453     9.117     0.150
     0.455     9.016     0.150
     0.465     8.914     0.150
     0.465    16.117     0.150
     0.540    10.516     0.150
     0.542    10.516     0.150
     0.534    11.414     0.150
     0.561    11.617     0.150
     0.622    12.016     0.150
     0.622    21.414     0.150
     0.673    12.414     0.150
     0.710    13.016     0.150
     0.710    22.914     0.150
     0.729    13.711     0.150
     0.735    14.211     0.150
     0.804    15.016     0.150
     0.930    18.914     0.150
     1.038    19.211     0.150
     1.155    21.414     0.150
     1.155    38.516     0.150
     1.182    21.812     0.150
     1.194    21.812     0.150
     1.399    25.016     0.150
     1.399    43.711     0.150
     1.640    29.617     0.150
     1.640    51.414     0.150
     1.808    31.117     0.150
     1.897    34.914     0.150
     2.567    44.312     0.150
     2.579    44.617     0.150
     2.600    44.312     0.150
     3.095    50.414     0.150
     3.178    50.617     0.150
     0.121     2.867     0.150
     0.143     3.062     0.150
     0.143     5.266     0.150
     0.175     3.961     0.150
     0.175     7.164     0.150
     0.209     4.266     0.150
     0.287     5.664     0.150
     0.287    10.062     0.150
     0.343     7.062     0.150
     0.372     7.664     0.150
     0.380     8.266     0.150
     0.441     8.562     0.150
     0.441    15.562     0.150
     0.457     8.961     0.150
     0.459     8.961     0.150
     0.464     8.766     0.150
     0.464    16.062     0.150
     0.538    10.461     0.150
     0.541    10.461     0.150
     0.536    11.562     0.150
     0.562    11.664     0.150
     0.625    11.961     0.150
     0.706    12.867     0.150
     0.706    22.867     0.150
     0.730    13.664     0.150
     0.737    14.062     0.150
     0.931    18.867     0.150
     1.035    18.961     0.150
     1.156    21.266     0.150
     1.156    39.461     0.150
     1.190    21.461     0.150
     1.190    38.062     0.150
     1.353    24.961     0.150
     1.396    24.961     0.150
     1.396    43.562     0.150
     1.644    29.461     0.150
     1.644    51.664     0.150
     1.900    34.867     0.150
     0.111     2.391     0.150
     0.111     5.195     0.150
     0.154     3.094     0.150
     0.154     5.891     0.150
     0.198     3.492     0.150
     0.183     3.891     0.150
     0.299     5.594     0.150
     0.336     6.891     0.150
     0.362     7.289     0.150
     0.390     6.789     0.150
     0.429     8.289     0.150
     0.429    15.094     0.150
     0.463     9.094     0.150
     0.463    16.289     0.150
     0.470     8.992     0.150
     0.470    16.289     0.150
     0.471     9.195     0.150
     0.528    10.289     0.150
     0.530    10.195     0.150
     0.547    11.992     0.150
     0.572    12.094     0.150
     0.638    12.195     0.150
     0.694    12.492     0.150
     0.723    13.492     0.150
     0.943    18.992     0.150
     1.023    18.789     0.150
     1.178    21.391     0.150
     1.166    22.391     0.150
     1.214    23.594     0.150
     1.384    24.594     0.150
     1.384    44.289     0.150
     1.656    29.789     0.150
     1.656    52.695     0.150
     1.792    30.891     0.150
     1.912    34.492     0.150
     2.615    43.594     0.150
     3.110    50.695     0.150
     3.162    52.391     0.150
     0.153     3.520     0.150
     0.174     3.820     0.150
     0.174     6.820     0.150
     0.147     3.223     0.150
     0.147     5.621     0.150
     0.231     4.621     0.150
     0.231     8.422     0.150
     0.304     6.121     0.150
     0.385     7.922     0.150
     0.400     8.223     0.150
     0.362     8.422     0.150
     0.407     7.121     0.150
     0.421     8.621     0.150
     0.488     9.520     0.150
     0.516     9.922     0.150
     0.559    11.020     0.150
     0.565    10.422     0.150
     0.531    11.820     0.150
     0.620    11.320     0.150
     0.640    12.621     0.150
     0.682    12.223     0.150
     0.773    14.621     0.150
     0.921    17.820     0.150
     1.026    19.320     0.150
     1.134    21.723     0.150
     1.347    24.820     0.150
     1.393    25.223     0.150
     1.675    30.621     0.150
     1.911    35.020     0.150
     2.612    43.121     0.150
     0.159     3.326     0.150
     0.159     6.126     0.150
     0.134     3.326     0.150
     0.134     5.126     0.150
     0.187     3.226     0.150
     0.187     6.126     0.150
     0.223     4.626     0.150
     0.223     7.626     0.150
     0.291     5.726     0.150
     0.291     9.726     0.150
     0.352     7.426     0.150
     0.352    12.926     0.150
     0.389     7.326     0.150
     0.389    12.426     0.150
     0.408     8.326     0.150
     0.408    12.826     0.150
     0.420     8.126     0.150
     0.420    14.826     0.150
     0.416     8.426     0.150
     0.416    14.826     0.150
     0.475     9.726     0.150
     0.475    16.126     0.150
     0.509     9.926     0.150
     0.509    17.226     0.150
     0.520    11.726     0.150
     0.568    11.426     0.150
     0.573    11.226     0.150
     0.628    11.726     0.150
     0.695    12.526     0.150
     1.038    18.326     0.150
     1.125    20.326     0.150
     1.172    21.026     0.150
     1.405    24.826     0.150
     1.662    29.726     0.150
     1.898    34.326     0.150
     2.600    41.726     0.150
     3.150    49.326     0.150
     0.147     2.932     0.150
     0.115     2.832     0.150
     0.166     3.730     0.150
     0.230     4.531     0.150
     0.259     5.432     0.150
     0.365     7.332     0.150
     0.353     8.031     0.150
     0.398     7.832     0.150
     0.463     8.932     0.150
     0.445     7.230     0.150
     0.434     8.332     0.150
     0.453     8.932     0.150
     0.508    11.031     0.150
     0.565    10.631     0.150
     0.567    10.332     0.150
     0.598    12.131     0.150
     0.732    13.432     0.150
     0.710    13.432     0.150
     0.750    14.031     0.150
     0.811    15.332     0.150
     1.130    20.730     0.150
     1.214    21.932     0.150
     1.175    21.230     0.150
     1.424    25.932     0.150
     1.502    27.332     0.150
     1.620    29.730     0.150
     1.620    50.332     0.150
     1.872    34.332     0.150
     2.575    43.332     0.150
     3.431    52.932     0.150
     0.143     3.020     0.150
     0.137     2.920     0.150
     0.191     3.520     0.150
     0.207     4.420     0.150
     0.207     8.120     0.150
     0.291     5.620     0.150
     0.291    10.320     0.150
     0.371     7.720     0.150
     0.363     8.320     0.150
     0.393     8.720     0.150
     0.424     8.120     0.150
     0.424    15.220     0.150
     0.433     8.320     0.150
     0.433    15.420     0.150
     0.471     9.220     0.150
     0.471    16.620     0.150
     0.492     9.420     0.150
     0.527    11.420     0.150
     0.555    10.720     0.150
     0.560    11.320     0.150
     0.628    12.020     0.150
     0.642    21.220     0.150
     0.696    12.120     0.150
     0.724    14.120     0.150
     0.760    14.220     0.150
     0.760    25.120     0.150
     0.919    18.020     0.150
     1.035    18.820     0.150
     1.137    21.720     0.150
     1.176    20.820     0.150
     1.176    37.620     0.150
     1.208    23.220     0.150
     1.399    24.720     0.150
     1.399    44.820     0.150
     1.658    30.320     0.150
     1.901    34.020     0.150
     0.137     3.078     0.150
     0.137     5.977     0.150
     0.195     4.180     0.150
     0.195     7.680     0.150
     0.135     2.977     0.150
     0.135     6.078     0.150
     0.199     4.180     0.150
     0.199     6.781     0.150
     0.286     5.578     0.150
     0.364     7.180     0.150
     0.388     7.977     0.150
     0.365     8.078     0.150
     0.432     8.375     0.150
     0.464     9.180     0.150
     0.442     8.477     0.150
     0.552    10.578     0.150
     0.556    10.680     0.150
     0.527    11.375     0.150
     0.527    11.227     0.150
     0.527    17.906     0.150
     0.547    11.477     0.150
     0.625    12.078     0.150
     0.652    12.078     0.150
     0.702    12.578     0.150
     0.751    14.078     0.150
     0.725    13.875     0.150
     0.785    14.477     0.150
     0.921    18.477     0.150
     1.037    18.875     0.150
     1.188    21.375     0.150
     1.141    21.281     0.150
     1.183    21.281     0.150
     1.203    22.375     0.150
     1.401    24.680     0.150
     1.530    28.477     0.150
     1.530    28.680     0.150
     1.518    28.078     0.150
     1.623    29.375     0.150
     1.651    29.375     0.150
     1.800    30.078     0.150
     1.898    34.180     0.150
     2.233    38.977     0.150
     2.497    41.680     0.150
     2.529    41.781     0.150
     2.563    44.281     0.150
     2.572    41.875     0.150
     2.600    42.477     0.150
     2.861    45.578     0.150
     2.937    47.875     0.150
     2.913    47.078     0.150
     3.092    50.180     0.150
     3.164    49.977     0.150
     3.508    54.578     0.150
     3.499    55.477     0.150
     3.574    55.781     0.150
     3.624    57.680     0.150
     3.620    56.477     0.150
     3.714    59.180     0.150
     3.774    58.977     0.150
     4.084    63.375     0.150
     4.731    72.281     0.150
     4.826    74.680     0.150
     5.621    87.375     0.150
     6.646   100.578     0.150
    21.273   285.555     0.150
    29.479   363.078     0.150
    29.479   548.695     0.150
    30.718   375.016     0.150
    40.691   460.680     0.150
    57.754   589.734     0.150
    83.160   743.844     0.150
     0.063     2.205     0.150
     0.285     6.405     0.150
     0.285    11.505     0.150
     0.285     6.305     0.150
     0.285    11.705     0.150
     0.469     9.405     0.150
     0.469    16.305     0.150
     0.599    12.805     0.150
     0.599    21.205     0.150
     0.592    12.604     0.150
     0.592    20.905     0.150
     0.646    12.705     0.150
     0.646    22.505     0.150
     0.681    13.305     0.150
     0.681    24.805     0.150
     0.757    15.205     0.150
     0.809    16.205     0.150
     0.816    16.205     0.150
     0.862    16.905     0.150
     0.862    31.005     0.150
     0.929    18.305     0.150
     0.971    19.104     0.150
     0.971    33.505     0.150
     0.978    18.305     0.150
     0.978    32.604     0.150
     1.002    21.005     0.150
     1.136    21.405     0.150
     1.147    21.005     0.150
     1.147    38.104     0.150
     1.162    22.005     0.150
     1.269    22.205     0.150
     1.269    40.505     0.150
     1.338    24.405     0.150
     1.338    42.905     0.150
     1.355    24.305     0.150
     1.379    24.604     0.150
     1.379    43.604     0.150
     1.456    27.205     0.150
     1.463    26.705     0.150
     1.463    46.104     0.150
     1.555    28.705     0.150
     1.685    30.104     0.150
     1.711    30.505     0.150
     1.710    29.405     0.150
     1.710    52.905     0.150
     1.726    31.805     0.150
     1.934    34.505     0.150
     0.238     4.898     0.150
     0.240     5.102     0.150
     0.240     8.398     0.150
     0.243     5.398     0.150
     0.243     9.195     0.150
     0.266     5.602     0.150
     0.266     9.695     0.150
     0.320     6.500     0.150
     0.320    11.500     0.150
     0.350     7.398     0.150
     0.350    13.195     0.150
     0.406     8.297     0.150
     0.410     8.797     0.150
     0.410    15.398     0.150
     0.556    11.000     0.150
     0.556    19.297     0.150
     0.567    11.297     0.150
     0.567    20.398     0.150
     0.579    11.500     0.150
     0.579    20.195     0.150
     0.605    12.297     0.150
     0.629    11.695     0.150
     0.629    21.602     0.150
     0.654    12.398     0.150
     0.654    21.297     0.150
     0.758    16.297     0.150
     0.869    16.000     0.150
     0.937    17.602     0.150
     1.490    26.102     0.150
     1.490    45.297     0.150
     1.495    27.102     0.150
     1.495    46.500     0.150
     1.813    32.102     0.150
     0.120     3.078     0.150
     0.120     5.578     0.150
     0.146     3.178     0.150
     0.146     5.779     0.150
     0.181     4.078     0.150
     0.181     7.078     0.150
     0.217     4.479     0.150
     0.269     5.678     0.150
     0.368     7.279     0.150
     0.355     7.379     0.150
     0.397     7.879     0.150
     0.397    15.078     0.150
     0.450     8.578     0.150
     0.450    15.979     0.150
     0.439     8.078     0.150
     0.446     8.678     0.150
     0.468     9.279     0.150
     0.513    10.578     0.150
     0.537    11.379     0.150
     0.563    11.479     0.150
     0.566    10.879     0.150
     0.608    12.078     0.150
     0.608    20.779     0.150
     0.720    12.578     0.150
     0.755    14.279     0.150
     0.755    24.578     0.150
     0.825    15.678     0.150
     1.330    24.578     0.150
     1.633    29.279     0.150
     1.818    30.779     0.150
     1.881    34.678     0.150
     3.182    50.078     0.150
     0.206     4.453     0.150
     0.206     9.555     0.150
     0.242     4.953     0.150
     0.242    10.852     0.150
     0.404     7.852     0.150
     0.404    14.953     0.150
     0.404     7.852     0.150
     0.404    14.953     0.150
     0.396     8.555     0.150
     0.453     8.852     0.150
     0.453    16.555     0.150
     0.515    11.258     0.150
     0.581    11.453     0.150
     0.700    12.953     0.150
     0.700    24.156     0.150
     0.719    13.156     0.150
     0.702    13.258     0.150
     0.818    14.453     0.150
     0.794    15.258     0.150
     0.866    18.453     0.150
     0.866    18.258     0.150
     0.908    17.758     0.150
     1.050    20.758     0.150
     1.111    20.156     0.150
     1.116    20.852     0.150
     1.138    21.258     0.150
     1.138    37.953     0.150
     1.242    22.453     0.150
     1.242    39.656     0.150
     1.254    22.555     0.150
     1.254    39.656     0.150
     1.254    23.258     0.150
     1.331    24.453     0.150
     1.384    25.352     0.150
     1.476    26.258     0.150
     1.508    27.055     0.150
     1.556    28.055     0.150
     1.703    29.758     0.150
     1.669    30.055     0.150
     1.742    30.852     0.150
     1.765    31.055     0.150
     1.893    32.258     0.150
     1.853    32.352     0.150
     1.910    34.156     0.150
     1.948    32.375     0.150
     1.948    56.523     0.150
     1.948    32.852     0.150
     1.917    34.555     0.150
     1.991    33.352     0.150
     2.052    35.555     0.150
     2.143    36.258     0.150
     2.183    36.656     0.150
     2.236    35.766     0.150
     2.236    62.781     0.150
     2.236    37.453     0.150
     2.248    37.156     0.150
     2.270    37.758     0.150
     2.406    39.055     0.150
     2.509    41.758     0.150
     2.789    45.555     0.150
     2.942    47.555     0.150
     3.350    52.656     0.150
     3.353    52.953     0.150
     3.461    54.758     0.150
     3.529    55.156     0.150
     5.308    80.156     0.150
     5.754    85.258     0.150
     5.818    83.633     0.150
     5.818    86.156     0.150
     9.394   133.922     0.150
    28.209   352.461     0.150
    29.528   363.805     0.150
    39.586   451.203     0.150
    39.586   450.086     0.150
    42.249   471.453     0.150
    58.359   593.273     0.150
    58.359   592.734     0.150
    89.999   778.688     0.150
     0.126     3.562     0.150
     0.126     6.258     0.150
     0.165     3.758     0.150
     0.165     7.562     0.150
     0.195     3.961     0.150
     0.195     7.961     0.150
     0.220     4.961     0.150
     0.283     6.461     0.150
     0.283    11.359     0.150
     0.344     6.664     0.150
     0.395     8.062     0.150
     0.395    14.664     0.150
     0.410     8.562     0.150
     0.410    16.062     0.150
     0.427     8.461     0.150
     0.427    15.562     0.150
     0.508    10.258     0.150
     0.508    17.758     0.150
     0.511    12.164     0.150
     0.523    10.164     0.150
     0.576    11.359     0.150
     0.576    19.961     0.150
     0.581    11.461     0.150
     0.619    12.562     0.150
     0.703    13.359     0.150
     0.703    23.258     0.150
     0.706    12.562     0.150
     0.783    14.758     0.150
     0.783    25.859     0.150
     0.902    17.562     0.150
     1.046    19.359     0.150
     1.117    20.164     0.150
     1.117    34.664     0.150
     1.413    42.562     0.150
     1.501    25.859     0.150
     1.525    27.258     0.150
     1.525    27.562     0.150
     1.608    27.664     0.150
     1.655    29.961     0.150
     1.800    31.164     0.150
     2.084    35.062     0.150
     2.212    38.164     0.150
     2.331    37.562     0.150
     2.573    42.359     0.150
     2.592    42.461     0.150
     0.088     2.994     0.150
     0.088     6.494     0.150
     0.198     4.195     0.150
     0.198     8.195     0.150
     0.183     4.395     0.150
     0.183     7.494     0.150
     0.209     5.096     0.150
     0.209     9.695     0.150
     0.258     6.195     0.150
     0.258    10.295     0.150
     0.277     5.596     0.150
     0.277    10.895     0.150
     0.277     6.295     0.150
     0.277    11.020     0.150
     0.366     7.295     0.150
     0.422     7.494     0.150
     0.382     7.994     0.150
     0.382    14.395     0.150
     0.449     9.395     0.150
     0.444     8.596     0.150
     0.444    16.395     0.150
     0.628    12.395     0.150
     0.628    21.994     0.150
     0.627    12.096     0.150
     0.627    20.895     0.150
     0.647    12.295     0.150
     0.647    11.994     0.150
     0.647    21.596     0.150
     0.757    24.994     0.150
     0.771    15.395     0.150
     0.791    14.795     0.150
     0.791    26.596     0.150
     0.841    15.895     0.150
     0.846    16.295     0.150
     0.846    28.596     0.150
     0.851    15.994     0.150
     0.851    29.895     0.150
     0.893    16.596     0.150
     0.893    29.295     0.150
     0.914    16.395     0.150
     0.914    29.695     0.150
     0.898    16.994     0.150
     0.898    29.494     0.150
     1.029    18.994     0.150
     1.029    33.695     0.150
     1.020    19.295     0.150
     1.020    34.994     0.150
     1.076    20.895     0.150
     1.076    35.695     0.150
     1.250    41.994     0.150
     1.285    23.395     0.150
     1.328    25.596     0.150
     1.328    42.195     0.150
     1.364    23.795     0.150
     1.511    27.395     0.150
     1.511    46.994     0.150
     1.659    29.695     0.150
     1.659    50.395     0.150
     1.674    29.994     0.150
     1.834    30.295     0.150
     1.996    33.295     0.150
     2.249    36.695     0.150
     2.369    39.195     0.150
     2.369    70.795     0.150
     2.838    44.895     0.150
     3.304    51.795     0.150
     3.289    52.195     0.150
     3.354    51.795     0.150
     3.501    53.994     0.150
     4.059    63.395     0.150
    21.107   284.221     0.150
    29.295   362.533     0.150
    30.562   373.645     0.150
    40.563   459.445     0.150
    66.287   645.252     0.150
     0.181     3.406     0.150
     0.181     6.906     0.150
     0.152     2.805     0.150
     0.152     6.203     0.150
     0.208     4.406     0.150
     0.208     8.406     0.150
     0.357     7.203     0.150
     0.357    14.008     0.150
     0.414     7.906     0.150
     0.414    14.805     0.150
     0.304     5.602     0.150
     0.304    10.805     0.150
     0.379     8.008     0.150
     0.539    10.305     0.150
     0.543    10.602     0.150
     0.543    18.008     0.150
     0.448     7.906     0.150
     0.448    15.305     0.150
     0.490     9.305     0.150
     0.490    16.703     0.150
     0.637    11.406     0.150
     0.637    21.203     0.150
     0.543    11.156     0.150
     0.543    11.305     0.150
     0.684    12.305     0.150
     0.684    22.305     0.150
     0.745    13.906     0.150
     0.745    25.203     0.150
     0.642    11.906     0.150
     0.642    22.203     0.150
     0.769    13.805     0.150
     0.769    25.305     0.150
     0.740    13.703     0.150
     0.740    25.406     0.150
     1.020    18.508     0.150
     1.020    33.906     0.150
     0.936    17.508     0.150
     1.172    20.703     0.150
     1.172    37.906     0.150
     1.058    20.203     0.150
     1.058    36.305     0.150
     1.154    21.102     0.150
     1.154    39.203     0.150
     1.187    22.602     0.150
     1.187    40.805     0.150
     1.221    23.008     0.150
     1.384    24.602     0.150
     1.384    44.305     0.150
     1.360    24.602     0.150
     1.534    27.602     0.150
     1.534    49.906     0.150
     1.548    27.906     0.150
     1.548    28.008     0.150
     1.639    29.508     0.150
     1.782    30.703     0.150
     1.669    29.703     0.150
     1.669    53.102     0.150
     1.915    34.008     0.150
     2.194    36.305     0.150
     2.106    36.008     0.150
     2.111    36.008     0.150
     2.319    40.102     0.150
     2.319    71.406     0.150
     2.251    38.008     0.150
     2.545    41.508     0.150
     2.554    41.805     0.150
     2.514    41.508     0.150
     2.547    41.406     0.150
     2.618    43.008     0.150
     2.919    47.008     0.150
     2.938    51.406     0.150
     2.877    46.508     0.150
     2.930    46.805     0.150
     3.146    55.008     0.150
     3.109    50.008     0.150
     3.353    52.102     0.150
     3.353    53.102     0.150
     3.490    57.906     0.150
     3.368    52.805     0.150
     3.605    56.508     0.150
     3.517    56.102     0.150
     3.520    56.602     0.150
     3.696    57.102     0.150
     3.696   113.008     0.150
     3.592    56.703     0.150
     3.592    97.836     0.150
     3.592    57.703     0.150
     3.637    56.508     0.150
     3.654    57.305     0.150
     3.817    61.102     0.150
     3.790    58.305     0.150
     3.872    61.508     0.150
     3.953    62.305     0.150
     4.078    63.406     0.150
     4.241    68.602     0.150
     4.295    66.406     0.150
     4.295   118.008     0.150
     4.359    77.508     0.150
     4.720    71.805     0.150
     4.769    70.555     0.150
     4.769    73.906     0.150
     4.747    74.305     0.150
     4.748    72.602     0.150
     4.843    75.305     0.150
     5.232    81.906     0.150
     5.603    86.805     0.150
     6.628   101.508     0.150
     7.208   105.383     0.150
     9.139   131.625     0.150
    10.792   156.305     0.150
    21.291   286.930     0.150
    21.291   286.344     0.150
    23.003   303.703     0.150
    23.937   312.555     0.150
    26.365   333.758     0.150
    26.365   333.531     0.150
    29.497   364.281     0.150
    29.504   363.742     0.150
    30.736   376.156     0.150
    30.736   552.805     0.150
    30.736   375.414     0.150
    40.709   461.328     0.150
    40.709   460.445     0.150
    43.626   484.242     0.150
    54.420   566.109     0.150
    57.741   589.688     0.150
    66.399   647.758     0.150
    67.229   652.281     0.150
    81.761   737.625     0.150
    83.169   744.648     0.150
     0.186     6.027     0.150
     0.269     4.426     0.150
     0.269     9.328     0.150
     0.357     6.129     0.150
     0.357    11.629     0.150
     0.369     6.578     0.150
     0.369     6.426     0.150
     0.369    13.426     0.150
     0.477     8.926     0.150
     0.477    16.629     0.150
     0.488     9.227     0.150
     0.476     9.629     0.150
     0.512    10.129     0.150
     0.508     9.926     0.150
     0.508    16.129     0.150
     0.611    12.129     0.150
     0.611    19.527     0.150
     0.606    11.328     0.150
     0.606    20.727     0.150
     0.686    13.227     0.150
     0.686    21.926     0.150
     0.701    13.227     0.150
     0.802    15.227     0.150
     0.824    15.629     0.150
     0.911    16.926     0.150
     0.926    17.328     0.150
     0.942    17.527     0.150
     1.051    20.027     0.150
     1.057    19.828     0.150
     1.083    20.828     0.150
     1.148    22.629     0.150
     1.330    24.527     0.150
     1.554    28.629     0.150
     1.634    29.426     0.150
     1.585    29.129     0.150
     1.631    29.426     0.150
     1.978    34.629     0.150
     2.034    35.828     0.150
     2.744    46.129     0.150
     2.907    48.426     0.150
     2.986    48.957     0.150
     2.986    49.727     0.150
     6.616    99.848     0.150
    20.648   281.254     0.150
    22.373   300.438     0.150
    23.167   309.355     0.150
    23.836   312.836     0.150
    26.883   340.977     0.150
    26.883   340.348     0.150
    28.859   360.078     0.150
    30.092   371.277     0.150
    30.092   370.977     0.150
    30.433   375.828     0.150
    33.706   402.848     0.150
    40.069   456.953     0.150
    40.069   457.289     0.150
    42.984   481.898     0.150
    54.802   569.402     0.150
    58.272   594.953     0.150
    58.272   595.098     0.150
    69.885   671.637     0.150
    82.793   747.145     0.150
     0.110     3.305     0.150
     0.152     3.305     0.150
     0.152     6.906     0.150
     0.191     4.805     0.150
     0.191     9.105     0.150
     0.224     3.906     0.150
     0.224     7.906     0.150
     0.287     6.707     0.150
     0.294     6.805     0.150
     0.294    10.906     0.150
     0.336     6.805     0.150
     0.336    12.605     0.150
     0.399     7.707     0.150
     0.399    14.305     0.150
     0.397     7.605     0.150
     0.397    13.906     0.150
     0.450     9.508     0.150
     0.473     9.305     0.150
     0.610    11.906     0.150
     0.610    21.508     0.150
     0.616    11.805     0.150
     0.616    21.406     0.150
     0.600    11.707     0.150
     0.600    19.906     0.150
     0.671    13.105     0.150
     0.749    13.605     0.150
     0.749    25.605     0.150
     0.812    15.707     0.150
     0.816    14.906     0.150
     0.783    15.305     0.150
     0.795    15.305     0.150
     0.795    26.906     0.150
     0.896    16.508     0.150
     0.896    29.008     0.150
     0.880    16.605     0.150
     0.880    30.508     0.150
     0.922    17.805     0.150
     0.998    18.605     0.150
     0.998    33.207     0.150
     1.029    19.406     0.150
     1.099    20.508     0.150
     1.099    36.406     0.150
     1.263    23.207     0.150
     1.273    23.406     0.150
     1.340    24.305     0.150
     1.340    25.508     0.150
     1.437    24.105     0.150
     1.515    25.805     0.150
     1.515    49.008     0.150
     1.636    27.406     0.150
     1.636    50.105     0.150
     1.690    31.008     0.150
     1.855    31.805     0.150
     1.981    32.508     0.150
     1.981    62.008     0.150
     2.046    34.406     0.150
     2.269    37.508     0.150
     2.393    38.508     0.150
     2.387    39.105     0.150
     2.621    42.207     0.150
     2.754    43.207     0.150
     2.764    43.805     0.150
     2.860    44.805     0.150
     3.110    47.707     0.150
     3.099    48.707     0.150
     3.296    51.105     0.150
     0.495     8.914     0.150
     0.495    16.422     0.150
     0.517    16.297     0.150
     0.487     9.496     0.150
     0.487    17.395     0.150
     0.591    10.395     0.150
     0.591    17.496     0.150
     0.571    11.297     0.150
     0.627    12.094     0.150
     0.648    11.797     0.150
     0.653    11.797     0.150
     0.635    11.895     0.150
     0.635    22.195     0.150
     0.672    12.297     0.150
     0.697    13.996     0.150
     0.801    15.254     0.150
     0.832    15.695     0.150
     0.832    26.496     0.150
     0.821    15.395     0.150
     0.821    27.996     0.150
     0.822    15.594     0.150
     0.822    28.395     0.150
     0.852    16.797     0.150
     0.852    28.996     0.150
     0.895    16.895     0.150
     0.948    17.395     0.150
     0.870    16.195     0.150
     0.982    18.094     0.150
     0.982    32.695     0.150
     1.038    20.094     0.150
     1.084    21.297     0.150
     1.182    22.496     0.150
     1.182    41.395     0.150
     1.175    21.695     0.150
     1.175    39.094     0.150
     1.215    22.996     0.150
     1.215    40.094     0.150
     1.199    23.297     0.150
     1.216    22.695     0.150
     1.216    21.496     0.150
     1.412    26.094     0.150
     1.499    26.996     0.150
     1.496    27.594     0.150
     1.496    47.594     0.150
     1.549    26.805     0.150
     1.549    28.496     0.150
     1.549    49.695     0.150
     1.780    33.395     0.150
     1.795    32.594     0.150
     1.795    56.594     0.150
     1.864    32.996     0.150
     1.866    32.895     0.150
     1.916    32.895     0.150
     2.117    37.996     0.150
     2.246    38.297     0.150
     2.273    38.395     0.150
     2.464    41.797     0.150
     2.498    42.797     0.150
     2.576    44.297     0.150
     2.615    43.496     0.150
     2.615    44.195     0.150
     2.619    44.797     0.150
     2.702    45.297     0.150
     2.727    44.625     0.150
     2.727    45.094     0.150
     2.776    46.195     0.150
     2.772    44.895     0.150
     2.795    45.496     0.150
     2.855    46.344     0.150
     2.855    46.875     0.150
     2.855    82.996     0.150
     2.909    47.594     0.150
     2.987    50.695     0.150
     2.970    48.594     0.150
     3.004    48.996     0.150
     3.119    48.734     0.150
     3.119    50.996     0.150
     3.150    51.297     0.150
     3.222    50.797     0.150
     3.232    51.594     0.150
     3.320    53.297     0.150
     3.345    55.594     0.150
     3.341    53.496     0.150
     3.474    56.395     0.150
     3.549    56.426     0.150
     3.714    58.195     0.150
     3.946    60.496     0.150
     3.946    61.094     0.150
     4.045    64.297     0.150
     4.048    63.895     0.150
     4.087    66.895     0.150
     4.072    63.695     0.150
     4.122    63.176     0.150
     4.122    64.594     0.150
     4.142    64.594     0.150
     4.191    66.496     0.150
     4.232    66.895     0.150
     4.285    67.297     0.150
     4.285    70.496     0.150
     4.403    71.797     0.150
     4.444    70.695     0.150
     4.497    68.465     0.150
     4.497    70.297     0.150
     4.497    72.496     0.150
     4.755    73.195     0.150
     4.772    74.195     0.150
     4.903    77.496     0.150
     5.039    79.094     0.150
     5.013    77.594     0.150
     5.134    78.395     0.150
     5.159    82.094     0.150
     5.284    81.594     0.150
     5.355    80.594     0.150
     5.355    83.395     0.150
     5.378    82.695     0.150
     5.436    83.195     0.150
     5.487    85.094     0.150
     5.563    83.996     0.150
     5.765    87.395     0.150
     5.855    87.594     0.150
     6.032    91.695     0.150
     6.032    94.094     0.150
     6.391    95.094     0.150
     6.391    96.695     0.150
     6.403    97.297     0.150
     6.488    95.176     0.150
     7.062   109.594     0.150
     7.429   115.094     0.150
     8.615   130.094     0.150
     8.910   128.816     0.150
     9.197   133.855     0.150
    12.500   179.156     0.150
    12.597   179.695     0.150
    13.247   186.984     0.150
    13.247   185.984     0.150
    13.885   197.996     0.150
    14.579   211.195     0.150
    14.636   206.047     0.150
    14.857   208.297     0.150
    15.501   219.754     0.150
    16.556   233.297     0.150
    16.556   234.336     0.150
    16.792   238.195     0.150
    16.850   238.395     0.150
    17.074   240.797     0.150
    17.190   240.895     0.150
    17.197   243.094     0.150
    18.393   255.664     0.150
    20.493   279.906     0.150
    20.493   280.672     0.150
    20.493   278.754     0.150
    20.493   281.695     0.150
    20.642   280.395     0.150
    21.836   295.344     0.150
    21.836   296.996     0.150
    22.226   297.926     0.150
    22.226   298.066     0.150
    23.701   312.215     0.150
    24.499   319.934     0.150
    25.475   326.965     0.150
    26.264   335.195     0.150
    26.264   610.297     0.150
    27.031   341.594     0.150
    27.031   342.711     0.150
    27.031   341.824     0.150
    27.363   346.895     0.150
    27.349   346.547     0.150
    28.707   358.621     0.150
    28.714   358.996     0.150
    29.936   370.246     0.150
    29.936   552.695     0.150
    29.936   369.145     0.150
    30.071   369.316     0.150
    32.628   395.996     0.150
    33.514   399.867     0.150
    33.514   399.254     0.150
    33.557   400.387     0.150
    38.296   441.773     0.150
    39.433   450.824     0.150
    39.433   451.156     0.150
    39.433   452.020     0.150
    39.636   453.137     0.150
    39.910   456.035     0.150
    39.910   455.297     0.150
    39.910   457.195     0.150
    42.826   480.297     0.150
    42.826   478.945     0.150
    54.020   565.395     0.150
    54.923   571.957     0.150
    54.923   634.293     0.150
    54.923   570.547     0.150
    54.945   571.055     0.150
    55.775   576.766     0.150
    55.775   576.824     0.150
    56.541   581.914     0.150
    57.061   587.797     0.150
    58.421   595.621     0.150
    58.421   594.934     0.150
    62.989   626.152     0.150
    64.014   632.695     0.150
    64.014   632.207     0.150
    66.863   651.695     0.150
    67.932   658.270     0.150
    70.043   670.773     0.150
    70.043   670.895     0.150
    75.259   702.289     0.150
    75.529   706.094     0.150
    75.529   705.504     0.150
    76.997   713.254     0.150
    82.560   743.496     0.150
    82.560   744.496     0.150
    82.560   742.844     0.150
    88.478   772.457     0.150
   116.914  1125.121     0.150
   143.245  1174.469     0.150
   143.534  1175.020     0.150
   146.852  1183.445     0.150
   149.893  1190.488     0.150
     0.343     7.547     0.150
     0.616    11.844     0.150
     0.616    20.742     0.150
     0.633    13.242     0.150
     0.633    20.844     0.150
     0.659    13.141     0.150
     0.659    22.641     0.150
     0.728    14.445     0.150
     0.732    14.242     0.150
     0.732    25.141     0.150
     0.822    16.547     0.150
     0.920    17.742     0.150
     0.920    30.445     0.150
     0.925    18.094     0.150
     0.925    17.742     0.150
     1.001    19.641     0.150
     1.001    34.742     0.150
     1.042    19.344     0.150
     1.042    34.945     0.150
     1.186    22.445     0.150
     1.186    39.141     0.150
     1.156    22.141     0.150
     1.156    37.844     0.150
     1.212    22.547     0.150
     1.212    39.641     0.150
     1.240    39.945     0.150
     1.344    26.344     0.150
     1.426    26.141     0.150
     1.406    25.445     0.150
     1.406    44.742     0.150
     1.434    26.141     0.150
     1.483    26.844     0.150
     1.483    46.641     0.150
     1.556    28.742     0.150
     1.556    50.141     0.150
     1.607    28.641     0.150
     1.607    49.445     0.150
     1.649    30.641     0.150
     1.627    29.547     0.150
     1.627    50.547     0.150
     1.732    30.742     0.150
     1.732    54.945     0.150
     1.813    32.445     0.150
     1.813    56.141     0.150
     1.885    34.141     0.150
     1.885    58.047     0.150
     1.895    33.344     0.150
     1.895    58.641     0.150
     1.870    33.141     0.150
     2.122    37.445     0.150
     2.122    65.141     0.150
     2.087    62.844     0.150
     2.154    37.641     0.150
     2.216    38.547     0.150
     2.337    40.344     0.150
     2.652    45.844     0.150
     2.719    45.945     0.150
     0.558    11.193     0.150
     0.627    12.893     0.150
     0.665    12.693     0.150
     0.665    23.593     0.150
     0.739    15.093     0.150
     0.764    15.893     0.150
     0.784    16.193     0.150
     0.924    17.393     0.150
     0.964    16.693     0.150
     0.945    18.593     0.150
     0.996    18.093     0.150
     0.983    19.193     0.150
     0.983    33.393     0.150
     1.047    19.893     0.150
     1.047    33.693     0.150
     1.066    20.293     0.150
     1.066    35.093     0.150
     1.056    19.993     0.150
     1.062    19.993     0.150
     1.062    35.193     0.150
     1.110    20.993     0.150
     1.114    20.593     0.150
     1.114    36.893     0.150
     1.292    22.893     0.150
     1.292    41.093     0.150
     1.290    23.593     0.150
     1.290    41.993     0.150
     1.343    23.493     0.150
     1.364    26.193     0.150
     1.378    25.093     0.150
     1.413    26.593     0.150
     1.463    26.893     0.150
     1.555    26.393     0.150
     1.555    48.093     0.150
     1.693    29.693     0.150
     1.693    53.393     0.150
     1.730    29.593     0.150
     1.766    31.493     0.150
     1.766    55.093     0.150
     1.887    32.093     0.150
     1.887    57.993     0.150
     2.067    35.093     0.150
     2.173    36.493     0.150
     2.381    37.993     0.150
     2.433    40.093     0.150
     2.715    42.993     0.150
     3.055    47.993     0.150
     3.258    50.593     0.150
     0.114     2.840     0.150
     0.114     5.439     0.150
     0.195     4.139     0.150
     0.195     8.039     0.150
     0.153     3.238     0.150
     0.188     3.939     0.150
     0.188     7.539     0.150
     0.340     7.039     0.150
     0.340    13.340     0.150
     0.365     7.539     0.150
     0.365    14.238     0.150
     0.403     7.539     0.150
     0.403    14.340     0.150
     0.427     8.439     0.150
     0.427    15.039     0.150
     0.299     5.738     0.150
     0.299    10.639     0.150
     0.387     8.139     0.150
     0.530    10.439     0.150
     0.530    18.139     0.150
     0.468     9.238     0.150
     0.468    15.738     0.150
     0.465     8.639     0.150
     0.465    15.840     0.150
     0.472     9.238     0.150
     0.472    16.939     0.150
     0.655    11.840     0.150
     0.655    22.039     0.150
     0.546    11.920     0.150
     0.546    11.639     0.150
     0.693    12.738     0.150
     0.693    22.639     0.150
     0.569    11.738     0.150
     0.728    13.840     0.150
     0.728    23.840     0.150
     0.638    12.139     0.150
     0.638    21.340     0.150
     0.786    14.738     0.150
     0.786    25.738     0.150
     0.746    15.439     0.150
     0.845    15.828     0.150
     0.845    27.609     0.150
     0.845    27.238     0.150
     1.023    18.840     0.150
     1.023    33.939     0.150
     0.941    18.340     0.150
     0.941    31.238     0.150
     1.169    21.238     0.150
     1.169    37.639     0.150
     1.062    35.639     0.150
     1.163    21.639     0.150
     1.163    38.039     0.150
     1.192    22.340     0.150
     1.215    22.738     0.150
     1.385    24.639     0.150
     1.385    43.539     0.150
     1.363    25.238     0.150
     1.537    26.939     0.150
     1.542    28.039     0.150
     1.542    49.738     0.150
     1.641    28.840     0.150
     1.790    30.840     0.150
     1.658    29.639     0.150
     1.658    52.139     0.150
     1.912    34.039     0.150
     1.912    59.639     0.150
     2.202    36.639     0.150
     2.107    35.238     0.150
     2.245    38.238     0.150
     2.550    43.539     0.150
     2.562    42.539     0.150
     2.514    42.039     0.150
     2.542    41.238     0.150
     2.615    42.539     0.150
     2.928    48.139     0.150
     2.879    46.939     0.150
     2.929    47.539     0.150
     3.159    50.639     0.150
     3.109    50.340     0.150
     3.355    52.689     0.150
     3.513    56.139     0.150
     3.588    56.039     0.150
     3.634    56.340     0.150
     3.794    59.738     0.150
     4.100    63.840     0.150
     4.290    66.639     0.150
    21.281   283.920     0.150
    27.621   344.369     0.150
    29.489   363.344     0.150
    30.725   374.359     0.150
    40.696   461.090     0.150
     0.241     5.445     0.150
     0.241     9.242     0.150
     0.424     9.047     0.150
     0.424    15.141     0.150
     0.504     9.344     0.150
     0.504    17.242     0.150
     0.518    10.445     0.150
     0.518    17.844     0.150
     0.610    11.641     0.150
     0.610    20.445     0.150
     0.633    12.547     0.150
     0.633    21.141     0.150
     0.672    13.445     0.150
     0.672    22.742     0.150
     0.683    22.242     0.150
     0.692    13.742     0.150
     0.692    23.445     0.150
     0.729    13.844     0.150
     0.729    23.844     0.150
     0.745    13.742     0.150
     0.799    14.844     0.150
     0.812    14.742     0.150
     0.847    15.844     0.150
     0.847    27.547     0.150
     0.877    16.141     0.150
     0.875    16.742     0.150
     0.875    28.945     0.150
     0.894    16.344     0.150
     1.235    22.445     0.150
     1.235    38.445     0.150
     1.284    22.742     0.150
     0.196     3.391     0.150
     0.196     6.189     0.150
     0.346     6.490     0.150
     0.346    11.990     0.150
     0.324     6.590     0.150
     0.324    11.590     0.150
     0.399     7.490     0.150
     0.399    14.689     0.150
     0.405     8.590     0.150
     0.444     8.590     0.150
     0.444    15.391     0.150
     0.478     8.891     0.150
     0.515     8.990     0.150
     0.515    16.289     0.150
     0.566    10.189     0.150
     0.566    18.689     0.150
     0.673    12.990     0.150
     0.673    21.689     0.150
     0.686    13.391     0.150
     0.686    22.689     0.150
     0.689    13.289     0.150
     0.689    21.990     0.150
     0.731    13.590     0.150
     0.754    14.891     0.150
     0.738    14.490     0.150
     0.738    14.289     0.150
     0.776    14.590     0.150
     0.891    17.391     0.150
     0.872    16.189     0.150
     0.872    29.090     0.150
     1.010    19.490     0.150
     1.121    21.490     0.150
     1.270    23.689     0.150
     1.435    26.289     0.150
     1.826    31.590     0.150
     2.177    39.391     0.150
     0.074     3.641     0.150
     0.074     7.234     0.150
     0.079     3.039     0.150
     0.079     7.039     0.150
     0.239     5.836     0.150
     0.239    10.938     0.150
     0.265     4.938     0.150
     0.265    12.141     0.150
     0.471    10.336     0.150
     0.471    17.836     0.150
     0.505    10.234     0.150
     0.505    18.234     0.150
     0.617    12.938     0.150
     0.617    21.641     0.150
     0.678    12.836     0.150
     0.678    23.438     0.150
     0.706    13.234     0.150
     0.706    24.234     0.150
     0.749    14.836     0.150
     0.749    25.438     0.150
     0.859    16.539     0.150
     0.859    28.641     0.150
     0.861    15.734     0.150
     0.861    28.039     0.150
     1.051    20.234     0.150
     1.051    33.438     0.150
     1.114    20.234     0.150
     1.114    34.938     0.150
     1.131    21.141     0.150
     1.131    35.938     0.150
     1.139    20.141     0.150
     0.319     7.357     0.150
     0.319    12.557     0.150
     0.350     8.656     0.150
     0.350    14.057     0.150
     0.578    11.656     0.150
     0.578    19.758     0.150
     0.638    11.357     0.150
     0.638    21.258     0.150
     0.651    12.156     0.150
     0.651    22.758     0.150
     0.721    13.656     0.150
     0.721    23.758     0.150
     0.729    13.258     0.150
     0.765    14.656     0.150
     0.765    25.557     0.150
     0.822    15.457     0.150
     0.822    26.258     0.150
     0.939    18.557     0.150
     0.967    19.156     0.150
     1.156    21.156     0.150
     1.144    21.357     0.150
     1.144    35.656     0.150
     1.225    22.156     0.150
     1.225    39.557     0.150
     1.226    22.656     0.150
     1.226    39.758     0.150
     1.378    24.557     0.150
     1.621    28.258     0.150
     1.621    49.357     0.150
     1.872    31.857     0.150
     2.302    37.957     0.150
     0.500    11.179     0.150
     0.500    19.179     0.150
     0.509    11.479     0.150
     0.509    19.979     0.150
     0.735    14.679     0.150
     0.735    25.979     0.150
     0.790    14.979     0.150
     0.790    26.179     0.150
     0.865    16.578     0.150
     0.865    28.479     0.150
     0.867    16.078     0.150
     0.867    28.179     0.150
     0.875    16.179     0.150
     0.875    28.278     0.150
     0.882    16.479     0.150
     0.952    17.578     0.150
     0.952    29.979     0.150
     0.959    17.578     0.150
     0.959    30.578     0.150
     0.986    18.578     0.150
     0.986    31.278     0.150
     1.025    19.078     0.150
     1.030    18.878     0.150
     1.030    32.679     0.150
     1.064    20.479     0.150
     1.064    18.878     0.150
     1.064    32.479     0.150
     1.096    19.378     0.150
     1.096    33.578     0.150
     1.139    18.979     0.150
     1.139    34.179     0.150
     1.146    20.878     0.150
     1.162    19.878     0.150
     1.162    34.378     0.150
     1.174    19.679     0.150
     1.175    20.278     0.150
     1.269    21.979     0.150
     1.280    22.378     0.150
     1.318    22.679     0.150
     1.318    38.878     0.150
     1.319    22.979     0.150
     1.319    39.179     0.150
     1.337    23.578     0.150
     1.344    22.479     0.150
     1.344    39.878     0.150
     1.526    25.778     0.150
     1.533    25.778     0.150
     1.533    44.479     0.150
     1.581    26.278     0.150
     1.657    27.179     0.150
     1.678    28.479     0.150
     1.705    27.778     0.150
     1.705    47.878     0.150
     1.705    27.878     0.150
     1.705    47.878     0.150
     1.880    29.479     0.150
     1.880    52.479     0.150
     1.964    30.479     0.150
     2.049    32.679     0.150
     2.049    57.479     0.150
     2.166    34.179     0.150
     2.362    36.479     0.150
     2.362    63.679     0.150
     2.369    36.378     0.150
     2.549    40.278     0.150
     2.799    42.578     0.150
     2.799    75.479     0.150
     2.952    45.578     0.150
     2.943    44.378     0.150
     3.063    46.479     0.150
     3.115    47.179     0.150
     3.181    48.578     0.150
     3.187    48.479     0.150
     3.219    47.878     0.150
     3.219    83.979     0.150
     3.226    48.778     0.150
     3.286    49.578     0.150
     3.286    85.878     0.150
     3.283    50.878     0.150
     3.391    51.878     0.150
     3.493    52.778     0.150
     3.614    54.378     0.150
     3.753    55.578     0.150
     3.883    57.278     0.150
     3.994    60.179     0.150
     4.442    65.979     0.150
     4.442   116.578     0.150
     4.491    65.878     0.150
     4.508    66.578     0.150
     5.071    73.679     0.150
     5.530    79.578     0.150
     0.667    12.713     0.150
     0.667    21.312     0.150
     0.815    14.074     0.150
     0.815    13.334     0.150
     0.815    23.344     0.150
     0.815    23.514     0.150
     0.794    15.312     0.150
     0.794    25.713     0.150
     0.955    17.014     0.150
     0.955    28.514     0.150
     0.927    17.113     0.150
     0.927    28.613     0.150
     0.993    17.514     0.150
     1.026    18.713     0.150
     1.026    32.113     0.150
     1.089    18.713     0.150
     1.089    31.713     0.150
     1.075    19.213     0.150
     1.075    32.613     0.150
     1.055    18.533     0.150
     1.055    18.914     0.150
     1.139    19.914     0.150
     1.139    33.914     0.150
     1.151    20.113     0.150
     1.091    19.713     0.150
     1.179    19.514     0.150
     1.264    22.334     0.150
     1.288    22.514     0.150
     1.288    38.164     0.150
     1.288    22.312     0.150
     1.295    23.514     0.150
     1.348    22.812     0.150
     1.348    38.312     0.150
     1.428    24.514     0.150
     1.428    24.703     0.150
     1.428    42.414     0.150
     1.467    25.014     0.150
     1.487    25.514     0.150
     1.487    43.514     0.150
     1.444    23.414     0.150
     1.630    26.812     0.150
     1.630    46.414     0.150
     1.630    26.812     0.150
     1.630    46.113     0.150
     1.579    26.213     0.150
     1.711    28.713     0.150
     1.711    49.812     0.150
     1.664    27.514     0.150
     1.751    29.604     0.150
     1.820    30.482     0.150
     1.820    30.113     0.150
     1.878    30.713     0.150
     1.872    30.213     0.150
     1.974    31.812     0.150
     1.999    32.713     0.150
     2.012    32.123     0.150
     2.165    33.914     0.150
     2.165    58.613     0.150
     2.363    37.514     0.150
     2.363    65.514     0.150
     2.444    38.014     0.150
     2.656    40.414     0.150
     2.675    41.914     0.150
     2.881    44.713     0.150
     3.108    47.713     0.150
     3.108    82.812     0.150
     3.119    48.504     0.150
     3.102    47.914     0.150
     3.102    84.312     0.150
     3.207    49.312     0.150
     3.253    50.613     0.150
     3.232    48.914     0.150
     3.264    48.883     0.150
     3.264    49.113     0.150
     3.378    49.713     0.150
     3.463    51.514     0.150
     3.529    54.174     0.150
     3.529    93.812     0.150
     3.557    53.113     0.150
     3.591    55.312     0.150
     3.674    55.914     0.150
     3.773    56.713     0.150
     3.753    56.113     0.150
     3.886    57.934     0.150
     3.886    57.514     0.150
     3.964    61.164     0.150
     3.977    61.213     0.150
     4.062    60.213     0.150
     4.142    63.914     0.150
     4.205    62.414     0.150
     4.139    61.273     0.150
     4.139    61.113     0.150
     4.281    64.414     0.150
     4.429    66.613     0.150
     4.456    67.623     0.150
     4.715    71.113     0.150
     4.755    69.354     0.150
     4.755    69.613     0.150
     4.909    73.014     0.150
     5.080    76.113     0.150
     5.389    80.273     0.150
     5.389    76.393     0.150
     5.366    79.514     0.150
     5.918    86.914     0.150
     5.953    87.113     0.150
     6.384    92.812     0.150
     6.534    94.312     0.150
     6.528    94.113     0.150
     6.681    96.613     0.150
     7.094   102.732     0.150
     7.094   100.963     0.150
     7.094   102.312     0.150
     7.094   100.613     0.150
     7.165   103.812     0.150
     7.289   103.812     0.150
     7.284   105.713     0.150
     7.546   109.713     0.150
     7.615   109.213     0.150
     7.823   113.914     0.150
     8.100   118.344     0.150
     8.928   126.754     0.150
    10.693   151.354     0.150
    10.693   149.934     0.150
    10.693   150.113     0.150
    10.854   153.943     0.150
    13.162   183.283     0.150
    13.162   181.914     0.150
    13.293   188.732     0.150
    13.309   182.193     0.150
    14.553   200.803     0.150
    15.090   208.303     0.150
    15.090   209.312     0.150
    16.436   226.273     0.150
    16.436   224.514     0.150
    16.163   223.533     0.150
    17.150   234.824     0.150
    17.150   237.643     0.150
    17.150   235.613     0.150
    17.972   246.232     0.150
    17.972   247.113     0.150
    18.340   250.902     0.150
    18.340   251.244     0.150
    19.836   266.732     0.150
    19.797   265.994     0.150
    19.797   264.414     0.150
    20.740   279.139     0.150
    20.740   496.463     0.150
    21.594   289.514     0.150
    22.617   297.424     0.150
    22.617   296.803     0.150
    22.617   296.312     0.150
    24.214   312.684     0.150
    25.067   317.084     0.150
    25.619   326.014     0.150
    25.942   324.703     0.150
    26.972   335.414     0.150
    26.972   609.414     0.150
    27.436   338.264     0.150
    27.436   539.922     0.150
    27.774   341.973     0.150
    29.021   356.789     0.150
    29.021   543.762     0.150
    29.736   365.934     0.150
    30.041   367.732     0.150
    30.134   366.914     0.150
    30.134   546.783     0.150
    30.134   366.104     0.150
    30.172   366.414     0.150
    30.172    12.898     0.150
    30.980   376.023     0.150
    33.902   399.232     0.150
    34.379   401.193     0.150
    36.544   424.473     0.150
    36.544   421.812     0.150
    37.460   430.324     0.150
    37.460   429.113     0.150
    37.654   432.254     0.150
    39.773   442.914     0.150
    39.831   451.004     0.150
    39.831   449.203     0.150
    39.831   448.812     0.150
    39.871   452.174     0.150
    39.871   449.213     0.150
    39.997   452.914     0.150
    39.997   452.566     0.150
    39.997   452.113     0.150
    40.700   453.402     0.150
    40.745   452.812     0.150
    42.516   467.014     0.150
    42.713   470.113     0.150
    42.961   477.494     0.150
    42.961   476.104     0.150
    42.961   475.213     0.150
    47.060   510.123     0.150
    47.060   507.924     0.150
    47.060   509.873     0.150
    47.060    15.730     0.150
    47.288   513.223     0.150
    47.288   510.053     0.150
    49.216   521.371     0.150
    52.338   545.674     0.150
    52.338   545.523     0.150
    54.173   558.414     0.150
    54.428   560.213     0.150
    55.464   568.652     0.150
    55.464   568.424     0.150
    55.561   568.434     0.150
    55.561   629.133     0.150
    55.589   569.764     0.150
    55.589   568.873     0.150
    56.506   575.014     0.150
    56.254   576.994     0.150
    56.629   575.539     0.150
    56.629   575.193     0.150
    56.827   577.494     0.150
    56.827   576.914     0.150
    58.302   587.133     0.150
    58.312   588.473     0.150
    58.438   587.613     0.150
    58.272   591.514     0.150
    58.792   590.463     0.150
    58.792   590.104     0.150
    58.910   592.584     0.150
    58.910   591.953     0.150
    59.301   597.643     0.150
    59.301   596.963     0.150
    59.301   596.113     0.150
    59.301    15.619     0.150
    60.019   599.934     0.150
    60.639   603.514     0.150
    60.696   604.652     0.150
    62.793   621.844     0.150
    62.793    15.770     0.150
    63.235   621.223     0.150
    63.357   621.514     0.150
    63.406   623.174     0.150
    63.406   621.514     0.150
    63.406   622.924     0.150
    63.406    15.350     0.150
    63.406    22.309     0.150
    64.465   628.748     0.150
    64.487   629.713     0.150
    64.487   629.883     0.150
    65.851   644.594     0.150
    66.354   646.744     0.150
    66.445   647.594     0.150
    67.733   655.604     0.150
    67.733    16.490     0.150
    68.255   653.514     0.150
    68.298   654.303     0.150
    68.842   662.873     0.150
    69.120   663.793     0.150
    69.498   666.463     0.150
    69.617   666.473     0.150
    69.792   669.213     0.150
    69.792   668.139     0.150
    69.792   665.414     0.150
    74.432   690.639     0.150
    74.328   692.963     0.150
    75.021   698.793     0.150
    75.021   698.139     0.150
    75.021   697.674     0.150
    75.021    16.609     0.150
    75.540   698.113     0.150
    75.540   697.414     0.150
    75.540   698.574     0.150
    75.701   702.174     0.150
    76.097   705.203     0.150
    76.315   708.174     0.150
    77.367   708.764     0.150
    77.204   712.553     0.150
    78.304   711.289     0.150
    78.539   717.773     0.150
    78.591   718.334     0.150
    78.591   715.613     0.150
    78.819   718.053     0.150
    78.919   720.914     0.150
    79.805   724.232     0.150
    80.762   724.953     0.150
    80.762   725.113     0.150
    81.365   732.732     0.150
    82.027   736.982     0.150
    82.027   734.473     0.150
    82.027   736.244     0.150
    82.471   737.264     0.150
    82.471   736.963     0.150
    82.850   738.543     0.150
    85.535   752.754     0.150
    86.300   758.203     0.150
    86.875   763.783     0.150
    86.906   760.623     0.150
    88.415   764.914     0.150
    88.450   765.660     0.150
    88.450   765.414     0.150
    88.458   766.264     0.150
    88.458   766.004     0.150
    88.458   765.414     0.150
    88.458   765.803     0.150
    88.510   765.713     0.150
    88.529   765.713     0.150
    88.552   765.914     0.150
    88.581   766.014     0.150
    88.812   770.504     0.150
    88.609   770.812     0.150
    88.609   770.680     0.150
    88.609   769.805     0.150
    88.609   769.244     0.150
    88.609   768.613     0.150
    89.404   773.084     0.150
    89.404   771.014     0.150
    90.342   774.994     0.150
    90.342   775.113     0.150
    90.858   779.074     0.150
    90.898   778.854     0.150
    91.572   782.344     0.150
    91.671   781.383     0.150
    92.030   782.773     0.150
    92.339   784.123     0.150
    92.495   788.203     0.150
    92.580   785.023     0.150
    92.575   786.184     0.150
    92.620   784.363     0.150
    92.767   787.463     0.150
    93.433   789.133     0.150
    93.689   790.504     0.150
    94.901   795.393     0.150
    94.916   796.943     0.150
    96.521   802.883     0.150
    97.681   810.184     0.150
    97.875   808.227     0.150
    99.522   816.184     0.150
    99.698   818.703     0.150
   117.764  1120.338     0.150
   129.225  1144.113     0.150
   129.225  1143.652     0.150
   133.006  1150.414     0.150
   142.665  1167.639     0.150
   144.195  1170.289     0.150
   144.195  1169.383     0.150
   145.901  1177.883     0.150
   145.901  1176.773     0.150
   155.423  1218.688     0.150
     0.116     2.406     0.150
     0.116     4.906     0.150
     0.151     3.206     0.150
     0.188     4.206     0.150
     0.188     7.706     0.150
     0.196     4.307     0.150
     0.196     7.706     0.150
     0.297     5.807     0.150
     0.297    11.706     0.150
     0.343     6.906     0.150
     0.343    13.106     0.150
     0.368     7.307     0.150
     0.368    13.106     0.150
     0.406     7.406     0.150
     0.406    13.807     0.150
     0.385     8.706     0.150
     0.385    14.507     0.150
     0.428     8.206     0.150
     0.428    15.007     0.150
     0.469     8.807     0.150
     0.469    16.206     0.150
     0.471     9.106     0.150
     0.471    16.606     0.150
     0.463     8.807     0.150
     0.463    16.507     0.150
     0.533    10.007     0.150
     0.536    10.406     0.150
     0.566    11.906     0.150
     0.636    12.307     0.150
     0.636    21.906     0.150
     0.655    12.007     0.150
     0.655    21.906     0.150
     0.694    12.307     0.150
     0.694    22.307     0.150
     0.730    13.906     0.150
     0.730    23.807     0.150
     0.743    14.307     0.150
     0.844    15.606     0.150
     0.844    27.307     0.150
     0.938    18.307     0.150
     1.025    18.706     0.150
     1.171    21.106     0.150
     1.160    21.507     0.150
     1.213    21.906     0.150
     1.361    24.206     0.150
     1.371    25.007     0.150
     1.387    24.807     0.150
     1.657    29.206     0.150
     1.657    49.007     0.150
     1.792    30.307     0.150
     1.910    33.706     0.150
     2.204    36.606     0.150
     2.564    41.606     0.150
     3.161    49.706     0.150
     3.394    52.406     0.150
     0.117     4.036     0.150
     0.117     6.436     0.150
     0.305     6.436     0.150
     0.305    10.336     0.150
     0.368     7.436     0.150
     0.437     9.036     0.150
     0.437    14.836     0.150
     0.493     9.636     0.150
     0.493    15.936     0.150
     0.555    10.836     0.150
     0.555    18.235     0.150
     0.553    11.436     0.150
     0.553    19.636     0.150
     0.633    12.536     0.150
     0.646    12.636     0.150
     0.630    13.235     0.150
     0.773    14.235     0.150
     0.773    25.235     0.150
     0.823    15.936     0.150
     0.823    27.235     0.150
     0.922    18.136     0.150
     0.926    18.136     0.150
     0.926    31.235     0.150
     0.960    17.636     0.150
     0.960    32.536     0.150
     0.960    17.536     0.150
     0.960    32.436     0.150
     0.963    18.235     0.150
     0.963    31.036     0.150
     1.036    19.336     0.150
     1.036    32.936     0.150
     1.068    20.336     0.150
     1.088    20.536     0.150
     1.088    35.336     0.150
     1.356    25.036     0.150
     1.406    25.636     0.150
     1.618    30.235     0.150
     1.649    28.436     0.150
     1.683    29.735     0.150
     2.011    33.936     0.150
     2.052    34.536     0.150
     0.131     3.812     0.150
     0.131     6.211     0.150
     0.286     6.109     0.150
     0.286     9.812     0.150
     0.349     7.512     0.150
     0.349    11.711     0.150
     0.436    14.512     0.150
     0.475     8.812     0.150
     0.475    15.609     0.150
     0.534    11.211     0.150
     0.543    10.410     0.150
     0.543    18.512     0.150
     0.617    12.711     0.150
     0.627    12.512     0.150
     0.627    21.711     0.150
     0.671    13.410     0.150
     0.691    13.312     0.150
     0.762    14.410     0.150
     0.816    15.211     0.150
     0.816    27.012     0.150
     0.909    17.910     0.150
     0.919    18.109     0.150
     0.919    31.312     0.150
     0.958    18.609     0.150
     0.958    31.609     0.150
     0.959    18.109     0.150
     0.959    31.512     0.150
     0.971    18.410     0.150
     0.971    30.910     0.150
     1.040    19.410     0.150
     1.040    34.012     0.150
     1.037    19.312     0.150
     1.037    32.910     0.150
     0.307     5.898     0.150
     0.307    10.199     0.150
     0.383     7.199     0.150
     0.383    12.799     0.150
     0.416    14.799     0.150
     0.491     9.299     0.150
     0.491    15.898     0.150
     0.543    10.598     0.150
     0.543    18.299     0.150
     0.564    11.199     0.150
     0.564    19.199     0.150
     0.628    12.299     0.150
     0.628    20.299     0.150
     0.649    12.498     0.150
     0.653    12.998     0.150
     0.653    22.498     0.150
     0.705    13.799     0.150
     0.721    13.998     0.150
     0.761    14.398     0.150
     0.761    25.299     0.150
     0.794    15.398     0.150
     0.805    15.398     0.150
     0.805    26.199     0.150
     0.862    17.299     0.150
     0.817    15.498     0.150
     0.817    26.699     0.150
     0.913    17.799     0.150
     0.909    17.598     0.150
     0.909    30.799     0.150
     0.982    18.598     0.150
     0.982    32.098     0.150
     0.983    18.699     0.150
     0.983    32.199     0.150
     1.034    19.299     0.150
     1.034    33.699     0.150
     1.014    32.998     0.150
     1.049    19.598     0.150
     1.069    20.898     0.150
     1.070    20.299     0.150
     1.070    35.098     0.150
     1.096    20.998     0.150
     1.143    21.598     0.150
     1.143    37.898     0.150
     1.214    22.799     0.150
     1.366    24.998     0.150
     1.393    25.498     0.150
     1.393    44.299     0.150
     1.379    25.398     0.150
     1.621    29.199     0.150
     1.639    29.498     0.150
     1.639    52.299     0.150
     1.673    30.098     0.150
     1.730    30.699     0.150
     1.730    52.898     0.150
     1.938    33.799     0.150
     1.938    60.699     0.150
     1.990    33.898     0.150
     2.034    36.598     0.150
     2.074    35.598     0.150
     2.407    41.799     0.150
     2.445    41.799     0.150
     2.480    41.498     0.150
     2.644    43.799     0.150
     2.762    45.299     0.150
     2.913    47.299     0.150
     2.913    83.398     0.150
     2.946    47.699     0.150
     2.946    84.398     0.150
     3.001    48.699     0.150
     3.001    84.898     0.150
     3.057    49.098     0.150
     3.057    87.199     0.150
     3.126    50.498     0.150
     3.169    50.898     0.150
     3.292    52.998     0.150
     3.292    92.898     0.150
     3.690    57.898     0.150
     3.690   102.699     0.150
     4.234    65.699     0.150
     4.310    66.199     0.150
     4.271    67.299     0.150
     0.183     5.102     0.150
     0.183     7.797     0.150
     0.284     6.102     0.150
     0.284    10.602     0.150
     0.457     9.203     0.150
     0.457    16.500     0.150
     0.478     9.297     0.150
     0.478    16.898     0.150
     0.507    10.102     0.150
     0.507    18.398     0.150
     0.552    11.297     0.150
     0.552    19.602     0.150
     0.560    10.898     0.150
     0.560    18.000     0.150
     0.602    20.602     0.150
     0.615    11.797     0.150
     0.615    20.398     0.150
     0.633    12.898     0.150
     0.674    12.602     0.150
     0.674    23.102     0.150
     0.792    15.898     0.150
     0.792    25.398     0.150
     0.843    15.703     0.150
     0.844    15.703     0.150
     0.844    27.297     0.150
     0.891    17.000     0.150
     0.905    16.297     0.150
     0.905    29.500     0.150
     0.906    16.398     0.150
     0.906    29.703     0.150
     0.928    17.898     0.150
     0.928    31.102     0.150
     0.944    17.203     0.150
     1.038    19.102     0.150
     1.089    20.297     0.150
     1.156    20.898     0.150
     1.170    21.703     0.150
     1.236    22.703     0.150
     1.236    38.500     0.150
     1.444    24.297     0.150
     1.511    25.797     0.150
     1.837    31.000     0.150
     1.938    32.898     0.150
     0.106     2.727     0.150
     0.106     5.727     0.150
     0.271     5.531     0.150
     0.271    10.031     0.150
     0.333     6.930     0.150
     0.333    11.930     0.150
     0.346     7.133     0.150
     0.346    12.133     0.150
     0.340     7.133     0.150
     0.340    12.531     0.150
     0.407     8.430     0.150
     0.407    13.930     0.150
     0.400     8.828     0.150
     0.563     9.727     0.150
     0.563    19.133     0.150
     0.583    11.531     0.150
     0.583    19.633     0.150
     0.650    12.633     0.150
     0.650    20.227     0.150
     0.744    14.828     0.150
     0.744    24.133     0.150
     0.758    14.031     0.150
     0.899    17.031     0.150
     0.914    17.430     0.150
     0.925    17.430     0.150
     0.925    30.133     0.150
     1.011    19.930     0.150
     1.011    32.828     0.150
     1.159    21.430     0.150
     1.159    37.328     0.150
     1.225    23.133     0.150
     1.225    38.633     0.150
     1.283    22.727     0.150
     1.283    40.031     0.150
     1.296    23.328     0.150
     1.296    41.133     0.150
     1.829    30.828     0.150
     2.187    37.930     0.150
     2.187    65.828     0.150
     3.732    58.328     0.150
     0.117     3.016     0.150
     0.150     3.516     0.150
     0.150     6.516     0.150
     0.184     4.316     0.150
     0.184     7.617     0.150
     0.217     4.715     0.150
     0.217     9.117     0.150
     0.267     5.715     0.150
     0.373     7.914     0.150
     0.373    13.816     0.150
     0.350     8.316     0.150
     0.350    14.117     0.150
     0.402     8.516     0.150
     0.402    14.215     0.150
     0.440     7.914     0.150
     0.440    14.617     0.150
     0.450     9.117     0.150
     0.450    16.414     0.150
     0.433     8.715     0.150
     0.433    15.715     0.150
     0.445     9.117     0.150
     0.445    15.914     0.150
     0.471     9.516     0.150
     0.471    16.516     0.150
     0.509    10.316     0.150
     0.509    18.016     0.150
     0.532    11.316     0.150
     0.532    18.715     0.150
     0.568    11.316     0.150
     0.568    19.516     0.150
     0.570    11.516     0.150
     0.570    19.516     0.150
     0.606    12.117     0.150
     0.606    21.414     0.150
     0.721    13.117     0.150
     0.721    23.516     0.150
     0.760    14.516     0.150
     0.760    25.316     0.150
     0.825    15.617     0.150
     0.825    27.117     0.150
     0.904    16.816     0.150
     1.056    19.914     0.150
     1.126    21.516     0.150
     1.184    22.617     0.150
     1.184    38.117     0.150
     1.201    21.715     0.150
     1.326    24.215     0.150
     1.420    25.516     0.150
     1.420    44.617     0.150
     1.605    28.215     0.150
     1.632    29.516     0.150
     1.819    31.516     0.150
     2.581    41.914     0.150
     3.074    48.617     0.150
     3.483    54.617     0.150
     3.483    95.715     0.150
     4.088    61.617     0.150
     0.193     3.961     0.150
     0.193     7.164     0.150
     0.243     5.266     0.150
     0.243     9.367     0.150
     0.261     5.562     0.150
     0.261    10.266     0.150
     0.403     8.164     0.150
     0.403    15.266     0.150
     0.449     8.664     0.150
     0.499    10.367     0.150
     0.499    18.461     0.150
     0.500    10.562     0.150
     0.574    11.266     0.150
     0.574    18.961     0.150
     0.593    11.367     0.150
     0.593    20.664     0.150
     0.607    12.461     0.150
     0.743    15.766     0.150
     0.743    27.562     0.150
     0.806    15.961     0.150
     0.836    15.766     0.150
     0.923    18.664     0.150
     0.927    17.367     0.150
     0.927    29.664     0.150
     1.155    21.461     0.150
     1.176    21.867     0.150
     1.171    21.562     0.150
     1.225    22.266     0.150
     1.426    25.062     0.150
     1.486    27.766     0.150
     1.928    32.867     0.150
     3.475    53.766     0.150
     0.215     4.125     0.150
     0.215     7.922     0.150
     0.234     5.723     0.150
     0.234     9.824     0.150
     0.296     6.223     0.150
     0.296    10.125     0.150
     0.483     9.223     0.150
     0.483    15.922     0.150
     0.512    10.125     0.150
     0.512    17.324     0.150
     0.468     9.824     0.150
     0.468    16.723     0.150
     0.571    12.223     0.150
     0.570    11.125     0.150
     0.570    19.023     0.150
     0.600    11.824     0.150
     0.600    20.125     0.150
     0.627    12.422     0.150
     0.627    21.422     0.150
     0.641    12.824     0.150
     0.771    15.324     0.150
     0.840    16.723     0.150
     0.804    15.723     0.150
     0.804    15.023     0.150
     0.832    17.625     0.150
     0.870    17.223     0.150
     0.893    16.523     0.150
     0.940    19.523     0.150
     0.957    18.625     0.150
     1.033    20.723     0.150
     1.034    21.324     0.150
     1.136    21.625     0.150
     1.189    23.223     0.150
     1.203    23.523     0.150
     1.203    22.422     0.150
     1.203    38.523     0.150
     1.194    22.023     0.150
     1.423    26.723     0.150
     1.461    26.625     0.150
     1.461    27.125     0.150
     1.492    27.523     0.150
     1.791    31.422     0.150
     1.836    32.922     0.150
     1.898    32.523     0.150
     2.435    41.023     0.150
     2.767    44.922     0.150
     2.783    46.523     0.150
     0.198     4.195     0.150
     0.269     5.293     0.150
     0.269    11.695     0.150
     0.321     5.195     0.150
     0.368     6.594     0.150
     0.368    13.094     0.150
     0.372     7.395     0.150
     0.373     7.793     0.150
     0.536     9.895     0.150
     0.536    19.094     0.150
     0.615    11.996     0.150
     0.662    13.395     0.150
     0.731    13.594     0.150
     0.738    14.195     0.150
     1.133    20.895     0.150
     1.133    36.395     0.150
     1.223    21.895     0.150
     1.223    39.793     0.150
     1.313    24.293     0.150
     1.696    30.793     0.150
     1.774    29.695     0.150
     1.828    31.496     0.150
     1.864    32.195     0.150
     1.874    31.895     0.150
     1.885    32.094     0.150
     2.029    34.793     0.150
     2.084    33.895     0.150
     2.214    37.094     0.150
     2.311    38.395     0.150
     0.195     4.629     0.150
     0.195     9.027     0.150
     0.277     5.828     0.150
     0.277     9.328     0.150
     0.335     6.828     0.150
     0.404     7.926     0.150
     0.404    13.629     0.150
     0.404     8.027     0.150
     0.426     8.426     0.150
     0.554    10.426     0.150
     0.607    12.727     0.150
     0.696    13.227     0.150
     0.700    13.828     0.150
     0.763    13.828     0.150
     0.763    25.227     0.150
     0.828    15.727     0.150
     0.810    15.426     0.150
     0.841    15.727     0.150
     0.943    17.328     0.150
     0.948    18.227     0.150
     1.100    20.129     0.150
     1.133    21.129     0.150
     1.111    21.426     0.150
     1.189    21.828     0.150
     1.256    22.129     0.150
     1.256    39.438     0.150
     1.256    22.328     0.150
     1.299    24.328     0.150
     1.339    24.426     0.150
     1.390    25.027     0.150
     1.475    27.227     0.150
     1.523    26.926     0.150
     1.571    27.828     0.150
     1.556    27.539     0.150
     1.556    48.828     0.150
     1.556    27.926     0.150
     1.558    27.828     0.150
     1.668    29.227     0.150
     1.676    30.328     0.150
     1.727    30.629     0.150
     1.711    30.426     0.150
     1.740    30.227     0.150
     1.751    31.227     0.150
     1.803    31.727     0.150
     1.838    31.727     0.150
     1.843    32.426     0.150
     1.848    32.227     0.150
     1.916    32.828     0.150
     1.977    33.926     0.150
     2.060    35.426     0.150
     2.051    34.129     0.150
     2.112    35.828     0.150
     2.141    36.426     0.150
     2.145    36.129     0.150
     2.180    35.926     0.150
     2.306    38.828     0.150
     2.315    38.527     0.150
     2.343    38.527     0.150
     2.575    42.926     0.150
     2.836    45.727     0.150
     2.917    46.629     0.150
     2.927    46.328     0.150
     2.929    47.426     0.150
     2.969    47.027     0.150
     3.031    48.129     0.150
     3.203    50.828     0.150
     3.552    55.629     0.150
     3.585    55.527     0.150
     3.770    58.027     0.150
     3.961    61.027     0.150
     4.322    64.426     0.150
     4.526    69.129     0.150
     4.549    66.789     0.150
     4.587    70.129     0.150
     4.665    70.727     0.150
     4.784    72.629     0.150
     5.054    75.227     0.150
     5.392    80.559     0.150
     5.392    81.828     0.150
     5.798    85.129     0.150
     8.970   130.227     0.150
     8.973   129.828     0.150
     9.655   140.426     0.150
     9.714   141.828     0.150
     9.740   141.527     0.150
    10.197   145.797     0.150
    17.445   241.906     0.150
    19.630   269.328     0.150
    19.630   266.398     0.150
    22.630   300.168     0.150
    27.261   344.105     0.150
    27.778   349.379     0.150
    27.778   348.246     0.150
    27.784   348.578     0.150
    29.104   360.578     0.150
    29.104   546.777     0.150
    29.104   360.328     0.150
    32.598   390.578     0.150
    39.175   448.527     0.150
    39.175   447.586     0.150
    42.043   471.637     0.150
    54.783   569.789     0.150
    54.783   569.457     0.150
    58.670   595.754     0.150
    58.670   595.566     0.150
    63.284   627.949     0.150
    65.116   640.207     0.150
    66.644   647.551     0.150
    68.239   657.926     0.150
    68.283   659.246     0.150
    68.413   661.176     0.150
    70.500   672.238     0.150
    70.500   672.129     0.150
    75.489   703.930     0.150
    82.844   743.746     0.150
    82.844   743.238     0.150
    83.316   744.879     0.150
    89.940   778.895     0.150
    89.940   778.297     0.150
   144.132  1173.629     0.150
   147.804  1184.926     0.150
     0.196     4.570     0.150
     0.272     5.766     0.150
     0.272    11.469     0.150
     0.380     7.969     0.150
     0.380     8.164     0.150
     0.360     6.367     0.150
     0.419     8.367     0.150
     0.541    10.367     0.150
     0.541    19.766     0.150
     0.612    12.570     0.150
     0.671    12.969     0.150
     0.744    13.867     0.150
     0.744    25.164     0.150
     0.723    13.469     0.150
     0.717    13.570     0.150
     0.717    24.867     0.150
     0.829    14.766     0.150
     0.852    15.570     0.150
     0.810    15.766     0.150
     0.930    18.367     0.150
     0.931    17.266     0.150
     0.931    31.766     0.150
     1.133    21.266     0.150
     1.114    21.070     0.150
     1.125    19.766     0.150
     1.166    21.766     0.150
     1.166    38.469     0.150
     1.231    22.180     0.150
     1.231    38.055     0.150
     1.322    23.969     0.150
     1.320    24.367     0.150
     1.367    24.867     0.150
     1.454    27.266     0.150
     1.500    27.070     0.150
     1.576    27.664     0.150
     1.552    27.570     0.150
     1.581    27.305     0.150
     1.581    47.664     0.150
     1.646    29.664     0.150
     1.696    29.164     0.150
     1.704    30.766     0.150
     1.715    30.570     0.150
     1.731    29.867     0.150
     1.768    30.266     0.150
     1.768    52.664     0.150
     1.821    31.664     0.150
     1.857    31.664     0.150
     1.869    32.070     0.150
     1.866    31.570     0.150
     1.893    33.164     0.150
     1.955    34.469     0.150
     2.076    33.570     0.150
     2.076    61.664     0.150
     2.130    35.867     0.150
     2.118    36.969     0.150
     2.165    36.070     0.150
     2.196    36.367     0.150
     2.205    36.070     0.150
     2.860    45.164     0.150
     2.940    45.766     0.150
     2.949    47.570     0.150
     2.950    47.766     0.150
     2.993    46.969     0.150
     3.052    48.266     0.150
     3.181    50.570     0.150
     3.609    55.367     0.150
     3.793    57.867     0.150
     4.527    66.656     0.150
     4.527    68.867     0.150
     4.611    69.664     0.150
     4.686    72.766     0.150
     5.078    74.867     0.150
     5.413    81.711     0.150
     6.488    91.945     0.150
     8.995   129.680     0.150
    11.045   156.500     0.150
    19.645   268.734     0.150
    19.645   268.406     0.150
    22.651   300.047     0.150
    27.260   343.156     0.150
    27.260   344.109     0.150
    27.260   342.938     0.150
    27.795   348.273     0.150
    27.795   544.141     0.150
    27.795   348.148     0.150
    27.800   348.156     0.150
    29.118   360.867     0.150
    29.118   547.664     0.150
    29.118   360.539     0.150
    29.118   547.438     0.150
    38.450   441.211     0.150
    39.187   447.938     0.150
    54.790   569.234     0.150
    54.790   568.773     0.150
    58.669   595.180     0.150
    59.043   598.000     0.150
    63.238   626.055     0.150
    63.283   626.047     0.150
    66.653   648.406     0.150
    68.407   661.141     0.150
    68.503   661.320     0.150
    75.485   703.445     0.150
    75.485   702.898     0.150
    82.837   743.414     0.150
    82.837   743.844     0.150
     0.200     4.430     0.150
     0.268     5.727     0.150
     0.268     9.125     0.150
     0.380     6.727     0.150
     0.380    13.430     0.150
     0.361     8.023     0.150
     0.360     7.625     0.150
     0.413     8.328     0.150
     0.530    10.430     0.150
     0.530    19.023     0.150
     0.618    12.828     0.150
     0.650    13.328     0.150
     0.704    13.430     0.150
     0.704    24.430     0.150
     0.743    14.023     0.150
     0.728    13.727     0.150
     0.845    15.625     0.150
     0.862    15.930     0.150
     0.915    17.125     0.150
     0.921    17.227     0.150
     1.145    20.125     0.150
     1.151    21.625     0.150
     1.147    21.930     0.150
     1.210    22.328     0.150
     1.210    37.523     0.150
     1.304    24.930     0.150
     1.342    24.523     0.150
     1.347    25.328     0.150
     1.347    42.828     0.150
     1.482    26.625     0.150
     1.601    28.523     0.150
     1.601    50.828     0.150
     1.628    28.625     0.150
     1.684    30.625     0.150
     1.695    30.625     0.150
     1.747    30.125     0.150
     1.783    31.125     0.150
     1.783    55.523     0.150
     1.837    31.727     0.150
     1.873    31.828     0.150
     1.887    33.430     0.150
     2.017    35.625     0.150
     2.096    34.727     0.150
     3.069    48.523     0.150
     3.163    50.625     0.150
     0.046     2.684     0.150
     0.046     5.482     0.150
     0.255     6.582     0.150
     0.256     6.283     0.150
     0.411     8.383     0.150
     0.411    15.684     0.150
     0.448     9.482     0.150
     0.450     9.982     0.150
     0.601    20.684     0.150
     0.613    11.482     0.150
     0.613    20.883     0.150
     0.599    11.982     0.150
     0.599    20.582     0.150
     0.595    11.982     0.150
     0.595    21.684     0.150
     0.628    12.184     0.150
     0.628    21.482     0.150
     0.680    23.883     0.150
     0.712    13.383     0.150
     0.750    13.982     0.150
     0.750    26.082     0.150
     0.839    15.283     0.150
     0.839    27.283     0.150
     0.844    15.383     0.150
     0.844    28.283     0.150
     0.853    16.883     0.150
     0.853    28.783     0.150
     0.871    28.684     0.150
     0.863    16.383     0.150
     0.863    29.482     0.150
     0.955    17.582     0.150
     0.998    18.684     0.150
     0.998    33.082     0.150
     1.010    18.982     0.150
     1.010    32.684     0.150
     0.994    18.283     0.150
     1.049    19.982     0.150
     1.049    36.283     0.150
     1.122    19.582     0.150
     1.122    36.582     0.150
     1.233    22.283     0.150
     1.233    39.482     0.150
     1.218    39.783     0.150
     1.343    23.383     0.150
     1.343    41.582     0.150
     1.351    23.883     0.150
     1.351    42.883     0.150
     1.398    25.283     0.150
     1.398    44.482     0.150
     1.398    25.283     0.150
     1.638    28.184     0.150
     1.638    50.383     0.150
     1.731    30.082     0.150
     1.816    31.082     0.150
     2.815    44.582     0.150
     0.142     2.893     0.150
     0.142     6.094     0.150
     0.167     3.594     0.150
     0.167     6.393     0.150
     0.296     6.594     0.150
     0.296    10.992     0.150
     0.307     6.742     0.150
     0.357     6.992     0.150
     0.357    13.193     0.150
     0.362     7.594     0.150
     0.362    12.193     0.150
     0.444     8.492     0.150
     0.444    15.992     0.150
     0.515     9.992     0.150
     0.515    18.094     0.150
     0.490    10.594     0.150
     0.502    10.193     0.150
     0.502    16.492     0.150
     0.532    11.293     0.150
     0.532    18.193     0.150
     0.570    11.293     0.150
     0.570    20.193     0.150
     0.599    11.594     0.150
     0.599    19.393     0.150
     0.662    13.293     0.150
     0.662    23.293     0.150
     0.662    13.543     0.150
     0.687    13.193     0.150
     0.687    24.193     0.150
     0.698    13.693     0.150
     0.698    22.992     0.150
     0.786    15.492     0.150
     0.786    15.293     0.150
     0.786    26.992     0.150
     0.791    15.393     0.150
     0.796    15.293     0.150
     0.796    27.893     0.150
     0.909    17.193     0.150
     0.909    30.094     0.150
     0.956    17.693     0.150
     0.996    18.693     0.150
     0.996    32.893     0.150
     1.058    19.393     0.150
     1.105    21.293     0.150
     1.133    21.094     0.150
     1.133    36.293     0.150
     1.198    22.193     0.150
     1.198    38.193     0.150
     1.205    22.492     0.150
     1.259    23.193     0.150
     1.254    22.992     0.150
     1.307    23.793     0.150
     1.367    24.693     0.150
     1.371    24.893     0.150
     1.440    25.492     0.150
     1.482    26.693     0.150
     1.471    26.293     0.150
     1.471    46.293     0.150
     1.492    26.492     0.150
     1.672    29.094     0.150
     1.767    30.193     0.150
     1.794    31.293     0.150
     1.860    32.893     0.150
     1.928    33.693     0.150
     2.028    34.992     0.150
     2.095    35.492     0.150
     2.230    37.594     0.150
     2.263    37.693     0.150
     2.505    40.793     0.150
     2.537    41.793     0.150
     2.662    43.094     0.150
     2.696    44.594     0.150
     2.722    44.594     0.150
     2.782    45.893     0.150
     2.807    45.594     0.150
     2.821    45.492     0.150
     2.945    46.793     0.150
     3.488    55.594     0.150
     3.913    61.992     0.150
     4.017    63.293     0.150
     4.200    62.873     0.150
     6.377    93.492     0.150
     9.954   142.424     0.150
    20.568   278.693     0.150
    20.568   278.072     0.150
    22.217   295.543     0.150
    26.667   339.354     0.150
    26.667   339.242     0.150
    26.667   339.924     0.150
    28.740   355.992     0.150
    28.740   355.803     0.150
    28.745   356.812     0.150
    30.031   367.844     0.150
    30.031   368.303     0.150
    30.374   371.713     0.150
    33.568   397.773     0.150
    36.742   426.363     0.150
    40.060   454.969     0.150
    40.060   455.533     0.150
    42.950   478.732     0.150
    54.469   567.604     0.150
     0.136     2.820     0.150
     0.136     5.721     0.150
     0.146     3.820     0.150
     0.146     6.621     0.150
     0.232     5.621     0.150
     0.362     7.021     0.150
     0.362    12.721     0.150
     0.436     8.420     0.150
     0.436    13.920     0.150
     0.474    10.820     0.150
     0.474    16.320     0.150
     0.500    10.021     0.150
     0.525     9.920     0.150
     0.525    17.521     0.150
     0.554    11.320     0.150
     0.554    18.721     0.150
     0.561    11.021     0.150
     0.579    11.420     0.150
     0.579    18.820     0.150
     0.674    13.121     0.150
     0.674    22.621     0.150
     0.698    13.121     0.150
     0.686    13.320     0.150
     0.788    15.420     0.150
     0.807    17.021     0.150
     0.807    16.420     0.150
     0.807    27.420     0.150
     0.908    17.320     0.150
     0.908    31.021     0.150
     0.981    18.920     0.150
     1.080    19.221     0.150
     1.124    21.521     0.150
     1.125    21.521     0.150
     1.189    21.721     0.150
     1.189    39.320     0.150
     1.188    22.621     0.150
     1.242    23.021     0.150
     1.273    23.121     0.150
     1.357    25.621     0.150
     1.361    25.320     0.150
     1.466    26.820     0.150
     1.476    26.721     0.150
     0.310     6.586     0.150
     0.310    11.535     0.150
     0.291     6.609     0.150
     0.291     6.711     0.150
     0.291    10.609     0.150
     0.370     7.410     0.150
     0.359     7.109     0.150
     0.359     6.910     0.150
     0.359    12.410     0.150
     0.359    13.312     0.150
     0.453     8.312     0.150
     0.495    10.312     0.150
     0.495    16.512     0.150
     0.498     9.910     0.150
     0.498    10.211     0.150
     0.514     9.910     0.150
     0.519    11.211     0.150
     0.519    18.410     0.150
     0.570    11.211     0.150
     0.570    19.312     0.150
     0.607    11.512     0.150
     0.607    19.812     0.150
     0.651    22.012     0.150
     0.686    13.109     0.150
     0.700    13.812     0.150
     0.700    24.410     0.150
     0.795    15.410     0.150
     0.788    15.512     0.150
     0.776    15.711     0.150
     0.776    15.211     0.150
     0.776    26.109     0.150
     0.904    17.312     0.150
     0.958    17.910     0.150
     0.958    31.910     0.150
     1.000    18.512     0.150
     1.000    32.910     0.150
     1.046    19.410     0.150
     1.046    34.312     0.150
     1.098    21.012     0.150
     1.133    21.109     0.150
     1.211    22.410     0.150
     1.211    39.609     0.150
     1.198    22.211     0.150
     1.198    38.609     0.150
     1.257    23.109     0.150
     1.257    40.109     0.150
     1.255    23.109     0.150
     1.315    23.711     0.150
     1.315    41.512     0.150
     1.372    25.109     0.150
     1.448    25.750     0.150
     1.448    25.012     0.150
     1.469    26.312     0.150
     1.497    26.211     0.150
     1.497    46.711     0.150
     1.473    26.812     0.150
     1.473    46.512     0.150
     1.667    29.012     0.150
     1.759    30.211     0.150
     1.759    53.211     0.150
     1.788    30.812     0.150
     1.788    54.711     0.150
     1.864    32.211     0.150
     1.934    34.312     0.150
     2.022    34.012     0.150
     2.026    33.812     0.150
     2.090    35.812     0.150
     2.233    36.711     0.150
     2.259    37.711     0.150
     2.502    40.621     0.150
     2.530    41.770     0.150
     2.530    42.211     0.150
     2.656    43.312     0.150
     2.690    43.609     0.150
     2.714    44.410     0.150
     2.776    45.812     0.150
     2.814    45.711     0.150
     2.944    46.312     0.150
     2.984    48.012     0.150
     3.847    58.750     0.150
     6.372    94.430     0.150
     9.950   143.762     0.150
     9.950   143.492     0.150
    11.905   173.953     0.150
    11.905   169.082     0.150
    13.076   182.430     0.150
    13.139   182.312     0.150
    15.080   213.820     0.150
    15.080   212.312     0.150
    20.559   279.035     0.150
    20.559   279.211     0.150
    20.830   280.609     0.150
    22.136   297.512     0.150
    22.210   297.691     0.150
    22.210   296.660     0.150
    22.210   297.512     0.150
    23.610   310.133     0.150
    24.086   312.641     0.150
    26.256   335.672     0.150
    26.680   338.562     0.150
    26.680   338.062     0.150
    27.333   345.680     0.150
    27.333   344.492     0.150
    28.731   356.910     0.150
    28.731   545.859     0.150
    28.737   357.020     0.150
    30.022   368.910     0.150
    30.022   549.961     0.150
    30.022   771.961     0.150
    30.022   368.480     0.150
    30.022   550.570     0.150
    30.058   369.910     0.150
    30.363   370.961     0.150
    30.574   376.902     0.150
    33.561   399.859     0.150
    36.731   426.949     0.150
    39.700   452.691     0.150
    40.050   455.562     0.150
    40.050   455.430     0.150
    40.050   455.812     0.150
    42.781   477.137     0.150
    42.940   478.781     0.150
    47.117   513.711     0.150
    47.117   510.820     0.150
    54.482   566.250     0.150
    54.482   565.852     0.150
    54.501   566.730     0.150
    55.280   571.961     0.150
    55.280   571.770     0.150
    57.129   585.387     0.150
    58.080   590.836     0.150
    58.080   590.340     0.150
    60.801   612.820     0.150
    62.648   621.535     0.150
    62.695   621.449     0.150
    63.640   627.512     0.150
    63.640   627.660     0.150
    66.407   646.785     0.150
    67.610   653.109     0.150
    68.754   662.992     0.150
    69.775   666.371     0.150
    69.775   666.859     0.150
    74.738   701.172     0.150
    74.954   697.000     0.150
    75.928   706.660     0.150
    75.928   706.262     0.150
    77.209   714.961     0.150
    78.357   720.871     0.150
    78.785   725.031     0.150
    80.201   731.672     0.150
    80.201   730.711     0.150
    80.201   732.012     0.150
    80.331   732.359     0.150
    80.331   730.262     0.150
    80.331   730.691     0.150
    82.429   742.609     0.150
    82.429   740.371     0.150
    83.119   745.004     0.150
    83.119   745.871     0.150
    88.096   771.781     0.150
    88.096   770.340     0.150
    88.849   773.859     0.150
    89.924   780.270     0.150
    89.924   779.277     0.150
    89.924   779.660     0.150
    89.924   780.812     0.150
    91.571   787.742     0.150
    92.085   790.301     0.150
    99.255   821.262     0.150
   116.420  1120.438     0.150
   132.615  1154.234     0.150
   142.788  1172.535     0.150
   142.788  1170.090     0.150
   144.030  1173.512     0.150
   144.030  1173.871     0.150
   145.106  1178.512     0.150
   146.890  1185.609     0.150
   147.318  1182.840     0.150
     0.129     2.582     0.150
     0.129     5.184     0.150
     0.152     3.781     0.150
     0.303     6.855     0.150
     0.303    12.105     0.150
     0.305     6.980     0.150
     0.305    12.582     0.150
     0.354     6.980     0.150
     0.354    13.281     0.150
     0.350     7.480     0.150
     0.431     8.281     0.150
     0.483    10.281     0.150
     0.516     9.883     0.150
     0.516    17.980     0.150
     0.508    10.480     0.150
     0.508    18.582     0.150
     0.549    11.582     0.150
     0.586    11.480     0.150
     0.586    20.082     0.150
     0.570    11.383     0.150
     0.570    20.383     0.150
     0.689    13.082     0.150
     0.689    24.582     0.150
     0.695    13.781     0.150
     0.695    22.684     0.150
     0.678    13.523     0.150
     0.678    13.684     0.150
     0.678    23.781     0.150
     0.795    15.383     0.150
     0.797    15.383     0.150
     0.797    26.480     0.150
     0.800    15.684     0.150
     0.800    27.184     0.150
     0.800    15.383     0.150
     0.800    26.980     0.150
     0.916    17.480     0.150
     0.916    30.980     0.150
     0.954    17.883     0.150
     0.954    31.582     0.150
     0.990    18.480     0.150
     1.076    19.582     0.150
     1.076    35.082     0.150
     1.116    21.184     0.150
     1.134    21.281     0.150
     1.134    36.480     0.150
     1.198    22.281     0.150
     1.197    22.383     0.150
     1.251    22.781     0.150
     1.264    23.184     0.150
     1.297    23.281     0.150
     1.366    24.980     0.150
     1.370    24.883     0.150
     1.429    23.531     0.150
     1.429    25.281     0.150
     1.485    26.281     0.150
     1.474    26.582     0.150
     1.494    26.480     0.150
     1.678    29.281     0.150
     1.779    30.082     0.150
     1.803    30.980     0.150
     1.918    33.980     0.150
     2.017    35.281     0.150
     2.032    33.980     0.150
     2.103    34.980     0.150
     2.225    37.082     0.150
     2.268    37.781     0.150
     2.509    40.902     0.150
     2.509    40.684     0.150
     2.547    42.133     0.150
     2.670    43.082     0.150
     2.705    44.082     0.150
     2.732    44.184     0.150
     2.792    45.582     0.150
     2.830    45.582     0.150
     2.946    46.480     0.150
     2.968    46.781     0.150
     3.138    50.980     0.150
     3.498    54.781     0.150
     3.826    58.934     0.150
     3.920    60.781     0.150
     4.214    62.512     0.150
     5.521    79.773     0.150
     6.384    96.152     0.150
     6.384    95.820     0.150
     9.961   145.160     0.150
    13.116   184.062     0.150
    14.683   205.531     0.150
    15.067   212.641     0.150
    16.237   226.094     0.150
    18.256   253.383     0.150
    18.624   257.891     0.150
    18.639   258.184     0.150
    20.580   279.332     0.150
    20.580   278.453     0.150
    22.166   296.781     0.150
    22.228   296.512     0.150
    22.228   297.371     0.150
    23.403   309.434     0.150
    23.624   312.352     0.150
    24.054   314.543     0.150
    24.054   312.094     0.150
    24.544   319.891     0.150
    26.649   337.332     0.150
    26.649   335.332     0.150
    26.981   340.711     0.150
    26.979   340.801     0.150
    28.751   356.781     0.150
    28.751   357.223     0.150
    30.044   368.934     0.150
    32.741   392.070     0.150
    33.585   399.711     0.150
    36.758   427.512     0.150
    36.758   426.992     0.150
    39.721   452.422     0.150
    40.074   455.602     0.150
    40.074   455.141     0.150
    42.932   479.051     0.150
    42.964   479.883     0.150
    42.964   478.762     0.150
    46.237   506.082     0.150
    47.141   513.004     0.150
    54.451   566.582     0.150
    54.451   565.031     0.150
    58.049   590.008     0.150
    59.591   601.926     0.150
    60.808   611.281     0.150
    62.039   620.023     0.150
    62.617   621.156     0.150
    63.608   626.707     0.150
    66.376   646.184     0.150
    67.579   652.883     0.150
    67.787   658.801     0.150
    69.746   666.121     0.150
    69.746   665.953     0.150
    74.748   700.594     0.150
    75.960   706.684     0.150
    75.960   706.184     0.150
    75.960   706.473     0.150
    77.031   713.434     0.150
    78.360   720.621     0.150
    80.210   731.184     0.150
    80.341   730.508     0.150
    80.341   729.844     0.150
    83.151   744.426     0.150
    83.151   745.762     0.150
    88.102   771.480     0.150
    89.230   775.672     0.150
    89.953   779.891     0.150
    89.953   779.449     0.150
    89.953   777.621     0.150
    96.368   808.711     0.150
    99.369   821.730     0.150
   100.277   823.820     0.150
   101.282   827.820     0.150
   143.349  1172.961     0.150
   144.058  1173.906     0.150
   144.058  1174.281     0.150
   144.936  1175.004     0.150
   147.336  1184.531     0.150
     0.195     5.030     0.150
     0.195     8.360     0.150
     0.241     5.370     0.150
     0.238     5.190     0.150
     0.433     8.700     0.150
     0.433    14.521     0.150
     0.438     8.860     0.150
     0.438    15.521     0.150
     0.503    10.110     0.150
     0.503    16.681     0.150
     0.554    10.550     0.150
     0.560    10.221     0.150
     0.550    11.230     0.150
     0.559    11.740     0.150
     0.587    12.490     0.150
     0.597    11.101     0.150
     0.642    12.141     0.150
     0.642    21.920     0.150
     0.725    13.950     0.150
     0.725    24.271     0.150
     0.766    15.620     0.150
     0.818    15.641     0.150
     0.852    16.080     0.150
     0.895    16.830     0.150
     0.926    17.580     0.150
     0.944    18.010     0.150
     0.948    17.780     0.150
     0.957    18.040     0.150
     0.957    30.891     0.150
     1.101    20.440     0.150
     1.106    20.311     0.150
     1.106    35.330     0.150
     1.117    21.010     0.150
     1.117    36.530     0.150
     1.288    23.340     0.150
     1.328    23.740     0.150
     1.394    24.610     0.150
     1.394    43.391     0.150
     1.576    30.290     0.150
     1.695    29.030     0.150
     1.990    33.271     0.150
     2.531    41.230     0.150
     0.144     3.575     0.150
     0.144     7.075     0.150
     0.160     3.545     0.150
     0.160     7.765     0.150
     0.177     3.595     0.150
     0.177     8.025     0.150
     0.234    10.155     0.150
     0.301     6.335     0.150
     0.301    11.315     0.150
     0.356     8.706     0.150
     0.356    14.805     0.150
     0.392     8.135     0.150
     0.392    14.575     0.150
     0.409     8.186     0.150
     0.409    14.945     0.150
     0.407     8.585     0.150
     0.407    15.445     0.150
     0.414     7.795     0.150
     0.414    15.666     0.150
     0.486    10.355     0.150
     0.486    17.555     0.150
     0.520    10.095     0.150
     0.520    17.735     0.150
     0.527     9.936     0.150
     0.527    17.706     0.150
     0.535    11.785     0.150
     0.565    11.905     0.150
     0.565    20.035     0.150
     0.571    11.095     0.150
     0.571    19.956     0.150
     0.619    11.085     0.150
     0.637    12.666     0.150
     0.637    21.735     0.150
     0.685    12.485     0.150
     0.719    13.605     0.150
     0.719    24.555     0.150
     0.753    14.146     0.150
     0.753    24.475     0.150
     0.780    27.186     0.150
     0.872    30.465     0.150
     0.916    17.355     0.150
     1.128    21.715     0.150
     1.128    37.675     0.150
     1.161    20.975     0.150
     1.161    38.075     0.150
     1.167    21.265     0.150
     1.167    38.896     0.150
     1.190    21.855     0.150
     1.190    37.916     0.150
     1.219    22.295     0.150
     1.219    39.405     0.150
     1.342    23.975     0.150
     1.374    24.495     0.150
     1.374    44.315     0.150
     1.397    43.235     0.150
     1.516    47.295     0.150
     1.543    26.865     0.150
     1.543    48.355     0.150
     1.624    27.805     0.150
     1.624    50.125     0.150
     1.673    29.015     0.150
     1.673    51.745     0.150
     1.782    30.075     0.150
     1.782    54.686     0.150
     2.091    34.706     0.150
     2.100    34.825     0.150
     2.194    36.195     0.150
     2.247    36.975     0.150
     2.502    40.666     0.150
     2.550    40.775     0.150
     2.550    84.265     0.150
     2.608    41.825     0.150
     2.608    85.635     0.150
     2.861    45.495     0.150
     2.861    80.635     0.150
     2.918    46.045     0.150
     2.918    82.855     0.150
     2.919    46.095     0.150
     2.919    82.396     0.150
     3.138    49.166     0.150
     3.138    96.825     0.150
     3.387    52.285     0.150
     3.387   101.095     0.150
     3.508    54.385     0.150
     3.508    96.725     0.150
     3.515    54.295     0.150
     3.515    97.475     0.150
     3.603    55.146     0.150
     3.585    55.475     0.150
     3.597    55.525     0.150
     3.630    55.975     0.150
     4.736    70.956     0.150
    51.376   547.206     0.150
     0.512    12.117     0.150
     0.512    20.180     0.150
     0.518    11.039     0.150
     0.518    18.656     0.150
     0.678    13.570     0.150
     0.678    23.320     0.150
     0.768    15.117     0.150
     0.768    26.266     0.150
     0.780    15.680     0.150
     0.817    15.922     0.150
     0.779    14.375     0.150
     0.779    24.539     0.150
     0.856    15.742     0.150
     0.856    26.969     0.150
     0.918    17.125     0.150
     0.918    30.102     0.150
     0.969    17.250     0.150
     0.907    16.102     0.150
     0.907    27.875     0.150
     1.039    18.906     0.150
     0.853    14.727     0.150
     0.853    14.547     0.150
     0.853    14.938     0.150
     1.181    20.906     0.150
     1.181    36.547     0.150
     1.161    36.781     0.150
     1.097    18.727     0.150
     1.299    22.547     0.150
     1.299    39.430     0.150
     1.301    22.680     0.150
     1.301    38.578     0.150
     1.382    23.828     0.150
     1.382    41.000     0.150
     1.333    22.758     0.150
     1.333    39.305     0.150
     1.316    22.625     0.150
     1.467    25.258     0.150
     1.467    44.211     0.150
     1.392    23.711     0.150
     1.568    26.500     0.150
     1.592    26.750     0.150
     1.592    44.969     0.150
     1.413    24.000     0.150
     1.413    41.172     0.150
     1.531    25.977     0.150
     1.754    29.680     0.150
     1.754    52.336     0.150
     1.614    26.820     0.150
     1.569    25.758     0.150
     1.569    44.422     0.150
     1.733    29.000     0.150
     1.733    50.016     0.150
     1.599    25.578     0.150
     1.599    42.930     0.150
     1.825    29.406     0.150
     1.825    53.266     0.150
     1.724    28.609     0.150
     1.724    48.867     0.150
     1.847    30.258     0.150
     1.847    53.391     0.150
     1.996    32.742     0.150
     2.222    35.930     0.150
     2.222    63.789     0.150
     2.117    33.688     0.150
     2.600    40.930     0.150
     2.600    73.438     0.150
     2.314    36.391     0.150
     2.314    63.266     0.150
     2.440    38.336     0.150
     2.440    67.648     0.150
     2.826    44.297     0.150
     2.926    45.578     0.150
     2.780    43.305     0.150
     2.788    42.469     0.150
     3.311    51.516     0.150
     2.921    44.078     0.150
     2.921    75.781     0.150
     2.921    44.266     0.150
     2.921    77.297     0.150
     3.127    48.086     0.150
     3.203    48.539     0.150
     3.305    50.039     0.150
     3.370    51.859     0.150
     3.682    57.180     0.150
     3.697    57.328     0.150
     3.429    50.531     0.150
     3.429    52.109     0.150
     3.556    53.508     0.150
     3.641    53.195     0.150
     3.641    95.109     0.150
     3.641    54.461     0.150
     3.617    54.789     0.150
     3.623    55.125     0.150
     3.658    54.969     0.150
     4.001    60.727     0.150
     3.724    56.195     0.150
     3.824    57.242     0.150
     3.900    58.641     0.150
     4.174    63.789     0.150
     3.933    58.828     0.150
     4.052    61.398     0.150
     4.157    63.086     0.150
     4.324    63.977     0.150
     4.631    69.242     0.150
     4.799    71.328     0.150
     5.017    73.117     0.150
     5.113    75.867     0.150
     5.113   129.680     0.150
     5.113    75.602     0.150
     4.887    72.961     0.150
     4.949    72.711     0.150
     4.930    72.969     0.150
     5.036    73.688     0.150
     5.466    76.938     0.150
     5.639    82.945     0.150
     5.748    84.047     0.150
     5.792    84.695     0.150
     6.250    90.695     0.150
     6.751    96.766     0.150
     6.567    95.227     0.150
     7.068   102.781     0.150
     6.848    99.156     0.150
     6.861    99.430     0.150
     7.176   101.727     0.150
     7.281   103.930     0.150
     7.281   105.508     0.150
     7.281   104.531     0.150
    10.882   153.875     0.150
    10.882   153.266     0.150
    12.884   175.891     0.150
    17.346   237.719     0.150
    17.346   238.461     0.150
    21.000   280.070     0.150
    21.000   279.859     0.150
    22.857   299.617     0.150
    22.857   298.219     0.150
    25.745   324.602     0.150
    27.170   333.695     0.150
    27.170   538.148     0.150
    27.170   335.055     0.150
    27.508   337.547     0.150
    27.506   337.648     0.150
    29.273   356.977     0.150
    29.273   542.898     0.150
    29.273   356.828     0.150
    29.280   357.031     0.150
    30.719   371.820     0.150
    30.400   368.297     0.150
    30.400   546.055     0.150
    30.400   367.148     0.150
    33.933   391.047     0.150
    34.150   402.242     0.150
    34.150   399.688     0.150
    40.273   453.250     0.150
    40.273   453.656     0.150
    40.757   455.242     0.150
    43.233   479.055     0.150
    43.233   478.742     0.150
    47.441   507.047     0.150
    47.441   597.852     0.150
    52.056   542.836     0.150
    52.979   545.633     0.150
    52.979   547.086     0.150
    54.910   562.078     0.150
    55.332   626.945     0.150
    56.572   573.172     0.150
    57.092   580.070     0.150
    58.030   584.875     0.150
    58.161   583.547     0.150
    58.161   584.547     0.150
    58.522   587.172     0.150
    58.941   592.172     0.150
    58.941   590.945     0.150
    59.033   594.898     0.150
    59.033   593.891     0.150
    60.462   600.547     0.150
    60.779   601.969     0.150
    63.086   618.375     0.150
    63.086   657.625     0.150
    63.135   620.375     0.150
    63.135   619.445     0.150
    63.107   619.031     0.150
    63.137   618.750     0.150
    64.203   624.766     0.150
    64.203   660.922     0.150
    64.203   624.570     0.150
    64.205   627.523     0.150
    67.324   644.523     0.150
    67.462   650.602     0.150
    67.980   650.156     0.150
    68.023   650.539     0.150
    67.974   654.945     0.150
    69.392   663.297     0.150
    69.392    15.039     0.150
    69.960   662.641     0.150
    69.960   662.852     0.150
    71.784   672.711     0.150
    71.536   675.289     0.150
    74.681   692.797     0.150
    75.151   696.031     0.150
    75.263   694.242     0.150
    75.637   696.477     0.150
    75.653   698.930     0.150
    76.143   705.156     0.150
    77.086   705.898     0.150
    77.097   710.320     0.150
    78.240   714.781     0.150
    78.328   715.391     0.150
    78.487   715.352     0.150
    78.548   711.922     0.150
    80.555   722.328     0.150
    81.095   730.109     0.150
    82.195   734.445     0.150
    82.195   734.203     0.150
    82.195   734.445     0.150
    82.574   737.227     0.150
    82.255   736.914     0.150
    82.255   737.617     0.150
    82.255   735.617     0.150
    87.548   761.500     0.150
    87.639   761.891     0.150
    88.168   763.695     0.150
    88.176   764.305     0.150
    88.176   763.469     0.150
    88.463   767.297     0.150
    91.910   781.891     0.150
    92.217   783.219     0.150
    93.559   788.891     0.150
    93.559    15.961     0.150
    94.168   790.039     0.150
    94.168   790.719     0.150
    97.618   806.109     0.150
    99.254   814.711     0.150
    99.690   816.969     0.150
   102.099   828.641     0.150
   117.608  1118.375     0.150
   117.608  1118.719     0.150
   132.684  1149.188     0.150
   141.446  1166.086     0.150
   141.224  1164.672     0.150
   144.173  1168.391     0.150
   144.173  1168.852     0.150
   144.384  1167.211     0.150
   145.028  1168.672     0.150
   145.286  1168.969     0.150
   145.524  1170.117     0.150
   145.494  1170.602     0.150
   145.672  1171.320     0.150
   145.958  1171.805     0.150
   146.385  1175.148     0.150
     0.089     3.008     0.150
     0.083     3.090     0.150
     0.254     6.469     0.150
     0.254    10.891     0.150
     0.508    10.320     0.150
     0.508    16.867     0.150
     0.524    17.199     0.150
     0.650    12.797     0.150
     0.650    21.539     0.150
     0.654    13.328     0.150
     0.654    21.910     0.150
     0.734    14.617     0.150
     0.812    16.949     0.150
     0.829    15.469     0.150
     0.916    17.688     0.150
     0.991    18.578     0.150
     0.991    32.898     0.150
     1.145    21.391     0.150
     1.145    35.930     0.150
     1.147    21.020     0.150
     1.169    37.520     0.150
     1.345    24.270     0.150
     1.374    24.707     0.150
     1.467    26.070     0.150
     1.491    26.840     0.150
     1.581    27.750     0.150
     1.749    30.891     0.150
     1.749    53.188     0.150
     1.753    30.758     0.150
     1.889    33.430     0.150
     1.143    18.578     0.150
     1.143    32.180     0.150
     2.803    40.809     0.150
     3.937    59.488     0.150
     4.904    72.430     0.150
     5.108    76.887     0.150
     7.575   110.180     0.150
    10.519   151.566     0.150
    12.683   175.250     0.150
    12.683   174.727     0.150
    12.861   175.309     0.150
    12.861   175.508     0.150
    12.861   177.887     0.150
    13.414   186.527     0.150
    13.414   187.773     0.150
    15.568   216.430     0.150
    15.568   218.629     0.150
    16.718   231.777     0.150
    16.551   227.527     0.150
    18.164   245.098     0.150
    18.440   251.727     0.150
    18.440   252.328     0.150
    20.187   269.168     0.150
    20.187   270.227     0.150
    21.246   282.902     0.150
    21.246   283.367     0.150
    22.435   293.566     0.150
    22.008   292.027     0.150
    22.008   294.129     0.150
    23.161   300.027     0.150
    23.161   300.617     0.150
    23.127   301.328     0.150
    23.127   302.449     0.150
    23.127   302.129     0.150
    23.013   303.598     0.150
    24.817   313.758     0.150
    24.817   314.867     0.150
    24.715   316.219     0.150
    25.578   322.809     0.150
    26.042   326.707     0.150
    26.042   327.688     0.150
    26.042   328.129     0.150
    25.982   326.930     0.150
    26.814   334.629     0.150
    26.814   608.129     0.150
    27.103   334.727     0.150
    27.103   334.438     0.150
    27.103   538.934     0.150
    27.103   755.512     0.150
    27.103   335.738     0.150
    27.442   338.129     0.150
    27.442   337.648     0.150
    27.440   337.668     0.150
    27.216   339.977     0.150
    27.514   344.020     0.150
    29.517   360.617     0.150
    29.530   360.055     0.150
    29.530   544.852     0.150
    29.530   762.758     0.150
    29.537   359.629     0.150
    29.537   360.117     0.150
    29.537   360.418     0.150
    29.537   360.828     0.150
    30.473   368.488     0.150
    30.495   369.367     0.150
    30.495   370.227     0.150
    30.495   369.727     0.150
    30.637   371.227     0.150
    30.637   370.129     0.150
    30.637   547.977     0.150
    30.637   766.828     0.150
    30.637   997.629     0.150
    30.637   371.309     0.150
    30.674   371.527     0.150
    34.157   398.547     0.150
    34.015   399.848     0.150
    34.414   400.379     0.150
    34.412   403.438     0.150
    34.412   403.637     0.150
    35.328   411.027     0.150
    35.829   413.379     0.150
    36.475   419.770     0.150
    36.475   420.180     0.150
    37.179   421.008     0.150
    37.286   426.500     0.150
    37.286   770.816     0.150
    37.016   425.758     0.150
    37.016   426.258     0.150
    37.959   434.547     0.150
    37.959   434.848     0.150
    37.959   435.129     0.150
    38.162   435.398     0.150
    39.271   444.977     0.150
    39.271   445.398     0.150
    40.298   450.457     0.150
    40.188   452.430     0.150
    40.188   451.840     0.150
    40.340   454.168     0.150
    40.340   454.090     0.150
    40.340   454.520     0.150
    40.340   455.227     0.150
    40.376   454.867     0.150
    40.376   455.930     0.150
    40.485   454.629     0.150
    40.485   455.203     0.150
    41.055   458.566     0.150
    41.055   459.059     0.150
    43.172   478.430     0.150
    43.455   479.898     0.150
    43.455   480.129     0.150
    45.249   490.398     0.150
    45.564   494.930     0.150
    46.076   502.289     0.150
    46.669   505.680     0.150
    47.420   599.328     0.150
    48.063   512.129     0.150
    48.063   512.668     0.150
    47.547   512.777     0.150
    47.547   513.250     0.150
    47.790   515.887     0.150
    47.790   514.949     0.150
    47.790   516.129     0.150
    48.428   516.129     0.150
    48.356   519.227     0.150
    48.585   518.930     0.150
    48.738   517.090     0.150
    49.196   522.348     0.150
    49.197   521.043     0.150
    49.197   605.477     0.150
    51.617   537.887     0.150
    51.617   538.148     0.150
    51.617   538.527     0.150
    51.988   540.547     0.150
    51.988   540.867     0.150
    51.896   541.668     0.150
    51.896   542.129     0.150
    51.423   541.918     0.150
    53.150   551.430     0.150
    53.150   548.535     0.150
    53.150   618.992     0.150
    53.150   548.617     0.150
    53.150   549.379     0.150
    54.103   556.629     0.150
    54.103   623.629     0.150
    54.091   560.227     0.150
    54.091   624.129     0.150
    54.831   563.227     0.150
    54.798   561.930     0.150
    55.347   566.629     0.150
    55.347   627.938     0.150
    55.347   862.297     0.150
    55.380   567.309     0.150
    55.380   567.527     0.150
    55.392   567.520     0.150
    55.750   570.887     0.150
    55.837   570.207     0.150
    56.126   571.930     0.150
    56.171   572.277     0.150
    56.442   573.930     0.150
    56.434   574.449     0.150
    56.434   575.219     0.150
    56.434   576.227     0.150
    56.469   575.027     0.150
    56.603   574.793     0.150
    56.603   575.738     0.150
    56.502   574.930     0.150
    56.679   576.238     0.150
    56.758   578.117     0.150
    56.904   577.520     0.150
    56.949   579.148     0.150
    57.268   582.707     0.150
    57.330   581.090     0.150
    57.508   582.648     0.150
    57.816   583.379     0.150
    57.735   584.387     0.150
    57.966   585.527     0.150
    57.887   586.020     0.150
    58.036   584.727     0.150
    58.036   586.758     0.150
    58.036   586.508     0.150
    58.036   638.172     0.150
    58.229   586.062     0.150
    58.296   587.520     0.150
    58.168   588.945     0.150
    58.439   587.629     0.150
    58.439   588.066     0.150
    58.593   591.387     0.150
    58.774   593.945     0.150
    58.800   593.969     0.150
    58.800   594.387     0.150
    58.800   595.727     0.150
    58.800   593.723     0.150
    58.804   594.723     0.150
    58.884   593.820     0.150
    58.497   592.238     0.150
    58.497   592.617     0.150
    59.023   595.102     0.150
    59.207   596.945     0.150
    59.259   597.344     0.150
    59.352   598.141     0.150
    59.598   596.328     0.150
    59.585   596.969     0.150
    59.195   598.449     0.150
    59.724   597.477     0.150
    59.818   598.438     0.150
    60.127   599.809     0.150
    60.161   601.047     0.150
    60.556   602.430     0.150
    60.562   602.969     0.150
    60.890   604.328     0.150
    60.890   604.180     0.150
    60.890   649.145     0.150
    61.055   606.508     0.150
    62.258   614.867     0.150
    63.001   618.863     0.150
    63.001   658.953     0.150
    63.051   620.227     0.150
    63.051   619.609     0.150
    63.256   621.430     0.150
    63.256   620.887     0.150
    63.256   621.328     0.150
    63.286   619.430     0.150
    64.147   626.688     0.150
    64.147   625.629     0.150
    64.147   662.586     0.150
    64.147   626.117     0.150
    64.022   627.977     0.150
    64.022   628.387     0.150
    64.604   630.438     0.150
    65.347   636.227     0.150
    66.513   646.777     0.150
    66.513   646.316     0.150
    67.357   646.602     0.150
    67.357   674.703     0.150
    67.457   650.754     0.150
    67.588   651.676     0.150
    67.881   650.805     0.150
    67.924   651.930     0.150
    67.924   651.809     0.150
    68.143   654.613     0.150
    67.981   657.250     0.150
    69.322   664.867     0.150
    69.824   664.348     0.150
    69.614   664.809     0.150
    70.121   667.758     0.150
    70.121   669.328     0.150
    69.994   668.289     0.150
    69.994   669.027     0.150
    71.859   674.527     0.150
    71.859   674.207     0.150
    71.859   674.828     0.150
    74.162   691.629     0.150
    74.473   690.352     0.150
    74.473   691.039     0.150
    74.505   692.430     0.150
    74.494   694.027     0.150
    74.887   693.219     0.150
    74.960   697.027     0.150
    75.150   695.828     0.150
    75.157   697.500     0.150
    75.761   698.566     0.150
    75.761   698.789     0.150
    75.842   701.027     0.150
    75.314   699.500     0.150
    76.111   703.090     0.150
    76.341   703.129     0.150
    76.839   707.328     0.150
    76.899   707.129     0.150
    76.899   706.703     0.150
    76.392   706.547     0.150
    76.392   706.887     0.150
    77.132   707.828     0.150
    77.132   708.137     0.150
    77.210   709.645     0.150
    78.039   711.629     0.150
    78.039   711.078     0.150
    78.036   714.688     0.150
    78.086   714.719     0.150
    78.086   714.090     0.150
    78.086   715.328     0.150
    78.280   715.090     0.150
    78.334   715.809     0.150
    78.664   716.227     0.150
    78.664   714.082     0.150
    78.664   717.500     0.150
    78.786   717.348     0.150
    78.581   719.328     0.150
    78.698   720.602     0.150
    78.698   720.469     0.150
    78.698   720.938     0.150
    79.315   721.008     0.150
    79.507   721.867     0.150
    80.352   725.129     0.150
    80.608   724.406     0.150
    80.608   723.566     0.150
    80.868   729.688     0.150
    80.868   730.629     0.150
    80.947   730.219     0.150
    81.985   734.430     0.150
    81.985   922.879     0.150
    82.361   737.438     0.150
    82.238   737.371     0.150
    82.238   737.566     0.150
    84.285   749.727     0.150
    85.841   753.328     0.150
    85.806   755.090     0.150
    86.399   753.504     0.150
    86.568   760.027     0.150
    86.504   761.449     0.150
    87.353   761.840     0.150
    87.989   765.930     0.150
    87.997   763.254     0.150
    87.997   970.180     0.150
    87.997   764.328     0.150
    88.005   763.328     0.150
    88.005   764.199     0.150
    88.098   765.027     0.150
    88.474   767.707     0.150
    88.930   770.207     0.150
    88.930   769.746     0.150
    88.672   770.309     0.150
    88.672   770.070     0.150
    88.672   771.027     0.150
    89.751   772.828     0.150
    89.809   773.109     0.150
    90.429   774.219     0.150
    90.361   776.199     0.150
    91.097   779.680     0.150
    91.250   779.180     0.150
    91.652   780.156     0.150
    91.839   782.809     0.150
    91.959   781.566     0.150
    92.031   784.168     0.150
    92.211   782.559     0.150
    92.214   782.738     0.150
    92.214  1073.766     0.150
    92.214   783.719     0.150
    92.323   784.719     0.150
    91.842   784.477     0.150
    92.780   787.559     0.150
    93.047   786.758     0.150
    93.288   788.238     0.150
    93.398   789.738     0.150
    94.080   790.832     0.150
    94.080   792.398     0.150
    94.534   793.109     0.150
    94.441   794.359     0.150
    95.208   798.316     0.150
    95.656   798.367     0.150
    97.572   806.398     0.150
    97.643   808.703     0.150
    97.643  1045.961     0.150
    98.085   809.809     0.150
    99.314   815.098     0.150
   117.727  1119.727     0.150
   127.904  1140.629     0.150
   129.408  1145.527     0.150
   129.412  1145.828     0.150
   131.679  1149.594     0.150
   131.679  1351.805     0.150
   132.755  1149.184     0.150
   132.755  1352.328     0.150
   132.755  1361.020     0.150
   132.864  1150.930     0.150
   132.874  1152.129     0.150
   132.874  1150.488     0.150
   132.874  1352.648     0.150
   133.705  1150.559     0.150
   133.705  1354.805     0.150
   135.033  1154.527     0.150
   139.399  1161.227     0.150
   141.534  1163.027     0.150
   142.670  1167.602     0.150
   142.670  1382.195     0.150
   144.000  1171.129     0.150
   144.406  1171.129     0.150
   144.408  1170.930     0.150
   144.409  1170.629     0.150
   144.409  1386.977     0.150
   145.707  1176.207     0.150
   147.521  1177.828     0.150
   148.297  1183.328     0.150
   148.857  1182.328     0.150
   149.537  1183.430     0.150
   150.632  1188.527     0.150
   155.534  1190.930     0.150
    56.581   576.270     0.150
    81.985   735.277     0.150
    81.985   735.047     0.150
    57.219   581.199     0.150
    58.229   587.066     0.150
    67.357   647.500     0.150
    56.603   575.277     0.150
     0.131     3.013     0.150
     0.131     2.912     0.150
     0.131     5.562     0.150
     2.930    45.112     0.150
     5.281    77.143     0.150
     5.281   139.242     0.150
     5.492    80.543     0.150
     6.645    96.202     0.150
     9.908   142.103     0.150
    10.244   147.662     0.150
    10.244   145.482     0.150
    12.404   176.143     0.150
    12.404   177.803     0.150
    12.404   174.986     0.150
    12.404   174.753     0.150
    13.207   183.412     0.150
    13.207   184.412     0.150
    13.251   186.053     0.150
    13.251   186.263     0.150
    14.621   211.152     0.150
    14.621   203.463     0.150
    15.742   221.853     0.150
    16.092   221.562     0.150
    16.092   221.072     0.150
    16.492   228.183     0.150
    16.714   235.952     0.150
    16.714   232.862     0.150
    18.305   254.192     0.150
    18.011   249.202     0.150
    18.011   249.520     0.150
    18.387   251.862     0.150
    19.173   263.452     0.150
    20.564   278.862     0.150
    20.564   278.067     0.150
    20.564   277.192     0.150
    21.426   287.103     0.150
    21.426   284.683     0.150
    22.334   296.343     0.150
    23.228   303.133     0.150
    22.932   302.933     0.150
    23.839   312.942     0.150
    23.839   310.013     0.150
    24.633   317.293     0.150
    24.633   315.822     0.150
    25.035   321.463     0.150
    25.099   323.343     0.150
    25.826   332.683     0.150
    27.121   341.643     0.150
    27.121   338.814     0.150
    27.121   542.465     0.150
    27.121   339.022     0.150
    26.882   340.662     0.150
    26.883   341.530     0.150
    27.456   341.843     0.150
    27.456   342.333     0.150
    27.454   342.333     0.150
    27.295   345.263     0.150
    28.796   357.968     0.150
    28.802   357.942     0.150
    28.802   356.362     0.150
    29.996   367.692     0.150
    29.996   550.843     0.150
    29.996   549.353     0.150
    30.119   371.643     0.150
    30.119   368.793     0.150
    33.449   399.713     0.150
    33.654   400.043     0.150
    35.590   417.143     0.150
    36.555   426.713     0.150
    36.555   423.963     0.150
    37.339   433.213     0.150
    37.340   434.013     0.150
    37.828   433.383     0.150
    37.828   569.473     0.150
    37.828   785.412     0.150
    39.245   446.603     0.150
    39.245   446.143     0.150
    39.544   450.593     0.150
    39.544   450.603     0.150
    39.544   449.293     0.150
    39.706   453.583     0.150
    39.942   454.242     0.150
    39.942   454.412     0.150
    39.942   579.043     0.150
    40.511   456.043     0.150
    41.307   462.543     0.150
    41.307   838.442     0.150
    42.723   479.192     0.150
    42.870   478.942     0.150
    42.870   477.242     0.150
    43.481   484.812     0.150
    45.162   497.603     0.150
    45.162   495.123     0.150
    46.116   505.662     0.150
    47.273   510.143     0.150
    47.273   933.942     0.150
    47.008   509.513     0.150
    47.435   512.343     0.150
    47.435   512.603     0.150
    47.435   510.753     0.150
    47.146   515.103     0.150
    47.994   515.242     0.150
    47.970   515.143     0.150
    47.970   932.242     0.150
    48.027   516.442     0.150
    48.571   520.112     0.150
    48.571   520.133     0.150
    48.571   519.393     0.150
    52.402   547.843     0.150
    52.402   547.492     0.150
    52.402   621.331     0.150
    52.402   619.162     0.150
    53.559   558.242     0.150
    55.077   567.121     0.150
    55.077   567.673     0.150
    55.100   568.343     0.150
    55.100   568.652     0.150
    55.100   568.213     0.150
    55.100   569.262     0.150
    55.889   573.242     0.150
    56.209   580.646     0.150
    56.698   582.951     0.150
    57.098   585.472     0.150
    57.231   584.803     0.150
    57.142   586.582     0.150
    57.238   588.610     0.150
    57.487   586.492     0.150
    57.735   588.242     0.150
    57.937   592.862     0.150
    58.217   593.628     0.150
    58.504   591.948     0.150
    58.504   592.383     0.150
    58.681   595.938     0.150
    58.750   595.697     0.150
    58.748   597.022     0.150
    59.429   602.852     0.150
    59.439   602.452     0.150
    59.439   602.943     0.150
    59.445   602.986     0.150
    59.662   604.885     0.150
    59.793   603.291     0.150
    59.853   605.610     0.150
    59.901   606.393     0.150
    60.140   603.742     0.150
    60.318   604.942     0.150
    62.569   620.242     0.150
    63.071   621.617     0.150
    63.071   662.902     0.150
    63.119   622.543     0.150
    63.119   621.933     0.150
    63.119   623.343     0.150
    63.119   660.933     0.150
    63.814   631.849     0.150
    64.118   630.643     0.150
    64.118   629.117     0.150
    64.118   629.763     0.150
    64.126   633.241     0.150
    64.457   634.293     0.150
    64.457   632.942     0.150
    65.831   645.393     0.150
    65.831   642.793     0.150
    67.028   648.593     0.150
    67.063   652.812     0.150
    68.003   655.543     0.150
    68.046   656.343     0.150
    68.212   659.887     0.150
    68.183   659.902     0.150
    69.262   666.843     0.150
    69.262   667.633     0.150
    70.081   669.412     0.150
    70.288   675.583     0.150
    70.288   672.062     0.150
    70.288   675.896     0.150
    71.398   676.043     0.150
    71.792   679.468     0.150
    74.374   695.333     0.150
    75.319   700.336     0.150
    75.663   703.343     0.150
    75.409   703.022     0.150
    76.483   709.702     0.150
    76.814   712.143     0.150
    77.292   713.343     0.150
    77.344   714.643     0.150
    77.344   714.067     0.150
    77.879   714.543     0.150
    78.076   717.242     0.150
    78.688   720.952     0.150
    78.761   721.543     0.150
    78.809   719.883     0.150
    78.843   721.732     0.150
    78.862   722.543     0.150
    79.293   723.793     0.150
    79.257   724.883     0.150
    79.257   722.713     0.150
    79.257   723.762     0.150
    79.877   727.183     0.150
    79.691   729.668     0.150
    79.691   727.072     0.150
    80.540   730.143     0.150
    80.540   729.117     0.150
    81.477   735.492     0.150
    82.526   740.603     0.150
    82.526   739.543     0.150
    82.517   742.192     0.150
    82.912   742.383     0.150
    83.191   743.742     0.150
    83.676   749.043     0.150
    86.034   757.543     0.150
    85.975   758.562     0.150
    87.030   764.982     0.150
    87.517   766.662     0.150
    88.023   767.503     0.150
    88.115   771.543     0.150
    88.109   769.843     0.150
    88.384   769.718     0.150
    88.384   769.393     0.150
    89.406   774.986     0.150
    89.229   777.034     0.150
    89.229   775.112     0.150
    90.833   781.083     0.150
    92.431   789.135     0.150
    92.431   787.162     0.150
   117.126  1122.043     0.150
   117.126  1753.893     0.150
   117.126  1121.723     0.150
   128.517  1145.945     0.150
   128.517  1144.992     0.150
   129.585  1147.866     0.150
   131.461  1150.003     0.150
   132.070  1153.643     0.150
   132.070  1150.763     0.150
   132.000  1154.718     0.150
   132.740  1152.433     0.150
   134.286  1154.933     0.150
   134.418  1156.143     0.150
   138.524  1164.262     0.150
   138.524  1163.532     0.150
   141.011  1168.333     0.150
   143.488  1171.442     0.150
   143.723  1171.662     0.150
   143.317  1173.143     0.150
   143.317  1172.402     0.150
   144.505  1174.883     0.150
   145.274  1178.333     0.150
   145.313  1176.662     0.150
   146.629  1178.873     0.150
   146.932  1178.293     0.150
   146.609  1182.213     0.150
   147.692  1180.312     0.150
   148.213  1179.473     0.150
   148.686  1182.152     0.150
   156.001  1195.317     0.150
   156.001  1223.692     0.150
   156.001  1441.293     0.150
   167.064  1205.763     0.150
   169.880  1208.152     0.150
    70.081   669.152     0.150
    82.526   739.702     0.150
    27.121   339.593     0.150
    72.321   682.412     0.150
     3.464    54.383     0.150
     3.464    97.556     0.150
     5.281    78.437     0.150
     5.281   143.603     0.150
     5.492    83.624     0.150
     6.645    95.726     0.150
     6.645    96.843     0.150
     9.908   141.506     0.150
    10.244   148.371     0.150
    13.207   183.540     0.150
    13.207   186.343     0.150
    13.251   185.769     0.150
    14.621   212.143     0.150
    15.742   219.653     0.150
    15.742   224.043     0.150
    16.492   230.438     0.150
    16.408   231.180     0.150
    16.714   235.298     0.150
    18.011   248.822     0.150
    18.387   254.348     0.150
    19.173   261.897     0.150
    19.173   264.143     0.150
    19.311   265.475     0.150
    20.564   278.623     0.150
    21.426   286.887     0.150
    21.782   293.475     0.150
    22.334   297.432     0.150
    22.334   299.143     0.150
    22.932   304.948     0.150
    23.839   312.779     0.150
    24.690   321.197     0.150
    25.035   322.389     0.150
    25.099   322.989     0.150
    25.685   330.504     0.150
    25.689   331.817     0.150
    25.826   332.290     0.150
    26.440   337.314     0.150
    26.631   337.254     0.150
    26.882   340.783     0.150
    26.883   342.013     0.150
    27.295   344.698     0.150
    27.456   342.146     0.150
    28.802   356.629     0.150
    29.996   369.843     0.150
    29.972   368.439     0.150
    30.119   371.265     0.150
    30.119   372.742     0.150
    32.756   391.742     0.150
    33.475   397.643     0.150
    33.475   717.643     0.150
    33.449   399.316     0.150
    33.654   399.822     0.150
    33.672   400.848     0.150
    35.590   416.966     0.150
    36.555   426.540     0.150
    36.726   426.657     0.150
    37.339   432.923     0.150
    37.340   434.942     0.150
    37.563   434.266     0.150
    38.191   440.314     0.150
    38.335   440.643     0.150
    38.425   441.817     0.150
    39.245   446.270     0.150
    39.544   450.162     0.150
    39.763   453.068     0.150
    42.723   478.812     0.150
    42.870   478.768     0.150
    44.382   488.442     0.150
    45.142   494.242     0.150
    45.162   498.099     0.150
    45.162   499.143     0.150
    46.116   505.020     0.150
    47.008   512.585     0.150
    47.146   514.693     0.150
    47.173   512.819     0.150
    47.435   512.837     0.150
    52.402   548.057     0.150
    54.112   563.442     0.150
    55.100   570.512     0.150
    58.748   598.630     0.150
    59.439   603.442     0.150
    59.548   607.579     0.150
    60.205   611.727     0.150
    63.145   628.395     0.150
    65.831   646.357     0.150
    66.494   650.683     0.150
    66.751   652.539     0.150
    67.063   655.257     0.150
    67.063   656.043     0.150
    67.339   655.342     0.150
    68.183   662.407     0.150
    69.262   668.543     0.150
    70.288   676.442     0.150
    75.319   698.412     0.150
    78.761   721.942     0.150
    78.761   723.043     0.150
    79.585   729.215     0.150
    81.477   738.143     0.150
    83.191   743.549     0.150
    87.517   770.912     0.150
    89.229   778.453     0.150
   129.195  1148.293     0.150
   143.652  1174.367     0.150
   143.556  1175.423     0.150
   145.139  1176.037     0.150
   146.629  1178.412     0.150
   146.932  1179.062     0.150
   147.930  1189.062     0.150
   148.213  1182.688     0.150
   148.686  1189.513     0.150
   161.237  1202.112     0.150
    29.996   369.166     0.150
    28.726   358.277     0.150
    24.579   322.237     0.150
    79.691   730.942     0.150
   156.001  1196.518     0.150
    28.119   351.698     0.150
    25.207   326.698     0.150
    25.471   328.865     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
