#!/bin/bash
gmt begin bandung1.79_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-4/3/0/54
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya20f10+l'Counts' -BWeSn+t'Origin Time Mislocation bandung1.79' << EOF
    -1.242
    -0.516
     0.531
     0.908
    -1.156
    -0.170
    -0.497
     1.043
    -0.156
    -0.621
    -0.305
    -1.844
    -0.188
    -0.133
    -0.355
    -0.047
     0.122
     0.195
     0.168
    -0.637
    -0.297
     0.685
     0.514
    -0.195
    -0.505
    -0.047
    -0.309
     0.176
    -0.055
    -0.168
     0.105
    -0.087
    -0.844
     0.248
     0.352
     0.003
    -0.562
    -0.262
    -2.062
     0.211
    -0.148
     0.650
    -0.580
    -0.324
    -0.270
    -0.344
    -0.488
    -1.031
    -0.242
    -0.076
    -0.586
    -0.344
    -0.219
    -0.695
    -0.633
    -0.203
    -0.445
    -0.312
    -0.375
    -0.873
    -0.467
    -0.478
    -0.070
     0.305
    -0.398
    -0.520
    -0.156
    -0.438
     0.055
    -0.664
    -0.629
    -0.391
     0.109
    -2.453
    -0.318
    -0.760
    -0.555
    -0.508
    -0.570
     0.658
     0.276
     1.191
    -0.692
    -0.162
    -0.387
     0.600
    -0.500
    -0.406
    -0.277
    -0.242
     0.328
    -0.402
     0.086
    -0.430
     0.023
    -0.316
     0.035
     0.121
    -0.035
    -0.113
    -0.379
    -0.272
    -2.125
    -0.082
     0.699
    -2.640
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.275    47.835 Median =  -0.3 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.3  0.
 -0.3  46.9
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -3.800    51.165 Author: all ( 106 samples)
EOF
gmt end
