#!/bin/bash
gmt begin bandung1.79_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-45/45/-45/45
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation bandung1.79'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     5.531     5.531
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.981    25.134
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.981    25.134 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.464    15.778
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.464    15.778 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.166    24.302
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.166    24.302 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.637    16.170
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.637    16.170 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.590     6.886
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.590     6.886 5
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.409    10.436
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.409    10.436 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.775    14.793
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.775    14.793 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.234     5.805
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.234     5.805 8
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.809     6.340
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.809     6.340 9
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.945    -4.702
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.945    -4.702 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.303     1.914
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.948    28.092
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.948    28.092 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.579     2.726
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.674    -1.671
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.435     1.486
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.917    12.478
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.917    12.478 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.158     1.626
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.538    -0.896
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.937     0.412
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.384     0.269
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.557     1.923
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.463     0.987
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.799     5.687
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.799     5.687 23
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.647     4.076
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.510    -0.079
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.498     2.563
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.605     0.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.737     4.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.486     5.578
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.486     5.578 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.430     2.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.011     0.762
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.336    21.403
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.336    21.403 32
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.091    -2.841
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.963     3.358
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.397     5.672
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.397     5.672 35
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.588    -2.390
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.588    -2.390 36
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.423     1.302
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.975     1.759
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.139    21.731
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.139    21.731 39
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.705     2.528
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.753     2.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.385    14.494
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.385    14.494 42
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.287    -0.938
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.087     0.790
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.381    -0.335
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.342    -0.436
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.137     0.242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.172    -6.686
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.172    -6.686 48
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.803    -0.253
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.910    -1.867
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.769     0.538
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.376    -1.543
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.051    -0.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.891     0.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.178    -0.245
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.213    -0.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.039    -0.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.846     0.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.594    -0.893
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.646    -1.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.945     1.501
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.790    -0.456
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.560    -4.725
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.560    -4.725 63
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.632    -2.360
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.426     0.545
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.233    -0.086
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.007    -2.309
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.369    -0.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.092     3.173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.468     0.785
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.468     0.785 70
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.224     0.804
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.693     2.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.448     6.403
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     0.448     6.403 73
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.459    13.131
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.459    13.131 74
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.311     4.571
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.087     1.281
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.087     1.281 76
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.211     1.197
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.266     2.107
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.408     0.837
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.427     2.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.518     2.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.069    19.972
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.069    19.972 82
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.159    -0.972
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.584     2.348
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.481     1.254
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.228     6.516
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.228     6.516 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.630     1.292
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.301     1.122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.639    -0.532
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.249    -1.851
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.129     3.475
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.948    -0.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.286     0.969
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.071    -4.060
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.957     0.924
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.279     1.780
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.476    -0.567
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.766     0.793
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.934     5.299
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.852     2.972
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.616     0.788
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.982     0.795
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.076    26.409
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.076    26.409 103
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.439     0.015
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    14.417    41.870
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    14.417    41.870 105
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.459    25.682
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.459    25.682 106
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -0.172     3.966     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000    43.000 Author: all ( 106 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -43.000   -43.000 Average =   4.0 km at 357.5 deg; median =    2.8 km
EOF
gmt end
