#!/bin/bash
gmt begin bandung1.79_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-27/28/0/13
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation bandung1.79' << EOF
     0.500
     1.500
    12.700
    22.800
     7.100
     7.000
     9.000
    10.000
    13.000
     4.000
    -0.200
   -11.000
    -3.000
    -5.000
    -5.000
    15.300
    -3.000
    -5.000
    -5.000
    -4.000
    -5.000
    -1.000
    -1.000
    -0.400
    -0.000
    -0.000
    -9.000
    -6.000
     1.000
     1.000
     7.400
    10.300
    -2.900
    -5.000
    -7.000
     4.000
    -6.000
   -10.000
    -1.600
    -1.000
    -2.000
    10.300
    -5.000
    -6.000
    -5.000
    -4.000
    -3.000
    18.300
    -0.000
    -6.000
    -1.000
     1.000
     5.200
     1.000
    -2.000
    -4.000
    -2.000
    -1.000
    -2.000
     1.000
    -0.000
    -1.000
     4.000
    -8.000
    -7.000
    -3.000
    -0.900
    -8.000
     2.400
     3.000
    -1.500
    -4.000
     3.900
    -1.800
    -4.000
     4.600
    -0.000
     7.000
    -8.000
    -5.000
   -22.000
    21.200
    -1.000
    -2.000
    -3.000
     2.000
   -12.000
    -3.000
    -6.000
    -4.000
    -0.000
    -4.000
     5.500
    -2.300
    -6.000
    -6.000
    -2.000
    -5.000
     1.500
    -7.000
    -4.000
    -9.000
    -1.600
   -12.000
    11.200
    -4.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -1.900    11.682 Median =  -1.9 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -1.9  0.
 -1.9  11.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -26.000    12.318 Author: all ( 106 samples)
EOF
gmt end
