#!/bin/bash
gmt begin bandung1.79_dcal pdf,ps
proj=-JM16.0c+
reg=-R104.0/110.9/-9.9/-4.1
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration bandung1.79'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
   107.130    -7.309
   106.965    -7.878
>
   106.556    -7.005
   106.565    -6.825
>
   107.130    -7.309
   106.999    -7.942
>
   107.130    -7.309
   106.999    -7.942
>
   107.130    -7.309
   107.023    -7.879
>
   107.130    -7.309
   107.023    -7.879
>
   107.618    -6.827
   107.763    -7.220
>
   107.618    -6.827
   107.763    -7.220
>
   107.618    -6.827
   107.763    -7.220
>
   107.618    -6.827
   107.763    -7.220
>
   107.130    -7.309
   107.763    -7.220
>
   108.263    -6.734
   107.763    -7.220
>
   107.650    -7.463
   107.431    -7.877
>
   107.130    -7.309
   107.431    -7.877
>
   107.650    -7.463
   107.690    -7.288
>
   107.618    -6.827
   107.690    -7.288
>
   107.618    -6.827
   107.690    -7.288
>
   107.618    -6.827
   107.690    -7.288
>
   107.130    -7.309
   107.690    -7.288
>
   107.130    -7.309
   107.690    -7.288
>
   107.130    -7.309
   107.333    -6.782
>
   107.130    -7.309
   107.333    -6.782
>
   106.750    -6.554
   107.333    -6.782
>
   106.750    -6.554
   107.333    -6.782
>
   108.931    -7.333
   108.706    -7.291
>
   109.169    -7.681
   108.706    -7.291
>
   107.811    -6.732
   107.795    -6.665
>
   107.614    -6.667
   107.795    -6.665
>
   107.614    -6.667
   107.795    -6.665
>
   108.010    -6.741
   107.795    -6.665
>
   107.618    -6.827
   107.795    -6.665
>
   108.134    -6.762
   107.795    -6.665
>
   107.445    -6.742
   107.795    -6.665
>
   107.418    -6.531
   107.795    -6.665
>
   108.185    -6.493
   107.795    -6.665
>
   108.263    -6.734
   107.795    -6.665
>
   107.356    -6.931
   107.795    -6.665
>
   107.222    -6.844
   107.795    -6.665
>
   108.440    -6.796
   107.795    -6.665
>
   107.650    -7.463
   107.694    -7.255
>
   107.650    -7.463
   107.694    -7.255
>
   107.618    -6.827
   107.694    -7.255
>
   107.618    -6.827
   107.694    -7.255
>
   107.356    -6.931
   107.694    -7.255
>
   108.196    -7.317
   107.694    -7.255
>
   107.130    -7.309
   107.694    -7.255
>
   107.811    -6.732
   107.694    -7.255
>
   107.614    -6.667
   107.694    -7.255
>
   108.134    -6.762
   107.694    -7.255
>
   107.222    -6.844
   107.143    -6.814
>
   106.963    -6.887
   107.143    -6.814
>
   107.140    -7.017
   107.143    -6.814
>
   106.935    -6.698
   107.143    -6.814
>
   107.356    -6.931
   107.143    -6.814
>
   107.445    -6.742
   107.143    -6.814
>
   107.418    -6.531
   107.143    -6.814
>
   106.725    -6.975
   107.143    -6.814
>
   107.476    -7.087
   107.143    -6.814
>
   106.750    -6.554
   107.143    -6.814
>
   107.618    -6.827
   107.143    -6.814
>
   107.130    -7.309
   107.143    -6.814
>
   106.549    -6.969
   107.143    -6.814
>
   106.556    -7.005
   107.143    -6.814
>
   106.749    -6.265
   107.143    -6.814
>
   107.811    -6.732
   107.143    -6.814
>
   107.130    -7.309
   107.017    -7.924
>
   108.931    -7.333
   108.830    -7.155
>
   108.719    -6.913
   108.830    -7.155
>
   109.164    -7.197
   108.830    -7.155
>
   109.184    -7.007
   108.830    -7.155
>
   108.532    -7.363
   108.830    -7.155
>
   108.615    -6.803
   108.830    -7.155
>
   108.440    -6.796
   108.830    -7.155
>
   109.169    -7.681
   108.830    -7.155
>
   108.196    -7.317
   108.830    -7.155
>
   108.931    -7.333
   108.675    -7.222
>
   108.719    -6.913
   108.675    -7.222
>
   108.585    -6.873
   108.675    -7.222
>
   108.615    -6.803
   108.675    -7.222
>
   108.196    -7.317
   108.675    -7.222
>
   108.196    -7.317
   108.675    -7.222
>
   108.440    -6.796
   108.675    -7.222
>
   109.164    -7.197
   108.675    -7.222
>
   108.449    -7.784
   108.675    -7.222
>
   108.449    -7.784
   108.675    -7.222
>
   108.263    -6.734
   108.675    -7.222
>
   108.931    -7.333
   108.942    -7.184
>
   108.931    -7.333
   108.942    -7.184
>
   109.164    -7.197
   108.942    -7.184
>
   109.184    -7.007
   108.942    -7.184
>
   109.184    -7.007
   108.942    -7.184
>
   108.719    -6.913
   108.942    -7.184
>
   108.532    -7.363
   108.942    -7.184
>
   108.585    -6.873
   108.942    -7.184
>
   109.169    -7.681
   108.942    -7.184
>
   109.580    -7.168
   108.942    -7.184
>
   108.440    -6.796
   108.942    -7.184
>
   108.440    -6.796
   108.942    -7.184
>
   107.130    -7.309
   107.223    -7.182
>
   107.130    -7.309
   107.223    -7.182
>
   107.140    -7.017
   107.223    -7.182
>
   107.140    -7.017
   107.223    -7.182
>
   107.476    -7.087
   107.223    -7.182
>
   107.476    -7.087
   107.223    -7.182
>
   107.356    -6.931
   107.223    -7.182
>
   107.356    -6.931
   107.223    -7.182
>
   106.963    -6.887
   107.223    -7.182
>
   106.963    -6.887
   107.223    -7.182
>
   106.801    -7.057
   107.223    -7.182
>
   106.801    -7.057
   107.223    -7.182
>
   107.445    -6.742
   107.223    -7.182
>
   107.650    -7.463
   107.223    -7.182
>
   107.650    -7.463
   107.223    -7.182
>
   107.618    -6.827
   107.223    -7.182
>
   107.618    -6.827
   107.223    -7.182
>
   106.725    -6.975
   107.223    -7.182
>
   106.725    -6.975
   107.223    -7.182
>
   106.935    -6.698
   107.223    -7.182
>
   107.614    -6.667
   107.223    -7.182
>
   107.614    -6.667
   107.223    -7.182
>
   107.418    -6.531
   107.223    -7.182
>
   106.556    -7.005
   107.223    -7.182
>
   106.556    -7.005
   107.223    -7.182
>
   107.418    -6.531
   107.394    -6.547
>
   107.418    -6.531
   107.394    -6.547
>
   107.445    -6.742
   107.394    -6.547
>
   107.614    -6.667
   107.394    -6.547
>
   107.222    -6.844
   107.394    -6.547
>
   107.356    -6.931
   107.394    -6.547
>
   106.935    -6.698
   107.394    -6.547
>
   107.811    -6.732
   107.394    -6.547
>
   107.140    -7.017
   107.394    -6.547
>
   106.963    -6.887
   107.394    -6.547
>
   107.476    -7.087
   107.394    -6.547
>
   106.750    -6.554
   107.394    -6.547
>
   108.010    -6.741
   107.394    -6.547
>
   106.749    -6.265
   107.394    -6.547
>
   107.650    -7.463
   107.686    -7.237
>
   107.650    -7.463
   107.686    -7.237
>
   107.476    -7.087
   107.686    -7.237
>
   107.476    -7.087
   107.686    -7.237
>
   107.618    -6.827
   107.686    -7.237
>
   107.618    -6.827
   107.686    -7.237
>
   107.618    -6.827
   107.686    -7.237
>
   107.618    -6.827
   107.686    -7.237
>
   107.356    -6.931
   107.686    -7.237
>
   107.356    -6.931
   107.686    -7.237
>
   107.811    -6.732
   107.686    -7.237
>
   108.196    -7.317
   107.686    -7.237
>
   107.445    -6.742
   107.686    -7.237
>
   107.130    -7.309
   107.686    -7.237
>
   107.614    -6.667
   107.686    -7.237
>
   107.140    -7.017
   107.686    -7.237
>
   108.010    -6.741
   107.686    -7.237
>
   107.222    -6.844
   107.686    -7.237
>
   108.134    -6.762
   107.686    -7.237
>
   107.650    -7.463
   107.673    -7.301
>
   107.476    -7.087
   107.673    -7.301
>
   107.618    -6.827
   107.673    -7.301
>
   108.196    -7.317
   107.673    -7.301
>
   107.811    -6.732
   107.673    -7.301
>
   107.130    -7.309
   107.673    -7.301
>
   107.445    -6.742
   107.673    -7.301
>
   107.614    -6.667
   107.673    -7.301
>
   108.010    -6.741
   107.673    -7.301
>
   107.222    -6.844
   107.673    -7.301
>
   107.445    -6.742
   107.360    -6.742
>
   107.445    -6.742
   107.360    -6.742
>
   107.222    -6.844
   107.360    -6.742
>
   107.418    -6.531
   107.360    -6.742
>
   107.418    -6.531
   107.360    -6.742
>
   107.356    -6.931
   107.360    -6.742
>
   107.618    -6.827
   107.360    -6.742
>
   107.618    -6.827
   107.360    -6.742
>
   107.618    -6.827
   107.360    -6.742
>
   107.140    -7.017
   107.360    -6.742
>
   107.476    -7.087
   107.360    -6.742
>
   106.935    -6.698
   107.360    -6.742
>
   106.963    -6.887
   107.360    -6.742
>
   106.750    -6.554
   107.360    -6.742
>
   106.750    -6.554
   107.360    -6.742
>
   107.130    -7.309
   107.360    -6.742
>
   106.801    -7.057
   107.360    -6.742
>
   108.010    -6.741
   107.360    -6.742
>
   108.010    -6.741
   107.360    -6.742
>
   106.725    -6.975
   107.360    -6.742
>
   107.140    -7.017
   107.184    -6.979
>
   107.140    -7.017
   107.184    -6.979
>
   107.222    -6.844
   107.184    -6.979
>
   107.222    -6.844
   107.184    -6.979
>
   107.356    -6.931
   107.184    -6.979
>
   107.356    -6.931
   107.184    -6.979
>
   106.963    -6.887
   107.184    -6.979
>
   106.963    -6.887
   107.184    -6.979
>
   107.476    -7.087
   107.184    -6.979
>
   107.130    -7.309
   107.184    -6.979
>
   107.130    -7.309
   107.184    -6.979
>
   107.445    -6.742
   107.184    -6.979
>
   106.935    -6.698
   107.184    -6.979
>
   106.935    -6.698
   107.184    -6.979
>
   106.725    -6.975
   107.184    -6.979
>
   107.618    -6.827
   107.184    -6.979
>
   107.418    -6.531
   107.184    -6.979
>
   107.418    -6.531
   107.184    -6.979
>
   106.750    -6.554
   107.184    -6.979
>
   106.750    -6.554
   107.184    -6.979
>
   106.556    -7.005
   107.184    -6.979
>
   107.650    -7.463
   107.184    -6.979
>
   107.650    -7.463
   107.184    -6.979
>
   107.476    -7.087
   107.565    -7.293
>
   107.476    -7.087
   107.565    -7.293
>
   107.650    -7.463
   107.565    -7.293
>
   107.650    -7.463
   107.565    -7.293
>
   107.356    -6.931
   107.565    -7.293
>
   107.130    -7.309
   107.565    -7.293
>
   107.618    -6.827
   107.565    -7.293
>
   107.140    -7.017
   107.565    -7.293
>
   107.140    -7.017
   107.565    -7.293
>
   107.445    -6.742
   107.565    -7.293
>
   107.222    -6.844
   107.565    -7.293
>
   107.811    -6.732
   107.565    -7.293
>
   108.196    -7.317
   107.565    -7.293
>
   108.196    -7.317
   107.565    -7.293
>
   107.130    -7.309
   107.305    -7.483
>
   107.130    -7.309
   107.305    -7.483
>
   107.650    -7.463
   107.305    -7.483
>
   107.650    -7.463
   107.305    -7.483
>
   107.476    -7.087
   107.305    -7.483
>
   107.476    -7.087
   107.305    -7.483
>
   107.140    -7.017
   107.305    -7.483
>
   107.140    -7.017
   107.305    -7.483
>
   107.356    -6.931
   107.305    -7.483
>
   107.356    -6.931
   107.305    -7.483
>
   107.222    -6.844
   107.305    -7.483
>
   107.222    -6.844
   107.305    -7.483
>
   106.801    -7.057
   107.305    -7.483
>
   106.801    -7.057
   107.305    -7.483
>
   106.963    -6.887
   107.305    -7.483
>
   106.963    -6.887
   107.305    -7.483
>
   107.130    -7.309
   107.324    -7.479
>
   107.650    -7.463
   107.324    -7.479
>
   107.650    -7.463
   107.324    -7.479
>
   107.476    -7.087
   107.324    -7.479
>
   107.140    -7.017
   107.324    -7.479
>
   107.140    -7.017
   107.324    -7.479
>
   107.356    -6.931
   107.324    -7.479
>
   107.356    -6.931
   107.324    -7.479
>
   107.222    -6.844
   107.324    -7.479
>
   106.801    -7.057
   107.324    -7.479
>
   106.801    -7.057
   107.324    -7.479
>
   106.963    -6.887
   107.324    -7.479
>
   106.963    -6.887
   107.324    -7.479
>
   107.476    -7.087
   107.441    -7.191
>
   107.476    -7.087
   107.441    -7.191
>
   107.356    -6.931
   107.441    -7.191
>
   107.356    -6.931
   107.441    -7.191
>
   107.140    -7.017
   107.441    -7.191
>
   107.130    -7.309
   107.441    -7.191
>
   107.130    -7.309
   107.441    -7.191
>
   107.222    -6.844
   107.441    -7.191
>
   107.222    -6.844
   107.441    -7.191
>
   107.650    -7.463
   107.441    -7.191
>
   106.963    -6.887
   107.441    -7.191
>
   107.614    -6.667
   107.441    -7.191
>
   107.811    -6.732
   107.441    -7.191
>
   107.418    -6.531
   107.441    -7.191
>
   107.418    -6.531
   107.441    -7.191
>
   107.650    -7.463
   107.713    -7.264
>
   107.650    -7.463
   107.713    -7.264
>
   107.476    -7.087
   107.713    -7.264
>
   107.476    -7.087
   107.713    -7.264
>
   107.618    -6.827
   107.713    -7.264
>
   107.618    -6.827
   107.713    -7.264
>
   107.356    -6.931
   107.713    -7.264
>
   107.356    -6.931
   107.713    -7.264
>
   108.196    -7.317
   107.713    -7.264
>
   108.196    -7.317
   107.713    -7.264
>
   107.811    -6.732
   107.713    -7.264
>
   107.811    -6.732
   107.713    -7.264
>
   107.445    -6.742
   107.713    -7.264
>
   107.445    -6.742
   107.713    -7.264
>
   107.614    -6.667
   107.713    -7.264
>
   108.010    -6.741
   107.713    -7.264
>
   108.010    -6.741
   107.713    -7.264
>
   107.140    -7.017
   107.713    -7.264
>
   107.222    -6.844
   107.713    -7.264
>
   108.363    -7.328
   107.713    -7.264
>
   108.363    -7.328
   107.713    -7.264
>
   107.650    -7.463
   107.725    -7.290
>
   107.650    -7.463
   107.725    -7.290
>
   107.650    -7.463
   107.725    -7.290
>
   107.476    -7.087
   107.725    -7.290
>
   107.618    -6.827
   107.725    -7.290
>
   107.618    -6.827
   107.725    -7.290
>
   108.196    -7.317
   107.725    -7.290
>
   108.196    -7.317
   107.725    -7.290
>
   107.356    -6.931
   107.725    -7.290
>
   107.811    -6.732
   107.725    -7.290
>
   107.811    -6.732
   107.725    -7.290
>
   107.445    -6.742
   107.725    -7.290
>
   107.445    -6.742
   107.725    -7.290
>
   108.363    -7.328
   107.725    -7.290
>
   108.363    -7.328
   107.725    -7.290
>
   107.222    -6.844
   107.725    -7.290
>
   107.222    -6.844
   107.725    -7.290
>
   107.130    -7.309
   106.993    -7.916
>
   107.130    -7.309
   106.993    -7.916
>
   107.130    -7.309
   106.994    -7.982
>
   108.449    -7.784
   108.081    -7.860
>
   108.196    -7.317
   108.081    -7.860
>
   108.196    -7.317
   108.081    -7.860
>
   108.363    -7.328
   108.081    -7.860
>
   108.363    -7.328
   108.081    -7.860
>
   107.650    -7.463
   108.081    -7.860
>
   107.650    -7.463
   108.081    -7.860
>
   108.532    -7.364
   108.081    -7.860
>
   108.532    -7.364
   108.081    -7.860
>
   108.532    -7.363
   108.081    -7.860
>
   108.532    -7.363
   108.081    -7.860
>
   107.650    -7.463
   107.796    -7.641
>
   107.650    -7.463
   107.796    -7.641
>
   108.196    -7.317
   107.796    -7.641
>
   108.196    -7.317
   107.796    -7.641
>
   107.476    -7.087
   107.796    -7.641
>
   107.476    -7.087
   107.796    -7.641
>
   108.363    -7.328
   107.796    -7.641
>
   108.449    -7.784
   107.796    -7.641
>
   108.449    -7.784
   107.796    -7.641
>
   107.683    -7.030
   107.724    -7.262
>
   107.650    -7.463
   107.724    -7.262
>
   107.650    -7.463
   107.724    -7.262
>
   107.476    -7.087
   107.724    -7.262
>
   107.630    -6.830
   107.724    -7.262
>
   107.618    -6.827
   107.724    -7.262
>
   107.618    -6.827
   107.724    -7.262
>
   108.196    -7.317
   107.724    -7.262
>
   108.196    -7.317
   107.724    -7.262
>
   107.356    -6.931
   107.724    -7.262
>
   107.356    -6.931
   107.724    -7.262
>
   108.010    -6.741
   107.724    -7.262
>
   107.222    -6.844
   107.724    -7.262
>
   107.650    -7.463
   107.719    -7.276
>
   107.650    -7.463
   107.719    -7.276
>
   107.683    -7.030
   107.719    -7.276
>
   107.476    -7.087
   107.719    -7.276
>
   107.476    -7.087
   107.719    -7.276
>
   107.356    -6.931
   107.719    -7.276
>
   107.356    -6.931
   107.719    -7.276
>
   108.196    -7.317
   107.719    -7.276
>
   108.196    -7.317
   107.719    -7.276
>
   107.811    -6.732
   107.719    -7.276
>
   107.130    -7.309
   107.719    -7.276
>
   107.130    -7.309
   107.719    -7.276
>
   107.445    -6.742
   107.719    -7.276
>
   108.010    -6.741
   107.719    -7.276
>
   108.010    -6.741
   107.719    -7.276
>
   107.614    -6.667
   107.719    -7.276
>
   107.614    -6.667
   107.719    -7.276
>
   107.140    -7.017
   107.719    -7.276
>
   107.222    -6.844
   107.719    -7.276
>
   107.418    -6.531
   107.357    -6.787
>
   107.445    -6.742
   107.357    -6.787
>
   107.445    -6.742
   107.357    -6.787
>
   107.614    -6.667
   107.357    -6.787
>
   107.222    -6.844
   107.357    -6.787
>
   107.356    -6.931
   107.357    -6.787
>
   107.618    -6.827
   107.357    -6.787
>
   107.618    -6.827
   107.357    -6.787
>
   107.618    -6.827
   107.357    -6.787
>
   106.935    -6.698
   107.357    -6.787
>
   107.140    -7.017
   107.357    -6.787
>
   107.683    -7.030
   107.357    -6.787
>
   106.750    -6.554
   107.357    -6.787
>
   106.750    -6.554
   107.357    -6.787
>
   108.010    -6.741
   107.357    -6.787
>
   108.010    -6.741
   107.357    -6.787
>
   106.801    -7.057
   107.357    -6.787
>
   106.801    -7.057
   107.357    -6.787
>
   106.725    -6.975
   107.357    -6.787
>
   107.130    -7.309
   107.357    -6.787
>
   107.130    -7.309
   107.357    -6.787
>
   107.445    -6.742
   107.356    -6.773
>
   107.445    -6.742
   107.356    -6.773
>
   107.222    -6.844
   107.356    -6.773
>
   107.356    -6.931
   107.356    -6.773
>
   107.418    -6.531
   107.356    -6.773
>
   107.418    -6.531
   107.356    -6.773
>
   107.618    -6.827
   107.356    -6.773
>
   107.614    -6.667
   107.356    -6.773
>
   107.140    -7.017
   107.356    -6.773
>
   107.140    -7.017
   107.356    -6.773
>
   106.935    -6.698
   107.356    -6.773
>
   107.683    -7.030
   107.356    -6.773
>
   107.130    -7.309
   107.356    -6.773
>
   107.130    -7.309
   107.356    -6.773
>
   106.801    -7.057
   107.356    -6.773
>
   106.750    -6.554
   107.356    -6.773
>
   106.750    -6.554
   107.356    -6.773
>
   106.725    -6.975
   107.356    -6.773
>
   106.725    -6.975
   107.356    -6.773
>
   108.010    -6.741
   107.356    -6.773
>
   108.010    -6.741
   107.356    -6.773
>
   107.445    -6.742
   107.353    -6.761
>
   107.445    -6.742
   107.353    -6.761
>
   107.222    -6.844
   107.353    -6.761
>
   107.356    -6.931
   107.353    -6.761
>
   107.418    -6.531
   107.353    -6.761
>
   107.418    -6.531
   107.353    -6.761
>
   107.614    -6.667
   107.353    -6.761
>
   107.618    -6.827
   107.353    -6.761
>
   107.140    -7.017
   107.353    -6.761
>
   106.935    -6.698
   107.353    -6.761
>
   107.683    -7.030
   107.353    -6.761
>
   107.130    -7.309
   107.353    -6.761
>
   106.750    -6.554
   107.353    -6.761
>
   106.801    -7.057
   107.353    -6.761
>
   108.010    -6.741
   107.353    -6.761
>
   106.725    -6.975
   107.353    -6.761
>
   106.935    -6.698
   107.019    -6.970
>
   107.356    -6.931
   107.019    -6.970
>
   107.445    -6.742
   107.019    -6.970
>
   107.445    -6.742
   107.019    -6.970
>
   106.750    -6.554
   107.019    -6.970
>
   106.750    -6.554
   107.019    -6.970
>
   107.476    -7.087
   107.019    -6.970
>
   107.618    -6.827
   107.019    -6.970
>
   107.618    -6.827
   107.019    -6.970
>
   107.614    -6.667
   107.019    -6.970
>
   107.683    -7.030
   107.019    -6.970
>
   107.683    -7.030
   107.019    -6.970
>
   107.222    -6.844
   107.103    -6.852
>
   107.140    -7.017
   107.103    -6.852
>
   107.140    -7.017
   107.103    -6.852
>
   106.935    -6.698
   107.103    -6.852
>
   107.356    -6.931
   107.103    -6.852
>
   107.356    -6.931
   107.103    -6.852
>
   106.801    -7.057
   107.103    -6.852
>
   107.445    -6.742
   107.103    -6.852
>
   106.725    -6.975
   107.103    -6.852
>
   106.725    -6.975
   107.103    -6.852
>
   107.476    -7.087
   107.103    -6.852
>
   107.130    -7.309
   107.103    -6.852
>
   107.130    -7.309
   107.103    -6.852
>
   107.418    -6.531
   107.103    -6.852
>
   107.418    -6.531
   107.103    -6.852
>
   106.750    -6.554
   107.103    -6.852
>
   106.750    -6.554
   107.103    -6.852
>
   106.549    -6.969
   107.103    -6.852
>
   106.556    -7.005
   107.103    -6.852
>
   107.683    -7.030
   107.103    -6.852
>
   107.683    -7.030
   107.103    -6.852
>
   107.222    -6.844
   107.070    -6.837
>
   106.935    -6.698
   107.070    -6.837
>
   106.935    -6.698
   107.070    -6.837
>
   107.140    -7.017
   107.070    -6.837
>
   107.356    -6.931
   107.070    -6.837
>
   106.801    -7.057
   107.070    -6.837
>
   106.801    -7.057
   107.070    -6.837
>
   106.725    -6.975
   107.070    -6.837
>
   106.725    -6.975
   107.070    -6.837
>
   107.445    -6.742
   107.070    -6.837
>
   106.750    -6.554
   107.070    -6.837
>
   106.750    -6.554
   107.070    -6.837
>
   107.418    -6.531
   107.070    -6.837
>
   107.418    -6.531
   107.070    -6.837
>
   107.130    -7.309
   107.070    -6.837
>
   107.130    -7.309
   107.070    -6.837
>
   107.476    -7.087
   107.070    -6.837
>
   106.549    -6.969
   107.070    -6.837
>
   106.556    -7.005
   107.070    -6.837
>
   107.614    -6.667
   107.070    -6.837
>
   107.683    -7.030
   107.070    -6.837
>
   106.470    -6.484
   107.070    -6.837
>
   106.935    -6.698
   107.082    -6.827
>
   107.140    -7.017
   107.082    -6.827
>
   107.140    -7.017
   107.082    -6.827
>
   107.356    -6.931
   107.082    -6.827
>
   106.801    -7.057
   107.082    -6.827
>
   106.801    -7.057
   107.082    -6.827
>
   106.725    -6.975
   107.082    -6.827
>
   106.725    -6.975
   107.082    -6.827
>
   107.445    -6.742
   107.082    -6.827
>
   106.750    -6.554
   107.082    -6.827
>
   107.418    -6.531
   107.082    -6.827
>
   107.418    -6.531
   107.082    -6.827
>
   107.130    -7.309
   107.082    -6.827
>
   107.130    -7.309
   107.082    -6.827
>
   107.476    -7.087
   107.082    -6.827
>
   106.549    -6.969
   107.082    -6.827
>
   106.556    -7.005
   107.082    -6.827
>
   107.618    -6.827
   107.082    -6.827
>
   107.614    -6.667
   107.082    -6.827
>
   106.749    -6.265
   107.082    -6.827
>
   106.749    -6.265
   107.082    -6.827
>
   107.683    -7.030
   107.082    -6.827
>
   107.683    -7.030
   107.082    -6.827
>
   106.470    -6.484
   107.082    -6.827
>
   107.140    -7.017
   107.082    -6.856
>
   107.140    -7.017
   107.082    -6.856
>
   106.935    -6.698
   107.082    -6.856
>
   106.935    -6.698
   107.082    -6.856
>
   107.356    -6.931
   107.082    -6.856
>
   107.356    -6.931
   107.082    -6.856
>
   106.801    -7.057
   107.082    -6.856
>
   106.725    -6.975
   107.082    -6.856
>
   106.725    -6.975
   107.082    -6.856
>
   107.445    -6.742
   107.082    -6.856
>
   107.445    -6.742
   107.082    -6.856
>
   106.750    -6.554
   107.082    -6.856
>
   106.750    -6.554
   107.082    -6.856
>
   107.130    -7.309
   107.082    -6.856
>
   107.130    -7.309
   107.082    -6.856
>
   107.476    -7.087
   107.082    -6.856
>
   107.418    -6.531
   107.082    -6.856
>
   106.549    -6.969
   107.082    -6.856
>
   106.556    -7.005
   107.082    -6.856
>
   107.618    -6.827
   107.082    -6.856
>
   107.618    -6.827
   107.082    -6.856
>
   107.614    -6.667
   107.082    -6.856
>
   107.683    -7.030
   107.082    -6.856
>
   107.683    -7.030
   107.082    -6.856
>
   106.963    -6.887
   107.080    -6.852
>
   106.963    -6.887
   107.080    -6.852
>
   107.222    -6.844
   107.080    -6.852
>
   107.222    -6.844
   107.080    -6.852
>
   107.140    -7.017
   107.080    -6.852
>
   106.935    -6.698
   107.080    -6.852
>
   106.935    -6.698
   107.080    -6.852
>
   107.356    -6.931
   107.080    -6.852
>
   107.356    -6.931
   107.080    -6.852
>
   106.801    -7.057
   107.080    -6.852
>
   106.725    -6.975
   107.080    -6.852
>
   106.725    -6.975
   107.080    -6.852
>
   107.445    -6.742
   107.080    -6.852
>
   106.750    -6.554
   107.080    -6.852
>
   106.750    -6.554
   107.080    -6.852
>
   107.130    -7.309
   107.080    -6.852
>
   107.130    -7.309
   107.080    -6.852
>
   107.476    -7.087
   107.080    -6.852
>
   107.418    -6.531
   107.080    -6.852
>
   107.418    -6.531
   107.080    -6.852
>
   106.549    -6.969
   107.080    -6.852
>
   106.549    -6.969
   107.080    -6.852
>
   106.556    -7.005
   107.080    -6.852
>
   107.618    -6.827
   107.080    -6.852
>
   107.614    -6.667
   107.080    -6.852
>
   107.683    -7.030
   107.080    -6.852
>
   107.130    -7.309
   107.002    -7.900
>
   107.130    -7.309
   107.002    -7.900
>
   106.963    -6.887
   107.076    -6.848
>
   106.963    -6.887
   107.076    -6.848
>
   107.140    -7.017
   107.076    -6.848
>
   107.140    -7.017
   107.076    -6.848
>
   106.935    -6.698
   107.076    -6.848
>
   106.935    -6.698
   107.076    -6.848
>
   107.356    -6.931
   107.076    -6.848
>
   107.356    -6.931
   107.076    -6.848
>
   106.801    -7.057
   107.076    -6.848
>
   107.445    -6.742
   107.076    -6.848
>
   106.750    -6.554
   107.076    -6.848
>
   106.750    -6.554
   107.076    -6.848
>
   107.130    -7.309
   107.076    -6.848
>
   107.130    -7.309
   107.076    -6.848
>
   107.476    -7.087
   107.076    -6.848
>
   107.476    -7.087
   107.076    -6.848
>
   107.418    -6.531
   107.076    -6.848
>
   107.418    -6.531
   107.076    -6.848
>
   106.549    -6.969
   107.076    -6.848
>
   107.618    -6.827
   107.076    -6.848
>
   107.614    -6.667
   107.076    -6.848
>
   107.683    -7.030
   107.076    -6.848
>
   107.222    -6.844
   107.078    -6.813
>
   107.222    -6.844
   107.078    -6.813
>
   106.935    -6.698
   107.078    -6.813
>
   106.935    -6.698
   107.078    -6.813
>
   107.140    -7.017
   107.078    -6.813
>
   107.140    -7.017
   107.078    -6.813
>
   107.356    -6.931
   107.078    -6.813
>
   107.356    -6.931
   107.078    -6.813
>
   106.801    -7.057
   107.078    -6.813
>
   106.801    -7.057
   107.078    -6.813
>
   106.725    -6.975
   107.078    -6.813
>
   106.725    -6.975
   107.078    -6.813
>
   107.445    -6.742
   107.078    -6.813
>
   106.750    -6.554
   107.078    -6.813
>
   106.750    -6.554
   107.078    -6.813
>
   107.418    -6.531
   107.078    -6.813
>
   107.476    -7.087
   107.078    -6.813
>
   107.476    -7.087
   107.078    -6.813
>
   107.130    -7.309
   107.078    -6.813
>
   106.549    -6.969
   107.078    -6.813
>
   106.556    -7.005
   107.078    -6.813
>
   107.618    -6.827
   107.078    -6.813
>
   107.614    -6.667
   107.078    -6.813
>
   107.683    -7.030
   107.078    -6.813
>
   106.963    -6.887
   107.057    -6.835
>
   107.222    -6.844
   107.057    -6.835
>
   107.222    -6.844
   107.057    -6.835
>
   106.935    -6.698
   107.057    -6.835
>
   107.140    -7.017
   107.057    -6.835
>
   107.356    -6.931
   107.057    -6.835
>
   106.801    -7.057
   107.057    -6.835
>
   106.725    -6.975
   107.057    -6.835
>
   107.445    -6.742
   107.057    -6.835
>
   106.750    -6.554
   107.057    -6.835
>
   107.418    -6.531
   107.057    -6.835
>
   107.418    -6.531
   107.057    -6.835
>
   107.130    -7.309
   107.057    -6.835
>
   107.130    -7.309
   107.057    -6.835
>
   107.476    -7.087
   107.057    -6.835
>
   106.549    -6.969
   107.057    -6.835
>
   106.556    -7.005
   107.057    -6.835
>
   107.618    -6.827
   107.057    -6.835
>
   107.614    -6.667
   107.057    -6.835
>
   106.749    -6.265
   107.057    -6.835
>
   107.683    -7.030
   107.057    -6.835
>
   106.470    -6.484
   107.057    -6.835
>
   106.963    -6.887
   107.071    -6.856
>
   106.963    -6.887
   107.071    -6.856
>
   107.140    -7.017
   107.071    -6.856
>
   107.140    -7.017
   107.071    -6.856
>
   107.222    -6.844
   107.071    -6.856
>
   106.935    -6.698
   107.071    -6.856
>
   106.801    -7.057
   107.071    -6.856
>
   107.356    -6.931
   107.071    -6.856
>
   107.356    -6.931
   107.071    -6.856
>
   106.725    -6.975
   107.071    -6.856
>
   107.445    -6.742
   107.071    -6.856
>
   106.750    -6.554
   107.071    -6.856
>
   106.750    -6.554
   107.071    -6.856
>
   107.130    -7.309
   107.071    -6.856
>
   107.130    -7.309
   107.071    -6.856
>
   107.476    -7.087
   107.071    -6.856
>
   106.549    -6.969
   107.071    -6.856
>
   106.556    -7.005
   107.071    -6.856
>
   107.618    -6.827
   107.071    -6.856
>
   107.614    -6.667
   107.071    -6.856
>
   107.683    -7.030
   107.071    -6.856
>
   106.963    -6.887
   107.068    -6.850
>
   106.963    -6.887
   107.068    -6.850
>
   106.935    -6.698
   107.068    -6.850
>
   107.222    -6.844
   107.068    -6.850
>
   107.140    -7.017
   107.068    -6.850
>
   106.801    -7.057
   107.068    -6.850
>
   106.801    -7.057
   107.068    -6.850
>
   106.725    -6.975
   107.068    -6.850
>
   106.725    -6.975
   107.068    -6.850
>
   107.356    -6.931
   107.068    -6.850
>
   107.356    -6.931
   107.068    -6.850
>
   106.750    -6.554
   107.068    -6.850
>
   106.750    -6.554
   107.068    -6.850
>
   107.445    -6.742
   107.068    -6.850
>
   107.130    -7.309
   107.068    -6.850
>
   107.130    -7.309
   107.068    -6.850
>
   106.549    -6.969
   107.068    -6.850
>
   106.556    -7.005
   107.068    -6.850
>
   107.476    -7.087
   107.068    -6.850
>
   107.418    -6.531
   107.068    -6.850
>
   107.418    -6.531
   107.068    -6.850
>
   107.618    -6.827
   107.068    -6.850
>
   107.614    -6.667
   107.068    -6.850
>
   106.749    -6.265
   107.068    -6.850
>
   106.749    -6.265
   107.068    -6.850
>
   107.683    -7.030
   107.068    -6.850
>
   106.470    -6.484
   107.068    -6.850
>
   106.470    -6.484
   107.068    -6.850
>
   107.140    -7.017
   107.077    -6.985
>
   107.140    -7.017
   107.077    -6.985
>
   106.963    -6.887
   107.077    -6.985
>
   106.963    -6.887
   107.077    -6.985
>
   107.222    -6.844
   107.077    -6.985
>
   106.801    -7.057
   107.077    -6.985
>
   106.801    -7.057
   107.077    -6.985
>
   107.356    -6.931
   107.077    -6.985
>
   107.356    -6.931
   107.077    -6.985
>
   106.935    -6.698
   107.077    -6.985
>
   106.725    -6.975
   107.077    -6.985
>
   107.130    -7.309
   107.077    -6.985
>
   107.476    -7.087
   107.077    -6.985
>
   107.445    -6.742
   107.077    -6.985
>
   106.556    -7.005
   107.077    -6.985
>
   106.549    -6.969
   107.077    -6.985
>
   106.750    -6.554
   107.077    -6.985
>
   107.418    -6.531
   107.077    -6.985
>
   107.618    -6.827
   107.077    -6.985
>
   107.683    -7.030
   107.077    -6.985
>
   107.614    -6.667
   107.077    -6.985
>
   106.521    -7.330
   107.077    -6.985
>
   106.521    -7.330
   107.077    -6.985
>
   106.963    -6.887
   107.072    -6.838
>
   106.963    -6.887
   107.072    -6.838
>
   107.222    -6.844
   107.072    -6.838
>
   107.222    -6.844
   107.072    -6.838
>
   107.140    -7.017
   107.072    -6.838
>
   107.140    -7.017
   107.072    -6.838
>
   106.935    -6.698
   107.072    -6.838
>
   106.935    -6.698
   107.072    -6.838
>
   106.801    -7.057
   107.072    -6.838
>
   106.725    -6.975
   107.072    -6.838
>
   106.725    -6.975
   107.072    -6.838
>
   107.445    -6.742
   107.072    -6.838
>
   106.750    -6.554
   107.072    -6.838
>
   106.750    -6.554
   107.072    -6.838
>
   107.418    -6.531
   107.072    -6.838
>
   107.418    -6.531
   107.072    -6.838
>
   107.130    -7.309
   107.072    -6.838
>
   106.549    -6.969
   107.072    -6.838
>
   106.556    -7.005
   107.072    -6.838
>
   107.618    -6.827
   107.072    -6.838
>
   107.614    -6.667
   107.072    -6.838
>
   107.683    -7.030
   107.072    -6.838
>
   106.470    -6.484
   107.072    -6.838
>
   106.470    -6.484
   107.072    -6.838
>
   106.963    -6.887
   107.081    -6.856
>
   107.222    -6.844
   107.081    -6.856
>
   107.222    -6.844
   107.081    -6.856
>
   107.140    -7.017
   107.081    -6.856
>
   107.140    -7.017
   107.081    -6.856
>
   106.935    -6.698
   107.081    -6.856
>
   107.356    -6.931
   107.081    -6.856
>
   107.356    -6.931
   107.081    -6.856
>
   106.801    -7.057
   107.081    -6.856
>
   106.725    -6.975
   107.081    -6.856
>
   107.445    -6.742
   107.081    -6.856
>
   106.750    -6.554
   107.081    -6.856
>
   106.750    -6.554
   107.081    -6.856
>
   107.130    -7.309
   107.081    -6.856
>
   107.476    -7.087
   107.081    -6.856
>
   107.418    -6.531
   107.081    -6.856
>
   107.418    -6.531
   107.081    -6.856
>
   106.549    -6.969
   107.081    -6.856
>
   106.556    -7.005
   107.081    -6.856
>
   107.618    -6.827
   107.081    -6.856
>
   107.614    -6.667
   107.081    -6.856
>
   107.683    -7.030
   107.081    -6.856
>
   107.683    -7.030
   107.081    -6.856
>
   106.749    -6.265
   107.081    -6.856
>
   106.963    -6.887
   107.079    -6.852
>
   107.222    -6.844
   107.079    -6.852
>
   107.222    -6.844
   107.079    -6.852
>
   107.140    -7.017
   107.079    -6.852
>
   107.140    -7.017
   107.079    -6.852
>
   106.935    -6.698
   107.079    -6.852
>
   107.356    -6.931
   107.079    -6.852
>
   107.356    -6.931
   107.079    -6.852
>
   106.801    -7.057
   107.079    -6.852
>
   106.725    -6.975
   107.079    -6.852
>
   107.445    -6.742
   107.079    -6.852
>
   106.750    -6.554
   107.079    -6.852
>
   106.750    -6.554
   107.079    -6.852
>
   107.130    -7.309
   107.079    -6.852
>
   107.476    -7.087
   107.079    -6.852
>
   107.418    -6.531
   107.079    -6.852
>
   107.418    -6.531
   107.079    -6.852
>
   106.549    -6.969
   107.079    -6.852
>
   106.556    -7.005
   107.079    -6.852
>
   107.618    -6.827
   107.079    -6.852
>
   107.614    -6.667
   107.079    -6.852
>
   107.683    -7.030
   107.079    -6.852
>
   106.963    -6.887
   107.067    -6.848
>
   106.963    -6.887
   107.067    -6.848
>
   107.222    -6.844
   107.067    -6.848
>
   107.222    -6.844
   107.067    -6.848
>
   106.935    -6.698
   107.067    -6.848
>
   107.140    -7.017
   107.067    -6.848
>
   107.356    -6.931
   107.067    -6.848
>
   106.801    -7.057
   107.067    -6.848
>
   106.725    -6.975
   107.067    -6.848
>
   107.445    -6.742
   107.067    -6.848
>
   106.750    -6.554
   107.067    -6.848
>
   106.750    -6.554
   107.067    -6.848
>
   107.130    -7.309
   107.067    -6.848
>
   107.130    -7.309
   107.067    -6.848
>
   107.418    -6.531
   107.067    -6.848
>
   107.418    -6.531
   107.067    -6.848
>
   107.476    -7.087
   107.067    -6.848
>
   106.549    -6.969
   107.067    -6.848
>
   106.556    -7.005
   107.067    -6.848
>
   107.618    -6.827
   107.067    -6.848
>
   107.614    -6.667
   107.067    -6.848
>
   107.683    -7.030
   107.067    -6.848
>
   106.470    -6.484
   107.067    -6.848
>
   106.963    -6.887
   107.083    -6.792
>
   106.935    -6.698
   107.083    -6.792
>
   106.935    -6.698
   107.083    -6.792
>
   107.222    -6.844
   107.083    -6.792
>
   107.222    -6.844
   107.083    -6.792
>
   107.140    -7.017
   107.083    -6.792
>
   107.140    -7.017
   107.083    -6.792
>
   107.356    -6.931
   107.083    -6.792
>
   106.801    -7.057
   107.083    -6.792
>
   106.725    -6.975
   107.083    -6.792
>
   107.445    -6.742
   107.083    -6.792
>
   106.750    -6.554
   107.083    -6.792
>
   107.418    -6.531
   107.083    -6.792
>
   107.476    -7.087
   107.083    -6.792
>
   107.130    -7.309
   107.083    -6.792
>
   106.549    -6.969
   107.083    -6.792
>
   106.556    -7.005
   107.083    -6.792
>
   107.618    -6.827
   107.083    -6.792
>
   106.749    -6.265
   107.083    -6.792
>
   107.683    -7.030
   107.083    -6.792
>
   106.470    -6.484
   107.083    -6.792
>
   106.963    -6.887
   107.095    -6.798
>
   106.963    -6.887
   107.095    -6.798
>
   107.222    -6.844
   107.095    -6.798
>
   107.222    -6.844
   107.095    -6.798
>
   106.935    -6.698
   107.095    -6.798
>
   106.935    -6.698
   107.095    -6.798
>
   107.140    -7.017
   107.095    -6.798
>
   107.140    -7.017
   107.095    -6.798
>
   107.356    -6.931
   107.095    -6.798
>
   107.356    -6.931
   107.095    -6.798
>
   107.445    -6.742
   107.095    -6.798
>
   107.445    -6.742
   107.095    -6.798
>
   106.801    -7.057
   107.095    -6.798
>
   106.801    -7.057
   107.095    -6.798
>
   106.725    -6.975
   107.095    -6.798
>
   106.725    -6.975
   107.095    -6.798
>
   106.750    -6.554
   107.095    -6.798
>
   106.750    -6.554
   107.095    -6.798
>
   107.418    -6.531
   107.095    -6.798
>
   107.418    -6.531
   107.095    -6.798
>
   107.476    -7.087
   107.095    -6.798
>
   107.476    -7.087
   107.095    -6.798
>
   107.130    -7.309
   107.095    -6.798
>
   107.130    -7.309
   107.095    -6.798
>
   107.618    -6.827
   107.095    -6.798
>
   106.549    -6.969
   107.095    -6.798
>
   106.556    -7.005
   107.095    -6.798
>
   107.683    -7.030
   107.095    -6.798
>
   106.470    -6.484
   107.095    -6.798
>
   106.963    -6.887
   107.107    -6.853
>
   107.222    -6.844
   107.107    -6.853
>
   107.140    -7.017
   107.107    -6.853
>
   106.935    -6.698
   107.107    -6.853
>
   107.356    -6.931
   107.107    -6.853
>
   106.801    -7.057
   107.107    -6.853
>
   107.445    -6.742
   107.107    -6.853
>
   106.725    -6.975
   107.107    -6.853
>
   106.750    -6.554
   107.107    -6.853
>
   107.418    -6.531
   107.107    -6.853
>
   107.476    -7.087
   107.107    -6.853
>
   107.130    -7.309
   107.107    -6.853
>
   107.618    -6.827
   107.107    -6.853
>
   106.549    -6.969
   107.107    -6.853
>
   106.556    -7.005
   107.107    -6.853
>
   107.683    -7.030
   107.107    -6.853
>
   106.963    -6.887
   107.087    -6.816
>
   107.222    -6.844
   107.087    -6.816
>
   106.935    -6.698
   107.087    -6.816
>
   107.140    -7.017
   107.087    -6.816
>
   107.140    -7.017
   107.087    -6.816
>
   107.356    -6.931
   107.087    -6.816
>
   107.356    -6.931
   107.087    -6.816
>
   106.801    -7.057
   107.087    -6.816
>
   107.445    -6.742
   107.087    -6.816
>
   106.725    -6.975
   107.087    -6.816
>
   106.750    -6.554
   107.087    -6.816
>
   106.750    -6.554
   107.087    -6.816
>
   107.418    -6.531
   107.087    -6.816
>
   107.418    -6.531
   107.087    -6.816
>
   107.476    -7.087
   107.087    -6.816
>
   107.476    -7.087
   107.087    -6.816
>
   107.130    -7.309
   107.087    -6.816
>
   107.618    -6.827
   107.087    -6.816
>
   106.549    -6.969
   107.087    -6.816
>
   106.556    -7.005
   107.087    -6.816
>
   107.683    -7.030
   107.087    -6.816
>
   106.749    -6.265
   107.087    -6.816
>
   106.470    -6.484
   107.087    -6.816
>
   106.963    -6.887
   107.087    -6.828
>
   106.963    -6.887
   107.087    -6.828
>
   107.140    -7.017
   107.087    -6.828
>
   107.140    -7.017
   107.087    -6.828
>
   107.222    -6.844
   107.087    -6.828
>
   107.222    -6.844
   107.087    -6.828
>
   106.935    -6.698
   107.087    -6.828
>
   106.935    -6.698
   107.087    -6.828
>
   107.356    -6.931
   107.087    -6.828
>
   106.801    -7.057
   107.087    -6.828
>
   106.725    -6.975
   107.087    -6.828
>
   107.445    -6.742
   107.087    -6.828
>
   106.750    -6.554
   107.087    -6.828
>
   107.476    -7.087
   107.087    -6.828
>
   107.418    -6.531
   107.087    -6.828
>
   106.549    -6.969
   107.087    -6.828
>
   106.556    -7.005
   107.087    -6.828
>
   107.618    -6.827
   107.087    -6.828
>
   107.618    -6.827
   107.087    -6.828
>
   107.618    -6.827
   107.087    -6.828
>
   107.614    -6.667
   107.087    -6.828
>
   107.683    -7.030
   107.087    -6.828
>
   106.749    -6.265
   107.087    -6.828
>
   108.196    -7.317
   108.244    -7.359
>
   108.532    -7.364
   108.244    -7.359
>
   108.532    -7.364
   108.244    -7.359
>
   108.532    -7.363
   108.244    -7.359
>
   108.532    -7.363
   108.244    -7.359
>
   108.449    -7.784
   108.244    -7.359
>
   108.449    -7.784
   108.244    -7.359
>
   107.650    -7.463
   108.244    -7.359
>
   107.650    -7.463
   108.244    -7.359
>
   108.440    -6.796
   108.244    -7.359
>
   108.440    -6.796
   108.244    -7.359
>
   107.683    -7.030
   108.244    -7.359
>
   107.683    -7.030
   108.244    -7.359
>
   108.931    -7.333
   108.244    -7.359
>
   108.931    -7.333
   108.244    -7.359
>
   106.963    -6.887
   107.124    -7.065
>
   107.222    -6.844
   107.124    -7.065
>
   107.222    -6.844
   107.124    -7.065
>
   107.130    -7.309
   107.124    -7.065
>
   107.130    -7.309
   107.124    -7.065
>
   107.356    -6.931
   107.124    -7.065
>
   107.356    -6.931
   107.124    -7.065
>
   106.801    -7.057
   107.124    -7.065
>
   106.801    -7.057
   107.124    -7.065
>
   107.476    -7.087
   107.124    -7.065
>
   107.476    -7.087
   107.124    -7.065
>
   106.725    -6.975
   107.124    -7.065
>
   106.935    -6.698
   107.124    -7.065
>
   106.935    -6.698
   107.124    -7.065
>
   107.683    -7.030
   107.124    -7.065
>
   107.683    -7.030
   107.124    -7.065
>
   106.556    -7.005
   107.124    -7.065
>
   106.556    -7.005
   107.124    -7.065
>
   106.549    -6.969
   107.124    -7.065
>
   106.549    -6.969
   107.124    -7.065
>
   107.418    -6.531
   107.124    -7.065
>
   106.750    -6.554
   107.124    -7.065
>
   106.750    -6.554
   107.124    -7.065
>
   106.521    -7.330
   107.124    -7.065
>
   106.521    -7.330
   107.124    -7.065
>
   107.222    -6.844
   107.101    -6.839
>
   107.222    -6.844
   107.101    -6.839
>
   106.963    -6.887
   107.101    -6.839
>
   106.963    -6.887
   107.101    -6.839
>
   107.140    -7.017
   107.101    -6.839
>
   107.140    -7.017
   107.101    -6.839
>
   106.935    -6.698
   107.101    -6.839
>
   107.356    -6.931
   107.101    -6.839
>
   106.801    -7.057
   107.101    -6.839
>
   107.445    -6.742
   107.101    -6.839
>
   106.725    -6.975
   107.101    -6.839
>
   106.725    -6.975
   107.101    -6.839
>
   106.750    -6.554
   107.101    -6.839
>
   106.750    -6.554
   107.101    -6.839
>
   107.418    -6.531
   107.101    -6.839
>
   107.476    -7.087
   107.101    -6.839
>
   107.130    -7.309
   107.101    -6.839
>
   107.618    -6.827
   107.101    -6.839
>
   107.614    -6.667
   107.101    -6.839
>
   106.549    -6.969
   107.101    -6.839
>
   106.556    -7.005
   107.101    -6.839
>
   107.683    -7.030
   107.101    -6.839
>
   107.683    -7.030
   107.101    -6.839
>
   108.615    -6.803
   108.480    -6.960
>
   108.615    -6.803
   108.480    -6.960
>
   108.719    -6.913
   108.480    -6.960
>
   108.719    -6.913
   108.480    -6.960
>
   108.532    -7.364
   108.480    -6.960
>
   108.532    -7.364
   108.480    -6.960
>
   108.532    -7.363
   108.480    -6.960
>
   108.532    -7.363
   108.480    -6.960
>
   108.134    -6.762
   108.480    -6.960
>
   108.196    -7.317
   108.480    -6.960
>
   108.196    -7.317
   108.480    -6.960
>
   108.010    -6.741
   108.480    -6.960
>
   108.931    -7.333
   108.480    -6.960
>
   107.222    -6.844
   107.103    -6.799
>
   107.222    -6.844
   107.103    -6.799
>
   106.963    -6.887
   107.103    -6.799
>
   106.963    -6.887
   107.103    -6.799
>
   106.935    -6.698
   107.103    -6.799
>
   106.935    -6.698
   107.103    -6.799
>
   107.140    -7.017
   107.103    -6.799
>
   107.356    -6.931
   107.103    -6.799
>
   107.356    -6.931
   107.103    -6.799
>
   107.445    -6.742
   107.103    -6.799
>
   106.801    -7.057
   107.103    -6.799
>
   106.801    -7.057
   107.103    -6.799
>
   107.418    -6.531
   107.103    -6.799
>
   107.418    -6.531
   107.103    -6.799
>
   106.750    -6.554
   107.103    -6.799
>
   106.750    -6.554
   107.103    -6.799
>
   107.130    -7.309
   107.103    -6.799
>
   107.130    -7.309
   107.103    -6.799
>
   107.618    -6.827
   107.103    -6.799
>
   107.614    -6.667
   107.103    -6.799
>
   106.549    -6.969
   107.103    -6.799
>
   106.549    -6.969
   107.103    -6.799
>
   106.556    -7.005
   107.103    -6.799
>
   107.683    -7.030
   107.103    -6.799
>
   107.445    -6.742
   107.359    -6.721
>
   107.445    -6.742
   107.359    -6.721
>
   107.418    -6.531
   107.359    -6.721
>
   107.418    -6.531
   107.359    -6.721
>
   107.222    -6.844
   107.359    -6.721
>
   107.222    -6.844
   107.359    -6.721
>
   107.356    -6.931
   107.359    -6.721
>
   107.356    -6.931
   107.359    -6.721
>
   107.614    -6.667
   107.359    -6.721
>
   107.614    -6.667
   107.359    -6.721
>
   107.618    -6.827
   107.359    -6.721
>
   107.618    -6.827
   107.359    -6.721
>
   107.618    -6.827
   107.359    -6.721
>
   107.618    -6.827
   107.359    -6.721
>
   107.140    -7.017
   107.359    -6.721
>
   106.935    -6.698
   107.359    -6.721
>
   107.476    -7.087
   107.359    -6.721
>
   107.476    -7.087
   107.359    -6.721
>
   107.811    -6.732
   107.359    -6.721
>
   107.683    -7.030
   107.359    -6.721
>
   107.683    -7.030
   107.359    -6.721
>
   106.750    -6.554
   107.359    -6.721
>
   106.750    -6.554
   107.359    -6.721
>
   107.130    -7.309
   107.359    -6.721
>
   107.130    -7.309
   107.359    -6.721
>
   106.801    -7.057
   107.359    -6.721
>
   108.010    -6.741
   107.359    -6.721
>
   108.010    -6.741
   107.359    -6.721
>
   106.935    -6.698
   107.071    -6.819
>
   106.935    -6.698
   107.071    -6.819
>
   107.222    -6.844
   107.071    -6.819
>
   107.222    -6.844
   107.071    -6.819
>
   107.140    -7.017
   107.071    -6.819
>
   107.140    -7.017
   107.071    -6.819
>
   106.801    -7.057
   107.071    -6.819
>
   106.801    -7.057
   107.071    -6.819
>
   106.750    -6.554
   107.071    -6.819
>
   106.750    -6.554
   107.071    -6.819
>
   107.356    -6.931
   107.071    -6.819
>
   107.356    -6.931
   107.071    -6.819
>
   107.445    -6.742
   107.071    -6.819
>
   106.549    -6.969
   107.071    -6.819
>
   106.556    -7.005
   107.071    -6.819
>
   106.556    -7.005
   107.071    -6.819
>
   107.418    -6.531
   107.071    -6.819
>
   107.418    -6.531
   107.071    -6.819
>
   107.130    -7.309
   107.071    -6.819
>
   107.130    -7.309
   107.071    -6.819
>
   106.749    -6.265
   107.071    -6.819
>
   106.749    -6.265
   107.071    -6.819
>
   107.618    -6.827
   107.071    -6.819
>
   107.618    -6.827
   107.071    -6.819
>
   106.470    -6.484
   107.071    -6.819
>
   106.470    -6.484
   107.071    -6.819
>
   107.683    -7.030
   107.071    -6.819
>
   107.683    -7.030
   107.071    -6.819
>
   107.683    -7.030
   107.597    -7.197
>
   107.650    -7.463
   107.597    -7.197
>
   107.650    -7.463
   107.597    -7.197
>
   107.356    -6.931
   107.597    -7.197
>
   107.356    -6.931
   107.597    -7.197
>
   107.618    -6.827
   107.597    -7.197
>
   107.618    -6.827
   107.597    -7.197
>
   107.618    -6.827
   107.597    -7.197
>
   107.130    -7.309
   107.597    -7.197
>
   107.130    -7.309
   107.597    -7.197
>
   107.140    -7.017
   107.597    -7.197
>
   107.445    -6.742
   107.597    -7.197
>
   107.222    -6.844
   107.597    -7.197
>
   107.811    -6.732
   107.597    -7.197
>
   107.811    -6.732
   107.597    -7.197
>
   108.010    -6.741
   107.597    -7.197
>
   108.010    -6.741
   107.597    -7.197
>
   108.196    -7.317
   107.597    -7.197
>
   108.196    -7.317
   107.597    -7.197
>
   107.418    -6.531
   107.597    -7.197
>
   107.418    -6.531
   107.597    -7.197
>
   107.445    -6.742
   107.334    -6.740
>
   107.222    -6.844
   107.334    -6.740
>
   107.222    -6.844
   107.334    -6.740
>
   107.356    -6.931
   107.334    -6.740
>
   107.356    -6.931
   107.334    -6.740
>
   107.418    -6.531
   107.334    -6.740
>
   107.418    -6.531
   107.334    -6.740
>
   107.614    -6.667
   107.334    -6.740
>
   107.618    -6.827
   107.334    -6.740
>
   107.618    -6.827
   107.334    -6.740
>
   107.140    -7.017
   107.334    -6.740
>
   107.140    -7.017
   107.334    -6.740
>
   106.935    -6.698
   107.334    -6.740
>
   106.935    -6.698
   107.334    -6.740
>
   106.963    -6.887
   107.334    -6.740
>
   106.963    -6.887
   107.334    -6.740
>
   107.683    -7.030
   107.334    -6.740
>
   107.811    -6.732
   107.334    -6.740
>
   106.750    -6.554
   107.334    -6.740
>
   106.750    -6.554
   107.334    -6.740
>
   106.801    -7.057
   107.334    -6.740
>
   106.801    -7.057
   107.334    -6.740
>
   107.130    -7.309
   107.334    -6.740
>
   107.130    -7.309
   107.334    -6.740
>
   108.010    -6.741
   107.334    -6.740
>
   107.618    -6.827
   107.705    -7.318
>
   107.618    -6.827
   107.705    -7.318
>
   107.356    -6.931
   107.705    -7.318
>
   108.196    -7.317
   107.705    -7.318
>
   108.196    -7.317
   107.705    -7.318
>
   107.811    -6.732
   107.705    -7.318
>
   107.811    -6.732
   107.705    -7.318
>
   107.130    -7.309
   107.705    -7.318
>
   107.445    -6.742
   107.705    -7.318
>
   108.010    -6.741
   107.705    -7.318
>
   107.614    -6.667
   107.705    -7.318
>
   107.140    -7.017
   107.705    -7.318
>
   107.140    -7.017
   107.705    -7.318
>
   107.222    -6.844
   107.705    -7.318
>
   108.134    -6.762
   107.705    -7.318
>
   108.185    -6.493
   108.264    -6.156
>
   108.134    -6.762
   108.264    -6.156
>
   108.134    -6.762
   108.264    -6.156
>
   108.010    -6.741
   108.264    -6.156
>
   108.010    -6.741
   108.264    -6.156
>
   108.440    -6.796
   108.264    -6.156
>
   108.440    -6.796
   108.264    -6.156
>
   107.418    -6.531
   107.692    -6.041
>
   107.614    -6.667
   107.692    -6.041
>
   108.185    -6.493
   107.692    -6.041
>
   108.185    -6.493
   107.692    -6.041
>
   106.963    -6.887
   107.068    -6.842
>
   106.963    -6.887
   107.068    -6.842
>
   106.935    -6.698
   107.068    -6.842
>
   106.935    -6.698
   107.068    -6.842
>
   107.222    -6.844
   107.068    -6.842
>
   107.140    -7.017
   107.068    -6.842
>
   107.140    -7.017
   107.068    -6.842
>
   106.801    -7.057
   107.068    -6.842
>
   106.801    -7.057
   107.068    -6.842
>
   106.725    -6.975
   107.068    -6.842
>
   106.725    -6.975
   107.068    -6.842
>
   106.662    -6.831
   107.068    -6.842
>
   106.662    -6.831
   107.068    -6.842
>
   106.750    -6.554
   107.068    -6.842
>
   106.750    -6.554
   107.068    -6.842
>
   107.356    -6.931
   107.068    -6.842
>
   107.356    -6.931
   107.068    -6.842
>
   107.445    -6.742
   107.068    -6.842
>
   106.549    -6.969
   107.068    -6.842
>
   106.549    -6.969
   107.068    -6.842
>
   107.130    -7.309
   107.068    -6.842
>
   107.130    -7.309
   107.068    -6.842
>
   107.418    -6.531
   107.068    -6.842
>
   107.418    -6.531
   107.068    -6.842
>
   107.476    -7.087
   107.068    -6.842
>
   107.476    -7.087
   107.068    -6.842
>
   106.749    -6.265
   107.068    -6.842
>
   106.749    -6.265
   107.068    -6.842
>
   107.618    -6.827
   107.068    -6.842
>
   107.618    -6.827
   107.068    -6.842
>
   106.470    -6.484
   107.068    -6.842
>
   106.470    -6.484
   107.068    -6.842
>
   107.614    -6.667
   107.068    -6.842
>
   107.683    -7.030
   107.068    -6.842
>
   107.683    -7.030
   107.068    -6.842
>
   107.130    -7.309
   107.228    -7.531
>
   107.130    -7.309
   107.228    -7.531
>
   107.650    -7.463
   107.228    -7.531
>
   107.650    -7.463
   107.228    -7.531
>
   107.476    -7.087
   107.228    -7.531
>
   107.476    -7.087
   107.228    -7.531
>
   107.140    -7.017
   107.228    -7.531
>
   107.140    -7.017
   107.228    -7.531
>
   107.356    -6.931
   107.228    -7.531
>
   107.356    -6.931
   107.228    -7.531
>
   106.801    -7.057
   107.228    -7.531
>
   106.801    -7.057
   107.228    -7.531
>
   107.683    -7.030
   107.228    -7.531
>
   107.683    -7.030
   107.228    -7.531
>
   107.222    -6.844
   107.228    -7.531
>
   106.963    -6.887
   107.228    -7.531
>
   106.963    -6.887
   107.228    -7.531
>
   107.683    -7.030
   107.812    -7.179
>
   107.683    -7.030
   107.812    -7.179
>
   107.476    -7.087
   107.812    -7.179
>
   107.476    -7.087
   107.812    -7.179
>
   107.650    -7.463
   107.812    -7.179
>
   107.650    -7.463
   107.812    -7.179
>
   107.618    -6.827
   107.812    -7.179
>
   107.618    -6.827
   107.812    -7.179
>
   108.196    -7.317
   107.812    -7.179
>
   107.811    -6.732
   107.812    -7.179
>
   107.811    -6.732
   107.812    -7.179
>
   108.010    -6.741
   107.812    -7.179
>
   107.356    -6.931
   107.812    -7.179
>
   107.356    -6.931
   107.812    -7.179
>
   107.445    -6.742
   107.812    -7.179
>
   107.445    -6.742
   107.812    -7.179
>
   107.222    -6.844
   107.812    -7.179
>
   107.222    -6.844
   107.812    -7.179
>
   107.140    -7.017
   107.812    -7.179
>
   107.140    -7.017
   107.812    -7.179
>
   107.130    -7.309
   107.812    -7.179
>
   107.130    -7.309
   107.812    -7.179
>
   108.010    -6.741
   108.076    -6.708
>
   108.010    -6.741
   108.076    -6.708
>
   108.134    -6.762
   108.076    -6.708
>
   108.134    -6.762
   108.076    -6.708
>
   108.185    -6.493
   108.076    -6.708
>
   108.185    -6.493
   108.076    -6.708
>
   107.811    -6.732
   108.076    -6.708
>
   107.811    -6.732
   108.076    -6.708
>
   107.618    -6.827
   108.076    -6.708
>
   107.618    -6.827
   108.076    -6.708
>
   107.683    -7.030
   108.076    -6.708
>
   107.683    -7.030
   108.076    -6.708
>
   108.196    -7.317
   108.076    -6.708
>
   108.196    -7.317
   108.076    -6.708
>
   107.418    -6.531
   108.076    -6.708
>
   107.418    -6.531
   108.076    -6.708
>
   107.130    -7.309
   107.314    -7.572
>
   107.130    -7.309
   107.314    -7.572
>
   107.650    -7.463
   107.314    -7.572
>
   107.650    -7.463
   107.314    -7.572
>
   107.140    -7.017
   107.314    -7.572
>
   107.140    -7.017
   107.314    -7.572
>
   107.356    -6.931
   107.314    -7.572
>
   107.356    -6.931
   107.314    -7.572
>
   107.683    -7.030
   107.314    -7.572
>
   107.683    -7.030
   107.314    -7.572
>
   107.650    -7.463
   107.276    -7.800
>
   107.650    -7.463
   107.276    -7.800
>
   107.130    -7.309
   107.276    -7.800
>
   107.130    -7.309
   107.276    -7.800
>
   107.130    -7.309
   107.003    -7.968
>
   107.130    -7.309
   107.003    -7.968
>
   106.963    -6.887
   107.070    -6.841
>
   106.963    -6.887
   107.070    -6.841
>
   107.222    -6.844
   107.070    -6.841
>
   107.140    -7.017
   107.070    -6.841
>
   107.140    -7.017
   107.070    -6.841
>
   106.935    -6.698
   107.070    -6.841
>
   106.935    -6.698
   107.070    -6.841
>
   107.356    -6.931
   107.070    -6.841
>
   107.356    -6.931
   107.070    -6.841
>
   106.801    -7.057
   107.070    -6.841
>
   106.801    -7.057
   107.070    -6.841
>
   106.725    -6.975
   107.070    -6.841
>
   106.725    -6.975
   107.070    -6.841
>
   106.662    -6.831
   107.070    -6.841
>
   106.662    -6.831
   107.070    -6.841
>
   107.445    -6.742
   107.070    -6.841
>
   107.445    -6.742
   107.070    -6.841
>
   106.750    -6.554
   107.070    -6.841
>
   106.750    -6.554
   107.070    -6.841
>
   107.130    -7.309
   107.070    -6.841
>
   107.130    -7.309
   107.070    -6.841
>
   107.476    -7.087
   107.070    -6.841
>
   107.476    -7.087
   107.070    -6.841
>
   107.418    -6.531
   107.070    -6.841
>
   107.418    -6.531
   107.070    -6.841
>
   106.549    -6.969
   107.070    -6.841
>
   106.556    -7.005
   107.070    -6.841
>
   107.614    -6.667
   107.070    -6.841
>
   107.683    -7.030
   107.070    -6.841
>
   107.683    -7.030
   107.070    -6.841
>
   106.749    -6.265
   107.070    -6.841
>
   106.749    -6.265
   107.070    -6.841
>
   106.470    -6.484
   107.070    -6.841
>
   106.470    -6.484
   107.070    -6.841
>
   107.650    -7.463
   107.564    -7.381
>
   107.650    -7.463
   107.564    -7.381
>
   107.476    -7.087
   107.564    -7.381
>
   107.476    -7.087
   107.564    -7.381
>
   107.683    -7.030
   107.564    -7.381
>
   107.130    -7.309
   107.564    -7.381
>
   107.130    -7.309
   107.564    -7.381
>
   107.356    -6.931
   107.564    -7.381
>
   107.356    -6.931
   107.564    -7.381
>
   107.140    -7.017
   107.564    -7.381
>
   107.140    -7.017
   107.564    -7.381
>
   107.618    -6.827
   107.564    -7.381
>
   107.618    -6.827
   107.564    -7.381
>
   107.222    -6.844
   107.564    -7.381
>
   107.445    -6.742
   107.564    -7.381
>
   108.196    -7.317
   107.564    -7.381
>
   107.650    -7.463
   107.566    -7.361
>
   107.650    -7.463
   107.566    -7.361
>
   107.476    -7.087
   107.566    -7.361
>
   107.476    -7.087
   107.566    -7.361
>
   107.683    -7.030
   107.566    -7.361
>
   107.683    -7.030
   107.566    -7.361
>
   107.130    -7.309
   107.566    -7.361
>
   107.356    -6.931
   107.566    -7.361
>
   107.356    -6.931
   107.566    -7.361
>
   107.618    -6.827
   107.566    -7.361
>
   107.140    -7.017
   107.566    -7.361
>
   107.140    -7.017
   107.566    -7.361
>
   107.222    -6.844
   107.566    -7.361
>
   108.196    -7.317
   107.566    -7.361
>
   108.196    -7.317
   107.566    -7.361
>
   107.811    -6.732
   107.566    -7.361
>
   107.614    -6.667
   107.566    -7.361
>
   107.476    -7.087
   107.542    -7.389
>
   107.476    -7.087
   107.542    -7.389
>
   107.683    -7.030
   107.542    -7.389
>
   107.683    -7.030
   107.542    -7.389
>
   107.130    -7.309
   107.542    -7.389
>
   107.356    -6.931
   107.542    -7.389
>
   107.356    -6.931
   107.542    -7.389
>
   107.140    -7.017
   107.542    -7.389
>
   107.140    -7.017
   107.542    -7.389
>
   107.618    -6.827
   107.542    -7.389
>
   107.618    -6.827
   107.542    -7.389
>
   107.222    -6.844
   107.542    -7.389
>
   107.222    -6.844
   107.542    -7.389
>
   107.445    -6.742
   107.542    -7.389
>
   108.196    -7.317
   107.542    -7.389
>
   108.196    -7.317
   107.542    -7.389
>
   107.650    -7.463
   107.686    -7.282
>
   107.650    -7.463
   107.686    -7.282
>
   107.476    -7.087
   107.686    -7.282
>
   107.476    -7.087
   107.686    -7.282
>
   107.618    -6.827
   107.686    -7.282
>
   107.618    -6.827
   107.686    -7.282
>
   107.356    -6.931
   107.686    -7.282
>
   107.356    -6.931
   107.686    -7.282
>
   108.196    -7.317
   107.686    -7.282
>
   108.196    -7.317
   107.686    -7.282
>
   107.130    -7.309
   107.686    -7.282
>
   107.130    -7.309
   107.686    -7.282
>
   107.811    -6.732
   107.686    -7.282
>
   107.811    -6.732
   107.686    -7.282
>
   107.140    -7.017
   107.686    -7.282
>
   107.614    -6.667
   107.686    -7.282
>
   107.614    -6.667
   107.686    -7.282
>
   107.222    -6.844
   107.686    -7.282
>
   108.363    -7.328
   107.686    -7.282
>
   108.363    -7.328
   107.686    -7.282
>
   107.476    -7.087
   107.441    -7.190
>
   107.476    -7.087
   107.441    -7.190
>
   107.356    -6.931
   107.441    -7.190
>
   107.356    -6.931
   107.441    -7.190
>
   107.130    -7.309
   107.441    -7.190
>
   107.130    -7.309
   107.441    -7.190
>
   107.140    -7.017
   107.441    -7.190
>
   107.140    -7.017
   107.441    -7.190
>
   107.650    -7.463
   107.441    -7.190
>
   107.650    -7.463
   107.441    -7.190
>
   107.222    -6.844
   107.441    -7.190
>
   107.222    -6.844
   107.441    -7.190
>
   107.618    -6.827
   107.441    -7.190
>
   106.963    -6.887
   107.441    -7.190
>
   106.963    -6.887
   107.441    -7.190
>
   107.811    -6.732
   107.441    -7.190
>
   107.811    -6.732
   107.441    -7.190
>
   106.801    -7.057
   107.441    -7.190
>
   106.801    -7.057
   107.441    -7.190
>
   107.222    -6.844
   107.105    -6.835
>
   106.963    -6.887
   107.105    -6.835
>
   106.963    -6.887
   107.105    -6.835
>
   107.140    -7.017
   107.105    -6.835
>
   107.140    -7.017
   107.105    -6.835
>
   106.935    -6.698
   107.105    -6.835
>
   106.935    -6.698
   107.105    -6.835
>
   107.356    -6.931
   107.105    -6.835
>
   106.801    -7.057
   107.105    -6.835
>
   106.801    -7.057
   107.105    -6.835
>
   107.445    -6.742
   107.105    -6.835
>
   107.445    -6.742
   107.105    -6.835
>
   106.725    -6.975
   107.105    -6.835
>
   106.725    -6.975
   107.105    -6.835
>
   106.662    -6.831
   107.105    -6.835
>
   106.662    -6.831
   107.105    -6.835
>
   106.750    -6.554
   107.105    -6.835
>
   106.750    -6.554
   107.105    -6.835
>
   107.418    -6.531
   107.105    -6.835
>
   107.418    -6.531
   107.105    -6.835
>
   107.476    -7.087
   107.105    -6.835
>
   107.476    -7.087
   107.105    -6.835
>
   107.130    -7.309
   107.105    -6.835
>
   107.130    -7.309
   107.105    -6.835
>
   107.618    -6.827
   107.105    -6.835
>
   107.618    -6.827
   107.105    -6.835
>
   107.614    -6.667
   107.105    -6.835
>
   107.614    -6.667
   107.105    -6.835
>
   106.549    -6.969
   107.105    -6.835
>
   106.549    -6.969
   107.105    -6.835
>
   106.556    -7.005
   107.105    -6.835
>
   106.556    -7.005
   107.105    -6.835
>
   107.683    -7.030
   107.105    -6.835
>
   107.683    -7.030
   107.105    -6.835
>
   107.683    -7.030
   107.701    -7.223
>
   107.683    -7.030
   107.701    -7.223
>
   107.650    -7.463
   107.701    -7.223
>
   107.650    -7.463
   107.701    -7.223
>
   107.476    -7.087
   107.701    -7.223
>
   107.476    -7.087
   107.701    -7.223
>
   107.618    -6.827
   107.701    -7.223
>
   107.618    -6.827
   107.701    -7.223
>
   107.356    -6.931
   107.701    -7.223
>
   108.196    -7.317
   107.701    -7.223
>
   108.196    -7.317
   107.701    -7.223
>
   107.811    -6.732
   107.701    -7.223
>
   107.130    -7.309
   107.701    -7.223
>
   107.130    -7.309
   107.701    -7.223
>
   107.140    -7.017
   107.701    -7.223
>
   107.140    -7.017
   107.701    -7.223
>
   107.222    -6.844
   107.701    -7.223
>
   107.683    -7.030
   107.731    -7.241
>
   107.683    -7.030
   107.731    -7.241
>
   107.650    -7.463
   107.731    -7.241
>
   107.650    -7.463
   107.731    -7.241
>
   107.476    -7.087
   107.731    -7.241
>
   107.476    -7.087
   107.731    -7.241
>
   107.356    -6.931
   107.731    -7.241
>
   107.356    -6.931
   107.731    -7.241
>
   107.811    -6.732
   107.731    -7.241
>
   107.811    -6.732
   107.731    -7.241
>
   108.196    -7.317
   107.731    -7.241
>
   108.196    -7.317
   107.731    -7.241
>
   107.445    -6.742
   107.731    -7.241
>
   108.010    -6.741
   107.731    -7.241
>
   108.010    -6.741
   107.731    -7.241
>
   107.130    -7.309
   107.731    -7.241
>
   107.130    -7.309
   107.731    -7.241
>
   107.140    -7.017
   107.731    -7.241
>
   107.140    -7.017
   107.731    -7.241
>
   107.222    -6.844
   107.731    -7.241
>
   108.931    -7.333
   108.843    -7.154
>
   108.719    -6.913
   108.843    -7.154
>
   108.719    -6.913
   108.843    -7.154
>
   109.164    -7.197
   108.843    -7.154
>
   109.184    -7.007
   108.843    -7.154
>
   109.184    -7.007
   108.843    -7.154
>
   108.532    -7.363
   108.843    -7.154
>
   108.532    -7.364
   108.843    -7.154
>
   108.440    -6.796
   108.843    -7.154
>
   108.440    -6.796
   108.843    -7.154
>
   109.169    -7.681
   108.843    -7.154
>
   108.196    -7.317
   108.843    -7.154
>
   108.931    -7.333
   108.875    -7.144
>
   108.931    -7.333
   108.875    -7.144
>
   108.719    -6.913
   108.875    -7.144
>
   108.719    -6.913
   108.875    -7.144
>
   109.184    -7.007
   108.875    -7.144
>
   108.532    -7.363
   108.875    -7.144
>
   108.532    -7.363
   108.875    -7.144
>
   108.532    -7.364
   108.875    -7.144
>
   108.615    -6.803
   108.875    -7.144
>
   108.440    -6.796
   108.875    -7.144
>
   109.169    -7.681
   108.875    -7.144
>
   108.196    -7.317
   108.875    -7.144
>
   109.580    -7.168
   108.875    -7.144
>
   108.931    -7.333
   108.851    -7.153
>
   108.719    -6.913
   108.851    -7.153
>
   108.719    -6.913
   108.851    -7.153
>
   108.532    -7.363
   108.851    -7.153
>
   108.532    -7.364
   108.851    -7.153
>
   109.184    -7.007
   108.851    -7.153
>
   108.615    -6.803
   108.851    -7.153
>
   108.440    -6.796
   108.851    -7.153
>
   108.440    -6.796
   108.851    -7.153
>
   109.169    -7.681
   108.851    -7.153
>
   108.196    -7.317
   108.851    -7.153
>
   108.931    -7.333
   108.831    -7.158
>
   108.719    -6.913
   108.831    -7.158
>
   108.719    -6.913
   108.831    -7.158
>
   109.184    -7.007
   108.831    -7.158
>
   109.184    -7.007
   108.831    -7.158
>
   108.532    -7.364
   108.831    -7.158
>
   108.532    -7.363
   108.831    -7.158
>
   108.615    -6.803
   108.831    -7.158
>
   108.440    -6.796
   108.831    -7.158
>
   108.440    -6.796
   108.831    -7.158
>
   109.169    -7.681
   108.831    -7.158
>
   108.196    -7.317
   108.831    -7.158
>
   107.418    -6.531
   107.431    -6.486
>
   107.418    -6.531
   107.431    -6.486
>
   107.445    -6.742
   107.431    -6.486
>
   107.614    -6.667
   107.431    -6.486
>
   107.222    -6.844
   107.431    -6.486
>
   107.222    -6.844
   107.431    -6.486
>
   107.356    -6.931
   107.431    -6.486
>
   107.811    -6.732
   107.431    -6.486
>
   107.140    -7.017
   107.431    -6.486
>
   106.963    -6.887
   107.431    -6.486
>
   106.963    -6.887
   107.431    -6.486
>
   107.476    -7.087
   107.431    -6.486
>
   107.476    -7.087
   107.431    -6.486
>
   107.683    -7.030
   107.431    -6.486
>
   107.683    -7.030
   107.431    -6.486
>
   108.010    -6.741
   107.431    -6.486
>
   108.010    -6.741
   107.431    -6.486
>
   106.750    -6.554
   107.431    -6.486
>
   108.010    -6.741
   107.925    -6.855
>
   108.010    -6.741
   107.925    -6.855
>
   107.811    -6.732
   107.925    -6.855
>
   107.811    -6.732
   107.925    -6.855
>
   107.683    -7.030
   107.925    -6.855
>
   107.683    -7.030
   107.925    -6.855
>
   107.618    -6.827
   107.925    -6.855
>
   108.263    -6.734
   107.925    -6.855
>
   108.263    -6.734
   107.925    -6.855
>
   107.614    -6.667
   107.925    -6.855
>
   107.614    -6.667
   107.925    -6.855
>
   108.185    -6.493
   107.925    -6.855
>
   108.185    -6.493
   107.925    -6.855
>
   108.440    -6.796
   107.925    -6.855
>
   108.440    -6.796
   107.925    -6.855
>
   107.445    -6.742
   107.925    -6.855
>
   107.476    -7.087
   107.925    -6.855
>
   107.476    -7.087
   107.925    -6.855
>
   108.196    -7.317
   107.925    -6.855
>
   108.196    -7.317
   107.925    -6.855
>
   107.356    -6.931
   107.925    -6.855
>
   107.356    -6.931
   107.925    -6.855
>
   107.418    -6.531
   107.925    -6.855
>
   107.418    -6.531
   107.925    -6.855
>
   107.650    -7.463
   107.925    -6.855
>
   107.650    -7.463
   107.925    -6.855
>
   107.650    -7.463
   107.925    -6.855
>
   108.615    -6.803
   107.925    -6.855
>
   108.615    -6.803
   107.925    -6.855
>
   107.222    -6.844
   107.925    -6.855
>
   107.222    -6.844
   107.925    -6.855
>
   108.010    -6.741
   107.913    -6.837
>
   108.010    -6.741
   107.913    -6.837
>
   107.811    -6.732
   107.913    -6.837
>
   107.811    -6.732
   107.913    -6.837
>
   108.134    -6.762
   107.913    -6.837
>
   108.263    -6.734
   107.913    -6.837
>
   108.263    -6.734
   107.913    -6.837
>
   108.185    -6.493
   107.913    -6.837
>
   108.185    -6.493
   107.913    -6.837
>
   107.445    -6.742
   107.913    -6.837
>
   107.445    -6.742
   107.913    -6.837
>
   107.476    -7.087
   107.913    -6.837
>
   108.440    -6.796
   107.913    -6.837
>
   108.440    -6.796
   107.913    -6.837
>
   108.196    -7.317
   107.913    -6.837
>
   108.196    -7.317
   107.913    -6.837
>
   107.356    -6.931
   107.913    -6.837
>
   107.418    -6.531
   107.913    -6.837
>
   107.418    -6.531
   107.913    -6.837
>
   107.650    -7.463
   107.913    -6.837
>
   107.650    -7.463
   107.913    -6.837
>
   108.615    -6.803
   107.913    -6.837
>
   107.222    -6.844
   107.913    -6.837
>
   107.618    -6.827
   107.927    -6.869
>
   107.618    -6.827
   107.927    -6.869
>
   107.683    -7.030
   107.927    -6.869
>
   107.683    -7.030
   107.927    -6.869
>
   107.683    -7.030
   107.927    -6.869
>
   107.614    -6.667
   107.927    -6.869
>
   108.263    -6.734
   107.927    -6.869
>
   108.263    -6.734
   107.927    -6.869
>
   108.263    -6.734
   107.927    -6.869
>
   108.263    -6.734
   107.927    -6.869
>
   108.185    -6.493
   107.927    -6.869
>
   107.445    -6.742
   107.927    -6.869
>
   107.445    -6.742
   107.927    -6.869
>
   107.476    -7.087
   107.927    -6.869
>
   107.476    -7.087
   107.927    -6.869
>
   108.440    -6.796
   107.927    -6.869
>
   108.196    -7.317
   107.927    -6.869
>
   108.196    -7.317
   107.927    -6.869
>
   107.356    -6.931
   107.927    -6.869
>
   107.356    -6.931
   107.927    -6.869
>
   107.418    -6.531
   107.927    -6.869
>
   107.418    -6.531
   107.927    -6.869
>
   107.650    -7.463
   107.927    -6.869
>
   108.615    -6.803
   107.927    -6.869
>
   108.010    -6.741
   107.922    -6.837
>
   108.010    -6.741
   107.922    -6.837
>
   107.811    -6.732
   107.922    -6.837
>
   107.618    -6.827
   107.922    -6.837
>
   107.618    -6.827
   107.922    -6.837
>
   107.683    -7.030
   107.922    -6.837
>
   107.683    -7.030
   107.922    -6.837
>
   108.263    -6.734
   107.922    -6.837
>
   108.263    -6.734
   107.922    -6.837
>
   107.614    -6.667
   107.922    -6.837
>
   108.185    -6.493
   107.922    -6.837
>
   107.445    -6.742
   107.922    -6.837
>
   108.440    -6.796
   107.922    -6.837
>
   108.440    -6.796
   107.922    -6.837
>
   107.476    -7.087
   107.922    -6.837
>
   107.476    -7.087
   107.922    -6.837
>
   108.196    -7.317
   107.922    -6.837
>
   107.418    -6.531
   107.922    -6.837
>
   107.418    -6.531
   107.922    -6.837
>
   107.356    -6.931
   107.922    -6.837
>
   107.356    -6.931
   107.922    -6.837
>
   108.615    -6.803
   107.922    -6.837
>
   108.615    -6.803
   107.922    -6.837
>
   107.222    -6.844
   107.922    -6.837
>
   107.222    -6.844
   107.922    -6.837
>
   107.650    -7.463
   107.922    -6.837
>
   107.650    -7.463
   107.922    -6.837
>
   107.650    -7.463
   107.922    -6.837
>
   107.650    -7.463
   107.634    -7.267
>
   107.650    -7.463
   107.634    -7.267
>
   107.683    -7.030
   107.634    -7.267
>
   107.476    -7.087
   107.634    -7.267
>
   107.356    -6.931
   107.634    -7.267
>
   107.356    -6.931
   107.634    -7.267
>
   107.618    -6.827
   107.634    -7.267
>
   107.618    -6.827
   107.634    -7.267
>
   107.130    -7.309
   107.634    -7.267
>
   107.130    -7.309
   107.634    -7.267
>
   107.445    -6.742
   107.634    -7.267
>
   107.811    -6.732
   107.634    -7.267
>
   107.140    -7.017
   107.634    -7.267
>
   108.196    -7.317
   107.634    -7.267
>
   107.222    -6.844
   107.634    -7.267
>
   107.614    -6.667
   107.634    -7.267
>
   108.010    -6.741
   107.634    -7.267
>
   108.010    -6.741
   107.634    -7.267
>
   107.222    -6.844
   107.089    -6.787
>
   107.222    -6.844
   107.089    -6.787
>
   106.963    -6.887
   107.089    -6.787
>
   106.963    -6.887
   107.089    -6.787
>
   106.935    -6.698
   107.089    -6.787
>
   106.935    -6.698
   107.089    -6.787
>
   107.140    -7.017
   107.089    -6.787
>
   107.356    -6.931
   107.089    -6.787
>
   107.356    -6.931
   107.089    -6.787
>
   107.445    -6.742
   107.089    -6.787
>
   107.445    -6.742
   107.089    -6.787
>
   106.801    -7.057
   107.089    -6.787
>
   106.801    -7.057
   107.089    -6.787
>
   106.750    -6.554
   107.089    -6.787
>
   106.750    -6.554
   107.089    -6.787
>
   106.725    -6.975
   107.089    -6.787
>
   106.725    -6.975
   107.089    -6.787
>
   107.418    -6.531
   107.089    -6.787
>
   107.418    -6.531
   107.089    -6.787
>
   107.476    -7.087
   107.089    -6.787
>
   107.476    -7.087
   107.089    -6.787
>
   107.130    -7.309
   107.089    -6.787
>
   107.130    -7.309
   107.089    -6.787
>
   107.618    -6.827
   107.089    -6.787
>
   107.618    -6.827
   107.089    -6.787
>
   107.614    -6.667
   107.089    -6.787
>
   106.549    -6.969
   107.089    -6.787
>
   106.549    -6.969
   107.089    -6.787
>
   106.556    -7.005
   107.089    -6.787
>
   106.556    -7.005
   107.089    -6.787
>
   106.749    -6.265
   107.089    -6.787
>
   107.683    -7.030
   107.089    -6.787
>
   107.683    -7.030
   107.089    -6.787
>
   106.470    -6.484
   107.089    -6.787
>
   106.521    -7.330
   106.835    -7.739
>
   106.521    -7.330
   106.835    -7.739
>
   107.130    -7.309
   106.835    -7.739
>
   107.130    -7.309
   106.835    -7.739
>
   106.801    -7.057
   106.835    -7.739
>
   106.801    -7.057
   106.835    -7.739
>
   108.196    -7.317
   108.284    -7.300
>
   108.363    -7.328
   108.284    -7.300
>
   108.532    -7.363
   108.284    -7.300
>
   108.532    -7.363
   108.284    -7.300
>
   108.449    -7.784
   108.284    -7.300
>
   108.449    -7.784
   108.284    -7.300
>
   108.440    -6.796
   108.284    -7.300
>
   107.650    -7.463
   108.284    -7.300
>
   107.650    -7.463
   108.284    -7.300
>
   107.683    -7.030
   108.284    -7.300
>
   107.683    -7.030
   108.284    -7.300
>
   107.650    -7.463
   107.518    -7.475
>
   107.650    -7.463
   107.518    -7.475
>
   107.650    -7.463
   107.518    -7.475
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
   107.130    -7.309     0.300
   106.556    -7.005     0.300
   107.618    -6.827     0.300
   108.263    -6.734     0.300
   107.650    -7.463     0.300
   106.750    -6.554     0.300
   108.931    -7.333     0.300
   109.169    -7.681     0.300
   107.811    -6.732     0.300
   107.614    -6.667     0.300
   108.010    -6.741     0.300
   108.134    -6.762     0.300
   107.445    -6.742     0.300
   107.418    -6.531     0.300
   108.185    -6.493     0.300
   107.356    -6.931     0.300
   107.222    -6.844     0.300
   108.440    -6.796     0.300
   108.196    -7.317     0.300
   106.963    -6.887     0.300
   107.140    -7.017     0.300
   106.935    -6.698     0.300
   106.725    -6.975     0.300
   107.476    -7.087     0.300
   106.549    -6.969     0.300
   106.749    -6.265     0.300
   108.719    -6.913     0.300
   109.164    -7.197     0.300
   109.184    -7.007     0.300
   108.532    -7.363     0.300
   108.615    -6.803     0.300
   108.585    -6.873     0.300
   108.449    -7.784     0.300
   109.580    -7.168     0.300
   106.801    -7.057     0.300
   108.363    -7.328     0.300
   108.532    -7.364     0.300
   107.683    -7.030     0.300
   107.630    -6.830     0.300
   106.470    -6.484     0.300
   106.521    -7.330     0.300
   106.662    -6.831     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
   106.965    -7.878     0.200
>
   106.565    -6.825     0.200
>
   105.945    -7.417     0.200
>
   106.999    -7.942     0.200
>
   107.023    -7.879     0.200
>
   107.763    -7.220     0.200
>
   106.840    -8.020     0.200
>
   107.431    -7.877     0.200
>
   106.927    -8.000     0.200
>
   107.690    -7.288     0.200
>
   107.333    -6.782     0.200
>
   108.706    -7.291     0.200
>
   107.795    -6.665     0.200
>
   107.694    -7.255     0.200
>
   107.143    -6.814     0.200
>
   107.017    -7.924     0.200
>
   108.830    -7.155     0.200
>
   108.675    -7.222     0.200
>
   108.942    -7.184     0.200
>
   107.223    -7.182     0.200
>
   107.394    -6.547     0.200
>
   107.686    -7.237     0.200
>
   107.673    -7.301     0.200
>
   107.360    -6.742     0.200
>
   107.184    -6.979     0.200
>
   107.565    -7.293     0.200
>
   107.305    -7.483     0.200
>
   107.324    -7.479     0.200
>
   107.441    -7.191     0.200
>
   107.713    -7.264     0.200
>
   107.725    -7.290     0.200
>
   106.993    -7.916     0.200
>
   106.994    -7.982     0.200
>
   108.081    -7.860     0.200
>
   107.796    -7.641     0.200
>
   107.137    -7.968     0.200
>
   107.724    -7.262     0.200
>
   107.719    -7.276     0.200
>
   107.357    -6.787     0.200
>
   107.356    -6.773     0.200
>
   107.353    -6.761     0.200
>
   107.019    -6.970     0.200
>
   107.103    -6.852     0.200
>
   107.070    -6.837     0.200
>
   107.082    -6.827     0.200
>
   107.082    -6.856     0.200
>
   107.080    -6.852     0.200
>
   107.002    -7.900     0.200
>
   107.076    -6.848     0.200
>
   107.078    -6.813     0.200
>
   107.057    -6.835     0.200
>
   107.071    -6.856     0.200
>
   107.068    -6.850     0.200
>
   107.077    -6.985     0.200
>
   107.072    -6.838     0.200
>
   107.081    -6.856     0.200
>
   107.079    -6.852     0.200
>
   107.067    -6.848     0.200
>
   107.083    -6.792     0.200
>
   107.095    -6.798     0.200
>
   107.107    -6.853     0.200
>
   107.087    -6.816     0.200
>
   107.087    -6.828     0.200
>
   108.244    -7.359     0.200
>
   107.124    -7.065     0.200
>
   107.101    -6.839     0.200
>
   108.480    -6.960     0.200
>
   107.103    -6.799     0.200
>
   107.359    -6.721     0.200
>
   107.071    -6.819     0.200
>
   107.597    -7.197     0.200
>
   107.334    -6.740     0.200
>
   107.705    -7.318     0.200
>
   108.264    -6.156     0.200
>
   107.692    -6.041     0.200
>
   107.068    -6.842     0.200
>
   107.228    -7.531     0.200
>
   107.812    -7.179     0.200
>
   108.076    -6.708     0.200
>
   107.314    -7.572     0.200
>
   107.276    -7.800     0.200
>
   107.003    -7.968     0.200
>
   107.070    -6.841     0.200
>
   107.564    -7.381     0.200
>
   107.566    -7.361     0.200
>
   107.542    -7.389     0.200
>
   107.686    -7.282     0.200
>
   107.441    -7.190     0.200
>
   107.105    -6.835     0.200
>
   107.701    -7.223     0.200
>
   107.731    -7.241     0.200
>
   108.843    -7.154     0.200
>
   108.875    -7.144     0.200
>
   108.851    -7.153     0.200
>
   108.831    -7.158     0.200
>
   107.431    -6.486     0.200
>
   107.925    -6.855     0.200
>
   107.913    -6.837     0.200
>
   107.927    -6.869     0.200
>
   107.922    -6.837     0.200
>
   107.634    -7.267     0.200
>
   107.089    -6.787     0.200
>
   106.835    -7.739     0.200
>
   108.284    -7.300     0.200
>
   106.535    -7.756     0.200
>
   107.518    -7.475     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
   107.459    -7.149     0.000   222.000   222.000
   107.459    -7.149     0.000   444.000   444.000
EOF
gmt end
