#!/bin/bash
gmt begin bandung1.79_base pdf,ps
proj=-JM16.0c+
reg=-R105.8/109.0/-8.1/-5.9
gmt basemap $proj $reg -Bxa1.0f0.1 -Bya1.0f0.1 -BWeSn+t'Base Map bandung1.79'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Cross-section locations
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
   107.459    -7.149    26.000 143.2k
EOF
gmt plot $proj $reg -S=0.1 -Wthicker,blue << EOF
   107.459    -7.149    26.000 -122.0k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
   107.459    -7.149   116.000 2.5k
EOF
gmt plot $proj $reg -S=0.1 -Wthin,blue << EOF
   107.459    -7.149   116.000 -2.5k
EOF

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
   106.965    -7.878 1
   106.565    -6.825 2
   105.945    -7.417 3
   106.999    -7.942 4
   107.023    -7.879 5
   107.763    -7.220 6
   106.840    -8.020 7
   107.431    -7.877 8
   106.927    -8.000 9
   107.690    -7.288 10
   107.333    -6.782 11
   108.706    -7.291 12
   107.795    -6.665 13
   107.694    -7.255 14
   107.143    -6.814 15
   107.017    -7.924 16
   108.830    -7.155 17
   108.675    -7.222 18
   108.942    -7.184 19
   107.223    -7.182 20
   107.394    -6.547 21
   107.686    -7.237 22
   107.673    -7.301 23
   107.360    -6.742 24
   107.184    -6.979 25
   107.565    -7.293 26
   107.305    -7.483 27
   107.324    -7.479 28
   107.441    -7.191 29
   107.713    -7.264 30
   107.725    -7.290 31
   106.993    -7.916 32
   106.994    -7.982 33
   108.081    -7.860 34
   107.796    -7.641 35
   107.137    -7.968 36
   107.724    -7.262 37
   107.719    -7.276 38
   107.357    -6.787 39
   107.356    -6.773 40
   107.353    -6.761 41
   107.019    -6.970 42
   107.103    -6.852 43
   107.070    -6.837 44
   107.082    -6.827 45
   107.082    -6.856 46
   107.080    -6.852 47
   107.002    -7.900 48
   107.076    -6.848 49
   107.078    -6.813 50
   107.057    -6.835 51
   107.071    -6.856 52
   107.068    -6.850 53
   107.077    -6.985 54
   107.072    -6.838 55
   107.081    -6.856 56
   107.079    -6.852 57
   107.067    -6.848 58
   107.083    -6.792 59
   107.095    -6.798 60
   107.107    -6.853 61
   107.087    -6.816 62
   107.087    -6.828 63
   108.244    -7.359 64
   107.124    -7.065 65
   107.101    -6.839 66
   108.480    -6.960 67
   107.103    -6.799 68
   107.359    -6.721 69
   107.071    -6.819 70
   107.597    -7.197 71
   107.334    -6.740 72
   107.705    -7.318 73
   108.264    -6.156 74
   107.692    -6.041 75
   107.068    -6.842 76
   107.228    -7.531 77
   107.812    -7.179 78
   108.076    -6.708 79
   107.314    -7.572 80
   107.276    -7.800 81
   107.003    -7.968 82
   107.070    -6.841 83
   107.564    -7.381 84
   107.566    -7.361 85
   107.542    -7.389 86
   107.686    -7.282 87
   107.441    -7.190 88
   107.105    -6.835 89
   107.701    -7.223 90
   107.731    -7.241 91
   108.843    -7.154 92
   108.875    -7.144 93
   108.851    -7.153 94
   108.831    -7.158 95
   107.431    -6.486 96
   107.925    -6.855 97
   107.913    -6.837 98
   107.927    -6.869 99
   107.922    -6.837 100
   107.634    -7.267 101
   107.089    -6.787 102
   106.835    -7.739 103
   108.284    -7.300 104
   106.535    -7.756 105
   107.518    -7.475 106
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
   107.000    -7.650
   106.965    -7.878
>
   106.669    -6.683
   106.565    -6.825
>
   105.992    -7.197
   105.945    -7.417
>
   107.042    -7.796
   106.999    -7.942
>
   107.038    -7.817
   107.023    -7.879
>
   107.740    -7.126
   107.763    -7.220
>
   106.848    -7.886
   106.840    -8.020
>
   107.442    -7.825
   107.431    -7.877
>
   106.962    -7.942
   106.927    -8.000
>
   107.654    -7.330
   107.690    -7.288
>
   107.336    -6.765
   107.333    -6.782
>
   108.743    -7.037
   108.706    -7.291
>
   107.800    -6.640
   107.795    -6.665
>
   107.670    -7.270
   107.694    -7.255
>
   107.130    -6.800
   107.143    -6.814
>
   107.081    -7.812
   107.017    -7.924
>
   108.850    -7.140
   108.830    -7.155
>
   108.670    -7.230
   108.675    -7.222
>
   108.960    -7.180
   108.942    -7.184
>
   107.220    -7.180
   107.223    -7.182
>
   107.380    -6.530
   107.394    -6.547
>
   107.673    -7.228
   107.686    -7.237
>
   107.680    -7.250
   107.673    -7.301
>
   107.345    -6.705
   107.360    -6.742
>
   107.170    -6.980
   107.184    -6.979
>
   107.560    -7.270
   107.565    -7.293
>
   107.300    -7.480
   107.305    -7.483
>
   107.340    -7.440
   107.324    -7.479
>
   107.410    -7.140
   107.441    -7.191
>
   107.700    -7.240
   107.713    -7.264
>
   107.715    -7.283
   107.725    -7.290
>
   107.041    -7.722
   106.993    -7.916
>
   107.004    -8.007
   106.994    -7.982
>
   108.090    -7.830
   108.081    -7.860
>
   107.800    -7.590
   107.796    -7.641
>
   107.050    -7.990
   107.137    -7.968
>
   107.720    -7.250
   107.724    -7.262
>
   107.710    -7.260
   107.719    -7.276
>
   107.345    -6.591
   107.357    -6.787
>
   107.340    -6.750
   107.356    -6.773
>
   107.360    -6.740
   107.353    -6.761
>
   107.087    -6.839
   107.019    -6.970
>
   107.100    -6.860
   107.103    -6.852
>
   107.060    -6.830
   107.070    -6.837
>
   107.060    -6.830
   107.082    -6.827
>
   107.070    -6.860
   107.082    -6.856
>
   107.070    -6.850
   107.080    -6.852
>
   106.982    -7.960
   107.002    -7.900
>
   107.060    -6.850
   107.076    -6.848
>
   107.070    -6.830
   107.078    -6.813
>
   107.050    -6.830
   107.057    -6.835
>
   107.050    -6.870
   107.071    -6.856
>
   107.032    -6.858
   107.068    -6.850
>
   107.060    -6.980
   107.077    -6.985
>
   107.070    -6.840
   107.072    -6.838
>
   107.070    -6.860
   107.081    -6.856
>
   107.060    -6.860
   107.079    -6.852
>
   107.050    -6.840
   107.067    -6.848
>
   107.060    -6.800
   107.083    -6.792
>
   107.080    -6.810
   107.095    -6.798
>
   107.080    -6.840
   107.107    -6.853
>
   107.080    -6.820
   107.087    -6.816
>
   107.054    -6.871
   107.087    -6.828
>
   108.250    -7.380
   108.244    -7.359
>
   107.120    -7.060
   107.124    -7.065
>
   107.090    -6.840
   107.101    -6.839
>
   108.498    -6.981
   108.480    -6.960
>
   107.100    -6.800
   107.103    -6.799
>
   107.349    -6.692
   107.359    -6.721
>
   107.003    -6.813
   107.071    -6.819
>
   107.568    -7.190
   107.597    -7.197
>
   107.310    -6.720
   107.334    -6.740
>
   107.710    -7.260
   107.705    -7.318
>
   108.260    -6.037
   108.264    -6.156
>
   107.680    -6.000
   107.692    -6.041
>
   106.995    -6.831
   107.068    -6.842
>
   107.230    -7.520
   107.228    -7.531
>
   107.800    -7.160
   107.812    -7.179
>
   108.080    -6.700
   108.076    -6.708
>
   107.310    -7.550
   107.314    -7.572
>
   107.290    -7.780
   107.276    -7.800
>
   107.078    -7.788
   107.003    -7.968
>
   107.060    -6.850
   107.070    -6.841
>
   107.550    -7.360
   107.564    -7.381
>
   107.570    -7.350
   107.566    -7.361
>
   107.540    -7.330
   107.542    -7.389
>
   107.680    -7.270
   107.686    -7.282
>
   107.420    -7.180
   107.441    -7.190
>
   107.090    -6.840
   107.105    -6.835
>
   107.690    -7.240
   107.701    -7.223
>
   107.720    -7.210
   107.731    -7.241
>
   108.870    -7.160
   108.843    -7.154
>
   108.864    -7.136
   108.875    -7.144
>
   108.851    -7.189
   108.851    -7.153
>
   108.840    -7.150
   108.831    -7.158
>
   107.410    -6.470
   107.431    -6.486
>
   107.939    -6.861
   107.925    -6.855
>
   107.920    -6.830
   107.913    -6.837
>
   107.918    -6.821
   107.927    -6.869
>
   107.930    -6.810
   107.922    -6.837
>
   107.640    -7.260
   107.634    -7.267
>
   107.080    -6.780
   107.089    -6.787
>
   106.772    -7.500
   106.835    -7.739
>
   108.280    -7.300
   108.284    -7.300
>
   106.666    -7.377
   106.535    -7.756
>
   107.566    -7.242
   107.518    -7.475
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
   106.967    -7.878
   106.965    -7.878
>
   106.568    -6.825
   106.565    -6.825
>
   105.945    -7.418
   105.945    -7.417
>
   106.998    -7.942
   106.999    -7.942
>
   107.024    -7.879
   107.023    -7.879
>
   107.762    -7.220
   107.763    -7.220
>
   106.840    -8.022
   106.840    -8.020
>
   107.431    -7.872
   107.431    -7.877
>
   106.928    -7.999
   106.927    -8.000
>
   107.692    -7.288
   107.690    -7.288
>
   107.335    -6.780
   107.333    -6.782
>
   108.702    -7.287
   108.706    -7.291
>
   107.796    -6.666
   107.795    -6.665
>
   107.694    -7.254
   107.694    -7.255
>
   107.143    -6.815
   107.143    -6.814
>
   107.013    -7.923
   107.017    -7.924
>
   108.831    -7.153
   108.830    -7.155
>
   108.673    -7.222
   108.675    -7.222
>
   108.942    -7.185
   108.942    -7.184
>
   107.224    -7.183
   107.223    -7.182
>
   107.396    -6.549
   107.394    -6.547
>
   107.686    -7.238
   107.686    -7.237
>
   107.673    -7.296
   107.673    -7.301
>
   107.361    -6.744
   107.360    -6.742
>
   107.184    -6.980
   107.184    -6.979
>
   107.565    -7.293
   107.565    -7.293
>
   107.305    -7.481
   107.305    -7.483
>
   107.325    -7.477
   107.324    -7.479
>
   107.440    -7.190
   107.441    -7.191
>
   107.713    -7.263
   107.713    -7.264
>
   107.726    -7.288
   107.725    -7.290
>
   106.994    -7.917
   106.993    -7.916
>
   106.987    -7.977
   106.994    -7.982
>
   108.081    -7.856
   108.081    -7.860
>
   107.795    -7.643
   107.796    -7.641
>
   107.138    -7.969
   107.137    -7.968
>
   107.727    -7.261
   107.724    -7.262
>
   107.719    -7.273
   107.719    -7.276
>
   107.356    -6.786
   107.357    -6.787
>
   107.354    -6.766
   107.356    -6.773
>
   107.355    -6.762
   107.353    -6.761
>
   107.020    -6.971
   107.019    -6.970
>
   107.103    -6.851
   107.103    -6.852
>
   107.069    -6.837
   107.070    -6.837
>
   107.082    -6.825
   107.082    -6.827
>
   107.082    -6.856
   107.082    -6.856
>
   107.081    -6.853
   107.080    -6.852
>
   107.000    -7.893
   107.002    -7.900
>
   107.076    -6.848
   107.076    -6.848
>
   107.078    -6.813
   107.078    -6.813
>
   107.057    -6.835
   107.057    -6.835
>
   107.071    -6.856
   107.071    -6.856
>
   107.068    -6.851
   107.068    -6.850
>
   107.077    -6.985
   107.077    -6.985
>
   107.072    -6.837
   107.072    -6.838
>
   107.081    -6.856
   107.081    -6.856
>
   107.078    -6.851
   107.079    -6.852
>
   107.067    -6.847
   107.067    -6.848
>
   107.083    -6.792
   107.083    -6.792
>
   107.095    -6.798
   107.095    -6.798
>
   107.107    -6.853
   107.107    -6.853
>
   107.087    -6.815
   107.087    -6.816
>
   107.087    -6.828
   107.087    -6.828
>
   108.243    -7.357
   108.244    -7.359
>
   107.125    -7.065
   107.124    -7.065
>
   107.101    -6.839
   107.101    -6.839
>
   108.480    -6.961
   108.480    -6.960
>
   107.104    -6.798
   107.103    -6.799
>
   107.359    -6.720
   107.359    -6.721
>
   107.070    -6.821
   107.071    -6.819
>
   107.598    -7.198
   107.597    -7.197
>
   107.336    -6.746
   107.334    -6.740
>
   107.706    -7.317
   107.705    -7.318
>
   108.264    -6.163
   108.264    -6.156
>
   107.696    -6.036
   107.692    -6.041
>
   107.068    -6.845
   107.068    -6.842
>
   107.229    -7.531
   107.228    -7.531
>
   107.810    -7.179
   107.812    -7.179
>
   108.070    -6.703
   108.076    -6.708
>
   107.318    -7.577
   107.314    -7.572
>
   107.274    -7.805
   107.276    -7.800
>
   107.000    -7.973
   107.003    -7.968
>
   107.070    -6.842
   107.070    -6.841
>
   107.564    -7.381
   107.564    -7.381
>
   107.566    -7.361
   107.566    -7.361
>
   107.542    -7.387
   107.542    -7.389
>
   107.687    -7.280
   107.686    -7.282
>
   107.440    -7.183
   107.441    -7.190
>
   107.106    -6.836
   107.105    -6.835
>
   107.703    -7.225
   107.701    -7.223
>
   107.732    -7.244
   107.731    -7.241
>
   108.844    -7.155
   108.843    -7.154
>
   108.875    -7.147
   108.875    -7.144
>
   108.851    -7.153
   108.851    -7.153
>
   108.832    -7.158
   108.831    -7.158
>
   107.432    -6.486
   107.431    -6.486
>
   107.925    -6.853
   107.925    -6.855
>
   107.913    -6.836
   107.913    -6.837
>
   107.927    -6.867
   107.927    -6.869
>
   107.922    -6.836
   107.922    -6.837
>
   107.635    -7.267
   107.634    -7.267
>
   107.090    -6.788
   107.089    -6.787
>
   106.835    -7.740
   106.835    -7.739
>
   108.286    -7.297
   108.284    -7.300
>
   106.533    -7.760
   106.535    -7.756
>
   107.520    -7.479
   107.518    -7.475
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
   106.965    -7.878   -83.208     1.743     1.983
   106.565    -6.825   -73.486     3.132     4.587
   105.945    -7.417   -56.121     1.585     1.991
   106.999    -7.942   -34.467     2.549     3.244
   107.023    -7.879   -27.605     3.020     4.165
   107.763    -7.220   -57.076     2.808     3.377
   106.840    -8.020   -52.499     1.833     2.202
   107.431    -7.877   -60.581     2.782     3.023
   106.927    -8.000   -21.727     2.710     4.054
   107.690    -7.288   -78.235     3.815     6.225
   107.333    -6.782   -49.374     2.162     3.714
   108.706    -7.291    12.978     0.050     7.129
   107.795    -6.665    88.621     1.453     4.518
   107.694    -7.255    81.754     3.180     4.370
   107.143    -6.814   -83.368     2.564     3.408
   107.017    -7.924   -56.052     2.186     4.076
   108.830    -7.155   -70.431     2.122     4.103
   108.675    -7.222   -60.254     2.219     4.018
   108.942    -7.184   -73.539     1.470     2.639
   107.223    -7.182    74.954     1.892     2.769
   107.394    -6.547    87.181     1.864     3.927
   107.686    -7.237   -78.639     1.829     3.346
   107.673    -7.301   -71.657     2.943     5.832
   107.360    -6.742   -82.171     1.369     2.396
   107.184    -6.979   -78.627     1.789     2.094
   107.565    -7.293   -75.495     1.949     4.332
   107.305    -7.483   -81.453     2.219     3.380
   107.324    -7.479   -86.331     2.602     3.974
   107.441    -7.191    73.368     3.954     5.270
   107.713    -7.264   -79.033     1.705     3.368
   107.725    -7.290   -70.099     1.927     4.402
   106.993    -7.916   -80.258     1.288     1.626
   106.994    -7.982   -36.509     3.466     5.260
   108.081    -7.860   -80.741     1.567     3.423
   107.796    -7.641   -77.444     2.263     5.842
   107.137    -7.968   -66.015     3.722     6.410
   107.724    -7.262   -79.456     1.986     4.040
   107.719    -7.276   -84.886     3.786     5.667
   107.357    -6.787   -84.603     1.468     2.690
   107.356    -6.773    88.632     2.048     3.309
   107.353    -6.761    79.983     2.363     3.903
   107.019    -6.970   -65.347     1.501     2.710
   107.103    -6.852   -62.608     1.545     2.148
   107.070    -6.837   -66.654     1.861     2.494
   107.082    -6.827   -58.927     1.850     2.562
   107.082    -6.856   -71.660     1.216     1.811
   107.080    -6.852   -77.242     1.303     1.818
   107.002    -7.900   -44.268     2.846     5.086
   107.076    -6.848   -57.287     2.257     3.258
   107.078    -6.813   -71.999     1.834     2.689
   107.057    -6.835   -85.250     1.759     2.285
   107.071    -6.856   -70.764     1.540     2.236
   107.068    -6.850   -74.104     1.272     1.782
   107.077    -6.985   -87.524     1.566     2.281
   107.072    -6.838   -59.411     1.948     2.528
   107.081    -6.856   -67.608     1.164     1.651
   107.079    -6.852   -74.680     1.214     1.726
   107.067    -6.848   -73.053     1.528     2.082
   107.083    -6.792   -69.098     2.121     3.020
   107.095    -6.798   -64.637     2.099     3.130
   107.107    -6.853   -79.188     2.304     3.516
   107.087    -6.816   -62.176     1.905     2.526
   107.087    -6.828   -88.023     1.295     1.985
   108.244    -7.359   -79.283     2.332     6.708
   107.124    -7.065   -86.799     2.153     2.729
   107.101    -6.839   -77.803     1.662     2.399
   108.480    -6.960   -81.159     1.594     3.086
   107.103    -6.799   -67.715     1.803     2.599
   107.359    -6.721   -79.376     1.320     2.205
   107.071    -6.819   -61.773     1.182     1.648
   107.597    -7.197   -85.988     1.738     2.913
   107.334    -6.740    88.699     1.462     2.546
   107.705    -7.318   -76.362     1.458     2.914
   108.264    -6.156   -75.712     3.057     7.119
   107.692    -6.041   -77.192     2.829     6.643
   107.068    -6.842   -71.860     1.093     1.557
   107.228    -7.531    73.737     3.442     5.403
   107.812    -7.179   -78.469     2.582     4.183
   108.076    -6.708   -82.006     4.044     6.292
   107.314    -7.572   -80.135     3.315     5.412
   107.276    -7.800   -65.544     1.470     3.561
   107.003    -7.968   -30.434     1.943     2.197
   107.070    -6.841   -63.528     1.416     1.963
   107.564    -7.381   -75.071     2.287     3.739
   107.566    -7.361   -80.310     2.269     3.919
   107.542    -7.389   -73.124     1.175     2.903
   107.686    -7.282   -89.552     1.919     3.747
   107.441    -7.190    88.889     1.738     3.299
   107.105    -6.835   -76.778     1.468     2.287
   107.701    -7.223   -76.825     2.962     4.288
   107.731    -7.241   -78.536     2.663     5.094
   108.843    -7.154   -88.912     2.642     5.489
   108.875    -7.144   -74.753     1.529     2.792
   108.851    -7.153   -64.370     1.520     3.330
   108.831    -7.158   -61.725     1.600     3.339
   107.431    -6.486   -80.944     1.569     2.884
   107.925    -6.855    85.957     1.156     2.662
   107.913    -6.837    82.077     1.732     3.926
   107.927    -6.869    87.444     1.190     2.739
   107.922    -6.837    85.851     1.164     2.934
   107.634    -7.267    82.177     1.839     3.545
   107.089    -6.787   -71.822     1.458     2.363
   106.835    -7.739   -62.545     1.902     3.343
   108.284    -7.300   -76.519     3.609     6.610
   106.535    -7.756   -61.416     2.354     3.213
   107.518    -7.475   -46.794     3.461     4.963
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
   105.899    -8.068   -87.042     1.078     1.174
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
   105.922    -8.068   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
   105.899    -8.068     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
   105.899    -8.068     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
   105.899    -8.113   5 km
EOF
gmt end
