#!/bin/bash
gmt begin alberchigos1.34_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases alberchigos1.34'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     1.000    -1.034
     1.500    -1.065
     2.000    -1.097
     2.500    -1.129
     3.000    -1.161
     3.500    -1.192
     4.000    -1.224
     4.500    -1.256
     5.000    -1.288
     5.500    -1.319
     6.000    -1.351
     6.500    -1.383
     7.000    -1.415
     7.500    -1.446
     8.000    -1.478
     8.500    -1.510
     9.000    -1.542
     9.500    -1.573
    10.000    -1.605
    10.500    -1.637
    11.000    -1.669
    11.500    -1.700
    12.000    -1.732
    12.500    -1.764
    13.000    -1.796
    13.500    -1.827
    14.000    -1.859
    14.500    -1.891
    15.000    -1.923
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     1.204 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000     3.036
     1.500    -0.480
     2.000    -3.995
     2.500    -7.510
     3.000   -11.026
     3.500   -14.544
     4.000   -18.065
     4.500   -21.588
     5.000   -25.115
     5.500   -28.645
     6.000   -32.179
     6.500   -35.718
     7.000   -39.262
     7.500   -42.810
     8.000   -46.365
     8.500   -49.926
     9.000   -53.494
     9.500   -57.067
    10.000   -60.649
    10.500   -64.239
    11.000   -67.837
    11.500   -71.443
    12.000   -75.059
    12.500   -78.684
    13.000   -82.317
    13.500   -85.961
    14.000   -89.616
    14.500   -93.280
    15.000   -96.957
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -79.317 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     0.734
     1.000    -0.068
     1.500    -1.512
     2.000    -2.956
     2.500    -4.400
     3.000    -5.847
     3.500    -7.294
     4.000    -8.744
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -11.744 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     6.299    -2.792     0.200
     6.324    -4.839     0.200
     7.138    -0.735     0.200
     9.113    -0.001     0.200
     9.142     0.716     0.200
     1.950    -1.123     0.200
     2.461    -1.812     0.200
     4.796    -5.059     0.200
     7.463     0.038     0.200
     2.435    -2.067     0.200
     7.436     0.298     0.200
     8.486     5.792     0.200
     1.828    -0.186     0.200
     6.826     0.777     0.200
    10.692     3.304     0.200
     7.164     1.402     0.200
    12.123     1.987     0.200
     6.785     1.347     0.200
     8.908    -1.557     0.200
     1.780    -1.452     0.200
     5.105     0.451     0.200
     4.599     0.748     0.200
     5.857    -5.645     0.200
     6.306    -1.024     0.200
     6.821    -1.281     0.200
    11.110    -3.947     0.200
     1.532    -1.766     0.200
     1.958    -0.936     0.200
     2.301    -1.847     0.200
     2.684    -2.093     0.200
     2.909    -2.543     0.200
     1.852    -1.357     0.200
     3.562    -2.800     0.200
     5.167    -3.805     0.200
     8.989    -2.914     0.200
     1.761    -1.383     0.200
     1.761    -1.885     0.200
     1.901    -1.848     0.200
     1.935    -1.471     0.200
     2.159    -1.506     0.200
     2.461    -1.692     0.200
     2.504    -2.180     0.200
     6.766    -0.294     0.200
     8.440     3.419     0.200
     1.315    -1.157     0.200
     1.316    -1.179     0.200
     2.020    -1.577     0.200
     2.020    -1.466     0.200
     2.020    -1.861     0.200
     2.744    -3.395     0.200
     3.729    -2.285     0.200
     4.530    -4.075     0.200
     2.426    -1.359     0.200
     3.163    -2.533     0.200
     3.761    -2.855     0.200
     4.128    -1.915     0.200
     4.522    -3.235     0.200
     4.674    -3.871     0.200
     4.969    -5.486     0.200
     5.008    -2.423     0.200
     7.460    -0.103     0.200
     7.460    -0.111     0.200
     8.531     1.421     0.200
    10.534     6.206     0.200
     1.668     1.421     0.200
     1.735    -0.932     0.200
     2.424    -1.571     0.200
     2.424    -0.106     0.200
     2.731    -0.507     0.200
     3.161    -1.721     0.200
     3.725    -4.473     0.200
     3.760    -2.597     0.200
     4.026    -3.726     0.200
     4.127    -2.146     0.200
     4.207    -5.109     0.200
     4.520    -4.001     0.200
     4.668    -4.351     0.200
     4.965    -5.422     0.200
     5.006    -3.290     0.200
     5.374    -4.846     0.200
     5.877    -1.549     0.200
     6.903     3.439     0.200
     7.459    -0.554     0.200
     9.455    -3.273     0.200
     1.731    -0.855     0.200
     2.420    -1.333     0.200
     3.156    -2.665     0.200
     3.291    -3.585     0.200
     3.723    -3.122     0.200
     3.755    -2.543     0.200
     4.122    -2.605     0.200
     4.666    -4.189     0.200
     7.454    -0.592     0.200
     2.024    -2.242     0.200
     2.430    -0.535     0.200
     3.166    -1.627     0.200
     3.296    -2.666     0.200
     7.464     0.660     0.200
     8.551     1.732     0.200
    10.551     0.089     0.200
     1.737    -0.794     0.200
     2.024    -2.296     0.200
     2.426    -1.469     0.200
     3.163    -2.386     0.200
     3.729    -3.626     0.200
     3.762    -2.269     0.200
     4.129    -1.159     0.200
     1.686     0.511     0.200
     1.753    -1.190     0.200
     2.442    -1.840     0.200
     2.442    -2.066     0.200
     3.178    -2.762     0.200
     3.308    -3.723     0.200
     3.606    -0.269     0.200
     3.741    -3.864     0.200
     3.777    -2.542     0.200
     4.145    -2.892     0.200
     4.537    -3.604     0.200
     4.660    -2.470     0.200
     4.685    -4.632     0.200
     5.024    -2.537     0.200
     1.655    -1.613     0.200
     1.673     1.237     0.200
     1.746    -0.999     0.200
     1.904    -0.102     0.200
     1.904    -1.653     0.200
     2.433    -2.029     0.200
     3.171    -2.275     0.200
     3.308    -3.992     0.200
     3.412    -4.253     0.200
     3.739    -4.179     0.200
     3.769    -2.074     0.200
     3.834     1.574     0.200
     4.041    -4.218     0.200
     4.135    -1.252     0.200
     4.530    -3.045     0.200
     4.682    -4.097     0.200
     5.016    -2.474     0.200
     5.235     2.828     0.200
     5.250     4.495     0.200
     5.280    -0.642     0.200
     5.387    -4.884     0.200
     5.536     3.700     0.200
     7.468     1.070     0.200
     8.367     2.134     0.200
     2.407    -2.846     0.200
     2.955    -3.178     0.200
     3.397    -2.282     0.200
     3.444    -3.076     0.200
     3.564    -2.556     0.200
     3.950    -2.978     0.200
     4.498    -4.183     0.200
     4.718    -5.737     0.200
     4.806    -4.200     0.200
     7.261     0.300     0.200
    10.883     0.217     0.200
     1.748    -0.849     0.200
     2.032    -2.534     0.200
     2.437    -0.970     0.200
     2.437    -0.165     0.200
     2.437    -2.263     0.200
     3.158    -1.456     0.200
     3.173    -1.134     0.200
     3.411    -2.995     0.200
     3.576    -3.664     0.200
     3.736    -2.882     0.200
     3.773    -2.226     0.200
     4.105    -4.900     0.200
     4.218    -3.950     0.200
     4.532    -4.837     0.200
     4.679    -3.699     0.200
     1.743    -1.636     0.200
     1.914     0.248     0.200
     2.432    -1.459     0.200
     2.662    -2.475     0.200
     3.168    -2.337     0.200
     3.406    -3.645     0.200
     4.100    -4.677     0.200
     4.972    -5.584     0.200
     1.746    -0.655     0.200
     1.924    -1.572     0.200
     2.028    -2.280     0.200
     2.436    -2.108     0.200
     1.743    -1.309     0.200
     2.029    -2.242     0.200
     2.432    -1.006     0.200
     3.168    -2.016     0.200
     3.407    -4.018     0.200
     3.733    -3.551     0.200
     4.034    -2.902     0.200
     4.101    -4.701     0.200
     4.216    -3.310     0.200
     4.974    -5.352     0.200
     1.660    -1.843     0.200
     1.755    -1.251     0.200
     1.928    -1.693     0.200
     2.038    -2.528     0.200
     2.445    -1.835     0.200
     3.164    -2.289     0.200
     3.181    -2.385     0.200
     3.583    -3.695     0.200
     3.603    -1.873     0.200
     4.112    -4.897     0.200
     4.148    -1.416     0.200
     1.920    -1.373     0.200
     2.018    -1.813     0.200
     2.427    -1.798     0.200
     2.427    -0.673     0.200
     3.163    -1.330     0.200
     3.762    -2.492     0.200
     4.020    -3.069     0.200
     8.803     2.554     0.200
    11.241    17.041     0.200
     1.737    -0.944     0.200
     2.428    -1.886     0.200
     2.428    -0.806     0.200
     7.462    -2.176     0.200
     1.909    -1.739     0.200
     2.428    -1.197     0.200
     2.428     0.449     0.200
     3.153    -0.849     0.200
     3.403    -2.276     0.200
     6.523    -0.737     0.200
     7.430     0.099     0.200
     7.462    -6.321     0.200
    11.873    -6.755     0.200
    12.032     3.433     0.200
     1.874    -1.753     0.200
     2.979    -0.590     0.200
     5.748     5.147     0.200
     1.688    -2.467     0.200
     1.918     0.686     0.200
     2.447     0.025     0.200
     2.679    -2.432     0.200
     3.184    -1.362     0.200
     3.318    -1.653     0.200
     3.290    -2.438     0.200
     3.424    -3.853     0.200
     3.750    -2.398     0.200
     3.783    -1.583     0.200
     7.482    -0.172     0.200
     8.538    -0.609     0.200
     1.812    -1.995     0.200
     2.499    -2.577     0.200
     2.734    -3.540     0.200
     2.800    -0.661     0.200
     3.237    -3.328     0.200
     3.228    -2.060     0.200
     3.373    -2.890     0.200
     3.478    -3.683     0.200
     3.659     2.115     0.200
     3.805    -4.348     0.200
     4.250     1.429     0.200
     4.105    -4.384     0.200
     4.172    -5.316     0.200
     4.748    -4.736     0.200
     5.044    -6.556     0.200
     2.462    -1.717     0.200
     2.462    -0.999     0.200
     2.697    -2.721     0.200
     3.200    -2.013     0.200
     3.769    -3.491     0.200
     4.071    -3.112     0.200
     4.135    -4.914     0.200
     4.560    -2.399     0.200
     4.712    -5.151     0.200
     5.008    -4.670     0.200
     5.045    -3.310     0.200
     7.497     0.461     0.200
     1.785    -0.622     0.200
     2.075    -2.541     0.200
     2.472    -1.843     0.200
     2.707    -2.639     0.200
     3.205    -1.093     0.200
     3.209    -2.964     0.200
     3.348    -2.584     0.200
     3.452    -3.647     0.200
     3.631     2.331     0.200
     3.780    -2.697     0.200
     4.145    -4.938     0.200
     7.506    -1.415     0.200
     2.024    -2.157     0.200
     2.423    -0.241     0.200
     2.430    -0.244     0.200
     3.166    -1.254     0.200
     3.728    -1.693     0.200
     3.765    -2.177     0.200
     4.286     1.463     0.200
     4.524    -2.958     0.200
     4.672    -3.975     0.200
     4.970    -4.645     0.200
     5.246     2.736     0.200
     7.064     2.839     0.200
     8.989     9.921     0.200
     9.438     4.939     0.200
     1.427    -1.885     0.200
     1.857    -1.956     0.200
     1.857    -1.737     0.200
     2.581    -2.626     0.200
     3.186    -3.716     0.200
     4.069    -4.267     0.200
     4.370    -3.783     0.200
     1.251    -1.837     0.200
     1.564    -1.557     0.200
     2.228    -1.682     0.200
     2.228    -2.967     0.200
     2.374     0.555     0.200
     1.691    -2.068     0.200
     1.729    -1.693     0.200
     1.759    -1.083     0.200
     1.972    -1.996     0.200
     2.021    -1.251     0.200
     2.099    -2.045     0.200
     4.335    -4.954     0.200
     1.894    -1.109     0.200
     1.974    -0.960     0.200
     1.815    -2.131     0.200
     2.085    -1.330     0.200
     2.358    -1.213     0.200
     2.416    -2.744     0.200
     2.893    -1.821     0.200
     3.101    -2.653     0.200
     3.511    -3.741     0.200
     3.849    -4.765     0.200
     4.256    -3.597     0.200
     4.444    -5.557     0.200
     1.895    -0.991     0.200
     1.975    -1.276     0.200
     2.193    -2.238     0.200
     2.846    -1.575     0.200
     2.937    -3.648     0.200
     3.268    -2.742     0.200
     3.682    -3.649     0.200
     2.415    -2.100     0.200
     5.060    -0.670     0.200
    10.775     0.665     0.200
     1.560    -2.304     0.200
     1.915    -2.349     0.200
     2.397    -2.470     0.200
     2.399    -2.290     0.200
     2.399    -2.790     0.200
     2.399    -1.208     0.200
     3.119    -2.484     0.200
     3.466    -3.829     0.200
     3.479    -3.560     0.200
     3.616    -2.538     0.200
     3.726    -2.877     0.200
     4.015    -4.687     0.200
     4.109    -0.491     0.200
     4.888    -5.850     0.200
     1.186    -1.705     0.200
     1.186    -1.395     0.200
     1.330    -1.555     0.200
     1.555     1.165     0.200
     1.600    -2.056     0.200
     1.699    -2.024     0.200
     2.044    -2.929     0.200
     2.754    -3.738     0.200
     1.930    -2.152     0.200
     2.403    -0.993     0.200
     2.410    -1.259     0.200
     3.332    -3.047     0.200
     3.631    -1.805     0.200
     7.437     0.747     0.200
     9.501    -0.647     0.200
    10.758    -1.153     0.200
     1.898    -1.814     0.200
     2.203    -1.002     0.200
     3.917    -4.466     0.200
     1.606    -0.578     0.200
     1.647    -0.680     0.200
     1.974    -1.628     0.200
     2.648    -2.847     0.200
     3.392    -3.578     0.200
     3.421    -2.763     0.200
     3.790     1.501     0.200
     4.336     1.899     0.200
     1.509    -1.522     0.200
     1.911    -2.426     0.200
     2.213    -1.289     0.200
     2.220    -1.286     0.200
     1.705    -2.008     0.200
     1.760    -1.824     0.200
     1.910    -2.352     0.200
     2.496    -2.738     0.200
     3.085    -3.340     0.200
     3.924    -4.877     0.200
     1.339    -1.261     0.200
     2.501    -3.316     0.200
     3.087    -2.028     0.200
     3.243    -4.080     0.200
     4.088    -5.019     0.200
     4.532    -5.510     0.200
     2.215    -0.930     0.200
     2.346    -2.138     0.200
     2.502    -2.735     0.200
     3.945    -4.289     0.200
     4.533    -5.744     0.200
     1.570    -2.122     0.200
     1.701    -1.928     0.200
     1.706     0.537     0.200
     1.924    -2.671     0.200
     2.037     0.023     0.200
     2.409    -2.679     0.200
     1.096    -1.416     0.200
     1.186    -1.870     0.200
     1.300    -1.983     0.200
     1.300    -1.996     0.200
     1.319    -2.139     0.200
     1.441    -1.565     0.200
     1.614    -2.535     0.200
     1.786    -2.394     0.200
     1.271    -1.534     0.200
     1.559    -1.795     0.200
     1.607    -1.901     0.200
     1.642    -0.137     0.200
     2.267    -1.886     0.200
     3.015    -3.051     0.200
     1.135    -1.537     0.200
     1.137    -1.098     0.200
     1.137    -0.938     0.200
     1.234    -1.919     0.200
     1.337    -1.960     0.200
     1.365    -2.033     0.200
     1.397    -2.058     0.200
     1.510    -1.806     0.200
     1.670    -2.383     0.200
     1.854    -2.317     0.200
     2.557    -3.550     0.200
     1.703    -0.062     0.200
     1.697    -1.791     0.200
     2.035    -0.101     0.200
     2.405    -2.655     0.200
     2.752    -1.481     0.200
     3.125    -3.343     0.200
     3.541    -0.427     0.200
     3.594    -0.641     0.200
     3.621    -4.283     0.200
     3.732    -3.073     0.200
     4.115    -2.288     0.200
     4.183    -1.313     0.200
     4.572    -5.505     0.200
     4.655    -2.735     0.200
     4.894    -6.310     0.200
     4.976    -4.001     0.200
     7.431     1.088     0.200
     1.178    -0.741     0.200
     1.275    -1.245     0.200
     1.381    -1.831     0.200
     1.438    -1.854     0.200
     1.617    -1.242     0.200
     1.617    -1.065     0.200
     2.166    -1.651     0.200
     2.910    -3.192     0.200
     3.869    -4.710     0.200
     1.693    -1.646     0.200
     1.729    -1.290     0.200
     1.729    -1.735     0.200
     2.080    -2.275     0.200
     2.089    -1.584     0.200
     2.376    -1.465     0.200
     2.680    -3.309     0.200
     3.027    -1.498     0.200
     1.218    -1.540     0.200
     1.260    -1.329     0.200
     1.334    -1.452     0.200
     1.422    -2.139     0.200
     1.473     0.132     0.200
     1.605    -2.243     0.200
     1.620    -1.354     0.200
     1.636    -2.267     0.200
     1.925    -1.623     0.200
     1.638    -1.838     0.200
     1.658     0.218     0.200
     1.658    -0.068     0.200
     2.181    -1.834     0.200
     2.188    -0.914     0.200
     2.188    -1.318     0.200
     2.449    -3.263     0.200
     4.294    -5.512     0.200
     7.222    -0.332     0.200
     8.400    -1.120     0.200
     8.772     1.627     0.200
     9.198     0.328     0.200
    10.554    -2.986     0.200
    11.655    -6.226     0.200
    16.749    -3.308     0.200
    23.799    -4.115     0.200
    26.785    -2.439     0.200
     1.331    -1.205     0.200
     1.543    -1.974     0.200
     1.641    -2.098     0.200
     1.641    -1.469     0.200
     1.842    -2.289     0.200
     1.873    -2.425     0.200
     1.177    -1.266     0.200
     1.196    -0.851     0.200
     1.267    -1.430     0.200
     1.331    -1.583     0.200
     1.522    -1.485     0.200
     1.543    -2.050     0.200
     1.556     0.232     0.200
     1.676    -1.416     0.200
     1.179    -0.769     0.200
     1.197    -1.044     0.200
     1.197    -1.278     0.200
     1.268    -1.563     0.200
     1.332    -2.015     0.200
     1.453    -1.909     0.200
     1.522    -1.545     0.200
     1.544    -1.874     0.200
     1.674     0.185     0.200
     1.748    -0.444     0.200
     2.199    -2.252     0.200
     3.536    -2.299     0.200
     4.303    -4.617     0.200
     4.782    -3.117     0.200
     1.094    -1.390     0.200
     1.290    -1.980     0.200
     1.574    -1.063     0.200
     1.607    -2.504     0.200
     2.040    -2.317     0.200
     1.377    -1.822     0.200
     1.418    -0.974     0.200
     1.432    -0.739     0.200
     1.471    -2.047     0.200
     1.426     0.052     0.200
     1.722    -1.594     0.200
     1.716     0.043     0.200
     2.031    -0.203     0.200
     2.421    -2.387     0.200
     2.427    -2.258     0.200
     3.150    -3.683     0.200
     1.738    -0.897     0.200
     1.798    -0.448     0.200
     1.810     1.130     0.200
     1.829    -1.433     0.200
     1.928    -2.038     0.200
     1.994    -1.874     0.200
     2.128    -2.077     0.200
     2.133    -2.475     0.200
     2.159    -2.093     0.200
     2.381    -1.974     0.200
     1.442    -1.121     0.200
     1.453    -0.888     0.200
     1.534    -1.948     0.200
     1.662     0.138     0.200
     1.785    -1.578     0.200
     1.819    -0.304     0.200
     2.453    -1.456     0.200
     3.199    -2.355     0.200
     3.467    -5.026     0.200
     4.157    -5.361     0.200
     4.563    -3.795     0.200
     4.749    -5.482     0.200
     1.198    -1.945     0.200
     1.573    -1.997     0.200
     1.725     0.286     0.200
     2.017    -1.455     0.200
     2.017    -1.291     0.200
     2.017    -2.135     0.200
     2.741    -2.987     0.200
     3.205    -0.156     0.200
     3.278    -2.874     0.200
     3.346    -2.300     0.200
     3.726    -2.721     0.200
     4.093    -4.019     0.200
     4.222    -3.232     0.200
     4.266    -3.413     0.200
     7.045     1.142     0.200
     1.927    -2.061     0.200
     2.233    -1.455     0.200
     2.518    -2.762     0.200
     3.099    -2.707     0.200
     1.757    -0.784     0.200
     2.136    -0.414     0.200
     2.469    -2.849     0.200
     2.959    -0.396     0.200
     3.568    -0.889     0.200
     4.320    -2.491     0.200
     1.826    -2.396     0.200
     1.869    -1.312     0.200
     2.913    -2.877     0.200
     2.869    -2.309     0.200
     3.191    -0.754     0.200
     3.597    -3.545     0.200
     3.643    -4.594     0.200
     2.143    -1.091     0.200
     2.150    -0.930     0.200
     3.855    -4.615     0.200
     1.189    -1.392     0.200
     1.450    -1.245     0.200
     1.502     0.462     0.200
     1.531    -1.216     0.200
     1.556    -0.588     0.200
     1.646    -0.654     0.200
     1.664     0.440     0.200
     1.720     0.008     0.200
     1.730    -1.783     0.200
     1.730    -1.455     0.200
     2.109    -2.389     0.200
     1.223    -1.858     0.200
     1.223    -0.991     0.200
     1.367    -1.837     0.200
     1.387    -1.646     0.200
     1.429    -0.346     0.200
     1.438    -2.344     0.200
     1.512    -1.556     0.200
     1.526    -1.327     0.200
     1.869    -2.222     0.200
     2.226    -1.808     0.200
     2.591    -2.881     0.200
     2.808    -3.985     0.200
     1.634    -1.654     0.200
     1.815    -1.668     0.200
     1.171    -1.741     0.200
     1.376    -2.172     0.200
     1.376    -2.143     0.200
     1.388    -1.877     0.200
     1.468    -1.548     0.200
     1.487    -1.210     0.200
     1.675    -2.464     0.200
     1.751    -1.656     0.200
     1.816    -0.502     0.200
     1.830    -1.508     0.200
     2.549    -2.653     0.200
     1.121    -0.912     0.200
     1.172    -1.775     0.200
     1.255    -1.936     0.200
     1.376    -2.228     0.200
     1.389    -1.899     0.200
     1.468    -1.677     0.200
     1.487    -1.515     0.200
     1.751    -1.493     0.200
     1.182    -1.441     0.200
     1.200    -1.577     0.200
     1.572    -2.301     0.200
     1.588    -2.330     0.200
     1.684    -1.556     0.200
     1.876    -2.922     0.200
     1.347    -1.974     0.200
     1.432    -1.421     0.200
     1.432    -1.624     0.200
     1.432    -1.312     0.200
     1.447    -1.962     0.200
     1.491     1.108     0.200
     1.527    -2.008     0.200
     1.582     0.995     0.200
     1.650    -2.428     0.200
     1.650    -2.162     0.200
     1.650    -1.498     0.200
     1.680    -0.760     0.200
     1.713    -1.844     0.200
     1.745    -2.235     0.200
     1.919    -2.351     0.200
     2.435    -2.870     0.200
     2.435    -2.299     0.200
     2.945    -0.391     0.200
     3.171    -3.827     0.200
     3.300    -4.636     0.200
     3.733    -4.293     0.200
     4.939    -5.595     0.200
     7.469     0.115     0.200
     1.381    -0.885     0.200
     1.430     0.900     0.200
     1.444    -0.063     0.200
     1.445    -1.307     0.200
     1.459     1.719     0.200
     1.463    -0.820     0.200
     1.532     0.635     0.200
     1.551    -1.354     0.200
     1.551    -1.564     0.200
     1.610    -1.641     0.200
     1.637    -1.483     0.200
     1.730    -1.822     0.200
     1.765    -0.860     0.200
     1.782    -1.745     0.200
     2.441    -2.027     0.200
     2.441    -2.413     0.200
     3.189    -3.367     0.200
     3.292    -4.468     0.200
     3.415    -4.526     0.200
     3.776    -3.348     0.200
     4.125    -3.491     0.200
     4.157    -4.858     0.200
     4.756    -5.822     0.200
     7.467    -3.074     0.200
     8.294    -4.254     0.200
     9.382    -2.071     0.200
     1.086    -1.101     0.200
     1.086    -1.308     0.200
     1.209    -1.597     0.200
     1.464    -1.496     0.200
     1.550    -1.741     0.200
     1.583    -2.283     0.200
     1.589     0.050     0.200
     1.675    -1.565     0.200
     1.131    -1.478     0.200
     1.212    -1.814     0.200
     1.336    -1.998     0.200
     1.439    -1.124     0.200
     1.693    -1.361     0.200
     1.704    -1.582     0.200
     1.776    -1.590     0.200
     1.783    -1.093     0.200
     1.783    -1.881     0.200
     2.148    -0.840     0.200
     2.502    -1.992     0.200
     1.095    -1.489     0.200
     1.095    -1.020     0.200
     1.164    -1.359     0.200
     1.286    -2.014     0.200
     2.061    -2.228     0.200
     2.797    -2.472     0.200
     3.732    -4.462     0.200
     1.505     1.463     0.200
     1.804    -2.441     0.200
     1.804    -1.933     0.200
     4.487    -3.152     0.200
     1.240    -1.447     0.200
     1.253    -1.636     0.200
     1.375    -1.967     0.200
     1.386    -1.761     0.200
     1.672    -2.307     0.200
     1.748    -1.580     0.200
     1.821    -1.450     0.200
     1.827    -1.407     0.200
     1.827    -1.665     0.200
     2.191    -0.606     0.200
     2.545    -2.505     0.200
     3.153    -3.590     0.200
     1.354    -1.345     0.200
     1.354    -1.627     0.200
     1.475    -2.025     0.200
     1.173    -1.662     0.200
     1.671    -1.910     0.200
     2.066    -2.135     0.200
     2.177    -2.668     0.200
     2.882    -2.988     0.200
     1.327    -1.242     0.200
     1.471    -1.924     0.200
     1.787    -2.153     0.200
     1.787    -2.395     0.200
     2.054    -2.380     0.200
     2.797    -2.493     0.200
     3.485    -4.418     0.200
     9.167     4.100     0.200
    10.769    -1.321     0.200
     1.464    -1.816     0.200
     1.690    -1.427     0.200
     1.783    -1.202     0.200
     1.798    -0.730     0.200
     2.048    -2.674     0.200
     2.524    -1.728     0.200
     2.755    -3.508     0.200
     2.792    -3.763     0.200
     3.480    -4.510     0.200
     1.259    -1.488     0.200
     1.463    -2.077     0.200
     1.721    -2.505     0.200
     1.797    -0.153     0.200
     1.230    -1.034     0.200
     1.303    -1.270     0.200
     1.474    -1.834     0.200
     1.732    -2.107     0.200
     1.336    -1.200     0.200
     1.294    -1.944     0.200
     1.469    -1.734     0.200
     1.524    -1.849     0.200
     1.566    -1.457     0.200
     1.601    -1.651     0.200
     1.654    -1.150     0.200
     1.654    -1.748     0.200
     1.691    -1.870     0.200
     2.383    -2.701     0.200
     7.418    -2.128     0.200
     8.572    -4.490     0.200
     9.427    -4.335     0.200
    10.598    -2.255     0.200
     1.099    -0.915     0.200
     1.105    -0.914     0.200
     1.308    -1.878     0.200
     1.421     1.219     0.200
     1.474     0.018     0.200
     1.906    -2.232     0.200
     6.924     3.183     0.200
     2.213    -1.407     0.200
     8.409    -0.454     0.200
     8.749     0.036     0.200
     9.223    -4.088     0.200
    10.548    -2.840     0.200
     2.198    -0.138     0.200
     2.205    -0.094     0.200
     7.238    -1.751     0.200
     8.407    -1.615     0.200
    10.551    -0.905     0.200
    11.670    -6.787     0.200
    12.224     1.928     0.200
     1.179    -0.989     0.200
     1.201    -1.033     0.200
     1.292    -1.276     0.200
     1.292    -1.729     0.200
     1.476    -1.684     0.200
     1.567    -1.794     0.200
     1.579    -0.080     0.200
     1.698    -0.733     0.200
     1.286    -1.149     0.200
     1.574    -0.482     0.200
     1.247    -1.027     0.200
     3.152     0.465     0.200
     1.289    -1.208     0.200
     1.289    -1.107     0.200
     3.111    -0.660     0.200
     1.338    -1.518     0.200
     1.389    -1.819     0.200
     1.423    -1.515     0.200
     1.470    -1.301     0.200
     1.459    -1.597     0.200
     1.581    -2.141     0.200
     1.891    -0.613     0.200
     2.006    -1.593     0.200
     2.018    -2.022     0.200
     2.066    -1.633     0.200
     2.127    -1.539     0.200
     1.280    -1.027     0.200
     1.527    -1.411     0.200
     1.654    -1.860     0.200
     1.722    -1.988     0.200
     3.119    -0.237     0.200
     1.707    -1.669     0.200
     1.740    -0.289     0.200
     1.752    -0.947     0.200
     1.857    -0.585     0.200
     1.875    -1.235     0.200
     1.953    -1.226     0.200
     2.144    -1.110     0.200
     1.220    -1.458     0.200
     1.311    -1.645     0.200
     1.468    -0.153     0.200
     1.495    -1.554     0.200
     1.496    -1.884     0.200
     1.558    -1.941     0.200
     1.582    -0.318     0.200
     1.633    -1.144     0.200
     1.661    -1.657     0.200
     1.576    -0.967     0.200
     1.604    -0.145     0.200
     1.702    -1.159     0.200
     1.725    -1.742     0.200
     1.756    -1.965     0.200
     1.233    -1.168     0.200
     1.271    -1.185     0.200
     1.303    -1.578     0.200
     1.303    -1.860     0.200
     1.310    -1.481     0.200
     1.312    -1.585     0.200
     1.424    -2.165     0.200
     1.696    -0.347     0.200
     1.729    -1.005     0.200
     1.864    -2.108     0.200
     1.216    -0.954     0.200
     1.084    -1.883     0.200
     1.269    -1.826     0.200
     1.344     1.532     0.200
     1.382     1.204     0.200
     1.992    -2.364     0.200
     7.024    -1.656     0.200
     1.691     3.240     0.200
     1.692    -0.453     0.200
     1.694    -1.608     0.200
     1.397    -1.262     0.200
     1.397    -1.471     0.200
     1.653    -1.720     0.200
     1.649    -1.144     0.200
     1.696    -1.398     0.200
     1.826    -1.719     0.200
     2.046    -2.413     0.200
     1.588    -1.028     0.200
     1.592    -1.548     0.200
     1.658    -1.895     0.200
     1.650    -0.782     0.200
     1.701    -1.421     0.200
     1.831    -1.805     0.200
     2.041    -2.640     0.200
     2.151    -2.235     0.200
    10.596    -2.423     0.200
     1.819    -1.654     0.200
     1.811    -0.403     0.200
     1.887    -1.186     0.200
     1.918    -0.099     0.200
     2.063    -0.725     0.200
     2.064    -0.821     0.200
     2.157    -1.048     0.200
     1.653    -2.002     0.200
     1.702    -0.921     0.200
     2.047     0.147     0.200
     1.303    -1.277     0.200
     1.563    -0.498     0.200
     1.590    -0.788     0.200
     1.614    -1.680     0.200
     1.615     0.008     0.200
     1.668    -0.245     0.200
     1.680    -1.914     0.200
     1.694    -0.935     0.200
     1.729    -0.986     0.200
     1.794    -1.733     0.200
     1.833    -2.445     0.200
     1.853    -1.664     0.200
     1.664    -1.743     0.200
     1.798    -2.000     0.200
     1.787    -1.607     0.200
     1.816    -2.437     0.200
     1.289    -1.933     0.200
     1.726    -1.790     0.200
     1.110    -1.336     0.200
     1.185    -1.625     0.200
     1.322    -1.592     0.200
     1.322    -1.432     0.200
     1.456    -1.580     0.200
     1.598    -2.088     0.200
     1.509    -3.098     0.200
     1.698    -1.530     0.200
     1.754    -0.763     0.200
     1.661    -1.651     0.200
     1.661    -1.498     0.200
     1.713    -0.930     0.200
     1.800    -1.068     0.200
     1.816    -1.025     0.200
     1.691     0.144     0.200
     1.686    -1.827     0.200
     2.238    -1.676     0.200
     7.272    -0.430     0.200
     8.400    -3.741     0.200
     9.242    -1.424     0.200
    12.241     1.879     0.200
     1.945    -0.315     0.200
     1.502    -1.930     0.200
     1.720     0.410     0.200
     1.693    -1.350     0.200
     1.520    -3.458     0.200
     1.586    -1.540     0.200
     3.090     1.455     0.200
     7.271    -0.891     0.200
    10.527     1.048     0.200
     1.503    -1.792     0.200
     1.692    -2.193     0.200
     2.244    -1.858     0.200
     7.278    -1.634     0.200
     1.597    -1.949     0.200
     1.610    -1.488     0.200
     1.642    -1.391     0.200
     1.639     2.045     0.200
     1.700     0.001     0.200
     1.722     0.459     0.200
     1.763    -1.889     0.200
     2.249    -2.516     0.200
     1.506    -1.521     0.200
     1.913    -1.561     0.200
     1.778     0.046     0.200
     1.874    -0.750     0.200
     1.928    -1.438     0.200
     2.269    -1.746     0.200
     1.499    -2.050     0.200
     1.583    -1.996     0.200
     1.673    -1.326     0.200
     1.578    -1.525     0.200
     1.676    -1.824     0.200
     1.877    -2.557     0.200
     1.894    -2.532     0.200
     2.228    -1.353     0.200
     3.099    -0.010     0.200
     7.261     0.999     0.200
    10.530     0.636     0.200
     2.230    -2.492     0.200
     1.303    -1.319     0.200
     1.303    -1.631     0.200
     1.488    -1.830     0.200
     1.888    -1.752     0.200
     3.086    -0.553     0.200
     1.486    -1.773     0.200
     1.687    -1.908     0.200
     1.702    -0.411     0.200
     1.486    -2.028     0.200
     1.244    -1.706     0.200
     1.245    -1.471     0.200
     1.361    -2.033     0.200
     1.438    -0.661     0.200
     1.506    -2.019     0.200
     1.533    -2.009     0.200
     1.605    -1.277     0.200
     1.623    -2.411     0.200
     1.647    -0.310     0.200
     1.658    -1.585     0.200
     1.706    -2.084     0.200
     1.726    -1.004     0.200
     1.737    -2.493     0.200
     1.801    -2.663     0.200
     1.863    -2.806     0.200
     1.509    -4.062     0.200
     1.493    -1.858     0.200
     1.711     0.478     0.200
     1.883    -2.513     0.200
     1.903    -1.154     0.200
     7.256    -2.442     0.200
     8.404    -5.298     0.200
     1.516    -3.993     0.200
     1.614    -2.001     0.200
     1.603     0.207     0.200
     1.211    -0.866     0.200
     1.230    -1.057     0.200
     1.332    -1.400     0.200
     1.409    -1.692     0.200
     1.467    -2.063     0.200
     1.509     0.531     0.200
     1.556    -1.375     0.200
     1.606    -0.072     0.200
     1.665    -2.477     0.200
     1.677    -0.887     0.200
     1.894    -2.667     0.200
     1.953    -0.475     0.200
     8.573    -3.478     0.200
    10.850    -2.025     0.200
     1.361    -1.147     0.200
     1.588    -0.477     0.200
     2.224    -1.053     0.200
     1.484    -1.931     0.200
     1.576    -1.573     0.200
     1.648    -1.551     0.200
     1.740    -2.146     0.200
     1.227    -1.575     0.200
     1.282    -1.152     0.200
     1.398    -1.505     0.200
     1.563    -1.033     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.021   -19.695     0.200
     0.967     3.419     0.200
     0.944     3.215     0.200
     2.835   -11.876     0.200
     9.208   -57.257     0.200
     1.738    -4.686     0.200
     1.738    -3.916     0.200
     3.071   -12.908     0.200
     3.441   -14.705     0.200
     3.476   -13.031     0.200
     4.313   -19.266     0.200
     6.297   -36.501     0.200
     7.174   -41.571     0.200
     9.294   -54.335     0.200
     1.810    -4.723     0.200
     1.447     0.023     0.200
     1.958    -4.424     0.200
     2.004    -5.822     0.200
     2.153    -7.666     0.200
     2.678   -10.311     0.200
     2.701   -11.307     0.200
     3.049   -13.393     0.200
     3.327   -15.103     0.200
     2.930   -11.767     0.200
     1.170     0.457     0.200
     2.210    -6.782     0.200
     2.331    -7.961     0.200
     2.362    -8.954     0.200
     2.606    -9.092     0.200
     2.968   -13.020     0.200
     3.029   -12.207     0.200
     3.059   -13.666     0.200
     3.059   -12.181     0.200
     3.237   -14.129     0.200
     3.424   -15.586     0.200
     3.424   -14.205     0.200
     3.779   -17.721     0.200
     4.372   -22.187     0.200
     4.533   -22.852     0.200
     2.194    -8.233     0.200
     2.558    -9.187     0.200
     2.558    -9.186     0.200
     3.765   -16.990     0.200
     3.765   -17.751     0.200
     1.666     1.070     0.200
     1.738    -0.820     0.200
     1.899    -3.686     0.200
     3.571   -14.946     0.200
     4.128   -14.774     0.200
     4.266   -16.436     0.200
     5.229   -21.292     0.200
     5.534   -29.805     0.200
     6.535   -36.678     0.200
     1.906    -3.672     0.200
     2.525    -9.962     0.200
     2.525    -8.649     0.200
     2.979   -10.152     0.200
     3.585   -12.797     0.200
     5.420   -28.809     0.200
     5.544   -28.504     0.200
     5.544   -30.161     0.200
     1.172     3.347     0.200
     1.188     2.938     0.200
     1.639    -1.249     0.200
     1.900    -3.825     0.200
     3.563   -12.771     0.200
     3.583   -14.144     0.200
     1.740    -0.380     0.200
     4.943   -22.291     0.200
     1.177     3.245     0.200
     1.343     2.078     0.200
     1.645    -1.080     0.200
     1.668     0.872     0.200
     3.569   -14.459     0.200
     3.589   -13.801     0.200
     1.194     3.095     0.200
     1.355     0.429     0.200
     1.446    -0.546     0.200
     1.658    -2.372     0.200
     3.837   -16.814     0.200
     1.178     2.831     0.200
     1.193     2.211     0.200
     1.437    -0.111     0.200
     1.437    -0.002     0.200
     2.433    -6.889     0.200
     3.579   -14.722     0.200
     3.822   -16.542     0.200
     3.834   -15.445     0.200
     4.135   -16.916     0.200
     4.222   -19.853     0.200
     4.262   -20.960     0.200
     4.978   -23.037     0.200
     5.250   -23.935     0.200
     5.536   -28.117     0.200
     6.539   -36.460     0.200
     7.795   -43.314     0.200
     8.530   -50.235     0.200
     8.786   -52.930     0.200
     8.772   -50.212     0.200
     8.869   -52.288     0.200
     8.983   -57.829     0.200
     9.004   -55.141     0.200
     9.136   -53.369     0.200
     9.194   -50.793     0.200
     9.458   -59.067     0.200
     9.861   -56.528     0.200
    10.401   -62.883     0.200
    10.736   -64.291     0.200
    10.821   -71.251     0.200
    11.179   -68.756     0.200
    12.122   -73.981     0.200
    12.652   -77.828     0.200
    12.750   -80.986     0.200
    13.369   -83.218     0.200
    13.483   -86.509     0.200
    13.654   -86.299     0.200
    13.709   -86.026     0.200
     1.529    -1.429     0.200
     1.560    -0.302     0.200
     1.743    -2.590     0.200
     2.649   -10.261     0.200
     2.809   -10.897     0.200
     1.653    -1.026     0.200
     1.682     1.228     0.200
     1.920    -5.407     0.200
     2.530    -9.608     0.200
     1.186     2.840     0.200
     1.914    -4.556     0.200
     2.983    -9.862     0.200
     1.195     2.987     0.200
     1.212     2.962     0.200
     1.650    -0.979     0.200
     1.682     1.366     0.200
     2.538    -9.876     0.200
     2.538   -10.712     0.200
     4.214   -18.880     0.200
     5.562   -28.850     0.200
     6.827   -39.301     0.200
     1.675     1.101     0.200
     1.911    -5.186     0.200
     2.522    -9.883     0.200
     1.356    -0.066     0.200
     1.449     0.474     0.200
     2.532    -9.592     0.200
     3.603   -16.602     0.200
     5.563   -28.284     0.200
     1.432     1.236     0.200
     1.640    -0.698     0.200
     1.736    -0.431     0.200
     1.920    -3.916     0.200
     2.970    -9.049     0.200
     4.297   -22.396     0.200
     1.190     2.744     0.200
     1.640    -1.224     0.200
     1.675    -0.564     0.200
     2.542    -9.544     0.200
     3.563   -17.009     0.200
     4.204   -18.991     0.200
     4.297   -21.683     0.200
     5.561   -29.132     0.200
     1.739    -0.821     0.200
     2.193    -8.836     0.200
     2.524   -10.195     0.200
     2.982   -10.914     0.200
     3.820   -16.930     0.200
     4.029   -18.690     0.200
     4.157   -22.077     0.200
     4.211   -18.981     0.200
     2.218    -7.691     0.200
     1.192     1.319     0.200
     1.759    -0.826     0.200
     2.514    -8.848     0.200
     3.003    -9.995     0.200
     3.610   -13.301     0.200
     3.841   -17.043     0.200
     4.233   -17.879     0.200
     5.263   -23.232     0.200
     5.549   -25.838     0.200
     1.420    -0.309     0.200
     1.503    -0.843     0.200
     1.520    -0.960     0.200
     1.950    -5.631     0.200
     2.498    -9.277     0.200
     5.565   -30.009     0.200
     1.384     0.883     0.200
     1.923    -4.769     0.200
     2.501    -9.020     0.200
     3.024   -12.353     0.200
     3.195   -12.592     0.200
     3.294   -14.253     0.200
     3.338   -15.072     0.200
     4.252   -20.231     0.200
     4.255   -22.773     0.200
     5.547   -27.905     0.200
     6.266   -36.094     0.200
     6.788   -39.399     0.200
     1.927    -6.324     0.200
     2.497    -9.896     0.200
     1.675     1.755     0.200
     1.740    -0.505     0.200
     1.916    -3.869     0.200
     2.201    -7.422     0.200
     2.532   -10.118     0.200
     2.979    -9.621     0.200
     4.210   -18.077     0.200
     5.554   -28.943     0.200
     1.857    -4.038     0.200
     2.438    -7.681     0.200
     2.577    -9.062     0.200
     2.707   -11.031     0.200
     2.746   -12.559     0.200
     3.291   -14.439     0.200
     3.613   -16.465     0.200
    10.936   -70.774     0.200
     0.930     2.842     0.200
     1.229    -0.981     0.200
     1.437    -0.540     0.200
     1.512    -2.519     0.200
     2.347    -8.493     0.200
     2.947    -9.956     0.200
     3.082   -11.862     0.200
     1.000     2.872     0.200
     1.370     0.365     0.200
     1.370     0.654     0.200
     1.691    -2.264     0.200
     2.096    -8.098     0.200
     2.104    -7.594     0.200
     2.616   -11.561     0.200
     2.682    -9.804     0.200
     2.831   -10.923     0.200
     2.831   -11.235     0.200
     2.834   -11.459     0.200
     2.969   -11.963     0.200
     3.529   -15.688     0.200
     3.877   -17.604     0.200
     4.368   -21.956     0.200
     2.424   -10.422     0.200
     2.981   -11.215     0.200
     1.973    -4.682     0.200
     1.975    -4.737     0.200
     2.573    -8.043     0.200
     2.658    -9.673     0.200
     3.128   -10.980     0.200
     3.423   -14.772     0.200
     1.696     0.273     0.200
     1.691    -1.090     0.200
     2.756   -11.181     0.200
     4.510   -23.300     0.200
     5.715   -30.105     0.200
     6.003   -33.139     0.200
     1.149     2.661     0.200
     1.203     1.559     0.200
     1.391     0.018     0.200
     1.391    -0.874     0.200
     1.410    -0.655     0.200
     1.540    -2.593     0.200
     1.569    -2.481     0.200
     1.840    -5.930     0.200
     2.148    -6.682     0.200
     2.471    -9.136     0.200
     2.645   -11.515     0.200
     2.859   -12.156     0.200
     3.311   -15.509     0.200
     3.525   -17.502     0.200
     3.723   -18.159     0.200
     4.513   -22.850     0.200
     1.314     3.516     0.200
     1.416     0.435     0.200
     1.595    -0.304     0.200
     1.614    -1.514     0.200
     1.703    -0.865     0.200
     2.743   -10.046     0.200
     4.837   -26.910     0.200
     6.884   -39.766     0.200
     1.089     2.584     0.200
     1.305     2.358     0.200
     1.304     2.685     0.200
     1.408     0.708     0.200
     1.599    -0.229     0.200
     2.331    -7.386     0.200
     1.307     0.926     0.200
     1.704    -3.185     0.200
     1.999    -5.537     0.200
     2.374    -8.513     0.200
     3.251   -12.489     0.200
     1.251     1.462     0.200
     1.427     0.199     0.200
     1.618    -0.368     0.200
     1.922    -6.388     0.200
     2.220    -7.227     0.200
     2.336    -7.457     0.200
     3.910   -18.038     0.200
     4.091   -22.752     0.200
     4.466   -22.563     0.200
     1.093     2.900     0.200
     1.254     1.468     0.200
     1.548    -0.705     0.200
     2.307    -7.537     0.200
     2.958    -9.871     0.200
     1.078     1.604     0.200
     1.554    -1.710     0.200
     2.315    -8.519     0.200
     2.958    -9.771     0.200
     3.548   -15.692     0.200
     4.069   -20.941     0.200
    14.464   -94.257     0.200
     1.103     2.337     0.200
     2.963   -10.402     0.200
     1.314     2.466     0.200
     1.450     0.804     0.200
     1.526     1.318     0.200
     1.588     0.071     0.200
     2.390    -7.398     0.200
     2.409    -6.201     0.200
     2.757   -11.097     0.200
     1.045    -0.520     0.200
     1.158    -0.224     0.200
     1.577    -2.942     0.200
     1.680    -5.247     0.200
     1.680    -5.032     0.200
     2.262    -9.781     0.200
     2.436    -9.019     0.200
     2.886   -13.792     0.200
     2.886   -13.199     0.200
     3.141   -13.323     0.200
     3.411   -16.881     0.200
     0.935     2.374     0.200
     1.470     0.046     0.200
     1.921    -6.162     0.200
     3.828   -21.263     0.200
     1.089     1.334     0.200
     1.242    -0.221     0.200
     1.242    -0.115     0.200
     1.297     0.776     0.200
     1.616    -2.424     0.200
     1.764    -4.675     0.200
     2.291    -7.706     0.200
     2.452    -8.976     0.200
     1.311     0.900     0.200
     1.311     2.721     0.200
     3.009   -12.220     0.200
     4.100   -17.888     0.200
     0.890     1.882     0.200
     0.953     0.845     0.200
     0.953     1.204     0.200
     1.145     1.455     0.200
     1.216    -0.749     0.200
     1.287     0.626     0.200
     0.903     3.318     0.200
     1.069     1.809     0.200
     1.195     1.142     0.200
     1.241     1.168     0.200
     1.278     1.599     0.200
     1.298     1.385     0.200
     1.318    -1.060     0.200
     1.354    -0.185     0.200
     1.385     0.492     0.200
     1.438    -1.353     0.200
     1.496    -1.070     0.200
     1.537    -1.819     0.200
     1.633    -2.347     0.200
     2.402    -9.310     0.200
     2.402    -9.668     0.200
     3.005   -11.732     0.200
     0.975     3.627     0.200
     1.198     1.513     0.200
     1.260     0.142     0.200
     1.367     1.379     0.200
     1.427     2.187     0.200
     1.434     2.167     0.200
     1.561     0.284     0.200
     1.665    -0.463     0.200
     1.665     0.330     0.200
     0.959     1.514     0.200
     1.022     1.988     0.200
     1.079     2.030     0.200
     1.148     0.135     0.200
     1.626    -2.575     0.200
     2.442   -10.660     0.200
     2.442   -10.261     0.200
     0.923     1.736     0.200
     0.944     1.625     0.200
     1.225     2.170     0.200
     1.277     0.388     0.200
     1.316     0.232     0.200
     1.326    -0.622     0.200
     1.380    -0.235     0.200
     1.415     0.262     0.200
     1.415     0.770     0.200
     1.427     1.010     0.200
     1.513    -0.680     0.200
     1.540    -1.549     0.200
     1.555    -0.848     0.200
     2.435    -8.130     0.200
     2.864   -10.056     0.200
     3.714   -15.361     0.200
     4.759   -26.584     0.200
     5.249   -25.835     0.200
     5.328   -26.499     0.200
     0.914     1.838     0.200
     0.959     3.727     0.200
     1.119     0.627     0.200
     1.127     0.050     0.200
     1.427     0.733     0.200
     1.452    -1.275     0.200
     1.521    -1.482     0.200
     1.521    -1.244     0.200
     2.446    -9.368     0.200
     0.917     1.898     0.200
     0.962     1.343     0.200
     1.129     0.585     0.200
     1.151    -0.479     0.200
     1.177     0.705     0.200
     1.392    -0.091     0.200
     1.429     0.172     0.200
     1.641    -2.800     0.200
     2.449    -9.255     0.200
     0.960     2.311     0.200
     1.121     1.694     0.200
     1.151    -0.435     0.200
     1.238     1.334     0.200
     1.392    -0.195     0.200
     1.428     0.307     0.200
     1.643    -2.515     0.200
     2.446   -10.071     0.200
     0.921     2.079     0.200
     0.982     0.401     0.200
     1.219     0.298     0.200
     1.245    -0.842     0.200
     1.306    -0.272     0.200
     1.319    -1.496     0.200
     1.394    -2.250     0.200
     2.667   -12.205     0.200
     2.725   -12.407     0.200
    10.755   -62.976     0.200
     1.406     0.656     0.200
     1.463     0.126     0.200
     1.465     0.065     0.200
     1.465    -0.341     0.200
     1.554    -0.887     0.200
     1.617    -0.655     0.200
     1.645     1.457     0.200
     2.312    -8.647     0.200
     1.119     2.261     0.200
     2.341   -10.658     0.200
     5.408   -27.418     0.200
     0.977     2.431     0.200
     1.025     1.362     0.200
     1.025     3.349     0.200
     1.322     1.179     0.200
     1.330     0.614     0.200
     2.199    -8.523     0.200
     2.552    -8.172     0.200
     2.724   -13.745     0.200
     3.760   -16.984     0.200
     1.101     2.819     0.200
     1.620    -0.617     0.200
     0.999     3.270     0.200
     1.126     0.682     0.200
     2.425    -9.275     0.200
     2.873   -12.295     0.200
     2.706   -12.024     0.200
     2.617    -6.962     0.200
     3.258   -13.266     0.200
     4.069   -20.241     0.200
     4.438   -22.234     0.200
     6.945   -40.725     0.200
     1.367     0.991     0.200
     1.596    -0.519     0.200
     2.393    -9.032     0.200
     0.806     2.439     0.200
     0.806     3.341     0.200
     0.919     1.156     0.200
     0.919     1.335     0.200
     1.189     0.358     0.200
     1.418    -2.285     0.200
     1.423    -2.291     0.200
     1.422    -2.338     0.200
     1.494    -3.011     0.200
     0.748     0.826     0.200
     0.748     1.061     0.200
     0.879    -0.275     0.200
     0.904    -0.024     0.200
     0.904     0.913     0.200
     0.907     2.504     0.200
     0.907     0.175     0.200
     0.920     0.188     0.200
     0.965     0.832     0.200
     0.985     0.495     0.200
     1.002     0.972     0.200
     1.024     0.902     0.200
     1.049    -1.174     0.200
     1.112     1.117     0.200
     1.119    -0.952     0.200
     1.117     0.114     0.200
     1.126     0.304     0.200
     1.162    -1.018     0.200
     1.192    -0.419     0.200
     1.192    -0.762     0.200
     1.506    -4.817     0.200
     1.646    -5.849     0.200
     1.947    -7.201     0.200
     2.574   -10.573     0.200
     2.764   -14.771     0.200
     2.764   -13.615     0.200
     1.057     3.376     0.200
     1.144     2.610     0.200
     1.144     3.930     0.200
     1.150     3.122     0.200
     1.288     2.032     0.200
     1.366     2.678     0.200
     1.421    -0.029     0.200
     1.468    -0.077     0.200
     1.468     0.151     0.200
     1.544    -0.188     0.200
     0.930     0.951     0.200
     0.957     1.238     0.200
     0.979     0.545     0.200
     1.000     1.530     0.200
     1.006     0.997     0.200
     1.007     2.130     0.200
     1.094     1.197     0.200
     1.146     1.244     0.200
     1.170    -0.112     0.200
     1.170    -0.601     0.200
     1.236     0.120     0.200
     1.236     0.950     0.200
     1.343    -0.844     0.200
     1.334     1.342     0.200
     1.650    -3.896     0.200
     1.929    -5.145     0.200
     2.377    -8.039     0.200
     2.520    -9.913     0.200
     2.806   -12.219     0.200
     2.806   -14.581     0.200
     0.978     2.097     0.200
     0.999     1.958     0.200
     1.006     1.050     0.200
     1.094     1.562     0.200
     1.170    -0.209     0.200
     1.199     1.699     0.200
     1.236    -1.127     0.200
     1.314    -1.428     0.200
     1.343    -1.534     0.200
     1.346     0.946     0.200
     1.394    -0.439     0.200
     1.650    -2.700     0.200
     1.675    -2.862     0.200
     0.833     2.290     0.200
     1.042    -0.366     0.200
     1.042     2.044     0.200
     1.002     1.677     0.200
     1.051     0.226     0.200
     1.050    -0.042     0.200
     1.050     2.028     0.200
     1.060     0.374     0.200
     1.077    -0.637     0.200
     1.077     0.334     0.200
     1.122     1.487     0.200
     1.200    -0.698     0.200
     1.269    -0.563     0.200
     1.320    -1.234     0.200
     2.747   -13.785     0.200
     1.042     0.673     0.200
     1.191     1.451     0.200
     1.207     0.882     0.200
     1.207     1.022     0.200
     1.207     1.788     0.200
     1.347    -0.607     0.200
     1.396    -1.141     0.200
     2.531   -11.488     0.200
     2.531   -10.504     0.200
     2.976   -10.049     0.200
     3.820   -17.262     0.200
     4.285   -22.661     0.200
     4.285   -23.185     0.200
     0.879     0.495     0.200
     0.989     0.949     0.200
     1.071     1.965     0.200
     1.072     1.559     0.200
     1.203    -0.670     0.200
     1.219    -0.464     0.200
     1.219     0.296     0.200
     1.219     0.466     0.200
     1.040     1.805     0.200
     1.055    -0.146     0.200
     1.114     0.989     0.200
     1.162     0.399     0.200
     1.209    -0.929     0.200
     1.252     0.459     0.200
     1.271    -1.311     0.200
     1.268    -0.605     0.200
     1.336    -0.751     0.200
     0.962     1.290     0.200
     0.962     1.284     0.200
     0.977     1.948     0.200
     1.050     1.534     0.200
     1.124     0.062     0.200
     1.258    -1.135     0.200
     1.284    -1.185     0.200
     1.284     0.916     0.200
     1.296    -0.864     0.200
     1.346    -0.243     0.200
     1.421    -1.569     0.200
     0.906     2.138     0.200
     0.943     2.386     0.200
     1.057     2.070     0.200
     1.082     1.611     0.200
     1.139     0.657     0.200
     1.223     0.164     0.200
     1.286    -0.389     0.200
     1.323    -0.225     0.200
     1.323     0.275     0.200
     1.371    -1.445     0.200
     1.675    -2.776     0.200
     2.053    -7.909     0.200
     2.576   -11.562     0.200
     2.576   -13.617     0.200
     2.685    -9.620     0.200
     3.232   -12.527     0.200
     3.535   -16.830     0.200
     2.308    -9.590     0.200
     2.308    -9.395     0.200
     3.446   -14.498     0.200
     0.974     2.412     0.200
     0.995     1.992     0.200
     1.002     1.079     0.200
     1.002     2.380     0.200
     1.005     1.724     0.200
     1.085     0.588     0.200
     1.089     2.098     0.200
     1.097     2.149     0.200
     1.165     0.046     0.200
     1.185     1.728     0.200
     1.240     0.573     0.200
     1.240     1.022     0.200
     1.327     1.384     0.200
     1.340    -1.153     0.200
     1.390     0.340     0.200
     1.465    -0.910     0.200
     1.649    -2.959     0.200
     1.924    -5.286     0.200
     2.378    -7.720     0.200
     2.520    -9.962     0.200
     2.803   -12.175     0.200
     2.803   -12.964     0.200
     3.023   -10.566     0.200
     3.230   -13.376     0.200
     3.561   -16.732     0.200
     4.542   -25.969     0.200
     1.114     1.794     0.200
     1.148     1.673     0.200
     1.188     1.650     0.200
     1.239     1.157     0.200
     1.475    -0.768     0.200
     1.475    -0.658     0.200
     0.839     2.878     0.200
     0.866     1.151     0.200
     0.938     0.971     0.200
     0.955     1.447     0.200
     0.978     0.416     0.200
     0.986     1.660     0.200
     0.987     2.050     0.200
     1.019     1.152     0.200
     1.080    -0.300     0.200
     1.080    -0.609     0.200
     1.081     0.169     0.200
     1.109    -0.720     0.200
     1.148    -0.540     0.200
     1.148     0.430     0.200
     1.653    -5.435     0.200
     1.845    -6.684     0.200
     2.315    -9.787     0.200
     2.950   -13.614     0.200
     3.360   -16.635     0.200
     0.944     2.237     0.200
     1.323    -0.852     0.200
     1.411    -1.509     0.200
     1.769    -4.234     0.200
     2.095    -5.496     0.200
     2.657    -9.454     0.200
     2.762    -8.883     0.200
     3.411   -13.742     0.200
     0.943     1.787     0.200
     0.948     2.963     0.200
     1.004     1.691     0.200
     1.014     2.067     0.200
     1.087     2.444     0.200
     1.208     0.180     0.200
     1.343    -0.431     0.200
     1.389    -0.773     0.200
     1.419    -1.037     0.200
     1.448    -0.159     0.200
     1.445    -1.106     0.200
     1.466    -0.430     0.200
     1.769    -4.436     0.200
     2.092    -6.263     0.200
     2.556    -9.678     0.200
     2.544    -9.595     0.200
     2.650    -9.479     0.200
     0.948     2.663     0.200
     1.004     2.491     0.200
     1.014     2.634     0.200
     1.207    -0.229     0.200
     1.205     1.950     0.200
     1.447    -0.127     0.200
     1.465    -0.241     0.200
     0.889     2.710     0.200
     0.945     3.042     0.200
     0.930     2.400     0.200
     0.988     1.254     0.200
     1.027     2.956     0.200
     1.158     0.193     0.200
     1.230     1.287     0.200
     1.010     1.770     0.200
     1.021     2.103     0.200
     1.152     2.083     0.200
     1.217     0.458     0.200
     1.320    -0.876     0.200
     1.320     2.624     0.200
     1.353     0.101     0.200
     1.428    -0.721     0.200
     1.454    -0.806     0.200
     1.476    -0.646     0.200
     1.007     2.779     0.200
     1.204     0.386     0.200
     1.336     0.273     0.200
     1.336     0.523     0.200
     0.965     0.492     0.200
     0.983     0.897     0.200
     0.983     1.299     0.200
     1.163     2.195     0.200
     1.184     0.955     0.200
     1.288    -0.314     0.200
     1.276    -0.583     0.200
     1.307     2.006     0.200
     1.319     1.724     0.200
     1.327     1.424     0.200
     1.349    -1.328     0.200
     1.342     1.546     0.200
     1.342     1.757     0.200
     1.348     1.704     0.200
     1.389    -1.500     0.200
     1.389    -1.360     0.200
     1.389    -0.192     0.200
     1.381    -1.288     0.200
     1.370     1.938     0.200
     4.998   -25.811     0.200
     5.414   -29.794     0.200
     6.722   -34.714     0.200
     9.242   -55.756     0.200
     0.998    -0.282     0.200
     1.086     1.797     0.200
     1.099     0.723     0.200
     1.092     1.365     0.200
     1.103     2.153     0.200
     1.177     0.623     0.200
     1.186     0.963     0.200
     1.239     1.812     0.200
     1.260    -0.324     0.200
     1.283     1.511     0.200
     1.293    -0.220     0.200
     1.339    -1.560     0.200
     1.351    -1.129     0.200
     1.013     1.950     0.200
     1.033     2.853     0.200
     1.076     0.728     0.200
     1.099     1.966     0.200
     0.947     3.575     0.200
     0.967     1.574     0.200
     1.026     3.002     0.200
     1.079     2.575     0.200
     1.130     2.506     0.200
     1.163     2.863     0.200
     1.250     1.169     0.200
     1.573    -0.191     0.200
     4.744   -26.497     0.200
     5.336   -25.361     0.200
     5.479   -27.596     0.200
     8.409   -45.161     0.200
     8.749   -50.937     0.200
     8.738   -47.918     0.200
     0.951     2.667     0.200
     0.951     3.538     0.200
     0.961     4.386     0.200
     1.123     3.217     0.200
     1.133     1.560     0.200
     1.156     2.866     0.200
     1.243     2.463     0.200
     1.277     1.272     0.200
     1.333     2.264     0.200
     1.340    -0.129     0.200
     1.397     1.158     0.200
     1.552    -0.972     0.200
     1.566    -0.424     0.200
     3.125    -9.080     0.200
     4.192   -21.640     0.200
     5.485   -27.918     0.200
     7.875   -44.004     0.200
     8.261   -46.541     0.200
     8.407   -44.354     0.200
     8.739   -51.399     0.200
     8.757   -49.324     0.200
     9.736   -54.947     0.200
     9.824   -55.417     0.200
     1.086     2.130     0.200
     1.134     2.442     0.200
     1.142     0.876     0.200
     1.166     2.400     0.200
     1.210     0.017     0.200
     1.210     1.991     0.200
     1.252     1.533     0.200
     1.343    -0.705     0.200
     1.567    -0.311     0.200
     3.121   -12.656     0.200
     1.344     2.175     0.200
     0.882     2.454     0.200
     0.888     2.393     0.200
     0.936     1.364     0.200
     0.937     1.682     0.200
     0.957     0.965     0.200
     0.966     0.575     0.200
     0.965     1.989     0.200
     0.985     0.249     0.200
     1.097    -0.187     0.200
     1.148     1.816     0.200
     1.157    -0.501     0.200
     1.181     1.842     0.200
     1.225    -0.973     0.200
     1.224     1.649     0.200
     1.267     0.812     0.200
     1.319     2.159     0.200
     1.357    -1.269     0.200
     1.358     1.784     0.200
     1.360     1.680     0.200
     1.376     1.855     0.200
     1.407     1.554     0.200
     1.421    -0.155     0.200
     1.478    -2.068     0.200
     0.897     1.750     0.200
     0.943     2.581     0.200
     1.151     2.172     0.200
     1.158     0.406     0.200
     1.286    -0.844     0.200
     1.352    -0.935     0.200
     1.135    -0.156     0.200
     1.195     0.485     0.200
     1.347    -1.055     0.200
     0.947     1.643     0.200
     1.024     0.883     0.200
     0.870     2.198     0.200
     0.919     2.768     0.200
     0.890     2.578     0.200
     0.917     2.376     0.200
     0.936     2.663     0.200
     0.959     1.079     0.200
     1.078     1.949     0.200
     1.118     1.203     0.200
     1.247    -0.887     0.200
     1.312    -1.021     0.200
     4.218   -24.357     0.200
     1.082     2.286     0.200
     1.391     2.223     0.200
     1.466    -0.838     0.200
     0.978     1.142     0.200
     1.053     0.820     0.200
     0.928     2.310     0.200
     1.140     2.216     0.200
     1.150     0.186     0.200
     1.172    -0.235     0.200
     1.199     1.039     0.200
     1.219    -0.418     0.200
     1.216     2.083     0.200
     1.249     2.603     0.200
     1.309    -0.795     0.200
     1.311     1.866     0.200
     1.353    -1.045     0.200
     1.353    -0.985     0.200
     1.475    -1.348     0.200
     1.865    -4.545     0.200
     4.196   -21.706     0.200
     0.829     0.714     0.200
     1.086     1.140     0.200
     1.018    -0.133     0.200
     1.273    -0.782     0.200
     1.294    -0.943     0.200
     1.294    -1.650     0.200
     0.889     2.794     0.200
     0.959     2.111     0.200
     1.189     1.313     0.200
     1.280    -0.847     0.200
     1.302    -0.326     0.200
     1.345    -0.679     0.200
     4.207   -23.697     0.200
     1.047     2.458     0.200
     1.199     2.052     0.200
     1.282     0.028     0.200
     1.319    -0.106     0.200
     1.328    -0.028     0.200
     1.366     1.783     0.200
     1.382     0.857     0.200
     1.451    -0.675     0.200
     1.451     0.194     0.200
     1.003     3.665     0.200
     1.025     3.184     0.200
     1.058     2.867     0.200
     1.156     1.881     0.200
     1.187     0.774     0.200
     1.180     2.322     0.200
     1.189     0.901     0.200
     1.261     1.182     0.200
     0.988     2.879     0.200
     0.988     1.582     0.200
     1.169    -0.266     0.200
     1.240    -0.960     0.200
     1.300     0.363     0.200
     1.331    -0.869     0.200
     1.375    -1.322     0.200
     1.370    -1.250     0.200
     1.369     1.109     0.200
     1.363     1.550     0.200
     1.385     1.191     0.200
     1.417     1.316     0.200
     1.434    -0.538     0.200
     0.989     4.203     0.200
     0.957     2.157     0.200
     1.137     1.377     0.200
     1.177     2.358     0.200
     1.235     0.654     0.200
     1.358    -0.073     0.200
     0.939     1.580     0.200
     0.964     1.713     0.200
     0.982     1.580     0.200
     0.982     2.170     0.200
     1.289    -0.978     0.200
     1.289    -0.357     0.200
     1.289     0.242     0.200
     1.311    -0.694     0.200
     1.354    -0.948     0.200
     1.475    -1.535     0.200
     1.025     1.451     0.200
     1.040     2.168     0.200
     1.048     0.531     0.200
     1.048     1.431     0.200
     1.127     2.272     0.200
     1.144     0.870     0.200
     1.223    -0.396     0.200
     1.278    -0.678     0.200
     1.266     1.392     0.200
     1.347     2.027     0.200
     1.391    -1.207     0.200
     1.444    -0.992     0.200
     1.564    -0.954     0.200
     0.896     1.160     0.200
     0.924     2.139     0.200
     0.991     2.966     0.200
     1.031     2.697     0.200
     1.039     0.421     0.200
     1.058     1.509     0.200
     1.128     0.130     0.200
     1.178     1.182     0.200
     1.236    -0.467     0.200
     1.288     1.796     0.200
     1.303     0.250     0.200
     1.293     0.164     0.200
     1.332    -0.120     0.200
     0.987     2.682     0.200
     1.028     2.233     0.200
     1.177     2.538     0.200
     1.235     0.518     0.200
     1.288     0.281     0.200
     1.317     1.882     0.200
     1.359    -0.070     0.200
     1.350     2.987     0.200
     1.418     2.197     0.200
     1.430     1.309     0.200
     1.455     2.204     0.200
     1.476     0.290     0.200
     1.495    -1.086     0.200
     1.524     1.014     0.200
     1.546    -0.998     0.200
     1.546    -0.898     0.200
     1.673    -1.010     0.200
     0.988     0.882     0.200
     0.985     0.795     0.200
     0.985     2.225     0.200
     1.069     0.414     0.200
     1.093    -0.006     0.200
     1.238    -0.752     0.200
     1.280    -1.048     0.200
     1.281    -0.817     0.200
     1.283    -0.248     0.200
     0.781     0.745     0.200
     0.781     1.844     0.200
     0.927     0.987     0.200
     0.973     2.294     0.200
     1.000    -0.089     0.200
     1.084     1.806     0.200
     1.053     1.255     0.200
     1.190    -1.387     0.200
     1.314     1.484     0.200
     1.674    -4.603     0.200
     4.426   -22.620     0.200
     6.955   -40.440     0.200
     1.180     0.769     0.200
     1.415     0.098     0.200
     1.579    -1.119     0.200
     1.579    -1.289     0.200
     4.661   -21.930     0.200
     0.934     1.347     0.200
     1.083     1.117     0.200
     1.083     2.486     0.200
     1.276    -0.432     0.200
     1.311     0.255     0.200
     1.381    -0.396     0.200
     1.489    -1.363     0.200
     1.503    -1.215     0.200
     1.583    -1.581     0.200
     1.587    -1.568     0.200
     0.897     3.183     0.200
     1.058     1.252     0.200
     1.087     0.360     0.200
     1.086     1.986     0.200
     1.086     0.357     0.200
     1.148     0.127     0.200
     1.152     0.524     0.200
     1.218    -0.324     0.200
     1.281    -0.808     0.200
     1.385     0.443     0.200
     1.402    -1.327     0.200
     1.476    -0.603     0.200
     1.494    -1.222     0.200
     1.508    -1.292     0.200
     1.757    -5.650     0.200
     3.183   -12.506     0.200
     5.177   -27.308     0.200
     1.070     3.608     0.200
     1.072     1.714     0.200
     1.175     3.402     0.200
     1.240     3.370     0.200
     1.241     0.900     0.200
     1.370     1.259     0.200
     1.487    -0.803     0.200
     1.502     0.750     0.200
     1.584    -1.026     0.200
     1.584    -0.677     0.200
     1.635    -0.680     0.200
     1.649    -1.180     0.200
     1.688     1.256     0.200
     1.754    -2.032     0.200
     3.193   -12.194     0.200
     4.214   -23.101     0.200
     1.772    -2.116     0.200
     1.084     2.815     0.200
     1.276     0.117     0.200
     1.396    -0.454     0.200
     1.311     2.209     0.200
     1.338     2.326     0.200
     1.382     0.933     0.200
     1.458    -0.869     0.200
     1.488    -1.089     0.200
     1.562    -0.756     0.200
     0.890     2.630     0.200
     0.977     0.889     0.200
     0.973     3.276     0.200
     0.973     1.846     0.200
     1.225    -0.462     0.200
     0.986     3.244     0.200
     0.927     2.757     0.200
     0.950     3.052     0.200
     1.104     1.338     0.200
     1.150     1.004     0.200
     1.242     0.448     0.200
     1.303    -0.406     0.200
     1.368     0.163     0.200
     1.423    -1.219     0.200
     1.486    -1.389     0.200
     1.498    -0.008     0.200
     1.515    -1.757     0.200
     1.515    -1.488     0.200
     1.529    -0.482     0.200
     4.216   -18.306     0.200
     4.787   -25.488     0.200
     5.372   -26.333     0.200
     0.923     2.185     0.200
     0.945     1.787     0.200
     1.065     1.989     0.200
     0.993     2.047     0.200
     0.993     2.496     0.200
     0.995     1.053     0.200
     1.304     0.253     0.200
     1.405    -0.293     0.200
     1.405    -0.715     0.200
     1.490    -0.932     0.200
     1.490    -1.092     0.200
     0.978     2.649     0.200
     1.149     1.426     0.200
     1.412     0.992     0.200
     1.522    -0.108     0.200
     1.531    -0.917     0.200
     1.608    -0.108     0.200
     1.635    -0.825     0.200
     1.658    -1.672     0.200
     0.900     0.165     0.200
     0.916     2.476     0.200
     0.978     0.120     0.200
     0.979    -0.301     0.200
     1.000     0.634     0.200
     0.996     0.164     0.200
     0.996    -0.336     0.200
     1.002    -0.587     0.200
     1.081     0.182     0.200
     1.111    -0.249     0.200
     1.113     0.214     0.200
     1.143    -0.536     0.200
     1.263    -0.907     0.200
     1.258    -1.309     0.200
     1.322    -2.083     0.200
     1.056     2.439     0.200
     1.354     0.009     0.200
     1.519    -1.156     0.200
     1.975    -7.235     0.200
     2.289    -8.962     0.200
     0.923     1.858     0.200
     0.977     2.709     0.200
     1.056     3.178     0.200
     1.524    -1.613     0.200
     4.038   -20.030     0.200
     6.456   -39.262     0.200
     0.995     2.991     0.200
     0.995     3.374     0.200
     1.123     0.987     0.200
     1.256     0.380     0.200
     1.368    -0.266     0.200
     1.401     0.027     0.200
     1.401     1.238     0.200
     1.453     1.605     0.200
     1.479    -0.620     0.200
     1.487    -0.950     0.200
     1.532    -0.973     0.200
     1.541     0.872     0.200
     1.542    -0.773     0.200
     1.542    -1.164     0.200
     1.667    -2.132     0.200
     1.923    -5.942     0.200
     0.939     2.929     0.200
     1.060     1.482     0.200
     1.323    -0.919     0.200
     1.508    -1.174     0.200
     0.927     2.844     0.200
     0.978     2.549     0.200
     0.978     1.627     0.200
     1.044     1.829     0.200
     1.046     1.221     0.200
     1.086     0.785     0.200
     1.148     3.000     0.200
     1.163     1.155     0.200
     1.188     0.204     0.200
     1.222     1.819     0.200
     1.312     0.350     0.200
     1.376    -0.868     0.200
     1.497    -1.025     0.200
     1.497    -0.904     0.200
     1.588    -1.742     0.200
     4.177   -20.912     0.200
     0.982     3.231     0.200
     1.499    -0.950     0.200
     0.983     2.752     0.200
     1.335    -0.716     0.200
     1.523     0.179     0.200
     0.940     2.192     0.200
     0.991     2.670     0.200
     1.442     1.657     0.200
     1.532    -0.406     0.200
     1.501    -1.182     0.200
     1.591    -1.121     0.200
     1.331    -0.728     0.200
     1.365     2.304     0.200
     1.369    -0.775     0.200
     1.377    -0.564     0.200
     1.499    -0.933     0.200
     1.695     0.041     0.200
     1.494    -0.601     0.200
     1.494    -0.710     0.200
     1.676    -0.869     0.200
     0.928     2.197     0.200
     0.939     2.568     0.200
     0.962     2.755     0.200
     0.979     1.391     0.200
     0.979     1.239     0.200
     1.046     1.231     0.200
     1.087     0.387     0.200
     1.148     2.176     0.200
     1.162     0.050     0.200
     1.221     0.760     0.200
     1.311    -0.672     0.200
     0.931     2.802     0.200
     0.983     2.603     0.200
     0.983     3.064     0.200
     1.153     2.197     0.200
     1.168     0.375     0.200
     1.382    -1.034     0.200
     1.594    -2.046     0.200
     1.683    -2.506     0.200
     0.929     1.434     0.200
     0.987     3.239     0.200
     0.987     1.028     0.200
     0.998     2.258     0.200
     0.998     3.838     0.200
     1.232     0.791     0.200
     1.248    -0.532     0.200
     1.271     2.516     0.200
     1.284     2.062     0.200
     1.322     0.140     0.200
     1.322     0.271     0.200
     1.340    -0.737     0.200
     1.361     1.867     0.200
     1.374     1.901     0.200
     1.378    -0.901     0.200
     1.385    -0.870     0.200
     1.386    -1.053     0.200
     1.386    -0.303     0.200
     1.387     2.045     0.200
     1.420     1.760     0.200
     1.440    -0.013     0.200
     1.474     0.075     0.200
     1.497     1.071     0.200
     1.506    -1.220     0.200
     1.507    -1.452     0.200
     1.557    -0.969     0.200
     1.568    -1.558     0.200
     2.259    -6.137     0.200
     4.177   -21.039     0.200
     4.709   -23.134     0.200
     5.073   -25.127     0.200
     5.308   -25.817     0.200
     5.441   -28.630     0.200
     6.640   -42.147     0.200
     7.833   -48.603     0.200
     0.984     2.268     0.200
     0.964     2.979     0.200
     0.964     3.128     0.200
     1.306    -0.696     0.200
     1.450    -0.544     0.200
     0.987     2.572     0.200
     0.987     4.303     0.200
     1.160     2.925     0.200
     2.248    -8.761     0.200
     1.021     1.053     0.200
     1.021     2.373     0.200
     0.929     2.689     0.200
     0.979     1.837     0.200
     0.979     2.376     0.200
     1.045     0.699     0.200
     1.427    -1.129     0.200
     1.492    -1.393     0.200
     0.921     3.117     0.200
     0.954     3.378     0.200
     0.971     2.516     0.200
     0.971     2.636     0.200
     0.986     3.922     0.200
     1.178    -0.022     0.200
     1.213     0.853     0.200
     1.366    -0.908     0.200
     1.487    -1.253     0.200
     0.970     1.121     0.200
     1.036     3.131     0.200
     1.213     1.166     0.200
     1.668    -1.759     0.200
     2.427    -8.312     0.200
     0.929     2.646     0.200
     0.979     2.080     0.200
     0.979     1.057     0.200
     1.488    -1.681     0.200
     0.970     2.300     0.200
     1.146     0.962     0.200
     0.981     2.128     0.200
     0.981     3.558     0.200
     1.498    -0.926     0.200
     0.935     2.478     0.200
     0.986     2.207     0.200
     1.333    -0.646     0.200
     1.499    -1.514     0.200
     0.927     2.747     0.200
     0.977     2.355     0.200
     0.977     2.547     0.200
     1.043     0.743     0.200
     1.491    -1.165     0.200
     0.924     2.921     0.200
     1.876    -4.048     0.200
     1.895    -4.235     0.200
     0.924     2.364     0.200
     0.974     1.322     0.200
     0.974     1.662     0.200
     1.040     2.957     0.200
     1.005     1.926     0.200
     1.019     0.416     0.200
     1.074     0.131     0.200
     1.074    -0.408     0.200
     1.073     1.163     0.200
     1.073    -0.013     0.200
     1.073     0.151     0.200
     1.169     0.329     0.200
     1.172    -0.800     0.200
     1.203    -0.417     0.200
     1.260    -0.835     0.200
     1.266     0.168     0.200
     1.273    -1.249     0.200
     1.328    -1.408     0.200
     1.354    -1.534     0.200
     1.371    -1.402     0.200
     1.371    -1.722     0.200
     1.393    -1.773     0.200
     1.691    -4.987     0.200
     1.770    -4.174     0.200
     1.895    -6.693     0.200
     1.971    -7.068     0.200
     2.009    -5.433     0.200
     2.078    -5.817     0.200
     0.961     2.912     0.200
     0.935     1.285     0.200
     1.493    -1.147     0.200
     2.021    -7.462     0.200
     0.979     2.195     0.200
     1.081     2.161     0.200
     0.972     2.974     0.200
     0.963     1.110     0.200
     0.999     2.017     0.200
     1.265     1.359     0.200
     1.378    -0.749     0.200
     1.346     1.836     0.200
     1.569    -0.712     0.200
     1.615    -2.217     0.200
     1.094     0.623     0.200
     1.107     0.931     0.200
     1.153     0.319     0.200
     1.160     1.399     0.200
     1.238     0.558     0.200
     1.230    -0.807     0.200
     1.222    -0.620     0.200
     1.315    -0.958     0.200
     1.240     2.218     0.200
     1.326     0.090     0.200
     1.363    -0.906     0.200
     1.430    -1.414     0.200
     1.478    -1.593     0.200
     1.414     1.465     0.200
     0.951     2.689     0.200
     0.968     2.768     0.200
     0.971     1.014     0.200
     0.983     1.723     0.200
     1.209     1.312     0.200
     1.298     0.131     0.200
     1.361     0.251     0.200
     1.482    -1.443     0.200
     1.574    -1.347     0.200
     1.027     3.312     0.200
     1.204     1.384     0.200
     1.476    -1.144     0.200
     1.557    -0.887     0.200
     1.035     0.729     0.200
     1.151    -0.097     0.200
     1.316    -0.961     0.200
     1.362    -0.946     0.200
     1.363    -1.076     0.200
     1.546    -1.664     0.200
     0.984     0.655     0.200
     1.060     0.145     0.200
     1.187    -0.553     0.200
     1.207    -0.033     0.200
     1.274     0.278     0.200
     1.277    -0.330     0.200
     1.291    -0.712     0.200
     1.304    -1.008     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.267     1.218     0.200
     0.781    -0.180     0.200
     0.835    -0.115     0.200
     0.881     0.070     0.200
     0.949    -0.844     0.200
     0.989     0.415     0.200
     0.733     1.148     0.200
     1.007    -0.045     0.200
     1.076     0.999     0.200
     1.094     0.635     0.200
     1.102     0.381     0.200
     1.391    -0.348     0.200
     0.709     1.123     0.200
     0.825     0.497     0.200
     0.936     0.813     0.200
     0.991    -0.187     0.200
     1.070    -0.064     0.200
     1.084    -0.254     0.200
     1.092     0.353     0.200
     1.373    -0.620     0.200
     0.193     1.084     0.200
     0.618     0.835     0.200
     0.782     0.702     0.200
     0.802     0.856     0.200
     0.803     0.808     0.200
     0.868     1.228     0.200
     0.906     0.568     0.200
     0.783     1.158     0.200
     0.975     0.825     0.200
     1.050     0.802     0.200
     1.111     1.116     0.200
     1.133     0.900     0.200
     1.141     0.654     0.200
     0.569     0.892     0.200
     0.448     1.306     0.200
     0.819     0.233     0.200
     0.874     0.059     0.200
     0.967    -0.108     0.200
     0.990    -0.465     0.200
     0.398     0.922     0.200
     0.398     0.802     0.200
     0.394     0.939     0.200
     0.607     0.325     0.200
     0.607     1.336     0.200
     0.809     0.688     0.200
     1.019     0.177     0.200
     1.664    -3.951     0.200
     4.564    -8.318     0.200
     5.825   -11.954     0.200
     0.311     1.397     0.200
     0.316     0.936     0.200
     0.316     0.796     0.200
     0.573     1.093     0.200
     2.427    -6.204     0.200
     0.343     0.925     0.200
     0.277     2.392     0.200
     0.372    -0.001     0.200
     0.372     1.741     0.200
     0.423     0.200     0.200
     0.423     1.439     0.200
     0.423     1.611     0.200
     0.622     0.576     0.200
     1.006    -0.064     0.200
     1.810    -2.520     0.200
     0.686     0.788     0.200
     0.777     0.819     0.200
     0.814     0.881     0.200
     0.855     0.493     0.200
     0.970     0.148     0.200
     1.257    -0.266     0.200
     1.256    -0.348     0.200
     1.664    -4.122     0.200
     2.165    -2.965     0.200
     3.075    -5.467     0.200
     0.256     1.677     0.200
     0.375     0.831     0.200
     0.428     0.980     0.200
     0.467     0.687     0.200
     0.467     1.754     0.200
     0.681     0.696     0.200
     1.715    -4.563     0.200
     1.852    -2.950     0.200
     2.913    -5.666     0.200
     0.313     1.310     0.200
     0.555     1.126     0.200
     0.824     0.454     0.200
     0.910     0.495     0.200
     0.885    -0.117     0.200
     1.074    -0.310     0.200
     1.074     0.642     0.200
     1.044     0.277     0.200
     1.609    -2.812     0.200
     1.727    -3.539     0.200
     1.727    -4.057     0.200
     2.641    -4.021     0.200
     2.805    -4.415     0.200
     3.339    -5.217     0.200
     0.302     1.412     0.200
     0.274     1.504     0.200
     0.646     0.528     0.200
     0.724     0.444     0.200
     0.730     0.359     0.200
     0.730     1.649     0.200
     0.808     0.444     0.200
     0.897    -0.026     0.200
     1.034    -0.553     0.200
     1.723    -3.266     0.200
     2.218    -3.286     0.200
     2.962    -4.975     0.200
     3.124    -5.024     0.200
     3.143    -5.009     0.200
     0.279     0.436     0.200
     0.281     0.368     0.200
     0.584     1.536     0.200
     0.695     1.905     0.200
     0.896     0.883     0.200
     1.031     1.003     0.200
     1.188     1.446     0.200
     1.346     0.355     0.200
     1.429    -0.126     0.200
     2.027    -2.786     0.200
     2.426    -4.609     0.200
     2.659    -4.008     0.200
     3.404    -5.856     0.200
     3.591    -8.160     0.200
     4.097    -6.674     0.200
     0.285     0.808     0.200
     0.287     0.975     0.200
     0.558     0.399     0.200
     0.573     1.465     0.200
     0.692     1.773     0.200
     0.885     0.867     0.200
     1.020     1.179     0.200
     1.178     0.723     0.200
     1.195    -0.589     0.200
     1.340    -1.085     0.200
     1.340     0.444     0.200
     1.428    -0.177     0.200
     2.021    -2.835     0.200
     2.655    -3.922     0.200
     3.293    -5.432     0.200
     3.399    -6.239     0.200
     4.093    -7.128     0.200
     0.288     0.526     0.200
     0.288     0.745     0.200
     0.289     0.411     0.200
     0.552     0.603     0.200
     0.688     2.014     0.200
     1.172     1.550     0.200
     1.424    -0.081     0.200
     2.019    -2.585     0.200
     2.420    -4.716     0.200
     2.652    -3.617     0.200
     3.396    -5.800     0.200
     4.090    -7.044     0.200
     0.573     1.805     0.200
     0.698     2.561     0.200
     0.884     1.345     0.200
     1.019     0.738     0.200
     1.186     1.704     0.200
     1.343     1.078     0.200
     1.434     0.523     0.200
     3.403    -4.454     0.200
     0.282     0.595     0.200
     0.282     0.755     0.200
     0.283     0.495     0.200
     0.283     0.874     0.200
     0.283     1.495     0.200
     0.553     0.720     0.200
     0.578     1.375     0.200
     0.694     1.953     0.200
     0.890     1.180     0.200
     1.025     0.743     0.200
     1.343    -0.981     0.200
     1.343     0.597     0.200
     1.430    -0.045     0.200
     2.658    -3.704     0.200
     3.402    -5.704     0.200
     4.096    -6.941     0.200
     0.269     0.643     0.200
     0.269     0.975     0.200
     0.271     0.741     0.200
     0.271     1.069     0.200
     0.583     1.502     0.200
     0.562     0.324     0.200
     0.710     1.511     0.200
     1.030     0.996     0.200
     1.194     0.916     0.200
     2.037    -3.090     0.200
     2.672    -4.311     0.200
     3.416    -5.660     0.200
     4.110    -7.115     0.200
     0.271     0.994     0.200
     0.273     0.942     0.200
     0.542     0.780     0.200
     0.592     1.528     0.200
     0.703     1.567     0.200
     0.903     0.693     0.200
     1.038     0.681     0.200
     1.178     0.600     0.200
     1.355    -0.652     0.200
     1.355    -0.179     0.200
     2.035    -2.859     0.200
     4.105    -6.729     0.200
     0.539     1.488     0.200
     0.544     1.304     0.200
     0.604     0.735     0.200
     0.680     1.102     0.200
     1.059     0.313     0.200
     1.198     0.035     0.200
     1.238    -1.259     0.200
     1.264    -0.311     0.200
     2.600    -3.680     0.200
     3.147    -5.165     0.200
     0.275     0.852     0.200
     0.275     0.633     0.200
     0.275     0.993     0.200
     0.276     0.770     0.200
     0.578     1.323     0.200
     0.705     1.366     0.200
     1.208    -0.241     0.200
     1.350    -0.799     0.200
     1.441    -0.018     0.200
     0.279     0.181     0.200
     0.281     0.639     0.200
     0.281     0.940     0.200
     0.562     0.580     0.200
     0.562     0.802     0.200
     0.576     1.316     0.200
     0.700     1.912     0.200
     1.346    -0.564     0.200
     1.436    -0.728     0.200
     2.027    -3.462     0.200
     2.656    -3.521     0.200
     0.279     0.977     0.200
     0.279     1.378     0.200
     0.281     0.363     0.200
     0.281     0.562     0.200
     0.572     0.208     0.200
     0.571     1.434     0.200
     0.703     1.191     0.200
     0.883     1.251     0.200
     1.018     0.896     0.200
     1.346     0.292     0.200
     1.346     0.122     0.200
     1.441    -0.359     0.200
     2.436    -3.293     0.200
     2.664    -4.481     0.200
     0.277     0.506     0.200
     0.279     0.591     0.200
     0.279     1.231     0.200
     0.556     0.497     0.200
     0.580     1.457     0.200
     0.700     1.643     0.200
     1.027     0.355     0.200
     1.200     0.616     0.200
     1.348    -1.270     0.200
     1.436     0.099     0.200
     0.268     0.928     0.200
     0.270     0.924     0.200
     0.894     0.494     0.200
     1.029    -0.003     0.200
     0.289     0.228     0.200
     0.289     0.698     0.200
     0.291     0.723     0.200
     0.576     1.106     0.200
     1.190     1.560     0.200
     1.190     1.759     0.200
     1.336    -1.004     0.200
     1.336     0.316     0.200
     0.289    -0.278     0.200
     0.289     0.744     0.200
     0.290     0.627     0.200
     0.290     0.297     0.200
     0.562     1.053     0.200
     0.576     0.818     0.200
     0.874     0.750     0.200
     1.009     0.718     0.200
     1.190     1.203     0.200
     1.336    -0.608     0.200
     1.336     0.280     0.200
     1.432     0.025     0.200
     2.018    -2.990     0.200
     4.092    -5.406     0.200
     0.283     0.808     0.200
     0.557     0.496     0.200
     0.577     1.598     0.200
     0.888     0.991     0.200
     1.023     0.931     0.200
     1.181     1.506     0.200
     1.344     0.660     0.200
     1.432     0.631     0.200
     1.444    -0.008     0.200
     1.645    -0.807     0.200
     2.025    -2.724     0.200
     2.428    -3.367     0.200
     0.534     1.057     0.200
     0.901     0.224     0.200
     0.938     0.632     0.200
     1.002    -0.101     0.200
     1.041    -0.699     0.200
     1.211     0.302     0.200
     1.414    -1.081     0.200
     0.260    -0.168     0.200
     0.262     0.369     0.200
     0.262     0.678     0.200
     0.596     1.602     0.200
     0.549     0.332     0.200
     0.908     0.772     0.200
     1.043     0.426     0.200
     1.207     0.467     0.200
     1.365     0.306     0.200
     1.365    -0.432     0.200
     1.451     0.378     0.200
     2.046    -2.497     0.200
     2.447    -3.580     0.200
     0.205     1.292     0.200
     0.205     0.853     0.200
     0.207     1.148     0.200
     0.644     1.935     0.200
     0.956     0.078     0.200
     1.420    -0.918     0.200
     2.101    -3.110     0.200
     0.241     0.693     0.200
     0.241     0.470     0.200
     0.243     0.590     0.200
     0.539     0.237     0.200
     0.539     0.948     0.200
     0.616     1.575     0.200
     0.928     0.775     0.200
     1.063     0.614     0.200
     1.384     0.051     0.200
     1.466    -0.917     0.200
     0.231     0.592     0.200
     0.231     0.471     0.200
     0.233     0.598     0.200
     0.535     0.190     0.200
     0.535     0.901     0.200
     0.626     1.380     0.200
     0.938     0.918     0.200
     1.395    -0.095     0.200
     1.395    -0.306     0.200
     1.475    -0.752     0.200
     1.494    -0.429     0.200
     0.282     0.643     0.200
     0.282     0.952     0.200
     0.566     0.542     0.200
     0.571     1.380     0.200
     0.883     1.019     0.200
     1.018     0.243     0.200
     1.187     0.825     0.200
     1.204     0.263     0.200
     1.342     0.035     0.200
     1.427     0.080     0.200
     1.443    -0.847     0.200
     1.645    -1.053     0.200
     0.339     1.222     0.200
     0.498     0.952     0.200
     0.751     0.552     0.200
     0.751     1.634     0.200
     0.865    -0.657     0.200
     0.893    -0.335     0.200
     0.882     0.194     0.200
     0.882     0.342     0.200
     0.883     0.470     0.200
     0.942     0.047     0.200
     1.044    -1.006     0.200
     1.152    -0.690     0.200
     1.174    -0.448     0.200
     2.059    -3.235     0.200
     2.803    -5.335     0.200
     3.130    -4.899     0.200
     3.497    -6.332     0.200
     0.403     0.918     0.200
     0.403     1.425     0.200
     0.479     0.455     0.200
     0.480     1.126     0.200
     0.480     1.408     0.200
     0.480     1.798     0.200
     1.251    -0.857     0.200
     1.336    -2.687     0.200
     1.632    -3.336     0.200
     1.632    -3.907     0.200
     1.913    -3.086     0.200
     4.757   -12.481     0.200
     6.763   -16.210     0.200
     0.367     1.154     0.200
     0.618     0.936     0.200
     0.618     0.726     0.200
     0.620     0.948     0.200
     0.620     0.667     0.200
     0.688     0.685     0.200
     0.963     1.133     0.200
     1.013     0.563     0.200
     1.013    -0.117     0.200
     1.098    -0.550     0.200
     1.109    -0.819     0.200
     1.308    -0.606     0.200
     1.404    -0.758     0.200
     2.292    -3.669     0.200
     2.320    -3.576     0.200
     2.426    -3.417     0.200
     2.443    -4.268     0.200
     3.065    -5.454     0.200
     3.394    -4.917     0.200
     3.758    -6.022     0.200
     0.346     1.127     0.200
     0.747     0.288     0.200
     0.748     0.237     0.200
     0.772     1.089     0.200
     0.889     0.340     0.200
     0.889     1.651     0.200
     0.975    -0.003     0.200
     1.261     0.665     0.200
     2.192    -2.959     0.200
     0.499     0.740     0.200
     0.545     1.213     0.200
     0.545     0.443     0.200
     0.546     0.446     0.200
     0.836     0.838     0.200
     1.148    -0.345     0.200
     1.237    -0.675     0.200
     1.477    -0.886     0.200
     3.160    -4.293     0.200
     0.348     0.921     0.200
     0.580     0.480     0.200
     0.690     0.846     0.200
     0.746     0.749     0.200
     0.747     0.660     0.200
     0.747     0.949     0.200
     0.891     0.578     0.200
     0.976     0.138     0.200
     0.985    -0.080     0.200
     1.180    -0.781     0.200
     1.260     0.072     0.200
     1.277    -0.259     0.200
     1.566    -1.391     0.200
     1.566    -1.047     0.200
     3.631    -4.808     0.200
     0.444     0.493     0.200
     0.444     0.672     0.200
     0.446     0.218     0.200
     0.446     0.577     0.200
     1.244     0.301     0.200
     1.354    -1.073     0.200
     2.415    -3.045     0.200
     5.219   -12.928     0.200
     0.448     0.417     0.200
     0.450     0.354     0.200
     0.450     0.572     0.200
     0.450     0.975     0.200
     0.699     1.341     0.200
     0.837     1.043     0.200
     1.231    -0.139     0.200
     1.340    -0.542     0.200
     1.406    -0.037     0.200
     0.132     2.768     0.200
     0.399     1.517     0.200
     0.525     0.882     0.200
     0.785    -0.228     0.200
     0.787     0.003     0.200
     0.787    -0.137     0.200
     0.856    -0.118     0.200
     0.856     0.532     0.200
     0.935     0.035     0.200
     0.965    -0.776     0.200
     1.063    -1.192     0.200
     1.067    -0.962     0.200
     2.943    -4.728     0.200
     3.640    -5.925     0.200
     0.431     0.858     0.200
     0.433     0.634     0.200
     0.433     1.223     0.200
     0.433     1.624     0.200
     0.433     0.845     0.200
     0.764    -0.148     0.200
     0.764     1.561     0.200
     0.895     0.738     0.200
     1.315     0.003     0.200
     1.355    -0.105     0.200
     1.574    -1.294     0.200
     1.930    -2.506     0.200
     4.029    -5.724     0.200
     0.509     0.909     0.200
     0.510     0.937     0.200
     0.510     0.413     0.200
     0.585    -0.078     0.200
     0.585     0.687     0.200
     0.877     1.526     0.200
     1.026    -0.348     0.200
     1.034     0.085     0.200
     1.089     0.529     0.200
     1.205    -0.183     0.200
     1.240     0.020     0.200
     1.240     0.645     0.200
     1.323    -0.811     0.200
     1.408     0.232     0.200
     1.495    -1.240     0.200
     1.542    -0.794     0.200
     1.898    -2.517     0.200
     2.488    -3.074     0.200
     0.079     2.801     0.200
     0.078     1.709     0.200
     0.078     2.139     0.200
     0.426     1.108     0.200
     0.665    -0.431     0.200
     1.004    -0.263     0.200
     2.285    -3.613     0.200
     2.907    -4.673     0.200
     3.651    -5.447     0.200
     0.489     0.257     0.200
     0.489     1.249     0.200
     0.490     0.331     0.200
     0.490    -0.059     0.200
     0.599     0.123     0.200
     0.599    -0.229     0.200
     1.007     0.024     0.200
     1.038    -0.583     0.200
     1.107     0.255     0.200
     1.223    -0.616     0.200
     1.251     0.353     0.200
     1.335    -0.935     0.200
     1.558    -1.150     0.200
     1.618    -2.395     0.200
     0.377     1.208     0.200
     0.514     0.882     0.200
     0.514     0.161     0.200
     0.515     0.658     0.200
     0.595     0.133     0.200
     0.699     0.376     0.200
     1.039    -0.659     0.200
     1.093     0.909     0.200
     1.210    -0.211     0.200
     1.254     0.068     0.200
     1.254    -1.222     0.200
     1.336    -1.047     0.200
     3.238    -4.458     0.200
     3.601    -4.938     0.200
     0.380     1.183     0.200
     0.504     0.676     0.200
     0.505     0.751     0.200
     0.505     0.571     0.200
     0.599    -0.286     0.200
     0.599    -0.126     0.200
     0.599    -0.406     0.200
     0.690     0.046     0.200
     0.888     2.070     0.200
     1.028    -0.640     0.200
     1.028     0.899     0.200
     1.051    -0.007     0.200
     1.051    -0.308     0.200
     1.100     0.199     0.200
     1.216    -0.569     0.200
     1.256    -0.081     0.200
     1.391    -0.979     0.200
     1.597    -4.233     0.200
     1.913    -3.020     0.200
     3.462    -5.202     0.200
     0.386     1.148     0.200
     0.499     1.173     0.200
     0.499     0.183     0.200
     0.499     1.027     0.200
     0.499    -0.133     0.200
     0.599    -0.107     0.200
     0.682     0.396     0.200
     0.885     1.843     0.200
     0.896     1.984     0.200
     1.020    -0.321     0.200
     1.046     0.345     0.200
     1.103     0.427     0.200
     1.219    -0.372     0.200
     1.254     0.157     0.200
     1.337    -0.672     0.200
     1.390    -0.630     0.200
     1.556    -1.115     0.200
     1.912    -2.629     0.200
     3.244    -5.205     0.200
     3.931    -5.570     0.200
     0.288     1.510     0.200
     0.443     0.688     0.200
     0.443     0.408     0.200
     0.445     0.393     0.200
     0.661     0.506     0.200
     0.765    -0.395     0.200
     0.788     0.252     0.200
     0.886     0.866     0.200
     0.886     0.715     0.200
     1.240    -0.095     0.200
     1.240    -0.535     0.200
     1.323    -0.197     0.200
     1.349    -1.222     0.200
     1.416    -0.606     0.200
     1.416    -0.821     0.200
     1.822    -3.080     0.200
     1.954    -2.991     0.200
     2.407    -5.889     0.200
     0.274     0.964     0.200
     0.395     1.978     0.200
     0.508     0.867     0.200
     0.618     0.411     0.200
     0.618     0.551     0.200
     0.720    -0.367     0.200
     0.720    -0.157     0.200
     0.732    -0.088     0.200
     0.732     0.872     0.200
     0.809    -0.676     0.200
     0.817    -0.585     0.200
     0.933    -1.119     0.200
     0.988    -1.131     0.200
     0.988    -0.117     0.200
     1.006    -0.519     0.200
     1.008    -1.054     0.200
     1.008    -0.614     0.200
     1.025    -1.775     0.200
     1.071    -0.994     0.200
     1.285    -2.343     0.200
     1.786    -3.000     0.200
     1.950    -3.327     0.200
     2.496    -3.769     0.200
     2.692    -5.396     0.200
     3.389    -5.973     0.200
     0.358     1.107     0.200
     0.452     1.043     0.200
     0.452     1.402     0.200
     0.452     1.277     0.200
     0.649    -0.089     0.200
     0.649     0.903     0.200
     0.935     1.342     0.200
     1.082    -0.415     0.200
     1.301    -1.054     0.200
     1.961    -3.374     0.200
     2.553    -4.101     0.200
     3.296    -5.575     0.200
     3.655    -6.313     0.200
     3.982    -6.555     0.200
     0.366     1.296     0.200
     0.366     1.767     0.200
     0.356     0.166     0.200
     0.356    -0.244     0.200
     0.356     0.566     0.200
     0.652     0.008     0.200
     0.860    -0.834     0.200
     0.895    -0.655     0.200
     0.982    -1.179     0.200
     0.984    -1.170     0.200
     0.984    -1.590     0.200
     1.010    -1.171     0.200
     1.337    -2.181     0.200
     1.620    -3.891     0.200
     1.999    -3.274     0.200
     2.739    -5.620     0.200
     0.284     1.397     0.200
     0.447     0.742     0.200
     0.449     0.167     0.200
     0.449     1.178     0.200
     0.761    -0.364     0.200
     0.665     0.331     0.200
     0.790     0.714     0.200
     0.882    -0.312     0.200
     1.236    -0.942     0.200
     1.311    -0.180     0.200
     1.412    -0.880     0.200
     1.920    -3.100     0.200
     2.582    -5.043     0.200
     3.323    -5.311     0.200
     4.020    -6.556     0.200
     0.266     0.517     0.200
     0.266     0.859     0.200
     0.377     0.802     0.200
     0.438     1.701     0.200
     0.438     1.521     0.200
     0.438     1.380     0.200
     0.668     0.352     0.200
     0.963    -0.879     0.200
     0.944     0.814     0.200
     1.070    -0.418     0.200
     1.159    -0.843     0.200
     1.295    -0.891     0.200
     1.557    -2.868     0.200
     1.753    -2.719     0.200
     1.753    -2.899     0.200
     1.812    -2.890     0.200
     1.946    -3.005     0.200
     0.238     0.416     0.200
     0.238     1.346     0.200
     0.530     0.372     0.200
     0.531     1.612     0.200
     0.532     0.427     0.200
     0.532     0.597     0.200
     0.856     2.076     0.200
     0.884     2.214     0.200
     0.959     0.501     0.200
     1.016     0.136     0.200
     1.085    -0.006     0.200
     1.113    -0.864     0.200
     1.165    -1.223     0.200
     1.261    -1.094     0.200
     1.496    -1.614     0.200
     1.496    -1.729     0.200
     1.838    -3.018     0.200
     2.437    -4.046     0.200
     3.180    -5.926     0.200
     0.402     0.717     0.200
     0.402     1.357     0.200
     0.408     1.354     0.200
     0.408     1.194     0.200
     0.408     0.132     0.200
     0.783    -0.736     0.200
     0.890     3.081     0.200
     0.981    -0.181     0.200
     0.980     1.784     0.200
     1.227    -0.612     0.200
     1.386    -0.444     0.200
     2.098    -3.005     0.200
     0.309    -0.704     0.200
     0.416     1.202     0.200
     0.625     0.480     0.200
     0.693     2.361     0.200
     0.772     0.692     0.200
     0.772     0.481     0.200
     0.773     0.812     0.200
     0.843     0.307     0.200
     0.849     0.490     0.200
     0.853     1.353     0.200
     0.872    -0.370     0.200
     0.925    -0.659     0.200
     0.983    -0.071     0.200
     0.983     0.108     0.200
     1.058    -1.183     0.200
     1.113    -0.165     0.200
     1.148     0.002     0.200
     1.231    -0.962     0.200
     1.884    -3.153     0.200
     2.206    -3.302     0.200
     0.195     1.151     0.200
     0.195     1.931     0.200
     0.495     0.893     0.200
     0.505     1.319     0.200
     0.505     1.029     0.200
     0.507     1.271     0.200
     0.544     1.162     0.200
     0.572    -0.080     0.200
     0.899     2.195     0.200
     0.978    -0.582     0.200
     1.106     0.676     0.200
     1.116     0.245     0.200
     1.139     0.032     0.200
     1.175    -0.099     0.200
     1.186    -0.559     0.200
     1.186    -0.278     0.200
     1.264    -0.886     0.200
     1.447    -0.962     0.200
     1.843    -2.610     0.200
     3.541    -5.708     0.200
     3.883    -5.431     0.200
     4.025    -6.571     0.200
     4.759    -9.725     0.200
     0.180     1.356     0.200
     0.496     0.946     0.200
     0.496     1.376     0.200
     0.502     0.241     0.200
     0.497     1.208     0.200
     0.497     1.837     0.200
     0.550     0.549     0.200
     0.560    -0.086     0.200
     0.941    -0.683     0.200
     0.941    -0.164     0.200
     0.964    -0.202     0.200
     1.149    -0.277     0.200
     1.177    -0.514     0.200
     1.177    -0.383     0.200
     1.195    -0.534     0.200
     1.267    -1.221     0.200
     1.267    -0.991     0.200
     1.847    -2.775     0.200
     1.847    -2.765     0.200
     0.177     0.728     0.200
     0.494     1.278     0.200
     0.494     1.159     0.200
     0.496     0.819     0.200
     0.496     0.960     0.200
     0.496     1.428     0.200
     0.496     1.629     0.200
     0.505     0.049     0.200
     0.556    -0.102     0.200
     0.551     0.285     0.200
     0.961    -0.681     0.200
     1.452    -2.574     0.200
     1.847    -3.327     0.200
     2.199    -5.825     0.200
     0.180     1.128     0.200
     0.180     1.566     0.200
     0.494     0.760     0.200
     0.494     1.268     0.200
     0.496     0.807     0.200
     0.496     1.378     0.200
     0.502     0.454     0.200
     0.552     0.038     0.200
     0.559     0.087     0.200
     0.915     1.122     0.200
     0.942    -0.016     0.200
     0.963    -0.365     0.200
     1.179    -0.487     0.200
     1.843    -2.807     0.200
     1.848    -3.084     0.200
     2.457    -4.620     0.200
     3.891    -6.656     0.200
     0.274     1.255     0.200
     0.274     1.986     0.200
     0.365     0.377     0.200
     0.420     1.156     0.200
     0.672     0.711     0.200
     0.709     0.378     0.200
     0.709     0.488     0.200
     0.710     0.428     0.200
     0.761    -0.514     0.200
     1.005    -1.180     0.200
     1.018    -1.117     0.200
     1.020    -0.615     0.200
     1.872    -3.768     0.200
     0.326     0.818     0.200
     0.188     1.621     0.200
     0.405     0.804     0.200
     0.405     1.046     0.200
     0.407     1.022     0.200
     0.407     2.100     0.200
     0.758     0.017     0.200
     0.778     0.774     0.200
     1.269    -0.799     0.200
     1.269    -0.646     0.200
     1.953    -3.345     0.200
     2.612    -4.415     0.200
     4.051    -7.055     0.200
     0.503     0.532     0.200
     0.525     0.827     0.200
     0.525     0.359     0.200
     0.526     0.531     0.200
     0.526     0.383     0.200
     0.575     0.207     0.200
     0.885     1.795     0.200
     0.933     0.304     0.200
     1.096     1.104     0.200
     1.119     0.915     0.200
     1.159     0.434     0.200
     1.159     1.887     0.200
     1.167     0.302     0.200
     1.206     0.026     0.200
     1.247    -0.313     0.200
     1.247     0.047     0.200
     1.308    -0.155     0.200
     0.263     0.680     0.200
     0.264     0.613     0.200
     0.264     1.519     0.200
     0.351     1.054     0.200
     0.717    -0.043     0.200
     1.205     0.001     0.200
     1.205    -0.327     0.200
     1.463    -0.421     0.200
     0.687    -0.637     0.200
     1.179    -1.120     0.200
     0.376     0.881     0.200
     0.624     0.603     0.200
     0.624     0.974     0.200
     0.814     0.787     0.200
     0.892     0.590     0.200
     0.892     0.481     0.200
     0.992    -0.162     0.200
     0.992    -0.291     0.200
     0.977     1.931     0.200
     1.017    -0.069     0.200
     1.023     0.146     0.200
     1.023    -0.010     0.200
     1.025     0.759     0.200
     1.075    -0.439     0.200
     1.101     1.086     0.200
     1.262    -1.174     0.200
     1.312    -0.294     0.200
     1.573    -2.134     0.200
     1.725    -3.683     0.200
     2.214    -3.519     0.200
     3.653    -4.765     0.200
     0.481     0.922     0.200
     0.481     0.758     0.200
     0.680    -0.382     0.200
     0.902     2.762     0.200
     0.912     2.703     0.200
     1.055     0.561     0.200
     1.055     0.318     0.200
     1.236    -0.053     0.200
     1.268    -0.198     0.200
     1.268     0.091     0.200
     1.268     0.966     0.200
     1.352    -0.618     0.200
     1.406    -0.476     0.200
     1.573    -0.936     0.200
     3.620    -4.923     0.200
     0.405     0.996     0.200
     0.405     1.456     0.200
     0.539    -0.149     0.200
     0.539     0.031     0.200
     0.539     0.301     0.200
     0.602     0.710     0.200
     0.701     0.170     0.200
     0.786     0.449     0.200
     0.787    -0.115     0.200
     0.812     0.114     0.200
     0.972     0.468     0.200
     1.023    -0.198     0.200
     1.650    -3.995     0.200
     1.927    -2.745     0.200
     3.366    -5.223     0.200
     0.851     0.915     0.200
     0.710     0.258     0.200
     1.348    -0.352     0.200
     1.348    -0.952     0.200
     1.643    -2.831     0.200
     1.716    -2.464     0.200
     1.716    -2.284     0.200
     3.804    -5.229     0.200
     4.479   -11.824     0.200
     0.432     0.663     0.200
     0.432     1.093     0.200
     0.472     0.533     0.200
     0.549     0.835     0.200
     0.836     2.187     0.200
     1.096    -0.062     0.200
     1.149    -0.455     0.200
     1.167    -0.016     0.200
     1.167     0.581     0.200
     1.252    -0.890     0.200
     1.482    -1.217     0.200
     1.828    -2.556     0.200
     2.424    -3.541     0.200
     0.172     1.966     0.200
     0.172     2.306     0.200
     0.562     0.110     0.200
     0.562     0.270     0.200
     0.806     0.189     0.200
     0.919    -0.122     0.200
     1.189    -0.751     0.200
     1.409    -2.646     0.200
     1.684    -3.108     0.200
     1.684    -2.995     0.200
     1.779    -3.991     0.200
     1.869    -3.427     0.200
     2.392    -3.992     0.200
     2.398    -4.063     0.200
     0.251     1.462     0.200
     0.441     1.307     0.200
     0.441     1.659     0.200
     0.529     1.508     0.200
     0.750     0.250     0.200
     0.748     0.248     0.200
     0.847    -0.706     0.200
     0.880    -0.765     0.200
     0.880    -0.640     0.200
     0.883    -0.919     0.200
     0.926    -0.817     0.200
     1.428    -2.535     0.200
     1.428    -2.347     0.200
     1.701    -2.872     0.200
     2.064    -3.772     0.200
     3.503    -6.601     0.200
     0.248     0.897     0.200
     0.248     1.276     0.200
     0.409     0.630     0.200
     0.409     0.970     0.200
     0.409     1.081     0.200
     0.832    -0.280     0.200
     0.832     0.041     0.200
     0.868     0.730     0.200
     0.907     0.739     0.200
     1.150     1.113     0.200
     1.288    -0.618     0.200
     1.288    -0.077     0.200
     0.243     0.848     0.200
     0.480     1.116     0.200
     0.480     0.857     0.200
     0.480     1.397     0.200
     0.480     1.547     0.200
     0.488     0.431     0.200
     0.491     0.743     0.200
     0.491     0.843     0.200
     0.697     0.033     0.200
     0.697    -0.096     0.200
     0.795    -0.404     0.200
     0.795    -1.004     0.200
     0.773    -0.050     0.200
     0.847    -0.685     0.200
     0.858    -0.681     0.200
     0.930     0.111     0.200
     0.930    -0.569     0.200
     0.917     1.240     0.200
     0.957    -0.232     0.200
     0.984    -1.038     0.200
     0.979    -1.075     0.200
     1.121    -0.636     0.200
     1.121    -0.776     0.200
     1.650    -3.027     0.200
     2.016    -3.833     0.200
     2.759    -4.147     0.200
     0.481     0.820     0.200
     0.481     1.050     0.200
     0.481     1.292     0.200
     0.489     0.487     0.200
     0.491     0.666     0.200
     0.491     1.014     0.200
     0.697     0.266     0.200
     0.697     0.058     0.200
     0.773    -0.118     0.200
     0.795    -0.440     0.200
     0.795    -0.569     0.200
     0.847    -0.507     0.200
     0.847    -0.687     0.200
     0.858    -0.651     0.200
     0.858    -0.668     0.200
     0.876    -0.820     0.200
     0.876    -0.597     0.200
     0.916     0.271     0.200
     0.930    -0.227     0.200
     0.956     0.118     0.200
     0.984    -0.851     0.200
     0.978    -0.692     0.200
     1.000    -1.046     0.200
     1.000    -1.147     0.200
     1.000    -0.745     0.200
     1.067    -1.051     0.200
     1.650    -3.672     0.200
     0.296     0.725     0.200
     0.296     0.906     0.200
     0.296     1.025     0.200
     0.352     1.312     0.200
     0.393     0.191     0.200
     0.609     0.930     0.200
     0.609     0.770     0.200
     0.735     0.635     0.200
     0.735     0.006     0.200
     0.833    -0.050     0.200
     0.889    -0.105     0.200
     0.991    -0.605     0.200
     0.991    -0.945     0.200
     1.035    -1.058     0.200
     1.077    -1.397     0.200
     1.077    -1.027     0.200
     1.200    -1.218     0.200
     1.848    -3.145     0.200
     0.162     1.644     0.200
     0.162     1.769     0.200
     0.278     1.109     0.200
     0.278     1.492     0.200
     0.278     1.711     0.200
     0.278     1.008     0.200
     0.504     0.394     0.200
     0.565     0.459     0.200
     0.565     0.764     0.200
     0.709    -0.082     0.200
     0.776    -0.063     0.200
     0.927     0.224     0.200
     1.015    -0.984     0.200
     1.042    -1.038     0.200
     1.042    -0.624     0.200
     2.029    -3.432     0.200
     3.408    -5.645     0.200
     6.674   -19.261     0.200
     0.307     1.581     0.200
     0.307     1.761     0.200
     0.355     1.138     0.200
     0.355     1.818     0.200
     0.721    -0.098     0.200
     0.821     0.223     0.200
     2.129    -4.193     0.200
     3.470    -5.138     0.200
     0.284     0.711     0.200
     0.284     0.820     0.200
     0.347     0.946     0.200
     0.390    -0.124     0.200
     0.459     0.245     0.200
     0.459     0.995     0.200
     0.627     0.012     0.200
     0.627     0.501     0.200
     0.640     0.443     0.200
     0.723    -0.293     0.200
     0.794    -0.034     0.200
     0.814     0.380     0.200
     0.901     0.131     0.200
     1.002    -0.867     0.200
     1.002    -1.348     0.200
     1.040    -0.598     0.200
     1.031    -0.873     0.200
     1.031    -1.021     0.200
     1.037    -0.967     0.200
     1.038    -0.579     0.200
     0.207     0.951     0.200
     0.376     0.473     0.200
     0.472     0.685     0.200
     0.472     1.075     0.200
     0.472     1.285     0.200
     0.535     1.040     0.200
     0.519     0.658     0.200
     0.534     0.656     0.200
     0.534     0.485     0.200
     0.534     1.145     0.200
     0.660    -0.114     0.200
     0.660     0.386     0.200
     0.755    -0.300     0.200
     0.755     0.260     0.200
     0.757    -0.144     0.200
     0.799    -0.395     0.200
     0.812    -0.969     0.200
     0.812    -0.316     0.200
     0.819    -0.282     0.200
     0.956    -1.190     0.200
     0.971     0.010     0.200
     0.977    -0.082     0.200
     1.073    -0.433     0.200
     1.073    -0.746     0.200
     1.073    -0.634     0.200
     1.073    -0.103     0.200
     1.884    -4.044     0.200
     1.972    -3.230     0.200
     0.228     1.009     0.200
     0.228     1.845     0.200
     0.228     2.095     0.200
     0.402     0.661     0.200
     0.459     0.556     0.200
     0.643     0.167     0.200
     0.643     0.635     0.200
     0.665     0.445     0.200
     0.768     0.222     0.200
     0.789    -0.074     0.200
     0.789     0.442     0.200
     0.943    -0.895     0.200
     1.002    -1.037     0.200
     1.002    -0.506     0.200
     1.030    -0.336     0.200
     1.041    -0.885     0.200
     1.059    -0.865     0.200
     1.059    -0.990     0.200
     2.295    -4.449     0.200
     3.300    -5.623     0.200
     0.200     1.616     0.200
     0.200     1.784     0.200
     0.200     2.045     0.200
     0.534     1.574     0.200
     0.662    -0.101     0.200
     0.662     0.547     0.200
     0.662     1.227     0.200
     0.623     0.756     0.200
     0.623     1.557     0.200
     1.901    -2.985     0.200
     2.482    -4.285     0.200
     0.238     1.112     0.200
     0.391     0.404     0.200
     0.391     1.604     0.200
     0.478     0.440     0.200
     0.478     0.741     0.200
     0.478     0.991     0.200
     0.483     0.881     0.200
     0.483     1.229     0.200
     0.483     1.791     0.200
     0.493     0.457     0.200
     0.493     0.907     0.200
     0.535     1.028     0.200
     0.535     1.637     0.200
     0.696     0.146     0.200
     0.696    -0.084     0.200
     0.794    -0.506     0.200
     0.843    -0.443     0.200
     0.854    -0.495     0.200
     0.854    -0.422     0.200
     0.853     0.451     0.200
     0.874    -0.655     0.200
     0.874    -0.456     0.200
     0.900     0.073     0.200
     0.912     1.198     0.200
     0.931    -0.508     0.200
     0.931    -0.180     0.200
     0.955     0.207     0.200
     0.982    -0.974     0.200
     0.974    -0.616     0.200
     0.998    -1.192     0.200
     1.065    -0.767     0.200
     1.071    -0.563     0.200
     1.170    -1.610     0.200
     1.375    -2.210     0.200
     1.503    -3.531     0.200
     1.645    -3.924     0.200
     2.014    -3.723     0.200
     2.757    -4.352     0.200
     3.453    -5.728     0.200
     0.210     1.534     0.200
     0.210     1.284     0.200
     0.210     1.663     0.200
     0.464     0.710     0.200
     0.494     0.172     0.200
     0.494     0.684     0.200
     0.486     1.071     0.200
     0.570     0.357     0.200
     0.582     0.227     0.200
     0.665     0.884     0.200
     0.827     0.992     0.200
     0.894     1.925     0.200
     0.926     1.387     0.200
     0.977    -0.130     0.200
     0.992    -0.539     0.200
     0.974    -0.194     0.200
     0.974     0.817     0.200
     1.012     0.184     0.200
     1.130     0.321     0.200
     1.157    -0.525     0.200
     1.206    -0.418     0.200
     1.206    -0.886     0.200
     1.208    -1.026     0.200
     1.294    -1.439     0.200
     1.294    -0.657     0.200
     0.079     3.613     0.200
     0.290     1.400     0.200
     0.333     2.086     0.200
     0.333     1.047     0.200
     0.333     2.346     0.200
     0.333     2.506     0.200
     0.402     0.987     0.200
     0.428     1.104     0.200
     0.428     1.886     0.200
     0.412     0.989     0.200
     0.492     0.857     0.200
     0.491     0.712     0.200
     0.593     0.373     0.200
     0.593     0.504     0.200
     0.593     0.674     0.200
     0.683    -0.311     0.200
     0.694     0.018     0.200
     0.694    -0.113     0.200
     0.721     0.028     0.200
     0.721    -0.218     0.200
     0.807    -0.551     0.200
     0.839     0.189     0.200
     0.862    -0.425     0.200
     0.868    -0.178     0.200
     0.954    -0.697     0.200
     0.969    -1.136     0.200
     1.059    -1.686     0.200
     1.094    -1.193     0.200
     1.824    -3.063     0.200
     2.375    -3.667     0.200
     2.566    -4.647     0.200
     3.262    -5.675     0.200
     0.132     0.996     0.200
     0.211     0.709     0.200
     0.252     0.567     0.200
     0.434     1.022     0.200
     0.514     0.854     0.200
     0.514     0.752     0.200
     0.514     1.885     0.200
     0.658     1.259     0.200
     0.719     0.571     0.200
     0.729     0.570     0.200
     0.729     0.218     0.200
     0.744     0.911     0.200
     0.746     0.010     0.200
     0.785     0.266     0.200
     0.832     0.485     0.200
     0.832     0.235     0.200
     0.904    -0.535     0.200
     0.906     0.069     0.200
     0.946    -0.036     0.200
     0.946    -0.743     0.200
     1.036     0.670     0.200
     1.036    -0.107     0.200
     1.112    -0.358     0.200
     3.158    -4.755     0.200
     0.148     0.850     0.200
     0.516     0.365     0.200
     0.723     0.849     0.200
     0.743     1.026     0.200
     0.743    -0.222     0.200
     0.780    -0.088     0.200
     0.807     2.340     0.200
     0.824     0.494     0.200
     0.851     2.168     0.200
     0.897    -0.764     0.200
     0.910    -0.321     0.200
     0.940    -0.640     0.200
     0.984     0.315     0.200
     1.034     0.119     0.200
     1.034    -0.014     0.200
     1.057    -0.792     0.200
     1.070    -0.740     0.200
     1.107    -0.136     0.200
     1.107    -0.730     0.200
     1.173    -0.778     0.200
     1.261    -1.326     0.200
     1.311    -0.991     0.200
     1.414    -2.084     0.200
     3.152    -4.512     0.200
     3.635    -6.149     0.200
     0.136     0.745     0.200
     0.136     2.114     0.200
     0.425     1.099     0.200
     0.516     0.327     0.200
     0.516     0.457     0.200
     0.507     1.619     0.200
     0.720     0.459     0.200
     0.658     1.018     0.200
     0.790     0.231     0.200
     0.742     0.100     0.200
     0.743     0.657     0.200
     0.786     0.877     0.200
     0.779     0.113     0.200
     0.823     0.334     0.200
     0.911     0.599     0.200
     0.895    -0.686     0.200
     0.895     0.224     0.200
     0.851     1.289     0.200
     0.938    -0.294     0.200
     1.056    -0.838     0.200
     1.172    -0.969     0.200
     0.261     0.567     0.200
     0.401     0.385     0.200
     0.433     0.315     0.200
     0.424     0.846     0.200
     0.590     2.199     0.200
     0.736    -0.255     0.200
     0.755     1.255     0.200
     0.878     0.133     0.200
     0.945    -0.009     0.200
     0.996    -0.078     0.200
     0.986    -0.865     0.200
     0.986    -0.714     0.200
     1.079     0.344     0.200
     1.079    -0.224     0.200
     1.150    -1.441     0.200
     1.150    -0.912     0.200
     0.139     0.679     0.200
     0.139     1.108     0.200
     0.139     1.247     0.200
     0.157     0.943     0.200
     0.507     0.675     0.200
     0.507     0.925     0.200
     0.507     1.194     0.200
     0.665     0.991     0.200
     0.672     2.164     0.200
     0.726     0.748     0.200
     0.726     1.217     0.200
     0.752    -0.440     0.200
     0.775     0.499     0.200
     0.790     0.018     0.200
     0.793     2.143     0.200
     0.794     0.508     0.200
     0.814     2.392     0.200
     0.833     0.353     0.200
     0.860     1.198     0.200
     0.905    -0.414     0.200
     0.905    -0.283     0.200
     0.901     0.125     0.200
     0.901     0.584     0.200
     0.949    -0.234     0.200
     0.949    -0.404     0.200
     1.043     0.428     0.200
     1.067    -0.389     0.200
     1.079    -0.588     0.200
     1.182    -0.658     0.200
     1.182    -0.777     0.200
     4.285    -7.547     0.200
     0.142     1.047     0.200
     0.131     1.081     0.200
     0.523     0.376     0.200
     0.651     1.163     0.200
     0.664     2.606     0.200
     0.735     0.115     0.200
     0.736     0.937     0.200
     0.792     0.389     0.200
     0.773     0.245     0.200
     0.773     0.436     0.200
     0.781     3.039     0.200
     0.820     0.436     0.200
     0.820     0.729     0.200
     0.820     1.526     0.200
     0.844     1.878     0.200
     0.891    -0.403     0.200
     0.891    -0.052     0.200
     0.918     0.152     0.200
     1.027     0.605     0.200
     0.103     2.496     0.200
     0.103     2.676     0.200
     0.103     3.207     0.200
     0.337     0.991     0.200
     0.337     1.170     0.200
     0.740    -0.114     0.200
     0.740     0.405     0.200
     0.724     0.587     0.200
     0.955    -0.835     0.200
     0.983    -0.053     0.200
     1.288    -1.095     0.200
     0.383     1.043     0.200
     0.336     0.997     0.200
     0.459     1.020     0.200
     0.459     1.319     0.200
     0.487     1.316     0.200
     0.453     0.329     0.200
     0.453     0.459     0.200
     0.477     0.349     0.200
     0.735    -0.278     0.200
     0.735    -0.148     0.200
     0.840    -0.910     0.200
     0.892    -0.552     0.200
     0.948    -0.936     0.200
     1.031    -1.118     0.200
     1.056    -1.463     0.200
     1.064    -0.938     0.200
     1.215    -2.118     0.200
     0.391     1.422     0.200
     0.391     1.891     0.200
     0.450     1.197     0.200
     0.461     1.197     0.200
     0.486     0.535     0.200
     0.486     0.793     0.200
     0.564     0.198     0.200
     0.564     0.354     0.200
     0.622     0.587     0.200
     0.622     1.447     0.200
     0.622     1.603     0.200
     0.622     0.369     0.200
     0.724     0.060     0.200
     0.724    -0.065     0.200
     0.815     0.076     0.200
     0.916     0.804     0.200
     0.915    -0.275     0.200
     0.939    -0.564     0.200
     1.003    -0.750     0.200
     0.991    -0.020     0.200
     1.033    -0.077     0.200
     1.046     0.083     0.200
     0.503     1.008     0.200
     0.503     1.695     0.200
     0.551     0.560     0.200
     0.567     1.193     0.200
     0.852     1.483     0.200
     0.956     0.136     0.200
     0.956     1.027     0.200
     0.968     0.181     0.200
     0.919     3.136     0.200
     0.954     0.833     0.200
     0.954     1.290     0.200
     0.954    -0.499     0.200
     1.026     0.842     0.200
     1.141     0.374     0.200
     1.164    -0.035     0.200
     1.194    -0.161     0.200
     1.211    -0.156     0.200
     1.284    -0.691     0.200
     1.284    -0.851     0.200
     1.347    -0.782     0.200
     0.495     1.605     0.200
     0.493     1.397     0.200
     0.559     0.931     0.200
     0.552     0.474     0.200
     0.846     1.859     0.200
     0.951     0.488     0.200
     1.019     0.611     0.200
     0.964     0.072     0.200
     1.074     0.728     0.200
     0.961    -0.345     0.200
     0.961    -0.044     0.200
     1.203     0.121     0.200
     1.187     0.156     0.200
     1.277    -0.506     0.200
     1.277    -0.619     0.200
     1.340    -0.550     0.200
     0.542     0.445     0.200
     0.504     0.559     0.200
     0.499     0.621     0.200
     0.499     1.012     0.200
     0.564     0.419     0.200
     0.858     0.533     0.200
     0.882     2.643     0.200
     0.948     0.310     0.200
     0.950    -0.420     0.200
     0.950     0.358     0.200
     0.950    -0.693     0.200
     0.960    -0.027     0.200
     1.029     0.394     0.200
     1.164    -0.418     0.200
     1.164    -0.478     0.200
     1.189    -0.218     0.200
     1.189    -0.850     0.200
     1.279    -0.763     0.200
     1.279    -1.127     0.200
     0.174     1.378     0.200
     0.501     0.653     0.200
     0.499     0.545     0.200
     0.499     1.006     0.200
     0.544     0.632     0.200
     0.562     0.799     0.200
     0.691     0.179     0.200
     0.922     3.071     0.200
     0.948     0.749     0.200
     0.953    -0.060     0.200
     0.953     0.351     0.200
     0.960    -0.052     0.200
     0.969     1.751     0.200
     1.139     0.715     0.200
     1.161     0.012     0.200
     1.188     0.032     0.200
     1.188    -0.347     0.200
     1.207    -0.221     0.200
     1.342    -0.487     0.200
     1.462    -0.930     0.200
     0.164     1.313     0.200
     0.164     1.798     0.200
     0.164     0.642     0.200
     0.496     0.627     0.200
     0.496     1.010     0.200
     0.519     0.801     0.200
     0.540     0.964     0.200
     0.579    -0.355     0.200
     0.707     0.343     0.200
     0.936    -0.159     0.200
     0.957    -0.168     0.200
     0.957    -0.628     0.200
     1.201    -0.509     0.200
     1.201    -0.908     0.200
     0.155     1.026     0.200
     0.155     1.737     0.200
     0.155     1.885     0.200
     0.155     0.807     0.200
     0.506     0.928     0.200
     0.530     0.468     0.200
     0.519     0.287     0.200
     0.575     0.129     0.200
     0.712     0.299     0.200
     0.933    -0.068     0.200
     0.890     2.038     0.200
     0.948     0.050     0.200
     0.948    -0.270     0.200
     0.957    -0.061     0.200
     0.990    -0.680     0.200
     1.045     0.014     0.200
     1.194    -0.554     0.200
     1.194    -0.264     0.200
     1.194    -0.694     0.200
     0.190     1.405     0.200
     0.190     1.604     0.200
     0.484     0.534     0.200
     0.484     0.813     0.200
     0.497     0.318     0.200
     0.497     1.078     0.200
     0.560     0.398     0.200
     0.560     0.638     0.200
     0.565     0.417     0.200
     0.680     0.003     0.200
     0.842     0.865     0.200
     0.855     2.391     0.200
     0.938     1.520     0.200
     0.960     0.004     0.200
     0.962    -0.448     0.200
     0.962    -0.069     0.200
     0.974    -0.119     0.200
     1.159    -0.553     0.200
     1.195    -0.314     0.200
     0.237     1.161     0.200
     0.237     2.072     0.200
     0.391     0.752     0.200
     0.395     0.653     0.200
     0.449     0.384     0.200
     0.449     0.712     0.200
     0.689     0.258     0.200
     0.683     0.557     0.200
     0.683     0.455     0.200
     0.749     0.536     0.200
     0.749     1.075     0.200
     0.749     2.017     0.200
     0.749     0.286     0.200
     0.771     0.111     0.200
     0.985    -0.134     0.200
     0.985     0.878     0.200
     0.985     1.237     0.200
     1.022    -0.185     0.200
     1.048     0.167     0.200
     1.048    -0.521     0.200
     1.047    -0.572     0.200
     1.047    -0.272     0.200
     1.047    -0.940     0.200
     1.148    -0.862     0.200
     1.264    -1.325     0.200
     1.270    -1.271     0.200
     0.174     1.117     0.200
     0.174     1.539     0.200
     0.174     1.008     0.200
     0.365     0.468     0.200
     0.478     0.306     0.200
     0.496     0.386     0.200
     0.533     0.257     0.200
     0.523     0.517     0.200
     0.523     0.256     0.200
     0.683    -0.158     0.200
     0.733     0.503     0.200
     0.848     0.781     0.200
     0.919     0.197     0.200
     0.933     0.147     0.200
     0.968     0.191     0.200
     0.968    -0.122     0.200
     1.157    -0.284     0.200
     1.157    -1.284     0.200
     0.176     0.963     0.200
     0.495     0.584     0.200
     0.495     0.982     0.200
     0.503     0.686     0.200
     0.547     0.428     0.200
     0.547     0.799     0.200
     0.565     0.502     0.200
     0.691     0.513     0.200
     0.868     2.937     0.200
     0.953    -0.582     0.200
     0.922     2.713     0.200
     1.164    -0.085     0.200
     1.191     0.115     0.200
     1.191    -0.483     0.200
     1.210    -0.524     0.200
     1.281    -0.750     0.200
     1.465    -1.111     0.200
     0.293     0.752     0.200
     0.293     1.073     0.200
     0.293    -0.443     0.200
     0.282     0.875     0.200
     0.359     1.022     0.200
     0.446     0.708     0.200
     0.446     1.482     0.200
     0.502     0.488     0.200
     0.624     0.700     0.200
     0.624     1.880     0.200
     0.624     0.372     0.200
     0.640     0.831     0.200
     0.782     0.282     0.200
     0.813     0.380     0.200
     0.813    -0.003     0.200
     0.893     0.513     0.200
     0.893    -0.315     0.200
     0.993    -0.754     0.200
     1.053    -0.789     0.200
     1.018    -0.446     0.200
     1.025     0.018     0.200
     1.164    -0.159     0.200
     1.199    -1.482     0.200
     1.263    -0.914     0.200
     0.172     0.772     0.200
     0.172     1.952     0.200
     0.404    -0.810     0.200
     0.492     0.794     0.200
     0.492     1.294     0.200
     0.512     0.476     0.200
     0.538     0.501     0.200
     0.642     0.475     0.200
     0.698    -0.088     0.200
     0.774     0.369     0.200
     0.874     2.516     0.200
     0.880     2.684     0.200
     0.944    -0.191     0.200
     0.957    -0.435     0.200
     0.957     0.065     0.200
     0.968    -0.098     0.200
     0.976    -0.413     0.200
     1.199    -0.671     0.200
     1.199    -0.341     0.200
     1.199    -0.570     0.200
     0.148     2.032     0.200
     0.148     2.860     0.200
     0.148     2.192     0.200
     0.488    -0.109     0.200
     0.488     0.110     0.200
     0.634    -0.033     0.200
     0.634     0.717     0.200
     0.806    -0.571     0.200
     0.829     0.077     0.200
     0.829    -0.235     0.200
     1.022    -0.732     0.200
     1.294    -0.810     0.200
     2.096    -3.539     0.200
     2.323    -4.116     0.200
     2.339    -6.976     0.200
     0.164     0.821     0.200
     0.164     2.201     0.200
     0.164     1.371     0.200
     0.398    -0.722     0.200
     0.504     0.532     0.200
     0.504     0.932     0.200
     0.504     0.202     0.200
     0.509     0.602     0.200
     0.536     0.426     0.200
     0.637     0.696     0.200
     0.701     0.341     0.200
     0.765     1.154     0.200
     0.943    -0.292     0.200
     0.943    -0.471     0.200
     0.946     0.244     0.200
     0.957    -0.449     0.200
     0.979    -0.266     0.200
     1.189     0.063     0.200
     1.189    -1.077     0.200
     0.286     1.634     0.200
     0.384     1.159     0.200
     0.384     1.040     0.200
     0.397     0.612     0.200
     0.415     1.480     0.200
     0.520     0.257     0.200
     0.520     0.766     0.200
     0.507     0.532     0.200
     0.526     0.048     0.200
     0.678     0.405     0.200
     0.678     0.883     0.200
     0.678     0.155     0.200
     0.786    -0.106     0.200
     0.786     0.183     0.200
     0.786    -0.246     0.200
     0.917    -0.323     0.200
     0.926    -0.074     0.200
     0.946     0.136     0.200
     1.009    -0.573     0.200
     1.035    -0.682     0.200
     1.047    -0.023     0.200
     1.047    -0.232     0.200
     1.057    -0.604     0.200
     1.058     0.011     0.200
     1.109    -0.519     0.200
     1.107    -0.682     0.200
     1.199    -0.998     0.200
     1.199    -1.469     0.200
     0.198     0.933     0.200
     0.198     1.722     0.200
     0.198     0.671     0.200
     0.503     0.753     0.200
     0.503     0.503     0.200
     0.490     0.649     0.200
     0.490     1.290     0.200
     0.521     0.789     0.200
     0.561     0.301     0.200
     0.845     2.795     0.200
     0.897     3.269     0.200
     0.950     0.273     0.200
     0.943     1.443     0.200
     0.943     1.624     0.200
     0.965     0.222     0.200
     1.002     0.618     0.200
     1.117     0.549     0.200
     1.180     0.250     0.200
     1.180    -0.190     0.200
     1.189    -0.276     0.200
     1.269    -0.362     0.200
     1.269    -0.602     0.200
     1.330    -0.517     0.200
     1.452    -0.993     0.200
     0.371    -0.353     0.200
     0.371     0.280     0.200
     0.371     0.499     0.200
     0.371     0.069     0.200
     0.396     0.062     0.200
     0.396     0.749     0.200
     0.416     0.878     0.200
     0.563     0.992     0.200
     0.563     1.140     0.200
     0.592     1.153     0.200
     0.816     0.615     0.200
     0.915    -0.085     0.200
     0.950     3.696     0.200
     0.953     0.495     0.200
     0.997     0.130     0.200
     1.019     0.776     0.200
     1.094     0.922     0.200
     1.104    -0.310     0.200
     1.121    -0.576     0.200
     1.176    -0.486     0.200
     1.185     0.115     0.200
     0.172     1.573     0.200
     0.172     2.073     0.200
     0.451     1.360     0.200
     0.451     2.164     0.200
     0.451     0.914     0.200
     0.479     0.551     0.200
     0.479     0.809     0.200
     0.531     0.315     0.200
     0.560     0.194     0.200
     0.554     0.325     0.200
     0.976    -0.326     0.200
     0.985    -0.488     0.200
     1.220    -0.513     0.200
     0.249     0.655     0.200
     0.249     1.186     0.200
     0.383     0.772     0.200
     0.383     1.511     0.200
     0.383     1.253     0.200
     0.421     0.686     0.200
     0.633     1.435     0.200
     0.715     2.026     0.200
     0.760     0.231     0.200
     0.780     2.984     0.200
     0.823     1.774     0.200
     0.875     2.900     0.200
     0.989    -0.657     0.200
     0.957     1.489     0.200
     1.027     1.186     0.200
     1.200     0.032     0.200
     1.215    -0.322     0.200
     1.413     0.236     0.200
     1.413    -0.232     0.200
     1.413    -0.502     0.200
     0.165     1.363     0.200
     0.165     2.123     0.200
     0.165     0.783     0.200
     0.469     0.897     0.200
     0.469     1.798     0.200
     0.469     0.737     0.200
     0.497     0.390     0.200
     0.497     0.930     0.200
     0.516     0.653     0.200
     0.538     0.338     0.200
     0.939    -0.311     0.200
     0.939    -0.481     0.200
     0.955    -0.096     0.200
     0.964    -0.042     0.200
     1.176    -0.844     0.200
     1.198    -0.417     0.200
     0.273     0.856     0.200
     0.272     1.370     0.200
     0.272     1.979     0.200
     0.471     0.409     0.200
     0.634     0.870     0.200
     0.644     0.882     0.200
     0.711     0.656     0.200
     0.711     0.186     0.200
     0.810     0.426     0.200
     0.810    -0.044     0.200
     0.914     0.541     0.200
     0.914     0.002     0.200
     0.914    -0.507     0.200
     1.015    -0.182     0.200
     1.015    -0.622     0.200
     1.025    -0.279     0.200
     1.052    -0.352     0.200
     1.046    -0.167     0.200
     1.099    -0.778     0.200
     1.096    -0.229     0.200
     1.122    -0.733     0.200
     1.205    -0.349     0.200
     2.376    -4.098     0.200
     0.418     1.687     0.200
     0.422     0.565     0.200
     0.422     1.014     0.200
     0.485     1.144     0.200
     0.572     0.569     0.200
     0.572     1.178     0.200
     0.616     0.782     0.200
     0.616     1.731     0.200
     0.616     0.481     0.200
     0.714     0.283     0.200
     0.791    -0.059     0.200
     0.798    -0.061     0.200
     0.798    -0.280     0.200
     0.825    -0.102     0.200
     0.875     0.500     0.200
     0.904    -0.297     0.200
     0.933     0.142     0.200
     0.976    -0.845     0.200
     0.985    -0.474     0.200
     0.991    -0.277     0.200
     1.011    -0.725     0.200
     1.011    -0.475     0.200
     1.008    -0.644     0.200
     1.031    -0.362     0.200
     1.091    -1.143     0.200
     1.149    -0.856     0.200
     1.164    -0.648     0.200
     1.176    -1.507     0.200
     1.191    -1.494     0.200
     0.250     1.017     0.200
     0.250     1.297     0.200
     0.420     0.901     0.200
     0.382     0.909     0.200
     0.382     1.609     0.200
     0.382     0.779     0.200
     0.634     0.989     0.200
     0.774    -0.056     0.200
     0.717     3.060     0.200
     0.760     0.514     0.200
     0.781     2.579     0.200
     0.987    -0.128     0.200
     0.876     2.319     0.200
     1.199     0.075     0.200
     1.199    -0.305     0.200
     1.214    -0.217     0.200
     0.183     1.280     0.200
     0.183     2.190     0.200
     0.183     0.891     0.200
     0.466     0.220     0.200
     0.519     0.598     0.200
     0.539     1.356     0.200
     0.539     1.086     0.200
     0.547     1.016     0.200
     0.547     1.325     0.200
     0.547    -0.006     0.200
     0.838     1.555     0.200
     0.867     1.871     0.200
     0.946    -0.640     0.200
     0.988    -0.230     0.200
     1.109    -0.792     0.200
     1.126    -0.345     0.200
     1.151    -0.705     0.200
     0.237     1.514     0.200
     0.301     1.152     0.200
     0.301     1.541     0.200
     0.301     0.902     0.200
     0.411     0.410     0.200
     0.650     0.698     0.200
     0.650     1.589     0.200
     0.650     0.368     0.200
     0.675     0.608     0.200
     0.675     1.169     0.200
     0.736     0.078     0.200
     0.781    -0.085     0.200
     0.895    -0.299     0.200
     0.895    -0.449     0.200
     0.895    -0.679     0.200
     0.991    -0.547     0.200
     0.991    -0.998     0.200
     0.982    -0.635     0.200
     0.995    -0.712     0.200
     0.973    -0.446     0.200
     1.084    -1.012     0.200
     0.279     0.251     0.200
     0.279     0.612     0.200
     0.279     0.142     0.200
     0.544     0.971     0.200
     0.569     0.981     0.200
     0.569     1.201     0.200
     0.569     0.821     0.200
     1.007    -0.121     0.200
     1.007    -0.420     0.200
     1.016     0.306     0.200
     1.016     0.676     0.200
     1.104     0.508     0.200
     1.181    -0.001     0.200
     1.691    -2.850     0.200
     0.195     0.489     0.200
     0.195     1.309     0.200
     0.443     0.639     0.200
     0.464     0.347     0.200
     0.529     0.576     0.200
     0.547     0.843     0.200
     0.547     1.013     0.200
     0.542     0.319     0.200
     0.661     0.458     0.200
     0.855     2.603     0.200
     0.894    -0.136     0.200
     0.894     0.555     0.200
     0.912    -0.233     0.200
     0.886     2.611     0.200
     0.886     0.899     0.200
     0.897     3.087     0.200
     0.897     0.747     0.200
     0.909     0.790     0.200
     0.910     2.540     0.200
     0.974     0.910     0.200
     0.999    -0.202     0.200
     1.083     0.445     0.200
     1.101    -0.286     0.200
     1.101    -0.165     0.200
     1.124     0.147     0.200
     1.124     0.317     0.200
     1.124    -0.513     0.200
     1.144    -0.048     0.200
     1.144     0.083     0.200
     1.213    -0.596     0.200
     3.188    -8.771     0.200
     0.193     0.617     0.200
     0.193     1.178     0.200
     0.447     0.629     0.200
     0.469     0.338     0.200
     0.531     0.303     0.200
     0.542     0.980     0.200
     0.537     0.324     0.200
     0.537     0.452     0.200
     0.542     1.110     0.200
     0.662     0.160     0.200
     0.827     1.405     0.200
     0.855     2.910     0.200
     0.899     0.256     0.200
     0.899     0.407     0.200
     0.884     0.634     0.200
     0.897     0.593     0.200
     0.916     0.140     0.200
     0.911     0.806     0.200
     0.912     0.786     0.200
     0.936     0.350     0.200
     0.977     0.617     0.200
     0.996    -0.121     0.200
     0.996    -0.432     0.200
     1.105    -0.230     0.200
     1.105    -0.351     0.200
     1.129    -0.042     0.200
     1.129     0.188     0.200
     1.218    -0.814     0.200
     4.222   -11.851     0.200
     0.209     0.548     0.200
     0.209     1.118     0.200
     0.432     1.058     0.200
     0.464     1.137     0.200
     0.535     0.374     0.200
     0.555     0.719     0.200
     0.555     0.950     0.200
     0.542     0.334     0.200
     0.646     1.355     0.200
     0.812     1.286     0.200
     0.841     3.619     0.200
     0.873     3.134     0.200
     0.873     1.240     0.200
     0.882     3.429     0.200
     0.882     1.249     0.200
     0.895     0.972     0.200
     0.920     1.421     0.200
     0.898     0.577     0.200
     0.898     0.356     0.200
     0.918     0.285     0.200
     0.962     0.880     0.200
     1.012    -0.436     0.200
     1.012    -0.597     0.200
     1.043     1.257     0.200
     1.070     0.469     0.200
     1.091     0.692     0.200
     1.136     0.756     0.200
     1.136     0.361     0.200
     1.122    -0.147     0.200
     1.122     0.144     0.200
     1.122     0.334     0.200
     1.211    -0.018     0.200
     1.211    -0.287     0.200
     1.296     0.049     0.200
     1.273    -0.095     0.200
     1.393    -0.396     0.200
     1.393    -0.855     0.200
     2.051    -2.668     0.200
     0.201     0.989     0.200
     0.201     1.848     0.200
     0.431     0.684     0.200
     0.449     0.594     0.200
     0.525     0.644     0.200
     0.554     0.373     0.200
     0.554     0.271     0.200
     0.562     0.460     0.200
     0.562     1.234     0.200
     0.562     0.671     0.200
     0.854     3.174     0.200
     0.880     0.464     0.200
     0.880     0.652     0.200
     0.890     2.684     0.200
     0.900     0.735     0.200
     1.009    -0.319     0.200
     1.009     0.291     0.200
     1.009    -0.537     0.200
     1.071     1.022     0.200
     1.087    -0.122     0.200
     1.108     0.166     0.200
     1.108     0.299     0.200
     1.129     0.425     0.200
     1.197    -0.530     0.200
     1.381    -0.809     0.200
     1.382    -0.929     0.200
     1.571    -1.406     0.200
     0.193     0.865     0.200
     0.193     2.174     0.200
     0.528     0.384     0.200
     0.463     0.414     0.200
     0.444     0.430     0.200
     0.547     1.004     0.200
     0.543     0.409     0.200
     0.893     0.064     0.200
     0.911     0.261     0.200
     0.998    -0.198     0.200
     0.998    -0.327     0.200
     0.857     2.673     0.200
     0.911     2.592     0.200
     0.898     2.622     0.200
     0.935     1.177     0.200
     1.123     0.323     0.200
     1.123     0.142     0.200
     1.084     0.736     0.200
     1.212    -0.553     0.200
     1.276    -0.193     0.200
     0.243     0.937     0.200
     0.244     0.666     0.200
     0.387     0.941     0.200
     0.387     1.402     0.200
     0.387     0.609     0.200
     0.407     1.069     0.200
     0.407     1.280     0.200
     0.651     0.097     0.200
     0.696     0.619     0.200
     0.723     2.976     0.200
     0.779     0.100     0.200
     0.792     2.365     0.200
     0.838     1.382     0.200
     0.977    -0.002     0.200
     0.977    -0.943     0.200
     0.979     0.436     0.200
     1.428    -1.506     0.200
     1.511    -2.574     0.200
     0.288     1.306     0.200
     0.288     1.736     0.200
     0.365     0.341     0.200
     0.366     0.687     0.200
     0.533     0.898     0.200
     0.633     0.658     0.200
     0.672     0.299     0.200
     0.672     0.680     0.200
     0.644     0.400     0.200
     0.768     2.912     0.200
     0.787     2.830     0.200
     0.800     2.055     0.200
     0.861     2.703     0.200
     0.925     2.412     0.200
     0.992    -0.219     0.200
     1.027     1.462     0.200
     1.089     0.341     0.200
     1.288     0.269     0.200
     1.372    -0.625     0.200
     1.426    -1.226     0.200
     0.182     1.176     0.200
     0.182     2.156     0.200
     0.468     0.394     0.200
     0.468     1.512     0.200
     0.490     0.447     0.200
     0.533     0.529     0.200
     0.520     1.283     0.200
     0.520     0.951     0.200
     0.524     0.577     0.200
     0.931    -0.026     0.200
     0.931     0.154     0.200
     0.978    -0.031     0.200
     1.150    -0.286     0.200
     1.240    -0.763     0.200
     1.240    -1.184     0.200
     3.161    -8.134     0.200
     0.186     0.709     0.200
     0.186     1.978     0.200
     0.186     0.369     0.200
     0.462     0.697     0.200
     0.484     0.417     0.200
     0.533     0.148     0.200
     0.533     0.527     0.200
     0.527     0.580     0.200
     0.528     0.488     0.200
     0.927     0.887     0.200
     0.984     0.101     0.200
     0.991     0.351     0.200
     1.120    -0.646     0.200
     1.144     0.008     0.200
     1.144    -0.321     0.200
     1.234    -0.745     0.200
     1.234    -1.265     0.200
     0.286     0.441     0.200
     0.287     1.023     0.200
     0.287     1.433     0.200
     0.345     0.917     0.200
     0.345     1.460     0.200
     0.345     1.058     0.200
     0.383     0.625     0.200
     0.383     1.363     0.200
     0.383     1.984     0.200
     0.645     0.712     0.200
     0.737    -0.068     0.200
     0.737     0.084     0.200
     0.714     0.279     0.200
     0.762     2.559     0.200
     0.822     2.477     0.200
     0.822     2.938     0.200
     0.861     1.289     0.200
     0.945    -0.614     0.200
     0.945    -0.196     0.200
     1.190    -0.611     0.200
     1.190    -0.501     0.200
     2.053    -3.731     0.200
     0.167     1.197     0.200
     0.167     1.568     0.200
     0.167     0.827     0.200
     0.475     0.602     0.200
     0.475     1.292     0.200
     0.475     0.352     0.200
     0.498     0.606     0.200
     0.499     0.575     0.200
     0.499     0.205     0.200
     0.510     1.078     0.200
     0.510     0.408     0.200
     0.540     0.493     0.200
     0.700     0.533     0.200
     0.863     1.865     0.200
     0.944    -0.534     0.200
     0.944     0.396     0.200
     0.944    -0.824     0.200
     0.962     0.203     0.200
     1.170     0.663     0.200
     1.193    -0.358     0.200
     1.193     0.133     0.200
     1.216    -0.094     0.200
     1.284    -0.653     0.200
     1.349    -0.390     0.200
     1.468    -0.964     0.200
     1.470    -1.220     0.200
     0.561     0.333     0.200
     0.561     0.892     0.200
     0.562     0.054     0.200
     0.562     0.753     0.200
     0.560     0.645     0.200
     0.560     1.465     0.200
     0.644     0.462     0.200
     0.734    -0.166     0.200
     0.734    -0.348     0.200
     0.759    -0.301     0.200
     0.769    -0.376     0.200
     0.794    -0.182     0.200
     0.806    -0.409     0.200
     0.822    -0.650     0.200
     0.916    -1.524     0.200
     1.770    -4.082     0.200
     0.320     0.636     0.200
     0.320     1.516     0.200
     0.320     0.766     0.200
     0.322     0.549     0.200
     0.322     0.799     0.200
     0.325     1.209     0.200
     0.325     1.718     0.200
     0.693     0.558     0.200
     0.713     0.042     0.200
     0.771     0.316     0.200
     0.777     0.422     0.200
     0.882    -0.252     0.200
     1.189    -0.359     0.200
     1.430    -0.513     0.200
     0.321     0.930     0.200
     0.321     1.410     0.200
     0.321     2.020     0.200
     0.321     0.789     0.200
     0.315     0.658     0.200
     0.316     0.619     0.200
     0.316     0.967     0.200
     0.332     1.063     0.200
     0.332     1.652     0.200
     0.719    -0.024     0.200
     0.696     0.677     0.200
     0.885    -0.210     0.200
     0.815     2.778     0.200
     0.777     0.333     0.200
     0.776     0.166     0.200
     0.883     2.896     0.200
     1.056     0.025     0.200
     1.195    -0.509     0.200
     1.435    -0.720     0.200
     0.293     0.691     0.200
     0.293     0.640     0.200
     0.339     1.045     0.200
     0.339     1.795     0.200
     0.339     1.245     0.200
     0.381     0.716     0.200
     0.381     1.188     0.200
     0.381     0.587     0.200
     0.644     0.386     0.200
     0.716     0.543     0.200
     0.730     0.349     0.200
     0.745     0.522     0.200
     0.767     2.699     0.200
     0.863     1.475     0.200
     0.918     1.558     0.200
     0.941    -0.545     0.200
     0.941     0.205     0.200
     0.941     0.346     0.200
     1.184    -0.489     0.200
     1.184    -0.349     0.200
     1.401    -0.423     0.200
     0.178     1.466     0.200
     0.178     1.267     0.200
     0.178     1.696     0.200
     0.442     1.076     0.200
     0.468     0.595     0.200
     0.469     0.514     0.200
     0.540     0.530     0.200
     0.572     0.391     0.200
     0.562     0.498     0.200
     0.562     0.389     0.200
     0.712     0.207     0.200
     0.873     1.791     0.200
     0.873     1.388     0.200
     0.879     2.366     0.200
     0.926     0.291     0.200
     0.926     0.819     0.200
     0.997     0.575     0.200
     0.997    -0.097     0.200
     1.202    -0.590     0.200
     1.202    -0.727     0.200
     1.232    -0.260     0.200
     1.530    -2.985     0.200
     0.184     1.457     0.200
     0.184     1.086     0.200
     0.184     1.617     0.200
     0.469     0.655     0.200
     0.470     0.930     0.200
     0.470     0.563     0.200
     0.456     0.441     0.200
     0.456     1.023     0.200
     0.456     1.542     0.200
     0.526     0.055     0.200
     0.526     0.247     0.200
     0.526     0.536     0.200
     0.562     0.537     0.200
     0.562     1.166     0.200
     0.565     0.550     0.200
     0.565    -0.000     0.200
     0.699     1.257     0.200
     0.867     2.481     0.200
     0.861     1.615     0.200
     0.861     2.057     0.200
     0.868     2.465     0.200
     0.939    -0.655     0.200
     0.939    -0.002     0.200
     0.993    -0.057     0.200
     0.993    -0.506     0.200
     1.237    -0.793     0.200
     1.222    -0.010     0.200
     1.222     0.830     0.200
     1.312    -0.693     0.200
     1.312    -0.919     0.200
     0.181     1.177     0.200
     0.452     0.793     0.200
     0.452     0.672     0.200
     0.471     0.452     0.200
     0.471     0.066     0.200
     0.530     0.503     0.200
     0.563     0.523     0.200
     0.564     0.578     0.200
     0.870     1.955     0.200
     0.935    -0.087     0.200
     0.935     0.484     0.200
     0.935     0.585     0.200
     0.935    -0.735     0.200
     0.993    -0.097     0.200
     1.191    -0.720     0.200
     1.224    -0.198     0.200
     1.224    -0.358     0.200
     1.314    -1.095     0.200
     1.524    -3.332     0.200
     0.183     1.198     0.200
     0.183     1.698     0.200
     0.450     1.367     0.200
     0.450     0.598     0.200
     0.467     0.740     0.200
     0.468     0.871     0.200
     0.468     0.590     0.200
     0.532     0.353     0.200
     0.532     0.236     0.200
     0.565     0.413     0.200
     0.567     0.486     0.200
     0.703     0.539     0.200
     0.865     1.615     0.200
     0.871     2.407     0.200
     0.934     0.262     0.200
     0.934     0.672     0.200
     0.934    -0.637     0.200
     0.996    -0.189     0.200
     1.168    -0.184     0.200
     1.194    -0.550     0.200
     1.227    -0.523     0.200
     1.227    -0.414     0.200
     1.227    -0.742     0.200
     1.242    -0.966     0.200
     1.317    -1.048     0.200
     1.317    -1.169     0.200
     0.447     0.894     0.200
     0.447     0.652     0.200
     0.476     0.565     0.200
     0.535     0.242     0.200
     0.555     0.517     0.200
     0.564     0.503     0.200
     0.879     2.785     0.200
     0.927     0.135     0.200
     0.927    -0.314     0.200
     0.989     0.416     0.200
     0.989    -0.354     0.200
     1.057     0.903     0.200
     1.197    -0.507     0.200
     1.225    -0.071     0.200
     1.315    -1.236     0.200
     0.183     0.976     0.200
     0.183     1.496     0.200
     0.453     1.324     0.200
     0.453     0.535     0.200
     0.469     0.430     0.200
     0.565     0.330     0.200
     0.528     0.359     0.200
     0.564     0.613     0.200
     0.937     0.240     0.200
     0.937     0.040     0.200
     0.980     0.424     0.200
     0.994    -0.381     0.200
     1.224     0.007     0.200
     1.224    -0.614     0.200
     1.239    -0.977     0.200
     1.314    -1.277     0.200
     0.191     1.094     0.200
     0.471     0.816     0.200
     0.473     0.635     0.200
     0.510     0.937     0.200
     0.550     0.662     0.200
     0.567     0.415     0.200
     0.686     0.406     0.200
     0.954    -0.553     0.200
     0.954    -0.154     0.200
     0.964     3.294     0.200
     0.986     0.891     0.200
     1.172     0.053     0.200
     1.172    -0.158     0.200
     1.210    -0.042     0.200
     1.210     0.657     0.200
     1.221    -0.262     0.200
     1.299    -0.417     0.200
     1.299    -0.303     0.200
     1.362    -0.596     0.200
     1.483    -0.737     0.200
     0.183     1.301     0.200
     0.458     0.738     0.200
     0.458     0.609     0.200
     0.471     0.802     0.200
     0.471     0.482     0.200
     0.524     0.329     0.200
     0.560     0.989     0.200
     0.563     0.174     0.200
     0.698    -0.064     0.200
     0.698     0.597     0.200
     0.860     1.983     0.200
     0.940     0.020     0.200
     0.991     0.681     0.200
     1.186    -0.016     0.200
     1.220    -0.166     0.200
     1.220     0.377     0.200
     1.310    -0.686     0.200
     1.310    -0.955     0.200
     0.183     1.377     0.200
     0.183     1.064     0.200
     0.183     1.564     0.200
     0.456     0.556     0.200
     0.456     0.795     0.200
     0.456     1.377     0.200
     0.471     0.622     0.200
     0.471     0.560     0.200
     0.525     0.509     0.200
     0.525     0.318     0.200
     0.561     0.198     0.200
     0.561     0.846     0.200
     0.561     1.108     0.200
     0.563     0.518     0.200
     0.563    -0.135     0.200
     0.700     0.046     0.200
     0.861     1.843     0.200
     0.869     2.272     0.200
     0.939    -0.881     0.200
     0.939     0.107     0.200
     0.939     0.497     0.200
     0.991    -0.114     0.200
     1.187    -0.874     0.200
     1.221    -0.420     0.200
     1.221    -0.150     0.200
     1.236    -0.802     0.200
     1.311    -1.352     0.200
     0.183     1.406     0.200
     0.450     0.745     0.200
     0.466     0.862     0.200
     0.467     1.239     0.200
     0.467     1.341     0.200
     0.532     0.813     0.200
     0.532     0.383     0.200
     0.566     0.438     0.200
     0.566     0.309     0.200
     0.568     0.269     0.200
     0.703     1.328     0.200
     0.703    -0.254     0.200
     0.865     1.706     0.200
     0.871     1.972     0.200
     0.868     1.403     0.200
     0.934     0.018     0.200
     0.934    -0.482     0.200
     0.996    -0.158     0.200
     0.996    -0.646     0.200
     1.052     0.417     0.200
     1.194    -0.795     0.200
     1.228    -0.185     0.200
     1.228    -0.588     0.200
     1.228    -0.865     0.200
     1.243    -0.971     0.200
     1.318    -1.443     0.200
     1.503    -2.222     0.200
     1.522    -4.230     0.200
     0.181     0.928     0.200
     0.181     1.758     0.200
     0.181     2.178     0.200
     0.445     1.088     0.200
     0.467     0.969     0.200
     0.571     0.012     0.200
     0.571     0.942     0.200
     0.565     0.238     0.200
     0.929     0.175     0.200
     1.174    -0.203     0.200
     1.199    -1.079     0.200
     1.232    -0.048     0.200
     1.232    -0.298     0.200
     1.322    -1.151     0.200
     1.526    -3.388     0.200
     3.079    -6.368     0.200
     0.184     1.249     0.200
     0.184     1.620     0.200
     0.447     0.856     0.200
     0.465     0.324     0.200
     0.567     0.278     0.200
     0.534     0.438     0.200
     0.571     0.281     0.200
     0.933    -0.196     0.200
     0.933    -0.065     0.200
     0.999     0.136     0.200
     1.196    -0.272     0.200
     1.231    -0.947     0.200
     1.231    -0.146     0.200
     0.195     1.471     0.200
     0.467     0.660     0.200
     0.467     0.929     0.200
     0.465     0.500     0.200
     0.514    -0.167     0.200
     0.557     0.431     0.200
     0.685     0.105     0.200
     0.953    -0.493     0.200
     0.953    -0.895     0.200
     0.947     1.491     0.200
     1.033    -0.046     0.200
     1.176    -0.792     0.200
     1.176    -1.304     0.200
     1.217    -0.121     0.200
     1.226    -1.132     0.200
     0.174     0.934     0.200
     0.174     1.402     0.200
     0.452     0.768     0.200
     0.452     1.881     0.200
     0.452     0.190     0.200
     0.477     0.544     0.200
     0.531     0.606     0.200
     0.556     0.229     0.200
     0.556     0.889     0.200
     0.561     0.365     0.200
     0.931    -0.208     0.200
     0.931    -0.470     0.200
     0.987    -0.317     0.200
     1.221     0.210     0.200
     1.221    -0.380     0.200
     1.311    -1.091     0.200
     0.070     1.180     0.200
     0.070     1.411     0.200
     0.487     1.004     0.200
     0.487     0.215     0.200
     0.504     0.830     0.200
     0.628     0.592     0.200
     0.701     0.334     0.200
     0.814     0.164     0.200
     0.812     0.950     0.200
     1.142     0.507     0.200
     1.142    -0.384     0.200
     1.160    -0.497     0.200
     1.252    -1.076     0.200
     1.245    -0.645     0.200
     1.455    -1.476     0.200
     1.843    -2.374     0.200
     2.222    -3.269     0.200
     0.135     1.064     0.200
     0.135     1.514     0.200
     0.437     0.703     0.200
     0.437     0.832     0.200
     0.508     0.859     0.200
     0.508     1.468     0.200
     0.552     0.581     0.200
     0.552     0.769     0.200
     0.552     1.312     0.200
     0.556     0.318     0.200
     0.900    -0.416     0.200
     0.900     1.064     0.200
     0.965    -0.054     0.200
     1.216    -0.472     0.200
     1.309    -1.169     0.200
     1.569    -4.357     0.200
     0.180     1.227     0.200
     0.458     1.167     0.200
     0.458     1.007     0.200
     0.475     0.476     0.200
     0.475     0.535     0.200
     0.475     0.236     0.200
     0.524     0.708     0.200
     0.524     0.419     0.200
     0.560     0.690     0.200
     0.560     0.430     0.200
     0.557     0.239     0.200
     0.700     1.580     0.200
     0.700    -0.131     0.200
     0.862     1.650     0.200
     0.872     2.280     0.200
     0.939    -0.021     0.200
     0.939    -0.421     0.200
     0.987    -0.095     0.200
     1.186    -0.715     0.200
     1.218    -0.818     0.200
     1.218    -0.949     0.200
     1.234    -0.941     0.200
     1.308    -1.437     0.200
     1.371    -1.334     0.200
     0.186     1.494     0.200
     0.186     1.015     0.200
     0.186     2.045     0.200
     0.466     0.959     0.200
     0.466     1.069     0.200
     0.473     0.581     0.200
     0.474     0.589     0.200
     0.516     0.658     0.200
     0.516     0.868     0.200
     0.563     0.568     0.200
     0.563     0.318     0.200
     0.553     0.335     0.200
     0.866     2.666     0.200
     0.863     1.440     0.200
     0.854     2.382     0.200
     0.947    -0.650     0.200
     0.947     0.350     0.200
     0.986    -0.418     0.200
     1.213    -0.596     0.200
     1.213    -0.356     0.200
     1.303    -0.970     0.200
     1.303    -1.220     0.200
     1.516    -3.425     0.200
     0.187     1.113     0.200
     0.187     0.434     0.200
     0.187     1.344     0.200
     0.187     1.804     0.200
     0.466     0.809     0.200
     0.472     0.572     0.200
     0.473     0.790     0.200
     0.473     0.510     0.200
     0.515     0.256     0.200
     0.553     0.136     0.200
     0.564     0.387     0.200
     0.691     0.501     0.200
     0.853     2.270     0.200
     0.853     1.020     0.200
     0.948    -0.088     0.200
     0.948    -0.198     0.200
     0.948     0.362     0.200
     0.987     0.430     0.200
     1.036     0.376     0.200
     1.036     0.476     0.200
     1.152    -0.100     0.200
     1.177    -0.916     0.200
     1.177    -0.716     0.200
     1.213    -0.924     0.200
     1.213     0.606     0.200
     1.213    -0.294     0.200
     1.303    -1.055     0.200
     0.186     1.130     0.200
     0.474     0.548     0.200
     0.478     0.366     0.200
     0.479     0.784     0.200
     0.479    -0.145     0.200
     0.508     0.770     0.200
     0.545     0.281     0.200
     0.561     0.396     0.200
     0.687     1.011     0.200
     0.687     0.752     0.200
     0.850     2.287     0.200
     0.850     2.127     0.200
     0.860     2.560     0.200
     0.866     2.830     0.200
     0.866     1.277     0.200
     0.953    -0.433     0.200
     0.953    -0.904     0.200
     0.980     0.084     0.200
     0.966     0.271     0.200
     0.966     1.002     0.200
     1.145     0.682     0.200
     1.170     0.196     0.200
     1.205     0.653     0.200
     1.205    -0.949     0.200
     1.218    -0.335     0.200
     1.294    -0.647     0.200
     1.478    -1.115     0.200
     1.478    -1.294     0.200
     3.108    -6.052     0.200
     0.178     1.343     0.200
     0.461     0.979     0.200
     0.479     0.660     0.200
     0.479     0.372     0.200
     0.479    -0.010     0.200
     0.521     0.134     0.200
     0.553    -0.140     0.200
     0.556     0.294     0.200
     0.700     1.025     0.200
     0.700    -0.178     0.200
     0.862     1.660     0.200
     0.871     2.488     0.200
     0.874     2.416     0.200
     0.874     2.476     0.200
     0.940    -0.506     0.200
     0.983    -0.139     0.200
     1.043     0.124     0.200
     1.183    -0.708     0.200
     1.213    -0.998     0.200
     1.213    -0.388     0.200
     1.230    -1.095     0.200
     3.097    -5.668     0.200
     0.180     1.144     0.200
     0.180     0.816     0.200
     0.474     0.284     0.200
     0.474     0.104     0.200
     0.485     0.663     0.200
     0.486     0.340     0.200
     0.486    -0.031     0.200
     0.509     0.637     0.200
     0.541     0.341     0.200
     0.554     0.230     0.200
     0.554     0.601     0.200
     0.691     0.692     0.200
     0.691    -0.050     0.200
     0.854     2.408     0.200
     0.872     2.635     0.200
     0.921     2.904     0.200
     0.974    -0.059     0.200
     0.970     0.949     0.200
     1.201    -0.255     0.200
     1.291    -1.196     0.200
     0.181     1.134     0.200
     0.454     0.832     0.200
     0.454     0.393     0.200
     0.470     0.661     0.200
     0.471     0.629     0.200
     0.471     0.799     0.200
     0.528     0.808     0.200
     0.562     0.813     0.200
     0.562     0.473     0.200
     0.563     0.691     0.200
     0.864     2.404     0.200
     0.870     2.750     0.200
     0.870     2.447     0.200
     0.871     3.155     0.200
     0.936    -0.127     0.200
     0.936    -1.168     0.200
     0.930     3.243     0.200
     0.992     0.225     0.200
     0.992     0.424     0.200
     1.049     0.760     0.200
     1.223     0.215     0.200
     1.313    -0.664     0.200
     0.177     1.320     0.200
     0.177     1.009     0.200
     0.177     1.558     0.200
     0.450     1.284     0.200
     0.450     1.114     0.200
     0.473     0.505     0.200
     0.474     0.472     0.200
     0.474     1.142     0.200
     0.474     0.333     0.200
     0.559     0.162     0.200
     0.559     0.451     0.200
     0.559     0.592     0.200
     0.532     0.318     0.200
     0.563     0.246     0.200
     0.707     0.534     0.200
     0.869     1.982     0.200
     0.875     2.866     0.200
     0.876     2.040     0.200
     0.932    -0.330     0.200
     0.932    -0.130     0.200
     0.990    -0.082     0.200
     0.990    -0.582     0.200
     1.169    -0.488     0.200
     1.193    -0.347     0.200
     1.224    -0.515     0.200
     1.224    -0.195     0.200
     1.241    -1.066     0.200
     1.314    -1.164     0.200
     0.181     1.117     0.200
     0.181     1.828     0.200
     0.460     0.863     0.200
     0.460     0.374     0.200
     0.474     0.577     0.200
     0.475     0.568     0.200
     0.522     0.288     0.200
     0.556     0.225     0.200
     0.560     0.410     0.200
     0.698    -0.132     0.200
     0.861     1.439     0.200
     0.869     2.862     0.200
     0.941    -0.216     0.200
     0.941    -0.076     0.200
     0.987    -0.464     0.200
     0.987    -0.054     0.200
     1.184    -0.695     0.200
     1.216    -0.650     0.200
     1.216    -0.248     0.200
     1.306    -1.185     0.200
     1.306    -1.314     0.200
     1.522    -3.584     0.200
     0.182     1.403     0.200
     0.182     1.684     0.200
     0.465     0.928     0.200
     0.465     1.167     0.200
     0.477     0.613     0.200
     0.477     0.369     0.200
     0.517     0.161     0.200
     0.517    -0.281     0.200
     0.560     0.305     0.200
     0.560     0.653     0.200
     0.552     0.188     0.200
     0.695     1.133     0.200
     0.867     2.621     0.200
     0.945    -0.041     0.200
     0.945    -0.158     0.200
     0.974     0.406     0.200
     0.983    -0.180     0.200
     1.179    -0.684     0.200
     1.212    -0.456     0.200
     1.302    -0.998     0.200
     0.182     0.824     0.200
     0.182     0.722     0.200
     0.182     1.714     0.200
     0.465     0.828     0.200
     0.465     1.199     0.200
     0.477     0.662     0.200
     0.477     0.411     0.200
     0.517     0.167     0.200
     0.551     0.170     0.200
     0.560     0.477     0.200
     0.560     0.235     0.200
     0.695     0.318     0.200
     0.857     1.403     0.200
     0.866     2.646     0.200
     0.869     2.565     0.200
     0.945    -0.168     0.200
     0.945     0.019     0.200
     0.945     0.910     0.200
     0.945    -1.211     0.200
     0.983    -0.456     0.200
     1.154    -0.100     0.200
     1.179    -0.848     0.200
     1.212    -0.324     0.200
     1.227    -0.752     0.200
     1.301    -1.843     0.200
     1.480    -2.383     0.200
     0.105     1.412     0.200
     0.422    -0.130     0.200
     0.422     1.440     0.200
     0.487     0.924     0.200
     0.487     1.315     0.200
     0.556     0.741     0.200
     0.556     1.726     0.200
     0.583     0.126     0.200
     0.636     0.094     0.200
     0.636     0.196     0.200
     0.636     0.930     0.200
     0.636     1.040     0.200
     0.728     0.005     0.200
     0.732    -0.581     0.200
     0.732    -0.308     0.200
     0.740    -0.440     0.200
     0.758    -0.563     0.200
     0.758    -0.272     0.200
     0.801    -0.432     0.200
     0.840    -0.824     0.200
     0.856    -0.914     0.200
     0.869    -0.156     0.200
     0.911    -1.030     0.200
     0.940    -0.764     0.200
     0.973    -0.436     0.200
     1.028    -1.257     0.200
     1.032    -0.405     0.200
     1.467    -2.910     0.200
     1.612    -4.196     0.200
     1.698    -2.875     0.200
     1.836    -3.242     0.200
     1.963    -4.512     0.200
     0.192     0.459     0.200
     0.192     1.241     0.200
     0.475     0.663     0.200
     0.474     0.656     0.200
     0.474     0.964     0.200
     0.506     0.811     0.200
     0.547     0.433     0.200
     0.566     0.417     0.200
     0.957    -0.613     0.200
     0.957    -0.464     0.200
     0.984     0.164     0.200
     1.168    -0.271     0.200
     1.207     0.063     0.200
     1.207    -0.347     0.200
     1.296    -0.468     0.200
     1.479    -1.096     0.200
     1.479    -0.936     0.200
     0.175     1.317     0.200
     0.175     1.535     0.200
     0.456     1.044     0.200
     0.456     0.845     0.200
     0.478     0.627     0.200
     0.478     0.445     0.200
     0.478     0.777     0.200
     0.478     1.035     0.200
     0.526     0.169     0.200
     0.526     0.356     0.200
     0.555     0.376     0.200
     0.555     0.247     0.200
     0.704     0.975     0.200
     0.867     1.603     0.200
     0.876     2.396     0.200
     0.933     0.761     0.200
     0.935     0.024     0.200
     0.935    -0.125     0.200
     0.984    -0.190     0.200
     0.984    -0.081     0.200
     1.188    -0.508     0.200
     1.188    -0.790     0.200
     1.217    -0.567     0.200
     1.217    -0.899     0.200
     1.308    -1.516     0.200
     1.528    -3.627     0.200
     1.696    -4.219     0.200
     0.183     0.688     0.200
     0.183     1.750     0.200
     0.471     0.956     0.200
     0.480     0.506     0.200
     0.481     0.430     0.200
     0.481     0.845     0.200
     0.511     1.084     0.200
     0.511     0.732     0.200
     0.546     0.428     0.200
     0.546     0.960     0.200
     0.558     0.252     0.200
     0.558     0.424     0.200
     0.691     1.429     0.200
     0.691     0.015     0.200
     0.864     2.745     0.200
     0.869     2.900     0.200
     0.921     2.517     0.200
     0.949    -0.353     0.200
     0.949     0.210     0.200
     0.949     0.936     0.200
     0.979    -0.071     0.200
     1.296    -0.717     0.200
     1.359    -0.824     0.200
     2.223    -3.816     0.200
     0.464     0.578     0.200
     0.565    -0.344     0.200
     0.471     0.585     0.200
     0.472     0.572     0.200
     0.518     0.685     0.200
     0.863     2.154     0.200
     0.865     2.587     0.200
     0.865     2.595     0.200
     0.921     3.017     0.200
     1.081     1.105     0.200
     1.155     0.523     0.200
     1.180     0.532     0.200
     1.228    -0.332     0.200
     1.305    -0.875     0.200
     1.368    -0.410     0.200
     1.489    -1.745     0.200
     0.340     1.151     0.200
     0.267     0.765     0.200
     0.267     1.066     0.200
     0.468     0.408     0.200
     0.468     0.306     0.200
     0.468     0.877     0.200
     0.651     0.358     0.200
     0.707    -0.008     0.200
     0.707     0.101     0.200
     0.707     1.742     0.200
     0.803     0.507     0.200
     0.804     0.177     0.200
     0.798     0.002     0.200
     0.798     0.103     0.200
     0.918     0.280     0.200
     0.918     0.542     0.200
     1.019    -0.173     0.200
     1.019    -0.552     0.200
     0.994     0.585     0.200
     1.053    -0.339     0.200
     1.046    -0.762     0.200
     1.046    -0.414     0.200
     1.103    -0.709     0.200
     1.103    -0.819     0.200
     1.098    -0.264     0.200
     1.069    -0.024     0.200
     1.124    -0.746     0.200
     1.226    -0.916     0.200
     1.226    -1.229     0.200
     0.339     1.082     0.200
     0.339     1.352     0.200
     0.202     1.082     0.200
     0.439     0.613     0.200
     0.366     0.931     0.200
     0.665     0.082     0.200
     0.772     0.257     0.200
     0.797     0.871     0.200
     0.888     0.398     0.200
     0.956    -0.470     0.200
     0.943    -0.774     0.200
     0.955     0.140     0.200
     0.955    -0.600     0.200
     1.011     0.069     0.200
     1.030    -0.866     0.200
     1.143    -0.573     0.200
     1.153    -1.251     0.200
     1.153    -1.011     0.200
     1.534    -3.039     0.200
     0.186     0.821     0.200
     0.186     1.974     0.200
     0.186     1.290     0.200
     0.476     0.646     0.200
     0.477     0.882     0.200
     0.477     1.273     0.200
     0.470     1.432     0.200
     0.470     1.081     0.200
     0.512     0.225     0.200
     0.512     0.506     0.200
     0.549     0.330     0.200
     0.549     0.920     0.200
     0.549     0.190     0.200
     0.562     0.180     0.200
     0.690     0.322     0.200
     0.690    -0.030     0.200
     0.690     1.681     0.200
     0.862     2.702     0.200
     0.866     2.838     0.200
     0.971    -0.415     0.200
     0.983    -0.019     0.200
     1.209     0.152     0.200
     1.209    -0.430     0.200
     1.298    -0.862     0.200
     1.298    -1.182     0.200
     0.191     1.041     0.200
     0.191     1.471     0.200
     0.476     0.527     0.200
     0.477     0.475     0.200
     0.477     0.916     0.200
     0.478     0.576     0.200
     0.504     0.577     0.200
     0.544     0.359     0.200
     0.565     0.101     0.200
     0.565     0.601     0.200
     0.682     0.436     0.200
     0.855     2.629     0.200
     0.911     2.525     0.200
     0.968     0.347     0.200
     0.981     0.054     0.200
     1.166    -0.486     0.200
     1.204     0.025     0.200
     1.293    -0.683     0.200
     1.509    -3.458     0.200
     0.186     1.156     0.200
     0.186     2.355     0.200
     0.186     1.457     0.200
     0.468     0.947     0.200
     0.468     1.729     0.200
     0.475     0.646     0.200
     0.476     0.503     0.200
     0.514     0.423     0.200
     0.514     0.224     0.200
     0.550     0.133     0.200
     0.562     0.415     0.200
     0.562     0.567     0.200
     0.691     0.311     0.200
     0.853     2.195     0.200
     0.973    -0.127     0.200
     0.984    -0.094     0.200
     0.984    -0.867     0.200
     1.175    -0.805     0.200
     1.210     0.025     0.200
     1.210    -0.655     0.200
     1.224    -1.021     0.200
     1.516    -3.635     0.200
     0.275     0.648     0.200
     0.275     1.528     0.200
     0.264     0.902     0.200
     0.264     1.271     0.200
     0.264     1.391     0.200
     0.354     0.715     0.200
     0.354     0.854     0.200
     0.456     0.710     0.200
     0.456     0.870     0.200
     0.650     0.499     0.200
     0.650     0.649     0.200
     0.662     0.591     0.200
     0.662     0.371     0.200
     0.704     0.091     0.200
     0.704     0.850     0.200
     0.783     0.499     0.200
     0.791     0.086     0.200
     0.792     0.084     0.200
     0.921     0.335     0.200
     1.021    -0.417     0.200
     1.039    -1.034     0.200
     1.039    -0.354     0.200
     1.048    -0.124     0.200
     1.104    -0.690     0.200
     1.104    -0.551     0.200
     1.123    -0.593     0.200
     1.211    -0.968     0.200
     1.678    -4.883     0.200
EOF
gmt end
