#!/bin/bash
gmt begin alberchigos1.34_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional alberchigos1.34'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.500    42.782
    15.000    42.503
    15.500    42.223
    16.000    41.938
    16.500    41.649
    17.000    41.353
    17.500    41.048
    18.000    40.734
    18.500    40.407
    19.000    40.065
    19.500    39.707
    20.000    39.330
    20.500    38.932
    21.000    38.510
    21.500    38.062
    22.000    37.587
    22.500    37.082
    23.000    36.545
    23.500    35.975
    24.000    34.768
    24.500    33.496
    25.000    32.215
    25.500    30.923
    26.000    29.620
    26.500    28.306
    27.000    26.979
    27.500    25.636
    28.000    24.273
    28.500    22.895
    29.000    21.505
    29.500    20.106
    30.000    18.700
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    21.273 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     8.754
     1.500     9.914
     2.000    11.075
     2.500    12.235
     3.000    13.395
     3.500    14.555
     4.000    15.713
     4.500    16.870
     5.000    18.027
     5.500    19.182
     6.000    20.336
     6.500    21.489
     7.000    22.640
     7.500    23.790
     8.000    24.937
     8.500    26.083
     9.000    27.227
     9.500    28.369
    10.000    29.508
    10.500    30.493
    11.000    31.431
    11.500    32.350
    12.000    33.245
    12.500    34.114
    13.000    34.953
    13.500    35.764
    14.000    36.541
    14.500    37.286
    15.000    37.996
    15.500    38.673
    16.000    39.240
    16.500    39.740
    17.000    40.179
    17.500    39.893
    18.000    40.242
    18.500    40.532
    19.000    40.764
    19.500    40.938
    20.000    41.053
    20.500    41.110
    21.000    41.107
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    31.953 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     1.000     6.756
     1.500    10.195
     2.000    13.633
     2.500    17.071
     3.000    20.509
     3.500    23.947
     4.000    27.386
     4.500    30.824
     5.000    34.262
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    30.386 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     3.887
     1.000     6.987
     1.500     9.685
     2.000    12.382
     2.500    15.080
     3.000    17.776
     3.500    20.472
     4.000    23.167
     4.500    25.860
     5.000    28.552
     5.500    31.242
     6.000    33.932
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.552 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    23.066
     1.500    29.565
     2.000    36.065
     2.500    42.565
     3.000    49.064
     3.500    55.561
     4.000    62.055
     4.500    68.547
     5.000    75.035
     5.500    81.520
     6.000    88.001
     6.500    94.477
     7.000   100.948
     7.500   107.415
     8.000   113.875
     8.500   120.329
     9.000   126.776
     9.500   133.218
    10.000   139.651
    10.500   146.076
    11.000   152.493
    11.500   158.902
    12.000   165.301
    12.500   171.691
    13.000   178.073
    13.500   184.444
    14.000   190.804
    14.500   197.155
    15.000   203.493
    15.500   209.821
    16.000   216.136
    16.500   222.439
    17.000   228.728
    17.500   234.754
    18.000   241.026
    18.500   247.286
    19.000   253.532
    19.500   259.765
    20.000   265.985
    20.500   272.189
    21.000   278.379
    21.500   284.554
    22.000   290.714
    22.500   296.857
    23.000   302.984
    23.500   309.094
    24.000   315.187
    24.500   321.263
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    60.055 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    10.749
     1.000    19.962
     1.500    28.533
     2.000    37.104
     2.500    45.675
     3.000    54.243
     3.500    62.811
     4.000    71.376
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    60.811 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     1.000    18.997
     1.500    28.980
     2.000    38.963
     2.500    48.946
     3.000    58.929
     3.500    68.913
     4.000    78.896
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    60.929 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
     2.088   917.162     0.150
    17.110    49.029     0.150
    17.409    47.258     0.150
    17.105    46.785     0.150
    15.538    48.453     0.150
    17.419    49.475     0.150
     2.449   909.325     0.150
    17.029   347.801     0.150
    17.015    44.518     0.150
    14.517   210.467     0.150
    23.813   479.232     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.183    40.538     0.200
    14.973    40.689     0.200
    15.160    40.033     0.200
    15.503    41.780     0.200
    15.589    39.587     0.200
    15.733    41.701     0.200
    15.978    41.151     0.200
    16.110    42.046     0.200
    16.162    41.304     0.200
    16.178    41.334     0.200
    16.264    41.725     0.200
    16.495    41.301     0.200
    16.563    41.225     0.200
    16.990    42.861     0.200
    17.387    41.508     0.200
    17.639    40.871     0.200
    21.942    39.929     0.200
    22.325    40.198     0.200
    22.797    38.868     0.200
    22.797    39.368     0.200
    23.835    37.756     0.200
    27.508    26.750     0.200
    28.363    23.912     0.200
    28.363    24.612     0.200
    29.257    22.799     0.200
    29.512    25.621     0.200
    17.037    43.863     0.200
    23.632    35.996     0.200
    14.753    43.646     0.200
    15.753    41.388     0.200
    24.024    35.947     0.200
    28.914    24.992     0.200
    14.521    40.521     0.200
    14.715    41.797     0.200
    14.721    41.911     0.200
    15.754    42.714     0.200
    16.173    42.086     0.200
    16.279    41.681     0.200
    16.686    42.282     0.200
    16.843    43.726     0.200
    17.000    43.017     0.200
    21.240    41.872     0.200
    23.994    36.998     0.200
    28.886    24.904     0.200
    29.260    23.842     0.200
    14.142    42.111     0.200
    14.799    45.426     0.200
    16.027    47.475     0.200
    16.147    46.186     0.200
    16.251    43.359     0.200
    16.342    46.671     0.200
    16.733    47.541     0.200
    16.778    47.000     0.200
    16.809    45.082     0.200
    16.921    44.158     0.200
    17.060    42.567     0.200
    22.216    41.035     0.200
    24.058    36.865     0.200
    16.366    40.320     0.200
    16.535    42.353     0.200
    16.679    41.365     0.200
    16.679    43.756     0.200
    16.846    42.131     0.200
    20.952    38.429     0.200
    22.518    41.365     0.200
    28.580    25.298     0.200
    16.408    43.599     0.200
    16.425    43.234     0.200
    17.302    42.437     0.200
    19.202    40.915     0.200
    23.861    36.483     0.200
    28.199    24.186     0.200
    28.285    23.524     0.200
    14.340    45.012     0.200
    16.723    43.305     0.200
    21.465    42.017     0.200
    14.262    46.062     0.200
    14.733    43.818     0.200
    15.584    43.246     0.200
    15.723    43.516     0.200
    17.002    43.010     0.200
    17.002    44.057     0.200
    17.288    44.544     0.200
    17.319    45.095     0.200
    17.808    45.046     0.200
    14.270    40.911     0.200
    14.349    40.798     0.200
    14.362    41.262     0.200
    14.363    41.497     0.200
    14.429    40.631     0.200
    14.555    42.692     0.200
    14.737    40.913     0.200
    14.849    41.225     0.200
    14.899    41.014     0.200
    14.901    42.238     0.200
    14.920    41.753     0.200
    14.949    42.105     0.200
    14.990    41.216     0.200
    15.090    41.422     0.200
    15.130    41.761     0.200
    15.178    41.255     0.200
    15.333    42.455     0.200
    15.412    41.828     0.200
    15.455    42.823     0.200
    15.476    42.411     0.200
    15.476    41.300     0.200
    15.588    42.869     0.200
    15.636    42.639     0.200
    15.726    42.872     0.200
    15.792    41.713     0.200
    15.909    42.650     0.200
    15.909    42.876     0.200
    16.015    41.872     0.200
    16.054    42.519     0.200
    16.321    42.442     0.200
    16.484    42.304     0.200
    16.567    42.440     0.200
    17.003    43.365     0.200
    17.121    43.520     0.200
    17.317    43.498     0.200
    17.324    43.653     0.200
    17.324    43.150     0.200
    17.328    44.278     0.200
    17.431    43.748     0.200
    17.449    42.453     0.200
    17.915    43.484     0.200
    18.021    42.578     0.200
    18.069    41.897     0.200
    18.096    46.108     0.200
    18.100    43.937     0.200
    18.347    46.068     0.200
    18.362    45.737     0.200
    18.394    43.817     0.200
    21.567    40.263     0.200
    21.995    40.745     0.200
    23.578    39.410     0.200
    23.617    38.444     0.200
    15.582    43.661     0.200
    15.720    41.709     0.200
    14.234    43.860     0.200
    14.228    42.147     0.200
    14.276    42.106     0.200
    14.306    42.318     0.200
    14.367    42.314     0.200
    14.633    43.542     0.200
    14.648    43.285     0.200
    14.709    42.529     0.200
    14.709    46.380     0.200
    14.745    43.412     0.200
    14.908    42.475     0.200
    14.925    44.131     0.200
    15.134    42.972     0.200
    15.340    42.125     0.200
    15.595    43.518     0.200
    15.595    43.788     0.200
    15.567    42.956     0.200
    15.734    43.569     0.200
    15.768    47.841     0.200
    16.170    47.173     0.200
    16.431    47.767     0.200
    16.575    44.009     0.200
    16.624    45.193     0.200
    17.010    44.829     0.200
    17.010    43.609     0.200
    17.010    42.454     0.200
    17.037    42.476     0.200
    17.295    45.051     0.200
    17.332    44.989     0.200
    17.700    46.594     0.200
    18.029    46.001     0.200
    18.102    45.872     0.200
    18.171    45.639     0.200
    18.338    46.158     0.200
    21.124    43.405     0.200
    21.447    40.200     0.200
    21.575    40.827     0.200
    21.631    41.642     0.200
    22.003    44.194     0.200
    22.807    40.063     0.200
    23.578    37.807     0.200
    24.040    37.645     0.200
    26.898    29.262     0.200
    28.883    25.456     0.200
    14.283    42.152     0.200
    14.582    41.304     0.200
    14.754    41.093     0.200
    15.744    43.181     0.200
    15.796    41.482     0.200
    16.048    43.010     0.200
    16.585    43.306     0.200
    17.021    41.175     0.200
    14.234    43.347     0.200
    14.297    41.194     0.200
    14.304    41.072     0.200
    14.420    41.745     0.200
    14.595    42.752     0.200
    14.636    42.562     0.200
    14.699    43.819     0.200
    14.902    43.737     0.200
    15.163    42.097     0.200
    15.186    42.054     0.200
    15.394    42.406     0.200
    15.591    42.374     0.200
    15.591    42.968     0.200
    15.729    43.216     0.200
    15.922    44.011     0.200
    16.340    42.341     0.200
    17.009    43.010     0.200
    17.025    42.303     0.200
    17.025    42.635     0.200
    17.065    42.356     0.200
    18.315    46.393     0.200
    18.380    46.068     0.200
    18.807    41.609     0.200
    20.715    41.305     0.200
    21.111    38.186     0.200
    21.998    42.762     0.200
    22.509    38.579     0.200
    22.894    38.091     0.200
    23.304    37.073     0.200
    23.357    37.146     0.200
    23.444    37.569     0.200
    23.959    35.699     0.200
    24.025    35.812     0.200
    24.304    35.121     0.200
    24.812    33.355     0.200
    14.117    41.550     0.200
    14.694    42.448     0.200
    15.834    41.992     0.200
    15.834    45.062     0.200
    15.908    42.566     0.200
    16.161    42.141     0.200
    16.387    43.462     0.200
    16.870    44.492     0.200
    17.048    42.324     0.200
    17.958    42.482     0.200
    17.972    42.700     0.200
    18.066    42.500     0.200
    18.130    44.402     0.200
    18.193    43.027     0.200
    18.198    42.922     0.200
    18.369    42.814     0.200
    18.648    40.085     0.200
    17.017    43.874     0.200
    14.276    42.710     0.200
    14.473    47.143     0.200
    14.732    43.366     0.200
    15.394    45.494     0.200
    15.494    43.807     0.200
    15.545    45.696     0.200
    15.597    43.322     0.200
    15.605    45.052     0.200
    15.775    46.612     0.200
    15.927    44.022     0.200
    16.167    47.475     0.200
    16.271    45.679     0.200
    16.427    47.109     0.200
    16.492    43.141     0.200
    16.576    44.228     0.200
    17.010    44.158     0.200
    17.140    44.748     0.200
    17.294    43.997     0.200
    17.335    44.934     0.200
    17.820    45.046     0.200
    22.004    42.850     0.200
    23.588    38.593     0.200
    24.047    36.291     0.200
    14.355    42.550     0.200
    14.570    41.192     0.200
    15.514    47.140     0.200
    15.744    42.882     0.200
    16.501    42.692     0.200
    16.586    42.234     0.200
    16.632    41.499     0.200
    17.023    44.631     0.200
    17.023    44.217     0.200
    17.040    41.425     0.200
    17.310    45.163     0.200
    17.829    46.101     0.200
    24.039    37.562     0.200
    24.039    37.886     0.200
    23.940    35.806     0.200
    19.085    37.800     0.200
    14.082    42.231     0.200
    14.349    45.576     0.200
    14.817    41.182     0.200
    14.819    44.743     0.200
    17.037    45.430     0.200
    17.626    43.154     0.200
    21.072    45.449     0.200
    24.196    35.895     0.200
    28.858    23.438     0.200
    14.305    41.150     0.200
    14.575    44.922     0.200
    14.604    41.420     0.200
    14.720    42.637     0.200
    14.804    41.650     0.200
    15.087    41.959     0.200
    15.244    41.766     0.200
    15.246    41.865     0.200
    15.388    43.257     0.200
    15.643    42.571     0.200
    15.727    41.457     0.200
    15.748    43.466     0.200
    16.137    43.465     0.200
    16.769    42.249     0.200
    17.029    43.469     0.200
    17.029    43.805     0.200
    17.091    43.420     0.200
    17.147    42.226     0.200
    17.179    44.073     0.200
    17.248    45.326     0.200
    17.295    42.625     0.200
    17.340    43.377     0.200
    17.399    43.311     0.200
    17.399    43.496     0.200
    17.411    44.051     0.200
    17.411    43.863     0.200
    17.516    43.145     0.200
    17.605    43.246     0.200
    17.644    43.931     0.200
    18.135    43.554     0.200
    18.135    45.511     0.200
    18.205    43.409     0.200
    18.939    41.292     0.200
    21.052    41.663     0.200
    21.263    41.386     0.200
    21.370    41.213     0.200
    21.370    41.848     0.200
    21.512    39.530     0.200
    21.614    42.275     0.200
    21.614    42.130     0.200
    22.478    39.195     0.200
    22.799    39.132     0.200
    23.411    39.032     0.200
    23.466    40.079     0.200
    23.743    39.457     0.200
    23.833    38.159     0.200
    23.833    37.604     0.200
    24.179    36.174     0.200
    24.179    35.024     0.200
    24.179    35.305     0.200
    24.522    36.587     0.200
    24.764    35.642     0.200
    24.991    34.401     0.200
    24.999    33.998     0.200
    25.072    34.313     0.200
    25.252    34.718     0.200
    25.252    35.950     0.200
    25.379    33.484     0.200
    25.408    32.828     0.200
    25.497    32.492     0.200
    25.509    33.834     0.200
    25.743    32.470     0.200
    25.781    31.427     0.200
    25.853    32.566     0.200
    26.030    31.642     0.200
    26.088    31.417     0.200
    26.094    31.316     0.200
    26.147    31.426     0.200
    26.235    31.162     0.200
    26.259    30.713     0.200
    26.292    31.031     0.200
    26.304    31.727     0.200
    26.305    30.653     0.200
    26.422    31.449     0.200
    26.422    32.316     0.200
    26.431    31.275     0.200
    26.463    30.819     0.200
    26.520    30.862     0.200
    26.641    30.600     0.200
    26.647    29.997     0.200
    26.671    30.958     0.200
    26.751    29.079     0.200
    26.922    29.812     0.200
    26.924    29.672     0.200
    26.988    28.694     0.200
    27.023    29.947     0.200
    27.023    30.066     0.200
    27.028    27.889     0.200
    27.038    28.208     0.200
    27.066    28.367     0.200
    27.110    28.165     0.200
    27.255    28.373     0.200
    27.302    27.892     0.200
    27.305    27.190     0.200
    27.320    28.596     0.200
    27.322    28.113     0.200
    27.341    27.183     0.200
    27.360    27.360     0.200
    27.371    27.913     0.200
    27.381    28.364     0.200
    27.448    27.536     0.200
    27.448    28.131     0.200
    27.457    26.563     0.200
    27.539    27.407     0.200
    27.560    28.394     0.200
    27.573    27.493     0.200
    27.613    27.583     0.200
    27.634    27.381     0.200
    27.638    27.931     0.200
    27.745    27.998     0.200
    27.777    26.899     0.200
    27.893    26.649     0.200
    27.910    26.300     0.200
    27.984    25.777     0.200
    28.026    25.801     0.200
    28.064    25.404     0.200
    28.069    24.682     0.200
    28.086    26.377     0.200
    28.629    24.421     0.200
    28.747    23.506     0.200
    28.838    24.117     0.200
    28.898    23.633     0.200
    28.902    24.951     0.200
    28.924    24.201     0.200
    29.036    23.927     0.200
    29.113    23.723     0.200
    29.130    23.448     0.200
    29.190    22.312     0.200
    29.320    22.642     0.200
    29.393    22.245     0.200
    29.409    22.181     0.200
    29.485    21.862     0.200
    29.536    22.006     0.200
    29.583    22.530     0.200
    29.584    22.680     0.200
    29.762    21.995     0.200
    29.767    21.810     0.200
    29.778    21.150     0.200
    29.828    21.176     0.200
    29.908    19.987     0.200
    29.956    19.516     0.200
    29.976    18.589     0.200
    14.100    40.895     0.200
    14.152    41.056     0.200
    14.383    42.063     0.200
    14.472    41.058     0.200
    14.479    41.425     0.200
    14.527    41.265     0.200
    14.724    46.020     0.200
    14.876    41.979     0.200
    14.970    42.484     0.200
    15.085    41.412     0.200
    15.142    41.650     0.200
    15.330    41.917     0.200
    15.355    42.526     0.200
    15.437    42.320     0.200
    16.174    44.153     0.200
    16.195    45.136     0.200
    16.225    42.838     0.200
    16.372    41.686     0.200
    16.749    42.987     0.200
    16.749    42.633     0.200
    16.780    42.340     0.200
    17.039    42.858     0.200
    17.068    43.979     0.200
    17.139    42.528     0.200
    17.241    41.911     0.200
    17.395    42.499     0.200
    17.519    42.622     0.200
    17.554    43.478     0.200
    17.855    42.407     0.200
    18.273    42.137     0.200
    18.360    42.405     0.200
    18.360    43.299     0.200
    18.572    41.330     0.200
    18.601    41.226     0.200
    18.725    41.685     0.200
    19.339    41.542     0.200
    19.347    40.409     0.200
    19.483    39.730     0.200
    19.829    40.752     0.200
    19.854    41.128     0.200
    20.015    40.905     0.200
    20.366    39.812     0.200
    20.705    40.704     0.200
    20.742    40.448     0.200
    20.815    39.974     0.200
    20.948    40.768     0.200
    20.976    39.973     0.200
    21.023    39.363     0.200
    21.023    39.931     0.200
    21.130    39.765     0.200
    21.221    41.765     0.200
    21.275    40.398     0.200
    21.325    40.986     0.200
    21.325    40.812     0.200
    21.461    40.360     0.200
    21.472    39.965     0.200
    21.646    39.493     0.200
    21.947    39.495     0.200
    22.057    41.415     0.200
    22.163    39.618     0.200
    22.163    39.014     0.200
    22.230    38.947     0.200
    22.312    40.381     0.200
    22.304    40.307     0.200
    22.359    39.242     0.200
    22.418    38.134     0.200
    22.418    39.279     0.200
    22.481    38.424     0.200
    22.481    39.039     0.200
    22.523    39.077     0.200
    22.550    37.984     0.200
    22.571    38.679     0.200
    22.663    38.627     0.200
    22.897    37.665     0.200
    23.050    37.778     0.200
    23.093    36.900     0.200
    23.093    39.430     0.200
    23.191    38.186     0.200
    23.216    38.146     0.200
    23.266    37.698     0.200
    23.313    38.070     0.200
    23.504    38.100     0.200
    23.504    38.272     0.200
    23.568    36.734     0.200
    23.625    38.249     0.200
    23.689    37.568     0.200
    23.799    36.746     0.200
    23.799    37.946     0.200
    23.866    36.946     0.200
    24.065    36.021     0.200
    24.116    35.501     0.200
    24.144    36.433     0.200
    24.222    34.340     0.200
    24.222    36.668     0.200
    24.305    36.313     0.200
    24.382    34.948     0.200
    24.382    36.542     0.200
    24.640    34.954     0.200
    24.640    36.165     0.200
    24.661    35.115     0.200
    24.715    35.117     0.200
    24.858    34.708     0.200
    24.908    32.750     0.200
    24.908    34.336     0.200
    24.938    34.692     0.200
    25.025    32.892     0.200
    25.100    33.430     0.200
    25.139    33.881     0.200
    25.177    34.507     0.200
    25.298    33.199     0.200
    25.532    32.015     0.200
    25.725    32.373     0.200
    25.793    32.906     0.200
    25.919    30.290     0.200
    25.957    31.185     0.200
    26.135    32.869     0.200
    26.165    30.502     0.200
    26.177    30.756     0.200
    26.315    29.966     0.200
    26.612    29.902     0.200
    26.668    29.889     0.200
    26.683    29.420     0.200
    26.770    28.195     0.200
    26.785    28.295     0.200
    26.929    28.483     0.200
    26.974    28.897     0.200
    27.142    27.960     0.200
    27.290    27.511     0.200
    27.488    27.411     0.200
    27.560    27.211     0.200
    27.568    26.909     0.200
    27.714    27.082     0.200
    28.082    25.366     0.200
    28.290    22.761     0.200
    28.290    25.068     0.200
    28.366    22.923     0.200
    28.413    25.596     0.200
    28.638    24.323     0.200
    28.638    25.658     0.200
    28.690    22.592     0.200
    28.792    22.395     0.200
    28.863    23.342     0.200
    28.904    22.812     0.200
    29.068    19.691     0.200
    29.125    22.321     0.200
    29.473    23.289     0.200
    29.493    18.509     0.200
    29.527    21.203     0.200
    29.617    21.223     0.200
    16.051    41.985     0.200
    16.162    42.536     0.200
    16.604    42.155     0.200
    17.368    42.917     0.200
    17.465    44.952     0.200
    17.465    43.819     0.200
    17.779    43.181     0.200
    19.544    35.344     0.200
    19.691    35.393     0.200
    19.689    36.266     0.200
    19.856    36.364     0.200
    20.643    35.192     0.200
    20.701    35.934     0.200
    21.141    34.813     0.200
    21.149    42.277     0.200
    21.375    39.977     0.200
    21.980    33.243     0.200
    22.957    38.298     0.200
    23.092    38.336     0.200
    23.263    32.610     0.200
    23.349    37.765     0.200
    24.433    34.795     0.200
    27.053    27.706     0.200
    16.952    43.122     0.200
    27.085    25.257     0.200
    16.370    42.439     0.200
    20.985    39.450     0.200
    23.571    36.943     0.200
    23.571    37.045     0.200
    15.562    42.106     0.200
    16.225    44.081     0.200
    16.972    42.149     0.200
    21.133    38.485     0.200
    24.032    34.935     0.200
    24.084    33.125     0.200
    25.312    32.411     0.200
    16.073    39.486     0.200
    16.544    43.563     0.200
    17.535    39.780     0.200
    15.686    43.360     0.200
    16.775    43.732     0.200
    16.775    44.107     0.200
    19.643    37.981     0.200
    20.288    36.309     0.200
    20.752    36.449     0.200
    21.031    41.745     0.200
    22.500    41.757     0.200
    23.510    38.335     0.200
    23.819    38.331     0.200
    24.721    30.269     0.200
    25.163    35.470     0.200
    27.146    29.031     0.200
    29.069    17.530     0.200
    20.286    38.579     0.200
    21.030    38.903     0.200
    21.030    42.755     0.200
    21.472    38.600     0.200
    22.494    40.740     0.200
    22.588    41.634     0.200
    23.679    40.985     0.200
    23.813    38.732     0.200
    24.458    33.512     0.200
    24.621    37.510     0.200
    24.914    37.841     0.200
    25.156    35.022     0.200
    26.980    32.578     0.200
    27.146    31.959     0.200
    28.655    24.699     0.200
    14.991    40.700     0.200
    15.484    45.797     0.200
    16.630    41.420     0.200
    17.261    43.067     0.200
    17.891    40.785     0.200
    18.590    39.800     0.200
    18.911    40.106     0.200
    20.279    38.971     0.200
    20.302    39.369     0.200
    20.718    38.461     0.200
    20.764    38.382     0.200
    22.709    36.305     0.200
    23.112    35.905     0.200
    24.931    32.238     0.200
    27.600    24.550     0.200
    15.450    42.329     0.200
    16.264    40.871     0.200
    16.269    41.676     0.200
    17.533    41.425     0.200
    19.329    39.630     0.200
    21.474    38.394     0.200
    22.504    38.046     0.200
    23.825    36.516     0.200
    24.468    32.785     0.200
    21.023    39.814     0.200
    23.232    36.380     0.200
    23.833    36.967     0.200
    24.475    32.542     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     1.546     8.000     0.200
     1.700     9.078     0.200
     1.700     9.478     0.200
     1.917     9.361     0.200
     2.049    10.317     0.200
     2.291    10.175     0.200
     2.291    11.075     0.200
     2.468    11.789     0.200
     2.528     9.589     0.200
     2.694    12.334     0.200
     2.770    12.457     0.200
     2.807    12.197     0.200
     3.165    13.797     0.200
     3.571    14.240     0.200
     3.941    15.356     0.200
     4.021    14.942     0.200
     4.132    16.212     0.200
     4.220    14.665     0.200
     4.220    15.465     0.200
     4.350    16.144     0.200
     4.384    17.094     0.200
     4.414    16.200     0.200
     4.749    16.138     0.200
     4.860    17.218     0.200
     5.159    17.563     0.200
     5.269    17.959     0.200
     5.299    18.073     0.200
     5.395    15.947     0.200
     5.395    16.747     0.200
     5.433    18.843     0.200
     5.442    18.121     0.200
     5.608    18.401     0.200
     5.644    18.511     0.200
     5.675    19.089     0.200
     5.773    19.013     0.200
     5.806    18.607     0.200
     5.828    19.718     0.200
     6.290    18.505     0.200
     6.290    18.804     0.200
     6.299    22.686     0.200
     6.324    22.061     0.200
     6.364    21.497     0.200
     6.427    21.907     0.200
     6.427    22.207     0.200
     6.400    21.224     0.200
     6.400    21.724     0.200
     6.484    20.994     0.200
     6.651    19.527     0.200
     6.651    20.096     0.200
     6.667    19.110     0.200
     6.667    20.010     0.200
     6.714    21.397     0.200
     6.796    22.250     0.200
     6.948    20.827     0.200
     7.037    20.786     0.200
     7.037    20.986     0.200
     7.133    20.669     0.200
     7.133    20.969     0.200
     7.138    21.007     0.200
     7.164    22.302     0.200
     7.164    22.602     0.200
     7.211    21.163     0.200
     7.313    20.997     0.200
     7.400    22.079     0.200
     7.444    23.041     0.200
     7.444    23.341     0.200
     7.466    23.788     0.200
     7.466    24.488     0.200
     7.896    22.177     0.200
     8.503    23.761     0.200
     8.634    26.794     0.200
     8.685    24.554     0.200
     8.685    25.354     0.200
     8.785    28.645     0.200
     8.827    26.898     0.200
     8.827    27.497     0.200
     8.824    28.300     0.200
     8.914    25.888     0.200
     8.914    26.288     0.200
     9.113    28.356     0.200
     9.142    28.377     0.200
     9.482    28.271     0.200
    10.347    30.162     0.200
    10.347    30.962     0.200
    10.603    31.857     0.200
    10.621    32.469     0.200
    11.012    28.996     0.200
    11.783    33.400     0.200
    11.783    34.100     0.200
    11.905    34.982     0.200
    11.905    35.182     0.200
    13.731    40.416     0.200
    13.940    40.190     0.200
    14.197    38.496     0.200
    15.589    38.598     0.200
    15.568    38.272     0.200
    15.568    39.331     0.200
    15.676    39.045     0.200
    20.206    43.602     0.200
     1.676     7.868     0.200
     1.950     9.430     0.200
     2.009     8.862     0.200
     2.206    10.134     0.200
     2.453    10.953     0.200
     2.818    10.913     0.200
     2.886    10.893     0.200
     3.646    14.527     0.200
     3.787    15.440     0.200
     4.012    15.096     0.200
     4.100    16.617     0.200
     4.265    16.485     0.200
     4.440    17.142     0.200
     5.009    18.062     0.200
     6.285    21.268     0.200
     6.463    21.339     0.200
     7.318    25.971     0.200
     8.347    26.718     0.200
     8.348    25.483     0.200
     8.451    26.346     0.200
     8.553    28.119     0.200
     8.597    28.050     0.200
     8.907    28.895     0.200
     9.342    29.206     0.200
    10.647    30.538     0.200
    12.012    34.708     0.200
     1.659    10.414     0.200
     1.651     8.671     0.200
     1.732    10.590     0.200
     1.985    11.268     0.200
     2.461    10.689     0.200
     2.523    12.121     0.200
     3.604    15.050     0.200
     4.221    17.762     0.200
     4.796    17.582     0.200
     5.278    19.393     0.200
     5.707    20.733     0.200
     6.194    21.789     0.200
     6.259    21.863     0.200
     6.936    23.668     0.200
     7.463    23.122     0.200
     8.508    27.003     0.200
     8.920    28.204     0.200
     8.970    29.000     0.200
     9.206    30.122     0.200
     9.270    29.580     0.200
     9.342    30.468     0.200
     9.518    30.692     0.200
     9.543    31.676     0.200
    10.494    31.153     0.200
    11.780    35.766     0.200
    12.461    35.796     0.200
    14.538    38.931     0.200
    18.780    46.126     0.200
     1.619     8.309     0.200
     1.668    10.227     0.200
     1.678     8.323     0.200
     1.961    11.243     0.200
     2.435    11.196     0.200
     2.841    12.747     0.200
     3.590    13.577     0.200
     3.580    16.163     0.200
     3.864    14.228     0.200
     4.211    16.541     0.200
     4.190    15.815     0.200
     4.774    17.898     0.200
     4.861    18.362     0.200
     5.252    18.489     0.200
     5.677    21.012     0.200
     5.822    19.870     0.200
     6.162    22.482     0.200
     6.227    21.869     0.200
     6.534    22.882     0.200
     6.727    23.240     0.200
     6.907    22.884     0.200
     7.436    21.634     0.200
     7.738    27.270     0.200
     8.486    26.672     0.200
     8.600    27.963     0.200
     8.841    29.168     0.200
     8.890    27.726     0.200
     8.940    29.223     0.200
     9.174    29.396     0.200
     9.241    29.050     0.200
     9.314    29.298     0.200
     9.357    30.868     0.200
     9.446    27.472     0.200
     9.489    30.207     0.200
     9.514    32.266     0.200
     9.764    33.013     0.200
    10.489    30.998     0.200
    11.392    35.164     0.200
    11.890    36.280     0.200
    12.429    36.860     0.200
    12.429    35.558     0.200
    13.781    37.458     0.200
    18.764    43.834     0.200
     1.761     9.370     0.200
     2.268    11.942     0.200
     2.987    13.996     0.200
     3.053    13.958     0.200
     4.201    15.829     0.200
     4.209    13.489     0.200
     4.408    16.253     0.200
     5.300    19.500     0.200
     5.934    23.654     0.200
     6.177    21.662     0.200
     6.304    21.921     0.200
     6.294    22.253     0.200
     6.826    24.297     0.200
     7.216    26.345     0.200
     8.320    26.857     0.200
     8.357    27.334     0.200
     8.473    27.340     0.200
     8.515    28.329     0.200
     8.616    28.116     0.200
     8.829    30.565     0.200
     9.238    30.000     0.200
    10.692    31.372     0.200
    11.909    34.971     0.200
    15.275    40.526     0.200
    16.074    38.544     0.200
    18.713    42.204     0.200
     1.688     9.334     0.200
     2.117    13.326     0.200
     2.259    14.759     0.200
     2.771    16.535     0.200
     3.656    17.021     0.200
     3.654    18.655     0.200
     4.237    15.036     0.200
     4.845    20.777     0.200
     5.059    19.386     0.200
     5.328    20.723     0.200
     5.756    21.787     0.200
     5.885    21.067     0.200
     6.234    21.842     0.200
     6.301    22.520     0.200
     6.610    24.951     0.200
     6.802    23.720     0.200
     6.893    25.512     0.200
     6.985    24.496     0.200
     7.810    27.693     0.200
     8.519    26.705     0.200
     8.521    26.136     0.200
     8.909    29.718     0.200
     8.952    29.056     0.200
     9.250    32.692     0.200
     9.302    31.196     0.200
     9.428    31.260     0.200
     9.525    30.169     0.200
     9.545    31.403     0.200
     9.837    31.186     0.200
     9.836    32.954     0.200
    10.793    34.076     0.200
    10.874    34.191     0.200
    11.470    36.787     0.200
    11.807    34.543     0.200
    12.081    37.499     0.200
    12.501    38.337     0.200
    12.705    37.585     0.200
    13.948    40.811     0.200
    14.541    39.334     0.200
    14.794    41.935     0.200
    14.852    40.961     0.200
    15.787    40.676     0.200
    16.765    42.177     0.200
    18.781    43.741     0.200
     1.573     7.630     0.200
     2.134     9.508     0.200
     3.342    12.553     0.200
     3.483    14.906     0.200
     3.719    12.295     0.200
     3.826    14.122     0.200
     4.131    13.008     0.200
     4.077    15.952     0.200
     4.449    16.071     0.200
     4.712    16.144     0.200
     5.243    18.204     0.200
     5.357    18.765     0.200
     5.856    20.223     0.200
     6.240    21.492     0.200
     6.622    22.556     0.200
     7.079    20.351     0.200
     7.130    23.032     0.200
     7.164    23.066     0.200
     7.411    24.468     0.200
     7.430    24.829     0.200
     7.533    22.845     0.200
     7.613    22.700     0.200
     7.670    22.207     0.200
     7.941    22.701     0.200
     8.327    24.264     0.200
     8.399    26.116     0.200
     8.620    26.771     0.200
     8.687    27.293     0.200
     8.800    27.921     0.200
     8.856    26.860     0.200
     8.985    25.660     0.200
     8.978    25.682     0.200
     9.090    26.963     0.200
     9.111    27.681     0.200
     9.262    28.146     0.200
     9.455    29.384     0.200
     9.549    27.389     0.200
     9.522    28.217     0.200
     9.574    30.267     0.200
     9.961    28.877     0.200
    10.009    29.036     0.200
    10.306    29.101     0.200
    10.522    29.858     0.200
    10.485    31.156     0.200
    11.079    30.798     0.200
    11.498    32.919     0.200
    11.970    35.452     0.200
    12.122    33.906     0.200
    12.123    34.924     0.200
    14.408    36.724     0.200
    14.466    38.099     0.200
    18.663    40.207     0.200
     1.664     9.097     0.200
     1.769     9.519     0.200
     2.835    11.469     0.200
     3.136    11.335     0.200
     3.343    14.864     0.200
     3.952    15.514     0.200
     4.564    16.790     0.200
     4.616    14.653     0.200
     5.825    20.573     0.200
     6.340    22.567     0.200
     6.785    22.650     0.200
     7.062    25.739     0.200
     7.414    27.990     0.200
     8.465    26.629     0.200
     8.591    28.037     0.200
     8.757    27.079     0.200
     8.908    27.374     0.200
     8.908    26.959     0.200
     9.208    26.393     0.200
    10.418    32.388     0.200
    10.478    32.316     0.200
    11.084    32.004     0.200
    12.103    35.923     0.200
     1.738     9.174     0.200
     2.427    11.420     0.200
     2.868    12.359     0.200
     3.071    11.229     0.200
     3.071    11.080     0.200
     3.213    12.631     0.200
     3.441    14.285     0.200
     3.443    14.182     0.200
     3.476    13.760     0.200
     3.487    13.826     0.200
     3.487    14.049     0.200
     3.553    13.102     0.200
     3.608    13.796     0.200
     3.659    14.962     0.200
     3.883    15.672     0.200
     4.230    15.548     0.200
     4.230    16.099     0.200
     4.309    17.151     0.200
     4.313    16.239     0.200
     4.563    17.422     0.200
     4.740    17.987     0.200
     5.105    19.499     0.200
     5.412    17.428     0.200
     5.508    19.960     0.200
     5.861    19.625     0.200
     5.928    20.941     0.200
     6.019    21.141     0.200
     6.195    22.042     0.200
     6.297    18.323     0.200
     6.389    22.510     0.200
     6.428    19.342     0.200
     6.509    19.554     0.200
     6.607    20.561     0.200
     6.704    20.953     0.200
     6.759    22.169     0.200
     6.785    23.563     0.200
     7.040    22.522     0.200
     7.040    21.952     0.200
     7.453    21.633     0.200
     7.469    26.404     0.200
     7.519    24.598     0.200
     7.708    25.354     0.200
     8.169    23.973     0.200
     8.352    26.115     0.200
     8.375    27.521     0.200
     8.444    24.971     0.200
     8.479    24.640     0.200
     8.522    24.754     0.200
     8.637    25.579     0.200
     8.653    27.324     0.200
     8.793    25.525     0.200
     8.793    25.256     0.200
     8.828    28.011     0.200
     8.926    27.267     0.200
     8.936    27.392     0.200
     9.294    26.088     0.200
     9.448    28.148     0.200
     9.481    29.296     0.200
    10.066    29.988     0.200
    10.227    32.338     0.200
    10.466    33.084     0.200
    10.551    32.587     0.200
    11.134    35.155     0.200
    11.165    30.238     0.200
    12.156    36.935     0.200
    12.289    34.492     0.200
    12.380    34.914     0.200
    12.589    34.620     0.200
    12.762    33.817     0.200
    13.814    36.464     0.200
    15.243    37.432     0.200
    15.597    39.339     0.200
     1.810     9.981     0.200
     1.810     9.868     0.200
     4.599    17.392     0.200
     5.488    19.075     0.200
     5.857    20.979     0.200
     6.078    22.561     0.200
     6.199    22.084     0.200
     6.394    22.465     0.200
     6.821    23.048     0.200
     7.469    26.117     0.200
     8.354    28.130     0.200
     8.520    27.599     0.200
     8.755    26.410     0.200
     8.755    25.769     0.200
     8.813    28.605     0.200
     8.817    29.439     0.200
     8.909    29.303     0.200
     9.243    27.174     0.200
     9.483    33.232     0.200
    10.472    33.518     0.200
    10.627    31.678     0.200
    11.110    31.109     0.200
    11.110    32.078     0.200
    11.738    32.222     0.200
    12.157    36.640     0.200
    12.157    35.401     0.200
    12.388    36.356     0.200
    12.415    35.434     0.200
    12.683    39.546     0.200
     1.664     8.592     0.200
     1.664     8.897     0.200
     1.958    10.115     0.200
     1.958    10.268     0.200
     2.153    10.137     0.200
     2.165    11.610     0.200
     2.301    11.302     0.200
     2.684    12.881     0.200
     2.701    10.789     0.200
     3.049    12.349     0.200
     3.075    14.388     0.200
     3.327    12.545     0.200
     4.673    17.170     0.200
     4.995    18.570     0.200
     5.698    19.282     0.200
     1.715     9.120     0.200
     1.852    10.070     0.200
     1.852     9.852     0.200
     2.913    12.031     0.200
     2.930    11.898     0.200
     3.189    10.219     0.200
     3.419    15.081     0.200
     3.550    13.646     0.200
     3.562    14.082     0.200
     4.329    16.111     0.200
     4.611    15.024     0.200
     5.167    19.178     0.200
     5.479    18.963     0.200
     6.216    21.938     0.200
     6.349    20.157     0.200
     6.621    17.236     0.200
     6.869    21.072     0.200
     7.482    27.144     0.200
     8.026    25.854     0.200
     8.094    21.438     0.200
     8.343    26.729     0.200
     8.726    27.806     0.200
     8.811    27.987     0.200
     8.838    26.923     0.200
     8.903    27.040     0.200
     8.989    28.235     0.200
     8.989    27.297     0.200
    11.055    30.596     0.200
    12.172    36.394     0.200
    12.408    38.389     0.200
     1.609     8.517     0.200
     1.727     9.503     0.200
     1.761    10.342     0.200
     1.761    11.217     0.200
     1.901    10.671     0.200
     1.935    10.691     0.200
     2.159    11.201     0.200
     2.210     9.945     0.200
     2.331    10.954     0.200
     2.362     9.708     0.200
     2.413    11.459     0.200
     2.461    12.858     0.200
     2.496    12.171     0.200
     2.606    11.948     0.200
     2.641    13.370     0.200
     2.790    12.754     0.200
     2.805    12.169     0.200
     2.968    11.501     0.200
     2.971    14.445     0.200
     2.975    13.166     0.200
     3.029    12.463     0.200
     3.044    13.433     0.200
     3.059    12.218     0.200
     3.059    11.560     0.200
     3.207    13.342     0.200
     3.339    14.996     0.200
     3.424    14.736     0.200
     3.424    14.182     0.200
     3.430    14.676     0.200
     3.466    13.976     0.200
     3.468    15.287     0.200
     3.468    15.702     0.200
     3.551    13.179     0.200
     3.590    16.185     0.200
     3.642    16.165     0.200
     3.779    14.586     0.200
     3.799    16.709     0.200
     3.816    15.124     0.200
     3.872    15.257     0.200
     3.892    15.430     0.200
     3.940    14.706     0.200
     3.959    13.937     0.200
     4.039    14.855     0.200
     4.043    15.155     0.200
     4.050    16.375     0.200
     4.119    13.793     0.200
     4.212    16.035     0.200
     4.212    16.841     0.200
     4.296    17.100     0.200
     4.303    16.354     0.200
     4.312    17.072     0.200
     4.372    15.490     0.200
     4.432    17.345     0.200
     4.533    16.057     0.200
     4.557    17.838     0.200
     4.606    18.392     0.200
     4.617    18.050     0.200
     4.624    20.625     0.200
     4.631    17.992     0.200
     4.703    15.389     0.200
     4.729    18.608     0.200
     4.767    15.337     0.200
     4.797    18.458     0.200
     4.813    17.671     0.200
     4.949    16.857     0.200
     4.947    19.222     0.200
     5.037    20.035     0.200
     5.071    19.238     0.200
     5.126    17.668     0.200
     5.132    19.426     0.200
     5.208    20.868     0.200
     5.235    18.603     0.200
     5.239    20.165     0.200
     5.239    19.697     0.200
     5.318    17.998     0.200
     5.420    17.386     0.200
     5.450    20.687     0.200
     5.497    20.370     0.200
     5.497    19.958     0.200
     5.522    20.565     0.200
     5.614    18.332     0.200
     5.646    20.999     0.200
     5.671    20.021     0.200
     5.798    22.977     0.200
     5.837    21.232     0.200
     5.867    22.221     0.200
     5.931    21.253     0.200
     5.955    20.209     0.200
     5.987    19.144     0.200
     5.993    18.559     0.200
     6.005    19.143     0.200
     6.063    22.749     0.200
     6.086    22.195     0.200
     6.109    20.428     0.200
     6.179    22.267     0.200
     6.286    20.935     0.200
     6.378    21.922     0.200
     6.373    22.807     0.200
     6.416    21.470     0.200
     6.423    24.531     0.200
     6.433    23.490     0.200
     6.473    23.002     0.200
     6.535    19.817     0.200
     6.510    21.351     0.200
     6.611    21.157     0.200
     6.598    23.899     0.200
     6.633    20.414     0.200
     6.610    23.918     0.200
     6.627    22.273     0.200
     6.649    21.537     0.200
     6.653    24.610     0.200
     6.766    25.154     0.200
     6.852    24.303     0.200
     6.973    22.396     0.200
     6.959    25.352     0.200
     7.022    23.144     0.200
     7.068    23.351     0.200
     7.245    22.250     0.200
     7.249    21.753     0.200
     7.287    23.410     0.200
     7.332    25.432     0.200
     7.328    25.192     0.200
     7.364    24.343     0.200
     7.453    27.347     0.200
     7.477    25.443     0.200
     7.535    26.433     0.200
     7.536    25.551     0.200
     7.563    24.242     0.200
     7.594    24.211     0.200
     7.614    25.013     0.200
     7.690    26.445     0.200
     7.699    26.895     0.200
     7.754    27.293     0.200
     7.819    23.287     0.200
     7.800    26.106     0.200
     7.798    27.052     0.200
     7.812    26.851     0.200
     7.871    25.748     0.200
     7.927    25.524     0.200
     8.005    23.238     0.200
     7.991    26.273     0.200
     8.093    24.464     0.200
     8.121    24.354     0.200
     8.157    26.540     0.200
     8.214    26.311     0.200
     8.224    25.638     0.200
     8.321    27.609     0.200
     8.365    27.287     0.200
     8.367    27.702     0.200
     8.440    25.183     0.200
     8.475    25.807     0.200
     8.492    27.200     0.200
     8.509    27.007     0.200
     8.493    28.030     0.200
     8.638    29.016     0.200
     8.788    26.405     0.200
     8.788    26.556     0.200
     8.791    27.817     0.200
     8.861    25.635     0.200
     8.902    29.191     0.200
     8.914    28.429     0.200
     8.917    29.248     0.200
     9.037    28.413     0.200
     9.041    24.349     0.200
     9.094    27.383     0.200
     9.086    28.795     0.200
     9.159    26.118     0.200
     9.230    26.388     0.200
     9.295    26.465     0.200
     9.408    34.441     0.200
     9.465    32.745     0.200
     9.569    29.381     0.200
    10.540    32.074     0.200
    10.645    31.009     0.200
    11.116    36.625     0.200
    11.171    31.451     0.200
    11.745    36.147     0.200
    12.140    36.942     0.200
    12.272    37.319     0.200
    12.363    36.985     0.200
    12.572    34.208     0.200
    14.267    34.939     0.200
    15.583    39.933     0.200
    19.200    42.841     0.200
     1.578     9.023     0.200
     1.723     8.837     0.200
     1.723     9.025     0.200
     2.020    10.326     0.200
     2.020    10.451     0.200
     2.194    10.110     0.200
     2.218    11.589     0.200
     2.367    11.355     0.200
     2.558    10.941     0.200
     2.558    10.942     0.200
     2.713    10.550     0.200
     2.718    11.037     0.200
     3.093    12.735     0.200
     3.124    13.433     0.200
     3.143    12.730     0.200
     3.729    16.288     0.200
     3.765    14.823     0.200
     4.467    14.511     0.200
     4.530    17.567     0.200
     4.913    18.418     0.200
     6.290    22.127     0.200
     6.492    21.317     0.200
     7.049    23.219     0.200
    10.866    31.185     0.200
     1.460    10.573     0.200
     1.666     9.419     0.200
     1.738    10.921     0.200
     1.859    11.848     0.200
     1.899     9.936     0.200
     2.027    11.616     0.200
     2.027    11.913     0.200
     2.088    12.951     0.200
     2.117    11.620     0.200
     2.180    12.698     0.200
     2.353    13.714     0.200
     2.375    11.602     0.200
     2.399    13.243     0.200
     2.409    13.844     0.200
     2.426    11.506     0.200
     2.426    13.702     0.200
     2.459    14.087     0.200
     2.511    10.936     0.200
     2.608    12.986     0.200
     2.630    14.730     0.200
     2.641    12.073     0.200
     2.681    14.825     0.200
     2.730    12.731     0.200
     2.730    13.934     0.200
     2.839    14.247     0.200
     3.357    15.012     0.200
     3.394    16.914     0.200
     3.496    14.613     0.200
     3.571    15.734     0.200
     3.585    14.877     0.200
     3.591    14.669     0.200
     4.128    16.641     0.200
     4.266    15.503     0.200
     4.319    16.758     0.200
     4.522    17.680     0.200
     4.674    20.027     0.200
     4.969    20.397     0.200
     5.008    18.558     0.200
     5.019    19.800     0.200
     5.068    21.167     0.200
     5.229    19.836     0.200
     5.242    19.724     0.200
     5.273    19.403     0.200
     5.379    19.852     0.200
     5.534    20.078     0.200
     5.678    21.451     0.200
     6.183    22.135     0.200
     6.261    21.397     0.200
     6.261    21.686     0.200
     6.535    23.280     0.200
     6.801    22.402     0.200
     7.054    24.051     0.200
     7.054    24.293     0.200
     7.460    24.597     0.200
     7.758    27.784     0.200
     7.854    22.895     0.200
     8.366    27.020     0.200
     8.366    27.340     0.200
     8.531    24.843     0.200
     8.970    29.011     0.200
     9.185    30.627     0.200
     9.189    32.268     0.200
     9.452    29.296     0.200
     9.452    28.375     0.200
     9.908    34.049     0.200
    10.534    31.618     0.200
    10.534    31.164     0.200
    10.534    31.164     0.200
    11.785    36.191     0.200
    11.873    35.625     0.200
    12.116    38.010     0.200
    12.167    39.969     0.200
    12.301    39.387     0.200
    12.450    37.637     0.200
    12.450    35.706     0.200
    12.647    39.095     0.200
    12.745    40.370     0.200
    12.868    39.041     0.200
    12.935    34.726     0.200
    18.810    46.961     0.200
     1.428     9.712     0.200
     1.668     9.407     0.200
     1.735    10.931     0.200
     1.906     9.899     0.200
     2.021    10.695     0.200
     2.378    11.597     0.200
     2.424    11.509     0.200
     2.424    11.630     0.200
     2.525    10.792     0.200
     2.525    10.919     0.200
     2.648    12.125     0.200
     2.731    12.698     0.200
     2.906    13.019     0.200
     2.979    11.709     0.200
     3.150    12.251     0.200
     3.161    14.285     0.200
     3.279    13.877     0.200
     3.499    14.699     0.200
     3.565    14.872     0.200
     3.585    14.309     0.200
     3.588    14.950     0.200
     3.725    15.537     0.200
     4.093    16.796     0.200
     4.127    15.946     0.200
     4.127    16.317     0.200
     4.154    16.608     0.200
     4.207    15.180     0.200
     4.520    16.742     0.200
     4.639    17.686     0.200
     4.965    17.971     0.200
     4.965    18.072     0.200
     5.006    18.706     0.200
     5.232    19.528     0.200
     5.240    18.296     0.200
     5.273    19.336     0.200
     5.374    20.049     0.200
     5.544    20.272     0.200
     5.544    20.065     0.200
     5.679    21.229     0.200
     5.835    20.472     0.200
     5.877    21.140     0.200
     6.273    22.067     0.200
     6.273    21.069     0.200
     6.541    22.723     0.200
     6.814    21.767     0.200
     6.903    22.145     0.200
     7.056    23.717     0.200
     7.056    23.844     0.200
     7.459    25.928     0.200
     7.746    24.900     0.200
     7.765    26.403     0.200
     7.783    25.792     0.200
     7.819    22.948     0.200
     7.848    24.999     0.200
     8.376    26.483     0.200
     8.376    27.198     0.200
     8.544    26.740     0.200
     8.874    28.536     0.200
     8.991    29.466     0.200
     9.011    29.290     0.200
     9.137    26.269     0.200
     9.195    28.367     0.200
     9.455    29.883     0.200
     9.861    30.565     0.200
     9.910    30.126     0.200
     9.915    32.566     0.200
    10.403    30.189     0.200
    10.547    31.083     0.200
    10.574    29.197     0.200
    10.696    33.639     0.200
    10.696    30.997     0.200
    10.736    31.405     0.200
    10.995    32.838     0.200
    11.166    33.322     0.200
    11.196    34.834     0.200
    11.196    33.498     0.200
    11.275    33.886     0.200
    11.387    32.274     0.200
    11.414    33.486     0.200
    11.598    36.730     0.200
    11.628    34.133     0.200
    11.770    34.258     0.200
    11.795    35.431     0.200
    11.795    34.302     0.200
    11.839    34.071     0.200
    11.870    37.081     0.200
    12.081    35.704     0.200
    12.118    37.185     0.200
    12.304    37.977     0.200
    12.304    38.650     0.200
    12.347    36.954     0.200
    12.379    36.222     0.200
    12.384    35.372     0.200
    12.457    34.565     0.200
    12.457    36.179     0.200
    12.463    37.134     0.200
    12.555    36.416     0.200
    12.828    37.256     0.200
    12.933    37.109     0.200
    12.949    33.736     0.200
    13.044    37.270     0.200
    13.054    38.211     0.200
    13.066    37.604     0.200
    13.140    34.302     0.200
    13.163    36.133     0.200
    13.256    37.852     0.200
    13.470    38.369     0.200
    13.588    38.365     0.200
    13.609    38.811     0.200
    13.610    37.788     0.200
    13.612    38.236     0.200
    13.648    37.910     0.200
    13.648    38.892     0.200
    13.671    37.515     0.200
    13.671    37.759     0.200
    13.708    40.168     0.200
    13.841    38.144     0.200
    14.121    38.571     0.200
    14.154    40.027     0.200
    14.224    40.453     0.200
    14.263    40.214     0.200
    14.266    33.671     0.200
    14.284    39.199     0.200
    14.301    39.651     0.200
    14.437    39.952     0.200
    14.499    40.527     0.200
    14.612    40.101     0.200
    14.701    41.031     0.200
    14.737    37.498     0.200
    14.779    39.959     0.200
    15.528    37.180     0.200
    15.623    40.897     0.200
    16.031    40.069     0.200
    16.224    41.181     0.200
    16.262    37.315     0.200
    16.346    41.573     0.200
    16.483    40.685     0.200
    16.541    41.404     0.200
    17.003    40.691     0.200
    17.097    40.944     0.200
    17.123    39.332     0.200
    18.061    41.726     0.200
    18.528    43.881     0.200
    18.961    44.538     0.200
    18.987    44.794     0.200
    19.171    43.601     0.200
    19.457    45.490     0.200
    19.899    42.085     0.200
     1.424     9.762     0.200
     1.639    10.432     0.200
     1.639    10.283     0.200
     1.662     9.476     0.200
     1.731    10.969     0.200
     1.900     9.957     0.200
     2.019    10.950     0.200
     2.372    11.611     0.200
     2.420    11.389     0.200
     2.519    10.833     0.200
     2.641    12.212     0.200
     2.726    12.838     0.200
     2.899    13.062     0.200
     3.148    12.446     0.200
     3.493    14.631     0.200
     3.563    14.283     0.200
     3.583    14.947     0.200
     3.813    16.678     0.200
     4.122    17.034     0.200
     4.274    14.711     0.200
     4.962    18.172     0.200
     5.226    19.720     0.200
     5.236    20.483     0.200
     5.538    19.681     0.200
     5.538    20.087     0.200
     5.674    21.352     0.200
     5.674    20.938     0.200
     5.831    22.465     0.200
     6.184    21.984     0.200
     6.266    21.665     0.200
     6.266    21.876     0.200
     6.534    22.867     0.200
     6.809    21.553     0.200
     6.898    23.659     0.200
     7.050    24.114     0.200
     7.050    23.919     0.200
     7.454    25.331     0.200
     7.758    27.401     0.200
     7.780    26.999     0.200
     7.814    26.573     0.200
     8.128    25.740     0.200
     8.370    27.990     0.200
     8.370    27.256     0.200
     8.538    24.209     0.200
     8.665    30.359     0.200
     8.783    27.085     0.200
     8.924    26.906     0.200
     8.972    29.419     0.200
     8.984    28.210     0.200
     9.004    30.029     0.200
     9.188    28.680     0.200
     9.449    27.630     0.200
    10.544    31.190     0.200
    10.689    30.202     0.200
    10.729    32.362     0.200
    10.816    32.918     0.200
    11.382    33.181     0.200
    11.788    33.540     0.200
    12.450    37.321     0.200
    13.863    37.859     0.200
    14.260    35.601     0.200
    16.025    41.038     0.200
    16.477    39.660     0.200
    16.998    40.995     0.200
     1.434     9.978     0.200
     1.646    11.061     0.200
     1.740    10.762     0.200
     1.820    11.370     0.200
     1.915     9.723     0.200
     2.024    11.503     0.200
     2.386    11.402     0.200
     2.430    12.260     0.200
     2.656    12.643     0.200
     2.659    13.493     0.200
     2.738    12.656     0.200
     2.913    13.551     0.200
     3.166    14.950     0.200
     3.403    15.237     0.200
     3.506    14.870     0.200
     3.569    15.875     0.200
     3.594    15.659     0.200
     3.589    15.565     0.200
     3.729    15.625     0.200
     3.827    17.172     0.200
     4.097    17.058     0.200
     4.133    16.882     0.200
     4.161    16.607     0.200
     4.672    18.552     0.200
     4.970    18.890     0.200
     4.943    17.166     0.200
     5.012    18.963     0.200
     5.014    19.622     0.200
     5.240    19.796     0.200
     5.246    19.684     0.200
     5.378    20.183     0.200
     5.423    20.123     0.200
     5.553    20.565     0.200
     5.553    20.876     0.200
     5.686    21.810     0.200
     6.280    21.693     0.200
     6.280    22.284     0.200
     6.549    23.193     0.200
     6.800    25.803     0.200
     6.820    22.211     0.200
     6.820    22.388     0.200
     7.063    24.536     0.200
     7.063    24.796     0.200
     7.464    26.006     0.200
     7.773    29.343     0.200
     7.787    26.618     0.200
     7.826    25.391     0.200
     8.385    27.507     0.200
     8.385    27.687     0.200
     8.551    27.703     0.200
     8.551    26.748     0.200
     8.798    31.096     0.200
     8.794    26.447     0.200
     8.882    28.115     0.200
     8.999    29.934     0.200
     9.019    30.287     0.200
     9.145    31.560     0.200
     9.203    33.369     0.200
     9.229    30.622     0.200
     9.437    33.852     0.200
     9.923    35.177     0.200
    10.551    31.391     0.200
    10.615    34.273     0.200
    10.704    35.415     0.200
    10.743    34.059     0.200
    10.831    34.871     0.200
    11.202    36.257     0.200
    11.202    35.352     0.200
    11.280    33.082     0.200
    11.420    34.135     0.200
    11.603    37.341     0.200
    11.640    37.575     0.200
    11.776    36.131     0.200
    11.803    35.818     0.200
    11.803    38.290     0.200
    11.802    35.894     0.200
    11.843    35.066     0.200
    11.874    37.673     0.200
    12.087    36.663     0.200
    12.125    38.538     0.200
    12.170    39.960     0.200
    12.245    38.154     0.200
    12.271    39.216     0.200
    12.272    37.544     0.200
    12.272    38.458     0.200
    12.312    38.911     0.200
    12.312    39.638     0.200
    12.383    39.214     0.200
    12.465    38.315     0.200
    12.722    40.555     0.200
    12.759    39.302     0.200
    12.782    40.657     0.200
    12.835    37.433     0.200
    12.938    37.573     0.200
    13.049    38.070     0.200
    13.058    38.766     0.200
    13.148    40.744     0.200
    13.262    38.696     0.200
    13.274    38.900     0.200
    13.497    38.993     0.200
    13.497    37.703     0.200
    13.592    39.977     0.200
    13.594    38.356     0.200
    13.617    39.436     0.200
    13.613    40.561     0.200
    13.652    38.912     0.200
    13.652    37.336     0.200
    13.676    38.591     0.200
    13.676    37.761     0.200
    13.790    41.843     0.200
    13.814    42.458     0.200
    13.847    38.702     0.200
    13.943    40.485     0.200
    13.943    39.528     0.200
    14.127    39.392     0.200
    14.268    40.351     0.200
    14.290    39.431     0.200
    14.442    40.145     0.200
    14.432    41.589     0.200
    14.562    41.043     0.200
    14.618    41.122     0.200
    14.740    41.047     0.200
    14.785    40.385     0.200
    14.853    41.342     0.200
    14.995    41.085     0.200
    15.331    41.116     0.200
    15.483    41.631     0.200
    15.535    41.834     0.200
    15.798    41.437     0.200
    16.038    41.697     0.200
    16.197    41.991     0.200
    16.392    40.368     0.200
    18.402    46.707     0.200
    18.583    47.094     0.200
    18.658    46.823     0.200
    18.745    46.831     0.200
    18.829    44.251     0.200
    19.383    46.014     0.200
    19.519    44.028     0.200
    19.523    42.827     0.200
    19.523    45.932     0.200
    20.729    43.660     0.200
    20.927    42.579     0.200
     1.430     9.607     0.200
     1.645    10.151     0.200
     1.645    10.264     0.200
     1.668     9.346     0.200
     1.737    10.881     0.200
     1.905     9.879     0.200
     2.024    10.906     0.200
     2.378    11.531     0.200
     2.426    11.480     0.200
     2.426    11.116     0.200
     2.646    11.930     0.200
     2.732    12.539     0.200
     2.905    12.886     0.200
     2.983    12.254     0.200
     3.277    13.893     0.200
     3.499    14.549     0.200
     3.569    14.410     0.200
     3.589    14.188     0.200
     3.589    14.718     0.200
     4.129    16.914     0.200
     4.129    17.117     0.200
     4.155    16.993     0.200
     4.211    16.766     0.200
     4.274    15.371     0.200
     4.522    16.995     0.200
     4.968    18.526     0.200
     5.232    19.085     0.200
     5.541    20.216     0.200
     5.541    19.310     0.200
     5.680    21.062     0.200
     6.269    21.061     0.200
     6.269    20.162     0.200
     6.539    20.953     0.200
     6.809    22.158     0.200
     7.056    24.270     0.200
     7.056    22.669     0.200
     7.763    25.400     0.200
     8.373    24.682     0.200
     8.784    25.986     0.200
     1.446     9.348     0.200
     1.686     9.075     0.200
     1.922     9.862     0.200
     1.922     9.073     0.200
     2.037    11.285     0.200
     2.396    11.197     0.200
     2.663    12.053     0.200
     2.749    12.864     0.200
     3.582    16.004     0.200
     3.601    15.255     0.200
     4.223    15.138     0.200
     5.556    20.429     0.200
     6.282    21.693     0.200
     6.557    22.616     0.200
     6.815    21.328     0.200
     7.780    26.523     0.200
     8.388    28.028     0.200
     8.550    23.949     0.200
     8.805    28.250     0.200
     8.788    26.092     0.200
     9.024    29.805     0.200
     9.211    27.965     0.200
     9.472    28.321     0.200
     9.877    31.370     0.200
     9.931    32.950     0.200
    10.419    32.316     0.200
    10.584    29.148     0.200
    10.619    33.709     0.200
    10.839    32.644     0.200
    11.198    34.148     0.200
    11.405    33.149     0.200
    11.807    33.587     0.200
    12.322    36.481     0.200
    12.269    35.405     0.200
    12.669    36.641     0.200
    12.767    38.382     0.200
    12.965    38.320     0.200
    13.060    38.125     0.200
    13.156    38.382     0.200
    13.386    38.791     0.200
    13.503    36.955     0.200
    13.725    39.149     0.200
    13.672    38.114     0.200
    15.773    39.487     0.200
    17.044    39.892     0.200
    17.121    40.153     0.200
    18.825    40.931     0.200
     1.437     9.461     0.200
     1.655    10.112     0.200
     1.655     9.991     0.200
     1.673     9.179     0.200
     1.746    10.724     0.200
     1.904     9.730     0.200
     2.035    10.631     0.200
     2.433    11.297     0.200
     2.508    10.711     0.200
     2.645    11.921     0.200
     2.667    12.451     0.200
     2.737    12.603     0.200
     2.907    12.905     0.200
     2.996    13.215     0.200
     3.171    14.059     0.200
     3.276    13.732     0.200
     3.412    14.213     0.200
     3.503    14.495     0.200
     3.579    14.386     0.200
     3.595    14.790     0.200
     3.599    14.219     0.200
     3.822    16.183     0.200
     3.834    14.516     0.200
     4.105    15.843     0.200
     4.135    16.269     0.200
     4.135    16.394     0.200
     4.159    16.095     0.200
     4.222    16.983     0.200
     4.262    14.718     0.200
     4.327    16.771     0.200
     4.530    16.585     0.200
     4.642    16.232     0.200
     4.978    18.120     0.200
     5.016    18.144     0.200
     5.235    19.258     0.200
     5.250    19.357     0.200
     5.387    19.894     0.200
     5.435    19.817     0.200
     5.536    19.548     0.200
     5.536    19.911     0.200
     5.685    20.421     0.200
     5.886    21.134     0.200
     6.261    21.116     0.200
     6.539    22.837     0.200
     6.797    21.372     0.200
     7.060    23.640     0.200
     7.060    23.991     0.200
     7.468    25.563     0.200
     7.762    26.035     0.200
     7.795    25.457     0.200
     7.805    25.678     0.200
     8.367    26.422     0.200
     8.367    26.907     0.200
     8.530    25.432     0.200
     8.786    26.197     0.200
     8.772    26.181     0.200
     8.869    27.429     0.200
     8.983    28.849     0.200
     9.004    29.585     0.200
     9.106    30.801     0.200
     9.177    28.421     0.200
     9.136    27.829     0.200
     9.194    29.821     0.200
     9.194    28.489     0.200
     9.425    30.367     0.200
     9.458    29.363     0.200
     9.861    30.971     0.200
     9.913    32.635     0.200
    10.401    34.021     0.200
    10.529    30.942     0.200
    10.690    34.119     0.200
    10.690    29.830     0.200
    10.736    31.453     0.200
    10.821    33.104     0.200
    11.179    31.008     0.200
    11.258    33.478     0.200
    11.395    36.448     0.200
    11.398    34.344     0.200
    11.609    36.076     0.200
    11.609    34.432     0.200
    11.786    35.750     0.200
    11.821    33.860     0.200
    11.881    38.024     0.200
    12.122    37.008     0.200
    12.174    39.508     0.200
    12.272    38.470     0.200
    12.307    37.484     0.200
    12.307    35.468     0.200
    12.361    34.447     0.200
    12.366    35.266     0.200
    12.652    37.522     0.200
    12.750    35.852     0.200
    12.786    39.736     0.200
    12.812    37.905     0.200
    12.915    36.839     0.200
    13.027    35.503     0.200
    13.139    39.893     0.200
    13.145    36.501     0.200
    13.483    36.057     0.200
    13.483    36.541     0.200
    13.572    37.105     0.200
    13.592    40.290     0.200
    13.591    38.828     0.200
    13.630    38.853     0.200
    13.654    37.303     0.200
    13.654    38.041     0.200
    13.709    36.222     0.200
    13.825    37.892     0.200
    14.206    38.383     0.200
    14.267    38.086     0.200
    14.284    38.118     0.200
    14.331    41.023     0.200
    14.738    38.905     0.200
    14.991    41.178     0.200
    15.308    41.315     0.200
    15.396    41.397     0.200
    15.696    39.442     0.200
    15.754    40.307     0.200
    16.242    41.675     0.200
    16.486    40.569     0.200
    17.009    40.619     0.200
    18.014    42.162     0.200
    20.032    45.240     0.200
    20.144    43.585     0.200
     1.529     9.660     0.200
     1.613     9.239     0.200
     1.659     9.755     0.200
     1.728    11.007     0.200
     1.743     9.570     0.200
     1.743     9.711     0.200
     1.805    11.368     0.200
     1.896    11.739     0.200
     1.947     9.565     0.200
     1.947     8.839     0.200
     2.066    12.168     0.200
     2.074    12.451     0.200
     2.148    12.406     0.200
     2.206    12.555     0.200
     2.224    12.598     0.200
     2.244    11.659     0.200
     2.240    12.626     0.200
     2.244    12.646     0.200
     2.281    12.742     0.200
     2.309    11.112     0.200
     2.368    12.910     0.200
     2.394    12.989     0.200
     2.407    12.201     0.200
     2.448    13.137     0.200
     2.600    11.957     0.200
     2.649    10.995     0.200
     2.676    11.843     0.200
     2.705    13.688     0.200
     2.809    11.133     0.200
     2.837    10.703     0.200
     2.857    12.587     0.200
     2.857    13.501     0.200
     3.135    14.781     0.200
     3.147    13.699     0.200
     3.274    14.022     0.200
     3.307    13.562     0.200
     3.586    15.679     0.200
     3.924    15.401     0.200
     3.924    14.917     0.200
     3.950    16.147     0.200
     3.990    14.599     0.200
     4.033    15.761     0.200
     4.396    16.585     0.200
     4.564    14.902     0.200
     4.718    17.755     0.200
     4.806    17.607     0.200
     5.039    18.738     0.200
     5.111    18.863     0.200
     5.122    18.791     0.200
     5.151    19.084     0.200
     5.544    19.927     0.200
     5.667    20.035     0.200
     5.667    19.816     0.200
     6.003    21.221     0.200
     6.300    22.657     0.200
     6.381    22.280     0.200
     6.455    21.550     0.200
     6.527    22.883     0.200
     6.949    24.101     0.200
     6.986    22.439     0.200
     7.106    21.801     0.200
     7.216    25.115     0.200
     7.261    27.287     0.200
     7.261    25.263     0.200
     7.528    24.660     0.200
     7.829    25.845     0.200
     8.063    24.794     0.200
     8.388    25.608     0.200
     8.432    25.586     0.200
     8.517    27.142     0.200
     8.778    26.503     0.200
     8.815    28.686     0.200
     8.921    29.165     0.200
     9.069    32.817     0.200
     9.101    26.674     0.200
     9.101    26.963     0.200
     9.145    30.556     0.200
     9.164    29.041     0.200
     9.354    29.291     0.200
     9.476    28.656     0.200
     9.474    30.491     0.200
     9.817    31.644     0.200
     9.887    29.442     0.200
    10.308    32.517     0.200
    10.728    33.115     0.200
    10.748    31.651     0.200
    10.882    31.730     0.200
    10.883    31.916     0.200
    11.030    36.189     0.200
    11.213    35.844     0.200
    11.471    35.267     0.200
    11.573    32.928     0.200
    11.623    36.755     0.200
    11.923    35.527     0.200
    11.955    34.464     0.200
    11.953    38.600     0.200
    12.098    38.091     0.200
    12.162    34.539     0.200
    12.469    36.598     0.200
    12.499    39.881     0.200
    12.527    35.728     0.200
    12.527    36.392     0.200
    12.635    38.502     0.200
    12.705    35.835     0.200
    12.706    36.655     0.200
    12.730    34.837     0.200
    12.752    34.489     0.200
    12.850    39.775     0.200
    12.854    36.399     0.200
    12.861    36.517     0.200
    12.933    37.915     0.200
    12.958    40.806     0.200
    13.001    36.766     0.200
    13.024    39.746     0.200
    13.115    36.111     0.200
    13.254    36.993     0.200
    13.342    37.047     0.200
    13.348    38.879     0.200
    13.380    38.421     0.200
    13.494    35.657     0.200
    13.537    37.893     0.200
    13.554    37.439     0.200
    13.554    38.462     0.200
    13.577    37.504     0.200
    13.643    37.015     0.200
    13.925    37.508     0.200
    13.934    38.811     0.200
    13.970    38.045     0.200
    13.970    38.678     0.200
    13.970    37.170     0.200
    13.978    38.381     0.200
    13.985    37.456     0.200
    14.132    38.431     0.200
    14.189    40.652     0.200
    14.218    39.214     0.200
    14.396    39.328     0.200
    14.535    39.368     0.200
    14.584    39.387     0.200
    14.675    40.768     0.200
    14.687    40.659     0.200
    14.851    37.883     0.200
    14.894    40.059     0.200
    15.076    40.896     0.200
    15.212    40.084     0.200
    15.238    40.135     0.200
    15.290    40.409     0.200
    15.399    40.882     0.200
    15.538    34.695     0.200
    15.608    40.296     0.200
    15.704    41.447     0.200
    15.718    41.138     0.200
    15.743    40.279     0.200
    15.837    39.069     0.200
    15.856    40.848     0.200
    15.968    42.086     0.200
    16.051    41.393     0.200
    16.051    41.011     0.200
    16.159    40.959     0.200
    16.459    40.676     0.200
    17.444    40.098     0.200
    17.445    39.117     0.200
    18.080    42.036     0.200
    18.358    42.055     0.200
    18.538    44.203     0.200
    18.549    42.876     0.200
    18.569    42.419     0.200
    19.103    45.269     0.200
    19.663    42.782     0.200
    20.067    44.328     0.200
     1.441    10.190     0.200
     1.653    10.303     0.200
     1.653    10.444     0.200
     1.682     9.704     0.200
     1.827    11.023     0.200
     1.920    10.121     0.200
     2.032    11.713     0.200
     2.392    11.730     0.200
     2.437    11.913     0.200
     2.530    11.043     0.200
     2.530    10.894     0.200
     2.661    12.142     0.200
     2.667    13.085     0.200
     2.745    13.064     0.200
     2.920    13.338     0.200
     3.158    13.872     0.200
     3.173    13.783     0.200
     3.292    13.644     0.200
     3.411    14.863     0.200
     3.512    15.053     0.200
     3.576    14.518     0.200
     3.596    14.152     0.200
     3.602    15.482     0.200
     3.604    15.036     0.200
     4.105    16.856     0.200
     4.140    16.553     0.200
     4.168    17.400     0.200
     4.218    16.093     0.200
     4.218    14.152     0.200
     4.284    15.117     0.200
     4.532    16.393     0.200
     4.653    17.501     0.200
     4.679    18.693     0.200
     4.977    18.532     0.200
     4.977    19.450     0.200
     5.019    19.301     0.200
     5.021    19.932     0.200
     5.246    20.323     0.200
     5.253    19.632     0.200
     5.385    20.272     0.200
     5.556    18.596     0.200
     5.556    19.069     0.200
     5.693    21.425     0.200
     5.891    22.041     0.200
     6.282    20.715     0.200
     6.554    23.451     0.200
     6.818    21.230     0.200
     6.818    21.078     0.200
     7.070    22.986     0.200
     7.070    24.298     0.200
     7.472    25.747     0.200
     7.778    24.775     0.200
     8.792    24.795     0.200
     9.023    30.077     0.200
     9.469    27.715     0.200
    10.546    31.188     0.200
     1.436     9.984     0.200
     1.436    10.136     0.200
     1.648    10.488     0.200
     1.648    10.738     0.200
     1.676    10.113     0.200
     1.914    10.097     0.200
     1.914    10.245     0.200
     2.027    11.320     0.200
     2.432    11.867     0.200
     2.528    10.906     0.200
     2.662    13.142     0.200
     2.739    12.739     0.200
     2.914    13.185     0.200
     3.572    15.142     0.200
     5.551    19.070     0.200
     1.441    10.305     0.200
     1.650    10.697     0.200
     1.746    11.223     0.200
     1.924    10.104     0.200
     2.028    12.081     0.200
     2.394    11.731     0.200
     2.436    11.609     0.200
     2.538    11.033     0.200
     2.538    10.869     0.200
     2.665    12.788     0.200
     2.664    14.041     0.200
     2.745    12.984     0.200
     2.922    12.985     0.200
     3.172    14.169     0.200
     3.514    14.533     0.200
     3.573    13.486     0.200
     3.592    14.649     0.200
     4.102    16.125     0.200
     4.214    15.143     0.200
     4.292    14.660     0.200
     4.653    17.037     0.200
     4.975    18.627     0.200
     5.248    17.502     0.200
     5.562    19.087     0.200
     6.290    22.218     0.200
     6.558    22.099     0.200
     6.827    21.710     0.200
     8.394    27.079     0.200
     9.029    30.668     0.200
     1.436    10.010     0.200
     1.650    10.628     0.200
     1.675     9.657     0.200
     1.743    11.398     0.200
     1.825    11.079     0.200
     1.911    10.111     0.200
     2.029    11.851     0.200
     2.385    11.710     0.200
     2.432    11.929     0.200
     2.522    10.974     0.200
     2.652    12.250     0.200
     2.663    13.876     0.200
     2.738    13.033     0.200
     2.912    13.014     0.200
     3.168    14.518     0.200
     3.595    15.286     0.200
     1.660     9.837     0.200
     1.690     9.266     0.200
     1.755    10.700     0.200
     1.834    10.732     0.200
     1.928     9.609     0.200
     1.928     9.396     0.200
     2.038    11.604     0.200
     2.401    11.239     0.200
     2.445    11.467     0.200
     2.532    10.839     0.200
     2.532    10.429     0.200
     2.674    12.445     0.200
     2.669    11.772     0.200
     2.753    12.820     0.200
     2.928    12.736     0.200
     3.164    14.061     0.200
     3.300    12.493     0.200
     3.521    14.357     0.200
     3.583    14.215     0.200
     3.603    14.007     0.200
     3.610    14.112     0.200
     4.112    16.291     0.200
     4.148    16.878     0.200
     5.563    19.285     0.200
     8.793    24.678     0.200
     9.477    27.103     0.200
     1.390     9.683     0.200
     1.432     9.948     0.200
     1.640    10.528     0.200
     1.674     9.767     0.200
     1.674    10.656     0.200
     1.697    11.737     0.200
     1.736    11.446     0.200
     1.813    10.879     0.200
     1.847    11.148     0.200
     1.871    11.419     0.200
     1.920    10.036     0.200
     1.920    10.216     0.200
     2.018    11.104     0.200
     2.018    11.961     0.200
     2.029    13.285     0.200
     2.061    13.348     0.200
     2.089    12.529     0.200
     2.128    11.178     0.200
     2.274    11.486     0.200
     2.307    13.860     0.200
     2.352    13.303     0.200
     2.387    11.790     0.200
     2.394    12.649     0.200
     2.407    12.796     0.200
     2.409    13.433     0.200
     2.433    12.584     0.200
     2.427    11.767     0.200
     2.427    12.048     0.200
     2.428    13.492     0.200
     2.458    13.691     0.200
     2.542    10.896     0.200
     2.626    14.367     0.200
     2.661    12.311     0.200
     2.654    13.139     0.200
     2.678    14.450     0.200
     2.737    12.917     0.200
     2.846    13.804     0.200
     2.916    13.297     0.200
     2.970    12.650     0.200
     3.143    12.694     0.200
     3.165     9.765     0.200
     3.292    13.983     0.200
     3.388    16.577     0.200
     3.506    14.592     0.200
     3.563    15.309     0.200
     3.593    15.301     0.200
     3.582    14.924     0.200
     3.722    15.510     0.200
     3.829    16.700     0.200
     3.862    18.142     0.200
     4.020    15.104     0.200
     4.092    16.653     0.200
     4.131    16.378     0.200
     4.131    16.819     0.200
     4.161    16.538     0.200
     4.204    16.592     0.200
     4.204    16.879     0.200
     4.297    15.118     0.200
     4.297    14.886     0.200
     4.303    16.149     0.200
     4.671    16.782     0.200
     4.645    17.882     0.200
     4.666    18.109     0.200
     4.950    18.765     0.200
     4.965    18.977     0.200
     4.965    19.637     0.200
     5.241    19.361     0.200
     5.243    19.353     0.200
     5.561    20.272     0.200
     6.290    21.572     0.200
     6.552    23.278     0.200
     6.761    23.435     0.200
     6.832    21.351     0.200
     6.792    26.630     0.200
     7.064    24.370     0.200
     7.462    28.990     0.200
     7.462    24.340     0.200
     7.778    27.049     0.200
     7.798    25.143     0.200
     7.838    27.753     0.200
     8.393    27.028     0.200
     8.562    25.126     0.200
     8.639    27.312     0.200
     8.688    30.995     0.200
     8.806    26.508     0.200
     8.888    29.107     0.200
     8.946    29.382     0.200
     8.995    29.918     0.200
     9.007    29.744     0.200
     9.194    28.810     0.200
     9.124    30.751     0.200
     9.149    31.753     0.200
     9.206    32.342     0.200
     9.228    30.144     0.200
     9.443    30.716     0.200
     9.463    27.558     0.200
     9.463    29.972     0.200
     9.765    31.626     0.200
     9.748    31.308     0.200
     9.872    32.845     0.200
    10.169    28.607     0.200
    10.562    31.212     0.200
    10.562    31.078     0.200
    10.623    34.020     0.200
    10.711    34.475     0.200
    10.746    32.906     0.200
    11.213    36.267     0.200
    11.241    36.872     0.200
    11.391    36.890     0.200
    11.812    36.785     0.200
    11.869    35.983     0.200
    12.042    37.501     0.200
    12.125    37.685     0.200
    12.167    39.952     0.200
    12.283    37.685     0.200
    12.269    38.434     0.200
    12.313    39.033     0.200
    12.470    36.380     0.200
    12.470    36.808     0.200
    12.470    35.038     0.200
    12.665    38.806     0.200
    12.783    41.660     0.200
    12.961    38.434     0.200
    13.055    38.922     0.200
    13.382    40.078     0.200
    13.504    38.340     0.200
    13.664    38.597     0.200
    13.688    38.443     0.200
    13.881    42.386     0.200
    14.597    41.556     0.200
    14.651    37.443     0.200
    14.713    41.932     0.200
    15.810    41.165     0.200
    17.010    42.083     0.200
    18.841    46.766     0.200
    19.050    43.049     0.200
     1.432     9.979     0.200
     1.640    10.649     0.200
     1.660     9.935     0.200
     1.675     9.716     0.200
     1.737    11.323     0.200
     1.920    10.282     0.200
     2.018    11.413     0.200
     2.274    11.636     0.200
     2.388    11.871     0.200
     2.428    11.862     0.200
     2.542    11.196     0.200
     2.542    10.950     0.200
     2.654    13.049     0.200
     2.661    12.357     0.200
     2.738    12.964     0.200
     2.916    13.392     0.200
     3.143    13.517     0.200
     3.563    16.981     0.200
     3.582    14.025     0.200
     3.593    14.443     0.200
     4.092    16.754     0.200
     4.131    17.249     0.200
     4.204    15.049     0.200
     4.297    14.789     0.200
     5.243    18.853     0.200
     5.242    19.191     0.200
     5.561    20.195     0.200
     6.553    23.440     0.200
     6.832    22.126     0.200
     7.064    23.792     0.200
     7.462    26.511     0.200
     7.778    28.010     0.200
     8.393    27.089     0.200
     8.806    25.572     0.200
    10.562    31.054     0.200
    12.471    35.700     0.200
     1.432    10.084     0.200
     1.739    11.331     0.200
     1.820    11.503     0.200
     1.909    10.331     0.200
     1.909    10.231     0.200
     2.025    11.981     0.200
     2.193    10.775     0.200
     2.382    11.768     0.200
     2.428    12.082     0.200
     2.428    11.956     0.200
     2.428    11.812     0.200
     2.524    11.108     0.200
     2.650    12.277     0.200
     2.650    12.429     0.200
     2.659    12.654     0.200
     2.735    12.864     0.200
     2.909    13.068     0.200
     2.982    12.746     0.200
     3.153    13.710     0.200
     3.281    13.967     0.200
     3.403    14.949     0.200
     3.476    14.519     0.200
     3.502    14.799     0.200
     3.569    17.002     0.200
     3.591    14.600     0.200
     3.729    15.518     0.200
     4.095    17.394     0.200
     4.097    16.256     0.200
     4.131    16.036     0.200
     4.131    17.569     0.200
     4.157    15.856     0.200
     4.278    14.823     0.200
     4.278    15.623     0.200
     4.314    17.538     0.200
     4.523    18.011     0.200
     4.643    17.774     0.200
     4.737    17.656     0.200
     4.969    18.571     0.200
     5.010    18.708     0.200
     5.015    18.544     0.200
     5.235    20.297     0.200
     5.244    21.337     0.200
     5.532    19.964     0.200
     5.546    19.186     0.200
     5.546    20.636     0.200
     5.796    20.391     0.200
     5.855    21.736     0.200
     5.881    20.702     0.200
     6.064    21.765     0.200
     6.543    23.607     0.200
     7.059    24.702     0.200
     7.393    25.783     0.200
     7.462    24.174     0.200
     8.543    24.938     0.200
     8.788    27.582     0.200
     8.932    30.006     0.200
     8.981    30.670     0.200
     9.207    32.954     0.200
     9.431    32.476     0.200
     9.458    27.290     0.200
     9.864    34.047     0.200
    10.545    32.681     0.200
    10.608    34.655     0.200
    10.825    35.515     0.200
    11.873    35.494     0.200
    12.032    37.838     0.200
    12.459    34.663     0.200
    17.007    41.646     0.200
     1.429     9.739     0.200
     1.460     9.814     0.200
     1.680     9.194     0.200
     1.680     9.706     0.200
     1.685    10.004     0.200
     1.717    10.871     0.200
     1.841    10.992     0.200
     1.859    11.034     0.200
     1.874    10.568     0.200
     1.874    10.392     0.200
     1.882    11.072     0.200
     1.924    11.379     0.200
     1.932    10.800     0.200
     1.969    10.515     0.200
     2.013    11.348     0.200
     2.057    11.712     0.200
     2.090    11.568     0.200
     2.218    10.542     0.200
     2.239    11.263     0.200
     2.404    10.696     0.200
     2.552    10.325     0.200
     2.789    13.255     0.200
     2.804    11.583     0.200
     2.800    13.281     0.200
     2.960    12.907     0.200
     2.979    12.720     0.200
     3.011    13.107     0.200
     3.066    13.984     0.200
     3.258    14.279     0.200
     3.392    13.851     0.200
     3.584    15.546     0.200
     3.600    14.574     0.200
     3.812    15.306     0.200
     4.222    16.816     0.200
     4.724    17.428     0.200
     4.726    18.001     0.200
     5.628    20.023     0.200
     5.748    20.634     0.200
     5.904    21.214     0.200
     1.406    10.567     0.200
     1.451    10.467     0.200
     1.482    10.945     0.200
     1.688    10.031     0.200
     1.688    11.250     0.200
     1.759    11.766     0.200
     1.842    11.389     0.200
     1.880    12.172     0.200
     1.918    10.503     0.200
     1.918    10.636     0.200
     1.918    11.116     0.200
     2.046    11.469     0.200
     2.046    11.648     0.200
     2.110    12.800     0.200
     2.139    11.891     0.200
     2.193    11.126     0.200
     2.277    12.361     0.200
     2.331    13.868     0.200
     2.374    13.526     0.200
     2.396    12.098     0.200
     2.421    13.430     0.200
     2.431    13.663     0.200
     2.447    12.311     0.200
     2.447    13.612     0.200
     2.449    13.723     0.200
     2.481    13.861     0.200
     2.514    11.480     0.200
     2.514    11.148     0.200
     2.629    14.370     0.200
     2.651    14.406     0.200
     2.679    13.203     0.200
     2.660    12.635     0.200
     2.660    12.854     0.200
     2.701    14.513     0.200
     2.752    13.257     0.200
     2.861    14.390     0.200
     2.922    13.508     0.200
     3.003    12.742     0.200
     3.095    15.582     0.200
     3.175    13.323     0.200
     3.181    15.305     0.200
     3.404    16.784     0.200
     3.414    16.484     0.200
     3.424    15.075     0.200
     3.479    14.767     0.200
     3.518    14.712     0.200
     3.590    15.589     0.200
     3.610    14.675     0.200
     3.622    17.534     0.200
     3.609    15.200     0.200
     3.750    15.585     0.200
     3.836    17.388     0.200
     3.890    17.843     0.200
     4.117    16.734     0.200
     4.105    17.668     0.200
     4.149    16.687     0.200
     4.149    17.335     0.200
     4.233    17.044     0.200
     4.233    17.465     0.200
     4.268    15.272     0.200
     4.268    14.623     0.200
     4.637    17.816     0.200
     4.693    18.353     0.200
     4.737    17.613     0.200
     4.921    20.166     0.200
     4.990    19.619     0.200
     5.036    18.963     0.200
     5.263    19.897     0.200
     5.549    20.167     0.200
     5.549    20.765     0.200
     5.699    20.149     0.200
     5.699    21.809     0.200
     5.794    20.278     0.200
     5.900    21.271     0.200
     6.074    22.228     0.200
     6.202    22.668     0.200
     6.272    21.652     0.200
     6.272    21.937     0.200
     6.361    23.216     0.200
     6.758    26.048     0.200
     6.802    22.222     0.200
     6.802    21.858     0.200
     7.075    24.013     0.200
     7.075    24.826     0.200
     7.189    26.244     0.200
     7.481    29.628     0.200
     7.482    24.785     0.200
     7.777    29.815     0.200
     7.808    28.072     0.200
     7.794    26.946     0.200
     8.126    25.248     0.200
     8.379    26.807     0.200
     8.538    24.281     0.200
     8.538    25.792     0.200
     8.775    26.673     0.200
     8.775    27.068     0.200
     8.800    29.468     0.200
     8.883    28.844     0.200
     8.936    28.719     0.200
     8.985    29.623     0.200
     8.996    29.913     0.200
     9.017    30.473     0.200
     9.120    30.655     0.200
     9.150    32.584     0.200
     9.439    29.751     0.200
     9.473    31.936     0.200
     9.732    30.536     0.200
     9.824    34.576     0.200
     9.876    30.767     0.200
     9.923    34.648     0.200
    10.528    31.329     0.200
    10.574    30.011     0.200
    10.611    32.534     0.200
    10.703    32.572     0.200
    10.751    32.956     0.200
    10.836    36.152     0.200
    11.185    37.307     0.200
    11.262    37.411     0.200
    11.894    38.022     0.200
    11.894    38.936     0.200
    12.137    38.620     0.200
    12.188    40.557     0.200
    12.322    38.763     0.200
    12.469    36.638     0.200
    12.469    37.176     0.200
    12.469    37.457     0.200
    12.667    34.929     0.200
    13.658    37.818     0.200
    15.605    40.943     0.200
    18.812    45.329     0.200
     1.520     9.396     0.200
     1.735     9.212     0.200
     1.812    10.827     0.200
     1.950     9.566     0.200
     2.101    11.873     0.200
     2.498    10.994     0.200
     2.439    11.256     0.200
     2.499    11.452     0.200
     2.691    11.291     0.200
     2.734    12.959     0.200
     2.800    12.504     0.200
     2.963    12.779     0.200
     3.237    14.118     0.200
     3.563    14.471     0.200
     5.565    19.253     0.200
     1.466    10.254     0.200
     1.484     9.738     0.200
     1.700     9.808     0.200
     2.406    11.625     0.200
     2.462    12.104     0.200
     2.501    11.215     0.200
     2.664    11.960     0.200
     2.697    11.916     0.200
     2.765    12.891     0.200
     2.931    12.371     0.200
     3.024    13.378     0.200
     3.195    13.751     0.200
     3.294    13.319     0.200
     3.529    14.569     0.200
     3.623    15.653     0.200
     4.135    18.508     0.200
     4.164    16.093     0.200
     4.186    16.068     0.200
     4.255    15.168     0.200
     4.560    16.312     0.200
     4.712    16.640     0.200
     5.547    20.630     0.200
     5.712    21.057     0.200
     6.266    21.701     0.200
     6.788    22.466     0.200
     7.497    26.835     0.200
    10.510    31.634     0.200
    12.473    38.985     0.200
     1.395     9.358     0.200
     1.475    10.116     0.200
     1.709     9.799     0.200
     1.927    10.132     0.200
     2.413    11.832     0.200
     2.472    12.087     0.200
     2.472    11.810     0.200
     2.497    11.370     0.200
     2.497    11.053     0.200
     2.669    12.328     0.200
     2.707    13.331     0.200
     2.773    13.100     0.200
     2.937    13.323     0.200
     3.209    14.881     0.200
     3.298    13.936     0.200
     3.452    16.019     0.200
     3.536    14.946     0.200
     3.631    14.761     0.200
     4.145    18.662     0.200
     4.173    16.333     0.200
     4.250    15.070     0.200
     4.250    14.637     0.200
     4.569    17.513     0.200
     4.722    19.104     0.200
     5.017    18.325     0.200
     5.054    18.956     0.200
     5.288    19.039     0.200
     5.548    20.044     0.200
     5.548    20.235     0.200
     5.720    21.689     0.200
     6.265    21.560     0.200
     6.783    21.593     0.200
     6.783    22.014     0.200
     7.093    22.876     0.200
     7.093    23.833     0.200
     7.506    25.381     0.200
     8.376    26.958     0.200
     8.753    27.375     0.200
     9.018    30.024     0.200
    10.502    30.891     0.200
     1.427    10.113     0.200
     1.645    10.741     0.200
     1.645    10.921     0.200
     1.675     9.733     0.200
     1.740    11.285     0.200
     1.916    10.219     0.200
     2.024    11.465     0.200
     2.201    10.790     0.200
     2.387    11.942     0.200
     2.423    11.907     0.200
     2.430    11.904     0.200
     2.532    10.889     0.200
     2.532    11.081     0.200
     2.657    12.439     0.200
     2.659    13.167     0.200
     2.738    13.130     0.200
     2.914    13.320     0.200
     2.979    12.695     0.200
     3.166    14.647     0.200
     3.484    14.548     0.200
     3.506    14.985     0.200
     3.569    16.539     0.200
     3.588    14.946     0.200
     3.595    15.484     0.200
     3.599    15.089     0.200
     3.828    16.891     0.200
     4.102    16.411     0.200
     4.097    16.669     0.200
     4.133    17.027     0.200
     4.161    16.690     0.200
     4.210    17.591     0.200
     4.210    18.259     0.200
     4.286    14.665     0.200
     4.286    14.989     0.200
     4.646    17.470     0.200
     4.662    16.645     0.200
     4.672    18.354     0.200
     4.746    17.913     0.200
     4.944    18.506     0.200
     5.240    20.027     0.200
     5.246    18.901     0.200
     5.467    18.318     0.200
     5.554    20.071     0.200
     5.554    20.645     0.200
     5.686    21.947     0.200
     5.686    21.404     0.200
     5.863    21.576     0.200
     5.884    19.417     0.200
     6.042    21.876     0.200
     6.071    21.837     0.200
     6.200    22.340     0.200
     6.282    22.171     0.200
     6.360    22.737     0.200
     6.549    23.798     0.200
     6.722    24.508     0.200
     6.756    24.297     0.200
     6.821    21.989     0.200
     7.064    24.085     0.200
     7.188    25.665     0.200
     7.282    23.987     0.200
     7.340    25.870     0.200
     7.399    25.111     0.200
     7.774    28.730     0.200
     7.793    26.583     0.200
     8.386    25.417     0.200
     8.386    26.319     0.200
     8.796    26.653     0.200
     8.799    33.799     0.200
     8.940    30.378     0.200
     8.989    31.153     0.200
     9.001    30.905     0.200
     9.438    29.629     0.200
     9.869    34.406     0.200
    10.551    31.488     0.200
    14.733    35.664     0.200
     1.623     8.593     0.200
     1.623     8.312     0.200
     1.857    10.099     0.200
     1.857    10.267     0.200
     1.928     9.989     0.200
     2.156    10.070     0.200
     2.210    11.226     0.200
     2.336    10.384     0.200
     2.438    11.085     0.200
     2.481    11.426     0.200
     2.577    10.870     0.200
     2.746    10.840     0.200
     2.746    10.730     0.200
     2.803    12.977     0.200
     2.972    12.847     0.200
     2.968    10.265     0.200
     3.008    13.068     0.200
     2.989    12.762     0.200
     3.047    13.168     0.200
     3.130    13.066     0.200
     3.186    12.927     0.200
     3.202    13.313     0.200
     3.332    13.509     0.200
     3.291    12.887     0.200
     3.291    12.367     0.200
     3.445    13.047     0.200
     3.497    15.274     0.200
     3.567    14.303     0.200
     3.567    14.026     0.200
     3.613    14.282     0.200
     3.613    14.497     0.200
     3.643    14.451     0.200
     3.761    14.573     0.200
     3.747    14.749     0.200
     3.933    15.159     0.200
     4.431    15.859     0.200
     4.426    16.165     0.200
     4.487    15.879     0.200
     4.764    17.761     0.200
     4.777    17.642     0.200
     4.831    17.372     0.200
     4.944    16.663     0.200
     5.155    19.113     0.200
     5.155    19.585     0.200
     5.237    18.484     0.200
     5.314    18.391     0.200
     5.380    19.586     0.200
     5.575    19.992     0.200
     5.701    20.102     0.200
     5.776    19.131     0.200
     5.789    19.434     0.200
     5.855    20.685     0.200
     6.158    21.004     0.200
     6.225    21.173     0.200
     6.283    19.841     0.200
     6.425    21.122     0.200
     7.034    20.907     0.200
     7.034    21.075     0.200
     7.187    23.140     0.200
     8.242    24.715     0.200
     9.071    25.363     0.200
     9.071    26.094     0.200
    10.935    30.072     0.200
    12.108    35.172     0.200
    17.510    39.575     0.200
     1.512     9.076     0.200
     1.512     8.935     0.200
     1.564     9.619     0.200
     1.632     8.259     0.200
     1.632     8.634     0.200
     1.913    10.541     0.200
     1.936     9.238     0.200
     2.347    10.408     0.200
     3.207    12.501     0.200
     3.437    14.915     0.200
     3.465    14.506     0.200
     5.045    19.899     0.200
     5.276    18.652     0.200
     5.333    18.251     0.200
     5.555    18.323     0.200
     5.578    18.474     0.200
     5.759    19.225     0.200
     5.789    19.322     0.200
     6.418    21.537     0.200
     6.763    20.923     0.200
     7.172    22.414     0.200
     1.404     9.597     0.200
     1.691     9.987     0.200
     1.711     8.902     0.200
     1.729    10.200     0.200
     2.096    10.569     0.200
     2.097    10.404     0.200
     2.104    10.300     0.200
     2.099    10.297     0.200
     2.099    10.398     0.200
     2.131    10.362     0.200
     2.292    10.849     0.200
     2.426    11.669     0.200
     2.616    10.641     0.200
     2.646    11.489     0.200
     2.682    11.658     0.200
     2.834    11.392     0.200
     2.864    12.135     0.200
     3.232    14.176     0.200
     3.363    13.748     0.200
     3.855    14.070     0.200
     3.883    15.967     0.200
     4.141    18.142     0.200
     4.666    17.431     0.200
     4.912    18.321     0.200
     5.374    20.235     0.200
     5.426    19.963     0.200
     5.674    20.423     0.200
     6.219    21.381     0.200
     1.564    10.189     0.200
     3.104    16.158     0.200
     1.477     9.575     0.200
     1.618     8.265     0.200
     1.815    10.780     0.200
     2.078     9.922     0.200
     2.085    10.249     0.200
     2.150    10.122     0.200
     2.424    10.029     0.200
     2.416    11.618     0.200
     2.439    11.272     0.200
     2.893    12.891     0.200
     2.981    13.305     0.200
     3.849    14.731     0.200
     4.177    14.668     0.200
     6.061    20.006     0.200
     6.721    21.061     0.200
     1.566    10.252     0.200
     1.646     9.216     0.200
     1.895    10.819     0.200
     1.973    11.070     0.200
     1.975    11.057     0.200
     1.975    10.745     0.200
     2.003    10.327     0.200
     2.119    10.550     0.200
     2.193    12.155     0.200
     2.310    11.761     0.200
     2.371    11.064     0.200
     2.550    12.128     0.200
     2.573    11.764     0.200
     2.658    11.166     0.200
     3.106    11.632     0.200
     3.631    15.311     0.200
     3.751    15.561     0.200
     3.806    15.831     0.200
     4.405    15.744     0.200
     4.970    18.681     0.200
     5.258    20.586     0.200
     5.383    20.182     0.200
     6.200    21.510     0.200
     6.952    21.912     0.200
     1.707    10.632     0.200
     1.928    10.928     0.200
     2.045    10.216     0.200
     2.398    11.044     0.200
     2.414    12.115     0.200
     2.415    13.471     0.200
     2.782    12.533     0.200
     3.479    15.000     0.200
     3.492    15.658     0.200
     3.663    14.683     0.200
     4.108    19.058     0.200
     4.224    17.438     0.200
     4.518    15.266     0.200
     4.942    17.857     0.200
     5.060    19.433     0.200
     5.219    21.406     0.200
     5.301    21.011     0.200
     5.699    19.380     0.200
     5.710    22.576     0.200
     5.731    20.507     0.200
     6.006    21.544     0.200
     6.015    20.765     0.200
     6.184    22.179     0.200
     6.323    22.479     0.200
     6.485    22.283     0.200
     6.654    23.782     0.200
     6.771    24.079     0.200
     6.851    21.783     0.200
     6.885    24.608     0.200
     7.464    26.782     0.200
     7.484    25.771     0.200
     7.679    30.336     0.200
     7.713    24.618     0.200
     7.805    25.666     0.200
     7.893    28.315     0.200
     8.001    27.896     0.200
     8.052    25.053     0.200
     8.101    24.316     0.200
     8.196    27.216     0.200
     8.368    25.301     0.200
     8.393    29.495     0.200
     8.572    27.482     0.200
     8.605    30.864     0.200
     8.774    26.949     0.200
     8.774    28.042     0.200
     8.851    31.761     0.200
     8.926    30.735     0.200
     9.028    26.821     0.200
     9.023    29.590     0.200
     9.058    29.964     0.200
     9.075    30.361     0.200
     9.085    30.851     0.200
     9.107    30.420     0.200
     9.112    31.065     0.200
     9.117    30.273     0.200
     9.121    30.260     0.200
     9.134    30.238     0.200
     9.138    30.359     0.200
     9.153    30.212     0.200
     9.175    30.197     0.200
     9.178    30.450     0.200
     9.185    30.217     0.200
     9.188    30.552     0.200
     9.252    30.995     0.200
     9.280    30.522     0.200
     9.356    30.689     0.200
     9.373    31.401     0.200
     9.511    32.066     0.200
     9.933    31.419     0.200
     9.956    34.341     0.200
    10.032    32.713     0.200
    10.443    33.040     0.200
    10.521    35.185     0.200
    10.775    32.067     0.200
    10.784    31.917     0.200
    10.794    33.758     0.200
    10.862    31.510     0.200
    11.214    31.448     0.200
    11.985    35.843     0.200
    12.574    38.742     0.200
    12.587    37.388     0.200
    12.587    37.324     0.200
    12.764    39.149     0.200
    12.860    39.798     0.200
    12.982    40.357     0.200
    13.062    38.783     0.200
    13.154    38.487     0.200
    13.479    39.611     0.200
    13.648    36.607     0.200
     1.696    10.596     0.200
     1.691    11.017     0.200
     1.714    10.636     0.200
     1.812    10.843     0.200
     1.915    11.666     0.200
     1.915    10.913     0.200
     2.029    10.780     0.200
     2.029    10.471     0.200
     2.397    12.836     0.200
     2.399    13.536     0.200
     2.399    12.728     0.200
     2.399    12.095     0.200
     2.435    12.065     0.200
     2.577    12.962     0.200
     2.756    11.901     0.200
     2.746    13.137     0.200
     2.765    12.974     0.200
     2.811    13.153     0.200
     2.977    13.610     0.200
     3.466    14.544     0.200
     3.479    14.104     0.200
     3.638    16.678     0.200
     4.096    17.522     0.200
     4.207    17.204     0.200
     4.510    15.707     0.200
     4.510    15.949     0.200
     4.888    19.554     0.200
     4.928    17.960     0.200
     5.071    19.294     0.200
     5.284    19.750     0.200
     5.694    19.258     0.200
     5.693    20.346     0.200
     5.715    20.314     0.200
     5.989    21.766     0.200
     6.003    19.603     0.200
     6.166    21.900     0.200
     6.306    22.484     0.200
     6.472    21.669     0.200
     6.636    23.965     0.200
     6.836    20.445     0.200
     6.868    24.807     0.200
     6.878    22.302     0.200
     7.466    23.999     0.200
     7.876    27.438     0.200
     7.882    23.513     0.200
     8.557    25.619     0.200
     8.719    24.256     0.200
     9.023    26.103     0.200
    10.770    29.752     0.200
    10.773    30.431     0.200
    10.773    32.329     0.200
    10.774    32.031     0.200
    12.570    38.626     0.200
     1.391     8.543     0.200
     1.540     8.723     0.200
     1.540     8.792     0.200
     1.569     9.397     0.200
     1.600     8.991     0.200
     1.840     9.145     0.200
     1.840     9.039     0.200
     1.865     9.781     0.200
     2.044    10.478     0.200
     2.044    10.305     0.200
     2.148    10.698     0.200
     2.164    11.701     0.200
     2.203    11.130     0.200
     2.335    10.324     0.200
     2.417    11.653     0.200
     2.471    10.394     0.200
     2.520    12.644     0.200
     2.557    11.279     0.200
     2.557    11.150     0.200
     2.645    10.477     0.200
     2.703    12.179     0.200
     2.859    10.823     0.200
     2.963    12.857     0.200
     3.071    13.215     0.200
     3.091    12.716     0.200
     3.171    13.116     0.200
     3.208    14.012     0.200
     3.221    12.907     0.200
     3.240    13.784     0.200
     3.384    13.680     0.200
     3.536    13.787     0.200
     3.640    14.663     0.200
     3.753    15.448     0.200
     3.984    16.156     0.200
     4.514    16.766     0.200
     4.609    15.949     0.200
     4.856    17.087     0.200
     4.980    18.748     0.200
     5.356    19.804     0.200
     5.497    17.719     0.200
     5.589    19.517     0.200
     5.589    19.296     0.200
     5.795    20.520     0.200
     5.924    20.569     0.200
     5.970    19.496     0.200
     6.077    21.045     0.200
     6.415    21.081     0.200
     7.155    21.973     0.200
     1.680    10.467     0.200
     1.704     9.895     0.200
     1.704    10.020     0.200
     1.703    10.422     0.200
     1.930    10.805     0.200
     2.029    10.056     0.200
     2.378    10.856     0.200
     2.408    11.136     0.200
     2.410    12.189     0.200
     2.410    11.386     0.200
     2.440    11.506     0.200
     2.591    13.444     0.200
     2.743    11.504     0.200
     2.743    11.348     0.200
     2.766    12.304     0.200
     2.766    12.589     0.200
     2.754    13.241     0.200
     2.828    12.157     0.200
     2.981    13.117     0.200
     3.021    12.125     0.200
     3.131    14.982     0.200
     3.182    14.734     0.200
     3.332    14.784     0.200
     3.481    14.916     0.200
     3.494    14.832     0.200
     3.542    15.462     0.200
     3.598    15.497     0.200
     3.644    14.406     0.200
     3.631    15.427     0.200
     3.683    15.589     0.200
     3.655    14.964     0.200
     3.655    14.692     0.200
     3.904    14.775     0.200
     4.029    17.050     0.200
     4.120    16.757     0.200
     4.111    16.374     0.200
     4.111    17.591     0.200
     4.185    16.847     0.200
     4.209    16.245     0.200
     4.209    16.526     0.200
     4.172    15.662     0.200
     4.498    15.551     0.200
     4.480    17.437     0.200
     4.583    18.280     0.200
     4.658    17.842     0.200
     4.837    17.399     0.200
     4.902    18.974     0.200
     4.902    18.429     0.200
     4.894    19.359     0.200
     4.982    18.687     0.200
     5.055    18.861     0.200
     5.274    19.771     0.200
     5.297    19.925     0.200
     5.309    20.569     0.200
     5.491    20.384     0.200
     5.511    16.859     0.200
     5.679    18.942     0.200
     5.712    19.912     0.200
     5.702    21.098     0.200
     5.759    20.127     0.200
     5.832    21.107     0.200
     5.867    21.704     0.200
     6.109    22.929     0.200
     6.465    21.847     0.200
     6.418    22.081     0.200
     6.816    22.745     0.200
     6.884    21.513     0.200
     7.034    22.541     0.200
     7.034    22.188     0.200
     7.098    24.329     0.200
     7.437    25.507     0.200
     8.552    27.357     0.200
     8.673    28.909     0.200
     8.673    27.985     0.200
     8.753    27.238     0.200
     8.753    26.495     0.200
     8.753    26.964     0.200
     8.753    26.134     0.200
     9.009    26.934     0.200
     9.009    26.629     0.200
     9.284    32.350     0.200
     9.501    30.139     0.200
     9.913    29.303     0.200
    10.764    31.606     0.200
    10.757    31.568     0.200
    10.757    31.256     0.200
    10.758    32.024     0.200
    10.844    33.396     0.200
    11.193    31.949     0.200
    11.413    34.350     0.200
    11.547    36.048     0.200
    11.569    36.106     0.200
    11.703    34.755     0.200
    11.808    36.847     0.200
    11.808    35.374     0.200
    11.966    35.570     0.200
    12.091    35.506     0.200
    12.281    36.668     0.200
    12.481    37.215     0.200
    12.514    38.008     0.200
    12.556    36.871     0.200
    12.571    37.857     0.200
    12.571    37.432     0.200
    12.743    40.323     0.200
    12.950    40.600     0.200
    12.997    38.637     0.200
    13.347    38.549     0.200
    13.497    40.196     0.200
    13.544    39.507     0.200
    13.630    38.347     0.200
    13.757    40.176     0.200
    13.756    41.483     0.200
    13.789    38.165     0.200
    13.865    38.991     0.200
    13.891    37.985     0.200
    13.891    38.092     0.200
    14.639    40.039     0.200
    14.797    40.456     0.200
    15.908    40.994     0.200
    17.770    41.174     0.200
    18.925    42.891     0.200
    18.925    43.874     0.200
    19.041    43.241     0.200
    19.379    43.612     0.200
    19.379    42.905     0.200
    19.648    43.694     0.200
    19.650    43.584     0.200
    19.695    42.647     0.200
    19.695    42.291     0.200
    19.818    43.031     0.200
    20.176    42.108     0.200
    20.746    41.548     0.200
    20.746    40.972     0.200
     1.542    10.635     0.200
     1.600    10.442     0.200
     1.693    10.690     0.200
     1.898    11.535     0.200
     2.203    12.679     0.200
     2.331    10.631     0.200
     3.177    13.561     0.200
     4.085    15.990     0.200
     4.452    16.524     0.200
     5.246    18.785     0.200
     5.545    19.960     0.200
     5.756    20.531     0.200
     6.628    20.862     0.200
     1.647     9.330     0.200
     1.860     9.407     0.200
     1.974    10.585     0.200
     1.999     9.396     0.200
     2.285    12.166     0.200
     2.374    10.491     0.200
     2.539    11.066     0.200
     2.648    11.345     0.200
     2.925    12.290     0.200
     4.120    14.193     0.200
     5.544    18.779     0.200
     5.687    18.252     0.200
     6.216    19.634     0.200
     6.643    20.046     0.200
     1.618     9.270     0.200
     1.922     9.420     0.200
     1.911    10.487     0.200
     2.336    10.301     0.200
     3.193    12.651     0.200
     4.091    13.444     0.200
     4.466    16.342     0.200
     1.705    10.662     0.200
     1.910    11.195     0.200
     1.910    10.510     0.200
     2.088    10.145     0.200
     2.205    10.760     0.200
     2.205    10.518     0.200
     2.307    10.719     0.200
     2.307    10.229     0.200
     2.307    10.373     0.200
     2.471    11.670     0.200
     2.604    11.917     0.200
     2.958    12.963     0.200
     3.085    12.891     0.200
     3.157    13.268     0.200
     3.428    16.422     0.200
     3.772    15.592     0.200
     3.892    16.291     0.200
     4.061    15.010     0.200
     4.431    16.687     0.200
     4.793    19.016     0.200
     5.227    18.992     0.200
     5.300    18.894     0.200
     5.412    19.331     0.200
     5.507    19.455     0.200
     5.529    19.387     0.200
     5.743    19.832     0.200
     5.869    20.600     0.200
     5.974    20.394     0.200
     6.225    21.283     0.200
     6.605    21.666     0.200
     1.391     9.478     0.200
     1.554     9.561     0.200
     1.597     8.103     0.200
     1.898     9.114     0.200
     1.913    10.460     0.200
     2.098     9.469     0.200
     2.213    11.729     0.200
     2.315     9.918     0.200
     2.338    11.839     0.200
     2.480    11.118     0.200
     3.169    12.922     0.200
     3.432    13.354     0.200
     3.784    15.205     0.200
     3.900    15.911     0.200
     4.069    13.557     0.200
     4.442    15.725     0.200
     4.798    17.202     0.200
     5.238    18.066     0.200
     5.238    18.495     0.200
     5.541    19.249     0.200
     5.881    19.391     0.200
     5.984    19.532     0.200
     6.612    20.476     0.200
     6.612    20.760     0.200
    14.464    32.501     0.200
     1.907     9.403     0.200
     1.912    10.680     0.200
     2.104    10.000     0.200
     2.215     9.761     0.200
     2.323    10.362     0.200
     2.323    10.024     0.200
     2.346    11.803     0.200
     3.178    12.303     0.200
     3.433    14.208     0.200
     3.792    14.268     0.200
     3.903    15.534     0.200
     4.077    14.449     0.200
     4.451    16.306     0.200
     5.247    18.225     0.200
     5.549    19.996     0.200
     5.994    19.802     0.200
     6.620    20.888     0.200
     1.416     9.549     0.200
     1.608     9.798     0.200
     1.679    10.664     0.200
     1.701    10.555     0.200
     1.701    11.125     0.200
     1.723    10.314     0.200
     1.822    10.339     0.200
     1.924    10.912     0.200
     1.954    10.659     0.200
     1.985    11.072     0.200
     2.037    11.010     0.200
     2.252    13.089     0.200
     2.321    14.503     0.200
     2.321    14.302     0.200
     2.332    14.316     0.200
     2.390    11.008     0.200
     2.407    11.565     0.200
     2.409    11.488     0.200
     2.444    11.141     0.200
     2.586    12.683     0.200
     2.757    11.495     0.200
     2.756    12.712     0.200
     3.475    14.793     0.200
     3.654    13.572     0.200
     4.119    14.913     0.200
     4.512    15.836     0.200
     4.934    17.302     0.200
     5.703    19.118     0.200
     6.007    20.456     0.200
     6.175    20.114     0.200
     1.577     8.887     0.200
     1.680     8.568     0.200
     1.784     9.743     0.200
     1.786     9.651     0.200
     1.928     7.416     0.200
     1.922    10.016     0.200
     2.167    10.614     0.200
     2.262     9.997     0.200
     2.376    11.076     0.200
     2.436    10.303     0.200
     2.886    10.540     0.200
     2.886    10.890     0.200
     3.091    10.447     0.200
     3.411    13.123     0.200
     3.788    13.884     0.200
     4.262    14.858     0.200
     4.752    16.237     0.200
     5.612    17.880     0.200
     5.889    18.557     0.200
     1.470     9.092     0.200
     1.559     9.260     0.200
     1.607     9.062     0.200
     1.642     8.396     0.200
     1.682     8.808     0.200
     1.921     8.993     0.200
     1.961    10.334     0.200
     1.961    10.233     0.200
     2.265    10.653     0.200
     2.267    11.167     0.200
     2.267    10.995     0.200
     2.311    10.504     0.200
     2.535    11.098     0.200
     3.200    12.888     0.200
     3.483    11.916     0.200
     3.512    13.255     0.200
     3.828    12.988     0.200
     3.955    14.795     0.200
     4.066    14.686     0.200
     4.466    16.112     0.200
     4.851    17.289     0.200
     5.269    17.978     0.200
     5.291    17.242     0.200
     5.800    20.374     0.200
     6.283    21.882     0.200
     6.608    19.859     0.200
     1.620     8.900     0.200
     1.670     9.631     0.200
     1.764     9.349     0.200
     1.853     9.253     0.200
     1.854     9.988     0.200
     1.854     9.379     0.200
     2.010     9.289     0.200
     2.006    10.402     0.200
     2.291    10.003     0.200
     2.333    10.647     0.200
     2.452    10.355     0.200
     2.565    12.407     0.200
     2.904     8.782     0.200
     2.934    11.292     0.200
     3.491    13.877     0.200
     4.830    16.942     0.200
     5.798    19.399     0.200
     5.963    19.865     0.200
     1.920    11.032     0.200
     2.035    10.236     0.200
     2.405    11.898     0.200
     3.077    15.695     0.200
     2.752    12.965     0.200
     2.758    11.587     0.200
     2.983    13.477     0.200
     3.541    15.167     0.200
     5.721    20.589     0.200
    12.576    36.716     0.200
     1.438     8.812     0.200
     1.557     9.246     0.200
     1.557     8.966     0.200
     1.610     9.159     0.200
     1.610    10.479     0.200
     1.657     9.550     0.200
     1.753    10.076     0.200
     1.812     9.889     0.200
     1.812    10.161     0.200
     1.946     9.915     0.200
     1.958    11.093     0.200
     1.977     9.994     0.200
     2.332     9.685     0.200
     3.222    12.836     0.200
     3.482    13.471     0.200
     3.510    14.217     0.200
     5.819    20.100     0.200
     1.496     9.269     0.200
     1.633     9.835     0.200
     1.617     9.011     0.200
     1.828    10.800     0.200
     2.086     9.633     0.200
     2.166    11.127     0.200
     2.402    10.025     0.200
     2.451    10.922     0.200
     3.364    14.123     0.200
     3.860    15.289     0.200
     4.156    14.803     0.200
     5.285    18.594     0.200
     5.285    18.748     0.200
     5.900    20.101     0.200
     6.048    20.342     0.200
     6.048    20.212     0.200
     6.700    21.176     0.200
     1.454    10.569     0.200
     1.693     9.884     0.200
     1.665     8.538     0.200
     1.824    11.087     0.200
     1.871     9.241     0.200
     2.217     9.993     0.200
     2.198    10.123     0.200
     2.376    11.585     0.200
     3.168    12.867     0.200
     3.614    15.557     0.200
     3.644    15.823     0.200
     3.846    15.538     0.200
     3.994    14.604     0.200
     4.271    14.678     0.200
     4.412    16.258     0.200
     4.973    17.220     0.200
     5.060    18.724     0.200
     5.161    18.222     0.200
     5.237    18.966     0.200
     5.579    20.047     0.200
     5.822    19.988     0.200
     5.939    20.964     0.200
     5.961    20.590     0.200
     5.944    20.554     0.200
     6.311    21.728     0.200
     6.415    21.856     0.200
     6.492    20.758     0.200
     6.600    22.476     0.200
     7.077    21.234     0.200
     7.183    20.729     0.200
     8.482    25.141     0.200
     8.596    24.979     0.200
     8.607    25.526     0.200
     8.632    25.537     0.200
     8.636    24.296     0.200
     8.703    25.804     0.200
     8.879    27.656     0.200
     1.626     9.241     0.200
     1.904     7.870     0.200
     1.925     9.617     0.200
     1.925     9.140     0.200
     2.156    11.026     0.200
     2.442     9.882     0.200
     2.442     9.531     0.200
     3.099    11.816     0.200
     3.139    12.627     0.200
     3.619    14.783     0.200
     3.616    15.474     0.200
     4.184    15.652     0.200
     4.410    15.766     0.200
     4.504    15.142     0.200
     5.520    18.317     0.200
     6.046    19.700     0.200
     6.458    19.732     0.200
     6.731    20.395     0.200
     6.922    22.224     0.200
     1.461     9.453     0.200
     1.638     9.996     0.200
     1.658     8.871     0.200
     1.768     9.427     0.200
     1.837    11.181     0.200
     1.843     9.559     0.200
     1.843    10.270     0.200
     1.843    11.781     0.200
     1.854     9.717     0.200
     1.868    11.858     0.200
     1.863     9.244     0.200
     1.872    10.992     0.200
     1.850     8.846     0.200
     1.850     8.686     0.200
     2.094    10.884     0.200
     2.122    10.532     0.200
     2.122    10.412     0.200
     2.121    10.430     0.200
     2.141    10.682     0.200
     2.138    10.281     0.200
     2.148    10.174     0.200
     2.169    10.460     0.200
     2.178    10.789     0.200
     2.182    10.339     0.200
     2.186    10.525     0.200
     2.188    10.572     0.200
     2.188    10.354     0.200
     2.188    10.171     0.200
     2.197    11.044     0.200
     2.202    10.326     0.200
     2.233    10.884     0.200
     2.392    11.185     0.200
     2.398    11.328     0.200
     2.410    11.337     0.200
     2.412    11.234     0.200
     2.449    11.549     0.200
     2.449    11.712     0.200
     2.435    10.654     0.200
     2.435    10.519     0.200
     2.480    11.560     0.200
     2.480    11.757     0.200
     2.599    12.200     0.200
     2.609    11.850     0.200
     2.648    11.994     0.200
     2.821    12.738     0.200
     2.864    11.627     0.200
     2.931    13.131     0.200
     2.931    13.305     0.200
     2.953    13.472     0.200
     3.031    13.011     0.200
     3.098    13.678     0.200
     3.194    13.304     0.200
     3.242    13.566     0.200
     3.334    14.027     0.200
     3.340    13.900     0.200
     3.374    14.109     0.200
     3.399    13.748     0.200
     3.525    13.984     0.200
     3.541    14.118     0.200
     3.714    13.215     0.200
     3.714    12.998     0.200
     3.843    15.969     0.200
     3.883    15.191     0.200
     3.885    15.198     0.200
     3.885    14.686     0.200
     4.025    14.860     0.200
     4.025    15.702     0.200
     4.175    15.167     0.200
     4.189    14.419     0.200
     4.189    14.259     0.200
     4.294    15.613     0.200
     4.388    16.077     0.200
     4.475    16.604     0.200
     4.494    16.544     0.200
     4.544    16.813     0.200
     4.754    17.001     0.200
     4.772    17.143     0.200
     4.759    16.993     0.200
     4.848    17.492     0.200
     4.975    18.705     0.200
     5.027    17.652     0.200
     5.133    17.206     0.200
     5.133    20.446     0.200
     5.173    18.242     0.200
     5.249    18.187     0.200
     5.301    18.181     0.200
     5.328    19.167     0.200
     5.328    19.655     0.200
     5.343    17.766     0.200
     5.426    19.540     0.200
     5.425    18.220     0.200
     5.613    20.826     0.200
     5.636    20.001     0.200
     5.626    18.975     0.200
     5.691    20.708     0.200
     5.704    19.297     0.200
     5.809    20.351     0.200
     5.878    20.560     0.200
     5.913    19.084     0.200
     5.941    21.362     0.200
     6.090    20.885     0.200
     6.286    22.139     0.200
     6.350    21.677     0.200
     6.399    22.388     0.200
     6.500    23.345     0.200
     6.632    19.656     0.200
     6.657    21.407     0.200
     6.733    21.166     0.200
     6.733    21.036     0.200
     6.800    22.512     0.200
     7.082    25.206     0.200
     7.105    21.676     0.200
     7.106    24.422     0.200
     7.133    23.421     0.200
     7.188    23.615     0.200
     7.222    24.132     0.200
     7.222    23.981     0.200
     7.465    25.160     0.200
     7.496    25.650     0.200
     7.515    25.702     0.200
     7.525    25.566     0.200
     7.574    23.856     0.200
     7.739    20.916     0.200
     7.754    23.440     0.200
     8.009    23.475     0.200
     8.170    25.993     0.200
     8.400    24.850     0.200
     8.400    25.022     0.200
     8.450    29.369     0.200
     8.542    27.779     0.200
     8.632    27.607     0.200
     8.675    28.754     0.200
     8.706    28.310     0.200
     8.736    28.605     0.200
     8.739    25.899     0.200
     8.739    25.477     0.200
     8.772    27.162     0.200
     8.865    29.073     0.200
     8.884    29.774     0.200
     8.939    27.066     0.200
     8.939    29.283     0.200
     8.955    29.517     0.200
     8.955    29.324     0.200
     8.972    29.079     0.200
     9.063    30.007     0.200
     9.198    28.072     0.200
     9.198    27.881     0.200
     9.322    29.872     0.200
     9.384    27.688     0.200
     9.533    28.608     0.200
     9.604    30.133     0.200
     9.602    28.384     0.200
     9.658    31.075     0.200
     9.661    31.362     0.200
     9.832    31.035     0.200
    10.014    29.725     0.200
    10.071    29.210     0.200
    10.085    31.621     0.200
    10.150    32.639     0.200
    10.261    31.201     0.200
    10.387    30.309     0.200
    10.387    30.594     0.200
    10.391    31.400     0.200
    10.464    31.465     0.200
    10.464    33.086     0.200
    10.478    31.544     0.200
    10.553    30.503     0.200
    10.553    30.151     0.200
    10.554    30.269     0.200
    10.824    31.491     0.200
    11.093    31.937     0.200
    11.093    32.913     0.200
    11.142    34.415     0.200
    11.583    33.266     0.200
    11.583    34.244     0.200
    11.655    36.710     0.200
    11.655    36.039     0.200
    11.775    35.480     0.200
    11.862    36.101     0.200
    11.923    33.619     0.200
    11.986    36.325     0.200
    12.046    34.241     0.200
    12.148    33.489     0.200
    12.148    35.031     0.200
    12.173    33.645     0.200
    12.207    34.875     0.200
    12.207    36.097     0.200
    12.208    35.666     0.200
    12.208    35.346     0.200
    12.208    36.176     0.200
    12.371    31.931     0.200
    12.399    36.726     0.200
    12.499    37.460     0.200
    12.517    36.960     0.200
    12.695    36.532     0.200
    12.721    37.213     0.200
    12.789    37.363     0.200
    12.847    33.271     0.200
    12.894    39.782     0.200
    12.936    39.401     0.200
    12.971    37.338     0.200
    13.115    38.442     0.200
    13.252    35.864     0.200
    13.252    36.663     0.200
    13.345    34.140     0.200
    13.359    33.927     0.200
    13.363    37.766     0.200
    13.439    34.468     0.200
    13.439    38.799     0.200
    13.450    40.706     0.200
    13.549    36.619     0.200
    13.614    40.136     0.200
    13.600    36.527     0.200
    13.600    36.919     0.200
    13.616    37.133     0.200
    13.616    37.515     0.200
    13.641    39.342     0.200
    13.677    39.962     0.200
    13.720    40.595     0.200
    13.744    39.949     0.200
    13.752    39.830     0.200
    13.865    40.498     0.200
    14.383    39.329     0.200
    14.390    38.696     0.200
    14.448    38.332     0.200
    14.435    35.720     0.200
    14.473    37.186     0.200
    14.473    37.653     0.200
    14.617    39.421     0.200
    14.876    38.734     0.200
    15.170    40.633     0.200
    15.330    37.725     0.200
    15.443    39.674     0.200
    15.465    38.942     0.200
    15.467    38.574     0.200
    15.467    38.809     0.200
    15.468    38.309     0.200
    15.468    38.949     0.200
    15.514    39.780     0.200
    15.527    37.237     0.200
    15.527    39.393     0.200
    15.566    39.618     0.200
    15.571    39.891     0.200
    15.621    38.725     0.200
    15.637    40.997     0.200
    15.638    41.279     0.200
    15.652    39.138     0.200
    15.669    40.123     0.200
    15.681    39.976     0.200
    15.708    40.770     0.200
    15.714    40.243     0.200
    15.770    40.067     0.200
    15.781    40.488     0.200
    15.930    39.017     0.200
    15.961    40.532     0.200
    16.234    40.804     0.200
    16.274    40.500     0.200
    16.379    41.585     0.200
    16.559    38.435     0.200
    16.689    41.402     0.200
    16.749    41.202     0.200
    16.780    40.858     0.200
    16.864    41.446     0.200
    16.971    39.458     0.200
    17.068    40.470     0.200
    17.065    41.216     0.200
    17.065    40.892     0.200
    17.092    41.367     0.200
    17.139    39.723     0.200
    17.241    40.604     0.200
    17.250    41.638     0.200
    17.985    40.281     0.200
    18.588    42.482     0.200
    18.601    42.350     0.200
    18.604    42.202     0.200
    18.725    42.274     0.200
    18.926    43.602     0.200
    19.011    41.760     0.200
    19.086    42.168     0.200
    19.221    43.070     0.200
    19.313    42.257     0.200
    19.313    41.943     0.200
    19.335    41.795     0.200
    19.335    42.562     0.200
    19.668    42.158     0.200
    19.877    42.728     0.200
    20.065    41.866     0.200
    20.203    42.613     0.200
    20.259    42.240     0.200
    20.366    42.811     0.200
    20.544    42.061     0.200
    20.679    41.625     0.200
     1.452     9.017     0.200
     1.543     9.537     0.200
     1.641     9.936     0.200
     1.673     8.584     0.200
     1.842    10.856     0.200
     1.847    10.587     0.200
     1.847    10.632     0.200
     1.873    10.993     0.200
     1.879    10.209     0.200
     1.859     8.488     0.200
     2.134    10.136     0.200
     2.197    10.345     0.200
     2.446    10.501     0.200
     3.379    14.482     0.200
     3.404    11.379     0.200
     3.858    16.029     0.200
     4.200    14.574     0.200
     4.558    16.747     0.200
     4.804    21.794     0.200
     5.343    17.763     0.200
     5.628    19.802     0.200
     5.640    19.475     0.200
     5.824    19.064     0.200
     5.956    21.172     0.200
     6.104    20.637     0.200
     6.301    21.343     0.200
     6.743    21.275     0.200
     1.452     8.823     0.200
     1.471     8.898     0.200
     1.522     9.142     0.200
     1.556     8.874     0.200
     1.676     8.463     0.200
     1.861     8.187     0.200
     1.847     9.884     0.200
     2.019     9.468     0.200
     2.136     9.964     0.200
     2.199    10.010     0.200
     2.199    10.158     0.200
     2.449    10.279     0.200
     2.449    10.023     0.200
     2.449     9.722     0.200
     2.456    10.354     0.200
     2.493    11.206     0.200
     2.664    11.597     0.200
     5.631    19.274     0.200
     5.959    19.906     0.200
     6.303    20.100     0.200
     1.453     8.831     0.200
     1.522     9.293     0.200
     1.674     8.274     0.200
     1.859     8.294     0.200
     1.881     9.889     0.200
     2.016     9.509     0.200
     2.135     9.857     0.200
     2.199    10.019     0.200
     2.199     9.878     0.200
     2.446    10.309     0.200
     2.446    10.184     0.200
     2.493    11.042     0.200
     2.864    12.125     0.200
     3.380    14.322     0.200
     3.859    14.645     0.200
     4.200    15.578     0.200
     4.559    16.275     0.200
     5.344    16.781     0.200
     5.439    19.412     0.200
     5.629    19.271     0.200
     5.640    19.320     0.200
     5.825    19.503     0.200
     5.957    20.587     0.200
     6.743    21.649     0.200
     1.394     8.330     0.200
     1.599     9.508     0.200
     1.599     8.988     0.200
     1.607     9.315     0.200
     1.638     9.418     0.200
     1.672     9.877     0.200
     1.885     9.933     0.200
     2.667    10.711     0.200
     2.667    10.578     0.200
     5.647    19.810     0.200
     6.229    20.717     0.200
     4.924    17.178     0.200
     6.204    20.455     0.200
     6.311    21.745     0.200
     6.442    18.878     0.200
     6.534    20.202     0.200
     6.455    21.184     0.200
     1.442    10.750     0.200
     1.494    10.707     0.200
     1.494    10.496     0.200
     1.621    10.588     0.200
     1.826    11.225     0.200
     1.993    10.255     0.200
     2.169    12.614     0.200
     2.436    11.286     0.200
     4.535    17.390     0.200
     5.598    20.026     0.200
     1.463     9.816     0.200
     1.554    10.349     0.200
     1.738    10.515     0.200
     1.798    10.812     0.200
     1.810     9.721     0.200
     2.020    10.462     0.200
     2.159    11.736     0.200
     2.312    10.556     0.200
     2.312    10.658     0.200
     2.463    11.622     0.200
     3.320    13.283     0.200
     4.066    14.678     0.200
     4.066    14.201     0.200
     4.561    16.643     0.200
     5.190    17.857     0.200
     5.247    18.164     0.200
     5.389    19.486     0.200
     5.606    18.877     0.200
     5.730    20.774     0.200
     5.969    21.081     0.200
     6.090    20.549     0.200
     6.087    21.858     0.200
     6.093    21.378     0.200
     6.455    22.690     0.200
     7.726    24.335     0.200
     1.534     9.325     0.200
     1.599     9.077     0.200
     1.720     9.632     0.200
     1.818     9.351     0.200
     1.819     8.974     0.200
     2.041     9.507     0.200
     2.114    10.900     0.200
     2.341     9.831     0.200
     2.341    10.229     0.200
     2.343    10.484     0.200
     2.453    10.180     0.200
     2.727    12.132     0.200
     3.338    11.393     0.200
     3.647    13.858     0.200
     3.672    11.666     0.200
     4.003    13.818     0.200
     4.095    13.943     0.200
     4.095    14.322     0.200
     4.144    13.836     0.200
     4.583    15.221     0.200
     4.796    16.145     0.200
     4.973    16.176     0.200
     5.027    15.592     0.200
     5.277    16.668     0.200
     5.408    18.233     0.200
     5.408    19.057     0.200
     5.978    19.068     0.200
     6.113    18.733     0.200
     6.463    21.881     0.200
     6.629    18.788     0.200
     1.725     9.227     0.200
     2.017    10.795     0.200
     2.017    10.646     0.200
     2.070    10.801     0.200
     2.199    10.546     0.200
     2.214    12.027     0.200
     2.365    11.755     0.200
     2.552    11.256     0.200
     2.619    12.198     0.200
     2.708    11.161     0.200
     2.724    11.274     0.200
     2.724    10.516     0.200
     2.741    12.963     0.200
     3.119    13.464     0.200
     3.138    12.954     0.200
     3.159    13.927     0.200
     3.399    13.002     0.200
     3.408    14.065     0.200
     3.653    15.864     0.200
     3.726    15.306     0.200
     3.760    14.897     0.200
     3.882    15.473     0.200
     4.387    16.371     0.200
     4.473    16.148     0.200
     4.473    15.902     0.200
     4.526    16.023     0.200
     4.581    16.146     0.200
     4.724    17.419     0.200
     4.912    18.286     0.200
     5.464    20.598     0.200
     5.464    18.376     0.200
     5.685    20.167     0.200
     5.733    18.620     0.200
     5.756    20.567     0.200
     5.815    20.648     0.200
     5.834    20.068     0.200
     5.829    20.588     0.200
     5.978    21.072     0.200
     6.281    21.557     0.200
     6.291    20.520     0.200
     6.414    22.255     0.200
     6.508    21.074     0.200
     6.510    22.374     0.200
     6.922    20.724     0.200
     7.019    22.101     0.200
     7.016    20.654     0.200
     7.045    24.627     0.200
     7.045    23.131     0.200
     7.107    22.478     0.200
     7.119    24.439     0.200
     7.285    24.826     0.200
     7.342    22.705     0.200
     7.477    22.951     0.200
     7.524    23.774     0.200
     7.543    22.592     0.200
     7.604    22.771     0.200
     7.806    21.432     0.200
     7.990    22.197     0.200
     8.063    24.079     0.200
     8.150    24.126     0.200
     8.262    22.652     0.200
     8.268    24.508     0.200
     8.321    27.414     0.200
     8.321    24.789     0.200
     8.520    22.811     0.200
     8.584    24.204     0.200
     8.618    23.219     0.200
     8.926    25.396     0.200
     9.040    26.107     0.200
     9.117    27.798     0.200
     9.117    26.267     0.200
     9.579    27.331     0.200
    10.135    27.407     0.200
    10.319    26.926     0.200
    10.555    29.038     0.200
    10.872    30.960     0.200
    10.872    30.759     0.200
    10.872    31.381     0.200
    12.236    36.551     0.200
     1.406     9.611     0.200
     1.916     9.895     0.200
     2.233    10.713     0.200
     2.323    10.786     0.200
     2.323    10.669     0.200
     3.807    17.378     0.200
     4.460    16.704     0.200
     5.563    19.858     0.200
     5.904    20.273     0.200
     1.650     9.059     0.200
     1.650     9.213     0.200
     1.757    10.873     0.200
     1.757    10.019     0.200
     1.889    10.360     0.200
     1.927    11.289     0.200
     2.062    12.004     0.200
     2.136    10.988     0.200
     2.239    11.406     0.200
     2.345    10.852     0.200
     2.448    11.900     0.200
     2.873    11.371     0.200
     2.945    13.294     0.200
     2.959    13.660     0.200
     3.383    14.469     0.200
     3.466    14.453     0.200
     3.755    15.589     0.200
     4.128    16.096     0.200
     4.329    16.521     0.200
     4.607    17.519     0.200
     4.707    17.409     0.200
     4.726    17.026     0.200
     5.072    18.359     0.200
     5.419    18.911     0.200
     5.488    18.627     0.200
     5.581    19.408     0.200
     5.607    18.729     0.200
     5.681    19.541     0.200
     6.130    19.907     0.200
     1.633     9.399     0.200
     1.643     9.754     0.200
     1.643     9.463     0.200
     1.643     9.604     0.200
     1.718     9.467     0.200
     1.716    10.622     0.200
     1.716    10.182     0.200
     1.716     9.743     0.200
     1.826    10.593     0.200
     1.857     9.929     0.200
     1.842    10.184     0.200
     1.842    10.451     0.200
     1.826    10.751     0.200
     1.826    10.081     0.200
     1.869    10.727     0.200
     1.942    10.385     0.200
     1.989     9.764     0.200
     1.922    11.032     0.200
     2.011    10.202     0.200
     1.998    10.755     0.200
     2.046    11.569     0.200
     2.046    10.858     0.200
     2.059    10.953     0.200
     2.130    10.668     0.200
     2.084    11.596     0.200
     2.168    12.128     0.200
     2.168    11.622     0.200
     2.222    11.583     0.200
     2.199    11.579     0.200
     2.348    11.007     0.200
     2.348    10.857     0.200
     2.298    12.142     0.200
     2.424    12.167     0.200
     2.400    11.575     0.200
     2.400    10.934     0.200
     2.542    11.485     0.200
     2.518    13.042     0.200
     2.706    11.983     0.200
     2.706    11.723     0.200
     2.842    12.555     0.200
     2.863    12.560     0.200
     2.913    11.501     0.200
     2.869    12.729     0.200
     2.869    12.627     0.200
     3.090    13.093     0.200
     3.063    14.257     0.200
     3.191    13.941     0.200
     3.192    14.412     0.200
     3.367    14.165     0.200
     3.258    13.071     0.200
     3.472    12.628     0.200
     3.597    14.938     0.200
     3.716    14.783     0.200
     3.853    14.908     0.200
     3.804    15.013     0.200
     3.962    15.950     0.200
     4.045    15.772     0.200
     3.963    14.847     0.200
     4.044    16.379     0.200
     4.069    14.896     0.200
     4.069    14.377     0.200
     4.438    15.603     0.200
     4.438    15.710     0.200
     4.479    16.794     0.200
     4.534    16.920     0.200
     4.501    16.429     0.200
     4.577    17.283     0.200
     4.616    17.067     0.200
     4.601    16.523     0.200
     4.601    16.333     0.200
     4.753    17.002     0.200
     5.052    18.676     0.200
     5.102    17.239     0.200
     5.235    18.591     0.200
     5.374    18.324     0.200
     5.374    19.167     0.200
     5.350    18.442     0.200
     5.424    19.928     0.200
     5.446    19.420     0.200
     5.518    18.788     0.200
     5.696    21.232     0.200
     5.726    19.674     0.200
     5.769    19.834     0.200
     5.920    19.209     0.200
     5.920    20.561     0.200
     5.959    20.344     0.200
     6.089    20.227     0.200
     6.140    21.709     0.200
     6.140    21.857     0.200
     6.274    22.044     0.200
     6.507    22.690     0.200
     6.587    22.391     0.200
     6.587    21.958     0.200
     6.599    23.616     0.200
     6.656    21.801     0.200
     6.609    23.560     0.200
     6.945    22.711     0.200
     6.945    22.504     0.200
     6.991    24.179     0.200
     7.181    25.134     0.200
     7.520    25.573     0.200
     7.540    22.754     0.200
     7.633    20.525     0.200
     7.849    21.354     0.200
     7.901    26.976     0.200
     8.086    26.421     0.200
     8.731    27.269     0.200
     8.783    26.275     0.200
     8.783    27.806     0.200
     8.827    24.379     0.200
     8.861    26.918     0.200
     8.861    27.392     0.200
     9.649    29.029     0.200
     9.919    30.406     0.200
    10.069    30.158     0.200
    10.512    30.047     0.200
    10.892    31.966     0.200
    11.099    33.258     0.200
    11.357    33.090     0.200
    12.158    34.576     0.200
    12.279    38.519     0.200
    12.451    34.704     0.200
    12.562    33.941     0.200
    12.781    36.381     0.200
    12.768    37.040     0.200
    12.896    35.855     0.200
    12.896    37.607     0.200
    13.467    38.033     0.200
    13.677    37.768     0.200
    13.773    37.454     0.200
    13.899    37.740     0.200
    13.977    32.667     0.200
    14.146    37.630     0.200
    14.389    34.798     0.200
    14.428    35.156     0.200
    14.455    34.760     0.200
    14.461    34.879     0.200
    14.745    40.245     0.200
    14.727    34.259     0.200
    15.098    35.382     0.200
    15.098    40.046     0.200
    15.069    37.578     0.200
    15.187    34.974     0.200
    15.223    34.812     0.200
    15.843    36.446     0.200
    15.956    35.268     0.200
    15.985    36.299     0.200
    16.154    36.444     0.200
    16.415    36.232     0.200
    17.644    35.925     0.200
    17.663    35.649     0.200
    17.716    36.220     0.200
    17.779    37.325     0.200
    17.745    36.376     0.200
    18.275    38.082     0.200
    18.870    42.282     0.200
    18.970    41.982     0.200
    19.689    41.672     0.200
    19.788    41.350     0.200
    19.856    43.141     0.200
     1.482     9.947     0.200
     1.828    10.196     0.200
     1.942     9.064     0.200
     2.150    11.352     0.200
     2.150    11.575     0.200
     2.337    11.076     0.200
     2.393     9.916     0.200
     2.393    10.181     0.200
     2.576    12.439     0.200
     3.199    13.565     0.200
     4.484    15.961     0.200
     4.496    15.856     0.200
     5.569    18.994     0.200
     6.031    20.138     0.200
     1.409     8.047     0.200
     1.409     8.258     0.200
     1.418     8.901     0.200
     1.423     8.312     0.200
     1.422     8.345     0.200
     1.494     8.629     0.200
     1.531     8.474     0.200
     1.552     8.677     0.200
     1.646     9.080     0.200
     1.657     8.965     0.200
     1.670     9.174     0.200
     1.684     9.667     0.200
     1.730     8.660     0.200
     1.779     9.433     0.200
     1.869     8.538     0.200
     1.869    10.609     0.200
     1.868     9.101     0.200
     1.898    10.045     0.200
     1.964     9.650     0.200
     2.109     9.340     0.200
     2.109     9.235     0.200
     2.360    11.444     0.200
     2.398    10.539     0.200
     2.426    10.406     0.200
     2.479    10.747     0.200
     2.499    10.246     0.200
     2.545    11.805     0.200
     2.552    11.645     0.200
     2.666    11.493     0.200
     2.766    11.501     0.200
     2.845    11.972     0.200
     2.887    11.148     0.200
     2.887    10.987     0.200
     3.027    12.023     0.200
     3.565    13.242     0.200
     3.751    14.177     0.200
     3.980    15.568     0.200
     4.279    15.238     0.200
     4.642    15.058     0.200
     5.041    16.820     0.200
     5.320    17.287     0.200
     5.816    18.227     0.200
     6.072    20.568     0.200
     6.122    19.040     0.200
     6.128    19.404     0.200
     6.232    20.616     0.200
     6.587    19.932     0.200
     6.697    19.925     0.200
     6.942    21.743     0.200
     7.179    20.985     0.200
     7.885    22.635     0.200
     1.428     8.230     0.200
     1.428     8.176     0.200
     1.438     8.366     0.200
     1.646     7.963     0.200
     1.869     9.322     0.200
     1.869     9.197     0.200
     1.893     9.141     0.200
     1.947     9.324     0.200
     2.178     9.446     0.200
     2.203    10.117     0.200
     2.221     8.273     0.200
     2.226    10.160     0.200
     2.602    12.299     0.200
     2.764     9.993     0.200
     2.764    10.211     0.200
     2.856     9.852     0.200
     3.355    12.102     0.200
     3.579    12.274     0.200
     3.752    12.665     0.200
     3.783    12.057     0.200
     4.435    12.594     0.200
     4.506    12.448     0.200
     5.033    13.791     0.200
     5.275    14.188     0.200
     5.607    16.209     0.200
     5.876    19.344     0.200
     6.247    20.167     0.200
     1.468    10.381     0.200
     1.544    10.048     0.200
     1.532     9.926     0.200
     1.638    10.115     0.200
     1.695    10.688     0.200
     1.815    10.535     0.200
     1.832     9.652     0.200
     1.922    10.426     0.200
     2.002     9.932     0.200
     2.213    11.606     0.200
     2.212    13.286     0.200
     2.256     9.792     0.200
     2.528    12.937     0.200
     2.570    11.934     0.200
     2.965    14.284     0.200
     3.310    13.533     0.200
     4.007    14.802     0.200
     4.212    16.126     0.200
     4.767    16.584     0.200
     5.229    17.633     0.200
     5.736    21.138     0.200
     5.987    20.876     0.200
     6.061    20.600     0.200
     6.102    21.148     0.200
     6.477    22.658     0.200
     6.581    21.681     0.200
     1.508     7.740     0.200
     1.650     8.274     0.200
     1.675     9.615     0.200
     1.829     9.840     0.200
     1.830     9.471     0.200
     1.856     9.441     0.200
     1.929     9.701     0.200
     2.016    10.482     0.200
     2.153    10.580     0.200
     2.149    10.832     0.200
     2.196    10.464     0.200
     2.203     9.734     0.200
     2.268     8.579     0.200
     2.357    10.441     0.200
     2.485    11.169     0.200
     2.520    10.196     0.200
     2.806    10.285     0.200
     2.999    11.702     0.200
     3.210    12.458     0.200
     3.369    13.129     0.200
     3.540    13.486     0.200
     3.629    13.787     0.200
     3.705    13.817     0.200
     3.777    14.071     0.200
     4.052    14.590     0.200
     4.179    14.777     0.200
     4.328    14.904     0.200
     4.546    14.886     0.200
     4.546    15.491     0.200
     4.758    15.869     0.200
     4.998    15.892     0.200
     5.137    19.236     0.200
     5.412    17.771     0.200
     5.412    18.898     0.200
     5.566    19.127     0.200
     5.568    19.849     0.200
     5.595    19.753     0.200
     5.660    20.186     0.200
     5.710    19.632     0.200
     5.834    18.888     0.200
     5.867    19.780     0.200
     6.164    20.544     0.200
     6.267    20.571     0.200
     6.292    20.848     0.200
     6.439    21.359     0.200
     7.092    20.439     0.200
     7.092    20.768     0.200
     7.326    22.514     0.200
     8.276    25.901     0.200
     9.132    25.461     0.200
     1.650     8.314     0.200
     1.675     9.280     0.200
     1.830     9.557     0.200
     1.856     9.393     0.200
     2.153    10.044     0.200
     2.202     9.666     0.200
     2.275     9.052     0.200
     2.805    10.678     0.200
     5.594    19.442     0.200
     1.455     8.507     0.200
     1.543     9.445     0.200
     1.572     8.833     0.200
     1.572     8.813     0.200
     1.588     9.532     0.200
     1.613     8.137     0.200
     1.668    10.115     0.200
     1.749     8.566     0.200
     1.876    10.891     0.200
     1.940    10.641     0.200
     2.025    10.394     0.200
     2.027    10.237     0.200
     2.050    10.108     0.200
     2.179     8.888     0.200
     2.197    12.091     0.200
     2.224     9.767     0.200
     2.352    11.074     0.200
     2.472    11.139     0.200
     2.747    10.938     0.200
     3.137    12.969     0.200
     3.360    11.914     0.200
     3.387    13.265     0.200
     3.433    13.272     0.200
     4.371    15.565     0.200
     4.397    16.284     0.200
     4.497    15.559     0.200
     4.592    16.729     0.200
     4.929    15.122     0.200
     5.190    15.680     0.200
     5.708    19.100     0.200
     5.764    19.878     0.200
     5.850    20.214     0.200
     5.964    20.746     0.200
     6.000    20.881     0.200
     6.175    17.450     0.200
     6.311    20.724     0.200
     6.435    19.775     0.200
     1.376     8.252     0.200
     1.432     8.576     0.200
     1.447     8.577     0.200
     1.447     8.733     0.200
     1.527     9.305     0.200
     1.580     8.284     0.200
     1.637     9.195     0.200
     1.650     9.321     0.200
     1.650     9.219     0.200
     1.680     8.750     0.200
     1.713    10.271     0.200
     1.742     7.014     0.200
     1.717     9.664     0.200
     1.797     8.762     0.200
     1.745    10.244     0.200
     1.745     9.564     0.200
     1.909     7.851     0.200
     1.909     8.047     0.200
     1.919     8.849     0.200
     1.976    11.073     0.200
     2.029    11.381     0.200
     2.040    11.314     0.200
     2.203     9.480     0.200
     2.391    10.639     0.200
     2.417    11.625     0.200
     2.435    10.805     0.200
     2.452    10.789     0.200
     2.531    10.091     0.200
     2.531     9.911     0.200
     2.664    12.078     0.200
     2.660    11.182     0.200
     2.743    11.960     0.200
     2.804    12.213     0.200
     3.486    13.127     0.200
     3.593    15.108     0.200
     3.820    15.193     0.200
     4.105    15.169     0.200
     4.138    14.358     0.200
     4.215    15.515     0.200
     4.285    13.911     0.200
     4.285    14.348     0.200
     4.349    14.824     0.200
     4.502    16.201     0.200
     4.529    15.572     0.200
     4.747    15.714     0.200
     4.794    18.035     0.200
     4.829    16.122     0.200
     4.939    18.024     0.200
     4.975    16.260     0.200
     4.979    17.203     0.200
     5.245    16.607     0.200
     5.465    16.729     0.200
     5.556    18.434     0.200
     5.572    16.291     0.200
     5.738    17.524     0.200
     5.806    18.658     0.200
     5.865    19.613     0.200
     6.074    20.168     0.200
     6.148    20.366     0.200
     6.175    20.838     0.200
     6.203    19.626     0.200
     6.283    19.413     0.200
     6.283    18.913     0.200
     6.365    19.737     0.200
     6.381    21.701     0.200
     6.553    20.674     0.200
     6.820    20.253     0.200
     6.820    20.026     0.200
     6.905    21.390     0.200
     7.350    19.730     0.200
     7.437    18.981     0.200
     8.142    22.510     0.200
     8.240    23.454     0.200
     8.388    24.850     0.200
     8.684    26.782     0.200
     8.802    24.547     0.200
     8.909    25.949     0.200
     8.909    25.721     0.200
     8.920    25.150     0.200
     8.946    24.510     0.200
     8.948    26.264     0.200
     8.952    22.750     0.200
     9.183    25.846     0.200
     9.117    27.194     0.200
     9.188    24.607     0.200
     9.191    25.719     0.200
    10.549    29.375     0.200
     1.335     7.352     0.200
     1.430     7.790     0.200
     1.532     8.375     0.200
     1.649     7.599     0.200
     1.637     7.898     0.200
     1.765     8.313     0.200
     1.765     8.437     0.200
     1.782     9.512     0.200
     1.969     9.084     0.200
     2.129    10.460     0.200
     2.129    10.215     0.200
     2.268     9.484     0.200
     2.306     9.924     0.200
     2.441    10.294     0.200
     2.449    10.064     0.200
     2.505    10.777     0.200
     2.701    11.229     0.200
     2.726    11.196     0.200
     2.812    11.975     0.200
     2.879    12.377     0.200
     3.128    12.380     0.200
     3.147    12.360     0.200
     3.292    12.813     0.200
     3.683    13.799     0.200
     3.947    14.063     0.200
     4.023    13.082     0.200
     4.125    14.513     0.200
     4.393    16.040     0.200
     4.510    14.937     0.200
     4.775    15.826     0.200
     4.845    15.607     0.200
     4.934    17.440     0.200
     4.949    16.695     0.200
     5.026    16.673     0.200
     5.135    17.211     0.200
     5.152    17.817     0.200
     5.211    17.050     0.200
     5.338    17.560     0.200
     5.534    18.148     0.200
     5.535    18.269     0.200
     5.556    17.743     0.200
     5.638    19.151     0.200
     5.638    18.880     0.200
     5.681    18.073     0.200
     5.875    18.686     0.200
     5.875    19.787     0.200
     5.923    18.930     0.200
     6.039    18.646     0.200
     6.040    18.376     0.200
     6.054    19.257     0.200
     6.143    18.645     0.200
     6.293    18.288     0.200
     6.383    20.627     0.200
     6.410    19.218     0.200
     6.515    18.701     0.200
     6.558    18.754     0.200
     6.558    20.127     0.200
     6.555    18.784     0.200
     7.281    20.522     0.200
     7.356    20.405     0.200
     7.467    22.519     0.200
     7.599    20.601     0.200
     7.604    21.330     0.200
     7.685    22.501     0.200
     8.159    23.067     0.200
     8.159    25.251     0.200
     8.294    22.269     0.200
     8.294    24.627     0.200
     8.294    24.294     0.200
     8.537    23.440     0.200
     8.537    24.576     0.200
     8.928    23.739     0.200
     8.960    23.892     0.200
     9.001    23.650     0.200
     9.073    24.843     0.200
     9.382    29.403     0.200
     9.903    25.422     0.200
    10.133    26.338     0.200
    10.311    27.191     0.200
    10.311    29.016     0.200
    10.336    26.370     0.200
    10.343    27.316     0.200
    10.754    25.858     0.200
    10.948    27.748     0.200
    12.306    36.049     0.200
    12.416    30.506     0.200
    13.397    32.439     0.200
    15.337    35.797     0.200
    15.561    37.006     0.200
    15.580    35.843     0.200
    16.166    37.354     0.200
    16.952    37.163     0.200
     1.583     8.818     0.200
     1.738     8.709     0.200
     2.029    11.019     0.200
     2.030     9.949     0.200
     2.053    10.119     0.200
     2.160     9.096     0.200
     2.208     9.825     0.200
     2.362    11.396     0.200
     2.447    11.130     0.200
     2.462     9.957     0.200
     2.728    10.395     0.200
     3.115    14.285     0.200
     3.895    15.290     0.200
     4.400    13.586     0.200
     4.594    15.519     0.200
     5.698    18.083     0.200
     1.421     8.568     0.200
     1.609     9.388     0.200
     1.629     9.351     0.200
     1.693    10.514     0.200
     1.751    10.345     0.200
     1.776     9.719     0.200
     1.783     9.172     0.200
     1.783     9.780     0.200
     1.808     8.983     0.200
     1.884     9.862     0.200
     1.950    10.981     0.200
     1.957    11.549     0.200
     2.002    11.290     0.200
     2.110    10.532     0.200
     2.101    10.805     0.200
     2.148    10.656     0.200
     2.185     9.744     0.200
     2.276     8.981     0.200
     2.319     9.440     0.200
     2.899    11.618     0.200
     4.007    15.372     0.200
     4.140    15.280     0.200
     4.711    16.955     0.200
     5.089    18.448     0.200
     5.521    19.290     0.200
     5.557    19.717     0.200
     5.826    18.212     0.200
     1.654     8.161     0.200
     1.675     9.302     0.200
     1.675     9.044     0.200
     2.007     8.248     0.200
     2.053     9.572     0.200
     2.055     9.411     0.200
     2.061     9.499     0.200
     2.078     9.312     0.200
     2.079     9.400     0.200
     2.295    11.354     0.200
     2.381    10.570     0.200
     2.387    10.161     0.200
     2.576    10.074     0.200
     2.593    11.068     0.200
     2.685    10.742     0.200
     2.797    12.473     0.200
     2.829    10.692     0.200
     3.160    12.428     0.200
     3.236    12.897     0.200
     3.296    13.227     0.200
     3.307    12.561     0.200
     3.535    11.042     0.200
     3.732    14.968     0.200
     3.808    14.510     0.200
     3.827    14.647     0.200
     3.978    15.311     0.200
     4.175    15.461     0.200
     4.327    13.917     0.200
     4.480    16.671     0.200
     4.611    15.967     0.200
     4.611    16.539     0.200
     4.904    17.641     0.200
     5.329    18.088     0.200
     5.369    18.264     0.200
     5.369    18.467     0.200
     5.617    19.588     0.200
     5.712    18.429     0.200
     5.780    17.831     0.200
     5.784    19.701     0.200
     5.808    19.947     0.200
     5.925    19.661     0.200
     6.165    20.471     0.200
     6.182    18.616     0.200
     6.371    21.576     0.200
     6.489    22.161     0.200
     6.873    20.609     0.200
     6.873    20.882     0.200
     6.873    20.999     0.200
     6.938    21.195     0.200
     7.067    23.829     0.200
     7.462    21.721     0.200
     8.221    24.746     0.200
     8.504    22.589     0.200
    11.288    30.153     0.200
     1.592     8.329     0.200
     1.646     8.281     0.200
     1.641     8.797     0.200
     1.772     8.783     0.200
     1.804     9.131     0.200
     1.804     9.744     0.200
     1.831     9.318     0.200
     1.831     9.451     0.200
     1.901     9.956     0.200
     2.028     9.039     0.200
     2.028     9.266     0.200
     2.094    10.500     0.200
     2.163    10.461     0.200
     2.163    10.739     0.200
     2.173    10.674     0.200
     2.277    10.946     0.200
     2.308    10.262     0.200
     2.308     9.844     0.200
     2.350    11.544     0.200
     2.378    10.955     0.200
     2.492    10.222     0.200
     2.492    10.581     0.200
     2.482    11.564     0.200
     2.523    11.297     0.200
     2.688    11.242     0.200
     2.830    11.308     0.200
     3.140    14.615     0.200
     3.092    12.448     0.200
     3.100    12.523     0.200
     3.184    12.658     0.200
     3.292    14.147     0.200
     3.446    13.289     0.200
     3.458    13.304     0.200
     3.576    14.193     0.200
     3.618    13.603     0.200
     3.824    14.360     0.200
     3.829    14.759     0.200
     3.844    14.404     0.200
     3.960    15.995     0.200
     4.039    14.400     0.200
     4.517    16.115     0.200
     4.941    18.278     0.200
     5.405    19.038     0.200
     5.412    18.990     0.200
     5.582    18.886     0.200
     1.465     9.045     0.200
     1.649     9.761     0.200
     1.645     9.541     0.200
     1.645     8.346     0.200
     1.672     9.722     0.200
     1.737    10.155     0.200
     1.795    10.396     0.200
     1.813    10.815     0.200
     1.821     9.840     0.200
     1.825     9.937     0.200
     1.827     9.431     0.200
     1.827     9.743     0.200
     1.827     9.853     0.200
     1.852     9.749     0.200
     1.852     9.331     0.200
     1.924     9.886     0.200
     2.014    10.765     0.200
     2.045    11.639     0.200
     2.151    11.139     0.200
     2.191    10.658     0.200
     2.198     9.874     0.200
     2.265     8.748     0.200
     2.295    11.175     0.200
     2.351    10.559     0.200
     2.378    10.525     0.200
     2.480    11.210     0.200
     2.520    10.261     0.200
     2.757    12.279     0.200
     2.803    10.563     0.200
     2.803    10.442     0.200
     2.939    12.712     0.200
     2.982     8.957     0.200
     2.995    12.616     0.200
     3.079    12.519     0.200
     3.153    12.760     0.200
     3.205    13.376     0.200
     3.364    13.395     0.200
     3.537    14.654     0.200
     3.702    15.140     0.200
     3.771    14.969     0.200
     4.048    15.572     0.200
     4.178    16.735     0.200
     4.198    14.898     0.200
     4.326    16.409     0.200
     4.395    16.445     0.200
     4.468    17.252     0.200
     4.542    14.274     0.200
     4.542    14.727     0.200
     4.542    13.715     0.200
     4.699    16.942     0.200
     4.753    17.709     0.200
     4.994    17.683     0.200
     5.283    18.497     0.200
     5.407    19.637     0.200
     5.407    19.176     0.200
     5.563    20.072     0.200
     5.589    20.009     0.200
     5.761    19.874     0.200
     5.833    21.208     0.200
     5.829    19.690     0.200
     5.835    18.444     0.200
     5.862    20.665     0.200
     5.991    18.413     0.200
     6.159    21.589     0.200
     6.262    21.317     0.200
     6.262    20.876     0.200
     6.434    22.935     0.200
     6.543    19.667     0.200
     6.726    20.154     0.200
     6.851    23.334     0.200
     7.003    21.830     0.200
     7.088    21.038     0.200
     7.088    20.527     0.200
     7.141    21.650     0.200
     7.322    22.923     0.200
     7.537    22.933     0.200
     8.271    26.096     0.200
     8.949    28.193     0.200
     9.129    25.499     0.200
     9.566    26.217     0.200
     9.655    26.577     0.200
    10.996    29.996     0.200
    10.997    30.475     0.200
    10.997    30.737     0.200
     1.570     9.788     0.200
     1.586    10.193     0.200
     1.667    10.116     0.200
     1.730    10.544     0.200
     1.773    11.610     0.200
     1.865    11.348     0.200
     1.872    10.632     0.200
     1.872    11.312     0.200
     1.985     9.361     0.200
     2.119    13.189     0.200
     2.209    10.328     0.200
     2.398    10.465     0.200
     2.408     9.652     0.200
     2.626    12.144     0.200
     4.162    15.838     0.200
     4.528    16.315     0.200
     5.811    20.177     0.200
     5.941    20.497     0.200
     1.405     7.901     0.200
     1.653     8.459     0.200
     1.671     8.525     0.200
     1.671     8.732     0.200
     1.824     9.620     0.200
     1.845     9.220     0.200
     1.955     9.852     0.200
     2.066     9.747     0.200
     2.177     8.880     0.200
     2.282    10.122     0.200
     2.315     8.433     0.200
     2.406    10.001     0.200
     2.433     9.034     0.200
     2.566    10.262     0.200
     2.882    11.635     0.200
     2.950    10.831     0.200
     3.379    13.587     0.200
     4.245    15.660     0.200
     5.563    19.863     0.200
     5.812    20.747     0.200
     1.769     9.455     0.200
     1.787     9.335     0.200
     1.930     9.590     0.200
     1.941     8.344     0.200
     2.030     8.549     0.200
     2.054    10.582     0.200
     2.095    10.432     0.200
     2.133    10.197     0.200
     2.208    11.144     0.200
     2.313    10.885     0.200
     2.396    10.264     0.200
     2.529    12.187     0.200
     2.548    10.144     0.200
     2.551    10.828     0.200
     2.657    11.370     0.200
     2.762    11.846     0.200
     2.770    11.142     0.200
     2.797    12.054     0.200
     2.873    12.213     0.200
     2.949    12.367     0.200
     3.015    12.411     0.200
     3.022    12.564     0.200
     3.124    12.995     0.200
     3.158    13.551     0.200
     3.301    11.711     0.200
     3.301    12.308     0.200
     3.411    12.880     0.200
     3.411    13.630     0.200
     3.485    14.177     0.200
     3.488    13.933     0.200
     3.488    13.515     0.200
     3.522    13.541     0.200
     3.567    14.230     0.200
     3.726    14.269     0.200
     3.833    14.754     0.200
     3.891    14.432     0.200
     3.893    15.151     0.200
     4.002    14.690     0.200
     4.085    15.053     0.200
     4.271    14.119     0.200
     4.282    13.674     0.200
     4.282    14.197     0.200
     4.328    15.839     0.200
     4.323    21.736     0.200
     4.355    15.850     0.200
     4.370    15.709     0.200
     4.480    16.963     0.200
     4.619    16.867     0.200
     4.633    16.479     0.200
     4.778    18.024     0.200
     4.874    18.145     0.200
     4.899    18.063     0.200
     4.921    17.599     0.200
     5.044    18.587     0.200
     5.159    18.321     0.200
     5.159    18.958     0.200
     5.591    18.432     0.200
     5.998    20.431     0.200
     6.431    21.533     0.200
     6.827    19.855     0.200
     6.827    20.675     0.200
     8.020    25.943     0.200
     8.383    25.083     0.200
     8.833    26.836     0.200
     8.876    25.636     0.200
     9.323    26.533     0.200
     9.400    28.175     0.200
    10.241    30.391     0.200
    10.277    28.806     0.200
    10.540    29.460     0.200
    10.768    30.024     0.200
    10.769    29.964     0.200
    10.769    30.785     0.200
    11.922    35.387     0.200
    11.922    32.542     0.200
    11.975    35.775     0.200
    16.370    39.623     0.200
    16.501    38.960     0.200
    18.781    42.008     0.200
     1.464     9.117     0.200
     1.690    10.270     0.200
     1.722    10.349     0.200
     1.734     9.924     0.200
     1.769     9.339     0.200
     1.783     9.442     0.200
     1.798     9.454     0.200
     1.936     9.259     0.200
     1.988    10.631     0.200
     2.003    10.729     0.200
     2.007    10.641     0.200
     2.048    11.103     0.200
     2.055    10.812     0.200
     2.092    10.411     0.200
     2.135    11.589     0.200
     2.200    11.030     0.200
     2.202    11.468     0.200
     2.313    11.556     0.200
     2.524    12.544     0.200
     2.524    12.286     0.200
     2.556    10.755     0.200
     2.556    10.638     0.200
     2.650    11.406     0.200
     3.113    13.450     0.200
     3.484    13.781     0.200
     3.568    15.441     0.200
     4.264    16.382     0.200
     4.289    15.030     0.200
     4.325    16.661     0.200
     4.442    15.995     0.200
     5.041    19.050     0.200
     5.372    18.758     0.200
     5.517    18.591     0.200
     5.568    19.003     0.200
     5.664    20.889     0.200
     5.980    20.641     0.200
     1.443     8.887     0.200
     1.463     9.056     0.200
     1.688    10.355     0.200
     1.770     9.831     0.200
     1.782     9.412     0.200
     1.797     9.426     0.200
     1.937     9.347     0.200
     2.136    11.316     0.200
     2.201    11.475     0.200
     2.557    10.389     0.200
     3.116    13.635     0.200
     3.114    13.402     0.200
     3.483    14.262     0.200
     3.568    14.879     0.200
     4.443    16.435     0.200
     5.372    19.083     0.200
     5.664    19.397     0.200
     1.463     8.993     0.200
     1.714     9.813     0.200
     1.809     9.037     0.200
     1.979     9.088     0.200
     2.343     9.955     0.200
     3.041    12.818     0.200
     3.593    14.814     0.200
     4.342    16.056     0.200
     5.370    19.466     0.200
     1.699    10.236     0.200
     1.725     9.610     0.200
     1.732    10.310     0.200
     1.744    11.929     0.200
     1.781    10.047     0.200
     1.793     9.170     0.200
     1.808     9.345     0.200
     1.835    12.389     0.200
     1.935     9.433     0.200
     1.997    12.020     0.200
     2.013    10.705     0.200
     2.016    12.148     0.200
     2.065    12.611     0.200
     2.140    11.352     0.200
     2.212    11.608     0.200
     2.551    10.706     0.200
     2.658     8.993     0.200
     2.794    16.148     0.200
     3.115    13.436     0.200
     4.443    16.483     0.200
     5.377    19.432     0.200
     5.670    20.151     0.200
     1.776    10.146     0.200
     1.933     9.627     0.200
     1.996    10.980     0.200
     2.129    11.748     0.200
     2.196    12.463     0.200
     3.109    14.288     0.200
     3.562    15.013     0.200
     4.438    16.485     0.200
     1.400     8.413     0.200
     1.469     8.791     0.200
     1.469     8.892     0.200
     1.524     9.392     0.200
     1.549     6.194     0.200
     1.513     8.655     0.200
     1.593     9.184     0.200
     1.559     8.389     0.200
     1.639     6.498     0.200
     1.654     9.562     0.200
     1.598     8.804     0.200
     1.658     9.312     0.200
     1.709     8.732     0.200
     1.691     9.932     0.200
     1.731     9.155     0.200
     1.765     9.427     0.200
     1.784     7.910     0.200
     1.848     9.632     0.200
     1.856     9.204     0.200
     1.897     9.039     0.200
     1.936     9.590     0.200
     1.946     8.241     0.200
     1.946     8.398     0.200
     2.046    10.483     0.200
     2.207     9.825     0.200
     2.353    10.725     0.200
     2.383    10.567     0.200
     2.397    10.757     0.200
     2.638    11.256     0.200
     2.746    12.067     0.200
     3.534    13.333     0.200
     4.088    15.517     0.200
     4.317    14.692     0.200
     4.317    13.555     0.200
     4.468    16.334     0.200
     4.716    16.138     0.200
     4.716    15.536     0.200
     4.770    17.436     0.200
     4.998    18.478     0.200
     4.998    17.876     0.200
     5.507    17.847     0.200
     6.722    21.177     0.200
     7.418    24.448     0.200
     8.572    26.016     0.200
     8.572    24.602     0.200
     8.572    25.407     0.200
     8.833    25.165     0.200
     9.242    26.742     0.200
     9.242    27.504     0.200
     9.222    26.178     0.200
     9.427    27.420     0.200
    10.047    30.255     0.200
    10.425    30.519     0.200
    10.598    30.916     0.200
    10.598    30.588     0.200
    10.808    31.717     0.200
    11.823    33.156     0.200
    12.447    32.629     0.200
    12.447    33.782     0.200
    15.352    35.843     0.200
    17.170    37.406     0.200
     1.441     7.904     0.200
     1.421     8.014     0.200
     1.450     8.430     0.200
     1.438     8.064     0.200
     1.474     8.912     0.200
     1.535     8.822     0.200
     1.562     8.757     0.200
     1.565     8.538     0.200
     1.599     8.193     0.200
     1.647     8.865     0.200
     1.696     9.203     0.200
     1.678     8.483     0.200
     1.737     9.612     0.200
     1.741     8.543     0.200
     1.812     9.860     0.200
     1.821    10.045     0.200
     1.870    10.127     0.200
     1.887     9.503     0.200
     1.907    10.260     0.200
     1.905     9.907     0.200
     1.906     9.755     0.200
     1.906     9.421     0.200
     1.934     9.726     0.200
     1.969     9.663     0.200
     2.032    10.325     0.200
     2.021     9.529     0.200
     2.032    10.360     0.200
     2.058     8.635     0.200
     2.068    10.645     0.200
     2.111    10.632     0.200
     2.204    10.418     0.200
     2.227    10.776     0.200
     2.281    10.643     0.200
     2.278     9.851     0.200
     2.303     8.590     0.200
     2.457    12.235     0.200
     2.449    10.639     0.200
     2.542    10.234     0.200
     2.576    11.940     0.200
     2.577    11.266     0.200
     2.683    12.984     0.200
     2.855    10.301     0.200
     2.968    12.334     0.200
     2.984    11.864     0.200
     2.983    11.542     0.200
     3.046    12.603     0.200
     3.303    11.916     0.200
     3.455    12.985     0.200
     3.604    12.448     0.200
     3.599    14.153     0.200
     3.616    13.899     0.200
     3.791    14.470     0.200
     3.870    14.721     0.200
     3.929    14.331     0.200
     3.963    15.161     0.200
     4.030    14.882     0.200
     4.144    14.973     0.200
     4.173    14.744     0.200
     4.261    15.166     0.200
     4.278    15.423     0.200
     4.384    15.553     0.200
     4.478    16.054     0.200
     4.599    14.548     0.200
     4.782    17.063     0.200
     4.774    16.015     0.200
     4.786    16.617     0.200
     4.847    17.548     0.200
     5.078    17.640     0.200
     5.219    18.552     0.200
     5.360    18.355     0.200
     5.501    19.147     0.200
     5.577    17.584     0.200
     5.687    19.820     0.200
     5.748    19.920     0.200
     5.877    18.623     0.200
     5.912    18.858     0.200
     6.050    18.538     0.200
     6.348    20.401     0.200
     6.674    19.958     0.200
     6.924    25.277     0.200
     6.924    21.771     0.200
     7.197    20.999     0.200
     8.044    22.727     0.200
     8.093    22.955     0.200
     8.234    23.473     0.200
     8.726    24.283     0.200
     8.729    22.516     0.200
     9.039    27.022     0.200
     9.039    26.651     0.200
     9.178    25.647     0.200
     9.606    27.474     0.200
     9.746    28.213     0.200
    11.026    30.442     0.200
    11.027    30.649     0.200
    11.027    30.774     0.200
     1.689     9.251     0.200
     1.793     9.674     0.200
     2.269    10.688     0.200
     2.356     9.429     0.200
     2.385    10.547     0.200
     2.490    11.591     0.200
     2.890    11.331     0.200
     4.747    15.637     0.200
     5.622    18.475     0.200
     1.650     9.151     0.200
     1.658    10.109     0.200
     1.680     8.769     0.200
     1.724    10.496     0.200
     1.711     8.253     0.200
     1.793     9.575     0.200
     1.859    10.588     0.200
     1.879     9.711     0.200
     1.895    10.419     0.200
     1.849     8.536     0.200
     2.015     9.669     0.200
     2.146    10.269     0.200
     2.213    10.644     0.200
     2.222    11.190     0.200
     2.421    10.795     0.200
     2.505    11.521     0.200
     2.621    12.666     0.200
     2.672    11.782     0.200
     3.021    10.862     0.200
     3.010    11.813     0.200
     3.117    12.251     0.200
     3.216    13.852     0.200
     4.192    15.384     0.200
     4.192    14.033     0.200
     4.558    16.203     0.200
     4.746    16.571     0.200
     5.111    19.949     0.200
     5.336    18.456     0.200
     5.479    19.462     0.200
     7.246    24.684     0.200
     7.869    25.295     0.200
     8.187    26.412     0.200
     8.409    24.681     0.200
     8.409    25.751     0.200
     8.409    25.212     0.200
     8.749    27.938     0.200
     8.749    27.723     0.200
     8.738    25.566     0.200
     8.738    25.175     0.200
     8.963    30.754     0.200
     9.223    26.620     0.200
     9.362    27.775     0.200
     9.819    32.864     0.200
     9.819    30.055     0.200
    10.548    31.080     0.200
    10.592    32.939     0.200
    11.167    34.871     0.200
    11.600    34.714     0.200
    11.678    32.643     0.200
    11.799    36.245     0.200
    12.071    37.116     0.200
    12.230    33.614     0.200
    14.478    38.403     0.200
    14.511    39.563     0.200
    15.195    36.178     0.200
    15.235    35.864     0.200
    15.547    40.370     0.200
    15.547    41.972     0.200
    15.717    39.784     0.200
    15.721    40.275     0.200
    16.250    40.335     0.200
    16.775    39.619     0.200
    17.089    42.023     0.200
    18.730    42.812     0.200
    19.329    43.276     0.200
     1.674     8.734     0.200
     1.674     8.926     0.200
     1.651    10.144     0.200
     1.644     9.329     0.200
     1.717    10.258     0.200
     1.713     8.355     0.200
     1.785     9.969     0.200
     1.871    10.269     0.200
     1.888    10.393     0.200
     1.850     8.631     0.200
     2.012    10.132     0.200
     1.983     9.168     0.200
     2.138    10.312     0.200
     2.123    11.716     0.200
     2.157    10.807     0.200
     2.198    14.985     0.200
     2.205    10.468     0.200
     2.205    10.910     0.200
     2.214    10.998     0.200
     2.414    11.086     0.200
     2.497    11.716     0.200
     2.613    12.425     0.200
     2.665    12.420     0.200
     2.665    12.080     0.200
     2.865    13.147     0.200
     2.873    11.952     0.200
     3.015    13.691     0.200
     3.015    12.601     0.200
     3.014    11.767     0.200
     3.209    13.567     0.200
     3.125    13.425     0.200
     3.260    13.639     0.200
     3.273    13.819     0.200
     3.354    16.940     0.200
     3.413    14.028     0.200
     3.413    15.348     0.200
     3.459    14.114     0.200
     3.859    15.297     0.200
     3.902    15.343     0.200
     3.959    15.911     0.200
     4.038    15.096     0.200
     4.038    18.053     0.200
     4.192    13.964     0.200
     4.192    14.136     0.200
     4.192    15.046     0.200
     4.526    16.663     0.200
     4.555    16.891     0.200
     4.738    17.149     0.200
     4.770    18.518     0.200
     4.861    18.357     0.200
     5.044    17.745     0.200
     5.119    21.718     0.200
     5.339    18.261     0.200
     5.485    20.629     0.200
     7.238    24.133     0.200
     7.875    24.858     0.200
     8.182    26.763     0.200
     8.407    26.312     0.200
     8.407    25.269     0.200
     8.407    27.378     0.200
     8.739    25.620     0.200
     8.739    26.312     0.200
     8.757    27.955     0.200
     8.757    28.119     0.200
     8.955    30.771     0.200
     9.215    27.719     0.200
     9.369    30.703     0.200
     9.736    30.245     0.200
     9.824    28.829     0.200
     9.824    33.301     0.200
    10.585    33.653     0.200
    10.551    31.095     0.200
    11.159    35.730     0.200
    11.083    33.705     0.200
    11.596    35.080     0.200
    11.670    35.476     0.200
    11.792    36.319     0.200
    12.064    37.397     0.200
    12.224    35.633     0.200
    12.817    37.271     0.200
    13.616    39.505     0.200
    14.477    40.331     0.200
    14.517    41.987     0.200
    15.159    41.763     0.200
    15.347    41.800     0.200
    15.468    42.186     0.200
    15.542    41.318     0.200
    15.717    38.578     0.200
    15.690    44.218     0.200
    15.933    43.094     0.200
    16.107    40.733     0.200
    16.086    41.063     0.200
    16.211    38.308     0.200
    16.243    41.889     0.200
    16.695    39.729     0.200
    16.767    43.184     0.200
    17.084    39.347     0.200
    17.091    42.615     0.200
    18.729    45.382     0.200
     1.653    10.279     0.200
     1.686     8.382     0.200
     1.794    11.964     0.200
     1.855    10.417     0.200
     1.877     9.844     0.200
     1.858     8.147     0.200
     2.023     9.360     0.200
     2.148    10.243     0.200
     2.212    10.171     0.200
     2.220    12.025     0.200
     2.426    12.993     0.200
     2.506    11.328     0.200
     2.676    12.311     0.200
     3.285    12.933     0.200
     3.391    12.316     0.200
     3.871    14.590     0.200
     5.353    17.230     0.200
     5.640    19.765     0.200
     5.646    18.804     0.200
     1.875     8.525     0.200
     2.021     9.587     0.200
     2.198    11.360     0.200
     4.597    14.602     0.200
     1.478     8.883     0.200
     1.579     9.328     0.200
     1.577     7.977     0.200
     1.698     8.814     0.200
     1.737     8.662     0.200
     1.776     9.505     0.200
     1.784    10.106     0.200
     1.809     9.863     0.200
     1.856     8.204     0.200
     1.868    10.150     0.200
     1.892     9.347     0.200
     1.908    10.121     0.200
     1.954     9.154     0.200
     2.031     9.653     0.200
     2.128    10.974     0.200
     2.160    10.314     0.200
     2.163     9.776     0.200
     2.178    10.467     0.200
     2.216    10.668     0.200
     2.225    10.270     0.200
     2.227     9.755     0.200
     2.227    10.192     0.200
     2.235    10.232     0.200
     2.241     9.695     0.200
     2.269    10.760     0.200
     2.439    12.149     0.200
     2.447    11.119     0.200
     2.521    10.711     0.200
     2.631    11.321     0.200
     2.690    11.742     0.200
     2.816    12.460     0.200
     3.405    12.647     0.200
     3.884    15.140     0.200
     3.925    15.000     0.200
     4.019    14.844     0.200
     4.202    15.306     0.200
     4.275    14.240     0.200
     4.429    16.029     0.200
     4.579    14.973     0.200
     4.574    15.895     0.200
     4.614    15.007     0.200
     4.761    15.388     0.200
     5.363    16.767     0.200
     5.652    18.420     0.200
     5.982    18.435     0.200
     6.118    19.558     0.200
     1.704     9.376     0.200
     1.808    10.452     0.200
     1.866     8.420     0.200
     2.040     9.565     0.200
     2.165    11.134     0.200
     2.225    10.143     0.200
     2.232    10.777     0.200
     2.239    10.251     0.200
     2.444    11.893     0.200
     2.521    11.654     0.200
     2.626    12.508     0.200
     2.693    12.630     0.200
     3.223    13.823     0.200
     3.400    14.056     0.200
     3.889    15.643     0.200
     3.924    15.263     0.200
     4.014    15.237     0.200
     4.212    15.654     0.200
     4.578    14.398     0.200
     4.612    14.830     0.200
     4.761    14.526     0.200
     1.468     8.997     0.200
     1.574     9.884     0.200
     1.841     9.027     0.200
     1.858    10.514     0.200
     1.875     9.511     0.200
     2.005     9.321     0.200
     2.138     9.918     0.200
     2.209    10.026     0.200
     2.218    10.645     0.200
     2.222     9.902     0.200
     2.412    12.647     0.200
     2.500    11.303     0.200
     2.619    12.273     0.200
     2.665    12.967     0.200
     3.268    13.075     0.200
     3.394    14.283     0.200
     3.584    13.383     0.200
     3.857    15.206     0.200
     4.006    14.780     0.200
     4.548    16.494     0.200
     4.597    16.419     0.200
     4.741    17.038     0.200
     5.446    18.641     0.200
     5.656    19.985     0.200
     5.824    20.090     0.200
     5.955    20.560     0.200
     6.093    20.685     0.200
     6.156    21.185     0.200
     6.414    20.954     0.200
     1.660     9.827     0.200
     2.080    13.813     0.200
     4.974    20.649     0.200
     1.433     8.715     0.200
     1.522     9.209     0.200
     1.535     8.521     0.200
     1.621     9.644     0.200
     1.689     9.901     0.200
     1.674     8.585     0.200
     1.744     8.326     0.200
     1.823    10.462     0.200
     1.848     9.671     0.200
     1.863    10.251     0.200
     1.879     8.620     0.200
     2.010     9.740     0.200
     2.127    10.188     0.200
     2.183    10.339     0.200
     2.190    10.945     0.200
     2.197    10.235     0.200
     2.413    11.064     0.200
     2.481    11.501     0.200
     2.586    11.533     0.200
     2.656    12.021     0.200
     3.385    11.599     0.200
     3.447    12.506     0.200
     4.218    14.153     0.200
     4.218    13.622     0.200
     5.350    18.771     0.200
     5.454    19.045     0.200
     6.412    21.787     0.200
     7.767    23.349     0.200
     8.768    26.171     0.200
     1.655    10.264     0.200
     1.722    10.737     0.200
     2.442    11.122     0.200
     3.281    13.283     0.200
     4.006    15.864     0.200
     4.562    16.557     0.200
     5.636    20.408     0.200
     5.642    19.706     0.200
     5.966    20.839     0.200
     1.588     9.714     0.200
     1.675     9.614     0.200
     1.680     8.779     0.200
     1.725     9.272     0.200
     1.965    10.659     0.200
     2.008    10.928     0.200
     2.018    10.470     0.200
     2.041    10.107     0.200
     2.070     9.971     0.200
     2.157     9.063     0.200
     2.198     9.954     0.200
     2.353    11.348     0.200
     2.366    10.955     0.200
     2.449    11.263     0.200
     2.467    11.256     0.200
     2.619    12.236     0.200
     2.723    10.924     0.200
     2.959    12.832     0.200
     3.049    12.656     0.200
     3.120    12.833     0.200
     3.727    13.958     0.200
     3.746    12.547     0.200
     4.093    14.831     0.200
     4.181    14.125     0.200
     4.387    14.618     0.200
     4.382    15.186     0.200
     4.581    16.881     0.200
     4.592    15.963     0.200
     5.372    18.201     0.200
     5.564    19.015     0.200
     5.685    18.926     0.200
     1.475     9.159     0.200
     1.577     8.824     0.200
     1.690     8.620     0.200
     1.865    10.176     0.200
     1.851     8.554     0.200
     1.887     9.500     0.200
     2.023     9.672     0.200
     2.155    10.258     0.200
     2.221    10.278     0.200
     2.228    10.708     0.200
     2.229    10.500     0.200
     2.235    10.199     0.200
     2.430    11.097     0.200
     2.442    10.344     0.200
     2.514    10.876     0.200
     2.628    10.962     0.200
     2.675    10.585     0.200
     2.682    11.622     0.200
     3.137    12.551     0.200
     3.156    11.685     0.200
     3.206    11.628     0.200
     3.286    12.805     0.200
     3.401    13.083     0.200
     3.426    13.151     0.200
     3.875    14.016     0.200
     3.975    14.716     0.200
     4.015    14.658     0.200
     4.051    13.238     0.200
     4.196    14.256     0.200
     4.196    12.586     0.200
     4.270    14.442     0.200
     4.307    15.539     0.200
     4.325    15.201     0.200
     4.422    15.759     0.200
     4.446    15.556     0.200
     4.450    15.309     0.200
     4.573    15.742     0.200
     4.566    16.543     0.200
     4.741    15.548     0.200
     4.755    16.101     0.200
     4.784    16.254     0.200
     4.978    17.372     0.200
     5.008    18.120     0.200
     5.061    15.707     0.200
     5.354    18.500     0.200
     5.425    18.151     0.200
     5.461    18.590     0.200
     5.528    16.560     0.200
     5.643    19.904     0.200
     5.645    18.023     0.200
     5.650    19.354     0.200
     5.707    18.073     0.200
     5.734    18.918     0.200
     5.842    19.561     0.200
     5.912    19.648     0.200
     5.942    19.369     0.200
     5.973    19.859     0.200
     6.035    19.955     0.200
     6.125    19.780     0.200
     6.131    19.523     0.200
     6.354    20.795     0.200
     6.668    20.472     0.200
     6.690    20.801     0.200
     6.739    20.993     0.200
     7.139    20.489     0.200
     7.692    22.346     0.200
     7.751    23.308     0.200
     8.741    26.193     0.200
     8.739    25.534     0.200
     8.740    24.405     0.200
    10.259    26.322     0.200
    10.548    29.327     0.200
    10.548    30.017     0.200
     1.581     8.784     0.200
     2.006    10.222     0.200
     2.456     9.752     0.200
     5.106    17.600     0.200
     0.933     7.101     0.200
     1.140     9.085     0.200
     1.168     8.112     0.200
     1.189     8.110     0.200
     1.213     8.336     0.200
     1.280     8.409     0.200
     1.302     9.113     0.200
     1.345     8.870     0.200
     1.346     9.070     0.200
     1.345     8.857     0.200
     1.567     8.139     0.200
     1.606    10.899     0.200
     1.632    10.308     0.200
     1.654    10.329     0.200
     1.657    10.404     0.200
     1.693     8.622     0.200
     1.722    10.478     0.200
     1.765     9.414     0.200
     1.772    11.565     0.200
     1.857    10.170     0.200
     1.863     8.339     0.200
     1.881     9.954     0.200
     1.985    11.688     0.200
     2.117    12.624     0.200
     2.154     9.636     0.200
     2.167    10.822     0.200
     2.208    12.615     0.200
     2.216    10.077     0.200
     2.220    11.095     0.200
     2.224     9.377     0.200
     2.230    10.035     0.200
     2.293    11.098     0.200
     2.324    13.517     0.200
     2.383    11.063     0.200
     2.435    11.635     0.200
     2.433    11.532     0.200
     2.453    10.873     0.200
     2.511    10.960     0.200
     2.669    11.845     0.200
     2.682    11.018     0.200
     2.943    11.182     0.200
     2.945    14.793     0.200
     3.202    11.123     0.200
     3.293    13.200     0.200
     3.418    13.269     0.200
     3.418    13.499     0.200
     3.878    13.893     0.200
     4.007    14.455     0.200
     4.207    15.557     0.200
     4.207    13.467     0.200
     4.312    16.659     0.200
     4.459    15.079     0.200
     4.574    16.221     0.200
     4.751    16.382     0.200
     4.777    16.555     0.200
     4.984    17.399     0.200
     5.008    18.568     0.200
     5.013    18.678     0.200
     5.327    17.438     0.200
     5.361    18.747     0.200
     5.436    18.163     0.200
     5.525    19.984     0.200
     5.647    18.594     0.200
     5.653    18.591     0.200
     5.744    19.120     0.200
     5.938    18.806     0.200
     5.976    19.915     0.200
     6.126    19.114     0.200
     6.321    20.242     0.200
     6.750    21.152     0.200
     7.168    22.278     0.200
     1.117     8.986     0.200
     1.168     8.648     0.200
     1.239     8.743     0.200
     1.251     8.705     0.200
     1.260     9.419     0.200
     1.310     9.289     0.200
     1.467     9.148     0.200
     1.497     9.286     0.200
     1.777     9.860     0.200
     1.773     9.705     0.200
     1.853    10.223     0.200
     1.878    10.198     0.200
     1.908    10.313     0.200
     2.023    10.670     0.200
     2.153    11.140     0.200
     2.266    10.803     0.200
     2.320    10.159     0.200
     2.333    10.634     0.200
     2.377    10.257     0.200
     2.473    10.022     0.200
     2.582    11.398     0.200
     2.765    10.748     0.200
     2.779    11.236     0.200
     2.913    11.513     0.200
     2.927    12.106     0.200
     2.925    11.518     0.200
     2.938    12.245     0.200
     3.497    13.168     0.200
     3.548    12.412     0.200
     3.759    14.293     0.200
     3.887    16.320     0.200
     3.892    15.322     0.200
     3.985    16.026     0.200
     4.222    17.655     0.200
     4.335    14.690     0.200
     4.433    16.844     0.200
     4.434    16.830     0.200
     4.451    17.457     0.200
     0.845     7.477     0.200
     0.897     7.831     0.200
     0.924     7.723     0.200
     0.943     7.962     0.200
     1.282     9.170     0.200
     1.319     9.347     0.200
     1.318    10.036     0.200
     1.328     9.073     0.200
     1.319    10.163     0.200
     1.330     9.087     0.200
     1.335     9.915     0.200
     1.366    10.369     0.200
     1.382    10.069     0.200
     1.417     9.967     0.200
     1.657     9.661     0.200
     1.707    10.726     0.200
     1.752    12.040     0.200
     1.841    10.658     0.200
     1.875    12.537     0.200
     1.953    12.484     0.200
     1.998    10.634     0.200
     2.122    10.513     0.200
     2.191    11.013     0.200
     2.204    10.410     0.200
     2.398    11.432     0.200
     2.431    11.169     0.200
     2.645    11.869     0.200
     2.648    11.308     0.200
     3.258    13.018     0.200
     3.378    12.695     0.200
     4.164    15.123     0.200
     4.429    15.825     0.200
     4.977    18.178     0.200
     1.003     8.503     0.200
     1.180     9.162     0.200
     1.694     9.403     0.200
     1.710    11.751     0.200
     1.857    12.980     0.200
     1.869    12.374     0.200
     1.887    10.885     0.200
     1.932    10.971     0.200
     1.944    10.985     0.200
     1.956    13.318     0.200
     1.968    10.852     0.200
     2.014    10.995     0.200
     2.090    11.723     0.200
     2.199     9.670     0.200
     2.198    10.821     0.200
     2.298    12.007     0.200
     2.386    12.578     0.200
     2.566    12.407     0.200
     2.755    11.661     0.200
     4.715    17.014     0.200
     5.036    18.577     0.200
     5.243    20.152     0.200
     5.982    20.682     0.200
     6.025    20.796     0.200
     6.241    20.096     0.200
     7.047    22.158     0.200
     0.938     7.526     0.200
     0.988     7.797     0.200
     0.988     7.695     0.200
     1.434     8.671     0.200
     1.495     9.046     0.200
     1.532     7.576     0.200
     1.661     9.581     0.200
     1.801    10.042     0.200
     1.924    10.073     0.200
     2.024     8.798     0.200
     2.152    10.663     0.200
     2.242    10.212     0.200
     2.255     9.274     0.200
     2.433    10.616     0.200
     3.448    12.384     0.200
     3.887    13.576     0.200
     4.314    15.049     0.200
     4.448    14.868     0.200
     4.568    15.613     0.200
     4.775    16.437     0.200
     5.017    17.580     0.200
     5.087    14.835     0.200
     5.360    17.473     0.200
     5.480    18.607     0.200
     5.653    18.384     0.200
     0.957     8.104     0.200
     1.235     8.972     0.200
     1.358     9.655     0.200
     1.413     9.460     0.200
     1.413     9.890     0.200
     1.664    10.581     0.200
     1.795    10.915     0.200
     1.871     9.181     0.200
     2.051    11.403     0.200
     2.214    10.160     0.200
     2.400    14.565     0.200
     3.615    14.308     0.200
     3.834    15.289     0.200
     4.214    17.114     0.200
     4.414    15.974     0.200
     5.470    18.746     0.200
     0.881     7.647     0.200
     0.982     7.868     0.200
     1.198     8.051     0.200
     1.198     8.171     0.200
     1.311     8.918     0.200
     1.354     8.742     0.200
     1.355     8.855     0.200
     1.576     9.461     0.200
     1.696     8.539     0.200
     1.865    10.023     0.200
     1.857     8.637     0.200
     2.030     9.675     0.200
     2.224    11.150     0.200
     2.229    11.268     0.200
     2.232    10.927     0.200
     2.448     9.948     0.200
     2.518    10.485     0.200
     2.629    11.977     0.200
     2.677    11.367     0.200
     2.687    12.452     0.200
     3.224    13.104     0.200
     3.293    12.530     0.200
     3.402    13.530     0.200
     4.016    13.668     0.200
     4.202    14.460     0.200
     4.313    15.465     0.200
     4.611    16.712     0.200
     4.758    15.161     0.200
     5.361    17.145     0.200
     1.048     7.692     0.200
     1.203     9.336     0.200
     1.281     8.813     0.200
     1.689    10.563     0.200
     1.725    10.511     0.200
     1.750     8.995     0.200
     1.898    11.356     0.200
     1.960    12.752     0.200
     1.990    10.343     0.200
     2.005    13.128     0.200
     2.034    10.480     0.200
     2.045    10.500     0.200
     2.044    14.158     0.200
     2.057    13.304     0.200
     2.059    13.014     0.200
     2.215    10.427     0.200
     2.376    11.705     0.200
     2.394    10.958     0.200
     2.494    11.908     0.200
     2.720    11.196     0.200
     2.729    11.589     0.200
     2.964    11.954     0.200
     3.142    13.291     0.200
     3.180    11.196     0.200
     3.241    12.799     0.200
     3.428    13.135     0.200
     3.534    14.569     0.200
     3.754    14.428     0.200
     3.770    14.728     0.200
     3.973    14.596     0.200
     4.205    15.176     0.200
     4.413    16.801     0.200
     4.609    17.716     0.200
     4.941    18.016     0.200
     5.710    18.595     0.200
     5.856    19.873     0.200
     6.004    21.004     0.200
     6.441    21.770     0.200
     0.991     7.907     0.200
     1.174     8.950     0.200
     1.355     9.344     0.200
     1.646     8.687     0.200
     1.689     9.417     0.200
     1.765     9.719     0.200
     1.891     9.874     0.200
     2.074    11.136     0.200
     2.141    10.707     0.200
     2.210    11.321     0.200
     2.230    10.132     0.200
     2.331     9.120     0.200
     2.342    10.649     0.200
     2.449    11.217     0.200
     2.573     9.043     0.200
     2.682    13.467     0.200
     2.860    10.560     0.200
     2.860    11.187     0.200
     2.902     9.660     0.200
     4.121    13.270     0.200
     4.718    15.730     0.200
     5.078    18.810     0.200
     5.413    19.428     0.200
     5.856    19.350     0.200
     0.876     7.623     0.200
     1.317     9.842     0.200
     1.412    10.516     0.200
     1.430    10.199     0.200
     1.664    10.646     0.200
     1.652     8.824     0.200
     1.873     9.057     0.200
     2.025    10.394     0.200
     2.051    11.023     0.200
     2.215     9.982     0.200
     2.197    10.272     0.200
     2.349    10.096     0.200
     2.401    11.826     0.200
     2.392    11.187     0.200
     2.599    11.822     0.200
     2.701    11.889     0.200
     2.737    14.936     0.200
     2.808    12.441     0.200
     2.802    12.731     0.200
     2.822    12.122     0.200
     3.166    12.784     0.200
     3.175    13.868     0.200
     3.290    12.490     0.200
     3.393    13.969     0.200
     3.835    14.310     0.200
     3.970    13.747     0.200
     4.028    17.516     0.200
     4.185    15.897     0.200
     4.215    16.332     0.200
     4.265    15.596     0.200
     4.341    17.509     0.200
     4.415    15.592     0.200
     4.612    16.584     0.200
     4.739    17.305     0.200
     4.847    17.345     0.200
     4.862    17.689     0.200
     4.925    18.054     0.200
     5.040    17.320     0.200
     5.236    17.561     0.200
     5.471    18.543     0.200
     5.532    17.727     0.200
     5.571    19.172     0.200
     6.041    18.926     0.200
     6.117    19.950     0.200
     0.867     6.948     0.200
     0.897     6.992     0.200
     1.283     8.450     0.200
     1.351     9.027     0.200
     1.402     8.651     0.200
     1.463     8.817     0.200
     1.491     9.184     0.200
     1.568     9.473     0.200
     1.590     9.581     0.200
     1.593     9.945     0.200
     1.657     9.765     0.200
     1.708    10.023     0.200
     1.792    10.496     0.200
     1.819     9.713     0.200
     1.908    10.529     0.200
     1.940    10.102     0.200
     2.028     9.762     0.200
     2.052    12.405     0.200
     2.086    10.371     0.200
     2.105    10.154     0.200
     2.122    13.759     0.200
     2.143    12.320     0.200
     2.154    10.228     0.200
     2.154    10.337     0.200
     2.179    14.033     0.200
     2.321    10.816     0.200
     2.399    11.065     0.200
     2.455    10.940     0.200
     2.480    10.406     0.200
     2.555    11.952     0.200
     2.608    11.446     0.200
     2.871    12.359     0.200
     3.279    13.169     0.200
     3.597    14.914     0.200
     4.466    14.450     0.200
     4.540    14.941     0.200
     4.568    16.284     0.200
     4.988    18.749     0.200
     1.367     7.986     0.200
     1.547     8.547     0.200
     1.580     7.903     0.200
     1.651     7.817     0.200
     1.674     8.290     0.200
     1.765     9.447     0.200
     1.753     8.470     0.200
     1.911     9.707     0.200
     1.912     9.678     0.200
     1.931    10.165     0.200
     1.925     9.878     0.200
     1.923     9.041     0.200
     1.954     8.911     0.200
     1.955     9.630     0.200
     1.986    10.085     0.200
     1.993     9.754     0.200
     1.992     9.570     0.200
     2.008     9.763     0.200
     2.014     9.504     0.200
     2.029     9.664     0.200
     2.056     9.778     0.200
     2.117     8.371     0.200
     2.146     9.456     0.200
     2.345    11.644     0.200
     2.332    10.504     0.200
     2.399    10.579     0.200
     2.443    11.394     0.200
     2.576     9.569     0.200
     2.678    10.123     0.200
     3.003    12.468     0.200
     3.017    12.486     0.200
     3.135    12.542     0.200
     3.355    13.221     0.200
     3.529    11.521     0.200
     4.171    15.590     0.200
     4.376    16.785     0.200
     4.367    15.679     0.200
     4.330    16.940     0.200
     4.426    14.491     0.200
     4.426    13.671     0.200
     4.552    16.201     0.200
     4.670    16.424     0.200
     5.381    16.852     0.200
     6.955    22.026     0.200
     7.024    21.958     0.200
     8.997    25.346     0.200
     9.081    26.325     0.200
    10.837    30.037     0.200
    12.189    32.683     0.200
     1.180     8.617     0.200
     1.579     9.902     0.200
     1.670    10.048     0.200
     1.691     8.711     0.200
     1.694     9.828     0.200
     1.694     9.938     0.200
     1.798    10.272     0.200
     1.798    10.772     0.200
     1.900    10.687     0.200
     1.925    10.512     0.200
     2.267    10.462     0.200
     2.301    11.148     0.200
     2.406    10.970     0.200
     2.446    11.691     0.200
     2.684    12.059     0.200
     2.692    12.913     0.200
     2.790    12.497     0.200
     2.837    11.603     0.200
     2.920    12.199     0.200
     3.056    13.094     0.200
     3.146    12.983     0.200
     3.147    12.909     0.200
     3.377    13.544     0.200
     3.673    13.411     0.200
     3.698    13.054     0.200
     3.831    13.862     0.200
     3.977    15.381     0.200
     4.449    15.863     0.200
     4.661    16.123     0.200
     4.661    15.984     0.200
     4.683    17.407     0.200
     4.888    16.774     0.200
     5.142    18.579     0.200
     5.225    17.776     0.200
     5.359    17.845     0.200
     5.672    19.713     0.200
     6.047    21.056     0.200
     6.285    20.848     0.200
     1.276     8.585     0.200
     1.311    10.209     0.200
     1.381     9.384     0.200
     1.587     9.868     0.200
     1.587     9.696     0.200
     1.653    10.003     0.200
     1.649     8.674     0.200
     1.649     8.803     0.200
     1.696     9.810     0.200
     1.787    10.325     0.200
     1.811     9.927     0.200
     1.826    10.376     0.200
     1.892     8.734     0.200
     1.892     8.564     0.200
     2.046    11.465     0.200
     2.094    10.147     0.200
     2.094    11.109     0.200
     2.147    10.225     0.200
     2.151    11.118     0.200
     2.388    11.662     0.200
     2.445    12.079     0.200
     2.550    11.773     0.200
     2.600    12.304     0.200
     3.081    10.750     0.200
     3.076    11.563     0.200
     3.136    11.676     0.200
     3.146    11.385     0.200
     3.188    10.389     0.200
     3.349    11.839     0.200
     3.912    15.006     0.200
     4.115    13.434     0.200
     4.225    14.640     0.200
     4.225    15.131     0.200
     4.533    13.325     0.200
     5.809    20.109     0.200
     5.930    19.893     0.200
     6.416    19.727     0.200
     8.779    28.796     0.200
     8.779    25.831     0.200
     1.476     9.257     0.200
     1.494     9.329     0.200
     1.588     9.142     0.200
     1.658     9.819     0.200
     1.650     8.552     0.200
     1.701     9.685     0.200
     1.757     8.235     0.200
     1.831    10.426     0.200
     1.888     8.703     0.200
     2.041    11.258     0.200
     2.151     9.619     0.200
     2.151    10.670     0.200
     2.155    10.886     0.200
     2.389     9.429     0.200
     2.449    10.120     0.200
     2.604    12.147     0.200
     2.628    11.096     0.200
     3.079    12.463     0.200
     3.085    14.123     0.200
     3.140    12.047     0.200
     3.702    14.461     0.200
     3.942    14.725     0.200
     4.220    13.974     0.200
     4.222    13.402     0.200
     4.222    13.962     0.200
     4.373    14.773     0.200
     4.688    15.773     0.200
     4.951    17.647     0.200
     5.177    14.642     0.200
     5.334    17.426     0.200
     5.601    18.431     0.200
     5.813    18.668     0.200
     5.932    20.489     0.200
     5.943    19.092     0.200
     6.421    20.073     0.200
     7.059    22.669     0.200
     7.127    21.990     0.200
     7.185    22.127     0.200
     7.765    23.659     0.200
     8.178    26.252     0.200
     8.423    25.072     0.200
     8.736    28.766     0.200
     8.776    25.850     0.200
     8.779    28.746     0.200
     9.172    27.583     0.200
     9.189    25.116     0.200
    10.198    27.876     0.200
    10.595    31.251     0.200
    10.596    31.011     0.200
    11.176    32.274     0.200
    11.589    34.516     0.200
    12.197    34.559     0.200
    14.238    37.667     0.200
    15.260    37.584     0.200
    17.092    39.606     0.200
    18.891    41.982     0.200
    19.380    40.117     0.200
     0.873     7.695     0.200
     0.882     7.759     0.200
     1.070     9.249     0.200
     1.175     9.746     0.200
     1.273     9.923     0.200
     1.267     9.211     0.200
     1.296    10.475     0.200
     1.325    10.347     0.200
     1.333     9.792     0.200
     1.371    10.080     0.200
     1.557    10.205     0.200
     1.649    10.410     0.200
     1.688    10.399     0.200
     1.754     8.453     0.200
     1.783    11.022     0.200
     1.803    10.338     0.200
     1.819    10.780     0.200
     1.883     8.905     0.200
     2.051    11.253     0.200
     2.082    10.751     0.200
     2.138    10.883     0.200
     2.145    11.609     0.200
     2.373    11.397     0.200
     2.435    11.781     0.200
     2.546    11.894     0.200
     2.592    12.391     0.200
     2.612    13.352     0.200
     3.073    13.452     0.200
     3.126    13.488     0.200
     3.140    13.285     0.200
     3.689    12.659     0.200
     3.900    13.903     0.200
     3.932    13.886     0.200
     4.108    15.171     0.200
     4.214    14.797     0.200
     4.186    15.209     0.200
     4.242    16.300     0.200
     4.343    16.134     0.200
     4.363    16.629     0.200
     4.525    17.265     0.200
     4.594    17.457     0.200
     4.674    17.591     0.200
     4.935    19.151     0.200
     4.980    18.552     0.200
     5.587    19.772     0.200
     5.608    19.339     0.200
     5.802    19.780     0.200
     5.916    21.626     0.200
     5.956    20.961     0.200
     6.059    21.257     0.200
     6.256    22.915     0.200
     6.414    21.831     0.200
     6.759    21.901     0.200
     7.698    23.221     0.200
     7.754    24.400     0.200
     1.772    10.965     0.200
     1.797    11.613     0.200
     1.811    12.136     0.200
     1.902    10.099     0.200
     1.918    13.309     0.200
     2.063    13.250     0.200
     2.064    13.819     0.200
     2.132    11.442     0.200
     2.135    11.875     0.200
     2.157    14.716     0.200
     2.535    11.984     0.200
     2.585    12.721     0.200
     3.265    13.341     0.200
     4.273    16.063     0.200
     4.971    18.249     0.200
     1.653    10.111     0.200
     1.650    10.093     0.200
     1.787     9.253     0.200
     1.805     8.741     0.200
     1.811     9.848     0.200
     1.826    10.521     0.200
     1.917    11.321     0.200
     1.933    13.255     0.200
     1.894     8.668     0.200
     2.079    13.775     0.200
     2.018     9.717     0.200
     2.150    10.225     0.200
     2.174    15.807     0.200
     2.095    10.252     0.200
     2.147    10.177     0.200
     2.389    11.733     0.200
     2.446    11.338     0.200
     2.550    10.930     0.200
     2.473    10.574     0.200
     2.600    11.216     0.200
     2.626    12.536     0.200
     2.847    12.721     0.200
     3.081    13.004     0.200
     3.145    12.601     0.200
     3.181    15.167     0.200
     3.137    12.714     0.200
     3.516    15.024     0.200
     3.846    14.275     0.200
     4.115    14.369     0.200
     4.195    14.647     0.200
     4.533    15.137     0.200
     4.558    16.211     0.200
     4.684    16.255     0.200
     5.335    17.699     0.200
     5.646    18.755     0.200
     5.750    18.836     0.200
     6.771    20.663     0.200
     1.252     8.820     0.200
     1.680     9.921     0.200
     1.665     8.163     0.200
     1.811    10.664     0.200
     1.814    11.521     0.200
     1.878     8.892     0.200
     2.042    11.982     0.200
     2.068    11.288     0.200
     2.213    11.296     0.200
     2.278    10.871     0.200
     2.367    11.792     0.200
     2.418    11.817     0.200
     2.405    12.798     0.200
     2.616    12.345     0.200
     2.716    12.684     0.200
     2.819    12.968     0.200
     2.825    12.965     0.200
     3.191    14.135     0.200
     3.847    14.333     0.200
     3.857    14.584     0.200
     3.967    13.662     0.200
     4.045    13.606     0.200
     4.225    17.402     0.200
     4.421    15.372     0.200
     4.757    17.123     0.200
     4.864    17.100     0.200
     4.887    16.745     0.200
     4.896    17.564     0.200
     4.935    18.269     0.200
     5.176    17.594     0.200
     5.243    18.534     0.200
     5.531    17.911     0.200
     5.940    19.797     0.200
     5.953    19.279     0.200
     6.506    18.923     0.200
     1.669    10.344     0.200
     1.755    11.427     0.200
     1.918     9.421     0.200
     1.924    12.735     0.200
     1.934    10.736     0.200
     2.139    12.256     0.200
     2.253    13.058     0.200
     2.288    13.133     0.200
     2.315    10.352     0.200
     2.374    13.759     0.200
     2.522    12.867     0.200
     2.693    14.995     0.200
     3.194    13.777     0.200
     4.147    20.924     0.200
     4.462    16.127     0.200
     4.933    18.859     0.200
     5.916    20.719     0.200
     1.486     9.202     0.200
     1.515     9.361     0.200
     1.563     9.766     0.200
     1.590     9.855     0.200
     1.614     9.882     0.200
     1.651     9.571     0.200
     1.664     8.685     0.200
     1.680    10.093     0.200
     1.723     9.597     0.200
     1.729    10.521     0.200
     1.815    10.287     0.200
     1.838     9.953     0.200
     1.853    10.485     0.200
     1.853    10.575     0.200
     1.857     9.147     0.200
     1.878     8.582     0.200
     1.944    11.155     0.200
     2.074    11.498     0.200
     2.116     9.959     0.200
     2.139    10.268     0.200
     2.173    10.182     0.200
     2.178    11.138     0.200
     2.181    11.277     0.200
     2.187    10.477     0.200
     2.215    11.135     0.200
     2.250    11.168     0.200
     2.341    11.209     0.200
     2.343    11.276     0.200
     2.392    11.692     0.200
     2.404    10.494     0.200
     2.470    11.298     0.200
     2.462    10.471     0.200
     2.577    13.562     0.200
     2.578    12.032     0.200
     2.627    12.163     0.200
     2.646    11.166     0.200
     2.764    12.861     0.200
     3.275    12.885     0.200
     3.377    13.823     0.200
     3.627    14.548     0.200
     3.848    14.132     0.200
     4.002    13.888     0.200
     4.142    15.036     0.200
     4.216    14.547     0.200
     4.241    15.448     0.200
     4.454    14.932     0.200
     4.561    15.934     0.200
     4.593    14.846     0.200
     4.624    16.352     0.200
     4.709    16.155     0.200
     4.787    16.914     0.200
     4.787    16.676     0.200
     4.970    16.089     0.200
     4.991    16.615     0.200
     5.372    18.232     0.200
    15.036    36.267     0.200
    15.076    36.224     0.200
    15.368    37.244     0.200
    15.387    37.185     0.200
    15.526    36.752     0.200
    16.355    38.225     0.200
    16.376    38.757     0.200
    17.262    39.813     0.200
     1.602    10.186     0.200
     1.644     9.571     0.200
     1.660     8.412     0.200
     1.808    10.157     0.200
     1.832     9.931     0.200
     1.881     8.608     0.200
     2.111    10.120     0.200
     2.133    10.325     0.200
     2.167    10.047     0.200
     2.171    11.741     0.200
     2.464    11.695     0.200
     2.463    10.673     0.200
     2.571    11.673     0.200
     2.620    11.481     0.200
     2.640    11.898     0.200
     3.092    12.697     0.200
     3.620    12.948     0.200
     3.843    14.791     0.200
     4.136    13.729     0.200
     4.235    14.753     0.200
     4.217    14.447     0.200
     4.285    17.163     0.200
     4.559    15.715     0.200
     4.703    17.334     0.200
     4.984    18.953     0.200
     5.942    20.731     0.200
     6.107    20.336     0.200
     0.993     8.008     0.200
     0.993     8.426     0.200
     1.405     9.087     0.200
     1.490     9.133     0.200
     1.535     9.358     0.200
     1.648     7.869     0.200
     1.664     9.717     0.200
     1.690     8.517     0.200
     1.728    10.842     0.200
     1.798     9.951     0.200
     1.773    13.077     0.200
     1.787     9.436     0.200
     1.816     9.250     0.200
     1.901    11.628     0.200
     2.021     9.998     0.200
     2.037     9.542     0.200
     2.053    10.574     0.200
     2.226    10.250     0.200
     2.255    10.093     0.200
     2.285    10.842     0.200
     2.364     9.920     0.200
     2.383    12.127     0.200
     2.406    11.293     0.200
     2.431    11.182     0.200
     2.622    11.491     0.200
     2.733    11.878     0.200
     2.811    12.308     0.200
     2.817    12.990     0.200
     3.210    13.332     0.200
     3.248    16.034     0.200
     3.314    12.823     0.200
     3.377    13.245     0.200
     3.399    12.972     0.200
     3.616    13.381     0.200
     3.758    12.983     0.200
     3.848    15.017     0.200
     3.874    14.389     0.200
     4.192    13.644     0.200
     4.310    14.312     0.200
     4.352    13.345     0.200
     4.413    14.939     0.200
     4.461    15.941     0.200
     4.620    14.855     0.200
     4.869    17.254     0.200
     4.968    18.174     0.200
     5.241    18.382     0.200
     5.558    20.357     0.200
     5.575    18.901     0.200
     5.613    19.718     0.200
     5.968    20.548     0.200
     5.994    20.216     0.200
     0.959     8.005     0.200
     1.046     8.852     0.200
     1.149     8.790     0.200
     1.349    10.370     0.200
     1.412    10.129     0.200
     1.635    10.760     0.200
     1.692     8.833     0.200
     1.694    11.966     0.200
     1.726    11.125     0.200
     1.775    12.249     0.200
     1.860    11.027     0.200
     1.899    12.763     0.200
     2.027     9.854     0.200
     2.155    11.630     0.200
     2.224    11.735     0.200
     2.343    13.737     0.200
     2.448    10.674     0.200
     2.623    13.803     0.200
     2.682    12.406     0.200
     4.310    17.650     0.200
     4.570    16.617     0.200
     5.011    18.748     0.200
     5.247    18.962     0.200
     5.358    18.854     0.200
     5.645    20.321     0.200
     5.975    20.466     0.200
     0.851     6.230     0.200
     0.874     6.448     0.200
     0.900     6.377     0.200
     0.916     7.362     0.200
     0.978     6.619     0.200
     1.000     6.938     0.200
     1.006     7.466     0.200
     0.996     6.820     0.200
     0.996     6.680     0.200
     1.104     8.369     0.200
     1.116     7.640     0.200
     1.113     7.464     0.200
     1.143     7.224     0.200
     1.263     7.611     0.200
     1.284     7.763     0.200
     1.319     7.661     0.200
     1.322     7.689     0.200
     1.388     8.619     0.200
     1.459     7.597     0.200
     1.442     8.572     0.200
     1.576     7.965     0.200
     1.598     9.434     0.200
     1.625     8.084     0.200
     1.671    10.282     0.200
     1.685     9.044     0.200
     1.693     9.169     0.200
     1.719    10.522     0.200
     1.745     9.170     0.200
     1.770     9.381     0.200
     1.792     8.481     0.200
     1.810    10.117     0.200
     2.084    10.413     0.200
     2.107     9.692     0.200
     2.154     9.871     0.200
     2.194     9.768     0.200
     2.266     8.836     0.200
     2.397     9.823     0.200
     2.789    11.026     0.200
     3.303    12.619     0.200
     3.673    13.098     0.200
     4.003    15.223     0.200
     4.237    15.923     0.200
     4.312    16.530     0.200
     4.644    16.445     0.200
     4.910    17.192     0.200
     5.625    18.627     0.200
     1.430     9.992     0.200
     1.519    10.101     0.200
     1.754     9.795     0.200
     1.870    11.383     0.200
     1.975     9.118     0.200
     2.084    11.937     0.200
     2.088    12.849     0.200
     2.289     9.875     0.200
     2.286    11.740     0.200
     2.445    14.351     0.200
     2.494    12.321     0.200
     2.848    14.031     0.200
     2.867    13.908     0.200
     3.270    12.987     0.200
     3.439    15.629     0.200
     4.320    15.583     0.200
     5.031    19.026     0.200
     6.032    20.010     0.200
     6.269    20.128     0.200
     1.524     9.552     0.200
     1.596    11.350     0.200
     1.703     9.845     0.200
     1.753     8.579     0.200
     1.872    10.339     0.200
     1.970     8.997     0.200
     2.087     9.572     0.200
     2.092    10.738     0.200
     2.113    13.164     0.200
     2.283     9.678     0.200
     2.287    10.803     0.200
     2.343    11.550     0.200
     2.416    11.379     0.200
     2.449    11.594     0.200
     2.493    11.507     0.200
     4.038    13.889     0.200
     1.401     9.207     0.200
     1.453    10.551     0.200
     1.542     9.682     0.200
     1.661     9.749     0.200
     1.661     9.881     0.200
     1.667     9.728     0.200
     1.693     8.068     0.200
     1.771    11.727     0.200
     1.816    11.884     0.200
     1.850    12.877     0.200
     1.874    12.831     0.200
     1.923     9.415     0.200
     1.945    13.158     0.200
     2.050    10.866     0.200
     2.067    13.880     0.200
     2.285    13.418     0.200
     2.363    11.961     0.200
     2.403    13.529     0.200
     2.622    11.338     0.200
     2.809    15.129     0.200
     3.877    15.348     0.200
     4.016    14.383     0.200
     4.016    14.602     0.200
     4.262    16.781     0.200
     4.466    16.007     0.200
     4.972    18.212     0.200
     5.244    18.692     0.200
     5.522    18.157     0.200
     5.617    20.431     0.200
     1.704    10.120     0.200
     1.687    10.474     0.200
     1.725    10.339     0.200
     1.898    11.183     0.200
     2.021     9.937     0.200
     2.028    11.563     0.200
     2.160    10.847     0.200
     2.209    11.435     0.200
     2.252    11.826     0.200
     2.261    12.750     0.200
     2.424    10.823     0.200
     2.542    12.583     0.200
     2.661    12.562     0.200
     2.705    13.821     0.200
     2.854    13.712     0.200
     3.077    15.098     0.200
     3.185    11.768     0.200
     3.233    12.320     0.200
     3.256    14.625     0.200
     3.276    13.041     0.200
     3.404    17.005     0.200
     3.890    15.870     0.200
     3.949    17.147     0.200
     4.048    15.868     0.200
     4.180    15.659     0.200
     4.224    17.075     0.200
     4.315    16.471     0.200
     4.565    16.613     0.200
     5.008    19.016     0.200
     5.018    17.711     0.200
     5.260    19.171     0.200
     5.640    19.840     0.200
     5.654    19.473     0.200
     5.723    19.781     0.200
     5.858    20.229     0.200
     5.988    20.176     0.200
     6.144    20.533     0.200
     6.213    20.153     0.200
     1.601    10.146     0.200
     1.691     9.273     0.200
     1.711     9.943     0.200
     1.767    11.061     0.200
     1.836    11.101     0.200
     1.887    11.440     0.200
     2.013     9.842     0.200
     2.017    11.466     0.200
     2.147    10.878     0.200
     2.164    10.319     0.200
     2.195    11.283     0.200
     2.238    11.695     0.200
     2.238    12.154     0.200
     2.249    11.366     0.200
     2.422    11.531     0.200
     2.528    12.110     0.200
     2.649    13.521     0.200
     2.689    12.463     0.200
     2.692    12.643     0.200
     2.841    13.117     0.200
     3.244    13.843     0.200
     3.449    15.703     0.200
     3.697    15.761     0.200
     4.036    16.631     0.200
     4.074    16.416     0.200
     4.177    14.902     0.200
     4.177    14.621     0.200
     4.303    17.377     0.200
     4.287    17.285     0.200
     4.314    16.785     0.200
     4.436    18.703     0.200
     4.556    16.528     0.200
     4.665    17.031     0.200
     4.716    16.228     0.200
     5.017    19.173     0.200
     5.403    18.600     0.200
     6.058    19.958     0.200
     6.719    21.133     0.200
     7.272    23.958     0.200
     7.515    23.931     0.200
     7.575    23.478     0.200
     8.400    25.891     0.200
     8.400    24.719     0.200
     8.400    25.076     0.200
     8.411    25.696     0.200
     8.719    26.041     0.200
     9.126    26.222     0.200
     9.242    29.245     0.200
    10.524    30.493     0.200
    10.525    31.027     0.200
    10.525    30.284     0.200
    12.038    31.119     0.200
    12.066    31.381     0.200
    12.241    36.369     0.200
    12.241    32.720     0.200
    12.570    33.360     0.200
    14.705    37.789     0.200
    16.796    39.870     0.200
     8.398    25.896     0.200
     2.238    12.510     0.200
     0.870     7.362     0.200
     0.982     8.385     0.200
     1.695    10.208     0.200
     1.714    10.182     0.200
     1.889    11.723     0.200
     2.016     9.995     0.200
     2.151    11.019     0.200
     2.242    12.988     0.200
     2.252    12.205     0.200
     2.424    11.221     0.200
     2.652    13.580     0.200
     2.693    13.467     0.200
     2.695    12.624     0.200
     2.844    14.070     0.200
     3.451    16.022     0.200
     4.307    17.876     0.200
     4.560    17.399     0.200
     5.010    19.378     0.200
     5.251    19.459     0.200
     5.635    18.915     0.200
     5.646    20.882     0.200
     5.979    21.425     0.200
     0.983     7.876     0.200
     0.983     8.095     0.200
     1.168     8.513     0.200
     1.242     8.487     0.200
     1.335     8.998     0.200
     1.368    10.325     0.200
     1.372     9.061     0.200
     1.381     9.447     0.200
     1.380     9.137     0.200
     1.435    10.168     0.200
     1.716    10.936     0.200
     1.892    11.583     0.200
     1.928    12.803     0.200
     2.022    11.947     0.200
     2.015     9.853     0.200
     2.151    11.147     0.200
     2.170    10.292     0.200
     2.201    11.312     0.200
     2.244    10.465     0.200
     2.254    13.535     0.200
     2.421    10.804     0.200
     2.533    12.310     0.200
     2.655    12.922     0.200
     2.698    12.694     0.200
     2.774    11.418     0.200
     5.009    18.852     0.200
     5.251    19.189     0.200
     5.979    20.846     0.200
     1.704     9.823     0.200
     1.720     9.963     0.200
     1.891    11.291     0.200
     2.025    11.209     0.200
     1.929    12.933     0.200
     2.020    12.034     0.200
     2.176    10.466     0.200
     2.205    12.482     0.200
     2.254    12.117     0.200
     2.431    11.866     0.200
     2.654    14.888     0.200
     2.700    12.784     0.200
     5.018    18.560     0.200
     5.260    18.664     0.200
     1.633    10.967     0.200
     1.713    11.865     0.200
     1.889    11.133     0.200
     2.014     9.837     0.200
     2.149    10.889     0.200
     2.167    10.280     0.200
     2.197    10.751     0.200
     2.251    13.078     0.200
     2.422    10.781     0.200
     2.651    11.354     0.200
     4.557    16.562     0.200
     4.999    19.114     0.200
     5.007    19.039     0.200
     5.249    19.240     0.200
     5.644    20.484     0.200
     5.719    18.597     0.200
     5.847    18.640     0.200
     1.483     9.933     0.200
     1.575    10.337     0.200
     1.695    11.889     0.200
     1.873    11.714     0.200
     2.234    14.002     0.200
     2.635    14.684     0.200
     2.677    14.765     0.200
     4.994    19.564     0.200
     1.494     9.915     0.200
     1.586    10.102     0.200
     1.690     9.106     0.200
     1.709    11.421     0.200
     1.885    11.840     0.200
     2.013    10.072     0.200
     2.146    11.284     0.200
     2.236    12.706     0.200
     2.247    13.543     0.200
     2.423    10.890     0.200
     2.647    14.882     0.200
     5.005    19.213     0.200
     5.246    19.420     0.200
     1.677     9.805     0.200
     1.685    10.387     0.200
     1.692     8.580     0.200
     1.710     9.114     0.200
     1.885    10.540     0.200
     2.015    11.364     0.200
     2.014     9.421     0.200
     2.147    10.457     0.200
     2.164    10.125     0.200
     2.195    10.182     0.200
     2.238    10.438     0.200
     2.248    12.012     0.200
     2.432    10.754     0.200
     2.424    10.784     0.200
     2.527    11.467     0.200
     2.648    12.480     0.200
     2.691    12.137     0.200
     2.689    11.927     0.200
     2.840    13.042     0.200
     3.219    12.938     0.200
     3.262    14.210     0.200
     3.447    14.773     0.200
     3.694    13.334     0.200
     3.696    15.281     0.200
     3.877    15.781     0.200
     4.034    16.191     0.200
     4.179    15.078     0.200
     4.179    15.606     0.200
     4.210    15.221     0.200
     4.286    17.208     0.200
     4.304    17.001     0.200
     4.343    16.218     0.200
     4.435    16.880     0.200
     4.557    16.436     0.200
     4.664    17.736     0.200
     4.804    16.824     0.200
     4.999    18.347     0.200
     5.007    18.937     0.200
     5.017    18.959     0.200
     5.206    19.817     0.200
     5.248    19.183     0.200
     5.359    19.506     0.200
     5.404    18.923     0.200
     5.427    19.855     0.200
     5.634    18.848     0.200
     5.720    18.682     0.200
     5.845    20.116     0.200
     5.975    19.829     0.200
     6.057    19.220     0.200
     6.101    20.493     0.200
     6.131    21.756     0.200
     6.136    20.892     0.200
     6.201    22.322     0.200
     6.324    21.798     0.200
     6.436    22.489     0.200
     6.721    20.738     0.200
     7.116    22.055     0.200
     7.174    22.604     0.200
     7.576    23.794     0.200
     8.188    25.346     0.200
     8.721    26.126     0.200
     9.127    28.276     0.200
    10.527    31.572     0.200
     1.503     9.375     0.200
     1.683    10.546     0.200
     1.695     8.249     0.200
     1.717     9.667     0.200
     1.893    10.623     0.200
     2.023    11.698     0.200
     2.014     9.507     0.200
     2.151    10.874     0.200
     2.170    10.627     0.200
     2.201    10.809     0.200
     2.244    10.448     0.200
     2.244    11.271     0.200
     2.255    11.596     0.200
     2.421    10.719     0.200
     2.436    11.140     0.200
     2.534    11.354     0.200
     2.655    12.552     0.200
     2.698    12.514     0.200
     2.695    11.407     0.200
     2.847    12.647     0.200
     3.250    13.502     0.200
     3.287    14.924     0.200
     3.418    16.835     0.200
     3.455    13.004     0.200
     3.675    12.757     0.200
     3.703    14.654     0.200
     3.881    15.077     0.200
     4.042    16.685     0.200
     4.176    13.871     0.200
     4.217    16.049     0.200
     4.293    15.847     0.200
     4.320    14.788     0.200
     4.350    16.163     0.200
     4.442    17.068     0.200
     4.558    16.258     0.200
     4.671    16.020     0.200
     4.811    17.307     0.200
     5.009    18.843     0.200
     5.251    19.108     0.200
     5.400    18.512     0.200
     5.433    20.951     0.200
     5.633    19.360     0.200
     5.646    20.177     0.200
     5.718    19.537     0.200
     5.849    19.956     0.200
     5.964    21.851     0.200
     5.979    20.664     0.200
     6.101    20.569     0.200
     6.135    20.342     0.200
     6.328    21.115     0.200
     6.718    21.892     0.200
     7.120    22.411     0.200
    10.521    30.730     0.200
    12.246    35.284     0.200
     1.506     9.285     0.200
     1.507     9.293     0.200
     1.568     9.547     0.200
     1.581     8.392     0.200
     1.597    10.128     0.200
     1.642     9.768     0.200
     1.639     9.169     0.200
     1.696    10.324     0.200
     1.700     8.830     0.200
     1.722     9.626     0.200
     1.742     9.419     0.200
     1.763    10.218     0.200
     1.897    10.981     0.200
     2.027    11.427     0.200
     2.017     9.657     0.200
     2.156    10.615     0.200
     2.175    10.335     0.200
     2.206    10.775     0.200
     2.249    10.667     0.200
     2.249    10.338     0.200
     2.259    11.411     0.200
     2.441    10.662     0.200
     2.422    10.478     0.200
     2.539    11.401     0.200
     2.655    13.277     0.200
     2.700    11.954     0.200
     3.459    15.343     0.200
     3.459    14.623     0.200
     3.886    15.420     0.200
     4.177    14.587     0.200
     4.561    16.570     0.200
     4.675    17.753     0.200
     4.709    16.369     0.200
     4.816    17.441     0.200
     5.073    17.930     0.200
     5.308    17.787     0.200
     5.441    17.369     0.200
     5.718    18.656     0.200
     6.068    19.744     0.200
     6.409    20.312     0.200
     6.640    21.698     0.200
     7.125    23.555     0.200
     7.283    23.179     0.200
     7.833    23.149     0.200
     8.403    25.155     0.200
     8.403    22.969     0.200
     8.717    26.048     0.200
     9.253    27.487     0.200
    10.133    24.923     0.200
    10.520    30.895     0.200
    11.765    30.049     0.200
    12.250    35.306     0.200
    12.569    34.483     0.200
    16.280    39.122     0.200
    16.807    38.723     0.200
    16.822    38.071     0.200
    17.066    39.523     0.200
     0.984     7.604     0.200
     1.438    10.257     0.200
     1.640    11.040     0.200
     1.696     9.619     0.200
     1.719     9.995     0.200
     1.896    11.315     0.200
     2.172    11.739     0.200
     2.247    10.662     0.200
     2.258    11.967     0.200
     2.658    12.474     0.200
     5.010    18.779     0.200
     1.450     8.879     0.200
     1.677     8.191     0.200
     1.699     9.888     0.200
     1.879    10.513     0.200
     2.000     9.226     0.200
     2.133     9.932     0.200
     2.151     9.890     0.200
     2.182    10.332     0.200
     2.227    11.139     0.200
     2.415    10.434     0.200
     2.418    11.463     0.200
     2.515    11.446     0.200
     2.641    11.547     0.200
     2.676    11.936     0.200
     2.681    11.551     0.200
     3.688    15.620     0.200
     3.923    16.169     0.200
     4.169    15.496     0.200
     4.201    17.023     0.200
     4.992    18.947     0.200
     5.414    20.076     0.200
     5.628    20.152     0.200
     5.961    20.647     0.200
     1.311     8.747     0.200
     1.497     9.293     0.200
     1.700     8.856     0.200
     1.887    10.811     0.200
     2.022     9.878     0.200
     2.155    10.444     0.200
     2.171     9.894     0.200
     2.250    11.044     0.200
     2.431    10.904     0.200
     2.533    11.234     0.200
     2.695    11.237     0.200
     3.073    12.433     0.200
     3.886    15.007     0.200
     4.566    15.904     0.200
     5.008    18.014     0.200
     5.015    18.525     0.200
     5.256    18.506     0.200
     5.651    20.102     0.200
     1.748     9.084     0.200
     1.778    11.674     0.200
     1.874     9.908     0.200
     1.928    10.772     0.200
     2.222    12.339     0.200
     2.248    10.624     0.200
     2.269    11.378     0.200
     2.278    11.977     0.200
     2.283    11.236     0.200
     2.308    11.987     0.200
     2.603    12.467     0.200
     2.610    12.721     0.200
     2.608    11.874     0.200
     2.664    10.449     0.200
     2.720    13.177     0.200
     3.290    15.489     0.200
     3.745    15.131     0.200
     3.977    16.969     0.200
     4.051    16.645     0.200
     4.089    14.644     0.200
     4.437    16.491     0.200
     5.206    18.999     0.200
     5.422    20.122     0.200
     1.021     8.003     0.200
     1.735     8.988     0.200
     1.735    11.013     0.200
     1.890    10.936     0.200
     1.921    11.366     0.200
     2.062     9.550     0.200
     2.187    10.564     0.200
     2.198     9.927     0.200
     2.223    11.263     0.200
     2.256    12.139     0.200
     2.256    12.459     0.200
     2.466    10.256     0.200
     2.475    10.784     0.200
     2.554    12.334     0.200
     2.653    13.015     0.200
     2.726    11.901     0.200
     2.710    12.090     0.200
     3.245    12.807     0.200
     3.251    12.730     0.200
     3.283    13.618     0.200
     3.450    14.650     0.200
     3.706    15.703     0.200
     3.920    14.305     0.200
     3.956    13.755     0.200
     4.042    16.432     0.200
     4.221    14.070     0.200
     4.223    15.940     0.200
     4.350    14.861     0.200
     4.304    16.529     0.200
     4.358    15.429     0.200
     4.474    17.009     0.200
     4.605    16.556     0.200
     4.814    16.894     0.200
     5.081    17.999     0.200
     5.052    18.913     0.200
     5.051    18.878     0.200
     5.229    18.848     0.200
     5.290    19.233     0.200
     5.501    20.289     0.200
     5.681    18.809     0.200
     5.688    19.935     0.200
     5.766    19.176     0.200
     6.018    20.987     0.200
     6.149    20.704     0.200
     0.871     7.149     0.200
     0.871     7.488     0.200
     0.872     7.468     0.200
     0.929     7.361     0.200
     0.961     7.572     0.200
     0.979     7.932     0.200
     1.045     7.773     0.200
     1.427    10.094     0.200
     1.427     9.744     0.200
     1.492     9.322     0.200
     1.492     9.392     0.200
     1.583     9.474     0.200
     1.692     9.941     0.200
     1.709    11.148     0.200
     1.883    10.769     0.200
     1.902    10.404     0.200
     2.016     9.809     0.200
     2.147    10.400     0.200
     2.164    11.096     0.200
     2.236    11.860     0.200
     2.245    12.199     0.200
     2.427    11.091     0.200
     2.433    11.546     0.200
     2.526    12.489     0.200
     2.645    13.819     0.200
     2.689    12.676     0.200
     2.838    13.384     0.200
     3.065    13.816     0.200
     3.218    14.658     0.200
     4.182    15.482     0.200
     4.560    16.465     0.200
     5.001    18.611     0.200
     5.008    18.387     0.200
     5.248    18.332     0.200
     5.351    19.280     0.200
     5.644    20.155     0.200
     5.723    19.770     0.200
     5.846    19.658     0.200
     5.976    20.298     0.200
     6.131    20.733     0.200
     0.866     7.587     0.200
     0.863     7.298     0.200
     0.921     7.467     0.200
     0.971     7.661     0.200
     1.487     9.352     0.200
     1.487     9.222     0.200
     1.486     9.337     0.200
     1.578     9.764     0.200
     1.684     8.669     0.200
     1.701     8.895     0.200
     1.833     8.607     0.200
     1.877    11.331     0.200
     1.894     9.633     0.200
     2.010     9.747     0.200
     2.139    10.731     0.200
     2.155    10.309     0.200
     2.228    10.149     0.200
     2.228    13.670     0.200
     2.239    11.096     0.200
     2.424    10.399     0.200
     2.518    11.697     0.200
     2.639    12.502     0.200
     2.681    11.508     0.200
     2.682    12.105     0.200
     3.659    12.970     0.200
     3.870    15.371     0.200
     4.025    15.754     0.200
     4.064    17.156     0.200
     4.179    14.361     0.200
     4.179    12.811     0.200
     4.201    14.770     0.200
     4.298    15.095     0.200
     4.456    18.006     0.200
     4.553    16.185     0.200
     4.794    16.259     0.200
     4.993    17.569     0.200
     5.000    18.493     0.200
     5.008    17.653     0.200
     5.197    19.217     0.200
     5.240    18.272     0.200
     5.344    19.128     0.200
     5.407    18.584     0.200
     5.341    18.631     0.200
     5.464    19.768     0.200
     5.633    18.648     0.200
     5.631    18.692     0.200
     5.636    19.712     0.200
     5.718    19.177     0.200
     5.675    20.081     0.200
     5.837    19.828     0.200
     5.968    19.367     0.200
     6.097    19.116     0.200
     6.048    19.997     0.200
     6.129    20.646     0.200
     6.122    19.954     0.200
     6.193    20.552     0.200
     6.315    20.861     0.200
     6.389    21.535     0.200
     6.428    20.930     0.200
     6.722    21.480     0.200
     6.946    21.212     0.200
     7.158    20.523     0.200
     7.165    21.735     0.200
     7.146    22.700     0.200
     7.209    23.677     0.200
     7.261    25.017     0.200
     7.556    22.037     0.200
     9.233    29.303     0.200
    10.530    30.786     0.200
    12.234    37.237     0.200
    14.041    37.181     0.200
    13.896    32.453     0.200
     1.487     9.367     0.200
     1.677    10.589     0.200
     1.683     8.547     0.200
     1.894     9.841     0.200
     2.009     9.618     0.200
     2.138    10.718     0.200
     2.155    10.182     0.200
     2.228    10.229     0.200
     2.239    11.362     0.200
     2.423    10.819     0.200
     2.517    12.009     0.200
     2.681    12.114     0.200
     3.402    11.263     0.200
     3.682    12.901     0.200
     4.552    16.595     0.200
     5.635    20.241     0.200
     5.717    19.148     0.200
     1.478    10.031     0.200
     1.679     8.867     0.200
     1.692     9.817     0.200
     1.868    11.380     0.200
     1.886    10.181     0.200
     1.998    11.979     0.200
     2.008     9.841     0.200
     2.133    11.109     0.200
     2.177    11.908     0.200
     2.220    10.767     0.200
     2.230    12.175     0.200
     2.427    11.394     0.200
     2.631    12.651     0.200
     2.673    12.262     0.200
     4.294    16.017     0.200
     4.552    16.510     0.200
     5.058    19.095     0.200
     5.235    19.451     0.200
     5.341    19.378     0.200
     5.631    19.043     0.200
     5.832    19.112     0.200
     5.963    21.196     0.200
     1.592    10.794     0.200
     1.669    10.200     0.200
     1.692     8.476     0.200
     1.706     9.750     0.200
     1.878    10.594     0.200
     1.898     9.713     0.200
     2.008    11.793     0.200
     2.018     9.640     0.200
     2.146    10.461     0.200
     2.162    10.193     0.200
     2.191    10.893     0.200
     2.232    10.262     0.200
     2.241    11.917     0.200
     2.433    10.909     0.200
     2.431    10.735     0.200
     2.523    10.669     0.200
     2.641    12.536     0.200
     2.688    11.378     0.200
     2.834    12.718     0.200
     3.065    12.873     0.200
     3.144    13.025     0.200
     3.440    13.812     0.200
     3.665    15.561     0.200
     3.877    14.828     0.200
     4.028    15.136     0.200
     4.065    15.206     0.200
     4.204    15.698     0.200
     4.186    15.740     0.200
     4.306    17.390     0.200
     4.561    16.512     0.200
     4.797    17.195     0.200
     5.001    17.898     0.200
     5.008    18.213     0.200
     5.015    18.045     0.200
     5.352    18.541     0.200
     5.412    18.380     0.200
     5.470    19.803     0.200
     5.644    19.770     0.200
     5.638    18.981     0.200
     5.680    19.434     0.200
     5.726    19.422     0.200
     5.845    19.749     0.200
     5.953    20.188     0.200
     5.976    20.491     0.200
     6.049    19.731     0.200
     6.130    20.210     0.200
     6.200    20.533     0.200
     6.435    21.190     0.200
     6.728    21.485     0.200
     0.872     7.378     0.200
     0.970     7.953     0.200
     1.146     8.561     0.200
     1.474     9.543     0.200
     1.683     8.705     0.200
     1.693    10.450     0.200
     1.865    10.892     0.200
     1.885    11.731     0.200
     2.015    10.147     0.200
     2.137    10.477     0.200
     2.150    11.265     0.200
     2.178    11.816     0.200
     2.219    11.923     0.200
     2.228    12.778     0.200
     2.298    15.471     0.200
     2.511    11.737     0.200
     2.673    12.188     0.200
     2.677    12.404     0.200
     3.676    15.097     0.200
     4.191    16.763     0.200
     4.446    16.967     0.200
     5.001    18.870     0.200
     0.870     7.527     0.200
     0.934    14.279     0.200
     0.981     7.911     0.200
     1.694     8.762     0.200
     1.713    10.141     0.200
     1.888    11.201     0.200
     1.907    10.242     0.200
     2.015     9.793     0.200
     2.240    10.867     0.200
     2.250    11.992     0.200
     2.424    10.852     0.200
     2.651    13.051     0.200
     5.009    18.789     0.200
     5.250    19.103     0.200
     1.716    10.792     0.200
     1.889    10.033     0.200
     1.909    10.401     0.200
     2.154    10.752     0.200
     2.171    10.664     0.200
     2.201    12.086     0.200
     2.243    11.845     0.200
     2.252    12.251     0.200
     2.440    13.241     0.200
     2.534    12.284     0.200
     2.652    13.672     0.200
     2.697    13.221     0.200
     3.153    15.336     0.200
     5.356    18.935     0.200
     5.691    20.622     0.200
     5.853    20.161     0.200
     5.983    20.653     0.200
     8.747    26.475     0.200
     1.490     9.348     0.200
     1.690     8.500     0.200
     1.707    10.771     0.200
     1.881    11.095     0.200
     1.900    12.233     0.200
     2.011    11.842     0.200
     2.145    10.273     0.200
     2.162     9.729     0.200
     2.234    10.428     0.200
     2.243    12.855     0.200
     2.524    11.809     0.200
     2.644    14.035     0.200
     5.089    18.020     0.200
     5.350    18.488     0.200
     1.486     9.292     0.200
     1.687     9.628     0.200
     1.702     9.731     0.200
     1.876    10.657     0.200
     1.895    10.789     0.200
     2.013     9.915     0.200
     2.229    10.562     0.200
     2.238    11.461     0.200
     2.428    10.917     0.200
     2.639    13.269     0.200
     2.682    12.589     0.200
     5.003    18.326     0.200
     1.420     9.874     0.200
     1.485     9.340     0.200
     1.621    10.719     0.200
     1.650    10.572     0.200
     1.687     9.488     0.200
     1.702    10.076     0.200
     1.742    10.781     0.200
     1.788    11.594     0.200
     1.876    10.752     0.200
     1.895    10.462     0.200
     1.912    12.471     0.200
     2.013     9.567     0.200
     2.141    10.586     0.200
     2.428    10.999     0.200
     3.233    13.271     0.200
     3.438    13.934     0.200
     3.438    14.391     0.200
     3.687    15.360     0.200
     4.277    15.978     0.200
     4.557    16.186     0.200
     4.997    18.303     0.200
     5.003    18.619     0.200
     5.243    18.534     0.200
     5.347    18.742     0.200
     5.639    19.802     0.200
     5.840    19.972     0.200
     5.971    20.046     0.200
     1.005     7.362     0.200
     1.134     8.465     0.200
     1.229     8.474     0.200
     1.266     8.643     0.200
     1.393     8.333     0.200
     1.533     9.337     0.200
     1.605    10.007     0.200
     1.612     8.317     0.200
     1.623     8.958     0.200
     1.647     9.105     0.200
     1.658    10.486     0.200
     1.662    11.016     0.200
     1.691     8.511     0.200
     1.698     9.426     0.200
     1.700    10.780     0.200
     1.704    11.000     0.200
     1.733    11.157     0.200
     1.770     9.161     0.200
     1.836     9.443     0.200
     1.853    11.270     0.200
     1.905    12.013     0.200
     2.009    11.045     0.200
     2.078    10.527     0.200
     2.143    11.427     0.200
     2.221    10.492     0.200
     2.301    10.318     0.200
     2.616    11.210     0.200
     2.752    11.571     0.200
     2.791    12.158     0.200
     2.796    11.858     0.200
     2.876    11.203     0.200
     2.932    11.725     0.200
     3.077    12.269     0.200
     3.211    13.174     0.200
     3.403    13.797     0.200
     3.608    12.227     0.200
     3.650    12.034     0.200
     3.722    13.590     0.200
     3.757    14.999     0.200
     3.966    15.307     0.200
     4.036    14.732     0.200
     4.185    15.081     0.200
     4.192    14.130     0.200
     4.547    15.158     0.200
     4.650    16.637     0.200
     4.938    17.543     0.200
     5.013    18.217     0.200
     5.068    17.580     0.200
     5.435    16.993     0.200
     5.536    19.806     0.200
     5.550    20.001     0.200
     5.850    20.422     0.200
     5.980    21.370     0.200
     0.961     7.908     0.200
     1.675     8.609     0.200
     1.691    11.067     0.200
     1.869    11.521     0.200
     1.885    11.869     0.200
     2.003     9.475     0.200
     2.129    10.543     0.200
     2.145    10.982     0.200
     2.219    11.696     0.200
     2.231    11.732     0.200
     2.415    11.964     0.200
     2.422    10.698     0.200
     2.508    12.542     0.200
     2.631    13.073     0.200
     2.673    12.503     0.200
     3.226    15.030     0.200
     3.679    16.001     0.200
     4.991    18.804     0.200
     5.231    19.182     0.200
     5.627    20.167     0.200
     5.958    20.945     0.200
     1.164     8.415     0.200
     1.366     9.176     0.200
     1.492     9.308     0.200
     1.554     9.668     0.200
     1.696     8.368     0.200
     1.711    10.057     0.200
     1.883    10.460     0.200
     1.903    11.354     0.200
     2.021     9.372     0.200
     2.167    11.606     0.200
     2.237    12.476     0.200
     2.246    12.878     0.200
     2.437    13.094     0.200
     2.529    13.456     0.200
     2.691    13.670     0.200
     2.693    12.933     0.200
     3.069    13.274     0.200
     3.445    15.816     0.200
     3.670    13.805     0.200
     3.694    16.820     0.200
     3.790    14.581     0.200
     3.934    15.760     0.200
     4.033    15.745     0.200
     4.186    14.503     0.200
     4.209    17.117     0.200
     4.286    17.786     0.200
     4.564    16.367     0.200
     4.763    17.954     0.200
     5.012    18.583     0.200
     5.252    19.070     0.200
     5.648    19.912     0.200
     1.136     9.083     0.200
     1.261     9.828     0.200
     1.571     9.780     0.200
     1.670    10.350     0.200
     1.683     8.693     0.200
     1.696    11.192     0.200
     1.870    11.191     0.200
     1.889    10.073     0.200
     2.000    11.495     0.200
     2.012     9.672     0.200
     2.137    10.887     0.200
     2.152    10.313     0.200
     2.181    11.749     0.200
     2.223    10.296     0.200
     2.232    12.355     0.200
     2.424    10.167     0.200
     2.430    10.825     0.200
     2.514    11.650     0.200
     2.628    16.715     0.200
     2.678    12.192     0.200
     3.681    15.514     0.200
     4.057    17.410     0.200
     8.404    23.194     0.200
    10.537    31.946     0.200
    16.782    43.243     0.200
     0.865     7.548     0.200
     1.703    10.442     0.200
     1.685    10.633     0.200
     1.879    10.682     0.200
     1.897    10.296     0.200
     2.009     9.785     0.200
     2.140    10.892     0.200
     2.157    11.931     0.200
     2.187    11.849     0.200
     2.241    11.446     0.200
     2.230    11.364     0.200
     2.425    13.116     0.200
     2.520    12.585     0.200
     2.684    13.080     0.200
     2.682    13.603     0.200
     3.058    13.917     0.200
     3.236    14.285     0.200
     3.305    13.620     0.200
     3.689    14.647     0.200
     3.927    15.346     0.200
     5.000    18.450     0.200
     1.349     9.125     0.200
     1.350     9.642     0.200
     1.416     9.530     0.200
     1.605     9.918     0.200
     1.692    10.819     0.200
     1.729    10.243     0.200
     1.704     9.985     0.200
     1.693     8.897     0.200
     1.779    12.035     0.200
     1.746     9.031     0.200
     1.814    11.986     0.200
     1.901    11.371     0.200
     1.965    11.212     0.200
     1.961    13.184     0.200
     1.993    11.133     0.200
     2.046    10.630     0.200
     2.097    10.584     0.200
     2.210    10.386     0.200
     2.394    11.619     0.200
     2.496    11.912     0.200
     3.446    13.999     0.200
     5.089    19.064     0.200
     5.707    20.699     0.200
     6.002    21.650     0.200
     7.651    23.715     0.200
     1.094     7.557     0.200
     1.238     8.517     0.200
     1.181     8.057     0.200
     1.222     8.115     0.200
     1.246     8.729     0.200
     1.326     8.974     0.200
     1.363     8.881     0.200
     1.409     8.622     0.200
     1.509     9.066     0.200
     1.543     8.417     0.200
     1.574    12.498     0.200
     1.606     9.931     0.200
     1.612     8.288     0.200
     1.610     7.956     0.200
     1.665     9.398     0.200
     1.645     8.275     0.200
     1.684    11.225     0.200
     1.725     9.904     0.200
     1.715     8.712     0.200
     1.819    10.814     0.200
     1.894    10.558     0.200
     1.871    12.305     0.200
     1.916     9.618     0.200
     1.953     9.166     0.200
     1.953     9.912     0.200
     1.974    13.135     0.200
     2.008    11.107     0.200
     1.974     9.827     0.200
     2.033    11.288     0.200
     1.991     9.667     0.200
     2.103    11.777     0.200
     2.051    10.097     0.200
     2.108    10.699     0.200
     2.131     9.716     0.200
     2.144    12.962     0.200
     2.286    12.633     0.200
     2.293     9.971     0.200
     2.415    13.966     0.200
     2.368     9.828     0.200
     2.424    15.906     0.200
     2.404    10.775     0.200
     2.539    10.880     0.200
     2.680    10.149     0.200
     2.978    11.685     0.200
     2.988    13.501     0.200
     3.100    10.991     0.200
     3.259    16.412     0.200
     3.369    12.912     0.200
     3.347    12.581     0.200
     3.477    14.657     0.200
     3.434    12.683     0.200
     3.489    12.966     0.200
     3.661    13.118     0.200
     3.786    13.907     0.200
     3.801    15.069     0.200
     3.955    14.137     0.200
     6.984    22.173     0.200
     8.573    25.422     0.200
    10.850    30.641     0.200
    12.155    35.093     0.200
     1.482     9.311     0.200
     1.482     9.233     0.200
     1.588    10.751     0.200
     1.682     8.793     0.200
     1.697     9.278     0.200
     1.872    10.896     0.200
     1.878    11.066     0.200
     1.890    11.596     0.200
     2.003    11.498     0.200
     2.009     9.476     0.200
     2.136    10.419     0.200
     2.152    10.355     0.200
     2.181    11.070     0.200
     2.224    11.163     0.200
     2.224    14.665     0.200
     2.234    11.945     0.200
     2.422    10.738     0.200
     2.514    11.387     0.200
     2.635    12.567     0.200
     2.678    12.202     0.200
     2.678    11.640     0.200
     2.826    12.364     0.200
     3.055    11.686     0.200
     3.104    13.238     0.200
     3.134    14.246     0.200
     3.206    13.476     0.200
     3.304    13.018     0.200
     3.434    14.576     0.200
     3.867    14.907     0.200
     3.921    15.575     0.200
     4.181    14.290     0.200
     5.193    19.192     0.200
     5.209    18.542     0.200
     5.460    20.347     0.200
     5.631    18.799     0.200
     5.634    18.307     0.200
     5.671    20.606     0.200
     5.719    18.784     0.200
     6.150    22.222     0.200
     6.190    21.448     0.200
     6.384    21.810     0.200
     6.502    21.333     0.200
     6.523    22.633     0.200
     7.106    24.757     0.200
     7.156    22.970     0.200
     7.257    26.179     0.200
     7.677    22.606     0.200
     8.054    26.528     0.200
     8.123    24.849     0.200
     8.182    25.590     0.200
     8.400    25.784     0.200
     8.400    24.687     0.200
     8.546    25.167     0.200
     8.725    25.486     0.200
     8.788    28.146     0.200
     8.888    28.578     0.200
     9.133    26.559     0.200
     9.208    28.980     0.200
     9.230    30.815     0.200
     9.543    28.049     0.200
    10.533    30.322     0.200
    12.232    35.703     0.200
    14.957    39.392     0.200
    15.087    36.929     0.200
    15.224    37.217     0.200
    15.339    38.157     0.200
    15.390    37.628     0.200
    15.546    38.822     0.200
    15.694    38.473     0.200
    16.267    38.776     0.200
    16.328    36.694     0.200
    16.346    38.487     0.200
    16.714    39.763     0.200
     8.398    24.242     0.200
     2.224    11.384     0.200
     1.866    11.010     0.200
     1.883    10.967     0.200
     2.003     9.514     0.200
     2.128    10.774     0.200
     2.143    11.552     0.200
     2.173    12.015     0.200
     2.216    11.814     0.200
     2.228    12.360     0.200
     2.414    12.763     0.200
     2.506    13.164     0.200
     2.628    13.945     0.200
     2.670    13.602     0.200
     2.819    14.508     0.200
     3.047    14.581     0.200
     3.152    14.942     0.200
     3.197    15.323     0.200
     3.223    14.979     0.200
     3.240    15.684     0.200
     3.353    13.593     0.200
     3.428    14.899     0.200
     3.647    15.655     0.200
     3.676    15.044     0.200
     3.859    15.857     0.200
     4.178    15.806     0.200
     4.189    17.379     0.200
     4.265    16.255     0.200
     4.295    17.019     0.200
     4.414    16.936     0.200
     4.445    17.430     0.200
     4.547    16.494     0.200
     4.566    17.900     0.200
     4.646    18.541     0.200
     4.743    18.569     0.200
     4.747    18.365     0.200
     4.985    18.698     0.200
     4.997    19.577     0.200
     5.054    17.909     0.200
     5.408    19.258     0.200
     5.452    20.715     0.200
     5.625    18.778     0.200
     5.626    20.391     0.200
     5.715    19.318     0.200
     5.827    19.807     0.200
     5.884    19.293     0.200
     5.901    20.623     0.200
     6.091    20.852     0.200
     6.119    21.400     0.200
     6.143    21.616     0.200
     6.182    21.822     0.200
     6.304    22.385     0.200
     6.515    23.325     0.200
     6.721    20.581     0.200
     7.154    23.525     0.200
     7.555    24.277     0.200
     8.176    26.162     0.200
     8.459    28.693     0.200
     8.724    26.099     0.200
     8.725    26.811     0.200
     8.729    26.931     0.200
    10.533    30.445     0.200
    10.534    30.264     0.200
     1.484     9.173     0.200
     1.648    10.629     0.200
     1.683     9.908     0.200
     1.874    11.055     0.200
     1.892    10.726     0.200
     2.009     9.253     0.200
     2.137    10.462     0.200
     2.153    11.047     0.200
     2.226    10.980     0.200
     2.236    11.647     0.200
     2.637    12.824     0.200
     2.637    12.658     0.200
     2.679    13.737     0.200
     2.679    12.103     0.200
     4.999    17.418     0.200
     6.130    15.650     0.200
     0.986     7.568     0.200
     1.026     7.454     0.200
     1.048     7.503     0.200
     1.187     8.337     0.200
     1.257     8.418     0.200
     1.274     8.559     0.200
     1.277     8.493     0.200
     1.563     8.816     0.200
     1.616     9.286     0.200
     1.678     8.382     0.200
     1.701     9.547     0.200
     1.733     9.043     0.200
     1.993    10.624     0.200
     2.043    10.115     0.200
     2.066    10.155     0.200
     2.088    10.215     0.200
     2.145    10.586     0.200
     2.195     9.810     0.200
     2.381    11.598     0.200
     2.388    11.238     0.200
     2.459    11.993     0.200
     2.492    11.695     0.200
     2.607    11.838     0.200
     2.636    11.353     0.200
     2.708    10.767     0.200
     2.963    11.579     0.200
     2.986    12.280     0.200
     3.079    12.518     0.200
     3.167    12.602     0.200
     3.426    13.107     0.200
     3.446    13.062     0.200
     3.529    13.864     0.200
     3.525    16.119     0.200
     3.752    14.607     0.200
     3.894    14.303     0.200
     3.975    14.693     0.200
     4.013    14.466     0.200
     4.209    16.040     0.200
     4.290    16.029     0.200
     4.358    15.479     0.200
     4.404    16.262     0.200
     4.412    16.596     0.200
     4.552    16.132     0.200
     4.555    16.429     0.200
     4.605    16.880     0.200
     4.618    16.815     0.200
     4.693    16.974     0.200
     4.722    16.801     0.200
     4.932    17.698     0.200
     4.959    17.682     0.200
     5.076    18.369     0.200
     5.131    17.525     0.200
     5.263    17.618     0.200
     5.334    18.590     0.200
     5.694    19.807     0.200
     5.765    18.890     0.200
     5.830    19.256     0.200
     5.923    19.597     0.200
     5.960    18.995     0.200
     5.990    20.926     0.200
     6.026    20.236     0.200
     6.094    19.870     0.200
     6.107    19.367     0.200
     6.162    19.746     0.200
     6.214    18.610     0.200
     6.306    21.802     0.200
     6.428    20.488     0.200
     6.584    21.051     0.200
     6.656    19.743     0.200
     7.370    23.239     0.200
     7.395    21.755     0.200
     7.613    23.803     0.200
     7.853    24.678     0.200
    10.850    30.035     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.730    17.639     0.200
     3.800    27.410     0.200
     4.192    26.684     0.200
     4.326    28.082     0.200
     4.402    31.595     0.200
     4.448    29.930     0.200
     1.950    13.030     0.200
     2.958    18.867     0.200
     2.461    16.490     0.200
     7.463    50.220     0.200
     1.986    13.954     0.200
     2.180    17.282     0.200
     2.435    15.996     0.200
     2.878    18.788     0.200
     3.028    19.729     0.200
     3.189    20.815     0.200
     3.388    21.562     0.200
     4.588    32.182     0.200
     8.486    59.372     0.200
     1.828    12.924     0.200
     2.294    16.216     0.200
     3.208    21.778     0.200
     3.808    24.012     0.200
     3.873    26.699     0.200
     3.897    28.125     0.200
     4.264    28.840     0.200
     4.343    30.365     0.200
     1.645    12.426     0.200
     2.986    24.136     0.200
     3.007    21.142     0.200
     3.102    21.166     0.200
     3.735    24.652     0.200
     3.898    27.301     0.200
     3.977    32.067     0.200
     4.108    28.795     0.200
     6.785    45.318     0.200
     1.447     8.110     0.200
     2.020    13.476     0.200
     7.049    49.038     0.200
     1.561     9.535     0.200
     1.627    11.362     0.200
     1.666    11.099     0.200
     1.696    12.149     0.200
     1.902    13.229     0.200
     2.036    13.587     0.200
     2.068    13.651     0.200
     3.163    20.356     0.200
     4.128    27.680     0.200
     4.214    26.586     0.200
     6.903    43.045     0.200
     7.460    50.464     0.200
     4.279    31.175     0.200
     2.420    16.498     0.200
     3.156    20.025     0.200
     1.646    10.212     0.200
     2.430    16.839     0.200
     4.129    28.176     0.200
     1.446     9.617     0.200
     1.658    10.423     0.200
     2.442    16.551     0.200
     3.178    21.189     0.200
     3.606    24.178     0.200
     3.777    24.905     0.200
     4.145    27.231     0.200
     5.250    36.466     0.200
     1.490    10.518     0.200
     1.512    10.955     0.200
     1.560    10.472     0.200
     3.739    25.161     0.200
     1.493     9.601     0.200
     2.437    15.800     0.200
     3.303    23.901     0.200
     3.773    25.776     0.200
     4.140    28.479     0.200
     2.432    16.375     0.200
     2.528    19.594     0.200
     3.828    32.173     0.200
     4.135    28.461     0.200
     2.436    16.792     0.200
     3.602    23.185     0.200
     4.140    27.349     0.200
     5.018    31.292     0.200
     1.486     9.565     0.200
     1.449     9.384     0.200
     3.181    19.977     0.200
     3.603    26.188     0.200
     4.148    27.338     0.200
     1.487     9.529     0.200
     1.545     9.767     0.200
     1.545     9.546     0.200
     1.659     9.664     0.200
     1.640    10.778     0.200
     2.089    14.619     0.200
     2.427    16.761     0.200
     2.428    16.293     0.200
     2.458    16.480     0.200
     3.165    22.234     0.200
     3.163    20.755     0.200
     3.762    24.436     0.200
     1.487     9.540     0.200
     2.428    16.263     0.200
     1.645    10.592     0.200
     2.428    16.982     0.200
     5.244    34.417     0.200
     6.523    46.300     0.200
     1.530    10.199     0.200
     1.711    10.826     0.200
     1.661    10.623     0.200
     1.717    11.990     0.200
     1.922    12.708     0.200
     2.447    16.889     0.200
     2.447    16.413     0.200
     3.404    24.123     0.200
     3.783    25.433     0.200
     4.243    30.641     0.200
     4.637    32.414     0.200
     1.503     9.585     0.200
     1.776    11.486     0.200
     2.462    17.479     0.200
     1.494     9.708     0.200
     1.785    11.596     0.200
     2.472    16.509     0.200
     7.506    50.783     0.200
     3.765    25.635     0.200
     4.133    27.425     0.200
     4.524    29.320     0.200
     4.970    31.911     0.200
     5.012    31.910     0.200
     5.534    35.077     0.200
     1.857    11.934     0.200
     1.437     9.062     0.200
     2.228    14.157     0.200
     2.228    13.989     0.200
     3.819    24.865     0.200
     3.918    26.181     0.200
     4.808    34.682     0.200
     1.486     9.505     0.200
     1.563    10.513     0.200
     1.691    10.620     0.200
     1.697    11.003     0.200
     1.759    12.193     0.200
     2.021    14.294     0.200
     2.533    17.019     0.200
     3.292    21.368     0.200
     4.368    33.693     0.200
     7.101    52.983     0.200
     7.132    53.269     0.200
     1.894    13.019     0.200
     1.972    13.346     0.200
     1.974    13.562     0.200
     1.974    13.316     0.200
     1.566    10.001     0.200
     1.696    11.678     0.200
     2.399    16.087     0.200
     3.588    23.681     0.200
     1.391     9.767     0.200
     1.410     9.118     0.200
     1.949    11.957     0.200
     2.024    13.290     0.200
     3.753    25.459     0.200
     1.611     9.516     0.200
     1.595    10.700     0.200
     2.403    16.444     0.200
     2.410    15.912     0.200
     9.501    67.834     0.200
     1.495     9.841     0.200
     1.600    10.246     0.200
     1.693    11.057     0.200
     1.908    12.334     0.200
     2.128    13.756     0.200
     2.144    14.520     0.200
     2.203    14.936     0.200
     2.438    15.655     0.200
     1.606    10.089     0.200
     3.790    26.779     0.200
     4.336    30.302     0.200
     4.341    31.013     0.200
     5.231    36.835     0.200
     1.509     9.647     0.200
     1.618    10.739     0.200
     1.911    12.014     0.200
     2.220    14.070     0.200
     1.924    12.249     0.200
     2.135    14.292     0.200
     2.327    16.278     0.200
     2.498    17.109     0.200
     1.597    10.594     0.200
     1.616    10.443     0.200
     1.708    10.901     0.200
     1.928    12.156     0.200
     2.155    15.884     0.200
     2.213    14.930     0.200
     3.243    20.229     0.200
     1.390     8.781     0.200
     1.556    10.331     0.200
     1.614    10.736     0.200
     1.764    12.035     0.200
     1.887    12.099     0.200
     1.898    12.671     0.200
     2.066    13.599     0.200
     2.378    14.953     0.200
     2.396    15.643     0.200
     2.407    15.856     0.200
     2.409    15.876     0.200
     2.725    18.186     0.200
     2.850    18.969     0.200
     1.642    10.825     0.200
     1.510    10.048     0.200
     1.754    12.553     0.200
     2.178    14.081     0.200
     1.703    11.500     0.200
     2.405    15.222     0.200
     2.752    18.757     0.200
     3.594    25.348     0.200
     2.271    14.085     0.200
     2.273    14.061     0.200
     1.441     9.431     0.200
     1.537     9.569     0.200
     1.556    10.211     0.200
     1.558    11.161     0.200
     1.715    11.518     0.200
     1.856    11.844     0.200
     2.103    13.861     0.200
     2.122    13.961     0.200
     2.178    14.764     0.200
     2.214    14.167     0.200
     2.465    16.547     0.200
     3.210    23.972     0.200
     1.591     7.740     0.200
     1.662    11.527     0.200
     1.729    11.589     0.200
     1.802    11.764     0.200
     1.894    11.982     0.200
     1.924    12.846     0.200
     2.052    13.838     0.200
     2.089    13.679     0.200
     2.324    15.010     0.200
     2.324    15.143     0.200
     2.347    15.680     0.200
     2.373    17.173     0.200
     2.623    17.327     0.200
     2.631    17.596     0.200
     4.053    28.863     0.200
     1.441     9.520     0.200
     1.473    10.002     0.200
     1.593    10.577     0.200
     1.620    10.683     0.200
     1.863    12.204     0.200
     1.923    12.555     0.200
     1.976    13.214     0.200
     2.223    14.994     0.200
     2.670    17.739     0.200
     1.447     9.252     0.200
     1.513     9.723     0.200
     1.540     9.927     0.200
     1.555    10.054     0.200
     1.555     9.814     0.200
     2.094    13.404     0.200
     2.122    14.692     0.200
     2.141    14.612     0.200
     2.178    15.229     0.200
     2.181    14.049     0.200
     2.186    15.094     0.200
     2.188    15.247     0.200
     2.188    14.941     0.200
     2.202    15.246     0.200
     2.233    15.094     0.200
     2.461    15.781     0.200
     2.599    16.200     0.200
     1.470     9.343     0.200
     1.521     9.727     0.200
     1.521     9.615     0.200
     1.521     9.924     0.200
     1.556     9.710     0.200
     1.863    12.507     0.200
     2.131    14.216     0.200
     2.131    14.056     0.200
     2.149    14.101     0.200
     2.187    14.774     0.200
     2.196    15.638     0.200
     2.206    15.228     0.200
     2.211    14.976     0.200
     2.241    14.583     0.200
     2.468    15.369     0.200
     1.392     9.129     0.200
     1.641    10.334     0.200
     1.748    11.717     0.200
     1.842    11.890     0.200
     1.880    12.078     0.200
     2.101    13.047     0.200
     2.132    13.833     0.200
     2.188    14.509     0.200
     2.213    14.808     0.200
     2.242    14.351     0.200
     1.522    10.074     0.200
     1.557     9.685     0.200
     1.643    10.316     0.200
     1.748    11.746     0.200
     1.874    11.782     0.200
     1.881    12.232     0.200
     2.132    13.870     0.200
     2.151    14.115     0.200
     2.188    14.607     0.200
     2.213    14.796     0.200
     2.242    14.251     0.200
     2.500    16.727     0.200
     1.574    10.461     0.200
     1.937    12.402     0.200
     1.951    12.249     0.200
     1.994    12.956     0.200
     2.964    19.336     0.200
     1.418     9.443     0.200
     1.432     9.916     0.200
     1.432     9.810     0.200
     1.471     8.907     0.200
     1.426     9.701     0.200
     1.619    10.089     0.200
     1.637    10.122     0.200
     1.657    11.456     0.200
     1.697    11.547     0.200
     1.751    10.613     0.200
     1.722    11.686     0.200
     1.722    10.792     0.200
     1.716    11.712     0.200
     2.341    14.537     0.200
     2.341    14.435     0.200
     2.399    15.817     0.200
     2.421    15.996     0.200
     2.427    15.484     0.200
     2.768    18.925     0.200
     3.099    20.800     0.200
     3.355    21.248     0.200
     1.448     8.873     0.200
     1.617    10.807     0.200
     1.829    11.793     0.200
     2.011    13.972     0.200
     2.158    14.155     0.200
     2.381    15.100     0.200
     2.403    16.645     0.200
     2.463    16.880     0.200
     1.442     9.000     0.200
     1.442     9.352     0.200
     1.453     9.745     0.200
     1.662    11.394     0.200
     1.785    11.677     0.200
     2.453    15.965     0.200
     3.592    25.010     0.200
     4.144    27.821     0.200
     2.017    13.486     0.200
     3.205    20.726     0.200
     3.346    22.800     0.200
     3.726    25.318     0.200
     1.722    10.970     0.200
     2.233    14.502     0.200
     1.386     8.701     0.200
     1.757    11.724     0.200
     2.136    14.521     0.200
     2.959    20.218     0.200
     2.008    13.361     0.200
     2.059    13.604     0.200
     3.643    25.410     0.200
     1.549    10.272     0.200
     2.150    14.290     0.200
     1.556    10.334     0.200
     3.157    20.992     0.200
     1.162     7.623     0.200
     1.162     7.482     0.200
     1.387     8.864     0.200
     1.544     9.827     0.200
     1.634    10.501     0.200
     1.468     9.153     0.200
     1.487     9.751     0.200
     1.650    10.105     0.200
     1.741    11.160     0.200
     1.741    11.380     0.200
     1.751    11.374     0.200
     1.816    12.151     0.200
     1.839    11.495     0.200
     2.275    15.423     0.200
     2.549    15.754     0.200
     2.759    16.949     0.200
     1.468     9.026     0.200
     1.487     9.727     0.200
     1.741    11.414     0.200
     1.741    11.054     0.200
     1.798    11.955     0.200
     1.829    12.294     0.200
     1.830    12.354     0.200
     1.839    11.347     0.200
     2.048    12.794     0.200
     1.455     9.791     0.200
     1.586    10.533     0.200
     1.684    11.229     0.200
     1.951    12.447     0.200
     2.039    12.743     0.200
     2.468    16.312     0.200
     1.382     9.509     0.200
     1.396     8.832     0.200
     1.432     8.936     0.200
     1.432     9.334     0.200
     1.491    10.120     0.200
     1.582    11.096     0.200
     2.361    14.809     0.200
     2.377    15.593     0.200
     2.433    16.241     0.200
     2.435    15.649     0.200
     2.435    16.196     0.200
     2.467    15.081     0.200
     2.741    18.050     0.200
     2.863    19.083     0.200
     2.945    19.928     0.200
     1.346     9.931     0.200
     1.463     8.993     0.200
     1.610    10.027     0.200
     1.842    11.806     0.200
     2.441    16.098     0.200
     6.885    48.694     0.200
     7.467    48.594     0.200
     1.550     9.709     0.200
     1.589    10.640     0.200
     1.675    10.448     0.200
     1.945    12.319     0.200
     2.471    16.531     0.200
     1.439     9.480     0.200
     1.693    10.955     0.200
     1.704    10.736     0.200
     1.781    12.140     0.200
     1.783    12.142     0.200
     1.792    11.125     0.200
     2.227    15.126     0.200
     3.300    23.214     0.200
     1.438    10.358     0.200
     1.449    10.256     0.200
     1.560    11.186     0.200
     1.669    11.533     0.200
     4.166    26.953     0.200
     4.185    26.447     0.200
     4.494    34.861     0.200
     1.483     9.467     0.200
     1.737    11.315     0.200
     1.748    11.176     0.200
     1.827    12.232     0.200
     1.836    11.668     0.200
     2.145    14.393     0.200
     1.876    13.059     0.200
     1.896    12.767     0.200
     2.145    14.587     0.200
     2.256    15.629     0.200
     2.434    15.944     0.200
     1.471     9.380     0.200
     3.533    24.758     0.200
     6.821    45.281     0.200
     1.466     9.429     0.200
     1.464     9.309     0.200
     1.715    12.202     0.200
     1.771    12.658     0.200
     1.783    12.731     0.200
     1.826    12.393     0.200
     1.465     9.622     0.200
     1.714    11.884     0.200
     1.714    12.015     0.200
     1.825    12.896     0.200
     2.005    12.545     0.200
     1.463     9.493     0.200
     1.476     9.726     0.200
     2.096    14.464     0.200
     2.209    16.148     0.200
     3.301    24.409     0.200
     1.459     9.294     0.200
     1.386     8.895     0.200
     1.406     9.656     0.200
     1.566     9.724     0.200
     1.601     9.978     0.200
     1.654    10.363     0.200
     1.654    10.261     0.200
     1.691    10.421     0.200
     2.383    15.165     0.200
     1.423    10.129     0.200
     1.468     9.320     0.200
     1.573    10.187     0.200
     2.213    14.668     0.200
     9.223    65.245     0.200
     1.461     9.320     0.200
     1.461     9.461     0.200
     1.566    10.176     0.200
     2.205    15.644     0.200
     9.215    66.969     0.200
     1.463     9.217     0.200
     1.554     9.895     0.200
     1.567    10.127     0.200
     1.567    10.256     0.200
     3.910    25.984     0.200
     4.260    27.933     0.200
     1.567     9.777     0.200
     1.470     9.285     0.200
     1.473     9.284     0.200
     1.572     9.955     0.200
     1.574    10.073     0.200
     1.416     9.548     0.200
     1.535     9.721     0.200
     3.152    22.578     0.200
     1.465     9.395     0.200
     1.466     9.432     0.200
     1.557    10.088     0.200
     1.894    12.410     0.200
     1.414     9.556     0.200
     3.111    22.283     0.200
     1.338     8.709     0.200
     1.168     7.832     0.200
     1.189     7.860     0.200
     1.280     8.290     0.200
     1.354    10.382     0.200
     1.368    10.171     0.200
     1.464     9.357     0.200
     1.466     9.233     0.200
     1.519    10.191     0.200
     1.527     9.582     0.200
     1.619    11.806     0.200
     1.711    11.586     0.200
     1.710    11.993     0.200
     1.896    12.349     0.200
     1.941    13.187     0.200
     1.972    12.498     0.200
     2.003    13.287     0.200
     2.123    14.556     0.200
     2.127    14.654     0.200
     2.149    14.177     0.200
     2.204    15.063     0.200
     2.216    14.848     0.200
     2.233    14.741     0.200
     2.242    14.823     0.200
     2.258    14.698     0.200
     2.285    15.135     0.200
     2.459    17.045     0.200
     2.483    15.770     0.200
     2.518    17.092     0.200
     2.523    16.285     0.200
     2.618    16.744     0.200
     2.638    17.629     0.200
     2.712    17.715     0.200
     2.765    18.702     0.200
     2.767    18.024     0.200
     2.807    18.295     0.200
     3.119    21.327     0.200
     1.263     8.333     0.200
     1.373     8.746     0.200
     1.401     8.944     0.200
     1.533     9.726     0.200
     2.328    15.669     0.200
     1.452     9.482     0.200
     1.220     7.910     0.200
     1.240     7.929     0.200
     1.311     8.367     0.200
     1.300    11.457     0.200
     1.496     9.302     0.200
     1.582    10.492     0.200
     1.633    10.611     0.200
     2.175    14.316     0.200
     2.194    14.489     0.200
     1.289     8.350     0.200
     1.475     9.286     0.200
     1.564    10.052     0.200
     1.421     9.184     0.200
     1.495     9.532     0.200
     1.524    10.734     0.200
     1.546     9.932     0.200
     1.612     7.801     0.200
     1.673    10.944     0.200
     1.729    11.358     0.200
     1.835    12.726     0.200
     1.898    13.167     0.200
     1.939    12.698     0.200
     2.061    13.550     0.200
     2.143    13.680     0.200
     2.155    14.706     0.200
     2.190    14.009     0.200
     2.243    15.466     0.200
     2.289    14.632     0.200
     2.296    15.681     0.200
     2.351    16.224     0.200
     2.413    16.677     0.200
     2.427    16.501     0.200
     1.109     7.289     0.200
     2.578    17.179     0.200
     1.333     8.907     0.200
     1.365     8.867     0.200
     1.453    10.232     0.200
     1.473     9.633     0.200
     1.511     9.622     0.200
     1.501    10.656     0.200
     1.507    10.303     0.200
     1.549    10.284     0.200
     1.591     9.740     0.200
     1.724    11.084     0.200
     1.818    12.517     0.200
     1.901    12.530     0.200
     2.145    13.687     0.200
     2.179    13.913     0.200
     2.265    15.435     0.200
     1.579    10.022     0.200
     1.692    12.142     0.200
     1.276     8.452     0.200
     1.276     8.202     0.200
     1.311     8.440     0.200
     1.397     8.798     0.200
     1.489     9.493     0.200
     1.402     8.723     0.200
     1.508    10.132     0.200
     1.816    11.419     0.200
     2.151    14.195     0.200
     3.183    20.733     0.200
     7.185    47.227     0.200
     9.172    66.759     0.200
     1.502     9.322     0.200
     1.581    10.880     0.200
     1.584    10.176     0.200
     1.584     9.584     0.200
     1.396     8.897     0.200
     1.626    11.447     0.200
     1.641    11.855     0.200
     1.702    10.877     0.200
     2.047    13.833     0.200
     2.115    14.075     0.200
     2.172    14.348     0.200
     2.223    14.410     0.200
     1.428     9.214     0.200
     1.711    11.372     0.200
     2.196    14.690     0.200
     1.423     8.911     0.200
     1.425     8.859     0.200
     1.529     9.856     0.200
     1.607    10.330     0.200
     1.615    10.293     0.200
     1.494    10.327     0.200
     1.190     7.735     0.200
     1.405     8.954     0.200
     1.542    10.948     0.200
     1.468     9.561     0.200
     1.608    10.995     0.200
     2.419    15.797     0.200
     1.002     6.534     0.200
     1.024     6.261     0.200
     1.086     6.747     0.200
     1.111     6.805     0.200
     1.263     7.969     0.200
     1.509     8.160     0.200
     1.435    10.191     0.200
     1.435     9.984     0.200
     1.492    10.346     0.200
     1.541    10.593     0.200
     1.508     9.583     0.200
     1.497     9.511     0.200
     2.238    14.978     0.200
     3.064    19.102     0.200
     3.089    22.008     0.200
     7.272    49.969     0.200
     1.499     9.693     0.200
     1.524     8.246     0.200
     1.945    13.288     0.200
     1.194     8.064     0.200
     1.317     8.712     0.200
     1.501     9.566     0.200
     1.502     9.874     0.200
     1.552    10.441     0.200
     1.563    10.028     0.200
     1.553    10.495     0.200
     3.090    21.497     0.200
     7.271    50.091     0.200
     2.244    15.067     0.200
     7.278    50.035     0.200
     1.420    10.591     0.200
     1.507     9.533     0.200
     2.249    14.963     0.200
     3.079    22.329     0.200
     3.184    19.964     0.200
     7.283    48.755     0.200
     1.556    10.354     0.200
     1.569    10.027     0.200
     1.673    10.774     0.200
     1.178     7.977     0.200
     1.213     8.137     0.200
     4.277    26.650     0.200
     7.261    49.512     0.200
     1.486     9.531     0.200
     1.478     9.544     0.200
     1.514     8.229     0.200
     3.097    22.550     0.200
     1.520     8.018     0.200
     1.498     9.631     0.200
     1.550    10.084     0.200
     3.086    22.695     0.200
     1.552     9.720     0.200
     1.536    10.137     0.200
     1.547     9.798     0.200
     1.074     7.140     0.200
     1.328     8.360     0.200
     1.354     8.685     0.200
     1.438     9.555     0.200
     1.509     8.161     0.200
     1.429     9.965     0.200
     1.480     9.314     0.200
     1.653    10.596     0.200
     1.677    11.553     0.200
     1.496    12.152     0.200
     1.566    10.130     0.200
     1.030     6.692     0.200
     1.043     6.779     0.200
     1.143     7.121     0.200
     1.211     7.482     0.200
     1.230     7.764     0.200
     1.433     9.191     0.200
     1.481     9.289     0.200
     1.953    13.239     0.200
     2.670    17.310     0.200
     6.984    46.173     0.200
     1.588    10.341     0.200
     1.645    11.631     0.200
     1.688    11.503     0.200
     1.484     9.459     0.200
     1.546    10.338     0.200
     2.751    17.486     0.200
     1.060     7.397     0.200
     1.096     7.556     0.200
     1.104     7.253     0.200
     1.291     8.338     0.200
     1.329     8.349     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     0.224     2.792     0.200
     0.466     3.496     0.200
     0.471     4.233     0.200
     0.710     4.830     0.200
     0.784     5.649     0.200
     0.916     6.402     0.200
     0.943     6.535     0.200
     0.953     6.830     0.200
     1.212     7.667     0.200
     5.994    34.645     0.200
     0.267     2.548     0.200
     0.781     5.075     0.200
     0.835     5.609     0.200
     0.881     5.775     0.200
     0.880     5.638     0.200
     0.949     6.660     0.200
     0.989     6.742     0.200
     1.141     7.011     0.200
     1.249     6.652     0.200
     1.458     7.490     0.200
     1.496     8.632     0.200
     2.686    14.368     0.200
     2.961    16.232     0.200
     3.013    16.466     0.200
     3.222    19.130     0.200
     0.733     6.157     0.200
     0.941     7.078     0.200
     1.007     6.968     0.200
     1.094     7.699     0.200
     1.102     7.836     0.200
     1.391     9.183     0.200
     1.417     8.884     0.200
     0.500     3.754     0.200
     0.709     5.557     0.200
     0.825     5.857     0.200
     0.936     6.463     0.200
     0.991     6.609     0.200
     1.070     7.320     0.200
     1.084     7.307     0.200
     1.092     7.298     0.200
     1.157     7.850     0.200
     1.373     8.463     0.200
     1.389     8.518     0.200
     2.052    12.161     0.200
     3.666    21.218     0.200
     4.213    23.834     0.200
     0.193     2.201     0.200
     0.618     4.738     0.200
     0.782     6.022     0.200
     0.758     5.723     0.200
     0.802     6.065     0.200
     0.776     5.453     0.200
     0.803     6.054     0.200
     0.828     6.010     0.200
     0.868     6.601     0.200
     0.906     6.562     0.200
     0.958     7.454     0.200
     1.017     7.380     0.200
     1.000     7.729     0.200
     1.096     7.988     0.200
     1.539     9.257     0.200
     1.938    12.005     0.200
     2.578    14.876     0.200
     2.604    15.657     0.200
     3.646    21.844     0.200
     0.783     6.789     0.200
     0.975     7.769     0.200
     1.050     7.700     0.200
     1.133     8.489     0.200
     1.141     8.559     0.200
     1.436     9.811     0.200
     3.526    21.203     0.200
     0.569     4.420     0.200
     0.448     3.881     0.200
     0.819     5.587     0.200
     0.874     5.672     0.200
     0.840     6.681     0.200
     0.967     6.609     0.200
     0.990     6.406     0.200
     1.418     7.955     0.200
     0.398     3.391     0.200
     0.398     3.313     0.200
     0.394     3.394     0.200
     0.464     3.683     0.200
     0.607     4.393     0.200
     0.809     6.170     0.200
     0.826     6.215     0.200
     0.919     5.726     0.200
     0.944     7.602     0.200
     1.019     7.074     0.200
     0.311     2.169     0.200
     0.311     2.868     0.200
     0.312     2.152     0.200
     0.315     2.819     0.200
     0.316     2.383     0.200
     0.316     2.970     0.200
     0.377     2.907     0.200
     0.573     4.158     0.200
     0.904     5.814     0.200
     1.257     7.510     0.200
     0.343     2.362     0.200
     0.343     3.022     0.200
     0.277     3.415     0.200
     0.370     2.714     0.200
     0.372     2.739     0.200
     0.423     3.146     0.200
     0.622     4.264     0.200
     1.006     6.682     0.200
     0.998     8.094     0.200
     0.686     5.371     0.200
     0.777     5.904     0.200
     0.814     6.478     0.200
     0.855     6.396     0.200
     0.970     7.368     0.200
     1.151     7.500     0.200
     1.257     8.044     0.200
     1.256     8.825     0.200
     1.532     9.571     0.200
     0.256     3.295     0.200
     0.375     3.092     0.200
     0.428     3.795     0.200
     0.467     3.676     0.200
     0.681     5.000     0.200
     0.319     2.326     0.200
     0.319     2.576     0.200
     0.310     2.680     0.200
     0.313     2.576     0.200
     0.555     4.151     0.200
     0.824     6.083     0.200
     0.910     6.177     0.200
     0.885     5.899     0.200
     1.044     7.027     0.200
     1.170     8.456     0.200
     0.302     3.155     0.200
     0.274     2.822     0.200
     0.528     4.147     0.200
     0.646     4.811     0.200
     0.724     5.012     0.200
     0.730     5.432     0.200
     0.808     5.826     0.200
     0.897     5.925     0.200
     0.975     7.385     0.200
     1.034     7.221     0.200
     1.315     8.586     0.200
     1.316     8.578     0.200
     1.323     8.150     0.200
     3.207    18.348     0.200
     0.279     2.319     0.200
     0.281     2.323     0.200
     0.545     4.293     0.200
     0.584     4.430     0.200
     0.695     5.962     0.200
     0.896     6.584     0.200
     1.031     7.247     0.200
     1.173     8.168     0.200
     1.188     8.431     0.200
     1.346     9.099     0.200
     1.429     9.701     0.200
     1.641    10.071     0.200
     1.647    10.191     0.200
     0.285     2.546     0.200
     0.287     2.515     0.200
     0.558     4.091     0.200
     0.573     4.520     0.200
     0.692     5.930     0.200
     0.885     6.682     0.200
     1.020     7.428     0.200
     1.178     8.241     0.200
     1.178     8.372     0.200
     1.195     8.599     0.200
     1.340     8.523     0.200
     1.340     8.683     0.200
     3.399    19.192     0.200
     0.288     2.551     0.200
     0.289     2.625     0.200
     0.552     4.266     0.200
     0.574     4.618     0.200
     0.688     6.079     0.200
     0.886     6.733     0.200
     1.021     7.427     0.200
     1.172     8.758     0.200
     1.172     8.414     0.200
     1.172     8.539     0.200
     1.188     8.778     0.200
     3.396    19.252     0.200
     0.573     4.354     0.200
     0.698     5.624     0.200
     0.884     6.517     0.200
     1.019     7.228     0.200
     1.186     8.843     0.200
     1.186     7.793     0.200
     1.186     8.033     0.200
     1.203     9.079     0.200
     1.434     9.675     0.200
     1.486     9.958     0.200
     1.543    10.058     0.200
     0.282     2.588     0.200
     0.283     2.377     0.200
     0.283     2.588     0.200
     0.553     4.255     0.200
     0.578     4.587     0.200
     0.694     6.002     0.200
     0.890     6.370     0.200
     1.025     7.026     0.200
     1.177     8.300     0.200
     1.343     8.717     0.200
     0.269     2.580     0.200
     0.271     2.599     0.200
     0.583     4.373     0.200
     0.562     4.026     0.200
     0.710     5.646     0.200
     0.895     6.617     0.200
     1.030     7.045     0.200
     1.194     8.013     0.200
     1.210     8.964     0.200
     1.210     8.456     0.200
     1.355     8.555     0.200
     1.355     8.657     0.200
     1.387     8.531     0.200
     1.403     8.749     0.200
     1.832    10.771     0.200
     2.442    14.914     0.200
     3.308    19.812     0.200
     3.416    19.417     0.200
     0.271     2.425     0.200
     0.273     2.508     0.200
     0.542     4.210     0.200
     0.592     4.467     0.200
     0.703     5.992     0.200
     0.903     6.243     0.200
     1.038     6.900     0.200
     1.178     8.218     0.200
     1.193     8.433     0.200
     1.355     8.692     0.200
     1.375     8.617     0.200
     1.484     9.138     0.200
     0.539     4.401     0.200
     0.544     4.683     0.200
     0.604     4.837     0.200
     0.680     5.364     0.200
     1.059     7.100     0.200
     1.198     7.820     0.200
     1.238     8.032     0.200
     1.264     8.939     0.200
     1.383    10.153     0.200
     1.386     9.979     0.200
     1.390     8.438     0.200
     1.542     9.398     0.200
     1.560     8.988     0.200
     2.995    18.136     0.200
     3.564    21.575     0.200
     0.275     2.601     0.200
     0.276     2.620     0.200
     0.564     4.237     0.200
     0.578     4.278     0.200
     0.705     5.487     0.200
     0.890     6.148     0.200
     1.025     6.819     0.200
     1.192     9.096     0.200
     1.192     8.088     0.200
     1.208     9.117     0.200
     1.350     8.952     0.200
     3.576    22.178     0.200
     0.279     2.467     0.200
     0.281     2.428     0.200
     0.562     4.130     0.200
     0.576     4.372     0.200
     0.700     5.588     0.200
     0.888     6.594     0.200
     1.023     7.149     0.200
     1.186     8.332     0.200
     1.346     9.081     0.200
     0.281     1.735     0.200
     0.281     2.184     0.200
     0.572     4.440     0.200
     0.571     4.483     0.200
     0.703     5.701     0.200
     0.883     6.255     0.200
     1.018     6.884     0.200
     1.195     8.609     0.200
     1.195     8.400     0.200
     1.212     9.963     0.200
     1.346     9.255     0.200
     1.346     9.136     0.200
     0.277     2.359     0.200
     0.279     2.390     0.200
     0.556     4.143     0.200
     0.580     4.238     0.200
     0.700     5.498     0.200
     1.027     7.076     0.200
     1.183     8.279     0.200
     1.200     8.671     0.200
     1.348     8.980     0.200
     1.448     9.384     0.200
     0.268     2.490     0.200
     0.270     2.530     0.200
     0.894     6.633     0.200
     1.029     7.020     0.200
     1.200     7.966     0.200
     1.356     8.381     0.200
     1.356     8.511     0.200
     3.418    19.279     0.200
     0.289     2.755     0.200
     0.289     2.415     0.200
     0.291     2.774     0.200
     0.291     2.635     0.200
     0.576     4.228     0.200
     1.190     8.462     0.200
     1.336     8.940     0.200
     1.487     9.789     0.200
     3.288    20.210     0.200
     0.289     2.823     0.200
     0.289     2.483     0.200
     0.290     2.834     0.200
     0.562     4.413     0.200
     0.576     4.272     0.200
     0.874     6.605     0.200
     1.009     7.234     0.200
     1.190     8.513     0.200
     1.336     9.040     0.200
     1.581     9.408     0.200
     3.163    19.599     0.200
     3.398    19.889     0.200
     0.281     2.563     0.200
     0.281     2.373     0.200
     0.283     2.573     0.200
     0.557     4.294     0.200
     0.577     4.406     0.200
     0.888     6.490     0.200
     1.023     6.884     0.200
     1.181     8.635     0.200
     1.344     8.984     0.200
     1.444     9.477     0.200
     0.437     3.795     0.200
     0.534     4.282     0.200
     0.733     5.534     0.200
     0.733     5.355     0.200
     0.833     5.889     0.200
     0.901     7.132     0.200
     0.901     7.027     0.200
     0.892     6.340     0.200
     0.892     6.730     0.200
     0.894     6.730     0.200
     0.938     6.899     0.200
     1.002     7.499     0.200
     1.046     8.153     0.200
     1.050     8.366     0.200
     1.041     6.797     0.200
     1.041     6.938     0.200
     1.146     9.214     0.200
     1.164     8.024     0.200
     1.211     8.291     0.200
     1.211     9.048     0.200
     1.209     7.854     0.200
     1.359     8.745     0.200
     1.378     9.041     0.200
     1.414     8.741     0.200
     0.260     2.815     0.200
     0.262     2.737     0.200
     0.596     4.747     0.200
     0.549     3.818     0.200
     0.908     6.750     0.200
     1.043     7.312     0.200
     1.192     8.804     0.200
     1.192     9.124     0.200
     1.207     9.458     0.200
     1.365     9.230     0.200
     1.465     9.713     0.200
     1.499     9.783     0.200
     1.580    10.265     0.200
     1.666    10.739     0.200
     2.056    13.051     0.200
     2.088    13.127     0.200
     0.205     1.724     0.200
     0.205     2.314     0.200
     0.207     2.313     0.200
     0.956     6.281     0.200
     1.092     6.985     0.200
     1.420     8.813     0.200
     0.241     1.850     0.200
     0.241     2.280     0.200
     0.243     2.300     0.200
     0.539     3.999     0.200
     0.616     4.600     0.200
     0.928     6.822     0.200
     1.063     7.266     0.200
     1.384     9.279     0.200
     2.065    12.340     0.200
     0.231     1.898     0.200
     0.231     2.277     0.200
     0.233     2.250     0.200
     0.233     1.930     0.200
     0.535     3.935     0.200
     0.626     4.609     0.200
     0.938     6.838     0.200
     1.073     7.489     0.200
     1.218    10.041     0.200
     1.395     9.190     0.200
     2.075    12.577     0.200
     0.282     2.799     0.200
     0.282     2.416     0.200
     0.566     4.357     0.200
     0.571     4.516     0.200
     0.883     6.699     0.200
     1.018     7.288     0.200
     1.187     8.531     0.200
     1.187     8.679     0.200
     1.204     8.753     0.200
     1.204     8.476     0.200
     1.342     9.130     0.200
     1.443     9.517     0.200
     3.393    20.271     0.200
     0.339     3.091     0.200
     0.498     3.935     0.200
     0.591     4.503     0.200
     0.751     5.529     0.200
     0.865     5.798     0.200
     0.846     5.768     0.200
     0.865     6.023     0.200
     0.884     6.815     0.200
     0.901     6.209     0.200
     0.893     6.100     0.200
     0.882     6.396     0.200
     0.882     6.197     0.200
     0.883     6.416     0.200
     0.942     7.547     0.200
     1.004     7.157     0.200
     1.044     6.630     0.200
     1.044     6.520     0.200
     1.152     7.667     0.200
     1.174     7.725     0.200
     1.222     7.559     0.200
     1.427     8.610     0.200
     2.059    11.450     0.200
     0.403     3.142     0.200
     0.479     3.849     0.200
     0.480     3.870     0.200
     0.910     6.450     0.200
     1.229     8.004     0.200
     1.251     8.155     0.200
     1.244     8.516     0.200
     1.336     8.032     0.200
     1.336     8.200     0.200
     0.367     3.262     0.200
     0.618     5.021     0.200
     0.618     5.240     0.200
     0.620     5.182     0.200
     0.645     4.642     0.200
     0.688     5.177     0.200
     0.767     5.218     0.200
     0.963     6.688     0.200
     1.000     8.648     0.200
     1.013     7.114     0.200
     1.075     7.517     0.200
     1.098     7.889     0.200
     1.109     7.451     0.200
     1.179     9.292     0.200
     1.188     8.960     0.200
     1.308     8.491     0.200
     1.316     8.562     0.200
     1.370     8.071     0.200
     1.368     9.564     0.200
     1.972    12.114     0.200
     2.864    17.354     0.200
     3.230    18.387     0.200
     3.805    22.794     0.200
     0.346     3.132     0.200
     0.578     4.382     0.200
     0.688     4.926     0.200
     0.747     5.972     0.200
     0.748     5.985     0.200
     0.748     5.744     0.200
     0.772     5.938     0.200
     0.889     6.710     0.200
     0.889     6.501     0.200
     0.899     6.705     0.200
     0.983     6.832     0.200
     1.083     7.620     0.200
     1.179     7.896     0.200
     1.261     9.444     0.200
     1.276     9.048     0.200
     1.359     8.744     0.200
     1.564     9.830     0.200
     2.192    12.564     0.200
     5.700    32.329     0.200
     0.499     4.346     0.200
     0.545     4.752     0.200
     0.546     3.758     0.200
     0.559     4.508     0.200
     0.882     6.000     0.200
     0.836     5.906     0.200
     0.904     7.733     0.200
     1.099     7.650     0.200
     1.148     8.324     0.200
     1.183     8.483     0.200
     1.338     7.632     0.200
     3.160    18.327     0.200
     0.348     3.231     0.200
     0.580     4.588     0.200
     0.690     5.223     0.200
     0.746     5.971     0.200
     0.746     5.776     0.200
     0.747     5.562     0.200
     0.747     5.984     0.200
     0.891     6.582     0.200
     0.891     6.731     0.200
     0.898     7.409     0.200
     0.945     8.540     0.200
     0.976     7.292     0.200
     0.985     7.095     0.200
     1.082     8.494     0.200
     1.180     8.039     0.200
     1.260     8.433     0.200
     1.277     9.208     0.200
     1.436     9.193     0.200
     2.937    16.726     0.200
     0.403     3.408     0.200
     0.444     3.747     0.200
     0.444     3.607     0.200
     0.446     3.333     0.200
     0.446     3.599     0.200
     0.707     5.352     0.200
     0.795     6.071     0.200
     0.845     6.157     0.200
     1.301     8.414     0.200
     1.423     9.588     0.200
     0.448     3.728     0.200
     0.450     3.337     0.200
     0.450     3.716     0.200
     0.699     5.721     0.200
     0.837     6.331     0.200
     1.231     8.275     0.200
     1.231     8.396     0.200
     1.284     8.652     0.200
     1.340     9.122     0.200
     1.340     8.751     0.200
     1.406     9.991     0.200
     1.560     9.625     0.200
     1.560     9.785     0.200
     3.882    20.420     0.200
     0.132     2.436     0.200
     0.399     3.505     0.200
     0.525     4.067     0.200
     0.785     5.361     0.200
     0.785     5.231     0.200
     0.787     5.409     0.200
     0.856     5.809     0.200
     0.856     5.689     0.200
     0.935     6.546     0.200
     0.965     6.099     0.200
     1.063     7.036     0.200
     1.067     7.374     0.200
     1.080     7.245     0.200
     1.096     6.431     0.200
     1.149     7.866     0.200
     1.186     7.026     0.200
     1.330     8.174     0.200
     1.338     7.899     0.200
     1.437     8.144     0.200
     1.699    10.376     0.200
     2.043    12.278     0.200
     2.191    12.093     0.200
     0.431     3.451     0.200
     0.433     3.457     0.200
     0.662     4.386     0.200
     0.764     4.537     0.200
     0.895     6.235     0.200
     1.315     8.747     0.200
     1.315     9.227     0.200
     1.416     9.408     0.200
     0.509     4.270     0.200
     0.509     4.012     0.200
     0.510     4.299     0.200
     0.585     3.683     0.200
     0.877     6.734     0.200
     1.026     6.893     0.200
     1.034     7.114     0.200
     1.034     6.997     0.200
     1.089     7.943     0.200
     1.106     8.410     0.200
     1.192     9.666     0.200
     1.205     8.487     0.200
     1.205     8.338     0.200
     1.240     8.753     0.200
     1.323     8.806     0.200
     1.384     9.494     0.200
     1.408    10.227     0.200
     1.482    10.662     0.200
     1.495     9.723     0.200
     1.898    11.809     0.200
     2.200    12.977     0.200
     2.488    14.866     0.200
     0.079     2.473     0.200
     0.079     2.123     0.200
     0.078     1.491     0.200
     0.426     3.886     0.200
     0.665     4.382     0.200
     1.004     6.543     0.200
     1.307     9.396     0.200
     1.533     9.698     0.200
     1.704    10.036     0.200
     1.776    10.519     0.200
     2.080    11.895     0.200
     2.154    12.054     0.200
     3.651    20.735     0.200
     4.342    24.992     0.200
     0.489     4.393     0.200
     0.489     4.174     0.200
     0.490     3.414     0.200
     0.599     3.727     0.200
     1.007     7.108     0.200
     1.038     6.761     0.200
     1.107     7.851     0.200
     1.223     8.514     0.200
     1.251     8.950     0.200
     1.335     8.924     0.200
     1.403     9.986     0.200
     1.427     9.000     0.200
     1.558     9.455     0.200
     2.213    13.547     0.200
     0.514     4.297     0.200
     0.515     4.308     0.200
     0.515     4.038     0.200
     0.595     3.871     0.200
     0.699     5.171     0.200
     0.877     8.112     0.200
     1.039     6.921     0.200
     1.054     7.531     0.200
     1.093     7.958     0.200
     1.210     8.228     0.200
     1.254     8.895     0.200
     1.336     8.950     0.200
     1.506     9.526     0.200
     1.548     9.566     0.200
     1.760    11.031     0.200
     1.894    11.878     0.200
     2.171    13.464     0.200
     2.496    15.101     0.200
     3.238    18.933     0.200
     3.370    20.338     0.200
     0.380     3.391     0.200
     0.504     4.025     0.200
     0.505     4.056     0.200
     0.599     3.479     0.200
     0.690     4.873     0.200
     0.878     6.265     0.200
     0.878     5.975     0.200
     0.888     7.526     0.200
     1.028     6.675     0.200
     1.078     7.832     0.200
     1.051     7.230     0.200
     1.100     7.602     0.200
     1.222     9.288     0.200
     1.216     7.934     0.200
     1.216     7.759     0.200
     1.256     8.590     0.200
     1.339     8.555     0.200
     1.391     8.719     0.200
     1.493    10.591     0.200
     1.509     9.254     0.200
     1.554     9.144     0.200
     1.764    10.748     0.200
     1.898    11.584     0.200
     1.913    11.073     0.200
     0.386     3.372     0.200
     0.499     4.128     0.200
     0.499     4.139     0.200
     0.599     3.668     0.200
     0.682     5.071     0.200
     0.885     6.349     0.200
     0.896     7.954     0.200
     1.020     6.745     0.200
     1.046     7.165     0.200
     1.046     7.475     0.200
     1.103     7.730     0.200
     1.219     8.034     0.200
     1.227    10.021     0.200
     1.254     8.860     0.200
     1.337     8.878     0.200
     1.495    10.771     0.200
     1.509     9.654     0.200
     1.556    10.780     0.200
     1.605     9.838     0.200
     1.912    11.384     0.200
     0.288     3.111     0.200
     0.443     3.590     0.200
     0.443     3.750     0.200
     0.445     3.746     0.200
     0.445     3.476     0.200
     0.661     4.770     0.200
     0.765     4.593     0.200
     0.788     6.066     0.200
     0.886     6.586     0.200
     1.240     7.895     0.200
     1.314     8.770     0.200
     1.323     8.793     0.200
     1.349     8.359     0.200
     1.570     9.498     0.200
     1.570     9.270     0.200
     2.419    14.909     0.200
     2.582    15.499     0.200
     0.274     2.665     0.200
     0.395     3.987     0.200
     0.508     4.082     0.200
     0.618     4.442     0.200
     0.720     4.853     0.200
     0.720     4.473     0.200
     0.732     5.277     0.200
     0.809     5.162     0.200
     0.817     5.795     0.200
     0.933     5.707     0.200
     0.958     6.986     0.200
     0.988     6.253     0.200
     1.006     6.700     0.200
     1.006     6.570     0.200
     1.008     6.420     0.200
     1.008     6.670     0.200
     1.025     6.384     0.200
     1.045     6.620     0.200
     1.063     7.391     0.200
     1.068     7.426     0.200
     1.071     6.887     0.200
     1.089     8.133     0.200
     1.096     6.642     0.200
     1.158     7.885     0.200
     1.158     7.987     0.200
     1.186     6.841     0.200
     1.300     7.675     0.200
     1.300     7.680     0.200
     1.786    10.387     0.200
     1.934    11.170     0.200
     0.358     3.083     0.200
     0.452     3.675     0.200
     0.452     3.878     0.200
     0.649     4.481     0.200
     0.928     6.111     0.200
     0.935     7.218     0.200
     0.935     7.780     0.200
     1.082     7.102     0.200
     1.168     7.089     0.200
     1.271     7.829     0.200
     1.301     8.417     0.200
     2.151    12.063     0.200
     2.553    14.796     0.200
     0.366     3.237     0.200
     0.356     1.948     0.200
     0.652     4.444     0.200
     0.895     6.200     0.200
     0.895     6.009     0.200
     0.982     6.072     0.200
     0.984     5.931     0.200
     1.022     6.534     0.200
     1.135     7.108     0.200
     1.136     7.683     0.200
     1.137     7.057     0.200
     1.148     7.875     0.200
     1.174     9.036     0.200
     1.224     6.915     0.200
     1.234     7.057     0.200
     1.242     8.339     0.200
     1.297     8.860     0.200
     1.337     8.040     0.200
     1.337     7.936     0.200
     1.337     8.196     0.200
     1.365     7.713     0.200
     1.812    10.980     0.200
     0.284     3.060     0.200
     0.447     3.196     0.200
     0.449     2.792     0.200
     0.761     4.693     0.200
     0.665     4.798     0.200
     0.790     6.222     0.200
     0.882     5.554     0.200
     1.236     7.964     0.200
     1.311     9.082     0.200
     1.412     9.619     0.200
     1.697    10.587     0.200
     2.582    14.404     0.200
     0.266     1.793     0.200
     0.377     3.224     0.200
     0.438     3.922     0.200
     0.438     3.973     0.200
     0.668     4.848     0.200
     0.890     7.199     0.200
     0.963     5.578     0.200
     0.944     6.589     0.200
     0.953     6.412     0.200
     1.070     7.097     0.200
     1.070     6.976     0.200
     1.159     7.819     0.200
     1.275     8.048     0.200
     1.295     8.282     0.200
     1.295     8.491     0.200
     1.381     8.296     0.200
     2.221    12.846     0.200
     0.238     1.868     0.200
     0.530     3.908     0.200
     0.531     4.693     0.200
     0.532     3.691     0.200
     0.610     4.692     0.200
     0.856     6.706     0.200
     0.884     6.735     0.200
     0.903     7.628     0.200
     0.959     6.634     0.200
     0.959     6.754     0.200
     0.981     7.119     0.200
     1.016     6.196     0.200
     1.069     8.169     0.200
     1.069     8.479     0.200
     1.085     6.907     0.200
     1.113     7.236     0.200
     1.165     7.735     0.200
     1.195     8.249     0.200
     1.241     9.021     0.200
     1.261     8.187     0.200
     1.298     9.188     0.200
     1.318     8.465     0.200
     1.354     9.026     0.200
     1.353     7.895     0.200
     1.385     9.046     0.200
     1.385     8.831     0.200
     1.438     8.815     0.200
     1.838    10.844     0.200
     1.838    11.243     0.200
     1.859    11.179     0.200
     2.079    12.637     0.200
     2.102    12.320     0.200
     2.103    12.701     0.200
     2.437    13.925     0.200
     2.445    15.029     0.200
     0.402     3.492     0.200
     0.408     3.718     0.200
     0.408     3.429     0.200
     0.408     2.768     0.200
     0.783     4.637     0.200
     0.806     5.624     0.200
     0.890     7.759     0.200
     0.981     6.710     0.200
     0.975     8.244     0.200
     0.980     7.052     0.200
     1.227     7.912     0.200
     1.260     9.191     0.200
     1.295     7.605     0.200
     1.367    10.193     0.200
     1.427    10.871     0.200
     2.098    12.721     0.200
     2.317    14.480     0.200
     3.644    20.491     0.200
     0.309     1.445     0.200
     0.416     3.376     0.200
     0.625     4.687     0.200
     0.693     4.985     0.200
     0.716     6.551     0.200
     0.772     5.689     0.200
     0.772     5.392     0.200
     0.773     5.684     0.200
     0.843     5.935     0.200
     0.849     5.748     0.200
     0.853     6.017     0.200
     0.872     5.542     0.200
     0.925     6.065     0.200
     0.959     6.077     0.200
     0.983     6.694     0.200
     1.022     7.381     0.200
     1.058     6.540     0.200
     1.050     6.796     0.200
     1.079     7.772     0.200
     1.113     7.027     0.200
     1.148     7.651     0.200
     1.148     7.041     0.200
     1.160     8.582     0.200
     1.201     8.219     0.200
     1.231     7.733     0.200
     1.218     7.374     0.200
     1.260     8.203     0.200
     1.334     7.919     0.200
     1.311     7.011     0.200
     1.367     8.750     0.200
     1.422     8.228     0.200
     1.422     8.345     0.200
     1.441     8.028     0.200
     1.605     9.601     0.200
     1.626     9.756     0.200
     1.636     9.775     0.200
     1.845    11.299     0.200
     1.884    11.079     0.200
     0.195     2.230     0.200
     0.495     3.716     0.200
     0.505     4.351     0.200
     0.507     4.347     0.200
     0.544     4.413     0.200
     0.572     4.084     0.200
     0.899     7.079     0.200
     0.899     7.459     0.200
     0.923     7.272     0.200
     0.944     6.447     0.200
     0.944     8.039     0.200
     0.944     7.659     0.200
     0.978     6.436     0.200
     1.022     7.397     0.200
     1.106     7.884     0.200
     1.106     8.054     0.200
     1.116     7.580     0.200
     1.139     7.826     0.200
     1.175     8.212     0.200
     1.175     7.902     0.200
     1.186     7.754     0.200
     1.186     8.393     0.200
     1.225     8.100     0.200
     1.264     8.265     0.200
     1.277     8.542     0.200
     1.326     8.652     0.200
     1.320     8.218     0.200
     1.334     8.648     0.200
     1.371     8.003     0.200
     1.393     8.309     0.200
     1.415     8.260     0.200
     1.501     8.913     0.200
     1.537     8.356     0.200
     2.449    14.642     0.200
     0.180     2.127     0.200
     0.496     4.205     0.200
     0.496     4.067     0.200
     0.502     3.556     0.200
     0.497     4.201     0.200
     0.550     4.236     0.200
     0.560     3.912     0.200
     0.914     6.885     0.200
     0.941     6.138     0.200
     0.941     6.007     0.200
     0.938     7.865     0.200
     0.959     8.538     0.200
     0.964     6.293     0.200
     1.119     9.097     0.200
     1.127     7.673     0.200
     1.149     7.617     0.200
     1.177     7.929     0.200
     1.177     7.701     0.200
     1.195     8.196     0.200
     1.237     8.604     0.200
     1.267     8.041     0.200
     1.331     8.331     0.200
     1.335     7.935     0.200
     1.391     9.240     0.200
     1.386     7.740     0.200
     1.427     8.258     0.200
     2.100    12.509     0.200
     2.114    12.234     0.200
     2.456    13.816     0.200
     3.822    22.222     0.200
     0.177     2.024     0.200
     0.494     4.071     0.200
     0.494     3.940     0.200
     0.496     4.066     0.200
     0.556     3.724     0.200
     0.551     3.977     0.200
     0.961     6.181     0.200
     0.940     6.034     0.200
     0.917     7.026     0.200
     0.962     8.062     0.200
     1.122     8.896     0.200
     1.129     7.089     0.200
     1.151     7.356     0.200
     1.177     7.742     0.200
     1.196     7.859     0.200
     1.239     8.258     0.200
     1.267     7.921     0.200
     1.293     8.107     0.200
     1.331     8.436     0.200
     1.350     8.014     0.200
     1.390     7.562     0.200
     1.429     7.708     0.200
     1.429     8.097     0.200
     1.452     8.714     0.200
     1.522     9.247     0.200
     1.543     9.277     0.200
     1.847    10.400     0.200
     1.847    10.371     0.200
     1.873    11.487     0.200
     0.180     2.045     0.200
     0.494     4.130     0.200
     0.496     4.116     0.200
     0.552     3.990     0.200
     0.559     3.870     0.200
     0.942     6.164     0.200
     0.939     6.791     0.200
     0.963     6.337     0.200
     0.960     7.794     0.200
     1.121     8.852     0.200
     1.129     7.037     0.200
     1.151     7.351     0.200
     1.179     7.535     0.200
     1.179     7.660     0.200
     1.197     7.879     0.200
     1.238     7.594     0.200
     1.268     7.931     0.200
     1.329     8.822     0.200
     1.332     8.385     0.200
     1.392     9.120     0.200
     1.387     7.562     0.200
     1.428     9.498     0.200
     1.472    10.006     0.200
     1.544     9.263     0.200
     1.643     9.839     0.200
     1.848    10.694     0.200
     1.848    10.944     0.200
     2.102    12.862     0.200
     2.457    14.038     0.200
     2.469    14.909     0.200
     0.274     2.619     0.200
     0.365     2.720     0.200
     0.420     3.453     0.200
     0.672     4.908     0.200
     0.709     5.204     0.200
     0.709     4.872     0.200
     0.710     5.302     0.200
     0.710     5.134     0.200
     0.921     6.067     0.200
     0.982     7.384     0.200
     1.005     6.388     0.200
     1.018     6.382     0.200
     1.020     6.721     0.200
     1.021     7.039     0.200
     1.094     6.721     0.200
     1.128     7.977     0.200
     1.217     7.171     0.200
     1.217     7.273     0.200
     1.245     7.836     0.200
     1.295     8.946     0.200
     1.319     8.407     0.200
     2.040    12.459     0.200
     0.326     3.040     0.200
     0.188     2.596     0.200
     0.405     3.791     0.200
     0.405     3.521     0.200
     0.407     3.768     0.200
     0.758     5.227     0.200
     0.778     5.870     0.200
     0.920     6.680     0.200
     1.269     8.035     0.200
     1.377     8.438     0.200
     1.595     9.443     0.200
     1.637     9.251     0.200
     1.848    10.744     0.200
     1.953    11.048     0.200
     1.953    11.325     0.200
     2.011    11.956     0.200
     2.070    12.304     0.200
     2.276    13.273     0.200
     2.440    14.817     0.200
     2.596    14.425     0.200
     2.612    15.098     0.200
     2.605    14.753     0.200
     2.649    14.748     0.200
     3.206    18.947     0.200
     0.503     3.774     0.200
     0.525     4.366     0.200
     0.525     4.241     0.200
     0.526     4.367     0.200
     0.575     4.224     0.200
     0.885     8.429     0.200
     0.933     6.757     0.200
     1.096     8.317     0.200
     1.119     8.218     0.200
     1.159     8.410     0.200
     1.167     8.681     0.200
     1.206     9.647     0.200
     1.247     8.600     0.200
     1.297     9.579     0.200
     1.308     9.028     0.200
     1.361     9.560     0.200
     1.429     9.433     0.200
     0.263     2.358     0.200
     0.264     2.338     0.200
     0.351     2.792     0.200
     0.717     4.991     0.200
     1.035     7.614     0.200
     1.112     8.104     0.200
     1.112     8.409     0.200
     1.205     8.345     0.200
     1.322     9.792     0.200
     1.365     8.569     0.200
     1.465     9.382     0.200
     1.738    10.882     0.200
     1.840    11.163     0.200
     1.994    12.415     0.200
     2.128    13.098     0.200
     2.133    12.360     0.200
     2.133    13.009     0.200
     2.739    16.429     0.200
     0.687     4.480     0.200
     1.044     7.430     0.200
     1.116     7.320     0.200
     1.119     9.241     0.200
     1.179     7.282     0.200
     1.179     7.641     0.200
     1.322     7.540     0.200
     2.114    12.373     0.200
     2.723    15.788     0.200
     3.467    19.558     0.200
     4.157    23.884     0.200
     0.376     3.315     0.200
     0.624     4.926     0.200
     0.624     4.773     0.200
     0.814     6.222     0.200
     0.892     6.132     0.200
     0.992     6.655     0.200
     0.977     7.606     0.200
     0.977     7.348     0.200
     1.017     7.194     0.200
     1.023     7.459     0.200
     1.025     7.809     0.200
     1.025     6.957     0.200
     1.075     7.301     0.200
     1.104     8.124     0.200
     1.101     8.680     0.200
     1.198     7.558     0.200
     1.262     8.306     0.200
     1.312     8.987     0.200
     1.322     8.515     0.200
     1.330    10.015     0.200
     1.533     8.774     0.200
     1.573     9.440     0.200
     1.573     9.311     0.200
     0.481     4.123     0.200
     0.680     5.021     0.200
     0.850     7.826     0.200
     0.902     8.150     0.200
     0.912     8.033     0.200
     1.055     7.575     0.200
     1.101     9.498     0.200
     1.175     7.920     0.200
     1.236     8.559     0.200
     1.268     8.900     0.200
     1.352     9.076     0.200
     1.406     9.329     0.200
     1.437     9.805     0.200
     1.525     9.870     0.200
     1.573     9.817     0.200
     1.620     9.772     0.200
     1.620     9.554     0.200
     1.927    11.627     0.200
     1.927    12.158     0.200
     2.518    15.168     0.200
     0.405     3.472     0.200
     0.539     3.526     0.200
     0.602     4.536     0.200
     0.701     5.090     0.200
     0.786     6.007     0.200
     0.787     5.684     0.200
     0.787     5.454     0.200
     0.812     5.939     0.200
     0.812     6.059     0.200
     0.910     5.970     0.200
     0.931     7.886     0.200
     0.931     6.016     0.200
     0.972     6.697     0.200
     0.972     6.354     0.200
     0.976     7.362     0.200
     0.999     8.612     0.200
     0.999     7.622     0.200
     1.043     7.132     0.200
     1.078     6.765     0.200
     1.126     8.089     0.200
     1.165     7.134     0.200
     1.283     8.387     0.200
     1.553     8.651     0.200
     0.851     6.568     0.200
     0.710     4.927     0.200
     1.193     8.402     0.200
     1.348     8.589     0.200
     1.348     8.809     0.200
     1.574     9.314     0.200
     4.099    24.822     0.200
     4.479    24.595     0.200
     0.432     3.494     0.200
     0.472     4.041     0.200
     0.549     4.526     0.200
     0.836     6.849     0.200
     0.863     6.464     0.200
     0.883     7.585     0.200
     0.959     6.559     0.200
     1.049     8.455     0.200
     1.096     7.211     0.200
     1.096     7.375     0.200
     1.149     7.933     0.200
     1.167     7.837     0.200
     1.167     8.157     0.200
     1.252     8.221     0.200
     1.307     8.000     0.200
     1.367     9.269     0.200
     1.427     8.757     0.200
     1.427     9.007     0.200
     1.828    11.118     0.200
     2.424    14.056     0.200
     0.172     2.595     0.200
     0.562     4.263     0.200
     0.806     5.975     0.200
     0.806     5.573     0.200
     0.919     6.406     0.200
     1.189     7.235     0.200
     1.302     7.619     0.200
     1.361     9.413     0.200
     1.361     7.296     0.200
     1.375     8.312     0.200
     0.251     2.757     0.200
     0.441     3.704     0.200
     0.472     3.880     0.200
     0.529     4.442     0.200
     0.529     4.559     0.200
     0.750     5.407     0.200
     0.748     5.228     0.200
     0.847     5.515     0.200
     0.879     6.285     0.200
     0.880     6.064     0.200
     0.883     5.832     0.200
     0.883     5.880     0.200
     0.904     6.010     0.200
     0.907     6.780     0.200
     0.907     6.100     0.200
     0.920     6.378     0.200
     0.926     6.042     0.200
     0.965     7.421     0.200
     0.985     5.632     0.200
     1.002     6.825     0.200
     1.024     7.507     0.200
     1.049     6.329     0.200
     1.112     7.478     0.200
     1.119     6.901     0.200
     1.117     7.509     0.200
     1.126     6.373     0.200
     1.192     7.171     0.200
     1.223     7.302     0.200
     1.429     8.412     0.200
     1.721     9.954     0.200
     0.248     2.472     0.200
     0.409     3.489     0.200
     0.832     5.476     0.200
     0.868     6.443     0.200
     0.907     6.640     0.200
     1.057     9.141     0.200
     1.144     9.372     0.200
     1.144     9.892     0.200
     1.150     9.560     0.200
     1.150     7.718     0.200
     1.288     8.513     0.200
     1.288     8.394     0.200
     1.366     9.652     0.200
     1.625     9.474     0.200
     0.243     2.163     0.200
     0.480     3.811     0.200
     0.488     3.523     0.200
     0.491     3.597     0.200
     0.697     4.717     0.200
     0.795     5.056     0.200
     0.773     5.428     0.200
     0.847     5.759     0.200
     0.858     5.575     0.200
     0.876     5.527     0.200
     0.905     6.098     0.200
     0.930     6.159     0.200
     0.917     6.514     0.200
     0.957     6.399     0.200
     0.984     6.020     0.200
     1.000     6.034     0.200
     0.979     5.840     0.200
     0.979     6.961     0.200
     1.000     7.665     0.200
     1.006     7.147     0.200
     1.007     7.671     0.200
     1.066     6.679     0.200
     1.089     7.304     0.200
     1.094     7.553     0.200
     1.121     7.174     0.200
     1.146     7.605     0.200
     1.171     7.043     0.200
     1.170     8.021     0.200
     1.170     7.360     0.200
     1.190     8.631     0.200
     1.200     7.702     0.200
     1.236     7.264     0.200
     1.255     7.299     0.200
     1.343     8.152     0.200
     1.332     7.663     0.200
     1.347     7.595     0.200
     1.376     7.992     0.200
     1.376     7.875     0.200
     1.376     8.363     0.200
     1.388     8.261     0.200
     0.243     2.033     0.200
     0.481     3.848     0.200
     0.489     3.633     0.200
     0.491     3.595     0.200
     0.697     4.658     0.200
     0.697     5.017     0.200
     0.773     5.471     0.200
     0.795     5.088     0.200
     0.847     5.813     0.200
     0.858     5.653     0.200
     0.858     5.332     0.200
     0.858     5.661     0.200
     0.876     5.619     0.200
     0.876     5.498     0.200
     0.905     6.155     0.200
     0.916     6.834     0.200
     0.916     5.733     0.200
     0.930     6.197     0.200
     0.956     6.468     0.200
     0.984     5.933     0.200
     0.978     5.983     0.200
     1.000     6.216     0.200
     1.000     6.087     0.200
     1.067     6.651     0.200
     1.089     7.410     0.200
     1.094     7.699     0.200
     1.121     7.147     0.200
     1.170     7.538     0.200
     1.255     7.331     0.200
     1.236     7.138     0.200
     1.343     8.145     0.200
     1.376     8.085     0.200
     1.376     8.132     0.200
     1.389     8.261     0.200
     1.394     9.244     0.200
     2.921    17.467     0.200
     0.296     2.449     0.200
     0.352     3.249     0.200
     0.393     2.715     0.200
     0.609     4.504     0.200
     0.735     5.065     0.200
     0.808     5.264     0.200
     0.833     5.836     0.200
     0.889     5.659     0.200
     0.889     5.468     0.200
     0.991     6.060     0.200
     1.042     6.566     0.200
     1.002     7.298     0.200
     1.033     6.546     0.200
     1.032     6.518     0.200
     1.035     6.742     0.200
     1.051     7.123     0.200
     1.050     6.681     0.200
     1.050     8.152     0.200
     1.060     6.799     0.200
     1.077     6.710     0.200
     1.122     8.068     0.200
     1.165     8.336     0.200
     1.182     7.066     0.200
     1.200     7.038     0.200
     1.256     8.075     0.200
     1.256     7.925     0.200
     1.255     8.808     0.200
     1.269     8.330     0.200
     1.320     8.474     0.200
     1.336     9.311     0.200
     1.338     8.985     0.200
     1.339     9.283     0.200
     1.368     8.116     0.200
     1.368     7.895     0.200
     0.162     2.159     0.200
     0.278     2.605     0.200
     0.504     3.512     0.200
     0.565     4.316     0.200
     0.709     4.669     0.200
     0.776     5.487     0.200
     0.927     6.085     0.200
     1.015     6.383     0.200
     1.042     6.647     0.200
     1.048     8.294     0.200
     1.081     8.677     0.200
     1.151     8.864     0.200
     1.191     8.167     0.200
     1.207     8.834     0.200
     1.207     9.616     0.200
     1.347     8.108     0.200
     1.396     8.048     0.200
     2.029    11.553     0.200
     2.316    13.246     0.200
     2.361    13.856     0.200
     2.614    14.335     0.200
     2.636    14.755     0.200
     2.639    15.176     0.200
     2.664    14.867     0.200
     3.398    18.881     0.200
     3.439    19.386     0.200
     0.307     2.918     0.200
     0.355     3.069     0.200
     0.721     4.866     0.200
     0.740     5.201     0.200
     0.821     5.202     0.200
     0.989     6.962     0.200
     1.071     8.231     0.200
     1.072     7.831     0.200
     1.203     6.970     0.200
     1.219     7.715     0.200
     1.219     7.955     0.200
     1.221     7.928     0.200
     1.285     9.675     0.200
     1.551     9.105     0.200
     1.610     9.247     0.200
     2.129    12.450     0.200
     3.470    19.456     0.200
     3.825    20.899     0.200
     4.157    22.807     0.200
     0.284     2.320     0.200
     0.347     3.018     0.200
     0.390     2.745     0.200
     0.459     3.255     0.200
     0.627     4.376     0.200
     0.627     4.478     0.200
     0.640     4.647     0.200
     0.723     5.021     0.200
     0.794     5.423     0.200
     0.814     5.864     0.200
     0.901     5.552     0.200
     0.901     5.665     0.200
     0.990     7.187     0.200
     0.990     7.636     0.200
     1.002     6.097     0.200
     1.040     6.425     0.200
     1.031     6.566     0.200
     1.031     6.599     0.200
     1.036     5.769     0.200
     1.037     6.897     0.200
     1.038     6.684     0.200
     1.055     6.765     0.200
     1.086     6.691     0.200
     1.086     6.809     0.200
     1.114     8.180     0.200
     1.162     8.307     0.200
     1.192     6.978     0.200
     1.209     7.019     0.200
     1.252     8.595     0.200
     1.270     8.592     0.200
     1.271     7.245     0.200
     1.268     8.402     0.200
     1.336     8.080     0.200
     1.464     8.525     0.200
     1.598     9.675     0.200
     1.884    10.799     0.200
     2.211    12.911     0.200
     0.207     1.965     0.200
     0.376     2.946     0.200
     0.472     3.637     0.200
     0.535     4.195     0.200
     0.519     3.596     0.200
     0.534     3.646     0.200
     0.534     3.856     0.200
     0.660     4.081     0.200
     0.660     4.480     0.200
     0.755     4.854     0.200
     0.757     5.190     0.200
     0.799     5.470     0.200
     0.833     5.165     0.200
     0.812     5.337     0.200
     0.812     5.177     0.200
     0.812     5.399     0.200
     0.819     5.182     0.200
     0.862     5.876     0.200
     0.888     5.962     0.200
     0.943     5.590     0.200
     0.956     5.895     0.200
     0.956     5.755     0.200
     0.962     6.315     0.200
     0.971     6.492     0.200
     0.962     7.153     0.200
     0.971     7.634     0.200
     0.977     6.591     0.200
     1.028     6.388     0.200
     1.038     6.557     0.200
     1.042     7.137     0.200
     1.050     7.686     0.200
     1.073     6.867     0.200
     1.131     6.812     0.200
     1.124     7.657     0.200
     1.148     8.550     0.200
     1.212     7.035     0.200
     1.267     9.167     0.200
     1.284     7.518     0.200
     1.296     7.989     0.200
     1.287     9.182     0.200
     1.336     7.669     0.200
     1.336     7.799     0.200
     1.336     7.860     0.200
     1.345     8.014     0.200
     1.312     7.988     0.200
     1.346     9.011     0.200
     2.705    15.106     0.200
     0.228     2.405     0.200
     0.402     3.055     0.200
     0.459     3.304     0.200
     0.643     4.864     0.200
     0.665     5.201     0.200
     0.683     4.876     0.200
     0.768     5.253     0.200
     0.789     5.305     0.200
     0.850     5.976     0.200
     0.906     6.335     0.200
     0.936     6.386     0.200
     0.943     5.877     0.200
     0.943     6.971     0.200
     1.002     6.397     0.200
     1.002     6.249     0.200
     1.030     6.775     0.200
     1.030     6.561     0.200
     1.030     6.532     0.200
     1.057     7.222     0.200
     1.057     7.089     0.200
     1.041     6.309     0.200
     1.059     6.920     0.200
     1.095     6.671     0.200
     1.139     8.129     0.200
     1.164     7.075     0.200
     1.223     7.463     0.200
     1.286     7.548     0.200
     1.319     7.393     0.200
     1.323     8.768     0.200
     1.371     8.740     0.200
     1.369     8.015     0.200
     1.380     8.994     0.200
     1.380     8.501     0.200
     0.200     2.509     0.200
     0.534     4.696     0.200
     0.662     4.527     0.200
     0.623     4.965     0.200
     1.082     7.421     0.200
     1.110     7.387     0.200
     1.348     7.333     0.200
     1.342     8.162     0.200
     1.437     7.667     0.200
     1.479     8.895     0.200
     1.505     8.900     0.200
     2.174    13.161     0.200
     4.487    26.977     0.200
     0.238     2.350     0.200
     0.391     3.171     0.200
     0.478     3.537     0.200
     0.483     3.895     0.200
     0.493     3.733     0.200
     0.535     4.271     0.200
     0.696     4.792     0.200
     0.769     5.589     0.200
     0.794     5.189     0.200
     0.843     5.903     0.200
     0.854     5.825     0.200
     0.854     5.795     0.200
     0.853     6.125     0.200
     0.874     5.618     0.200
     0.900     6.225     0.200
     0.912     7.068     0.200
     0.931     6.220     0.200
     0.955     6.535     0.200
     0.982     6.086     0.200
     0.974     6.305     0.200
     0.974     7.036     0.200
     0.998     6.165     0.200
     0.995     7.343     0.200
     1.002     7.203     0.200
     1.002     7.164     0.200
     1.002     8.113     0.200
     1.005     7.034     0.200
     1.065     6.729     0.200
     1.071     7.239     0.200
     1.085     7.511     0.200
     1.089     7.815     0.200
     1.097     8.383     0.200
     1.118     7.326     0.200
     1.141     8.761     0.200
     1.170     7.224     0.200
     1.165     7.704     0.200
     1.240     7.319     0.200
     1.253     7.380     0.200
     1.329     9.689     0.200
     1.327     7.820     0.200
     1.340     8.274     0.200
     1.342     7.844     0.200
     1.375     8.224     0.200
     1.375     8.099     0.200
     1.375     8.334     0.200
     1.386     8.290     0.200
     1.390     8.968     0.200
     1.503     7.939     0.200
     2.000    11.896     0.200
     2.545    15.470     0.200
     2.747    15.325     0.200
     0.210     2.163     0.200
     0.464     3.824     0.200
     0.494     3.608     0.200
     0.486     3.973     0.200
     0.570     4.061     0.200
     0.582     4.121     0.200
     0.665     4.585     0.200
     0.827     6.236     0.200
     0.894     7.007     0.200
     0.926     7.409     0.200
     0.977     6.497     0.200
     0.977     6.368     0.200
     0.992     6.411     0.200
     0.974     6.439     0.200
     1.012     6.615     0.200
     1.114     8.703     0.200
     1.130     7.333     0.200
     1.148     8.878     0.200
     1.157     7.410     0.200
     1.188     8.846     0.200
     1.206     8.025     0.200
     1.206     7.885     0.200
     1.208     8.121     0.200
     1.239     7.562     0.200
     1.294     8.099     0.200
     1.354     8.542     0.200
     1.475     9.115     0.200
     1.475     8.865     0.200
     1.476     9.098     0.200
     1.570     9.296     0.200
     0.079     2.817     0.200
     0.290     3.048     0.200
     0.333     3.462     0.200
     0.402     3.600     0.200
     0.428     3.842     0.200
     0.412     3.602     0.200
     0.492     3.890     0.200
     0.491     3.946     0.200
     0.602     4.128     0.200
     0.593     4.176     0.200
     0.683     4.519     0.200
     0.694     4.704     0.200
     0.694     4.595     0.200
     0.721     4.981     0.200
     0.766     5.352     0.200
     0.766     5.300     0.200
     0.783     5.019     0.200
     0.807     4.918     0.200
     0.839     5.492     0.200
     0.848     6.017     0.200
     0.862     5.565     0.200
     0.866     6.019     0.200
     0.866     5.769     0.200
     0.868     5.936     0.200
     0.938     6.926     0.200
     0.954     6.152     0.200
     0.955     7.009     0.200
     0.969     5.912     0.200
     0.978     6.636     0.200
     0.986     7.828     0.200
     0.987     7.732     0.200
     1.004     6.695     0.200
     1.019     7.326     0.200
     1.059     6.087     0.200
     1.080     7.025     0.200
     1.081     7.161     0.200
     1.084     7.260     0.200
     1.094     6.703     0.200
     1.109     7.276     0.200
     1.133     7.097     0.200
     1.173     6.890     0.200
     1.173     6.732     0.200
     0.132     1.540     0.200
     0.154     1.452     0.200
     0.211     1.899     0.200
     0.252     2.143     0.200
     0.434     3.528     0.200
     0.514     3.710     0.200
     0.514     3.890     0.200
     0.658     5.276     0.200
     0.666     5.705     0.200
     0.673     4.776     0.200
     0.719     5.220     0.200
     0.719     6.610     0.200
     0.729     5.221     0.200
     0.729     5.381     0.200
     0.737     6.389     0.200
     0.744     5.537     0.200
     0.746     4.937     0.200
     0.746     5.163     0.200
     0.765     6.460     0.200
     0.777     5.876     0.200
     0.785     5.426     0.200
     0.786     6.786     0.200
     0.797     6.778     0.200
     0.798     5.700     0.200
     0.807     6.910     0.200
     0.832     5.875     0.200
     0.853     6.660     0.200
     0.888     6.731     0.200
     0.905     6.758     0.200
     0.904     5.856     0.200
     0.906     6.680     0.200
     0.923     7.118     0.200
     0.944     7.365     0.200
     0.947     7.687     0.200
     0.946     6.070     0.200
     0.946     5.949     0.200
     0.987     7.028     0.200
     1.036     7.183     0.200
     1.085     7.020     0.200
     1.112     7.469     0.200
     1.117     7.349     0.200
     1.180     7.319     0.200
     1.216     8.074     0.200
     1.267     7.740     0.200
     1.317     7.931     0.200
     1.323     8.395     0.200
     1.327     7.975     0.200
     1.411     7.951     0.200
     1.456     8.443     0.200
     1.471     8.593     0.200
     0.148     1.696     0.200
     0.516     3.897     0.200
     0.669     5.633     0.200
     0.723     5.082     0.200
     0.723     6.570     0.200
     0.743     5.607     0.200
     0.721     5.421     0.200
     0.743     5.350     0.200
     0.787     6.743     0.200
     0.780     5.542     0.200
     0.807     6.810     0.200
     0.824     6.047     0.200
     0.824     5.765     0.200
     0.851     6.833     0.200
     0.881     7.222     0.200
     0.897     5.903     0.200
     0.910     6.505     0.200
     0.943     7.258     0.200
     0.948     7.549     0.200
     0.940     6.592     0.200
     0.984     7.141     0.200
     1.004     7.416     0.200
     1.014     7.937     0.200
     1.034     7.479     0.200
     1.057     6.882     0.200
     1.087     7.421     0.200
     1.070     6.947     0.200
     1.119     7.591     0.200
     1.107     7.642     0.200
     1.205     9.373     0.200
     1.208     8.346     0.200
     1.277     7.512     0.200
     1.261     7.925     0.200
     1.311     8.141     0.200
     1.343     8.927     0.200
     1.445     8.950     0.200
     1.464     9.051     0.200
     2.792    16.190     0.200
     0.146     1.525     0.200
     0.136     1.421     0.200
     0.425     3.360     0.200
     0.516     3.732     0.200
     0.507     3.903     0.200
     0.720     5.188     0.200
     0.658     4.949     0.200
     0.669     5.937     0.200
     0.790     5.642     0.200
     0.724     6.412     0.200
     0.742     5.057     0.200
     0.742     5.030     0.200
     0.743     5.393     0.200
     0.786     5.631     0.200
     0.743     6.502     0.200
     0.779     5.373     0.200
     0.823     5.846     0.200
     0.787     6.450     0.200
     0.807     6.618     0.200
     0.911     6.663     0.200
     0.895     5.772     0.200
     0.851     6.417     0.200
     0.882     7.020     0.200
     0.938     5.780     0.200
     0.938     5.929     0.200
     0.942     7.083     0.200
     0.948     7.408     0.200
     0.984     6.969     0.200
     1.014     7.829     0.200
     1.068     6.743     0.200
     1.106     7.526     0.200
     1.172     7.734     0.200
     1.207     8.384     0.200
     1.207     7.794     0.200
     1.259     7.875     0.200
     1.259     7.575     0.200
     1.314     8.207     0.200
     1.342     8.882     0.200
     1.332     9.932     0.200
     1.463     8.537     0.200
     1.414     7.902     0.200
     2.233    12.935     0.200
     0.261     2.148     0.200
     0.401     3.042     0.200
     0.433     3.441     0.200
     0.424     3.244     0.200
     0.530     4.196     0.200
     0.590     4.932     0.200
     0.672     6.111     0.200
     0.663     6.094     0.200
     0.696     6.046     0.200
     0.696     6.156     0.200
     0.736     5.382     0.200
     0.714     6.464     0.200
     0.755     5.615     0.200
     0.855     7.243     0.200
     0.878     5.998     0.200
     0.889     6.906     0.200
     0.945     6.577     0.200
     0.919     6.236     0.200
     0.919     6.263     0.200
     0.930     7.302     0.200
     0.996     6.761     0.200
     0.986     6.584     0.200
     0.988     7.255     0.200
     1.027     7.916     0.200
     1.079     7.184     0.200
     1.079     7.334     0.200
     1.077     7.667     0.200
     1.150     7.144     0.200
     1.158     8.171     0.200
     1.188     7.655     0.200
     1.142     8.727     0.200
     1.230     7.712     0.200
     2.440    13.956     0.200
     0.139     1.509     0.200
     0.157     1.740     0.200
     0.507     3.961     0.200
     0.665     4.620     0.200
     0.672     5.763     0.200
     0.726     6.621     0.200
     0.726     5.472     0.200
     0.742     6.456     0.200
     0.751     5.544     0.200
     0.752     4.974     0.200
     0.775     5.769     0.200
     0.790     5.561     0.200
     0.793     5.653     0.200
     0.794     5.974     0.200
     0.814     6.792     0.200
     0.833     5.522     0.200
     0.833     6.101     0.200
     0.860     6.597     0.200
     0.887     7.198     0.200
     0.905     5.953     0.200
     0.901     6.748     0.200
     0.951     7.343     0.200
     0.949     5.925     0.200
     0.954     7.552     0.200
     0.993     7.146     0.200
     1.010     7.549     0.200
     1.021     8.150     0.200
     1.067     6.964     0.200
     1.079     6.880     0.200
     1.091     7.289     0.200
     1.117     7.679     0.200
     1.182     7.653     0.200
     1.182     7.243     0.200
     1.217     8.230     0.200
     1.270     7.861     0.200
     1.281     7.417     0.200
     1.320     8.122     0.200
     1.323     8.221     0.200
     1.320     8.111     0.200
     1.343     9.031     0.200
     1.353     8.965     0.200
     1.454     8.839     0.200
     1.474     8.393     0.200
     1.474     8.782     0.200
     3.044    17.902     0.200
     0.142     1.679     0.200
     0.131     1.630     0.200
     0.523     3.798     0.200
     0.503     4.133     0.200
     0.651     4.939     0.200
     0.664     5.769     0.200
     0.735     5.227     0.200
     0.735     5.277     0.200
     0.736     5.552     0.200
     0.792     5.807     0.200
     0.739     6.850     0.200
     0.773     5.699     0.200
     0.781     6.615     0.200
     0.820     6.018     0.200
     0.801     6.825     0.200
     0.844     6.555     0.200
     0.891     5.925     0.200
     0.875     6.981     0.200
     0.918     6.617     0.200
     0.889     6.902     0.200
     0.934     6.299     0.200
     0.934     6.100     0.200
     0.935     7.293     0.200
     0.941     7.693     0.200
     0.977     7.159     0.200
     0.997     7.534     0.200
     1.007     7.969     0.200
     1.027     7.707     0.200
     1.051     6.724     0.200
     1.064     6.849     0.200
     1.100     7.753     0.200
     1.168     7.525     0.200
     1.204     8.338     0.200
     1.255     7.851     0.200
     1.336     7.934     0.200
     0.103     2.178     0.200
     0.337     3.018     0.200
     0.740     4.905     0.200
     0.700     5.381     0.200
     0.724     5.114     0.200
     0.724     5.317     0.200
     0.955     5.550     0.200
     0.965     6.420     0.200
     0.905     6.203     0.200
     0.983     6.474     0.200
     0.983     6.623     0.200
     1.055     9.002     0.200
     1.073     7.182     0.200
     1.134     7.073     0.200
     1.134     7.331     0.200
     1.163     7.465     0.200
     1.184     9.823     0.200
     1.184     7.777     0.200
     1.233     7.528     0.200
     1.288     7.882     0.200
     1.276     8.456     0.200
     1.294     7.691     0.200
     1.307     9.908     0.200
     1.319    10.143     0.200
     1.327     8.034     0.200
     1.340     7.875     0.200
     1.343     9.498     0.200
     1.343     9.690     0.200
     1.349     8.139     0.200
     1.349     8.185     0.200
     1.341     7.658     0.200
     1.342     8.166     0.200
     1.348    10.108     0.200
     1.348    10.655     0.200
     1.389     8.361     0.200
     1.381     8.739     0.200
     1.370    10.489     0.200
     1.449     8.398     0.200
     0.383     3.297     0.200
     0.336     2.998     0.200
     0.459     3.983     0.200
     0.487     4.210     0.200
     0.453     3.349     0.200
     0.477     3.729     0.200
     0.735     4.923     0.200
     0.840     5.249     0.200
     0.840     5.359     0.200
     0.849     5.891     0.200
     0.892     5.714     0.200
     0.892     5.825     0.200
     0.932     5.634     0.200
     0.931     6.366     0.200
     0.948     6.244     0.200
     0.948     6.316     0.200
     0.951     6.821     0.200
     0.972     6.421     0.200
     0.998     6.754     0.200
     1.031     6.245     0.200
     1.004     6.838     0.200
     1.006     6.804     0.200
     1.056     6.180     0.200
     1.099     6.834     0.200
     1.064     7.282     0.200
     1.064     6.242     0.200
     1.105     6.252     0.200
     1.086     6.473     0.200
     1.086     7.013     0.200
     1.099     7.757     0.200
     1.092     8.523     0.200
     1.103     8.390     0.200
     1.177     7.908     0.200
     1.186     8.438     0.200
     1.215     7.175     0.200
     1.239     8.416     0.200
     1.237     7.333     0.200
     1.260     8.320     0.200
     1.308     7.339     0.200
     1.283     9.004     0.200
     1.293     8.163     0.200
     1.339     8.197     0.200
     1.419     8.011     0.200
     1.410     8.118     0.200
     2.073    11.791     0.200
     2.378    14.132     0.200
     0.283     3.107     0.200
     0.391     3.612     0.200
     0.450     3.957     0.200
     0.461     4.149     0.200
     0.486     3.684     0.200
     0.564     3.962     0.200
     0.564     4.080     0.200
     0.622     4.588     0.200
     0.724     5.078     0.200
     0.815     5.694     0.200
     0.815     5.429     0.200
     0.826     6.263     0.200
     0.854     6.297     0.200
     0.916     7.080     0.200
     0.915     6.021     0.200
     0.939     6.008     0.200
     0.966     7.050     0.200
     0.990     7.159     0.200
     1.003     6.547     0.200
     0.991     6.444     0.200
     0.992     6.401     0.200
     1.033     6.772     0.200
     1.033     7.616     0.200
     1.046     7.181     0.200
     1.076     7.946     0.200
     1.099     8.641     0.200
     1.101     6.914     0.200
     1.192     7.141     0.200
     1.305     7.698     0.200
     1.324     7.734     0.200
     1.545     8.970     0.200
     3.419    20.669     0.200
     0.503     4.202     0.200
     0.551     4.109     0.200
     0.491     4.321     0.200
     0.567     4.374     0.200
     0.689     5.361     0.200
     0.852     6.797     0.200
     0.865     6.880     0.200
     0.865     7.251     0.200
     0.874     6.881     0.200
     0.956     6.665     0.200
     0.968     6.524     0.200
     0.919     7.010     0.200
     0.954     6.427     0.200
     0.947     7.130     0.200
     0.967     7.015     0.200
     1.026     7.342     0.200
     1.045     7.356     0.200
     1.079     7.432     0.200
     1.130     7.996     0.200
     1.130     7.758     0.200
     1.141     7.706     0.200
     1.164     7.915     0.200
     1.164     7.965     0.200
     1.163     9.124     0.200
     1.194     8.067     0.200
     1.211     8.460     0.200
     1.250     8.266     0.200
     1.284     8.404     0.200
     1.302     8.715     0.200
     1.347     8.713     0.200
     1.559     9.720     0.200
     1.573     9.636     0.200
     0.495     4.178     0.200
     0.493     4.147     0.200
     0.559     4.429     0.200
     0.552     4.063     0.200
     0.682     5.446     0.200
     0.846     6.789     0.200
     0.860     7.060     0.200
     0.860     7.240     0.200
     0.871     6.972     0.200
     0.871     7.582     0.200
     0.914     7.199     0.200
     0.951     6.560     0.200
     1.019     7.253     0.200
     0.964     6.477     0.200
     1.038     7.474     0.200
     1.074     7.401     0.200
     0.961     6.257     0.200
     1.123     7.997     0.200
     1.123     8.357     0.200
     1.133     7.611     0.200
     1.156     9.326     0.200
     1.156     7.911     0.200
     1.156     7.915     0.200
     1.176     8.002     0.200
     1.203     8.506     0.200
     1.187     8.324     0.200
     1.187     8.074     0.200
     1.243     8.250     0.200
     1.294     8.495     0.200
     1.277     8.430     0.200
     1.335     8.158     0.200
     1.340     8.943     0.200
     1.410     8.272     0.200
     1.552     9.812     0.200
     0.542     4.058     0.200
     0.504     4.056     0.200
     0.499     4.105     0.200
     0.564     4.361     0.200
     0.694     5.140     0.200
     0.872     7.374     0.200
     0.882     7.547     0.200
     0.948     6.354     0.200
     0.950     6.226     0.200
     0.960     6.403     0.200
     0.925     7.805     0.200
     1.029     6.558     0.200
     1.086     8.495     0.200
     1.134     8.686     0.200
     1.142     7.726     0.200
     1.164     7.587     0.200
     1.164     7.774     0.200
     1.189     7.921     0.200
     1.210     8.329     0.200
     1.210     9.193     0.200
     1.252     9.087     0.200
     1.279     8.315     0.200
     1.343     8.377     0.200
     1.465     9.130     0.200
     0.174     1.922     0.200
     0.501     3.972     0.200
     0.499     3.889     0.200
     0.544     4.020     0.200
     0.562     4.339     0.200
     0.691     4.970     0.200
     0.922     7.334     0.200
     0.953     6.173     0.200
     0.960     6.380     0.200
     0.969     7.641     0.200
     1.139     8.522     0.200
     1.161     8.064     0.200
     1.188     7.978     0.200
     1.188     8.208     0.200
     1.207     8.248     0.200
     1.462     9.379     0.200
     1.463     9.346     0.200
     0.164     1.929     0.200
     0.496     3.945     0.200
     0.519     3.760     0.200
     0.540     3.868     0.200
     0.579     4.053     0.200
     0.707     4.824     0.200
     0.882     7.019     0.200
     0.888     7.404     0.200
     0.936     6.247     0.200
     0.937     8.050     0.200
     0.957     6.251     0.200
     0.957     6.071     0.200
     0.966     6.154     0.200
     0.965     7.078     0.200
     0.985     7.431     0.200
     1.148     8.956     0.200
     1.157     7.270     0.200
     1.179     7.481     0.200
     1.201     7.698     0.200
     1.225     8.061     0.200
     1.267     8.522     0.200
     1.292     8.129     0.200
     1.357     8.588     0.200
     1.358     9.188     0.200
     1.360     7.813     0.200
     1.376     9.212     0.200
     1.434     7.932     0.200
     1.456     7.956     0.200
     1.666     9.977     0.200
     2.496    13.784     0.200
     0.155     1.822     0.200
     0.506     3.865     0.200
     0.530     3.933     0.200
     0.519     3.867     0.200
     0.575     4.054     0.200
     0.712     4.915     0.200
     0.933     6.196     0.200
     0.890     7.320     0.200
     0.948     6.354     0.200
     0.948     6.127     0.200
     0.957     6.312     0.200
     0.969     7.356     0.200
     0.990     7.426     0.200
     1.045     7.114     0.200
     1.158     7.832     0.200
     1.178     8.021     0.200
     1.194     7.805     0.200
     1.268     9.443     0.200
     1.286     8.191     0.200
     1.352     8.671     0.200
     1.863    10.637     0.200
     1.890    10.982     0.200
     0.190     2.070     0.200
     0.484     3.785     0.200
     0.497     3.699     0.200
     0.560     4.046     0.200
     0.565     4.164     0.200
     0.680     4.752     0.200
     0.842     6.270     0.200
     0.855     6.871     0.200
     0.864     7.090     0.200
     0.910     6.926     0.200
     0.938     7.594     0.200
     0.960     6.338     0.200
     0.962     6.315     0.200
     0.974     6.641     0.200
     1.019     6.756     0.200
     1.070     6.848     0.200
     1.123     8.849     0.200
     1.135     7.110     0.200
     1.159     7.475     0.200
     1.195     7.859     0.200
     1.347     8.498     0.200
     0.237     2.325     0.200
     0.391     3.223     0.200
     0.395     3.219     0.200
     0.449     3.286     0.200
     0.689     4.946     0.200
     0.683     5.446     0.200
     0.749     5.285     0.200
     0.749     5.394     0.200
     0.771     5.386     0.200
     0.908     7.508     0.200
     0.985     6.602     0.200
     0.985     6.731     0.200
     1.022     6.889     0.200
     1.024     7.289     0.200
     1.048     7.093     0.200
     1.047     6.362     0.200
     1.148     7.308     0.200
     1.264     7.866     0.200
     1.270     7.799     0.200
     1.263     8.828     0.200
     0.174     1.702     0.200
     0.174     1.401     0.200
     0.365     2.734     0.200
     0.478     3.484     0.200
     0.496     3.588     0.200
     0.533     3.712     0.200
     0.523     4.091     0.200
     0.683     4.762     0.200
     0.733     5.150     0.200
     0.848     6.450     0.200
     0.870     6.796     0.200
     0.919     6.062     0.200
     0.919     6.242     0.200
     0.890     6.693     0.200
     0.890     7.243     0.200
     0.933     5.992     0.200
     0.917     7.501     0.200
     0.917     6.943     0.200
     0.968     6.390     0.200
     0.936     7.064     0.200
     0.936     7.393     0.200
     0.959     6.711     0.200
     1.038     7.186     0.200
     1.078     7.218     0.200
     1.118     7.323     0.200
     1.137     7.407     0.200
     1.137     7.473     0.200
     1.157     7.566     0.200
     1.157     7.379     0.200
     1.181     7.781     0.200
     1.176     9.199     0.200
     1.247     7.852     0.200
     1.285     9.391     0.200
     1.312     8.169     0.200
     2.999    15.682     0.200
     0.176     1.778     0.200
     0.495     3.876     0.200
     0.503     3.985     0.200
     0.547     3.931     0.200
     0.565     4.347     0.200
     0.691     5.039     0.200
     0.868     7.289     0.200
     0.953     6.247     0.200
     0.922     7.106     0.200
     0.952     6.241     0.200
     0.948     8.346     0.200
     0.969     6.317     0.200
     1.082     7.367     0.200
     1.141     8.498     0.200
     1.164     8.062     0.200
     1.191     8.112     0.200
     1.191     7.991     0.200
     1.210     8.296     0.200
     1.281     8.349     0.200
     1.570     9.726     0.200
     1.856    11.388     0.200
     0.247     2.449     0.200
     0.293     2.561     0.200
     0.282     2.694     0.200
     0.446     3.653     0.200
     0.473     3.937     0.200
     0.502     4.020     0.200
     0.624     4.776     0.200
     0.640     4.982     0.200
     0.782     5.681     0.200
     0.813     6.031     0.200
     0.893     5.930     0.200
     0.893     6.149     0.200
     0.993     6.473     0.200
     0.993     6.653     0.200
     0.978     7.504     0.200
     1.018     7.054     0.200
     1.024     7.252     0.200
     1.025     7.307     0.200
     1.042     7.718     0.200
     1.076     6.963     0.200
     1.096     7.261     0.200
     1.116     8.325     0.200
     1.164     8.254     0.200
     1.199     7.561     0.200
     1.263     7.570     0.200
     2.851    17.187     0.200
     0.172     2.000     0.200
     0.404     1.808     0.200
     0.492     4.123     0.200
     0.546     4.002     0.200
     0.512     3.905     0.200
     0.538     4.079     0.200
     0.642     4.738     0.200
     0.698     4.831     0.200
     0.774     5.660     0.200
     0.861     6.649     0.200
     0.874     7.122     0.200
     0.880     6.704     0.200
     0.880     6.815     0.200
     0.944     6.385     0.200
     0.957     6.383     0.200
     0.968     6.327     0.200
     0.928     7.884     0.200
     0.958     6.992     0.200
     0.976     6.996     0.200
     1.140     8.976     0.200
     1.150     7.429     0.200
     1.172     7.776     0.200
     1.199     7.779     0.200
     1.199     7.930     0.200
     1.219     8.234     0.200
     1.249     9.657     0.200
     1.289     8.183     0.200
     1.289     8.408     0.200
     1.309     8.792     0.200
     1.311     9.932     0.200
     1.353     8.733     0.200
     1.353     8.704     0.200
     1.349     8.760     0.200
     1.528     8.028     0.200
     1.994    11.428     0.200
     2.136    12.038     0.200
     0.148     2.290     0.200
     0.634     4.417     0.200
     0.806     5.164     0.200
     0.829     5.430     0.200
     1.018     6.553     0.200
     1.022     6.529     0.200
     1.294     8.355     0.200
     1.294     7.930     0.200
     1.294     8.122     0.200
     1.389     8.405     0.200
     0.164     2.051     0.200
     0.398     1.867     0.200
     0.504     4.016     0.200
     0.509     4.070     0.200
     0.536     4.056     0.200
     0.637     4.833     0.200
     0.701     5.121     0.200
     0.765     5.761     0.200
     0.880     7.418     0.200
     0.889     7.518     0.200
     0.943     6.265     0.200
     0.946     6.464     0.200
     0.957     6.422     0.200
     0.959     7.079     0.200
     0.979     6.953     0.200
     1.466     8.435     0.200
     2.341    13.753     0.200
     2.415    14.714     0.200
     2.435    14.549     0.200
     2.614    15.692     0.200
     2.731    16.421     0.200
     2.767    15.739     0.200
     0.286     2.844     0.200
     0.384     3.780     0.200
     0.520     3.696     0.200
     0.507     4.090     0.200
     0.526     4.137     0.200
     0.678     4.986     0.200
     0.786     5.428     0.200
     0.885     6.140     0.200
     0.917     6.341     0.200
     0.916     6.730     0.200
     0.926     6.076     0.200
     0.946     6.784     0.200
     0.978     6.468     0.200
     1.009     6.461     0.200
     1.008     7.411     0.200
     1.035     6.727     0.200
     1.047     7.108     0.200
     1.047     7.528     0.200
     1.044     7.126     0.200
     1.057     6.824     0.200
     1.058     7.959     0.200
     1.109     7.503     0.200
     1.107     7.348     0.200
     1.160     7.428     0.200
     1.199     7.298     0.200
     1.210     7.647     0.200
     1.259     7.707     0.200
     1.391     8.283     0.200
     1.458     9.077     0.200
     1.557     9.449     0.200
     0.198     1.883     0.200
     0.198     1.764     0.200
     0.503     4.006     0.200
     0.490     3.991     0.200
     0.521     3.977     0.200
     0.561     4.103     0.200
     0.666     5.022     0.200
     0.950     6.562     0.200
     0.950     6.152     0.200
     0.943     7.171     0.200
     0.965     6.471     0.200
     1.002     7.095     0.200
     1.117     7.965     0.200
     1.180     8.104     0.200
     1.180     8.354     0.200
     1.189     8.454     0.200
     1.269     8.528     0.200
     1.269     8.348     0.200
     1.451     9.238     0.200
     1.451     9.029     0.200
     1.559     9.434     0.200
     0.371     2.487     0.200
     0.396     2.830     0.200
     0.416     3.653     0.200
     0.563     4.555     0.200
     0.592     4.744     0.200
     0.816     5.912     0.200
     0.816     6.021     0.200
     0.915     6.452     0.200
     0.950     7.880     0.200
     0.953     7.209     0.200
     0.986     7.396     0.200
     0.997     6.743     0.200
     0.997     6.911     0.200
     1.019     7.171     0.200
     1.048     8.222     0.200
     1.094     8.254     0.200
     1.104     7.490     0.200
     1.121     7.500     0.200
     1.176     7.836     0.200
     1.187     8.856     0.200
     1.185     7.605     0.200
     1.189     8.837     0.200
     1.261     8.870     0.200
     1.276     9.224     0.200
     1.291     8.596     0.200
     1.307     8.582     0.200
     1.509     9.294     0.200
     0.172     2.155     0.200
     0.451     3.676     0.200
     0.479     3.809     0.200
     0.531     3.917     0.200
     0.560     4.015     0.200
     0.554     3.992     0.200
     0.709     4.950     0.200
     0.976     6.101     0.200
     0.976     6.327     0.200
     0.985     6.300     0.200
     1.169     6.986     0.200
     1.220     7.707     0.200
     1.375     8.685     0.200
     1.369     8.859     0.200
     1.363     9.748     0.200
     1.385     8.106     0.200
     1.468     9.527     0.200
     1.558     9.306     0.200
     3.695    19.118     0.200
     0.249     2.243     0.200
     0.383     3.376     0.200
     0.421     3.502     0.200
     0.715     6.330     0.200
     0.716     6.298     0.200
     0.760     5.535     0.200
     0.780     6.761     0.200
     0.823     6.620     0.200
     0.875     7.312     0.200
     0.875     7.421     0.200
     0.989     6.503     0.200
     0.957     7.526     0.200
     0.962     7.257     0.200
     1.027     7.684     0.200
     1.137     8.407     0.200
     1.200     8.045     0.200
     1.200     8.146     0.200
     1.215     7.901     0.200
     1.287     8.907     0.200
     0.165     1.948     0.200
     0.469     3.926     0.200
     0.497     3.920     0.200
     0.516     3.933     0.200
     0.538     3.978     0.200
     0.705     4.991     0.200
     0.939     6.279     0.200
     0.955     6.213     0.200
     0.955     6.463     0.200
     0.964     6.457     0.200
     0.935     7.801     0.200
     0.964     7.616     0.200
     0.982     7.647     0.200
     1.176     7.820     0.200
     1.535     8.020     0.200
     0.273     2.586     0.200
     0.272     2.831     0.200
     0.471     3.786     0.200
     0.634     5.033     0.200
     0.634     4.732     0.200
     0.644     5.186     0.200
     0.711     5.356     0.200
     0.802     5.771     0.200
     0.810     6.157     0.200
     0.914     6.131     0.200
     0.914     6.301     0.200
     0.967     6.786     0.200
     1.015     6.577     0.200
     1.025     6.787     0.200
     1.002     7.418     0.200
     1.052     7.377     0.200
     1.046     7.128     0.200
     1.046     6.859     0.200
     1.048     7.253     0.200
     1.099     7.252     0.200
     1.096     7.607     0.200
     1.122     7.373     0.200
     1.144     8.309     0.200
     1.205     7.729     0.200
     1.192     8.376     0.200
     1.223     7.501     0.200
     1.223     7.751     0.200
     1.278     7.864     0.200
     1.283     9.090     0.200
     1.410     8.946     0.200
     1.444     9.191     0.200
     1.478     8.927     0.200
     0.418     4.116     0.200
     0.422     3.629     0.200
     0.572     4.371     0.200
     0.616     4.717     0.200
     0.714     5.057     0.200
     0.791     5.931     0.200
     0.798     5.255     0.200
     0.798     5.396     0.200
     0.803     6.076     0.200
     0.807     5.795     0.200
     0.814     5.839     0.200
     0.825     5.610     0.200
     0.875     6.454     0.200
     0.896     6.892     0.200
     0.904     5.953     0.200
     0.922     5.991     0.200
     0.924     7.586     0.200
     0.933     6.868     0.200
     0.976     6.263     0.200
     0.985     6.619     0.200
     0.990     6.675     0.200
     0.991     6.485     0.200
     1.011     6.979     0.200
     1.011     6.858     0.200
     1.031     6.803     0.200
     1.039     7.542     0.200
     1.058     7.936     0.200
     1.191     7.378     0.200
     1.233     8.024     0.200
     1.303     7.730     0.200
     1.310     7.749     0.200
     1.312     7.984     0.200
     0.250     2.444     0.200
     0.420     3.647     0.200
     0.382     3.522     0.200
     0.634     4.848     0.200
     0.681     5.145     0.200
     0.774     5.552     0.200
     0.717     6.596     0.200
     0.760     5.674     0.200
     0.781     6.979     0.200
     0.824     6.483     0.200
     0.963     7.519     0.200
     1.028     7.954     0.200
     1.199     8.246     0.200
     1.199     7.996     0.200
     1.214     8.142     0.200
     1.235     7.917     0.200
     1.359     9.045     0.200
     3.049    18.099     0.200
     0.183     1.956     0.200
     0.466     3.304     0.200
     0.453     3.188     0.200
     0.519     3.831     0.200
     0.539     4.351     0.200
     0.547     4.096     0.200
     0.838     6.124     0.200
     0.891     6.333     0.200
     0.946     6.644     0.200
     0.988     6.608     0.200
     0.985     6.777     0.200
     1.069     6.957     0.200
     1.093     7.360     0.200
     1.109     7.119     0.200
     1.126     7.562     0.200
     1.151     7.519     0.200
     1.216     7.679     0.200
     1.238     8.102     0.200
     1.280     7.926     0.200
     1.281     8.044     0.200
     1.400     8.541     0.200
     1.402     8.460     0.200
     0.237     2.589     0.200
     0.301     2.727     0.200
     0.411     3.492     0.200
     0.396     3.307     0.200
     0.650     4.807     0.200
     0.675     4.937     0.200
     0.736     5.200     0.200
     0.729     5.317     0.200
     0.781     5.885     0.200
     0.895     5.859     0.200
     0.895     6.199     0.200
     0.927     6.463     0.200
     0.991     6.218     0.200
     0.982     6.457     0.200
     0.995     6.704     0.200
     0.973     7.903     0.200
     0.973     5.803     0.200
     0.971     6.515     0.200
     0.972     6.584     0.200
     1.000     6.866     0.200
     1.084     6.524     0.200
     1.050     6.974     0.200
     1.067     6.637     0.200
     1.082     6.846     0.200
     1.053     8.099     0.200
     1.058     6.377     0.200
     1.084     7.739     0.200
     1.134     7.556     0.200
     1.179     7.093     0.200
     1.190     7.130     0.200
     1.247     7.442     0.200
     1.221     7.849     0.200
     1.269     7.709     0.200
     1.263     7.657     0.200
     1.269     7.221     0.200
     1.269     7.779     0.200
     1.276     9.217     0.200
     1.292     8.970     0.200
     1.325     8.628     0.200
     1.370     8.148     0.200
     1.402     8.552     0.200
     1.446     8.327     0.200
     1.466     8.785     0.200
     1.520     9.167     0.200
     1.572     9.130     0.200
     1.630     9.705     0.200
     1.645     9.538     0.200
     1.715     9.711     0.200
     1.858    10.078     0.200
     1.983    11.829     0.200
     1.991    11.480     0.200
     2.098    11.901     0.200
     2.106    12.387     0.200
     2.209    12.935     0.200
     2.204    12.280     0.200
     2.309    13.317     0.200
     2.451    12.720     0.200
     0.279     2.199     0.200
     0.544     4.137     0.200
     0.569     4.493     0.200
     1.007     7.148     0.200
     1.016     7.055     0.200
     1.104     7.231     0.200
     1.181     8.112     0.200
     1.180     8.318     0.200
     1.579     9.791     0.200
     2.822    17.026     0.200
     0.195     1.925     0.200
     0.195     2.065     0.200
     0.443     3.571     0.200
     0.464     3.591     0.200
     0.529     4.002     0.200
     0.547     4.455     0.200
     0.542     4.333     0.200
     0.661     4.708     0.200
     0.826     6.484     0.200
     0.855     7.314     0.200
     0.894     6.152     0.200
     0.894     6.262     0.200
     0.912     6.322     0.200
     0.886     7.474     0.200
     0.886     6.621     0.200
     0.897     7.319     0.200
     0.897     6.431     0.200
     0.909     6.421     0.200
     0.910     7.437     0.200
     0.934     7.073     0.200
     0.974     6.759     0.200
     0.999     6.739     0.200
     1.083     7.615     0.200
     1.083     8.708     0.200
     1.083     7.358     0.200
     1.101     7.360     0.200
     1.124     7.694     0.200
     1.144     7.896     0.200
     1.213     7.960     0.200
     1.397     8.499     0.200
     1.489     9.034     0.200
     1.503     8.878     0.200
     1.514     8.188     0.200
     1.583     9.076     0.200
     0.193     1.524     0.200
     0.193     1.943     0.200
     0.447     3.474     0.200
     0.469     3.536     0.200
     0.531     3.913     0.200
     0.542     4.492     0.200
     0.537     4.368     0.200
     0.662     4.721     0.200
     0.827     6.480     0.200
     0.855     6.773     0.200
     0.899     6.001     0.200
     0.899     6.331     0.200
     0.884     6.811     0.200
     0.884     6.200     0.200
     0.897     7.039     0.200
     0.897     6.437     0.200
     0.916     6.215     0.200
     0.911     6.544     0.200
     0.912     7.140     0.200
     0.936     7.112     0.200
     0.977     7.149     0.200
     0.996     6.744     0.200
     1.058     7.313     0.200
     1.087     7.548     0.200
     1.086     7.811     0.200
     1.086     7.382     0.200
     1.105     7.268     0.200
     1.105     7.498     0.200
     1.129     7.688     0.200
     1.129     7.577     0.200
     1.148     7.879     0.200
     1.152     7.588     0.200
     1.218     7.986     0.200
     1.256     8.251     0.200
     1.281     8.228     0.200
     1.312     8.178     0.200
     1.385     8.236     0.200
     1.402     8.294     0.200
     1.508     8.642     0.200
     1.513     8.121     0.200
     1.592     9.692     0.200
     1.793    10.622     0.200
     0.209     2.014     0.200
     0.432     3.859     0.200
     0.535     4.366     0.200
     0.555     4.466     0.200
     0.542     4.049     0.200
     0.646     5.106     0.200
     0.812     6.372     0.200
     0.841     7.672     0.200
     0.873     6.283     0.200
     0.882     6.519     0.200
     0.895     6.604     0.200
     0.896     7.458     0.200
     0.920     7.047     0.200
     0.898     6.719     0.200
     0.898     6.231     0.200
     0.918     6.348     0.200
     0.962     6.891     0.200
     1.012     6.744     0.200
     1.043     7.693     0.200
     1.070     6.909     0.200
     1.072     7.995     0.200
     1.091     7.793     0.200
     1.136     7.725     0.200
     1.136     8.270     0.200
     1.122     8.066     0.200
     1.122     7.946     0.200
     1.211     8.304     0.200
     1.241     8.178     0.200
     1.296     8.484     0.200
     1.273     8.814     0.200
     1.273     8.413     0.200
     1.370     8.610     0.200
     1.393     9.192     0.200
     1.393     9.003     0.200
     1.394     9.249     0.200
     1.455     9.532     0.200
     1.487     9.744     0.200
     1.487     9.535     0.200
     1.502     9.693     0.200
     1.528    10.846     0.200
     1.584    10.036     0.200
     0.201     1.824     0.200
     0.431     3.599     0.200
     0.449     3.414     0.200
     0.525     3.815     0.200
     0.554     4.388     0.200
     0.562     4.445     0.200
     0.655     4.870     0.200
     0.880     6.334     0.200
     0.880     5.983     0.200
     0.900     6.015     0.200
     1.009     6.626     0.200
     1.071     8.193     0.200
     1.087     7.677     0.200
     1.108     7.929     0.200
     1.129     8.120     0.200
     1.197     8.177     0.200
     1.381     9.113     0.200
     1.382     9.166     0.200
     1.571    10.025     0.200
     1.642     9.547     0.200
     0.193     2.050     0.200
     0.528     3.951     0.200
     0.463     3.522     0.200
     0.444     3.489     0.200
     0.547     4.497     0.200
     0.543     4.388     0.200
     0.893     5.948     0.200
     0.893     6.258     0.200
     0.911     6.221     0.200
     0.998     6.698     0.200
     0.857     7.351     0.200
     0.911     7.547     0.200
     0.888     7.658     0.200
     0.935     7.482     0.200
     1.123     7.654     0.200
     1.123     7.524     0.200
     1.084     7.522     0.200
     1.101     7.451     0.200
     1.144     7.818     0.200
     1.212     7.980     0.200
     1.276     8.400     0.200
     1.276     8.752     0.200
     1.284     9.510     0.200
     1.338     9.841     0.200
     1.382     9.611     0.200
     1.458     9.160     0.200
     1.502     8.339     0.200
     1.379    10.429     0.200
     1.485    10.177     0.200
     1.586     9.996     0.200
     1.562    10.080     0.200
     1.587    10.496     0.200
     1.515     8.315     0.200
     2.138    12.378     0.200
     0.243     2.312     0.200
     0.244     2.312     0.200
     0.387     3.299     0.200
     0.407     3.640     0.200
     0.651     4.576     0.200
     0.651     4.795     0.200
     0.696     4.858     0.200
     0.723     6.001     0.200
     0.779     5.208     0.200
     0.792     6.761     0.200
     0.838     6.082     0.200
     0.890     7.371     0.200
     0.977     6.589     0.200
     0.973     7.918     0.200
     0.979     7.262     0.200
     1.225     7.801     0.200
     0.288     2.737     0.200
     0.365     2.871     0.200
     0.366     2.872     0.200
     0.533     4.105     0.200
     0.633     4.841     0.200
     0.672     4.921     0.200
     0.644     4.639     0.200
     0.800     6.502     0.200
     0.861     7.681     0.200
     0.918     7.460     0.200
     0.925     8.069     0.200
     0.992     6.544     0.200
     1.027     7.786     0.200
     1.089     7.531     0.200
     1.155     8.309     0.200
     1.257     8.610     0.200
     1.288     8.898     0.200
     1.372     8.975     0.200
     1.416     9.386     0.200
     1.426     9.171     0.200
     1.545     9.721     0.200
     1.601    10.680     0.200
     1.609    10.165     0.200
     0.182     1.829     0.200
     0.468     3.516     0.200
     0.490     3.549     0.200
     0.533     3.819     0.200
     0.520     4.307     0.200
     0.524     4.184     0.200
     0.674     4.848     0.200
     0.862     7.223     0.200
     0.885     6.879     0.200
     0.909     7.433     0.200
     0.931     6.155     0.200
     0.927     7.263     0.200
     0.950     7.882     0.200
     0.978     6.547     0.200
     0.996     7.099     0.200
     1.019     7.420     0.200
     1.069     7.349     0.200
     1.104     7.694     0.200
     1.107     7.554     0.200
     1.150     7.718     0.200
     1.171     7.963     0.200
     1.222     9.214     0.200
     1.223     7.850     0.200
     1.240     8.010     0.200
     1.242     8.851     0.200
     1.260     9.585     0.200
     1.303     8.214     0.200
     1.303     8.425     0.200
     1.302     8.919     0.200
     1.326     8.083     0.200
     1.360    10.080     0.200
     1.368     9.377     0.200
     1.396     8.232     0.200
     1.541     8.303     0.200
     2.086    11.946     0.200
     2.166    12.570     0.200
     2.299    13.084     0.200
     3.161    17.468     0.200
     0.186     1.917     0.200
     0.186     1.815     0.200
     0.462     3.632     0.200
     0.484     3.511     0.200
     0.533     3.894     0.200
     0.527     4.290     0.200
     0.528     4.270     0.200
     0.927     6.215     0.200
     0.923     7.253     0.200
     0.945     7.950     0.200
     0.984     6.647     0.200
     0.991     7.011     0.200
     1.101     7.970     0.200
     1.120     7.441     0.200
     1.144     7.760     0.200
     1.144     7.490     0.200
     1.164     7.925     0.200
     1.234     8.045     0.200
     1.418     8.628     0.200
     1.523     8.888     0.200
     0.286     2.687     0.200
     0.287     2.679     0.200
     0.345     3.059     0.200
     0.383     3.214     0.200
     0.645     4.821     0.200
     0.645     4.720     0.200
     0.737     5.090     0.200
     0.714     5.283     0.200
     0.822     7.211     0.200
     0.945     6.075     0.200
     0.915     7.585     0.200
     0.995     7.805     0.200
     0.167     1.810     0.200
     0.475     3.829     0.200
     0.498     3.958     0.200
     0.499     3.950     0.200
     0.510     4.112     0.200
     0.540     3.971     0.200
     0.700     5.164     0.200
     0.863     6.408     0.200
     0.863     6.768     0.200
     0.944     6.220     0.200
     0.962     6.653     0.200
     0.962     6.383     0.200
     0.978     6.733     0.200
     1.170     8.179     0.200
     1.193     7.890     0.200
     1.193     8.400     0.200
     1.193     8.150     0.200
     1.216     8.477     0.200
     1.284     8.322     0.200
     1.349     9.160     0.200
     1.470     9.551     0.200
     1.531     9.698     0.200
     0.346     2.778     0.200
     0.561     4.067     0.200
     0.561     3.805     0.200
     0.562     3.825     0.200
     0.560     4.391     0.200
     0.644     4.740     0.200
     0.728     5.284     0.200
     0.734     4.864     0.200
     0.759     5.374     0.200
     0.769     5.190     0.200
     0.794     5.467     0.200
     0.818     5.705     0.200
     0.806     5.194     0.200
     0.822     5.394     0.200
     0.916     5.592     0.200
     0.920     5.845     0.200
     0.929     5.579     0.200
     0.979     6.441     0.200
     0.987     6.186     0.200
     1.110     6.765     0.200
     1.185     7.065     0.200
     1.263     7.361     0.200
     0.320     2.786     0.200
     0.322     2.599     0.200
     0.325     3.075     0.200
     0.693     5.196     0.200
     0.713     5.061     0.200
     0.771     5.690     0.200
     0.777     5.615     0.200
     0.882     5.778     0.200
     1.056     7.435     0.200
     1.189     7.767     0.200
     1.354     9.087     0.200
     0.321     2.801     0.200
     0.315     2.667     0.200
     0.316     2.648     0.200
     0.332     3.049     0.200
     0.719     5.046     0.200
     0.696     5.114     0.200
     0.885     5.841     0.200
     0.815     6.813     0.200
     0.777     5.499     0.200
     0.776     5.617     0.200
     0.883     7.791     0.200
     0.923     6.780     0.200
     0.977     8.300     0.200
     1.056     7.484     0.200
     1.056     8.914     0.200
     1.195     7.804     0.200
     1.506     7.689     0.200
     0.293     2.512     0.200
     0.293     2.504     0.200
     0.339     3.179     0.200
     0.381     3.159     0.200
     0.644     4.873     0.200
     0.716     5.287     0.200
     0.730     5.198     0.200
     0.745     5.577     0.200
     0.767     6.521     0.200
     0.863     6.431     0.200
     0.918     7.198     0.200
     0.941     6.180     0.200
     0.995     8.439     0.200
     0.995     7.959     0.200
     0.997     6.961     0.200
     1.123     7.825     0.200
     1.184     7.839     0.200
     1.401     9.680     0.200
     1.425     9.839     0.200
     1.453     7.896     0.200
     1.487     9.371     0.200
     1.542     9.580     0.200
     1.800    10.907     0.200
     3.646    22.644     0.200
     3.902    22.652     0.200
     0.178     1.893     0.200
     0.442     3.749     0.200
     0.468     3.682     0.200
     0.469     3.623     0.200
     0.540     3.875     0.200
     0.572     3.989     0.200
     0.562     4.070     0.200
     0.562     3.851     0.200
     0.712     4.837     0.200
     0.873     6.491     0.200
     0.875     6.598     0.200
     0.879     7.134     0.200
     0.939     7.237     0.200
     0.926     6.412     0.200
     0.926     6.302     0.200
     0.997     6.664     0.200
     0.997     6.523     0.200
     1.060     7.305     0.200
     1.202     8.011     0.200
     1.202     7.871     0.200
     1.232     8.052     0.200
     1.250     8.299     0.200
     1.323     8.316     0.200
     1.530     8.231     0.200
     0.184     1.783     0.200
     0.469     3.684     0.200
     0.470     3.668     0.200
     0.456     3.522     0.200
     0.456     3.682     0.200
     0.526     4.062     0.200
     0.562     4.138     0.200
     0.565     4.098     0.200
     0.699     5.060     0.200
     0.861     6.672     0.200
     0.868     6.849     0.200
     0.868     7.091     0.200
     0.927     7.363     0.200
     0.978     7.201     0.200
     0.978     7.443     0.200
     0.939     6.247     0.200
     1.044     7.339     0.200
     1.046     7.160     0.200
     0.993     6.546     0.200
     1.086     7.410     0.200
     1.148     8.233     0.200
     1.163     7.621     0.200
     1.188     8.204     0.200
     1.237     8.507     0.200
     1.222     8.114     0.200
     1.312     8.475     0.200
     1.377    10.281     0.200
     1.376     8.736     0.200
     1.520     8.556     0.200
     1.497     9.351     0.200
     1.588     9.588     0.200
     1.686    10.219     0.200
     0.181     1.906     0.200
     0.452     3.691     0.200
     0.471     3.669     0.200
     0.530     3.930     0.200
     0.563     4.121     0.200
     0.564     4.027     0.200
     0.935     6.043     0.200
     0.935     6.266     0.200
     0.993     6.757     0.200
     1.191     8.194     0.200
     1.224     8.151     0.200
     1.224     8.354     0.200
     1.314     8.642     0.200
     0.183     1.781     0.200
     0.450     3.740     0.200
     0.467     3.523     0.200
     0.468     3.468     0.200
     0.532     3.949     0.200
     0.565     4.102     0.200
     0.565     3.961     0.200
     0.567     4.045     0.200
     0.703     4.924     0.200
     0.865     6.558     0.200
     0.871     7.231     0.200
     0.934     6.318     0.200
     0.934     6.021     0.200
     0.996     6.533     0.200
     1.051     7.215     0.200
     1.194     7.954     0.200
     1.227     8.353     0.200
     1.227     8.111     0.200
     1.227     7.900     0.200
     1.317     8.489     0.200
     1.523     8.361     0.200
     0.173     1.879     0.200
     0.447     3.548     0.200
     0.447     3.837     0.200
     0.476     3.499     0.200
     0.476     3.659     0.200
     0.535     3.876     0.200
     0.555     4.061     0.200
     0.564     3.980     0.200
     0.927     5.876     0.200
     0.927     6.326     0.200
     0.991     7.212     0.200
     0.989     6.564     0.200
     1.057     7.791     0.200
     1.197     7.966     0.200
     1.225     8.113     0.200
     1.225     8.320     0.200
     1.315     8.601     0.200
     1.533     8.829     0.200
     1.501     9.575     0.200
     0.183     1.908     0.200
     0.453     3.717     0.200
     0.469     3.624     0.200
     0.565     4.087     0.200
     0.528     3.890     0.200
     0.564     4.041     0.200
     0.937     6.240     0.200
     0.980     7.526     0.200
     0.994     6.502     0.200
     1.190     7.997     0.200
     1.224     8.088     0.200
     1.224     8.189     0.200
     1.314     8.568     0.200
     1.521     8.041     0.200
     0.191     1.962     0.200
     0.471     3.730     0.200
     0.473     3.684     0.200
     0.510     4.214     0.200
     0.567     4.195     0.200
     0.686     5.186     0.200
     0.954     6.230     0.200
     0.964     7.323     0.200
     0.986     7.016     0.200
     1.172     8.239     0.200
     1.172     8.071     0.200
     1.210     8.616     0.200
     1.210     8.725     0.200
     1.221     8.678     0.200
     1.299     8.843     0.200
     0.183     2.012     0.200
     0.458     3.903     0.200
     0.471     3.754     0.200
     0.940     5.942     0.200
     0.991     6.842     0.200
     1.186     8.151     0.200
     1.186     8.362     0.200
     1.220     8.406     0.200
     1.220     8.554     0.200
     1.235     8.717     0.200
     1.520     8.251     0.200
     0.183     1.842     0.200
     0.456     3.737     0.200
     0.471     3.710     0.200
     0.471     3.710     0.200
     0.525     3.962     0.200
     0.561     4.050     0.200
     0.563     4.051     0.200
     0.700     4.957     0.200
     0.861     6.388     0.200
     0.869     7.252     0.200
     0.928     7.406     0.200
     0.939     6.215     0.200
     0.991     6.532     0.200
     0.979     7.860     0.200
     0.979     7.630     0.200
     1.046     7.557     0.200
     1.087     7.324     0.200
     1.162     7.731     0.200
     1.187     7.957     0.200
     1.221     8.073     0.200
     1.236     8.442     0.200
     1.232     8.980     0.200
     1.311     8.413     0.200
     1.495     9.182     0.200
     1.521     7.938     0.200
     2.643    16.107     0.200
     0.183     1.899     0.200
     0.450     3.815     0.200
     0.466     3.579     0.200
     0.467     3.602     0.200
     0.532     3.825     0.200
     0.566     4.039     0.200
     0.568     4.073     0.200
     0.703     4.774     0.200
     0.865     6.658     0.200
     0.868     6.296     0.200
     0.934     6.314     0.200
     0.931     7.793     0.200
     0.965     7.394     0.200
     0.996     6.582     0.200
     0.983     8.846     0.200
     1.052     7.338     0.200
     1.168     8.155     0.200
     1.194     7.810     0.200
     1.228     8.161     0.200
     1.243     8.287     0.200
     1.318     8.567     0.200
     1.382     8.940     0.200
     1.503     9.215     0.200
     1.522     7.733     0.200
     1.594     9.794     0.200
     1.683    10.366     0.200
     1.692    10.444     0.200
     0.181     1.826     0.200
     0.445     3.650     0.200
     0.445     3.781     0.200
     0.467     3.755     0.200
     0.571     3.960     0.200
     0.565     3.998     0.200
     0.708     4.886     0.200
     0.929     6.102     0.200
     0.929     6.333     0.200
     0.987     7.917     0.200
     0.987     7.055     0.200
     0.998     6.451     0.200
     1.174     7.584     0.200
     1.199     8.005     0.200
     1.232     8.174     0.200
     1.232     8.055     0.200
     1.248     8.348     0.200
     1.271     9.909     0.200
     1.284     9.659     0.200
     1.300     9.889     0.200
     1.322     8.400     0.200
     1.330     8.594     0.200
     1.361     7.942     0.200
     1.374    10.056     0.200
     1.385     8.814     0.200
     1.386     8.786     0.200
     1.387     8.680     0.200
     1.526     8.089     0.200
     1.610     9.869     0.200
     0.184     1.927     0.200
     0.447     3.721     0.200
     0.465     3.652     0.200
     0.567     4.098     0.200
     0.534     3.891     0.200
     0.571     4.075     0.200
     0.933     6.240     0.200
     0.999     6.618     0.200
     1.054     8.040     0.200
     1.196     7.744     0.200
     1.231     8.322     0.200
     1.245     8.432     0.200
     1.338     9.050     0.200
     1.375     9.458     0.200
     1.506     9.547     0.200
     0.195     2.003     0.200
     0.467     3.969     0.200
     0.465     3.773     0.200
     0.514     3.496     0.200
     0.557     3.917     0.200
     0.685     4.807     0.200
     0.953     6.478     0.200
     0.947     8.124     0.200
     0.964     7.471     0.200
     0.964     8.291     0.200
     1.033     6.850     0.200
     1.176     7.665     0.200
     1.176     7.505     0.200
     1.217     7.968     0.200
     1.226     8.256     0.200
     1.507     7.890     0.200
     1.489     9.052     0.200
     1.913    11.167     0.200
     0.174     1.878     0.200
     0.452     3.771     0.200
     0.477     3.903     0.200
     0.531     4.107     0.200
     0.556     4.048     0.200
     0.561     4.131     0.200
     0.931     6.183     0.200
     0.987     7.235     0.200
     0.987     7.805     0.200
     0.987     6.607     0.200
     1.192     7.908     0.200
     1.221     8.253     0.200
     1.530     8.168     0.200
     0.070     1.431     0.200
     0.487     3.824     0.200
     0.504     3.999     0.200
     0.628     4.860     0.200
     0.701     5.418     0.200
     0.814     5.724     0.200
     0.812     6.515     0.200
     0.891     6.763     0.200
     1.142     7.561     0.200
     1.142     7.740     0.200
     1.160     7.936     0.200
     1.252     8.424     0.200
     1.245     8.165     0.200
     1.455     9.185     0.200
     0.135     1.809     0.200
     0.437     3.594     0.200
     0.508     4.166     0.200
     0.520     3.807     0.200
     0.552     4.343     0.200
     0.556     4.048     0.200
     0.900     5.889     0.200
     0.965     6.362     0.200
     1.210     7.965     0.200
     1.216     7.773     0.200
     1.216     8.073     0.200
     1.309     8.277     0.200
     1.569     7.901     0.200
     1.499     9.354     0.200
     0.180     1.829     0.200
     0.458     3.722     0.200
     0.475     3.720     0.200
     0.475     3.744     0.200
     0.524     3.883     0.200
     0.560     3.958     0.200
     0.557     3.974     0.200
     0.700     4.866     0.200
     0.862     6.545     0.200
     0.939     6.222     0.200
     0.987     6.672     0.200
     0.979     7.231     0.200
     1.161     7.890     0.200
     1.186     7.842     0.200
     1.218     8.099     0.200
     1.218     7.990     0.200
     1.234     8.302     0.200
     1.308     8.327     0.200
     1.326     9.029     0.200
     1.371     9.172     0.200
     1.371     9.074     0.200
     1.371     8.715     0.200
     1.492     9.112     0.200
     1.523     8.542     0.200
     3.093    17.560     0.200
     0.186     1.824     0.200
     0.466     3.803     0.200
     0.473     3.855     0.200
     0.474     3.817     0.200
     0.516     3.990     0.200
     0.563     3.988     0.200
     0.553     4.008     0.200
     0.692     4.985     0.200
     0.854     6.612     0.200
     0.947     6.245     0.200
     0.954     7.197     0.200
     0.971     6.941     0.200
     0.986     6.603     0.200
     1.303     8.380     0.200
     1.366     8.624     0.200
     1.516     8.166     0.200
     1.578     9.654     0.200
     1.676    10.086     0.200
     3.781    21.941     0.200
     3.925    24.241     0.200
     4.334    24.766     0.200
     4.426    27.150     0.200
     0.187     1.867     0.200
     0.466     3.857     0.200
     0.472     3.844     0.200
     0.473     3.826     0.200
     0.515     3.851     0.200
     0.553     3.950     0.200
     0.564     4.021     0.200
     0.691     4.893     0.200
     0.853     6.480     0.200
     0.862     7.498     0.200
     0.948     6.283     0.200
     0.970     7.538     0.200
     0.987     6.489     0.200
     0.987     6.709     0.200
     1.036     7.257     0.200
     1.036     6.947     0.200
     1.036     7.272     0.200
     1.152     7.380     0.200
     1.177     7.827     0.200
     1.177     7.677     0.200
     1.213     8.268     0.200
     1.213     8.158     0.200
     1.226     8.319     0.200
     1.303     8.193     0.200
     1.515     7.976     0.200
     0.186     1.944     0.200
     0.474     3.796     0.200
     0.478     3.906     0.200
     0.479     3.889     0.200
     0.508     4.112     0.200
     0.545     4.172     0.200
     0.561     4.133     0.200
     0.687     5.153     0.200
     0.850     6.785     0.200
     0.860     7.381     0.200
     0.866     7.438     0.200
     0.866     6.607     0.200
     0.916     6.976     0.200
     0.953     6.263     0.200
     0.947     7.420     0.200
     0.980     6.734     0.200
     0.966     7.152     0.200
     0.966     7.941     0.200
     1.029     7.216     0.200
     1.170     8.102     0.200
     1.170     7.942     0.200
     1.205     8.411     0.200
     1.218     8.497     0.200
     1.294     8.596     0.200
     1.478     9.591     0.200
     1.668    10.422     0.200
     0.178     1.942     0.200
     0.461     3.828     0.200
     0.479     3.806     0.200
     0.479     3.814     0.200
     0.521     3.855     0.200
     0.553     3.984     0.200
     0.556     4.054     0.200
     0.700     4.840     0.200
     0.862     6.501     0.200
     0.862     6.399     0.200
     0.871     7.167     0.200
     0.874     7.321     0.200
     0.874     6.484     0.200
     0.929     7.490     0.200
     0.940     6.289     0.200
     0.940     6.187     0.200
     0.960     7.092     0.200
     0.983     6.362     0.200
     0.979     8.002     0.200
     0.979     6.525     0.200
     1.043     6.875     0.200
     1.183     7.738     0.200
     1.183     7.605     0.200
     1.213     8.037     0.200
     1.230     8.283     0.200
     1.303     8.398     0.200
     1.488     9.201     0.200
     1.524     8.116     0.200
     0.180     1.920     0.200
     0.474     3.843     0.200
     0.485     3.886     0.200
     0.486     3.878     0.200
     0.509     4.015     0.200
     0.541     4.100     0.200
     0.554     4.075     0.200
     0.691     5.041     0.200
     0.691     4.830     0.200
     0.854     6.718     0.200
     0.950     6.280     0.200
     0.974     6.734     0.200
     0.970     6.504     0.200
     1.170     8.029     0.200
     1.201     8.237     0.200
     1.291     8.348     0.200
     1.475     9.401     0.200
     0.181     1.886     0.200
     0.454     3.568     0.200
     0.470     3.702     0.200
     0.471     3.584     0.200
     0.528     4.267     0.200
     0.562     4.128     0.200
     0.563     4.325     0.200
     0.702     5.098     0.200
     0.864     6.650     0.200
     0.870     7.428     0.200
     0.871     7.819     0.200
     0.936     6.056     0.200
     0.930     7.300     0.200
     0.992     6.759     0.200
     1.049     7.405     0.200
     1.190     8.153     0.200
     1.223     8.429     0.200
     1.313     8.778     0.200
     1.497     9.662     0.200
     1.498     9.693     0.200
     1.498     9.193     0.200
     1.523     8.527     0.200
     1.687    10.672     0.200
     0.177     1.900     0.200
     0.177     1.599     0.200
     0.450     3.777     0.200
     0.473     3.822     0.200
     0.474     3.824     0.200
     0.559     4.013     0.200
     0.532     4.078     0.200
     0.563     3.988     0.200
     0.707     4.924     0.200
     0.869     6.564     0.200
     0.876     6.602     0.200
     0.932     6.270     0.200
     0.932     6.151     0.200
     0.935     7.713     0.200
     0.990     6.640     0.200
     0.990     6.229     0.200
     0.986     7.517     0.200
     1.169     7.634     0.200
     1.193     8.197     0.200
     1.224     8.373     0.200
     1.224     8.093     0.200
     1.241     8.358     0.200
     1.314     8.169     0.200
     1.314     8.448     0.200
     1.333     8.929     0.200
     1.499     9.206     0.200
     1.528     8.080     0.200
     0.181     1.946     0.200
     0.460     3.878     0.200
     0.474     3.862     0.200
     0.475     3.854     0.200
     0.522     3.904     0.200
     0.556     4.006     0.200
     0.560     4.060     0.200
     0.698     4.947     0.200
     0.861     6.586     0.200
     0.869     7.227     0.200
     0.870     7.313     0.200
     0.927     6.890     0.200
     0.941     6.307     0.200
     0.987     6.374     0.200
     0.977     7.431     0.200
     0.977     7.950     0.200
     1.043     6.964     0.200
     1.184     7.733     0.200
     1.216     8.224     0.200
     1.306     8.431     0.200
     1.491     9.187     0.200
     1.522     8.249     0.200
     3.139    18.920     0.200
     0.182     1.907     0.200
     0.465     3.842     0.200
     0.477     3.750     0.200
     0.477     3.711     0.200
     0.517     3.736     0.200
     0.560     4.013     0.200
     0.552     3.966     0.200
     0.695     4.742     0.200
     0.869     7.264     0.200
     0.867     7.188     0.200
     0.857     6.707     0.200
     0.945     6.286     0.200
     0.974     7.279     0.200
     0.983     6.497     0.200
     1.179     7.835     0.200
     1.212     8.181     0.200
     1.302     8.342     0.200
     1.520     8.147     0.200
     0.182     1.938     0.200
     0.465     3.884     0.200
     0.477     3.769     0.200
     0.477     3.761     0.200
     0.517     3.752     0.200
     0.517     3.639     0.200
     0.551     3.736     0.200
     0.560     4.052     0.200
     0.695     4.837     0.200
     0.857     6.442     0.200
     0.866     7.091     0.200
     0.869     7.159     0.200
     0.924     7.354     0.200
     0.945     6.356     0.200
     0.945     6.117     0.200
     0.945     5.758     0.200
     0.983     6.470     0.200
     0.974     6.994     0.200
     0.974     7.361     0.200
     1.154     7.735     0.200
     1.179     7.738     0.200
     1.212     8.424     0.200
     1.212     8.154     0.200
     1.227     8.208     0.200
     1.301     8.323     0.200
     1.319     8.764     0.200
     1.357     9.131     0.200
     1.354    10.108     0.200
     1.365     9.096     0.200
     1.364     8.966     0.200
     1.370    10.218     0.200
     1.486     9.093     0.200
     1.520     7.909     0.200
     0.422     3.174     0.200
     0.487     4.057     0.200
     0.556     4.227     0.200
     0.583     4.005     0.200
     0.636     4.356     0.200
     0.728     5.084     0.200
     0.732     4.876     0.200
     0.732     4.720     0.200
     0.740     4.977     0.200
     0.758     4.872     0.200
     0.758     5.097     0.200
     0.801     5.696     0.200
     0.825     5.884     0.200
     0.835     6.174     0.200
     0.840     5.314     0.200
     0.856     5.308     0.200
     0.869     6.127     0.200
     0.911     5.667     0.200
     0.924     5.919     0.200
     0.973     6.383     0.200
     0.979     6.871     0.200
     1.019     6.665     0.200
     1.028     6.239     0.200
     1.032     6.815     0.200
     1.046     6.374     0.200
     1.061     6.907     0.200
     1.072     7.330     0.200
     1.073     7.045     0.200
     1.073     7.022     0.200
     1.203     7.934     0.200
     1.244     7.277     0.200
     1.260     7.887     0.200
     1.371     7.809     0.200
     1.371     7.997     0.200
     1.467     8.278     0.200
     0.192     1.953     0.200
     0.475     3.894     0.200
     0.474     3.984     0.200
     0.506     4.162     0.200
     0.547     4.200     0.200
     0.566     4.113     0.200
     0.683     5.204     0.200
     0.957     6.305     0.200
     0.984     6.766     0.200
     1.168     7.879     0.200
     1.207     8.290     0.200
     1.207     8.411     0.200
     1.296     8.569     0.200
     1.479     9.400     0.200
     1.479     9.541     0.200
     0.175     1.969     0.200
     0.456     3.860     0.200
     0.478     3.799     0.200
     0.478     3.799     0.200
     0.526     3.853     0.200
     0.526     3.712     0.200
     0.555     4.033     0.200
     0.704     4.866     0.200
     0.935     6.291     0.200
     0.984     6.578     0.200
     0.984     6.418     0.200
     1.188     7.744     0.200
     1.188     7.853     0.200
     1.217     8.179     0.200
     1.217     8.019     0.200
     1.235     8.279     0.200
     1.308     8.214     0.200
     1.493     9.114     0.200
     1.528     7.846     0.200
     0.183     1.955     0.200
     0.471     3.825     0.200
     0.480     3.814     0.200
     0.481     3.837     0.200
     0.511     3.906     0.200
     0.546     4.035     0.200
     0.558     4.065     0.200
     0.691     4.956     0.200
     0.864     7.279     0.200
     0.869     7.466     0.200
     0.921     7.631     0.200
     0.949     6.283     0.200
     0.979     6.448     0.200
     1.173     7.788     0.200
     1.206     8.106     0.200
     1.296     8.347     0.200
     1.359     8.554     0.200
     1.518     7.971     0.200
     0.464     3.767     0.200
     0.565     4.219     0.200
     0.471     3.622     0.200
     0.472     3.604     0.200
     0.518     3.998     0.200
     0.863     7.410     0.200
     0.865     7.559     0.200
     0.921     7.713     0.200
     0.954     7.102     0.200
     0.972     8.252     0.200
     1.038     7.508     0.200
     1.155     8.308     0.200
     1.180     8.063     0.200
     1.228     8.484     0.200
     1.305     8.659     0.200
     1.297     9.435     0.200
     1.321     9.192     0.200
     1.368     8.713     0.200
     1.367     9.260     0.200
     1.358     9.488     0.200
     1.355    10.071     0.200
     1.421    10.085     0.200
     1.489     9.616     0.200
     1.489     9.563     0.200
     1.455     9.897     0.200
     1.551    10.194     0.200
     1.539    10.283     0.200
     1.571     9.459     0.200
     1.516     8.081     0.200
     1.623    11.041     0.200
     0.267     2.420     0.200
     0.468     3.708     0.200
     0.651     5.037     0.200
     0.707     5.016     0.200
     0.803     5.888     0.200
     0.804     5.869     0.200
     0.798     5.632     0.200
     0.918     6.327     0.200
     1.019     6.530     0.200
     0.963     7.194     0.200
     0.994     7.429     0.200
     1.053     7.423     0.200
     1.046     7.006     0.200
     1.046     7.116     0.200
     1.103     7.310     0.200
     1.103     7.181     0.200
     1.098     7.559     0.200
     1.069     7.560     0.200
     1.124     7.378     0.200
     1.145     8.538     0.200
     1.209     7.563     0.200
     1.226     7.637     0.200
     1.226     7.496     0.200
     1.281     7.958     0.200
     1.305     8.538     0.200
     1.283     8.914     0.200
     1.396     8.816     0.200
     1.378     9.428     0.200
     1.413     8.921     0.200
     1.447     9.157     0.200
     1.481     9.042     0.200
     1.569    10.047     0.200
     1.615     9.797     0.200
     0.202     2.305     0.200
     0.439     3.564     0.200
     0.366     3.217     0.200
     0.665     4.920     0.200
     0.772     5.450     0.200
     0.797     6.041     0.200
     0.862     5.857     0.200
     0.872     6.365     0.200
     0.888     6.659     0.200
     0.888     6.510     0.200
     0.956     6.215     0.200
     0.943     6.052     0.200
     0.943     6.402     0.200
     0.955     6.706     0.200
     0.963     6.850     0.200
     1.030     6.562     0.200
     1.153     6.857     0.200
     1.153     7.157     0.200
     1.230     7.424     0.200
     1.315     8.044     0.200
     1.315     7.893     0.200
     1.332     8.017     0.200
     1.360     7.677     0.200
     1.332     8.172     0.200
     1.352     7.881     0.200
     1.467     7.790     0.200
     1.505     7.766     0.200
     1.509     7.906     0.200
     0.186     1.970     0.200
     0.476     3.850     0.200
     0.477     3.854     0.200
     0.470     3.876     0.200
     0.512     3.802     0.200
     0.549     3.955     0.200
     0.562     4.042     0.200
     0.690     4.829     0.200
     0.690     4.970     0.200
     0.852     6.492     0.200
     0.862     6.730     0.200
     0.866     6.621     0.200
     0.866     6.752     0.200
     0.919     6.696     0.200
     0.951     7.405     0.200
     0.968     7.468     0.200
     0.971     6.426     0.200
     0.983     6.417     0.200
     1.033     7.060     0.200
     1.174     7.728     0.200
     1.174     7.431     0.200
     1.209     8.183     0.200
     1.298     8.305     0.200
     1.361     8.609     0.200
     1.482     9.119     0.200
     1.515     8.264     0.200
     1.574     9.749     0.200
     0.191     1.873     0.200
     0.476     3.800     0.200
     0.477     3.792     0.200
     0.478     3.778     0.200
     0.504     3.886     0.200
     0.544     3.990     0.200
     0.565     4.033     0.200
     0.682     4.950     0.200
     0.844     6.585     0.200
     0.855     6.686     0.200
     0.861     7.461     0.200
     0.968     6.483     0.200
     0.981     6.485     0.200
     1.141     8.384     0.200
     1.166     7.663     0.200
     1.204     7.900     0.200
     1.204     8.279     0.200
     1.214     8.343     0.200
     1.293     8.390     0.200
     1.344     9.320     0.200
     1.353     8.883     0.200
     1.476     9.190     0.200
     1.476     9.501     0.200
     1.509     8.066     0.200
     1.525    10.159     0.200
     1.557    10.226     0.200
     1.568    10.064     0.200
     0.186     1.887     0.200
     0.468     3.828     0.200
     0.475     3.852     0.200
     0.476     3.804     0.200
     0.514     3.792     0.200
     0.550     3.900     0.200
     0.562     3.992     0.200
     0.691     4.804     0.200
     0.853     6.140     0.200
     0.862     6.690     0.200
     0.866     7.400     0.200
     0.973     6.404     0.200
     0.984     6.608     0.200
     1.035     7.122     0.200
     1.036     7.264     0.200
     1.175     8.018     0.200
     1.210     8.109     0.200
     1.210     7.679     0.200
     1.224     7.902     0.200
     1.362     8.964     0.200
     1.516     7.874     0.200
     0.264     2.386     0.200
     0.354     3.046     0.200
     0.456     4.002     0.200
     0.650     4.881     0.200
     0.662     4.854     0.200
     0.704     4.732     0.200
     0.783     5.810     0.200
     0.791     5.881     0.200
     0.792     5.862     0.200
     0.921     6.160     0.200
     1.021     6.572     0.200
     1.039     7.020     0.200
     1.039     7.241     0.200
     1.123     7.261     0.200
     1.211     7.489     0.200
     1.227     7.512     0.200
     1.282     7.826     0.200
     1.291     7.763     0.200
     1.291     7.883     0.200
     1.398     8.357     0.200
     1.398     8.337     0.200
     1.412     8.573     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
     4.021    60.852     0.200
     0.967    22.789     0.200
     0.944    22.122     0.200
     2.835    44.918     0.200
     9.208   127.174     0.200
     1.738    30.135     0.200
     1.738    30.904     0.200
     3.071    48.596     0.200
     3.441    54.218     0.200
     3.476    56.585     0.200
     4.313    67.114     0.200
     6.297    89.620     0.200
     7.174   102.129     0.200
     9.294   131.814     0.200
     1.810    31.528     0.200
     1.447    29.013     0.200
     1.958    34.787     0.200
     2.004    34.327     0.200
     2.153    35.450     0.200
     2.678    43.327     0.200
     2.701    42.785     0.200
     3.049    47.669     0.200
     3.327    51.537     0.200
     2.930    46.918     0.200
     1.170    23.897     0.200
     2.210    37.478     0.200
     2.331    38.737     0.200
     2.362    38.365     0.200
     2.606    43.111     0.200
     2.968    46.431     0.200
     3.029    48.465     0.200
     3.059    47.615     0.200
     3.059    49.099     0.200
     3.237    50.700     0.200
     3.424    53.002     0.200
     3.424    54.383     0.200
     3.779    57.974     0.200
     4.372    65.388     0.200
     4.533    67.947     0.200
     2.194    35.721     0.200
     2.558    42.051     0.200
     2.558    42.051     0.200
     3.765    58.413     0.200
     3.765    57.653     0.200
     1.666    34.450     0.200
     1.738    33.991     0.200
     1.899    34.358     0.200
     3.571    56.578     0.200
     4.128    67.906     0.200
     4.266    69.003     0.200
     5.229    83.446     0.200
     5.534    81.047     0.200
     6.535    94.210     0.200
     1.906    34.512     0.200
     2.525    40.606     0.200
     2.525    41.919     0.200
     2.979    49.518     0.200
     3.585    59.018     0.200
     5.420    79.753     0.200
     5.544    82.552     0.200
     5.544    80.895     0.200
     1.172    26.813     0.200
     1.188    26.731     0.200
     1.639    31.573     0.200
     1.900    34.223     0.200
     3.563    58.588     0.200
     3.583    57.619     0.200
     1.740    34.479     0.200
     4.943    76.726     0.200
     1.177    26.820     0.200
     1.343    28.986     0.200
     1.645    31.862     0.200
     1.668    34.291     0.200
     3.569    57.019     0.200
     3.589    58.078     0.200
     1.194    27.021     0.200
     1.355    27.575     0.200
     1.446    28.418     0.200
     1.658    30.841     0.200
     3.837    60.037     0.200
     1.178    26.418     0.200
     1.193    26.101     0.200
     1.437    28.672     0.200
     1.437    28.781     0.200
     2.433    41.847     0.200
     3.579    56.964     0.200
     3.822    60.004     0.200
     3.834    61.355     0.200
     4.135    65.913     0.200
     4.222    64.706     0.200
     4.262    64.417     0.200
     4.978    76.662     0.200
     5.250    81.216     0.200
     5.536    82.775     0.200
     6.539    94.525     0.200
     7.795   112.828     0.200
     8.530   120.612     0.200
     8.786   123.056     0.200
     8.772   125.486     0.200
     8.869   125.358     0.200
     8.983   122.099     0.200
     9.004   125.206     0.200
     9.136   129.618     0.200
     9.194   133.372     0.200
     9.458   130.383     0.200
     9.861   140.991     0.200
    10.401   145.451     0.200
    10.736   150.750     0.200
    10.821   145.503     0.200
    11.179   155.169     0.200
    12.122   168.825     0.200
    12.652   175.593     0.200
    12.750   174.391     0.200
    13.369   184.570     0.200
    13.483   183.560     0.200
    13.654   187.190     0.200
    13.709   188.574     0.200
     1.529    29.191     0.200
     1.560    30.949     0.200
     1.743    32.328     0.200
     2.649    42.807     0.200
     2.809    45.367     0.200
     1.653    32.084     0.200
     1.682    34.911     0.200
     1.920    33.043     0.200
     2.530    41.058     0.200
     1.186    26.601     0.200
     1.914    33.788     0.200
     2.983    49.888     0.200
     1.195    26.929     0.200
     1.212    27.242     0.200
     1.650    32.066     0.200
     1.682    35.065     0.200
     2.538    40.965     0.200
     2.538    40.129     0.200
     4.214    65.524     0.200
     5.562    82.565     0.200
     6.827    97.440     0.200
     1.675    34.649     0.200
     1.911    33.091     0.200
     2.522    40.636     0.200
     1.356    27.101     0.200
     1.449    29.507     0.200
     2.532    41.129     0.200
     3.603    55.558     0.200
     5.563    83.135     0.200
     1.432    29.913     0.200
     1.640    32.150     0.200
     1.736    34.351     0.200
     1.920    34.532     0.200
     2.970    50.445     0.200
     4.297    63.665     0.200
     1.190    26.583     0.200
     1.640    31.630     0.200
     1.675    32.984     0.200
     2.542    41.382     0.200
     3.563    54.360     0.200
     4.204    65.219     0.200
     4.297    64.379     0.200
     5.561    82.255     0.200
     1.739    34.011     0.200
     2.193    35.085     0.200
     2.524    40.353     0.200
     2.982    48.826     0.200
     3.820    59.587     0.200
     4.029    62.020     0.200
     4.157    61.196     0.200
     4.211    65.369     0.200
     2.218    36.729     0.200
     1.192    25.202     0.200
     1.759    34.406     0.200
     2.514    41.511     0.200
     3.003    50.164     0.200
     3.610    59.015     0.200
     3.841    59.889     0.200
     4.233    66.899     0.200
     5.263    82.193     0.200
     5.549    85.304     0.200
     1.420    28.124     0.200
     1.503    29.253     0.200
     1.520    29.476     0.200
     1.950    33.417     0.200
     2.498    40.760     0.200
     5.565    81.450     0.200
     1.384    28.611     0.200
     1.923    33.740     0.200
     2.501    41.083     0.200
     3.024    48.210     0.200
     3.195    51.395     0.200
     3.294    51.729     0.200
     3.338    51.785     0.200
     4.252    64.927     0.200
     4.255    62.449     0.200
     5.547    83.201     0.200
     6.266    89.412     0.200
     6.788    96.567     0.200
     1.927    32.276     0.200
     2.497    40.116     0.200
     1.675    35.307     0.200
     1.740    34.352     0.200
     1.916    34.500     0.200
     2.201    36.672     0.200
     2.532    40.604     0.200
     2.979    50.043     0.200
     4.210    66.251     0.200
     5.554    82.305     0.200
     1.857    33.157     0.200
     2.438    41.156     0.200
     2.577    42.565     0.200
     2.707    43.180     0.200
     2.746    42.445     0.200
     3.291    51.473     0.200
     3.613    55.895     0.200
    10.936   148.277     0.200
     0.930    21.466     0.200
     1.229    23.645     0.200
     1.437    28.237     0.200
     1.512    27.763     0.200
     2.347    38.517     0.200
     2.947    49.080     0.200
     3.082    49.865     0.200
     1.000    22.906     0.200
     1.370    27.813     0.200
     1.370    28.102     0.200
     1.691    31.604     0.200
     2.096    33.889     0.200
     2.104    34.558     0.200
     2.616    40.828     0.200
     2.682    43.924     0.200
     2.831    45.777     0.200
     2.831    45.465     0.200
     2.834    45.314     0.200
     2.969    47.497     0.200
     3.529    55.007     0.200
     3.877    60.047     0.200
     4.368    65.529     0.200
     2.424    38.130     0.200
     2.981    48.489     0.200
     1.973    34.835     0.200
     1.975    34.815     0.200
     2.573    43.491     0.200
     2.658    43.572     0.200
     3.128    51.665     0.200
     3.423    53.799     0.200
     1.696    34.248     0.200
     1.691    32.786     0.200
     2.756    44.014     0.200
     4.510    67.043     0.200
     5.715    84.372     0.200
     6.003    87.091     0.200
     1.149    25.665     0.200
     1.203    25.646     0.200
     1.391    27.878     0.200
     1.391    26.985     0.200
     1.410    27.579     0.200
     1.540    28.261     0.200
     1.569    28.948     0.200
     1.840    30.928     0.200
     2.148    36.349     0.200
     2.471    40.365     0.200
     2.645    41.473     0.200
     2.859    45.106     0.200
     3.311    50.809     0.200
     3.525    53.096     0.200
     3.723    56.412     0.200
     4.513    67.537     0.200
     1.314    29.829     0.200
     1.416    28.802     0.200
     1.595    31.639     0.200
     1.614    30.821     0.200
     1.703    33.248     0.200
     2.743    44.898     0.200
     4.837    69.979     0.200
     6.884    98.122     0.200
     1.089    24.404     0.200
     1.305    28.497     0.200
     1.304    28.805     0.200
     1.408    28.907     0.200
     1.599    31.800     0.200
     2.331    39.295     0.200
     1.307    27.097     0.200
     1.704    30.937     0.200
     1.999    34.500     0.200
     2.374    39.048     0.200
     3.251    52.634     0.200
     1.251    26.516     0.200
     1.427    28.781     0.200
     1.618    32.048     0.200
     1.922    32.119     0.200
     2.220    37.245     0.200
     2.336    39.340     0.200
     3.910    60.270     0.200
     4.091    59.186     0.200
     4.466    66.900     0.200
     1.093    24.797     0.200
     1.254    26.596     0.200
     1.548    30.311     0.200
     2.307    38.679     0.200
     2.958    49.373     0.200
     1.078    23.191     0.200
     1.554    29.422     0.200
     2.315    37.841     0.200
     2.958    49.476     0.200
     3.548    55.382     0.200
     4.069    60.555     0.200
    14.464   195.461     0.200
     1.103    24.421     0.200
     2.963    48.946     0.200
     1.314    28.790     0.200
     1.450    29.846     0.200
     1.526    31.887     0.200
     1.588    31.870     0.200
     2.390    40.469     0.200
     2.409    42.046     0.200
     2.757    44.124     0.200
     1.045    20.410     0.200
     1.158    22.977     0.200
     1.577    28.637     0.200
     1.680    28.404     0.200
     1.680    28.619     0.200
     2.262    35.527     0.200
     2.436    39.773     0.200
     2.886    44.007     0.200
     2.886    44.600     0.200
     3.141    49.587     0.200
     3.411    51.433     0.200
     0.935    21.108     0.200
     1.470    29.482     0.200
     1.921    32.321     0.200
     3.828    55.417     0.200
     1.089    23.148     0.200
     1.242    24.651     0.200
     1.242    24.757     0.200
     1.297    26.758     0.200
     1.616    29.947     0.200
     1.764    30.653     0.200
     2.291    38.181     0.200
     2.452    40.136     0.200
     1.311    27.152     0.200
     1.311    28.973     0.200
     3.009    48.040     0.200
     4.100    64.244     0.200
     0.890    19.699     0.200
     0.953    19.943     0.200
     0.953    20.303     0.200
     1.145    24.382     0.200
     1.216    23.615     0.200
     1.287    26.408     0.200
     0.903    21.408     0.200
     1.069    23.229     0.200
     1.195    25.068     0.200
     1.241    26.032     0.200
     1.278    27.202     0.200
     1.298    27.388     0.200
     1.318    25.345     0.200
     1.354    26.937     0.200
     1.385    28.240     0.200
     1.438    27.454     0.200
     1.496    28.892     0.200
     1.537    28.970     0.200
     1.633    30.355     0.200
     2.402    38.804     0.200
     2.402    38.446     0.200
     3.005    48.458     0.200
     0.975    23.154     0.200
     1.198    25.515     0.200
     1.260    25.371     0.200
     1.367    28.751     0.200
     1.427    30.762     0.200
     1.434    30.893     0.200
     1.561    31.545     0.200
     1.665    32.881     0.200
     1.665    33.674     0.200
     0.959    20.718     0.200
     1.022    22.467     0.200
     1.079    23.647     0.200
     1.148    23.127     0.200
     1.626    29.998     0.200
     2.442    38.257     0.200
     2.442    38.656     0.200
     0.923    20.232     0.200
     0.944    20.539     0.200
     1.225    26.710     0.200
     1.277    25.972     0.200
     1.316    26.591     0.200
     1.326    25.942     0.200
     1.380    27.411     0.200
     1.415    28.606     0.200
     1.415    29.114     0.200
     1.427    29.600     0.200
     1.513    29.627     0.200
     1.540    29.297     0.200
     1.555    30.294     0.200
     2.435    40.648     0.200
     2.864    47.302     0.200
     3.714    59.027     0.200
     4.759    68.733     0.200
     5.249    79.308     0.200
     5.328    80.229     0.200
     0.914    20.145     0.200
     0.959    22.938     0.200
     1.119    23.048     0.200
     1.127    22.633     0.200
     1.427    29.311     0.200
     1.452    27.807     0.200
     1.521    28.977     0.200
     1.521    29.215     0.200
     2.446    39.624     0.200
     0.917    20.267     0.200
     0.962    20.613     0.200
     1.129    23.208     0.200
     1.151    22.577     0.200
     1.177    24.283     0.200
     1.392    27.799     0.200
     1.429    28.788     0.200
     1.641    30.075     0.200
     2.449    39.793     0.200
     0.960    21.544     0.200
     1.121    24.141     0.200
     1.151    22.616     0.200
     1.238    26.141     0.200
     1.392    27.691     0.200
     1.428    28.912     0.200
     1.643    30.386     0.200
     2.446    38.918     0.200
     0.921    20.536     0.200
     0.982    20.064     0.200
     1.219    24.708     0.200
     1.245    24.086     0.200
     1.306    25.888     0.200
     1.319    24.926     0.200
     1.394    25.678     0.200
     2.667    41.211     0.200
     2.725    42.183     0.200
    10.755   152.454     0.200
     1.406    28.818     0.200
     1.463    29.433     0.200
     1.465    29.406     0.200
     1.465    28.999     0.200
     1.554    30.240     0.200
     1.617    31.737     0.200
     1.645    34.410     0.200
     2.312    37.665     0.200
     1.119    24.670     0.200
     2.341    36.229     0.200
     5.408    80.897     0.200
     0.977    22.008     0.200
     1.025    21.898     0.200
     1.025    23.886     0.200
     1.322    27.656     0.200
     1.330    27.245     0.200
     2.199    35.514     0.200
     2.552    42.947     0.200
     2.724    40.809     0.200
     3.760    58.323     0.200
     1.101    24.881     0.200
     1.620    31.835     0.200
     0.999    23.272     0.200
     1.126    23.232     0.200
     2.425    39.296     0.200
     2.873    45.245     0.200
     2.706    42.174     0.200
     2.617    45.460     0.200
     3.258    52.001     0.200
     4.069    61.260     0.200
     4.438    66.653     0.200
     6.945    98.388     0.200
     1.367    28.367     0.200
     1.596    31.459     0.200
     2.393    38.896     0.200
     0.806    18.592     0.200
     0.806    19.495     0.200
     0.919    19.554     0.200
     0.919    19.734     0.200
     1.189    24.165     0.200
     1.418    26.124     0.200
     1.423    26.203     0.200
     1.422    26.154     0.200
     1.494    26.918     0.200
     0.748    15.814     0.200
     0.748    16.049     0.200
     0.879    17.324     0.200
     0.904    18.088     0.200
     0.904    19.025     0.200
     0.907    20.662     0.200
     0.907    18.334     0.200
     0.920    18.620     0.200
     0.965    20.156     0.200
     0.985    20.234     0.200
     1.002    21.051     0.200
     1.024    21.406     0.200
     1.049    19.837     0.200
     1.112    23.400     0.200
     1.119    21.464     0.200
     1.117    22.478     0.200
     1.126    22.849     0.200
     1.162    22.263     0.200
     1.192    23.452     0.200
     1.192    23.108     0.200
     1.506    25.342     0.200
     1.646    27.120     0.200
     1.947    31.800     0.200
     2.574    40.989     0.200
     2.764    40.594     0.200
     2.764    41.750     0.200
     1.057    24.549     0.200
     1.144    25.530     0.200
     1.144    26.851     0.200
     1.150    26.150     0.200
     1.288    27.833     0.200
     1.366    30.043     0.200
     1.421    28.427     0.200
     1.468    29.325     0.200
     1.468    29.561     0.200
     1.544    30.738     0.200
     0.930    19.579     0.200
     0.957    20.399     0.200
     0.979    20.150     0.200
     1.000    21.555     0.200
     1.006    21.157     0.200
     1.007    22.301     0.200
     1.094    23.114     0.200
     1.146    24.205     0.200
     1.170    23.320     0.200
     1.170    22.831     0.200
     1.236    24.884     0.200
     1.236    25.714     0.200
     1.343    26.052     0.200
     1.334    28.057     0.200
     1.650    29.158     0.200
     1.929    33.491     0.200
     2.377    39.575     0.200
     2.520    40.564     0.200
     2.806    43.987     0.200
     2.806    41.625     0.200
     0.978    21.690     0.200
     0.999    21.975     0.200
     1.006    21.203     0.200
     1.094    23.473     0.200
     1.170    23.218     0.200
     1.199    25.720     0.200
     1.236    23.638     0.200
     1.314    24.899     0.200
     1.343    25.364     0.200
     1.346    27.913     0.200
     1.394    27.475     0.200
     1.650    30.357     0.200
     1.675    30.690     0.200
     0.833    18.974     0.200
     1.042    20.506     0.200
     1.042    22.916     0.200
     1.002    21.738     0.200
     1.051    21.274     0.200
     1.050    20.991     0.200
     1.050    23.062     0.200
     1.060    21.600     0.200
     1.077    20.930     0.200
     1.077    21.901     0.200
     1.122    23.968     0.200
     1.200    23.346     0.200
     1.269    24.850     0.200
     1.320    25.203     0.200
     2.747    41.239     0.200
     1.042    21.553     0.200
     1.191    25.300     0.200
     1.207    25.061     0.200
     1.207    25.202     0.200
     1.207    25.967     0.200
     1.347    26.374     0.200
     1.396    26.829     0.200
     2.531    39.216     0.200
     2.531    40.201     0.200
     2.976    49.564     0.200
     3.820    59.255     0.200
     4.285    63.176     0.200
     4.285    62.653     0.200
     0.879    18.093     0.200
     0.989    20.762     0.200
     1.071    23.411     0.200
     1.072    23.040     0.200
     1.203    23.420     0.200
     1.219    23.945     0.200
     1.219    24.705     0.200
     1.219    24.875     0.200
     1.040    22.636     0.200
     1.055    20.995     0.200
     1.114    23.309     0.200
     1.162    23.667     0.200
     1.209    23.296     0.200
     1.252    25.532     0.200
     1.271    24.155     0.200
     1.268    24.800     0.200
     1.336    26.010     0.200
     0.962    20.565     0.200
     0.962    20.563     0.200
     0.977    21.521     0.200
     1.050    22.556     0.200
     1.124    22.577     0.200
     1.258    24.057     0.200
     1.284    24.538     0.200
     1.284    26.638     0.200
     1.296    25.098     0.200
     1.346    26.711     0.200
     1.421    26.899     0.200
     0.906    20.281     0.200
     0.943    21.276     0.200
     1.057    23.238     0.200
     1.082    23.286     0.200
     1.139    23.473     0.200
     1.223    24.659     0.200
     1.286    25.368     0.200
     1.323    26.268     0.200
     1.323    26.768     0.200
     1.371    26.021     0.200
     1.675    30.778     0.200
     2.053    33.213     0.200
     2.576    40.043     0.200
     2.576    37.988     0.200
     2.685    44.164     0.200
     3.232    52.212     0.200
     3.535    53.979     0.200
     2.308    36.637     0.200
     2.308    36.833     0.200
     3.446    54.519     0.200
     0.974    21.914     0.200
     0.995    21.913     0.200
     1.002    21.140     0.200
     1.002    22.453     0.200
     1.005    21.846     0.200
     1.085    22.312     0.200
     1.089    23.917     0.200
     1.097    24.113     0.200
     1.165    23.383     0.200
     1.185    25.469     0.200
     1.240    25.409     0.200
     1.240    25.858     0.200
     1.327    27.968     0.200
     1.340    25.684     0.200
     1.390    28.179     0.200
     1.465    28.432     0.200
     1.649    30.062     0.200
     1.924    33.253     0.200
     2.378    39.907     0.200
     2.520    40.511     0.200
     2.803    43.962     0.200
     2.803    43.172     0.200
     3.023    49.979     0.200
     3.230    51.316     0.200
     3.561    54.598     0.200
     4.542    65.004     0.200
     1.114    24.101     0.200
     1.148    24.659     0.200
     1.188    25.440     0.200
     1.239    25.984     0.200
     1.475    28.776     0.200
     1.475    28.885     0.200
     0.839    19.681     0.200
     0.866    18.490     0.200
     0.938    19.756     0.200
     0.955    20.570     0.200
     0.978    20.007     0.200
     0.986    21.406     0.200
     0.987    21.822     0.200
     1.019    21.567     0.200
     1.080    21.323     0.200
     1.080    21.015     0.200
     1.081    21.831     0.200
     1.109    21.497     0.200
     1.148    22.460     0.200
     1.148    23.431     0.200
     1.653    27.679     0.200
     1.845    30.266     0.200
     2.315    36.573     0.200
     2.950    45.466     0.200
     3.360    50.656     0.200
     0.944    21.147     0.200
     1.323    25.645     0.200
     1.411    26.760     0.200
     1.769    31.209     0.200
     2.095    36.464     0.200
     2.657    43.768     0.200
     2.762    46.432     0.200
     3.411    54.575     0.200
     0.943    20.668     0.200
     0.948    21.947     0.200
     1.004    21.795     0.200
     1.014    22.375     0.200
     1.087    24.222     0.200
     1.208    24.385     0.200
     1.343    26.466     0.200
     1.389    27.043     0.200
     1.419    27.388     0.200
     1.448    28.842     0.200
     1.445    27.829     0.200
     1.466    28.937     0.200
     1.769    30.992     0.200
     2.092    35.646     0.200
     2.556    41.509     0.200
     2.544    41.359     0.200
     2.650    43.601     0.200
     0.948    21.648     0.200
     1.004    22.596     0.200
     1.014    22.939     0.200
     1.207    23.945     0.200
     1.205    26.080     0.200
     1.447    28.854     0.200
     1.465    29.103     0.200
     0.889    20.515     0.200
     0.945    21.977     0.200
     0.930    21.021     0.200
     0.988    21.034     0.200
     1.027    23.525     0.200
     1.158    23.380     0.200
     1.230    25.931     0.200
     1.010    22.008     0.200
     1.021    22.560     0.200
     1.152    25.157     0.200
     1.217    24.830     0.200
     1.320    25.570     0.200
     1.320    29.070     0.200
     1.353    27.194     0.200
     1.428    27.883     0.200
     1.454    28.320     0.200
     1.476    28.915     0.200
     1.007    22.946     0.200
     1.204    24.498     0.200
     1.336    27.036     0.200
     1.336    27.286     0.200
     0.965    19.818     0.200
     0.983    20.592     0.200
     0.983    20.994     0.200
     1.163    25.493     0.200
     1.184    24.663     0.200
     1.288    25.480     0.200
     1.276    24.976     0.200
     1.307    28.185     0.200
     1.319    28.150     0.200
     1.327    28.003     0.200
     1.349    25.701     0.200
     1.342    28.428     0.200
     1.342    28.639     0.200
     1.348    28.706     0.200
     1.389    26.314     0.200
     1.389    26.455     0.200
     1.389    27.623     0.200
     1.381    26.380     0.200
     1.370    29.379     0.200
     4.998    74.306     0.200
     5.414    78.655     0.200
     6.722    99.919     0.200
     9.242   129.363     0.200
     0.998    19.704     0.200
     1.086    23.553     0.200
     1.099    22.728     0.200
     1.092    23.242     0.200
     1.103    24.240     0.200
     1.177    24.189     0.200
     1.186    24.718     0.200
     1.239    26.636     0.200
     1.260    24.921     0.200
     1.283    27.214     0.200
     1.293    25.673     0.200
     1.339    25.268     0.200
     1.351    25.939     0.200
     1.013    22.246     0.200
     1.033    23.545     0.200
     1.076    22.289     0.200
     1.099    23.969     0.200
     0.947    22.540     0.200
     0.967    20.937     0.200
     1.026    23.561     0.200
     1.079    24.193     0.200
     1.130    25.148     0.200
     1.163    26.163     0.200
     1.250    26.216     0.200
     1.573    31.308     0.200
     4.744    68.525     0.200
     5.336    81.518     0.200
     5.479    82.142     0.200
     8.409   123.275     0.200
     8.749   124.313     0.200
     8.738   127.105     0.200
     0.951    21.720     0.200
     0.951    22.591     0.200
     0.961    23.636     0.200
     1.123    25.708     0.200
     1.133    24.252     0.200
     1.156    26.014     0.200
     1.243    27.351     0.200
     1.277    26.848     0.200
     1.333    28.971     0.200
     1.340    26.713     0.200
     1.397    29.146     0.200
     1.552    30.125     0.200
     1.566    30.946     0.200
     3.125    53.508     0.200
     4.192    62.335     0.200
     5.485    81.949     0.200
     7.875   113.737     0.200
     8.261   118.931     0.200
     8.407   124.046     0.200
     8.739   123.652     0.200
     8.757   126.076     0.200
     9.736   140.057     0.200
     9.824   141.368     0.200
     1.086    23.874     0.200
     1.134    25.147     0.200
     1.142    23.753     0.200
     1.166    25.756     0.200
     1.210    24.247     0.200
     1.210    26.225     0.200
     1.252    26.606     0.200
     1.343    26.205     0.200
     1.567    31.076     0.200
     3.121    49.854     0.200
     1.344    29.094     0.200
     0.882    20.121     0.200
     0.888    20.177     0.200
     0.936    20.115     0.200
     0.937    20.449     0.200
     0.957    20.126     0.200
     0.966    19.928     0.200
     0.965    21.312     0.200
     0.985    19.970     0.200
     1.097    21.785     0.200
     1.148    24.808     0.200
     1.157    22.676     0.200
     1.181    25.489     0.200
     1.225    23.554     0.200
     1.224    26.163     0.200
     1.267    26.186     0.200
     1.319    28.587     0.200
     1.357    25.908     0.200
     1.358    28.977     0.200
     1.360    28.914     0.200
     1.376    29.423     0.200
     1.407    29.741     0.200
     1.421    28.298     0.200
     1.478    27.539     0.200
     0.897    19.723     0.200
     0.943    21.476     0.200
     1.151    25.220     0.200
     1.158    23.597     0.200
     1.286    24.909     0.200
     1.352    26.140     0.200
     1.135    22.571     0.200
     1.195    24.418     0.200
     1.347    25.918     0.200
     0.947    20.605     0.200
     1.024    21.399     0.200
     0.870    19.624     0.200
     0.919    21.179     0.200
     0.890    20.404     0.200
     0.917    20.751     0.200
     0.936    21.412     0.200
     0.959    20.293     0.200
     1.078    23.539     0.200
     1.118    23.592     0.200
     1.247    24.094     0.200
     1.312    25.251     0.200
     4.218    60.133     0.200
     1.082    23.956     0.200
     1.391    30.082     0.200
     1.466    28.530     0.200
     0.978    20.739     0.200
     1.053    21.914     0.200
     0.928    20.903     0.200
     1.140    25.046     0.200
     1.150    23.218     0.200
     1.172    23.247     0.200
     1.199    25.049     0.200
     1.219    23.994     0.200
     1.216    26.431     0.200
     1.249    27.627     0.200
     1.309    25.422     0.200
     1.311    28.134     0.200
     1.353    26.064     0.200
     1.353    26.124     0.200
     1.475    28.188     0.200
     1.865    32.805     0.200
     4.196    62.346     0.200
     0.829    17.328     0.200
     1.086    22.895     0.200
     1.018    20.264     0.200
     1.273    24.708     0.200
     1.294    24.984     0.200
     1.294    24.262     0.200
     0.889    20.608     0.200
     0.959    21.329     0.200
     1.189    25.130     0.200
     1.280    24.790     0.200
     1.302    25.752     0.200
     1.345    26.261     0.200
     4.207    60.576     0.200
     1.047    23.438     0.200
     1.199    26.069     0.200
     1.282    25.709     0.200
     1.319    26.318     0.200
     1.328    26.573     0.200
     1.366    29.148     0.200
     1.382    28.548     0.200
     1.451    28.389     0.200
     1.451    29.258     0.200
     1.003    23.753     0.200
     1.025    23.717     0.200
     1.058    24.059     0.200
     1.156    25.031     0.200
     1.187    24.547     0.200
     1.180    25.952     0.200
     1.189    24.708     0.200
     1.261    26.440     0.200
     0.988    22.672     0.200
     0.988    21.375     0.200
     1.169    23.143     0.200
     1.240    23.874     0.200
     1.300    26.410     0.200
     1.331    25.784     0.200
     1.375    26.224     0.200
     1.370    26.196     0.200
     1.369    28.531     0.200
     1.363    28.842     0.200
     1.385    28.927     0.200
     1.417    29.698     0.200
     1.434    28.186     0.200
     0.989    24.003     0.200
     0.957    21.334     0.200
     1.137    24.157     0.200
     1.177    25.925     0.200
     1.235    25.382     0.200
     1.358    27.136     0.200
     0.939    20.380     0.200
     0.964    21.016     0.200
     0.982    21.258     0.200
     0.982    21.848     0.200
     1.289    24.841     0.200
     1.289    25.461     0.200
     1.289    26.060     0.200
     1.311    25.558     0.200
     1.354    26.172     0.200
     1.475    28.016     0.200
     1.025    21.988     0.200
     1.040    23.003     0.200
     1.048    21.522     0.200
     1.048    22.422     0.200
     1.127    24.848     0.200
     1.144    23.789     0.200
     1.223    24.101     0.200
     1.278    24.912     0.200
     1.266    26.749     0.200
     1.347    29.011     0.200
     1.391    26.664     0.200
     1.444    27.932     0.200
     1.564    30.372     0.200
     0.896    19.099     0.200
     0.924    20.649     0.200
     0.991    22.817     0.200
     1.031    23.342     0.200
     1.039    21.241     0.200
     1.058    22.698     0.200
     1.128    22.726     0.200
     1.178    24.777     0.200
     1.236    24.283     0.200
     1.288    27.604     0.200
     1.303    26.359     0.200
     1.293    26.068     0.200
     1.332    26.558     0.200
     0.987    22.459     0.200
     1.028    22.824     0.200
     1.177    26.121     0.200
     1.235    25.257     0.200
     1.288    26.073     0.200
     1.317    28.261     0.200
     1.359    27.145     0.200
     1.350    30.033     0.200
     1.418    30.595     0.200
     1.430    29.959     0.200
     1.455    31.350     0.200
     1.476    29.856     0.200
     1.495    28.862     0.200
     1.524    31.544     0.200
     1.546    29.963     0.200
     1.546    30.063     0.200
     1.673    32.504     0.200
     0.988    20.669     0.200
     0.985    20.517     0.200
     0.985    21.947     0.200
     1.069    21.836     0.200
     1.093    21.890     0.200
     1.238    24.041     0.200
     1.280    24.596     0.200
     1.281    24.845     0.200
     1.283    25.460     0.200
     0.781    16.385     0.200
     0.781    17.485     0.200
     0.927    19.552     0.200
     0.973    21.784     0.200
     1.000    19.946     0.200
     1.084    23.524     0.200
     1.053    22.349     0.200
     1.190    22.450     0.200
     1.314    27.798     0.200
     1.674    28.931     0.200
     4.426    66.042     0.200
     6.955    98.866     0.200
     1.180    24.408     0.200
     1.415    28.432     0.200
     1.579    30.511     0.200
     1.579    30.341     0.200
     4.661    71.434     0.200
     0.934    20.061     0.200
     1.083    22.814     0.200
     1.083    24.178     0.200
     1.276    25.131     0.200
     1.311    26.510     0.200
     1.381    27.275     0.200
     1.489    28.454     0.200
     1.503    28.887     0.200
     1.583    30.117     0.200
     1.587    30.217     0.200
     0.897    21.158     0.200
     1.058    22.444     0.200
     1.087    22.128     0.200
     1.086    23.731     0.200
     1.086    22.102     0.200
     1.148    23.129     0.200
     1.152    23.598     0.200
     1.218    24.075     0.200
     1.281    24.857     0.200
     1.385    28.187     0.200
     1.402    26.764     0.200
     1.476    28.958     0.200
     1.494    28.699     0.200
     1.508    28.913     0.200
     1.757    29.545     0.200
     3.183    51.253     0.200
     5.177    76.392     0.200
     1.070    25.038     0.200
     1.072    23.184     0.200
     1.175    26.928     0.200
     1.240    28.217     0.200
     1.241    25.748     0.200
     1.370    28.710     0.200
     1.487    28.975     0.200
     1.502    30.841     0.200
     1.584    30.706     0.200
     1.584    31.043     0.200
     1.635    32.060     0.200
     1.649    31.850     0.200
     1.688    35.059     0.200
     1.754    33.104     0.200
     3.193    51.755     0.200
     4.214    61.306     0.200
     1.772    33.371     0.200
     1.084    24.521     0.200
     1.276    25.670     0.200
     1.396    27.507     0.200
     1.311    28.468     0.200
     1.338    29.131     0.200
     1.382    28.611     0.200
     1.458    28.340     0.200
     1.488    28.714     0.200
     1.562    30.530     0.200
     0.890    20.450     0.200
     0.977    20.460     0.200
     0.973    22.766     0.200
     0.973    21.336     0.200
     1.225    24.083     0.200
     0.986    22.990     0.200
     0.927    21.333     0.200
     0.950    22.074     0.200
     1.104    23.444     0.200
     1.150    24.035     0.200
     1.242    25.323     0.200
     1.303    25.702     0.200
     1.368    27.568     0.200
     1.423    27.294     0.200
     1.486    28.374     0.200
     1.498    29.996     0.200
     1.515    28.591     0.200
     1.515    28.861     0.200
     1.529    30.137     0.200
     4.216    66.137     0.200
     4.787    70.387     0.200
     5.372    81.271     0.200
     0.923    20.664     0.200
     0.945    20.719     0.200
     1.065    23.329     0.200
     0.993    21.938     0.200
     0.993    22.387     0.200
     0.995    20.985     0.200
     1.304    26.365     0.200
     1.405    27.857     0.200
     1.405    27.435     0.200
     1.490    28.922     0.200
     1.490    28.762     0.200
     0.978    22.233     0.200
     1.149    24.430     0.200
     1.412    29.269     0.200
     1.522    30.386     0.200
     1.531    29.747     0.200
     1.608    32.105     0.200
     1.635    31.930     0.200
     1.658    31.542     0.200
     0.900    18.186     0.200
     0.916    20.832     0.200
     0.978    19.718     0.200
     0.979    19.310     0.200
     1.000    20.659     0.200
     0.996    20.119     0.200
     0.996    19.619     0.200
     1.002    19.483     0.200
     1.081    21.833     0.200
     1.111    21.996     0.200
     1.113    22.507     0.200
     1.143    22.365     0.200
     1.263    24.389     0.200
     1.258    23.881     0.200
     1.322    24.398     0.200
     1.056    23.595     0.200
     1.354    27.136     0.200
     1.519    29.261     0.200
     1.975    32.317     0.200
     2.289    36.894     0.200
     0.923    20.351     0.200
     0.977    22.281     0.200
     1.056    24.324     0.200
     1.524    28.904     0.200
     4.038    60.850     0.200
     6.456    90.058     0.200
     0.995    22.927     0.200
     0.995    23.310     0.200
     1.123    23.486     0.200
     1.256    25.538     0.200
     1.368    27.144     0.200
     1.401    28.098     0.200
     1.401    29.309     0.200
     1.453    30.703     0.200
     1.479    29.010     0.200
     1.487    28.832     0.200
     1.532    29.709     0.200
     1.541    31.734     0.200
     1.542    30.111     0.200
     1.542    29.721     0.200
     1.667    31.260     0.200
     1.923    32.575     0.200
     0.939    21.737     0.200
     1.060    22.715     0.200
     1.323    25.578     0.200
     1.508    29.036     0.200
     0.927    21.410     0.200
     0.978    22.143     0.200
     0.978    21.221     0.200
     1.044    22.749     0.200
     1.046    22.172     0.200
     1.086    22.547     0.200
     1.148    25.991     0.200
     1.163    24.441     0.200
     1.188    23.997     0.200
     1.222    26.302     0.200
     1.312    26.635     0.200
     1.376    26.685     0.200
     1.497    28.952     0.200
     1.497    29.074     0.200
     1.588    30.061     0.200
     4.177    62.754     0.200
     0.982    22.905     0.200
     1.499    29.076     0.200
     0.983    22.435     0.200
     1.335    26.018     0.200
     1.523    30.682     0.200
     0.940    21.012     0.200
     0.991    22.513     0.200
     1.442    30.544     0.200
     1.532    30.284     0.200
     1.501    28.887     0.200
     1.591    30.741     0.200
     1.331    25.939     0.200
     1.365    29.647     0.200
     1.369    26.643     0.200
     1.377    27.012     0.200
     1.499    29.087     0.200
     1.695    33.990     0.200
     1.494    29.333     0.200
     1.494    29.224     0.200
     1.676    32.702     0.200
     0.928    20.777     0.200
     0.939    21.375     0.200
     0.962    22.031     0.200
     0.979    20.993     0.200
     0.979    20.841     0.200
     1.046    22.178     0.200
     1.087    22.164     0.200
     1.148    25.167     0.200
     1.162    23.328     0.200
     1.221    25.214     0.200
     1.311    25.585     0.200
     0.931    21.441     0.200
     0.983    22.284     0.200
     0.983    22.744     0.200
     1.153    25.293     0.200
     1.168    23.776     0.200
     1.382    26.639     0.200
     1.594    29.872     0.200
     1.683    31.214     0.200
     0.929    20.052     0.200
     0.987    23.016     0.200
     0.987    20.805     0.200
     0.998    22.250     0.200
     0.998    23.830     0.200
     1.232    25.463     0.200
     1.248    24.459     0.200
     1.271    27.969     0.200
     1.284    27.790     0.200
     1.322    26.621     0.200
     1.322    26.751     0.200
     1.340    26.101     0.200
     1.361    29.134     0.200
     1.374    29.417     0.200
     1.378    26.693     0.200
     1.385    26.875     0.200
     1.386    26.706     0.200
     1.386    27.456     0.200
     1.387    29.831     0.200
     1.420    30.212     0.200
     1.440    28.839     0.200
     1.474    29.592     0.200
     1.497    31.052     0.200
     1.506    28.945     0.200
     1.507    28.732     0.200
     1.557    30.225     0.200
     1.568    29.856     0.200
     2.259    39.120     0.200
     4.177    62.618     0.200
     4.709    71.180     0.200
     5.073    76.480     0.200
     5.308    80.498     0.200
     5.441    80.359     0.200
     6.640    90.858     0.200
     7.833   108.290     0.200
     0.984    21.975     0.200
     0.964    22.291     0.200
     0.964    22.440     0.200
     1.306    25.467     0.200
     1.450    28.500     0.200
     0.987    22.336     0.200
     0.987    24.067     0.200
     1.160    26.159     0.200
     2.248    36.276     0.200
     1.021    21.503     0.200
     1.021    22.823     0.200
     0.929    21.291     0.200
     0.979    21.451     0.200
     0.979    21.990     0.200
     1.045    21.632     0.200
     1.427    27.455     0.200
     1.492    28.501     0.200
     0.921    21.557     0.200
     0.954    22.487     0.200
     0.971    21.961     0.200
     0.971    22.081     0.200
     0.986    23.673     0.200
     1.178    23.567     0.200
     1.213    25.147     0.200
     1.366    26.444     0.200
     1.487    28.522     0.200
     0.970    20.548     0.200
     1.036    23.892     0.200
     1.213    25.468     0.200
     1.668    31.653     0.200
     2.427    40.304     0.200
     0.929    21.248     0.200
     0.979    21.681     0.200
     0.979    20.658     0.200
     1.488    28.131     0.200
     0.970    21.723     0.200
     1.146    23.921     0.200
     0.981    21.782     0.200
     0.981    23.211     0.200
     1.498    29.074     0.200
     0.935    21.204     0.200
     0.986    21.956     0.200
     1.333    26.050     0.200
     1.499    28.517     0.200
     0.927    21.312     0.200
     0.977    21.931     0.200
     0.977    22.122     0.200
     1.043    21.636     0.200
     1.491    28.698     0.200
     0.924    21.423     0.200
     1.876    33.529     0.200
     1.895    33.719     0.200
     0.924    20.865     0.200
     0.974    20.822     0.200
     0.974    21.162     0.200
     1.040    23.794     0.200
     1.005    22.049     0.200
     1.019    20.837     0.200
     1.074    21.640     0.200
     1.074    21.101     0.200
     1.073    22.647     0.200
     1.073    21.483     0.200
     1.073    21.647     0.200
     1.169    23.737     0.200
     1.172    22.680     0.200
     1.203    23.684     0.200
     1.260    24.394     0.200
     1.266    25.534     0.200
     1.273    24.242     0.200
     1.328    25.195     0.200
     1.354    25.584     0.200
     1.371    26.052     0.200
     1.371    25.731     0.200
     1.393    26.122     0.200
     1.691    28.878     0.200
     1.770    31.271     0.200
     1.895    31.267     0.200
     1.971    32.412     0.200
     2.009    34.811     0.200
     2.078    35.800     0.200
     0.961    22.170     0.200
     0.935    20.014     0.200
     1.493    28.755     0.200
     2.021    33.012     0.200
     0.979    21.807     0.200
     1.081    23.804     0.200
     0.972    22.434     0.200
     0.963    20.394     0.200
     0.999    22.023     0.200
     1.265    26.703     0.200
     1.378    26.857     0.200
     1.346    28.794     0.200
     1.569    30.719     0.200
     1.615    30.125     0.200
     1.094    22.537     0.200
     1.107    23.112     0.200
     1.153    23.417     0.200
     1.160    24.630     0.200
     1.238    25.357     0.200
     1.230    23.825     0.200
     1.222    23.855     0.200
     1.315    25.374     0.200
     1.240    27.048     0.200
     1.326    26.644     0.200
     1.363    26.391     0.200
     1.430    27.234     0.200
     1.478    28.009     0.200
     1.414    29.791     0.200
     0.951    21.745     0.200
     0.968    22.167     0.200
     0.971    20.465     0.200
     0.983    21.409     0.200
     1.209    25.523     0.200
     1.298    26.137     0.200
     1.361    27.519     0.200
     1.482    28.248     0.200
     1.574    30.179     0.200
     1.027    23.887     0.200
     1.204    25.490     0.200
     1.476    28.420     0.200
     1.557    30.296     0.200
     1.035    21.450     0.200
     1.151    22.948     0.200
     1.316    25.405     0.200
     1.362    26.331     0.200
     1.363    26.226     0.200
     1.546    29.295     0.200
     0.984    20.355     0.200
     1.060    21.367     0.200
     1.187    23.227     0.200
     1.207    24.145     0.200
     1.274    25.788     0.200
     1.277    25.243     0.200
     1.291    25.152     0.200
     1.304    25.107     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
     6.299   123.387     0.200
     6.324   121.830     0.200
     7.138   142.246     0.200
     9.113   182.526     0.200
     9.142   183.826     0.200
     1.950    37.930     0.200
     2.461    47.490     0.200
     4.796    91.011     0.200
     7.463   149.521     0.200
     2.435    46.696     0.200
     7.436   149.233     0.200
     8.486   175.772     0.200
     1.828    36.424     0.200
     6.826   137.496     0.200
    10.692   217.473     0.200
     7.164   144.906     0.200
    12.123   244.803     0.200
     6.785   137.259     0.200
     8.908   176.874     0.200
     1.780    34.208     0.200
     5.105   102.698     0.200
     4.599    92.873     0.200
     5.857   111.667     0.200
     6.306   125.284     0.200
     6.821   135.349     0.200
    11.110   218.578     0.200
     1.532    28.926     0.200
     1.958    38.276     0.200
     2.301    44.251     0.200
     2.684    51.674     0.200
     2.909    55.727     0.200
     1.852    35.746     0.200
     3.562    68.543     0.200
     5.167    99.689     0.200
     8.989   177.137     0.200
     1.761    33.899     0.200
     1.761    33.397     0.200
     1.901    36.232     0.200
     1.935    37.296     0.200
     2.159    41.740     0.200
     2.461    47.606     0.200
     2.504    47.979     0.200
     6.766   135.229     0.200
     8.440   172.482     0.200
     1.315    25.192     0.200
     1.316    25.183     0.200
     2.020    38.876     0.200
     2.020    38.987     0.200
     2.020    38.592     0.200
     2.744    51.569     0.200
     3.729    72.408     0.200
     4.530    86.667     0.200
     2.426    47.225     0.200
     3.163    60.817     0.200
     3.761    72.487     0.200
     4.128    80.766     0.200
     4.522    87.344     0.200
     4.674    89.746     0.200
     4.969    94.053     0.200
     5.008    97.886     0.200
     7.460   149.323     0.200
     7.460   149.315     0.200
     8.531   172.296     0.200
    10.534   217.211     0.200
     1.668    34.829     0.200
     1.735    33.826     0.200
     2.424    46.985     0.200
     2.424    48.450     0.200
     2.731    54.200     0.200
     3.161    61.586     0.200
     3.725    70.145     0.200
     3.760    72.713     0.200
     4.026    76.910     0.200
     4.127    80.520     0.200
     4.207    79.166     0.200
     4.520    86.525     0.200
     4.668    89.158     0.200
     4.965    94.037     0.200
     5.006    96.985     0.200
     5.374   102.799     0.200
     5.877   116.177     0.200
     6.903   141.703     0.200
     7.459   148.844     0.200
     9.455   186.107     0.200
     1.731    33.821     0.200
     2.420    47.131     0.200
     3.156    60.556     0.200
     3.291    62.340     0.200
     3.723    71.446     0.200
     3.755    72.676     0.200
     4.122    79.964     0.200
     4.666    89.263     0.200
     7.454   148.714     0.200
     2.024    38.304     0.200
     2.430    48.135     0.200
     3.166    61.787     0.200
     3.296    63.348     0.200
     7.464   150.172     0.200
     8.551   173.004     0.200
    10.551   211.416     0.200
     1.737    34.006     0.200
     2.024    38.254     0.200
     2.426    47.120     0.200
     3.163    60.960     0.200
     3.729    71.058     0.200
     3.762    73.075     0.200
     4.129    81.535     0.200
     1.686    34.274     0.200
     1.753    33.914     0.200
     2.442    47.070     0.200
     2.442    46.844     0.200
     3.178    60.896     0.200
     3.308    62.539     0.200
     3.606    71.955     0.200
     3.741    71.069     0.200
     3.777    73.120     0.200
     4.145    80.129     0.200
     4.537    87.270     0.200
     4.660    90.864     0.200
     4.685    89.199     0.200
     5.024    98.090     0.200
     1.655    31.530     0.200
     1.673    34.753     0.200
     1.746    33.970     0.200
     1.904    38.027     0.200
     1.904    36.476     0.200
     2.433    46.707     0.200
     3.171    61.231     0.200
     3.308    62.274     0.200
     3.412    64.084     0.200
     3.739    70.721     0.200
     3.769    73.421     0.200
     3.834    78.375     0.200
     4.041    76.731     0.200
     4.135    81.577     0.200
     4.530    87.690     0.200
     4.682    89.682     0.200
     5.016    97.988     0.200
     5.235   107.687     0.200
     5.250   109.646     0.200
     5.280   105.119     0.200
     5.387   103.019     0.200
     5.536   114.591     0.200
     7.468   150.649     0.200
     8.367   169.727     0.200
     2.407    45.365     0.200
     2.955    56.014     0.200
     3.397    65.752     0.200
     3.444    65.909     0.200
     3.564    68.825     0.200
     3.950    76.139     0.200
     4.498    85.918     0.200
     4.718    88.762     0.200
     4.806    92.068     0.200
     7.261   145.740     0.200
    10.883   218.205     0.200
     1.748    34.159     0.200
     2.032    38.159     0.200
     2.437    47.847     0.200
     2.437    48.652     0.200
     2.437    46.554     0.200
     3.158    61.806     0.200
     3.173    62.428     0.200
     3.411    65.324     0.200
     3.576    67.971     0.200
     3.736    71.946     0.200
     3.773    73.343     0.200
     4.105    77.317     0.200
     4.218    80.535     0.200
     4.532    85.940     0.200
     4.679    90.029     0.200
     1.743    33.266     0.200
     1.914    38.593     0.200
     2.432    47.250     0.200
     2.662    50.837     0.200
     3.168    61.119     0.200
     3.406    64.577     0.200
     4.100    77.441     0.200
     4.972    94.012     0.200
     1.746    34.315     0.200
     1.924    36.968     0.200
     2.028    38.331     0.200
     2.436    46.689     0.200
     1.743    33.607     0.200
     2.029    38.403     0.200
     2.432    47.704     0.200
     3.168    61.448     0.200
     3.407    64.231     0.200
     3.733    71.228     0.200
     4.034    77.893     0.200
     4.101    77.442     0.200
     4.216    81.127     0.200
     4.974    94.268     0.200
     1.660    31.407     0.200
     1.755    33.910     0.200
     1.928    36.916     0.200
     2.038    38.295     0.200
     2.445    47.142     0.200
     3.164    61.084     0.200
     3.181    61.334     0.200
     3.583    68.075     0.200
     3.603    70.288     0.200
     4.112    77.465     0.200
     4.148    81.677     0.200
     1.920    37.075     0.200
     2.018    38.598     0.200
     2.427    46.818     0.200
     2.427    47.943     0.200
     3.163    62.015     0.200
     3.762    72.870     0.200
     4.020    77.448     0.200
     8.803   178.877     0.200
    11.241   242.202     0.200
     1.737    33.844     0.200
     2.428    46.737     0.200
     2.428    47.817     0.200
     7.462   147.287     0.200
     1.909    36.491     0.200
     2.428    47.432     0.200
     2.428    49.078     0.200
     3.153    62.311     0.200
     3.403    65.887     0.200
     6.523   129.920     0.200
     7.430   148.925     0.200
     7.462   143.149     0.200
    11.873   231.068     0.200
    12.032   244.438     0.200
     1.874    35.783     0.200
     2.979    59.072     0.200
     5.748   120.275     0.200
     1.688    31.344     0.200
     1.918    39.105     0.200
     2.447    49.038     0.200
     2.679    51.238     0.200
     3.184    62.413     0.200
     3.318    64.814     0.200
     3.290    63.463     0.200
     3.424    64.727     0.200
     3.750    72.722     0.200
     3.783    74.187     0.200
     7.482   149.683     0.200
     8.538   170.406     0.200
     1.812    34.305     0.200
     2.499    47.475     0.200
     2.734    51.219     0.200
     2.800    55.423     0.200
     3.237    61.505     0.200
     3.228    62.598     0.200
     3.373    64.662     0.200
     3.478    65.987     0.200
     3.659    75.399     0.200
     3.805    71.866     0.200
     4.250    86.565     0.200
     4.105    77.833     0.200
     4.172    78.244     0.200
     4.748    90.366     0.200
     5.044    94.479     0.200
     2.462    47.604     0.200
     2.462    48.323     0.200
     2.697    51.307     0.200
     3.200    62.085     0.200
     3.769    72.008     0.200
     4.071    78.422     0.200
     4.135    77.914     0.200
     4.560    88.933     0.200
     4.712    89.230     0.200
     5.008    95.632     0.200
     5.045    97.739     0.200
     7.497   150.624     0.200
     1.785    35.135     0.200
     2.075    39.030     0.200
     2.472    47.661     0.200
     2.707    51.589     0.200
     3.205    63.100     0.200
     3.209    61.322     0.200
     3.348    64.478     0.200
     3.452    65.491     0.200
     3.631    75.070     0.200
     3.780    73.006     0.200
     4.145    78.088     0.200
     7.506   148.931     0.200
     2.024    38.379     0.200
     2.423    48.298     0.200
     2.430    48.428     0.200
     3.166    62.159     0.200
     3.728    72.979     0.200
     3.765    73.245     0.200
     4.286    87.321     0.200
     4.524    87.668     0.200
     4.672    89.596     0.200
     4.970    94.896     0.200
     5.246   107.811     0.200
     7.064   144.327     0.200
     8.989   189.965     0.200
     9.438   193.988     0.200
     1.427    26.696     0.200
     1.857    35.239     0.200
     1.857    35.458     0.200
     2.581    49.069     0.200
     3.186    60.103     0.200
     4.069    77.236     0.200
     4.370    83.748     0.200
     1.251    23.226     0.200
     1.564    29.771     0.200
     2.228    42.942     0.200
     2.228    41.657     0.200
     2.374    48.097     0.200
     1.691    31.799     0.200
     1.729    32.934     0.200
     1.759    34.146     0.200
     1.972    37.513     0.200
     2.021    39.223     0.200
     2.099    39.992     0.200
     4.335    81.883     0.200
     1.894    36.830     0.200
     1.974    38.584     0.200
     1.815    34.217     0.200
     2.085    40.428     0.200
     2.358    46.018     0.200
     2.416    45.649     0.200
     2.893    56.126     0.200
     3.101    59.467     0.200
     3.511    66.592     0.200
     3.849    72.329     0.200
     4.256    81.657     0.200
     4.444    83.448     0.200
     1.895    36.959     0.200
     1.975    38.276     0.200
     2.193    41.679     0.200
     2.846    55.429     0.200
     2.937    55.179     0.200
     3.268    62.725     0.200
     3.682    70.111     0.200
     2.415    46.276     0.200
     5.060   100.683     0.200
    10.775   216.489     0.200
     1.560    28.945     0.200
     1.915    36.010     0.200
     2.397    45.547     0.200
     2.399    45.759     0.200
     2.399    45.259     0.200
     2.399    46.841     0.200
     3.119    59.994     0.200
     3.466    65.595     0.200
     3.479    66.123     0.200
     3.616    69.888     0.200
     3.726    71.760     0.200
     4.015    75.737     0.200
     4.109    81.806     0.200
     4.888    92.065     0.200
     1.186    22.055     0.200
     1.186    22.366     0.200
     1.330    25.081     0.200
     1.555    32.318     0.200
     1.600    30.002     0.200
     1.699    32.017     0.200
     2.044    38.006     0.200
     2.754    51.430     0.200
     1.930    36.508     0.200
     2.403    47.144     0.200
     2.410    47.011     0.200
     3.332    63.698     0.200
     3.631    70.929     0.200
     7.437   149.704     0.200
     9.501   189.664     0.200
    10.758   214.321     0.200
     1.898    36.207     0.200
     2.203    43.116     0.200
     3.917    73.997     0.200
     1.606    31.599     0.200
     1.647    32.314     0.200
     1.974    37.917     0.200
     2.648    50.198     0.200
     3.392    64.366     0.200
     3.421    65.759     0.200
     3.790    77.420     0.200
     4.336    88.754     0.200
     1.509    28.698     0.200
     1.911    35.846     0.200
     2.213    43.047     0.200
     2.220    43.187     0.200
     1.705    32.153     0.200
     1.760    33.421     0.200
     1.910    35.906     0.200
     2.496    47.251     0.200
     3.085    58.457     0.200
     3.924    73.720     0.200
     1.339    25.555     0.200
     2.501    46.774     0.200
     3.087    59.803     0.200
     3.243    60.886     0.200
     4.088    76.863     0.200
     4.532    85.274     0.200
     2.215    43.446     0.200
     2.346    44.862     0.200
     2.502    47.374     0.200
     3.945    74.738     0.200
     4.533    85.050     0.200
     1.570    29.319     0.200
     1.701    32.144     0.200
     1.706    34.706     0.200
     1.924    35.871     0.200
     2.037    40.817     0.200
     2.409    45.568     0.200
     1.096    20.542     0.200
     1.186    21.891     0.200
     1.300    24.063     0.200
     1.300    24.050     0.200
     1.319    24.282     0.200
     1.441    27.305     0.200
     1.614    29.797     0.200
     1.786    33.372     0.200
     1.271    23.915     0.200
     1.559    29.432     0.200
     1.607    30.296     0.200
     1.642    32.747     0.200
     2.267    43.526     0.200
     3.015    57.334     0.200
     1.135    21.188     0.200
     1.137    21.684     0.200
     1.137    21.844     0.200
     1.234    22.797     0.200
     1.337    24.817     0.200
     1.365    25.315     0.200
     1.397    25.917     0.200
     1.510    28.437     0.200
     1.670    31.061     0.200
     1.854    34.824     0.200
     2.557    47.673     0.200
     1.703    34.041     0.200
     1.697    32.203     0.200
     2.035    40.653     0.200
     2.405    45.515     0.200
     2.752    53.641     0.200
     3.125    59.251     0.200
     3.541    70.499     0.200
     3.594    71.347     0.200
     3.621    68.238     0.200
     3.732    71.683     0.200
     4.115    80.130     0.200
     4.183    82.478     0.200
     4.572    86.081     0.200
     4.655    90.497     0.200
     4.894    91.711     0.200
     4.976    95.665     0.200
     7.431   149.923     0.200
     1.178    22.859     0.200
     1.275    24.298     0.200
     1.381    25.826     0.200
     1.438    26.943     0.200
     1.617    31.143     0.200
     1.617    31.320     0.200
     2.166    41.732     0.200
     2.910    55.102     0.200
     3.869    72.784     0.200
     1.693    32.263     0.200
     1.729    33.347     0.200
     1.729    32.902     0.200
     2.080    39.394     0.200
     2.089    40.261     0.200
     2.376    46.120     0.200
     2.680    50.362     0.200
     3.027    59.130     0.200
     1.218    22.866     0.200
     1.260    23.906     0.200
     1.334    25.278     0.200
     1.422    26.353     0.200
     1.473    29.642     0.200
     1.605    29.913     0.200
     1.620    31.089     0.200
     1.636    30.502     0.200
     1.925    36.929     0.200
     1.638    30.966     0.200
     1.658    33.433     0.200
     1.658    33.146     0.200
     2.181    41.854     0.200
     2.188    42.916     0.200
     2.188    42.513     0.200
     2.449    45.801     0.200
     4.294    80.490     0.200
     7.222   144.317     0.200
     8.400   167.133     0.200
     8.772   177.322     0.200
     9.198   184.557     0.200
    10.554   208.409     0.200
    11.655   227.216     0.200
    16.749   332.182     0.200
    23.799   472.576     0.200
    26.785   534.069     0.200
     1.331    25.450     0.200
     1.543    28.928     0.200
     1.641    30.778     0.200
     1.641    31.406     0.200
     1.842    34.606     0.200
     1.873    35.093     0.200
     1.177    22.312     0.200
     1.196    23.115     0.200
     1.267    23.951     0.200
     1.331    25.077     0.200
     1.522    28.992     0.200
     1.543    28.848     0.200
     1.556    31.394     0.200
     1.676    32.157     0.200
     1.179    22.839     0.200
     1.197    22.926     0.200
     1.197    22.691     0.200
     1.268    23.845     0.200
     1.332    24.666     0.200
     1.453    27.198     0.200
     1.522    28.941     0.200
     1.544    29.052     0.200
     1.674    33.720     0.200
     1.748    34.574     0.200
     2.199    41.792     0.200
     3.536    68.520     0.200
     4.303    81.578     0.200
     4.782    92.669     0.200
     1.094    20.530     0.200
     1.290    23.864     0.200
     1.574    30.469     0.200
     1.607    29.686     0.200
     2.040    38.549     0.200
     1.377    25.759     0.200
     1.418    27.424     0.200
     1.432    27.947     0.200
     1.471    27.426     0.200
     1.426    28.611     0.200
     1.722    32.889     0.200
     1.716    34.408     0.200
     2.031    40.478     0.200
     2.421    46.101     0.200
     2.427    46.359     0.200
     3.150    59.411     0.200
     1.738    33.914     0.200
     1.798    35.570     0.200
     1.810    37.385     0.200
     1.829    35.207     0.200
     1.928    36.584     0.200
     1.994    38.056     0.200
     2.128    40.543     0.200
     2.133    40.259     0.200
     2.159    41.150     0.200
     2.381    45.725     0.200
     1.442    27.762     0.200
     1.453    28.225     0.200
     1.534    28.778     0.200
     1.662    33.421     0.200
     1.785    34.169     0.200
     1.819    36.126     0.200
     2.453    47.680     0.200
     3.199    61.712     0.200
     3.467    64.421     0.200
     4.157    77.895     0.200
     4.563    87.594     0.200
     4.749    89.639     0.200
     1.198    22.058     0.200
     1.573    29.518     0.200
     1.725    34.840     0.200
     2.017    38.943     0.200
     2.017    39.107     0.200
     2.017    38.263     0.200
     2.741    51.912     0.200
     3.205    64.042     0.200
     3.278    62.777     0.200
     3.346    64.726     0.200
     3.726    71.919     0.200
     4.093    77.960     0.200
     4.222    81.335     0.200
     4.266    82.041     0.200
     7.045   142.263     0.200
     1.927    36.541     0.200
     2.233    43.275     0.200
     2.518    47.676     0.200
     3.099    59.356     0.200
     1.757    34.404     0.200
     2.136    42.364     0.200
     2.469    46.599     0.200
     2.959    58.874     0.200
     3.568    70.584     0.200
     4.320    84.034     0.200
     1.826    34.180     0.200
     1.869    36.129     0.200
     2.913    55.462     0.200
     2.869    55.158     0.200
     3.191    63.169     0.200
     3.597    68.501     0.200
     3.643    68.365     0.200
     2.143    41.830     0.200
     2.150    42.126     0.200
     3.855    72.604     0.200
     1.189    22.415     0.200
     1.450    27.803     0.200
     1.502    30.554     0.200
     1.531    29.455     0.200
     1.556    30.584     0.200
     1.646    32.322     0.200
     1.664    33.774     0.200
     1.720    34.461     0.200
     1.730    32.859     0.200
     1.730    33.188     0.200
     2.109    39.856     0.200
     1.223    22.646     0.200
     1.223    23.513     0.200
     1.367    25.546     0.200
     1.387    26.130     0.200
     1.429    28.287     0.200
     1.438    26.460     0.200
     1.512    28.725     0.200
     1.526    29.239     0.200
     1.869    35.213     0.200
     2.226    42.770     0.200
     2.591    49.014     0.200
     2.808    52.261     0.200
     1.634    31.069     0.200
     1.815    34.685     0.200
     1.171    21.722     0.200
     1.376    25.394     0.200
     1.376    25.422     0.200
     1.388    25.931     0.200
     1.468    27.853     0.200
     1.487    28.571     0.200
     1.675    31.086     0.200
     1.751    33.424     0.200
     1.816    35.871     0.200
     1.830    35.155     0.200
     2.549    48.396     0.200
     1.121    21.538     0.200
     1.172    21.694     0.200
     1.255    23.202     0.200
     1.376    25.343     0.200
     1.389    25.913     0.200
     1.468    27.725     0.200
     1.487    28.266     0.200
     1.751    33.588     0.200
     1.182    22.227     0.200
     1.200    22.468     0.200
     1.572    29.182     0.200
     1.588    29.481     0.200
     1.684    32.168     0.200
     1.876    34.660     0.200
     1.347    25.007     0.200
     1.432    27.264     0.200
     1.432    27.061     0.200
     1.432    27.373     0.200
     1.447    27.030     0.200
     1.491    30.979     0.200
     1.527    28.578     0.200
     1.582    32.690     0.200
     1.650    30.625     0.200
     1.650    30.891     0.200
     1.650    31.555     0.200
     1.680    32.883     0.200
     1.713    32.474     0.200
     1.745    32.720     0.200
     1.919    36.083     0.200
     2.435    45.899     0.200
     2.435    46.469     0.200
     2.945    58.600     0.200
     3.171    59.684     0.200
     3.300    61.460     0.200
     3.733    70.476     0.200
     4.939    93.336     0.200
     7.469   149.724     0.200
     1.381    26.785     0.200
     1.430    29.540     0.200
     1.444    28.850     0.200
     1.445    27.634     0.200
     1.459    30.934     0.200
     1.463    28.483     0.200
     1.532    31.325     0.200
     1.551    29.714     0.200
     1.551    29.504     0.200
     1.610    30.607     0.200
     1.637    31.308     0.200
     1.730    32.828     0.200
     1.765    34.484     0.200
     1.782    33.947     0.200
     2.441    46.858     0.200
     2.441    46.473     0.200
     3.189    60.503     0.200
     3.292    61.463     0.200
     3.415    63.882     0.200
     3.776    72.288     0.200
     4.125    79.141     0.200
     4.157    78.401     0.200
     4.756    89.443     0.200
     7.467   146.494     0.200
     8.294   161.869     0.200
     9.382   185.852     0.200
     1.086    20.648     0.200
     1.086    20.441     0.200
     1.209    22.628     0.200
     1.464    27.834     0.200
     1.550    29.298     0.200
     1.583    29.427     0.200
     1.589    31.878     0.200
     1.675    31.980     0.200
     1.131    21.182     0.200
     1.212    22.455     0.200
     1.336    24.770     0.200
     1.439    27.701     0.200
     1.693    32.554     0.200
     1.704    32.555     0.200
     1.776    33.989     0.200
     1.783    34.612     0.200
     1.783    33.824     0.200
     2.148    42.183     0.200
     2.502    48.114     0.200
     1.095    20.436     0.200
     1.095    20.905     0.200
     1.164    21.950     0.200
     1.286    23.743     0.200
     2.061    39.061     0.200
     2.797    53.543     0.200
     3.732    70.296     0.200
     1.505    31.611     0.200
     1.804    33.693     0.200
     1.804    34.201     0.200
     4.487    86.715     0.200
     1.240    23.389     0.200
     1.253    23.458     0.200
     1.375    25.572     0.200
     1.386    26.008     0.200
     1.672    31.190     0.200
     1.748    33.438     0.200
     1.821    35.016     0.200
     1.827    35.185     0.200
     1.827    34.927     0.200
     2.191    43.287     0.200
     2.545    48.482     0.200
     3.153    59.557     0.200
     1.354    25.784     0.200
     1.354    25.502     0.200
     1.475    27.518     0.200
     1.173    21.839     0.200
     1.671    31.570     0.200
     2.066    39.254     0.200
     2.177    40.936     0.200
     2.882    54.737     0.200
     1.327    25.338     0.200
     1.471    27.543     0.200
     1.787    33.644     0.200
     1.787    33.402     0.200
     2.054    38.766     0.200
     2.797    53.538     0.200
     3.485    65.388     0.200
     9.167   187.706     0.200
    10.769   214.386     0.200
     1.464    27.516     0.200
     1.690    32.418     0.200
     1.783    34.512     0.200
     1.798    35.286     0.200
     2.048    38.356     0.200
     2.524    48.829     0.200
     2.755    51.671     0.200
     2.792    52.155     0.200
     3.480    65.186     0.200
     1.259    23.734     0.200
     1.463    27.226     0.200
     1.721    31.965     0.200
     1.797    35.846     0.200
     1.230    23.610     0.200
     1.303    24.832     0.200
     1.474    27.682     0.200
     1.732    32.580     0.200
     1.336    25.563     0.200
     1.294    23.969     0.200
     1.469    27.697     0.200
     1.524    28.681     0.200
     1.566    29.911     0.200
     1.601    30.415     0.200
     1.654    31.972     0.200
     1.654    31.374     0.200
     1.691    32.010     0.200
     2.383    45.040     0.200
     7.418   146.448     0.200
     8.572   167.200     0.200
     9.427   184.495     0.200
    10.598   210.014     0.200
     1.099    21.095     0.200
     1.105    21.222     0.200
     1.308    24.329     0.200
     1.421    29.684     0.200
     1.474    29.533     0.200
     1.906    35.954     0.200
     6.924   141.878     0.200
     2.213    42.918     0.200
     8.409   167.982     0.200
     8.749   175.285     0.200
     9.223   180.644     0.200
    10.548   208.431     0.200
     2.198    43.883     0.200
     2.205    44.070     0.200
     7.238   143.235     0.200
     8.407   166.784     0.200
    10.551   210.427     0.200
    11.670   226.968     0.200
    12.224   246.765     0.200
     1.179    22.630     0.200
     1.201    23.018     0.200
     1.292    24.597     0.200
     1.292    24.144     0.200
     1.476    27.883     0.200
     1.567    29.590     0.200
     1.579    31.539     0.200
     1.698    33.283     0.200
     1.286    24.605     0.200
     1.574    31.044     0.200
     1.247    23.953     0.200
     3.152    63.609     0.200
     1.289    24.612     0.200
     1.289    24.714     0.200
     3.111    61.652     0.200
     1.338    25.291     0.200
     1.389    25.995     0.200
     1.423    26.990     0.200
     1.470    28.145     0.200
     1.459    27.631     0.200
     1.581    29.534     0.200
     1.891    37.262     0.200
     2.006    38.581     0.200
     2.018    38.399     0.200
     2.066    39.757     0.200
     2.127    41.067     0.200
     1.280    24.610     0.200
     1.527    29.182     0.200
     1.654    31.279     0.200
     1.722    32.507     0.200
     3.119    62.237     0.200
     1.707    32.515     0.200
     1.740    34.566     0.200
     1.752    34.140     0.200
     1.857    36.618     0.200
     1.875    36.328     0.200
     1.953    37.885     0.200
     2.144    41.838     0.200
     1.220    22.980     0.200
     1.311    24.610     0.200
     1.468    29.261     0.200
     1.495    28.390     0.200
     1.496    28.091     0.200
     1.558    29.259     0.200
     1.582    31.367     0.200
     1.633    31.572     0.200
     1.661    31.620     0.200
     1.576    30.600     0.200
     1.604    31.978     0.200
     1.702    32.937     0.200
     1.725    32.812     0.200
     1.756    33.216     0.200
     1.233    23.524     0.200
     1.271    24.266     0.200
     1.303    24.530     0.200
     1.303    24.249     0.200
     1.310    24.749     0.200
     1.312    24.691     0.200
     1.424    26.361     0.200
     1.696    33.620     0.200
     1.729    33.618     0.200
     1.864    35.234     0.200
     1.216    23.398     0.200
     1.084    19.835     0.200
     1.269    23.590     0.200
     1.344    28.447     0.200
     1.382    28.896     0.200
     1.992    37.545     0.200
     7.024   139.034     0.200
     1.691    37.101     0.200
     1.692    33.442     0.200
     1.694    32.328     0.200
     1.397    26.727     0.200
     1.397    26.518     0.200
     1.653    31.393     0.200
     1.649    31.883     0.200
     1.696    32.579     0.200
     1.826    34.856     0.200
     2.046    38.575     0.200
     1.588    30.773     0.200
     1.592    30.341     0.200
     1.658    31.319     0.200
     1.650    32.273     0.200
     1.701    32.643     0.200
     1.831    34.865     0.200
     2.041    38.248     0.200
     2.151    40.846     0.200
    10.596   209.820     0.200
     1.819    34.790     0.200
     1.811    35.863     0.200
     1.887    36.606     0.200
     1.918    38.324     0.200
     2.063    40.602     0.200
     2.064    40.522     0.200
     2.157    42.161     0.200
     1.653    31.101     0.200
     1.702    33.167     0.200
     2.047    41.142     0.200
     1.303    24.832     0.200
     1.563    30.805     0.200
     1.590    31.054     0.200
     1.614    30.644     0.200
     1.615    32.351     0.200
     1.668    33.174     0.200
     1.680    31.745     0.200
     1.694    33.001     0.200
     1.729    33.654     0.200
     1.794    34.201     0.200
     1.833    34.267     0.200
     1.853    35.458     0.200
     1.664    31.588     0.200
     1.798    34.021     0.200
     1.787    34.178     0.200
     1.816    33.941     0.200
     1.289    23.895     0.200
     1.726    32.775     0.200
     1.110    20.894     0.200
     1.185    22.116     0.200
     1.322    24.888     0.200
     1.322    25.048     0.200
     1.456    27.590     0.200
     1.598    29.925     0.200
     1.509    27.130     0.200
     1.698    32.483     0.200
     1.754    34.365     0.200
     1.661    31.620     0.200
     1.661    31.772     0.200
     1.713    33.383     0.200
     1.800    34.989     0.200
     1.816    35.345     0.200
     1.691    34.016     0.200
     1.686    31.950     0.200
     2.238    43.154     0.200
     7.272   145.219     0.200
     8.400   164.516     0.200
     9.242   183.698     0.200
    12.241   247.076     0.200
     1.945    38.647     0.200
     1.502    28.155     0.200
     1.720    34.861     0.200
     1.693    32.560     0.200
     1.520    26.993     0.200
     1.586    30.219     0.200
     3.090    63.357     0.200
     7.271   144.743     0.200
    10.527   211.896     0.200
     1.503    28.305     0.200
     1.692    31.702     0.200
     2.244    43.095     0.200
     7.278   144.137     0.200
     1.597    30.048     0.200
     1.610    30.760     0.200
     1.642    31.497     0.200
     1.639    34.878     0.200
     1.700    34.051     0.200
     1.722    34.946     0.200
     1.763    33.418     0.200
     2.249    42.538     0.200
     1.506    28.637     0.200
     1.913    36.757     0.200
     1.778    35.663     0.200
     1.874    36.779     0.200
     1.928    37.170     0.200
     2.269    43.698     0.200
     1.499    27.983     0.200
     1.583    29.714     0.200
     1.673    32.185     0.200
     1.578    30.084     0.200
     1.676    31.756     0.200
     1.877    35.031     0.200
     1.894    35.413     0.200
     2.228    43.270     0.200
     3.099    62.071     0.200
     7.261   146.442     0.200
    10.530   211.560     0.200
     2.230    42.175     0.200
     1.303    24.789     0.200
     1.303    24.477     0.200
     1.488    27.982     0.200
     1.888    36.061     0.200
     3.086    61.266     0.200
     1.486    27.991     0.200
     1.687    31.878     0.200
     1.702    33.673     0.200
     1.486    27.734     0.200
     1.244    23.215     0.200
     1.245    23.464     0.200
     1.361    25.227     0.200
     1.438    28.141     0.200
     1.506    28.149     0.200
     1.533    28.696     0.200
     1.605    30.866     0.200
     1.623    30.098     0.200
     1.647    32.684     0.200
     1.658    31.627     0.200
     1.706    32.085     0.200
     1.726    33.573     0.200
     1.737    32.304     0.200
     1.801    33.416     0.200
     1.863    34.504     0.200
     1.509    26.161     0.200
     1.493    28.044     0.200
     1.711    34.748     0.200
     1.883    35.202     0.200
     1.903    36.971     0.200
     7.256   142.899     0.200
     8.404   163.030     0.200
     1.516    26.370     0.200
     1.614    30.318     0.200
     1.603    32.314     0.200
     1.211    23.392     0.200
     1.230    23.575     0.200
     1.332    25.287     0.200
     1.409    26.532     0.200
     1.467    27.330     0.200
     1.509    30.756     0.200
     1.556    29.782     0.200
     1.606    32.100     0.200
     1.665    30.868     0.200
     1.677    32.698     0.200
     1.894    35.278     0.200
     1.953    38.637     0.200
     8.573   168.248     0.200
    10.850   215.291     0.200
     1.361    26.121     0.200
     1.588    31.321     0.200
     2.224    43.490     0.200
     1.484    27.794     0.200
     1.576    29.987     0.200
     1.648    31.449     0.200
     1.740    32.701     0.200
     1.227    23.003     0.200
     1.282    24.536     0.200
     1.398    26.497     0.200
     1.563    30.266     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.267     6.567     0.200
     0.781    15.454     0.200
     0.835    16.609     0.200
     0.881    17.727     0.200
     0.949    18.160     0.200
     0.989    20.223     0.200
     0.733    15.837     0.200
     1.007    20.116     0.200
     1.076    22.555     0.200
     1.094    22.546     0.200
     1.102    22.453     0.200
     1.391    27.511     0.200
     0.709    15.317     0.200
     0.825    17.027     0.200
     0.936    19.563     0.200
     0.991    19.669     0.200
     1.070    21.370     0.200
     1.084    21.457     0.200
     1.092    22.218     0.200
     1.373    26.883     0.200
     0.193     4.951     0.200
     0.618    13.219     0.200
     0.782    16.373     0.200
     0.802    16.916     0.200
     0.803    16.886     0.200
     0.868    18.621     0.200
     0.906    18.711     0.200
     0.783    16.840     0.200
     0.975    20.351     0.200
     1.050    21.840     0.200
     1.111    23.363     0.200
     1.133    23.587     0.200
     1.141    23.509     0.200
     0.569    12.279     0.200
     0.448    10.272     0.200
     0.819    16.637     0.200
     0.874    17.571     0.200
     0.967    19.262     0.200
     0.990    19.375     0.200
     0.398     8.899     0.200
     0.398     8.774     0.200
     0.394     8.824     0.200
     0.607    12.490     0.200
     0.607    13.502     0.200
     0.809    16.889     0.200
     1.019    20.593     0.200
     1.664    29.386     0.200
     4.564    83.091     0.200
     5.825   104.714     0.200
     0.311     7.618     0.200
     0.316     7.266     0.200
     0.316     7.130     0.200
     0.573    12.561     0.200
     2.427    42.401     0.200
     0.343     7.799     0.200
     0.277     7.942     0.200
     0.372     7.446     0.200
     0.372     9.188     0.200
     0.423     8.666     0.200
     0.423     9.904     0.200
     0.423    10.076     0.200
     0.622    13.042     0.200
     1.006    20.080     0.200
     1.810    33.731     0.200
     0.686    14.519     0.200
     0.777    16.385     0.200
     0.814    17.177     0.200
     0.855    17.614     0.200
     0.970    19.575     0.200
     1.257    24.907     0.200
     1.256    24.806     0.200
     1.664    29.209     0.200
     2.165    40.399     0.200
     3.075    56.118     0.200
     0.256     6.795     0.200
     0.375     8.342     0.200
     0.428     9.552     0.200
     0.467    10.047     0.200
     0.467    11.113     0.200
     0.681    14.340     0.200
     1.715    29.780     0.200
     1.852    34.152     0.200
     2.913    52.683     0.200
     0.313     7.586     0.200
     0.555    12.251     0.200
     0.824    16.952     0.200
     0.910    18.716     0.200
     0.885    17.620     0.200
     1.074    21.213     0.200
     1.074    22.164     0.200
     1.044    21.183     0.200
     1.609    29.424     0.200
     1.727    31.055     0.200
     1.727    30.538     0.200
     2.641    48.884     0.200
     2.805    51.768     0.200
     3.339    61.654     0.200
     0.302     7.455     0.200
     0.274     7.002     0.200
     0.646    13.460     0.200
     0.724    14.952     0.200
     0.730    14.972     0.200
     0.730    16.262     0.200
     0.808    16.627     0.200
     0.897    17.945     0.200
     1.034    20.155     0.200
     1.723    31.247     0.200
     2.218    41.148     0.200
     2.962    54.355     0.200
     3.124    57.542     0.200
     3.143    57.940     0.200
     0.279     6.030     0.200
     0.281     5.995     0.200
     0.584    13.242     0.200
     0.695    15.821     0.200
     0.896    18.827     0.200
     1.031    21.645     0.200
     1.188    25.244     0.200
     1.346    27.325     0.200
     1.429    28.506     0.200
     2.027    37.819     0.200
     2.426    43.975     0.200
     2.659    49.256     0.200
     3.404    62.319     0.200
     3.591    63.771     0.200
     4.097    75.390     0.200
     0.285     6.515     0.200
     0.287     6.716     0.200
     0.558    11.571     0.200
     0.573    12.949     0.200
     0.692    15.641     0.200
     0.885    18.593     0.200
     1.020    21.608     0.200
     1.178    24.321     0.200
     1.195    23.340     0.200
     1.340    25.754     0.200
     1.340    27.283     0.200
     1.428    28.433     0.200
     2.021    37.648     0.200
     2.655    49.255     0.200
     3.293    60.531     0.200
     3.399    61.848     0.200
     4.093    74.854     0.200
     0.288     6.285     0.200
     0.288     6.504     0.200
     0.289     6.203     0.200
     0.552    11.665     0.200
     0.688    15.797     0.200
     1.172    25.016     0.200
     1.424    28.433     0.200
     2.019    37.848     0.200
     2.420    43.748     0.200
     2.652    49.494     0.200
     3.396    62.221     0.200
     4.090    74.869     0.200
     0.573    13.273     0.200
     0.698    16.534     0.200
     0.884    19.056     0.200
     1.019    21.158     0.200
     1.186    25.462     0.200
     1.343    27.974     0.200
     1.434    29.250     0.200
     3.403    63.717     0.200
     0.282     6.236     0.200
     0.282     6.397     0.200
     0.283     6.170     0.200
     0.283     6.549     0.200
     0.283     7.170     0.200
     0.553    11.794     0.200
     0.578    12.958     0.200
     0.694    15.861     0.200
     0.890    19.003     0.200
     1.025    21.268     0.200
     1.343    25.928     0.200
     1.343    27.506     0.200
     1.430    28.595     0.200
     2.658    49.529     0.200
     3.402    62.439     0.200
     4.096    75.095     0.200
     0.269     6.037     0.200
     0.269     6.369     0.200
     0.271     6.169     0.200
     0.271     6.497     0.200
     0.583    13.185     0.200
     0.562    11.577     0.200
     0.710    15.728     0.200
     1.030    21.635     0.200
     1.194    24.841     0.200
     2.037    37.707     0.200
     2.672    49.201     0.200
     3.416    62.761     0.200
     4.110    75.203     0.200
     0.271     6.425     0.200
     0.273     6.406     0.200
     0.542    11.643     0.200
     0.592    13.378     0.200
     0.703    15.640     0.200
     0.903    18.782     0.200
     1.038    21.470     0.200
     1.178    24.187     0.200
     1.355    26.481     0.200
     1.355    26.953     0.200
     2.035    37.908     0.200
     4.105    75.496     0.200
     0.539    12.291     0.200
     0.544    12.199     0.200
     0.604    12.829     0.200
     0.680    14.731     0.200
     1.059    21.530     0.200
     1.198    24.024     0.200
     1.238    23.547     0.200
     1.264    25.017     0.200
     2.600    48.395     0.200
     3.147    57.878     0.200
     0.275     6.351     0.200
     0.275     6.132     0.200
     0.275     6.492     0.200
     0.276     6.303     0.200
     0.578    12.907     0.200
     0.705    15.487     0.200
     1.208    23.957     0.200
     1.350    26.241     0.200
     1.441    28.854     0.200
     0.279     5.768     0.200
     0.281     6.260     0.200
     0.281     6.561     0.200
     0.562    11.829     0.200
     0.562    12.051     0.200
     0.576    12.853     0.200
     0.700    15.928     0.200
     1.346    26.390     0.200
     1.436    28.035     0.200
     2.027    37.141     0.200
     2.656    49.672     0.200
     0.279     6.564     0.200
     0.279     6.964     0.200
     0.281     5.985     0.200
     0.281     6.184     0.200
     0.572    11.671     0.200
     0.571    12.874     0.200
     0.703    15.281     0.200
     0.883    18.936     0.200
     1.018    21.295     0.200
     1.346    27.245     0.200
     1.346    27.075     0.200
     1.441    28.497     0.200
     2.436    45.503     0.200
     2.664    48.871     0.200
     0.277     6.051     0.200
     0.279     6.170     0.200
     0.279     6.810     0.200
     0.556    11.633     0.200
     0.580    13.080     0.200
     0.700    15.668     0.200
     1.027    20.925     0.200
     1.200    24.642     0.200
     1.348    25.730     0.200
     1.436    28.861     0.200
     0.268     6.300     0.200
     0.270     6.330     0.200
     0.894    18.392     0.200
     1.029    20.610     0.200
     0.289     6.015     0.200
     0.289     6.486     0.200
     0.291     6.545     0.200
     0.576    12.638     0.200
     1.190    25.392     0.200
     1.190    25.591     0.200
     1.336    25.749     0.200
     1.336    27.069     0.200
     0.289     5.503     0.200
     0.289     6.525     0.200
     0.290     6.443     0.200
     0.290     6.113     0.200
     0.562    12.311     0.200
     0.576    12.352     0.200
     0.874    18.253     0.200
     1.009    20.933     0.200
     1.190    25.042     0.200
     1.336    26.151     0.200
     1.336    27.040     0.200
     1.432    28.710     0.200
     2.018    37.428     0.200
     4.092    76.567     0.200
     0.283     6.473     0.200
     0.557    11.654     0.200
     0.577    13.146     0.200
     0.888    18.780     0.200
     1.023    21.424     0.200
     1.181    25.155     0.200
     1.344    27.574     0.200
     1.432    29.313     0.200
     1.444    28.907     0.200
     1.645    32.152     0.200
     2.025    37.834     0.200
     2.428    45.262     0.200
     0.534    11.763     0.200
     0.901    18.273     0.200
     0.938    19.411     0.200
     1.002    19.968     0.200
     1.041    20.145     0.200
     1.211    24.556     0.200
     1.414    27.241     0.200
     0.260     5.038     0.200
     0.262     5.608     0.200
     0.262     5.917     0.200
     0.596    13.548     0.200
     0.549    11.338     0.200
     0.908    18.961     0.200
     1.043    21.324     0.200
     1.207    24.649     0.200
     1.365    27.648     0.200
     1.365    26.910     0.200
     1.451    29.439     0.200
     2.046    38.488     0.200
     2.447    45.432     0.200
     0.205     5.404     0.200
     0.205     4.964     0.200
     0.207     5.294     0.200
     0.644    14.841     0.200
     0.956    19.230     0.200
     1.420    27.514     0.200
     2.101    38.968     0.200
     0.241     5.522     0.200
     0.241     5.299     0.200
     0.243     5.452     0.200
     0.539    11.026     0.200
     0.539    11.737     0.200
     0.616    13.920     0.200
     0.928    19.365     0.200
     1.063    21.914     0.200
     1.384    27.779     0.200
     1.466    28.449     0.200
     0.231     5.219     0.200
     0.231     5.097     0.200
     0.233     5.258     0.200
     0.535    10.915     0.200
     0.535    11.626     0.200
     0.626    13.918     0.200
     0.938    19.701     0.200
     1.395    27.839     0.200
     1.395    27.628     0.200
     1.475    28.796     0.200
     1.494    29.497     0.200
     0.282     6.299     0.200
     0.282     6.607     0.200
     0.566    11.876     0.200
     0.571    12.824     0.200
     0.883    18.706     0.200
     1.018    20.640     0.200
     1.187    24.601     0.200
     1.204    24.374     0.200
     1.342    26.919     0.200
     1.427    28.668     0.200
     1.443    28.048     0.200
     1.645    31.902     0.200
     0.339     8.012     0.200
     0.498    10.927     0.200
     0.751    15.600     0.200
     0.751    16.682     0.200
     0.865    16.675     0.200
     0.893    17.561     0.200
     0.882    17.857     0.200
     0.882    18.006     0.200
     0.883    18.166     0.200
     0.942    18.914     0.200
     1.044    19.911     0.200
     1.152    22.389     0.200
     1.174    23.061     0.200
     2.059    37.997     0.200
     2.803    50.801     0.200
     3.130    57.796     0.200
     3.497    63.716     0.200
     0.403     8.994     0.200
     0.403     9.502     0.200
     0.479    10.048     0.200
     0.480    10.737     0.200
     0.480    11.018     0.200
     0.480    11.409     0.200
     1.251    24.206     0.200
     1.336    24.083     0.200
     1.632    29.353     0.200
     1.632    28.782     0.200
     1.913    35.228     0.200
     4.757    82.802     0.200
     6.763   119.255     0.200
     0.367     8.496     0.200
     0.618    13.318     0.200
     0.618    13.107     0.200
     0.620    13.361     0.200
     0.620    13.080     0.200
     0.688    14.474     0.200
     0.963    20.415     0.200
     1.013    20.856     0.200
     1.013    20.177     0.200
     1.098    21.444     0.200
     1.109    21.404     0.200
     1.308    25.585     0.200
     1.404    27.355     0.200
     2.292    42.248     0.200
     2.320    42.899     0.200
     2.426    45.169     0.200
     2.443    44.673     0.200
     3.065    55.931     0.200
     3.394    63.069     0.200
     3.758    69.258     0.200
     0.346     8.052     0.200
     0.747    15.244     0.200
     0.748    15.225     0.200
     0.772    16.549     0.200
     0.889    18.149     0.200
     0.889    19.460     0.200
     0.975    19.536     0.200
     1.261    25.914     0.200
     2.192    40.937     0.200
     0.499    10.725     0.200
     0.545    12.131     0.200
     0.545    11.362     0.200
     0.546    11.387     0.200
     0.836    17.586     0.200
     1.148    22.652     0.200
     1.237    24.105     0.200
     1.477    28.700     0.200
     3.160    58.999     0.200
     0.348     7.887     0.200
     0.580    12.103     0.200
     0.690    14.677     0.200
     0.746    15.682     0.200
     0.747    15.625     0.200
     0.747    15.914     0.200
     0.891    18.418     0.200
     0.976    19.683     0.200
     0.985    19.642     0.200
     1.180    22.859     0.200
     1.260    25.316     0.200
     1.277    25.317     0.200
     1.566    29.970     0.200
     1.566    30.314     0.200
     3.631    67.913     0.200
     0.444     9.388     0.200
     0.444     9.567     0.200
     0.446     9.153     0.200
     0.446     9.513     0.200
     1.244    25.222     0.200
     1.354    26.045     0.200
     2.415    45.331     0.200
     5.219    91.609     0.200
     0.448     9.400     0.200
     0.450     9.376     0.200
     0.450     9.595     0.200
     0.450     9.997     0.200
     0.699    15.350     0.200
     0.837    17.812     0.200
     1.231    24.517     0.200
     1.340    26.302     0.200
     1.406    28.131     0.200
     0.132     5.416     0.200
     0.399     9.505     0.200
     0.525    11.407     0.200
     0.785    15.491     0.200
     0.787    15.759     0.200
     0.787    15.619     0.200
     0.856    17.029     0.200
     0.856    17.679     0.200
     0.935    18.766     0.200
     0.965    18.549     0.200
     1.063    20.095     0.200
     1.067    20.411     0.200
     2.943    54.224     0.200
     3.640    66.991     0.200
     0.431     9.490     0.200
     0.433     9.306     0.200
     0.433     9.896     0.200
     0.433    10.297     0.200
     0.433     9.517     0.200
     0.764    15.149     0.200
     0.764    16.858     0.200
     0.895    18.665     0.200
     1.315    26.337     0.200
     1.355    27.030     0.200
     1.574    30.232     0.200
     1.930    36.155     0.200
     4.029    74.981     0.200
     0.509    11.106     0.200
     0.510    11.151     0.200
     0.510    10.627     0.200
     0.585    11.636     0.200
     0.585    12.402     0.200
     0.877    19.093     0.200
     1.026    20.205     0.200
     1.034    20.794     0.200
     1.089    22.349     0.200
     1.205    23.963     0.200
     1.240    24.862     0.200
     1.240    25.487     0.200
     1.323    25.697     0.200
     1.408    28.430     0.200
     1.495    28.708     0.200
     1.542    30.096     0.200
     1.898    35.504     0.200
     2.488    46.756     0.200
     0.079     4.383     0.200
     0.078     3.280     0.200
     0.078     3.710     0.200
     0.426     9.636     0.200
     0.665    12.893     0.200
     1.004    19.841     0.200
     2.285    42.152     0.200
     2.907    53.548     0.200
     3.651    67.686     0.200
     0.489    10.061     0.200
     0.489    11.053     0.200
     0.490    10.153     0.200
     0.490     9.762     0.200
     0.599    12.117     0.200
     0.599    11.766     0.200
     1.007    20.186     0.200
     1.038    20.210     0.200
     1.107    22.421     0.200
     1.223    23.873     0.200
     1.251    25.407     0.200
     1.335    25.806     0.200
     1.558    30.064     0.200
     1.618    30.020     0.200
     0.377     8.763     0.200
     0.514    11.177     0.200
     0.514    10.457     0.200
     0.515    10.968     0.200
     0.595    12.051     0.200
     0.699    14.371     0.200
     1.039    20.151     0.200
     1.093    22.807     0.200
     1.210    24.021     0.200
     1.254    25.195     0.200
     1.254    23.905     0.200
     1.336    25.720     0.200
     3.238    60.402     0.200
     3.601    67.189     0.200
     0.380     8.801     0.200
     0.504    10.775     0.200
     0.505    10.866     0.200
     0.505    10.686     0.200
     0.599    11.710     0.200
     0.599    11.870     0.200
     0.599    11.590     0.200
     0.690    13.873     0.200
     0.888    19.856     0.200
     1.028    19.946     0.200
     1.028    21.485     0.200
     1.051    21.050     0.200
     1.051    20.750     0.200
     1.100    22.232     0.200
     1.216    23.795     0.200
     1.256    25.080     0.200
     1.391    26.879     0.200
     1.597    27.751     0.200
     1.913    35.300     0.200
     3.462    64.133     0.200
     0.386     8.881     0.200
     0.499    11.159     0.200
     0.499    10.168     0.200
     0.499    11.029     0.200
     0.499     9.869     0.200
     0.599    11.888     0.200
     0.682    14.051     0.200
     0.885    19.569     0.200
     0.896    19.924     0.200
     1.020    20.106     0.200
     1.046    21.305     0.200
     1.103    22.510     0.200
     1.219    24.040     0.200
     1.254    25.280     0.200
     1.337    26.118     0.200
     1.390    27.220     0.200
     1.556    30.048     0.200
     1.912    35.674     0.200
     3.244    59.782     0.200
     3.931    73.167     0.200
     0.288     7.271     0.200
     0.443     9.558     0.200
     0.443     9.279     0.200
     0.445     9.304     0.200
     0.661    13.750     0.200
     0.765    14.923     0.200
     0.788    16.045     0.200
     0.886    18.615     0.200
     0.886    18.465     0.200
     1.240    24.744     0.200
     1.240    24.305     0.200
     1.323    26.293     0.200
     1.349    25.808     0.200
     1.416    27.760     0.200
     1.416    27.545     0.200
     1.822    33.409     0.200
     1.954    36.139     0.200
     2.407    42.327     0.200
     0.274     6.455     0.200
     0.395     9.887     0.200
     0.508    11.032     0.200
     0.618    12.792     0.200
     0.618    12.932     0.200
     0.720    14.053     0.200
     0.720    14.263     0.200
     0.732    14.567     0.200
     0.732    15.527     0.200
     0.809    15.532     0.200
     0.817    15.781     0.200
     0.933    17.568     0.200
     0.988    18.663     0.200
     0.988    19.680     0.200
     1.006    19.640     0.200
     1.008    19.140     0.200
     1.008    19.580     0.200
     1.025    18.754     0.200
     1.071    20.460     0.200
     1.285    23.391     0.200
     1.786    32.766     0.200
     1.950    35.732     0.200
     2.496    46.217     0.200
     2.692    48.529     0.200
     3.389    61.903     0.200
     0.358     8.286     0.200
     0.452    10.089     0.200
     0.452    10.448     0.200
     0.452    10.323     0.200
     0.649    12.910     0.200
     0.649    13.903     0.200
     0.935    20.077     0.200
     1.082    21.266     0.200
     1.301    24.995     0.200
     1.961    35.904     0.200
     2.553    47.030     0.200
     3.296    60.438     0.200
     3.655    66.890     0.200
     3.982    73.213     0.200
     0.366     8.626     0.200
     0.366     9.097     0.200
     0.356     7.288     0.200
     0.356     6.878     0.200
     0.356     7.688     0.200
     0.652    13.075     0.200
     0.860    16.398     0.200
     0.895    17.278     0.200
     0.982    18.482     0.200
     0.984    18.530     0.200
     0.984    18.110     0.200
     1.010    19.067     0.200
     1.337    24.596     0.200
     1.620    28.560     0.200
     1.999    36.772     0.200
     2.739    49.250     0.200
     0.284     7.090     0.200
     0.447     9.686     0.200
     0.449     9.152     0.200
     0.449    10.163     0.200
     0.761    14.884     0.200
     0.665    13.648     0.200
     0.790    16.532     0.200
     0.882    17.355     0.200
     1.236    23.814     0.200
     1.311    26.072     0.200
     1.412    27.412     0.200
     1.920    35.358     0.200
     2.582    46.681     0.200
     3.323    61.256     0.200
     4.020    73.974     0.200
     0.266     5.851     0.200
     0.266     6.193     0.200
     0.377     8.345     0.200
     0.438    10.483     0.200
     0.438    10.303     0.200
     0.438    10.163     0.200
     0.668    13.727     0.200
     0.963    18.418     0.200
     0.944    19.729     0.200
     1.070    21.007     0.200
     1.159    22.380     0.200
     1.295    25.042     0.200
     1.557    28.326     0.200
     1.753    32.386     0.200
     1.753    32.207     0.200
     1.812    33.411     0.200
     1.946    35.984     0.200
     0.238     5.188     0.200
     0.238     6.118     0.200
     0.530    10.998     0.200
     0.531    12.244     0.200
     0.532    11.081     0.200
     0.532    11.251     0.200
     0.856    19.226     0.200
     0.884    19.915     0.200
     0.959    19.714     0.200
     1.016    20.496     0.200
     1.085    21.726     0.200
     1.113    21.436     0.200
     1.165    22.118     0.200
     1.261    24.156     0.200
     1.496    28.354     0.200
     1.496    28.238     0.200
     1.838    33.791     0.200
     2.437    44.760     0.200
     3.180    57.776     0.200
     0.402     8.762     0.200
     0.402     9.403     0.200
     0.408     9.527     0.200
     0.408     9.367     0.200
     0.408     8.307     0.200
     0.783    14.938     0.200
     0.890    20.900     0.200
     0.981    19.472     0.200
     0.980    21.419     0.200
     1.227    23.963     0.200
     1.386    27.323     0.200
     2.098    39.022     0.200
     0.309     5.492     0.200
     0.416     9.540     0.200
     0.625    12.992     0.200
     0.693    16.251     0.200
     0.772    16.150     0.200
     0.772    15.939     0.200
     0.773    16.293     0.200
     0.843    17.193     0.200
     0.849    17.498     0.200
     0.853    18.447     0.200
     0.872    17.097     0.200
     0.925    17.869     0.200
     0.983    19.616     0.200
     0.983    19.795     0.200
     1.058    20.001     0.200
     1.113    22.128     0.200
     1.148    22.995     0.200
     1.231    23.686     0.200
     1.884    34.579     0.200
     2.206    40.887     0.200
     0.195     5.060     0.200
     0.195     5.840     0.200
     0.495    10.816     0.200
     0.505    11.441     0.200
     0.505    11.151     0.200
     0.507    11.417     0.200
     0.544    12.053     0.200
     0.572    11.374     0.200
     0.899    20.199     0.200
     0.978    19.006     0.200
     1.106    22.824     0.200
     1.116    22.590     0.200
     1.139    22.846     0.200
     1.175    23.442     0.200
     1.186    23.203     0.200
     1.186    23.484     0.200
     1.264    24.435     0.200
     1.447    28.022     0.200
     1.843    34.304     0.200
     3.541    65.228     0.200
     3.883    72.355     0.200
     4.025    74.040     0.200
     4.759    85.593     0.200
     0.180     4.967     0.200
     0.496    10.875     0.200
     0.496    11.305     0.200
     0.502    10.306     0.200
     0.497    11.162     0.200
     0.497    11.791     0.200
     0.550    11.576     0.200
     0.560    11.121     0.200
     0.941    18.167     0.200
     0.941    18.687     0.200
     0.964    19.104     0.200
     1.149    22.746     0.200
     1.177    23.070     0.200
     1.177    23.201     0.200
     1.195    23.407     0.200
     1.267    24.162     0.200
     1.267    24.393     0.200
     1.847    34.212     0.200
     1.847    34.222     0.200
     0.177     4.274     0.200
     0.494    11.180     0.200
     0.494    11.061     0.200
     0.496    10.746     0.200
     0.496    10.886     0.200
     0.496    11.355     0.200
     0.496    11.556     0.200
     0.505    10.159     0.200
     0.556    11.045     0.200
     0.551    11.327     0.200
     0.961    18.572     0.200
     1.452    26.512     0.200
     1.847    33.660     0.200
     2.199    38.217     0.200
     0.180     4.725     0.200
     0.180     5.162     0.200
     0.494    10.661     0.200
     0.494    11.169     0.200
     0.496    10.733     0.200
     0.496    11.303     0.200
     0.502    10.509     0.200
     0.552    11.091     0.200
     0.559    11.292     0.200
     0.915    19.448     0.200
     0.942    18.851     0.200
     0.963    18.915     0.200
     1.179    23.120     0.200
     1.843    34.114     0.200
     1.848    33.928     0.200
     2.457    44.593     0.200
     3.891    71.290     0.200
     0.274     6.736     0.200
     0.274     7.467     0.200
     0.365     7.689     0.200
     0.420     9.563     0.200
     0.672    14.170     0.200
     0.709    14.571     0.200
     0.709    14.680     0.200
     0.710    14.653     0.200
     0.761    14.736     0.200
     1.005    18.958     0.200
     1.018    19.273     0.200
     1.020    19.823     0.200
     1.872    33.725     0.200
     0.326     7.341     0.200
     0.188     5.385     0.200
     0.405     8.920     0.200
     0.405     9.162     0.200
     0.407     9.178     0.200
     0.407    10.256     0.200
     0.758    15.196     0.200
     0.778    16.358     0.200
     1.269    24.613     0.200
     1.269    24.765     0.200
     1.953    35.774     0.200
     2.612    47.907     0.200
     4.051    74.080     0.200
     0.503    10.602     0.200
     0.525    11.342     0.200
     0.525    10.874     0.200
     0.526    11.071     0.200
     0.526    10.922     0.200
     0.575    11.716     0.200
     0.885    19.523     0.200
     0.933    18.999     0.200
     1.096    23.059     0.200
     1.119    23.336     0.200
     1.159    23.652     0.200
     1.159    25.105     0.200
     1.167    23.673     0.200
     1.206    24.178     0.200
     1.247    24.671     0.200
     1.247    25.030     0.200
     1.308    26.052     0.200
     0.263     5.952     0.200
     0.264     5.893     0.200
     0.264     6.799     0.200
     0.351     8.089     0.200
     0.717    14.320     0.200
     1.205    24.134     0.200
     1.205    23.806     0.200
     1.463    28.886     0.200
     0.687    13.128     0.200
     1.179    22.493     0.200
     0.376     8.413     0.200
     0.624    13.094     0.200
     0.624    13.465     0.200
     0.814    17.093     0.200
     0.892    18.460     0.200
     0.892    18.350     0.200
     0.992    19.713     0.200
     0.992    19.584     0.200
     0.977    21.508     0.200
     1.017    20.303     0.200
     1.023    20.646     0.200
     1.023    20.490     0.200
     1.025    21.296     0.200
     1.075    21.090     0.200
     1.101    23.129     0.200
     1.262    24.099     0.200
     1.312    25.991     0.200
     1.573    29.381     0.200
     1.725    30.872     0.200
     2.214    40.832     0.200
     3.653    68.407     0.200
     0.481    10.553     0.200
     0.481    10.389     0.200
     0.680    13.232     0.200
     0.902    20.822     0.200
     0.912    20.963     0.200
     1.055    21.700     0.200
     1.055    21.457     0.200
     1.236    24.707     0.200
     1.268    25.197     0.200
     1.268    25.486     0.200
     1.268    26.361     0.200
     1.352    26.459     0.200
     1.406    27.681     0.200
     1.573    30.567     0.200
     3.620    67.594     0.200
     0.405     9.102     0.200
     0.405     9.562     0.200
     0.539    10.646     0.200
     0.539    10.826     0.200
     0.539    11.096     0.200
     0.602    12.776     0.200
     0.701    14.220     0.200
     0.786    16.186     0.200
     0.787    15.644     0.200
     0.812    16.379     0.200
     0.972    19.927     0.200
     1.023    20.301     0.200
     1.650    29.056     0.200
     1.927    35.860     0.200
     3.366    62.203     0.200
     0.851    17.966     0.200
     0.710    14.477     0.200
     1.348    26.649     0.200
     1.348    26.050     0.200
     1.643    30.084     0.200
     1.716    31.913     0.200
     1.716    32.092     0.200
     3.804    70.966     0.200
     4.479    77.884     0.200
     0.432     9.322     0.200
     0.432     9.752     0.200
     0.472     9.983     0.200
     0.549    11.826     0.200
     0.836    18.939     0.200
     1.096    21.883     0.200
     1.149    22.570     0.200
     1.167    23.360     0.200
     1.167    23.958     0.200
     1.252    24.182     0.200
     1.482    28.462     0.200
     1.828    34.056     0.200
     2.424    45.005     0.200
     0.172     5.416     0.200
     0.172     5.756     0.200
     0.562    11.372     0.200
     0.562    11.532     0.200
     0.806    16.342     0.200
     0.919    18.277     0.200
     1.189    23.055     0.200
     1.409    25.566     0.200
     1.684    30.617     0.200
     1.684    30.730     0.200
     1.779    31.644     0.200
     1.869    33.999     0.200
     2.392    43.916     0.200
     2.398    43.969     0.200
     0.251     6.491     0.200
     0.441    10.142     0.200
     0.441    10.493     0.200
     0.529    12.106     0.200
     0.750    15.282     0.200
     0.748    15.236     0.200
     0.847    16.257     0.200
     0.880    16.853     0.200
     0.880    16.978     0.200
     0.883    16.761     0.200
     0.926    17.722     0.200
     1.428    26.074     0.200
     1.428    26.261     0.200
     1.701    31.207     0.200
     2.064    37.575     0.200
     3.503    63.565     0.200
     0.248     5.863     0.200
     0.248     6.242     0.200
     0.409     8.829     0.200
     0.409     9.169     0.200
     0.409     9.280     0.200
     0.832    16.386     0.200
     0.832    16.706     0.200
     0.868    18.122     0.200
     0.907    18.909     0.200
     1.150    24.140     0.200
     1.288    25.183     0.200
     1.288    25.724     0.200
     0.243     5.723     0.200
     0.480    10.731     0.200
     0.480    10.471     0.200
     0.480    11.011     0.200
     0.480    11.161     0.200
     0.488    10.213     0.200
     0.491    10.587     0.200
     0.491    10.687     0.200
     0.697    13.997     0.200
     0.697    13.867     0.200
     0.795    15.517     0.200
     0.795    14.916     0.200
     0.773    15.439     0.200
     0.847    16.279     0.200
     0.858    16.514     0.200
     0.930    18.740     0.200
     0.930    18.059     0.200
     0.917    19.603     0.200
     0.957    18.929     0.200
     0.984    18.670     0.200
     0.979    18.530     0.200
     1.121    21.813     0.200
     1.121    21.674     0.200
     1.650    30.025     0.200
     2.016    36.548     0.200
     2.759    51.125     0.200
     0.481    10.446     0.200
     0.481    10.677     0.200
     0.481    10.919     0.200
     0.489    10.274     0.200
     0.491    10.506     0.200
     0.491    10.853     0.200
     0.697    14.236     0.200
     0.697    14.029     0.200
     0.773    15.358     0.200
     0.795    15.487     0.200
     0.795    15.358     0.200
     0.847    16.454     0.200
     0.847    16.274     0.200
     0.858    16.539     0.200
     0.858    16.521     0.200
     0.876    16.736     0.200
     0.876    16.959     0.200
     0.916    18.623     0.200
     0.930    18.396     0.200
     0.956    19.268     0.200
     0.984    18.862     0.200
     0.978    18.901     0.200
     1.000    18.986     0.200
     1.000    18.884     0.200
     1.000    19.286     0.200
     1.067    20.311     0.200
     1.650    29.373     0.200
     0.296     6.658     0.200
     0.296     6.840     0.200
     0.296     6.959     0.200
     0.352     8.360     0.200
     0.393     8.055     0.200
     0.609    13.135     0.200
     0.609    12.975     0.200
     0.735    15.364     0.200
     0.735    14.735     0.200
     0.833    16.635     0.200
     0.889    17.708     0.200
     0.991    19.249     0.200
     0.991    18.909     0.200
     1.035    19.682     0.200
     1.077    20.171     0.200
     1.077    20.540     0.200
     1.200    22.827     0.200
     1.848    33.863     0.200
     0.162     4.885     0.200
     0.162     5.010     0.200
     0.278     6.668     0.200
     0.278     7.051     0.200
     0.278     7.269     0.200
     0.278     6.566     0.200
     0.504    10.497     0.200
     0.565    11.784     0.200
     0.565    12.089     0.200
     0.709    14.122     0.200
     0.776    15.487     0.200
     0.927    18.796     0.200
     1.015    19.344     0.200
     1.042    19.842     0.200
     1.042    20.256     0.200
     2.029    37.201     0.200
     3.408    62.619     0.200
     6.674   114.424     0.200
     0.307     7.738     0.200
     0.307     7.918     0.200
     0.355     8.239     0.200
     0.355     8.919     0.200
     0.721    14.336     0.200
     0.821    16.672     0.200
     2.129    38.452     0.200
     3.470    64.357     0.200
     0.284     6.398     0.200
     0.284     6.507     0.200
     0.347     7.889     0.200
     0.390     7.694     0.200
     0.459     9.442     0.200
     0.459    10.192     0.200
     0.627    12.568     0.200
     0.627    13.056     0.200
     0.640    13.257     0.200
     0.723    14.193     0.200
     0.794    15.861     0.200
     0.814    16.684     0.200
     0.901    18.184     0.200
     1.002    19.207     0.200
     1.002    18.726     0.200
     1.040    20.234     0.200
     1.031    19.785     0.200
     1.031    19.636     0.200
     1.037    19.807     0.200
     1.038    20.204     0.200
     0.207     5.105     0.200
     0.376     8.006     0.200
     0.472    10.137     0.200
     0.472    10.528     0.200
     0.472    10.738     0.200
     0.535    11.766     0.200
     0.519    11.057     0.200
     0.534    11.346     0.200
     0.534    11.176     0.200
     0.534    11.836     0.200
     0.660    13.110     0.200
     0.660    13.610     0.200
     0.755    14.824     0.200
     0.755    15.383     0.200
     0.757    15.020     0.200
     0.799    15.610     0.200
     0.812    15.297     0.200
     0.812    15.949     0.200
     0.819    16.131     0.200
     0.956    17.965     0.200
     0.971    19.462     0.200
     0.977    19.491     0.200
     1.073    21.068     0.200
     1.073    20.755     0.200
     1.073    20.867     0.200
     1.073    21.398     0.200
     1.884    33.694     0.200
     1.972    36.264     0.200
     0.228     5.570     0.200
     0.228     6.405     0.200
     0.228     6.655     0.200
     0.402     8.719     0.200
     0.459     9.742     0.200
     0.643    13.044     0.200
     0.643    13.513     0.200
     0.665    13.763     0.200
     0.768    15.597     0.200
     0.789    15.735     0.200
     0.789    16.250     0.200
     0.943    17.994     0.200
     1.002    19.038     0.200
     1.002    19.569     0.200
     1.030    20.298     0.200
     1.041    19.958     0.200
     1.059    20.350     0.200
     1.059    20.225     0.200
     2.295    41.526     0.200
     3.300    60.479     0.200
     0.200     5.622     0.200
     0.200     5.790     0.200
     0.200     6.052     0.200
     0.534    12.266     0.200
     0.662    13.160     0.200
     0.662    13.809     0.200
     0.662    14.488     0.200
     0.623    13.234     0.200
     0.623    14.035     0.200
     1.901    35.085     0.200
     2.482    45.427     0.200
     0.238     5.881     0.200
     0.391     8.230     0.200
     0.391     9.429     0.200
     0.478    10.018     0.200
     0.478    10.318     0.200
     0.478    10.568     0.200
     0.483    10.548     0.200
     0.483    10.895     0.200
     0.483    11.458     0.200
     0.493    10.335     0.200
     0.493    10.784     0.200
     0.535    11.752     0.200
     0.535    12.361     0.200
     0.696    14.093     0.200
     0.696    13.863     0.200
     0.794    15.388     0.200
     0.843    16.438     0.200
     0.854    16.606     0.200
     0.854    16.678     0.200
     0.853    17.535     0.200
     0.874    16.856     0.200
     0.874    17.055     0.200
     0.900    18.104     0.200
     0.912    19.459     0.200
     0.931    18.149     0.200
     0.931    18.477     0.200
     0.955    19.336     0.200
     0.982    18.703     0.200
     0.974    18.887     0.200
     0.998    18.793     0.200
     1.065    20.569     0.200
     1.071    20.891     0.200
     1.170    21.826     0.200
     1.375    25.330     0.200
     1.503    26.576     0.200
     1.645    29.026     0.200
     2.014    36.612     0.200
     2.757    50.877     0.200
     3.453    63.430     0.200
     0.210     5.733     0.200
     0.210     5.483     0.200
     0.210     5.862     0.200
     0.464    10.003     0.200
     0.494    10.077     0.200
     0.494    10.589     0.200
     0.486    10.813     0.200
     0.570    11.764     0.200
     0.582    11.879     0.200
     0.665    14.207     0.200
     0.827    17.564     0.200
     0.894    19.827     0.200
     0.926    19.940     0.200
     0.977    19.439     0.200
     0.992    19.333     0.200
     0.974    19.306     0.200
     0.974    20.318     0.200
     1.012    20.463     0.200
     1.130    22.954     0.200
     1.157    22.660     0.200
     1.206    23.736     0.200
     1.206    23.267     0.200
     1.208    23.171     0.200
     1.294    24.478     0.200
     1.294    25.260     0.200
     0.079     5.198     0.200
     0.290     7.208     0.200
     0.333     8.761     0.200
     0.333     7.722     0.200
     0.333     9.021     0.200
     0.333     9.181     0.200
     0.402     9.039     0.200
     0.428     9.670     0.200
     0.428    10.451     0.200
     0.412     9.242     0.200
     0.492    10.710     0.200
     0.491    10.556     0.200
     0.593    12.244     0.200
     0.593    12.375     0.200
     0.593    12.545     0.200
     0.683    13.371     0.200
     0.694    13.915     0.200
     0.694    13.784     0.200
     0.721    14.462     0.200
     0.721    14.215     0.200
     0.807    15.607     0.200
     0.839    16.992     0.200
     0.862    16.835     0.200
     0.868    17.217     0.200
     0.954    18.422     0.200
     0.969    18.274     0.200
     1.059    19.536     0.200
     1.094    20.722     0.200
     1.824    33.466     0.200
     2.375    43.907     0.200
     2.566    46.740     0.200
     3.262    59.667     0.200
     0.132     3.642     0.200
     0.211     4.938     0.200
     0.252     5.612     0.200
     0.434     9.716     0.200
     0.514    11.140     0.200
     0.514    11.038     0.200
     0.514    12.171     0.200
     0.658    14.436     0.200
     0.719    14.978     0.200
     0.729    15.162     0.200
     0.729    14.811     0.200
     0.744    15.818     0.200
     0.746    14.949     0.200
     0.785    15.981     0.200
     0.832    17.145     0.200
     0.832    16.895     0.200
     0.904    17.567     0.200
     0.906    18.219     0.200
     0.946    18.918     0.200
     0.946    18.211     0.200
     1.036    21.421     0.200
     1.036    20.644     0.200
     1.112    21.914     0.200
     3.158    58.508     0.200
     0.148     3.805     0.200
     0.516    10.698     0.200
     0.723    15.332     0.200
     0.743    15.908     0.200
     0.743    14.658     0.200
     0.780    15.542     0.200
     0.807    18.509     0.200
     0.824    17.008     0.200
     0.851    19.223     0.200
     0.897    17.196     0.200
     0.910    17.915     0.200
     0.940    18.182     0.200
     0.984    20.032     0.200
     1.034    20.831     0.200
     1.034    20.698     0.200
     1.057    20.382     0.200
     1.070    20.685     0.200
     1.107    22.033     0.200
     1.107    21.439     0.200
     1.173    22.725     0.200
     1.261    23.925     0.200
     1.311    25.262     0.200
     1.414    26.237     0.200
     3.152    58.625     0.200
     3.635    66.664     0.200
     0.136     3.471     0.200
     0.136     4.840     0.200
     0.425     9.610     0.200
     0.516    10.672     0.200
     0.516    10.802     0.200
     0.507    11.773     0.200
     0.720    14.878     0.200
     0.658    14.199     0.200
     0.790    16.052     0.200
     0.742    14.967     0.200
     0.743    15.532     0.200
     0.786    16.612     0.200
     0.779    15.724     0.200
     0.823    16.816     0.200
     0.911    18.854     0.200
     0.895    17.243     0.200
     0.895    18.153     0.200
     0.851    18.337     0.200
     0.938    18.500     0.200
     1.056    20.309     0.200
     1.172    22.503     0.200
     0.261     5.788     0.200
     0.401     8.413     0.200
     0.433     8.980     0.200
     0.424     9.334     0.200
     0.590    14.022     0.200
     0.736    14.483     0.200
     0.755    16.384     0.200
     0.878    17.729     0.200
     0.945    18.927     0.200
     0.996    19.863     0.200
     0.986    18.883     0.200
     0.986    19.034     0.200
     1.079    21.963     0.200
     1.079    21.395     0.200
     1.150    21.603     0.200
     1.150    22.132     0.200
     0.139     3.460     0.200
     0.139     3.889     0.200
     0.139     4.028     0.200
     0.157     4.082     0.200
     0.507    10.832     0.200
     0.507    11.082     0.200
     0.507    11.352     0.200
     0.665    14.309     0.200
     0.672    15.632     0.200
     0.726    15.282     0.200
     0.726    15.751     0.200
     0.752    14.623     0.200
     0.775    16.031     0.200
     0.790    15.840     0.200
     0.793    18.032     0.200
     0.794    16.413     0.200
     0.814    18.692     0.200
     0.833    17.032     0.200
     0.860    18.417     0.200
     0.905    17.722     0.200
     0.905    17.853     0.200
     0.901    18.168     0.200
     0.901    18.627     0.200
     0.949    18.775     0.200
     0.949    18.605     0.200
     1.043    21.311     0.200
     1.067    20.973     0.200
     1.079    21.020     0.200
     1.182    23.022     0.200
     1.182    22.903     0.200
     4.285    78.283     0.200
     0.142     3.890     0.200
     0.131     3.700     0.200
     0.523    10.860     0.200
     0.651    14.208     0.200
     0.664    15.902     0.200
     0.735    14.844     0.200
     0.736    15.673     0.200
     0.792    16.248     0.200
     0.773    15.726     0.200
     0.773    15.918     0.200
     0.781    18.678     0.200
     0.820    16.858     0.200
     0.820    17.151     0.200
     0.820    17.948     0.200
     0.844    18.786     0.200
     0.891    17.452     0.200
     0.891    17.804     0.200
     0.918    18.535     0.200
     1.027    21.168     0.200
     0.103     4.557     0.200
     0.103     4.737     0.200
     0.103     5.268     0.200
     0.337     7.737     0.200
     0.337     7.917     0.200
     0.740    14.706     0.200
     0.740    15.225     0.200
     0.724    15.094     0.200
     0.955    18.300     0.200
     0.983    19.642     0.200
     1.288    24.698     0.200
     0.383     8.717     0.200
     0.336     7.727     0.200
     0.459    10.212     0.200
     0.459    10.512     0.200
     0.487    11.080     0.200
     0.453     9.408     0.200
     0.453     9.538     0.200
     0.477     9.909     0.200
     0.735    14.442     0.200
     0.735    14.572     0.200
     0.840    15.910     0.200
     0.892    17.305     0.200
     0.948    18.054     0.200
     1.031    19.535     0.200
     1.056    19.680     0.200
     1.064    20.373     0.200
     1.215    22.225     0.200
     0.391     9.261     0.200
     0.391     9.730     0.200
     0.450    10.215     0.200
     0.461    10.422     0.200
     0.486    10.262     0.200
     0.486    10.520     0.200
     0.564    11.486     0.200
     0.564    11.642     0.200
     0.622    13.041     0.200
     0.622    13.900     0.200
     0.622    14.057     0.200
     0.622    12.822     0.200
     0.724    14.570     0.200
     0.724    14.445     0.200
     0.815    16.397     0.200
     0.916    19.158     0.200
     0.915    18.060     0.200
     0.939    18.235     0.200
     1.003    19.336     0.200
     0.991    19.827     0.200
     1.033    20.616     0.200
     1.046    21.040     0.200
     0.503    11.081     0.200
     0.503    11.768     0.200
     0.551    11.597     0.200
     0.567    12.546     0.200
     0.852    18.547     0.200
     0.956    19.282     0.200
     0.956    20.173     0.200
     0.968    19.570     0.200
     0.919    21.549     0.200
     0.954    19.939     0.200
     0.954    20.396     0.200
     0.954    18.607     0.200
     1.026    21.401     0.200
     1.141    23.225     0.200
     1.164    23.282     0.200
     1.194    23.754     0.200
     1.211    24.096     0.200
     1.284    25.025     0.200
     1.284    24.865     0.200
     1.347    26.206     0.200
     0.495    11.518     0.200
     0.493    11.276     0.200
     0.559    12.128     0.200
     0.552    11.523     0.200
     0.846    18.801     0.200
     0.951    19.540     0.200
     1.019    21.015     0.200
     0.964    19.387     0.200
     1.074    22.233     0.200
     0.961    18.905     0.200
     0.961    19.206     0.200
     1.203    24.213     0.200
     1.187    23.937     0.200
     1.277    25.071     0.200
     1.277    24.958     0.200
     1.340    26.291     0.200
     0.542    11.300     0.200
     0.504    10.646     0.200
     0.499    10.625     0.200
     0.499    11.016     0.200
     0.564    11.720     0.200
     0.858    17.713     0.200
     0.882    20.316     0.200
     0.948    19.307     0.200
     0.950    18.609     0.200
     0.950    19.386     0.200
     0.950    18.335     0.200
     0.960    19.200     0.200
     1.029    20.999     0.200
     1.164    22.899     0.200
     1.164    22.833     0.200
     1.189    23.592     0.200
     1.189    22.960     0.200
     1.279    24.858     0.200
     1.279    24.494     0.200
     0.174     4.871     0.200
     0.501    10.683     0.200
     0.499    10.530     0.200
     0.499    10.991     0.200
     0.544    11.527     0.200
     0.562    12.058     0.200
     0.691    14.021     0.200
     0.922    21.545     0.200
     0.948    19.742     0.200
     0.953    19.033     0.200
     0.953    19.443     0.200
     0.960    19.181     0.200
     0.969    21.153     0.200
     1.139    23.533     0.200
     1.161    23.275     0.200
     1.188    23.818     0.200
     1.188    23.439     0.200
     1.207    23.959     0.200
     1.342    26.388     0.200
     1.462    28.348     0.200
     0.164     4.600     0.200
     0.164     5.085     0.200
     0.164     3.929     0.200
     0.496    10.563     0.200
     0.496    10.945     0.200
     0.519    11.189     0.200
     0.540    11.783     0.200
     0.579    11.233     0.200
     0.707    14.496     0.200
     0.936    18.591     0.200
     0.957    18.993     0.200
     0.957    18.532     0.200
     1.201    23.542     0.200
     1.201    23.143     0.200
     0.155     4.134     0.200
     0.155     4.845     0.200
     0.155     4.994     0.200
     0.155     3.916     0.200
     0.506    11.068     0.200
     0.530    11.082     0.200
     0.519    10.679     0.200
     0.575    11.648     0.200
     0.712    14.564     0.200
     0.933    18.610     0.200
     0.890    19.859     0.200
     0.948    19.034     0.200
     0.948    18.713     0.200
     0.957    19.101     0.200
     0.990    19.145     0.200
     1.045    20.950     0.200
     1.194    23.368     0.200
     1.194    23.657     0.200
     1.194    23.227     0.200
     0.190     5.200     0.200
     0.190     5.400     0.200
     0.484    10.226     0.200
     0.484    10.505     0.200
     0.497    10.279     0.200
     0.497    11.038     0.200
     0.560    11.616     0.200
     0.560    11.857     0.200
     0.565    11.725     0.200
     0.680    13.613     0.200
     0.842    17.740     0.200
     0.855    19.521     0.200
     0.938    20.312     0.200
     0.960    19.236     0.200
     0.962    18.824     0.200
     0.962    19.203     0.200
     0.974    19.381     0.200
     1.159    22.664     0.200
     1.195    23.619     0.200
     0.237     5.914     0.200
     0.237     6.825     0.200
     0.391     8.575     0.200
     0.395     8.558     0.200
     0.449     9.387     0.200
     0.449     9.715     0.200
     0.689    14.055     0.200
     0.683    14.247     0.200
     0.683    14.145     0.200
     0.749    15.535     0.200
     0.749    16.074     0.200
     0.749    17.015     0.200
     0.749    15.285     0.200
     0.771    15.554     0.200
     0.985    19.590     0.200
     0.985    20.602     0.200
     0.985    20.961     0.200
     1.022    20.280     0.200
     1.048    21.160     0.200
     1.048    20.472     0.200
     1.047    20.401     0.200
     1.047    20.702     0.200
     1.047    20.034     0.200
     1.148    22.129     0.200
     1.264    23.987     0.200
     1.270    24.170     0.200
     0.174     4.592     0.200
     0.174     5.014     0.200
     0.174     4.483     0.200
     0.365     7.784     0.200
     0.478     9.887     0.200
     0.496    10.326     0.200
     0.533    10.942     0.200
     0.523    11.001     0.200
     0.523    10.739     0.200
     0.683    13.532     0.200
     0.733    15.177     0.200
     0.848    17.770     0.200
     0.919    18.609     0.200
     0.933    18.832     0.200
     0.968    19.581     0.200
     0.968    19.269     0.200
     1.157    22.887     0.200
     1.157    21.887     0.200
     0.176     4.489     0.200
     0.495    10.498     0.200
     0.495    10.896     0.200
     0.503    10.755     0.200
     0.547    11.381     0.200
     0.547    11.752     0.200
     0.565    11.820     0.200
     0.691    14.351     0.200
     0.868    20.328     0.200
     0.953    18.497     0.200
     0.922    21.176     0.200
     1.164    23.222     0.200
     1.191    23.972     0.200
     1.191    23.374     0.200
     1.210    23.707     0.200
     1.281    24.912     0.200
     1.465    28.234     0.200
     0.293     6.615     0.200
     0.293     6.936     0.200
     0.293     5.420     0.200
     0.282     6.522     0.200
     0.359     8.215     0.200
     0.446     9.645     0.200
     0.446    10.418     0.200
     0.502    10.536     0.200
     0.624    13.206     0.200
     0.624    14.386     0.200
     0.624    12.878     0.200
     0.640    13.654     0.200
     0.782    15.955     0.200
     0.813    16.672     0.200
     0.813    16.289     0.200
     0.893    18.399     0.200
     0.893    17.571     0.200
     0.993    19.137     0.200
     1.053    20.304     0.200
     1.018    19.937     0.200
     1.025    20.557     0.200
     1.164    23.152     0.200
     1.199    22.537     0.200
     1.263    24.375     0.200
     0.172     4.219     0.200
     0.172     5.398     0.200
     0.404     7.289     0.200
     0.492    10.653     0.200
     0.492    11.153     0.200
     0.512    10.726     0.200
     0.538    11.278     0.200
     0.642    13.328     0.200
     0.698    13.892     0.200
     0.774    15.881     0.200
     0.874    20.013     0.200
     0.880    20.315     0.200
     0.944    18.726     0.200
     0.957    18.744     0.200
     0.957    19.244     0.200
     0.968    19.297     0.200
     0.976    19.137     0.200
     1.199    23.338     0.200
     1.199    23.668     0.200
     1.199    23.439     0.200
     0.148     5.001     0.200
     0.148     5.829     0.200
     0.148     5.161     0.200
     0.488     9.672     0.200
     0.488     9.891     0.200
     0.634    12.674     0.200
     0.634    13.424     0.200
     0.806    15.574     0.200
     0.829    16.691     0.200
     0.829    16.379     0.200
     1.022    19.748     0.200
     1.294    25.102     0.200
     2.096    38.453     0.200
     2.323    42.411     0.200
     2.339    39.873     0.200
     0.164     4.109     0.200
     0.164     5.490     0.200
     0.164     4.660     0.200
     0.398     7.257     0.200
     0.504    10.625     0.200
     0.504    11.026     0.200
     0.504    10.295     0.200
     0.509    10.791     0.200
     0.536    11.155     0.200
     0.637    13.454     0.200
     0.701    14.391     0.200
     0.765    16.472     0.200
     0.943    18.605     0.200
     0.943    18.426     0.200
     0.946    19.195     0.200
     0.957    18.713     0.200
     0.979    19.342     0.200
     1.189    23.880     0.200
     1.189    22.739     0.200
     0.286     7.363     0.200
     0.384     8.851     0.200
     0.384     8.732     0.200
     0.397     8.561     0.200
     0.415     9.783     0.200
     0.520    10.667     0.200
     0.520    11.177     0.200
     0.507    10.680     0.200
     0.526    10.578     0.200
     0.678    13.976     0.200
     0.678    14.454     0.200
     0.678    13.726     0.200
     0.786    15.639     0.200
     0.786    15.928     0.200
     0.786    15.499     0.200
     0.917    18.042     0.200
     0.926    18.474     0.200
     0.946    19.082     0.200
     1.009    19.631     0.200
     1.035    20.045     0.200
     1.047    20.958     0.200
     1.047    20.749     0.200
     1.057    20.574     0.200
     1.058    21.197     0.200
     1.109    21.704     0.200
     1.107    21.499     0.200
     1.199    23.019     0.200
     1.199    22.548     0.200
     0.198     4.895     0.200
     0.198     5.684     0.200
     0.198     4.633     0.200
     0.503    10.824     0.200
     0.503    10.574     0.200
     0.490    10.470     0.200
     0.490    11.110     0.200
     0.521    11.217     0.200
     0.561    11.542     0.200
     0.845    19.727     0.200
     0.897    21.241     0.200
     0.950    19.292     0.200
     0.943    20.341     0.200
     0.943    20.523     0.200
     0.965    19.551     0.200
     1.002    20.695     0.200
     1.117    22.926     0.200
     1.180    23.883     0.200
     1.180    23.444     0.200
     1.189    23.544     0.200
     1.269    25.047     0.200
     1.269    24.807     0.200
     1.330    26.128     0.200
     1.452    28.082     0.200
     0.371     7.077     0.200
     0.371     7.710     0.200
     0.371     7.929     0.200
     0.371     7.499     0.200
     0.396     7.990     0.200
     0.396     8.678     0.200
     0.416     9.211     0.200
     0.563    12.274     0.200
     0.563    12.423     0.200
     0.592    13.002     0.200
     0.816    16.951     0.200
     0.915    18.241     0.200
     0.950    22.728     0.200
     0.953    19.592     0.200
     0.997    20.102     0.200
     1.019    21.179     0.200
     1.094    22.832     0.200
     1.104    21.811     0.200
     1.121    21.871     0.200
     1.176    23.067     0.200
     1.185    23.855     0.200
     0.172     5.022     0.200
     0.172     5.522     0.200
     0.451    10.403     0.200
     0.451    11.208     0.200
     0.451     9.958     0.200
     0.479    10.145     0.200
     0.479    10.402     0.200
     0.531    10.956     0.200
     0.560    11.405     0.200
     0.554    11.414     0.200
     0.976    19.226     0.200
     0.985    19.245     0.200
     1.220    23.926     0.200
     0.249     5.641     0.200
     0.249     6.173     0.200
     0.383     8.447     0.200
     0.383     9.185     0.200
     0.383     8.927     0.200
     0.421     9.123     0.200
     0.633    14.118     0.200
     0.715    16.357     0.200
     0.760    15.457     0.200
     0.780    18.600     0.200
     0.823    18.261     0.200
     0.875    20.433     0.200
     0.989    19.144     0.200
     0.957    20.666     0.200
     1.027    21.754     0.200
     1.200    24.064     0.200
     1.215    24.011     0.200
     1.413    28.538     0.200
     1.413    28.069     0.200
     1.413    27.800     0.200
     0.165     4.668     0.200
     0.165     5.427     0.200
     0.165     4.088     0.200
     0.469    10.296     0.200
     0.469    11.197     0.200
     0.469    10.136     0.200
     0.497    10.350     0.200
     0.497    10.890     0.200
     0.516    10.984     0.200
     0.538    11.108     0.200
     0.939    18.489     0.200
     0.939    18.319     0.200
     0.955    19.024     0.200
     0.964    19.277     0.200
     1.176    22.710     0.200
     1.198    23.581     0.200
     0.273     6.326     0.200
     0.272     6.812     0.200
     0.272     7.421     0.200
     0.471     9.844     0.200
     0.634    13.572     0.200
     0.644    13.785     0.200
     0.711    14.897     0.200
     0.711    14.426     0.200
     0.810    16.657     0.200
     0.810    16.186     0.200
     0.914    18.840     0.200
     0.914    18.301     0.200
     0.914    17.792     0.200
     1.015    20.147     0.200
     1.015    19.708     0.200
     1.025    20.257     0.200
     1.052    20.717     0.200
     1.046    20.779     0.200
     1.099    21.243     0.200
     1.096    21.716     0.200
     1.122    21.733     0.200
     1.205    23.790     0.200
     2.376    43.494     0.200
     0.418    10.057     0.200
     0.422     9.012     0.200
     0.422     9.461     0.200
     0.485    10.862     0.200
     0.572    12.020     0.200
     0.572    12.629     0.200
     0.616    13.115     0.200
     0.616    14.064     0.200
     0.616    12.814     0.200
     0.714    14.588     0.200
     0.791    15.782     0.200
     0.798    15.927     0.200
     0.798    15.708     0.200
     0.825    16.430     0.200
     0.875    18.017     0.200
     0.904    17.805     0.200
     0.933    18.821     0.200
     0.976    18.704     0.200
     0.985    19.255     0.200
     0.991    19.575     0.200
     1.011    19.518     0.200
     1.011    19.768     0.200
     1.008    19.541     0.200
     1.031    20.284     0.200
     1.091    20.705     0.200
     1.149    22.168     0.200
     1.164    22.662     0.200
     1.176    22.054     0.200
     1.191    22.355     0.200
     0.250     6.024     0.200
     0.250     6.304     0.200
     0.420     9.317     0.200
     0.382     8.562     0.200
     0.382     9.262     0.200
     0.382     8.432     0.200
     0.634    13.678     0.200
     0.774    15.441     0.200
     0.717    17.416     0.200
     0.760    15.734     0.200
     0.781    18.219     0.200
     0.987    19.649     0.200
     0.876    19.873     0.200
     1.199    24.096     0.200
     1.199    23.716     0.200
     1.214    24.102     0.200
     0.183     4.936     0.200
     0.183     5.846     0.200
     0.183     4.547     0.200
     0.466     9.544     0.200
     0.519    10.991     0.200
     0.539    12.161     0.200
     0.539    11.892     0.200
     0.547    11.967     0.200
     0.547    12.276     0.200
     0.547    10.946     0.200
     0.838    18.345     0.200
     0.867    19.239     0.200
     0.946    18.314     0.200
     0.988    19.557     0.200
     1.109    21.430     0.200
     1.126    22.200     0.200
     1.151    22.359     0.200
     0.237     6.269     0.200
     0.301     7.178     0.200
     0.301     7.567     0.200
     0.301     6.928     0.200
     0.411     8.643     0.200
     0.650    13.727     0.200
     0.650    14.618     0.200
     0.650    13.397     0.200
     0.675    14.136     0.200
     0.675    14.697     0.200
     0.736    14.820     0.200
     0.781    15.555     0.200
     0.895    17.619     0.200
     0.895    17.469     0.200
     0.895    17.238     0.200
     0.991    19.298     0.200
     0.991    18.846     0.200
     0.982    19.037     0.200
     0.995    19.223     0.200
     0.973    19.043     0.200
     1.084    20.706     0.200
     0.279     5.848     0.200
     0.279     6.209     0.200
     0.279     5.739     0.200
     0.544    11.876     0.200
     0.569    12.373     0.200
     0.569    12.592     0.200
     0.569    12.213     0.200
     1.007    20.049     0.200
     1.007    19.749     0.200
     1.016    20.654     0.200
     1.016    21.024     0.200
     1.104    22.612     0.200
     1.181    23.663     0.200
     1.691    31.012     0.200
     0.195     4.386     0.200
     0.195     5.206     0.200
     0.443     9.521     0.200
     0.464     9.642     0.200
     0.529    11.172     0.200
     0.547    11.795     0.200
     0.547    11.965     0.200
     0.542    11.173     0.200
     0.661    13.688     0.200
     0.855    19.734     0.200
     0.894    17.771     0.200
     0.894    18.463     0.200
     0.912    18.033     0.200
     0.886    20.362     0.200
     0.886    18.653     0.200
     0.897    21.050     0.200
     0.897    18.710     0.200
     0.909    18.991     0.200
     0.910    20.767     0.200
     0.974    20.419     0.200
     0.999    19.807     0.200
     1.083    22.137     0.200
     1.101    21.761     0.200
     1.101    21.882     0.200
     1.124    22.653     0.200
     1.124    22.823     0.200
     1.124    21.993     0.200
     1.144    22.865     0.200
     1.144    22.996     0.200
     1.213    23.700     0.200
     3.188    55.088     0.200
     0.193     4.492     0.200
     0.193     5.053     0.200
     0.447     9.584     0.200
     0.469     9.736     0.200
     0.531    10.942     0.200
     0.542    11.841     0.200
     0.537    11.089     0.200
     0.537    11.218     0.200
     0.542    11.972     0.200
     0.662    13.411     0.200
     0.827    17.970     0.200
     0.855    20.035     0.200
     0.899    18.260     0.200
     0.899    18.411     0.200
     0.884    18.349     0.200
     0.897    18.568     0.200
     0.916    18.497     0.200
     0.911    19.044     0.200
     0.912    19.050     0.200
     0.936    19.092     0.200
     0.977    20.188     0.200
     0.996    19.834     0.200
     0.996    19.524     0.200
     1.105    21.899     0.200
     1.105    21.777     0.200
     1.129    22.567     0.200
     1.129    22.798     0.200
     1.218    23.585     0.200
     4.222    72.712     0.200
     0.209     4.735     0.200
     0.209     5.305     0.200
     0.432     9.718     0.200
     0.464    10.423     0.200
     0.535    11.097     0.200
     0.555    11.837     0.200
     0.555    12.068     0.200
     0.542    11.189     0.200
     0.646    14.295     0.200
     0.812    17.542     0.200
     0.841    20.461     0.200
     0.873    20.624     0.200
     0.873    18.732     0.200
     0.882    21.099     0.200
     0.882    18.920     0.200
     0.895    18.893     0.200
     0.920    19.848     0.200
     0.898    18.571     0.200
     0.898    18.350     0.200
     0.918    18.678     0.200
     0.962    20.141     0.200
     1.012    19.834     0.200
     1.012    19.674     0.200
     1.043    22.145     0.200
     1.070    21.899     0.200
     1.091    22.543     0.200
     1.136    23.514     0.200
     1.136    23.110     0.200
     1.122    22.335     0.200
     1.122    22.626     0.200
     1.122    22.816     0.200
     1.211    24.234     0.200
     1.211    23.964     0.200
     1.296    26.016     0.200
     1.273    25.394     0.200
     1.393    27.513     0.200
     1.393    27.054     0.200
     2.051    38.423     0.200
     0.201     5.019     0.200
     0.201     5.878     0.200
     0.431     9.310     0.200
     0.449     9.578     0.200
     0.525    11.166     0.200
     0.554    11.466     0.200
     0.554    11.365     0.200
     0.562    11.711     0.200
     0.562    12.484     0.200
     0.562    11.922     0.200
     0.854    20.277     0.200
     0.880    18.100     0.200
     0.880    18.287     0.200
     0.890    20.507     0.200
     0.900    18.758     0.200
     1.009    19.900     0.200
     1.009    20.509     0.200
     1.009    19.681     0.200
     1.071    22.467     0.200
     1.087    21.646     0.200
     1.108    22.359     0.200
     1.108    22.492     0.200
     1.129    23.042     0.200
     1.197    23.450     0.200
     1.381    26.848     0.200
     1.382    26.744     0.200
     1.571    30.064     0.200
     0.193     4.740     0.200
     0.193     6.050     0.200
     0.528    10.951     0.200
     0.463     9.692     0.200
     0.444     9.319     0.200
     0.547    11.957     0.200
     0.543    11.289     0.200
     0.893    17.948     0.200
     0.911    18.501     0.200
     0.998    19.798     0.200
     0.998    19.668     0.200
     0.857    19.831     0.200
     0.911    20.837     0.200
     0.898    20.608     0.200
     0.935    19.913     0.200
     1.123    22.814     0.200
     1.123    22.633     0.200
     1.084    22.442     0.200
     1.212    23.730     0.200
     1.276    25.360     0.200
     0.243     5.812     0.200
     0.244     5.554     0.200
     0.387     8.701     0.200
     0.387     9.162     0.200
     0.387     8.369     0.200
     0.407     9.222     0.200
     0.407     9.433     0.200
     0.651    13.134     0.200
     0.696    14.561     0.200
     0.723    17.450     0.200
     0.779    15.708     0.200
     0.792    18.229     0.200
     0.838    18.171     0.200
     0.977    19.570     0.200
     0.977    18.628     0.200
     0.979    20.039     0.200
     1.428    27.104     0.200
     1.511    27.696     0.200
     0.288     7.067     0.200
     0.288     7.497     0.200
     0.365     7.660     0.200
     0.366     8.021     0.200
     0.533    11.573     0.200
     0.633    13.330     0.200
     0.672    13.761     0.200
     0.672    14.141     0.200
     0.644    13.299     0.200
     0.768    18.293     0.200
     0.787    18.603     0.200
     0.800    18.072     0.200
     0.861    19.941     0.200
     0.925    20.940     0.200
     0.992    19.655     0.200
     1.027    22.036     0.200
     1.089    22.160     0.200
     1.288    26.058     0.200
     1.372    26.853     0.200
     1.426    27.341     0.200
     0.182     4.821     0.200
     0.182     5.802     0.200
     0.468     9.766     0.200
     0.468    10.883     0.200
     0.490    10.260     0.200
     0.533    11.198     0.200
     0.520    11.698     0.200
     0.520    11.366     0.200
     0.524    11.082     0.200
     0.931    18.616     0.200
     0.931    18.795     0.200
     0.978    19.566     0.200
     1.150    22.746     0.200
     1.240    24.068     0.200
     1.240    23.646     0.200
     3.161    55.179     0.200
     0.186     4.425     0.200
     0.186     5.694     0.200
     0.186     4.085     0.200
     0.462     9.944     0.200
     0.484    10.113     0.200
     0.533    10.816     0.200
     0.533    11.195     0.200
     0.527    11.138     0.200
     0.528    11.059     0.200
     0.927    19.453     0.200
     0.984    19.808     0.200
     0.991    20.191     0.200
     1.120    21.788     0.200
     1.144    22.920     0.200
     1.144    22.592     0.200
     1.234    23.963     0.200
     1.234    23.444     0.200
     0.286     6.175     0.200
     0.287     6.769     0.200
     0.287     7.179     0.200
     0.345     7.829     0.200
     0.345     8.372     0.200
     0.345     7.969     0.200
     0.383     8.303     0.200
     0.383     9.042     0.200
     0.383     9.663     0.200
     0.645    13.630     0.200
     0.737    14.688     0.200
     0.737    14.840     0.200
     0.714    14.584     0.200
     0.762    17.817     0.200
     0.822    18.950     0.200
     0.822    19.410     0.200
     0.861    18.524     0.200
     0.945    18.318     0.200
     0.945    18.736     0.200
     1.190    23.216     0.200
     1.190    23.325     0.200
     2.053    37.382     0.200
     0.167     4.550     0.200
     0.167     4.920     0.200
     0.167     4.180     0.200
     0.475    10.119     0.200
     0.475    10.809     0.200
     0.475     9.869     0.200
     0.498    10.588     0.200
     0.499    10.570     0.200
     0.499    10.200     0.200
     0.510    11.292     0.200
     0.510    10.622     0.200
     0.540    11.311     0.200
     0.700    14.554     0.200
     0.863    19.158     0.200
     0.944    18.369     0.200
     0.944    19.300     0.200
     0.944    18.080     0.200
     0.962    19.463     0.200
     1.170    24.099     0.200
     1.193    23.540     0.200
     1.193    24.030     0.200
     1.216    24.256     0.200
     1.284    25.062     0.200
     1.349    26.631     0.200
     1.468    28.442     0.200
     1.470    28.221     0.200
     0.561    11.576     0.200
     0.561    12.135     0.200
     0.562    11.316     0.200
     0.562    12.015     0.200
     0.560    11.861     0.200
     0.560    12.682     0.200
     0.644    13.361     0.200
     0.734    14.546     0.200
     0.734    14.364     0.200
     0.759    14.894     0.200
     0.769    15.030     0.200
     0.794    15.727     0.200
     0.806    15.745     0.200
     0.822    15.814     0.200
     0.916    16.832     0.200
     1.770    31.371     0.200
     0.320     7.046     0.200
     0.320     7.927     0.200
     0.320     7.177     0.200
     0.322     6.990     0.200
     0.322     7.240     0.200
     0.325     7.725     0.200
     0.325     8.235     0.200
     0.693    14.436     0.200
     0.713    14.323     0.200
     0.771    15.750     0.200
     0.777    15.984     0.200
     0.882    17.417     0.200
     1.189    23.456     0.200
     1.430    28.133     0.200
     0.321     7.352     0.200
     0.321     7.832     0.200
     0.321     8.442     0.200
     0.321     7.211     0.200
     0.315     6.968     0.200
     0.316     6.941     0.200
     0.316     7.289     0.200
     0.332     7.709     0.200
     0.332     8.299     0.200
     0.719    14.386     0.200
     0.696    14.614     0.200
     0.885    17.509     0.200
     0.815    19.102     0.200
     0.777    15.889     0.200
     0.776    15.707     0.200
     0.883    20.592     0.200
     1.056    21.172     0.200
     1.195    23.433     0.200
     1.435    28.031     0.200
     0.293     6.551     0.200
     0.293     6.512     0.200
     0.339     7.831     0.200
     0.339     8.581     0.200
     0.339     8.031     0.200
     0.381     8.347     0.200
     0.381     8.819     0.200
     0.381     8.218     0.200
     0.644    13.276     0.200
     0.716    14.888     0.200
     0.730    14.980     0.200
     0.745    15.436     0.200
     0.767    18.064     0.200
     0.863    18.763     0.200
     0.918    19.937     0.200
     0.941    18.309     0.200
     0.941    19.059     0.200
     0.941    19.199     0.200
     1.184    23.226     0.200
     1.184    23.366     0.200
     1.401    27.649     0.200
     0.178     5.022     0.200
     0.178     4.823     0.200
     0.178     5.252     0.200
     0.442     9.928     0.200
     0.468     9.971     0.200
     0.469     9.904     0.200
     0.540    11.344     0.200
     0.572    11.848     0.200
     0.562    11.749     0.200
     0.562    11.640     0.200
     0.712    14.466     0.200
     0.873    19.284     0.200
     0.873    18.882     0.200
     0.879    19.963     0.200
     0.926    18.834     0.200
     0.926    19.361     0.200
     0.997    20.542     0.200
     0.997    19.871     0.200
     1.202    23.480     0.200
     1.202    23.343     0.200
     1.232    24.424     0.200
     1.530    27.661     0.200
     0.184     5.142     0.200
     0.184     4.771     0.200
     0.184     5.302     0.200
     0.469    10.047     0.200
     0.470    10.336     0.200
     0.470     9.969     0.200
     0.456     9.569     0.200
     0.456    10.151     0.200
     0.456    10.670     0.200
     0.526    10.589     0.200
     0.526    10.781     0.200
     0.526    11.070     0.200
     0.562    11.798     0.200
     0.562    12.427     0.200
     0.565    11.860     0.200
     0.565    11.309     0.200
     0.699    15.260     0.200
     0.867    19.854     0.200
     0.861    18.859     0.200
     0.861    19.301     0.200
     0.868    19.849     0.200
     0.939    18.157     0.200
     0.939    18.809     0.200
     0.993    19.823     0.200
     0.993    19.374     0.200
     1.237    23.975     0.200
     1.222    24.474     0.200
     1.222    25.314     0.200
     1.312    25.592     0.200
     1.312    25.365     0.200
     0.181     4.804     0.200
     0.452     9.851     0.200
     0.452     9.730     0.200
     0.471     9.876     0.200
     0.471     9.490     0.200
     0.530    11.109     0.200
     0.563    11.793     0.200
     0.564    11.875     0.200
     0.870    19.389     0.200
     0.935    18.645     0.200
     0.935    19.215     0.200
     0.935    19.317     0.200
     0.935    17.997     0.200
     0.993    19.784     0.200
     1.191    23.143     0.200
     1.224    24.323     0.200
     1.224    24.163     0.200
     1.314    25.232     0.200
     1.524    27.187     0.200
     0.183     4.859     0.200
     0.183     5.359     0.200
     0.450    10.381     0.200
     0.450     9.612     0.200
     0.467    10.093     0.200
     0.468    10.238     0.200
     0.468     9.957     0.200
     0.532    11.000     0.200
     0.532    10.883     0.200
     0.565    11.730     0.200
     0.567    11.846     0.200
     0.703    14.628     0.200
     0.865    18.941     0.200
     0.871    19.852     0.200
     0.934    18.978     0.200
     0.934    19.388     0.200
     0.934    18.080     0.200
     0.996    19.755     0.200
     1.168    23.212     0.200
     1.194    23.357     0.200
     1.227    24.060     0.200
     1.227    24.169     0.200
     1.227    23.841     0.200
     1.242    23.917     0.200
     1.317    25.340     0.200
     1.317    25.219     0.200
     0.447     9.849     0.200
     0.447     9.607     0.200
     0.476    10.101     0.200
     0.535    10.966     0.200
     0.555    11.643     0.200
     0.564    11.808     0.200
     0.879    20.388     0.200
     0.927    18.705     0.200
     0.927    18.255     0.200
     0.989    20.225     0.200
     0.989    19.455     0.200
     1.057    22.072     0.200
     1.197    23.466     0.200
     1.225    24.461     0.200
     1.315    25.113     0.200
     0.183     4.647     0.200
     0.183     5.166     0.200
     0.453    10.405     0.200
     0.453     9.616     0.200
     0.469     9.824     0.200
     0.565    11.638     0.200
     0.528    10.941     0.200
     0.564    11.913     0.200
     0.937    19.010     0.200
     0.937    18.810     0.200
     0.980    20.057     0.200
     0.994    19.521     0.200
     1.224    24.529     0.200
     1.224    23.908     0.200
     1.239    23.839     0.200
     1.314    25.049     0.200
     0.191     4.915     0.200
     0.471    10.257     0.200
     0.473    10.102     0.200
     0.510    11.156     0.200
     0.550    11.686     0.200
     0.567    11.766     0.200
     0.686    14.139     0.200
     0.954    18.550     0.200
     0.954    18.948     0.200
     0.964    22.612     0.200
     0.986    20.649     0.200
     1.172    23.532     0.200
     1.172    23.321     0.200
     1.210    24.198     0.200
     1.210    24.897     0.200
     1.221    24.198     0.200
     1.299    25.612     0.200
     1.299    25.726     0.200
     1.362    26.684     0.200
     1.483    28.965     0.200
     0.183     4.973     0.200
     0.458     9.903     0.200
     0.458     9.774     0.200
     0.471    10.242     0.200
     0.471     9.922     0.200
     0.524    10.828     0.200
     0.560    12.207     0.200
     0.563    11.460     0.200
     0.698    13.924     0.200
     0.698    14.585     0.200
     0.860    19.214     0.200
     0.940    18.852     0.200
     0.991    20.522     0.200
     1.186    23.741     0.200
     1.220    24.273     0.200
     1.220    24.816     0.200
     1.310    25.555     0.200
     1.310    25.286     0.200
     0.183     5.034     0.200
     0.183     4.721     0.200
     0.183     5.221     0.200
     0.456     9.698     0.200
     0.456     9.936     0.200
     0.456    10.518     0.200
     0.471    10.050     0.200
     0.471    10.003     0.200
     0.525    11.033     0.200
     0.525    10.841     0.200
     0.561    11.429     0.200
     0.561    12.077     0.200
     0.561    12.339     0.200
     0.563    11.794     0.200
     0.563    11.141     0.200
     0.700    14.059     0.200
     0.861    19.099     0.200
     0.869    19.674     0.200
     0.939    17.925     0.200
     0.939    18.914     0.200
     0.939    19.304     0.200
     0.991    19.731     0.200
     1.187    22.907     0.200
     1.221    24.034     0.200
     1.221    24.303     0.200
     1.236    23.950     0.200
     1.311    24.905     0.200
     0.183     5.079     0.200
     0.450     9.752     0.200
     0.466    10.200     0.200
     0.467    10.591     0.200
     0.467    10.692     0.200
     0.532    11.465     0.200
     0.532    11.036     0.200
     0.566    11.769     0.200
     0.566    11.640     0.200
     0.568    11.643     0.200
     0.703    15.414     0.200
     0.703    13.832     0.200
     0.865    19.029     0.200
     0.871    19.410     0.200
     0.868    18.796     0.200
     0.934    18.735     0.200
     0.934    18.235     0.200
     0.996    19.801     0.200
     0.996    19.313     0.200
     1.052    21.479     0.200
     1.194    23.118     0.200
     1.228    24.411     0.200
     1.228    24.009     0.200
     1.228    23.732     0.200
     1.243    23.920     0.200
     1.318    24.958     0.200
     1.503    27.875     0.200
     1.522    26.264     0.200
     0.181     4.555     0.200
     0.181     5.385     0.200
     0.181     5.805     0.200
     0.445     9.992     0.200
     0.467    10.313     0.200
     0.571    11.460     0.200
     0.571    12.389     0.200
     0.565    11.549     0.200
     0.929    18.792     0.200
     1.174    23.303     0.200
     1.199    22.937     0.200
     1.232    24.624     0.200
     1.232    24.374     0.200
     1.322    25.329     0.200
     1.526    27.179     0.200
     3.079    55.299     0.200
     0.184     4.937     0.200
     0.184     5.308     0.200
     0.447     9.810     0.200
     0.465     9.633     0.200
     0.567    11.639     0.200
     0.534    11.141     0.200
     0.571    11.715     0.200
     0.933    18.490     0.200
     0.933    18.621     0.200
     0.999    20.148     0.200
     1.196    23.693     0.200
     1.231    23.710     0.200
     1.231    24.511     0.200
     0.195     5.382     0.200
     0.467    10.019     0.200
     0.467    10.289     0.200
     0.465     9.820     0.200
     0.514    10.125     0.200
     0.557    11.596     0.200
     0.685    13.826     0.200
     0.953    18.599     0.200
     0.953    18.197     0.200
     0.947    20.452     0.200
     1.033    20.639     0.200
     1.176    22.766     0.200
     1.176    22.255     0.200
     1.217    24.258     0.200
     1.226    23.424     0.200
     0.174     4.421     0.200
     0.174     4.890     0.200
     0.452     9.817     0.200
     0.452    10.931     0.200
     0.452     9.239     0.200
     0.477    10.103     0.200
     0.531    11.236     0.200
     0.556    11.357     0.200
     0.556    12.017     0.200
     0.561    11.592     0.200
     0.931    18.445     0.200
     0.931    18.183     0.200
     0.987    19.446     0.200
     1.221    24.663     0.200
     1.221    24.073     0.200
     1.311    25.177     0.200
     0.070     2.579     0.200
     0.070     2.810     0.200
     0.487    10.753     0.200
     0.487     9.964     0.200
     0.504    10.929     0.200
     0.628    13.161     0.200
     0.701    14.367     0.200
     0.814    16.466     0.200
     0.812    17.222     0.200
     1.142    23.373     0.200
     1.142    22.482     0.200
     1.160    22.737     0.200
     1.252    24.002     0.200
     1.245    24.294     0.200
     1.455    27.666     0.200
     1.843    34.538     0.200
     2.222    41.230     0.200
     0.135     3.778     0.200
     0.135     4.227     0.200
     0.437     9.465     0.200
     0.437     9.594     0.200
     0.508    11.026     0.200
     0.508    11.635     0.200
     0.552    11.632     0.200
     0.552    11.819     0.200
     0.552    12.362     0.200
     0.556    11.458     0.200
     0.900    17.608     0.200
     0.900    19.088     0.200
     0.965    19.272     0.200
     1.216    23.894     0.200
     1.309    25.059     0.200
     1.569    27.069     0.200
     0.180     4.829     0.200
     0.458    10.343     0.200
     0.458    10.183     0.200
     0.475     9.980     0.200
     0.475    10.052     0.200
     0.475     9.754     0.200
     0.524    11.204     0.200
     0.524    10.914     0.200
     0.560    11.898     0.200
     0.560    11.638     0.200
     0.557    11.403     0.200
     0.700    15.607     0.200
     0.700    13.896     0.200
     0.862    18.924     0.200
     0.872    19.737     0.200
     0.939    18.783     0.200
     0.939    18.382     0.200
     0.987    19.672     0.200
     1.186    23.033     0.200
     1.218    23.570     0.200
     1.218    23.439     0.200
     1.234    23.771     0.200
     1.308    24.756     0.200
     1.371    26.135     0.200
     0.186     5.213     0.200
     0.186     4.733     0.200
     0.186     5.763     0.200
     0.466    10.292     0.200
     0.466    10.403     0.200
     0.473    10.065     0.200
     0.474    10.087     0.200
     0.516    10.990     0.200
     0.516    11.200     0.200
     0.563    11.848     0.200
     0.563    11.598     0.200
     0.553    11.409     0.200
     0.866    20.007     0.200
     0.863    18.728     0.200
     0.854    19.492     0.200
     0.947    18.325     0.200
     0.947    19.325     0.200
     0.986    19.333     0.200
     1.213    23.697     0.200
     1.213    23.937     0.200
     1.303    25.120     0.200
     1.303    24.870     0.200
     1.516    26.946     0.200
     0.187     4.856     0.200
     0.187     4.177     0.200
     0.187     5.087     0.200
     0.187     5.547     0.200
     0.466    10.147     0.200
     0.472    10.034     0.200
     0.473    10.266     0.200
     0.473     9.986     0.200
     0.515    10.581     0.200
     0.553    11.220     0.200
     0.564    11.691     0.200
     0.691    14.343     0.200
     0.853    19.360     0.200
     0.853    18.110     0.200
     0.948    18.903     0.200
     0.948    18.793     0.200
     0.948    19.353     0.200
     0.987    20.199     0.200
     1.036    21.127     0.200
     1.036    21.227     0.200
     1.152    22.980     0.200
     1.177    22.667     0.200
     1.177    22.867     0.200
     1.213    23.378     0.200
     1.213    24.908     0.200
     1.213    24.008     0.200
     1.303    25.043     0.200
     0.186     4.864     0.200
     0.474    10.046     0.200
     0.478     9.947     0.200
     0.479    10.379     0.200
     0.479     9.449     0.200
     0.508    10.942     0.200
     0.545    11.192     0.200
     0.561    11.633     0.200
     0.687    14.772     0.200
     0.687    14.512     0.200
     0.850    19.304     0.200
     0.850    19.144     0.200
     0.860    19.791     0.200
     0.866    20.168     0.200
     0.866    18.616     0.200
     0.953    18.663     0.200
     0.953    18.192     0.200
     0.980    19.712     0.200
     0.966    19.611     0.200
     0.966    20.342     0.200
     1.145    23.616     0.200
     1.170    23.621     0.200
     1.205    24.782     0.200
     1.205    23.180     0.200
     1.218    24.058     0.200
     1.294    25.276     0.200
     1.478    28.490     0.200
     1.478    28.310     0.200
     3.108    56.199     0.200
     0.178     4.902     0.200
     0.461    10.219     0.200
     0.479    10.244     0.200
     0.479     9.970     0.200
     0.479     9.588     0.200
     0.521    10.574     0.200
     0.553    10.937     0.200
     0.556    11.437     0.200
     0.700    15.044     0.200
     0.700    13.840     0.200
     0.862    18.930     0.200
     0.871    19.941     0.200
     0.874    19.914     0.200
     0.874    19.976     0.200
     0.940    18.320     0.200
     0.983    19.541     0.200
     1.043    21.016     0.200
     1.183    22.980     0.200
     1.213    23.303     0.200
     1.213    23.912     0.200
     1.230    23.548     0.200
     3.097    56.370     0.200
     0.180     4.748     0.200
     0.180     4.420     0.200
     0.474     9.785     0.200
     0.474     9.605     0.200
     0.485    10.378     0.200
     0.486    10.070     0.200
     0.486     9.699     0.200
     0.509    10.823     0.200
     0.541    11.171     0.200
     0.554    11.325     0.200
     0.554    11.696     0.200
     0.691    14.541     0.200
     0.691    13.799     0.200
     0.854    19.519     0.200
     0.872    20.109     0.200
     0.921    21.358     0.200
     0.974    19.445     0.200
     0.970    20.371     0.200
     1.201    23.796     0.200
     1.291    24.656     0.200
     0.181     4.765     0.200
     0.454     9.918     0.200
     0.454     9.478     0.200
     0.470    10.083     0.200
     0.471    10.065     0.200
     0.471    10.235     0.200
     0.528    11.388     0.200
     0.562    12.079     0.200
     0.562    11.739     0.200
     0.563    11.964     0.200
     0.864    19.709     0.200
     0.870    20.178     0.200
     0.870    19.876     0.200
     0.871    20.599     0.200
     0.936    18.627     0.200
     0.936    17.586     0.200
     0.930    21.870     0.200
     0.992    20.089     0.200
     0.992    20.288     0.200
     1.049    21.764     0.200
     1.223    24.711     0.200
     1.313    25.637     0.200
     0.177     4.861     0.200
     0.177     4.550     0.200
     0.177     5.099     0.200
     0.450    10.306     0.200
     0.450    10.136     0.200
     0.473     9.982     0.200
     0.474     9.963     0.200
     0.474    10.633     0.200
     0.474     9.824     0.200
     0.559    11.353     0.200
     0.559    11.642     0.200
     0.559    11.783     0.200
     0.532    10.969     0.200
     0.563    11.529     0.200
     0.707    14.694     0.200
     0.869    19.384     0.200
     0.875    20.386     0.200
     0.876    19.582     0.200
     0.932    18.331     0.200
     0.932    18.530     0.200
     0.990    19.749     0.200
     0.990    19.249     0.200
     1.169    22.923     0.200
     1.193    23.556     0.200
     1.224    23.994     0.200
     1.224    24.314     0.200
     1.241    23.797     0.200
     1.314    25.157     0.200
     0.181     4.743     0.200
     0.181     5.454     0.200
     0.460    10.077     0.200
     0.460     9.589     0.200
     0.474    10.080     0.200
     0.475    10.084     0.200
     0.522    10.744     0.200
     0.556    11.365     0.200
     0.560    11.630     0.200
     0.698    13.857     0.200
     0.861    18.676     0.200
     0.869    20.266     0.200
     0.941    18.627     0.200
     0.941    18.768     0.200
     0.987    19.296     0.200
     0.987    19.706     0.200
     1.184    23.014     0.200
     1.216    23.712     0.200
     1.216    24.114     0.200
     1.306    24.981     0.200
     1.306    24.853     0.200
     1.522    26.897     0.200
     0.182     5.048     0.200
     0.182     5.329     0.200
     0.465    10.244     0.200
     0.465    10.482     0.200
     0.477    10.160     0.200
     0.477     9.930     0.200
     0.517    10.517     0.200
     0.517    10.075     0.200
     0.560    11.513     0.200
     0.560    11.861     0.200
     0.552    11.235     0.200
     0.695    15.051     0.200
     0.867    19.977     0.200
     0.945    18.884     0.200
     0.945    18.767     0.200
     0.974    19.907     0.200
     0.983    19.516     0.200
     1.179    22.925     0.200
     1.212    23.813     0.200
     1.302    25.073     0.200
     0.182     4.470     0.200
     0.182     4.368     0.200
     0.182     5.360     0.200
     0.465    10.145     0.200
     0.465    10.517     0.200
     0.477    10.210     0.200
     0.477     9.972     0.200
     0.517    10.522     0.200
     0.551    11.217     0.200
     0.560    11.685     0.200
     0.560    11.443     0.200
     0.695    14.235     0.200
     0.857    18.571     0.200
     0.866    20.001     0.200
     0.869    19.979     0.200
     0.945    18.758     0.200
     0.945    18.946     0.200
     0.945    19.836     0.200
     0.945    17.715     0.200
     0.983    19.240     0.200
     1.154    23.016     0.200
     1.179    22.758     0.200
     1.212    23.943     0.200
     1.227    23.818     0.200
     1.301    24.226     0.200
     1.480    27.263     0.200
     0.105     3.506     0.200
     0.422     8.314     0.200
     0.422     9.885     0.200
     0.487    10.682     0.200
     0.487    11.073     0.200
     0.556    11.883     0.200
     0.556    12.868     0.200
     0.583    11.810     0.200
     0.636    12.825     0.200
     0.636    12.927     0.200
     0.636    13.661     0.200
     0.636    13.770     0.200
     0.728    14.584     0.200
     0.732    14.087     0.200
     0.732    14.360     0.200
     0.740    14.376     0.200
     0.758    14.622     0.200
     0.758    14.902     0.200
     0.801    15.618     0.200
     0.840    16.002     0.200
     0.856    16.230     0.200
     0.869    17.259     0.200
     0.911    17.214     0.200
     0.940    18.073     0.200
     0.973    19.047     0.200
     1.028    19.332     0.200
     1.032    20.268     0.200
     1.467    26.474     0.200
     1.612    28.099     0.200
     1.698    31.137     0.200
     1.836    33.529     0.200
     1.963    34.809     0.200
     0.192     4.301     0.200
     0.192     5.082     0.200
     0.475    10.184     0.200
     0.474    10.156     0.200
     0.474    10.465     0.200
     0.506    10.951     0.200
     0.547    11.387     0.200
     0.566    11.761     0.200
     0.957    18.555     0.200
     0.957    18.703     0.200
     0.984    19.875     0.200
     1.168    23.129     0.200
     1.207    24.232     0.200
     1.207    23.821     0.200
     1.296    25.487     0.200
     1.479    28.529     0.200
     1.479    28.689     0.200
     0.175     4.829     0.200
     0.175     5.048     0.200
     0.456    10.181     0.200
     0.456     9.981     0.200
     0.478    10.197     0.200
     0.478    10.029     0.200
     0.478    10.361     0.200
     0.478    10.619     0.200
     0.526    10.712     0.200
     0.526    10.900     0.200
     0.555    11.502     0.200
     0.555    11.373     0.200
     0.704    15.084     0.200
     0.867    18.961     0.200
     0.876    19.942     0.200
     0.933    19.448     0.200
     0.935    18.752     0.200
     0.935    18.604     0.200
     0.984    19.527     0.200
     0.984    19.637     0.200
     1.188    23.283     0.200
     1.188    23.002     0.200
     1.217    23.812     0.200
     1.217    23.480     0.200
     1.308    24.675     0.200
     1.528    26.975     0.200
     1.696    29.759     0.200
     0.183     4.345     0.200
     0.183     5.408     0.200
     0.471    10.388     0.200
     0.480    10.118     0.200
     0.481    10.056     0.200
     0.481    10.470     0.200
     0.511    11.328     0.200
     0.511    10.977     0.200
     0.546    11.363     0.200
     0.546    11.895     0.200
     0.558    11.432     0.200
     0.558    11.604     0.200
     0.691    15.276     0.200
     0.691    13.862     0.200
     0.864    20.060     0.200
     0.869    20.310     0.200
     0.921    20.959     0.200
     0.949    18.658     0.200
     0.949    19.221     0.200
     0.949    19.947     0.200
     0.979    19.542     0.200
     1.296    25.238     0.200
     1.359    26.398     0.200
     2.223    40.703     0.200
     0.464     9.868     0.200
     0.565    10.969     0.200
     0.471    10.023     0.200
     0.472    10.024     0.200
     0.518    11.057     0.200
     0.863    19.439     0.200
     0.865    19.908     0.200
     0.865    19.917     0.200
     0.921    21.463     0.200
     1.081    22.750     0.200
     1.155    23.648     0.200
     1.180    24.162     0.200
     1.228    24.275     0.200
     1.305    25.268     0.200
     1.368    26.994     0.200
     1.489    28.083     0.200
     0.340     7.957     0.200
     0.267     6.119     0.200
     0.267     6.420     0.200
     0.468     9.786     0.200
     0.468     9.684     0.200
     0.468    10.255     0.200
     0.651    13.389     0.200
     0.707    14.145     0.200
     0.707    14.254     0.200
     0.707    15.895     0.200
     0.803    16.595     0.200
     0.804    16.279     0.200
     0.798    15.980     0.200
     0.798    16.081     0.200
     0.918    18.667     0.200
     0.918    18.928     0.200
     1.019    20.237     0.200
     1.019    19.858     0.200
     0.994    20.499     0.200
     1.053    20.751     0.200
     1.046    20.186     0.200
     1.046    20.534     0.200
     1.103    21.380     0.200
     1.103    21.271     0.200
     1.098    21.727     0.200
     1.069    21.381     0.200
     1.124    21.776     0.200
     1.226    23.649     0.200
     1.226    23.336     0.200
     0.339     7.877     0.200
     0.339     8.147     0.200
     0.202     5.134     0.200
     0.439     9.404     0.200
     0.366     8.257     0.200
     0.665    13.410     0.200
     0.772    15.730     0.200
     0.797    16.841     0.200
     0.888    18.189     0.200
     0.956    18.685     0.200
     0.943    18.112     0.200
     0.955    19.276     0.200
     0.955    18.536     0.200
     1.011    20.318     0.200
     1.030    19.771     0.200
     1.143    22.331     0.200
     1.153    21.847     0.200
     1.153    22.087     0.200
     1.534    27.691     0.200
     0.186     4.540     0.200
     0.186     5.693     0.200
     0.186     5.009     0.200
     0.476    10.182     0.200
     0.477    10.432     0.200
     0.477    10.823     0.200
     0.470    10.844     0.200
     0.470    10.493     0.200
     0.512    10.481     0.200
     0.512    10.763     0.200
     0.549    11.322     0.200
     0.549    11.912     0.200
     0.549    11.182     0.200
     0.562    11.432     0.200
     0.690    14.138     0.200
     0.690    13.786     0.200
     0.690    15.497     0.200
     0.862    19.968     0.200
     0.866    20.183     0.200
     0.971    19.035     0.200
     0.983    19.667     0.200
     1.209    24.363     0.200
     1.209    23.781     0.200
     1.298    25.145     0.200
     1.298    24.825     0.200
     0.191     4.873     0.200
     0.191     5.303     0.200
     0.476    10.062     0.200
     0.477    10.023     0.200
     0.477    10.464     0.200
     0.478    10.149     0.200
     0.504    10.668     0.200
     0.544    11.251     0.200
     0.565    11.416     0.200
     0.565    11.916     0.200
     0.682    14.091     0.200
     0.855    19.756     0.200
     0.911    20.774     0.200
     0.968    19.745     0.200
     0.981    19.711     0.200
     1.166    22.862     0.200
     1.204    24.131     0.200
     1.293    25.211     0.200
     1.509    26.766     0.200
     0.186     4.876     0.200
     0.186     6.075     0.200
     0.186     5.177     0.200
     0.468    10.328     0.200
     0.468    11.109     0.200
     0.475    10.160     0.200
     0.476    10.031     0.200
     0.514    10.710     0.200
     0.514    10.511     0.200
     0.550    11.158     0.200
     0.562    11.679     0.200
     0.562    11.832     0.200
     0.691    14.144     0.200
     0.853    19.280     0.200
     0.973    19.353     0.200
     0.984    19.620     0.200
     0.984    18.846     0.200
     1.175    22.737     0.200
     1.210    24.269     0.200
     1.210    23.589     0.200
     1.224    23.492     0.200
     1.516    26.725     0.200
     0.275     6.154     0.200
     0.275     7.034     0.200
     0.264     6.197     0.200
     0.264     6.566     0.200
     0.264     6.686     0.200
     0.354     7.796     0.200
     0.354     7.936     0.200
     0.456     9.842     0.200
     0.456    10.002     0.200
     0.650    13.511     0.200
     0.650    13.661     0.200
     0.662    13.854     0.200
     0.662    13.635     0.200
     0.704    14.182     0.200
     0.704    14.941     0.200
     0.783    16.190     0.200
     0.791    15.930     0.200
     0.792    15.942     0.200
     0.921    18.790     0.200
     1.021    20.042     0.200
     1.039    19.770     0.200
     1.039    20.451     0.200
     1.048    20.864     0.200
     1.104    21.414     0.200
     1.104    21.553     0.200
     1.123    21.910     0.200
     1.211    23.289     0.200
     1.678    28.722     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
