#!/bin/bash
gmt begin alberchigos1.34_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source alberchigos1.34'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  0.8 -10.0
  0.8 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.224     0.181     0.200
     0.466    -0.193     0.200
     0.471     0.497     0.200
     0.710    -0.277     0.200
     0.784     0.243     0.200
     0.916     0.061     0.200
     0.943     0.264     0.200
     0.953     0.501     0.200
     0.267    -0.200     0.200
     0.781    -0.392     0.200
     0.835    -0.087     0.200
     0.881    -0.185     0.200
     0.880    -0.290     0.200
     0.949     0.296     0.200
     0.989     0.135     0.200
     0.733     0.582     0.200
     0.941     0.120     0.200
     0.500    -0.143     0.200
     0.709     0.036     0.200
     0.825    -0.162     0.200
     0.936    -0.233     0.200
     0.991    -0.379     0.200
     0.193     0.532     0.200
     0.618     0.044     0.200
     0.782     0.108     0.200
     0.758     0.002     0.200
     0.802     0.019     0.200
     0.776    -0.401     0.200
     0.803     0.005     0.200
     0.828    -0.240     0.200
     0.868     0.057     0.200
     0.906    -0.299     0.200
     0.958     0.411     0.200
     1.000     0.463     0.200
     0.783     0.909     0.200
     0.975     0.452     0.200
     0.569    -0.048     0.200
     0.448     0.153     0.200
     0.819    -0.084     0.200
     0.874    -0.301     0.200
     0.840     0.960     0.200
     0.967     0.200     0.200
     0.990    -0.144     0.200
     0.398     0.245     0.200
     0.398     0.175     0.200
     0.394     0.251     0.200
     0.464     0.061     0.200
     0.607    -0.290     0.200
     0.809     0.096     0.200
     0.826     0.101     0.200
     0.919    -0.913     0.200
     0.944     0.854     0.200
     0.311    -0.565     0.200
     0.311     0.134     0.200
     0.312    -0.531     0.200
     0.315     0.117     0.200
     0.316    -0.423     0.200
     0.316     0.247     0.200
     0.377    -0.222     0.200
     0.573    -0.362     0.200
     0.904    -0.509     0.200
     0.343    -0.353     0.200
     0.343     0.307     0.200
     0.277     1.136     0.200
     0.370    -0.158     0.200
     0.372    -0.155     0.200
     0.423    -0.120     0.200
     0.622    -0.484     0.200
     0.998     0.899     0.200
     0.686     0.180     0.200
     0.777    -0.014     0.200
     0.814     0.336     0.200
     0.855    -0.112     0.200
     0.970     0.268     0.200
     0.256     0.847     0.200
     0.375    -0.057     0.200
     0.428     0.325     0.200
     0.467    -0.073     0.200
     0.681    -0.181     0.200
     0.319    -0.220     0.200
     0.319     0.030     0.200
     0.310     0.232     0.200
     0.313     0.048     0.200
     0.555    -0.105     0.200
     0.824    -0.147     0.200
     0.910    -0.530     0.200
     0.885    -0.715     0.200
     0.302     0.500     0.200
     0.274     0.380     0.200
     0.528    -0.014     0.200
     0.646    -0.189     0.200
     0.724    -0.382     0.200
     0.730    -0.213     0.200
     0.808    -0.021     0.200
     0.897    -0.499     0.200
     0.975     0.625     0.200
     0.279     0.151     0.200
     0.281     0.142     0.200
     0.545     0.197     0.200
     0.584     0.026     0.200
     0.695     0.727     0.200
     0.896    -0.148     0.200
     0.285     0.173     0.200
     0.287     0.128     0.200
     0.558    -0.156     0.200
     0.573     0.138     0.200
     0.692     0.657     0.200
     0.885     0.028     0.200
     0.288     0.251     0.200
     0.289     0.313     0.200
     0.552     0.092     0.200
     0.574     0.265     0.200
     0.688     0.870     0.200
     0.886     0.061     0.200
     0.573     0.054     0.200
     0.698     0.383     0.200
     0.884    -0.120     0.200
     0.282     0.286     0.200
     0.283     0.062     0.200
     0.283     0.273     0.200
     0.553     0.061     0.200
     0.578     0.189     0.200
     0.694     0.732     0.200
     0.890    -0.389     0.200
     0.269     0.128     0.200
     0.271     0.134     0.200
     0.583    -0.153     0.200
     0.562    -0.318     0.200
     0.710     0.119     0.200
     0.895     0.143     0.200
     0.271     0.088     0.200
     0.273     0.158     0.200
     0.542     0.056     0.200
     0.592    -0.069     0.200
     0.703     0.624     0.200
     0.903    -0.431     0.200
     0.539     0.227     0.200
     0.544     0.492     0.200
     0.604     0.168     0.200
     0.680     0.187     0.200
     0.275     0.393     0.200
     0.276     0.398     0.200
     0.564    -0.022     0.200
     0.578    -0.104     0.200
     0.705     0.153     0.200
     0.890    -0.557     0.200
     0.279     0.228     0.200
     0.281     0.175     0.200
     0.562    -0.114     0.200
     0.576     0.007     0.200
     0.700     0.293     0.200
     0.888    -0.092     0.200
     0.281    -0.479     0.200
     0.281    -0.030     0.200
     0.572     0.128     0.200
     0.571     0.168     0.200
     0.703     0.391     0.200
     0.883    -0.388     0.200
     0.277     0.135     0.200
     0.279     0.152     0.200
     0.556    -0.059     0.200
     0.580    -0.159     0.200
     0.700     0.199     0.200
     0.268     0.045     0.200
     0.270     0.071     0.200
     0.894     0.167     0.200
     0.289     0.517     0.200
     0.289     0.177     0.200
     0.291     0.522     0.200
     0.291     0.383     0.200
     0.576    -0.101     0.200
     0.289     0.516     0.200
     0.289     0.177     0.200
     0.290     0.513     0.200
     0.562     0.151     0.200
     0.576    -0.077     0.200
     0.874     0.021     0.200
     0.281     0.410     0.200
     0.281     0.220     0.200
     0.283     0.407     0.200
     0.557     0.111     0.200
     0.577     0.070     0.200
     0.888    -0.180     0.200
     0.437     0.406     0.200
     0.534     0.199     0.200
     0.733    -0.031     0.200
     0.733    -0.211     0.200
     0.833    -0.401     0.200
     0.901     0.404     0.200
     0.901     0.298     0.200
     0.892    -0.489     0.200
     0.892    -0.099     0.200
     0.894    -0.113     0.200
     0.938     0.040     0.200
     0.260     0.843     0.200
     0.262     0.752     0.200
     0.596     0.268     0.200
     0.549    -0.305     0.200
     0.908    -0.066     0.200
     0.205    -0.457     0.200
     0.205     0.133     0.200
     0.207     0.121     0.200
     0.956    -0.445     0.200
     0.241    -0.178     0.200
     0.241     0.251     0.200
     0.243     0.258     0.200
     0.539    -0.089     0.200
     0.616    -0.080     0.200
     0.928    -0.144     0.200
     0.231    -0.010     0.200
     0.231     0.369     0.200
     0.233     0.328     0.200
     0.233     0.008     0.200
     0.535    -0.115     0.200
     0.626    -0.127     0.200
     0.938    -0.258     0.200
     0.282     0.637     0.200
     0.282     0.254     0.200
     0.566     0.108     0.200
     0.571     0.219     0.200
     0.883     0.067     0.200
     0.339     0.181     0.200
     0.498    -0.054     0.200
     0.591    -0.126     0.200
     0.751    -0.029     0.200
     0.865    -0.293     0.200
     0.846    -0.228     0.200
     0.865    -0.124     0.200
     0.884     0.625     0.200
     0.901    -0.066     0.200
     0.893    -0.131     0.200
     0.882     0.013     0.200
     0.882    -0.186     0.200
     0.883     0.020     0.200
     0.942     1.057     0.200
     0.403    -0.244     0.200
     0.479    -0.205     0.200
     0.480    -0.193     0.200
     0.910     0.276     0.200
     0.367     0.349     0.200
     0.618     0.249     0.200
     0.618     0.467     0.200
     0.620     0.397     0.200
     0.645    -0.284     0.200
     0.688    -0.051     0.200
     0.767    -0.595     0.200
     0.963    -0.239     0.200
     0.346     0.463     0.200
     0.578     0.001     0.200
     0.688    -0.265     0.200
     0.747     0.314     0.200
     0.748     0.314     0.200
     0.748     0.073     0.200
     0.772     0.128     0.200
     0.889     0.010     0.200
     0.889    -0.199     0.200
     0.899    -0.056     0.200
     0.983    -0.453     0.200
     0.499     0.513     0.200
     0.545     0.510     0.200
     0.546    -0.494     0.200
     0.559     0.210     0.200
     0.882    -0.492     0.200
     0.836    -0.406     0.200
     0.904     1.136     0.200
     0.348     0.547     0.200
     0.580     0.189     0.200
     0.690     0.015     0.200
     0.746     0.321     0.200
     0.746     0.126     0.200
     0.747    -0.100     0.200
     0.747     0.321     0.200
     0.891    -0.129     0.200
     0.891     0.019     0.200
     0.898     0.659     0.200
     0.945     1.489     0.200
     0.976     0.002     0.200
     0.985    -0.198     0.200
     0.403     0.358     0.200
     0.444     0.368     0.200
     0.444     0.227     0.200
     0.446    -0.062     0.200
     0.446     0.204     0.200
     0.707     0.033     0.200
     0.795     0.100     0.200
     0.845    -0.188     0.200
     0.448     0.295     0.200
     0.450    -0.111     0.200
     0.450     0.268     0.200
     0.699     0.449     0.200
     0.837     0.037     0.200
     0.132     0.488     0.200
     0.399     0.147     0.200
     0.525    -0.129     0.200
     0.785    -0.421     0.200
     0.785    -0.551     0.200
     0.787    -0.387     0.200
     0.856    -0.237     0.200
     0.856    -0.357     0.200
     0.935     0.168     0.200
     0.965    -0.462     0.200
     0.431     0.147     0.200
     0.433     0.137     0.200
     0.662    -0.595     0.200
     0.764    -1.221     0.200
     0.895    -0.487     0.200
     0.509     0.390     0.200
     0.509     0.132     0.200
     0.510     0.412     0.200
     0.585    -0.743     0.200
     0.877     0.144     0.200
     0.079     0.444     0.200
     0.079     0.095     0.200
     0.078    -0.547     0.200
     0.426     0.409     0.200
     0.665    -0.623     0.200
     0.489     0.582     0.200
     0.489     0.363     0.200
     0.490    -0.404     0.200
     0.599    -0.856     0.200
     0.514     0.359     0.200
     0.515     0.364     0.200
     0.515     0.094     0.200
     0.595    -0.645     0.200
     0.699    -0.094     0.200
     0.877     1.519     0.200
     0.380     0.340     0.200
     0.504     0.007     0.200
     0.505     0.031     0.200
     0.599    -1.179     0.200
     0.690    -0.410     0.200
     0.878    -0.049     0.200
     0.878    -0.339     0.200
     0.888     1.172     0.200
     0.386     0.406     0.200
     0.499     0.280     0.200
     0.499     0.284     0.200
     0.599    -0.895     0.200
     0.682    -0.080     0.200
     0.885    -0.316     0.200
     0.896     1.245     0.200
     0.288     0.737     0.200
     0.443     0.041     0.200
     0.443     0.201     0.200
     0.445     0.181     0.200
     0.445    -0.088     0.200
     0.661    -0.279     0.200
     0.765    -1.302     0.200
     0.788     0.168     0.200
     0.886     0.161     0.200
     0.274    -0.259     0.200
     0.395     0.637     0.200
     0.508     0.137     0.200
     0.618    -0.183     0.200
     0.720    -0.243     0.200
     0.720    -0.623     0.200
     0.732     0.041     0.200
     0.809    -0.431     0.200
     0.817     0.131     0.200
     0.933    -0.546     0.200
     0.958     0.623     0.200
     0.988    -0.271     0.200
     0.358     0.043     0.200
     0.452    -0.118     0.200
     0.452     0.085     0.200
     0.649    -0.477     0.200
     0.928    -0.237     0.200
     0.935     0.842     0.200
     0.935     1.404     0.200
     0.366     0.094     0.200
     0.356    -1.222     0.200
     0.652    -0.426     0.200
     0.895     0.047     0.200
     0.895    -0.144     0.200
     0.982    -0.698     0.200
     0.984    -0.666     0.200
     0.284     0.754     0.200
     0.447    -0.340     0.200
     0.449    -0.760     0.200
     0.761    -1.104     0.200
     0.665    -0.258     0.200
     0.790     0.243     0.200
     0.882    -0.926     0.200
     0.266    -0.724     0.200
     0.377     0.064     0.200
     0.438     0.224     0.200
     0.438     0.267     0.200
     0.668    -0.093     0.200
     0.890     1.069     0.200
     0.963    -0.957     0.200
     0.944     0.150     0.200
     0.953    -0.062     0.200
     0.238    -0.344     0.200
     0.530    -0.293     0.200
     0.531     0.450     0.200
     0.532    -0.561     0.200
     0.610    -0.029     0.200
     0.856     0.600     0.200
     0.884     0.467     0.200
     0.903     1.270     0.200
     0.959    -0.029     0.200
     0.959     0.091     0.200
     0.981     0.339     0.200
     0.402     0.395     0.200
     0.408     0.525     0.200
     0.408     0.236     0.200
     0.408    -0.427     0.200
     0.783    -1.285     0.200
     0.806    -0.451     0.200
     0.890     1.082     0.200
     0.981    -0.468     0.200
     0.975     1.108     0.200
     0.980    -0.127     0.200
     0.309    -1.449     0.200
     0.416    -0.134     0.200
     0.625     0.062     0.200
     0.693    -0.022     0.200
     0.716     1.436     0.200
     0.772     0.055     0.200
     0.772    -0.242     0.200
     0.773     0.039     0.200
     0.843     0.133     0.200
     0.849    -0.094     0.200
     0.853     0.158     0.200
     0.872    -0.429     0.200
     0.925    -0.249     0.200
     0.959    -0.347     0.200
     0.983     0.041     0.200
     0.195     0.409     0.200
     0.495    -0.121     0.200
     0.505     0.362     0.200
     0.507     0.347     0.200
     0.544     0.182     0.200
     0.572    -0.310     0.200
     0.899     0.586     0.200
     0.899     0.967     0.200
     0.923     0.634     0.200
     0.944    -0.293     0.200
     0.944     1.302     0.200
     0.944     0.922     0.200
     0.978    -0.490     0.200
     0.180     0.228     0.200
     0.496     0.208     0.200
     0.496     0.069     0.200
     0.502    -0.392     0.200
     0.497     0.193     0.200
     0.550    -0.107     0.200
     0.560    -0.446     0.200
     0.914     0.467     0.200
     0.941    -0.427     0.200
     0.941    -0.558     0.200
     0.938     1.306     0.200
     0.959     1.878     0.200
     0.964    -0.401     0.200
     0.177    -0.147     0.200
     0.494    -0.066     0.200
     0.494    -0.197     0.200
     0.496    -0.082     0.200
     0.556    -0.539     0.200
     0.551    -0.375     0.200
     0.961    -0.264     0.200
     0.940    -0.290     0.200
     0.917     0.826     0.200
     0.962     1.620     0.200
     0.180    -0.035     0.200
     0.494     0.054     0.200
     0.496     0.028     0.200
     0.552    -0.444     0.200
     0.559    -0.486     0.200
     0.942    -0.250     0.200
     0.939     0.381     0.200
     0.963    -0.194     0.200
     0.960     1.284     0.200
     0.274    -0.348     0.200
     0.365    -0.703     0.200
     0.420    -0.093     0.200
     0.672     0.068     0.200
     0.709    -0.054     0.200
     0.709    -0.386     0.200
     0.710     0.031     0.200
     0.710    -0.137     0.200
     0.921    -0.201     0.200
     0.982     0.894     0.200
     0.326    -0.018     0.200
     0.188    -0.050     0.200
     0.405     0.122     0.200
     0.405    -0.147     0.200
     0.407     0.085     0.200
     0.758    -0.059     0.200
     0.778     0.350     0.200
     0.920     0.526     0.200
     0.503    -0.002     0.200
     0.525     0.401     0.200
     0.525     0.276     0.200
     0.526     0.393     0.200
     0.575    -0.091     0.200
     0.885     1.789     0.200
     0.933    -0.245     0.200
     0.263     0.228     0.200
     0.264     0.204     0.200
     0.351     0.104     0.200
     0.717    -0.411     0.200
     0.687    -0.411     0.200
     0.376     0.364     0.200
     0.624     0.175     0.200
     0.624     0.023     0.200
     0.814     0.107     0.200
     0.892    -0.499     0.200
     0.992    -0.444     0.200
     0.977     0.599     0.200
     0.977     0.341     0.200
     0.481     0.452     0.200
     0.680    -0.093     0.200
     0.850     1.442     0.200
     0.902     1.376     0.200
     0.912     1.187     0.200
     0.405     0.287     0.200
     0.539    -0.629     0.200
     0.602    -0.110     0.200
     0.701    -0.259     0.200
     0.786     0.055     0.200
     0.787    -0.245     0.200
     0.787    -0.475     0.200
     0.812    -0.099     0.200
     0.812     0.022     0.200
     0.910    -0.623     0.200
     0.931     1.210     0.200
     0.931    -0.660     0.200
     0.972    -0.185     0.200
     0.972    -0.543     0.200
     0.976     0.437     0.200
     0.999     1.582     0.200
     0.999     0.593     0.200
     0.851     0.174     0.200
     0.710    -0.447     0.200
     0.432     0.133     0.200
     0.472     0.402     0.200
     0.549     0.257     0.200
     0.836     0.616     0.200
     0.863     0.073     0.200
     0.883     1.102     0.200
     0.959    -0.337     0.200
     0.172     0.054     0.200
     0.562    -0.206     0.200
     0.806     0.430     0.200
     0.806     0.028     0.200
     0.919     0.259     0.200
     0.251    -0.877     0.200
     0.441    -0.349     0.200
     0.472    -0.237     0.200
     0.529     0.087     0.200
     0.529     0.205     0.200
     0.750    -0.114     0.200
     0.748    -0.175     0.200
     0.847    -0.414     0.200
     0.879    -0.012     0.200
     0.880    -0.081     0.200
     0.883    -0.269     0.200
     0.883    -0.219     0.200
     0.904    -0.189     0.200
     0.907     0.557     0.200
     0.907    -0.123     0.200
     0.920     0.091     0.200
     0.926    -0.308     0.200
     0.965     0.913     0.200
     0.985    -0.985     0.200
     0.248     0.448     0.200
     0.409     0.359     0.200
     0.832    -0.784     0.200
     0.868    -0.087     0.200
     0.907    -0.199     0.200
     0.243    -0.516     0.200
     0.480     0.042     0.200
     0.488    -0.297     0.200
     0.491    -0.291     0.200
     0.697    -0.318     0.200
     0.795    -0.433     0.200
     0.773     0.080     0.200
     0.847    -0.056     0.200
     0.858    -0.246     0.200
     0.876    -0.418     0.200
     0.905     0.032     0.200
     0.930    -0.253     0.200
     0.917     0.379     0.200
     0.957     0.061     0.200
     0.984    -0.506     0.200
     1.000    -0.574     0.200
     0.979    -0.614     0.200
     0.979     0.506     0.200
     1.000     1.093     0.200
     0.243    -0.592     0.200
     0.481     0.080     0.200
     0.489    -0.185     0.200
     0.491    -0.287     0.200
     0.697    -0.377     0.200
     0.697    -0.018     0.200
     0.773     0.128     0.200
     0.795    -0.401     0.200
     0.847    -0.000     0.200
     0.858    -0.166     0.200
     0.858    -0.486     0.200
     0.858    -0.156     0.200
     0.876    -0.326     0.200
     0.876    -0.447     0.200
     0.905     0.091     0.200
     0.916     0.703     0.200
     0.916    -0.398     0.200
     0.930    -0.212     0.200
     0.956     0.133     0.200
     0.984    -0.594     0.200
     0.978    -0.468     0.200
     0.296    -0.486     0.200
     0.352     0.108     0.200
     0.393    -0.757     0.200
     0.609     0.024     0.200
     0.735    -0.310     0.200
     0.808    -0.280     0.200
     0.833     0.156     0.200
     0.889    -0.420     0.200
     0.889    -0.611     0.200
     0.991    -0.494     0.200
     0.162    -0.251     0.200
     0.278    -0.382     0.200
     0.504    -0.403     0.200
     0.565     0.080     0.200
     0.709    -0.344     0.200
     0.776    -0.008     0.200
     0.927    -0.095     0.200
     0.307    -0.445     0.200
     0.355    -0.279     0.200
     0.721    -0.272     0.200
     0.740    -0.024     0.200
     0.821    -0.574     0.200
     0.989     0.421     0.200
     0.284    -0.470     0.200
     0.347    -0.046     0.200
     0.390    -0.669     0.200
     0.459    -0.425     0.200
     0.627    -0.183     0.200
     0.627    -0.082     0.200
     0.640    -0.011     0.200
     0.723    -0.276     0.200
     0.794    -0.034     0.200
     0.814     0.294     0.200
     0.901    -0.585     0.200
     0.901    -0.471     0.200
     0.990     0.657     0.200
     0.990     1.106     0.200
     0.207    -0.507     0.200
     0.376    -0.281     0.200
     0.472    -0.084     0.200
     0.535     0.102     0.200
     0.519    -0.390     0.200
     0.534    -0.466     0.200
     0.534    -0.256     0.200
     0.660    -0.753     0.200
     0.660    -0.353     0.200
     0.755    -0.419     0.200
     0.757    -0.070     0.200
     0.799    -0.085     0.200
     0.833    -0.545     0.200
     0.812    -0.232     0.200
     0.812    -0.392     0.200
     0.812    -0.170     0.200
     0.819    -0.413     0.200
     0.862     0.043     0.200
     0.888    -0.017     0.200
     0.943    -0.715     0.200
     0.956    -0.477     0.200
     0.956    -0.617     0.200
     0.962    -0.050     0.200
     0.971    -0.139     0.200
     0.962     0.783     0.200
     0.971     1.222     0.200
     0.977     0.142     0.200
     0.228    -0.073     0.200
     0.402    -0.416     0.200
     0.459    -0.355     0.200
     0.643     0.004     0.200
     0.665     0.437     0.200
     0.683     0.017     0.200
     0.768    -0.064     0.200
     0.789    -0.158     0.200
     0.850     0.218     0.200
     0.906     0.261     0.200
     0.936     0.160     0.200
     0.943    -0.385     0.200
     0.943     0.709     0.200
     0.200     0.161     0.200
     0.534     0.483     0.200
     0.662    -0.382     0.200
     0.623     0.215     0.200
     0.238    -0.077     0.200
     0.391    -0.097     0.200
     0.478    -0.317     0.200
     0.483     0.015     0.200
     0.493    -0.250     0.200
     0.535     0.022     0.200
     0.696    -0.392     0.200
     0.769     0.112     0.200
     0.794    -0.448     0.200
     0.843    -0.045     0.200
     0.854    -0.125     0.200
     0.854    -0.155     0.200
     0.853     0.193     0.200
     0.874    -0.471     0.200
     0.900     0.030     0.200
     0.912     0.806     0.200
     0.931    -0.354     0.200
     0.955     0.050     0.200
     0.982    -0.587     0.200
     0.974    -0.278     0.200
     0.974     0.453     0.200
     0.998    -0.587     0.200
     0.995     0.644     0.200
     0.210     0.187     0.200
     0.464     0.183     0.200
     0.494    -0.260     0.200
     0.486     0.080     0.200
     0.570    -0.386     0.200
     0.582    -0.371     0.200
     0.665    -0.511     0.200
     0.827     0.208     0.200
     0.894     0.620     0.200
     0.926     0.834     0.200
     0.977    -0.339     0.200
     0.977    -0.468     0.200
     0.992    -0.536     0.200
     0.974    -0.385     0.200
     0.079    -0.323     0.200
     0.290    -0.212     0.200
     0.333     0.214     0.200
     0.402    -0.078     0.200
     0.428     0.151     0.200
     0.412    -0.119     0.200
     0.492    -0.182     0.200
     0.491    -0.041     0.200
     0.602    -0.399     0.200
     0.593    -0.320     0.200
     0.683    -0.461     0.200
     0.694    -0.348     0.200
     0.694    -0.458     0.200
     0.721    -0.224     0.200
     0.766    -0.032     0.200
     0.766    -0.084     0.200
     0.783    -0.487     0.200
     0.807    -0.706     0.200
     0.839    -0.262     0.200
     0.848     0.208     0.200
     0.862    -0.321     0.200
     0.866     0.106     0.200
     0.866    -0.144     0.200
     0.868     0.025     0.200
     0.938     0.649     0.200
     0.954    -0.366     0.200
     0.955     0.627     0.200
     0.969    -0.540     0.200
     0.978     0.139     0.200
     0.986     1.294     0.200
     0.987     1.189     0.200
     0.132    -0.221     0.200
     0.154    -0.516     0.200
     0.211    -0.298     0.200
     0.252    -0.218     0.200
     0.434    -0.006     0.200
     0.514    -0.376     0.200
     0.514    -0.197     0.200
     0.658     0.319     0.200
     0.666     0.692     0.200
     0.673    -0.275     0.200
     0.719    -0.068     0.200
     0.719     1.323     0.200
     0.729    -0.119     0.200
     0.729     0.041     0.200
     0.737     1.006     0.200
     0.744     0.106     0.200
     0.746    -0.509     0.200
     0.746    -0.281     0.200
     0.765     0.926     0.200
     0.777     0.274     0.200
     0.785    -0.285     0.200
     0.786     1.134     0.200
     0.797     1.069     0.200
     0.798    -0.044     0.200
     0.807     1.150     0.200
     0.832    -0.117     0.200
     0.853     0.652     0.200
     0.888     0.532     0.200
     0.905     0.465     0.200
     0.904    -0.453     0.200
     0.906     0.165     0.200
     0.923     0.728     0.200
     0.944     0.866     0.200
     0.947     1.170     0.200
     0.946    -0.485     0.200
     0.946    -0.606     0.200
     0.987     0.289     0.200
     0.148    -0.039     0.200
     0.516    -0.138     0.200
     0.669     0.506     0.200
     0.723    -0.383     0.200
     0.723     1.105     0.200
     0.743     0.026     0.200
     0.721    -0.036     0.200
     0.743    -0.236     0.200
     0.787     0.930     0.200
     0.780    -0.303     0.200
     0.807     0.891     0.200
     0.824    -0.063     0.200
     0.824    -0.344     0.200
     0.851     0.676     0.200
     0.881     0.902     0.200
     0.897    -0.524     0.200
     0.910    -0.189     0.200
     0.943     0.610     0.200
     0.948     0.873     0.200
     0.940    -0.083     0.200
     0.984     0.262     0.200
     0.146    -0.417     0.200
     0.136    -0.353     0.200
     0.425    -0.111     0.200
     0.516    -0.375     0.200
     0.507    -0.109     0.200
     0.720    -0.106     0.200
     0.658    -0.009     0.200
     0.669     0.905     0.200
     0.790    -0.058     0.200
     0.724     1.100     0.200
     0.742    -0.370     0.200
     0.742    -0.394     0.200
     0.743    -0.030     0.200
     0.786    -0.017     0.200
     0.743     1.087     0.200
     0.779    -0.310     0.200
     0.823    -0.099     0.200
     0.787     0.792     0.200
     0.807     0.855     0.200
     0.911     0.121     0.200
     0.895    -0.490     0.200
     0.851     0.418     0.200
     0.882     0.855     0.200
     0.938    -0.732     0.200
     0.938    -0.583     0.200
     0.942     0.593     0.200
     0.948     0.888     0.200
     0.984     0.250     0.200
     0.261    -0.236     0.200
     0.401    -0.307     0.200
     0.433    -0.083     0.200
     0.424    -0.188     0.200
     0.530     0.021     0.200
     0.590     0.340     0.200
     0.672     1.066     0.200
     0.663     1.109     0.200
     0.696     0.884     0.200
     0.696     0.993     0.200
     0.736    -0.214     0.200
     0.714     1.202     0.200
     0.755     0.132     0.200
     0.855     1.221     0.200
     0.878    -0.157     0.200
     0.889     0.703     0.200
     0.945     0.067     0.200
     0.919    -0.143     0.200
     0.919    -0.118     0.200
     0.930     0.878     0.200
     0.996    -0.049     0.200
     0.986    -0.213     0.200
     0.988     0.520     0.200
     0.139    -0.071     0.200
     0.157    -0.033     0.200
     0.507    -0.012     0.200
     0.665    -0.474     0.200
     0.672     0.610     0.200
     0.726     1.142     0.200
     0.726    -0.009     0.200
     0.742     0.887     0.200
     0.751    -0.080     0.200
     0.752    -0.661     0.200
     0.775     0.019     0.200
     0.790    -0.336     0.200
     0.793    -0.193     0.200
     0.794     0.095     0.200
     0.814     0.838     0.200
     0.833    -0.632     0.200
     0.833    -0.054     0.200
     0.860     0.396     0.200
     0.887     0.848     0.200
     0.905    -0.522     0.200
     0.901     0.106     0.200
     0.951     0.651     0.200
     0.949    -0.801     0.200
     0.954     0.840     0.200
     0.993     0.217     0.200
     0.142    -0.034     0.200
     0.131     0.084     0.200
     0.523    -0.291     0.200
     0.503     0.210     0.200
     0.651    -0.056     0.200
     0.664     0.679     0.200
     0.735    -0.318     0.200
     0.735    -0.267     0.200
     0.736     0.011     0.200
     0.792    -0.060     0.200
     0.739     1.301     0.200
     0.773    -0.106     0.200
     0.781     0.836     0.200
     0.820    -0.067     0.200
     0.801     0.942     0.200
     0.844     0.438     0.200
     0.891    -0.474     0.200
     0.875     0.695     0.200
     0.918    -0.116     0.200
     0.889     0.540     0.200
     0.934    -0.345     0.200
     0.934    -0.544     0.200
     0.935     0.685     0.200
     0.941     1.054     0.200
     0.977     0.320     0.200
     0.997     0.594     0.200
     0.103     0.024     0.200
     0.337    -0.190     0.200
     0.740    -0.269     0.200
     0.700     0.407     0.200
     0.724    -0.094     0.200
     0.724     0.109     0.200
     0.955    -0.782     0.200
     0.965     0.009     0.200
     0.905     0.143     0.200
     0.983    -0.007     0.200
     0.983     0.142     0.200
     0.383    -0.003     0.200
     0.336    -0.198     0.200
     0.459     0.301     0.200
     0.487     0.347     0.200
     0.453    -0.363     0.200
     0.477    -0.073     0.200
     0.735    -0.328     0.200
     0.840    -0.490     0.200
     0.840    -0.381     0.200
     0.849     0.126     0.200
     0.892    -0.499     0.200
     0.892    -0.388     0.200
     0.932    -0.618     0.200
     0.931     0.091     0.200
     0.948    -0.066     0.200
     0.948     0.006     0.200
     0.951     0.509     0.200
     0.972    -0.009     0.200
     0.998     0.182     0.200
     0.283     0.637     0.200
     0.391     0.486     0.200
     0.450     0.402     0.200
     0.461     0.523     0.200
     0.486    -0.115     0.200
     0.564    -0.416     0.200
     0.564    -0.298     0.200
     0.622    -0.225     0.200
     0.724    -0.420     0.200
     0.815    -0.308     0.200
     0.815    -0.573     0.200
     0.826     0.174     0.200
     0.854     0.114     0.200
     0.916     0.564     0.200
     0.915    -0.525     0.200
     0.939    -0.658     0.200
     0.966     0.259     0.200
     0.990     0.254     0.200
     0.991    -0.482     0.200
     0.992    -0.527     0.200
     0.503     0.352     0.200
     0.551    -0.091     0.200
     0.491     0.567     0.200
     0.567     0.027     0.200
     0.689     0.146     0.200
     0.852     0.402     0.200
     0.865     0.413     0.200
     0.865     0.784     0.200
     0.874     0.368     0.200
     0.956    -0.292     0.200
     0.968    -0.529     0.200
     0.919     0.251     0.200
     0.954    -0.526     0.200
     0.947     0.210     0.200
     0.967     0.002     0.200
     0.495     0.407     0.200
     0.493     0.394     0.200
     0.559     0.160     0.200
     0.552    -0.124     0.200
     0.682     0.292     0.200
     0.846     0.419     0.200
     0.860     0.580     0.200
     0.860     0.760     0.200
     0.871     0.412     0.200
     0.871     1.021     0.200
     0.914     0.393     0.200
     0.951    -0.451     0.200
     0.964    -0.633     0.200
     0.961    -0.813     0.200
     0.542    -0.119     0.200
     0.504     0.152     0.200
     0.499     0.239     0.200
     0.564    -0.019     0.200
     0.694    -0.149     0.200
     0.872     1.024     0.200
     0.882     1.144     0.200
     0.948    -0.407     0.200
     0.950    -0.549     0.200
     0.960    -0.449     0.200
     0.925     1.169     0.200
     0.174     0.473     0.200
     0.501     0.175     0.200
     0.499     0.114     0.200
     0.544    -0.095     0.200
     0.562     0.066     0.200
     0.691    -0.237     0.200
     0.922     0.403     0.200
     0.953    -0.932     0.200
     0.960    -0.786     0.200
     0.969     0.461     0.200
     0.164    -0.198     0.200
     0.496     0.014     0.200
     0.519    -0.315     0.200
     0.540    -0.309     0.200
     0.579    -0.447     0.200
     0.707    -0.241     0.200
     0.882     1.007     0.200
     0.888     1.361     0.200
     0.936    -0.063     0.200
     0.937     1.742     0.200
     0.957    -0.164     0.200
     0.957    -0.344     0.200
     0.966    -0.342     0.200
     0.965     0.607     0.200
     0.985     0.867     0.200
     0.155     0.037     0.200
     0.506    -0.109     0.200
     0.530    -0.214     0.200
     0.519    -0.207     0.200
     0.575    -0.463     0.200
     0.712    -0.414     0.200
     0.933    -0.329     0.200
     0.890     1.033     0.200
     0.948    -0.247     0.200
     0.948    -0.474     0.200
     0.957    -0.366     0.200
     0.969     0.628     0.200
     0.990     0.600     0.200
     0.190     0.039     0.200
     0.484    -0.066     0.200
     0.497    -0.257     0.200
     0.560    -0.348     0.200
     0.565    -0.313     0.200
     0.680    -0.323     0.200
     0.842     0.316     0.200
     0.855     0.848     0.200
     0.864     1.020     0.200
     0.910     0.610     0.200
     0.938     1.110     0.200
     0.960    -0.252     0.200
     0.962    -0.292     0.200
     0.974    -0.050     0.200
     0.237     0.186     0.200
     0.391     0.038     0.200
     0.395     0.057     0.200
     0.449    -0.256     0.200
     0.689    -0.324     0.200
     0.683     0.215     0.200
     0.749    -0.321     0.200
     0.749    -0.211     0.200
     0.771    -0.369     0.200
     0.908     1.033     0.200
     0.985    -0.372     0.200
     0.985    -0.243     0.200
     0.174    -0.354     0.200
     0.174    -0.655     0.200
     0.365    -0.431     0.200
     0.478    -0.378     0.200
     0.496    -0.417     0.200
     0.533    -0.623     0.200
     0.523    -0.065     0.200
     0.683    -0.256     0.200
     0.733    -0.190     0.200
     0.848     0.543     0.200
     0.870     0.772     0.200
     0.919    -0.229     0.200
     0.919    -0.049     0.200
     0.890     0.561     0.200
     0.890     1.112     0.200
     0.933    -0.402     0.200
     0.917     1.221     0.200
     0.917     0.662     0.200
     0.968    -0.171     0.200
     0.936     0.671     0.200
     0.936     0.999     0.200
     0.959     0.206     0.200
     0.176     0.266     0.200
     0.495     0.111     0.200
     0.503     0.157     0.200
     0.547    -0.219     0.200
     0.565     0.034     0.200
     0.691    -0.178     0.200
     0.868     0.752     0.200
     0.953    -0.776     0.200
     0.922     0.255     0.200
     0.952    -0.774     0.200
     0.948     1.338     0.200
     0.969    -0.786     0.200
     0.247     0.249     0.200
     0.293     0.071     0.200
     0.282     0.234     0.200
     0.446     0.129     0.200
     0.473     0.205     0.200
     0.502     0.063     0.200
     0.624    -0.022     0.200
     0.640     0.058     0.200
     0.782    -0.105     0.200
     0.813     0.076     0.200
     0.893    -0.549     0.200
     0.893    -0.330     0.200
     0.993    -0.474     0.200
     0.993    -0.295     0.200
     0.978     0.647     0.200
     0.172     0.047     0.200
     0.404    -1.559     0.200
     0.492     0.214     0.200
     0.546    -0.295     0.200
     0.512    -0.152     0.200
     0.538    -0.180     0.200
     0.642    -0.248     0.200
     0.698    -0.343     0.200
     0.774     0.016     0.200
     0.861     0.596     0.200
     0.874     1.001     0.200
     0.880     0.548     0.200
     0.880     0.659     0.200
     0.944    -0.126     0.200
     0.957    -0.193     0.200
     0.968    -0.336     0.200
     0.928     1.467     0.200
     0.958     0.404     0.200
     0.976     0.323     0.200
     0.148    -0.539     0.200
     0.634    -0.269     0.200
     0.806    -0.402     0.200
     0.829    -0.267     0.200
     0.164     0.131     0.200
     0.398    -1.461     0.200
     0.504     0.024     0.200
     0.509     0.034     0.200
     0.536    -0.165     0.200
     0.637    -0.128     0.200
     0.701    -0.072     0.200
     0.765     0.170     0.200
     0.880     1.262     0.200
     0.889     1.313     0.200
     0.943    -0.240     0.200
     0.946    -0.050     0.200
     0.957    -0.178     0.200
     0.959     0.480     0.200
     0.979     0.264     0.200
     0.286     0.398     0.200
     0.384     0.705     0.200
     0.520    -0.367     0.200
     0.507     0.097     0.200
     0.526     0.044     0.200
     0.678    -0.233     0.200
     0.786    -0.402     0.200
     0.885    -0.243     0.200
     0.917    -0.249     0.200
     0.916     0.152     0.200
     0.926    -0.549     0.200
     0.946     0.102     0.200
     0.978    -0.417     0.200
     0.198     0.228     0.200
     0.198     0.109     0.200
     0.503     0.126     0.200
     0.490     0.260     0.200
     0.521     0.005     0.200
     0.561    -0.155     0.200
     0.666    -0.009     0.200
     0.950    -0.440     0.200
     0.950    -0.850     0.200
     0.943     0.204     0.200
     0.965    -0.643     0.200
     0.371    -0.361     0.200
     0.396    -0.188     0.200
     0.416     0.482     0.200
     0.563     0.299     0.200
     0.592     0.272     0.200
     0.816    -0.239     0.200
     0.816    -0.130     0.200
     0.915    -0.429     0.200
     0.950     0.785     0.200
     0.953     0.040     0.200
     0.986     0.115     0.200
     0.997    -0.634     0.200
     0.997    -0.466     0.200
     0.172     0.001     0.200
     0.451    -0.229     0.200
     0.479    -0.030     0.200
     0.531    -0.225     0.200
     0.560    -0.327     0.200
     0.554    -0.258     0.200
     0.709    -0.130     0.200
     0.976    -0.420     0.200
     0.976    -0.193     0.200
     0.985    -0.298     0.200
     0.249     0.299     0.200
     0.383     0.438     0.200
     0.421     0.244     0.200
     0.715     0.941     0.200
     0.716     0.909     0.200
     0.760    -0.199     0.200
     0.780     0.893     0.200
     0.823     0.428     0.200
     0.875     0.730     0.200
     0.875     0.839     0.200
     0.989    -0.793     0.200
     0.957     0.406     0.200
     0.962     0.095     0.200
     0.165     0.025     0.200
     0.469     0.066     0.200
     0.497    -0.025     0.200
     0.516    -0.153     0.200
     0.538    -0.284     0.200
     0.705    -0.218     0.200
     0.939    -0.200     0.200
     0.955    -0.347     0.200
     0.955    -0.097     0.200
     0.964    -0.185     0.200
     0.935     1.347     0.200
     0.964     0.994     0.200
     0.982     0.940     0.200
     0.273     0.216     0.200
     0.272     0.477     0.200
     0.471     0.085     0.200
     0.634     0.163     0.200
     0.634    -0.138     0.200
     0.644     0.233     0.200
     0.711    -0.262     0.200
     0.802    -0.122     0.200
     0.810     0.219     0.200
     0.914    -0.459     0.200
     0.914    -0.289     0.200
     0.967     0.004     0.200
     0.418     0.724     0.200
     0.422     0.198     0.200
     0.572    -0.127     0.200
     0.616    -0.110     0.200
     0.714    -0.229     0.200
     0.791     0.186     0.200
     0.798    -0.501     0.200
     0.798    -0.360     0.200
     0.803     0.333     0.200
     0.807    -0.044     0.200
     0.814     0.023     0.200
     0.825    -0.316     0.200
     0.875     0.320     0.200
     0.896     0.641     0.200
     0.904    -0.373     0.200
     0.922    -0.429     0.200
     0.924     1.178     0.200
     0.933     0.408     0.200
     0.976    -0.480     0.200
     0.985    -0.115     0.200
     0.990    -0.091     0.200
     0.991    -0.270     0.200
     0.250     0.459     0.200
     0.420     0.367     0.200
     0.382     0.567     0.200
     0.634     0.052     0.200
     0.681     0.002     0.200
     0.774    -0.284     0.200
     0.717     1.187     0.200
     0.760    -0.070     0.200
     0.781     1.092     0.200
     0.824     0.274     0.200
     0.963     0.431     0.200
     0.183    -0.137     0.200
     0.466    -0.496     0.200
     0.453    -0.502     0.200
     0.519    -0.309     0.200
     0.539    -0.107     0.200
     0.547    -0.186     0.200
     0.838     0.272     0.200
     0.891     0.192     0.200
     0.946     0.210     0.200
     0.988    -0.059     0.200
     0.985     0.135     0.200
     0.237    -0.361     0.200
     0.301    -0.406     0.200
     0.411    -0.054     0.200
     0.396    -0.185     0.200
     0.650     0.061     0.200
     0.675     0.030     0.200
     0.736    -0.219     0.200
     0.729     0.158     0.200
     0.781     0.451     0.200
     0.895    -0.276     0.200
     0.895     0.064     0.200
     0.927     0.240     0.200
     0.991    -0.357     0.200
     0.982    -0.060     0.200
     0.995     0.059     0.200
     0.973     1.450     0.200
     0.973    -0.650     0.200
     0.971     0.071     0.200
     0.972     0.134     0.200
     0.279    -0.033     0.200
     0.544    -0.015     0.200
     0.569     0.150     0.200
     0.195     0.108     0.200
     0.195     0.248     0.200
     0.443     0.100     0.200
     0.464    -0.046     0.200
     0.529    -0.082     0.200
     0.547     0.170     0.200
     0.542     0.159     0.200
     0.661    -0.333     0.200
     0.826     0.384     0.200
     0.855     1.056     0.200
     0.894    -0.315     0.200
     0.894    -0.206     0.200
     0.912    -0.271     0.200
     0.886     1.051     0.200
     0.886     0.197     0.200
     0.897     0.838     0.200
     0.897    -0.051     0.200
     0.909    -0.137     0.200
     0.910     0.871     0.200
     0.934     0.391     0.200
     0.974    -0.138     0.200
     0.999    -0.301     0.200
     0.193    -0.441     0.200
     0.193    -0.021     0.200
     0.447    -0.092     0.200
     0.469    -0.207     0.200
     0.531    -0.243     0.200
     0.542     0.169     0.200
     0.537     0.171     0.200
     0.662    -0.335     0.200
     0.827     0.531     0.200
     0.855     0.673     0.200
     0.899    -0.337     0.200
     0.899    -0.007     0.200
     0.884     0.554     0.200
     0.884    -0.058     0.200
     0.897     0.710     0.200
     0.897     0.109     0.200
     0.916    -0.246     0.200
     0.911     0.132     0.200
     0.912     0.720     0.200
     0.936     0.578     0.200
     0.977     0.391     0.200
     0.996    -0.125     0.200
     0.209     0.366     0.200
     0.432     0.584     0.200
     0.535     0.330     0.200
     0.555     0.246     0.200
     0.542    -0.038     0.200
     0.646     0.244     0.200
     0.812     0.274     0.200
     0.841     1.355     0.200
     0.873    -0.277     0.200
     0.882    -0.107     0.200
     0.895    -0.118     0.200
     0.896     0.726     0.200
     0.920     0.138     0.200
     0.898    -0.028     0.200
     0.898    -0.516     0.200
     0.918    -0.552     0.200
     0.962    -0.329     0.200
     0.201     0.231     0.200
     0.431     0.337     0.200
     0.449     0.010     0.200
     0.525    -0.149     0.200
     0.554     0.214     0.200
     0.562     0.176     0.200
     0.655    -0.060     0.200
     0.880    -0.280     0.200
     0.880    -0.631     0.200
     0.900    -0.746     0.200
     0.193     0.368     0.200
     0.528    -0.076     0.200
     0.463    -0.052     0.200
     0.444     0.071     0.200
     0.547     0.270     0.200
     0.543     0.249     0.200
     0.893    -0.670     0.200
     0.893    -0.359     0.200
     0.911    -0.522     0.200
     0.998    -0.494     0.200
     0.857     0.930     0.200
     0.911     0.820     0.200
     0.888     1.070     0.200
     0.935     0.637     0.200
     0.243     0.049     0.200
     0.244     0.045     0.200
     0.387     0.081     0.200
     0.407     0.196     0.200
     0.651    -0.368     0.200
     0.651    -0.149     0.200
     0.696    -0.306     0.200
     0.723     0.695     0.200
     0.779    -0.415     0.200
     0.792     1.079     0.200
     0.838     0.151     0.200
     0.890     1.163     0.200
     0.977    -0.098     0.200
     0.973     1.261     0.200
     0.979     0.559     0.200
     0.288     0.521     0.200
     0.365     0.097     0.200
     0.366     0.093     0.200
     0.533     0.082     0.200
     0.633     0.069     0.200
     0.672    -0.137     0.200
     0.644    -0.208     0.200
     0.800     0.492     0.200
     0.861     1.216     0.200
     0.918     0.564     0.200
     0.925     1.122     0.200
     0.992    -0.850     0.200
     0.182    -0.078     0.200
     0.468    -0.196     0.200
     0.490    -0.340     0.200
     0.533    -0.348     0.200
     0.520     0.140     0.200
     0.524     0.079     0.200
     0.674    -0.276     0.200
     0.862     1.084     0.200
     0.885     0.621     0.200
     0.909     1.045     0.200
     0.931    -0.384     0.200
     0.927     0.759     0.200
     0.950     1.273     0.200
     0.978    -0.226     0.200
     0.996     0.238     0.200
     0.186     0.075     0.200
     0.186    -0.027     0.200
     0.462    -0.002     0.200
     0.484    -0.302     0.200
     0.533    -0.243     0.200
     0.527     0.197     0.200
     0.528     0.172     0.200
     0.927    -0.381     0.200
     0.923     0.698     0.200
     0.945     1.287     0.200
     0.984    -0.232     0.200
     0.991     0.103     0.200
     0.286     0.223     0.200
     0.287     0.212     0.200
     0.345     0.173     0.200
     0.383    -0.021     0.200
     0.645    -0.169     0.200
     0.645    -0.270     0.200
     0.737    -0.382     0.200
     0.714    -0.057     0.200
     0.822     1.287     0.200
     0.945    -0.518     0.200
     0.915     1.164     0.200
     0.995     0.936     0.200
     0.167     0.408     0.200
     0.475     0.177     0.200
     0.498     0.184     0.200
     0.499     0.171     0.200
     0.510     0.247     0.200
     0.540    -0.115     0.200
     0.700    -0.110     0.200
     0.863    -0.085     0.200
     0.863     0.276     0.200
     0.944    -0.835     0.200
     0.962    -0.521     0.200
     0.962    -0.791     0.200
     0.978    -0.496     0.200
     0.346    -0.549     0.200
     0.561    -0.305     0.200
     0.561    -0.567     0.200
     0.562    -0.500     0.200
     0.560     0.055     0.200
     0.644    -0.096     0.200
     0.728     0.114     0.200
     0.734    -0.366     0.200
     0.759    -0.030     0.200
     0.769    -0.210     0.200
     0.794    -0.133     0.200
     0.818     0.051     0.200
     0.806    -0.432     0.200
     0.822    -0.338     0.200
     0.916    -0.572     0.200
     0.920    -0.386     0.200
     0.929    -0.694     0.200
     0.979    -0.059     0.200
     0.987    -0.427     0.200
     0.320     0.218     0.200
     0.322     0.102     0.200
     0.325     0.530     0.200
     0.693    -0.041     0.200
     0.713    -0.322     0.200
     0.771    -0.133     0.200
     0.777    -0.243     0.200
     0.882    -0.865     0.200
     0.321     0.030     0.200
     0.315     0.065     0.200
     0.316     0.043     0.200
     0.332     0.300     0.200
     0.719    -0.411     0.200
     0.696    -0.228     0.200
     0.885    -0.504     0.200
     0.815     0.853     0.200
     0.777    -0.256     0.200
     0.776    -0.202     0.200
     0.883     1.460     0.200
     0.923     0.235     0.200
     0.977     1.464     0.200
     0.293     0.152     0.200
     0.293     0.140     0.200
     0.339     0.469     0.200
     0.381     0.083     0.200
     0.644    -0.030     0.200
     0.716    -0.147     0.200
     0.730    -0.343     0.200
     0.745    -0.084     0.200
     0.767     0.712     0.200
     0.863     0.054     0.200
     0.918     0.527     0.200
     0.941    -0.627     0.200
     0.995     1.349     0.200
     0.995     0.869     0.200
     0.997    -0.152     0.200
     0.178     0.093     0.200
     0.442     0.165     0.200
     0.468     0.012     0.200
     0.469    -0.052     0.200
     0.540    -0.319     0.200
     0.572    -0.454     0.200
     0.562    -0.277     0.200
     0.562    -0.496     0.200
     0.712    -0.568     0.200
     0.873     0.215     0.200
     0.875     0.316     0.200
     0.879     0.830     0.200
     0.939     0.606     0.200
     0.926    -0.154     0.200
     0.926    -0.264     0.200
     0.997    -0.310     0.200
     0.997    -0.450     0.200
     0.184     0.097     0.200
     0.469     0.066     0.200
     0.470     0.045     0.200
     0.456    -0.080     0.200
     0.456     0.080     0.200
     0.526     0.021     0.200
     0.562    -0.182     0.200
     0.565    -0.222     0.200
     0.699    -0.246     0.200
     0.861     0.306     0.200
     0.868     0.445     0.200
     0.868     0.687     0.200
     0.927     0.641     0.200
     0.978     0.204     0.200
     0.978     0.446     0.200
     0.939    -0.548     0.200
     0.993    -0.560     0.200
     0.181     0.360     0.200
     0.452     0.179     0.200
     0.471     0.084     0.200
     0.530    -0.097     0.200
     0.563    -0.147     0.200
     0.564    -0.265     0.200
     0.935    -0.887     0.200
     0.935    -0.664     0.200
     0.993    -0.506     0.200
     0.183     0.031     0.200
     0.450     0.142     0.200
     0.467    -0.108     0.200
     0.468    -0.168     0.200
     0.532    -0.158     0.200
     0.565    -0.244     0.200
     0.565    -0.385     0.200
     0.567    -0.336     0.200
     0.703    -0.432     0.200
     0.865     0.248     0.200
     0.871     0.889     0.200
     0.934    -0.373     0.200
     0.934    -0.670     0.200
     0.996    -0.513     0.200
     0.173     0.327     0.200
     0.447     0.042     0.200
     0.447     0.332     0.200
     0.476    -0.148     0.200
     0.476     0.012     0.200
     0.535    -0.212     0.200
     0.555    -0.172     0.200
     0.564    -0.334     0.200
     0.927    -0.931     0.200
     0.927    -0.482     0.200
     0.991     0.070     0.200
     0.989    -0.601     0.200
     0.183     0.156     0.200
     0.453     0.095     0.200
     0.469    -0.022     0.200
     0.565    -0.255     0.200
     0.528    -0.193     0.200
     0.564    -0.318     0.200
     0.937    -0.466     0.200
     0.980     0.596     0.200
     0.994    -0.532     0.200
     0.191     0.476     0.200
     0.471     0.148     0.200
     0.473     0.125     0.200
     0.510     0.372     0.200
     0.567    -0.067     0.200
     0.686     0.036     0.200
     0.954    -0.928     0.200
     0.964     0.086     0.200
     0.986    -0.389     0.200
     0.183     0.503     0.200
     0.458     0.379     0.200
     0.471     0.180     0.200
     0.940    -1.093     0.200
     0.991    -0.488     0.200
     0.183     0.016     0.200
     0.456     0.053     0.200
     0.471     0.021     0.200
     0.471     0.016     0.200
     0.525    -0.128     0.200
     0.561    -0.312     0.200
     0.563    -0.304     0.200
     0.700    -0.382     0.200
     0.861     0.175     0.200
     0.869     1.000     0.200
     0.928     0.836     0.200
     0.939    -0.423     0.200
     0.991    -0.409     0.200
     0.979     1.017     0.200
     0.979     0.786     0.200
     0.183     0.068     0.200
     0.450     0.178     0.200
     0.466    -0.078     0.200
     0.467    -0.059     0.200
     0.532    -0.312     0.200
     0.566    -0.337     0.200
     0.568    -0.341     0.200
     0.703    -0.585     0.200
     0.865     0.427     0.200
     0.868     0.047     0.200
     0.934    -0.300     0.200
     0.931     1.207     0.200
     0.965     0.608     0.200
     0.996    -0.389     0.200
     0.983     1.981     0.200
     0.181     0.008     0.200
     0.445     0.049     0.200
     0.445     0.180     0.200
     0.467     0.096     0.200
     0.571    -0.480     0.200
     0.565    -0.371     0.200
     0.708    -0.498     0.200
     0.929    -0.484     0.200
     0.929    -0.253     0.200
     0.987     1.026     0.200
     0.987     0.165     0.200
     0.998    -0.529     0.200
     0.184     0.241     0.200
     0.447     0.181     0.200
     0.465     0.064     0.200
     0.567    -0.241     0.200
     0.534    -0.212     0.200
     0.571    -0.309     0.200
     0.933    -0.521     0.200
     0.999    -0.523     0.200
     0.195    -0.056     0.200
     0.467     0.122     0.200
     0.465     0.052     0.200
     0.514    -0.576     0.200
     0.557    -0.485     0.200
     0.685    -0.298     0.200
     0.953    -0.080     0.200
     0.947     1.595     0.200
     0.964     0.862     0.200
     0.964     1.682     0.200
     0.174     0.095     0.200
     0.452     0.119     0.200
     0.477     0.168     0.200
     0.531    -0.021     0.200
     0.556    -0.254     0.200
     0.561    -0.230     0.200
     0.931    -0.413     0.200
     0.987     0.348     0.200
     0.987     0.918     0.200
     0.987    -0.312     0.200
     0.070     0.475     0.200
     0.487     0.061     0.200
     0.504     0.148     0.200
     0.628     0.109     0.200
     0.701     0.128     0.200
     0.814    -0.410     0.200
     0.812     0.388     0.200
     0.891     0.080     0.200
     0.135     0.203     0.200
     0.437     0.042     0.200
     0.508     0.213     0.200
     0.520    -0.241     0.200
     0.552     0.063     0.200
     0.556    -0.281     0.200
     0.900    -0.537     0.200
     0.965    -0.439     0.200
     0.180     0.096     0.200
     0.458     0.067     0.200
     0.475     0.035     0.200
     0.475     0.053     0.200
     0.524    -0.169     0.200
     0.560    -0.347     0.200
     0.557    -0.336     0.200
     0.700    -0.467     0.200
     0.862     0.250     0.200
     0.939    -0.493     0.200
     0.987    -0.325     0.200
     0.979     0.306     0.200
     0.186    -0.019     0.200
     0.466     0.053     0.200
     0.473     0.146     0.200
     0.474     0.103     0.200
     0.516    -0.031     0.200
     0.563    -0.369     0.200
     0.553    -0.297     0.200
     0.692    -0.307     0.200
     0.854     0.439     0.200
     0.947    -0.438     0.200
     0.954     0.471     0.200
     0.971     0.140     0.200
     0.986    -0.312     0.200
     0.187     0.017     0.200
     0.466     0.105     0.200
     0.472     0.143     0.200
     0.473     0.120     0.200
     0.515    -0.167     0.200
     0.553    -0.359     0.200
     0.564    -0.345     0.200
     0.691    -0.392     0.200
     0.853     0.313     0.200
     0.862     1.282     0.200
     0.948    -0.404     0.200
     0.970     0.742     0.200
     0.987    -0.431     0.200
     0.987    -0.210     0.200
     0.186     0.413     0.200
     0.474     0.151     0.200
     0.478     0.281     0.200
     0.479     0.258     0.200
     0.508     0.263     0.200
     0.545     0.040     0.200
     0.561    -0.108     0.200
     0.687    -0.024     0.200
     0.850     0.395     0.200
     0.860     0.911     0.200
     0.866     0.929     0.200
     0.866     0.097     0.200
     0.916     0.087     0.200
     0.953    -0.844     0.200
     0.947     0.344     0.200
     0.980    -0.539     0.200
     0.966    -0.012     0.200
     0.966     0.777     0.200
     0.178     0.055     0.200
     0.461     0.068     0.200
     0.479     0.029     0.200
     0.479     0.032     0.200
     0.521    -0.236     0.200
     0.553    -0.353     0.200
     0.556    -0.282     0.200
     0.700    -0.422     0.200
     0.862     0.362     0.200
     0.862     0.261     0.200
     0.871     0.979     0.200
     0.874     1.122     0.200
     0.874     0.283     0.200
     0.929     0.993     0.200
     0.940    -0.276     0.200
     0.940    -0.377     0.200
     0.960     0.412     0.200
     0.983    -0.456     0.200
     0.979     1.236     0.200
     0.979    -0.240     0.200
     0.180     0.324     0.200
     0.474     0.142     0.200
     0.485     0.174     0.200
     0.486     0.161     0.200
     0.509     0.123     0.200
     0.541    -0.040     0.200
     0.554    -0.146     0.200
     0.691    -0.194     0.200
     0.691    -0.404     0.200
     0.854     0.311     0.200
     0.950    -0.652     0.200
     0.974    -0.349     0.200
     0.970    -0.525     0.200
     0.181     0.391     0.200
     0.454     0.073     0.200
     0.470     0.135     0.200
     0.471     0.012     0.200
     0.528     0.267     0.200
     0.562    -0.124     0.200
     0.563     0.059     0.200
     0.702    -0.192     0.200
     0.864     0.153     0.200
     0.870     0.885     0.200
     0.871     1.271     0.200
     0.936    -0.958     0.200
     0.930     0.327     0.200
     0.992    -0.578     0.200
     0.177     0.103     0.200
     0.177    -0.197     0.200
     0.450     0.135     0.200
     0.473     0.116     0.200
     0.474     0.113     0.200
     0.559    -0.312     0.200
     0.532    -0.058     0.200
     0.563    -0.392     0.200
     0.707    -0.455     0.200
     0.869     0.312     0.200
     0.876     0.312     0.200
     0.932    -0.328     0.200
     0.932    -0.447     0.200
     0.935     1.105     0.200
     0.990    -0.297     0.200
     0.990    -0.707     0.200
     0.986     0.634     0.200
     0.181     0.128     0.200
     0.460     0.169     0.200
     0.474     0.146     0.200
     0.475     0.133     0.200
     0.522    -0.162     0.200
     0.556    -0.323     0.200
     0.560    -0.276     0.200
     0.698    -0.385     0.200
     0.861     0.379     0.200
     0.869     0.974     0.200
     0.870     1.054     0.200
     0.927     0.325     0.200
     0.941    -0.341     0.200
     0.987    -0.543     0.200
     0.977     0.594     0.200
     0.977     1.114     0.200
     0.182     0.084     0.200
     0.465     0.098     0.200
     0.477     0.019     0.200
     0.477    -0.025     0.200
     0.517    -0.294     0.200
     0.560    -0.318     0.200
     0.552    -0.330     0.200
     0.695    -0.571     0.200
     0.869     1.010     0.200
     0.867     0.949     0.200
     0.857     0.518     0.200
     0.945    -0.383     0.200
     0.974     0.462     0.200
     0.983    -0.403     0.200
     0.182     0.115     0.200
     0.465     0.139     0.200
     0.477     0.038     0.200
     0.477     0.025     0.200
     0.517    -0.277     0.200
     0.517    -0.390     0.200
     0.551    -0.559     0.200
     0.560    -0.279     0.200
     0.695    -0.476     0.200
     0.857     0.254     0.200
     0.866     0.852     0.200
     0.869     0.905     0.200
     0.924     0.806     0.200
     0.945    -0.314     0.200
     0.945    -0.552     0.200
     0.945    -0.911     0.200
     0.983    -0.430     0.200
     0.974     0.178     0.200
     0.974     0.545     0.200
     0.422    -0.304     0.200
     0.487     0.221     0.200
     0.556    -0.049     0.200
     0.583    -0.329     0.200
     0.636    -0.308     0.200
     0.728    -0.090     0.200
     0.732    -0.293     0.200
     0.732    -0.449     0.200
     0.740    -0.268     0.200
     0.758    -0.460     0.200
     0.758    -0.180     0.200
     0.801     0.197     0.200
     0.825     0.247     0.200
     0.835     0.484     0.200
     0.840    -0.436     0.200
     0.856    -0.523     0.200
     0.869     0.240     0.200
     0.911    -0.491     0.200
     0.924    -0.254     0.200
     0.973    -0.039     0.200
     0.979     0.410     0.200
     0.192     0.386     0.200
     0.475     0.241     0.200
     0.474     0.388     0.200
     0.506     0.325     0.200
     0.547     0.051     0.200
     0.566    -0.168     0.200
     0.683     0.058     0.200
     0.957    -0.821     0.200
     0.984    -0.529     0.200
     0.175     0.180     0.200
     0.456     0.179     0.200
     0.478     0.060     0.200
     0.478     0.055     0.200
     0.526    -0.244     0.200
     0.526    -0.385     0.200
     0.555    -0.269     0.200
     0.704    -0.499     0.200
     0.935    -0.325     0.200
     0.984    -0.328     0.200
     0.984    -0.488     0.200
     0.183     0.277     0.200
     0.471     0.116     0.200
     0.480     0.116     0.200
     0.481     0.134     0.200
     0.511    -0.029     0.200
     0.546    -0.166     0.200
     0.558    -0.208     0.200
     0.691    -0.294     0.200
     0.864     0.894     0.200
     0.869     1.057     0.200
     0.921     0.942     0.200
     0.949    -0.566     0.200
     0.979    -0.586     0.200
     0.464     0.197     0.200
     0.565    -0.050     0.200
     0.471     0.049     0.200
     0.472     0.026     0.200
     0.518     0.075     0.200
     0.863     0.920     0.200
     0.865     1.056     0.200
     0.921     0.791     0.200
     0.954    -0.011     0.200
     0.972     1.056     0.200
     0.267     0.094     0.200
     0.468     0.027     0.200
     0.651     0.038     0.200
     0.707    -0.578     0.200
     0.803    -0.012     0.200
     0.804    -0.035     0.200
     0.798    -0.236     0.200
     0.918    -0.287     0.200
     0.963     0.436     0.200
     0.994     0.501     0.200
     0.202     0.112     0.200
     0.439    -0.020     0.200
     0.366     0.113     0.200
     0.665    -0.031     0.200
     0.772    -0.265     0.200
     0.797     0.407     0.200
     0.862    -0.220     0.200
     0.872     0.329     0.200
     0.888     0.537     0.200
     0.888     0.387     0.200
     0.956    -0.300     0.200
     0.943    -0.379     0.200
     0.943    -0.029     0.200
     0.955     0.151     0.200
     0.963     0.317     0.200
     0.186     0.127     0.200
     0.476     0.123     0.200
     0.477     0.122     0.200
     0.470     0.098     0.200
     0.512    -0.192     0.200
     0.549    -0.321     0.200
     0.562    -0.306     0.200
     0.690    -0.447     0.200
     0.690    -0.306     0.200
     0.852     0.330     0.200
     0.862     0.514     0.200
     0.866     0.385     0.200
     0.866     0.515     0.200
     0.919     0.174     0.200
     0.951     0.694     0.200
     0.968     0.679     0.200
     0.971    -0.379     0.200
     0.983    -0.481     0.200
     0.191     0.205     0.200
     0.476     0.154     0.200
     0.477     0.141     0.200
     0.478     0.050     0.200
     0.504     0.030     0.200
     0.544    -0.173     0.200
     0.565    -0.269     0.200
     0.682    -0.212     0.200
     0.844     0.231     0.200
     0.855     0.273     0.200
     0.861     1.018     0.200
     0.968    -0.542     0.200
     0.981    -0.640     0.200
     0.186    -0.038     0.200
     0.468     0.019     0.200
     0.475     0.099     0.200
     0.476     0.047     0.200
     0.514    -0.245     0.200
     0.550    -0.418     0.200
     0.562    -0.388     0.200
     0.691    -0.409     0.200
     0.853     0.051     0.200
     0.862     0.550     0.200
     0.866     1.243     0.200
     0.973    -0.331     0.200
     0.984    -0.219     0.200
     0.264    -0.048     0.200
     0.354     0.084     0.200
     0.456     0.335     0.200
     0.650    -0.033     0.200
     0.662    -0.157     0.200
     0.704    -0.689     0.200
     0.783     0.175     0.200
     0.791     0.202     0.200
     0.792     0.180     0.200
     0.921    -0.317     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.933    -1.238     0.200
     0.845    -1.363     0.200
     0.897    -1.131     0.200
     0.924    -1.325     0.200
     0.943    -1.107     0.200
     0.938    -0.588     0.200
     0.988    -0.435     0.200
     0.988    -0.536     0.200
     0.957    -1.117     0.200
     0.881    -0.569     0.200
     0.982    -0.585     0.200
     0.991    -0.559     0.200
     0.876    -1.293     0.200
     0.867    -1.117     0.200
     0.897    -1.137     0.200
     0.873    -1.439     0.200
     0.882    -1.403     0.200
     0.993    -0.589     0.200
     0.993    -0.171     0.200
     0.959    -1.240     0.200
     0.851    -0.963     0.200
     0.874    -0.775     0.200
     0.900    -0.947     0.200
     0.916     0.039     0.200
     0.978    -0.843     0.200
     1.000    -0.595     0.200
     0.996    -1.008     0.200
     0.996    -1.148     0.200
     0.870    -1.532     0.200
     0.982    -0.774     0.200
     0.983    -0.931     0.200
     0.983    -0.712     0.200
     0.984    -1.324     0.200
     0.871    -1.397     0.200
     0.871    -1.053     0.200
     0.872    -1.076     0.200
     0.929    -1.321     0.200
     0.961    -1.206     0.200
     0.979    -0.867     0.200
     0.866    -0.823     0.200
     0.863    -1.113     0.200
     0.921    -1.079     0.200
     0.971    -1.001     0.200
     0.872    -1.401     0.200
     0.970    -1.059     0.200
     0.870    -1.485     0.200
     0.934     5.112     0.200
     0.981    -1.364     0.200
     0.961    -1.320     0.200
     0.865    -1.451     0.200
     0.986    -0.913     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.267    -0.308     0.200
     0.781    -0.138     0.200
     0.835     0.188     0.200
     0.881     0.486     0.200
     0.949    -0.299     0.200
     0.989     1.032     0.200
     0.733     0.261     0.200
     0.709     0.180     0.200
     0.825     0.105     0.200
     0.936     0.613     0.200
     0.991    -0.218     0.200
     0.193     0.550     0.200
     0.618     0.104     0.200
     0.782    -0.182     0.200
     0.802    -0.007     0.200
     0.803    -0.047     0.200
     0.868     0.360     0.200
     0.906    -0.300     0.200
     0.783     0.281     0.200
     0.975    -0.208     0.200
     0.569     0.084     0.200
     0.448     0.292     0.200
     0.819     0.392     0.200
     0.874     0.369     0.200
     0.967     0.575     0.200
     0.990     0.264     0.200
     0.398     0.259     0.200
     0.398     0.144     0.200
     0.394     0.252     0.200
     0.607    -0.488     0.200
     0.607     0.523     0.200
     0.809     0.003     0.200
     0.311     0.413     0.200
     0.316    -0.096     0.200
     0.316    -0.116     0.200
     0.573     0.093     0.200
     0.343     0.388     0.200
     0.277     1.820     0.200
     0.372    -0.545     0.200
     0.372     1.197     0.200
     0.423    -0.380     0.200
     0.423     0.858     0.200
     0.423     1.030     0.200
     0.622    -0.194     0.200
     0.686     0.017     0.200
     0.777    -0.159     0.200
     0.814     0.040     0.200
     0.855    -0.384     0.200
     0.970    -0.349     0.200
     0.256     0.537     0.200
     0.375    -0.099     0.200
     0.428     0.113     0.200
     0.467    -0.187     0.200
     0.467     0.879     0.200
     0.681     0.009     0.200
     0.313     0.752     0.200
     0.555     0.412     0.200
     0.824    -0.465     0.200
     0.910    -0.064     0.200
     0.885    -0.808     0.200
     0.302     0.470     0.200
     0.274     0.589     0.200
     0.646    -0.291     0.200
     0.724    -0.097     0.200
     0.730    -0.529     0.200
     0.730     0.761     0.200
     0.808     0.141     0.200
     0.897    -0.227     0.200
     0.279    -0.009     0.200
     0.281    -0.081     0.200
     0.584     0.885     0.200
     0.695     1.107     0.200
     0.896    -0.077     0.200
     0.285     0.201     0.200
     0.287     0.367     0.200
     0.558    -0.268     0.200
     0.573     0.748     0.200
     0.692     0.921     0.200
     0.885     0.104     0.200
     0.288     0.053     0.200
     0.288     0.272     0.200
     0.289    -0.066     0.200
     0.552    -0.006     0.200
     0.688     1.201     0.200
     0.573     1.179     0.200
     0.698     1.769     0.200
     0.884     0.402     0.200
     0.282     0.098     0.200
     0.282     0.259     0.200
     0.283     0.000     0.200
     0.283     0.379     0.200
     0.283     1.000     0.200
     0.553     0.085     0.200
     0.578     0.679     0.200
     0.694     1.119     0.200
     0.890     0.293     0.200
     0.269    -0.316     0.200
     0.269     0.016     0.200
     0.271    -0.219     0.200
     0.271     0.109     0.200
     0.583     0.684     0.200
     0.562    -0.460     0.200
     0.710     0.572     0.200
     0.271     0.267     0.200
     0.273     0.214     0.200
     0.542     0.090     0.200
     0.592     0.768     0.200
     0.703     0.685     0.200
     0.903     0.121     0.200
     0.539     0.743     0.200
     0.544     0.578     0.200
     0.604    -0.105     0.200
     0.680     0.292     0.200
     0.275     0.398     0.200
     0.275     0.179     0.200
     0.275     0.538     0.200
     0.276     0.312     0.200
     0.578     0.649     0.200
     0.705     0.537     0.200
     0.279    -0.280     0.200
     0.281     0.174     0.200
     0.281     0.475     0.200
     0.562    -0.038     0.200
     0.562     0.185     0.200
     0.576     0.643     0.200
     0.700     1.088     0.200
     0.279     0.521     0.200
     0.279     0.922     0.200
     0.281    -0.097     0.200
     0.281     0.102     0.200
     0.572    -0.400     0.200
     0.571     0.782     0.200
     0.703     0.376     0.200
     0.883     0.296     0.200
     0.277     0.048     0.200
     0.279     0.129     0.200
     0.279     0.769     0.200
     0.556    -0.116     0.200
     0.580     0.780     0.200
     0.700     0.819     0.200
     0.268    -0.033     0.200
     0.270    -0.038     0.200
     0.894     0.172     0.200
     0.289    -0.227     0.200
     0.289     0.243     0.200
     0.291     0.263     0.200
     0.576     0.510     0.200
     0.289    -0.752     0.200
     0.289     0.269     0.200
     0.290     0.149     0.200
     0.290    -0.181     0.200
     0.562     0.393     0.200
     0.576     0.188     0.200
     0.874    -0.206     0.200
     0.283     0.366     0.200
     0.557    -0.072     0.200
     0.577     0.964     0.200
     0.888     0.043     0.200
     0.534     0.394     0.200
     0.901    -0.472     0.200
     0.938     0.149     0.200
     0.260    -0.579     0.200
     0.262    -0.046     0.200
     0.262     0.262     0.200
     0.596     0.952     0.200
     0.549    -0.223     0.200
     0.908    -0.194     0.200
     0.205     0.027     0.200
     0.205    -0.413     0.200
     0.207    -0.117     0.200
     0.644     1.043     0.200
     0.956     0.075     0.200
     0.241     0.156     0.200
     0.241    -0.067     0.200
     0.243     0.053     0.200
     0.539    -0.385     0.200
     0.539     0.326     0.200
     0.616     0.846     0.200
     0.928    -0.002     0.200
     0.231     0.167     0.200
     0.231     0.046     0.200
     0.233     0.175     0.200
     0.535    -0.404     0.200
     0.535     0.307     0.200
     0.626     0.662     0.200
     0.938     0.030     0.200
     0.282     0.204     0.200
     0.282     0.513     0.200
     0.566    -0.035     0.200
     0.571     0.751     0.200
     0.883     0.076     0.200
     0.339     0.273     0.200
     0.498     0.050     0.200
     0.751     0.067     0.200
     0.751     1.150     0.200
     0.865    -0.768     0.200
     0.893    -0.254     0.200
     0.882    -0.109     0.200
     0.882     0.039     0.200
     0.883     0.165     0.200
     0.942     0.273     0.200
     0.403    -0.104     0.200
     0.403     0.403     0.200
     0.479    -0.735     0.200
     0.480    -0.068     0.200
     0.480     0.213     0.200
     0.480     0.604     0.200
     0.367     0.542     0.200
     0.618     0.086     0.200
     0.618    -0.125     0.200
     0.620     0.094     0.200
     0.620    -0.188     0.200
     0.688    -0.117     0.200
     0.963     0.843     0.200
     0.346     0.655     0.200
     0.747    -0.632     0.200
     0.748    -0.687     0.200
     0.772     0.279     0.200
     0.889    -0.715     0.200
     0.889     0.596     0.200
     0.975    -0.765     0.200
     0.499     0.079     0.200
     0.545     0.428     0.200
     0.545    -0.342     0.200
     0.546    -0.342     0.200
     0.836     0.072     0.200
     0.348     0.448     0.200
     0.580    -0.201     0.200
     0.690     0.095     0.200
     0.746    -0.170     0.200
     0.747    -0.264     0.200
     0.747     0.026     0.200
     0.891    -0.472     0.200
     0.976    -0.623     0.200
     0.985    -0.742     0.200
     0.444    -0.114     0.200
     0.444     0.065     0.200
     0.446    -0.394     0.200
     0.446    -0.035     0.200
     0.448    -0.206     0.200
     0.450    -0.274     0.200
     0.450    -0.055     0.200
     0.450     0.347     0.200
     0.699     0.564     0.200
     0.837     0.165     0.200
     0.132     1.012     0.200
     0.399     0.511     0.200
     0.525    -0.007     0.200
     0.785    -0.672     0.200
     0.787    -0.443     0.200
     0.787    -0.583     0.200
     0.856    -0.161     0.200
     0.856     0.490     0.200
     0.935     0.376     0.200
     0.965    -0.387     0.200
     0.431     0.251     0.200
     0.433     0.023     0.200
     0.433     0.613     0.200
     0.433     1.013     0.200
     0.433     0.234     0.200
     0.764    -1.016     0.200
     0.764     0.693     0.200
     0.895    -0.176     0.200
     0.509     0.227     0.200
     0.510     0.252     0.200
     0.510    -0.271     0.200
     0.585    -0.775     0.200
     0.585    -0.010     0.200
     0.877     0.621     0.200
     0.079     0.289     0.200
     0.078    -0.824     0.200
     0.078    -0.394     0.200
     0.426     0.214     0.200
     0.665    -1.017     0.200
     0.489    -0.457     0.200
     0.489     0.535     0.200
     0.490    -0.385     0.200
     0.490    -0.776     0.200
     0.599    -0.643     0.200
     0.599    -0.994     0.200
     0.377     0.745     0.200
     0.514     0.182     0.200
     0.514    -0.538     0.200
     0.515    -0.045     0.200
     0.595    -0.589     0.200
     0.699    -0.370     0.200
     0.380     0.465     0.200
     0.504    -0.105     0.200
     0.505    -0.030     0.200
     0.505    -0.209     0.200
     0.599    -1.134     0.200
     0.599    -0.974     0.200
     0.599    -1.254     0.200
     0.690    -0.746     0.200
     0.888     1.864     0.200
     0.386     0.642     0.200
     0.499     0.470     0.200
     0.499    -0.520     0.200
     0.499     0.322     0.200
     0.499    -0.839     0.200
     0.599    -0.851     0.200
     0.682    -0.353     0.200
     0.885     1.052     0.200
     0.896     1.246     0.200
     0.288     0.855     0.200
     0.443    -0.025     0.200
     0.443    -0.304     0.200
     0.445    -0.318     0.200
     0.661    -0.309     0.200
     0.765    -1.302     0.200
     0.788    -0.384     0.200
     0.886     0.513     0.200
     0.886     0.362     0.200
     0.274    -0.757     0.200
     0.395     0.967     0.200
     0.508     0.199     0.200
     0.618    -0.073     0.200
     0.618     0.067     0.200
     0.720    -0.430     0.200
     0.720    -0.220     0.200
     0.732    -0.242     0.200
     0.732     0.718     0.200
     0.809    -0.505     0.200
     0.817    -0.438     0.200
     0.933    -0.580     0.200
     0.988    -0.387     0.200
     0.988     0.620     0.200
     0.358     0.148     0.200
     0.452    -0.037     0.200
     0.452     0.322     0.200
     0.452     0.197     0.200
     0.649    -0.777     0.200
     0.649     0.215     0.200
     0.935     1.688     0.200
     0.366     0.250     0.200
     0.366     0.721     0.200
     0.356    -1.024     0.200
     0.356    -1.434     0.200
     0.356    -0.623     0.200
     0.652    -0.485     0.200
     0.860    -0.636     0.200
     0.895    -0.402     0.200
     0.982    -0.924     0.200
     0.984    -0.610     0.200
     0.984    -1.030     0.200
     0.284     0.818     0.200
     0.447     0.055     0.200
     0.449    -0.524     0.200
     0.449     0.486     0.200
     0.761    -1.420     0.200
     0.665    -0.454     0.200
     0.790    -0.058     0.200
     0.882    -0.815     0.200
     0.266    -0.625     0.200
     0.266    -0.283     0.200
     0.377    -0.147     0.200
     0.438     0.611     0.200
     0.438     0.431     0.200
     0.438     0.291     0.200
     0.668    -0.090     0.200
     0.963    -0.465     0.200
     0.944     1.163     0.200
     0.238    -0.538     0.200
     0.238     0.393     0.200
     0.530    -0.476     0.200
     0.531     0.741     0.200
     0.532    -0.444     0.200
     0.532    -0.274     0.200
     0.856     1.915     0.200
     0.884     2.111     0.200
     0.959     0.635     0.200
     0.402     0.176     0.200
     0.402     0.816     0.200
     0.408     0.737     0.200
     0.408     0.577     0.200
     0.408    -0.487     0.200
     0.783    -1.647     0.200
     0.890     2.324     0.200
     0.981    -0.685     0.200
     0.980     1.268     0.200
     0.309    -1.971     0.200
     0.416     0.137     0.200
     0.625     0.062     0.200
     0.693     2.124     0.200
     0.772     0.347     0.200
     0.772     0.136     0.200
     0.773     0.464     0.200
     0.843     0.520     0.200
     0.849     0.711     0.200
     0.853     1.595     0.200
     0.872    -0.092     0.200
     0.925    -0.320     0.200
     0.983     0.390     0.200
     0.983     0.570     0.200
     0.195     0.356     0.200
     0.195     1.137     0.200
     0.495     0.191     0.200
     0.505     0.554     0.200
     0.505     0.264     0.200
     0.507     0.504     0.200
     0.544     0.389     0.200
     0.572    -0.831     0.200
     0.899     1.880     0.200
     0.978    -0.680     0.200
     0.180     0.251     0.200
     0.496     0.065     0.200
     0.496     0.495     0.200
     0.502    -0.566     0.200
     0.497     0.326     0.200
     0.497     0.955     0.200
     0.550    -0.298     0.200
     0.560    -0.918     0.200
     0.941    -0.601     0.200
     0.941    -0.082     0.200
     0.964    -0.063     0.200
     0.177    -0.881     0.200
     0.494     0.133     0.200
     0.494     0.014     0.200
     0.496    -0.330     0.200
     0.496    -0.189     0.200
     0.496     0.280     0.200
     0.496     0.481     0.200
     0.505    -0.715     0.200
     0.556    -0.727     0.200
     0.551    -0.547     0.200
     0.961    -0.135     0.200
     0.180    -0.297     0.200
     0.180     0.141     0.200
     0.494    -0.294     0.200
     0.494     0.214     0.200
     0.496    -0.479     0.200
     0.496     0.091     0.200
     0.502    -0.456     0.200
     0.552    -0.931     0.200
     0.559    -0.667     0.200
     0.915     1.407     0.200
     0.942     0.345     0.200
     0.963     0.046     0.200
     0.274    -0.542     0.200
     0.274     0.188     0.200
     0.365    -1.100     0.200
     0.420     0.115     0.200
     0.672     0.504     0.200
     0.709    -0.081     0.200
     0.709     0.028     0.200
     0.710    -0.034     0.200
     0.761    -0.451     0.200
     0.326    -0.522     0.200
     0.188    -0.653     0.200
     0.405    -0.605     0.200
     0.405    -0.363     0.200
     0.407    -0.388     0.200
     0.407     0.691     0.200
     0.758     0.088     0.200
     0.778     0.699     0.200
     0.503     0.017     0.200
     0.525     0.148     0.200
     0.525    -0.321     0.200
     0.526    -0.152     0.200
     0.526    -0.300     0.200
     0.575    -0.383     0.200
     0.885     0.904     0.200
     0.933    -0.635     0.200
     0.263     0.244     0.200
     0.264     0.176     0.200
     0.264     1.082     0.200
     0.351     0.610     0.200
     0.717    -0.806     0.200
     0.687    -0.746     0.200
     0.376     0.286     0.200
     0.624    -0.147     0.200
     0.624     0.224     0.200
     0.814     0.086     0.200
     0.892    -0.040     0.200
     0.892    -0.150     0.200
     0.992    -0.385     0.200
     0.992    -0.514     0.200
     0.977     1.684     0.200
     0.481     0.268     0.200
     0.481     0.104     0.200
     0.680    -1.095     0.200
     0.902     1.833     0.200
     0.912     1.774     0.200
     0.405     0.336     0.200
     0.405     0.796     0.200
     0.539    -0.879     0.200
     0.539    -0.699     0.200
     0.539    -0.429     0.200
     0.602    -0.099     0.200
     0.701    -0.683     0.200
     0.786    -0.306     0.200
     0.787    -0.820     0.200
     0.812    -0.472     0.200
     0.972     0.366     0.200
     0.851     0.183     0.200
     0.710    -0.538     0.200
     0.432     0.037     0.200
     0.432     0.467     0.200
     0.472    -0.110     0.200
     0.549     0.046     0.200
     0.836     1.553     0.200
     0.172    -0.321     0.200
     0.172     0.019     0.200
     0.562    -0.772     0.200
     0.562    -0.612     0.200
     0.806     0.405     0.200
     0.919     0.424     0.200
     0.251    -1.717     0.200
     0.441    -0.320     0.200
     0.441     0.032     0.200
     0.529     0.420     0.200
     0.750    -0.152     0.200
     0.748     0.012     0.200
     0.847    -0.647     0.200
     0.880    -0.676     0.200
     0.880    -0.551     0.200
     0.883    -0.721     0.200
     0.926    -0.526     0.200
     0.248     0.507     0.200
     0.248     0.886     0.200
     0.409     0.113     0.200
     0.409     0.452     0.200
     0.409     0.564     0.200
     0.832    -1.149     0.200
     0.832    -0.829     0.200
     0.868    -0.170     0.200
     0.907    -0.312     0.200
     0.243    -0.829     0.200
     0.480     0.415     0.200
     0.480     0.155     0.200
     0.480     0.695     0.200
     0.480     0.845     0.200
     0.488    -0.258     0.200
     0.491    -0.019     0.200
     0.491     0.081     0.200
     0.697    -0.196     0.200
     0.697    -0.326     0.200
     0.795    -0.232     0.200
     0.795    -0.832     0.200
     0.773     0.100     0.200
     0.847    -0.437     0.200
     0.858    -0.306     0.200
     0.930     0.357     0.200
     0.930    -0.323     0.200
     0.917     1.784     0.200
     0.957     0.446     0.200
     0.984    -0.349     0.200
     0.979    -0.328     0.200
     0.481     0.125     0.200
     0.481     0.355     0.200
     0.481     0.598     0.200
     0.489    -0.196     0.200
     0.491    -0.090     0.200
     0.491     0.257     0.200
     0.697     0.041     0.200
     0.697    -0.166     0.200
     0.773     0.032     0.200
     0.795    -0.265     0.200
     0.795    -0.394     0.200
     0.847    -0.257     0.200
     0.847    -0.437     0.200
     0.858    -0.275     0.200
     0.858    -0.292     0.200
     0.876    -0.437     0.200
     0.876    -0.214     0.200
     0.916     0.815     0.200
     0.930     0.023     0.200
     0.956     0.795     0.200
     0.984    -0.159     0.200
     0.978     0.053     0.200
     0.296    -0.758     0.200
     0.296    -0.576     0.200
     0.296    -0.457     0.200
     0.352     0.141     0.200
     0.393    -1.045     0.200
     0.609     0.580     0.200
     0.609     0.419     0.200
     0.735     0.298     0.200
     0.735    -0.331     0.200
     0.833     0.256     0.200
     0.889     0.209     0.200
     0.991     0.125     0.200
     0.991    -0.215     0.200
     0.162    -0.544     0.200
     0.162    -0.419     0.200
     0.278    -0.674     0.200
     0.278    -0.291     0.200
     0.278    -0.072     0.200
     0.278    -0.775     0.200
     0.504    -0.261     0.200
     0.565    -0.006     0.200
     0.565     0.299     0.200
     0.709    -0.136     0.200
     0.776    -0.117     0.200
     0.927     0.816     0.200
     0.307    -0.474     0.200
     0.307    -0.294     0.200
     0.355    -0.339     0.200
     0.355     0.341     0.200
     0.721    -0.222     0.200
     0.821     0.235     0.200
     0.284    -0.679     0.200
     0.284    -0.570     0.200
     0.347    -0.163     0.200
     0.390    -1.295     0.200
     0.459    -0.555     0.200
     0.459     0.195     0.200
     0.627    -0.263     0.200
     0.627     0.225     0.200
     0.640     0.157     0.200
     0.723    -0.645     0.200
     0.794     0.175     0.200
     0.814     0.644     0.200
     0.901     0.492     0.200
     0.207    -0.806     0.200
     0.376    -0.560     0.200
     0.472    -0.035     0.200
     0.472     0.355     0.200
     0.472     0.565     0.200
     0.535     0.457     0.200
     0.519     0.059     0.200
     0.534     0.022     0.200
     0.534    -0.149     0.200
     0.534     0.511     0.200
     0.660    -0.446     0.200
     0.660     0.054     0.200
     0.755    -0.240     0.200
     0.755     0.319     0.200
     0.757    -0.039     0.200
     0.799    -0.282     0.200
     0.812    -0.726     0.200
     0.812    -0.073     0.200
     0.819     0.005     0.200
     0.956    -0.571     0.200
     0.971     0.380     0.200
     0.977     0.656     0.200
     0.228    -0.527     0.200
     0.228     0.309     0.200
     0.228     0.559     0.200
     0.402    -0.463     0.200
     0.459    -0.217     0.200
     0.643    -0.412     0.200
     0.643     0.057     0.200
     0.665     0.281     0.200
     0.768     0.356     0.200
     0.789     0.075     0.200
     0.789     0.591     0.200
     0.943    -0.251     0.200
     0.200    -0.003     0.200
     0.200     0.165     0.200
     0.200     0.427     0.200
     0.534     0.755     0.200
     0.662    -0.558     0.200
     0.662     0.091     0.200
     0.662     0.770     0.200
     0.623     0.104     0.200
     0.623     0.905     0.200
     0.238    -0.202     0.200
     0.391    -0.557     0.200
     0.391     0.642     0.200
     0.478    -0.492     0.200
     0.478    -0.192     0.200
     0.478     0.058     0.200
     0.483    -0.046     0.200
     0.483     0.302     0.200
     0.483     0.864     0.200
     0.493    -0.504     0.200
     0.493    -0.055     0.200
     0.535     0.168     0.200
     0.535     0.777     0.200
     0.696    -0.358     0.200
     0.696    -0.588     0.200
     0.794    -0.612     0.200
     0.843    -0.480     0.200
     0.854    -0.408     0.200
     0.854    -0.335     0.200
     0.853     0.558     0.200
     0.874    -0.554     0.200
     0.874    -0.355     0.200
     0.900     0.304     0.200
     0.912     1.453     0.200
     0.931    -0.529     0.200
     0.931    -0.201     0.200
     0.955     0.605     0.200
     0.982    -0.563     0.200
     0.974    -0.159     0.200
     0.998    -0.729     0.200
     0.210     0.646     0.200
     0.210     0.396     0.200
     0.210     0.775     0.200
     0.464    -0.028     0.200
     0.494    -0.582     0.200
     0.494    -0.070     0.200
     0.486     0.278     0.200
     0.570    -0.467     0.200
     0.582    -0.572     0.200
     0.665     0.034     0.200
     0.827     0.610     0.200
     0.894     1.734     0.200
     0.926     1.269     0.200
     0.977    -0.082     0.200
     0.992    -0.495     0.200
     0.974    -0.166     0.200
     0.974     0.845     0.200
     0.079    -0.785     0.200
     0.290    -0.690     0.200
     0.333     0.523     0.200
     0.333    -0.516     0.200
     0.333     0.782     0.200
     0.333     0.942     0.200
     0.402    -0.476     0.200
     0.428    -0.081     0.200
     0.428     0.700     0.200
     0.412    -0.426     0.200
     0.492    -0.199     0.200
     0.491    -0.212     0.200
     0.593    -0.198     0.200
     0.593    -0.067     0.200
     0.593     0.103     0.200
     0.683    -0.615     0.200
     0.694    -0.280     0.200
     0.694    -0.410     0.200
     0.721    -0.206     0.200
     0.721    -0.452     0.200
     0.807    -0.461     0.200
     0.839     0.443     0.200
     0.862    -0.121     0.200
     0.868     0.165     0.200
     0.954    -0.338     0.200
     0.969    -0.501     0.200
     0.132    -0.449     0.200
     0.211    -0.532     0.200
     0.252    -0.480     0.200
     0.434     0.129     0.200
     0.514    -0.039     0.200
     0.514    -0.141     0.200
     0.514     0.992     0.200
     0.658     0.665     0.200
     0.719     0.155     0.200
     0.729     0.176     0.200
     0.729    -0.176     0.200
     0.744     0.552     0.200
     0.746    -0.354     0.200
     0.785    -0.078     0.200
     0.832     0.233     0.200
     0.832    -0.017     0.200
     0.904    -0.461     0.200
     0.906    -0.164     0.200
     0.946     0.134     0.200
     0.946    -0.573     0.200
     0.148    -0.354     0.200
     0.516    -0.398     0.200
     0.723     0.167     0.200
     0.743     0.387     0.200
     0.743    -0.870     0.200
     0.780    -0.720     0.200
     0.807     1.901     0.200
     0.824    -0.055     0.200
     0.851     1.858     0.200
     0.897    -0.987     0.200
     0.910    -0.817     0.200
     0.940    -0.765     0.200
     0.984     0.379     0.200
     0.136    -0.673     0.200
     0.136     0.696     0.200
     0.425     0.205     0.200
     0.516    -0.566     0.200
     0.516    -0.436     0.200
     0.507     0.753     0.200
     0.720     0.040     0.200
     0.658     0.424     0.200
     0.790    -0.033     0.200
     0.742    -0.274     0.200
     0.743     0.294     0.200
     0.786     0.647     0.200
     0.779    -0.246     0.200
     0.823     0.056     0.200
     0.911     0.381     0.200
     0.895    -0.638     0.200
     0.895     0.273     0.200
     0.851     1.254     0.200
     0.938    -0.147     0.200
     0.261    -0.421     0.200
     0.401    -0.566     0.200
     0.433    -0.579     0.200
     0.424    -0.011     0.200
     0.590     1.408     0.200
     0.736    -0.980     0.200
     0.755     0.942     0.200
     0.878     0.162     0.200
     0.945     0.224     0.200
     0.996     0.252     0.200
     0.986    -0.627     0.200
     0.986    -0.477     0.200
     0.139    -0.375     0.200
     0.139     0.054     0.200
     0.139     0.193     0.200
     0.157    -0.217     0.200
     0.507    -0.087     0.200
     0.507     0.163     0.200
     0.507     0.433     0.200
     0.665     0.142     0.200
     0.672     1.313     0.200
     0.726     0.070     0.200
     0.726     0.539     0.200
     0.752    -1.062     0.200
     0.775    -0.037     0.200
     0.790    -0.587     0.200
     0.793     1.659     0.200
     0.794    -0.020     0.200
     0.814     1.972     0.200
     0.833    -0.172     0.200
     0.860     0.912     0.200
     0.905    -0.611     0.200
     0.905    -0.480     0.200
     0.901    -0.399     0.200
     0.901     0.060     0.200
     0.949    -0.333     0.200
     0.949    -0.503     0.200
     0.142    -0.186     0.200
     0.131    -0.012     0.200
     0.523    -0.394     0.200
     0.651     0.323     0.200
     0.664     1.753     0.200
     0.735    -0.555     0.200
     0.736     0.278     0.200
     0.792    -0.145     0.200
     0.773    -0.409     0.200
     0.773    -0.218     0.200
     0.781     2.518     0.200
     0.820    -0.127     0.200
     0.820     0.166     0.200
     0.820     0.963     0.200
     0.844     1.547     0.200
     0.891    -0.641     0.200
     0.891    -0.290     0.200
     0.918    -0.324     0.200
     0.103     0.040     0.200
     0.103     0.220     0.200
     0.103     0.751     0.200
     0.337    -0.472     0.200
     0.337    -0.292     0.200
     0.740    -0.070     0.200
     0.740     0.450     0.200
     0.724     0.392     0.200
     0.955    -0.162     0.200
     0.983     0.704     0.200
     0.383    -0.024     0.200
     0.336    -0.447     0.200
     0.459     0.214     0.200
     0.459     0.514     0.200
     0.487     0.548     0.200
     0.453    -0.591     0.200
     0.453    -0.461     0.200
     0.477    -0.438     0.200
     0.735    -0.417     0.200
     0.735    -0.287     0.200
     0.840    -0.621     0.200
     0.892    -0.431     0.200
     0.948    -0.313     0.200
     0.391     0.704     0.200
     0.391     1.173     0.200
     0.450     0.455     0.200
     0.461     0.454     0.200
     0.486    -0.213     0.200
     0.486     0.045     0.200
     0.564    -0.602     0.200
     0.564    -0.446     0.200
     0.622    -0.268     0.200
     0.622     0.591     0.200
     0.622     0.748     0.200
     0.622    -0.487     0.200
     0.724    -0.660     0.200
     0.724    -0.785     0.200
     0.815    -0.410     0.200
     0.916     0.666     0.200
     0.915    -0.473     0.200
     0.939    -0.687     0.200
     0.991     0.043     0.200
     0.503     0.372     0.200
     0.503     1.059     0.200
     0.551    -0.106     0.200
     0.567     0.455     0.200
     0.852     0.757     0.200
     0.956    -0.292     0.200
     0.956     0.598     0.200
     0.968    -0.260     0.200
     0.919     2.604     0.200
     0.954     0.389     0.200
     0.954     0.846     0.200
     0.954    -0.943     0.200
     0.495     1.007     0.200
     0.493     0.812     0.200
     0.559     0.223     0.200
     0.552    -0.164     0.200
     0.846     0.976     0.200
     0.951    -0.093     0.200
     0.964    -0.519     0.200
     0.961    -0.907     0.200
     0.961    -0.606     0.200
     0.542    -0.287     0.200
     0.504    -0.154     0.200
     0.499    -0.082     0.200
     0.499     0.308     0.200
     0.564    -0.371     0.200
     0.858     0.100     0.200
     0.882     2.281     0.200
     0.948     0.137     0.200
     0.950    -0.598     0.200
     0.950     0.179     0.200
     0.950    -0.871     0.200
     0.960    -0.214     0.200
     0.174     0.980     0.200
     0.501     0.076     0.200
     0.499    -0.017     0.200
     0.499     0.444     0.200
     0.544     0.026     0.200
     0.562     0.108     0.200
     0.691    -0.555     0.200
     0.922     2.270     0.200
     0.948     0.021     0.200
     0.953    -0.783     0.200
     0.953    -0.373     0.200
     0.960    -0.793     0.200
     0.969     1.085     0.200
     0.164    -0.373     0.200
     0.164     0.111     0.200
     0.164    -1.045     0.200
     0.496    -0.163     0.200
     0.496     0.220     0.200
     0.519     0.041     0.200
     0.540     0.287     0.200
     0.579    -1.109     0.200
     0.707     0.164     0.200
     0.936     0.314     0.200
     0.957     0.374     0.200
     0.957    -0.087     0.200
     0.155    -0.182     0.200
     0.155     0.529     0.200
     0.155     0.677     0.200
     0.155    -0.401     0.200
     0.506     0.119     0.200
     0.530    -0.352     0.200
     0.519    -0.533     0.200
     0.575    -0.720     0.200
     0.712    -0.279     0.200
     0.933    -0.020     0.200
     0.890     1.973     0.200
     0.948     0.152     0.200
     0.948    -0.169     0.200
     0.957     0.019     0.200
     0.990    -0.454     0.200
     0.190     0.182     0.200
     0.190     0.382     0.200
     0.484    -0.328     0.200
     0.484    -0.049     0.200
     0.497    -0.557     0.200
     0.497     0.203     0.200
     0.560    -0.497     0.200
     0.560    -0.257     0.200
     0.565    -0.653     0.200
     0.680    -0.531     0.200
     0.842     0.803     0.200
     0.855     2.365     0.200
     0.938     1.712     0.200
     0.960     0.279     0.200
     0.962    -0.176     0.200
     0.962     0.203     0.200
     0.974     0.147     0.200
     0.237     0.322     0.200
     0.237     1.232     0.200
     0.391    -0.033     0.200
     0.395    -0.077     0.200
     0.449    -0.352     0.200
     0.449    -0.024     0.200
     0.689    -0.525     0.200
     0.683    -0.245     0.200
     0.683    -0.346     0.200
     0.749    -0.075     0.200
     0.749     0.464     0.200
     0.749     1.405     0.200
     0.749    -0.325     0.200
     0.771    -0.484     0.200
     0.985    -0.220     0.200
     0.985     0.792     0.200
     0.985     1.151     0.200
     0.174    -0.337     0.200
     0.174     0.084     0.200
     0.174    -0.447     0.200
     0.365    -0.597     0.200
     0.478    -0.635     0.200
     0.496    -0.630     0.200
     0.533    -0.765     0.200
     0.523    -0.331     0.200
     0.523    -0.593     0.200
     0.683    -0.542     0.200
     0.733     0.169     0.200
     0.848     0.874     0.200
     0.919     0.493     0.200
     0.933     0.435     0.200
     0.968     0.618     0.200
     0.968     0.305     0.200
     0.176     0.473     0.200
     0.495    -0.003     0.200
     0.495     0.395     0.200
     0.503     0.081     0.200
     0.547    -0.206     0.200
     0.547     0.165     0.200
     0.565    -0.212     0.200
     0.691    -0.240     0.200
     0.868     2.118     0.200
     0.953    -1.168     0.200
     0.922     2.048     0.200
     0.293    -0.029     0.200
     0.293     0.292     0.200
     0.293    -1.224     0.200
     0.282     0.030     0.200
     0.359     0.300     0.200
     0.446    -0.031     0.200
     0.446     0.742     0.200
     0.502    -0.281     0.200
     0.624    -0.122     0.200
     0.624     1.057     0.200
     0.624    -0.450     0.200
     0.640    -0.014     0.200
     0.782    -0.230     0.200
     0.813    -0.046     0.200
     0.813    -0.429     0.200
     0.893     0.162     0.200
     0.893    -0.666     0.200
     0.993    -0.699     0.200
     0.172    -0.522     0.200
     0.172     0.657     0.200
     0.404    -1.754     0.200
     0.492    -0.070     0.200
     0.492     0.430     0.200
     0.512    -0.402     0.200
     0.538    -0.395     0.200
     0.642    -0.357     0.200
     0.698    -0.569     0.200
     0.774     0.016     0.200
     0.874     2.543     0.200
     0.880     2.732     0.200
     0.944     0.030     0.200
     0.957    -0.167     0.200
     0.957     0.333     0.200
     0.968     0.153     0.200
     0.976    -0.088     0.200
     0.148    -1.020     0.200
     0.148    -0.192     0.200
     0.148    -0.860     0.200
     0.488    -0.948     0.200
     0.488    -0.729     0.200
     0.634    -0.426     0.200
     0.634     0.324     0.200
     0.806    -0.394     0.200
     0.829     0.314     0.200
     0.829     0.002     0.200
     0.164    -0.511     0.200
     0.164     0.870     0.200
     0.164     0.040     0.200
     0.398    -1.668     0.200
     0.504    -0.334     0.200
     0.504     0.067     0.200
     0.504    -0.664     0.200
     0.509    -0.275     0.200
     0.536    -0.452     0.200
     0.637    -0.149     0.200
     0.701    -0.129     0.200
     0.765     0.774     0.200
     0.943    -0.074     0.200
     0.943    -0.254     0.200
     0.946     0.478     0.200
     0.957    -0.231     0.200
     0.979     0.067     0.200
     0.286     0.849     0.200
     0.384     0.442     0.200
     0.384     0.323     0.200
     0.397    -0.112     0.200
     0.415     0.744     0.200
     0.520    -0.510     0.200
     0.520    -0.001     0.200
     0.507    -0.235     0.200
     0.526    -0.720     0.200
     0.678    -0.569     0.200
     0.678    -0.090     0.200
     0.678    -0.819     0.200
     0.786    -0.648     0.200
     0.786    -0.359     0.200
     0.786    -0.789     0.200
     0.917    -0.575     0.200
     0.926    -0.277     0.200
     0.946     0.074     0.200
     0.198     0.458     0.200
     0.198     1.247     0.200
     0.198     0.197     0.200
     0.503     0.047     0.200
     0.503    -0.203     0.200
     0.490     0.065     0.200
     0.490     0.706     0.200
     0.521     0.145     0.200
     0.561    -0.345     0.200
     0.845     1.910     0.200
     0.897     2.534     0.200
     0.950    -0.312     0.200
     0.943     0.843     0.200
     0.943     1.025     0.200
     0.965    -0.367     0.200
     0.371    -0.839     0.200
     0.371    -0.206     0.200
     0.371     0.013     0.200
     0.371    -0.417     0.200
     0.396    -0.420     0.200
     0.396     0.267     0.200
     0.416     0.373     0.200
     0.563     0.373     0.200
     0.563     0.522     0.200
     0.592     0.491     0.200
     0.816    -0.295     0.200
     0.915    -0.948     0.200
     0.950     2.953     0.200
     0.953    -0.331     0.200
     0.997    -0.523     0.200
     0.172    -0.064     0.200
     0.172     0.436     0.200
     0.451     0.091     0.200
     0.451     0.895     0.200
     0.451    -0.355     0.200
     0.479    -0.288     0.200
     0.479    -0.030     0.200
     0.531    -0.408     0.200
     0.560    -0.521     0.200
     0.554    -0.312     0.200
     0.976     0.272     0.200
     0.985     0.089     0.200
     0.249     0.276     0.200
     0.249     0.807     0.200
     0.383     0.277     0.200
     0.383     1.015     0.200
     0.383     0.757     0.200
     0.421     0.073     0.200
     0.633     0.740     0.200
     0.715     1.270     0.200
     0.760    -0.610     0.200
     0.780     2.167     0.200
     0.823     0.917     0.200
     0.875     1.994     0.200
     0.989    -1.278     0.200
     0.957     0.791     0.200
     0.165     0.036     0.200
     0.165     0.795     0.200
     0.165    -0.545     0.200
     0.469    -0.080     0.200
     0.469     0.821     0.200
     0.469    -0.240     0.200
     0.497    -0.474     0.200
     0.497     0.066     0.200
     0.516    -0.226     0.200
     0.538    -0.562     0.200
     0.939    -0.107     0.200
     0.939    -0.277     0.200
     0.955     0.163     0.200
     0.964     0.199     0.200
     0.273     0.048     0.200
     0.272     0.571     0.200
     0.272     1.181     0.200
     0.471    -0.337     0.200
     0.634     0.041     0.200
     0.644     0.036     0.200
     0.711    -0.416     0.200
     0.711    -0.887     0.200
     0.810    -0.009     0.200
     0.810    -0.479     0.200
     0.914     0.250     0.200
     0.914    -0.289     0.200
     0.914    -0.799     0.200
     0.418     0.830     0.200
     0.422    -0.308     0.200
     0.422     0.142     0.200
     0.485     0.267     0.200
     0.572    -0.370     0.200
     0.572     0.239     0.200
     0.616    -0.093     0.200
     0.616     0.856     0.200
     0.616    -0.394     0.200
     0.714    -0.190     0.200
     0.791    -0.384     0.200
     0.798    -0.319     0.200
     0.798    -0.538     0.200
     0.825    -0.319     0.200
     0.875     0.517     0.200
     0.904    -0.251     0.200
     0.933     0.308     0.200
     0.976    -0.634     0.200
     0.985    -0.143     0.200
     0.991     0.092     0.200
     0.250     0.580     0.200
     0.250     0.860     0.200
     0.420     0.272     0.200
     0.382     0.383     0.200
     0.382     1.083     0.200
     0.382     0.253     0.200
     0.634     0.273     0.200
     0.774    -0.890     0.200
     0.717     2.285     0.200
     0.760    -0.342     0.200
     0.781     1.745     0.200
     0.987    -0.614     0.200
     0.876     1.524     0.200
     0.183    -0.131     0.200
     0.183     0.779     0.200
     0.183    -0.519     0.200
     0.466    -0.752     0.200
     0.519    -0.277     0.200
     0.539     0.203     0.200
     0.539    -0.066     0.200
     0.547     0.235     0.200
     0.547     0.543     0.200
     0.547    -0.787     0.200
     0.838     1.620     0.200
     0.867     2.018     0.200
     0.946    -0.262     0.200
     0.988     0.255     0.200
     0.237    -0.683     0.200
     0.301    -0.602     0.200
     0.301    -0.213     0.200
     0.301    -0.852     0.200
     0.411    -0.733     0.200
     0.650     0.395     0.200
     0.650     1.285     0.200
     0.650     0.064     0.200
     0.675     0.333     0.200
     0.675     0.894     0.200
     0.736    -0.326     0.200
     0.781     0.013     0.200
     0.895    -0.016     0.200
     0.895    -0.167     0.200
     0.895    -0.397     0.200
     0.991     0.144     0.200
     0.991    -0.307     0.200
     0.982     0.049     0.200
     0.995    -0.083     0.200
     0.973     0.235     0.200
     0.279    -0.257     0.200
     0.279     0.103     0.200
     0.279    -0.367     0.200
     0.544     0.309     0.200
     0.569     0.276     0.200
     0.569     0.496     0.200
     0.569     0.116     0.200
     0.195    -0.307     0.200
     0.195     0.514     0.200
     0.443    -0.040     0.200
     0.464    -0.344     0.200
     0.529    -0.149     0.200
     0.547     0.035     0.200
     0.547     0.205     0.200
     0.542    -0.411     0.200
     0.661    -0.353     0.200
     0.855     2.162     0.200
     0.894    -0.467     0.200
     0.894     0.225     0.200
     0.912    -0.559     0.200
     0.886     2.262     0.200
     0.886     0.549     0.200
     0.897     2.766     0.200
     0.897     0.427     0.200
     0.909     0.483     0.200
     0.910     2.235     0.200
     0.974     0.814     0.200
     0.999    -0.239     0.200
     0.193    -0.444     0.200
     0.193     0.116     0.200
     0.447    -0.174     0.200
     0.469    -0.488     0.200
     0.531    -0.517     0.200
     0.542     0.113     0.200
     0.537    -0.497     0.200
     0.537    -0.368     0.200
     0.542     0.244     0.200
     0.662    -0.563     0.200
     0.827     1.160     0.200
     0.855     2.745     0.200
     0.899     0.216     0.200
     0.899     0.367     0.200
     0.884     0.554     0.200
     0.897     0.551     0.200
     0.916     0.104     0.200
     0.911     0.780     0.200
     0.912     0.763     0.200
     0.936     0.420     0.200
     0.977     0.806     0.200
     0.996     0.111     0.200
     0.996    -0.200     0.200
     0.209     0.226     0.200
     0.209     0.796     0.200
     0.432     0.564     0.200
     0.464     0.588     0.200
     0.535    -0.199     0.200
     0.555    -0.006     0.200
     0.555     0.225     0.200
     0.542    -0.251     0.200
     0.646     0.680     0.200
     0.812     0.453     0.200
     0.841     2.757     0.200
     0.873     2.242     0.200
     0.873     0.347     0.200
     0.882     2.527     0.200
     0.882     0.348     0.200
     0.895     0.050     0.200
     0.920     0.483     0.200
     0.898    -0.341     0.200
     0.898    -0.561     0.200
     0.918    -0.671     0.200
     0.962     0.054     0.200
     0.201     0.676     0.200
     0.201     1.535     0.200
     0.431     0.192     0.200
     0.449     0.059     0.200
     0.525     0.074     0.200
     0.554    -0.218     0.200
     0.554    -0.319     0.200
     0.562    -0.272     0.200
     0.562     0.502     0.200
     0.562    -0.061     0.200
     0.854     2.300     0.200
     0.880    -0.437     0.200
     0.880    -0.249     0.200
     0.890     1.776     0.200
     0.900    -0.203     0.200
     0.193     0.291     0.200
     0.193     1.601     0.200
     0.528    -0.264     0.200
     0.463    -0.212     0.200
     0.444    -0.163     0.200
     0.547     0.238     0.200
     0.543    -0.248     0.200
     0.893    -0.547     0.200
     0.911    -0.346     0.200
     0.998    -0.513     0.200
     0.998    -0.643     0.200
     0.857     1.959     0.200
     0.911     2.013     0.200
     0.898     2.028     0.200
     0.935     0.693     0.200
     0.243    -0.053     0.200
     0.244    -0.322     0.200
     0.387     0.035     0.200
     0.387     0.496     0.200
     0.387    -0.297     0.200
     0.407     0.055     0.200
     0.407     0.266     0.200
     0.651    -0.558     0.200
     0.696     0.133     0.200
     0.723     2.569     0.200
     0.779    -0.162     0.200
     0.792     2.156     0.200
     0.838     1.308     0.200
     0.977     0.313     0.200
     0.977    -0.629     0.200
     0.979     0.744     0.200
     0.288     0.918     0.200
     0.288     1.348     0.200
     0.365    -0.082     0.200
     0.366     0.264     0.200
     0.533     0.314     0.200
     0.633    -0.049     0.200
     0.672    -0.408     0.200
     0.672    -0.027     0.200
     0.644    -0.274     0.200
     0.768     2.121     0.200
     0.787     2.019     0.200
     0.800     1.233     0.200
     0.861     1.822     0.200
     0.925     1.482     0.200
     0.992    -0.968     0.200
     0.182     0.077     0.200
     0.182     1.057     0.200
     0.468    -0.411     0.200
     0.468     0.706     0.200
     0.490    -0.381     0.200
     0.533    -0.292     0.200
     0.520     0.408     0.200
     0.520     0.076     0.200
     0.524    -0.239     0.200
     0.931    -0.021     0.200
     0.931     0.159     0.200
     0.978     0.149     0.200
     0.186    -0.237     0.200
     0.186     1.033     0.200
     0.186    -0.577     0.200
     0.462    -0.046     0.200
     0.484    -0.344     0.200
     0.533    -0.622     0.200
     0.533    -0.243     0.200
     0.527    -0.186     0.200
     0.528    -0.278     0.200
     0.927     0.743     0.200
     0.984     0.159     0.200
     0.991     0.440     0.200
     0.286    -0.385     0.200
     0.287     0.197     0.200
     0.287     0.607     0.200
     0.345     0.078     0.200
     0.345     0.621     0.200
     0.345     0.219     0.200
     0.383    -0.309     0.200
     0.383     0.429     0.200
     0.383     1.050     0.200
     0.645    -0.098     0.200
     0.737    -0.591     0.200
     0.737    -0.439     0.200
     0.714    -0.293     0.200
     0.762     2.127     0.200
     0.822     2.218     0.200
     0.822     2.679     0.200
     0.861     1.140     0.200
     0.945    -0.530     0.200
     0.945    -0.112     0.200
     0.167     0.796     0.200
     0.167     1.166     0.200
     0.167     0.426     0.200
     0.475    -0.061     0.200
     0.475     0.629     0.200
     0.475    -0.311     0.200
     0.498     0.044     0.200
     0.499     0.012     0.200
     0.499    -0.358     0.200
     0.510     0.493     0.200
     0.510    -0.177     0.200
     0.540    -0.110     0.200
     0.700    -0.209     0.200
     0.863     0.970     0.200
     0.944    -1.285     0.200
     0.944    -0.355     0.200
     0.944    -1.575     0.200
     0.962    -0.534     0.200
     0.561    -0.402     0.200
     0.561     0.156     0.200
     0.562    -0.595     0.200
     0.562     0.105     0.200
     0.560    -0.047     0.200
     0.560     0.773     0.200
     0.644    -0.065     0.200
     0.734    -0.279     0.200
     0.734    -0.461     0.200
     0.759    -0.415     0.200
     0.769    -0.361     0.200
     0.794    -0.199     0.200
     0.806    -0.326     0.200
     0.822    -0.558     0.200
     0.916    -1.033     0.200
     0.320     0.120     0.200
     0.320     1.001     0.200
     0.320     0.251     0.200
     0.322     0.083     0.200
     0.322     0.333     0.200
     0.325     0.726     0.200
     0.325     1.236     0.200
     0.693    -0.210     0.200
     0.713    -0.736     0.200
     0.771    -0.550     0.200
     0.777    -0.409     0.200
     0.882    -1.042     0.200
     0.321     0.041     0.200
     0.321     0.522     0.200
     0.321     1.131     0.200
     0.321    -0.099     0.200
     0.315    -0.065     0.200
     0.316    -0.103     0.200
     0.316     0.244     0.200
     0.332     0.303     0.200
     0.332     0.893     0.200
     0.719    -0.736     0.200
     0.696    -0.124     0.200
     0.885    -0.439     0.200
     0.815     2.362     0.200
     0.777    -0.196     0.200
     0.776    -0.477     0.200
     0.883     2.675     0.200
     0.293     0.117     0.200
     0.293     0.065     0.200
     0.339     0.440     0.200
     0.339     1.190     0.200
     0.339     0.639     0.200
     0.381     0.070     0.200
     0.381     0.543     0.200
     0.381    -0.059     0.200
     0.644    -0.391     0.200
     0.716    -0.280     0.200
     0.730    -0.491     0.200
     0.745    -0.361     0.200
     0.767     1.868     0.200
     0.863     0.919     0.200
     0.918     1.159     0.200
     0.941    -0.887     0.200
     0.941    -0.137     0.200
     0.941     0.004     0.200
     0.178     0.497     0.200
     0.178     0.298     0.200
     0.178     0.727     0.200
     0.442     0.265     0.200
     0.468    -0.144     0.200
     0.469    -0.225     0.200
     0.540    -0.246     0.200
     0.572    -0.418     0.200
     0.562    -0.289     0.200
     0.562    -0.398     0.200
     0.712    -0.509     0.200
     0.873     1.541     0.200
     0.873     1.139     0.200
     0.879     2.131     0.200
     0.926     0.181     0.200
     0.926     0.709     0.200
     0.997     0.633     0.200
     0.997    -0.039     0.200
     0.184     0.762     0.200
     0.184     0.391     0.200
     0.184     0.922     0.200
     0.469     0.013     0.200
     0.470     0.288     0.200
     0.470    -0.079     0.200
     0.456    -0.257     0.200
     0.456     0.325     0.200
     0.456     0.844     0.200
     0.526    -0.633     0.200
     0.526    -0.442     0.200
     0.526    -0.153     0.200
     0.562    -0.198     0.200
     0.562     0.431     0.200
     0.565    -0.160     0.200
     0.565    -0.711     0.200
     0.699     0.448     0.200
     0.867     1.939     0.200
     0.861     1.053     0.200
     0.861     1.494     0.200
     0.868     1.922     0.200
     0.939    -1.003     0.200
     0.939    -0.350     0.200
     0.993    -0.289     0.200
     0.993    -0.738     0.200
     0.181     0.691     0.200
     0.452     0.134     0.200
     0.452     0.013     0.200
     0.471    -0.115     0.200
     0.471    -0.502     0.200
     0.530    -0.124     0.200
     0.563    -0.125     0.200
     0.564    -0.103     0.200
     0.870     1.142     0.200
     0.935    -0.723     0.200
     0.935    -0.153     0.200
     0.935    -0.052     0.200
     0.935    -1.372     0.200
     0.993    -0.605     0.200
     0.183     0.378     0.200
     0.183     0.878     0.200
     0.450     0.662     0.200
     0.450    -0.108     0.200
     0.467     0.054     0.200
     0.468     0.184     0.200
     0.468    -0.097     0.200
     0.532    -0.377     0.200
     0.532    -0.494     0.200
     0.565    -0.334     0.200
     0.567    -0.285     0.200
     0.703    -0.304     0.200
     0.865     1.203     0.200
     0.871     2.011     0.200
     0.934     0.038     0.200
     0.934     0.449     0.200
     0.934    -0.860     0.200
     0.996    -0.273     0.200
     0.447     0.221     0.200
     0.447    -0.021     0.200
     0.476    -0.041     0.200
     0.535    -0.419     0.200
     0.555    -0.153     0.200
     0.564    -0.204     0.200
     0.879     2.138     0.200
     0.927    -0.386     0.200
     0.927    -0.835     0.200
     0.989     0.035     0.200
     0.989    -0.734     0.200
     0.183     0.157     0.200
     0.183     0.677     0.200
     0.453     0.624     0.200
     0.453    -0.165     0.200
     0.469    -0.258     0.200
     0.565    -0.417     0.200
     0.528    -0.369     0.200
     0.564    -0.156     0.200
     0.937     0.024     0.200
     0.937    -0.175     0.200
     0.980     0.346     0.200
     0.994    -0.471     0.200
     0.191     0.816     0.200
     0.471     0.182     0.200
     0.473     0.137     0.200
     0.510     0.389     0.200
     0.550     0.047     0.200
     0.567    -0.178     0.200
     0.686    -0.295     0.200
     0.954    -1.521     0.200
     0.954    -1.122     0.200
     0.964     2.339     0.200
     0.986    -0.052     0.200
     0.183     0.906     0.200
     0.458     0.091     0.200
     0.458    -0.038     0.200
     0.471     0.263     0.200
     0.471    -0.057     0.200
     0.524    -0.268     0.200
     0.560     0.334     0.200
     0.563    -0.450     0.200
     0.698    -0.804     0.200
     0.698    -0.144     0.200
     0.860     1.091     0.200
     0.940    -0.741     0.200
     0.991     0.028     0.200
     0.183     0.423     0.200
     0.183     0.110     0.200
     0.183     0.610     0.200
     0.456    -0.249     0.200
     0.456    -0.011     0.200
     0.456     0.572     0.200
     0.471    -0.118     0.200
     0.471    -0.180     0.200
     0.525    -0.258     0.200
     0.525    -0.450     0.200
     0.561    -0.603     0.200
     0.561     0.045     0.200
     0.561     0.307     0.200
     0.563    -0.270     0.200
     0.563    -0.922     0.200
     0.700    -0.706     0.200
     0.861     1.559     0.200
     0.869     2.008     0.200
     0.939    -0.953     0.200
     0.939     0.035     0.200
     0.939     0.426     0.200
     0.991    -0.074     0.200
     0.183     0.454     0.200
     0.450    -0.062     0.200
     0.466     0.123     0.200
     0.467     0.501     0.200
     0.467     0.602     0.200
     0.532     0.041     0.200
     0.532    -0.389     0.200
     0.566    -0.352     0.200
     0.566    -0.481     0.200
     0.568    -0.537     0.200
     0.703     0.587     0.200
     0.703    -0.995     0.200
     0.865     1.432     0.200
     0.871     1.714     0.200
     0.868     1.139     0.200
     0.934    -0.067     0.200
     0.934    -0.567     0.200
     0.996    -0.102     0.200
     0.996    -0.590     0.200
     0.181    -0.030     0.200
     0.181     0.800     0.200
     0.181     1.220     0.200
     0.445     0.278     0.200
     0.467     0.230     0.200
     0.571    -0.797     0.200
     0.571     0.133     0.200
     0.565    -0.551     0.200
     0.929     0.075     0.200
     0.184     0.554     0.200
     0.184     0.925     0.200
     0.447     0.168     0.200
     0.465    -0.315     0.200
     0.567    -0.435     0.200
     0.534    -0.256     0.200
     0.571    -0.460     0.200
     0.933    -0.562     0.200
     0.933    -0.431     0.200
     0.999    -0.077     0.200
     0.195     0.270     0.200
     0.467    -0.318     0.200
     0.467    -0.049     0.200
     0.465    -0.359     0.200
     0.514    -1.045     0.200
     0.557    -0.473     0.200
     0.685    -0.413     0.200
     0.953    -0.248     0.200
     0.953    -0.650     0.200
     0.947     1.708     0.200
     0.174    -0.046     0.200
     0.174     0.423     0.200
     0.452    -0.039     0.200
     0.452     1.074     0.200
     0.452    -0.617     0.200
     0.477    -0.199     0.200
     0.531    -0.165     0.200
     0.556    -0.554     0.200
     0.556     0.106     0.200
     0.561    -0.436     0.200
     0.931    -0.302     0.200
     0.931    -0.564     0.200
     0.987    -0.289     0.200
     0.070     0.380     0.200
     0.070     0.610     0.200
     0.487     0.313     0.200
     0.487    -0.476     0.200
     0.504     0.200     0.200
     0.628    -0.119     0.200
     0.701    -0.429     0.200
     0.814    -0.704     0.200
     0.812     0.069     0.200
     0.135    -0.072     0.200
     0.135     0.377     0.200
     0.437    -0.109     0.200
     0.437     0.020     0.200
     0.508     0.103     0.200
     0.508     0.713     0.200
     0.552    -0.203     0.200
     0.552    -0.015     0.200
     0.552     0.528     0.200
     0.556    -0.480     0.200
     0.900    -0.601     0.200
     0.900     0.879     0.200
     0.965    -0.089     0.200
     0.180     0.400     0.200
     0.458     0.479     0.200
     0.458     0.319     0.200
     0.475    -0.215     0.200
     0.475    -0.156     0.200
     0.475    -0.455     0.200
     0.524    -0.017     0.200
     0.524    -0.306     0.200
     0.560    -0.054     0.200
     0.560    -0.314     0.200
     0.557    -0.525     0.200
     0.700     0.739     0.200
     0.700    -0.972     0.200
     0.862     1.230     0.200
     0.872     1.887     0.200
     0.939    -0.231     0.200
     0.939    -0.632     0.200
     0.987    -0.205     0.200
     0.186     0.549     0.200
     0.186     0.069     0.200
     0.186     1.099     0.200
     0.466     0.158     0.200
     0.466     0.268     0.200
     0.473    -0.160     0.200
     0.474    -0.152     0.200
     0.516    -0.103     0.200
     0.516     0.107     0.200
     0.563    -0.219     0.200
     0.563    -0.469     0.200
     0.553    -0.460     0.200
     0.866     2.396     0.200
     0.863     1.161     0.200
     0.854     2.078     0.200
     0.947    -0.698     0.200
     0.947     0.302     0.200
     0.986    -0.392     0.200
     0.187     0.171     0.200
     0.187    -0.508     0.200
     0.187     0.402     0.200
     0.187     0.862     0.200
     0.466     0.008     0.200
     0.472    -0.169     0.200
     0.473     0.049     0.200
     0.473    -0.231     0.200
     0.515    -0.505     0.200
     0.553    -0.659     0.200
     0.564    -0.401     0.200
     0.691    -0.275     0.200
     0.853     1.962     0.200
     0.853     0.712     0.200
     0.948    -0.133     0.200
     0.948    -0.243     0.200
     0.948     0.317     0.200
     0.987     0.459     0.200
     0.186     0.737     0.200
     0.474    -0.114     0.200
     0.478    -0.179     0.200
     0.479     0.239     0.200
     0.479    -0.691     0.200
     0.508     0.187     0.200
     0.545    -0.361     0.200
     0.561    -0.226     0.200
     0.687     0.281     0.200
     0.687     0.022     0.200
     0.850     1.405     0.200
     0.850     1.245     0.200
     0.860     1.668     0.200
     0.866     1.934     0.200
     0.866     0.380     0.200
     0.953    -1.156     0.200
     0.953    -1.627     0.200
     0.980    -0.600     0.200
     0.966    -0.403     0.200
     0.966     0.327     0.200
     0.178     0.228     0.200
     0.461     0.087     0.200
     0.479    -0.140     0.200
     0.479    -0.428     0.200
     0.479    -0.810     0.200
     0.521    -0.686     0.200
     0.553    -0.978     0.200
     0.556    -0.536     0.200
     0.700     0.413     0.200
     0.700    -0.791     0.200
     0.862     1.517     0.200
     0.871     2.370     0.200
     0.874     2.307     0.200
     0.874     2.365     0.200
     0.940    -0.437     0.200
     0.983     0.016     0.200
     0.180     0.556     0.200
     0.180     0.227     0.200
     0.474    -0.415     0.200
     0.474    -0.595     0.200
     0.485     0.050     0.200
     0.486    -0.273     0.200
     0.486    -0.644     0.200
     0.509    -0.003     0.200
     0.541    -0.346     0.200
     0.554    -0.439     0.200
     0.554    -0.068     0.200
     0.691    -0.084     0.200
     0.691    -0.826     0.200
     0.854     1.689     0.200
     0.872     1.970     0.200
     0.921     2.377     0.200
     0.974    -0.483     0.200
     0.970     0.564     0.200
     0.181     0.739     0.200
     0.454     0.189     0.200
     0.454    -0.250     0.200
     0.470     0.123     0.200
     0.471     0.090     0.200
     0.471     0.260     0.200
     0.528     0.208     0.200
     0.562     0.190     0.200
     0.562    -0.150     0.200
     0.563     0.033     0.200
     0.864     1.509     0.200
     0.870     1.849     0.200
     0.870     1.546     0.200
     0.871     2.253     0.200
     0.936    -0.899     0.200
     0.936    -1.940     0.200
     0.930     2.464     0.200
     0.992    -0.425     0.200
     0.992    -0.226     0.200
     0.177     0.349     0.200
     0.177     0.038     0.200
     0.177     0.587     0.200
     0.450     0.477     0.200
     0.450     0.307     0.200
     0.473    -0.236     0.200
     0.474    -0.270     0.200
     0.474     0.400     0.200
     0.474    -0.408     0.200
     0.559    -0.622     0.200
     0.559    -0.333     0.200
     0.559    -0.193     0.200
     0.532    -0.454     0.200
     0.563    -0.557     0.200
     0.707    -0.197     0.200
     0.869     1.720     0.200
     0.875     2.622     0.200
     0.876     1.797     0.200
     0.932    -0.423     0.200
     0.932    -0.223     0.200
     0.990    -0.044     0.200
     0.990    -0.544     0.200
     0.181     0.159     0.200
     0.181     0.870     0.200
     0.460     0.059     0.200
     0.460    -0.429     0.200
     0.474    -0.164     0.200
     0.475    -0.174     0.200
     0.522    -0.477     0.200
     0.556    -0.572     0.200
     0.560    -0.376     0.200
     0.698    -0.887     0.200
     0.861     1.153     0.200
     0.869     2.599     0.200
     0.941    -0.283     0.200
     0.941    -0.142     0.200
     0.987    -0.436     0.200
     0.987    -0.026     0.200
     0.182     0.447     0.200
     0.182     0.728     0.200
     0.465     0.127     0.200
     0.465     0.365     0.200
     0.477    -0.129     0.200
     0.477    -0.374     0.200
     0.517    -0.601     0.200
     0.517    -1.043     0.200
     0.560    -0.480     0.200
     0.560    -0.132     0.200
     0.552    -0.607     0.200
     0.695     0.367     0.200
     0.867     2.351     0.200
     0.945    -0.096     0.200
     0.945    -0.213     0.200
     0.974     0.447     0.200
     0.983    -0.162     0.200
     0.182    -0.132     0.200
     0.182    -0.234     0.200
     0.182     0.759     0.200
     0.465     0.026     0.200
     0.465     0.397     0.200
     0.477    -0.080     0.200
     0.477    -0.332     0.200
     0.517    -0.594     0.200
     0.551    -0.624     0.200
     0.560    -0.308     0.200
     0.560    -0.550     0.200
     0.695    -0.447     0.200
     0.857     1.107     0.200
     0.866     2.376     0.200
     0.869     2.306     0.200
     0.945    -0.223     0.200
     0.945    -0.035     0.200
     0.945     0.855     0.200
     0.945    -1.266     0.200
     0.983    -0.437     0.200
     0.105    -1.252     0.200
     0.422    -1.040     0.200
     0.422     0.531     0.200
     0.487     0.195     0.200
     0.487     0.586     0.200
     0.556     0.103     0.200
     0.556     1.088     0.200
     0.583    -0.291     0.200
     0.636    -0.249     0.200
     0.636    -0.148     0.200
     0.636     0.587     0.200
     0.636     0.696     0.200
     0.728    -0.091     0.200
     0.732    -0.617     0.200
     0.732    -0.344     0.200
     0.740    -0.516     0.200
     0.758    -0.563     0.200
     0.758    -0.189     0.200
     0.801    -0.201     0.200
     0.840    -0.551     0.200
     0.856    -0.587     0.200
     0.869     0.240     0.200
     0.911    -0.594     0.200
     0.940    -0.274     0.200
     0.973     0.293     0.200
     0.192     0.068     0.200
     0.192     0.849     0.200
     0.475    -0.001     0.200
     0.474     0.114     0.200
     0.474     0.423     0.200
     0.506     0.230     0.200
     0.547    -0.211     0.200
     0.566    -0.210     0.200
     0.957    -1.325     0.200
     0.957    -1.177     0.200
     0.984    -0.508     0.200
     0.175     0.341     0.200
     0.175     0.560     0.200
     0.456     0.239     0.200
     0.456     0.040     0.200
     0.478    -0.116     0.200
     0.478    -0.298     0.200
     0.478     0.034     0.200
     0.478     0.292     0.200
     0.526    -0.600     0.200
     0.526    -0.412     0.200
     0.555    -0.407     0.200
     0.555    -0.536     0.200
     0.704     0.237     0.200
     0.867     1.334     0.200
     0.876     2.156     0.200
     0.933     0.683     0.200
     0.935    -0.059     0.200
     0.935    -0.208     0.200
     0.984    -0.169     0.200
     0.984    -0.059     0.200
     0.183    -0.010     0.200
     0.183     1.053     0.200
     0.471     0.242     0.200
     0.480    -0.143     0.200
     0.481    -0.219     0.200
     0.481     0.196     0.200
     0.511     0.406     0.200
     0.511     0.054     0.200
     0.546    -0.294     0.200
     0.546     0.238     0.200
     0.558    -0.453     0.200
     0.558    -0.281     0.200
     0.691     0.626     0.200
     0.691    -0.788     0.200
     0.864     2.193     0.200
     0.869     2.363     0.200
     0.921     2.127     0.200
     0.949    -0.672     0.200
     0.949    -0.110     0.200
     0.949     0.617     0.200
     0.979    -0.341     0.200
     0.464    -0.075     0.200
     0.565    -0.969     0.200
     0.471     0.046     0.200
     0.472     0.032     0.200
     0.518     0.094     0.200
     0.863     1.260     0.200
     0.865     1.692     0.200
     0.865     1.699     0.200
     0.921     2.211     0.200
     0.340     0.427     0.200
     0.267    -0.037     0.200
     0.267     0.264     0.200
     0.468    -0.337     0.200
     0.468    -0.439     0.200
     0.468     0.131     0.200
     0.651    -0.493     0.200
     0.707    -1.093     0.200
     0.707    -0.984     0.200
     0.707     0.657     0.200
     0.803     0.051     0.200
     0.804    -0.277     0.200
     0.798    -0.467     0.200
     0.798    -0.365     0.200
     0.918     0.001     0.200
     0.918     0.263     0.200
     0.994     0.685     0.200
     0.339     0.050     0.200
     0.339     0.320     0.200
     0.202    -0.264     0.200
     0.439    -0.323     0.200
     0.366    -0.045     0.200
     0.665    -0.403     0.200
     0.772    -0.222     0.200
     0.797     0.814     0.200
     0.888     0.608     0.200
     0.956    -0.106     0.200
     0.943    -0.429     0.200
     0.955     0.428     0.200
     0.955    -0.312     0.200
     0.186    -0.124     0.200
     0.186     1.028     0.200
     0.186     0.345     0.200
     0.476    -0.096     0.200
     0.477     0.140     0.200
     0.477     0.530     0.200
     0.470     0.632     0.200
     0.470     0.281     0.200
     0.512    -0.534     0.200
     0.512    -0.253     0.200
     0.549    -0.462     0.200
     0.549     0.128     0.200
     0.549    -0.603     0.200
     0.562    -0.607     0.200
     0.690    -0.459     0.200
     0.690    -0.810     0.200
     0.690     0.901     0.200
     0.862     2.419     0.200
     0.866     2.569     0.200
     0.971    -0.385     0.200
     0.983    -0.002     0.200
     0.191     0.465     0.200
     0.191     0.895     0.200
     0.476    -0.079     0.200
     0.477    -0.132     0.200
     0.477     0.309     0.200
     0.478    -0.127     0.200
     0.504    -0.060     0.200
     0.544    -0.331     0.200
     0.565    -0.576     0.200
     0.565    -0.076     0.200
     0.682    -0.332     0.200
     0.855     1.911     0.200
     0.911     1.969     0.200
     0.968    -0.045     0.200
     0.981    -0.348     0.200
     0.186     0.070     0.200
     0.186     1.269     0.200
     0.186     0.371     0.200
     0.468     0.058     0.200
     0.468     0.839     0.200
     0.475    -0.152     0.200
     0.476    -0.296     0.200
     0.514    -0.395     0.200
     0.514    -0.594     0.200
     0.550    -0.705     0.200
     0.562    -0.418     0.200
     0.562    -0.266     0.200
     0.691    -0.329     0.200
     0.853     2.025     0.200
     0.973     0.046     0.200
     0.984     0.066     0.200
     0.984    -0.708     0.200
     0.275    -0.373     0.200
     0.275     0.507     0.200
     0.264    -0.124     0.200
     0.264     0.246     0.200
     0.264     0.366     0.200
     0.354    -0.167     0.200
     0.354    -0.027     0.200
     0.456    -0.161     0.200
     0.456    -0.001     0.200
     0.650    -0.123     0.200
     0.650     0.028     0.200
     0.662    -0.042     0.200
     0.662    -0.262     0.200
     0.704    -0.727     0.200
     0.704     0.032     0.200
     0.783     0.266     0.200
     0.791    -0.129     0.200
     0.792    -0.128     0.200
     0.921     0.342     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.967     1.264     0.200
     0.944    -0.391     0.200
     0.930    -0.050     0.200
     0.935    -0.500     0.200
     0.890    -1.315     0.200
     0.953    -1.900     0.200
     0.953    -1.541     0.200
     0.903    -0.166     0.200
     0.975    -0.319     0.200
     0.959    -1.000     0.200
     0.923    -2.025     0.200
     0.944    -1.955     0.200
     0.914    -1.570     0.200
     0.959     0.637     0.200
     0.917    -0.910     0.200
     0.962    -1.148     0.200
     0.960    -0.386     0.200
     0.921    -0.060     0.200
     0.982    -1.085     0.200
     0.977    -1.138     0.200
     0.999     0.083     0.200
     0.806    -0.420     0.200
     0.806     0.483     0.200
     0.919    -0.904     0.200
     0.919    -0.724     0.200
     0.748    -1.359     0.200
     0.748    -1.125     0.200
     0.879    -2.036     0.200
     0.904    -1.103     0.200
     0.904    -0.166     0.200
     0.907     1.396     0.200
     0.907    -0.932     0.200
     0.920    -0.817     0.200
     0.965     0.168     0.200
     0.985    -0.024     0.200
     0.930    -1.920     0.200
     0.957    -0.944     0.200
     0.979    -1.493     0.200
     1.000    -0.374     0.200
     0.978    -0.080     0.200
     0.999    -0.083     0.200
     0.833    -0.496     0.200
     0.879    -1.573     0.200
     0.989    -0.358     0.200
     0.962    -1.005     0.200
     0.962    -1.015     0.200
     0.977    -0.223     0.200
     0.906    -0.588     0.200
     0.943    -0.043     0.200
     0.974    -0.182     0.200
     0.995    -0.467     0.200
     0.839     0.658     0.200
     0.866    -0.919     0.200
     0.938    -0.555     0.200
     0.955     0.014     0.200
     0.978    -0.843     0.200
     0.986     0.473     0.200
     0.987     0.866     0.200
     0.944    -0.765     0.200
     0.943    -1.610     0.200
     0.948    -0.396     0.200
     0.948    -0.311     0.200
     0.889    -0.683     0.200
     0.945     0.063     0.200
     0.930    -0.707     0.200
     0.988    -1.443     0.200
     0.965    -1.849     0.200
     0.983    -1.249     0.200
     0.983    -0.847     0.200
     0.998    -1.946     0.200
     0.947    -0.407     0.200
     0.967    -2.234     0.200
     0.951    -1.434     0.200
     0.951    -0.563     0.200
     0.961     0.362     0.200
     0.882    -0.599     0.200
     0.888    -0.612     0.200
     0.936    -1.294     0.200
     0.937    -0.987     0.200
     0.957    -1.556     0.200
     0.966    -1.945     0.200
     0.965    -0.517     0.200
     0.985    -2.084     0.200
     0.897    -1.767     0.200
     0.943    -0.621     0.200
     0.947    -1.725     0.200
     0.870    -1.131     0.200
     0.919    -0.209     0.200
     0.890    -0.603     0.200
     0.917    -0.623     0.200
     0.936    -0.238     0.200
     0.959    -1.624     0.200
     0.978    -2.037     0.200
     0.928    -0.805     0.200
     0.829    -1.698     0.200
     0.889    -0.582     0.200
     0.959    -0.820     0.200
     0.988     0.571     0.200
     0.988    -0.726     0.200
     0.989     0.179     0.200
     0.957    -2.105     0.200
     0.939    -1.446     0.200
     0.964    -1.188     0.200
     0.982    -1.154     0.200
     0.982    -0.564     0.200
     0.896    -2.213     0.200
     0.924    -1.031     0.200
     0.991     0.304     0.200
     0.987    -1.158     0.200
     0.988    -1.606     0.200
     0.985    -1.733     0.200
     0.985    -0.303     0.200
     0.781    -2.004     0.200
     0.781    -0.904     0.200
     0.927    -0.786     0.200
     0.973     0.883     0.200
     0.934    -2.302     0.200
     0.897    -0.341     0.200
     0.890    -0.761     0.200
     0.977    -1.868     0.200
     0.973     0.474     0.200
     0.973    -0.955     0.200
     0.986    -1.012     0.200
     0.927    -0.592     0.200
     0.950    -0.104     0.200
     0.923    -1.391     0.200
     0.945    -1.594     0.200
     0.993    -0.806     0.200
     0.993    -0.357     0.200
     0.995    -1.821     0.200
     0.978    -1.468     0.200
     0.900    -1.683     0.200
     0.916     0.805     0.200
     0.978    -1.105     0.200
     0.979    -1.521     0.200
     1.000    -0.473     0.200
     0.996    -1.439     0.200
     0.996    -1.939     0.200
     0.923    -1.681     0.200
     0.977    -0.451     0.200
     0.995    -0.425     0.200
     0.995    -0.042     0.200
     0.939    -0.497     0.200
     0.927    -1.053     0.200
     0.978    -0.986     0.200
     0.978    -1.908     0.200
     0.982    -0.662     0.200
     0.983    -0.559     0.200
     0.940    -1.808     0.200
     0.991    -0.970     0.200
     0.928    -1.309     0.200
     0.939    -0.840     0.200
     0.962    -0.541     0.200
     0.979    -1.755     0.200
     0.979    -1.907     0.200
     0.931    -0.683     0.200
     0.983    -0.515     0.200
     0.983    -0.055     0.200
     0.929    -2.040     0.200
     0.987     0.155     0.200
     0.987    -2.056     0.200
     0.998    -0.808     0.200
     0.998     0.772     0.200
     0.984    -1.227     0.200
     0.964     0.117     0.200
     0.964     0.265     0.200
     0.987    -0.517     0.200
     0.987     1.214     0.200
     0.929    -1.002     0.200
     0.979    -1.497     0.200
     0.979    -0.958     0.200
     0.921    -0.438     0.200
     0.954     0.023     0.200
     0.971    -0.685     0.200
     0.971    -0.565     0.200
     0.986     0.771     0.200
     0.970    -2.086     0.200
     0.929    -0.659     0.200
     0.979    -0.873     0.200
     0.979    -1.897     0.200
     0.970    -1.487     0.200
     0.981    -1.965     0.200
     0.981    -0.535     0.200
     0.935    -0.976     0.200
     0.986    -0.887     0.200
     0.927    -0.764     0.200
     0.977    -0.800     0.200
     0.977    -0.608     0.200
     0.924    -0.612     0.200
     0.924    -1.169     0.200
     0.974    -1.859     0.200
     0.974    -1.520     0.200
     0.961    -1.320     0.200
     0.935    -2.150     0.200
     0.979    -1.390     0.200
     0.972    -1.187     0.200
     0.963    -2.143     0.200
     0.999    -1.019     0.200
     0.951    -0.685     0.200
     0.968    -0.449     0.200
     0.971    -2.176     0.200
     0.983    -1.450     0.200
     0.984    -2.072     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00   -0.012
 0.80   -0.012
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00    0.0
 0.80    0.0
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -1.3
 0.80   -1.3
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-0.8)
     0.050     7.000   Pg = red x; average =  -0.0 (solid red line)
     0.050    -7.500   Sg = red circles; average =   0.0 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -1.3 (dashed green line)
EOF
gmt end
