#!/bin/bash
gmt begin alberchigos1.34_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic alberchigos1.34'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.470
   135.500     1.552
   136.000     1.637
   136.500     1.725
   137.000     1.817
   137.500     1.912
   138.000     2.010
   138.500     2.111
   139.000     2.216
   139.500     2.325
   140.000     2.438
   140.500     2.555
   141.000     2.676
   141.500     2.802
   142.000     2.932
   142.500     3.067
   143.000     3.207
   143.500     3.352
   144.000     3.502
   144.500     3.659
   145.000     3.821
   145.500     3.989
   146.000     4.164
   146.500     4.346
   147.000     4.534
   147.500     4.730
   148.000     4.933
   148.500     5.144
   149.000     5.363
   149.500     5.591
   150.000     5.830
   150.500     6.078
   151.000     6.336
   151.500     6.604
   152.000     6.883
   152.500     7.172
   153.000     7.471
   153.500     7.780
   154.000     8.100
   154.500     8.431
   155.000     8.773
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.691
   145.500     0.272
   146.000     1.298
   146.500     2.367
   147.000     3.471
   147.500     4.605
   148.000     5.766
   148.500     6.952
   149.000     8.162
   149.500     9.394
   150.000    10.649
   150.500    11.925
   151.000    13.221
   151.500    14.538
   152.000    15.873
   152.500    17.226
   153.000    18.597
   153.500    19.986
   154.000    21.393
   154.500    22.817
   155.000    24.259
   155.500    25.717
   156.000    27.193
   156.500    28.685
   157.000    30.193
   157.500    31.719
   158.000    33.261
   158.500    34.819
   159.000    36.394
   159.500    37.986
   160.000    39.594
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.693
   145.500     0.073
   146.000     0.767
   146.500     1.409
   147.000     2.008
   147.500     2.568
   148.000     3.093
   148.500     3.585
   149.000     4.052
   149.500     4.498
   150.000     4.928
   150.500     5.345
   151.000     5.752
   151.500     6.149
   152.000     6.537
   152.500     6.919
   153.000     7.294
   153.500     7.666
   154.000     8.034
   154.500     8.401
   155.000     8.766
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   145.790    -0.153     0.200
   145.339     0.738     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   146.213     1.534     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   145.620     2.076     0.200
   146.361     4.614     0.200
   146.143     2.635     0.200
   146.143     2.800     0.200
   143.866     2.897     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
