#!/bin/bash
gmt begin alberchigos1.34_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P alberchigos1.34'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.713
    79.000     8.538
    80.000     7.447
    81.000     6.441
    82.000     5.522
    83.000     4.687
    84.000     3.936
    85.000     3.272
    86.000     2.694
    87.000     2.194
    88.000     1.798
    89.000     1.498
    90.000     1.240
    91.000     1.013
    92.000     0.812
    93.000     0.630
    94.000     0.465
    95.000     0.320
    96.000     0.200
    97.000     0.107
    98.000     0.041
    99.000     0.006
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    14.183     5.901     0.200
    14.973     4.502     0.200
    15.160     3.559     0.200
    15.503     4.814     0.200
    15.589     2.504     0.200
    15.733     4.425     0.200
    15.978     3.564     0.200
    16.110     4.298     0.200
    16.162     3.496     0.200
    16.178     3.507     0.200
    16.264     3.800     0.200
    16.495     3.127     0.200
    16.563     2.982     0.200
    16.990     4.215     0.200
    17.387     2.535     0.200
    17.639     1.710     0.200
    21.942     3.195     0.200
    22.325     3.847     0.200
    22.797     3.015     0.200
    22.797     3.515     0.200
    23.835     3.534     0.200
    27.508     2.105     0.200
    28.363     1.610     0.200
    28.363     2.310     0.200
    29.257     2.984     0.200
    29.512     6.521     0.200
    33.942     2.472     0.200
    33.942     3.272     0.200
    34.246     6.338     0.200
    36.568     6.042     0.200
    36.705     1.927     0.200
    37.670     2.008     0.200
    37.950     2.142     0.200
    38.456     2.164     0.200
    38.456     2.575     0.200
    40.104     1.046     0.200
    41.079     1.702     0.200
    43.550     0.931     0.200
    44.584     3.531     0.200
    50.703     1.125     0.200
    66.532     6.849     0.200
    68.449     2.732     0.200
    71.533     7.587     0.200
    81.353    -0.876     0.200
    81.353    -0.576     0.200
    84.096     6.565     0.200
    84.583     6.796     0.200
    84.623     6.893     0.200
    84.658     6.717     0.200
    84.685     6.376     0.200
    84.873     6.729     0.200
    90.347     1.570     0.200
    17.037     5.046     0.200
    23.632     1.110     0.200
    30.748     1.595     0.200
    38.017     2.192     0.200
    38.221     0.269     0.200
    44.591     1.690     0.200
    14.753     6.801     0.200
    15.753     2.947     0.200
    24.024     0.842     0.200
    28.914     2.843     0.200
    31.260     1.984     0.200
    37.362     2.420     0.200
    38.728     2.003     0.200
    41.723     2.156     0.200
    14.521     4.494     0.200
    14.715     5.388     0.200
    14.721     5.490     0.200
    15.754     4.651     0.200
    16.173     3.498     0.200
    16.279     2.971     0.200
    16.686     3.141     0.200
    16.843     4.433     0.200
    17.000     3.581     0.200
    21.240     3.624     0.200
    23.994     2.270     0.200
    28.886     3.137     0.200
    29.260     3.118     0.200
    37.338     3.779     0.200
    38.507     2.216     0.200
    38.702     1.676     0.200
    41.583     3.578     0.200
    41.698     3.434     0.200
    67.197     1.237     0.200
    78.508     2.129     0.200
    14.142     6.344     0.200
    30.628     2.447     0.200
    38.100     3.972     0.200
    14.799     7.763     0.200
    16.027     7.917     0.200
    16.147     6.480     0.200
    16.251     3.529     0.200
    16.342     6.735     0.200
    16.733     7.188     0.200
    16.778     6.603     0.200
    16.809     4.655     0.200
    16.921     3.624     0.200
    17.060     1.907     0.200
    22.216     2.426     0.200
    24.058     0.936     0.200
    31.308     2.153     0.200
    38.778     2.366     0.200
    41.773     3.036     0.200
    82.579     1.404     0.200
    85.973     0.600     0.200
    16.366     2.282     0.200
    16.535     4.138     0.200
    16.679     3.007     0.200
    16.679     5.397     0.200
    16.846     3.615     0.200
    20.952     0.782     0.200
    22.518     5.214     0.200
    28.580     3.596     0.200
    30.810     2.369     0.200
    30.906     2.315     0.200
    38.192     2.642     0.200
    38.406     3.082     0.200
    16.408     4.616     0.200
    37.989     1.523     0.200
    16.425     4.618     0.200
    17.302     3.007     0.200
    19.202     1.326     0.200
    23.861     1.721     0.200
    28.199     0.819     0.200
    35.344     2.495     0.200
    37.861     2.137     0.200
    83.164     0.161     0.200
    85.973     2.062     0.200
    30.719     1.237     0.200
    28.285     0.396     0.200
    30.755     0.825     0.200
    86.085    -0.797     0.200
    14.340     8.977     0.200
    16.723     3.739     0.200
    21.465     3.546     0.200
    38.264     1.405     0.200
    14.262     9.696     0.200
    14.733     6.528     0.200
    15.584     4.529     0.200
    15.723     4.609     0.200
    17.002     2.662     0.200
    17.002     3.709     0.200
    17.288     3.948     0.200
    17.319     4.475     0.200
    17.808     4.057     0.200
    31.234     2.057     0.200
    31.234     2.065     0.200
    38.690     0.440     0.200
    38.690     0.440     0.200
    40.078     3.347     0.200
    92.673     4.312     0.200
    14.270     5.014     0.200
    14.349     4.745     0.200
    14.362     5.183     0.200
    14.363     5.418     0.200
    14.429     4.422     0.200
    14.555     6.235     0.200
    14.737     4.099     0.200
    14.849     4.192     0.200
    14.899     3.881     0.200
    14.901     5.101     0.200
    14.920     4.580     0.200
    14.949     4.874     0.200
    14.990     3.906     0.200
    15.090     3.927     0.200
    15.130     4.205     0.200
    15.178     3.628     0.200
    15.333     4.599     0.200
    15.412     3.858     0.200
    15.455     4.791     0.200
    15.476     4.350     0.200
    15.476     3.238     0.200
    15.588     4.652     0.200
    15.636     4.356     0.200
    15.726     4.466     0.200
    15.792     3.220     0.200
    15.909     4.005     0.200
    15.909     4.232     0.200
    16.015     3.093     0.200
    16.054     3.692     0.200
    16.321     3.300     0.200
    16.484     2.983     0.200
    16.567     3.031     0.200
    17.003     3.536     0.200
    17.121     3.588     0.200
    17.317     3.402     0.200
    17.324     3.552     0.200
    17.324     3.048     0.200
    17.328     4.173     0.200
    17.431     3.562     0.200
    17.449     2.253     0.200
    17.915     2.949     0.200
    18.021     1.975     0.200
    18.069     1.263     0.200
    18.096     5.457     0.200
    18.100     3.283     0.200
    18.347     5.269     0.200
    18.362     4.929     0.200
    18.394     2.991     0.200
    21.567     1.886     0.200
    21.995     2.776     0.200
    23.578     3.176     0.200
    23.617     2.308     0.200
    38.688     3.947     0.200
    65.719     1.688     0.200
    95.999    -0.762     0.200
    15.582     5.200     0.200
    15.720     3.058     0.200
    14.234     7.308     0.200
    14.228     5.606     0.200
    14.276     5.470     0.200
    14.306     5.623     0.200
    14.367     5.501     0.200
    14.633     6.204     0.200
    14.648     5.919     0.200
    14.709     5.042     0.200
    14.709     8.894     0.200
    14.745     5.855     0.200
    14.908     4.599     0.200
    14.925     6.221     0.200
    15.134     4.661     0.200
    15.340     3.507     0.200
    15.595     4.534     0.200
    15.595     4.803     0.200
    15.567     4.010     0.200
    15.734     4.394     0.200
    15.768     8.619     0.200
    16.170     7.439     0.200
    16.431     7.731     0.200
    16.575     3.818     0.200
    16.624     4.950     0.200
    17.010     4.213     0.200
    17.010     2.993     0.200
    17.010     1.838     0.200
    17.037     1.836     0.200
    17.295     4.189     0.200
    17.332     4.096     0.200
    17.700     5.418     0.200
    18.029     4.599     0.200
    18.102     4.424     0.200
    18.171     4.148     0.200
    18.338     4.568     0.200
    21.124     3.773     0.200
    21.447     0.856     0.200
    21.575     1.600     0.200
    21.631     2.468     0.200
    22.003     5.374     0.200
    22.807     2.065     0.200
    23.578     0.677     0.200
    24.040     1.669     0.200
    26.898     0.697     0.200
    28.883     2.304     0.200
    38.509     1.586     0.200
    38.693     2.619     0.200
    14.283     6.592     0.200
    14.582     5.156     0.200
    14.754     4.608     0.200
    15.744     5.132     0.200
    15.796     3.364     0.200
    16.048     4.573     0.200
    16.585     4.266     0.200
    17.021     1.721     0.200
    14.234     7.642     0.200
    14.297     5.365     0.200
    14.304     5.229     0.200
    14.420     5.675     0.200
    14.595     6.337     0.200
    14.636     6.067     0.200
    14.699     7.200     0.200
    14.902     6.720     0.200
    15.163     4.618     0.200
    15.186     4.541     0.200
    15.394     4.588     0.200
    15.591     4.280     0.200
    15.591     4.873     0.200
    15.729     4.934     0.200
    15.922     5.477     0.200
    16.340     3.306     0.200
    17.009     3.306     0.200
    17.025     2.584     0.200
    17.025     2.916     0.200
    17.065     2.603     0.200
    18.315     5.744     0.200
    18.380     5.383     0.200
    18.807     1.178     0.200
    20.715     2.318     0.200
    21.111    -0.460     0.200
    21.998     4.938     0.200
    22.509     1.271     0.200
    22.894     1.193     0.200
    23.304     0.634     0.200
    23.357     0.768     0.200
    23.444     1.293     0.200
    23.959     0.578     0.200
    24.025     0.860     0.200
    24.304     0.877     0.200
    24.812     0.409     0.200
    38.510     1.556     0.200
    38.698     2.356     0.200
    39.207     2.208     0.200
    39.262     2.463     0.200
    39.573     1.946     0.200
    39.713     2.936     0.200
    96.012     0.434     0.200
    14.117     6.075     0.200
    14.694     5.840     0.200
    15.834     3.571     0.200
    15.834     6.641     0.200
    15.908     4.049     0.200
    16.161     3.312     0.200
    16.387     4.374     0.200
    16.870     4.915     0.200
    17.048     2.585     0.200
    17.958     2.051     0.200
    17.972     2.260     0.200
    18.066     2.000     0.200
    18.130     3.862     0.200
    18.193     2.449     0.200
    18.198     2.341     0.200
    18.369     2.135     0.200
    18.648    -0.453     0.200
    31.126     1.845     0.200
    36.849     1.062     0.200
    38.464     2.140     0.200
    95.721    -0.675     0.200
    17.017     3.773     0.200
    38.700     2.778     0.200
    14.276     6.316     0.200
    14.473    10.363     0.200
    14.732     6.077     0.200
    15.394     7.047     0.200
    15.494     5.216     0.200
    15.545     7.034     0.200
    15.597     4.587     0.200
    15.605     6.306     0.200
    15.775     7.634     0.200
    15.927     4.846     0.200
    16.167     8.000     0.200
    16.271     6.082     0.200
    16.427     7.334     0.200
    16.492     3.296     0.200
    16.576     4.294     0.200
    17.010     3.802     0.200
    17.140     4.278     0.200
    17.294     3.397     0.200
    17.335     4.300     0.200
    17.820     4.048     0.200
    22.004     4.318     0.200
    23.588     1.778     0.200
    24.047     0.635     0.200
    31.245     0.845     0.200
    38.508     2.186     0.200
    38.689     2.613     0.200
    94.305     1.255     0.200
    95.996     0.727     0.200
    31.245     1.006     0.200
    38.689     1.494     0.200
    38.691     1.422     0.200
    38.691     1.425     0.200
    14.355     5.759     0.200
    14.570     3.979     0.200
    15.514     8.270     0.200
    15.744     3.694     0.200
    16.501     2.579     0.200
    16.586     2.031     0.200
    16.632     1.248     0.200
    17.023     4.003     0.200
    17.023     3.589     0.200
    17.040     0.783     0.200
    17.310     4.289     0.200
    17.829     4.834     0.200
    24.039     1.583     0.200
    24.039     1.907     0.200
    31.256     1.505     0.200
    38.525     1.887     0.200
    38.711    -0.942     0.200
    38.711     2.718     0.200
    96.024    -0.634     0.200
    38.728     3.101     0.200
    31.274     0.344     0.200
    38.547     0.999     0.200
    38.737     1.105     0.200
    23.940    -0.271     0.200
    19.085    -1.872     0.200
    38.101     4.729     0.200
    14.082     6.222     0.200
    14.349     9.039     0.200
    14.817     3.726     0.200
    14.819     7.284     0.200
    17.037     5.051     0.200
    17.626     2.295     0.200
    21.072     6.056     0.200
    24.196     0.619     0.200
    28.858     0.523     0.200
    31.287     0.725     0.200
    38.505     2.227     0.200
    38.647     2.512     0.200
    45.747     4.903     0.200
    82.644     0.797     0.200
    95.905     1.735     0.200
    38.632     2.096     0.200
    14.305     4.821     0.200
    14.575     8.063     0.200
    14.604     4.502     0.200
    14.720     5.494     0.200
    14.804     4.340     0.200
    15.087     4.096     0.200
    15.244     3.665     0.200
    15.246     3.760     0.200
    15.388     4.944     0.200
    15.643     3.900     0.200
    15.727     2.671     0.200
    15.748     4.652     0.200
    16.137     4.154     0.200
    16.769     2.250     0.200
    17.029     3.227     0.200
    17.029     3.563     0.200
    17.091     3.122     0.200
    17.147     1.880     0.200
    17.179     3.700     0.200
    17.248     4.895     0.200
    17.295     2.154     0.200
    17.340     2.870     0.200
    17.399     2.757     0.200
    17.399     2.942     0.200
    17.411     3.487     0.200
    17.411     3.300     0.200
    17.516     2.500     0.200
    17.605     2.534     0.200
    17.644     3.190     0.200
    18.135     2.482     0.200
    18.135     4.439     0.200
    18.205     2.295     0.200
    18.939     0.387     0.200
    21.052     2.395     0.200
    21.263     2.304     0.200
    21.370     2.228     0.200
    21.370     2.863     0.200
    21.512     0.674     0.200
    21.614     3.513     0.200
    21.614     3.369     0.200
    22.478     1.282     0.200
    22.799     1.558     0.200
    23.411     2.140     0.200
    23.466     3.251     0.200
    23.743     3.184     0.200
    23.833     2.115     0.200
    23.833     1.561     0.200
    24.179     1.005     0.200
    24.179    -0.145     0.200
    24.179     0.136     0.200
    24.522     2.293     0.200
    24.764     1.965     0.200
    24.991     1.307     0.200
    24.999     0.924     0.200
    25.072     1.429     0.200
    25.252     2.297     0.200
    25.252     3.529     0.200
    25.379     1.390     0.200
    25.408     0.811     0.200
    25.497     0.705     0.200
    25.509     2.078     0.200
    25.743     1.323     0.200
    25.781     0.379     0.200
    25.853     1.705     0.200
    26.030     1.243     0.200
    26.088     1.170     0.200
    26.094     1.085     0.200
    26.147     1.335     0.200
    26.235     1.300     0.200
    26.259     0.914     0.200
    26.292     1.320     0.200
    26.304     2.047     0.200
    26.305     0.977     0.200
    26.422     2.079     0.200
    26.422     2.947     0.200
    26.431     1.929     0.200
    26.463     1.559     0.200
    26.520     1.750     0.200
    26.641     1.809     0.200
    26.647     1.223     0.200
    26.671     2.248     0.200
    26.751     0.578     0.200
    26.922     1.766     0.200
    26.924     1.631     0.200
    26.988     0.825     0.200
    27.023     2.172     0.200
    27.023     2.291     0.200
    27.028     0.127     0.200
    27.038     0.472     0.200
    27.066     0.707     0.200
    27.110     0.621     0.200
    27.255     1.218     0.200
    27.302     0.862     0.200
    27.305     0.170     0.200
    27.320     1.616     0.200
    27.322     1.138     0.200
    27.341     0.259     0.200
    27.360     0.487     0.200
    27.371     1.070     0.200
    27.381     1.547     0.200
    27.448     0.901     0.200
    27.448     1.496     0.200
    27.457    -0.048     0.200
    27.539     1.015     0.200
    27.560     2.060     0.200
    27.573     1.195     0.200
    27.613     1.394     0.200
    27.634     1.247     0.200
    27.638     1.809     0.200
    27.745     2.167     0.200
    27.777     1.157     0.200
    27.893     1.221     0.200
    27.910     0.922     0.200
    27.984     0.600     0.200
    28.026     0.738     0.200
    28.064     0.445     0.200
    28.069    -0.263     0.200
    28.086     1.478     0.200
    28.629     1.022     0.200
    28.747     0.435     0.200
    28.838     1.299     0.200
    28.898     0.983     0.200
    28.902     2.311     0.200
    28.924     1.621     0.200
    29.036     1.659     0.200
    29.113     1.672     0.200
    29.130     1.443     0.200
    29.190     0.474     0.200
    29.320     1.168     0.200
    29.393     0.977     0.200
    29.409     0.958     0.200
    29.485     0.851     0.200
    29.536     1.139     0.200
    29.583     1.794     0.200
    29.584     1.947     0.200
    29.762     1.761     0.200
    29.767     1.590     0.200
    29.778     0.963     0.200
    29.828     1.130     0.200
    29.908     0.165     0.200
    29.956    -0.171     0.200
    29.976    -1.042     0.200
    30.042     0.732     0.200
    30.099     0.938     0.200
    30.357     1.468     0.200
    30.361     2.130     0.200
    30.424     1.284     0.200
    30.500     1.742     0.200
    30.586     0.817     0.200
    30.737     0.682     0.200
    30.867     2.635     0.200
    31.021     1.908     0.200
    31.098     0.948     0.200
    31.278     1.338     0.200
    31.355     1.924     0.200
    31.345     1.217     0.200
    31.403     1.391     0.200
    31.430     2.002     0.200
    31.695    -0.200     0.200
    31.839    -0.653     0.200
    31.857    -0.109     0.200
    31.977     2.993     0.200
    32.243     1.385     0.200
    32.347     0.453     0.200
    32.378     1.636     0.200
    32.602     0.429     0.200
    32.613     1.067     0.200
    32.622     1.761     0.200
    32.881     0.346     0.200
    33.041     1.301     0.200
    33.210     0.809     0.200
    33.547     1.014     0.200
    33.633     1.450     0.200
    33.836     0.944     0.200
    33.847     1.490     0.200
    33.901     0.874     0.200
    34.014     0.624     0.200
    34.106     1.320     0.200
    34.244     1.137     0.200
    34.491     1.441     0.200
    34.837     1.125     0.200
    35.347     1.109     0.200
    35.469     3.256     0.200
    35.910     2.203     0.200
    36.080     2.009     0.200
    36.428     0.712     0.200
    37.199     2.530     0.200
    37.341     1.413     0.200
    37.722     0.686     0.200
    38.407     1.965     0.200
    38.580     2.601     0.200
    38.645     2.158     0.200
    38.645     0.300     0.200
    39.012     1.885     0.200
    39.012     2.314     0.200
    39.055     1.785     0.200
    40.654     2.021     0.200
    41.335     1.901     0.200
    42.151     1.829     0.200
    42.151     2.436     0.200
    45.746     2.178     0.200
    47.000     2.187     0.200
    47.566     2.298     0.200
    47.566     0.109     0.200
    50.333     0.979     0.200
    56.763     1.357     0.200
    56.826     2.409     0.200
    63.433     4.099     0.200
    63.623     2.021     0.200
    65.865     2.513     0.200
    68.045     0.540     0.200
    68.045     0.349     0.200
    73.246     1.724     0.200
    75.666     0.651     0.200
    78.512     1.249     0.200
    78.512     1.323     0.200
    80.038     0.787     0.200
    80.085     3.456     0.200
    82.630     0.104     0.200
    82.630     1.353     0.200
    82.998     4.938     0.200
    82.998     2.089     0.200
    82.998     1.858     0.200
    85.353     0.530     0.200
    85.792     2.574     0.200
    86.250    -1.592     0.200
    90.420     3.652     0.200
    90.807    -0.048     0.200
    92.322     2.931     0.200
    92.554     2.060     0.200
    92.604     5.429     0.200
    92.604     1.568     0.200
    95.885     0.470     0.200
    95.908     2.468     0.200
    96.891     5.804     0.200
    14.100     5.576     0.200
    14.152     5.633     0.200
    14.383     6.186     0.200
    14.472     5.006     0.200
    14.479     5.359     0.200
    14.527     5.105     0.200
    14.724     9.473     0.200
    14.876     5.135     0.200
    14.970     5.455     0.200
    15.085     4.174     0.200
    15.142     4.327     0.200
    15.330     4.317     0.200
    15.355     4.889     0.200
    15.437     4.566     0.200
    16.174     5.437     0.200
    16.195     6.395     0.200
    16.225     4.061     0.200
    16.372     2.742     0.200
    16.749     3.654     0.200
    16.749     3.300     0.200
    16.780     2.977     0.200
    17.039     3.257     0.200
    17.068     4.353     0.200
    17.139     2.841     0.200
    17.241     2.138     0.200
    17.395     2.603     0.200
    17.519     2.631     0.200
    17.554     3.460     0.200
    17.855     2.176     0.200
    18.273     1.645     0.200
    18.360     1.863     0.200
    18.360     2.758     0.200
    18.572     0.882     0.200
    18.601     0.797     0.200
    18.725     1.340     0.200
    19.339     1.627     0.200
    19.347     0.500     0.200
    19.483    -0.080     0.200
    19.829     1.201     0.200
    19.854     1.595     0.200
    20.015     1.496     0.200
    20.366     0.681     0.200
    20.705     1.851     0.200
    20.742     1.626     0.200
    20.815     1.214     0.200
    20.948     2.121     0.200
    20.976     1.352     0.200
    21.023     0.782     0.200
    21.023     1.350     0.200
    21.130     1.277     0.200
    21.221     3.359     0.200
    21.275     2.040     0.200
    21.325     2.673     0.200
    21.325     2.499     0.200
    21.461     2.170     0.200
    21.472     1.785     0.200
    21.646     1.476     0.200
    21.947     1.765     0.200
    22.057     3.793     0.200
    22.163     2.101     0.200
    22.163     1.497     0.200
    22.230     1.497     0.200
    22.312     3.014     0.200
    22.304     2.932     0.200
    22.359     1.923     0.200
    22.418     0.875     0.200
    22.418     2.021     0.200
    22.481     1.231     0.200
    22.481     1.845     0.200
    22.523     1.927     0.200
    22.550     0.863     0.200
    22.571     1.580     0.200
    22.663     1.625     0.200
    22.897     0.915     0.200
    23.050     1.196     0.200
    23.093     0.367     0.200
    23.093     2.897     0.200
    23.191     1.763     0.200
    23.216     1.751     0.200
    23.266     1.359     0.200
    23.313     1.787     0.200
    23.504     2.038     0.200
    23.504     2.210     0.200
    23.568     0.777     0.200
    23.625     2.438     0.200
    23.689     1.917     0.200
    23.799     1.373     0.200
    23.799     2.572     0.200
    23.866     1.744     0.200
    24.065     1.321     0.200
    24.116     0.931     0.200
    24.144     1.934     0.200
    24.222     0.038     0.200
    24.222     2.367     0.200
    24.305     2.224     0.200
    24.382     1.054     0.200
    24.382     2.647     0.200
    24.640     1.719     0.200
    24.640     2.930     0.200
    24.661     1.933     0.200
    24.715     2.073     0.200
    24.858     2.031     0.200
    24.908     0.201     0.200
    24.908     1.787     0.200
    24.938     2.221     0.200
    25.025     0.644     0.200
    25.100     1.376     0.200
    25.139     1.928     0.200
    25.177     2.652     0.200
    25.298     1.656     0.200
    25.532     1.079     0.200
    25.725     1.939     0.200
    25.793     2.648     0.200
    25.919     0.361     0.200
    25.957     1.356     0.200
    26.135     3.506     0.200
    26.165     1.217     0.200
    26.177     1.501     0.200
    26.315     1.076     0.200
    26.612     1.795     0.200
    26.668     1.931     0.200
    26.683     1.500     0.200
    26.770     0.506     0.200
    26.785     0.646     0.200
    26.929     1.218     0.200
    26.974     1.751     0.200
    27.142     1.264     0.200
    27.290     1.211     0.200
    27.488     1.645     0.200
    27.560     1.640     0.200
    27.568     1.359     0.200
    27.714     1.930     0.200
    28.082     1.221     0.200
    28.290    -0.813     0.200
    28.290     1.494     0.200
    28.366    -0.440     0.200
    28.413     2.363     0.200
    28.638     1.714     0.200
    28.638     3.049     0.200
    28.690     0.125     0.200
    28.792     0.213     0.200
    28.863     1.359     0.200
    28.904     0.941     0.200
    29.068    -1.723     0.200
    29.125     1.066     0.200
    29.473     3.008     0.200
    29.493    -1.715     0.200
    29.527     1.073     0.200
    29.617     1.346     0.200
    30.378     2.067     0.200
    30.895     2.091     0.200
    30.980     1.274     0.200
    31.339     0.025     0.200
    32.017     2.211     0.200
    32.488    -0.909     0.200
    33.264    -0.621     0.200
    38.257     1.931     0.200
    38.257     1.659     0.200
    38.459     2.037     0.200
    38.459     2.366     0.200
    38.459     2.187     0.200
    38.975     2.316     0.200
    39.002     1.912     0.200
    39.292     3.057     0.200
    39.778     2.402     0.200
    40.690     2.007     0.200
    41.427     1.439     0.200
    41.947     2.493     0.200
    46.960     2.860     0.200
    47.423     1.907     0.200
    55.943     3.248     0.200
    56.402     1.298     0.200
    61.146    -0.007     0.200
    61.637     2.143     0.200
    63.307     1.260     0.200
    63.572     1.307     0.200
    65.124     0.776     0.200
    65.857     1.791     0.200
    66.986     2.556     0.200
    68.012     3.056     0.200
    68.475     1.236     0.200
    77.997     0.548     0.200
    79.986     1.563     0.200
    80.031     1.167     0.200
    82.276     1.713     0.200
    82.276     1.927     0.200
    84.972     1.627     0.200
    85.727     3.294     0.200
    86.565     0.359     0.200
    92.427     2.279     0.200
    92.454     3.845     0.200
    93.048     3.107     0.200
    95.803     2.450     0.200
    38.260     2.773     0.200
    16.051     3.161     0.200
    16.162     3.578     0.200
    16.604     2.708     0.200
    17.368     2.780     0.200
    17.465     4.739     0.200
    17.465     3.606     0.200
    17.779     2.739     0.200
    19.544    -4.705     0.200
    19.691    -4.546     0.200
    19.689    -3.675     0.200
    19.856    -3.451     0.200
    20.643    -3.996     0.200
    20.701    -3.207     0.200
    21.141    -3.950     0.200
    21.149     3.522     0.200
    21.375     1.424     0.200
    21.980    -4.741     0.200
    22.957     1.326     0.200
    23.092     1.513     0.200
    23.263    -4.019     0.200
    23.349     1.234     0.200
    24.433     0.728     0.200
    27.053     0.468     0.200
    35.683     4.112     0.200
    35.816     4.654     0.200
    36.132     3.399     0.200
    36.192     3.209     0.200
    36.342     2.765     0.200
    36.472     3.731     0.200
    36.515     4.747     0.200
    36.888     3.810     0.200
    37.162     4.166     0.200
    37.233     3.328     0.200
    37.283     4.948     0.200
    37.365     5.260     0.200
    37.391     4.554     0.200
    37.503     3.786     0.200
    37.576     3.998     0.200
    37.669     4.564     0.200
    37.729     5.118     0.200
    37.751     4.577     0.200
    37.803     4.022     0.200
    37.877     3.320     0.200
    37.942     3.181     0.200
    38.089     5.217     0.200
    38.323     3.770     0.200
    38.548     4.517     0.200
    39.052     4.006     0.200
    39.328     3.971     0.200
    39.386     4.082     0.200
    39.663     2.956     0.200
    39.672     4.000     0.200
    39.935     3.860     0.200
    39.981     4.637     0.200
    40.138     3.286     0.200
    40.166     4.967     0.200
    40.270     2.910     0.200
    40.305     3.777     0.200
    40.627     4.542     0.200
    40.654     3.520     0.200
    40.999     3.703     0.200
    41.129     3.649     0.200
    41.126     4.541     0.200
    41.554     4.057     0.200
    41.568     2.691     0.200
    41.804     3.745     0.200
    42.430     3.126     0.200
    42.619     3.513     0.200
    51.945     2.695     0.200
    82.531     3.303     0.200
    96.374    -2.239     0.200
    16.952     5.134     0.200
    27.085     0.213     0.200
    38.713     3.697     0.200
    41.685     0.563     0.200
    38.062     2.502     0.200
    16.370     3.884     0.200
    20.985     1.263     0.200
    23.571     1.448     0.200
    23.571     1.550     0.200
    38.057     1.839     0.200
    95.409     0.704     0.200
    15.562     4.933     0.200
    16.225     6.072     0.200
    16.972     3.389     0.200
    21.133     0.855     0.200
    24.032     1.060     0.200
    24.084    -0.619     0.200
    25.312     1.813     0.200
    31.208     1.360     0.200
    35.264     1.360     0.200
    37.258     0.322     0.200
    38.644     2.275     0.200
    39.466    -3.692     0.200
    39.479    -1.168     0.200
    41.060     1.021     0.200
    41.100    -2.246     0.200
    42.173    -1.823     0.200
    43.598    -0.275     0.200
    43.822    -1.375     0.200
    95.858     5.611     0.200
    95.948     0.026     0.200
    16.073     2.038     0.200
    16.544     5.597     0.200
    17.535     0.958     0.200
    15.686     5.010     0.200
    16.775     4.115     0.200
    16.775     4.490     0.200
    19.643    -1.994     0.200
    20.288    -3.169     0.200
    20.752    -2.648     0.200
    21.031     2.886     0.200
    22.500     4.297     0.200
    23.510     1.991     0.200
    23.819     2.705     0.200
    24.721    -3.064     0.200
    25.163     3.274     0.200
    27.146     2.039     0.200
    29.069    -4.185     0.200
    31.005     2.243     0.200
    38.483     2.692     0.200
    43.266    -2.484     0.200
    63.592     1.342     0.200
    78.167     2.211     0.200
    79.668     2.866     0.200
    82.300     1.083     0.200
    84.988     3.683     0.200
    20.286    -1.042     0.200
    21.030    -0.099     0.200
    21.030     3.753     0.200
    21.472    -0.007     0.200
    22.494     3.130     0.200
    22.588     4.122     0.200
    23.679     4.856     0.200
    23.813     2.940     0.200
    24.458    -0.642     0.200
    24.621     3.770     0.200
    24.914     4.854     0.200
    25.156     2.656     0.200
    26.980     4.991     0.200
    27.146     4.816     0.200
    28.655     1.679     0.200
    30.998     0.784     0.200
    37.354     0.025     0.200
    38.475     2.088     0.200
    38.475     4.069     0.200
    39.611    -1.509     0.200
    40.756    -1.317     0.200
    41.321    -1.246     0.200
    41.427     2.310     0.200
    41.427    -0.639     0.200
    42.036    -1.758     0.200
    43.055    -1.643     0.200
    46.488     3.224     0.200
    47.417     3.836     0.200
    51.266     4.483     0.200
    51.616     4.429     0.200
    51.673     4.685     0.200
    53.996     4.113     0.200
    56.418     5.105     0.200
    59.036     3.458     0.200
    61.163     3.411     0.200
    61.404     3.147     0.200
    61.867     4.132     0.200
    63.061     5.928     0.200
    63.585     2.633     0.200
    63.585     0.149     0.200
    65.138     5.479     0.200
    65.846     4.750     0.200
    75.341     2.891     0.200
    75.341    -0.663     0.200
    76.090     2.926     0.200
    78.014     2.951     0.200
    78.014     3.943     0.200
    78.161     4.363     0.200
    78.161     3.140     0.200
    79.144     5.216     0.200
    79.592     4.489     0.200
    79.661     2.482     0.200
    79.978     3.877     0.200
    80.020     4.532     0.200
    80.020    -0.218     0.200
    80.400    -2.480     0.200
    80.479     5.166     0.200
    81.050     4.772     0.200
    81.357     4.618     0.200
    81.637     4.786     0.200
    81.624     4.117     0.200
    81.933     4.968     0.200
    82.216     5.229     0.200
    82.293     2.211     0.200
    82.336     5.241     0.200
    82.402     5.346     0.200
    82.457     4.698     0.200
    82.664     4.275     0.200
    82.678     2.640     0.200
    82.678    -0.224     0.200
    82.698     5.080     0.200
    82.895     5.211     0.200
    82.925     4.603     0.200
    82.284     6.860     0.200
    82.991     4.991     0.200
    82.989     5.408     0.200
    83.047     4.213     0.200
    83.129     3.699     0.200
    83.165     4.727     0.200
    83.207     5.261     0.200
    83.096     2.333     0.200
    83.291     4.268     0.200
    83.308     4.322     0.200
    83.288     2.279     0.200
    83.288     0.076     0.200
    83.367     4.187     0.200
    83.368     4.961     0.200
    83.391     4.903     0.200
    83.491     5.260     0.200
    83.605     4.893     0.200
    83.869     4.903     0.200
    83.938     2.909     0.200
    84.081     4.719     0.200
    84.984     2.330     0.200
    85.484     3.227     0.200
    85.971    -2.340     0.200
    86.392     4.208     0.200
    86.579    -1.035     0.200
    86.690     4.248     0.200
    87.678     4.426     0.200
    87.787     5.034     0.200
    87.846     5.925     0.200
    88.050     4.718     0.200
    88.071     4.655     0.200
    88.110     5.347     0.200
    88.112     2.834     0.200
    88.190     5.174     0.200
    88.276     4.424     0.200
    88.357     4.766     0.200
    88.989     3.822     0.200
    89.012     3.515     0.200
    89.097     3.313     0.200
    89.110     5.632     0.200
    89.277     4.151     0.200
    89.330     1.472     0.200
    89.698     4.684     0.200
    89.801     4.431     0.200
    90.000     5.085     0.200
    90.108     4.896     0.200
    90.339     3.839     0.200
    90.547     1.737     0.200
    90.755     4.971     0.200
    90.807     5.126     0.200
    91.327     3.013     0.200
    92.321     4.215     0.200
    92.340     3.924     0.200
    92.443     2.114     0.200
    92.443     4.649     0.200
    92.470     3.033     0.200
    92.649     3.799     0.200
    93.065     2.677     0.200
    93.065    -0.342     0.200
    93.371     3.571     0.200
    95.653     2.992     0.200
    95.791     5.574     0.200
    95.818    -1.845     0.200
    96.696    -0.937     0.200
    97.165     0.252     0.200
    97.268     2.580     0.200
    98.432    -0.662     0.200
    30.856     2.138     0.200
    38.244     3.235     0.200
    14.991     3.873     0.200
    15.484     8.227     0.200
    16.630     2.463     0.200
    17.261     3.540     0.200
    17.891     0.793     0.200
    80.833    -0.458     0.200
    18.590    -0.355     0.200
    18.911     0.170     0.200
    20.279     0.053     0.200
    20.302     0.470     0.200
    20.718    -0.096     0.200
    20.764    -0.137     0.200
    22.709    -0.361     0.200
    23.112    -0.319     0.200
    24.931     0.052     0.200
    27.600    -0.610     0.200
    30.492    -0.240     0.200
    15.450     4.431     0.200
    16.264     1.921     0.200
    16.269     2.720     0.200
    17.533     1.292     0.200
    19.329    -0.434     0.200
    21.474     0.074     0.200
    22.504     0.733     0.200
    23.825     1.058     0.200
    24.468    -1.041     0.200
    38.509     2.710     0.200
    38.509     1.031     0.200
    39.356    -1.188     0.200
    39.390    -0.095     0.200
    40.048    -0.713     0.200
    40.545     0.578     0.200
    40.979     0.803     0.200
    56.740     2.651     0.200
    63.620     3.168     0.200
    79.678     2.845     0.200
    79.985     0.335     0.200
    79.985     2.648     0.200
    80.923     1.029     0.200
    82.313     1.672     0.200
    82.713     2.947     0.200
    84.987     2.192     0.200
    84.987    -0.949     0.200
    80.922     1.705     0.200
    38.515     3.168     0.200
    21.023     1.376     0.200
    23.232     0.147     0.200
    23.833     1.830     0.200
    24.475    -0.963     0.200
    31.036     0.173     0.200
    37.162     0.101     0.200
    37.199    -0.529     0.200
    38.520     2.716     0.200
    39.911     2.327     0.200
    40.556     0.847     0.200
    40.672     2.052     0.200
    40.990     1.465     0.200
    63.630     2.047     0.200
    79.687     2.044     0.200
    80.934     1.367     0.200
    82.322     1.663     0.200
    84.993     3.314     0.200
    92.516     2.530     0.200
    35.733    -0.102     0.200
    38.499     4.543     0.200
    38.493     3.632     0.200
    80.907     2.098     0.200
    38.495     5.411     0.200
    80.908     3.457     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   101.585     2.414     0.200
   102.668    -0.699     0.200
   122.884     4.627     0.200
   101.675    -0.686     0.200
   101.967     0.515     0.200
   102.774    -0.074     0.200
   102.275     0.439     0.200
   107.443    -1.017     0.200
   102.277     1.303     0.200
   102.298     0.078     0.200
   107.750    -1.159     0.200
   102.246     3.983     0.200
   102.652     3.177     0.200
   102.039     3.312     0.200
   107.532    -0.809     0.200
   100.393     1.948     0.200
   100.393    -0.271     0.200
   102.055     1.408     0.200
   102.002     3.004     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    38.728   131.503     0.200
    31.308   174.857     0.200
    97.808     1.259     0.200
    95.345     1.724     0.200
    98.582     2.575     0.200
    31.278   174.688     0.200
    98.456     2.452     0.200
    30.980   176.776     0.200
    30.998   177.737     0.200
    38.475   133.994     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
