#!/bin/bash
gmt begin alberchigos1.34_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times alberchigos1.34'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   323.965
    25.500   328.508
    26.000   333.040
    26.500   337.561
    27.000   342.069
    27.500   346.561
    28.000   351.033
    28.500   355.490
    29.000   359.935
    29.500   364.371
    30.000   368.800
    30.500   373.221
    31.000   377.634
    31.500   382.039
    32.000   386.437
    32.500   390.824
    33.000   395.202
    33.500   399.566
    34.000   403.917
    34.500   408.252
    35.000   412.573
    35.500   416.878
    36.000   421.169
    36.500   425.444
    37.000   429.704
    37.500   433.948
    38.000   438.176
    38.500   442.388
    39.000   446.583
    39.500   450.762
    40.000   454.923
    40.500   459.067
    41.000   463.195
    41.500   467.305
    42.000   471.398
    42.500   475.474
    43.000   479.533
    43.500   483.574
    44.000   487.597
    44.500   491.603
    45.000   495.590
    45.500   499.560
    46.000   503.512
    46.500   507.445
    47.000   511.361
    47.500   515.259
    48.000   519.138
    48.500   522.999
    49.000   526.842
    49.500   530.667
    50.000   534.474
    50.500   538.262
    51.000   542.032
    51.500   545.784
    52.000   549.518
    52.500   553.234
    53.000   556.932
    53.500   560.612
    54.000   564.274
    54.500   567.918
    55.000   571.544
    55.500   575.150
    56.000   578.739
    56.500   582.309
    57.000   585.860
    57.500   589.394
    58.000   592.909
    58.500   596.406
    59.000   599.886
    59.500   603.346
    60.000   606.789
    60.500   610.213
    61.000   613.619
    61.500   617.006
    62.000   620.375
    62.500   623.726
    63.000   627.059
    63.500   630.374
    64.000   633.671
    64.500   636.950
    65.000   640.212
    65.500   643.455
    66.000   646.681
    66.500   649.888
    67.000   653.077
    67.500   656.249
    68.000   659.402
    68.500   662.536
    69.000   665.653
    69.500   668.752
    70.000   671.832
    70.500   674.894
    71.000   677.938
    71.500   680.964
    72.000   683.972
    72.500   686.962
    73.000   689.933
    73.500   692.886
    74.000   695.819
    74.500   698.735
    75.000   701.631
    75.500   704.509
    76.000   707.369
    76.500   710.210
    77.000   713.033
    77.500   715.839
    78.000   718.626
    78.500   721.395
    79.000   724.146
    79.500   726.878
    80.000   729.592
    80.500   732.287
    81.000   734.962
    81.500   737.618
    82.000   740.255
    82.500   742.873
    83.000   745.473
    83.500   748.054
    84.000   750.615
    84.500   753.156
    85.000   755.676
    85.500   758.177
    86.000   760.658
    86.500   763.123
    87.000   765.569
    87.500   767.992
    88.000   770.381
    88.500   772.748
    89.000   775.102
    89.500   777.448
    90.000   779.786
    90.500   782.117
    91.000   784.442
    91.500   786.761
    92.000   789.076
    92.500   791.387
    93.000   793.694
    93.500   795.998
    94.000   798.298
    94.500   800.594
    95.000   802.884
    95.500   805.168
    96.000   807.446
    96.500   809.718
    97.000   811.983
    97.500   814.242
    98.000   816.493
    98.500   818.738
    99.000   820.974
    99.500   823.203
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1122.221
   116.000  1123.183
   116.500  1124.145
   117.000  1125.107
   117.500  1126.069
   118.000  1127.031
   118.500  1127.993
   119.000  1128.955
   119.500  1129.916
   120.000  1130.877
   120.500  1131.839
   121.000  1132.799
   121.500  1133.760
   122.000  1134.720
   122.500  1135.680
   123.000  1136.639
   123.500  1137.599
   124.000  1138.557
   124.500  1139.515
   125.000  1140.473
   125.500  1141.430
   126.000  1142.387
   126.500  1143.343
   127.000  1144.298
   127.500  1145.252
   128.000  1146.206
   128.500  1147.159
   129.000  1148.110
   129.500  1149.062
   130.000  1150.011
   130.500  1150.960
   131.000  1151.908
   131.500  1152.854
   132.000  1153.799
   132.500  1154.743
   133.000  1155.685
   133.500  1156.625
   134.000  1157.564
   134.500  1158.502
   135.000  1159.437
   135.500  1160.370
   136.000  1161.301
   136.500  1162.230
   137.000  1163.156
   137.500  1164.080
   138.000  1165.002
   138.500  1165.920
   139.000  1166.836
   139.500  1167.749
   140.000  1168.658
   140.500  1169.565
   141.000  1170.467
   141.500  1171.366
   142.000  1172.260
   142.500  1173.151
   143.000  1174.037
   143.500  1174.918
   144.000  1175.794
   144.500  1176.665
   145.000  1177.531
   145.500  1178.391
   146.000  1179.245
   146.500  1180.093
   147.000  1180.933
   147.500  1181.768
   148.000  1182.595
   148.500  1183.415
   149.000  1184.226
   149.500  1185.029
   150.000  1185.822
   150.500  1186.605
   151.000  1187.379
   151.500  1188.142
   152.000  1188.896
   152.500  1189.639
   153.000  1190.372
   153.500  1191.095
   154.000  1191.808
   154.500  1192.509
   155.000  1193.200
   155.500  1193.879
   156.000  1194.546
   156.500  1195.202
   157.000  1195.845
   157.500  1196.477
   158.000  1197.096
   158.500  1197.703
   159.000  1198.297
   159.500  1198.878
   160.000  1199.447
   160.500  1200.002
   161.000  1200.545
   161.500  1201.074
   162.000  1201.590
   162.500  1202.093
   163.000  1202.583
   163.500  1203.059
   164.000  1203.521
   164.500  1203.969
   165.000  1204.404
   165.500  1204.824
   166.000  1205.231
   166.500  1205.625
   167.000  1206.004
   167.500  1206.369
   168.000  1206.720
   168.500  1207.057
   169.000  1207.380
   169.500  1207.689
   170.000  1207.983
   170.500  1208.264
   171.000  1208.530
   171.500  1208.781
   172.000  1209.019
   172.500  1209.242
   173.000  1209.451
   173.500  1209.646
   174.000  1209.826
   174.500  1209.992
   175.000  1210.143
   175.500  1210.280
   176.000  1210.403
   176.500  1210.511
   177.000  1210.605
   177.500  1210.685
   178.000  1210.750
   178.500  1210.800
   179.000  1210.836
   179.500  1210.858
   180.000  1210.865
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   993.164
     1.000   993.172
     1.500   993.186
     2.000   993.206
     2.500   993.231
     3.000   993.262
     3.500   993.298
     4.000   993.340
     4.500   993.388
     5.000   993.441
     5.500   993.499
     6.000   993.564
     6.500   993.634
     7.000   993.709
     7.500   993.790
     8.000   993.877
     8.500   993.969
     9.000   994.067
     9.500   994.170
    10.000   994.279
    10.500   994.393
    11.000   994.513
    11.500   994.639
    12.000   994.770
    12.500   994.907
    13.000   995.049
    13.500   995.197
    14.000   995.350
    14.500   995.508
    15.000   995.673
    15.500   995.843
    16.000   996.018
    16.500   996.199
    17.000   996.385
    17.500   996.577
    18.000   996.774
    18.500   996.976
    19.000   997.185
    19.500   997.398
    20.000   997.617
    20.500   997.842
    21.000   998.072
    21.500   998.307
    22.000   998.548
    22.500   998.794
    23.000   999.046
    23.500   999.303
    24.000   999.565
    24.500   999.833
    25.000  1000.106
    25.500  1000.384
    26.000  1000.668
    26.500  1000.957
    27.000  1001.252
    27.500  1001.552
    28.000  1001.857
    28.500  1002.167
    29.000  1002.483
    29.500  1002.804
    30.000  1003.130
    30.500  1003.461
    31.000  1003.798
    31.500  1004.140
    32.000  1004.487
    32.500  1004.840
    33.000  1005.197
    33.500  1005.560
    34.000  1005.928
    34.500  1006.301
    35.000  1006.679
    35.500  1007.063
    36.000  1007.451
    36.500  1007.845
    37.000  1008.243
    37.500  1008.647
    38.000  1009.056
    38.500  1009.470
    39.000  1009.889
    39.500  1010.313
    40.000  1010.742
    40.500  1011.176
    41.000  1011.615
    41.500  1012.059
    42.000  1012.508
    42.500  1012.962
    43.000  1013.420
    43.500  1013.884
    44.000  1014.353
    44.500  1014.826
    45.000  1015.304
    45.500  1015.787
    46.000  1016.276
    46.500  1016.768
    47.000  1017.266
    47.500  1017.768
    48.000  1018.276
    48.500  1018.787
    49.000  1019.304
    49.500  1019.826
    50.000  1020.352
    50.500  1020.882
    51.000  1021.418
    51.500  1021.958
    52.000  1022.503
    52.500  1023.052
    53.000  1023.606
    53.500  1024.164
    54.000  1024.727
    54.500  1025.295
    55.000  1025.867
    55.500  1026.444
    56.000  1027.025
    56.500  1027.611
    57.000  1028.201
    57.500  1028.795
    58.000  1029.394
    58.500  1029.997
    59.000  1030.605
    59.500  1031.217
    60.000  1031.833
    60.500  1032.454
    61.000  1033.079
    61.500  1033.709
    62.000  1034.342
    62.500  1034.980
    63.000  1035.622
    63.500  1036.268
    64.000  1036.919
    64.500  1037.573
    65.000  1038.232
    65.500  1038.895
    66.000  1039.562
    66.500  1040.233
    67.000  1040.908
    67.500  1041.587
    68.000  1042.270
    68.500  1042.957
    69.000  1043.648
    69.500  1044.344
    70.000  1045.043
    70.500  1045.746
    71.000  1046.452
    71.500  1047.163
    72.000  1047.878
    72.500  1048.596
    73.000  1049.318
    73.500  1050.044
    74.000  1050.774
    74.500  1051.508
    75.000  1052.245
    75.500  1052.986
    76.000  1053.730
    76.500  1054.479
    77.000  1055.230
    77.500  1055.986
    78.000  1056.745
    78.500  1057.508
    79.000  1058.274
    79.500  1059.044
    80.000  1059.817
    80.500  1060.594
    81.000  1061.374
    81.500  1062.157
    82.000  1062.944
    82.500  1063.735
    83.000  1064.529
    83.500  1065.326
    84.000  1066.126
    84.500  1066.930
    85.000  1067.737
    85.500  1068.547
    86.000  1069.361
    86.500  1070.177
    87.000  1070.997
    87.500  1071.820
    88.000  1072.646
    88.500  1073.476
    89.000  1074.308
    89.500  1075.143
    90.000  1075.982
    90.500  1076.823
    91.000  1077.668
    91.500  1078.515
    92.000  1079.366
    92.500  1080.219
    93.000  1081.075
    93.500  1081.934
    94.000  1082.796
    94.500  1083.661
    95.000  1084.529
    95.500  1085.399
    96.000  1086.272
    96.500  1087.148
    97.000  1088.027
    97.500  1088.908
    98.000  1089.792
    98.500  1090.679
    99.000  1091.568
    99.500  1092.460
   100.000  1093.354
   100.500  1094.251
   101.000  1095.150
   101.500  1096.052
   102.000  1096.957
   102.500  1097.863
   103.000  1098.773
   103.500  1099.684
   104.000  1100.598
   104.500  1101.515
   105.000  1102.433
   105.500  1103.354
   106.000  1104.278
   106.500  1105.203
   107.000  1106.131
   107.500  1107.061
   108.000  1107.993
   108.500  1108.927
   109.000  1109.864
   109.500  1110.802
   110.000  1111.743
   110.500  1112.686
   111.000  1113.631
   111.500  1114.577
   112.000  1115.526
   112.500  1116.477
   113.000  1117.430
   113.500  1118.384
   114.000  1119.341
   114.500  1120.299
   115.000  1121.259
   115.500  1122.221
   116.000  1123.185
   116.500  1124.151
   117.000  1125.118
   117.500  1126.087
   118.000  1127.058
   118.500  1128.030
   119.000  1129.004
   119.500  1129.980
   120.000  1130.957
   120.500  1131.936
   121.000  1132.917
   121.500  1133.899
   122.000  1134.882
   122.500  1135.867
   123.000  1136.854
   123.500  1137.842
   124.000  1138.831
   124.500  1139.822
   125.000  1140.814
   125.500  1141.807
   126.000  1142.802
   126.500  1143.798
   127.000  1144.795
   127.500  1145.794
   128.000  1146.794
   128.500  1147.795
   129.000  1148.797
   129.500  1149.800
   130.000  1150.805
   130.500  1151.810
   131.000  1152.817
   131.500  1153.825
   132.000  1154.833
   132.500  1155.843
   133.000  1156.854
   133.500  1157.866
   134.000  1158.878
   134.500  1159.892
   135.000  1160.907
   135.500  1161.922
   136.000  1162.938
   136.500  1163.955
   137.000  1164.973
   137.500  1165.992
   138.000  1167.011
   138.500  1168.031
   139.000  1169.053
   139.500  1170.074
   140.000  1171.096
   140.500  1172.120
   141.000  1173.143
   141.500  1174.167
   142.000  1175.192
   142.500  1176.218
   143.000  1177.243
   143.500  1178.270
   144.000  1179.297
   144.500  1180.324
   145.000  1181.352
   145.500  1182.380
   146.000  1183.409
   146.500  1184.438
   147.000  1185.468
   147.500  1186.498
   148.000  1187.528
   148.500  1188.558
   149.000  1189.589
   149.500  1190.620
   150.000  1191.651
   150.500  1192.683
   151.000  1193.715
   151.500  1194.746
   152.000  1195.778
   152.500  1196.811
   153.000  1197.843
   153.500  1198.875
   154.000  1199.908
   154.500  1200.941
   155.000  1201.973
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.840
   145.500  1178.663
   146.000  1180.543
   146.500  1182.460
   147.000  1184.405
   147.500  1186.373
   148.000  1188.361
   148.500  1190.366
   149.000  1192.388
   149.500  1194.423
   150.000  1196.471
   150.500  1198.530
   151.000  1200.600
   151.500  1202.680
   152.000  1204.768
   152.500  1206.865
   153.000  1208.970
   153.500  1211.082
   154.000  1213.201
   154.500  1215.327
   155.000  1217.458
   155.500  1219.596
   156.000  1221.739
   156.500  1223.886
   157.000  1226.038
   157.500  1228.195
   158.000  1230.357
   158.500  1232.522
   159.000  1234.691
   159.500  1236.864
   160.000  1239.040
   160.500  1241.220
   161.000  1243.402
   161.500  1245.588
   162.000  1247.776
   162.500  1249.967
   163.000  1252.160
   163.500  1254.355
   164.000  1256.553
   164.500  1258.752
   165.000  1260.954
   165.500  1263.157
   166.000  1265.362
   166.500  1267.569
   167.000  1269.777
   167.500  1271.987
   168.000  1274.198
   168.500  1276.410
   169.000  1278.623
   169.500  1280.838
   170.000  1283.053
   170.500  1285.270
   171.000  1287.487
   171.500  1289.705
   172.000  1291.924
   172.500  1294.143
   173.000  1296.363
   173.500  1298.583
   174.000  1300.804
   174.500  1303.026
   175.000  1305.248
   175.500  1307.470
   176.000  1309.692
   176.500  1311.914
   177.000  1314.137
   177.500  1316.360
   178.000  1318.583
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1176.838
   145.500  1178.464
   146.000  1180.012
   146.500  1181.502
   147.000  1182.941
   147.500  1184.336
   148.000  1185.688
   148.500  1187.000
   149.000  1188.277
   149.500  1189.526
   150.000  1190.750
   150.500  1191.950
   151.000  1193.130
   151.500  1194.291
   152.000  1195.433
   152.500  1196.558
   153.000  1197.667
   153.500  1198.761
   154.000  1199.842
   154.500  1200.911
   155.000  1201.965
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   510.039
     1.000   510.075
     1.500   510.135
     2.000   510.219
     2.500   510.327
     3.000   510.459
     3.500   510.615
     4.000   510.795
     4.500   510.999
     5.000   511.226
     5.500   511.477
     6.000   511.752
     6.500   512.051
     7.000   512.373
     7.500   512.719
     8.000   513.089
     8.500   513.482
     9.000   513.898
     9.500   514.337
    10.000   514.800
    10.500   515.285
    11.000   515.794
    11.500   516.326
    12.000   516.880
    12.500   517.458
    13.000   518.057
    13.500   518.680
    14.000   519.324
    14.500   519.991
    15.000   520.680
    15.500   521.391
    16.000   522.124
    16.500   522.879
    17.000   523.656
    17.500   524.453
    18.000   525.273
    18.500   526.113
    19.000   526.975
    19.500   527.857
    20.000   528.760
    20.500   529.684
    21.000   530.628
    21.500   531.593
    22.000   532.578
    22.500   533.582
    23.000   534.607
    23.500   535.651
    24.000   536.715
    24.500   537.798
    25.000   538.900
    25.500   540.021
    26.000   541.161
    26.500   542.319
    27.000   543.496
    27.500   544.691
    28.000   545.905
    28.500   547.136
    29.000   548.385
    29.500   549.651
    30.000   550.935
    30.500   552.236
    31.000   553.554
    31.500   554.889
    32.000   556.241
    32.500   557.609
    33.000   558.993
    33.500   560.393
    34.000   561.809
    34.500   563.241
    35.000   564.688
    35.500   566.151
    36.000   567.629
    36.500   569.121
    37.000   570.629
    37.500   572.151
    38.000   573.688
    38.500   575.238
    39.000   576.803
    39.500   578.381
    40.000   579.974
    40.500   581.579
    41.000   583.198
    41.500   584.830
    42.000   586.475
    42.500   588.133
    43.000   589.803
    43.500   591.486
    44.000   593.180
    44.500   594.887
    45.000   596.606
    45.500   598.336
    46.000   600.078
    46.500   601.831
    47.000   603.595
    47.500   605.371
    48.000   607.157
    48.500   608.953
    49.000   610.760
    49.500   612.578
    50.000   614.405
    50.500   616.243
    51.000   618.090
    51.500   619.947
    52.000   621.813
    52.500   623.689
    53.000   625.574
    53.500   627.468
    54.000   629.370
    54.500   631.282
    55.000   633.202
    55.500   635.130
    56.000   637.066
    56.500   639.011
    57.000   640.963
    57.500   642.923
    58.000   644.891
    58.500   646.866
    59.000   648.849
    59.500   650.839
    60.000   652.836
    60.500   654.839
    61.000   656.850
    61.500   658.867
    62.000   660.891
    62.500   662.921
    63.000   664.957
    63.500   666.999
    64.000   669.047
    64.500   671.102
    65.000   673.161
    65.500   675.227
    66.000   677.298
    66.500   679.374
    67.000   681.456
    67.500   683.542
    68.000   685.634
    68.500   687.730
    69.000   689.831
    69.500   691.937
    70.000   694.047
    70.500   696.162
    71.000   698.281
    71.500   700.404
    72.000   702.531
    72.500   704.662
    73.000   706.797
    73.500   708.936
    74.000   711.079
    74.500   713.225
    75.000   715.374
    75.500   717.527
    76.000   719.683
    76.500   721.843
    77.000   724.005
    77.500   726.170
    78.000   728.339
    78.500   730.510
    79.000   732.683
    79.500   734.860
    80.000   737.039
    80.500   739.220
    81.000   741.404
    81.500   743.590
    82.000   745.778
    82.500   747.968
    83.000   750.160
    83.500   752.355
    84.000   754.551
    84.500   756.749
    85.000   758.949
    85.500   761.150
    86.000   763.353
    86.500   765.557
    87.000   767.763
    87.500   769.971
    88.000   772.179
    88.500   774.389
    89.000   776.600
    89.500   778.812
    90.000   781.026
    90.500   783.240
    91.000   785.455
    91.500   787.671
    92.000   789.888
    92.500   792.106
    93.000   794.324
    93.500   796.543
    94.000   798.763
    94.500   800.983
    95.000   803.204
    95.500   805.425
    96.000   807.646
    96.500   809.868
    97.000   812.090
    97.500   814.312
    98.000   816.535
    98.500   818.757
    99.000   820.980
    99.500   823.203
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.500   419.790
    29.000   425.348
    29.500   430.905
    30.000   436.461
    30.500   442.016
    31.000   447.570
    31.500   453.121
    32.000   458.671
    32.500   464.219
    33.000   469.763
    33.500   475.304
    34.000   480.842
    34.500   486.375
    35.000   491.904
    35.500   497.428
    36.000   502.946
    36.500   508.458
    37.000   513.964
    37.500   519.462
    38.000   524.953
    38.500   530.435
    39.000   535.909
    39.500   541.373
    40.000   546.827
    40.500   552.271
    41.000   557.703
    41.500   563.124
    42.000   568.532
    42.500   573.928
    43.000   579.310
    43.500   584.679
    44.000   590.033
    44.500   595.372
    45.000   600.696
    45.500   606.004
    46.000   611.296
    46.500   616.571
    47.000   621.830
    47.500   626.585
    48.000   631.156
    48.500   635.722
    49.000   640.284
    49.500   644.840
    50.000   649.392
    50.500   653.938
    51.000   658.479
    51.500   663.015
    52.000   667.545
    52.500   672.069
    53.000   676.588
    53.500   681.100
    54.000   685.605
    54.500   690.103
    55.000   694.591
    55.500   699.069
    56.000   703.537
    56.500   707.997
    57.000   712.451
    57.500   716.899
    58.000   721.343
    58.500   725.781
    59.000   730.216
    59.500   734.647
    60.000   739.074
    60.500   743.497
    61.000   747.916
    61.500   752.332
    62.000   756.743
    62.500   761.151
    63.000   765.555
    63.500   769.955
    64.000   774.350
    64.500   778.741
    65.000   783.127
    65.500   787.508
    66.000   791.882
    66.500   796.251
    67.000   800.613
    67.500   804.967
    68.000   809.315
    68.500   813.655
    69.000   817.988
    69.500   822.313
    70.000   826.630
    70.500   830.940
    71.000   835.242
    71.500   839.537
    72.000   843.824
    72.500   848.104
    73.000   852.376
    73.500   856.640
    74.000   860.897
    74.500   865.145
    75.000   869.386
    75.500   873.619
    76.000   877.844
    76.500   882.060
    77.000   886.269
    77.500   890.469
    78.000   894.661
    78.500   898.844
    79.000   903.019
    79.500   907.186
    80.000   911.344
    80.500   915.493
    81.000   919.634
    81.500   923.766
    82.000   927.890
    82.500   932.005
    83.000   936.112
    83.500   940.210
    84.000   944.300
    84.500   948.381
    85.000   952.453
    85.500   956.517
    86.000   960.572
    86.500   964.618
    87.000   968.655
    87.500   972.684
    88.000   976.703
    88.500   980.714
    89.000   984.716
    89.500   988.708
    90.000   992.692
    90.500   996.667
    91.000  1000.633
    91.500  1004.590
    92.000  1008.538
    92.500  1012.477
    93.000  1016.407
    93.500  1020.328
    94.000  1024.240
    94.500  1028.142
    95.000  1032.036
    95.500  1035.921
    96.000  1039.796
    96.500  1043.663
    97.000  1047.520
    97.500  1051.369
    98.000  1055.208
    98.500  1059.038
    99.000  1062.859
    99.500  1066.671
   100.000  1070.474
   100.500  1074.268
   101.000  1078.052
   101.500  1081.827
   102.000  1085.593
   102.500  1089.350
   103.000  1093.098
   103.500  1096.837
   104.000  1100.567
   104.500  1104.288
   105.000  1108.000
   105.500  1111.703
   106.000  1115.398
   106.500  1119.083
   107.000  1122.759
   107.500  1126.427
   108.000  1130.085
   108.500  1133.734
   109.000  1137.374
   109.500  1141.005
   110.000  1144.626
   110.500  1148.238
   111.000  1151.841
   111.500  1155.435
   112.000  1159.019
   112.500  1162.594
   113.000  1166.160
   113.500  1169.717
   114.000  1173.265
   114.500  1176.803
   115.000  1180.333
   115.500  1183.854
   116.000  1187.365
   116.500  1190.867
   117.000  1194.361
   117.500  1197.845
   118.000  1201.320
   118.500  1204.786
   119.000  1208.243
   119.500  1211.691
   120.000  1215.129
   120.500  1218.559
   121.000  1221.979
   121.500  1225.390
   122.000  1228.791
   122.500  1232.184
   123.000  1235.567
   123.500  1238.941
   124.000  1242.306
   124.500  1245.662
   125.000  1249.009
   125.500  1252.347
   126.000  1255.676
   126.500  1258.996
   127.000  1262.308
   127.500  1265.610
   128.000  1268.903
   128.500  1272.188
   129.000  1275.463
   129.500  1278.730
   130.000  1281.987
   130.500  1285.236
   131.000  1288.475
   131.500  1291.706
   132.000  1294.927
   132.500  1298.140
   133.000  1301.343
   133.500  1304.537
   134.000  1307.723
   134.500  1310.899
   135.000  1314.066
   135.500  1317.224
   136.000  1320.373
   136.500  1323.513
   137.000  1326.644
   137.500  1329.766
   138.000  1332.878
   138.500  1335.982
   139.000  1339.076
   139.500  1342.162
   140.000  1345.238
   140.500  1348.306
   141.000  1351.364
   141.500  1354.413
   142.000  1357.453
   142.500  1360.484
   143.000  1363.506
   143.500  1366.519
   144.000  1369.523
   144.500  1372.517
   145.000  1375.503
   145.500  1378.479
   146.000  1381.446
   146.500  1384.404
   147.000  1387.353
   147.500  1390.292
   148.000  1393.222
   148.500  1396.142
   149.000  1399.053
   149.500  1401.955
   150.000  1404.847
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   825.426
   100.500   827.649
   101.000   829.872
   101.500   832.094
   102.000   834.317
   102.500   836.540
   103.000   838.763
   103.500   840.986
   104.000   843.209
   104.500   845.431
   105.000   847.654
   105.500   849.877
   106.000   852.100
   106.500   854.323
   107.000   856.546
   107.500   858.768
   108.000   860.991
   108.500   863.214
   109.000   865.437
   109.500   867.660
   110.000   869.883
   110.500   872.105
   111.000   874.328
   111.500   876.551
   112.000   878.774
   112.500   880.997
   113.000   883.220
   113.500   885.442
   114.000   887.665
   114.500   889.888
   115.000   892.111
   115.500   894.334
   116.000   896.557
   116.500   898.779
   117.000   901.002
   117.500   903.225
   118.000   905.448
   118.500   907.671
   119.000   909.894
   119.500   912.116
   120.000   914.339
   120.500   916.562
   121.000   918.785
   121.500   921.008
   122.000   923.231
   122.500   925.453
   123.000   927.676
   123.500   929.899
   124.000   932.122
   124.500   934.345
   125.000   936.568
   125.500   938.790
   126.000   941.013
   126.500   943.236
   127.000   945.459
   127.500   947.682
   128.000   949.905
   128.500   952.128
   129.000   954.350
   129.500   956.573
   130.000   958.796
   130.500   961.019
   131.000   963.242
   131.500   965.464
   132.000   967.687
   132.500   969.910
   133.000   972.133
   133.500   974.356
   134.000   976.579
   134.500   978.801
   135.000   981.024
   135.500   983.247
   136.000   985.470
   136.500   987.693
   137.000   989.916
   137.500   992.138
   138.000   994.361
   138.500   996.584
   139.000   998.807
   139.500  1001.030
   140.000  1003.253
   140.500  1005.476
   141.000  1007.698
   141.500  1009.921
   142.000  1012.144
   142.500  1014.367
   143.000  1016.590
   143.500  1018.812
   144.000  1021.035
   144.500  1023.258
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   385.808
    15.000   396.047
    15.500   406.281
    16.000   416.509
    16.500   426.727
    17.000   436.931
    17.500   447.116
    18.000   457.279
    18.500   467.413
    19.000   477.514
    19.500   487.575
    20.000   497.591
    20.500   507.556
    21.000   517.463
    21.500   527.307
    22.000   537.083
    22.500   546.787
    23.000   555.483
    23.500   563.626
    24.000   571.736
    24.500   579.813
    25.000   587.847
    25.500   595.801
    26.000   603.713
    26.500   611.613
    27.000   619.505
    27.500   627.389
    28.000   635.266
    28.500   643.136
    29.000   651.000
    29.500   658.858
    30.000   666.708
    30.500   674.549
    31.000   682.382
    31.500   690.203
    32.000   698.011
    32.500   705.805
    33.000   713.583
    33.500   721.345
    34.000   729.089
    34.500   736.815
    35.000   744.521
    35.500   752.208
    36.000   759.876
    36.500   767.523
    37.000   775.151
    37.500   782.757
    38.000   790.342
    38.500   797.906
    39.000   805.448
    39.500   812.967
    40.000   820.463
    40.500   827.936
    41.000   835.386
    41.500   842.812
    42.000   850.215
    42.500   857.593
    43.000   864.946
    43.500   872.276
    44.000   879.580
    44.500   886.860
    45.000   894.114
    45.500   901.343
    46.000   908.547
    46.500   915.725
    47.000   922.876
    47.500   930.001
    48.000   937.100
    48.500   944.172
    49.000   951.216
    49.500   958.234
    50.000   965.225
    50.500   972.188
    51.000   979.125
    51.500   986.034
    52.000   992.915
    52.500   999.769
    53.000  1006.595
    53.500  1013.396
    54.000  1020.170
    54.500  1026.919
    55.000  1033.640
    55.500  1040.335
    56.000  1047.002
    56.500  1053.641
    57.000  1060.253
    57.500  1066.836
    58.000  1073.391
    58.500  1079.918
    59.000  1086.417
    59.500  1092.889
    60.000  1099.334
    60.500  1105.750
    61.000  1112.139
    61.500  1118.500
    62.000  1124.832
    62.500  1131.136
    63.000  1137.412
    63.500  1143.659
    64.000  1149.877
    64.500  1156.068
    65.000  1162.229
    65.500  1168.363
    66.000  1174.469
    66.500  1180.546
    67.000  1186.595
    67.500  1192.615
    68.000  1198.607
    68.500  1204.570
    69.000  1210.505
    69.500  1216.411
    70.000  1222.288
    70.500  1228.137
    71.000  1233.956
    71.500  1239.747
    72.000  1245.509
    72.500  1251.241
    73.000  1256.943
    73.500  1262.616
    74.000  1268.258
    74.500  1273.871
    75.000  1279.453
    75.500  1285.007
    76.000  1290.531
    76.500  1296.025
    77.000  1301.490
    77.500  1306.926
    78.000  1312.330
    78.500  1317.704
    79.000  1323.048
    79.500  1328.363
    80.000  1333.649
    80.500  1338.906
    81.000  1344.132
    81.500  1349.326
    82.000  1354.489
    82.500  1359.620
    83.000  1364.719
    83.500  1369.787
    84.000  1374.824
    84.500  1379.830
    85.000  1384.804
    85.500  1389.748
    86.000  1394.659
    86.500  1399.539
    87.000  1404.386
    87.500  1409.201
    88.000  1413.982
    88.500  1418.731
    89.000  1423.447
    89.500  1428.128
    90.000  1432.777
    90.500  1437.391
    91.000  1441.972
    91.500  1446.519
    92.000  1451.032
    92.500  1455.511
    93.000  1459.957
    93.500  1464.368
    94.000  1468.753
    94.500  1473.121
    95.000  1477.476
    95.500  1481.819
    96.000  1486.151
    96.500  1490.470
    97.000  1494.772
    97.500  1499.054
    98.000  1503.316
    98.500  1507.558
    99.000  1511.781
    99.500  1515.984
   100.000  1520.165
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   720.966
     1.000   721.013
     1.500   721.091
     2.000   721.200
     2.500   721.340
     3.000   721.511
     3.500   721.713
     4.000   721.946
     4.500   722.210
     5.000   722.505
     5.500   722.830
     6.000   723.186
     6.500   723.573
     7.000   723.990
     7.500   724.438
     8.000   724.916
     8.500   725.424
     9.000   725.962
     9.500   726.531
    10.000   727.129
    10.500   727.756
    11.000   728.413
    11.500   729.099
    12.000   729.815
    12.500   730.560
    13.000   731.333
    13.500   732.135
    14.000   732.965
    14.500   733.824
    15.000   734.711
    15.500   735.626
    16.000   736.568
    16.500   737.538
    17.000   738.535
    17.500   739.558
    18.000   740.609
    18.500   741.686
    19.000   742.790
    19.500   743.919
    20.000   745.074
    20.500   746.255
    21.000   747.461
    21.500   748.692
    22.000   749.947
    22.500   751.227
    23.000   752.532
    23.500   753.860
    24.000   755.211
    24.500   756.586
    25.000   757.984
    25.500   759.405
    26.000   760.848
    26.500   762.314
    27.000   763.801
    27.500   765.309
    28.000   766.839
    28.500   768.390
    29.000   769.961
    29.500   771.552
    30.000   773.164
    30.500   774.795
    31.000   776.445
    31.500   778.115
    32.000   779.803
    32.500   781.509
    33.000   783.234
    33.500   784.976
    34.000   786.735
    34.500   788.511
    35.000   790.304
    35.500   792.114
    36.000   793.939
    36.500   795.780
    37.000   797.637
    37.500   799.508
    38.000   801.394
    38.500   803.295
    39.000   805.209
    39.500   807.137
    40.000   809.079
    40.500   811.033
    41.000   813.000
    41.500   814.980
    42.000   816.971
    42.500   818.974
    43.000   820.988
    43.500   823.014
    44.000   825.050
    44.500   827.096
    45.000   829.153
    45.500   831.219
    46.000   833.294
    46.500   835.379
    47.000   837.472
    47.500   839.573
    48.000   841.683
    48.500   843.801
    49.000   845.926
    49.500   848.058
    50.000   850.196
    50.500   852.342
    51.000   854.494
    51.500   856.651
    52.000   858.815
    52.500   860.983
    53.000   863.157
    53.500   865.335
    54.000   867.518
    54.500   869.706
    55.000   871.897
    55.500   874.092
    56.000   876.290
    56.500   878.492
    57.000   880.697
    57.500   882.904
    58.000   885.114
    58.500   887.326
    59.000   889.540
    59.500   891.756
    60.000   893.973
    60.500   896.192
    61.000   898.412
    61.500   900.633
    62.000   902.855
    62.500   905.077
    63.000   907.299
    63.500   909.522
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   933.020
     1.000   933.087
     1.500   933.198
     2.000   933.352
     2.500   933.552
     3.000   933.795
     3.500   934.083
     4.000   934.414
     4.500   934.790
     5.000   935.209
     5.500   935.673
     6.000   936.180
     6.500   936.731
     7.000   937.325
     7.500   937.963
     8.000   938.645
     8.500   939.369
     9.000   940.137
     9.500   940.947
    10.000   941.801
    10.500   942.697
    11.000   943.635
    11.500   944.616
    12.000   945.639
    12.500   946.704
    13.000   947.810
    13.500   948.958
    14.000   950.148
    14.500   951.378
    15.000   952.650
    15.500   953.962
    16.000   955.315
    16.500   956.707
    17.000   958.140
    17.500   959.613
    18.000   961.125
    18.500   962.676
    19.000   964.266
    19.500   965.895
    20.000   967.562
    20.500   969.268
    21.000   971.011
    21.500   972.792
    22.000   974.610
    22.500   976.465
    23.000   978.357
    23.500   980.285
    24.000   982.249
    24.500   984.249
    25.000   986.285
    25.500   988.356
    26.000   990.461
    26.500   992.601
    27.000   994.776
    27.500   996.984
    28.000   999.226
    28.500  1001.501
    29.000  1003.809
    29.500  1006.150
    30.000  1008.522
    30.500  1010.927
    31.000  1013.364
    31.500  1015.831
    32.000  1018.330
    32.500  1020.859
    33.000  1023.418
    33.500  1026.008
    34.000  1028.627
    34.500  1031.275
    35.000  1033.952
    35.500  1036.658
    36.000  1039.392
    36.500  1042.153
    37.000  1044.943
    37.500  1047.759
    38.000  1050.603
    38.500  1053.473
    39.000  1056.369
    39.500  1059.292
    40.000  1062.239
    40.500  1065.212
    41.000  1068.210
    41.500  1071.232
    42.000  1074.279
    42.500  1077.349
    43.000  1080.443
    43.500  1083.561
    44.000  1086.701
    44.500  1089.864
    45.000  1093.049
    45.500  1096.256
    46.000  1099.485
    46.500  1102.735
    47.000  1106.006
    47.500  1109.298
    48.000  1112.610
    48.500  1115.943
    49.000  1119.295
    49.500  1122.667
    50.000  1126.057
    50.500  1129.467
    51.000  1132.895
    51.500  1136.342
    52.000  1139.806
    52.500  1143.288
    53.000  1146.788
    53.500  1150.305
    54.000  1153.839
    54.500  1157.389
    55.000  1160.955
    55.500  1164.538
    56.000  1168.136
    56.500  1171.749
    57.000  1175.378
    57.500  1179.022
    58.000  1182.680
    58.500  1186.353
    59.000  1190.040
    59.500  1193.741
    60.000  1197.455
    60.500  1201.183
    61.000  1204.923
    61.500  1208.677
    62.000  1212.443
    62.500  1216.222
    63.000  1220.013
    63.500  1223.815
    64.000  1227.630
    64.500  1231.455
    65.000  1235.292
    65.500  1239.140
    66.000  1242.998
    66.500  1246.867
    67.000  1250.746
    67.500  1254.636
    68.000  1258.535
    68.500  1262.443
    69.000  1266.361
    69.500  1270.289
    70.000  1274.225
    70.500  1278.170
    71.000  1282.124
    71.500  1286.085
    72.000  1290.056
    72.500  1294.034
    73.000  1298.019
    73.500  1302.013
    74.000  1306.013
    74.500  1310.021
    75.000  1314.036
    75.500  1318.058
    76.000  1322.087
    76.500  1326.121
    77.000  1330.162
    77.500  1334.210
    78.000  1338.263
    78.500  1342.322
    79.000  1346.386
    79.500  1350.456
    80.000  1354.531
    80.500  1358.611
    81.000  1362.696
    81.500  1366.786
    82.000  1370.881
    82.500  1374.980
    83.000  1379.083
    83.500  1383.190
    84.000  1387.302
    84.500  1391.417
    85.000  1395.536
    85.500  1399.658
    86.000  1403.784
    86.500  1407.913
    87.000  1412.045
    87.500  1416.180
    88.000  1420.318
    88.500  1424.459
    89.000  1428.603
    89.500  1432.748
    90.000  1436.896
    90.500  1441.047
    91.000  1445.199
    91.500  1449.354
    92.000  1453.510
    92.500  1457.668
    93.000  1461.827
    93.500  1465.988
    94.000  1470.151
    94.500  1474.314
    95.000  1478.479
    95.500  1482.645
    96.000  1486.811
    96.500  1490.979
    97.000  1495.147
    97.500  1499.316
    98.000  1503.485
    98.500  1507.655
    99.000  1511.825
    99.500  1515.995
   100.000  1520.165
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    29.000   773.762
    29.500   784.001
    30.000   794.240
    30.500   804.476
    31.000   814.710
    31.500   824.941
    32.000   835.167
    32.500   845.389
    33.000   855.604
    33.500   865.813
    34.000   876.014
    34.500   886.206
    35.000   896.388
    35.500   906.558
    36.000   916.716
    36.500   926.860
    37.000   936.989
    37.500   947.102
    38.000   957.196
    38.500   966.899
    39.000   977.325
    39.500   987.356
    40.000   997.363
    40.500  1007.345
    41.000  1017.299
    41.500  1027.225
    42.000  1037.122
    42.500  1046.987
    43.000  1056.819
    43.500  1066.617
    44.000  1076.381
    44.500  1086.108
    45.000  1095.798
    45.500  1105.195
    46.000  1113.366
    46.500  1121.519
    47.000  1129.655
    47.500  1137.775
    48.000  1145.879
    48.500  1153.966
    49.000  1162.036
    49.500  1170.085
    50.000  1178.108
    50.500  1186.095
    51.000  1194.026
    51.500  1201.942
    52.000  1209.851
    52.500  1217.754
    53.000  1225.652
    53.500  1233.546
    54.000  1241.436
    54.500  1249.322
    55.000  1257.205
    55.500  1265.084
    56.000  1272.960
    56.500  1280.833
    57.000  1288.702
    57.500  1296.568
    58.000  1304.430
    58.500  1312.290
    59.000  1320.145
    59.500  1327.998
    60.000  1335.846
    60.500  1343.691
    61.000  1351.531
    61.500  1359.366
    62.000  1367.196
    62.500  1375.021
    63.000  1382.839
    63.500  1390.651
    64.000  1398.457
    64.500  1406.255
    65.000  1414.047
    65.500  1421.830
    66.000  1429.605
    66.500  1437.372
    67.000  1445.130
    67.500  1452.880
    68.000  1460.620
    68.500  1468.352
    69.000  1476.073
    69.500  1483.786
    70.000  1491.488
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     4.021    61.812     0.150
     4.568    67.911     0.150
     4.568    68.312     0.150
     6.364    95.711     0.150
     8.685   233.011     0.150
     8.685   233.011     0.150
     9.482   304.161     0.150
    10.603   344.131     0.150
    10.621   333.871     0.150
    11.012   342.211     0.150
    13.199   193.791     0.150
    14.197   467.441     0.150
    14.878   193.411     0.150
    15.568   492.401     0.150
    16.162   230.011     0.150
    16.495   233.711     0.150
    21.942   295.911     0.150
    30.756   374.911     0.150
    36.705   428.111     0.150
    40.104   455.812     0.150
    41.079   464.511     0.150
    44.269   500.911     0.150
    50.703   539.911     0.150
    66.335   654.911     0.150
    78.100   727.111     0.150
    79.599   734.411     0.150
    87.294   774.312     0.150
     2.378    40.072     0.150
     4.133    66.463     0.150
    10.647   276.383     0.150
    10.647   343.482     0.150
    12.012   386.283     0.150
     0.941    30.965     0.150
     1.076    20.414     0.150
     3.331    47.504     0.150
     5.840    86.234     0.150
    10.494   339.016     0.150
    13.724   202.812     0.150
     0.500    15.957     0.150
     0.984    17.907     0.150
     0.984    31.287     0.150
     1.853    40.337     0.150
     2.435    78.807     0.150
     3.511    71.337     0.150
     3.937    69.227     0.150
     7.436   136.107     0.150
     9.446   305.007     0.150
    10.489   340.807     0.150
    12.350   185.577     0.150
    12.429   402.407     0.150
     0.758    14.582     0.150
     1.259    24.613     0.150
     3.046    53.422     0.150
     3.346    61.172     0.150
     4.645    74.734     0.150
     1.111    21.547     0.150
     1.436    45.098     0.150
     1.467    26.574     0.150
     1.782    33.875     0.150
     1.949    37.766     0.150
     2.478    44.176     0.150
     3.910    64.395     0.150
     4.011    71.445     0.150
     4.540    85.566     0.150
     4.554    86.387     0.150
     7.513   118.527     0.150
    10.474   155.324     0.150
    23.580   311.188     0.150
    26.853   343.926     0.150
     0.874    33.715     0.150
     0.840    28.844     0.150
     0.840    41.367     0.150
     0.967    34.105     0.150
     0.990    35.297     0.150
     1.080    20.125     0.150
     1.080    35.207     0.150
     1.163    22.215     0.150
     1.163    37.336     0.150
     7.164   127.707     0.150
     7.164   106.676     0.150
     7.164   127.711     0.150
     7.164   228.520     0.150
    10.522   263.016     0.150
    10.522   338.117     0.150
    10.522   152.645     0.150
    10.522   263.012     0.150
    10.522   338.121     0.150
    13.572   191.523     0.150
    22.518   304.145     0.150
    28.580   358.820     0.150
    30.906   388.047     0.150
    30.906   558.645     0.150
    30.906   558.637     0.150
    30.906   378.148     0.150
    30.906   558.641     0.150
    38.192   441.496     0.150
    38.406   443.691     0.150
     0.607    20.617     0.150
     0.755    14.617     0.150
     0.919    16.387     0.150
     1.019    34.078     0.150
     1.019    36.938     0.150
     1.769    49.418     0.150
     3.136    83.250     0.150
     8.853   124.797     0.150
    13.217   195.277     0.150
    16.408   235.078     0.150
     0.316    12.770     0.150
     0.316    12.270     0.150
     0.316     6.660     0.150
     0.316    10.820     0.150
     0.790    14.992     0.150
     0.790    25.590     0.150
     1.059    17.980     0.150
     1.059    35.320     0.150
     1.257    38.703     0.150
     1.738    29.551     0.150
     4.703    60.781     0.150
     5.017    67.320     0.150
     6.026    86.070     0.150
     6.785   113.617     0.150
     6.785   218.590     0.150
     8.793   279.668     0.150
     8.808   127.543     0.150
     8.936   276.480     0.150
    10.549   154.980     0.150
    11.757   168.383     0.150
    12.156   388.641     0.150
    28.199   353.262     0.150
   102.668   846.191     0.150
   112.193  1120.793     0.150
     0.277    13.336     0.150
     0.277     6.648     0.150
     0.277    11.176     0.150
     0.805    15.676     0.150
     0.805    26.367     0.150
     4.655    67.387     0.150
     5.069    74.805     0.150
     5.857   107.426     0.150
     6.306   103.527     0.150
     6.821   102.656     0.150
     6.821   214.945     0.150
     0.236    18.730     0.150
     0.236    22.473     0.150
     0.236    18.730     0.150
     0.236    22.473     0.150
     0.236    23.102     0.150
     0.537    23.723     0.150
     0.537    25.102     0.150
     0.537    31.250     0.150
     0.537    33.723     0.150
     0.617    25.102     0.150
     0.620    25.230     0.150
     0.620    33.730     0.150
     0.620    34.500     0.150
     0.647    25.562     0.150
     0.647    34.520     0.150
     0.647    34.852     0.150
     0.686    24.109     0.150
     0.912    29.930     0.150
     0.912    42.012     0.150
     1.151    35.043     0.150
     0.467    21.047     0.150
     0.467     9.129     0.150
     0.467    15.500     0.150
     0.835    16.469     0.150
     0.835    27.688     0.150
     0.984    16.000     0.150
     0.984    29.289     0.150
     3.189    83.500     0.150
     3.550    94.508     0.150
     4.329   125.590     0.150
     6.216   207.699     0.150
     6.349   120.109     0.150
     6.869   219.914     0.150
     6.869   101.227     0.150
     6.869   219.910     0.150
     8.726   129.559     0.150
    10.528   148.438     0.150
    10.610   157.258     0.150
    11.055   355.539     0.150
    30.755   375.930     0.150
    95.345   800.488     0.150
    95.345  1434.789     0.150
     0.379     7.412     0.150
     0.379    12.613     0.150
     0.555    20.662     0.150
     0.555    27.082     0.150
     0.773    14.873     0.150
     0.773    25.303     0.150
     0.910    31.203     0.150
     0.910    33.223     0.150
     0.910    16.793     0.150
     0.910    29.332     0.150
     1.016    15.582     0.150
     1.074    18.492     0.150
     1.074    39.613     0.150
     1.129    20.283     0.150
     1.129    35.033     0.150
     1.240    21.895     0.150
     1.240    38.176     0.150
     1.727    29.723     0.150
     2.790    85.863     0.150
     3.369    55.742     0.150
     4.629    73.668     0.150
     4.703   130.023     0.150
     6.766   104.113     0.150
     6.766   214.184     0.150
     8.365   124.902     0.150
     8.506   130.162     0.150
     8.788   268.863     0.150
     8.917   277.812     0.150
    10.449   151.604     0.150
    11.171   349.135     0.150
    12.391   187.912     0.150
    13.235   197.293     0.150
    13.796   204.482     0.150
    68.942  5170.584     0.150
    68.947  5170.883     0.150
    68.959  5171.891     0.150
    69.692  5228.412     0.150
     0.302     6.676     0.150
     0.302    10.976     0.150
     0.528    10.306     0.150
     0.646    12.346     0.150
     0.646    20.995     0.150
     0.646    22.915     0.150
     0.646    23.285     0.150
     0.724    13.465     0.150
     0.724    23.405     0.150
     0.724    25.205     0.150
     0.730    13.945     0.150
     0.730    26.815     0.150
     0.808    33.195     0.150
     0.976    18.195     0.150
     0.976    30.915     0.150
     1.034    19.286     0.150
     1.034    32.220     0.150
     1.203    21.426     0.150
     1.203    36.165     0.150
     1.323    23.586     0.150
     1.578    47.401     0.150
     1.578    27.440     0.150
     1.578    47.401     0.150
     1.723    29.134     0.150
     2.020    37.045     0.150
     2.020    62.445     0.150
     2.020    33.904     0.150
     2.020    33.904     0.150
     2.020    62.161     0.150
     2.194    35.719     0.150
     2.194    61.329     0.150
     2.218    37.478     0.150
     2.218    67.036     0.150
     2.367    38.974     0.150
     2.713    42.215     0.150
     2.718    42.755     0.150
     2.744    83.593     0.150
     2.962    88.922     0.150
     3.093    48.832     0.150
     3.207    55.776     0.150
     3.765   101.585     0.150
     7.049   105.479     0.150
     7.049   131.295     0.150
    10.866   157.995     0.150
    38.264   441.596     0.150
     0.279     5.594     0.150
     0.279     9.320     0.150
     0.545    17.758     0.150
     1.346    41.891     0.150
     1.346    24.391     0.150
     1.346    46.117     0.150
     1.370    25.531     0.150
     1.370    43.812     0.150
     1.385    26.594     0.150
     1.478    27.773     0.150
     1.647    50.398     0.150
     1.666    24.422     0.150
     1.899    32.172     0.150
     4.214   120.922     0.150
     4.969    78.992     0.150
     4.969   139.578     0.150
     5.242   137.828     0.150
     5.534    84.758     0.150
     5.678    78.398     0.150
     7.460   108.570     0.150
     7.787   122.938     0.150
     9.452   303.875     0.150
     9.452   303.883     0.150
    10.534   340.148     0.150
    10.731   152.828     0.150
    12.450   181.000     0.150
    13.658   200.422     0.150
     0.285     5.871     0.150
     0.285     9.840     0.150
     0.285     5.859     0.150
     0.558    23.041     0.150
     0.558    28.400     0.150
     1.340    24.160     0.150
     1.340    41.391     0.150
     1.340    49.631     0.150
     1.906    32.070     0.150
     4.026    63.465     0.150
     4.668    70.045     0.150
     5.240   170.840     0.150
     6.814   101.301     0.150
     6.903   127.180     0.150
     7.056   231.670     0.150
     7.459   135.262     0.150
     8.544   272.471     0.150
     8.577   129.439     0.150
     8.577   272.539     0.150
     9.455   182.520     0.150
    10.547   328.207     0.150
    12.457   390.385     0.150
    12.653   179.910     0.150
    12.751   181.689     0.150
    12.776   188.078     0.150
    13.489   189.451     0.150
    15.792   222.791     0.150
    86.744   760.221     0.150
    95.999  1444.820     0.150
    95.999  1484.121     0.150
   107.725   856.820     0.150
     0.288     5.906     0.150
     0.288     9.641     0.150
     0.288     5.930     0.150
     0.289     6.008     0.150
     0.552    18.828     0.150
     0.574    23.891     0.150
     1.338    24.367     0.150
     1.338    41.445     0.150
     1.338    24.367     0.150
     1.338    41.445     0.150
     1.338    24.445     0.150
     1.338    47.961     0.150
     1.364    25.688     0.150
     1.364    43.547     0.150
     4.205    69.156     0.150
     4.205   118.148     0.150
     5.236   147.836     0.150
     6.515    96.984     0.150
     7.454   136.742     0.150
     7.844   123.484     0.150
     8.867   135.039     0.150
     9.130   131.766     0.150
     9.184   129.961     0.150
     9.854   142.156     0.150
    10.544   320.805     0.150
    12.112   175.656     0.150
    12.298   177.188     0.150
    13.702   201.867     0.150
     0.564    10.596     0.150
     0.564    18.926     0.150
     1.186    30.176     0.150
     1.203    31.686     0.150
     1.343    24.404     0.150
     1.343    34.545     0.150
     1.343    24.404     0.150
     1.343    34.545     0.150
     1.343    24.246     0.150
     1.343    53.035     0.150
     1.375    25.846     0.150
     1.375    44.775     0.150
     1.646    52.916     0.150
     1.675    29.477     0.150
     2.430    79.176     0.150
     3.569   102.865     0.150
     3.765   118.494     0.150
     4.661    74.686     0.150
     4.661    74.686     0.150
     4.970    76.955     0.150
     4.943    74.855     0.150
     4.943   134.416     0.150
     7.464   125.416     0.150
     8.551   272.785     0.150
     8.794   129.166     0.150
     9.118   141.676     0.150
     9.537   130.225     0.150
    12.389   181.705     0.150
    12.779   191.705     0.150
    12.998   193.680     0.150
    13.144   195.686     0.150
    13.716   203.395     0.150
    13.951   205.883     0.150
    17.037   244.965     0.150
    17.190   245.984     0.150
    20.608   288.135     0.150
    21.599   297.635     0.150
    55.450  4108.314     0.150
    69.581  5244.535     0.150
    69.599  5244.539     0.150
    70.306  5269.398     0.150
    70.323  5276.635     0.150
     0.282     5.875     0.150
     0.282     9.523     0.150
     0.282     5.895     0.150
     0.578    21.035     0.150
     0.694    28.215     0.150
     1.177    22.055     0.150
     1.343    24.395     0.150
     1.343    41.605     0.150
     1.343    24.426     0.150
     1.370    25.555     0.150
     1.370    43.797     0.150
     1.430    26.344     0.150
     1.905    32.047     0.150
     1.905    38.676     0.150
     2.658    46.070     0.150
     6.809   102.664     0.150
     9.008   133.387     0.150
     0.269     5.723     0.150
     0.269     9.180     0.150
     0.269     5.742     0.150
     0.271     5.742     0.150
     0.895    29.832     0.150
     1.194    22.012     0.150
     1.210    41.641     0.150
     1.355    40.820     0.150
     1.355    24.371     0.150
     1.355    40.820     0.150
     1.355    46.180     0.150
     1.355    49.941     0.150
     1.386    25.570     0.150
     1.386    43.980     0.150
     1.658    29.730     0.150
     3.837    58.301     0.150
     4.145    75.672     0.150
     4.223   127.695     0.150
     4.982   151.898     0.150
     4.982    79.883     0.150
     8.888   133.980     0.150
    10.752   154.340     0.150
     0.271     5.672     0.150
     0.271     9.582     0.150
     0.271     5.590     0.150
     0.271     9.590     0.150
     1.178    22.000     0.150
     1.178    21.973     0.150
     1.193    22.332     0.150
     1.355    24.500     0.150
     1.355    49.883     0.150
     1.355    51.891     0.150
     1.355    24.500     0.150
     1.355    42.289     0.150
     1.377    25.371     0.150
     1.377    43.551     0.150
     1.377    46.672     0.150
     1.437    26.289     0.150
     1.904    31.910     0.150
     2.433    39.680     0.150
     3.599   105.750     0.150
     4.222   111.539     0.150
     4.978   150.859     0.150
     4.978    76.242     0.150
     6.811   106.812     0.150
     8.772   128.633     0.150
    10.529   325.262     0.150
    11.248   162.223     0.150
    11.248   280.672     0.150
    11.786   175.961     0.150
    12.307   319.961     0.150
    13.036   188.562     0.150
    13.369   194.230     0.150
    14.640   215.738     0.150
    14.640   218.711     0.150
    14.699   219.461     0.150
    15.317   220.461     0.150
    18.543   263.656     0.150
    18.807   266.754     0.150
     0.232     5.852     0.150
     0.232     9.891     0.150
     0.604    11.945     0.150
     1.059    19.523     0.150
     1.059    33.820     0.150
     1.059    38.797     0.150
     1.059    39.195     0.150
     1.059    19.461     0.150
     1.059    33.891     0.150
     1.198    21.820     0.150
     1.206    22.141     0.150
     1.206    37.914     0.150
     1.254    24.414     0.150
     1.264    23.680     0.150
     1.390    24.656     0.150
     2.600    43.742     0.150
     2.955    52.031     0.150
     3.739    60.016     0.150
     4.718    72.852     0.150
     6.455    96.836     0.150
     8.517   126.562     0.150
     9.129   129.430     0.150
    10.808   162.070     0.150
    10.808   282.672     0.150
    11.194   158.477     0.150
    12.001   181.523     0.150
    12.215   184.727     0.150
    12.564   184.508     0.150
    15.538   397.766     0.150
    15.647   222.875     0.150
    19.103   262.836     0.150
    95.721     4.602     0.150
    95.721     7.797     0.150
     0.275     5.816     0.150
     0.275     5.844     0.150
     0.564    21.906     0.150
     0.578    22.387     0.150
     0.705    29.727     0.150
     1.192    36.457     0.150
     1.350    24.707     0.150
     1.350    39.555     0.150
     1.350    24.797     0.150
     1.350    50.707     0.150
     1.382    25.477     0.150
     1.382    43.367     0.150
     1.382    47.188     0.150
     1.920    32.457     0.150
     2.437    40.344     0.150
     2.437    44.285     0.150
     2.986    48.918     0.150
     4.140    64.926     0.150
     4.140   132.457     0.150
     6.282    93.957     0.150
     7.472   136.816     0.150
     7.472   234.617     0.150
     8.886   130.727     0.150
     0.279     5.723     0.150
     0.279     9.023     0.150
     0.281     5.793     0.150
     0.576    22.965     0.150
     0.700    25.664     0.150
     1.186    23.816     0.150
     1.346    24.785     0.150
     1.346    42.094     0.150
     1.346    24.836     0.150
     1.376    25.453     0.150
     1.376    43.965     0.150
     1.648    49.734     0.150
     1.676    50.520     0.150
     1.914    38.203     0.150
     2.432    40.273     0.150
     2.432    77.816     0.150
     0.279     6.430     0.150
     0.279     6.420     0.150
     0.279     9.818     0.150
     0.279     6.449     0.150
     0.572    24.199     0.150
     0.571    23.639     0.150
     0.703    13.920     0.150
     0.703    24.520     0.150
     1.346    24.959     0.150
     1.346    42.949     0.150
     1.346    49.699     0.150
     1.381    25.100     0.150
     1.381    46.199     0.150
     1.682    31.416     0.150
     4.292   112.430     0.150
     0.277     5.611     0.150
     0.277     9.291     0.150
     0.279    10.131     0.150
     0.556    22.480     0.150
     0.580    21.320     0.150
     0.580    22.861     0.150
     1.183    22.160     0.150
     1.348    24.682     0.150
     1.376    25.441     0.150
     1.376    43.602     0.150
     1.448    43.771     0.150
     2.987    49.619     0.150
     0.268     5.680     0.150
     0.268     5.620     0.150
     0.268     9.430     0.150
     0.270    10.470     0.150
     0.270     5.690     0.150
     0.270     9.450     0.150
     0.582    13.271     0.150
     0.582    21.220     0.150
     0.582    22.220     0.150
     0.582    24.180     0.150
     1.356    40.910     0.150
     1.356    24.210     0.150
     1.356    40.910     0.150
     1.390    24.980     0.150
     1.449    26.355     0.150
     1.928    36.811     0.150
     4.286    62.601     0.150
     4.286   130.521     0.150
     0.289     6.127     0.150
     0.289     9.387     0.150
     1.190    22.377     0.150
     1.190    22.316     0.150
     1.336    24.537     0.150
     1.336    46.566     0.150
     1.336    24.527     0.150
     1.336    41.336     0.150
     1.372    80.377     0.150
     1.432    26.637     0.150
     1.432    26.617     0.150
     1.471    27.006     0.150
     1.581    27.496     0.150
     1.640    31.236     0.150
     1.920    32.496     0.150
     1.895    35.057     0.150
     2.420  1040.967     0.150
     2.427    40.047     0.150
     2.427    75.146     0.150
     2.916    47.277     0.150
     6.521   104.496     0.150
     6.832   175.566     0.150
     7.430   117.637     0.150
     7.462   137.541     0.150
     7.462   234.217     0.150
     7.849   123.557     0.150
     8.152   126.117     0.150
     8.562   275.467     0.150
     8.562   129.277     0.150
     8.562   275.467     0.150
     8.803   136.387     0.150
     9.027   129.717     0.150
    12.412   186.537     0.150
    13.621   201.166     0.150
    13.701   205.656     0.150
    13.718   202.246     0.150
    15.494     7.061     0.150
    17.201   246.117     0.150
     0.289     6.191     0.150
     0.289     8.871     0.150
     0.562    21.242     0.150
     0.576    19.662     0.150
     1.190    22.412     0.150
     1.190    22.412     0.150
     1.336    24.602     0.150
     1.336    50.152     0.150
     1.336    24.631     0.150
     1.336    41.742     0.150
     1.372    25.441     0.150
     1.372    46.121     0.150
     1.432    26.762     0.150
     1.640    29.791     0.150
     2.428    40.285     0.150
     5.242   172.512     0.150
     7.462   136.092     0.150
     0.281     9.534     0.150
     0.281     9.444     0.150
     0.281     9.534     0.150
     0.557    19.584     0.150
     0.577    21.944     0.150
     1.181    22.414     0.150
     1.181    22.354     0.150
     1.344    24.734     0.150
     1.344    46.834     0.150
     1.344    24.664     0.150
     1.344    43.254     0.150
     1.372    25.374     0.150
     1.432    26.726     0.150
     1.444    26.414     0.150
     1.671    29.283     0.150
     2.428    45.304     0.150
     2.428    75.764     0.150
     2.650    71.374     0.150
     3.589    59.594     0.150
     3.763   118.679     0.150
     4.097   126.490     0.150
     4.211    69.194     0.150
     4.969    81.274     0.150
     5.459    85.984     0.150
     6.752   132.144     0.150
     6.813    99.202     0.150
     7.059   105.142     0.150
     7.333   116.444     0.150
     7.430   136.764     0.150
     7.462   111.254     0.150
     7.462   136.894     0.150
     7.462   136.889     0.150
     7.462   230.239     0.150
     7.767   124.494     0.150
     8.377   128.414     0.150
     8.465   135.984     0.150
     8.543   260.139     0.150
     8.788   126.080     0.150
     8.875   135.654     0.150
     8.875   289.304     0.150
     8.981   294.874     0.150
     9.112   130.184     0.150
     9.140   140.504     0.150
     9.197   133.308     0.150
     9.197   141.084     0.150
     9.458   293.014     0.150
    10.544   158.834     0.150
    10.545   326.439     0.150
    12.459   180.064     0.150
    17.007   240.114     0.150
     0.285    11.340     0.150
     0.733    21.719     0.150
     0.843    15.930     0.150
     0.833    24.820     0.150
     0.900    17.961     0.150
     0.892    26.898     0.150
     1.164    36.445     0.150
     1.295    24.531     0.150
     1.414    25.188     0.150
     1.414    43.160     0.150
     1.530    44.352     0.150
     1.680    28.820     0.150
     1.680    48.949     0.150
     0.260     5.848     0.150
     0.260     8.070     0.150
     0.262    10.547     0.150
     0.262     5.738     0.150
     0.596    25.449     0.150
     1.192    37.660     0.150
     1.207    46.320     0.150
     1.365    49.469     0.150
     1.365    25.238     0.150
     1.365    25.238     0.150
     1.365    42.840     0.150
     1.391    25.730     0.150
     1.391    44.367     0.150
     1.391    48.809     0.150
     1.451    27.340     0.150
     1.451    27.438     0.150
     1.499    28.289     0.150
     1.666    30.270     0.150
     1.922    29.988     0.150
     2.447    40.945     0.150
     2.447    77.645     0.150
     2.447    77.598     0.150
     2.514    74.797     0.150
     3.184    50.395     0.150
     4.117   126.816     0.150
     4.268   118.809     0.150
     4.990    79.059     0.150
     5.601    92.379     0.150
     6.272   169.199     0.150
     7.342   115.180     0.150
     7.872   123.527     0.150
     8.379   124.570     0.150
     8.538   270.039     0.150
     8.678   127.188     0.150
     9.209   141.410     0.150
    10.528   151.617     0.150
    11.409   164.309     0.150
    14.655   217.598     0.150
    14.714   219.641     0.150
     0.205     7.898     0.150
     0.541     9.488     0.150
     0.541    16.479     0.150
     0.541    16.988     0.150
     0.644    11.568     0.150
     0.644    20.779     0.150
     0.644    25.439     0.150
     1.241    20.238     0.150
     1.420    25.430     0.150
     1.503    27.023     0.150
     3.478    61.236     0.150
     3.835   123.994     0.150
     4.287   116.779     0.150
     0.616    22.793     0.150
     1.213    24.715     0.150
     1.213    42.293     0.150
     1.384    48.465     0.150
     1.384    25.375     0.150
     1.466    27.297     0.150
     1.484    47.633     0.150
     1.700    51.414     0.150
     1.776    56.602     0.150
     2.065    63.859     0.150
     2.462    40.820     0.150
     3.200    50.555     0.150
     3.442   106.078     0.150
     0.231     4.973     0.150
     0.231     7.793     0.150
     0.231     7.875     0.150
     0.233     9.113     0.150
     0.233     7.883     0.150
     0.626    24.582     0.150
     1.205    24.453     0.150
     1.205    42.504     0.150
     1.218    42.484     0.150
     1.395    25.465     0.150
     1.395    43.902     0.150
     1.475    27.324     0.150
     2.472    40.883     0.150
     2.472    76.406     0.150
     2.472    76.504     0.150
     3.205    52.562     0.150
     4.194    63.781     0.150
     4.681   151.574     0.150
     6.265    94.625     0.150
     8.376   124.805     0.150
     0.282     6.094     0.150
     0.282     9.594     0.150
     1.342    24.773     0.150
     1.342    42.664     0.150
     1.342    46.473     0.150
     1.342    24.793     0.150
     1.342    42.582     0.150
     1.375    25.473     0.150
     1.375    46.352     0.150
     1.427    26.754     0.150
     1.443    26.414     0.150
     1.916    32.613     0.150
     2.430    40.301     0.150
     2.657    43.531     0.150
     2.738    86.551     0.150
     4.286   121.164     0.150
     6.821    98.113     0.150
     7.064   104.344     0.150
     8.796   127.289     0.150
     8.883   139.434     0.150
     9.021   131.172     0.150
    13.622   192.871     0.150
     0.498    10.957     0.150
     0.498    18.418     0.150
     0.751    23.117     0.150
     0.751    14.328     0.150
     0.751    29.039     0.150
     0.846    25.688     0.150
     0.865    16.117     0.150
     1.623    46.402     0.150
     2.581    40.672     0.150
     4.071   123.176     0.150
     4.109    61.121     0.150
     4.370   132.176     0.150
     4.487    68.188     0.150
     5.380    82.367     0.150
     6.225    93.848     0.150
     6.559    94.656     0.150
     8.805   129.586     0.150
    10.936   157.078     0.150
    19.552   262.289     0.150
     0.644    11.207     0.150
     0.644    19.938     0.150
     0.930    18.586     0.150
     0.910    35.086     0.150
     1.175    20.816     0.150
     1.229    22.316     0.150
     1.251    22.789     0.150
     1.936    67.809     0.150
     2.374    40.379     0.150
     4.480    69.379     0.150
     4.757   113.520     0.150
     4.808    75.156     0.150
     4.811   116.488     0.150
     4.978    73.699     0.150
    10.458   245.688     0.150
     0.367    15.094     0.150
     0.618    12.453     0.150
     0.618    20.320     0.150
     0.620    12.492     0.150
     0.620    12.492     0.150
     0.620    20.312     0.150
     0.645    13.688     0.150
     0.963    39.938     0.150
     0.963    40.008     0.150
     1.013    18.953     0.150
     1.013    18.953     0.150
     1.013    32.000     0.150
     1.046    18.898     0.150
     1.046    31.922     0.150
     1.046    34.633     0.150
     1.098    20.672     0.150
     1.109    20.422     0.150
     1.370    26.258     0.150
     1.711    49.273     0.150
     1.711    28.898     0.150
     3.350    51.422     0.150
     0.346    14.076     0.150
     0.578    13.086     0.150
     0.578    21.977     0.150
     0.747    14.676     0.150
     0.747    14.676     0.150
     0.747    23.957     0.150
     0.889    30.365     0.150
     0.889    16.916     0.150
     0.889    27.916     0.150
     0.889    16.877     0.150
     0.925    16.826     0.150
     0.925    28.166     0.150
     0.925    28.826     0.150
     0.975    18.816     0.150
     0.975    18.756     0.150
     0.983    18.377     0.150
     0.983    30.537     0.150
     1.179    21.686     0.150
     1.276    39.711     0.150
     1.564    47.418     0.150
     1.647    46.156     0.150
     1.972    47.826     0.150
     1.974    47.826     0.150
     2.372    53.227     0.150
     3.328    69.727     0.150
     5.258    83.916     0.150
     0.545    11.094     0.150
     0.836    18.164     0.150
     0.836    30.422     0.150
     0.904    32.230     0.150
     1.094    19.871     0.150
     1.094    33.402     0.150
     1.094    35.414     0.150
     1.148    21.680     0.150
     1.237    23.164     0.150
     1.374    23.898     0.150
     2.150    68.965     0.150
     2.605    41.145     0.150
     0.580    12.445     0.150
     0.746    14.672     0.150
     0.746    24.383     0.150
     0.747    26.156     0.150
     0.891    16.977     0.150
     0.891    28.812     0.150
     0.891    28.766     0.150
     0.891    31.203     0.150
     0.925    16.906     0.150
     0.925    32.414     0.150
     0.945    33.172     0.150
     0.945    19.562     0.150
     0.945    33.172     0.150
     0.976    18.750     0.150
     1.180    21.805     0.150
     1.646    28.445     0.150
     1.646    28.445     0.150
     3.128    47.703     0.150
     3.451    53.555     0.150
     3.751    96.352     0.150
     0.403    17.805     0.150
     0.403    18.562     0.150
     0.444     8.930     0.150
     0.444    14.570     0.150
     0.446     8.539     0.150
     0.446    14.359     0.150
     0.707    16.086     0.150
     0.707    28.883     0.150
     0.795    25.500     0.150
     1.244    22.406     0.150
     1.244    38.336     0.150
     1.244    22.406     0.150
     1.244    38.336     0.150
     1.244    22.500     0.150
     1.244    46.742     0.150
     1.354    24.070     0.150
     1.354    40.945     0.150
     1.354    24.203     0.150
     1.373    24.430     0.150
     1.373    41.992     0.150
     1.373    48.930     0.150
     1.575    27.781     0.150
     1.575    27.766     0.150
     2.415    41.891     0.150
     2.415    74.461     0.150
     3.899    65.633     0.150
     4.125    66.836     0.150
     4.518    83.891     0.150
     4.518   124.336     0.150
     4.903    78.031     0.150
     5.219    95.383     0.150
     5.731   156.953     0.150
     6.893   108.211     0.150
     7.108   109.211     0.150
     7.441   115.461     0.150
     7.441   233.391     0.150
     7.899   122.312     0.150
     8.774   267.680     0.150
     8.774   267.680     0.150
     8.911   135.453     0.150
     9.114   136.562     0.150
     9.254   141.453     0.150
     9.511   294.312     0.150
    10.031   145.461     0.150
    12.369   177.805     0.150
    13.911   198.484     0.150
    14.817   382.883     0.150
    15.653   231.484     0.150
    42.154   479.734     0.150
    69.362  5245.430     0.150
    69.367  5245.492     0.150
    69.379  5246.812     0.150
     0.448     8.980     0.150
     0.448    14.633     0.150
     1.231    48.703     0.150
     1.356    24.531     0.150
     1.356    41.594     0.150
     1.356    47.934     0.150
     1.406    26.383     0.150
     1.691    30.793     0.150
     1.915    55.844     0.150
     2.765    43.895     0.150
     3.318   101.445     0.150
     4.109    67.352     0.150
     4.855    71.363     0.150
     5.203    84.301     0.150
     5.203   159.461     0.150
     7.090   109.492     0.150
     7.425   238.461     0.150
     9.305   133.230     0.150
    10.845   155.363     0.150
    11.793   167.082     0.150
     0.399    10.679     0.150
     0.399    18.049     0.150
     0.785    14.519     0.150
     0.785    24.648     0.150
     0.785    24.699     0.150
     0.787    14.549     0.150
     0.787    14.568     0.150
     0.787    24.719     0.150
     0.856    15.799     0.150
     0.856    27.019     0.150
     0.965    17.379     0.150
     1.021    18.269     0.150
     1.021    30.639     0.150
     1.021    18.159     0.150
     1.067    19.759     0.150
     1.096    22.009     0.150
     1.149    21.269     0.150
     1.149    39.068     0.150
     1.186    20.889     0.150
     1.330    23.739     0.150
     1.540    45.973     0.150
     1.949    59.119     0.150
     3.593    55.338     0.150
     6.415    95.861     0.150
     0.431     8.500     0.150
     0.431    14.471     0.150
     0.431     8.480     0.150
     0.431    14.520     0.150
     0.433     8.471     0.150
     1.060    17.619     0.150
     1.060    29.760     0.150
     1.060    32.209     0.150
     1.060    17.609     0.150
     1.060    29.689     0.150
     0.895    30.391     0.150
     1.285    22.240     0.150
     1.315    24.090     0.150
     1.315    41.680     0.150
     1.314    48.100     0.150
     1.366    24.100     0.150
     1.366    42.430     0.150
     1.355    23.801     0.150
     1.355    23.801     0.150
     1.355    42.840     0.150
     1.416    25.949     0.150
     1.450    24.260     0.150
     1.450    44.379     0.150
     1.523    26.859     0.150
     1.574    27.391     0.150
     1.614    28.551     0.150
     1.614    27.820     0.150
     1.643    28.699     0.150
     1.668    28.990     0.150
     1.930    33.379     0.150
     2.029    33.641     0.150
     2.029    33.689     0.150
     2.410    40.340     0.150
     2.410    40.359     0.150
     2.743    43.320     0.150
     2.743    76.910     0.150
     3.182    91.904     0.150
     3.481    55.580     0.150
     3.738    59.621     0.150
     4.120    64.840     0.150
     4.120    64.879     0.150
     4.498    68.080     0.150
     4.837    71.990     0.150
     4.837    71.990     0.150
     4.837   126.430     0.150
     4.902    75.641     0.150
     5.055    73.301     0.150
     5.055   130.959     0.150
     5.055    73.301     0.150
     5.055   130.959     0.150
     5.511   142.900     0.150
     6.884   101.850     0.150
     6.884   178.459     0.150
     7.034   183.189     0.150
     7.034   104.270     0.150
     7.034   183.189     0.150
     7.437   135.215     0.150
     8.673   268.822     0.150
     8.673   216.209     0.150
     8.673   129.199     0.150
     8.673   216.209     0.150
     8.753   128.590     0.150
     9.009   132.000     0.150
    11.808   364.357     0.150
    11.808   174.641     0.150
    12.571   394.539     0.150
    15.908   226.539     0.150
    15.908   226.539     0.150
    17.340   245.709     0.150
    21.370   291.279     0.150
    22.799   305.240     0.150
    23.833   315.750     0.150
    25.252   330.650     0.150
    25.497   330.061     0.150
    38.580   446.529     0.150
    40.654   463.279     0.150
    46.134  3425.641     0.150
    47.000   514.449     0.150
    56.763   586.449     0.150
    58.318  4339.539     0.150
    65.865   649.215     0.150
    69.378  5247.594     0.150
    69.383  5185.525     0.150
    69.396  5229.699     0.150
    80.085   734.449     0.150
    82.630   744.516     0.150
   145.620  1181.650     0.150
     0.509    17.141     0.150
     0.509    10.211     0.150
     0.509    17.070     0.150
     0.510    10.250     0.150
     0.933    14.922     0.150
     0.933    24.852     0.150
     0.933    24.891     0.150
     1.106    21.320     0.150
     1.151    20.578     0.150
     1.240    23.227     0.150
     1.323    24.258     0.150
     1.323    24.250     0.150
     1.408    26.617     0.150
     1.542    28.648     0.150
     1.599    30.242     0.150
     1.599    51.398     0.150
     1.599    30.109     0.150
     0.610    10.135     0.150
     0.610    16.686     0.150
     1.533    50.645     0.150
     1.606    55.205     0.150
     4.342   131.600     0.150
     4.341   140.061     0.150
     0.489    10.105     0.150
     0.489    15.773     0.150
     0.490     9.125     0.150
     0.599    10.695     0.150
     0.920    13.645     0.150
     0.920    23.184     0.150
     0.920    13.637     0.150
     0.920    23.227     0.150
     1.223    22.773     0.150
     1.335    24.504     0.150
     1.335    41.387     0.150
     2.220    38.844     0.150
     3.910    58.887     0.150
     5.564    81.094     0.150
     5.902    86.164     0.150
     0.377     8.115     0.150
     0.514    10.285     0.150
     0.514    10.285     0.150
     0.514    16.455     0.150
     0.515    10.295     0.150
     0.515    15.846     0.150
     0.515    10.045     0.150
     0.515    15.846     0.150
     0.595    10.806     0.150
     0.595    19.006     0.150
     0.922    14.615     0.150
     0.922    24.745     0.150
     0.877    31.186     0.150
     0.877    18.346     0.150
     0.877    31.186     0.150
     1.156    20.705     0.150
     1.210    39.056     0.150
     1.210    22.391     0.150
     1.254    23.495     0.150
     1.254    23.495     0.150
     1.254    38.545     0.150
     1.336    24.545     0.150
     1.336    41.315     0.150
     1.406    24.688     0.150
     1.586    27.226     0.150
     1.586    27.031     0.150
     1.586    50.562     0.150
     2.327    40.186     0.150
     2.953    47.120     0.150
     4.061    62.469     0.150
     5.227    79.944     0.150
     6.605   173.186     0.150
     6.605    98.663     0.150
     0.504     9.929     0.150
     0.504    16.639     0.150
     0.504     9.929     0.150
     0.504    16.639     0.150
     0.505     9.939     0.150
     0.505    16.739     0.150
     0.505     9.979     0.150
     0.505     9.979     0.150
     0.505    16.579     0.150
     0.599    10.449     0.150
     0.918    14.599     0.150
     0.918    24.649     0.150
     0.918    14.459     0.150
     0.918    24.489     0.150
     0.888    17.889     0.150
     0.888    30.219     0.150
     1.051    19.479     0.150
     1.100    41.169     0.150
     1.100    41.569     0.150
     1.162    20.289     0.150
     1.216    22.059     0.150
     1.256    23.189     0.150
     1.256    23.279     0.150
     1.256    39.839     0.150
     1.256    23.279     0.150
     1.256    39.839     0.150
     1.312    25.729     0.150
     1.339    24.179     0.150
     1.339    41.179     0.150
     1.393    26.349     0.150
     1.415    24.344     0.150
     2.176    40.829     0.150
     2.315    36.832     0.150
     3.930   119.299     0.150
     3.947   119.930     0.150
     4.069    60.963     0.150
     6.612   216.949     0.150
    13.601   191.649     0.150
     0.499    10.017     0.150
     0.499    10.017     0.150
     0.499    15.986     0.150
     0.499     9.997     0.150
     0.499    16.826     0.150
     0.499     9.946     0.150
     0.499     9.946     0.150
     0.499    15.696     0.150
     0.599    10.707     0.150
     0.599    18.896     0.150
     0.919    14.316     0.150
     0.919    24.486     0.150
     0.919    14.347     0.150
     0.919    24.387     0.150
     0.885    16.727     0.150
     0.896    18.406     0.150
     0.896    30.377     0.150
     1.165    20.597     0.150
     1.219    21.981     0.150
     1.254    23.427     0.150
     1.254    23.517     0.150
     1.254    39.847     0.150
     1.254    23.517     0.150
     1.254    39.847     0.150
     1.337    24.486     0.150
     1.337    41.727     0.150
     1.397    26.667     0.150
     1.419    24.581     0.150
     1.419    42.019     0.150
     1.605    27.130     0.150
     2.215    35.639     0.150
     0.445     8.918     0.150
     0.765    13.518     0.150
     0.765    23.887     0.150
     0.886    16.957     0.150
     1.073    17.947     0.150
     1.073    29.877     0.150
     1.073    17.918     0.150
     1.073    29.877     0.150
     1.240    47.428     0.150
     1.240    22.377     0.150
     1.240    22.307     0.150
     1.366    24.367     0.150
     1.416    26.018     0.150
     1.446    24.928     0.150
     1.570    27.746     0.150
     1.701    30.402     0.150
     1.706    31.227     0.150
     1.924    33.303     0.150
     1.924    58.285     0.150
     2.037    36.104     0.150
     2.409    39.516     0.150
     2.476    49.816     0.150
     2.625    45.607     0.150
     2.757    43.594     0.150
     2.757    76.344     0.150
     2.773    46.467     0.150
     5.997    88.668     0.150
     6.314    92.316     0.150
     0.274     5.885     0.150
     0.274     9.665     0.150
     0.395     8.605     0.150
     0.618    11.735     0.150
     0.618    11.765     0.150
     0.618    20.075     0.150
     0.773    13.805     0.150
     0.773    22.985     0.150
     0.809    24.995     0.150
     0.817    15.295     0.150
     0.817    25.345     0.150
     0.817    15.325     0.150
     0.817    25.425     0.150
     0.988    17.885     0.150
     1.008    18.445     0.150
     1.071    32.925     0.150
     1.071    19.395     0.150
     1.096    19.435     0.150
     1.285    21.575     0.150
     1.350    40.475     0.150
     1.562    25.705     0.150
     1.562    44.155     0.150
     1.562    48.105     0.150
     1.680    28.145     0.150
     2.376    39.040     0.150
     0.452     9.195     0.150
     0.649    12.094     0.150
     0.870    13.547     0.150
     1.082    19.688     0.150
     1.216    21.016     0.150
     1.216    35.555     0.150
     1.271    22.617     0.150
     1.301    23.672     0.150
     1.301    40.109     0.150
     1.301    23.586     0.150
     1.301    40.117     0.150
     1.961    59.484     0.150
     2.311    38.766     0.150
     2.383    37.203     0.150
     5.001    73.664     0.150
     5.475    80.156     0.150
     6.479    94.945     0.150
     7.065   101.398     0.150
     0.366     7.498     0.150
     0.366    12.807     0.150
     0.356     6.088     0.150
     0.652    12.078     0.150
     0.652    20.717     0.150
     0.813    14.547     0.150
     0.852    15.377     0.150
     0.895    27.816     0.150
     0.982    16.957     0.150
     0.982    29.316     0.150
     1.022    31.008     0.150
     1.137    20.338     0.150
     1.555    25.797     0.150
     1.555    24.168     0.150
     1.764    51.328     0.150
     1.764    29.877     0.150
     2.887    42.777     0.150
     0.665    23.627     0.150
     0.665    26.657     0.150
     1.076    17.137     0.150
     1.076    30.237     0.150
     1.076    31.837     0.150
     1.236    44.217     0.150
     5.699   175.459     0.150
     7.431   120.604     0.150
     7.431   135.312     0.150
    10.774   158.339     0.150
    38.638   449.820     0.150
     0.438     9.051     0.150
     0.438    13.570     0.150
     0.438     9.090     0.150
     0.438     9.051     0.150
     0.874    13.779     0.150
     0.874    23.811     0.150
     0.874    13.730     0.150
     0.874    23.811     0.150
     0.944    17.529     0.150
     0.953    19.439     0.150
     1.070    33.500     0.150
     1.178    20.330     0.150
     1.216    21.150     0.150
     1.221    21.150     0.150
     1.221    35.910     0.150
     1.275    22.131     0.150
     1.275    39.180     0.150
     1.295    40.150     0.150
     1.295    23.439     0.150
     1.295    40.189     0.150
     1.438    25.590     0.150
     1.438    43.721     0.150
     1.657    28.801     0.150
     1.661    30.189     0.150
     1.753    30.551     0.150
     1.812    54.561     0.150
     1.946    32.631     0.150
     1.946    58.709     0.150
     1.945    40.170     0.150
     2.271    44.750     0.150
     3.848    77.891     0.150
     0.367    10.138     0.150
     0.367    17.269     0.150
     0.367    17.668     0.150
     0.531    10.868     0.150
     0.531    18.428     0.150
     0.532     9.908     0.150
     0.994    16.099     0.150
     0.994    26.729     0.150
     0.994    16.088     0.150
     0.994    28.588     0.150
     0.856    16.738     0.150
     0.856    29.188     0.150
     0.884    16.998     0.150
     0.903    18.099     0.150
     0.959    30.868     0.150
     1.112    19.309     0.150
     1.112    32.248     0.150
     1.112    19.318     0.150
     1.112    32.358     0.150
     1.165    21.388     0.150
     1.165    35.628     0.150
     1.165    21.388     0.150
     1.165    35.678     0.150
     1.195    22.198     0.150
     1.241    23.408     0.150
     1.285    23.198     0.150
     1.278    24.508     0.150
     1.318    23.809     0.150
     1.385    44.448     0.150
     1.385    25.118     0.150
     1.438    25.658     0.150
     1.496    26.769     0.150
     1.496    26.798     0.150
     1.537    27.528     0.150
     1.556    46.378     0.150
     1.617    27.908     0.150
     1.838    32.288     0.150
     2.158    38.059     0.150
     2.402    38.019     0.150
     0.230     5.430     0.150
     0.408     8.480     0.150
     0.408    14.289     0.150
     0.408     7.520     0.150
     0.408    13.000     0.150
     0.734    11.422     0.150
     0.734    18.891     0.150
     0.734    11.402     0.150
     0.734    18.980     0.150
     0.638    13.789     0.150
     0.638    24.082     0.150
     0.638    26.750     0.150
     0.975    19.621     0.150
     0.975    34.531     0.150
     0.980    18.512     0.150
     0.980    43.551     0.150
     0.980    44.012     0.150
     1.314    22.969     0.150
     1.332    23.672     0.150
     1.332    23.410     0.150
     1.332    40.109     0.150
     1.331    25.469     0.150
     1.386    23.566     0.150
     1.386    24.609     0.150
     1.525    28.242     0.150
     1.525    28.242     0.150
     1.575    47.801     0.150
     1.665    28.059     0.150
     1.729    28.496     0.150
     1.894    57.520     0.150
     2.098    37.250     0.150
     2.198    35.871     0.150
     5.554    83.391     0.150
     6.488    96.809     0.150
     6.902   102.262     0.150
     8.060   117.531     0.150
     8.704   126.422     0.150
     8.710   128.820     0.150
     0.243     5.055     0.150
     0.243     9.281     0.150
     0.416    14.438     0.150
     0.693    13.023     0.150
     0.693    26.047     0.150
     0.693    29.203     0.150
     0.716    25.977     0.150
     0.730    25.664     0.150
     0.730    25.664     0.150
     0.772    14.695     0.150
     0.772    25.156     0.150
     0.773    14.719     0.150
     0.871    14.836     0.150
     0.871    14.844     0.150
     0.925    16.922     0.150
     0.925    28.602     0.150
     0.925    16.906     0.150
     0.983    18.148     0.150
     1.209    18.492     0.150
     1.209    32.266     0.150
     1.209    18.492     0.150
     1.209    32.328     0.150
     1.058    18.883     0.150
     1.058    32.344     0.150
     1.218    21.602     0.150
     1.220    22.406     0.150
     1.260    22.969     0.150
     1.260    38.656     0.150
     1.260    22.938     0.150
     1.334    23.531     0.150
     1.626    28.242     0.150
     1.863    33.922     0.150
     2.206    39.227     0.150
     2.362    36.148     0.150
     2.442    37.992     0.150
     5.404    79.594     0.150
     0.364    10.798     0.150
     0.364    18.388     0.150
     0.364    19.458     0.150
     0.505    10.248     0.150
     0.505    17.338     0.150
     0.505    10.258     0.150
     0.507    10.268     0.150
     0.507    17.388     0.150
     0.992    16.268     0.150
     0.992    26.988     0.150
     0.992    16.318     0.150
     0.923    18.008     0.150
     0.944    28.768     0.150
     0.944    17.418     0.150
     0.944    19.058     0.150
     0.944    31.558     0.150
     1.133    20.308     0.150
     1.133    33.538     0.150
     1.133    20.258     0.150
     1.175    37.228     0.150
     1.186    22.248     0.150
     1.225    22.398     0.150
     1.264    23.018     0.150
     1.264    39.188     0.150
     1.264    23.018     0.150
     1.277    23.388     0.150
     1.316    23.618     0.150
     1.320    23.648     0.150
     1.380    24.568     0.150
     1.415    24.708     0.150
     1.415    24.758     0.150
     1.513    27.418     0.150
     1.513    47.208     0.150
     1.587    30.508     0.150
     1.587    52.168     0.150
     1.658    28.268     0.150
     1.737    32.728     0.150
     1.854    35.028     0.150
     2.109    37.418     0.150
     2.121    35.198     0.150
     2.188    35.948     0.150
     2.435    39.028     0.150
     2.435    69.068     0.150
     2.461    40.098     0.150
     2.489    40.468     0.150
     2.489    46.438     0.150
     2.609    48.518     0.150
     2.648    42.968     0.150
     4.189    63.198     0.150
     4.754    72.428     0.150
     4.759    72.528     0.150
     4.759    72.528     0.150
     5.133   134.458     0.150
     5.343   140.588     0.150
     5.426    82.938     0.150
     6.090    91.988     0.150
     6.672   102.768     0.150
     6.800   101.858     0.150
     7.754   113.928     0.150
     8.170   121.408     0.150
     8.400   123.068     0.150
    11.376   165.133     0.150
    12.208   385.033     0.150
    12.544   181.385     0.150
    12.875   189.598     0.150
    13.270   193.948     0.150
    13.588   192.296     0.150
    13.646   199.278     0.150
    14.448   209.388     0.150
    17.855   249.347     0.150
    19.483   268.958     0.150
    20.799   283.588     0.150
    26.785   341.480     0.150
    27.142   344.668     0.150
    46.515  3411.308     0.150
    55.729  4101.008     0.150
    56.402   583.078     0.150
    56.402   583.048     0.150
    61.146   614.708     0.150
    69.564  5240.964     0.150
    69.569  5248.747     0.150
    69.582  5245.412     0.150
    70.298  5271.767     0.150
    70.311  5272.631     0.150
     0.366    10.682     0.150
     0.366    18.521     0.150
     0.496     9.990     0.150
     0.496    16.660     0.150
     0.497    10.021     0.150
     0.497    16.941     0.150
     0.991    16.111     0.150
     0.991    27.041     0.150
     0.991    16.080     0.150
     0.991    27.080     0.150
     0.914    17.541     0.150
     0.959    19.730     0.150
     0.959    34.131     0.150
     1.142    20.150     0.150
     1.142    34.111     0.150
     1.142    20.131     0.150
     1.142    34.191     0.150
     1.177    42.602     0.150
     1.195    22.131     0.150
     1.195    37.381     0.150
     1.195    22.150     0.150
     1.195    37.750     0.150
     1.267    22.830     0.150
     1.267    38.951     0.150
     1.267    22.750     0.150
     1.452    25.900     0.150
     1.452    44.730     0.150
     1.452    46.211     0.150
     1.521    47.061     0.150
     1.641    29.121     0.150
     1.673    28.182     0.150
     1.847    32.111     0.150
     2.197    35.910     0.150
     2.446    38.980     0.150
     0.365    10.420     0.150
     0.365    17.648     0.150
     0.496     9.850     0.150
     0.505     9.160     0.150
     0.505     9.180     0.150
     0.505    16.059     0.150
     0.991    15.850     0.150
     0.991    26.629     0.150
     0.991    15.850     0.150
     0.991    27.299     0.150
     0.940    16.979     0.150
     0.917    17.770     0.150
     0.941    19.840     0.150
     0.941    19.830     0.150
     0.962    19.238     0.150
     1.143    20.020     0.150
     1.143    33.750     0.150
     1.143    20.000     0.150
     1.143    33.840     0.150
     1.177    21.379     0.150
     1.177    36.680     0.150
     1.196    21.910     0.150
     1.196    37.129     0.150
     1.196    21.889     0.150
     1.239    22.719     0.150
     1.267    22.680     0.150
     1.293    23.219     0.150
     1.330    23.369     0.150
     1.429    24.750     0.150
     1.522    46.699     0.150
     1.676    28.119     0.150
     4.562    67.738     0.150
     0.367    10.414     0.150
     0.367    17.898     0.150
     0.367    18.234     0.150
     0.494     9.898     0.150
     0.496     9.906     0.150
     0.502     9.070     0.150
     0.990    15.891     0.150
     0.990    26.875     0.150
     0.990    15.891     0.150
     0.990    27.070     0.150
     0.990    28.195     0.150
     0.990    28.719     0.150
     0.942    17.148     0.150
     0.963    17.570     0.150
     1.129    35.867     0.150
     1.143    19.859     0.150
     1.143    19.906     0.150
     1.143    33.547     0.150
     1.179    40.664     0.150
     1.197    21.898     0.150
     1.197    21.938     0.150
     1.336    25.711     0.150
     1.453    25.781     0.150
     1.522    46.797     0.150
     1.522    27.125     0.150
     1.674    27.789     0.150
     1.848    32.266     0.150
     2.132    38.758     0.150
     2.663    44.375     0.150
     0.127     6.922     0.150
     0.127    11.930     0.150
     0.672    12.801     0.150
     0.672    21.980     0.150
     0.710    13.430     0.150
     0.761    13.461     0.150
     0.921    16.762     0.150
     0.970    16.711     0.150
     0.970    28.039     0.150
     0.970    16.781     0.150
     1.060    19.242     0.150
     1.255    20.590     0.150
     1.255    34.812     0.150
     1.255    19.570     0.150
     1.255    33.859     0.150
     1.872    32.160     0.150
     1.937    35.070     0.150
     0.405     8.508     0.150
     0.405    13.648     0.150
     0.407     8.520     0.150
     0.407    13.867     0.150
     0.538    14.867     0.150
     0.538    25.297     0.150
     0.538    26.008     0.150
     0.920    29.879     0.150
     0.920    17.410     0.150
     0.920    29.898     0.150
     1.035    17.570     0.150
     1.035    29.160     0.150
     1.035    17.648     0.150
     1.035    30.020     0.150
     1.269    22.848     0.150
     1.269    43.258     0.150
     1.288    25.199     0.150
     1.377    24.508     0.150
     1.377    41.828     0.150
     1.316    26.680     0.150
     1.316    45.070     0.150
     1.316    45.070     0.150
     1.382    24.840     0.150
     1.382    41.828     0.150
     1.382    24.648     0.150
     1.382    41.840     0.150
     1.432    44.648     0.150
     1.595    48.000     0.150
     1.595    28.078     0.150
     1.751    30.879     0.150
     1.716    32.438     0.150
     1.953    33.930     0.150
     2.031    34.230     0.150
     2.031    35.922     0.150
     2.104    34.309     0.150
     2.427    59.797     0.150
     2.427    41.949     0.150
     2.725    43.629     0.150
     2.725    43.629     0.150
     2.725    73.988     0.150
     3.045    50.898     0.150
     2.985    49.230     0.150
     3.504    52.250     0.150
     3.517    51.480     0.150
     4.480    68.668     0.150
     7.015   104.320     0.150
     9.163   240.297     0.150
    12.575   180.008     0.150
     0.525    10.539     0.150
     0.526    10.516     0.150
     1.009    16.492     0.150
     1.009    27.609     0.150
     1.009    16.477     0.150
     1.009    27.633     0.150
     0.907    39.797     0.150
     0.933    17.680     0.150
     0.933    29.977     0.150
     1.113    20.320     0.150
     1.113    33.891     0.150
     1.113    20.336     0.150
     1.113    35.648     0.150
     1.159    21.930     0.150
     1.159    37.211     0.150
     1.167    22.312     0.150
     1.247    23.102     0.150
     1.429    26.172     0.150
     0.263     5.445     0.150
     0.263     8.969     0.150
     0.264     5.477     0.150
     0.264     8.969     0.150
     0.708    11.094     0.150
     0.708    18.336     0.150
     0.708    11.125     0.150
     0.708    18.516     0.150
     0.708    21.719     0.150
     1.205    22.445     0.150
     1.365    44.664     0.150
     1.406    25.188     0.150
     1.411    25.430     0.150
     1.411    43.094     0.150
     1.411    25.516     0.150
     1.463    26.797     0.150
     1.465    26.523     0.150
     1.465    26.531     0.150
     1.554    28.516     0.150
     1.667    31.680     0.150
     1.738    30.891     0.150
     1.741    31.273     0.150
     1.798    31.742     0.150
     1.798    56.516     0.150
     1.810    30.891     0.150
     2.403    44.594     0.150
     5.671    85.648     0.150
     0.732    11.570     0.150
     0.732    11.629     0.150
     0.732    19.289     0.150
     1.044    21.039     0.150
     1.119    22.297     0.150
     1.119    37.727     0.150
     1.400    23.809     0.150
     1.453    26.648     0.150
     1.453    45.211     0.150
     1.534    27.227     0.150
     1.534    46.680     0.150
     1.819    30.102     0.150
     2.114    63.609     0.150
     2.341    63.547     0.150
     2.341    37.453     0.150
     2.723    82.270     0.150
     5.631    82.789     0.150
     5.744    83.258     0.150
     0.892    32.703     0.150
     0.892    35.934     0.150
     0.892    16.551     0.150
     0.892    27.312     0.150
     0.892    16.531     0.150
     0.992    18.203     0.150
     0.974    17.574     0.150
     0.974    29.312     0.150
     0.974    17.523     0.150
     0.974    28.711     0.150
     1.023    19.402     0.150
     1.025    19.801     0.150
     1.025    20.883     0.150
     1.075    19.824     0.150
     1.075    33.043     0.150
     1.294    20.684     0.150
     1.294    36.773     0.150
     1.294    37.902     0.150
     1.294    20.551     0.150
     1.294    35.102     0.150
     1.725    29.312     0.150
     2.017    34.359     0.150
     2.070    41.125     0.150
     2.724    41.633     0.150
     2.724    71.793     0.150
     4.526   136.910     0.150
     6.077    88.031     0.150
     6.545    96.672     0.150
     6.712    98.242     0.150
     7.543   108.613     0.150
     8.694   124.281     0.150
     8.916   129.332     0.150
     9.117   293.547     0.150
     9.675   138.633     0.150
    10.161   145.281     0.150
    10.453   149.523     0.150
    10.522   151.371     0.150
    10.571   150.082     0.150
    10.872   156.492     0.150
    95.552   801.312     0.150
     0.481     9.727     0.150
     0.850    29.133     0.150
     1.055    19.961     0.150
     1.182    21.125     0.150
     1.182    21.023     0.150
     1.182    37.680     0.150
     1.236    23.070     0.150
     1.268    23.656     0.150
     1.268    23.742     0.150
     1.352    24.836     0.150
     1.352    42.227     0.150
     1.525    27.695     0.150
     1.650    30.891     0.150
     0.405     8.225     0.150
     0.602    11.565     0.150
     0.602    19.805     0.150
     0.602    11.575     0.150
     0.602    19.875     0.150
     0.602    21.065     0.150
     0.701    13.275     0.150
     0.701    22.405     0.150
     0.701    13.265     0.150
     0.701    22.485     0.150
     0.741    13.655     0.150
     0.741    13.705     0.150
     0.741    22.825     0.150
     0.786    15.165     0.150
     0.786    25.305     0.150
     0.910    16.515     0.150
     0.910    30.305     0.150
     0.999    20.265     0.150
     0.999    34.925     0.150
     1.023    18.465     0.150
     1.023    18.465     0.150
     1.023    18.445     0.150
     1.043    19.305     0.150
     1.043    32.936     0.150
     1.283    22.905     0.150
     1.283    39.083     0.150
     1.572    26.425     0.150
     1.572    24.455     0.150
     1.572    43.725     0.150
     2.873    44.882     0.150
     0.298     6.971     0.150
     0.298    11.662     0.150
     0.298     6.971     0.150
     0.298    11.662     0.150
     0.298     6.961     0.150
     0.298    11.641     0.150
     0.802    14.352     0.150
     0.802    24.201     0.150
     0.802    14.561     0.150
     0.802    24.301     0.150
     0.802    27.012     0.150
     0.802    27.861     0.150
     1.193    37.102     0.150
     1.484    26.131     0.150
     1.574    27.291     0.150
     1.574    52.602     0.150
     1.633    28.490     0.150
     1.643    28.932     0.150
     1.643    49.240     0.150
     1.643    49.262     0.150
     1.716    51.941     0.150
     1.826    31.900     0.150
     1.818    31.082     0.150
     1.818    31.041     0.150
     1.818    60.070     0.150
     1.818    60.102     0.150
     1.869    32.594     0.150
     1.922    33.502     0.150
     2.046    68.801     0.150
     2.046    69.951     0.150
     2.059    34.941     0.150
     2.130    35.430     0.150
     2.168    67.730     0.150
     2.199    70.631     0.150
     2.348    38.395     0.150
     2.400    73.584     0.150
     2.706    43.352     0.150
     2.706    43.352     0.150
     2.617    47.432     0.150
     4.438    67.361     0.150
     4.577    70.646     0.150
     4.601   130.740     0.150
     5.102   136.631     0.150
     6.656   179.760     0.150
     6.816    97.641     0.150
     6.945    98.262     0.150
     7.768   111.451     0.150
     7.901   246.725     0.150
     8.079   114.191     0.150
     8.210   119.922     0.150
     8.210   222.447     0.150
     8.340   117.490     0.150
     8.783   123.502     0.150
     8.861   125.041     0.150
     8.861   268.303     0.150
     9.919   310.154     0.150
    10.362   145.641     0.150
    10.512   324.701     0.150
    10.512   147.092     0.150
    11.280   164.896     0.150
    12.451   173.711     0.150
    12.581   176.682     0.150
    12.562   176.711     0.150
    12.896   402.850     0.150
    13.420   187.303     0.150
    13.494   189.850     0.150
    13.595   191.381     0.150
    13.677   190.861     0.150
    14.169   197.732     0.150
    14.179   195.189     0.150
    14.323   201.861     0.150
    14.745   204.740     0.150
    16.162   223.080     0.150
    17.465   240.592     0.150
    17.993   245.240     0.150
    19.788   266.061     0.150
    20.401   271.771     0.150
    21.283   281.971     0.150
    21.375   283.713     0.150
    21.488   282.412     0.150
    21.992   288.803     0.150
    22.550   295.092     0.150
    22.867   300.053     0.150
    22.957   300.689     0.150
    23.092   302.670     0.150
    23.517   305.771     0.150
    23.789   309.650     0.150
    23.789   314.170     0.150
    24.433   314.760     0.150
    29.319   368.975     0.150
    31.701   388.951     0.150
    38.956   451.025     0.150
    38.956   449.861     0.150
    39.116   453.756     0.150
    39.940   458.061     0.150
     0.432    15.719     0.150
     0.549    10.938     0.150
     0.549    18.250     0.150
     1.003    16.137     0.150
     1.003    16.129     0.150
     1.003    26.887     0.150
     0.883    31.219     0.150
     1.096    19.148     0.150
     1.096    19.238     0.150
     1.096    35.160     0.150
     1.149    21.348     0.150
     1.596    29.047     0.150
     0.172     7.773     0.150
     0.562    10.844     0.150
     0.806    25.766     0.150
     1.196    33.566     0.150
     1.196    19.824     0.150
     1.196    19.637     0.150
     1.196    33.664     0.150
     1.196    35.227     0.150
     1.196    35.766     0.150
     1.189    21.086     0.150
     1.189    42.914     0.150
     1.302    38.613     0.150
     1.302    22.766     0.150
     1.371    40.184     0.150
     1.371    23.555     0.150
     1.371    23.664     0.150
     1.371    40.324     0.150
     1.371    42.844     0.150
     1.371    48.055     0.150
     1.375    44.246     0.150
     1.418    25.512     0.150
     1.418    42.727     0.150
     1.520    24.273     0.150
     1.531    26.426     0.150
     1.531    48.605     0.150
     1.670    49.977     0.150
     1.684    29.355     0.150
     1.684    29.395     0.150
     1.730    28.816     0.150
     2.398    38.590     0.150
     2.887    44.895     0.150
     3.157    96.906     0.150
     4.642    69.168     0.150
     5.708    84.094     0.150
     7.944   114.863     0.150
     0.080     5.711     0.150
     0.080     9.367     0.150
     0.080     9.633     0.150
     0.080    10.070     0.150
     0.441    15.711     0.150
     0.750    14.164     0.150
     0.750    24.078     0.150
     0.831    14.609     0.150
     0.831    24.461     0.150
     0.831    14.633     0.150
     0.847    15.438     0.150
     0.879    16.609     0.150
     0.880    16.344     0.150
     0.880    16.328     0.150
     0.907    32.141     0.150
     1.049    18.641     0.150
     1.162    35.805     0.150
     1.162    21.078     0.150
     1.192    21.070     0.150
     1.223    38.672     0.150
     1.422    23.328     0.150
     1.422    39.758     0.150
     1.422    23.023     0.150
     1.428    24.898     0.150
     1.428    42.789     0.150
     1.646    27.258     0.150
     1.646    46.406     0.150
     1.869    57.055     0.150
     2.764    42.492     0.150
     4.072    59.992     0.150
     4.232    61.172     0.150
     5.169    74.109     0.150
     5.326    75.758     0.150
     5.597    79.742     0.150
     5.607    79.312     0.150
     0.248     5.396     0.150
     0.248     8.807     0.150
     0.248     9.146     0.150
     0.315     7.236     0.150
     0.315    12.035     0.150
     0.315    12.326     0.150
     0.626     9.846     0.150
     0.626    16.615     0.150
     0.626     9.035     0.150
     0.626    16.166     0.150
     0.626     9.885     0.150
     0.626    16.307     0.150
     0.626    17.115     0.150
     0.732    17.215     0.150
     0.732    29.455     0.150
     0.732    31.785     0.150
     0.732    31.896     0.150
     0.832    28.236     0.150
     1.421    26.865     0.150
     1.468    26.375     0.150
     1.468    25.557     0.150
     1.478    26.486     0.150
     1.478    25.545     0.150
     1.478    44.736     0.150
     1.478    45.906     0.150
     1.544    45.705     0.150
     1.544    27.996     0.150
     1.634    29.525     0.150
     1.634    51.406     0.150
     1.815    32.676     0.150
     1.815    57.506     0.150
     1.815    58.205     0.150
     0.130     4.992     0.150
     0.130     8.482     0.150
     0.130     8.772     0.150
     0.130     8.793     0.150
     0.480     9.412     0.150
     0.491    16.522     0.150
     0.697    12.822     0.150
     0.697    22.152     0.150
     0.697    12.822     0.150
     0.795    14.423     0.150
     0.800    13.912     0.150
     0.800    23.612     0.150
     0.800    13.893     0.150
     0.800    23.763     0.150
     0.847    26.343     0.150
     0.847    15.601     0.150
     0.847    26.317     0.150
     0.847    15.603     0.150
     0.876    26.923     0.150
     0.876    15.772     0.150
     0.876    26.963     0.150
     0.905    28.372     0.150
     0.930    17.003     0.150
     1.000    17.683     0.150
     1.000    31.702     0.150
     1.000    31.713     0.150
     1.066    19.053     0.150
     1.071    20.622     0.150
     1.121    20.210     0.150
     1.121    20.263     0.150
     1.171    20.652     0.150
     1.297    38.982     0.150
     1.314    39.572     0.150
     1.477    22.593     0.150
     1.477    41.303     0.150
     1.477    23.162     0.150
     1.477    41.122     0.150
     1.477    42.562     0.150
     1.477    43.152     0.150
     1.477    22.812     0.150
     1.477    40.202     0.150
     1.394    25.143     0.150
     1.650    27.491     0.150
     1.830    30.888     0.150
     2.806    43.096     0.150
     2.806    42.933     0.150
     5.137    79.142     0.150
     9.132   132.075     0.150
     0.129     5.055     0.150
     0.129     8.488     0.150
     0.129     8.828     0.150
     0.481     9.465     0.150
     0.697    12.828     0.150
     0.697    22.277     0.150
     0.795    14.367     0.150
     0.800    13.957     0.150
     0.800    23.668     0.150
     0.800    13.957     0.150
     0.800    23.375     0.150
     0.847    15.715     0.150
     0.930    16.988     0.150
     0.978    27.105     0.150
     1.000    32.078     0.150
     1.067    19.086     0.150
     1.172    21.105     0.150
     1.476    22.836     0.150
     1.476    38.918     0.150
     1.476    24.316     0.150
     1.476    41.078     0.150
     0.154     7.266     0.150
     0.154    12.676     0.150
     0.154    12.846     0.150
     0.296     5.906     0.150
     0.296    10.166     0.150
     0.609    11.637     0.150
     0.735    13.676     0.150
     0.889    15.996     0.150
     0.889    28.186     0.150
     0.889    28.127     0.150
     0.991    17.656     0.150
     0.986    16.967     0.150
     0.986    17.037     0.150
     0.986    28.906     0.150
     1.042    37.695     0.150
     1.035    18.846     0.150
     1.077    19.186     0.150
     1.304    20.586     0.150
     1.304    36.826     0.150
     1.304    20.387     0.150
     1.304    36.115     0.150
     1.304    20.346     0.150
     1.304    35.637     0.150
     1.200    20.996     0.150
     1.339    44.006     0.150
     1.668    50.506     0.150
     1.848    32.266     0.150
     2.747    42.926     0.150
     5.324    79.186     0.150
     0.162     4.062     0.150
     0.162     6.914     0.150
     0.278     5.883     0.150
     0.565    20.672     0.150
     0.556    14.516     0.150
     0.556    24.562     0.150
     0.873    13.906     0.150
     0.873    23.539     0.150
     0.873    13.898     0.150
     0.873    23.547     0.150
     0.873    25.523     0.150
     0.873    13.898     0.150
     0.873    23.094     0.150
     1.042    18.812     0.150
     1.151    38.688     0.150
     1.207    23.703     0.150
     1.347    23.797     0.150
     1.347    42.148     0.150
     1.347    23.812     0.150
     1.379    24.164     0.150
     1.379    40.625     0.150
     1.379    24.109     0.150
     1.379    40.875     0.150
     1.379    42.242     0.150
     1.379    43.422     0.150
     1.376    45.453     0.150
     1.382    43.977     0.150
     1.447    43.867     0.150
     1.527    27.195     0.150
     1.527    46.453     0.150
     1.548    50.664     0.150
     1.638    29.469     0.150
     1.650    28.539     0.150
     1.650    51.445     0.150
     1.680    29.422     0.150
     1.713    30.289     0.150
     1.713    52.477     0.150
     1.824    31.703     0.150
     1.919    31.336     0.150
     2.029    34.961     0.150
     2.101    37.328     0.150
     2.303    39.672     0.150
     2.435    39.133     0.150
     2.531    39.555     0.150
     2.531    39.430     0.150
     2.976    48.383     0.150
     4.102   124.195     0.150
     4.285    64.008     0.150
     4.529   136.555     0.150
     5.556    81.477     0.150
     5.691    82.078     0.150
     5.691    82.367     0.150
     6.674   192.312     0.150
     6.759    97.555     0.150
     7.344   102.508     0.150
     7.469   114.969     0.150
     7.469   136.062     0.150
     7.759   105.734     0.150
     7.777   107.164     0.150
     8.889   126.477     0.150
     8.886   126.656     0.150
     9.015   130.789     0.150
    10.549   154.742     0.150
    10.549   328.469     0.150
    10.549   151.172     0.150
    12.470   183.789     0.150
     0.307     6.516     0.150
     0.304     5.736     0.150
     0.304     9.736     0.150
     0.304    10.276     0.150
     0.355     7.256     0.150
     0.355    12.376     0.150
     0.705    10.126     0.150
     0.705    17.596     0.150
     0.705    10.416     0.150
     0.705    17.756     0.150
     0.652    15.096     0.150
     0.652    25.986     0.150
     0.652    29.016     0.150
     0.652    29.046     0.150
     0.721    25.786     0.150
     0.721    25.986     0.150
     0.740    23.676     0.150
     0.793    14.446     0.150
     0.879    16.336     0.150
     1.285    42.156     0.150
     1.335    41.796     0.150
     1.381    23.766     0.150
     1.391    23.496     0.150
     1.391    40.056     0.150
     1.391    41.256     0.150
     1.391    42.636     0.150
     1.391    42.986     0.150
     1.444    26.846     0.150
     1.445    25.106     0.150
     1.445    25.114     0.150
     1.445    44.574     0.150
     1.463    26.076     0.150
     1.551    27.276     0.150
     1.730    29.676     0.150
     1.730    29.696     0.150
     1.730    54.946     0.150
     1.730    55.046     0.150
     2.268    36.036     0.150
     2.441    38.795     0.150
     2.441    38.730     0.150
     3.825   115.413     0.150
     4.023    59.977     0.150
     4.308   130.184     0.150
     5.338    79.904     0.150
     6.039    87.996     0.150
     6.885   100.056     0.150
     7.617   110.376     0.150
     8.632   122.846     0.150
     8.704   124.346     0.150
     9.260   132.126     0.150
     9.382   133.056     0.150
     9.747   138.386     0.150
    10.264   146.126     0.150
    10.311   147.806     0.150
    10.311   146.816     0.150
    10.311   318.327     0.150
    10.398   148.556     0.150
    10.509   148.576     0.150
    10.622   151.126     0.150
    10.690   151.266     0.150
    11.372   161.116     0.150
    12.242   173.126     0.150
    12.306   382.561     0.150
    13.416   189.086     0.150
    15.635   219.286     0.150
     0.150     7.363     0.150
     0.150    12.871     0.150
     0.284     5.684     0.150
     0.723    13.453     0.150
     0.723    22.684     0.150
     0.814    28.691     0.150
     0.901    28.844     0.150
     0.901    16.230     0.150
     0.901    27.000     0.150
     0.983    19.000     0.150
     0.988    29.250     0.150
     0.988    17.023     0.150
     0.988    17.121     0.150
     0.988    29.184     0.150
     1.002    17.852     0.150
     1.037    18.992     0.150
     1.288    20.980     0.150
     1.288    36.141     0.150
     1.288    21.230     0.150
     1.288    21.000     0.150
     1.288    34.863     0.150
     1.162    21.883     0.150
     1.192    36.773     0.150
     1.209    21.152     0.150
     1.271    22.141     0.150
     1.273    21.652     0.150
     1.688    30.062     0.150
     1.688    52.832     0.150
     4.734    72.480     0.150
     5.192    80.371     0.150
     0.154     4.365     0.150
     0.154     7.505     0.150
     0.154     7.965     0.150
     0.154     9.564     0.150
     0.376    13.685     0.150
     0.376    14.715     0.150
     0.472     9.115     0.150
     0.472    15.705     0.150
     0.534    18.085     0.150
     0.799    14.805     0.150
     0.819    29.135     0.150
     0.819    31.545     0.150
     0.956    30.265     0.150
     1.028    18.345     0.150
     1.073    19.401     0.150
     1.073    19.365     0.150
     1.124    20.735     0.150
     1.124    35.644     0.150
     1.284    42.705     0.150
     1.509    24.785     0.150
     1.509    23.484     0.150
     2.441    41.115     0.150
     0.191     7.805     0.150
     0.191    13.430     0.150
     0.191    13.945     0.150
     0.228     5.070     0.150
     0.643    12.336     0.150
     0.665    23.992     0.150
     0.768    14.281     0.150
     0.768    24.602     0.150
     1.168    18.070     0.150
     1.168    32.547     0.150
     1.168    18.141     0.150
     1.168    30.367     0.150
     1.168    18.094     0.150
     1.007    17.336     0.150
     1.007    29.375     0.150
     1.007    17.297     0.150
     1.007    29.461     0.150
     1.007    32.570     0.150
     1.002    18.047     0.150
     1.059    19.297     0.150
     1.059    19.266     0.150
     1.082    19.633     0.150
     1.095    19.445     0.150
     1.164    20.641     0.150
     1.164    35.586     0.150
     1.286    22.625     0.150
     1.286    40.680     0.150
     1.323    24.141     0.150
     1.371    24.703     0.150
     2.055    60.656     0.150
     2.061    33.500     0.150
     2.576    40.211     0.150
     2.576    40.164     0.150
     3.197    49.672     0.150
     4.327    64.320     0.150
     4.327   108.305     0.150
     6.165    92.445     0.150
     7.557   108.930     0.150
     0.200     4.844     0.150
     0.200     8.484     0.150
     0.438     7.234     0.150
     0.438    12.434     0.150
     0.438     7.617     0.150
     0.438    12.746     0.150
     0.438    12.887     0.150
     0.438    12.945     0.150
     0.534    20.547     0.150
     0.534    20.637     0.150
     0.924    16.844     0.150
     0.999    21.895     0.150
     0.999    39.055     0.150
     0.999    40.117     0.150
     1.167    20.484     0.150
     1.223    21.867     0.150
     1.299    22.754     0.150
     1.438    28.375     0.150
     1.438    48.285     0.150
     1.438    48.926     0.150
     1.505    50.344     0.150
     1.506    25.594     0.150
     1.778    31.867     0.150
     1.778    55.074     0.150
     1.831    57.582     0.150
     1.901    32.074     0.150
     2.163    66.871     0.150
     2.308    37.207     0.150
     2.492    78.906     0.150
     4.995    76.961     0.150
     0.128     5.117     0.150
     0.128     8.660     0.150
     0.128     8.879     0.150
     0.483     9.570     0.150
     0.483    16.219     0.150
     0.493     9.398     0.150
     0.493    16.051     0.150
     0.493    16.609     0.150
     0.696    12.828     0.150
     0.696    12.918     0.150
     0.696    22.219     0.150
     0.794    14.457     0.150
     0.794    24.648     0.150
     0.796    14.070     0.150
     0.796    23.660     0.150
     0.796    14.000     0.150
     0.796    23.828     0.150
     0.796    24.328     0.150
     0.843    15.789     0.150
     0.843    15.859     0.150
     0.853    31.059     0.150
     0.874    15.750     0.150
     0.931    17.129     0.150
     0.998    17.738     0.150
     1.071    20.840     0.150
     1.118    20.359     0.150
     1.118    35.027     0.150
     1.165    21.223     0.150
     1.165    36.906     0.150
     1.185    22.020     0.150
     1.253    21.957     0.150
     1.477    23.828     0.150
     1.477    41.117     0.150
     1.477    22.730     0.150
     1.477    41.109     0.150
     1.477    22.660     0.150
     2.803    43.285     0.150
     6.309    95.129     0.150
     0.210     4.598     0.150
     0.210    10.320     0.150
     0.395    10.730     0.150
     0.395    18.148     0.150
     0.395    18.879     0.150
     0.962    15.320     0.150
     0.962    26.070     0.150
     0.962    15.039     0.150
     0.962    26.109     0.150
     0.962    27.707     0.150
     0.977    30.750     0.150
     0.974    31.770     0.150
     1.012    36.051     0.150
     1.012    36.668     0.150
     1.154    20.910     0.150
     1.154    35.027     0.150
     1.294    40.680     0.150
     1.354    24.270     0.150
     1.475    44.738     0.150
     1.820    32.020     0.150
     0.333     7.352     0.150
     0.327     6.432     0.150
     0.327    10.602     0.150
     0.492     9.641     0.150
     0.492    16.410     0.150
     0.492    18.131     0.150
     0.491    17.781     0.150
     0.491    18.201     0.150
     0.680    12.320     0.150
     0.680    20.852     0.150
     0.680    12.240     0.150
     0.680    20.951     0.150
     0.721    13.295     0.150
     0.721    13.352     0.150
     0.807    14.410     0.150
     0.839    32.111     0.150
     0.862    15.561     0.150
     0.954    29.576     0.150
     0.954    17.252     0.150
     1.080    19.621     0.150
     1.084    36.320     0.150
     1.148    20.102     0.150
     1.405    43.172     0.150
     1.682    27.121     0.150
     1.653    27.758     0.150
     2.375    36.959     0.150
     2.950    45.320     0.150
     4.750    72.410     0.150
     0.192     3.363     0.150
     0.192     5.801     0.150
     0.656    13.371     0.150
     0.656    23.133     0.150
     0.666    24.594     0.150
     0.666    13.551     0.150
     0.719    26.242     0.150
     0.719    15.031     0.150
     0.719    26.293     0.150
     0.731    12.543     0.150
     0.731    12.734     0.150
     0.731    26.461     0.150
     0.737    15.082     0.150
     0.785    14.660     0.150
     0.785    14.602     0.150
     0.786    16.004     0.150
     0.786    27.734     0.150
     0.807    28.152     0.150
     0.832    15.652     0.150
     0.832    15.621     0.150
     0.832    31.031     0.150
     0.853    16.594     0.150
     0.904    16.363     0.150
     0.906    17.223     0.150
     1.036    19.258     0.150
     1.036    19.211     0.150
     1.112    20.531     0.150
     1.364    38.414     0.150
     1.364    22.371     0.150
     1.364    22.453     0.150
     1.364    37.973     0.150
     1.364    21.234     0.150
     1.216    22.203     0.150
     1.327    44.594     0.150
     1.327    45.004     0.150
     1.337    24.004     0.150
     1.411    24.461     0.150
     1.471    25.719     0.150
     1.787    30.246     0.150
     1.787    30.156     0.150
     2.548    39.953     0.150
     2.548    39.852     0.150
     2.548    65.344     0.150
     2.548    39.922     0.150
     4.282    63.715     0.150
     4.355    66.609     0.150
     6.821    99.262     0.150
     6.821   212.363     0.150
     8.383   122.930     0.150
     8.833   274.039     0.150
    11.688   167.258     0.150
    11.922   377.789     0.150
     0.669    24.500     0.150
     0.723    25.387     0.150
     0.727    12.719     0.150
     0.727    21.609     0.150
     0.787    27.859     0.150
     0.780    14.703     0.150
     0.780    24.695     0.150
     0.881    30.578     0.150
     1.034    19.523     0.150
     1.107    20.629     0.150
     1.370    21.539     0.150
     1.370    21.020     0.150
     1.205    39.828     0.150
     1.333    24.027     0.150
     1.414    24.449     0.150
     1.414    24.527     0.150
     1.783    30.191     0.150
     2.038    34.109     0.150
     3.892    58.398     0.150
     4.079   123.320     0.150
     4.350   131.828     0.150
     5.599    85.500     0.150
     0.188     3.219     0.150
     0.188     5.439     0.150
     0.244     3.959     0.150
     0.516     9.719     0.150
     0.720    13.600     0.150
     0.720    23.299     0.150
     0.726    12.629     0.150
     0.726    21.619     0.150
     0.726    12.520     0.150
     0.726    21.409     0.150
     0.724    26.069     0.150
     0.743    26.419     0.150
     0.779    14.469     0.150
     0.823    15.459     0.150
     0.823    27.389     0.150
     0.823    27.489     0.150
     0.807    27.969     0.150
     0.895    16.209     0.150
     0.895    29.639     0.150
     0.895    29.859     0.150
     1.371    22.139     0.150
     1.207    37.969     0.150
     0.342     7.740     0.150
     0.342    13.039     0.150
     0.433     8.500     0.150
     0.530    19.850     0.150
     0.663    24.320     0.150
     0.663    13.779     0.150
     0.696    25.520     0.150
     0.755    32.549     0.150
     0.855    29.639     0.150
     0.878    16.250     0.150
     0.878    27.980     0.150
     0.945    17.590     0.150
     0.945    30.059     0.150
     0.932    15.910     0.150
     0.932    16.059     0.150
     0.932    15.869     0.150
     0.932    29.629     0.150
     0.932    29.910     0.150
     1.130    18.160     0.150
     1.130    18.010     0.150
     1.130    30.850     0.150
     0.986    17.990     0.150
     1.150    20.600     0.150
     0.186     3.580     0.150
     0.186     5.910     0.150
     0.186     6.240     0.150
     0.186     6.459     0.150
     0.507     9.869     0.150
     0.507    18.240     0.150
     0.726    25.549     0.150
     0.726    13.969     0.150
     0.726    23.830     0.150
     0.726    24.270     0.150
     0.737    12.420     0.150
     0.737    21.629     0.150
     0.737    12.770     0.150
     0.742    26.750     0.150
     0.751    24.029     0.150
     0.752    14.000     0.150
     0.790    14.760     0.150
     0.794    27.539     0.150
     0.794    28.020     0.150
     0.833    28.068     0.150
     0.905    16.559     0.150
     0.905    30.180     0.150
     0.905    30.600     0.150
     0.901    17.260     0.150
     0.951    31.779     0.150
     0.949    17.049     0.150
     1.117    20.699     0.150
     1.124    37.080     0.150
     1.214    40.430     0.150
     1.320    44.520     0.150
     1.418    23.990     0.150
     1.725    29.818     0.150
     4.285    85.180     0.150
     0.131     6.508     0.150
     0.194     3.379     0.150
     0.194     5.539     0.150
     0.523     9.918     0.150
     0.523    17.016     0.150
     0.720    12.668     0.150
     0.720    21.547     0.150
     0.720    12.406     0.150
     0.720    21.547     0.150
     0.739    27.156     0.150
     0.773    14.648     0.150
     0.820    15.539     0.150
     0.820    27.605     0.150
     0.801    27.969     0.150
     0.891    29.926     0.150
     0.935    31.695     0.150
     1.064    32.887     0.150
     1.082    21.207     0.150
     1.204    22.309     0.150
     1.376    21.348     0.150
     1.376    21.258     0.150
     2.040    34.766     0.150
     5.658    84.047     0.150
     0.103     3.449     0.150
     0.103     5.738     0.150
     0.103     3.562     0.150
     0.103     5.672     0.150
     0.337     6.898     0.150
     0.500    13.727     0.150
     0.500    23.297     0.150
     0.700    25.738     0.150
     0.700    26.309     0.150
     0.930    14.938     0.150
     0.930    25.449     0.150
     0.930    14.988     0.150
     0.930    25.227     0.150
     0.930    15.121     0.150
     0.983    17.977     0.150
     0.983    31.020     0.150
     1.134    38.098     0.150
     1.134    20.656     0.150
     1.134    38.176     0.150
     1.163    21.039     0.150
     1.163    21.047     0.150
     1.288    22.918     0.150
     1.288    43.258     0.150
     1.288    47.887     0.150
     1.288    22.836     0.150
     1.294    22.809     0.150
     1.329    23.250     0.150
     1.329    39.758     0.150
     1.329    23.188     0.150
     1.340    42.758     0.150
     1.342    23.848     0.150
     1.342    23.910     0.150
     1.389    24.500     0.150
     1.345    29.508     0.150
     1.345    51.297     0.150
     1.381    24.859     0.150
     1.469    25.879     0.150
     1.549    42.938     0.150
     1.654    28.879     0.150
     1.897    31.238     0.150
     1.946    30.957     0.150
     4.317   116.750     0.150
     4.716   127.539     0.150
     5.381    78.359     0.150
     5.381   131.148     0.150
     5.414    73.328     0.150
     8.628   131.258     0.150
    12.734   180.207     0.150
    14.615   212.969     0.150
    15.370   211.688     0.150
    16.972   234.180     0.150
    24.032   312.867     0.150
    69.532  5241.664     0.150
    69.537  5244.301     0.150
    69.550  5243.266     0.150
    70.257  5275.699     0.150
    70.261  5288.629     0.150
    70.275  5289.547     0.150
    79.885   732.684     0.150
    82.516   746.840     0.150
     0.172     6.938     0.150
     0.172    11.729     0.150
     0.459     9.398     0.150
     0.453     8.669     0.150
     0.735    13.568     0.150
     0.735    13.469     0.150
     0.735    23.078     0.150
     0.840    15.049     0.150
     0.840    25.709     0.150
     0.892    16.118     0.150
     0.892    27.709     0.150
     0.885    15.629     0.150
     0.885    26.539     0.150
     0.885    15.679     0.150
     0.932    16.559     0.150
     0.931    17.278     0.150
     1.004    18.599     0.150
     1.056    18.539     0.150
     1.237    40.938     0.150
     1.461    22.419     0.150
     1.461    21.929     0.150
     1.461    37.669     0.150
     1.423    46.379     0.150
     1.812    30.979     0.150
     1.906    32.068     0.150
     2.354    42.568     0.150
     3.559    64.019     0.150
     3.559    64.019     0.150
     3.559   108.089     0.150
     8.729   259.928     0.150
     9.039   277.184     0.150
    11.027   337.086     0.150
    38.127   445.259     0.150
     0.220     6.469     0.150
     0.220    10.773     0.150
     0.220    11.250     0.150
     0.220    11.406     0.150
     0.391     8.227     0.150
     0.391    13.828     0.150
     0.450    16.508     0.150
     0.486    16.211     0.150
     0.622    11.898     0.150
     0.622    11.930     0.150
     0.724    24.023     0.150
     0.724    13.492     0.150
     0.782    14.430     0.150
     0.782    24.023     0.150
     0.782    14.422     0.150
     0.815    25.742     0.150
     0.826    15.930     0.150
     1.003    18.289     0.150
     1.278    22.430     0.150
     1.294    23.469     0.150
     1.561    25.844     0.150
     1.561    26.094     0.150
     1.561    43.477     0.150
     4.760    71.000     0.150
     5.897    87.109     0.150
     0.382    11.129     0.150
     0.382    19.168     0.150
     0.382    19.418     0.150
     0.503    19.148     0.150
     0.551    19.738     0.150
     0.491    19.160     0.150
     0.491    20.898     0.150
     0.865    30.719     0.150
     0.874    17.047     0.150
     0.874    30.727     0.150
     0.956    17.789     0.150
     0.956    30.410     0.150
     0.919    17.750     0.150
     0.954    17.520     0.150
     0.947    18.129     0.150
     1.026    40.137     0.150
     1.079    20.047     0.150
     1.157    20.617     0.150
     1.157    34.680     0.150
     1.157    35.637     0.150
     1.157    20.609     0.150
     1.157    34.488     0.150
     1.194    41.168     0.150
     1.194    21.988     0.150
     1.194    37.738     0.150
     1.194    22.000     0.150
     1.194    37.738     0.150
     1.211    22.547     0.150
     1.250    22.828     0.150
     1.284    40.918     0.150
     1.284    23.348     0.150
     1.284    23.348     0.150
     1.284    39.848     0.150
     1.440    25.129     0.150
     1.468    26.430     0.150
     1.680    28.309     0.150
     1.762    30.078     0.150
     1.976    30.410     0.150
     2.130    37.117     0.150
     2.213    36.387     0.150
     3.117    82.539     0.150
     3.117    48.629     0.150
     3.117    82.539     0.150
     4.192   109.117     0.150
     4.744    68.000     0.150
     4.744    68.000     0.150
     4.796    72.027     0.150
     5.336    80.727     0.150
     7.246   133.148     0.150
     7.246   226.199     0.150
     7.869   210.047     0.150
     7.869   117.129     0.150
     8.254   116.539     0.150
     8.254   116.539     0.150
     8.409   123.887     0.150
     8.749   129.828     0.150
     8.738   127.539     0.150
     9.819   147.457     0.150
    11.077   290.527     0.150
    11.678   367.246     0.150
    12.230   390.039     0.150
    15.686   226.410     0.150
    16.086   225.117     0.150
    16.775   526.566     0.150
    21.478   285.477     0.150
    31.005   375.957     0.150
    33.464   393.160     0.150
    38.282   445.250     0.150
    95.826   801.898     0.150
     0.376    11.020     0.150
     0.376    19.801     0.150
     0.376    24.223     0.150
     0.495    19.043     0.150
     0.495    19.680     0.150
     0.493    17.953     0.150
     0.552    19.203     0.150
     0.871    30.461     0.150
     0.914    17.859     0.150
     0.914    17.883     0.150
     0.951    17.660     0.150
     0.951    30.652     0.150
     1.074    20.000     0.150
     0.961    32.551     0.150
     0.961    17.461     0.150
     1.149    20.520     0.150
     1.149    34.602     0.150
     1.149    39.102     0.150
     1.149    41.332     0.150
     1.149    20.531     0.150
     1.149    35.102     0.150
     1.203    22.500     0.150
     1.203    22.582     0.150
     1.187    38.141     0.150
     1.187    46.301     0.150
     1.187    22.082     0.150
     1.187    37.793     0.150
     1.243    22.781     0.150
     1.277    23.383     0.150
     1.277    23.383     0.150
     1.277    39.859     0.150
     1.277    23.383     0.150
     1.340    24.641     0.150
     1.383    25.121     0.150
     1.432    25.043     0.150
     1.461    26.281     0.150
     1.566    54.512     0.150
     1.566    28.512     0.150
     1.674    28.383     0.150
     1.754    29.883     0.150
     1.850    30.230     0.150
     1.850    30.180     0.150
     2.198   487.781     0.150
     2.205    36.180     0.150
     2.205    36.293     0.150
     3.125    49.891     0.150
     3.125    89.973     0.150
     3.385    60.883     0.150
     4.490    71.980     0.150
     4.750    69.551     0.150
     4.750   121.883     0.150
     4.750    69.551     0.150
     5.339   143.121     0.150
     5.339    80.570     0.150
     7.238   133.508     0.150
     7.875   116.762     0.150
     8.261   124.352     0.150
     8.261   124.352     0.150
     8.407   123.383     0.150
     8.739   127.609     0.150
     8.757   276.875     0.150
     8.757   130.312     0.150
     9.215   287.805     0.150
     9.736   143.859     0.150
     9.824   143.480     0.150
    11.083   288.301     0.150
    11.083   163.043     0.150
    12.817   331.422     0.150
    12.817   186.852     0.150
    13.616   198.402     0.150
    14.371   212.840     0.150
    14.517   211.402     0.150
    14.517   379.883     0.150
    14.517   214.000     0.150
    15.690   227.320     0.150
    15.933   229.031     0.150
    16.767   240.352     0.150
    16.767   527.824     0.150
    19.325   269.633     0.150
    21.755   291.770     0.150
    23.509   314.223     0.150
    26.790   343.301     0.150
    30.998   382.609     0.150
    82.293   741.953     0.150
    92.470   791.453     0.150
     0.377    10.914     0.150
     0.377    18.512     0.150
     0.377    21.414     0.150
     0.377    23.262     0.150
     0.948    17.484     0.150
     0.948    30.375     0.150
     0.950    17.312     0.150
     1.156    20.445     0.150
     1.156    34.414     0.150
     1.156    20.363     0.150
     1.156    34.203     0.150
     1.189    40.895     0.150
     1.189    21.805     0.150
     1.189    21.805     0.150
     1.189    36.832     0.150
     1.279    40.582     0.150
     1.279    23.195     0.150
     1.279    23.195     0.150
     1.279    39.422     0.150
     3.121    44.773     0.150
     3.121    44.773     0.150
     3.121    86.273     0.150
     0.174     3.957     0.150
     0.174     6.828     0.150
     0.376    10.918     0.150
     0.376    18.406     0.150
     0.376    18.738     0.150
     0.376    19.586     0.150
     0.981    15.227     0.150
     0.981    26.508     0.150
     0.981    15.547     0.150
     0.981    26.078     0.150
     0.981    15.719     0.150
     0.981    26.586     0.150
     0.948    16.496     0.150
     1.188    22.035     0.150
     1.188    37.707     0.150
     1.652    50.617     0.150
     1.853    29.219     0.150
     5.450    77.695     0.150
     0.164     3.820     0.150
     0.389    10.844     0.150
     0.389    18.672     0.150
     0.389    18.922     0.150
     0.389    19.914     0.150
     0.969    15.430     0.150
     0.969    26.133     0.150
     0.969    27.969     0.150
     0.969    15.445     0.150
     0.969    25.789     0.150
     0.969    15.406     0.150
     0.969    25.805     0.150
     1.097    21.305     0.150
     1.171    20.289     0.150
     1.171    35.039     0.150
     1.171    20.414     0.150
     1.171    34.320     0.150
     1.201    21.750     0.150
     1.201    21.781     0.150
     1.292    23.242     0.150
     1.421    24.719     0.150
     1.434    47.836     0.150
     2.160    35.484     0.150
     2.529    42.430     0.150
     5.468    81.414     0.150
     0.155     3.609     0.150
     0.383    10.898     0.150
     0.383    18.422     0.150
     0.383    19.109     0.150
     0.976    15.453     0.150
     0.976    26.086     0.150
     0.976    15.484     0.150
     0.976    26.023     0.150
     0.976    15.477     0.150
     0.976    26.969     0.150
     0.933    30.953     0.150
     1.169    20.617     0.150
     1.169    20.625     0.150
     1.169    34.578     0.150
     1.194    43.367     0.150
     1.194    21.766     0.150
     1.194    21.844     0.150
     1.286    23.258     0.150
     4.583    67.594     0.150
     4.808    71.695     0.150
     5.067    74.562     0.150
     0.383    10.752     0.150
     0.383    18.312     0.150
     0.383    18.793     0.150
     0.383    18.951     0.150
     0.973    15.342     0.150
     0.973    25.803     0.150
     0.973    15.312     0.150
     0.960    17.562     0.150
     0.960    30.441     0.150
     1.153    20.152     0.150
     1.153    33.902     0.150
     1.153    20.152     0.150
     1.153    33.893     0.150
     1.195    21.842     0.150
     3.420    55.951     0.150
     0.175     7.773     0.150
     0.175    13.184     0.150
     0.175    13.824     0.150
     0.237     5.082     0.150
     0.237     8.664     0.150
     0.683    13.422     0.150
     0.985    31.051     0.150
     0.985    18.191     0.150
     0.985    31.043     0.150
     0.947    20.324     0.150
     0.996    17.504     0.150
     0.996    29.793     0.150
     0.996    32.773     0.150
     0.996    17.523     0.150
     0.996    29.641     0.150
     1.048    19.383     0.150
     1.047    18.641     0.150
     1.186    19.734     0.150
     1.186    33.402     0.150
     1.186    18.832     0.150
     1.186    33.602     0.150
     0.345     9.977     0.150
     0.345    17.168     0.150
     0.345    17.816     0.150
     0.523    10.258     0.150
     0.919    29.336     0.150
     0.968    17.676     0.150
     1.078    19.789     0.150
     1.127    19.449     0.150
     1.127    33.379     0.150
     1.127    19.746     0.150
     1.127    33.219     0.150
     1.157    21.129     0.150
     1.157    35.367     0.150
     1.181    21.547     0.150
     1.192    21.867     0.150
     1.247    22.367     0.150
     1.335    25.496     0.150
     1.433    25.426     0.150
     1.674    28.148     0.150
     1.879    30.469     0.150
     3.973    58.059     0.150
     7.566   113.246     0.150
     0.176     3.754     0.150
     0.379    10.902     0.150
     0.379    18.480     0.150
     0.379    19.242     0.150
     0.495     9.691     0.150
     0.495    16.254     0.150
     0.503    17.781     0.150
     0.977    15.434     0.150
     0.977    26.402     0.150
     0.977    15.543     0.150
     0.977    15.434     0.150
     0.977    25.703     0.150
     0.953    17.363     0.150
     0.953    29.613     0.150
     0.969    29.703     0.150
     1.156    20.371     0.150
     1.156    34.480     0.150
     1.191    39.203     0.150
     1.191    22.004     0.150
     1.281    23.344     0.150
     1.281    39.844     0.150
     1.281    23.344     0.150
     1.281    39.844     0.150
     1.682    31.074     0.150
     1.761    33.242     0.150
     1.770    33.352     0.150
     0.136     7.711     0.150
     0.136    13.094     0.150
     0.136    13.953     0.150
     0.247     8.844     0.150
     0.293     5.953     0.150
     0.359     7.422     0.150
     0.136     7.664     0.150
     0.136    13.023     0.150
     0.624    12.031     0.150
     0.813    15.492     0.150
     0.893    30.273     0.150
     0.893    27.664     0.150
     0.893    16.656     0.150
     0.974    17.430     0.150
     0.974    29.836     0.150
     1.053    18.734     0.150
     1.053    18.805     0.150
     1.053    32.547     0.150
     1.293    20.641     0.150
     1.293    35.445     0.150
     1.293    20.133     0.150
     1.293    35.836     0.150
     1.293    37.859     0.150
     1.293    21.180     0.150
     1.293    35.703     0.150
     1.588    47.727     0.150
     0.172     3.998     0.150
     0.172     6.127     0.150
     0.387    10.957     0.150
     0.387    18.357     0.150
     0.387    19.098     0.150
     0.492    20.428     0.150
     0.492     9.857     0.150
     0.492    16.338     0.150
     0.546    17.287     0.150
     0.387    10.938     0.150
     0.387    18.418     0.150
     0.970    15.717     0.150
     0.970    25.928     0.150
     0.970    15.646     0.150
     0.970    26.236     0.150
     0.944    17.377     0.150
     0.944    29.816     0.150
     0.944    17.406     0.150
     0.944    29.748     0.150
     0.957    17.607     0.150
     0.958    30.697     0.150
     1.165    20.467     0.150
     1.165    34.906     0.150
     1.199    21.887     0.150
     1.216    23.588     0.150
     1.289    23.287     0.150
     1.289    23.287     0.150
     1.289    39.758     0.150
     5.202    77.268     0.150
     6.668    98.287     0.150
     6.748   100.508     0.150
     7.881   115.697     0.150
     8.195   119.057     0.150
     0.148     4.000     0.150
     0.488     9.180     0.150
     0.488    18.391     0.150
     0.488     9.211     0.150
     0.486    12.848     0.150
     0.486    21.961     0.150
     0.486    22.730     0.150
     0.887    13.520     0.150
     0.887    23.141     0.150
     0.887    13.391     0.150
     0.887    22.949     0.150
     0.887    24.551     0.150
     0.887    13.648     0.150
     0.887    23.008     0.150
     0.486    12.777     0.150
     0.486    21.680     0.150
     0.829    15.141     0.150
     0.962    32.438     0.150
     1.072    36.121     0.150
     1.086    23.168     0.150
     1.285    22.430     0.150
     1.285    37.270     0.150
     1.273    23.770     0.150
     1.294    23.078     0.150
     1.294    40.121     0.150
     1.848    33.070     0.150
     1.798    32.258     0.150
     1.894    58.078     0.150
     2.237    68.219     0.150
     0.164     3.977     0.150
     0.377    11.016     0.150
     0.377    18.557     0.150
     0.377    19.506     0.150
     0.504     9.926     0.150
     0.377    11.025     0.150
     0.980    15.637     0.150
     0.980    26.637     0.150
     0.980    28.037     0.150
     0.980    28.266     0.150
     0.980    15.605     0.150
     0.980    26.137     0.150
     0.980    15.605     0.150
     0.980    26.137     0.150
     0.943    31.396     0.150
     0.943    17.275     0.150
     0.943    17.275     0.150
     0.943    29.436     0.150
     0.946    17.516     0.150
     1.160    20.516     0.150
     1.160    20.445     0.150
     1.160    34.477     0.150
     1.189    21.836     0.150
     1.189    36.615     0.150
     1.280    23.346     0.150
     1.280    39.727     0.150
     1.284    23.957     0.150
     1.555    27.547     0.150
     0.942    36.727     0.150
     2.128    37.445     0.150
     3.119    57.727     0.150
     3.119    98.637     0.150
     4.419    64.996     0.150
     0.240     7.412     0.150
     0.240    12.152     0.150
     0.240    12.482     0.150
     0.384     8.262     0.150
     0.240     7.383     0.150
     0.240    12.352     0.150
     0.397     8.053     0.150
     0.415     8.883     0.150
     0.520     9.832     0.150
     0.520    16.781     0.150
     0.678    12.883     0.150
     0.678    21.982     0.150
     0.678    12.871     0.150
     0.786    14.582     0.150
     0.786    14.592     0.150
     0.873    16.062     0.150
     0.873    26.482     0.150
     1.009    18.271     0.150
     1.024    21.633     0.150
     1.199    21.182     0.150
     1.214    22.492     0.150
     1.533    24.902     0.150
     1.533    43.072     0.150
     1.533    25.422     0.150
     1.533    42.951     0.150
     1.493    26.342     0.150
     5.198    77.451     0.150
     0.369    10.713     0.150
     0.369    18.803     0.150
     0.503     9.873     0.150
     0.490     9.691     0.150
     0.490    16.203     0.150
     0.369    10.732     0.150
     0.369    18.002     0.150
     0.988    15.783     0.150
     0.988    26.742     0.150
     0.988    15.732     0.150
     0.988    26.402     0.150
     0.988    28.713     0.150
     0.988    15.742     0.150
     0.988    26.432     0.150
     1.180    21.902     0.150
     1.451    48.182     0.150
     0.092     6.758     0.150
     0.092    11.328     0.150
     0.170     3.938     0.150
     0.170     6.586     0.150
     0.371     6.809     0.150
     0.092     6.758     0.150
     0.092    11.469     0.150
     0.563    11.039     0.150
     0.810    14.699     0.150
     0.810    25.066     0.150
     0.816    26.520     0.150
     0.905    16.598     0.150
     0.905    27.816     0.150
     0.905    16.457     0.150
     0.986    31.816     0.150
     0.997    31.719     0.150
     1.128    34.199     0.150
     1.365    22.496     0.150
     1.365    38.566     0.150
     1.365    22.316     0.150
     1.365    38.098     0.150
     1.341    25.277     0.150
     1.914    34.578     0.150
     2.000    35.359     0.150
     5.782    84.727     0.150
     0.172     4.203     0.150
     0.172     6.984     0.150
     0.408    11.203     0.150
     0.408    19.727     0.150
     0.408    20.258     0.150
     0.451     8.906     0.150
     0.451     8.906     0.150
     0.451    15.227     0.150
     0.479     9.344     0.150
     0.531    18.906     0.150
     0.408    11.195     0.150
     0.408    19.094     0.150
     0.949    15.023     0.150
     0.949    24.945     0.150
     0.949    15.023     0.150
     0.949    24.945     0.150
     0.976    30.562     0.150
     0.988    19.328     0.150
     0.988    34.203     0.150
     1.186    20.688     0.150
     1.220    22.148     0.150
     1.220    37.219     0.150
     1.311    23.664     0.150
     1.311    39.906     0.150
     1.309    41.531     0.150
     1.331    24.898     0.150
     1.370    24.242     0.150
     2.231    40.867     0.150
     2.311    42.383     0.150
     0.249     5.148     0.150
     0.249     8.508     0.150
     0.383     7.879     0.150
     0.421     8.430     0.150
     0.421    14.047     0.150
     0.763    11.348     0.150
     0.763    18.859     0.150
     0.763    19.238     0.150
     0.763    21.277     0.150
     0.763    11.449     0.150
     0.763    19.039     0.150
     0.763    11.418     0.150
     0.763    18.828     0.150
     0.780    15.906     0.150
     0.989    18.027     0.150
     0.989    30.770     0.150
     1.200    43.449     0.150
     1.200    44.648     0.150
     1.200    38.020     0.150
     1.304    23.488     0.150
     1.304    39.629     0.150
     1.413    26.047     0.150
     1.651    30.277     0.150
     0.165     3.862     0.150
     0.469     9.333     0.150
     0.497     9.753     0.150
     0.497    16.053     0.150
     0.971    15.473     0.150
     0.971    26.213     0.150
     0.971    28.123     0.150
     0.971    15.433     0.150
     0.971    25.713     0.150
     0.971    15.343     0.150
     0.971    26.202     0.150
     0.939    17.312     0.150
     0.955    30.072     0.150
     1.168    20.503     0.150
     1.168    34.763     0.150
     1.168    20.402     0.150
     1.176    21.553     0.150
     1.198    37.513     0.150
     1.198    21.963     0.150
     1.198    37.373     0.150
     1.289    23.353     0.150
     1.289    39.803     0.150
     1.432    27.022     0.150
     0.272     5.973     0.150
     0.634    22.463     0.150
     0.634    21.043     0.150
     0.711    13.633     0.150
     0.810    15.592     0.150
     0.914    34.402     0.150
     0.914    16.943     0.150
     1.002    17.922     0.150
     1.002    29.992     0.150
     1.015    36.123     0.150
     1.015    18.453     0.150
     1.002    17.912     0.150
     1.002    29.992     0.150
     1.025    18.652     0.150
     1.025    32.133     0.150
     1.052    19.703     0.150
     1.099    19.992     0.150
     1.279    36.803     0.150
     1.279    21.002     0.150
     1.279    21.092     0.150
     1.279    36.152     0.150
     1.279    21.143     0.150
     1.279    35.172     0.150
     1.377    25.514     0.150
     1.604    29.652     0.150
     1.756    31.113     0.150
     2.102    38.354     0.150
     2.192    39.492     0.150
     0.062     3.160     0.150
     0.062     5.121     0.150
     0.062     5.371     0.150
     0.205     5.594     0.150
     0.205     9.102     0.150
     0.205     9.422     0.150
     0.205     9.160     0.150
     0.205     5.582     0.150
     0.418    14.922     0.150
     0.418     8.934     0.150
     0.485    10.160     0.150
     0.572    11.102     0.150
     0.572    18.684     0.150
     0.616    11.922     0.150
     0.616    11.922     0.150
     0.616    20.000     0.150
     0.746    13.621     0.150
     0.746    22.543     0.150
     0.714    13.410     0.150
     0.714    22.883     0.150
     0.714    13.410     0.150
     0.714    22.883     0.150
     0.746    13.594     0.150
     0.746    22.684     0.150
     0.791    15.184     0.150
     0.814    15.383     0.150
     0.991    19.473     0.150
     1.011    18.773     0.150
     1.011    31.312     0.150
     1.031    18.844     0.150
     1.031    32.312     0.150
     1.031    20.812     0.150
     1.074    21.141     0.150
     5.927    24.133     0.150
     1.303    22.512     0.150
     1.303    22.941     0.150
     1.303    39.461     0.150
     1.339    41.043     0.150
     1.558    43.660     0.150
     1.558    23.922     0.150
     1.558    25.012     0.150
     1.558    43.594     0.150
     1.558    44.863     0.150
     1.558    25.781     0.150
     1.558    43.660     0.150
     0.382     8.001     0.150
     0.763    11.571     0.150
     0.763    19.321     0.150
     0.763    21.491     0.150
     0.763    11.391     0.150
     0.763    18.951     0.150
     0.609    14.391     0.150
     0.609    24.421     0.150
     0.609    26.391     0.150
     0.609    27.611     0.150
     0.609    14.341     0.150
     0.609    24.101     0.150
     0.987    18.151     0.150
     0.963    32.381     0.150
     1.305    23.071     0.150
     1.305    39.441     0.150
     1.288    22.861     0.150
     1.305    22.881     0.150
     1.359    23.841     0.150
     1.413    31.401     0.150
     1.413    50.061     0.150
     1.479    27.721     0.150
     1.479    47.321     0.150
     1.795    29.141     0.150
     1.830    30.081     0.150
     1.866    36.701     0.150
     3.315    51.551     0.150
     0.183     4.107     0.150
     0.314     9.387     0.150
     0.314    16.086     0.150
     0.314    16.857     0.150
     0.314     9.406     0.150
     0.314    16.156     0.150
     0.539    10.646     0.150
     0.539    10.646     0.150
     0.539    18.188     0.150
     0.547    10.467     0.150
     0.867    17.047     0.150
     0.867    29.357     0.150
     1.043    16.656     0.150
     1.043    29.557     0.150
     1.043    30.086     0.150
     1.043    16.746     0.150
     1.043    16.637     0.150
     1.043    28.277     0.150
     0.988    18.146     0.150
     0.988    31.166     0.150
     0.988    18.146     0.150
     0.988    31.166     0.150
     0.985    35.416     0.150
     1.098    18.928     0.150
     1.098    32.268     0.150
     1.098    18.928     0.150
     1.109    20.076     0.150
     1.126    20.646     0.150
     1.216    21.867     0.150
     1.216    37.586     0.150
     1.492    26.566     0.150
     1.899    31.617     0.150
     0.101     7.059     0.150
     0.101    12.049     0.150
     0.301    14.738     0.150
     0.301     6.189     0.150
     0.101     7.098     0.150
     0.101    11.809     0.150
     0.650    12.479     0.150
     0.736    24.799     0.150
     0.736    13.768     0.150
     0.736    13.768     0.150
     0.736    23.408     0.150
     0.781    14.988     0.150
     0.895    29.299     0.150
     0.895    16.289     0.150
     0.945    16.508     0.150
     0.945    27.789     0.150
     0.945    16.508     0.150
     0.945    31.928     0.150
     0.945    32.439     0.150
     0.991    31.268     0.150
     0.991    17.789     0.150
     0.991    17.789     0.150
     0.991    30.408     0.150
     0.982    17.979     0.150
     0.995    18.318     0.150
     0.973    19.258     0.150
     0.973    33.139     0.150
     0.972    33.559     0.150
     1.084    19.098     0.150
     1.084    19.098     0.150
     1.084    32.488     0.150
     1.280    19.709     0.150
     1.280    20.119     0.150
     1.280    35.158     0.150
     1.280    19.459     0.150
     1.280    34.248     0.150
     1.129    37.969     0.150
     1.190    21.068     0.150
     1.263    22.439     0.150
     0.914    31.418     0.150
     1.845    31.369     0.150
     1.968    32.949     0.150
     1.992    35.572     0.150
     1.993    32.908     0.150
     6.955   103.189     0.150
     7.024   127.953     0.150
    10.836   152.568     0.150
    10.837   153.609     0.150
     0.279     5.470     0.150
     0.279     5.470     0.150
     0.279     9.000     0.150
     0.569    11.200     0.150
     0.916    21.450     0.150
     0.916    36.970     0.150
     0.916    39.310     0.150
     1.049    18.240     0.150
     1.049    30.460     0.150
     1.049    18.240     0.150
     1.049    30.870     0.150
     1.049    18.300     0.150
     1.049    30.420     0.150
     1.007    18.930     0.150
     0.916    21.660     0.150
     0.916    36.939     0.150
     1.415    25.100     0.150
     1.579    48.770     0.150
     1.694    52.040     0.150
     1.694    29.710     0.150
     1.694    52.040     0.150
     1.720    31.740     0.150
     1.720    55.340     0.150
     2.822    85.790     0.150
     2.822    49.960     0.150
     2.822    85.790     0.150
     4.661   125.830     0.150
     0.312     9.676     0.150
     0.312    16.246     0.150
     0.312     9.426     0.150
     0.312    15.887     0.150
     0.547    10.875     0.150
     0.542    10.666     0.150
     0.542    17.506     0.150
     0.855    15.936     0.150
     0.855    27.695     0.150
     1.044    16.715     0.150
     1.044    27.865     0.150
     1.044    16.766     0.150
     1.044    28.605     0.150
     1.044    16.766     0.150
     1.044    28.316     0.150
     0.999    18.406     0.150
     0.999    31.436     0.150
     1.091    19.295     0.150
     1.091    32.996     0.150
     1.091    19.227     0.150
     1.091    32.646     0.150
     1.101    20.236     0.150
     1.124    20.875     0.150
     1.124    20.896     0.150
     1.144    21.246     0.150
     1.213    22.215     0.150
     1.213    37.785     0.150
     1.216    23.125     0.150
     1.276    40.016     0.150
     1.503    26.336     0.150
     1.761    31.926     0.150
     2.215    36.605     0.150
     2.625    41.326     0.150
     3.937    57.105     0.150
     4.225   121.336     0.150
     4.948    70.525     0.150
     0.317     9.590     0.150
     0.317    16.570     0.150
     0.317     9.291     0.150
     0.317    15.602     0.150
     0.537    10.650     0.150
     0.542    10.781     0.150
     0.542    10.820     0.150
     0.542    18.170     0.150
     0.855    16.080     0.150
     0.855    27.840     0.150
     1.039    16.090     0.150
     1.039    27.762     0.150
     1.039    16.691     0.150
     1.039    28.121     0.150
     1.039    16.781     0.150
     1.039    28.150     0.150
     0.884    31.131     0.150
     0.996    18.281     0.150
     0.996    18.371     0.150
     0.996    31.461     0.150
     1.095    19.201     0.150
     1.095    32.730     0.150
     1.095    19.191     0.150
     1.095    32.691     0.150
     1.129    20.852     0.150
     1.129    35.740     0.150
     1.218    22.160     0.150
     1.218    22.160     0.150
     1.218    37.801     0.150
     1.256    39.361     0.150
     1.494    26.740     0.150
     2.097    33.340     0.150
     2.219    36.320     0.150
     3.183    57.881     0.150
     3.183    88.400     0.150
     5.177   136.811     0.150
     6.075    88.711     0.150
     6.272    92.320     0.150
     7.185   231.566     0.150
     7.897   116.420     0.150
     8.423   271.295     0.150
     9.172   295.301     0.150
    10.596   151.275     0.150
    75.308   226.211     0.150
    38.420   440.801     0.150
    38.420   440.801     0.150
     0.209     4.475     0.150
     0.312     9.873     0.150
     0.312    17.164     0.150
     0.464     9.273     0.150
     0.535    10.703     0.150
     0.535    17.443     0.150
     0.312    16.014     0.150
     0.312     9.914     0.150
     0.555    10.914     0.150
     0.555    10.943     0.150
     0.555    18.314     0.150
     0.841    15.934     0.150
     0.841    28.004     0.150
     1.045    16.834     0.150
     1.045    28.283     0.150
     1.045    16.254     0.150
     1.045    28.135     0.150
     1.045    16.854     0.150
     1.045    28.193     0.150
     1.012    18.564     0.150
     1.012    18.555     0.150
     1.012    31.645     0.150
     1.082    19.494     0.150
     1.082    32.645     0.150
     1.082    19.443     0.150
     1.082    33.123     0.150
     1.091    20.594     0.150
     1.136    21.484     0.150
     1.122    21.154     0.150
     1.206    23.363     0.150
     1.211    22.443     0.150
     1.211    22.443     0.150
     1.211    38.094     0.150
     1.477    27.135     0.150
     1.635    28.193     0.150
     1.635    28.094     0.150
     1.649    29.555     0.150
     1.883    30.834     0.150
     2.207    37.014     0.150
     3.193    58.193     0.150
     3.193    89.014     0.150
     3.346    50.895     0.150
     3.837    58.295     0.150
     4.214    55.123     0.150
     4.214   110.484     0.150
     5.120    77.564     0.150
     5.319    79.324     0.150
     0.201     4.242     0.150
     0.201     7.430     0.150
     0.297     9.477     0.150
     0.297    15.852     0.150
     0.297    16.359     0.150
     0.297     9.508     0.150
     0.297    15.719     0.150
     0.554    10.859     0.150
     0.562    11.008     0.150
     1.060    17.047     0.150
     1.060    28.930     0.150
     1.060    16.898     0.150
     1.060    28.906     0.150
     1.060    17.039     0.150
     1.060    28.531     0.150
     0.902    16.742     0.150
     1.009    18.328     0.150
     1.076    19.117     0.150
     1.076    32.602     0.150
     1.108    20.891     0.150
     2.017    35.219     0.150
     2.119    66.758     0.150
     2.200    36.477     0.150
     0.311     9.588     0.150
     0.311    16.418     0.150
     0.311    20.987     0.150
     0.311     9.598     0.150
     0.311    16.438     0.150
     0.547    10.878     0.150
     0.547    18.338     0.150
     0.543    10.748     0.150
     0.543    17.598     0.150
     0.893    28.367     0.150
     0.998    18.328     0.150
     0.998    18.328     0.150
     0.998    31.317     0.150
     1.091    19.157     0.150
     1.123    20.808     0.150
     1.091    19.157     0.150
     1.091    33.588     0.150
     1.212    22.197     0.150
     1.212    37.878     0.150
     1.216    22.947     0.150
     1.397    24.548     0.150
     1.485    47.518     0.150
     1.696    31.848     0.150
     2.134    39.458     0.150
     2.215    36.367     0.150
     3.416    56.128     0.150
     0.244     5.133     0.150
     0.244     8.473     0.150
     0.387     7.754     0.150
     0.407     8.352     0.150
     0.407     8.391     0.150
     0.407    13.973     0.150
     0.747    11.160     0.150
     0.747    18.684     0.150
     0.747    11.301     0.150
     0.747    18.633     0.150
     0.747    11.043     0.150
     0.747    18.254     0.150
     0.624    14.211     0.150
     0.624    24.594     0.150
     0.624    27.254     0.150
     0.651    20.723     0.150
     0.696    12.980     0.150
     0.779    24.812     0.150
     0.624    14.082     0.150
     0.624    23.703     0.150
     0.977    17.953     0.150
     0.977    17.953     0.150
     0.977    30.031     0.150
     0.973    19.273     0.150
     0.973    19.352     0.150
     0.973    34.121     0.150
     1.428    25.922     0.150
     1.428    43.773     0.150
     1.511    26.172     0.150
     1.511    26.172     0.150
     1.511    45.332     0.150
     1.605    29.594     0.150
     1.721    30.711     0.150
     2.444    40.844     0.150
     3.174    51.762     0.150
     0.288     6.074     0.150
     0.366    13.805     0.150
     0.482    12.154     0.150
     0.482    20.854     0.150
     0.482    24.613     0.150
     0.482    12.135     0.150
     0.482    20.693     0.150
     0.533    10.344     0.150
     0.482    12.023     0.150
     0.672    12.773     0.150
     0.644    12.154     0.150
     0.883    13.385     0.150
     0.883    23.014     0.150
     0.883    13.385     0.150
     0.883    23.373     0.150
     0.925    18.863     0.150
     0.925    31.734     0.150
     0.992    18.094     0.150
     0.992    31.164     0.150
     1.089    20.225     0.150
     1.089    34.873     0.150
     1.202    21.854     0.150
     1.202    36.734     0.150
     1.195    21.713     0.150
     1.202    21.824     0.150
     1.202    36.123     0.150
     1.288    24.004     0.150
     1.288    41.043     0.150
     1.372    24.984     0.150
     1.372    42.863     0.150
     1.601    50.914     0.150
     1.632    30.543     0.150
     1.669    49.963     0.150
     0.182     3.953     0.150
     0.338     9.984     0.150
     0.338    16.926     0.150
     0.338    17.555     0.150
     0.338    10.035     0.150
     0.490    18.645     0.150
     0.338     9.945     0.150
     0.338    16.926     0.150
     0.533    10.035     0.150
     0.520    10.453     0.150
     0.520    10.453     0.150
     0.520    17.434     0.150
     1.018    16.363     0.150
     1.018    29.266     0.150
     1.018    16.395     0.150
     1.018    28.145     0.150
     1.018    29.844     0.150
     0.931    16.984     0.150
     0.950    18.965     0.150
     0.950    33.156     0.150
     0.978    17.895     0.150
     1.117    19.703     0.150
     1.117    19.605     0.150
     1.117    33.113     0.150
     1.117    36.543     0.150
     1.150    44.785     0.150
     1.150    21.184     0.150
     1.240    22.453     0.150
     1.240    22.453     0.150
     1.240    38.113     0.150
     1.303    23.523     0.150
     1.512    27.156     0.150
     1.529    27.625     0.150
     1.930    33.434     0.150
     0.910    35.934     0.150
     2.161    36.516     0.150
     4.216    63.746     0.150
     4.216   115.336     0.150
     5.372    80.926     0.150
     5.372   143.965     0.150
     0.332     9.949     0.150
     0.332    16.949     0.150
     0.332    18.340     0.150
     0.462     9.000     0.150
     0.462    15.332     0.150
     0.533    10.109     0.150
     0.332     9.770     0.150
     0.332    16.652     0.150
     1.024    16.410     0.150
     1.024    27.602     0.150
     0.984    18.109     0.150
     0.984    31.289     0.150
     1.015    20.512     0.150
     1.111    19.629     0.150
     1.111    19.512     0.150
     1.234    22.461     0.150
     1.506    26.781     0.150
     3.866    57.719     0.150
     0.287     6.027     0.150
     0.287    10.078     0.150
     0.345     7.066     0.150
     0.383     7.676     0.150
     0.383    12.707     0.150
     0.765    11.438     0.150
     0.765    19.297     0.150
     0.765    21.598     0.150
     0.765    11.496     0.150
     0.765    19.297     0.150
     0.765    11.477     0.150
     0.765    19.328     0.150
     0.597    14.258     0.150
     0.597    24.426     0.150
     0.597    25.457     0.150
     0.645    21.086     0.150
     0.737    13.676     0.150
     0.714    13.629     0.150
     0.597    14.219     0.150
     0.597    24.445     0.150
     0.945    17.156     0.150
     0.945    29.328     0.150
     0.945    17.168     0.150
     0.945    29.418     0.150
     1.190    21.586     0.150
     1.316    22.559     0.150
     1.304    24.117     0.150
     1.316    22.809     0.150
     1.316    39.648     0.150
     1.370    25.898     0.150
     1.405    25.355     0.150
     1.405    44.297     0.150
     1.490    26.617     0.150
     1.671    30.227     0.150
     1.701    28.566     0.150
     1.715    29.766     0.150
     1.715    52.777     0.150
     1.919    34.598     0.150
     2.037    61.629     0.150
     2.166    43.887     0.150
     0.167     3.753     0.150
     0.381    11.083     0.150
     0.381    18.833     0.150
     0.381    19.284     0.150
     0.475     9.383     0.150
     0.499     9.733     0.150
     0.510    10.083     0.150
     0.540    10.264     0.150
     0.540    17.653     0.150
     0.381    11.003     0.150
     0.381    18.604     0.150
     0.700    13.293     0.150
     0.976    15.403     0.150
     0.976    26.624     0.150
     0.976    15.363     0.150
     0.976    26.043     0.150
     0.976    15.543     0.150
     0.976    26.443     0.150
     0.944    17.144     0.150
     0.944    29.394     0.150
     0.944    17.074     0.150
     0.962    30.733     0.150
     1.162    20.784     0.150
     1.193    37.554     0.150
     1.284    23.304     0.150
     1.284    39.974     0.150
     1.286    41.833     0.150
     1.557    28.844     0.150
     1.557    48.644     0.150
     1.858    32.514     0.150
     1.860    56.713     0.150
     2.218    39.494     0.150
     0.169     3.906     0.150
     0.169     6.367     0.150
     0.169     3.855     0.150
     0.169     6.127     0.150
     0.169     6.627     0.150
     0.346    11.186     0.150
     0.561    18.096     0.150
     0.562    10.416     0.150
     0.560    10.947     0.150
     0.644    12.287     0.150
     0.644    12.217     0.150
     0.644    20.826     0.150
     0.711    12.527     0.150
     0.711    20.826     0.150
     0.734    13.355     0.150
     0.759    14.207     0.150
     0.769    14.076     0.150
     0.806    14.686     0.150
     0.806    25.127     0.150
     0.858    28.297     0.150
     0.874    29.477     0.150
     0.955    19.105     0.150
     0.979    17.947     0.150
     0.979    30.766     0.150
     0.998    19.877     0.150
     1.077    19.105     0.150
     1.077    34.527     0.150
     1.322    23.207     0.150
     1.322    23.127     0.150
     1.524    24.787     0.150
     1.524    25.217     0.150
     1.524    43.057     0.150
     1.524    25.146     0.150
     1.524    40.547     0.150
     1.456    25.727     0.150
     0.320     6.531     0.150
     0.322     6.352     0.150
     0.322    10.662     0.150
     0.738    10.932     0.150
     0.738    18.291     0.150
     0.738    20.781     0.150
     0.738    10.912     0.150
     0.738    18.201     0.150
     0.619    14.752     0.150
     0.619    25.902     0.150
     0.619    28.832     0.150
     0.882    29.541     0.150
     0.882    16.082     0.150
     0.882    27.762     0.150
     1.698    30.822     0.150
     1.761    32.291     0.150
     1.761    55.381     0.150
     2.088    62.582     0.150
     2.413    41.701     0.150
     4.517    67.711     0.150
     5.677    84.531     0.150
     0.321     6.582     0.150
     0.316     6.344     0.150
     0.316    10.562     0.150
     0.332     6.922     0.150
     0.332    11.594     0.150
     0.732    10.941     0.150
     0.732    18.312     0.150
     0.732    20.824     0.150
     0.732    10.941     0.150
     0.732    18.395     0.150
     0.732    10.934     0.150
     0.732    18.293     0.150
     0.624    15.012     0.150
     0.624    25.902     0.150
     0.624    28.773     0.150
     0.719    13.441     0.150
     0.719    22.875     0.150
     0.696    13.215     0.150
     0.696    22.723     0.150
     0.885    16.191     0.150
     0.885    27.773     0.150
     0.885    16.254     0.150
     0.885    27.734     0.150
     0.777    14.613     0.150
     0.624    15.023     0.150
     0.624    25.852     0.150
     1.357    23.875     0.150
     1.706    30.742     0.150
     1.764    29.902     0.150
     1.800    32.562     0.150
     2.226    39.734     0.150
     2.887    75.203     0.150
     6.456    90.234     0.150
     0.293     5.926     0.150
     0.293     9.945     0.150
     0.339     7.125     0.150
     0.381     7.586     0.150
     0.381     7.586     0.150
     0.381    12.664     0.150
     0.768    11.344     0.150
     0.768    19.043     0.150
     0.768    21.496     0.150
     0.768    11.355     0.150
     0.768    19.094     0.150
     0.768    11.355     0.150
     0.768    19.094     0.150
     0.593    14.305     0.150
     0.593    24.312     0.150
     0.593    27.164     0.150
     0.644    12.355     0.150
     0.644    20.773     0.150
     0.716    13.613     0.150
     0.730    13.703     0.150
     0.593    14.305     0.150
     0.593    24.293     0.150
     0.941    17.234     0.150
     0.941    29.266     0.150
     0.941    17.234     0.150
     0.941    29.266     0.150
     0.995    20.055     0.150
     0.995    34.543     0.150
     1.184    21.715     0.150
     1.256    22.105     0.150
     1.303    22.863     0.150
     1.303    41.613     0.150
     1.303    22.723     0.150
     1.314    23.184     0.150
     1.314    40.016     0.150
     1.368    24.285     0.150
     1.401    45.664     0.150
     1.401    26.035     0.150
     1.401    44.004     0.150
     1.425    45.793     0.150
     1.453    41.633     0.150
     1.479    26.355     0.150
     1.487    26.723     0.150
     1.487    46.184     0.150
     1.532    25.543     0.150
     1.699    31.773     0.150
     1.713    31.484     0.150
     1.725    31.473     0.150
     1.911    35.656     0.150
     1.916    34.773     0.150
     2.036    37.074     0.150
     2.148    39.035     0.150
     2.186    38.855     0.150
     4.016    98.613     0.150
     0.178     3.977     0.150
     0.420    11.367     0.150
     0.420    19.273     0.150
     0.540    10.145     0.150
     0.540    17.547     0.150
     0.420    11.375     0.150
     0.420    19.457     0.150
     0.712    13.117     0.150
     0.937    14.906     0.150
     0.937    25.574     0.150
     0.937    14.867     0.150
     0.937    25.055     0.150
     0.937    27.586     0.150
     0.873    16.684     0.150
     0.873    31.016     0.150
     0.926    29.605     0.150
     1.232    22.406     0.150
     0.184     3.969     0.150
     0.184     7.547     0.150
     0.470    19.289     0.150
     0.470     9.066     0.150
     0.410    11.340     0.150
     0.410    19.238     0.150
     0.410    19.707     0.150
     0.456     8.840     0.150
     0.456    14.887     0.150
     0.526    10.168     0.150
     0.562    19.379     0.150
     0.410    11.328     0.150
     0.410    19.348     0.150
     0.565    10.629     0.150
     0.565    19.777     0.150
     0.699    13.207     0.150
     0.946    14.797     0.150
     0.946    25.078     0.150
     0.946    14.918     0.150
     0.946    25.629     0.150
     0.946    30.816     0.150
     0.946    14.797     0.150
     0.946    25.078     0.150
     0.978    18.617     0.150
     0.978    33.559     0.150
     0.939    17.117     0.150
     0.939    17.277     0.150
     0.939    38.590     0.150
     0.939    17.207     0.150
     0.939    29.117     0.150
     0.993    18.117     0.150
     1.222    22.438     0.150
     1.222    38.688     0.150
     1.222    22.379     0.150
     1.222    38.738     0.150
     1.312    23.719     0.150
     1.312    23.719     0.150
     1.312    40.680     0.150
     3.089   101.438     0.150
     4.177   117.207     0.150
     7.864   115.668     0.150
    18.065   121.957     0.150
    10.525   327.387     0.150
    11.705   369.820     0.150
    15.511   219.207     0.150
    16.796   240.273     0.150
    23.825   311.609     0.150
    82.313   741.137     0.150
   120.290  1135.633     0.150
     0.412    11.410     0.150
     0.412    19.500     0.150
     0.412    20.168     0.150
     0.452     9.000     0.150
     0.471     9.207     0.150
     0.944    14.938     0.150
     0.944    25.098     0.150
     0.944    27.641     0.150
     0.944    14.898     0.150
     0.944    25.469     0.150
     0.183     3.914     0.150
     0.183     7.023     0.150
     0.415    11.285     0.150
     0.415    19.336     0.150
     0.415    19.613     0.150
     0.450     9.035     0.150
     0.468     8.973     0.150
     0.532    10.125     0.150
     0.565    18.324     0.150
     0.415    11.293     0.150
     0.415    19.324     0.150
     0.703    13.086     0.150
     0.941    14.895     0.150
     0.941    25.293     0.150
     0.941    14.883     0.150
     0.941    25.543     0.150
     0.941    14.945     0.150
     0.941    25.465     0.150
     0.934    29.863     0.150
     0.934    17.195     0.150
     1.189    20.574     0.150
     1.189    35.105     0.150
     1.194    36.203     0.150
     1.311    24.934     0.150
     1.311    41.664     0.150
     1.695    30.242     0.150
     2.005    36.215     0.150
     3.100    64.203     0.150
     0.173     6.703     0.150
     0.173     6.637     0.150
     0.476    15.727     0.150
     0.413    11.137     0.150
     0.413    19.426     0.150
     0.413    20.523     0.150
     0.944    25.535     0.150
     0.944    14.926     0.150
     0.944    26.066     0.150
     0.944    27.664     0.150
     0.944    14.863     0.150
     0.944    25.363     0.150
     1.533    44.203     0.150
     2.246    39.215     0.150
     0.453     9.008     0.150
     0.469     9.016     0.150
     0.469    15.246     0.150
     0.412    11.336     0.150
     0.412    19.168     0.150
     0.412    19.508     0.150
     0.412    20.055     0.150
     0.944    14.895     0.150
     0.944    25.125     0.150
     0.944    27.598     0.150
     0.944    29.305     0.150
     0.944    14.895     0.150
     0.944    25.238     0.150
     0.937    17.086     0.150
     1.190    36.336     0.150
     1.307    42.066     0.150
     1.521    43.867     0.150
     1.499    27.355     0.150
     1.693    31.227     0.150
     2.241    38.855     0.150
     0.399    11.488     0.150
     0.399    19.250     0.150
     0.471     9.238     0.150
     0.473     9.289     0.150
     0.473    15.680     0.150
     0.550    10.938     0.150
     0.958    15.027     0.150
     0.958    25.449     0.150
     0.958    15.098     0.150
     0.958    25.648     0.150
     0.954    17.398     0.150
     1.299    24.000     0.150
     1.483    27.320     0.150
     1.483    46.211     0.150
     1.511    35.000     0.150
     1.575    48.469     0.150
     1.678    35.719     0.150
     2.004    40.379     0.150
     2.132    40.320     0.150
     2.149    38.777     0.150
     2.179    41.250     0.150
     2.223    41.430     0.150
     2.421    46.469     0.150
     2.512    44.277     0.150
     2.674    46.668     0.150
     0.408    19.215     0.150
     0.458     9.195     0.150
     0.471     9.332     0.150
     0.948    14.492     0.150
     0.948    25.672     0.150
     0.948    14.355     0.150
     0.948    25.715     0.150
     0.940    16.863     0.150
     0.940    28.312     0.150
     1.181    21.734     0.150
     1.181    35.164     0.150
     1.186    37.504     0.150
     1.310    23.535     0.150
     1.310    24.734     0.150
     1.494    27.465     0.150
     0.183     3.980     0.150
     0.409    11.281     0.150
     0.409    19.102     0.150
     0.409    19.582     0.150
     0.456     9.062     0.150
     0.456     9.062     0.150
     0.456    15.023     0.150
     0.471    18.273     0.150
     0.471     9.203     0.150
     0.471    15.492     0.150
     0.525    10.082     0.150
     0.563    10.582     0.150
     0.563    19.121     0.150
     0.409    11.281     0.150
     0.409    19.082     0.150
     0.700    13.121     0.150
     0.948    14.973     0.150
     0.948    25.191     0.150
     0.948    14.980     0.150
     0.948    25.094     0.150
     0.948    27.953     0.150
     0.948    28.652     0.150
     0.948    14.973     0.150
     0.948    25.191     0.150
     0.939    17.211     0.150
     0.939    17.172     0.150
     0.939    28.883     0.150
     0.991    18.043     0.150
     0.991    31.203     0.150
     0.979    19.281     0.150
     0.979    32.414     0.150
     1.182    20.621     0.150
     1.182    35.242     0.150
     1.221    22.312     0.150
     1.221    22.320     0.150
     1.221    38.281     0.150
     1.311    23.781     0.150
     1.311    23.781     0.150
     1.311    40.203     0.150
     3.090    57.562     0.150
     3.090    99.422     0.150
     3.373    51.344     0.150
    10.527   154.871     0.150
    12.242   181.457     0.150
    31.025   382.137     0.150
     0.183    53.699     0.150
     0.183     4.012     0.150
     0.183     7.230     0.150
     0.416    11.320     0.150
     0.416    19.199     0.150
     0.450     9.070     0.150
     0.450    14.980     0.150
     0.466    58.840     0.150
     0.467     9.039     0.150
     0.532    59.699     0.150
     0.532    10.000     0.150
     0.566    60.402     0.150
     0.566    10.652     0.150
     0.416    11.289     0.150
     0.416    19.359     0.150
     0.416    60.910     0.150
     0.703    63.660     0.150
     0.703    13.039     0.150
     0.941    15.039     0.150
     0.941    25.340     0.150
     0.941    64.680     0.150
     0.941    15.031     0.150
     0.941    25.281     0.150
     0.941    15.012     0.150
     0.941    24.832     0.150
     0.865    66.660     0.150
     0.934    67.582     0.150
     0.934    17.242     0.150
     0.934    29.680     0.150
     0.934    17.289     0.150
     0.996    18.199     0.150
     0.983    21.461     0.150
     1.052    18.281     0.150
     1.168    71.211     0.150
     1.189    21.051     0.150
     1.189    35.109     0.150
     1.194    71.832     0.150
     1.194    86.832     0.150
     1.194    21.750     0.150
     1.194    36.969     0.150
     1.228    72.551     0.150
     1.228    22.449     0.150
     1.228    22.492     0.150
     1.243    72.789     0.150
     1.243    22.789     0.150
     1.243    38.441     0.150
     1.311    24.930     0.150
     1.503    76.660     0.150
     1.503    95.789     0.150
     1.522    78.219     0.150
     1.522    94.922     0.150
     1.594    28.871     0.150
     2.165    38.102     0.150
     2.244    41.262     0.150
     0.420    11.318     0.150
     0.420    19.398     0.150
     0.420    19.879     0.150
     0.420    20.799     0.150
     0.445    15.238     0.150
     0.445    18.568     0.150
     0.445    18.568     0.150
     0.445     8.838     0.150
     0.445    15.180     0.150
     0.467    19.859     0.150
     0.467     9.189     0.150
     0.467    15.729     0.150
     0.571    19.078     0.150
     0.565    19.668     0.150
     0.565    19.689     0.150
     0.937    14.949     0.150
     0.937    25.869     0.150
     0.937    14.939     0.150
     0.937    25.738     0.150
     0.937    28.049     0.150
     0.937    14.949     0.150
     0.937    25.869     0.150
     0.929    29.629     0.150
     0.929    31.199     0.150
     0.929    16.949     0.150
     0.929    29.639     0.150
     0.987    19.439     0.150
     0.987    34.539     0.150
     0.998    30.588     0.150
     1.194    21.049     0.150
     1.194    35.199     0.150
     1.194    38.279     0.150
     1.232    22.549     0.150
     1.232    38.998     0.150
     1.316    24.559     0.150
     1.316    41.619     0.150
     1.322    23.779     0.150
     1.322    40.729     0.150
     1.322    23.779     0.150
     1.322    40.729     0.150
     1.378    24.949     0.150
     1.440    25.279     0.150
     1.474    25.088     0.150
     1.474    25.289     0.150
     1.507    46.238     0.150
     1.507    49.789     0.150
     1.507    50.258     0.150
     6.457    50.959     0.150
     1.610    53.539     0.150
     2.169    38.119     0.150
     3.291    48.350     0.150
     4.177    63.328     0.150
     4.177   111.359     0.150
     4.709    71.318     0.150
     4.709   126.129     0.150
     5.073   135.680     0.150
     5.308    79.729     0.150
     5.308   142.439     0.150
     9.664    99.119     0.150
     6.640    99.189     0.150
     6.640   168.350     0.150
     7.833   114.559     0.150
     7.833   199.699     0.150
    16.807   240.188     0.150
    31.036   378.068     0.150
    38.520   440.729     0.150
    79.687   729.879     0.150
    92.516   793.930     0.150
     0.447     8.967     0.150
     0.447    15.076     0.150
     0.447     8.938     0.150
     0.447    15.027     0.150
     0.465     9.047     0.150
     0.465    15.086     0.150
     0.419    11.438     0.150
     0.419    19.127     0.150
     0.419    20.117     0.150
     0.419    20.377     0.150
     0.938    14.807     0.150
     0.938    25.277     0.150
     0.938    14.807     0.150
     0.938    25.367     0.150
     0.938    27.316     0.150
     0.938    14.807     0.150
     0.938    25.277     0.150
     0.933    17.156     0.150
     0.933    17.127     0.150
     0.933    29.377     0.150
     1.196    21.758     0.150
     1.231    22.607     0.150
     1.231    22.688     0.150
     1.231    38.076     0.150
     0.467     9.500     0.150
     0.465     9.203     0.150
     0.465    15.320     0.150
     0.406    11.031     0.150
     0.406    18.242     0.150
     0.951    15.062     0.150
     0.951    25.402     0.150
     0.951    15.223     0.150
     0.951    25.180     0.150
     0.953    17.680     0.150
     1.172    19.703     0.150
     1.172    34.551     0.150
     1.306    23.820     0.150
     5.709    87.273     0.150
     0.452     9.102     0.150
     0.477     9.492     0.150
     0.477    15.730     0.150
     0.409    11.422     0.150
     0.409    19.711     0.150
     0.409    21.312     0.150
     0.948    15.043     0.150
     0.948    25.680     0.150
     0.948    15.113     0.150
     0.948    25.242     0.150
     0.931    17.082     0.150
     1.221    22.562     0.150
     0.323     7.203     0.150
     0.323    11.934     0.150
     0.378    11.953     0.150
     0.378    20.203     0.150
     0.378    23.453     0.150
     0.487    17.793     0.150
     0.487     9.516     0.150
     0.701    13.594     0.150
     0.701    22.605     0.150
     0.814    15.246     0.150
     0.814    25.984     0.150
     1.083    17.863     0.150
     1.083    30.266     0.150
     1.083    31.535     0.150
     1.083    17.836     0.150
     1.083    29.395     0.150
     1.748    50.625     0.150
     1.843    30.965     0.150
     2.823    47.145     0.150
     0.437     8.770     0.150
     0.437    14.668     0.150
     0.508    20.539     0.150
     0.508    10.109     0.150
     0.508    16.930     0.150
     0.406    11.621     0.150
     0.406    19.531     0.150
     0.406    20.539     0.150
     0.520    18.500     0.150
     0.957    15.250     0.150
     0.957    25.828     0.150
     0.957    15.340     0.150
     0.957    25.801     0.150
     0.900    29.629     0.150
     0.900    16.430     0.150
     0.900    28.078     0.150
     1.594    28.488     0.150
     6.242    89.840     0.150
     0.180     3.918     0.150
     0.406    11.168     0.150
     0.406    18.979     0.150
     0.475     9.258     0.150
     0.524    10.008     0.150
     0.560    10.529     0.150
     0.406    11.139     0.150
     0.406    18.949     0.150
     0.700    13.039     0.150
     0.951    15.039     0.150
     0.951    26.139     0.150
     0.951    15.049     0.150
     0.951    27.328     0.150
     0.951    15.049     0.150
     0.951    24.979     0.150
     0.862    16.549     0.150
     0.862    28.918     0.150
     0.939    17.178     0.150
     0.939    29.639     0.150
     0.939    17.148     0.150
     0.987    18.189     0.150
     0.987    31.168     0.150
     1.180    20.588     0.150
     1.180    34.979     0.150
     1.186    21.639     0.150
     1.218    22.258     0.150
     1.234    22.678     0.150
     1.303    24.568     0.150
     3.093    89.369     0.150
     4.182    64.219     0.150
     0.186     4.000     0.150
     0.466     9.220     0.150
     0.466     9.240     0.150
     0.466    15.730     0.150
     0.474     9.360     0.150
     0.474    15.540     0.150
     0.401    11.140     0.150
     0.401    19.050     0.150
     0.401    20.080     0.150
     0.516     9.990     0.150
     0.563    10.590     0.150
     0.553    20.820     0.150
     0.401    11.130     0.150
     0.401    19.600     0.150
     0.692    24.170     0.150
     0.692    13.090     0.150
     0.955    15.200     0.150
     0.955    26.460     0.150
     0.955    15.170     0.150
     0.955    26.100     0.150
     0.955    15.200     0.150
     0.955    26.460     0.150
     0.947    17.390     0.150
     0.947    29.410     0.150
     0.947    17.300     0.150
     0.947    29.380     0.150
     0.971    18.990     0.150
     0.971    33.290     0.150
     0.986    18.040     0.150
     1.173    20.670     0.150
     1.173    35.100     0.150
     1.213    22.210     0.150
     1.213    22.290     0.150
     1.213    37.850     0.150
     1.303    23.620     0.150
     1.303    23.620     0.150
     1.303    40.070     0.150
     1.487    45.850     0.150
     1.569    27.800     0.150
     1.569    49.090     0.150
     3.099    58.880     0.150
     3.099    58.880     0.150
     3.099    98.240     0.150
     4.179   115.390     0.150
     4.179   115.390     0.150
     5.699    87.270     0.150
     8.400   126.219     0.150
     9.233   296.675     0.150
     0.187     4.037     0.150
     0.402    11.057     0.150
     0.402    18.807     0.150
     0.402    19.467     0.150
     0.402    19.498     0.150
     0.466     9.297     0.150
     0.466    15.637     0.150
     0.473     9.357     0.150
     0.515    18.287     0.150
     0.515     9.877     0.150
     0.515    16.597     0.150
     0.564    10.607     0.150
     0.402    11.077     0.150
     0.402    18.647     0.150
     0.691    12.927     0.150
     0.955    15.197     0.150
     0.955    25.748     0.150
     0.955    15.167     0.150
     0.955    25.837     0.150
     0.955    27.817     0.150
     0.955    15.217     0.150
     0.955    25.208     0.150
     0.853    16.438     0.150
     0.948    17.357     0.150
     0.948    17.447     0.150
     0.948    29.827     0.150
     1.213    22.277     0.150
     1.303    23.478     0.150
     1.303    40.257     0.150
     1.568    27.518     0.150
     0.393    11.260     0.150
     0.393    18.789     0.150
     0.474     9.330     0.150
     0.474    15.629     0.150
     0.479     9.479     0.150
     0.508    10.029     0.150
     0.508    16.818     0.150
     0.561    10.639     0.150
     0.561    18.260     0.150
     0.561    18.260     0.150
     0.393    11.279     0.150
     0.393    19.648     0.150
     0.687    13.199     0.150
     0.963    15.309     0.150
     0.963    25.410     0.150
     0.963    15.250     0.150
     0.963    25.580     0.150
     0.963    15.260     0.150
     0.963    25.129     0.150
     0.918    24.869     0.150
     0.918    42.309     0.150
     0.953    17.350     0.150
     0.953    17.260     0.150
     0.980    18.139     0.150
     1.029    32.398     0.150
     1.164    20.799     0.150
     1.164    34.719     0.150
     1.170    38.080     0.150
     1.205    22.430     0.150
     1.205    22.430     0.150
     1.294    23.619     0.150
     1.294    39.559     0.150
     4.996    74.488     0.150
     0.178     4.008     0.150
     0.178     6.945     0.150
     0.401    11.102     0.150
     0.401    18.758     0.150
     0.461     9.211     0.150
     0.461    15.578     0.150
     0.461     9.211     0.150
     0.461    15.602     0.150
     0.479     9.438     0.150
     0.521     9.883     0.150
     0.521    16.680     0.150
     0.556    10.531     0.150
     0.556    18.016     0.150
     0.401    11.117     0.150
     0.401    18.766     0.150
     0.700    12.961     0.150
     0.955    15.156     0.150
     0.955    25.578     0.150
     0.955    15.133     0.150
     0.955    25.578     0.150
     0.955    15.156     0.150
     0.955    25.578     0.150
     0.931    24.758     0.150
     0.931    42.266     0.150
     0.940    29.367     0.150
     0.940    17.258     0.150
     0.940    29.289     0.150
     0.979    19.422     0.150
     0.979    33.102     0.150
     1.177    20.766     0.150
     1.177    34.633     0.150
     1.183    36.781     0.150
     1.213    22.109     0.150
     1.213    22.195     0.150
     1.213    37.461     0.150
     1.303    23.547     0.150
     1.303    23.547     0.150
     1.303    39.688     0.150
     1.488    26.531     0.150
     1.572    27.562     0.150
     1.572    49.000     0.150
     3.097    92.516     0.150
     0.180     3.969     0.150
     0.474     9.328     0.150
     0.474     9.379     0.150
     0.474    15.320     0.150
     0.486     9.547     0.150
     0.509     9.969     0.150
     0.509    16.719     0.150
     0.554    10.547     0.150
     0.389    11.117     0.150
     0.968    15.359     0.150
     0.968    24.699     0.150
     0.968    15.340     0.150
     0.968    26.348     0.150
     0.968    15.359     0.150
     0.968    24.699     0.150
     0.950    28.617     0.150
     0.950    17.367     0.150
     0.950    28.617     0.150
     0.970    19.270     0.150
     0.970    33.039     0.150
     1.201    22.250     0.150
     1.201    37.809     0.150
     1.291    23.410     0.150
     1.291    39.719     0.150
     1.559    28.750     0.150
     1.979    35.797     0.150
     0.181     3.982     0.150
     0.181     6.893     0.150
     0.411    11.572     0.150
     0.411    19.672     0.150
     0.454     8.852     0.150
     0.471     9.172     0.150
     0.528    10.342     0.150
     0.528    17.461     0.150
     0.562    10.662     0.150
     0.411    11.631     0.150
     0.411    19.592     0.150
     0.702    13.312     0.150
     0.946    14.852     0.150
     0.946    14.771     0.150
     0.946    24.881     0.150
     0.946    14.803     0.150
     0.946    25.281     0.150
     0.936    31.281     0.150
     0.936    17.021     0.150
     0.934    43.102     0.150
     0.992    18.312     0.150
     1.049    38.121     0.150
     1.049    38.412     0.150
     1.185    21.092     0.150
     1.185    35.232     0.150
     1.190    21.951     0.150
     1.313    24.002     0.150
     1.313    40.881     0.150
     1.498    46.621     0.150
     2.150    35.242     0.150
     0.412    11.264     0.150
     0.412    19.072     0.150
     0.412    20.242     0.150
     0.412    21.133     0.150
     0.450     9.062     0.150
     0.450    18.303     0.150
     0.450     9.033     0.150
     0.450    15.562     0.150
     0.474     9.363     0.150
     0.532    10.232     0.150
     0.532    17.203     0.150
     0.412    11.293     0.150
     0.412    19.184     0.150
     0.945    15.014     0.150
     0.945    25.203     0.150
     0.945    14.934     0.150
     0.945    25.273     0.150
     0.945    15.014     0.150
     0.945    25.203     0.150
     0.932    17.143     0.150
     0.932    29.203     0.150
     1.224    22.652     0.150
     1.224    38.273     0.150
     1.314    40.424     0.150
     1.314    23.783     0.150
     1.314    40.424     0.150
     1.499    26.613     0.150
     1.550    48.643     0.150
     1.699    30.273     0.150
     2.697    45.293     0.150
     3.086    58.713     0.150
     0.181     4.066     0.150
     0.181     6.918     0.150
     0.404    11.195     0.150
     0.404    18.816     0.150
     0.404    19.297     0.150
     0.460     9.227     0.150
     0.475     9.398     0.150
     0.475    15.547     0.150
     0.522     9.988     0.150
     0.522    16.828     0.150
     0.560    10.586     0.150
     0.560    18.238     0.150
     0.404    11.188     0.150
     0.404    18.828     0.150
     0.698    13.098     0.150
     0.952    15.188     0.150
     0.952    25.418     0.150
     0.952    15.176     0.150
     0.952    25.969     0.150
     0.952    15.156     0.150
     0.952    25.527     0.150
     0.941    17.277     0.150
     0.941    17.258     0.150
     0.941    29.629     0.150
     0.987    17.977     0.150
     1.178    20.656     0.150
     1.178    34.879     0.150
     1.184    21.078     0.150
     1.216    22.398     0.150
     1.306    40.957     0.150
     1.306    23.695     0.150
     1.429    27.387     0.150
     0.182     4.031     0.150
     0.182     7.121     0.150
     0.182     7.531     0.150
     0.465     9.262     0.150
     0.477     9.293     0.150
     0.477    15.492     0.150
     0.400    10.961     0.150
     0.400    18.492     0.150
     0.400    19.293     0.150
     0.517     9.762     0.150
     0.560    10.551     0.150
     0.400    10.973     0.150
     0.400    18.641     0.150
     0.957    15.191     0.150
     0.957    25.883     0.150
     0.957    15.141     0.150
     0.957    25.910     0.150
     0.957    14.871     0.150
     0.957    25.191     0.150
     0.945    17.320     0.150
     0.182     4.055     0.150
     0.400    11.012     0.150
     0.400    18.445     0.150
     0.400    20.652     0.150
     0.465     9.312     0.150
     0.477     9.324     0.150
     0.477    15.523     0.150
     0.517    16.555     0.150
     0.560    10.574     0.150
     0.400    11.012     0.150
     0.400    18.582     0.150
     0.695    12.883     0.150
     0.957    15.203     0.150
     0.957    25.574     0.150
     0.957    15.223     0.150
     0.957    25.895     0.150
     0.957    15.184     0.150
     0.957    25.914     0.150
     1.296    24.402     0.150
     1.778    33.184     0.150
     1.989    35.652     0.150
     0.105     2.578     0.150
     0.105     4.398     0.150
     0.256     4.609     0.150
     0.256     7.734     0.150
     0.256     4.594     0.150
     0.256     7.742     0.150
     0.256     8.086     0.150
     0.422     8.078     0.150
     0.422    13.172     0.150
     0.487     9.734     0.150
     0.556    10.703     0.150
     0.556    18.398     0.150
     0.556    10.672     0.150
     0.556    18.305     0.150
     0.583    10.773     0.150
     0.583    19.375     0.150
     0.636    11.812     0.150
     0.684    11.984     0.150
     0.684    20.227     0.150
     0.728    13.586     0.150
     0.728    23.125     0.150
     0.758    14.008     0.150
     0.924    16.688     0.150
     1.074    19.742     0.150
     1.073    19.562     0.150
     1.371    39.086     0.150
     1.613    27.773     0.150
     1.613    26.898     0.150
     1.613    45.867     0.150
     1.613    27.109     0.150
     1.613    43.406     0.150
     0.895    44.938     0.150
     1.662    52.055     0.150
     1.726    31.508     0.150
     1.749    31.734     0.150
     1.749    54.203     0.150
     1.788    54.727     0.150
     1.963    33.648     0.150
     2.395    36.664     0.150
     4.606    70.594     0.150
     0.395    11.199     0.150
     0.395    18.961     0.150
     0.395    22.801     0.150
     0.475     9.391     0.150
     0.475    15.711     0.150
     0.474     9.480     0.150
     0.474    15.711     0.150
     0.961    15.379     0.150
     0.961    26.562     0.150
     0.961    15.352     0.150
     0.961    25.910     0.150
     0.957    17.520     0.150
     1.296    23.742     0.150
     1.296    40.562     0.150
     1.560    27.973     0.150
     1.560    48.652     0.150
     0.175     4.016     0.150
     0.175     6.875     0.150
     0.405    11.145     0.150
     0.405    18.324     0.150
     0.405    19.914     0.150
     0.456     9.184     0.150
     0.478     9.414     0.150
     0.478    15.535     0.150
     0.555    10.523     0.150
     0.405    11.145     0.150
     0.704    13.086     0.150
     0.952    15.145     0.150
     0.952    25.383     0.150
     0.952    15.023     0.150
     0.952    25.836     0.150
     0.952    15.113     0.150
     0.952    26.746     0.150
     0.935    17.195     0.150
     0.935    29.656     0.150
     0.935    17.195     0.150
     1.182    20.543     0.150
     1.182    34.684     0.150
     1.217    22.324     0.150
     1.308    23.426     0.150
     1.308    39.914     0.150
     1.493    26.484     0.150
     1.493    46.246     0.150
     1.493    48.426     0.150
     2.151    37.676     0.150
     2.196    39.234     0.150
     4.186   104.055     0.150
     0.183     7.195     0.150
     0.183     4.117     0.150
     0.183     7.555     0.150
     0.394    11.078     0.150
     0.394    18.680     0.150
     0.394    19.180     0.150
     0.394    21.500     0.150
     0.511     9.867     0.150
     0.511    18.805     0.150
     0.558    10.578     0.150
     0.394    11.055     0.150
     0.394    19.156     0.150
     0.691    13.117     0.150
     0.962    15.266     0.150
     0.962    25.734     0.150
     0.962    15.258     0.150
     0.962    25.539     0.150
     1.173    21.508     0.150
     1.563    27.656     0.150
     7.256   131.031     0.150
     7.256   131.023     0.150
     8.404   121.266     0.150
    10.537   336.031     0.150
    12.233   174.023     0.150
    69.587  5242.180     0.150
     0.404    11.250     0.150
     0.404    19.391     0.150
     0.404    20.871     0.150
     0.464     9.170     0.150
     0.464    15.191     0.150
     0.464    16.971     0.150
     0.565    10.820     0.150
     0.518    10.021     0.150
     0.518    17.111     0.150
     0.404    11.260     0.150
     0.404    19.430     0.150
     0.953    15.010     0.150
     0.953    25.141     0.150
     0.953    14.971     0.150
     0.953    25.260     0.150
     0.953    28.400     0.150
     1.175    20.641     0.150
     1.175    35.510     0.150
     0.164     8.141     0.150
     0.164    13.449     0.150
     0.164    14.129     0.150
     0.340     7.199     0.150
     0.267     5.539     0.150
     0.267     9.148     0.150
     0.164     8.141     0.150
     0.164    13.840     0.150
     0.468     9.148     0.150
     0.651    12.621     0.150
     0.707    13.262     0.150
     0.798    15.031     0.150
     0.918    16.980     0.150
     1.019    33.680     0.150
     1.019    18.430     0.150
     1.003    17.910     0.150
     1.003    30.430     0.150
     1.273    20.879     0.150
     1.273    35.172     0.150
     1.273    20.719     0.150
     1.273    35.500     0.150
     1.193    22.551     0.150
     1.759    31.219     0.150
     2.074    37.512     0.150
     0.062     6.345     0.150
     0.062    10.985     0.150
     0.062    11.275     0.150
     0.339     6.865     0.150
     0.339     6.845     0.150
     0.062     4.655     0.150
     0.062    10.875     0.150
     0.366     7.475     0.150
     0.366    12.485     0.150
     0.905    15.985     0.150
     0.905    27.045     0.150
     0.951    19.315     0.150
     0.955    17.815     0.150
     1.011    17.375     0.150
     1.310    21.635     0.150
     1.310    36.775     0.150
     1.044    19.795     0.150
     1.285    23.115     0.150
     1.285    39.565     0.150
     1.677    29.585     0.150
     0.886    54.605     0.150
     1.809    31.215     0.150
     1.928    32.975     0.150
     1.971    31.195     0.150
     6.984   217.805     0.150
     0.186     7.938     0.150
     0.186     4.148     0.150
     0.397    10.988     0.150
     0.397    18.648     0.150
     0.397    19.617     0.150
     0.397    20.008     0.150
     0.470     9.316     0.150
     0.512    18.656     0.150
     0.512     9.770     0.150
     0.549    10.379     0.150
     0.562    20.656     0.150
     0.562    10.586     0.150
     0.562    18.008     0.150
     0.397    10.977     0.150
     0.397    18.707     0.150
     0.959    15.258     0.150
     0.959    25.789     0.150
     0.959    30.789     0.150
     0.959    30.797     0.150
     0.959    15.246     0.150
     0.959    25.770     0.150
     0.852    16.449     0.150
     0.971    17.797     0.150
     0.971    30.367     0.150
     0.983    17.938     0.150
     0.983    31.188     0.150
     1.169    20.477     0.150
     1.169    35.129     0.150
     1.169    37.770     0.150
     1.209    22.227     0.150
     1.298    23.387     0.150
     1.482    48.219     0.150
     1.564    28.207     0.150
     1.588    56.176     0.150
     7.257   234.473     0.150
     7.866   114.906     0.150
     9.230   295.398     0.150
    16.783   241.742     0.150
     0.191     4.098     0.150
     0.191     7.027     0.150
     0.392    11.008     0.150
     0.392    18.695     0.150
     0.392    19.297     0.150
     0.504     9.777     0.150
     0.504    16.574     0.150
     0.544    10.336     0.150
     0.544    17.695     0.150
     0.392    11.008     0.150
     0.392    18.555     0.150
     0.565    10.617     0.150
     0.682    12.926     0.150
     0.964    15.277     0.150
     0.964    25.715     0.150
     0.964    15.277     0.150
     0.964    25.914     0.150
     0.964    27.887     0.150
     0.844    16.445     0.150
     0.968    17.816     0.150
     0.968    31.137     0.150
     0.981    17.906     0.150
     1.674    30.227     0.150
     2.669    45.145     0.150
     8.781   128.008     0.150
     0.186     4.043     0.150
     0.399    10.984     0.150
     0.399    18.562     0.150
     0.399    19.863     0.150
     0.514     9.773     0.150
     0.550    10.234     0.150
     0.550    17.562     0.150
     0.562    10.574     0.150
     0.399    11.004     0.150
     0.399    18.465     0.150
     0.691    12.855     0.150
     0.958    15.164     0.150
     0.958    25.742     0.150
     0.958    15.195     0.150
     0.958    26.004     0.150
     0.984    18.125     0.150
     1.292    23.973     0.150
     1.566    26.824     0.150
     1.566    48.875     0.150
     1.740    31.863     0.150
     0.156     8.452     0.150
     0.156    14.042     0.150
     0.156    14.651     0.150
     0.275     6.151     0.150
     0.275     6.162     0.150
     0.275    10.832     0.150
     0.264     5.492     0.150
     0.264     9.231     0.150
     0.354     7.182     0.150
     0.156     8.441     0.150
     0.156    13.852     0.150
     0.456     9.322     0.150
     0.650    12.452     0.150
     0.662    12.562     0.150
     0.792    27.651     0.150
     0.921    16.901     0.150
     0.921    29.462     0.150
     0.921    34.032     0.150
     0.998    17.901     0.150
     0.998    30.042     0.150
     0.998    31.332     0.150
     1.096    34.622     0.150
     1.097    19.441     0.150
     1.104    20.032     0.150
     1.266    19.672     0.150
     1.266    19.271     0.150
     1.266    35.002     0.150
     1.266    36.441     0.150
     1.139    21.682     0.150
     1.139    36.742     0.150
     1.227    21.802     0.150
     1.336    41.682     0.150
     1.356    23.582     0.150
     1.374    25.182     0.150
     1.374    43.422     0.150
     9.641    94.842     0.150
     8.904   129.682     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     0.224     5.411     0.150
     0.466     8.931     0.150
     0.471     9.731     0.150
     0.710    13.121     0.150
     0.784    14.801     0.150
     0.916    17.091     0.150
     0.943    17.541     0.150
     0.953    17.951     0.150
     1.212    21.812     0.150
     1.546    26.041     0.150
     1.700    28.911     0.150
     1.700    29.312     0.150
     1.917    31.731     0.150
     2.049    34.231     0.150
     2.291    36.911     0.150
     2.291    37.812     0.150
     2.468    40.591     0.150
     2.528    39.091     0.150
     2.694    43.771     0.150
     2.730    49.501     0.150
     2.770    44.781     0.150
     2.807    44.951     0.150
     3.165    50.731     0.150
     3.571    55.911     0.150
     3.800    71.751     0.150
     3.941    61.352     0.150
     4.021    61.871     0.150
     4.021   107.781     0.150
     4.132    64.431     0.150
     4.192    75.602     0.150
     4.220    63.911     0.150
     4.220    64.711     0.150
     4.326    78.571     0.150
     4.350    66.911     0.150
     4.384    68.251     0.150
     4.402    82.971     0.150
     4.414    67.711     0.150
     4.448    81.841     0.150
     4.749    71.562     0.150
     4.860    73.931     0.150
     5.159    77.771     0.150
     5.269    79.451     0.150
     5.299    79.911     0.150
     5.395    78.911     0.150
     5.395    79.711     0.150
     5.433    82.251     0.150
     5.442    81.631     0.150
     5.608    83.841     0.150
     5.644    84.381     0.150
     5.675    85.321     0.150
     5.773    86.381     0.150
     5.806    86.361     0.150
     5.828    87.731     0.150
     5.994   104.591     0.150
     6.290    91.911     0.150
     6.290    92.211     0.150
     6.299    96.201     0.150
     6.299   196.901     0.150
     6.324    95.861     0.150
     6.324   195.631     0.150
     6.364    95.761     0.150
     6.427    96.911     0.150
     6.427    97.211     0.150
     6.400    95.911     0.150
     6.400    96.411     0.150
     6.484    96.661     0.150
     6.651    97.142     0.150
     6.651    97.711     0.150
     6.667    96.911     0.150
     6.667    97.812     0.150
     6.714    99.751     0.150
     6.796   101.562     0.150
     6.948   101.911     0.150
     7.037   102.911     0.150
     7.037   103.111     0.150
     7.133   103.911     0.150
     7.133   104.211     0.150
     7.138   104.312     0.150
     7.138   225.551     0.150
     7.164   105.911     0.150
     7.164   106.211     0.150
     7.211   105.321     0.150
     7.313   106.341     0.150
     7.400   108.441     0.150
     7.444   109.911     0.150
     7.444   110.211     0.150
     7.466   110.911     0.150
     7.466   111.611     0.150
     7.896   114.321     0.150
     8.503   122.991     0.150
     8.634   127.551     0.150
     8.685   125.911     0.150
     8.685   126.711     0.150
     8.785   131.161     0.150
     8.827   129.911     0.150
     8.827   130.511     0.150
     8.824   131.271     0.150
     8.914   129.911     0.150
     8.914   130.312     0.150
     9.113   134.701     0.150
     9.113   288.871     0.150
     9.142   135.062     0.150
     9.142   290.511     0.150
     9.482   138.931     0.150
    10.347   150.911     0.150
    10.347   151.711     0.150
    10.603   155.591     0.150
    10.621   156.421     0.150
    11.012   157.501     0.150
    11.783   170.911     0.150
    11.783   171.611     0.150
    11.905   173.911     0.150
    11.905   174.111     0.150
    13.731   200.651     0.150
    13.940   202.871     0.150
    14.183   206.051     0.150
    14.197   204.171     0.150
    14.973   215.421     0.150
    15.160   216.951     0.150
    15.503   222.701     0.150
    15.589   220.521     0.150
    15.589   221.511     0.150
    15.568   219.951     0.150
    15.568   221.011     0.150
    15.676   221.981     0.150
    15.733   225.301     0.150
    15.978   227.611     0.150
    16.110   230.051     0.150
    16.162   229.911     0.150
    16.178   230.131     0.150
    16.264   231.521     0.150
    16.495   233.801     0.150
    16.563   234.511     0.150
    16.990   241.131     0.150
    17.387   244.411     0.150
    17.639   246.721     0.150
    20.206   279.411     0.150
    21.942   295.991     0.150
    22.325   300.731     0.150
    22.797   304.911     0.150
    22.797   305.411     0.150
    23.835   315.911     0.150
    27.508   347.771     0.150
    28.363   354.911     0.150
    28.363   355.611     0.150
    29.257   364.231     0.150
    29.512   370.031     0.150
    33.942   404.911     0.150
    33.942   405.711     0.150
    34.246   411.411     0.150
    36.568   431.081     0.150
    36.705   428.142     0.150
    37.670   436.411     0.150
    37.950   438.911     0.150
    38.456   443.201     0.150
    38.456   443.611     0.150
    40.104   455.841     0.150
    41.079   464.562     0.150
    43.550   483.911     0.150
    44.584   494.812     0.150
    44.584   605.911     0.150
    50.703   539.911     0.150
    66.532   655.911     0.150
    68.449   663.911     0.150
    71.533   687.711     0.150
    81.353   734.911     0.150
    81.353   735.211     0.150
    84.096   756.611     0.150
    84.583   759.312     0.150
    84.623   759.611     0.150
    84.658   759.611     0.150
    84.685   759.411     0.150
    84.873   760.711     0.150
    90.347   781.911     0.150
   145.790  1177.642     0.150
   145.790  1187.681     0.150
     0.267     5.664     0.150
     0.267     9.684     0.150
     0.781    14.184     0.150
     0.781    24.562     0.150
     0.835    15.354     0.150
     0.835    26.354     0.150
     0.881    16.062     0.150
     0.881    28.014     0.150
     0.880    15.902     0.150
     0.949    17.732     0.150
     0.949    29.232     0.150
     0.989    18.283     0.150
     0.989    31.764     0.150
     1.141    20.322     0.150
     1.249    21.232     0.150
     1.458    24.504     0.150
     1.496    26.094     0.150
     1.676    27.424     0.150
     1.950    32.184     0.150
     1.950    35.783     0.150
     1.950    60.684     0.150
     2.009    32.303     0.150
     2.206    35.873     0.150
     2.453    39.584     0.150
     2.686    45.713     0.150
     2.818    43.803     0.150
     2.886    44.572     0.150
     2.958    53.383     0.150
     2.961    50.783     0.150
     3.013    51.633     0.150
     3.222    56.732     0.150
     3.646    57.072     0.150
     3.787    59.633     0.150
     4.012    61.914     0.150
     4.100    64.463     0.150
     4.265    66.254     0.150
     4.440    68.963     0.150
     5.009    76.514     0.150
     6.285    94.613     0.150
     6.463    96.764     0.150
     7.318   111.373     0.150
     8.347   124.133     0.150
     8.348   122.902     0.150
     8.451   124.973     0.150
     8.553   127.934     0.150
     8.597   128.373     0.150
     8.907   132.844     0.150
     9.342   138.223     0.150
    10.647   154.783     0.150
    12.012   174.883     0.150
    17.037   242.684     0.150
    23.632   311.783     0.150
    30.748   376.184     0.150
    38.017   439.684     0.150
    38.221   439.482     0.150
    44.591   493.184     0.150
     0.733    14.715     0.150
     0.733    24.395     0.150
     0.941    18.062     0.150
     1.007    18.715     0.150
     1.007    31.863     0.150
     1.076    35.113     0.150
     1.094    20.465     0.150
     1.094    35.312     0.150
     1.102    20.695     0.150
     1.102    35.312     0.150
     1.391    25.414     0.150
     1.391    43.742     0.150
     1.417    25.426     0.150
     1.659    29.773     0.150
     1.651    27.934     0.150
     1.732    30.805     0.150
     1.985    34.434     0.150
     2.461    39.414     0.150
     2.461    45.215     0.150
     2.461    76.215     0.150
     2.523    41.562     0.150
     3.604    57.113     0.150
     4.221    67.023     0.150
     4.796    73.555     0.150
     4.796   146.984     0.150
     5.278    80.992     0.150
     5.707    87.336     0.150
     6.194    94.074     0.150
     6.259    94.902     0.150
     6.936   104.605     0.150
     7.463   110.215     0.150
     7.463   137.312     0.150
     7.463   236.613     0.150
     8.508   126.293     0.150
     8.920   132.305     0.150
     8.970   133.676     0.150
     9.206   137.555     0.150
     9.270   137.766     0.150
     9.342   139.492     0.150
     9.518   141.766     0.150
     9.543   143.043     0.150
    10.494   153.613     0.150
    11.780   173.234     0.150
    12.461   181.215     0.150
    14.538   208.594     0.150
    14.753   215.812     0.150
    15.753   225.223     0.150
    18.780   265.293     0.150
    24.024   316.312     0.150
    28.914   362.414     0.150
    31.260   382.312     0.150
    37.362   435.605     0.150
    38.728   446.715     0.150
    38.728   576.215     0.150
    41.723   471.703     0.150
   118.749  1132.613     0.150
     0.500     9.587     0.150
     0.709    13.827     0.150
     0.709    23.587     0.150
     0.825    15.487     0.150
     0.825    26.657     0.150
     0.936    17.387     0.150
     0.936    30.487     0.150
     0.991    18.177     0.150
     0.991    31.237     0.150
     1.070    19.807     0.150
     1.070    33.857     0.150
     1.084    19.957     0.150
     1.084    34.107     0.150
     1.092    20.037     0.150
     1.092    34.957     0.150
     1.157    21.357     0.150
     1.373    24.487     0.150
     1.373    42.907     0.150
     1.389    24.727     0.150
     1.619    27.207     0.150
     1.668    29.687     0.150
     1.678    27.907     0.150
     1.961    34.127     0.150
     1.986    37.127     0.150
     2.052    36.107     0.150
     2.180    42.717     0.150
     2.435    39.607     0.150
     2.435    44.407     0.150
     2.435    75.107     0.150
     2.841    45.897     0.150
     2.878    52.377     0.150
     3.028    55.067     0.150
     3.189    58.027     0.150
     3.388    61.097     0.150
     3.590    55.467     0.150
     3.580    57.937     0.150
     3.666    63.997     0.150
     3.864    59.317     0.150
     4.211    65.687     0.150
     4.213    72.997     0.150
     4.190    64.717     0.150
     4.588    85.727     0.150
     4.774    73.607     0.150
     4.861    75.087     0.150
     5.252    79.777     0.150
     5.677    87.267     0.150
     5.822    87.807     0.150
     6.162    94.397     0.150
     6.227    94.537     0.150
     6.534    99.137     0.150
     6.727   101.747     0.150
     6.907   103.487     0.150
     7.436   108.407     0.150
     7.436   236.007     0.150
     7.738   117.567     0.150
     8.486   125.707     0.150
     8.486   158.407     0.150
     8.486   274.807     0.150
     8.600   128.327     0.150
     8.841   132.337     0.150
     8.890   131.477     0.150
     8.940   133.547     0.150
     9.174   136.457     0.150
     9.241   136.887     0.150
     9.314   137.987     0.150
     9.357   140.067     0.150
     9.446   137.707     0.150
     9.489   140.947     0.150
     9.514   143.297     0.150
     9.764   146.957     0.150
    10.489   153.407     0.150
    11.392   168.107     0.150
    11.890   175.037     0.150
    12.429   181.907     0.150
    12.429   180.607     0.150
    13.781   198.287     0.150
    14.521   209.977     0.150
    14.715   213.527     0.150
    14.721   213.707     0.150
    15.754   226.557     0.150
    16.173   230.827     0.150
    16.279   231.657     0.150
    16.686   237.007     0.150
    16.843   240.287     0.150
    17.000   241.407     0.150
    18.764   262.807     0.150
    21.240   289.737     0.150
    23.994   317.007     0.150
    28.886   362.007     0.150
    29.260   365.307     0.150
    37.338   436.297     0.150
    38.507   444.607     0.150
    38.702   445.707     0.150
    41.583   471.507     0.150
    41.698   472.307     0.150
    67.197   655.507     0.150
    78.508   723.507     0.150
   118.764  1129.907     0.150
   120.454  1133.707     0.150
     0.193     4.453     0.150
     0.193     7.203     0.150
     0.618    11.953     0.150
     0.618    20.434     0.150
     0.782    15.152     0.150
     0.782    25.504     0.150
     0.758    14.574     0.150
     0.802    15.422     0.150
     0.802    26.273     0.150
     0.776    14.512     0.150
     0.803    15.422     0.150
     0.803    26.254     0.150
     0.828    15.672     0.150
     0.868    16.734     0.150
     0.868    28.754     0.150
     0.906    17.133     0.150
     0.906    29.281     0.150
     0.958    18.633     0.150
     1.017    19.254     0.150
     1.000    19.395     0.150
     1.096    20.773     0.150
     1.539    27.215     0.150
     1.761    29.922     0.150
     1.828    34.254     0.150
     1.828    57.754     0.150
     1.938    34.625     0.150
     2.268    38.414     0.150
     2.294    42.992     0.150
     2.578    44.965     0.150
     2.604    46.043     0.150
     2.987    48.852     0.150
     3.053    49.582     0.150
     3.208    59.215     0.150
     3.646    64.395     0.150
     3.808    68.453     0.150
     3.873    71.895     0.150
     3.897    73.602     0.150
     4.201    64.852     0.150
     4.264    78.602     0.150
     4.209    62.613     0.150
     4.343    81.043     0.150
     4.408    67.691     0.150
     5.300    81.352     0.150
     5.934    92.902     0.150
     6.177    93.742     0.150
     6.304    95.492     0.150
     6.294    95.703     0.150
     6.826   103.953     0.150
     6.826   217.152     0.150
     7.216   110.555     0.150
     8.320   123.953     0.150
     8.357   124.863     0.150
     8.473   126.223     0.150
     8.515   127.703     0.150
     8.616   128.664     0.150
     8.829   133.594     0.150
     9.238   137.812     0.150
    10.692   156.152     0.150
    10.692   342.254     0.150
    11.909   173.953     0.150
    14.142   207.152     0.150
    15.275   218.781     0.150
    16.074   226.133     0.150
    18.713   260.582     0.150
    30.628   377.352     0.150
    38.100   443.555     0.150
     0.783    15.926     0.150
     0.783    25.977     0.150
     0.975    19.145     0.150
     0.975    31.727     0.150
     1.050    19.957     0.150
     1.050    34.098     0.150
     1.111    36.324     0.150
     1.133    21.707     0.150
     1.133    36.805     0.150
     1.141    21.875     0.150
     1.141    36.824     0.150
     1.436    26.574     0.150
     1.645    31.617     0.150
     1.688    29.035     0.150
     2.117    38.035     0.150
     2.259    41.117     0.150
     2.771    48.875     0.150
     2.986    58.984     0.150
     3.007    56.234     0.150
     3.102    57.367     0.150
     3.526    62.355     0.150
     3.656    59.688     0.150
     3.654    61.297     0.150
     3.735    68.234     0.150
     3.898    72.785     0.150
     3.977    78.477     0.150
     4.108    76.734     0.150
     4.237    64.477     0.150
     4.845    77.316     0.150
     5.059    78.426     0.150
     5.328    82.906     0.150
     5.756    88.965     0.150
     5.885    89.746     0.150
     6.234    94.598     0.150
     6.301    96.055     0.150
     6.610   102.086     0.150
     6.802   103.105     0.150
     6.893   105.957     0.150
     6.985   106.016     0.150
     7.810   118.836     0.150
     8.519   126.125     0.150
     8.521   125.574     0.150
     8.909   133.688     0.150
     8.952   133.527     0.150
     9.250   140.637     0.150
     9.302   139.746     0.150
     9.428   141.285     0.150
     9.525   141.324     0.150
     9.545   142.797     0.150
     9.837   145.984     0.150
     9.836   147.746     0.150
    10.793   160.035     0.150
    10.874   161.086     0.150
    11.470   170.645     0.150
    11.807   172.336     0.150
    12.081   178.484     0.150
    12.501   184.227     0.150
    12.705   185.848     0.150
    13.948   203.586     0.150
    14.541   209.027     0.150
    14.794   214.586     0.150
    14.799   218.125     0.150
    14.852   214.285     0.150
    15.787   224.906     0.150
    16.027   234.516     0.150
    16.147   234.625     0.150
    16.251   233.004     0.150
    16.342   237.387     0.150
    16.733   242.816     0.150
    16.765   237.824     0.150
    16.778   242.797     0.150
    16.809   241.246     0.150
    16.921   241.625     0.150
    17.060   241.656     0.150
    18.781   262.914     0.150
    22.216   300.297     0.150
    24.058   317.625     0.150
    31.308   383.824     0.150
    31.308   556.527     0.150
    38.778   448.426     0.150
    41.773   473.926     0.150
    82.579   746.125     0.150
    85.973   762.566     0.150
   118.753  1130.727     0.150
   120.519  1135.227     0.150
   145.339  1180.336     0.150
   146.213  1182.625     0.150
     0.569    11.055     0.150
     0.569    18.914     0.150
     0.448     9.105     0.150
     0.448    15.496     0.150
     0.819    15.145     0.150
     0.819    26.195     0.150
     0.874    15.875     0.150
     0.874    27.773     0.150
     0.840    16.484     0.150
     0.967    17.895     0.150
     0.967    30.547     0.150
     0.967    34.074     0.150
     0.990    17.965     0.150
     0.990    30.934     0.150
     1.418    24.504     0.150
     1.573    25.984     0.150
     2.134    34.406     0.150
     3.342    51.555     0.150
     3.483    55.555     0.150
     3.719    55.695     0.150
     3.826    58.766     0.150
     4.131    61.215     0.150
     4.077    63.535     0.150
     4.449    67.996     0.150
     4.712    71.137     0.150
     5.243    79.395     0.150
     5.357    81.285     0.150
     5.856    88.566     0.150
     6.240    94.316     0.150
     6.622    99.836     0.150
     7.079   102.965     0.150
     7.130   106.234     0.150
     7.164   106.676     0.150
     7.164   228.516     0.150
     7.411   110.957     0.150
     7.430   111.535     0.150
     7.533   110.754     0.150
     7.613   111.547     0.150
     7.670   111.715     0.150
     7.941   115.367     0.150
     8.327   121.445     0.150
     8.399   124.137     0.150
     8.620   127.367     0.150
     8.687   128.676     0.150
     8.800   130.617     0.150
     8.856   130.215     0.150
     8.985   130.516     0.150
     8.978   130.457     0.150
     9.090   133.047     0.150
     9.111   134.004     0.150
     9.262   136.234     0.150
     9.455   139.727     0.150
     9.549   138.824     0.150
     9.522   139.344     0.150
     9.574   141.996     0.150
     9.961   145.117     0.150
    10.009   145.836     0.150
    10.306   149.367     0.150
    10.522   152.645     0.150
    10.485   153.516     0.150
    11.079   160.086     0.150
    11.498   167.105     0.150
    11.970   175.137     0.150
    12.122   175.375     0.150
    12.123   176.395     0.150
    12.123   386.273     0.150
    14.408   204.867     0.150
    14.466   206.914     0.150
    16.366   231.316     0.150
    16.535   235.316     0.150
    16.679   236.004     0.150
    16.679   238.395     0.150
    16.846   238.727     0.150
    18.663   258.004     0.150
    20.952   282.934     0.150
    22.518   304.145     0.150
    28.580   358.824     0.150
    30.810   377.355     0.150
    30.906   378.145     0.150
    38.192   441.457     0.150
    38.406   443.695     0.150
     0.398     8.039     0.150
     0.398    13.547     0.150
     0.398     7.957     0.150
     0.398    13.418     0.150
     0.394     7.988     0.150
     0.394    13.418     0.150
     0.464     9.098     0.150
     0.607    11.480     0.150
     0.607    19.578     0.150
     0.607    20.590     0.150
     0.809    15.609     0.150
     0.809    26.328     0.150
     0.826    15.859     0.150
     0.919    16.449     0.150
     0.944    18.617     0.150
     0.944    33.137     0.150
     1.019    18.969     0.150
     1.019    32.488     0.150
     1.664    28.520     0.150
     1.664    48.809     0.150
     1.769    30.160     0.150
     2.835    44.559     0.150
     2.835    78.008     0.150
     3.136    47.938     0.150
     3.343    53.879     0.150
     3.952    61.629     0.150
     4.564    70.047     0.150
     4.564   136.348     0.150
     4.616    68.520     0.150
     5.825    88.547     0.150
     5.825   172.688     0.150
     6.340    96.559     0.150
     6.785   101.836     0.150
     6.785   124.504     0.150
     6.785   216.445     0.150
     7.062   108.148     0.150
     7.414   114.508     0.150
     8.465   125.410     0.150
     8.591   128.297     0.150
     8.757   129.277     0.150
     8.908   131.332     0.150
     8.908   280.832     0.150
     8.908   130.918     0.150
     9.208   133.848     0.150
     9.208   234.629     0.150
    10.418   153.969     0.150
    10.478   154.598     0.150
    11.084   161.359     0.150
    12.103   177.160     0.150
    16.408   235.082     0.150
    37.989   439.707     0.150
     0.311     5.793     0.150
     0.311     6.492     0.150
     0.311    11.242     0.150
     0.312     5.793     0.150
     0.315     6.492     0.150
     0.316     6.070     0.150
     0.316    10.953     0.150
     0.316     6.660     0.150
     0.316    10.820     0.150
     0.377     7.301     0.150
     0.573    10.840     0.150
     0.573    19.242     0.150
     0.904    16.363     0.150
     1.257    22.180     0.150
     1.738    29.461     0.150
     1.738    50.422     0.150
     1.738    51.191     0.150
     1.780    54.984     0.150
     2.427    39.738     0.150
     2.427    70.719     0.150
     2.868    45.824     0.150
     3.071    47.062     0.150
     3.071    46.914     0.150
     3.071    84.430     0.150
     3.213    50.133     0.150
     3.441    54.441     0.150
     3.441    94.375     0.150
     3.443    54.367     0.150
     3.476    54.320     0.150
     3.476    97.145     0.150
     3.487    54.520     0.150
     3.487    54.742     0.150
     3.553    54.570     0.150
     3.608    55.902     0.150
     3.659    57.664     0.150
     3.883    60.984     0.150
     4.230    64.910     0.150
     4.230    65.461     0.150
     4.309    67.438     0.150
     4.313    66.566     0.150
     4.313   117.441     0.150
     4.563    70.672     0.150
     4.740    73.305     0.150
     5.105    79.070     0.150
     5.105   162.270     0.150
     5.412    80.590     0.150
     5.508    84.242     0.150
     5.861    88.023     0.150
     5.928    90.121     0.150
     6.019    91.379     0.150
     6.195    94.340     0.150
     6.297    91.805     0.150
     6.297   163.102     0.150
     6.389    97.070     0.150
     6.428    94.352     0.150
     6.509    95.512     0.150
     6.607    97.668     0.150
     6.704    99.191     0.150
     6.759   101.043     0.150
     6.785   102.742     0.150
     7.040   104.680     0.150
     7.040   104.109     0.150
     7.174   185.852     0.150
     7.453   108.613     0.150
     7.469   113.562     0.150
     7.519   112.344     0.150
     7.708   115.305     0.150
     8.169   119.301     0.150
     8.352   123.582     0.150
     8.375   125.262     0.150
     8.444   123.512     0.150
     8.479   123.590     0.150
     8.522   124.203     0.150
     8.637   126.371     0.150
     8.653   128.301     0.150
     8.793   128.141     0.150
     8.793   127.871     0.150
     8.828   131.031     0.150
     8.926   131.430     0.150
     8.936   131.672     0.150
     9.294   134.543     0.150
     9.294   240.270     0.150
     9.448   138.410     0.150
     9.481   139.941     0.150
    10.066   147.453     0.150
    10.227   151.688     0.150
    10.466   155.223     0.150
    10.551   155.723     0.150
    11.134   165.094     0.150
    11.165   160.531     0.150
    12.156   178.793     0.150
    12.289   177.902     0.150
    12.380   179.391     0.150
    12.589   181.531     0.150
    12.762   182.750     0.150
    13.814   197.672     0.150
    15.243   215.320     0.150
    15.597   221.352     0.150
    16.425   234.918     0.150
    17.302   244.352     0.150
    19.202   265.000     0.150
    23.861   314.941     0.150
    28.199   353.266     0.150
    35.344   417.672     0.150
    37.861   438.770     0.150
    83.164   746.090     0.150
    85.973   762.191     0.150
    85.973  1394.793     0.150
    97.808   816.492     0.150
   101.585   834.492     0.150
   102.668   836.191     0.150
   102.668   842.293     0.150
   112.193  1115.492     0.150
   122.884   931.391     0.150
     0.343     6.367     0.150
     0.343     7.027     0.150
     0.343    11.805     0.150
     0.277     6.648     0.150
     0.277    11.176     0.150
     0.370     7.027     0.150
     0.372     7.078     0.150
     0.372    11.785     0.150
     0.372    13.527     0.150
     0.423     8.078     0.150
     0.423    13.598     0.150
     0.423    14.836     0.150
     0.423    15.008     0.150
     0.622    11.527     0.150
     0.622    20.305     0.150
     1.006    18.418     0.150
     1.006    31.816     0.150
     0.998    19.738     0.150
     1.810    31.102     0.150
     1.810    54.852     0.150
     1.810    30.988     0.150
     1.810    52.648     0.150
     4.599    71.066     0.150
     4.599   146.547     0.150
     5.488    83.117     0.150
     5.857    89.328     0.150
     5.857   180.016     0.150
     6.078    93.488     0.150
     6.199    94.426     0.150
     6.306   198.875     0.150
     6.394    97.086     0.150
     6.821   102.652     0.150
     6.821   214.953     0.150
     7.469   113.277     0.150
     8.354   125.617     0.150
     8.520   127.027     0.150
     8.755   128.586     0.150
     8.755   127.945     0.150
     8.813   131.457     0.150
     8.817   132.328     0.150
     8.909   133.266     0.150
     9.243   135.035     0.150
     9.483   143.898     0.150
    10.472   155.727     0.150
    10.627   155.695     0.150
    11.110   160.758     0.150
    11.110   161.727     0.150
    11.110   348.227     0.150
    11.738   169.207     0.150
    12.157   178.516     0.150
    12.157   177.277     0.150
    12.388   180.918     0.150
    12.415   180.316     0.150
    12.683   187.555     0.150
    30.719   376.793     0.150
     0.686    13.371     0.150
     0.686    22.520     0.150
     0.777    14.973     0.150
     0.777    25.453     0.150
     0.814    15.973     0.150
     0.814    26.672     0.150
     0.855    16.371     0.150
     0.855    27.590     0.150
     0.970    18.688     0.150
     0.970    30.895     0.150
     1.151    20.930     0.150
     1.257    22.711     0.150
     1.257    39.574     0.150
     1.256    23.480     0.150
     1.256    39.461     0.150
     1.447    25.000     0.150
     1.447    45.902     0.150
     1.532    27.453     0.150
     1.532    46.809     0.150
     1.664    28.012     0.150
     1.664    28.316     0.150
     1.664    48.629     0.150
     1.958    32.961     0.150
     1.958    57.633     0.150
     1.958    33.113     0.150
     1.958    61.121     0.150
     2.004    57.719     0.150
     2.153    35.258     0.150
     2.153    60.570     0.150
     2.165    36.875     0.150
     2.165    65.664     0.150
     2.301    38.160     0.150
     2.301    71.109     0.150
     2.684    44.207     0.150
     2.684    83.000     0.150
     2.678    74.578     0.150
     2.701    42.305     0.150
     2.701    74.301     0.150
     2.909    89.676     0.150
     3.049    47.926     0.150
     3.049    83.246     0.150
     3.075    50.270     0.150
     3.075    92.000     0.150
     3.327    51.371     0.150
     3.327    90.363     0.150
     4.673    71.703     0.150
     4.995    76.863     0.150
     5.698    85.773     0.150
     0.256     6.277     0.150
     0.256     9.777     0.150
     0.375     7.469     0.150
     0.375    12.719     0.150
     0.428     8.789     0.150
     0.428    14.547     0.150
     0.467     9.129     0.150
     0.467    15.500     0.150
     0.467    16.566     0.150
     0.681    12.949     0.150
     0.681    22.289     0.150
     1.715    29.129     0.150
     1.715    49.789     0.150
     1.852    31.688     0.150
     1.852    57.363     0.150
     1.852    31.469     0.150
     1.852    55.770     0.150
     2.913    46.027     0.150
     2.913    86.680     0.150
     2.930    46.090     0.150
     2.930    81.109     0.150
     3.189    47.430     0.150
     3.419    54.977     0.150
     3.550    55.078     0.150
     3.562    55.648     0.150
     3.562   110.109     0.150
     4.329    66.629     0.150
     4.611    68.840     0.150
     5.167    79.477     0.150
     5.167   159.988     0.150
     5.479    82.898     0.150
     6.216    94.477     0.150
     6.349    94.250     0.150
     6.621    94.500     0.150
     6.869   101.234     0.150
     7.482   114.457     0.150
     8.026   119.520     0.150
     8.094   115.898     0.150
     8.343   124.090     0.150
     8.726   129.637     0.150
     8.811   130.809     0.150
     8.838   130.059     0.150
     8.903   130.938     0.150
     8.989   133.137     0.150
     8.989   282.039     0.150
     8.989   132.199     0.150
    11.055   159.613     0.150
    12.172   178.438     0.150
    12.408   183.188     0.150
    28.285   353.613     0.150
    30.755   375.934     0.150
    86.085   759.887     0.150
    95.345   805.789     0.150
    95.345  1032.387     0.150
    95.345  1470.988     0.150
   101.675   831.789     0.150
   101.967   834.289     0.150
   101.967  1084.590     0.150
   101.967  1536.590     0.150
   102.774   837.289     0.150
   102.774   840.988     0.150
   102.774   842.988     0.150
   112.304  1116.289     0.150
     0.319     6.053     0.150
     0.319     6.303     0.150
     0.310     6.303     0.150
     0.313     6.232     0.150
     0.313    11.242     0.150
     0.555    10.633     0.150
     0.555    18.732     0.150
     0.824    15.695     0.150
     0.824    26.564     0.150
     0.910    16.793     0.150
     0.910    29.332     0.150
     0.885    16.232     0.150
     0.885    27.953     0.150
     1.074    33.752     0.150
     1.074    34.703     0.150
     1.044    19.207     0.150
     1.044    33.363     0.150
     1.170    22.113     0.150
     1.170    37.555     0.150
     1.609    27.299     0.150
     1.609    48.205     0.150
     1.727    29.658     0.150
     1.727    51.211     0.150
     1.727    50.693     0.150
     1.761    30.898     0.150
     1.761    54.455     0.150
     1.761    31.773     0.150
     1.761    53.953     0.150
     1.901    32.857     0.150
     1.901    58.418     0.150
     1.935    33.277     0.150
     1.935    59.883     0.150
     2.159    36.396     0.150
     2.159    66.936     0.150
     2.210    35.732     0.150
     2.210    63.266     0.150
     2.331    38.162     0.150
     2.331    65.945     0.150
     2.362    37.277     0.150
     2.362    65.934     0.150
     2.413    39.623     0.150
     2.461    41.580     0.150
     2.461    76.328     0.150
     2.496    41.305     0.150
     2.504    77.203     0.150
     2.606    42.363     0.150
     2.606    73.525     0.150
     2.641    44.193     0.150
     2.641    79.707     0.150
     2.790    45.312     0.150
     2.805    44.902     0.150
     2.805    84.502     0.150
     2.968    46.139     0.150
     2.968    81.068     0.150
     2.971    49.117     0.150
     2.975    47.881     0.150
     3.029    47.812     0.150
     3.029    83.814     0.150
     3.044    48.953     0.150
     3.059    47.922     0.150
     3.059    83.318     0.150
     3.059    47.264     0.150
     3.059    84.803     0.150
     3.207    50.764     0.150
     3.237    88.471     0.150
     3.339    53.957     0.150
     3.339   100.615     0.150
     3.424    54.697     0.150
     3.424    92.963     0.150
     3.424    54.143     0.150
     3.424    94.344     0.150
     3.430    54.703     0.150
     3.466    54.426     0.150
     3.468    55.760     0.150
     3.468    56.174     0.150
     3.551    54.621     0.150
     3.590    58.076     0.150
     3.642    58.670     0.150
     3.779    58.688     0.150
     3.779   102.076     0.150
     3.799    61.041     0.150
     3.816    59.660     0.150
     3.872    60.441     0.150
     3.892    60.852     0.150
     3.940    60.689     0.150
     3.959    60.139     0.150
     4.039    61.986     0.150
     4.043    62.334     0.150
     4.050    63.635     0.150
     4.119    61.867     0.150
     4.212    65.186     0.150
     4.212    65.992     0.150
     4.296    67.232     0.150
     4.303    66.568     0.150
     4.312    67.389     0.150
     4.372    66.514     0.150
     4.372   116.412     0.150
     4.432    69.062     0.150
     4.533    68.959     0.150
     4.533   120.850     0.150
     4.557    71.023     0.150
     4.606    72.139     0.150
     4.617    71.930     0.150
     4.624    74.584     0.150
     4.631    72.041     0.150
     4.703    70.273     0.150
     4.729    73.791     0.150
     4.767    70.969     0.150
     4.797    74.443     0.150
     4.813    73.834     0.150
     4.949    74.613     0.150
     4.947    76.955     0.150
     5.037    78.812     0.150
     5.071    78.412     0.150
     5.126    77.488     0.150
     5.132    79.316     0.150
     5.208    81.646     0.150
     5.235    79.691     0.150
     5.239    81.309     0.150
     5.239    80.830     0.150
     5.318    80.062     0.150
     5.420    80.639     0.150
     5.450    84.293     0.150
     5.497    84.525     0.150
     5.497    84.113     0.150
     5.522    85.004     0.150
     5.614    83.842     0.150
     5.646    86.893     0.150
     5.671    86.197     0.150
     5.798    90.643     0.150
     5.837    89.348     0.150
     5.867    90.686     0.150
     5.931    90.465     0.150
     5.955    89.703     0.150
     5.987    89.014     0.150
     5.993    88.500     0.150
     6.005    89.227     0.150
     6.063    93.506     0.150
     6.086    93.217     0.150
     6.109    91.719     0.150
     6.179    94.373     0.150
     6.286    94.295     0.150
     6.378    96.355     0.150
     6.373    97.174     0.150
     6.416    96.342     0.150
     6.423    99.490     0.150
     6.433    98.561     0.150
     6.473    98.539     0.150
     6.535    96.080     0.150
     6.510    97.320     0.150
     6.611    98.312     0.150
     6.598   100.893     0.150
     6.633    97.818     0.150
     6.610   101.051     0.150
     6.627    99.605     0.150
     6.649    99.137     0.150
     6.653   102.246     0.150
     6.766   104.113     0.150
     6.766   214.188     0.150
     6.852   104.268     0.150
     6.973   103.770     0.150
     6.959   106.564     0.150
     7.022   105.094     0.150
     7.068   105.832     0.150
     7.245   106.801     0.150
     7.249   106.348     0.150
     7.287   108.453     0.150
     7.332   110.992     0.150
     7.328   110.715     0.150
     7.364   110.281     0.150
     7.453   114.322     0.150
     7.477   112.703     0.150
     7.535   114.361     0.150
     7.536   113.498     0.150
     7.563   112.508     0.150
     7.594   112.828     0.150
     7.614   113.867     0.150
     7.690   116.184     0.150
     7.699   116.738     0.150
     7.754   117.783     0.150
     7.819   114.529     0.150
     7.800   117.127     0.150
     7.798   118.057     0.150
     7.812   118.014     0.150
     7.871   117.605     0.150
     7.927   118.027     0.150
     8.005   116.650     0.150
     7.991   119.531     0.150
     8.093   118.912     0.150
     8.121   119.121     0.150
     8.157   121.730     0.150
     8.214   122.166     0.150
     8.224   121.613     0.150
     8.321   124.721     0.150
     8.365   124.904     0.150
     8.367   125.344     0.150
     8.440   123.684     0.150
     8.440   270.982     0.150
     8.475   124.713     0.150
     8.492   126.307     0.150
     8.509   126.311     0.150
     8.493   127.146     0.150
     8.638   129.822     0.150
     8.788   128.963     0.150
     8.788   129.113     0.150
     8.791   130.412     0.150
     8.861   129.045     0.150
     8.902   133.072     0.150
     8.914   132.453     0.150
     8.917   133.312     0.150
     9.037   133.877     0.150
     9.041   129.854     0.150
     9.094   133.510     0.150
     9.086   134.824     0.150
     9.159   133.002     0.150
     9.230   134.104     0.150
     9.295   134.943     0.150
     9.408   144.232     0.150
     9.465   143.203     0.150
     9.569   141.053     0.150
    10.540   155.072     0.150
    10.645   155.232     0.150
    11.116   166.354     0.150
    11.171   161.812     0.150
    11.745   173.213     0.150
    12.140   178.613     0.150
    12.272   180.533     0.150
    12.363   181.264     0.150
    12.572   180.924     0.150
    14.267   201.434     0.150
    14.340   212.363     0.150
    15.583   221.783     0.150
    16.723   238.463     0.150
    19.200   266.902     0.150
    21.465   292.514     0.150
    69.675  5225.182     0.150
    69.679  5225.152     0.150
     0.302     6.676     0.150
     0.302    10.976     0.150
     0.274     6.025     0.150
     0.274    10.205     0.150
     0.528    10.306     0.150
     0.646    12.346     0.150
     0.646    20.995     0.150
     0.724    13.465     0.150
     0.724    23.405     0.150
     0.730    13.945     0.150
     0.730    23.485     0.150
     0.730    24.775     0.150
     0.808    15.255     0.150
     0.808    26.056     0.150
     0.897    16.396     0.150
     0.897    28.415     0.150
     0.975    18.766     0.150
     1.034    19.286     0.150
     1.034    32.220     0.150
     1.315    23.938     0.150
     1.315    40.543     0.150
     1.316    23.938     0.150
     1.316    40.543     0.150
     1.323    23.586     0.150
     1.578    27.440     0.150
     1.723    28.945     0.150
     1.723    51.355     0.150
     1.723    29.134     0.150
     2.020    33.896     0.150
     2.020    37.045     0.150
     2.020    62.445     0.150
     2.020    62.556     0.150
     2.020    34.021     0.150
     2.020    62.161     0.150
     2.194    35.719     0.150
     2.194    61.329     0.150
     2.218    37.478     0.150
     2.218    67.036     0.150
     2.367    38.974     0.150
     2.558    40.794     0.150
     2.558    71.903     0.150
     2.558    40.794     0.150
     2.558    71.903     0.150
     2.713    42.215     0.150
     2.718    42.755     0.150
     2.744    83.593     0.150
     2.962    88.922     0.150
     3.093    48.832     0.150
     3.124    49.886     0.150
     3.124    93.995     0.150
     3.143    49.405     0.150
     3.143    94.615     0.150
     3.207    55.776     0.150
     3.729    59.806     0.150
     3.729   115.926     0.150
     3.765    58.755     0.150
     3.765   102.346     0.150
     3.765   101.585     0.150
     4.467    66.646     0.150
     4.530    70.436     0.150
     4.530   139.535     0.150
     4.913    75.755     0.150
     6.290    95.535     0.150
     6.492    97.075     0.150
     7.049   105.476     0.150
     7.049   131.295     0.150
    10.866   157.995     0.150
    38.264   441.596     0.150
     0.279     5.578     0.150
     0.279     9.289     0.150
     0.281     5.602     0.150
     0.281     9.273     0.150
     0.545    10.648     0.150
     0.584    11.250     0.150
     0.584    20.062     0.150
     0.695    14.070     0.150
     0.695    23.930     0.150
     0.896    17.039     0.150
     0.896    29.281     0.150
     1.031    19.273     0.150
     1.031    33.672     0.150
     1.173    21.852     0.150
     1.188    22.297     0.150
     1.188    39.109     0.150
     1.346    24.812     0.150
     1.346    43.039     0.150
     1.429    26.383     0.150
     1.429    45.188     0.150
     1.460    27.617     0.150
     1.561    27.750     0.150
     1.627    30.344     0.150
     1.641    29.227     0.150
     1.647    29.406     0.150
     1.666    28.867     0.150
     1.666    53.898     0.150
     1.666    30.547     0.150
     1.696    31.938     0.150
     1.738    31.203     0.150
     1.738    54.273     0.150
     1.859    33.547     0.150
     1.899    32.102     0.150
     1.899    56.523     0.150
     1.902    35.430     0.150
     2.027    35.273     0.150
     2.027    61.477     0.150
     2.027    35.570     0.150
     2.036    37.352     0.150
     2.068    37.781     0.150
     2.088    37.320     0.150
     2.088   941.531     0.150
     2.117    36.328     0.150
     2.180    38.141     0.150
     2.353    41.172     0.150
     2.375    39.320     0.150
     2.399    41.242     0.150
     2.409    41.961     0.150
     2.426    39.812     0.150
     2.426    75.531     0.150
     2.426    42.008     0.150
     2.426    72.281     0.150
     2.459    42.789     0.150
     2.511    40.242     0.150
     2.608    43.422     0.150
     2.630    45.422     0.150
     2.641    42.891     0.150
     2.659    80.289     0.150
     2.681    46.109     0.150
     2.730    44.594     0.150
     2.730    45.797     0.150
     2.839    47.383     0.150
     3.163    57.266     0.150
     3.163    97.727     0.150
     3.357    54.188     0.150
     3.394    56.523     0.150
     3.404   102.039     0.150
     3.496    55.414     0.150
     3.571    57.406     0.150
     3.571    98.250     0.150
     3.585    56.711     0.150
     3.591    56.578     0.150
     3.591   105.680     0.150
     3.761   116.383     0.150
     4.097   123.203     0.150
     4.128   128.938     0.150
     4.128    64.812     0.150
     4.128    75.852     0.150
     4.128   116.078     0.150
     4.214    75.758     0.150
     4.266    65.281     0.150
     4.266   118.781     0.150
     4.319    67.164     0.150
     4.522    70.453     0.150
     4.522   140.117     0.150
     4.674    74.570     0.150
     4.674   144.289     0.150
     4.969    78.391     0.150
     4.969   152.047     0.150
     5.008    77.000     0.150
     5.008   156.328     0.150
     5.019    78.367     0.150
     5.068    80.312     0.150
     5.229    80.859     0.150
     5.229   144.469     0.150
     5.242    80.898     0.150
     5.273    80.938     0.150
     5.379    82.625     0.150
     5.534    84.664     0.150
     5.534   145.633     0.150
     5.678    87.711     0.150
     6.183    94.297     0.150
     6.261    94.461     0.150
     6.261    94.750     0.150
     6.535    99.539     0.150
     6.535   170.469     0.150
     6.801   101.766     0.150
     6.903   123.602     0.150
     7.054   106.367     0.150
     7.054   106.609     0.150
     7.460   236.383     0.150
     7.460   111.656     0.150
     7.460   137.523     0.150
     7.460   236.375     0.150
     7.758   118.320     0.150
     7.854   114.547     0.150
     8.366   124.648     0.150
     8.366   124.969     0.150
     8.531   124.398     0.150
     8.531   271.852     0.150
     8.970   133.688     0.150
     9.185   137.820     0.150
     9.189   139.508     0.150
     9.452   139.602     0.150
     9.452   138.680     0.150
     9.908   149.680     0.150
    10.534   154.547     0.150
    10.534   154.102     0.150
    10.534   340.148     0.150
    10.534   154.102     0.150
    11.785   173.719     0.150
    11.873   174.188     0.150
    12.116   179.398     0.150
    12.167   181.953     0.150
    12.301   182.938     0.150
    12.450   182.930     0.150
    12.450   181.000     0.150
    12.647   186.688     0.150
    12.745   189.102     0.150
    12.868   189.211     0.150
    12.935   185.672     0.150
    14.262   212.500     0.150
    14.733   215.750     0.150
    15.584   225.117     0.150
    15.723   227.000     0.150
    17.002   241.422     0.150
    17.002   242.469     0.150
    17.110   248.703     0.150
    17.288   246.297     0.150
    17.319   247.203     0.150
    17.808   252.867     0.150
    18.810   266.469     0.150
    31.234   382.773     0.150
    31.234   382.781     0.150
    38.690   445.453     0.150
    38.690   445.453     0.150
    40.078   459.953     0.150
    69.596  5233.305     0.150
    69.601  5235.008     0.150
    69.614  5234.914     0.150
    92.673   797.609     0.150
     0.285     5.871     0.150
     0.285     9.840     0.150
     0.287     5.859     0.150
     0.287    10.061     0.150
     0.558    10.600     0.150
     0.558    18.080     0.150
     0.573    11.211     0.150
     0.573    19.641     0.150
     0.692    14.010     0.150
     0.692    23.721     0.150
     0.885    17.010     0.150
     0.885    28.920     0.150
     1.020    19.330     0.150
     1.020    33.510     0.150
     1.178    21.990     0.150
     1.178    38.070     0.150
     1.178    22.121     0.150
     1.195    22.541     0.150
     1.195    37.281     0.150
     1.340    24.160     0.150
     1.340    41.391     0.150
     1.340    24.320     0.150
     1.340    42.920     0.150
     1.428    26.381     0.150
     1.428    45.102     0.150
     1.668    28.871     0.150
     1.668    54.293     0.150
     1.735    31.182     0.150
     1.735    54.076     0.150
     1.906    32.146     0.150
     1.906    56.760     0.150
     2.021    34.281     0.150
     2.021    61.234     0.150
     2.378    39.354     0.150
     2.424    39.799     0.150
     2.424    75.275     0.150
     2.424    39.920     0.150
     2.424    76.740     0.150
     2.525    40.254     0.150
     2.525    70.068     0.150
     2.525    40.381     0.150
     2.525    71.381     0.150
     2.648    43.023     0.150
     2.655    80.238     0.150
     2.731    44.572     0.150
     2.731    86.074     0.150
     2.906    46.930     0.150
     2.979    46.475     0.150
     2.979    84.283     0.150
     3.150    49.008     0.150
     3.161    51.170     0.150
     3.161    98.471     0.150
     3.279    52.143     0.150
     3.293    98.963     0.150
     3.399    58.861     0.150
     3.399   101.518     0.150
     3.499    55.527     0.150
     3.565    56.480     0.150
     3.585    56.150     0.150
     3.585   100.859     0.150
     3.588    56.822     0.150
     3.725    59.012     0.150
     3.725   113.619     0.150
     3.760   116.590     0.150
     4.026   123.891     0.150
     4.093    64.561     0.150
     4.093   122.619     0.150
     4.127    64.109     0.150
     4.127   128.684     0.150
     4.127    64.480     0.150
     4.154    65.086     0.150
     4.207   128.268     0.150
     4.207    64.281     0.150
     4.279    81.109     0.150
     4.520    69.484     0.150
     4.520   139.268     0.150
     4.639    71.826     0.150
     4.668   143.639     0.150
     4.965    75.918     0.150
     4.965   151.984     0.150
     4.965    76.020     0.150
     5.006    77.129     0.150
     5.006   155.408     0.150
     5.232    80.590     0.150
     5.240    79.451     0.150
     5.273    80.869     0.150
     5.374    82.766     0.150
     5.374   165.516     0.150
     5.420   143.004     0.150
     5.544    84.977     0.150
     5.544   147.256     0.150
     5.544    84.770     0.150
     5.544   145.600     0.150
     5.679    87.504     0.150
     5.835    88.561     0.150
     5.877    89.730     0.150
     5.877   184.768     0.150
     6.273    95.268     0.150
     6.273    94.270     0.150
     6.541    99.051     0.150
     6.814   101.287     0.150
     6.903   102.701     0.150
     6.903   222.260     0.150
     7.056   106.062     0.150
     7.056   106.189     0.150
     7.459   112.971     0.150
     7.459   235.887     0.150
     7.746   115.301     0.150
     7.765   117.020     0.150
     7.783   116.621     0.150
     7.819   114.201     0.150
     7.848   116.590     0.150
     8.376   124.236     0.150
     8.376   124.951     0.150
     8.544   126.445     0.150
     8.874   132.090     0.150
     8.991   134.391     0.150
     9.011   134.451     0.150
     9.137   132.900     0.150
     9.195   135.670     0.150
     9.455   140.221     0.150
     9.455   296.445     0.150
     9.861   145.641     0.150
     9.910   145.781     0.150
     9.915   148.270     0.150
    10.403   151.590     0.150
    10.547   154.170     0.150
    10.574   152.600     0.150
    10.696   158.463     0.150
    10.696   155.820     0.150
    10.736   156.689     0.150
    10.995   161.145     0.150
    11.166   163.631     0.150
    11.196   165.486     0.150
    11.196   164.150     0.150
    11.275   165.463     0.150
    11.387   165.160     0.150
    11.414   166.691     0.150
    11.598   172.076     0.150
    11.628   169.828     0.150
    11.770   171.613     0.150
    11.795   173.080     0.150
    11.795   171.951     0.150
    11.839   172.234     0.150
    11.870   175.600     0.150
    12.081   176.691     0.150
    12.118   178.600     0.150
    12.304   181.566     0.150
    12.304   182.240     0.150
    12.347   181.049     0.150
    12.379   180.688     0.150
    12.384   179.898     0.150
    12.457   179.939     0.150
    12.457   181.555     0.150
    12.463   182.572     0.150
    12.555   182.932     0.150
    12.828   186.963     0.150
    12.933   188.043     0.150
    12.949   184.850     0.150
    13.044   189.490     0.150
    13.054   190.555     0.150
    13.066   190.082     0.150
    13.140   187.641     0.150
    13.163   189.744     0.150
    13.256   192.553     0.150
    13.470   195.562     0.150
    13.588   196.934     0.150
    13.609   197.629     0.150
    13.610   196.613     0.150
    13.612   197.088     0.150
    13.648   197.178     0.150
    13.648   198.160     0.150
    13.671   197.057     0.150
    13.671   197.301     0.150
    13.708   200.141     0.150
    13.841   199.674     0.150
    14.121   203.357     0.150
    14.154   205.209     0.150
    14.224   206.443     0.150
    14.263   206.664     0.150
    14.270   207.441     0.150
    14.266   200.160     0.150
    14.284   205.895     0.150
    14.301   206.545     0.150
    14.349   208.254     0.150
    14.362   208.871     0.150
    14.363   209.107     0.150
    14.429   209.018     0.150
    14.437   208.426     0.150
    14.499   209.732     0.150
    14.555   212.549     0.150
    14.612   210.619     0.150
    14.701   212.592     0.150
    14.737   212.891     0.150
    14.737   209.480     0.150
    14.779   212.432     0.150
    14.849   214.508     0.150
    14.899   214.889     0.150
    14.901   216.135     0.150
    14.920   215.873     0.150
    14.949   216.564     0.150
    14.990   216.150     0.150
    15.090   217.520     0.150
    15.130   218.332     0.150
    15.178   218.383     0.150
    15.333   221.396     0.150
    15.412   221.689     0.150
    15.455   223.188     0.150
    15.476   223.021     0.150
    15.476   221.910     0.150
    15.528   218.391     0.150
    15.588   224.779     0.150
    15.623   223.213     0.150
    15.636   225.107     0.150
    15.726   226.400     0.150
    15.792   226.004     0.150
    15.909   228.305     0.150
    15.909   228.531     0.150
    16.015   228.764     0.150
    16.031   227.150     0.150
    16.054   229.865     0.150
    16.224   230.520     0.150
    16.262   227.090     0.150
    16.321   232.902     0.150
    16.346   232.326     0.150
    16.484   234.674     0.150
    16.483   233.041     0.150
    16.541   234.438     0.150
    16.567   235.781     0.150
    17.003   241.795     0.150
    17.003   239.121     0.150
    17.097   240.463     0.150
    17.123   239.160     0.150
    17.121   243.324     0.150
    17.317   245.582     0.150
    17.324   245.824     0.150
    17.324   245.320     0.150
    17.328   246.490     0.150
    17.431   247.166     0.150
    17.449   246.080     0.150
    17.915   252.551     0.150
    18.021   252.879     0.150
    18.061   252.494     0.150
    18.069   252.766     0.150
    18.096   257.287     0.150
    18.100   255.166     0.150
    18.347   260.174     0.150
    18.362   260.027     0.150
    18.394   258.475     0.150
    18.528   260.100     0.150
    18.961   265.816     0.150
    18.987   266.375     0.150
    19.171   267.328     0.150
    19.457   272.549     0.150
    19.899   274.307     0.150
    21.567   291.945     0.150
    21.995   297.430     0.150
    23.578   314.564     0.150
    23.617   314.051     0.150
    38.688   448.320     0.150
    65.719   646.990     0.150
    69.584  5239.209     0.150
    69.589  5233.395     0.150
    69.601  5234.355     0.150
    95.999   807.121     0.150
    95.999  1042.621     0.150
    95.999  1876.721     0.150
    98.582   822.121     0.150
   102.275   836.420     0.150
   107.725  1124.721     0.150
   107.725  1581.420     0.150
   107.725  2037.420     0.150
     0.288     5.906     0.150
     0.288     9.641     0.150
     0.288     9.859     0.150
     0.289     6.000     0.150
     0.289     9.578     0.150
     0.552    10.711     0.150
     0.552    18.109     0.150
     0.574    11.320     0.150
     0.688    14.109     0.150
     0.688    23.828     0.150
     0.886    17.070     0.150
     1.021    19.336     0.150
     1.172    22.430     0.150
     1.172    40.484     0.150
     1.172    22.086     0.150
     1.172    22.211     0.150
     1.172    38.688     0.150
     1.188    22.641     0.150
     1.188    40.594     0.150
     1.424    26.375     0.150
     1.424    45.047     0.150
     1.639    29.555     0.150
     1.639    50.695     0.150
     1.639    29.406     0.150
     1.662    28.875     0.150
     1.731    31.172     0.150
     1.731    54.023     0.150
     1.900    32.125     0.150
     1.900    56.391     0.150
     2.019    34.508     0.150
     2.019    61.406     0.150
     2.372    39.297     0.150
     2.420    44.734     0.150
     2.420    75.367     0.150
     2.420    39.625     0.150
     2.420    71.984     0.150
     2.519    40.234     0.150
     2.641    43.031     0.150
     2.652    80.438     0.150
     2.726    44.648     0.150
     2.899    46.898     0.150
     3.148    49.188     0.150
     3.156    56.859     0.150
     3.156    97.391     0.150
     3.291   100.750     0.150
     3.396    58.883     0.150
     3.396   101.852     0.150
     3.493    55.391     0.150
     3.563    55.859     0.150
     3.563   100.164     0.150
     3.583    56.758     0.150
     3.583    99.430     0.150
     3.723   114.891     0.150
     3.755   116.500     0.150
     3.813    61.180     0.150
     4.090   122.594     0.150
     4.122   128.070     0.150
     4.122    65.141     0.150
     4.274    64.586     0.150
     4.666   143.711     0.150
     4.962    76.078     0.150
     5.226    80.711     0.150
     5.236    81.586     0.150
     5.538    84.305     0.150
     5.538    84.711     0.150
     5.674    87.562     0.150
     5.674    87.148     0.150
     5.831    90.516     0.150
     6.184    94.148     0.150
     6.266    94.789     0.150
     6.266    95.000     0.150
     6.534    99.117     0.150
     6.809   101.016     0.150
     6.898   104.156     0.150
     7.050   106.391     0.150
     7.050   106.195     0.150
     7.454   112.320     0.150
     7.454   235.703     0.150
     7.758   117.938     0.150
     7.780   117.789     0.150
     7.814   117.758     0.150
     8.128   120.594     0.150
     8.370   125.664     0.150
     8.370   124.930     0.150
     8.538   123.844     0.150
     8.665   131.484     0.150
     8.783   129.578     0.150
     8.924   131.047     0.150
     8.972   134.125     0.150
     8.984   133.055     0.150
     9.004   135.109     0.150
     9.188   135.906     0.150
     9.449   137.898     0.150
    10.544   154.242     0.150
    10.689   154.945     0.150
    10.729   157.570     0.150
    10.816   159.141     0.150
    11.382   166.008     0.150
    11.788   171.109     0.150
    12.450   182.617     0.150
    13.863   199.641     0.150
    14.260   202.016     0.150
    15.582   225.500     0.150
    15.720   225.164     0.150
    16.025   228.047     0.150
    16.477   231.945     0.150
    16.998   239.359     0.150
     0.573    11.035     0.150
     0.573    19.955     0.150
     0.698    13.766     0.150
     0.698    24.676     0.150
     0.884    16.836     0.150
     0.884    29.375     0.150
     1.019    19.125     0.150
     1.019    33.055     0.150
     1.186    22.686     0.150
     1.186    21.635     0.150
     1.186    21.875     0.150
     1.186    39.305     0.150
     1.203    23.115     0.150
     1.343    43.645     0.150
     1.434    26.412     0.150
     1.434    45.986     0.150
     1.434    26.715     0.150
     1.486    27.305     0.150
     1.543    28.064     0.150
     1.646    30.266     0.150
     1.646    29.416     0.150
     1.740    31.072     0.150
     1.740    54.789     0.150
     1.820    32.605     0.150
     1.915    32.066     0.150
     2.024    35.127     0.150
     2.024    61.928     0.150
     2.386    39.246     0.150
     2.430    40.617     0.150
     2.430    76.492     0.150
     2.430    45.195     0.150
     2.656    43.637     0.150
     2.659    44.525     0.150
     2.738    44.607     0.150
     2.913    47.551     0.150
     3.166    51.896     0.150
     3.166    98.734     0.150
     3.296   101.809     0.150
     3.403    54.955     0.150
     3.403   103.436     0.150
     3.506    55.781     0.150
     3.569    57.525     0.150
     3.594    57.605     0.150
     3.589    57.445     0.150
     3.729    59.137     0.150
     3.827    61.836     0.150
     4.097    64.873     0.150
     4.133    65.115     0.150
     4.161    65.166     0.150
     4.672    73.074     0.150
     4.970    76.889     0.150
     4.943    74.855     0.150
     4.943   134.416     0.150
     5.012    77.451     0.150
     5.014    78.131     0.150
     5.240    80.945     0.150
     5.246    80.904     0.150
     5.378    82.945     0.150
     5.423    83.404     0.150
     5.553    85.365     0.150
     5.553    85.676     0.150
     5.686    88.164     0.150
     6.280    94.984     0.150
     6.280    95.576     0.150
     6.549    99.615     0.150
     6.800   105.154     0.150
     6.820   101.797     0.150
     6.820   101.975     0.150
     7.063   106.965     0.150
     7.063   107.225     0.150
     7.464   113.115     0.150
     7.464   237.281     0.150
     7.773   120.055     0.150
     7.787   117.496     0.150
     7.826   116.725     0.150
     8.385   125.355     0.150
     8.385   125.535     0.150
     8.551   127.490     0.150
     8.551   272.791     0.150
     8.551   126.535     0.150
     8.798   133.766     0.150
     8.794   129.076     0.150
     8.882   131.766     0.150
     8.999   134.955     0.150
     9.019   135.545     0.150
     9.145   138.285     0.150
     9.203   140.766     0.150
     9.229   138.326     0.150
     9.437   143.984     0.150
     9.923   150.975     0.150
    10.551   154.516     0.150
    10.551   334.541     0.150
    10.615   158.154     0.150
    10.704   160.336     0.150
    10.743   159.436     0.150
    10.831   161.266     0.150
    11.202   166.980     0.150
    11.202   166.076     0.150
    11.280   164.723     0.150
    11.420   167.408     0.150
    11.603   172.744     0.150
    11.640   173.414     0.150
    11.776   173.561     0.150
    11.803   173.562     0.150
    11.803   176.035     0.150
    11.802   173.625     0.150
    11.843   173.279     0.150
    11.874   176.244     0.150
    12.087   177.721     0.150
    12.125   180.035     0.150
    12.170   181.984     0.150
    12.245   181.057     0.150
    12.271   182.416     0.150
    12.272   180.752     0.150
    12.272   181.666     0.150
    12.312   182.588     0.150
    12.312   183.314     0.150
    12.383   183.727     0.150
    12.465   183.785     0.150
    12.722   189.025     0.150
    12.759   188.195     0.150
    12.782   189.820     0.150
    12.835   187.213     0.150
    12.938   188.559     0.150
    13.049   190.354     0.150
    13.058   191.158     0.150
    13.148   194.176     0.150
    13.262   193.467     0.150
    13.274   193.811     0.150
    13.497   196.504     0.150
    13.497   195.215     0.150
    13.592   198.596     0.150
    13.594   196.998     0.150
    13.617   198.344     0.150
    13.613   199.428     0.150
    13.652   198.230     0.150
    13.652   196.654     0.150
    13.676   198.195     0.150
    13.676   197.365     0.150
    13.790   202.775     0.150
    13.814   203.668     0.150
    13.847   200.299     0.150
    13.943   203.197     0.150
    13.943   202.244     0.150
    14.127   204.250     0.150
    14.234   209.965     0.150
    14.228   208.189     0.150
    14.268   206.857     0.150
    14.276   208.711     0.150
    14.290   206.189     0.150
    14.306   209.271     0.150
    14.367   209.973     0.150
    14.442   208.686     0.150
    14.432   210.014     0.150
    14.562   210.977     0.150
    14.633   214.309     0.150
    14.618   211.709     0.150
    14.648   214.225     0.150
    14.709   214.184     0.150
    14.709   218.035     0.150
    14.745   215.484     0.150
    14.740   213.059     0.150
    14.785   212.930     0.150
    14.853   214.674     0.150
    14.908   216.447     0.150
    14.925   218.305     0.150
    14.995   216.082     0.150
    15.134   219.584     0.150
    15.331   220.025     0.150
    15.340   221.139     0.150
    15.483   222.316     0.150
    15.535   223.131     0.150
    15.595   225.516     0.150
    15.595   225.785     0.150
    15.567   224.625     0.150
    15.734   227.186     0.150
    15.768   231.855     0.150
    15.798   225.805     0.150
    16.038   228.865     0.150
    16.170   235.875     0.150
    16.197   231.006     0.150
    16.392   231.658     0.150
    16.431   239.516     0.150
    16.575   237.436     0.150
    16.624   239.195     0.150
    17.010   243.340     0.150
    17.010   242.119     0.150
    17.010   240.965     0.150
    17.037   241.295     0.150
    17.295   246.885     0.150
    17.332   247.252     0.150
    17.409   250.416     0.150
    17.700   253.150     0.150
    18.029   256.398     0.150
    18.102   257.123     0.150
    18.171   257.693     0.150
    18.338   260.166     0.150
    18.402   261.457     0.150
    18.583   263.961     0.150
    18.658   264.557     0.150
    18.745   265.590     0.150
    18.829   263.984     0.150
    19.383   272.209     0.150
    19.519   271.812     0.150
    19.523   270.660     0.150
    19.523   273.766     0.150
    20.729   285.562     0.150
    20.927   286.797     0.150
    21.124   289.928     0.150
    21.447   290.488     0.150
    21.575   292.605     0.150
    21.631   294.076     0.150
    22.003   300.965     0.150
    22.807   306.215     0.150
    23.578   312.959     0.150
    24.040   318.189     0.150
    26.898   343.166     0.150
    28.883   362.516     0.150
    38.509   445.391     0.150
    38.693   447.965     0.150
    69.586  5233.494     0.150
    70.310  5276.891     0.150
     0.282     5.875     0.150
     0.282     9.523     0.150
     0.282     9.684     0.150
     0.283     5.684     0.150
     0.283     9.477     0.150
     0.283     5.895     0.150
     0.283     9.855     0.150
     0.283    10.477     0.150
     0.553    10.707     0.150
     0.553    18.246     0.150
     0.578    11.336     0.150
     0.578    19.707     0.150
     0.694    14.105     0.150
     0.694    23.965     0.150
     0.890    16.754     0.150
     0.890    29.387     0.150
     1.025    18.984     0.150
     1.025    33.227     0.150
     1.177    22.035     0.150
     1.177    40.555     0.150
     1.343    24.395     0.150
     1.343    41.605     0.150
     1.343    43.184     0.150
     1.343    44.664     0.150
     1.430    26.293     0.150
     1.430    45.281     0.150
     1.645    29.344     0.150
     1.645    51.055     0.150
     1.645    29.457     0.150
     1.668    28.816     0.150
     1.668    53.762     0.150
     1.737    31.156     0.150
     1.737    54.281     0.150
     1.905    32.105     0.150
     2.024    34.531     0.150
     2.024    61.879     0.150
     2.378    39.285     0.150
     2.426    39.789     0.150
     2.426    75.430     0.150
     2.426    39.426     0.150
     2.646    42.809     0.150
     2.658    80.543     0.150
     2.732    44.422     0.150
     2.905    46.789     0.150
     2.983    47.070     0.150
     3.163    97.867     0.150
     3.277    52.137     0.150
     3.402   102.141     0.150
     3.499    55.379     0.150
     3.569    56.055     0.150
     3.569    98.664     0.150
     3.589    56.066     0.150
     3.589    99.957     0.150
     3.589    56.602     0.150
     3.729   114.570     0.150
     3.762   116.973     0.150
     4.096   122.891     0.150
     4.129    65.094     0.150
     4.129    65.297     0.150
     4.129    76.355     0.150
     4.129   129.715     0.150
     4.155    65.477     0.150
     4.211    65.906     0.150
     4.274    65.246     0.150
     4.522    69.762     0.150
     4.968    76.504     0.150
     5.232    80.145     0.150
     5.541    84.883     0.150
     5.541    83.977     0.150
     5.680    87.344     0.150
     6.269    94.215     0.150
     6.269    93.316     0.150
     6.539    97.266     0.150
     6.809   101.617     0.150
     7.056   106.617     0.150
     7.056   105.016     0.150
     7.763   115.996     0.150
     8.373   122.395     0.150
     8.784   128.496     0.150
     0.269     5.723     0.150
     0.269     9.180     0.150
     0.269     9.512     0.150
     0.271     5.762     0.150
     0.271     9.332     0.150
     0.271     9.660     0.150
     0.583    11.180     0.150
     0.583    19.992     0.150
     0.562    10.582     0.150
     0.562    18.133     0.150
     0.710    13.930     0.150
     0.710    24.012     0.150
     0.895    17.062     0.150
     1.030    19.070     0.150
     1.030    33.660     0.150
     1.194    21.953     0.150
     1.194    40.961     0.150
     1.194    38.781     0.150
     1.210    23.090     0.150
     1.210    22.582     0.150
     1.355    24.371     0.150
     1.355    24.473     0.150
     1.355    43.391     0.150
     1.387    24.723     0.150
     1.403    25.121     0.150
     1.446    26.492     0.150
     1.446    45.293     0.150
     1.446    26.223     0.150
     1.658    29.773     0.150
     1.658    50.191     0.150
     1.686    28.746     0.150
     1.686    53.945     0.150
     1.753    54.367     0.150
     1.832    32.152     0.150
     1.922    32.289     0.150
     1.922    31.500     0.150
     2.037    35.055     0.150
     2.037    61.477     0.150
     2.396    39.156     0.150
     2.442    45.047     0.150
     2.442    75.566     0.150
     2.442    43.410     0.150
     2.442    75.340     0.150
     2.672    80.379     0.150
     2.663    43.133     0.150
     2.749    44.945     0.150
     3.178    58.277     0.150
     3.178    97.984     0.150
     3.308    58.418     0.150
     3.308   101.145     0.150
     3.416    59.281     0.150
     3.416   102.625     0.150
     3.582    57.801     0.150
     3.601    57.281     0.150
     3.606    66.258     0.150
     3.606   114.035     0.150
     3.741   114.727     0.150
     3.777    68.988     0.150
     3.777   117.203     0.150
     3.837   104.812     0.150
     4.110   123.164     0.150
     4.145    75.602     0.150
     4.145   128.500     0.150
     4.223    64.422     0.150
     4.537   140.215     0.150
     4.660   145.242     0.150
     4.685   143.867     0.150
     5.024   156.719     0.150
     5.556    85.273     0.150
     6.282    95.000     0.150
     6.557    99.133     0.150
     6.815   100.863     0.150
     7.780   117.320     0.150
     8.388   125.910     0.150
     8.550   123.723     0.150
     8.805   131.000     0.150
     8.788   128.652     0.150
     9.024   135.113     0.150
     9.211   135.461     0.150
     9.472   138.863     0.150
     9.877   146.641     0.150
     9.931   148.840     0.150
    10.419   153.902     0.150
    10.584   152.660     0.150
    10.619   157.633     0.150
    10.839   159.133     0.150
    11.198   164.832     0.150
    11.405   166.242     0.150
    11.807   171.371     0.150
    12.322   180.273     0.150
    12.269   178.582     0.150
    12.669   184.492     0.150
    12.767   187.371     0.150
    12.965   189.621     0.150
    13.060   190.531     0.150
    13.156   191.910     0.150
    13.386   195.012     0.150
    13.503   194.531     0.150
    13.725   199.320     0.150
    13.672   197.660     0.150
    14.283   208.840     0.150
    14.582   211.480     0.150
    14.754   213.273     0.150
    15.744   226.910     0.150
    15.773   223.562     0.150
    15.796   225.820     0.150
    16.048   230.293     0.150
    16.585   236.852     0.150
    17.021   239.812     0.150
    17.044   238.793     0.150
    17.121   239.953     0.150
    18.825   260.621     0.150
     0.271     5.590     0.150
     0.271     9.590     0.150
     0.273     5.691     0.150
     0.273     9.590     0.150
     0.542    10.539     0.150
     0.542    17.973     0.150
     0.592    11.371     0.150
     0.592    20.281     0.150
     0.703    14.191     0.150
     0.703    23.840     0.150
     0.903    16.781     0.150
     0.903    29.320     0.150
     1.038    19.012     0.150
     1.038    33.582     0.150
     1.178    21.961     0.150
     1.178    37.930     0.150
     1.178    40.160     0.150
     1.193    22.352     0.150
     1.193    40.020     0.150
     1.355    24.500     0.150
     1.355    42.289     0.150
     1.355    42.762     0.150
     1.375    24.660     0.150
     1.437    26.230     0.150
     1.437    45.441     0.150
     1.437    45.551     0.150
     1.484    26.461     0.150
     1.655    29.422     0.150
     1.655    29.301     0.150
     1.655    50.840     0.150
     1.673    28.707     0.150
     1.673    54.281     0.150
     1.746    31.098     0.150
     1.746    54.344     0.150
     1.904    31.945     0.150
     1.904    60.242     0.150
     1.904    58.691     0.150
     2.035    34.383     0.150
     2.035    61.660     0.150
     2.433    39.691     0.150
     2.433    75.102     0.150
     2.433    70.242     0.150
     2.508    39.984     0.150
     2.645    42.789     0.150
     2.667    43.578     0.150
     2.737    44.547     0.150
     2.907    46.832     0.150
     2.996    48.180     0.150
     3.171    51.059     0.150
     3.171    98.230     0.150
     3.276    51.961     0.150
     3.308   100.883     0.150
     3.412    54.027     0.150
     3.412   103.898     0.150
     3.503    55.371     0.150
     3.579    56.152     0.150
     3.579    98.730     0.150
     3.595    56.742     0.150
     3.599    56.223     0.150
     3.739   114.359     0.150
     3.769   117.406     0.150
     3.822    60.781     0.150
     3.822   104.602     0.150
     3.834    59.262     0.150
     3.834   106.102     0.150
     3.834   123.121     0.150
     4.041   123.895     0.150
     4.105    63.750     0.150
     4.105   123.402     0.150
     4.135    64.527     0.150
     4.135   129.836     0.150
     4.135    64.652     0.150
     4.135   114.172     0.150
     4.159    64.633     0.150
     4.222   113.973     0.150
     4.222    66.250     0.150
     4.262    64.461     0.150
     4.262   114.160     0.150
     4.327    67.270     0.150
     4.530    69.449     0.150
     4.530   140.555     0.150
     4.682   144.320     0.150
     4.642    70.410     0.150
     4.978    76.207     0.150
     4.978   134.750     0.150
     5.016    76.676     0.150
     5.016   156.520     0.150
     5.235    80.352     0.150
     5.235   168.781     0.150
     5.250    80.621     0.150
     5.250    97.730     0.150
     5.250   142.480     0.150
     5.250   170.910     0.150
     5.280   166.738     0.150
     5.387    82.762     0.150
     5.387   165.887     0.150
     5.435    83.242     0.150
     5.536    84.156     0.150
     5.536    84.520     0.150
     5.536   147.383     0.150
     5.536   179.199     0.150
     5.685    86.762     0.150
     5.886    89.820     0.150
     6.261    94.184     0.150
     6.539    99.152     0.150
     6.539   170.840     0.150
     6.797   100.695     0.150
     7.060   106.031     0.150
     7.060   106.383     0.150
     7.468   112.711     0.150
     7.468   237.797     0.150
     7.762   116.621     0.150
     7.795   116.430     0.150
     7.795   203.801     0.150
     7.805   116.762     0.150
     8.367   124.066     0.150
     8.367   124.551     0.150
     8.367   267.371     0.150
     8.530   124.973     0.150
     8.530   220.152     0.150
     8.786   128.730     0.150
     8.786   225.590     0.150
     8.772   128.547     0.150
     8.772   227.852     0.150
     8.869   130.930     0.150
     8.869   228.859     0.150
     8.983   133.680     0.150
     8.983   226.930     0.150
     9.004   134.660     0.150
     9.004   230.281     0.150
     9.106   137.070     0.150
     9.177   135.520     0.150
     9.136   134.441     0.150
     9.136   236.230     0.150
     9.194   137.121     0.150
     9.194   135.789     0.150
     9.194   240.672     0.150
     9.425   140.352     0.150
     9.458   139.742     0.150
     9.458   240.762     0.150
     9.861   146.051     0.150
     9.861   256.070     0.150
     9.913   148.320     0.150
    10.401   155.402     0.150
    10.401   266.832     0.150
    10.529   153.812     0.150
    10.690   158.871     0.150
    10.690   154.582     0.150
    10.736   156.742     0.150
    10.736   276.039     0.150
    10.821   159.391     0.150
    10.821   271.789     0.150
    11.179   161.473     0.150
    11.179   285.633     0.150
    11.258   164.855     0.150
    11.395   169.422     0.150
    11.398   167.355     0.150
    11.609   171.551     0.150
    11.609   169.914     0.150
    11.786   173.297     0.150
    11.821   171.812     0.150
    11.881   176.680     0.150
    12.122   178.473     0.150
    12.122   310.289     0.150
    12.174   181.582     0.150
    12.272   181.680     0.150
    12.307   181.105     0.150
    12.307   179.090     0.150
    12.361   178.699     0.150
    12.366   179.582     0.150
    12.652   185.172     0.150
    12.652   323.242     0.150
    12.750   184.641     0.150
    12.750   323.180     0.150
    12.786   188.949     0.150
    12.812   187.426     0.150
    12.915   187.562     0.150
    13.027   187.523     0.150
    13.139   193.223     0.150
    13.145   189.898     0.150
    13.369   340.590     0.150
    13.483   193.406     0.150
    13.483   193.891     0.150
    13.483   340.910     0.150
    13.572   195.488     0.150
    13.592   198.906     0.150
    13.591   197.434     0.150
    13.630   197.910     0.150
    13.654   196.645     0.150
    13.654   197.383     0.150
    13.654   346.531     0.150
    13.709   196.211     0.150
    13.709   348.562     0.150
    13.825   199.227     0.150
    14.234   209.461     0.150
    14.206   204.164     0.150
    14.267   204.582     0.150
    14.297   208.043     0.150
    14.284   204.809     0.150
    14.304   208.000     0.150
    14.331   208.266     0.150
    14.420   210.023     0.150
    14.595   213.078     0.150
    14.636   213.367     0.150
    14.699   215.359     0.150
    14.738   210.902     0.150
    14.902   217.648     0.150
    14.991   216.121     0.150
    15.163   219.047     0.150
    15.186   219.273     0.150
    15.308   219.961     0.150
    15.396   221.070     0.150
    15.394   222.051     0.150
    15.591   224.316     0.150
    15.591   224.910     0.150
    15.696   222.609     0.150
    15.729   226.770     0.150
    15.754   224.152     0.150
    15.922   229.816     0.150
    16.242   231.219     0.150
    16.340   233.023     0.150
    16.486   232.961     0.150
    17.009   241.500     0.150
    17.009   239.109     0.150
    17.025   240.988     0.150
    17.025   241.320     0.150
    17.065   241.504     0.150
    17.105   246.402     0.150
    18.014   252.391     0.150
    18.315   260.133     0.150
    18.380   260.562     0.150
    18.807   261.082     0.150
    20.032   279.012     0.150
    20.144   278.660     0.150
    20.715   283.047     0.150
    21.111   284.551     0.150
    21.998   299.480     0.150
    22.509   301.254     0.150
    22.894   305.258     0.150
    23.304   309.027     0.150
    23.357   309.719     0.150
    23.444   311.160     0.150
    23.959   315.297     0.150
    24.025   316.188     0.150
    24.304   318.750     0.150
    24.812   322.914     0.150
    38.510   444.285     0.150
    38.698   446.660     0.150
    39.207   450.781     0.150
    39.262   451.492     0.150
    39.573   453.570     0.150
    39.713   455.730     0.150
    96.012   808.211     0.150
    96.012  1480.711     0.150
    96.012  1487.312     0.150
     0.539    10.695     0.150
     0.539    18.586     0.150
     0.544    11.031     0.150
     0.544    18.547     0.150
     0.604    11.883     0.150
     0.604    19.875     0.150
     0.680    13.305     0.150
     0.680    22.672     0.150
     1.059    19.461     0.150
     1.059    33.891     0.150
     1.198    21.797     0.150
     1.198    38.000     0.150
     1.238    22.484     0.150
     1.238    38.000     0.150
     1.264    23.695     0.150
     1.264    39.773     0.150
     1.383    26.297     0.150
     1.386    26.156     0.150
     1.390    24.664     0.150
     1.490    27.906     0.150
     1.512    28.602     0.150
     1.529    27.500     0.150
     1.529    47.031     0.150
     1.542    27.391     0.150
     1.560    27.195     0.150
     1.560    49.156     0.150
     1.560    28.680     0.150
     1.613    28.062     0.150
     1.659    29.117     0.150
     1.728    31.172     0.150
     1.743    29.914     0.150
     1.743    52.672     0.150
     1.743    30.055     0.150
     1.805    32.430     0.150
     1.896    33.867     0.150
     1.947    32.281     0.150
     1.947    31.555     0.150
     2.066    36.281     0.150
     2.074    36.656     0.150
     2.148    37.477     0.150
     2.206    38.297     0.150
     2.224    38.547     0.150
     2.244    37.852     0.150
     2.240    38.766     0.150
     2.244    38.836     0.150
     2.281    39.367     0.150
     2.309    38.055     0.150
     2.368    40.547     0.150
     2.394    40.930     0.150
     2.407    40.289     0.150
     2.407    73.453     0.150
     2.448    41.703     0.150
     2.600    42.297     0.150
     2.600    78.734     0.150
     2.649    41.914     0.150
     2.649    73.727     0.150
     2.676    43.070     0.150
     2.705    45.250     0.150
     2.809    43.914     0.150
     2.809    78.148     0.150
     2.837    43.805     0.150
     2.857    45.930     0.150
     2.857    46.844     0.150
     2.955    90.500     0.150
     2.995    53.086     0.150
     3.135    51.367     0.150
     3.147    50.430     0.150
     3.147    94.609     0.150
     3.274    52.227     0.150
     3.307    52.156     0.150
     3.397   105.391     0.150
     3.444   106.102     0.150
     3.564    63.164     0.150
     3.564   110.414     0.150
     3.586    57.523     0.150
     3.739    68.797     0.150
     3.924    61.195     0.150
     3.924    60.711     0.150
     3.950   122.234     0.150
     3.950    62.242     0.150
     3.990    61.156     0.150
     4.033    62.820     0.150
     4.396    67.883     0.150
     4.498   138.414     0.150
     4.564    68.164     0.150
     4.718    72.812     0.150
     4.718   143.820     0.150
     4.806    73.695     0.150
     4.806   148.156     0.150
     5.039    77.547     0.150
     5.111    78.508     0.150
     5.122    78.570     0.150
     5.151    79.195     0.150
     5.544    84.625     0.150
     5.667    86.164     0.150
     5.667    85.945     0.150
     6.003    91.273     0.150
     6.300    96.180     0.150
     6.381    96.742     0.150
     6.455    96.883     0.150
     6.527    99.055     0.150
     6.949   105.195     0.150
     6.986   103.961     0.150
     7.106   104.727     0.150
     7.216   109.320     0.150
     7.261   112.023     0.150
     7.261   110.000     0.150
     7.261   230.477     0.150
     7.528   112.516     0.150
     7.829   117.211     0.150
     8.063   118.891     0.150
     8.388   123.500     0.150
     8.432   123.992     0.150
     8.517   126.539     0.150
     8.778   128.945     0.150
     8.815   131.562     0.150
     8.921   133.273     0.150
     9.069   138.656     0.150
     9.101   132.883     0.150
     9.101   133.172     0.150
     9.145   137.281     0.150
     9.164   135.984     0.150
     9.354   138.453     0.150
     9.476   139.242     0.150
     9.474   141.047     0.150
     9.817   146.211     0.150
     9.887   144.820     0.150
    10.308   152.812     0.150
    10.728   158.305     0.150
    10.748   157.086     0.150
    10.882   158.727     0.150
    10.883   158.922     0.150
    10.883   345.211     0.150
    11.030   164.914     0.150
    11.213   166.695     0.150
    11.471   169.133     0.150
    11.573   167.984     0.150
    11.623   172.391     0.150
    11.923   174.672     0.150
    11.955   173.984     0.150
    11.953   178.094     0.150
    12.098   179.273     0.150
    12.162   176.469     0.150
    12.469   182.117     0.150
    12.499   185.742     0.150
    12.527   181.922     0.150
    12.527   182.586     0.150
    12.635   185.953     0.150
    12.705   184.102     0.150
    12.706   184.930     0.150
    12.730   183.391     0.150
    12.752   183.305     0.150
    12.850   189.734     0.150
    12.854   186.406     0.150
    12.861   186.602     0.150
    12.933   188.844     0.150
    12.958   192.023     0.150
    13.001   188.492     0.150
    13.024   191.734     0.150
    13.115   189.164     0.150
    13.254   191.672     0.150
    13.342   192.750     0.150
    13.348   194.656     0.150
    13.380   194.562     0.150
    13.494   193.133     0.150
    13.537   195.867     0.150
    13.554   195.609     0.150
    13.554   196.633     0.150
    13.577   195.945     0.150
    13.643   196.234     0.150
    13.925   200.016     0.150
    13.934   201.422     0.150
    13.970   201.078     0.150
    13.970   201.711     0.150
    13.970   200.195     0.150
    13.978   201.500     0.150
    13.985   200.656     0.150
    14.117   206.297     0.150
    14.132   203.352     0.150
    14.189   206.242     0.150
    14.218   205.141     0.150
    14.396   207.328     0.150
    14.535   208.992     0.150
    14.584   209.578     0.150
    14.675   212.023     0.150
    14.687   212.055     0.150
    14.694   213.922     0.150
    14.851   211.195     0.150
    14.894   213.867     0.150
    15.076   216.828     0.150
    15.212   217.609     0.150
    15.238   217.961     0.150
    15.290   218.844     0.150
    15.399   220.586     0.150
    15.538   216.023     0.150
    15.538   229.781     0.150
    15.608   222.445     0.150
    15.704   224.711     0.150
    15.718   224.570     0.150
    15.743   224.000     0.150
    15.837   223.883     0.150
    15.834   226.773     0.150
    15.834   229.844     0.150
    15.856   225.883     0.150
    15.908   228.211     0.150
    15.968   228.430     0.150
    16.051   228.703     0.150
    16.051   228.320     0.150
    16.159   229.531     0.150
    16.161   230.734     0.150
    16.387   234.703     0.150
    16.459   232.758     0.150
    16.870   241.367     0.150
    17.048   241.273     0.150
    17.444   243.672     0.150
    17.445   242.703     0.150
    17.958   252.047     0.150
    17.972   252.438     0.150
    18.066   253.328     0.150
    18.080   253.031     0.150
    18.130   255.977     0.150
    18.193   255.336     0.150
    18.198   255.289     0.150
    18.358   256.297     0.150
    18.369   257.180     0.150
    18.538   260.547     0.150
    18.549   259.344     0.150
    18.569   259.117     0.150
    18.648   257.711     0.150
    19.103   268.195     0.150
    19.663   272.250     0.150
    20.067   278.508     0.150
    31.126   380.844     0.150
    36.849   429.734     0.150
    38.464   444.477     0.150
    95.721   805.773     0.150
    95.721  1041.070     0.150
    95.721  1478.070     0.150
    95.721  1485.570     0.150
   107.443   857.773     0.150
     0.275     5.805     0.150
     0.275     9.555     0.150
     0.275     9.336     0.150
     0.275     9.695     0.150
     0.276     5.844     0.150
     0.276     9.527     0.150
     0.564    10.816     0.150
     0.578    11.027     0.150
     0.578    19.656     0.150
     0.705    13.715     0.150
     0.705    23.715     0.150
     0.890    16.535     0.150
     1.025    18.785     0.150
     1.192    23.004     0.150
     1.192    21.996     0.150
     1.208    23.215     0.150
     1.208    38.055     0.150
     1.350    24.707     0.150
     1.350    41.996     0.150
     1.441    27.012     0.150
     1.441    45.676     0.150
     1.493    27.027     0.150
     1.653    29.594     0.150
     1.653    51.375     0.150
     1.653    29.734     0.150
     1.682    29.328     0.150
     1.682    54.535     0.150
     1.748    54.555     0.150
     1.827    32.344     0.150
     1.920    32.523     0.150
     1.920    55.445     0.150
     2.032    35.422     0.150
     2.032    61.867     0.150
     2.392    39.648     0.150
     2.437    44.242     0.150
     2.437    76.289     0.150
     2.437    40.355     0.150
     2.437    77.094     0.150
     2.437    74.996     0.150
     2.530    40.562     0.150
     2.530    70.578     0.150
     2.530    40.414     0.150
     2.661    43.195     0.150
     2.667    44.203     0.150
     2.745    45.098     0.150
     2.920    47.410     0.150
     3.158    50.730     0.150
     3.158    98.664     0.150
     3.173    50.816     0.150
     3.173    99.461     0.150
     3.292    52.062     0.150
     3.303    62.445     0.150
     3.411    54.668     0.150
     3.411   105.129     0.150
     3.512    56.043     0.150
     3.576    56.254     0.150
     3.576    63.914     0.150
     3.576   109.707     0.150
     3.596    56.117     0.150
     3.602    57.512     0.150
     3.604    57.094     0.150
     3.736   115.543     0.150
     3.773    69.805     0.150
     3.773   117.371     0.150
     4.105    64.758     0.150
     4.105   125.219     0.150
     4.140    64.871     0.150
     4.140    76.797     0.150
     4.168    66.039     0.150
     4.218    65.316     0.150
     4.218   129.758     0.150
     4.218    63.375     0.150
     4.284    65.105     0.150
     4.532    69.281     0.150
     4.532   138.828     0.150
     4.653    71.801     0.150
     4.679    73.301     0.150
     4.679   144.637     0.150
     4.977    76.617     0.150
     4.977    77.535     0.150
     5.019    77.875     0.150
     5.021    78.523     0.150
     5.246    81.547     0.150
     5.253    80.938     0.150
     5.385    83.121     0.150
     5.556    83.434     0.150
     5.556    83.906     0.150
     5.693    87.859     0.150
     5.891    90.785     0.150
     6.282    94.027     0.150
     6.554    99.938     0.150
     6.818   100.797     0.150
     6.818   100.645     0.150
     7.070   105.492     0.150
     7.070   106.805     0.150
     7.472   112.941     0.150
     7.778   115.547     0.150
     8.792   127.395     0.150
     9.023   135.375     0.150
     9.469   138.215     0.150
    10.546   154.266     0.150
    17.017   242.465     0.150
    38.700   447.566     0.150
     0.279     5.723     0.150
     0.279     9.023     0.150
     0.281     5.703     0.150
     0.281     9.535     0.150
     0.281     9.836     0.150
     0.562    10.684     0.150
     0.562    18.383     0.150
     0.562    18.605     0.150
     0.576    11.094     0.150
     0.576    19.574     0.150
     0.700    13.754     0.150
     0.700    24.094     0.150
     0.888    16.953     0.150
     1.023    19.086     0.150
     1.186    40.445     0.150
     1.186    22.176     0.150
     1.346    24.785     0.150
     1.346    42.094     0.150
     1.436    26.742     0.150
     1.436    44.793     0.150
     1.436    26.895     0.150
     1.648    29.723     0.150
     1.648    29.973     0.150
     1.676    29.672     0.150
     1.743    53.602     0.150
     1.914    32.438     0.150
     1.914    56.129     0.150
     1.914    32.586     0.150
     1.914    60.934     0.150
     2.027    34.977     0.150
     2.027    60.797     0.150
     2.432    40.246     0.150
     2.432    75.629     0.150
     2.432    44.754     0.150
     2.528    40.406     0.150
     2.528    49.094     0.150
     2.662    44.203     0.150
     2.662    81.898     0.150
     2.656    80.664     0.150
     2.739    44.707     0.150
     2.914    47.191     0.150
     2.983    84.699     0.150
     3.168    98.090     0.150
     3.406   104.324     0.150
     3.572    56.824     0.150
     3.828    76.844     0.150
     4.100   125.285     0.150
     4.135    76.715     0.150
     4.972   152.039     0.150
     5.551    83.855     0.150
     0.279     9.818     0.150
     0.279    10.219     0.150
     0.281     5.010     0.150
     0.281     9.260     0.150
     0.281     5.459     0.150
     0.281     9.459     0.150
     0.572    11.119     0.150
     0.572    18.350     0.150
     0.571    11.148     0.150
     0.571    19.539     0.150
     0.703    13.910     0.150
     0.703    23.490     0.150
     0.883    16.559     0.150
     0.883    29.240     0.150
     1.018    18.770     0.150
     1.018    33.180     0.150
     1.195    22.559     0.150
     1.195    40.879     0.150
     1.195    22.350     0.150
     1.212    24.109     0.150
     1.212    41.389     0.150
     1.346    24.959     0.150
     1.346    42.949     0.150
     1.346    24.840     0.150
     1.346    42.779     0.150
     1.441    27.117     0.150
     1.441    45.309     0.150
     1.650    29.949     0.150
     1.650    51.318     0.150
     1.682    54.699     0.150
     1.746    31.598     0.150
     1.746    54.689     0.150
     1.924    32.559     0.150
     1.924    59.422     0.150
     2.028    35.742     0.150
     2.028    61.992     0.150
     2.394    39.674     0.150
     2.436    45.223     0.150
     2.436    73.934     0.150
     2.436    40.039     0.150
     2.436    75.119     0.150
     2.538    40.654     0.150
     2.538    70.586     0.150
     2.538    40.490     0.150
     2.538    69.750     0.150
     2.665    43.893     0.150
     2.664    45.125     0.150
     2.664    79.955     0.150
     2.745    45.023     0.150
     2.922    47.088     0.150
     3.172    51.184     0.150
     3.514    55.539     0.150
     3.573    55.180     0.150
     3.592    56.568     0.150
     3.602    65.215     0.150
     4.102    63.994     0.150
     4.140    75.660     0.150
     4.214    64.318     0.150
     4.214   114.699     0.150
     4.292    64.750     0.150
     4.653    71.342     0.150
     4.975    76.680     0.150
     5.018    89.852     0.150
     5.248    78.750     0.150
     5.562    84.000     0.150
     5.562   147.479     0.150
     6.290    95.619     0.150
     6.558    98.629     0.150
     6.827   101.379     0.150
     6.827   177.109     0.150
     8.394   125.039     0.150
     9.029   136.039     0.150
     0.277     5.590     0.150
     0.277     9.281     0.150
     0.279     5.641     0.150
     0.279     9.420     0.150
     0.279    10.061     0.150
     0.556    10.631     0.150
     0.556    18.121     0.150
     0.580    11.010     0.150
     0.580    19.852     0.150
     0.700    13.670     0.150
     0.700    23.840     0.150
     1.027    19.061     0.150
     1.027    32.910     0.150
     1.183    22.090     0.150
     1.200    22.670     0.150
     1.200    38.641     0.150
     1.348    24.711     0.150
     1.348    41.461     0.150
     1.436    26.768     0.150
     1.436    45.619     0.150
     1.448    26.281     0.150
     1.486    26.910     0.150
     1.650    29.881     0.150
     1.675    29.203     0.150
     1.675    54.195     0.150
     1.743    31.740     0.150
     1.743    53.949     0.150
     1.825    32.371     0.150
     1.911    32.412     0.150
     1.911    55.393     0.150
     2.029    35.531     0.150
     2.029    62.084     0.150
     2.385    39.541     0.150
     2.432    40.309     0.150
     2.432    76.084     0.150
     2.522    40.408     0.150
     2.522    70.070     0.150
     2.652    43.203     0.150
     2.663    44.953     0.150
     2.738    44.990     0.150
     2.912    46.994     0.150
     3.168    51.494     0.150
     3.168    98.424     0.150
     3.407   103.994     0.150
     3.595    57.244     0.150
     3.733   114.797     0.150
     4.034   124.967     0.150
     4.101   125.301     0.150
     4.216   130.322     0.150
     4.974   152.309     0.150
     0.268     5.620     0.150
     0.268     9.430     0.150
     0.270     5.680     0.150
     0.270     9.480     0.150
     0.894    17.061     0.150
     0.894    28.820     0.150
     1.029    19.030     0.150
     1.029    32.620     0.150
     1.200    21.970     0.150
     1.356    24.210     0.150
     1.356    24.340     0.150
     1.356    42.930     0.150
     1.449    26.300     0.150
     1.449    46.422     0.150
     1.660    29.210     0.150
     1.660    50.780     0.150
     1.690    28.987     0.150
     1.755    31.186     0.150
     1.755    54.396     0.150
     1.834    32.130     0.150
     1.928    32.104     0.150
     1.928    31.891     0.150
     1.928    59.410     0.150
     2.038    35.389     0.150
     2.038    62.080     0.150
     2.401    39.256     0.150
     2.445    40.002     0.150
     2.445    75.677     0.150
     2.532    40.391     0.150
     2.532    39.980     0.150
     2.532    70.680     0.150
     2.674    43.647     0.150
     2.669    42.918     0.150
     2.753    44.950     0.150
     2.928    46.905     0.150
     3.164    50.983     0.150
     3.164    98.006     0.150
     3.181    57.102     0.150
     3.181    98.458     0.150
     3.300    51.004     0.150
     3.418    59.168     0.150
     3.521    55.444     0.150
     3.583    56.030     0.150
     3.583   109.891     0.150
     3.603    56.050     0.150
     3.603    68.230     0.150
     3.603    97.601     0.150
     3.603   112.330     0.150
     3.610    56.237     0.150
     4.112    64.277     0.150
     4.112   125.452     0.150
     4.148    65.290     0.150
     4.148    75.750     0.150
     4.148   130.090     0.150
     5.563    84.200     0.150
     5.563   148.050     0.150
     8.793   127.290     0.150
     9.477   137.700     0.150
     0.289     6.127     0.150
     0.289     9.387     0.150
     0.289     5.787     0.150
     0.289     9.857     0.150
     0.291     6.166     0.150
     0.291     9.938     0.150
     0.291     6.027     0.150
     0.576    10.947     0.150
     0.576    19.357     0.150
     1.190    22.348     0.150
     1.190    39.277     0.150
     1.190    39.477     0.150
     1.336    24.527     0.150
     1.336    41.336     0.150
     1.336    42.656     0.150
     1.390    25.906     0.150
     1.432    26.656     0.150
     1.432    46.621     0.150
     1.487    26.877     0.150
     1.487    27.137     0.150
     1.545    27.797     0.150
     1.545    27.576     0.150
     1.659    29.027     0.150
     1.640    29.666     0.150
     1.640    29.916     0.150
     1.640    51.287     0.150
     1.674    29.309     0.150
     1.674    30.197     0.150
     1.697    31.537     0.150
     1.736    31.711     0.150
     1.736    54.615     0.150
     1.813    32.037     0.150
     1.847    32.697     0.150
     1.871    33.256     0.150
     1.920    32.438     0.150
     1.920    56.934     0.150
     1.920    32.617     0.150
     1.920    59.477     0.150
     2.018    34.648     0.150
     2.018    62.143     0.150
     2.018    35.506     0.150
     2.029    36.967     0.150
     2.061    37.396     0.150
     2.089    36.906     0.150
     2.089    38.996     0.150
     2.128    36.006     0.150
     2.274    38.018     0.150
     2.307    40.777     0.150
     2.352    40.756     0.150
     2.387    39.650     0.150
     2.394    40.586     0.150
     2.407    40.887     0.150
     2.409    41.547     0.150
     2.433    40.977     0.150
     2.427    40.092     0.150
     2.427    75.143     0.150
     2.427    40.373     0.150
     2.427    76.268     0.150
     2.427    45.086     0.150
     2.428    41.826     0.150
     2.428    44.627     0.150
     2.458    42.377     0.150
     2.458    45.166     0.150
     2.542    40.566     0.150
     2.626    45.018     0.150
     2.661    43.361     0.150
     2.654    44.109     0.150
     2.678    45.697     0.150
     2.737    44.861     0.150
     2.846    47.018     0.150
     2.916    47.324     0.150
     2.970    47.312     0.150
     2.970    85.107     0.150
     3.143    49.373     0.150
     3.165    46.697     0.150
     3.165    59.166     0.150
     3.163    57.662     0.150
     3.163    98.922     0.150
     3.292    52.404     0.150
     3.288    58.582     0.150
     3.388    56.117     0.150
     3.506    55.510     0.150
     3.563    56.887     0.150
     3.593    57.232     0.150
     3.582    56.727     0.150
     3.722    58.943     0.150
     3.762    68.344     0.150
     3.762   116.777     0.150
     3.829    61.387     0.150
     3.862    63.207     0.150
     4.020    62.016     0.150
     4.020   124.359     0.150
     4.092    64.408     0.150
     4.131    64.586     0.150
     4.131    65.027     0.150
     4.161    65.096     0.150
     4.204    65.650     0.150
     4.204    65.938     0.150
     4.297    65.260     0.150
     4.297    65.027     0.150
     4.297   113.807     0.150
     4.303    66.367     0.150
     4.671    71.297     0.150
     4.645    72.092     0.150
     4.666    72.559     0.150
     4.950    76.537     0.150
     4.965    76.916     0.150
     4.965    77.576     0.150
     5.241    80.527     0.150
     5.243    80.537     0.150
     5.561    85.166     0.150
     6.290    94.977     0.150
     6.552    99.746     0.150
     6.761   102.336     0.150
     6.832   101.076     0.150
     6.792   105.896     0.150
     7.064   106.807     0.150
     7.462   116.066     0.150
     7.462   111.416     0.150
     7.778   117.816     0.150
     7.798   116.146     0.150
     7.838   119.217     0.150
     8.393   124.977     0.150
     8.562   125.041     0.150
     8.639   128.127     0.150
     8.688   132.387     0.150
     8.806   129.277     0.150
     8.803   281.607     0.150
     8.888   132.826     0.150
     8.946   133.787     0.150
     8.995   134.887     0.150
     9.007   134.857     0.150
     9.194   136.107     0.150
     9.124   137.227     0.150
     9.149   138.527     0.150
     9.206   139.777     0.150
     9.228   137.836     0.150
     9.443   140.916     0.150
     9.463   137.992     0.150
     9.463   140.406     0.150
     9.765   145.586     0.150
     9.748   145.066     0.150
     9.872   148.047     0.150
    10.169   147.277     0.150
    10.562   154.467     0.150
    10.562   154.342     0.150
    10.623   157.996     0.150
    10.711   159.477     0.150
    10.746   158.316     0.150
    11.213   167.127     0.150
    11.241   168.057     0.150
    11.241   373.387     0.150
    11.391   169.826     0.150
    11.812   174.627     0.150
    11.869   174.496     0.150
    12.042   178.027     0.150
    12.125   179.188     0.150
    12.167   181.938     0.150
    12.283   181.027     0.150
    12.269   181.617     0.150
    12.313   182.727     0.150
    12.470   181.906     0.150
    12.470   182.336     0.150
    12.470   180.566     0.150
    12.665   186.607     0.150
    12.783   190.836     0.150
    12.961   189.688     0.150
    13.055   191.277     0.150
    13.382   196.246     0.150
    13.504   195.928     0.150
    13.664   198.057     0.150
    13.688   198.188     0.150
    13.881   204.377     0.150
    14.276   209.316     0.150
    14.473   216.037     0.150
    14.597   211.906     0.150
    14.651   208.416     0.150
    14.713   213.637     0.150
    14.732   215.287     0.150
    15.394   225.137     0.150
    15.494   224.627     0.150
    15.545   227.107     0.150
    15.597   225.336     0.150
    15.605   227.166     0.150
    15.775   230.707     0.150
    15.810   225.666     0.150
    15.927   229.887     0.150
    16.167   236.146     0.150
    16.271   235.557     0.150
    16.427   238.816     0.150
    16.492   235.598     0.150
    16.576   237.666     0.150
    17.010   240.592     0.150
    17.010   242.666     0.150
    17.140   244.768     0.150
    17.294   245.816     0.150
    17.335   247.236     0.150
    17.419   252.756     0.150
    17.820   253.006     0.150
    18.841   266.637     0.150
    19.050   265.357     0.150
    22.004   299.637     0.150
    23.588   313.861     0.150
    24.047   316.916     0.150
    31.245   381.654     0.150
    38.508   445.666     0.150
    38.689   447.617     0.150
    94.305   802.066     0.150
    95.996   809.268     0.150
   102.277   837.967     0.150
     0.289     6.191     0.150
     0.289     8.871     0.150
     0.289     5.852     0.150
     0.289     9.893     0.150
     0.290     6.223     0.150
     0.290     9.832     0.150
     0.290     9.502     0.150
     0.562    10.973     0.150
     0.562    18.871     0.150
     0.576    10.992     0.150
     0.576    19.072     0.150
     0.874    16.803     0.150
     0.874    28.451     0.150
     1.009    19.012     0.150
     1.009    32.711     0.150
     1.190    22.402     0.150
     1.190    38.932     0.150
     1.190    40.473     0.150
     1.336    24.631     0.150
     1.336    41.742     0.150
     1.336    42.631     0.150
     1.432    26.691     0.150
     1.432    45.422     0.150
     1.487    26.893     0.150
     1.581    27.861     0.150
     1.640    29.791     0.150
     1.640    50.771     0.150
     1.660    29.303     0.150
     1.675    29.262     0.150
     1.675    52.529     0.150
     1.737    31.592     0.150
     1.737    54.113     0.150
     1.920    32.688     0.150
     2.018    34.961     0.150
     2.018    60.977     0.150
     2.274    38.172     0.150
     2.388    39.736     0.150
     2.428    40.191     0.150
     2.428    44.592     0.150
     2.428    75.066     0.150
     2.428    76.146     0.150
     2.542    40.867     0.150
     2.542    40.621     0.150
     2.542    71.053     0.150
     2.654    44.023     0.150
     2.661    43.412     0.150
     2.738    44.912     0.150
     2.916    47.424     0.150
     3.143    50.199     0.150
     3.163    56.510     0.150
     3.398    59.549     0.150
     3.563    58.562     0.150
     3.563    95.941     0.150
     3.582    55.832     0.150
     3.593    56.379     0.150
     4.092    64.514     0.150
     4.092   124.326     0.150
     4.131    65.461     0.150
     4.204    64.111     0.150
     4.204   114.281     0.150
     4.297    64.932     0.150
     4.297   114.521     0.150
     5.243    80.041     0.150
     5.242    80.361     0.150
     5.561    85.092     0.150
     5.561   147.152     0.150
     6.553    99.912     0.150
     6.832   101.852     0.150
     7.064   106.232     0.150
     7.462   113.592     0.150
     7.462   234.367     0.150
     7.778   118.781     0.150
     8.393   125.041     0.150
     8.806   128.342     0.150
    10.562   154.316     0.150
    12.471   181.232     0.150
    31.245   381.512     0.150
    38.689   446.191     0.150
     0.281     5.844     0.150
     0.281     5.654     0.150
     0.283     5.874     0.150
     0.283     9.774     0.150
     0.557    10.794     0.150
     0.557    18.154     0.150
     0.577    11.134     0.150
     0.577    19.874     0.150
     0.888    16.854     0.150
     0.888    29.144     0.150
     1.023    18.824     0.150
     1.023    33.364     0.150
     1.181    22.414     0.150
     1.181    38.934     0.150
     1.344    24.664     0.150
     1.344    43.254     0.150
     1.432    26.794     0.150
     1.432    46.023     0.150
     1.444    26.324     0.150
     1.444    45.754     0.150
     1.645    29.794     0.150
     1.645    51.354     0.150
     1.739    31.624     0.150
     1.739    54.304     0.150
     1.820    32.744     0.150
     1.909    32.604     0.150
     1.909    32.504     0.150
     1.909    58.764     0.150
     2.025    35.611     0.150
     2.025    61.464     0.150
     2.193    36.364     0.150
     2.193    60.674     0.150
     2.382    39.560     0.150
     2.428    40.414     0.150
     2.428    45.314     0.150
     2.428    75.764     0.150
     2.428    40.288     0.150
     2.428    77.410     0.150
     2.428    40.144     0.150
     2.428    73.594     0.150
     2.524    40.558     0.150
     2.524    69.803     0.150
     2.650    43.202     0.150
     2.650    43.354     0.150
     2.659    43.680     0.150
     2.735    44.777     0.150
     2.909    47.011     0.150
     2.982    47.551     0.150
     2.982    83.631     0.150
     3.153    50.509     0.150
     3.153    99.110     0.150
     3.281    52.257     0.150
     3.403    54.662     0.150
     3.403   105.600     0.150
     3.476    55.084     0.150
     3.502    55.664     0.150
     3.569    58.654     0.150
     3.591    56.512     0.150
     3.729    59.036     0.150
     3.820   104.168     0.150
     4.029   109.043     0.150
     4.095    65.184     0.150
     4.097    64.064     0.150
     4.131    64.241     0.150
     4.131    65.774     0.150
     4.157    64.372     0.150
     4.157   109.712     0.150
     4.211   114.514     0.150
     4.278    64.744     0.150
     4.278    65.544     0.150
     4.314    67.885     0.150
     4.523    70.797     0.150
     4.643    71.954     0.150
     4.737    72.934     0.150
     4.969    76.562     0.150
     5.010    77.173     0.150
     5.015    77.069     0.150
     5.235    81.394     0.150
     5.244    82.534     0.150
     5.244    95.614     0.150
     5.532    84.527     0.150
     5.546    83.904     0.150
     5.546    85.354     0.150
     5.796    88.034     0.150
     5.855    90.064     0.150
     5.881    89.334     0.150
     6.064    92.534     0.150
     6.523   122.424     0.150
     6.523   206.044     0.150
     6.543    99.964     0.150
     7.059   107.084     0.150
     7.393   112.064     0.150
     7.430   235.634     0.150
     7.462   230.234     0.150
     7.462   111.259     0.150
     8.543   124.639     0.150
     8.788   130.134     0.150
     8.932   134.244     0.150
     8.981   135.474     0.150
     9.207   140.394     0.150
     9.431   142.534     0.150
     9.458   137.664     0.150
     9.864   149.154     0.150
    10.545   155.739     0.150
    10.608   158.454     0.150
    10.825   161.844     0.150
    11.873   174.056     0.150
    11.873   369.630     0.150
    12.032   178.254     0.150
    12.032   384.854     0.150
    12.459   180.064     0.150
    17.007   240.114     0.150
    38.691   446.601     0.150
    38.691   446.604     0.150
     0.437     8.898     0.150
     0.534    10.520     0.150
     0.534    18.000     0.150
     0.733    14.090     0.150
     0.733    13.910     0.150
     0.833    15.609     0.150
     0.901    17.648     0.150
     0.901    17.543     0.150
     0.901    28.789     0.150
     0.892    16.750     0.150
     0.892    17.141     0.150
     0.894    17.160     0.150
     0.938    17.840     0.150
     0.938    30.352     0.150
     1.002    19.191     0.150
     1.002    31.660     0.150
     1.046    20.359     0.150
     1.050    20.621     0.150
     1.041    18.941     0.150
     1.041    19.082     0.150
     1.041    32.289     0.150
     1.146    22.590     0.150
     1.164    21.609     0.150
     1.211    22.422     0.150
     1.211    38.688     0.150
     1.211    23.180     0.150
     1.209    21.969     0.150
     1.359    24.609     0.150
     1.378    25.121     0.150
     1.414    25.242     0.150
     1.414    43.742     0.150
     1.429    26.410     0.150
     1.460    26.852     0.150
     1.530    28.059     0.150
     1.680    28.797     0.150
     1.680    29.309     0.150
     1.685    29.672     0.150
     1.711    30.789     0.150
     1.717    30.910     0.150
     1.841    32.480     0.150
     1.859    32.730     0.150
     1.874    32.438     0.150
     1.874    57.652     0.150
     1.874    32.262     0.150
     1.882    33.031     0.150
     1.924    33.832     0.150
     1.932    33.352     0.150
     1.969    33.492     0.150
     2.013    34.840     0.150
     2.057    35.719     0.150
     2.090    35.961     0.150
     2.218    36.422     0.150
     2.218    62.609     0.150
     2.239    37.387     0.150
     2.404    38.750     0.150
     2.552    40.109     0.150
     2.789    45.809     0.150
     2.804    44.305     0.150
     2.800    45.961     0.150
     2.960    47.449     0.150
     2.979    47.480     0.150
     2.979    93.832     0.150
     3.011    48.250     0.150
     3.066    49.770     0.150
     3.258    52.301     0.150
     3.392    53.441     0.150
     3.584    57.371     0.150
     3.600    56.590     0.150
     3.812    59.789     0.150
     4.222    66.082     0.150
     4.724    72.559     0.150
     4.726    73.148     0.150
     5.628    85.699     0.150
     5.748    87.711     0.150
     5.748   187.352     0.150
     5.904    90.109     0.150
     0.260     5.848     0.150
     0.260     8.070     0.150
     0.262     5.789     0.150
     0.262     8.660     0.150
     0.262     8.969     0.150
     0.596    11.707     0.150
     0.596    20.508     0.150
     0.549    10.230     0.150
     0.549    17.750     0.150
     0.908    17.348     0.150
     0.908    29.559     0.150
     1.043    19.488     0.150
     1.043    33.500     0.150
     1.192    22.719     0.150
     1.192    23.039     0.150
     1.192    39.117     0.150
     1.207    23.547     0.150
     1.207    38.738     0.150
     1.365    25.160     0.150
     1.365    43.578     0.150
     1.365    42.840     0.150
     1.406    26.980     0.150
     1.451    27.398     0.150
     1.451    46.371     0.150
     1.465    26.809     0.150
     1.482    28.238     0.150
     1.499    27.277     0.150
     1.580    28.699     0.150
     1.666    30.188     0.150
     1.661    30.008     0.150
     1.688    29.730     0.150
     1.688    51.043     0.150
     1.688    30.949     0.150
     1.717    32.027     0.150
     1.759    32.293     0.150
     1.759    54.934     0.150
     1.842    32.879     0.150
     1.880    34.117     0.150
     1.922    35.141     0.150
     1.918    32.887     0.150
     1.918    61.488     0.150
     1.918    33.020     0.150
     1.918    33.500     0.150
     2.046    35.348     0.150
     2.046    62.367     0.150
     2.046    35.527     0.150
     2.056    37.047     0.150
     2.088    37.488     0.150
     2.110    37.418     0.150
     2.139    36.848     0.150
     2.193    36.719     0.150
     2.277    38.938     0.150
     2.331    41.070     0.150
     2.374    41.230     0.150
     2.396    40.062     0.150
     2.421    41.680     0.150
     2.431    42.027     0.150
     2.447    40.867     0.150
     2.447    45.445     0.150
     2.447    77.594     0.150
     2.447    42.168     0.150
     2.447    44.969     0.150
     2.447    73.988     0.150
     2.449    42.309     0.150
     2.449   937.910     0.150
     2.481    42.809     0.150
     2.514    40.820     0.150
     2.514    70.852     0.150
     2.514    40.488     0.150
     2.629    45.047     0.150
     2.651    45.340     0.150
     2.679    44.473     0.150
     2.679    82.508     0.150
     2.660    43.672     0.150
     2.660    43.891     0.150
     2.701    46.039     0.150
     2.752    45.371     0.150
     2.861    47.777     0.150
     2.922    47.609     0.150
     3.003    47.793     0.150
     3.003    85.215     0.150
     3.095    51.699     0.150
     3.175    50.371     0.150
     3.184    99.570     0.150
     3.181    52.430     0.150
     3.318   103.539     0.150
     3.290   101.859     0.150
     3.404    56.508     0.150
     3.404    63.848     0.150
     3.414    56.328     0.150
     3.424    55.031     0.150
     3.424   104.684     0.150
     3.479    55.367     0.150
     3.518    55.762     0.150
     3.590    57.488     0.150
     3.610    56.809     0.150
     3.610   101.148     0.150
     3.622    59.809     0.150
     3.609    57.320     0.150
     3.750    59.352     0.150
     3.750   116.488     0.150
     3.783    69.578     0.150
     3.783   118.332     0.150
     3.841   104.711     0.150
     3.836    62.160     0.150
     3.890    63.238     0.150
     4.117    64.785     0.150
     4.105    65.570     0.150
     4.149    65.109     0.150
     4.149    65.758     0.150
     4.233    66.438     0.150
     4.233   116.293     0.150
     4.233    66.859     0.150
     4.243    80.160     0.150
     4.268    65.078     0.150
     4.268    64.430     0.150
     4.637    71.930     0.150
     4.637    86.527     0.150
     4.693    73.125     0.150
     4.737    72.891     0.150
     4.921    77.598     0.150
     4.990    77.852     0.150
     5.036    77.738     0.150
     5.263    81.320     0.150
     5.263   143.617     0.150
     5.549    84.922     0.150
     5.549    85.520     0.150
     5.549   150.059     0.150
     5.699    86.660     0.150
     5.699    88.320     0.150
     5.794    87.891     0.150
     5.900    90.121     0.150
     6.074    93.117     0.150
     6.202    95.047     0.150
     6.272    94.844     0.150
     6.272    95.129     0.150
     6.361    97.449     0.150
     6.758   104.910     0.150
     6.802   101.602     0.150
     6.802   101.238     0.150
     7.075   106.578     0.150
     7.075   107.391     0.150
     7.189   110.141     0.150
     7.481   116.938     0.150
     7.482   112.094     0.150
     7.482   236.992     0.150
     7.777   120.570     0.150
     7.808   119.188     0.150
     7.794   117.898     0.150
     8.126   120.078     0.150
     8.379   124.590     0.150
     8.538   123.918     0.150
     8.538   270.043     0.150
     8.538   125.430     0.150
     8.775   129.074     0.150
     8.775   129.469     0.150
     8.800   132.168     0.150
     8.883   132.508     0.150
     8.936   133.008     0.150
     8.985   134.480     0.150
     8.996   134.891     0.150
     9.017   135.699     0.150
     9.120   137.090     0.150
     9.150   139.367     0.150
     9.439   139.898     0.150
     9.473   142.488     0.150
     9.732   144.109     0.150
     9.824   149.219     0.150
     9.876   146.020     0.150
     9.923   150.449     0.150
    10.528   154.195     0.150
    10.574   153.410     0.150
    10.611   156.367     0.150
    10.703   157.480     0.150
    10.751   158.418     0.150
    10.836   162.609     0.150
    11.185   167.840     0.150
    11.262   168.840     0.150
    11.894   176.824     0.150
    11.894   177.738     0.150
    12.137   180.258     0.150
    12.188   182.789     0.150
    12.322   182.559     0.150
    12.469   182.148     0.150
    12.469   182.688     0.150
    12.469   182.969     0.150
    12.667   182.750     0.150
    13.658   197.207     0.150
    14.355   210.070     0.150
    14.570   211.219     0.150
    15.514   228.188     0.150
    15.605   223.059     0.150
    15.744   226.609     0.150
    16.501   235.258     0.150
    16.586   235.789     0.150
    16.632   235.590     0.150
    17.023   243.293     0.150
    17.023   242.879     0.150
    17.040   240.277     0.150
    17.310   247.168     0.150
    17.829   254.168     0.150
    18.812   264.867     0.150
    24.039   318.094     0.150
    24.039   318.418     0.150
    31.256   382.715     0.150
    38.525   445.820     0.150
    38.711   444.559     0.150
    38.711   448.219     0.150
    96.024   808.367     0.150
   102.298   837.168     0.150
   107.750   860.168     0.150
     0.205     4.119     0.150
     0.205     7.799     0.150
     0.205     4.709     0.150
     0.205     7.359     0.150
     0.207     4.729     0.150
     0.207     7.709     0.150
     0.644    22.359     0.150
     0.956    17.439     0.150
     0.956    30.389     0.150
     1.092    19.729     0.150
     1.420    25.379     0.150
     1.420    44.080     0.150
     1.420    44.689     0.150
     1.503    27.119     0.150
     1.503    46.787     0.150
     1.520    27.129     0.150
     1.520    47.209     0.150
     1.735    29.465     0.150
     1.812    31.977     0.150
     1.812    55.455     0.150
     1.950    32.316     0.150
     1.950    56.168     0.150
     2.101    36.389     0.150
     2.101    63.484     0.150
     2.498    40.146     0.150
     2.498    69.912     0.150
     2.439    39.723     0.150
     2.499    40.613     0.150
     2.499    76.637     0.150
     2.691    42.697     0.150
     2.734    44.863     0.150
     2.734    83.123     0.150
     2.800    45.180     0.150
     2.800    88.100     0.150
     2.963    47.352     0.150
     3.237    51.891     0.150
     3.237    99.277     0.150
     3.228   100.270     0.150
     3.373   104.020     0.150
     3.478   106.578     0.150
     3.563    56.049     0.150
     3.659   118.096     0.150
     3.805   116.270     0.150
     4.250   136.168     0.150
     4.105   125.734     0.150
     4.172   126.928     0.150
     4.748   145.775     0.150
     5.044   153.344     0.150
     5.565    84.191     0.150
     5.565   146.389     0.150
     0.241     4.664     0.150
     0.241     8.336     0.150
     0.241     5.094     0.150
     0.241     8.113     0.150
     0.243     5.133     0.150
     0.243     8.285     0.150
     0.539    10.285     0.150
     0.539    17.312     0.150
     0.539    18.023     0.150
     0.616    11.793     0.150
     0.616    21.113     0.150
     0.928    17.652     0.150
     0.928    30.195     0.150
     1.063    19.676     0.150
     1.063    34.324     0.150
     1.384    25.434     0.150
     1.384    43.934     0.150
     1.384    44.766     0.150
     1.466    27.363     0.150
     1.466    45.559     0.150
     1.484    27.055     0.150
     1.700    29.652     0.150
     1.776    32.207     0.150
     1.923    56.176     0.150
     2.065    36.441     0.150
     2.406    39.707     0.150
     2.462    40.840     0.150
     2.462    46.215     0.150
     2.462    76.340     0.150
     2.462    77.059     0.150
     2.501    40.406     0.150
     2.501    70.273     0.150
     2.664    43.051     0.150
     2.697    43.395     0.150
     2.697    82.785     0.150
     2.765    45.156     0.150
     2.931    46.574     0.150
     3.024    48.664     0.150
     3.024    83.496     0.150
     3.200    99.430     0.150
     3.195    51.031     0.150
     3.195    88.676     0.150
     3.294    51.762     0.150
     3.294    90.172     0.150
     3.338    90.738     0.150
     3.529    55.750     0.150
     3.623    57.934     0.150
     3.769   115.996     0.150
     4.071   125.926     0.150
     4.135    66.766     0.150
     4.135   126.172     0.150
     4.164    64.688     0.150
     4.186    64.918     0.150
     4.252   114.543     0.150
     4.255    64.820     0.150
     4.255   112.102     0.150
     4.560    69.523     0.150
     4.560   142.145     0.150
     4.712    71.629     0.150
     4.712   144.219     0.150
     5.008   154.070     0.150
     5.045   156.613     0.150
     5.547    85.363     0.150
     5.547   147.934     0.150
     5.712    87.715     0.150
     6.266    94.824     0.150
     6.266   162.535     0.150
     6.788   101.684     0.150
     6.788   175.785     0.150
     7.497   114.324     0.150
     7.497   238.113     0.150
    10.510   154.289     0.150
    12.473   184.547     0.150
    38.728   447.965     0.150
     0.231     4.594     0.150
     0.231     7.914     0.150
     0.231     4.973     0.150
     0.231     7.793     0.150
     0.233     4.965     0.150
     0.233     7.973     0.150
     0.233     4.645     0.150
     0.535    10.184     0.150
     0.535    17.164     0.150
     0.535    17.875     0.150
     0.626    11.914     0.150
     0.626    21.223     0.150
     0.938    17.781     0.150
     0.938    30.645     0.150
     1.073    20.012     0.150
     1.218    24.254     0.150
     1.395    25.633     0.150
     1.395    44.113     0.150
     1.395    25.465     0.150
     1.395    43.902     0.150
     1.475    27.332     0.150
     1.475    46.012     0.150
     1.494    27.145     0.150
     1.494    46.934     0.150
     1.709    29.738     0.150
     1.785    32.430     0.150
     1.785    55.969     0.150
     1.927    32.621     0.150
     1.927    54.766     0.150
     2.075    36.797     0.150
     2.075    63.250     0.150
     2.413    39.996     0.150
     2.472    40.930     0.150
     2.472    76.504     0.150
     2.472    40.652     0.150
     2.472    45.352     0.150
     2.497    40.508     0.150
     2.497    69.254     0.150
     2.497    40.191     0.150
     2.669    43.473     0.150
     2.707    44.926     0.150
     2.707    83.184     0.150
     2.773    45.461     0.150
     2.937    47.602     0.150
     3.205   100.500     0.150
     3.209    52.336     0.150
     3.209    98.777     0.150
     3.298    52.430     0.150
     3.348   103.551     0.150
     3.452    56.301     0.150
     3.452   105.773     0.150
     3.536    56.215     0.150
     3.631    57.141     0.150
     3.631   117.449     0.150
     3.780   117.113     0.150
     4.145    67.035     0.150
     4.145   126.461     0.150
     4.173    65.031     0.150
     4.250    64.668     0.150
     4.250    64.234     0.150
     4.569    70.836     0.150
     4.722    74.211     0.150
     5.017    76.879     0.150
     5.054    77.938     0.150
     5.288    80.754     0.150
     5.548    84.793     0.150
     5.548    84.984     0.150
     5.720    88.441     0.150
     6.265    94.676     0.150
     6.783   100.750     0.150
     6.783   101.172     0.150
     7.093   105.656     0.150
     7.093   106.613     0.150
     7.506   112.977     0.150
     7.506   138.379     0.150
     7.506   236.527     0.150
     8.376   124.711     0.150
     8.753   129.520     0.150
     9.018   135.262     0.150
    10.502   153.453     0.150
    31.274   381.102     0.150
    38.547   444.504     0.150
    38.737   446.203     0.150
     0.282     6.094     0.150
     0.282     9.594     0.150
     0.282     5.711     0.150
     0.282     9.902     0.150
     0.566    10.961     0.150
     0.566    18.480     0.150
     0.571    11.184     0.150
     0.571    19.492     0.150
     0.883    17.004     0.150
     0.883    29.012     0.150
     1.018    19.172     0.150
     1.018    32.523     0.150
     1.187    22.383     0.150
     1.187    22.531     0.150
     1.187    38.453     0.150
     1.204    22.801     0.150
     1.204    38.422     0.150
     1.204    22.523     0.150
     1.342    24.793     0.150
     1.342    42.582     0.150
     1.427    26.770     0.150
     1.427    45.324     0.150
     1.443    26.352     0.150
     1.443    44.883     0.150
     1.645    29.941     0.150
     1.645    30.121     0.150
     1.645    51.102     0.150
     1.675    29.281     0.150
     1.675    54.855     0.150
     1.740    31.594     0.150
     1.740    54.660     0.150
     1.916    32.574     0.150
     1.916    56.855     0.150
     2.024    35.082     0.150
     2.024    61.996     0.150
     2.201    36.480     0.150
     2.201    62.363     0.150
     2.387    39.793     0.150
     2.423    40.188     0.150
     2.423    76.578     0.150
     2.430    40.262     0.150
     2.430    76.785     0.150
     2.532    40.441     0.150
     2.532    70.156     0.150
     2.532    40.633     0.150
     2.657    43.445     0.150
     2.659    44.195     0.150
     2.738    45.086     0.150
     2.914    47.328     0.150
     2.979    47.457     0.150
     2.979    84.805     0.150
     3.166    51.594     0.150
     3.166    99.105     0.150
     3.393    59.871     0.150
     3.484    55.211     0.150
     3.506    55.902     0.150
     3.569    58.184     0.150
     3.588    56.820     0.150
     3.595    57.434     0.150
     3.599    57.090     0.150
     3.728   116.484     0.150
     3.765    69.578     0.150
     3.765   117.188     0.150
     3.828    61.562     0.150
     4.102    64.281     0.150
     4.097    64.480     0.150
     4.133    75.660     0.150
     4.133    65.262     0.150
     4.161    65.254     0.150
     4.210    66.723     0.150
     4.210   115.383     0.150
     4.210    67.391     0.150
     4.286    64.688     0.150
     4.286    65.012     0.150
     4.286   137.344     0.150
     4.524    82.121     0.150
     4.524   140.469     0.150
     4.646    71.691     0.150
     4.662    71.051     0.150
     4.672    72.871     0.150
     4.672   144.113     0.150
     4.746    73.293     0.150
     4.944    76.203     0.150
     4.970    89.906     0.150
     4.970   152.891     0.150
     5.012    90.398     0.150
     5.240    81.184     0.150
     5.246    80.121     0.150
     5.246   169.031     0.150
     5.467    82.121     0.150
     5.534    99.656     0.150
     5.554    84.887     0.150
     5.554   147.121     0.150
     5.554    85.461     0.150
     5.686    88.305     0.150
     5.686    87.762     0.150
     5.863    89.992     0.150
     5.884    88.078     0.150
     6.042    92.383     0.150
     6.071    92.684     0.150
     6.200    94.691     0.150
     6.282    95.480     0.150
     6.360    96.953     0.150
     6.549   100.230     0.150
     6.722   102.953     0.150
     6.756   103.141     0.150
     6.821   101.594     0.150
     7.064   106.520     0.150
     7.064   226.762     0.150
     7.188   109.551     0.150
     7.282   108.973     0.150
     7.340   111.531     0.150
     7.399   111.461     0.150
     7.774   119.453     0.150
     7.793   117.531     0.150
     8.386   123.281     0.150
     8.386   124.184     0.150
     8.796   129.301     0.150
     8.799   136.480     0.150
     8.940   134.711     0.150
     8.989   136.051     0.150
     8.989   294.863     0.150
     9.001   135.941     0.150
     9.438   139.773     0.150
     9.438   304.133     0.150
     9.869   149.582     0.150
    10.551   154.621     0.150
    14.733   207.594     0.150
    23.940   315.184     0.150
     0.339     7.047     0.150
     0.339    11.969     0.150
     0.498     9.746     0.150
     0.498    16.738     0.150
     0.591    11.406     0.150
     0.751    14.297     0.150
     0.751    24.367     0.150
     0.751    25.449     0.150
     0.865    15.898     0.150
     0.846    15.637     0.150
     0.865    16.121     0.150
     0.865    26.773     0.150
     0.884    17.129     0.150
     0.901    16.719     0.150
     0.893    16.527     0.150
     0.893    27.988     0.150
     0.882    16.688     0.150
     0.882    28.148     0.150
     0.882    16.488     0.150
     0.882    28.297     0.150
     0.883    16.727     0.150
     0.883    28.477     0.150
     0.942    18.539     0.150
     0.942    29.906     0.150
     1.004    18.879     0.150
     1.044    18.816     0.150
     1.044    18.707     0.150
     1.044    32.098     0.150
     1.152    21.113     0.150
     1.152    35.836     0.150
     1.174    21.422     0.150
     1.174    36.758     0.150
     1.222    21.816     0.150
     1.427    25.262     0.150
     1.427    43.348     0.150
     1.623    27.539     0.150
     1.623    27.258     0.150
     1.857    33.605     0.150
     1.857    56.910     0.150
     1.857    31.770     0.150
     1.857    57.129     0.150
     1.857    31.938     0.150
     1.857    54.828     0.150
     1.928    32.488     0.150
     2.059    35.473     0.150
     2.059    62.020     0.150
     2.156    35.227     0.150
     2.210    37.016     0.150
     2.336    37.648     0.150
     2.438    39.539     0.150
     2.438    69.609     0.150
     2.481    40.379     0.150
     2.581    79.188     0.150
     2.577    40.949     0.150
     2.577    72.645     0.150
     2.707    74.766     0.150
     2.746    42.887     0.150
     2.746    74.492     0.150
     2.746    42.777     0.150
     2.803    45.684     0.150
     2.803    83.508     0.150
     2.972    47.527     0.150
     2.968    44.906     0.150
     3.008    48.172     0.150
     2.989    47.648     0.150
     3.047    48.727     0.150
     3.130    49.594     0.150
     3.130    94.324     0.150
     3.186    50.109     0.150
     3.186    97.285     0.150
     3.202    50.680     0.150
     3.332    52.398     0.150
     3.291    51.289     0.150
     3.291    89.875     0.150
     3.291    50.770     0.150
     3.445    53.254     0.150
     3.497    56.086     0.150
     3.497   104.527     0.150
     3.567    55.926     0.150
     3.567    55.648     0.150
     3.613    56.441     0.150
     3.613    98.055     0.150
     3.613    56.656     0.150
     3.643    56.961     0.150
     3.761    58.469     0.150
     3.747    58.480     0.150
     3.933    61.062     0.150
     4.069   124.723     0.150
     4.370   134.746     0.150
     4.431    67.566     0.150
     4.426    67.820     0.150
     4.487    68.242     0.150
     4.764    73.359     0.150
     4.777    73.387     0.150
     4.831    73.746     0.150
     4.944    74.359     0.150
     5.155    79.266     0.150
     5.155    79.738     0.150
     5.237    79.605     0.150
     5.314    80.406     0.150
     5.380    82.371     0.150
     5.575    85.047     0.150
     5.701    86.629     0.150
     5.776    86.539     0.150
     5.789    86.988     0.150
     5.855    89.008     0.150
     6.158    92.867     0.150
     6.225    93.812     0.150
     6.283    93.168     0.150
     6.425    96.098     0.150
     7.034   102.988     0.150
     7.034   103.156     0.150
     7.187   107.008     0.150
     8.242   120.898     0.150
     9.071   131.227     0.150
     9.071   131.957     0.150
    10.935   157.688     0.150
    10.936   275.902     0.150
    12.108   176.477     0.150
    17.510   243.922     0.150
    19.085   260.520     0.150
    38.101   443.395     0.150
     0.403     7.848     0.150
     0.403    13.699     0.150
     0.403    14.207     0.150
     0.479     9.438     0.150
     0.479    15.637     0.150
     0.480     9.469     0.150
     0.480    16.336     0.150
     0.480    16.617     0.150
     0.480    17.008     0.150
     0.930    32.316     0.150
     0.910    17.066     0.150
     1.229    22.352     0.150
     1.229    37.992     0.150
     1.251    22.758     0.150
     1.251    37.828     0.150
     1.251    38.809     0.150
     1.244    23.039     0.150
     1.336    23.629     0.150
     1.336    39.680     0.150
     1.336    23.797     0.150
     1.437    25.828     0.150
     1.437    45.004     0.150
     1.512    26.719     0.150
     1.512    26.578     0.150
     1.512    45.406     0.150
     1.564    27.871     0.150
     1.564    48.023     0.150
     1.632    27.305     0.150
     1.632    48.398     0.150
     1.632    27.680     0.150
     1.632    47.828     0.150
     1.913    32.863     0.150
     1.913    57.551     0.150
     1.936    31.836     0.150
     2.228    40.156     0.150
     2.228    68.941     0.150
     2.228    39.988     0.150
     2.228    67.656     0.150
     2.347    37.797     0.150
     2.347    65.906     0.150
     2.374    75.797     0.150
     2.947    83.477     0.150
     3.082    85.828     0.150
     3.207    49.930     0.150
     3.437    55.020     0.150
     3.465    54.938     0.150
     3.819    69.430     0.150
     3.918    71.906     0.150
     4.757   138.316     0.150
     4.808    90.789     0.150
     5.045    78.770     0.150
     5.276    80.227     0.150
     5.333    80.488     0.150
     5.555    83.148     0.150
     5.578    83.566     0.150
     5.759    86.430     0.150
     5.789    86.879     0.150
     6.418    96.430     0.150
     6.763    99.848     0.150
     6.763   198.180     0.150
     7.172   106.117     0.150
     0.367     7.539     0.150
     0.367    12.773     0.150
     0.618    12.234     0.150
     0.618    20.531     0.150
     0.618    12.453     0.150
     0.618    20.320     0.150
     0.620    12.414     0.150
     0.620    20.594     0.150
     0.620    20.312     0.150
     0.645    12.164     0.150
     0.688    13.211     0.150
     0.688    22.508     0.150
     0.767    14.164     0.150
     0.963    17.922     0.150
     0.963    31.648     0.150
     1.000    20.320     0.150
     1.000    34.578     0.150
     1.013    18.938     0.150
     1.013    32.680     0.150
     1.013    32.000     0.150
     1.075    20.062     0.150
     1.098    20.703     0.150
     1.098    34.258     0.150
     1.109    20.398     0.150
     1.109    34.352     0.150
     1.179    23.055     0.150
     1.188    22.828     0.150
     1.308    23.750     0.150
     1.308    40.844     0.150
     1.316    23.914     0.150
     1.370    24.062     0.150
     1.370    43.805     0.150
     1.370    44.094     0.150
     1.368    25.523     0.150
     1.404    25.977     0.150
     1.404    43.734     0.150
     1.486    26.844     0.150
     1.563    28.758     0.150
     1.691    29.719     0.150
     1.691    51.336     0.150
     1.691    30.352     0.150
     1.691    51.531     0.150
     1.711    28.867     0.150
     1.697    30.812     0.150
     1.729    30.375     0.150
     1.729    53.109     0.150
     1.759    32.719     0.150
     1.759    54.672     0.150
     1.972    35.133     0.150
     1.972    60.531     0.150
     2.021    37.875     0.150
     2.021    62.805     0.150
     2.096    35.031     0.150
     2.096    58.352     0.150
     2.097    34.875     0.150
     2.104    34.859     0.150
     2.104    59.117     0.150
     2.099    34.789     0.150
     2.099    64.484     0.150
     2.099    34.891     0.150
     2.131    35.234     0.150
     2.292    37.602     0.150
     2.292    69.000     0.150
     2.320    69.977     0.150
     2.426    39.977     0.150
     2.426    73.477     0.150
     2.443    73.188     0.150
     2.533    46.578     0.150
     2.616    41.164     0.150
     2.616    71.352     0.150
     2.646    42.367     0.150
     2.682    42.961     0.150
     2.682    75.227     0.150
     2.831    78.812     0.150
     2.831    78.500     0.150
     2.834    44.469     0.150
     2.834    78.391     0.150
     2.864    45.562     0.150
     2.864    50.781     0.150
     2.969    82.141     0.150
     3.065    91.695     0.150
     3.230    56.078     0.150
     3.232    51.898     0.150
     3.292    59.789     0.150
     3.363    53.000     0.150
     3.394   102.680     0.150
     3.529    96.195     0.150
     3.758   113.117     0.150
     3.805    67.203     0.150
     3.855    59.055     0.150
     3.883    61.281     0.150
     3.877   105.289     0.150
     4.141    66.469     0.150
     4.335   132.477     0.150
     4.368   116.500     0.150
     4.368    84.664     0.150
     4.666    71.883     0.150
     4.912    75.648     0.150
     5.374    82.953     0.150
     5.426    83.281     0.150
     5.674    86.633     0.150
     6.219    93.953     0.150
     7.101   135.852     0.150
     7.132   136.500     0.150
     0.346     7.166     0.150
     0.346    12.086     0.150
     0.578    11.127     0.150
     0.688    12.957     0.150
     0.747    14.686     0.150
     0.747    23.957     0.150
     0.748    14.717     0.150
     0.748    14.477     0.150
     0.748    23.957     0.150
     0.772    14.945     0.150
     0.772    25.557     0.150
     0.889    17.086     0.150
     0.889    28.525     0.150
     0.889    29.836     0.150
     0.889    16.877     0.150
     0.899    17.195     0.150
     0.975    30.920     0.150
     0.983    18.307     0.150
     1.083    20.256     0.150
     1.179    21.656     0.150
     1.261    24.154     0.150
     1.261    40.625     0.150
     1.276    23.941     0.150
     1.359    24.605     0.150
     1.564    28.445     0.150
     1.564    28.086     0.150
     1.894    35.123     0.150
     1.894    58.934     0.150
     1.972    36.365     0.150
     1.974    36.602     0.150
     1.974    61.623     0.150
     1.974    36.355     0.150
     2.192    38.139     0.150
     2.192    66.512     0.150
     3.104    52.387     0.150
     5.700    98.846     0.150
     0.499    10.164     0.150
     0.499    16.543     0.150
     0.545    11.113     0.150
     0.545    18.492     0.150
     0.545    17.723     0.150
     0.546    10.133     0.150
     0.546    17.762     0.150
     0.559    11.031     0.150
     0.882    16.293     0.150
     0.836    15.664     0.150
     0.836    27.344     0.150
     0.904    18.281     0.150
     1.099    20.473     0.150
     1.148    21.723     0.150
     1.148    36.051     0.150
     1.183    22.293     0.150
     1.237    38.543     0.150
     1.338    23.242     0.150
     1.477    26.812     0.150
     1.477    45.938     0.150
     1.618    27.148     0.150
     1.815    31.957     0.150
     1.815    55.395     0.150
     2.078    34.176     0.150
     2.085    34.578     0.150
     2.085    64.758     0.150
     2.150    35.207     0.150
     2.358    73.535     0.150
     2.424    38.316     0.150
     2.424    66.418     0.150
     2.416    39.812     0.150
     2.416    73.844     0.150
     2.439    39.730     0.150
     2.893    46.652     0.150
     2.893    89.887     0.150
     2.981    48.090     0.150
     2.981    83.273     0.150
     3.101    95.660     0.150
     3.160    55.203     0.150
     3.160    95.875     0.150
     3.511   107.570     0.150
     3.849    59.648     0.150
     3.849   117.246     0.150
     4.177    63.414     0.150
     4.256   131.328     0.150
     4.444   135.305     0.150
     6.061    90.738     0.150
     6.721    99.500     0.150
     0.348     7.289     0.150
     0.348    11.945     0.150
     0.580    11.359     0.150
     0.580    18.875     0.150
     0.690    13.281     0.150
     0.690    22.734     0.150
     0.746    14.672     0.150
     0.746    24.383     0.150
     0.746    14.477     0.150
     0.747    14.281     0.150
     0.747    24.344     0.150
     0.747    14.703     0.150
     0.747    24.633     0.150
     0.891    16.977     0.150
     0.891    28.812     0.150
     0.891    17.125     0.150
     0.898    17.883     0.150
     0.945    19.562     0.150
     0.976    18.680     0.150
     0.976    31.070     0.150
     0.985    18.586     0.150
     0.985    31.133     0.150
     1.082    21.125     0.150
     1.180    21.812     0.150
     1.180    36.633     0.150
     1.260    23.141     0.150
     1.260    40.023     0.150
     1.277    24.109     0.150
     1.277    40.219     0.150
     1.436    25.953     0.150
     1.566    28.273     0.150
     1.566    48.242     0.150
     1.566    28.523     0.150
     1.566    48.586     0.150
     1.646    28.422     0.150
     1.895    32.930     0.150
     1.895    59.070     0.150
     1.973    34.094     0.150
     1.973    57.859     0.150
     1.975    34.102     0.150
     1.975    57.859     0.150
     1.975    33.789     0.150
     1.975    61.320     0.150
     2.003    33.703     0.150
     2.119    35.281     0.150
     2.193    37.742     0.150
     2.193    67.266     0.150
     2.310    38.719     0.150
     2.371    38.734     0.150
     2.550    41.883     0.150
     2.573    41.789     0.150
     2.573    73.516     0.150
     2.658    42.188     0.150
     2.658    74.594     0.150
     2.846    88.641     0.150
     2.937    51.000     0.150
     2.937    89.453     0.150
     3.106    47.875     0.150
     3.128    88.164     0.150
     3.268   100.867     0.150
     3.423    93.750     0.150
     3.631    57.680     0.150
     3.631   110.281     0.150
     3.682   113.086     0.150
     3.751    59.336     0.150
     3.806    60.242     0.150
     4.405    67.156     0.150
     4.970    76.680     0.150
     5.258    81.945     0.150
     5.383    83.000     0.150
     6.200    93.867     0.150
     6.952   103.039     0.150
     0.403     8.109     0.150
     0.444     8.930     0.150
     0.444    14.570     0.150
     0.444     8.789     0.150
     0.444    14.750     0.150
     0.446     8.539     0.150
     0.446    14.359     0.150
     0.446     8.805     0.150
     0.446    14.719     0.150
     0.707    13.602     0.150
     0.795    15.352     0.150
     0.845    16.016     0.150
     1.244    39.742     0.150
     1.301    23.594     0.150
     1.354    41.844     0.150
     1.423    26.195     0.150
     1.707    30.555     0.150
     1.928    33.430     0.150
     2.045    34.086     0.150
     2.398    39.031     0.150
     2.414    40.281     0.150
     2.415    41.656     0.150
     2.415    73.516     0.150
     2.415    74.461     0.150
     2.782    45.000     0.150
     3.479    55.602     0.150
     3.492    56.406     0.150
     3.663    57.430     0.150
     4.108    67.000     0.150
     4.224    66.734     0.150
     4.518    67.992     0.150
     4.942    75.531     0.150
     5.060    78.484     0.150
     5.060   159.734     0.150
     5.219    82.312     0.150
     5.219   152.516     0.150
     5.301    82.875     0.150
     5.699    85.883     0.150
     5.710    89.211     0.150
     5.731    87.383     0.150
     6.006    91.633     0.150
     6.015    90.961     0.150
     6.184    94.344     0.150
     6.323    96.266     0.150
     6.485    97.961     0.150
     6.654   101.430     0.150
     6.771   103.102     0.150
     6.851   101.734     0.150
     6.885   104.953     0.150
     7.464   113.891     0.150
     7.484   113.109     0.150
     7.679   119.953     0.150
     7.713   114.633     0.150
     7.805   116.750     0.150
     7.893   120.430     0.150
     8.001   121.266     0.150
     8.052   119.016     0.150
     8.101   118.852     0.150
     8.196   122.859     0.150
     8.368   122.961     0.150
     8.393   127.445     0.150
     8.572   127.516     0.150
     8.605   131.281     0.150
     8.774   129.336     0.150
     8.774   130.430     0.150
     8.851   135.055     0.150
     8.926   134.906     0.150
     9.028   132.180     0.150
     9.023   134.883     0.150
     9.058   135.672     0.150
     9.075   136.266     0.150
     9.085   136.875     0.150
     9.107   136.695     0.150
     9.112   137.406     0.150
     9.117   136.672     0.150
     9.121   136.703     0.150
     9.134   136.836     0.150
     9.138   137.000     0.150
     9.153   137.023     0.150
     9.175   137.266     0.150
     9.178   137.562     0.150
     9.185   137.406     0.150
     9.188   137.781     0.150
     9.252   138.969     0.150
     9.280   138.820     0.150
     9.356   139.875     0.150
     9.373   140.789     0.150
     9.511   143.062     0.150
     9.933   147.336     0.150
     9.956   150.523     0.150
    10.032   149.789     0.150
    10.443   154.906     0.150
    10.521   157.969     0.150
    10.775   157.812     0.150
    10.775   342.234     0.150
    10.784   157.766     0.150
    10.794   159.719     0.150
    10.862   158.266     0.150
    11.214   162.312     0.150
    11.985   175.711     0.150
    12.574   185.484     0.150
    12.587   184.273     0.150
    12.587   184.211     0.150
    12.764   188.109     0.150
    12.860   189.875     0.150
    12.982   191.852     0.150
    13.062   191.211     0.150
    13.154   191.992     0.150
    13.479   196.914     0.150
    13.648   195.875     0.150
    14.082   206.562     0.150
    14.349   213.031     0.150
    14.817   214.102     0.150
    14.819   217.680     0.150
    17.037   244.250     0.150
    17.626   248.844     0.150
    21.072   291.359     0.150
    24.196   318.266     0.150
    28.858   360.211     0.150
    31.287   381.906     0.150
    38.505   445.688     0.150
    38.647   447.164     0.150
    45.747   507.461     0.150
    82.644   745.523     0.150
    95.905   809.859     0.150
     0.448     8.961     0.150
     0.448    14.633     0.150
     0.450     8.594     0.150
     0.450    14.633     0.150
     0.450     8.973     0.150
     0.450    14.852     0.150
     0.450    15.254     0.150
     0.699    13.883     0.150
     0.699    23.512     0.150
     0.837    16.102     0.150
     0.837    27.582     0.150
     1.231    22.641     0.150
     1.231    38.883     0.150
     1.231    22.762     0.150
     1.284    23.633     0.150
     1.340    24.762     0.150
     1.340    41.941     0.150
     1.340    24.391     0.150
     1.406    26.402     0.150
     1.406    44.543     0.150
     1.560    27.832     0.150
     1.560    47.152     0.150
     1.560    27.992     0.150
     1.696    30.391     0.150
     1.696    54.043     0.150
     1.696    31.473     0.150
     1.691    30.754     0.150
     1.691    52.523     0.150
     1.714    30.633     0.150
     1.812    31.992     0.150
     1.915    34.016     0.150
     1.915    58.359     0.150
     1.915    33.262     0.150
     2.029    34.453     0.150
     2.029    34.145     0.150
     2.397    40.812     0.150
     2.397    73.523     0.150
     2.399    41.531     0.150
     2.399    44.082     0.150
     2.399    73.754     0.150
     2.399    40.723     0.150
     2.399    73.254     0.150
     2.399    40.090     0.150
     2.399    74.836     0.150
     2.435    40.477     0.150
     2.577    43.035     0.150
     2.756    44.059     0.150
     2.756    76.172     0.150
     2.746    45.180     0.150
     2.765    45.242     0.150
     2.811    45.957     0.150
     2.977    48.348     0.150
     3.119    96.395     0.150
     3.466    54.992     0.150
     3.466   106.043     0.150
     3.479    54.703     0.150
     3.479   106.723     0.150
     3.588    65.551     0.150
     3.616   112.086     0.150
     3.638    59.133     0.150
     3.726   115.246     0.150
     3.882    65.723     0.150
     4.015   122.594     0.150
     4.109   129.754     0.150
     4.096    65.320     0.150
     4.207    66.301     0.150
     4.510    68.344     0.150
     4.510    68.586     0.150
     4.510   119.680     0.150
     4.888    76.602     0.150
     4.888   149.113     0.150
     4.928    75.473     0.150
     5.071    78.473     0.150
     5.284    81.410     0.150
     5.694    85.711     0.150
     5.693    86.781     0.150
     5.715    87.012     0.150
     5.715   151.070     0.150
     5.989    91.660     0.150
     6.003    89.652     0.150
     6.003   157.141     0.150
     6.166    93.863     0.150
     6.306    96.070     0.150
     6.472    97.191     0.150
     6.636   101.410     0.150
     6.836   100.223     0.150
     6.868   104.953     0.150
     6.878   102.570     0.150
     7.466   111.133     0.150
     7.876   119.352     0.150
     7.882   115.492     0.150
     8.557   125.480     0.150
     8.719   126.012     0.150
     9.023   131.402     0.150
    10.770   155.441     0.150
    10.773   156.152     0.150
    10.773   158.051     0.150
    10.774   157.762     0.150
    12.570   185.312     0.150
    38.632   446.469     0.150
     0.132     3.979     0.150
     0.132     6.959     0.150
     0.399     8.159     0.150
     0.399    14.159     0.150
     0.525    10.199     0.150
     0.525    17.539     0.150
     0.785    14.519     0.150
     0.785    24.648     0.150
     0.785    14.389     0.150
     0.787    14.589     0.150
     0.787    24.938     0.150
     0.787    24.799     0.150
     0.856    15.799     0.150
     0.856    27.019     0.150
     0.856    15.679     0.150
     0.856    27.669     0.150
     0.935    17.459     0.150
     0.935    29.679     0.150
     0.965    17.358     0.150
     0.965    29.809     0.150
     1.063    19.438     0.150
     1.063    32.498     0.150
     1.067    19.826     0.150
     1.067    32.863     0.150
     1.080    19.849     0.150
     1.096    19.219     0.150
     1.149    21.269     0.150
     1.149    39.068     0.150
     1.186    20.869     0.150
     1.186    35.898     0.150
     1.186    36.209     0.150
     1.203    39.680     0.150
     1.330    23.692     0.150
     1.330    40.600     0.150
     1.338    23.519     0.150
     1.391    25.999     0.150
     1.391    44.109     0.150
     1.391    24.774     0.150
     1.391    43.217     0.150
     1.410    25.568     0.150
     1.410    44.029     0.150
     1.437    24.919     0.150
     1.540    26.700     0.150
     1.540    26.769     0.150
     1.540    46.238     0.150
     1.555    50.469     0.150
     1.569    27.709     0.150
     1.569    47.260     0.150
     1.600    27.669     0.150
     1.600    48.680     0.150
     1.699    30.209     0.150
     1.699    51.850     0.150
     1.840    30.619     0.150
     1.840    30.514     0.150
     1.840    52.402     0.150
     1.865    31.549     0.150
     1.949    34.699     0.150
     2.024    36.908     0.150
     2.043    36.119     0.150
     2.044    34.328     0.150
     2.044    34.154     0.150
     2.044    61.855     0.150
     2.148    35.770     0.150
     2.148    61.420     0.150
     2.164    36.959     0.150
     2.191    37.658     0.150
     2.203    36.834     0.150
     2.335    37.568     0.150
     2.417    39.854     0.150
     2.471    39.234     0.150
     2.471    69.205     0.150
     2.520    42.049     0.150
     2.557    41.119     0.150
     2.557    40.990     0.150
     2.645    41.350     0.150
     2.645    72.346     0.150
     2.703    43.719     0.150
     2.754    83.572     0.150
     2.859    44.186     0.150
     2.859    78.469     0.150
     2.943    88.570     0.150
     2.963    47.430     0.150
     3.071    49.059     0.150
     3.091    48.789     0.150
     3.171    50.119     0.150
     3.208    51.449     0.150
     3.221    50.494     0.150
     3.240    51.600     0.150
     3.311    89.447     0.150
     3.384    53.168     0.150
     3.525    94.229     0.150
     3.536    55.049     0.150
     3.640    57.146     0.150
     3.640   109.475     0.150
     3.723    99.859     0.150
     3.753    59.248     0.150
     3.753    69.260     0.150
     3.984    62.648     0.150
     4.513   120.199     0.150
     4.514    69.439     0.150
     4.609    69.738     0.150
     4.856    73.760     0.150
     4.980    76.859     0.150
     5.356    82.309     0.150
     5.497    81.869     0.150
     5.589    84.738     0.150
     5.589    84.518     0.150
     5.795    88.148     0.150
     5.924    89.699     0.150
     5.970    89.168     0.150
     6.077    91.969     0.150
     6.415    95.939     0.150
     7.155   105.471     0.150
     0.431     8.480     0.150
     0.431    14.520     0.150
     0.433     8.510     0.150
     0.433    14.359     0.150
     0.433    14.949     0.150
     0.433    15.350     0.150
     0.433    14.570     0.150
     0.662    12.109     0.150
     0.764    13.449     0.150
     0.764    24.061     0.150
     0.764    25.770     0.150
     0.895    16.680     0.150
     0.895    29.109     0.150
     1.315    24.090     0.150
     1.315    41.680     0.150
     1.315    24.570     0.150
     1.314    45.160     0.150
     1.355    42.840     0.150
     1.416    25.936     0.150
     1.416    45.330     0.150
     1.574    48.600     0.150
     1.611    28.320     0.150
     1.595    29.311     0.150
     1.595    50.250     0.150
     1.614    49.660     0.150
     1.680    30.070     0.150
     1.704    29.775     0.150
     1.704    29.900     0.150
     1.703    30.297     0.150
     1.703    53.123     0.150
     1.930    33.330     0.150
     1.930    59.033     0.150
     1.930    58.680     0.150
     2.029    33.734     0.150
     2.378    38.609     0.150
     2.403    44.490     0.150
     2.403    75.189     0.150
     2.408    39.240     0.150
     2.410    40.312     0.150
     2.410    39.510     0.150
     2.410    44.035     0.150
     2.410    75.135     0.150
     2.440    39.984     0.150
     2.591    43.680     0.150
     2.743    43.516     0.150
     2.743    43.359     0.150
     2.743    76.910     0.150
     2.766    44.584     0.150
     2.766    44.869     0.150
     2.754    45.385     0.150
     2.828    45.162     0.150
     2.981    47.910     0.150
     3.021    47.383     0.150
     3.131    51.523     0.150
     3.182    51.863     0.150
     3.332    53.672     0.150
     3.332   102.586     0.150
     3.481    55.539     0.150
     3.494    55.609     0.150
     3.542    56.797     0.150
     3.598    57.480     0.150
     3.644    56.930     0.150
     3.631    57.805     0.150
     3.631   113.307     0.150
     3.683    58.572     0.150
     3.655    57.621     0.150
     3.655    57.350     0.150
     3.904    60.334     0.150
     4.029    64.070     0.150
     4.029   122.002     0.150
     4.120    64.832     0.150
     4.111    64.354     0.150
     4.111    65.570     0.150
     4.185    65.689     0.150
     4.209    65.359     0.150
     4.209    65.641     0.150
     4.172    64.346     0.150
     4.498    68.039     0.150
     4.480    69.715     0.150
     4.583    71.760     0.150
     4.658    72.197     0.150
     4.837   126.430     0.150
     4.837    73.850     0.150
     4.902    76.186     0.150
     4.902    75.641     0.150
     4.894    76.471     0.150
     4.982    76.826     0.150
     5.055    77.850     0.150
     5.274    81.312     0.150
     5.297    81.744     0.150
     5.309    82.527     0.150
     5.491    84.461     0.150
     5.511    81.170     0.150
     5.679    85.221     0.150
     5.712    86.566     0.150
     5.702    87.639     0.150
     5.759    87.340     0.150
     5.832    89.170     0.150
     5.867    90.170     0.150
     6.109    94.223     0.150
     6.465    97.289     0.150
     6.418    96.980     0.150
     6.816   102.287     0.150
     6.884   101.850     0.150
     6.884   178.459     0.150
     7.034   104.623     0.150
     7.034   104.270     0.150
     7.098   107.162     0.150
     7.437   112.293     0.150
     7.437   236.490     0.150
     8.552   127.164     0.150
     8.673   130.123     0.150
     8.673   129.199     0.150
     8.753   129.383     0.150
     8.753   128.641     0.150
     8.753   129.109     0.150
     8.753   128.279     0.150
     9.009   132.064     0.150
     9.009   131.760     0.150
     9.284   140.697     0.150
     9.501   141.020     0.150
     9.501   178.715     0.150
     9.501   300.545     0.150
     9.913   144.990     0.150
    10.764   157.221     0.150
    10.757   157.100     0.150
    10.757   156.789     0.150
    10.758   157.564     0.150
    10.758   339.861     0.150
    10.844   159.945     0.150
    11.193   162.574     0.150
    11.413   167.545     0.150
    11.547   170.797     0.150
    11.569   171.113     0.150
    11.703   171.328     0.150
    11.808   174.641     0.150
    11.808   173.168     0.150
    11.966   175.215     0.150
    12.091   176.607     0.150
    12.281   179.986     0.150
    12.481   182.865     0.150
    12.514   184.047     0.150
    12.556   183.398     0.150
    12.571   184.564     0.150
    12.571   184.141     0.150
    12.743   189.039     0.150
    12.950   191.721     0.150
    12.997   190.309     0.150
    13.347   194.309     0.150
    13.497   197.703     0.150
    13.544   197.568     0.150
    13.630   197.414     0.150
    13.757   200.719     0.150
    13.756   202.020     0.150
    13.789   199.088     0.150
    13.865   200.795     0.150
    13.891   200.092     0.150
    13.891   200.199     0.150
    14.305   208.094     0.150
    14.575   215.010     0.150
    14.604   211.854     0.150
    14.639   210.877     0.150
    14.720   214.416     0.150
    14.797   213.135     0.150
    14.804   214.418     0.150
    15.087   218.021     0.150
    15.244   219.662     0.150
    15.246   219.787     0.150
    15.388   222.840     0.150
    15.643   225.119     0.150
    15.727   224.992     0.150
    15.748   227.240     0.150
    15.908   226.635     0.150
    16.137   231.785     0.150
    16.769   237.938     0.150
    17.029   242.195     0.150
    17.029   242.531     0.150
    17.029   546.527     0.150
    17.091   242.877     0.150
    17.147   242.330     0.150
    17.179   244.547     0.150
    17.248   246.609     0.150
    17.295   244.459     0.150
    17.340   245.740     0.150
    17.399   246.354     0.150
    17.399   246.539     0.150
    17.411   247.238     0.150
    17.411   247.051     0.150
    17.516   247.562     0.150
    17.605   248.695     0.150
    17.644   249.836     0.150
    17.770   248.551     0.150
    18.135   255.184     0.150
    18.135   257.141     0.150
    18.205   255.859     0.150
    18.925   263.748     0.150
    18.925   264.730     0.150
    18.939   262.311     0.150
    19.041   265.455     0.150
    19.379   269.768     0.150
    19.379   269.061     0.150
    19.648   272.982     0.150
    19.650   272.898     0.150
    19.695   272.484     0.150
    19.695   272.129     0.150
    19.818   274.303     0.150
    20.176   277.566     0.150
    20.746   283.656     0.150
    20.746   283.080     0.150
    21.052   287.336     0.150
    21.263   289.521     0.150
    21.370   290.605     0.150
    21.370   291.240     0.150
    21.512   290.580     0.150
    21.614   294.514     0.150
    21.614   294.369     0.150
    22.478   301.510     0.150
    22.799   305.201     0.150
    23.411   312.240     0.150
    23.466   313.932     0.150
    23.743   316.535     0.150
    23.833   316.295     0.150
    23.833   315.740     0.150
    24.179   318.340     0.150
    24.179   317.189     0.150
    24.179   317.471     0.150
    24.522   322.762     0.150
    24.764   324.633     0.150
    24.991   326.045     0.150
    24.999   325.732     0.150
    25.072   326.906     0.150
    25.252   329.408     0.150
    25.252   330.641     0.150
    25.379   329.654     0.150
    25.408   329.344     0.150
    25.497   330.039     0.150
    25.509   331.523     0.150
    25.743   332.895     0.150
    25.781   332.293     0.150
    25.853   334.271     0.150
    26.030   335.412     0.150
    26.088   335.865     0.150
    26.094   335.830     0.150
    26.147   336.566     0.150
    26.235   337.320     0.150
    26.259   337.150     0.150
    26.292   337.863     0.150
    26.304   338.693     0.150
    26.305   337.637     0.150
    26.422   339.793     0.150
    26.422   340.660     0.150
    26.431   339.723     0.150
    26.463   339.646     0.150
    26.520   340.346     0.150
    26.641   341.502     0.150
    26.647   340.973     0.150
    26.671   342.213     0.150
    26.751   341.258     0.150
    26.922   343.990     0.150
    26.924   343.873     0.150
    26.988   343.646     0.150
    27.023   345.311     0.150
    27.023   345.430     0.150
    27.028   343.309     0.150
    27.038   343.740     0.150
    27.066   344.230     0.150
    27.110   344.535     0.150
    27.255   346.441     0.150
    27.302   346.504     0.150
    27.305   345.844     0.150
    27.320   347.424     0.150
    27.322   346.961     0.150
    27.341   346.250     0.150
    27.360   346.652     0.150
    27.371   347.336     0.150
    27.381   347.900     0.150
    27.448   347.855     0.150
    27.448   348.453     0.150
    27.457   346.990     0.150
    27.539   348.781     0.150
    27.560   350.016     0.150
    27.573   349.270     0.150
    27.613   349.832     0.150
    27.634   349.865     0.150
    27.638   350.467     0.150
    27.745   351.781     0.150
    27.777   351.061     0.150
    27.893   352.156     0.150
    27.910   352.016     0.150
    27.984   352.352     0.150
    28.026   352.861     0.150
    28.064   352.906     0.150
    28.069   352.244     0.150
    28.086   354.135     0.150
    28.629   358.518     0.150
    28.747   358.982     0.150
    28.838   360.658     0.150
    28.898   360.875     0.150
    28.902   362.236     0.150
    28.924   361.738     0.150
    29.036   362.771     0.150
    29.113   363.471     0.150
    29.130   363.391     0.150
    29.190   362.953     0.150
    29.320   364.803     0.150
    29.393   365.262     0.150
    29.409   365.389     0.150
    29.485   365.951     0.150
    29.536   366.693     0.150
    29.583   367.762     0.150
    29.584   367.922     0.150
    29.762   369.312     0.150
    29.767   369.186     0.150
    29.778   368.660     0.150
    29.828   369.273     0.150
    29.908   369.014     0.150
    29.956   369.102     0.150
    29.976   368.406     0.150
    30.042   370.762     0.150
    30.099   371.480     0.150
    30.357   374.289     0.150
    30.361   374.984     0.150
    30.424   374.699     0.150
    30.500   375.824     0.150
    30.586   375.656     0.150
    30.737   376.859     0.150
    30.867   379.957     0.150
    31.021   380.592     0.150
    31.098   380.307     0.150
    31.278   382.285     0.150
    31.278   555.635     0.150
    31.355   383.553     0.150
    31.345   382.760     0.150
    31.403   383.438     0.150
    31.430   384.293     0.150
    31.695   384.418     0.150
    31.839   385.232     0.150
    31.857   385.938     0.150
    31.977   390.096     0.150
    32.243   390.816     0.150
    32.347   390.799     0.150
    32.378   392.258     0.150
    32.602   393.016     0.150
    32.613   393.746     0.150
    32.622   394.521     0.150
    32.881   395.375     0.150
    33.041   397.725     0.150
    33.210   398.707     0.150
    33.547   401.859     0.150
    33.633   403.039     0.150
    33.836   404.301     0.150
    33.847   404.939     0.150
    33.901   404.795     0.150
    34.014   405.531     0.150
    34.106   407.027     0.150
    34.244   408.043     0.150
    34.491   410.486     0.150
    34.837   413.156     0.150
    35.347   417.543     0.150
    35.469   420.740     0.150
    35.910   423.473     0.150
    36.080   424.732     0.150
    36.428   426.410     0.150
    37.199   434.801     0.150
    37.341   434.885     0.150
    37.722   437.389     0.150
    38.407   444.447     0.150
    38.580   446.539     0.150
    38.645   446.641     0.150
    38.645   444.783     0.150
    39.012   449.439     0.150
    39.012   449.869     0.150
    39.055   449.707     0.150
    40.654   463.240     0.150
    41.335   468.730     0.150
    42.151   475.342     0.150
    42.151   475.949     0.150
    45.746   504.570     0.150
    47.000   514.439     0.150
    47.566   518.959     0.150
    47.566   516.770     0.150
    50.333   538.869     0.150
    56.763   586.439     0.150
    56.826   587.939     0.150
    58.330  1084.141     0.150
    63.433   634.939     0.150
    63.623   634.121     0.150
    65.865   649.240     0.150
    68.045   661.141     0.150
    68.045   660.949     0.150
    73.246   694.039     0.150
    75.666   707.039     0.150
    78.512   723.641     0.150
    78.512   723.715     0.150
    80.038   731.516     0.150
    80.085   734.439     0.150
    82.630   744.590     0.150
    82.630   745.840     0.150
    82.998   751.340     0.150
    82.998   748.490     0.150
    82.998   748.260     0.150
    85.353   758.914     0.150
    85.792   763.141     0.150
    86.250   761.240     0.150
    90.420   786.340     0.150
    90.807   784.439     0.150
    90.807  1003.840     0.150
    92.322   794.439     0.150
    92.554   794.641     0.150
    92.604   798.240     0.150
    92.604   794.379     0.150
    95.885   808.340     0.150
    95.908   810.439     0.150
    96.891   818.240     0.150
    98.456   821.939     0.150
   102.246   840.340     0.150
   102.652   841.340     0.150
   116.565  1129.939     0.150
   116.565  1124.662     0.150
   118.484  1128.289     0.150
   120.315  1133.840     0.150
   145.620  1181.641     0.150
   146.361  1185.439     0.150
     0.509    10.211     0.150
     0.509    17.047     0.150
     0.509     9.953     0.150
     0.510    10.250     0.150
     0.510    17.102     0.150
     0.510    16.578     0.150
     0.585    10.508     0.150
     0.585    18.461     0.150
     0.585    19.227     0.150
     0.877    16.969     0.150
     0.877    29.328     0.150
     1.026    18.867     0.150
     1.026    32.180     0.150
     1.034    19.180     0.150
     1.034    19.062     0.150
     1.034    32.859     0.150
     1.089    20.656     0.150
     1.089    35.062     0.150
     1.089    37.117     0.150
     1.106    21.320     0.150
     1.192    23.578     0.150
     1.205    22.555     0.150
     1.205    38.031     0.150
     1.205    22.406     0.150
     1.240    23.227     0.150
     1.240    39.336     0.150
     1.240    39.961     0.150
     1.305    43.727     0.150
     1.304    44.023     0.150
     1.323    24.250     0.150
     1.323    41.141     0.150
     1.384    25.648     0.150
     1.408    26.656     0.150
     1.408    45.336     0.150
     1.408    44.859     0.150
     1.482    27.953     0.150
     1.495    27.172     0.150
     1.495    27.289     0.150
     1.495    46.156     0.150
     1.542    28.633     0.150
     1.542    48.094     0.150
     1.600    28.922     0.150
     1.600    29.117     0.150
     1.599    50.461     0.150
     1.693    30.453     0.150
     1.693    30.820     0.150
     1.898    33.688     0.150
     1.898    57.656     0.150
     1.898    33.961     0.150
     1.898    58.359     0.150
     1.908    34.602     0.150
     2.128    38.586     0.150
     2.144    39.539     0.150
     2.200    38.656     0.150
     2.203    40.641     0.150
     2.203    68.820     0.150
     2.203    38.383     0.150
     2.331    37.828     0.150
     2.331    66.492     0.150
     2.438    44.109     0.150
     2.488    43.898     0.150
     2.488    75.789     0.150
     3.177    50.633     0.150
     3.917   119.711     0.150
     4.085    63.656     0.150
     4.452    68.477     0.150
     5.246    80.000     0.150
     5.545    84.672     0.150
     5.756    87.703     0.150
     6.628    98.211     0.150
     0.079     3.395     0.150
     0.079     5.305     0.150
     0.079     3.045     0.150
     0.078     2.406     0.150
     0.078     4.195     0.150
     0.078     4.625     0.150
     0.426     8.855     0.150
     0.426    14.605     0.150
     0.665    12.145     0.150
     0.665    20.656     0.150
     1.004    18.256     0.150
     1.004    31.555     0.150
     1.307    24.645     0.150
     1.307    42.346     0.150
     1.533    27.586     0.150
     1.606    28.836     0.150
     1.606    50.346     0.150
     1.647    28.553     0.150
     1.647    51.537     0.150
     1.704    29.916     0.150
     1.704    50.816     0.150
     1.776    31.246     0.150
     1.860    31.113     0.150
     1.974    33.625     0.150
     1.974    60.957     0.150
     1.999    32.723     0.150
     1.999    57.826     0.150
     2.080    36.166     0.150
     2.154    37.195     0.150
     2.285    38.830     0.150
     2.285    68.816     0.150
     2.374    38.201     0.150
     2.374    66.758     0.150
     2.539    40.693     0.150
     2.648    42.250     0.150
     2.648    81.104     0.150
     2.907    87.469     0.150
     2.925    46.430     0.150
     3.251    90.576     0.150
     3.392   103.951     0.150
     3.421   105.682     0.150
     3.651    63.344     0.150
     3.651   110.295     0.150
     3.790    71.012     0.150
     3.790   121.652     0.150
     4.120    62.273     0.150
     4.342    75.668     0.150
     4.336    80.906     0.150
     4.336   139.357     0.150
     4.341    81.678     0.150
     5.231    97.885     0.150
     5.544    83.477     0.150
     5.687    84.621     0.150
     6.216    92.178     0.150
     6.643    97.572     0.150
     0.489    10.105     0.150
     0.489    15.773     0.150
     0.489     9.887     0.150
     0.489    16.766     0.150
     0.490     9.137     0.150
     0.490    15.875     0.150
     0.490    15.484     0.150
     0.599    10.715     0.150
     0.599    19.105     0.150
     0.599    18.754     0.150
     1.007    18.855     0.150
     1.007    31.934     0.150
     1.038    18.875     0.150
     1.038    32.324     0.150
     1.107    20.766     0.150
     1.107    35.336     0.150
     1.223    22.781     0.150
     1.223    38.141     0.150
     1.251    23.547     0.150
     1.251    40.004     0.150
     1.251    41.113     0.150
     1.335    24.504     0.150
     1.335    41.387     0.150
     1.403    26.355     0.150
     1.427    25.652     0.150
     1.427    45.434     0.150
     1.509    27.254     0.150
     1.509    46.305     0.150
     1.558    27.641     0.150
     1.558    48.250     0.150
     1.618    29.625     0.150
     1.618    50.934     0.150
     1.618    28.156     0.150
     1.618    48.906     0.150
     1.922    31.855     0.150
     1.922    54.555     0.150
     1.911    34.312     0.150
     1.911    32.785     0.150
     1.911    58.145     0.150
     2.213    39.379     0.150
     2.213    68.879     0.150
     2.220    39.980     0.150
     2.220    69.098     0.150
     2.220    63.156     0.150
     2.336    37.566     0.150
     2.336    66.605     0.150
     3.193    49.914     0.150
     3.910   105.895     0.150
     4.091    61.184     0.150
     4.091   106.926     0.150
     4.466    68.465     0.150
     4.466   119.023     0.150
     0.377    13.165     0.150
     0.514    10.295     0.150
     0.514    17.176     0.150
     0.514    16.455     0.150
     0.515    10.315     0.150
     0.515    16.976     0.150
     0.515    10.045     0.150
     0.595    10.815     0.150
     0.595    18.995     0.150
     0.699    13.325     0.150
     0.699    22.525     0.150
     0.877    18.346     0.150
     1.039    19.045     0.150
     1.039    32.275     0.150
     1.054    19.825     0.150
     1.093    20.716     0.150
     1.093    35.565     0.150
     1.093    37.556     0.150
     1.210    22.346     0.150
     1.210    38.140     0.150
     1.254    23.535     0.150
     1.254    39.835     0.150
     1.254    41.235     0.150
     1.254    38.545     0.150
     1.336    24.545     0.150
     1.336    41.315     0.150
     1.506    27.096     0.150
     1.548    27.637     0.150
     1.548    48.381     0.150
     1.705    30.565     0.150
     1.705    52.056     0.150
     1.760    31.565     0.150
     1.760    53.955     0.150
     1.894    33.976     0.150
     1.910    33.485     0.150
     1.910    32.800     0.150
     1.910    58.196     0.150
     1.924    34.705     0.150
     2.088    34.513     0.150
     2.135    39.205     0.150
     2.171    38.795     0.150
     2.205    36.495     0.150
     2.205    36.253     0.150
     2.307    37.646     0.150
     2.307    37.155     0.150
     2.307    65.605     0.150
     2.307    37.300     0.150
     2.327    43.437     0.150
     2.471    40.510     0.150
     2.496    44.226     0.150
     2.496    76.376     0.150
     2.498    46.256     0.150
     2.604    42.309     0.150
     2.958    47.479     0.150
     2.958    83.890     0.150
     3.085    48.896     0.150
     3.085    94.462     0.150
     3.157    50.115     0.150
     3.238    56.723     0.150
     3.238    98.191     0.150
     3.370    59.665     0.150
     3.428    56.426     0.150
     3.601   109.212     0.150
     3.772    59.615     0.150
     3.892    61.705     0.150
     3.924   119.513     0.150
     4.061    62.405     0.150
     4.431    68.396     0.150
     4.793    74.945     0.150
     5.227    79.985     0.150
     5.300    80.745     0.150
     5.412    82.485     0.150
     5.507    83.716     0.150
     5.529    83.915     0.150
     5.743    86.855     0.150
     5.869    89.096     0.150
     5.974    90.110     0.150
     6.225    93.926     0.150
     6.605    98.745     0.150
     0.380     7.829     0.150
     0.380    13.239     0.150
     0.504     9.909     0.150
     0.504    16.659     0.150
     0.505     9.949     0.150
     0.505    16.759     0.150
     0.505    16.579     0.150
     0.599    10.469     0.150
     0.599    18.699     0.150
     0.599    18.859     0.150
     0.599    18.579     0.150
     0.690    12.929     0.150
     0.690    21.929     0.150
     0.878    16.509     0.150
     0.878    16.219     0.150
     0.888    17.889     0.150
     0.888    30.219     0.150
     1.028    18.669     0.150
     1.028    31.939     0.150
     1.028    33.479     0.150
     1.078    20.409     0.150
     1.078    35.769     0.150
     1.051    19.499     0.150
     1.051    33.319     0.150
     1.051    33.019     0.150
     1.100    20.439     0.150
     1.100    35.069     0.150
     1.222    23.549     0.150
     1.216    22.129     0.150
     1.216    21.954     0.150
     1.216    37.990     0.150
     1.256    23.249     0.150
     1.256    39.739     0.150
     1.339    24.179     0.150
     1.339    41.179     0.150
     1.391    24.949     0.150
     1.391    43.109     0.150
     1.391    25.709     0.150
     1.493    28.009     0.150
     1.509    26.869     0.150
     1.554    27.699     0.150
     1.554    27.282     0.150
     1.554    47.560     0.150
     1.597    29.229     0.150
     1.597    26.737     0.150
     1.597    46.386     0.150
     1.616    29.299     0.150
     1.708    30.839     0.150
     1.764    31.329     0.150
     1.898    31.259     0.150
     1.898    33.729     0.150
     1.913    33.399     0.150
     1.913    32.786     0.150
     1.913    57.626     0.150
     1.928    34.659     0.150
     2.098    33.953     0.150
     2.155    41.029     0.150
     2.213    37.549     0.150
     2.213    40.750     0.150
     2.315    36.929     0.150
     2.315    64.852     0.150
     2.338    39.129     0.150
     2.480    40.062     0.150
     2.501    75.958     0.150
     2.958    83.994     0.150
     3.087    95.828     0.150
     3.169    49.899     0.150
     3.243    58.080     0.150
     3.243    98.736     0.150
     3.432    53.409     0.150
     3.462   104.529     0.150
     3.548    96.791     0.150
     3.784    59.359     0.150
     3.900    61.419     0.150
     4.069    61.039     0.150
     4.069   108.037     0.150
     4.088   124.569     0.150
     4.442    67.559     0.150
     4.532   138.167     0.150
     4.798    73.199     0.150
     5.238    79.189     0.150
     5.238    79.618     0.150
     5.541    83.909     0.150
     5.881    88.019     0.150
     5.984    89.369     0.150
     6.612    97.639     0.150
     6.612    97.923     0.150
    14.464   201.299     0.150
    14.464   364.259     0.150
     0.386     7.877     0.150
     0.386    13.387     0.150
     0.499     9.946     0.150
     0.499    16.977     0.150
     0.499    15.986     0.150
     0.499     9.967     0.150
     0.499    16.856     0.150
     0.499    15.696     0.150
     0.599    10.656     0.150
     0.599    18.877     0.150
     0.682    13.026     0.150
     0.682    22.007     0.150
     0.885    16.677     0.150
     0.885    29.896     0.150
     0.896    18.406     0.150
     0.896    30.377     0.150
     1.020    18.646     0.150
     1.020    32.007     0.150
     1.046    19.377     0.150
     1.046    33.517     0.150
     1.046    19.687     0.150
     1.103    20.597     0.150
     1.103    35.377     0.150
     1.103    37.287     0.150
     1.219    22.257     0.150
     1.219    38.263     0.150
     1.227    24.337     0.150
     1.254    23.497     0.150
     1.254    39.917     0.150
     1.337    24.486     0.150
     1.337    41.727     0.150
     1.390    25.007     0.150
     1.390    43.446     0.150
     1.495    28.217     0.150
     1.509    27.267     0.150
     1.556    28.937     0.150
     1.556    28.487     0.150
     1.556    48.205     0.150
     1.605    28.566     0.150
     1.614    29.576     0.150
     1.764    32.616     0.150
     1.907    31.656     0.150
     1.887    34.116     0.150
     1.898    34.816     0.150
     1.912    32.997     0.150
     1.912    33.701     0.150
     1.912    57.991     0.150
     2.104    34.556     0.150
     2.215    35.616     0.150
     2.215    69.301     0.150
     2.323    37.467     0.150
     2.323    37.129     0.150
     2.346    39.187     0.150
     2.346    72.245     0.150
     2.502    76.568     0.150
     2.963    83.523     0.150
     3.178    49.387     0.150
     3.244    97.645     0.150
     3.433    54.267     0.150
     3.792    58.517     0.150
     3.903    61.087     0.150
     3.931   119.041     0.150
     3.945   120.781     0.150
     4.077    62.026     0.150
     4.451    68.247     0.150
     4.533   137.949     0.150
     5.247    79.455     0.150
     5.549    84.757     0.150
     5.994    89.747     0.150
     6.620    98.145     0.150
     0.288     6.467     0.150
     0.288    10.627     0.150
     0.443     8.758     0.150
     0.443    14.727     0.150
     0.443     8.918     0.150
     0.443    14.447     0.150
     0.445     8.938     0.150
     0.445     8.668     0.150
     0.445    14.496     0.150
     0.661    12.486     0.150
     0.661    21.467     0.150
     0.765    13.518     0.150
     0.765    23.848     0.150
     0.788    15.268     0.150
     0.788    25.246     0.150
     0.886    16.928     0.150
     0.886    28.957     0.150
     0.886    28.807     0.150
     1.240    22.367     0.150
     1.240    39.217     0.150
     1.240    38.777     0.150
     1.314    24.107     0.150
     1.314    44.127     0.150
     1.323    24.227     0.150
     1.323    41.727     0.150
     1.349    24.107     0.150
     1.349    41.557     0.150
     1.416    26.076     0.150
     1.416    44.287     0.150
     1.416    44.072     0.150
     1.450    46.768     0.150
     1.526    49.697     0.150
     1.570    27.816     0.150
     1.570    27.588     0.150
     1.570    47.637     0.150
     1.588    50.396     0.150
     1.608    28.566     0.150
     1.679    30.258     0.150
     1.701    30.406     0.150
     1.701    30.977     0.150
     1.701    51.996     0.150
     1.706    54.613     0.150
     1.723    30.418     0.150
     1.822    31.598     0.150
     1.822    54.668     0.150
     1.924    33.367     0.150
     1.924    58.326     0.150
     1.954    33.457     0.150
     1.954    58.938     0.150
     1.985    34.236     0.150
     2.037    34.777     0.150
     2.037    64.584     0.150
     2.066    37.707     0.150
     2.252    39.367     0.150
     2.321    41.588     0.150
     2.321    41.387     0.150
     2.332    41.527     0.150
     2.378    42.707     0.150
     2.390    38.896     0.150
     2.390    68.357     0.150
     2.396    43.607     0.150
     2.407    39.656     0.150
     2.407    70.418     0.150
     2.407    43.947     0.150
     2.409    39.598     0.150
     2.409    70.156     0.150
     2.409    43.986     0.150
     2.409    73.678     0.150
     2.419    43.137     0.150
     2.444    39.662     0.150
     2.582    45.627     0.150
     2.586    42.867     0.150
     2.725    49.986     0.150
     2.757    43.668     0.150
     2.757    76.297     0.150
     2.756    44.869     0.150
     2.850    52.227     0.150
     3.475    55.348     0.150
     3.654    56.217     0.150
     4.119    62.977     0.150
     4.512    68.486     0.150
     4.934    74.877     0.150
     5.703    85.668     0.150
     6.007    90.557     0.150
     6.175    92.178     0.150
     0.274     5.865     0.150
     0.274     9.655     0.150
     0.395     8.595     0.150
     0.395    14.495     0.150
     0.508    10.005     0.150
     0.508    16.955     0.150
     0.618    11.655     0.150
     0.618    20.005     0.150
     0.618    20.145     0.150
     0.720    13.255     0.150
     0.720    22.455     0.150
     0.720    12.875     0.150
     0.720    22.665     0.150
     0.732    13.815     0.150
     0.732    23.105     0.150
     0.732    24.065     0.150
     0.809    24.975     0.150
     0.809    14.605     0.150
     0.817    15.330     0.150
     0.817    25.316     0.150
     0.933    28.455     0.150
     0.933    16.595     0.150
     0.958    18.165     0.150
     0.988    17.785     0.150
     0.988    30.195     0.150
     0.988    31.215     0.150
     1.006    18.445     0.150
     1.006    31.385     0.150
     1.006    18.315     0.150
     1.008    18.185     0.150
     1.008    30.905     0.150
     1.008    18.435     0.150
     1.008    31.345     0.150
     1.025    18.345     0.150
     1.025    30.715     0.150
     1.045    18.815     0.150
     1.045    32.605     0.150
     1.063    19.795     0.150
     1.068    19.885     0.150
     1.071    19.387     0.150
     1.071    32.959     0.150
     1.089    20.845     0.150
     1.096    19.435     0.150
     1.096    33.335     0.150
     1.158    21.403     0.150
     1.158    21.505     0.150
     1.158    36.495     0.150
     1.186    35.735     0.150
     1.186    20.685     0.150
     1.285    38.385     0.150
     1.300    22.850     0.150
     1.300    39.239     0.150
     1.300    22.855     0.150
     1.300    39.225     0.150
     1.319    39.675     0.150
     1.441    44.125     0.150
     1.577    27.285     0.150
     1.577    47.035     0.150
     1.614    48.635     0.150
     1.680    28.174     0.150
     1.680    48.010     0.150
     1.680    48.225     0.150
     1.784    30.565     0.150
     1.786    30.490     0.150
     1.786    54.211     0.150
     1.786    31.225     0.150
     1.786    53.605     0.150
     1.928    29.915     0.150
     1.922    32.443     0.150
     1.934    33.745     0.150
     1.950    58.488     0.150
     2.167    35.902     0.150
     2.262    36.395     0.150
     2.262    61.925     0.150
     2.376    38.805     0.150
     2.436    38.730     0.150
     2.436    68.200     0.150
     2.496    75.340     0.150
     2.692    79.948     0.150
     2.886    44.215     0.150
     2.886    77.682     0.150
     2.886    44.565     0.150
     2.886    78.275     0.150
     3.091    46.515     0.150
     3.141    86.240     0.150
     3.389   101.449     0.150
     3.411    52.925     0.150
     3.411    91.235     0.150
     3.788    58.085     0.150
     4.262    64.595     0.150
     4.752    71.695     0.150
     5.612    83.375     0.150
     5.889    87.285     0.150
     0.358     7.266     0.150
     0.358    12.469     0.150
     0.452     8.945     0.150
     0.452    15.359     0.150
     0.452     9.148     0.150
     0.452    15.719     0.150
     0.452    15.594     0.150
     0.649    12.055     0.150
     0.649    20.484     0.150
     0.649    21.477     0.150
     0.928    16.938     0.150
     0.935    18.133     0.150
     0.935    18.695     0.150
     0.935    30.992     0.150
     0.935    32.023     0.150
     1.082    19.734     0.150
     1.082    33.898     0.150
     1.168    20.719     0.150
     1.271    22.656     0.150
     1.271    38.742     0.150
     1.301    23.594     0.150
     1.301    40.172     0.150
     1.470    26.242     0.150
     1.470    46.633     0.150
     1.559    27.453     0.150
     1.559    47.625     0.150
     1.607    27.820     0.150
     1.607    49.055     0.150
     1.642    29.984     0.150
     1.642    51.906     0.150
     1.642    27.555     0.150
     1.682    28.438     0.150
     1.921    31.414     0.150
     1.921    54.742     0.150
     1.961    33.219     0.150
     1.961    33.117     0.150
     1.961    58.789     0.150
     2.151    37.164     0.150
     2.265    37.086     0.150
     2.267    37.625     0.150
     2.267    69.984     0.150
     2.267    37.453     0.150
     2.311    37.469     0.150
     2.535    40.680     0.150
     2.553    44.586     0.150
     2.553    76.820     0.150
     3.015    92.516     0.150
     3.200    50.227     0.150
     3.296    98.898     0.150
     3.483    52.562     0.150
     3.512    54.234     0.150
     3.655   109.539     0.150
     3.828    57.664     0.150
     3.828   100.094     0.150
     3.955    60.945     0.150
     3.982   119.688     0.150
     4.066    62.133     0.150
     4.466    68.227     0.150
     4.851    73.906     0.150
     5.269    79.469     0.150
     5.291    78.984     0.150
     5.800    88.062     0.150
     6.283    95.203     0.150
     6.608    96.969     0.150
     0.366     7.508     0.150
     0.366    12.896     0.150
     0.366    13.367     0.150
     0.356     6.098     0.150
     0.356    11.438     0.150
     0.356    11.027     0.150
     0.356    11.838     0.150
     0.652    12.057     0.150
     0.652    20.688     0.150
     0.860    26.438     0.150
     0.895    16.648     0.150
     0.895    27.727     0.150
     0.895    16.457     0.150
     0.982    17.527     0.150
     0.982    29.938     0.150
     0.984    17.408     0.150
     0.984    30.008     0.150
     0.984    29.588     0.150
     1.010    30.857     0.150
     1.022    18.457     0.150
     1.089    35.857     0.150
     1.135    20.348     0.150
     1.135    34.428     0.150
     1.136    20.938     0.150
     1.137    20.330     0.150
     1.137    34.957     0.150
     1.137    35.117     0.150
     1.148    21.277     0.150
     1.174    22.736     0.150
     1.224    21.197     0.150
     1.234    21.457     0.150
     1.234    37.197     0.150
     1.242    22.830     0.150
     1.242    39.143     0.150
     1.242    39.248     0.150
     1.297    23.998     0.150
     1.297    41.896     0.150
     1.337    23.641     0.150
     1.337    40.197     0.150
     1.337    23.537     0.150
     1.337    23.797     0.150
     1.337    40.418     0.150
     1.365    23.646     0.150
     1.365    41.248     0.150
     1.397    42.217     0.150
     1.510    27.668     0.150
     1.510    46.057     0.150
     1.616    48.807     0.150
     1.620    27.807     0.150
     1.620    47.467     0.150
     1.670    29.117     0.150
     1.670    50.547     0.150
     1.754    33.027     0.150
     1.764    29.932     0.150
     1.764    51.236     0.150
     1.812    32.127     0.150
     1.853    30.877     0.150
     1.854    31.627     0.150
     1.854    56.463     0.150
     1.854    31.018     0.150
     1.999    60.104     0.150
     2.010    32.748     0.150
     2.006    33.809     0.150
     2.178    39.498     0.150
     2.291    36.738     0.150
     2.291    64.916     0.150
     2.333    37.877     0.150
     2.452    38.969     0.150
     2.452    68.750     0.150
     2.557    77.518     0.150
     2.565    42.342     0.150
     2.739    81.219     0.150
     2.904    42.668     0.150
     2.934    45.537     0.150
     3.491    54.617     0.150
     4.830    73.307     0.150
     5.798    87.066     0.150
     5.963    89.457     0.150
     0.284     6.377     0.150
     0.284    10.407     0.150
     0.447     8.407     0.150
     0.447    14.897     0.150
     0.449     8.027     0.150
     0.449    14.387     0.150
     0.449    15.397     0.150
     0.761    13.577     0.150
     0.761    23.768     0.150
     0.665    12.557     0.150
     0.665    21.407     0.150
     0.790    15.438     0.150
     0.790    25.748     0.150
     0.882    15.847     0.150
     0.882    27.647     0.150
     1.236    22.387     0.150
     1.236    38.237     0.150
     1.311    24.377     0.150
     1.311    41.367     0.150
     1.311    42.447     0.150
     1.311    44.268     0.150
     1.412    26.103     0.150
     1.412    43.896     0.150
     1.703    31.369     0.150
     1.703    53.910     0.150
     1.697    30.393     0.150
     1.697    52.008     0.150
     1.920    33.438     0.150
     1.920    57.764     0.150
     2.035    33.980     0.150
     2.035    64.397     0.150
     2.405    39.963     0.150
     2.405    43.288     0.150
     2.405    73.581     0.150
     3.077    51.607     0.150
     2.582    44.541     0.150
     2.582    76.817     0.150
     2.752    45.081     0.150
     2.752    50.873     0.150
     2.752    85.757     0.150
     2.758    43.776     0.150
     2.983    48.289     0.150
     3.009    83.149     0.150
     3.125    95.720     0.150
     3.323   100.041     0.150
     3.541    56.491     0.150
     3.541   111.823     0.150
     3.594    67.291     0.150
     3.594   113.290     0.150
     3.621   110.491     0.150
     3.732   115.237     0.150
     4.020   120.893     0.150
     4.115   128.148     0.150
     4.100   112.096     0.150
     4.183   131.297     0.150
     4.572   139.441     0.150
     4.655   144.817     0.150
     4.894   148.820     0.150
     4.976   153.732     0.150
     5.721    87.351     0.150
     7.431   236.639     0.150
    12.576   183.476     0.150
     0.266     4.900     0.150
     0.266     8.959     0.150
     0.266     9.301     0.150
     0.377     7.619     0.150
     0.377    12.740     0.150
     0.438     9.029     0.150
     0.438     9.090     0.150
     0.438    15.600     0.150
     0.438    15.420     0.150
     0.438    15.279     0.150
     0.668    12.641     0.150
     0.668    21.520     0.150
     0.890    17.580     0.150
     0.890    30.080     0.150
     0.963    16.820     0.150
     0.963    29.660     0.150
     0.944    17.609     0.150
     0.944    30.750     0.150
     0.953    17.539     0.150
     0.953    31.070     0.150
     0.953    31.430     0.150
     1.070    19.580     0.150
     1.070    33.490     0.150
     1.070    19.459     0.150
     1.159    21.350     0.150
     1.159    35.910     0.150
     1.145    37.740     0.150
     1.178    36.609     0.150
     1.216    37.811     0.150
     1.275    22.930     0.150
     1.275    39.180     0.150
     1.295    23.391     0.150
     1.295    40.150     0.150
     1.295    23.600     0.150
     1.287    41.430     0.150
     1.381    24.410     0.150
     1.381    41.939     0.150
     1.438    25.590     0.150
     1.438    43.721     0.150
     1.557    27.420     0.150
     1.557    27.141     0.150
     1.557    46.500     0.150
     1.610    27.949     0.150
     1.610    29.270     0.150
     1.657    28.891     0.150
     1.753    30.529     0.150
     1.753    52.840     0.150
     1.753    52.660     0.150
     1.812    31.039     0.150
     1.812    54.561     0.150
     1.812    31.311     0.150
     1.946    32.631     0.150
     1.946    58.699     0.150
     1.958    33.939     0.150
     1.977    33.070     0.150
     2.221    38.770     0.150
     2.271    40.590     0.150
     2.273    40.590     0.150
     2.332    36.900     0.150
     3.222    50.439     0.150
     3.482    54.109     0.150
     3.510    55.180     0.150
     5.819    88.010     0.150
     0.238     4.648     0.150
     0.238     7.968     0.150
     0.238     8.898     0.150
     0.530    10.099     0.150
     0.530    17.188     0.150
     0.531    10.888     0.150
     0.531    18.438     0.150
     0.532     9.898     0.150
     0.532    17.288     0.150
     0.532    17.458     0.150
     0.610    11.809     0.150
     0.856    16.698     0.150
     0.856    29.218     0.150
     0.884    17.048     0.150
     0.884    30.229     0.150
     0.903    18.168     0.150
     0.903    31.948     0.150
     0.959    17.828     0.150
     0.959    30.908     0.150
     0.959    17.948     0.150
     0.981    18.568     0.150
     1.016    18.059     0.150
     1.016    32.358     0.150
     1.069    20.648     0.150
     1.069    35.708     0.150
     1.069    20.958     0.150
     1.085    19.568     0.150
     1.085    34.388     0.150
     1.113    20.229     0.150
     1.113    34.428     0.150
     1.165    21.334     0.150
     1.165    35.717     0.150
     1.195    22.188     0.150
     1.195    39.008     0.150
     1.241    23.508     0.150
     1.241    40.519     0.150
     1.261    22.898     0.150
     1.261    38.868     0.150
     1.278    42.118     0.150
     1.298    24.338     0.150
     1.298    42.538     0.150
     1.318    23.849     0.150
     1.318    40.729     0.150
     1.354    24.828     0.150
     1.354    42.738     0.150
     1.353    23.688     0.150
     1.385    25.213     0.150
     1.385    44.407     0.150
     1.385    24.998     0.150
     1.438    25.599     0.150
     1.438    44.238     0.150
     1.441    26.248     0.150
     1.496    26.729     0.150
     1.496    45.813     0.150
     1.496    45.698     0.150
     1.496    46.349     0.150
     1.537    27.508     0.150
     1.537    46.908     0.150
     1.556    28.368     0.150
     1.558    29.338     0.150
     1.633    28.888     0.150
     1.633    49.408     0.150
     1.617    27.879     0.150
     1.617    50.011     0.150
     1.617    50.188     0.150
     1.715    31.528     0.150
     1.828    32.128     0.150
     1.838    32.290     0.150
     1.838    55.237     0.150
     1.838    32.688     0.150
     1.859    32.868     0.150
     1.856    33.498     0.150
     2.079    36.898     0.150
     2.086    33.976     0.150
     2.102    36.849     0.150
     2.103    38.398     0.150
     2.103    37.238     0.150
     2.122    38.729     0.150
     2.166    36.403     0.150
     2.166    67.009     0.150
     2.178    40.178     0.150
     2.214    40.008     0.150
     2.437    42.360     0.150
     2.437    73.195     0.150
     2.402    38.058     0.150
     2.402    66.837     0.150
     2.402    66.479     0.150
     2.445    43.559     0.150
     2.451    39.522     0.150
     2.465    45.309     0.150
     2.910    89.065     0.150
     3.005    83.526     0.150
     3.180    94.891     0.150
     3.210    61.428     0.150
     3.364    53.378     0.150
     3.860    60.338     0.150
     3.869   117.934     0.150
     4.156    63.298     0.150
     5.285    80.273     0.150
     5.285    80.428     0.150
     5.900    88.958     0.150
     6.048    90.918     0.150
     6.048    90.788     0.150
     6.700    99.360     0.150
     0.402     8.180     0.150
     0.402    13.449     0.150
     0.402    14.090     0.150
     0.408     8.480     0.150
     0.408    14.289     0.150
     0.408     8.191     0.150
     0.408    14.129     0.150
     0.408     7.531     0.150
     0.408    13.070     0.150
     0.783    13.770     0.150
     0.783    24.070     0.150
     0.806    15.031     0.150
     0.890    18.141     0.150
     0.890    31.281     0.150
     0.981    18.160     0.150
     0.981    30.922     0.150
     0.975    19.621     0.150
     0.975    34.531     0.150
     0.980    18.492     0.150
     0.980    32.859     0.150
     1.198    39.500     0.150
     1.227    22.230     0.150
     1.227    38.281     0.150
     1.260    23.891     0.150
     1.260    40.070     0.150
     1.295    22.719     0.150
     1.367    26.141     0.150
     1.367    44.699     0.150
     1.386    43.500     0.150
     1.427    27.520     0.150
     1.427    47.410     0.150
     1.434    47.629     0.150
     1.454    27.539     0.150
     1.561    49.758     0.150
     1.591    26.309     0.150
     1.662    30.922     0.150
     1.693    29.641     0.150
     1.693    52.020     0.150
     1.665    27.965     0.150
     1.665    52.309     0.150
     1.665    53.102     0.150
     1.729    53.527     0.150
     1.729    31.770     0.150
     1.729    53.082     0.150
     1.802    32.789     0.150
     1.824    32.379     0.150
     1.894    34.082     0.150
     1.871    31.070     0.150
     1.924    35.301     0.150
     2.052    37.781     0.150
     2.080    63.672     0.150
     2.089    38.059     0.150
     2.089    64.641     0.150
     2.098    37.207     0.150
     2.098    63.508     0.150
     2.217    35.867     0.150
     2.198    35.773     0.150
     2.317    41.520     0.150
     2.324    42.129     0.150
     2.324    42.262     0.150
     2.347    43.070     0.150
     2.373    44.871     0.150
     2.376    73.844     0.150
     2.376    39.309     0.150
     2.623    47.941     0.150
     2.631    48.301     0.150
     2.680    81.633     0.150
     3.027    94.453     0.150
     3.168    49.832     0.150
     3.614    57.730     0.150
     3.644    58.352     0.150
     3.644    63.020     0.150
     3.846    60.422     0.150
     3.994    61.211     0.150
     4.053    76.160     0.150
     4.271    64.520     0.150
     4.412    67.750     0.150
     4.973    75.250     0.150
     5.060    77.770     0.150
     5.161    78.449     0.150
     5.237    80.082     0.150
     5.579    85.152     0.150
     5.822    87.930     0.150
     5.939    90.270     0.150
     5.961    90.160     0.150
     5.944    89.922     0.150
     6.311    95.371     0.150
     6.415    96.719     0.150
     6.492    96.520     0.150
     6.600    99.492     0.150
     7.077   103.820     0.150
     7.183   104.559     0.150
     8.482   124.121     0.150
     8.596   125.289     0.150
     8.607   125.969     0.150
     8.632   126.270     0.150
     8.636   125.082     0.150
     8.703   127.371     0.150
     8.879   131.270     0.150
     0.309     5.055     0.150
     0.309     9.102     0.150
     0.416     8.234     0.150
     0.416    14.398     0.150
     0.625    11.977     0.150
     0.625    20.281     0.150
     0.693    13.078     0.150
     0.693    24.344     0.150
     0.716    14.906     0.150
     0.772    14.695     0.150
     0.772    25.156     0.150
     0.772    14.398     0.150
     0.772    24.945     0.150
     0.773    14.703     0.150
     0.773    25.312     0.150
     0.843    15.773     0.150
     0.843    27.031     0.150
     0.849    15.656     0.150
     0.849    27.406     0.150
     0.853    15.977     0.150
     0.853    28.406     0.150
     0.872    15.719     0.150
     0.872    27.273     0.150
     0.925    16.859     0.150
     0.925    28.664     0.150
     0.959    17.266     0.150
     0.959    31.906     0.150
     0.983    18.164     0.150
     0.983    31.086     0.150
     0.983    31.266     0.150
     1.022    19.312     0.150
     1.022    34.398     0.150
     1.058    18.883     0.150
     1.058    32.344     0.150
     1.050    19.047     0.150
     1.079    20.367     0.150
     1.079    36.242     0.150
     1.113    20.016     0.150
     1.113    35.117     0.150
     1.148    21.047     0.150
     1.148    36.391     0.150
     1.148    20.438     0.150
     1.148    36.523     0.150
     1.160    22.125     0.150
     1.201    22.234     0.150
     1.231    22.094     0.150
     1.231    38.047     0.150
     1.218    21.594     0.150
     1.218    37.086     0.150
     1.260    22.906     0.150
     1.260    38.609     0.150
     1.334    23.492     0.150
     1.334    40.852     0.150
     1.311    22.312     0.150
     1.367    24.703     0.150
     1.422    24.828     0.150
     1.422    42.953     0.150
     1.422    24.945     0.150
     1.441    24.844     0.150
     1.441    26.336     0.150
     1.473    27.195     0.150
     1.473    46.836     0.150
     1.593    29.172     0.150
     1.605    28.336     0.150
     1.605    48.648     0.150
     1.626    28.219     0.150
     1.626    48.977     0.150
     1.626    28.734     0.150
     1.620    29.586     0.150
     1.620    49.992     0.150
     1.636    28.867     0.150
     1.636    49.594     0.150
     1.845    32.836     0.150
     1.863    33.945     0.150
     1.884    33.062     0.150
     1.884    56.562     0.150
     1.904    30.094     0.150
     1.923    34.992     0.150
     1.925    32.078     0.150
     1.925    59.391     0.150
     1.925    31.602     0.150
     1.976    36.273     0.150
     2.156    36.188     0.150
     2.206    66.633     0.150
     2.223    40.938     0.150
     2.442    38.383     0.150
     2.442    66.758     0.150
     2.442    38.031     0.150
     2.442    67.156     0.150
     2.670    48.898     0.150
     3.099    47.984     0.150
     3.139    49.258     0.150
     3.619    57.016     0.150
     3.616    57.672     0.150
     4.184    64.484     0.150
     4.410    67.234     0.150
     4.504    67.703     0.150
     5.520    82.734     0.150
     6.046    90.258     0.150
     6.458    95.102     0.150
     6.731    98.945     0.150
     6.922   103.008     0.150
     0.195     4.508     0.150
     0.195     7.338     0.150
     0.195     8.118     0.150
     0.495     9.498     0.150
     0.495    16.598     0.150
     0.505    10.248     0.150
     0.505    17.338     0.150
     0.505    17.048     0.150
     0.507    10.258     0.150
     0.507    17.328     0.150
     0.544    10.758     0.150
     0.544    18.398     0.150
     0.572    10.758     0.150
     0.572    18.048     0.150
     0.899    17.568     0.150
     0.899    30.688     0.150
     0.899    17.948     0.150
     0.923    18.048     0.150
     0.923    31.008     0.150
     0.944    17.468     0.150
     0.944    19.058     0.150
     0.944    31.558     0.150
     0.944    18.678     0.150
     0.978    17.848     0.150
     0.978    30.418     0.150
     1.022    19.328     0.150
     1.106    20.788     0.150
     1.106    35.728     0.150
     1.106    20.958     0.150
     1.116    20.598     0.150
     1.116    35.608     0.150
     1.139    21.118     0.150
     1.139    36.138     0.150
     1.175    37.158     0.150
     1.175    21.928     0.150
     1.175    21.618     0.150
     1.186    21.598     0.150
     1.186    37.047     0.150
     1.186    22.238     0.150
     1.186    37.328     0.150
     1.225    22.398     0.150
     1.225    41.008     0.150
     1.264    23.018     0.150
     1.264    39.188     0.150
     1.277    23.448     0.150
     1.277    40.878     0.150
     1.316    41.948     0.150
     1.326    24.128     0.150
     1.326    41.418     0.150
     1.320    23.618     0.150
     1.334    24.218     0.150
     1.380    43.518     0.150
     1.371    24.008     0.150
     1.393    24.568     0.150
     1.415    24.774     0.150
     1.415    45.120     0.150
     1.415    45.628     0.150
     1.427    46.258     0.150
     1.447    26.138     0.150
     1.447    44.908     0.150
     1.461    26.508     0.150
     1.501    26.428     0.150
     1.513    27.381     0.150
     1.513    47.285     0.150
     1.540    27.898     0.150
     1.540    47.268     0.150
     1.537    26.288     0.150
     1.555    28.198     0.150
     1.555    48.438     0.150
     1.555    27.958     0.150
     1.638    29.108     0.150
     1.638    50.078     0.150
     1.658    28.222     0.150
     1.658    52.784     0.150
     1.658    52.498     0.150
     1.768    30.058     0.150
     1.837    32.618     0.150
     1.843    31.067     0.150
     1.843    55.812     0.150
     1.843    31.778     0.150
     1.843    33.288     0.150
     1.854    31.358     0.150
     1.868    33.658     0.150
     1.863    30.988     0.150
     1.872    32.838     0.150
     1.850    30.438     0.150
     1.850    30.278     0.150
     2.094    35.318     0.150
     2.094    37.838     0.150
     2.122    35.298     0.150
     2.122    39.458     0.150
     2.122    35.178     0.150
     2.121    35.178     0.150
     2.141    35.668     0.150
     2.141    39.598     0.150
     2.138    35.228     0.150
     2.148    35.238     0.150
     2.169    35.768     0.150
     2.178    36.208     0.150
     2.178    40.648     0.150
     2.181    39.503     0.150
     2.181    67.308     0.150
     2.182    35.798     0.150
     2.186    36.038     0.150
     2.186    40.608     0.150
     2.188    36.109     0.150
     2.188    40.784     0.150
     2.188    68.453     0.150
     2.188    35.891     0.150
     2.188    68.050     0.150
     2.188    35.708     0.150
     2.188    40.478     0.150
     2.197    36.688     0.150
     2.202    36.018     0.150
     2.202    40.938     0.150
     2.233    36.938     0.150
     2.233    41.148     0.150
     2.392    39.098     0.150
     2.398    39.318     0.150
     2.410    39.458     0.150
     2.412    39.378     0.150
     2.449    40.135     0.150
     2.449    74.386     0.150
     2.449    40.298     0.150
     2.449    43.228     0.150
     2.435    39.073     0.150
     2.435    38.938     0.150
     2.435    69.068     0.150
     2.461    44.498     0.150
     2.480    40.502     0.150
     2.480    40.698     0.150
     2.599    42.528     0.150
     2.599    46.528     0.150
     2.609    42.298     0.150
     2.648    42.894     0.150
     2.821    45.658     0.150
     2.864    45.046     0.150
     2.864    80.721     0.150
     2.931    47.333     0.150
     2.931    47.508     0.150
     2.953    47.928     0.150
     3.031    48.388     0.150
     3.098    49.828     0.150
     3.194    50.574     0.150
     3.242    51.404     0.150
     3.334    52.938     0.150
     3.340    52.880     0.150
     3.374    53.478     0.150
     3.399    53.418     0.150
     3.525    55.121     0.150
     3.541    55.447     0.150
     3.541   106.557     0.150
     3.714    56.555     0.150
     3.714   102.367     0.150
     3.714    56.338     0.150
     3.843    60.818     0.150
     3.883    60.511     0.150
     3.883   117.675     0.150
     3.885    60.540     0.150
     3.885    60.028     0.150
     4.025    61.826     0.150
     4.025   121.007     0.150
     4.025    62.668     0.150
     4.175    63.885     0.150
     4.189    63.308     0.150
     4.189    63.148     0.150
     4.294    65.719     0.150
     4.294   130.596     0.150
     4.388    67.286     0.150
     4.475    68.832     0.150
     4.494    68.994     0.150
     4.544    69.838     0.150
     4.754    72.483     0.150
     4.772    72.826     0.150
     4.759    72.528     0.150
     4.759   124.268     0.150
     4.759   141.128     0.150
     4.848    74.071     0.150
     4.975    76.758     0.150
     5.027    76.316     0.150
     5.133    77.108     0.150
     5.133    80.348     0.150
     5.173    78.611     0.150
     5.249    79.447     0.150
     5.249   140.568     0.150
     5.301    80.043     0.150
     5.328    81.350     0.150
     5.328   142.412     0.150
     5.328    81.838     0.150
     5.343    80.118     0.150
     5.426    82.866     0.150
     5.425    81.528     0.150
     5.613    86.328     0.150
     5.636    85.772     0.150
     5.626    84.628     0.150
     5.691    87.118     0.150
     5.704    85.866     0.150
     5.809    88.148     0.150
     5.878    89.158     0.150
     5.913    88.090     0.150
     5.941    90.698     0.150
     6.090    91.952     0.150
     6.286    95.498     0.150
     6.350    95.778     0.150
     6.399    97.068     0.150
     6.500    99.198     0.150
     6.632    97.053     0.150
     6.657    99.088     0.150
     6.733    99.738     0.150
     6.733    99.608     0.150
     6.800   101.864     0.150
     7.082   107.858     0.150
     7.105   104.588     0.150
     7.106   107.348     0.150
     7.133   106.668     0.150
     7.188   107.498     0.150
     7.222   108.409     0.150
     7.222   228.594     0.150
     7.222   108.258     0.150
     7.465   112.278     0.150
     7.496   113.128     0.150
     7.515   113.398     0.150
     7.525   113.378     0.150
     7.574   112.248     0.150
     7.739   111.228     0.150
     7.754   113.930     0.150
     8.009   116.938     0.150
     8.170   121.338     0.150
     8.400   122.879     0.150
     8.400   265.162     0.150
     8.400   123.051     0.150
     8.450   127.978     0.150
     8.542   127.468     0.150
     8.632   128.338     0.150
     8.675   129.988     0.150
     8.706   129.908     0.150
     8.736   130.558     0.150
     8.739   127.880     0.150
     8.739   127.458     0.150
     8.772   129.527     0.150
     8.772   279.687     0.150
     8.865   132.528     0.150
     8.884   133.448     0.150
     8.939   131.381     0.150
     8.939   133.598     0.150
     8.955   134.018     0.150
     8.955   133.828     0.150
     8.972   133.778     0.150
     9.063   135.768     0.150
     9.198   135.408     0.150
     9.198   291.893     0.150
     9.198   135.218     0.150
     9.322   138.658     0.150
     9.384   137.198     0.150
     9.533   139.854     0.150
     9.604   142.208     0.150
     9.602   140.438     0.150
     9.658   143.788     0.150
     9.661   144.108     0.150
     9.832   145.778     0.150
    10.014   146.588     0.150
    10.071   146.740     0.150
    10.085   149.308     0.150
    10.150   151.088     0.150
    10.261   150.948     0.150
    10.387   151.523     0.150
    10.387   151.808     0.150
    10.391   152.668     0.150
    10.464   153.577     0.150
    10.464   155.198     0.150
    10.478   153.828     0.150
    10.553   153.658     0.150
    10.553   153.308     0.150
    10.554   153.433     0.150
    10.554   331.573     0.150
    10.824   157.806     0.150
    11.093   161.392     0.150
    11.093   162.368     0.150
    11.142   164.438     0.150
    11.583   168.440     0.150
    11.583   169.418     0.150
    11.655   172.719     0.150
    11.655   363.225     0.150
    11.655   172.048     0.150
    11.775   172.898     0.150
    11.862   174.528     0.150
    11.923   172.764     0.150
    11.986   176.198     0.150
    12.046   174.822     0.150
    12.148   175.256     0.150
    12.148   176.798     0.150
    12.173   175.706     0.150
    12.207   177.336     0.150
    12.207   178.558     0.150
    12.208   178.128     0.150
    12.208   177.808     0.150
    12.208   178.638     0.150
    12.371   176.303     0.150
    12.399   181.418     0.150
    12.499   183.328     0.150
    12.517   183.028     0.150
    12.695   184.678     0.150
    12.721   185.668     0.150
    12.789   186.608     0.150
    12.847   183.195     0.150
    12.894   190.258     0.150
    12.936   190.368     0.150
    12.971   188.708     0.150
    13.115   191.498     0.150
    13.252   190.519     0.150
    13.252   191.318     0.150
    13.345   189.875     0.150
    13.359   189.832     0.150
    13.363   193.708     0.150
    13.439   191.307     0.150
    13.439   195.638     0.150
    13.450   197.668     0.150
    13.549   194.740     0.150
    13.614   199.008     0.150
    13.600   195.236     0.150
    13.600   195.628     0.150
    13.616   196.036     0.150
    13.616   196.418     0.150
    13.641   198.538     0.150
    13.677   199.568     0.150
    13.720   200.708     0.150
    13.744   200.338     0.150
    13.752   200.318     0.150
    13.865   202.298     0.150
    14.100   205.438     0.150
    14.152   206.208     0.150
    14.383   207.175     0.150
    14.383   209.908     0.150
    14.390   206.622     0.150
    14.448   206.940     0.150
    14.435   204.180     0.150
    14.472   209.948     0.150
    14.479   210.398     0.150
    14.473   206.081     0.150
    14.473   206.548     0.150
    14.527   210.798     0.150
    14.617   209.998     0.150
    14.724   217.848     0.150
    14.876   212.333     0.150
    14.876   215.578     0.150
    14.970   217.188     0.150
    15.085   217.458     0.150
    15.142   218.358     0.150
    15.170   217.668     0.150
    15.330   216.626     0.150
    15.330   220.818     0.150
    15.355   221.718     0.150
    15.437   222.468     0.150
    15.443   219.898     0.150
    15.465   219.418     0.150
    15.467   219.073     0.150
    15.467   219.308     0.150
    15.468   218.818     0.150
    15.468   219.458     0.150
    15.514   220.828     0.150
    15.527   218.443     0.150
    15.527   220.598     0.150
    15.566   221.268     0.150
    15.571   221.608     0.150
    15.621   221.018     0.150
    15.637   223.478     0.150
    15.638   223.778     0.150
    15.652   221.798     0.150
    15.669   222.978     0.150
    15.681   222.978     0.150
    15.708   224.088     0.150
    15.714   223.628     0.150
    15.770   224.108     0.150
    15.781   224.648     0.150
    15.930   224.919     0.150
    15.961   226.798     0.150
    16.174   232.898     0.150
    16.195   234.128     0.150
    16.225   232.188     0.150
    16.234   230.258     0.150
    16.274   230.418     0.150
    16.372   232.748     0.150
    16.379   232.728     0.150
    16.559   231.683     0.150
    16.689   236.158     0.150
    16.749   238.452     0.150
    16.749   527.647     0.150
    16.749   236.667     0.150
    16.749   238.098     0.150
    16.780   236.686     0.150
    16.780   238.168     0.150
    16.864   238.248     0.150
    16.971   237.507     0.150
    17.039   241.708     0.150
    17.068   239.650     0.150
    17.068   243.158     0.150
    17.065   240.362     0.150
    17.065   240.038     0.150
    17.092   240.828     0.150
    17.139   239.733     0.150
    17.139   242.538     0.150
    17.241   241.811     0.150
    17.241   243.118     0.150
    17.250   242.948     0.150
    17.395   245.498     0.150
    17.519   247.068     0.150
    17.554   248.328     0.150
    17.855   250.778     0.150
    17.985   250.166     0.150
    18.273   255.378     0.150
    18.360   256.664     0.150
    18.360   257.558     0.150
    18.572   258.068     0.150
    18.588   259.408     0.150
    18.601   258.304     0.150
    18.601   259.428     0.150
    18.604   259.308     0.150
    18.725   260.209     0.150
    18.725   260.798     0.150
    18.926   264.468     0.150
    19.011   263.619     0.150
    19.086   264.898     0.150
    19.221   267.378     0.150
    19.313   267.642     0.150
    19.313   267.328     0.150
    19.335   267.432     0.150
    19.335   268.198     0.150
    19.339   267.228     0.150
    19.347   266.191     0.150
    19.483   267.095     0.150
    19.668   271.688     0.150
    19.829   272.158     0.150
    19.854   272.824     0.150
    19.877   274.698     0.150
    20.015   274.478     0.150
    20.065   276.028     0.150
    20.203   278.378     0.150
    20.259   278.658     0.150
    20.366   277.489     0.150
    20.366   280.488     0.150
    20.544   281.808     0.150
    20.679   282.948     0.150
    20.705   282.328     0.150
    20.742   282.508     0.150
    20.815   282.888     0.150
    20.948   285.229     0.150
    20.976   284.768     0.150
    21.023   284.700     0.150
    21.023   285.268     0.150
    21.130   286.348     0.150
    21.221   289.418     0.150
    21.275   288.678     0.150
    21.325   289.852     0.150
    21.325   289.678     0.150
    21.461   290.808     0.150
    21.472   290.538     0.150
    21.646   292.108     0.150
    21.947   295.618     0.150
    22.057   298.818     0.150
    22.163   298.262     0.150
    22.163   297.658     0.150
    22.230   298.368     0.150
    22.312   300.758     0.150
    22.304   300.598     0.150
    22.359   300.168     0.150
    22.418   299.753     0.150
    22.418   300.898     0.150
    22.481   300.774     0.150
    22.481   301.388     0.150
    22.523   301.918     0.150
    22.550   301.148     0.150
    22.571   302.083     0.150
    22.663   303.108     0.150
    22.897   304.878     0.150
    23.050   306.768     0.150
    23.093   306.398     0.150
    23.093   308.928     0.150
    23.191   308.828     0.150
    23.216   309.078     0.150
    23.266   309.208     0.150
    23.313   310.138     0.150
    23.504   312.395     0.150
    23.504   312.568     0.150
    23.568   311.768     0.150
    23.625   313.958     0.150
    23.689   314.020     0.150
    23.799   314.479     0.150
    23.799   750.308     0.150
    23.799   315.678     0.150
    23.866   315.468     0.150
    24.065   316.858     0.150
    24.116   316.938     0.150
    24.144   318.198     0.150
    24.222   317.010     0.150
    24.222   319.338     0.150
    24.305   319.958     0.150
    24.382   319.485     0.150
    24.382   321.078     0.150
    24.640   322.507     0.150
    24.640   323.718     0.150
    24.661   322.908     0.150
    24.715   323.538     0.150
    24.858   324.798     0.150
    24.908   323.422     0.150
    24.908   325.008     0.150
    24.938   325.718     0.150
    25.025   324.928     0.150
    25.100   326.348     0.150
    25.139   327.258     0.150
    25.177   328.328     0.150
    25.298   328.428     0.150
    25.532   329.978     0.150
    25.725   332.588     0.150
    25.793   333.908     0.150
    25.919   332.768     0.150
    25.957   334.108     0.150
    26.135   337.868     0.150
    26.165   335.848     0.150
    26.177   336.238     0.150
    26.315   337.068     0.150
    26.612   340.468     0.150
    26.668   341.108     0.150
    26.683   340.808     0.150
    26.770   340.598     0.150
    26.785   846.652     0.150
    26.785   340.878     0.150
    26.929   342.748     0.150
    26.974   343.685     0.150
    27.142   344.712     0.150
    27.290   345.988     0.150
    27.488   348.198     0.150
    27.560   348.838     0.150
    27.568   348.628     0.150
    27.714   350.508     0.150
    28.082   353.088     0.150
    28.290   352.901     0.150
    28.290   355.208     0.150
    28.366   353.954     0.150
    28.413   357.178     0.150
    28.638   358.533     0.150
    28.638   359.868     0.150
    28.690   357.399     0.150
    28.792   358.398     0.150
    28.863   360.178     0.150
    28.904   360.118     0.150
    29.068   358.911     0.150
    29.125   362.208     0.150
    29.473   367.238     0.150
    29.493   362.691     0.150
    29.527   365.778     0.150
    29.617   366.848     0.150
    30.378   374.308     0.150
    30.895   378.898     0.150
    30.980   378.831     0.150
    30.980   554.333     0.150
    31.339   380.746     0.150
    32.017   388.898     0.150
    32.488   389.908     0.150
    33.264   396.988     0.150
    38.257   442.370     0.150
    38.257   442.098     0.150
    38.459   444.178     0.150
    38.459   444.508     0.150
    38.459   444.328     0.150
    38.975   448.788     0.150
    39.002   448.608     0.150
    39.292   452.178     0.150
    39.778   455.578     0.150
    40.690   462.748     0.150
    41.427   468.248     0.150
    41.947   473.558     0.150
    46.960   514.008     0.150
    47.423   516.668     0.150
    55.943   581.678     0.150
    56.402   583.008     0.150
    58.713  1084.908     0.150
    61.146   614.708     0.150
    61.637   620.178     0.150
    63.307   630.459     0.150
    63.572   632.258     0.150
    65.124   641.895     0.150
    65.857   647.658     0.150
    66.986   655.648     0.150
    68.012   662.638     0.150
    68.475   663.718     0.150
    70.294  5274.557     0.150
    77.997   719.264     0.150
    79.986   731.185     0.150
    80.031   731.032     0.150
    82.276   743.524     0.150
    82.276   743.738     0.150
    84.972   757.270     0.150
    85.727   762.708     0.150
    86.565   763.908     0.150
    92.427   793.437     0.150
    92.454   795.128     0.150
    93.048   797.130     0.150
    95.803   809.108     0.150
   102.039   837.908     0.150
   107.532   858.208     0.150
   116.850  1125.481     0.150
   118.785  1129.589     0.150
   118.933  1130.928     0.150
   146.143  1182.233     0.150
   146.143  1182.398     0.150
     0.180     4.230     0.150
     0.180     7.070     0.150
     0.496     9.990     0.150
     0.496    16.660     0.150
     0.496     9.852     0.150
     0.496    17.090     0.150
     0.502     9.420     0.150
     0.502    16.170     0.150
     0.497    10.000     0.150
     0.497    16.961     0.150
     0.497    17.590     0.150
     0.550    10.660     0.150
     0.550    18.000     0.150
     0.560    10.441     0.150
     0.560    17.650     0.150
     0.914    17.551     0.150
     0.914    30.811     0.150
     0.941    17.121     0.150
     0.941    29.150     0.150
     0.941    16.990     0.150
     0.941    29.670     0.150
     0.938    18.811     0.150
     0.959    19.730     0.150
     0.959    34.131     0.150
     0.964    17.541     0.150
     0.964    30.352     0.150
     1.119    36.111     0.150
     1.119    22.160     0.150
     1.127    20.830     0.150
     1.127    35.791     0.150
     1.149    21.031     0.150
     1.149    36.160     0.150
     1.177    21.670     0.150
     1.177    36.811     0.150
     1.177    21.441     0.150
     1.177    36.941     0.150
     1.195    22.145     0.150
     1.195    37.355     0.150
     1.237    23.041     0.150
     1.267    22.830     0.150
     1.267    38.951     0.150
     1.267    39.182     0.150
     1.331    23.861     0.150
     1.331    40.980     0.150
     1.335    23.510     0.150
     1.391    25.471     0.150
     1.386    23.920     0.150
     1.427    24.908     0.150
     1.427    45.961     0.150
     1.452    25.961     0.150
     1.452    44.750     0.150
     1.470    26.500     0.150
     1.521    27.473     0.150
     1.521    46.723     0.150
     1.521    27.361     0.150
     1.521    46.961     0.150
     1.521    27.670     0.150
     1.543    46.932     0.150
     1.543    27.541     0.150
     1.556    27.871     0.150
     1.641    29.090     0.150
     1.641    49.932     0.150
     1.641    50.561     0.150
     1.673    28.109     0.150
     1.842    32.352     0.150
     1.842    56.102     0.150
     1.847    32.137     0.150
     1.847    55.762     0.150
     1.847    32.182     0.150
     1.847    55.771     0.150
     1.863    34.250     0.150
     1.873    32.852     0.150
     1.873    56.951     0.150
     1.879    32.141     0.150
     1.859    30.182     0.150
     2.100    37.021     0.150
     2.114    36.900     0.150
     2.131    39.080     0.150
     2.131    38.920     0.150
     2.134    35.037     0.150
     2.149    39.182     0.150
     2.187    40.291     0.150
     2.196    41.260     0.150
     2.197    35.990     0.150
     2.206    40.971     0.150
     2.211    40.781     0.150
     2.241    40.730     0.150
     2.456    42.473     0.150
     2.468    44.170     0.150
     2.446    39.045     0.150
     2.446    68.168     0.150
     3.379    53.910     0.150
     3.404    51.102     0.150
     3.822    66.830     0.150
     3.858    61.051     0.150
     4.200    63.590     0.150
     4.558    69.941     0.150
     4.804    77.852     0.150
     5.343    80.121     0.150
     5.628    85.480     0.150
     5.640    85.291     0.150
     5.824    87.031     0.150
     5.956    90.682     0.150
     6.104    91.871     0.150
     6.301    94.871     0.150
     6.743    99.971     0.150
     0.177     4.090     0.150
     0.177     6.340     0.150
     0.494     9.840     0.150
     0.494    16.949     0.150
     0.494     9.709     0.150
     0.494    16.830     0.150
     0.496     9.850     0.150
     0.496    16.529     0.150
     0.496    16.670     0.150
     0.496    17.139     0.150
     0.496    17.340     0.150
     0.505    16.049     0.150
     0.556    10.219     0.150
     0.556    17.539     0.150
     0.551    10.410     0.150
     0.551    17.760     0.150
     0.961    17.398     0.150
     0.961    29.789     0.150
     0.940    17.000     0.150
     0.917    17.729     0.150
     0.917    30.969     0.150
     0.962    19.289     0.150
     0.962    31.840     0.150
     1.122    21.988     0.150
     1.129    20.270     0.150
     1.129    36.389     0.150
     1.151    20.789     0.150
     1.151    36.010     0.150
     1.177    21.479     0.150
     1.177    36.049     0.150
     1.177    38.020     0.150
     1.196    21.822     0.150
     1.196    37.078     0.150
     1.239    22.719     0.150
     1.267    22.709     0.150
     1.267    38.738     0.150
     1.293    23.199     0.150
     1.331    40.609     0.150
     1.331    23.969     0.150
     1.350    23.770     0.150
     1.390    23.779     0.150
     1.392    25.379     0.150
     1.392    44.049     0.150
     1.429    24.381     0.150
     1.429    45.461     0.150
     1.429    24.770     0.150
     1.452    25.660     0.150
     1.452    43.459     0.150
     1.452    25.770     0.150
     1.471    26.068     0.150
     1.522    27.004     0.150
     1.522    46.748     0.150
     1.522    26.898     0.150
     1.543    27.279     0.150
     1.543    46.850     0.150
     1.556    27.029     0.150
     1.556    49.549     0.150
     1.641    29.488     0.150
     1.641    49.229     0.150
     1.676    28.023     0.150
     1.676    51.717     0.150
     1.748    32.119     0.150
     1.861    29.910     0.150
     1.842    33.389     0.150
     1.847    31.434     0.150
     1.847    55.209     0.150
     1.847    31.949     0.150
     1.847    31.920     0.150
     1.873    33.350     0.150
     1.880    34.020     0.150
     2.019    33.029     0.150
     2.101    37.568     0.150
     2.132    38.709     0.150
     2.136    34.893     0.150
     2.188    40.039     0.150
     2.199    35.670     0.150
     2.199    63.877     0.150
     2.199    35.818     0.150
     2.213    40.629     0.150
     2.242    40.510     0.150
     2.449    38.855     0.150
     2.449    38.600     0.150
     2.449    68.369     0.150
     2.449    38.299     0.150
     2.456    39.018     0.150
     2.493    40.303     0.150
     2.664    42.686     0.150
     5.631    84.988     0.150
     5.959    89.449     0.150
     6.303    93.660     0.150
     0.180     4.141     0.150
     0.180     6.820     0.150
     0.180     7.258     0.150
     0.494     9.898     0.150
     0.494    16.430     0.150
     0.494    16.938     0.150
     0.496     9.898     0.150
     0.496    16.516     0.150
     0.496    17.086     0.150
     0.502    16.367     0.150
     0.552    10.430     0.150
     0.552    17.531     0.150
     0.559    10.398     0.150
     0.559    17.820     0.150
     0.915    30.125     0.150
     0.942    17.156     0.150
     0.942    29.844     0.150
     0.939    17.750     0.150
     0.963    17.570     0.150
     0.963    30.148     0.150
     0.960    19.000     0.150
     0.960    32.750     0.150
     1.121    21.930     0.150
     1.121    37.219     0.150
     1.129    20.211     0.150
     1.151    20.781     0.150
     1.151    36.047     0.150
     1.179    21.289     0.150
     1.179    36.594     0.150
     1.179    21.414     0.150
     1.179    36.875     0.150
     1.197    21.844     0.150
     1.197    36.891     0.150
     1.197    36.656     0.150
     1.238    22.047     0.150
     1.238    40.594     0.150
     1.268    22.734     0.150
     1.268    38.648     0.150
     1.329    24.336     0.150
     1.332    23.930     0.150
     1.332    40.211     0.150
     1.392    25.367     0.150
     1.392    43.938     0.150
     1.387    23.750     0.150
     1.428    26.164     0.150
     1.428    45.578     0.150
     1.453    25.789     0.150
     1.453    44.156     0.150
     1.472    27.180     0.150
     1.522    27.055     0.150
     1.522    46.703     0.150
     1.522    27.836     0.150
     1.544    47.070     0.150
     1.544    27.281     0.150
     1.557    27.859     0.150
     1.643    29.484     0.150
     1.643    49.555     0.150
     1.643    29.008     0.150
     1.674    27.812     0.150
     1.674    53.258     0.150
     1.748    32.148     0.150
     1.748    54.977     0.150
     1.843    55.625     0.150
     1.848    32.258     0.150
     1.848    55.492     0.150
     1.848    32.508     0.150
     1.859    29.984     0.150
     1.874    33.656     0.150
     1.881    31.836     0.150
     1.881    34.180     0.150
     2.016    33.039     0.150
     2.102    37.391     0.150
     2.132    38.750     0.150
     2.135    34.773     0.150
     2.151    39.211     0.150
     2.188    40.141     0.150
     2.199    35.680     0.150
     2.199    67.453     0.150
     2.199    35.539     0.150
     2.213    40.617     0.150
     2.242    40.414     0.150
     2.446    38.852     0.150
     2.446    67.461     0.150
     2.446    38.727     0.150
     2.457    42.711     0.150
     2.457    73.266     0.150
     2.469    43.727     0.150
     2.493    40.133     0.150
     2.500    45.906     0.150
     2.864    45.547     0.150
     3.380    53.766     0.150
     3.536   109.781     0.150
     3.859    59.680     0.150
     3.891   116.703     0.150
     4.200    64.594     0.150
     4.303   131.797     0.150
     4.559    69.477     0.150
     4.782   148.477     0.150
     5.344    79.148     0.150
     5.439    82.891     0.150
     5.629    84.961     0.150
     5.640    85.141     0.150
     5.825    87.484     0.150
     5.957    90.109     0.150
     6.743   100.344     0.150
     0.274     5.812     0.150
     0.274     9.930     0.150
     0.274    10.660     0.150
     0.365     6.980     0.150
     0.365    11.949     0.150
     0.420     8.352     0.150
     0.420    14.461     0.150
     0.672    12.750     0.150
     0.672    22.012     0.150
     0.709    13.473     0.150
     0.709    22.840     0.150
     0.709    13.141     0.150
     0.709    22.949     0.150
     0.710    13.590     0.150
     0.710    13.422     0.150
     0.710    22.941     0.150
     0.761    23.621     0.150
     0.921    16.820     0.150
     0.921    31.289     0.150
     0.982    18.840     0.150
     0.982    31.520     0.150
     1.005    18.121     0.150
     1.005    30.691     0.150
     1.018    18.262     0.150
     1.018    31.152     0.150
     1.020    18.629     0.150
     1.020    31.730     0.150
     1.021    18.949     0.150
     1.094    19.492     0.150
     1.094    33.301     0.150
     1.128    21.141     0.150
     1.217    21.379     0.150
     1.217    21.480     0.150
     1.219    38.930     0.150
     1.245    22.359     0.150
     1.245    38.609     0.150
     1.290    38.922     0.150
     1.295    24.062     0.150
     1.306    41.129     0.150
     1.319    23.801     0.150
     1.319    40.320     0.150
     1.394    24.602     0.150
     1.394    41.949     0.150
     1.574    28.832     0.150
     1.574    48.840     0.150
     1.599    28.172     0.150
     1.599    27.652     0.150
     1.607    28.070     0.150
     1.607    48.441     0.150
     1.638    28.539     0.150
     1.672    29.391     0.150
     1.872    55.570     0.150
     1.885    31.930     0.150
     1.937    35.012     0.150
     1.951    35.020     0.150
     1.994    36.230     0.150
     2.040    36.270     0.150
     2.040    62.359     0.150
     2.667    41.832     0.150
     2.667    72.332     0.150
     2.667    41.699     0.150
     2.964    53.922     0.150
     5.647    85.711     0.150
     6.229    93.410     0.150
     0.326     6.840     0.150
     0.326    11.141     0.150
     0.188     4.789     0.150
     0.188     7.578     0.150
     0.405     8.520     0.150
     0.405    13.648     0.150
     0.405     8.250     0.150
     0.405    13.891     0.150
     0.407     8.520     0.150
     0.407    13.930     0.150
     0.407    15.008     0.150
     0.758    14.070     0.150
     0.758    24.039     0.150
     0.778    14.949     0.150
     0.778    25.438     0.150
     0.920    17.418     0.150
     1.269    22.840     0.150
     1.269    39.418     0.150
     1.269    39.570     0.150
     1.377    24.508     0.150
     1.377    41.828     0.150
     1.418    25.988     0.150
     1.418    43.969     0.150
     1.432    26.629     0.150
     1.432    44.660     0.150
     1.432    26.523     0.150
     1.471    44.598     0.150
     1.471    26.078     0.150
     1.426    26.340     0.150
     1.426    45.250     0.150
     1.619    28.980     0.150
     1.595    28.059     0.150
     1.637    28.359     0.150
     1.637    29.230     0.150
     1.657    30.797     0.150
     1.697    31.348     0.150
     1.751    31.047     0.150
     1.722    31.777     0.150
     1.722    30.883     0.150
     1.722    52.980     0.150
     1.716    31.734     0.150
     1.716    54.430     0.150
     1.848    32.309     0.150
     1.953    33.840     0.150
     1.953    58.566     0.150
     1.953    34.117     0.150
     2.011    35.430     0.150
     2.070    36.457     0.150
     2.031    64.180     0.150
     2.276    39.828     0.150
     2.341    41.859     0.150
     2.341    41.758     0.150
     2.399    43.809     0.150
     2.421    44.246     0.150
     2.421    74.352     0.150
     2.427    43.809     0.150
     2.427    74.684     0.150
     2.440    43.297     0.150
     2.596    44.719     0.150
     2.612    45.582     0.150
     2.612    78.391     0.150
     2.605    45.148     0.150
     2.649    45.660     0.150
     2.725    73.988     0.150
     2.768    51.230     0.150
     3.206    56.359     0.150
     3.150    96.172     0.150
     4.051   121.352     0.150
     4.924    74.641     0.150
     6.204    92.859     0.150
     6.311    95.391     0.150
     6.442    94.059     0.150
     6.534    96.457     0.150
     6.455    96.520     0.150
    10.755   277.969     0.150
     0.503     9.641     0.150
     0.503    16.469     0.150
     0.525    10.492     0.150
     0.525    17.469     0.150
     0.525    10.367     0.150
     0.525    17.000     0.150
     0.526    10.508     0.150
     0.526    17.211     0.150
     0.526    17.062     0.150
     0.575    10.930     0.150
     0.575    18.422     0.150
     0.885    18.758     0.150
     0.885    29.852     0.150
     0.933    17.648     0.150
     0.933    29.891     0.150
     1.096    21.109     0.150
     1.096    35.852     0.150
     1.119    21.281     0.150
     1.119    36.398     0.150
     1.159    21.938     0.150
     1.159    37.180     0.150
     1.159    38.633     0.150
     1.167    22.297     0.150
     1.167    37.289     0.150
     1.206    23.719     0.150
     1.206    38.250     0.150
     1.247    23.156     0.150
     1.247    39.227     0.150
     1.247    39.586     0.150
     1.297    24.711     0.150
     1.308    24.297     0.150
     1.308    41.320     0.150
     1.361    25.438     0.150
     1.429    26.109     0.150
     1.442    27.578     0.150
     1.494    28.141     0.150
     1.494    27.930     0.150
     1.621    29.500     0.150
     1.826    32.531     0.150
     1.993    33.516     0.150
     2.169    37.922     0.150
     2.436    39.719     0.150
     3.099    56.961     0.150
     3.355    60.406     0.150
     4.535    70.312     0.150
     5.598    85.359     0.150
     0.263     5.430     0.150
     0.263     9.023     0.150
     0.264     5.414     0.150
     0.264     8.969     0.150
     0.264     9.875     0.150
     0.351     6.891     0.150
     0.351    12.188     0.150
     0.717    13.359     0.150
     0.717    22.688     0.150
     1.035    19.688     0.150
     1.112    21.086     0.150
     1.112    21.391     0.150
     1.205    22.406     0.150
     1.205    38.195     0.150
     1.205    37.867     0.150
     1.322    25.219     0.150
     1.365    24.500     0.150
     1.406    45.227     0.150
     1.463    26.891     0.150
     1.463    45.961     0.150
     1.463    46.508     0.150
     1.448    25.766     0.150
     1.465    26.477     0.150
     1.465    46.500     0.150
     1.465    46.094     0.150
     1.554    28.484     0.150
     1.554    48.375     0.150
     1.617    29.680     0.150
     1.617    50.609     0.150
     1.645    53.609     0.150
     1.738    30.797     0.150
     1.738    54.195     0.150
     1.738    31.164     0.150
     1.798    31.797     0.150
     1.798    56.555     0.150
     1.810    30.844     0.150
     1.810    58.508     0.150
     1.829    33.141     0.150
     1.829    56.555     0.150
     1.840    32.641     0.150
     1.928    59.086     0.150
     1.994    35.680     0.150
     1.994    61.320     0.150
     2.011    37.445     0.150
     2.020    34.039     0.150
     2.128    37.930     0.150
     2.128    65.375     0.150
     2.133    37.258     0.150
     2.133    37.906     0.150
     2.133    65.156     0.150
     2.159    36.930     0.150
     2.159    66.344     0.150
     2.158    39.336     0.150
     2.312    37.539     0.150
     2.312    64.648     0.150
     2.312    37.641     0.150
     2.381    42.891     0.150
     2.381    73.516     0.150
     2.403    44.688     0.150
     2.463    40.367     0.150
     2.463    45.625     0.150
     2.739    48.391     0.150
     3.320    52.023     0.150
     4.066    62.125     0.150
     4.066    61.648     0.150
     4.561    69.867     0.150
     5.190    78.430     0.150
     5.247    79.398     0.150
     5.389    82.375     0.150
     5.606    84.305     0.150
     5.730    87.648     0.150
     5.969    90.734     0.150
     6.090    91.617     0.150
     6.087    92.898     0.150
     6.093    92.484     0.150
     6.455    98.023     0.150
     7.726   114.500     0.150
     0.687    12.500     0.150
     0.687    21.148     0.150
     1.044    19.609     0.150
     1.116    20.340     0.150
     1.119    22.297     0.150
     1.119    37.727     0.150
     1.179    21.039     0.150
     1.179    21.398     0.150
     1.179    36.250     0.150
     1.322    22.969     0.150
     1.442    25.828     0.150
     1.442    26.180     0.150
     1.442    44.590     0.150
     1.453    26.707     0.150
     1.453    45.188     0.150
     1.534    27.227     0.150
     1.534    46.680     0.150
     1.599    27.738     0.150
     1.662    30.785     0.150
     1.662    52.812     0.150
     1.720    29.707     0.150
     1.785    32.504     0.150
     1.785    54.996     0.150
     1.818    30.570     0.150
     1.819    30.199     0.150
     1.819    57.352     0.150
     2.041    33.328     0.150
     2.114    35.570     0.150
     2.114    37.043     0.150
     2.341    37.148     0.150
     2.341    63.547     0.150
     2.341    37.547     0.150
     2.343    37.824     0.150
     2.453    38.809     0.150
     2.453    44.594     0.150
     2.453    76.309     0.150
     2.723    47.566     0.150
     2.727    43.957     0.150
     3.199    99.039     0.150
     3.338    50.348     0.150
     3.467    60.020     0.150
     3.467   104.883     0.150
     3.592    66.930     0.150
     3.647    56.418     0.150
     3.672    54.520     0.150
     4.003    60.539     0.150
     4.095    61.727     0.150
     4.095    62.105     0.150
     4.144    62.199     0.150
     4.144    76.184     0.150
     4.157    72.391     0.150
     4.157   126.402     0.150
     4.563   140.840     0.150
     4.583    68.699     0.150
     4.749   145.059     0.150
     4.796    72.109     0.150
     4.973    74.207     0.150
     5.027    74.258     0.150
     5.277    78.250     0.150
     5.408    81.340     0.150
     5.408    82.164     0.150
     5.408   144.004     0.150
     5.978    88.828     0.150
     6.113    90.070     0.150
     6.463    97.309     0.150
     6.629    96.148     0.150
     0.376     7.703     0.150
     0.376    12.801     0.150
     0.624    12.203     0.150
     0.624    20.371     0.150
     0.624    12.051     0.150
     0.624    20.742     0.150
     0.814    15.723     0.150
     0.814    26.594     0.150
     0.892    16.543     0.150
     0.892    28.871     0.150
     0.892    28.762     0.150
     0.992    18.234     0.150
     0.992    31.293     0.150
     0.992    31.164     0.150
     0.977    19.012     0.150
     0.977    33.414     0.150
     0.977    18.754     0.150
     0.977    32.914     0.150
     1.017    19.062     0.150
     1.017    32.172     0.150
     1.023    19.402     0.150
     1.023    32.590     0.150
     1.023    32.434     0.150
     1.025    19.773     0.150
     1.025    33.863     0.150
     1.025    18.922     0.150
     1.025    33.262     0.150
     1.025    35.852     0.150
     1.075    19.844     0.150
     1.075    33.633     0.150
     1.104    21.012     0.150
     1.101    21.523     0.150
     1.101    35.973     0.150
     1.198    21.543     0.150
     1.198    36.043     0.150
     1.262    23.031     0.150
     1.262    38.824     0.150
     1.312    24.301     0.150
     1.312    41.305     0.150
     1.322    23.941     0.150
     1.322    43.082     0.150
     1.330    25.531     0.150
     1.330    42.762     0.150
     1.533    26.664     0.150
     1.573    27.801     0.150
     1.573    47.879     0.150
     1.573    27.672     0.150
     1.573    47.742     0.150
     1.725    29.359     0.150
     1.725    54.973     0.150
     1.725    51.004     0.150
     2.017    34.332     0.150
     2.017    62.480     0.150
     2.017    37.023     0.150
     2.017    62.645     0.150
     2.017    34.184     0.150
     2.017    61.801     0.150
     2.070    34.957     0.150
     2.199    36.203     0.150
     2.199    61.172     0.150
     2.214    37.867     0.150
     2.214    66.672     0.150
     2.365    39.355     0.150
     2.552    41.039     0.150
     2.552    72.730     0.150
     2.619    42.762     0.150
     2.708    42.762     0.150
     2.724    43.059     0.150
     2.724    42.301     0.150
     2.724    72.594     0.150
     2.741    44.949     0.150
     2.741    83.898     0.150
     3.119    49.863     0.150
     3.138    49.574     0.150
     3.159    50.793     0.150
     3.205    58.129     0.150
     3.205   101.445     0.150
     3.278   101.027     0.150
     3.346    61.852     0.150
     3.346   103.777     0.150
     3.399    52.664     0.150
     3.408    53.832     0.150
     3.653    58.496     0.150
     3.653   111.039     0.150
     3.726    68.805     0.150
     3.726   115.406     0.150
     3.726    58.793     0.150
     3.760   102.199     0.150
     3.760    58.773     0.150
     3.882    60.773     0.150
     4.093   125.723     0.150
     4.222   130.605     0.150
     4.266   131.828     0.150
     4.387    67.562     0.150
     4.473    68.348     0.150
     4.473    68.102     0.150
     4.526    68.844     0.150
     4.581    69.602     0.150
     4.724    72.543     0.150
     4.912    75.613     0.150
     5.464    84.363     0.150
     5.464    82.141     0.150
     5.685    86.512     0.150
     5.733    85.523     0.150
     5.756    87.734     0.150
     5.815    88.512     0.150
     5.834    88.152     0.150
     5.829    88.613     0.150
     5.978    90.832     0.150
     6.281    94.852     0.150
     6.291    93.934     0.150
     6.414    97.102     0.150
     6.508    97.023     0.150
     6.510    98.352     0.150
     6.922   101.504     0.150
     7.019   104.012     0.150
     7.016   102.531     0.150
     7.045   106.848     0.150
     7.045   224.484     0.150
     7.045   105.352     0.150
     7.107   105.414     0.150
     7.119   107.523     0.150
     7.285   109.844     0.150
     7.342   108.383     0.150
     7.477   110.203     0.150
     7.524   111.574     0.150
     7.543   110.621     0.150
     7.604   111.504     0.150
     7.806   112.523     0.150
     7.990   115.441     0.150
     8.063   118.172     0.150
     8.150   119.234     0.150
     8.262   119.074     0.150
     8.268   120.992     0.150
     8.321   124.516     0.150
     8.321   121.891     0.150
     8.520   122.234     0.150
     8.584   124.383     0.150
     8.618   123.793     0.150
     8.926   129.562     0.150
     9.040   131.602     0.150
     9.117   134.195     0.150
     9.117   132.664     0.150
     9.579   139.113     0.150
    10.135   145.684     0.150
    10.319   147.352     0.150
    10.555   152.211     0.150
    10.872   157.832     0.150
    10.872   157.633     0.150
    10.872   158.262     0.150
    12.236   179.344     0.150
    38.260   443.398     0.150
   124.843  1146.004     0.150
     0.481     9.734     0.150
     0.481    16.164     0.150
     0.481    16.000     0.150
     0.680    12.953     0.150
     0.680    21.164     0.150
     0.850    17.742     0.150
     0.902    18.672     0.150
     0.902    31.344     0.150
     0.912    18.672     0.150
     0.912    31.602     0.150
     1.055    19.891     0.150
     1.055    34.016     0.150
     1.055    33.773     0.150
     1.101    22.352     0.150
     1.101    37.734     0.150
     1.175    21.633     0.150
     1.236    22.984     0.150
     1.236    39.133     0.150
     1.268    23.695     0.150
     1.268    39.992     0.150
     1.268    40.281     0.150
     1.268    41.156     0.150
     1.352    24.852     0.150
     1.352    42.234     0.150
     1.406    25.734     0.150
     1.406    26.016     0.150
     1.406    44.086     0.150
     1.437    26.578     0.150
     1.525    27.664     0.150
     1.573    28.172     0.150
     1.573    48.922     0.150
     1.620    28.680     0.150
     1.620    28.461     0.150
     1.620    50.742     0.150
     1.722    31.070     0.150
     1.916    32.250     0.150
     1.927    34.117     0.150
     1.927    34.648     0.150
     1.927    59.031     0.150
     2.233    36.773     0.150
     2.233    40.562     0.150
     2.233    69.336     0.150
     2.323    37.891     0.150
     2.323    37.773     0.150
     2.518    44.555     0.150
     2.518    77.062     0.150
     3.099    95.516     0.150
     3.620   109.844     0.150
     3.807    61.805     0.150
     4.460    68.750     0.150
     5.563    84.781     0.150
     5.904    89.172     0.150
     0.405     8.195     0.150
     0.405    13.825     0.150
     0.405    14.285     0.150
     0.539     9.815     0.150
     0.539    16.935     0.150
     0.539    17.115     0.150
     0.539    17.385     0.150
     0.602    11.565     0.150
     0.602    19.805     0.150
     0.701    13.275     0.150
     0.701    22.405     0.150
     0.786    15.175     0.150
     0.786    25.355     0.150
     0.787    14.865     0.150
     0.787    14.635     0.150
     0.787    24.825     0.150
     0.812    15.415     0.150
     0.812    15.535     0.150
     0.812    25.855     0.150
     0.910    16.595     0.150
     0.931    18.745     0.150
     0.931    16.875     0.150
     0.972    18.035     0.150
     0.972    31.265     0.150
     0.972    17.695     0.150
     0.976    18.755     0.150
     0.999    20.265     0.150
     0.999    34.925     0.150
     0.999    19.275     0.150
     1.023    32.245     0.150
     1.043    19.305     0.150
     1.078    19.345     0.150
     1.126    21.228     0.150
     1.126    36.371     0.150
     1.165    20.725     0.150
     1.283    23.355     0.150
     1.386    24.875     0.150
     1.553    26.775     0.150
     1.650    28.315     0.150
     1.650    28.470     0.150
     1.650    48.313     0.150
     1.757    31.375     0.150
     1.757    30.521     0.150
     1.757    32.226     0.150
     1.757    54.906     0.150
     1.889    32.407     0.150
     1.927    33.781     0.150
     1.927    58.352     0.150
     2.062    36.065     0.150
     2.136    35.911     0.150
     2.136    39.444     0.150
     2.136    67.287     0.150
     2.239    37.535     0.150
     2.345    38.215     0.150
     2.425    67.595     0.150
     2.448    40.470     0.150
     2.469    75.409     0.150
     2.873    44.895     0.150
     2.873    78.769     0.150
     2.945    47.663     0.150
     2.959    48.192     0.150
     2.959    54.750     0.150
     2.959    93.406     0.150
     3.366   101.487     0.150
     3.383    53.945     0.150
     3.466    54.905     0.150
     3.568   112.226     0.150
     3.755    59.415     0.150
     4.128    64.275     0.150
     4.320   134.446     0.150
     4.329    67.035     0.150
     4.607    71.285     0.150
     4.707    72.335     0.150
     4.726    72.175     0.150
     5.072    77.545     0.150
     5.419    82.145     0.150
     5.488    82.675     0.150
     5.581    84.535     0.150
     5.607    84.165     0.150
     5.681    85.835     0.150
     6.130    91.445     0.150
     0.851    16.502     0.150
     0.851    27.900     0.150
     0.710    13.211     0.150
     0.710    22.762     0.150
     1.193    22.320     0.150
     1.348    24.320     0.150
     1.348    42.381     0.150
     1.348    24.541     0.150
     1.348    41.781     0.150
     1.574    27.682     0.150
     1.633    28.461     0.150
     1.643    28.932     0.150
     1.643    49.262     0.150
     1.643    28.641     0.150
     1.643    28.781     0.150
     1.718    29.521     0.150
     1.716    30.650     0.150
     1.716    51.941     0.150
     1.716    30.211     0.150
     1.716    29.771     0.150
     1.716    52.121     0.150
     1.826    31.900     0.150
     1.857    31.602     0.150
     1.842    31.682     0.150
     1.842    31.951     0.150
     1.826    32.061     0.150
     1.826    55.490     0.150
     1.826    31.391     0.150
     1.869    32.541     0.150
     1.869    57.943     0.150
     1.942    33.051     0.150
     1.989    32.980     0.150
     1.922    33.461     0.150
     2.011    33.672     0.150
     1.998    34.070     0.150
     2.008    36.791     0.150
     2.046    35.441     0.150
     2.046    34.730     0.150
     2.059    34.980     0.150
     2.059    37.631     0.150
     2.130    35.521     0.150
     2.084    35.912     0.150
     2.168    37.432     0.150
     2.168    36.926     0.150
     2.222    37.512     0.150
     2.199    37.240     0.150
     2.348    38.412     0.150
     2.348    38.262     0.150
     2.298    38.961     0.150
     2.424    40.451     0.150
     2.400    39.582     0.150
     2.400    38.941     0.150
     2.542    41.150     0.150
     2.518    42.432     0.150
     2.706    43.561     0.150
     2.706    43.301     0.150
     2.706    73.752     0.150
     2.617    76.002     0.150
     2.842    45.721     0.150
     2.863    45.967     0.150
     2.913    45.490     0.150
     2.913    89.451     0.150
     2.869    46.211     0.150
     2.869    46.109     0.150
     2.869    88.641     0.150
     3.090    49.150     0.150
     3.063    49.998     0.150
     3.191    51.184     0.150
     3.191   100.412     0.150
     3.192    51.662     0.150
     3.367    53.457     0.150
     3.258    51.098     0.150
     3.258    90.027     0.150
     3.472    53.146     0.150
     3.597    56.914     0.150
     3.597   110.477     0.150
     3.716    58.154     0.150
     3.643    67.918     0.150
     3.643   110.873     0.150
     3.853    59.871     0.150
     3.804    59.406     0.150
     3.804   115.359     0.150
     3.962    62.188     0.150
     4.045    62.979     0.150
     3.963    61.092     0.150
     4.044    63.578     0.150
     4.099    72.656     0.150
     4.069    62.381     0.150
     4.069    61.861     0.150
     4.069   108.744     0.150
     4.438    67.391     0.150
     4.438   118.441     0.150
     4.438    67.498     0.150
     4.479    69.061     0.150
     4.479    76.861     0.150
     4.479   130.150     0.150
     4.534    69.832     0.150
     4.501    68.955     0.150
     4.577    70.691     0.150
     4.616    70.939     0.150
     4.601    70.211     0.150
     4.601    70.021     0.150
     4.753    72.471     0.150
     5.052    77.633     0.150
     5.102    76.781     0.150
     5.235    79.682     0.150
     5.374    81.041     0.150
     5.374    81.885     0.150
     5.350    80.875     0.150
     5.424    83.221     0.150
     5.446    82.980     0.150
     5.518    83.182     0.150
     5.696    87.701     0.150
     5.726    86.500     0.150
     5.769    87.156     0.150
     5.920    88.301     0.150
     5.920    89.652     0.150
     5.959    89.891     0.150
     6.089    91.291     0.150
     6.140    93.361     0.150
     6.140    93.510     0.150
     6.274    95.262     0.150
     6.507    98.631     0.150
     6.587    99.262     0.150
     6.587    98.828     0.150
     6.599   100.631     0.150
     6.656    99.480     0.150
     6.609   100.691     0.150
     6.945   103.762     0.150
     6.945   179.439     0.150
     6.945   103.555     0.150
     6.991   105.762     0.150
     7.181   108.932     0.150
     7.520   113.328     0.150
     7.540   110.740     0.150
     7.633   109.602     0.150
     7.849   112.951     0.150
     7.901   119.178     0.150
     8.086   120.781     0.150
     8.731   129.158     0.150
     8.783   128.771     0.150
     8.783   130.303     0.150
     8.827   127.391     0.150
     8.861   130.320     0.150
     8.861   130.795     0.150
     9.649   141.635     0.150
     9.919   146.156     0.150
    10.069   147.662     0.150
    10.512   152.725     0.150
    10.892   159.072     0.150
    11.099   162.783     0.150
    11.357   165.621     0.150
    12.158   176.461     0.150
    12.279   181.818     0.150
    12.451   180.010     0.150
    12.562   180.545     0.150
    12.781   185.529     0.150
    12.768   186.037     0.150
    12.896   186.346     0.150
    12.896   188.100     0.150
    13.467   195.193     0.150
    13.677   197.381     0.150
    13.773   198.186     0.150
    13.899   199.943     0.150
    13.977   195.779     0.150
    14.146   202.709     0.150
    14.389   202.721     0.150
    14.428   203.529     0.150
    14.455   203.451     0.150
    14.461   203.643     0.150
    14.745   212.322     0.150
    14.727   206.123     0.150
    15.098   211.572     0.150
    15.098   216.236     0.150
    15.069   213.436     0.150
    15.187   212.201     0.150
    15.223   212.463     0.150
    15.843   221.330     0.150
    15.956   221.471     0.150
    15.985   222.842     0.150
    16.051   229.303     0.150
    16.162   231.143     0.150
    16.154   224.963     0.150
    16.415   227.791     0.150
    16.604   235.920     0.150
    17.368   245.607     0.150
    17.465   248.771     0.150
    17.465   247.639     0.150
    17.644   241.830     0.150
    17.663   241.779     0.150
    17.716   242.971     0.150
    17.779   244.803     0.150
    17.779   250.658     0.150
    17.745   243.463     0.150
    18.275   251.350     0.150
    18.870   262.494     0.150
    18.970   263.357     0.150
    19.544   263.420     0.150
    19.691   265.182     0.150
    19.689   266.041     0.150
    19.689   271.447     0.150
    19.788   272.279     0.150
    19.856   268.080     0.150
    19.856   274.857     0.150
    20.643   276.100     0.150
    20.701   277.510     0.150
    21.141   281.529     0.150
    21.149   289.088     0.150
    21.375   289.420     0.150
    21.980   289.752     0.150
    22.957   306.201     0.150
    23.092   307.818     0.150
    23.263   304.092     0.150
    23.349   310.248     0.150
    24.433   319.928     0.150
    27.053   343.420     0.150
    35.683   422.967     0.150
    35.816   424.654     0.150
    36.132   426.107     0.150
    36.192   426.432     0.150
    36.342   427.264     0.150
    36.472   429.346     0.150
    36.515   430.729     0.150
    36.888   432.967     0.150
    37.162   435.650     0.150
    37.233   435.420     0.150
    37.283   437.467     0.150
    37.365   438.471     0.150
    37.391   437.986     0.150
    37.503   438.170     0.150
    37.576   438.998     0.150
    37.669   440.354     0.150
    37.729   441.416     0.150
    37.751   441.057     0.150
    37.803   440.943     0.150
    37.877   440.869     0.150
    37.942   441.279     0.150
    38.089   444.549     0.150
    38.323   445.076     0.150
    38.548   447.717     0.150
    39.052   451.432     0.150
    39.328   453.705     0.150
    39.386   454.299     0.150
    39.663   455.482     0.150
    39.672   456.604     0.150
    39.935   458.654     0.150
    39.981   459.814     0.150
    40.138   459.768     0.150
    40.166   461.678     0.150
    40.270   460.482     0.150
    40.305   461.643     0.150
    40.627   465.068     0.150
    40.654   464.268     0.150
    40.999   467.303     0.150
    41.129   468.318     0.150
    41.126   469.182     0.150
    41.554   472.217     0.150
    41.568   470.963     0.150
    41.804   473.955     0.150
    42.430   478.443     0.150
    42.619   480.365     0.150
    51.945   552.225     0.150
    70.375  5287.596     0.150
    70.379  5287.975     0.150
    70.392  5288.932     0.150
    82.531   746.775     0.150
    96.374   807.350     0.150
     0.432     8.539     0.150
     0.432    14.367     0.150
     0.432    14.797     0.150
     0.472     9.547     0.150
     0.472    15.488     0.150
     0.549    10.930     0.150
     0.549    18.230     0.150
     0.836    16.609     0.150
     0.836    28.699     0.150
     0.863    16.539     0.150
     0.883    17.887     0.150
     0.959    17.750     0.150
     1.049    20.699     0.150
     1.096    20.000     0.150
     1.096    20.160     0.150
     1.096    34.668     0.150
     1.149    21.348     0.150
     1.149    35.984     0.150
     1.167    21.457     0.150
     1.167    21.777     0.150
     1.167    36.980     0.150
     1.167    37.578     0.150
     1.252    22.828     0.150
     1.252    38.789     0.150
     1.307    23.258     0.150
     1.367    25.219     0.150
     1.367    44.316     0.150
     1.427    25.410     0.150
     1.427    25.660     0.150
     1.482    27.238     0.150
     1.482    45.754     0.150
     1.549    28.348     0.150
     1.596    50.090     0.150
     1.828    31.527     0.150
     1.828    32.449     0.150
     1.828    55.387     0.150
     1.942    31.730     0.150
     2.143    66.836     0.150
     2.150    36.438     0.150
     2.150    36.660     0.150
     2.150    39.375     0.150
     2.150    67.211     0.150
     2.337    38.348     0.150
     2.393    37.840     0.150
     2.393    38.105     0.150
     2.393    66.820     0.150
     2.424    42.340     0.150
     2.424    73.289     0.150
     2.576    42.500     0.150
     3.199    50.898     0.150
     3.855   117.594     0.150
     4.484    68.289     0.150
     4.496    68.320     0.150
     5.569    83.980     0.150
     6.031    90.520     0.150
     0.172     4.605     0.150
     0.172     7.426     0.150
     0.172     7.766     0.150
     0.562    10.824     0.150
     0.562    17.934     0.150
     0.562    18.094     0.150
     0.806    15.387     0.150
     0.806    25.754     0.150
     0.806    14.984     0.150
     0.806    28.004     0.150
     0.806    28.906     0.150
     0.919    17.125     0.150
     0.919    28.996     0.150
     0.919    30.273     0.150
     0.919    30.453     0.150
     1.189    21.105     0.150
     1.189    36.285     0.150
     1.189    36.926     0.150
     1.189    38.035     0.150
     1.302    22.816     0.150
     1.361    25.293     0.150
     1.361    23.176     0.150
     1.375    24.355     0.150
     1.409    42.004     0.150
     1.409    24.484     0.150
     1.409    24.695     0.150
     1.418    25.453     0.150
     1.418    42.676     0.150
     1.423    42.805     0.150
     1.423    24.914     0.150
     1.422    24.945     0.150
     1.422    42.754     0.150
     1.450    44.727     0.150
     1.494    26.066     0.150
     1.494    44.355     0.150
     1.502    48.086     0.150
     1.531    26.344     0.150
     1.531    47.324     0.150
     1.552    26.785     0.150
     1.556    28.496     0.150
     1.556    48.746     0.150
     1.646    28.293     0.150
     1.646    51.535     0.150
     1.657    28.305     0.150
     1.664    53.195     0.150
     1.670    28.664     0.150
     1.684    29.316     0.150
     1.684    50.266     0.150
     1.684    50.379     0.150
     1.720    54.535     0.150
     1.730    28.844     0.150
     1.730    53.043     0.150
     1.730    53.371     0.150
     1.779    52.406     0.150
     1.779    30.195     0.150
     1.869    30.344     0.150
     1.869    32.414     0.150
     1.869    55.805     0.150
     1.868    30.906     0.150
     1.898    32.195     0.150
     1.964    32.574     0.150
     2.109    33.953     0.150
     2.109    33.848     0.150
     2.109    64.469     0.150
     2.360    38.984     0.150
     2.392    71.828     0.150
     2.398    38.523     0.150
     2.398    71.953     0.150
     2.426    38.715     0.150
     2.479    39.676     0.150
     2.499    39.406     0.150
     2.545    41.500     0.150
     2.552    41.426     0.150
     2.666    42.605     0.150
     2.766    43.781     0.150
     2.845    45.176     0.150
     2.887    44.844     0.150
     2.887    44.684     0.150
     3.027    47.352     0.150
     3.157    57.836     0.150
     3.565    54.848     0.150
     3.751    57.953     0.150
     3.980    62.012     0.150
     4.279    65.176     0.150
     4.642    69.234     0.150
     5.041    75.645     0.150
     5.320    79.375     0.150
     5.816    86.105     0.150
     6.072    91.426     0.150
     6.122    90.484     0.150
     6.128    90.914     0.150
     6.232    93.344     0.150
     6.587    96.805     0.150
     6.697    98.074     0.150
     6.942   102.754     0.150
     7.179   104.766     0.150
     7.885   114.656     0.150
     0.251     5.688     0.150
     0.251     9.422     0.150
     0.441     8.852     0.150
     0.441    15.289     0.150
     0.441    15.641     0.150
     0.472     9.391     0.150
     0.529    10.617     0.150
     0.529    18.281     0.150
     0.529    10.734     0.150
     0.750    14.164     0.150
     0.750    24.039     0.150
     0.748    13.961     0.150
     0.748    23.969     0.150
     0.748    24.547     0.150
     0.748    24.781     0.150
     0.847    15.398     0.150
     0.847    26.141     0.150
     0.879    16.539     0.150
     0.879    27.578     0.150
     0.880    16.328     0.150
     0.880    27.117     0.150
     0.880    27.242     0.150
     0.883    16.133     0.150
     0.883    27.062     0.150
     0.883    16.180     0.150
     0.904    16.562     0.150
     0.904    28.641     0.150
     0.904    29.578     0.150
     0.907    17.359     0.150
     0.907    31.242     0.150
     0.907    16.680     0.150
     0.907    28.914     0.150
     0.920    17.117     0.150
     0.920    29.359     0.150
     0.926    16.844     0.150
     0.926    28.523     0.150
     0.965    18.680     0.150
     0.965    31.414     0.150
     0.985    17.133     0.150
     0.985    31.734     0.150
     1.002    18.523     0.150
     1.002    32.750     0.150
     1.024    19.453     0.150
     1.024    33.352     0.150
     1.049    18.570     0.150
     1.049    32.078     0.150
     1.112    20.461     0.150
     1.112    36.383     0.150
     1.119    19.961     0.150
     1.119    34.523     0.150
     1.117    20.539     0.150
     1.117    35.508     0.150
     1.126    35.984     0.150
     1.126    19.508     0.150
     1.162    21.188     0.150
     1.162    35.828     0.150
     1.162    21.047     0.150
     1.192    21.078     0.150
     1.192    37.359     0.150
     1.192    37.016     0.150
     1.223    21.578     0.150
     1.223    36.922     0.150
     1.223    37.789     0.150
     1.367    41.500     0.150
     1.387    25.047     0.150
     1.387    42.312     0.150
     1.428    24.898     0.150
     1.428    42.742     0.150
     1.428    42.930     0.150
     1.428    24.844     0.150
     1.429    25.094     0.150
     1.429    44.969     0.150
     1.438    25.148     0.150
     1.438    43.242     0.150
     1.506    42.914     0.150
     1.512    46.367     0.150
     1.526    47.047     0.150
     1.646    27.172     0.150
     1.646    46.328     0.150
     1.701    51.062     0.150
     1.721    30.039     0.150
     1.869    31.133     0.150
     1.869    57.023     0.150
     1.869    31.008     0.150
     1.893    31.234     0.150
     1.947    32.047     0.150
     1.947    54.523     0.150
     2.064    61.664     0.150
     2.178    34.859     0.150
     2.203    35.820     0.150
     2.221    34.188     0.150
     2.226    36.133     0.150
     2.226    68.742     0.150
     2.574    71.031     0.150
     2.591    79.250     0.150
     2.602    42.664     0.150
     2.764    42.250     0.150
     2.764    42.469     0.150
     2.764    72.852     0.150
     2.764    74.008     0.150
     2.808    85.031     0.150
     2.856    43.188     0.150
     3.355    51.258     0.150
     3.503   104.445     0.150
     3.579    54.039     0.150
     3.752    56.453     0.150
     3.783    56.203     0.150
     4.435    64.352     0.150
     4.506    65.031     0.150
     5.033    72.531     0.150
     5.275    75.750     0.150
     5.607    81.641     0.150
     5.876    87.914     0.150
     6.247    93.070     0.150
     0.248     5.365     0.150
     0.248     8.756     0.150
     0.248     9.135     0.150
     0.409     8.266     0.150
     0.409    13.605     0.150
     0.409    13.945     0.150
     0.409    14.057     0.150
     0.832    15.186     0.150
     0.832    26.096     0.150
     0.832    26.416     0.150
     0.868    16.576     0.150
     0.868    28.256     0.150
     0.907    17.227     0.150
     0.907    29.496     0.150
     1.057    21.477     0.150
     1.057    36.885     0.150
     1.144    22.727     0.150
     1.144    23.246     0.150
     1.144    38.885     0.150
     1.144    40.205     0.150
     1.150    22.977     0.150
     1.150    39.566     0.150
     1.150    21.135     0.150
     1.150    37.557     0.150
     1.288    23.545     0.150
     1.288    40.215     0.150
     1.288    23.426     0.150
     1.288    40.756     0.150
     1.288    42.865     0.150
     1.366    25.596     0.150
     1.366    45.986     0.150
     1.421    45.006     0.150
     1.468    46.455     0.150
     1.468    46.695     0.150
     1.468    27.516     0.150
     1.544    28.066     0.150
     1.544    27.846     0.150
     1.544    48.756     0.150
     1.532    27.807     0.150
     1.638    29.227     0.150
     1.634    29.566     0.150
     1.634    50.135     0.150
     1.625    28.436     0.150
     1.695    30.465     0.150
     1.815    31.715     0.150
     1.815    55.865     0.150
     1.832    31.025     0.150
     1.922    32.855     0.150
     2.002    33.295     0.150
     2.213    37.426     0.150
     2.212    39.105     0.150
     2.256    36.115     0.150
     2.528    42.436     0.150
     2.570    41.926     0.150
     2.965    48.885     0.150
     3.310    52.156     0.150
     4.007    61.566     0.150
     4.212    65.275     0.150
     4.767    72.215     0.150
     5.229    78.656     0.150
     5.736    88.076     0.150
     5.987    90.746     0.150
     6.061    91.336     0.150
     6.102    92.355     0.150
     6.477    98.246     0.150
     6.581    98.477     0.150
     0.243     5.003     0.150
     0.243     8.562     0.150
     0.480     9.412     0.150
     0.480    16.332     0.150
     0.480    16.072     0.150
     0.480    16.612     0.150
     0.480    16.763     0.150
     0.488     9.223     0.150
     0.488    15.912     0.150
     0.491     9.332     0.150
     0.491    16.322     0.150
     0.491    16.423     0.150
     0.697    12.853     0.150
     0.697    22.133     0.150
     0.697    22.003     0.150
     0.795    14.332     0.150
     0.795    24.793     0.150
     0.795    24.192     0.150
     0.773    14.452     0.150
     0.773    24.463     0.150
     0.847    15.643     0.150
     0.847    26.162     0.150
     0.858    15.593     0.150
     0.858    26.532     0.150
     0.876    15.753     0.150
     0.905    16.662     0.150
     0.930    17.013     0.150
     0.930    29.593     0.150
     0.930    30.433     0.150
     0.930    28.912     0.150
     0.917    17.213     0.150
     0.917    30.303     0.150
     0.957    17.562     0.150
     0.957    30.093     0.150
     0.957    31.562     0.150
     0.984    17.503     0.150
     0.984    30.152     0.150
     1.000    17.702     0.150
     0.979    17.263     0.150
     0.979    18.383     0.150
     0.979    29.952     0.150
     0.979    31.572     0.150
     1.000    19.332     0.150
     1.000    33.223     0.150
     1.006    18.893     0.150
     1.006    32.902     0.150
     1.007    19.423     0.150
     1.007    34.053     0.150
     1.066    19.122     0.150
     1.089    20.013     0.150
     1.094    20.322     0.150
     1.094    35.883     0.150
     1.121    20.253     0.150
     1.121    34.893     0.150
     1.121    34.753     0.150
     1.146    20.982     0.150
     1.146    37.582     0.150
     1.171    20.713     0.150
     1.171    35.393     0.150
     1.170    21.673     0.150
     1.170    36.973     0.150
     1.170    21.013     0.150
     1.170    36.483     0.150
     1.190    22.522     0.150
     1.200    21.702     0.150
     1.236    21.692     0.150
     1.236    39.312     0.150
     1.236    40.143     0.150
     1.255    21.942     0.150
     1.343    23.822     0.150
     1.343    41.723     0.150
     1.334    43.622     0.150
     1.332    23.213     0.150
     1.347    23.312     0.150
     1.376    24.053     0.150
     1.376    23.936     0.150
     1.376    41.454     0.150
     1.376    24.423     0.150
     1.376    41.482     0.150
     1.388    24.463     0.150
     1.388    42.133     0.150
     1.468    26.282     0.150
     1.468    44.982     0.150
     1.487    27.103     0.150
     1.487    45.923     0.150
     1.508    25.343     0.150
     1.650    29.362     0.150
     1.650    49.282     0.150
     1.650    27.532     0.150
     1.650    48.416     0.150
     1.675    29.162     0.150
     1.675    50.633     0.150
     1.741    31.473     0.150
     1.741    31.692     0.150
     1.751    31.812     0.150
     1.751    53.862     0.150
     1.816    33.343     0.150
     1.816    57.062     0.150
     1.829    31.183     0.150
     1.830    30.832     0.150
     1.830    56.516     0.150
     1.839    32.952     0.150
     1.856    31.103     0.150
     1.929    32.212     0.150
     1.929    56.002     0.150
     2.016    34.009     0.150
     2.016    60.075     0.150
     2.153    35.702     0.150
     2.149    35.912     0.150
     2.196    36.087     0.150
     2.203    35.442     0.150
     2.268    35.043     0.150
     2.275    41.973     0.150
     2.377    67.315     0.150
     2.357    37.942     0.150
     2.485    40.166     0.150
     2.520    39.604     0.150
     2.520    69.973     0.150
     2.549    45.496     0.150
     2.549    78.139     0.150
     2.759    49.152     0.150
     2.759    83.328     0.150
     2.806    43.032     0.150
     2.806    76.734     0.150
     2.806    74.372     0.150
     2.999    46.701     0.150
     3.210    49.918     0.150
     3.369    52.442     0.150
     3.540    54.803     0.150
     3.629    56.134     0.150
     3.705    57.053     0.150
     3.777    58.143     0.150
     4.052    61.883     0.150
     4.179    63.543     0.150
     4.328    65.412     0.150
     4.546    67.933     0.150
     4.546    68.538     0.150
     4.758    71.393     0.150
     4.998    74.223     0.150
     5.137    79.183     0.150
     5.412    80.933     0.150
     5.412    82.060     0.150
     5.566    84.082     0.150
     5.568    84.832     0.150
     5.595    85.043     0.150
     5.660    86.232     0.150
     5.710    86.272     0.150
     5.834    86.973     0.150
     5.867    88.253     0.150
     6.164    92.482     0.150
     6.267    93.702     0.150
     6.292    94.272     0.150
     6.439    96.503     0.150
     7.092   103.202     0.150
     7.092   103.531     0.150
     7.326   108.013     0.150
     8.276   122.482     0.150
     9.132   132.032     0.150
     0.243     4.867     0.150
     0.481     9.457     0.150
     0.481    16.055     0.150
     0.481    16.285     0.150
     0.481    16.527     0.150
     0.489     9.336     0.150
     0.489    15.977     0.150
     0.491     9.328     0.150
     0.491    16.238     0.150
     0.491    16.586     0.150
     0.697    12.797     0.150
     0.697    22.375     0.150
     0.697    13.156     0.150
     0.697    22.168     0.150
     0.773    14.488     0.150
     0.773    24.375     0.150
     0.795    14.367     0.150
     0.795    24.766     0.150
     0.795    24.637     0.150
     0.847    15.695     0.150
     0.847    26.336     0.150
     0.847    26.156     0.150
     0.858    15.668     0.150
     0.858    26.555     0.150
     0.858    15.348     0.150
     0.858    15.676     0.150
     0.858    26.535     0.150
     0.876    15.848     0.150
     0.876    26.965     0.150
     0.876    15.727     0.150
     0.876    27.188     0.150
     0.905    16.715     0.150
     0.916    17.527     0.150
     0.916    16.426     0.150
     0.916    29.316     0.150
     0.930    17.047     0.150
     0.930    29.246     0.150
     0.956    17.625     0.150
     0.956    30.426     0.150
     0.984    17.418     0.150
     0.984    30.348     0.150
     0.978    17.398     0.150
     0.978    30.316     0.150
     0.978    33.105     0.150
     1.000    30.656     0.150
     1.000    17.887     0.150
     1.000    17.758     0.150
     1.000    30.555     0.150
     1.000    30.957     0.150
     0.999    33.637     0.150
     1.006    32.945     0.150
     1.067    19.098     0.150
     1.067    32.758     0.150
     1.089    20.117     0.150
     1.094    20.465     0.150
     1.094    36.238     0.150
     1.121    20.227     0.150
     1.121    34.617     0.150
     1.172    35.367     0.150
     1.170    21.188     0.150
     1.170    36.867     0.150
     1.199    39.715     0.150
     1.255    21.977     0.150
     1.255    37.848     0.150
     1.236    21.566     0.150
     1.236    38.066     0.150
     1.314    40.238     0.150
     1.343    23.816     0.150
     1.343    41.035     0.150
     1.346    43.625     0.150
     1.376    24.148     0.150
     1.376    24.195     0.150
     1.376    41.406     0.150
     1.389    24.465     0.150
     1.389    42.117     0.150
     1.394    25.508     0.150
     1.394    43.738     0.150
     1.468    26.156     0.150
     1.468    44.855     0.150
     1.487    27.078     0.150
     1.487    45.617     0.150
     1.650    49.617     0.150
     1.650    27.566     0.150
     1.650    48.625     0.150
     1.675    28.828     0.150
     1.675    50.238     0.150
     1.741    31.727     0.150
     1.741    31.367     0.150
     1.751    54.027     0.150
     1.798    32.938     0.150
     1.829    33.637     0.150
     1.830    30.918     0.150
     1.830    33.715     0.150
     1.839    32.805     0.150
     1.856    31.055     0.150
     2.048    36.695     0.150
     2.153    35.168     0.150
     2.202    35.367     0.150
     2.275    35.598     0.150
     2.805    43.418     0.150
     2.921    51.555     0.150
     5.594    84.727     0.150
     0.296     5.906     0.150
     0.296    10.115     0.150
     0.296    10.297     0.150
     0.296    10.416     0.150
     0.352     7.355     0.150
     0.352    12.467     0.150
     0.393     7.297     0.150
     0.393    12.637     0.150
     0.609    11.615     0.150
     0.609    20.246     0.150
     0.609    20.086     0.150
     0.735    13.646     0.150
     0.735    23.945     0.150
     0.735    23.316     0.150
     0.808    14.695     0.150
     0.833    15.557     0.150
     0.833    26.355     0.150
     0.833    28.695     0.150
     0.889    16.037     0.150
     0.889    28.086     0.150
     0.889    15.846     0.150
     0.991    17.627     0.150
     0.991    30.816     0.150
     0.991    30.477     0.150
     1.042    18.727     0.150
     1.042    32.666     0.150
     1.042    35.076     0.150
     1.002    18.986     0.150
     1.002    33.426     0.150
     1.033    18.596     0.150
     1.032    18.566     0.150
     1.035    18.826     0.150
     1.035    31.766     0.150
     1.051    19.387     0.150
     1.051    33.537     0.150
     1.050    18.936     0.150
     1.050    20.406     0.150
     1.050    33.246     0.150
     1.050    35.316     0.150
     1.060    19.166     0.150
     1.060    33.967     0.150
     1.077    19.275     0.150
     1.077    32.736     0.150
     1.077    33.105     0.150
     1.077    33.496     0.150
     1.077    34.467     0.150
     1.122    21.166     0.150
     1.122    37.066     0.150
     1.165    21.936     0.150
     1.182    20.855     0.150
     1.182    36.016     0.150
     1.200    21.047     0.150
     1.200    36.477     0.150
     1.200    36.836     0.150
     1.200    37.355     0.150
     1.256    22.736     0.150
     1.256    22.586     0.150
     1.255    23.457     0.150
     1.269    23.137     0.150
     1.269    39.656     0.150
     1.320    23.877     0.150
     1.320    40.605     0.150
     1.336    24.896     0.150
     1.338    24.605     0.150
     1.339    24.906     0.150
     1.368    24.076     0.150
     1.368    23.855     0.150
     1.455    25.486     0.150
     1.455    26.775     0.150
     1.543    27.457     0.150
     1.572    27.176     0.150
     1.572    27.156     0.150
     1.572    47.525     0.150
     1.588    28.066     0.150
     1.588    48.016     0.150
     1.586    29.047     0.150
     1.613    26.957     0.150
     1.668    29.586     0.150
     1.684    30.877     0.150
     1.684    51.816     0.150
     1.749    28.977     0.150
     1.848    55.426     0.150
     1.876    32.787     0.150
     1.876    56.557     0.150
     1.940    33.275     0.150
     1.951    35.217     0.150
     2.025    34.025     0.150
     2.027    33.887     0.150
     2.039    36.537     0.150
     2.050    34.037     0.150
     2.179    34.316     0.150
     2.197    37.727     0.150
     2.224    35.727     0.150
     2.352    38.525     0.150
     2.468    45.115     0.150
     2.472    39.986     0.150
     2.747    42.996     0.150
     2.747    73.297     0.150
     3.137    49.576     0.150
     3.360    51.127     0.150
     3.387    52.787     0.150
     3.433    53.336     0.150
     4.371    66.576     0.150
     4.397    67.596     0.150
     4.497    68.037     0.150
     4.592    70.316     0.150
     4.929    72.646     0.150
     5.190    76.246     0.150
     5.708    85.717     0.150
     5.764    87.146     0.150
     5.850    88.486     0.150
     5.964    90.346     0.150
     6.000    90.896     0.150
     6.175    89.516     0.150
     6.311    94.377     0.150
     6.435    94.865     0.150
     0.162     4.047     0.150
     0.162     6.773     0.150
     0.162     6.898     0.150
     0.278     5.844     0.150
     0.278     9.906     0.150
     0.278    10.289     0.150
     0.278    10.508     0.150
     0.278     9.805     0.150
     0.504     9.398     0.150
     0.504    16.383     0.150
     0.565    10.914     0.150
     0.565    18.383     0.150
     0.565    18.688     0.150
     0.709    12.945     0.150
     0.709    22.398     0.150
     0.776    14.547     0.150
     0.776    24.547     0.150
     0.927    16.906     0.150
     0.927    29.617     0.150
     1.015    18.227     0.150
     1.015    31.188     0.150
     1.042    18.812     0.150
     1.042    32.008     0.150
     1.042    32.422     0.150
     1.042    33.719     0.150
     1.048    20.523     0.150
     1.081    21.297     0.150
     1.151    22.297     0.150
     1.191    22.062     0.150
     1.191    39.195     0.150
     1.207    22.922     0.150
     1.207    23.703     0.150
     1.207    39.148     0.150
     1.207    39.289     0.150
     1.207    40.055     0.150
     1.347    23.828     0.150
     1.347    42.094     0.150
     1.347    40.727     0.150
     1.376    24.312     0.150
     1.382    25.633     0.150
     1.396    24.344     0.150
     1.396    43.125     0.150
     1.396    25.125     0.150
     1.432    25.648     0.150
     1.432    43.977     0.150
     1.432    26.047     0.150
     1.432    43.773     0.150
     1.432    25.289     0.150
     1.432    44.086     0.150
     1.447    25.469     0.150
     1.447    43.922     0.150
     1.447    25.625     0.150
     1.491    27.523     0.150
     1.491    48.383     0.150
     1.527    27.125     0.150
     1.527    46.398     0.150
     1.580    26.727     0.150
     1.582    29.562     0.150
     1.582    51.156     0.150
     1.637    28.297     0.150
     1.650    28.578     0.150
     1.650    49.883     0.150
     1.650    28.477     0.150
     1.650    50.148     0.150
     1.650    50.812     0.150
     1.680    28.352     0.150
     1.680    52.484     0.150
     1.713    30.266     0.150
     1.713    52.469     0.150
     1.742    27.344     0.150
     1.717    29.703     0.150
     1.797    29.734     0.150
     1.745    30.609     0.150
     1.745    29.930     0.150
     1.745    53.086     0.150
     1.909    30.133     0.150
     1.909    30.328     0.150
     1.919    31.242     0.150
     1.919    58.477     0.150
     1.976    34.133     0.150
     2.029    35.055     0.150
     2.029    60.875     0.150
     2.029    35.227     0.150
     2.040    35.117     0.150
     2.203    35.188     0.150
     2.316    40.273     0.150
     2.361    42.359     0.150
     2.361    41.406     0.150
     2.377    43.328     0.150
     2.391    38.539     0.150
     2.417    39.836     0.150
     2.433    44.633     0.150
     2.435    44.062     0.150
     2.435    74.312     0.150
     2.435    44.609     0.150
     2.435    39.219     0.150
     2.435    74.883     0.150
     2.452    39.398     0.150
     2.467    43.867     0.150
     2.531    39.633     0.150
     2.531    39.453     0.150
     2.531    68.758     0.150
     2.531    69.742     0.150
     2.614    44.836     0.150
     2.636    45.516     0.150
     2.639    45.969     0.150
     2.664    45.953     0.150
     2.664    43.164     0.150
     2.660    42.227     0.150
     2.741    50.039     0.150
     2.743    43.969     0.150
     2.804    44.938     0.150
     2.863    52.492     0.150
     2.945    54.297     0.150
     2.945    92.969     0.150
     2.976    84.297     0.150
     3.171    96.688     0.150
     3.300    99.969     0.150
     3.398    58.539     0.150
     3.408   102.391     0.150
     3.439    59.523     0.150
     3.486    53.812     0.150
     3.593    57.039     0.150
     3.733   114.039     0.150
     3.820    59.773     0.150
     3.820   103.836     0.150
     4.105    63.078     0.150
     4.138    62.648     0.150
     4.215    64.703     0.150
     4.285    63.922     0.150
     4.285    64.359     0.150
     4.285   113.188     0.150
     4.285   112.664     0.150
     4.349    65.578     0.150
     4.502    68.742     0.150
     4.529    68.430     0.150
     4.747    71.109     0.150
     4.794    73.984     0.150
     4.829    72.477     0.150
     4.939    75.664     0.150
     4.939   150.977     0.150
     4.975    74.312     0.150
     4.979    75.312     0.150
     5.245    77.812     0.150
     5.465    80.508     0.150
     5.556    83.273     0.150
     5.572    81.312     0.150
     5.738    84.484     0.150
     5.806    86.414     0.150
     5.865    88.062     0.150
     6.074    91.055     0.150
     6.148    92.117     0.150
     6.175    92.898     0.150
     6.203    92.016     0.150
     6.283    92.734     0.150
     6.283    92.234     0.150
     6.365    94.016     0.150
     6.381    96.172     0.150
     6.553    97.148     0.150
     6.674   192.312     0.150
     6.820    99.844     0.150
     6.820    99.617     0.150
     6.905   101.977     0.150
     7.350   105.508     0.150
     7.437   105.773     0.150
     7.469   236.891     0.150
     8.142   117.523     0.150
     8.240   119.609     0.150
     8.388   122.734     0.150
     8.684   128.125     0.150
     8.802   127.266     0.150
     8.909   129.914     0.150
     8.909   129.688     0.150
     8.920   129.242     0.150
     8.946   128.914     0.150
     8.948   130.688     0.150
     8.952   127.219     0.150
     9.183   133.016     0.150
     9.117   133.594     0.150
     9.188   131.836     0.150
     9.191   132.977     0.150
    10.549   152.477     0.150
    17.015   243.086     0.150
     0.307     6.506     0.150
     0.307    11.326     0.150
     0.307    11.506     0.150
     0.355     7.206     0.150
     0.355    12.376     0.150
     0.355    13.056     0.150
     0.721    13.276     0.150
     0.721    22.746     0.150
     0.740    13.836     0.150
     0.821    14.786     0.150
     0.821    26.256     0.150
     0.879    28.346     0.150
     0.989    18.506     0.150
     0.989    32.306     0.150
     1.071    20.726     0.150
     1.071    35.906     0.150
     1.072    20.346     0.150
     1.072    35.556     0.150
     1.203    21.006     0.150
     1.203    37.456     0.150
     1.219    21.936     0.150
     1.219    38.166     0.150
     1.219    22.176     0.150
     1.219    38.926     0.150
     1.219    39.096     0.150
     1.221    22.176     0.150
     1.285    24.676     0.150
     1.335    22.936     0.150
     1.346    25.636     0.150
     1.381    42.906     0.150
     1.430    24.476     0.150
     1.430    46.226     0.150
     1.444    45.696     0.150
     1.445    44.496     0.150
     1.459    47.956     0.150
     1.463    26.066     0.150
     1.463    45.556     0.150
     1.532    26.256     0.150
     1.532    49.206     0.150
     1.551    27.206     0.150
     1.551    47.816     0.150
     1.551    47.606     0.150
     1.610    28.036     0.150
     1.610    28.816     0.150
     1.610    49.396     0.150
     1.649    26.846     0.150
     1.637    27.003     0.150
     1.637    50.413     0.150
     1.730    53.016     0.150
     1.765    28.906     0.150
     1.765    29.030     0.150
     1.765    55.077     0.150
     1.782    30.307     0.150
     1.782    54.742     0.150
     1.842    33.306     0.150
     1.969    32.066     0.150
     2.129    35.306     0.150
     2.129    35.061     0.150
     2.129    63.298     0.150
     2.129    37.296     0.150
     2.268    35.956     0.150
     2.306    36.832     0.150
     2.441    38.776     0.150
     2.441    75.340     0.150
     2.441    44.580     0.150
     2.441    74.955     0.150
     2.449    38.646     0.150
     2.505    40.006     0.150
     2.701    42.752     0.150
     2.726    43.013     0.150
     2.812    44.795     0.150
     2.879    45.976     0.150
     3.128    48.886     0.150
     3.147    49.089     0.150
     3.189    97.716     0.150
     3.292    51.226     0.150
     3.292    99.876     0.150
     3.415   103.738     0.150
     3.470    59.946     0.150
     3.470   104.847     0.150
     3.683    56.776     0.150
     3.776   116.356     0.150
     3.825    65.541     0.150
     3.947    60.126     0.150
     4.023    60.026     0.150
     4.125    62.656     0.150
     4.125   127.284     0.150
     4.157    71.316     0.150
     4.157   126.910     0.150
     4.393    67.306     0.150
     4.510    67.566     0.150
     4.756   144.947     0.150
     4.775    71.546     0.150
     4.845    72.146     0.150
     4.934    75.016     0.150
     4.949    74.446     0.150
     5.026    75.326     0.150
     5.135    77.140     0.150
     5.152    77.936     0.150
     5.211    77.866     0.150
     5.338    79.856     0.150
     5.534    82.726     0.150
     5.535    82.868     0.150
     5.556    82.586     0.150
     5.638    84.946     0.150
     5.638    84.675     0.150
     5.681    84.376     0.150
     5.875    87.246     0.150
     5.875    88.347     0.150
     5.923    88.046     0.150
     6.039    89.124     0.150
     6.040    88.866     0.150
     6.054    89.906     0.150
     6.143    90.336     0.150
     6.293    91.726     0.150
     6.383    95.116     0.150
     6.410    94.026     0.150
     6.515    94.736     0.150
     6.558    95.286     0.150
     6.558    96.659     0.150
     6.555    95.276     0.150
     6.885   129.046     0.150
     7.281   105.486     0.150
     7.356   106.246     0.150
     7.467   109.661     0.150
     7.467   135.736     0.150
     7.467   233.636     0.150
     7.599   109.286     0.150
     7.604   110.066     0.150
     7.685   112.186     0.150
     8.159   118.286     0.150
     8.159   120.470     0.150
     8.294   119.056     0.150
     8.294   121.414     0.150
     8.294   121.081     0.150
     8.294   258.656     0.150
     8.537   123.066     0.150
     8.537   124.203     0.150
     8.928   127.926     0.150
     8.960   128.456     0.150
     9.001   128.686     0.150
     9.073   130.726     0.150
     9.382   138.892     0.150
     9.382   295.341     0.150
     9.903   140.996     0.150
    10.133   144.586     0.150
    10.311   147.516     0.150
    10.311   149.351     0.150
    10.336   146.986     0.150
    10.343   148.016     0.150
    10.754   151.356     0.150
    10.948   155.516     0.150
    12.306   179.663     0.150
    12.416   175.406     0.150
    13.397   188.786     0.150
    15.337   214.776     0.150
    15.561   218.606     0.150
    15.580   217.656     0.150
    16.166   226.016     0.150
    16.952   234.996     0.150
    16.952   240.955     0.150
    27.085   341.342     0.150
    38.713   446.136     0.150
    41.685   467.636     0.150
     0.284     5.633     0.150
     0.284     9.711     0.150
     0.284     9.820     0.150
     0.347     7.062     0.150
     0.347    11.934     0.150
     0.390     7.301     0.150
     0.390    12.250     0.150
     0.459     8.613     0.150
     0.459    14.801     0.150
     0.459    15.551     0.150
     0.627    11.691     0.150
     0.627    19.883     0.150
     0.627    11.793     0.150
     0.627    20.371     0.150
     0.640    12.113     0.150
     0.640    20.723     0.150
     0.723    13.461     0.150
     0.723    22.633     0.150
     0.794    14.684     0.150
     0.794    25.121     0.150
     0.814    15.363     0.150
     0.814    26.184     0.150
     0.901    16.070     0.150
     0.901    28.703     0.150
     0.901    16.184     0.150
     0.990    18.742     0.150
     0.990    19.191     0.150
     1.002    17.793     0.150
     1.002    30.902     0.150
     1.002    30.422     0.150
     1.040    18.562     0.150
     1.040    32.371     0.150
     1.040    34.773     0.150
     1.031    31.820     0.150
     1.031    18.602     0.150
     1.031    31.672     0.150
     1.031    18.633     0.150
     1.036    17.863     0.150
     1.037    19.000     0.150
     1.037    31.910     0.150
     1.038    18.793     0.150
     1.038    32.312     0.150
     1.055    19.082     0.150
     1.055    33.312     0.150
     1.086    19.363     0.150
     1.086    33.320     0.150
     1.086    19.480     0.150
     1.086    33.113     0.150
     1.114    21.184     0.150
     1.114    36.312     0.150
     1.162    21.863     0.150
     1.162    37.223     0.150
     1.192    20.891     0.150
     1.209    37.410     0.150
     1.209    21.133     0.150
     1.209    36.742     0.150
     1.252    23.203     0.150
     1.252    40.141     0.150
     1.270    23.410     0.150
     1.271    22.082     0.150
     1.271    38.992     0.150
     1.268    23.203     0.150
     1.268    39.602     0.150
     1.336    23.672     0.150
     1.336    41.602     0.150
     1.464    25.613     0.150
     1.464    44.922     0.150
     1.550    27.793     0.150
     1.550    47.383     0.150
     1.583    27.293     0.150
     1.583    47.902     0.150
     1.589    29.184     0.150
     1.589    50.422     0.150
     1.598    28.320     0.150
     1.675    29.992     0.150
     1.675    51.523     0.150
     1.738    28.992     0.150
     1.884    32.781     0.150
     1.945    35.012     0.150
     2.029    34.691     0.150
     2.030    33.641     0.150
     2.053    34.082     0.150
     2.160    34.301     0.150
     2.208    35.594     0.150
     2.211    38.711     0.150
     2.362    38.961     0.150
     2.447    39.684     0.150
     2.462    38.691     0.150
     2.471    45.363     0.150
     2.728    42.230     0.150
     3.115    50.633     0.150
     3.895    60.750     0.150
     4.400    64.934     0.150
     4.594    69.133     0.150
     5.698    84.582     0.150
     0.207     4.385     0.150
     0.207     7.524     0.150
     0.376     7.335     0.150
     0.376    12.395     0.150
     0.472     9.145     0.150
     0.472    15.645     0.150
     0.472    16.035     0.150
     0.472    16.245     0.150
     0.535    10.444     0.150
     0.535    18.015     0.150
     0.519     9.654     0.150
     0.519    17.115     0.150
     0.534     9.875     0.150
     0.534    17.575     0.150
     0.534    10.085     0.150
     0.534    17.404     0.150
     0.534    18.064     0.150
     0.660    11.785     0.150
     0.660    20.814     0.150
     0.660    12.185     0.150
     0.660    21.314     0.150
     0.755    13.665     0.150
     0.755    23.635     0.150
     0.755    24.194     0.150
     0.757    14.024     0.150
     0.757    23.854     0.150
     0.799    14.795     0.150
     0.799    24.935     0.150
     0.833    14.885     0.150
     0.812    14.814     0.150
     0.812    24.774     0.150
     0.812    14.654     0.150
     0.812    14.875     0.150
     0.812    25.425     0.150
     0.819    14.745     0.150
     0.819    25.694     0.150
     0.862    15.935     0.150
     0.888    16.325     0.150
     0.943    16.595     0.150
     0.956    17.055     0.150
     0.956    29.125     0.150
     0.956    16.915     0.150
     0.962    17.545     0.150
     0.962    31.795     0.150
     0.971    17.825     0.150
     0.971    30.795     0.150
     0.962    18.385     0.150
     0.962    31.795     0.150
     0.971    18.965     0.150
     0.977    17.995     0.150
     0.977    30.895     0.150
     0.977    32.925     0.150
     1.028    18.385     0.150
     1.038    18.665     0.150
     1.042    19.295     0.150
     1.050    19.935     0.150
     1.050    34.805     0.150
     1.073    19.395     0.150
     1.073    33.595     0.150
     1.073    33.282     0.150
     1.073    33.395     0.150
     1.073    33.925     0.150
     1.131    20.015     0.150
     1.131    34.385     0.150
     1.124    20.774     0.150
     1.124    35.694     0.150
     1.148    21.944     0.150
     1.212    21.175     0.150
     1.212    36.595     0.150
     1.258    38.734     0.150
     1.267    23.955     0.150
     1.284    22.505     0.150
     1.284    39.524     0.150
     1.284    41.625     0.150
     1.296    23.115     0.150
     1.296    40.225     0.150
     1.287    24.205     0.150
     1.336    23.265     0.150
     1.336    23.395     0.150
     1.336    40.365     0.150
     1.336    23.455     0.150
     1.345    23.715     0.150
     1.312    23.295     0.150
     1.346    24.715     0.150
     1.346    42.415     0.150
     1.421    25.154     0.150
     1.421    43.484     0.150
     1.439    26.274     0.150
     1.439    44.495     0.150
     1.609    28.165     0.150
     1.629    28.365     0.150
     1.693    30.715     0.150
     1.693    52.314     0.150
     1.693    30.274     0.150
     1.704    30.625     0.150
     1.704    52.444     0.150
     1.751    30.774     0.150
     1.776    30.448     0.150
     1.776    54.719     0.150
     1.781    32.925     0.150
     1.783    32.944     0.150
     1.783    55.415     0.150
     1.783    29.975     0.150
     1.783    30.583     0.150
     1.783    54.627     0.150
     1.792    32.035     0.150
     1.808    30.085     0.150
     1.884    31.850     0.150
     1.884    55.682     0.150
     1.950    33.734     0.150
     1.957    34.385     0.150
     1.972    59.274     0.150
     2.002    34.654     0.150
     2.110    35.154     0.150
     2.101    35.325     0.150
     2.148    35.722     0.150
     2.148    67.249     0.150
     2.185    35.245     0.150
     2.227    41.115     0.150
     2.276    35.545     0.150
     2.319    36.505     0.150
     2.502    77.307     0.150
     2.705    46.675     0.150
     2.899    45.455     0.150
     4.007    62.135     0.150
     4.140    63.595     0.150
     4.711    71.935     0.150
     5.089    77.835     0.150
     5.521    83.715     0.150
     5.557    84.564     0.150
     5.826    86.205     0.150
     0.228     5.062     0.150
     0.228     8.227     0.150
     0.228     9.062     0.150
     0.228     9.312     0.150
     0.402     7.750     0.150
     0.402    13.414     0.150
     0.459     8.656     0.150
     0.459    15.094     0.150
     0.643    12.367     0.150
     0.643    20.547     0.150
     0.643    21.016     0.150
     0.665    12.961     0.150
     0.665    21.523     0.150
     0.683    12.844     0.150
     0.768    14.211     0.150
     0.768    24.555     0.150
     0.789    14.516     0.150
     0.789    24.945     0.150
     0.789    25.461     0.150
     0.850    15.891     0.150
     0.906    16.906     0.150
     0.906    30.852     0.150
     0.936    17.312     0.150
     0.943    16.883     0.150
     0.943    17.977     0.150
     0.943    29.000     0.150
     0.943    32.281     0.150
     1.002    18.094     0.150
     1.002    17.945     0.150
     1.002    30.734     0.150
     1.002    31.266     0.150
     1.030    18.797     0.150
     1.030    32.320     0.150
     1.030    18.586     0.150
     1.030    18.555     0.150
     1.057    19.555     0.150
     1.057    35.570     0.150
     1.057    19.422     0.150
     1.041    18.453     0.150
     1.041    32.102     0.150
     1.059    19.281     0.150
     1.059    32.711     0.150
     1.059    32.586     0.150
     1.082    35.914     0.150
     1.095    19.445     0.150
     1.095    33.211     0.150
     1.095    33.680     0.150
     1.139    21.422     0.150
     1.139    36.766     0.150
     1.164    20.656     0.150
     1.164    35.531     0.150
     1.223    21.734     0.150
     1.223    38.930     0.150
     1.286    22.555     0.150
     1.286    38.750     0.150
     1.286    40.375     0.150
     1.319    22.781     0.150
     1.323    24.203     0.150
     1.323    41.703     0.150
     1.323    42.203     0.150
     1.371    24.742     0.150
     1.371    42.023     0.150
     1.369    23.992     0.150
     1.380    25.094     0.150
     1.380    24.602     0.150
     1.654    27.461     0.150
     1.675    28.852     0.150
     1.675    28.594     0.150
     1.675    50.328     0.150
     2.007    31.672     0.150
     2.053    33.531     0.150
     2.053    57.172     0.150
     2.055    33.391     0.150
     2.061    33.555     0.150
     2.061    63.117     0.150
     2.078    33.562     0.150
     2.079    33.664     0.150
     2.295    38.141     0.150
     2.295    68.312     0.150
     2.381    38.352     0.150
     2.387    38.016     0.150
     2.576    40.141     0.150
     2.576    70.109     0.150
     2.576    68.055     0.150
     2.593    41.328     0.150
     2.685    42.078     0.150
     2.685    75.500     0.150
     2.797    45.109     0.150
     2.797    86.180     0.150
     2.829    43.703     0.150
     3.160    49.305     0.150
     3.232    89.930     0.150
     3.236    50.656     0.150
     3.296    51.688     0.150
     3.307    51.156     0.150
     3.300    61.727     0.150
     3.300    98.992     0.150
     3.535    52.297     0.150
     3.535    95.234     0.150
     3.732    58.523     0.150
     3.732   113.852     0.150
     3.808    58.953     0.150
     3.827    59.305     0.150
     3.978    61.734     0.150
     4.175    64.180     0.150
     4.327    64.414     0.150
     4.480    68.953     0.150
     4.611    69.781     0.150
     4.611    70.352     0.150
     4.904    74.875     0.150
     5.329    80.281     0.150
     5.369    80.922     0.150
     5.369    81.125     0.150
     5.617    85.133     0.150
     5.712    85.086     0.150
     5.780    85.281     0.150
     5.784    87.195     0.150
     5.808    87.727     0.150
     5.925    88.805     0.150
     6.165    92.414     0.150
     6.182    90.766     0.150
     6.371    95.922     0.150
     6.489    97.883     0.150
     6.873   100.812     0.150
     6.873   101.086     0.150
     6.873   101.203     0.150
     6.938   102.156     0.150
     7.067   106.297     0.150
     7.462   108.805     0.150
     8.221   120.680     0.150
     8.504   121.836     0.150
    11.288   161.883     0.150
     0.200     4.844     0.150
     0.200     7.957     0.150
     0.200     8.125     0.150
     0.200     8.387     0.150
     0.534    10.926     0.150
     0.534    18.496     0.150
     0.662    12.254     0.150
     0.662    20.887     0.150
     0.662    21.535     0.150
     0.662    22.215     0.150
     0.623    12.234     0.150
     0.623    20.504     0.150
     0.623    21.305     0.150
     1.082    20.047     0.150
     1.110    20.336     0.150
     1.348    23.066     0.150
     1.342    23.824     0.150
     1.437    24.434     0.150
     1.438    27.145     0.150
     1.449    27.164     0.150
     1.479    26.156     0.150
     1.505    26.465     0.150
     1.505    49.176     0.150
     1.560    29.387     0.150
     1.592    26.906     0.150
     1.646    27.484     0.150
     1.641    27.945     0.150
     1.669    31.016     0.150
     1.772    29.457     0.150
     1.804    30.184     0.150
     1.804    54.746     0.150
     1.804    30.797     0.150
     1.804    55.254     0.150
     1.831    30.691     0.150
     1.831    30.824     0.150
     1.901    32.137     0.150
     1.901    57.266     0.150
     2.028    32.707     0.150
     2.028    32.934     0.150
     2.094    34.934     0.150
     2.163    35.707     0.150
     2.163    35.984     0.150
     2.173    36.035     0.150
     2.174    38.535     0.150
     2.277    37.516     0.150
     2.308    37.195     0.150
     2.308    63.570     0.150
     2.308    36.777     0.150
     2.308    63.766     0.150
     2.350    38.965     0.150
     2.378    38.707     0.150
     2.492    39.305     0.150
     2.492    39.664     0.150
     2.482    40.527     0.150
     2.482    74.391     0.150
     2.523    40.734     0.150
     2.688    42.605     0.150
     2.830    44.332     0.150
     3.140    51.254     0.150
     3.092    48.527     0.150
     3.100    48.699     0.150
     3.184    49.820     0.150
     3.292    52.566     0.150
     3.446    53.500     0.150
     3.446    94.730     0.150
     3.458    53.660     0.150
     3.576    55.930     0.150
     3.618    55.828     0.150
     3.824    58.988     0.150
     3.829    59.445     0.150
     3.844    59.266     0.150
     3.960    62.203     0.150
     4.039    61.539     0.150
     4.166    75.570     0.150
     4.185    75.281     0.150
     4.487    79.336     0.150
     4.487   139.074     0.150
     4.494    87.305     0.150
     4.517    68.824     0.150
     4.941    75.938     0.150
     5.405    82.117     0.150
     5.412    82.145     0.150
     5.582    84.027     0.150
     0.238     5.129     0.150
     0.238     8.660     0.150
     0.391     7.730     0.150
     0.391    12.789     0.150
     0.391    13.988     0.150
     0.478     9.117     0.150
     0.478    15.598     0.150
     0.478    15.898     0.150
     0.478    16.148     0.150
     0.483     9.527     0.150
     0.483    16.180     0.150
     0.483    16.527     0.150
     0.483    17.090     0.150
     0.493     9.488     0.150
     0.493    16.090     0.150
     0.493    16.539     0.150
     0.535    10.520     0.150
     0.535    18.000     0.150
     0.535    18.609     0.150
     0.696    12.918     0.150
     0.696    22.219     0.150
     0.696    21.988     0.150
     0.769    14.559     0.150
     0.794    14.449     0.150
     0.794    24.648     0.150
     0.843    15.738     0.150
     0.843    26.273     0.150
     0.854    15.789     0.150
     0.854    26.570     0.150
     0.854    15.758     0.150
     0.854    26.641     0.150
     0.853    16.078     0.150
     0.853    27.488     0.150
     0.874    15.820     0.150
     0.874    27.059     0.150
     0.874    27.258     0.150
     0.900    16.730     0.150
     0.900    28.609     0.150
     0.912    17.707     0.150
     0.912    30.098     0.150
     0.931    17.090     0.150
     0.931    29.020     0.150
     0.931    29.348     0.150
     0.955    17.680     0.150
     0.955    30.480     0.150
     0.982    17.551     0.150
     0.982    30.168     0.150
     0.974    17.668     0.150
     0.974    18.398     0.150
     0.974    30.250     0.150
     0.974    33.277     0.150
     0.998    30.438     0.150
     0.998    17.809     0.150
     0.995    18.949     0.150
     0.995    33.520     0.150
     1.002    18.891     0.150
     1.002    32.828     0.150
     1.002    18.859     0.150
     1.002    19.809     0.150
     1.002    34.148     0.150
     1.005    18.758     0.150
     1.005    33.570     0.150
     1.065    19.160     0.150
     1.065    33.000     0.150
     1.071    19.738     0.150
     1.071    33.391     0.150
     1.085    20.168     0.150
     1.085    34.969     0.150
     1.089    20.527     0.150
     1.089    36.629     0.150
     1.097    21.180     0.150
     1.097    36.910     0.150
     1.118    20.367     0.150
     1.141    22.078     0.150
     1.170    20.879     0.150
     1.170    35.480     0.150
     1.165    21.301     0.150
     1.165    36.980     0.150
     1.185    39.301     0.150
     1.240    21.789     0.150
     1.240    37.859     0.150
     1.240    39.879     0.150
     1.240    40.328     0.150
     1.253    22.000     0.150
     1.253    38.078     0.150
     1.329    25.199     0.150
     1.327    23.309     0.150
     1.327    43.457     0.150
     1.340    23.910     0.150
     1.340    41.320     0.150
     1.342    23.500     0.150
     1.375    24.270     0.150
     1.375    24.145     0.150
     1.375    41.375     0.150
     1.375    24.379     0.150
     1.375    41.617     0.150
     1.386    24.469     0.150
     1.386    42.188     0.150
     1.390    25.188     0.150
     1.390    44.398     0.150
     1.465    26.141     0.150
     1.465    45.527     0.150
     1.483    26.777     0.150
     1.503    25.480     0.150
     1.503    44.117     0.150
     1.649    29.000     0.150
     1.649    49.301     0.150
     1.645    28.738     0.150
     1.645    27.543     0.150
     1.645    48.223     0.150
     1.672    29.238     0.150
     1.672    50.707     0.150
     1.737    31.590     0.150
     1.737    30.430     0.150
     1.748    31.578     0.150
     1.748    53.840     0.150
     1.795    31.340     0.150
     1.813    31.969     0.150
     1.821    31.086     0.150
     1.821    56.262     0.150
     1.825    31.238     0.150
     1.827    30.750     0.150
     1.827    33.551     0.150
     1.827    31.062     0.150
     1.827    56.504     0.150
     1.827    31.172     0.150
     1.827    56.246     0.150
     1.836    33.090     0.150
     1.852    31.367     0.150
     1.852    30.949     0.150
     1.924    32.340     0.150
     1.924    55.707     0.150
     2.000    35.238     0.150
     2.014    34.266     0.150
     2.014    60.113     0.150
     2.045    35.508     0.150
     2.145    39.430     0.150
     2.151    36.238     0.150
     2.191    36.230     0.150
     2.191    68.859     0.150
     2.198    35.527     0.150
     2.265    35.180     0.150
     2.295    37.957     0.150
     2.351    38.000     0.150
     2.378    38.273     0.150
     2.378    67.656     0.150
     2.480    40.148     0.150
     2.520    39.668     0.150
     2.520    69.918     0.150
     2.545    45.176     0.150
     2.545    78.188     0.150
     2.747    47.379     0.150
     2.757    44.457     0.150
     2.757    83.055     0.150
     2.803    43.270     0.150
     2.803    76.668     0.150
     2.803    43.148     0.150
     2.803    75.879     0.150
     2.939    47.008     0.150
     2.982    43.758     0.150
     2.995    47.562     0.150
     3.023    85.254     0.150
     3.079    48.449     0.150
     3.153    49.551     0.150
     3.153    96.348     0.150
     3.205    50.777     0.150
     3.230    89.008     0.150
     3.364    52.648     0.150
     3.453   103.723     0.150
     3.537    55.930     0.150
     3.561    96.156     0.150
     3.702    58.348     0.150
     3.771    58.980     0.150
     4.048    62.809     0.150
     4.178    65.488     0.150
     4.198    63.891     0.150
     4.326    66.891     0.150
     4.395    67.738     0.150
     4.468    69.398     0.150
     4.542    67.277     0.150
     4.542    67.730     0.150
     4.542    66.719     0.150
     4.542   118.008     0.150
     4.699    71.777     0.150
     4.753    73.180     0.150
     4.994    75.969     0.150
     5.283    80.148     0.150
     5.407    82.738     0.150
     5.407    82.277     0.150
     5.563    84.988     0.150
     5.589    85.238     0.150
     5.761    87.109     0.150
     5.833    89.277     0.150
     5.829    87.719     0.150
     5.835    86.539     0.150
     5.862    89.078     0.150
     5.991    88.328     0.150
     6.159    93.469     0.150
     6.262    94.391     0.150
     6.262    93.949     0.150
     6.434    98.020     0.150
     6.543    96.020     0.150
     6.726    98.648     0.150
     6.851   103.285     0.150
     7.003   103.559     0.150
     7.088   103.758     0.150
     7.088   103.246     0.150
     7.141   104.988     0.150
     7.322   108.367     0.150
     7.537   110.891     0.150
     8.271   122.617     0.150
     8.949   132.625     0.150
     9.129   132.031     0.150
     9.566   137.848     0.150
     9.655   139.250     0.150
    10.996   158.320     0.150
    10.997   158.809     0.150
    10.997   159.070     0.150
    38.062   440.680     0.150
     0.210     4.609     0.150
     0.210     8.180     0.150
     0.210     7.930     0.150
     0.210     8.309     0.150
     0.464     9.238     0.150
     0.464    15.418     0.150
     0.494     9.379     0.150
     0.494    15.848     0.150
     0.494    16.359     0.150
     0.486     9.648     0.150
     0.486    16.488     0.150
     0.570    10.707     0.150
     0.570    18.410     0.150
     0.582    10.910     0.150
     0.582    18.668     0.150
     0.665    12.348     0.150
     0.665    21.969     0.150
     0.827    15.891     0.150
     0.827    27.219     0.150
     0.894    17.438     0.150
     0.894    30.258     0.150
     0.926    18.219     0.150
     0.926    30.750     0.150
     0.977    17.898     0.150
     0.977    30.840     0.150
     0.977    17.770     0.150
     0.992    17.988     0.150
     0.992    30.910     0.150
     0.974    17.801     0.150
     0.974    30.668     0.150
     0.974    31.680     0.150
     1.012    18.430     0.150
     1.012    32.277     0.150
     1.114    21.699     0.150
     1.114    37.098     0.150
     1.130    20.520     0.150
     1.130    36.141     0.150
     1.148    22.270     0.150
     1.148    38.051     0.150
     1.157    36.168     0.150
     1.157    20.918     0.150
     1.188    22.707     0.150
     1.188    39.301     0.150
     1.206    22.098     0.150
     1.206    37.809     0.150
     1.206    21.957     0.150
     1.206    37.340     0.150
     1.208    22.219     0.150
     1.208    37.270     0.150
     1.239    22.027     0.150
     1.239    40.449     0.150
     1.294    23.199     0.150
     1.294    39.578     0.150
     1.294    40.359     0.150
     1.354    41.590     0.150
     1.354    24.348     0.150
     1.354    41.309     0.150
     1.475    26.328     0.150
     1.475    44.730     0.150
     1.475    26.078     0.150
     1.475    45.988     0.150
     1.475    46.098     0.150
     1.476    26.328     0.150
     1.570    28.109     0.150
     1.570    27.617     0.150
     1.586    28.699     0.150
     1.667    29.570     0.150
     1.730    30.738     0.150
     1.773    32.301     0.150
     1.865    33.109     0.150
     1.872    32.480     0.150
     1.872    33.160     0.150
     1.876    34.957     0.150
     1.896    34.898     0.150
     1.985    32.527     0.150
     2.119    37.918     0.150
     2.145    39.617     0.150
     2.209    36.109     0.150
     2.256    41.957     0.150
     2.398    38.449     0.150
     2.434    44.348     0.150
     2.408    37.750     0.150
     2.626    42.789     0.150
     4.162    64.410     0.150
     4.528    69.160     0.150
     5.811    87.988     0.150
     5.941    89.828     0.150
     0.079     3.740     0.150
     0.079     6.121     0.150
     0.290     6.432     0.150
     0.290    10.592     0.150
     0.333     7.352     0.150
     0.333    12.650     0.150
     0.333    11.611     0.150
     0.333    12.910     0.150
     0.333    13.070     0.150
     0.402     8.291     0.150
     0.402    13.730     0.150
     0.428     8.832     0.150
     0.428    14.660     0.150
     0.428    15.441     0.150
     0.412     8.410     0.150
     0.412    14.051     0.150
     0.492     9.631     0.150
     0.492    16.451     0.150
     0.491     9.682     0.150
     0.491    16.291     0.150
     0.602    11.150     0.150
     0.593    11.092     0.150
     0.593    19.160     0.150
     0.593    19.291     0.150
     0.593    19.461     0.150
     0.683    12.490     0.150
     0.683    21.342     0.150
     0.694    12.801     0.150
     0.694    22.012     0.150
     0.694    12.691     0.150
     0.694    21.881     0.150
     0.721    13.391     0.150
     0.721    22.871     0.150
     0.721    22.625     0.150
     0.766    14.291     0.150
     0.766    14.240     0.150
     0.783    14.160     0.150
     0.807    14.332     0.150
     0.807    25.021     0.150
     0.839    15.281     0.150
     0.839    26.781     0.150
     0.839    29.471     0.150
     0.848    15.910     0.150
     0.862    15.621     0.150
     0.862    26.891     0.150
     0.866    16.121     0.150
     0.866    28.592     0.150
     0.866    15.871     0.150
     0.868    16.070     0.150
     0.868    27.352     0.150
     0.938    17.871     0.150
     0.938    30.701     0.150
     0.954    29.561     0.150
     0.954    17.291     0.150
     0.955    18.150     0.150
     0.955    31.711     0.150
     0.969    29.582     0.150
     0.969    17.221     0.150
     0.978    18.051     0.150
     0.978    31.422     0.150
     0.986    19.332     0.150
     0.986    32.910     0.150
     0.987    19.252     0.150
     0.987    33.342     0.150
     1.004    18.410     0.150
     1.019    19.221     0.150
     1.019    33.461     0.150
     1.059    31.900     0.150
     1.059    18.451     0.150
     1.080    33.922     0.150
     1.080    19.623     0.150
     1.080    33.613     0.150
     1.081    19.781     0.150
     1.081    34.451     0.150
     1.084    19.910     0.150
     1.094    19.471     0.150
     1.094    33.490     0.150
     1.109    20.221     0.150
     1.109    34.441     0.150
     1.133    20.320     0.150
     1.148    35.861     0.150
     1.148    36.832     0.150
     1.173    20.582     0.150
     1.173    20.424     0.150
     1.173    35.531     0.150
     1.405    24.301     0.150
     1.653    27.752     0.150
     1.653    46.973     0.150
     1.671    28.031     0.150
     1.671    28.238     0.150
     1.671    51.076     0.150
     1.824    30.902     0.150
     1.824    54.748     0.150
     1.845    30.748     0.150
     1.845    51.795     0.150
     1.955    32.672     0.150
     2.066    33.861     0.150
     2.066    63.369     0.150
     2.177    34.285     0.150
     2.177    66.342     0.150
     2.282    36.752     0.150
     2.315    35.443     0.150
     2.315    63.584     0.150
     2.375    71.625     0.150
     2.406    38.082     0.150
     2.433    37.432     0.150
     2.566    40.201     0.150
     2.566    76.680     0.150
     2.882    45.268     0.150
     2.882    88.369     0.150
     2.950    45.252     0.150
     2.950    79.887     0.150
     3.262    97.736     0.150
     3.360    89.861     0.150
     3.379    53.021     0.150
     4.245    65.201     0.150
     5.563    84.781     0.150
     5.812    88.570     0.150
     0.132     3.082     0.150
     0.132     5.184     0.150
     0.154     3.254     0.150
     0.211     4.363     0.150
     0.211     7.402     0.150
     0.252     5.082     0.150
     0.252     8.551     0.150
     0.434     8.594     0.150
     0.434    14.781     0.150
     0.514    17.133     0.150
     0.514     9.703     0.150
     0.514     9.883     0.150
     0.514    17.031     0.150
     0.514    18.164     0.150
     0.658    12.953     0.150
     0.658    22.113     0.150
     0.666    13.473     0.150
     0.673    12.633     0.150
     0.719    13.613     0.150
     0.719    15.004     0.150
     0.719    23.371     0.150
     0.729    13.723     0.150
     0.729    23.664     0.150
     0.729    13.883     0.150
     0.729    23.312     0.150
     0.737    14.984     0.150
     0.744    14.223     0.150
     0.744    24.504     0.150
     0.746    13.641     0.150
     0.746    23.652     0.150
     0.746    13.863     0.150
     0.765    15.383     0.150
     0.777    14.941     0.150
     0.785    14.582     0.150
     0.785    25.137     0.150
     0.786    15.961     0.150
     0.797    16.082     0.150
     0.798    15.012     0.150
     0.807    16.324     0.150
     0.832    15.582     0.150
     0.832    26.852     0.150
     0.832    26.602     0.150
     0.853    16.613     0.150
     0.888    17.094     0.150
     0.905    17.324     0.150
     0.904    16.402     0.150
     0.904    28.113     0.150
     0.906    17.254     0.150
     0.906    28.793     0.150
     0.923    17.891     0.150
     0.944    18.383     0.150
     0.944    32.164     0.150
     0.947    18.742     0.150
     0.946    17.113     0.150
     0.946    29.961     0.150
     0.946    16.992     0.150
     0.946    29.254     0.150
     0.987    18.551     0.150
     1.036    19.273     0.150
     1.036    33.512     0.150
     1.036    32.734     0.150
     1.085    19.684     0.150
     1.112    20.445     0.150
     1.112    34.891     0.150
     1.117    20.383     0.150
     1.180    21.094     0.150
     1.216    22.262     0.150
     1.267    22.531     0.150
     1.317    23.301     0.150
     1.323    23.832     0.150
     1.323    41.082     0.150
     1.327    23.461     0.150
     1.327    40.824     0.150
     1.411    24.422     0.150
     1.411    43.230     0.150
     1.456    25.434     0.150
     1.471    26.551     0.150
     1.471    25.762     0.150
     1.471    44.711     0.150
     1.769    30.105     0.150
     1.769    51.859     0.150
     1.787    30.191     0.150
     1.787    54.500     0.150
     1.787    54.258     0.150
     1.930    32.113     0.150
     1.941    30.992     0.150
     2.030    32.242     0.150
     2.054    34.555     0.150
     2.054    62.738     0.150
     2.095    34.879     0.150
     2.095    60.910     0.150
     2.133    35.094     0.150
     2.208    36.914     0.150
     2.313    37.879     0.150
     2.396    38.223     0.150
     2.529    41.695     0.150
     2.548    39.883     0.150
     2.551    40.602     0.150
     2.657    42.379     0.150
     2.657    74.777     0.150
     2.762    44.074     0.150
     2.762    78.660     0.150
     2.770    43.465     0.150
     2.797    44.699     0.150
     2.797    86.184     0.150
     2.873    45.746     0.150
     2.949    46.777     0.150
     3.015    47.594     0.150
     3.022    47.836     0.150
     3.124    49.449     0.150
     3.158    50.410     0.150
     3.158    95.367     0.150
     3.301    50.234     0.150
     3.301    50.832     0.150
     3.411    52.684     0.150
     3.411    53.434     0.150
     3.411    94.379     0.150
     3.485    54.848     0.150
     3.485   106.059     0.150
     3.488    54.633     0.150
     3.488    54.215     0.150
     3.522    54.641     0.150
     3.533    65.984     0.150
     3.567    55.852     0.150
     3.726    57.754     0.150
     3.833    59.484     0.150
     3.891    59.844     0.150
     3.893    60.582     0.150
     4.002    61.395     0.150
     4.085    62.727     0.150
     4.271    63.961     0.150
     4.282    63.641     0.150
     4.282    64.164     0.150
     4.328    66.352     0.150
     4.323    72.184     0.150
     4.355    66.672     0.150
     4.370    66.711     0.150
     4.480    69.242     0.150
     4.619    70.773     0.150
     4.633    70.543     0.150
     4.778    73.781     0.150
     4.874    75.027     0.150
     4.899    75.230     0.150
     4.921    75.031     0.150
     5.044    77.445     0.150
     5.159    78.531     0.150
     5.159    79.168     0.150
     5.591    83.684     0.150
     5.998    90.430     0.150
     6.431    96.578     0.150
     6.821   124.887     0.150
     6.827    99.531     0.150
     6.827   100.352     0.150
     8.020   119.531     0.150
     8.383   122.910     0.150
     8.833   129.914     0.150
     8.876   129.223     0.150
     9.167   294.680     0.150
     9.323   135.332     0.150
     9.400   137.871     0.150
    10.241   149.898     0.150
    10.277   148.742     0.150
    10.540   152.461     0.150
    10.768   155.691     0.150
    10.769   155.641     0.150
    10.769   156.461     0.150
    10.769   340.062     0.150
    11.922   174.516     0.150
    11.922   171.672     0.150
    11.975   175.527     0.150
    16.370   233.473     0.150
    16.370   230.656     0.150
    16.501   231.523     0.150
    18.781   261.184     0.150
    20.985   284.344     0.150
    23.571   312.012     0.150
    23.571   312.113     0.150
    38.057   440.129     0.150
    95.409   805.062     0.150
     0.148     3.418     0.150
     0.148     5.527     0.150
     0.516     9.918     0.150
     0.516    16.719     0.150
     0.669    13.438     0.150
     0.723    13.520     0.150
     0.723    15.008     0.150
     0.723    23.770     0.150
     0.743    14.277     0.150
     0.743    24.578     0.150
     0.721    13.840     0.150
     0.743    23.328     0.150
     0.743    14.020     0.150
     0.787    15.930     0.150
     0.780    14.648     0.150
     0.780    24.648     0.150
     0.807    16.230     0.150
     0.807    27.930     0.150
     0.824    15.668     0.150
     0.824    26.629     0.150
     0.824    15.387     0.150
     0.851    16.770     0.150
     0.851    29.160     0.150
     0.881    17.508     0.150
     0.897    16.367     0.150
     0.897    27.660     0.150
     0.910    17.129     0.150
     0.910    28.539     0.150
     0.943    18.258     0.150
     0.943    31.668     0.150
     0.948    18.609     0.150
     0.948    33.008     0.150
     0.940    17.559     0.150
     0.940    29.148     0.150
     0.984    18.629     0.150
     0.984    31.520     0.150
     1.004    19.129     0.150
     1.004    33.508     0.150
     1.014    19.770     0.150
     1.014    34.207     0.150
     1.034    19.547     0.150
     1.034    32.898     0.150
     1.034    32.766     0.150
     1.057    32.719     0.150
     1.057    19.219     0.150
     1.087    20.109     0.150
     1.087    36.910     0.150
     1.070    19.430     0.150
     1.070    33.168     0.150
     1.119    20.648     0.150
     1.107    20.559     0.150
     1.107    34.949     0.150
     1.107    34.355     0.150
     1.173    36.418     0.150
     1.205    23.438     0.150
     1.208    22.449     0.150
     1.208    38.488     0.150
     1.277    22.410     0.150
     1.261    22.637     0.150
     1.261    38.637     0.150
     1.311    23.438     0.150
     1.311    40.559     0.150
     1.343    24.598     0.150
     1.343    42.137     0.150
     1.389    43.250     0.150
     1.414    42.738     0.150
     1.419    43.949     0.150
     1.448    45.738     0.150
     1.445    25.809     0.150
     1.445    44.688     0.150
     1.466    26.539     0.150
     1.466    46.047     0.150
     1.464    26.398     0.150
     1.464    26.141     0.150
     1.464    44.605     0.150
     1.464    26.207     0.150
     1.690    29.988     0.150
     1.690    52.137     0.150
     1.715    32.219     0.150
     1.722    30.449     0.150
     1.734    30.160     0.150
     1.769    29.980     0.150
     1.769    51.633     0.150
     1.771    33.328     0.150
     1.783    30.250     0.150
     1.783    33.539     0.150
     1.783    55.320     0.150
     1.798    30.438     0.150
     1.798    56.270     0.150
     1.826    33.699     0.150
     1.936    31.848     0.150
     1.988    33.828     0.150
     2.003    34.109     0.150
     2.007    34.059     0.150
     2.048    35.008     0.150
     2.048    62.262     0.150
     2.055    34.797     0.150
     2.092    34.828     0.150
     2.092    60.062     0.150
     2.135    36.508     0.150
     2.200    36.707     0.150
     2.202    37.168     0.150
     2.313    38.547     0.150
     2.524    42.000     0.150
     2.524    41.742     0.150
     2.524    78.285     0.150
     2.556    40.578     0.150
     2.556    40.461     0.150
     2.556    71.332     0.150
     2.544    71.047     0.150
     2.650    42.332     0.150
     2.650    74.527     0.150
     2.755    83.820     0.150
     2.792    48.770     0.150
     2.792    84.734     0.150
     3.113    49.777     0.150
     3.152    95.410     0.150
     3.484    54.438     0.150
     3.480   105.793     0.150
     3.568    57.078     0.150
     3.635   109.086     0.150
     4.264    66.148     0.150
     4.289    65.078     0.150
     4.325    67.137     0.150
     4.442    67.828     0.150
     5.041    77.879     0.150
     5.372    81.449     0.150
     5.517    82.969     0.150
     5.568    83.980     0.150
     5.664    86.988     0.150
     5.980    90.430     0.150
     0.146     3.229     0.150
     0.136     3.009     0.150
     0.136     5.060     0.150
     0.136     6.429     0.150
     0.425     8.319     0.150
     0.425    14.569     0.150
     0.516     9.759     0.150
     0.516    16.699     0.150
     0.516    16.829     0.150
     0.507     9.819     0.150
     0.507    17.689     0.150
     0.720    13.589     0.150
     0.720    23.279     0.150
     0.658    12.629     0.150
     0.658    21.879     0.150
     0.669    13.749     0.150
     0.790    14.859     0.150
     0.790    25.270     0.150
     0.724    14.859     0.150
     0.742    13.719     0.150
     0.742    23.629     0.150
     0.742    13.689     0.150
     0.743    14.060     0.150
     0.743    24.199     0.150
     0.786    14.799     0.150
     0.786    25.779     0.150
     0.743    15.169     0.150
     0.779    14.469     0.150
     0.779    24.819     0.150
     0.823    15.449     0.150
     0.823    26.419     0.150
     0.787    15.639     0.150
     0.807    16.039     0.150
     0.911    17.299     0.150
     0.911    29.489     0.150
     0.895    16.219     0.150
     0.895    27.689     0.150
     0.895    28.600     0.150
     0.851    16.350     0.150
     0.851    28.270     0.150
     0.882    17.310     0.150
     0.938    16.729     0.150
     0.938    29.449     0.150
     0.938    16.879     0.150
     0.942    18.079     0.150
     0.948    18.469     0.150
     0.948    32.709     0.150
     0.984    18.449     0.150
     1.004    34.310     0.150
     1.014    19.659     0.150
     1.014    34.770     0.150
     1.056    32.629     0.150
     1.068    19.209     0.150
     1.106    20.429     0.150
     1.172    21.409     0.150
     1.172    36.179     0.150
     1.207    22.469     0.150
     1.207    38.029     0.150
     1.207    21.879     0.150
     1.205    40.139     0.150
     1.259    22.569     0.150
     1.259    38.429     0.150
     1.259    22.270     0.150
     1.314    23.539     0.150
     1.342    24.539     0.150
     1.332    25.479     0.150
     1.443    25.729     0.150
     1.463    25.609     0.150
     1.463    26.129     0.150
     1.463    44.299     0.150
     1.414    24.409     0.150
     1.447    45.739     0.150
     1.465    26.719     0.150
     1.465    46.199     0.150
     1.688    30.060     0.150
     1.721    52.049     0.150
     1.714    31.889     0.150
     1.714    32.020     0.150
     1.770    30.489     0.150
     1.782    30.209     0.150
     1.797    30.399     0.150
     1.797    56.819     0.150
     1.825    34.189     0.150
     1.937    31.949     0.150
     2.005    35.949     0.150
     2.136    36.239     0.150
     2.201    37.159     0.150
     2.233    38.989     0.150
     2.557    40.229     0.150
     3.116    49.999     0.150
     3.114    49.739     0.150
     3.483    54.909     0.150
     3.568    56.520     0.150
     4.443    68.279     0.150
     5.372    81.779     0.150
     5.664    85.499     0.150
     0.261     5.189     0.150
     0.261     8.830     0.150
     0.401     7.719     0.150
     0.401    13.090     0.150
     0.433     8.490     0.150
     0.433    14.029     0.150
     0.424     8.189     0.150
     0.424    14.279     0.150
     0.530    10.379     0.150
     0.590    11.820     0.150
     0.590    20.910     0.150
     0.672    13.949     0.150
     0.663    13.830     0.150
     0.696    14.170     0.150
     0.696    14.279     0.150
     0.736    13.969     0.150
     0.736    23.070     0.150
     0.714    14.799     0.150
     0.755    14.430     0.150
     0.755    25.199     0.150
     0.855    17.219     0.150
     0.878    16.250     0.150
     0.878    27.980     0.150
     0.889    17.279     0.150
     0.889    30.889     0.150
     0.945    17.609     0.150
     0.945    29.959     0.150
     0.945    33.010     0.150
     0.919    16.959     0.150
     0.919    16.990     0.150
     0.930    18.150     0.150
     0.930    31.869     0.150
     0.996    18.379     0.150
     0.996    31.480     0.150
     0.986    18.090     0.150
     0.986    30.389     0.150
     0.986    30.539     0.150
     0.988    18.779     0.150
     0.988    32.559     0.150
     1.027    19.900     0.150
     1.027    35.510     0.150
     1.079    19.779     0.150
     1.079    34.559     0.150
     1.079    19.930     0.150
     1.079    33.990     0.150
     1.077    20.240     0.150
     1.150    20.570     0.150
     1.150    35.029     0.150
     1.150    35.559     0.150
     1.158    21.680     0.150
     1.158    36.889     0.150
     1.188    21.520     0.150
     1.142    22.049     0.150
     1.230    22.070     0.150
     1.230    37.969     0.150
     1.230    40.289     0.150
     1.303    40.039     0.150
     1.463    26.070     0.150
     1.463    26.570     0.150
     1.714    29.820     0.150
     1.809    30.150     0.150
     1.979    32.180     0.150
     2.343    37.299     0.150
     2.440    42.430     0.150
     3.041    48.309     0.150
     3.593    56.750     0.150
     4.342    66.730     0.150
     5.370    82.129     0.150
     0.139     3.129     0.150
     0.139     5.080     0.150
     0.139     5.510     0.150
     0.139     5.648     0.150
     0.157     3.568     0.150
     0.157     5.910     0.150
     0.507     9.879     0.150
     0.507    16.750     0.150
     0.507    17.000     0.150
     0.507    17.270     0.150
     0.665    12.379     0.150
     0.665    22.068     0.150
     0.672    13.609     0.150
     0.672    23.479     0.150
     0.726    15.090     0.150
     0.726    13.939     0.150
     0.726    23.750     0.150
     0.726    24.219     0.150
     0.742    15.119     0.150
     0.751    14.309     0.150
     0.752    13.750     0.150
     0.752    23.398     0.150
     0.775    14.818     0.150
     0.775    25.080     0.150
     0.790    14.779     0.150
     0.790    25.059     0.150
     0.793    14.910     0.150
     0.793    27.289     0.150
     0.794    15.240     0.150
     0.794    25.680     0.150
     0.814    16.289     0.150
     0.814    28.189     0.150
     0.833    15.240     0.150
     0.833    15.818     0.150
     0.833    26.750     0.150
     0.860    16.629     0.150
     0.860    28.449     0.150
     0.887    17.549     0.150
     0.905    16.520     0.150
     0.905    28.289     0.150
     0.905    28.420     0.150
     0.901    17.260     0.150
     0.901    28.680     0.150
     0.901    29.139     0.150
     0.951    18.439     0.150
     0.949    17.000     0.150
     0.949    29.850     0.150
     0.949    29.680     0.150
     0.954    18.689     0.150
     0.993    18.740     0.150
     1.010    19.340     0.150
     1.010    33.799     0.150
     1.021    20.068     0.150
     1.021    34.479     0.150
     1.043    33.479     0.150
     1.067    19.410     0.150
     1.067    33.420     0.150
     1.079    19.469     0.150
     1.079    33.609     0.150
     1.091    20.020     0.150
     1.117    20.709     0.150
     1.152    38.600     0.150
     1.182    21.449     0.150
     1.182    36.818     0.150
     1.182    21.039     0.150
     1.182    36.699     0.150
     1.217    39.029     0.150
     1.217    22.430     0.150
     1.270    22.680     0.150
     1.281    22.369     0.150
     1.320    23.529     0.150
     1.323    23.660     0.150
     1.320    23.520     0.150
     1.320    40.979     0.150
     1.320    44.479     0.150
     1.343    24.699     0.150
     1.353    24.750     0.150
     1.353    42.979     0.150
     1.428    44.549     0.150
     1.454    25.809     0.150
     1.454    45.289     0.150
     1.474    25.590     0.150
     1.474    25.979     0.150
     1.474    44.879     0.150
     1.476    26.949     0.150
     1.476    46.139     0.150
     1.699    30.068     0.150
     1.725    29.740     0.150
     1.732    30.520     0.150
     1.732    52.789     0.150
     1.744    32.279     0.150
     1.781    30.830     0.150
     1.793    30.090     0.150
     1.808    30.439     0.150
     1.835    33.809     0.150
     1.935    32.020     0.150
     1.997    35.330     0.150
     2.013    34.199     0.150
     2.016    35.680     0.150
     2.065    36.709     0.150
     2.096    38.930     0.150
     2.140    36.330     0.150
     2.209    41.930     0.150
     2.212    37.420     0.150
     2.551    40.479     0.150
     2.658    40.010     0.150
     2.794    48.760     0.150
     3.044    53.430     0.150
     3.115    49.789     0.150
     3.301    62.930     0.150
     4.285   128.289     0.150
     4.443    68.330     0.150
     5.377    82.180     0.150
     5.670    86.318     0.150
     0.142     3.336     0.150
     0.142     5.547     0.150
     0.131     3.156     0.150
     0.131     5.227     0.150
     0.523     9.906     0.150
     0.523    16.969     0.150
     0.503    10.008     0.150
     0.651    12.539     0.150
     0.651    21.809     0.150
     0.664    13.516     0.150
     0.664    23.648     0.150
     0.735    13.809     0.150
     0.735    23.426     0.150
     0.735    13.855     0.150
     0.736    14.137     0.150
     0.736    24.258     0.150
     0.792    15.047     0.150
     0.792    25.488     0.150
     0.739    15.469     0.150
     0.773    14.719     0.150
     0.773    24.746     0.150
     0.773    24.938     0.150
     0.781    15.727     0.150
     0.781    27.789     0.150
     0.820    15.586     0.150
     0.820    26.426     0.150
     0.820    26.719     0.150
     0.820    27.516     0.150
     0.801    16.168     0.150
     0.844    16.406     0.150
     0.844    28.637     0.150
     0.891    16.328     0.150
     0.891    27.855     0.150
     0.891    28.207     0.150
     0.875    17.195     0.150
     0.918    17.328     0.150
     0.918    29.246     0.150
     0.889    17.277     0.150
     0.934    17.195     0.150
     0.934    16.996     0.150
     0.935    18.207     0.150
     0.941    18.676     0.150
     0.977    18.559     0.150
     0.997    19.168     0.150
     1.007    19.719     0.150
     1.007    34.695     0.150
     1.027    19.688     0.150
     1.027    33.148     0.150
     1.051    18.988     0.150
     1.064    19.266     0.150
     1.100    20.586     0.150
     1.168    21.156     0.150
     1.204    22.387     0.150
     1.204    38.547     0.150
     1.255    22.496     0.150
     1.336    23.527     0.150
     1.336    41.156     0.150
     1.336    42.629     0.150
     1.336    42.879     0.150
     1.459    26.316     0.150
     1.776    30.867     0.150
     1.933    32.188     0.150
     1.996    34.277     0.150
     2.129    36.598     0.150
     2.196    38.086     0.150
     3.109    50.566     0.150
     3.562    56.578     0.150
     4.438    68.277     0.150
     0.103     3.379     0.150
     0.103     5.758     0.150
     0.103     5.938     0.150
     0.103     6.469     0.150
     0.337     6.949     0.150
     0.337    11.668     0.150
     0.337    11.848     0.150
     0.740    13.539     0.150
     0.740    23.340     0.150
     0.740    23.859     0.150
     0.700    13.547     0.150
     0.724    13.566     0.150
     0.724    23.547     0.150
     0.724    13.770     0.150
     0.955    16.699     0.150
     0.955    29.449     0.150
     0.965    17.680     0.150
     0.965    31.078     0.150
     0.905    16.770     0.150
     0.983    17.949     0.150
     0.983    31.117     0.150
     0.983    32.066     0.150
     0.983    32.469     0.150
     0.983    18.098     0.150
     1.055    21.309     0.150
     1.073    19.699     0.150
     1.134    20.309     0.150
     1.134    20.566     0.150
     1.163    21.039     0.150
     1.163    39.066     0.150
     1.184    23.637     0.150
     1.184    38.477     0.150
     1.184    21.590     0.150
     1.233    21.918     0.150
     1.288    22.910     0.150
     1.288    40.508     0.150
     1.288    39.727     0.150
     1.276    23.348     0.150
     1.276    39.867     0.150
     1.294    22.789     0.150
     1.294    39.066     0.150
     1.307    25.160     0.150
     1.307    43.438     0.150
     1.319    25.539     0.150
     1.319    43.547     0.150
     1.327    23.520     0.150
     1.327    43.488     0.150
     1.340    23.508     0.150
     1.343    25.168     0.150
     1.343    25.359     0.150
     1.349    23.887     0.150
     1.349    41.449     0.150
     1.349    23.930     0.150
     1.341    23.309     0.150
     1.342    23.828     0.150
     1.342    44.090     0.150
     1.342    44.301     0.150
     1.348    25.840     0.150
     1.348    26.387     0.150
     1.348    44.438     0.150
     1.389    24.566     0.150
     1.389    42.520     0.150
     1.389    42.660     0.150
     1.389    43.828     0.150
     1.381    24.859     0.150
     1.381    42.500     0.150
     1.370    26.477     0.150
     1.370    45.367     0.150
     1.386    25.066     0.150
     1.400    24.750     0.150
     1.406    26.059     0.150
     1.469    25.938     0.150
     1.469    26.039     0.150
     1.469    44.844     0.150
     1.449    25.309     0.150
     1.524    27.180     0.150
     1.524    46.469     0.150
     1.549    24.270     0.150
     1.513    26.309     0.150
     1.566    28.000     0.150
     1.566    48.188     0.150
     1.601    28.660     0.150
     1.601    49.098     0.150
     1.593    27.770     0.150
     1.559    26.578     0.150
     1.639    25.629     0.150
     1.654    28.859     0.150
     1.654    29.660     0.150
     1.654    51.270     0.150
     1.654    29.559     0.150
     1.654    50.672     0.150
     1.598    27.457     0.150
     1.658    28.660     0.150
     1.691    30.160     0.150
     1.691    51.750     0.150
     1.709    28.680     0.150
     1.691    29.668     0.150
     1.731    29.359     0.150
     1.765    30.027     0.150
     1.784    28.727     0.150
     1.848    31.199     0.150
     1.856    30.867     0.150
     1.897    31.180     0.150
     1.936    32.180     0.150
     1.946    30.949     0.150
     1.946    31.105     0.150
     2.046    34.359     0.150
     2.207    35.578     0.150
     2.353    38.188     0.150
     2.383    38.383     0.150
     2.383    42.980     0.150
     2.383    72.855     0.150
     2.397    38.727     0.150
     2.638    42.039     0.150
     2.746    44.117     0.150
     3.534    54.578     0.150
     4.088    63.227     0.150
     4.317    65.066     0.150
     4.317    63.930     0.150
     4.468    68.477     0.150
     4.716    71.168     0.150
     4.716    70.566     0.150
     4.770    73.098     0.150
     4.998    76.809     0.150
     4.998    76.207     0.150
     4.998   132.637     0.150
     5.414   141.840     0.150
     5.507    82.109     0.150
     6.722    99.617     0.150
     6.722   178.359     0.150
     7.418   111.012     0.150
     7.418   233.012     0.150
     8.572   126.047     0.150
     8.572   124.633     0.150
     8.572   267.230     0.150
     8.572   125.438     0.150
     8.833   128.250     0.150
     9.242   134.598     0.150
     9.242   135.359     0.150
     9.242   237.219     0.150
     9.222   133.797     0.150
     9.427   137.438     0.150
     9.427   294.512     0.150
    10.047   147.500     0.150
    10.425   152.180     0.150
    10.598   154.590     0.150
    10.598   154.262     0.150
    10.598   333.688     0.150
    10.808   157.848     0.150
    11.823   171.125     0.150
    12.447   177.887     0.150
    12.447   179.039     0.150
    15.352   215.000     0.150
    15.562   223.719     0.150
    16.225   233.430     0.150
    16.972   240.207     0.150
    17.170   237.777     0.150
    21.133   285.109     0.150
    24.032   315.387     0.150
    24.084   314.180     0.150
    25.312   327.797     0.150
    31.208   380.012     0.150
    35.264   415.387     0.150
    37.258   431.387     0.150
    38.644   445.039     0.150
    39.466   445.957     0.150
    39.479   448.590     0.150
    41.060   463.879     0.150
    41.100   460.938     0.150
    42.173   470.148     0.150
    43.598   483.250     0.150
    43.822   483.957     0.150
    95.858   811.512     0.150
    95.948   806.340     0.150
     0.383     7.769     0.150
     0.383    13.188     0.150
     0.336     6.919     0.150
     0.336    11.648     0.150
     0.459     9.339     0.150
     0.459    15.568     0.150
     0.459    15.868     0.150
     0.487     9.898     0.150
     0.487    16.769     0.150
     0.453     8.639     0.150
     0.453    14.698     0.150
     0.453    14.828     0.150
     0.477     9.299     0.150
     0.477    15.479     0.150
     0.735    13.499     0.150
     0.735    23.019     0.150
     0.735    23.148     0.150
     0.840    15.049     0.150
     0.840    25.709     0.150
     0.840    15.158     0.150
     0.849    15.799     0.150
     0.892    16.118     0.150
     0.892    27.709     0.150
     0.892    16.229     0.150
     0.932    16.509     0.150
     0.931    17.229     0.150
     0.948    17.309     0.150
     0.948    29.118     0.150
     0.948    17.379     0.150
     0.951    17.919     0.150
     0.972    17.769     0.150
     0.998    18.398     0.150
     0.998    31.349     0.150
     1.031    18.278     0.150
     1.031    31.568     0.150
     1.004    18.559     0.150
     1.006    18.539     0.150
     1.056    31.999     0.150
     1.056    18.499     0.150
     1.099    19.658     0.150
     1.099    33.919     0.150
     1.064    19.698     0.150
     1.064    18.658     0.150
     1.064    32.789     0.150
     1.105    19.148     0.150
     1.105    34.118     0.150
     1.086    19.148     0.150
     1.086    36.229     0.150
     1.086    19.688     0.150
     1.099    20.578     0.150
     1.099    35.549     0.150
     1.092    35.988     0.150
     1.092    21.269     0.150
     1.103    21.259     0.150
     1.103    37.108     0.150
     1.177    21.639     0.150
     1.177    37.919     0.150
     1.186    22.278     0.150
     1.186    38.559     0.150
     1.215    21.358     0.150
     1.215    36.408     0.150
     1.239    22.879     0.150
     1.239    41.099     0.150
     1.237    21.769     0.150
     1.260    23.028     0.150
     1.260    39.629     0.150
     1.308    22.608     0.150
     1.308    39.599     0.150
     1.283    23.979     0.150
     1.283    42.188     0.150
     1.293    23.249     0.150
     1.293    40.759     0.150
     1.339    23.828     0.150
     1.339    40.898     0.150
     1.351    41.709     0.150
     1.419    24.568     0.150
     1.410    24.578     0.150
     1.441    24.719     0.150
     1.423    26.738     0.150
     1.421    24.599     0.150
     1.421    46.269     0.150
     1.450    25.349     0.150
     1.438    24.849     0.150
     1.474    26.108     0.150
     1.474    46.729     0.150
     1.535    26.738     0.150
     1.562    26.988     0.150
     1.565    26.799     0.150
     1.599    26.858     0.150
     1.647    28.089     0.150
     1.696    28.999     0.150
     1.678    28.068     0.150
     1.737    29.889     0.150
     1.741    28.858     0.150
     1.812    31.009     0.150
     1.821    31.299     0.150
     1.870    31.948     0.150
     1.887    31.528     0.150
     1.907    32.519     0.150
     1.905    32.139     0.150
     1.906    32.003     0.150
     1.906    58.202     0.150
     1.906    31.669     0.150
     1.934    32.299     0.150
     1.969    32.639     0.150
     2.032    34.039     0.150
     2.021    33.108     0.150
     2.032    34.078     0.150
     2.058    32.648     0.150
     2.073    35.979     0.150
     2.068    34.778     0.150
     2.111    35.269     0.150
     2.204    36.139     0.150
     2.227    36.769     0.150
     2.281    37.259     0.150
     2.278    36.438     0.150
     2.303    35.469     0.150
     2.378    41.879     0.150
     2.457    40.908     0.150
     2.449    39.219     0.150
     2.542    39.898     0.150
     2.576    41.999     0.150
     2.577    41.339     0.150
     2.683    44.299     0.150
     2.855    43.618     0.150
     2.968    46.969     0.150
     2.984    46.688     0.150
     2.983    46.358     0.150
     3.046    48.148     0.150
     3.303    50.459     0.150
     3.455    53.299     0.150
     3.604    54.509     0.150
     3.599    56.158     0.150
     3.616    56.099     0.150
     3.791    58.709     0.150
     3.870    59.879     0.150
     3.929    60.188     0.150
     3.963    61.408     0.150
     4.030    61.908     0.150
     4.144    63.328     0.150
     4.173    63.438     0.150
     4.261    64.889     0.150
     4.278    65.349     0.150
     4.384    66.719     0.150
     4.478    68.309     0.150
     4.599    68.219     0.150
     4.782    72.868     0.150
     4.774    71.729     0.150
     4.786    72.469     0.150
     4.847    74.108     0.150
     5.078    76.898     0.150
     5.219    79.459     0.150
     5.360    80.908     0.150
     5.501    83.339     0.150
     5.577    82.669     0.150
     5.687    86.188     0.150
     5.748    86.999     0.150
     5.877    87.209     0.150
     5.912    87.849     0.150
     6.050    89.139     0.150
     6.348    94.479     0.150
     6.674    97.839     0.150
     6.924   106.084     0.150
     6.924   222.685     0.150
     6.924   102.578     0.150
     7.197   104.988     0.150
     8.044   116.599     0.150
     8.093   117.398     0.150
     8.234   119.568     0.150
     8.726   126.118     0.150
     8.729   124.378     0.150
     9.039   132.509     0.150
     9.039   132.139     0.150
     9.178   132.749     0.150
     9.606   139.578     0.150
     9.746   141.948     0.150
    11.026   159.118     0.150
    11.027   159.334     0.150
    11.027   159.459     0.150
    16.073   227.059     0.150
    16.544   236.628     0.150
    17.535   244.408     0.150
     0.283     6.406     0.150
     0.391     8.180     0.150
     0.391    13.828     0.150
     0.391    14.297     0.150
     0.450     9.211     0.150
     0.450    15.469     0.150
     0.461     9.523     0.150
     0.461    15.797     0.150
     0.486     9.352     0.150
     0.486    15.930     0.150
     0.486    16.188     0.150
     0.564    10.539     0.150
     0.564    18.062     0.150
     0.564    10.656     0.150
     0.564    18.219     0.150
     0.622    11.844     0.150
     0.622    20.297     0.150
     0.622    21.156     0.150
     0.622    21.312     0.150
     0.622    20.078     0.150
     0.724    13.531     0.150
     0.724    23.023     0.150
     0.724    22.898     0.150
     0.815    15.203     0.150
     0.815    14.938     0.150
     0.815    25.906     0.150
     0.826    15.898     0.150
     0.854    16.258     0.150
     0.916    17.773     0.150
     0.916    29.852     0.150
     0.915    16.703     0.150
     0.915    28.742     0.150
     0.939    16.961     0.150
     0.939    29.188     0.150
     0.966    18.328     0.150
     0.990    18.711     0.150
     1.003    18.250     0.150
     1.003    31.039     0.150
     0.991    31.391     0.150
     0.991    18.008     0.150
     0.992    17.977     0.150
     1.013    34.070     0.150
     1.033    18.828     0.150
     1.033    19.672     0.150
     1.033    32.672     0.150
     1.033    35.602     0.150
     1.046    19.391     0.150
     1.046    33.250     0.150
     1.076    20.508     0.150
     1.076    34.852     0.150
     1.099    21.461     0.150
     1.099    36.789     0.150
     1.101    19.758     0.150
     1.192    21.047     0.150
     1.305    22.922     0.150
     1.324    23.188     0.150
     1.545    27.000     0.150
     1.689    28.961     0.150
     1.793    30.602     0.150
     2.269    37.172     0.150
     2.356    36.922     0.150
     2.385    38.383     0.150
     2.490    40.648     0.150
     2.890    45.062     0.150
     3.419    60.570     0.150
     4.747    71.039     0.150
     5.622    84.078     0.150
     0.503    10.070     0.150
     0.503    16.949     0.150
     0.503    17.637     0.150
     0.551    10.539     0.150
     0.551    18.027     0.150
     0.491    10.047     0.150
     0.567    10.988     0.150
     0.567    19.160     0.150
     0.689    13.398     0.150
     0.852    16.738     0.150
     0.852    28.488     0.150
     0.865    16.977     0.150
     0.865    17.348     0.150
     0.874    17.078     0.150
     0.956    17.820     0.150
     0.956    30.438     0.150
     0.956    31.328     0.150
     0.968    17.820     0.150
     0.968    30.867     0.150
     0.919    17.738     0.150
     0.919    32.277     0.150
     0.954    17.559     0.150
     0.954    31.070     0.150
     0.954    31.527     0.150
     0.954    29.738     0.150
     0.947    18.180     0.150
     0.947    33.590     0.150
     0.967    18.297     0.150
     0.967    32.219     0.150
     1.026    19.320     0.150
     1.026    33.379     0.150
     1.026    35.539     0.150
     1.045    19.547     0.150
     1.079    20.027     0.150
     1.079    36.789     0.150
     1.130    21.188     0.150
     1.130    20.949     0.150
     1.130    38.340     0.150
     1.141    21.020     0.150
     1.141    36.539     0.150
     1.164    21.500     0.150
     1.164    36.867     0.150
     1.164    21.547     0.150
     1.163    22.699     0.150
     1.163    39.738     0.150
     1.194    22.000     0.150
     1.194    37.688     0.150
     1.211    22.590     0.150
     1.211    38.227     0.150
     1.250    22.859     0.150
     1.250    40.809     0.150
     1.284    23.387     0.150
     1.284    40.008     0.150
     1.284    39.848     0.150
     1.302    23.910     0.150
     1.347    24.438     0.150
     1.347    41.930     0.150
     1.468    26.457     0.150
     1.559    27.918     0.150
     1.573    27.988     0.150
     1.573    49.660     0.150
     1.573    28.539     0.150
     1.650    28.410     0.150
     1.658    29.457     0.150
     1.680    28.379     0.150
     1.724    30.617     0.150
     1.711    28.219     0.150
     1.793    30.500     0.150
     1.859    32.277     0.150
     1.879    31.637     0.150
     1.895    32.539     0.150
     1.849    30.109     0.150
     2.015    33.188     0.150
     2.146    35.309     0.150
     2.213    36.469     0.150
     2.213    40.492     0.150
     2.213    68.742     0.150
     2.222    37.117     0.150
     2.421    39.047     0.150
     2.505    40.758     0.150
     2.621    43.250     0.150
     2.672    42.969     0.150
     3.021    46.117     0.150
     3.010    46.938     0.150
     3.117    48.629     0.150
     3.216    51.387     0.150
     4.192    64.309     0.150
     4.192    62.957     0.150
     4.558    69.398     0.150
     4.746    71.957     0.150
     4.744   123.887     0.150
     5.111    79.598     0.150
     5.336    80.727     0.150
     5.336   143.789     0.150
     5.479    83.398     0.150
     5.479   146.078     0.150
     7.246   109.250     0.150
     7.869   117.129     0.150
     8.187   121.949     0.150
     8.409   122.816     0.150
     8.409   266.117     0.150
     8.409   123.887     0.150
     8.409   221.410     0.150
     8.409   123.348     0.150
     8.749   130.043     0.150
     8.749   277.391     0.150
     8.749   129.828     0.150
     8.749   226.418     0.150
     8.738   127.539     0.150
     8.738   229.078     0.150
     8.738   127.148     0.150
     8.963   135.348     0.150
     9.223   134.250     0.150
     9.223   172.875     0.150
     9.223   288.273     0.150
     9.362   137.027     0.150
     9.819   147.457     0.150
     9.819   144.648     0.150
    10.548   154.172     0.150
    10.548   331.523     0.150
    10.592   156.547     0.150
    11.167   165.188     0.150
    11.600   170.090     0.150
    11.678   168.926     0.150
    11.799   173.938     0.150
    12.071   177.988     0.150
    12.230   176.340     0.150
    14.478   207.359     0.150
    14.511   208.910     0.150
    15.195   213.508     0.150
    15.235   213.660     0.150
    15.547   221.809     0.150
    15.547   223.410     0.150
    15.686   226.410     0.150
    15.717   223.199     0.150
    15.721   223.738     0.150
    16.250   229.977     0.150
    16.775   239.492     0.150
    16.775   235.379     0.150
    16.775   239.867     0.150
    17.089   241.457     0.150
    18.730   261.387     0.150
    19.329   268.848     0.150
    19.643   267.219     0.150
    20.288   273.070     0.150
    20.752   278.629     0.150
    21.031   287.180     0.150
    22.500   304.328     0.150
    23.510   312.699     0.150
    23.819   316.297     0.150
    24.721   318.758     0.150
    25.163   329.117     0.150
    27.146   345.820     0.150
    29.069   356.770     0.150
    31.005   380.328     0.150
    38.483   445.348     0.150
    43.266   479.617     0.150
    63.592   632.750     0.150
    78.167   722.199     0.150
    79.668   731.094     0.150
    82.300   743.348     0.150
    84.988   759.738     0.150
   116.849  1126.445     0.150
   118.782  1129.613     0.150
     0.495     9.953     0.150
     0.495    17.293     0.150
     0.493     9.902     0.150
     0.493    17.031     0.150
     0.559    10.953     0.150
     0.559    18.652     0.150
     0.552    10.500     0.150
     0.552    17.961     0.150
     0.682    13.410     0.150
     0.846    16.660     0.150
     0.846    28.672     0.150
     0.860    17.102     0.150
     0.860    17.281     0.150
     0.871    17.141     0.150
     0.871    17.750     0.150
     0.914    17.859     0.150
     0.951    17.660     0.150
     0.951    30.641     0.150
     0.951    32.820     0.150
     0.951    33.691     0.150
     1.019    19.141     0.150
     1.019    32.902     0.150
     0.964    17.730     0.150
     0.964    30.641     0.150
     1.038    19.590     0.150
     1.074    19.930     0.150
     1.074    34.762     0.150
     0.961    17.473     0.150
     0.961    30.121     0.150
     0.961    34.852     0.150
     0.961    30.422     0.150
     1.123    21.102     0.150
     1.123    21.461     0.150
     1.123    38.812     0.150
     1.133    20.832     0.150
     1.133    37.473     0.150
     1.156    22.812     0.150
     1.156    39.500     0.150
     1.156    21.402     0.150
     1.156    21.402     0.150
     1.176    21.730     0.150
     1.203    22.543     0.150
     1.203    38.250     0.150
     1.187    22.180     0.150
     1.187    21.930     0.150
     1.187    37.793     0.150
     1.243    22.750     0.150
     1.243    41.852     0.150
     1.294    23.602     0.150
     1.277    23.332     0.150
     1.277    39.973     0.150
     1.277    41.750     0.150
     1.277    39.859     0.150
     1.333    44.531     0.150
     1.335    23.742     0.150
     1.340    24.582     0.150
     1.340    41.930     0.150
     1.340    42.352     0.150
     1.397    45.453     0.150
     1.410    24.723     0.150
     1.461    26.371     0.150
     1.461    26.512     0.150
     1.552    27.930     0.150
     1.552    48.242     0.150
     1.566    28.453     0.150
     1.566    49.223     0.150
     1.674    28.270     0.150
     1.674    28.461     0.150
     1.651    29.410     0.150
     1.644    28.520     0.150
     1.717    30.293     0.150
     1.713    28.352     0.150
     1.785    30.801     0.150
     1.871    32.102     0.150
     1.888    32.422     0.150
     1.850    30.223     0.150
     2.012    33.609     0.150
     1.983    32.312     0.150
     2.138    35.262     0.150
     2.123    36.492     0.150
     2.157    35.980     0.150
     2.198    40.633     0.150
     2.198    69.531     0.150
     2.205    36.199     0.150
     2.205    41.375     0.150
     2.205    69.801     0.150
     2.205    36.641     0.150
     2.214    36.832     0.150
     2.414    39.262     0.150
     2.497    40.859     0.150
     2.613    42.922     0.150
     2.665    43.520     0.150
     2.665    43.180     0.150
     2.865    46.582     0.150
     2.873    45.480     0.150
     3.015    48.871     0.150
     3.015    47.781     0.150
     3.014    46.941     0.150
     3.209    51.012     0.150
     3.125    49.891     0.150
     3.125    89.973     0.150
     3.260    51.680     0.150
     3.273    52.020     0.150
     3.354    56.082     0.150
     3.413    53.859     0.150
     3.413    55.180     0.150
     3.459    54.480     0.150
     3.859    60.332     0.150
     3.902    60.883     0.150
     3.959    62.109     0.150
     4.038    62.223     0.150
     4.038    65.180     0.150
     4.192    62.891     0.150
     4.192   111.262     0.150
     4.192    63.062     0.150
     4.192    63.973     0.150
     4.526    69.480     0.150
     4.555    70.043     0.150
     4.738    72.441     0.150
     4.770    74.180     0.150
     4.861    75.082     0.150
     5.044    76.609     0.150
     5.119    81.453     0.150
     5.339    80.570     0.150
     5.485    84.641     0.150
     5.485   145.961     0.150
     7.238   108.605     0.150
     7.238   227.707     0.150
     7.875   116.762     0.150
     7.875   205.641     0.150
     8.182   122.250     0.150
     8.261   215.340     0.150
     8.407   124.426     0.150
     8.407   264.898     0.150
     8.407   123.383     0.150
     8.407   222.160     0.150
     8.407   125.492     0.150
     8.739   127.609     0.150
     8.739   225.641     0.150
     8.739   128.301     0.150
     8.757   130.148     0.150
     8.757   130.312     0.150
     8.757   228.270     0.150
     8.955   135.281     0.150
     9.215   135.258     0.150
     9.215   174.508     0.150
     9.369   140.043     0.150
     9.736   143.859     0.150
     9.736   253.672     0.150
     9.824   143.480     0.150
     9.824   256.020     0.150
     9.824   147.953     0.150
    10.585   157.180     0.150
    10.551   154.223     0.150
    10.551   333.555     0.150
    11.159   165.953     0.150
    11.083   163.043     0.150
    11.596   170.402     0.150
    11.670   171.668     0.150
    11.670   363.160     0.150
    11.792   173.930     0.150
    12.064   178.180     0.150
    12.224   178.281     0.150
    12.224   389.414     0.150
    12.817   186.852     0.150
    13.616   198.402     0.150
    14.477   209.281     0.150
    14.517   211.402     0.150
    14.517   379.883     0.150
    15.159   218.672     0.150
    15.347   220.902     0.150
    15.468   222.703     0.150
    15.542   222.691     0.150
    15.717   221.992     0.150
    15.690   227.320     0.150
    15.933   229.031     0.150
    16.107   228.703     0.150
    16.086   228.781     0.150
    16.211   227.492     0.150
    16.243   231.441     0.150
    16.695   234.562     0.150
    16.767   238.852     0.150
    17.084   238.723     0.150
    17.091   242.070     0.150
    18.729   263.953     0.150
    20.286   275.320     0.150
    21.030   284.320     0.150
    21.030   288.172     0.150
    21.472   289.180     0.150
    22.494   303.250     0.150
    22.588   305.230     0.150
    23.679   317.324     0.150
    23.813   316.633     0.150
    23.813   757.133     0.150
    24.458   318.941     0.150
    24.621   324.832     0.150
    24.914   328.590     0.150
    25.156   328.590     0.150
    26.980   347.430     0.150
    27.146   348.750     0.150
    28.655   359.105     0.150
    30.998   378.953     0.150
    30.998   555.906     0.150
    37.354   433.301     0.150
    38.475   444.832     0.150
    38.475   576.738     0.150
    38.475   446.812     0.150
    39.611   450.742     0.150
    40.756   460.430     0.150
    41.321   465.160     0.150
    41.427   469.582     0.150
    41.427   466.633     0.150
    42.036   470.500     0.150
    43.055   478.902     0.150
    46.488   511.148     0.150
    47.417   519.023     0.150
    51.266   549.090     0.150
    51.616   551.660     0.150
    51.673   552.340     0.150
    53.996   568.941     0.150
    56.418   587.410     0.150
    59.036   604.180     0.150
    61.163   618.723     0.150
    61.404   620.090     0.150
    61.867   624.203     0.150
    63.061   633.980     0.150
    63.585   634.156     0.150
    63.585   768.430     0.150
    63.585   631.672     0.150
    65.138   647.180     0.150
    65.846   651.031     0.150
    75.341   707.086     0.150
    75.341   703.531     0.150
    76.090   711.406     0.150
    78.014   722.258     0.150
    78.014   723.250     0.150
    78.161   724.480     0.150
    78.161   723.258     0.150
    79.144   730.750     0.150
    79.592   732.473     0.150
    79.661   730.840     0.150
    79.910  1353.480     0.150
    79.978   733.953     0.150
    80.020   734.832     0.150
    80.020   730.082     0.150
    80.400   729.871     0.150
    80.479   737.941     0.150
    81.050   740.602     0.150
    81.357   742.082     0.150
    81.637   743.730     0.150
    81.624   742.992     0.150
    81.933   745.473     0.150
    82.216   747.223     0.150
    82.293   744.605     0.150
    82.336   747.859     0.150
    82.402   748.312     0.150
    82.457   747.953     0.150
    82.664   748.609     0.150
    82.678   747.043     0.150
    82.678   744.180     0.150
    82.698   749.590     0.150
    82.895   750.742     0.150
    82.925   750.293     0.150
    82.284   749.211     0.150
    82.991   751.020     0.150
    82.989   751.430     0.150
    83.047   750.531     0.150
    83.129   750.441     0.150
    83.165   751.660     0.150
    83.207   752.410     0.150
    83.096   748.906     0.150
    83.291   751.852     0.150
    83.308   751.992     0.150
    83.288   749.844     0.150
    83.288   747.641     0.150
    83.367   752.160     0.150
    83.368   752.941     0.150
    83.391   753.000     0.150
    83.491   753.871     0.150
    83.605   754.090     0.150
    83.869   755.453     0.150
    83.938   753.812     0.150
    83.945   947.953     0.150
    84.081   756.352     0.150
    84.984   758.531     0.150
    85.484   761.930     0.150
    85.971   758.781     0.150
    86.392   767.406     0.150
    86.579   763.082     0.150
    86.690   768.910     0.150
    87.678   773.883     0.150
    87.787   775.012     0.150
    87.846   776.180     0.150
    88.050   775.945     0.150
    88.071   775.980     0.150
    88.110   776.859     0.150
    88.112   774.355     0.150
    88.190   777.062     0.150
    88.276   776.723     0.150
    88.357   777.445     0.150
    88.989   779.480     0.150
    89.012   779.281     0.150
    89.097   779.480     0.150
    89.110   781.859     0.150
    89.277   781.164     0.150
    89.330   778.730     0.150
    89.698   783.668     0.150
    89.801   783.895     0.150
    90.000   785.480     0.150
    90.108   785.797     0.150
    90.339   785.816     0.150
    90.547   784.680     0.150
    90.755   788.883     0.150
    90.807   789.281     0.150
    91.327   789.582     0.150
    92.321   795.383     0.150
    92.340   795.180     0.150
    92.443   793.848     0.150
    92.443   796.383     0.150
    92.470   794.891     0.150
    92.649   796.480     0.150
    93.065   797.281     0.150
    93.065   794.262     0.150
    93.371   799.582     0.150
    95.653   809.469     0.150
    95.791   812.680     0.150
    95.818   805.383     0.150
    96.696   810.281     0.150
    96.696  1491.180     0.150
    97.165   813.590     0.150
    97.268   816.383     0.150
    97.268  1054.996     0.150
    98.432   818.383     0.150
   100.393   829.730     0.150
   100.393   827.512     0.150
   102.055   836.582     0.150
   105.324  1113.930     0.150
   112.170  1114.180     0.150
   116.848  1127.848     0.150
   118.782  1131.582     0.150
   120.255  1134.430     0.150
   121.356  1137.176     0.150
   121.356  1133.961     0.150
   129.480  1149.770     0.150
   134.038  1158.953     0.150
   143.866  1179.082     0.150
     0.542    10.383     0.150
     0.542    17.625     0.150
     0.504     9.934     0.150
     0.504    16.523     0.150
     0.499     9.934     0.150
     0.499    16.453     0.150
     0.499    16.844     0.150
     0.564    10.945     0.150
     0.564    18.305     0.150
     0.694    13.242     0.150
     0.858    27.723     0.150
     0.872    17.555     0.150
     0.882    17.844     0.150
     0.882    30.613     0.150
     0.948    17.422     0.150
     0.948    30.375     0.150
     0.950    17.312     0.150
     0.950    29.695     0.150
     0.950    30.473     0.150
     0.950    29.422     0.150
     0.960    17.605     0.150
     0.960    30.402     0.150
     0.925    18.605     0.150
     1.029    18.562     0.150
     1.029    33.004     0.150
     1.086    21.164     0.150
     1.086    36.543     0.150
     1.134    21.914     0.150
     1.134    38.375     0.150
     1.142    21.055     0.150
     1.142    37.082     0.150
     1.164    21.172     0.150
     1.164    36.484     0.150
     1.164    21.355     0.150
     1.164    36.414     0.150
     1.189    21.793     0.150
     1.189    37.465     0.150
     1.189    36.832     0.150
     1.166    39.363     0.150
     1.210    22.445     0.150
     1.210    38.363     0.150
     1.210    23.312     0.150
     1.210    40.344     0.150
     1.252    23.695     0.150
     1.252    41.215     0.150
     1.279    23.242     0.150
     1.279    39.785     0.150
     1.279    39.422     0.150
     1.343    24.055     0.150
     1.343    41.883     0.150
     1.463    26.293     0.150
     1.465    26.223     0.150
     1.554    28.035     0.150
     1.567    28.414     0.150
     1.567    49.363     0.150
     1.567    28.543     0.150
     1.653    29.574     0.150
     1.686    28.055     0.150
     1.794    32.895     0.150
     1.855    32.062     0.150
     1.877    31.754     0.150
     1.858    29.824     0.150
     2.023    32.973     0.150
     2.148    35.312     0.150
     2.212    35.984     0.150
     2.220    37.934     0.150
     2.426    41.305     0.150
     2.506    40.574     0.150
     2.676    43.535     0.150
     3.121    86.273     0.150
     3.285    51.273     0.150
     3.391    51.895     0.150
     3.871    59.762     0.150
     3.910    71.613     0.150
     4.260    77.652     0.150
     5.353    79.703     0.150
     5.640    85.582     0.150
     5.646    84.695     0.150
     0.174     3.957     0.150
     0.174     6.906     0.150
     0.501     9.816     0.150
     0.501    16.527     0.150
     0.499     9.707     0.150
     0.499    16.348     0.150
     0.499    16.809     0.150
     0.544    10.367     0.150
     0.544    17.875     0.150
     0.562    10.898     0.150
     0.562    18.617     0.150
     0.691    13.035     0.150
     0.691    22.086     0.150
     0.922    18.098     0.150
     0.922    32.309     0.150
     0.948    30.809     0.150
     0.953    17.297     0.150
     0.953    30.156     0.150
     0.953    30.566     0.150
     0.960    17.586     0.150
     0.960    30.387     0.150
     0.969    18.945     0.150
     0.969    32.457     0.150
     1.139    21.816     0.150
     1.139    36.828     0.150
     1.161    21.617     0.150
     1.161    36.828     0.150
     1.188    21.836     0.150
     1.188    37.676     0.150
     1.188    22.066     0.150
     1.188    37.297     0.150
     1.207    22.336     0.150
     1.207    38.047     0.150
     1.342    42.047     0.150
     1.344    44.777     0.150
     1.462    26.438     0.150
     1.462    45.406     0.150
     1.463    26.418     0.150
     1.875    30.406     0.150
     2.021    33.168     0.150
     2.198    37.016     0.150
     4.597    68.246     0.150
     0.164     3.844     0.150
     0.164     6.516     0.150
     0.164     7.000     0.150
     0.164     5.844     0.150
     0.496     9.734     0.150
     0.496    16.352     0.150
     0.496    16.734     0.150
     0.519     9.812     0.150
     0.519    17.242     0.150
     0.540    10.172     0.150
     0.540    18.086     0.150
     0.579    10.805     0.150
     0.579    17.984     0.150
     0.707    13.070     0.150
     0.707    22.742     0.150
     0.882    17.312     0.150
     0.882    30.414     0.150
     0.888    17.766     0.150
     0.888    30.539     0.150
     0.936    17.172     0.150
     0.936    29.516     0.150
     0.936    31.039     0.150
     0.937    18.984     0.150
     0.937    31.383     0.150
     0.957    17.414     0.150
     0.957    30.156     0.150
     0.957    31.289     0.150
     0.957    17.234     0.150
     0.957    29.695     0.150
     0.966    17.430     0.150
     0.966    31.203     0.150
     0.965    18.336     0.150
     0.965    32.570     0.150
     0.985    18.922     0.150
     0.985    31.461     0.150
     1.097    34.586     0.150
     1.148    22.352     0.150
     1.148    38.203     0.150
     1.157    20.773     0.150
     1.157    36.180     0.150
     1.179    21.242     0.150
     1.179    36.391     0.150
     1.181    39.266     0.150
     1.201    21.711     0.150
     1.201    37.555     0.150
     1.201    37.156     0.150
     1.201    37.031     0.150
     1.225    22.352     0.150
     1.225    37.844     0.150
     1.224    40.445     0.150
     1.267    23.305     0.150
     1.267    40.969     0.150
     1.292    23.203     0.150
     1.292    39.672     0.150
     1.292    39.219     0.150
     1.319    43.984     0.150
     1.357    24.422     0.150
     1.357    41.742     0.150
     1.358    25.031     0.150
     1.358    44.820     0.150
     1.360    23.680     0.150
     1.360    44.781     0.150
     1.376    25.273     0.150
     1.376    45.484     0.150
     1.407    46.164     0.150
     1.421    44.875     0.150
     1.434    24.672     0.150
     1.456    24.953     0.150
     1.476    45.109     0.150
     1.478    26.133     0.150
     1.478    44.789     0.150
     1.567    28.062     0.150
     1.567    47.875     0.150
     1.579    27.750     0.150
     1.579    49.961     0.150
     1.577    26.383     0.150
     1.666    29.422     0.150
     1.698    28.633     0.150
     1.698    53.102     0.150
     1.737    28.930     0.150
     1.776    30.234     0.150
     1.784    30.922     0.150
     1.809    30.969     0.150
     1.856    29.859     0.150
     1.868    31.953     0.150
     1.892    31.430     0.150
     1.908    32.383     0.150
     1.954    31.953     0.150
     2.031    33.352     0.150
     2.128    35.812     0.150
     2.160    35.516     0.150
     2.163    35.016     0.150
     2.178    35.883     0.150
     2.216    36.523     0.150
     2.225    36.234     0.150
     2.227    35.742     0.150
     2.227    36.180     0.150
     2.235    36.312     0.150
     2.241    35.844     0.150
     2.269    37.242     0.150
     2.439    40.609     0.150
     2.447    39.672     0.150
     2.496    42.914     0.150
     2.521    40.133     0.150
     2.631    42.023     0.150
     2.690    43.133     0.150
     2.816    45.320     0.150
     3.405    52.383     0.150
     3.884    60.461     0.150
     3.925    60.805     0.150
     4.019    61.742     0.150
     4.202    64.344     0.150
     4.275    64.133     0.150
     4.429    67.719     0.150
     4.579    68.414     0.150
     4.574    69.273     0.150
     4.614    68.852     0.150
     4.761    70.953     0.150
     5.363    79.352     0.150
     5.652    84.375     0.150
     5.982    88.242     0.150
     6.118    90.961     0.150
     0.155     3.633     0.150
     0.155     5.945     0.150
     0.155     6.656     0.150
     0.155     6.805     0.150
     0.155     5.727     0.150
     0.506     9.773     0.150
     0.506    16.977     0.150
     0.530    10.117     0.150
     0.530    17.266     0.150
     0.519     9.922     0.150
     0.519    16.734     0.150
     0.575    10.766     0.150
     0.575    18.359     0.150
     0.712    13.227     0.150
     0.712    22.875     0.150
     0.933    17.078     0.150
     0.933    29.492     0.150
     0.897    30.195     0.150
     0.890    17.703     0.150
     0.890    30.242     0.150
     0.948    17.414     0.150
     0.948    30.094     0.150
     0.948    17.188     0.150
     0.948    29.773     0.150
     0.957    17.477     0.150
     0.957    30.266     0.150
     0.943    32.484     0.150
     0.969    18.664     0.150
     0.990    18.977     0.150
     0.990    30.695     0.150
     1.045    19.312     0.150
     1.045    33.148     0.150
     1.151    38.648     0.150
     1.158    21.344     0.150
     1.158    37.109     0.150
     1.178    21.773     0.150
     1.194    21.742     0.150
     1.194    37.305     0.150
     1.194    37.594     0.150
     1.194    37.164     0.150
     1.268    24.234     0.150
     1.286    23.195     0.150
     1.286    39.914     0.150
     1.286    39.609     0.150
     1.352    24.445     0.150
     1.352    41.914     0.150
     1.470    26.445     0.150
     1.473    26.477     0.150
     1.572    28.297     0.150
     1.704    29.258     0.150
     1.808    31.555     0.150
     1.866    30.195     0.150
     1.863    32.383     0.150
     1.890    33.039     0.150
     2.040    33.367     0.150
     2.165    36.398     0.150
     2.225    36.109     0.150
     2.232    36.828     0.150
     2.239    36.383     0.150
     2.444    40.414     0.150
     2.521    41.078     0.150
     2.626    43.156     0.150
     2.693    44.055     0.150
     3.223    51.438     0.150
     3.400    53.734     0.150
     3.889    61.023     0.150
     3.924    61.055     0.150
     4.014    62.086     0.150
     4.212    64.812     0.150
     4.578    67.828     0.150
     4.612    68.648     0.150
     4.761    70.086     0.150
     0.190     4.281     0.150
     0.190     7.412     0.150
     0.190     7.611     0.150
     0.484     9.432     0.150
     0.484    15.873     0.150
     0.484    16.152     0.150
     0.497     9.502     0.150
     0.497    16.082     0.150
     0.497    16.842     0.150
     0.560    10.582     0.150
     0.560    18.152     0.150
     0.560    18.393     0.150
     0.565    10.752     0.150
     0.565    18.312     0.150
     0.680    12.682     0.150
     0.680    21.543     0.150
     0.842    16.102     0.150
     0.842    27.572     0.150
     0.855    16.852     0.150
     0.855    29.502     0.150
     0.864    17.172     0.150
     0.910    17.543     0.150
     0.938    18.543     0.150
     0.938    31.262     0.150
     0.960    17.543     0.150
     0.960    30.441     0.150
     0.962    17.543     0.150
     0.962    30.053     0.150
     0.962    30.432     0.150
     0.974    18.002     0.150
     0.974    30.742     0.150
     1.019    18.652     0.150
     1.070    19.332     0.150
     1.123    21.951     0.150
     1.135    20.352     0.150
     1.135    35.812     0.150
     1.159    21.002     0.150
     1.159    36.191     0.150
     1.195    21.803     0.150
     1.195    37.562     0.150
     1.195    38.361     0.150
     1.347    24.213     0.150
     1.347    41.633     0.150
     1.468    26.123     0.150
     1.574    28.252     0.150
     1.574    49.412     0.150
     1.574    28.441     0.150
     1.841    30.512     0.150
     1.858    32.191     0.150
     1.875    31.393     0.150
     2.005    32.723     0.150
     2.138    34.873     0.150
     2.209    35.803     0.150
     2.218    36.531     0.150
     2.222    35.832     0.150
     2.412    40.793     0.150
     2.500    40.473     0.150
     2.619    42.842     0.150
     2.665    44.062     0.150
     3.268    51.213     0.150
     3.394    53.893     0.150
     3.584    55.213     0.150
     3.857    60.213     0.150
     4.006    61.531     0.150
     4.548    69.572     0.150
     4.597    70.062     0.150
     4.741    72.361     0.150
     5.446    82.191     0.150
     5.656    85.992     0.150
     5.824    88.053     0.150
     5.955    90.053     0.150
     6.093    91.793     0.150
     6.156    93.021     0.150
     6.414    95.803     0.150
     0.237     5.094     0.150
     0.237     8.684     0.150
     0.237     9.594     0.150
     0.391     7.781     0.150
     0.391    13.133     0.150
     0.395     7.824     0.150
     0.395    13.164     0.150
     0.449     8.531     0.150
     0.449    14.633     0.150
     0.449    14.961     0.150
     0.689    12.984     0.150
     0.689    22.094     0.150
     0.683    13.422     0.150
     0.683    22.223     0.150
     0.683    22.121     0.150
     0.749    14.023     0.150
     0.749    24.273     0.150
     0.749    24.812     0.150
     0.749    25.754     0.150
     0.749    14.133     0.150
     0.749    24.023     0.150
     0.771    14.383     0.150
     0.771    24.551     0.150
     0.908    18.102     0.150
     0.985    18.094     0.150
     0.985    31.082     0.150
     0.985    32.094     0.150
     0.985    32.453     0.150
     0.985    18.223     0.150
     0.947    31.652     0.150
     1.022    18.812     0.150
     1.022    32.203     0.150
     1.024    19.242     0.150
     1.024    33.352     0.150
     1.048    19.324     0.150
     1.048    33.391     0.150
     1.048    32.703     0.150
     1.047    18.582     0.150
     1.047    32.621     0.150
     1.047    32.922     0.150
     1.047    32.254     0.150
     1.148    20.703     0.150
     1.148    35.523     0.150
     1.264    22.613     0.150
     1.264    38.734     0.150
     1.270    22.621     0.150
     1.270    38.992     0.150
     1.263    23.562     0.150
     1.660    29.203     0.150
     2.080    38.082     0.150
     4.974    78.691     0.150
     0.174     3.727     0.150
     0.174     6.617     0.150
     0.174     7.039     0.150
     0.174     3.426     0.150
     0.174     6.508     0.150
     0.365     6.996     0.150
     0.365    12.047     0.150
     0.478     9.066     0.150
     0.478    15.469     0.150
     0.496     9.379     0.150
     0.496    16.117     0.150
     0.533     9.938     0.150
     0.533    17.168     0.150
     0.523    10.199     0.150
     0.523    17.109     0.150
     0.523    16.848     0.150
     0.683    12.738     0.150
     0.683    21.508     0.150
     0.733    13.699     0.150
     0.733    23.727     0.150
     0.848    16.348     0.150
     0.848    27.668     0.150
     0.870    16.949     0.150
     0.870    29.777     0.150
     0.919    16.789     0.150
     0.919    29.336     0.150
     0.919    31.906     0.150
     0.919    16.969     0.150
     0.890    17.078     0.150
     0.890    17.629     0.150
     0.890    30.789     0.150
     0.933    16.879     0.150
     0.933    29.719     0.150
     0.917    18.207     0.150
     0.917    17.648     0.150
     0.917    31.457     0.150
     0.968    17.688     0.150
     0.968    30.879     0.150
     0.968    30.566     0.150
     0.936    17.988     0.150
     0.936    18.316     0.150
     0.936    32.336     0.150
     0.959    17.906     0.150
     0.959    31.488     0.150
     1.038    19.297     0.150
     1.078    19.797     0.150
     1.078    36.117     0.150
     1.118    20.367     0.150
     1.118    36.637     0.150
     1.137    20.676     0.150
     1.137    20.738     0.150
     1.157    21.066     0.150
     1.157    36.387     0.150
     1.157    35.387     0.150
     1.157    20.879     0.150
     1.181    21.559     0.150
     1.176    22.918     0.150
     1.247    22.406     0.150
     1.247    38.648     0.150
     1.247    38.508     0.150
     1.285    24.387     0.150
     1.312    23.477     0.150
     1.312    40.559     0.150
     1.416    26.078     0.150
     1.433    25.438     0.150
     1.522    26.977     0.150
     1.535    27.637     0.150
     1.535    26.438     0.150
     1.621    28.566     0.150
     1.689    29.609     0.150
     1.674    28.117     0.150
     1.744    28.676     0.150
     1.823    31.738     0.150
     1.848    31.238     0.150
     1.863    31.988     0.150
     1.879    30.547     0.150
     2.010    33.199     0.150
     2.127    35.008     0.150
     2.183    35.816     0.150
     2.190    36.508     0.150
     2.197    35.879     0.150
     2.413    39.227     0.150
     2.481    40.449     0.150
     2.586    41.707     0.150
     2.656    43.020     0.150
     2.999    50.676     0.150
     3.152    59.367     0.150
     3.152   100.398     0.150
     3.385    51.098     0.150
     3.447    52.738     0.150
     4.218    63.379     0.150
     4.218    62.848     0.150
     4.218   109.359     0.150
     5.350    81.207     0.150
     5.454    82.688     0.150
     6.412    96.617     0.150
     7.767   113.988     0.150
     8.768   128.488     0.150
     0.176     3.832     0.150
     0.176     6.543     0.150
     0.495     9.652     0.150
     0.495    16.273     0.150
     0.495    16.672     0.150
     0.503     9.852     0.150
     0.503    16.621     0.150
     0.547    10.312     0.150
     0.547    17.762     0.150
     0.547    18.133     0.150
     0.565    10.941     0.150
     0.565    18.414     0.150
     0.691    13.102     0.150
     0.691    22.414     0.150
     0.868    17.422     0.150
     0.868    30.461     0.150
     0.953    17.363     0.150
     0.953    29.613     0.150
     0.922    17.863     0.150
     0.922    31.934     0.150
     0.952    17.352     0.150
     0.948    19.414     0.150
     0.969    17.621     0.150
     1.082    19.992     0.150
     1.082    36.582     0.150
     1.141    21.812     0.150
     1.164    21.641     0.150
     1.164    36.801     0.150
     1.191    22.012     0.150
     1.191    37.871     0.150
     1.191    21.891     0.150
     1.191    37.273     0.150
     1.210    22.414     0.150
     1.210    37.824     0.150
     1.281    23.301     0.150
     1.281    39.863     0.150
     1.391    46.312     0.150
     1.465    26.492     0.150
     1.465    45.332     0.150
     1.466    26.543     0.150
     1.466    45.641     0.150
     1.557    28.254     0.150
     1.570    28.043     0.150
     1.655    29.582     0.150
     1.722    30.832     0.150
     1.856    33.051     0.150
     1.894    34.512     0.150
     2.442    39.621     0.150
     3.281    51.574     0.150
     4.006    62.613     0.150
     4.562    69.793     0.150
     5.636    86.184     0.150
     5.642    85.543     0.150
     5.966    90.461     0.150
     0.247     5.336     0.150
     0.293     5.977     0.150
     0.293    10.031     0.150
     0.293    10.352     0.150
     0.293     8.836     0.150
     0.282     5.984     0.150
     0.282     9.812     0.150
     0.359    12.406     0.150
     0.446     8.859     0.150
     0.446    14.852     0.150
     0.446    15.625     0.150
     0.473     9.461     0.150
     0.502     9.875     0.150
     0.502    16.391     0.150
     0.624    12.062     0.150
     0.624    20.492     0.150
     0.624    21.672     0.150
     0.624    20.164     0.150
     0.640    12.453     0.150
     0.640    21.125     0.150
     0.782    14.812     0.150
     0.782    25.086     0.150
     0.813    15.523     0.150
     0.813    26.164     0.150
     0.813    25.781     0.150
     0.893    16.352     0.150
     0.893    28.820     0.150
     0.893    16.570     0.150
     0.893    27.992     0.150
     0.993    18.062     0.150
     0.993    18.242     0.150
     0.993    30.727     0.150
     0.978    18.922     0.150
     0.978    32.156     0.150
     1.053    32.594     0.150
     1.053    34.203     0.150
     1.018    18.930     0.150
     1.018    31.812     0.150
     1.024    19.203     0.150
     1.025    19.273     0.150
     1.025    32.523     0.150
     1.042    19.875     0.150
     1.076    19.516     0.150
     1.096    20.055     0.150
     1.116    21.352     0.150
     1.164    21.836     0.150
     1.164    36.734     0.150
     1.199    21.555     0.150
     1.199    36.531     0.150
     1.263    22.305     0.150
     1.263    39.109     0.150
     1.588    28.242     0.150
     1.675    29.164     0.150
     1.680    28.383     0.150
     1.725    29.406     0.150
     1.965    33.594     0.150
     2.008    34.359     0.150
     2.018    34.016     0.150
     2.041    33.922     0.150
     2.070    34.133     0.150
     2.157    34.234     0.150
     2.198    35.609     0.150
     2.353    38.805     0.150
     2.366    38.562     0.150
     2.449    39.844     0.150
     2.467    40.047     0.150
     2.619    42.805     0.150
     2.723    42.703     0.150
     2.851    50.453     0.150
     2.959    47.359     0.150
     3.049    48.242     0.150
     3.120    49.242     0.150
     3.727    57.453     0.150
     3.746    56.266     0.150
     4.093    62.602     0.150
     4.181    62.922     0.150
     4.387    65.812     0.150
     4.382    66.320     0.150
     4.581    70.344     0.150
     4.592    69.547     0.150
     5.372    80.891     0.150
     5.564    83.945     0.150
     5.685    85.273     0.150
     0.172     4.008     0.150
     0.172     6.227     0.150
     0.172     7.406     0.150
     0.404     6.527     0.150
     0.404    12.008     0.150
     0.492     9.867     0.150
     0.492    16.396     0.150
     0.492    16.896     0.150
     0.546    10.377     0.150
     0.512     9.877     0.150
     0.512    16.697     0.150
     0.538    10.357     0.150
     0.538    17.557     0.150
     0.642    12.227     0.150
     0.642    20.816     0.150
     0.698    12.977     0.150
     0.698    22.037     0.150
     0.774    14.697     0.150
     0.774    24.918     0.150
     0.861    16.697     0.150
     0.874    17.316     0.150
     0.874    30.207     0.150
     0.880    16.977     0.150
     0.880    17.088     0.150
     0.880    30.588     0.150
     0.944    17.406     0.150
     0.944    29.748     0.150
     0.957    17.557     0.150
     0.957    29.918     0.150
     0.957    30.418     0.150
     0.968    17.627     0.150
     0.968    30.598     0.150
     0.928    18.717     0.150
     0.928    31.736     0.150
     0.958    18.168     0.150
     0.976    18.387     0.150
     0.976    30.527     0.150
     1.140    22.277     0.150
     1.140    38.348     0.150
     1.150    20.848     0.150
     1.150    36.637     0.150
     1.172    21.457     0.150
     1.172    36.928     0.150
     1.199    21.768     0.150
     1.199    37.326     0.150
     1.199    39.037     0.150
     1.199    21.918     0.150
     1.199    37.656     0.150
     1.199    37.428     0.150
     1.219    22.457     0.150
     1.219    38.217     0.150
     1.216    40.617     0.150
     1.249    24.236     0.150
     1.249    42.207     0.150
     1.289    23.227     0.150
     1.289    39.656     0.150
     1.289    39.758     0.150
     1.289    23.447     0.150
     1.309    24.066     0.150
     1.309    40.697     0.150
     1.311    25.236     0.150
     1.311    43.438     0.150
     1.353    24.527     0.150
     1.353    41.857     0.150
     1.353    24.498     0.150
     1.353    41.918     0.150
     1.349    24.508     0.150
     1.414    26.057     0.150
     1.475    26.367     0.150
     1.475    45.396     0.150
     1.528    25.857     0.150
     1.577    27.227     0.150
     1.690    28.338     0.150
     1.865    31.938     0.150
     1.865    54.566     0.150
     1.851    30.156     0.150
     1.887    31.518     0.150
     1.994    34.697     0.150
     2.023    33.277     0.150
     2.136    36.967     0.150
     2.155    35.406     0.150
     2.221    36.197     0.150
     2.228    36.707     0.150
     2.229    36.518     0.150
     2.235    36.277     0.150
     2.430    39.457     0.150
     2.442    38.838     0.150
     2.514    40.217     0.150
     2.628    41.627     0.150
     2.675    41.797     0.150
     2.682    42.918     0.150
     3.111    58.588     0.150
     3.111    97.957     0.150
     3.137    49.156     0.150
     3.156    48.518     0.150
     3.206    49.037     0.150
     3.286    51.156     0.150
     3.401    52.777     0.150
     3.426    53.137     0.150
     3.875    59.236     0.150
     3.975    61.107     0.150
     4.015    61.508     0.150
     4.051    60.518     0.150
     4.196    63.227     0.150
     4.196    61.557     0.150
     4.196   111.316     0.150
     4.270    64.268     0.150
     4.307    65.797     0.150
     4.325    65.678     0.150
     4.422    67.367     0.150
     4.446    67.438     0.150
     4.450    67.236     0.150
     4.573    69.107     0.150
     4.566    69.826     0.150
     4.741    70.877     0.150
     4.755    71.588     0.150
     4.784    72.088     0.150
     4.978    75.467     0.150
     5.008    76.566     0.150
     5.061    74.768     0.150
     5.354    80.986     0.150
     5.425    81.457     0.150
     5.461    82.316     0.150
     5.528    81.066     0.150
     5.643    85.758     0.150
     5.645    83.896     0.150
     5.650    85.287     0.150
     5.707    84.668     0.150
     5.734    85.838     0.150
     5.842    87.736     0.150
     5.912    88.646     0.150
     5.942    88.717     0.150
     5.973    89.566     0.150
     6.035    90.387     0.150
     6.125    91.258     0.150
     6.131    91.076     0.150
     6.354    94.947     0.150
     6.668    98.287     0.150
     6.690    98.877     0.150
     6.739    99.637     0.150
     7.139   103.797     0.150
     7.692   112.117     0.150
     7.751   113.768     0.150
     8.741   128.197     0.150
     8.739   127.518     0.150
     8.740   126.396     0.150
    10.259   146.047     0.150
    10.548   152.418     0.150
    10.548   153.117     0.150
     0.148     4.020     0.150
     0.148     6.730     0.150
     0.148     7.559     0.150
     0.148     6.891     0.150
     0.488    15.371     0.150
     0.488    15.590     0.150
     0.634    11.820     0.150
     0.634    20.078     0.150
     0.634    20.828     0.150
     0.806    14.570     0.150
     0.806    24.980     0.150
     0.829    15.109     0.150
     0.829    26.371     0.150
     0.829    27.008     0.150
     0.829    26.059     0.150
     1.086    35.570     0.150
     1.018    18.438     0.150
     1.018    32.148     0.150
     1.022    18.461     0.150
     1.022    31.680     0.150
     1.273    39.559     0.150
     1.294    23.461     0.150
     1.294    40.090     0.150
     1.294    23.027     0.150
     1.294    40.199     0.150
     1.294    23.219     0.150
     1.294    39.359     0.150
     1.338    24.328     0.150
     1.338    40.910     0.150
     1.389    24.609     0.150
     1.389    42.199     0.150
     1.423    43.598     0.150
     1.470    45.301     0.150
     1.459    44.660     0.150
     1.581    27.238     0.150
     1.581    47.988     0.150
     1.891    59.328     0.150
     2.006    33.629     0.150
     2.006    61.988     0.150
     2.018    61.949     0.150
     2.066    63.871     0.150
     2.096    62.918     0.150
     2.127    65.891     0.150
     2.323    69.520     0.150
     2.339    67.168     0.150
     2.456    38.418     0.150
     5.106    77.188     0.150
     0.164     3.967     0.150
     0.164     6.025     0.150
     0.164     7.406     0.150
     0.164     6.576     0.150
     0.398     6.516     0.150
     0.398    11.906     0.150
     0.504     9.896     0.150
     0.504    16.506     0.150
     0.504    16.906     0.150
     0.504    16.176     0.150
     0.509    10.006     0.150
     0.509    16.727     0.150
     0.536    10.307     0.150
     0.536    17.406     0.150
     0.637    12.266     0.150
     0.637    20.887     0.150
     0.701    13.307     0.150
     0.701    22.576     0.150
     0.765    14.686     0.150
     0.765    25.396     0.150
     0.880    17.686     0.150
     0.889    17.896     0.150
     0.889    30.986     0.150
     0.943    17.275     0.150
     0.943    29.615     0.150
     0.943    29.436     0.150
     0.946    17.506     0.150
     0.946    30.236     0.150
     0.933    17.986     0.150
     0.957    17.586     0.150
     0.957    29.877     0.150
     0.959    32.525     0.150
     0.959    18.275     0.150
     0.979    18.377     0.150
     0.979    30.766     0.150
     1.140    22.387     0.150
     1.168    21.467     0.150
     1.168    21.746     0.150
     1.189    21.736     0.150
     1.189    37.756     0.150
     1.189    39.006     0.150
     1.189    36.615     0.150
     1.189    21.986     0.150
     1.213    22.496     0.150
     1.280    23.227     0.150
     1.280    39.547     0.150
     1.280    23.346     0.150
     1.280    39.727     0.150
     1.302    24.307     0.150
     1.302    40.945     0.150
     1.345    24.566     0.150
     1.345    41.957     0.150
     1.346    24.775     0.150
     1.345    24.547     0.150
     1.354    26.186     0.150
     1.368    26.137     0.150
     1.464    26.445     0.150
     1.466    26.346     0.150
     1.466    25.547     0.150
     1.519    27.916     0.150
     1.527    27.406     0.150
     1.527    47.006     0.150
     1.567    26.426     0.150
     1.606    29.637     0.150
     1.619    30.695     0.150
     1.632    29.355     0.150
     1.654    29.637     0.150
     1.654    50.586     0.150
     1.657    29.746     0.150
     1.693    28.377     0.150
     1.711    31.557     0.150
     1.710    31.945     0.150
     1.722    30.576     0.150
     1.722    52.605     0.150
     1.765    30.016     0.150
     1.772    32.246     0.150
     1.857    31.836     0.150
     1.863    30.076     0.150
     1.881    31.906     0.150
     1.896    34.477     0.150
     1.941    35.836     0.150
     1.972    35.516     0.150
     1.985    34.855     0.150
     2.003    36.666     0.150
     2.117    37.326     0.150
     2.123    39.336     0.150
     2.127    39.477     0.150
     2.149    39.256     0.150
     2.154    34.775     0.150
     2.167    36.105     0.150
     2.208    38.377     0.150
     2.204    40.787     0.150
     2.216    35.936     0.150
     2.216    40.707     0.150
     2.220    37.006     0.150
     2.224    35.326     0.150
     2.233    40.797     0.150
     2.230    36.057     0.150
     2.242    40.986     0.150
     2.258    41.047     0.150
     2.285    41.797     0.150
     2.293    37.855     0.150
     2.324    40.637     0.150
     2.341    41.076     0.150
     2.383    38.877     0.150
     2.415    42.896     0.150
     2.435    42.967     0.150
     2.435    40.047     0.150
     2.433    39.926     0.150
     2.453    39.496     0.150
     2.459    45.746     0.150
     2.483    44.746     0.150
     2.511    40.266     0.150
     2.518    46.477     0.150
     2.523    45.727     0.150
     2.614    46.195     0.150
     2.618    47.297     0.150
     2.638    48.416     0.150
     2.669    42.996     0.150
     2.682    42.316     0.150
     2.712    49.365     0.150
     2.731    48.297     0.150
     2.767    48.025     0.150
     2.765    50.967     0.150
     2.767    50.316     0.150
     2.807    51.047     0.150
     2.943    45.525     0.150
     2.945    49.166     0.150
     3.119    57.727     0.150
     3.119    98.637     0.150
     3.202    48.496     0.150
     3.293    51.627     0.150
     3.418    53.156     0.150
     3.418    53.387     0.150
     3.878    59.146     0.150
     4.007    61.217     0.150
     4.207    64.656     0.150
     4.207    62.566     0.150
     4.207   109.676     0.150
     4.312    66.977     0.150
     4.459    67.115     0.150
     4.574    69.596     0.150
     4.751    71.826     0.150
     4.777    72.307     0.150
     4.984    75.566     0.150
     5.008    77.006     0.150
     5.013    77.176     0.150
     5.327    79.605     0.150
     5.361    81.307     0.150
     5.436    81.605     0.150
     5.525    84.457     0.150
     5.647    84.496     0.150
     5.653    84.566     0.150
     5.744    86.156     0.150
     5.938    88.105     0.150
     5.976    89.656     0.150
     6.126    90.605     0.150
     6.321    94.006     0.150
     6.750    99.926     0.150
     7.168   105.926     0.150
     0.286     6.182     0.150
     0.286    10.701     0.150
     0.384     8.262     0.150
     0.384    13.332     0.150
     0.384    13.213     0.150
     0.397    13.191     0.150
     0.415    14.621     0.150
     0.520     9.762     0.150
     0.520    16.732     0.150
     0.520    17.242     0.150
     0.507    10.002     0.150
     0.507    16.592     0.150
     0.526    10.271     0.150
     0.526    16.713     0.150
     0.678    12.893     0.150
     0.678    21.883     0.150
     0.678    22.361     0.150
     0.678    21.633     0.150
     0.786    14.602     0.150
     0.786    24.812     0.150
     0.786    25.102     0.150
     0.786    24.672     0.150
     0.885    16.473     0.150
     0.917    17.041     0.150
     0.917    28.742     0.150
     0.916    17.422     0.150
     0.926    16.883     0.150
     0.926    29.281     0.150
     0.946    17.822     0.150
     0.946    30.121     0.150
     0.978    17.883     0.150
     1.009    18.232     0.150
     1.009    31.402     0.150
     1.008    19.172     0.150
     1.035    18.803     0.150
     1.035    32.121     0.150
     1.047    19.332     0.150
     1.047    33.182     0.150
     1.047    35.662     0.150
     1.047    19.752     0.150
     1.047    32.973     0.150
     1.044    19.312     0.150
     1.057    19.162     0.150
     1.057    32.912     0.150
     1.058    20.303     0.150
     1.058    33.541     0.150
     1.109    20.451     0.150
     1.109    34.652     0.150
     1.107    20.271     0.150
     1.107    34.422     0.150
     1.117    22.021     0.150
     1.160    20.963     0.150
     1.168    22.281     0.150
     1.199    37.012     0.150
     1.199    40.062     0.150
     1.199    21.291     0.150
     1.199    36.541     0.150
     1.210    21.771     0.150
     1.239    23.201     0.150
     1.251    23.303     0.150
     1.259    22.402     0.150
     1.263    23.072     0.150
     1.260    24.121     0.150
     1.310    24.582     0.150
     1.373    24.771     0.150
     1.391    24.512     0.150
     1.401    25.291     0.150
     1.458    26.092     0.150
     1.467    26.271     0.150
     1.497    26.762     0.150
     1.533    27.621     0.150
     1.557    27.621     0.150
     1.777    30.602     0.150
     1.773    30.393     0.150
     1.853    31.852     0.150
     1.878    32.111     0.150
     1.908    32.582     0.150
     2.023    34.281     0.150
     2.153    36.262     0.150
     2.266    37.242     0.150
     2.320    37.232     0.150
     2.328    42.842     0.150
     2.333    37.861     0.150
     2.377    37.992     0.150
     2.473    38.883     0.150
     2.582    41.531     0.150
     2.765    43.012     0.150
     2.779    43.662     0.150
     2.913    45.502     0.150
     2.927    46.262     0.150
     2.925    45.652     0.150
     2.938    46.531     0.150
     3.497    53.973     0.150
     3.548    53.812     0.150
     3.759    58.162     0.150
     3.887    61.682     0.150
     3.892    60.742     0.150
     3.985    62.531     0.150
     4.222    66.922     0.150
     4.335    65.281     0.150
     4.433    68.572     0.150
     4.434    68.572     0.150
     4.451    69.402     0.150
     0.198     4.191     0.150
     0.198     7.203     0.150
     0.198     7.992     0.150
     0.198     6.941     0.150
     0.198     4.072     0.150
     0.503     9.873     0.150
     0.503    16.691     0.150
     0.503    16.441     0.150
     0.490     9.713     0.150
     0.490    16.191     0.150
     0.490    16.832     0.150
     0.521    10.053     0.150
     0.521    17.293     0.150
     0.561    10.652     0.150
     0.561    18.092     0.150
     0.666    12.793     0.150
     0.845    17.342     0.150
     0.845    29.592     0.150
     0.897    18.303     0.150
     0.897    31.713     0.150
     0.924    18.512     0.150
     0.950    17.643     0.150
     0.950    30.373     0.150
     0.950    17.232     0.150
     0.943    18.182     0.150
     0.943    18.973     0.150
     0.943    31.352     0.150
     0.943    31.533     0.150
     0.965    17.732     0.150
     0.965    30.812     0.150
     1.002    18.793     0.150
     1.002    32.393     0.150
     1.117    21.002     0.150
     1.117    35.963     0.150
     1.180    21.873     0.150
     1.180    37.652     0.150
     1.180    22.123     0.150
     1.180    37.213     0.150
     1.189    22.332     0.150
     1.189    37.422     0.150
     1.269    23.332     0.150
     1.269    39.852     0.150
     1.269    23.152     0.150
     1.269    39.611     0.150
     1.282    24.133     0.150
     1.282    40.672     0.150
     1.319    24.742     0.150
     1.319    41.713     0.150
     1.318    25.412     0.150
     1.328    24.572     0.150
     1.328    42.072     0.150
     1.319    25.553     0.150
     1.330    24.611     0.150
     1.330    41.652     0.150
     1.335    25.492     0.150
     1.366    26.312     0.150
     1.366    45.092     0.150
     1.382    26.203     0.150
     1.382    44.682     0.150
     1.417    26.502     0.150
     1.452    26.422     0.150
     1.452    45.021     0.150
     1.451    26.172     0.150
     1.451    45.322     0.150
     1.451    46.191     0.150
     1.451    25.963     0.150
     1.559    27.633     0.150
     1.657    29.002     0.150
     1.707    30.643     0.150
     1.707    52.432     0.150
     1.740    54.873     0.150
     1.752    32.482     0.150
     1.752    54.582     0.150
     1.841    32.143     0.150
     1.857    58.293     0.150
     1.875    34.422     0.150
     1.875    58.213     0.150
     1.953    35.271     0.150
     1.953    60.672     0.150
     1.998    33.953     0.150
     2.122    35.271     0.150
     2.144    66.861     0.150
     2.191    36.582     0.150
     2.204    36.133     0.150
     2.398    39.412     0.150
     2.431    39.533     0.150
     2.645    42.732     0.150
     2.648    42.213     0.150
     3.258    51.043     0.150
     3.378    52.111     0.150
     4.164    63.713     0.150
     4.429    67.512     0.150
     4.977    76.262     0.150
     0.371     6.816     0.150
     0.371    11.406     0.150
     0.371    12.039     0.150
     0.371    12.258     0.150
     0.371    11.828     0.150
     0.396     7.449     0.150
     0.396    12.609     0.150
     0.396    13.297     0.150
     0.416     8.508     0.150
     0.416    14.066     0.150
     0.563    11.129     0.150
     0.563    18.848     0.150
     0.563    18.996     0.150
     0.592    11.648     0.150
     0.592    19.906     0.150
     0.816    15.430     0.150
     0.816    26.469     0.150
     0.816    15.539     0.150
     0.915    17.129     0.150
     0.915    28.918     0.150
     0.950    18.969     0.150
     0.950    33.816     0.150
     0.953    18.336     0.150
     0.953    30.719     0.150
     0.986    18.898     0.150
     1.003    20.207     0.150
     1.003    35.457     0.150
     0.997    18.379     0.150
     0.997    31.738     0.150
     0.997    18.547     0.150
     1.025    35.680     0.150
     1.019    19.059     0.150
     1.019    33.066     0.150
     1.048    20.457     0.150
     1.058    36.406     0.150
     1.094    21.020     0.150
     1.094    35.598     0.150
     1.104    20.379     0.150
     1.104    34.699     0.150
     1.121    20.578     0.150
     1.121    34.949     0.150
     1.156    38.520     0.150
     1.176    21.559     0.150
     1.176    36.789     0.150
     1.187    22.707     0.150
     1.187    38.398     0.150
     1.185    21.438     0.150
     1.185    37.688     0.150
     1.180    22.930     0.150
     1.180    39.719     0.150
     1.189    22.707     0.150
     1.189    38.578     0.150
     1.261    23.586     0.150
     1.261    41.156     0.150
     1.276    24.109     0.150
     1.291    23.668     0.150
     1.307    23.836     0.150
     1.509    26.906     0.150
     1.694    29.168     0.150
     1.710    31.707     0.150
     1.857    34.648     0.150
     1.869    34.180     0.150
     1.887    32.906     0.150
     1.932    33.520     0.150
     1.944    33.668     0.150
     1.956    36.148     0.150
     1.968    33.816     0.150
     2.014    34.496     0.150
     2.090    36.109     0.150
     2.199    35.336     0.150
     2.198    36.477     0.150
     2.298    38.828     0.150
     2.386    40.418     0.150
     2.566    42.348     0.150
     2.755    43.809     0.150
     4.715    72.039     0.150
     5.036    77.348     0.150
     5.243    81.336     0.150
     5.982    90.496     0.150
     6.025    91.109     0.150
     6.241    92.930     0.150
     7.047   104.398     0.150
     0.172     4.164     0.150
     0.172     7.031     0.150
     0.172     7.531     0.150
     0.451     8.945     0.150
     0.451    15.672     0.150
     0.451    16.477     0.150
     0.451    15.227     0.150
     0.479     9.398     0.150
     0.479    15.734     0.150
     0.479    15.992     0.150
     0.531    10.117     0.150
     0.531    17.156     0.150
     0.560    10.547     0.150
     0.560    17.938     0.150
     0.554    10.453     0.150
     0.554    17.875     0.150
     0.709    13.227     0.150
     0.938    18.469     0.150
     0.976    17.492     0.150
     0.976    30.617     0.150
     0.976    17.719     0.150
     0.985    17.797     0.150
     0.985    30.742     0.150
     0.988    19.328     0.150
     0.988    34.203     0.150
     0.988    19.227     0.150
     0.988    32.906     0.150
     1.169    20.625     0.150
     1.169    36.781     0.150
     1.220    21.945     0.150
     1.220    38.164     0.150
     1.220    22.148     0.150
     1.220    37.219     0.150
     1.240    22.398     0.150
     1.240    38.344     0.150
     1.311    23.664     0.150
     1.311    39.906     0.150
     1.300    26.633     0.150
     1.300    41.586     0.150
     1.331    41.312     0.150
     1.375    24.734     0.150
     1.375    42.273     0.150
     1.370    42.188     0.150
     1.369    24.836     0.150
     1.369    44.508     0.150
     1.363    25.648     0.150
     1.363    44.742     0.150
     1.385    24.266     0.150
     1.385    45.086     0.150
     1.417    46.234     0.150
     1.434    25.406     0.150
     1.434    44.922     0.150
     1.468    26.664     0.150
     1.468    46.398     0.150
     1.495    26.492     0.150
     1.495    45.836     0.150
     1.496    26.766     0.150
     1.496    45.555     0.150
     1.558    27.484     0.150
     1.558    47.438     0.150
     1.532    25.453     0.150
     1.582    28.953     0.150
     1.582    49.828     0.150
     1.633    29.672     0.150
     1.633    50.633     0.150
     1.661    28.969     0.150
     1.661    51.008     0.150
     1.801    31.055     0.150
     1.924    32.531     0.150
     2.024    32.422     0.150
     2.152    35.773     0.150
     2.175    39.703     0.150
     2.194    40.094     0.150
     2.242    36.375     0.150
     2.255    35.594     0.150
     2.433    39.008     0.150
     3.448    52.625     0.150
     3.695    62.242     0.150
     3.887    58.938     0.150
     4.314    65.398     0.150
     4.448    66.773     0.150
     4.568    68.922     0.150
     4.775    72.156     0.150
     5.017    76.125     0.150
     5.087    74.195     0.150
     5.360    80.023     0.150
     5.480    82.555     0.150
     5.653    84.352     0.150
     0.249     5.148     0.150
     0.249     8.547     0.150
     0.249     9.078     0.150
     0.383     7.848     0.150
     0.383    12.918     0.150
     0.383    13.656     0.150
     0.383    13.398     0.150
     0.421     8.418     0.150
     0.421    14.039     0.150
     0.633    21.508     0.150
     0.715    14.680     0.150
     0.715    24.707     0.150
     0.716    14.648     0.150
     0.760    14.406     0.150
     0.760    24.328     0.150
     0.780    15.859     0.150
     0.780    27.699     0.150
     0.823    16.227     0.150
     0.823    27.867     0.150
     0.875    17.527     0.150
     0.875    17.637     0.150
     0.875    30.648     0.150
     0.989    18.039     0.150
     0.989    30.680     0.150
     0.989    35.539     0.150
     0.957    18.699     0.150
     0.957    19.277     0.150
     0.957    31.840     0.150
     0.957    32.508     0.150
     0.962    18.488     0.150
     1.027    19.668     0.150
     1.027    33.738     0.150
     1.137    21.680     0.150
     1.137    37.430     0.150
     1.200    22.047     0.150
     1.200    38.066     0.150
     1.200    22.148     0.150
     1.215    22.078     0.150
     1.215    38.188     0.150
     1.177    39.656     0.150
     1.235    23.379     0.150
     1.235    39.789     0.150
     1.287    23.930     0.150
     1.358    25.508     0.150
     1.358    42.988     0.150
     1.413    25.949     0.150
     1.413    45.027     0.150
     1.413    26.379     0.150
     1.413    44.559     0.150
     1.413    44.289     0.150
     1.664    29.996     0.150
     1.795    31.867     0.150
     1.871    31.020     0.150
     2.051    35.340     0.150
     2.214    35.996     0.150
     2.400    42.578     0.150
     3.615    56.496     0.150
     3.834    60.027     0.150
     4.214    66.289     0.150
     4.414    67.488     0.150
     5.470    82.578     0.150
     0.165     3.873     0.150
     0.165     6.593     0.150
     0.165     7.353     0.150
     0.165     6.013     0.150
     0.469     9.402     0.150
     0.469    15.772     0.150
     0.469    16.673     0.150
     0.469    15.612     0.150
     0.497     9.723     0.150
     0.497    16.152     0.150
     0.497    16.692     0.150
     0.516     9.952     0.150
     0.516    17.003     0.150
     0.538    10.253     0.150
     0.538    17.383     0.150
     0.705    13.213     0.150
     0.881    17.923     0.150
     0.939    17.232     0.150
     0.939    29.442     0.150
     0.939    31.333     0.150
     0.939    29.272     0.150
     0.955    17.353     0.150
     0.955    30.163     0.150
     0.955    17.603     0.150
     0.964    17.713     0.150
     0.964    30.532     0.150
     0.935    18.713     0.150
     0.964    18.862     0.150
     0.964    32.263     0.150
     0.982    19.112     0.150
     0.982    19.333     0.150
     0.982    32.723     0.150
     0.982    33.312     0.150
     1.176    21.543     0.150
     1.176    36.433     0.150
     1.198    22.032     0.150
     1.198    37.562     0.150
     1.198    22.152     0.150
     1.289    23.393     0.150
     1.289    39.883     0.150
     1.289    40.503     0.150
     1.289    41.103     0.150
     1.311    24.213     0.150
     1.311    40.853     0.150
     1.354    24.543     0.150
     1.354    41.973     0.150
     1.355    24.663     0.150
     1.475    26.503     0.150
     1.475    45.232     0.150
     1.535    25.933     0.150
     1.576    27.853     0.150
     1.576    48.992     0.150
     1.696    28.333     0.150
     1.865    31.793     0.150
     1.857    30.303     0.150
     2.030    33.362     0.150
     2.224    37.103     0.150
     2.229    37.282     0.150
     2.232    36.973     0.150
     2.448    38.513     0.150
     2.518    39.873     0.150
     2.629    42.652     0.150
     2.677    42.612     0.150
     2.687    43.812     0.150
     3.224    50.732     0.150
     3.293    50.963     0.150
     3.402    53.232     0.150
     4.016    60.532     0.150
     4.202    63.503     0.150
     4.313    65.803     0.150
     4.611    70.522     0.150
     4.758    70.692     0.150
     5.361    79.713     0.150
     0.273     5.773     0.150
     0.273     9.514     0.150
     0.272     6.002     0.150
     0.272     9.982     0.150
     0.272    10.592     0.150
     0.471     9.283     0.150
     0.471    15.342     0.150
     0.634    12.434     0.150
     0.634    20.973     0.150
     0.634    12.133     0.150
     0.644    12.703     0.150
     0.644    21.303     0.150
     0.711    13.652     0.150
     0.711    23.193     0.150
     0.711    22.723     0.150
     0.802    15.133     0.150
     0.810    15.613     0.150
     0.810    26.113     0.150
     0.810    25.643     0.150
     0.914    16.793     0.150
     0.914    29.502     0.150
     0.914    16.963     0.150
     0.914    28.963     0.150
     0.914    28.453     0.150
     0.967    18.072     0.150
     1.015    18.422     0.150
     1.015    31.992     0.150
     1.015    31.553     0.150
     1.025    18.752     0.150
     1.025    32.223     0.150
     1.025    33.953     0.150
     1.002    19.113     0.150
     1.052    19.652     0.150
     1.052    32.992     0.150
     1.046    19.332     0.150
     1.046    19.062     0.150
     1.046    32.982     0.150
     1.040    35.143     0.150
     1.048    19.482     0.150
     1.048    19.922     0.150
     1.048    33.752     0.150
     1.048    34.652     0.150
     1.099    20.082     0.150
     1.099    34.072     0.150
     1.096    20.393     0.150
     1.096    34.502     0.150
     1.122    20.463     0.150
     1.122    34.822     0.150
     1.127    38.002     0.150
     1.144    21.662     0.150
     1.144    37.143     0.150
     1.205    21.793     0.150
     1.205    37.854     0.150
     1.192    22.283     0.150
     1.223    21.773     0.150
     1.223    38.373     0.150
     1.223    22.023     0.150
     1.203    23.373     0.150
     1.281    23.764     0.150
     1.278    22.773     0.150
     1.278    39.822     0.150
     1.266    41.523     0.150
     1.283    24.062     0.150
     1.347    44.732     0.150
     1.391    42.902     0.150
     1.410    25.402     0.150
     1.444    26.043     0.150
     1.444    44.783     0.150
     1.478    26.172     0.150
     1.564    28.303     0.150
     1.564    48.623     0.150
     1.604    50.693     0.150
     1.689    30.273     0.150
     1.702    52.803     0.150
     1.725    30.643     0.150
     1.725    52.943     0.150
     1.756    53.713     0.150
     1.750    29.412     0.150
     1.898    33.502     0.150
     1.960    35.623     0.150
     1.990    33.562     0.150
     2.005    36.523     0.150
     2.034    34.223     0.150
     2.045    34.363     0.150
     2.044    38.014     0.150
     2.057    37.312     0.150
     2.059    37.043     0.150
     2.215    36.273     0.150
     2.376    39.434     0.150
     2.376    71.223     0.150
     2.394    38.893     0.150
     2.494    41.014     0.150
     2.720    42.943     0.150
     2.729    43.434     0.150
     2.964    46.543     0.150
     3.142    49.963     0.150
     3.180    48.303     0.150
     3.241    50.623     0.150
     3.428    53.143     0.150
     3.534    55.812     0.150
     3.754    58.242     0.150
     3.770    58.723     0.150
     3.973    60.963     0.150
     4.205    64.252     0.150
     4.413    68.303     0.150
     4.609    71.502     0.150
     4.941    75.672     0.150
     5.710    85.232     0.150
     5.856    88.213     0.150
     6.004    91.072     0.150
     6.441    96.934     0.150
     0.418     8.992     0.150
     0.418    14.934     0.150
     0.422     8.551     0.150
     0.422    13.934     0.150
     0.422    14.383     0.150
     0.485    16.523     0.150
     0.572    11.043     0.150
     0.572    18.691     0.150
     0.572    19.301     0.150
     0.616    11.902     0.150
     0.616    20.301     0.150
     0.616    21.250     0.150
     0.616    20.000     0.150
     0.714    13.391     0.150
     0.714    22.922     0.150
     0.791    15.160     0.150
     0.791    25.012     0.150
     0.798    14.570     0.150
     0.798    25.242     0.150
     0.798    14.711     0.150
     0.798    25.023     0.150
     0.803    15.453     0.150
     0.807    15.211     0.150
     0.814    15.344     0.150
     0.825    15.242     0.150
     0.825    26.062     0.150
     0.875    16.660     0.150
     0.875    28.223     0.150
     0.896    17.344     0.150
     0.896    29.551     0.150
     0.904    16.500     0.150
     0.904    28.352     0.150
     0.922    16.750     0.150
     0.924    31.434     0.150
     0.924    18.371     0.150
     0.933    17.750     0.150
     0.933    29.703     0.150
     0.976    17.652     0.150
     0.976    30.094     0.150
     0.985    18.113     0.150
     0.985    30.750     0.150
     0.990    18.230     0.150
     0.991    19.473     0.150
     0.991    18.051     0.150
     0.991    31.141     0.150
     0.991    34.383     0.150
     1.011    18.773     0.150
     1.011    31.312     0.150
     1.011    18.652     0.150
     1.011    31.562     0.150
     1.008    31.301     0.150
     1.031    18.832     0.150
     1.031    32.312     0.150
     1.031    35.371     0.150
     1.039    19.672     0.150
     1.039    33.371     0.150
     1.058    20.281     0.150
     1.058    35.043     0.150
     1.091    33.434     0.150
     1.128    35.891     0.150
     1.149    35.582     0.150
     1.164    36.242     0.150
     1.176    35.781     0.150
     1.174    22.652     0.150
     1.178    38.523     0.150
     1.191    21.273     0.150
     1.191    36.250     0.150
     1.233    22.410     0.150
     1.233    37.910     0.150
     1.236    38.703     0.150
     1.271    39.094     0.150
     1.288    42.641     0.150
     1.303    39.742     0.150
     1.303    41.570     0.150
     1.303    22.941     0.150
     1.303    39.461     0.150
     1.293    41.160     0.150
     1.310    40.031     0.150
     1.310    23.031     0.150
     1.312    23.293     0.150
     1.312    40.000     0.150
     1.332    42.102     0.150
     1.355    25.152     0.150
     1.421    25.762     0.150
     1.424    42.980     0.150
     1.646    27.891     0.150
     1.689    29.133     0.150
     1.765    30.312     0.150
     1.891    31.941     0.150
     2.074    35.344     0.150
     2.141    35.691     0.150
     2.210    37.113     0.150
     2.230    36.152     0.150
     2.331    36.320     0.150
     2.342    37.980     0.150
     2.449    39.801     0.150
     2.573    39.070     0.150
     2.682    44.762     0.150
     2.860    43.934     0.150
     2.860    44.562     0.150
     2.902    43.523     0.150
     4.121    61.363     0.150
     4.718    70.793     0.150
     5.078    78.070     0.150
     5.413    82.602     0.150
     5.856    87.691     0.150
     0.250     5.361     0.150
     0.250     8.941     0.150
     0.250     9.221     0.150
     0.420     8.551     0.150
     0.420    14.221     0.150
     0.382     7.981     0.150
     0.382    13.021     0.150
     0.382    13.721     0.150
     0.382    12.891     0.150
     0.634    12.241     0.150
     0.634    21.071     0.150
     0.681    13.091     0.150
     0.774    14.581     0.150
     0.774    24.471     0.150
     0.717    14.961     0.150
     0.717    25.781     0.150
     0.760    14.541     0.150
     0.760    24.601     0.150
     0.781    16.091     0.150
     0.781    27.331     0.150
     0.824    16.101     0.150
     0.987    31.171     0.150
     0.987    33.981     0.150
     0.876    17.851     0.150
     0.876    30.101     0.150
     0.963    18.761     0.150
     1.028    19.951     0.150
     1.028    34.821     0.150
     1.199    22.241     0.150
     1.199    38.091     0.150
     1.199    21.991     0.150
     1.199    37.711     0.150
     1.214    22.311     0.150
     1.214    38.271     0.150
     1.177    39.861     0.150
     1.235    22.331     0.150
     1.235    39.671     0.150
     1.288    41.101     0.150
     1.317    25.211     0.150
     1.317    43.631     0.150
     1.359    24.901     0.150
     1.359    43.001     0.150
     1.350    45.791     0.150
     1.412    26.991     0.150
     1.418    47.141     0.150
     1.430    26.891     0.150
     1.430    46.651     0.150
     1.455    48.331     0.150
     1.476    47.081     0.150
     1.495    26.981     0.150
     1.495    46.311     0.150
     1.524    28.521     0.150
     1.524    49.331     0.150
     1.546    27.971     0.150
     1.546    48.001     0.150
     1.546    48.101     0.150
     1.612    26.611     0.150
     1.664    30.061     0.150
     1.673    30.471     0.150
     1.673    52.031     0.150
     1.652    28.101     0.150
     1.696    53.411     0.150
     1.729    31.531     0.150
     1.729    53.791     0.150
     1.835    34.141     0.150
     1.864    56.991     0.150
     1.873    30.911     0.150
     1.898    35.311     0.150
     1.939    35.331     0.150
     2.025    34.021     0.150
     2.051    34.961     0.150
     2.061    37.601     0.150
     2.143    38.691     0.150
     2.155    39.851     0.150
     2.190    39.571     0.150
     2.215    35.831     0.150
     2.197    35.911     0.150
     2.243    41.641     0.150
     2.289    41.341     0.150
     2.296    42.481     0.150
     2.349    37.511     0.150
     2.351    43.661     0.150
     2.401    39.841     0.150
     2.392    39.101     0.150
     2.413    44.831     0.150
     2.427    44.821     0.150
     2.599    42.151     0.150
     2.701    43.411     0.150
     2.737    46.881     0.150
     2.808    45.211     0.150
     2.802    45.431     0.150
     2.822    45.061     0.150
     3.049    53.681     0.150
     3.166    49.731     0.150
     3.175    50.921     0.150
     3.290    50.881     0.150
     3.393    53.561     0.150
     3.835    59.061     0.150
     3.970    60.081     0.150
     4.028    64.521     0.150
     4.185    64.741     0.150
     4.215    65.521     0.150
     4.265    65.371     0.150
     4.341    68.171     0.150
     4.415    67.121     0.150
     4.612    70.411     0.150
     4.739    72.611     0.150
     4.847    73.911     0.150
     4.862    74.431     0.150
     4.925    75.531     0.150
     5.040    76.141     0.150
     5.236    78.661     0.150
     5.471    82.391     0.150
     5.532    82.281     0.150
     5.571    84.191     0.150
     6.041    89.421     0.150
     6.117    91.341     0.150
     0.183     4.086     0.150
     0.183     7.066     0.150
     0.183     7.977     0.150
     0.183     6.678     0.150
     0.466     8.736     0.150
     0.466    14.977     0.150
     0.453     8.477     0.150
     0.519     9.887     0.150
     0.519    17.047     0.150
     0.539    10.646     0.150
     0.539    18.457     0.150
     0.539    18.188     0.150
     0.547    10.477     0.150
     0.547    18.348     0.150
     0.547    18.656     0.150
     0.547    17.326     0.150
     0.838    15.906     0.150
     0.838    28.127     0.150
     0.891    16.736     0.150
     0.867    17.066     0.150
     0.867    29.357     0.150
     0.897    17.457     0.150
     0.946    17.688     0.150
     0.946    29.357     0.150
     0.988    18.137     0.150
     0.988    31.086     0.150
     0.988    32.197     0.150
     0.985    18.268     0.150
     0.985    32.008     0.150
     0.985    33.438     0.150
     1.069    19.438     0.150
     1.069    34.316     0.150
     1.093    20.117     0.150
     1.093    34.646     0.150
     1.109    20.066     0.150
     1.109    20.236     0.150
     1.109    34.377     0.150
     1.126    20.697     0.150
     1.126    35.336     0.150
     1.151    20.957     0.150
     1.151    35.797     0.150
     1.216    21.867     0.150
     1.216    37.586     0.150
     1.238    22.547     0.150
     1.238    38.486     0.150
     1.280    22.867     0.150
     1.280    39.537     0.150
     1.281    22.996     0.150
     1.281    39.797     0.150
     1.283    23.428     0.150
     1.283    40.438     0.150
     1.351    24.797     0.150
     1.400    24.877     0.150
     1.402    24.816     0.150
     1.402    25.008     0.150
     1.463    25.887     0.150
     1.491    26.586     0.150
     1.568    27.768     0.150
     1.590    28.137     0.150
     1.593    28.537     0.150
     1.657    29.107     0.150
     1.708    29.957     0.150
     1.792    31.406     0.150
     1.819    30.938     0.150
     1.908    32.797     0.150
     1.940    32.746     0.150
     2.028    33.428     0.150
     2.052    36.357     0.150
     2.086    34.717     0.150
     2.105    34.717     0.150
     2.122    38.527     0.150
     2.143    37.326     0.150
     2.154    35.367     0.150
     2.154    35.477     0.150
     2.179    39.467     0.150
     2.321    37.896     0.150
     2.399    39.066     0.150
     2.455    39.586     0.150
     2.480    39.348     0.150
     2.555    41.768     0.150
     2.578    47.268     0.150
     2.608    41.877     0.150
     2.871    45.867     0.150
     3.279    51.438     0.150
     3.597    56.887     0.150
     4.466    66.566     0.150
     4.540    67.928     0.150
     4.568    69.598     0.150
     4.988    76.957     0.150
     0.237     5.359     0.150
     0.237     9.039     0.150
     0.301     6.238     0.150
     0.301    10.689     0.150
     0.301    11.078     0.150
     0.301    10.439     0.150
     0.411     8.289     0.150
     0.411    13.439     0.150
     0.396     7.928     0.150
     0.650    12.398     0.150
     0.650    21.318     0.150
     0.650    22.209     0.150
     0.650    20.988     0.150
     0.675    12.818     0.150
     0.675    22.018     0.150
     0.675    22.578     0.150
     0.736    13.789     0.150
     0.736    23.408     0.150
     0.729    13.828     0.150
     0.781    14.998     0.150
     0.781    25.498     0.150
     0.781    26.598     0.150
     0.781    24.668     0.150
     0.895    16.299     0.150
     0.895    28.059     0.150
     0.895    16.639     0.150
     0.895    27.908     0.150
     0.895    27.678     0.150
     0.927    17.279     0.150
     0.927    30.369     0.150
     0.991    17.779     0.150
     0.991    30.859     0.150
     0.991    30.408     0.150
     0.982    17.918     0.150
     0.982    30.498     0.150
     0.995    18.318     0.150
     0.995    30.838     0.150
     0.973    19.258     0.150
     0.973    33.139     0.150
     0.973    17.158     0.150
     0.973    30.398     0.150
     0.971    17.848     0.150
     0.972    17.928     0.150
     1.000    18.539     0.150
     1.000    31.619     0.150
     1.084    19.178     0.150
     1.084    33.359     0.150
     1.084    36.178     0.150
     1.084    32.488     0.150
     1.050    19.229     0.150
     1.067    19.088     0.150
     1.082    19.469     0.150
     1.053    20.389     0.150
     1.053    34.639     0.150
     1.058    18.729     0.150
     1.084    20.389     0.150
     1.134    20.789     0.150
     1.179    20.848     0.150
     1.190    21.018     0.150
     1.190    36.338     0.150
     1.247    21.998     0.150
     1.221    22.098     0.150
     1.269    22.518     0.150
     1.263    22.398     0.150
     1.269    22.029     0.150
     1.269    38.398     0.150
     1.269    22.588     0.150
     1.276    24.109     0.150
     1.333    24.459     0.150
     1.292    24.049     0.150
     1.325    24.088     0.150
     1.367    23.939     0.150
     1.314    43.129     0.150
     1.370    24.139     0.150
     1.365    24.799     0.150
     1.344    44.129     0.150
     1.402    24.908     0.150
     1.382    45.029     0.150
     1.446    25.199     0.150
     1.466    25.889     0.150
     1.453    27.189     0.150
     1.473    26.818     0.150
     1.511    27.258     0.150
     1.501    28.178     0.150
     1.520    26.908     0.150
     1.547    26.598     0.150
     1.507    27.889     0.150
     1.549    28.359     0.150
     1.572    27.479     0.150
     1.580    26.338     0.150
     1.591    28.309     0.150
     1.630    28.729     0.150
     1.645    28.738     0.150
     1.651    27.088     0.150
     1.674    27.828     0.150
     1.674    48.469     0.150
     1.715    29.729     0.150
     1.724    31.199     0.150
     1.765    30.039     0.150
     1.753    28.928     0.150
     1.818    33.738     0.150
     1.858    31.758     0.150
     1.901    34.709     0.150
     1.911    32.008     0.150
     1.912    31.988     0.150
     1.931    32.699     0.150
     1.925    32.338     0.150
     1.923    31.479     0.150
     1.954    31.709     0.150
     1.955    32.439     0.150
     1.983    34.969     0.150
     1.991    34.719     0.150
     1.986    33.268     0.150
     1.993    33.008     0.150
     1.992    32.822     0.150
     1.992    60.797     0.150
     2.008    33.199     0.150
     2.014    33.008     0.150
     2.029    33.338     0.150
     2.056    33.768     0.150
     2.098    36.379     0.150
     2.106    36.969     0.150
     2.145    38.719     0.150
     2.117    33.078     0.150
     2.179    39.338     0.150
     2.146    34.498     0.150
     2.209    38.719     0.150
     2.204    37.998     0.150
     2.265    41.869     0.150
     2.309    40.258     0.150
     2.345    39.008     0.150
     2.332    37.719     0.150
     2.399    38.578     0.150
     2.451    41.328     0.150
     2.443    39.908     0.150
     2.576    39.629     0.150
     2.678    41.379     0.150
     3.003    47.518     0.150
     3.017    47.699     0.150
     3.135    49.129     0.150
     3.355    52.369     0.150
     3.529    52.699     0.150
     4.171    64.268     0.150
     4.376    67.848     0.150
     4.367    66.639     0.150
     4.330    67.469     0.150
     4.426    66.148     0.150
     4.426    65.328     0.150
     4.426   117.699     0.150
     4.552    69.328     0.150
     4.670    70.928     0.150
     5.381    79.648     0.150
     6.955   103.189     0.150
     6.955   180.029     0.150
     7.024   103.928     0.150
     7.024   221.004     0.150
     8.997   130.338     0.150
     9.081   132.303     0.150
    10.837   156.504     0.150
    12.189   174.928     0.150
    30.856   376.789     0.150
    38.244   441.729     0.150
     0.279     5.460     0.150
     0.279     9.109     0.150
     0.279     9.470     0.150
     0.279     9.000     0.150
     0.544    10.490     0.150
     0.544    18.229     0.150
     0.569    11.130     0.150
     0.569    19.010     0.150
     0.569    19.229     0.150
     0.569    18.850     0.150
     1.007    18.899     0.150
     1.007    31.800     0.150
     1.007    31.500     0.150
     1.016    18.910     0.150
     1.016    32.510     0.150
     1.016    32.880     0.150
     1.104    20.109     0.150
     1.104    35.490     0.150
     1.181    21.899     0.150
     1.181    37.450     0.150
     1.180    22.090     0.150
     1.180    38.180     0.150
     1.180    22.390     0.150
     1.415    44.939     0.150
     1.579    28.220     0.150
     1.579    48.939     0.150
     1.579    28.330     0.150
     1.579    48.770     0.150
     1.579    28.450     0.150
     1.670    29.540     0.150
     1.691    28.439     0.150
     1.691    50.740     0.150
     1.691    56.830     0.150
     1.692    31.890     0.150
     1.692    53.189     0.150
     1.694    29.600     0.150
     1.694    52.100     0.150
     1.694    29.710     0.150
     1.798    31.260     0.150
     1.798    31.760     0.150
     1.900    32.859     0.150
     1.925    32.979     0.150
     2.267    36.920     0.150
     2.301    38.000     0.150
     2.406    39.050     0.150
     2.446    40.240     0.150
     2.684    43.380     0.150
     2.692    44.330     0.150
     2.790    45.060     0.150
     2.822    49.960     0.150
     2.837    44.710     0.150
     2.920    46.280     0.150
     3.056    48.760     0.150
     3.146    49.700     0.150
     3.147    49.640     0.150
     3.377    52.950     0.150
     3.673    56.270     0.150
     3.698    56.210     0.150
     3.831    58.569     0.150
     3.977    61.790     0.150
     4.449    67.780     0.150
     4.661    70.520     0.150
     4.661   125.830     0.150
     4.661    70.380     0.150
     4.683    72.060     0.150
     4.888    73.819     0.150
     5.142    78.580     0.150
     5.225    78.750     0.150
     5.359    80.390     0.150
     5.672    85.910     0.150
     6.047    91.620     0.150
     6.285    94.189     0.150
     0.195     4.195     0.150
     0.195     6.656     0.150
     0.195     4.336     0.150
     0.195     7.477     0.150
     0.443     8.746     0.150
     0.443    14.695     0.150
     0.464     9.006     0.150
     0.464    15.057     0.150
     0.529    10.176     0.150
     0.529    17.346     0.150
     0.547    10.836     0.150
     0.547    18.176     0.150
     0.547    18.346     0.150
     0.542    10.656     0.150
     0.542    17.496     0.150
     0.661    12.416     0.150
     0.661    21.396     0.150
     0.826    16.125     0.150
     0.855    17.295     0.150
     0.855    29.715     0.150
     0.894    16.586     0.150
     0.894    28.205     0.150
     0.894    16.695     0.150
     0.894    28.896     0.150
     0.912    16.965     0.150
     0.912    28.676     0.150
     0.886    17.816     0.150
     0.886    30.705     0.150
     0.886    16.965     0.150
     0.886    28.996     0.150
     0.897    17.785     0.150
     0.897    31.516     0.150
     0.897    16.896     0.150
     0.897    29.176     0.150
     0.909    17.025     0.150
     0.909    29.596     0.150
     0.910    18.057     0.150
     0.910    31.387     0.150
     0.934    17.977     0.150
     0.934    30.965     0.150
     0.974    18.125     0.150
     0.974    31.785     0.150
     0.999    18.396     0.150
     0.999    31.465     0.150
     1.083    20.256     0.150
     1.083    35.455     0.150
     1.083    21.346     0.150
     1.083    36.816     0.150
     1.083    19.996     0.150
     1.083    34.775     0.150
     1.101    20.205     0.150
     1.101    34.605     0.150
     1.101    34.727     0.150
     1.124    20.807     0.150
     1.124    35.766     0.150
     1.124    35.936     0.150
     1.124    35.105     0.150
     1.144    21.246     0.150
     1.144    36.215     0.150
     1.144    36.346     0.150
     1.213    22.115     0.150
     1.213    37.855     0.150
     1.276    23.346     0.150
     1.276    40.025     0.150
     1.276    23.096     0.150
     1.276    23.477     0.150
     1.311    25.506     0.150
     1.311    23.736     0.150
     1.311    41.807     0.150
     1.381    25.506     0.150
     1.381    43.396     0.150
     1.397    25.105     0.150
     1.397    43.035     0.150
     1.397    24.807     0.150
     1.397    42.826     0.150
     1.489    26.865     0.150
     1.489    26.406     0.150
     1.489    45.826     0.150
     1.503    26.416     0.150
     1.503    46.426     0.150
     1.514    25.855     0.150
     1.583    27.545     0.150
     1.583    48.586     0.150
     1.587    28.387     0.150
     1.587    28.215     0.150
     1.587    48.736     0.150
     1.653    29.295     0.150
     1.653    50.686     0.150
     1.649    27.916     0.150
     1.649    28.045     0.150
     1.649    51.125     0.150
     1.696    29.605     0.150
     1.696    52.375     0.150
     1.787    31.186     0.150
     1.811    31.066     0.150
     1.826    31.686     0.150
     1.826    56.166     0.150
     1.892    30.816     0.150
     1.892    30.646     0.150
     2.046    35.346     0.150
     2.046    62.455     0.150
     2.094    34.586     0.150
     2.094    35.545     0.150
     2.147    35.275     0.150
     2.151    36.215     0.150
     2.388    39.525     0.150
     2.445    40.615     0.150
     2.550    41.535     0.150
     2.600    42.646     0.150
     3.081    46.705     0.150
     3.076    47.455     0.150
     3.136    48.275     0.150
     3.146    48.096     0.150
     3.188    47.596     0.150
     3.188    92.295     0.150
     3.349    50.926     0.150
     3.912    60.656     0.150
     4.115    61.455     0.150
     4.225    63.945     0.150
     4.225    64.436     0.150
     4.533    66.227     0.150
     5.809    87.896     0.150
     5.930    89.096     0.150
     6.416    94.605     0.150
     8.779   131.246     0.150
     8.779   128.285     0.150
     0.193     3.781     0.150
     0.193     6.750     0.150
     0.193     4.201     0.150
     0.193     7.311     0.150
     0.447     8.691     0.150
     0.447    14.801     0.150
     0.469     9.012     0.150
     0.469    15.211     0.150
     0.531    10.111     0.150
     0.531    17.141     0.150
     0.542    10.820     0.150
     0.542    18.170     0.150
     0.537    10.641     0.150
     0.537    17.361     0.150
     0.537    17.490     0.150
     0.542    18.301     0.150
     0.662    12.441     0.150
     0.662    21.131     0.150
     0.827    16.131     0.150
     0.827    27.621     0.150
     0.855    16.750     0.150
     0.855    30.012     0.150
     0.899    16.490     0.150
     0.899    28.750     0.150
     0.899    16.820     0.150
     0.899    28.900     0.150
     0.884    17.131     0.150
     0.884    16.521     0.150
     0.884    28.670     0.150
     0.897    17.512     0.150
     0.897    31.631     0.150
     0.897    16.910     0.150
     0.897    29.041     0.150
     0.916    16.910     0.150
     0.916    29.191     0.150
     0.911    17.170     0.150
     0.911    29.670     0.150
     0.912    17.781     0.150
     0.912    29.691     0.150
     0.936    18.031     0.150
     0.936    30.012     0.150
     0.977    18.551     0.150
     0.977    31.590     0.150
     0.996    18.371     0.150
     0.996    31.461     0.150
     0.996    31.150     0.150
     1.058    19.660     0.150
     1.058    34.791     0.150
     1.087    20.230     0.150
     1.087    34.811     0.150
     1.086    20.480     0.150
     1.086    36.400     0.150
     1.086    20.051     0.150
     1.086    34.771     0.150
     1.105    34.791     0.150
     1.105    20.160     0.150
     1.105    20.391     0.150
     1.105    34.670     0.150
     1.129    35.740     0.150
     1.129    20.861     0.150
     1.129    20.750     0.150
     1.129    35.971     0.150
     1.148    21.281     0.150
     1.148    36.531     0.150
     1.152    21.031     0.150
     1.152    37.041     0.150
     1.218    22.201     0.150
     1.218    38.291     0.150
     1.218    37.801     0.150
     1.256    22.910     0.150
     1.281    23.182     0.150
     1.281    39.811     0.150
     1.312    23.490     0.150
     1.385    24.400     0.150
     1.385    44.352     0.150
     1.402    24.660     0.150
     1.402    25.090     0.150
     1.402    43.131     0.150
     1.476    26.480     0.150
     1.476    46.182     0.150
     1.494    26.762     0.150
     1.494    46.131     0.150
     1.508    27.730     0.150
     1.508    26.240     0.150
     1.508    46.512     0.150
     1.513    25.781     0.150
     1.588    27.670     0.150
     1.588    49.301     0.150
     1.592    28.271     0.150
     1.592    48.920     0.150
     1.658    29.170     0.150
     1.658    50.670     0.150
     1.650    27.811     0.150
     1.650    51.531     0.150
     1.701    29.531     0.150
     1.701    52.490     0.150
     1.757    28.740     0.150
     1.757    50.051     0.150
     1.793    31.541     0.150
     1.816    32.611     0.150
     1.831    31.791     0.150
     1.831    56.230     0.150
     1.888    30.740     0.150
     2.041    35.080     0.150
     2.041    62.070     0.150
     2.151    34.721     0.150
     2.151    35.770     0.150
     2.151    39.295     0.150
     2.151    65.945     0.150
     2.155    36.041     0.150
     2.389    37.311     0.150
     2.449    38.701     0.150
     2.604    42.541     0.150
     2.628    41.762     0.150
     3.079    48.391     0.150
     3.085    50.131     0.150
     3.140    48.691     0.150
     3.183    57.881     0.150
     3.183    88.400     0.150
     3.702    57.660     0.150
     3.942    60.730     0.150
     4.220    63.221     0.150
     4.222    62.670     0.150
     4.222    63.230     0.150
     4.222   121.980     0.150
     4.373    65.811     0.150
     4.688    70.480     0.150
     4.951    75.420     0.150
     5.177   136.811     0.150
     5.177    75.061     0.150
     5.334    79.670     0.150
     5.601    83.791     0.150
     5.813    86.512     0.150
     5.932    89.711     0.150
     5.943    88.451     0.150
     6.421    95.012     0.150
     7.059   105.051     0.150
     7.127   105.160     0.150
     7.185   105.977     0.150
     7.185   131.076     0.150
     7.765   114.271     0.150
     8.178   121.691     0.150
     8.423   123.369     0.150
     8.736   130.711     0.150
     8.776   128.262     0.150
     8.779   131.201     0.150
     9.172   134.625     0.150
     9.172   173.801     0.150
     9.189   132.352     0.150
    10.198   146.881     0.150
    10.595   154.900     0.150
    10.596   333.479     0.150
    10.596   154.670     0.150
    11.176   162.701     0.150
    11.589   169.762     0.150
    12.197   176.900     0.150
    14.238   203.830     0.150
    14.991   215.641     0.150
    15.260   215.670     0.150
    15.484   226.500     0.150
    16.630   235.490     0.150
    17.092   239.070     0.150
    17.261   244.500     0.150
    17.891   249.570     0.150
    18.891   262.441     0.150
    19.380   266.281     0.150
    80.833   733.389     0.150
   102.002   837.102     0.150
     0.209     4.453     0.150
     0.209     7.174     0.150
     0.209     7.744     0.150
     0.432     8.904     0.150
     0.432    14.764     0.150
     0.464    15.834     0.150
     0.535    10.613     0.150
     0.535    17.344     0.150
     0.555    10.943     0.150
     0.555    18.314     0.150
     0.555    18.545     0.150
     0.542    10.373     0.150
     0.542    17.514     0.150
     0.646    12.645     0.150
     0.646    21.834     0.150
     0.812    15.844     0.150
     0.812    27.014     0.150
     0.841    17.484     0.150
     0.841    30.273     0.150
     0.873    17.885     0.150
     0.873    30.814     0.150
     0.873    16.475     0.150
     0.873    28.924     0.150
     0.882    18.055     0.150
     0.882    31.395     0.150
     0.882    16.814     0.150
     0.882    29.215     0.150
     0.895    17.045     0.150
     0.895    29.334     0.150
     0.896    17.914     0.150
     0.920    17.783     0.150
     0.920    30.584     0.150
     0.898    17.203     0.150
     0.898    29.055     0.150
     0.898    16.715     0.150
     0.898    28.834     0.150
     0.918    17.064     0.150
     0.918    29.395     0.150
     0.962    18.113     0.150
     0.962    31.363     0.150
     1.012    18.555     0.150
     1.012    31.645     0.150
     1.012    31.484     0.150
     1.043    19.863     0.150
     1.043    34.314     0.150
     1.070    21.734     0.150
     1.070    37.523     0.150
     1.070    19.395     0.150
     1.070    34.385     0.150
     1.072    20.504     0.150
     1.072    35.693     0.150
     1.091    20.523     0.150
     1.091    35.273     0.150
     1.136    20.984     0.150
     1.136    36.773     0.150
     1.136    21.523     0.150
     1.136    36.363     0.150
     1.122    21.164     0.150
     1.122    35.434     0.150
     1.122    21.045     0.150
     1.122    35.725     0.150
     1.122    35.914     0.150
     1.175    23.453     0.150
     1.175    40.635     0.150
     1.211    22.434     0.150
     1.211    38.363     0.150
     1.211    38.094     0.150
     1.240    42.693     0.150
     1.241    22.654     0.150
     1.241    40.225     0.150
     1.273    24.773     0.150
     1.267    23.994     0.150
     1.296    25.604     0.150
     1.296    23.613     0.150
     1.296    41.145     0.150
     1.273    23.664     0.150
     1.273    23.264     0.150
     1.273    40.244     0.150
     1.325    25.814     0.150
     1.333    25.344     0.150
     1.371    26.074     0.150
     1.370    24.604     0.150
     1.370    44.703     0.150
     1.393    25.453     0.150
     1.393    43.773     0.150
     1.393    25.264     0.150
     1.393    43.314     0.150
     1.394    25.514     0.150
     1.455    26.514     0.150
     1.487    27.094     0.150
     1.487    26.885     0.150
     1.487    46.324     0.150
     1.502    26.854     0.150
     1.502    48.373     0.150
     1.502    27.225     0.150
     1.528    28.684     0.150
     1.557    28.373     0.150
     1.581    29.334     0.150
     1.584    28.664     0.150
     1.584    28.523     0.150
     1.584    49.193     0.150
     1.584    28.064     0.150
     1.584    49.523     0.150
     1.635    51.135     0.150
     1.649    29.654     0.150
     1.649    51.094     0.150
     1.688    30.094     0.150
     1.688    54.754     0.150
     1.754    28.924     0.150
     1.754    53.574     0.150
     1.783    31.834     0.150
     1.803    31.385     0.150
     1.819    32.014     0.150
     1.819    56.023     0.150
     1.883    30.885     0.150
     2.051    35.193     0.150
     2.051    62.363     0.150
     2.082    35.045     0.150
     2.138    35.834     0.150
     2.145    36.645     0.150
     2.373    39.094     0.150
     2.435    40.193     0.150
     2.546    41.604     0.150
     2.592    42.635     0.150
     2.612    43.834     0.150
     3.073    49.314     0.150
     3.126    49.965     0.150
     3.140    49.934     0.150
     3.193    89.014     0.150
     3.689    55.715     0.150
     3.900    59.414     0.150
     3.932    59.773     0.150
     4.108    63.113     0.150
     4.214   110.484     0.150
     4.214    63.975     0.150
     4.186    64.064     0.150
     4.242    65.805     0.150
     4.343    66.814     0.150
     4.363    67.545     0.150
     4.525    70.074     0.150
     4.594    71.074     0.150
     4.674    72.135     0.150
     4.935    76.744     0.150
     4.980    76.664     0.150
     5.587    84.975     0.150
     5.608    84.783     0.150
     5.802    87.494     0.150
     5.916    90.664     0.150
     5.956    90.465     0.150
     6.059    91.965     0.150
     6.256    95.924     0.150
     6.414    96.684     0.150
     6.759   100.773     0.150
     7.698   113.055     0.150
     7.754   114.895     0.150
     0.201     4.172     0.150
     0.201     7.367     0.150
     0.201     8.227     0.150
     0.431     8.625     0.150
     0.431    14.336     0.150
     0.449     8.648     0.150
     0.449    14.812     0.150
     0.525     9.945     0.150
     0.525    17.297     0.150
     0.554    10.852     0.150
     0.554    17.930     0.150
     0.554    17.828     0.150
     0.562    11.000     0.150
     0.562    18.266     0.150
     0.562    19.039     0.150
     0.562    18.477     0.150
     0.655    12.516     0.150
     0.854    30.242     0.150
     0.880    16.609     0.150
     0.880    28.375     0.150
     0.880    16.258     0.150
     0.880    28.562     0.150
     0.890    30.891     0.150
     0.900    16.516     0.150
     0.900    29.258     0.150
     1.009    18.406     0.150
     1.009    31.680     0.150
     1.009    32.289     0.150
     1.009    31.461     0.150
     1.071    20.688     0.150
     1.071    34.961     0.150
     1.087    20.359     0.150
     1.087    34.328     0.150
     1.108    20.859     0.150
     1.108    35.289     0.150
     1.108    35.422     0.150
     1.129    21.297     0.150
     1.129    36.219     0.150
     1.197    22.148     0.150
     1.197    37.422     0.150
     1.381    25.227     0.150
     1.381    42.961     0.150
     1.382    25.289     0.150
     1.382    42.867     0.150
     1.571    28.359     0.150
     1.571    48.398     0.150
     1.642    28.711     0.150
     1.772    31.641     0.150
     1.772    54.047     0.150
     1.797    32.578     0.150
     1.811    33.266     0.150
     1.811    56.992     0.150
     1.887    58.625     0.150
     1.902    32.297     0.150
     1.918    35.695     0.150
     1.918    60.711     0.150
     2.063    37.328     0.150
     2.063    64.680     0.150
     2.064    37.906     0.150
     2.064    64.609     0.150
     2.132    36.320     0.150
     2.135    36.789     0.150
     2.157    39.891     0.150
     2.157    67.336     0.150
     2.535    41.562     0.150
     2.585    42.891     0.150
     3.265    51.445     0.150
     4.273    65.930     0.150
     4.971    76.258     0.150
     0.193     4.308     0.150
     0.193     6.998     0.150
     0.193     8.308     0.150
     0.528    10.107     0.150
     0.528    17.107     0.150
     0.463     8.928     0.150
     0.463    15.098     0.150
     0.444     8.668     0.150
     0.444    14.498     0.150
     0.547    10.878     0.150
     0.547    18.338     0.150
     0.543    10.728     0.150
     0.543    17.628     0.150
     0.893    16.367     0.150
     0.893    28.367     0.150
     0.893    16.678     0.150
     0.911    16.848     0.150
     0.911    29.128     0.150
     0.998    18.348     0.150
     0.998    31.447     0.150
     0.998    31.317     0.150
     0.857    17.348     0.150
     0.857    29.828     0.150
     0.911    18.178     0.150
     0.911    31.468     0.150
     0.888    18.018     0.150
     0.898    31.088     0.150
     0.935    18.397     0.150
     0.935    30.828     0.150
     1.123    20.758     0.150
     1.123    35.918     0.150
     1.123    20.628     0.150
     1.123    35.737     0.150
     1.084    20.168     0.150
     1.084    35.088     0.150
     1.101    20.298     0.150
     1.084    37.168     0.150
     1.144    21.168     0.150
     1.212    22.128     0.150
     1.212    37.878     0.150
     1.276    23.288     0.150
     1.276    40.248     0.150
     1.276    40.558     0.150
     1.276    23.638     0.150
     1.284    24.498     0.150
     1.396    25.188     0.150
     1.396    43.798     0.150
     1.311    43.768     0.150
     1.338    25.458     0.150
     1.338    44.748     0.150
     1.382    25.737     0.150
     1.382    44.737     0.150
     1.458    26.178     0.150
     1.458    45.357     0.150
     1.488    46.078     0.150
     1.502    25.867     0.150
     1.379    26.527     0.150
     1.485    27.508     0.150
     1.586    28.508     0.150
     1.562    28.308     0.150
     1.562    48.758     0.150
     1.587    29.018     0.150
     1.515    25.998     0.150
     1.653    29.397     0.150
     1.653    50.388     0.150
     1.626    30.418     0.150
     1.641    31.008     0.150
     1.702    30.737     0.150
     1.702    53.027     0.150
     1.650    29.348     0.150
     1.787    30.107     0.150
     1.805    29.808     0.150
     1.811    30.987     0.150
     1.826    31.828     0.150
     1.917    33.688     0.150
     1.933    35.817     0.150
     1.894    30.768     0.150
     2.047    37.718     0.150
     2.047    65.027     0.150
     2.079    38.038     0.150
     2.138    37.328     0.150
     2.115    38.758     0.150
     2.018    33.268     0.150
     2.150    35.317     0.150
     2.174    41.178     0.150
     2.095    34.697     0.150
     2.147    35.228     0.150
     2.172    39.697     0.150
     2.223    40.348     0.150
     2.389    39.607     0.150
     2.446    39.878     0.150
     2.550    40.688     0.150
     2.473    39.438     0.150
     2.600    41.558     0.150
     2.626    43.178     0.150
     2.847    45.947     0.150
     3.081    48.958     0.150
     3.145    49.308     0.150
     3.181    52.288     0.150
     3.137    49.317     0.150
     3.516    56.058     0.150
     3.846    59.157     0.150
     4.115    62.388     0.150
     4.195    63.598     0.150
     4.533    68.038     0.150
     4.558    69.407     0.150
     4.684    70.918     0.150
     5.335    79.958     0.150
     5.646    84.647     0.150
     5.750    85.938     0.150
     6.771    99.678     0.150
     0.243     5.152     0.150
     0.243     8.652     0.150
     0.244     5.160     0.150
     0.244     8.402     0.150
     0.387     7.820     0.150
     0.387    13.223     0.150
     0.387    13.684     0.150
     0.387    12.891     0.150
     0.407     8.391     0.150
     0.407    13.973     0.150
     0.407    14.184     0.150
     0.651    12.172     0.150
     0.651    20.730     0.150
     0.651    12.391     0.150
     0.696    12.980     0.150
     0.696    22.684     0.150
     0.723    14.434     0.150
     0.723    25.883     0.150
     0.779    14.301     0.150
     0.779    24.801     0.150
     0.792    16.004     0.150
     0.792    27.473     0.150
     0.838    15.863     0.150
     0.838    27.953     0.150
     0.890    17.754     0.150
     0.890    30.832     0.150
     0.977    17.992     0.150
     0.977    30.973     0.150
     0.977    31.863     0.150
     0.977    30.031     0.150
     0.973    19.273     0.150
     0.973    34.121     0.150
     0.973    32.691     0.150
     0.979    18.684     0.150
     0.979    31.461     0.150
     1.225    22.102     0.150
     1.225    38.383     0.150
     1.252    23.434     0.150
     1.428    25.883     0.150
     1.428    43.773     0.150
     1.511    45.332     0.150
     1.680    29.531     0.150
     1.665    27.594     0.150
     1.811    31.793     0.150
     1.814    32.691     0.150
     1.878    30.812     0.150
     2.042    35.812     0.150
     2.068    35.422     0.150
     2.213    37.121     0.150
     2.278    37.461     0.150
     2.367    39.410     0.150
     2.418    40.031     0.150
     2.405    40.863     0.150
     2.616    42.871     0.150
     2.716    44.383     0.150
     2.819    45.871     0.150
     2.825    45.934     0.150
     3.191    51.371     0.150
     3.847    59.230     0.150
     3.857    59.594     0.150
     3.967    59.953     0.150
     4.045    60.812     0.150
     4.225    66.703     0.150
     4.421    66.961     0.150
     4.757    72.633     0.150
     4.864    73.863     0.150
     4.887    73.781     0.150
     4.896    74.703     0.150
     4.935    75.863     0.150
     5.176    77.992     0.150
     5.243    79.723     0.150
     5.531    82.461     0.150
     5.940    89.121     0.150
     5.953    88.754     0.150
     6.506    94.844     0.150
     0.288     6.094     0.150
     0.288    10.424     0.150
     0.288    10.854     0.150
     0.365     7.135     0.150
     0.365    11.924     0.150
     0.366     7.145     0.150
     0.366    12.293     0.150
     0.533    10.324     0.150
     0.533    17.793     0.150
     0.633    12.225     0.150
     0.633    20.713     0.150
     0.672    12.764     0.150
     0.672    21.604     0.150
     0.672    21.984     0.150
     0.644    12.154     0.150
     0.644    20.814     0.150
     0.768    27.254     0.150
     0.787    27.793     0.150
     0.800    15.834     0.150
     0.800    27.404     0.150
     0.861    17.725     0.150
     0.861    29.984     0.150
     0.918    18.174     0.150
     0.925    18.863     0.150
     0.925    31.734     0.150
     0.992    18.123     0.150
     0.992    31.234     0.150
     0.986    34.494     0.150
     1.027    19.773     0.150
     1.027    34.023     0.150
     1.089    20.244     0.150
     1.089    34.873     0.150
     1.155    21.783     0.150
     1.257    23.273     0.150
     1.288    23.924     0.150
     1.288    41.084     0.150
     1.372    24.984     0.150
     1.372    42.863     0.150
     1.416    25.914     0.150
     1.426    25.814     0.150
     1.426    43.984     0.150
     1.545    27.754     0.150
     1.601    29.363     0.150
     1.609    28.943     0.150
     1.669    29.824     0.150
     1.711    31.344     0.150
     1.755    31.904     0.150
     1.918    31.805     0.150
     1.924    35.193     0.150
     1.934    33.305     0.150
     2.139    37.213     0.150
     2.196    40.314     0.150
     2.253    39.354     0.150
     2.288    39.834     0.150
     2.315    37.363     0.150
     2.374    41.463     0.150
     2.522    42.293     0.150
     2.693    46.424     0.150
     3.194    51.055     0.150
     4.147    69.324     0.150
     4.462    68.203     0.150
     4.933    76.424     0.150
     5.916    89.754     0.150
     0.182     3.953     0.150
     0.182     6.945     0.150
     0.182     7.926     0.150
     0.468     8.977     0.150
     0.468    15.227     0.150
     0.468    16.344     0.150
     0.490     9.266     0.150
     0.490    15.977     0.150
     0.533    10.035     0.150
     0.533    17.414     0.150
     0.520    10.375     0.150
     0.520    17.766     0.150
     0.520    17.434     0.150
     0.524    10.305     0.150
     0.524    17.203     0.150
     0.674    12.715     0.150
     0.862    17.285     0.150
     0.885    17.203     0.150
     0.909    18.035     0.150
     0.931    17.016     0.150
     0.931    29.477     0.150
     0.931    29.656     0.150
     0.927    18.086     0.150
     0.927    32.156     0.150
     0.950    18.965     0.150
     0.950    33.156     0.150
     0.978    17.965     0.150
     0.978    30.984     0.150
     0.996    18.727     0.150
     1.019    19.316     0.150
     1.069    19.824     0.150
     1.104    20.574     0.150
     1.104    36.324     0.150
     1.107    20.477     0.150
     1.150    21.137     0.150
     1.150    36.164     0.150
     1.150    37.453     0.150
     1.171    21.625     0.150
     1.222    23.477     0.150
     1.223    22.125     0.150
     1.240    22.477     0.150
     1.240    38.535     0.150
     1.240    38.113     0.150
     1.242    23.344     0.150
     1.242    39.816     0.150
     1.260    24.293     0.150
     1.303    23.426     0.150
     1.303    40.043     0.150
     1.303    23.637     0.150
     1.303    40.914     0.150
     1.302    24.113     0.150
     1.326    23.555     0.150
     1.360    25.953     0.150
     1.368    25.344     0.150
     1.368    43.535     0.150
     1.396    24.523     0.150
     1.423    25.523     0.150
     1.423    43.906     0.150
     1.425    25.484     0.150
     1.486    26.543     0.150
     1.486    45.715     0.150
     1.498    47.477     0.150
     1.515    27.043     0.150
     1.515    46.273     0.150
     1.515    46.543     0.150
     1.529    27.695     0.150
     1.529    47.977     0.150
     1.541    26.285     0.150
     1.563    28.004     0.150
     1.563    49.043     0.150
     1.590    28.406     0.150
     1.590    49.605     0.150
     1.607    29.086     0.150
     1.614    28.715     0.150
     1.614    49.477     0.150
     1.615    29.137     0.150
     1.615    51.195     0.150
     1.651    28.836     0.150
     1.668    52.645     0.150
     1.664    28.105     0.150
     1.680    29.703     0.150
     1.680    51.355     0.150
     1.694    52.773     0.150
     1.723    29.703     0.150
     1.729    30.703     0.150
     1.729    53.836     0.150
     1.794    55.137     0.150
     1.815    31.465     0.150
     1.833    55.656     0.150
     1.838    31.406     0.150
     1.853    32.113     0.150
     1.853    57.086     0.150
     1.853    32.203     0.150
     1.857    30.816     0.150
     1.878    30.504     0.150
     1.944    33.844     0.150
     2.074    35.703     0.150
     2.086    36.293     0.150
     2.116    34.656     0.150
     2.139    35.227     0.150
     2.166    37.844     0.150
     2.173    35.543     0.150
     2.178    36.555     0.150
     2.181    36.727     0.150
     2.187    36.004     0.150
     2.215    36.984     0.150
     2.250    37.426     0.150
     2.299    39.914     0.150
     2.341    38.523     0.150
     2.343    38.613     0.150
     2.392    39.605     0.150
     2.404    38.543     0.150
     2.470    40.125     0.150
     2.462    39.203     0.150
     2.577    43.637     0.150
     2.578    42.113     0.150
     2.627    42.816     0.150
     2.646    42.043     0.150
     2.764    45.113     0.150
     3.161    54.355     0.150
     3.161    92.066     0.150
     3.275    51.105     0.150
     3.377    53.227     0.150
     3.627    56.875     0.150
     3.848    59.035     0.150
     4.002    60.586     0.150
     4.142    63.375     0.150
     4.216    63.746     0.150
     4.216   115.336     0.150
     4.241    64.945     0.150
     4.454    66.914     0.150
     4.561    69.164     0.150
     4.593    68.445     0.150
     4.624    70.316     0.150
     4.709    71.113     0.150
     4.787    72.773     0.150
     4.787    72.535     0.150
     4.787   126.246     0.150
     4.970    74.086     0.150
     4.991    74.855     0.150
     5.372    80.926     0.150
     5.372   143.965     0.150
    15.036   211.734     0.150
    15.076   212.156     0.150
    15.368   216.586     0.150
    15.387   216.754     0.150
    15.526   217.945     0.150
    16.355   229.086     0.150
    16.376   229.863     0.150
    17.262   241.266     0.150
    18.590   256.746     0.150
    18.911   260.793     0.150
    20.279   275.625     0.150
    20.302   276.293     0.150
    20.718   280.246     0.150
    20.764   280.695     0.150
    22.709   301.316     0.150
    23.112   305.625     0.150
    24.931   323.184     0.150
    27.600   346.637     0.150
    30.492   372.703     0.150
     0.186     4.082     0.150
     0.186     6.590     0.150
     0.186     7.859     0.150
     0.186     3.980     0.150
     0.186     6.250     0.150
     0.462     9.020     0.150
     0.462    15.332     0.150
     0.484     9.160     0.150
     0.484    15.762     0.150
     0.533    10.109     0.150
     0.533    17.031     0.150
     0.533    17.410     0.150
     0.527    10.441     0.150
     0.527    17.289     0.150
     0.528    10.430     0.150
     0.528    17.219     0.150
     0.927    17.031     0.150
     0.927    30.270     0.150
     0.923    18.020     0.150
     0.923    31.430     0.150
     0.945    18.980     0.150
     0.945    31.750     0.150
     0.984    18.129     0.150
     0.984    31.289     0.150
     0.991    18.570     0.150
     0.991    31.750     0.150
     1.065    35.762     0.150
     1.101    20.820     0.150
     1.120    20.512     0.150
     1.120    34.859     0.150
     1.144    21.109     0.150
     1.144    36.270     0.150
     1.144    20.840     0.150
     1.144    35.941     0.150
     1.164    21.512     0.150
     1.234    22.441     0.150
     1.234    38.359     0.150
     1.234    37.840     0.150
     1.418    25.180     0.150
     1.523    26.660     0.150
     1.494    27.762     0.150
     1.602    28.879     0.150
     1.644    28.762     0.150
     1.660    27.781     0.150
     1.808    31.262     0.150
     1.832    31.309     0.150
     1.881    30.559     0.150
     2.111    34.750     0.150
     2.133    35.211     0.150
     2.167    35.332     0.150
     2.171    37.082     0.150
     2.464    40.449     0.150
     2.463    39.422     0.150
     2.571    41.680     0.150
     2.620    42.059     0.150
     2.640    42.711     0.150
     3.092    48.781     0.150
     3.620    55.199     0.150
     3.843    59.641     0.150
     4.136    61.992     0.150
     4.235    64.180     0.150
     4.217    63.660     0.150
     4.285    67.172     0.150
     4.559    68.922     0.150
     4.703    72.219     0.150
     4.984    77.121     0.150
     5.942    90.070     0.150
     6.107    91.602     0.150
     0.286     6.027     0.150
     0.286     9.516     0.150
     0.287     6.027     0.150
     0.287    10.117     0.150
     0.287    10.527     0.150
     0.345     7.086     0.150
     0.345    11.855     0.150
     0.345    12.398     0.150
     0.345    11.996     0.150
     0.383     7.688     0.150
     0.383    12.777     0.150
     0.383    13.516     0.150
     0.383    14.137     0.150
     0.645    12.348     0.150
     0.645    21.156     0.150
     0.645    12.246     0.150
     0.737    13.688     0.150
     0.737    23.285     0.150
     0.737    23.438     0.150
     0.714    13.617     0.150
     0.714    22.918     0.150
     0.762    26.707     0.150
     0.822    16.809     0.150
     0.822    28.547     0.150
     0.822    29.008     0.150
     0.861    28.566     0.150
     0.945    17.105     0.150
     0.945    29.348     0.150
     0.945    29.766     0.150
     0.915    18.258     0.150
     0.993    19.598     0.150
     0.993    20.016     0.150
     0.993    33.527     0.150
     0.993    33.977     0.150
     0.995    19.418     0.150
     0.995    32.598     0.150
     1.190    21.617     0.150
     1.190    37.098     0.150
     1.190    37.207     0.150
     1.304    41.578     0.150
     1.405    25.355     0.150
     1.405    44.258     0.150
     1.405    25.488     0.150
     1.405    43.836     0.150
     1.490    26.527     0.150
     1.490    46.316     0.150
     1.490    46.156     0.150
     1.535    27.266     0.150
     1.542    28.938     0.150
     1.648    27.098     0.150
     1.664    29.137     0.150
     1.664    51.008     0.150
     1.690    28.238     0.150
     1.728    31.008     0.150
     1.798    30.938     0.150
     1.798    55.008     0.150
     1.773    33.766     0.150
     1.787    30.285     0.150
     1.787    55.027     0.150
     1.816    30.445     0.150
     1.816    55.137     0.150
     1.901    33.809     0.150
     2.021    33.586     0.150
     2.037    33.316     0.150
     2.053    34.527     0.150
     2.053    61.336     0.150
     2.226    36.227     0.150
     2.255    36.406     0.150
     2.285    37.508     0.150
     2.364    37.508     0.150
     2.383    39.938     0.150
     2.406    39.367     0.150
     2.431    39.547     0.150
     2.622    42.086     0.150
     2.733    43.777     0.150
     2.811    45.117     0.150
     2.817    45.867     0.150
     3.210    50.797     0.150
     3.248    53.938     0.150
     3.314    51.496     0.150
     3.377    52.648     0.150
     3.399    52.637     0.150
     3.616    55.586     0.150
     3.758    56.836     0.150
     3.848    59.918     0.150
     3.874    59.598     0.150
     4.192    62.559     0.150
     4.310    64.605     0.150
     4.352    64.137     0.150
     4.413    66.438     0.150
     4.461    67.996     0.150
     4.620    68.766     0.150
     4.869    74.078     0.150
     4.968    76.148     0.150
     5.241    79.547     0.150
     5.558    85.219     0.150
     5.575    83.957     0.150
     5.613    85.227     0.150
     5.968    90.195     0.150
     5.994    90.168     0.150
     0.167     3.764     0.150
     0.167     6.503     0.150
     0.167     6.874     0.150
     0.167     6.133     0.150
     0.475     9.374     0.150
     0.475    15.664     0.150
     0.475    16.354     0.150
     0.475    15.414     0.150
     0.498     9.773     0.150
     0.498    16.403     0.150
     0.499     9.773     0.150
     0.499    16.394     0.150
     0.499    16.023     0.150
     0.510    10.063     0.150
     0.510    17.244     0.150
     0.510    16.574     0.150
     0.540    10.273     0.150
     0.540    17.613     0.150
     0.700    13.333     0.150
     0.700    22.724     0.150
     0.863    16.483     0.150
     0.863    16.844     0.150
     0.863    29.233     0.150
     0.944    17.233     0.150
     0.944    29.383     0.150
     0.944    30.313     0.150
     0.944    29.094     0.150
     0.962    17.874     0.150
     0.962    30.684     0.150
     0.962    17.604     0.150
     0.959    19.193     0.150
     0.978    18.144     0.150
     0.978    33.644     0.150
     1.046    21.054     0.150
     1.149    22.193     0.150
     1.149    37.833     0.150
     1.170    21.833     0.150
     1.170    37.753     0.150
     1.193    21.813     0.150
     1.193    37.463     0.150
     1.193    22.324     0.150
     1.193    37.954     0.150
     1.193    22.074     0.150
     1.216    22.664     0.150
     1.216    38.443     0.150
     1.284    23.304     0.150
     1.284    40.043     0.150
     1.289    38.943     0.150
     1.349    24.903     0.150
     1.349    42.374     0.150
     1.349    26.113     0.150
     1.412    26.604     0.150
     1.412    45.744     0.150
     1.468    26.693     0.150
     1.468    45.574     0.150
     1.470    26.704     0.150
     1.470    45.374     0.150
     1.522    48.153     0.150
     1.531    27.563     0.150
     1.531    47.613     0.150
     1.608    29.764     0.150
     1.608    50.874     0.150
     1.635    29.844     0.150
     1.635    51.014     0.150
     1.658    50.894     0.150
     1.692    28.574     0.150
     1.694    31.733     0.150
     1.726    31.264     0.150
     1.726    52.914     0.150
     1.775    32.963     0.150
     1.860    32.733     0.150
     1.899    34.923     0.150
     2.027    33.514     0.150
     2.155    36.773     0.150
     2.224    37.684     0.150
     2.343    41.083     0.150
     2.419    44.023     0.150
     2.448    39.244     0.150
     2.623    44.414     0.150
     2.682    43.704     0.150
     4.310    67.943     0.150
     4.570    69.954     0.150
     5.011    77.224     0.150
     5.247    80.193     0.150
     5.358    81.383     0.150
     5.645    86.204     0.150
     5.975    90.193     0.150
     0.346     6.816     0.150
     0.561    10.617     0.150
     0.561    18.127     0.150
     0.561    18.686     0.150
     0.561    10.355     0.150
     0.562    10.387     0.150
     0.562    17.877     0.150
     0.562    18.576     0.150
     0.560    10.926     0.150
     0.560    18.396     0.150
     0.560    19.217     0.150
     0.644    12.256     0.150
     0.644    20.877     0.150
     0.728    13.777     0.150
     0.734    13.436     0.150
     0.734    23.117     0.150
     0.734    22.936     0.150
     0.759    14.227     0.150
     0.759    23.746     0.150
     0.769    14.166     0.150
     0.769    24.006     0.150
     0.794    14.736     0.150
     0.794    24.996     0.150
     0.818    15.256     0.150
     0.806    14.605     0.150
     0.806    25.156     0.150
     0.822    14.986     0.150
     0.822    25.406     0.150
     0.851    16.156     0.150
     0.874    16.646     0.150
     0.900    16.877     0.150
     0.900    28.686     0.150
     0.916    16.287     0.150
     0.916    18.057     0.150
     0.916    27.527     0.150
     0.916    31.527     0.150
     0.920    16.586     0.150
     0.929    16.426     0.150
     0.978    18.037     0.150
     0.978    31.137     0.150
     0.979    17.867     0.150
     0.979    30.736     0.150
     1.000    18.605     0.150
     1.000    32.326     0.150
     1.006    19.207     0.150
     0.987    17.707     0.150
     0.996    18.447     0.150
     0.996    31.746     0.150
     0.996    18.307     0.150
     0.996    31.246     0.150
     1.002    18.227     0.150
     1.002    31.176     0.150
     1.024    18.217     0.150
     1.081    34.447     0.150
     1.104    21.256     0.150
     1.086    19.416     0.150
     1.116    20.666     0.150
     1.113    20.447     0.150
     1.111    19.766     0.150
     1.111    34.957     0.150
     1.110    19.717     0.150
     1.110    33.846     0.150
     1.113    35.496     0.150
     1.143    20.566     0.150
     1.143    35.707     0.150
     1.185    20.896     0.150
     1.185    35.947     0.150
     1.263    22.346     0.150
     1.263    22.096     0.150
     1.263    22.707     0.150
     1.263    39.127     0.150
     1.258    38.557     0.150
     1.284    22.746     0.150
     1.319    23.057     0.150
     1.322    23.117     0.150
     1.322    40.316     0.150
     1.322    40.477     0.150
     1.322    39.826     0.150
     1.388    24.816     0.150
     1.459    24.627     0.150
     1.442    25.396     0.150
     1.456    44.586     0.150
     1.576    26.355     0.150
     1.598    28.086     0.150
     1.598    48.576     0.150
     1.625    27.047     0.150
     1.671    29.777     0.150
     1.685    28.707     0.150
     1.693    28.926     0.150
     1.719    30.586     0.150
     1.745    29.537     0.150
     1.770    30.037     0.150
     1.770    52.027     0.150
     1.792    29.396     0.150
     1.810    31.236     0.150
     2.084    34.736     0.150
     2.107    34.277     0.150
     2.154    35.006     0.150
     2.194    35.367     0.150
     2.266    35.277     0.150
     2.397    37.797     0.150
     2.789    43.576     0.150
     3.303    51.166     0.150
     3.673    55.967     0.150
     4.003    61.936     0.150
     4.237    65.367     0.150
     4.312    66.855     0.150
     4.644    70.637     0.150
     4.910    74.496     0.150
     5.625    84.266     0.150
     0.320     6.521     0.150
     0.320    10.781     0.150
     0.320    11.662     0.150
     0.320    10.912     0.150
     0.322     6.352     0.150
     0.322    10.742     0.150
     0.322    10.992     0.150
     0.325     6.871     0.150
     0.325    11.521     0.150
     0.325    12.031     0.150
     0.693    13.281     0.150
     0.693    22.521     0.150
     0.713    13.381     0.150
     0.713    22.643     0.150
     0.771    14.682     0.150
     0.771    24.742     0.150
     0.777    14.682     0.150
     0.777    25.051     0.150
     0.882    16.072     0.150
     0.882    27.711     0.150
     1.056    19.762     0.150
     1.056    35.922     0.150
     1.189    21.643     0.150
     1.189    37.332     0.150
     1.354    24.893     0.150
     1.354    42.941     0.150
     1.430    26.682     0.150
     1.430    44.822     0.150
     1.509    25.771     0.150
     1.509    44.742     0.150
     1.519    27.822     0.150
     1.519    46.982     0.150
     1.698    52.301     0.150
     1.754    30.262     0.150
     1.754    54.832     0.150
     1.870    33.201     0.150
     1.975    32.162     0.150
     1.975    55.361     0.150
     2.084    36.262     0.150
     2.088    37.211     0.150
     2.289    36.592     0.150
     2.289    63.611     0.150
     2.286    38.422     0.150
     2.445    42.881     0.150
     2.494    41.432     0.150
     2.848    47.271     0.150
     2.867    47.361     0.150
     3.270    51.152     0.150
     3.439    55.762     0.150
     4.320    66.002     0.150
     5.031    77.732     0.150
     6.032    90.402     0.150
     6.269    93.281     0.150
     0.321     6.543     0.150
     0.321    11.094     0.150
     0.321    11.574     0.150
     0.321    12.184     0.150
     0.321    10.953     0.150
     0.315     6.344     0.150
     0.315    10.645     0.150
     0.316     6.332     0.150
     0.316    10.625     0.150
     0.316    10.973     0.150
     0.332     6.922     0.150
     0.332    11.582     0.150
     0.332    12.172     0.150
     0.719    13.441     0.150
     0.719    22.781     0.150
     0.696    13.234     0.150
     0.696    22.734     0.150
     0.885    16.164     0.150
     0.885    27.832     0.150
     0.815    16.324     0.150
     0.815    28.613     0.150
     0.777    14.562     0.150
     0.777    24.953     0.150
     0.776    14.672     0.150
     0.776    24.762     0.150
     0.883    18.102     0.150
     0.883    30.902     0.150
     0.923    17.555     0.150
     0.923    31.125     0.150
     0.977    19.703     0.150
     0.977    33.684     0.150
     1.056    19.805     0.150
     1.056    21.234     0.150
     1.056    33.492     0.150
     1.056    36.645     0.150
     1.195    21.754     0.150
     1.195    37.383     0.150
     1.435    26.941     0.150
     1.435    26.734     0.150
     1.435    44.781     0.150
     1.506    25.262     0.150
     1.524    27.332     0.150
     1.524    46.684     0.150
     1.596    29.973     0.150
     1.703    29.715     0.150
     1.753    29.031     0.150
     1.872    32.184     0.150
     1.970    31.992     0.150
     2.087    33.934     0.150
     2.092    35.152     0.150
     2.113    37.824     0.150
     2.283    36.324     0.150
     2.287    37.492     0.150
     2.343    38.895     0.150
     2.416    39.574     0.150
     2.449    40.172     0.150
     2.493    40.602     0.150
     4.038    61.012     0.150
     4.038   107.973     0.150
     6.456   165.402     0.150
     0.293     5.926     0.150
     0.293     9.965     0.150
     0.293     5.926     0.150
     0.293     9.934     0.150
     0.339     7.133     0.150
     0.339    11.785     0.150
     0.339    12.535     0.150
     0.339    11.984     0.150
     0.381     7.605     0.150
     0.381    12.793     0.150
     0.381    13.266     0.150
     0.381    12.664     0.150
     0.644    12.383     0.150
     0.644    20.785     0.150
     0.716    13.645     0.150
     0.716    23.246     0.150
     0.730    13.723     0.150
     0.730    23.504     0.150
     0.745    14.266     0.150
     0.745    24.125     0.150
     0.767    15.473     0.150
     0.767    27.016     0.150
     0.863    16.504     0.150
     0.863    28.836     0.150
     0.918    17.906     0.150
     0.918    30.645     0.150
     0.941    17.164     0.150
     0.941    29.293     0.150
     0.941    30.043     0.150
     0.941    30.184     0.150
     0.995    20.055     0.150
     0.995    34.543     0.150
     0.995    19.574     0.150
     0.995    34.926     0.150
     0.997    18.594     0.150
     1.123    20.934     0.150
     1.123    36.594     0.150
     1.184    21.656     0.150
     1.184    37.043     0.150
     1.184    37.184     0.150
     1.256    40.195     0.150
     1.368    43.113     0.150
     1.401    25.562     0.150
     1.401    44.453     0.150
     1.401    45.664     0.150
     1.401    26.035     0.150
     1.401    44.004     0.150
     1.425    26.473     0.150
     1.453    24.855     0.150
     1.453    27.504     0.150
     1.453    47.656     0.150
     1.479    46.273     0.150
     1.487    26.723     0.150
     1.487    46.184     0.150
     1.492    27.754     0.150
     1.532    47.586     0.150
     1.541    28.574     0.150
     1.541    49.715     0.150
     1.542    27.676     0.150
     1.542    48.105     0.150
     1.542    27.574     0.150
     1.542    47.715     0.150
     1.661    29.133     0.150
     1.661    51.004     0.150
     1.661    29.266     0.150
     1.661    51.156     0.150
     1.667    29.184     0.150
     1.667    50.715     0.150
     1.693    27.824     0.150
     1.713    53.375     0.150
     1.800    31.914     0.150
     1.800    55.996     0.150
     1.771    32.395     0.150
     1.816    33.074     0.150
     1.816    56.535     0.150
     1.850    34.465     0.150
     1.874    34.703     0.150
     1.923    31.855     0.150
     1.923    55.016     0.150
     1.945    35.855     0.150
     2.050    34.785     0.150
     2.067    38.004     0.150
     2.285    40.086     0.150
     2.363    39.535     0.150
     2.403    41.574     0.150
     2.622    41.934     0.150
     2.809    47.906     0.150
     3.646    65.195     0.150
     3.877    60.594     0.150
     3.902    68.184     0.150
     4.016    61.254     0.150
     4.016    61.473     0.150
     4.262    66.523     0.150
     4.466    68.125     0.150
     4.972    76.234     0.150
     5.244    79.895     0.150
     5.522    82.594     0.150
     5.617    85.984     0.150
     0.178     3.965     0.150
     0.178     7.094     0.150
     0.178     6.895     0.150
     0.178     7.324     0.150
     0.442     8.906     0.150
     0.442    15.086     0.150
     0.468     9.145     0.150
     0.468    15.434     0.150
     0.469     9.094     0.150
     0.469    15.375     0.150
     0.540    10.176     0.150
     0.540    17.645     0.150
     0.572    10.664     0.150
     0.572    18.523     0.150
     0.562    10.625     0.150
     0.562    18.305     0.150
     0.562    10.406     0.150
     0.562    18.195     0.150
     0.712    13.145     0.150
     0.712    22.773     0.150
     0.873    16.684     0.150
     0.873    29.477     0.150
     0.873    29.074     0.150
     0.875    16.805     0.150
     0.879    17.387     0.150
     0.879    30.215     0.150
     0.939    18.195     0.150
     0.939    32.695     0.150
     0.926    17.215     0.150
     0.926    29.637     0.150
     0.926    17.105     0.150
     0.926    30.164     0.150
     0.997    18.297     0.150
     0.997    32.176     0.150
     0.997    18.156     0.150
     0.997    31.504     0.150
     1.060    19.676     0.150
     1.060    35.086     0.150
     1.202    22.035     0.150
     1.202    37.504     0.150
     1.202    21.895     0.150
     1.202    37.367     0.150
     1.232    22.434     0.150
     1.232    38.805     0.150
     1.250    22.887     0.150
     1.323    23.754     0.150
     1.323    41.016     0.150
     1.508    27.184     0.150
     1.508    46.637     0.150
     1.530    26.086     0.150
     1.530    45.516     0.150
     1.704    30.004     0.150
     1.687    30.156     0.150
     1.725    30.465     0.150
     1.898    33.336     0.150
     2.021    33.523     0.150
     2.028    35.227     0.150
     2.160    36.055     0.150
     2.209    37.215     0.150
     2.252    38.105     0.150
     2.261    39.137     0.150
     2.424    39.117     0.150
     2.542    42.246     0.150
     2.661    43.617     0.150
     2.705    45.395     0.150
     2.854    47.016     0.150
     3.077    51.004     0.150
     3.185    48.934     0.150
     3.233    50.055     0.150
     3.256    52.625     0.150
     3.276    51.273     0.150
     3.404    56.734     0.150
     3.890    61.266     0.150
     3.949    63.227     0.150
     4.048    63.105     0.150
     4.180    64.434     0.150
     4.224    66.367     0.150
     4.315    66.824     0.150
     4.565    69.887     0.150
     5.008    77.465     0.150
     5.018    76.266     0.150
     5.260    80.555     0.150
     5.640    85.656     0.150
     5.654    85.457     0.150
     5.723    86.574     0.150
     5.858    88.594     0.150
     5.988    90.055     0.150
     6.144    92.234     0.150
     6.213    92.664     0.150
     0.184     3.930     0.150
     0.184     7.289     0.150
     0.184     6.918     0.150
     0.184     7.449     0.150
     0.469     9.156     0.150
     0.469    15.520     0.150
     0.470     9.148     0.150
     0.470    15.816     0.150
     0.470    15.449     0.150
     0.456     8.840     0.150
     0.456    14.887     0.150
     0.456     9.000     0.150
     0.456    15.469     0.150
     0.456    15.988     0.150
     0.526    10.199     0.150
     0.526    16.727     0.150
     0.526    16.918     0.150
     0.526    17.207     0.150
     0.562    10.699     0.150
     0.562    18.359     0.150
     0.562    18.988     0.150
     0.565    10.688     0.150
     0.565    18.449     0.150
     0.565    17.898     0.150
     0.699    13.219     0.150
     0.699    23.418     0.150
     0.867    29.977     0.150
     0.861    16.719     0.150
     0.861    28.906     0.150
     0.861    29.348     0.150
     0.868    16.977     0.150
     0.868    17.219     0.150
     0.868    29.977     0.150
     0.927    18.180     0.150
     0.927    32.227     0.150
     0.978    18.617     0.150
     0.978    33.559     0.150
     0.978    18.859     0.150
     0.978    32.637     0.150
     0.939    17.207     0.150
     0.939    29.117     0.150
     0.939    29.770     0.150
     1.044    19.527     0.150
     1.044    34.938     0.150
     1.046    19.367     0.150
     1.046    34.379     0.150
     0.993    18.129     0.150
     0.993    31.406     0.150
     0.993    30.957     0.150
     1.086    20.090     0.150
     1.086    35.227     0.150
     1.148    21.629     0.150
     1.148    39.387     0.150
     1.163    21.188     0.150
     1.163    38.008     0.150
     1.188    22.066     0.150
     1.188    37.859     0.150
     1.237    22.938     0.150
     1.237    38.406     0.150
     1.222    22.379     0.150
     1.222    38.738     0.150
     1.222    39.578     0.150
     1.222    40.566     0.150
     1.312    23.789     0.150
     1.312    40.906     0.150
     1.312    41.949     0.150
     1.312    40.680     0.150
     1.377    26.348     0.150
     1.376    24.789     0.150
     1.376    42.738     0.150
     1.520    26.297     0.150
     1.497    26.977     0.150
     1.497    46.418     0.150
     1.497    26.816     0.150
     1.497    46.539     0.150
     1.588    28.117     0.150
     1.588    48.590     0.150
     1.601    28.828     0.150
     1.691    29.008     0.150
     1.691    53.750     0.150
     1.711    29.906     0.150
     1.686    29.898     0.150
     1.686    51.629     0.150
     1.767    31.680     0.150
     1.836    32.527     0.150
     1.887    33.457     0.150
     2.013    33.328     0.150
     2.017    35.000     0.150
     2.147    35.930     0.150
     2.164    35.578     0.150
     2.195    36.898     0.150
     2.238    37.816     0.150
     2.238    38.273     0.150
     2.238    41.098     0.150
     2.238    69.273     0.150
     2.249    37.609     0.150
     2.422    39.797     0.150
     2.528    41.609     0.150
     2.649    44.438     0.150
     2.689    43.848     0.150
     2.692    44.059     0.150
     2.841    46.270     0.150
     3.064    54.859     0.150
     3.089    58.059     0.150
     3.244    51.699     0.150
     3.449    55.949     0.150
     3.697    58.906     0.150
     4.036    63.727     0.150
     4.074    63.957     0.150
     4.177   111.500     0.150
     4.177    63.648     0.150
     4.177    63.367     0.150
     4.303    67.598     0.150
     4.287    67.316     0.150
     4.314    67.129     0.150
     4.436    70.469     0.150
     4.556    69.699     0.150
     4.665    71.477     0.150
     4.716    71.270     0.150
     5.017    77.727     0.150
     5.403    81.648     0.150
     6.058    90.656     0.150
     6.719    99.547     0.150
     7.272   108.816     0.150
     7.272   134.828     0.150
     7.272   230.078     0.150
     7.515   111.629     0.150
     7.575   111.879     0.150
     8.400   123.922     0.150
     8.400   262.547     0.150
     8.400   122.750     0.150
     8.400   123.109     0.150
     8.411   123.848     0.150
     8.719   127.797     0.150
     9.126   132.719     0.150
     9.242   137.102     0.150
     9.242   291.555     0.150
    10.524   153.309     0.150
    10.525   153.852     0.150
    10.525   153.109     0.150
    12.038   171.598     0.150
    12.066   172.188     0.150
    12.241   179.227     0.150
    12.241   389.934     0.150
    12.241   175.578     0.150
    12.570   180.047     0.150
    14.705   209.398     0.150
    15.450   222.629     0.150
    16.264   230.668     0.150
    16.269   231.539     0.150
    16.796   235.879     0.150
    17.533   246.039     0.150
    19.329   265.199     0.150
    21.474   289.000     0.150
    22.504   300.668     0.150
    23.825   314.555     0.150
    24.468   318.328     0.150
    38.509   445.430     0.150
    38.509   443.750     0.150
    39.356   448.629     0.150
    39.390   450.000     0.150
    40.048   454.867     0.150
    40.545   460.270     0.150
    40.979   464.078     0.150
    56.740   586.930     0.150
    63.620   634.602     0.150
    79.678   730.965     0.150
    79.985   730.117     0.150
    79.985   732.430     0.150
    80.923   735.852     0.150
    82.313   743.840     0.150
    82.713   747.203     0.150
    84.987   758.078     0.150
    84.987   754.938     0.150
   118.798  1131.492     0.150
     8.398   123.898     0.150
     2.238    38.629     0.150
     0.181     4.020     0.150
     0.181     6.918     0.150
     0.452     8.969     0.150
     0.452    15.129     0.150
     0.452    15.008     0.150
     0.471     9.160     0.150
     0.471    15.367     0.150
     0.471    14.980     0.150
     0.530    10.109     0.150
     0.530    17.289     0.150
     0.563    10.688     0.150
     0.563    18.359     0.150
     0.564    10.609     0.150
     0.564    18.457     0.150
     0.870    17.520     0.150
     0.870    29.547     0.150
     0.935    16.957     0.150
     0.935    29.559     0.150
     0.935    30.129     0.150
     0.935    30.230     0.150
     0.935    17.180     0.150
     0.935    28.910     0.150
     0.982    19.848     0.150
     0.982    34.367     0.150
     0.993    18.340     0.150
     0.993    31.367     0.150
     1.191    22.098     0.150
     1.191    37.047     0.150
     1.224    22.438     0.150
     1.224    38.609     0.150
     1.224    22.641     0.150
     1.224    38.449     0.150
     1.314    23.980     0.150
     1.314    40.570     0.150
     1.499    27.188     0.150
     1.499    46.570     0.150
     1.524    26.027     0.150
     1.524    44.969     0.150
     1.695    29.988     0.150
     1.714    30.188     0.150
     1.889    33.770     0.150
     1.945    35.988     0.150
     1.945    61.348     0.150
     2.016    33.520     0.150
     2.151    36.117     0.150
     2.242    39.148     0.150
     2.252    38.480     0.150
     2.424    39.508     0.150
     2.652    44.527     0.150
     2.693    44.898     0.150
     2.695    44.078     0.150
     2.844    47.258     0.150
     3.451    56.297     0.150
     4.307    68.141     0.150
     4.560    70.609     0.150
     5.010    77.840     0.150
     5.251    80.738     0.150
     5.635    84.680     0.150
     5.646    86.770     0.150
     5.979    91.199     0.150
     0.183     3.914     0.150
     0.183     6.992     0.150
     0.183     7.492     0.150
     0.450     8.992     0.150
     0.450    15.633     0.150
     0.450    14.863     0.150
     0.467     8.973     0.150
     0.467    15.543     0.150
     0.468     8.926     0.150
     0.468    15.695     0.150
     0.468    15.414     0.150
     0.532    10.152     0.150
     0.532    17.203     0.150
     0.532    17.086     0.150
     0.565    10.695     0.150
     0.565    18.324     0.150
     0.565    10.555     0.150
     0.567    10.664     0.150
     0.567    18.465     0.150
     0.703    13.133     0.150
     0.703    22.836     0.150
     0.865    16.652     0.150
     0.865    29.035     0.150
     0.871    17.395     0.150
     0.871    30.016     0.150
     0.934    17.223     0.150
     0.934    29.883     0.150
     0.934    16.926     0.150
     0.934    30.293     0.150
     0.934    28.984     0.150
     0.996    18.152     0.150
     0.996    31.375     0.150
     0.983    19.344     0.150
     0.983    19.562     0.150
     0.983    33.902     0.150
     1.051    19.484     0.150
     1.168    22.145     0.150
     1.168    36.844     0.150
     1.194    21.883     0.150
     1.194    21.992     0.150
     1.194    37.285     0.150
     1.227    22.676     0.150
     1.227    38.383     0.150
     1.227    22.434     0.150
     1.227    38.492     0.150
     1.227    22.223     0.150
     1.227    38.164     0.150
     1.242    22.984     0.150
     1.242    38.414     0.150
     1.317    23.863     0.150
     1.317    40.715     0.150
     1.317    24.086     0.150
     1.317    40.594     0.150
     1.335    24.574     0.150
     1.335    41.594     0.150
     1.368    26.293     0.150
     1.372    25.074     0.150
     1.381    25.562     0.150
     1.380    25.242     0.150
     1.435    26.914     0.150
     1.501    27.086     0.150
     1.502    27.402     0.150
     1.502    45.684     0.150
     1.523    26.133     0.150
     1.523    48.453     0.150
     1.552    28.555     0.150
     1.563    28.273     0.150
     1.716    30.965     0.150
     1.892    33.664     0.150
     1.928    35.305     0.150
     2.022    35.543     0.150
     2.015    33.363     0.150
     2.151    36.254     0.150
     2.170    35.613     0.150
     2.201    36.992     0.150
     2.244    36.652     0.150
     2.254    39.844     0.150
     2.421    39.062     0.150
     2.533    41.875     0.150
     2.655    43.902     0.150
     2.698    44.176     0.150
     2.774    43.793     0.150
     5.009    77.312     0.150
     5.251    80.473     0.150
     5.979    90.625     0.150
     0.173     3.895     0.150
     0.447     8.766     0.150
     0.447    15.066     0.150
     0.447     9.055     0.150
     0.447    14.824     0.150
     0.476     9.055     0.150
     0.476    15.656     0.150
     0.476     9.215     0.150
     0.535    10.125     0.150
     0.535    17.215     0.150
     0.555    10.543     0.150
     0.555    18.125     0.150
     0.564    10.566     0.150
     0.564    18.395     0.150
     0.879    30.645     0.150
     0.927    16.695     0.150
     0.927    29.523     0.150
     0.927    17.145     0.150
     0.927    29.074     0.150
     0.940    31.977     0.150
     0.991    18.773     0.150
     0.991    34.074     0.150
     0.989    31.766     0.150
     0.989    18.105     0.150
     0.989    30.996     0.150
     1.057    20.125     0.150
     1.057    34.406     0.150
     1.197    21.934     0.150
     1.197    37.434     0.150
     1.225    22.406     0.150
     1.225    38.754     0.150
     1.225    22.613     0.150
     1.315    23.953     0.150
     1.315    40.465     0.150
     1.442    47.375     0.150
     1.533    26.715     0.150
     1.532    48.164     0.150
     1.501    27.094     0.150
     1.501    46.406     0.150
     1.553    28.613     0.150
     1.591    49.305     0.150
     1.704    29.703     0.150
     1.720    54.934     0.150
     1.720    30.035     0.150
     1.891    33.363     0.150
     2.025    34.836     0.150
     1.929    35.445     0.150
     2.020    35.613     0.150
     2.176    35.855     0.150
     2.205    38.215     0.150
     2.254    38.426     0.150
     2.431    40.234     0.150
     2.654    45.863     0.150
     2.700    44.293     0.150
     5.018    77.125     0.150
     5.260    80.043     0.150
     0.183     4.047     0.150
     0.183     6.785     0.150
     0.183     7.305     0.150
     0.453     9.008     0.150
     0.453    15.695     0.150
     0.453    14.906     0.150
     0.469     9.098     0.150
     0.469    15.297     0.150
     0.565    10.676     0.150
     0.565    18.227     0.150
     0.528    10.055     0.150
     0.528    17.105     0.150
     0.564    10.625     0.150
     0.564    18.496     0.150
     0.937    17.176     0.150
     0.937    29.945     0.150
     0.937    29.746     0.150
     0.980    18.965     0.150
     0.980    31.496     0.150
     0.994    18.098     0.150
     0.994    31.117     0.150
     1.190    21.887     0.150
     1.224    22.375     0.150
     1.224    38.816     0.150
     1.224    22.477     0.150
     1.224    38.195     0.150
     1.239    38.297     0.150
     1.314    23.906     0.150
     1.314    40.387     0.150
     1.331    41.477     0.150
     1.365    45.578     0.150
     1.369    42.617     0.150
     1.377    43.078     0.150
     1.521    25.797     0.150
     1.499    46.578     0.150
     1.633    30.027     0.150
     1.693    52.316     0.150
     1.713    31.855     0.150
     1.889    33.176     0.150
     2.014    33.336     0.150
     2.149    35.965     0.150
     2.167    35.566     0.150
     2.197    36.395     0.150
     2.251    39.348     0.150
     2.422    39.047     0.150
     2.651    42.297     0.150
     4.557    69.746     0.150
     4.999    77.457     0.150
     5.007    77.477     0.150
     5.249    80.496     0.150
     5.644    86.348     0.150
     5.719    85.336     0.150
     5.847    86.875     0.150
     0.191     4.188     0.150
     0.191     7.141     0.150
     0.471     9.230     0.150
     0.471    15.758     0.150
     0.473     9.199     0.150
     0.473    15.617     0.150
     0.510    10.168     0.150
     0.510    17.109     0.150
     0.550    18.109     0.150
     0.567    10.809     0.150
     0.567    18.379     0.150
     0.686    13.188     0.150
     0.686    22.141     0.150
     0.954    17.359     0.150
     0.954    29.680     0.150
     0.954    30.078     0.150
     0.964    18.578     0.150
     0.964    33.867     0.150
     0.986    18.527     0.150
     0.986    32.160     0.150
     1.172    21.918     0.150
     1.172    37.211     0.150
     1.172    21.750     0.150
     1.172    37.000     0.150
     1.210    22.738     0.150
     1.210    38.320     0.150
     1.210    22.848     0.150
     1.210    39.020     0.150
     1.221    22.930     0.150
     1.221    38.449     0.150
     1.299    24.008     0.150
     1.299    40.777     0.150
     1.299    40.891     0.150
     1.362    42.578     0.150
     1.483    27.238     0.150
     1.483    46.270     0.150
     1.575    28.719     0.150
     1.695    31.668     0.150
     1.695    53.770     0.150
     1.873    33.570     0.150
     2.234    40.078     0.150
     2.635    45.438     0.150
     2.677    46.000     0.150
     4.994    77.840     0.150
     0.183     4.152     0.150
     0.183     7.113     0.150
     0.458     9.242     0.150
     0.458    15.242     0.150
     0.458    15.113     0.150
     0.471     9.254     0.150
     0.471    15.742     0.150
     0.471    15.422     0.150
     0.524    16.945     0.150
     0.560    18.742     0.150
     0.563    18.035     0.150
     0.698    22.074     0.150
     0.698    22.734     0.150
     0.860    29.254     0.150
     0.940    16.914     0.150
     0.940    29.824     0.150
     0.991    18.402     0.150
     0.991    32.082     0.150
     1.186    21.992     0.150
     1.186    37.582     0.150
     1.186    22.203     0.150
     1.220    22.645     0.150
     1.220    38.512     0.150
     1.220    22.793     0.150
     1.220    39.055     0.150
     1.235    23.125     0.150
     1.310    40.844     0.150
     1.310    40.574     0.150
     1.494    46.773     0.150
     1.494    27.355     0.150
     1.494    46.664     0.150
     1.520    25.992     0.150
     1.520    44.734     0.150
     1.586    28.605     0.150
     1.586    48.723     0.150
     1.676    52.262     0.150
     1.690    28.832     0.150
     1.709    31.363     0.150
     1.885    33.832     0.150
     2.013    33.562     0.150
     2.146    36.324     0.150
     2.236    38.805     0.150
     2.247    39.762     0.150
     2.423    39.172     0.150
     2.647    45.773     0.150
     5.005    77.625     0.150
     5.246    80.645     0.150
     0.183     3.973     0.150
     0.183     7.164     0.150
     0.183     6.852     0.150
     0.183     7.352     0.150
     0.456     9.062     0.150
     0.456    15.023     0.150
     0.456    15.262     0.150
     0.456    15.844     0.150
     0.471     9.203     0.150
     0.471    15.543     0.150
     0.471     9.211     0.150
     0.471    15.504     0.150
     0.525    10.094     0.150
     0.525    17.164     0.150
     0.525    16.973     0.150
     0.561    10.594     0.150
     0.561    17.973     0.150
     0.561    18.621     0.150
     0.561    18.883     0.150
     0.563    10.621     0.150
     0.563    18.363     0.150
     0.563    17.711     0.150
     0.700    13.121     0.150
     0.700    22.223     0.150
     0.861    16.441     0.150
     0.861    29.152     0.150
     0.869    17.391     0.150
     0.869    29.812     0.150
     0.928    18.230     0.150
     0.928    31.602     0.150
     0.939    17.172     0.150
     0.939    28.883     0.150
     0.939    29.871     0.150
     0.939    30.262     0.150
     0.939    32.332     0.150
     0.962    33.262     0.150
     0.991    18.094     0.150
     0.991    31.293     0.150
     0.979    19.281     0.150
     0.979    32.414     0.150
     0.979    19.051     0.150
     0.979    32.262     0.150
     1.046    19.762     0.150
     1.046    34.383     0.150
     1.087    20.012     0.150
     1.087    34.852     0.150
     1.148    38.562     0.150
     1.162    21.293     0.150
     1.162    36.891     0.150
     1.187    21.812     0.150
     1.187    36.762     0.150
     1.221    22.320     0.150
     1.221    38.281     0.150
     1.221    38.551     0.150
     1.221    39.461     0.150
     1.236    22.863     0.150
     1.236    38.371     0.150
     1.232    23.352     0.150
     1.311    23.711     0.150
     1.311    40.883     0.150
     1.311    40.203     0.150
     1.495    26.633     0.150
     1.521    25.691     0.150
     1.677    29.371     0.150
     1.685    30.051     0.150
     1.692    28.320     0.150
     1.710    29.070     0.150
     1.885    32.543     0.150
     2.015    34.883     0.150
     2.014    32.922     0.150
     2.147    35.512     0.150
     2.164    35.383     0.150
     2.195    35.793     0.150
     2.238    36.551     0.150
     2.248    38.242     0.150
     2.432    39.141     0.150
     2.424    39.070     0.150
     2.527    40.961     0.150
     2.643    46.953     0.150
     2.648    43.383     0.150
     2.691    43.543     0.150
     2.689    43.312     0.150
     2.840    46.184     0.150
     3.090    57.562     0.150
     3.090    99.422     0.150
     3.219    50.504     0.150
     3.262    52.273     0.150
     3.447    55.004     0.150
     3.694    56.441     0.150
     3.696    58.414     0.150
     3.877    61.031     0.150
     4.034    63.273     0.150
     4.179    63.844     0.150
     4.179    64.371     0.150
     4.210    64.352     0.150
     4.286    67.230     0.150
     4.304    67.230     0.150
     4.343    66.902     0.150
     4.435    68.641     0.150
     4.557    69.621     0.150
     4.664    72.164     0.150
     4.804    72.883     0.150
     4.999    76.684     0.150
     5.007    77.363     0.150
     5.017    77.512     0.150
     5.206    80.570     0.150
     5.248    80.422     0.150
     5.359    82.043     0.150
     5.404    81.992     0.150
     5.427    83.184     0.150
     5.634    84.594     0.150
     5.720    85.434     0.150
     5.845    88.332     0.150
     5.975    89.562     0.150
     6.057    89.902     0.150
     6.101    91.691     0.150
     6.131    93.301     0.150
     6.136    92.504     0.150
     6.201    94.684     0.150
     6.324    95.594     0.150
     6.436    97.594     0.150
     6.721    99.172     0.150
     7.116   105.102     0.150
     7.174   106.320     0.150
     7.271   134.941     0.150
     7.271   229.594     0.150
     7.576   112.203     0.150
     8.188   120.902     0.150
     8.721   127.902     0.150
     9.127   134.793     0.150
    10.527   154.418     0.150
    10.527   334.742     0.150
    80.922   736.191     0.150
     0.183     4.039     0.150
     0.183     7.219     0.150
     0.450     9.062     0.150
     0.450    15.000     0.150
     0.466     9.020     0.150
     0.466    15.641     0.150
     0.467     9.051     0.150
     0.467    16.039     0.150
     0.467    16.141     0.150
     0.532    10.031     0.150
     0.532    17.672     0.150
     0.532    17.242     0.150
     0.566    10.641     0.150
     0.566    18.371     0.150
     0.566    18.242     0.150
     0.568    10.699     0.150
     0.568    18.270     0.150
     0.703    12.980     0.150
     0.703    23.621     0.150
     0.703    22.039     0.150
     0.865    16.750     0.150
     0.865    29.121     0.150
     0.871    29.570     0.150
     0.868    16.430     0.150
     0.868    28.930     0.150
     0.934    17.219     0.150
     0.934    29.641     0.150
     0.934    29.141     0.150
     0.931    18.652     0.150
     0.931    32.301     0.150
     0.965    18.660     0.150
     0.996    18.211     0.150
     0.996    31.430     0.150
     0.996    30.941     0.150
     0.983    20.312     0.150
     0.983    33.750     0.150
     0.983    34.211     0.150
     1.052    19.609     0.150
     1.052    33.750     0.150
     1.153    38.750     0.150
     1.168    21.789     0.150
     1.168    37.410     0.150
     1.194    21.742     0.150
     1.194    37.051     0.150
     1.228    22.492     0.150
     1.228    38.742     0.150
     1.228    38.340     0.150
     1.228    38.062     0.150
     1.243    22.789     0.150
     1.243    38.422     0.150
     1.318    23.949     0.150
     1.318    40.340     0.150
     1.382    25.062     0.150
     1.382    42.762     0.150
     1.503    26.750     0.150
     1.503    45.410     0.150
     1.503    26.910     0.150
     1.503    45.840     0.150
     1.522    25.500     0.150
     1.522    44.031     0.150
     1.594    28.391     0.150
     1.594    48.469     0.150
     1.683    30.191     0.150
     1.683    30.012     0.150
     1.683    50.859     0.150
     1.692    30.191     0.150
     1.692    51.449     0.150
     1.695    28.031     0.150
     1.717    29.699     0.150
     1.893    32.711     0.150
     2.023    35.301     0.150
     2.014    33.012     0.150
     2.151    35.980     0.150
     2.170    35.949     0.150
     2.201    36.492     0.150
     2.244    36.641     0.150
     2.244    37.461     0.150
     2.244    41.258     0.150
     2.244    69.285     0.150
     2.255    37.910     0.150
     2.421    38.969     0.150
     2.436    39.570     0.150
     2.534    40.922     0.150
     2.655    43.539     0.150
     2.698    44.000     0.150
     2.695    42.852     0.150
     2.847    45.871     0.150
     3.250    51.430     0.150
     3.287    53.281     0.150
     3.418    56.719     0.150
     3.455    53.320     0.150
     3.675    55.641     0.150
     3.703    57.871     0.150
     3.881    60.371     0.150
     4.042    63.852     0.150
     4.176    62.602     0.150
     4.217    65.262     0.150
     4.293    65.949     0.150
     4.320    65.199     0.150
     4.350    66.930     0.150
     4.442    68.902     0.150
     4.558    69.449     0.150
     4.671    70.531     0.150
     4.811    73.449     0.150
     5.009    77.301     0.150
     5.251    80.391     0.150
     5.400    81.531     0.150
     5.433    84.352     0.150
     5.633    85.102     0.150
     5.646    86.062     0.150
     5.718    86.270     0.150
     5.849    88.219     0.150
     5.964    91.449     0.150
     5.979    90.441     0.150
     6.101    91.770     0.150
     6.135    91.941     0.150
     6.328    94.961     0.150
     6.718   100.289     0.150
     7.120   105.500     0.150
     7.278   134.965     0.150
     7.278   229.066     0.150
    10.521   153.516     0.150
    12.246   178.191     0.150
    38.515   445.629     0.150
     0.181     3.939     0.150
     0.181     6.668     0.150
     0.181     7.498     0.150
     0.181     7.918     0.150
     0.445     8.838     0.150
     0.445    15.180     0.150
     0.445     8.969     0.150
     0.467     9.199     0.150
     0.467    15.758     0.150
     0.571    10.629     0.150
     0.571    18.129     0.150
     0.571    19.059     0.150
     0.565    10.588     0.150
     0.565    18.139     0.150
     0.708    13.148     0.150
     0.929    16.949     0.150
     0.929    29.639     0.150
     0.929    17.180     0.150
     0.929    30.898     0.150
     0.987    19.439     0.150
     0.987    34.539     0.150
     0.987    18.578     0.150
     0.987    32.328     0.150
     0.998    18.100     0.150
     0.998    33.898     0.150
     0.998    35.479     0.150
     1.174    21.279     0.150
     1.174    36.998     0.150
     1.199    21.998     0.150
     1.199    36.930     0.150
     1.232    22.549     0.150
     1.232    38.998     0.150
     1.232    22.430     0.150
     1.232    38.748     0.150
     1.232    39.838     0.150
     1.248    22.908     0.150
     1.248    39.020     0.150
     1.271    24.738     0.150
     1.271    42.799     0.150
     1.284    24.648     0.150
     1.284    42.779     0.150
     1.300    25.059     0.150
     1.322    23.828     0.150
     1.322    40.758     0.150
     1.322    42.049     0.150
     1.322    42.180     0.150
     1.330    24.119     0.150
     1.340    41.738     0.150
     1.361    23.828     0.150
     1.361    45.020     0.150
     1.374    26.088     0.150
     1.374    45.449     0.150
     1.378    42.770     0.150
     1.385    24.979     0.150
     1.385    43.039     0.150
     1.386    24.959     0.150
     1.386    42.879     0.150
     1.386    43.629     0.150
     1.387    24.869     0.150
     1.387    46.020     0.150
     1.420    27.168     0.150
     1.420    46.789     0.150
     1.440    45.648     0.150
     1.474    46.789     0.150
     1.497    48.520     0.150
     1.506    26.859     0.150
     1.506    46.520     0.150
     1.507    27.119     0.150
     1.507    46.318     0.150
     1.507    26.879     0.150
     1.526    25.898     0.150
     1.526    44.988     0.150
     1.557    48.398     0.150
     1.568    27.850     0.150
     1.568    48.158     0.150
     1.581    26.838     0.150
     1.597    28.770     0.150
     1.597    48.689     0.150
     1.610    28.658     0.150
     1.610    49.549     0.150
     1.642    28.930     0.150
     1.642    50.658     0.150
     1.639    28.299     0.150
     1.639    54.008     0.150
     1.696    30.119     0.150
     1.700    28.668     0.150
     1.700    53.889     0.150
     1.722    29.719     0.150
     1.722    55.039     0.150
     1.742    29.748     0.150
     1.763    30.789     0.150
     1.763    53.988     0.150
     1.897    33.119     0.150
     2.027    35.078     0.150
     2.017    33.199     0.150
     2.156    35.779     0.150
     2.175    35.719     0.150
     2.206    36.520     0.150
     2.249    36.918     0.150
     2.249    36.588     0.150
     2.249    41.213     0.150
     2.249    68.787     0.150
     2.259    37.779     0.150
     2.259    65.488     0.150
     2.441    39.148     0.150
     2.422    38.738     0.150
     2.539    41.029     0.150
     2.655    44.258     0.150
     2.700    43.459     0.150
     3.079    58.258     0.150
     3.079    91.229     0.150
     3.184    57.119     0.150
     3.459    55.709     0.150
     3.459    54.988     0.150
     3.886    60.770     0.150
     4.177    63.328     0.150
     4.177   111.359     0.150
     4.561    69.799     0.150
     4.675    72.309     0.150
     4.709    71.318     0.150
     4.709   126.129     0.150
     4.816    73.639     0.150
     5.073   135.680     0.150
     5.073    77.129     0.150
     5.308    79.729     0.150
     5.308   142.439     0.150
     5.441    80.869     0.150
     5.441   143.859     0.150
     5.718    85.389     0.150
     6.068    90.559     0.150
     6.409    95.100     0.150
     6.640    99.189     0.150
     6.640   168.350     0.150
     7.125   106.699     0.150
     7.283   108.168     0.150
     7.283   133.744     0.150
     7.833   114.559     0.150
     7.833   199.699     0.150
     8.403   123.213     0.150
     8.403   121.029     0.150
     8.717   127.779     0.150
     9.253   135.469     0.150
    10.133   143.180     0.150
    10.520   153.668     0.150
    11.765   167.350     0.150
    12.250   178.270     0.150
    12.569   181.168     0.150
    16.280   229.109     0.150
    16.807   234.859     0.150
    16.822   234.389     0.150
    17.066   238.689     0.150
    21.023   285.158     0.150
    23.232   307.498     0.150
    23.833   315.094     0.150
    24.475   318.168     0.150
    31.036   378.068     0.150
    37.162   431.129     0.150
    37.199   430.809     0.150
    38.520   445.219     0.150
    39.911   456.459     0.150
    40.556   460.318     0.150
    40.672   462.488     0.150
    40.990   464.520     0.150
    63.630   633.223     0.150
    79.687   729.881     0.150
    80.934   735.918     0.150
    82.322   743.549     0.150
    84.993   758.895     0.150
    92.516   793.930     0.150
   118.798  1129.818     0.150
    35.733   418.719     0.150
     0.184     4.076     0.150
     0.184     7.086     0.150
     0.184     7.457     0.150
     0.447     8.938     0.150
     0.447    15.027     0.150
     0.465     9.076     0.150
     0.465    15.057     0.150
     0.567    10.717     0.150
     0.567    18.258     0.150
     0.534    10.127     0.150
     0.534    17.377     0.150
     0.571    10.736     0.150
     0.571    18.377     0.150
     0.933    17.127     0.150
     0.933    29.377     0.150
     0.933    29.508     0.150
     0.984    19.086     0.150
     0.984    33.457     0.150
     0.999    18.277     0.150
     0.999    31.807     0.150
     1.054    20.336     0.150
     1.196    21.707     0.150
     1.196    37.656     0.150
     1.231    22.688     0.150
     1.231    38.076     0.150
     1.231    38.877     0.150
     1.245    22.967     0.150
     1.338    24.666     0.150
     1.375    25.508     0.150
     1.438    27.037     0.150
     1.506    27.117     0.150
     1.506    46.207     0.150
     1.556    28.508     0.150
     1.640    30.178     0.150
     1.696    29.416     0.150
     1.719    30.057     0.150
     1.896    33.438     0.150
     2.172    37.086     0.150
     2.247    36.887     0.150
     2.258    38.316     0.150
     2.658    43.496     0.150
     5.010    77.246     0.150
     0.195     4.281     0.150
     0.195     7.660     0.150
     0.467     9.422     0.150
     0.467    15.473     0.150
     0.467    15.742     0.150
     0.465     9.203     0.150
     0.465    15.250     0.150
     0.514     9.492     0.150
     0.514    16.121     0.150
     0.557    10.422     0.150
     0.557    18.102     0.150
     0.685    12.801     0.150
     0.685    21.820     0.150
     0.953    17.602     0.150
     0.953    29.723     0.150
     0.953    29.320     0.150
     0.947    19.172     0.150
     0.947    31.500     0.150
     0.964    18.723     0.150
     0.964    19.543     0.150
     0.964    33.543     0.150
     0.964    33.691     0.150
     1.033    18.902     0.150
     1.033    32.691     0.150
     1.176    21.391     0.150
     1.176    36.492     0.150
     1.176    21.230     0.150
     1.176    35.980     0.150
     1.217    22.172     0.150
     1.217    38.461     0.150
     1.226    22.562     0.150
     1.226    37.730     0.150
     1.306    40.711     0.150
     1.450    25.801     0.150
     1.450    45.422     0.150
     1.507    25.480     0.150
     1.489    26.430     0.150
     1.569    28.332     0.150
     1.677    27.762     0.150
     1.699    29.711     0.150
     1.879    32.441     0.150
     1.913    33.492     0.150
     1.913    59.082     0.150
     2.000    32.570     0.150
     2.133    34.820     0.150
     2.151    34.992     0.150
     2.182    35.801     0.150
     2.227    37.133     0.150
     2.415    38.613     0.150
     2.418    39.680     0.150
     2.515    40.801     0.150
     2.641    42.371     0.150
     2.676    43.160     0.150
     2.681    42.840     0.150
     3.688    58.660     0.150
     3.923    61.953     0.150
     4.169    64.152     0.150
     4.201    66.051     0.150
     4.992    77.203     0.150
     5.414    83.262     0.150
     5.628    85.832     0.150
     5.961    90.211     0.150
     0.174     3.910     0.150
     0.174     6.453     0.150
     0.174     6.922     0.150
     0.452     9.043     0.150
     0.452    15.090     0.150
     0.452    16.203     0.150
     0.452    14.512     0.150
     0.477     9.473     0.150
     0.477    15.672     0.150
     0.531    10.301     0.150
     0.531    17.430     0.150
     0.556    10.531     0.150
     0.556    17.840     0.150
     0.556    18.500     0.150
     0.561    10.672     0.150
     0.561    18.133     0.150
     0.931    17.051     0.150
     0.931    29.312     0.150
     0.931    29.051     0.150
     0.987    18.750     0.150
     0.987    19.320     0.150
     0.987    33.852     0.150
     0.987    35.582     0.150
     0.987    18.121     0.150
     0.987    30.961     0.150
     1.192    21.820     0.150
     1.221    22.500     0.150
     1.221    38.910     0.150
     1.221    38.320     0.150
     1.311    24.051     0.150
     1.311    40.480     0.150
     1.530    26.023     0.150
     1.497    26.762     0.150
     1.700    28.691     0.150
     1.887    32.832     0.150
     2.022    33.480     0.150
     2.155    35.590     0.150
     2.171    35.230     0.150
     2.250    37.301     0.150
     2.431    39.273     0.150
     2.533    40.793     0.150
     2.695    42.691     0.150
     3.073    48.293     0.150
     3.886    60.352     0.150
     4.566    69.191     0.150
     5.008    76.453     0.150
     5.015    77.051     0.150
     5.256    79.840     0.150
     5.651    86.051     0.150
     0.070     2.246     0.150
     0.070     3.395     0.150
     0.070     3.625     0.150
     0.487     9.504     0.150
     0.487    16.434     0.150
     0.487    15.645     0.150
     0.504     9.883     0.150
     0.504    16.812     0.150
     0.628    12.184     0.150
     0.628    20.484     0.150
     0.701    13.594     0.150
     0.701    22.543     0.150
     0.814    15.223     0.150
     0.814    25.965     0.150
     0.812    15.996     0.150
     0.812    26.703     0.150
     0.891    17.156     0.150
     1.142    20.883     0.150
     1.142    36.695     0.150
     1.142    21.062     0.150
     1.142    35.805     0.150
     1.160    21.473     0.150
     1.160    36.273     0.150
     1.160    39.695     0.150
     1.252    23.035     0.150
     1.252    38.613     0.150
     1.245    22.695     0.150
     1.245    38.824     0.150
     1.455    26.164     0.150
     1.455    44.645     0.150
     1.748    29.484     0.150
     1.778    32.426     0.150
     1.778    56.414     0.150
     1.843    56.043     0.150
     1.874    31.773     0.150
     1.874    58.645     0.150
     1.928    33.266     0.150
     1.928    59.664     0.150
     2.222    38.266     0.150
     2.222    67.156     0.150
     2.248    36.863     0.150
     2.248    62.516     0.150
     2.269    37.855     0.150
     2.269    70.176     0.150
     2.278    38.562     0.150
     2.283    37.875     0.150
     2.308    38.926     0.150
     2.603    42.844     0.150
     2.610    43.176     0.150
     2.608    42.305     0.150
     2.664    41.535     0.150
     2.720    44.914     0.150
     3.290    53.883     0.150
     3.745    58.836     0.150
     3.977    63.383     0.150
     4.051    63.926     0.150
     4.089    62.363     0.150
     4.437    68.273     0.150
     5.206    79.754     0.150
     5.422    83.395     0.150
     0.135     3.391     0.150
     0.135     5.359     0.150
     0.135     5.809     0.150
     0.437     8.699     0.150
     0.437    14.570     0.150
     0.437    14.699     0.150
     0.508    10.090     0.150
     0.508    16.949     0.150
     0.508    17.559     0.150
     0.520     9.879     0.150
     0.552    10.781     0.150
     0.552    18.070     0.150
     0.552    18.258     0.150
     0.552    18.801     0.150
     0.556    10.539     0.150
     0.556    17.949     0.150
     0.900    16.391     0.150
     0.900    28.109     0.150
     0.900    29.590     0.150
     0.965    17.621     0.150
     0.965    30.531     0.150
     1.021    19.918     0.150
     1.021    33.418     0.150
     1.021    34.738     0.150
     1.210    22.090     0.150
     1.216    21.969     0.150
     1.216    22.270     0.150
     1.216    38.090     0.150
     1.309    23.559     0.150
     1.309    40.340     0.150
     1.569    26.211     0.150
     1.569    45.379     0.150
     1.499    26.852     0.150
     1.499    45.480     0.150
     1.735    29.230     0.150
     1.735    31.258     0.150
     1.890    32.988     0.150
     1.921    33.781     0.150
     2.062    33.609     0.150
     2.187    36.090     0.150
     2.198    35.578     0.150
     2.223    37.199     0.150
     2.256    38.469     0.150
     2.256    38.781     0.150
     2.466    39.031     0.150
     2.475    39.668     0.150
     2.554    42.141     0.150
     2.653    43.980     0.150
     2.726    43.711     0.150
     2.710    43.711     0.150
     3.245    50.680     0.150
     3.251    50.668     0.150
     3.283    51.930     0.150
     3.450    54.910     0.150
     3.706    58.949     0.150
     3.920    60.051     0.150
     3.956    59.918     0.150
     4.042    63.602     0.150
     4.221    63.328     0.150
     4.223    65.219     0.150
     4.350    65.629     0.150
     4.304    66.758     0.150
     4.358    66.289     0.150
     4.474    69.219     0.150
     4.605    70.301     0.150
     4.814    73.070     0.150
     5.081    77.289     0.150
     5.052    77.871     0.150
     5.051    77.828     0.150
     5.229    79.871     0.150
     5.290    80.969     0.150
     5.501    84.488     0.150
     5.681    85.109     0.150
     5.688    86.309     0.150
     5.766    86.461     0.150
     6.018    91.219     0.150
     6.149    92.461     0.150
     0.180     3.928     0.150
     0.180     6.928     0.150
     0.458    15.689     0.150
     0.458     9.068     0.150
     0.458    15.529     0.150
     0.475     9.258     0.150
     0.475    15.518     0.150
     0.475     9.289     0.150
     0.475    15.598     0.150
     0.475    15.299     0.150
     0.524     9.998     0.150
     0.524    17.318     0.150
     0.524    17.029     0.150
     0.560    10.488     0.150
     0.560    18.428     0.150
     0.560    18.168     0.150
     0.557    10.479     0.150
     0.557    17.908     0.150
     0.700    13.039     0.150
     0.700    23.779     0.150
     0.700    22.068     0.150
     0.862    16.609     0.150
     0.862    28.988     0.150
     0.871    17.309     0.150
     0.871    17.658     0.150
     0.872    17.639     0.150
     0.872    29.908     0.150
     0.939    17.178     0.150
     0.939    29.738     0.150
     0.939    29.338     0.150
     0.929    18.199     0.150
     0.929    32.129     0.150
     0.961    18.789     0.150
     0.987    18.189     0.150
     0.987    31.189     0.150
     0.979    18.658     0.150
     0.979    19.359     0.150
     0.979    32.879     0.150
     0.979    33.418     0.150
     1.045    19.969     0.150
     1.045    33.828     0.150
     1.161    21.439     0.150
     1.186    21.678     0.150
     1.186    36.869     0.150
     1.218    22.309     0.150
     1.218    22.199     0.150
     1.218    37.779     0.150
     1.218    37.648     0.150
     1.234    22.699     0.150
     1.234    38.168     0.150
     1.308    23.588     0.150
     1.308    40.018     0.150
     1.326    24.498     0.150
     1.371    25.168     0.150
     1.371    25.078     0.150
     1.371    24.719     0.150
     1.371    42.139     0.150
     1.427    26.748     0.150
     1.427    26.398     0.150
     1.427    44.109     0.150
     1.492    26.729     0.150
     1.492    26.809     0.150
     1.492    26.529     0.150
     1.492    45.918     0.150
     1.523    26.318     0.150
     1.583    27.949     0.150
     1.583    48.189     0.150
     1.673    30.299     0.150
     1.673    51.709     0.150
     1.692    29.689     0.150
     1.709    31.088     0.150
     1.883    32.738     0.150
     1.902    32.598     0.150
     2.016    33.338     0.150
     2.147    35.459     0.150
     2.164    36.348     0.150
     2.236    37.949     0.150
     2.245    38.398     0.150
     2.427    39.418     0.150
     2.433    39.939     0.150
     2.526    41.969     0.150
     2.645    44.689     0.150
     2.689    44.059     0.150
     2.838    46.498     0.150
     3.065    49.588     0.150
     3.093    53.658     0.150
     3.218    52.209     0.150
     4.182    64.289     0.150
     4.560    69.678     0.150
     5.001    76.969     0.150
     5.008    76.828     0.150
     5.248    79.578     0.150
     5.351    81.729     0.150
     5.644    86.018     0.150
     5.723    86.559     0.150
     5.846    87.879     0.150
     5.976    90.039     0.150
     6.131    92.279     0.150
     0.186     3.990     0.150
     0.186     7.380     0.150
     0.186     6.900     0.150
     0.186     7.930     0.150
     0.466     9.240     0.150
     0.466    15.730     0.150
     0.466    15.840     0.150
     0.473     9.380     0.150
     0.473    15.590     0.150
     0.474     9.350     0.150
     0.474    15.620     0.150
     0.516    10.010     0.150
     0.516    17.010     0.150
     0.516    17.220     0.150
     0.563    10.560     0.150
     0.563    18.420     0.150
     0.563    18.170     0.150
     0.553    10.460     0.150
     0.553    17.860     0.150
     0.692    13.060     0.150
     0.866    17.690     0.150
     0.866    30.110     0.150
     0.863    17.370     0.150
     0.863    28.800     0.150
     0.854    16.580     0.150
     0.854    29.460     0.150
     0.947    17.300     0.150
     0.947    29.380     0.150
     0.947    30.380     0.150
     0.921    18.210     0.150
     0.921    32.300     0.150
     0.954    18.330     0.150
     0.954    33.620     0.150
     0.971    18.990     0.150
     0.971    33.290     0.150
     0.971    18.270     0.150
     0.971    33.410     0.150
     0.986    18.110     0.150
     0.986    30.840     0.150
     0.986    35.180     0.150
     1.178    21.720     0.150
     1.178    37.310     0.150
     1.213    22.290     0.150
     1.213    37.850     0.150
     1.213    38.090     0.150
     1.213    39.300     0.150
     1.303    23.580     0.150
     1.303    40.320     0.150
     1.303    40.070     0.150
     1.366    24.560     0.150
     1.366    42.380     0.150
     1.516    25.860     0.150
     1.516    44.640     0.150
     1.487    26.700     0.150
     1.487    45.870     0.150
     1.487    26.570     0.150
     1.486    26.680     0.150
     1.578    28.180     0.150
     1.578    28.070     0.150
     1.578    48.500     0.150
     1.684    28.320     0.150
     1.676    29.650     0.150
     1.676    51.320     0.150
     1.701    28.740     0.150
     1.833    30.000     0.150
     1.877    33.230     0.150
     1.877    56.930     0.150
     1.894    31.740     0.150
     1.894    57.520     0.150
     2.010    33.200     0.150
     2.139    35.690     0.150
     2.155    35.460     0.150
     2.228    36.150     0.150
     2.228    39.669     0.150
     2.228    69.269     0.150
     2.239    37.220     0.150
     2.424    38.690     0.150
     2.518    41.080     0.150
     2.639    43.300     0.150
     2.681    42.790     0.150
     2.682    43.400     0.150
     3.099    98.240     0.150
     3.659    55.670     0.150
     3.781    66.060     0.150
     3.870    60.530     0.150
     3.925    70.040     0.150
     4.025    62.730     0.150
     4.064    64.580     0.150
     4.179    63.130     0.150
     4.179    61.580     0.150
     4.201    63.790     0.150
     4.298    65.250     0.150
     4.277    76.560     0.150
     4.334    75.340     0.150
     4.426    78.800     0.150
     4.456    70.010     0.150
     4.553    69.320     0.150
     4.794    72.210     0.150
     4.993    75.840     0.150
     5.000    76.840     0.150
     5.008    76.100     0.150
     5.197    79.870     0.150
     5.240    79.420     0.150
     5.344    81.490     0.150
     5.407    81.680     0.150
     5.341    80.960     0.150
     5.464    83.530     0.150
     5.633    84.380     0.150
     5.631    84.400     0.150
     5.636    85.480     0.150
     5.718    85.910     0.150
     5.675    86.310     0.150
     5.837    87.950     0.150
     5.968    89.010     0.150
     6.097    90.270     0.150
     6.048    90.580     0.150
     6.129    92.170     0.150
     6.122    91.400     0.150
     6.193    92.820     0.150
     6.315    94.560     0.150
     6.389    96.090     0.150
     6.428    95.940     0.150
     6.722    99.920     0.150
     6.946   102.270     0.150
     7.158   104.060     0.150
     7.165   105.350     0.150
     7.146   106.090     0.150
     7.209   107.810     0.150
     7.261   109.755     0.150
     7.261   134.250     0.150
     7.261   231.180     0.150
     7.556   110.220     0.150
     9.233   137.050     0.150
    10.530   153.675     0.150
    10.530   334.450     0.150
    12.234   180.009     0.150
    14.041   201.040     0.150
    38.499   446.865     0.150
    13.896   194.620     0.150
     0.187     4.047     0.150
     0.187     7.037     0.150
     0.187     6.357     0.150
     0.187     7.268     0.150
     0.187     7.728     0.150
     0.466     9.297     0.150
     0.466    15.587     0.150
     0.472     9.357     0.150
     0.472    15.547     0.150
     0.473     9.347     0.150
     0.473    15.787     0.150
     0.473    15.507     0.150
     0.515     9.867     0.150
     0.515    16.597     0.150
     0.553    10.407     0.150
     0.553    17.677     0.150
     0.564    10.607     0.150
     0.564    18.277     0.150
     0.691    12.958     0.150
     0.691    22.407     0.150
     0.853    16.438     0.150
     0.853    29.317     0.150
     0.853    28.067     0.150
     0.862    17.557     0.150
     0.948    17.347     0.150
     0.948    29.967     0.150
     0.948    29.857     0.150
     0.948    30.417     0.150
     0.970    18.857     0.150
     0.970    31.867     0.150
     0.987    18.007     0.150
     0.987    31.717     0.150
     0.987    18.228     0.150
     1.036    19.347     0.150
     1.036    33.217     0.150
     1.036    19.037     0.150
     1.036    33.317     0.150
     1.036    19.367     0.150
     1.036    35.987     0.150
     1.152    20.827     0.150
     1.152    36.427     0.150
     1.177    21.567     0.150
     1.177    36.407     0.150
     1.177    21.417     0.150
     1.177    36.607     0.150
     1.213    22.427     0.150
     1.213    22.317     0.150
     1.213    37.537     0.150
     1.213    39.067     0.150
     1.213    39.627     0.150
     1.213    38.167     0.150
     1.226    22.627     0.150
     1.303    23.397     0.150
     1.303    40.248     0.150
     1.487    26.717     0.150
     1.486    26.877     0.150
     1.515    25.657     0.150
     1.677    30.157     0.150
     1.683    28.188     0.150
     1.894    31.947     0.150
     2.009    33.057     0.150
     2.138    35.667     0.150
     2.155    35.327     0.150
     2.228    36.228     0.150
     2.239    37.487     0.150
     2.423    39.097     0.150
     2.517    41.387     0.150
     2.681    43.407     0.150
     3.402    50.967     0.150
     3.682    55.867     0.150
     4.552    69.717     0.150
     5.635    85.998     0.150
     5.717    85.867     0.150
     0.186     4.119     0.150
     0.186     7.039     0.150
     0.474     9.330     0.150
     0.474    15.580     0.150
     0.478     9.488     0.150
     0.478    15.529     0.150
     0.479     9.479     0.150
     0.479    15.969     0.150
     0.479    15.039     0.150
     0.508    10.039     0.150
     0.508    16.869     0.150
     0.545    10.529     0.150
     0.545    17.549     0.150
     0.561    10.680     0.150
     0.561    18.180     0.150
     0.687    13.170     0.150
     0.687    22.789     0.150
     0.687    22.529     0.150
     0.850    29.219     0.150
     0.850    16.699     0.150
     0.850    29.059     0.150
     0.860    17.420     0.150
     0.860    29.830     0.150
     0.866    17.539     0.150
     0.866    30.270     0.150
     0.866    16.709     0.150
     0.866    28.719     0.150
     0.916    17.670     0.150
     0.953    17.389     0.150
     0.953    29.789     0.150
     0.953    29.318     0.150
     0.947    18.469     0.150
     0.980    18.170     0.150
     0.980    31.148     0.150
     0.966    18.420     0.150
     0.966    19.209     0.150
     0.966    30.879     0.150
     0.966    31.609     0.150
     1.029    19.229     0.150
     1.145    36.979     0.150
     1.170    21.750     0.150
     1.170    21.590     0.150
     1.170    37.270     0.150
     1.205    22.469     0.150
     1.205    38.840     0.150
     1.205    37.238     0.150
     1.218    22.709     0.150
     1.218    38.270     0.150
     1.294    23.699     0.150
     1.294    40.379     0.150
     1.478    26.789     0.150
     1.478    27.279     0.150
     1.478    45.738     0.150
     1.478    26.840     0.150
     1.478    45.559     0.150
     1.514    25.898     0.150
     1.668    29.889     0.150
     1.668    51.119     0.150
     1.679    28.459     0.150
     1.692    29.568     0.150
     1.868    33.180     0.150
     1.886    32.189     0.150
     1.998    35.299     0.150
     2.008    33.279     0.150
     2.133    36.000     0.150
     2.177    37.318     0.150
     2.220    36.670     0.150
     2.230    38.199     0.150
     2.230    68.199     0.150
     2.427    39.719     0.150
     2.427    68.629     0.150
     2.631    43.350     0.150
     2.673    43.459     0.150
     3.108    92.469     0.150
     4.294    66.129     0.150
     4.552    69.629     0.150
     5.058    78.119     0.150
     5.235    80.539     0.150
     5.341    81.709     0.150
     5.631    84.760     0.150
     5.832    87.170     0.150
     5.963    90.779     0.150
     0.178     4.016     0.150
     0.178     6.977     0.150
     0.461     9.211     0.150
     0.461    15.602     0.150
     0.479     9.391     0.150
     0.479    15.828     0.150
     0.479     9.406     0.150
     0.479    15.562     0.150
     0.479    15.180     0.150
     0.521     9.938     0.150
     0.521    16.656     0.150
     0.553    10.438     0.150
     0.553    17.391     0.150
     0.556    10.547     0.150
     0.556    17.930     0.150
     0.700    13.008     0.150
     0.700    23.211     0.150
     0.700    22.008     0.150
     0.862    16.562     0.150
     0.862    28.992     0.150
     0.862    16.461     0.150
     0.871    17.336     0.150
     0.871    30.109     0.150
     0.874    17.516     0.150
     0.874    30.109     0.150
     0.874    16.680     0.150
     0.874    30.172     0.150
     0.929    18.328     0.150
     0.929    32.086     0.150
     0.940    17.258     0.150
     0.940    29.289     0.150
     0.940    17.156     0.150
     0.960    18.297     0.150
     0.983    17.828     0.150
     0.983    31.008     0.150
     0.979    19.422     0.150
     0.979    33.102     0.150
     0.979    17.945     0.150
     0.979    32.078     0.150
     1.043    19.047     0.150
     1.043    33.188     0.150
     1.183    21.539     0.150
     1.183    36.781     0.150
     1.183    21.406     0.150
     1.213    22.195     0.150
     1.213    37.461     0.150
     1.213    38.070     0.150
     1.230    22.641     0.150
     1.230    37.906     0.150
     1.303    23.609     0.150
     1.303    40.000     0.150
     1.303    39.688     0.150
     1.488    26.570     0.150
     1.488    45.500     0.150
     1.488    45.352     0.150
     1.524    25.906     0.150
     1.592    29.367     0.150
     1.669    29.672     0.150
     1.692    28.219     0.150
     1.706    29.656     0.150
     1.878    32.516     0.150
     1.898    31.867     0.150
     2.008    35.227     0.150
     2.018    33.188     0.150
     2.146    35.508     0.150
     2.162    35.422     0.150
     2.191    36.461     0.150
     2.232    36.312     0.150
     2.241    38.070     0.150
     2.433    39.297     0.150
     2.431    39.102     0.150
     2.523    40.117     0.150
     2.641    43.359     0.150
     2.688    42.742     0.150
     2.834    45.789     0.150
     3.065    48.641     0.150
     3.097    92.516     0.150
     3.097    58.695     0.150
     3.144    49.711     0.150
     3.440    53.961     0.150
     3.665    58.328     0.150
     3.877    60.078     0.150
     4.028    62.141     0.150
     4.065    62.648     0.150
     4.204    64.758     0.150
     4.186    64.586     0.150
     4.306    67.641     0.150
     4.561    69.742     0.150
     4.797    73.180     0.150
     5.001    76.266     0.150
     5.008    76.656     0.150
     5.015    76.570     0.150
     5.352    81.000     0.150
     5.412    81.539     0.150
     5.470    83.633     0.150
     5.644    85.633     0.150
     5.638    84.781     0.150
     5.680    85.719     0.150
     5.726    86.242     0.150
     5.845    87.961     0.150
     5.953    89.656     0.150
     5.976    90.227     0.150
     6.049    90.328     0.150
     6.130    91.742     0.150
     6.200    92.891     0.150
     6.435    96.289     0.150
     6.728   100.000     0.150
     0.180     4.020     0.150
     0.180     6.848     0.150
     0.180     6.520     0.150
     0.474     9.379     0.150
     0.474    15.320     0.150
     0.474    15.141     0.150
     0.485     9.547     0.150
     0.485    16.039     0.150
     0.486     9.547     0.150
     0.486    15.738     0.150
     0.486    15.367     0.150
     0.509     9.949     0.150
     0.509    16.758     0.150
     0.541    10.410     0.150
     0.541    17.480     0.150
     0.554    10.539     0.150
     0.554    17.789     0.150
     0.554    18.160     0.150
     0.691    13.109     0.150
     0.691    22.609     0.150
     0.691    12.898     0.150
     0.691    21.867     0.150
     0.854    16.688     0.150
     0.854    29.488     0.150
     0.872    17.559     0.150
     0.872    30.289     0.150
     0.921    32.109     0.150
     0.950    17.367     0.150
     0.974    18.098     0.150
     0.974    30.809     0.150
     0.970    19.270     0.150
     0.970    33.039     0.150
     0.970    17.820     0.150
     0.970    31.688     0.150
     1.146    21.938     0.150
     1.146    37.297     0.150
     1.170    21.680     0.150
     1.201    22.250     0.150
     1.201    37.809     0.150
     1.291    23.410     0.150
     1.291    39.719     0.150
     1.474    26.750     0.150
     1.475    26.617     0.150
     1.520    25.758     0.150
     1.683    28.348     0.150
     1.693    30.207     0.150
     1.865    32.660     0.150
     1.885    33.730     0.150
     2.015    33.660     0.150
     2.137    35.410     0.150
     2.150    36.359     0.150
     2.178    37.238     0.150
     2.219    37.820     0.150
     2.228    38.777     0.150
     2.298    42.289     0.150
     2.511    41.039     0.150
     2.673    43.379     0.150
     2.677    43.641     0.150
     3.676    58.000     0.150
     4.191    65.668     0.150
     4.446    68.848     0.150
     5.001    77.230     0.150
     0.181     4.002     0.150
     0.181     6.881     0.150
     0.454     8.861     0.150
     0.454    15.211     0.150
     0.454    14.771     0.150
     0.470     9.191     0.150
     0.470    15.572     0.150
     0.471     9.082     0.150
     0.471    15.562     0.150
     0.471    15.732     0.150
     0.528    10.432     0.150
     0.528    17.553     0.150
     0.562    10.691     0.150
     0.562    18.643     0.150
     0.562    18.303     0.150
     0.563    10.893     0.150
     0.563    18.531     0.150
     0.702    13.291     0.150
     0.864    16.732     0.150
     0.864    29.791     0.150
     0.870    17.582     0.150
     0.870    30.332     0.150
     0.870    17.682     0.150
     0.870    30.031     0.150
     0.871    17.982     0.150
     0.871    30.762     0.150
     0.936    16.982     0.150
     0.936    29.553     0.150
     0.936    28.512     0.150
     0.930    18.152     0.150
     0.930    32.723     0.150
     0.934    25.182     0.150
     0.981    19.361     0.150
     0.981    33.232     0.150
     0.981    34.662     0.150
     0.992    18.332     0.150
     0.992    31.662     0.150
     0.992    31.861     0.150
     1.049    19.643     0.150
     1.049    34.002     0.150
     1.190    22.041     0.150
     1.223    22.701     0.150
     1.223    38.982     0.150
     1.313    24.102     0.150
     1.313    40.961     0.150
     1.497    27.131     0.150
     1.498    27.172     0.150
     1.498    46.553     0.150
     1.498    26.672     0.150
     1.523    26.303     0.150
     1.687    30.361     0.150
     1.694    28.531     0.150
     1.713    30.131     0.150
     1.888    33.232     0.150
     1.888    58.092     0.150
     1.907    32.492     0.150
     2.015    33.312     0.150
     2.240    37.012     0.150
     2.250    38.252     0.150
     2.424    39.143     0.150
     2.651    43.982     0.150
     5.009    77.242     0.150
     5.250    80.371     0.150
     0.177     3.963     0.150
     0.177     6.924     0.150
     0.177     3.662     0.150
     0.177     6.613     0.150
     0.177     7.162     0.150
     0.450     9.033     0.150
     0.450    15.562     0.150
     0.450    15.393     0.150
     0.473     9.344     0.150
     0.473    15.504     0.150
     0.474     9.354     0.150
     0.474    15.492     0.150
     0.474    16.162     0.150
     0.474    15.354     0.150
     0.559    17.873     0.150
     0.559    10.533     0.150
     0.559    18.162     0.150
     0.559    18.303     0.150
     0.532    10.283     0.150
     0.532    17.174     0.150
     0.563    10.562     0.150
     0.563    18.104     0.150
     0.707    13.174     0.150
     0.707    22.943     0.150
     0.869    16.703     0.150
     0.869    29.523     0.150
     0.875    30.594     0.150
     0.876    16.822     0.150
     0.876    29.803     0.150
     0.932    17.143     0.150
     0.932    29.203     0.150
     0.932    17.023     0.150
     0.932    29.402     0.150
     0.935    18.623     0.150
     0.935    32.113     0.150
     0.990    18.193     0.150
     0.990    31.303     0.150
     0.990    17.783     0.150
     0.990    30.803     0.150
     0.986    19.023     0.150
     0.986    33.463     0.150
     1.169    21.273     0.150
     1.169    36.562     0.150
     1.193    22.123     0.150
     1.193    37.482     0.150
     1.224    22.652     0.150
     1.224    38.273     0.150
     1.224    22.373     0.150
     1.224    38.594     0.150
     1.241    22.844     0.150
     1.241    38.283     0.150
     1.314    23.504     0.150
     1.314    40.492     0.150
     1.314    23.783     0.150
     1.333    24.482     0.150
     1.333    41.604     0.150
     1.498    27.113     0.150
     1.499    26.703     0.150
     1.499    46.014     0.150
     1.528    25.912     0.150
     1.550    28.174     0.150
     1.716    30.822     0.150
     1.889    32.082     0.150
     1.909    32.684     0.150
     2.154    35.893     0.150
     2.171    36.004     0.150
     2.201    37.773     0.150
     2.243    38.023     0.150
     2.252    38.533     0.150
     2.440    41.713     0.150
     2.534    41.854     0.150
     2.652    44.623     0.150
     2.697    44.693     0.150
     3.086    58.713     0.150
     3.086    97.283     0.150
     3.153    52.133     0.150
     5.356    81.443     0.150
     5.691    87.033     0.150
     5.853    88.463     0.150
     5.983    90.473     0.150
     8.747   128.553     0.150
     0.181     4.059     0.150
     0.181     6.855     0.150
     0.181     7.566     0.150
     0.460     9.246     0.150
     0.460    15.445     0.150
     0.460    14.957     0.150
     0.474     9.398     0.150
     0.474    15.617     0.150
     0.475     9.398     0.150
     0.475    15.629     0.150
     0.522     9.996     0.150
     0.522    16.836     0.150
     0.556    10.496     0.150
     0.556    17.855     0.150
     0.560    10.598     0.150
     0.560    18.168     0.150
     0.698    13.098     0.150
     0.698    22.008     0.150
     0.861    16.629     0.150
     0.861    28.719     0.150
     0.869    17.367     0.150
     0.869    30.406     0.150
     0.870    17.469     0.150
     0.927    17.707     0.150
     0.927    32.129     0.150
     0.941    17.285     0.150
     0.941    29.605     0.150
     0.941    29.746     0.150
     0.987    17.887     0.150
     0.987    30.809     0.150
     0.987    31.219     0.150
     0.977    18.836     0.150
     0.977    19.355     0.150
     0.977    33.336     0.150
     0.977    33.527     0.150
     1.043    19.137     0.150
     1.043    33.809     0.150
     1.184    36.828     0.150
     1.184    21.547     0.150
     1.216    22.418     0.150
     1.216    37.906     0.150
     1.216    38.309     0.150
     1.306    23.676     0.150
     1.306    40.227     0.150
     1.306    40.098     0.150
     1.490    26.738     0.150
     1.491    26.586     0.150
     1.491    46.098     0.150
     1.522    26.008     0.150
     1.522    44.656     0.150
     1.552    27.836     0.150
     1.690    28.227     0.150
     1.707    30.688     0.150
     1.881    33.047     0.150
     1.900    34.406     0.150
     2.011    35.309     0.150
     2.145    35.309     0.150
     2.162    34.957     0.150
     2.234    36.496     0.150
     2.243    39.035     0.150
     2.524    41.266     0.150
     2.644    44.887     0.150
     3.139    55.547     0.150
     5.089    77.406     0.150
     5.350    80.918     0.150
     0.182     4.031     0.150
     0.182     7.172     0.150
     0.182     7.453     0.150
     0.465     9.270     0.150
     0.465    15.672     0.150
     0.465    15.910     0.150
     0.477     9.312     0.150
     0.477    15.723     0.150
     0.477     9.281     0.150
     0.477    15.500     0.150
     0.517     9.770     0.150
     0.517    16.551     0.150
     0.517    16.109     0.150
     0.560    10.543     0.150
     0.560    18.043     0.150
     0.560    18.391     0.150
     0.552    10.402     0.150
     0.552    17.672     0.150
     0.695    12.852     0.150
     0.695    23.160     0.150
     0.869    17.410     0.150
     0.867    17.301     0.150
     0.867    30.090     0.150
     0.857    16.711     0.150
     0.945    17.312     0.150
     0.945    29.910     0.150
     0.945    29.793     0.150
     0.924    32.203     0.150
     0.974    18.641     0.150
     0.974    31.270     0.150
     0.983    17.973     0.150
     0.983    30.992     0.150
     1.179    21.590     0.150
     1.179    36.680     0.150
     1.212    22.320     0.150
     1.212    37.953     0.150
     1.302    23.531     0.150
     1.302    40.262     0.150
     1.520    25.883     0.150
     1.486    26.633     0.150
     1.486    45.332     0.150
     1.687    29.312     0.150
     1.687    51.562     0.150
     1.702    29.590     0.150
     1.702    53.531     0.150
     1.876    32.551     0.150
     1.876    55.422     0.150
     1.895    32.902     0.150
     1.895    55.832     0.150
     2.013    33.410     0.150
     2.229    36.570     0.150
     2.238    37.582     0.150
     2.428    39.250     0.150
     2.639    44.062     0.150
     2.682    43.891     0.150
     5.003    76.711     0.150
     0.182     4.062     0.150
     0.182     6.594     0.150
     0.182     6.492     0.150
     0.182     7.484     0.150
     0.465     9.312     0.150
     0.465    15.574     0.150
     0.465    15.945     0.150
     0.477     9.332     0.150
     0.477    15.773     0.150
     0.477     9.332     0.150
     0.477    15.543     0.150
     0.517     9.785     0.150
     0.517    16.555     0.150
     0.517     9.672     0.150
     0.551    10.172     0.150
     0.551    17.652     0.150
     0.560    10.582     0.150
     0.560    18.215     0.150
     0.560    17.973     0.150
     0.695    12.945     0.150
     0.695    22.344     0.150
     0.857    16.445     0.150
     0.857    28.574     0.150
     0.866    17.203     0.150
     0.866    30.113     0.150
     0.869    17.305     0.150
     0.869    30.125     0.150
     0.924    18.133     0.150
     0.924    31.645     0.150
     0.945    17.383     0.150
     0.945    29.785     0.150
     0.945    17.145     0.150
     0.945    29.973     0.150
     0.945    30.863     0.150
     0.945    16.785     0.150
     0.945    28.742     0.150
     0.983    17.945     0.150
     0.983    30.715     0.150
     0.974    18.355     0.150
     0.974    18.723     0.150
     0.974    32.184     0.150
     0.974    32.523     0.150
     1.040    35.934     0.150
     1.154    21.203     0.150
     1.154    36.484     0.150
     1.179    21.492     0.150
     1.179    36.512     0.150
     1.212    22.562     0.150
     1.212    22.293     0.150
     1.212    38.082     0.150
     1.227    22.523     0.150
     1.227    38.133     0.150
     1.301    23.512     0.150
     1.301    39.414     0.150
     1.319    24.152     0.150
     1.357    24.965     0.150
     1.354    25.914     0.150
     1.365    25.023     0.150
     1.364    24.883     0.150
     1.370    26.203     0.150
     1.420    26.445     0.150
     1.485    26.672     0.150
     1.486    26.434     0.150
     1.486    45.074     0.150
     1.480    44.535     0.150
     1.536    28.062     0.150
     1.520    25.645     0.150
     1.547    27.855     0.150
     1.621    29.633     0.150
     1.650    29.824     0.150
     1.687    29.172     0.150
     1.702    29.934     0.150
     1.742    31.105     0.150
     1.788    32.465     0.150
     1.876    32.645     0.150
     1.895    32.574     0.150
     1.912    34.785     0.150
     2.013    33.062     0.150
     2.141    35.574     0.150
     2.428    39.332     0.150
     3.233    51.004     0.150
     3.438    54.055     0.150
     3.438    54.512     0.150
     3.687    58.383     0.150
     4.277    65.895     0.150
     4.557    69.363     0.150
     4.997    76.613     0.150
     5.003    77.004     0.150
     5.243    79.715     0.150
     5.347    81.145     0.150
     5.639    85.605     0.150
     5.840    88.125     0.150
     5.971    89.723     0.150
     0.105     4.727     0.150
     0.422     8.094     0.150
     0.422    13.234     0.150
     0.422    14.805     0.150
     0.487     9.742     0.150
     0.487    16.367     0.150
     0.487    16.758     0.150
     0.556    10.719     0.150
     0.556    18.375     0.150
     0.556    19.359     0.150
     0.583    10.812     0.150
     0.583    18.617     0.150
     0.636    11.773     0.150
     0.636    20.242     0.150
     0.636    20.344     0.150
     0.636    21.078     0.150
     0.636    21.188     0.150
     0.728    13.578     0.150
     0.728    23.078     0.150
     0.732    13.422     0.150
     0.732    22.633     0.150
     0.732    13.266     0.150
     0.732    22.906     0.150
     0.740    13.609     0.150
     0.740    23.008     0.150
     0.758    13.719     0.150
     0.758    23.469     0.150
     0.758    13.938     0.150
     0.758    23.742     0.150
     0.801    15.047     0.150
     0.801    24.969     0.150
     0.825    15.516     0.150
     0.835    15.914     0.150
     0.840    15.117     0.150
     0.840    25.805     0.150
     0.856    15.297     0.150
     0.856    26.219     0.150
     0.869    16.273     0.150
     0.869    27.406     0.150
     0.911    16.297     0.150
     0.911    27.844     0.150
     0.924    16.703     0.150
     0.940    29.047     0.150
     0.973    17.734     0.150
     0.973    30.398     0.150
     0.979    18.297     0.150
     1.005    19.086     0.150
     1.005    33.773     0.150
     1.019    18.562     0.150
     1.019    32.734     0.150
     1.028    18.234     0.150
     1.028    31.328     0.150
     1.032    18.859     0.150
     1.032    32.312     0.150
     1.046    18.578     0.150
     1.061    19.289     0.150
     1.072    19.836     0.150
     1.074    19.672     0.150
     1.074    34.172     0.150
     1.074    33.633     0.150
     1.073    19.562     0.150
     1.073    35.164     0.150
     1.073    19.547     0.150
     1.073    34.008     0.150
     1.073    34.172     0.150
     1.134    21.695     0.150
     1.169    37.375     0.150
     1.172    36.359     0.150
     1.203    21.977     0.150
     1.203    37.727     0.150
     1.229    22.812     0.150
     1.244    21.797     0.150
     1.244    37.734     0.150
     1.245    37.992     0.150
     1.260    22.586     0.150
     1.260    39.094     0.150
     1.266    23.422     0.150
     1.266    40.312     0.150
     1.273    39.094     0.150
     1.328    23.859     0.150
     1.328    40.695     0.150
     1.354    24.484     0.150
     1.354    41.383     0.150
     1.361    41.109     0.150
     1.371    42.047     0.150
     1.371    23.805     0.150
     1.371    41.727     0.150
     1.371    23.992     0.150
     1.393    24.586     0.150
     1.393    42.375     0.150
     1.438    26.336     0.150
     1.438    44.922     0.150
     1.467    25.398     0.150
     1.467    43.594     0.150
     1.506    45.727     0.150
     1.533    27.227     0.150
     1.533    46.586     0.150
     1.605    28.734     0.150
     1.605    49.594     0.150
     1.612    27.133     0.150
     1.612    46.914     0.150
     1.623    27.898     0.150
     1.623    49.039     0.150
     1.647    28.328     0.150
     1.647    51.906     0.150
     1.658    29.836     0.150
     1.658    50.977     0.150
     1.662    30.406     0.150
     1.691    28.242     0.150
     1.691    48.609     0.150
     1.698    29.242     0.150
     1.698    50.953     0.150
     1.700    30.617     0.150
     1.704    30.883     0.150
     1.706    51.992     0.150
     1.726    53.719     0.150
     1.733    31.383     0.150
     1.737    52.578     0.150
     1.770    29.812     0.150
     1.770    51.922     0.150
     1.801    54.438     0.150
     1.836    30.867     0.150
     1.836    54.953     0.150
     1.853    32.898     0.150
     1.863    56.242     0.150
     1.895    53.383     0.150
     1.905    34.242     0.150
     1.963    57.719     0.150
     1.971    55.414     0.150
     2.009    34.492     0.150
     2.009    58.258     0.150
     2.078    34.773     0.150
     2.078    60.047     0.150
     2.143    36.438     0.150
     2.221    36.406     0.150
     2.301    37.172     0.150
     2.616    41.734     0.150
     2.752    43.688     0.150
     2.791    44.727     0.150
     2.796    44.492     0.150
     2.876    44.766     0.150
     2.932    45.945     0.150
     3.077    48.172     0.150
     3.211    50.648     0.150
     3.403    53.508     0.150
     3.608    54.336     0.150
     3.650    54.625     0.150
     3.722    57.023     0.150
     3.757    58.844     0.150
     3.966    61.594     0.150
     4.036    61.836     0.150
     4.185    63.914     0.150
     4.192    63.055     0.150
     4.547    68.219     0.150
     4.650    70.898     0.150
     4.938    75.164     0.150
     5.013    76.719     0.150
     5.068    76.727     0.150
     5.435    80.422     0.150
     5.536    84.406     0.150
     5.550    84.773     0.150
     5.850    88.695     0.150
     5.980    91.156     0.150
     0.192     4.191     0.150
     0.192     6.539     0.150
     0.192     7.320     0.150
     0.475     9.441     0.150
     0.475    15.730     0.150
     0.474     9.520     0.150
     0.474    15.691     0.150
     0.474    16.000     0.150
     0.506    10.070     0.150
     0.506    16.859     0.150
     0.547    10.582     0.150
     0.547    17.770     0.150
     0.566    10.723     0.150
     0.566    18.371     0.150
     0.683    13.172     0.150
     0.957    17.473     0.150
     0.957    29.723     0.150
     0.957    29.871     0.150
     0.984    18.250     0.150
     0.984    31.359     0.150
     0.961    19.129     0.150
     0.961    33.391     0.150
     1.168    21.512     0.150
     1.168    36.762     0.150
     1.207    22.371     0.150
     1.207    38.312     0.150
     1.207    22.492     0.150
     1.207    37.902     0.150
     1.296    23.691     0.150
     1.296    40.609     0.150
     1.479    26.660     0.150
     1.479    45.789     0.150
     1.479    26.801     0.150
     1.479    45.949     0.150
     1.509    25.770     0.150
     1.509    43.770     0.150
     1.675    28.152     0.150
     1.691    30.801     0.150
     1.869    33.332     0.150
     1.885    33.871     0.150
     2.003    32.852     0.150
     2.129    35.391     0.150
     2.145    36.020     0.150
     2.219    37.590     0.150
     2.231    37.762     0.150
     2.415    40.152     0.150
     2.422    38.961     0.150
     2.508    41.812     0.150
     2.631    43.781     0.150
     2.673    43.691     0.150
     3.226    52.672     0.150
     3.679    58.930     0.150
     4.991    77.051     0.150
     5.231    80.223     0.150
     5.627    85.832     0.150
     5.958    90.480     0.150
     0.175     4.016     0.150
     0.175     6.875     0.150
     0.175     7.094     0.150
     0.456     9.184     0.150
     0.456    15.504     0.150
     0.456    15.305     0.150
     0.478     9.375     0.150
     0.478    15.773     0.150
     0.478     9.383     0.150
     0.478    15.613     0.150
     0.478    15.945     0.150
     0.478    16.203     0.150
     0.526     9.996     0.150
     0.526    16.855     0.150
     0.526     9.855     0.150
     0.526    17.043     0.150
     0.555    10.516     0.150
     0.555    17.984     0.150
     0.555    17.855     0.150
     0.704    13.086     0.150
     0.704    23.305     0.150
     0.867    29.074     0.150
     0.876    30.164     0.150
     0.933    30.336     0.150
     0.935    17.203     0.150
     0.935    29.664     0.150
     0.935    30.926     0.150
     0.935    29.516     0.150
     0.984    18.066     0.150
     0.984    31.016     0.150
     0.984    17.906     0.150
     0.984    31.125     0.150
     1.164    21.996     0.150
     1.188    21.605     0.150
     1.188    37.145     0.150
     1.188    21.715     0.150
     1.188    36.863     0.150
     1.217    22.383     0.150
     1.217    22.223     0.150
     1.217    38.016     0.150
     1.217    37.684     0.150
     1.235    22.695     0.150
     1.308    23.473     0.150
     1.308    39.934     0.150
     1.366    25.113     0.150
     1.429    26.645     0.150
     1.492    26.715     0.150
     1.493    26.535     0.150
     1.493    46.176     0.150
     1.493    45.465     0.150
     1.528    25.676     0.150
     1.528    44.805     0.150
     1.554    27.805     0.150
     1.696    28.164     0.150
     1.696    49.555     0.150
     1.711    30.023     0.150
     1.711    54.715     0.150
     1.883    32.434     0.150
     1.883    57.176     0.150
     1.903    33.566     0.150
     1.903    59.184     0.150
     2.021    32.953     0.150
     2.021    56.594     0.150
     2.167    36.895     0.150
     2.237    38.586     0.150
     2.246    39.086     0.150
     2.437    41.535     0.150
     2.529    42.965     0.150
     2.691    45.074     0.150
     2.693    44.355     0.150
     3.069    49.094     0.150
     3.445    56.016     0.150
     3.670    56.633     0.150
     3.694    59.934     0.150
     3.790    58.805     0.150
     3.934    61.676     0.150
     4.033    62.805     0.150
     4.186    63.355     0.150
     4.209    66.234     0.150
     4.286    67.805     0.150
     4.564    69.633     0.150
     4.763    73.543     0.150
     5.012    77.074     0.150
     5.252    80.363     0.150
     5.648    85.824     0.150
     0.183     4.086     0.150
     0.183     6.477     0.150
     0.183     7.539     0.150
     0.471     9.320     0.150
     0.471    15.883     0.150
     0.480     9.414     0.150
     0.480    15.719     0.150
     0.481     9.445     0.150
     0.481    15.664     0.150
     0.481    16.078     0.150
     0.511     9.875     0.150
     0.511    17.297     0.150
     0.511    16.945     0.150
     0.546    10.406     0.150
     0.546    17.734     0.150
     0.546    18.266     0.150
     0.558    10.578     0.150
     0.558    17.945     0.150
     0.558    18.117     0.150
     0.691    13.023     0.150
     0.691    23.344     0.150
     0.691    21.930     0.150
     0.864    17.367     0.150
     0.864    30.148     0.150
     0.869    17.609     0.150
     0.869    30.453     0.150
     0.921    18.375     0.150
     0.921    31.703     0.150
     0.949    17.359     0.150
     0.949    29.734     0.150
     0.949    30.297     0.150
     0.949    31.023     0.150
     0.979    17.875     0.150
     0.979    30.969     0.150
     0.979    33.234     0.150
     1.081    36.414     0.150
     1.136    22.344     0.150
     1.173    21.477     0.150
     1.206    22.180     0.150
     1.261    24.539     0.150
     1.296    23.469     0.150
     1.296    40.359     0.150
     1.359    24.414     0.150
     1.359    42.258     0.150
     1.480    26.586     0.150
     1.518    25.688     0.150
     1.571    28.117     0.150
     1.670    29.836     0.150
     1.683    28.336     0.150
     1.696    30.984     0.150
     1.870    33.016     0.150
     1.889    32.117     0.150
     2.000    34.836     0.150
     2.012    33.156     0.150
     2.137    35.828     0.150
     2.152    35.430     0.150
     2.181    37.203     0.150
     2.223    36.234     0.150
     2.223    66.641     0.150
     2.232    38.406     0.150
     2.424    38.453     0.150
     2.430    39.180     0.150
     2.514    40.984     0.150
     2.628    47.383     0.150
     2.678    43.445     0.150
     3.681    58.469     0.150
     4.057    64.758     0.150
     7.256   227.578     0.150
     8.404   121.266     0.150
     8.404   261.102     0.150
    10.537   154.914     0.150
    16.782   239.094     0.150
    38.493   446.219     0.150
    69.582  5239.992     0.150
    69.600  5240.141     0.150
    80.907   736.836     0.150
     0.464     9.180     0.150
     0.464    15.281     0.150
     0.565    10.811     0.150
     0.565    17.561     0.150
     0.471     9.121     0.150
     0.471    15.521     0.150
     0.472     9.111     0.150
     0.472    15.531     0.150
     0.518    10.041     0.150
     0.518    17.100     0.150
     0.863    17.480     0.150
     0.863    29.510     0.150
     0.865    17.650     0.150
     0.865    30.000     0.150
     0.865    17.641     0.150
     0.865    30.010     0.150
     0.921    18.461     0.150
     0.921    32.211     0.150
     0.954    18.230     0.150
     0.972    19.590     0.150
     0.972    33.771     0.150
     1.038    19.621     0.150
     1.081    35.361     0.150
     1.155    21.781     0.150
     1.155    37.121     0.150
     1.180    21.830     0.150
     1.180    37.930     0.150
     1.228    22.820     0.150
     1.228    38.611     0.150
     1.305    23.891     0.150
     1.305    40.500     0.150
     1.297    24.570     0.150
     1.321    24.611     0.150
     1.368    24.680     0.150
     1.368    42.961     0.150
     1.367    25.211     0.150
     1.358    25.340     0.150
     1.355    25.881     0.150
     1.421    26.670     0.150
     1.489    26.990     0.150
     1.489    26.941     0.150
     1.489    45.461     0.150
     1.455    26.871     0.150
     1.551    28.291     0.150
     1.539    28.240     0.150
     1.571    27.791     0.150
     1.516    25.771     0.150
     1.516    44.061     0.150
     1.623    29.980     0.150
     1.653    29.881     0.150
     1.677    31.121     0.150
     1.703    30.311     0.150
     1.685    30.291     0.150
     1.879    32.611     0.150
     1.897    32.430     0.150
     2.009    33.230     0.150
     2.140    35.861     0.150
     2.157    37.100     0.150
     2.187    37.371     0.150
     2.241    37.600     0.150
     2.230    37.391     0.150
     2.425    41.420     0.150
     2.520    41.990     0.150
     2.684    44.400     0.150
     2.682    44.900     0.150
     3.058    49.600     0.150
     3.236    52.051     0.150
     3.305    52.191     0.150
     3.689    57.701     0.150
     3.927    61.170     0.150
     5.000    76.801     0.150
     0.340    11.922     0.150
     0.267     5.539     0.150
     0.267     9.238     0.150
     0.267     9.539     0.150
     0.468     9.172     0.150
     0.468    15.250     0.150
     0.468    15.148     0.150
     0.468    15.719     0.150
     0.651    12.629     0.150
     0.651    20.980     0.150
     0.707    13.262     0.150
     0.707    22.391     0.150
     0.707    22.500     0.150
     0.707    24.141     0.150
     0.803    15.262     0.150
     0.803    25.969     0.150
     0.804    15.250     0.150
     0.804    25.660     0.150
     0.798    14.941     0.150
     0.798    25.289     0.150
     0.798    25.391     0.150
     0.918    17.039     0.150
     0.918    29.379     0.150
     0.918    29.641     0.150
     1.019    18.422     0.150
     1.019    32.129     0.150
     1.019    31.750     0.150
     0.963    18.430     0.150
     0.963    31.629     0.150
     0.994    19.031     0.150
     0.994    32.102     0.150
     0.999    33.680     0.150
     1.053    19.711     0.150
     1.053    33.039     0.150
     1.046    19.211     0.150
     1.046    32.391     0.150
     1.046    32.738     0.150
     1.046    19.320     0.150
     1.103    20.180     0.150
     1.103    34.250     0.150
     1.103    20.051     0.150
     1.103    34.141     0.150
     1.098    20.371     0.150
     1.098    34.539     0.150
     1.069    20.031     0.150
     1.069    33.852     0.150
     1.124    20.500     0.150
     1.124    34.898     0.150
     1.145    21.898     0.150
     1.209    21.672     0.150
     1.226    21.949     0.150
     1.226    37.961     0.150
     1.226    21.809     0.150
     1.226    37.648     0.150
     1.281    22.910     0.150
     1.349    24.871     0.150
     1.305    23.770     0.150
     1.265    41.469     0.150
     1.283    23.891     0.150
     1.396    25.102     0.150
     1.350    25.398     0.150
     1.378    25.512     0.150
     1.378    42.941     0.150
     1.346    44.500     0.150
     1.413    25.410     0.150
     1.416    26.051     0.150
     1.447    26.039     0.150
     1.481    26.328     0.150
     1.496    29.609     0.150
     1.566    28.410     0.150
     1.569    28.359     0.150
     1.569    49.031     0.150
     1.615    28.641     0.150
     1.615    48.969     0.150
     1.614    49.148     0.150
     1.605    28.648     0.150
     1.603    51.020     0.150
     1.692    30.559     0.150
     1.729    30.422     0.150
     1.704    29.871     0.150
     1.693    28.648     0.150
     1.779    32.801     0.150
     1.746    29.410     0.150
     1.814    33.160     0.150
     1.901    33.551     0.150
     1.965    34.148     0.150
     1.961    36.070     0.150
     1.993    34.391     0.150
     2.046    34.512     0.150
     2.097    35.059     0.150
     2.210    36.172     0.150
     2.394    39.559     0.150
     2.496    41.039     0.150
     3.446    54.219     0.150
     5.089    78.449     0.150
     5.707    87.301     0.150
     6.002    91.691     0.150
     7.651   113.000     0.150
     0.339    11.835     0.150
     0.339    12.105     0.150
     0.202     4.665     0.150
     0.202     7.495     0.150
     0.439     8.685     0.150
     0.439    14.525     0.150
     0.366     7.485     0.150
     0.366    12.525     0.150
     0.665    12.685     0.150
     0.665    21.175     0.150
     0.772    14.465     0.150
     0.772    24.745     0.150
     0.797    15.345     0.150
     0.797    26.145     0.150
     0.862    15.915     0.150
     0.872    16.545     0.150
     0.888    17.025     0.150
     0.888    16.875     0.150
     0.888    28.555     0.150
     0.956    17.375     0.150
     0.956    29.845     0.150
     0.943    17.055     0.150
     0.943    29.115     0.150
     0.943    17.405     0.150
     0.955    17.855     0.150
     0.955    30.425     0.150
     0.955    29.685     0.150
     0.963    18.085     0.150
     1.011    32.115     0.150
     1.030    18.715     0.150
     1.030    18.585     0.150
     1.030    31.795     0.150
     1.043    18.955     0.150
     1.094    20.325     0.150
     1.094    35.305     0.150
     1.143    20.465     0.150
     1.143    35.675     0.150
     1.107    36.035     0.150
     1.153    20.315     0.150
     1.153    35.305     0.150
     1.153    20.615     0.150
     1.153    35.545     0.150
     1.153    36.875     0.150
     1.160    38.165     0.150
     1.238    22.965     0.150
     1.238    39.805     0.150
     1.211    21.615     0.150
     1.211    37.525     0.150
     1.230    22.115     0.150
     1.230    38.175     0.150
     1.230    21.775     0.150
     1.230    37.925     0.150
     1.181    21.845     0.150
     1.222    22.375     0.150
     1.222    38.115     0.150
     1.315    23.385     0.150
     1.315    23.235     0.150
     1.315    40.715     0.150
     1.240    41.515     0.150
     1.246    23.265     0.150
     1.332    23.565     0.150
     1.332    40.835     0.150
     1.360    23.545     0.150
     1.332    23.715     0.150
     1.326    24.445     0.150
     1.326    42.115     0.150
     1.363    24.785     0.150
     1.363    42.295     0.150
     1.352    23.655     0.150
     1.409    25.065     0.150
     1.409    42.975     0.150
     1.430    43.925     0.150
     1.433    25.915     0.150
     1.478    45.255     0.150
     1.414    46.295     0.150
     1.481    26.575     0.150
     1.467    24.915     0.150
     1.467    44.455     0.150
     1.509    26.675     0.150
     1.509    48.365     0.150
     1.543    26.425     0.150
     1.534    45.595     0.150
     1.556    47.935     0.150
     1.505    25.335     0.150
     1.509    25.515     0.150
     1.574    30.865     0.150
     1.606    28.675     0.150
     1.606    50.845     0.150
     1.612    27.095     0.150
     1.610    26.745     0.150
     1.665    28.825     0.150
     1.665    50.295     0.150
     1.677    52.265     0.150
     1.645    27.475     0.150
     1.684    30.875     0.150
     1.725    30.035     0.150
     1.715    28.725     0.150
     1.819    32.045     0.150
     1.894    32.665     0.150
     1.894    57.385     0.150
     1.871    34.145     0.150
     1.916    31.975     0.150
     1.953    31.955     0.150
     1.953    32.699     0.150
     1.953    36.026     0.150
     1.953    61.424     0.150
     1.974    36.175     0.150
     2.008    34.535     0.150
     1.974    32.865     0.150
     2.033    35.015     0.150
     1.991    32.905     0.150
     2.103    36.315     0.150
     2.051    34.035     0.150
     2.108    35.295     0.150
     2.131    34.585     0.150
     2.144    37.985     0.150
     2.286    39.305     0.150
     2.293    36.725     0.150
     2.415    42.155     0.150
     2.368    37.465     0.150
     2.424    44.195     0.150
     2.404    38.825     0.150
     2.539    40.515     0.150
     2.680    41.425     0.150
     2.670    48.465     0.150
     2.978    46.435     0.150
     2.988    48.375     0.150
     3.100    47.165     0.150
     3.259    54.445     0.150
     3.369    52.225     0.150
     3.347    51.635     0.150
     3.477    55.235     0.150
     3.434    52.755     0.150
     3.489    53.685     0.150
     3.661    55.845     0.150
     3.786    58.095     0.150
     3.801    59.425     0.150
     3.955    60.295     0.150
     6.984   103.680     0.150
     6.984   127.680     0.150
     8.573   125.474     0.150
     8.573   268.299     0.150
    10.850   157.255     0.150
    10.850   341.905     0.150
    12.155   176.943     0.150
     0.186     4.137     0.150
     0.186     6.707     0.150
     0.186     7.859     0.150
     0.186     7.176     0.150
     0.476     9.406     0.150
     0.476    15.738     0.150
     0.477     9.418     0.150
     0.477    15.996     0.150
     0.477    16.387     0.150
     0.470     9.359     0.150
     0.470    16.328     0.150
     0.470    15.977     0.150
     0.512     9.777     0.150
     0.512    16.457     0.150
     0.512    16.738     0.150
     0.549    10.359     0.150
     0.549    17.727     0.150
     0.549    18.316     0.150
     0.549    17.586     0.150
     0.562    10.598     0.150
     0.562    17.988     0.150
     0.690    12.879     0.150
     0.690    22.188     0.150
     0.690    13.020     0.150
     0.690    21.836     0.150
     0.690    23.547     0.150
     0.852    16.438     0.150
     0.862    16.789     0.150
     0.862    30.027     0.150
     0.866    16.727     0.150
     0.866    30.289     0.150
     0.866    16.859     0.150
     0.919    17.418     0.150
     0.951    18.508     0.150
     0.951    32.848     0.150
     0.968    18.770     0.150
     0.968    33.469     0.150
     0.971    17.758     0.150
     0.971    30.367     0.150
     0.971    31.797     0.150
     0.983    17.887     0.150
     0.983    31.137     0.150
     0.983    32.879     0.150
     1.033    19.117     0.150
     1.174    21.426     0.150
     1.174    21.129     0.150
     1.209    22.289     0.150
     1.209    38.469     0.150
     1.209    39.629     0.150
     1.209    37.887     0.150
     1.298    23.457     0.150
     1.298    40.297     0.150
     1.298    41.289     0.150
     1.298    39.977     0.150
     1.361    24.496     0.150
     1.361    42.008     0.150
     1.361    43.406     0.150
     1.482    26.418     0.150
     1.482    45.547     0.150
     1.482    26.609     0.150
     1.482    26.527     0.150
     1.515    25.949     0.150
     1.574    28.117     0.150
     1.574    48.547     0.150
     1.588    28.867     0.150
     1.588    49.848     0.150
     1.588    29.277     0.150
     1.682    28.418     0.150
     1.697    29.078     0.150
     1.872    32.746     0.150
     1.878    32.977     0.150
     1.890    33.656     0.150
     2.003    34.867     0.150
     2.009    32.926     0.150
     2.136    35.348     0.150
     2.152    35.469     0.150
     2.181    36.527     0.150
     2.224    37.117     0.150
     2.224    40.617     0.150
     2.224    69.441     0.150
     2.234    38.020     0.150
     2.422    39.008     0.150
     2.514    40.727     0.150
     2.635    43.316     0.150
     2.678    43.449     0.150
     2.678    42.887     0.150
     2.826    45.348     0.150
     3.055    47.336     0.150
     3.104    49.457     0.150
     3.134    50.816     0.150
     3.206    50.887     0.150
     3.304    51.578     0.150
     3.434    54.656     0.150
     3.867    60.039     0.150
     3.921    61.328     0.150
     4.181    63.078     0.150
     5.193    79.797     0.150
     5.209    79.328     0.150
     5.460    84.066     0.150
     5.631    84.508     0.150
     5.634    84.059     0.150
     5.671    86.789     0.150
     5.719    85.527     0.150
     6.150    93.996     0.150
     6.190    93.688     0.150
     6.384    96.316     0.150
     6.502    97.207     0.150
     6.523    98.758     0.150
     7.106   107.688     0.150
     7.156   106.477     0.150
     7.257   110.871     0.150
     7.677   112.199     0.150
     8.054   120.520     0.150
     8.123   119.648     0.150
     8.182   121.078     0.150
     8.400   123.816     0.150
     8.400   122.719     0.150
     8.546   124.898     0.150
     8.725   127.309     0.150
     8.788   130.699     0.150
     8.888   132.297     0.150
     9.133   133.137     0.150
     9.208   136.438     0.150
     9.230   138.523     0.150
     9.543   139.418     0.150
    10.533   153.246     0.150
    12.232   178.449     0.150
    14.957   213.938     0.150
    15.087   212.996     0.150
    15.224   214.887     0.150
    15.339   217.168     0.150
    15.390   217.227     0.150
    15.546   220.246     0.150
    15.694   221.617     0.150
    16.267   228.617     0.150
    16.328   227.238     0.150
    16.346   229.246     0.150
    16.714   234.816     0.150
    38.495   447.699     0.150
    80.908   737.871     0.150
     8.398   122.246     0.150
     2.224    37.336     0.150
     0.191     4.105     0.150
     0.191     7.105     0.150
     0.191     7.535     0.150
     0.476     9.355     0.150
     0.476    15.617     0.150
     0.477     9.355     0.150
     0.477    15.586     0.150
     0.477    16.027     0.150
     0.478     9.355     0.150
     0.478    15.727     0.150
     0.504     9.766     0.150
     0.504    16.547     0.150
     0.544    10.336     0.150
     0.544    17.598     0.150
     0.565    10.625     0.150
     0.565    18.008     0.150
     0.565    18.508     0.150
     0.682    12.906     0.150
     0.682    22.047     0.150
     0.844    16.438     0.150
     0.855    16.664     0.150
     0.855    29.734     0.150
     0.861    17.508     0.150
     0.911    31.406     0.150
     0.968    17.785     0.150
     0.968    31.047     0.150
     0.981    17.938     0.150
     0.981    31.164     0.150
     1.027    35.875     0.150
     1.141    21.695     0.150
     1.166    21.266     0.150
     1.166    36.465     0.150
     1.204    21.945     0.150
     1.204    38.176     0.150
     1.204    39.535     0.150
     1.204    22.324     0.150
     1.214    22.516     0.150
     1.293    23.477     0.150
     1.293    40.297     0.150
     1.344    25.008     0.150
     1.353    24.676     0.150
     1.476    26.414     0.150
     1.476    45.645     0.150
     1.476    26.727     0.150
     1.509    25.676     0.150
     1.509    44.375     0.150
     1.525    27.957     0.150
     1.557    28.395     0.150
     1.557    48.465     0.150
     1.568    28.367     0.150
     1.645    30.824     0.150
     1.688    31.207     0.150
     1.866    32.785     0.150
     1.883    32.938     0.150
     2.003    32.895     0.150
     2.128    35.605     0.150
     2.143    36.566     0.150
     2.173    37.375     0.150
     2.216    37.676     0.150
     2.228    38.355     0.150
     2.414    40.938     0.150
     2.506    42.406     0.150
     2.628    44.617     0.150
     2.670    44.758     0.150
     2.819    47.406     0.150
     3.047    50.137     0.150
     3.152    51.727     0.150
     3.197    52.637     0.150
     3.223    52.586     0.150
     3.240    53.496     0.150
     3.353    52.727     0.150
     3.428    54.906     0.150
     3.647    58.215     0.150
     3.676    57.938     0.150
     3.859    60.895     0.150
     4.178    64.566     0.150
     4.189    66.266     0.150
     4.265    66.027     0.150
     4.295    67.137     0.150
     4.414    68.445     0.150
     4.445    69.305     0.150
     4.547    69.555     0.150
     4.566    71.188     0.150
     4.646    72.766     0.150
     4.743    73.914     0.150
     4.747    73.766     0.150
     4.985    76.875     0.150
     4.997    77.887     0.150
     5.054    76.887     0.150
     5.408    82.375     0.150
     5.452    84.336     0.150
     5.625    84.426     0.150
     5.626    86.047     0.150
     5.715    86.016     0.150
     5.827    87.805     0.150
     5.884    87.957     0.150
     5.901    89.484     0.150
     6.091    91.938     0.150
     6.119    92.805     0.150
     6.143    93.305     0.150
     6.182    93.965     0.150
     6.304    95.957     0.150
     6.515    99.355     0.150
     6.721    99.016     0.150
     7.154   107.008     0.150
     7.555   112.445     0.150
     8.176   121.574     0.150
     8.459   127.406     0.150
     8.724   127.906     0.150
     8.725   128.637     0.150
     8.729   128.797     0.150
    10.533   153.367     0.150
    10.534   153.195     0.150
     0.186     4.055     0.150
     0.186     7.043     0.150
     0.186     8.242     0.150
     0.186     7.344     0.150
     0.468     9.293     0.150
     0.468    15.793     0.150
     0.468    16.574     0.150
     0.475     9.395     0.150
     0.475    15.703     0.150
     0.476     9.355     0.150
     0.476    15.582     0.150
     0.514     9.785     0.150
     0.514    16.703     0.150
     0.514    16.504     0.150
     0.550    10.324     0.150
     0.550    17.582     0.150
     0.562    10.555     0.150
     0.562    18.242     0.150
     0.562    18.395     0.150
     0.691    12.863     0.150
     0.691    22.203     0.150
     0.853    16.094     0.150
     0.853    29.234     0.150
     0.862    16.754     0.150
     0.866    17.504     0.150
     0.973    17.754     0.150
     0.973    30.703     0.150
     0.984    18.094     0.150
     0.984    31.105     0.150
     0.984    30.332     0.150
     1.035    19.195     0.150
     1.035    33.523     0.150
     1.036    19.355     0.150
     1.151    36.375     0.150
     1.175    21.734     0.150
     1.175    36.453     0.150
     1.210    22.234     0.150
     1.210    38.395     0.150
     1.210    21.805     0.150
     1.210    37.715     0.150
     1.224    22.184     0.150
     1.224    37.773     0.150
     1.316    40.766     0.150
     1.362    24.855     0.150
     1.362    42.223     0.150
     1.363    42.133     0.150
     1.484    26.492     0.150
     1.484    45.113     0.150
     1.484    26.773     0.150
     1.516    25.562     0.150
     1.516    44.414     0.150
     1.546    28.375     0.150
     1.546    47.332     0.150
     1.576    48.375     0.150
     1.648    29.855     0.150
     1.648    50.676     0.150
     1.683    29.543     0.150
     1.740    53.004     0.150
     1.874    32.926     0.150
     1.892    32.805     0.150
     2.009    32.703     0.150
     2.137    35.402     0.150
     2.153    36.176     0.150
     2.226    36.953     0.150
     2.236    37.742     0.150
     2.637    43.594     0.150
     2.637    43.434     0.150
     2.679    45.004     0.150
     2.679    43.363     0.150
     2.751    49.594     0.150
     4.999    75.754     0.150
     6.130    87.184     0.150
     0.275     9.362     0.150
     0.275    10.242     0.150
     0.264     5.472     0.150
     0.264     9.282     0.150
     0.264     9.651     0.150
     0.264     9.771     0.150
     0.354     7.172     0.150
     0.354    11.922     0.150
     0.354    12.062     0.150
     0.456     9.322     0.150
     0.456    15.162     0.150
     0.456    15.322     0.150
     0.650    12.462     0.150
     0.650    21.092     0.150
     0.650    21.242     0.150
     0.662    12.582     0.150
     0.662    21.582     0.150
     0.662    21.362     0.150
     0.704    12.941     0.150
     0.704    22.392     0.150
     0.704    23.151     0.150
     0.783    14.952     0.150
     0.783    25.332     0.150
     0.791    15.112     0.150
     0.791    25.162     0.150
     0.792    15.102     0.150
     0.792    25.182     0.150
     0.921    16.912     0.150
     0.921    29.542     0.150
     0.984    31.832     0.150
     0.986    19.072     0.150
     1.026    19.432     0.150
     1.021    18.492     0.150
     1.021    31.962     0.150
     1.039    19.142     0.150
     1.039    31.892     0.150
     1.039    19.362     0.150
     1.039    32.572     0.150
     1.048    19.731     0.150
     1.048    33.092     0.150
     1.060    19.762     0.150
     1.060    33.731     0.150
     1.096    20.342     0.150
     1.104    20.132     0.150
     1.104    34.292     0.150
     1.104    34.432     0.150
     1.123    20.372     0.150
     1.123    35.021     0.150
     1.187    22.191     0.150
     1.187    37.082     0.150
     1.207    38.231     0.150
     1.211    21.622     0.150
     1.211    37.422     0.150
     1.227    21.832     0.150
     1.227    37.322     0.150
     1.257    23.082     0.150
     1.274    23.422     0.150
     1.274    40.651     0.150
     1.277    23.392     0.150
     1.277    40.142     0.150
     1.282    22.792     0.150
     1.282    39.502     0.150
     1.291    22.832     0.150
     1.291    22.952     0.150
     1.291    40.222     0.150
     1.291    23.401     0.150
     1.304    40.322     0.150
     1.329    23.862     0.150
     1.398    24.672     0.150
     1.398    42.812     0.150
     1.398    24.651     0.150
     1.412    25.052     0.150
     1.563    27.052     0.150
     1.563    48.502     0.150
     1.616    28.142     0.150
     1.678    27.962     0.150
     1.678    48.302     0.150
     1.701    29.392     0.150
     1.733    29.271     0.150
     1.993    33.882     0.150
     2.043    33.952     0.150
     2.066    34.271     0.150
     2.088    34.582     0.150
     2.145    35.612     0.150
     2.195    35.422     0.150
     2.381    39.382     0.150
     2.388    39.102     0.150
     2.459    40.691     0.150
     2.492    40.782     0.150
     2.607    42.262     0.150
     2.636    42.112     0.150
     2.708    42.372     0.150
     2.963    46.162     0.150
     2.986    47.132     0.150
     3.079    48.452     0.150
     3.167    49.562     0.150
     3.426    53.092     0.150
     3.446    53.282     0.150
     3.529    55.042     0.150
     3.525    57.252     0.150
     3.752    58.392     0.150
     3.894    59.742     0.150
     3.975    61.082     0.150
     4.013    61.302     0.150
     4.209    65.162     0.150
     4.290    66.092     0.150
     4.358    66.342     0.150
     4.404    67.651     0.150
     4.412    68.082     0.150
     4.552    69.252     0.150
     4.555    69.582     0.150
     4.605    70.622     0.150
     4.618    70.702     0.150
     4.693    71.742     0.150
     4.722    71.912     0.150
     4.932    75.252     0.150
     4.959    75.552     0.150
     5.076    77.602     0.150
     5.131    77.401     0.150
     5.263    79.032     0.150
     5.334    80.842     0.150
     5.694    86.262     0.150
     5.765    86.172     0.150
     5.830    87.292     0.150
     5.923    88.722     0.150
     5.960    88.552     0.150
     5.990    90.832     0.150
     6.026    90.562     0.150
     6.094    90.992     0.150
     6.107    90.632     0.150
     6.162    91.662     0.150
     6.214    91.132     0.150
     6.306    95.392     0.150
     6.428    95.502     0.150
     6.584    97.882     0.150
     6.656    97.422     0.150
     7.370   109.252     0.150
     7.395   108.052     0.150
     7.613   112.642     0.150
     7.853   116.322     0.150
    10.850   156.651     0.150
EOF
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jBL  << EOF
    60.000   140.000 P phases in red
EOF
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL  << EOF
    60.000   100.000 S phases in green
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL  << EOF
    60.000    60.000 Readings used for cluster vectors in black
EOF
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    60.000    20.000 Readings not used for cluster vectors in cyan
EOF
gmt end
