#!/bin/bash
gmt begin alberchigos1.34_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-23/23/-23/23
gmt basemap $proj $reg -Bxa10f5+l'km' -Bya10f5+l'km' -BWeSn+t'Epicentral Mislocation alberchigos1.34'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     5.132     5.132
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.602    -1.755
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.602    -1.755 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -9.026     5.211
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -9.026     5.211 2
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.771     2.094
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.771     2.094 3
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.530    -3.668
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.530    -3.668 4
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.709     0.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -7.825    -8.690
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -7.825    -8.690 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.329    -9.427
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.329    -9.427 7
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.593     1.940
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.202    -1.441
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.677    -3.685
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.331     0.800
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.126    -6.542
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.126    -6.542 12
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.443    -3.608
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.718     2.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.691     1.246
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.348    -0.462
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.944    -0.307
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.329     3.758
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.361    -4.128
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -6.697     2.571
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -6.697     2.571 20
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.566     2.411
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.212     1.130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.050     2.844
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.602    -4.900
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.776    -2.117
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.768    -3.952
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.482    -3.983
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.482    -3.983 27
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.931    -1.127
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.240    -1.517
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.658     2.282
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.514     3.590
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.913    -0.619
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    12.416    -1.966
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    12.416    -1.966 33
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.682     1.777
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.243    -1.775
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.002     0.141
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.615     2.194
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.815    -3.275
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.752    -0.673
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.247    -1.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.584    -2.032
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.584    -2.032 41
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.089     5.073
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.023    -6.195
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.023    -6.195 43
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.546     4.093
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.546     4.093 44
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.665    -1.930
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.516     2.401
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.890    -1.320
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.323     0.536
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.339     1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.024     0.177
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.259     1.582
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.840     2.063
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.850    -0.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.084     0.395
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.916     1.497
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.523    -1.826
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.849     5.842
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.849     5.842 57
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.961    -3.289
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.509     0.308
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.544     0.248
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.873    -1.809
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.363     0.819
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.814     1.270
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.230    -6.600
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.230    -6.600 64
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.577    -0.133
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.036    -2.044
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -10.881   -18.847
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -10.881   -18.847 67
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.224     0.679
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.006    -2.621
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.371    -7.778
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.371    -7.778 70
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.671    -5.242
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -2.671    -5.242 71
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.673     0.627
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.103    -0.689
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.065     7.748
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.065     7.748 74
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.512     0.081
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.573    -0.659
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.431    -0.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.463    -2.218
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.413    -1.818
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.078     0.937
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.189    -2.670
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.244    -4.646
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.284    -1.139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.024    -2.197
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.385    -0.536
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.528     0.955
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.092    -4.382
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.958    -0.349
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.941     0.745
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.853    -1.132
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.207     0.425
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.743     0.533
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.931    -4.366
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -3.931    -4.366 93
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.642    -1.157
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.075     0.613
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.502    -2.026
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.097    -2.164
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.097    -2.164 97
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.489    -2.354
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.678    -1.006
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.702    -0.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.312     8.282
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.312     8.282 101
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.201    -1.774
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.167     0.414
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.892    -0.190
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.321    -4.588
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.107    -0.692
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.303    -0.173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.931    -1.455
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.098    -1.828
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.508    -2.989
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.282    -1.983
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.933    -0.974
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.933    -0.974 112
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.999    -1.191
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.112    -1.649
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.851    -1.912
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.091    -5.226
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -0.091    -5.226 116
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.263     1.961
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.398    -4.301
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.734    -1.355
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.210    -1.532
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.555    -0.711
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.671    -6.704
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.671    -6.704 122
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.132    -0.074
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.024    -3.263
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.024    -3.263 124
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.556    -0.856
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.676     0.418
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.934    -0.065
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.801    -0.066
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.338    -0.316
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
   -12.209    -7.629
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
   -12.209    -7.629 130
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.613    -1.008
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.231    -3.297
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.144     0.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.552    -0.879
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.710    -3.651
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.436    -1.197
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.254     1.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.672    -1.509
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.591    -8.282
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.591    -8.282 139
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.636    -1.499
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.421     1.578
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.988     2.221
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.988     2.221 142
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.207    -0.238
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.957    -0.310
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.006    -6.255
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.006    -6.255 145
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.669    -9.163
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.669    -9.163 146
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.074    -0.851
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.041    -0.386
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.454     0.204
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.289    -0.000
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.389     2.725
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.374   -10.342
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.374   -10.342 152
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.373   -11.762
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.373   -11.762 153
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.579    -7.457
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     8.579    -7.457 154
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.487     0.371
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     7.829    -9.669
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     7.829    -9.669 156
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.929    -0.266
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.870    -3.805
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.870    -3.805 158
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.632     0.123
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.543    -1.439
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.385     0.219
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.124    -1.011
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.055    -1.042
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.519    -1.687
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.215     0.541
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.088    -6.088
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.088    -6.088 166
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.201     0.468
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.645    -0.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.432    -1.591
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.368     1.070
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.773    -0.446
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.150    -6.142
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.150    -6.142 172
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -8.280    -4.219
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -8.280    -4.219 173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.388   -13.335
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -5.388   -13.335 174
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.553     1.242
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.410     0.951
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.652     1.337
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.697     1.565
EOF
gmt plot $proj $reg -SE -Gred << EOF
    -0.542    -1.321     0.000     1.500     1.500
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -21.500    21.500 Author: all ( 178 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -21.500   -21.500 Average =   1.4 km at 202.3 deg; median =    2.6 km
EOF
gmt end
