#!/bin/bash
gmt begin alberchigos1.34_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-24/16/0/96
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa10f1+l'Depth (km)' -Bya50f10+lCounts -BWeSn+t'Focal Depth Mislocation alberchigos1.34' << EOF
    -0.000
     2.000
    -3.800
    -0.000
     3.200
     0.300
    -6.000
     0.400
    -4.700
    -3.100
    -0.800
    -4.200
     0.900
     0.200
     7.000
     4.400
    -3.700
     9.000
    -0.000
    -0.000
    -0.000
     2.800
     5.000
    -0.000
    -0.000
    -0.000
     0.200
     6.100
    -0.200
    -0.700
    -2.200
     9.000
     3.100
    -0.000
    -0.000
     0.800
     0.700
     0.100
    -0.800
    -0.000
    -6.200
    -0.500
     7.000
    -1.900
     4.900
    -3.900
     1.700
     1.500
     3.400
     1.000
    -0.400
     0.400
    -0.500
    -0.300
     1.900
     0.500
     2.000
    -0.300
    -0.200
     0.100
     2.900
    -7.100
     0.200
     0.200
     1.200
     8.500
   -15.800
    -0.500
    10.400
    -0.100
    -4.300
    -1.800
    -0.200
     5.500
    -2.500
    -1.800
     1.100
    -0.700
     1.500
     0.100
     5.500
    -0.700
   -19.100
    10.600
    -0.300
     3.200
     1.100
     0.200
     3.100
    -0.100
    -2.700
    -0.300
    -0.400
    -0.400
    -7.400
    -0.100
    -4.300
     5.900
    -0.000
    -5.500
    -3.400
     0.300
    -1.500
     0.200
     8.300
     2.700
    -0.000
     2.400
     7.500
    -0.000
     0.300
     0.100
     2.300
     0.200
    -0.100
    -0.000
     0.200
     0.400
     3.200
    -0.000
    -2.000
     0.300
     1.500
    -0.200
    -0.000
     0.300
     0.100
     2.000
    -0.500
    -2.000
     0.800
     0.800
     0.100
    -0.000
    -1.000
     0.200
     0.500
    -0.300
    -2.200
     4.200
    -0.000
     2.000
     0.400
     1.000
     3.000
     1.000
     1.800
     0.400
    -0.000
    -0.000
    -0.000
    -0.300
     6.700
     0.100
    -1.600
     0.200
     1.000
    -0.000
    -0.000
     0.100
     5.100
    -0.100
     0.300
     4.300
    -0.000
    -0.000
    -0.000
     1.300
    -0.000
    -0.000
    -2.800
    -0.000
    -0.000
    -3.000
    -0.000
    -0.000
     1.600
    -2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -0.000    85.040 Median =  -0.0 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -0.0  0.
 -0.0  83.4
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -23.000    90.960 Author: all ( 178 samples)
EOF
gmt end
