#!/bin/bash
gmt begin alberchigos1.34_dcal pdf,ps
proj=-JM16.0c+
reg=-R-118.5/-113.0/28.9/33.8
gmt basemap $proj $reg -Bxa1.0f0.5 -Bya1.0f0.5 -BWeSn+t'Direct Calibration alberchigos1.34'

# Standard Topography (ETOPO1)
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue
# Raypaths used in direct calibration
gmt plot $proj $reg -Wthick,red << EOF
  -115.942    31.928
  -116.126    31.767
>
  -116.660    31.869
  -116.126    31.767
>
  -116.663    31.884
  -116.126    31.767
>
  -116.664    32.313
  -116.126    31.767
>
  -115.242    31.988
  -116.126    31.767
>
  -115.942    31.928
  -115.691    31.768
>
  -115.942    31.928
  -115.691    31.768
>
  -116.598    31.657
  -115.691    31.768
>
  -116.598    31.657
  -115.691    31.768
>
  -115.942    31.928
  -115.602    31.253
>
  -115.942    31.928
  -115.602    31.253
>
  -115.051    31.472
  -115.593    31.284
>
  -115.942    31.928
  -115.593    31.284
>
  -115.942    31.928
  -115.593    31.284
>
  -115.942    31.928
  -115.720    31.889
>
  -115.942    31.928
  -115.720    31.889
>
  -116.442    31.962
  -115.720    31.889
>
  -116.442    31.962
  -115.720    31.889
>
  -116.598    31.657
  -115.720    31.889
>
  -116.598    31.657
  -115.720    31.889
>
  -115.725    32.649
  -115.720    31.889
>
  -115.923    32.648
  -115.720    31.889
>
  -115.942    31.928
  -115.587    31.205
>
  -115.942    31.928
  -115.587    31.205
>
  -115.464    31.045
  -115.575    31.607
>
  -115.464    31.045
  -115.575    31.607
>
  -115.942    31.928
  -115.575    31.607
>
  -115.942    31.928
  -115.575    31.607
>
  -116.663    31.884
  -116.196    31.852
>
  -116.663    31.884
  -116.196    31.852
>
  -116.663    31.868
  -116.196    31.852
>
  -116.663    31.868
  -116.196    31.852
>
  -116.598    31.657
  -116.196    31.852
>
  -116.598    31.657
  -116.196    31.852
>
  -116.725    31.742
  -116.196    31.852
>
  -116.664    32.313
  -116.196    31.852
>
  -116.664    32.313
  -116.196    31.852
>
  -116.664    32.313
  -116.196    31.852
>
  -116.598    31.657
  -116.296    31.832
>
  -116.598    31.657
  -116.296    31.832
>
  -116.598    31.657
  -116.296    31.832
>
  -116.660    31.869
  -116.296    31.832
>
  -116.663    31.868
  -116.296    31.832
>
  -115.942    31.928
  -116.296    31.832
>
  -115.942    31.928
  -116.296    31.832
>
  -116.663    31.884
  -116.296    31.832
>
  -116.663    31.884
  -116.296    31.832
>
  -116.725    31.742
  -116.296    31.832
>
  -116.664    32.313
  -116.296    31.832
>
  -116.664    32.313
  -116.296    31.832
>
  -116.598    31.657
  -116.235    31.807
>
  -116.598    31.657
  -116.235    31.807
>
  -116.598    31.657
  -116.235    31.807
>
  -115.942    31.928
  -116.235    31.807
>
  -115.942    31.928
  -116.235    31.807
>
  -116.663    31.868
  -116.235    31.807
>
  -116.663    31.884
  -116.235    31.807
>
  -116.663    31.884
  -116.235    31.807
>
  -116.663    31.884
  -116.235    31.807
>
  -116.725    31.742
  -116.235    31.807
>
  -116.725    31.742
  -116.235    31.807
>
  -116.725    31.742
  -116.235    31.807
>
  -116.725    31.742
  -116.235    31.807
>
  -116.664    32.313
  -116.235    31.807
>
  -116.664    32.313
  -116.235    31.807
>
  -115.242    31.988
  -115.969    31.693
>
  -115.242    31.988
  -115.969    31.693
>
  -115.464    31.045
  -115.969    31.693
>
  -115.464    31.045
  -115.969    31.693
>
  -115.942    31.928
  -116.178    31.769
>
  -115.942    31.928
  -116.178    31.769
>
  -116.598    31.657
  -116.178    31.769
>
  -116.598    31.657
  -116.178    31.769
>
  -116.663    31.884
  -116.178    31.769
>
  -116.663    31.884
  -116.178    31.769
>
  -116.725    31.742
  -116.178    31.769
>
  -116.725    31.742
  -116.178    31.769
>
  -116.725    31.742
  -116.178    31.769
>
  -116.664    32.313
  -116.178    31.769
>
  -116.664    32.313
  -116.178    31.769
>
  -116.598    31.657
  -116.299    31.851
>
  -116.598    31.657
  -116.299    31.851
>
  -116.663    31.868
  -116.299    31.851
>
  -115.942    31.928
  -116.299    31.851
>
  -115.942    31.928
  -116.299    31.851
>
  -116.664    32.313
  -116.299    31.851
>
  -116.664    32.313
  -116.299    31.851
>
  -115.942    31.928
  -115.980    31.627
>
  -115.942    31.928
  -115.980    31.627
>
  -116.273    31.514
  -115.980    31.627
>
  -116.273    31.514
  -115.980    31.627
>
  -116.598    31.657
  -115.980    31.627
>
  -116.725    31.742
  -115.980    31.627
>
  -116.725    31.742
  -115.980    31.627
>
  -115.242    31.988
  -115.980    31.627
>
  -115.242    31.988
  -115.980    31.627
>
  -115.464    31.045
  -115.980    31.627
>
  -115.464    31.045
  -115.980    31.627
>
  -115.464    31.045
  -115.980    31.627
>
  -115.466    31.046
  -115.647    31.279
>
  -115.466    31.046
  -115.647    31.279
>
  -115.464    31.045
  -115.647    31.279
>
  -115.464    31.045
  -115.647    31.279
>
  -115.051    31.472
  -115.647    31.279
>
  -116.273    31.514
  -115.647    31.279
>
  -116.273    31.514
  -115.647    31.279
>
  -115.942    31.928
  -115.647    31.279
>
  -115.942    31.928
  -115.647    31.279
>
  -115.466    31.046
  -115.662    31.276
>
  -115.466    31.046
  -115.662    31.276
>
  -115.464    31.045
  -115.662    31.276
>
  -115.464    31.045
  -115.662    31.276
>
  -115.051    31.472
  -115.662    31.276
>
  -115.051    31.472
  -115.662    31.276
>
  -116.273    31.514
  -115.662    31.276
>
  -116.273    31.514
  -115.662    31.276
>
  -115.942    31.928
  -115.662    31.276
>
  -115.942    31.928
  -115.662    31.276
>
  -115.466    31.046
  -115.658    31.282
>
  -115.466    31.046
  -115.658    31.282
>
  -115.466    31.046
  -115.658    31.282
>
  -115.464    31.045
  -115.658    31.282
>
  -115.464    31.045
  -115.658    31.282
>
  -115.051    31.472
  -115.658    31.282
>
  -115.051    31.472
  -115.658    31.282
>
  -116.273    31.514
  -115.658    31.282
>
  -115.942    31.928
  -115.658    31.282
>
  -115.942    31.928
  -115.658    31.282
>
  -116.273    31.514
  -115.667    31.269
>
  -116.273    31.514
  -115.667    31.269
>
  -115.942    31.928
  -115.667    31.269
>
  -115.942    31.928
  -115.667    31.269
>
  -115.466    31.046
  -115.656    31.276
>
  -115.466    31.046
  -115.656    31.276
>
  -115.466    31.046
  -115.656    31.276
>
  -115.464    31.045
  -115.656    31.276
>
  -115.464    31.045
  -115.656    31.276
>
  -115.464    31.045
  -115.656    31.276
>
  -115.464    31.045
  -115.656    31.276
>
  -115.464    31.045
  -115.656    31.276
>
  -115.051    31.472
  -115.656    31.276
>
  -115.051    31.472
  -115.656    31.276
>
  -116.273    31.514
  -115.656    31.276
>
  -116.273    31.514
  -115.656    31.276
>
  -115.942    31.928
  -115.656    31.276
>
  -115.942    31.928
  -115.656    31.276
>
  -115.466    31.046
  -115.659    31.259
>
  -115.466    31.046
  -115.659    31.259
>
  -115.466    31.046
  -115.659    31.259
>
  -115.464    31.045
  -115.659    31.259
>
  -115.464    31.045
  -115.659    31.259
>
  -115.464    31.045
  -115.659    31.259
>
  -116.273    31.514
  -115.659    31.259
>
  -116.273    31.514
  -115.659    31.259
>
  -115.051    31.472
  -115.659    31.259
>
  -115.051    31.472
  -115.659    31.259
>
  -115.942    31.928
  -115.659    31.259
>
  -115.942    31.928
  -115.659    31.259
>
  -115.466    31.046
  -115.641    31.272
>
  -115.466    31.046
  -115.641    31.272
>
  -115.464    31.045
  -115.641    31.272
>
  -115.464    31.045
  -115.641    31.272
>
  -115.051    31.472
  -115.641    31.272
>
  -115.051    31.472
  -115.641    31.272
>
  -116.273    31.514
  -115.641    31.272
>
  -116.273    31.514
  -115.641    31.272
>
  -115.942    31.928
  -115.641    31.272
>
  -115.942    31.928
  -115.641    31.272
>
  -115.942    31.928
  -116.040    31.394
>
  -115.942    31.928
  -116.040    31.394
>
  -116.598    31.657
  -116.040    31.394
>
  -116.598    31.657
  -116.040    31.394
>
  -115.464    31.045
  -116.040    31.394
>
  -115.464    31.045
  -116.040    31.394
>
  -116.725    31.742
  -116.040    31.394
>
  -116.725    31.742
  -116.040    31.394
>
  -115.466    31.046
  -115.663    31.263
>
  -115.466    31.046
  -115.663    31.263
>
  -115.466    31.046
  -115.663    31.263
>
  -115.466    31.046
  -115.663    31.263
>
  -115.464    31.045
  -115.663    31.263
>
  -115.464    31.045
  -115.663    31.263
>
  -115.051    31.472
  -115.663    31.263
>
  -116.273    31.514
  -115.663    31.263
>
  -116.273    31.514
  -115.663    31.263
>
  -115.942    31.928
  -115.663    31.263
>
  -115.942    31.928
  -115.663    31.263
>
  -115.466    31.046
  -115.663    31.268
>
  -115.466    31.046
  -115.663    31.268
>
  -115.464    31.045
  -115.663    31.268
>
  -115.464    31.045
  -115.663    31.268
>
  -115.464    31.045
  -115.663    31.268
>
  -115.051    31.472
  -115.663    31.268
>
  -115.051    31.472
  -115.663    31.268
>
  -115.051    31.472
  -115.663    31.268
>
  -116.273    31.514
  -115.663    31.268
>
  -116.273    31.514
  -115.663    31.268
>
  -115.942    31.928
  -115.663    31.268
>
  -115.942    31.928
  -115.663    31.268
>
  -115.466    31.046
  -115.674    31.261
>
  -115.466    31.046
  -115.674    31.261
>
  -115.464    31.045
  -115.674    31.261
>
  -115.464    31.045
  -115.674    31.261
>
  -115.464    31.045
  -115.674    31.261
>
  -115.464    31.045
  -115.674    31.261
>
  -115.051    31.472
  -115.674    31.261
>
  -115.051    31.472
  -115.674    31.261
>
  -116.273    31.514
  -115.674    31.261
>
  -116.273    31.514
  -115.674    31.261
>
  -115.942    31.928
  -115.674    31.261
>
  -115.942    31.928
  -115.674    31.261
>
  -115.466    31.046
  -115.657    31.270
>
  -115.466    31.046
  -115.657    31.270
>
  -115.464    31.045
  -115.657    31.270
>
  -115.464    31.045
  -115.657    31.270
>
  -115.464    31.045
  -115.657    31.270
>
  -115.051    31.472
  -115.657    31.270
>
  -115.051    31.472
  -115.657    31.270
>
  -116.273    31.514
  -115.657    31.270
>
  -116.273    31.514
  -115.657    31.270
>
  -115.942    31.928
  -115.657    31.270
>
  -115.942    31.928
  -115.657    31.270
>
  -115.466    31.046
  -115.664    31.254
>
  -115.466    31.046
  -115.664    31.254
>
  -115.464    31.045
  -115.664    31.254
>
  -115.464    31.045
  -115.664    31.254
>
  -115.466    31.046
  -115.681    31.269
>
  -115.466    31.046
  -115.681    31.269
>
  -115.466    31.046
  -115.681    31.269
>
  -115.466    31.046
  -115.681    31.269
>
  -115.464    31.045
  -115.681    31.269
>
  -115.464    31.045
  -115.681    31.269
>
  -115.464    31.045
  -115.681    31.269
>
  -115.051    31.472
  -115.681    31.269
>
  -115.051    31.472
  -115.681    31.269
>
  -115.466    31.046
  -115.681    31.268
>
  -115.466    31.046
  -115.681    31.268
>
  -115.466    31.046
  -115.681    31.268
>
  -115.466    31.046
  -115.681    31.268
>
  -115.464    31.045
  -115.681    31.268
>
  -115.464    31.045
  -115.681    31.268
>
  -115.464    31.045
  -115.681    31.268
>
  -116.273    31.514
  -115.681    31.268
>
  -116.273    31.514
  -115.681    31.268
>
  -115.051    31.472
  -115.681    31.268
>
  -115.051    31.472
  -115.681    31.268
>
  -115.466    31.046
  -115.660    31.273
>
  -115.466    31.046
  -115.660    31.273
>
  -115.464    31.045
  -115.660    31.273
>
  -115.464    31.045
  -115.660    31.273
>
  -115.051    31.472
  -115.660    31.273
>
  -115.051    31.472
  -115.660    31.273
>
  -116.273    31.514
  -115.660    31.273
>
  -116.273    31.514
  -115.660    31.273
>
  -116.598    31.657
  -116.098    31.757
>
  -116.725    31.742
  -116.098    31.757
>
  -116.725    31.742
  -116.098    31.757
>
  -116.664    32.313
  -116.098    31.757
>
  -116.664    32.313
  -116.098    31.757
>
  -115.466    31.046
  -115.643    31.257
>
  -115.466    31.046
  -115.643    31.257
>
  -115.464    31.045
  -115.643    31.257
>
  -115.464    31.045
  -115.643    31.257
>
  -115.464    31.045
  -115.643    31.257
>
  -116.273    31.514
  -115.643    31.257
>
  -116.273    31.514
  -115.643    31.257
>
  -115.051    31.472
  -115.643    31.257
>
  -115.051    31.472
  -115.643    31.257
>
  -115.466    31.046
  -115.607    31.212
>
  -115.466    31.046
  -115.607    31.212
>
  -115.466    31.046
  -115.607    31.212
>
  -115.466    31.046
  -115.607    31.212
>
  -115.464    31.045
  -115.607    31.212
>
  -115.464    31.045
  -115.607    31.212
>
  -116.273    31.514
  -115.607    31.212
>
  -115.466    31.046
  -115.623    31.246
>
  -115.466    31.046
  -115.623    31.246
>
  -115.466    31.046
  -115.623    31.246
>
  -115.466    31.046
  -115.623    31.246
>
  -115.464    31.045
  -115.623    31.246
>
  -115.464    31.045
  -115.623    31.246
>
  -115.051    31.472
  -115.623    31.246
>
  -115.051    31.472
  -115.623    31.246
>
  -115.051    31.472
  -115.623    31.246
>
  -116.273    31.514
  -115.623    31.246
>
  -116.273    31.514
  -115.623    31.246
>
  -115.466    31.046
  -115.615    31.239
>
  -115.466    31.046
  -115.615    31.239
>
  -115.466    31.046
  -115.615    31.239
>
  -115.466    31.046
  -115.615    31.239
>
  -115.464    31.045
  -115.615    31.239
>
  -115.464    31.045
  -115.615    31.239
>
  -115.464    31.045
  -115.615    31.239
>
  -115.051    31.472
  -115.615    31.239
>
  -115.051    31.472
  -115.615    31.239
>
  -115.051    31.472
  -115.615    31.239
>
  -116.273    31.514
  -115.615    31.239
>
  -116.273    31.514
  -115.615    31.239
>
  -115.466    31.046
  -115.669    31.269
>
  -115.466    31.046
  -115.669    31.269
>
  -115.466    31.046
  -115.669    31.269
>
  -115.466    31.046
  -115.669    31.269
>
  -115.051    31.472
  -115.669    31.269
>
  -115.051    31.472
  -115.669    31.269
>
  -116.273    31.514
  -115.669    31.269
>
  -116.273    31.514
  -115.669    31.269
>
  -116.273    31.514
  -116.033    31.785
>
  -116.273    31.514
  -116.033    31.785
>
  -116.598    31.657
  -116.033    31.785
>
  -116.598    31.657
  -116.033    31.785
>
  -116.725    31.742
  -116.033    31.785
>
  -116.664    32.313
  -116.033    31.785
>
  -116.664    32.313
  -116.033    31.785
>
  -116.664    32.313
  -116.033    31.785
>
  -115.051    31.472
  -115.519    31.524
>
  -115.051    31.472
  -115.519    31.524
>
  -115.051    31.472
  -115.519    31.524
>
  -115.466    31.046
  -115.519    31.524
>
  -115.466    31.046
  -115.519    31.524
>
  -115.464    31.045
  -115.519    31.524
>
  -115.464    31.045
  -115.519    31.524
>
  -115.464    31.045
  -115.519    31.524
>
  -115.464    31.045
  -115.519    31.524
>
  -116.273    31.514
  -115.849    31.571
>
  -116.273    31.514
  -115.849    31.571
>
  -115.466    31.046
  -115.849    31.571
>
  -115.466    31.046
  -115.849    31.571
>
  -115.466    31.046
  -115.849    31.571
>
  -115.466    31.046
  -115.849    31.571
>
  -115.464    31.045
  -115.849    31.571
>
  -115.464    31.045
  -115.849    31.571
>
  -115.464    31.045
  -115.849    31.571
>
  -116.598    31.657
  -115.849    31.571
>
  -115.051    31.472
  -115.849    31.571
>
  -115.051    31.472
  -115.849    31.571
>
  -116.725    31.742
  -115.849    31.571
>
  -116.273    31.514
  -115.921    31.685
>
  -116.273    31.514
  -115.921    31.685
>
  -116.598    31.657
  -115.921    31.685
>
  -116.725    31.742
  -115.921    31.685
>
  -115.466    31.046
  -115.921    31.685
>
  -115.466    31.046
  -115.921    31.685
>
  -115.464    31.045
  -115.921    31.685
>
  -115.464    31.045
  -115.921    31.685
>
  -115.464    31.045
  -115.921    31.685
>
  -115.051    31.472
  -115.921    31.685
>
  -115.051    31.472
  -115.921    31.685
>
  -115.051    31.472
  -115.622    31.576
>
  -115.051    31.472
  -115.622    31.576
>
  -115.466    31.046
  -115.622    31.576
>
  -115.466    31.046
  -115.622    31.576
>
  -115.466    31.046
  -115.622    31.576
>
  -115.464    31.045
  -115.622    31.576
>
  -115.464    31.045
  -115.622    31.576
>
  -116.273    31.514
  -115.622    31.576
>
  -116.273    31.514
  -115.918    31.685
>
  -116.273    31.514
  -115.918    31.685
>
  -116.598    31.657
  -115.918    31.685
>
  -116.598    31.657
  -115.918    31.685
>
  -116.725    31.742
  -115.918    31.685
>
  -116.725    31.742
  -115.918    31.685
>
  -115.466    31.046
  -115.918    31.685
>
  -115.466    31.046
  -115.918    31.685
>
  -115.466    31.046
  -115.918    31.685
>
  -115.464    31.045
  -115.918    31.685
>
  -115.464    31.045
  -115.918    31.685
>
  -115.464    31.045
  -115.918    31.685
>
  -115.464    31.045
  -115.918    31.685
>
  -116.273    31.514
  -115.937    31.231
>
  -115.466    31.046
  -115.937    31.231
>
  -115.466    31.046
  -115.937    31.231
>
  -115.466    31.046
  -115.937    31.231
>
  -115.466    31.046
  -115.937    31.231
>
  -115.464    31.045
  -115.937    31.231
>
  -115.464    31.045
  -115.937    31.231
>
  -115.464    31.045
  -115.937    31.231
>
  -115.464    31.045
  -115.937    31.231
>
  -116.598    31.657
  -115.937    31.231
>
  -115.051    31.472
  -115.937    31.231
>
  -115.466    31.046
  -115.933    31.248
>
  -115.466    31.046
  -115.933    31.248
>
  -115.464    31.045
  -115.933    31.248
>
  -115.464    31.045
  -115.933    31.248
>
  -115.464    31.045
  -115.933    31.248
>
  -115.464    31.045
  -115.933    31.248
>
  -115.464    31.045
  -115.933    31.248
>
  -116.598    31.657
  -115.933    31.248
>
  -116.598    31.657
  -115.933    31.248
>
  -116.273    31.514
  -116.139    31.580
>
  -116.273    31.514
  -116.139    31.580
>
  -116.598    31.657
  -116.139    31.580
>
  -116.598    31.657
  -116.139    31.580
>
  -116.725    31.742
  -116.139    31.580
>
  -116.725    31.742
  -116.139    31.580
>
  -115.466    31.046
  -116.139    31.580
>
  -115.466    31.046
  -116.139    31.580
>
  -115.466    31.046
  -116.139    31.580
>
  -115.464    31.045
  -116.139    31.580
>
  -115.464    31.045
  -116.139    31.580
>
  -115.464    31.045
  -116.139    31.580
>
  -115.466    31.046
  -115.915    31.239
>
  -115.466    31.046
  -115.915    31.239
>
  -115.464    31.045
  -115.915    31.239
>
  -115.464    31.045
  -115.915    31.239
>
  -115.464    31.045
  -115.915    31.239
>
  -115.464    31.045
  -115.915    31.239
>
  -115.464    31.045
  -115.915    31.239
>
  -115.876    30.576
  -115.915    31.239
>
  -115.948    32.005
  -115.915    31.239
>
  -115.948    32.005
  -115.915    31.239
>
  -115.948    32.005
  -115.915    31.239
>
  -115.466    31.046
  -115.507    31.555
>
  -115.466    31.046
  -115.507    31.555
>
  -115.466    31.046
  -115.507    31.555
>
  -115.464    31.045
  -115.507    31.555
>
  -115.464    31.045
  -115.507    31.555
>
  -115.464    31.045
  -115.507    31.555
>
  -115.948    32.005
  -115.507    31.555
>
  -115.948    32.005
  -115.507    31.555
>
  -115.948    32.005
  -115.507    31.555
>
  -115.466    31.046
  -115.412    31.109
>
  -115.466    31.046
  -115.412    31.109
>
  -115.466    31.046
  -115.412    31.109
>
  -115.464    31.045
  -115.412    31.109
>
  -115.464    31.045
  -115.412    31.109
>
  -115.464    31.045
  -115.412    31.109
>
  -115.784    31.391
  -115.412    31.109
>
  -115.784    31.391
  -115.412    31.109
>
  -115.876    30.576
  -115.412    31.109
>
  -115.876    30.576
  -115.412    31.109
>
  -115.466    31.046
  -115.509    31.535
>
  -115.466    31.046
  -115.509    31.535
>
  -115.466    31.046
  -115.509    31.535
>
  -115.466    31.046
  -115.509    31.535
>
  -115.464    31.045
  -115.509    31.535
>
  -115.464    31.045
  -115.509    31.535
>
  -115.464    31.045
  -115.509    31.535
>
  -115.948    32.005
  -115.509    31.535
>
  -115.948    32.005
  -115.509    31.535
>
  -115.948    32.005
  -115.509    31.535
>
  -115.051    31.472
  -115.480    31.561
>
  -115.466    31.046
  -115.480    31.561
>
  -115.466    31.046
  -115.480    31.561
>
  -115.466    31.046
  -115.480    31.561
>
  -115.464    31.045
  -115.480    31.561
>
  -115.464    31.045
  -115.480    31.561
>
  -115.464    31.045
  -115.480    31.561
>
  -115.948    32.005
  -115.480    31.561
>
  -115.948    32.005
  -115.480    31.561
>
  -116.251    31.327
  -115.480    31.561
>
  -116.251    31.327
  -115.480    31.561
>
  -115.051    31.472
  -115.487    31.551
>
  -115.051    31.472
  -115.487    31.551
>
  -115.466    31.046
  -115.487    31.551
>
  -115.466    31.046
  -115.487    31.551
>
  -115.464    31.045
  -115.487    31.551
>
  -115.464    31.045
  -115.487    31.551
>
  -115.464    31.045
  -115.487    31.551
>
  -115.948    32.005
  -115.487    31.551
>
  -115.948    32.005
  -115.487    31.551
>
  -115.948    32.005
  -115.487    31.551
>
  -115.948    32.005
  -115.487    31.551
>
  -116.251    31.327
  -115.487    31.551
>
  -116.251    31.327
  -115.487    31.551
>
  -115.051    31.472
  -115.495    31.545
>
  -115.051    31.472
  -115.495    31.545
>
  -115.466    31.046
  -115.495    31.545
>
  -115.466    31.046
  -115.495    31.545
>
  -115.466    31.046
  -115.495    31.545
>
  -115.464    31.045
  -115.495    31.545
>
  -115.464    31.045
  -115.495    31.545
>
  -115.464    31.045
  -115.495    31.545
>
  -115.948    32.005
  -115.495    31.545
>
  -115.948    32.005
  -115.495    31.545
>
  -116.251    31.327
  -115.495    31.545
>
  -116.251    31.327
  -115.495    31.545
>
  -116.251    31.327
  -115.932    31.238
>
  -116.251    31.327
  -115.932    31.238
>
  -115.466    31.046
  -115.932    31.238
>
  -115.466    31.046
  -115.932    31.238
>
  -115.466    31.046
  -115.932    31.238
>
  -115.466    31.046
  -115.932    31.238
>
  -115.464    31.045
  -115.932    31.238
>
  -115.464    31.045
  -115.932    31.238
>
  -115.464    31.045
  -115.932    31.238
>
  -115.876    30.576
  -115.932    31.238
>
  -115.876    30.576
  -115.932    31.238
>
  -115.948    32.005
  -115.932    31.238
>
  -115.948    32.005
  -115.932    31.238
>
  -115.051    31.472
  -115.932    31.238
>
  -115.051    31.472
  -115.932    31.238
>
  -115.948    32.005
  -116.201    31.834
>
  -115.948    32.005
  -116.201    31.834
>
  -116.663    31.868
  -116.201    31.834
>
  -116.663    31.868
  -116.201    31.834
>
  -116.251    31.327
  -116.201    31.834
>
  -116.251    31.327
  -116.201    31.834
>
  -116.664    32.313
  -116.201    31.834
>
  -116.664    32.313
  -116.201    31.834
>
  -116.664    32.313
  -116.201    31.834
>
  -116.675    32.433
  -116.201    31.834
>
  -116.675    32.433
  -116.201    31.834
>
  -116.675    32.433
  -116.201    31.834
>
  -116.675    32.433
  -116.201    31.834
>
  -116.029    32.553
  -116.201    31.834
>
  -116.029    32.553
  -116.201    31.834
>
  -116.029    32.553
  -116.201    31.834
>
  -115.051    31.472
  -115.470    31.498
>
  -115.051    31.472
  -115.470    31.498
>
  -115.464    31.045
  -115.470    31.498
>
  -115.464    31.045
  -115.470    31.498
>
  -115.464    31.045
  -115.470    31.498
>
  -115.464    31.045
  -115.470    31.498
>
  -115.464    31.045
  -115.470    31.498
>
  -115.948    32.005
  -115.470    31.498
>
  -115.948    32.005
  -115.470    31.498
>
  -115.948    32.005
  -115.470    31.498
>
  -116.663    31.868
  -116.252    31.760
>
  -116.663    31.868
  -116.252    31.760
>
  -116.663    31.868
  -116.252    31.760
>
  -115.948    32.005
  -116.252    31.760
>
  -115.948    32.005
  -116.252    31.760
>
  -115.948    32.005
  -116.252    31.760
>
  -115.948    32.005
  -116.252    31.760
>
  -116.664    32.313
  -116.252    31.760
>
  -116.664    32.313
  -116.252    31.760
>
  -116.251    31.327
  -115.934    31.241
>
  -116.251    31.327
  -115.934    31.241
>
  -115.466    31.046
  -115.934    31.241
>
  -115.466    31.046
  -115.934    31.241
>
  -115.464    31.045
  -115.934    31.241
>
  -115.464    31.045
  -115.934    31.241
>
  -115.464    31.045
  -115.934    31.241
>
  -115.948    32.005
  -115.934    31.241
>
  -115.948    32.005
  -115.934    31.241
>
  -115.876    30.576
  -115.934    31.241
>
  -115.876    30.576
  -115.934    31.241
>
  -115.051    31.472
  -115.934    31.241
>
  -115.051    31.472
  -115.934    31.241
>
  -115.784    31.391
  -115.492    31.484
>
  -115.784    31.391
  -115.492    31.484
>
  -115.784    31.391
  -115.492    31.484
>
  -115.051    31.472
  -115.492    31.484
>
  -115.051    31.472
  -115.492    31.484
>
  -115.466    31.046
  -115.492    31.484
>
  -115.464    31.045
  -115.492    31.484
>
  -115.464    31.045
  -115.492    31.484
>
  -115.464    31.045
  -115.492    31.484
>
  -115.464    31.045
  -115.492    31.484
>
  -116.251    31.327
  -115.492    31.484
>
  -116.251    31.327
  -115.492    31.484
>
  -115.784    31.391
  -115.594    31.567
>
  -115.784    31.391
  -115.594    31.567
>
  -115.784    31.391
  -115.594    31.567
>
  -115.948    32.005
  -115.594    31.567
>
  -115.948    32.005
  -115.594    31.567
>
  -115.466    31.046
  -115.594    31.567
>
  -115.466    31.046
  -115.594    31.567
>
  -115.464    31.045
  -115.594    31.567
>
  -115.464    31.045
  -115.594    31.567
>
  -115.464    31.045
  -115.594    31.567
>
  -116.251    31.327
  -115.594    31.567
>
  -115.784    31.391
  -115.317    31.435
>
  -115.784    31.391
  -115.317    31.435
>
  -115.784    31.391
  -115.317    31.435
>
  -115.466    31.046
  -115.317    31.435
>
  -115.466    31.046
  -115.317    31.435
>
  -115.466    31.046
  -115.317    31.435
>
  -115.466    31.046
  -115.317    31.435
>
  -115.464    31.045
  -115.317    31.435
>
  -115.464    31.045
  -115.317    31.435
>
  -115.948    32.005
  -115.317    31.435
>
  -115.948    32.005
  -115.317    31.435
>
  -115.948    32.005
  -115.676    31.799
>
  -115.948    32.005
  -115.676    31.799
>
  -115.784    31.391
  -115.676    31.799
>
  -115.784    31.391
  -115.676    31.799
>
  -115.051    31.472
  -115.676    31.799
>
  -115.051    31.472
  -115.676    31.799
>
  -115.304    32.418
  -115.676    31.799
>
  -115.304    32.418
  -115.676    31.799
>
  -115.076    32.303
  -115.676    31.799
>
  -115.466    31.046
  -115.676    31.799
>
  -115.466    31.046
  -115.676    31.799
>
  -115.466    31.046
  -115.676    31.799
>
  -115.466    31.046
  -115.676    31.799
>
  -115.464    31.045
  -115.676    31.799
>
  -115.464    31.045
  -115.676    31.799
>
  -115.784    31.391
  -115.627    31.533
>
  -115.784    31.391
  -115.627    31.533
>
  -115.784    31.391
  -115.627    31.533
>
  -115.051    31.472
  -115.627    31.533
>
  -115.051    31.472
  -115.627    31.533
>
  -115.466    31.046
  -115.627    31.533
>
  -115.466    31.046
  -115.627    31.533
>
  -115.466    31.046
  -115.627    31.533
>
  -115.464    31.045
  -115.627    31.533
>
  -115.464    31.045
  -115.627    31.533
>
  -115.948    32.005
  -115.627    31.533
>
  -115.948    32.005
  -115.627    31.533
>
  -116.251    31.327
  -115.627    31.533
>
  -116.251    31.327
  -115.627    31.533
>
  -115.784    31.391
  -115.637    31.521
>
  -115.784    31.391
  -115.637    31.521
>
  -115.466    31.046
  -115.637    31.521
>
  -115.466    31.046
  -115.637    31.521
>
  -115.466    31.046
  -115.637    31.521
>
  -115.466    31.046
  -115.637    31.521
>
  -115.051    31.472
  -115.637    31.521
>
  -115.051    31.472
  -115.637    31.521
>
  -115.464    31.045
  -115.637    31.521
>
  -115.464    31.045
  -115.637    31.521
>
  -115.464    31.045
  -115.637    31.521
>
  -115.948    32.005
  -115.637    31.521
>
  -115.948    32.005
  -115.637    31.521
>
  -116.251    31.327
  -115.637    31.521
>
  -116.251    31.327
  -115.637    31.521
>
  -115.784    31.391
  -115.640    31.519
>
  -115.784    31.391
  -115.640    31.519
>
  -115.466    31.046
  -115.640    31.519
>
  -115.466    31.046
  -115.640    31.519
>
  -115.466    31.046
  -115.640    31.519
>
  -115.466    31.046
  -115.640    31.519
>
  -115.464    31.045
  -115.640    31.519
>
  -115.464    31.045
  -115.640    31.519
>
  -115.464    31.045
  -115.640    31.519
>
  -115.464    31.045
  -115.640    31.519
>
  -115.464    31.045
  -115.640    31.519
>
  -115.051    31.472
  -115.640    31.519
>
  -116.251    31.327
  -115.640    31.519
>
  -116.251    31.327
  -115.640    31.519
>
  -115.948    32.005
  -115.640    31.519
>
  -115.948    32.005
  -115.640    31.519
>
  -115.784    31.391
  -115.636    31.520
>
  -115.784    31.391
  -115.636    31.520
>
  -115.784    31.391
  -115.636    31.520
>
  -115.466    31.046
  -115.636    31.520
>
  -115.466    31.046
  -115.636    31.520
>
  -115.466    31.046
  -115.636    31.520
>
  -115.464    31.045
  -115.636    31.520
>
  -115.464    31.045
  -115.636    31.520
>
  -115.464    31.045
  -115.636    31.520
>
  -115.051    31.472
  -115.636    31.520
>
  -115.948    32.005
  -115.636    31.520
>
  -115.948    32.005
  -115.636    31.520
>
  -116.251    31.327
  -115.636    31.520
>
  -116.251    31.327
  -115.636    31.520
>
  -115.784    31.391
  -115.921    31.639
>
  -115.784    31.391
  -115.921    31.639
>
  -115.784    31.391
  -115.921    31.639
>
  -115.948    32.005
  -115.921    31.639
>
  -115.948    32.005
  -115.921    31.639
>
  -116.251    31.327
  -115.921    31.639
>
  -116.251    31.327
  -115.921    31.639
>
  -116.663    31.868
  -115.921    31.639
>
  -116.663    31.868
  -115.921    31.639
>
  -115.466    31.046
  -115.921    31.639
>
  -115.466    31.046
  -115.921    31.639
>
  -115.466    31.046
  -115.921    31.639
>
  -115.466    31.046
  -115.921    31.639
>
  -115.464    31.045
  -115.921    31.639
>
  -115.464    31.045
  -115.921    31.639
>
  -115.464    31.045
  -115.921    31.639
>
  -115.051    31.472
  -115.921    31.639
>
  -116.251    31.327
  -115.889    31.226
>
  -116.251    31.327
  -115.889    31.226
>
  -115.784    31.391
  -115.889    31.226
>
  -115.784    31.391
  -115.889    31.226
>
  -115.466    31.046
  -115.889    31.226
>
  -115.466    31.046
  -115.889    31.226
>
  -115.466    31.046
  -115.889    31.226
>
  -115.466    31.046
  -115.889    31.226
>
  -115.464    31.045
  -115.889    31.226
>
  -115.464    31.045
  -115.889    31.226
>
  -115.464    31.045
  -115.889    31.226
>
  -115.051    31.472
  -115.889    31.226
>
  -115.051    31.472
  -115.889    31.226
>
  -115.948    32.005
  -115.889    31.226
>
  -115.948    32.005
  -115.889    31.226
>
  -115.051    31.472
  -115.632    31.553
>
  -115.051    31.472
  -115.632    31.553
>
  -115.466    31.046
  -115.632    31.553
>
  -115.466    31.046
  -115.632    31.553
>
  -115.466    31.046
  -115.632    31.553
>
  -115.466    31.046
  -115.632    31.553
>
  -115.464    31.045
  -115.632    31.553
>
  -115.464    31.045
  -115.632    31.553
>
  -115.464    31.045
  -115.632    31.553
>
  -116.251    31.327
  -115.632    31.553
>
  -116.251    31.327
  -115.632    31.553
>
  -115.466    31.046
  -115.414    31.306
>
  -115.466    31.046
  -115.414    31.306
>
  -115.464    31.045
  -115.414    31.306
>
  -115.464    31.045
  -115.414    31.306
>
  -115.464    31.045
  -115.414    31.306
>
  -115.051    31.472
  -115.414    31.306
>
  -115.051    31.472
  -115.414    31.306
>
  -116.251    31.327
  -115.414    31.306
>
  -116.251    31.327
  -115.414    31.306
>
  -116.251    31.327
  -115.449    31.305
>
  -116.251    31.327
  -115.449    31.305
>
  -116.251    31.327
  -115.987    31.629
>
  -116.251    31.327
  -115.987    31.629
>
  -116.663    31.868
  -115.987    31.629
>
  -116.663    31.868
  -115.987    31.629
>
  -116.663    31.868
  -115.987    31.629
>
  -116.663    31.868
  -115.987    31.629
>
  -115.466    31.046
  -115.491    31.528
>
  -115.466    31.046
  -115.491    31.528
>
  -115.466    31.046
  -115.491    31.528
>
  -116.251    31.327
  -115.491    31.528
>
  -116.251    31.327
  -115.491    31.528
>
  -116.663    31.868
  -116.188    31.865
>
  -116.663    31.868
  -116.188    31.865
>
  -116.663    31.868
  -116.188    31.865
>
  -116.251    31.327
  -116.188    31.865
>
  -116.251    31.327
  -116.188    31.865
>
  -116.251    31.327
  -116.188    31.865
>
  -116.251    31.327
  -116.188    31.865
>
  -116.664    32.313
  -116.188    31.865
>
  -116.664    32.313
  -116.188    31.865
>
  -116.675    32.433
  -116.188    31.865
>
  -116.675    32.433
  -116.188    31.865
>
  -116.109    32.650
  -116.188    31.865
>
  -116.109    32.650
  -116.188    31.865
>
  -116.607    32.569
  -116.188    31.865
>
  -116.607    32.569
  -116.188    31.865
>
  -116.607    32.569
  -116.188    31.865
>
  -116.251    31.327
  -115.680    30.811
>
  -116.251    31.327
  -115.680    30.811
>
  -115.708    32.007
  -115.587    31.586
>
  -115.708    32.007
  -115.587    31.586
>
  -115.708    32.007
  -115.587    31.586
>
  -115.051    31.472
  -115.587    31.586
>
  -115.051    31.472
  -115.587    31.586
>
  -115.466    31.046
  -115.587    31.586
>
  -115.466    31.046
  -115.587    31.586
>
  -116.251    31.327
  -116.086    31.228
>
  -116.251    31.327
  -116.086    31.228
>
  -116.251    31.327
  -116.086    31.228
>
  -115.466    31.046
  -116.086    31.228
>
  -115.466    31.046
  -116.086    31.228
>
  -115.466    31.046
  -116.086    31.228
>
  -115.948    32.005
  -116.053    31.769
>
  -115.948    32.005
  -116.053    31.769
>
  -115.784    31.391
  -116.053    31.769
>
  -115.784    31.391
  -116.053    31.769
>
  -115.784    31.391
  -116.053    31.769
>
  -116.251    31.327
  -116.053    31.769
>
  -116.663    31.868
  -116.053    31.769
>
  -116.663    31.868
  -116.053    31.769
>
  -116.663    31.868
  -116.053    31.769
>
  -116.664    32.313
  -116.053    31.769
>
  -116.664    32.313
  -116.053    31.769
>
  -115.284    32.135
  -116.053    31.769
>
  -115.284    32.135
  -116.053    31.769
>
  -115.284    32.135
  -116.053    31.769
>
  -115.284    32.135
  -116.053    31.769
>
  -115.466    31.046
  -115.329    31.265
>
  -115.466    31.046
  -115.329    31.265
>
  -115.466    31.046
  -115.329    31.265
>
  -115.784    31.391
  -115.329    31.265
>
  -115.784    31.391
  -115.329    31.265
>
  -115.784    31.391
  -115.329    31.265
>
  -115.784    31.391
  -115.329    31.265
>
  -115.948    32.005
  -116.105    31.801
>
  -115.948    32.005
  -116.105    31.801
>
  -116.663    31.868
  -116.105    31.801
>
  -116.663    31.868
  -116.105    31.801
>
  -116.663    31.868
  -116.105    31.801
>
  -116.663    31.868
  -116.105    31.801
>
  -116.663    31.868
  -116.105    31.801
>
  -116.251    31.327
  -116.105    31.801
>
  -116.251    31.327
  -116.105    31.801
>
  -115.784    31.391
  -116.105    31.801
>
  -115.784    31.391
  -116.105    31.801
>
  -115.784    31.391
  -116.105    31.801
>
  -116.664    32.313
  -116.105    31.801
>
  -116.664    32.313
  -116.105    31.801
>
  -116.664    32.313
  -116.105    31.801
>
  -116.675    32.433
  -116.105    31.801
>
  -116.675    32.433
  -116.105    31.801
>
  -116.675    32.433
  -116.105    31.801
>
  -115.284    32.135
  -116.105    31.801
>
  -115.284    32.135
  -116.105    31.801
>
  -115.948    32.005
  -116.104    31.801
>
  -116.663    31.868
  -116.104    31.801
>
  -116.663    31.868
  -116.104    31.801
>
  -116.663    31.868
  -116.104    31.801
>
  -116.663    31.868
  -116.104    31.801
>
  -116.251    31.327
  -116.104    31.801
>
  -116.251    31.327
  -116.104    31.801
>
  -115.784    31.391
  -116.104    31.801
>
  -115.784    31.391
  -116.104    31.801
>
  -115.784    31.391
  -116.104    31.801
>
  -116.664    32.313
  -116.104    31.801
>
  -116.664    32.313
  -116.104    31.801
>
  -116.664    32.313
  -116.104    31.801
>
  -116.664    32.313
  -116.104    31.801
>
  -115.284    32.135
  -116.104    31.801
>
  -115.284    32.135
  -116.104    31.801
>
  -116.675    32.433
  -116.104    31.801
>
  -116.675    32.433
  -116.104    31.801
>
  -116.675    32.433
  -116.104    31.801
>
  -115.784    31.391
  -116.013    31.615
>
  -115.784    31.391
  -116.013    31.615
>
  -115.784    31.391
  -116.013    31.615
>
  -115.784    31.391
  -116.013    31.615
>
  -116.251    31.327
  -116.013    31.615
>
  -116.251    31.327
  -116.013    31.615
>
  -115.948    32.005
  -116.013    31.615
>
  -115.948    32.005
  -116.013    31.615
>
  -116.663    31.868
  -116.013    31.615
>
  -116.663    31.868
  -116.013    31.615
>
  -116.663    31.868
  -116.013    31.615
>
  -115.466    31.046
  -116.013    31.615
>
  -115.466    31.046
  -116.013    31.615
>
  -115.466    31.046
  -116.013    31.615
>
  -115.784    31.391
  -115.667    31.264
>
  -115.784    31.391
  -115.667    31.264
>
  -115.784    31.391
  -115.667    31.264
>
  -115.466    31.046
  -115.667    31.264
>
  -115.466    31.046
  -115.667    31.264
>
  -115.466    31.046
  -115.667    31.264
>
  -115.466    31.046
  -115.667    31.264
>
  -115.466    31.046
  -115.667    31.264
>
  -116.251    31.327
  -115.667    31.264
>
  -116.251    31.327
  -115.667    31.264
>
  -115.051    31.472
  -115.667    31.264
>
  -115.051    31.472
  -115.667    31.264
>
  -115.051    31.472
  -115.667    31.264
>
  -115.876    30.576
  -115.667    31.264
>
  -115.876    30.576
  -115.667    31.264
>
  -115.948    32.005
  -115.667    31.264
>
  -115.948    32.005
  -115.667    31.264
>
  -115.466    31.046
  -115.373    31.344
>
  -115.466    31.046
  -115.373    31.344
>
  -115.466    31.046
  -115.373    31.344
>
  -115.784    31.391
  -115.373    31.344
>
  -115.784    31.391
  -115.373    31.344
>
  -115.784    31.391
  -115.373    31.344
>
  -115.708    32.007
  -115.373    31.344
>
  -115.708    32.007
  -115.373    31.344
>
  -116.238    31.340
  -115.373    31.344
>
  -115.784    31.391
  -115.990    31.615
>
  -115.784    31.391
  -115.990    31.615
>
  -115.784    31.391
  -115.990    31.615
>
  -116.238    31.340
  -115.990    31.615
>
  -116.238    31.340
  -115.990    31.615
>
  -115.948    32.005
  -115.990    31.615
>
  -115.948    32.005
  -115.990    31.615
>
  -115.708    32.007
  -115.990    31.615
>
  -115.708    32.007
  -115.990    31.615
>
  -115.708    32.007
  -115.990    31.615
>
  -116.663    31.868
  -115.990    31.615
>
  -116.663    31.868
  -115.990    31.615
>
  -116.663    31.868
  -115.990    31.615
>
  -116.663    31.868
  -115.990    31.615
>
  -116.725    31.742
  -115.990    31.615
>
  -116.725    31.742
  -115.990    31.615
>
  -115.466    31.046
  -115.990    31.615
>
  -115.466    31.046
  -115.990    31.615
>
  -115.284    32.135
  -115.990    31.615
>
  -115.284    32.135
  -115.990    31.615
>
  -115.948    32.005
  -116.109    31.849
>
  -115.948    32.005
  -116.109    31.849
>
  -115.708    32.007
  -116.109    31.849
>
  -115.708    32.007
  -116.109    31.849
>
  -116.663    31.868
  -116.109    31.849
>
  -116.663    31.868
  -116.109    31.849
>
  -116.663    31.868
  -116.109    31.849
>
  -116.663    31.868
  -116.109    31.849
>
  -116.725    31.742
  -116.109    31.849
>
  -116.725    31.742
  -116.109    31.849
>
  -116.238    31.340
  -116.109    31.849
>
  -116.238    31.340
  -116.109    31.849
>
  -115.784    31.391
  -116.109    31.849
>
  -115.784    31.391
  -116.109    31.849
>
  -115.784    31.391
  -116.109    31.849
>
  -115.784    31.391
  -116.109    31.849
>
  -115.784    31.391
  -116.109    31.849
>
  -116.664    32.313
  -116.109    31.849
>
  -116.664    32.313
  -116.109    31.849
>
  -116.664    32.313
  -116.109    31.849
>
  -116.664    32.313
  -116.109    31.849
>
  -116.675    32.433
  -116.109    31.849
>
  -116.675    32.433
  -116.109    31.849
>
  -116.675    32.433
  -116.109    31.849
>
  -115.284    32.135
  -116.109    31.849
>
  -115.284    32.135
  -116.109    31.849
>
  -116.109    32.650
  -116.109    31.849
>
  -116.109    32.650
  -116.109    31.849
>
  -115.784    31.391
  -115.811    31.619
>
  -115.784    31.391
  -115.811    31.619
>
  -115.784    31.391
  -115.811    31.619
>
  -115.784    31.391
  -115.811    31.619
>
  -115.948    32.005
  -115.811    31.619
>
  -115.948    32.005
  -115.811    31.619
>
  -116.238    31.340
  -115.811    31.619
>
  -116.238    31.340
  -115.811    31.619
>
  -115.466    31.046
  -115.811    31.619
>
  -115.466    31.046
  -115.811    31.619
>
  -115.466    31.046
  -115.811    31.619
>
  -115.051    31.472
  -115.811    31.619
>
  -115.051    31.472
  -115.811    31.619
>
  -115.284    32.135
  -115.811    31.619
>
  -116.663    31.868
  -115.811    31.619
>
  -116.663    31.868
  -115.811    31.619
>
  -116.725    31.742
  -115.811    31.619
>
  -116.725    31.742
  -115.811    31.619
>
  -116.725    31.742
  -115.811    31.619
>
  -115.466    31.046
  -115.252    30.966
>
  -115.466    31.046
  -115.252    30.966
>
  -115.466    31.046
  -115.252    30.966
>
  -115.466    31.046
  -115.252    30.966
>
  -115.051    31.472
  -115.252    30.966
>
  -115.051    31.472
  -115.252    30.966
>
  -115.876    30.576
  -115.252    30.966
>
  -115.876    30.576
  -115.252    30.966
>
  -115.876    30.576
  -115.252    30.966
>
  -115.876    30.576
  -115.252    30.966
>
  -115.784    31.391
  -115.252    30.966
>
  -115.784    31.391
  -115.252    30.966
>
  -115.784    31.391
  -115.252    30.966
>
  -115.948    32.005
  -116.101    31.805
>
  -115.948    32.005
  -116.101    31.805
>
  -115.708    32.007
  -116.101    31.805
>
  -115.708    32.007
  -116.101    31.805
>
  -115.708    32.007
  -116.101    31.805
>
  -116.238    31.340
  -116.101    31.805
>
  -116.238    31.340
  -116.101    31.805
>
  -116.238    31.340
  -116.101    31.805
>
  -116.238    31.340
  -116.101    31.805
>
  -116.663    31.868
  -116.101    31.805
>
  -116.663    31.868
  -116.101    31.805
>
  -116.663    31.868
  -116.101    31.805
>
  -116.663    31.868
  -116.101    31.805
>
  -115.784    31.391
  -116.101    31.805
>
  -115.784    31.391
  -116.101    31.805
>
  -115.784    31.391
  -116.101    31.805
>
  -116.725    31.742
  -116.101    31.805
>
  -116.725    31.742
  -116.101    31.805
>
  -116.725    31.742
  -116.101    31.805
>
  -116.664    32.313
  -116.101    31.805
>
  -116.664    32.313
  -116.101    31.805
>
  -116.664    32.313
  -116.101    31.805
>
  -115.284    32.135
  -116.101    31.805
>
  -116.675    32.433
  -116.101    31.805
>
  -116.675    32.433
  -116.101    31.805
>
  -115.784    31.391
  -115.591    31.522
>
  -115.784    31.391
  -115.591    31.522
>
  -115.784    31.391
  -115.591    31.522
>
  -115.784    31.391
  -115.591    31.522
>
  -115.051    31.472
  -115.591    31.522
>
  -115.051    31.472
  -115.591    31.522
>
  -115.708    32.007
  -115.591    31.522
>
  -115.708    32.007
  -115.591    31.522
>
  -115.708    32.007
  -115.591    31.522
>
  -115.466    31.046
  -115.591    31.522
>
  -115.466    31.046
  -115.591    31.522
>
  -115.948    32.005
  -115.591    31.522
>
  -115.948    32.005
  -115.591    31.522
>
  -116.238    31.340
  -115.591    31.522
>
  -116.238    31.340
  -115.591    31.522
>
  -115.284    32.135
  -115.591    31.522
>
  -115.284    32.135
  -115.591    31.522
>
  -116.301    32.020
  -116.281    31.942
>
  -116.301    32.020
  -116.281    31.942
>
  -115.948    32.005
  -116.281    31.942
>
  -115.948    32.005
  -116.281    31.942
>
  -116.663    31.868
  -116.281    31.942
>
  -116.663    31.868
  -116.281    31.942
>
  -116.663    31.868
  -116.281    31.942
>
  -116.663    31.868
  -116.281    31.942
>
  -116.663    31.868
  -116.281    31.942
>
  -115.816    31.871
  -116.281    31.942
>
  -115.816    31.871
  -116.281    31.942
>
  -116.725    31.742
  -116.281    31.942
>
  -116.725    31.742
  -116.281    31.942
>
  -116.725    31.742
  -116.281    31.942
>
  -115.841    32.116
  -116.281    31.942
>
  -115.841    32.116
  -116.281    31.942
>
  -116.664    32.313
  -116.281    31.942
>
  -116.664    32.313
  -116.281    31.942
>
  -115.708    32.007
  -116.281    31.942
>
  -115.708    32.007
  -116.281    31.942
>
  -116.238    31.340
  -116.281    31.942
>
  -116.675    32.433
  -116.281    31.942
>
  -116.675    32.433
  -116.281    31.942
>
  -116.675    32.433
  -116.281    31.942
>
  -116.675    32.433
  -116.281    31.942
>
  -116.607    32.569
  -116.281    31.942
>
  -116.607    32.569
  -116.281    31.942
>
  -115.784    31.391
  -116.281    31.942
>
  -115.784    31.391
  -116.281    31.942
>
  -115.784    31.391
  -116.281    31.942
>
  -115.784    31.391
  -116.281    31.942
>
  -116.109    32.650
  -116.281    31.942
>
  -116.109    32.650
  -116.281    31.942
>
  -116.109    32.650
  -116.281    31.942
>
  -115.923    32.648
  -116.281    31.942
>
  -115.922    32.647
  -116.281    31.942
>
  -116.775    32.607
  -116.281    31.942
>
  -115.708    32.007
  -115.808    31.906
>
  -115.708    32.007
  -115.808    31.906
>
  -115.948    32.005
  -115.808    31.906
>
  -115.841    32.116
  -115.808    31.906
>
  -115.841    32.116
  -115.808    31.906
>
  -116.099    31.857
  -115.808    31.906
>
  -116.099    31.857
  -115.808    31.906
>
  -116.301    32.020
  -115.808    31.906
>
  -116.301    32.020
  -115.808    31.906
>
  -115.784    31.391
  -115.808    31.906
>
  -115.784    31.391
  -115.808    31.906
>
  -115.784    31.391
  -115.808    31.906
>
  -115.784    31.391
  -115.808    31.906
>
  -115.784    31.391
  -115.808    31.906
>
  -115.581    32.537
  -115.808    31.906
>
  -115.581    32.537
  -115.808    31.906
>
  -115.304    32.418
  -115.808    31.906
>
  -116.238    31.340
  -115.808    31.906
>
  -115.198    32.407
  -115.808    31.906
>
  -115.198    32.407
  -115.808    31.906
>
  -115.198    32.407
  -115.808    31.906
>
  -116.663    31.868
  -115.808    31.906
>
  -116.663    31.868
  -115.808    31.906
>
  -116.663    31.868
  -115.808    31.906
>
  -116.663    31.868
  -115.808    31.906
>
  -115.076    32.303
  -115.808    31.906
>
  -115.725    32.649
  -115.808    31.906
>
  -115.725    32.649
  -115.808    31.906
>
  -115.923    32.648
  -115.808    31.906
>
  -115.923    32.648
  -115.808    31.906
>
  -115.922    32.647
  -115.808    31.906
>
  -114.961    32.166
  -115.808    31.906
>
  -115.051    31.472
  -115.808    31.906
>
  -116.109    32.650
  -115.808    31.906
>
  -116.109    32.650
  -115.808    31.906
>
  -115.445    32.632
  -115.808    31.906
>
  -115.145    32.473
  -115.808    31.906
>
  -116.725    31.742
  -115.808    31.906
>
  -115.948    32.005
  -115.817    31.908
>
  -115.948    32.005
  -115.817    31.908
>
  -115.784    31.391
  -115.817    31.908
>
  -115.784    31.391
  -115.817    31.908
>
  -115.304    32.418
  -115.817    31.908
>
  -115.198    32.407
  -115.817    31.908
>
  -115.198    32.407
  -115.817    31.908
>
  -115.198    32.407
  -115.817    31.908
>
  -115.725    32.649
  -115.817    31.908
>
  -115.725    32.649
  -115.817    31.908
>
  -116.663    31.868
  -115.817    31.908
>
  -115.923    32.648
  -115.817    31.908
>
  -115.923    32.648
  -115.817    31.908
>
  -115.445    32.632
  -115.817    31.908
>
  -116.109    32.650
  -115.817    31.908
>
  -116.109    32.650
  -115.817    31.908
>
  -115.948    32.005
  -115.818    31.909
>
  -115.708    32.007
  -115.818    31.909
>
  -115.708    32.007
  -115.818    31.909
>
  -115.708    32.007
  -115.818    31.909
>
  -116.301    32.020
  -115.818    31.909
>
  -116.301    32.020
  -115.818    31.909
>
  -115.784    31.391
  -115.818    31.909
>
  -115.784    31.391
  -115.818    31.909
>
  -115.784    31.391
  -115.818    31.909
>
  -115.284    32.135
  -115.818    31.909
>
  -115.284    32.135
  -115.818    31.909
>
  -116.663    31.868
  -115.818    31.909
>
  -116.663    31.868
  -115.818    31.909
>
  -115.581    32.537
  -115.818    31.909
>
  -115.581    32.537
  -115.818    31.909
>
  -115.304    32.418
  -115.818    31.909
>
  -116.725    31.742
  -115.818    31.909
>
  -116.725    31.742
  -115.818    31.909
>
  -115.198    32.407
  -115.818    31.909
>
  -115.923    32.648
  -115.818    31.909
>
  -115.923    32.648
  -115.818    31.909
>
  -115.922    32.647
  -115.818    31.909
>
  -115.725    32.649
  -115.818    31.909
>
  -115.725    32.649
  -115.818    31.909
>
  -115.051    31.472
  -115.818    31.909
>
  -115.051    31.472
  -115.818    31.909
>
  -115.076    32.303
  -115.818    31.909
>
  -116.109    32.650
  -115.818    31.909
>
  -116.109    32.650
  -115.818    31.909
>
  -115.445    32.632
  -115.818    31.909
>
  -115.708    32.007
  -115.558    31.780
>
  -115.708    32.007
  -115.558    31.780
>
  -115.948    32.005
  -115.558    31.780
>
  -115.948    32.005
  -115.558    31.780
>
  -115.784    31.391
  -115.558    31.780
>
  -115.784    31.391
  -115.558    31.780
>
  -115.284    32.135
  -115.558    31.780
>
  -115.284    32.135
  -115.558    31.780
>
  -115.051    31.472
  -115.558    31.780
>
  -115.161    32.266
  -115.558    31.780
>
  -115.161    32.266
  -115.558    31.780
>
  -115.304    32.418
  -115.558    31.780
>
  -115.076    32.303
  -115.558    31.780
>
  -115.198    32.407
  -115.558    31.780
>
  -115.198    32.407
  -115.558    31.780
>
  -115.466    31.046
  -115.558    31.780
>
  -115.466    31.046
  -115.558    31.780
>
  -114.745    31.959
  -115.558    31.780
>
  -115.581    32.537
  -115.558    31.780
>
  -115.581    32.537
  -115.558    31.780
>
  -115.708    32.007
  -115.811    31.899
>
  -115.708    32.007
  -115.811    31.899
>
  -115.708    32.007
  -115.811    31.899
>
  -115.708    32.007
  -115.811    31.899
>
  -115.948    32.005
  -115.811    31.899
>
  -115.948    32.005
  -115.811    31.899
>
  -115.784    31.391
  -115.811    31.899
>
  -115.784    31.391
  -115.811    31.899
>
  -115.784    31.391
  -115.811    31.899
>
  -115.784    31.391
  -115.811    31.899
>
  -115.581    32.537
  -115.811    31.899
>
  -115.581    32.537
  -115.811    31.899
>
  -115.304    32.418
  -115.811    31.899
>
  -115.304    32.418
  -115.811    31.899
>
  -115.198    32.407
  -115.811    31.899
>
  -116.663    31.868
  -115.811    31.899
>
  -116.663    31.868
  -115.811    31.899
>
  -116.663    31.868
  -115.811    31.899
>
  -115.076    32.303
  -115.811    31.899
>
  -115.725    32.649
  -115.811    31.899
>
  -115.923    32.648
  -115.811    31.899
>
  -115.923    32.648
  -115.811    31.899
>
  -115.051    31.472
  -115.811    31.899
>
  -115.051    31.472
  -115.811    31.899
>
  -116.109    32.650
  -115.811    31.899
>
  -116.109    32.650
  -115.811    31.899
>
  -115.445    32.632
  -115.811    31.899
>
  -115.445    32.632
  -115.811    31.899
>
  -116.725    31.742
  -115.811    31.899
>
  -116.725    31.742
  -115.811    31.899
>
  -115.948    32.005
  -115.818    31.916
>
  -115.948    32.005
  -115.818    31.916
>
  -115.708    32.007
  -115.818    31.916
>
  -115.708    32.007
  -115.818    31.916
>
  -115.784    31.391
  -115.818    31.916
>
  -115.784    31.391
  -115.818    31.916
>
  -115.284    32.135
  -115.818    31.916
>
  -115.581    32.537
  -115.818    31.916
>
  -115.581    32.537
  -115.818    31.916
>
  -115.304    32.418
  -115.818    31.916
>
  -115.304    32.418
  -115.818    31.916
>
  -115.923    32.648
  -115.818    31.916
>
  -115.923    32.648
  -115.818    31.916
>
  -115.922    32.647
  -115.818    31.916
>
  -115.725    32.649
  -115.818    31.916
>
  -115.725    32.649
  -115.818    31.916
>
  -116.725    31.742
  -115.818    31.916
>
  -116.725    31.742
  -115.818    31.916
>
  -115.076    32.303
  -115.818    31.916
>
  -116.109    32.650
  -115.818    31.916
>
  -116.109    32.650
  -115.818    31.916
>
  -116.109    32.650
  -115.818    31.916
>
  -115.445    32.632
  -115.818    31.916
>
  -115.445    32.632
  -115.818    31.916
>
  -115.784    31.391
  -115.717    31.306
>
  -115.784    31.391
  -115.717    31.306
>
  -115.784    31.391
  -115.717    31.306
>
  -115.784    31.391
  -115.717    31.306
>
  -115.466    31.046
  -115.717    31.306
>
  -115.466    31.046
  -115.717    31.306
>
  -115.466    31.046
  -115.717    31.306
>
  -115.876    30.576
  -115.717    31.306
>
  -115.876    30.576
  -115.717    31.306
>
  -115.876    30.576
  -115.717    31.306
>
  -115.708    32.007
  -115.717    31.306
>
  -115.948    32.005
  -115.717    31.306
>
  -115.948    32.005
  -115.717    31.306
>
  -115.948    32.005
  -115.717    31.306
>
  -116.238    31.340
  -116.154    31.717
>
  -116.238    31.340
  -116.154    31.717
>
  -115.948    32.005
  -116.154    31.717
>
  -115.948    32.005
  -116.154    31.717
>
  -116.663    31.868
  -116.154    31.717
>
  -116.663    31.868
  -116.154    31.717
>
  -116.663    31.868
  -116.154    31.717
>
  -116.725    31.742
  -116.154    31.717
>
  -116.725    31.742
  -116.154    31.717
>
  -115.784    31.391
  -116.154    31.717
>
  -115.784    31.391
  -116.154    31.717
>
  -115.784    31.391
  -116.154    31.717
>
  -115.708    32.007
  -116.154    31.717
>
  -115.708    32.007
  -116.154    31.717
>
  -116.664    32.313
  -116.154    31.717
>
  -116.664    32.313
  -116.154    31.717
>
  -116.664    32.313
  -116.154    31.717
>
  -115.948    32.005
  -116.206    31.826
>
  -116.663    31.868
  -116.206    31.826
>
  -116.663    31.868
  -116.206    31.826
>
  -116.663    31.868
  -116.206    31.826
>
  -116.725    31.742
  -116.206    31.826
>
  -116.725    31.742
  -116.206    31.826
>
  -115.708    32.007
  -116.206    31.826
>
  -115.708    32.007
  -116.206    31.826
>
  -116.238    31.340
  -116.206    31.826
>
  -116.238    31.340
  -116.206    31.826
>
  -116.238    31.340
  -116.206    31.826
>
  -115.784    31.391
  -116.206    31.826
>
  -115.784    31.391
  -116.206    31.826
>
  -115.784    31.391
  -116.206    31.826
>
  -115.784    31.391
  -116.206    31.826
>
  -116.664    32.313
  -116.206    31.826
>
  -116.664    32.313
  -116.206    31.826
>
  -116.664    32.313
  -116.206    31.826
>
  -116.664    32.313
  -116.206    31.826
>
  -116.664    32.313
  -116.206    31.826
>
  -116.675    32.433
  -116.206    31.826
>
  -116.675    32.433
  -116.206    31.826
>
  -116.675    32.433
  -116.206    31.826
>
  -115.708    32.007
  -115.624    31.508
>
  -115.708    32.007
  -115.624    31.508
>
  -115.708    32.007
  -115.624    31.508
>
  -116.238    31.340
  -115.624    31.508
>
  -116.238    31.340
  -115.624    31.508
>
  -115.051    31.472
  -115.624    31.508
>
  -115.948    32.005
  -115.624    31.508
>
  -115.948    32.005
  -115.624    31.508
>
  -115.284    32.135
  -115.624    31.508
>
  -115.708    32.007
  -115.626    31.516
>
  -115.708    32.007
  -115.626    31.516
>
  -115.051    31.472
  -115.626    31.516
>
  -115.051    31.472
  -115.626    31.516
>
  -115.948    32.005
  -115.626    31.516
>
  -115.948    32.005
  -115.626    31.516
>
  -116.238    31.340
  -115.626    31.516
>
  -116.238    31.340
  -115.626    31.516
>
  -115.284    32.135
  -115.626    31.516
>
  -116.238    31.340
  -115.634    31.506
>
  -116.238    31.340
  -115.634    31.506
>
  -115.708    32.007
  -115.634    31.506
>
  -115.708    32.007
  -115.634    31.506
>
  -115.051    31.472
  -115.634    31.506
>
  -115.051    31.472
  -115.634    31.506
>
  -115.051    31.472
  -115.634    31.506
>
  -115.948    32.005
  -115.634    31.506
>
  -115.948    32.005
  -115.634    31.506
>
  -115.284    32.135
  -115.634    31.506
>
  -115.784    31.391
  -115.633    31.509
>
  -115.784    31.391
  -115.633    31.509
>
  -115.708    32.007
  -115.633    31.509
>
  -115.708    32.007
  -115.633    31.509
>
  -115.051    31.472
  -115.633    31.509
>
  -115.051    31.472
  -115.633    31.509
>
  -115.051    31.472
  -115.633    31.509
>
  -116.238    31.340
  -115.633    31.509
>
  -116.238    31.340
  -115.633    31.509
>
  -115.948    32.005
  -115.633    31.509
>
  -115.948    32.005
  -115.633    31.509
>
  -115.284    32.135
  -115.633    31.509
>
  -115.284    32.135
  -115.633    31.509
>
  -115.784    31.391
  -115.631    31.491
>
  -115.784    31.391
  -115.631    31.491
>
  -115.784    31.391
  -115.631    31.491
>
  -115.784    31.391
  -115.631    31.491
>
  -115.051    31.472
  -115.631    31.491
>
  -115.051    31.472
  -115.631    31.491
>
  -115.051    31.472
  -115.631    31.491
>
  -115.708    32.007
  -115.631    31.491
>
  -115.708    32.007
  -115.631    31.491
>
  -116.238    31.340
  -115.631    31.491
>
  -116.238    31.340
  -115.631    31.491
>
  -115.948    32.005
  -115.631    31.491
>
  -115.948    32.005
  -115.631    31.491
>
  -115.284    32.135
  -115.631    31.491
>
  -115.284    32.135
  -115.631    31.491
>
  -115.784    31.391
  -115.643    31.490
>
  -115.784    31.391
  -115.643    31.490
>
  -115.784    31.391
  -115.643    31.490
>
  -115.784    31.391
  -115.643    31.490
>
  -115.784    31.391
  -115.643    31.490
>
  -115.051    31.472
  -115.643    31.490
>
  -115.051    31.472
  -115.643    31.490
>
  -116.238    31.340
  -115.643    31.490
>
  -116.238    31.340
  -115.643    31.490
>
  -115.708    32.007
  -115.643    31.490
>
  -115.708    32.007
  -115.643    31.490
>
  -115.948    32.005
  -115.643    31.490
>
  -115.948    32.005
  -115.643    31.490
>
  -115.284    32.135
  -115.643    31.490
>
  -115.284    32.135
  -115.643    31.490
>
  -115.784    31.391
  -115.615    31.515
>
  -115.784    31.391
  -115.615    31.515
>
  -115.784    31.391
  -115.615    31.515
>
  -115.051    31.472
  -115.615    31.515
>
  -115.051    31.472
  -115.615    31.515
>
  -115.051    31.472
  -115.615    31.515
>
  -115.708    32.007
  -115.615    31.515
>
  -115.708    32.007
  -115.615    31.515
>
  -115.708    32.007
  -115.615    31.515
>
  -116.238    31.340
  -115.615    31.515
>
  -116.238    31.340
  -115.615    31.515
>
  -116.238    31.340
  -115.615    31.515
>
  -115.948    32.005
  -115.615    31.515
>
  -115.948    32.005
  -115.615    31.515
>
  -115.284    32.135
  -115.615    31.515
>
  -115.284    32.135
  -115.615    31.515
>
  -115.784    31.391
  -115.831    31.626
>
  -115.784    31.391
  -115.831    31.626
>
  -115.784    31.391
  -115.831    31.626
>
  -115.948    32.005
  -115.831    31.626
>
  -115.948    32.005
  -115.831    31.626
>
  -115.708    32.007
  -115.831    31.626
>
  -115.708    32.007
  -115.831    31.626
>
  -116.238    31.340
  -115.831    31.626
>
  -116.238    31.340
  -115.831    31.626
>
  -116.238    31.340
  -115.831    31.626
>
  -115.284    32.135
  -115.831    31.626
>
  -115.284    32.135
  -115.831    31.626
>
  -115.051    31.472
  -115.831    31.626
>
  -115.051    31.472
  -115.831    31.626
>
  -115.051    31.472
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.663    31.868
  -115.831    31.626
>
  -116.725    31.742
  -115.831    31.626
>
  -116.725    31.742
  -115.831    31.626
>
  -115.784    31.391
  -115.660    31.529
>
  -115.784    31.391
  -115.660    31.529
>
  -115.784    31.391
  -115.660    31.529
>
  -115.784    31.391
  -115.660    31.529
>
  -115.784    31.391
  -115.660    31.529
>
  -115.816    31.871
  -115.660    31.529
>
  -115.816    31.871
  -115.660    31.529
>
  -115.708    32.007
  -115.660    31.529
>
  -115.708    32.007
  -115.660    31.529
>
  -116.099    31.857
  -115.660    31.529
>
  -116.099    31.857
  -115.660    31.529
>
  -115.948    32.005
  -115.660    31.529
>
  -115.948    32.005
  -115.660    31.529
>
  -115.051    31.472
  -115.660    31.529
>
  -115.051    31.472
  -115.660    31.529
>
  -115.051    31.472
  -115.660    31.529
>
  -115.284    32.135
  -115.660    31.529
>
  -115.284    32.135
  -115.660    31.529
>
  -116.301    32.020
  -115.660    31.529
>
  -116.301    32.020
  -115.660    31.529
>
  -115.784    31.391
  -115.629    31.508
>
  -115.784    31.391
  -115.629    31.508
>
  -115.051    31.472
  -115.629    31.508
>
  -115.051    31.472
  -115.629    31.508
>
  -115.051    31.472
  -115.629    31.508
>
  -115.708    32.007
  -115.629    31.508
>
  -115.708    32.007
  -115.629    31.508
>
  -116.238    31.340
  -115.629    31.508
>
  -116.238    31.340
  -115.629    31.508
>
  -116.238    31.340
  -115.629    31.508
>
  -115.948    32.005
  -115.629    31.508
>
  -115.948    32.005
  -115.629    31.508
>
  -115.284    32.135
  -115.629    31.508
>
  -115.284    32.135
  -115.629    31.508
>
  -116.099    31.857
  -115.986    31.628
>
  -115.784    31.391
  -115.986    31.628
>
  -115.784    31.391
  -115.986    31.628
>
  -115.784    31.391
  -115.986    31.628
>
  -115.784    31.391
  -115.986    31.628
>
  -115.816    31.871
  -115.986    31.628
>
  -115.816    31.871
  -115.986    31.628
>
  -116.238    31.340
  -115.986    31.628
>
  -115.708    32.007
  -115.986    31.628
>
  -115.708    32.007
  -115.986    31.628
>
  -115.708    32.007
  -115.986    31.628
>
  -116.301    32.020
  -115.986    31.628
>
  -115.841    32.116
  -115.986    31.628
>
  -115.841    32.116
  -115.986    31.628
>
  -116.663    31.868
  -115.986    31.628
>
  -116.663    31.868
  -115.986    31.628
>
  -116.663    31.868
  -115.986    31.628
>
  -116.663    31.868
  -115.986    31.628
>
  -116.725    31.742
  -115.986    31.628
>
  -116.725    31.742
  -115.986    31.628
>
  -115.284    32.135
  -115.986    31.628
>
  -115.284    32.135
  -115.986    31.628
>
  -115.784    31.391
  -115.627    31.499
>
  -115.784    31.391
  -115.627    31.499
>
  -115.784    31.391
  -115.627    31.499
>
  -115.816    31.871
  -115.627    31.499
>
  -115.816    31.871
  -115.627    31.499
>
  -115.051    31.472
  -115.627    31.499
>
  -115.051    31.472
  -115.627    31.499
>
  -115.051    31.472
  -115.627    31.499
>
  -116.238    31.340
  -115.627    31.499
>
  -115.708    32.007
  -115.627    31.499
>
  -115.708    32.007
  -115.627    31.499
>
  -116.099    31.857
  -115.627    31.499
>
  -116.099    31.857
  -115.627    31.499
>
  -115.841    32.116
  -115.627    31.499
>
  -115.841    32.116
  -115.627    31.499
>
  -115.284    32.135
  -115.627    31.499
>
  -115.284    32.135
  -115.627    31.499
>
  -116.301    32.020
  -115.627    31.499
>
  -116.301    32.020
  -115.627    31.499
>
  -115.784    31.391
  -115.611    31.376
>
  -115.784    31.391
  -115.611    31.376
>
  -115.784    31.391
  -115.611    31.376
>
  -115.784    31.391
  -115.611    31.376
>
  -115.051    31.472
  -115.611    31.376
>
  -115.051    31.472
  -115.611    31.376
>
  -115.708    32.007
  -115.611    31.376
>
  -115.708    32.007
  -115.611    31.376
>
  -115.708    32.007
  -115.611    31.376
>
  -115.784    31.391
  -115.640    31.501
>
  -115.784    31.391
  -115.640    31.501
>
  -115.784    31.391
  -115.640    31.501
>
  -115.784    31.391
  -115.640    31.501
>
  -115.816    31.871
  -115.640    31.501
>
  -115.816    31.871
  -115.640    31.501
>
  -115.051    31.472
  -115.640    31.501
>
  -115.051    31.472
  -115.640    31.501
>
  -115.051    31.472
  -115.640    31.501
>
  -115.051    31.472
  -115.640    31.501
>
  -115.708    32.007
  -115.640    31.501
>
  -115.708    32.007
  -115.640    31.501
>
  -116.238    31.340
  -115.640    31.501
>
  -116.238    31.340
  -115.640    31.501
>
  -115.841    32.116
  -115.640    31.501
>
  -115.841    32.116
  -115.640    31.501
>
  -115.284    32.135
  -115.640    31.501
>
  -115.284    32.135
  -115.640    31.501
>
  -116.301    32.020
  -115.640    31.501
>
  -116.301    32.020
  -115.640    31.501
>
  -116.301    32.020
  -116.239    31.738
>
  -116.301    32.020
  -116.239    31.738
>
  -116.663    31.868
  -116.239    31.738
>
  -116.663    31.868
  -116.239    31.738
>
  -116.663    31.868
  -116.239    31.738
>
  -116.238    31.340
  -116.239    31.738
>
  -116.725    31.742
  -116.239    31.738
>
  -115.784    31.391
  -116.239    31.738
>
  -115.784    31.391
  -116.239    31.738
>
  -115.784    31.391
  -116.239    31.738
>
  -115.841    32.116
  -116.239    31.738
>
  -115.841    32.116
  -116.239    31.738
>
  -115.708    32.007
  -116.239    31.738
>
  -115.708    32.007
  -116.239    31.738
>
  -116.664    32.313
  -116.239    31.738
>
  -116.664    32.313
  -116.239    31.738
>
  -116.664    32.313
  -116.239    31.738
>
  -116.664    32.313
  -116.239    31.738
>
  -116.675    32.433
  -116.239    31.738
>
  -116.675    32.433
  -116.239    31.738
>
  -116.675    32.433
  -116.239    31.738
>
  -116.675    32.433
  -116.239    31.738
>
  -115.784    31.391
  -115.621    31.532
>
  -115.784    31.391
  -115.621    31.532
>
  -115.784    31.391
  -115.621    31.532
>
  -115.784    31.391
  -115.621    31.532
>
  -115.784    31.391
  -115.621    31.532
>
  -115.466    31.046
  -115.621    31.532
>
  -115.466    31.046
  -115.621    31.532
>
  -115.466    31.046
  -115.621    31.532
>
  -115.051    31.472
  -115.621    31.532
>
  -115.051    31.472
  -115.621    31.532
>
  -115.051    31.472
  -115.621    31.532
>
  -116.099    31.857
  -115.621    31.532
>
  -116.099    31.857
  -115.621    31.532
>
  -116.238    31.340
  -115.621    31.532
>
  -116.238    31.340
  -115.621    31.532
>
  -115.284    32.135
  -115.621    31.532
>
  -115.784    31.391
  -116.033    31.696
>
  -115.784    31.391
  -116.033    31.696
>
  -115.784    31.391
  -116.033    31.696
>
  -115.784    31.391
  -116.033    31.696
>
  -115.784    31.391
  -116.033    31.696
>
  -116.238    31.340
  -116.033    31.696
>
  -116.238    31.340
  -116.033    31.696
>
  -116.238    31.340
  -116.033    31.696
>
  -115.708    32.007
  -116.033    31.696
>
  -115.708    32.007
  -116.033    31.696
>
  -116.663    31.868
  -116.033    31.696
>
  -116.663    31.868
  -116.033    31.696
>
  -116.663    31.868
  -116.033    31.696
>
  -116.725    31.742
  -116.033    31.696
>
  -116.725    31.742
  -116.033    31.696
>
  -115.784    31.391
  -115.612    31.481
>
  -115.784    31.391
  -115.612    31.481
>
  -115.784    31.391
  -115.612    31.481
>
  -115.466    31.046
  -115.612    31.481
>
  -115.466    31.046
  -115.612    31.481
>
  -115.466    31.046
  -115.612    31.481
>
  -115.466    31.046
  -115.612    31.481
>
  -115.051    31.472
  -115.612    31.481
>
  -115.051    31.472
  -115.612    31.481
>
  -115.051    31.472
  -115.612    31.481
>
  -115.708    32.007
  -115.612    31.481
>
  -115.708    32.007
  -115.612    31.481
>
  -116.099    31.857
  -115.612    31.481
>
  -116.099    31.857
  -115.612    31.481
>
  -116.238    31.340
  -115.612    31.481
>
  -116.238    31.340
  -115.612    31.481
>
  -115.284    32.135
  -115.612    31.481
>
  -115.051    31.472
  -115.342    31.455
>
  -115.051    31.472
  -115.342    31.455
>
  -115.051    31.472
  -115.342    31.455
>
  -115.784    31.391
  -115.342    31.455
>
  -115.784    31.391
  -115.342    31.455
>
  -115.784    31.391
  -115.342    31.455
>
  -115.784    31.391
  -115.342    31.455
>
  -115.466    31.046
  -115.342    31.455
>
  -115.466    31.046
  -115.342    31.455
>
  -115.708    32.007
  -115.342    31.455
>
  -114.745    31.960
  -115.342    31.455
>
  -114.745    31.960
  -115.342    31.455
>
  -114.745    31.959
  -115.342    31.455
>
  -116.099    31.857
  -115.342    31.455
>
  -116.099    31.857
  -115.342    31.455
>
  -114.961    32.166
  -115.342    31.455
>
  -114.961    32.166
  -115.342    31.455
>
  -115.784    31.391
  -115.633    31.494
>
  -115.784    31.391
  -115.633    31.494
>
  -115.784    31.391
  -115.633    31.494
>
  -115.784    31.391
  -115.633    31.494
>
  -115.466    31.046
  -115.633    31.494
>
  -115.466    31.046
  -115.633    31.494
>
  -115.466    31.046
  -115.633    31.494
>
  -115.466    31.046
  -115.633    31.494
>
  -115.051    31.472
  -115.633    31.494
>
  -115.051    31.472
  -115.633    31.494
>
  -115.051    31.472
  -115.633    31.494
>
  -115.708    32.007
  -115.633    31.494
>
  -115.708    32.007
  -115.633    31.494
>
  -116.099    31.857
  -115.633    31.494
>
  -116.099    31.857
  -115.633    31.494
>
  -115.284    32.135
  -115.633    31.494
>
  -116.099    31.857
  -115.988    31.600
>
  -116.099    31.857
  -115.988    31.600
>
  -115.784    31.391
  -115.988    31.600
>
  -115.784    31.391
  -115.988    31.600
>
  -115.784    31.391
  -115.988    31.600
>
  -115.708    32.007
  -115.988    31.600
>
  -115.708    32.007
  -115.988    31.600
>
  -116.663    31.868
  -115.988    31.600
>
  -116.663    31.868
  -115.988    31.600
>
  -116.663    31.868
  -115.988    31.600
>
  -116.725    31.742
  -115.988    31.600
>
  -116.725    31.742
  -115.988    31.600
>
  -115.466    31.046
  -115.988    31.600
>
  -115.466    31.046
  -115.988    31.600
>
  -115.466    31.046
  -115.988    31.600
>
  -116.663    31.868
  -116.172    31.859
>
  -116.663    31.868
  -116.172    31.859
>
  -115.708    32.007
  -116.172    31.859
>
  -115.708    32.007
  -116.172    31.859
>
  -115.708    32.007
  -116.172    31.859
>
  -116.725    31.742
  -116.172    31.859
>
  -115.784    31.391
  -116.172    31.859
>
  -115.784    31.391
  -116.172    31.859
>
  -115.784    31.391
  -116.172    31.859
>
  -116.664    32.313
  -116.172    31.859
>
  -116.664    32.313
  -116.172    31.859
>
  -116.664    32.313
  -116.172    31.859
>
  -116.664    32.313
  -116.172    31.859
>
  -116.675    32.433
  -116.172    31.859
>
  -116.675    32.433
  -116.172    31.859
>
  -116.109    32.650
  -116.172    31.859
>
  -116.109    32.650
  -116.172    31.859
>
  -116.607    32.569
  -116.172    31.859
>
  -116.607    32.569
  -116.172    31.859
>
  -116.607    32.569
  -116.172    31.859
>
  -116.607    32.569
  -116.172    31.859
>
  -115.051    31.472
  -115.343    31.454
>
  -115.051    31.472
  -115.343    31.454
>
  -115.051    31.472
  -115.343    31.454
>
  -115.466    31.046
  -115.343    31.454
>
  -115.466    31.046
  -115.343    31.454
>
  -115.784    31.391
  -115.343    31.454
>
  -115.784    31.391
  -115.343    31.454
>
  -115.784    31.391
  -115.343    31.454
>
  -115.784    31.391
  -115.343    31.454
>
  -115.708    32.007
  -115.343    31.454
>
  -115.708    32.007
  -115.343    31.454
>
  -115.284    32.135
  -115.343    31.454
>
  -116.238    31.340
  -115.343    31.454
>
  -116.238    31.340
  -115.343    31.454
>
  -114.745    31.960
  -115.343    31.454
>
  -114.745    31.960
  -115.343    31.454
>
  -116.099    31.857
  -115.343    31.454
>
  -116.099    31.857
  -115.343    31.454
>
  -114.961    32.166
  -115.343    31.454
>
  -114.961    32.166
  -115.343    31.454
>
  -115.784    31.391
  -115.684    31.553
>
  -115.784    31.391
  -115.684    31.553
>
  -115.784    31.391
  -115.684    31.553
>
  -115.784    31.391
  -115.684    31.553
>
  -116.099    31.857
  -115.684    31.553
>
  -116.099    31.857
  -115.684    31.553
>
  -115.708    32.007
  -115.684    31.553
>
  -116.238    31.340
  -115.684    31.553
>
  -116.238    31.340
  -115.684    31.553
>
  -115.466    31.046
  -115.684    31.553
>
  -115.466    31.046
  -115.684    31.553
>
  -115.466    31.046
  -115.684    31.553
>
  -115.051    31.472
  -115.684    31.553
>
  -115.051    31.472
  -115.684    31.553
>
  -115.051    31.472
  -115.684    31.553
>
  -115.051    31.472
  -115.684    31.553
>
  -116.099    31.857
  -115.939    31.663
>
  -116.099    31.857
  -115.939    31.663
>
  -115.784    31.391
  -115.939    31.663
>
  -115.784    31.391
  -115.939    31.663
>
  -115.784    31.391
  -115.939    31.663
>
  -115.784    31.391
  -115.939    31.663
>
  -116.238    31.340
  -115.939    31.663
>
  -116.238    31.340
  -115.939    31.663
>
  -115.708    32.007
  -115.939    31.663
>
  -116.663    31.868
  -115.939    31.663
>
  -116.663    31.868
  -115.939    31.663
>
  -116.663    31.868
  -115.939    31.663
>
  -116.663    31.868
  -115.939    31.663
>
  -116.725    31.742
  -115.939    31.663
>
  -116.725    31.742
  -115.939    31.663
>
  -116.725    31.742
  -115.939    31.663
>
  -115.466    31.046
  -115.939    31.663
>
  -115.466    31.046
  -115.939    31.663
>
  -115.284    32.135
  -115.939    31.663
>
  -115.051    31.472
  -115.939    31.663
>
  -115.051    31.472
  -115.939    31.663
>
  -115.051    31.472
  -115.939    31.663
>
  -115.051    31.472
  -115.939    31.663
>
  -115.876    30.576
  -115.971    30.844
>
  -115.876    30.576
  -115.971    30.844
>
  -115.876    30.576
  -115.971    30.844
>
  -115.876    30.576
  -115.971    30.844
>
  -116.238    31.340
  -115.971    30.844
>
  -116.238    31.340
  -115.971    30.844
>
  -115.784    31.391
  -115.971    30.844
>
  -115.784    31.391
  -115.971    30.844
>
  -115.784    31.391
  -115.971    30.844
>
  -115.784    31.391
  -115.971    30.844
>
  -115.784    31.391
  -115.677    31.564
>
  -115.784    31.391
  -115.677    31.564
>
  -115.784    31.391
  -115.677    31.564
>
  -115.784    31.391
  -115.677    31.564
>
  -115.708    32.007
  -115.677    31.564
>
  -115.708    32.007
  -115.677    31.564
>
  -116.099    31.857
  -115.677    31.564
>
  -116.099    31.857
  -115.677    31.564
>
  -116.238    31.340
  -115.677    31.564
>
  -116.238    31.340
  -115.677    31.564
>
  -115.466    31.046
  -115.677    31.564
>
  -115.466    31.046
  -115.677    31.564
>
  -115.466    31.046
  -115.677    31.564
>
  -115.051    31.472
  -115.677    31.564
>
  -115.051    31.472
  -115.677    31.564
>
  -115.284    32.135
  -115.677    31.564
>
  -115.284    32.135
  -115.677    31.564
>
  -115.784    31.391
  -115.672    31.560
>
  -115.784    31.391
  -115.672    31.560
>
  -115.784    31.391
  -115.672    31.560
>
  -115.784    31.391
  -115.672    31.560
>
  -115.708    32.007
  -115.672    31.560
>
  -115.708    32.007
  -115.672    31.560
>
  -116.099    31.857
  -115.672    31.560
>
  -116.099    31.857
  -115.672    31.560
>
  -116.238    31.340
  -115.672    31.560
>
  -116.238    31.340
  -115.672    31.560
>
  -115.466    31.046
  -115.672    31.560
>
  -115.466    31.046
  -115.672    31.560
>
  -115.051    31.472
  -115.672    31.560
>
  -115.051    31.472
  -115.672    31.560
>
  -115.051    31.472
  -115.672    31.560
>
  -115.466    31.046
  -115.672    31.560
>
  -115.284    32.135
  -115.672    31.560
>
  -115.284    32.135
  -115.672    31.560
>
  -115.784    31.391
  -115.666    31.575
>
  -115.784    31.391
  -115.666    31.575
>
  -115.784    31.391
  -115.666    31.575
>
  -115.708    32.007
  -115.666    31.575
>
  -115.708    32.007
  -115.666    31.575
>
  -116.099    31.857
  -115.666    31.575
>
  -115.051    31.472
  -115.666    31.575
>
  -115.051    31.472
  -115.666    31.575
>
  -115.466    31.046
  -115.666    31.575
>
  -115.466    31.046
  -115.666    31.575
>
  -115.466    31.046
  -115.666    31.575
>
  -116.238    31.340
  -115.666    31.575
>
  -116.238    31.340
  -115.666    31.575
>
  -115.284    32.135
  -115.666    31.575
>
  -115.284    32.135
  -115.666    31.575
>
  -115.784    31.391
  -115.688    31.576
>
  -115.784    31.391
  -115.688    31.576
>
  -115.784    31.391
  -115.688    31.576
>
  -115.708    32.007
  -115.688    31.576
>
  -115.708    32.007
  -115.688    31.576
>
  -116.099    31.857
  -115.688    31.576
>
  -116.099    31.857
  -115.688    31.576
>
  -116.238    31.340
  -115.688    31.576
>
  -116.238    31.340
  -115.688    31.576
>
  -115.051    31.472
  -115.688    31.576
>
  -115.051    31.472
  -115.688    31.576
>
  -115.051    31.472
  -115.688    31.576
>
  -115.466    31.046
  -115.688    31.576
>
  -115.466    31.046
  -115.688    31.576
>
  -115.466    31.046
  -115.688    31.576
>
  -115.466    31.046
  -115.688    31.576
>
  -115.284    32.135
  -115.688    31.576
>
  -115.784    31.391
  -115.678    31.563
>
  -115.784    31.391
  -115.678    31.563
>
  -115.784    31.391
  -115.678    31.563
>
  -116.238    31.340
  -115.678    31.563
>
  -116.238    31.340
  -115.678    31.563
>
  -116.099    31.857
  -115.678    31.563
>
  -116.099    31.857
  -115.678    31.563
>
  -115.708    32.007
  -115.678    31.563
>
  -115.708    32.007
  -115.678    31.563
>
  -115.466    31.046
  -115.678    31.563
>
  -115.466    31.046
  -115.678    31.563
>
  -115.051    31.472
  -115.678    31.563
>
  -115.051    31.472
  -115.678    31.563
>
  -115.052    31.472
  -115.334    31.438
>
  -115.052    31.472
  -115.334    31.438
>
  -115.051    31.472
  -115.334    31.438
>
  -115.051    31.472
  -115.334    31.438
>
  -115.784    31.391
  -115.334    31.438
>
  -115.784    31.391
  -115.334    31.438
>
  -115.784    31.391
  -115.334    31.438
>
  -115.784    31.391
  -115.334    31.438
>
  -115.466    31.046
  -115.334    31.438
>
  -115.466    31.046
  -115.334    31.438
>
  -115.466    31.046
  -115.334    31.438
>
  -115.708    32.007
  -115.334    31.438
>
  -115.708    32.007
  -115.334    31.438
>
  -115.708    32.007
  -115.334    31.438
>
  -115.284    32.135
  -115.334    31.438
>
  -115.284    32.135
  -115.334    31.438
>
  -114.745    31.960
  -115.334    31.438
>
  -114.745    31.960
  -115.334    31.438
>
  -116.238    31.340
  -115.334    31.438
>
  -116.238    31.340
  -115.334    31.438
>
  -114.961    32.166
  -115.334    31.438
>
  -114.961    32.166
  -115.334    31.438
>
  -115.784    31.391
  -115.477    31.511
>
  -115.784    31.391
  -115.477    31.511
>
  -115.784    31.391
  -115.477    31.511
>
  -115.052    31.472
  -115.477    31.511
>
  -115.052    31.472
  -115.477    31.511
>
  -115.051    31.472
  -115.477    31.511
>
  -115.051    31.472
  -115.477    31.511
>
  -115.708    32.007
  -115.477    31.511
>
  -115.708    32.007
  -115.477    31.511
>
  -116.099    31.857
  -115.477    31.511
>
  -116.099    31.857
  -115.477    31.511
>
  -116.238    31.340
  -115.477    31.511
>
  -116.238    31.340
  -115.477    31.511
>
  -116.238    31.340
  -115.477    31.511
>
  -115.284    32.135
  -115.477    31.511
>
  -115.284    32.135
  -115.477    31.511
>
  -114.745    31.960
  -115.477    31.511
>
  -114.961    32.166
  -115.477    31.511
>
  -115.161    32.266
  -115.477    31.511
>
  -115.161    32.266
  -115.477    31.511
>
  -115.784    31.391
  -115.660    31.540
>
  -115.784    31.391
  -115.660    31.540
>
  -115.784    31.391
  -115.660    31.540
>
  -115.708    32.007
  -115.660    31.540
>
  -115.708    32.007
  -115.660    31.540
>
  -115.708    32.007
  -115.660    31.540
>
  -116.099    31.857
  -115.660    31.540
>
  -116.099    31.857
  -115.660    31.540
>
  -116.238    31.340
  -115.660    31.540
>
  -116.238    31.340
  -115.660    31.540
>
  -115.466    31.046
  -115.660    31.540
>
  -115.466    31.046
  -115.660    31.540
>
  -115.466    31.046
  -115.660    31.540
>
  -115.051    31.472
  -115.660    31.540
>
  -115.051    31.472
  -115.660    31.540
>
  -115.284    32.135
  -115.660    31.540
>
  -115.784    31.391
  -115.663    31.546
>
  -115.784    31.391
  -115.663    31.546
>
  -115.784    31.391
  -115.663    31.546
>
  -115.784    31.391
  -115.663    31.546
>
  -115.784    31.391
  -115.663    31.546
>
  -115.708    32.007
  -115.663    31.546
>
  -115.708    32.007
  -115.663    31.546
>
  -116.099    31.857
  -115.663    31.546
>
  -116.099    31.857
  -115.663    31.546
>
  -116.238    31.340
  -115.663    31.546
>
  -116.238    31.340
  -115.663    31.546
>
  -116.238    31.340
  -115.663    31.546
>
  -115.052    31.472
  -115.663    31.546
>
  -115.052    31.472
  -115.663    31.546
>
  -115.051    31.472
  -115.663    31.546
>
  -115.051    31.472
  -115.663    31.546
>
  -115.052    31.472
  -115.382    31.424
>
  -115.052    31.472
  -115.382    31.424
>
  -115.051    31.472
  -115.382    31.424
>
  -115.051    31.472
  -115.382    31.424
>
  -115.051    31.472
  -115.382    31.424
>
  -115.784    31.391
  -115.382    31.424
>
  -115.784    31.391
  -115.382    31.424
>
  -115.784    31.391
  -115.382    31.424
>
  -115.784    31.391
  -115.382    31.424
>
  -115.466    31.046
  -115.382    31.424
>
  -115.466    31.046
  -115.382    31.424
>
  -115.466    31.046
  -115.382    31.424
>
  -115.466    31.046
  -115.382    31.424
>
  -115.708    32.007
  -115.382    31.424
>
  -115.708    32.007
  -115.382    31.424
>
  -115.708    32.007
  -115.382    31.424
>
  -116.238    31.340
  -115.382    31.424
>
  -116.238    31.340
  -115.382    31.424
>
  -116.238    31.340
  -115.382    31.424
>
  -115.284    32.135
  -115.382    31.424
>
  -115.284    32.135
  -115.382    31.424
>
  -114.745    31.960
  -115.382    31.424
>
  -115.784    31.391
  -115.635    31.500
>
  -115.784    31.391
  -115.635    31.500
>
  -115.784    31.391
  -115.635    31.500
>
  -115.784    31.391
  -115.635    31.500
>
  -115.466    31.046
  -115.635    31.500
>
  -115.466    31.046
  -115.635    31.500
>
  -115.466    31.046
  -115.635    31.500
>
  -115.466    31.046
  -115.635    31.500
>
  -115.052    31.472
  -115.635    31.500
>
  -115.052    31.472
  -115.635    31.500
>
  -115.051    31.472
  -115.635    31.500
>
  -115.051    31.472
  -115.635    31.500
>
  -115.051    31.472
  -115.635    31.500
>
  -115.708    32.007
  -115.635    31.500
>
  -115.708    32.007
  -115.635    31.500
>
  -115.708    32.007
  -115.635    31.500
>
  -116.238    31.340
  -115.635    31.500
>
  -116.238    31.340
  -115.635    31.500
>
  -115.284    32.135
  -115.635    31.500
>
  -115.284    32.135
  -115.635    31.500
>
  -115.708    32.007
  -116.091    31.889
>
  -115.784    31.391
  -116.091    31.889
>
  -115.784    31.391
  -116.091    31.889
>
  -115.784    31.391
  -116.091    31.889
>
  -115.784    31.391
  -116.091    31.889
>
  -116.238    31.340
  -116.091    31.889
>
  -116.238    31.340
  -116.091    31.889
>
  -116.238    31.340
  -116.091    31.889
>
  -116.725    31.742
  -116.091    31.889
>
  -116.725    31.742
  -116.091    31.889
>
  -116.725    31.742
  -116.091    31.889
>
  -116.664    32.313
  -116.091    31.889
>
  -116.664    32.313
  -116.091    31.889
>
  -115.284    32.135
  -116.091    31.889
>
  -116.675    32.433
  -116.091    31.889
>
  -116.675    32.433
  -116.091    31.889
>
  -116.675    32.433
  -116.091    31.889
>
  -116.109    32.650
  -116.091    31.889
>
  -116.109    32.650
  -116.091    31.889
>
  -115.922    32.647
  -116.091    31.889
>
  -115.922    32.647
  -116.091    31.889
>
  -116.366    32.651
  -116.091    31.889
>
  -116.366    32.651
  -116.091    31.889
>
  -115.466    31.046
  -115.405    31.363
>
  -115.466    31.046
  -115.405    31.363
>
  -115.466    31.046
  -115.405    31.363
>
  -115.466    31.046
  -115.405    31.363
>
  -115.051    31.472
  -115.405    31.363
>
  -115.051    31.472
  -115.405    31.363
>
  -115.051    31.472
  -115.405    31.363
>
  -115.784    31.391
  -115.405    31.363
>
  -115.784    31.391
  -115.405    31.363
>
  -115.784    31.391
  -115.405    31.363
>
  -115.708    32.007
  -115.405    31.363
>
  -115.708    32.007
  -115.405    31.363
>
  -116.238    31.340
  -115.405    31.363
>
  -116.238    31.340
  -115.405    31.363
>
  -116.099    31.857
  -115.405    31.363
>
  -116.099    31.857
  -115.405    31.363
>
  -115.284    32.135
  -115.405    31.363
>
  -115.284    32.135
  -115.405    31.363
>
  -115.466    31.046
  -115.398    31.362
>
  -115.466    31.046
  -115.398    31.362
>
  -115.466    31.046
  -115.398    31.362
>
  -115.466    31.046
  -115.398    31.362
>
  -115.466    31.046
  -115.398    31.362
>
  -115.052    31.472
  -115.398    31.362
>
  -115.052    31.472
  -115.398    31.362
>
  -115.051    31.472
  -115.398    31.362
>
  -115.051    31.472
  -115.398    31.362
>
  -115.051    31.472
  -115.398    31.362
>
  -115.784    31.391
  -115.398    31.362
>
  -115.784    31.391
  -115.398    31.362
>
  -115.784    31.391
  -115.398    31.362
>
  -116.238    31.340
  -115.398    31.362
>
  -116.238    31.340
  -115.398    31.362
>
  -115.708    32.007
  -115.398    31.362
>
  -115.708    32.007
  -115.398    31.362
>
  -115.284    32.135
  -115.398    31.362
>
  -115.284    32.135
  -115.398    31.362
>
  -116.099    31.857
  -115.398    31.362
>
  -116.099    31.857
  -115.398    31.362
>
  -115.052    31.472
  -115.389    31.422
>
  -115.052    31.472
  -115.389    31.422
>
  -115.051    31.472
  -115.389    31.422
>
  -115.051    31.472
  -115.389    31.422
>
  -115.784    31.391
  -115.389    31.422
>
  -115.784    31.391
  -115.389    31.422
>
  -115.784    31.391
  -115.389    31.422
>
  -115.784    31.391
  -115.389    31.422
>
  -115.466    31.046
  -115.389    31.422
>
  -115.466    31.046
  -115.389    31.422
>
  -115.466    31.046
  -115.389    31.422
>
  -115.466    31.046
  -115.389    31.422
>
  -115.708    32.007
  -115.389    31.422
>
  -115.708    32.007
  -115.389    31.422
>
  -115.284    32.135
  -115.389    31.422
>
  -115.284    32.135
  -115.389    31.422
>
  -116.238    31.340
  -115.389    31.422
>
  -116.238    31.340
  -115.389    31.422
>
  -116.099    31.857
  -115.389    31.422
>
  -116.099    31.857
  -115.389    31.422
>
  -114.745    31.960
  -115.389    31.422
>
  -114.745    31.960
  -115.389    31.422
>
  -115.784    31.391
  -115.600    31.474
>
  -115.784    31.391
  -115.600    31.474
>
  -115.784    31.391
  -115.600    31.474
>
  -115.784    31.391
  -115.600    31.474
>
  -115.466    31.046
  -115.600    31.474
>
  -115.466    31.046
  -115.600    31.474
>
  -115.052    31.472
  -115.600    31.474
>
  -115.052    31.472
  -115.600    31.474
>
  -115.051    31.472
  -115.600    31.474
>
  -115.051    31.472
  -115.600    31.474
>
  -115.708    32.007
  -115.600    31.474
>
  -115.708    32.007
  -115.600    31.474
>
  -116.099    31.857
  -115.600    31.474
>
  -116.099    31.857
  -115.600    31.474
>
  -116.238    31.340
  -115.600    31.474
>
  -116.238    31.340
  -115.600    31.474
>
  -116.238    31.340
  -115.600    31.474
>
  -116.238    31.340
  -115.600    31.474
>
  -115.284    32.135
  -115.600    31.474
>
  -115.284    32.135
  -115.600    31.474
>
  -115.784    31.391
  -115.601    31.488
>
  -115.784    31.391
  -115.601    31.488
>
  -115.784    31.391
  -115.601    31.488
>
  -115.784    31.391
  -115.601    31.488
>
  -115.052    31.472
  -115.601    31.488
>
  -115.052    31.472
  -115.601    31.488
>
  -115.051    31.472
  -115.601    31.488
>
  -115.051    31.472
  -115.601    31.488
>
  -115.051    31.472
  -115.601    31.488
>
  -115.466    31.046
  -115.601    31.488
>
  -115.466    31.046
  -115.601    31.488
>
  -115.466    31.046
  -115.601    31.488
>
  -115.466    31.046
  -115.601    31.488
>
  -115.466    31.046
  -115.601    31.488
>
  -115.708    32.007
  -115.601    31.488
>
  -115.708    32.007
  -115.601    31.488
>
  -115.708    32.007
  -115.601    31.488
>
  -115.708    32.007
  -115.601    31.488
>
  -116.099    31.857
  -115.601    31.488
>
  -116.099    31.857
  -115.601    31.488
>
  -116.099    31.857
  -115.601    31.488
>
  -116.238    31.340
  -115.601    31.488
>
  -116.238    31.340
  -115.601    31.488
>
  -116.238    31.340
  -115.601    31.488
>
  -115.284    32.135
  -115.601    31.488
>
  -115.284    32.135
  -115.601    31.488
>
  -115.784    31.391
  -115.602    31.484
>
  -115.784    31.391
  -115.602    31.484
>
  -115.466    31.046
  -115.602    31.484
>
  -115.466    31.046
  -115.602    31.484
>
  -115.466    31.046
  -115.602    31.484
>
  -115.051    31.472
  -115.602    31.484
>
  -115.051    31.472
  -115.602    31.484
>
  -115.051    31.472
  -115.602    31.484
>
  -115.708    32.007
  -115.602    31.484
>
  -115.708    32.007
  -115.602    31.484
>
  -116.238    31.340
  -115.602    31.484
>
  -116.238    31.340
  -115.602    31.484
>
  -116.099    31.857
  -115.602    31.484
>
  -116.099    31.857
  -115.602    31.484
>
  -115.784    31.391
  -115.598    31.483
>
  -115.784    31.391
  -115.598    31.483
>
  -115.784    31.391
  -115.598    31.483
>
  -115.466    31.046
  -115.598    31.483
>
  -115.466    31.046
  -115.598    31.483
>
  -115.466    31.046
  -115.598    31.483
>
  -115.052    31.472
  -115.598    31.483
>
  -115.052    31.472
  -115.598    31.483
>
  -115.051    31.472
  -115.598    31.483
>
  -115.051    31.472
  -115.598    31.483
>
  -115.051    31.472
  -115.598    31.483
>
  -115.708    32.007
  -115.598    31.483
>
  -115.708    32.007
  -115.598    31.483
>
  -115.708    32.007
  -115.598    31.483
>
  -116.238    31.340
  -115.598    31.483
>
  -116.238    31.340
  -115.598    31.483
>
  -116.238    31.340
  -115.598    31.483
>
  -116.099    31.857
  -115.598    31.483
>
  -116.099    31.857
  -115.598    31.483
>
  -115.284    32.135
  -115.598    31.483
>
  -115.284    32.135
  -115.598    31.483
>
  -115.784    31.391
  -115.608    31.477
>
  -115.466    31.046
  -115.608    31.477
>
  -115.466    31.046
  -115.608    31.477
>
  -115.466    31.046
  -115.608    31.477
>
  -115.466    31.046
  -115.608    31.477
>
  -115.051    31.472
  -115.608    31.477
>
  -115.051    31.472
  -115.608    31.477
>
  -115.051    31.472
  -115.608    31.477
>
  -115.708    32.007
  -115.608    31.477
>
  -115.708    32.007
  -115.608    31.477
>
  -116.238    31.340
  -115.608    31.477
>
  -116.238    31.340
  -115.608    31.477
>
  -116.099    31.857
  -115.608    31.477
>
  -116.099    31.857
  -115.608    31.477
>
  -115.784    31.391
  -115.600    31.486
>
  -115.784    31.391
  -115.600    31.486
>
  -115.784    31.391
  -115.600    31.486
>
  -115.466    31.046
  -115.600    31.486
>
  -115.466    31.046
  -115.600    31.486
>
  -115.466    31.046
  -115.600    31.486
>
  -115.051    31.472
  -115.600    31.486
>
  -115.051    31.472
  -115.600    31.486
>
  -116.238    31.340
  -115.600    31.486
>
  -116.238    31.340
  -115.600    31.486
>
  -115.708    32.007
  -115.600    31.486
>
  -115.708    32.007
  -115.600    31.486
>
  -116.099    31.857
  -115.600    31.486
>
  -116.099    31.857
  -115.600    31.486
>
  -115.784    31.391
  -115.603    31.504
>
  -115.784    31.391
  -115.603    31.504
>
  -115.466    31.046
  -115.603    31.504
>
  -115.466    31.046
  -115.603    31.504
>
  -115.051    31.472
  -115.603    31.504
>
  -115.051    31.472
  -115.603    31.504
>
  -115.708    32.007
  -115.603    31.504
>
  -115.708    32.007
  -115.603    31.504
>
  -116.099    31.857
  -115.603    31.504
>
  -116.238    31.340
  -115.603    31.504
>
  -116.238    31.340
  -115.603    31.504
>
  -115.284    32.135
  -115.603    31.504
>
  -115.284    32.135
  -115.603    31.504
>
  -115.784    31.391
  -115.603    31.489
>
  -115.784    31.391
  -115.603    31.489
>
  -115.466    31.046
  -115.603    31.489
>
  -115.466    31.046
  -115.603    31.489
>
  -115.466    31.046
  -115.603    31.489
>
  -115.051    31.472
  -115.603    31.489
>
  -115.051    31.472
  -115.603    31.489
>
  -115.051    31.472
  -115.603    31.489
>
  -115.708    32.007
  -115.603    31.489
>
  -116.099    31.857
  -115.603    31.489
>
  -116.238    31.340
  -115.603    31.489
>
  -115.284    32.135
  -115.603    31.489
>
  -115.284    32.135
  -115.603    31.489
>
  -115.784    31.391
  -115.603    31.488
>
  -115.784    31.391
  -115.603    31.488
>
  -115.784    31.391
  -115.603    31.488
>
  -115.784    31.391
  -115.603    31.488
>
  -115.466    31.046
  -115.603    31.488
>
  -115.466    31.046
  -115.603    31.488
>
  -115.466    31.046
  -115.603    31.488
>
  -115.466    31.046
  -115.603    31.488
>
  -115.052    31.472
  -115.603    31.488
>
  -115.052    31.472
  -115.603    31.488
>
  -115.051    31.472
  -115.603    31.488
>
  -115.051    31.472
  -115.603    31.488
>
  -115.708    32.007
  -115.603    31.488
>
  -115.708    32.007
  -115.603    31.488
>
  -115.708    32.007
  -115.603    31.488
>
  -116.099    31.857
  -115.603    31.488
>
  -116.099    31.857
  -115.603    31.488
>
  -116.099    31.857
  -115.603    31.488
>
  -116.099    31.857
  -115.603    31.488
>
  -116.238    31.340
  -115.603    31.488
>
  -116.238    31.340
  -115.603    31.488
>
  -116.238    31.340
  -115.603    31.488
>
  -115.284    32.135
  -115.603    31.488
>
  -115.284    32.135
  -115.603    31.488
>
  -115.784    31.391
  -115.598    31.482
>
  -115.784    31.391
  -115.598    31.482
>
  -115.466    31.046
  -115.598    31.482
>
  -115.466    31.046
  -115.598    31.482
>
  -115.052    31.472
  -115.598    31.482
>
  -115.052    31.472
  -115.598    31.482
>
  -115.051    31.472
  -115.598    31.482
>
  -115.051    31.472
  -115.598    31.482
>
  -115.051    31.472
  -115.598    31.482
>
  -115.708    32.007
  -115.598    31.482
>
  -115.708    32.007
  -115.598    31.482
>
  -115.708    32.007
  -115.598    31.482
>
  -116.238    31.340
  -115.598    31.482
>
  -116.238    31.340
  -115.598    31.482
>
  -116.238    31.340
  -115.598    31.482
>
  -116.099    31.857
  -115.598    31.482
>
  -116.099    31.857
  -115.598    31.482
>
  -115.284    32.135
  -115.598    31.482
>
  -115.284    32.135
  -115.598    31.482
>
  -115.284    32.135
  -115.598    31.482
>
  -115.784    31.391
  -115.597    31.477
>
  -115.784    31.391
  -115.597    31.477
>
  -115.784    31.391
  -115.597    31.477
>
  -115.784    31.391
  -115.597    31.477
>
  -115.466    31.046
  -115.597    31.477
>
  -115.466    31.046
  -115.597    31.477
>
  -115.466    31.046
  -115.597    31.477
>
  -115.051    31.472
  -115.597    31.477
>
  -115.051    31.472
  -115.597    31.477
>
  -116.099    31.857
  -115.597    31.477
>
  -116.099    31.857
  -115.597    31.477
>
  -116.099    31.857
  -115.597    31.477
>
  -116.238    31.340
  -115.597    31.477
>
  -116.238    31.340
  -115.597    31.477
>
  -115.284    32.135
  -115.597    31.477
>
  -115.784    31.391
  -115.595    31.480
>
  -115.784    31.391
  -115.595    31.480
>
  -115.784    31.391
  -115.595    31.480
>
  -115.466    31.046
  -115.595    31.480
>
  -115.466    31.046
  -115.595    31.480
>
  -115.051    31.472
  -115.595    31.480
>
  -115.051    31.472
  -115.595    31.480
>
  -116.238    31.340
  -115.595    31.480
>
  -116.238    31.340
  -115.595    31.480
>
  -115.708    32.007
  -115.595    31.480
>
  -115.708    32.007
  -115.595    31.480
>
  -116.099    31.857
  -115.595    31.480
>
  -116.099    31.857
  -115.595    31.480
>
  -115.784    31.391
  -115.595    31.501
>
  -115.784    31.391
  -115.595    31.501
>
  -115.466    31.046
  -115.595    31.501
>
  -115.466    31.046
  -115.595    31.501
>
  -115.466    31.046
  -115.595    31.501
>
  -115.051    31.472
  -115.595    31.501
>
  -115.051    31.472
  -115.595    31.501
>
  -115.708    32.007
  -115.595    31.501
>
  -115.708    32.007
  -115.595    31.501
>
  -116.099    31.857
  -115.595    31.501
>
  -116.099    31.857
  -115.595    31.501
>
  -115.284    32.135
  -115.595    31.501
>
  -115.284    32.135
  -115.595    31.501
>
  -115.784    31.391
  -115.610    31.482
>
  -115.784    31.391
  -115.610    31.482
>
  -115.784    31.391
  -115.610    31.482
>
  -115.466    31.046
  -115.610    31.482
>
  -115.466    31.046
  -115.610    31.482
>
  -115.466    31.046
  -115.610    31.482
>
  -115.466    31.046
  -115.610    31.482
>
  -115.051    31.472
  -115.610    31.482
>
  -115.051    31.472
  -115.610    31.482
>
  -115.708    32.007
  -115.610    31.482
>
  -115.708    32.007
  -115.610    31.482
>
  -116.238    31.340
  -115.610    31.482
>
  -116.238    31.340
  -115.610    31.482
>
  -116.238    31.340
  -115.610    31.482
>
  -116.099    31.857
  -115.610    31.482
>
  -116.099    31.857
  -115.610    31.482
>
  -115.784    31.391
  -115.866    31.393
>
  -115.784    31.391
  -115.866    31.393
>
  -115.784    31.391
  -115.866    31.393
>
  -115.466    31.046
  -115.866    31.393
>
  -115.466    31.046
  -115.866    31.393
>
  -115.466    31.046
  -115.866    31.393
>
  -116.099    31.857
  -115.866    31.393
>
  -116.099    31.857
  -115.866    31.393
>
  -115.708    32.007
  -115.866    31.393
>
  -115.708    32.007
  -115.866    31.393
>
  -115.051    31.472
  -115.866    31.393
>
  -115.051    31.472
  -115.866    31.393
>
  -115.784    31.391
  -115.645    31.457
>
  -115.784    31.391
  -115.645    31.457
>
  -115.784    31.391
  -115.645    31.457
>
  -115.466    31.046
  -115.645    31.457
>
  -115.466    31.046
  -115.645    31.457
>
  -115.466    31.046
  -115.645    31.457
>
  -115.051    31.472
  -115.645    31.457
>
  -115.051    31.472
  -115.645    31.457
>
  -115.051    31.472
  -115.645    31.457
>
  -116.238    31.340
  -115.645    31.457
>
  -115.708    32.007
  -115.645    31.457
>
  -115.708    32.007
  -115.645    31.457
>
  -115.708    32.007
  -115.645    31.457
>
  -115.708    32.007
  -115.645    31.457
>
  -116.099    31.857
  -115.645    31.457
>
  -116.099    31.857
  -115.645    31.457
>
  -115.784    31.391
  -115.607    31.489
>
  -115.784    31.391
  -115.607    31.489
>
  -115.466    31.046
  -115.607    31.489
>
  -115.466    31.046
  -115.607    31.489
>
  -115.466    31.046
  -115.607    31.489
>
  -115.052    31.472
  -115.607    31.489
>
  -115.052    31.472
  -115.607    31.489
>
  -115.051    31.472
  -115.607    31.489
>
  -115.051    31.472
  -115.607    31.489
>
  -115.051    31.472
  -115.607    31.489
>
  -115.708    32.007
  -115.607    31.489
>
  -115.708    32.007
  -115.607    31.489
>
  -115.708    32.007
  -115.607    31.489
>
  -116.238    31.340
  -115.607    31.489
>
  -116.238    31.340
  -115.607    31.489
>
  -116.238    31.340
  -115.607    31.489
>
  -116.099    31.857
  -115.607    31.489
>
  -116.099    31.857
  -115.607    31.489
>
  -115.284    32.135
  -115.607    31.489
>
  -115.284    32.135
  -115.607    31.489
>
  -115.284    32.135
  -115.607    31.489
>
  -115.784    31.391
  -115.606    31.498
>
  -115.784    31.391
  -115.606    31.498
>
  -115.784    31.391
  -115.606    31.498
>
  -115.784    31.391
  -115.606    31.498
>
  -115.466    31.046
  -115.606    31.498
>
  -115.466    31.046
  -115.606    31.498
>
  -115.466    31.046
  -115.606    31.498
>
  -115.052    31.472
  -115.606    31.498
>
  -115.052    31.472
  -115.606    31.498
>
  -115.051    31.472
  -115.606    31.498
>
  -115.051    31.472
  -115.606    31.498
>
  -115.708    32.007
  -115.606    31.498
>
  -115.708    32.007
  -115.606    31.498
>
  -115.708    32.007
  -115.606    31.498
>
  -116.238    31.340
  -115.606    31.498
>
  -116.238    31.340
  -115.606    31.498
>
  -116.238    31.340
  -115.606    31.498
>
  -116.099    31.857
  -115.606    31.498
>
  -116.099    31.857
  -115.606    31.498
>
  -115.284    32.135
  -115.606    31.498
>
  -115.784    31.391
  -115.604    31.498
>
  -115.784    31.391
  -115.604    31.498
>
  -115.784    31.391
  -115.604    31.498
>
  -115.784    31.391
  -115.604    31.498
>
  -115.784    31.391
  -115.604    31.498
>
  -115.466    31.046
  -115.604    31.498
>
  -115.466    31.046
  -115.604    31.498
>
  -115.052    31.472
  -115.604    31.498
>
  -115.052    31.472
  -115.604    31.498
>
  -115.051    31.472
  -115.604    31.498
>
  -115.051    31.472
  -115.604    31.498
>
  -115.051    31.472
  -115.604    31.498
>
  -115.708    32.007
  -115.604    31.498
>
  -115.708    32.007
  -115.604    31.498
>
  -116.099    31.857
  -115.604    31.498
>
  -116.099    31.857
  -115.604    31.498
>
  -116.238    31.340
  -115.604    31.498
>
  -116.238    31.340
  -115.604    31.498
>
  -115.284    32.135
  -115.604    31.498
>
  -115.284    32.135
  -115.604    31.498
>
  -115.784    31.391
  -115.611    31.505
>
  -115.784    31.391
  -115.611    31.505
>
  -115.466    31.046
  -115.611    31.505
>
  -115.466    31.046
  -115.611    31.505
>
  -115.052    31.472
  -115.611    31.505
>
  -115.052    31.472
  -115.611    31.505
>
  -115.051    31.472
  -115.611    31.505
>
  -115.051    31.472
  -115.611    31.505
>
  -115.051    31.472
  -115.611    31.505
>
  -115.708    32.007
  -115.611    31.505
>
  -115.708    32.007
  -115.611    31.505
>
  -116.099    31.857
  -115.611    31.505
>
  -116.099    31.857
  -115.611    31.505
>
  -116.238    31.340
  -115.611    31.505
>
  -116.238    31.340
  -115.611    31.505
>
  -115.284    32.135
  -115.611    31.505
>
  -115.284    32.135
  -115.611    31.505
>
  -115.284    32.135
  -115.611    31.505
>
  -115.784    31.391
  -115.612    31.491
>
  -115.784    31.391
  -115.612    31.491
>
  -115.466    31.046
  -115.612    31.491
>
  -115.466    31.046
  -115.612    31.491
>
  -115.052    31.472
  -115.612    31.491
>
  -115.052    31.472
  -115.612    31.491
>
  -115.051    31.472
  -115.612    31.491
>
  -115.051    31.472
  -115.612    31.491
>
  -115.051    31.472
  -115.612    31.491
>
  -115.708    32.007
  -115.612    31.491
>
  -115.708    32.007
  -115.612    31.491
>
  -116.099    31.857
  -115.612    31.491
>
  -116.099    31.857
  -115.612    31.491
>
  -116.238    31.340
  -115.612    31.491
>
  -116.238    31.340
  -115.612    31.491
>
  -115.284    32.135
  -115.612    31.491
>
  -115.284    32.135
  -115.612    31.491
>
  -115.284    32.135
  -115.612    31.491
>
  -115.784    31.391
  -115.619    31.503
>
  -115.784    31.391
  -115.619    31.503
>
  -115.784    31.391
  -115.619    31.503
>
  -115.466    31.046
  -115.619    31.503
>
  -115.466    31.046
  -115.619    31.503
>
  -115.466    31.046
  -115.619    31.503
>
  -115.052    31.472
  -115.619    31.503
>
  -115.052    31.472
  -115.619    31.503
>
  -115.051    31.472
  -115.619    31.503
>
  -115.051    31.472
  -115.619    31.503
>
  -115.051    31.472
  -115.619    31.503
>
  -115.708    32.007
  -115.619    31.503
>
  -115.708    32.007
  -115.619    31.503
>
  -116.099    31.857
  -115.619    31.503
>
  -116.099    31.857
  -115.619    31.503
>
  -116.238    31.340
  -115.619    31.503
>
  -116.238    31.340
  -115.619    31.503
>
  -116.238    31.340
  -115.619    31.503
>
  -115.284    32.135
  -115.619    31.503
>
  -115.284    32.135
  -115.619    31.503
>
  -115.284    32.135
  -115.619    31.503
>
  -115.284    32.135
  -115.619    31.503
>
  -115.784    31.391
  -115.602    31.485
>
  -115.784    31.391
  -115.602    31.485
>
  -115.466    31.046
  -115.602    31.485
>
  -115.466    31.046
  -115.602    31.485
>
  -115.466    31.046
  -115.602    31.485
>
  -115.052    31.472
  -115.602    31.485
>
  -115.052    31.472
  -115.602    31.485
>
  -115.051    31.472
  -115.602    31.485
>
  -115.051    31.472
  -115.602    31.485
>
  -115.051    31.472
  -115.602    31.485
>
  -115.708    32.007
  -115.602    31.485
>
  -115.708    32.007
  -115.602    31.485
>
  -116.238    31.340
  -115.602    31.485
>
  -116.238    31.340
  -115.602    31.485
>
  -116.238    31.340
  -115.602    31.485
>
  -116.099    31.857
  -115.602    31.485
>
  -116.099    31.857
  -115.602    31.485
>
  -115.284    32.135
  -115.602    31.485
>
  -115.784    31.391
  -115.606    31.481
>
  -115.784    31.391
  -115.606    31.481
>
  -115.784    31.391
  -115.606    31.481
>
  -115.784    31.391
  -115.606    31.481
>
  -115.784    31.391
  -115.606    31.481
>
  -115.466    31.046
  -115.606    31.481
>
  -115.466    31.046
  -115.606    31.481
>
  -115.466    31.046
  -115.606    31.481
>
  -115.052    31.472
  -115.606    31.481
>
  -115.052    31.472
  -115.606    31.481
>
  -115.051    31.472
  -115.606    31.481
>
  -115.051    31.472
  -115.606    31.481
>
  -115.051    31.472
  -115.606    31.481
>
  -115.051    31.472
  -115.606    31.481
>
  -116.238    31.340
  -115.606    31.481
>
  -116.238    31.340
  -115.606    31.481
>
  -116.238    31.340
  -115.606    31.481
>
  -116.238    31.340
  -115.606    31.481
>
  -115.708    32.007
  -115.606    31.481
>
  -115.708    32.007
  -115.606    31.481
>
  -116.099    31.857
  -115.606    31.481
>
  -116.099    31.857
  -115.606    31.481
>
  -115.284    32.135
  -115.606    31.481
>
  -115.284    32.135
  -115.606    31.481
>
  -115.784    31.391
  -115.607    31.491
>
  -115.784    31.391
  -115.607    31.491
>
  -115.784    31.391
  -115.607    31.491
>
  -115.466    31.046
  -115.607    31.491
>
  -115.466    31.046
  -115.607    31.491
>
  -115.466    31.046
  -115.607    31.491
>
  -115.052    31.472
  -115.607    31.491
>
  -115.052    31.472
  -115.607    31.491
>
  -115.051    31.472
  -115.607    31.491
>
  -115.051    31.472
  -115.607    31.491
>
  -115.708    32.007
  -115.607    31.491
>
  -115.708    32.007
  -115.607    31.491
>
  -116.099    31.857
  -115.607    31.491
>
  -116.099    31.857
  -115.607    31.491
>
  -116.238    31.340
  -115.607    31.491
>
  -116.238    31.340
  -115.607    31.491
>
  -115.284    32.135
  -115.607    31.491
>
  -115.284    32.135
  -115.607    31.491
>
  -115.784    31.391
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.052    31.472
  -115.609    31.496
>
  -115.052    31.472
  -115.609    31.496
>
  -115.051    31.472
  -115.609    31.496
>
  -115.051    31.472
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -116.099    31.857
  -115.609    31.496
>
  -116.099    31.857
  -115.609    31.496
>
  -115.284    32.135
  -115.609    31.496
>
  -115.284    32.135
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.784    31.391
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.466    31.046
  -115.609    31.496
>
  -115.052    31.472
  -115.609    31.496
>
  -115.052    31.472
  -115.609    31.496
>
  -115.051    31.472
  -115.609    31.496
>
  -115.051    31.472
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -115.708    32.007
  -115.609    31.496
>
  -116.099    31.857
  -115.609    31.496
>
  -116.099    31.857
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -116.238    31.340
  -115.609    31.496
>
  -115.284    32.135
  -115.609    31.496
>
  -115.284    32.135
  -115.609    31.496
>
  -116.099    31.857
  -116.194    31.924
>
  -115.708    32.007
  -116.194    31.924
>
  -115.708    32.007
  -116.194    31.924
>
  -115.708    32.007
  -116.194    31.924
>
  -116.725    31.742
  -116.194    31.924
>
  -116.725    31.742
  -116.194    31.924
>
  -116.725    31.742
  -116.194    31.924
>
  -116.664    32.313
  -116.194    31.924
>
  -116.664    32.313
  -116.194    31.924
>
  -116.664    32.313
  -116.194    31.924
>
  -116.238    31.340
  -116.194    31.924
>
  -116.238    31.340
  -116.194    31.924
>
  -115.784    31.391
  -116.194    31.924
>
  -115.784    31.391
  -116.194    31.924
>
  -115.784    31.391
  -116.194    31.924
>
  -115.784    31.391
  -116.194    31.924
>
  -115.784    31.391
  -116.194    31.924
>
  -116.109    32.650
  -116.194    31.924
>
  -116.109    32.650
  -116.194    31.924
>
  -116.607    32.569
  -116.194    31.924
>
  -116.607    32.569
  -116.194    31.924
>
  -116.607    32.569
  -116.194    31.924
>
  -116.607    32.569
  -116.194    31.924
>
  -116.366    32.651
  -116.194    31.924
>
  -116.366    32.651
  -116.194    31.924
>
  -116.485    32.643
  -116.194    31.924
>
  -116.485    32.643
  -116.194    31.924
>
  -115.922    32.647
  -116.194    31.924
>
  -115.922    32.647
  -116.194    31.924
>
  -115.784    31.391
  -115.605    31.507
>
  -115.784    31.391
  -115.605    31.507
>
  -115.784    31.391
  -115.605    31.507
>
  -115.466    31.046
  -115.605    31.507
>
  -115.466    31.046
  -115.605    31.507
>
  -115.051    31.472
  -115.605    31.507
>
  -115.051    31.472
  -115.605    31.507
>
  -115.051    31.472
  -115.605    31.507
>
  -115.708    32.007
  -115.605    31.507
>
  -115.708    32.007
  -115.605    31.507
>
  -116.099    31.857
  -115.605    31.507
>
  -116.099    31.857
  -115.605    31.507
>
  -116.238    31.340
  -115.605    31.507
>
  -116.238    31.340
  -115.605    31.507
>
  -115.284    32.135
  -115.605    31.507
>
  -115.784    31.391
  -115.611    31.486
>
  -115.784    31.391
  -115.611    31.486
>
  -115.784    31.391
  -115.611    31.486
>
  -115.466    31.046
  -115.611    31.486
>
  -115.466    31.046
  -115.611    31.486
>
  -115.466    31.046
  -115.611    31.486
>
  -115.052    31.472
  -115.611    31.486
>
  -115.052    31.472
  -115.611    31.486
>
  -115.051    31.472
  -115.611    31.486
>
  -115.051    31.472
  -115.611    31.486
>
  -115.051    31.472
  -115.611    31.486
>
  -115.051    31.472
  -115.611    31.486
>
  -115.708    32.007
  -115.611    31.486
>
  -115.708    32.007
  -115.611    31.486
>
  -115.708    32.007
  -115.611    31.486
>
  -115.708    32.007
  -115.611    31.486
>
  -116.238    31.340
  -115.611    31.486
>
  -116.238    31.340
  -115.611    31.486
>
  -116.238    31.340
  -115.611    31.486
>
  -115.284    32.135
  -115.611    31.486
>
  -115.284    32.135
  -115.611    31.486
>
  -115.784    31.391
  -115.613    31.501
>
  -115.784    31.391
  -115.613    31.501
>
  -115.784    31.391
  -115.613    31.501
>
  -115.466    31.046
  -115.613    31.501
>
  -115.466    31.046
  -115.613    31.501
>
  -115.052    31.472
  -115.613    31.501
>
  -115.052    31.472
  -115.613    31.501
>
  -115.051    31.472
  -115.613    31.501
>
  -115.051    31.472
  -115.613    31.501
>
  -115.051    31.472
  -115.613    31.501
>
  -115.708    32.007
  -115.613    31.501
>
  -115.708    32.007
  -115.613    31.501
>
  -115.708    32.007
  -115.613    31.501
>
  -116.099    31.857
  -115.613    31.501
>
  -116.099    31.857
  -115.613    31.501
>
  -116.099    31.857
  -115.613    31.501
>
  -116.238    31.340
  -115.613    31.501
>
  -116.238    31.340
  -115.613    31.501
>
  -116.238    31.340
  -115.613    31.501
>
  -115.284    32.135
  -115.613    31.501
>
  -115.284    32.135
  -115.613    31.501
>
  -115.284    32.135
  -115.613    31.501
>
  -115.466    31.046
  -115.603    31.496
>
  -115.466    31.046
  -115.603    31.496
>
  -116.238    31.340
  -115.603    31.496
>
  -116.238    31.340
  -115.603    31.496
>
  -115.052    31.472
  -115.603    31.496
>
  -115.052    31.472
  -115.603    31.496
>
  -115.051    31.472
  -115.603    31.496
>
  -115.051    31.472
  -115.603    31.496
>
  -115.708    32.007
  -115.603    31.496
>
  -115.708    32.007
  -115.603    31.496
>
  -116.238    31.340
  -115.981    31.600
>
  -115.784    31.391
  -115.981    31.600
>
  -115.784    31.391
  -115.981    31.600
>
  -115.784    31.391
  -115.981    31.600
>
  -115.708    32.007
  -115.981    31.600
>
  -115.708    32.007
  -115.981    31.600
>
  -115.708    32.007
  -115.981    31.600
>
  -115.708    32.007
  -115.981    31.600
>
  -116.725    31.742
  -115.981    31.600
>
  -116.725    31.742
  -115.981    31.600
>
  -115.466    31.046
  -115.981    31.600
>
  -115.466    31.046
  -115.981    31.600
>
  -115.466    31.046
  -115.981    31.600
>
  -115.466    31.046
  -115.981    31.600
>
  -115.284    32.135
  -115.981    31.600
>
  -115.284    32.135
  -115.981    31.600
>
  -115.284    32.135
  -115.981    31.600
>
  -115.784    31.391
  -115.946    31.702
>
  -115.784    31.391
  -115.946    31.702
>
  -116.099    31.857
  -115.946    31.702
>
  -116.099    31.857
  -115.946    31.702
>
  -116.238    31.340
  -115.946    31.702
>
  -116.238    31.340
  -115.946    31.702
>
  -115.708    32.007
  -115.946    31.702
>
  -115.708    32.007
  -115.946    31.702
>
  -116.725    31.742
  -115.946    31.702
>
  -116.725    31.742
  -115.946    31.702
>
  -115.466    31.046
  -115.946    31.702
>
  -115.466    31.046
  -115.946    31.702
>
  -115.051    31.472
  -115.946    31.702
>
  -115.051    31.472
  -115.946    31.702
>
  -115.784    31.391
  -115.608    31.501
>
  -115.784    31.391
  -115.608    31.501
>
  -115.784    31.391
  -115.608    31.501
>
  -115.784    31.391
  -115.608    31.501
>
  -115.052    31.472
  -115.608    31.501
>
  -115.052    31.472
  -115.608    31.501
>
  -115.051    31.472
  -115.608    31.501
>
  -115.051    31.472
  -115.608    31.501
>
  -115.051    31.472
  -115.608    31.501
>
  -115.466    31.046
  -115.608    31.501
>
  -115.466    31.046
  -115.608    31.501
>
  -115.466    31.046
  -115.608    31.501
>
  -115.708    32.007
  -115.608    31.501
>
  -115.708    32.007
  -115.608    31.501
>
  -115.708    32.007
  -115.608    31.501
>
  -116.099    31.857
  -115.608    31.501
>
  -116.099    31.857
  -115.608    31.501
>
  -116.099    31.857
  -115.608    31.501
>
  -116.099    31.857
  -115.608    31.501
>
  -116.238    31.340
  -115.608    31.501
>
  -116.238    31.340
  -115.608    31.501
>
  -115.284    32.135
  -115.608    31.501
>
  -115.284    32.135
  -115.608    31.501
>
  -115.284    32.135
  -115.608    31.501
>
  -115.284    32.135
  -115.608    31.501
>
  -115.284    32.135
  -115.608    31.501
>
  -115.784    31.391
  -115.608    31.510
>
  -115.784    31.391
  -115.608    31.510
>
  -115.784    31.391
  -115.608    31.510
>
  -115.052    31.472
  -115.608    31.510
>
  -115.052    31.472
  -115.608    31.510
>
  -115.051    31.472
  -115.608    31.510
>
  -115.051    31.472
  -115.608    31.510
>
  -115.051    31.472
  -115.608    31.510
>
  -115.466    31.046
  -115.608    31.510
>
  -115.466    31.046
  -115.608    31.510
>
  -115.708    32.007
  -115.608    31.510
>
  -115.708    32.007
  -115.608    31.510
>
  -116.099    31.857
  -115.608    31.510
>
  -116.099    31.857
  -115.608    31.510
>
  -116.238    31.340
  -115.608    31.510
>
  -116.238    31.340
  -115.608    31.510
>
  -116.238    31.340
  -115.608    31.510
>
  -115.284    32.135
  -115.608    31.510
>
  -115.284    32.135
  -115.608    31.510
>
  -115.784    31.391
  -115.607    31.500
>
  -115.784    31.391
  -115.607    31.500
>
  -115.784    31.391
  -115.607    31.500
>
  -115.784    31.391
  -115.607    31.500
>
  -115.466    31.046
  -115.607    31.500
>
  -115.466    31.046
  -115.607    31.500
>
  -115.466    31.046
  -115.607    31.500
>
  -115.052    31.472
  -115.607    31.500
>
  -115.052    31.472
  -115.607    31.500
>
  -115.051    31.472
  -115.607    31.500
>
  -115.051    31.472
  -115.607    31.500
>
  -115.708    32.007
  -115.607    31.500
>
  -115.708    32.007
  -115.607    31.500
>
  -115.708    32.007
  -115.607    31.500
>
  -116.099    31.857
  -115.607    31.500
>
  -116.099    31.857
  -115.607    31.500
>
  -116.238    31.340
  -115.607    31.500
>
  -116.238    31.340
  -115.607    31.500
>
  -116.238    31.340
  -115.607    31.500
>
  -115.284    32.135
  -115.607    31.500
>
  -115.284    32.135
  -115.607    31.500
>
  -116.099    31.857
  -115.965    31.606
>
  -116.099    31.857
  -115.965    31.606
>
  -115.784    31.391
  -115.965    31.606
>
  -115.784    31.391
  -115.965    31.606
>
  -115.784    31.391
  -115.965    31.606
>
  -115.784    31.391
  -115.965    31.606
>
  -116.238    31.340
  -115.965    31.606
>
  -116.238    31.340
  -115.965    31.606
>
  -116.238    31.340
  -115.965    31.606
>
  -115.708    32.007
  -115.965    31.606
>
  -115.708    32.007
  -115.965    31.606
>
  -115.708    32.007
  -115.965    31.606
>
  -116.663    31.868
  -115.965    31.606
>
  -116.663    31.868
  -115.965    31.606
>
  -116.663    31.868
  -115.965    31.606
>
  -116.725    31.742
  -115.965    31.606
>
  -116.725    31.742
  -115.965    31.606
>
  -116.725    31.742
  -115.965    31.606
>
  -115.466    31.046
  -115.965    31.606
>
  -115.466    31.046
  -115.965    31.606
>
  -115.466    31.046
  -115.965    31.606
>
  -115.284    32.135
  -115.965    31.606
>
  -115.284    32.135
  -115.965    31.606
>
  -115.052    31.472
  -115.965    31.606
>
  -115.052    31.472
  -115.965    31.606
>
  -115.051    31.472
  -115.965    31.606
>
  -115.051    31.472
  -115.965    31.606
>
EOF
# Seismic stations used for direct calibration, marked by a triangle
gmt plot $proj $reg -St -Wthick,black -Gblack << EOF
  -115.942    31.928     0.300
  -116.660    31.869     0.300
  -116.663    31.884     0.300
  -116.664    32.313     0.300
  -115.242    31.988     0.300
  -116.598    31.657     0.300
  -115.051    31.472     0.300
  -116.442    31.962     0.300
  -115.725    32.649     0.300
  -115.923    32.648     0.300
  -115.464    31.045     0.300
  -116.663    31.868     0.300
  -116.725    31.742     0.300
  -116.273    31.514     0.300
  -115.466    31.046     0.300
  -115.876    30.576     0.300
  -115.948    32.005     0.300
  -115.784    31.391     0.300
  -116.251    31.327     0.300
  -116.675    32.433     0.300
  -116.029    32.553     0.300
  -115.304    32.418     0.300
  -115.076    32.303     0.300
  -116.109    32.650     0.300
  -116.607    32.569     0.300
  -115.708    32.007     0.300
  -115.284    32.135     0.300
  -116.238    31.340     0.300
  -116.301    32.020     0.300
  -115.816    31.871     0.300
  -115.841    32.116     0.300
  -115.922    32.647     0.300
  -116.775    32.607     0.300
  -116.099    31.857     0.300
  -115.581    32.537     0.300
  -115.198    32.407     0.300
  -114.961    32.166     0.300
  -115.445    32.632     0.300
  -115.145    32.473     0.300
  -115.161    32.266     0.300
  -114.745    31.959     0.300
  -116.099    31.857     0.300
  -114.745    31.960     0.300
  -115.052    31.472     0.300
  -116.366    32.651     0.300
  -116.485    32.643     0.300
EOF
# S-P stations used for direct calibration, marked by an open diamond
gmt plot $proj $reg -Sd -Wthick << EOF
EOF
# Cluster events, marked by open black circles
gmt plot $proj $reg -Sc -Wthick,black << EOF
  -116.126    31.767     0.200
>
  -115.691    31.768     0.200
>
  -115.602    31.253     0.200
>
  -115.593    31.284     0.200
>
  -115.720    31.889     0.200
>
  -115.587    31.205     0.200
>
  -115.575    31.607     0.200
>
  -116.196    31.852     0.200
>
  -116.296    31.832     0.200
>
  -116.235    31.807     0.200
>
  -115.969    31.693     0.200
>
  -116.178    31.769     0.200
>
  -116.299    31.851     0.200
>
  -115.980    31.627     0.200
>
  -115.647    31.279     0.200
>
  -115.662    31.276     0.200
>
  -115.658    31.282     0.200
>
  -115.667    31.269     0.200
>
  -115.656    31.276     0.200
>
  -115.659    31.259     0.200
>
  -115.641    31.272     0.200
>
  -116.040    31.394     0.200
>
  -115.663    31.263     0.200
>
  -115.663    31.268     0.200
>
  -115.674    31.261     0.200
>
  -115.657    31.270     0.200
>
  -115.664    31.254     0.200
>
  -115.681    31.269     0.200
>
  -115.681    31.268     0.200
>
  -115.660    31.273     0.200
>
  -116.098    31.757     0.200
>
  -115.643    31.257     0.200
>
  -115.607    31.212     0.200
>
  -115.623    31.246     0.200
>
  -115.615    31.239     0.200
>
  -115.669    31.269     0.200
>
  -116.033    31.785     0.200
>
  -115.519    31.524     0.200
>
  -115.849    31.571     0.200
>
  -115.921    31.685     0.200
>
  -115.622    31.576     0.200
>
  -115.918    31.685     0.200
>
  -115.937    31.231     0.200
>
  -115.933    31.248     0.200
>
  -116.139    31.580     0.200
>
  -115.915    31.239     0.200
>
  -115.507    31.555     0.200
>
  -115.412    31.109     0.200
>
  -115.509    31.535     0.200
>
  -115.480    31.561     0.200
>
  -115.487    31.551     0.200
>
  -115.495    31.545     0.200
>
  -115.932    31.238     0.200
>
  -116.201    31.834     0.200
>
  -115.470    31.498     0.200
>
  -116.252    31.760     0.200
>
  -115.934    31.241     0.200
>
  -115.492    31.484     0.200
>
  -115.594    31.567     0.200
>
  -115.317    31.435     0.200
>
  -115.676    31.799     0.200
>
  -115.627    31.533     0.200
>
  -115.637    31.521     0.200
>
  -115.640    31.519     0.200
>
  -115.636    31.520     0.200
>
  -115.921    31.639     0.200
>
  -115.889    31.226     0.200
>
  -115.632    31.553     0.200
>
  -115.414    31.306     0.200
>
  -115.449    31.305     0.200
>
  -115.987    31.629     0.200
>
  -115.491    31.528     0.200
>
  -116.188    31.865     0.200
>
  -115.680    30.811     0.200
>
  -115.587    31.586     0.200
>
  -116.086    31.228     0.200
>
  -116.053    31.769     0.200
>
  -115.329    31.265     0.200
>
  -116.105    31.801     0.200
>
  -116.104    31.801     0.200
>
  -116.013    31.615     0.200
>
  -115.667    31.264     0.200
>
  -115.373    31.344     0.200
>
  -115.990    31.615     0.200
>
  -116.109    31.849     0.200
>
  -115.811    31.619     0.200
>
  -115.252    30.966     0.200
>
  -116.101    31.805     0.200
>
  -115.591    31.522     0.200
>
  -116.281    31.942     0.200
>
  -115.808    31.906     0.200
>
  -115.817    31.908     0.200
>
  -115.818    31.909     0.200
>
  -115.558    31.780     0.200
>
  -115.811    31.899     0.200
>
  -115.818    31.916     0.200
>
  -115.717    31.306     0.200
>
  -116.154    31.717     0.200
>
  -116.206    31.826     0.200
>
  -115.624    31.508     0.200
>
  -115.626    31.516     0.200
>
  -115.634    31.506     0.200
>
  -115.633    31.509     0.200
>
  -115.631    31.491     0.200
>
  -115.643    31.490     0.200
>
  -115.615    31.515     0.200
>
  -115.831    31.626     0.200
>
  -115.660    31.529     0.200
>
  -115.629    31.508     0.200
>
  -115.986    31.628     0.200
>
  -115.627    31.499     0.200
>
  -115.611    31.376     0.200
>
  -115.640    31.501     0.200
>
  -116.239    31.738     0.200
>
  -115.621    31.532     0.200
>
  -116.033    31.696     0.200
>
  -115.612    31.481     0.200
>
  -115.342    31.455     0.200
>
  -115.633    31.494     0.200
>
  -115.988    31.600     0.200
>
  -116.172    31.859     0.200
>
  -115.343    31.454     0.200
>
  -115.684    31.553     0.200
>
  -115.939    31.663     0.200
>
  -115.971    30.844     0.200
>
  -115.677    31.564     0.200
>
  -115.672    31.560     0.200
>
  -115.666    31.575     0.200
>
  -115.688    31.576     0.200
>
  -115.678    31.563     0.200
>
  -115.334    31.438     0.200
>
  -115.477    31.511     0.200
>
  -115.660    31.540     0.200
>
  -115.663    31.546     0.200
>
  -115.382    31.424     0.200
>
  -115.635    31.500     0.200
>
  -116.091    31.889     0.200
>
  -115.405    31.363     0.200
>
  -115.398    31.362     0.200
>
  -115.389    31.422     0.200
>
  -115.600    31.474     0.200
>
  -115.601    31.488     0.200
>
  -115.602    31.484     0.200
>
  -115.598    31.483     0.200
>
  -115.608    31.477     0.200
>
  -115.600    31.486     0.200
>
  -115.603    31.504     0.200
>
  -115.603    31.489     0.200
>
  -115.603    31.488     0.200
>
  -115.598    31.482     0.200
>
  -115.597    31.477     0.200
>
  -115.595    31.480     0.200
>
  -115.595    31.501     0.200
>
  -115.610    31.482     0.200
>
  -115.866    31.393     0.200
>
  -115.645    31.457     0.200
>
  -115.607    31.489     0.200
>
  -115.606    31.498     0.200
>
  -115.604    31.498     0.200
>
  -115.611    31.505     0.200
>
  -115.612    31.491     0.200
>
  -115.619    31.503     0.200
>
  -115.602    31.485     0.200
>
  -115.606    31.481     0.200
>
  -115.607    31.491     0.200
>
  -115.609    31.496     0.200
>
  -115.609    31.496     0.200
>
  -116.194    31.924     0.200
>
  -115.605    31.507     0.200
>
  -115.611    31.486     0.200
>
  -115.613    31.501     0.200
>
  -115.603    31.496     0.200
>
  -115.981    31.600     0.200
>
  -115.946    31.702     0.200
>
  -115.608    31.501     0.200
>
  -115.608    31.510     0.200
>
  -115.607    31.500     0.200
>
  -115.965    31.606     0.200
>
EOF
# Circle of radius 1 and 2 degrees
gmt plot $proj $reg -SE -Wthicker,red << EOF
  -115.730    31.513     0.000   222.000   222.000
  -115.730    31.513     0.000   444.000   444.000
EOF
gmt end
