#!/bin/bash
gmt begin alberchigos1.34_base pdf,ps
proj=-JM16.0c+
reg=-R-116.4/-115.2/30.7/32.0
gmt basemap $proj $reg -Bxa0.5f0.1 -Bya0.5f0.1 -BWeSn+t'Base Map alberchigos1.34'

# Standard Topography
palette=-Ctables/gmt/cpt/topo.cpt
dem=tables/gmt/dem/earth_relief_01m_g.grd
gmt grdcut $dem -Gmloc.grd $reg
gmt grdgradient mloc.grd -Gmloc_ilum.grd -A340 -Nt
gmt grdimage mloc.grd $palette $proj -Imloc_ilum.grd
rm mloc.grd mloc_ilum.grd

# Coastlines and rivers
gmt coast $proj $reg -Df -Ia/blue -Wblue

# Event numbers
gmt text $proj $reg -F+f8p+jCM << EOF
  -116.126    31.767 1
  -115.691    31.768 2
  -115.602    31.253 3
  -115.593    31.284 4
  -115.720    31.889 5
  -115.587    31.205 6
  -115.575    31.607 7
  -116.196    31.852 8
  -116.296    31.832 9
  -116.235    31.807 10
  -115.969    31.693 11
  -116.178    31.769 12
  -116.299    31.851 13
  -115.980    31.627 14
  -115.647    31.279 15
  -115.662    31.276 16
  -115.658    31.282 17
  -115.667    31.269 18
  -115.656    31.276 19
  -115.659    31.259 20
  -115.641    31.272 21
  -116.040    31.394 22
  -115.663    31.263 23
  -115.663    31.268 24
  -115.674    31.261 25
  -115.657    31.270 26
  -115.664    31.254 27
  -115.681    31.269 28
  -115.681    31.268 29
  -115.660    31.273 30
  -116.098    31.757 31
  -115.643    31.257 32
  -115.607    31.212 33
  -115.623    31.246 34
  -115.615    31.239 35
  -115.669    31.269 36
  -116.033    31.785 37
  -115.519    31.524 38
  -115.849    31.571 39
  -115.921    31.685 40
  -115.622    31.576 41
  -115.918    31.685 42
  -115.937    31.231 43
  -115.933    31.248 44
  -116.139    31.580 45
  -115.915    31.239 46
  -115.507    31.555 47
  -115.412    31.109 48
  -115.509    31.535 49
  -115.480    31.561 50
  -115.487    31.551 51
  -115.495    31.545 52
  -115.932    31.238 53
  -116.201    31.834 54
  -115.470    31.498 55
  -116.252    31.760 56
  -115.934    31.241 57
  -115.492    31.484 58
  -115.594    31.567 59
  -115.317    31.435 60
  -115.676    31.799 61
  -115.627    31.533 62
  -115.637    31.521 63
  -115.640    31.519 64
  -115.636    31.520 65
  -115.921    31.639 66
  -115.889    31.226 67
  -115.632    31.553 68
  -115.414    31.306 69
  -115.449    31.305 70
  -115.987    31.629 71
  -115.491    31.528 72
  -116.188    31.865 73
  -115.680    30.811 74
  -115.587    31.586 75
  -116.086    31.228 76
  -116.053    31.769 77
  -115.329    31.265 78
  -116.105    31.801 79
  -116.104    31.801 80
  -116.013    31.615 81
  -115.667    31.264 82
  -115.373    31.344 83
  -115.990    31.615 84
  -116.109    31.849 85
  -115.811    31.619 86
  -115.252    30.966 87
  -116.101    31.805 88
  -115.591    31.522 89
  -116.281    31.942 90
  -115.808    31.906 91
  -115.817    31.908 92
  -115.818    31.909 93
  -115.558    31.780 94
  -115.811    31.899 95
  -115.818    31.916 96
  -115.717    31.306 97
  -116.154    31.717 98
  -116.206    31.826 99
  -115.624    31.508 100
  -115.626    31.516 101
  -115.634    31.506 102
  -115.633    31.509 103
  -115.631    31.491 104
  -115.643    31.490 105
  -115.615    31.515 106
  -115.831    31.626 107
  -115.660    31.529 108
  -115.629    31.508 109
  -115.986    31.628 110
  -115.627    31.499 111
  -115.611    31.376 112
  -115.640    31.501 113
  -116.239    31.738 114
  -115.621    31.532 115
  -116.033    31.696 116
  -115.612    31.481 117
  -115.342    31.455 118
  -115.633    31.494 119
  -115.988    31.600 120
  -116.172    31.859 121
  -115.343    31.454 122
  -115.684    31.553 123
  -115.939    31.663 124
  -115.971    30.844 125
  -115.677    31.564 126
  -115.672    31.560 127
  -115.666    31.575 128
  -115.688    31.576 129
  -115.678    31.563 130
  -115.334    31.438 131
  -115.477    31.511 132
  -115.660    31.540 133
  -115.663    31.546 134
  -115.382    31.424 135
  -115.635    31.500 136
  -116.091    31.889 137
  -115.405    31.363 138
  -115.398    31.362 139
  -115.389    31.422 140
  -115.600    31.474 141
  -115.601    31.488 142
  -115.602    31.484 143
  -115.598    31.483 144
  -115.608    31.477 145
  -115.600    31.486 146
  -115.603    31.504 147
  -115.603    31.489 148
  -115.603    31.488 149
  -115.598    31.482 150
  -115.597    31.477 151
  -115.595    31.480 152
  -115.595    31.501 153
  -115.610    31.482 154
  -115.866    31.393 155
  -115.645    31.457 156
  -115.607    31.489 157
  -115.606    31.498 158
  -115.604    31.498 159
  -115.611    31.505 160
  -115.612    31.491 161
  -115.619    31.503 162
  -115.602    31.485 163
  -115.606    31.481 164
  -115.607    31.491 165
  -115.609    31.496 166
  -115.609    31.496 167
  -116.194    31.924 168
  -115.605    31.507 169
  -115.611    31.486 170
  -115.613    31.501 171
  -115.603    31.496 172
  -115.981    31.600 173
  -115.946    31.702 174
  -115.608    31.501 175
  -115.608    31.510 176
  -115.607    31.500 177
  -115.965    31.606 178
EOF

# Change in location from data file input locations in black
gmt plot $proj $reg -Wthin,black << EOF
  -116.206    31.752
  -116.126    31.767
>
  -115.787    31.814
  -115.691    31.768
>
  -115.715    31.273
  -115.602    31.253
>
  -115.640    31.251
  -115.593    31.284
>
  -115.770    31.897
  -115.720    31.889
>
  -115.669    31.127
  -115.587    31.205
>
  -115.579    31.522
  -115.575    31.607
>
  -116.190    31.869
  -116.196    31.852
>
  -116.294    31.819
  -116.296    31.832
>
  -116.263    31.773
  -116.235    31.807
>
  -115.955    31.700
  -115.969    31.693
>
  -116.201    31.710
  -116.178    31.769
>
  -116.294    31.818
  -116.299    31.851
>
  -115.972    31.652
  -115.980    31.627
>
  -115.640    31.290
  -115.647    31.279
>
  -115.659    31.272
  -115.662    31.276
>
  -115.648    31.280
  -115.658    31.282
>
  -115.664    31.303
  -115.667    31.269
>
  -115.652    31.239
  -115.656    31.276
>
  -115.730    31.282
  -115.659    31.259
>
  -115.658    31.294
  -115.641    31.272
>
  -116.027    31.404
  -116.040    31.394
>
  -115.664    31.288
  -115.663    31.263
>
  -115.670    31.224
  -115.663    31.268
>
  -115.655    31.242
  -115.674    31.261
>
  -115.649    31.234
  -115.657    31.270
>
  -115.721    31.219
  -115.664    31.254
>
  -115.640    31.258
  -115.681    31.269
>
  -115.684    31.254
  -115.681    31.268
>
  -115.642    31.294
  -115.660    31.273
>
  -116.072    31.790
  -116.098    31.757
>
  -115.674    31.252
  -115.643    31.257
>
  -115.476    31.195
  -115.607    31.212
>
  -115.616    31.262
  -115.623    31.246
>
  -115.628    31.223
  -115.615    31.239
>
  -115.659    31.270
  -115.669    31.269
>
  -116.005    31.804
  -116.033    31.785
>
  -115.539    31.494
  -115.519    31.524
>
  -115.831    31.565
  -115.849    31.571
>
  -115.934    31.675
  -115.921    31.685
>
  -115.564    31.557
  -115.622    31.576
>
  -115.917    31.731
  -115.918    31.685
>
  -115.979    31.175
  -115.937    31.231
>
  -115.886    31.285
  -115.933    31.248
>
  -116.146    31.563
  -116.139    31.580
>
  -115.868    31.261
  -115.915    31.239
>
  -115.516    31.543
  -115.507    31.555
>
  -115.436    31.114
  -115.412    31.109
>
  -115.485    31.550
  -115.509    31.535
>
  -115.502    31.563
  -115.480    31.561
>
  -115.463    31.565
  -115.487    31.551
>
  -115.465    31.564
  -115.495    31.545
>
  -115.923    31.236
  -115.932    31.238
>
  -116.190    31.838
  -116.201    31.834
>
  -115.490    31.511
  -115.470    31.498
>
  -116.258    31.744
  -116.252    31.760
>
  -115.905    31.294
  -115.934    31.241
>
  -115.523    31.455
  -115.492    31.484
>
  -115.621    31.570
  -115.594    31.567
>
  -115.354    31.437
  -115.317    31.435
>
  -115.696    31.782
  -115.676    31.799
>
  -115.641    31.541
  -115.627    31.533
>
  -115.656    31.532
  -115.637    31.521
>
  -115.642    31.459
  -115.640    31.519
>
  -115.642    31.518
  -115.636    31.520
>
  -115.922    31.621
  -115.921    31.639
>
  -116.003    31.056
  -115.889    31.226
>
  -115.645    31.559
  -115.632    31.553
>
  -115.424    31.282
  -115.414    31.306
>
  -115.464    31.235
  -115.449    31.305
>
  -116.016    31.582
  -115.987    31.629
>
  -115.498    31.533
  -115.491    31.528
>
  -116.176    31.859
  -116.188    31.865
>
  -115.565    30.882
  -115.680    30.811
>
  -115.582    31.587
  -115.587    31.586
>
  -116.092    31.222
  -116.086    31.228
>
  -116.057    31.765
  -116.053    31.769
>
  -115.355    31.245
  -115.329    31.265
>
  -116.130    31.784
  -116.105    31.801
>
  -116.116    31.809
  -116.104    31.801
>
  -116.025    31.591
  -116.013    31.615
>
  -115.669    31.222
  -115.667    31.264
>
  -115.370    31.333
  -115.373    31.344
>
  -116.001    31.595
  -115.990    31.615
>
  -116.145    31.844
  -116.109    31.849
>
  -115.795    31.627
  -115.811    31.619
>
  -115.241    30.926
  -115.252    30.966
>
  -116.111    31.802
  -116.101    31.805
>
  -115.612    31.528
  -115.591    31.522
>
  -116.290    31.932
  -116.281    31.942
>
  -115.806    31.910
  -115.808    31.906
>
  -115.798    31.913
  -115.817    31.908
>
  -115.860    31.869
  -115.818    31.909
>
  -115.607    31.769
  -115.558    31.780
>
  -115.812    31.905
  -115.811    31.899
>
  -115.844    31.897
  -115.818    31.916
>
  -115.771    31.286
  -115.717    31.306
>
  -116.191    31.696
  -116.154    31.717
>
  -116.199    31.817
  -116.206    31.826
>
  -115.663    31.507
  -115.624    31.508
>
  -115.613    31.591
  -115.626    31.516
>
  -115.668    31.490
  -115.634    31.506
>
  -115.635    31.513
  -115.633    31.509
>
  -115.641    31.490
  -115.631    31.491
>
  -115.647    31.449
  -115.643    31.490
>
  -115.627    31.509
  -115.615    31.515
>
  -115.866    31.624
  -115.831    31.626
>
  -115.681    31.516
  -115.660    31.529
>
  -115.641    31.491
  -115.629    31.508
>
  -116.013    31.601
  -115.986    31.628
>
  -115.650    31.481
  -115.627    31.499
>
  -115.528    31.368
  -115.611    31.376
>
  -115.651    31.490
  -115.640    31.501
>
  -116.251    31.723
  -116.239    31.738
>
  -115.630    31.515
  -115.621    31.532
>
  -116.034    31.649
  -116.033    31.696
>
  -115.646    31.499
  -115.612    31.481
>
  -115.357    31.416
  -115.342    31.455
>
  -115.651    31.482
  -115.633    31.494
>
  -116.033    31.587
  -115.988    31.600
>
  -116.178    31.852
  -116.172    31.859
>
  -115.361    31.393
  -115.343    31.454
>
  -115.707    31.553
  -115.684    31.553
>
  -115.992    31.633
  -115.939    31.663
>
  -115.965    30.836
  -115.971    30.844
>
  -115.694    31.567
  -115.677    31.564
>
  -115.682    31.559
  -115.672    31.560
>
  -115.626    31.575
  -115.666    31.575
>
  -115.692    31.573
  -115.688    31.576
>
  -115.807    31.494
  -115.678    31.563
>
  -115.351    31.429
  -115.334    31.438
>
  -115.480    31.481
  -115.477    31.511
>
  -115.672    31.544
  -115.660    31.540
>
  -115.690    31.538
  -115.663    31.546
>
  -115.390    31.391
  -115.382    31.424
>
  -115.639    31.489
  -115.635    31.500
>
  -116.067    31.899
  -116.091    31.889
>
  -115.398    31.349
  -115.405    31.363
>
  -115.350    31.287
  -115.398    31.362
>
  -115.383    31.409
  -115.389    31.422
>
  -115.585    31.488
  -115.600    31.474
>
  -115.548    31.508
  -115.601    31.488
>
  -115.604    31.482
  -115.602    31.484
>
  -115.619    31.480
  -115.598    31.483
>
  -115.524    31.421
  -115.608    31.477
>
  -115.551    31.403
  -115.600    31.486
>
  -115.604    31.496
  -115.603    31.504
>
  -115.603    31.486
  -115.603    31.489
>
  -115.618    31.490
  -115.603    31.488
>
  -115.622    31.483
  -115.598    31.482
>
  -115.612    31.502
  -115.597    31.477
>
  -115.507    31.387
  -115.595    31.480
>
  -115.560    31.395
  -115.595    31.501
>
  -115.520    31.414
  -115.610    31.482
>
  -115.850    31.396
  -115.866    31.393
>
  -115.562    31.370
  -115.645    31.457
>
  -115.617    31.487
  -115.607    31.489
>
  -115.554    31.463
  -115.606    31.498
>
  -115.611    31.499
  -115.604    31.498
>
  -115.627    31.492
  -115.611    31.505
>
  -115.626    31.493
  -115.612    31.491
>
  -115.620    31.494
  -115.619    31.503
>
  -115.603    31.476
  -115.602    31.485
>
  -115.622    31.466
  -115.606    31.481
>
  -115.620    31.496
  -115.607    31.491
>
  -115.545    31.441
  -115.609    31.496
>
  -115.633    31.500
  -115.609    31.496
>
  -116.201    31.922
  -116.194    31.924
>
  -115.620    31.493
  -115.605    31.507
>
  -115.615    31.496
  -115.611    31.486
>
  -115.621    31.497
  -115.613    31.501
>
  -115.688    31.440
  -115.603    31.496
>
  -116.068    31.561
  -115.981    31.600
>
  -116.003    31.582
  -115.946    31.702
>
  -115.614    31.512
  -115.608    31.501
>
  -115.593    31.518
  -115.608    31.510
>
  -115.614    31.512
  -115.607    31.500
>
  -115.958    31.621
  -115.965    31.606
>
EOF

# Change in location from starting location in green
gmt plot $proj $reg -Wthin,green << EOF
  -116.126    31.768
  -116.126    31.767
>
  -115.691    31.767
  -115.691    31.768
>
  -115.603    31.252
  -115.602    31.253
>
  -115.593    31.283
  -115.593    31.284
>
  -115.720    31.889
  -115.720    31.889
>
  -115.587    31.202
  -115.587    31.205
>
  -115.574    31.607
  -115.575    31.607
>
  -116.196    31.852
  -116.196    31.852
>
  -116.296    31.831
  -116.296    31.832
>
  -116.235    31.806
  -116.235    31.807
>
  -115.969    31.693
  -115.969    31.693
>
  -116.178    31.769
  -116.178    31.769
>
  -116.299    31.851
  -116.299    31.851
>
  -115.980    31.627
  -115.980    31.627
>
  -115.646    31.279
  -115.647    31.279
>
  -115.662    31.276
  -115.662    31.276
>
  -115.658    31.283
  -115.658    31.282
>
  -115.667    31.269
  -115.667    31.269
>
  -115.656    31.276
  -115.656    31.276
>
  -115.659    31.259
  -115.659    31.259
>
  -115.641    31.272
  -115.641    31.272
>
  -116.039    31.394
  -116.040    31.394
>
  -115.664    31.263
  -115.663    31.263
>
  -115.663    31.268
  -115.663    31.268
>
  -115.674    31.261
  -115.674    31.261
>
  -115.657    31.270
  -115.657    31.270
>
  -115.663    31.255
  -115.664    31.254
>
  -115.681    31.269
  -115.681    31.269
>
  -115.681    31.268
  -115.681    31.268
>
  -115.660    31.273
  -115.660    31.273
>
  -116.098    31.758
  -116.098    31.757
>
  -115.643    31.258
  -115.643    31.257
>
  -115.606    31.213
  -115.607    31.212
>
  -115.623    31.247
  -115.623    31.246
>
  -115.615    31.239
  -115.615    31.239
>
  -115.669    31.269
  -115.669    31.269
>
  -116.033    31.784
  -116.033    31.785
>
  -115.520    31.524
  -115.519    31.524
>
  -115.849    31.571
  -115.849    31.571
>
  -115.921    31.685
  -115.921    31.685
>
  -115.622    31.576
  -115.622    31.576
>
  -115.918    31.685
  -115.918    31.685
>
  -115.937    31.230
  -115.937    31.231
>
  -115.933    31.248
  -115.933    31.248
>
  -116.139    31.580
  -116.139    31.580
>
  -115.918    31.242
  -115.915    31.239
>
  -115.507    31.555
  -115.507    31.555
>
  -115.412    31.109
  -115.412    31.109
>
  -115.509    31.535
  -115.509    31.535
>
  -115.480    31.561
  -115.480    31.561
>
  -115.487    31.552
  -115.487    31.551
>
  -115.495    31.545
  -115.495    31.545
>
  -115.933    31.237
  -115.932    31.238
>
  -116.201    31.834
  -116.201    31.834
>
  -115.470    31.498
  -115.470    31.498
>
  -116.252    31.761
  -116.252    31.760
>
  -115.936    31.240
  -115.934    31.241
>
  -115.492    31.485
  -115.492    31.484
>
  -115.594    31.566
  -115.594    31.567
>
  -115.317    31.435
  -115.317    31.435
>
  -115.677    31.799
  -115.676    31.799
>
  -115.627    31.533
  -115.627    31.533
>
  -115.637    31.521
  -115.637    31.521
>
  -115.639    31.519
  -115.640    31.519
>
  -115.636    31.520
  -115.636    31.520
>
  -115.922    31.639
  -115.921    31.639
>
  -115.884    31.229
  -115.889    31.226
>
  -115.632    31.553
  -115.632    31.553
>
  -115.413    31.306
  -115.414    31.306
>
  -115.448    31.306
  -115.449    31.305
>
  -115.988    31.628
  -115.987    31.629
>
  -115.491    31.527
  -115.491    31.528
>
  -116.188    31.866
  -116.188    31.865
>
  -115.681    30.814
  -115.680    30.811
>
  -115.587    31.586
  -115.587    31.586
>
  -116.088    31.230
  -116.086    31.228
>
  -116.053    31.769
  -116.053    31.769
>
  -115.328    31.265
  -115.329    31.265
>
  -116.105    31.801
  -116.105    31.801
>
  -116.103    31.801
  -116.104    31.801
>
  -116.013    31.615
  -116.013    31.615
>
  -115.666    31.264
  -115.667    31.264
>
  -115.373    31.344
  -115.373    31.344
>
  -115.990    31.615
  -115.990    31.615
>
  -116.109    31.849
  -116.109    31.849
>
  -115.811    31.619
  -115.811    31.619
>
  -115.252    30.965
  -115.252    30.966
>
  -116.101    31.805
  -116.101    31.805
>
  -115.591    31.522
  -115.591    31.522
>
  -116.281    31.942
  -116.281    31.942
>
  -115.808    31.906
  -115.808    31.906
>
  -115.816    31.908
  -115.817    31.908
>
  -115.818    31.908
  -115.818    31.909
>
  -115.558    31.780
  -115.558    31.780
>
  -115.811    31.899
  -115.811    31.899
>
  -115.818    31.916
  -115.818    31.916
>
  -115.717    31.306
  -115.717    31.306
>
  -116.154    31.717
  -116.154    31.717
>
  -116.206    31.826
  -116.206    31.826
>
  -115.624    31.508
  -115.624    31.508
>
  -115.627    31.516
  -115.626    31.516
>
  -115.635    31.506
  -115.634    31.506
>
  -115.633    31.509
  -115.633    31.509
>
  -115.630    31.492
  -115.631    31.491
>
  -115.644    31.490
  -115.643    31.490
>
  -115.616    31.515
  -115.615    31.515
>
  -115.831    31.626
  -115.831    31.626
>
  -115.665    31.528
  -115.660    31.529
>
  -115.629    31.507
  -115.629    31.508
>
  -115.987    31.628
  -115.986    31.628
>
  -115.625    31.500
  -115.627    31.499
>
  -115.613    31.377
  -115.611    31.376
>
  -115.640    31.501
  -115.640    31.501
>
  -116.239    31.738
  -116.239    31.738
>
  -115.621    31.532
  -115.621    31.532
>
  -116.031    31.696
  -116.033    31.696
>
  -115.612    31.481
  -115.612    31.481
>
  -115.343    31.455
  -115.342    31.455
>
  -115.633    31.494
  -115.633    31.494
>
  -115.986    31.601
  -115.988    31.600
>
  -116.172    31.859
  -116.172    31.859
>
  -115.343    31.454
  -115.343    31.454
>
  -115.684    31.553
  -115.684    31.553
>
  -115.938    31.662
  -115.939    31.663
>
  -115.971    30.844
  -115.971    30.844
>
  -115.677    31.564
  -115.677    31.564
>
  -115.672    31.560
  -115.672    31.560
>
  -115.667    31.575
  -115.666    31.575
>
  -115.689    31.576
  -115.688    31.576
>
  -115.678    31.563
  -115.678    31.563
>
  -115.334    31.438
  -115.334    31.438
>
  -115.478    31.510
  -115.477    31.511
>
  -115.660    31.540
  -115.660    31.540
>
  -115.663    31.546
  -115.663    31.546
>
  -115.382    31.424
  -115.382    31.424
>
  -115.634    31.500
  -115.635    31.500
>
  -116.091    31.889
  -116.091    31.889
>
  -115.405    31.363
  -115.405    31.363
>
  -115.398    31.362
  -115.398    31.362
>
  -115.390    31.422
  -115.389    31.422
>
  -115.600    31.474
  -115.600    31.474
>
  -115.601    31.488
  -115.601    31.488
>
  -115.602    31.484
  -115.602    31.484
>
  -115.599    31.483
  -115.598    31.483
>
  -115.609    31.477
  -115.608    31.477
>
  -115.600    31.486
  -115.600    31.486
>
  -115.603    31.504
  -115.603    31.504
>
  -115.603    31.489
  -115.603    31.489
>
  -115.603    31.488
  -115.603    31.488
>
  -115.598    31.483
  -115.598    31.482
>
  -115.597    31.477
  -115.597    31.477
>
  -115.595    31.480
  -115.595    31.480
>
  -115.595    31.501
  -115.595    31.501
>
  -115.610    31.482
  -115.610    31.482
>
  -115.866    31.393
  -115.866    31.393
>
  -115.645    31.457
  -115.645    31.457
>
  -115.607    31.489
  -115.607    31.489
>
  -115.606    31.498
  -115.606    31.498
>
  -115.604    31.498
  -115.604    31.498
>
  -115.611    31.505
  -115.611    31.505
>
  -115.612    31.491
  -115.612    31.491
>
  -115.619    31.503
  -115.619    31.503
>
  -115.603    31.485
  -115.602    31.485
>
  -115.606    31.481
  -115.606    31.481
>
  -115.607    31.491
  -115.607    31.491
>
  -115.609    31.496
  -115.609    31.496
>
  -115.609    31.496
  -115.609    31.496
>
  -116.193    31.924
  -116.194    31.924
>
  -115.605    31.507
  -115.605    31.507
>
  -115.611    31.486
  -115.611    31.486
>
  -115.613    31.501
  -115.613    31.501
>
  -115.603    31.496
  -115.603    31.496
>
  -115.981    31.599
  -115.981    31.600
>
  -115.946    31.702
  -115.946    31.702
>
  -115.608    31.501
  -115.608    31.501
>
  -115.608    31.509
  -115.608    31.510
>
  -115.607    31.500
  -115.607    31.500
>
  -115.965    31.606
  -115.965    31.606
>
EOF

# Confidence ellipses for relative location
gmt plot $proj $reg -SE -Wthick << EOF
  -116.126    31.767   -76.108     2.839     4.157
  -115.691    31.768    78.848     1.984     3.787
  -115.602    31.253   -79.750     2.636     5.335
  -115.593    31.284   -81.072     1.762     4.583
  -115.720    31.889    53.434     2.155     4.505
  -115.587    31.205     8.351     0.821     1.985
  -115.575    31.607    59.971     1.519     2.007
  -116.196    31.852    46.610     2.097     2.687
  -116.296    31.832    71.376     1.676     2.579
  -116.235    31.807    77.707     2.377     3.590
  -115.969    31.693   -58.593     1.392     2.530
  -116.178    31.769    66.571     2.391     4.936
  -116.299    31.851   -62.828     1.598     2.401
  -115.980    31.627   -84.445     1.344     1.570
  -115.647    31.279   -57.625     1.374     2.258
  -115.662    31.276   -57.464     0.979     1.872
  -115.658    31.282   -41.710     1.347     2.396
  -115.667    31.269   -67.840     1.237     2.958
  -115.656    31.276   -46.175     1.375     2.539
  -115.659    31.259   -51.298     1.326     2.297
  -115.641    31.272   -53.814     0.900     1.643
  -116.040    31.394   -57.959     1.230     2.444
  -115.663    31.263   -45.074     1.381     2.816
  -115.663    31.268   -50.234     1.164     2.076
  -115.674    31.261   -59.077     1.481     2.797
  -115.657    31.270   -48.509     1.292     2.323
  -115.664    31.254   -41.022     1.533     3.789
  -115.681    31.269   -44.592     1.223     2.443
  -115.681    31.268   -49.388     1.243     2.247
  -115.660    31.273   -57.509     1.542     2.760
  -116.098    31.757   -48.506     1.246     2.101
  -115.643    31.257   -58.920     1.348     2.291
  -115.607    31.212   -48.115     1.530     2.758
  -115.623    31.246   -53.044     1.390     2.384
  -115.615    31.239   -46.810     1.357     2.437
  -115.669    31.269   -58.134     1.320     2.293
  -116.033    31.785   -30.236     1.068     1.542
  -115.519    31.524   -41.931     1.830     3.094
  -115.849    31.571   -39.018     1.070     1.813
  -115.921    31.685   -34.018     1.560     2.345
  -115.622    31.576   -37.788     1.573     2.460
  -115.918    31.685   -25.715     1.246     1.838
  -115.937    31.231   -50.694     1.570     4.290
  -115.933    31.248   -48.623     1.448     4.180
  -116.139    31.580   -41.923     1.290     1.917
  -115.915    31.239   -44.399     1.068     2.729
  -115.507    31.555   -18.630     1.264     2.634
  -115.412    31.109    -2.878     2.524     4.781
  -115.509    31.535   -17.504     1.666     3.364
  -115.480    31.561   -28.668     1.353     2.460
  -115.487    31.551   -34.534     1.506     2.138
  -115.495    31.545   -30.197     1.617     2.460
  -115.932    31.238   -44.827     1.663     3.567
  -116.201    31.834   -39.441     1.086     2.105
  -115.470    31.498   -43.569     1.524     2.490
  -116.252    31.760   -44.539     1.779     2.684
  -115.934    31.241   -40.805     2.043     3.975
  -115.492    31.484   -28.721     1.547     2.223
  -115.594    31.567   -10.115     1.039     1.744
  -115.317    31.435    -1.442     1.457     1.885
  -115.676    31.799   -29.211     1.137     1.835
  -115.627    31.533   -45.353     0.840     1.223
  -115.637    31.521   -37.444     1.118     1.645
  -115.640    31.519   -25.424     1.197     1.833
  -115.636    31.520   -27.886     1.074     1.495
  -115.921    31.639   -29.341     1.224     2.650
  -115.889    31.226   -46.737     1.783     3.315
  -115.632    31.553   -29.017     1.262     2.190
  -115.414    31.306   -39.321     1.647     2.213
  -115.449    31.305   -68.418     3.338     5.308
  -115.987    31.629   -59.871     1.203     1.956
  -115.491    31.528   -26.389     1.811     2.552
  -116.188    31.865   -62.734     1.770     2.169
  -115.680    30.811   -62.990     1.705     3.721
  -115.587    31.586   -44.009     1.356     2.461
  -116.086    31.228   -54.438     1.804     4.016
  -116.053    31.769   -38.210     1.288     2.194
  -115.329    31.265    13.641     1.849     2.820
  -116.105    31.801   -39.732     0.776     1.245
  -116.104    31.801   -40.969     0.762     1.164
  -116.013    31.615   -41.802     1.151     2.003
  -115.667    31.264   -46.578     1.332     2.231
  -115.373    31.344   -18.714     1.710     2.050
  -115.990    31.615   -21.196     1.067     1.544
  -116.109    31.849   -23.129     0.865     1.207
  -115.811    31.619   -15.910     0.903     1.104
  -115.252    30.966    72.112     2.301     3.383
  -116.101    31.805   -21.838     0.738     0.958
  -115.591    31.522    23.219     1.273     1.452
  -116.281    31.942   -53.775     1.050     1.361
  -115.808    31.906   -19.578     0.829     0.981
  -115.817    31.908   -77.882     1.166     1.449
  -115.818    31.909   -75.797     1.102     1.385
  -115.558    31.780   -14.028     1.351     1.563
  -115.811    31.899   -65.775     1.038     1.225
  -115.818    31.916    35.151     1.371     1.487
  -115.717    31.306   -44.980     1.443     2.345
  -116.154    31.717   -39.836     1.042     1.416
  -116.206    31.826   -27.968     1.383     1.961
  -115.624    31.508   -63.870     1.154     1.304
  -115.626    31.516    69.019     1.155     1.341
  -115.634    31.506    72.630     1.460     1.720
  -115.633    31.509    39.420     1.685     1.858
  -115.631    31.491    64.329     1.441     1.674
  -115.643    31.490    61.740     1.308     1.656
  -115.615    31.515    59.465     1.178     1.623
  -115.831    31.626     1.119     1.308     1.600
  -115.660    31.529   -81.803     1.350     1.672
  -115.629    31.508    69.054     1.240     1.494
  -115.986    31.628   -40.889     1.381     1.522
  -115.627    31.499   -76.786     1.132     1.579
  -115.611    31.376   -13.518     2.827     3.133
  -115.640    31.501   -73.290     1.185     1.385
  -116.239    31.738   -42.059     1.215     1.746
  -115.621    31.532   -23.468     1.168     1.331
  -116.033    31.696   -10.225     1.206     1.508
  -115.612    31.481   -44.122     1.492     1.699
  -115.342    31.455    55.984     1.417     1.841
  -115.633    31.494   -36.423     1.202     1.591
  -115.988    31.600   -51.318     1.072     1.722
  -116.172    31.859   -40.976     0.908     1.423
  -115.343    31.454    73.519     1.393     1.883
  -115.684    31.553   -30.676     1.167     1.299
  -115.939    31.663   -24.405     1.174     1.535
  -115.971    30.844   -34.169     1.967     2.985
  -115.677    31.564   -30.874     1.123     1.223
  -115.672    31.560   -40.550     1.070     1.165
  -115.666    31.575    70.164     1.109     1.191
  -115.688    31.576   -22.682     1.130     1.367
  -115.678    31.563   -25.281     1.249     1.493
  -115.334    31.438    77.438     1.229     1.789
  -115.477    31.511   -81.982     1.093     1.733
  -115.660    31.540   -39.746     0.837     1.076
  -115.663    31.546   -75.778     0.909     1.292
  -115.382    31.424    79.563     1.117     1.623
  -115.635    31.500   -64.668     0.948     1.227
  -116.091    31.889   -22.494     1.003     1.655
  -115.405    31.363    54.388     1.674     1.998
  -115.398    31.362    68.526     1.136     1.725
  -115.389    31.422    87.013     1.091     1.534
  -115.600    31.474    85.700     1.041     1.415
  -115.601    31.488   -80.127     0.786     0.943
  -115.602    31.484   -49.147     1.343     1.449
  -115.598    31.483   -76.743     0.827     1.021
  -115.608    31.477   -36.422     1.419     1.529
  -115.600    31.486   -33.123     1.387     1.519
  -115.603    31.504    -8.256     1.739     2.048
  -115.603    31.489   -43.619     1.470     1.686
  -115.603    31.488   -77.252     0.875     1.109
  -115.598    31.482   -74.028     0.927     1.197
  -115.597    31.477   -39.008     1.010     1.187
  -115.595    31.480   -10.636     1.423     1.608
  -115.595    31.501   -26.458     1.345     2.088
  -115.610    31.482   -79.796     1.390     1.421
  -115.866    31.393   -45.050     1.513     2.769
  -115.645    31.457   -47.050     1.321     1.517
  -115.607    31.489   -75.815     0.898     1.239
  -115.606    31.498   -79.754     0.903     1.248
  -115.604    31.498   -75.953     0.842     1.053
  -115.611    31.505   -72.177     0.921     1.225
  -115.612    31.491   -76.702     0.811     1.081
  -115.619    31.503   -85.173     0.903     1.247
  -115.602    31.485   -83.378     0.973     1.389
  -115.606    31.481   -83.863     0.914     1.158
  -115.607    31.491   -78.156     0.905     1.254
  -115.609    31.496   -78.778     0.821     1.094
  -115.609    31.496   -76.351     0.888     1.057
  -116.194    31.924   -30.189     0.784     1.277
  -115.605    31.507   -73.588     1.444     1.537
  -115.611    31.486   -78.370     1.015     1.358
  -115.613    31.501   -83.141     0.929     1.351
  -115.603    31.496   -73.058     1.129     1.649
  -115.981    31.600   -51.365     0.899     1.439
  -115.946    31.702   -28.683     1.136     1.425
  -115.608    31.501   -76.799     0.893     1.341
  -115.608    31.510   -78.608     0.898     1.368
  -115.607    31.500   -75.769     1.101     1.540
  -115.965    31.606   -47.109     0.873     1.165
EOF

# Hypocentroid confidence ellipse
gmt plot $proj $reg -SE -Wthick,blue << EOF
  -116.336    30.765   -39.198     0.831     0.934
EOF
gmt text $proj $reg -F+f6p,Helvetica,blue+a0.+jBL << EOF
  -116.314    30.765   Hypocentroid
EOF

# Circle of radius 5 km for reference
gmt plot $proj $reg -SE -Wthick,red << EOF
  -116.336    30.765     0.000    10.000    10.000
EOF
gmt plot $proj $reg -Sx -Wthinnest -Gblue << EOF
  -116.336    30.765     0.070
EOF
gmt text $proj $reg -F+f6p,Helvetica-Bold,red+a0.+jBC -Gwhite << EOF
  -116.336    30.720   5 km
EOF
gmt end
