#!/bin/bash
gmt begin acapulco7.51_tt7_local_regional_s pdf,ps
proj=-JX18/12
reg=-R0/15/-120/30
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya50f10+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional Shear Phases acapulco7.51'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     1.000  -115.000 Inverse reduction velocity: 31.70 sec/deg
EOF
# Rg theoretical TT curve in black
gmt plot $proj $reg -Wthick,black << EOF
     2.500    12.000
     3.000    14.400
     3.500    16.800
     4.000    19.200
     4.500    21.600
     5.000    24.000
EOF
# Rg label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBR << EOF
     3.000    17.400 Rg
EOF
# Lg theoretical TT curve in cyan
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    -0.500
     3.000    -0.600
     3.500    -0.700
     4.000    -0.800
     4.500    -0.900
     5.000    -1.000
     5.500    -1.100
     6.000    -1.200
     6.500    -1.300
     7.000    -1.400
     7.500    -1.500
     8.000    -1.600
     8.500    -1.700
     9.000    -1.800
     9.500    -1.900
    10.000    -2.000
    10.500    -2.100
    11.000    -2.200
    11.500    -2.300
    12.000    -2.400
    12.500    -2.500
    13.000    -2.600
    13.500    -2.700
    14.000    -2.800
    14.500    -2.900
    15.000    -3.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBL << EOF
    13.000     0.400 Lg
EOF
# Sn theoretical TT curve in green
gmt plot $proj $reg -Wthick,green << EOF
     1.000    -0.163
     1.500    -3.682
     2.000    -7.201
     2.500   -10.720
     3.000   -14.241
     3.500   -17.766
     4.000   -21.291
     4.500   -24.822
     5.000   -28.355
     5.500   -31.892
     6.000   -35.434
     6.500   -38.981
     7.000   -42.532
     7.500   -46.090
     8.000   -49.653
     8.500   -53.224
     9.000   -56.801
     9.500   -60.386
    10.000   -63.978
    10.500   -67.580
    11.000   -71.189
    11.500   -74.808
    12.000   -78.435
    12.500   -82.070
    13.000   -85.716
    13.500   -89.372
    14.000   -93.038
    14.500   -96.715
    15.000  -100.404
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jBL << EOF
    13.000   -82.716 Sn
EOF
# Sb theoretical TT curve in blue
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg theoretical TT curve in red
gmt plot $proj $reg -Wthick,red << EOF
     0.500     2.351
     1.000     0.081
     1.500    -1.587
     2.000    -3.141
     2.500    -4.659
     3.000    -6.162
     3.500    -7.658
     4.000    -9.150
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     4.000   -12.150 Sg
EOF
# Rg observations in black circles
gmt plot $proj $reg -Sc -Wthin,black << EOF
EOF
# Lg observations in cyan circles
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    24.130  -114.742     0.200
    12.726    -0.884     0.200
     5.198    -3.496     0.200
    11.591     4.322     0.200
    12.453     2.627     0.200
    18.495     2.656     0.200
    21.844    16.574     0.200
    26.361     5.850     0.200
    26.664     6.179     0.200
    30.045     4.662     0.200
    33.153     6.649     0.200
    33.886    14.633     0.200
    45.490     5.013     0.200
    45.983     4.547     0.200
    46.332     0.581     0.200
    46.627     6.715     0.200
    12.735     2.409     0.200
    18.782     3.190     0.200
    26.671     9.692     0.200
    27.063    -6.048     0.200
     5.186    -5.083     0.200
    12.760     1.497     0.200
    18.799     0.784     0.200
     4.487    -3.133     0.200
    12.926    -1.448     0.200
    18.989     0.836     0.200
    22.526    12.039     0.200
    27.005     6.673     0.200
    27.146     6.150     0.200
    27.344     6.209     0.200
    31.725    12.998     0.200
     4.567    -2.885     0.200
    12.725    -6.351     0.200
     4.541     1.666     0.200
    13.036     1.299     0.200
    19.096     8.110     0.200
     3.768     1.246     0.200
    13.324    -2.355     0.200
     2.944    -0.983     0.200
     2.953    -1.969     0.200
    12.917     3.439     0.200
     2.621    -2.171     0.200
     2.727    -1.672     0.200
     4.174     0.975     0.200
     4.222     0.409     0.200
     4.296    -0.306     0.200
    13.291     0.087     0.200
     2.676    -2.554     0.200
     3.257    -2.860     0.200
     3.493     2.377     0.200
     4.442     2.389     0.200
     8.894     1.325     0.200
    13.026     3.663     0.200
     2.559     1.370     0.200
     4.570    -1.512     0.200
     9.015    -1.593     0.200
    13.014     6.114     0.200
     2.654    -0.877     0.200
     3.063    -3.306     0.200
     3.034    -1.487     0.200
     3.234    -1.476     0.200
     3.616     0.030     0.200
     3.972     1.278     0.200
     4.543    -2.636     0.200
     5.001    -2.170     0.200
     5.001    -3.838     0.200
     9.443    -1.372     0.200
    12.888     6.796     0.200
    18.935     2.896     0.200
     2.858    -4.231     0.200
     2.793    -3.793     0.200
     2.637    -0.293     0.200
     2.766    -0.872     0.200
     4.704    -1.856     0.200
    13.030    11.163     0.200
     2.946    -6.446     0.200
     4.635    -1.353     0.200
     3.872     0.796     0.200
     8.364     0.295     0.200
    13.081     1.991     0.200
    19.154     0.713     0.200
    22.896    -3.431     0.200
    27.325    -5.872     0.200
    27.596    -1.697     0.200
     2.846    -6.169     0.200
     4.375    -2.142     0.200
    13.153     1.507     0.200
     2.544    -5.277     0.200
     2.603    -5.570     0.200
     2.904    -6.479     0.200
     4.675    -6.692     0.200
    12.778    -2.923     0.200
    18.836     0.672     0.200
     2.613     1.382     0.200
     4.635    -1.891     0.200
     2.635    -0.848     0.200
     2.635    -0.844     0.200
     4.025    -4.178     0.200
    13.517    -0.975     0.200
     2.664    -4.016     0.200
     2.525    -0.147     0.200
     2.525    -0.150     0.200
     2.544    -2.381     0.200
     2.670    -1.812     0.200
     2.694    -0.072     0.200
     4.737    -5.993     0.200
     4.826    -4.272     0.200
     4.830    -6.019     0.200
     4.837    -3.941     0.200
     4.858    -5.843     0.200
     4.877    -4.780     0.200
    12.752     5.284     0.200
     4.786    -4.796     0.200
    18.916     0.708     0.200
     2.593    -1.909     0.200
     2.701    -3.216     0.200
     3.283    -0.813     0.200
     3.698    -0.182     0.200
     2.809    -5.412     0.200
     4.519    -4.447     0.200
    12.669    -2.131     0.200
     2.557    -4.920     0.200
     4.821    -7.435     0.200
    12.653    -0.559     0.200
     4.705    -4.990     0.200
    13.004     9.002     0.200
    19.060    -7.101     0.200
     4.239    -5.486     0.200
    13.400     3.434     0.200
    19.467     6.660     0.200
     2.619    -1.965     0.200
     2.702    -0.569     0.200
     4.953    -2.650     0.200
     9.397    -4.971     0.200
    12.896     4.532     0.200
     2.612    -0.520     0.200
     2.946    -2.804     0.200
     4.910    -4.435     0.200
     9.374    -2.183     0.200
    12.825    -1.386     0.200
    18.876    -5.059     0.200
     9.898    -2.273     0.200
    12.358    -0.850     0.200
     2.507    -0.790     0.200
     2.785    -3.370     0.200
     3.307    -3.963     0.200
     3.305    -3.905     0.200
     3.324    -3.856     0.200
     5.062    -4.444     0.200
     9.493    -8.285     0.200
    11.987     3.138     0.200
    12.922    -3.826     0.200
    18.965     1.328     0.200
     2.653    -4.091     0.200
     3.902    -2.988     0.200
     2.716    -5.042     0.200
    11.836    -1.227     0.200
    12.575    -5.426     0.200
     2.664    -4.259     0.200
     2.525    -2.640     0.200
     2.575     0.765     0.200
     2.643    -2.172     0.200
     2.617    -2.665     0.200
     2.617    -0.681     0.200
     2.884    -3.156     0.200
    12.884    -7.804     0.200
     2.530    -0.665     0.200
     2.552    -2.711     0.200
     2.552     0.360     0.200
     2.617    -2.609     0.200
     2.617    -2.359     0.200
     2.675    -0.204     0.200
     2.706    -2.526     0.200
     2.706    -2.177     0.200
     2.817    -2.735     0.200
     2.817    -0.656     0.200
     3.022    -2.732     0.200
     4.807    -6.046     0.200
     4.625    -2.447     0.200
     2.554    -0.759     0.200
     2.597    -2.254     0.200
     2.685    -1.189     0.200
     2.510    -2.588     0.200
     2.533    -0.999     0.200
     2.535    -2.617     0.200
     2.553     0.100     0.200
     2.565    -0.716     0.200
     2.659    -1.372     0.200
     2.670    -0.774     0.200
     2.694    -3.024     0.200
     2.772    -1.513     0.200
     2.864    -1.590     0.200
     2.983    -2.474     0.200
    19.057    -3.446     0.200
     2.519     0.317     0.200
     2.519     0.308     0.200
     2.514     1.720     0.200
     2.539     2.700     0.200
     2.599    -2.612     0.200
     2.615    -0.156     0.200
     2.630     0.586     0.200
     2.646     2.393     0.200
     2.670    -1.378     0.200
     2.728    -2.005     0.200
     2.749    -1.652     0.200
     2.762    -1.458     0.200
     2.831     0.468     0.200
     2.869    -2.210     0.200
     3.103    -1.522     0.200
     3.746    -4.453     0.200
     3.809    -1.720     0.200
     4.669    -5.725     0.200
     4.694    -5.744     0.200
     5.351    -5.730     0.200
     6.350    -8.603     0.200
    13.009    -9.276     0.200
    12.810    -5.175     0.200
     3.073    -5.092     0.200
     3.125    -1.286     0.200
     4.456    -0.185     0.200
    13.126    -1.561     0.200
     2.909    -2.194     0.200
     3.092    -2.902     0.200
     3.771    -4.509     0.200
     3.925    -4.461     0.200
     2.816    -3.091     0.200
     5.002    -6.210     0.200
    12.535    -3.587     0.200
     4.422    -1.573     0.200
    13.277     1.317     0.200
    19.339    -2.554     0.200
     2.813    -6.447     0.200
     4.959    -5.243     0.200
    12.840    -4.174     0.200
    18.888    -3.062     0.200
EOF
# Sn observations in green circles
gmt plot $proj $reg -Sc -Wthin,green << EOF
    20.830  -140.131     0.200
    24.130  -174.402     0.200
     1.512    -0.550     0.200
     2.425    -6.526     0.200
     2.492    -7.118     0.200
     2.665    -8.598     0.200
     2.759    -8.852     0.200
     2.878    -9.292     0.200
     2.903    -9.073     0.200
     3.215   -12.066     0.200
     3.224   -10.591     0.200
     4.010   -17.669     0.200
     4.192   -20.230     0.200
     5.510   -21.999     0.200
     7.657   -40.662     0.200
     7.810   -39.466     0.200
     0.308     4.911     0.200
     0.729     0.098     0.200
     0.979    -1.491     0.200
     2.435    -8.268     0.200
     2.495    -9.302     0.200
     2.495    -6.601     0.200
     3.612   -14.527     0.200
     4.851   -23.219     0.200
     1.163    -2.752     0.200
     2.252    -8.111     0.200
     2.284    -8.872     0.200
     2.479    -9.441     0.200
     2.511    -9.045     0.200
     2.590    -9.605     0.200
     3.064   -11.332     0.200
     3.077   -16.289     0.200
     3.308   -15.123     0.200
     3.432   -15.714     0.200
     4.287   -22.461     0.200
     4.469   -21.992     0.200
     5.030   -28.494     0.200
     5.198   -27.865     0.200
     5.513   -25.537     0.200
     5.683   -31.883     0.200
     7.894   -47.134     0.200
     8.259   -44.208     0.200
     8.862   -52.602     0.200
    19.760  -136.888     0.200
     0.158     6.425     0.200
     0.969     0.538     0.200
     1.181    -1.265     0.200
     1.407    -1.933     0.200
     2.025    -5.465     0.200
     2.233    -9.430     0.200
     2.283    -7.725     0.200
     2.369    -5.569     0.200
     2.444    -8.159     0.200
     2.464    -9.165     0.200
     2.508    -7.687     0.200
     2.602   -10.255     0.200
     3.051   -13.540     0.200
     3.095   -14.590     0.200
     3.307   -14.690     0.200
     3.414   -16.895     0.200
     3.423   -18.402     0.200
     4.268   -23.799     0.200
     5.049   -26.608     0.200
     5.181   -31.844     0.200
     5.181   -28.543     0.200
    11.783   -76.348     0.200
    19.745  -135.729     0.200
    22.254  -159.969     0.200
     1.064     0.896     0.200
     1.987    -6.402     0.200
     2.523    -8.813     0.200
     2.780    -9.965     0.200
     2.926   -11.004     0.200
     3.236   -13.028     0.200
     3.351   -14.450     0.200
     4.454   -17.274     0.200
     1.318    -3.198     0.200
     1.671    -4.336     0.200
     2.143    -8.415     0.200
     2.498    -9.299     0.200
     2.559    -9.383     0.200
     2.644    -9.451     0.200
     2.682    -9.101     0.200
     2.843   -10.515     0.200
     2.892   -11.972     0.200
     2.910   -11.511     0.200
     2.946   -11.677     0.200
     3.025   -13.451     0.200
     3.071   -12.347     0.200
     3.185   -13.994     0.200
     3.217   -15.488     0.200
     3.418   -16.057     0.200
     3.427   -16.860     0.200
     3.593   -15.732     0.200
     4.170   -21.343     0.200
     4.178   -21.743     0.200
     5.186   -33.605     0.200
     5.186   -27.573     0.200
     5.198   -28.304     0.200
     5.748   -32.831     0.200
     6.219   -35.443     0.200
     8.000   -46.907     0.200
    11.873   -83.572     0.200
    11.873   -78.542     0.200
     1.939    -6.400     0.200
     3.412   -14.535     0.200
     3.854   -19.534     0.200
     4.487   -25.731     0.200
     4.607   -23.088     0.200
     4.763   -25.698     0.200
     5.805   -32.127     0.200
     6.175   -32.836     0.200
     6.240   -35.230     0.200
    11.206   -76.917     0.200
     0.294     5.693     0.200
     0.584     2.089     0.200
     1.350    -2.483     0.200
     1.625    -5.374     0.200
     1.799    -6.490     0.200
     1.846    -5.352     0.200
     1.916    -5.935     0.200
     2.123    -6.956     0.200
     2.193    -6.979     0.200
     2.397    -8.727     0.200
     2.539    -9.847     0.200
     2.638   -10.053     0.200
     2.791   -12.493     0.200
     2.798   -13.519     0.200
     3.654   -19.665     0.200
     3.709   -20.011     0.200
     4.434   -24.123     0.200
     4.567   -24.424     0.200
     4.567   -25.338     0.200
     4.601   -25.077     0.200
     6.053   -34.947     0.200
     6.273   -36.123     0.200
     6.264   -36.356     0.200
     7.254   -42.147     0.200
     7.767   -45.623     0.200
    11.229   -72.732     0.200
     1.138     0.974     0.200
     1.270     0.312     0.200
     1.948    -7.252     0.200
     4.219   -22.248     0.200
     4.541   -21.799     0.200
     6.572   -30.627     0.200
    11.290   -76.981     0.200
    11.290   -73.770     0.200
    13.637   -92.241     0.200
    15.269  -103.762     0.200
     1.429    -3.393     0.200
     2.139    -8.352     0.200
     2.143    -6.869     0.200
     2.318    -8.095     0.200
     2.487    -9.353     0.200
     2.617    -9.310     0.200
     2.694   -14.602     0.200
     2.756   -12.350     0.200
     3.713   -17.518     0.200
     3.768   -19.656     0.200
     4.607   -26.804     0.200
     5.500   -31.764     0.200
     6.546   -39.607     0.200
    10.576   -71.828     0.200
    10.576   -71.062     0.200
    13.444   -89.303     0.200
    14.548   -96.850     0.200
     0.650     2.062     0.200
     1.332    -2.609     0.200
     1.505    -3.914     0.200
     1.910    -6.088     0.200
     2.008    -6.122     0.200
     2.751   -11.839     0.200
     3.139   -16.255     0.200
     4.158   -20.120     0.200
     6.246   -40.653     0.200
     6.216   -35.084     0.200
    11.236   -77.003     0.200
     1.488    -1.493     0.200
     1.562    -1.839     0.200
     2.021    -5.593     0.200
     1.985    -4.772     0.200
     2.087    -5.068     0.200
     2.296    -6.992     0.200
     2.603    -9.094     0.200
     2.735    -9.918     0.200
     1.217    -0.508     0.200
     1.217    -0.747     0.200
     1.353    -1.595     0.200
     1.935    -6.419     0.200
     2.269    -8.265     0.200
     2.273    -6.622     0.200
     2.542    -8.481     0.200
     2.727    -8.774     0.200
     3.212   -17.538     0.200
     3.537   -15.341     0.200
     4.174   -18.896     0.200
     4.179   -21.060     0.200
     4.969   -25.544     0.200
     2.020    -5.549     0.200
     2.020    -7.057     0.200
     4.124   -16.312     0.200
     4.442   -20.459     0.200
    11.187   -71.303     0.200
     1.914    -5.347     0.200
     1.914    -7.566     0.200
     2.805   -10.862     0.200
     4.570   -23.512     0.200
     9.015   -59.867     0.200
    11.315   -75.625     0.200
     1.937    -5.676     0.200
     5.001   -30.073     0.200
    11.719   -71.638     0.200
     0.292     6.449     0.200
     0.292     6.308     0.200
     0.397     4.509     0.200
     0.397     4.329     0.200
     0.827     0.443     0.200
     0.791     1.019     0.200
     1.197    -1.336     0.200
     1.268    -1.889     0.200
     1.268    -0.904     0.200
     1.400    -4.770     0.200
     1.839    -7.957     0.200
     1.816    -3.212     0.200
     2.019    -6.347     0.200
     3.494   -18.775     0.200
    12.601   -78.998     0.200
     1.621    -4.775     0.200
     1.822    -7.446     0.200
     3.662   -20.334     0.200
     3.729   -17.957     0.200
     3.990   -16.572     0.200
     4.438   -17.182     0.200
     4.704   -26.356     0.200
     6.318   -33.581     0.200
     0.087     8.510     0.200
     0.087     8.377     0.200
     0.514     2.765     0.200
     0.863    -0.587     0.200
     1.062    -1.681     0.200
     1.062    -0.361     0.200
     1.217    -1.670     0.200
     1.338    -2.832     0.200
     1.345    -3.484     0.200
     1.675    -5.858     0.200
     1.743    -6.167     0.200
     1.896    -7.171     0.200
     1.896    -5.171     0.200
     1.990    -6.943     0.200
     2.251    -8.482     0.200
     2.364    -3.846     0.200
     2.742    -7.418     0.200
     3.286   -16.196     0.200
     3.655   -17.180     0.200
     3.683   -18.047     0.200
     3.969   -20.477     0.200
     4.314   -22.994     0.200
     4.394   -23.300     0.200
     4.554   -24.369     0.200
     5.481   -29.467     0.200
     5.598   -32.127     0.200
     0.406     3.698     0.200
     0.697     1.985     0.200
     0.710     1.538     0.200
     0.920     0.221     0.200
     0.924     0.983     0.200
     1.152     1.092     0.200
     1.286    -3.279     0.200
     1.392    -0.015     0.200
     1.948    -6.479     0.200
     1.917    -4.085     0.200
     2.078    -6.322     0.200
     2.112    -6.892     0.200
     2.097    -5.331     0.200
     2.117    -4.985     0.200
     2.675   -13.986     0.200
     3.345   -15.770     0.200
     3.469   -14.658     0.200
     3.872   -21.180     0.200
     3.878   -15.224     0.200
     4.422   -23.281     0.200
     4.435   -22.453     0.200
     5.019   -22.272     0.200
     5.049   -24.362     0.200
     5.561   -28.635     0.200
     5.617   -34.298     0.200
     7.640   -49.492     0.200
     7.935   -48.838     0.200
     8.364   -53.033     0.200
     9.394   -55.665     0.200
    10.070   -63.145     0.200
    10.969   -72.338     0.200
    13.836   -89.141     0.200
    19.154  -128.209     0.200
    19.545  -133.456     0.200
    20.516  -140.810     0.200
    20.696  -145.429     0.200
    21.518  -153.185     0.200
    21.520  -155.683     0.200
    21.572  -154.227     0.200
    22.023  -159.161     0.200
    22.040  -160.674     0.200
    22.040  -158.801     0.200
     0.302     6.504     0.200
     0.423     5.276     0.200
     0.633     2.144     0.200
     0.862    -0.274     0.200
     0.865    -0.057     0.200
     0.986     0.165     0.200
     1.091    -1.326     0.200
     1.119    -2.029     0.200
     1.157    -0.200     0.200
     1.257    -2.190     0.200
     1.277    -2.464     0.200
     1.455    -3.835     0.200
     1.603    -6.583     0.200
     1.933    -7.669     0.200
     1.970    -7.490     0.200
     2.017    -7.927     0.200
     2.400   -11.784     0.200
     2.675   -13.850     0.200
     3.701   -19.931     0.200
     8.200   -53.720     0.200
     0.101     9.814     0.200
     0.370     5.216     0.200
     0.540     3.071     0.200
     0.672     1.362     0.200
     0.840     0.337     0.200
     0.904     0.553     0.200
     1.304    -2.587     0.200
     1.405    -2.669     0.200
     1.595    -4.325     0.200
     1.728    -5.259     0.200
     1.832    -6.166     0.200
     1.839    -5.538     0.200
     1.887    -8.208     0.200
     1.866    -4.382     0.200
     1.947    -6.992     0.200
     2.152    -6.978     0.200
     2.191    -5.651     0.200
     2.200    -8.616     0.200
     2.282    -4.418     0.200
     2.287    -7.528     0.200
     2.390    -7.545     0.200
     2.558   -13.509     0.200
     3.566   -22.398     0.200
     3.566   -22.228     0.200
     3.648   -20.552     0.200
     3.797   -23.921     0.200
     4.442   -23.210     0.200
     4.478   -25.964     0.200
     4.615   -26.766     0.200
     0.291     5.870     0.200
     0.288     5.919     0.200
     0.371     4.663     0.200
     0.251     6.561     0.200
     0.401     4.267     0.200
     0.939     0.053     0.200
     1.182    -2.061     0.200
     1.329    -1.406     0.200
     1.346    -1.575     0.200
     1.453    -3.023     0.200
     1.543    -1.799     0.200
     1.457    -2.560     0.200
     1.457    -2.208     0.200
     1.766    -3.412     0.200
     1.903    -3.913     0.200
     2.162    -8.178     0.200
     2.226    -6.847     0.200
     2.223    -7.493     0.200
     2.276   -10.689     0.200
     2.371    -5.001     0.200
     2.383    -8.285     0.200
     2.620    -7.777     0.200
     4.068   -21.832     0.200
     4.912   -28.470     0.200
     1.189    -1.118     0.200
     1.222    -0.514     0.200
     1.295     0.469     0.200
     1.675    -3.851     0.200
     1.686    -4.555     0.200
     1.724    -4.807     0.200
     2.617    -9.896     0.200
     2.754   -12.328     0.200
     3.280   -11.657     0.200
     4.047   -24.838     0.200
     4.736   -18.460     0.200
     4.832   -21.123     0.200
     4.853   -21.384     0.200
     4.889   -23.009     0.200
     4.966   -25.347     0.200
     6.468   -30.200     0.200
     8.148   -43.602     0.200
     0.171     7.582     0.200
     0.204     6.725     0.200
     0.463     3.578     0.200
     0.484     3.284     0.200
     0.576     2.346     0.200
     0.911    -0.151     0.200
     1.069    -0.874     0.200
     1.253    -2.576     0.200
     1.357    -2.695     0.200
     1.515    -3.420     0.200
     1.616    -4.701     0.200
     1.683    -3.939     0.200
     1.687    -4.299     0.200
     1.867    -5.749     0.200
     1.973    -7.453     0.200
     2.107    -8.306     0.200
     2.122    -6.109     0.200
     2.163    -8.690     0.200
     2.214    -8.862     0.200
     2.215    -6.813     0.200
     2.229    -8.477     0.200
     2.283    -7.229     0.200
     2.345    -9.746     0.200
     2.343    -8.661     0.200
     2.386    -9.449     0.200
     2.399    -8.257     0.200
     2.458    -9.617     0.200
     2.500   -10.903     0.200
     2.521    -9.306     0.200
     2.560   -12.178     0.200
     2.582   -11.989     0.200
     2.590   -10.134     0.200
     2.619   -11.522     0.200
     2.771   -11.643     0.200
     2.816    -9.132     0.200
     2.889   -12.383     0.200
     2.975   -13.269     0.200
     3.166   -16.125     0.200
     3.183   -17.355     0.200
     3.336   -17.272     0.200
     3.836   -17.769     0.200
     3.857   -19.512     0.200
     3.920   -19.548     0.200
     3.925   -19.893     0.200
     3.932   -18.059     0.200
     3.953   -18.201     0.200
     3.995   -20.881     0.200
     4.197   -27.386     0.200
     4.245   -23.917     0.200
     5.102   -31.601     0.200
     0.477     4.238     0.200
     0.664     2.750     0.200
     1.110    -1.511     0.200
     1.275    -1.788     0.200
     1.275    -3.169     0.200
     1.397    -2.684     0.200
     1.399    -2.820     0.200
     1.379    -2.557     0.200
     1.519    -3.081     0.200
     1.690    -6.269     0.200
     1.801    -5.247     0.200
     1.724    -4.516     0.200
     1.930    -6.418     0.200
     1.920    -4.778     0.200
     1.960    -7.152     0.200
     2.047    -7.162     0.200
     2.135    -6.720     0.200
     2.266    -5.305     0.200
     2.263    -4.285     0.200
     2.172    -7.351     0.200
     2.286    -6.803     0.200
     2.309    -7.542     0.200
     2.299    -8.789     0.200
     2.317    -9.949     0.200
     2.317    -9.960     0.200
     2.316    -3.186     0.200
     2.362    -9.907     0.200
     2.375    -9.752     0.200
     2.375   -10.552     0.200
     2.375    -9.736     0.200
     2.375    -7.607     0.200
     2.384    -9.762     0.200
     2.411    -8.520     0.200
     2.445   -10.801     0.200
     2.505   -10.103     0.200
     2.533   -10.639     0.200
     2.548    -9.361     0.200
     2.644    -9.405     0.200
     2.690   -14.052     0.200
     2.738    -7.291     0.200
     2.710   -15.011     0.200
     2.798   -10.465     0.200
     2.907   -12.755     0.200
     2.906   -12.745     0.200
     2.915   -13.113     0.200
     2.976   -16.527     0.200
     3.143   -15.120     0.200
     3.148   -12.612     0.200
     3.248   -14.396     0.200
     3.347   -10.850     0.200
     3.638   -16.820     0.200
     3.730   -16.396     0.200
     3.766   -14.256     0.200
     3.726   -23.429     0.200
     3.854   -21.224     0.200
     4.174   -21.818     0.200
     4.308   -22.051     0.200
     4.392   -24.258     0.200
     4.399   -22.095     0.200
     4.419   -19.381     0.200
     4.438   -21.900     0.200
     4.469   -25.493     0.200
     4.546   -25.566     0.200
     4.684   -23.353     0.200
     4.675   -27.970     0.200
     4.675   -26.696     0.200
     4.854   -21.811     0.200
     5.226   -27.674     0.200
     5.386   -31.638     0.200
     5.513   -28.244     0.200
     5.588   -30.825     0.200
     6.030   -33.208     0.200
     6.305   -35.204     0.200
     6.369   -33.141     0.200
     6.422   -40.989     0.200
     7.486   -46.239     0.200
     7.519   -43.352     0.200
     7.609   -48.194     0.200
     7.854   -49.453     0.200
     9.560   -56.474     0.200
     1.129     0.908     0.200
     1.145    -0.852     0.200
     1.347    -0.428     0.200
     1.571    -4.559     0.200
     1.660    -3.657     0.200
     1.864    -5.134     0.200
     2.476   -10.178     0.200
     2.491   -12.820     0.200
     2.500    -8.207     0.200
     2.500    -8.215     0.200
     2.519    -9.029     0.200
     2.584   -11.860     0.200
     2.526   -10.803     0.200
     2.574    -8.740     0.200
     2.588    -8.185     0.200
     2.588    -8.204     0.200
     2.701    -9.923     0.200
     2.747   -10.481     0.200
     2.760    -8.825     0.200
     2.775    -9.374     0.200
     2.849   -10.174     0.200
     2.870   -11.280     0.200
     2.869   -11.270     0.200
     2.857   -10.629     0.200
     2.969   -12.363     0.200
     3.091   -13.037     0.200
     3.107   -10.536     0.200
     3.206   -13.608     0.200
     3.456   -15.617     0.200
     3.607   -20.721     0.200
     3.562   -14.745     0.200
     3.563   -14.773     0.200
     3.775   -17.115     0.200
     3.853   -18.824     0.200
     3.933   -15.827     0.200
     4.289   -18.568     0.200
     4.473   -24.821     0.200
     4.565   -20.557     0.200
     4.569   -22.289     0.200
     4.575   -18.816     0.200
     4.597   -27.915     0.200
     4.621   -25.528     0.200
     4.635   -25.992     0.200
     4.635   -22.340     0.200
     4.707   -22.842     0.200
     4.718   -19.725     0.200
     4.842   -23.334     0.200
     5.355   -24.080     0.200
     5.378   -22.289     0.200
     5.743   -33.365     0.200
     6.226   -31.615     0.200
     6.277   -28.396     0.200
     6.316   -33.240     0.200
     6.331   -41.988     0.200
     6.536   -30.635     0.200
     7.285   -37.055     0.200
     7.384   -48.618     0.200
     7.420   -46.821     0.200
     7.507   -45.220     0.200
     1.453     1.291     0.200
     1.482    -0.739     0.200
     2.495    -7.292     0.200
     2.752    -8.077     0.200
     2.793   -10.205     0.200
     2.871   -10.853     0.200
     2.872   -10.888     0.200
     3.131   -11.132     0.200
     3.336   -12.864     0.200
     3.607   -12.879     0.200
     3.835   -18.232     0.200
     3.834   -18.205     0.200
     3.814   -17.588     0.200
     3.953   -14.387     0.200
     4.025   -19.331     0.200
     4.509   -23.800     0.200
     4.806   -27.761     0.200
     4.758   -22.535     0.200
     5.041   -19.756     0.200
     5.204   -23.710     0.200
     5.289   -20.958     0.200
     5.301   -22.088     0.200
     5.321   -20.976     0.200
     5.340   -22.341     0.200
     5.355   -22.818     0.200
     5.675   -22.982     0.200
     6.477   -30.089     0.200
     6.588   -33.489     0.200
     7.118   -32.253     0.200
     8.420   -44.248     0.200
     1.454    -4.089     0.200
     1.861    -5.364     0.200
     2.283    -8.843     0.200
     2.407   -12.038     0.200
     2.561    -9.845     0.200
     2.572   -10.823     0.200
     2.814   -12.317     0.200
     3.134   -14.751     0.200
     3.314   -13.593     0.200
     3.427   -19.753     0.200
     3.559   -18.305     0.200
     3.712   -17.900     0.200
     4.449   -25.900     0.200
     4.870   -28.626     0.200
     0.282     6.543     0.200
     0.353     5.548     0.200
     0.594     2.622     0.200
     0.649     2.458     0.200
     0.745     1.557     0.200
     0.771     0.433     0.200
     0.980     0.866     0.200
     1.118    -0.955     0.200
     1.243    -4.317     0.200
     1.228    -1.236     0.200
     1.303    -2.669     0.200
     1.582    -2.647     0.200
     1.636    -4.018     0.200
     1.647    -4.715     0.200
     1.786    -5.606     0.200
     1.808    -5.589     0.200
     1.792    -6.019     0.200
     1.803    -4.972     0.200
     1.807    -5.524     0.200
     1.892    -4.869     0.200
     2.040    -4.778     0.200
     2.103    -5.716     0.200
     2.120    -6.492     0.200
     2.129    -5.939     0.200
     2.144    -5.053     0.200
     2.142    -4.535     0.200
     2.524    -7.292     0.200
     2.643    -9.990     0.200
     2.796   -11.476     0.200
     3.588   -14.997     0.200
     3.721   -20.454     0.200
     4.563   -26.099     0.200
     1.268    -0.721     0.200
     1.245    -0.960     0.200
     1.313    -0.036     0.200
     1.427     0.570     0.200
     1.427    -1.430     0.200
     1.724    -4.284     0.200
     1.925    -7.148     0.200
     1.971    -5.000     0.200
     2.130    -8.016     0.200
     2.328    -7.747     0.200
     2.323    -7.877     0.200
     2.594   -10.177     0.200
     2.679    -8.726     0.200
     3.347   -16.188     0.200
     3.701   -15.621     0.200
     3.657   -13.904     0.200
     4.040   -23.938     0.200
     4.129   -16.800     0.200
     4.206   -15.685     0.200
     4.437   -18.482     0.200
     4.549   -17.558     0.200
     4.652   -25.219     0.200
     5.954   -26.000     0.200
     6.079   -36.608     0.200
     6.743   -34.004     0.200
     7.164   -36.083     0.200
     7.251   -43.148     0.200
    11.197   -75.876     0.200
     1.009    -1.307     0.200
     1.391    -3.685     0.200
     1.488    -4.631     0.200
     2.027    -9.194     0.200
     2.206    -7.957     0.200
     2.289    -7.335     0.200
     2.339    -9.032     0.200
     2.442    -9.285     0.200
     2.790   -10.918     0.200
     3.009   -11.943     0.200
     3.046   -17.807     0.200
     3.967   -18.731     0.200
     4.059   -19.620     0.200
     4.206   -20.207     0.200
     0.142     9.020     0.200
     0.281     6.320     0.200
     0.349     5.298     0.200
     0.576     2.480     0.200
     0.724     1.639     0.200
     0.762     1.641     0.200
     1.000    -0.443     0.200
     1.133    -2.290     0.200
     1.240    -1.056     0.200
     1.235    -1.143     0.200
     1.283    -1.833     0.200
     1.560    -5.035     0.200
     1.670    -6.398     0.200
     1.650    -5.051     0.200
     1.764    -7.401     0.200
     1.793    -3.874     0.200
     1.788    -6.574     0.200
     1.794    -2.964     0.200
     1.827    -5.623     0.200
     1.907    -6.896     0.200
     2.097    -9.265     0.200
     2.121    -7.447     0.200
     2.125    -7.558     0.200
     2.135    -7.570     0.200
     2.136    -6.571     0.200
     2.142    -6.452     0.200
     2.147    -7.419     0.200
     2.207    -7.793     0.200
     2.219    -6.202     0.200
     2.240   -10.155     0.200
     2.278    -9.704     0.200
     2.336   -10.759     0.200
     2.380    -9.021     0.200
     2.477    -9.002     0.200
     2.536   -10.512     0.200
     2.687   -14.938     0.200
     3.181   -11.167     0.200
     3.502   -17.865     0.200
     3.590   -17.207     0.200
     3.672   -22.508     0.200
     3.739   -21.563     0.200
     4.583   -26.911     0.200
     1.294    -1.713     0.200
     1.398    -2.874     0.200
     1.747    -4.535     0.200
     1.900    -5.284     0.200
     2.253    -8.025     0.200
     2.359    -7.661     0.200
     2.415    -8.290     0.200
     2.597   -11.939     0.200
     2.598    -8.641     0.200
     2.567    -9.291     0.200
     2.615    -8.413     0.200
     2.669   -12.768     0.200
     2.697   -14.747     0.200
     2.675   -10.550     0.200
     2.699   -10.162     0.200
     2.710    -9.256     0.200
     2.739   -13.431     0.200
     2.755   -11.372     0.200
     2.769   -11.626     0.200
     2.768    -9.920     0.200
     2.768    -9.938     0.200
     2.782   -10.668     0.200
     2.785   -12.402     0.200
     2.755   -10.110     0.200
     2.818   -10.899     0.200
     2.850   -12.846     0.200
     2.903   -12.367     0.200
     2.922   -11.924     0.200
     2.918   -13.797     0.200
     2.978   -10.956     0.200
     2.974   -10.942     0.200
     3.041   -11.393     0.200
     3.129   -11.019     0.200
     3.121   -17.622     0.200
     3.199   -13.317     0.200
     3.262   -13.344     0.200
     3.297   -13.469     0.200
     3.426   -14.659     0.200
     3.536   -14.960     0.200
     3.536   -14.951     0.200
     3.544   -19.483     0.200
     3.564   -18.875     0.200
     3.650   -16.811     0.200
     3.651   -16.838     0.200
     3.733   -18.010     0.200
     3.861   -21.668     0.200
     3.950   -17.062     0.200
     3.979   -18.062     0.200
     3.979   -17.542     0.200
     3.984   -23.305     0.200
     3.985   -21.538     0.200
     4.001   -18.105     0.200
     4.010   -21.299     0.200
     4.028   -18.899     0.200
     3.979   -16.838     0.200
     4.084   -23.045     0.200
     4.239   -18.173     0.200
     4.261   -23.615     0.200
     4.492   -21.478     0.200
     4.582   -19.198     0.200
     4.744   -20.704     0.200
     4.740   -24.478     0.200
     4.742   -20.029     0.200
     4.971   -23.874     0.200
     4.999   -24.465     0.200
     5.108   -26.188     0.200
     5.304   -28.243     0.200
     5.317   -27.959     0.200
     5.391   -25.566     0.200
     5.572   -29.129     0.200
     5.683   -28.883     0.200
     5.719   -28.479     0.200
     5.841   -27.204     0.200
     6.019   -32.121     0.200
     6.199   -32.910     0.200
     6.270   -37.830     0.200
     6.992   -36.029     0.200
     8.439   -51.276     0.200
     9.035   -56.123     0.200
     9.355   -58.691     0.200
    20.240  -133.796     0.200
    20.532  -139.388     0.200
    21.657  -152.426     0.200
    21.708  -151.684     0.200
     0.735     0.176     0.200
     1.240    -2.724     0.200
     1.422    -3.653     0.200
     1.450    -4.188     0.200
     1.753    -8.065     0.200
     1.672    -4.370     0.200
     1.951    -7.073     0.200
     2.053    -8.039     0.200
     2.018    -8.570     0.200
     2.107    -9.274     0.200
     2.192    -8.584     0.200
     2.236    -9.269     0.200
     2.470   -11.184     0.200
     2.514    -8.997     0.200
     2.770   -16.138     0.200
     2.842   -12.401     0.200
     2.942   -12.490     0.200
     3.018   -15.601     0.200
     3.036   -11.643     0.200
     3.484   -16.070     0.200
     3.584   -18.682     0.200
     3.791   -23.726     0.200
     4.077   -17.373     0.200
     4.824   -28.720     0.200
     5.549   -27.746     0.200
     6.033   -32.317     0.200
     6.369   -33.836     0.200
     6.505   -40.685     0.200
     0.617     1.799     0.200
     0.560     2.591     0.200
     4.357   -25.335     0.200
     0.220     6.646     0.200
     0.479     2.588     0.200
     0.606     1.891     0.200
     0.765     0.334     0.200
     0.828     1.277     0.200
     1.013     0.765     0.200
     1.141    -1.512     0.200
     1.243    -1.222     0.200
     1.291    -1.845     0.200
     1.417    -2.317     0.200
     1.468    -3.027     0.200
     1.920    -4.918     0.200
     2.026    -8.007     0.200
     2.157    -3.634     0.200
     2.168    -5.683     0.200
     2.199    -5.038     0.200
     2.240    -4.435     0.200
     2.196    -8.522     0.200
     3.029   -17.829     0.200
     3.213   -15.883     0.200
     3.174   -14.928     0.200
     3.419   -15.739     0.200
     3.720   -17.015     0.200
     4.049   -22.767     0.200
     4.337   -25.026     0.200
     5.706   -37.094     0.200
     0.394     5.899     0.200
     0.640     2.844     0.200
     0.788     1.753     0.200
     0.935     1.068     0.200
     1.071    -0.708     0.200
     1.071    -0.950     0.200
     1.182    -0.619     0.200
     1.223    -2.871     0.200
     1.311    -1.797     0.200
     1.590    -3.371     0.200
     1.616    -3.380     0.200
     1.621    -2.126     0.200
     1.763    -5.425     0.200
     1.783    -4.223     0.200
     1.763    -5.210     0.200
     1.845    -4.071     0.200
     1.825    -5.834     0.200
     2.043    -5.829     0.200
     2.077    -6.427     0.200
     1.999    -6.789     0.200
     2.101    -6.019     0.200
     2.107    -4.544     0.200
     2.108    -4.554     0.200
     2.107    -6.466     0.200
     2.126    -6.855     0.200
     2.123    -5.855     0.200
     2.189    -5.050     0.200
     2.189    -7.764     0.200
     2.204    -6.748     0.200
     2.214    -6.094     0.200
     2.216    -8.082     0.200
     2.235    -7.005     0.200
     2.258    -5.741     0.200
     2.261    -7.332     0.200
     2.287    -8.299     0.200
     2.316    -9.410     0.200
     2.339   -10.586     0.200
     2.348    -8.426     0.200
     2.250    -3.717     0.200
     2.477    -9.988     0.200
     2.597    -8.211     0.200
     2.707    -7.317     0.200
     2.752   -13.176     0.200
     2.752   -13.167     0.200
     2.761   -15.859     0.200
     2.781   -15.200     0.200
     2.927   -12.751     0.200
     2.912   -13.856     0.200
     3.047    -9.697     0.200
     3.164   -15.117     0.200
     3.163   -15.089     0.200
     3.242   -13.758     0.200
     3.675   -19.310     0.200
     3.636   -22.195     0.200
     3.731   -18.991     0.200
     3.955   -16.431     0.200
     4.365   -23.222     0.200
     4.488   -26.845     0.200
     4.427   -24.625     0.200
     4.435   -23.380     0.200
     4.443   -23.202     0.200
     4.460   -22.527     0.200
     4.480   -24.161     0.200
     4.519   -24.275     0.200
     4.519   -28.681     0.200
     4.491   -22.488     0.200
     4.543   -27.508     0.200
     4.602   -24.687     0.200
     4.706   -21.110     0.200
     5.223   -32.877     0.200
     5.299   -33.024     0.200
     5.443   -28.507     0.200
     5.657   -32.427     0.200
     6.041   -32.826     0.200
     6.303   -41.114     0.200
     6.623   -38.993     0.200
     7.214   -46.472     0.200
     7.375   -48.620     0.200
     7.406   -46.211     0.200
     7.410   -43.419     0.200
     8.210   -51.725     0.200
    11.162   -77.517     0.200
     0.089     9.097     0.200
     0.290     5.245     0.200
     0.662     1.798     0.200
     0.784     0.450     0.200
     0.840     1.498     0.200
     0.976    -0.778     0.200
     1.046    -0.592     0.200
     1.352    -3.432     0.200
     1.391    -1.817     0.200
     1.490    -7.355     0.200
     1.612    -2.790     0.200
     1.785    -5.751     0.200
     1.839    -4.742     0.200
     2.014    -6.296     0.200
     2.215    -5.636     0.200
     2.260    -9.640     0.200
     2.372    -8.013     0.200
     2.384   -11.329     0.200
     2.384    -8.559     0.200
     2.426    -8.289     0.200
     2.436    -7.613     0.200
     2.445   -10.721     0.200
     2.548   -11.056     0.200
     2.782   -12.204     0.200
     3.716   -17.762     0.200
     3.727   -22.061     0.200
     3.748   -16.429     0.200
     3.865   -20.812     0.200
     4.423   -28.123     0.200
     0.371     6.036     0.200
     0.413     4.306     0.200
     0.587     2.845     0.200
     0.647     2.251     0.200
     0.834     0.914     0.200
     0.989    -0.296     0.200
     1.124    -1.583     0.200
     1.183    -1.632     0.200
     1.228    -1.632     0.200
     1.358    -2.304     0.200
     1.388    -2.098     0.200
     1.453    -1.811     0.200
     1.711    -3.468     0.200
     1.753    -4.455     0.200
     1.933    -5.504     0.200
     1.934    -7.752     0.200
     1.934    -5.481     0.200
     1.971    -7.882     0.200
     1.971    -6.273     0.200
     1.996    -6.267     0.200
     2.086    -6.318     0.200
     2.090    -5.135     0.200
     2.101    -4.841     0.200
     2.122    -7.987     0.200
     2.131    -6.771     0.200
     2.142    -7.316     0.200
     2.172    -8.122     0.200
     2.209    -6.129     0.200
     2.200    -7.841     0.200
     2.203    -7.369     0.200
     2.261    -7.554     0.200
     2.329    -8.412     0.200
     3.184   -10.452     0.200
     4.945   -26.495     0.200
     4.959   -27.864     0.200
     0.850     1.514     0.200
     2.196    -6.744     0.200
     2.222    -7.324     0.200
     2.243    -9.295     0.200
     2.362    -9.635     0.200
     2.362    -9.305     0.200
     2.393    -7.870     0.200
     2.434    -9.569     0.200
     2.508    -8.799     0.200
     2.803   -10.818     0.200
     2.829   -12.771     0.200
     2.850   -10.853     0.200
     3.150   -12.949     0.200
     3.179   -13.874     0.200
     3.258   -14.310     0.200
     3.780   -19.723     0.200
     4.008   -26.685     0.200
     4.069   -20.903     0.200
     4.110   -17.996     0.200
     4.130   -18.247     0.200
     4.182   -20.826     0.200
     4.260   -19.911     0.200
     4.695   -21.387     0.200
     4.868   -27.109     0.200
     4.939   -24.794     0.200
     5.268   -22.812     0.200
     5.621   -33.211     0.200
     5.746   -27.596     0.200
     6.618   -35.616     0.200
     0.210     6.378     0.200
     0.226     6.023     0.200
     0.274     5.368     0.200
     0.331     4.678     0.200
     0.498     3.103     0.200
     0.873     1.238     0.200
     1.242    -1.807     0.200
     1.349    -3.899     0.200
     1.348    -2.171     0.200
     1.378    -2.233     0.200
     1.555    -5.192     0.200
     1.861    -8.178     0.200
     1.893    -5.747     0.200
     1.934    -4.065     0.200
     2.000    -7.534     0.200
     2.224    -6.005     0.200
     2.232    -4.945     0.200
     2.241    -6.058     0.200
     2.264    -7.291     0.200
     2.276    -5.317     0.200
     2.290    -9.187     0.200
     2.292    -9.308     0.200
     2.292    -5.402     0.200
     2.294    -6.463     0.200
     2.316    -9.902     0.200
     2.314    -3.859     0.200
     2.329    -6.603     0.200
     2.329    -6.080     0.200
     2.331    -4.750     0.200
     2.356    -6.472     0.200
     2.356    -5.214     0.200
     2.375    -7.521     0.200
     2.400    -4.148     0.200
     2.463    -8.698     0.200
     2.547    -7.392     0.200
     2.650    -7.403     0.200
     2.774    -9.522     0.200
     2.832    -7.779     0.200
     2.881   -16.909     0.200
     3.023    -8.823     0.200
     3.053   -13.853     0.200
     3.054   -13.862     0.200
     3.083   -10.900     0.200
     3.062   -15.713     0.200
     3.082   -13.638     0.200
     3.776   -18.825     0.200
     3.895   -25.607     0.200
     3.984   -22.638     0.200
     4.227   -18.626     0.200
     4.265   -19.536     0.200
     4.231   -21.352     0.200
     4.377   -22.035     0.200
     4.821   -28.263     0.200
     6.163   -30.121     0.200
     6.584   -43.396     0.200
    11.470   -77.570     0.200
     1.162    -0.221     0.200
     1.197     0.463     0.200
     1.410    -0.366     0.200
     1.603    -4.892     0.200
     1.806    -5.592     0.200
     1.992    -5.856     0.200
     2.648   -12.653     0.200
     2.741    -9.488     0.200
     2.940   -13.096     0.200
     2.940   -13.105     0.200
     2.948   -13.710     0.200
     2.968   -11.998     0.200
     3.185   -14.464     0.200
     3.418   -13.357     0.200
     3.672   -20.858     0.200
     3.715   -21.512     0.200
     3.923   -15.084     0.200
     3.977   -19.834     0.200
     4.346   -17.267     0.200
     4.547   -24.167     0.200
     4.565   -26.828     0.200
     4.566   -23.543     0.200
     4.667   -27.631     0.200
     4.705   -20.713     0.200
     4.705   -25.264     0.200
     4.786   -26.178     0.200
     4.870   -20.689     0.200
     5.321   -31.082     0.200
     5.275   -26.094     0.200
     5.686   -29.268     0.200
     5.721   -26.527     0.200
     6.182   -28.494     0.200
     6.386   -29.498     0.200
     6.398   -34.442     0.200
     6.517   -31.490     0.200
     7.355   -39.635     0.200
     7.450   -43.168     0.200
     7.486   -43.836     0.200
     8.096   -41.849     0.200
     9.501   -58.495     0.200
     9.754   -53.432     0.200
     1.797    -7.252     0.200
     2.008    -7.625     0.200
     2.729   -10.584     0.200
     2.816   -15.327     0.200
     2.852   -10.770     0.200
     2.992   -13.679     0.200
     3.926   -21.946     0.200
     4.288   -23.338     0.200
     4.308   -22.570     0.200
     4.327   -21.792     0.200
     4.439   -22.995     0.200
     2.095   -10.701     0.200
     2.493    -8.927     0.200
     2.493    -8.917     0.200
     3.121   -18.563     0.200
     4.282   -24.716     0.200
     4.239   -25.283     0.200
     4.969   -23.080     0.200
     6.535   -32.801     0.200
     6.846   -36.284     0.200
     6.907   -38.590     0.200
     6.945   -40.688     0.200
     6.970   -35.394     0.200
     7.031   -41.911     0.200
     1.421    -3.149     0.200
     1.577    -7.792     0.200
     1.835    -5.386     0.200
     2.026    -7.075     0.200
     2.128   -10.654     0.200
     2.134   -12.562     0.200
     2.177   -12.637     0.200
     2.186    -9.327     0.200
     2.206   -12.663     0.200
     2.256    -6.836     0.200
     2.254    -8.851     0.200
     2.273    -8.725     0.200
     2.321   -12.641     0.200
     2.330    -7.294     0.200
     2.602   -13.108     0.200
     2.717   -14.259     0.200
     2.806   -16.514     0.200
     2.819   -12.460     0.200
     2.850   -12.781     0.200
     3.014   -14.405     0.200
     3.043   -13.129     0.200
     3.489   -17.954     0.200
     3.579   -13.975     0.200
     3.667   -18.152     0.200
     3.715   -17.827     0.200
     3.874   -22.661     0.200
     3.938   -20.398     0.200
     4.171   -19.709     0.200
     4.252   -21.357     0.200
     4.312   -22.105     0.200
     4.539   -18.494     0.200
     4.782   -26.874     0.200
     0.297     5.207     0.200
     0.290     5.118     0.200
     0.397     3.808     0.200
     0.522     2.772     0.200
     0.760     1.445     0.200
     0.860    -0.422     0.200
     1.156    -0.211     0.200
     1.197    -1.766     0.200
     1.559    -4.663     0.200
     1.781    -5.124     0.200
     1.813    -5.948     0.200
     1.869    -6.943     0.200
     1.822    -5.535     0.200
     2.025    -7.772     0.200
     2.082    -7.700     0.200
     2.069    -6.586     0.200
     2.080    -7.060     0.200
     2.075    -7.054     0.200
     2.111    -7.513     0.200
     2.120    -8.036     0.200
     2.129    -7.676     0.200
     2.129    -7.003     0.200
     2.151    -8.284     0.200
     2.152    -8.061     0.200
     2.176    -7.044     0.200
     2.187    -8.526     0.200
     2.204    -8.682     0.200
     2.266    -8.918     0.200
     2.282    -9.093     0.200
     2.435    -9.263     0.200
     2.485    -9.808     0.200
     2.691   -12.044     0.200
     2.752   -12.392     0.200
     2.759   -10.908     0.200
     2.760   -11.883     0.200
     2.832   -13.324     0.200
     2.888   -14.841     0.200
     3.018   -14.721     0.200
     3.468   -18.281     0.200
     3.633   -18.832     0.200
     3.667   -18.742     0.200
     3.896   -24.759     0.200
     3.931   -22.840     0.200
     4.199   -21.686     0.200
     4.218   -22.059     0.200
     4.237   -22.900     0.200
     4.354   -23.187     0.200
     4.784   -29.261     0.200
     5.486   -33.808     0.200
     1.180     0.046     0.200
     2.636    -8.692     0.200
     2.903   -14.195     0.200
     3.047   -11.381     0.200
     3.186   -11.148     0.200
     3.187   -11.157     0.200
     3.214   -15.075     0.200
     3.229   -13.769     0.200
     3.468   -17.537     0.200
     3.927   -23.530     0.200
     4.323   -17.089     0.200
     4.435   -17.475     0.200
     4.505   -19.887     0.200
     5.445   -23.285     0.200
     5.578   -24.828     0.200
     5.671   -33.968     0.200
     5.972   -31.756     0.200
     6.380   -29.375     0.200
     6.637   -37.757     0.200
     7.609   -38.866     0.200
     8.709   -53.291     0.200
     1.353    -2.394     0.200
     1.557    -6.629     0.200
     1.875    -6.893     0.200
     2.025    -8.621     0.200
     2.107    -6.765     0.200
     2.394    -7.310     0.200
     2.362    -8.556     0.200
     2.447    -7.488     0.200
     2.455    -9.610     0.200
     2.465    -8.614     0.200
     2.481    -8.807     0.200
     2.497    -8.274     0.200
     2.533    -8.958     0.200
     2.572   -10.196     0.200
     2.603    -9.560     0.200
     2.761    -9.010     0.200
     2.764    -9.163     0.200
     2.814   -11.189     0.200
     2.890   -15.076     0.200
     2.983   -14.581     0.200
     3.143   -11.948     0.200
     3.142   -11.938     0.200
     3.151   -10.800     0.200
     3.200   -11.478     0.200
     3.170   -15.563     0.200
     3.467   -20.667     0.200
     3.808   -16.037     0.200
     3.916   -19.017     0.200
     3.913   -23.144     0.200
     3.987   -15.689     0.200
     4.103   -20.498     0.200
     4.277   -21.680     0.200
     4.300   -22.621     0.200
     4.315   -20.547     0.200
     4.319   -19.536     0.200
     4.418   -26.045     0.200
     4.422   -20.438     0.200
     4.910   -29.085     0.200
     4.910   -28.029     0.200
     4.940   -23.774     0.200
     5.437   -34.175     0.200
     5.453   -31.394     0.200
     5.625   -34.555     0.200
     6.189   -32.370     0.200
     6.317   -32.235     0.200
     6.599   -34.049     0.200
     6.630   -38.445     0.200
     7.575   -48.330     0.200
     7.686   -50.864     0.200
     7.721   -41.354     0.200
     7.809   -48.483     0.200
     7.977   -47.355     0.200
     8.328   -51.276     0.200
     8.349   -49.958     0.200
     9.534   -56.233     0.200
     9.711   -59.243     0.200
    11.012   -71.121     0.200
    11.611   -74.337     0.200
    12.560   -78.923     0.200
     0.308     5.260     0.200
     0.781     0.826     0.200
     1.061    -1.176     0.200
     1.017    -0.174     0.200
     1.407    -5.133     0.200
     1.465    -4.781     0.200
     1.440    -2.187     0.200
     1.778    -6.574     0.200
     1.864    -7.070     0.200
     1.864    -7.271     0.200
     1.931    -5.284     0.200
     2.088    -5.600     0.200
     2.150    -6.975     0.200
     2.258    -7.469     0.200
     2.273    -7.706     0.200
     2.280    -7.735     0.200
     2.341   -10.205     0.200
     2.314    -8.712     0.200
     2.428   -11.431     0.200
     2.357    -9.556     0.200
     2.369    -6.556     0.200
     2.385    -9.968     0.200
     2.391    -8.571     0.200
     2.401    -8.928     0.200
     2.402    -8.952     0.200
     2.431    -8.235     0.200
     2.461    -9.029     0.200
     2.461    -8.839     0.200
     2.445    -9.607     0.200
     2.465    -9.196     0.200
     2.454    -9.931     0.200
     2.502    -9.248     0.200
     2.494   -10.691     0.200
     2.514    -9.650     0.200
     2.520    -9.879     0.200
     2.521    -9.901     0.200
     2.509    -7.951     0.200
     2.524    -8.668     0.200
     2.543   -10.065     0.200
     2.606   -12.267     0.200
     2.628   -11.793     0.200
     2.557    -7.183     0.200
     2.576   -10.612     0.200
     2.613   -10.383     0.200
     2.624   -10.071     0.200
     2.659   -10.475     0.200
     2.616    -9.549     0.200
     2.850   -14.010     0.200
     2.760    -8.816     0.200
     2.831   -13.221     0.200
     2.769   -10.412     0.200
     2.879   -12.313     0.200
     2.977   -12.462     0.200
     2.900   -12.486     0.200
     3.196   -15.818     0.200
     3.372   -17.234     0.200
     3.318   -13.854     0.200
     3.319   -13.881     0.200
     3.448   -18.842     0.200
     3.601   -19.759     0.200
     3.601   -19.750     0.200
     3.610   -19.569     0.200
     3.630   -19.269     0.200
     3.556   -15.381     0.200
     3.710   -16.784     0.200
     3.717   -16.650     0.200
     3.728   -17.090     0.200
     3.735   -17.384     0.200
     3.829   -18.027     0.200
     3.991   -18.290     0.200
     4.464   -28.884     0.200
     4.500   -25.960     0.200
     4.575   -25.970     0.200
     4.645   -21.177     0.200
     4.856   -27.421     0.200
     5.270   -34.485     0.200
     5.366   -35.454     0.200
     5.366   -31.353     0.200
     5.354   -26.049     0.200
     5.839   -36.584     0.200
     6.065   -40.898     0.200
     7.070   -43.350     0.200
     7.151   -49.052     0.200
     8.065   -49.652     0.200
     8.219   -53.158     0.200
     8.251   -52.668     0.200
     8.342   -53.408     0.200
     9.898   -65.873     0.200
    10.169   -71.929     0.200
    10.599   -66.040     0.200
    10.746   -66.884     0.200
     1.269    -0.768     0.200
     1.503    -2.476     0.200
     1.984    -9.736     0.200
     2.335    -7.939     0.200
     2.491    -8.545     0.200
     2.550    -7.684     0.200
     2.618   -14.146     0.200
     2.720    -8.485     0.200
     2.715   -10.451     0.200
     2.824    -9.052     0.200
     2.859   -10.359     0.200
     3.270   -13.137     0.200
     3.297   -16.021     0.200
     3.296   -16.011     0.200
     3.396   -12.642     0.200
     3.679   -18.280     0.200
     3.679   -18.308     0.200
     4.016   -24.121     0.200
     4.121   -19.157     0.200
     4.259   -23.518     0.200
     4.272   -24.015     0.200
     4.381   -24.076     0.200
     4.619   -21.408     0.200
     5.100   -24.172     0.200
     5.062   -23.573     0.200
     5.937   -31.576     0.200
     6.342   -37.243     0.200
     9.493   -61.710     0.200
     9.579   -62.647     0.200
     0.038    10.222     0.200
     0.807     0.193     0.200
     0.958    -0.183     0.200
     1.133    -0.652     0.200
     1.265    -3.483     0.200
     1.365    -3.710     0.200
     1.433    -4.166     0.200
     1.555    -6.899     0.200
     1.658    -7.161     0.200
     1.777    -4.339     0.200
     1.900    -6.876     0.200
     1.926    -4.349     0.200
     1.903    -3.643     0.200
     1.984    -6.207     0.200
     2.100    -4.982     0.200
     2.154    -9.426     0.200
     2.173    -6.061     0.200
     2.178    -5.061     0.200
     2.202    -9.014     0.200
     2.217    -8.976     0.200
     2.213    -8.421     0.200
     2.247    -8.870     0.200
     2.237    -5.595     0.200
     2.265    -6.270     0.200
     2.266   -10.007     0.200
     2.329    -6.783     0.200
     2.354   -11.766     0.200
     2.401   -11.548     0.200
     2.456   -11.242     0.200
     2.566   -10.308     0.200
     2.554    -9.589     0.200
     2.598   -11.244     0.200
     2.575   -13.968     0.200
     2.732   -10.074     0.200
     2.754   -12.417     0.200
     2.844   -14.910     0.200
     3.035   -14.382     0.200
     3.305   -15.216     0.200
     3.543   -18.037     0.200
     3.587   -21.467     0.200
     3.672   -19.468     0.200
     3.702   -20.905     0.200
     3.776   -20.085     0.200
     4.536   -21.863     0.200
     4.522   -28.584     0.200
     4.672   -27.201     0.200
     5.233   -33.761     0.200
     5.718   -32.925     0.200
     6.275   -41.286     0.200
     1.076    -0.061     0.200
     1.076    -0.221     0.200
     1.352    -2.754     0.200
     1.538    -3.818     0.200
     1.538    -4.137     0.200
     1.671    -5.156     0.200
     1.781    -8.216     0.200
     1.781    -8.506     0.200
     2.158    -8.012     0.200
     2.166    -7.544     0.200
     2.210    -7.832     0.200
     2.210    -8.383     0.200
     2.442    -8.223     0.200
     2.472   -11.955     0.200
     2.468    -7.826     0.200
     2.661   -14.195     0.200
     2.657    -9.793     0.200
     2.671    -9.025     0.200
     2.710    -9.477     0.200
     2.762   -10.603     0.200
     2.778    -9.550     0.200
     2.776   -11.876     0.200
     2.804   -18.226     0.200
     2.792    -9.579     0.200
     2.828   -12.588     0.200
     2.867   -11.231     0.200
     2.871   -11.444     0.200
     2.874   -11.332     0.200
     2.896   -11.907     0.200
     2.948   -15.175     0.200
     2.951   -11.649     0.200
     3.048   -12.517     0.200
     3.054   -14.320     0.200
     3.116   -18.909     0.200
     3.200   -13.695     0.200
     3.221   -14.402     0.200
     3.278   -14.672     0.200
     3.328   -14.074     0.200
     3.748   -16.305     0.200
     3.748   -16.332     0.200
     3.801   -16.153     0.200
     3.833   -20.978     0.200
     3.902   -21.213     0.200
     3.902   -20.177     0.200
     3.902   -20.555     0.200
     3.902   -20.287     0.200
     4.157   -23.180     0.200
     4.135   -22.707     0.200
     4.574   -26.760     0.200
     4.545   -29.865     0.200
     4.545   -27.035     0.200
     4.632   -28.374     0.200
     4.778   -26.646     0.200
     5.361   -27.975     0.200
     5.382   -33.930     0.200
     5.494   -30.626     0.200
     5.773   -30.751     0.200
     5.890   -33.927     0.200
     6.170   -40.265     0.200
     6.318   -32.925     0.200
     6.511   -36.928     0.200
     6.503   -36.260     0.200
     6.606   -37.132     0.200
     6.621   -44.068     0.200
     6.813   -41.680     0.200
     6.905   -46.453     0.200
     6.955   -37.249     0.200
     7.092   -39.482     0.200
     7.234   -43.248     0.200
     7.241   -44.173     0.200
     8.278   -53.995     0.200
     8.338   -53.163     0.200
     8.679   -55.448     0.200
     8.679   -56.790     0.200
     9.581   -57.969     0.200
     9.679   -66.911     0.200
     9.742   -66.794     0.200
     9.742   -61.826     0.200
    10.001   -61.386     0.200
    10.406   -58.277     0.200
    10.747   -73.914     0.200
    10.747   -72.858     0.200
    11.535   -68.920     0.200
    12.097   -75.399     0.200
    16.070  -105.155     0.200
    16.642  -109.782     0.200
     0.237     6.727     0.200
     0.494     3.053     0.200
     0.799    -0.002     0.200
     0.987    -1.579     0.200
     1.053    -1.354     0.200
     1.084    -1.547     0.200
     1.128    -0.660     0.200
     1.334    -2.856     0.200
     1.338    -3.039     0.200
     1.453    -3.445     0.200
     1.531    -2.573     0.200
     1.528    -3.095     0.200
     1.738    -5.747     0.200
     1.879    -6.766     0.200
     1.987    -7.261     0.200
     2.001    -4.655     0.200
     2.047    -6.999     0.200
     2.054    -8.020     0.200
     2.073    -7.148     0.200
     2.074    -6.652     0.200
     2.112    -7.033     0.200
     2.137    -7.133     0.200
     2.141    -9.106     0.200
     2.218    -7.100     0.200
     2.223    -7.739     0.200
     2.220    -7.413     0.200
     2.255    -6.663     0.200
     2.266    -8.153     0.200
     2.270    -7.571     0.200
     2.287    -7.832     0.200
     2.316    -6.019     0.200
     2.302    -9.937     0.200
     2.312   -10.492     0.200
     2.329    -8.737     0.200
     2.342    -9.766     0.200
     2.353    -6.504     0.200
     2.454    -9.029     0.200
     2.600    -9.580     0.200
     2.605   -10.494     0.200
     2.837   -11.112     0.200
     3.145   -17.688     0.200
     3.268   -15.338     0.200
     3.310   -11.278     0.200
     3.321   -17.777     0.200
     4.070   -24.521     0.200
     4.221   -24.896     0.200
     0.169     7.990     0.200
     0.541     2.803     0.200
     0.722     0.779     0.200
     0.794     1.210     0.200
     0.878     0.095     0.200
     1.004    -0.266     0.200
     1.129    -1.030     0.200
     1.252    -1.750     0.200
     1.388    -2.343     0.200
     1.523    -0.636     0.200
     1.677    -2.536     0.200
     1.777    -4.872     0.200
     1.814    -7.671     0.200
     1.907    -4.836     0.200
     1.918    -8.355     0.200
     1.963    -5.138     0.200
     2.018    -6.865     0.200
     2.037    -6.746     0.200
     2.042    -6.498     0.200
     2.078   -11.124     0.200
     2.094    -8.928     0.200
     2.101    -9.615     0.200
     2.143   -10.589     0.200
     2.150    -9.071     0.200
     2.344   -11.705     0.200
     2.332    -9.153     0.200
     2.420    -8.291     0.200
     2.476   -11.020     0.200
     2.538   -13.448     0.200
     2.632   -14.747     0.200
     2.664    -9.374     0.200
     3.542   -22.606     0.200
     4.431   -23.877     0.200
     0.235     6.339     0.200
     0.398     4.133     0.200
     0.376     4.602     0.200
     0.872     1.331     0.200
     1.161    -0.525     0.200
     1.340    -3.485     0.200
     1.873    -5.726     0.200
     1.941    -5.337     0.200
     2.179    -6.871     0.200
     2.151   -10.379     0.200
     2.215    -8.118     0.200
     2.243    -7.634     0.200
     2.218    -6.231     0.200
     2.216    -8.716     0.200
     2.263   -10.344     0.200
     2.265   -10.411     0.200
     2.270    -9.710     0.200
     2.284    -8.057     0.200
     2.319    -5.096     0.200
     2.335   -12.235     0.200
     2.336   -12.251     0.200
     2.345    -9.909     0.200
     2.365   -11.242     0.200
     2.409   -10.912     0.200
     2.379   -11.859     0.200
     2.424    -7.882     0.200
     2.455   -11.954     0.200
     2.528    -7.350     0.200
     2.606    -7.219     0.200
     2.740    -8.061     0.200
     2.817   -12.694     0.200
     2.872   -11.445     0.200
     3.005   -16.427     0.200
     2.994   -12.462     0.200
     2.971   -13.927     0.200
     3.177   -17.728     0.200
     3.277   -15.855     0.200
     3.278   -15.883     0.200
     3.344   -17.134     0.200
     3.788   -19.908     0.200
     3.803   -20.054     0.200
     3.785   -13.742     0.200
     4.019   -27.507     0.200
     4.142   -23.291     0.200
     4.253   -20.531     0.200
     4.290   -21.571     0.200
     7.773   -48.455     0.200
     7.729   -43.703     0.200
     7.806   -47.129     0.200
     7.896   -50.804     0.200
     8.422   -48.918     0.200
     0.379     6.043     0.200
     0.383     5.907     0.200
     0.470     5.094     0.200
     0.716     2.532     0.200
     1.069    -0.292     0.200
     1.187    -0.672     0.200
     1.725    -1.470     0.200
     1.839    -5.776     0.200
     2.011    -7.213     0.200
     2.110    -5.013     0.200
     2.117    -5.912     0.200
     2.116    -8.571     0.200
     2.125    -3.499     0.200
     2.156    -3.150     0.200
     2.333    -9.967     0.200
     2.710   -11.138     0.200
     2.864   -13.563     0.200
     2.968   -17.380     0.200
     3.077   -16.280     0.200
     3.393   -21.058     0.200
     3.644   -15.291     0.200
     3.977   -24.141     0.200
     4.270   -24.449     0.200
     5.321   -32.694     0.200
     1.119    -0.642     0.200
     1.737    -7.062     0.200
     1.700    -5.806     0.200
     2.574   -10.682     0.200
     2.574    -8.532     0.200
     2.574   -10.938     0.200
     2.740   -10.289     0.200
     2.799   -12.357     0.200
     2.917   -13.209     0.200
     3.022   -13.824     0.200
     3.022   -13.814     0.200
     3.031   -11.511     0.200
     3.094   -12.309     0.200
     3.316   -14.158     0.200
     3.545   -14.953     0.200
     3.610   -19.462     0.200
     3.773   -23.212     0.200
     4.459   -17.633     0.200
     4.560   -24.805     0.200
     4.789   -26.352     0.200
     4.789   -25.906     0.200
     4.935   -21.115     0.200
     5.215   -29.001     0.200
     5.346   -26.119     0.200
     5.895   -33.266     0.200
     6.077   -32.921     0.200
     6.241   -30.615     0.200
     6.473   -33.752     0.200
     6.495   -39.429     0.200
     6.495   -34.440     0.200
     6.667   -37.832     0.200
     7.446   -42.006     0.200
     7.585   -46.910     0.200
     8.210   -46.768     0.200
     8.547   -48.803     0.200
     8.547   -56.835     0.200
     9.274   -52.674     0.200
    10.078   -58.555     0.200
    10.439   -65.243     0.200
    10.419   -60.961     0.200
    10.451   -65.644     0.200
    10.439   -61.454     0.200
    10.550   -60.303     0.200
    10.740   -65.554     0.200
    10.692   -71.674     0.200
    10.770   -72.811     0.200
    10.970   -64.046     0.200
    11.513   -79.052     0.200
    11.513   -72.221     0.200
    12.160   -73.320     0.200
    12.155   -72.877     0.200
    12.464   -74.031     0.200
    13.150   -79.702     0.200
    13.576   -89.329     0.200
    13.996   -85.495     0.200
    14.186   -87.568     0.200
    14.426   -90.547     0.200
    15.015   -94.577     0.200
    15.486  -100.609     0.200
    15.599   -98.508     0.200
    16.151  -103.170     0.200
    16.317  -104.238     0.200
    16.764  -115.289     0.200
    22.401  -160.818     0.200
     1.093    -0.114     0.200
     2.549    -9.905     0.200
     2.786   -14.938     0.200
     3.054   -13.866     0.200
     3.053   -11.633     0.200
     3.572   -20.968     0.200
     3.808   -24.369     0.200
     4.418   -24.538     0.200
     4.519   -25.079     0.200
     4.814   -29.421     0.200
     4.814   -27.880     0.200
     4.814   -21.882     0.200
     4.892   -24.360     0.200
     5.176   -29.944     0.200
     5.540   -21.617     0.200
     6.211   -29.815     0.200
     6.500   -30.716     0.200
     7.475   -49.875     0.200
     7.582   -48.418     0.200
     7.617   -48.213     0.200
     7.705   -50.998     0.200
     8.006   -42.497     0.200
     8.564   -53.982     0.200
     8.711   -49.345     0.200
     9.615   -54.809     0.200
    10.449   -65.818     0.200
    11.528   -77.511     0.200
    11.528   -77.120     0.200
    11.528   -79.120     0.200
     1.027    -0.022     0.200
     3.548   -18.623     0.200
     4.380   -19.087     0.200
     4.750   -20.862     0.200
     4.807   -28.947     0.200
     5.147   -28.746     0.200
     5.346   -24.415     0.200
     5.529   -26.740     0.200
     5.991   -28.598     0.200
     7.476   -47.831     0.200
     7.593   -51.150     0.200
     7.628   -50.250     0.200
     7.717   -45.057     0.200
     7.939   -44.025     0.200
     9.559   -52.458     0.200
    10.358   -61.592     0.200
    12.074   -76.096     0.200
     0.742     1.270     0.200
     0.995     0.323     0.200
     1.265    -2.894     0.200
     1.802    -7.481     0.200
     2.018    -5.704     0.200
     2.027    -7.168     0.200
     2.078    -7.098     0.200
     2.256   -10.917     0.200
     2.334    -9.762     0.200
     2.341   -11.128     0.200
     2.355   -10.104     0.200
     2.356   -10.659     0.200
     2.362    -8.462     0.200
     2.370    -8.634     0.200
     2.379    -9.769     0.200
     2.440    -9.419     0.200
     2.510    -8.961     0.200
     2.511   -11.548     0.200
     2.569   -10.941     0.200
     2.632   -13.603     0.200
     2.590   -10.502     0.200
     2.672    -9.977     0.200
     2.689   -13.625     0.200
     2.710    -9.568     0.200
     2.782   -10.841     0.200
     2.819   -10.703     0.200
     2.857   -12.591     0.200
     2.857   -12.581     0.200
     2.865   -16.233     0.200
     2.944   -11.068     0.200
     3.342   -14.283     0.200
     3.414   -17.113     0.200
     3.415   -17.141     0.200
     3.650   -22.007     0.200
     3.717   -20.012     0.200
     3.818   -22.112     0.200
     4.625   -26.865     0.200
     4.625   -28.498     0.200
     4.697   -25.293     0.200
     5.309   -32.175     0.200
     5.961   -36.334     0.200
     7.932   -49.767     0.200
     1.268     1.080     0.200
     1.350    -0.517     0.200
     1.382     0.403     0.200
     1.691    -2.927     0.200
     2.252    -5.752     0.200
     2.252    -5.422     0.200
     2.677    -9.513     0.200
     2.745    -9.748     0.200
     2.793    -9.397     0.200
     0.302     6.083     0.200
     0.385     3.769     0.200
     0.686     0.636     0.200
     0.699     1.456     0.200
     0.859    -0.099     0.200
     0.899    -0.050     0.200
     1.141    -0.977     0.200
     1.165    -1.362     0.200
     1.204    -1.719     0.200
     1.289    -3.534     0.200
     1.323    -2.177     0.200
     1.372    -4.205     0.200
     1.524    -3.556     0.200
     1.886    -6.828     0.200
     1.892    -7.128     0.200
     1.956    -7.942     0.200
     1.956    -8.103     0.200
     2.005    -6.337     0.200
     2.018    -6.262     0.200
     2.044    -8.811     0.200
     2.055    -4.442     0.200
     2.076    -5.558     0.200
     2.084    -6.601     0.200
     2.098   -10.183     0.200
     2.100    -7.871     0.200
     2.110    -7.961     0.200
     2.160    -8.391     0.200
     2.226    -8.559     0.200
     2.244   -11.587     0.200
     2.283   -11.623     0.200
     2.322   -11.374     0.200
     2.334   -10.735     0.200
     2.355   -10.579     0.200
     2.374    -7.879     0.200
     2.409    -9.609     0.200
     2.415   -10.358     0.200
     2.445    -9.939     0.200
     2.511   -13.220     0.200
     2.525   -13.071     0.200
     2.629    -9.529     0.200
     2.850   -11.492     0.200
     2.916   -12.931     0.200
     2.952   -18.525     0.200
     3.072   -15.474     0.200
     3.321   -13.825     0.200
     3.452   -16.482     0.200
     3.866   -22.168     0.200
     4.581   -28.759     0.200
     0.312     5.673     0.200
     0.411     4.669     0.200
     0.642     1.880     0.200
     0.855     0.288     0.200
     0.871    -0.500     0.200
     0.998     0.179     0.200
     1.130    -1.159     0.200
     1.166    -1.621     0.200
     1.269    -2.642     0.200
     1.275    -2.097     0.200
     1.446    -3.800     0.200
     1.604    -4.279     0.200
     1.621    -5.098     0.200
     1.811    -6.286     0.200
     1.944    -6.449     0.200
     1.952    -7.550     0.200
     1.960    -6.629     0.200
     1.982    -7.199     0.200
     1.983    -7.697     0.200
     1.993    -7.701     0.200
     2.014    -7.813     0.200
     2.022    -6.994     0.200
     2.049    -8.213     0.200
     2.056    -7.564     0.200
     2.089    -7.771     0.200
     2.115    -7.673     0.200
     2.120    -5.772     0.200
     2.176   -10.621     0.200
     2.284    -9.875     0.200
     2.321   -10.276     0.200
     2.372    -9.146     0.200
     2.405    -9.651     0.200
     2.408   -10.085     0.200
     2.409   -11.025     0.200
     2.449   -12.967     0.200
     2.484   -10.463     0.200
     2.487   -13.565     0.200
     2.502    -6.135     0.200
     2.656   -11.371     0.200
     2.667   -14.131     0.200
     2.673   -11.727     0.200
     2.802   -15.415     0.200
     2.984   -13.611     0.200
     3.349   -17.026     0.200
     3.548   -18.718     0.200
     3.566   -18.606     0.200
     3.712   -19.348     0.200
     4.428   -24.227     0.200
     4.520   -26.817     0.200
     5.190   -28.280     0.200
     5.291   -29.987     0.200
     5.422   -31.634     0.200
     6.133   -36.684     0.200
     1.172     0.228     0.200
     2.556    -8.186     0.200
     2.557    -8.196     0.200
     2.650   -14.046     0.200
     2.650   -10.515     0.200
     2.724    -9.377     0.200
     2.759   -12.038     0.200
     2.791   -15.261     0.200
     2.894   -12.001     0.200
     2.969   -13.413     0.200
     2.969   -13.403     0.200
     3.179   -18.436     0.200
     3.405   -16.962     0.200
     3.596   -17.283     0.200
     3.597   -17.311     0.200
     3.698   -22.825     0.200
     3.692   -20.659     0.200
     4.219   -20.037     0.200
     4.547   -27.986     0.200
     4.647   -24.201     0.200
     4.734   -27.889     0.200
     5.299   -22.634     0.200
     5.983   -41.326     0.200
     1.602    -6.092     0.200
     2.461    -8.832     0.200
     2.625    -9.109     0.200
     3.638   -21.501     0.200
     4.448   -22.638     0.200
     4.669   -28.024     0.200
     4.669   -27.634     0.200
     4.669   -25.729     0.200
     7.319   -42.654     0.200
     7.416   -44.214     0.200
     7.623   -40.607     0.200
     9.548   -52.569     0.200
     0.312     5.315     0.200
     0.363     4.715     0.200
     0.489     3.073     0.200
     0.884    -0.111     0.200
     1.152    -2.069     0.200
     1.254    -2.005     0.200
     1.530    -8.263     0.200
     1.797    -5.256     0.200
     1.844    -5.132     0.200
     2.058    -6.119     0.200
     2.087    -6.428     0.200
     2.106    -4.211     0.200
     2.130    -7.379     0.200
     2.116    -7.701     0.200
     2.136    -4.314     0.200
     2.166    -6.455     0.200
     2.173    -6.784     0.200
     2.176    -6.780     0.200
     2.182    -8.902     0.200
     2.206    -9.365     0.200
     2.208    -5.854     0.200
     2.230    -7.449     0.200
     2.232    -6.837     0.200
     2.235    -8.258     0.200
     2.287    -7.961     0.200
     2.297    -6.938     0.200
     2.369    -8.378     0.200
     2.451    -6.062     0.200
     2.735   -11.247     0.200
     2.724   -11.545     0.200
     2.745    -9.593     0.200
     2.866   -12.078     0.200
     3.199   -13.589     0.200
     3.440   -14.805     0.200
     3.964   -22.179     0.200
     4.090   -19.608     0.200
     4.330   -21.279     0.200
     4.817   -28.848     0.200
     0.408     5.229     0.200
     0.610     2.387     0.200
     0.875    -0.120     0.200
     1.018    -0.401     0.200
     1.111    -1.216     0.200
     1.217    -2.504     0.200
     1.205    -0.703     0.200
     1.263    -2.899     0.200
     1.865    -6.935     0.200
     1.916    -9.115     0.200
     1.957    -6.158     0.200
     1.954    -9.500     0.200
     1.972    -5.371     0.200
     1.976    -8.675     0.200
     1.985    -7.580     0.200
     2.005   -11.121     0.200
     2.011    -9.704     0.200
     2.065    -6.310     0.200
     2.129    -9.192     0.200
     2.208    -8.163     0.200
     2.313   -11.509     0.200
     2.355    -8.195     0.200
     2.353    -7.701     0.200
     2.355    -9.632     0.200
     2.398    -7.511     0.200
     2.403    -9.259     0.200
     2.428    -9.976     0.200
     2.432    -7.302     0.200
     2.435   -13.790     0.200
     2.514   -13.745     0.200
     2.621   -15.332     0.200
     2.621   -12.518     0.200
     2.764   -13.997     0.200
     2.833   -14.848     0.200
     2.853   -17.464     0.200
     3.029   -14.244     0.200
     3.300   -16.633     0.200
     3.534   -19.026     0.200
     3.745   -20.238     0.200
     5.138   -28.559     0.200
     5.238   -30.114     0.200
     5.370   -33.233     0.200
     5.506   -34.477     0.200
     6.055   -33.144     0.200
     6.579   -41.629     0.200
     6.610   -41.028     0.200
     6.702   -42.993     0.200
     0.512     3.852     0.200
     0.480     4.889     0.200
     0.718     2.151     0.200
     1.005    -0.018     0.200
     1.046    -0.366     0.200
     1.101    -0.375     0.200
     1.247    -1.378     0.200
     1.335    -2.151     0.200
     1.349    -1.027     0.200
     1.686    -4.401     0.200
     1.750    -8.552     0.200
     1.802    -5.800     0.200
     1.838   -11.331     0.200
     1.857    -6.890     0.200
     1.903    -5.941     0.200
     1.952    -7.233     0.200
     2.038    -6.642     0.200
     1.990    -3.767     0.200
     2.153    -6.279     0.200
     2.158    -7.036     0.200
     2.091    -4.614     0.200
     2.219    -8.394     0.200
     2.060    -6.516     0.200
     2.240    -7.716     0.200
     2.471   -13.852     0.200
     2.965   -14.094     0.200
     3.021   -17.245     0.200
     3.295   -10.978     0.200
     3.857   -21.880     0.200
     4.561   -27.973     0.200
     4.957   -29.399     0.200
     5.186   -29.349     0.200
     6.261   -35.720     0.200
     0.217     5.752     0.200
     0.295     4.908     0.200
     0.910     0.074     0.200
     1.198    -1.706     0.200
     1.360    -3.297     0.200
     1.378    -2.952     0.200
     1.439    -4.213     0.200
     1.487    -4.396     0.200
     1.912    -7.001     0.200
     1.976    -8.358     0.200
     1.978    -7.114     0.200
     1.995    -7.084     0.200
     2.187    -8.501     0.200
     2.250    -8.619     0.200
     2.256    -9.808     0.200
     2.261    -8.429     0.200
     2.297    -8.147     0.200
     2.303    -9.401     0.200
     2.308    -8.787     0.200
     2.319   -10.175     0.200
     2.343    -9.947     0.200
     2.355    -9.824     0.200
     2.378   -10.082     0.200
     2.410   -10.622     0.200
     2.417   -10.429     0.200
     2.567   -11.432     0.200
     2.645   -11.586     0.200
     2.774   -12.735     0.200
     2.874   -13.364     0.200
     2.910   -14.239     0.200
     2.995   -15.258     0.200
     3.012   -14.135     0.200
     3.173   -15.316     0.200
     3.317   -15.976     0.200
     3.816   -20.229     0.200
     4.011   -22.313     0.200
     4.027   -21.403     0.200
     4.100   -22.117     0.200
     4.270   -23.352     0.200
     4.941   -28.662     0.200
     5.647   -32.880     0.200
     0.918     0.386     0.200
     1.504    -3.723     0.200
     1.933    -7.511     0.200
     2.422   -10.104     0.200
     2.461    -9.577     0.200
     2.505    -9.305     0.200
     2.538    -9.736     0.200
     2.556    -9.571     0.200
     2.564    -8.442     0.200
     2.608    -9.002     0.200
     2.610    -8.527     0.200
     2.619   -11.335     0.200
     2.629    -9.715     0.200
     2.636   -12.687     0.200
     2.668   -11.461     0.200
     2.699    -9.541     0.200
     2.752    -9.598     0.200
     2.777   -11.008     0.200
     2.857   -11.540     0.200
     2.948   -16.081     0.200
     2.961   -11.683     0.200
     3.063   -13.305     0.200
     3.110   -11.759     0.200
     3.203   -15.160     0.200
     3.202   -15.151     0.200
     3.211   -14.333     0.200
     3.149   -13.100     0.200
     3.413   -18.268     0.200
     3.970   -23.301     0.200
     4.014   -17.665     0.200
     4.161   -20.591     0.200
     4.121   -22.501     0.200
     4.252   -23.844     0.200
     4.468   -21.790     0.200
     4.368   -23.301     0.200
     4.832   -23.416     0.200
     4.970   -30.160     0.200
     4.970   -25.933     0.200
     4.962   -22.394     0.200
     5.385   -27.504     0.200
     5.685   -33.006     0.200
     5.898   -31.116     0.200
     6.196   -29.914     0.200
     6.689   -40.479     0.200
     7.635   -47.496     0.200
     7.745   -48.072     0.200
     7.780   -46.535     0.200
     7.868   -49.989     0.200
     7.981   -41.934     0.200
     9.503   -53.963     0.200
    11.668   -77.544     0.200
    11.967   -75.074     0.200
     0.257     6.658     0.200
     0.593     2.640     0.200
     0.650     1.876     0.200
     0.708     1.439     0.200
     0.761     0.342     0.200
     1.014     0.344     0.200
     1.113    -1.899     0.200
     1.125     0.567     0.200
     1.177    -1.100     0.200
     1.616    -5.347     0.200
     1.686    -4.507     0.200
     1.722    -6.314     0.200
     1.841    -8.146     0.200
     1.886    -6.158     0.200
     1.920    -2.337     0.200
     1.971    -5.028     0.200
     1.993    -4.675     0.200
     2.036    -4.763     0.200
     2.097    -8.360     0.200
     2.099    -8.576     0.200
     2.495   -10.950     0.200
     2.636   -10.627     0.200
     2.695   -10.167     0.200
     2.753   -15.528     0.200
     2.778   -13.594     0.200
     3.622   -21.132     0.200
     3.752   -26.027     0.200
     4.243   -21.526     0.200
     4.334   -21.290     0.200
     4.479   -26.174     0.200
     4.602   -26.766     0.200
     0.845     0.127     0.200
     1.871    -6.583     0.200
     1.875    -5.537     0.200
     1.863    -6.683     0.200
     1.912    -5.418     0.200
     2.060    -7.259     0.200
     2.167    -8.212     0.200
     2.163    -8.779     0.200
     2.201    -8.878     0.200
     2.217    -7.832     0.200
     2.218    -8.698     0.200
     2.238    -8.433     0.200
     2.242    -8.327     0.200
     2.272    -8.435     0.200
     2.277    -8.587     0.200
     2.290    -9.229     0.200
     2.306    -8.667     0.200
     2.286    -8.552     0.200
     2.307    -9.425     0.200
     2.309    -9.389     0.200
     2.334    -8.251     0.200
     2.352    -9.917     0.200
     2.356    -9.332     0.200
     2.373    -8.757     0.200
     2.378   -10.056     0.200
     2.409    -9.081     0.200
     2.440   -10.922     0.200
     2.449   -10.758     0.200
     2.489   -10.345     0.200
     2.524   -10.778     0.200
     2.575   -10.830     0.200
     2.758   -11.704     0.200
     2.807   -13.040     0.200
     2.815   -13.085     0.200
     2.850   -13.290     0.200
     2.890   -13.094     0.200
     2.883   -13.570     0.200
     3.047   -13.972     0.200
     3.047   -13.981     0.200
     3.071   -14.506     0.200
     3.271   -15.080     0.200
     3.272   -15.108     0.200
     3.851   -19.480     0.200
     3.896   -20.757     0.200
     4.129   -22.296     0.200
     4.371   -24.268     0.200
     4.740   -24.192     0.200
     5.412   -30.581     0.200
     5.851   -31.668     0.200
     5.957   -34.146     0.200
     6.514   -38.348     0.200
     6.582   -43.932     0.200
     7.504   -44.209     0.200
     7.650   -47.148     0.200
     7.682   -45.732     0.200
     7.750   -48.017     0.200
     0.905     0.263     0.200
     2.351    -9.272     0.200
     2.410    -9.496     0.200
     2.408    -7.378     0.200
     2.464    -8.180     0.200
     2.506    -9.451     0.200
     2.516    -8.481     0.200
     2.539    -8.065     0.200
     2.536   -10.048     0.200
     2.555    -8.405     0.200
     2.567    -9.403     0.200
     2.595    -8.198     0.200
     2.612   -10.142     0.200
     2.613    -9.731     0.200
     2.621    -9.877     0.200
     2.633   -10.947     0.200
     2.679   -10.401     0.200
     2.703   -10.409     0.200
     2.864   -11.912     0.200
     2.973   -12.290     0.200
     3.102   -15.686     0.200
     3.079   -12.195     0.200
     3.115   -11.211     0.200
     3.191   -11.325     0.200
     3.191   -11.317     0.200
     3.162   -16.775     0.200
     3.427   -17.599     0.200
     3.529   -13.474     0.200
     3.530   -13.502     0.200
     3.957   -23.641     0.200
     4.026   -20.953     0.200
     4.136   -19.979     0.200
     4.267   -22.001     0.200
     4.383   -21.618     0.200
     4.464   -21.685     0.200
     4.835   -24.341     0.200
     4.959   -26.357     0.200
     4.970   -23.259     0.200
     5.034   -25.605     0.200
     5.399   -27.525     0.200
     5.505   -26.001     0.200
     5.721   -29.207     0.200
     5.912   -29.405     0.200
     6.203   -32.660     0.200
     6.306   -33.314     0.200
     6.647   -37.548     0.200
     6.676   -42.670     0.200
     7.623   -45.974     0.200
     7.731   -47.621     0.200
     7.767   -44.262     0.200
     7.855   -47.936     0.200
     7.988   -44.594     0.200
     8.680   -48.480     0.200
     1.244    -0.227     0.200
     1.244    -0.743     0.200
     1.982    -7.476     0.200
     2.059    -6.955     0.200
     2.181    -7.412     0.200
     2.388    -8.146     0.200
     2.427    -9.230     0.200
     2.435   -11.457     0.200
     2.506    -8.077     0.200
     2.508    -8.678     0.200
     2.555    -8.202     0.200
     2.568    -8.286     0.200
     2.605    -9.554     0.200
     2.622   -10.089     0.200
     2.623    -8.412     0.200
     2.622    -9.167     0.200
     2.636   -10.763     0.200
     2.644    -9.230     0.200
     2.647   -10.392     0.200
     2.651   -10.735     0.200
     2.653    -9.189     0.200
     2.669    -9.767     0.200
     2.670    -9.061     0.200
     2.695    -9.070     0.200
     2.697   -12.939     0.200
     2.694    -8.888     0.200
     2.694    -8.879     0.200
     2.719    -9.836     0.200
     2.736   -10.201     0.200
     2.745   -10.224     0.200
     2.776   -11.141     0.200
     2.865    -9.799     0.200
     2.891   -10.878     0.200
     3.048   -12.278     0.200
     3.123   -11.985     0.200
     3.267   -13.078     0.200
     3.348   -16.239     0.200
     3.348   -16.410     0.200
     3.411   -17.234     0.200
     3.598   -15.769     0.200
     3.599   -15.797     0.200
     3.626   -16.670     0.200
     3.695   -17.333     0.200
     3.692   -16.703     0.200
     3.900   -18.374     0.200
     3.971   -23.167     0.200
     4.203   -19.426     0.200
     4.368   -19.159     0.200
     4.456   -27.739     0.200
     5.163   -27.079     0.200
     5.179   -27.081     0.200
     5.573   -32.517     0.200
     5.883   -31.561     0.200
     5.937   -36.592     0.200
     6.132   -32.260     0.200
     6.238   -33.033     0.200
     6.330   -32.609     0.200
     6.406   -35.031     0.200
     6.672   -37.318     0.200
     7.097   -38.846     0.200
     8.144   -42.223     0.200
     8.882   -48.577     0.200
     9.937   -58.444     0.200
    11.227   -73.783     0.200
     1.160    -1.864     0.200
     1.241    -2.962     0.200
     2.092    -6.683     0.200
     2.176    -7.056     0.200
     2.288    -8.477     0.200
     2.288    -8.344     0.200
     2.341    -8.451     0.200
     2.340    -9.164     0.200
     2.354    -8.299     0.200
     2.373    -9.678     0.200
     2.396    -9.662     0.200
     2.482    -9.726     0.200
     2.520    -8.397     0.200
     2.586   -11.828     0.200
     2.957   -13.420     0.200
     3.120   -13.809     0.200
     3.197   -17.935     0.200
     3.231   -12.925     0.200
     3.336   -15.152     0.200
     3.816   -17.197     0.200
     3.930   -16.824     0.200
     4.058   -19.564     0.200
     4.210   -26.834     0.200
     4.736   -25.311     0.200
     1.283     0.415     0.200
     1.421    -0.481     0.200
     1.525    -1.623     0.200
     2.361    -6.005     0.200
     2.407    -6.413     0.200
     3.439   -12.367     0.200
     7.714   -42.753     0.200
     0.192     6.938     0.200
     0.306     5.201     0.200
     0.469     2.776     0.200
     0.885     0.711     0.200
     1.037    -1.521     0.200
     1.123    -1.109     0.200
     1.345    -2.129     0.200
     1.360    -2.622     0.200
     1.417    -3.114     0.200
     1.528    -4.023     0.200
     1.870    -5.692     0.200
     1.953    -6.080     0.200
     2.056    -7.717     0.200
     2.139    -7.440     0.200
     2.218    -7.870     0.200
     2.222    -7.820     0.200
     2.244    -8.817     0.200
     2.275    -7.544     0.200
     2.286    -9.009     0.200
     2.292    -6.809     0.200
     2.300    -8.437     0.200
     2.304    -7.872     0.200
     2.322    -8.527     0.200
     2.321    -8.769     0.200
     2.321    -7.629     0.200
     2.350    -9.321     0.200
     2.350    -7.751     0.200
     2.355    -8.028     0.200
     2.355    -8.046     0.200
     2.366    -9.764     0.200
     2.371    -8.864     0.200
     2.370    -9.276     0.200
     2.385    -9.189     0.200
     2.387    -8.796     0.200
     2.393    -9.238     0.200
     2.426    -9.246     0.200
     2.431   -10.094     0.200
     2.458    -9.842     0.200
     2.459   -10.123     0.200
     2.478   -10.481     0.200
     2.525    -9.996     0.200
     2.588   -11.111     0.200
     2.692   -11.441     0.200
     2.801   -11.466     0.200
     2.879   -12.655     0.200
     2.901   -12.974     0.200
     3.050   -13.950     0.200
     3.076   -15.052     0.200
     3.235   -15.482     0.200
     3.235   -15.473     0.200
     3.274   -14.777     0.200
     3.275   -14.804     0.200
     3.273   -15.645     0.200
     3.741   -18.180     0.200
     3.825   -18.814     0.200
     3.828   -20.454     0.200
     3.942   -20.152     0.200
     4.090   -26.005     0.200
     4.151   -21.237     0.200
     4.184   -21.875     0.200
     4.329   -22.360     0.200
     4.587   -24.503     0.200
     4.689   -23.810     0.200
     4.859   -26.070     0.200
     5.002   -30.088     0.200
     5.002   -27.398     0.200
     5.226   -27.718     0.200
     5.221   -29.082     0.200
     5.495   -31.563     0.200
     5.705   -32.987     0.200
     5.679   -31.645     0.200
     6.025   -33.076     0.200
     6.703   -40.173     0.200
     6.776   -44.139     0.200
     7.695   -46.654     0.200
     7.710   -44.413     0.200
     7.844   -47.489     0.200
     7.876   -47.251     0.200
     8.397   -48.486     0.200
     8.420   -51.190     0.200
    10.044   -62.612     0.200
    10.728   -67.040     0.200
    10.991   -67.892     0.200
    11.621   -80.209     0.200
    11.621   -81.932     0.200
     2.155    -7.454     0.200
     2.335    -7.921     0.200
     2.335    -8.467     0.200
     2.409    -8.637     0.200
     2.698   -11.726     0.200
     2.768   -12.280     0.200
     2.761    -9.579     0.200
     3.020   -13.277     0.200
     3.107   -15.969     0.200
     3.242   -16.187     0.200
     3.274   -13.438     0.200
     3.274   -12.528     0.200
     3.393   -17.470     0.200
     3.779   -18.959     0.200
     3.881   -17.685     0.200
     4.022   -23.089     0.200
     4.299   -23.176     0.200
     4.594   -21.987     0.200
     4.694   -26.566     0.200
     5.056   -28.770     0.200
     5.159   -29.198     0.200
     5.351   -31.959     0.200
     5.860   -37.676     0.200
     8.009   -52.160     0.200
     8.042   -48.204     0.200
     8.132   -52.738     0.200
     1.051    -1.974     0.200
     1.351    -3.776     0.200
     1.410    -3.463     0.200
     1.512    -3.660     0.200
     1.911    -5.933     0.200
     2.006    -6.928     0.200
     2.068    -9.011     0.200
     2.093    -6.320     0.200
     2.173    -7.376     0.200
     2.178    -7.723     0.200
     2.237    -9.231     0.200
     2.232    -7.958     0.200
     2.242    -8.910     0.200
     2.282    -9.073     0.200
     2.326   -10.210     0.200
     2.339    -9.997     0.200
     2.478   -10.380     0.200
     2.476    -9.102     0.200
     2.542    -8.486     0.200
     2.652   -11.583     0.200
     2.876   -13.087     0.200
     3.031   -13.506     0.200
     3.088   -18.011     0.200
     3.231   -16.887     0.200
     3.263   -16.874     0.200
     3.230   -14.760     0.200
     4.035   -21.257     0.200
     4.165   -25.384     0.200
     4.845   -26.248     0.200
     2.758    -9.462     0.200
     4.422   -24.007     0.200
    11.229   -67.704     0.200
     1.037     3.544     0.200
     1.312     2.098     0.200
     1.356     0.645     0.200
     1.866    -3.463     0.200
     2.169    -4.096     0.200
     2.302    -6.540     0.200
     2.312    -4.189     0.200
     2.374    -4.797     0.200
     2.610    -5.698     0.200
     2.630    -7.546     0.200
     2.668    -7.485     0.200
     2.643    -6.624     0.200
     2.689    -6.768     0.200
     2.705    -6.990     0.200
     2.708    -6.616     0.200
     2.753    -6.576     0.200
     2.743    -6.481     0.200
     2.758    -8.482     0.200
     2.759    -6.632     0.200
     2.767    -7.234     0.200
     2.782    -7.060     0.200
     2.782    -6.389     0.200
     2.784    -7.136     0.200
     2.804    -6.436     0.200
     2.826    -6.851     0.200
     2.831    -6.711     0.200
     2.833    -8.016     0.200
     2.853    -7.380     0.200
     2.879    -7.556     0.200
     2.896    -8.677     0.200
     2.913    -9.208     0.200
     3.004    -8.821     0.200
     3.026    -8.616     0.200
     3.194   -10.364     0.200
     3.251   -10.622     0.200
     3.260    -9.994     0.200
     3.327   -16.435     0.200
     3.414   -11.055     0.200
     3.497   -11.686     0.200
     3.686   -13.571     0.200
     3.734   -13.150     0.200
     3.766   -14.342     0.200
     4.004   -13.406     0.200
     4.075   -17.963     0.200
     4.273   -16.795     0.200
     4.422   -19.417     0.200
     4.518   -22.514     0.200
     4.588   -19.791     0.200
     4.784   -21.174     0.200
     4.910   -19.605     0.200
     4.918   -22.293     0.200
     4.989   -22.435     0.200
     5.030   -23.563     0.200
     5.036   -22.383     0.200
     5.150   -24.987     0.200
     6.049   -28.399     0.200
     6.069   -34.353     0.200
     6.032   -27.298     0.200
     6.087   -28.942     0.200
     6.119   -30.432     0.200
     6.364   -31.574     0.200
     6.539   -32.843     0.200
     6.822   -32.721     0.200
     7.043   -36.278     0.200
     7.131   -36.314     0.200
     8.245   -41.291     0.200
     8.286   -43.217     0.200
     9.280   -56.891     0.200
    10.084   -56.722     0.200
    10.900   -63.351     0.200
    11.229   -67.099     0.200
    11.406   -65.243     0.200
    11.808   -68.232     0.200
    12.624   -74.793     0.200
    12.663   -72.621     0.200
    13.133   -79.277     0.200
    15.784   -98.250     0.200
    16.280  -103.294     0.200
    16.548  -106.370     0.200
    17.882  -117.620     0.200
    18.729  -125.216     0.200
    20.520  -136.796     0.200
    22.101  -155.006     0.200
    22.187  -154.916     0.200
     0.233     7.565     0.200
     0.568     3.160     0.200
     0.690     1.681     0.200
     0.679     2.050     0.200
     0.753     0.953     0.200
     1.029    -0.029     0.200
     1.136    -1.200     0.200
     1.155    -2.015     0.200
     1.192    -1.219     0.200
     1.642    -5.048     0.200
     1.718    -5.069     0.200
     1.857    -6.607     0.200
     1.909    -6.586     0.200
     2.017    -7.192     0.200
     2.024    -8.907     0.200
     2.026    -9.539     0.200
     2.068    -6.684     0.200
     2.082    -7.063     0.200
     2.168   -11.071     0.200
     2.261    -9.677     0.200
     2.400    -7.549     0.200
     2.523    -9.744     0.200
     2.660   -12.666     0.200
     2.661    -6.980     0.200
     2.754   -15.908     0.200
     2.794   -11.329     0.200
     2.852   -16.740     0.200
     3.103   -17.116     0.200
     4.242   -21.457     0.200
     4.335   -24.521     0.200
     4.478   -23.089     0.200
     0.318     4.578     0.200
     0.317     5.054     0.200
     0.462     3.331     0.200
     0.832     0.936     0.200
     0.889    -0.755     0.200
     1.183    -1.647     0.200
     1.306    -3.387     0.200
     1.847    -6.623     0.200
     1.892    -5.922     0.200
     1.898    -5.274     0.200
     2.091    -9.632     0.200
     2.135   -10.373     0.200
     2.139    -7.113     0.200
     2.159    -7.576     0.200
     2.183    -7.883     0.200
     2.220   -10.530     0.200
     2.226   -12.370     0.200
     2.230   -12.023     0.200
     2.286    -8.957     0.200
     2.340   -13.150     0.200
     2.421   -11.962     0.200
     2.502    -9.992     0.200
     2.555    -9.042     0.200
     2.598   -10.057     0.200
     2.772   -14.364     0.200
     2.925   -16.985     0.200
     3.080   -14.410     0.200
     3.250   -13.032     0.200
     1.834    -6.016     0.200
     1.889    -5.841     0.200
     2.104    -7.189     0.200
     2.195    -7.090     0.200
     2.225    -8.846     0.200
     2.226    -7.084     0.200
     2.288    -8.034     0.200
     2.277   -10.175     0.200
     2.291    -8.132     0.200
     2.359    -7.692     0.200
     2.712   -12.945     0.200
     2.744   -10.369     0.200
     2.854   -10.969     0.200
     2.908   -13.547     0.200
     3.040   -14.501     0.200
     3.190   -11.792     0.200
     3.447   -16.209     0.200
     3.917   -21.296     0.200
     4.095   -19.366     0.200
     4.199   -20.006     0.200
     4.335   -20.978     0.200
     4.807   -26.825     0.200
     1.412    -0.182     0.200
     1.429    -0.351     0.200
     1.529    -3.009     0.200
     1.914    -5.909     0.200
     2.144    -5.915     0.200
     2.481    -7.434     0.200
     2.927   -11.326     0.200
     2.991   -10.253     0.200
     3.191   -11.858     0.200
     3.178   -13.177     0.200
     3.436   -16.838     0.200
     4.036   -15.323     0.200
     3.950   -19.336     0.200
     4.044   -17.547     0.200
     4.154   -17.870     0.200
     4.475   -18.364     0.200
     4.283   -20.381     0.200
     4.853   -21.826     0.200
     4.989   -21.133     0.200
     4.959   -27.778     0.200
     4.959   -24.110     0.200
     5.044   -28.752     0.200
     5.504   -27.983     0.200
     5.523   -27.617     0.200
     5.409   -30.183     0.200
     5.674   -28.863     0.200
     5.734   -32.122     0.200
     5.926   -31.749     0.200
     6.221   -30.872     0.200
     6.324   -32.677     0.200
     6.646   -35.819     0.200
     6.672   -37.771     0.200
     7.621   -41.982     0.200
     7.726   -49.181     0.200
     7.850   -44.110     0.200
     8.007   -44.019     0.200
     8.702   -49.806     0.200
     8.699   -47.996     0.200
     8.675   -50.265     0.200
     9.533   -54.456     0.200
    10.310   -61.195     0.200
    11.283   -67.632     0.200
    12.059   -73.750     0.200
    12.553   -77.414     0.200
    15.257   -98.050     0.200
    15.695  -103.435     0.200
    15.997  -103.792     0.200
    19.899  -130.655     0.200
     1.236    -3.430     0.200
     1.992    -6.891     0.200
     2.229   -11.249     0.200
     2.256   -12.550     0.200
     2.630    -9.131     0.200
     2.723    -9.072     0.200
     2.761   -10.967     0.200
     2.785    -9.733     0.200
     2.836   -11.325     0.200
     2.833   -12.228     0.200
     2.856   -11.974     0.200
     2.899   -11.019     0.200
     2.925   -12.825     0.200
     2.987   -12.148     0.200
     3.098   -11.018     0.200
     3.255   -19.641     0.200
     3.317   -11.976     0.200
     3.279   -14.081     0.200
     3.499   -17.726     0.200
     3.659   -16.693     0.200
     3.592   -17.551     0.200
     3.807   -15.009     0.200
     3.862   -19.955     0.200
     4.294   -16.815     0.200
     4.378   -23.211     0.200
     4.378   -24.117     0.200
     4.160   -27.002     0.200
     4.612   -22.227     0.200
     5.008   -23.427     0.200
     5.055   -23.710     0.200
     4.874   -30.105     0.200
     5.108   -25.933     0.200
     5.002   -29.795     0.200
     5.009   -30.391     0.200
     5.121   -30.822     0.200
     5.393   -26.858     0.200
     5.771   -36.610     0.200
     6.004   -34.867     0.200
     6.036   -35.623     0.200
     6.128   -33.207     0.200
     6.137   -39.757     0.200
     6.546   -37.347     0.200
     6.456   -39.723     0.200
     6.634   -40.356     0.200
     6.985   -40.378     0.200
     6.985   -42.214     0.200
     6.917   -38.403     0.200
     7.043   -47.024     0.200
     7.060   -40.521     0.200
     7.082   -43.604     0.200
     8.217   -45.861     0.200
     8.217   -45.205     0.200
     8.365   -46.757     0.200
     9.111   -52.788     0.200
    10.183   -58.217     0.200
    11.205   -74.723     0.200
    11.493   -69.755     0.200
    11.904   -74.865     0.200
    15.880  -106.211     0.200
    20.597  -145.578     0.200
EOF
# Sb observations in blue circles
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg observations in red circles
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.180     2.084     0.200
     0.250     1.712     0.200
     1.452    -2.279     0.200
     1.972    -4.186     0.200
     2.110    -4.525     0.200
     2.358    -6.072     0.200
     2.499    -6.679     0.200
     2.499    -5.498     0.200
     4.429   -15.190     0.200
     0.168     6.030     0.200
     0.977     1.423     0.200
     1.411    -0.597     0.200
     2.031    -5.031     0.200
     2.371    -7.399     0.200
     2.451    -6.414     0.200
     2.451    -6.914     0.200
     0.168     3.054     0.200
     1.533    -1.601     0.200
     1.440    -1.458     0.200
     2.365    -6.500     0.200
     2.367    -6.546     0.200
     0.154     5.239     0.200
     0.397     3.141     0.200
     1.212    -1.483     0.200
     1.377    -2.201     0.200
     2.280    -6.938     0.200
     0.682     0.475     0.200
     1.012     0.588     0.200
     1.475    -2.217     0.200
     1.553    -2.500     0.200
     2.000    -4.005     0.200
     2.326    -6.677     0.200
     2.435    -7.246     0.200
     2.586    -8.283     0.200
     2.719    -9.197     0.200
     0.274     2.341     0.200
     0.677     0.643     0.200
     1.646    -2.905     0.200
     1.480    -0.518     0.200
     2.461    -1.700     0.200
     2.568    -4.954     0.200
     4.270   -13.436     0.200
     5.113   -13.446     0.200
     6.292   -17.429     0.200
     0.865     2.182     0.200
     1.023    -0.772     0.200
     1.094     0.522     0.200
     2.010    -4.015     0.200
     2.176    -5.098     0.200
     2.337    -7.316     0.200
     1.011    -0.635     0.200
     1.185    -1.349     0.200
     1.478    -2.782     0.200
     1.538    -3.318     0.200
     2.040    -2.507     0.200
     2.338    -0.229     0.200
     2.455    -4.666     0.200
     2.612    -8.094     0.200
     2.679    -4.372     0.200
     3.417    -8.549     0.200
     4.581    -8.707     0.200
     0.242     2.118     0.200
     1.019    -0.514     0.200
     1.287    -1.446     0.200
     1.436    -2.633     0.200
     0.594     1.023     0.200
     0.997    -0.719     0.200
     1.181    -1.923     0.200
     1.797    -3.731     0.200
     2.554    -3.232     0.200
     0.358     1.895     0.200
     1.564    -0.655     0.200
     1.655    -1.961     0.200
     2.076    -3.166     0.200
     2.390    -0.983     0.200
     5.891   -14.587     0.200
     0.240     3.194     0.200
     0.642     1.102     0.200
     1.594    -1.756     0.200
     1.594    -0.756     0.200
     1.620    -2.907     0.200
     2.128    -2.813     0.200
     3.551    -6.036     0.200
     0.215     3.064     0.200
     0.285     2.160     0.200
     1.674    -0.821     0.200
     1.526    -0.528     0.200
     4.377   -12.502     0.200
     5.406   -10.975     0.200
     0.626     2.767     0.200
     0.553     0.707     0.200
     1.187    -2.606     0.200
     1.422    -2.219     0.200
     1.422     0.574     0.200
     1.627    -3.343     0.200
     2.148    -5.636     0.200
     2.180    -5.274     0.200
     2.216    -6.096     0.200
     2.925    -9.458     0.200
     3.140    -5.017     0.200
     3.161    -8.367     0.200
     4.362   -10.463     0.200
     4.249   -14.159     0.200
     4.537   -15.091     0.200
     0.294     3.158     0.200
     0.372     1.557     0.200
     0.461     1.750     0.200
     0.864     0.140     0.200
     0.929     0.291     0.200
     1.222    -2.115     0.200
     1.675    -3.412     0.200
     1.686    -1.225     0.200
     1.724    -1.708     0.200
     1.788    -1.753     0.200
     1.817     0.424     0.200
     1.918    -3.319     0.200
     2.170    -4.146     0.200
     2.135    -2.361     0.200
     2.236     0.274     0.200
     2.289    -2.939     0.200
     2.309    -0.129     0.200
     2.468    -2.375     0.200
     2.595    -5.722     0.200
     2.632    -5.034     0.200
     2.652    -6.836     0.200
     2.641    -7.814     0.200
     4.087   -12.167     0.200
     4.825   -15.293     0.200
     0.190     2.979     0.200
     0.167     3.083     0.200
     0.249     2.523     0.200
     0.811     0.149     0.200
     1.499    -1.463     0.200
     1.611    -2.229     0.200
     1.618    -1.460     0.200
     1.883    -4.022     0.200
     1.922    -3.526     0.200
     2.080    -5.441     0.200
     2.156    -4.805     0.200
     2.162    -5.628     0.200
     2.177    -1.227     0.200
     2.501    -4.600     0.200
     2.502    -4.315     0.200
     2.504    -5.022     0.200
     2.588    -7.127     0.200
     2.588    -5.724     0.200
     2.601    -7.789     0.200
     2.616    -7.944     0.200
     2.634    -5.690     0.200
     2.657    -6.441     0.200
     2.687    -5.434     0.200
     2.692    -7.830     0.200
     2.715    -6.504     0.200
     2.878    -7.076     0.200
     2.897    -5.663     0.200
     3.188    -9.579     0.200
     3.244   -10.286     0.200
     4.238   -14.637     0.200
     4.616   -17.198     0.200
     5.086    -9.738     0.200
     7.407   -24.492     0.200
     8.082   -17.758     0.200
     0.871     0.229     0.200
     0.824     0.177     0.200
     1.197    -0.727     0.200
     1.576    -2.878     0.200
     1.810    -2.111     0.200
     1.987    -2.760     0.200
     1.864     1.876     0.200
     2.289     0.390     0.200
     2.289     0.400     0.200
     2.403    -4.649     0.200
     2.529    -5.106     0.200
     2.536    -6.156     0.200
     2.682    -7.044     0.200
     2.599    -4.842     0.200
     2.820    -7.358     0.200
     2.850    -7.420     0.200
     2.850    -7.607     0.200
     2.857    -4.180     0.200
     2.871    -5.533     0.200
     2.892    -7.376     0.200
     2.957    -8.457     0.200
     2.974    -8.495     0.200
     2.984    -8.029     0.200
     3.032    -8.256     0.200
     3.131    -8.083     0.200
     3.316    -8.336     0.200
     3.363    -6.814     0.200
     3.387    -9.823     0.200
     4.275   -12.081     0.200
     4.443   -12.767     0.200
     5.485    -7.116     0.200
     6.112   -11.568     0.200
     0.110     7.893     0.200
     0.323     4.621     0.200
     0.698     1.888     0.200
     0.726     1.169     0.200
     0.807     0.570     0.200
     0.819     0.763     0.200
     1.011    -0.853     0.200
     0.957    -0.062     0.200
     0.991     0.324     0.200
     1.393    -0.679     0.200
     1.596    -1.523     0.200
     1.735    -2.176     0.200
     1.811    -3.206     0.200
     2.016    -4.688     0.200
     2.210    -4.801     0.200
     2.445    -6.003     0.200
     2.450    -4.860     0.200
     2.697    -7.452     0.200
     3.690   -12.852     0.200
     3.731   -13.223     0.200
     4.508   -11.001     0.200
     0.421     1.234     0.200
     1.268    -2.120     0.200
     1.724    -3.284     0.200
     1.731    -1.600     0.200
     1.818    -3.901     0.200
     1.780    -1.353     0.200
     1.780    -3.353     0.200
     1.852    -2.583     0.200
     1.971    -2.000     0.200
     2.224    -3.430     0.200
     2.286    -5.749     0.200
     2.555    -6.586     0.200
     2.566    -7.017     0.200
     2.598    -7.038     0.200
     2.601    -5.976     0.200
     2.617    -7.584     0.200
     2.619    -7.137     0.200
     2.671    -6.457     0.200
     2.670    -6.432     0.200
     2.670    -5.341     0.200
     2.671    -7.560     0.200
     2.694    -6.722     0.200
     2.694    -7.831     0.200
     2.676    -5.333     0.200
     2.665    -5.841     0.200
     2.716    -4.767     0.200
     2.651    -7.325     0.200
     2.650    -7.315     0.200
     2.745    -7.415     0.200
     2.658    -7.347     0.200
     2.703    -7.688     0.200
     2.678    -7.437     0.200
     2.791    -6.854     0.200
     2.809    -7.703     0.200
     2.839    -8.525     0.200
     2.938    -8.800     0.200
     3.106    -9.982     0.200
     3.164    -6.811     0.200
     3.172    -7.357     0.200
     3.420    -4.565     0.200
     3.420    -7.585     0.200
     3.645   -12.323     0.200
     3.646   -12.351     0.200
     4.887    -9.524     0.200
     4.902   -10.838     0.200
     4.971    -8.329     0.200
     5.221   -17.920     0.200
     5.134   -18.477     0.200
     6.008   -14.670     0.200
     0.231     5.320     0.200
     0.342     3.707     0.200
     0.360     4.095     0.200
     0.366     3.799     0.200
     0.438     3.459     0.200
     0.853     0.577     0.200
     1.186    -1.072     0.200
     1.316    -0.237     0.200
     1.378    -1.194     0.200
     1.708    -2.728     0.200
     1.921    -4.172     0.200
     1.986    -4.076     0.200
     2.188    -2.842     0.200
     2.193    -4.465     0.200
     2.193    -2.057     0.200
     2.259    -5.860     0.200
     2.288    -2.473     0.200
     2.322    -4.971     0.200
     2.468    -3.660     0.200
     2.500    -2.953     0.200
     2.560    -5.561     0.200
     2.569    -6.611     0.200
     2.693    -4.858     0.200
     2.783    -9.453     0.200
     2.860    -9.208     0.200
     3.249    -8.420     0.200
     0.226     2.626     0.200
     0.334     2.675     0.200
     0.753     2.103     0.200
     1.036    -1.008     0.200
     1.232    -2.850     0.200
     1.245    -1.985     0.200
     1.717    -2.686     0.200
     1.744    -4.070     0.200
     2.250    -6.336     0.200
     2.739    -7.070     0.200
     3.161    -7.869     0.200
     0.019     9.962     0.200
     0.255     4.245     0.200
     0.401     4.000     0.200
     0.616     2.087     0.200
     1.058    -0.893     0.200
     0.047     9.211     0.200
     0.268     5.221     0.200
     0.734     1.578     0.200
     0.865     1.023     0.200
     1.017     0.403     0.200
     1.177    -0.525     0.200
     1.300    -0.152     0.200
     1.338    -0.902     0.200
     1.371    -1.171     0.200
     1.630    -0.796     0.200
     1.583    -2.278     0.200
     1.703    -1.292     0.200
     1.840    -4.321     0.200
     1.887    -3.921     0.200
     1.891    -3.564     0.200
     1.950    -3.467     0.200
     2.235    -2.040     0.200
     2.228    -0.697     0.200
     2.309    -5.399     0.200
     2.650    -3.792     0.200
     2.820    -4.244     0.200
     4.429   -15.454     0.200
     4.481   -15.328     0.200
     0.258     4.652     0.200
     0.319     4.545     0.200
     0.387     3.971     0.200
     0.391     3.359     0.200
     0.957    -0.482     0.200
     1.151    -0.753     0.200
     1.319     0.214     0.200
     1.333    -1.081     0.200
     1.449    -2.890     0.200
     1.952    -4.707     0.200
     2.151    -5.421     0.200
     2.160    -6.462     0.200
     2.196    -4.605     0.200
     2.201    -3.525     0.200
     2.243    -4.885     0.200
     2.249    -2.986     0.200
     2.249    -6.229     0.200
     2.284    -5.350     0.200
     2.286    -4.915     0.200
     2.288    -5.842     0.200
     2.295    -5.295     0.200
     2.313    -3.975     0.200
     2.326    -6.358     0.200
     2.343    -5.893     0.200
     2.437    -5.011     0.200
     2.490    -6.815     0.200
     2.589    -8.307     0.200
     2.732    -9.264     0.200
     2.796    -9.567     0.200
     2.972    -9.177     0.200
     3.355   -12.119     0.200
     3.542   -10.563     0.200
     0.141     3.578     0.200
     0.283     1.970     0.200
     0.536     1.113     0.200
     0.630     2.145     0.200
     0.758     0.344     0.200
     1.557    -1.949     0.200
     1.595    -3.130     0.200
     1.636    -2.715     0.200
     1.637    -2.161     0.200
     1.945    -3.545     0.200
     2.150    -4.818     0.200
     2.152    -4.736     0.200
     2.170    -4.891     0.200
     2.192    -6.054     0.200
     2.274    -5.245     0.200
     2.474    -5.039     0.200
     2.498    -6.546     0.200
     2.539    -4.564     0.200
     2.598    -6.880     0.200
     2.611    -4.211     0.200
     2.612    -6.197     0.200
     2.738    -7.054     0.200
     2.837    -7.624     0.200
     2.854    -8.540     0.200
     2.916    -7.916     0.200
     3.585   -11.964     0.200
     4.223   -13.108     0.200
     8.094   -23.638     0.200
     0.170     6.481     0.200
     0.210     5.483     0.200
     0.207     5.964     0.200
     0.390     3.938     0.200
     0.562     2.831     0.200
     0.778     0.869     0.200
     0.872     0.145     0.200
     1.280    -1.054     0.200
     1.326    -1.804     0.200
     1.619    -3.528     0.200
     1.843    -3.043     0.200
     1.899    -2.207     0.200
     1.926    -3.355     0.200
     2.100    -4.559     0.200
     2.197    -5.008     0.200
     2.222    -3.467     0.200
     2.227    -1.051     0.200
     2.235    -0.866     0.200
     2.245    -1.641     0.200
     2.259    -1.646     0.200
     2.273    -2.667     0.200
     2.298    -5.948     0.200
     2.334    -2.474     0.200
     2.461    -3.422     0.200
     2.867    -9.554     0.200
     2.884    -9.378     0.200
     3.755   -10.958     0.200
     4.361    -8.900     0.200
     0.637     0.865     0.200
     1.619    -2.261     0.200
     1.772     1.521     0.200
     2.816    -4.989     0.200
     4.198   -11.304     0.200
     0.239     4.264     0.200
     0.256     4.598     0.200
     0.379     2.847     0.200
     0.528     1.384     0.200
     0.828     0.519     0.200
     1.199     0.622     0.200
     1.325    -0.418     0.200
     1.843    -3.164     0.200
     1.839    -4.108     0.200
     1.876    -4.299     0.200
     2.273    -6.966     0.200
     2.300    -6.442     0.200
     2.815    -8.667     0.200
     3.240   -10.305     0.200
     0.169     4.019     0.200
     0.435     2.172     0.200
     0.885     0.593     0.200
     1.362    -2.032     0.200
     1.485    -2.395     0.200
     1.564    -2.897     0.200
     1.603    -1.544     0.200
     1.603    -1.896     0.200
     1.729    -0.429     0.200
     1.892    -3.895     0.200
     2.131    -1.426     0.200
     2.197    -4.013     0.200
     2.228    -4.034     0.200
     2.242    -5.431     0.200
     2.373    -4.668     0.200
     2.400    -5.905     0.200
     2.481    -6.968     0.200
     2.537    -6.164     0.200
     2.545    -3.428     0.200
     2.601    -7.105     0.200
     2.636    -7.888     0.200
     2.681    -4.944     0.200
     2.747    -6.206     0.200
     2.770    -8.286     0.200
     2.778    -8.816     0.200
     2.820    -8.256     0.200
     2.851    -6.617     0.200
     2.904    -8.863     0.200
     3.021   -10.052     0.200
     3.123    -7.051     0.200
     3.195   -10.805     0.200
     3.273    -7.467     0.200
     3.600   -10.678     0.200
     4.100   -11.786     0.200
     4.157   -12.526     0.200
     0.122     4.738     0.200
     0.367     3.056     0.200
     0.510     0.276     0.200
     0.859     0.753     0.200
     1.412    -0.650     0.200
     1.564    -0.203     0.200
     1.651    -0.982     0.200
     2.057    -3.331     0.200
     2.151    -5.572     0.200
     2.176    -6.001     0.200
     2.304    -4.502     0.200
     2.398    -6.404     0.200
     2.440    -7.290     0.200
     2.465    -6.265     0.200
     2.493    -5.441     0.200
     2.510    -6.923     0.200
     2.528    -3.437     0.200
     2.528    -3.450     0.200
     2.545    -7.500     0.200
     2.545    -6.412     0.200
     2.591    -7.450     0.200
     2.596    -5.722     0.200
     2.611    -7.526     0.200
     2.648    -5.269     0.200
     2.679    -8.164     0.200
     2.687    -7.540     0.200
     2.729    -5.636     0.200
     2.983    -6.405     0.200
     3.055    -7.151     0.200
     3.090    -6.520     0.200
     3.509   -12.257     0.200
     3.510   -12.284     0.200
     0.302     1.205     0.200
     0.519     0.588     0.200
     0.553     2.035     0.200
     0.988     0.486     0.200
     1.521    -2.842     0.200
     1.740    -1.788     0.200
     1.721    -0.772     0.200
     1.721    -0.881     0.200
     1.846    -0.660     0.200
     2.275    -2.781     0.200
     2.342    -0.801     0.200
     2.617    -5.725     0.200
     2.623    -6.879     0.200
     2.655    -3.705     0.200
     2.662    -3.840     0.200
     2.665    -4.510     0.200
     2.670    -5.754     0.200
     2.690    -7.001     0.200
     2.697    -4.611     0.200
     2.707    -5.571     0.200
     2.720    -4.642     0.200
     2.748    -5.516     0.200
     2.776    -4.839     0.200
     2.795    -5.117     0.200
     2.830    -5.482     0.200
     2.856    -6.759     0.200
     2.930    -8.693     0.200
     3.000    -6.924     0.200
     2.991    -5.368     0.200
     3.139    -6.461     0.200
     3.218    -9.076     0.200
     3.211    -4.910     0.200
     3.241    -5.437     0.200
     4.274   -15.375     0.200
     0.288     3.161     0.200
     1.303    -0.007     0.200
     1.558    -3.364     0.200
     1.558    -2.604     0.200
     1.671    -2.866     0.200
     1.931    -5.050     0.200
     2.354    -6.851     0.200
     2.354    -6.291     0.200
     2.380    -6.295     0.200
     2.391    -6.612     0.200
     2.421    -3.435     0.200
     2.473    -6.816     0.200
     2.534    -5.231     0.200
     2.534    -5.226     0.200
     2.596    -8.069     0.200
     2.654    -8.242     0.200
     2.791    -8.763     0.200
     2.811    -5.278     0.200
     3.748   -10.725     0.200
     0.103     5.173     0.200
     0.429     1.274     0.200
     0.651     1.010     0.200
     0.724     1.246     0.200
     1.453    -2.789     0.200
     1.588    -1.305     0.200
     1.596    -1.970     0.200
     2.167    -0.850     0.200
     2.393    -0.597     0.200
     2.445    -4.689     0.200
     2.468    -2.986     0.200
     2.483    -3.380     0.200
     2.503    -4.098     0.200
     2.500    -5.991     0.200
     2.517    -7.205     0.200
     2.620    -4.201     0.200
     2.720    -7.250     0.200
     2.750    -6.481     0.200
     4.371   -16.603     0.200
     4.448   -15.936     0.200
     4.838   -18.000     0.200
     6.473   -21.483     0.200
     0.293     2.817     0.200
     0.610     0.773     0.200
     1.459    -2.352     0.200
     1.459    -1.152     0.200
     1.570    -2.120     0.200
     1.589    -0.036     0.200
     1.661    -2.302     0.200
     1.771    -2.972     0.200
     2.084    -2.613     0.200
     2.120    -2.916     0.200
     2.127    -4.304     0.200
     2.144    -2.907     0.200
     2.263    -0.546     0.200
     2.378    -1.052     0.200
     2.417    -6.506     0.200
     2.430    -2.696     0.200
     2.445    -0.980     0.200
     2.452    -1.787     0.200
     2.456    -3.684     0.200
     2.467    -2.539     0.200
     2.478    -2.228     0.200
     2.486    -4.483     0.200
     2.491    -5.303     0.200
     2.493    -4.722     0.200
     2.497    -1.509     0.200
     2.508    -4.360     0.200
     2.509    -4.372     0.200
     2.550    -3.847     0.200
     2.549    -4.896     0.200
     2.595    -4.631     0.200
     2.682    -6.943     0.200
     2.772    -3.577     0.200
     2.819    -5.974     0.200
     2.978    -8.650     0.200
     3.046    -6.236     0.200
     3.046    -6.226     0.200
     3.086    -4.051     0.200
     3.274    -7.524     0.200
     3.274   -10.183     0.200
     3.518    -7.199     0.200
     3.519    -7.227     0.200
     4.369   -16.365     0.200
     4.407   -14.251     0.200
     5.589   -21.172     0.200
     0.260     3.286     0.200
     0.577     1.881     0.200
     1.426    -2.467     0.200
     1.426    -0.307     0.200
     1.504    -1.535     0.200
     1.548    -0.670     0.200
     1.635    -3.471     0.200
     1.786    -4.078     0.200
     2.070    -2.874     0.200
     2.054    -2.456     0.200
     2.054    -0.136     0.200
     2.081    -1.927     0.200
     2.096    -3.115     0.200
     2.198    -3.651     0.200
     2.260    -2.224     0.200
     2.319     0.809     0.200
     2.350    -2.687     0.200
     2.370     0.450     0.200
     2.385     0.105     0.200
     2.393    -0.564     0.200
     2.390    -0.987     0.200
     2.400    -3.473     0.200
     2.400    -2.704     0.200
     2.426    -2.902     0.200
     2.434     0.661     0.200
     2.435    -1.914     0.200
     2.435    -1.284     0.200
     2.449    -0.136     0.200
     2.484    -1.060     0.200
     2.754    -4.148     0.200
     2.754    -3.728     0.200
     2.842    -5.972     0.200
     2.993    -7.668     0.200
     3.047    -8.024     0.200
     3.224    -4.317     0.200
     3.452    -8.806     0.200
     3.453    -8.834     0.200
     4.323   -11.367     0.200
     4.484   -16.359     0.200
     5.511   -21.092     0.200
     0.100     5.793     0.200
     0.110     5.433     0.200
     0.541     2.016     0.200
     0.591     1.419     0.200
     1.401    -0.993     0.200
     1.469    -3.027     0.200
     1.613    -2.503     0.200
     1.890    -0.699     0.200
     2.033    -5.470     0.200
     2.306    -6.843     0.200
     2.486    -7.106     0.200
     2.567    -7.442     0.200
     2.963    -8.980     0.200
     0.137     1.970     0.200
     0.459     0.757     0.200
     0.634     0.782     0.200
     0.707     1.009     0.200
     0.873     0.288     0.200
     1.324    -0.538     0.200
     1.725    -1.554     0.200
     1.789    -0.780     0.200
     1.940    -0.702     0.200
     2.042    -1.229     0.200
     2.148     0.241     0.200
     2.155    -0.839     0.200
     2.200    -1.003     0.200
     2.211    -1.447     0.200
     2.219    -3.817     0.200
     2.222    -0.453     0.200
     2.237    -4.529     0.200
     2.250    -0.564     0.200
     2.256    -3.740     0.200
     2.261    -2.081     0.200
     2.270    -0.916     0.200
     2.366    -0.174     0.200
     2.458    -4.195     0.200
     0.303     2.030     0.200
     0.515     1.465     0.200
     0.659     1.240     0.200
     0.739     0.946     0.200
     1.226    -0.583     0.200
     1.437    -0.451     0.200
     1.583    -0.148     0.200
     1.648    -0.973     0.200
     1.784    -1.956     0.200
     1.972    -1.130     0.200
     2.021    -0.618     0.200
     2.178    -4.643     0.200
     2.198    -1.283     0.200
     2.204    -3.919     0.200
     2.422    -1.283     0.200
     2.475     0.478     0.200
     2.493    -0.145     0.200
     2.493     0.409     0.200
     2.499     0.596     0.200
     2.514    -3.583     0.200
     2.527    -3.535     0.200
     2.544    -5.064     0.200
     2.624    -7.648     0.200
     2.754    -3.677     0.200
     2.944    -8.130     0.200
     3.127    -6.153     0.200
     4.400   -16.486     0.200
     4.734    -9.186     0.200
     0.264     4.387     0.200
     0.595     1.478     0.200
     0.565     1.504     0.200
     1.163    -1.351     0.200
     1.153    -0.525     0.200
     1.378    -1.367     0.200
     1.603    -2.264     0.200
     1.627    -0.988     0.200
     1.913    -0.133     0.200
     2.383    -6.970     0.200
     2.497    -5.796     0.200
     2.515    -4.059     0.200
     2.882    -7.028     0.200
     3.196    -4.537     0.200
     5.089    -8.823     0.200
     5.239    -7.735     0.200
     5.716    -9.515     0.200
     0.237     3.466     0.200
     0.424     2.040     0.200
     0.464     1.810     0.200
     1.418    -0.795     0.200
     1.400    -2.343     0.200
     1.586    -2.571     0.200
     1.586    -1.341     0.200
     1.584    -2.800     0.200
     2.109    -4.421     0.200
     2.177    -4.459     0.200
     2.235    -4.870     0.200
     2.359    -7.041     0.200
     2.434    -5.984     0.200
     2.484    -6.696     0.200
     2.470    -6.749     0.200
     2.496    -6.078     0.200
     2.506    -7.386     0.200
     2.564    -7.225     0.200
     2.563    -7.177     0.200
     2.592    -8.149     0.200
     2.705    -7.830     0.200
     2.997   -10.034     0.200
     2.961    -6.382     0.200
     3.113   -10.757     0.200
     3.526   -10.223     0.200
     3.525   -10.196     0.200
     4.257   -15.994     0.200
     0.275     4.533     0.200
     0.341     3.289     0.200
     0.499     2.370     0.200
     0.850    -0.088     0.200
     1.224    -1.707     0.200
     1.233    -1.436     0.200
     1.325    -2.102     0.200
     1.364    -1.082     0.200
     1.364    -2.141     0.200
     0.252     3.060     0.200
     0.415     1.949     0.200
     1.114    -2.250     0.200
     1.408    -1.778     0.200
     1.519    -1.059     0.200
     1.578    -1.906     0.200
     1.578    -2.171     0.200
     1.587    -0.471     0.200
     1.920    -3.127     0.200
     2.102    -0.443     0.200
     2.126    -5.667     0.200
     2.179    -5.668     0.200
     2.224    -3.386     0.200
     2.496    -7.462     0.200
     2.507    -6.474     0.200
     2.568    -7.317     0.200
     2.568    -6.069     0.200
     2.568    -6.327     0.200
     2.595    -7.807     0.200
     2.634    -3.860     0.200
     2.709    -7.656     0.200
     2.836    -9.293     0.200
     2.991    -8.553     0.200
     2.973    -4.665     0.200
     3.067    -8.757     0.200
     0.331     1.864     0.200
     0.788     0.376     0.200
     1.003    -0.979     0.200
     1.210    -1.382     0.200
     1.762    -3.322     0.200
     1.898    -3.852     0.200
     2.232    -6.236     0.200
     2.491    -7.046     0.200
     2.491    -7.050     0.200
     2.622    -7.401     0.200
     2.647    -7.627     0.200
     2.702    -8.245     0.200
     0.210     5.645     0.200
     0.209     5.628     0.200
     0.589     2.619     0.200
     0.879     0.448     0.200
     1.029    -0.227     0.200
     1.322    -1.132     0.200
     1.514    -2.383     0.200
     1.606    -3.684     0.200
     1.938    -5.492     0.200
     2.082    -4.348     0.200
     2.192    -5.781     0.200
     2.247    -6.407     0.200
     2.249    -5.558     0.200
     2.276    -4.837     0.200
     2.311    -6.252     0.200
     2.333    -7.230     0.200
     2.363    -5.946     0.200
     2.383    -6.116     0.200
     2.420    -5.804     0.200
     2.427    -5.836     0.200
     2.581    -7.077     0.200
     2.552    -5.919     0.200
     2.730    -7.864     0.200
     0.289     1.622     0.200
     0.307     1.332     0.200
     0.465     0.277     0.200
     0.869     1.408     0.200
     1.380    -1.139     0.200
     1.935    -2.015     0.200
     1.970    -2.324     0.200
     2.109    -1.772     0.200
     2.210    -2.612     0.200
     2.196    -2.596     0.200
     2.257    -1.729     0.200
     2.270    -2.136     0.200
     2.289    -3.069     0.200
     2.299    -4.652     0.200
     2.309    -2.543     0.200
     2.330    -2.235     0.200
     2.331    -2.294     0.200
     2.353    -5.230     0.200
     2.362    -2.450     0.200
     2.361    -5.423     0.200
     2.351    -2.993     0.200
     2.327    -0.333     0.200
     2.404    -0.848     0.200
     2.413    -3.348     0.200
     2.495    -2.328     0.200
     2.503    -3.205     0.200
     2.576    -3.647     0.200
     2.630    -3.880     0.200
     2.672    -4.188     0.200
     2.835    -5.939     0.200
     2.818    -3.985     0.200
     2.907    -3.744     0.200
     2.947    -5.352     0.200
     3.073    -5.397     0.200
     3.325    -9.793     0.200
     3.815    -5.207     0.200
     4.112   -12.491     0.200
     4.355   -13.728     0.200
     0.148     5.748     0.200
     0.181     5.554     0.200
     0.635     0.989     0.200
     0.935     0.227     0.200
     1.047    -0.362     0.200
     1.193    -1.238     0.200
     1.372    -1.722     0.200
     1.571    -1.822     0.200
     1.668    -2.295     0.200
     1.991    -4.918     0.200
     2.222    -5.621     0.200
     2.399    -4.360     0.200
     2.435    -6.054     0.200
     2.441    -6.921     0.200
     2.584    -7.518     0.200
     2.640    -6.424     0.200
     0.228     5.389     0.200
     0.309     4.740     0.200
     0.480     2.807     0.200
     0.844     1.278     0.200
     1.080    -0.154     0.200
     1.302    -1.716     0.200
     1.825    -3.899     0.200
     2.253    -6.505     0.200
     2.277    -7.139     0.200
     2.316    -6.947     0.200
     2.415    -7.710     0.200
     2.480    -7.083     0.200
     2.544    -8.305     0.200
     2.755    -7.927     0.200
     2.836    -7.475     0.200
     0.364    -0.174     0.200
     1.122     1.037     0.200
     1.300     0.117     0.200
     1.765    -1.555     0.200
     1.813    -1.383     0.200
     1.845    -0.159     0.200
     1.896    -1.650     0.200
     2.026    -2.182     0.200
     2.544    -5.142     0.200
     2.546    -5.028     0.200
     2.547    -4.618     0.200
     2.615    -5.248     0.200
     2.726    -5.744     0.200
     2.782    -5.727     0.200
     0.307     4.401     0.200
     0.375     3.812     0.200
     0.499     2.765     0.200
     0.769     1.656     0.200
     0.879     0.353     0.200
     1.149    -0.171     0.200
     1.244    -1.319     0.200
     1.332    -1.327     0.200
     1.538    -2.286     0.200
     1.788    -1.792     0.200
     1.834    -3.832     0.200
     2.048    -4.678     0.200
     2.079    -3.848     0.200
     2.120    -6.132     0.200
     2.136    -5.701     0.200
     2.155    -3.388     0.200
     2.162    -5.419     0.200
     2.165    -3.710     0.200
     2.195    -6.246     0.200
     2.220    -3.479     0.200
     2.225    -5.276     0.200
     2.268    -6.329     0.200
     2.271    -6.755     0.200
     2.494    -5.633     0.200
     2.545    -5.497     0.200
     2.761    -8.934     0.200
     2.771    -5.119     0.200
     0.492     1.757     0.200
     0.900     0.864     0.200
     1.585    -1.218     0.200
     1.604     0.705     0.200
     2.110    -3.903     0.200
     2.195    -3.718     0.200
     2.226    -5.183     0.200
     2.357    -5.333     0.200
     2.427    -6.541     0.200
     2.492    -6.933     0.200
     2.521    -5.472     0.200
     2.408    -7.019     0.200
     2.524    -5.903     0.200
     2.534    -5.921     0.200
     2.555    -5.517     0.200
     2.570    -6.715     0.200
     2.554    -6.236     0.200
     2.585    -4.786     0.200
     2.585    -5.585     0.200
     2.613    -5.925     0.200
     2.613    -5.335     0.200
     2.629    -6.602     0.200
     2.631    -6.129     0.200
     2.638    -6.146     0.200
     2.650    -6.407     0.200
     2.689    -6.605     0.200
     2.720    -7.117     0.200
     2.726    -7.172     0.200
     2.799    -7.259     0.200
     2.854    -8.262     0.200
     2.883    -7.880     0.200
     2.999    -9.594     0.200
     3.132    -9.911     0.200
     3.108    -8.100     0.200
     3.098    -9.633     0.200
     3.548   -11.137     0.200
     0.575     1.773     0.200
     1.338    -0.177     0.200
     1.441    -2.154     0.200
     1.747    -2.187     0.200
     1.825    -3.942     0.200
     1.866    -3.028     0.200
     1.893    -4.449     0.200
     2.034    -4.311     0.200
     2.381    -6.643     0.200
     2.454    -7.213     0.200
     2.596    -7.054     0.200
     2.606    -6.702     0.200
     2.606    -6.689     0.200
     2.669    -6.678     0.200
     2.693    -7.483     0.200
     2.740    -8.958     0.200
     2.689    -7.354     0.200
     2.752    -8.658     0.200
     2.715    -8.178     0.200
     2.818    -8.775     0.200
     2.832    -8.776     0.200
     2.855    -8.622     0.200
     2.858    -8.041     0.200
     2.878    -8.677     0.200
     2.908    -9.624     0.200
     2.946    -8.826     0.200
     2.951    -8.995     0.200
     2.964    -9.421     0.200
EOF
gmt end
