#!/bin/bash
gmt begin acapulco7.51_tt6_local_regional pdf,ps
proj=-JX18/12
reg=-R0/30/0/70
gmt basemap $proj $reg -Bxa5f1+l'Epicentral Distance (deg)' -Bya10f1+l'Reduced Travel Time (s)' -BWeSn+t'Local-Regional acapulco7.51'
# Reduction velocity
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     2.000     6.000 Inverse reduction velocity: 11.67 sec/deg
EOF
# Distance limit for local crustal model
gmt plot $proj $reg -Wthick,black,- << EOF
  17.0 0.0
  17.0 70.0
EOF
gmt plot $proj $reg -Wthick,black << EOF
    14.000    39.772
    14.500    39.494
    15.000    39.215
    15.500    38.932
    16.000    38.646
    16.500    38.354
    17.000    38.055
    17.500    37.747
    18.000    37.428
    18.500    37.095
    19.000    36.748
    19.500    36.383
    20.000    35.998
    20.500    35.591
    21.000    35.160
    21.500    34.702
    22.000    34.215
    22.500    33.699
    23.000    33.150
    23.500    32.407
    24.000    31.142
    24.500    29.867
    25.000    28.583
    25.500    27.288
    26.000    25.982
    26.500    24.664
    27.000    23.333
    27.500    21.985
    28.000    20.617
    28.500    19.235
    29.000    17.842
    29.500    16.442
    30.000    15.033
EOF
# P label
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jTR << EOF
    28.000    17.617 P
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000     6.760
     1.500     7.918
     2.000     9.076
     2.500    10.234
     3.000    11.391
     3.500    12.548
     4.000    13.703
     4.500    14.858
     5.000    16.012
     5.500    17.164
     6.000    18.316
     6.500    19.465
     7.000    20.613
     7.500    21.759
     8.000    22.904
     8.500    24.047
     9.000    25.187
     9.500    26.325
    10.000    27.460
    10.500    28.592
    11.000    29.618
    11.500    30.538
    12.000    31.374
    12.500    32.165
    13.000    32.943
    13.500    33.700
    14.000    34.431
    14.500    35.134
    15.000    35.806
    15.500    36.379
    16.000    36.890
    16.500    37.344
    17.000    37.740
    17.500    36.888
    18.000    37.208
    18.500    37.470
    19.000    37.676
    19.500    37.823
    20.000    37.912
    20.500    37.943
    21.000    37.914
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
    13.000    29.943 Pn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    18.325
     3.000    21.990
     3.500    25.655
     4.000    29.320
     4.500    32.985
     5.000    36.650
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     4.000    32.320 P_
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500     4.985
     1.000     7.205
     1.500     9.772
     2.000    12.406
     2.500    15.060
     3.000    17.723
     3.500    20.390
     4.000    23.059
     4.500    25.729
     5.000    28.399
     5.500    31.068
     6.000    33.736
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     5.000    26.399 Pg
EOF
gmt plot $proj $reg -Wthick,green << EOF
     1.000    19.867
     1.500    26.363
     2.000    32.859
     2.500    39.355
     3.000    45.849
     3.500    52.339
     4.000    58.829
     4.500    65.313
     5.000    71.795
     5.500    78.273
     6.000    84.746
     6.500    91.214
     7.000    97.678
     7.500   104.135
     8.000   110.587
     8.500   117.031
     9.000   123.469
     9.500   129.899
    10.000   136.322
    10.500   142.735
    11.000   149.141
    11.500   155.537
    12.000   161.925
    12.500   168.305
    13.000   174.674
    13.500   181.033
    14.000   187.382
    14.500   193.720
    15.000   200.046
    15.500   206.360
    16.000   212.663
    16.500   218.953
    17.000   225.232
    17.500   230.641
    18.000   236.903
    18.500   243.153
    19.000   249.390
    19.500   255.613
    20.000   261.822
    20.500   268.016
    21.000   274.195
    21.500   280.359
    22.000   286.507
    22.500   292.639
    23.000   298.755
    23.500   304.853
    24.000   310.934
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     4.000    56.829 Sn
EOF
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
gmt plot $proj $reg -Wthick,red << EOF
     0.500    12.366
     1.000    20.111
     1.500    28.458
     2.000    36.919
     2.500    45.416
     3.000    53.928
     3.500    62.447
     4.000    70.970
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.500    60.447 Sg
EOF
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    49.575
     3.000    59.490
     3.500    69.405
     4.000    79.320
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.000    61.490 Lg
EOF
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
    17.276   235.817     0.150
    24.130   253.577     0.150
    27.857   319.080     0.150
    28.061   305.704     0.150
    28.347   665.367     0.150
    28.975   317.929     0.150
    17.088    45.837     0.150
    17.128    44.592     0.150
    17.220    46.202     0.150
    17.269    45.649     0.150
    17.518    47.766     0.150
    18.073   250.119     0.150
    26.670   301.831     0.150
    18.912    50.590     0.150
    19.877    49.294     0.150
    20.601    52.325     0.150
    20.852    51.264     0.150
    26.573  -300.312     0.150
    26.573   230.024     0.150
    26.641   230.171     0.150
    17.098    43.310     0.150
    17.129    42.614     0.150
    17.129    42.352     0.150
    17.515    42.917     0.150
    17.666    43.027     0.150
    17.666    43.386     0.150
    17.808    43.837     0.150
    17.808    45.266     0.150
    18.495   247.345     0.150
    21.844   270.605     0.150
    22.271   281.014     0.150
    23.496   278.213     0.150
    23.523   472.967     0.150
    23.540   285.672     0.150
    24.880   295.268     0.150
    26.361   234.014     0.150
    26.361   301.434     0.150
    26.664   303.415     0.150
    27.890   219.914     0.150
    28.259   311.123     0.150
    28.823  -325.834     0.150
    29.013  -330.597     0.150
    29.610   202.534     0.150
    17.111    44.132     0.150
    17.111    43.183     0.150
    17.490    43.168     0.150
    17.516    51.768     0.150
    17.647    43.006     0.150
    17.647    43.467     0.150
    20.194    51.104     0.150
    24.863   301.740     0.150
    26.176  -291.649     0.150
    26.375   233.649     0.150
    26.675   229.754     0.150
    27.225  -305.459     0.150
    28.240  -312.952     0.150
    28.504  -321.847     0.150
    28.504  -318.136     0.150
    28.779  -322.185     0.150
    28.814  -322.101     0.150
    17.532    45.544     0.150
    26.441  -300.869     0.150
    26.671   233.593     0.150
    26.846  -305.958     0.150
    26.949  -308.140     0.150
    26.949   228.830     0.150
    12.926   842.435     0.150
    14.978   214.924     0.150
    16.637   231.897     0.150
    18.989   253.856     0.150
    22.849   285.615     0.150
    23.376   285.737     0.150
    25.893   237.990     0.150
    26.928   228.688     0.150
    27.005   228.291     0.150
    27.005   685.838     0.150
    27.005  2221.939     0.150
    27.146   225.808     0.150
    27.146   682.160     0.150
    27.146  1793.660     0.150
    27.344   224.785     0.150
    27.344   225.003     0.150
    27.482   309.138     0.150
    28.574   213.929     0.150
    29.146   208.004     0.150
    29.991  -341.258     0.150
    26.804  -303.734     0.150
    17.338   234.279     0.150
    24.203   701.499     0.150
    19.427   253.195     0.150
    20.739   289.649     0.150
    22.565   481.954     0.150
    22.933   312.239     0.150
    23.374   474.159     0.150
    26.329   453.895     0.150
    27.330  -306.779     0.150
    29.928  -341.325     0.150
    29.981  -341.542     0.150
    16.562   332.908     0.150
    26.913   230.642     0.150
    17.278    45.576     0.150
    18.438   249.317     0.150
    27.107   228.570     0.150
    27.107   446.418     0.150
    27.107   687.336     0.150
    27.246   226.718     0.150
    27.446   225.406     0.150
    27.446   445.715     0.150
    15.997    44.014     0.150
    27.056   229.280     0.150
    27.056   229.284     0.150
    27.233   225.606     0.150
    27.233   225.606     0.150
    27.411   224.715     0.150
    28.659   213.680     0.150
    26.807   231.523     0.150
    26.807   231.519     0.150
    27.102   227.532     0.150
    27.102   227.528     0.150
    28.329   216.926     0.150
    18.796    47.577     0.150
    26.955  -306.471     0.150
    15.045   216.373     0.150
    15.630   220.948     0.150
    15.820   221.230     0.150
    17.014   234.551     0.150
    17.161   234.149     0.150
    17.307   236.815     0.150
    17.726   240.710     0.150
    17.819   242.008     0.150
    18.040   244.900     0.150
    18.177   242.127     0.150
    18.693   251.558     0.150
    18.753   250.688     0.150
    19.100   252.439     0.150
    19.114   251.459     0.150
    20.067   258.657     0.150
    20.077   258.285     0.150
    21.506   271.845     0.150
    21.513   271.525     0.150
    21.805   272.597     0.150
    21.890   277.090     0.150
    22.094   274.649     0.150
    22.173   275.900     0.150
    22.227   279.087     0.150
    22.314   282.360     0.150
    22.486   284.071     0.150
    22.608   282.371     0.150
    22.631   284.875     0.150
    22.833   286.439     0.150
    22.880   286.534     0.150
    22.889   285.903     0.150
    22.896   286.128     0.150
    23.231   288.973     0.150
    23.342   284.078     0.150
    23.349   288.363     0.150
    23.509   286.611     0.150
    23.617   291.446     0.150
    23.655   290.495     0.150
    23.811   287.071     0.150
    23.838   290.253     0.150
    23.848   292.002     0.150
    23.934   287.391     0.150
    23.983   288.110     0.150
    24.009   292.223     0.150
    24.057   293.651     0.150
    24.079   292.491     0.150
    24.124   291.861     0.150
    24.261   290.724     0.150
    24.380   294.550     0.150
    24.486   298.823     0.150
    24.492   295.105     0.150
    24.630   297.759     0.150
    24.655   296.428     0.150
    24.688   294.110     0.150
    24.968   293.225     0.150
    24.970   298.144     0.150
    25.118   293.611     0.150
    25.175   296.750     0.150
    25.186   294.732     0.150
    25.367   297.757     0.150
    25.498   298.770     0.150
    25.500   300.137     0.150
    25.508   294.419     0.150
    25.691   294.313     0.150
    25.794   299.576     0.150
    25.839   301.655     0.150
    25.852   303.197     0.150
    25.971   299.069     0.150
    26.117   300.964     0.150
    26.307   303.507     0.150
    26.487   302.487     0.150
    27.295   223.487     0.150
    27.325   225.131     0.150
    27.596   221.596     0.150
    21.213    51.720     0.150
    22.855    51.505     0.150
    23.537    46.126     0.150
    23.870    50.006     0.150
    26.370    43.306     0.150
    27.334  -305.591     0.150
    27.334   221.945     0.150
    27.413  -307.230     0.150
    27.413   222.052     0.150
    27.664  -308.793     0.150
    29.704    34.373     0.150
    27.373  -311.390     0.150
    27.579  -313.768     0.150
    15.287   222.228     0.150
    15.428   220.730     0.150
    15.629   224.632     0.150
    15.694   227.399     0.150
    16.631   235.043     0.150
    17.151   240.828     0.150
    17.691    43.856     0.150
    18.210   247.713     0.150
    18.634   251.416     0.150
    21.864   278.951     0.150
    22.121   281.443     0.150
    22.391   285.393     0.150
    22.502   285.637     0.150
    23.446   291.856     0.150
    23.866   291.927     0.150
    26.585   233.930     0.150
    26.957   229.154     0.150
    27.015   228.887     0.150
    23.359    43.588     0.150
    26.854   229.473     0.150
    27.080   226.163     0.150
    26.394  -296.892     0.150
    29.885  -336.843     0.150
    27.005   229.972     0.150
    27.222   226.452     0.150
    26.781   230.862     0.150
    27.041   227.989     0.150
    26.221   234.869     0.150
    26.587  -298.567     0.150
    28.744  -325.408     0.150
    16.865   229.573     0.150
    17.395    44.082     0.150
    17.809    44.866     0.150
    27.664   221.950     0.150
    27.683   221.365     0.150
    16.122   223.956     0.150
    17.116    43.286     0.150
    17.137    43.564     0.150
    17.172    43.866     0.150
    17.188    43.504     0.150
    18.977   254.654     0.150
    18.850    48.736     0.150
    20.045   254.413     0.150
    20.803   267.784     0.150
    21.310   273.161     0.150
    21.733   274.562     0.150
    22.468   276.099     0.150
    23.999   291.125     0.150
    26.788   302.570     0.150
    26.907   230.979     0.150
    27.015   302.564     0.150
    27.369   304.863     0.150
    27.432   300.911     0.150
    27.492   303.427     0.150
    27.726   312.335     0.150
    28.590   310.395     0.150
    17.853    48.778     0.150
    19.498    46.016     0.150
    20.183    44.871     0.150
    26.995   227.188     0.150
    27.021   228.445     0.150
    27.228   225.461     0.150
    27.589    33.545     0.150
    27.252    29.766     0.150
    27.036   227.217     0.150
    26.498   230.350     0.150
    26.751   228.295     0.150
    18.092    51.246     0.150
    23.604   297.706     0.150
    16.548   230.864     0.150
    17.882    47.194     0.150
    23.669   298.514     0.150
    23.673   293.007     0.150
    26.936  -307.880     0.150
    27.444  -314.776     0.150
    29.264  -334.916     0.150
    27.588   221.781     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.976    41.436     0.200
    16.387    41.941     0.200
    16.519    41.193     0.200
    16.818    41.901     0.200
    19.124    41.496     0.200
    19.271    40.773     0.200
    19.274    36.847     0.200
    19.888    39.676     0.200
    20.710    38.683     0.200
    21.191    44.072     0.200
    21.346    40.066     0.200
    21.654    40.975     0.200
    21.702    40.911     0.200
    21.978    42.188     0.200
    22.259    36.410     0.200
    22.259    36.711     0.200
    22.223    39.834     0.200
    22.376    36.444     0.200
    22.496    35.643     0.200
    22.496    36.042     0.200
    22.714    39.780     0.200
    22.787    39.243     0.200
    22.811    38.971     0.200
    22.983    35.956     0.200
    22.983    36.155     0.200
    23.113    35.449     0.200
    23.113    35.847     0.200
    23.383    37.090     0.200
    23.402    36.677     0.200
    23.533    37.547     0.200
    24.096    37.474     0.200
    24.109    37.825     0.200
    24.130    37.827     0.200
    24.130    36.941     0.200
    24.915    34.914     0.200
    25.324    34.636     0.200
    25.521    34.343     0.200
    26.088    32.722     0.200
    26.002    31.734     0.200
    26.047    31.309     0.200
    26.306    30.177     0.200
    26.414    31.420     0.200
    26.685    29.759     0.200
    26.849    29.346     0.200
    26.814    29.753     0.200
    26.943    28.748     0.200
    26.957    28.486     0.200
    26.975    29.674     0.200
    27.106    30.241     0.200
    27.452    25.308     0.200
    27.452    27.708     0.200
    27.611    28.948     0.200
    27.534    25.853     0.200
    27.534    26.353     0.200
    27.535    28.033     0.200
    27.857    26.181     0.200
    28.061    26.204     0.200
    28.230    25.729     0.200
    28.347    26.067     0.200
    28.366    25.537     0.200
    28.740    22.771     0.200
    28.975    20.632     0.200
    28.901    24.300     0.200
    29.050    22.353     0.200
    29.064    24.193     0.200
    29.734    22.475     0.200
    14.216    41.866     0.200
    14.247    42.637     0.200
    14.623    42.350     0.200
    14.923    42.837     0.200
    16.316    46.292     0.200
    18.076    43.892     0.200
    18.073    43.293     0.200
    18.193    44.684     0.200
    18.228    44.898     0.200
    18.439    40.548     0.200
    19.876    39.227     0.200
    19.908    38.799     0.200
    20.388    39.242     0.200
    20.896    37.997     0.200
    20.900    38.158     0.200
    21.359    39.813     0.200
    21.754    37.924     0.200
    21.962    37.181     0.200
    22.157    40.157     0.200
    22.173    37.436     0.200
    22.351    39.283     0.200
    22.388    36.654     0.200
    22.714    37.724     0.200
    22.765    35.862     0.200
    22.910    39.386     0.200
    23.008    39.336     0.200
    23.121    38.726     0.200
    23.237    35.430     0.200
    23.238    37.345     0.200
    23.335    41.040     0.200
    23.561    39.413     0.200
    23.579    37.405     0.200
    23.844    36.767     0.200
    23.904    36.478     0.200
    23.929    37.705     0.200
    23.952    36.133     0.200
    24.082    36.186     0.200
    24.082    36.216     0.200
    24.117    35.094     0.200
    24.387    33.539     0.200
    24.528    34.783     0.200
    24.675    36.349     0.200
    24.706    36.212     0.200
    25.082    32.350     0.200
    25.629    33.035     0.200
    25.813    33.490     0.200
    26.595    28.794     0.200
    26.593    31.749     0.200
    26.670    30.966     0.200
    26.810    31.135     0.200
    26.941    29.087     0.200
    26.941    28.728     0.200
    27.059    29.719     0.200
    27.041    32.130     0.200
    27.293    29.439     0.200
    27.363    28.561     0.200
    27.510    25.625     0.200
    27.522    28.075     0.200
    27.677    28.190     0.200
    27.841    26.518     0.200
    27.957    26.873     0.200
    28.226    27.153     0.200
    28.300    26.622     0.200
    28.412    30.257     0.200
    28.646    23.229     0.200
    29.043    24.958     0.200
    29.051    23.517     0.200
    29.136    26.868     0.200
    29.150    23.622     0.200
    29.763    23.064     0.200
    29.785    22.208     0.200
    29.913    21.465     0.200
    15.284    38.535     0.200
    16.611    39.940     0.200
    17.638    40.848     0.200
    17.697    40.898     0.200
    18.079    40.980     0.200
    18.302    37.965     0.200
    19.877    36.794     0.200
    20.852    35.223     0.200
    21.184    37.176     0.200
    21.490    35.447     0.200
    21.631    37.130     0.200
    21.697    38.186     0.200
    21.844    36.769     0.200
    21.907    33.564     0.200
    21.971    36.959     0.200
    22.017    38.771     0.200
    22.218    34.288     0.200
    22.260    33.616     0.200
    22.331    34.740     0.200
    22.437    38.142     0.200
    22.488    36.829     0.200
    22.672    33.358     0.200
    22.898    34.575     0.200
    22.985    32.662     0.200
    23.119    32.953     0.200
    23.079    36.249     0.200
    23.105    35.747     0.200
    23.514    35.578     0.200
    23.605    33.112     0.200
    23.663    35.835     0.200
    23.981    32.233     0.200
    24.043    34.875     0.200
    24.170    32.688     0.200
    24.173    30.871     0.200
    24.174    31.175     0.200
    24.211    34.113     0.200
    24.649    32.296     0.200
    25.010    29.015     0.200
    25.115    31.662     0.200
    25.224    30.688     0.200
    25.295    30.978     0.200
    25.349    31.580     0.200
    25.402    30.962     0.200
    25.569    29.667     0.200
    25.570    31.078     0.200
    25.945    28.772     0.200
    26.082    28.554     0.200
    26.149    29.552     0.200
    26.225    28.940     0.200
    26.347    29.106     0.200
    26.573    26.225     0.200
    26.618    25.198     0.200
    26.641    27.222     0.200
    26.830    26.779     0.200
    26.948    24.877     0.200
    26.983    25.562     0.200
    27.027    23.402     0.200
    27.067    26.048     0.200
    27.248    26.656     0.200
    27.469    22.546     0.200
    27.466    24.176     0.200
    27.587    24.351     0.200
    27.787    25.029     0.200
    28.064    23.175     0.200
    28.644    19.802     0.200
    28.751    21.307     0.200
    28.819    18.367     0.200
    29.263    20.932     0.200
    29.849    18.575     0.200
    15.834    41.160     0.200
    15.908    40.867     0.200
    15.908    43.576     0.200
    15.970    40.709     0.200
    16.286    39.987     0.200
    16.489    42.520     0.200
    16.566    44.540     0.200
    16.592    41.912     0.200
    16.669    40.655     0.200
    16.877    42.745     0.200
    16.979    41.289     0.200
    16.979    41.828     0.200
    17.140    40.971     0.200
    17.298    42.148     0.200
    17.347    41.348     0.200
    17.485    41.365     0.200
    17.478    42.467     0.200
    17.501    42.491     0.200
    17.509    42.039     0.200
    17.509    42.199     0.200
    17.563    41.777     0.200
    17.596    42.641     0.200
    17.648    42.901     0.200
    17.767    41.147     0.200
    17.767    41.356     0.200
    17.808    41.964     0.200
    17.853    41.593     0.200
    18.072    42.212     0.200
    18.289    37.866     0.200
    18.891    38.221     0.200
    19.812    37.517     0.200
    20.103    38.612     0.200
    20.196    37.111     0.200
    20.501    38.001     0.200
    20.802    37.141     0.200
    20.804    35.423     0.200
    20.960    37.786     0.200
    21.027    37.678     0.200
    21.049    39.207     0.200
    21.113    39.250     0.200
    21.191    37.606     0.200
    21.191    38.317     0.200
    21.237    39.576     0.200
    21.286    39.024     0.200
    21.318    36.668     0.200
    21.324    39.100     0.200
    21.335    39.090     0.200
    21.357    36.394     0.200
    21.469    37.813     0.200
    21.469    40.106     0.200
    21.481    39.112     0.200
    21.517    35.464     0.200
    21.531    35.441     0.200
    21.538    39.136     0.200
    21.594    35.631     0.200
    21.589    37.656     0.200
    21.590    39.107     0.200
    21.657    38.674     0.200
    21.746    38.097     0.200
    21.844    38.799     0.200
    21.849    38.457     0.200
    21.863    33.906     0.200
    21.863    34.185     0.200
    21.980    38.293     0.200
    22.037    37.988     0.200
    22.049    34.402     0.200
    22.051    34.598     0.200
    22.138    34.702     0.200
    22.154    39.619     0.200
    22.199    38.057     0.200
    22.231    38.078     0.200
    22.244    34.210     0.200
    22.244    34.348     0.200
    22.269    37.785     0.200
    22.271    37.215     0.200
    22.281    37.103     0.200
    22.420    36.418     0.200
    22.424    37.626     0.200
    22.447    33.864     0.200
    22.498    37.074     0.200
    22.518    37.335     0.200
    22.572    37.613     0.200
    22.630    37.427     0.200
    22.642    33.755     0.200
    22.645    36.544     0.200
    22.639    37.466     0.200
    22.726    37.652     0.200
    22.761    36.997     0.200
    22.834    36.709     0.200
    22.860    37.497     0.200
    22.903    37.135     0.200
    22.910    36.724     0.200
    22.918    36.957     0.200
    22.975    33.530     0.200
    22.975    35.643     0.200
    22.996    36.592     0.200
    23.035    36.656     0.200
    23.050    36.871     0.200
    23.099    33.273     0.200
    23.094    36.812     0.200
    23.229    38.043     0.200
    23.237    36.345     0.200
    23.247    36.788     0.200
    23.291    36.318     0.200
    23.330    36.199     0.200
    23.384    36.401     0.200
    23.396    35.968     0.200
    23.418    36.204     0.200
    23.475    33.286     0.200
    23.496    34.914     0.200
    23.523    35.999     0.200
    23.540    32.502     0.200
    23.535    35.912     0.200
    23.533    35.650     0.200
    23.568    34.519     0.200
    23.627    35.252     0.200
    23.637    35.422     0.200
    23.779    35.233     0.200
    23.779    35.601     0.200
    23.816    35.691     0.200
    23.873    35.510     0.200
    23.890    33.084     0.200
    23.892    35.230     0.200
    23.898    35.350     0.200
    23.966    34.177     0.200
    24.009    35.556     0.200
    24.075    32.977     0.200
    24.071    34.525     0.200
    24.090    32.076     0.200
    24.135    34.961     0.200
    24.177    35.334     0.200
    24.177    35.018     0.200
    24.177    35.106     0.200
    24.286    30.726     0.200
    24.286    31.197     0.200
    24.315    31.420     0.200
    24.306    34.627     0.200
    24.414    32.359     0.200
    24.461    34.513     0.200
    24.461    34.355     0.200
    24.467    34.321     0.200
    24.484    33.933     0.200
    24.502    31.710     0.200
    24.755    32.578     0.200
    24.754    33.419     0.200
    24.783    33.521     0.200
    24.798    33.613     0.200
    24.856    32.704     0.200
    24.880    33.368     0.200
    24.914    33.943     0.200
    24.943    33.039     0.200
    24.949    32.831     0.200
    24.973    29.711     0.200
    24.973    29.836     0.200
    24.985    31.878     0.200
    25.105    31.332     0.200
    25.103    32.442     0.200
    25.144    28.724     0.200
    25.144    32.670     0.200
    25.169    32.216     0.200
    25.169    32.047     0.200
    25.220    31.561     0.200
    25.244    32.621     0.200
    25.270    31.759     0.200
    25.310    32.595     0.200
    25.335    31.129     0.200
    25.335    30.748     0.200
    25.335    31.447     0.200
    25.380    31.825     0.200
    25.401    31.135     0.200
    25.451    31.798     0.200
    25.491    31.182     0.200
    25.488    31.764     0.200
    25.499    32.549     0.200
    25.560    30.983     0.200
    25.586    31.227     0.200
    25.602    31.614     0.200
    25.710    31.272     0.200
    25.713    31.489     0.200
    25.730    30.616     0.200
    25.842    29.506     0.200
    25.892    30.484     0.200
    25.895    30.624     0.200
    25.896    30.407     0.200
    26.047    29.546     0.200
    26.054    28.917     0.200
    26.059    30.546     0.200
    26.075    30.673     0.200
    26.099    30.238     0.200
    26.109    29.673     0.200
    26.110    28.787     0.200
    26.155    29.504     0.200
    26.164    28.347     0.200
    26.168    29.579     0.200
    26.188    30.238     0.200
    26.198    30.260     0.200
    26.312    29.275     0.200
    26.325    27.989     0.200
    26.366    26.779     0.200
    26.361    29.235     0.200
    26.370    29.378     0.200
    26.376    29.222     0.200
    26.429    28.839     0.200
    26.437    28.517     0.200
    26.494    29.269     0.200
    26.506    29.492     0.200
    26.546    26.251     0.200
    26.592    29.683     0.200
    26.600    28.121     0.200
    26.626    25.043     0.200
    26.639    28.282     0.200
    26.664    26.459     0.200
    26.664    26.540     0.200
    26.676    27.658     0.200
    26.702    27.635     0.200
    26.719    27.897     0.200
    26.767    27.493     0.200
    26.801    27.907     0.200
    26.862    25.982     0.200
    26.855    27.207     0.200
    26.933    27.266     0.200
    26.979    27.056     0.200
    27.002    27.943     0.200
    27.011    25.373     0.200
    27.011    25.576     0.200
    27.020    23.701     0.200
    27.028    26.962     0.200
    27.039    28.020     0.200
    27.041    27.000     0.200
    27.081    25.644     0.200
    27.194    26.510     0.200
    27.206    26.974     0.200
    27.210    26.251     0.200
    27.210    26.427     0.200
    27.282    26.354     0.200
    27.395    26.071     0.200
    27.404    25.858     0.200
    27.420    22.945     0.200
    27.408    28.008     0.200
    27.494    26.547     0.200
    27.508    26.628     0.200
    27.519    27.928     0.200
    27.535    25.180     0.200
    27.561    24.535     0.200
    27.562    25.682     0.200
    27.599    25.087     0.200
    27.627    24.462     0.200
    27.640    25.993     0.200
    27.640    26.132     0.200
    27.660    25.526     0.200
    27.677    26.213     0.200
    27.703    25.378     0.200
    27.707    24.226     0.200
    27.726    23.841     0.200
    27.727    25.807     0.200
    27.780    25.756     0.200
    27.768    26.220     0.200
    27.773    24.439     0.200
    27.848    24.850     0.200
    27.856    24.315     0.200
    27.868    24.455     0.200
    27.890    22.764     0.200
    27.912    25.041     0.200
    27.944    24.485     0.200
    27.952    24.685     0.200
    28.011    25.107     0.200
    28.075    24.275     0.200
    28.080    22.768     0.200
    28.119    24.864     0.200
    28.163    23.690     0.200
    28.189    23.311     0.200
    28.226    24.831     0.200
    28.232    23.765     0.200
    28.270    24.125     0.200
    28.259    26.973     0.200
    28.259    23.772     0.200
    28.259    24.354     0.200
    28.327    24.502     0.200
    28.323    24.297     0.200
    28.382    23.435     0.200
    28.440    24.013     0.200
    28.476    23.403     0.200
    28.499    23.753     0.200
    28.511    20.807     0.200
    28.528    23.540     0.200
    28.531    23.783     0.200
    28.552    24.360     0.200
    28.563    23.708     0.200
    28.568    23.549     0.200
    28.580    20.259     0.200
    28.620    22.741     0.200
    28.631    22.085     0.200
    28.714    22.282     0.200
    28.731    22.879     0.200
    28.741    22.714     0.200
    28.774    22.735     0.200
    28.781    19.168     0.200
    28.783    21.911     0.200
    28.804    21.544     0.200
    28.799    23.268     0.200
    28.823    20.536     0.200
    28.823    21.627     0.200
    28.827    22.747     0.200
    28.834    21.669     0.200
    28.846    22.026     0.200
    28.859    21.434     0.200
    28.859    21.713     0.200
    28.864    22.906     0.200
    28.879    22.321     0.200
    28.893    22.496     0.200
    28.965    22.667     0.200
    29.013    21.785     0.200
    29.040    21.353     0.200
    29.067    20.978     0.200
    29.078    21.349     0.200
    29.127    20.870     0.200
    29.211    22.171     0.200
    29.239    21.939     0.200
    29.249    20.547     0.200
    29.285    20.285     0.200
    29.408    21.298     0.200
    29.422    20.552     0.200
    29.479    20.404     0.200
    29.495    20.077     0.200
    29.547    18.384     0.200
    29.543    20.670     0.200
    29.607    19.893     0.200
    29.610    19.354     0.200
    29.626    19.242     0.200
    29.643    20.827     0.200
    29.681    19.534     0.200
    29.687    19.415     0.200
    29.723    19.473     0.200
    29.766    20.087     0.200
    29.779    19.490     0.200
    29.800    17.373     0.200
    29.840    18.465     0.200
    29.884    17.312     0.200
    29.877    19.019     0.200
    29.876    20.101     0.200
    29.892    18.840     0.200
    29.963    18.743     0.200
    29.980    19.090     0.200
    29.980    18.768     0.200
    29.997    18.947     0.200
    14.858    44.650     0.200
    15.890    43.906     0.200
    15.890    44.305     0.200
    16.299    40.056     0.200
    16.470    44.059     0.200
    16.470    44.278     0.200
    16.683    40.306     0.200
    17.153    40.737     0.200
    17.332    39.877     0.200
    17.361    41.000     0.200
    17.490    42.618     0.200
    17.498    40.979     0.200
    17.781    40.809     0.200
    17.819    41.330     0.200
    17.867    41.283     0.200
    18.290    37.708     0.200
    18.398    38.054     0.200
    18.891    37.753     0.200
    19.807    36.613     0.200
    20.194    36.995     0.200
    20.490    37.215     0.200
    20.800    34.599     0.200
    20.800    38.128     0.200
    20.970    37.842     0.200
    20.983    39.651     0.200
    21.025    35.539     0.200
    20.999    39.294     0.200
    21.064    39.018     0.200
    21.127    38.894     0.200
    21.202    37.711     0.200
    21.202    37.823     0.200
    21.251    39.250     0.200
    21.302    38.769     0.200
    21.355    36.433     0.200
    21.340    39.000     0.200
    21.351    39.430     0.200
    21.450    39.033     0.200
    21.515    35.238     0.200
    21.496    38.785     0.200
    21.537    35.432     0.200
    21.552    38.879     0.200
    21.592    36.534     0.200
    21.645    41.301     0.200
    21.604    38.884     0.200
    21.672    38.366     0.200
    21.761    38.839     0.200
    21.860    33.616     0.200
    21.859    38.202     0.200
    21.859    38.432     0.200
    21.859    37.801     0.200
    21.859    38.627     0.200
    21.864    38.300     0.200
    22.044    33.870     0.200
    22.054    34.382     0.200
    22.050    37.651     0.200
    22.254    38.288     0.200
    22.213    37.734     0.200
    22.244    33.758     0.200
    22.245    37.738     0.200
    22.282    37.689     0.200
    22.295    37.874     0.200
    22.446    33.168     0.200
    22.437    37.234     0.200
    22.533    37.368     0.200
    22.588    37.786     0.200
    22.641    33.110     0.200
    22.643    37.175     0.200
    22.655    36.014     0.200
    22.654    37.347     0.200
    22.774    36.767     0.200
    22.874    37.053     0.200
    22.917    36.552     0.200
    22.926    37.170     0.200
    22.970    33.276     0.200
    22.932    36.625     0.200
    22.984    35.002     0.200
    23.012    36.906     0.200
    23.051    36.865     0.200
    23.065    36.945     0.200
    23.099    32.753     0.200
    23.108    36.723     0.200
    23.245    38.094     0.200
    23.251    36.186     0.200
    23.262    36.528     0.200
    23.304    36.818     0.200
    23.344    36.105     0.200
    23.397    36.448     0.200
    23.411    36.003     0.200
    23.434    36.215     0.200
    23.473    32.268     0.200
    23.534    32.720     0.200
    23.536    36.170     0.200
    23.548    35.842     0.200
    23.580    34.519     0.200
    23.640    34.521     0.200
    23.653    35.450     0.200
    23.792    35.101     0.200
    23.795    35.553     0.200
    23.830    35.619     0.200
    23.882    33.212     0.200
    23.888    35.549     0.200
    23.905    35.044     0.200
    23.914    35.232     0.200
    23.978    34.254     0.200
    24.022    35.027     0.200
    24.067    33.358     0.200
    24.082    31.925     0.200
    24.087    34.926     0.200
    24.150    34.725     0.200
    24.192    35.051     0.200
    24.192    34.946     0.200
    24.193    34.666     0.200
    24.310    31.083     0.200
    24.322    34.507     0.200
    24.423    31.932     0.200
    24.495    31.460     0.200
    24.476    34.247     0.200
    24.476    34.058     0.200
    24.481    33.871     0.200
    24.497    33.613     0.200
    24.767    32.395     0.200
    24.770    33.094     0.200
    24.798    33.164     0.200
    24.863    32.640     0.200
    24.813    33.381     0.200
    24.868    32.028     0.200
    24.970    29.115     0.200
    24.963    32.479     0.200
    24.959    32.925     0.200
    24.997    31.478     0.200
    25.114    30.757     0.200
    25.143    28.635     0.200
    25.117    32.185     0.200
    25.160    32.475     0.200
    25.182    31.826     0.200
    25.182    31.588     0.200
    25.231    31.212     0.200
    25.257    32.103     0.200
    25.285    31.677     0.200
    25.324    32.179     0.200
    25.348    31.000     0.200
    25.394    31.526     0.200
    25.412    30.814     0.200
    25.466    32.038     0.200
    25.503    30.589     0.200
    25.503    31.672     0.200
    25.515    31.820     0.200
    25.574    30.728     0.200
    25.600    30.977     0.200
    25.617    31.500     0.200
    25.724    30.624     0.200
    25.727    30.863     0.200
    25.742    30.232     0.200
    25.853    29.002     0.200
    25.908    29.841     0.200
    25.910    30.009     0.200
    25.912    30.061     0.200
    26.059    28.996     0.200
    26.067    28.840     0.200
    26.074    30.334     0.200
    26.113    29.893     0.200
    26.124    29.723     0.200
    26.125    28.576     0.200
    26.168    29.213     0.200
    26.176    28.058     0.200
    26.212    29.738     0.200
    26.360    26.611     0.200
    26.337    27.755     0.200
    26.328    29.068     0.200
    26.375    29.374     0.200
    26.390    28.813     0.200
    26.386    29.216     0.200
    26.442    28.443     0.200
    26.449    28.168     0.200
    26.540    25.616     0.200
    26.508    28.919     0.200
    26.574    29.044     0.200
    26.521    29.176     0.200
    26.630    25.029     0.200
    26.615    27.949     0.200
    26.653    28.050     0.200
    26.675    26.134     0.200
    26.675    26.104     0.200
    26.688    27.312     0.200
    26.718    27.435     0.200
    26.730    27.014     0.200
    26.780    27.271     0.200
    26.854    25.119     0.200
    26.817    27.633     0.200
    26.867    26.903     0.200
    26.946    26.990     0.200
    27.021    23.537     0.200
    27.041    26.848     0.200
    27.053    27.859     0.200
    27.057    26.853     0.200
    27.091    25.639     0.200
    27.207    26.071     0.200
    27.220    26.344     0.200
    27.225    25.998     0.200
    27.225    26.327     0.200
    27.296    25.960     0.200
    27.390    27.640     0.200
    27.416    22.472     0.200
    27.416    25.653     0.200
    27.410    25.736     0.200
    27.500    26.358     0.200
    27.508    26.347     0.200
    27.580    24.334     0.200
    27.523    26.482     0.200
    27.547    24.756     0.200
    27.572    24.034     0.200
    27.623    25.411     0.200
    27.575    25.672     0.200
    27.638    24.162     0.200
    27.762    26.000     0.200
    27.692    26.017     0.200
    27.755    23.389     0.200
    27.717    23.877     0.200
    27.717    25.134     0.200
    27.736    23.574     0.200
    27.743    25.681     0.200
    27.783    25.884     0.200
    27.861    24.683     0.200
    27.868    24.148     0.200
    27.879    24.154     0.200
    27.901    22.996     0.200
    27.891    24.664     0.200
    27.927    24.781     0.200
    27.956    23.904     0.200
    27.966    24.321     0.200
    28.027    24.997     0.200
    28.089    23.774     0.200
    28.133    24.624     0.200
    28.176    23.507     0.200
    28.240    21.493     0.200
    28.245    23.356     0.200
    28.241    24.701     0.200
    28.304    24.557     0.200
    28.284    23.570     0.200
    28.343    24.201     0.200
    28.395    23.099     0.200
    28.513    24.284     0.200
    28.455    23.579     0.200
    28.504    20.772     0.200
    28.490    22.721     0.200
    28.513    23.618     0.200
    28.575    20.103     0.200
    28.578    22.832     0.200
    28.643    21.631     0.200
    28.636    22.711     0.200
    28.781    23.323     0.200
    28.727    22.096     0.200
    28.779    19.291     0.200
    28.746    22.628     0.200
    28.784    24.398     0.200
    28.796    21.473     0.200
    28.814    21.215     0.200
    28.833    20.247     0.200
    28.846    21.312     0.200
    28.842    22.145     0.200
    28.860    21.631     0.200
    28.871    21.240     0.200
    28.879    22.713     0.200
    28.893    22.165     0.200
    28.908    22.278     0.200
    29.006    19.497     0.200
    28.980    22.004     0.200
    29.054    21.013     0.200
    29.078    20.728     0.200
    29.088    20.919     0.200
    29.140    20.605     0.200
    29.226    21.424     0.200
    29.253    21.754     0.200
    29.262    20.186     0.200
    29.298    20.214     0.200
    29.424    21.141     0.200
    29.436    20.184     0.200
    29.490    19.987     0.200
    29.556    18.344     0.200
    29.557    20.541     0.200
    29.621    19.819     0.200
    29.623    18.742     0.200
    29.639    18.899     0.200
    29.658    20.707     0.200
    29.692    19.192     0.200
    29.699    18.764     0.200
    29.735    19.040     0.200
    29.737    19.548     0.200
    29.781    19.544     0.200
    29.793    19.268     0.200
    29.851    18.148     0.200
    29.851    18.259     0.200
    29.879    15.594     0.200
    29.889    18.590     0.200
    29.892    19.735     0.200
    29.902    18.436     0.200
    29.976    18.428     0.200
    29.994    18.661     0.200
    29.994    18.438     0.200
    15.538    42.260     0.200
    15.649    40.416     0.200
    16.210    47.201     0.200
    16.592    41.861     0.200
    16.977    41.811     0.200
    17.111    41.832     0.200
    17.447    42.220     0.200
    17.656    42.515     0.200
    17.788    42.464     0.200
    17.970    43.195     0.200
    18.083    42.633     0.200
    18.075    42.716     0.200
    18.099    42.859     0.200
    18.163    42.775     0.200
    18.200    42.739     0.200
    18.236    43.238     0.200
    18.229    43.011     0.200
    18.269    43.028     0.200
    18.459    39.806     0.200
    18.472    39.757     0.200
    19.049    39.834     0.200
    19.899    39.424     0.200
    19.930    38.311     0.200
    21.134    41.504     0.200
    21.161    37.047     0.200
    21.145    40.785     0.200
    21.221    39.926     0.200
    21.237    39.146     0.200
    21.299    39.481     0.200
    21.295    40.702     0.200
    21.203    43.066     0.200
    21.359    40.483     0.200
    21.422    40.482     0.200
    21.460    40.368     0.200
    21.482    39.082     0.200
    21.482    39.230     0.200
    21.493    38.201     0.200
    21.545    40.594     0.200
    21.598    40.101     0.200
    21.626    40.732     0.200
    21.659    36.881     0.200
    21.636    40.510     0.200
    21.674    39.831     0.200
    21.727    36.988     0.200
    21.769    36.871     0.200
    21.792    40.317     0.200
    21.847    40.151     0.200
    21.864    39.026     0.200
    21.897    40.090     0.200
    21.984    35.270     0.200
    22.078    39.051     0.200
    22.057    39.662     0.200
    22.146    36.149     0.200
    22.172    38.353     0.200
    22.155    39.423     0.200
    22.155    40.054     0.200
    22.155    39.779     0.200
    22.160    39.804     0.200
    22.189    39.389     0.200
    22.197    36.434     0.200
    22.265    36.509     0.200
    22.339    39.108     0.200
    22.409    35.779     0.200
    22.404    38.459     0.200
    22.464    40.561     0.200
    22.494    39.300     0.200
    22.508    39.184     0.200
    22.542    38.909     0.200
    22.575    39.205     0.200
    22.604    34.871     0.200
    22.591    39.142     0.200
    22.640    38.420     0.200
    22.711    37.647     0.200
    22.721    36.739     0.200
    22.727    38.908     0.200
    22.787    35.903     0.200
    22.884    39.209     0.200
    22.926    37.428     0.200
    22.951    38.766     0.200
    22.999    37.265     0.200
    23.016    37.835     0.200
    23.063    34.835     0.200
    23.037    38.349     0.200
    23.065    38.226     0.200
    23.170    38.535     0.200
    23.213    38.397     0.200
    23.249    36.384     0.200
    23.226    38.239     0.200
    23.258    34.419     0.200
    23.222    37.934     0.200
    23.280    38.481     0.200
    23.305    36.747     0.200
    23.322    36.429     0.200
    23.308    37.922     0.200
    23.347    37.579     0.200
    23.361    37.945     0.200
    23.401    37.904     0.200
    23.545    37.382     0.200
    23.541    37.757     0.200
    23.559    37.728     0.200
    23.608    35.000     0.200
    23.596    37.875     0.200
    23.591    37.277     0.200
    23.623    33.894     0.200
    23.623    33.596     0.200
    23.639    37.347     0.200
    23.688    37.563     0.200
    23.706    36.794     0.200
    23.707    37.294     0.200
    23.728    36.011     0.200
    23.730    37.428     0.200
    23.828    37.119     0.200
    23.840    37.248     0.200
    23.863    35.914     0.200
    23.863    35.701     0.200
    23.868    35.662     0.200
    23.844    36.885     0.200
    23.912    36.388     0.200
    23.928    36.490     0.200
    23.953    34.870     0.200
    23.928    35.141     0.200
    23.949    36.660     0.200
    24.081    36.147     0.200
    24.101    33.955     0.200
    24.091    36.704     0.200
    24.107    35.078     0.200
    24.126    36.811     0.200
    24.141    33.750     0.200
    24.185    36.850     0.200
    24.200    36.222     0.200
    24.242    35.688     0.200
    24.262    34.939     0.200
    24.263    36.030     0.200
    24.316    36.241     0.200
    24.385    36.205     0.200
    24.409    32.460     0.200
    24.404    33.382     0.200
    24.382    34.816     0.200
    24.429    35.045     0.200
    24.446    35.661     0.200
    24.487    36.026     0.200
    24.487    36.213     0.200
    24.489    35.757     0.200
    24.527    34.471     0.200
    24.618    35.238     0.200
    24.685    33.564     0.200
    24.699    35.008     0.200
    24.716    34.923     0.200
    24.752    33.967     0.200
    24.773    34.608     0.200
    24.775    35.258     0.200
    24.773    35.129     0.200
    24.790    35.084     0.200
    24.890    33.948     0.200
    24.914    33.985     0.200
    25.052    34.124     0.200
    25.053    34.072     0.200
    25.097    32.866     0.200
    25.066    34.052     0.200
    25.104    31.084     0.200
    25.095    34.333     0.200
    25.109    34.446     0.200
    25.177    33.115     0.200
    25.207    33.687     0.200
    25.256    33.705     0.200
    25.279    33.414     0.200
    25.255    34.043     0.200
    25.304    30.393     0.200
    25.310    32.100     0.200
    25.382    32.703     0.200
    25.411    33.657     0.200
    25.472    33.204     0.200
    25.474    33.040     0.200
    25.456    33.509     0.200
    25.514    31.776     0.200
    25.552    30.127     0.200
    25.552    33.243     0.200
    25.583    32.506     0.200
    25.580    32.783     0.200
    25.624    32.124     0.200
    25.634    32.252     0.200
    25.621    33.547     0.200
    25.663    30.880     0.200
    25.680    31.064     0.200
    25.696    32.172     0.200
    25.687    32.805     0.200
    25.766    31.674     0.200
    25.787    32.206     0.200
    25.763    32.919     0.200
    25.840    30.242     0.200
    25.811    32.424     0.200
    25.845    32.664     0.200
    25.895    31.662     0.200
    25.935    30.714     0.200
    26.021    32.111     0.200
    26.031    31.454     0.200
    26.021    32.066     0.200
    26.057    30.129     0.200
    26.139    30.531     0.200
    26.215    30.122     0.200
    26.204    31.153     0.200
    26.207    31.204     0.200
    26.274    29.524     0.200
    26.304    30.898     0.200
    26.346    30.284     0.200
    26.353    29.821     0.200
    26.370    31.326     0.200
    26.408    30.946     0.200
    26.420    30.752     0.200
    26.441    28.196     0.200
    26.421    29.684     0.200
    26.458    29.468     0.200
    26.458    30.501     0.200
    26.484    30.094     0.200
    26.508    30.731     0.200
    26.621    29.101     0.200
    26.619    28.005     0.200
    26.624    30.262     0.200
    26.671    30.605     0.200
    26.683    29.939     0.200
    26.682    30.169     0.200
    26.738    29.440     0.200
    26.734    29.592     0.200
    26.785    28.694     0.200
    26.803    29.894     0.200
    26.846    26.489     0.200
    26.901    27.648     0.200
    26.949    27.688     0.200
    26.949    27.850     0.200
    26.949    27.629     0.200
    26.947    29.316     0.200
    26.974    28.344     0.200
    27.015    28.454     0.200
    27.014    28.521     0.200
    27.063    28.826     0.200
    27.070    28.608     0.200
    27.083    27.964     0.200
    27.049    30.567     0.200
    27.239    28.411     0.200
    27.272    26.733     0.200
    27.291    28.301     0.200
    27.312    28.130     0.200
    27.332    27.825     0.200
    27.329    28.941     0.200
    27.370    27.274     0.200
    27.349    28.921     0.200
    27.353    28.029     0.200
    27.402    27.409     0.200
    27.240    31.869     0.200
    27.496    27.295     0.200
    27.515    27.803     0.200
    27.533    24.951     0.200
    27.522    27.249     0.200
    27.577    26.541     0.200
    27.588    27.188     0.200
    27.486    27.291     0.200
    27.519    28.038     0.200
    27.680    27.056     0.200
    27.702    26.759     0.200
    27.740    26.412     0.200
    27.811    25.576     0.200
    27.803    27.426     0.200
    27.831    25.963     0.200
    27.849    25.495     0.200
    27.865    26.715     0.200
    27.891    25.412     0.200
    27.915    25.509     0.200
    27.968    25.776     0.200
    27.987    25.404     0.200
    27.995    25.088     0.200
    28.013    24.967     0.200
    27.988    26.789     0.200
    28.011    26.036     0.200
    28.039    26.996     0.200
    28.079    26.763     0.200
    28.157    25.337     0.200
    28.156    25.206     0.200
    28.154    25.567     0.200
    27.983    30.121     0.200
    28.177    24.327     0.200
    28.182    26.696     0.200
    28.241    25.012     0.200
    28.223    25.718     0.200
    28.257    25.555     0.200
    28.266    25.384     0.200
    28.291    24.850     0.200
    28.323    26.115     0.200
    28.352    24.322     0.200
    28.368    24.427     0.200
    28.383    25.102     0.200
    28.429    25.651     0.200
    28.465    24.893     0.200
    28.501    24.079     0.200
    28.532    24.383     0.200
    28.570    22.471     0.200
    28.576    25.104     0.200
    28.637    23.728     0.200
    28.669    22.957     0.200
    28.507    25.044     0.200
    28.685    24.208     0.200
    28.734    23.481     0.200
    28.750    24.719     0.200
    28.616    26.042     0.200
    28.784    24.036     0.200
    28.809    24.601     0.200
    28.847    24.569     0.200
    28.854    25.341     0.200
    28.840    23.946     0.200
    28.864    25.012     0.200
    28.911    21.663     0.200
    28.910    23.049     0.200
    28.928    22.952     0.200
    28.932    23.626     0.200
    29.020    22.676     0.200
    29.059    23.439     0.200
    29.043    23.620     0.200
    29.053    23.889     0.200
    29.053    23.327     0.200
    29.075    22.387     0.200
    29.085    22.904     0.200
    29.103    21.520     0.200
    29.103    21.981     0.200
    29.133    22.438     0.200
    29.152    23.003     0.200
    29.156    22.472     0.200
    29.151    22.730     0.200
    29.135    22.934     0.200
    29.175    23.606     0.200
    29.198    22.179     0.200
    29.188    23.206     0.200
    29.204    23.463     0.200
    29.277    23.487     0.200
    29.355    20.792     0.200
    29.362    21.958     0.200
    29.430    21.859     0.200
    29.518    21.654     0.200
    29.521    22.492     0.200
    29.550    21.305     0.200
    29.591    21.276     0.200
    29.616    21.310     0.200
    29.640    21.300     0.200
    29.727    21.450     0.200
    29.740    21.317     0.200
    29.720    22.794     0.200
    29.720    22.011     0.200
    29.770    21.097     0.200
    29.827    19.583     0.200
    29.834    20.940     0.200
    29.915    21.048     0.200
    29.916    20.319     0.200
    29.928    20.322     0.200
    29.946    19.561     0.200
    29.971    20.595     0.200
    29.955    21.774     0.200
    15.659    40.525     0.200
    16.208    40.307     0.200
    16.293    42.488     0.200
    16.293    41.672     0.200
    16.411    39.828     0.200
    16.504    40.078     0.200
    16.568    40.935     0.200
    16.977    40.502     0.200
    16.988    40.485     0.200
    17.151    40.360     0.200
    17.310    40.801     0.200
    17.362    40.499     0.200
    17.641    41.093     0.200
    17.734    40.784     0.200
    17.796    40.881     0.200
    17.995    41.148     0.200
    18.046    40.910     0.200
    18.096    40.751     0.200
    18.282    42.336     0.200
    18.365    38.876     0.200
    18.384    39.723     0.200
    18.579    37.791     0.200
    18.621    39.239     0.200
    18.856    38.793     0.200
    19.078    39.008     0.200
    19.176    37.940     0.200
    19.253    38.670     0.200
    19.269    39.206     0.200
    19.490    39.756     0.200
    19.660    39.075     0.200
    19.765    38.893     0.200
    19.833    39.328     0.200
    19.931    38.816     0.200
    19.933    39.609     0.200
    20.049    39.303     0.200
    20.057    37.605     0.200
    20.073    38.238     0.200
    20.408    37.984     0.200
    20.488    39.054     0.200
    20.520    38.596     0.200
    20.533    38.799     0.200
    20.693    38.486     0.200
    20.728    38.926     0.200
    20.834    37.872     0.200
    20.872    38.665     0.200
    20.874    39.046     0.200
    21.003    37.864     0.200
    21.008    39.183     0.200
    21.008    39.974     0.200
    21.014    38.490     0.200
    21.100    39.667     0.200
    21.113    38.171     0.200
    21.219    40.300     0.200
    21.319    39.061     0.200
    21.330    38.024     0.200
    21.350    38.723     0.200
    21.421    36.608     0.200
    21.458    37.073     0.200
    21.492    37.945     0.200
    21.502    37.022     0.200
    21.547    38.923     0.200
    21.551    38.010     0.200
    21.575    39.959     0.200
    21.584    39.142     0.200
    21.631    35.398     0.200
    21.670    37.147     0.200
    21.713    37.588     0.200
    21.745    39.344     0.200
    21.762    37.470     0.200
    21.813    39.169     0.200
    21.866    34.447     0.200
    21.927    38.961     0.200
    21.995    37.681     0.200
    22.027    37.586     0.200
    22.099    39.410     0.200
    22.099    38.915     0.200
    22.108    38.515     0.200
    22.125    36.417     0.200
    22.127    36.429     0.200
    22.129    34.712     0.200
    22.171    37.904     0.200
    22.207    36.587     0.200
    22.301    34.764     0.200
    22.317    36.925     0.200
    22.356    35.133     0.200
    22.367    36.847     0.200
    22.365    34.926     0.200
    22.371    37.668     0.200
    22.405    36.322     0.200
    22.423    39.317     0.200
    22.454    36.013     0.200
    22.496    37.887     0.200
    22.531    38.536     0.200
    22.636    36.389     0.200
    22.664    35.874     0.200
    22.708    36.303     0.200
    22.731    35.728     0.200
    22.737    35.407     0.200
    22.765    36.058     0.200
    22.784    35.355     0.200
    22.902    37.472     0.200
    22.911    36.384     0.200
    22.921    34.609     0.200
    23.127    37.304     0.200
    23.221    34.865     0.200
    23.284    35.207     0.200
    23.284    35.075     0.200
    23.287    34.812     0.200
    23.306    35.362     0.200
    23.390    34.943     0.200
    23.409    34.030     0.200
    23.510    36.731     0.200
    23.511    34.417     0.200
    23.599    34.902     0.200
    23.664    36.356     0.200
    23.737    34.202     0.200
    23.783    32.368     0.200
    23.809    35.379     0.200
    23.808    34.300     0.200
    23.867    34.159     0.200
    23.867    34.531     0.200
    23.883    34.795     0.200
    23.893    35.915     0.200
    23.904    34.140     0.200
    23.911    34.638     0.200
    23.920    35.622     0.200
    23.925    35.642     0.200
    24.054    33.608     0.200
    24.082    35.000     0.200
    24.133    35.572     0.200
    24.160    34.389     0.200
    24.174    33.323     0.200
    24.249    34.123     0.200
    24.265    33.899     0.200
    24.282    33.950     0.200
    24.311    32.994     0.200
    24.403    34.724     0.200
    24.407    33.132     0.200
    24.409    33.145     0.200
    24.441    34.974     0.200
    24.498    32.810     0.200
    24.542    33.486     0.200
    24.553    31.710     0.200
    24.561    31.641     0.200
    24.586    33.496     0.200
    24.667    32.444     0.200
    24.719    34.778     0.200
    24.724    32.086     0.200
    24.795    32.121     0.200
    24.827    32.431     0.200
    24.920    32.808     0.200
    24.928    32.170     0.200
    25.017    31.846     0.200
    25.046    34.073     0.200
    25.052    32.265     0.200
    25.067    33.880     0.200
    25.114    32.011     0.200
    25.179    32.103     0.200
    25.199    33.411     0.200
    25.229    32.763     0.200
    25.283    32.606     0.200
    25.364    30.987     0.200
    25.429    28.291     0.200
    25.556    30.184     0.200
    25.580    31.178     0.200
    25.596    31.714     0.200
    25.629    30.939     0.200
    25.629    30.727     0.200
    25.632    30.946     0.200
    25.682    30.030     0.200
    25.959    29.492     0.200
    26.067    29.275     0.200
    26.137    29.563     0.200
    26.171    28.588     0.200
    26.214    28.744     0.200
    26.220    29.475     0.200
    26.293    28.436     0.200
    26.306    29.327     0.200
    26.330    29.086     0.200
    26.464    29.122     0.200
    26.557    29.106     0.200
    26.622    27.995     0.200
    26.632    29.633     0.200
    26.782    26.536     0.200
    26.934    25.009     0.200
    26.969    26.873     0.200
    26.969    26.030     0.200
    26.969    26.794     0.200
    26.972    26.928     0.200
    27.015    27.323     0.200
    27.055    26.308     0.200
    27.075    25.882     0.200
    27.086    26.356     0.200
    27.154    29.974     0.200
    27.189    26.100     0.200
    27.415    25.318     0.200
    27.477    25.050     0.200
    27.503    24.996     0.200
    27.745    25.059     0.200
    27.770    24.537     0.200
    27.826    24.538     0.200
    27.832    24.520     0.200
    27.995    23.740     0.200
    27.998    24.018     0.200
    28.223    23.017     0.200
    28.309    23.196     0.200
    28.359    23.338     0.200
    28.639    22.064     0.200
    28.639    22.417     0.200
    29.054    20.084     0.200
    29.130    20.797     0.200
    29.130    20.337     0.200
    29.155    21.229     0.200
    29.155    21.424     0.200
    29.157    20.443     0.200
    29.364    20.793     0.200
    29.542    20.318     0.200
    29.542    19.871     0.200
    29.555    19.226     0.200
    29.612    19.949     0.200
    29.747    19.867     0.200
    29.829    17.925     0.200
    29.850    19.570     0.200
    29.972    18.359     0.200
    29.985    18.774     0.200
    16.267    39.512     0.200
    16.515    40.759     0.200
    16.515    40.256     0.200
    16.598    39.755     0.200
    16.776    39.991     0.200
    16.895    40.294     0.200
    16.998    40.191     0.200
    17.097    40.172     0.200
    17.240    40.540     0.200
    17.356    40.040     0.200
    17.589    40.541     0.200
    17.596    41.005     0.200
    17.746    40.057     0.200
    17.888    41.529     0.200
    17.925    40.373     0.200
    18.072    41.335     0.200
    18.212    40.723     0.200
    18.348    38.233     0.200
    18.425    38.294     0.200
    18.490    38.678     0.200
    18.750    38.899     0.200
    18.791    39.121     0.200
    18.804    38.657     0.200
    18.914    38.451     0.200
    18.958    39.547     0.200
    18.968    38.434     0.200
    18.996    38.899     0.200
    19.182    38.726     0.200
    19.221    37.946     0.200
    19.381    38.658     0.200
    19.385    38.594     0.200
    19.417    39.080     0.200
    19.524    38.066     0.200
    19.536    38.062     0.200
    19.567    38.445     0.200
    19.648    38.266     0.200
    19.660    37.550     0.200
    19.752    36.547     0.200
    19.759    38.523     0.200
    19.883    38.502     0.200
    20.023    39.216     0.200
    20.073    38.836     0.200
    20.083    38.105     0.200
    20.110    37.695     0.200
    20.198    37.200     0.200
    20.216    39.055     0.200
    20.226    37.592     0.200
    20.258    37.570     0.200
    20.266    37.699     0.200
    20.440    38.847     0.200
    20.498    37.773     0.200
    20.499    37.014     0.200
    20.600    38.450     0.200
    20.663    38.316     0.200
    20.703    37.059     0.200
    20.723    39.143     0.200
    20.693    39.682     0.200
    20.794    36.937     0.200
    20.848    38.600     0.200
    20.902    37.111     0.200
    20.918    37.430     0.200
    20.953    38.565     0.200
    20.999    35.778     0.200
    21.050    38.311     0.200
    21.049    38.800     0.200
    21.112    37.656     0.200
    21.161    39.208     0.200
    21.208    38.303     0.200
    21.242    37.781     0.200
    21.310    39.288     0.200
    21.478    38.288     0.200
    21.484    36.539     0.200
    21.494    38.783     0.200
    21.513    35.651     0.200
    21.560    37.231     0.200
    21.561    35.483     0.200
    21.581    37.000     0.200
    21.626    38.179     0.200
    21.659    38.926     0.200
    21.668    38.845     0.200
    21.696    38.529     0.200
    21.706    37.408     0.200
    21.706    37.549     0.200
    21.720    37.763     0.200
    21.792    36.809     0.200
    21.800    34.352     0.200
    21.902    37.052     0.200
    21.906    37.465     0.200
    21.922    34.388     0.200
    21.958    38.324     0.200
    22.015    38.470     0.200
    22.032    38.009     0.200
    22.143    38.214     0.200
    22.157    37.382     0.200
    22.172    38.262     0.200
    22.182    35.951     0.200
    22.203    36.341     0.200
    22.231    37.009     0.200
    22.261    34.474     0.200
    22.303    36.136     0.200
    22.305    37.655     0.200
    22.443    37.721     0.200
    22.482    32.992     0.200
    22.478    37.764     0.200
    22.496    36.686     0.200
    22.509    35.675     0.200
    22.522    37.764     0.200
    22.526    37.422     0.200
    22.526    37.773     0.200
    22.567    36.865     0.200
    22.575    36.382     0.200
    22.589    35.859     0.200
    22.643    33.628     0.200
    22.647    36.346     0.200
    22.716    35.448     0.200
    22.796    35.678     0.200
    22.807    35.641     0.200
    22.803    38.172     0.200
    22.822    33.399     0.200
    22.875    34.681     0.200
    22.890    37.172     0.200
    22.917    35.906     0.200
    22.940    36.023     0.200
    22.970    37.323     0.200
    22.999    35.152     0.200
    23.041    35.740     0.200
    23.110    35.703     0.200
    23.251    35.838     0.200
    23.252    36.900     0.200
    23.306    36.579     0.200
    23.335    34.326     0.200
    23.376    32.998     0.200
    23.406    34.703     0.200
    23.394    36.551     0.200
    23.443    32.613     0.200
    23.434    36.410     0.200
    23.456    34.068     0.200
    23.455    34.783     0.200
    23.476    34.346     0.200
    23.514    36.249     0.200
    23.556    35.259     0.200
    23.619    34.067     0.200
    23.613    35.739     0.200
    23.683    35.802     0.200
    23.722    35.965     0.200
    23.734    35.384     0.200
    23.786    34.653     0.200
    23.786    33.556     0.200
    23.847    32.465     0.200
    23.863    34.095     0.200
    23.886    35.614     0.200
    23.913    35.695     0.200
    23.913    35.538     0.200
    23.919    35.219     0.200
    23.948    33.904     0.200
    23.951    33.454     0.200
    23.950    31.206     0.200
    23.964    35.238     0.200
    24.044    33.375     0.200
    24.046    32.335     0.200
    24.046    33.280     0.200
    24.049    34.973     0.200
    24.080    33.771     0.200
    24.101    33.698     0.200
    24.101    33.862     0.200
    24.110    35.495     0.200
    24.117    35.112     0.200
    24.139    33.311     0.200
    24.161    34.327     0.200
    24.166    32.131     0.200
    24.136    35.073     0.200
    24.194    34.118     0.200
    24.200    34.207     0.200
    24.214    33.987     0.200
    24.227    31.027     0.200
    24.320    34.518     0.200
    24.337    33.576     0.200
    24.385    32.085     0.200
    24.445    31.893     0.200
    24.500    32.688     0.200
    24.508    33.316     0.200
    24.528    32.858     0.200
    24.543    33.069     0.200
    24.545    34.085     0.200
    24.590    35.014     0.200
    24.590    34.139     0.200
    24.654    32.028     0.200
    24.665    32.109     0.200
    24.735    32.495     0.200
    24.742    32.816     0.200
    24.745    32.186     0.200
    24.776    33.235     0.200
    24.788    33.370     0.200
    24.833    31.649     0.200
    24.841    33.406     0.200
    24.889    31.850     0.200
    24.935    30.463     0.200
    24.997    31.710     0.200
    24.993    33.261     0.200
    25.041    31.423     0.200
    25.056    32.850     0.200
    25.105    32.779     0.200
    25.138    32.392     0.200
    25.138    33.064     0.200
    25.149    31.552     0.200
    25.187    29.559     0.200
    25.200    30.834     0.200
    25.297    30.934     0.200
    25.301    33.578     0.200
    25.442    30.219     0.200
    25.448    31.590     0.200
    25.449    32.192     0.200
    25.410    29.977     0.200
    25.451    31.949     0.200
    25.468    29.737     0.200
    25.504    28.459     0.200
    25.510    30.188     0.200
    25.516    30.485     0.200
    25.565    31.342     0.200
    25.596    29.903     0.200
    25.624    31.687     0.200
    25.665    29.118     0.200
    25.720    30.100     0.200
    25.752    29.805     0.200
    25.765    27.921     0.200
    25.810    29.087     0.200
    25.838    31.290     0.200
    25.852    28.805     0.200
    25.863    28.809     0.200
    25.815    30.362     0.200
    25.880    28.959     0.200
    25.891    28.722     0.200
    25.893    29.888     0.200
    25.893    30.072     0.200
    25.937    29.763     0.200
    25.969    30.625     0.200
    26.053    28.114     0.200
    26.115    28.570     0.200
    26.121    28.376     0.200
    26.274    27.885     0.200
    26.278    28.248     0.200
    26.336    27.820     0.200
    26.355    27.294     0.200
    26.466    27.300     0.200
    26.473    27.917     0.200
    26.500    26.864     0.200
    26.589    26.320     0.200
    26.567    29.965     0.200
    26.631    26.555     0.200
    26.595    29.328     0.200
    26.690    27.040     0.200
    26.688    27.262     0.200
    26.717    28.534     0.200
    26.736    26.211     0.200
    26.742    29.315     0.200
    26.856    24.917     0.200
    26.894    26.284     0.200
    26.911    25.826     0.200
    26.928    28.258     0.200
    26.974    26.841     0.200
    26.950    28.756     0.200
    27.005    28.240     0.200
    27.011    26.030     0.200
    27.016    25.602     0.200
    26.998    27.264     0.200
    27.063    25.574     0.200
    27.146    25.717     0.200
    27.146    25.609     0.200
    27.159    26.054     0.200
    27.189    25.908     0.200
    27.204    25.390     0.200
    27.259    25.746     0.200
    27.320    25.682     0.200
    27.332    23.386     0.200
    27.335    25.635     0.200
    27.344    26.113     0.200
    27.344    26.304     0.200
    27.424    24.247     0.200
    27.453    23.469     0.200
    27.482    24.243     0.200
    27.519    24.762     0.200
    27.528    24.754     0.200
    27.482    28.427     0.200
    27.482    28.610     0.200
    27.514    25.423     0.200
    27.587    24.778     0.200
    27.547    25.977     0.200
    27.605    24.480     0.200
    27.649    24.907     0.200
    27.668    26.168     0.200
    27.684    24.291     0.200
    27.798    24.255     0.200
    27.756    25.392     0.200
    27.877    24.928     0.200
    27.912    24.068     0.200
    27.974    24.055     0.200
    27.984    24.682     0.200
    28.002    22.539     0.200
    28.018    23.742     0.200
    27.980    25.098     0.200
    28.058    23.666     0.200
    28.068    22.710     0.200
    28.073    23.668     0.200
    28.086    23.327     0.200
    28.122    23.732     0.200
    28.159    22.466     0.200
    28.183    23.202     0.200
    28.186    22.872     0.200
    28.193    23.347     0.200
    28.204    23.284     0.200
    28.205    23.179     0.200
    28.217    22.850     0.200
    28.341    22.270     0.200
    28.368    22.922     0.200
    28.382    22.383     0.200
    28.397    22.019     0.200
    28.416    24.139     0.200
    28.493    22.513     0.200
    28.574    21.776     0.200
    28.579    22.298     0.200
    28.623    21.219     0.200
    28.626    21.001     0.200
    28.714    21.743     0.200
    28.782    20.566     0.200
    28.790    21.625     0.200
    28.795    18.899     0.200
    28.796    21.225     0.200
    28.876    21.646     0.200
    28.932    21.655     0.200
    28.949    20.315     0.200
    28.959    20.606     0.200
    29.043    21.623     0.200
    29.133    20.965     0.200
    29.136    19.682     0.200
    29.138    19.461     0.200
    29.143    19.456     0.200
    29.146    22.012     0.200
    29.174    20.688     0.200
    29.282    19.759     0.200
    29.291    21.086     0.200
    29.322    18.459     0.200
    29.281    22.277     0.200
    29.387    20.565     0.200
    29.403    20.207     0.200
    29.404    20.084     0.200
    29.511    18.403     0.200
    29.536    19.128     0.200
    29.571    20.447     0.200
    29.604    19.671     0.200
    29.684    18.458     0.200
    29.738    19.721     0.200
    29.813    19.006     0.200
    29.827    17.778     0.200
    29.834    19.695     0.200
    29.868    19.041     0.200
    29.886    17.293     0.200
    29.902    17.779     0.200
    29.908    17.615     0.200
    29.918    17.020     0.200
    29.968    19.003     0.200
    29.991    19.195     0.200
    14.966    39.524     0.200
    15.526    38.763     0.200
    16.312    39.526     0.200
    16.692    40.567     0.200
    16.795    40.248     0.200
    17.037    39.408     0.200
    17.386    39.133     0.200
    17.393    40.372     0.200
    17.685    40.766     0.200
    18.099    40.992     0.200
    18.222    37.737     0.200
    18.249    37.420     0.200
    18.757    38.976     0.200
    18.787    39.259     0.200
    18.985    38.026     0.200
    19.054    38.106     0.200
    19.182    37.134     0.200
    19.217    37.081     0.200
    19.552    35.423     0.200
    19.562    37.991     0.200
    19.615    38.050     0.200
    19.821    37.451     0.200
    19.926    37.123     0.200
    20.016    37.614     0.200
    20.055    36.603     0.200
    20.066    36.480     0.200
    20.073    36.736     0.200
    20.210    37.708     0.200
    20.302    36.568     0.200
    20.403    36.663     0.200
    20.447    36.884     0.200
    20.464    36.925     0.200
    20.480    36.699     0.200
    20.512    36.913     0.200
    20.521    37.146     0.200
    20.601    34.747     0.200
    20.723    36.106     0.200
    20.750    37.438     0.200
    20.849    37.021     0.200
    20.915    36.182     0.200
    21.006    36.523     0.200
    21.044    36.573     0.200
    21.107    36.470     0.200
    21.107    37.626     0.200
    21.117    35.693     0.200
    21.205    36.933     0.200
    21.252    35.323     0.200
    21.290    35.956     0.200
    21.291    35.864     0.200
    21.363    35.583     0.200
    21.387    36.160     0.200
    21.429    33.148     0.200
    21.503    36.359     0.200
    21.503    36.648     0.200
    21.519    36.616     0.200
    21.594    35.564     0.200
    21.639    35.633     0.200
    21.673    33.152     0.200
    21.704    36.510     0.200
    21.703    36.281     0.200
    21.809    32.898     0.200
    21.943    38.936     0.200
    21.970    38.565     0.200
    22.029    36.179     0.200
    22.087    33.856     0.200
    22.275    37.199     0.200
    22.295    35.704     0.200
    22.366    36.057     0.200
    22.373    35.130     0.200
    22.444    36.293     0.200
    22.503    34.792     0.200
    22.524    35.465     0.200
    22.595    35.272     0.200
    22.614    34.490     0.200
    22.691    38.057     0.200
    22.715    33.743     0.200
    22.910    35.229     0.200
    22.992    32.109     0.200
    23.050    34.885     0.200
    23.107    36.847     0.200
    23.209    33.203     0.200
    23.209    34.196     0.200
    23.271    31.313     0.200
    23.271    31.719     0.200
    23.310    32.631     0.200
    23.584    33.507     0.200
    23.665    33.200     0.200
    23.683    35.513     0.200
    23.712    32.481     0.200
    23.749    33.282     0.200
    23.760    33.507     0.200
    23.813    34.123     0.200
    23.856    33.421     0.200
    23.878    33.274     0.200
    23.898    33.725     0.200
    23.898    34.092     0.200
    23.990    34.181     0.200
    23.997    32.938     0.200
    24.058    31.253     0.200
    24.136    32.952     0.200
    24.269    33.072     0.200
    24.305    33.224     0.200
    24.331    31.921     0.200
    24.534    32.512     0.200
    24.542    32.852     0.200
    24.797    31.450     0.200
    24.804    29.159     0.200
    25.040    28.474     0.200
    25.094    30.392     0.200
    25.311    31.396     0.200
    25.313    30.890     0.200
    25.339    28.118     0.200
    25.362    31.218     0.200
    25.689    29.501     0.200
    25.689    31.267     0.200
    25.921    28.536     0.200
    26.267    28.032     0.200
    26.257    25.925     0.200
    26.272    28.103     0.200
    26.680    24.953     0.200
    26.727    27.547     0.200
    26.804    27.141     0.200
    26.945    26.070     0.200
    26.945    25.835     0.200
    26.945    24.946     0.200
    27.117    25.822     0.200
    27.136    25.187     0.200
    27.211    22.670     0.200
    27.407    24.156     0.200
    27.446    24.963     0.200
    27.483    24.075     0.200
    27.713    23.891     0.200
    27.993    22.832     0.200
    28.016    22.946     0.200
    28.068    20.941     0.200
    28.144    22.294     0.200
    28.181    22.495     0.200
    28.373    21.799     0.200
    28.759    20.668     0.200
    28.943    19.829     0.200
    29.201    20.461     0.200
    29.609    19.326     0.200
    29.703    18.097     0.200
    29.766    18.264     0.200
    29.789    18.586     0.200
    29.926    17.401     0.200
    15.748    39.136     0.200
    15.748    39.444     0.200
    15.644    43.289     0.200
    16.028    40.799     0.200
    16.724    43.472     0.200
    16.983    41.712     0.200
    17.338    41.458     0.200
    18.122    39.477     0.200
    18.122    39.707     0.200
    18.137    39.926     0.200
    18.270    39.477     0.200
    18.323    39.751     0.200
    18.324    39.941     0.200
    18.406    41.878     0.200
    18.428    41.859     0.200
    18.428    42.519     0.200
    18.452    39.583     0.200
    18.452    40.465     0.200
    18.459    39.886     0.200
    18.476    41.942     0.200
    18.476    42.430     0.200
    18.532    39.566     0.200
    18.557    41.937     0.200
    18.651    38.744     0.200
    18.666    38.380     0.200
    18.859    38.671     0.200
    19.083    38.784     0.200
    19.209    38.861     0.200
    19.273    38.493     0.200
    19.354    39.003     0.200
    19.438    38.774     0.200
    19.464    38.924     0.200
    19.464    39.049     0.200
    19.479    38.981     0.200
    19.562    38.141     0.200
    19.585    38.365     0.200
    19.619    38.365     0.200
    19.664    38.539     0.200
    19.679    38.470     0.200
    19.711    38.729     0.200
    19.791    39.311     0.200
    19.835    38.289     0.200
    19.886    38.177     0.200
    19.951    37.791     0.200
    20.067    38.284     0.200
    20.064    37.719     0.200
    20.123    37.989     0.200
    20.243    37.796     0.200
    20.258    38.399     0.200
    20.269    38.068     0.200
    20.276    37.939     0.200
    20.328    38.517     0.200
    20.401    37.926     0.200
    20.469    37.829     0.200
    20.623    37.931     0.200
    20.623    38.345     0.200
    20.684    36.852     0.200
    20.717    36.784     0.200
    20.781    37.224     0.200
    20.847    37.606     0.200
    20.858    37.995     0.200
    20.905    37.318     0.200
    20.956    37.273     0.200
    21.022    37.040     0.200
    21.162    37.001     0.200
    21.238    36.739     0.200
    21.109    39.808     0.200
    21.234    40.287     0.200
    21.234    40.553     0.200
    21.320    36.692     0.200
    21.370    36.466     0.200
    21.402    40.572     0.200
    21.402    40.799     0.200
    21.493    36.865     0.200
    21.517    36.823     0.200
    21.518    38.814     0.200
    21.518    38.700     0.200
    21.539    36.902     0.200
    21.555    36.018     0.200
    21.574    36.466     0.200
    21.570    39.430     0.200
    21.570    39.934     0.200
    21.648    36.454     0.200
    21.666    36.243     0.200
    21.669    36.470     0.200
    21.696    37.937     0.200
    21.763    36.594     0.200
    21.737    39.876     0.200
    21.776    39.065     0.200
    21.810    38.484     0.200
    21.810    38.832     0.200
    21.830    38.975     0.200
    21.859    35.716     0.200
    21.907    36.484     0.200
    21.934    35.582     0.200
    21.934    35.754     0.200
    21.951    36.924     0.200
    21.951    35.885     0.200
    22.043    36.212     0.200
    22.054    35.682     0.200
    22.031    38.916     0.200
    22.083    39.198     0.200
    22.146    36.294     0.200
    22.097    40.619     0.200
    22.182    36.037     0.200
    22.189    36.084     0.200
    22.216    35.647     0.200
    22.218    38.933     0.200
    22.255    39.587     0.200
    22.303    37.004     0.200
    22.303    37.219     0.200
    22.379    35.440     0.200
    22.392    35.686     0.200
    22.392    36.096     0.200
    22.395    35.493     0.200
    22.384    38.340     0.200
    22.472    35.479     0.200
    22.508    38.547     0.200
    22.570    39.215     0.200
    22.634    35.632     0.200
    22.624    37.197     0.200
    22.624    37.076     0.200
    22.595    38.841     0.200
    22.596    37.997     0.200
    22.596    39.005     0.200
    22.596    39.552     0.200
    22.712    35.064     0.200
    22.775    35.662     0.200
    22.777    37.477     0.200
    22.813    35.397     0.200
    22.795    37.600     0.200
    22.880    34.905     0.200
    22.929    34.430     0.200
    22.882    39.893     0.200
    22.953    34.915     0.200
    22.967    37.889     0.200
    23.022    36.940     0.200
    23.049    36.465     0.200
    23.078    34.649     0.200
    23.093    34.204     0.200
    23.037    37.315     0.200
    23.183    34.360     0.200
    23.190    37.083     0.200
    23.221    36.959     0.200
    23.277    34.813     0.200
    23.288    34.398     0.200
    23.295    37.804     0.200
    23.370    34.231     0.200
    23.322    37.940     0.200
    23.425    34.436     0.200
    23.381    37.821     0.200
    23.456    34.436     0.200
    23.480    37.613     0.200
    23.507    34.302     0.200
    23.522    35.847     0.200
    23.577    34.966     0.200
    23.463    38.168     0.200
    23.607    33.881     0.200
    23.615    33.661     0.200
    23.621    33.955     0.200
    23.592    37.559     0.200
    23.676    36.656     0.200
    23.781    32.997     0.200
    23.751    37.144     0.200
    23.795    37.106     0.200
    23.861    32.888     0.200
    23.799    36.575     0.200
    23.889    37.108     0.200
    23.925    34.197     0.200
    23.906    35.556     0.200
    23.909    36.001     0.200
    23.946    33.983     0.200
    23.964    34.128     0.200
    23.988    36.723     0.200
    23.988    37.512     0.200
    23.987    37.626     0.200
    24.085    34.568     0.200
    24.031    36.690     0.200
    24.123    33.368     0.200
    24.169    34.497     0.200
    24.169    35.442     0.200
    24.127    35.703     0.200
    24.182    32.784     0.200
    24.209    32.557     0.200
    24.203    35.101     0.200
    24.177    36.214     0.200
    24.240    33.031     0.200
    24.286    32.760     0.200
    24.297    33.446     0.200
    24.290    35.585     0.200
    24.346    32.448     0.200
    24.361    32.859     0.200
    24.305    35.227     0.200
    24.390    36.008     0.200
    24.446    35.074     0.200
    24.446    35.187     0.200
    24.484    33.934     0.200
    24.513    33.043     0.200
    24.513    33.489     0.200
    24.556    32.246     0.200
    24.574    33.170     0.200
    24.575    34.542     0.200
    24.544    35.059     0.200
    24.602    34.121     0.200
    24.609    34.755     0.200
    24.644    34.088     0.200
    24.644    33.709     0.200
    24.618    35.013     0.200
    24.657    34.863     0.200
    24.774    32.217     0.200
    24.787    31.505     0.200
    24.794    32.070     0.200
    24.831    32.034     0.200
    24.655    35.441     0.200
    24.839    33.955     0.200
    24.866    34.685     0.200
    24.935    31.359     0.200
    24.899    34.438     0.200
    24.899    35.086     0.200
    24.949    32.946     0.200
    24.917    34.470     0.200
    25.000    31.528     0.200
    25.037    33.760     0.200
    25.070    31.688     0.200
    25.062    34.052     0.200
    25.167    31.064     0.200
    25.175    31.257     0.200
    25.132    33.956     0.200
    25.169    32.345     0.200
    25.254    30.987     0.200
    25.210    33.510     0.200
    25.210    34.350     0.200
    25.318    31.671     0.200
    25.322    30.368     0.200
    25.322    30.790     0.200
    25.379    30.828     0.200
    25.397    32.426     0.200
    25.486    30.103     0.200
    25.504    32.405     0.200
    25.528    33.223     0.200
    25.517    32.912     0.200
    25.589    30.297     0.200
    25.637    29.907     0.200
    25.652    32.051     0.200
    25.652    32.336     0.200
    25.753    28.715     0.200
    25.766    29.888     0.200
    25.807    30.440     0.200
    25.831    29.811     0.200
    25.835    29.511     0.200
    25.812    32.321     0.200
    25.854    31.573     0.200
    25.899    28.415     0.200
    25.899    29.665     0.200
    25.911    28.520     0.200
    25.904    32.264     0.200
    25.994    28.689     0.200
    25.991    31.266     0.200
    26.038    31.092     0.200
    26.045    31.277     0.200
    26.124    28.561     0.200
    26.147    28.842     0.200
    26.301    30.468     0.200
    26.398    27.034     0.200
    26.434    27.648     0.200
    26.436    27.149     0.200
    26.457    28.361     0.200
    26.451    28.908     0.200
    26.451    29.478     0.200
    26.463    29.318     0.200
    26.484    28.179     0.200
    26.545    28.163     0.200
    26.547    27.440     0.200
    26.547    27.277     0.200
    26.592    28.822     0.200
    26.600    27.221     0.200
    26.608    28.853     0.200
    26.706    29.564     0.200
    26.762    26.019     0.200
    26.760    28.230     0.200
    26.760    27.394     0.200
    26.771    28.736     0.200
    26.792    28.539     0.200
    26.556    30.891     0.200
    26.556    31.359     0.200
    26.840    25.902     0.200
    26.794    30.413     0.200
    26.676    29.960     0.200
    26.942    25.727     0.200
    26.986    26.349     0.200
    26.986    26.568     0.200
    27.047    26.551     0.200
    27.085    28.824     0.200
    27.085    28.820     0.200
    27.141    24.409     0.200
    27.160    26.280     0.200
    27.163    26.803     0.200
    27.038    28.735     0.200
    27.177    26.041     0.200
    27.220    25.511     0.200
    27.246    26.788     0.200
    27.256    26.629     0.200
    27.256    27.067     0.200
    27.256    26.927     0.200
    27.256    26.927     0.200
    27.273    25.026     0.200
    27.279    27.270     0.200
    27.284    25.317     0.200
    27.301    26.744     0.200
    27.357    25.209     0.200
    27.375    26.582     0.200
    27.360    27.364     0.200
    27.437    27.756     0.200
    27.465    25.034     0.200
    27.509    25.731     0.200
    27.509    26.325     0.200
    27.563    23.588     0.200
    27.581    24.475     0.200
    27.628    24.083     0.200
    27.653    23.447     0.200
    27.697    24.601     0.200
    27.693    25.767     0.200
    27.474    30.061     0.200
    27.763    24.030     0.200
    27.750    27.636     0.200
    27.832    24.741     0.200
    27.842    24.999     0.200
    27.864    22.956     0.200
    27.876    25.056     0.200
    27.918    23.477     0.200
    27.956    25.244     0.200
    27.987    23.003     0.200
    27.952    26.050     0.200
    28.121    22.601     0.200
    28.122    22.811     0.200
    28.166    24.659     0.200
    28.228    23.529     0.200
    28.230    24.808     0.200
    28.264    22.245     0.200
    28.284    22.458     0.200
    28.287    23.363     0.200
    28.326    22.600     0.200
    28.325    24.315     0.200
    28.135    23.642     0.200
    28.382    22.384     0.200
    28.443    22.066     0.200
    28.452    21.628     0.200
    28.490    23.490     0.200
    28.505    23.350     0.200
    28.536    22.985     0.200
    28.570    21.523     0.200
    28.561    22.550     0.200
    28.577    22.725     0.200
    28.677    21.185     0.200
    28.682    23.405     0.200
    28.791    20.722     0.200
    28.786    23.330     0.200
    28.874    21.395     0.200
    28.928    20.680     0.200
    28.924    22.095     0.200
    28.914    23.090     0.200
    28.966    20.950     0.200
    28.972    21.028     0.200
    28.997    21.269     0.200
    29.014    20.510     0.200
    29.041    22.230     0.200
    29.041    23.277     0.200
    29.077    19.674     0.200
    29.074    21.220     0.200
    29.095    21.680     0.200
    29.105    19.816     0.200
    29.156    19.638     0.200
    29.153    23.642     0.200
    29.164    23.739     0.200
    29.234    21.071     0.200
    29.295    19.601     0.200
    29.395    20.942     0.200
    29.395    21.055     0.200
    29.400    21.850     0.200
    29.438    18.791     0.200
    29.459    19.456     0.200
    29.299    22.041     0.200
    29.299    22.654     0.200
    29.504    21.558     0.200
    29.606    19.711     0.200
    29.640    18.905     0.200
    29.630    22.376     0.200
    29.679    19.533     0.200
    29.678    21.601     0.200
    29.698    19.485     0.200
    29.700    19.135     0.200
    29.720    19.237     0.200
    29.725    18.259     0.200
    29.788    17.895     0.200
    29.800    18.021     0.200
    29.800    19.475     0.200
    29.876    17.870     0.200
    29.906    18.174     0.200
    29.910    20.343     0.200
    15.453    40.323     0.200
    15.769    40.890     0.200
    16.138    41.086     0.200
    16.569    39.685     0.200
    17.428    40.584     0.200
    17.718    40.432     0.200
    17.718    39.897     0.200
    18.130    36.459     0.200
    18.223    37.853     0.200
    18.252    38.093     0.200
    18.269    38.292     0.200
    18.269    38.456     0.200
    18.300    36.437     0.200
    18.330    37.691     0.200
    18.356    37.411     0.200
    18.356    38.989     0.200
    18.435    38.210     0.200
    18.460    38.287     0.200
    18.460    38.619     0.200
    18.482    36.993     0.200
    18.485    38.359     0.200
    18.500    37.343     0.200
    18.519    37.276     0.200
    18.523    37.111     0.200
    18.586    38.334     0.200
    18.658    37.282     0.200
    18.669    38.184     0.200
    18.824    37.841     0.200
    18.885    38.073     0.200
    18.922    38.607     0.200
    18.936    37.939     0.200
    18.993    37.783     0.200
    19.027    38.091     0.200
    19.044    37.567     0.200
    19.050    37.314     0.200
    19.069    37.741     0.200
    19.069    37.866     0.200
    19.094    37.883     0.200
    19.157    37.773     0.200
    19.286    37.392     0.200
    19.286    37.418     0.200
    19.297    37.413     0.200
    19.297    37.530     0.200
    19.306    37.714     0.200
    19.359    36.935     0.200
    19.367    37.513     0.200
    19.385    37.639     0.200
    19.427    36.843     0.200
    19.436    37.014     0.200
    19.460    37.037     0.200
    19.579    38.024     0.200
    19.585    37.368     0.200
    19.614    35.870     0.200
    19.641    37.025     0.200
    19.656    37.257     0.200
    19.668    36.955     0.200
    19.668    37.209     0.200
    19.737    37.429     0.200
    19.739    36.983     0.200
    19.780    36.823     0.200
    19.876    36.322     0.200
    19.954    36.699     0.200
    20.026    36.514     0.200
    20.143    36.834     0.200
    20.151    36.785     0.200
    20.151    37.320     0.200
    20.216    36.579     0.200
    20.256    37.059     0.200
    20.270    36.472     0.200
    20.286    36.804     0.200
    20.378    36.916     0.200
    20.423    36.234     0.200
    20.609    35.752     0.200
    20.623    35.805     0.200
    20.784    35.962     0.200
    20.802    36.123     0.200
    20.897    36.248     0.200
    20.933    38.384     0.200
    20.933    37.958     0.200
    20.951    35.674     0.200
    20.993    35.568     0.200
    21.093    35.752     0.200
    21.111    35.404     0.200
    21.247    35.222     0.200
    21.270    34.991     0.200
    21.309    35.461     0.200
    21.374    38.651     0.200
    21.439    35.289     0.200
    21.441    35.889     0.200
    21.516    35.876     0.200
    21.525    35.387     0.200
    21.540    35.545     0.200
    21.612    35.360     0.200
    21.618    35.220     0.200
    21.640    35.119     0.200
    21.650    34.411     0.200
    21.710    35.343     0.200
    21.713    34.745     0.200
    21.762    38.429     0.200
    21.762    38.308     0.200
    21.759    36.831     0.200
    21.759    36.640     0.200
    21.790    34.365     0.200
    21.819    38.276     0.200
    21.819    38.670     0.200
    22.024    34.916     0.200
    22.024    35.748     0.200
    22.080    37.831     0.200
    22.097    34.294     0.200
    22.105    36.950     0.200
    22.105    37.122     0.200
    22.134    37.028     0.200
    22.134    36.903     0.200
    22.176    34.550     0.200
    22.186    34.219     0.200
    22.186    34.916     0.200
    22.209    34.591     0.200
    22.240    34.339     0.200
    22.269    37.110     0.200
    22.283    37.945     0.200
    22.348    33.766     0.200
    22.378    34.416     0.200
    22.397    33.382     0.200
    22.457    35.188     0.200
    22.457    36.091     0.200
    22.553    32.648     0.200
    22.558    37.372     0.200
    22.585    33.307     0.200
    22.615    33.218     0.200
    22.638    37.343     0.200
    22.651    34.133     0.200
    22.660    37.068     0.200
    22.709    34.876     0.200
    22.728    37.133     0.200
    22.731    36.787     0.200
    22.806    33.779     0.200
    22.816    33.331     0.200
    22.817    34.026     0.200
    22.844    35.190     0.200
    22.844    36.276     0.200
    22.852    33.668     0.200
    22.956    32.856     0.200
    22.989    37.034     0.200
    22.994    35.065     0.200
    23.028    32.914     0.200
    23.073    36.633     0.200
    23.087    33.950     0.200
    23.110    32.387     0.200
    23.123    36.629     0.200
    23.122    35.941     0.200
    23.128    32.948     0.200
    23.128    33.573     0.200
    23.139    35.790     0.200
    23.139    37.137     0.200
    23.139    36.629     0.200
    23.276    32.139     0.200
    23.282    34.671     0.200
    23.293    33.177     0.200
    23.320    33.318     0.200
    23.350    33.361     0.200
    23.369    34.431     0.200
    23.412    34.155     0.200
    23.419    32.292     0.200
    23.448    32.688     0.200
    23.458    33.041     0.200
    23.476    36.140     0.200
    23.475    31.918     0.200
    23.512    34.933     0.200
    23.562    32.053     0.200
    23.590    36.168     0.200
    23.594    32.289     0.200
    23.614    35.874     0.200
    23.707    31.393     0.200
    23.715    35.615     0.200
    23.746    34.087     0.200
    23.770    31.560     0.200
    23.836    36.453     0.200
    23.849    31.921     0.200
    23.860    36.083     0.200
    23.888    32.742     0.200
    23.899    35.581     0.200
    23.908    34.873     0.200
    23.931    32.320     0.200
    23.959    32.338     0.200
    23.960    32.511     0.200
    24.016    32.410     0.200
    24.046    34.372     0.200
    24.094    37.002     0.200
    24.069    31.000     0.200
    24.077    35.233     0.200
    24.081    32.283     0.200
    24.078    32.074     0.200
    24.079    31.052     0.200
    24.094    35.062     0.200
    24.113    32.017     0.200
    24.237    30.861     0.200
    24.249    34.284     0.200
    24.281    34.322     0.200
    24.278    30.707     0.200
    24.299    34.360     0.200
    24.299    32.740     0.200
    24.323    34.022     0.200
    24.435    34.168     0.200
    24.465    30.795     0.200
    24.469    33.773     0.200
    24.505    34.536     0.200
    24.505    33.899     0.200
    24.540    33.790     0.200
    24.536    32.336     0.200
    24.546    32.716     0.200
    24.587    35.683     0.200
    24.607    31.361     0.200
    24.607    31.552     0.200
    24.620    33.129     0.200
    24.626    33.328     0.200
    24.686    34.930     0.200
    24.675    33.215     0.200
    24.679    30.328     0.200
    24.728    32.198     0.200
    24.728    32.655     0.200
    24.734    33.511     0.200
    24.768    30.858     0.200
    24.803    30.557     0.200
    24.803    30.343     0.200
    24.807    30.379     0.200
    24.867    31.857     0.200
    24.867    31.979     0.200
    24.885    29.829     0.200
    24.893    31.913     0.200
    24.906    32.234     0.200
    24.931    32.484     0.200
    24.932    30.038     0.200
    24.944    31.899     0.200
    24.963    32.278     0.200
    25.032    32.481     0.200
    25.063    35.463     0.200
    25.079    29.111     0.200
    25.105    32.266     0.200
    25.112    32.308     0.200
    25.137    29.320     0.200
    25.137    29.480     0.200
    25.145    32.156     0.200
    25.158    31.383     0.200
    25.184    31.780     0.200
    25.205    29.700     0.200
    25.212    31.904     0.200
    25.212    32.618     0.200
    25.244    29.256     0.200
    25.364    31.548     0.200
    25.367    29.948     0.200
    25.379    31.975     0.200
    25.379    31.698     0.200
    25.379    31.473     0.200
    25.391    28.803     0.200
    25.415    31.289     0.200
    25.424    31.315     0.200
    25.430    31.522     0.200
    25.458    28.782     0.200
    25.540    27.895     0.200
    25.553    28.773     0.200
    25.609    31.235     0.200
    25.644    30.609     0.200
    25.666    28.440     0.200
    25.684    27.720     0.200
    25.738    29.195     0.200
    25.744    31.111     0.200
    25.744    30.743     0.200
    25.814    28.537     0.200
    25.823    27.062     0.200
    25.842    27.872     0.200
    25.895    31.401     0.200
    25.895    29.041     0.200
    25.860    28.127     0.200
    25.866    30.010     0.200
    25.874    28.674     0.200
    25.931    31.910     0.200
    25.936    30.616     0.200
    25.959    29.629     0.200
    25.996    33.616     0.200
    25.981    26.962     0.200
    26.024    30.070     0.200
    26.080    29.900     0.200
    26.078    27.542     0.200
    26.092    26.377     0.200
    26.099    29.922     0.200
    26.099    29.457     0.200
    26.096    26.322     0.200
    26.196    29.089     0.200
    26.233    29.584     0.200
    26.275    29.159     0.200
    26.330    25.287     0.200
    26.347    27.217     0.200
    26.348    24.693     0.200
    26.363    28.732     0.200
    26.462    29.382     0.200
    26.482    26.043     0.200
    26.522    26.223     0.200
    26.554    25.500     0.200
    26.552    27.324     0.200
    26.555    25.383     0.200
    26.575    26.000     0.200
    26.584    27.548     0.200
    26.586    25.621     0.200
    26.628    26.353     0.200
    26.636    28.046     0.200
    26.672    26.651     0.200
    26.672    27.006     0.200
    26.695    26.474     0.200
    26.732    27.582     0.200
    26.732    24.573     0.200
    26.752    27.028     0.200
    26.804    28.301     0.200
    26.790    24.246     0.200
    26.875    24.473     0.200
    26.908    29.479     0.200
    26.919    26.368     0.200
    27.000    28.887     0.200
    26.974    26.832     0.200
    26.988    24.310     0.200
    27.051    23.821     0.200
    27.072    26.739     0.200
    27.107    23.835     0.200
    27.110    24.284     0.200
    27.146    27.176     0.200
    27.152    24.145     0.200
    27.180    26.607     0.200
    27.221    23.940     0.200
    27.240    23.705     0.200
    27.241    23.831     0.200
    27.242    24.219     0.200
    27.264    24.572     0.200
    27.291    23.541     0.200
    27.300    26.439     0.200
    27.343    22.977     0.200
    27.380    27.329     0.200
    27.398    24.498     0.200
    27.438    25.050     0.200
    27.493    26.353     0.200
    27.510    22.679     0.200
    27.529    25.215     0.200
    27.536    24.937     0.200
    27.536    24.613     0.200
    27.536    24.743     0.200
    27.536    24.626     0.200
    27.571    25.515     0.200
    27.571    25.616     0.200
    27.587    22.934     0.200
    27.634    23.095     0.200
    27.669    24.472     0.200
    27.671    22.597     0.200
    27.710    24.793     0.200
    27.718    22.417     0.200
    27.777    21.244     0.200
    27.843    25.548     0.200
    27.842    22.339     0.200
    27.925    21.446     0.200
    27.928    22.387     0.200
    27.960    22.967     0.200
    27.972    22.872     0.200
    27.974    21.640     0.200
    28.002    23.238     0.200
    28.008    22.740     0.200
    28.071    20.907     0.200
    28.089    20.779     0.200
    28.105    23.628     0.200
    28.212    20.592     0.200
    28.249    24.522     0.200
    28.321    21.548     0.200
    28.321    20.849     0.200
    28.399    20.546     0.200
    28.420    19.787     0.200
    28.454    19.982     0.200
    28.464    22.342     0.200
    28.470    22.825     0.200
    28.467    20.617     0.200
    28.522    21.834     0.200
    28.525    22.626     0.200
    28.556    19.661     0.200
    28.604    20.567     0.200
    28.616    22.081     0.200
    28.641    19.120     0.200
    28.648    21.496     0.200
    28.662    21.051     0.200
    28.690    20.573     0.200
    28.739    19.184     0.200
    28.858    19.305     0.200
    28.858    18.816     0.200
    28.975    20.977     0.200
    29.027    19.010     0.200
    29.037    19.143     0.200
    29.054    18.154     0.200
    29.074    20.911     0.200
    29.087    19.415     0.200
    29.095    17.615     0.200
    29.106    17.671     0.200
    29.111    18.940     0.200
    29.137    17.906     0.200
    29.187    19.059     0.200
    29.221    19.490     0.200
    29.263    17.895     0.200
    29.299    18.691     0.200
    29.324    20.745     0.200
    29.324    21.452     0.200
    29.375    19.461     0.200
    29.385    17.253     0.200
    29.425    20.465     0.200
    29.430    20.922     0.200
    29.450    21.559     0.200
    29.571    17.734     0.200
    29.621    18.496     0.200
    29.647    18.913     0.200
    29.647    18.670     0.200
    29.648    20.041     0.200
    29.688    17.210     0.200
    29.686    19.893     0.200
    29.693    16.888     0.200
    29.709    18.070     0.200
    29.759    16.535     0.200
    29.763    19.472     0.200
    29.767    17.331     0.200
    29.785    15.878     0.200
    29.807    17.138     0.200
    29.818    17.550     0.200
    29.818    16.204     0.200
    29.859    18.984     0.200
    29.859    18.707     0.200
    29.857    16.009     0.200
    29.921    17.125     0.200
    29.937    17.247     0.200
    29.971    19.101     0.200
    29.972    16.148     0.200
    14.736    39.973     0.200
    15.142    41.201     0.200
    15.415    40.797     0.200
    15.568    39.730     0.200
    15.644    40.470     0.200
    15.943    39.306     0.200
    16.147    40.172     0.200
    16.206    40.449     0.200
    16.325    40.462     0.200
    16.394    40.185     0.200
    16.462    40.485     0.200
    16.488    40.510     0.200
    16.540    39.861     0.200
    16.548    42.852     0.200
    16.574    39.939     0.200
    17.050    39.879     0.200
    17.058    40.008     0.200
    17.082    40.242     0.200
    17.180    40.392     0.200
    17.214    39.812     0.200
    17.227    40.969     0.200
    17.385    39.632     0.200
    17.441    39.644     0.200
    17.828    39.786     0.200
    18.290    41.371     0.200
    18.341    37.871     0.200
    18.332    39.043     0.200
    18.313    41.675     0.200
    18.374    37.672     0.200
    18.374    37.469     0.200
    18.405    38.859     0.200
    18.441    39.791     0.200
    18.526    37.452     0.200
    18.534    38.733     0.200
    18.553    38.084     0.200
    18.629    37.898     0.200
    18.640    39.363     0.200
    18.649    38.430     0.200
    18.666    38.204     0.200
    18.684    39.032     0.200
    18.743    38.232     0.200
    18.742    38.656     0.200
    18.851    38.428     0.200
    18.872    38.635     0.200
    18.939    38.411     0.200
    18.938    38.004     0.200
    18.941    38.143     0.200
    18.941    37.611     0.200
    18.962    38.285     0.200
    18.979    39.582     0.200
    18.979    38.723     0.200
    19.082    37.825     0.200
    19.120    38.614     0.200
    19.154    38.343     0.200
    19.198    38.473     0.200
    19.227    37.634     0.200
    19.227    37.416     0.200
    19.268    37.732     0.200
    19.310    37.375     0.200
    19.339    39.316     0.200
    19.354    38.176     0.200
    19.401    37.977     0.200
    19.416    37.591     0.200
    19.435    37.697     0.200
    19.435    37.003     0.200
    19.459    37.495     0.200
    19.466    37.569     0.200
    19.491    37.373     0.200
    19.537    37.439     0.200
    19.537    37.329     0.200
    19.551    37.350     0.200
    19.585    37.519     0.200
    19.664    37.064     0.200
    19.697    36.909     0.200
    19.708    37.452     0.200
    19.766    36.276     0.200
    19.824    36.713     0.200
    19.935    37.307     0.200
    19.947    36.801     0.200
    19.940    36.699     0.200
    19.996    36.528     0.200
    20.122    37.400     0.200
    20.116    36.625     0.200
    20.131    37.145     0.200
    20.143    36.272     0.200
    20.148    36.659     0.200
    20.191    36.540     0.200
    20.209    36.883     0.200
    20.201    37.146     0.200
    20.275    36.710     0.200
    20.267    39.631     0.200
    20.267    38.404     0.200
    20.341    36.547     0.200
    20.415    36.003     0.200
    20.520    36.700     0.200
    20.520    36.848     0.200
    20.557    36.001     0.200
    20.590    36.155     0.200
    20.594    38.612     0.200
    20.594    38.385     0.200
    20.653    37.138     0.200
    20.739    35.298     0.200
    20.779    35.781     0.200
    20.806    35.846     0.200
    20.828    35.817     0.200
    20.796    39.024     0.200
    20.895    35.845     0.200
    21.012    36.440     0.200
    21.034    35.594     0.200
    21.080    37.491     0.200
    21.112    35.827     0.200
    21.141    39.241     0.200
    21.141    39.007     0.200
    21.192    35.708     0.200
    21.220    35.528     0.200
    21.243    34.911     0.200
    21.295    38.788     0.200
    21.347    38.425     0.200
    21.366    35.818     0.200
    21.393    35.179     0.200
    21.411    35.786     0.200
    21.397    36.579     0.200
    21.397    36.399     0.200
    21.429    35.010     0.200
    21.447    35.878     0.200
    21.475    38.221     0.200
    21.475    39.026     0.200
    21.540    35.162     0.200
    21.542    35.131     0.200
    21.575    37.162     0.200
    21.635    35.148     0.200
    21.637    38.109     0.200
    21.648    38.950     0.200
    21.678    39.005     0.200
    21.695    36.849     0.200
    21.695    37.107     0.200
    21.732    35.237     0.200
    21.711    37.102     0.200
    21.780    35.348     0.200
    21.814    34.295     0.200
    21.824    36.456     0.200
    21.935    34.676     0.200
    21.938    34.190     0.200
    21.938    38.861     0.200
    22.019    36.092     0.200
    21.995    38.674     0.200
    22.010    38.506     0.200
    22.054    35.027     0.200
    22.062    35.842     0.200
    22.089    34.470     0.200
    22.090    35.166     0.200
    22.124    38.262     0.200
    22.155    38.353     0.200
    22.179    34.620     0.200
    22.230    36.712     0.200
    22.253    34.492     0.200
    22.264    35.097     0.200
    22.264    35.222     0.200
    22.267    34.884     0.200
    22.345    35.085     0.200
    22.463    36.457     0.200
    22.507    36.074     0.200
    22.502    36.725     0.200
    22.502    35.288     0.200
    22.499    37.848     0.200
    22.502    38.219     0.200
    22.506    38.103     0.200
    22.506    37.158     0.200
    22.506    37.994     0.200
    22.585    35.541     0.200
    22.565    35.790     0.200
    22.655    33.770     0.200
    22.648    35.703     0.200
    22.685    35.827     0.200
    22.680    34.579     0.200
    22.753    34.335     0.200
    22.803    33.915     0.200
    22.785    38.567     0.200
    22.840    33.147     0.200
    22.854    33.892     0.200
    22.871    36.121     0.200
    22.951    34.219     0.200
    22.967    33.761     0.200
    22.949    37.194     0.200
    23.056    33.744     0.200
    23.075    35.828     0.200
    23.102    35.654     0.200
    23.149    33.794     0.200
    23.150    33.723     0.200
    23.179    33.123     0.200
    23.188    36.572     0.200
    23.243    33.177     0.200
    23.275    33.246     0.200
    23.297    33.099     0.200
    23.313    33.213     0.200
    23.287    37.228     0.200
    23.328    33.613     0.200
    23.324    36.172     0.200
    23.394    32.641     0.200
    23.374    36.612     0.200
    23.425    35.708     0.200
    23.400    36.173     0.200
    23.400    34.329     0.200
    23.456    33.139     0.200
    23.412    36.015     0.200
    23.481    32.443     0.200
    23.487    32.511     0.200
    23.494    33.350     0.200
    23.496    37.070     0.200
    23.597    31.956     0.200
    23.675    33.629     0.200
    23.662    35.150     0.200
    23.789    32.380     0.200
    23.806    33.471     0.200
    23.808    33.059     0.200
    23.780    35.672     0.200
    23.819    32.366     0.200
    23.868    33.302     0.200
    23.871    31.092     0.200
    23.871    35.960     0.200
    23.894    35.215     0.200
    23.894    35.402     0.200
    23.897    35.406     0.200
    23.898    35.364     0.200
    23.963    33.043     0.200
    23.943    34.696     0.200
    23.995    32.279     0.200
    24.055    32.597     0.200
    24.044    33.720     0.200
    24.030    34.784     0.200
    24.083    31.800     0.200
    24.113    31.981     0.200
    24.089    34.376     0.200
    24.183    31.431     0.200
    24.180    34.903     0.200
    24.219    32.184     0.200
    24.241    30.675     0.200
    24.223    34.415     0.200
    24.332    31.349     0.200
    24.299    33.699     0.200
    24.328    33.868     0.200
    24.328    34.102     0.200
    24.357    32.352     0.200
    24.405    31.383     0.200
    24.405    31.266     0.200
    24.429    31.748     0.200
    24.447    32.595     0.200
    24.447    31.704     0.200
    24.460    34.056     0.200
    24.458    34.122     0.200
    24.488    32.905     0.200
    24.522    32.266     0.200
    24.522    32.828     0.200
    24.569    33.078     0.200
    24.569    33.671     0.200
    24.647    31.383     0.200
    24.661    30.515     0.200
    24.666    31.325     0.200
    24.703    31.187     0.200
    24.754    34.235     0.200
    24.769    33.123     0.200
    24.807    30.874     0.200
    24.799    33.895     0.200
    24.827    31.358     0.200
    24.822    33.201     0.200
    24.873    30.714     0.200
    24.902    32.154     0.200
    24.949    29.818     0.200
    24.973    33.297     0.200
    25.040    29.410     0.200
    25.048    30.447     0.200
    25.126    30.242     0.200
    25.119    31.859     0.200
    25.198    29.544     0.200
    25.198    29.240     0.200
    25.190    31.465     0.200
    25.251    30.851     0.200
    25.358    29.506     0.200
    25.392    31.399     0.200
    25.461    29.976     0.200
    25.429    31.180     0.200
    25.431    30.936     0.200
    25.430    31.676     0.200
    25.510    28.230     0.200
    25.548    31.131     0.200
    25.548    31.396     0.200
    25.626    28.630     0.200
    25.604    31.460     0.200
    25.680    29.980     0.200
    25.740    28.900     0.200
    25.777    29.153     0.200
    25.777    28.622     0.200
    25.784    28.264     0.200
    25.845    31.421     0.200
    25.817    31.726     0.200
    25.866    27.976     0.200
    25.880    29.686     0.200
    25.880    30.069     0.200
    25.925    28.813     0.200
    25.961    26.713     0.200
    25.950    31.015     0.200
    25.997    28.359     0.200
    26.019    29.115     0.200
    26.012    29.467     0.200
    26.269    26.247     0.200
    26.271    26.083     0.200
    26.309    28.335     0.200
    26.329    28.083     0.200
    26.329    27.895     0.200
    26.374    26.975     0.200
    26.419    28.029     0.200
    26.542    24.819     0.200
    26.594    28.135     0.200
    26.620    29.730     0.200
    26.703    24.024     0.200
    26.677    27.466     0.200
    26.712    24.726     0.200
    26.699    29.591     0.200
    26.716    28.024     0.200
    26.814    24.717     0.200
    26.859    25.214     0.200
    26.859    24.909     0.200
    27.014    23.611     0.200
    27.120    25.829     0.200
    27.137    25.767     0.200
    27.137    25.892     0.200
    27.137    25.924     0.200
    27.137    25.807     0.200
    27.184    23.728     0.200
    27.247    26.241     0.200
    27.347    23.368     0.200
    27.330    26.619     0.200
    27.384    25.121     0.200
    27.525    22.895     0.200
    27.570    23.206     0.200
    27.737    22.095     0.200
    27.791    23.071     0.200
    27.831    23.954     0.200
    27.860    22.864     0.200
    27.994    22.758     0.200
    28.049    23.673     0.200
    28.113    23.825     0.200
    28.156    21.542     0.200
    28.194    24.128     0.200
    28.208    22.706     0.200
    28.304    21.831     0.200
    28.316    23.057     0.200
    28.352    22.272     0.200
    28.447    21.290     0.200
    28.442    20.587     0.200
    28.564    21.809     0.200
    28.753    19.842     0.200
    28.801    19.888     0.200
    28.816    20.708     0.200
    28.970    20.423     0.200
    29.275    20.193     0.200
    29.275    20.021     0.200
    29.310    18.982     0.200
    29.312    19.521     0.200
    29.392    20.210     0.200
    29.566    18.015     0.200
    29.799    19.311     0.200
    29.876    16.693     0.200
    29.916    16.289     0.200
    29.928    17.691     0.200
    29.991    16.399     0.200
    29.981    19.372     0.200
    29.999    17.940     0.200
    15.392    40.895     0.200
    15.553    41.048     0.200
    15.566    44.398     0.200
    16.562    43.528     0.200
    16.617    40.960     0.200
    16.825    41.410     0.200
    16.948    42.214     0.200
    16.948    43.592     0.200
    17.756    41.270     0.200
    18.048    43.540     0.200
    18.047    43.398     0.200
    18.047    42.871     0.200
    18.064    42.383     0.200
    18.200    44.446     0.200
    18.234    41.171     0.200
    18.297    41.189     0.200
    18.384    41.285     0.200
    18.423    41.758     0.200
    18.435    43.654     0.200
    18.484    40.226     0.200
    18.582    40.890     0.200
    18.665    40.728     0.200
    18.691    40.900     0.200
    18.739    40.626     0.200
    18.733    39.754     0.200
    18.795    40.275     0.200
    18.902    40.179     0.200
    18.907    38.995     0.200
    18.969    40.428     0.200
    18.995    40.291     0.200
    19.004    40.194     0.200
    19.047    39.307     0.200
    19.064    39.942     0.200
    19.074    39.075     0.200
    19.165    38.954     0.200
    19.211    39.449     0.200
    19.211    40.445     0.200
    19.279    39.219     0.200
    19.308    39.538     0.200
    19.318    40.083     0.200
    19.400    39.674     0.200
    19.411    40.752     0.200
    19.427    38.033     0.200
    19.448    39.835     0.200
    19.494    40.435     0.200
    19.515    40.246     0.200
    19.603    39.037     0.200
    19.613    39.614     0.200
    19.691    39.483     0.200
    19.733    39.099     0.200
    19.807    38.865     0.200
    19.819    39.307     0.200
    19.818    38.978     0.200
    19.828    38.572     0.200
    19.855    38.870     0.200
    19.885    40.328     0.200
    19.959    39.809     0.200
    19.983    40.793     0.200
    19.991    38.641     0.200
    20.005    38.325     0.200
    20.081    38.438     0.200
    20.100    38.764     0.200
    20.100    37.318     0.200
    20.169    38.824     0.200
    20.261    38.464     0.200
    20.314    38.382     0.200
    20.318    38.172     0.200
    20.411    40.458     0.200
    20.530    37.458     0.200
    20.552    38.483     0.200
    20.579    38.551     0.200
    20.597    39.356     0.200
    20.780    38.091     0.200
    20.803    37.705     0.200
    20.807    38.158     0.200
    20.861    37.674     0.200
    20.993    40.578     0.200
    21.014    37.452     0.200
    21.112    37.802     0.200
    21.120    41.460     0.200
    21.125    36.849     0.200
    21.185    37.828     0.200
    21.198    39.638     0.200
    21.198    39.973     0.200
    21.254    37.777     0.200
    21.256    40.853     0.200
    21.272    37.108     0.200
    21.272    41.038     0.200
    21.202    38.062     0.200
    21.333    40.857     0.200
    21.359    37.486     0.200
    21.447    38.769     0.200
    21.447    40.302     0.200
    21.449    36.912     0.200
    21.470    37.702     0.200
    21.472    37.222     0.200
    21.491    39.268     0.200
    21.491    40.233     0.200
    21.508    37.968     0.200
    21.575    37.192     0.200
    21.573    40.412     0.200
    21.614    36.668     0.200
    21.614    37.680     0.200
    21.614    40.875     0.200
    21.722    37.231     0.200
    21.726    37.823     0.200
    21.726    38.150     0.200
    21.728    37.192     0.200
    21.767    40.653     0.200
    21.780    37.411     0.200
    21.787    37.677     0.200
    21.793    36.465     0.200
    21.820    41.273     0.200
    21.941    40.014     0.200
    21.939    36.177     0.200
    22.005    37.717     0.200
    22.032    37.486     0.200
    22.036    39.262     0.200
    22.048    36.144     0.200
    22.056    37.311     0.200
    22.102    36.669     0.200
    22.132    40.406     0.200
    22.132    39.552     0.200
    22.132    40.205     0.200
    22.136    40.228     0.200
    22.159    40.697     0.200
    22.154    37.236     0.200
    22.243    36.862     0.200
    22.287    36.258     0.200
    22.306    37.706     0.200
    22.323    39.041     0.200
    22.339    36.721     0.200
    22.430    38.686     0.200
    22.438    41.231     0.200
    22.516    39.485     0.200
    22.546    36.019     0.200
    22.569    39.629     0.200
    22.592    37.360     0.200
    22.636    36.073     0.200
    22.709    35.039     0.200
    22.709    35.222     0.200
    22.717    35.772     0.200
    22.820    35.434     0.200
    22.860    38.733     0.200
    22.883    39.721     0.200
    22.889    37.835     0.200
    22.928    35.950     0.200
    22.926    38.821     0.200
    22.951    35.017     0.200
    22.988    35.640     0.200
    22.999    35.637     0.200
    23.017    38.635     0.200
    23.019    35.701     0.200
    23.047    35.972     0.200
    23.064    39.096     0.200
    23.087    36.042     0.200
    23.144    39.237     0.200
    23.196    35.077     0.200
    23.210    37.135     0.200
    23.247    34.914     0.200
    23.263    34.874     0.200
    23.280    36.224     0.200
    23.293    35.023     0.200
    23.285    38.877     0.200
    23.337    39.412     0.200
    23.369    35.551     0.200
    23.458    36.353     0.200
    23.484    39.775     0.200
    23.491    39.801     0.200
    23.509    34.981     0.200
    23.518    40.001     0.200
    23.534    37.261     0.200
    23.565    38.363     0.200
    23.563    38.783     0.200
    23.563    36.499     0.200
    23.579    34.668     0.200
    23.579    35.218     0.200
    23.646    34.350     0.200
    23.666    34.482     0.200
    23.680    37.067     0.200
    23.737    34.182     0.200
    23.829    37.085     0.200
    23.867    33.791     0.200
    23.895    37.778     0.200
    23.914    33.385     0.200
    23.870    37.428     0.200
    23.926    36.482     0.200
    23.948    33.941     0.200
    24.044    32.990     0.200
    24.056    36.123     0.200
    24.071    33.385     0.200
    24.066    35.343     0.200
    24.103    34.962     0.200
    24.103    36.441     0.200
    24.110    33.472     0.200
    24.099    35.727     0.200
    24.135    33.080     0.200
    24.188    35.995     0.200
    24.207    32.829     0.200
    24.229    37.366     0.200
    24.333    34.295     0.200
    24.333    35.577     0.200
    24.373    33.638     0.200
    24.373    35.303     0.200
    24.360    33.510     0.200
    24.364    32.977     0.200
    24.374    32.968     0.200
    24.432    33.044     0.200
    24.460    37.213     0.200
    24.509    32.533     0.200
    24.596    33.182     0.200
    24.595    35.293     0.200
    24.607    32.961     0.200
    24.624    33.620     0.200
    24.646    34.012     0.200
    24.674    32.243     0.200
    24.680    35.689     0.200
    24.684    32.363     0.200
    24.749    35.716     0.200
    24.784    32.547     0.200
    24.860    32.411     0.200
    24.903    32.823     0.200
    24.976    33.333     0.200
    25.008    32.842     0.200
    25.044    35.316     0.200
    25.077    32.435     0.200
    25.070    34.941     0.200
    25.082    34.960     0.200
    25.120    34.575     0.200
    25.189    32.473     0.200
    25.227    33.909     0.200
    25.227    34.705     0.200
    25.232    34.484     0.200
    25.158    34.172     0.200
    25.258    31.586     0.200
    25.258    31.252     0.200
    25.279    31.602     0.200
    25.225    30.566     0.200
    25.321    31.861     0.200
    25.321    31.068     0.200
    25.344    32.768     0.200
    25.412    31.027     0.200
    25.437    31.614     0.200
    25.434    34.159     0.200
    25.555    32.027     0.200
    25.602    32.546     0.200
    25.602    32.747     0.200
    25.595    33.170     0.200
    25.615    30.706     0.200
    25.630    31.766     0.200
    25.638    30.610     0.200
    25.648    31.266     0.200
    25.643    32.767     0.200
    25.820    30.498     0.200
    25.868    30.081     0.200
    25.868    30.438     0.200
    25.936    29.654     0.200
    25.962    29.312     0.200
    26.103    28.607     0.200
    26.140    29.369     0.200
    26.140    30.814     0.200
    26.223    28.667     0.200
    26.258    28.286     0.200
    26.302    28.029     0.200
    26.308    27.834     0.200
    26.320    31.277     0.200
    26.347    28.271     0.200
    26.344    30.696     0.200
    26.359    29.162     0.200
    26.423    30.283     0.200
    26.426    28.658     0.200
    26.517    29.192     0.200
    26.553    27.992     0.200
    26.575    28.304     0.200
    26.598    28.021     0.200
    26.688    27.467     0.200
    26.724    27.233     0.200
    26.800    26.734     0.200
    26.803    26.971     0.200
    26.803    27.571     0.200
    26.862    31.321     0.200
    26.913    29.140     0.200
    26.913    28.566     0.200
    26.913    28.587     0.200
    26.913    28.417     0.200
    26.909    28.159     0.200
    26.968    28.046     0.200
    26.981    29.789     0.200
    27.014    28.071     0.200
    27.025    28.061     0.200
    27.097    27.071     0.200
    27.111    26.894     0.200
    27.061    30.660     0.200
    27.182    27.144     0.200
    27.194    26.538     0.200
    27.231    27.497     0.200
    27.303    30.214     0.200
    27.365    27.133     0.200
    27.412    26.758     0.200
    27.419    27.574     0.200
    27.488    26.105     0.200
    27.501    26.653     0.200
    27.497    28.360     0.200
    27.510    26.446     0.200
    27.547    29.119     0.200
    27.634    25.350     0.200
    27.731    25.978     0.200
    27.728    25.589     0.200
    27.736    25.880     0.200
    27.812    25.563     0.200
    27.813    25.446     0.200
    27.814    28.708     0.200
    27.958    24.969     0.200
    27.959    26.438     0.200
    27.971    25.117     0.200
    27.977    26.000     0.200
    28.155    27.314     0.200
    28.176    24.620     0.200
    28.245    24.627     0.200
    28.267    23.993     0.200
    28.331    25.049     0.200
    28.355    24.440     0.200
    28.266    28.494     0.200
    28.462    26.097     0.200
    28.618    27.148     0.200
    28.643    25.794     0.200
    28.643    26.084     0.200
    28.782    25.748     0.200
    28.807    23.250     0.200
    28.920    23.295     0.200
    29.066    23.131     0.200
    29.066    22.790     0.200
    29.123    23.438     0.200
    29.123    23.574     0.200
    29.169    21.620     0.200
    29.179    24.564     0.200
    29.286    21.961     0.200
    29.371    21.985     0.200
    29.506    20.426     0.200
    29.517    22.563     0.200
    29.521    20.607     0.200
    29.571    20.361     0.200
    29.605    20.370     0.200
    29.668    20.656     0.200
    29.703    21.033     0.200
    29.749    19.636     0.200
    29.862    21.221     0.200
    15.327    42.624     0.200
    15.965    40.691     0.200
    15.965    42.210     0.200
    16.195    43.157     0.200
    16.341    43.383     0.200
    17.578    41.870     0.200
    17.618    41.985     0.200
    18.450    40.214     0.200
    18.611    39.150     0.200
    18.611    38.806     0.200
    18.752    38.877     0.200
    18.901    40.002     0.200
    19.162    39.856     0.200
    19.182    39.866     0.200
    19.209    38.999     0.200
    19.223    39.825     0.200
    19.223    40.063     0.200
    19.328    39.596     0.200
    19.354    40.393     0.200
    19.397    39.676     0.200
    19.415    39.322     0.200
    19.499    38.677     0.200
    19.499    39.099     0.200
    19.562    39.469     0.200
    19.571    39.184     0.200
    19.574    38.061     0.200
    19.579    38.843     0.200
    19.632    38.597     0.200
    19.648    38.958     0.200
    19.659    39.651     0.200
    19.690    38.494     0.200
    19.711    39.629     0.200
    19.711    39.520     0.200
    19.806    38.177     0.200
    19.808    37.498     0.200
    19.830    38.678     0.200
    19.836    39.229     0.200
    19.873    38.409     0.200
    19.875    38.549     0.200
    19.948    37.919     0.200
    19.945    37.983     0.200
    19.945    39.162     0.200
    19.981    38.764     0.200
    19.989    37.832     0.200
    19.997    38.090     0.200
    20.089    38.081     0.200
    20.160    38.351     0.200
    20.173    37.937     0.200
    20.190    39.380     0.200
    20.253    37.407     0.200
    20.315    38.483     0.200
    20.324    38.199     0.200
    20.388    37.710     0.200
    20.399    38.104     0.200
    20.406    37.479     0.200
    20.429    37.103     0.200
    20.439    37.862     0.200
    20.512    37.952     0.200
    20.539    37.667     0.200
    20.609    37.133     0.200
    20.618    37.205     0.200
    20.659    39.942     0.200
    20.749    37.288     0.200
    20.758    37.058     0.200
    20.822    37.092     0.200
    20.848    37.680     0.200
    20.905    37.221     0.200
    20.928    36.872     0.200
    20.956    37.035     0.200
    20.953    40.048     0.200
    20.997    44.148     0.200
    21.026    36.673     0.200
    21.131    36.606     0.200
    21.178    36.913     0.200
    21.198    40.545     0.200
    21.309    36.767     0.200
    21.323    36.552     0.200
    21.341    36.620     0.200
    21.349    36.996     0.200
    21.447    36.813     0.200
    21.459    36.859     0.200
    21.499    36.783     0.200
    21.545    35.992     0.200
    21.545    41.169     0.200
    21.586    35.810     0.200
    21.603    37.107     0.200
    21.620    35.756     0.200
    21.628    36.465     0.200
    21.678    36.176     0.200
    21.691    39.763     0.200
    21.705    36.629     0.200
    21.761    38.282     0.200
    21.761    38.692     0.200
    21.779    36.850     0.200
    21.806    36.606     0.200
    21.824    37.258     0.200
    21.861    35.555     0.200
    21.879    40.028     0.200
    21.911    36.974     0.200
    21.927    36.172     0.200
    21.962    36.691     0.200
    21.988    35.653     0.200
    21.988    35.814     0.200
    22.038    36.438     0.200
    22.051    39.987     0.200
    22.077    38.774     0.200
    22.081    39.578     0.200
    22.083    38.397     0.200
    22.083    39.300     0.200
    22.094    35.874     0.200
    22.142    36.669     0.200
    22.162    35.792     0.200
    22.337    35.819     0.200
    22.342    38.707     0.200
    22.372    35.690     0.200
    22.402    36.311     0.200
    22.398    38.771     0.200
    22.441    35.589     0.200
    22.480    34.831     0.200
    22.493    35.727     0.200
    22.521    37.241     0.200
    22.527    39.127     0.200
    22.538    35.709     0.200
    22.553    36.388     0.200
    22.556    38.757     0.200
    22.727    35.533     0.200
    22.749    35.090     0.200
    22.824    35.983     0.200
    22.842    36.420     0.200
    22.856    36.835     0.200
    22.862    34.885     0.200
    22.860    38.606     0.200
    22.875    35.582     0.200
    22.906    39.131     0.200
    22.907    37.914     0.200
    22.910    37.840     0.200
    22.945    37.211     0.200
    23.023    35.280     0.200
    23.048    35.492     0.200
    23.063    37.229     0.200
    23.131    35.092     0.200
    23.188    39.936     0.200
    23.208    35.701     0.200
    23.226    35.954     0.200
    23.275    37.511     0.200
    23.318    36.063     0.200
    23.315    36.579     0.200
    23.322    33.776     0.200
    23.353    38.002     0.200
    23.383    35.843     0.200
    23.427    34.500     0.200
    23.449    35.531     0.200
    23.456    37.457     0.200
    23.477    36.424     0.200
    23.471    37.897     0.200
    23.501    34.274     0.200
    23.517    35.516     0.200
    23.517    35.903     0.200
    23.525    33.993     0.200
    23.537    33.745     0.200
    23.619    34.801     0.200
    23.635    37.526     0.200
    23.690    37.095     0.200
    23.703    33.935     0.200
    23.723    34.402     0.200
    23.762    33.940     0.200
    23.761    36.228     0.200
    23.772    37.320     0.200
    23.812    33.730     0.200
    23.865    32.752     0.200
    23.899    37.299     0.200
    23.918    33.625     0.200
    23.996    33.730     0.200
    24.032    33.270     0.200
    24.066    36.399     0.200
    24.173    36.706     0.200
    24.216    32.716     0.200
    24.268    36.649     0.200
    24.282    32.265     0.200
    24.297    35.321     0.200
    24.299    36.284     0.200
    24.306    33.143     0.200
    24.327    33.402     0.200
    24.377    33.054     0.200
    24.379    34.239     0.200
    24.395    33.203     0.200
    24.416    32.718     0.200
    24.416    33.500     0.200
    24.433    35.280     0.200
    24.475    34.486     0.200
    24.566    32.416     0.200
    24.572    34.292     0.200
    24.637    32.022     0.200
    24.689    32.767     0.200
    24.703    35.189     0.200
    24.702    33.707     0.200
    24.702    33.110     0.200
    24.736    31.882     0.200
    24.844    34.062     0.200
    24.873    34.304     0.200
    24.883    33.492     0.200
    24.883    34.039     0.200
    24.884    34.369     0.200
    24.913    31.983     0.200
    24.929    34.698     0.200
    24.967    30.911     0.200
    25.120    31.601     0.200
    25.141    32.134     0.200
    25.172    33.932     0.200
    25.202    34.121     0.200
    25.226    33.515     0.200
    25.264    31.135     0.200
    25.301    30.610     0.200
    25.298    33.375     0.200
    25.376    33.393     0.200
    25.418    30.341     0.200
    25.418    30.602     0.200
    25.441    33.674     0.200
    25.460    30.672     0.200
    25.503    30.143     0.200
    25.522    34.122     0.200
    25.522    34.993     0.200
    25.559    29.487     0.200
    25.633    30.436     0.200
    25.641    30.351     0.200
    25.672    32.398     0.200
    25.781    32.225     0.200
    25.833    32.161     0.200
    25.837    29.754     0.200
    25.949    30.514     0.200
    25.948    31.820     0.200
    25.948    32.457     0.200
    25.996    29.355     0.200
    26.008    32.009     0.200
    26.188    28.389     0.200
    26.270    31.197     0.200
    26.270    31.088     0.200
    26.311    30.807     0.200
    26.327    28.725     0.200
    26.416    30.531     0.200
    26.482    27.835     0.200
    26.482    28.382     0.200
    26.540    27.071     0.200
    26.571    29.858     0.200
    26.689    28.546     0.200
    26.689    29.515     0.200
    26.806    28.044     0.200
    26.984    27.559     0.200
    27.061    28.220     0.200
    27.103    28.762     0.200
    27.147    25.690     0.200
    27.153    25.599     0.200
    27.153    26.959     0.200
    27.313    29.160     0.200
    27.389    28.334     0.200
    27.389    29.079     0.200
    27.507    24.374     0.200
    27.511    26.331     0.200
    27.511    26.797     0.200
    27.511    26.484     0.200
    27.511    26.594     0.200
    27.625    27.242     0.200
    27.634    27.104     0.200
    27.729    25.542     0.200
    27.729    26.335     0.200
    27.744    27.472     0.200
    27.843    24.138     0.200
    27.999    23.297     0.200
    28.272    24.044     0.200
    28.426    24.660     0.200
    28.489    24.568     0.200
    28.575    21.688     0.200
    28.572    24.028     0.200
    28.619    21.816     0.200
    28.729    23.657     0.200
    28.749    23.287     0.200
    28.844    24.033     0.200
    28.941    23.028     0.200
    29.000    23.902     0.200
    29.505    22.042     0.200
    29.510    20.167     0.200
    29.531    22.967     0.200
    29.642    20.616     0.200
    29.642    20.784     0.200
    29.657    20.911     0.200
    29.690    19.720     0.200
    29.779    20.233     0.200
    29.779    21.186     0.200
    29.798    18.951     0.200
    29.937    17.831     0.200
    15.570    41.490     0.200
    15.570    41.755     0.200
    15.743    40.939     0.200
    16.058    41.145     0.200
    16.058    41.688     0.200
    16.438    42.107     0.200
    16.997    42.035     0.200
    17.342    41.716     0.200
    17.342    42.353     0.200
    17.858    42.367     0.200
    18.394    39.964     0.200
    18.438    39.286     0.200
    18.438    39.419     0.200
    18.570    39.449     0.200
    18.586    39.271     0.200
    18.616    39.230     0.200
    18.616    39.789     0.200
    18.959    38.622     0.200
    18.999    39.342     0.200
    19.004    39.615     0.200
    19.004    40.076     0.200
    19.127    39.530     0.200
    19.166    39.022     0.200
    19.249    40.044     0.200
    19.272    39.047     0.200
    19.275    38.844     0.200
    19.275    38.208     0.200
    19.292    38.328     0.200
    19.292    40.714     0.200
    19.301    39.030     0.200
    19.301    39.550     0.200
    19.309    38.588     0.200
    19.398    39.238     0.200
    19.488    39.983     0.200
    19.494    39.536     0.200
    19.513    39.093     0.200
    19.513    39.558     0.200
    19.543    38.921     0.200
    19.598    39.035     0.200
    19.603    38.380     0.200
    19.676    39.828     0.200
    19.676    39.578     0.200
    19.707    39.449     0.200
    19.707    39.344     0.200
    19.721    38.759     0.200
    19.721    39.282     0.200
    19.791    37.987     0.200
    19.791    38.796     0.200
    19.811    38.361     0.200
    19.811    37.936     0.200
    19.969    38.806     0.200
    19.969    39.064     0.200
    20.008    39.918     0.200
    20.021    38.927     0.200
    20.033    37.651     0.200
    20.071    39.003     0.200
    20.068    37.812     0.200
    20.101    38.678     0.200
    20.110    38.633     0.200
    20.110    39.105     0.200
    20.110    38.656     0.200
    20.110    38.414     0.200
    20.199    37.867     0.200
    20.215    39.010     0.200
    20.262    39.045     0.200
    20.255    38.530     0.200
    20.338    38.608     0.200
    20.338    38.924     0.200
    20.430    38.903     0.200
    20.427    38.366     0.200
    20.445    38.307     0.200
    20.445    38.619     0.200
    20.452    38.382     0.200
    20.446    39.246     0.200
    20.446    38.695     0.200
    20.458    38.773     0.200
    20.531    38.623     0.200
    20.564    38.554     0.200
    20.571    36.887     0.200
    20.613    37.788     0.200
    20.613    38.444     0.200
    20.655    37.910     0.200
    20.655    38.597     0.200
    20.616    39.870     0.200
    20.688    37.768     0.200
    20.688    38.386     0.200
    20.697    39.636     0.200
    20.722    38.175     0.200
    20.780    37.555     0.200
    20.815    37.559     0.200
    20.857    39.623     0.200
    20.864    40.505     0.200
    20.903    38.171     0.200
    20.913    37.168     0.200
    20.924    37.575     0.200
    20.924    38.357     0.200
    20.948    38.254     0.200
    21.009    42.209     0.200
    21.009    39.628     0.200
    21.045    39.508     0.200
    21.060    38.793     0.200
    21.057    37.116     0.200
    21.123    37.669     0.200
    21.171    38.696     0.200
    21.209    37.194     0.200
    21.244    37.923     0.200
    21.239    38.383     0.200
    21.262    40.820     0.200
    21.262    40.398     0.200
    21.265    41.733     0.200
    21.384    37.554     0.200
    21.396    39.180     0.200
    21.400    37.213     0.200
    21.413    40.526     0.200
    21.413    41.069     0.200
    21.417    36.554     0.200
    21.448    37.260     0.200
    21.502    38.716     0.200
    21.502    39.321     0.200
    21.567    36.905     0.200
    21.567    37.378     0.200
    21.564    41.136     0.200
    21.601    36.440     0.200
    21.620    36.873     0.200
    21.658    36.482     0.200
    21.724    38.622     0.200
    21.698    38.574     0.200
    21.732    36.468     0.200
    21.759    40.003     0.200
    21.769    39.967     0.200
    21.799    39.265     0.200
    21.807    38.878     0.200
    21.807    39.370     0.200
    21.799    36.230     0.200
    21.819    38.761     0.200
    21.858    36.579     0.200
    21.858    35.661     0.200
    21.886    40.665     0.200
    21.914    36.898     0.200
    21.914    37.374     0.200
    21.911    36.815     0.200
    21.932    35.873     0.200
    21.932    36.651     0.200
    21.953    36.859     0.200
    21.953    35.816     0.200
    21.972    36.372     0.200
    21.972    38.286     0.200
    21.972    38.665     0.200
    21.974    35.749     0.200
    21.974    36.257     0.200
    21.986    36.473     0.200
    22.016    35.846     0.200
    22.016    36.584     0.200
    22.027    35.957     0.200
    22.060    39.631     0.200
    22.116    39.381     0.200
    22.132    39.884     0.200
    22.113    40.381     0.200
    22.200    35.594     0.200
    22.207    36.347     0.200
    22.244    39.138     0.200
    22.276    36.980     0.200
    22.276    37.851     0.200
    22.269    35.639     0.200
    22.344    36.017     0.200
    22.371    35.393     0.200
    22.407    38.525     0.200
    22.427    34.987     0.200
    22.489    36.293     0.200
    22.523    36.165     0.200
    22.544    38.425     0.200
    22.512    39.836     0.200
    22.556    36.534     0.200
    22.569    36.065     0.200
    22.606    37.319     0.200
    22.623    38.513     0.200
    22.628    39.339     0.200
    22.628    39.191     0.200
    22.632    35.354     0.200
    22.675    35.497     0.200
    22.670    35.546     0.200
    22.732    35.824     0.200
    22.746    35.427     0.200
    22.792    37.770     0.200
    22.829    34.689     0.200
    22.873    37.581     0.200
    22.915    35.717     0.200
    22.992    37.791     0.200
    23.010    35.709     0.200
    23.070    37.811     0.200
    23.089    33.767     0.200
    23.186    37.522     0.200
    23.183    34.813     0.200
    23.209    37.496     0.200
    23.230    33.797     0.200
    23.230    36.152     0.200
    23.244    36.235     0.200
    23.285    34.659     0.200
    23.306    38.878     0.200
    23.285    37.766     0.200
    23.353    38.250     0.200
    23.361    36.530     0.200
    23.391    35.966     0.200
    23.392    36.893     0.200
    23.396    35.375     0.200
    23.408    37.598     0.200
    23.422    34.664     0.200
    23.441    39.210     0.200
    23.460    34.109     0.200
    23.504    36.540     0.200
    23.503    35.784     0.200
    23.530    34.428     0.200
    23.534    36.615     0.200
    23.578    35.043     0.200
    23.591    34.790     0.200
    23.616    37.038     0.200
    23.655    34.795     0.200
    23.655    35.647     0.200
    23.686    34.287     0.200
    23.682    35.966     0.200
    23.713    36.947     0.200
    23.784    36.979     0.200
    23.783    34.104     0.200
    23.812    35.757     0.200
    23.815    34.758     0.200
    23.815    36.160     0.200
    23.824    36.835     0.200
    23.834    36.935     0.200
    23.846    33.806     0.200
    23.885    34.686     0.200
    23.944    33.068     0.200
    23.952    35.178     0.200
    24.015    36.331     0.200
    24.064    37.145     0.200
    24.055    35.299     0.200
    24.139    34.500     0.200
    24.151    35.680     0.200
    24.164    33.666     0.200
    24.193    33.985     0.200
    24.202    35.631     0.200
    24.197    33.525     0.200
    24.211    36.723     0.200
    24.213    33.405     0.200
    24.251    33.341     0.200
    24.251    33.833     0.200
    24.285    32.751     0.200
    24.285    33.345     0.200
    24.296    36.625     0.200
    24.337    33.117     0.200
    24.349    32.840     0.200
    24.354    31.801     0.200
    24.421    34.810     0.200
    24.423    33.303     0.200
    24.437    34.825     0.200
    24.488    35.423     0.200
    24.495    33.558     0.200
    24.514    32.841     0.200
    24.532    33.326     0.200
    24.580    35.536     0.200
    24.593    32.403     0.200
    24.601    34.340     0.200
    24.610    35.165     0.200
    24.626    33.700     0.200
    24.647    35.005     0.200
    24.646    32.661     0.200
    24.646    32.278     0.200
    24.679    32.014     0.200
    24.641    36.870     0.200
    24.690    34.507     0.200
    24.690    35.206     0.200
    24.728    32.787     0.200
    24.769    35.997     0.200
    24.822    31.425     0.200
    24.822    31.936     0.200
    24.868    31.877     0.200
    24.876    34.257     0.200
    24.890    34.593     0.200
    24.919    34.484     0.200
    24.930    33.498     0.200
    24.935    32.103     0.200
    24.935    32.693     0.200
    24.943    34.221     0.200
    24.957    30.830     0.200
    24.957    31.080     0.200
    24.986    31.881     0.200
    24.995    31.860     0.200
    25.038    31.604     0.200
    25.076    31.724     0.200
    25.094    33.899     0.200
    25.112    30.719     0.200
    25.119    30.775     0.200
    25.121    31.300     0.200
    25.082    34.322     0.200
    25.152    30.487     0.200
    25.198    30.700     0.200
    25.205    33.657     0.200
    25.216    31.056     0.200
    25.240    34.030     0.200
    25.240    30.906     0.200
    25.256    29.995     0.200
    25.264    31.622     0.200
    25.326    31.429     0.200
    25.378    30.852     0.200
    25.453    34.934     0.200
    25.541    30.733     0.200
    25.550    33.082     0.200
    25.552    32.879     0.200
    25.552    32.476     0.200
    25.563    29.999     0.200
    25.525    35.155     0.200
    25.581    29.879     0.200
    25.627    29.345     0.200
    25.653    31.418     0.200
    25.648    29.948     0.200
    25.664    29.004     0.200
    25.667    32.485     0.200
    25.667    32.660     0.200
    25.661    28.943     0.200
    25.661    31.025     0.200
    25.686    28.970     0.200
    25.686    30.692     0.200
    25.725    32.509     0.200
    25.750    29.272     0.200
    25.735    34.532     0.200
    25.812    28.844     0.200
    25.815    29.818     0.200
    25.814    29.464     0.200
    25.828    29.228     0.200
    25.828    30.092     0.200
    25.798    32.356     0.200
    25.853    31.379     0.200
    25.860    29.314     0.200
    25.938    32.530     0.200
    25.995    31.768     0.200
    26.049    28.810     0.200
    26.051    29.239     0.200
    26.071    31.540     0.200
    26.037    30.297     0.200
    26.037    32.328     0.200
    26.072    32.992     0.200
    26.126    29.222     0.200
    26.145    28.867     0.200
    26.162    29.259     0.200
    26.201    28.405     0.200
    26.221    28.902     0.200
    26.227    31.128     0.200
    26.253    28.216     0.200
    26.252    31.461     0.200
    26.334    28.441     0.200
    26.318    34.286     0.200
    26.396    28.313     0.200
    26.397    27.965     0.200
    26.405    27.508     0.200
    26.433    29.280     0.200
    26.382    31.335     0.200
    26.470    26.663     0.200
    26.485    26.297     0.200
    26.490    28.240     0.200
    26.489    28.209     0.200
    26.513    27.022     0.200
    26.561    30.702     0.200
    26.621    27.619     0.200
    26.622    26.174     0.200
    26.601    32.710     0.200
    26.722    27.212     0.200
    26.726    26.732     0.200
    26.750    26.372     0.200
    26.754    26.418     0.200
    26.754    27.203     0.200
    26.753    27.312     0.200
    26.788    26.396     0.200
    26.786    26.983     0.200
    26.819    30.093     0.200
    26.830    28.558     0.200
    26.842    31.158     0.200
    26.920    27.353     0.200
    26.941    26.737     0.200
    26.939    26.459     0.200
    26.937    28.447     0.200
    26.930    30.913     0.200
    27.014    26.676     0.200
    27.032    25.456     0.200
    27.031    25.927     0.200
    26.993    30.925     0.200
    26.999    31.774     0.200
    27.054    30.650     0.200
    27.107    29.464     0.200
    27.107    28.765     0.200
    27.161    26.245     0.200
    27.169    26.359     0.200
    27.142    26.823     0.200
    27.185    25.510     0.200
    27.185    25.014     0.200
    27.207    26.343     0.200
    27.194    25.494     0.200
    27.229    24.960     0.200
    27.246    26.943     0.200
    27.246    27.291     0.200
    27.246    27.163     0.200
    27.246    27.316     0.200
    27.309    25.122     0.200
    27.311    25.209     0.200
    27.272    30.771     0.200
    27.329    25.241     0.200
    27.347    25.685     0.200
    27.379    25.845     0.200
    27.379    25.415     0.200
    27.386    24.419     0.200
    27.429    24.629     0.200
    27.446    27.808     0.200
    27.463    25.187     0.200
    27.400    29.728     0.200
    27.400    30.603     0.200
    27.483    25.728     0.200
    27.483    26.463     0.200
    27.491    24.391     0.200
    27.512    24.594     0.200
    27.462    29.609     0.200
    27.541    24.408     0.200
    27.541    25.939     0.200
    27.552    24.473     0.200
    27.552    24.992     0.200
    27.560    24.685     0.200
    27.560    25.130     0.200
    27.615    25.230     0.200
    27.687    26.432     0.200
    27.686    24.260     0.200
    27.686    24.588     0.200
    27.680    28.111     0.200
    27.748    24.266     0.200
    27.769    27.092     0.200
    27.806    24.873     0.200
    27.812    24.723     0.200
    27.828    23.451     0.200
    27.850    24.336     0.200
    27.866    24.340     0.200
    27.830    27.277     0.200
    27.919    22.820     0.200
    27.922    23.262     0.200
    27.977    22.878     0.200
    27.979    26.038     0.200
    27.940    27.845     0.200
    27.992    26.923     0.200
    28.042    23.499     0.200
    28.078    24.979     0.200
    28.078    25.405     0.200
    28.057    28.241     0.200
    28.188    22.326     0.200
    28.212    21.898     0.200
    28.222    24.738     0.200
    28.216    23.097     0.200
    28.216    23.249     0.200
    28.232    22.863     0.200
    28.230    23.012     0.200
    28.281    26.184     0.200
    28.304    23.621     0.200
    28.311    22.467     0.200
    28.311    22.830     0.200
    28.317    24.123     0.200
    28.325    21.743     0.200
    28.355    22.666     0.200
    28.355    22.775     0.200
    28.308    26.261     0.200
    28.376    22.946     0.200
    28.377    22.851     0.200
    28.377    22.691     0.200
    28.381    23.443     0.200
    28.442    22.365     0.200
    28.442    21.959     0.200
    28.445    22.039     0.200
    28.457    25.408     0.200
    28.476    22.407     0.200
    28.476    22.876     0.200
    28.483    23.933     0.200
    28.530    22.444     0.200
    28.534    22.245     0.200
    28.534    22.656     0.200
    28.557    25.714     0.200
    28.593    21.461     0.200
    28.594    21.240     0.200
    28.594    21.839     0.200
    28.465    24.196     0.200
    28.615    24.981     0.200
    28.631    21.017     0.200
    28.674    23.408     0.200
    28.777    23.663     0.200
    28.773    20.644     0.200
    28.781    20.477     0.200
    28.799    21.369     0.200
    28.799    20.889     0.200
    28.805    21.712     0.200
    28.835    22.111     0.200
    28.835    22.657     0.200
    28.844    20.642     0.200
    28.844    21.201     0.200
    28.874    20.476     0.200
    28.900    21.200     0.200
    28.881    19.570     0.200
    28.935    20.748     0.200
    28.940    22.592     0.200
    28.924    22.037     0.200
    28.954    20.403     0.200
    28.980    23.233     0.200
    28.984    21.428     0.200
    29.032    22.033     0.200
    29.032    23.209     0.200
    29.041    20.243     0.200
    29.009    25.969     0.200
    29.143    22.659     0.200
    29.151    19.700     0.200
    29.151    20.728     0.200
    29.162    20.233     0.200
    29.172    19.491     0.200
    29.152    25.254     0.200
    29.232    19.190     0.200
    29.213    22.956     0.200
    29.285    18.742     0.200
    29.292    19.773     0.200
    29.292    20.394     0.200
    29.338    20.491     0.200
    29.345    20.451     0.200
    29.357    22.302     0.200
    29.367    20.378     0.200
    29.381    21.008     0.200
    29.411    18.799     0.200
    29.420    19.730     0.200
    29.443    25.331     0.200
    29.531    20.771     0.200
    29.531    18.372     0.200
    29.545    18.538     0.200
    29.984    14.918     0.200
    29.594    19.542     0.200
    29.616    18.440     0.200
    29.694    19.051     0.200
    29.741    19.076     0.200
    29.747    18.868     0.200
    29.895    17.560     0.200
    29.902    20.260     0.200
    29.941    17.830     0.200
    29.941    17.681     0.200
    29.953    18.952     0.200
    29.950    17.793     0.200
    16.608    41.195     0.200
    16.955    41.590     0.200
    17.312    40.921     0.200
    17.444    40.481     0.200
    18.105    39.908     0.200
    18.383    40.898     0.200
    18.404    40.684     0.200
    18.495    38.513     0.200
    18.495    38.892     0.200
    18.534    39.847     0.200
    18.647    38.841     0.200
    18.647    38.224     0.200
    19.059    38.388     0.200
    19.062    38.584     0.200
    19.073    39.862     0.200
    19.114    38.842     0.200
    19.345    38.781     0.200
    19.386    38.883     0.200
    19.386    38.301     0.200
    19.427    38.469     0.200
    19.460    38.040     0.200
    19.514    38.814     0.200
    19.556    37.956     0.200
    19.634    38.506     0.200
    19.651    38.320     0.200
    19.705    38.435     0.200
    19.719    38.272     0.200
    19.778    37.764     0.200
    19.778    36.643     0.200
    19.795    38.573     0.200
    19.795    37.803     0.200
    19.820    38.246     0.200
    19.820    37.945     0.200
    19.887    37.571     0.200
    19.887    37.376     0.200
    19.909    37.760     0.200
    19.909    37.564     0.200
    20.060    37.648     0.200
    20.080    37.744     0.200
    20.080    37.095     0.200
    20.138    37.799     0.200
    20.162    37.885     0.200
    20.173    38.055     0.200
    20.181    37.750     0.200
    20.217    37.229     0.200
    20.217    38.393     0.200
    20.297    37.332     0.200
    20.351    39.176     0.200
    20.395    37.774     0.200
    20.395    37.582     0.200
    20.487    38.453     0.200
    20.536    38.524     0.200
    20.536    37.579     0.200
    20.536    38.090     0.200
    20.558    38.016     0.200
    20.629    36.769     0.200
    20.633    37.556     0.200
    20.682    37.369     0.200
    20.712    37.433     0.200
    20.743    37.388     0.200
    20.743    36.735     0.200
    20.784    37.998     0.200
    20.784    36.545     0.200
    20.859    36.422     0.200
    20.899    37.099     0.200
    20.899    36.490     0.200
    20.927    36.923     0.200
    20.996    37.538     0.200
    21.115    37.004     0.200
    21.159    37.012     0.200
    21.243    36.023     0.200
    21.204    39.601     0.200
    21.204    40.612     0.200
    21.307    36.866     0.200
    21.302    36.448     0.200
    21.334    37.543     0.200
    21.375    40.288     0.200
    21.492    36.787     0.200
    21.514    35.881     0.200
    21.497    38.842     0.200
    21.497    37.627     0.200
    21.646    36.022     0.200
    21.671    36.182     0.200
    21.671    35.374     0.200
    21.689    35.362     0.200
    21.695    36.483     0.200
    21.721    36.649     0.200
    21.721    35.989     0.200
    21.730    36.252     0.200
    21.694    39.548     0.200
    21.707    39.394     0.200
    21.747    39.675     0.200
    21.794    36.387     0.200
    21.787    38.661     0.200
    21.787    37.586     0.200
    21.817    36.275     0.200
    21.808    39.092     0.200
    21.896    35.966     0.200
    21.935    35.069     0.200
    21.935    36.077     0.200
    21.936    36.250     0.200
    21.936    36.429     0.200
    22.026    36.010     0.200
    22.026    35.623     0.200
    22.001    39.061     0.200
    22.051    35.417     0.200
    22.051    35.936     0.200
    22.056    35.427     0.200
    22.056    34.689     0.200
    22.058    35.405     0.200
    22.052    39.430     0.200
    22.107    35.780     0.200
    22.107    35.100     0.200
    22.066    37.959     0.200
    22.128    35.893     0.200
    22.189    39.062     0.200
    22.226    38.957     0.200
    22.296    36.064     0.200
    22.286    37.081     0.200
    22.286    36.143     0.200
    22.306    35.535     0.200
    22.357    35.248     0.200
    22.357    35.002     0.200
    22.381    35.771     0.200
    22.432    34.371     0.200
    22.432    35.093     0.200
    22.511    35.262     0.200
    22.477    38.790     0.200
    22.477    38.212     0.200
    22.571    34.500     0.200
    22.543    37.604     0.200
    22.612    34.841     0.200
    22.613    34.052     0.200
    22.564    38.260     0.200
    22.566    38.179     0.200
    22.566    37.905     0.200
    22.604    37.143     0.200
    22.661    34.947     0.200
    22.658    37.011     0.200
    22.733    35.524     0.200
    22.743    34.627     0.200
    22.773    35.657     0.200
    22.775    33.730     0.200
    22.757    37.060     0.200
    22.771    36.546     0.200
    22.776    36.881     0.200
    22.830    34.451     0.200
    22.833    34.767     0.200
    22.853    36.208     0.200
    22.865    36.343     0.200
    22.923    34.411     0.200
    22.897    36.668     0.200
    22.902    36.203     0.200
    22.912    36.110     0.200
    22.927    36.173     0.200
    22.958    34.046     0.200
    22.937    37.692     0.200
    22.961    36.383     0.200
    22.970    36.084     0.200
    23.006    34.722     0.200
    23.006    34.398     0.200
    22.999    36.633     0.200
    23.017    36.463     0.200
    23.006    37.500     0.200
    23.085    36.472     0.200
    23.114    35.048     0.200
    23.093    36.546     0.200
    23.172    34.131     0.200
    23.166    36.528     0.200
    23.174    36.463     0.200
    23.199    36.220     0.200
    23.270    33.888     0.200
    23.268    37.327     0.200
    23.318    33.859     0.200
    23.318    33.324     0.200
    23.342    33.018     0.200
    23.292    38.159     0.200
    23.384    34.834     0.200
    23.351    37.362     0.200
    23.406    35.712     0.200
    23.484    34.267     0.200
    23.486    33.659     0.200
    23.452    36.158     0.200
    23.492    35.671     0.200
    23.512    33.982     0.200
    23.490    34.195     0.200
    23.501    35.190     0.200
    23.501    35.936     0.200
    23.546    33.655     0.200
    23.576    33.499     0.200
    23.563    37.372     0.200
    23.684    34.711     0.200
    23.694    34.494     0.200
    23.645    37.323     0.200
    23.745    34.009     0.200
    23.745    33.149     0.200
    23.768    33.406     0.200
    23.768    32.949     0.200
    23.721    36.847     0.200
    23.881    33.876     0.200
    23.863    36.198     0.200
    23.866    35.179     0.200
    23.917    33.793     0.200
    23.920    34.698     0.200
    23.920    34.124     0.200
    23.933    33.915     0.200
    23.981    33.897     0.200
    23.982    33.277     0.200
    23.950    34.987     0.200
    23.958    36.635     0.200
    23.958    35.440     0.200
    23.956    35.483     0.200
    23.969    35.056     0.200
    24.014    33.429     0.200
    24.028    32.827     0.200
    24.044    33.782     0.200
    24.044    33.180     0.200
    24.000    35.282     0.200
    24.084    32.652     0.200
    24.098    35.675     0.200
    24.153    34.677     0.200
    24.153    34.017     0.200
    24.146    36.240     0.200
    24.179    34.082     0.200
    24.263    33.342     0.200
    24.282    32.548     0.200
    24.264    33.684     0.200
    24.302    32.740     0.200
    24.302    32.408     0.200
    24.301    32.824     0.200
    24.362    31.944     0.200
    24.362    32.436     0.200
    24.359    35.326     0.200
    24.412    32.632     0.200
    24.424    32.351     0.200
    24.435    32.186     0.200
    24.424    34.757     0.200
    24.424    34.312     0.200
    24.520    32.725     0.200
    24.520    31.815     0.200
    24.561    32.868     0.200
    24.561    32.126     0.200
    24.512    34.990     0.200
    24.577    32.704     0.200
    24.608    32.551     0.200
    24.584    33.921     0.200
    24.588    34.709     0.200
    24.623    33.446     0.200
    24.684    31.495     0.200
    24.716    31.805     0.200
    24.763    31.990     0.200
    24.760    34.711     0.200
    24.837    34.352     0.200
    24.902    30.781     0.200
    24.902    29.930     0.200
    24.870    34.462     0.200
    24.870    34.138     0.200
    24.887    34.256     0.200
    24.929    31.532     0.200
    24.880    32.456     0.200
    24.967    31.106     0.200
    24.996    30.828     0.200
    25.014    30.854     0.200
    25.014    30.237     0.200
    24.982    32.753     0.200
    25.023    31.470     0.200
    25.023    30.466     0.200
    25.069    30.288     0.200
    25.082    31.317     0.200
    25.082    30.704     0.200
    25.031    33.728     0.200
    25.124    30.800     0.200
    25.124    30.074     0.200
    25.165    31.196     0.200
    25.189    30.435     0.200
    25.190    30.297     0.200
    25.214    31.025     0.200
    25.214    30.893     0.200
    25.218    30.193     0.200
    25.218    29.728     0.200
    25.201    31.308     0.200
    25.180    33.201     0.200
    25.180    33.314     0.200
    25.195    33.881     0.200
    25.280    30.230     0.200
    25.280    29.183     0.200
    25.319    29.986     0.200
    25.319    29.119     0.200
    25.340    30.013     0.200
    25.340    29.419     0.200
    25.367    30.127     0.200
    25.367    29.299     0.200
    25.372    31.231     0.200
    25.413    30.381     0.200
    25.475    30.048     0.200
    25.475    29.220     0.200
    25.485    32.245     0.200
    25.493    32.464     0.200
    25.499    32.979     0.200
    25.629    29.189     0.200
    25.629    28.978     0.200
    25.635    30.021     0.200
    25.561    34.712     0.200
    25.647    29.249     0.200
    25.624    32.447     0.200
    25.664    32.410     0.200
    25.721    28.458     0.200
    25.729    29.320     0.200
    25.740    29.901     0.200
    25.763    28.843     0.200
    25.763    28.476     0.200
    25.853    29.870     0.200
    25.829    29.636     0.200
    25.894    28.757     0.200
    25.898    28.941     0.200
    25.898    27.852     0.200
    25.904    29.292     0.200
    25.910    29.048     0.200
    25.959    29.453     0.200
    25.911    32.336     0.200
    25.965    30.634     0.200
    25.965    30.841     0.200
    26.016    31.881     0.200
    26.127    27.866     0.200
    26.137    28.277     0.200
    26.199    27.375     0.200
    26.199    26.722     0.200
    26.154    30.353     0.200
    26.219    28.740     0.200
    26.300    28.079     0.200
    26.300    27.532     0.200
    26.277    28.676     0.200
    26.324    27.748     0.200
    26.336    27.358     0.200
    26.336    26.612     0.200
    26.300    29.803     0.200
    26.424    27.909     0.200
    26.424    27.140     0.200
    26.372    29.510     0.200
    26.431    28.648     0.200
    26.431    27.664     0.200
    26.470    27.292     0.200
    26.470    25.640     0.200
    26.484    27.797     0.200
    26.484    26.859     0.200
    26.491    27.302     0.200
    26.491    27.903     0.200
    26.425    31.432     0.200
    26.544    26.734     0.200
    26.544    25.683     0.200
    26.545    26.357     0.200
    26.585    27.523     0.200
    26.586    27.245     0.200
    26.594    26.603     0.200
    26.681    27.906     0.200
    26.725    26.894     0.200
    26.660    30.401     0.200
    26.710    31.512     0.200
    26.768    28.270     0.200
    26.807    26.179     0.200
    26.765    29.786     0.200
    26.828    26.661     0.200
    26.832    26.015     0.200
    26.832    25.429     0.200
    26.832    26.054     0.200
    26.832    25.589     0.200
    26.805    27.660     0.200
    26.845    26.654     0.200
    26.860    25.454     0.200
    26.860    25.106     0.200
    26.876    26.489     0.200
    26.844    28.290     0.200
    26.902    28.797     0.200
    26.975    25.842     0.200
    26.975    25.533     0.200
    27.016    26.240     0.200
    27.016    25.787     0.200
    26.980    28.972     0.200
    27.038    26.135     0.200
    27.066    26.585     0.200
    27.056    29.350     0.200
    27.056    28.772     0.200
    27.101    26.164     0.200
    27.106    24.883     0.200
    27.111    25.240     0.200
    27.225    24.850     0.200
    27.159    30.525     0.200
    27.240    24.352     0.200
    27.240    24.477     0.200
    27.233    26.247     0.200
    27.233    26.735     0.200
    27.233    26.567     0.200
    27.233    26.738     0.200
    27.233    26.164     0.200
    27.274    25.302     0.200
    27.301    23.836     0.200
    27.301    25.627     0.200
    27.319    26.326     0.200
    27.335    25.747     0.200
    27.393    24.408     0.200
    27.409    25.275     0.200
    27.420    25.460     0.200
    27.411    26.840     0.200
    27.411    25.965     0.200
    27.450    23.835     0.200
    27.450    23.159     0.200
    27.413    26.335     0.200
    27.467    24.151     0.200
    27.467    22.635     0.200
    27.479    24.813     0.200
    27.479    23.837     0.200
    27.506    24.119     0.200
    27.506    23.213     0.200
    27.491    24.929     0.200
    27.491    25.695     0.200
    27.551    24.817     0.200
    27.551    24.063     0.200
    27.573    24.188     0.200
    27.574    23.940     0.200
    27.574    22.584     0.200
    27.567    25.156     0.200
    27.567    23.683     0.200
    27.646    24.030     0.200
    27.669    23.965     0.200
    27.710    24.507     0.200
    27.710    23.632     0.200
    27.705    25.225     0.200
    27.760    23.811     0.200
    27.760    22.811     0.200
    27.827    23.539     0.200
    27.904    24.468     0.200
    27.912    22.895     0.200
    27.912    22.508     0.200
    27.956    23.804     0.200
    27.922    25.197     0.200
    27.991    22.534     0.200
    27.961    26.436     0.200
    27.945    26.457     0.200
    28.021    23.357     0.200
    28.021    22.021     0.200
    28.053    22.638     0.200
    28.139    22.617     0.200
    28.139    22.129     0.200
    28.143    24.275     0.200
    28.207    24.001     0.200
    28.262    21.985     0.200
    28.229    24.593     0.200
    28.293    21.556     0.200
    28.293    21.064     0.200
    28.288    22.844     0.200
    28.317    21.991     0.200
    28.325    22.490     0.200
    28.303    23.397     0.200
    28.389    21.676     0.200
    28.394    22.268     0.200
    28.406    24.413     0.200
    28.465    22.645     0.200
    28.472    22.927     0.200
    28.472    22.224     0.200
    28.474    22.272     0.200
    28.474    21.397     0.200
    28.468    22.002     0.200
    28.500    21.460     0.200
    28.500    20.854     0.200
    28.565    22.259     0.200
    28.565    21.330     0.200
    28.565    23.784     0.200
    28.626    22.099     0.200
    28.634    22.224     0.200
    28.665    21.031     0.200
    28.668    21.184     0.200
    28.681    21.183     0.200
    28.659    22.750     0.200
    28.563    23.351     0.200
    28.711    20.638     0.200
    28.763    22.481     0.200
    28.851    20.389     0.200
    28.874    19.492     0.200
    28.874    20.730     0.200
    28.898    21.950     0.200
    28.919    20.263     0.200
    28.919    19.712     0.200
    28.928    20.306     0.200
    28.928    19.939     0.200
    28.884    23.004     0.200
    28.992    21.264     0.200
    28.966    21.734     0.200
    29.012    19.962     0.200
    29.019    22.973     0.200
    29.019    21.805     0.200
    29.081    21.255     0.200
    29.113    19.410     0.200
    29.221    20.061     0.200
    29.221    17.604     0.200
    29.197    22.975     0.200
    29.245    20.390     0.200
    29.251    20.013     0.200
    29.253    18.874     0.200
    29.253    18.300     0.200
    29.282    18.840     0.200
    29.344    20.888     0.200
    29.373    20.790     0.200
    29.373    20.633     0.200
    29.377    20.622     0.200
    29.431    20.124     0.200
    29.431    19.558     0.200
    29.462    19.132     0.200
    29.462    18.721     0.200
    29.473    18.492     0.200
    29.473    17.887     0.200
    29.457    20.065     0.200
    29.494    18.401     0.200
    29.612    18.557     0.200
    29.656    20.286     0.200
    29.684    18.890     0.200
    29.684    18.398     0.200
    29.692    17.960     0.200
    29.692    16.648     0.200
    29.790    19.508     0.200
    29.835    18.610     0.200
    29.835    17.887     0.200
    29.835    18.629     0.200
    29.909    16.306     0.200
    29.884    18.088     0.200
    29.968    17.331     0.200
    15.304    42.529     0.200
    15.304    41.658     0.200
    15.580    40.572     0.200
    15.682    43.091     0.200
    15.682    39.861     0.200
    15.750    41.401     0.200
    15.750    40.506     0.200
    15.719    44.484     0.200
    16.084    40.725     0.200
    16.084    43.916     0.200
    16.734    41.837     0.200
    17.129    43.281     0.200
    17.129    42.558     0.200
    17.893    40.058     0.200
    18.235    41.692     0.200
    18.215    42.860     0.200
    18.215    41.957     0.200
    18.351    41.294     0.200
    18.604    38.711     0.200
    18.770    39.119     0.200
    18.770    38.595     0.200
    18.935    40.385     0.200
    19.160    38.926     0.200
    19.191    38.613     0.200
    19.406    38.775     0.200
    19.474    39.283     0.200
    19.587    38.843     0.200
    19.587    38.237     0.200
    19.682    38.547     0.200
    20.021    38.025     0.200
    20.151    36.820     0.200
    20.163    40.435     0.200
    20.163    39.771     0.200
    20.285    37.861     0.200
    20.504    38.163     0.200
    20.504    37.053     0.200
    20.605    39.606     0.200
    20.624    39.613     0.200
    20.766    36.646     0.200
    20.772    37.741     0.200
    20.772    37.499     0.200
    20.922    36.846     0.200
    20.966    36.974     0.200
    20.966    36.283     0.200
    20.981    35.970     0.200
    21.040    37.884     0.200
    21.040    36.532     0.200
    20.931    39.711     0.200
    21.049    37.006     0.200
    21.081    36.600     0.200
    21.108    36.778     0.200
    21.108    36.368     0.200
    21.239    37.030     0.200
    21.169    41.131     0.200
    21.169    37.923     0.200
    21.270    36.249     0.200
    21.297    36.668     0.200
    21.279    40.698     0.200
    21.279    40.151     0.200
    21.414    36.167     0.200
    21.437    37.086     0.200
    21.391    39.287     0.200
    21.391    38.080     0.200
    21.406    40.531     0.200
    21.424    39.943     0.200
    21.587    37.067     0.200
    21.495    40.359     0.200
    21.655    35.794     0.200
    21.633    38.860     0.200
    21.730    35.945     0.200
    21.798    36.622     0.200
    21.729    40.719     0.200
    21.763    40.452     0.200
    21.889    35.800     0.200
    21.773    39.585     0.200
    21.914    35.744     0.200
    21.949    37.163     0.200
    21.924    36.987     0.200
    21.956    35.575     0.200
    21.993    36.508     0.200
    22.028    37.234     0.200
    21.925    40.259     0.200
    21.986    38.656     0.200
    22.117    34.981     0.200
    22.117    35.239     0.200
    22.156    38.398     0.200
    22.254    35.561     0.200
    22.254    34.843     0.200
    22.229    37.685     0.200
    22.229    36.423     0.200
    22.271    34.933     0.200
    22.275    36.813     0.200
    22.275    35.099     0.200
    22.310    35.206     0.200
    22.339    38.039     0.200
    22.339    35.414     0.200
    22.284    39.465     0.200
    22.284    40.532     0.200
    22.284    38.504     0.200
    22.406    37.391     0.200
    22.291    39.794     0.200
    22.333    37.993     0.200
    22.549    37.804     0.200
    22.552    36.711     0.200
    22.552    35.402     0.200
    22.509    36.849     0.200
    22.573    37.684     0.200
    22.510    37.343     0.200
    22.578    36.671     0.200
    22.578    34.812     0.200
    22.719    35.296     0.200
    22.745    34.197     0.200
    22.771    34.866     0.200
    22.702    36.933     0.200
    22.713    37.117     0.200
    22.675    39.257     0.200
    22.747    37.061     0.200
    22.759    36.550     0.200
    22.839    36.835     0.200
    22.719    38.560     0.200
    22.775    36.814     0.200
    22.794    37.223     0.200
    22.814    36.875     0.200
    22.819    36.930     0.200
    22.893    34.596     0.200
    22.903    37.761     0.200
    22.848    36.715     0.200
    22.925    33.781     0.200
    22.864    36.604     0.200
    22.945    36.388     0.200
    23.051    35.909     0.200
    23.058    38.504     0.200
    23.091    35.549     0.200
    23.024    36.644     0.200
    23.080    36.570     0.200
    23.058    37.551     0.200
    23.153    34.178     0.200
    23.153    33.736     0.200
    23.172    36.028     0.200
    23.185    34.685     0.200
    23.083    38.736     0.200
    23.242    36.352     0.200
    23.242    34.813     0.200
    23.206    37.804     0.200
    23.238    37.156     0.200
    23.402    35.784     0.200
    23.400    34.329     0.200
    23.305    38.856     0.200
    23.403    36.387     0.200
    23.403    35.695     0.200
    23.346    38.343     0.200
    23.543    35.138     0.200
    23.543    34.337     0.200
    23.603    34.086     0.200
    23.652    35.320     0.200
    23.727    35.368     0.200
    23.733    33.405     0.200
    23.744    33.508     0.200
    23.743    33.277     0.200
    23.659    37.416     0.200
    23.749    35.509     0.200
    23.669    37.174     0.200
    23.759    35.300     0.200
    23.691    37.868     0.200
    23.691    36.876     0.200
    23.739    37.103     0.200
    23.730    36.386     0.200
    23.710    37.212     0.200
    23.842    37.522     0.200
    23.967    33.092     0.200
    23.967    32.584     0.200
    23.977    33.225     0.200
    23.977    32.772     0.200
    23.977    33.254     0.200
    23.978    34.784     0.200
    24.013    35.142     0.200
    24.061    35.185     0.200
    24.108    34.228     0.200
    24.155    34.646     0.200
    24.075    35.504     0.200
    24.078    36.536     0.200
    24.209    33.644     0.200
    24.210    35.233     0.200
    24.210    34.717     0.200
    24.233    33.967     0.200
    24.235    32.980     0.200
    24.239    32.472     0.200
    24.251    33.274     0.200
    24.272    33.539     0.200
    24.285    34.610     0.200
    24.285    32.888     0.200
    24.264    34.945     0.200
    24.293    35.765     0.200
    24.293    34.214     0.200
    24.316    36.527     0.200
    24.411    34.361     0.200
    24.412    34.879     0.200
    24.510    33.520     0.200
    24.526    33.215     0.200
    24.526    32.129     0.200
    24.531    33.599     0.200
    24.542    32.544     0.200
    24.542    31.985     0.200
    24.543    32.808     0.200
    24.526    34.424     0.200
    24.526    33.904     0.200
    24.591    33.753     0.200
    24.571    33.293     0.200
    24.630    32.139     0.200
    24.631    32.828     0.200
    24.640    33.053     0.200
    24.624    35.768     0.200
    24.624    35.268     0.200
    24.622    35.644     0.200
    24.779    32.426     0.200
    24.779    31.778     0.200
    24.855    32.757     0.200
    24.774    34.020     0.200
    24.746    35.879     0.200
    24.840    32.631     0.200
    24.968    31.771     0.200
    24.987    31.018     0.200
    24.903    34.809     0.200
    24.903    34.266     0.200
    25.034    33.067     0.200
    25.034    31.247     0.200
    25.057    32.688     0.200
    25.232    30.788     0.200
    25.239    30.415     0.200
    25.248    30.903     0.200
    25.248    30.000     0.200
    25.201    32.569     0.200
    25.185    32.980     0.200
    25.191    34.397     0.200
    25.334    31.402     0.200
    25.334    30.203     0.200
    25.337    30.751     0.200
    25.337    30.063     0.200
    25.227    33.936     0.200
    25.349    30.817     0.200
    25.358    30.923     0.200
    25.358    29.927     0.200
    25.369    30.826     0.200
    25.395    31.086     0.200
    25.446    30.100     0.200
    25.446    29.686     0.200
    25.454    31.429     0.200
    25.454    30.359     0.200
    25.480    30.096     0.200
    25.397    33.881     0.200
    25.397    32.791     0.200
    25.384    33.998     0.200
    25.537    31.571     0.200
    25.609    30.454     0.200
    25.609    29.743     0.200
    25.609    30.957     0.200
    25.609    28.593     0.200
    25.630    30.171     0.200
    25.647    30.934     0.200
    25.582    33.724     0.200
    25.701    29.100     0.200
    25.733    29.784     0.200
    25.733    29.436     0.200
    25.800    29.845     0.200
    25.855    29.061     0.200
    25.782    31.815     0.200
    25.782    30.725     0.200
    25.882    29.883     0.200
    25.977    29.360     0.200
    26.005    29.005     0.200
    26.051    28.912     0.200
    26.092    28.325     0.200
    26.131    28.865     0.200
    26.011    30.659     0.200
    26.164    29.221     0.200
    26.115    29.097     0.200
    26.222    28.663     0.200
    26.295    28.185     0.200
    26.295    27.650     0.200
    26.312    27.819     0.200
    26.353    27.953     0.200
    26.333    30.147     0.200
    26.333    28.362     0.200
    26.462    28.239     0.200
    26.538    27.309     0.200
    26.538    26.477     0.200
    26.569    28.078     0.200
    26.569    26.738     0.200
    26.501    28.869     0.200
    26.605    27.052     0.200
    26.605    26.317     0.200
    26.656    27.275     0.200
    26.656    25.904     0.200
    26.576    29.618     0.200
    26.582    28.981     0.200
    26.705    27.500     0.200
    26.705    26.578     0.200
    26.633    27.962     0.200
    26.720    26.804     0.200
    26.736    27.735     0.200
    26.736    26.903     0.200
    26.639    29.403     0.200
    26.787    26.739     0.200
    26.835    27.432     0.200
    26.847    27.349     0.200
    26.807    29.601     0.200
    26.807    29.601     0.200
    26.807    29.320     0.200
    26.830    30.950     0.200
    27.006    27.195     0.200
    27.011    27.284     0.200
    27.015    26.194     0.200
    27.015    25.257     0.200
    27.020    25.916     0.200
    27.000    27.879     0.200
    27.000    26.618     0.200
    27.024    25.898     0.200
    27.024    25.367     0.200
    27.033    25.972     0.200
    27.033    24.753     0.200
    27.084    26.577     0.200
    27.103    26.568     0.200
    27.107    26.500     0.200
    26.994    30.737     0.200
    27.102    28.055     0.200
    27.102    27.242     0.200
    27.102    27.380     0.200
    27.102    27.122     0.200
    27.102    26.583     0.200
    27.070    28.619     0.200
    27.073    28.114     0.200
    27.164    27.022     0.200
    27.272    26.254     0.200
    27.171    28.173     0.200
    27.277    24.886     0.200
    27.208    27.553     0.200
    27.301    24.724     0.200
    27.305    26.084     0.200
    27.321    27.832     0.200
    27.342    26.072     0.200
    27.427    26.864     0.200
    27.418    28.021     0.200
    27.548    24.991     0.200
    27.464    27.891     0.200
    27.601    24.106     0.200
    27.657    25.257     0.200
    27.657    24.828     0.200
    27.662    24.517     0.200
    27.662    23.974     0.200
    27.670    25.274     0.200
    27.556    28.469     0.200
    27.684    24.046     0.200
    27.684    23.757     0.200
    27.751    23.871     0.200
    27.654    26.683     0.200
    27.772    23.698     0.200
    27.776    26.074     0.200
    27.776    24.995     0.200
    27.710    26.525     0.200
    27.862    24.027     0.200
    27.822    25.790     0.200
    27.929    23.568     0.200
    27.929    22.622     0.200
    27.961    24.255     0.200
    27.961    22.950     0.200
    28.001    24.398     0.200
    27.976    26.660     0.200
    28.118    22.985     0.200
    28.118    22.696     0.200
    28.067    24.860     0.200
    28.146    24.303     0.200
    28.147    24.981     0.200
    28.226    24.013     0.200
    28.165    25.274     0.200
    28.228    22.485     0.200
    28.289    23.651     0.200
    28.289    22.472     0.200
    28.304    23.890     0.200
    28.329    24.125     0.200
    28.397    23.271     0.200
    28.319    25.909     0.200
    28.430    22.426     0.200
    28.573    23.055     0.200
    28.520    22.949     0.200
    28.611    20.967     0.200
    28.628    23.557     0.200
    28.693    22.570     0.200
    28.709    22.887     0.200
    28.709    21.785     0.200
    28.730    21.870     0.200
    28.730    20.784     0.200
    28.620    24.453     0.200
    28.822    20.691     0.200
    28.878    21.795     0.200
    28.983    21.440     0.200
    28.983    19.604     0.200
    29.046    20.946     0.200
    29.046    20.337     0.200
    28.945    23.776     0.200
    29.000    21.819     0.200
    29.140    21.419     0.200
    29.227    21.885     0.200
    29.277    19.579     0.200
    29.181    22.857     0.200
    29.257    21.953     0.200
    29.257    21.383     0.200
    29.469    21.594     0.200
    29.672    19.594     0.200
    29.869    18.511     0.200
    29.869    16.948     0.200
    29.914    18.465     0.200
    29.914    18.336     0.200
    29.850    21.283     0.200
    29.921    20.543     0.200
    18.658    39.168     0.200
    18.759    38.469     0.200
    19.502    38.978     0.200
    19.878    36.403     0.200
    20.062    38.491     0.200
    20.100    36.232     0.200
    20.294    38.151     0.200
    20.950    38.387     0.200
    21.090    36.822     0.200
    22.842    35.908     0.200
    23.097    33.807     0.200
    23.438    35.216     0.200
    23.758    33.831     0.200
    24.010    33.191     0.200
    24.785    31.755     0.200
    26.555    27.806     0.200
    26.632    27.843     0.200
    26.632    26.952     0.200
    26.820    25.528     0.200
    26.820    24.974     0.200
    26.988    26.333     0.200
    14.120    43.476     0.200
    15.328    42.826     0.200
    15.778    43.208     0.200
    16.892    38.736     0.200
    17.007    40.873     0.200
    16.938    42.637     0.200
    17.364    42.298     0.200
    17.607    39.573     0.200
    17.609    41.138     0.200
    17.870    39.960     0.200
    17.911    39.229     0.200
    17.944    40.023     0.200
    18.427    42.689     0.200
    18.427    42.193     0.200
    18.582    39.336     0.200
    18.562    39.971     0.200
    19.144    40.756     0.200
    19.086    40.574     0.200
    19.086    41.508     0.200
    19.294    38.834     0.200
    19.419    39.673     0.200
    19.506    37.763     0.200
    19.544    38.792     0.200
    19.571    39.128     0.200
    19.749    38.308     0.200
    19.911    39.611     0.200
    19.991    36.715     0.200
    19.919    41.481     0.200
    20.031    38.701     0.200
    20.142    37.956     0.200
    20.196    38.254     0.200
    20.294    36.792     0.200
    20.302    37.797     0.200
    20.301    37.901     0.200
    20.347    41.070     0.200
    20.482    38.055     0.200
    20.482    38.329     0.200
    20.356    41.087     0.200
    20.536    38.392     0.200
    20.598    37.396     0.200
    20.472    39.501     0.200
    20.725    38.850     0.200
    20.725    40.135     0.200
    20.858    37.424     0.200
    20.906    35.427     0.200
    20.966    37.318     0.200
    20.843    40.314     0.200
    21.011    37.406     0.200
    21.115    37.168     0.200
    21.214    37.408     0.200
    21.167    41.226     0.200
    21.167    40.964     0.200
    21.390    35.211     0.200
    21.364    39.446     0.200
    21.364    41.106     0.200
    21.521    38.401     0.200
    21.521    38.933     0.200
    21.609    36.813     0.200
    21.632    37.087     0.200
    21.804    36.429     0.200
    21.845    36.592     0.200
    21.719    40.627     0.200
    21.794    38.887     0.200
    21.794    38.762     0.200
    21.825    39.267     0.200
    22.040    36.487     0.200
    22.040    37.085     0.200
    22.146    36.280     0.200
    22.173    36.485     0.200
    22.173    37.200     0.200
    22.165    36.083     0.200
    22.170    36.199     0.200
    22.224    36.710     0.200
    22.156    39.786     0.200
    22.202    39.956     0.200
    22.325    36.960     0.200
    22.471    35.770     0.200
    22.459    36.245     0.200
    22.448    35.994     0.200
    22.522    36.127     0.200
    22.530    38.456     0.200
    22.680    36.099     0.200
    22.528    39.248     0.200
    22.526    39.581     0.200
    22.526    39.171     0.200
    22.706    35.191     0.200
    22.905    39.018     0.200
    23.074    34.808     0.200
    23.076    35.192     0.200
    23.124    34.455     0.200
    23.219    36.937     0.200
    23.255    37.927     0.200
    23.253    39.903     0.200
    23.433    34.680     0.200
    23.465    34.716     0.200
    23.316    39.222     0.200
    23.397    37.401     0.200
    23.438    37.341     0.200
    23.606    35.113     0.200
    23.528    35.857     0.200
    23.528    36.299     0.200
    23.629    34.058     0.200
    23.629    34.839     0.200
    23.678    33.290     0.200
    23.532    38.256     0.200
    23.685    33.227     0.200
    23.862    33.636     0.200
    23.856    37.073     0.200
    23.855    36.501     0.200
    23.938    36.592     0.200
    23.946    36.379     0.200
    24.106    33.797     0.200
    24.136    34.273     0.200
    24.163    33.277     0.200
    24.068    36.447     0.200
    24.182    35.220     0.200
    24.300    33.270     0.200
    24.259    35.608     0.200
    24.417    33.341     0.200
    24.417    34.075     0.200
    24.467    33.577     0.200
    24.467    34.097     0.200
    24.320    36.108     0.200
    24.505    32.128     0.200
    24.439    35.618     0.200
    24.643    33.454     0.200
    24.627    32.437     0.200
    24.581    33.791     0.200
    24.552    36.174     0.200
    24.650    34.311     0.200
    24.601    34.517     0.200
    24.807    35.005     0.200
    24.844    34.565     0.200
    24.844    35.175     0.200
    24.959    32.859     0.200
    24.970    33.523     0.200
    25.101    30.549     0.200
    25.203    31.831     0.200
    25.237    30.575     0.200
    25.142    33.131     0.200
    25.142    34.417     0.200
    25.212    32.699     0.200
    25.390    30.078     0.200
    25.464    29.500     0.200
    25.374    32.343     0.200
    25.479    32.789     0.200
    25.460    33.376     0.200
    25.470    33.984     0.200
    25.606    31.891     0.200
    25.606    33.031     0.200
    25.625    33.390     0.200
    25.809    30.152     0.200
    26.031    28.586     0.200
    25.963    29.933     0.200
    25.963    31.667     0.200
    25.984    32.259     0.200
    26.233    27.508     0.200
    26.283    27.521     0.200
    26.202    30.063     0.200
    26.541    27.277     0.200
    26.610    26.665     0.200
    26.610    28.204     0.200
    26.632    24.618     0.200
    26.773    28.571     0.200
    26.733    30.770     0.200
    26.938    25.502     0.200
    26.942    25.594     0.200
    26.962    26.045     0.200
    27.039    26.740     0.200
    26.912    29.802     0.200
    27.138    26.745     0.200
    27.004    29.092     0.200
    27.029    29.727     0.200
    27.249    26.143     0.200
    27.249    27.381     0.200
    27.326    24.724     0.200
    27.249    26.824     0.200
    27.249    27.394     0.200
    27.292    28.011     0.200
    27.337    26.727     0.200
    27.401    28.310     0.200
    27.401    26.787     0.200
    27.538    22.964     0.200
    27.389    27.269     0.200
    27.679    25.630     0.200
    27.831    24.334     0.200
    27.691    27.135     0.200
    27.934    25.721     0.200
    28.024    24.380     0.200
    28.155    24.243     0.200
    28.220    24.327     0.200
    28.201    26.233     0.200
    28.316    24.177     0.200
    28.681    22.294     0.200
    28.977    21.076     0.200
    29.394    20.892     0.200
    29.394    21.654     0.200
    29.448    19.050     0.200
    29.472    20.250     0.200
    29.480    20.797     0.200
    29.480    21.715     0.200
    29.800    19.099     0.200
    29.755    19.180     0.200
    29.794    20.628     0.200
    29.880    20.174     0.200
    15.853    38.620     0.200
    17.590    39.638     0.200
    17.884    39.139     0.200
    18.105    39.951     0.200
    18.228    38.900     0.200
    18.260    38.554     0.200
    18.821    38.822     0.200
    18.988    38.037     0.200
    19.218    38.173     0.200
    19.220    37.986     0.200
    19.614    37.690     0.200
    19.932    37.357     0.200
    19.978    37.311     0.200
    20.216    37.494     0.200
    20.420    37.921     0.200
    20.561    35.013     0.200
    20.659    35.976     0.200
    21.103    37.799     0.200
    21.220    37.126     0.200
    21.508    36.102     0.200
    21.509    36.395     0.200
    21.731    35.033     0.200
    21.860    34.067     0.200
    21.870    33.825     0.200
    22.012    35.375     0.200
    22.137    35.168     0.200
    22.173    35.029     0.200
    22.995    35.435     0.200
    23.137    34.842     0.200
    23.335    32.158     0.200
    23.335    33.115     0.200
    23.568    33.541     0.200
    23.872    32.770     0.200
    23.902    34.516     0.200
    24.146    33.125     0.200
    24.300    33.385     0.200
    24.917    29.887     0.200
    24.936    29.874     0.200
    24.923    29.811     0.200
    25.042    30.643     0.200
    25.369    30.203     0.200
    25.924    27.963     0.200
    26.147    27.536     0.200
    26.247    27.718     0.200
    26.301    26.188     0.200
    26.490    27.107     0.200
    26.648    26.056     0.200
    26.715    26.821     0.200
    26.791    28.572     0.200
    26.955    25.748     0.200
    26.955    26.310     0.200
    26.955    25.720     0.200
    26.955    25.860     0.200
    27.246    25.044     0.200
    28.025    22.179     0.200
    14.626    39.562     0.200
    15.100    39.497     0.200
    15.100    38.981     0.200
    16.269    39.737     0.200
    16.292    41.822     0.200
    16.979    39.523     0.200
    17.161    39.492     0.200
    17.182    40.515     0.200
    17.471    40.621     0.200
    17.471    40.003     0.200
    17.718    41.576     0.200
    17.768    41.984     0.200
    17.768    40.030     0.200
    18.232    37.651     0.200
    18.294    37.499     0.200
    18.308    37.036     0.200
    18.308    37.473     0.200
    18.439    39.055     0.200
    18.448    38.225     0.200
    18.621    37.417     0.200
    18.679    37.250     0.200
    18.753    38.172     0.200
    18.753    38.711     0.200
    18.827    37.825     0.200
    18.848    38.424     0.200
    18.867    35.949     0.200
    18.920    36.861     0.200
    19.008    37.125     0.200
    19.029    36.568     0.200
    19.100    37.908     0.200
    19.100    36.119     0.200
    19.114    37.764     0.200
    19.154    39.273     0.200
    19.213    37.391     0.200
    19.257    37.491     0.200
    19.272    37.875     0.200
    19.363    37.248     0.200
    19.471    36.864     0.200
    19.506    36.823     0.200
    19.589    37.004     0.200
    19.768    36.902     0.200
    19.797    36.750     0.200
    19.802    36.983     0.200
    19.821    36.953     0.200
    19.837    36.438     0.200
    19.857    34.364     0.200
    19.951    37.510     0.200
    19.958    36.616     0.200
    20.013    36.250     0.200
    20.037    36.814     0.200
    20.053    36.818     0.200
    20.067    36.884     0.200
    20.067    37.298     0.200
    20.077    36.895     0.200
    20.077    36.489     0.200
    20.114    37.110     0.200
    20.113    36.910     0.200
    20.120    36.258     0.200
    20.119    36.223     0.200
    20.152    37.142     0.200
    20.162    36.731     0.200
    20.222    37.859     0.200
    20.227    37.401     0.200
    20.253    37.387     0.200
    20.256    36.631     0.200
    20.252    36.368     0.200
    20.267    36.572     0.200
    20.296    37.434     0.200
    20.435    37.376     0.200
    20.435    38.134     0.200
    20.419    36.593     0.200
    20.433    35.840     0.200
    20.481    37.098     0.200
    20.539    37.153     0.200
    20.696    38.460     0.200
    20.696    38.014     0.200
    20.726    37.227     0.200
    20.730    36.210     0.200
    20.846    35.463     0.200
    20.978    36.076     0.200
    21.054    36.188     0.200
    21.069    35.036     0.200
    21.099    36.037     0.200
    21.111    35.585     0.200
    21.128    38.823     0.200
    21.145    35.699     0.200
    21.167    35.544     0.200
    21.200    35.480     0.200
    21.254    34.984     0.200
    21.289    35.345     0.200
    21.333    35.106     0.200
    21.377    37.205     0.200
    21.405    36.010     0.200
    21.404    35.432     0.200
    21.504    35.356     0.200
    21.506    34.540     0.200
    21.506    34.774     0.200
    21.513    34.853     0.200
    21.513    35.603     0.200
    21.518    37.694     0.200
    21.518    38.897     0.200
    21.520    37.596     0.200
    21.520    36.753     0.200
    21.572    38.939     0.200
    21.572    38.782     0.200
    21.583    34.718     0.200
    21.604    34.018     0.200
    21.606    35.942     0.200
    21.805    35.347     0.200
    21.805    35.613     0.200
    21.864    37.645     0.200
    21.872    34.311     0.200
    21.890    37.277     0.200
    21.890    36.457     0.200
    21.900    37.226     0.200
    21.971    34.320     0.200
    21.989    35.812     0.200
    22.023    37.616     0.200
    22.040    38.172     0.200
    22.040    38.038     0.200
    22.060    34.342     0.200
    22.077    35.144     0.200
    22.094    33.774     0.200
    22.094    34.345     0.200
    22.115    34.618     0.200
    22.173    33.900     0.200
    22.173    33.666     0.200
    22.227    35.602     0.200
    22.227    35.899     0.200
    22.258    33.361     0.200
    22.306    38.116     0.200
    22.314    37.501     0.200
    22.361    33.577     0.200
    22.393    33.674     0.200
    22.397    37.832     0.200
    22.419    36.771     0.200
    22.466    34.544     0.200
    22.482    37.222     0.200
    22.486    37.532     0.200
    22.500    33.690     0.200
    22.540    33.651     0.200
    22.560    38.017     0.200
    22.608    35.496     0.200
    22.631    37.399     0.200
    22.713    33.317     0.200
    22.742    37.189     0.200
    22.785    34.764     0.200
    22.785    34.975     0.200
    22.808    34.045     0.200
    22.802    34.212     0.200
    22.828    34.022     0.200
    22.833    37.228     0.200
    22.833    36.056     0.200
    22.880    36.909     0.200
    22.889    37.271     0.200
    22.896    37.034     0.200
    22.896    37.143     0.200
    22.918    33.262     0.200
    22.966    34.293     0.200
    23.012    34.184     0.200
    23.012    33.825     0.200
    23.087    32.610     0.200
    23.231    36.356     0.200
    23.246    33.420     0.200
    23.244    34.461     0.200
    23.293    31.661     0.200
    23.342    32.820     0.200
    23.342    33.226     0.200
    23.349    36.270     0.200
    23.432    32.964     0.200
    23.468    35.439     0.200
    23.477    33.178     0.200
    23.509    34.361     0.200
    23.509    34.767     0.200
    23.532    33.774     0.200
    23.537    32.561     0.200
    23.562    32.635     0.200
    23.589    34.517     0.200
    23.617    35.696     0.200
    23.655    36.932     0.200
    23.661    34.661     0.200
    23.692    32.189     0.200
    23.790    32.932     0.200
    23.811    32.118     0.200
    23.811    33.258     0.200
    23.838    36.042     0.200
    23.848    34.900     0.200
    23.934    31.899     0.200
    23.934    31.751     0.200
    23.983    31.711     0.200
    23.983    32.289     0.200
    24.007    31.942     0.200
    24.009    35.371     0.200
    24.065    33.815     0.200
    24.034    34.732     0.200
    24.057    31.571     0.200
    24.062    34.581     0.200
    24.072    33.071     0.200
    24.072    33.751     0.200
    24.079    34.663     0.200
    24.121    33.029     0.200
    24.121    34.669     0.200
    24.124    34.892     0.200
    24.153    34.515     0.200
    24.163    32.253     0.200
    24.178    32.094     0.200
    24.222    33.609     0.200
    24.261    32.989     0.200
    24.261    34.927     0.200
    24.275    31.074     0.200
    24.298    33.149     0.200
    24.301    33.014     0.200
    24.345    32.563     0.200
    24.374    33.524     0.200
    24.380    34.449     0.200
    24.394    31.290     0.200
    24.394    31.446     0.200
    24.428    33.436     0.200
    24.436    33.427     0.200
    24.458    30.926     0.200
    24.486    33.144     0.200
    24.486    32.808     0.200
    24.492    34.316     0.200
    24.553    30.704     0.200
    24.585    32.276     0.200
    24.629    31.049     0.200
    24.624    32.550     0.200
    24.630    32.352     0.200
    24.649    30.709     0.200
    24.657    29.769     0.200
    24.655    32.326     0.200
    24.661    32.190     0.200
    24.688    32.664     0.200
    24.693    29.566     0.200
    24.701    29.084     0.200
    24.699    32.525     0.200
    24.718    32.503     0.200
    24.743    31.069     0.200
    24.763    32.079     0.200
    24.789    30.661     0.200
    24.794    30.353     0.200
    24.801    30.641     0.200
    24.808    32.214     0.200
    24.823    30.265     0.200
    24.849    28.999     0.200
    24.855    31.970     0.200
    24.901    33.470     0.200
    24.980    31.403     0.200
    24.968    29.647     0.200
    24.970    32.902     0.200
    24.970    32.511     0.200
    25.039    29.752     0.200
    25.115    29.174     0.200
    25.118    32.228     0.200
    25.175    32.531     0.200
    25.202    28.694     0.200
    25.177    30.356     0.200
    25.186    32.216     0.200
    25.300    30.377     0.200
    25.286    30.658     0.200
    25.337    27.301     0.200
    25.362    28.847     0.200
    25.367    32.702     0.200
    25.378    28.716     0.200
    25.523    28.235     0.200
    25.498    31.950     0.200
    25.500    30.622     0.200
    25.500    31.786     0.200
    25.505    30.194     0.200
    25.508    28.106     0.200
    25.508    28.239     0.200
    25.625    29.551     0.200
    25.599    29.182     0.200
    25.621    30.187     0.200
    25.673    29.416     0.200
    25.691    27.985     0.200
    25.691    27.751     0.200
    25.772    29.511     0.200
    25.839    30.999     0.200
    25.852    29.752     0.200
    25.875    27.678     0.200
    25.896    26.327     0.200
    25.922    27.838     0.200
    25.951    28.603     0.200
    25.971    27.624     0.200
    25.971    28.108     0.200
    25.990    30.799     0.200
    25.997    27.361     0.200
    26.121    28.579     0.200
    26.121    29.767     0.200
    26.121    29.634     0.200
    26.125    27.407     0.200
    26.104    28.705     0.200
    26.106    25.608     0.200
    26.117    28.730     0.200
    26.117    29.550     0.200
    26.172    29.279     0.200
    26.139    28.109     0.200
    26.155    28.510     0.200
    26.155    26.042     0.200
    26.157    25.947     0.200
    26.213    25.615     0.200
    26.221    29.931     0.200
    26.329    29.940     0.200
    26.307    28.132     0.200
    26.362    29.319     0.200
    26.332    26.345     0.200
    26.362    25.452     0.200
    26.362    26.983     0.200
    26.373    25.557     0.200
    26.420    27.265     0.200
    26.419    25.875     0.200
    26.419    26.320     0.200
    26.391    27.964     0.200
    26.399    25.765     0.200
    26.435    27.326     0.200
    26.435    27.780     0.200
    26.483    28.154     0.200
    26.455    24.660     0.200
    26.495    23.260     0.200
    26.485    27.729     0.200
    26.487    28.558     0.200
    26.563    30.424     0.200
    26.540    25.276     0.200
    26.600    26.358     0.200
    26.598    27.603     0.200
    26.598    26.283     0.200
    26.643    27.845     0.200
    26.791    26.422     0.200
    26.781    24.920     0.200
    26.826    26.289     0.200
    26.867    24.408     0.200
    26.867    25.502     0.200
    26.894    26.358     0.200
    26.878    26.251     0.200
    26.912    25.361     0.200
    26.929    24.776     0.200
    26.929    28.151     0.200
    26.923    24.944     0.200
    26.925    24.276     0.200
    26.927    24.572     0.200
    26.927    25.634     0.200
    26.935    26.280     0.200
    27.017    24.332     0.200
    27.059    24.553     0.200
    27.080    24.363     0.200
    27.184    27.206     0.200
    27.183    24.370     0.200
    27.195    26.790     0.200
    27.227    23.179     0.200
    27.237    21.071     0.200
    27.325    27.318     0.200
    27.296    26.638     0.200
    27.295    25.470     0.200
    27.295    24.900     0.200
    27.295    25.081     0.200
    27.295    24.394     0.200
    27.295    24.628     0.200
    27.307    25.322     0.200
    27.325    25.107     0.200
    27.325    25.795     0.200
    27.392    24.353     0.200
    27.418    23.338     0.200
    27.439    23.400     0.200
    27.439    24.853     0.200
    27.471    23.765     0.200
    27.465    24.696     0.200
    27.568    24.884     0.200
    27.587    25.907     0.200
    27.596    24.471     0.200
    27.596    24.792     0.200
    27.669    25.318     0.200
    27.757    21.898     0.200
    27.758    23.777     0.200
    27.774    22.130     0.200
    27.844    21.730     0.200
    27.845    22.600     0.200
    27.845    22.116     0.200
    27.851    22.023     0.200
    27.953    21.857     0.200
    28.044    23.832     0.200
    28.071    22.127     0.200
    28.071    21.893     0.200
    28.105    22.838     0.200
    28.221    22.803     0.200
    28.234    23.384     0.200
    28.265    22.754     0.200
    28.282    22.225     0.200
    28.367    21.996     0.200
    28.374    22.094     0.200
    28.396    20.434     0.200
    28.396    20.114     0.200
    28.456    20.431     0.200
    28.456    20.079     0.200
    28.459    20.121     0.200
    28.509    21.425     0.200
    28.505    21.818     0.200
    28.524    21.838     0.200
    28.540    20.680     0.200
    28.687    22.229     0.200
    28.687    21.432     0.200
    28.687    19.604     0.200
    28.664    19.779     0.200
    28.664    19.162     0.200
    28.678    22.432     0.200
    28.704    21.573     0.200
    28.787    22.023     0.200
    28.799    19.189     0.200
    28.829    18.352     0.200
    28.827    21.466     0.200
    28.832    20.691     0.200
    28.888    21.054     0.200
    28.899    18.907     0.200
    28.917    19.918     0.200
    28.986    18.768     0.200
    29.029    22.323     0.200
    29.031    18.180     0.200
    29.031    20.048     0.200
    29.068    17.586     0.200
    29.082    20.244     0.200
    29.082    20.384     0.200
    29.168    17.645     0.200
    29.177    16.976     0.200
    29.184    18.475     0.200
    29.184    17.671     0.200
    29.188    17.869     0.200
    29.189    20.577     0.200
    29.267    17.915     0.200
    29.283    20.212     0.200
    29.356    20.021     0.200
    29.405    19.612     0.200
    29.408    18.764     0.200
    29.408    18.303     0.200
    29.443    16.288     0.200
    29.444    19.517     0.200
    29.521    19.155     0.200
    29.562    17.150     0.200
    29.562    18.423     0.200
    29.586    17.422     0.200
    29.613    18.123     0.200
    29.613    18.826     0.200
    29.729    19.279     0.200
    29.796    19.774     0.200
    29.807    16.975     0.200
    29.807    16.335     0.200
    29.880    16.358     0.200
    29.880    16.154     0.200
    29.892    18.180     0.200
    29.898    18.360     0.200
    29.971    16.438     0.200
    14.643    40.460     0.200
    15.020    40.497     0.200
    15.020    39.813     0.200
    15.204    39.946     0.200
    15.204    39.559     0.200
    15.220    40.274     0.200
    15.503    39.465     0.200
    15.626    40.190     0.200
    15.626    39.866     0.200
    16.141    41.548     0.200
    16.173    42.824     0.200
    16.366    39.603     0.200
    16.932    39.137     0.200
    17.099    39.083     0.200
    17.261    39.792     0.200
    17.328    39.399     0.200
    17.535    40.190     0.200
    18.124    38.147     0.200
    18.598    38.032     0.200
    18.704    38.781     0.200
    18.777    38.450     0.200
    18.777    38.845     0.200
    18.982    36.937     0.200
    19.200    38.906     0.200
    19.640    38.077     0.200
    19.762    36.647     0.200
    19.986    36.155     0.200
    20.024    35.959     0.200
    20.334    36.851     0.200
    20.722    38.202     0.200
    21.079    35.536     0.200
    21.207    34.655     0.200
    21.401    34.235     0.200
    21.424    33.279     0.200
    21.551    36.311     0.200
    21.551    37.006     0.200
    21.616    37.079     0.200
    21.643    35.726     0.200
    21.643    37.699     0.200
    21.903    36.983     0.200
    21.940    35.659     0.200
    21.940    37.026     0.200
    22.035    34.561     0.200
    22.113    36.750     0.200
    22.148    34.924     0.200
    22.239    35.184     0.200
    22.412    36.192     0.200
    22.502    35.563     0.200
    22.580    35.178     0.200
    22.910    33.212     0.200
    22.940    34.452     0.200
    22.998    35.259     0.200
    22.998    35.072     0.200
    23.280    34.654     0.200
    23.324    33.860     0.200
    23.453    33.657     0.200
    23.541    33.944     0.200
    23.717    34.199     0.200
    23.736    32.989     0.200
    23.751    34.491     0.200
    23.870    33.038     0.200
    23.940    34.332     0.200
    24.118    32.677     0.200
    24.134    32.912     0.200
    24.306    31.822     0.200
    24.356    32.889     0.200
    24.471    32.670     0.200
    24.527    31.879     0.200
    24.657    31.943     0.200
    24.789    30.873     0.200
    24.906    29.777     0.200
    25.280    30.209     0.200
    25.321    28.144     0.200
    25.436    27.771     0.200
    25.469    29.089     0.200
    25.607    27.492     0.200
    25.599    29.606     0.200
    25.843    26.648     0.200
    25.864    26.885     0.200
    25.931    28.758     0.200
    26.090    28.746     0.200
    26.178    27.006     0.200
    26.178    28.377     0.200
    26.194    27.147     0.200
    26.400    28.063     0.200
    26.462    26.889     0.200
    26.759    25.863     0.200
    26.759    24.191     0.200
    26.875    24.751     0.200
    26.928    23.880     0.200
    27.335    24.064     0.200
    27.334    24.031     0.200
    27.413    25.294     0.200
    27.413    23.892     0.200
    27.664    23.707     0.200
    27.664    22.543     0.200
    27.675    23.649     0.200
    27.753    22.618     0.200
    29.082    17.006     0.200
    29.466    16.847     0.200
    29.670    18.087     0.200
    29.704    16.061     0.200
    26.580    28.394     0.200
    26.813    26.061     0.200
    15.457    41.908     0.200
    15.769    42.766     0.200
    15.847    41.818     0.200
    15.971    40.940     0.200
    16.192    43.443     0.200
    16.600    41.013     0.200
    16.649    43.205     0.200
    17.131    42.183     0.200
    17.447    41.166     0.200
    17.875    42.021     0.200
    18.470    38.885     0.200
    18.523    38.838     0.200
    18.628    40.567     0.200
    18.888    39.770     0.200
    19.217    40.556     0.200
    19.397    38.507     0.200
    19.536    38.857     0.200
    19.575    39.004     0.200
    19.596    39.384     0.200
    19.758    37.660     0.200
    19.786    39.113     0.200
    19.852    38.907     0.200
    19.878    36.955     0.200
    19.931    38.838     0.200
    20.115    38.089     0.200
    20.309    39.469     0.200
    20.514    39.746     0.200
    20.562    37.932     0.200
    20.820    38.948     0.200
    20.872    36.703     0.200
    20.947    39.157     0.200
    21.050    40.064     0.200
    21.131    37.684     0.200
    21.396    40.255     0.200
    21.396    40.145     0.200
    21.467    38.515     0.200
    21.545    39.525     0.200
    21.627    37.911     0.200
    21.730    39.573     0.200
    21.922    35.092     0.200
    21.936    37.866     0.200
    21.932    40.089     0.200
    21.945    37.129     0.200
    21.992    35.035     0.200
    22.024    36.678     0.200
    22.024    36.971     0.200
    22.193    38.804     0.200
    22.378    37.641     0.200
    22.394    36.217     0.200
    22.408    39.036     0.200
    22.445    35.425     0.200
    22.453    35.083     0.200
    22.541    37.042     0.200
    22.676    36.356     0.200
    22.713    38.214     0.200
    22.729    37.162     0.200
    22.729    36.014     0.200
    22.754    38.625     0.200
    22.757    38.211     0.200
    22.761    39.698     0.200
    22.761    39.177     0.200
    23.107    37.036     0.200
    23.126    39.232     0.200
    23.204    37.216     0.200
    23.471    33.990     0.200
    23.486    37.225     0.200
    23.541    37.415     0.200
    23.573    37.300     0.200
    23.627    36.539     0.200
    23.627    36.039     0.200
    23.666    36.697     0.200
    23.750    37.219     0.200
    23.843    34.725     0.200
    23.843    34.414     0.200
    23.846    36.592     0.200
    23.917    36.720     0.200
    23.958    36.568     0.200
    23.967    35.892     0.200
    23.998    34.336     0.200
    24.027    35.409     0.200
    24.122    35.559     0.200
    24.151    36.001     0.200
    24.148    35.313     0.200
    24.255    34.532     0.200
    24.255    34.089     0.200
    24.264    33.084     0.200
    24.285    35.298     0.200
    24.350    31.959     0.200
    24.344    35.468     0.200
    24.393    34.901     0.200
    24.462    32.732     0.200
    24.477    34.466     0.200
    24.563    33.589     0.200
    24.554    35.450     0.200
    24.639    32.557     0.200
    24.731    33.427     0.200
    24.740    33.716     0.200
    24.749    32.776     0.200
    24.749    33.749     0.200
    25.008    34.744     0.200
    25.023    33.586     0.200
    25.053    33.285     0.200
    25.077    32.926     0.200
    25.227    32.615     0.200
    25.257    30.232     0.200
    25.275    30.582     0.200
    25.295    30.533     0.200
    25.336    29.799     0.200
    25.338    32.574     0.200
    25.373    32.948     0.200
    25.637    31.850     0.200
    25.675    30.415     0.200
    25.684    30.982     0.200
    25.685    31.306     0.200
    25.685    32.208     0.200
    25.800    31.648     0.200
    25.859    31.694     0.200
    25.901    28.802     0.200
    26.071    31.555     0.200
    26.112    27.768     0.200
    26.126    30.649     0.200
    26.204    31.087     0.200
    26.360    30.364     0.200
    26.441    27.642     0.200
    26.374    32.021     0.200
    26.537    26.501     0.200
    26.556    27.185     0.200
    26.545    29.569     0.200
    26.651    26.611     0.200
    26.596    28.668     0.200
    26.879    27.734     0.200
    27.044    25.482     0.200
    27.239    25.520     0.200
    27.241    28.546     0.200
    27.271    23.676     0.200
    27.237    29.144     0.200
    27.366    24.549     0.200
    27.373    26.040     0.200
    27.373    26.657     0.200
    27.447    24.558     0.200
    27.579    27.682     0.200
    27.601    24.830     0.200
    27.650    24.873     0.200
    28.288    21.837     0.200
    28.527    22.054     0.200
    28.590    26.087     0.200
    28.866    20.175     0.200
    28.875    20.807     0.200
    28.969    19.144     0.200
    29.115    22.622     0.200
    29.115    22.308     0.200
    29.384    19.671     0.200
    29.468    17.449     0.200
    29.506    19.345     0.200
    29.519    20.836     0.200
    29.636    20.276     0.200
    15.390    41.833     0.200
    15.489    42.023     0.200
    15.687    37.961     0.200
    15.715    41.584     0.200
    15.759    38.319     0.200
    15.867    39.342     0.200
    16.713    39.071     0.200
    16.734    40.423     0.200
    17.071    38.764     0.200
    17.359    38.252     0.200
    17.623    39.617     0.200
    17.945    38.666     0.200
    17.994    38.302     0.200
    18.127    39.146     0.200
    18.144    38.797     0.200
    18.206    38.744     0.200
    18.327    35.161     0.200
    18.481    35.927     0.200
    18.586    37.444     0.200
    18.623    36.809     0.200
    18.672    37.064     0.200
    18.836    38.085     0.200
    18.836    36.518     0.200
    18.982    37.070     0.200
    18.982    36.918     0.200
    19.029    37.184     0.200
    19.006    38.122     0.200
    19.125    36.689     0.200
    19.155    37.165     0.200
    19.155    36.282     0.200
    19.198    37.262     0.200
    19.264    37.003     0.200
    19.279    37.151     0.200
    19.306    36.417     0.200
    19.391    37.155     0.200
    19.466    36.632     0.200
    19.477    35.792     0.200
    19.644    37.108     0.200
    19.681    36.902     0.200
    19.681    35.377     0.200
    19.732    36.115     0.200
    19.685    36.666     0.200
    19.746    35.266     0.200
    19.765    36.242     0.200
    19.803    35.856     0.200
    19.837    35.648     0.200
    19.881    36.060     0.200
    19.934    35.927     0.200
    19.934    36.434     0.200
    19.996    36.464     0.200
    20.028    36.071     0.200
    20.035    36.621     0.200
    20.091    36.286     0.200
    20.139    36.266     0.200
    20.110    37.380     0.200
    20.144    36.538     0.200
    20.176    35.659     0.200
    20.191    34.984     0.200
    20.149    37.808     0.200
    20.202    36.639     0.200
    20.231    35.718     0.200
    20.237    36.507     0.200
    20.270    36.581     0.200
    20.394    34.888     0.200
    20.469    34.597     0.200
    20.466    36.982     0.200
    20.555    35.898     0.200
    20.555    35.284     0.200
    20.628    35.358     0.200
    20.689    35.887     0.200
    20.626    37.270     0.200
    20.725    35.008     0.200
    20.776    34.689     0.200
    20.775    34.468     0.200
    20.892    35.561     0.200
    20.964    34.272     0.200
    20.964    37.767     0.200
    21.094    34.876     0.200
    21.133    36.336     0.200
    21.133    38.410     0.200
    21.264    36.040     0.200
    21.264    37.155     0.200
    21.300    36.787     0.200
    21.371    34.737     0.200
    21.406    37.493     0.200
    21.457    36.533     0.200
    21.469    37.836     0.200
    21.506    37.909     0.200
    21.575    34.287     0.200
    21.548    36.610     0.200
    21.548    37.170     0.200
    21.595    34.422     0.200
    21.572    36.328     0.200
    21.572    36.639     0.200
    21.724    33.347     0.200
    21.724    34.368     0.200
    21.797    32.965     0.200
    21.797    33.855     0.200
    21.762    36.445     0.200
    21.815    36.071     0.200
    21.926    34.039     0.200
    21.926    34.086     0.200
    21.937    33.652     0.200
    21.997    33.851     0.200
    21.949    36.991     0.200
    21.985    36.953     0.200
    22.062    34.835     0.200
    22.062    34.350     0.200
    22.092    33.397     0.200
    22.114    33.098     0.200
    22.183    34.401     0.200
    22.183    33.445     0.200
    22.200    33.327     0.200
    22.265    32.272     0.200
    22.265    32.086     0.200
    22.301    36.946     0.200
    22.328    36.689     0.200
    22.328    34.920     0.200
    22.452    32.382     0.200
    22.622    32.424     0.200
    22.697    35.052     0.200
    22.723    34.969     0.200
    22.833    31.066     0.200
    22.769    34.600     0.200
    22.968    35.926     0.200
    23.045    32.334     0.200
    23.107    31.941     0.200
    23.054    34.887     0.200
    23.111    35.081     0.200
    23.179    31.314     0.200
    23.250    33.551     0.200
    23.210    35.056     0.200
    23.270    34.043     0.200
    23.270    34.151     0.200
    23.385    33.730     0.200
    23.322    35.433     0.200
    23.401    30.256     0.200
    23.401    31.897     0.200
    23.425    32.267     0.200
    23.431    32.061     0.200
    23.410    34.125     0.200
    23.483    34.179     0.200
    23.635    30.626     0.200
    23.731    31.035     0.200
    23.753    31.628     0.200
    23.718    33.843     0.200
    23.718    33.582     0.200
    23.846    31.350     0.200
    23.847    31.466     0.200
    23.847    31.031     0.200
    23.895    31.279     0.200
    23.903    30.783     0.200
    23.932    31.991     0.200
    23.909    32.678     0.200
    23.939    32.887     0.200
    23.995    33.730     0.200
    24.035    30.369     0.200
    24.023    34.126     0.200
    24.187    29.442     0.200
    24.121    32.761     0.200
    24.223    31.091     0.200
    24.223    29.759     0.200
    24.187    32.734     0.200
    24.187    30.900     0.200
    24.283    33.108     0.200
    24.355    30.429     0.200
    24.365    30.648     0.200
    24.337    31.726     0.200
    24.344    31.462     0.200
    24.349    32.544     0.200
    24.427    30.472     0.200
    24.427    29.912     0.200
    24.392    30.806     0.200
    24.389    32.826     0.200
    24.631    30.351     0.200
    24.572    32.446     0.200
    24.596    32.187     0.200
    24.628    32.669     0.200
    24.628    32.388     0.200
    24.647    31.202     0.200
    24.769    29.023     0.200
    24.709    31.585     0.200
    24.842    29.027     0.200
    24.793    31.483     0.200
    24.902    32.123     0.200
    24.963    31.259     0.200
    24.941    32.111     0.200
    25.060    28.736     0.200
    25.031    29.494     0.200
    25.109    29.356     0.200
    25.152    28.313     0.200
    25.155    27.933     0.200
    25.132    30.940     0.200
    25.253    28.769     0.200
    25.287    27.611     0.200
    25.254    30.326     0.200
    25.258    31.158     0.200
    25.249    30.745     0.200
    25.333    29.004     0.200
    25.413    29.161     0.200
    25.443    28.079     0.200
    25.443    29.035     0.200
    25.426    30.190     0.200
    25.636    29.717     0.200
    25.724    30.261     0.200
    25.724    29.457     0.200
    25.788    30.302     0.200
    25.860    29.038     0.200
    25.991    26.483     0.200
    26.023    25.558     0.200
    25.985    26.878     0.200
    26.314    24.952     0.200
    26.367    25.825     0.200
    26.388    24.280     0.200
    26.388    26.255     0.200
    26.404    25.427     0.200
    26.528    25.769     0.200
    26.646    24.386     0.200
    26.686    24.528     0.200
    26.704    24.193     0.200
    26.714    24.173     0.200
    26.739    26.002     0.200
    26.815    28.149     0.200
    26.921    23.968     0.200
    26.997    25.192     0.200
    26.997    25.277     0.200
    26.997    25.828     0.200
    27.066    23.819     0.200
    27.169    25.774     0.200
    27.172    26.671     0.200
    27.269    22.908     0.200
    27.269    23.578     0.200
    27.313    22.349     0.200
    27.336    23.424     0.200
    27.611    21.001     0.200
    27.673    24.274     0.200
    27.720    23.405     0.200
    27.803    22.214     0.200
    27.933    21.792     0.200
    28.194    21.166     0.200
    28.180    24.804     0.200
    28.369    24.528     0.200
    28.783    21.093     0.200
    29.139    19.574     0.200
    29.239    20.034     0.200
    29.368    17.031     0.200
    29.490    15.606     0.200
    15.251    42.895     0.200
    15.347    44.063     0.200
    15.730    42.164     0.200
    15.730    43.273     0.200
    15.971    42.476     0.200
    16.480    40.909     0.200
    16.939    41.550     0.200
    17.302    42.357     0.200
    17.338    41.484     0.200
    17.487    40.942     0.200
    18.529    39.378     0.200
    18.529    40.116     0.200
    19.071    40.694     0.200
    19.099    39.828     0.200
    19.318    37.985     0.200
    19.372    38.336     0.200
    19.372    40.055     0.200
    19.434    39.064     0.200
    19.438    39.721     0.200
    19.592    39.057     0.200
    19.641    38.185     0.200
    19.714    38.022     0.200
    19.844    38.987     0.200
    19.844    39.577     0.200
    19.874    38.501     0.200
    20.091    37.744     0.200
    20.146    37.717     0.200
    20.198    38.040     0.200
    20.258    37.588     0.200
    20.286    40.187     0.200
    20.341    39.481     0.200
    20.578    37.169     0.200
    20.701    39.285     0.200
    20.701    39.828     0.200
    20.792    37.770     0.200
    20.837    37.695     0.200
    20.904    36.433     0.200
    20.946    36.697     0.200
    21.047    37.307     0.200
    21.179    40.819     0.200
    21.337    39.378     0.200
    21.362    40.835     0.200
    21.362    40.120     0.200
    21.518    40.387     0.200
    21.500    37.746     0.200
    21.500    38.508     0.200
    21.566    37.203     0.200
    21.667    40.333     0.200
    21.680    40.361     0.200
    21.726    39.979     0.200
    21.726    36.967     0.200
    21.738    35.367     0.200
    21.782    38.863     0.200
    21.775    37.068     0.200
    21.807    38.931     0.200
    21.807    39.345     0.200
    21.976    39.606     0.200
    21.953    37.937     0.200
    22.078    35.733     0.200
    22.105    34.784     0.200
    22.166    39.785     0.200
    22.156    35.403     0.200
    22.286    36.352     0.200
    22.296    36.592     0.200
    22.296    37.725     0.200
    22.405    37.616     0.200
    22.405    34.931     0.200
    22.407    35.683     0.200
    22.467    36.436     0.200
    22.467    37.034     0.200
    22.539    39.730     0.200
    22.616    35.336     0.200
    22.783    35.628     0.200
    22.914    39.201     0.200
    22.979    39.645     0.200
    23.007    35.576     0.200
    23.014    34.915     0.200
    23.056    36.144     0.200
    23.190    37.497     0.200
    23.266    39.097     0.200
    23.327    39.007     0.200
    23.505    36.000     0.200
    23.505    37.703     0.200
    23.541    38.501     0.200
    23.538    34.763     0.200
    23.562    33.614     0.200
    23.562    34.004     0.200
    23.615    38.946     0.200
    23.634    33.709     0.200
    23.694    38.369     0.200
    23.739    38.249     0.200
    23.795    33.742     0.200
    23.852    36.793     0.200
    23.934    37.021     0.200
    23.976    35.395     0.200
    24.036    33.930     0.200
    24.076    36.567     0.200
    24.074    32.513     0.200
    24.118    36.433     0.200
    24.095    34.120     0.200
    24.165    35.463     0.200
    24.333    36.140     0.200
    24.350    33.240     0.200
    24.405    34.043     0.200
    24.423    34.147     0.200
    24.423    35.420     0.200
    24.573    32.539     0.200
    24.573    33.414     0.200
    24.582    33.038     0.200
    24.628    33.411     0.200
    24.777    35.217     0.200
    24.815    35.020     0.200
    24.850    34.504     0.200
    25.004    34.800     0.200
    25.134    31.311     0.200
    25.171    30.512     0.200
    25.264    30.946     0.200
    25.355    31.258     0.200
    25.457    33.154     0.200
    25.470    32.966     0.200
    25.477    33.301     0.200
    25.607    32.051     0.200
    25.638    32.765     0.200
    25.649    30.828     0.200
    25.845    31.771     0.200
    25.938    30.037     0.200
    26.171    28.223     0.200
    26.354    28.516     0.200
    26.435    28.734     0.200
    26.532    28.149     0.200
    26.542    28.017     0.200
    26.588    27.390     0.200
    26.742    29.233     0.200
    26.779    26.999     0.200
    26.878    25.474     0.200
    26.997    27.047     0.200
    27.036    27.727     0.200
    27.036    29.594     0.200
    27.069    26.577     0.200
    27.232    27.210     0.200
    27.232    27.008     0.200
    27.232    25.961     0.200
    27.232    26.559     0.200
    27.262    25.338     0.200
    27.274    25.948     0.200
    27.394    27.794     0.200
    27.398    26.659     0.200
    27.440    25.084     0.200
    27.500    25.731     0.200
    27.512    24.790     0.200
    27.762    25.101     0.200
    28.364    23.023     0.200
    28.614    22.324     0.200
    28.916    21.880     0.200
    28.947    22.171     0.200
    28.985    21.532     0.200
    29.018    22.713     0.200
    29.375    21.398     0.200
    29.471    21.233     0.200
    29.541    19.645     0.200
    29.874    20.081     0.200
    17.552    43.688     0.200
    19.600    39.827     0.200
    19.587    40.210     0.200
    19.587    41.640     0.200
    19.587    41.983     0.200
    19.777    39.574     0.200
    20.504    38.868     0.200
    20.904    38.714     0.200
    20.910    38.885     0.200
    21.020    42.523     0.200
    21.080    42.223     0.200
    21.481    41.709     0.200
    21.841    41.453     0.200
    21.957    40.958     0.200
    21.957    41.232     0.200
    21.993    36.500     0.200
    21.993    37.094     0.200
    22.170    41.206     0.200
    22.305    40.037     0.200
    22.315    39.978     0.200
    22.315    39.509     0.200
    22.344    40.912     0.200
    22.352    40.882     0.200
    22.368    40.788     0.200
    22.638    40.603     0.200
    22.701    40.505     0.200
    22.819    40.164     0.200
    22.838    40.901     0.200
    23.027    37.666     0.200
    23.127    39.555     0.200
    23.202    39.995     0.200
    23.210    39.386     0.200
    23.210    40.132     0.200
    23.566    39.065     0.200
    23.659    35.984     0.200
    23.655    39.113     0.200
    23.852    38.705     0.200
    23.966    36.609     0.200
    23.934    38.489     0.200
    23.984    37.859     0.200
    24.188    38.035     0.200
    24.281    33.508     0.200
    24.421    33.871     0.200
    24.434    33.835     0.200
    24.431    36.687     0.200
    24.551    34.140     0.200
    24.580    37.394     0.200
    24.836    36.126     0.200
    24.926    34.685     0.200
    25.003    35.790     0.200
    25.084    34.787     0.200
    25.225    35.997     0.200
    25.466    31.767     0.200
    25.485    34.953     0.200
    25.518    34.667     0.200
    25.677    34.441     0.200
    25.820    33.946     0.200
    26.002    30.102     0.200
    26.072    32.575     0.200
    26.177    29.786     0.200
    26.223    32.102     0.200
    26.613    28.242     0.200
    26.946    27.479     0.200
    27.277    26.713     0.200
    27.402    26.208     0.200
    27.428    26.849     0.200
    27.498    25.734     0.200
    27.597    28.681     0.200
    27.675    29.254     0.200
    27.675    28.945     0.200
    27.735    27.032     0.200
    27.735    27.329     0.200
    27.735    27.576     0.200
    27.735    26.553     0.200
    27.735    26.904     0.200
    27.987    27.842     0.200
    28.540    23.454     0.200
    28.655    25.053     0.200
    28.977    23.894     0.200
    29.509    20.543     0.200
    29.857    21.761     0.200
    29.857    21.390     0.200
    14.938    40.285     0.200
    15.184    40.120     0.200
    15.263    40.259     0.200
    15.374    39.673     0.200
    15.632    42.267     0.200
    15.733    42.661     0.200
    15.896    41.483     0.200
    16.046    40.804     0.200
    16.098    42.292     0.200
    16.171    41.398     0.200
    16.191    41.959     0.200
    16.335    40.286     0.200
    16.359    42.771     0.200
    16.440    42.683     0.200
    16.605    43.079     0.200
    16.986    41.596     0.200
    17.018    40.958     0.200
    17.059    41.018     0.200
    17.159    42.094     0.200
    17.492    42.072     0.200
    17.507    42.518     0.200
    17.562    40.747     0.200
    17.588    40.184     0.200
    17.928    41.549     0.200
    18.015    40.243     0.200
    18.230    40.865     0.200
    18.257    40.640     0.200
    18.489    39.722     0.200
    18.579    39.208     0.200
    19.136    39.622     0.200
    19.417    38.052     0.200
    19.632    39.739     0.200
    19.751    39.559     0.200
    19.826    39.103     0.200
    19.816    37.396     0.200
    19.903    39.613     0.200
    20.239    38.688     0.200
    20.347    38.717     0.200
    20.699    39.469     0.200
    20.863    39.531     0.200
    20.900    38.167     0.200
    20.930    35.930     0.200
    21.006    35.998     0.200
    21.377    39.280     0.200
    21.576    40.323     0.200
    21.581    36.559     0.200
    21.603    38.932     0.200
    21.641    38.439     0.200
    21.669    38.983     0.200
    21.711    35.692     0.200
    21.753    40.119     0.200
    21.973    39.260     0.200
    21.986    39.073     0.200
    21.981    36.651     0.200
    22.033    35.282     0.200
    22.050    35.908     0.200
    22.085    36.071     0.200
    22.092    36.297     0.200
    22.380    35.507     0.200
    22.434    40.686     0.200
    22.459    37.293     0.200
    22.510    37.496     0.200
    22.606    36.172     0.200
    22.744    40.105     0.200
    22.781    39.884     0.200
    22.806    36.787     0.200
    22.838    36.602     0.200
    22.943    38.062     0.200
    23.006    38.323     0.200
    22.978    35.199     0.200
    23.016    35.962     0.200
    23.020    35.589     0.200
    23.271    37.090     0.200
    23.340    33.862     0.200
    23.406    37.146     0.200
    23.418    37.304     0.200
    23.469    37.842     0.200
    23.494    33.390     0.200
    23.529    34.703     0.200
    23.529    36.433     0.200
    23.670    36.255     0.200
    23.689    34.507     0.200
    23.762    34.709     0.200
    23.976    34.217     0.200
    24.060    36.884     0.200
    24.059    32.787     0.200
    24.152    36.301     0.200
    24.143    32.761     0.200
    24.171    34.821     0.200
    24.302    33.705     0.200
    24.343    33.649     0.200
    24.323    32.181     0.200
    24.368    35.247     0.200
    24.428    35.121     0.200
    24.408    32.231     0.200
    24.603    35.227     0.200
    24.684    34.235     0.200
    24.735    34.547     0.200
    24.739    34.555     0.200
    24.792    33.372     0.200
    25.160    33.582     0.200
    25.182    32.536     0.200
    25.225    29.789     0.200
    25.385    31.765     0.200
    25.728    32.099     0.200
    25.776    30.888     0.200
    25.876    30.287     0.200
    26.440    26.217     0.200
    26.506    27.306     0.200
    26.835    26.222     0.200
    26.874    27.602     0.200
    26.915    25.313     0.200
    26.956    28.013     0.200
    27.189    27.814     0.200
    27.266    27.499     0.200
    27.266    29.574     0.200
    27.413    26.550     0.200
    27.413    26.440     0.200
    27.413    27.590     0.200
    27.413    26.169     0.200
    27.434    24.294     0.200
    27.526    26.666     0.200
    29.548    20.584     0.200
    15.098    40.839     0.200
    15.480    44.340     0.200
    15.815    41.910     0.200
    15.833    41.302     0.200
    16.053    41.388     0.200
    16.395    42.782     0.200
    16.395    44.443     0.200
    16.531    41.602     0.200
    16.532    41.674     0.200
    16.655    41.465     0.200
    16.951    42.095     0.200
    17.032    41.809     0.200
    17.376    42.863     0.200
    17.692    43.595     0.200
    17.977    42.187     0.200
    18.005    41.783     0.200
    18.005    42.158     0.200
    18.092    41.512     0.200
    18.092    41.158     0.200
    18.301    43.307     0.200
    18.634    38.060     0.200
    18.634    39.351     0.200
    18.724    38.650     0.200
    18.724    39.441     0.200
    19.400    38.903     0.200
    19.466    39.468     0.200
    19.540    39.472     0.200
    19.703    38.733     0.200
    19.769    40.055     0.200
    19.801    38.277     0.200
    20.139    37.993     0.200
    20.139    38.551     0.200
    20.144    37.744     0.200
    20.144    37.346     0.200
    20.208    37.706     0.200
    20.208    37.991     0.200
    20.240    38.921     0.200
    20.259    37.878     0.200
    20.488    39.498     0.200
    20.532    38.080     0.200
    20.773    37.808     0.200
    20.787    37.549     0.200
    21.045    39.756     0.200
    21.050    39.809     0.200
    21.077    37.694     0.200
    21.082    37.076     0.200
    21.144    36.972     0.200
    21.159    40.488     0.200
    21.181    40.327     0.200
    21.182    36.355     0.200
    21.182    36.999     0.200
    21.213    36.631     0.200
    21.272    40.121     0.200
    21.371    36.748     0.200
    21.371    37.293     0.200
    21.474    38.869     0.200
    21.470    36.658     0.200
    21.493    40.166     0.200
    21.516    39.576     0.200
    21.517    37.042     0.200
    21.541    39.534     0.200
    21.698    36.443     0.200
    21.703    35.510     0.200
    21.708    36.674     0.200
    21.864    36.590     0.200
    21.863    37.206     0.200
    21.932    38.032     0.200
    21.934    36.278     0.200
    21.956    35.368     0.200
    22.035    39.633     0.200
    22.042    39.508     0.200
    22.054    39.579     0.200
    22.136    36.729     0.200
    22.136    37.393     0.200
    22.121    34.845     0.200
    22.200    35.498     0.200
    22.200    35.019     0.200
    22.350    35.222     0.200
    22.390    37.198     0.200
    22.380    34.837     0.200
    22.391    35.536     0.200
    22.410    35.257     0.200
    22.445    39.020     0.200
    22.454    34.846     0.200
    22.454    35.656     0.200
    22.472    38.156     0.200
    22.462    35.423     0.200
    22.502    34.576     0.200
    22.588    34.647     0.200
    22.588    35.415     0.200
    22.601    36.449     0.200
    22.691    34.973     0.200
    22.773    38.616     0.200
    22.791    34.132     0.200
    22.791    34.580     0.200
    22.850    37.321     0.200
    22.860    37.249     0.200
    22.902    38.580     0.200
    22.951    34.143     0.200
    22.951    34.592     0.200
    23.038    36.857     0.200
    23.078    38.085     0.200
    23.092    37.760     0.200
    23.191    37.938     0.200
    23.221    37.244     0.200
    23.237    33.985     0.200
    23.255    37.586     0.200
    23.282    35.933     0.200
    23.282    36.245     0.200
    23.282    36.706     0.200
    23.303    33.514     0.200
    23.368    34.013     0.200
    23.443    34.350     0.200
    23.446    33.616     0.200
    23.458    37.422     0.200
    23.473    33.382     0.200
    23.589    33.945     0.200
    23.609    36.999     0.200
    23.615    36.991     0.200
    23.659    33.783     0.200
    23.706    36.703     0.200
    23.721    33.676     0.200
    23.836    36.043     0.200
    23.866    33.431     0.200
    23.867    34.241     0.200
    23.982    35.601     0.200
    24.024    33.565     0.200
    24.079    36.219     0.200
    24.089    35.778     0.200
    24.099    33.080     0.200
    24.106    33.124     0.200
    24.149    35.154     0.200
    24.255    32.988     0.200
    24.302    31.938     0.200
    24.338    31.955     0.200
    24.355    35.925     0.200
    24.389    36.018     0.200
    24.378    33.889     0.200
    24.378    34.193     0.200
    24.405    33.936     0.200
    24.404    35.895     0.200
    24.402    33.140     0.200
    24.414    33.483     0.200
    24.502    35.069     0.200
    24.525    32.823     0.200
    24.525    33.722     0.200
    24.587    35.362     0.200
    24.588    32.076     0.200
    24.630    32.064     0.200
    24.624    31.628     0.200
    24.624    32.184     0.200
    24.643    32.129     0.200
    24.643    31.160     0.200
    24.663    34.626     0.200
    24.790    32.468     0.200
    24.923    32.145     0.200
    24.941    33.735     0.200
    24.994    34.315     0.200
    25.018    34.466     0.200
    25.029    32.702     0.200
    25.143    34.300     0.200
    25.148    30.499     0.200
    25.190    32.652     0.200
    25.198    31.977     0.200
    25.245    31.154     0.200
    25.333    33.179     0.200
    25.409    29.780     0.200
    25.414    30.085     0.200
    25.445    30.419     0.200
    25.472    30.441     0.200
    25.487    29.933     0.200
    25.487    30.036     0.200
    25.500    33.485     0.200
    25.577    29.761     0.200
    25.583    30.447     0.200
    25.602    32.516     0.200
    25.701    29.763     0.200
    25.761    29.669     0.200
    25.807    30.476     0.200
    25.925    32.413     0.200
    26.022    28.013     0.200
    26.112    28.463     0.200
    26.112    28.668     0.200
    26.212    29.035     0.200
    26.212    30.136     0.200
    26.274    30.509     0.200
    26.312    27.326     0.200
    26.397    27.118     0.200
    26.397    26.914     0.200
    26.385    30.593     0.200
    26.504    26.223     0.200
    26.480    29.494     0.200
    26.585    30.730     0.200
    26.566    30.726     0.200
    26.637    27.017     0.200
    26.653    26.952     0.200
    26.688    26.239     0.200
    26.641    28.864     0.200
    26.721    27.213     0.200
    26.764    27.971     0.200
    26.778    27.369     0.200
    26.797    25.649     0.200
    26.819    26.626     0.200
    26.868    26.384     0.200
    26.868    26.835     0.200
    26.875    24.430     0.200
    26.957    27.513     0.200
    26.957    28.105     0.200
    26.965    25.723     0.200
    26.965    26.418     0.200
    27.015    28.288     0.200
    26.988    28.176     0.200
    27.093    25.366     0.200
    27.099    25.123     0.200
    27.127    25.936     0.200
    27.131    25.710     0.200
    27.172    27.070     0.200
    27.169    25.695     0.200
    27.169    26.296     0.200
    27.140    30.756     0.200
    27.155    28.367     0.200
    27.238    28.305     0.200
    27.238    29.604     0.200
    27.364    25.093     0.200
    27.337    26.193     0.200
    27.332    28.758     0.200
    27.345    27.574     0.200
    27.401    25.386     0.200
    27.413    25.468     0.200
    27.412    29.208     0.200
    27.429    29.366     0.200
    27.486    27.225     0.200
    27.447    29.271     0.200
    27.508    24.711     0.200
    27.473    28.152     0.200
    27.528    28.932     0.200
    27.616    26.134     0.200
    27.697    24.130     0.200
    27.704    23.326     0.200
    27.736    24.140     0.200
    27.755    24.084     0.200
    27.764    22.801     0.200
    27.783    24.030     0.200
    27.783    25.102     0.200
    27.828    25.061     0.200
    27.811    27.095     0.200
    27.892    24.099     0.200
    27.864    27.057     0.200
    27.905    24.366     0.200
    27.970    23.471     0.200
    28.024    28.097     0.200
    28.098    25.412     0.200
    28.097    23.443     0.200
    28.097    23.910     0.200
    28.104    27.506     0.200
    28.161    26.752     0.200
    28.219    21.871     0.200
    28.224    26.727     0.200
    28.224    24.926     0.200
    28.272    25.546     0.200
    28.439    22.688     0.200
    28.501    21.327     0.200
    28.580    20.578     0.200
    28.631    21.707     0.200
    28.639    21.433     0.200
    28.658    21.016     0.200
    28.679    25.463     0.200
    28.740    23.811     0.200
    28.721    26.083     0.200
    28.834    22.041     0.200
    28.871    21.273     0.200
    28.896    23.688     0.200
    28.857    25.103     0.200
    28.908    20.999     0.200
    28.894    24.380     0.200
    28.976    21.972     0.200
    29.058    20.798     0.200
    29.082    19.901     0.200
    29.095    21.412     0.200
    29.122    22.463     0.200
    29.121    20.132     0.200
    29.121    20.418     0.200
    29.131    22.309     0.200
    29.131    22.490     0.200
    29.239    19.290     0.200
    29.236    22.190     0.200
    29.236    21.729     0.200
    29.331    20.535     0.200
    29.437    19.965     0.200
    29.468    18.525     0.200
    29.613    19.530     0.200
    29.711    17.921     0.200
    29.801    18.812     0.200
    29.854    22.056     0.200
    29.948    17.232     0.200
    29.951    21.294     0.200
    16.364    40.397     0.200
    16.539    41.123     0.200
    18.252    39.650     0.200
    18.396    38.183     0.200
    18.423    39.045     0.200
    18.916    39.901     0.200
    18.916    39.026     0.200
    18.916    39.573     0.200
    19.038    40.002     0.200
    19.221    37.092     0.200
    19.288    37.392     0.200
    19.288    37.580     0.200
    19.536    37.635     0.200
    19.432    39.208     0.200
    19.675    36.373     0.200
    19.837    37.029     0.200
    19.837    37.310     0.200
    20.071    36.321     0.200
    20.140    37.110     0.200
    20.173    38.927     0.200
    20.346    36.520     0.200
    20.561    36.777     0.200
    20.561    38.542     0.200
    20.712    36.437     0.200
    20.783    35.456     0.200
    20.930    35.004     0.200
    21.112    34.485     0.200
    21.136    33.974     0.200
    21.189    38.345     0.200
    21.274    35.613     0.200
    21.355    37.520     0.200
    21.355    37.216     0.200
    21.362    38.553     0.200
    21.478    38.087     0.200
    21.510    35.202     0.200
    21.544    37.235     0.200
    21.623    36.985     0.200
    21.657    37.448     0.200
    21.752    34.856     0.200
    21.790    37.847     0.200
    21.835    37.738     0.200
    21.848    37.300     0.200
    21.948    34.347     0.200
    21.948    35.534     0.200
    21.981    37.411     0.200
    22.082    32.736     0.200
    22.079    33.443     0.200
    22.091    32.609     0.200
    22.114    35.053     0.200
    22.168    36.500     0.200
    22.259    37.101     0.200
    22.311    35.900     0.200
    22.341    34.335     0.200
    22.345    37.768     0.200
    22.352    37.758     0.200
    22.356    38.384     0.200
    22.395    34.025     0.200
    22.408    35.455     0.200
    22.468    37.225     0.200
    22.597    33.271     0.200
    22.691    37.186     0.200
    22.730    38.663     0.200
    22.770    35.863     0.200
    22.790    37.303     0.200
    22.965    37.038     0.200
    23.079    36.386     0.200
    23.142    37.423     0.200
    23.242    35.927     0.200
    23.363    35.334     0.200
    23.357    36.875     0.200
    23.425    36.694     0.200
    23.506    36.111     0.200
    23.557    32.164     0.200
    23.680    35.130     0.200
    23.749    36.333     0.200
    23.783    31.796     0.200
    23.893    35.524     0.200
    24.004    33.297     0.200
    24.004    33.157     0.200
    24.041    33.827     0.200
    24.145    35.051     0.200
    24.271    34.520     0.200
    24.342    32.666     0.200
    24.375    32.377     0.200
    24.377    34.556     0.200
    24.409    34.056     0.200
    24.486    32.954     0.200
    24.584    31.684     0.200
    24.586    33.515     0.200
    24.632    33.640     0.200
    24.669    33.179     0.200
    24.679    33.314     0.200
    24.795    32.012     0.200
    24.816    32.429     0.200
    24.918    31.861     0.200
    24.967    31.679     0.200
    25.050    33.240     0.200
    25.267    31.287     0.200
    25.300    29.683     0.200
    25.285    31.183     0.200
    25.294    31.814     0.200
    25.410    28.969     0.200
    25.430    30.949     0.200
    25.451    31.802     0.200
    25.578    29.851     0.200
    25.656    30.494     0.200
    25.789    30.141     0.200
    25.809    30.599     0.200
    25.894    28.150     0.200
    26.143    26.697     0.200
    26.293    27.815     0.200
    26.371    26.310     0.200
    26.545    26.807     0.200
    26.506    27.018     0.200
    26.555    25.990     0.200
    26.558    28.849     0.200
    26.854    27.395     0.200
    26.899    25.397     0.200
    27.080    26.264     0.200
    27.080    26.265     0.200
    27.208    24.760     0.200
    27.207    25.216     0.200
    27.370    25.425     0.200
    27.424    23.990     0.200
    27.489    23.631     0.200
    28.364    21.190     0.200
    28.607    20.553     0.200
    28.864    20.578     0.200
    28.882    19.663     0.200
    28.865    21.706     0.200
    29.227    20.546     0.200
    29.307    20.564     0.200
    29.393    20.979     0.200
    29.706    17.460     0.200
    26.822    26.286     0.200
    26.974    25.669     0.200
    15.386    37.534     0.200
    16.869    40.698     0.200
    16.971    38.337     0.200
    16.990    38.548     0.200
    16.990    39.408     0.200
    17.514    37.337     0.200
    18.153    39.571     0.200
    18.974    36.633     0.200
    19.144    36.917     0.200
    19.465    36.721     0.200
    19.747    35.370     0.200
    19.799    35.336     0.200
    19.862    35.012     0.200
    20.335    35.931     0.200
    20.341    36.560     0.200
    20.341    36.810     0.200
    20.514    34.260     0.200
    20.935    37.394     0.200
    20.935    37.918     0.200
    21.064    36.889     0.200
    21.064    37.764     0.200
    21.145    35.118     0.200
    21.145    36.704     0.200
    21.181    33.990     0.200
    21.359    33.749     0.200
    21.451    35.729     0.200
    21.451    36.635     0.200
    21.462    35.773     0.200
    21.462    36.797     0.200
    21.463    37.988     0.200
    21.587    33.436     0.200
    21.587    34.351     0.200
    21.796    38.001     0.200
    21.923    35.061     0.200
    21.913    37.228     0.200
    22.010    34.304     0.200
    22.068    34.542     0.200
    22.249    35.577     0.200
    22.226    37.410     0.200
    22.296    36.495     0.200
    22.297    36.485     0.200
    22.304    36.365     0.200
    22.660    36.659     0.200
    22.750    36.646     0.200
    22.887    34.333     0.200
    23.078    35.120     0.200
    23.147    33.498     0.200
    23.283    34.652     0.200
    23.398    34.713     0.200
    23.627    31.127     0.200
    23.684    34.095     0.200
    23.971    30.255     0.200
    24.014    30.259     0.200
    24.080    32.328     0.200
    24.208    29.906     0.200
    24.269    31.287     0.200
    24.370    33.265     0.200
    24.562    32.688     0.200
    24.612    32.279     0.200
    24.789    29.038     0.200
    24.771    32.526     0.200
    24.957    28.914     0.200
    24.889    32.035     0.200
    24.914    32.078     0.200
    25.219    30.612     0.200
    25.234    30.757     0.200
    25.323    30.663     0.200
    25.400    31.071     0.200
    25.642    29.148     0.200
    25.619    30.855     0.200
    26.171    26.104     0.200
    26.196    25.915     0.200
    26.770    26.506     0.200
    26.770    27.279     0.200
    26.874    24.803     0.200
    26.889    24.440     0.200
    26.889    24.994     0.200
    27.056    24.375     0.200
    27.124    23.942     0.200
    27.129    24.668     0.200
    27.980    21.423     0.200
    28.549    20.070     0.200
    28.619    19.623     0.200
    29.024    19.900     0.200
    29.155    17.956     0.200
    29.152    19.589     0.200
    29.943    15.732     0.200
    14.541    38.865     0.200
    15.356    38.280     0.200
    17.119    41.012     0.200
    18.054    40.057     0.200
    18.054    40.760     0.200
    18.281    37.564     0.200
    18.281    37.954     0.200
    18.505    37.321     0.200
    18.707    37.332     0.200
    18.707    37.637     0.200
    18.752    36.258     0.200
    18.916    36.485     0.200
    19.023    36.417     0.200
    19.331    37.238     0.200
    19.483    35.727     0.200
    19.880    35.856     0.200
    19.989    37.990     0.200
    20.711    34.627     0.200
    20.776    35.167     0.200
    20.987    37.412     0.200
    21.415    37.742     0.200
    21.635    35.148     0.200
    21.785    33.826     0.200
    21.785    35.069     0.200
    21.959    34.997     0.200
    21.982    34.202     0.200
    21.982    34.382     0.200
    22.165    37.538     0.200
    22.227    33.295     0.200
    22.227    33.764     0.200
    22.438    32.401     0.200
    22.494    35.251     0.200
    22.592    34.681     0.200
    22.911    33.031     0.200
    23.154    34.603     0.200
    23.275    32.680     0.200
    23.833    32.668     0.200
    23.857    33.257     0.200
    23.887    33.746     0.200
    24.195    31.782     0.200
    24.210    31.161     0.200
    25.005    29.463     0.200
    25.282    28.033     0.200
    25.584    30.642     0.200
    26.242    25.900     0.200
    26.394    28.436     0.200
    26.659    26.225     0.200
    26.659    28.139     0.200
    26.698    23.840     0.200
    26.871    24.997     0.200
    26.871    26.629     0.200
    27.786    21.906     0.200
    27.922    22.928     0.200
    28.519    20.417     0.200
    29.885    18.603     0.200
    14.142    40.992     0.200
    15.127    41.082     0.200
    15.791    43.241     0.200
    15.791    44.930     0.200
    17.917    39.945     0.200
    18.557    39.004     0.200
    19.060    41.832     0.200
    19.926    39.471     0.200
    21.345    39.861     0.200
    21.768    38.836     0.200
    21.768    39.016     0.200
    21.963    36.452     0.200
    22.018    36.200     0.200
    22.018    35.709     0.200
    22.154    36.349     0.200
    22.451    36.950     0.200
    23.416    34.933     0.200
    23.446    36.065     0.200
    23.501    36.402     0.200
    24.031    35.346     0.200
    24.396    33.513     0.200
    24.445    31.111     0.200
    24.445    32.761     0.200
    24.461    33.033     0.200
    25.937    31.734     0.200
    26.747    29.250     0.200
    27.005    29.368     0.200
    27.013    26.531     0.200
    27.202    28.441     0.200
    27.202    28.671     0.200
    27.222    27.046     0.200
    27.222    27.337     0.200
    29.454    22.090     0.200
    14.302    40.078     0.200
    15.226    43.298     0.200
    15.234    40.050     0.200
    15.512    40.556     0.200
    15.751    41.570     0.200
    15.836    41.588     0.200
    15.871    41.415     0.200
    16.122    38.461     0.200
    18.169    39.431     0.200
    18.436    38.379     0.200
    18.550    39.725     0.200
    18.634    40.512     0.200
    18.610    37.921     0.200
    18.696    40.080     0.200
    18.683    38.092     0.200
    18.683    38.936     0.200
    18.782    40.825     0.200
    18.803    38.254     0.200
    18.892    40.848     0.200
    18.892    41.715     0.200
    18.908    40.622     0.200
    18.900    39.104     0.200
    19.076    38.295     0.200
    19.288    38.171     0.200
    19.382    36.775     0.200
    19.412    36.931     0.200
    19.423    38.269     0.200
    19.467    39.489     0.200
    19.467    38.903     0.200
    19.467    39.599     0.200
    19.467    40.106     0.200
    19.467    40.325     0.200
    19.461    36.525     0.200
    19.488    37.101     0.200
    19.540    37.671     0.200
    19.580    37.816     0.200
    19.701    40.196     0.200
    19.726    38.059     0.200
    19.726    38.153     0.200
    19.788    40.556     0.200
    19.817    37.968     0.200
    19.849    37.477     0.200
    19.906    38.374     0.200
    19.945    38.332     0.200
    19.948    37.501     0.200
    19.959    37.436     0.200
    20.000    37.128     0.200
    20.044    36.185     0.200
    20.058    37.730     0.200
    20.098    38.215     0.200
    20.264    37.138     0.200
    20.265    37.178     0.200
    20.353    39.915     0.200
    20.329    36.743     0.200
    20.334    37.700     0.200
    20.483    37.197     0.200
    20.611    38.118     0.200
    20.685    36.783     0.200
    20.679    36.739     0.200
    20.773    39.907     0.200
    20.786    36.883     0.200
    20.844    38.599     0.200
    20.798    36.952     0.200
    20.800    37.800     0.200
    20.924    39.614     0.200
    20.956    36.375     0.200
    20.974    37.121     0.200
    21.058    39.509     0.200
    21.315    38.657     0.200
    21.486    36.350     0.200
    21.625    38.553     0.200
    21.598    36.517     0.200
    21.662    38.418     0.200
    21.666    35.407     0.200
    21.712    35.048     0.200
    21.743    35.724     0.200
    21.806    38.411     0.200
    21.819    35.517     0.200
    21.846    36.162     0.200
    21.868    36.848     0.200
    21.861    34.491     0.200
    21.996    36.877     0.200
    21.973    35.757     0.200
    22.040    37.220     0.200
    22.041    34.017     0.200
    22.041    35.611     0.200
    22.049    35.930     0.200
    22.059    34.958     0.200
    22.125    35.730     0.200
    22.142    35.316     0.200
    22.151    36.527     0.200
    22.188    37.126     0.200
    22.188    37.728     0.200
    22.284    37.487     0.200
    22.236    36.127     0.200
    22.392    35.297     0.200
    22.459    37.475     0.200
    22.415    35.302     0.200
    22.512    37.366     0.200
    22.530    36.870     0.200
    22.565    35.093     0.200
    22.644    36.794     0.200
    22.606    34.459     0.200
    22.606    35.084     0.200
    22.618    35.536     0.200
    22.672    37.014     0.200
    22.638    34.696     0.200
    22.655    34.941     0.200
    22.766    36.860     0.200
    22.806    36.928     0.200
    22.775    34.353     0.200
    22.911    38.017     0.200
    22.942    38.006     0.200
    22.886    34.221     0.200
    22.918    34.738     0.200
    23.002    36.839     0.200
    23.023    36.747     0.200
    23.027    37.062     0.200
    23.027    37.679     0.200
    23.009    34.542     0.200
    23.056    36.291     0.200
    23.100    37.294     0.200
    23.045    35.599     0.200
    23.075    34.788     0.200
    23.128    36.920     0.200
    23.157    36.474     0.200
    23.175    36.017     0.200
    23.253    36.230     0.200
    23.265    36.214     0.200
    23.253    34.282     0.200
    23.296    35.624     0.200
    23.302    35.483     0.200
    23.312    34.518     0.200
    23.347    35.853     0.200
    23.358    36.254     0.200
    23.371    35.404     0.200
    23.347    34.154     0.200
    23.417    36.604     0.200
    23.486    35.681     0.200
    23.491    35.244     0.200
    23.511    34.797     0.200
    23.574    35.067     0.200
    23.556    34.199     0.200
    23.578    33.637     0.200
    23.645    35.840     0.200
    23.628    36.070     0.200
    23.657    35.242     0.200
    23.700    35.984     0.200
    23.699    33.930     0.200
    23.796    32.543     0.200
    23.849    35.481     0.200
    23.866    36.013     0.200
    23.866    34.146     0.200
    23.887    34.855     0.200
    23.879    33.898     0.200
    23.885    33.525     0.200
    23.977    33.833     0.200
    24.022    32.893     0.200
    24.059    32.060     0.200
    24.077    33.312     0.200
    24.103    32.714     0.200
    24.183    34.992     0.200
    24.219    32.470     0.200
    24.297    34.308     0.200
    24.383    34.385     0.200
    24.355    32.063     0.200
    24.355    33.540     0.200
    24.419    35.020     0.200
    24.414    34.448     0.200
    24.415    34.210     0.200
    24.478    33.368     0.200
    24.469    32.448     0.200
    24.469    32.596     0.200
    24.550    34.565     0.200
    24.528    32.215     0.200
    24.587    33.303     0.200
    24.574    31.476     0.200
    24.649    33.194     0.200
    24.707    31.726     0.200
    24.721    29.509     0.200
    24.766    31.795     0.200
    24.811    33.077     0.200
    24.893    33.783     0.200
    24.920    32.391     0.200
    24.960    33.318     0.200
    24.976    32.519     0.200
    24.986    32.388     0.200
    24.996    32.707     0.200
    25.020    33.329     0.200
    25.046    33.392     0.200
    24.996    30.448     0.200
    25.062    32.350     0.200
    25.098    31.270     0.200
    25.233    31.855     0.200
    25.189    30.665     0.200
    25.191    30.344     0.200
    25.200    29.919     0.200
    25.289    32.662     0.200
    25.246    30.747     0.200
    25.342    32.319     0.200
    25.322    29.948     0.200
    25.333    30.109     0.200
    25.401    31.927     0.200
    25.363    29.905     0.200
    25.502    29.622     0.200
    25.592    31.580     0.200
    25.639    31.371     0.200
    25.784    30.120     0.200
    25.851    28.190     0.200
    25.872    27.790     0.200
    25.949    31.586     0.200
    25.951    30.797     0.200
    25.944    29.893     0.200
    25.924    27.618     0.200
    26.007    29.761     0.200
    26.064    29.329     0.200
    26.035    27.946     0.200
    26.117    29.790     0.200
    26.124    30.676     0.200
    26.090    28.250     0.200
    26.238    29.853     0.200
    26.294    27.635     0.200
    26.423    28.826     0.200
    26.398    26.693     0.200
    26.415    27.584     0.200
    26.467    27.164     0.200
    26.553    29.496     0.200
    26.517    27.035     0.200
    26.626    26.282     0.200
    26.674    28.257     0.200
    26.683    28.371     0.200
    26.658    25.850     0.200
    26.751    26.109     0.200
    26.751    30.953     0.200
    26.724    26.346     0.200
    26.795    26.776     0.200
    26.874    25.948     0.200
    26.913    26.271     0.200
    26.935    25.817     0.200
    26.985    25.011     0.200
    27.082    27.659     0.200
    27.059    26.102     0.200
    27.172    26.383     0.200
    27.172    26.891     0.200
    27.241    24.947     0.200
    27.241    25.290     0.200
    27.356    25.746     0.200
    27.429    26.545     0.200
    27.385    23.304     0.200
    27.483    26.705     0.200
    27.506    26.335     0.200
    27.506    27.124     0.200
    27.466    23.545     0.200
    27.556    24.138     0.200
    27.620    25.142     0.200
    27.620    25.143     0.200
    27.620    24.597     0.200
    27.620    25.565     0.200
    27.603    23.582     0.200
    27.614    23.171     0.200
    27.683    25.913     0.200
    27.724    25.602     0.200
    27.768    25.483     0.200
    27.728    22.694     0.200
    27.743    23.737     0.200
    27.762    23.362     0.200
    27.830    24.517     0.200
    27.830    25.626     0.200
    27.876    22.559     0.200
    27.987    22.973     0.200
    28.599    22.796     0.200
    28.659    24.003     0.200
    28.615    20.818     0.200
    28.682    22.574     0.200
    28.693    22.502     0.200
    28.683    20.664     0.200
    28.849    21.828     0.200
    29.013    21.378     0.200
    29.000    20.099     0.200
    29.149    19.045     0.200
    29.356    20.521     0.200
    29.338    18.004     0.200
    29.359    18.727     0.200
    29.357    18.768     0.200
    29.614    20.164     0.200
    29.731    18.480     0.200
    29.750    18.900     0.200
    29.767    19.367     0.200
    29.825    18.726     0.200
    29.801    17.279     0.200
    29.845    18.897     0.200
    29.892    19.419     0.200
    29.995    18.870     0.200
    15.312    42.885     0.200
    15.590    40.509     0.200
    15.577    41.682     0.200
    16.041    43.689     0.200
    18.236    42.224     0.200
    18.944    40.708     0.200
    18.944    41.427     0.200
    20.288    40.180     0.200
    20.957    38.723     0.200
    21.059    37.070     0.200
    21.186    37.303     0.200
    21.397    37.617     0.200
    21.511    43.282     0.200
    21.518    37.650     0.200
    21.518    39.182     0.200
    21.645    37.955     0.200
    21.645    39.127     0.200
    22.092    35.742     0.200
    22.092    35.391     0.200
    22.277    35.773     0.200
    22.311    39.070     0.200
    22.311    37.774     0.200
    22.644    36.653     0.200
    22.987    36.612     0.200
    23.050    37.164     0.200
    23.409    36.235     0.200
    23.685    36.641     0.200
    23.702    34.672     0.200
    23.714    33.672     0.200
    23.714    33.851     0.200
    23.865    37.454     0.200
    24.026    34.338     0.200
    24.497    34.186     0.200
    24.497    32.733     0.200
    24.518    32.435     0.200
    25.797    30.503     0.200
    25.797    32.042     0.200
    26.339    28.573     0.200
    26.620    28.008     0.200
    26.620    28.633     0.200
    26.705    26.230     0.200
    26.830    28.293     0.200
    26.912    30.292     0.200
    26.912    27.932     0.200
    27.111    26.051     0.200
    27.111    27.309     0.200
    27.111    26.488     0.200
    27.225    27.555     0.200
    27.225    26.734     0.200
    27.444    26.234     0.200
    27.444    27.297     0.200
    27.533    26.286     0.200
    27.871    25.684     0.200
    27.975    24.815     0.200
    29.319    21.894     0.200
    29.319    20.714     0.200
    29.713    20.518     0.200
    29.713    20.182     0.200
    15.522    39.537     0.200
    16.037    40.977     0.200
    18.184    41.917     0.200
    18.184    40.907     0.200
    18.184    41.048     0.200
    18.499    38.906     0.200
    18.497    39.048     0.200
    18.497    38.647     0.200
    18.876    40.443     0.200
    19.948    37.956     0.200
    21.453    43.303     0.200
    21.470    37.542     0.200
    21.470    38.362     0.200
    21.578    38.435     0.200
    21.837    36.759     0.200
    22.001    35.382     0.200
    22.001    35.972     0.200
    22.270    38.747     0.200
    22.321    35.859     0.200
    22.391    37.889     0.200
    22.443    35.112     0.200
    23.335    35.919     0.200
    23.625    35.633     0.200
    23.811    36.563     0.200
    24.407    33.318     0.200
    24.427    32.874     0.200
    24.433    32.156     0.200
    24.651    34.454     0.200
    25.488    30.455     0.200
    25.526    30.439     0.200
    25.694    30.696     0.200
    25.733    31.754     0.200
    25.736    31.498     0.200
    26.555    28.528     0.200
    26.781    28.221     0.200
    26.781    28.676     0.200
    26.905    26.695     0.200
    26.902    26.536     0.200
    26.930    28.909     0.200
    26.930    29.370     0.200
    27.041    26.858     0.200
    27.041    26.627     0.200
    27.114    27.362     0.200
    27.167    27.091     0.200
    27.466    25.610     0.200
    27.868    25.092     0.200
    27.868    24.688     0.200
    29.256    21.664     0.200
    29.693    19.560     0.200
    29.866    19.455     0.200
    15.110    38.782     0.200
    16.146    39.062     0.200
    16.604    38.700     0.200
    17.466    37.146     0.200
    17.634    41.286     0.200
    17.687    40.641     0.200
    18.103    37.974     0.200
    18.097    37.867     0.200
    18.269    38.147     0.200
    18.287    37.496     0.200
    18.336    37.971     0.200
    18.394    39.239     0.200
    18.394    39.340     0.200
    18.394    37.810     0.200
    18.394    40.730     0.200
    18.462    36.874     0.200
    18.395    38.343     0.200
    18.469    36.659     0.200
    18.464    37.822     0.200
    18.652    36.908     0.200
    18.748    37.031     0.200
    18.839    36.625     0.200
    18.897    36.634     0.200
    18.938    36.693     0.200
    18.764    40.301     0.200
    19.033    36.870     0.200
    19.127    36.169     0.200
    19.160    38.293     0.200
    19.231    36.221     0.200
    19.199    36.953     0.200
    19.199    37.602     0.200
    19.383    36.541     0.200
    19.413    36.993     0.200
    19.507    36.781     0.200
    19.536    38.726     0.200
    19.633    36.993     0.200
    19.597    37.688     0.200
    19.647    35.811     0.200
    19.691    38.615     0.200
    19.811    36.394     0.200
    19.761    37.081     0.200
    19.887    35.734     0.200
    19.956    36.631     0.200
    20.007    36.068     0.200
    20.107    36.630     0.200
    20.040    38.543     0.200
    20.094    36.917     0.200
    20.209    35.369     0.200
    20.276    37.053     0.200
    20.342    38.118     0.200
    20.605    37.645     0.200
    20.595    38.916     0.200
    20.638    37.966     0.200
    20.691    37.923     0.200
    20.700    36.936     0.200
    20.801    34.960     0.200
    20.927    35.126     0.200
    20.922    33.973     0.200
    20.871    36.880     0.200
    21.003    36.399     0.200
    20.931    36.380     0.200
    21.098    35.046     0.200
    21.084    36.143     0.200
    21.084    38.003     0.200
    21.134    35.251     0.200
    21.148    36.549     0.200
    21.183    37.719     0.200
    21.302    35.155     0.200
    21.365    35.320     0.200
    21.376    34.876     0.200
    21.337    37.096     0.200
    21.429    36.939     0.200
    21.592    36.155     0.200
    21.751    34.500     0.200
    21.671    36.304     0.200
    21.694    37.750     0.200
    21.694    37.177     0.200
    21.694    38.366     0.200
    21.744    35.344     0.200
    21.759    36.817     0.200
    21.765    35.823     0.200
    21.906    33.611     0.200
    21.891    33.867     0.200
    21.891    34.426     0.200
    22.017    34.067     0.200
    21.996    34.503     0.200
    22.050    34.621     0.200
    22.091    34.825     0.200
    22.058    35.873     0.200
    22.066    35.344     0.200
    22.079    35.179     0.200
    22.188    35.118     0.200
    22.202    34.057     0.200
    22.155    35.906     0.200
    22.245    33.648     0.200
    22.245    34.488     0.200
    22.200    35.985     0.200
    22.203    35.329     0.200
    22.211    35.320     0.200
    22.284    33.443     0.200
    22.245    35.545     0.200
    22.268    35.151     0.200
    22.270    35.527     0.200
    22.300    35.596     0.200
    22.316    35.217     0.200
    22.323    35.005     0.200
    22.408    34.509     0.200
    22.385    35.012     0.200
    22.380    34.970     0.200
    22.398    35.652     0.200
    22.476    35.043     0.200
    22.474    35.238     0.200
    22.483    36.097     0.200
    22.570    34.213     0.200
    22.623    33.269     0.200
    22.557    35.455     0.200
    22.656    32.574     0.200
    22.634    36.169     0.200
    22.661    35.784     0.200
    22.973    33.930     0.200
    22.846    35.608     0.200
    22.888    35.193     0.200
    23.104    32.365     0.200
    23.084    34.775     0.200
    23.100    34.850     0.200
    23.176    34.074     0.200
    23.102    34.905     0.200
    23.120    34.678     0.200
    23.146    34.887     0.200
    23.164    34.687     0.200
    23.254    35.431     0.200
    23.369    32.348     0.200
    23.497    33.025     0.200
    23.457    33.568     0.200
    23.500    34.002     0.200
    23.590    32.523     0.200
    23.578    32.563     0.200
    23.633    32.269     0.200
    23.623    34.406     0.200
    23.626    34.063     0.200
    23.680    33.467     0.200
    23.696    33.283     0.200
    23.726    35.093     0.200
    23.809    34.129     0.200
    23.840    33.779     0.200
    23.882    31.532     0.200
    23.856    33.745     0.200
    23.899    33.897     0.200
    23.919    33.147     0.200
    24.157    30.304     0.200
    24.161    31.081     0.200
    24.143    31.439     0.200
    24.114    33.271     0.200
    24.200    33.088     0.200
    24.313    29.962     0.200
    24.313    29.462     0.200
    24.362    31.230     0.200
    24.362    29.940     0.200
    24.313    32.956     0.200
    24.512    32.043     0.200
    24.669    30.212     0.200
    24.642    30.443     0.200
    24.639    31.967     0.200
    24.795    31.737     0.200
    24.897    29.596     0.200
    24.830    31.516     0.200
    24.968    29.257     0.200
    25.089    29.408     0.200
    25.166    31.259     0.200
    25.278    29.680     0.200
    25.218    30.300     0.200
    25.218    31.740     0.200
    25.314    28.388     0.200
    25.288    29.696     0.200
    25.338    28.968     0.200
    25.335    29.202     0.200
    25.561    28.969     0.200
    25.818    29.382     0.200
    25.938    28.515     0.200
    26.044    27.410     0.200
    26.055    29.893     0.200
    26.051    28.827     0.200
    26.074    27.780     0.200
    26.077    27.366     0.200
    26.160    27.892     0.200
    26.193    26.847     0.200
    26.221    29.094     0.200
    26.218    27.800     0.200
    26.316    26.089     0.200
    26.340    25.194     0.200
    26.475    24.946     0.200
    26.502    24.494     0.200
    26.459    28.069     0.200
    26.587    23.882     0.200
    26.565    25.488     0.200
    26.565    26.159     0.200
    26.565    26.319     0.200
    26.565    26.458     0.200
    26.605    26.251     0.200
    26.635    26.754     0.200
    26.828    25.235     0.200
    26.937    26.667     0.200
    27.012    23.870     0.200
    27.325    24.020     0.200
    27.452    22.879     0.200
    27.389    24.037     0.200
    27.733    23.381     0.200
    27.761    23.868     0.200
    27.788    22.993     0.200
    28.032    22.548     0.200
    28.472    21.255     0.200
    28.744    22.011     0.200
    28.749    21.505     0.200
    29.130    20.152     0.200
    29.480    18.993     0.200
    29.480    20.263     0.200
    29.634    16.856     0.200
    29.786    18.143     0.200
    15.610    40.531     0.200
    15.610    41.289     0.200
    15.799    40.012     0.200
    18.229    41.444     0.200
    19.732    39.576     0.200
    20.334    38.024     0.200
    20.643    39.768     0.200
    21.039    37.764     0.200
    21.181    36.847     0.200
    21.661    39.848     0.200
    22.187    36.232     0.200
    22.187    36.854     0.200
    22.385    36.576     0.200
    23.441    36.971     0.200
    24.599    32.128     0.200
    24.612    32.461     0.200
    24.612    32.972     0.200
    25.063    32.492     0.200
    25.805    32.915     0.200
    26.635    30.210     0.200
    26.817    30.632     0.200
    26.817    30.393     0.200
    27.054    27.111     0.200
    27.134    27.931     0.200
    27.134    27.404     0.200
    28.364    23.037     0.200
    14.636    40.663     0.200
    14.640    41.076     0.200
    14.929    39.942     0.200
    15.540    42.236     0.200
    15.608    41.461     0.200
    15.615    41.126     0.200
    15.762    41.475     0.200
    15.798    40.485     0.200
    15.798    41.165     0.200
    15.798    41.715     0.200
    15.843    41.611     0.200
    15.892    42.551     0.200
    15.939    40.956     0.200
    16.009    42.093     0.200
    16.027    43.197     0.200
    16.044    40.829     0.200
    16.070    40.853     0.200
    16.090    42.274     0.200
    16.103    42.702     0.200
    16.104    41.010     0.200
    16.105    40.692     0.200
    16.105    41.058     0.200
    16.120    40.801     0.200
    16.148    40.492     0.200
    16.149    41.084     0.200
    16.204    41.371     0.200
    16.219    42.049     0.200
    16.356    40.418     0.200
    16.356    41.541     0.200
    16.622    42.831     0.200
    16.642    40.893     0.200
    16.652    44.305     0.200
    16.652    40.786     0.200
    16.850    44.223     0.200
    16.847    41.620     0.200
    16.865    41.694     0.200
    16.921    44.323     0.200
    18.279    40.794     0.200
    18.484    40.230     0.200
    19.539    40.515     0.200
    19.539    40.175     0.200
    19.829    37.818     0.200
    19.829    38.438     0.200
    20.256    37.751     0.200
    20.327    37.173     0.200
    20.365    37.833     0.200
    20.476    39.123     0.200
    20.476    39.498     0.200
    20.476    39.003     0.200
    20.476    38.473     0.200
    20.540    42.642     0.200
    20.540    43.102     0.200
    21.092    39.110     0.200
    21.094    38.321     0.200
    21.154    38.984     0.200
    21.318    39.747     0.200
    21.638    37.246     0.200
    21.729    36.670     0.200
    21.828    36.090     0.200
    21.867    34.637     0.200
    21.867    34.883     0.200
    21.956    34.752     0.200
    22.071    35.266     0.200
    22.122    36.626     0.200
    22.271    37.749     0.200
    22.273    37.280     0.200
    22.313    40.550     0.200
    22.483    38.838     0.200
    22.705    34.306     0.200
    22.856    36.942     0.200
    22.856    36.458     0.200
    22.856    35.198     0.200
    23.212    37.317     0.200
    23.212    38.333     0.200
    23.904    35.362     0.200
    24.131    39.213     0.200
    24.148    33.365     0.200
    24.295    32.101     0.200
    24.295    32.322     0.200
    24.446    38.534     0.200
    24.812    36.062     0.200
    25.211    35.705     0.200
    25.431    33.346     0.200
    25.555    34.396     0.200
    25.677    34.571     0.200
    25.867    34.258     0.200
    25.870    33.542     0.200
    25.870    29.881     0.200
    25.920    32.831     0.200
    26.452    31.233     0.200
    26.460    31.048     0.200
    26.414    30.337     0.200
    26.414    31.342     0.200
    26.414    30.467     0.200
    26.488    30.108     0.200
    26.760    30.911     0.200
    26.811    30.232     0.200
    27.182    25.208     0.200
    27.273    27.691     0.200
    27.258    27.721     0.200
    27.664    26.737     0.200
    27.683    25.865     0.200
    27.683    25.595     0.200
    27.839    24.940     0.200
    27.839    25.360     0.200
    28.142    24.904     0.200
    28.357    24.495     0.200
    28.375    24.788     0.200
    28.510    24.308     0.200
    28.591    23.913     0.200
    28.591    24.768     0.200
    29.355    22.953     0.200
    29.988    20.308     0.200
    14.912    40.366     0.200
    14.962    39.961     0.200
    17.952    40.231     0.200
    18.266    37.083     0.200
    19.799    36.566     0.200
    20.633    36.494     0.200
    20.493    38.224     0.200
    21.331    37.403     0.200
    21.331    37.782     0.200
    21.420    40.599     0.200
    21.793    33.181     0.200
    21.793    33.583     0.200
    21.793    33.692     0.200
    21.933    36.904     0.200
    22.015    33.743     0.200
    22.054    37.900     0.200
    22.215    32.979     0.200
    22.215    33.568     0.200
    22.215    33.861     0.200
    22.669    35.787     0.200
    23.083    34.679     0.200
    23.083    34.538     0.200
    24.216    31.107     0.200
    24.218    30.066     0.200
    24.218    30.273     0.200
    24.699    28.799     0.200
    25.319    28.208     0.200
    25.493    30.072     0.200
    25.493    31.013     0.200
    26.308    28.016     0.200
    26.555    28.447     0.200
    26.555    28.134     0.200
    26.659    24.523     0.200
    26.659    25.902     0.200
    26.791    26.260     0.200
    26.792    25.554     0.200
    26.792    25.323     0.200
    29.012    20.267     0.200
    29.787    18.524     0.200
    14.186    40.398     0.200
    14.742    40.870     0.200
    15.296    42.153     0.200
    15.316    41.744     0.200
    15.320    40.816     0.200
    15.332    43.678     0.200
    15.350    42.232     0.200
    15.489    41.135     0.200
    15.490    40.770     0.200
    15.513    41.386     0.200
    15.518    42.740     0.200
    15.528    42.796     0.200
    15.527    40.696     0.200
    15.699    40.974     0.200
    15.711    41.882     0.200
    15.713    41.165     0.200
    15.761    43.247     0.200
    15.804    41.691     0.200
    15.806    41.314     0.200
    15.807    41.654     0.200
    15.870    42.147     0.200
    15.894    43.288     0.200
    15.995    41.747     0.200
    16.021    43.377     0.200
    16.029    42.239     0.200
    16.031    40.804     0.200
    16.030    45.218     0.200
    16.063    40.783     0.200
    16.072    41.552     0.200
    16.089    43.288     0.200
    16.121    43.446     0.200
    16.136    44.851     0.200
    16.154    42.052     0.200
    16.154    46.093     0.200
    16.222    41.742     0.200
    16.396    41.474     0.200
    16.403    41.919     0.200
    16.414    43.375     0.200
    16.438    42.563     0.200
    16.441    43.064     0.200
    16.444    41.448     0.200
    16.457    42.526     0.200
    16.486    42.712     0.200
    16.506    41.250     0.200
    16.529    40.796     0.200
    16.536    41.594     0.200
    16.560    42.554     0.200
    16.575    41.677     0.200
    16.582    41.773     0.200
    16.582    41.999     0.200
    16.618    45.396     0.200
    16.657    43.360     0.200
    16.671    43.724     0.200
    16.729    41.812     0.200
    16.731    41.619     0.200
    16.747    43.015     0.200
    16.764    41.424     0.200
    16.764    41.268     0.200
    16.764    41.978     0.200
    16.786    43.084     0.200
    16.793    42.998     0.200
    16.809    42.113     0.200
    16.844    43.820     0.200
    16.846    43.080     0.200
    16.875    42.574     0.200
    16.906    41.859     0.200
    16.912    41.790     0.200
    16.946    42.971     0.200
    16.975    42.821     0.200
    16.975    41.899     0.200
    16.991    43.504     0.200
    17.011    42.400     0.200
    17.057    42.566     0.200
    17.070    42.242     0.200
    17.068    42.089     0.200
    17.072    42.036     0.200
    17.072    41.685     0.200
    17.075    41.830     0.200
    17.088    42.034     0.200
    17.117    42.222     0.200
    17.185    41.776     0.200
    17.193    41.119     0.200
    17.414    43.334     0.200
    17.579    42.728     0.200
    17.587    42.374     0.200
    17.616    42.731     0.200
    17.620    42.168     0.200
    17.815    43.233     0.200
    17.971    43.346     0.200
    18.187    41.215     0.200
    18.306    41.438     0.200
    18.359    42.342     0.200
    18.525    38.870     0.200
    18.525    38.630     0.200
    18.977    40.470     0.200
    19.014    39.411     0.200
    19.014    39.720     0.200
    19.325    39.500     0.200
    19.316    40.683     0.200
    19.400    38.308     0.200
    19.479    38.899     0.200
    19.479    39.958     0.200
    19.479    41.718     0.200
    19.889    38.224     0.200
    20.019    38.496     0.200
    20.019    38.176     0.200
    20.010    38.412     0.200
    20.045    38.683     0.200
    20.067    36.420     0.200
    20.271    37.863     0.200
    20.383    37.180     0.200
    20.383    38.191     0.200
    20.383    36.950     0.200
    20.383    37.850     0.200
    20.623    38.676     0.200
    20.803    38.413     0.200
    20.803    35.803     0.200
    20.933    37.341     0.200
    21.082    42.014     0.200
    21.138    40.432     0.200
    21.209    39.146     0.200
    21.246    39.791     0.200
    21.246    38.881     0.200
    21.310    38.764     0.200
    21.350    40.967     0.200
    21.354    39.800     0.200
    21.354    38.327     0.200
    21.354    40.517     0.200
    21.354    39.797     0.200
    21.354    38.117     0.200
    21.416    38.667     0.200
    21.410    38.628     0.200
    21.546    37.573     0.200
    21.350    41.657     0.200
    21.350    42.517     0.200
    21.646    39.143     0.200
    21.683    38.291     0.200
    21.683    38.881     0.200
    21.683    37.961     0.200
    21.716    37.921     0.200
    21.717    38.118     0.200
    21.782    35.948     0.200
    21.733    38.162     0.200
    21.787    36.691     0.200
    21.903    36.816     0.200
    21.903    36.336     0.200
    21.934    37.050     0.200
    22.004    35.198     0.200
    22.004    34.898     0.200
    22.004    35.528     0.200
    22.101    38.888     0.200
    22.121    38.657     0.200
    22.163    35.387     0.200
    22.163    35.697     0.200
    22.373    35.165     0.200
    22.373    35.425     0.200
    22.373    36.925     0.200
    22.401    38.000     0.200
    22.401    39.110     0.200
    22.401    38.968     0.200
    22.401    38.820     0.200
    22.412    38.674     0.200
    22.468    35.246     0.200
    22.468    35.021     0.200
    22.468    34.866     0.200
    22.468    36.316     0.200
    22.481    36.108     0.200
    22.481    36.568     0.200
    22.563    36.403     0.200
    22.846    37.006     0.200
    22.893    34.351     0.200
    22.913    36.054     0.200
    23.013    37.230     0.200
    23.105    35.781     0.200
    23.097    37.299     0.200
    23.156    35.683     0.200
    23.425    35.408     0.200
    23.425    36.018     0.200
    23.425    35.778     0.200
    23.409    36.935     0.200
    23.609    33.431     0.200
    23.701    34.974     0.200
    23.701    37.534     0.200
    23.701    35.824     0.200
    23.701    34.524     0.200
    23.701    35.594     0.200
    23.721    33.545     0.200
    23.866    34.199     0.200
    23.866    34.000     0.200
    23.999    34.208     0.200
    23.999    33.750     0.200
    24.103    33.831     0.200
    24.103    34.011     0.200
    24.125    33.264     0.200
    24.195    35.266     0.200
    24.395    32.381     0.200
    24.395    32.901     0.200
    24.395    32.511     0.200
    24.379    37.316     0.200
    24.430    32.144     0.200
    24.430    32.513     0.200
    24.405    36.014     0.200
    24.542    35.724     0.200
    24.722    34.016     0.200
    24.722    35.066     0.200
    24.963    33.394     0.200
    25.081    33.718     0.200
    25.228    33.309     0.200
    25.359    29.640     0.200
    25.359    29.830     0.200
    25.359    30.180     0.200
    25.416    32.661     0.200
    25.779    32.781     0.200
    25.826    31.926     0.200
    25.847    31.282     0.200
    25.847    31.532     0.200
    25.847    30.182     0.200
    25.868    32.039     0.200
    25.973    30.815     0.200
    26.079    30.421     0.200
    26.132    30.078     0.200
    26.132    30.623     0.200
    26.132    30.853     0.200
    26.243    34.258     0.200
    26.388    29.702     0.200
    26.388    30.034     0.200
    26.388    29.464     0.200
    26.507    30.277     0.200
    26.507    29.582     0.200
    26.595    27.761     0.200
    26.595    27.531     0.200
    26.573    33.514     0.200
    26.609    30.185     0.200
    26.661    28.406     0.200
    26.661    28.856     0.200
    26.661    28.616     0.200
    26.698    32.752     0.200
    26.786    29.520     0.200
    26.787    28.474     0.200
    26.788    28.635     0.200
    26.788    31.055     0.200
    26.788    29.670     0.200
    26.788    29.984     0.200
    26.788    28.235     0.200
    26.788    29.815     0.200
    26.788    30.095     0.200
    26.817    27.860     0.200
    26.849    31.887     0.200
    26.868    29.882     0.200
    26.884    29.415     0.200
    26.895    28.847     0.200
    26.907    29.467     0.200
    26.907    28.097     0.200
    26.913    28.942     0.200
    26.928    28.764     0.200
    26.961    25.771     0.200
    26.961    26.201     0.200
    26.961    25.961     0.200
    26.961    26.781     0.200
    26.930    27.519     0.200
    27.015    28.991     0.200
    27.015    30.552     0.200
    27.140    26.695     0.200
    27.141    26.787     0.200
    27.140    26.788     0.200
    27.140    27.058     0.200
    27.140    26.588     0.200
    27.225    28.307     0.200
    27.267    25.090     0.200
    27.280    26.966     0.200
    27.280    29.186     0.200
    27.280    27.387     0.200
    27.280    27.157     0.200
    27.283    27.224     0.200
    27.283    27.604     0.200
    27.373    27.869     0.200
    27.369    27.655     0.200
    27.369    29.265     0.200
    27.379    28.706     0.200
    27.432    25.446     0.200
    27.432    26.396     0.200
    27.432    26.136     0.200
    27.492    25.489     0.200
    27.492    25.354     0.200
    27.492    26.089     0.200
    27.469    28.646     0.200
    27.529    25.064     0.200
    27.529    26.724     0.200
    27.544    24.119     0.200
    27.544    23.928     0.200
    27.569    24.971     0.200
    27.569    26.011     0.200
    27.569    25.691     0.200
    27.569    25.391     0.200
    27.601    27.011     0.200
    27.720    27.926     0.200
    27.721    27.010     0.200
    27.726    27.109     0.200
    27.726    26.299     0.200
    27.763    26.119     0.200
    27.812    23.833     0.200
    27.812    25.881     0.200
    27.908    24.986     0.200
    27.969    28.520     0.200
    28.014    26.096     0.200
    28.067    28.477     0.200
    28.106    27.618     0.200
    28.169    23.584     0.200
    28.167    25.805     0.200
    28.207    23.484     0.200
    28.451    25.089     0.200
    28.590    22.536     0.200
    28.590    23.818     0.200
    28.632    25.287     0.200
    28.835    23.016     0.200
    28.938    21.309     0.200
    28.938    20.389     0.200
    29.043    20.314     0.200
    29.043    21.034     0.200
    29.038    23.173     0.200
    29.299    22.618     0.200
    29.345    22.666     0.200
    29.363    20.667     0.200
    29.365    20.832     0.200
    29.365    21.742     0.200
    29.365    21.402     0.200
    29.365    20.622     0.200
    29.427    18.858     0.200
    29.466    21.644     0.200
    29.682    20.210     0.200
    29.746    22.786     0.200
    29.764    19.813     0.200
    29.970    19.235     0.200
    14.460    45.490     0.200
    15.637    39.800     0.200
    15.791    40.089     0.200
    15.933    40.434     0.200
    15.933    43.076     0.200
    16.954    42.240     0.200
    17.012    40.107     0.200
    18.147    40.158     0.200
    18.460    38.884     0.200
    18.501    38.596     0.200
    18.795    38.764     0.200
    18.937    39.495     0.200
    19.080    39.234     0.200
    19.326    38.358     0.200
    19.572    38.873     0.200
    19.929    38.027     0.200
    20.033    38.206     0.200
    20.055    37.001     0.200
    20.401    37.351     0.200
    20.586    38.818     0.200
    20.752    37.218     0.200
    21.000    38.487     0.200
    21.376    37.909     0.200
    21.378    37.546     0.200
    21.426    38.604     0.200
    21.643    37.172     0.200
    21.643    38.601     0.200
    21.367    41.832     0.200
    21.367    43.033     0.200
    21.678    37.906     0.200
    21.832    34.978     0.200
    21.987    35.057     0.200
    21.987    35.508     0.200
    22.154    35.248     0.200
    22.154    35.868     0.200
    22.358    39.391     0.200
    22.445    34.462     0.200
    22.445    35.162     0.200
    22.500    35.735     0.200
    22.634    34.608     0.200
    23.039    34.103     0.200
    23.057    36.520     0.200
    23.387    34.732     0.200
    23.387    36.092     0.200
    23.446    33.904     0.200
    23.601    32.758     0.200
    23.721    33.238     0.200
    23.721    37.368     0.200
    24.382    31.328     0.200
    24.382    32.887     0.200
    24.413    31.285     0.200
    24.413    32.514     0.200
    24.623    31.016     0.200
    24.679    33.894     0.200
    25.336    28.759     0.200
    25.806    31.195     0.200
    25.999    30.297     0.200
    26.584    26.582     0.200
    26.620    29.080     0.200
    26.703    28.336     0.200
    26.864    29.106     0.200
    26.864    27.935     0.200
    26.930    25.582     0.200
    26.930    26.122     0.200
    27.101    27.129     0.200
    27.101    26.259     0.200
    27.101    25.959     0.200
    27.242    24.534     0.200
    27.529    26.140     0.200
    28.332    22.736     0.200
    29.925    17.672     0.200
    29.930    19.355     0.200
    15.955    41.982     0.200
    18.436    38.305     0.200
    18.874    39.564     0.200
    19.018    38.566     0.200
    19.388    37.508     0.200
    19.398    37.474     0.200
    19.415    39.531     0.200
    19.508    38.203     0.200
    19.818    37.461     0.200
    19.876    37.424     0.200
    20.008    37.550     0.200
    19.989    36.638     0.200
    20.137    38.418     0.200
    20.336    36.900     0.200
    20.520    38.580     0.200
    20.744    39.008     0.200
    21.146    36.694     0.200
    21.314    36.802     0.200
    21.365    38.529     0.200
    21.445    35.453     0.200
    21.580    36.730     0.200
    21.580    38.970     0.200
    21.346    41.220     0.200
    21.346    42.670     0.200
    21.712    35.247     0.200
    21.803    36.067     0.200
    21.926    34.889     0.200
    21.926    35.760     0.200
    22.067    34.882     0.200
    22.072    34.885     0.200
    22.100    35.197     0.200
    22.100    35.957     0.200
    22.214    34.777     0.200
    22.276    35.227     0.200
    22.308    39.199     0.200
    22.380    34.235     0.200
    22.380    34.705     0.200
    22.484    35.175     0.200
    22.962    34.339     0.200
    22.982    33.973     0.200
    22.996    36.359     0.200
    23.322    34.542     0.200
    23.322    36.162     0.200
    23.540    32.793     0.200
    23.557    33.583     0.200
    23.636    35.147     0.200
    23.782    34.988     0.200
    23.866    34.490     0.200
    23.967    33.560     0.200
    24.002    33.450     0.200
    24.079    32.471     0.200
    24.324    31.920     0.200
    24.324    32.999     0.200
    24.352    31.718     0.200
    24.355    32.632     0.200
    24.775    30.516     0.200
    24.819    30.014     0.200
    24.923    32.125     0.200
    25.158    30.178     0.200
    25.272    29.227     0.200
    25.746    29.830     0.200
    25.746    32.189     0.200
    25.948    29.281     0.200
    26.529    26.580     0.200
    26.559    27.203     0.200
    26.559    29.423     0.200
    26.866    28.172     0.200
    26.810    29.420     0.200
    26.821    24.882     0.200
    26.864    24.973     0.200
    26.864    26.193     0.200
    27.038    26.020     0.200
    27.037    27.868     0.200
    27.038    27.361     0.200
    27.038    25.641     0.200
    27.038    26.101     0.200
    27.555    23.714     0.200
    27.662    23.010     0.200
    28.088    23.576     0.200
    28.979    19.571     0.200
    29.868    18.844     0.200
    15.865    41.620     0.200
    19.163    38.371     0.200
    19.610    39.034     0.200
    21.170    41.038     0.200
    21.662    37.055     0.200
    23.437    35.099     0.200
    23.973    33.276     0.200
    24.404    33.730     0.200
    25.014    30.522     0.200
    26.911    28.044     0.200
    27.088    26.092     0.200
    27.088    25.741     0.200
    27.338    23.677     0.200
    14.350    46.311     0.200
    15.312    40.109     0.200
    15.694    40.233     0.200
    15.815    43.988     0.200
    15.815    44.722     0.200
    15.923    40.728     0.200
    18.269    40.556     0.200
    18.571    39.349     0.200
    18.649    39.119     0.200
    18.683    37.812     0.200
    18.770    39.168     0.200
    18.883    38.043     0.200
    19.057    39.148     0.200
    19.841    38.426     0.200
    20.924    41.668     0.200
    21.370    37.658     0.200
    21.309    43.354     0.200
    21.765    38.990     0.200
    21.851    36.759     0.200
    22.036    35.711     0.200
    22.036    35.461     0.200
    22.177    36.282     0.200
    22.227    39.283     0.200
    22.490    39.838     0.200
    22.490    38.119     0.200
    22.490    35.793     0.200
    22.512    35.875     0.200
    22.607    38.150     0.200
    22.638    36.203     0.200
    23.502    36.408     0.200
    23.630    32.881     0.200
    24.055    33.414     0.200
    24.417    33.684     0.200
    24.423    33.831     0.200
    24.463    32.596     0.200
    24.463    30.940     0.200
    24.527    33.050     0.200
    24.846    31.737     0.200
    25.469    29.686     0.200
    25.932    32.067     0.200
    26.743    29.412     0.200
    26.984    30.185     0.200
    26.995    27.571     0.200
    26.995    28.844     0.200
    27.022    26.416     0.200
    27.221    25.977     0.200
    27.221    26.297     0.200
    27.231    28.916     0.200
    28.150    22.230     0.200
    15.759    41.096     0.200
    15.759    46.152     0.200
    18.415    38.144     0.200
    18.417    40.550     0.200
    18.543    38.461     0.200
    18.543    37.511     0.200
    18.698    38.041     0.200
    18.904    38.327     0.200
    19.066    39.830     0.200
    19.287    40.132     0.200
    19.867    36.892     0.200
    19.900    37.753     0.200
    19.920    37.159     0.200
    20.387    37.016     0.200
    20.460    39.521     0.200
    20.700    38.338     0.200
    20.959    40.320     0.200
    21.163    38.725     0.200
    21.237    37.363     0.200
    21.497    37.805     0.200
    21.244    42.522     0.200
    21.244    40.261     0.200
    21.776    38.558     0.200
    21.776    37.378     0.200
    21.998    35.364     0.200
    21.998    34.964     0.200
    21.998    35.744     0.200
    22.128    35.512     0.200
    22.128    34.742     0.200
    22.370    35.804     0.200
    22.483    34.290     0.200
    22.483    34.450     0.200
    22.522    39.948     0.200
    22.522    37.648     0.200
    23.243    36.618     0.200
    23.676    35.889     0.200
    23.757    33.975     0.200
    24.003    32.874     0.200
    24.168    33.784     0.200
    24.373    32.445     0.200
    24.373    31.645     0.200
    24.425    31.344     0.200
    24.425    31.813     0.200
    24.796    31.136     0.200
    25.371    29.442     0.200
    25.670    28.646     0.200
    25.947    31.276     0.200
    25.947    30.177     0.200
    26.161    29.138     0.200
    26.566    26.763     0.200
    26.751    26.926     0.200
    26.755    28.726     0.200
    26.755    26.496     0.200
    26.827    26.925     0.200
    26.881    26.914     0.200
    27.005    25.758     0.200
    27.005    25.108     0.200
    27.021    28.945     0.200
    27.021    27.600     0.200
    27.227    29.717     0.200
    27.228    26.031     0.200
    27.228    26.611     0.200
    27.228    25.501     0.200
    27.236    25.167     0.200
    27.336    25.933     0.200
    27.361    26.305     0.200
    27.361    24.405     0.200
    27.359    25.792     0.200
    27.388    25.165     0.200
    27.502    26.438     0.200
    27.502    27.218     0.200
    27.533    22.860     0.200
    27.660    25.866     0.200
    27.660    24.266     0.200
    28.017    23.585     0.200
    28.281    22.676     0.200
    29.372    20.055     0.200
    29.422    21.511     0.200
    29.422    19.062     0.200
    29.463    21.492     0.200
    27.283    23.812     0.200
    27.354    26.199     0.200
    27.076    24.090     0.200
    27.140    25.267     0.200
    15.666    40.725     0.200
    16.093    41.323     0.200
    16.351    40.110     0.200
    17.059    40.747     0.200
    17.173    41.046     0.200
    18.153    42.064     0.200
    18.588    38.981     0.200
    18.647    38.768     0.200
    18.640    38.805     0.200
    18.753    35.926     0.200
    18.781    38.414     0.200
    18.896    38.125     0.200
    18.858    38.509     0.200
    18.858    39.412     0.200
    18.858    40.052     0.200
    18.858    39.911     0.200
    19.136    37.856     0.200
    19.591    37.626     0.200
    19.935    37.563     0.200
    20.676    36.472     0.200
    20.834    36.319     0.200
    20.957    36.114     0.200
    21.311    36.697     0.200
    21.551    37.021     0.200
    21.566    35.889     0.200
    21.559    39.188     0.200
    21.604    36.909     0.200
    21.911    35.718     0.200
    22.028    35.952     0.200
    22.028    35.061     0.200
    22.227    35.690     0.200
    22.387    35.137     0.200
    22.462    35.180     0.200
    22.683    33.447     0.200
    22.803    33.868     0.200
    23.323    35.631     0.200
    23.654    33.544     0.200
    23.600    35.835     0.200
    24.189    32.614     0.200
    24.209    34.214     0.200
    24.319    33.730     0.200
    24.440    33.090     0.200
    24.453    33.097     0.200
    24.453    31.609     0.200
    25.109    32.483     0.200
    25.251    29.354     0.200
    25.722    30.598     0.200
    26.294    27.017     0.200
    26.534    29.622     0.200
    26.748    27.181     0.200
    26.748    28.017     0.200
    26.927    24.653     0.200
    26.935    24.435     0.200
    26.911    26.547     0.200
    27.025    25.621     0.200
    29.627    19.432     0.200
    26.635    25.839     0.200
    15.941    39.506     0.200
    16.501    39.606     0.200
    16.913    40.091     0.200
    16.973    39.148     0.200
    17.508    40.504     0.200
    17.901    41.485     0.200
    17.913    39.569     0.200
    18.006    40.217     0.200
    18.038    41.457     0.200
    18.211    40.902     0.200
    18.345    40.273     0.200
    19.333    37.871     0.200
    19.501    37.733     0.200
    19.937    36.540     0.200
    20.080    38.249     0.200
    20.158    36.721     0.200
    20.698    37.744     0.200
    20.863    36.864     0.200
    20.951    36.942     0.200
    20.970    37.630     0.200
    21.199    38.209     0.200
    21.298    36.591     0.200
    21.397    37.445     0.200
    21.561    37.122     0.200
    21.763    34.953     0.200
    21.987    36.241     0.200
    22.133    35.836     0.200
    22.224    34.709     0.200
    22.435    37.313     0.200
    22.799    35.271     0.200
    22.831    35.593     0.200
    23.356    35.836     0.200
    23.391    35.103     0.200
    23.881    34.036     0.200
    24.983    30.937     0.200
    25.699    29.455     0.200
    26.311    28.334     0.200
    26.366    26.530     0.200
    26.376    27.026     0.200
    26.666    25.900     0.200
    26.671    26.307     0.200
    26.852    27.452     0.200
    26.852    27.234     0.200
    27.919    24.572     0.200
    28.850    20.921     0.200
    15.220    39.919     0.200
    15.256    39.435     0.200
    15.596    39.566     0.200
    15.702    39.777     0.200
    15.933    40.797     0.200
    16.079    40.610     0.200
    16.079    39.141     0.200
    16.149    40.537     0.200
    16.160    40.839     0.200
    16.218    39.835     0.200
    16.682    40.779     0.200
    16.724    40.659     0.200
    17.751    40.394     0.200
    17.982    40.069     0.200
    18.166    40.080     0.200
    18.176    41.054     0.200
    18.464    39.592     0.200
    18.518    38.857     0.200
    18.641    40.173     0.200
    18.869    39.373     0.200
    18.869    38.622     0.200
    18.901    38.248     0.200
    18.985    39.481     0.200
    19.247    39.464     0.200
    19.497    39.223     0.200
    19.595    38.584     0.200
    19.615    38.848     0.200
    19.935    38.045     0.200
    20.065    38.524     0.200
    20.082    39.327     0.200
    20.199    37.718     0.200
    20.679    37.005     0.200
    20.966    36.235     0.200
    21.022    36.182     0.200
    21.114    37.923     0.200
    21.569    35.655     0.200
    21.828    35.463     0.200
    22.030    35.398     0.200
    22.190    34.806     0.200
    22.254    34.926     0.200
    22.308    34.342     0.200
    22.976    35.646     0.200
    23.004    36.394     0.200
    23.613    35.489     0.200
    23.966    32.696     0.200
    24.187    32.560     0.200
    24.330    33.490     0.200
    24.455    31.304     0.200
    24.576    33.063     0.200
    25.121    31.598     0.200
    25.251    30.032     0.200
    26.485    26.431     0.200
    26.633    26.311     0.200
    26.761    30.124     0.200
    26.761    28.179     0.200
    26.918    25.659     0.200
    26.937    25.210     0.200
    27.036    26.420     0.200
    27.036    26.568     0.200
    15.536    40.817     0.200
    15.533    40.865     0.200
    16.138    41.205     0.200
    16.354    40.432     0.200
    16.381    40.367     0.200
    16.977    40.348     0.200
    17.008    41.387     0.200
    17.431    41.075     0.200
    17.447    40.678     0.200
    17.463    41.066     0.200
    17.673    40.461     0.200
    18.516    39.762     0.200
    18.534    39.706     0.200
    18.541    39.127     0.200
    18.900    40.021     0.200
    18.966    39.603     0.200
    19.074    40.291     0.200
    19.102    39.952     0.200
    19.195    40.089     0.200
    19.355    39.720     0.200
    19.571    38.814     0.200
    19.597    38.659     0.200
    19.853    39.292     0.200
    19.857    38.694     0.200
    20.044    40.045     0.200
    20.112    39.296     0.200
    20.203    39.252     0.200
    20.300    38.141     0.200
    20.442    37.523     0.200
    20.527    39.383     0.200
    20.879    37.269     0.200
    20.909    37.949     0.200
    21.343    38.891     0.200
    21.504    38.793     0.200
    21.549    37.659     0.200
    21.719    39.104     0.200
    21.905    37.869     0.200
    21.920    37.915     0.200
    21.955    36.600     0.200
    22.107    37.650     0.200
    22.141    38.048     0.200
    22.166    38.822     0.200
    22.208    38.461     0.200
    22.327    37.942     0.200
    22.402    38.314     0.200
    22.445    38.085     0.200
    22.450    37.320     0.200
    22.589    37.551     0.200
    22.584    35.948     0.200
    22.672    37.347     0.200
    22.707    37.241     0.200
    22.775    36.420     0.200
    22.990    35.299     0.200
    24.038    34.343     0.200
    24.041    34.009     0.200
    25.132    31.244     0.200
    26.145    28.211     0.200
    26.486    27.685     0.200
    26.815    27.028     0.200
    27.193    28.779     0.200
    27.193    27.912     0.200
    27.346    25.688     0.200
    27.346    26.336     0.200
    14.540    38.148     0.200
    14.816    38.462     0.200
    14.971    38.442     0.200
    15.044    37.533     0.200
    15.100    37.937     0.200
    15.299    38.854     0.200
    15.475    37.811     0.200
    15.874    38.175     0.200
    16.083    36.847     0.200
    16.233    38.586     0.200
    16.440    37.195     0.200
    16.590    38.188     0.200
    16.671    37.584     0.200
    16.791    39.757     0.200
    16.896    37.809     0.200
    17.053    37.247     0.200
    17.317    38.487     0.200
    17.349    37.194     0.200
    17.490    36.806     0.200
    17.533    37.218     0.200
    17.533    36.278     0.200
    17.693    37.767     0.200
    17.711    37.157     0.200
    17.769    38.493     0.200
    17.791    39.894     0.200
    17.859    38.408     0.200
    17.898    41.645     0.200
    17.898    39.615     0.200
    17.898    42.025     0.200
    18.138    38.536     0.200
    18.172    38.587     0.200
    18.263    37.996     0.200
    18.263    37.496     0.200
    18.367    38.432     0.200
    18.384    37.388     0.200
    18.433    37.733     0.200
    18.501    38.068     0.200
    18.515    37.385     0.200
    18.584    38.785     0.200
    18.585    40.497     0.200
    18.585    40.009     0.200
    18.585    39.167     0.200
    18.637    37.940     0.200
    18.681    39.431     0.200
    18.716    37.556     0.200
    18.762    37.153     0.200
    18.801    37.447     0.200
    18.871    37.288     0.200
    18.975    37.052     0.200
    19.224    38.324     0.200
    19.329    37.468     0.200
    19.346    37.096     0.200
    19.348    36.850     0.200
    19.397    39.508     0.200
    19.474    36.970     0.200
    19.679    36.208     0.200
    19.694    36.808     0.200
    19.823    37.312     0.200
    19.851    35.914     0.200
    19.922    36.656     0.200
    19.949    36.089     0.200
    19.944    38.858     0.200
    20.163    35.842     0.200
    20.433    35.371     0.200
    20.742    35.075     0.200
    20.767    36.295     0.200
    20.825    35.598     0.200
    20.840    38.343     0.200
    21.004    37.348     0.200
    21.035    36.831     0.200
    21.074    34.737     0.200
    21.060    38.094     0.200
    21.206    34.890     0.200
    21.287    37.994     0.200
    21.287    36.024     0.200
    21.325    35.060     0.200
    21.329    37.219     0.200
    21.433    37.159     0.200
    21.493    37.746     0.200
    21.491    36.705     0.200
    21.622    33.754     0.200
    21.624    37.479     0.200
    21.731    37.375     0.200
    21.479    40.703     0.200
    21.479    39.443     0.200
    21.802    33.537     0.200
    21.997    34.037     0.200
    21.994    38.390     0.200
    21.994    36.470     0.200
    21.994    37.041     0.200
    22.039    34.341     0.200
    22.061    34.843     0.200
    22.135    34.461     0.200
    22.162    36.108     0.200
    22.214    34.231     0.200
    22.214    33.471     0.200
    22.283    33.347     0.200
    22.329    36.695     0.200
    22.465    33.391     0.200
    22.565    33.606     0.200
    22.696    35.366     0.200
    22.882    35.871     0.200
    22.912    35.347     0.200
    22.957    33.035     0.200
    23.046    34.958     0.200
    23.046    34.828     0.200
    23.146    34.685     0.200
    23.330    35.779     0.200
    23.356    32.980     0.200
    23.455    31.967     0.200
    23.554    34.162     0.200
    23.670    33.402     0.200
    23.721    33.452     0.200
    23.789    33.279     0.200
    23.858    33.233     0.200
    23.869    34.306     0.200
    23.888    33.360     0.200
    23.919    31.150     0.200
    23.933    31.115     0.200
    23.927    34.105     0.200
    23.941    33.394     0.200
    23.961    32.390     0.200
    23.962    33.455     0.200
    23.966    32.014     0.200
    24.047    32.858     0.200
    24.073    32.624     0.200
    24.169    32.478     0.200
    24.209    30.889     0.200
    24.211    32.495     0.200
    24.227    30.783     0.200
    24.234    31.512     0.200
    24.234    30.602     0.200
    24.392    32.978     0.200
    24.844    30.399     0.200
    25.038    29.372     0.200
    25.037    30.796     0.200
    25.058    29.798     0.200
    25.421    28.030     0.200
    25.445    30.942     0.200
    25.634    29.969     0.200
    25.671    29.773     0.200
    25.923    26.476     0.200
    25.976    28.175     0.200
    26.079    25.517     0.200
    26.234    25.403     0.200
    26.263    28.348     0.200
    26.263    26.928     0.200
    26.368    25.210     0.200
    26.402    24.539     0.200
    26.423    28.078     0.200
    26.455    25.097     0.200
    26.487    29.489     0.200
    26.498    28.231     0.200
    26.498    27.420     0.200
    26.642    25.400     0.200
    26.642    24.510     0.200
    26.751    25.827     0.200
    26.858    26.435     0.200
    27.174    25.127     0.200
    27.815    21.141     0.200
    28.903    19.442     0.200
    29.707    17.636     0.200
    21.994    35.761     0.200
    19.437    36.315     0.200
    14.861    42.534     0.200
    15.434    43.906     0.200
    15.434    43.293     0.200
    15.434    43.097     0.200
    15.434    41.695     0.200
    15.589    45.435     0.200
    15.871    41.495     0.200
    15.992    42.428     0.200
    16.280    44.233     0.200
    16.303    46.750     0.200
    16.303    46.488     0.200
    17.648    44.152     0.200
    18.103    43.344     0.200
    18.103    41.961     0.200
    18.092    45.977     0.200
    18.665    42.161     0.200
    18.729    45.772     0.200
    18.729    43.335     0.200
    19.339    44.377     0.200
    19.339    44.545     0.200
    19.339    42.518     0.200
    19.960    41.048     0.200
    19.993    40.735     0.200
    20.000    41.950     0.200
    20.102    41.889     0.200
    20.210    42.396     0.200
    20.204    42.416     0.200
    20.225    41.627     0.200
    20.225    41.154     0.200
    20.281    41.769     0.200
    20.299    40.827     0.200
    20.324    40.768     0.200
    20.435    40.901     0.200
    20.477    41.314     0.200
    20.493    43.757     0.200
    20.997    42.224     0.200
    21.786    39.347     0.200
    22.056    41.987     0.200
    22.061    38.964     0.200
    22.061    38.632     0.200
    22.061    38.456     0.200
    22.121    39.322     0.200
    22.121    39.052     0.200
    22.348    41.762     0.200
    22.595    38.335     0.200
    22.595    38.120     0.200
    22.729    40.069     0.200
    22.848    42.324     0.200
    22.848    42.113     0.200
    22.848    41.336     0.200
    22.848    41.571     0.200
    22.925    39.965     0.200
    23.367    40.850     0.200
    23.367    39.198     0.200
    23.604    37.980     0.200
    23.756    40.123     0.200
    23.965    37.893     0.200
    23.950    40.613     0.200
    24.390    37.444     0.200
    24.398    36.379     0.200
    24.489    35.882     0.200
    24.489    35.746     0.200
    24.489    35.124     0.200
    25.152    37.484     0.200
    25.420    33.026     0.200
    25.817    32.619     0.200
    26.240    34.309     0.200
    26.215    35.578     0.200
    26.364    32.065     0.200
    26.318    33.342     0.200
    26.399    34.930     0.200
    26.932    32.377     0.200
    26.932    31.506     0.200
    26.897    27.314     0.200
    27.038    31.474     0.200
    27.184    29.261     0.200
    27.184    29.003     0.200
    27.142    33.562     0.200
    27.123    32.686     0.200
    27.328    30.794     0.200
    27.339    31.830     0.200
    27.339    30.916     0.200
    27.345    30.388     0.200
    27.496    28.723     0.200
    27.497    28.718     0.200
    27.497    30.023     0.200
    27.497    29.797     0.200
    27.735    29.432     0.200
    27.735    29.307     0.200
    27.735    28.694     0.200
    27.735    28.045     0.200
    27.676    30.020     0.200
    27.817    29.059     0.200
    28.205    28.557     0.200
    29.005    23.855     0.200
    29.118    26.642     0.200
    29.118    25.911     0.200
    29.118    25.603     0.200
    20.676    43.720     0.200
    19.844    45.626     0.200
    22.848    40.775     0.200
    26.452    36.106     0.200
    20.327    45.393     0.200
    21.975    38.760     0.200
    15.784    42.441     0.200
    16.280    43.850     0.200
    16.548    45.247     0.200
    17.612    42.489     0.200
    18.204    46.097     0.200
    18.729    45.046     0.200
    19.192    44.542     0.200
    19.602    42.571     0.200
    19.738    42.980     0.200
    20.225    42.014     0.200
    20.501    45.170     0.200
    20.520    44.119     0.200
    20.545    42.521     0.200
    20.997    42.107     0.200
    21.604    42.185     0.200
    21.684    41.106     0.200
    22.101    42.319     0.200
    22.633    40.748     0.200
    22.780    40.229     0.200
    22.824    39.590     0.200
    23.214    42.593     0.200
    23.367    39.999     0.200
    23.669    38.495     0.200
    26.932    31.666     0.200
    27.213    31.911     0.200
    14.836    38.728     0.200
    15.257    42.145     0.200
    15.534    39.677     0.200
    15.695    40.561     0.200
    15.997    40.040     0.200
    15.997    40.732     0.200
    16.071    41.663     0.200
    17.085    39.837     0.200
    17.274    42.218     0.200
    18.183    42.542     0.200
    18.183    42.870     0.200
    18.536    39.344     0.200
    18.730    41.880     0.200
    18.888    42.390     0.200
    18.888    41.765     0.200
    19.334    45.657     0.200
    19.861    43.482     0.200
    19.899    40.348     0.200
    19.924    44.574     0.200
    20.168    39.509     0.200
    20.216    38.454     0.200
    20.213    38.284     0.200
    20.409    38.443     0.200
    20.435    37.905     0.200
    20.497    37.698     0.200
    20.583    38.423     0.200
    20.552    39.631     0.200
    20.696    37.632     0.200
    20.845    38.686     0.200
    20.857    36.675     0.200
    21.588    38.801     0.200
    21.589    39.869     0.200
    21.505    42.931     0.200
    21.505    42.169     0.200
    21.752    40.532     0.200
    22.046    35.903     0.200
    22.046    35.790     0.200
    22.239    36.134     0.200
    22.261    39.828     0.200
    22.261    38.969     0.200
    22.483    35.720     0.200
    22.483    35.822     0.200
    22.871    38.349     0.200
    23.352    36.621     0.200
    23.673    34.449     0.200
    24.455    33.601     0.200
    24.471    32.555     0.200
    24.471    32.867     0.200
    26.309    30.421     0.200
    26.645    30.150     0.200
    26.778    29.360     0.200
    26.778    29.989     0.200
    26.936    26.909     0.200
    27.055    27.890     0.200
    26.952    30.943     0.200
    26.952    30.173     0.200
    27.125    30.093     0.200
    27.372    27.024     0.200
    27.372    26.895     0.200
    27.444    26.463     0.200
    27.887    27.750     0.200
    29.264    22.713     0.200
    29.733    22.295     0.200
    15.290    41.583     0.200
    15.359    41.525     0.200
    15.352    41.058     0.200
    15.352    40.003     0.200
    15.352    39.816     0.200
    15.352    41.753     0.200
    15.352    40.456     0.200
    15.509    38.695     0.200
    15.785    41.028     0.200
    15.770    41.303     0.200
    15.819    41.196     0.200
    15.804    38.798     0.200
    15.881    41.156     0.200
    15.907    41.455     0.200
    15.880    39.951     0.200
    16.064    41.368     0.200
    16.085    38.496     0.200
    16.157    39.515     0.200
    16.281    41.301     0.200
    16.222    39.175     0.200
    16.222    42.285     0.200
    16.285    38.615     0.200
    16.431    42.484     0.200
    16.376    40.302     0.200
    16.376    42.802     0.200
    16.612    41.158     0.200
    16.774    39.915     0.200
    16.881    40.541     0.200
    17.169    38.047     0.200
    17.223    38.490     0.200
    17.312    41.590     0.200
    17.331    40.579     0.200
    17.695    38.563     0.200
    17.729    39.867     0.200
    17.666    38.740     0.200
    18.040    37.585     0.200
    18.090    39.472     0.200
    18.180    39.572     0.200
    18.180    39.041     0.200
    18.238    40.527     0.200
    18.398    39.812     0.200
    18.429    38.877     0.200
    18.726    38.445     0.200
    18.726    37.687     0.200
    18.723    39.063     0.200
    18.655    39.931     0.200
    18.761    41.080     0.200
    18.868    37.681     0.200
    18.898    38.909     0.200
    18.826    41.272     0.200
    18.826    39.929     0.200
    18.826    39.600     0.200
    18.959    38.698     0.200
    19.038    38.699     0.200
    19.108    38.805     0.200
    19.133    40.127     0.200
    19.163    38.697     0.200
    19.279    37.853     0.200
    19.277    38.195     0.200
    19.337    38.827     0.200
    19.267    40.824     0.200
    19.413    38.835     0.200
    19.426    38.169     0.200
    19.448    38.030     0.200
    19.431    40.549     0.200
    19.431    40.237     0.200
    19.431    40.674     0.200
    19.431    39.533     0.200
    19.431    39.605     0.200
    19.431    40.058     0.200
    19.536    38.220     0.200
    19.563    38.172     0.200
    19.608    37.929     0.200
    19.713    38.214     0.200
    19.700    38.306     0.200
    19.821    38.172     0.200
    19.975    37.568     0.200
    20.033    38.004     0.200
    20.086    38.211     0.200
    20.283    37.058     0.200
    20.303    36.460     0.200
    20.365    36.431     0.200
    20.382    37.591     0.200
    20.359    37.384     0.200
    20.299    40.062     0.200
    20.415    40.895     0.200
    20.415    41.676     0.200
    20.507    37.032     0.200
    20.627    36.879     0.200
    20.564    37.911     0.200
    20.597    39.934     0.200
    20.616    40.637     0.200
    20.839    36.778     0.200
    20.879    36.013     0.200
    20.768    39.011     0.200
    20.952    38.115     0.200
    20.952    40.404     0.200
    20.863    39.747     0.200
    21.028    35.728     0.200
    21.049    35.675     0.200
    21.038    38.404     0.200
    21.093    38.398     0.200
    21.008    42.400     0.200
    21.008    41.282     0.200
    21.531    36.616     0.200
    21.720    35.001     0.200
    21.583    37.821     0.200
    21.823    35.555     0.200
    21.733    38.997     0.200
    21.749    38.803     0.200
    21.857    35.987     0.200
    21.921    35.526     0.200
    21.844    36.851     0.200
    22.108    35.479     0.200
    22.108    34.722     0.200
    22.108    35.815     0.200
    22.136    35.363     0.200
    22.111    34.775     0.200
    21.956    37.640     0.200
    22.149    37.761     0.200
    22.149    37.042     0.200
    22.161    37.427     0.200
    22.126    37.416     0.200
    22.241    35.951     0.200
    22.494    34.708     0.200
    22.411    37.639     0.200
    22.557    35.052     0.200
    22.444    37.120     0.200
    22.607    34.408     0.200
    22.654    34.513     0.200
    22.654    33.567     0.200
    22.613    36.377     0.200
    22.727    34.617     0.200
    22.568    37.169     0.200
    22.873    38.589     0.200
    22.917    37.146     0.200
    23.090    34.763     0.200
    23.018    36.568     0.200
    23.235    35.037     0.200
    23.327    34.138     0.200
    23.329    35.820     0.200
    23.447    36.049     0.200
    23.639    35.119     0.200
    23.581    35.677     0.200
    23.642    36.371     0.200
    23.779    36.706     0.200
    23.826    35.863     0.200
    24.071    33.034     0.200
    24.018    35.156     0.200
    24.162    33.465     0.200
    24.178    32.823     0.200
    24.234    35.023     0.200
    24.435    32.741     0.200
    24.435    32.538     0.200
    24.473    33.746     0.200
    24.536    31.904     0.200
    24.536    31.498     0.200
    24.536    30.755     0.200
    24.536    32.685     0.200
    24.476    33.943     0.200
    24.544    33.060     0.200
    24.757    33.681     0.200
    24.885    32.605     0.200
    24.914    31.831     0.200
    24.967    32.843     0.200
    24.878    32.486     0.200
    24.915    32.582     0.200
    25.187    30.582     0.200
    25.252    30.113     0.200
    25.268    30.163     0.200
    25.331    30.492     0.200
    25.428    29.736     0.200
    25.436    29.967     0.200
    25.356    32.193     0.200
    25.560    30.914     0.200
    25.602    30.541     0.200
    25.743    31.621     0.200
    25.884    29.023     0.200
    25.847    30.562     0.200
    25.904    30.839     0.200
    26.093    27.942     0.200
    26.158    29.601     0.200
    26.322    27.616     0.200
    26.388    27.418     0.200
    26.227    28.488     0.200
    26.311    31.462     0.200
    26.334    28.669     0.200
    26.438    25.550     0.200
    26.489    27.597     0.200
    26.550    26.453     0.200
    26.604    27.114     0.200
    26.454    30.495     0.200
    26.679    26.600     0.200
    26.724    26.245     0.200
    26.581    28.333     0.200
    26.890    27.615     0.200
    26.890    27.748     0.200
    26.890    26.209     0.200
    26.951    25.955     0.200
    27.003    25.493     0.200
    26.860    28.056     0.200
    27.047    25.202     0.200
    26.982    28.093     0.200
    27.118    25.668     0.200
    27.049    26.681     0.200
    27.131    27.170     0.200
    27.259    25.500     0.200
    27.541    24.632     0.200
    27.424    27.873     0.200
    27.435    27.214     0.200
    27.435    26.191     0.200
    27.684    23.967     0.200
    27.588    24.944     0.200
    27.588    25.813     0.200
    27.588    25.320     0.200
    27.788    23.305     0.200
    27.792    23.887     0.200
    27.701    24.500     0.200
    27.820    25.368     0.200
    27.820    23.938     0.200
    27.820    26.063     0.200
    27.791    25.307     0.200
    28.454    20.749     0.200
    28.593    22.232     0.200
    29.054    20.762     0.200
    29.076    19.167     0.200
    29.047    21.848     0.200
    29.047    21.348     0.200
    29.047    20.864     0.200
    29.411    19.031     0.200
    29.469    19.603     0.200
    29.846    19.781     0.200
    23.872    39.134     0.200
    27.602    25.005     0.200
    26.322    28.240     0.200
    26.549    27.396     0.200
    26.918    28.279     0.200
    15.490    43.244     0.200
    15.490    43.142     0.200
    15.836    40.707     0.200
    15.837    42.267     0.200
    16.359    42.868     0.200
    17.794    43.757     0.200
    17.936    40.371     0.200
    18.180    40.968     0.200
    18.502    39.698     0.200
    18.590    45.065     0.200
    18.590    44.065     0.200
    18.590    43.905     0.200
    19.182    42.958     0.200
    19.182    42.638     0.200
    19.747    40.412     0.200
    20.117    41.247     0.200
    20.117    39.755     0.200
    20.540    42.316     0.200
    20.968    41.304     0.200
    20.987    43.862     0.200
    21.508    42.012     0.200
    21.593    39.903     0.200
    21.908    37.155     0.200
    21.985    37.090     0.200
    22.433    37.318     0.200
    22.420    37.649     0.200
    22.723    40.405     0.200
    22.720    41.070     0.200
    22.723    40.933     0.200
    23.326    37.985     0.200
    23.594    37.711     0.200
    23.839    37.339     0.200
    24.168    38.061     0.200
    24.253    34.626     0.200
    24.225    35.495     0.200
    24.335    34.224     0.200
    24.335    33.685     0.200
    24.572    37.457     0.200
    24.572    36.457     0.200
    25.016    36.110     0.200
    25.217    37.628     0.200
    25.657    35.794     0.200
    25.657    34.994     0.200
    26.432    29.199     0.200
    26.411    32.479     0.200
    26.898    30.188     0.200
    26.858    32.177     0.200
    26.858    31.778     0.200
    27.018    26.909     0.200
    27.083    29.319     0.200
    27.080    30.089     0.200
    27.163    29.455     0.200
    27.433    25.681     0.200
    27.339    28.122     0.200
    27.570    28.175     0.200
    27.570    27.714     0.200
    27.542    28.819     0.200
    27.981    28.483     0.200
    27.981    27.882     0.200
    28.516    24.022     0.200
    28.851    22.527     0.200
    29.145    24.396     0.200
    29.145    23.595     0.200
    29.145    23.775     0.200
    29.235    25.440     0.200
    29.473    22.391     0.200
    29.600    22.561     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.403    14.124     0.200
     2.541    12.015     0.200
     2.570    15.184     0.200
     2.864    13.243     0.200
     2.926    14.022     0.200
     4.735    17.909     0.200
     6.448    22.923     0.200
     7.098    22.586     0.200
     9.177    30.575     0.200
    10.298    29.000     0.200
    17.276    40.067     0.200
    17.821    39.404     0.200
    19.124    42.098     0.200
    19.127    42.112     0.200
    20.380    42.840     0.200
    20.394    43.174     0.200
    20.830    40.190     0.200
    20.768    41.616     0.200
    20.860    42.502     0.200
     1.452     9.022     0.200
     1.512     9.882     0.200
     1.972    11.213     0.200
     2.110    11.704     0.200
     2.358    12.234     0.200
     2.425    14.452     0.200
     2.492    13.029     0.200
     2.492    13.249     0.200
     2.499    12.460     0.200
     2.499    12.860     0.200
     2.499    13.070     0.200
     2.580    11.721     0.200
     2.665    12.517     0.200
     2.759    13.356     0.200
     2.878    14.185     0.200
     2.903    14.116     0.200
     3.215    14.191     0.200
     3.224    14.509     0.200
     3.265    13.312     0.200
     4.010    17.033     0.200
     4.063    16.824     0.200
     4.192    16.889     0.200
     4.429    16.954     0.200
     4.467    18.152     0.200
     5.330    21.006     0.200
     5.510    18.524     0.200
     7.657    23.334     0.200
     7.810    26.251     0.200
     8.574    31.409     0.200
     9.696    33.421     0.200
    10.180    31.027     0.200
    10.428    34.384     0.200
    12.726    38.055     0.200
    12.726    33.104     0.200
    13.485    36.854     0.200
    13.538    39.046     0.200
    13.538    39.436     0.200
    13.550    39.731     0.200
    13.706    40.845     0.200
    13.874    41.326     0.200
    14.162    40.447     0.200
    14.235    39.538     0.200
    14.284    41.852     0.200
    15.639    41.604     0.200
    17.723    39.142     0.200
    18.463    43.866     0.200
    18.449    46.373     0.200
    18.774    42.831     0.200
    21.020    42.300     0.200
     0.308     5.251     0.200
     0.729     5.736     0.200
     0.979     6.395     0.200
     1.481     8.668     0.200
     2.105     9.833     0.200
     2.234    10.016     0.200
     2.267    10.568     0.200
     2.279    11.727     0.200
     2.338    10.355     0.200
     2.435    10.598     0.200
     2.418    11.565     0.200
     2.418    11.865     0.200
     2.538    10.969     0.200
     2.495    11.016     0.200
     2.521    14.140     0.200
     2.564    11.062     0.200
     2.572    15.078     0.200
     2.649    11.315     0.200
     2.668     9.603     0.200
     2.675    10.914     0.200
     2.875    10.838     0.200
     3.439    13.318     0.200
     3.612    13.172     0.200
     3.621    14.968     0.200
     3.714    15.718     0.200
     4.010    16.408     0.200
     4.471    15.933     0.200
     4.851    17.482     0.200
     5.852    17.788     0.200
     8.076    24.752     0.200
    10.881    33.327     0.200
    11.372    34.030     0.200
    11.609    34.683     0.200
    11.675    34.213     0.200
    11.817    34.576     0.200
    12.367    33.759     0.200
    12.367    33.085     0.200
    13.180    33.969     0.200
    13.340    33.107     0.200
    17.479    36.750     0.200
    18.402    40.339     0.200
    18.912    37.920     0.200
    19.848    38.061     0.200
    20.225    38.432     0.200
    20.345    39.562     0.200
    20.601    39.645     0.200
    20.834    36.735     0.200
    20.880    37.724     0.200
     1.163     7.094     0.200
     2.031    10.315     0.200
     2.284    12.308     0.200
     2.371    11.898     0.200
     2.451    12.152     0.200
     2.479    11.969     0.200
     2.511    11.746     0.200
     2.590    11.261     0.200
     3.064    12.730     0.200
     3.077    11.279     0.200
     3.308    13.082     0.200
     4.154    13.731     0.200
     4.287    15.695     0.200
     4.469    15.084     0.200
     5.030    17.876     0.200
     5.030    17.077     0.200
     5.198    14.923     0.200
     5.198    17.458     0.200
     5.513    19.278     0.200
     5.683    19.650     0.200
     7.894    24.614     0.200
     8.259    25.016     0.200
     8.862    23.067     0.200
    10.212    29.174     0.200
    10.236    30.475     0.200
    10.529    28.768     0.200
    10.871    31.094     0.200
    11.591    33.492     0.200
    11.591    29.826     0.200
    11.799    30.234     0.200
    11.799    28.996     0.200
    12.453    33.985     0.200
    12.951    34.651     0.200
    12.951    35.221     0.200
    13.219    33.814     0.200
    13.330    32.139     0.200
    13.330    33.567     0.200
    14.845    37.940     0.200
    15.140    37.694     0.200
    15.370    35.270     0.200
    15.874    37.899     0.200
    17.187    36.903     0.200
    17.350    38.497     0.200
    17.350    39.818     0.200
    17.511    37.247     0.200
    17.645    38.122     0.200
    18.342    42.004     0.200
    18.425    41.370     0.200
    18.495    40.540     0.200
    18.495    39.870     0.200
    18.495    40.870     0.200
    18.495    40.283     0.200
    18.802    41.286     0.200
    18.921    40.690     0.200
    18.984    41.745     0.200
    19.389    40.716     0.200
    19.694    40.520     0.200
    19.760    40.011     0.200
    19.820    40.560     0.200
    19.856    40.319     0.200
    20.177    39.970     0.200
    20.244    40.219     0.200
    20.488    40.112     0.200
    20.507    39.954     0.200
    20.544    40.167     0.200
    20.720    40.246     0.200
    20.720    40.099     0.200
    20.828    40.225     0.200
    20.834    39.522     0.200
    20.968    39.641     0.200
    20.984    39.622     0.200
     0.158     5.567     0.200
     0.538     4.344     0.200
     0.969     7.275     0.200
     1.181     7.483     0.200
     1.407     8.721     0.200
     2.025     9.533     0.200
     2.283    12.039     0.200
     2.369    12.594     0.200
     2.444    11.048     0.200
     2.464    11.525     0.200
     2.508    10.585     0.200
     2.602    11.035     0.200
     3.051    12.695     0.200
     3.095    11.996     0.200
     3.307    12.917     0.200
     3.414    14.192     0.200
     3.423    13.366     0.200
     4.268    15.356     0.200
     5.049    17.567     0.200
     5.181    17.378     0.200
     5.181    17.488     0.200
     5.530    19.748     0.200
     5.667    16.877     0.200
     7.876    24.399     0.200
     8.276    26.781     0.200
     8.846    24.387     0.200
    10.884    32.167     0.200
    11.609    33.448     0.200
    11.783    28.264     0.200
    12.463    33.754     0.200
    12.933    35.219     0.200
    13.224    33.208     0.200
    13.331    31.828     0.200
    15.150    37.574     0.200
    15.370    35.674     0.200
    17.173    37.803     0.200
    17.332    39.287     0.200
    17.516    37.108     0.200
    17.651    37.945     0.200
    18.085    41.866     0.200
    18.323    41.783     0.200
    18.439    41.163     0.200
    18.506    40.492     0.200
    18.506    40.232     0.200
    18.817    41.081     0.200
    18.935    40.453     0.200
    19.403    40.490     0.200
    19.745    39.369     0.200
    19.708    39.900     0.200
    19.834    40.023     0.200
    19.870    39.765     0.200
    20.191    39.839     0.200
    20.257    39.992     0.200
    20.504    39.788     0.200
    20.522    39.855     0.200
    20.558    39.622     0.200
    20.733    39.768     0.200
    20.733    39.912     0.200
    20.841    40.052     0.200
     1.064     7.619     0.200
     1.440     8.542     0.200
     1.987    10.724     0.200
     2.365    12.554     0.200
     2.367    12.069     0.200
     2.523    11.947     0.200
     2.780    13.055     0.200
     2.926    12.578     0.200
     3.236    13.929     0.200
     3.351    14.409     0.200
     4.454    18.553     0.200
     5.004    17.177     0.200
     5.823    24.101     0.200
     6.696    22.733     0.200
     6.737    21.937     0.200
     7.915    25.326     0.200
     7.822    26.725     0.200
    11.175    31.181     0.200
    11.896    34.150     0.200
    12.735    35.736     0.200
    12.709    35.809     0.200
    13.455    35.887     0.200
    13.505    33.955     0.200
    15.150    39.700     0.200
    15.589    39.669     0.200
    17.497    38.197     0.200
    17.899    39.618     0.200
    18.377    43.171     0.200
    18.470    42.823     0.200
    18.734    42.355     0.200
    18.750    42.836     0.200
    18.782    42.037     0.200
    18.782    41.918     0.200
    18.782    41.287     0.200
    18.806    43.183     0.200
    18.849    42.753     0.200
    18.968    42.699     0.200
    19.112    42.392     0.200
    19.235    42.474     0.200
    19.229    41.879     0.200
    19.252    42.243     0.200
    19.544    41.626     0.200
    19.584    42.298     0.200
    19.696    41.978     0.200
    19.777    42.158     0.200
    19.879    41.828     0.200
    19.991    41.920     0.200
    20.016    41.641     0.200
    20.004    41.610     0.200
    20.126    41.957     0.200
    20.164    41.340     0.200
    20.295    41.162     0.200
    20.284    41.064     0.200
    20.372    41.483     0.200
    20.486    41.409     0.200
    20.551    41.453     0.200
    20.615    41.134     0.200
    20.735    41.650     0.200
    20.800    41.220     0.200
    20.818    40.988     0.200
    20.852    41.399     0.200
    20.943    40.150     0.200
    21.024    41.374     0.200
     1.212     7.323     0.200
     1.318     7.131     0.200
     1.377     8.121     0.200
     1.671     8.783     0.200
     1.889     9.599     0.200
     2.143     9.556     0.200
     2.280    11.180     0.200
     2.498    11.666     0.200
     2.559    11.061     0.200
     2.644    11.624     0.200
     2.682    11.918     0.200
     2.843    11.923     0.200
     2.892    12.910     0.200
     2.910    12.398     0.200
     2.946    11.332     0.200
     3.025    12.800     0.200
     3.071    12.741     0.200
     3.185    12.053     0.200
     3.217    11.336     0.200
     3.418    13.365     0.200
     3.427    13.135     0.200
     3.593    13.648     0.200
     4.178    14.861     0.200
     5.186    16.224     0.200
     5.186    16.658     0.200
     5.198    16.232     0.200
     5.748    17.343     0.200
     6.219    18.735     0.200
     8.000    23.626     0.200
    10.830    29.761     0.200
    11.781    32.625     0.200
    11.873    28.034     0.200
    11.873    27.621     0.200
    12.461    32.486     0.200
    12.561    32.555     0.200
    12.754    34.145     0.200
    12.760    34.519     0.200
    12.815    33.921     0.200
    12.871    33.889     0.200
    13.080    35.014     0.200
    13.176    34.251     0.200
    13.209    34.026     0.200
    13.226    35.555     0.200
    13.284    36.213     0.200
    13.399    36.497     0.200
    13.532    36.128     0.200
    13.555    37.368     0.200
    13.622    34.993     0.200
    13.727    35.470     0.200
    13.744    35.860     0.200
    13.854    36.766     0.200
    13.924    35.101     0.200
    13.938    37.072     0.200
    14.126    37.304     0.200
    14.176    37.997     0.200
    14.348    35.772     0.200
    14.431    34.627     0.200
    14.467    36.034     0.200
    14.473    36.973     0.200
    14.600    37.237     0.200
    14.606    36.736     0.200
    14.741    37.982     0.200
    14.944    36.984     0.200
    14.973    36.250     0.200
    15.024    38.290     0.200
    15.229    38.949     0.200
    15.248    38.543     0.200
    15.292    38.121     0.200
    15.297    37.720     0.200
    15.671    37.574     0.200
    15.676    38.838     0.200
    15.692    38.504     0.200
    15.730    37.085     0.200
    15.781    37.606     0.200
    15.837    38.381     0.200
    15.953    37.884     0.200
    16.038    38.249     0.200
    16.181    38.676     0.200
    16.337    37.697     0.200
    16.342    37.655     0.200
    16.349    39.134     0.200
    16.430    38.682     0.200
    16.572    39.234     0.200
    16.639    38.375     0.200
    16.702    39.349     0.200
    16.792    37.302     0.200
    16.937    37.277     0.200
    17.031    38.670     0.200
    17.111    38.463     0.200
    17.146    38.353     0.200
    17.248    39.433     0.200
    17.408    39.586     0.200
    17.521    38.312     0.200
    17.575    39.801     0.200
    17.631    38.968     0.200
    17.643    37.110     0.200
    17.820    36.855     0.200
    17.854    39.195     0.200
    17.860    39.212     0.200
    17.956    38.689     0.200
    17.956    38.417     0.200
    17.987    39.312     0.200
    18.190    38.518     0.200
    18.260    39.058     0.200
    18.430    41.287     0.200
    18.479    41.407     0.200
    18.538    40.252     0.200
    18.720    41.022     0.200
    18.799    40.685     0.200
    18.799    40.335     0.200
    18.803    41.481     0.200
    18.801    40.063     0.200
    18.925    40.311     0.200
    19.045    41.176     0.200
    19.358    40.334     0.200
    19.572    40.251     0.200
    19.577    39.973     0.200
    19.966    41.042     0.200
    20.008    39.771     0.200
    20.104    41.102     0.200
    20.181    39.673     0.200
    20.257    39.705     0.200
    20.451    39.871     0.200
    20.749    40.456     0.200
    20.749    40.563     0.200
     1.553     8.648     0.200
     1.939     9.012     0.200
     2.000     9.781     0.200
     2.326    11.013     0.200
     2.435    11.536     0.200
     2.586    11.637     0.200
     2.719    13.277     0.200
     3.412    14.130     0.200
     3.512    14.247     0.200
     3.854    13.704     0.200
     4.487    15.492     0.200
     4.763    18.073     0.200
     5.805    19.074     0.200
     6.175    20.448     0.200
     6.240    19.980     0.200
     6.476    21.045     0.200
     7.154    22.872     0.200
     7.304    23.030     0.200
     7.950    26.622     0.200
     8.065    27.304     0.200
     8.755    29.318     0.200
     8.972    26.226     0.200
     9.196    31.016     0.200
     9.675    28.897     0.200
     9.923    31.013     0.200
    10.027    30.937     0.200
    10.073    31.759     0.200
    10.144    30.759     0.200
    10.416    31.137     0.200
    10.861    31.302     0.200
    11.206    28.026     0.200
    11.206    27.881     0.200
    11.466    33.049     0.200
    11.771    31.341     0.200
    12.187    33.980     0.200
    12.342    32.717     0.200
    12.342    34.245     0.200
    12.480    32.292     0.200
    12.541    32.496     0.200
    12.884    34.653     0.200
    12.926    33.455     0.200
    12.968    34.843     0.200
    13.162    33.579     0.200
    13.225    33.669     0.200
    13.264    35.364     0.200
    13.278    34.713     0.200
    13.377    35.822     0.200
    13.424    31.096     0.200
    13.516    35.943     0.200
    13.685    36.014     0.200
    13.730    36.308     0.200
    13.744    34.530     0.200
    13.818    35.928     0.200
    13.898    36.086     0.200
    13.905    34.128     0.200
    14.046    37.319     0.200
    14.290    37.323     0.200
    14.311    37.375     0.200
    14.357    35.299     0.200
    14.410    34.632     0.200
    14.507    35.896     0.200
    14.671    37.466     0.200
    14.678    36.408     0.200
    14.707    37.079     0.200
    14.831    37.804     0.200
    14.894    37.795     0.200
    14.913    35.494     0.200
    14.976    35.594     0.200
    14.978    36.076     0.200
    15.129    36.544     0.200
    15.138    35.195     0.200
    15.213    38.018     0.200
    15.388    36.857     0.200
    15.411    37.679     0.200
    15.436    37.845     0.200
    15.647    36.307     0.200
    15.645    36.328     0.200
    15.667    38.627     0.200
    15.670    36.537     0.200
    15.651    40.028     0.200
    15.714    36.345     0.200
    15.779    38.397     0.200
    15.791    36.656     0.200
    15.832    38.496     0.200
    15.865    37.240     0.200
    15.866    38.424     0.200
    15.957    39.381     0.200
    16.036    38.932     0.200
    16.068    37.653     0.200
    16.178    38.038     0.200
    16.243    36.877     0.200
    16.328    36.684     0.200
    16.342    38.428     0.200
    16.348    36.697     0.200
    16.368    36.498     0.200
    16.394    36.636     0.200
    16.506    37.461     0.200
    16.598    39.577     0.200
    16.637    36.498     0.200
    16.663    37.373     0.200
    16.771    37.791     0.200
    16.787    39.607     0.200
    16.938    36.772     0.200
    16.949    38.090     0.200
    16.985    37.369     0.200
    16.993    36.894     0.200
    17.023    36.734     0.200
    17.098    37.400     0.200
    17.165    39.667     0.200
    17.209    37.722     0.200
    17.231    37.544     0.200
    17.309    36.304     0.200
    17.369    38.287     0.200
    17.503    37.842     0.200
    17.567    38.062     0.200
    17.652    37.630     0.200
    17.694    38.068     0.200
    17.769    36.788     0.200
    17.945    37.893     0.200
    17.975    38.641     0.200
    18.000    38.545     0.200
    18.000    38.197     0.200
    18.129    39.224     0.200
    18.206    38.018     0.200
    18.220    38.337     0.200
    18.232    38.278     0.200
    18.301    40.528     0.200
    18.323    41.092     0.200
    18.351    40.152     0.200
    18.392    40.925     0.200
    18.425    40.141     0.200
    18.451    40.066     0.200
    18.519    41.352     0.200
    18.570    40.643     0.200
    18.687    41.308     0.200
    18.695    40.585     0.200
    18.749    41.378     0.200
    18.953    40.852     0.200
    18.989    40.106     0.200
    19.103    39.978     0.200
    19.171    41.028     0.200
    19.200    40.967     0.200
    19.228    40.581     0.200
    19.296    40.785     0.200
    19.516    40.097     0.200
    19.663    39.607     0.200
    19.724    41.828     0.200
    19.818    40.303     0.200
    19.859    40.401     0.200
    20.144    39.423     0.200
    20.281    39.514     0.200
    20.338    39.706     0.200
    20.343    39.764     0.200
    20.412    39.740     0.200
    20.426    39.666     0.200
    20.814    39.415     0.200
    20.931    40.159     0.200
     0.294     5.708     0.200
     0.584     5.453     0.200
     1.350     7.694     0.200
     1.625     8.290     0.200
     1.799     8.269     0.200
     1.846     8.387     0.200
     1.916     9.467     0.200
     2.123     9.865     0.200
     2.193    10.300     0.200
     2.397    10.511     0.200
     2.539    11.000     0.200
     2.638    11.199     0.200
     2.791    11.504     0.200
     2.798    11.984     0.200
     3.654    13.737     0.200
     3.709    12.289     0.200
     4.434    17.601     0.200
     4.567    15.185     0.200
     4.567    14.802     0.200
     4.601    16.575     0.200
     6.053    18.250     0.200
     6.273    19.142     0.200
     6.264    22.003     0.200
     7.254    23.247     0.200
     7.767    23.267     0.200
    11.229    29.148     0.200
    11.229    29.383     0.200
    11.584    31.339     0.200
    12.290    31.718     0.200
    12.356    32.390     0.200
    12.685    33.146     0.200
    12.725    32.673     0.200
    12.768    33.031     0.200
    12.976    33.007     0.200
    13.036    33.152     0.200
    13.063    34.146     0.200
    13.085    33.480     0.200
    13.181    34.120     0.200
    13.318    34.348     0.200
    13.325    34.143     0.200
    13.485    34.748     0.200
    13.528    34.741     0.200
    13.555    34.537     0.200
    13.623    34.764     0.200
    13.706    34.984     0.200
    13.720    34.537     0.200
    13.848    34.938     0.200
    14.089    35.411     0.200
    14.112    35.835     0.200
    14.225    35.279     0.200
    14.315    36.507     0.200
    14.469    36.746     0.200
    14.510    36.040     0.200
    14.729    35.131     0.200
    14.788    35.628     0.200
    14.936    35.585     0.200
    15.011    37.169     0.200
    15.234    37.834     0.200
    15.467    38.120     0.200
    15.632    37.754     0.200
    15.665    37.907     0.200
    15.669    38.114     0.200
    15.802    37.947     0.200
    15.834    38.153     0.200
    15.978    37.727     0.200
    16.074    33.303     0.200
    16.142    37.497     0.200
    16.144    36.083     0.200
    16.161    37.333     0.200
    16.177    36.932     0.200
    16.202    37.278     0.200
    16.311    38.092     0.200
    16.395    38.855     0.200
    16.397    38.711     0.200
    16.466    37.129     0.200
    16.572    38.822     0.200
    16.748    37.945     0.200
    16.793    37.893     0.200
    16.806    38.339     0.200
    16.840    38.287     0.200
    16.964    38.604     0.200
    17.013    38.038     0.200
    17.036    37.774     0.200
    17.154    38.747     0.200
    17.183    36.452     0.200
    17.314    38.593     0.200
    17.357    38.818     0.200
    17.545    38.456     0.200
    17.588    36.070     0.200
    17.723    38.890     0.200
    17.749    37.956     0.200
    17.777    38.494     0.200
    17.808    37.802     0.200
    17.808    38.544     0.200
    18.010    38.367     0.200
    18.020    38.251     0.200
    18.152    38.194     0.200
    18.484    39.936     0.200
    18.493    39.634     0.200
    18.750    40.242     0.200
    18.787    39.095     0.200
    19.656    40.650     0.200
    20.144    40.934     0.200
    20.223    39.144     0.200
    20.613    39.950     0.200
     1.480     8.438     0.200
     1.948    10.340     0.200
     2.461    11.734     0.200
     2.568    12.685     0.200
     2.698    12.093     0.200
     2.776    12.629     0.200
     3.245    14.962     0.200
     3.544    13.383     0.200
     3.517    13.806     0.200
     3.860    14.453     0.200
     4.219    13.114     0.200
     4.270    16.330     0.200
     4.541    15.354     0.200
     5.113    15.162     0.200
     6.292    20.799     0.200
     6.221    20.555     0.200
     6.238    19.911     0.200
     6.572    23.057     0.200
     6.572    23.889     0.200
     7.191    20.627     0.200
     7.316    26.187     0.200
     9.741    28.099     0.200
    10.204    29.208     0.200
    10.270    29.453     0.200
    10.785    31.252     0.200
    10.802    30.212     0.200
    10.816    30.567     0.200
    11.333    32.143     0.200
    11.290    27.505     0.200
    11.290    28.505     0.200
    11.453    31.762     0.200
    11.489    32.234     0.200
    11.569    32.027     0.200
    11.556    34.158     0.200
    11.885    32.788     0.200
    11.785    33.695     0.200
    12.049    32.514     0.200
    12.132    32.575     0.200
    12.280    33.061     0.200
    12.342    32.904     0.200
    12.207    34.009     0.200
    12.383    34.103     0.200
    12.546    33.388     0.200
    12.595    33.113     0.200
    12.626    33.297     0.200
    12.661    32.424     0.200
    12.857    32.854     0.200
    12.955    33.827     0.200
    13.036    35.820     0.200
    13.036    35.848     0.200
    13.148    33.995     0.200
    13.228    33.808     0.200
    13.240    33.661     0.200
    13.319    33.872     0.200
    13.438    33.800     0.200
    13.558    33.425     0.200
    13.578    34.120     0.200
    13.637    34.821     0.200
    13.637    34.607     0.200
    13.902    34.558     0.200
    13.918    34.676     0.200
    14.002    33.680     0.200
    14.024    34.282     0.200
    14.061    35.018     0.200
    14.162    34.753     0.200
    14.327    35.013     0.200
    14.340    35.163     0.200
    14.410    35.229     0.200
    14.468    35.963     0.200
    14.490    35.564     0.200
    14.541    34.953     0.200
    14.573    35.294     0.200
    14.634    35.356     0.200
    14.758    35.721     0.200
    14.829    35.169     0.200
    14.863    35.204     0.200
    15.030    35.600     0.200
    15.184    36.433     0.200
    15.202    35.859     0.200
    15.215    36.522     0.200
    15.269    36.282     0.200
    15.269    36.536     0.200
    15.340    35.860     0.200
    15.120    42.908     0.200
    15.359    35.651     0.200
    15.408    35.766     0.200
    15.474    35.837     0.200
    15.542    36.512     0.200
    15.577    36.193     0.200
    15.577    36.607     0.200
    15.631    35.625     0.200
    15.649    34.524     0.200
    15.695    36.533     0.200
    15.771    37.542     0.200
    15.774    37.128     0.200
    15.774    37.491     0.200
    15.784    37.097     0.200
    15.834    36.843     0.200
    15.873    36.555     0.200
    15.872    36.591     0.200
    15.644    41.214     0.200
    15.644    38.847     0.200
    15.972    36.147     0.200
    16.061    35.999     0.200
    16.092    36.319     0.200
    16.130    37.557     0.200
    16.171    36.595     0.200
    16.264    36.723     0.200
    16.332    37.617     0.200
    16.346    37.055     0.200
    16.453    37.753     0.200
    16.520    37.276     0.200
    16.590    38.069     0.200
    16.616    37.907     0.200
    16.652    37.092     0.200
    16.667    38.007     0.200
    16.693    36.889     0.200
    16.710    37.531     0.200
    16.739    37.879     0.200
    16.748    36.888     0.200
    16.792    37.009     0.200
    16.885    37.281     0.200
    16.890    36.794     0.200
    16.932    37.892     0.200
    17.108    38.117     0.200
    16.882    41.628     0.200
    17.166    37.350     0.200
    17.177    38.719     0.200
    17.165    37.454     0.200
    17.185    37.773     0.200
    17.209    38.471     0.200
    17.219    37.293     0.200
    17.227    37.449     0.200
    17.022    43.272     0.200
    17.307    38.241     0.200
    17.339    38.257     0.200
    17.349    38.772     0.200
    17.338    38.669     0.200
    17.443    37.359     0.200
    17.507    37.236     0.200
    17.519    37.991     0.200
    17.559    37.283     0.200
    17.569    38.489     0.200
    17.630    38.127     0.200
    17.704    38.012     0.200
    17.714    38.530     0.200
    17.702    37.674     0.200
    17.699    37.619     0.200
    17.791    38.445     0.200
    17.818    38.670     0.200
    17.819    38.037     0.200
    17.824    39.099     0.200
    17.838    38.174     0.200
    17.898    38.283     0.200
    17.904    37.748     0.200
    17.955    38.763     0.200
    18.018    38.624     0.200
    18.028    38.402     0.200
    18.048    38.015     0.200
    18.079    38.713     0.200
    18.332    39.202     0.200
    18.385    38.796     0.200
    18.451    38.251     0.200
    18.500    38.888     0.200
    18.661    40.049     0.200
    18.776    40.034     0.200
    18.799    41.584     0.200
    18.869    39.690     0.200
    19.000    39.796     0.200
    19.066    39.273     0.200
    19.065    40.166     0.200
    19.066    39.322     0.200
    19.068    39.567     0.200
    19.068    39.376     0.200
    19.096    41.110     0.200
    19.096    40.852     0.200
    19.096    41.696     0.200
    19.096    41.594     0.200
    19.246    39.251     0.200
    19.276    40.680     0.200
    19.276    42.231     0.200
    19.528    39.238     0.200
    19.560    39.304     0.200
    19.664    39.230     0.200
    19.953    41.716     0.200
    20.377    40.370     0.200
    20.377    41.120     0.200
    20.419    41.286     0.200
    20.515    41.315     0.200
    20.716    39.073     0.200
    20.716    39.741     0.200
    20.896    40.714     0.200
     0.725     5.406     0.200
     1.094     7.773     0.200
     1.429     7.822     0.200
     2.010    10.059     0.200
     2.139     9.278     0.200
     2.143    10.008     0.200
     2.176    10.219     0.200
     2.318    10.607     0.200
     2.337    10.996     0.200
     2.487    11.422     0.200
     2.617    11.744     0.200
     2.694     8.863     0.200
     2.756    10.644     0.200
     3.713    13.089     0.200
     3.713    15.026     0.200
     3.768    12.868     0.200
     4.607    13.305     0.200
     6.546    19.170     0.200
     6.982    23.544     0.200
     9.717    27.073     0.200
    10.186    28.071     0.200
    10.292    28.558     0.200
    10.576    26.843     0.200
    10.576    26.956     0.200
    10.830    29.637     0.200
    10.847    29.718     0.200
    11.351    30.226     0.200
    11.429    30.773     0.200
    11.544    31.094     0.200
    11.558    30.704     0.200
    11.559    30.955     0.200
    11.731    28.619     0.200
    11.755    31.134     0.200
    11.800    28.998     0.200
    11.949    31.484     0.200
    11.992    33.231     0.200
    12.070    31.086     0.200
    12.110    31.392     0.200
    12.180    30.385     0.200
    12.279    32.211     0.200
    12.405    31.190     0.200
    12.450    32.724     0.200
    12.607    31.031     0.200
    12.642    31.114     0.200
    12.682    31.344     0.200
    12.800    31.924     0.200
    12.859    31.654     0.200
    13.007    30.920     0.200
    13.043    32.682     0.200
    13.248    31.992     0.200
    13.290    32.425     0.200
    13.293    32.416     0.200
    13.325    34.520     0.200
    13.324    34.754     0.200
    13.386    32.139     0.200
    13.444    31.374     0.200
    13.444    29.726     0.200
    13.489    32.707     0.200
    13.725    33.683     0.200
    13.725    34.101     0.200
    13.775    32.521     0.200
    13.837    32.260     0.200
    13.971    33.437     0.200
    14.036    33.059     0.200
    14.040    33.444     0.200
    14.103    33.558     0.200
    14.131    32.483     0.200
    14.236    32.300     0.200
    14.252    33.497     0.200
    14.290    33.458     0.200
    14.484    33.106     0.200
    14.515    30.778     0.200
    14.538    33.814     0.200
    14.548    34.446     0.200
    14.554    33.846     0.200
    14.643    32.917     0.200
    14.707    34.422     0.200
    14.744    32.992     0.200
    14.743    32.737     0.200
    14.769    34.509     0.200
    14.902    37.965     0.200
    14.873    33.626     0.200
    14.911    34.080     0.200
    15.049    32.996     0.200
    15.050    33.363     0.200
    15.091    33.072     0.200
    15.226    35.375     0.200
    15.228    35.494     0.200
    15.250    35.309     0.200
    15.289    34.203     0.200
    15.296    33.568     0.200
    15.349    34.693     0.200
    15.377    32.832     0.200
    15.423    33.396     0.200
    15.436    34.405     0.200
    15.436    34.112     0.200
    15.452    35.231     0.200
    15.576    34.935     0.200
    15.727    34.553     0.200
    15.733    34.462     0.200
    15.751    33.597     0.200
    15.795    35.932     0.200
    15.808    34.122     0.200
    15.816    35.615     0.200
    15.817    36.330     0.200
    15.818    35.615     0.200
    15.850    35.975     0.200
    15.904    34.211     0.200
    15.919    34.088     0.200
    15.941    33.675     0.200
    15.989    36.958     0.200
    16.044    36.045     0.200
    16.064    37.843     0.200
    16.141    34.247     0.200
    16.220    35.925     0.200
    16.282    34.484     0.200
    16.309    38.006     0.200
    16.381    34.897     0.200
    16.400    35.219     0.200
    16.420    34.226     0.200
    16.440    34.047     0.200
    16.489    34.825     0.200
    16.493    36.750     0.200
    16.540    35.082     0.200
    16.571    35.308     0.200
    16.596    36.411     0.200
    16.597    36.626     0.200
    16.614    36.445     0.200
    16.654    36.745     0.200
    16.792    35.335     0.200
    16.823    36.587     0.200
    16.892    35.454     0.200
    16.968    36.122     0.200
    17.159    35.274     0.200
    17.171    35.958     0.200
    17.184    37.333     0.200
    17.188    36.806     0.200
    17.213    37.061     0.200
    17.252    35.143     0.200
    17.261    35.383     0.200
    17.308    35.746     0.200
    17.331    35.773     0.200
    17.341    35.515     0.200
    17.420    36.981     0.200
    17.519    36.946     0.200
    17.541    37.553     0.200
    17.541    37.882     0.200
    17.560    35.755     0.200
    17.573    36.070     0.200
    17.602    36.014     0.200
    17.658    36.728     0.200
    17.670    36.458     0.200
    17.679    37.237     0.200
    17.734    36.077     0.200
    17.746    37.221     0.200
    17.777    35.808     0.200
    17.825    38.194     0.200
    17.845    35.724     0.200
    17.909    37.701     0.200
    17.927    37.985     0.200
    17.941    36.402     0.200
    18.056    38.056     0.200
    18.172    36.927     0.200
    18.206    37.255     0.200
    18.724    39.720     0.200
    18.755    40.660     0.200
    18.755    42.976     0.200
    18.873    40.048     0.200
    18.940    41.088     0.200
    18.940    41.643     0.200
    19.128    40.335     0.200
    19.397    39.729     0.200
    19.397    39.409     0.200
    19.397    39.604     0.200
    19.626    39.052     0.200
    19.790    40.334     0.200
    19.790    39.783     0.200
    19.937    40.861     0.200
    19.937    41.439     0.200
    20.354    40.007     0.200
    20.763    38.789     0.200
    20.934    39.174     0.200
    20.952    39.282     0.200
     0.650     5.636     0.200
     1.185     7.704     0.200
     1.185     7.095     0.200
     1.332     8.163     0.200
     1.478     8.335     0.200
     1.505     7.972     0.200
     1.538     8.307     0.200
     1.910     9.403     0.200
     2.008     8.884     0.200
     2.040    10.823     0.200
     2.295    10.978     0.200
     2.338    10.000     0.200
     2.362    12.061     0.200
     2.441    10.246     0.200
     2.455    10.471     0.200
     2.612    10.641     0.200
     2.679    12.006     0.200
     2.751    12.724     0.200
     2.760    13.867     0.200
     2.944    11.968     0.200
     2.953    11.404     0.200
     3.139    12.720     0.200
     3.139    12.423     0.200
     3.417    12.284     0.200
     4.581    18.590     0.200
     4.735    17.862     0.200
     6.246    19.185     0.200
     6.462    19.438     0.200
     7.186    23.682     0.200
    10.077    25.068     0.200
    10.142    31.598     0.200
    10.657    30.683     0.200
    10.689    27.912     0.200
    11.236    27.930     0.200
    11.236    28.977     0.200
    11.327    31.363     0.200
    11.362    30.370     0.200
    11.451    30.621     0.200
    11.758    31.453     0.200
    11.921    31.425     0.200
    12.004    31.603     0.200
    12.214    29.748     0.200
    12.219    32.985     0.200
    12.498    32.513     0.200
    12.730    31.832     0.200
    12.918    32.926     0.200
    12.917    34.277     0.200
    13.100    31.426     0.200
    13.113    33.167     0.200
    13.192    33.755     0.200
    13.451    32.812     0.200
    13.791    34.099     0.200
    13.896    35.435     0.200
    13.933    35.874     0.200
    14.363    34.340     0.200
    14.413    35.332     0.200
    14.445    35.651     0.200
    14.509    34.741     0.200
    14.630    35.724     0.200
    14.651    35.189     0.200
    14.705    34.931     0.200
    14.904    35.858     0.200
    15.056    35.350     0.200
    15.076    34.326     0.200
    15.087    36.687     0.200
    15.281    38.956     0.200
    15.349    35.833     0.200
    15.451    37.175     0.200
    15.451    34.652     0.200
    15.508    35.580     0.200
    15.647    35.691     0.200
    15.632    38.210     0.200
    15.632    36.366     0.200
    15.657    36.199     0.200
    15.706    37.481     0.200
    15.746    37.521     0.200
    15.746    38.686     0.200
    15.850    36.842     0.200
    15.967    36.302     0.200
    16.003    38.922     0.200
    16.048    38.278     0.200
    16.530    38.815     0.200
    16.585    36.581     0.200
    16.612    37.545     0.200
    16.627    39.372     0.200
    16.678    39.284     0.200
    16.761    38.418     0.200
    16.773    39.113     0.200
    16.805    38.979     0.200
    16.879    39.061     0.200
    16.982    38.964     0.200
    17.043    39.520     0.200
    17.099    37.755     0.200
    17.111    39.334     0.200
    17.226    37.255     0.200
    17.226    37.630     0.200
    17.371    39.120     0.200
    17.395    39.155     0.200
    17.442    38.250     0.200
    17.504    37.466     0.200
    17.588    37.520     0.200
    17.589    36.742     0.200
    17.577    39.060     0.200
    17.587    38.873     0.200
    17.665    37.376     0.200
    17.696    36.906     0.200
    17.699    37.540     0.200
    17.690    38.488     0.200
    17.718    39.251     0.200
    17.771    38.813     0.200
    17.771    38.469     0.200
    17.909    39.331     0.200
    17.936    37.504     0.200
    17.954    37.667     0.200
    17.997    39.593     0.200
    18.010    39.280     0.200
    18.031    37.962     0.200
    18.074    38.689     0.200
    18.143    38.293     0.200
    18.196    39.348     0.200
    18.197    39.209     0.200
    18.206    37.541     0.200
    18.223    36.817     0.200
    18.262    38.531     0.200
    18.275    37.878     0.200
    18.334    38.353     0.200
    18.324    39.138     0.200
    18.313    39.402     0.200
    18.375    41.213     0.200
    18.375    41.346     0.200
    19.181    41.102     0.200
    19.181    40.305     0.200
    19.845    40.583     0.200
    20.324    40.084     0.200
    20.410    40.079     0.200
    20.729    40.127     0.200
    20.720    40.763     0.200
     1.436     8.700     0.200
     1.488     9.306     0.200
     1.562     9.968     0.200
     1.562     9.838     0.200
     2.021    10.518     0.200
     1.985     9.898     0.200
     2.087    11.390     0.200
     2.296    10.751     0.200
     2.467    11.087     0.200
     2.479    12.892     0.200
     2.603    12.138     0.200
     2.735    13.025     0.200
     2.960    13.462     0.200
     3.902    14.608     0.200
     5.509    21.671     0.200
     6.183    24.598     0.200
     7.664    27.331     0.200
     7.872    27.584     0.200
    10.052    31.636     0.200
    10.092    33.546     0.200
    10.581    34.657     0.200
    10.642    34.525     0.200
    10.678    34.065     0.200
    11.144    37.233     0.200
    11.155    35.488     0.200
    11.280    36.144     0.200
    11.418    35.806     0.200
    11.977    35.733     0.200
    12.212    35.633     0.200
    12.421    36.561     0.200
    12.504    36.451     0.200
    12.698    37.520     0.200
    12.698    36.464     0.200
    12.701    37.462     0.200
    12.845    37.377     0.200
    13.045    36.646     0.200
    13.165    37.515     0.200
    13.412    37.877     0.200
    13.412    34.557     0.200
    13.714    37.429     0.200
    13.844    38.471     0.200
    13.902    37.916     0.200
    14.288    37.812     0.200
    14.314    37.612     0.200
    14.360    38.392     0.200
    14.415    38.425     0.200
    14.558    38.150     0.200
    14.616    38.488     0.200
    14.749    38.351     0.200
    14.932    38.380     0.200
    14.983    38.156     0.200
    15.035    38.184     0.200
    15.108    38.384     0.200
    15.108    39.022     0.200
    15.271    39.282     0.200
    15.414    38.156     0.200
    15.492    38.310     0.200
    15.492    39.190     0.200
    15.553    39.467     0.200
    15.591    38.617     0.200
    15.733    40.150     0.200
    15.952    38.916     0.200
    16.009    40.201     0.200
    16.090    38.757     0.200
    16.303    40.455     0.200
    16.302    40.049     0.200
    16.432    40.400     0.200
    16.525    39.785     0.200
    16.627    39.908     0.200
    16.644    40.333     0.200
    16.710    40.085     0.200
    16.741    40.142     0.200
    16.834    40.517     0.200
    16.851    40.085     0.200
    16.925    40.290     0.200
    17.020    40.567     0.200
    17.049    39.892     0.200
    17.060    39.975     0.200
    17.060    38.941     0.200
    17.165    39.973     0.200
    17.227    38.966     0.200
    17.370    39.272     0.200
    17.452    39.255     0.200
    17.464    39.073     0.200
    17.490    39.827     0.200
    17.524    39.477     0.200
    17.543    40.398     0.200
    17.695    38.964     0.200
    17.695    39.386     0.200
    17.807    40.847     0.200
    17.858    41.064     0.200
    18.005    40.186     0.200
    18.012    40.436     0.200
    18.044    39.112     0.200
    18.097    39.880     0.200
    18.208    40.677     0.200
    18.345    40.739     0.200
    18.414    39.884     0.200
    18.530    41.943     0.200
    18.746    42.845     0.200
    18.746    42.590     0.200
    18.824    43.369     0.200
    18.824    42.972     0.200
    19.552    43.264     0.200
    19.966    42.406     0.200
    19.983    42.363     0.200
    20.411    41.165     0.200
    20.459    42.151     0.200
    20.776    42.225     0.200
    20.993    42.256     0.200
     1.353     8.444     0.200
     1.797    10.062     0.200
     1.935    10.384     0.200
     2.269    11.311     0.200
     2.273    11.174     0.200
     2.542    12.366     0.200
     2.621    12.176     0.200
     2.727    13.568     0.200
     3.212    13.060     0.200
     3.537    17.549     0.200
     4.174    12.371     0.200
     4.174    13.055     0.200
     4.179    15.581     0.200
     4.222    17.735     0.200
     4.296    15.297     0.200
     4.969    20.208     0.200
     6.919    23.376     0.200
    11.676    34.403     0.200
    13.291    33.691     0.200
    13.292    34.493     0.200
    13.831    34.899     0.200
    15.172    37.964     0.200
    15.427    36.838     0.200
    16.457    40.523     0.200
    16.810    40.468     0.200
    17.291    40.420     0.200
    17.272    40.278     0.200
    17.440    40.627     0.200
    17.576    40.076     0.200
    17.578    40.726     0.200
    17.612    40.507     0.200
    17.924    39.490     0.200
    18.078    40.155     0.200
    18.078    40.632     0.200
    18.183    39.286     0.200
    18.273    40.368     0.200
    18.273    40.700     0.200
    18.337    40.301     0.200
    18.671    41.110     0.200
    18.776    42.466     0.200
    18.776    41.806     0.200
    18.996    46.311     0.200
    19.077    43.918     0.200
    19.357    40.924     0.200
    19.357    41.166     0.200
    19.585    42.033     0.200
    20.239    41.913     0.200
    20.659    41.106     0.200
    20.728    41.167     0.200
    20.809    41.164     0.200
     1.105     8.554     0.200
     1.171     9.491     0.200
     1.171     8.869     0.200
     1.335    10.029     0.200
     1.564    10.811     0.200
     1.655    10.420     0.200
     2.020     9.962     0.200
     2.076    11.155     0.200
     2.403    13.285     0.200
     2.558    12.782     0.200
     2.676    13.346     0.200
     2.684    13.510     0.200
     2.943    15.425     0.200
     3.018    15.409     0.200
     3.020    15.165     0.200
     3.257    15.598     0.200
     3.257    17.297     0.200
     3.436    14.116     0.200
     3.493    13.869     0.200
     4.124    13.335     0.200
     4.442    16.338     0.200
     4.442    16.025     0.200
     4.699    20.751     0.200
     4.851    19.667     0.200
     5.891    21.206     0.200
     6.125    21.206     0.200
     6.149    20.611     0.200
     6.337    22.530     0.200
     6.578    22.961     0.200
     6.578    24.050     0.200
     7.098    23.695     0.200
     7.098    23.496     0.200
     7.232    25.802     0.200
     8.038    23.477     0.200
     8.038    23.747     0.200
     8.038    24.278     0.200
     9.071    28.551     0.200
     9.123    33.391     0.200
     9.611    33.497     0.200
    10.128    26.135     0.200
    10.402    31.501     0.200
    11.187    29.604     0.200
    11.187    27.534     0.200
    11.450    31.808     0.200
    11.568    34.481     0.200
    11.568    34.629     0.200
    12.120    34.566     0.200
    12.120    33.538     0.200
    12.436    35.905     0.200
    12.436    33.315     0.200
    13.027    36.162     0.200
    13.026    36.286     0.200
    13.026    34.161     0.200
    13.026    35.341     0.200
    13.124    37.095     0.200
    13.230    34.382     0.200
    13.317    36.039     0.200
    13.499    33.726     0.200
    13.601    35.535     0.200
    13.601    35.180     0.200
    13.661    37.570     0.200
    13.694    37.299     0.200
    13.807    36.459     0.200
    14.012    35.543     0.200
    14.704    38.352     0.200
    15.220    37.756     0.200
    15.220    37.521     0.200
    15.216    38.916     0.200
    15.431    40.259     0.200
    15.431    38.626     0.200
    15.514    36.528     0.200
    15.514    36.352     0.200
    15.544    40.177     0.200
    15.570    39.369     0.200
    15.570    39.165     0.200
    15.736    37.647     0.200
    15.743    39.377     0.200
    15.743    39.826     0.200
    15.743    40.701     0.200
    15.877    40.298     0.200
    15.931    40.564     0.200
    17.327    39.326     0.200
    17.366    37.672     0.200
    17.452    37.956     0.200
    17.607    40.208     0.200
    17.758    39.727     0.200
    17.857    39.668     0.200
    17.857    40.152     0.200
    18.082    40.381     0.200
    18.094    39.881     0.200
    18.094    40.271     0.200
    18.245    38.479     0.200
    18.245    39.822     0.200
    18.402    42.109     0.200
    18.424    42.296     0.200
    18.424    41.362     0.200
    18.494    42.830     0.200
    18.494    42.580     0.200
    18.526    41.841     0.200
    18.552    42.199     0.200
    19.089    41.705     0.200
    19.089    41.385     0.200
    19.302    41.677     0.200
    19.302    42.290     0.200
    19.961    42.198     0.200
    20.253    41.369     0.200
    20.288    41.896     0.200
    20.383    41.880     0.200
    20.383    41.560     0.200
    20.445    41.552     0.200
    20.528    41.559     0.200
    20.814    43.460     0.200
    20.964    41.122     0.200
     1.620     9.825     0.200
     1.914     9.554     0.200
     2.128    10.639     0.200
     2.464    11.629     0.200
     2.474    12.180     0.200
     2.643    12.422     0.200
     2.805    12.988     0.200
     3.063    12.874     0.200
     3.073    12.297     0.200
     3.218    14.850     0.200
     3.551    13.858     0.200
     4.231    13.117     0.200
     4.570    15.531     0.200
     4.570    15.832     0.200
     6.546    22.327     0.200
     7.223    22.274     0.200
     8.064    23.426     0.200
     9.015    23.396     0.200
    10.252    26.261     0.200
    10.821    28.366     0.200
    11.315    28.244     0.200
    11.476    28.778     0.200
    11.529    31.995     0.200
    12.240    31.529     0.200
    12.350    35.881     0.200
    13.014    35.577     0.200
    13.014    34.581     0.200
    13.014    35.580     0.200
    13.014    35.031     0.200
    13.014    35.026     0.200
    13.347    33.108     0.200
    13.552    32.893     0.200
    13.622    32.774     0.200
    13.622    34.716     0.200
    14.051    35.576     0.200
    14.819    38.380     0.200
    15.259    37.130     0.200
    15.259    36.615     0.200
    15.572    36.310     0.200
    15.572    35.747     0.200
    15.547    36.232     0.200
    15.725    39.170     0.200
    15.725    38.701     0.200
    15.678    37.731     0.200
    15.678    38.888     0.200
    15.759    37.679     0.200
    15.759    37.198     0.200
    15.871    39.407     0.200
    15.921    39.064     0.200
    15.997    39.323     0.200
    16.546    39.214     0.200
    17.330    38.676     0.200
    17.444    37.953     0.200
    17.444    37.340     0.200
    17.516    38.397     0.200
    17.736    39.205     0.200
    17.820    38.772     0.200
    17.885    37.734     0.200
    17.885    39.347     0.200
    18.129    38.636     0.200
    18.340    38.544     0.200
    18.462    38.459     0.200
    18.448    41.858     0.200
    18.448    41.975     0.200
    18.505    41.694     0.200
    19.059    39.583     0.200
    19.073    40.979     0.200
    19.073    41.362     0.200
    19.246    40.887     0.200
    19.246    41.528     0.200
    19.319    39.257     0.200
    19.927    41.301     0.200
    20.351    40.629     0.200
    20.389    40.662     0.200
    20.696    39.817     0.200
     1.481     9.242     0.200
     1.526     8.337     0.200
     2.266    10.312     0.200
     3.063    12.931     0.200
     3.034    15.429     0.200
     3.034    13.539     0.200
     3.234    13.896     0.200
     4.543    21.017     0.200
     4.377    18.825     0.200
     5.001    16.065     0.200
     6.366    19.003     0.200
     7.656    22.319     0.200
     9.443    26.150     0.200
    11.719    29.566     0.200
    11.719    29.773     0.200
    12.667    34.378     0.200
    12.889    33.702     0.200
    12.889    34.192     0.200
    12.888    34.083     0.200
    12.888    33.728     0.200
    13.610    37.537     0.200
    15.580    38.576     0.200
    17.255    39.185     0.200
    17.255    39.295     0.200
    17.628    39.276     0.200
    17.893    38.995     0.200
    17.944    39.322     0.200
    18.054    40.142     0.200
    18.054    39.927     0.200
    18.205    38.999     0.200
    18.604    39.696     0.200
    18.935    41.229     0.200
    18.935    41.885     0.200
    18.983    42.391     0.200
    19.160    40.379     0.200
    19.406    40.560     0.200
    19.474    40.080     0.200
    19.535    39.952     0.200
    20.021    39.514     0.200
    20.269    40.644     0.200
    20.449    41.098     0.200
    20.561    39.562     0.200
    20.605    40.642     0.200
    20.915    43.145     0.200
    20.981    40.501     0.200
     0.292     5.846     0.200
     0.397     5.471     0.200
     0.827     6.360     0.200
     0.791     6.123     0.200
     1.197     7.284     0.200
     1.306     8.094     0.200
     1.268     7.695     0.200
     1.400     9.236     0.200
     1.584     8.243     0.200
     1.839     8.706     0.200
     1.816    10.769     0.200
     2.012    10.202     0.200
     2.019    10.435     0.200
     2.229     9.824     0.200
     2.249    10.634     0.200
     2.858    11.337     0.200
     2.793    15.013     0.200
     2.793    11.669     0.200
     3.494    12.040     0.200
    12.601    33.103     0.200
     1.621     9.627     0.200
     1.822     8.863     0.200
     2.216    10.763     0.200
     2.561    11.999     0.200
     2.560    11.868     0.200
     2.637    10.696     0.200
     2.638    11.958     0.200
     2.638    12.306     0.200
     2.850    12.454     0.200
     2.925    12.794     0.200
     2.906    13.823     0.200
     2.939    13.294     0.200
     3.140    15.330     0.200
     3.210    15.872     0.200
     3.662    14.425     0.200
     4.362    10.503     0.200
     4.249    16.854     0.200
     4.438    18.297     0.200
     4.704    14.762     0.200
     4.704    16.211     0.200
     4.537    19.993     0.200
     4.669    18.754     0.200
     5.747    17.762     0.200
     6.318    17.931     0.200
     6.391    20.905     0.200
     6.542    21.407     0.200
     7.350    22.144     0.200
     8.088    24.946     0.200
     9.499    26.794     0.200
    10.311    29.357     0.200
    11.516    33.531     0.200
    13.030    35.698     0.200
    13.030    34.484     0.200
    13.031    33.395     0.200
    13.031    33.249     0.200
    14.120    35.601     0.200
    15.328    36.756     0.200
    15.298    39.508     0.200
    15.615    37.092     0.200
    15.659    36.545     0.200
    15.813    37.329     0.200
    16.071    37.731     0.200
    15.958    39.253     0.200
    16.675    38.934     0.200
    16.802    37.140     0.200
    17.309    41.708     0.200
    17.364    39.002     0.200
    17.549    38.033     0.200
    18.392    41.358     0.200
    18.582    38.516     0.200
    18.738    38.775     0.200
    18.889    40.294     0.200
    19.144    39.533     0.200
    19.312    39.652     0.200
    19.499    39.053     0.200
    19.911    38.439     0.200
    19.944    38.740     0.200
    20.253    38.594     0.200
    20.404    39.279     0.200
     0.087     5.773     0.200
     0.514     5.448     0.200
     0.863     5.653     0.200
     1.062     7.132     0.200
     1.217     7.248     0.200
     1.217     8.088     0.200
     1.338     7.239     0.200
     1.345     7.271     0.200
     1.675     8.071     0.200
     1.743     8.381     0.200
     1.896     9.543     0.200
     1.990     9.442     0.200
     2.207     9.802     0.200
     2.251     9.339     0.200
     2.313    11.268     0.200
     2.364    10.727     0.200
     2.582    12.453     0.200
     2.629    10.091     0.200
     2.695    10.934     0.200
     2.742    10.616     0.200
     2.946    14.664     0.200
     2.946    11.574     0.200
     3.286    14.529     0.200
     3.655    12.059     0.200
     3.683    16.276     0.200
     3.969    17.526     0.200
     4.314    16.679     0.200
     4.394    17.145     0.200
     4.554    17.177     0.200
     4.635    14.633     0.200
     4.801    15.578     0.200
     5.481    19.792     0.200
     6.271    19.235     0.200
     7.319    21.188     0.200
    12.736    32.325     0.200
    12.736    31.679     0.200
    12.736    34.453     0.200
    12.736    32.113     0.200
    13.796    33.546     0.200
    15.337    36.805     0.200
    15.447    37.274     0.200
    15.757    36.709     0.200
    16.350    38.089     0.200
    16.685    38.707     0.200
    17.037    38.991     0.200
    17.055    39.329     0.200
    17.293    37.885     0.200
    18.796    39.585     0.200
    19.327    38.778     0.200
     0.406     5.483     0.200
     0.697     6.041     0.200
     0.710     5.961     0.200
     0.710     6.243     0.200
     0.941     6.368     0.200
     0.920     6.332     0.200
     0.924     6.938     0.200
     1.152     8.051     0.200
     1.183     7.626     0.200
     1.226     8.142     0.200
     1.286     7.238     0.200
     1.326     8.630     0.200
     1.392     8.423     0.200
     1.948     9.152     0.200
     1.917    10.232     0.200
     2.078    10.639     0.200
     2.104    11.182     0.200
     2.112    11.364     0.200
     2.097    10.141     0.200
     2.117    10.182     0.200
     2.135    11.388     0.200
     2.389    11.140     0.200
     2.389    11.483     0.200
     2.441    12.354     0.200
     2.514    10.597     0.200
     2.645    11.966     0.200
     2.947    12.255     0.200
     2.940    12.451     0.200
     3.157    13.233     0.200
     3.345    12.794     0.200
     3.469    14.714     0.200
     3.469    14.870     0.200
     3.654    11.197     0.200
     3.872    13.051     0.200
     3.872    13.770     0.200
     3.878    15.850     0.200
     4.422    14.486     0.200
     4.435    15.636     0.200
     4.422    16.214     0.200
     5.049    18.028     0.200
     5.111    19.600     0.200
     5.296    18.257     0.200
     5.561    19.436     0.200
     5.617    18.557     0.200
     5.969    20.182     0.200
     6.100    18.012     0.200
     6.345    17.846     0.200
     6.543    20.992     0.200
     6.543    20.773     0.200
     6.735    20.117     0.200
     6.735    21.297     0.200
     7.316    21.048     0.200
     7.366    22.674     0.200
     7.935    21.609     0.200
     8.364    22.977     0.200
     8.673    23.510     0.200
     9.394    28.628     0.200
     9.528    26.554     0.200
     9.554    25.971     0.200
     9.897    23.837     0.200
    10.070    30.830     0.200
    10.599    28.089     0.200
    10.969    32.376     0.200
    11.339    30.199     0.200
    11.570    32.151     0.200
    11.593    31.778     0.200
    11.595    31.512     0.200
    11.637    32.121     0.200
    11.745    31.815     0.200
    12.228    34.794     0.200
    12.624    32.914     0.200
    12.819    37.181     0.200
    13.082    34.176     0.200
    13.082    33.390     0.200
    13.081    33.715     0.200
    13.081    33.855     0.200
    13.257    31.997     0.200
    13.503    33.136     0.200
    13.503    33.870     0.200
    13.582    34.444     0.200
    13.836    33.594     0.200
    13.836    32.711     0.200
    14.204    35.789     0.200
    14.345    35.747     0.200
    14.730    37.642     0.200
    14.711    34.786     0.200
    14.921    37.505     0.200
    15.045    35.217     0.200
    15.252    37.434     0.200
    15.255    34.564     0.200
    15.255    34.845     0.200
    15.261    35.149     0.200
    15.576    34.436     0.200
    15.630    35.932     0.200
    15.630    35.799     0.200
    15.820    38.394     0.200
    15.820    37.535     0.200
    15.965    38.177     0.200
    16.062    36.073     0.200
    16.257    36.060     0.200
    16.391    36.876     0.200
    16.633    37.951     0.200
    16.635    37.046     0.200
    16.762    35.087     0.200
    17.014    36.777     0.200
    17.014    35.340     0.200
    17.065    38.915     0.200
    17.054    35.932     0.200
    17.105    38.155     0.200
    17.106    36.397     0.200
    17.307    37.885     0.200
    17.307    38.135     0.200
    17.479    37.310     0.200
    17.616    36.670     0.200
    17.726    37.155     0.200
    17.726    37.515     0.200
    17.819    35.524     0.200
    17.819    36.172     0.200
    17.863    37.825     0.200
    17.998    37.061     0.200
    18.040    38.260     0.200
    18.040    37.760     0.200
    18.098    37.784     0.200
    18.088    37.442     0.200
    18.177    37.690     0.200
    18.177    37.541     0.200
    18.480    40.151     0.200
    18.511    40.291     0.200
    18.511    40.698     0.200
    18.612    39.538     0.200
    18.693    41.058     0.200
    18.693    40.644     0.200
    19.154    40.078     0.200
    19.154    39.789     0.200
    19.154    39.922     0.200
    19.545    40.460     0.200
    20.125    38.949     0.200
    20.108    39.867     0.200
    20.013    40.905     0.200
    20.516    39.565     0.200
    20.516    39.432     0.200
    20.689    39.522     0.200
    20.705    39.339     0.200
     0.302     6.199     0.200
     0.423     6.150     0.200
     0.633     5.974     0.200
     0.815     6.509     0.200
     0.862     6.525     0.200
     0.865     6.640     0.200
     0.986     7.238     0.200
     1.091     6.906     0.200
     1.119     7.133     0.200
     1.157     7.788     0.200
     1.257     7.531     0.200
     1.277     8.126     0.200
     1.455     7.783     0.200
     1.603     9.358     0.200
     1.933     9.744     0.200
     1.942     9.407     0.200
     1.961    10.127     0.200
     1.970     8.942     0.200
     2.017    10.243     0.200
     2.400    12.628     0.200
     2.400     9.956     0.200
     2.675    11.108     0.200
     3.567    15.067     0.200
     3.701    12.929     0.200
     6.811    22.386     0.200
     8.200    22.104     0.200
    11.823    31.058     0.200
    13.126    35.135     0.200
    13.126    34.346     0.200
    13.502    34.912     0.200
    13.502    34.209     0.200
    13.811    36.987     0.200
    13.811    35.866     0.200
    15.870    38.212     0.200
    15.870    38.395     0.200
    17.328    38.442     0.200
    17.535    38.397     0.200
    17.596    38.705     0.200
    18.250    40.647     0.200
    18.530    39.694     0.200
    18.658    39.185     0.200
    19.054    38.800     0.200
    19.153    38.979     0.200
    19.200    39.343     0.200
    20.340    39.738     0.200
     0.101     6.693     0.200
     0.370     5.687     0.200
     0.540     5.791     0.200
     0.672     5.746     0.200
     0.840     6.408     0.200
     0.904     6.727     0.200
     1.304     7.925     0.200
     1.405     7.967     0.200
     1.540     7.882     0.200
     1.595     8.508     0.200
     1.728     9.124     0.200
     1.832     8.439     0.200
     1.839     9.111     0.200
     1.887     8.682     0.200
     1.866    10.120     0.200
     1.947     9.828     0.200
     2.152    10.123     0.200
     2.166     9.453     0.200
     2.186    10.398     0.200
     2.191    10.675     0.200
     2.200    10.067     0.200
     2.287    10.497     0.200
     2.390     8.891     0.200
     2.534    10.565     0.200
     2.590    10.429     0.200
     2.709    11.905     0.200
     3.472    11.128     0.200
     3.566    12.945     0.200
     3.566    13.215     0.200
     3.648    12.591     0.200
     3.797    13.129     0.200
     4.442    16.419     0.200
     4.478    14.648     0.200
     4.508    18.418     0.200
     4.515    17.383     0.200
     4.523    17.670     0.200
     4.541    17.685     0.200
     4.615    16.342     0.200
     4.685    17.557     0.200
     0.291     5.703     0.200
     0.288     5.796     0.200
     0.371     5.538     0.200
     0.251     5.744     0.200
     0.401     5.519     0.200
     0.876     5.990     0.200
     0.939     6.485     0.200
     1.182     7.045     0.200
     1.329     7.861     0.200
     1.346     7.607     0.200
     1.453     8.100     0.200
     1.543     8.343     0.200
     1.457     7.656     0.200
     1.766     9.690     0.200
     1.882     8.854     0.200
     1.959     9.271     0.200
     1.958     8.963     0.200
     1.903    10.163     0.200
     2.157    10.183     0.200
     2.162     9.656     0.200
     2.226     9.847     0.200
     2.223     9.328     0.200
     2.224     9.461     0.200
     2.230     9.851     0.200
     2.276     9.720     0.200
     2.308     9.250     0.200
     2.324    11.072     0.200
     2.371    13.071     0.200
     2.383    10.125     0.200
     2.501    10.543     0.200
     2.537    11.452     0.200
     2.594    11.608     0.200
     2.620    12.187     0.200
     2.846    10.226     0.200
     2.824    10.200     0.200
     2.834     9.556     0.200
     2.877    11.045     0.200
     3.779    12.662     0.200
     4.068    13.664     0.200
     4.039    16.412     0.200
     4.120    18.050     0.200
     4.125    16.944     0.200
     4.132    17.783     0.200
     4.153    17.086     0.200
     4.277    16.318     0.200
     4.912    15.715     0.200
     7.780    23.099     0.200
     7.780    23.303     0.200
     7.870    23.811     0.200
    12.596    33.918     0.200
     1.675     9.989     0.200
     1.686    10.169     0.200
     1.724     9.877     0.200
     1.788    10.192     0.200
     1.817    10.269     0.200
     1.918    10.480     0.200
     2.170    11.096     0.200
     2.135    10.407     0.200
     2.289    12.977     0.200
     2.309    11.273     0.200
     2.468    11.473     0.200
     2.617    12.366     0.200
     2.610    11.692     0.200
     2.632    11.340     0.200
     2.621    13.156     0.200
     2.652    11.715     0.200
     2.641    13.049     0.200
     2.754    13.226     0.200
     3.280    13.686     0.200
     3.331    11.962     0.200
     3.390    14.748     0.200
     3.390    13.066     0.200
     3.390    13.546     0.200
     4.047    12.948     0.200
     4.403    20.352     0.200
     4.375    15.187     0.200
     4.375    15.693     0.200
     4.736    18.800     0.200
     4.820    19.774     0.200
     4.825    19.947     0.200
     4.832    19.475     0.200
     4.853    19.066     0.200
     4.889    18.168     0.200
     4.966    14.407     0.200
     4.972    19.039     0.200
     6.010    20.129     0.200
     6.468    18.888     0.200
     6.710    21.061     0.200
     7.015    23.618     0.200
     7.015    26.038     0.200
     7.754    23.851     0.200
     8.148    25.142     0.200
     9.167    25.873     0.200
     9.978    28.964     0.200
    11.560    31.858     0.200
    11.560    30.225     0.200
    11.701    33.523     0.200
    12.023    32.735     0.200
    13.153    35.216     0.200
    13.153    35.779     0.200
    13.153    34.803     0.200
    13.153    35.213     0.200
    13.587    36.806     0.200
    13.592    34.376     0.200
    13.712    34.581     0.200
    13.712    32.464     0.200
    14.112    33.957     0.200
    14.599    36.917     0.200
    14.705    37.653     0.200
    15.095    36.644     0.200
    15.328    38.309     0.200
    15.600    36.609     0.200
    15.600    35.316     0.200
    15.847    39.998     0.200
    16.129    39.130     0.200
    16.148    39.245     0.200
    16.678    39.773     0.200
    16.962    38.978     0.200
    17.430    39.185     0.200
    17.430    38.952     0.200
    17.447    39.387     0.200
    17.473    39.902     0.200
    17.504    40.023     0.200
    17.964    38.862     0.200
    18.175    40.107     0.200
    18.211    39.720     0.200
    18.211    39.365     0.200
    18.289    38.435     0.200
    18.289    37.766     0.200
    18.382    41.245     0.200
    18.530    41.411     0.200
    18.554    41.492     0.200
    19.217    41.132     0.200
    19.436    40.944     0.200
    19.436    41.877     0.200
    20.093    40.570     0.200
    20.514    40.688     0.200
     0.171     5.928     0.200
     0.204     5.639     0.200
     0.463     5.564     0.200
     0.484     5.705     0.200
     0.576     5.519     0.200
     0.911     6.229     0.200
     1.069     6.906     0.200
     1.144     6.730     0.200
     1.253     8.051     0.200
     1.357     7.810     0.200
     1.515     8.497     0.200
     1.616     8.592     0.200
     1.683     9.419     0.200
     1.687     9.141     0.200
     1.973     8.507     0.200
     2.107     9.713     0.200
     2.122     9.994     0.200
     2.163     9.191     0.200
     2.214    10.379     0.200
     2.215    10.324     0.200
     2.229     9.583     0.200
     2.283    10.064     0.200
     2.345    10.764     0.200
     2.343    10.346     0.200
     2.386    10.708     0.200
     2.399     9.922     0.200
     2.458    11.084     0.200
     2.500    10.633     0.200
     2.521    10.460     0.200
     2.560    12.198     0.200
     2.590    10.677     0.200
     2.619    13.255     0.200
     2.771    12.131     0.200
     2.975    12.274     0.200
     3.166    11.884     0.200
     3.183    12.252     0.200
     3.336    12.811     0.200
     3.836    14.054     0.200
     3.857    12.261     0.200
     3.920    15.398     0.200
     3.925    17.184     0.200
     3.932    14.874     0.200
     3.953    15.422     0.200
     3.995    14.924     0.200
     4.073    15.094     0.200
     4.197    12.420     0.200
     4.245    15.280     0.200
     5.102    15.648     0.200
     0.477     6.138     0.200
     0.664     6.229     0.200
     0.923     6.337     0.200
     1.110     6.934     0.200
     1.275     7.473     0.200
     1.397     8.069     0.200
     1.399     7.918     0.200
     1.379     8.205     0.200
     1.519     8.370     0.200
     1.690     8.017     0.200
     1.801     8.710     0.200
     1.724     9.040     0.200
     1.930     9.346     0.200
     1.920    10.684     0.200
     1.960     8.566     0.200
     2.047     9.278     0.200
     2.135    10.005     0.200
     2.266     9.914     0.200
     2.263    10.358     0.200
     2.172    11.412     0.200
     2.286    10.007     0.200
     2.309     9.484     0.200
     2.299    10.013     0.200
     2.317     9.304     0.200
     2.317     9.300     0.200
     2.316     9.915     0.200
     2.362    10.423     0.200
     2.375    10.113     0.200
     2.375    10.504     0.200
     2.375     9.849     0.200
     2.375    10.119     0.200
     2.384    10.268     0.200
     2.411    10.145     0.200
     2.421    10.251     0.200
     2.445    10.927     0.200
     2.488    12.211     0.200
     2.533    10.208     0.200
     2.544    10.469     0.200
     2.548    10.153     0.200
     2.644    10.312     0.200
     2.690    10.307     0.200
     2.738    10.907     0.200
     2.710    11.288     0.200
     2.798    10.556     0.200
     2.878    10.597     0.200
     2.904    10.712     0.200
     2.907    11.924     0.200
     2.906    11.928     0.200
     2.915    11.234     0.200
     2.976    12.979     0.200
     3.143    11.069     0.200
     3.148    13.295     0.200
     3.248    14.259     0.200
     3.347    11.028     0.200
     3.347    11.017     0.200
     3.667    10.184     0.200
     3.638    13.264     0.200
     3.730    13.075     0.200
     3.766    11.048     0.200
     3.726    13.476     0.200
     3.854    13.088     0.200
     4.174    10.635     0.200
     4.308    16.852     0.200
     4.387    17.290     0.200
     4.392    17.677     0.200
     4.399    18.033     0.200
     4.419    17.312     0.200
     4.438    17.723     0.200
     4.469    16.095     0.200
     4.546    17.888     0.200
     4.684    12.755     0.200
     4.675    14.360     0.200
     4.675    14.985     0.200
     4.854    15.265     0.200
     5.203    12.001     0.200
     5.226    18.032     0.200
     5.386    16.200     0.200
     5.513    18.778     0.200
     5.588    19.037     0.200
     6.030    22.560     0.200
     6.305    20.718     0.200
     6.305    20.539     0.200
     6.369    18.519     0.200
     6.422    20.241     0.200
     7.353    22.925     0.200
     7.486    22.667     0.200
     7.519    23.485     0.200
     7.609    22.980     0.200
     7.854    21.042     0.200
     8.158    26.694     0.200
     9.478    26.867     0.200
     9.560    29.302     0.200
    10.330    28.632     0.200
    11.266    27.186     0.200
    11.266    28.383     0.200
    11.287    29.874     0.200
    11.928    29.486     0.200
    12.396    29.840     0.200
    12.778    32.369     0.200
    12.778    32.343     0.200
    12.778    32.491     0.200
    12.778    33.126     0.200
    13.376    30.187     0.200
    13.409    33.318     0.200
    13.409    32.665     0.200
    13.855    34.809     0.200
    13.855    32.571     0.200
    14.374    33.720     0.200
    14.937    34.139     0.200
    15.063    34.715     0.200
    15.063    34.428     0.200
    15.400    34.679     0.200
    15.486    37.202     0.200
    15.547    35.666     0.200
    15.547    34.869     0.200
    15.637    37.433     0.200
    15.788    36.678     0.200
    15.823    34.739     0.200
    16.375    37.493     0.200
    16.409    35.833     0.200
    16.561    34.342     0.200
    16.746    36.464     0.200
    17.071    35.233     0.200
    17.108    35.844     0.200
    17.059    36.853     0.200
    17.071    38.013     0.200
    17.103    36.852     0.200
    17.103    37.092     0.200
    17.307    35.441     0.200
    17.307    34.601     0.200
    17.355    36.040     0.200
    17.605    36.036     0.200
    17.654    36.836     0.200
    17.678    36.254     0.200
    17.678    36.082     0.200
    17.883    37.542     0.200
    17.883    36.962     0.200
    18.165    37.247     0.200
    18.165    37.503     0.200
    18.165    37.048     0.200
    18.239    36.197     0.200
    18.253    37.036     0.200
    18.266    37.867     0.200
    18.296    36.486     0.200
    18.323    37.000     0.200
    18.323    36.558     0.200
    18.531    39.021     0.200
    18.825    37.767     0.200
    18.836    38.809     0.200
    18.899    37.653     0.200
    20.110    38.028     0.200
     1.129     8.288     0.200
     1.145     7.745     0.200
     1.347     9.211     0.200
     1.499    10.064     0.200
     1.571     9.049     0.200
     1.611     9.222     0.200
     1.660     9.919     0.200
     1.618     9.801     0.200
     1.864    10.956     0.200
     1.883    10.376     0.200
     1.922    10.786     0.200
     2.080    10.970     0.200
     2.162    10.429     0.200
     2.177    12.345     0.200
     2.476    12.262     0.200
     2.491    13.752     0.200
     2.501    11.505     0.200
     2.500    11.732     0.200
     2.500    11.729     0.200
     2.502    12.680     0.200
     2.504    12.663     0.200
     2.584    12.292     0.200
     2.526    13.287     0.200
     2.574    12.499     0.200
     2.588    12.464     0.200
     2.588    13.483     0.200
     2.588    13.476     0.200
     2.588    13.355     0.200
     2.601    12.112     0.200
     2.616    12.688     0.200
     2.634    12.936     0.200
     2.657    12.878     0.200
     2.692    12.305     0.200
     2.715    12.282     0.200
     2.747    12.958     0.200
     2.760    12.668     0.200
     2.775    12.152     0.200
     2.849    12.249     0.200
     2.870    13.201     0.200
     2.869    13.205     0.200
     2.878    11.897     0.200
     2.857    13.829     0.200
     2.897    12.818     0.200
     3.091    16.552     0.200
     3.188    16.327     0.200
     3.206    14.320     0.200
     3.244    13.287     0.200
     3.607    14.625     0.200
     3.562    13.314     0.200
     3.563    13.304     0.200
     3.775    14.146     0.200
     3.781    13.177     0.200
     3.853    14.725     0.200
     3.933    12.863     0.200
     4.238    15.580     0.200
     4.289    18.327     0.200
     4.473    18.306     0.200
     4.565    20.427     0.200
     4.569    19.605     0.200
     4.575    19.787     0.200
     4.597    19.275     0.200
     4.616    20.491     0.200
     4.635    14.869     0.200
     4.635    16.084     0.200
     4.707    19.061     0.200
     4.718    14.712     0.200
     4.842    19.680     0.200
     5.355    17.614     0.200
     5.378    17.698     0.200
     5.743    18.494     0.200
     6.226    19.932     0.200
     6.277    22.948     0.200
     6.331    21.451     0.200
     6.536    23.867     0.200
     6.536    23.528     0.200
     7.285    24.449     0.200
     7.285    23.320     0.200
     7.384    24.846     0.200
     7.420    25.004     0.200
     7.507    24.593     0.200
    12.698    32.019     0.200
    13.013    34.348     0.200
    13.013    34.559     0.200
    13.013    34.782     0.200
    14.457    34.432     0.200
    14.750    37.344     0.200
    15.284    38.585     0.200
    15.284    38.714     0.200
    15.606    36.920     0.200
    15.606    38.217     0.200
    15.643    38.809     0.200
    15.721    39.828     0.200
    15.777    38.992     0.200
    16.023    39.018     0.200
    16.739    40.489     0.200
    17.302    40.959     0.200
    17.292    39.031     0.200
    17.338    40.398     0.200
    17.553    38.986     0.200
    17.851    40.115     0.200
    17.856    39.516     0.200
    17.905    39.064     0.200
    17.905    40.365     0.200
    18.159    38.547     0.200
    18.379    41.806     0.200
    18.430    42.020     0.200
    18.430    42.504     0.200
    19.071    41.487     0.200
    19.223    42.396     0.200
    19.915    41.302     0.200
    20.341    41.399     0.200
    20.472    41.074     0.200
     1.576    10.053     0.200
     1.689    10.647     0.200
     1.810    11.012     0.200
     1.987    11.486     0.200
     1.864    11.488     0.200
     2.289    12.890     0.200
     2.289    12.894     0.200
     2.403    13.343     0.200
     2.495    12.613     0.200
     2.529    12.219     0.200
     2.635    13.047     0.200
     2.635    13.068     0.200
     2.682    12.254     0.200
     2.599    12.355     0.200
     2.752    15.049     0.200
     2.793    15.285     0.200
     2.820    14.879     0.200
     2.850    15.790     0.200
     2.871    13.604     0.200
     2.871    14.924     0.200
     2.872    13.591     0.200
     2.957    15.957     0.200
     2.974    16.239     0.200
     2.984    15.671     0.200
     3.131    16.759     0.200
     3.316    17.428     0.200
     3.336    14.837     0.200
     3.387    18.218     0.200
     3.597    13.292     0.200
     3.835    18.677     0.200
     3.814    16.345     0.200
     3.953    14.022     0.200
     4.025    15.794     0.200
     4.025    15.688     0.200
     4.100    12.739     0.200
     4.509    17.084     0.200
     4.679    15.256     0.200
     4.758    17.127     0.200
     5.041    23.227     0.200
     5.204    21.197     0.200
     5.289    22.032     0.200
     5.294    20.985     0.200
     5.301    22.251     0.200
     5.321    22.373     0.200
     5.340    23.600     0.200
     5.355    21.612     0.200
     5.439    21.845     0.200
     5.637    19.279     0.200
     5.675    21.197     0.200
     6.112    22.021     0.200
     6.588    21.416     0.200
     6.621    23.487     0.200
     7.118    26.397     0.200
     7.118    24.858     0.200
     8.420    27.081     0.200
     8.796    27.532     0.200
    10.882    27.291     0.200
    11.826    33.827     0.200
    11.826    31.948     0.200
    12.999    34.229     0.200
    13.517    37.325     0.200
    16.247    40.912     0.200
    17.501    40.047     0.200
    17.599    41.034     0.200
    17.772    41.227     0.200
    18.446    42.949     0.200
    18.514    41.410     0.200
    19.055    44.094     0.200
    19.055    43.809     0.200
    19.877    43.578     0.200
    20.500    43.204     0.200
     1.011     6.430     0.200
     1.454     7.100     0.200
     1.811     9.287     0.200
     1.861     8.943     0.200
     2.016     9.275     0.200
     2.210    10.285     0.200
     2.283    10.854     0.200
     2.407     9.983     0.200
     2.450    10.786     0.200
     2.561    11.536     0.200
     2.572    11.451     0.200
     2.697     8.562     0.200
     2.814    12.759     0.200
     3.250    12.715     0.200
     3.314    12.336     0.200
     3.427    12.794     0.200
     3.592    16.233     0.200
     3.680    15.894     0.200
     3.684    14.878     0.200
     3.712    14.550     0.200
     3.751    15.163     0.200
     3.920    12.943     0.200
     0.282     5.610     0.200
     0.353     5.429     0.200
     0.594     5.552     0.200
     0.649     6.034     0.200
     0.745     5.680     0.200
     0.771     5.552     0.200
     0.980     6.836     0.200
     1.118     7.292     0.200
     1.243     7.218     0.200
     1.228     7.633     0.200
     1.303     7.322     0.200
     1.582     9.041     0.200
     1.636     8.618     0.200
     1.647     8.084     0.200
     1.786     8.559     0.200
     1.808     9.830     0.200
     1.792     9.058     0.200
     1.803     9.674     0.200
     1.807     9.316     0.200
     1.892     9.194     0.200
     2.040    10.128     0.200
     2.103     9.640     0.200
     2.120    10.770     0.200
     2.129    10.921     0.200
     2.144    12.408     0.200
     2.142    10.328     0.200
     2.215     8.124     0.200
     2.483    11.821     0.200
     2.643    10.347     0.200
     2.664    10.993     0.200
     2.796    11.301     0.200
     2.905    13.760     0.200
     3.493    11.934     0.200
     3.588    11.928     0.200
     3.721    12.734     0.200
     4.563    14.004     0.200
     1.818    10.467     0.200
     1.925     9.946     0.200
     2.130    11.131     0.200
     2.224    11.159     0.200
     2.286    11.808     0.200
     2.525    12.539     0.200
     2.525    12.537     0.200
     2.555    13.222     0.200
     2.566    13.153     0.200
     2.598    12.744     0.200
     2.594    13.675     0.200
     2.601    13.177     0.200
     2.617    13.140     0.200
     2.619    12.967     0.200
     2.671    13.867     0.200
     2.670    13.876     0.200
     2.671    13.096     0.200
     2.679    13.079     0.200
     2.694    12.557     0.200
     2.676    13.730     0.200
     2.665    13.112     0.200
     2.716    13.977     0.200
     2.745    13.649     0.200
     2.658    14.851     0.200
     2.678    14.556     0.200
     2.784    12.067     0.200
     2.791    13.172     0.200
     2.938    13.722     0.200
     3.106    15.212     0.200
     3.646    16.497     0.200
     3.701    14.143     0.200
     3.698    13.905     0.200
     4.040    15.336     0.200
     4.206    14.207     0.200
     4.410    16.863     0.200
     4.737    19.068     0.200
     4.652    18.077     0.200
     4.826    18.895     0.200
     4.830    20.304     0.200
     4.837    20.116     0.200
     4.858    19.998     0.200
     4.877    21.885     0.200
     4.887    18.987     0.200
     4.971    19.548     0.200
     5.221    16.743     0.200
     5.134    18.245     0.200
     5.954    21.796     0.200
     6.008    20.191     0.200
     6.082    22.732     0.200
     6.079    21.347     0.200
     6.381    18.797     0.200
     7.043    21.169     0.200
     7.251    25.200     0.200
    11.197    30.047     0.200
    12.749    35.855     0.200
    12.812    35.604     0.200
    13.193    36.388     0.200
    13.457    36.266     0.200
    13.761    36.971     0.200
    14.279    38.554     0.200
    14.568    38.667     0.200
    15.465    39.186     0.200
    15.645    39.726     0.200
    16.720    39.677     0.200
    18.568    42.678     0.200
    18.586    43.757     0.200
    18.655    42.052     0.200
    18.725    40.589     0.200
    19.256    41.581     0.200
    19.256    41.251     0.200
    19.289    40.447     0.200
    19.340    40.392     0.200
    19.359    40.090     0.200
    19.403    40.086     0.200
    19.438    40.227     0.200
    19.459    42.743     0.200
    19.806    40.248     0.200
    19.811    40.270     0.200
    19.905    40.302     0.200
    19.981    40.260     0.200
    20.125    42.033     0.200
    20.122    40.933     0.200
    20.152    40.617     0.200
    20.212    40.650     0.200
    20.351    40.792     0.200
    20.691    40.165     0.200
     1.009     6.407     0.200
     1.117     6.836     0.200
     1.391     7.837     0.200
     1.921     9.791     0.200
     1.986     9.862     0.200
     2.027     8.880     0.200
     2.188    11.004     0.200
     2.206    10.608     0.200
     2.259    10.684     0.200
     2.442    11.640     0.200
     2.790    11.367     0.200
     3.009    11.967     0.200
     3.249    12.003     0.200
     3.967    17.420     0.200
     4.052    18.268     0.200
     0.142     6.490     0.200
     0.281     5.716     0.200
     0.349     5.590     0.200
     0.576     5.643     0.200
     0.724     5.817     0.200
     0.762     6.302     0.200
     1.000     6.928     0.200
     1.133     7.593     0.200
     1.240     7.722     0.200
     1.235     7.858     0.200
     1.283     7.789     0.200
     1.560     9.153     0.200
     1.670     8.084     0.200
     1.650     8.902     0.200
     1.764     8.470     0.200
     1.793    10.102     0.200
     1.788     8.430     0.200
     1.794    11.055     0.200
     1.827     9.442     0.200
     1.907     9.457     0.200
     2.097     8.834     0.200
     2.121     9.707     0.200
     2.125     9.814     0.200
     2.135     9.552     0.200
     2.136     9.773     0.200
     2.142     9.300     0.200
     2.147     9.271     0.200
     2.207     8.457     0.200
     2.219     9.263     0.200
     2.240    10.157     0.200
     2.278    10.941     0.200
     2.380     9.896     0.200
     2.477    11.060     0.200
     2.536    10.611     0.200
     2.687    11.081     0.200
     3.502    11.877     0.200
     3.590    10.980     0.200
     3.672    12.706     0.200
     3.739    12.926     0.200
     4.583    15.275     0.200
     1.232     6.745     0.200
     1.717    10.399     0.200
     1.744    10.117     0.200
     1.747     9.536     0.200
     1.900    10.270     0.200
     2.250    12.884     0.200
     2.253     9.547     0.200
     2.359    10.732     0.200
     2.415    11.546     0.200
     2.597    10.903     0.200
     2.598    11.921     0.200
     2.567    11.833     0.200
     2.615    12.188     0.200
     2.669    11.686     0.200
     2.673    11.652     0.200
     2.697    12.358     0.200
     2.675    12.054     0.200
     2.699    13.011     0.200
     2.710    13.105     0.200
     2.711    12.634     0.200
     2.730    11.076     0.200
     2.739    11.879     0.200
     2.739    13.348     0.200
     2.755    12.218     0.200
     2.769    12.285     0.200
     2.768    11.978     0.200
     2.768    11.972     0.200
     2.785    11.841     0.200
     2.755    12.078     0.200
     2.818    13.983     0.200
     2.885    11.889     0.200
     2.903    12.224     0.200
     2.922    13.580     0.200
     2.918    12.630     0.200
     2.978    13.899     0.200
     2.974    11.980     0.200
     3.129    13.244     0.200
     3.121    10.900     0.200
     3.161    10.813     0.200
     3.199    12.888     0.200
     3.297    13.110     0.200
     3.426    13.324     0.200
     3.536    14.100     0.200
     3.536    14.103     0.200
     3.544    11.882     0.200
     3.564    13.643     0.200
     3.650    13.070     0.200
     3.651    13.060     0.200
     3.733    15.479     0.200
     3.861    15.354     0.200
     3.950    17.706     0.200
     3.979    17.021     0.200
     3.979    16.450     0.200
     3.984    16.593     0.200
     3.985    14.378     0.200
     4.001    15.006     0.200
     4.010    16.968     0.200
     4.028    16.820     0.200
     4.084    15.990     0.200
     4.239    13.496     0.200
     4.239    12.431     0.200
     4.287    14.861     0.200
     4.492    15.360     0.200
     4.582    18.804     0.200
     4.744    16.721     0.200
     4.740    16.101     0.200
     4.742    15.110     0.200
     4.971    15.949     0.200
     4.999    20.080     0.200
     5.108    17.459     0.200
     5.304    16.748     0.200
     5.317    15.839     0.200
     5.391    20.445     0.200
     5.683    21.990     0.200
     5.841    21.933     0.200
     6.019    17.401     0.200
     6.199    20.984     0.200
     6.199    24.484     0.200
     6.270    19.021     0.200
     6.276    23.458     0.200
     6.992    22.661     0.200
     7.015    21.080     0.200
     7.967    25.174     0.200
     8.031    25.357     0.200
     8.439    27.511     0.200
     8.691    26.949     0.200
     8.713    26.219     0.200
     8.724    26.185     0.200
     9.035    24.095     0.200
     9.355    29.699     0.200
    10.091    32.709     0.200
    10.105    26.994     0.200
    10.268    26.669     0.200
    10.916    30.730     0.200
    10.937    31.397     0.200
    11.127    32.939     0.200
    11.127    33.539     0.200
    11.117    33.930     0.200
    11.117    34.430     0.200
    11.432    31.287     0.200
    11.432    30.479     0.200
    11.432    30.789     0.200
    11.576    33.926     0.200
    11.721    33.536     0.200
    11.990    31.618     0.200
    11.990    30.678     0.200
    11.990    29.811     0.200
    12.162    33.232     0.200
    12.489    33.656     0.200
    12.637    33.456     0.200
    12.752    34.568     0.200
    12.752    34.111     0.200
    12.752    34.045     0.200
    12.752    35.110     0.200
    12.982    34.695     0.200
    12.982    34.855     0.200
    12.982    35.355     0.200
    13.111    36.597     0.200
    13.553    33.558     0.200
    13.553    35.247     0.200
    13.553    34.659     0.200
    13.674    34.796     0.200
    13.674    32.915     0.200
    13.997    37.338     0.200
    13.970    37.462     0.200
    13.970    38.363     0.200
    14.083    36.430     0.200
    14.083    35.215     0.200
    14.403    35.833     0.200
    14.459    36.595     0.200
    14.549    37.940     0.200
    14.765    38.015     0.200
    14.985    37.463     0.200
    14.938    38.928     0.200
    15.287    36.882     0.200
    15.287    37.183     0.200
    15.298    38.455     0.200
    15.305    37.052     0.200
    15.305    37.337     0.200
    15.428    39.388     0.200
    15.428    38.263     0.200
    15.428    38.148     0.200
    15.552    39.099     0.200
    15.552    39.579     0.200
    15.629    37.007     0.200
    15.629    36.890     0.200
    15.644    37.095     0.200
    15.694    37.993     0.200
    15.694    37.759     0.200
    15.694    38.263     0.200
    15.714    37.117     0.200
    15.714    36.539     0.200
    15.714    37.906     0.200
    15.729    37.171     0.200
    15.742    40.102     0.200
    15.767    40.302     0.200
    15.778    40.178     0.200
    15.861    37.895     0.200
    15.921    38.286     0.200
    15.936    37.940     0.200
    15.991    40.979     0.200
    15.992    38.949     0.200
    16.014    39.948     0.200
    16.018    40.908     0.200
    16.149    38.087     0.200
    16.178    40.557     0.200
    16.233    38.075     0.200
    16.234    38.148     0.200
    16.189    39.927     0.200
    16.380    37.929     0.200
    16.395    38.591     0.200
    16.631    38.334     0.200
    16.631    38.049     0.200
    16.951    39.257     0.200
    16.951    39.919     0.200
    16.977    38.482     0.200
    17.034    38.958     0.200
    17.151    39.793     0.200
    17.151    39.549     0.200
    17.550    39.449     0.200
    17.699    38.405     0.200
    17.716    37.858     0.200
    17.716    39.114     0.200
    17.742    37.812     0.200
    17.848    38.664     0.200
    17.848    38.317     0.200
    17.968    39.581     0.200
    18.210    39.375     0.200
    18.752    42.596     0.200
    18.752    40.846     0.200
    18.786    40.684     0.200
    18.786    41.977     0.200
    18.786    41.261     0.200
    18.786    41.757     0.200
    19.663    42.068     0.200
    19.981    41.192     0.200
    20.974    41.153     0.200
     1.058     7.134     0.200
     1.240     7.572     0.200
     1.422     8.271     0.200
     1.450     8.707     0.200
     1.467     8.533     0.200
     1.551     8.624     0.200
     1.535     8.776     0.200
     1.753     8.383     0.200
     1.672     9.081     0.200
     1.951     9.419     0.200
     2.053    10.050     0.200
     2.018    10.995     0.200
     2.107     9.181     0.200
     2.192    10.074     0.200
     2.236    10.464     0.200
     2.470    10.088     0.200
     2.514    11.131     0.200
     2.770    10.934     0.200
     2.842    10.983     0.200
     2.942    11.291     0.200
     3.018    12.363     0.200
     3.036    12.839     0.200
     3.036    14.878     0.200
     3.484    11.786     0.200
     3.584    13.211     0.200
     3.791    13.534     0.200
     4.077    18.958     0.200
     4.330    15.125     0.200
     4.786    15.535     0.200
     4.824    13.354     0.200
     4.967    18.336     0.200
     5.501    16.329     0.200
     5.549    18.960     0.200
     6.033    22.287     0.200
     6.179    22.047     0.200
     6.369    21.033     0.200
     6.369    22.759     0.200
     6.505    19.394     0.200
     7.450    21.644     0.200
     9.586    25.193     0.200
    11.386    28.780     0.200
    11.386    29.608     0.200
    11.493    26.685     0.200
    11.493    28.349     0.200
    11.517    32.469     0.200
    12.491    31.275     0.200
    12.590    31.908     0.200
    12.862    34.727     0.200
    13.164    32.396     0.200
    13.526    32.748     0.200
    13.526    33.240     0.200
    13.853    32.802     0.200
    13.986    34.226     0.200
    14.013    34.963     0.200
    14.352    32.990     0.200
    14.594    36.048     0.200
    14.620    35.887     0.200
    14.999    35.810     0.200
    15.168    37.174     0.200
    15.193    34.473     0.200
    15.193    35.997     0.200
    15.353    35.418     0.200
    15.441    35.109     0.200
    15.542    34.519     0.200
    15.542    36.964     0.200
    15.551    34.143     0.200
    15.565    37.329     0.200
    15.630    35.605     0.200
    15.665    37.105     0.200
    15.920    37.328     0.200
    15.920    38.273     0.200
    15.915    36.009     0.200
    15.926    36.771     0.200
    16.885    39.819     0.200
    17.136    39.096     0.200
    17.200    37.451     0.200
    17.203    38.969     0.200
    17.501    37.682     0.200
    17.990    38.632     0.200
    18.240    39.972     0.200
    19.038    41.252     0.200
    19.117    40.873     0.200
     1.177     7.790     0.200
     1.300     7.948     0.200
     1.338     8.113     0.200
     1.371     8.230     0.200
     1.630     7.909     0.200
     1.583     9.547     0.200
     1.703     8.961     0.200
     1.840     9.506     0.200
     1.887     9.004     0.200
     1.891    10.884     0.200
     1.950     9.574     0.200
     2.054    10.089     0.200
     2.235    10.355     0.200
     2.228    12.726     0.200
     2.593    10.827     0.200
     2.650    11.012     0.200
     2.701    10.868     0.200
     2.820    12.157     0.200
     2.973    15.720     0.200
     4.357    16.501     0.200
     4.429    16.565     0.200
     4.435    17.443     0.200
     4.443    17.585     0.200
     4.481    17.945     0.200
     4.589    14.287     0.200
     4.525    15.616     0.200
     0.220     5.464     0.200
     0.606     5.301     0.200
     0.765     5.512     0.200
     0.828     6.038     0.200
     0.969     6.279     0.200
     1.013     6.345     0.200
     1.141     6.848     0.200
     1.196     6.486     0.200
     1.243     7.750     0.200
     1.291     7.704     0.200
     1.417     8.309     0.200
     1.468     7.763     0.200
     1.523     8.250     0.200
     1.842     9.664     0.200
     1.920    10.090     0.200
     2.026     9.540     0.200
     2.157    10.990     0.200
     2.199    10.448     0.200
     2.196    11.468     0.200
     3.213    10.669     0.200
     3.174    11.897     0.200
     3.352    16.075     0.200
     3.964    13.266     0.200
     4.337    11.909     0.200
     6.634    22.694     0.200
     0.150     6.783     0.200
     0.394     6.295     0.200
     0.754     6.049     0.200
     0.640     6.343     0.200
     0.788     6.372     0.200
     0.935     7.017     0.200
     1.071     7.439     0.200
     1.182     7.703     0.200
     1.223     7.764     0.200
     1.311     7.766     0.200
     1.590     8.859     0.200
     1.616     8.463     0.200
     1.621     8.055     0.200
     1.763     8.343     0.200
     1.783     8.586     0.200
     1.763     9.352     0.200
     1.845     9.490     0.200
     1.825     9.175     0.200
     2.077     9.714     0.200
     1.999    10.133     0.200
     2.101     9.345     0.200
     2.108     9.193     0.200
     2.107     9.674     0.200
     2.126     9.718     0.200
     2.123     8.580     0.200
     2.189    10.091     0.200
     2.189    10.075     0.200
     2.189     9.372     0.200
     2.204    10.311     0.200
     2.214    10.669     0.200
     2.216     9.851     0.200
     2.235     9.879     0.200
     2.261    10.080     0.200
     2.316     7.772     0.200
     2.339     8.880     0.200
     2.348     9.749     0.200
     2.250    12.281     0.200
     2.477    10.330     0.200
     2.597    10.268     0.200
     2.707    10.154     0.200
     2.809    13.497     0.200
     2.761     7.800     0.200
     2.927     9.807     0.200
     2.912    12.684     0.200
     2.912    11.449     0.200
     3.047    10.825     0.200
     3.164    11.043     0.200
     3.163    11.053     0.200
     3.242    12.014     0.200
     3.449    11.473     0.200
     3.606    13.125     0.200
     3.675    11.754     0.200
     3.636    14.379     0.200
     3.731    12.038     0.200
     3.955    11.035     0.200
     4.443    17.636     0.200
     4.365    14.850     0.200
     4.488    12.293     0.200
     4.427    16.829     0.200
     4.443    16.221     0.200
     4.460    17.101     0.200
     4.480    15.717     0.200
     4.543    14.553     0.200
     4.602    15.095     0.200
     5.223    16.184     0.200
     5.299    15.080     0.200
     5.443    17.468     0.200
     5.657    16.110     0.200
     5.884    15.664     0.200
     5.909    19.363     0.200
     6.041    17.718     0.200
     6.228    18.455     0.200
     6.228    20.440     0.200
     6.303    19.261     0.200
     7.214    23.813     0.200
     7.375    21.862     0.200
     7.406    22.068     0.200
     7.498    21.077     0.200
     7.693    23.757     0.200
     8.425    27.636     0.200
     9.512    24.443     0.200
    11.106    27.687     0.200
    11.162    26.750     0.200
    11.162    27.476     0.200
    11.222    28.576     0.200
    11.564    32.334     0.200
    12.234    30.373     0.200
    12.669    30.801     0.200
    12.669    32.817     0.200
    12.670    31.560     0.200
    13.253    30.335     0.200
    13.253    31.553     0.200
    13.763    33.467     0.200
    14.067    32.332     0.200
    14.416    33.110     0.200
    14.888    34.807     0.200
    15.124    34.216     0.200
    15.206    34.113     0.200
    15.390    34.587     0.200
    15.390    35.767     0.200
    15.923    35.847     0.200
    16.653    37.197     0.200
    17.155    35.081     0.200
    17.514    35.868     0.200
    18.129    37.173     0.200
    18.733    37.992     0.200
    18.733    38.485     0.200
    18.733    38.953     0.200
    18.971    38.799     0.200
    20.031    38.564     0.200
     0.089     5.671     0.200
     0.290     5.228     0.200
     0.662     5.759     0.200
     0.784     5.937     0.200
     0.840     6.364     0.200
     0.976     6.477     0.200
     0.981     6.860     0.200
     1.046     6.463     0.200
     1.352     7.209     0.200
     1.391     8.098     0.200
     1.490     9.165     0.200
     1.612     8.477     0.200
     1.705     9.165     0.200
     1.785     8.497     0.200
     1.839    10.348     0.200
     2.014     8.558     0.200
     2.215     9.307     0.200
     2.260    10.626     0.200
     2.372    10.204     0.200
     2.384     9.363     0.200
     2.384     9.551     0.200
     2.426    10.072     0.200
     2.436     9.649     0.200
     2.445     9.082     0.200
     2.548    10.492     0.200
     2.782    12.011     0.200
     2.958    11.564     0.200
     3.292    11.291     0.200
     3.716    17.897     0.200
     3.748    17.651     0.200
     3.767    17.792     0.200
     3.865    15.816     0.200
     3.872    17.393     0.200
     3.999    14.920     0.200
     4.423    16.022     0.200
     0.371     5.995     0.200
     0.413     5.593     0.200
     0.587     5.615     0.200
     0.647     5.837     0.200
     0.834     6.520     0.200
     0.838     6.305     0.200
     0.989     6.825     0.200
     1.124     7.016     0.200
     1.183     7.533     0.200
     1.173     6.761     0.200
     1.228     7.866     0.200
     1.358     7.899     0.200
     1.388     7.745     0.200
     1.711     8.744     0.200
     1.753     9.024     0.200
     1.933    10.381     0.200
     1.934     9.980     0.200
     1.934    10.672     0.200
     1.971    10.360     0.200
     1.996    10.388     0.200
     2.101     7.596     0.200
     2.122    10.212     0.200
     2.131     9.523     0.200
     2.172    11.207     0.200
     2.209     8.832     0.200
     2.200     8.424     0.200
     2.203     9.265     0.200
     2.329    10.027     0.200
     4.945    17.587     0.200
     4.959    19.001     0.200
     4.980    18.168     0.200
     5.111    17.558     0.200
     1.919     9.014     0.200
     1.952     9.846     0.200
     1.975     8.697     0.200
     2.151    10.602     0.200
     2.160    10.423     0.200
     2.196    10.914     0.200
     2.222    10.506     0.200
     2.243     9.996     0.200
     2.249    10.445     0.200
     2.249    10.639     0.200
     2.284    10.878     0.200
     2.286    10.278     0.200
     2.288    10.320     0.200
     2.291    10.345     0.200
     2.291    10.585     0.200
     2.313    10.725     0.200
     2.343    10.786     0.200
     2.362     8.602     0.200
     2.393    10.985     0.200
     2.434    12.127     0.200
     2.508    11.556     0.200
     2.589    11.984     0.200
     2.732    12.739     0.200
     2.796    12.744     0.200
     2.803    13.441     0.200
     2.829    11.914     0.200
     2.850    12.359     0.200
     2.972    12.062     0.200
     2.995    11.938     0.200
     3.150    12.961     0.200
     3.258    15.129     0.200
     3.542    14.206     0.200
     3.780    13.014     0.200
     4.008    13.066     0.200
     4.069    14.119     0.200
     4.110    17.159     0.200
     4.130    16.926     0.200
     4.149    16.349     0.200
     4.182    14.213     0.200
     4.260    15.458     0.200
     4.566    16.503     0.200
     4.917    16.407     0.200
     4.939    16.578     0.200
     5.300    18.982     0.200
     5.621    16.073     0.200
     5.746    18.491     0.200
     6.065    21.003     0.200
     0.210     5.485     0.200
     0.226     5.396     0.200
     0.274     5.435     0.200
     0.331     5.304     0.200
     0.498     5.436     0.200
     0.842     6.131     0.200
     0.873     6.942     0.200
     1.242     7.999     0.200
     1.349     7.459     0.200
     1.348     8.604     0.200
     1.378     8.298     0.200
     1.378     8.431     0.200
     1.478     8.693     0.200
     1.555     7.984     0.200
     1.861     8.596     0.200
     1.891     9.656     0.200
     1.934     8.901     0.200
     2.000    10.339     0.200
     2.069    10.165     0.200
     2.224    10.360     0.200
     2.232    10.462     0.200
     2.241    10.446     0.200
     2.238    10.239     0.200
     2.251    10.439     0.200
     2.264     9.699     0.200
     2.276    10.034     0.200
     2.285    10.148     0.200
     2.290    10.812     0.200
     2.292    10.240     0.200
     2.292    10.561     0.200
     2.294    10.221     0.200
     2.316    10.329     0.200
     2.314    10.450     0.200
     2.314    10.445     0.200
     2.329     9.133     0.200
     2.329    10.341     0.200
     2.463    10.321     0.200
     2.547    11.117     0.200
     2.650    10.796     0.200
     2.774    11.216     0.200
     2.783    11.081     0.200
     2.832    11.783     0.200
     2.832    13.033     0.200
     2.866    11.602     0.200
     2.881    11.313     0.200
     2.903    11.597     0.200
     3.023    12.479     0.200
     3.053    12.633     0.200
     3.054    12.630     0.200
     3.083    15.030     0.200
     3.062    11.319     0.200
     3.082    13.650     0.200
     3.294    11.355     0.200
     3.295    11.345     0.200
     3.468    12.090     0.200
     3.619    13.668     0.200
     3.619    15.817     0.200
     3.727    11.671     0.200
     3.776    10.729     0.200
     3.869    16.524     0.200
     3.895    13.750     0.200
     3.984    13.631     0.200
     4.227    17.183     0.200
     4.247    17.302     0.200
     4.265    18.915     0.200
     4.231    14.092     0.200
     4.266    16.918     0.200
     4.297    15.143     0.200
     4.377    16.558     0.200
     4.596    15.021     0.200
     4.821    15.866     0.200
     5.054    16.972     0.200
     5.331    15.023     0.200
     5.368    17.905     0.200
     5.416    17.838     0.200
     5.861    21.282     0.200
     5.980    16.233     0.200
     6.163    20.980     0.200
     6.163    18.542     0.200
     6.163    19.206     0.200
     6.584    19.989     0.200
     7.508    21.357     0.200
     7.508    23.029     0.200
     7.772    20.846     0.200
     9.406    30.073     0.200
    10.519    28.691     0.200
    11.139    30.723     0.200
    11.359    34.267     0.200
    11.470    27.704     0.200
    11.470    26.915     0.200
    12.284    29.265     0.200
    12.653    33.648     0.200
    12.954    32.833     0.200
    13.644    33.108     0.200
    13.805    32.923     0.200
    14.149    32.005     0.200
    14.386    34.809     0.200
    14.411    34.850     0.200
    14.653    36.271     0.200
    14.791    35.299     0.200
    14.912    35.371     0.200
    14.995    35.169     0.200
    15.269    34.862     0.200
    15.300    35.180     0.200
    15.356    36.413     0.200
    15.356    36.920     0.200
    15.353    34.731     0.200
    15.358    34.042     0.200
    15.460    35.277     0.200
    15.518    37.072     0.200
    15.597    38.723     0.200
    15.647    36.982     0.200
    15.670    36.956     0.200
    15.714    35.769     0.200
    15.736    36.654     0.200
    15.948    36.290     0.200
    15.950    36.197     0.200
    15.962    36.804     0.200
    15.961    36.328     0.200
    16.158    37.300     0.200
    16.563    38.266     0.200
    16.697    36.143     0.200
    16.993    37.499     0.200
    17.323    35.173     0.200
    17.476    36.988     0.200
    17.596    36.128     0.200
    17.862    38.068     0.200
    17.935    37.673     0.200
    18.013    39.262     0.200
    18.024    39.637     0.200
    18.707    39.988     0.200
     1.410     9.489     0.200
     1.410     9.349     0.200
     1.603     8.818     0.200
     1.557    10.006     0.200
     1.595     9.475     0.200
     1.636     9.481     0.200
     1.637     9.802     0.200
     1.806     9.829     0.200
     1.945    10.502     0.200
     1.992    11.059     0.200
     2.152    12.109     0.200
     2.170    11.049     0.200
     2.192    10.870     0.200
     2.274    12.418     0.200
     2.474    12.403     0.200
     2.498    12.298     0.200
     2.538    12.757     0.200
     2.539    12.754     0.200
     2.648    12.252     0.200
     2.611    12.825     0.200
     2.612    12.459     0.200
     2.741    12.476     0.200
     2.738    12.145     0.200
     2.837    12.518     0.200
     2.854    12.449     0.200
     2.916    12.405     0.200
     2.940    13.320     0.200
     2.940    13.317     0.200
     2.948    12.274     0.200
     2.968    12.535     0.200
     3.185    16.855     0.200
     3.185    14.885     0.200
     3.306    14.515     0.200
     3.585    15.523     0.200
     3.672    13.988     0.200
     3.715    13.652     0.200
     3.838    13.334     0.200
     3.923    15.055     0.200
     3.977    13.607     0.200
     4.346    14.588     0.200
     4.547    17.554     0.200
     4.565    16.130     0.200
     4.566    20.504     0.200
     4.667    18.240     0.200
     4.705    17.410     0.200
     4.705    16.355     0.200
     4.786    14.465     0.200
     4.870    20.273     0.200
     5.321    17.980     0.200
     5.275    16.671     0.200
     5.686    19.940     0.200
     5.721    20.111     0.200
     6.182    25.070     0.200
     6.292    22.458     0.200
     6.386    23.328     0.200
     6.398    21.279     0.200
     6.517    23.160     0.200
     6.517    22.459     0.200
     6.517    23.890     0.200
     7.355    24.140     0.200
     7.355    24.009     0.200
     7.450    21.957     0.200
     7.486    23.713     0.200
     9.754    31.585     0.200
    11.449    31.368     0.200
    11.491    33.459     0.200
    11.491    34.080     0.200
    11.506    32.208     0.200
    12.365    35.015     0.200
    12.618    33.942     0.200
    12.709    34.072     0.200
    13.004    36.066     0.200
    13.004    35.889     0.200
    13.298    36.909     0.200
    13.648    37.415     0.200
    13.993    37.076     0.200
    14.470    35.246     0.200
    14.738    37.947     0.200
    14.756    38.210     0.200
    15.791    40.184     0.200
    15.786    39.080     0.200
    15.935    40.404     0.200
    16.870    40.144     0.200
    18.403    42.490     0.200
    19.060    41.684     0.200
     1.797     8.736     0.200
     1.843     9.515     0.200
     1.926     9.506     0.200
     2.008     9.995     0.200
     2.100    10.063     0.200
     2.227    11.066     0.200
     2.259    10.395     0.200
     2.298    10.278     0.200
     2.729    10.090     0.200
     2.852    10.942     0.200
     2.867    12.584     0.200
     2.992    12.523     0.200
     3.689    13.186     0.200
     3.755    12.812     0.200
     4.288    15.353     0.200
     4.308    15.831     0.200
     4.327    16.216     0.200
     4.439    16.281     0.200
     4.760    15.155     0.200
     1.252     7.894     0.200
     1.252     7.784     0.200
     1.459     7.645     0.200
     1.772     8.974     0.200
     2.500     9.534     0.200
     2.519     8.791     0.200
     2.816    11.407     0.200
     3.121     9.900     0.200
     3.653    14.880     0.200
     3.949    15.996     0.200
     4.239    13.167     0.200
     4.198    11.478     0.200
     4.330    15.861     0.200
     4.969    14.832     0.200
     5.401    21.342     0.200
     6.535    25.580     0.200
     6.846    21.136     0.200
     6.846    21.675     0.200
     6.970    23.312     0.200
     6.970    21.210     0.200
     6.970    22.444     0.200
     7.031    19.272     0.200
     9.776    27.098     0.200
    11.824    30.801     0.200
    11.770    30.329     0.200
    12.223    35.925     0.200
    12.801    33.363     0.200
    12.924    31.454     0.200
    12.970    32.095     0.200
    13.401    34.009     0.200
    13.400    34.102     0.200
    13.400    35.758     0.200
    13.648    33.018     0.200
    13.754    33.603     0.200
    13.754    36.916     0.200
    13.926    33.524     0.200
    14.382    35.440     0.200
    14.380    37.651     0.200
    14.458    37.153     0.200
    14.723    37.103     0.200
    15.117    37.010     0.200
    15.115    38.895     0.200
    15.152    37.747     0.200
    15.387    39.425     0.200
    15.440    39.997     0.200
    15.760    39.041     0.200
    16.059    36.853     0.200
    16.122    37.289     0.200
    16.245    37.862     0.200
    16.371    39.088     0.200
    16.415    38.169     0.200
    16.475    37.598     0.200
    16.538    37.594     0.200
    16.569    37.375     0.200
    16.586    38.058     0.200
    16.619    38.411     0.200
    16.772    38.948     0.200
    16.858    36.677     0.200
    17.131    38.102     0.200
    17.210    39.337     0.200
    17.303    36.391     0.200
    17.521    38.641     0.200
    17.549    38.756     0.200
    17.634    39.707     0.200
    17.681    38.327     0.200
    17.678    39.329     0.200
    17.731    40.168     0.200
    17.884    38.995     0.200
    17.992    38.405     0.200
    18.073    39.230     0.200
    18.169    37.681     0.200
    18.295    40.521     0.200
    18.365    38.115     0.200
    18.756    40.642     0.200
    18.806    40.828     0.200
    19.227    43.914     0.200
     1.577     7.992     0.200
     1.843     8.525     0.200
     1.876     9.630     0.200
     2.026    10.417     0.200
     2.128    10.388     0.200
     2.167    11.102     0.200
     2.177    11.077     0.200
     2.178    10.706     0.200
     2.206    10.912     0.200
     2.256    11.229     0.200
     2.254    11.315     0.200
     2.300    11.472     0.200
     2.321    10.967     0.200
     2.330     9.181     0.200
     2.717    11.492     0.200
     2.862    11.628     0.200
     2.850    11.969     0.200
     3.014    12.283     0.200
     3.043    13.416     0.200
     3.240    12.780     0.200
     3.489    13.163     0.200
     3.667    13.944     0.200
     3.715    12.849     0.200
     3.874    14.007     0.200
     3.938    14.097     0.200
     4.233    17.269     0.200
     4.252    17.905     0.200
     4.272    16.086     0.200
     4.312    15.564     0.200
     4.386    17.309     0.200
     4.539    19.857     0.200
     4.782    16.315     0.200
     0.297     5.180     0.200
     0.290     5.435     0.200
     0.397     5.193     0.200
     0.522     5.405     0.200
     0.760     6.307     0.200
     0.860     6.207     0.200
     1.156     7.567     0.200
     1.197     7.844     0.200
     1.559     7.538     0.200
     1.781     9.258     0.200
     1.813     9.670     0.200
     1.869     8.685     0.200
     1.822     8.409     0.200
     2.025     9.874     0.200
     2.082    10.528     0.200
     2.069     9.719     0.200
     2.080     9.891     0.200
     2.075     9.996     0.200
     2.111     9.018     0.200
     2.120     9.889     0.200
     2.129    10.149     0.200
     2.129    10.873     0.200
     2.151    10.237     0.200
     2.152     9.301     0.200
     2.176    10.098     0.200
     2.187     9.937     0.200
     2.204     9.451     0.200
     2.205    10.120     0.200
     2.266    10.263     0.200
     2.282     9.948     0.200
     2.435     9.893     0.200
     2.485    11.063     0.200
     2.691    11.171     0.200
     2.752    11.268     0.200
     2.759    10.333     0.200
     2.760    11.362     0.200
     2.832    11.206     0.200
     2.888    11.298     0.200
     3.183    11.803     0.200
     3.468    12.704     0.200
     3.633    12.181     0.200
     3.667    12.947     0.200
     3.931    14.175     0.200
     4.199    13.594     0.200
     4.237    12.675     0.200
     4.354    15.970     0.200
     4.784    14.520     0.200
     5.486    16.053     0.200
     1.362     7.510     0.200
     1.485     8.789     0.200
     1.564     7.652     0.200
     1.603     9.662     0.200
     1.603     9.771     0.200
     1.655     9.728     0.200
     1.729    10.098     0.200
     1.729    10.223     0.200
     1.892     9.559     0.200
     2.131    10.929     0.200
     2.197    11.796     0.200
     2.228    11.452     0.200
     2.242    10.309     0.200
     2.373    11.472     0.200
     2.400    11.764     0.200
     2.481    10.500     0.200
     2.531    13.578     0.200
     2.537    11.761     0.200
     2.545    11.274     0.200
     2.601    11.507     0.200
     2.618    11.161     0.200
     2.619    11.156     0.200
     2.636    12.387     0.200
     2.636    12.437     0.200
     2.636    11.655     0.200
     2.663    14.001     0.200
     2.681    13.779     0.200
     2.687    11.287     0.200
     2.701    13.640     0.200
     2.739    11.131     0.200
     2.770    10.869     0.200
     2.778    13.023     0.200
     2.820    11.384     0.200
     2.851    12.456     0.200
     2.852    12.876     0.200
     2.904    12.193     0.200
     2.903    12.201     0.200
     3.021    12.459     0.200
     3.047    13.985     0.200
     3.047    12.954     0.200
     3.123    12.626     0.200
     3.136    13.085     0.200
     3.186    13.073     0.200
     3.214    13.629     0.200
     3.229    13.694     0.200
     3.273    14.730     0.200
     3.468    13.805     0.200
     3.599    12.976     0.200
     3.600    12.966     0.200
     3.887    16.029     0.200
     3.927    15.267     0.200
     4.100    15.868     0.200
     4.157    14.857     0.200
     4.298    16.999     0.200
     4.298    17.710     0.200
     4.322    18.002     0.200
     4.322    19.502     0.200
     4.323    21.388     0.200
     4.323    15.285     0.200
     4.323    16.621     0.200
     4.340    18.084     0.200
     4.340    18.467     0.200
     4.435    16.753     0.200
     4.505    14.799     0.200
     4.953    15.790     0.200
     4.953    16.415     0.200
     5.445    18.923     0.200
     5.578    21.564     0.200
     5.671    15.431     0.200
     5.972    21.341     0.200
     6.276    19.059     0.200
     6.380    20.378     0.200
     6.380    25.456     0.200
     6.380    22.893     0.200
     6.637    21.513     0.200
     6.654    20.452     0.200
     7.609    24.496     0.200
     8.062    24.218     0.200
     8.364    25.505     0.200
     8.755    31.803     0.200
     9.397    25.404     0.200
     9.586    26.404     0.200
    10.576    29.665     0.200
    11.090    30.928     0.200
    11.471    30.255     0.200
    11.435    33.791     0.200
    11.673    29.831     0.200
    11.774    36.813     0.200
    12.161    31.874     0.200
    12.562    32.493     0.200
    12.621    33.849     0.200
    12.621    35.326     0.200
    12.676    32.253     0.200
    12.896    34.446     0.200
    12.896    34.086     0.200
    12.897    33.462     0.200
    13.605    33.631     0.200
    13.891    36.005     0.200
    14.439    34.448     0.200
    14.579    38.191     0.200
    15.293    37.210     0.200
    15.590    38.181     0.200
    15.665    39.022     0.200
    15.745    39.791     0.200
    16.041    38.736     0.200
    16.041    40.837     0.200
    16.753    39.561     0.200
    17.144    39.869     0.200
    17.630    39.865     0.200
    17.677    40.863     0.200
    17.925    38.921     0.200
    18.148    40.898     0.200
    18.944    41.583     0.200
     1.089     8.252     0.200
     1.353     7.248     0.200
     1.360     8.891     0.200
     1.412     8.780     0.200
     1.532     9.848     0.200
     1.532     9.668     0.200
     1.651     9.932     0.200
     1.875     8.807     0.200
     2.025     8.809     0.200
     2.057    10.662     0.200
     2.107    10.361     0.200
     2.151    10.378     0.200
     2.176    10.924     0.200
     2.304    11.375     0.200
     2.394    12.157     0.200
     2.362    11.520     0.200
     2.398    11.899     0.200
     2.440    10.772     0.200
     2.447    12.746     0.200
     2.455    11.212     0.200
     2.465    11.411     0.200
     2.481    10.914     0.200
     2.493    11.264     0.200
     2.497    12.107     0.200
     2.510    10.640     0.200
     2.528    11.320     0.200
     2.528    11.315     0.200
     2.545    11.607     0.200
     2.545    12.190     0.200
     2.545    11.370     0.200
     2.591    11.106     0.200
     2.596    10.889     0.200
     2.603    11.792     0.200
     2.611    12.202     0.200
     2.679    13.093     0.200
     2.729    12.970     0.200
     2.761    11.548     0.200
     2.764    11.052     0.200
     2.814    11.244     0.200
     2.946    12.677     0.200
     2.983    13.879     0.200
     2.983    13.170     0.200
     2.983    12.865     0.200
     3.055    12.665     0.200
     3.185    14.289     0.200
     3.143    13.299     0.200
     3.142    13.302     0.200
     3.200    12.992     0.200
     3.170    15.233     0.200
     3.467    11.097     0.200
     3.510    14.740     0.200
     3.808    15.727     0.200
     3.916    12.518     0.200
     3.987    12.764     0.200
     4.103    13.995     0.200
     4.271    17.541     0.200
     4.277    16.319     0.200
     4.300    16.464     0.200
     4.306    16.072     0.200
     4.315    13.660     0.200
     4.319    17.175     0.200
     4.418    16.205     0.200
     4.422    14.187     0.200
     4.910    16.521     0.200
     4.940    13.196     0.200
     5.625    17.757     0.200
     5.940    24.899     0.200
     6.189    17.750     0.200
     6.317    21.967     0.200
     6.317    19.617     0.200
     6.317    21.467     0.200
     6.599    21.724     0.200
     7.575    22.956     0.200
     7.575    24.309     0.200
     7.686    23.188     0.200
     7.721    24.173     0.200
     7.809    23.236     0.200
     7.977    27.508     0.200
     8.349    25.326     0.200
     8.349    22.926     0.200
     8.349    27.084     0.200
     8.673    21.802     0.200
     9.374    26.709     0.200
     9.534    26.857     0.200
     9.711    26.963     0.200
     9.711    24.303     0.200
     9.711    26.590     0.200
    10.109    30.438     0.200
    10.195    26.779     0.200
    10.307    30.516     0.200
    10.474    32.344     0.200
    10.534    28.645     0.200
    10.534    30.545     0.200
    10.556    28.924     0.200
    10.556    30.901     0.200
    10.690    30.880     0.200
    11.280    29.523     0.200
    11.387    30.090     0.200
    11.414    30.682     0.200
    11.414    33.692     0.200
    11.611    30.374     0.200
    11.611    28.056     0.200
    11.901    30.619     0.200
    12.480    32.397     0.200
    12.591    32.243     0.200
    12.600    33.460     0.200
    12.600    31.130     0.200
    12.600    34.810     0.200
    12.825    35.079     0.200
    12.825    34.409     0.200
    12.826    33.171     0.200
    13.107    32.928     0.200
    13.440    33.972     0.200
    13.522    34.219     0.200
    13.544    34.458     0.200
    13.819    35.362     0.200
    13.999    35.477     0.200
    13.999    36.252     0.200
    14.354    35.210     0.200
    14.552    37.832     0.200
    14.595    38.022     0.200
    14.985    37.505     0.200
    15.092    37.507     0.200
    15.330    37.594     0.200
    15.522    38.088     0.200
    15.522    38.217     0.200
    15.564    37.255     0.200
    16.037    39.096     0.200
    16.037    40.336     0.200
    17.801    38.592     0.200
    18.876    40.746     0.200
    18.876    41.353     0.200
     0.080     6.854     0.200
     0.308     5.737     0.200
     0.701     6.134     0.200
     0.843     6.121     0.200
     0.781     7.491     0.200
     1.061     6.811     0.200
     1.017     7.136     0.200
     0.986     7.962     0.200
     1.407     7.406     0.200
     1.465     8.437     0.200
     1.440     9.141     0.200
     1.778     9.126     0.200
     1.864     8.396     0.200
     1.864     9.306     0.200
     1.920     9.652     0.200
     1.931     8.941     0.200
     2.088     9.032     0.200
     2.150    10.023     0.200
     2.258    10.145     0.200
     2.273    10.149     0.200
     2.280     9.909     0.200
     2.341    10.469     0.200
     2.314    10.312     0.200
     2.428     9.870     0.200
     2.369    10.220     0.200
     2.385    10.279     0.200
     2.391    10.405     0.200
     2.401    10.794     0.200
     2.402    10.429     0.200
     2.402    10.739     0.200
     2.461    10.285     0.200
     2.461    10.395     0.200
     2.445    10.480     0.200
     2.465    10.381     0.200
     2.454    10.788     0.200
     2.502     9.766     0.200
     2.494    10.534     0.200
     2.514     9.973     0.200
     2.520    10.466     0.200
     2.521    10.457     0.200
     2.509    10.871     0.200
     2.524    11.386     0.200
     2.543    10.328     0.200
     2.606    11.352     0.200
     2.487    11.541     0.200
     2.487    11.691     0.200
     2.628    11.176     0.200
     2.557    11.404     0.200
     2.576    10.907     0.200
     2.613    11.245     0.200
     2.624    10.818     0.200
     2.659    10.537     0.200
     2.616    13.354     0.200
     2.850    12.108     0.200
     2.760    11.365     0.200
     2.831    10.403     0.200
     2.879    12.696     0.200
     2.977    11.971     0.200
     2.900    12.005     0.200
     3.196    11.527     0.200
     3.372    12.538     0.200
     3.318    11.374     0.200
     3.319    11.364     0.200
     3.448    12.862     0.200
     3.601    13.863     0.200
     3.601    13.866     0.200
     3.610    12.520     0.200
     3.630    14.008     0.200
     3.556    13.123     0.200
     3.710    17.039     0.200
     3.717    15.078     0.200
     3.728    17.269     0.200
     3.735    14.677     0.200
     3.829    14.972     0.200
     3.991    12.099     0.200
     4.081    13.237     0.200
     4.464    15.510     0.200
     4.500    14.284     0.200
     4.575    16.658     0.200
     4.645    15.496     0.200
     4.856    17.422     0.200
     5.270    13.146     0.200
     5.366    16.377     0.200
     5.366    16.788     0.200
     5.354    21.859     0.200
     5.839    14.686     0.200
     5.810    17.690     0.200
     5.810    19.340     0.200
     5.903    17.066     0.200
     6.065    17.998     0.200
     7.070    21.046     0.200
     7.151    20.243     0.200
     8.065    22.797     0.200
     8.065    23.157     0.200
     8.219    23.696     0.200
     8.251    23.977     0.200
     8.342    24.910     0.200
     8.984    28.251     0.200
     9.898    26.100     0.200
    10.169    24.827     0.200
    10.169    24.966     0.200
    10.599    28.729     0.200
    10.746    28.758     0.200
    10.746    27.988     0.200
    10.824    30.135     0.200
    11.087    30.981     0.200
    11.051    29.513     0.200
    11.942    30.422     0.200
    12.101    31.625     0.200
    12.256    31.453     0.200
    12.358    31.868     0.200
    12.358    34.919     0.200
    12.359    35.213     0.200
    12.717    35.448     0.200
    13.168    33.169     0.200
    13.360    35.879     0.200
    13.606    36.777     0.200
    14.023    34.225     0.200
    14.150    36.083     0.200
    14.067    36.178     0.200
    14.189    35.468     0.200
    14.161    35.885     0.200
    14.371    37.465     0.200
    14.529    35.830     0.200
    14.594    35.172     0.200
    14.684    35.924     0.200
    14.916    35.438     0.200
    14.905    36.239     0.200
    14.981    33.885     0.200
    14.952    35.095     0.200
    15.130    36.666     0.200
    15.273    35.577     0.200
    15.275    37.698     0.200
    15.310    36.563     0.200
    15.368    36.220     0.200
    15.557    36.233     0.200
    15.436    36.774     0.200
    15.760    36.484     0.200
    15.861    35.650     0.200
    15.994    35.795     0.200
    16.156    37.793     0.200
    16.260    36.199     0.200
    16.604    37.456     0.200
    16.531    36.085     0.200
    16.566    38.258     0.200
    16.680    37.076     0.200
    16.919    36.205     0.200
    17.087    37.469     0.200
    17.321    37.516     0.200
    17.364    37.535     0.200
    17.410    36.387     0.200
    17.424    36.534     0.200
    17.466    36.326     0.200
    17.534    39.030     0.200
    17.577    37.851     0.200
    17.646    36.944     0.200
    17.766    38.666     0.200
    17.802    38.775     0.200
     1.521     9.328     0.200
     1.503     9.381     0.200
     1.536    10.124     0.200
     1.740    10.322     0.200
     1.721    10.494     0.200
     1.721    10.662     0.200
     2.248    11.795     0.200
     2.335    10.902     0.200
     2.342    12.550     0.200
     2.491    12.514     0.200
     2.550    12.447     0.200
     2.507    13.012     0.200
     2.618    12.175     0.200
     2.623    13.103     0.200
     2.655    12.119     0.200
     2.662    13.466     0.200
     2.665    12.206     0.200
     2.690    11.924     0.200
     2.697    11.928     0.200
     2.720    13.224     0.200
     2.720    13.982     0.200
     2.720    13.392     0.200
     2.715    11.823     0.200
     2.748    13.639     0.200
     2.795    11.813     0.200
     2.856    13.399     0.200
     2.959    15.163     0.200
     3.000    15.163     0.200
     3.061    13.886     0.200
     3.139    12.524     0.200
     3.139    13.344     0.200
     3.270    15.971     0.200
     3.241    13.787     0.200
     3.297    14.461     0.200
     3.296    14.465     0.200
     3.396    11.126     0.200
     3.679    13.274     0.200
     3.679    13.264     0.200
     4.016    15.763     0.200
     4.259    17.133     0.200
     4.274    19.512     0.200
     4.272    15.206     0.200
     4.381    18.014     0.200
     4.619    19.750     0.200
     5.100    22.160     0.200
     5.062    16.427     0.200
     5.381    15.155     0.200
     5.937    20.678     0.200
     6.342    15.491     0.200
     6.391    23.471     0.200
     6.391    23.779     0.200
     6.391    18.088     0.200
     8.454    24.389     0.200
     9.493    25.678     0.200
     9.579    33.262     0.200
     9.859    24.327     0.200
    11.338    29.248     0.200
    11.384    32.938     0.200
    12.734    30.606     0.200
    12.922    34.615     0.200
    12.922    34.267     0.200
    13.255    37.013     0.200
    13.660    32.463     0.200
    13.919    31.977     0.200
    14.125    37.112     0.200
    14.155    35.007     0.200
    14.387    37.855     0.200
    14.499    35.767     0.200
    14.499    38.956     0.200
    14.640    38.512     0.200
    14.706    38.209     0.200
    14.930    38.591     0.200
    15.112    38.520     0.200
    15.310    36.445     0.200
    15.356    38.943     0.200
    15.361    37.483     0.200
    15.718    37.519     0.200
    15.654    36.106     0.200
    15.801    38.300     0.200
    15.837    39.530     0.200
    16.069    38.157     0.200
    17.716    38.332     0.200
    17.945    37.785     0.200
    17.945    38.914     0.200
    18.099    39.590     0.200
    18.965    41.226     0.200
    18.965    40.800     0.200
    18.965    42.199     0.200
     0.038     6.634     0.200
     0.807     6.519     0.200
     0.897     5.591     0.200
     0.958     6.921     0.200
     1.133     7.386     0.200
     1.265     7.762     0.200
     1.365     7.513     0.200
     1.433     7.563     0.200
     1.555     8.298     0.200
     1.658    10.503     0.200
     1.777     9.522     0.200
     1.863     9.044     0.200
     1.900     8.357     0.200
     1.926     9.262     0.200
     1.903     9.701     0.200
     1.984    10.288     0.200
     2.100     9.592     0.200
     2.154     9.296     0.200
     2.173    10.839     0.200
     2.184    10.661     0.200
     2.202     8.800     0.200
     2.217     9.317     0.200
     2.213    10.434     0.200
     2.247    10.033     0.200
     2.237    10.313     0.200
     2.265    10.620     0.200
     2.329    11.258     0.200
     2.354     9.618     0.200
     2.401     8.191     0.200
     2.456    12.602     0.200
     2.566     9.874     0.200
     2.554     9.319     0.200
     2.598    11.142     0.200
     2.575    10.202     0.200
     2.754    11.481     0.200
     3.035    11.950     0.200
     3.543    11.934     0.200
     3.587    11.197     0.200
     3.672    10.691     0.200
     3.702    14.048     0.200
     3.776    12.793     0.200
     4.536    17.339     0.200
     4.522    13.981     0.200
     4.672    16.367     0.200
     5.233    16.677     0.200
     5.718    17.873     0.200
     6.275    18.003     0.200
     1.538     8.418     0.200
     1.558     8.691     0.200
     1.671     8.953     0.200
     1.931     9.961     0.200
     2.158    10.293     0.200
     2.166     9.967     0.200
     2.210    10.307     0.200
     2.210    10.856     0.200
     2.354    10.554     0.200
     2.354    11.264     0.200
     2.380    11.851     0.200
     2.391    10.919     0.200
     2.391    10.679     0.200
     2.421    10.895     0.200
     2.442    10.840     0.200
     2.472    12.836     0.200
     2.468    11.110     0.200
     2.473    11.447     0.200
     2.508    11.429     0.200
     2.534    11.282     0.200
     2.534    12.272     0.200
     2.534    11.284     0.200
     2.661    10.071     0.200
     2.596    11.348     0.200
     2.654    12.389     0.200
     2.657    13.052     0.200
     2.671    13.837     0.200
     2.710    11.812     0.200
     2.710    11.952     0.200
     2.762    11.980     0.200
     2.778    12.617     0.200
     2.776    12.363     0.200
     2.804    10.769     0.200
     2.791    11.455     0.200
     2.791    12.055     0.200
     2.791    12.805     0.200
     2.791    12.953     0.200
     2.791    12.285     0.200
     2.792    12.728     0.200
     2.792    13.288     0.200
     2.828    12.658     0.200
     2.867    12.905     0.200
     2.871    13.302     0.200
     2.874    14.079     0.200
     2.896    12.592     0.200
     2.948     8.684     0.200
     2.951    14.786     0.200
     3.048    12.273     0.200
     3.054    13.932     0.200
     3.116    10.047     0.200
     3.200    12.435     0.200
     3.221    12.660     0.200
     3.278    14.388     0.200
     3.328    13.591     0.200
     3.328    15.082     0.200
     3.461    11.522     0.200
     3.748    13.439     0.200
     3.748    13.429     0.200
     3.801    16.555     0.200
     3.801    14.927     0.200
     3.801    15.537     0.200
     3.833    12.277     0.200
     3.902    13.035     0.200
     3.902    12.931     0.200
     4.157    14.886     0.200
     4.135    12.537     0.200
     4.574    14.701     0.200
     4.545    14.585     0.200
     4.545    14.426     0.200
     4.632    14.443     0.200
     4.778    16.857     0.200
     5.361    19.252     0.200
     5.382    18.059     0.200
     5.494    18.758     0.200
     5.559    17.646     0.200
     5.559    17.416     0.200
     5.559    17.036     0.200
     5.773    16.612     0.200
     6.170    19.173     0.200
     6.318    19.399     0.200
     6.532    19.901     0.200
     6.511    20.958     0.200
     6.511    20.646     0.200
     6.503    18.920     0.200
     6.606    20.552     0.200
     6.584    19.983     0.200
     6.584    20.333     0.200
     6.606    19.730     0.200
     6.621    20.830     0.200
     6.708    20.542     0.200
     6.813    22.658     0.200
     6.905    21.596     0.200
     6.955    21.435     0.200
     6.955    21.585     0.200
     7.092    23.363     0.200
     7.092    23.093     0.200
     7.092    24.098     0.200
     7.092    23.254     0.200
     7.092    23.499     0.200
     7.234    22.801     0.200
     7.234    22.501     0.200
     7.241    22.184     0.200
     7.318    24.373     0.200
     7.753    21.528     0.200
     7.753    22.299     0.200
     8.084    25.462     0.200
     8.253    24.342     0.200
     8.278    22.116     0.200
     8.308    27.760     0.200
     8.338    25.021     0.200
     8.338    22.291     0.200
     8.679    23.536     0.200
     8.679    22.746     0.200
     8.679    22.597     0.200
     9.146    27.298     0.200
     9.365    28.815     0.200
     9.377    28.507     0.200
     9.581    28.633     0.200
     9.585    29.032     0.200
     9.679    29.473     0.200
     9.679    26.223     0.200
     9.679    26.603     0.200
     9.689    28.057     0.200
     9.732    30.099     0.200
     9.748    28.893     0.200
     9.742    25.048     0.200
     9.794    28.341     0.200
     9.835    29.396     0.200
     9.938    27.067     0.200
    10.001    29.208     0.200
    10.036    28.710     0.200
    10.117    29.030     0.200
    10.234    29.183     0.200
    10.406    31.344     0.200
    10.678    30.287     0.200
    10.721    30.353     0.200
    10.759    29.907     0.200
    10.747    26.573     0.200
    10.747    27.105     0.200
    10.747    25.835     0.200
    10.747    27.425     0.200
    10.747    26.405     0.200
    11.000    30.998     0.200
    11.000    32.833     0.200
    11.128    30.401     0.200
    11.191    31.771     0.200
    11.501    31.211     0.200
    11.501    31.070     0.200
    11.501    30.641     0.200
    11.501    30.811     0.200
    11.540    33.065     0.200
    11.535    32.324     0.200
    11.581    33.401     0.200
    11.658    33.300     0.200
    11.688    32.865     0.200
    11.742    32.086     0.200
    12.097    34.488     0.200
    12.099    33.761     0.200
    12.099    33.132     0.200
    12.099    34.117     0.200
    12.099    33.522     0.200
    12.180    32.931     0.200
    12.189    32.569     0.200
    12.332    33.256     0.200
    12.331    33.623     0.200
    12.331    33.389     0.200
    12.397    33.433     0.200
    12.404    33.825     0.200
    12.442    33.614     0.200
    12.489    33.646     0.200
    12.567    34.137     0.200
    12.599    35.276     0.200
    12.633    33.127     0.200
    12.659    32.720     0.200
    12.777    35.067     0.200
    12.837    34.130     0.200
    12.924    32.640     0.200
    12.939    32.969     0.200
    13.008    34.708     0.200
    13.018    34.706     0.200
    13.026    35.606     0.200
    13.026    34.706     0.200
    13.031    34.783     0.200
    13.066    33.987     0.200
    13.066    35.133     0.200
    13.066    35.503     0.200
    13.057    34.592     0.200
    13.057    35.501     0.200
    13.136    34.846     0.200
    13.456    35.058     0.200
    13.456    35.733     0.200
    13.467    35.561     0.200
    13.467    35.261     0.200
    13.489    35.585     0.200
    13.489    36.854     0.200
    13.650    33.829     0.200
    13.650    33.350     0.200
    13.806    36.467     0.200
    13.905    35.147     0.200
    13.905    34.417     0.200
    14.046    38.211     0.200
    14.929    37.516     0.200
    14.929    38.098     0.200
    14.929    39.138     0.200
    14.929    39.397     0.200
    15.186    39.717     0.200
    15.905    39.256     0.200
    15.905    38.843     0.200
    16.176    40.070     0.200
    16.202    38.670     0.200
    16.202    39.050     0.200
    16.219    38.449     0.200
    16.219    36.909     0.200
    16.356    38.148     0.200
    17.099    37.854     0.200
    18.172    39.532     0.200
    18.706    40.778     0.200
    19.039    42.141     0.200
    19.039    42.511     0.200
    19.102    43.428     0.200
    19.102    41.408     0.200
    19.346    40.957     0.200
    19.539    40.799     0.200
    19.819    44.233     0.200
    19.869    41.953     0.200
    20.126    41.247     0.200
    20.173    45.203     0.200
    20.315    43.033     0.200
    20.540    42.892     0.200
    20.867    39.618     0.200
    20.897    40.503     0.200
    20.915    41.310     0.200
     0.237     5.550     0.200
     0.494     5.317     0.200
     0.799     5.693     0.200
     0.987     6.469     0.200
     1.053     6.260     0.200
     1.084     6.461     0.200
     1.128     7.135     0.200
     1.262     7.110     0.200
     1.334     7.721     0.200
     1.338     8.196     0.200
     1.453     8.229     0.200
     1.531     8.335     0.200
     1.528     8.885     0.200
     1.738     8.972     0.200
     1.879     9.579     0.200
     1.987     9.352     0.200
     2.001     9.888     0.200
     2.047     9.093     0.200
     2.054     8.455     0.200
     2.073     9.432     0.200
     2.074    10.045     0.200
     2.112     9.536     0.200
     2.137     9.507     0.200
     2.141     9.884     0.200
     2.218    10.308     0.200
     2.223    10.205     0.200
     2.220     9.545     0.200
     2.255     8.633     0.200
     2.266    10.928     0.200
     2.270     9.513     0.200
     2.287    10.377     0.200
     2.316    11.873     0.200
     2.302    10.683     0.200
     2.312    10.337     0.200
     2.329    10.864     0.200
     2.342    10.418     0.200
     2.353    11.245     0.200
     2.454    10.874     0.200
     2.501    10.735     0.200
     2.600    13.460     0.200
     2.605    10.987     0.200
     3.145    12.074     0.200
     3.268    12.050     0.200
     3.310    15.129     0.200
     3.321    13.965     0.200
     4.070    13.234     0.200
     4.221    13.056     0.200
     0.169     6.162     0.200
     0.541     5.473     0.200
     0.722     5.867     0.200
     0.794     6.335     0.200
     0.878     6.274     0.200
     1.004     7.275     0.200
     1.129     7.570     0.200
     1.252     7.949     0.200
     1.388     8.255     0.200
     1.523     7.457     0.200
     1.677     8.981     0.200
     1.777     9.319     0.200
     1.772     8.641     0.200
     1.814    10.134     0.200
     1.907     9.492     0.200
     1.918     9.328     0.200
     1.963     8.520     0.200
     2.018     9.230     0.200
     2.037     9.295     0.200
     2.042     9.529     0.200
     2.063     9.495     0.200
     2.063    10.174     0.200
     2.078     9.073     0.200
     2.094    10.266     0.200
     2.101     9.640     0.200
     2.106     8.485     0.200
     2.112     9.762     0.200
     2.131    10.454     0.200
     2.143    11.473     0.200
     2.150    12.042     0.200
     2.227     9.084     0.200
     2.281     7.168     0.200
     2.344     9.168     0.200
     2.332    10.457     0.200
     2.448    11.122     0.200
     2.476    10.514     0.200
     2.538    10.464     0.200
     2.632    15.133     0.200
     3.542    12.984     0.200
     3.594    12.573     0.200
     0.235     5.676     0.200
     0.398     5.561     0.200
     0.376     5.719     0.200
     0.872     7.003     0.200
     1.161     7.879     0.200
     1.340     8.485     0.200
     1.471     8.734     0.200
     1.430     8.000     0.200
     1.873     9.196     0.200
     1.985     9.075     0.200
     1.941     8.792     0.200
     1.974     9.913     0.200
     2.179    10.694     0.200
     2.151    10.327     0.200
     2.215     9.772     0.200
     2.243    10.493     0.200
     2.218    10.286     0.200
     2.216    10.332     0.200
     2.263    10.147     0.200
     2.265    10.079     0.200
     2.270    10.238     0.200
     2.284     9.995     0.200
     2.307     9.883     0.200
     2.314    10.094     0.200
     2.319    10.527     0.200
     2.319    10.499     0.200
     2.335    10.251     0.200
     2.336    10.245     0.200
     2.345     9.739     0.200
     2.365    10.400     0.200
     2.409    11.250     0.200
     2.379     9.732     0.200
     2.383     9.839     0.200
     2.384    12.033     0.200
     2.424    11.911     0.200
     2.455    10.378     0.200
     2.458    10.668     0.200
     2.528    10.930     0.200
     2.596    10.365     0.200
     2.587    10.616     0.200
     2.606    10.665     0.200
     2.740    12.773     0.200
     2.740    12.242     0.200
     2.817    10.842     0.200
     2.852    11.406     0.200
     2.872    12.056     0.200
     3.005    11.704     0.200
     2.994    11.896     0.200
     2.971    12.057     0.200
     3.168    13.133     0.200
     3.168    13.136     0.200
     3.177    15.121     0.200
     3.277    11.332     0.200
     3.278    11.322     0.200
     3.344    12.181     0.200
     3.788    12.326     0.200
     3.803    12.081     0.200
     3.785    14.266     0.200
     4.019    12.542     0.200
     4.142    18.570     0.200
     4.144    16.813     0.200
     4.253    16.806     0.200
     4.290    14.375     0.200
     4.930    16.254     0.200
     5.291    18.173     0.200
     5.578    21.277     0.200
     6.635    21.912     0.200
     6.706    20.806     0.200
     7.626    22.016     0.200
     7.626    21.635     0.200
     7.773    23.538     0.200
     7.729    19.843     0.200
     7.806    24.687     0.200
     7.896    23.712     0.200
     8.422    25.457     0.200
     9.304    25.690     0.200
    11.043    30.097     0.200
    11.138    28.933     0.200
    11.267    29.463     0.200
    11.564    27.453     0.200
    11.564    29.819     0.200
    11.836    32.387     0.200
    12.229    31.663     0.200
    12.343    31.046     0.200
    12.576    32.654     0.200
    12.575    33.586     0.200
    12.575    33.832     0.200
    12.581    34.895     0.200
    12.682    31.818     0.200
    13.272    33.051     0.200
    13.568    35.012     0.200
    13.747    35.669     0.200
    14.106    33.318     0.200
    14.303    36.023     0.200
    14.342    35.829     0.200
    14.578    36.396     0.200
    14.733    36.217     0.200
    15.011    37.479     0.200
    15.274    37.538     0.200
    18.627    39.461     0.200
    18.627    39.262     0.200
    18.627    39.980     0.200
    18.627    39.641     0.200
     0.379     6.492     0.200
     0.383     6.294     0.200
     0.470     6.523     0.200
     0.716     6.588     0.200
     1.069     7.496     0.200
     1.187     7.743     0.200
     1.346     8.375     0.200
     1.488     8.552     0.200
     1.725     8.161     0.200
     1.784     7.968     0.200
     1.839     9.486     0.200
     1.950     8.888     0.200
     2.011     9.473     0.200
     2.056     9.150     0.200
     2.067     9.125     0.200
     2.080    10.300     0.200
     2.104     9.315     0.200
     2.114     9.637     0.200
     2.116    10.054     0.200
     2.125     9.445     0.200
     2.149    10.211     0.200
     2.156     9.256     0.200
     2.177     9.562     0.200
     2.187     9.116     0.200
     2.333    10.872     0.200
     2.380    10.170     0.200
     2.664    12.433     0.200
     2.710    11.068     0.200
     2.864    11.366     0.200
     3.077    13.108     0.200
     3.393     9.891     0.200
     3.636    10.648     0.200
     3.644    10.557     0.200
     3.977    14.062     0.200
     4.152    17.268     0.200
     4.270    15.220     0.200
     5.321    15.478     0.200
     1.119     8.423     0.200
     1.453     9.196     0.200
     1.588     9.858     0.200
     1.596    10.004     0.200
     1.737     8.401     0.200
     1.700     8.167     0.200
     2.148    10.979     0.200
     2.167    10.373     0.200
     2.393    12.052     0.200
     2.445    12.180     0.200
     2.448    12.721     0.200
     2.461    12.647     0.200
     2.468    12.473     0.200
     2.483    12.466     0.200
     2.494    12.003     0.200
     2.502    10.176     0.200
     2.503    12.014     0.200
     2.500    12.123     0.200
     2.516    11.666     0.200
     2.517    13.089     0.200
     2.525    11.433     0.200
     2.525    11.429     0.200
     2.575    13.869     0.200
     2.574    12.124     0.200
     2.574    13.323     0.200
     2.574    11.494     0.200
     2.574    12.975     0.200
     2.620    13.237     0.200
     2.643    13.265     0.200
     2.676    12.831     0.200
     2.706    12.160     0.200
     2.720    13.740     0.200
     2.740    12.519     0.200
     2.799    12.694     0.200
     2.844    12.228     0.200
     2.917    13.677     0.200
     3.022    13.286     0.200
     3.022    13.289     0.200
     3.031    13.230     0.200
     3.077    13.017     0.200
     3.108    13.006     0.200
     3.094    12.721     0.200
     3.094    14.361     0.200
     3.316    15.547     0.200
     3.544    13.036     0.200
     3.545    13.026     0.200
     3.610    13.071     0.200
     3.773    13.314     0.200
     3.773    14.552     0.200
     3.995    14.978     0.200
     4.371    14.004     0.200
     4.448    21.352     0.200
     4.459    17.517     0.200
     4.560    17.025     0.200
     4.789    15.148     0.200
     4.789    18.216     0.200
     4.838    14.147     0.200
     5.215    17.050     0.200
     5.346    18.808     0.200
     5.580    16.831     0.200
     5.630    16.635     0.200
     5.895    23.075     0.200
     6.077    21.016     0.200
     6.241    22.250     0.200
     6.473    18.952     0.200
     6.473    19.606     0.200
     6.473    20.565     0.200
     6.495    18.319     0.200
     6.495    22.381     0.200
     7.446    22.970     0.200
     7.446    23.351     0.200
     7.446    22.747     0.200
     7.446    22.644     0.200
     7.549    22.071     0.200
     7.585    23.583     0.200
     7.672    23.441     0.200
     8.038    25.476     0.200
     8.210    25.966     0.200
     8.210    26.471     0.200
     8.547    24.802     0.200
     8.547    20.093     0.200
     8.547    21.435     0.200
     8.550    20.898     0.200
     8.746    29.957     0.200
     8.822    28.503     0.200
     8.980    26.973     0.200
     9.187    28.096     0.200
     9.238    28.833     0.200
     9.276    25.139     0.200
     9.274    32.100     0.200
     9.274    29.196     0.200
     9.277    28.102     0.200
     9.381    23.632     0.200
     9.485    27.457     0.200
     9.657    28.269     0.200
     9.682    29.038     0.200
     9.852    32.630     0.200
     9.852    31.462     0.200
     9.909    27.823     0.200
    10.045    26.563     0.200
    10.078    27.022     0.200
    10.078    30.294     0.200
    10.112    31.365     0.200
    10.138    31.628     0.200
    10.168    29.142     0.200
    10.168    29.541     0.200
    10.334    31.709     0.200
    10.439    26.342     0.200
    10.419    29.433     0.200
    10.419    31.310     0.200
    10.451    29.830     0.200
    10.550    29.126     0.200
    10.550    29.821     0.200
    10.550    30.403     0.200
    10.554    31.550     0.200
    10.717    31.958     0.200
    10.740    30.704     0.200
    10.692    27.516     0.200
    10.698    33.137     0.200
    10.721    32.745     0.200
    10.767    33.957     0.200
    10.770    30.628     0.200
    10.896    30.199     0.200
    10.896    31.762     0.200
    10.970    32.930     0.200
    11.004    30.275     0.200
    11.004    32.872     0.200
    11.203    33.908     0.200
    11.397    32.311     0.200
    11.449    30.809     0.200
    11.513    27.377     0.200
    11.513    28.317     0.200
    11.513    28.868     0.200
    11.513    29.928     0.200
    11.513    31.473     0.200
    11.589    31.158     0.200
    11.647    32.836     0.200
    11.647    33.863     0.200
    11.690    35.338     0.200
    12.121    32.009     0.200
    12.160    34.794     0.200
    12.155    31.941     0.200
    12.155    33.161     0.200
    12.472    32.409     0.200
    12.464    33.286     0.200
    12.464    34.216     0.200
    12.464    34.326     0.200
    12.464    31.596     0.200
    12.464    32.766     0.200
    12.923    35.483     0.200
    12.923    33.427     0.200
    12.928    34.441     0.200
    13.069    36.443     0.200
    13.069    34.691     0.200
    13.069    37.413     0.200
    13.069    35.501     0.200
    13.149    33.449     0.200
    13.150    36.864     0.200
    13.226    34.533     0.200
    13.460    36.284     0.200
    13.460    35.232     0.200
    13.460    36.410     0.200
    13.576    33.482     0.200
    13.576    32.402     0.200
    13.576    34.614     0.200
    13.576    32.032     0.200
    13.576    33.182     0.200
    13.996    35.654     0.200
    13.996    37.584     0.200
    13.996    38.471     0.200
    13.996    36.184     0.200
    13.996    36.546     0.200
    14.337    37.671     0.200
    14.426    36.111     0.200
    14.426    38.111     0.200
    14.426    38.804     0.200
    14.426    36.221     0.200
    14.654    39.795     0.200
    14.682    37.605     0.200
    14.900    36.430     0.200
    14.962    38.134     0.200
    14.979    39.323     0.200
    15.015    39.096     0.200
    15.015    38.857     0.200
    15.041    37.282     0.200
    15.041    38.093     0.200
    15.255    36.263     0.200
    15.240    38.759     0.200
    15.266    39.861     0.200
    15.318    39.263     0.200
    15.322    39.212     0.200
    15.344    40.356     0.200
    15.486    39.032     0.200
    15.486    35.192     0.200
    15.516    40.295     0.200
    15.520    40.419     0.200
    15.552    40.409     0.200
    15.602    35.858     0.200
    15.602    36.038     0.200
    15.577    40.284     0.200
    15.589    40.314     0.200
    15.599    39.538     0.200
    15.599    39.999     0.200
    15.601    39.484     0.200
    15.624    39.319     0.200
    15.802    39.239     0.200
    15.834    39.929     0.200
    15.895    38.861     0.200
    15.895    39.777     0.200
    15.895    38.517     0.200
    15.895    40.087     0.200
    15.895    40.217     0.200
    16.034    38.826     0.200
    16.122    37.686     0.200
    16.151    37.820     0.200
    16.151    36.061     0.200
    16.151    40.010     0.200
    16.147    39.628     0.200
    16.154    39.894     0.200
    16.154    40.604     0.200
    16.317    39.575     0.200
    16.317    39.994     0.200
    16.317    39.043     0.200
    16.435    40.668     0.200
    16.709    40.628     0.200
    16.764    38.589     0.200
    16.942    34.730     0.200
    16.942    37.320     0.200
    16.942    38.899     0.200
    16.975    40.899     0.200
    16.994    40.656     0.200
    17.265    38.694     0.200
    17.423    40.031     0.200
    17.514    36.273     0.200
    17.793    38.293     0.200
    17.858    38.805     0.200
    17.856    40.285     0.200
    17.948    40.467     0.200
    18.084    40.017     0.200
    18.398    42.418     0.200
    18.546    42.976     0.200
    18.555    41.638     0.200
    18.555    41.767     0.200
    18.646    42.166     0.200
    18.677    41.454     0.200
    18.750    42.353     0.200
    18.769    41.911     0.200
    18.774    42.790     0.200
    18.971    40.829     0.200
    18.977    41.279     0.200
    18.977    41.450     0.200
    18.977    40.861     0.200
    19.000    42.259     0.200
    19.167    41.110     0.200
    19.658    43.740     0.200
    19.799    41.551     0.200
    19.799    43.561     0.200
    20.309    40.551     0.200
    20.309    42.013     0.200
    20.831    41.123     0.200
    21.006    40.874     0.200
     1.093     7.640     0.200
     1.570     9.372     0.200
     1.589     9.305     0.200
     1.661     9.643     0.200
     1.771     8.375     0.200
     2.084    10.857     0.200
     2.120     9.939     0.200
     2.127    10.094     0.200
     2.144    10.062     0.200
     2.263    11.275     0.200
     2.378    10.413     0.200
     2.417    11.735     0.200
     2.430    10.878     0.200
     2.445    11.903     0.200
     2.452    11.813     0.200
     2.456    11.669     0.200
     2.467    12.316     0.200
     2.478    10.857     0.200
     2.486    11.190     0.200
     2.491    10.025     0.200
     2.493    11.332     0.200
     2.497    10.632     0.200
     2.508    10.780     0.200
     2.509    10.776     0.200
     2.550    12.795     0.200
     2.549    11.359     0.200
     2.549    13.099     0.200
     2.549    10.919     0.200
     2.682    12.017     0.200
     2.695    13.675     0.200
     2.729    12.488     0.200
     2.786    11.881     0.200
     2.772    12.733     0.200
     2.819    13.265     0.200
     2.880    12.220     0.200
     2.884    13.422     0.200
     2.978    12.184     0.200
     3.046    13.181     0.200
     3.046    13.184     0.200
     3.054     8.105     0.200
     3.053    13.274     0.200
     3.053    14.124     0.200
     3.086    12.508     0.200
     3.518    12.226     0.200
     3.519    12.216     0.200
     3.572    11.497     0.200
     3.808    12.743     0.200
     4.369    12.261     0.200
     4.407    16.881     0.200
     4.418    18.773     0.200
     4.519    14.275     0.200
     4.814    15.895     0.200
     4.814    14.036     0.200
     4.814    17.468     0.200
     5.176    17.912     0.200
     5.540    17.215     0.200
     5.589    19.121     0.200
     5.853    23.283     0.200
     6.035    22.213     0.200
     6.211    17.996     0.200
     7.475    23.572     0.200
     7.475    22.612     0.200
     7.582    23.069     0.200
     7.617    22.634     0.200
     7.705    24.069     0.200
     8.006    20.542     0.200
     8.564    20.041     0.200
     8.711    28.840     0.200
     9.615    29.875     0.200
    10.202    28.933     0.200
    10.585    29.253     0.200
    11.039    30.409     0.200
    11.356    30.091     0.200
    11.528    28.941     0.200
    11.528    28.362     0.200
    11.528    26.171     0.200
    11.528    31.482     0.200
    11.681    31.077     0.200
    12.496    31.970     0.200
    12.496    34.770     0.200
    12.519    32.031     0.200
    12.621    32.686     0.200
    12.884    34.985     0.200
    13.189    33.646     0.200
    13.551    33.039     0.200
    14.040    36.712     0.200
    14.413    34.765     0.200
    14.460    36.490     0.200
    14.614    36.661     0.200
    14.645    36.483     0.200
    14.885    36.227     0.200
    15.076    37.676     0.200
    15.226    37.698     0.200
    15.695    38.083     0.200
    15.933    38.735     0.200
    16.954    37.769     0.200
    17.835    38.246     0.200
    18.937    40.799     0.200
    18.937    40.205     0.200
    19.472    40.104     0.200
    20.002    41.603     0.200
     0.577     6.074     0.200
     1.027     7.834     0.200
     1.426     8.643     0.200
     1.635     8.930     0.200
     1.786     8.275     0.200
     2.070    10.749     0.200
     2.054    11.123     0.200
     2.081    10.239     0.200
     2.096     9.624     0.200
     2.198    10.856     0.200
     2.260    10.892     0.200
     2.319    10.459     0.200
     2.350    13.706     0.200
     2.370    11.229     0.200
     2.385    10.662     0.200
     2.393    11.126     0.200
     2.400    12.498     0.200
     2.426    10.577     0.200
     2.434     9.836     0.200
     2.435     9.093     0.200
     2.435     9.303     0.200
     2.448    10.988     0.200
     2.449    10.984     0.200
     2.484     9.510     0.200
     2.485    12.776     0.200
     2.484    10.300     0.200
     2.530    12.965     0.200
     2.617    11.484     0.200
     2.617    11.884     0.200
     2.675    10.848     0.200
     2.706    12.244     0.200
     2.706    12.974     0.200
     2.754    12.917     0.200
     2.754    13.198     0.200
     2.842    12.169     0.200
     2.817    12.734     0.200
     2.817    13.184     0.200
     2.993    11.306     0.200
     2.986    12.272     0.200
     2.986    12.692     0.200
     2.993    13.716     0.200
     3.022    12.863     0.200
     3.022    13.303     0.200
     3.452    12.044     0.200
     3.453    12.034     0.200
     3.548    12.745     0.200
     3.824    12.015     0.200
     4.380    20.846     0.200
     4.484    18.304     0.200
     4.750    17.854     0.200
     4.807    15.762     0.200
     4.807    14.654     0.200
     5.147    18.537     0.200
     5.346    14.241     0.200
     5.511    17.120     0.200
     5.529    20.407     0.200
     5.991    20.093     0.200
     6.497    21.012     0.200
     6.535    19.941     0.200
     7.476    22.710     0.200
     7.476    21.890     0.200
     7.593    22.547     0.200
     7.628    23.472     0.200
     7.717    23.098     0.200
     7.939    23.154     0.200
     9.559    28.445     0.200
    10.217    28.549     0.200
    10.358    28.092     0.200
    10.601    29.339     0.200
    10.992    30.474     0.200
    11.053    28.910     0.200
    11.297    28.451     0.200
    11.350    26.930     0.200
    11.504    29.212     0.200
    11.504    28.273     0.200
    11.696    30.896     0.200
    12.074    34.103     0.200
    12.506    31.062     0.200
    12.506    34.062     0.200
    12.453    29.499     0.200
    12.554    29.918     0.200
    12.820    34.932     0.200
    12.820    31.942     0.200
    12.821    30.475     0.200
    13.811    33.733     0.200
    14.316    34.406     0.200
    14.476    35.001     0.200
    14.476    37.312     0.200
    14.551    35.566     0.200
    14.722    37.286     0.200
    14.960    35.452     0.200
    15.060    35.586     0.200
    15.159    36.245     0.200
    15.312    33.695     0.200
    15.513    35.020     0.200
    15.661    39.016     0.200
    15.628    34.775     0.200
    15.740    38.412     0.200
    15.955    39.911     0.200
    15.955    39.422     0.200
    16.212    38.834     0.200
    16.327    36.941     0.200
    16.719    38.609     0.200
    16.824    40.170     0.200
    16.925    38.528     0.200
    17.035    39.610     0.200
    17.092    38.856     0.200
    17.166    37.179     0.200
    17.163    36.795     0.200
    17.436    37.148     0.200
    17.771    38.087     0.200
    17.917    40.418     0.200
    17.950    38.331     0.200
    18.085    38.063     0.200
    18.436    39.364     0.200
    18.874    41.377     0.200
    18.874    41.593     0.200
     0.995     7.388     0.200
     1.265     8.563     0.200
     1.613     8.439     0.200
     1.802     9.501     0.200
     1.890    10.361     0.200
     2.033    10.720     0.200
     2.018    10.153     0.200
     2.027    10.619     0.200
     2.078    10.640     0.200
     2.256     7.712     0.200
     2.306    10.975     0.200
     2.334    10.653     0.200
     2.341    11.881     0.200
     2.355    12.174     0.200
     2.356    10.709     0.200
     2.362    11.833     0.200
     2.364    11.069     0.200
     2.364    11.066     0.200
     2.370    12.239     0.200
     2.441    12.523     0.200
     2.440    11.807     0.200
     2.440    11.288     0.200
     2.486    10.538     0.200
     2.510    12.559     0.200
     2.511     9.883     0.200
     2.567    11.491     0.200
     2.569    12.167     0.200
     2.590    13.077     0.200
     2.672    13.020     0.200
     2.689    11.740     0.200
     2.710    12.211     0.200
     2.782    11.899     0.200
     2.819    13.665     0.200
     2.857    12.565     0.200
     2.857    12.569     0.200
     2.865    13.148     0.200
     3.071    15.767     0.200
     3.342    12.652     0.200
     3.414    12.157     0.200
     3.415    12.146     0.200
     3.650    13.929     0.200
     3.679    13.349     0.200
     3.717    14.143     0.200
     3.818    14.069     0.200
     4.187    11.471     0.200
     4.625    14.986     0.200
     4.625    15.381     0.200
     4.697    18.837     0.200
     5.309    16.589     0.200
     5.607    22.457     0.200
     5.961    21.266     0.200
     6.355    20.298     0.200
    11.331    27.701     0.200
    15.787    38.274     0.200
    18.928    40.076     0.200
     1.268     9.698     0.200
     1.382     9.960     0.200
     1.691     9.848     0.200
     1.725    10.486     0.200
     2.677    13.275     0.200
     2.745    13.536     0.200
     0.302     5.702     0.200
     0.385     5.575     0.200
     0.686     5.836     0.200
     0.699     6.041     0.200
     0.899     6.428     0.200
     0.952     6.614     0.200
     1.141     7.586     0.200
     1.165     7.627     0.200
     1.204     7.458     0.200
     1.289     7.016     0.200
     1.323     8.249     0.200
     1.372     7.794     0.200
     1.465     7.405     0.200
     1.524     8.753     0.200
     1.886     9.752     0.200
     1.892     9.933     0.200
     2.005    11.028     0.200
     2.018     9.158     0.200
     2.055    11.102     0.200
     2.076     8.892     0.200
     2.098    10.668     0.200
     2.100     9.151     0.200
     2.110    10.098     0.200
     2.160    11.517     0.200
     2.244    12.770     0.200
     2.322    11.913     0.200
     2.334    10.397     0.200
     2.409    12.914     0.200
     2.415    11.474     0.200
     2.445    12.971     0.200
     2.511    10.451     0.200
     2.525     9.417     0.200
     2.621    13.574     0.200
     2.629    11.922     0.200
     2.952    11.447     0.200
     3.072    11.674     0.200
     3.452    13.763     0.200
     3.866    13.219     0.200
     4.581    12.927     0.200
     0.312     5.829     0.200
     0.411     5.636     0.200
     0.642     5.957     0.200
     0.818     6.602     0.200
     0.855     6.042     0.200
     0.871     6.601     0.200
     0.998     7.647     0.200
     1.130     7.399     0.200
     1.166     8.170     0.200
     1.269     7.740     0.200
     1.275     7.664     0.200
     1.446     7.162     0.200
     1.604     8.749     0.200
     1.621     7.984     0.200
     1.811     8.733     0.200
     1.944    10.006     0.200
     1.952     8.645     0.200
     1.960    10.443     0.200
     1.982     9.026     0.200
     1.983     9.316     0.200
     1.993     9.896     0.200
     2.014     9.848     0.200
     2.022     9.947     0.200
     2.049    10.303     0.200
     2.056    10.342     0.200
     2.089     9.860     0.200
     2.115    10.704     0.200
     2.120    11.608     0.200
     2.176     8.999     0.200
     2.284    11.504     0.200
     2.372    11.914     0.200
     2.405    10.838     0.200
     2.408    10.828     0.200
     2.409    10.996     0.200
     2.449    11.165     0.200
     2.484    12.613     0.200
     2.487     8.758     0.200
     2.502    13.219     0.200
     2.656    12.251     0.200
     2.667    10.521     0.200
     2.673    13.699     0.200
     2.802    11.256     0.200
     2.984    11.947     0.200
     3.349    12.338     0.200
     3.548    12.412     0.200
     3.566    14.222     0.200
     3.712    12.845     0.200
     4.428    14.587     0.200
     4.520    14.222     0.200
     4.572    14.814     0.200
     5.190    17.008     0.200
     5.291    14.764     0.200
     5.422    18.956     0.200
     6.133    18.494     0.200
    13.129    33.103     0.200
     1.437     8.960     0.200
     1.583     9.339     0.200
     1.592     9.519     0.200
     1.648     9.904     0.200
     1.663     8.463     0.200
     1.784     9.202     0.200
     1.972    10.318     0.200
     2.021    10.668     0.200
     2.178    10.788     0.200
     2.198    10.916     0.200
     2.422    11.161     0.200
     2.475    11.691     0.200
     2.493    11.241     0.200
     2.493    12.084     0.200
     2.499    11.934     0.200
     2.510    11.436     0.200
     2.514    11.672     0.200
     2.527    10.880     0.200
     2.533    11.340     0.200
     2.535    12.395     0.200
     2.544    11.086     0.200
     2.553     8.764     0.200
     2.556    11.862     0.200
     2.557    11.859     0.200
     2.565    12.156     0.200
     2.624    11.933     0.200
     2.624    12.263     0.200
     2.624    11.355     0.200
     2.650    11.011     0.200
     2.659    11.240     0.200
     2.694    12.580     0.200
     2.737    11.638     0.200
     2.754    11.668     0.200
     2.759    11.320     0.200
     2.791    11.508     0.200
     2.864    12.201     0.200
     2.944    12.068     0.200
     2.969    12.912     0.200
     2.969    12.915     0.200
     3.179    12.561     0.200
     3.405    14.375     0.200
     3.597    16.016     0.200
     3.698    12.950     0.200
     3.692    14.400     0.200
     4.219    11.960     0.200
     4.400    18.184     0.200
     4.547    18.940     0.200
     4.647    18.374     0.200
     4.734    15.363     0.200
     5.299    18.939     0.200
     6.511    23.544     0.200
     6.511    19.810     0.200
     6.511    24.294     0.200
    10.308    27.422     0.200
    11.478    27.333     0.200
    11.478    29.325     0.200
    11.484    30.580     0.200
    11.484    30.252     0.200
    11.513    28.762     0.200
    11.643    33.074     0.200
    12.015    30.067     0.200
    12.177    28.884     0.200
    12.717    30.792     0.200
    13.203    31.204     0.200
    13.300    33.810     0.200
    13.625    33.157     0.200
    13.655    32.566     0.200
    13.993    33.650     0.200
    14.146    33.173     0.200
    14.735    35.429     0.200
    14.758    36.769     0.200
    14.812    36.165     0.200
    15.002    35.447     0.200
    15.132    36.437     0.200
    15.181    35.118     0.200
    15.438    37.938     0.200
    15.489    36.215     0.200
    15.559    35.905     0.200
    15.602    36.815     0.200
    15.649    37.069     0.200
    15.706    39.400     0.200
    15.706    37.689     0.200
    15.756    36.387     0.200
    15.793    35.867     0.200
    15.815    39.332     0.200
    15.872    37.834     0.200
    15.934    37.044     0.200
    16.038    37.216     0.200
    16.131    38.786     0.200
    16.268    36.098     0.200
    16.287    37.384     0.200
    16.304    37.790     0.200
    16.494    38.570     0.200
    16.905    38.990     0.200
    16.975    38.890     0.200
    16.995    37.907     0.200
    17.320    37.489     0.200
    18.123    39.245     0.200
    18.271    39.720     0.200
    18.393    43.090     0.200
    18.393    41.809     0.200
    19.057    41.523     0.200
    19.057    40.327     0.200
    19.057    41.983     0.200
     0.595     5.850     0.200
     0.565     5.909     0.200
     0.785     6.576     0.200
     1.163     8.144     0.200
     1.153     7.877     0.200
     1.602     8.372     0.200
     1.603     9.680     0.200
     1.627     9.569     0.200
     1.836     9.711     0.200
     1.913     9.602     0.200
     2.114    10.905     0.200
     2.136    10.690     0.200
     2.177     9.956     0.200
     2.383    10.675     0.200
     2.455    11.249     0.200
     2.461    10.965     0.200
     2.484    11.178     0.200
     2.489    11.506     0.200
     2.496    10.993     0.200
     2.497    12.044     0.200
     2.515    11.759     0.200
     2.514    12.654     0.200
     2.539    11.846     0.200
     2.599    12.225     0.200
     2.599    12.115     0.200
     2.599    10.365     0.200
     2.615    11.363     0.200
     2.630    11.201     0.200
     2.670    12.918     0.200
     2.728    12.116     0.200
     2.762    13.161     0.200
     2.806    11.769     0.200
     2.831    12.879     0.200
     2.869    13.088     0.200
     2.882    11.722     0.200
     2.904    13.015     0.200
     2.904    13.012     0.200
     3.103    15.336     0.200
     3.196    14.345     0.200
     3.196    16.265     0.200
     3.638    13.872     0.200
     3.746    14.313     0.200
     3.809    13.288     0.200
     3.887    14.517     0.200
     4.448    17.633     0.200
     4.669    15.444     0.200
     4.669    17.274     0.200
     4.694    18.483     0.200
     5.351    18.827     0.200
     5.716    19.699     0.200
     6.350    23.310     0.200
     6.527    23.691     0.200
     6.527    20.591     0.200
     6.527    24.057     0.200
     6.527    24.191     0.200
     7.319    22.099     0.200
     7.319    22.669     0.200
     7.319    24.498     0.200
     7.416    23.240     0.200
     7.452    22.929     0.200
     7.623    26.049     0.200
     8.647    24.454     0.200
     9.548    30.559     0.200
     9.770    25.650     0.200
    10.033    27.989     0.200
    11.414    28.843     0.200
    11.414    27.533     0.200
    11.414    29.244     0.200
    11.688    36.818     0.200
    11.688    33.617     0.200
    11.688    33.418     0.200
    11.998    30.889     0.200
    12.331    30.210     0.200
    12.509    29.558     0.200
    13.009    35.195     0.200
    13.009    32.955     0.200
    13.010    33.148     0.200
    13.010    36.238     0.200
    13.300    34.554     0.200
    13.598    33.602     0.200
    13.644    33.785     0.200
    13.998    35.434     0.200
    14.141    35.247     0.200
    14.291    36.000     0.200
    14.464    34.457     0.200
    14.759    36.078     0.200
    14.905    37.445     0.200
    15.007    35.747     0.200
    15.126    35.081     0.200
    15.184    36.620     0.200
    15.462    37.734     0.200
    15.620    35.293     0.200
    15.716    39.100     0.200
    15.759    38.292     0.200
    15.782    36.135     0.200
    15.874    37.867     0.200
    15.954    39.675     0.200
    16.017    38.308     0.200
    16.628    38.783     0.200
    16.640    37.552     0.200
    16.850    37.571     0.200
    16.839    39.024     0.200
    16.927    39.560     0.200
    16.970    37.226     0.200
    17.294    40.122     0.200
    17.507    36.401     0.200
    17.720    39.208     0.200
    17.871    38.175     0.200
    17.911    37.476     0.200
    18.281    39.936     0.200
    18.417    42.160     0.200
    19.066    41.160     0.200
    19.066    40.654     0.200
    19.066    41.360     0.200
     0.312     5.425     0.200
     0.363     5.408     0.200
     0.489     5.164     0.200
     0.779     5.272     0.200
     0.884     6.267     0.200
     1.152     6.717     0.200
     1.254     7.214     0.200
     1.230     7.619     0.200
     1.343     7.764     0.200
     1.797     9.297     0.200
     1.844     7.877     0.200
     1.846     9.033     0.200
     2.058     9.700     0.200
     2.087    10.620     0.200
     2.106    11.080     0.200
     2.130    11.766     0.200
     2.116     9.638     0.200
     2.136    10.624     0.200
     2.166     9.490     0.200
     2.173    10.099     0.200
     2.176     9.191     0.200
     2.182     9.547     0.200
     2.208     8.923     0.200
     2.230     9.396     0.200
     2.235    11.508     0.200
     2.287    11.086     0.200
     2.297    10.684     0.200
     2.369    12.120     0.200
     2.451    12.572     0.200
     2.735    11.101     0.200
     2.724    10.797     0.200
     2.745    14.039     0.200
     2.866    11.062     0.200
     3.050    11.671     0.200
     3.199    11.180     0.200
     3.440    12.210     0.200
     3.964    13.118     0.200
     4.090    18.511     0.200
     4.330    16.877     0.200
     4.817    15.088     0.200
     0.287     6.299     0.200
     0.408     5.972     0.200
     0.610     5.998     0.200
     0.875     6.897     0.200
     1.018     7.544     0.200
     1.111     7.222     0.200
     1.217     7.563     0.200
     1.205     8.329     0.200
     1.263     7.641     0.200
     1.408     7.284     0.200
     1.547     8.617     0.200
     1.865     9.095     0.200
     1.879    10.011     0.200
     1.957     9.813     0.200
     1.954    10.145     0.200
     1.978    10.449     0.200
     1.972     8.776     0.200
     1.976     9.975     0.200
     1.985     8.875     0.200
     2.005    10.966     0.200
     2.065     9.475     0.200
     2.233    13.326     0.200
     2.355    10.366     0.200
     2.353    12.758     0.200
     2.355    10.212     0.200
     2.398    12.762     0.200
     2.428    12.563     0.200
     2.432    10.591     0.200
     2.514    12.613     0.200
     2.621    10.772     0.200
     2.621     8.989     0.200
     2.764    13.373     0.200
     2.833    11.246     0.200
     2.853    12.031     0.200
     3.029     9.979     0.200
     3.300    12.779     0.200
     3.508    11.711     0.200
     3.534     8.601     0.200
     3.745    13.035     0.200
     4.525    13.525     0.200
     5.138    17.435     0.200
     5.238    18.140     0.200
     5.370    18.602     0.200
     5.437    17.631     0.200
     5.506    17.791     0.200
     6.055    20.016     0.200
     6.579    20.016     0.200
     6.610    20.097     0.200
     6.702    19.173     0.200
     0.512     6.214     0.200
     0.480     6.132     0.200
     0.718     6.209     0.200
     1.005     7.090     0.200
     1.046     7.233     0.200
     1.101     7.766     0.200
     1.084     7.024     0.200
     1.247     7.891     0.200
     1.335     8.120     0.200
     1.297     6.907     0.200
     1.349     8.582     0.200
     1.686     8.543     0.200
     1.750     8.529     0.200
     1.802     8.110     0.200
     1.812     8.763     0.200
     1.838     8.264     0.200
     1.842     9.555     0.200
     1.857     9.051     0.200
     1.903     9.183     0.200
     1.952    10.607     0.200
     1.932     9.413     0.200
     2.019    10.484     0.200
     1.990     9.069     0.200
     2.153    10.255     0.200
     2.158    11.498     0.200
     2.091    10.611     0.200
     2.219    12.808     0.200
     2.240    11.897     0.200
     2.424    13.071     0.200
     2.471    10.110     0.200
     2.720    14.266     0.200
     2.965    10.184     0.200
     3.021    11.376     0.200
     3.035    10.754     0.200
     3.295    14.534     0.200
     3.473     8.938     0.200
     3.857    13.364     0.200
     4.309    16.991     0.200
     4.364    13.877     0.200
     4.561    13.233     0.200
     4.957    16.738     0.200
     5.186    17.386     0.200
     6.261    16.640     0.200
    12.864    32.969     0.200
     0.217     5.178     0.200
     0.295     5.547     0.200
     0.379     5.085     0.200
     0.392     4.739     0.200
     0.910     6.567     0.200
     0.955     6.251     0.200
     1.198     7.559     0.200
     1.360     8.187     0.200
     1.378     8.478     0.200
     1.439     7.974     0.200
     1.487     8.591     0.200
     1.912    10.579     0.200
     1.976     8.697     0.200
     1.978     8.319     0.200
     1.995     9.928     0.200
     2.187    10.287     0.200
     2.190    10.734     0.200
     2.250    10.192     0.200
     2.261    10.402     0.200
     2.256    11.007     0.200
     2.261    11.882     0.200
     2.297    10.153     0.200
     2.303     9.708     0.200
     2.308    10.744     0.200
     2.319    10.436     0.200
     2.343    11.639     0.200
     2.355    10.783     0.200
     2.378    10.091     0.200
     2.410    11.229     0.200
     2.417     9.640     0.200
     2.567    10.903     0.200
     2.645    11.753     0.200
     2.774    11.393     0.200
     2.874    11.184     0.200
     2.995    11.679     0.200
     3.012    11.858     0.200
     3.173    11.781     0.200
     3.317    12.124     0.200
     3.816    13.787     0.200
     4.027    14.278     0.200
     4.100    13.948     0.200
     4.270    13.631     0.200
     4.941    16.418     0.200
     0.918     7.168     0.200
     1.418     9.138     0.200
     1.400     8.365     0.200
     1.504     8.646     0.200
     1.933     9.688     0.200
     2.109    10.718     0.200
     2.177     9.669     0.200
     2.235    11.339     0.200
     2.359    11.341     0.200
     2.422    11.975     0.200
     2.434     9.699     0.200
     2.461    10.123     0.200
     2.484    10.531     0.200
     2.470    11.325     0.200
     2.496     9.508     0.200
     2.505    10.920     0.200
     2.538    10.799     0.200
     2.556     9.686     0.200
     2.564    12.363     0.200
     2.564    11.846     0.200
     2.564    11.057     0.200
     2.564    12.315     0.200
     2.608    11.809     0.200
     2.610    11.155     0.200
     2.619    12.697     0.200
     2.629    12.752     0.200
     2.630    12.928     0.200
     2.636    12.193     0.200
     2.699    11.788     0.200
     2.705    11.635     0.200
     2.752    12.838     0.200
     2.777    12.176     0.200
     2.857    12.303     0.200
     2.997    12.436     0.200
     2.961    13.324     0.200
     2.961    14.145     0.200
     3.063    11.984     0.200
     3.110    12.506     0.200
     3.113    13.274     0.200
     3.203    13.146     0.200
     3.202    13.150     0.200
     3.211    11.640     0.200
     3.149    14.710     0.200
     3.413    14.433     0.200
     3.963    13.011     0.200
     3.970    12.404     0.200
     4.014    18.199     0.200
     4.161    15.067     0.200
     4.121    16.075     0.200
     4.252    16.242     0.200
     4.468    19.565     0.200
     4.368    15.727     0.200
     4.832    18.793     0.200
     4.970    15.749     0.200
     4.970    16.683     0.200
     5.385    18.419     0.200
     5.685    17.836     0.200
     6.196    19.217     0.200
     6.294    22.184     0.200
     6.294    19.594     0.200
     6.689    19.437     0.200
     7.635    20.973     0.200
     7.635    21.383     0.200
     7.745    23.337     0.200
     7.780    23.584     0.200
     7.868    23.226     0.200
     7.981    21.161     0.200
    11.253    31.428     0.200
    11.253    30.608     0.200
    11.517    31.046     0.200
    11.366    32.025     0.200
    11.668    26.409     0.200
    11.668    27.940     0.200
    11.668    27.108     0.200
    11.668    26.069     0.200
    11.907    30.979     0.200
    11.967    33.174     0.200
    12.594    31.164     0.200
    12.810    35.446     0.200
    12.810    34.051     0.200
    12.811    34.177     0.200
    13.132    34.456     0.200
    13.523    33.140     0.200
    13.805    35.489     0.200
    13.994    34.963     0.200
    14.313    35.811     0.200
    14.358    34.755     0.200
    14.534    36.589     0.200
    14.585    36.554     0.200
    14.635    37.232     0.200
    14.816    38.420     0.200
    14.981    37.278     0.200
    15.153    36.677     0.200
    15.214    36.682     0.200
    15.246    37.771     0.200
    15.321    38.223     0.200
    15.528    37.910     0.200
    15.504    38.774     0.200
    15.504    38.297     0.200
    15.592    36.991     0.200
    15.575    37.517     0.200
    15.663    36.759     0.200
    15.692    38.689     0.200
    15.926    37.291     0.200
    16.141    38.445     0.200
    16.151    38.040     0.200
    16.358    38.697     0.200
    16.669    40.615     0.200
    16.716    39.109     0.200
    16.860    38.656     0.200
    16.926    38.558     0.200
    17.172    39.119     0.200
    17.221    38.523     0.200
    17.540    38.666     0.200
    17.560    38.722     0.200
    17.549    39.120     0.200
    17.744    39.425     0.200
    17.804    38.953     0.200
    17.804    39.132     0.200
    17.854    39.080     0.200
    17.976    38.797     0.200
    17.970    39.173     0.200
    18.062    40.349     0.200
    18.133    38.616     0.200
    18.250    38.960     0.200
    18.404    38.515     0.200
    18.514    39.002     0.200
    18.514    38.471     0.200
    18.753    40.363     0.200
    18.858    41.540     0.200
     0.257     5.988     0.200
     0.593     5.712     0.200
     0.650     6.095     0.200
     0.708     5.802     0.200
     0.761     5.919     0.200
     1.014     7.284     0.200
     1.113     7.353     0.200
     1.125     7.324     0.200
     1.177     7.335     0.200
     1.616     8.748     0.200
     1.686     8.704     0.200
     1.722     8.340     0.200
     1.841     9.647     0.200
     1.886     9.283     0.200
     1.920     9.254     0.200
     1.971     9.937     0.200
     1.985     9.308     0.200
     1.993    10.026     0.200
     2.036     9.404     0.200
     2.049    10.631     0.200
     2.097    10.316     0.200
     2.495     9.816     0.200
     2.636    10.608     0.200
     2.695     9.067     0.200
     2.753    11.144     0.200
     2.778    12.198     0.200
     3.622     9.961     0.200
     3.752    12.759     0.200
     4.243    16.699     0.200
     4.479    15.251     0.200
     4.602    15.557     0.200
     1.224     7.185     0.200
     1.233     8.028     0.200
     1.875     9.747     0.200
     1.863     8.493     0.200
     1.912     8.959     0.200
     2.060    10.159     0.200
     2.167    10.003     0.200
     2.217    10.085     0.200
     2.229    10.764     0.200
     2.238    10.300     0.200
     2.242    10.122     0.200
     2.290    10.751     0.200
     2.306    11.428     0.200
     2.306    11.319     0.200
     2.378    11.297     0.200
     2.524    11.958     0.200
     2.758    11.060     0.200
     2.815    12.616     0.200
     2.844    12.473     0.200
     2.890    11.603     0.200
     2.883    11.843     0.200
     3.047    12.807     0.200
     3.047    12.803     0.200
     3.071    12.084     0.200
     3.271    12.357     0.200
     3.272    12.347     0.200
     3.467    11.946     0.200
     3.851    13.548     0.200
     3.896    13.481     0.200
     4.129    15.404     0.200
     4.212    15.344     0.200
     4.371    16.978     0.200
     4.740    15.161     0.200
     4.815    17.074     0.200
     5.412    17.848     0.200
     5.851    17.581     0.200
     5.957    18.231     0.200
     6.514    20.580     0.200
     6.582    19.510     0.200
     7.504    21.278     0.200
     7.504    22.098     0.200
     7.650    22.534     0.200
     7.682    23.912     0.200
     7.750    23.188     0.200
     8.454    24.090     0.200
    11.458    29.622     0.200
    11.458    30.224     0.200
    12.634    35.087     0.200
    12.634    34.969     0.200
    12.634    34.732     0.200
    12.934    35.716     0.200
    14.127    33.922     0.200
    14.367    36.541     0.200
    14.391    36.965     0.200
    14.910    37.994     0.200
    14.973    37.078     0.200
    15.069    37.786     0.200
    15.388    37.622     0.200
    15.692    36.953     0.200
    15.926    38.554     0.200
    16.137    38.560     0.200
    16.547    38.578     0.200
    18.415    39.116     0.200
    18.542    40.033     0.200
    18.596    40.890     0.200
    18.647    39.409     0.200
    18.688    39.384     0.200
    18.688    40.185     0.200
    18.689    40.692     0.200
    18.735    40.243     0.200
    19.001    39.799     0.200
    19.039    39.880     0.200
    19.071    40.297     0.200
    19.947    38.751     0.200
     1.410     8.368     0.200
     1.519     8.763     0.200
     1.587     9.371     0.200
     2.102    10.788     0.200
     2.126    11.617     0.200
     2.179    10.225     0.200
     2.351    11.175     0.200
     2.408    11.764     0.200
     2.464    11.284     0.200
     2.496    11.625     0.200
     2.506    11.382     0.200
     2.507    11.578     0.200
     2.539    11.625     0.200
     2.536    13.300     0.200
     2.555    11.194     0.200
     2.568    12.769     0.200
     2.595    13.355     0.200
     2.612    13.232     0.200
     2.613    12.409     0.200
     2.621    10.800     0.200
     2.633    10.347     0.200
     2.679    12.677     0.200
     2.703    13.171     0.200
     2.709    11.655     0.200
     2.836    11.302     0.200
     2.864    13.220     0.200
     2.934    12.830     0.200
     2.991    12.334     0.200
     2.973    13.277     0.200
     3.067    13.145     0.200
     3.102    12.849     0.200
     3.079    14.720     0.200
     3.191    13.512     0.200
     3.191    13.515     0.200
     3.162    14.391     0.200
     3.427    13.376     0.200
     3.530    14.443     0.200
     3.957    13.335     0.200
     3.958    13.359     0.200
     4.026    15.811     0.200
     4.136    17.957     0.200
     4.267    19.378     0.200
     4.383    18.281     0.200
     4.464    15.977     0.200
     4.835    18.502     0.200
     4.959    16.326     0.200
     4.959    16.561     0.200
     4.970    19.285     0.200
     5.034    18.242     0.200
     5.399    18.282     0.200
     5.505    23.285     0.200
     5.721    22.752     0.200
     5.912    21.439     0.200
     6.203    19.991     0.200
     6.647    21.088     0.200
     6.676    21.700     0.200
     7.623    23.361     0.200
     7.731    23.666     0.200
     7.767    24.096     0.200
     7.855    23.524     0.200
     7.988    26.780     0.200
    11.659    26.341     0.200
    11.659    28.138     0.200
    12.822    32.669     0.200
    12.821    34.809     0.200
    12.821    32.301     0.200
    13.142    33.060     0.200
    13.530    37.404     0.200
    13.565    37.214     0.200
    14.003    37.755     0.200
    14.365    36.894     0.200
    14.545    38.135     0.200
    14.595    37.939     0.200
    14.826    38.603     0.200
    14.990    37.669     0.200
    15.680    39.323     0.200
    15.761    39.491     0.200
    17.071    38.645     0.200
    17.182    38.598     0.200
    17.563    39.325     0.200
    17.583    39.137     0.200
    17.812    38.997     0.200
    18.074    39.985     0.200
    18.141    39.331     0.200
    18.594    39.708     0.200
    18.648    39.977     0.200
    18.787    40.103     0.200
    18.869    40.412     0.200
    18.869    40.294     0.200
    19.975    39.975     0.200
     1.670     9.531     0.200
     1.747     9.468     0.200
     1.762    10.315     0.200
     1.781     9.775     0.200
     1.898    10.478     0.200
     1.982    10.258     0.200
     2.059     9.717     0.200
     2.181    10.159     0.200
     2.232    11.990     0.200
     2.388    11.736     0.200
     2.427    12.281     0.200
     2.435    10.945     0.200
     2.478    12.154     0.200
     2.491    10.843     0.200
     2.491    10.841     0.200
     2.506    12.806     0.200
     2.508    12.132     0.200
     2.555    12.634     0.200
     2.568    12.238     0.200
     2.605    12.243     0.200
     2.622    11.038     0.200
     2.622    12.108     0.200
     2.623    13.325     0.200
     2.622    11.147     0.200
     2.636    12.520     0.200
     2.644    12.959     0.200
     2.647    12.590     0.200
     2.651    13.388     0.200
     2.653    13.208     0.200
     2.669    12.451     0.200
     2.670    11.034     0.200
     2.695    12.878     0.200
     2.697    12.428     0.200
     2.694    13.086     0.200
     2.694    13.089     0.200
     2.702    12.604     0.200
     2.719    11.726     0.200
     2.745    11.183     0.200
     2.776    12.525     0.200
     2.865    14.460     0.200
     2.891    11.398     0.200
     3.048    13.732     0.200
     3.123    13.528     0.200
     3.267    14.684     0.200
     3.348    14.612     0.200
     3.348    14.456     0.200
     3.411    14.383     0.200
     3.599    17.167     0.200
     3.626    14.109     0.200
     3.695    13.052     0.200
     3.692    13.716     0.200
     3.900    14.052     0.200
     3.971    14.511     0.200
     4.203    15.387     0.200
     4.368    16.943     0.200
     4.456    15.939     0.200
     4.456    14.173     0.200
     5.163    21.277     0.200
     5.179    17.106     0.200
     5.573    18.742     0.200
     5.937    20.031     0.200
     6.132    23.294     0.200
     6.238    20.259     0.200
     6.330    20.818     0.200
     6.406    22.529     0.200
     6.672    22.132     0.200
     6.672    22.983     0.200
     7.097    20.450     0.200
     7.097    24.255     0.200
     8.144    29.479     0.200
     9.256    29.473     0.200
     9.937    29.604     0.200
    11.227    28.995     0.200
    11.227    27.042     0.200
    11.227    30.417     0.200
    11.556    31.638     0.200
    11.659    32.248     0.200
    11.899    34.175     0.200
    12.759    32.827     0.200
    13.126    35.338     0.200
    13.126    34.604     0.200
    13.127    34.401     0.200
    13.395    35.512     0.200
    13.603    34.476     0.200
    13.706    35.406     0.200
    14.111    38.399     0.200
    14.221    37.342     0.200
    14.516    37.383     0.200
    14.858    38.587     0.200
    14.871    38.206     0.200
    15.119    39.385     0.200
    15.204    39.463     0.200
    15.533    36.787     0.200
    15.562    37.219     0.200
    15.841    37.857     0.200
    15.842    37.723     0.200
    16.067    37.682     0.200
    16.234    37.777     0.200
    16.550    39.564     0.200
    16.673    40.234     0.200
    16.929    39.612     0.200
    17.533    40.009     0.200
    17.554    40.351     0.200
    17.854    40.311     0.200
    17.861    39.786     0.200
    17.878    39.660     0.200
    17.963    40.298     0.200
    18.088    39.835     0.200
    18.199    39.629     0.200
    18.328    39.696     0.200
    18.411    40.744     0.200
    18.817    40.373     0.200
    19.022    40.729     0.200
    19.189    41.060     0.200
    19.189    40.685     0.200
    19.188    40.897     0.200
    19.295    40.363     0.200
    20.170    40.051     0.200
     1.241     6.661     0.200
     1.938     9.252     0.200
     2.247    10.384     0.200
     2.249    10.800     0.200
     2.276    11.370     0.200
     2.288    11.477     0.200
     2.341    11.058     0.200
     2.333     9.869     0.200
     2.340    10.513     0.200
     2.347    10.733     0.200
     2.354    11.104     0.200
     2.373    11.091     0.200
     2.383     9.836     0.200
     2.396    10.773     0.200
     2.482    11.529     0.200
     2.520    12.212     0.200
     2.586    11.876     0.200
     2.552    11.468     0.200
     2.957    11.139     0.200
     3.120    12.143     0.200
     3.197    12.019     0.200
     3.231    13.320     0.200
     3.336    13.267     0.200
     3.816    14.909     0.200
     3.930    15.280     0.200
     4.058    16.051     0.200
     4.210    13.093     0.200
     4.736    15.716     0.200
     5.383    19.357     0.200
     1.421     9.340     0.200
     1.970    11.146     0.200
     2.289    12.273     0.200
     2.299    11.948     0.200
     2.362    12.766     0.200
     2.407    10.673     0.200
     2.818    12.830     0.200
     2.947    14.096     0.200
     4.112    16.281     0.200
     0.192     5.877     0.200
     0.306     5.646     0.200
     0.469     5.292     0.200
     0.885     6.434     0.200
     1.037     6.722     0.200
     1.123     7.371     0.200
     1.345     8.019     0.200
     1.360     8.202     0.200
     1.417     8.459     0.200
     1.528     7.766     0.200
     1.528     8.666     0.200
     1.870     9.700     0.200
     1.953     9.208     0.200
     2.056     9.226     0.200
     2.139    10.990     0.200
     2.218    10.892     0.200
     2.222    11.112     0.200
     2.244    10.688     0.200
     2.275    11.378     0.200
     2.286    11.251     0.200
     2.292    10.978     0.200
     2.300    10.560     0.200
     2.304    10.737     0.200
     2.322    10.596     0.200
     2.321    11.659     0.200
     2.321    10.989     0.200
     2.321    10.499     0.200
     2.350    10.681     0.200
     2.355    10.699     0.200
     2.355    10.693     0.200
     2.366    11.274     0.200
     2.371     9.886     0.200
     2.370    11.167     0.200
     2.383    11.339     0.200
     2.385    10.819     0.200
     2.387    10.928     0.200
     2.393    10.884     0.200
     2.426    11.384     0.200
     2.431    11.183     0.200
     2.458    10.727     0.200
     2.459    11.066     0.200
     2.478    11.342     0.200
     2.525    11.802     0.200
     2.588    10.831     0.200
     2.692    11.046     0.200
     2.692    13.076     0.200
     2.692    12.096     0.200
     2.801    11.788     0.200
     2.879    12.982     0.200
     2.901    11.558     0.200
     2.910    14.194     0.200
     3.050    11.872     0.200
     3.076    11.866     0.200
     3.235    13.086     0.200
     3.235    13.090     0.200
     3.274    12.072     0.200
     3.275    12.062     0.200
     3.273    12.514     0.200
     3.741    13.649     0.200
     3.825    12.152     0.200
     3.828    12.525     0.200
     3.942    17.090     0.200
     4.090    14.512     0.200
     4.151    14.464     0.200
     4.184    16.888     0.200
     4.329    14.526     0.200
     4.587    14.984     0.200
     4.689    15.093     0.200
     4.859    16.642     0.200
     5.002    15.105     0.200
     5.002    15.659     0.200
     5.226    17.298     0.200
     5.221    17.259     0.200
     5.495    16.449     0.200
     5.510    20.616     0.200
     5.705    16.370     0.200
     5.679    18.629     0.200
     6.025    20.893     0.200
     6.025    17.443     0.200
     6.025    21.373     0.200
     6.025    19.323     0.200
     6.703    20.210     0.200
     6.776    20.434     0.200
     7.695    22.802     0.200
     7.695    22.582     0.200
     7.710    22.882     0.200
     7.844    23.563     0.200
     7.876    23.903     0.200
     7.967    24.077     0.200
     8.397    24.650     0.200
     8.420    24.840     0.200
     9.249    26.739     0.200
    10.044    28.264     0.200
    10.728    29.327     0.200
    10.991    30.026     0.200
    11.242    29.432     0.200
    11.621    30.144     0.200
    11.621    28.676     0.200
    11.621    28.104     0.200
    11.621    30.474     0.200
    12.536    33.047     0.200
    12.535    34.258     0.200
    12.535    34.384     0.200
    12.855    35.729     0.200
    13.249    32.951     0.200
    13.530    32.598     0.200
    13.718    34.607     0.200
    13.743    34.777     0.200
    14.087    34.429     0.200
    15.231    35.874     0.200
    15.657    35.524     0.200
    16.233    38.131     0.200
    16.294    35.747     0.200
    18.585    40.907     0.200
     1.193     6.887     0.200
     1.991     9.065     0.200
     2.155    10.748     0.200
     2.222    10.019     0.200
     2.335    10.250     0.200
     2.335     9.658     0.200
     2.409    10.443     0.200
     2.435    11.164     0.200
     2.441     9.923     0.200
     2.640    11.451     0.200
     2.768     8.932     0.200
     2.761    11.290     0.200
     3.020    11.025     0.200
     3.107    11.678     0.200
     3.183    12.524     0.200
     3.242    12.789     0.200
     3.274    11.638     0.200
     3.779    15.936     0.200
     3.881    12.072     0.200
     3.926    14.059     0.200
     4.022    16.315     0.200
     4.256    14.227     0.200
     4.299    14.864     0.200
     4.694    15.664     0.200
     5.159    17.472     0.200
     5.351    19.040     0.200
     5.860    16.522     0.200
     8.009    23.946     0.200
     1.351     7.326     0.200
     1.911     9.118     0.200
     2.006    10.238     0.200
     2.068     9.136     0.200
     2.093    10.576     0.200
     2.178    10.315     0.200
     2.237    10.542     0.200
     2.242    10.624     0.200
     2.282    10.496     0.200
     2.277     9.478     0.200
     2.277     9.946     0.200
     2.316     8.736     0.200
     2.326    11.129     0.200
     2.339    10.608     0.200
     2.415    11.360     0.200
     2.478    11.433     0.200
     2.480    11.137     0.200
     2.876    11.007     0.200
     3.031    11.919     0.200
     3.088    11.910     0.200
     3.231    12.631     0.200
     3.263    13.146     0.200
     3.923    12.449     0.200
     4.165    15.887     0.200
     2.758    14.119     0.200
     3.497    16.019     0.200
     4.422    18.932     0.200
     6.822    23.457     0.200
     7.043    26.265     0.200
     7.043    24.616     0.200
     7.883    27.452     0.200
    10.101    32.510     0.200
    10.559    31.989     0.200
    11.229    34.651     0.200
    11.229    32.015     0.200
    11.229    32.558     0.200
    11.200    34.415     0.200
    11.698    36.121     0.200
    11.808    37.883     0.200
    11.808    36.539     0.200
    11.808    36.426     0.200
    11.808    34.504     0.200
    12.029    37.127     0.200
    12.029    35.158     0.200
    12.029    35.627     0.200
    12.129    35.830     0.200
    13.277    38.966     0.200
    13.543    41.308     0.200
    13.729    38.587     0.200
    13.729    37.192     0.200
    13.849    38.381     0.200
    15.434    42.066     0.200
     0.900     9.779     0.200
     1.037    10.219     0.200
     1.312    11.175     0.200
     1.356    11.763     0.200
     1.813    11.395     0.200
     2.374    13.848     0.200
     2.544    13.768     0.200
     2.615    14.890     0.200
     2.630    14.858     0.200
     2.668    15.039     0.200
     2.643    14.529     0.200
     2.689    14.704     0.200
     2.705    14.184     0.200
     2.708    15.039     0.200
     2.726    14.487     0.200
     2.743    15.296     0.200
     2.758    15.119     0.200
     2.767    15.148     0.200
     2.782    15.563     0.200
     2.782    15.301     0.200
     2.782    15.430     0.200
     2.784    15.203     0.200
     2.804    14.912     0.200
     2.833    15.413     0.200
     2.853    15.054     0.200
     2.879    15.359     0.200
     2.896    15.739     0.200
     2.913    14.805     0.200
     3.004    15.572     0.200
     3.026    15.757     0.200
     3.194    15.960     0.200
     3.251    16.169     0.200
     3.327    16.047     0.200
     3.414    16.805     0.200
     3.497    17.878     0.200
     3.686    16.836     0.200
     3.734    17.820     0.200
     3.766    16.314     0.200
     4.004    17.631     0.200
     4.075    17.855     0.200
     4.273    15.784     0.200
     4.422    18.690     0.200
     4.518    19.201     0.200
     4.784    20.668     0.200
     4.910    20.910     0.200
     4.918    21.639     0.200
     4.989    19.836     0.200
     5.030    19.993     0.200
     5.036    19.653     0.200
     5.150    19.740     0.200
     6.049    23.407     0.200
     6.069    22.162     0.200
     6.087    21.945     0.200
     6.119    22.260     0.200
     6.364    26.799     0.200
     6.469    25.326     0.200
     6.539    22.310     0.200
     6.822    25.496     0.200
     7.043    25.538     0.200
     7.131    24.209     0.200
     8.245    30.336     0.200
     8.286    27.917     0.200
     9.027    29.333     0.200
     9.280    32.159     0.200
    10.084    32.229     0.200
    10.900    34.960     0.200
    11.229    32.288     0.200
    11.406    35.139     0.200
    11.808    35.566     0.200
    13.133    37.578     0.200
     0.233     6.222     0.200
     0.568     5.752     0.200
     0.690     5.906     0.200
     0.679     6.175     0.200
     0.753     6.126     0.200
     1.029     7.491     0.200
     1.136     7.640     0.200
     1.155     7.636     0.200
     1.192     7.688     0.200
     1.642     8.861     0.200
     1.712     6.602     0.200
     1.739     8.225     0.200
     1.718     8.447     0.200
     1.857     9.514     0.200
     1.909     9.440     0.200
     2.017     9.608     0.200
     2.021    11.693     0.200
     2.024     8.478     0.200
     2.026     9.006     0.200
     2.068     9.437     0.200
     2.069    10.273     0.200
     2.108    10.076     0.200
     2.106    11.022     0.200
     2.261    12.540     0.200
     2.359    11.912     0.200
     2.400    12.086     0.200
     2.660    10.651     0.200
     2.661    10.631     0.200
     2.754    11.041     0.200
     4.242    15.181     0.200
     4.335    14.901     0.200
     4.478    16.726     0.200
     0.318     5.083     0.200
     0.317     5.271     0.200
     0.462     5.163     0.200
     0.832     6.326     0.200
     0.889     6.069     0.200
     1.183     7.326     0.200
     1.306     7.859     0.200
     1.385     8.232     0.200
     1.513     8.240     0.200
     1.847     9.469     0.200
     1.905     8.274     0.200
     1.892     9.419     0.200
     1.898     8.212     0.200
     2.091    10.049     0.200
     2.139    10.962     0.200
     2.159    10.025     0.200
     2.183    12.016     0.200
     2.230     9.722     0.200
     2.286    10.525     0.200
     2.322    11.111     0.200
     2.421    12.941     0.200
     2.502     9.834     0.200
     2.598     9.185     0.200
     2.772    10.962     0.200
     2.910    11.404     0.200
     3.080    11.657     0.200
     4.847    16.231     0.200
     0.879     6.011     0.200
     1.538     8.122     0.200
     1.834     9.608     0.200
     1.834     8.866     0.200
     1.889     9.682     0.200
     2.048    10.107     0.200
     2.104    10.393     0.200
     2.155    10.600     0.200
     2.162     9.112     0.200
     2.195    10.762     0.200
     2.220     9.838     0.200
     2.225     9.131     0.200
     2.288    11.060     0.200
     2.277     8.228     0.200
     2.291    10.781     0.200
     2.359    11.323     0.200
     2.494    11.617     0.200
     2.712    10.967     0.200
     2.744    12.407     0.200
     2.771    10.234     0.200
     2.854    11.697     0.200
     3.040    11.796     0.200
     3.190    10.329     0.200
     3.447    11.532     0.200
     3.652    11.678     0.200
     3.682    11.055     0.200
     4.095    15.394     0.200
     4.199    18.598     0.200
     4.335    18.490     0.200
     4.807    14.672     0.200
     5.023    14.453     0.200
     1.529     8.469     0.200
     2.110    10.411     0.200
     2.195    10.949     0.200
     2.357    10.996     0.200
     2.521    12.027     0.200
     2.534    12.568     0.200
     2.555    12.276     0.200
     2.570    11.077     0.200
     2.585    12.869     0.200
     2.585    12.716     0.200
     2.585    12.216     0.200
     2.585    13.040     0.200
     2.613    13.005     0.200
     2.631    12.044     0.200
     2.689    12.161     0.200
     2.726    12.588     0.200
     2.799    12.933     0.200
     2.883    13.129     0.200
     2.999    12.126     0.200
     2.991    14.565     0.200
     2.991    13.796     0.200
     3.132    14.694     0.200
     3.108    12.235     0.200
     3.098    13.641     0.200
     3.191    13.104     0.200
     3.548    13.613     0.200
     3.436    12.591     0.200
     3.970    14.774     0.200
     4.036    16.012     0.200
     3.950    14.928     0.200
     4.044    15.326     0.200
     4.154    14.423     0.200
     4.475    16.233     0.200
     4.283    15.718     0.200
     4.853    17.657     0.200
     4.989    16.778     0.200
     4.959    16.395     0.200
     4.959    16.262     0.200
     5.044    15.658     0.200
     5.504    17.302     0.200
     5.523    19.372     0.200
     5.409    17.430     0.200
     5.674    17.962     0.200
     5.734    17.955     0.200
     5.926    18.400     0.200
     6.221    20.348     0.200
     6.324    21.866     0.200
     6.324    20.674     0.200
     6.646    21.305     0.200
     6.672    20.999     0.200
     7.621    24.525     0.200
     7.621    23.716     0.200
     7.726    24.223     0.200
     7.750    22.959     0.200
     7.762    25.536     0.200
     7.850    24.353     0.200
     8.007    24.267     0.200
     8.505    26.237     0.200
     8.702    23.701     0.200
     8.699    28.023     0.200
     8.675    24.874     0.200
     8.950    27.155     0.200
    10.227    30.399     0.200
    10.310    29.938     0.200
    10.727    31.570     0.200
    11.283    32.534     0.200
    11.283    33.777     0.200
    11.416    33.658     0.200
    11.544    32.299     0.200
    11.826    33.056     0.200
    12.059    32.374     0.200
    12.553    33.791     0.200
    12.641    35.689     0.200
    12.641    35.252     0.200
    12.840    36.728     0.200
    12.840    35.829     0.200
    12.840    35.834     0.200
    13.161    36.756     0.200
    13.246    38.447     0.200
    13.549    35.656     0.200
    13.583    33.919     0.200
    13.583    35.298     0.200
    13.636    38.222     0.200
    14.033    36.967     0.200
    14.384    36.510     0.200
    16.071    41.409     0.200
     1.338     7.934     0.200
     1.441     7.739     0.200
     1.866     9.198     0.200
     1.893     9.400     0.200
     2.034     9.420     0.200
     2.381    10.409     0.200
     2.256     8.515     0.200
     2.454    10.515     0.200
     2.596    10.258     0.200
     2.606    11.206     0.200
     2.606    11.836     0.200
     2.630    10.721     0.200
     2.669    11.582     0.200
     2.693    11.576     0.200
     2.740    10.892     0.200
     2.689    11.779     0.200
     2.752    10.968     0.200
     2.715    10.570     0.200
     2.723    11.462     0.200
     2.761    11.433     0.200
     2.785    11.948     0.200
     2.818    11.599     0.200
     2.836    11.393     0.200
     2.832    11.948     0.200
     2.832    12.362     0.200
     2.832    12.698     0.200
     2.832    12.542     0.200
     2.833    11.390     0.200
     2.856    11.717     0.200
     2.855    11.994     0.200
     2.855    12.689     0.200
     2.858    12.393     0.200
     2.878    12.159     0.200
     2.899    12.589     0.200
     2.908    11.537     0.200
     2.925    11.888     0.200
     2.946    13.618     0.200
     2.951    11.938     0.200
     2.964    11.782     0.200
     2.987    13.053     0.200
     3.098    12.310     0.200
     3.255    10.669     0.200
     3.317    13.121     0.200
     3.279    12.283     0.200
     3.333    13.582     0.200
     3.499    12.762     0.200
     3.659    12.677     0.200
     3.592    16.592     0.200
     3.592    13.100     0.200
     3.787    12.881     0.200
     3.807    14.544     0.200
     3.862    14.222     0.200
     4.294    15.042     0.200
     4.378    13.318     0.200
     4.160    11.376     0.200
     4.612    14.322     0.200
     5.008    14.320     0.200
     5.055    18.465     0.200
     5.108    15.028     0.200
     5.009    13.457     0.200
     5.393    17.660     0.200
     5.771    15.033     0.200
     6.004    17.959     0.200
     6.036    18.599     0.200
     6.128    20.144     0.200
     6.137    16.083     0.200
     6.546    19.912     0.200
     6.456    17.521     0.200
     6.634    17.561     0.200
     6.985    20.815     0.200
     6.985    21.706     0.200
     6.985    21.214     0.200
     6.917    22.969     0.200
     6.917    22.445     0.200
     6.917    23.594     0.200
     6.917    20.594     0.200
     7.043    19.927     0.200
     7.082    20.936     0.200
     7.260    21.513     0.200
     7.810    22.932     0.200
     8.365    26.065     0.200
     9.111    28.935     0.200
    10.027    27.681     0.200
    10.485    27.427     0.200
    11.205    29.180     0.200
    11.205    28.547     0.200
    11.493    32.506     0.200
    11.777    32.605     0.200
    11.960    31.169     0.200
    11.960    30.490     0.200
    11.960    35.240     0.200
    11.904    30.807     0.200
    11.904    33.447     0.200
    11.904    32.525     0.200
    11.904    34.299     0.200
    12.209    31.570     0.200
    12.339    32.276     0.200
    12.543    33.848     0.200
    13.368    35.588     0.200
    13.368    35.158     0.200
    13.369    35.354     0.200
    13.369    36.300     0.200
    13.466    34.503     0.200
    13.466    33.604     0.200
    13.631    35.103     0.200
    13.793    35.052     0.200
    13.793    32.692     0.200
    13.793    33.974     0.200
    13.930    34.395     0.200
    14.351    36.473     0.200
    14.451    36.277     0.200
    14.734    35.293     0.200
    14.781    34.694     0.200
    15.114    36.978     0.200
    15.352    39.175     0.200
    18.826    42.116     0.200
    19.431    40.854     0.200
     2.610    12.656     0.200
     2.591    13.476     0.200
     4.982    17.579     0.200
     6.085    22.002     0.200
     6.674    25.333     0.200
     6.674    24.524     0.200
     8.119    27.064     0.200
    11.165    30.117     0.200
    11.165    30.719     0.200
    11.665    35.761     0.200
    12.053    34.385     0.200
    13.565    36.711     0.200
    13.565    37.110     0.200
    13.565    34.809     0.200
    13.565    35.711     0.200
    13.683    36.127     0.200
    15.579    37.931     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.837    18.821     0.200
     3.072    21.153     0.200
     3.079    22.164     0.200
     3.140    20.792     0.200
     3.251    27.111     0.200
     4.570    29.942     0.200
     2.701    19.491     0.200
     7.407    57.677     0.200
     8.082    55.020     0.200
     2.892    20.801     0.200
     5.485    35.802     0.200
     2.891    21.794     0.200
     2.605    25.278     0.200
     2.785    19.183     0.200
     2.599    17.237     0.200
     2.625    17.634     0.200
     3.125    23.191     0.200
     2.826    19.446     0.200
     2.524    16.712     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.544    11.653     0.200
     2.495    15.553     0.200
     2.583    16.026     0.200
     0.180     2.659     0.200
     0.250     3.242     0.200
     0.168     5.564     0.200
     0.556     5.226     0.200
     0.977     7.341     0.200
     0.168     3.433     0.200
     1.533    10.066     0.200
     0.154     4.619     0.200
     0.397     5.171     0.200
     0.424     5.273     0.200
     0.682     5.892     0.200
     1.012     7.324     0.200
     0.274     3.750     0.200
     0.677     5.484     0.200
     1.138     8.148     0.200
     1.270     8.913     0.200
     1.646    10.026     0.200
     2.423    16.595     0.200
     2.806    16.423     0.200
     3.245    15.880     0.200
     0.865     6.597     0.200
     0.865     6.765     0.200
     1.023     6.923     0.200
     2.617    14.533     0.200
     0.274     5.199     0.200
     1.011     6.574     0.200
     1.185     7.884     0.200
     0.168     2.639     0.200
     0.242     2.948     0.200
     1.019     6.516     0.200
     1.287     7.990     0.200
     2.467    14.187     0.200
     2.850    17.139     0.200
     0.594     5.464     0.200
     0.997     6.832     0.200
     1.181     7.602     0.200
     1.217     8.361     0.200
     2.554    15.500     0.200
     4.296    23.172     0.200
     0.358     3.994     0.200
     0.754     5.980     0.200
     0.240     3.986     0.200
     0.642     5.522     0.200
     1.124     7.851     0.200
     1.286     9.016     0.200
     1.441     9.368     0.200
     1.594     9.907     0.200
     0.215     3.494     0.200
     0.285     3.656     0.200
     1.646     9.678     0.200
     1.674    10.013     0.200
     2.654    14.756     0.200
     3.616    19.671     0.200
     3.972    22.053     0.200
     0.626     6.501     0.200
     0.553     4.792     0.200
     1.187     8.389     0.200
     1.422     9.574     0.200
     1.422     9.691     0.200
     1.627     9.347     0.200
     1.958    10.687     0.200
     2.148    11.812     0.200
     2.180    11.608     0.200
     2.220    11.947     0.200
     3.004    17.206     0.200
     3.161    19.603     0.200
     3.221    17.183     0.200
     3.990    20.016     0.200
     0.294     4.497     0.200
     0.372     4.017     0.200
     0.419     4.188     0.200
     0.929     7.001     0.200
     1.189     8.538     0.200
     1.189     8.407     0.200
     1.222     8.121     0.200
     1.295     8.086     0.200
     2.610    13.591     0.200
     2.595    15.699     0.200
     4.087    22.004     0.200
     0.190     3.370     0.200
     0.167     3.476     0.200
     0.249     3.741     0.200
     0.592     4.958     0.200
     0.811     5.929     0.200
     2.156    13.393     0.200
     2.687    17.327     0.200
     2.969    18.346     0.200
     3.107    17.775     0.200
     3.456    18.043     0.200
     3.965    22.546     0.200
     0.871     7.229     0.200
     0.824     6.821     0.200
     1.197     8.713     0.200
     1.197     8.956     0.200
     1.327     8.748     0.200
     1.453    10.407     0.200
     1.482    10.724     0.200
     2.536    15.251     0.200
     2.857    17.041     0.200
     2.871    16.803     0.200
     3.131    17.938     0.200
     3.363    18.517     0.200
     3.607    20.220     0.200
     4.443    23.152     0.200
     0.110     5.134     0.200
     0.323     4.928     0.200
     0.698     5.841     0.200
     0.726     5.766     0.200
     0.807     5.813     0.200
     0.819     5.979     0.200
     0.957     6.312     0.200
     0.991     6.788     0.200
     1.393     8.456     0.200
     1.596     8.854     0.200
     1.735    10.090     0.200
     2.445    12.689     0.200
     3.690    17.918     0.200
     3.731    19.007     0.200
     3.829    19.618     0.200
     4.508    22.484     0.200
     0.421     4.426     0.200
     0.455     4.367     0.200
     0.858     6.614     0.200
     1.075     7.556     0.200
     1.268     8.824     0.200
     1.427    10.269     0.200
     1.724    10.742     0.200
     1.731    11.823     0.200
     1.780    11.148     0.200
     2.328    13.345     0.200
     2.544    15.110     0.200
     2.619    14.158     0.200
     2.670    14.737     0.200
     2.694    14.581     0.200
     2.809    14.816     0.200
     2.839    15.302     0.200
     3.172    18.194     0.200
     3.326    17.766     0.200
     3.420    17.448     0.200
     3.420    17.639     0.200
     4.129    25.560     0.200
     4.902    29.729     0.200
     0.231     4.887     0.200
     0.342     4.683     0.200
     0.360     4.997     0.200
     0.366     4.647     0.200
     0.438     5.077     0.200
     0.853     6.114     0.200
     1.186     7.482     0.200
     1.316     8.033     0.200
     1.378     8.230     0.200
     1.488     8.938     0.200
     1.708     9.844     0.200
     2.193    13.091     0.200
     2.193    12.087     0.200
     2.243    13.687     0.200
     2.288    13.449     0.200
     2.322    14.338     0.200
     2.321    11.945     0.200
     2.430    12.668     0.200
     2.468    13.396     0.200
     2.500    14.901     0.200
     2.560    14.262     0.200
     2.569    14.417     0.200
     2.693    15.779     0.200
     2.860    14.414     0.200
     4.079    19.650     0.200
     4.098    21.185     0.200
     0.226     3.485     0.200
     0.334     3.923     0.200
     0.513     5.038     0.200
     0.579     5.278     0.200
     0.753     6.146     0.200
     1.036     6.417     0.200
     1.294     8.743     0.200
     1.398     8.908     0.200
     2.031    12.460     0.200
     2.817    17.157     0.200
     0.019     6.430     0.200
     0.255     4.923     0.200
     0.616     5.690     0.200
     0.735     5.784     0.200
     0.047     6.030     0.200
     0.268     5.062     0.200
     0.617     5.435     0.200
     0.560     5.352     0.200
     0.734     5.826     0.200
     0.865     6.523     0.200
     1.017     7.245     0.200
     3.283    17.788     0.200
     3.698    21.322     0.200
     0.258     4.758     0.200
     0.319     4.956     0.200
     0.387     5.102     0.200
     0.391     4.540     0.200
     0.850     6.753     0.200
     0.957     6.387     0.200
     1.151     7.274     0.200
     1.319     7.946     0.200
     1.333     8.372     0.200
     1.449     8.674     0.200
     2.196    11.292     0.200
     2.201    11.605     0.200
     2.295    12.389     0.200
     2.298    12.714     0.200
     2.402    15.168     0.200
     2.437    13.179     0.200
     2.490    13.727     0.200
     0.283     3.813     0.200
     0.536     4.905     0.200
     0.630     6.163     0.200
     0.758     5.791     0.200
     1.162     7.894     0.200
     1.197     8.486     0.200
     3.418    19.296     0.200
     4.223    21.861     0.200
     5.092    32.072     0.200
     0.170     5.257     0.200
     0.210     5.129     0.200
     0.207     5.113     0.200
     0.390     5.362     0.200
     0.562     5.747     0.200
     0.778     6.023     0.200
     0.872     6.282     0.200
     1.280     7.840     0.200
     1.326     8.157     0.200
     1.619     9.310     0.200
     1.899    11.044     0.200
     2.222    12.724     0.200
     2.235    11.886     0.200
     2.245    12.873     0.200
     2.334    13.660     0.200
     2.461    12.873     0.200
     0.270     4.064     0.200
     2.816    16.516     0.200
     0.239     4.445     0.200
     0.256     4.707     0.200
     0.379     4.367     0.200
     0.528     4.970     0.200
     0.828     5.936     0.200
     0.816     7.051     0.200
     1.199     8.153     0.200
     1.212     8.091     0.200
     1.325     8.815     0.200
     1.421     9.115     0.200
     1.835    10.193     0.200
     1.839    11.465     0.200
     2.126    11.095     0.200
     2.134    11.591     0.200
     2.273    15.237     0.200
     2.273    12.263     0.200
     2.406    13.071     0.200
     2.542    15.357     0.200
     2.602    15.123     0.200
     2.774    14.188     0.200
     2.806    13.970     0.200
     2.819    15.853     0.200
     2.815    14.462     0.200
     3.579    18.435     0.200
     4.171    20.802     0.200
     0.169     3.958     0.200
     0.435     4.762     0.200
     0.885     6.867     0.200
     1.180     8.026     0.200
     1.419     9.127     0.200
     2.488    14.304     0.200
     2.636    15.491     0.200
     2.702    15.873     0.200
     3.195    17.686     0.200
     0.367     4.728     0.200
     0.859     6.282     0.200
     1.564    10.068     0.200
     2.533    14.528     0.200
     2.612    14.892     0.200
     2.648    14.186     0.200
     2.687    15.829     0.200
     3.046    18.021     0.200
     3.090    17.747     0.200
     4.033    19.682     0.200
     4.812    24.642     0.200
     0.302     3.705     0.200
     0.519     4.738     0.200
     0.988     8.236     0.200
     1.269     8.829     0.200
     1.304     8.353     0.200
     2.275    13.959     0.200
     2.573    14.513     0.200
     2.617    15.332     0.200
     2.670    14.166     0.200
     2.707    14.779     0.200
     2.720    15.961     0.200
     2.776    16.994     0.200
     2.784    16.708     0.200
     2.859    14.802     0.200
     3.061    16.386     0.200
     3.218    17.630     0.200
     3.211    17.541     0.200
     3.307    18.416     0.200
     3.305    17.766     0.200
     3.324    20.870     0.200
     4.121    20.466     0.200
     0.288     3.905     0.200
     0.770     5.773     0.200
     1.076     7.064     0.200
     1.076     7.394     0.200
     1.076     6.954     0.200
     1.303     7.962     0.200
     2.811    17.721     0.200
     3.748    22.308     0.200
     4.778    27.357     0.200
     0.103     3.802     0.200
     0.291     4.276     0.200
     0.651     4.836     0.200
     0.724     5.908     0.200
     2.643    15.075     0.200
     4.935    24.975     0.200
     0.293     4.263     0.200
     1.459     9.119     0.200
     1.459     9.310     0.200
     2.595    13.462     0.200
     2.617    13.877     0.200
     2.617    15.806     0.200
     3.052    16.058     0.200
     3.274    18.837     0.200
     3.274    18.178     0.200
     0.260     4.256     0.200
     1.426     9.252     0.200
     1.504     9.846     0.200
     1.548     9.292     0.200
     2.054    12.043     0.200
     2.350    13.526     0.200
     2.390    13.008     0.200
     2.400    13.078     0.200
     2.552    13.502     0.200
     2.552    13.599     0.200
     2.629    14.871     0.200
     3.047    18.461     0.200
     3.224    16.402     0.200
     0.100     4.715     0.200
     0.110     4.463     0.200
     0.541     5.300     0.200
     0.591     5.356     0.200
     0.742     6.143     0.200
     1.401     9.476     0.200
     1.469     9.850     0.200
     2.632    14.318     0.200
     2.944    16.510     0.200
     2.963    16.770     0.200
     0.137     2.346     0.200
     0.150     2.630     0.200
     0.459     3.846     0.200
     0.634     4.871     0.200
     0.707     6.053     0.200
     0.873     6.093     0.200
     1.324     8.747     0.200
     1.940    12.442     0.200
     2.042    12.498     0.200
     2.148    14.211     0.200
     2.155    13.163     0.200
     2.200    13.475     0.200
     2.219    14.489     0.200
     2.222    13.900     0.200
     2.250    13.889     0.200
     2.252    15.749     0.200
     2.256    13.557     0.200
     2.261    13.084     0.200
     2.270    15.897     0.200
     2.366    15.098     0.200
     2.366    14.649     0.200
     2.397    16.157     0.200
     2.554    16.369     0.200
     2.597    16.187     0.200
     2.685    16.998     0.200
     0.303     3.793     0.200
     0.515     4.691     0.200
     0.739     5.969     0.200
     1.172     8.119     0.200
     1.226     8.450     0.200
     2.204    12.441     0.200
     2.624    16.715     0.200
     2.724    15.832     0.200
     2.772    17.068     0.200
     2.983    16.017     0.200
     3.127    19.058     0.200
     3.179    18.186     0.200
     3.179    17.287     0.200
     0.264     5.054     0.200
     1.378     8.415     0.200
     1.378     8.595     0.200
     2.625    16.614     0.200
     2.749    17.394     0.200
     3.573    19.334     0.200
     3.574    19.324     0.200
     5.089    31.298     0.200
     6.027    33.192     0.200
     6.205    32.486     0.200
     0.237     4.188     0.200
     0.424     4.822     0.200
     0.464     4.891     0.200
     1.586     9.224     0.200
     1.586     9.552     0.200
     1.584     9.489     0.200
     1.702     9.860     0.200
     2.563    13.109     0.200
     2.948    15.918     0.200
     4.970    27.722     0.200
     0.275     4.696     0.200
     0.341     4.581     0.200
     0.499     4.753     0.200
     0.850     6.104     0.200
     0.845     6.030     0.200
     1.325     7.845     0.200
     1.364     8.954     0.200
     1.364     8.552     0.200
     1.871    10.455     0.200
     2.163    11.869     0.200
     2.201    11.756     0.200
     2.218    12.401     0.200
     2.272    12.992     0.200
     2.277    13.264     0.200
     2.307    14.175     0.200
     2.309    13.473     0.200
     2.334    14.181     0.200
     2.352    13.723     0.200
     2.356    12.326     0.200
     2.373    13.746     0.200
     2.440    13.386     0.200
     2.449    13.691     0.200
     2.489    15.666     0.200
     2.575    13.760     0.200
     2.815    15.847     0.200
     2.850    13.941     0.200
     2.844    15.781     0.200
     0.252     4.492     0.200
     0.415     4.744     0.200
     0.479     4.954     0.200
     0.905     7.163     0.200
     1.114     7.144     0.200
     1.408     8.916     0.200
     1.578     9.410     0.200
     1.920    10.675     0.200
     2.224    15.443     0.200
     2.410    12.504     0.200
     2.516    14.555     0.200
     2.568    13.907     0.200
     2.568    13.519     0.200
     2.567    13.979     0.200
     2.595    13.651     0.200
     2.634    14.063     0.200
     2.973    16.980     0.200
     3.115    18.584     0.200
     0.331     4.181     0.200
     0.788     6.347     0.200
     1.003     7.142     0.200
     1.210     7.905     0.200
     1.244     8.111     0.200
     0.210     5.117     0.200
     0.209     5.062     0.200
     0.589     5.794     0.200
     0.879     6.727     0.200
     1.029     6.907     0.200
     1.160     7.142     0.200
     1.322     8.339     0.200
     1.514     8.526     0.200
     1.606     9.315     0.200
     2.082    11.149     0.200
     2.176    11.424     0.200
     2.192    11.414     0.200
     2.363    12.475     0.200
     2.427    13.564     0.200
     2.581    13.056     0.200
     2.853    15.385     0.200
     0.289     2.980     0.200
     0.307     3.043     0.200
     0.465     3.546     0.200
     0.869     6.600     0.200
     1.380     8.022     0.200
     1.935    11.769     0.200
     2.109    12.455     0.200
     2.210    12.896     0.200
     2.196    12.614     0.200
     2.257    13.173     0.200
     2.270    13.355     0.200
     2.309    14.133     0.200
     2.330    13.643     0.200
     2.331    15.085     0.200
     2.353    13.299     0.200
     2.361    14.433     0.200
     2.351    13.797     0.200
     2.327    14.549     0.200
     2.404    16.079     0.200
     2.413    13.747     0.200
     2.427    15.409     0.200
     2.495    13.726     0.200
     2.630    16.110     0.200
     2.672    16.854     0.200
     2.835    15.948     0.200
     2.888    15.549     0.200
     2.907    18.683     0.200
     2.909    18.198     0.200
     3.439    20.805     0.200
     3.771    23.695     0.200
     3.815    23.003     0.200
     4.355    21.947     0.200
     0.148     5.086     0.200
     0.181     4.996     0.200
     0.635     5.535     0.200
     0.935     6.937     0.200
     1.047     7.097     0.200
     1.372     8.062     0.200
     1.571     9.104     0.200
     1.668     9.224     0.200
     2.399    13.076     0.200
     2.584    15.343     0.200
     0.228     5.172     0.200
     0.309     5.114     0.200
     0.480     5.312     0.200
     0.844     6.736     0.200
     1.051     6.605     0.200
     1.080     7.271     0.200
     1.302     8.409     0.200
     1.410     8.323     0.200
     1.512     8.713     0.200
     1.825     9.675     0.200
     2.173    11.467     0.200
     2.253    11.782     0.200
     2.544    13.173     0.200
     2.652    12.946     0.200
     0.364     3.233     0.200
     0.481     3.242     0.200
     1.037     7.020     0.200
     1.300     9.341     0.200
     1.765    11.785     0.200
     1.866    12.710     0.200
     1.896    12.376     0.200
     2.026    12.657     0.200
     2.302    14.435     0.200
     2.312    15.701     0.200
     2.546    15.951     0.200
     2.547    14.697     0.200
     2.610    15.163     0.200
     2.753    16.356     0.200
     2.759    16.441     0.200
     2.831    17.867     0.200
     3.260    17.520     0.200
     0.307     4.908     0.200
     0.375     4.949     0.200
     0.499     5.332     0.200
     0.769     6.279     0.200
     1.149     7.519     0.200
     1.244     8.220     0.200
     1.332     8.248     0.200
     1.788     9.923     0.200
     2.079    11.703     0.200
     2.120    11.872     0.200
     2.136    11.316     0.200
     2.165    11.224     0.200
     2.195    12.153     0.200
     2.225    11.702     0.200
     2.226    12.025     0.200
     2.268    12.509     0.200
     2.761    13.475     0.200
     0.420     4.206     0.200
     0.492     3.910     0.200
     0.900     5.910     0.200
     1.131     7.869     0.200
     1.412     8.491     0.200
     1.429     8.714     0.200
     1.585     9.987     0.200
     1.585     9.245     0.200
     1.604     9.725     0.200
     2.144    13.125     0.200
     2.427    13.450     0.200
     2.481    14.222     0.200
     2.492    12.991     0.200
     2.554    14.472     0.200
     2.613    13.888     0.200
     2.629    14.858     0.200
     2.638    16.641     0.200
     2.650    14.297     0.200
     2.720    14.893     0.200
     2.854    15.065     0.200
     3.178    16.095     0.200
     0.363     4.386     0.200
     1.049     6.907     0.200
     3.592    18.389     0.200
     1.326     8.942     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,green << EOF
    20.830   277.089     0.200
    24.130   308.917     0.200
     1.512    29.732     0.200
     2.425    42.052     0.200
     2.492    42.789     0.200
     2.665    44.777     0.200
     2.759    46.415     0.200
     2.878    48.344     0.200
     2.903    49.076     0.200
     3.215    52.321     0.200
     3.224    53.989     0.200
     4.010    62.644     0.200
     4.192    63.729     0.200
     5.510    88.364     0.200
     7.657   112.714     0.200
     7.810   116.971     0.200
     0.308    11.081     0.200
     0.729    14.705     0.200
     0.979    18.125     0.200
     2.435    40.508     0.200
     2.495    40.676     0.200
     2.495    43.378     0.200
     3.612    57.822     0.200
     4.851    73.951     0.200
     1.163    20.535     0.200
     2.252    36.994     0.200
     2.284    36.878     0.200
     2.479    40.219     0.200
     2.511    41.256     0.200
     2.590    42.283     0.200
     3.064    50.050     0.200
     3.077    45.337     0.200
     3.308    51.131     0.200
     3.432    53.030     0.200
     4.287    63.406     0.200
     4.469    67.514     0.200
     5.030    72.267     0.200
     5.198    76.259     0.200
     5.513    84.887     0.200
     5.683    81.951     0.200
     7.894   110.975     0.200
     8.259   121.227     0.200
     8.862   124.897     0.200
    19.760   258.911     0.200
     0.158     9.586     0.200
     0.969    19.955     0.200
     1.181    22.394     0.200
     1.407    26.243     0.200
     2.025    35.101     0.200
     2.233    35.304     0.200
     2.283    37.998     0.200
     2.369    41.875     0.200
     2.444    40.788     0.200
     2.464    40.185     0.200
     2.508    42.556     0.200
     2.602    41.856     0.200
     3.051    47.566     0.200
     3.095    47.406     0.200
     3.307    51.546     0.200
     3.414    51.493     0.200
     3.423    50.167     0.200
     4.268    61.696     0.200
     5.049    74.518     0.200
     5.181    71.927     0.200
     5.181    75.228     0.200
    11.783   159.674     0.200
    19.745   259.769     0.200
    22.254   285.788     0.200
     1.064    22.209     0.200
     1.987    33.404     0.200
     2.523    41.717     0.200
     2.780    45.715     0.200
     2.926    47.607     0.200
     3.236    51.779     0.200
     3.351    52.671     0.200
     4.454    71.932     0.200
     1.318    23.202     0.200
     1.671    29.133     0.200
     2.143    34.506     0.200
     2.498    40.727     0.200
     2.559    41.871     0.200
     2.644    43.514     0.200
     2.682    44.628     0.200
     2.843    46.433     0.200
     2.892    45.960     0.200
     2.910    46.768     0.200
     2.946    47.332     0.200
     3.025    47.140     0.200
     3.071    49.171     0.200
     3.185    49.803     0.200
     3.217    48.956     0.200
     3.418    52.405     0.200
     3.427    51.774     0.200
     3.593    56.228     0.200
     4.170    62.180     0.200
     4.178    61.951     0.200
     5.186    70.276     0.200
     5.186    76.309     0.200
     5.198    75.812     0.200
     5.748    82.303     0.200
     6.219    89.126     0.200
     8.000   113.326     0.200
    11.873   154.251     0.200
    11.873   159.281     0.200
     1.939    32.446     0.200
     3.412    53.802     0.200
     3.854    57.654     0.200
     4.487    64.144     0.200
     4.607    69.192     0.200
     4.763    69.702     0.200
     5.805    84.144     0.200
     6.175    90.858     0.200
     6.240    89.750     0.200
    11.206   147.534     0.200
     0.294    11.583     0.200
     0.584    13.781     0.200
     1.350    24.553     0.200
     1.625    27.181     0.200
     1.799    29.535     0.200
     1.846    31.622     0.200
     1.916    32.444     0.200
     2.123    35.568     0.200
     2.193    36.957     0.200
     2.397    39.285     0.200
     2.539    41.000     0.200
     2.638    42.785     0.200
     2.791    43.403     0.200
     2.798    42.531     0.200
     3.654    53.518     0.200
     3.709    54.289     0.200
     4.434    64.687     0.200
     4.567    67.044     0.200
     4.567    66.130     0.200
     4.601    67.075     0.200
     6.053    86.297     0.200
     6.273    89.517     0.200
     6.264    89.121     0.200
     7.254   103.146     0.200
     7.767   109.947     0.200
    11.229   152.179     0.200
     1.138    23.769     0.200
     1.270    25.745     0.200
     1.948    31.762     0.200
     4.219    62.262     0.200
     4.541    69.151     0.200
     6.572   101.006     0.200
    11.290   149.162     0.200
    11.290   152.373     0.200
    13.637   180.907     0.200
    15.269   202.086     0.200
     1.429    25.232     0.200
     2.139    34.496     0.200
     2.143    36.047     0.200
     2.318    38.338     0.200
     2.487    40.454     0.200
     2.617    43.103     0.200
     2.694    39.356     0.200
     2.756    42.843     0.200
     3.713    56.858     0.200
     3.768    55.817     0.200
     4.607    65.477     0.200
     5.500    78.398     0.200
     6.546    91.510     0.200
    10.576   140.018     0.200
    10.576   140.784     0.200
    13.444   179.987     0.200
    14.548   194.548     0.200
     0.650    15.089     0.200
     1.332    24.077     0.200
     1.505    26.238     0.200
     1.910    32.161     0.200
     2.008    34.103     0.200
     2.751    43.263     0.200
     3.139    46.618     0.200
     4.158    63.159     0.200
     6.246    84.458     0.200
     6.216    89.421     0.200
    11.236   148.055     0.200
     1.488    28.306     0.200
     1.562    29.449     0.200
     2.021    34.878     0.200
     1.985    34.978     0.200
     2.087    36.739     0.200
     2.296    39.001     0.200
     2.603    43.048     0.200
     2.735    44.855     0.200
     1.217    23.861     0.200
     1.217    23.622     0.200
     1.353    25.514     0.200
     1.935    32.345     0.200
     2.269    37.182     0.200
     2.273    38.905     0.200
     2.542    42.436     0.200
     2.727    45.845     0.200
     3.212    46.790     0.200
     3.537    55.510     0.200
     4.174    64.703     0.200
     4.179    62.648     0.200
     4.969    73.977     0.200
     2.020    34.911     0.200
     2.020    33.403     0.200
     4.124    66.296     0.200
     4.442    68.514     0.200
    11.187   152.772     0.200
     1.914    32.984     0.200
     1.914    30.765     0.200
     2.805    45.316     0.200
     4.570    68.031     0.200
     9.015   120.697     0.200
    11.315   151.006     0.200
     1.937    33.132     0.200
     5.001    70.089     0.200
    11.719   163.089     0.200
     0.292    12.291     0.200
     0.292    12.151     0.200
     0.397    12.471     0.200
     0.397    12.291     0.200
     0.827    17.016     0.200
     0.791    16.873     0.200
     1.197    22.635     0.200
     1.268    23.508     0.200
     1.268    24.492     0.200
     1.400    23.267     0.200
     1.839    28.886     0.200
     1.816    33.160     0.200
     2.019    34.099     0.200
     3.494    51.220     0.200
    12.601   173.400     0.200
     1.621    27.698     0.200
     1.822    29.047     0.200
     3.662    53.008     0.200
     3.729    56.743     0.200
     3.990    63.345     0.200
     4.438    71.707     0.200
     4.704    67.863     0.200
     6.318    92.978     0.200
     0.087    10.254     0.200
     0.087    10.121     0.200
     0.514    13.065     0.200
     0.863    16.704     0.200
     1.062    19.581     0.200
     1.062    20.901     0.200
     1.217    22.705     0.200
     1.338    23.978     0.200
     1.345    23.459     0.200
     1.675    27.692     0.200
     1.743    28.740     0.200
     1.896    30.804     0.200
     1.896    32.804     0.200
     1.990    32.922     0.200
     2.251    36.608     0.200
     2.364    43.508     0.200
     2.742    47.495     0.200
     3.286    49.627     0.200
     3.655    56.040     0.200
     3.683    55.725     0.200
     3.969    59.014     0.200
     4.314    63.409     0.200
     4.394    64.704     0.200
     4.554    66.857     0.200
     5.481    80.323     0.200
     5.598    80.007     0.200
     0.406    11.827     0.200
     0.697    15.940     0.200
     0.710    15.750     0.200
     0.920    18.652     0.200
     0.924    19.485     0.200
     1.152    24.176     0.200
     1.286    22.488     0.200
     1.392    27.861     0.200
     1.948    32.535     0.200
     1.917    34.310     0.200
     2.078    35.303     0.200
     2.112    35.419     0.200
     2.097    36.665     0.200
     2.117    37.424     0.200
     2.675    39.590     0.200
     3.345    51.240     0.200
     3.469    54.823     0.200
     3.872    56.371     0.200
     3.878    62.459     0.200
     4.422    65.283     0.200
     4.435    66.378     0.200
     5.019    78.267     0.200
     5.049    76.762     0.200
     5.561    82.757     0.200
     5.617    78.214     0.200
     7.640   103.537     0.200
     7.935   110.101     0.200
     8.364   114.500     0.200
     9.394   132.487     0.200
    10.070   138.565     0.200
    10.969   147.368     0.200
    13.836   187.985     0.200
    19.154   255.453     0.200
    19.545   258.038     0.200
    20.516   270.135     0.200
    20.696   269.116     0.200
    21.518   277.827     0.200
    21.520   275.362     0.200
    21.572   277.853     0.200
    22.023   281.960     0.200
    22.040   280.781     0.200
    22.040   282.670     0.200
     0.302    12.559     0.200
     0.423    13.748     0.200
     0.633    14.826     0.200
     0.862    16.994     0.200
     0.865    17.269     0.200
     0.986    19.918     0.200
     1.091    20.524     0.200
     1.119    20.391     0.200
     1.157    22.967     0.200
     1.257    22.992     0.200
     1.277    23.106     0.200
     1.455    25.314     0.200
     1.603    25.526     0.200
     1.933    31.053     0.200
     1.970    31.973     0.200
     2.017    32.481     0.200
     2.400    36.288     0.200
     2.675    39.729     0.200
     3.701    54.202     0.200
     8.200   110.530     0.200
     0.101    11.843     0.200
     0.370    12.627     0.200
     0.540    13.890     0.200
     0.672    14.816     0.200
     0.840    17.168     0.200
     0.904    18.657     0.200
     1.304    23.535     0.200
     1.405    25.476     0.200
     1.595    27.628     0.200
     1.728    29.344     0.200
     1.832    30.539     0.200
     1.839    31.301     0.200
     1.887    29.592     0.200
     1.866    32.990     0.200
     1.947    31.998     0.200
     2.152    36.123     0.200
     2.191    38.235     0.200
     2.200    35.457     0.200
     2.282    41.299     0.200
     2.287    38.277     0.200
     2.390    40.331     0.200
     2.558    37.731     0.200
     3.566    49.035     0.200
     3.566    49.206     0.200
     3.648    52.521     0.200
     3.797    52.140     0.200
     4.442    65.759     0.200
     4.478    63.728     0.200
     4.615    65.682     0.200
     0.291    11.703     0.200
     0.288    11.687     0.200
     0.371    12.093     0.200
     0.251    11.587     0.200
     0.401    12.308     0.200
     0.939    18.852     0.200
     1.182    21.623     0.200
     1.329    25.221     0.200
     1.346    25.381     0.200
     1.453    26.077     0.200
     1.543    29.109     0.200
     1.457    26.633     0.200
     1.457    26.984     0.200
     1.766    31.956     0.200
     1.903    34.210     0.200
     2.162    35.133     0.200
     2.226    37.746     0.200
     2.223    37.039     0.200
     2.276    34.900     0.200
     2.371    42.493     0.200
     2.383    39.453     0.200
     2.620    44.694     0.200
     4.068    59.656     0.200
     4.912    69.919     0.200
     1.189    22.688     0.200
     1.222    23.972     0.200
     1.295    26.406     0.200
     1.675    29.700     0.200
     1.686    29.220     0.200
     1.724    29.727     0.200
     2.617    42.532     0.200
     2.754    42.838     0.200
     3.280    54.047     0.200
     4.047    56.227     0.200
     4.736    76.400     0.200
     4.832    75.667     0.200
     4.853    75.816     0.200
     4.889    74.928     0.200
     4.966    74.118     0.200
     6.468    99.349     0.200
     8.148   119.601     0.200
     0.171    10.998     0.200
     0.204    10.809     0.200
     0.463    12.853     0.200
     0.484    12.986     0.200
     0.576    13.878     0.200
     0.911    18.091     0.200
     1.069    20.535     0.200
     1.253    22.512     0.200
     1.357    24.490     0.200
     1.515    26.927     0.200
     1.616    27.662     0.200
     1.683    29.769     0.200
     1.687    29.491     0.200
     1.867    31.643     0.200
     1.973    32.058     0.200
     2.107    33.892     0.200
     2.122    36.394     0.200
     2.163    34.642     0.200
     2.214    35.488     0.200
     2.215    37.545     0.200
     2.229    36.173     0.200
     2.283    38.504     0.200
     2.345    37.223     0.200
     2.343    38.266     0.200
     2.386    38.337     0.200
     2.399    39.794     0.200
     2.458    39.615     0.200
     2.500    39.173     0.200
     2.521    41.188     0.200
     2.560    39.108     0.200
     2.582    39.726     0.200
     2.590    41.737     0.200
     2.619    40.935     0.200
     2.771    43.860     0.200
     2.816    47.275     0.200
     2.889    45.490     0.200
     2.975    46.313     0.200
     3.166    47.285     0.200
     3.183    46.402     0.200
     3.336    49.541     0.200
     3.836    59.064     0.200
     3.857    57.752     0.200
     3.920    58.978     0.200
     3.925    58.723     0.200
     3.932    60.695     0.200
     3.953    60.970     0.200
     3.995    59.143     0.200
     4.197    56.679     0.200
     4.245    61.110     0.200
     5.102    70.590     0.200
     0.477    13.789     0.200
     0.664    16.059     0.200
     1.110    20.713     0.200
     1.275    23.752     0.200
     1.275    22.372     0.200
     1.397    25.300     0.200
     1.399    25.199     0.200
     1.379    25.055     0.200
     1.519    27.339     0.200
     1.690    27.587     0.200
     1.801    30.819     0.200
     1.724    30.021     0.200
     1.930    32.246     0.200
     1.920    33.684     0.200
     1.960    32.115     0.200
     2.047    33.849     0.200
     2.135    36.046     0.200
     2.266    40.074     0.200
     2.263    41.037     0.200
     2.172    36.162     0.200
     2.286    38.985     0.200
     2.309    38.713     0.200
     2.299    37.263     0.200
     2.317    36.462     0.200
     2.317    36.458     0.200
     2.316    43.204     0.200
     2.362    37.394     0.200
     2.375    37.824     0.200
     2.375    37.023     0.200
     2.375    37.830     0.200
     2.375    39.959     0.200
     2.384    37.997     0.200
     2.411    39.774     0.200
     2.445    38.177     0.200
     2.505    40.070     0.200
     2.533    40.106     0.200
     2.548    41.683     0.200
     2.644    43.562     0.200
     2.690    39.836     0.200
     2.738    47.558     0.200
     2.710    39.268     0.200
     2.798    45.586     0.200
     2.907    45.463     0.200
     2.906    45.467     0.200
     2.915    45.275     0.200
     2.976    43.089     0.200
     3.143    47.841     0.200
     3.148    50.445     0.200
     3.248    50.659     0.200
     3.347    56.199     0.200
     3.638    56.055     0.200
     3.730    58.315     0.200
     3.766    61.169     0.200
     3.726    51.194     0.200
     3.854    55.969     0.200
     4.174    61.783     0.200
     4.308    64.231     0.200
     4.392    63.717     0.200
     4.399    66.023     0.200
     4.419    69.133     0.200
     4.438    66.992     0.200
     4.469    64.027     0.200
     4.546    65.497     0.200
     4.684    70.476     0.200
     4.675    65.671     0.200
     4.675    66.944     0.200
     4.854    75.416     0.200
     5.226    77.010     0.200
     5.386    76.241     0.200
     5.513    82.179     0.200
     5.588    81.107     0.200
     6.030    87.579     0.200
     6.305    91.078     0.200
     6.369    94.427     0.200
     6.422    87.639     0.200
     7.486   103.696     0.200
     7.519   107.255     0.200
     7.609   104.208     0.200
     7.854   107.872     0.200
     9.560   135.023     0.200
     1.129    23.530     0.200
     1.145    22.073     0.200
     1.347    26.551     0.200
     1.571    26.901     0.200
     1.660    29.590     0.200
     1.864    32.206     0.200
     2.476    39.422     0.200
     2.491    37.072     0.200
     2.500    41.873     0.200
     2.500    41.870     0.200
     2.519    41.425     0.200
     2.584    39.901     0.200
     2.526    39.787     0.200
     2.574    42.819     0.200
     2.588    43.643     0.200
     2.588    43.636     0.200
     2.701    44.178     0.200
     2.747    44.548     0.200
     2.760    46.461     0.200
     2.775    46.214     0.200
     2.849    46.897     0.200
     2.870    46.201     0.200
     2.869    46.205     0.200
     2.857    46.599     0.200
     2.969    47.116     0.200
     3.091    48.884     0.200
     3.107    51.693     0.200
     3.206    50.602     0.200
     3.456    53.601     0.200
     3.607    51.527     0.200
     3.562    56.595     0.200
     3.563    56.585     0.200
     3.775    58.497     0.200
     3.853    58.354     0.200
     3.933    62.953     0.200
     4.289    67.339     0.200
     4.473    64.783     0.200
     4.565    70.877     0.200
     4.569    69.222     0.200
     4.575    72.826     0.200
     4.597    64.162     0.200
     4.621    67.037     0.200
     4.635    66.842     0.200
     4.635    70.494     0.200
     4.707    71.433     0.200
     4.718    74.774     0.200
     4.842    73.660     0.200
     5.355    83.172     0.200
     5.378    85.436     0.200
     5.743    81.662     0.200
     6.226    93.092     0.200
     6.277    97.331     0.200
     6.316    93.264     0.200
     6.331    84.818     0.200
     6.536   100.278     0.200
     7.285   108.871     0.200
     7.384    99.275     0.200
     7.420   101.793     0.200
     7.507   105.144     0.200
     1.453    30.387     0.200
     1.482    28.947     0.200
     2.495    42.684     0.200
     2.752    47.037     0.200
     2.793    45.738     0.200
     2.871    46.655     0.200
     2.872    46.642     0.200
     3.131    51.587     0.200
     3.336    53.958     0.200
     3.607    59.361     0.200
     3.835    58.580     0.200
     3.834    58.590     0.200
     3.814    58.802     0.200
     3.953    64.784     0.200
     4.025    61.290     0.200
     4.509    66.506     0.200
     4.806    68.499     0.200
     4.758    72.760     0.200
     5.041    81.207     0.200
     5.204    80.529     0.200
     5.289    84.973     0.200
     5.301    84.083     0.200
     5.321    85.603     0.200
     5.340    84.627     0.200
     5.355    84.451     0.200
     5.675    90.697     0.200
     6.477    99.637     0.200
     6.588    98.474     0.200
     7.118   110.315     0.200
     8.420   124.401     0.200
     1.454    25.038     0.200
     1.861    31.904     0.200
     2.283    36.878     0.200
     2.407    36.170     0.200
     2.561    41.450     0.200
     2.572    40.685     0.200
     2.814    44.040     0.200
     3.134    48.026     0.200
     3.314    52.796     0.200
     3.427    48.880     0.200
     3.559    52.977     0.200
     3.712    56.448     0.200
     4.449    63.218     0.200
     4.870    68.923     0.200
     0.282    12.200     0.200
     0.353    12.616     0.200
     0.594    14.521     0.200
     0.649    15.467     0.200
     0.745    16.481     0.200
     0.771    15.884     0.200
     0.980    20.496     0.200
     1.118    21.433     0.200
     1.243    20.585     0.200
     1.228    23.363     0.200
     1.303    23.423     0.200
     1.582    29.041     0.200
     1.636    28.759     0.200
     1.647    28.275     0.200
     1.786    30.176     0.200
     1.808    30.631     0.200
     1.792    29.866     0.200
     1.803    31.142     0.200
     1.807    30.675     0.200
     1.892    33.026     0.200
     2.040    36.081     0.200
     2.103    36.397     0.200
     2.120    35.981     0.200
     2.129    36.703     0.200
     2.144    37.900     0.200
     2.142    38.367     0.200
     2.524    43.254     0.200
     2.643    42.957     0.200
     2.796    44.520     0.200
     3.588    56.865     0.200
     3.721    54.074     0.200
     4.563    65.297     0.200
     1.268    24.683     0.200
     1.245    23.983     0.200
     1.313    26.263     0.200
     1.427    29.158     0.200
     1.427    27.158     0.200
     1.724    30.253     0.200
     1.925    31.416     0.200
     1.971    34.482     0.200
     2.130    34.641     0.200
     2.328    38.885     0.200
     2.323    38.648     0.200
     2.594    41.776     0.200
     2.679    44.938     0.200
     3.347    50.848     0.200
     3.701    58.512     0.200
     3.657    59.353     0.200
     4.040    56.986     0.200
     4.129    65.901     0.200
     4.206    68.567     0.200
     4.437    70.400     0.200
     4.549    73.552     0.200
     4.652    67.957     0.200
     5.954    93.267     0.200
     6.079    85.147     0.200
     6.743   101.049     0.200
     7.164   107.411     0.200
     7.251   102.080     0.200
    11.197   148.396     0.200
     1.009    18.899     0.200
     1.391    24.177     0.200
     1.488    25.169     0.200
     2.027    31.400     0.200
     2.206    36.229     0.200
     2.289    38.511     0.200
     2.339    37.810     0.200
     2.442    39.632     0.200
     2.790    44.957     0.200
     3.009    48.327     0.200
     3.046    43.211     0.200
     3.967    60.721     0.200
     4.059    61.677     0.200
     4.206    64.033     0.200
     0.142    11.859     0.200
     0.281    11.946     0.200
     0.349    12.290     0.200
     0.576    14.014     0.200
     0.724    16.137     0.200
     0.762    16.903     0.200
     1.000    19.579     0.200
     1.133    20.403     0.200
     1.240    23.782     0.200
     1.235    23.599     0.200
     1.283    23.869     0.200
     1.560    26.204     0.200
     1.670    27.055     0.200
     1.650    27.992     0.200
     1.764    27.929     0.200
     1.793    32.034     0.200
     1.788    29.238     0.200
     1.794    32.975     0.200
     1.827    30.973     0.200
     1.907    31.307     0.200
     2.097    32.735     0.200
     2.121    35.047     0.200
     2.125    35.006     0.200
     2.135    35.190     0.200
     2.136    36.222     0.200
     2.142    36.448     0.200
     2.147    35.582     0.200
     2.207    36.416     0.200
     2.219    38.253     0.200
     2.240    34.706     0.200
     2.278    35.921     0.200
     2.336    36.033     0.200
     2.380    38.656     0.200
     2.477    40.609     0.200
     2.536    40.281     0.200
     2.687    38.891     0.200
     3.181    52.557     0.200
     3.502    52.277     0.200
     3.590    54.699     0.200
     3.672    51.036     0.200
     3.739    53.336     0.200
     4.583    64.896     0.200
     1.294    24.212     0.200
     1.398    25.119     0.200
     1.747    30.465     0.200
     1.900    32.780     0.200
     2.253    37.097     0.200
     2.359    39.582     0.200
     2.415    40.077     0.200
     2.597    40.073     0.200
     2.598    43.391     0.200
     2.567    42.122     0.200
     2.615    43.968     0.200
     2.669    40.697     0.200
     2.697    39.280     0.200
     2.675    43.023     0.200
     2.699    43.899     0.200
     2.710    45.035     0.200
     2.739    41.438     0.200
     2.755    43.808     0.200
     2.769    43.834     0.200
     2.768    45.517     0.200
     2.768    45.511     0.200
     2.782    45.059     0.200
     2.785    43.390     0.200
     2.755    45.068     0.200
     2.818    45.543     0.200
     2.850    44.238     0.200
     2.903    45.773     0.200
     2.922    46.600     0.200
     2.918    44.640     0.200
     2.978    48.700     0.200
     2.974    48.629     0.200
     3.041    49.519     0.200
     3.129    51.652     0.200
     3.121    44.900     0.200
     3.199    50.769     0.200
     3.262    51.997     0.200
     3.297    52.571     0.200
     3.426    53.965     0.200
     3.536    55.869     0.200
     3.536    55.873     0.200
     3.544    51.513     0.200
     3.564    52.514     0.200
     3.650    56.300     0.200
     3.651    56.290     0.200
     3.733    56.768     0.200
     3.861    55.674     0.200
     3.950    62.046     0.200
     3.979    61.640     0.200
     3.979    62.161     0.200
     3.984    56.493     0.200
     3.985    58.288     0.200
     4.001    62.035     0.200
     4.010    59.026     0.200
     4.028    61.781     0.200
     3.979    62.862     0.200
     4.084    58.750     0.200
     4.239    66.737     0.200
     4.261    61.738     0.200
     4.492    68.489     0.200
     4.582    72.583     0.200
     4.744    74.323     0.200
     4.740    70.463     0.200
     4.742    74.950     0.200
     4.971    75.689     0.200
     4.999    75.660     0.200
     5.108    76.120     0.200
     5.304    77.998     0.200
     5.317    78.538     0.200
     5.391    82.414     0.200
     5.572    82.474     0.200
     5.683    84.941     0.200
     5.719    86.081     0.200
     5.841    89.792     0.200
     6.019    88.430     0.200
     6.199    91.256     0.200
     6.270    87.750     0.200
     6.992   104.021     0.200
     8.439   117.761     0.200
     9.035   124.855     0.200
     9.355   128.699     0.200
    20.240   271.617     0.200
    20.532   271.867     0.200
    21.657   281.367     0.200
    21.708   283.129     0.200
     0.735    14.894     0.200
     1.240    22.119     0.200
     1.422    24.833     0.200
     1.450    24.863     0.200
     1.753    27.054     0.200
     1.672    29.120     0.200
     1.951    32.005     0.200
     2.053    33.081     0.200
     2.018    31.854     0.200
     2.107    32.923     0.200
     2.192    35.324     0.200
     2.236    35.526     0.200
     2.470    38.291     0.200
     2.514    41.358     0.200
     2.770    39.341     0.200
     2.842    44.522     0.200
     2.942    46.440     0.200
     3.018    44.840     0.200
     3.036    49.175     0.200
     3.484    53.716     0.200
     3.584    53.110     0.200
     3.791    52.206     0.200
     4.077    64.294     0.200
     4.824    67.901     0.200
     5.549    83.405     0.200
     6.033    88.529     0.200
     6.369    93.736     0.200
     6.505    89.620     0.200
     0.617    14.154     0.200
     0.560    13.813     0.200
     4.357    61.930     0.200
     0.220    11.046     0.200
     0.479    12.180     0.200
     0.606    14.039     0.200
     0.765    15.653     0.200
     0.828    17.858     0.200
     1.013    21.056     0.200
     1.141    21.336     0.200
     1.243    23.679     0.200
     1.291    24.013     0.200
     1.417    26.070     0.200
     1.468    26.384     0.200
     1.920    33.547     0.200
     2.026    32.567     0.200
     2.157    39.568     0.200
     2.168    37.745     0.200
     2.199    39.006     0.200
     2.240    40.430     0.200
     2.196    35.468     0.200
     3.029    42.835     0.200
     3.213    48.466     0.200
     3.174    48.647     0.200
     3.419    52.747     0.200
     3.720    57.490     0.200
     4.049    58.342     0.200
     4.337    61.839     0.200
     5.706    77.192     0.200
     0.394    13.787     0.200
     0.640    15.664     0.200
     0.788    17.528     0.200
     0.935    19.798     0.200
     1.071    20.744     0.200
     1.071    20.502     0.200
     1.182    23.062     0.200
     1.223    21.616     0.200
     1.311    24.470     0.200
     1.590    28.476     0.200
     1.616    28.986     0.200
     1.621    30.337     0.200
     1.763    29.882     0.200
     1.783    31.500     0.200
     1.763    30.095     0.200
     1.845    32.888     0.200
     1.825    30.714     0.200
     2.043    35.095     0.200
     2.077    35.175     0.200
     1.999    33.250     0.200
     2.101    36.071     0.200
     2.107    37.665     0.200
     2.108    37.662     0.200
     2.107    35.729     0.200
     2.126    35.733     0.200
     2.123    36.674     0.200
     2.189    38.802     0.200
     2.189    36.075     0.200
     2.204    37.397     0.200
     2.214    38.255     0.200
     2.216    36.304     0.200
     2.235    37.762     0.200
     2.258    39.495     0.200
     2.261    37.947     0.200
     2.287    37.517     0.200
     2.316    36.975     0.200
     2.339    36.271     0.200
     2.348    38.601     0.200
     2.250    41.351     0.200
     2.477    39.635     0.200
     2.597    43.799     0.200
     2.707    46.912     0.200
     2.752    41.956     0.200
     2.752    41.960     0.200
     2.761    39.448     0.200
     2.781    40.506     0.200
     2.927    45.869     0.200
     2.912    44.481     0.200
     3.047    51.333     0.200
     3.164    48.261     0.200
     3.163    48.272     0.200
     3.242    51.171     0.200
     3.675    54.300     0.200
     3.636    50.637     0.200
     3.731    55.741     0.200
     3.955    62.785     0.200
     4.365    64.209     0.200
     4.488    63.043     0.200
     4.427    64.048     0.200
     4.435    65.449     0.200
     4.443    65.791     0.200
     4.460    66.805     0.200
     4.480    65.576     0.200
     4.519    66.245     0.200
     4.519    61.839     0.200
     4.491    67.461     0.200
     4.543    63.490     0.200
     4.602    67.486     0.200
     4.706    73.151     0.200
     5.223    71.747     0.200
     5.299    73.119     0.200
     5.443    80.523     0.200
     5.657    80.892     0.200
     6.041    88.179     0.200
     6.303    85.128     0.200
     6.623    93.674     0.200
     7.214    98.024     0.200
     7.375    99.104     0.200
     7.406   102.138     0.200
     7.410   105.007     0.200
     8.210   112.731     0.200
    11.162   146.054     0.200
     0.089    10.882     0.200
     0.290    11.056     0.200
     0.662    15.052     0.200
     0.784    16.147     0.200
     0.840    18.332     0.200
     0.976    18.766     0.200
     1.046    20.350     0.200
     1.352    23.658     0.200
     1.391    26.047     0.200
     1.490    22.485     0.200
     1.612    29.505     0.200
     1.785    30.009     0.200
     1.839    32.098     0.200
     2.014    34.046     0.200
     2.215    38.724     0.200
     2.260    35.634     0.200
     2.372    39.493     0.200
     2.384    36.422     0.200
     2.384    39.191     0.200
     2.426    40.303     0.200
     2.436    41.188     0.200
     2.445    38.250     0.200
     2.548    39.973     0.200
     2.782    43.511     0.200
     3.716    56.667     0.200
     3.727    52.582     0.200
     3.748    58.644     0.200
     3.865    56.605     0.200
     4.423    60.460     0.200
     0.371    13.473     0.200
     0.413    12.571     0.200
     0.587    14.605     0.200
     0.647    15.208     0.200
     0.834    17.610     0.200
     0.989    19.514     0.200
     1.124    20.936     0.200
     1.183    22.062     0.200
     1.228    22.966     0.200
     1.358    24.899     0.200
     1.388    25.694     0.200
     1.453    27.286     0.200
     1.711    30.795     0.200
     1.753    30.653     0.200
     1.933    33.211     0.200
     1.934    30.980     0.200
     1.934    33.252     0.200
     1.971    31.590     0.200
     1.971    33.200     0.200
     1.996    33.708     0.200
     2.086    35.457     0.200
     2.090    36.733     0.200
     2.101    37.246     0.200
     2.122    34.521     0.200
     2.131    35.904     0.200
     2.142    35.596     0.200
     2.172    35.388     0.200
     2.209    38.111     0.200
     2.200    36.224     0.200
     2.203    36.765     0.200
     2.261    37.738     0.200
     2.329    38.238     0.200
     3.184    53.328     0.200
     4.945    72.557     0.200
     4.959    71.472     0.200
     0.850    18.542     0.200
     2.196    37.244     0.200
     2.222    37.176     0.200
     2.243    35.636     0.200
     2.362    37.672     0.200
     2.362    38.002     0.200
     2.393    40.066     0.200
     2.434    39.187     0.200
     2.508    41.435     0.200
     2.803    45.330     0.200
     2.829    43.885     0.200
     2.850    46.240     0.200
     3.150    50.151     0.200
     3.179    49.804     0.200
     3.258    50.938     0.200
     3.780    55.985     0.200
     4.008    53.586     0.200
     4.069    60.599     0.200
     4.110    64.328     0.200
     4.130    64.477     0.200
     4.182    62.934     0.200
     4.260    65.419     0.200
     4.695    72.659     0.200
     4.868    70.389     0.200
     4.939    74.129     0.200
     5.268    82.712     0.200
     5.621    79.384     0.200
     5.746    87.491     0.200
     6.618    96.942     0.200
     0.210    10.587     0.200
     0.226    10.560     0.200
     0.274    10.857     0.200
     0.331    11.304     0.200
     0.498    13.069     0.200
     0.873    18.716     0.200
     1.242    23.069     0.200
     1.349    23.123     0.200
     1.348    24.831     0.200
     1.378    25.361     0.200
     1.555    25.945     0.200
     1.861    29.096     0.200
     1.893    32.173     0.200
     1.934    34.682     0.200
     2.000    32.527     0.200
     2.224    38.540     0.200
     2.232    39.759     0.200
     2.241    38.821     0.200
     2.264    38.066     0.200
     2.276    40.269     0.200
     2.290    36.687     0.200
     2.292    36.608     0.200
     2.292    40.514     0.200
     2.294    39.487     0.200
     2.316    36.493     0.200
     2.314    42.489     0.200
     2.329    40.047     0.200
     2.329    40.575     0.200
     2.331    41.944     0.200
     2.356    40.722     0.200
     2.356    41.980     0.200
     2.375    40.045     0.200
     2.400    43.927     0.200
     2.463    40.633     0.200
     2.547    43.617     0.200
     2.650    45.671     0.200
     2.774    46.036     0.200
     2.832    48.939     0.200
     2.881    40.789     0.200
     3.023    51.729     0.200
     3.053    47.305     0.200
     3.054    47.302     0.200
     3.083    50.851     0.200
     3.062    45.623     0.200
     3.082    48.095     0.200
     3.776    56.799     0.200
     3.895    52.407     0.200
     3.984    57.163     0.200
     4.227    66.034     0.200
     4.265    65.892     0.200
     4.231    63.397     0.200
     4.377    65.628     0.200
     4.821    68.311     0.200
     6.163    93.331     0.200
     6.584    88.489     0.200
    11.470   152.181     0.200
     1.162    23.045     0.200
     1.197    24.445     0.200
     1.410    27.868     0.200
     1.603    27.207     0.200
     1.806    30.589     0.200
     1.992    34.049     0.200
     2.648    40.393     0.200
     2.741    45.406     0.200
     2.940    45.791     0.200
     2.940    45.788     0.200
     2.948    45.343     0.200
     2.968    47.445     0.200
     3.185    49.324     0.200
     3.418    55.114     0.200
     3.672    52.689     0.200
     3.715    52.902     0.200
     3.923    63.496     0.200
     3.977    59.826     0.200
     4.346    69.787     0.200
     4.547    66.913     0.200
     4.565    64.600     0.200
     4.566    67.914     0.200
     4.667    65.840     0.200
     4.705    73.531     0.200
     4.705    68.980     0.200
     4.786    69.686     0.200
     4.870    76.863     0.200
     5.321    75.501     0.200
     5.275    79.561     0.200
     5.686    84.629     0.200
     5.721    88.070     0.200
     6.182    95.339     0.200
     6.386    98.408     0.200
     6.398    93.719     0.200
     6.517    99.039     0.200
     7.355   107.679     0.200
     7.450   106.056     0.200
     7.486   106.114     0.200
     8.096   120.310     0.200
     9.501   131.818     0.200
     9.754   141.947     0.200
     1.797    28.736     0.200
     2.008    32.604     0.200
     2.729    44.071     0.200
     2.816    41.086     0.200
     2.852    46.352     0.200
     2.992    46.241     0.200
     3.926    56.694     0.200
     4.288    62.552     0.200
     4.308    63.713     0.200
     4.327    64.884     0.200
     4.439    65.914     0.200
     2.095    31.267     0.200
     2.493    41.008     0.200
     2.493    41.012     0.200
     3.121    43.947     0.200
     4.282    61.057     0.200
     4.239    59.620     0.200
     4.969    76.449     0.200
     6.535    98.096     0.200
     6.846   100.847     0.200
     6.907    99.760     0.200
     6.945    98.431     0.200
     6.970   104.210     0.200
     7.031    98.913     0.200
     1.421    25.316     0.200
     1.577    23.803     0.200
     1.835    31.373     0.200
     2.026    33.506     0.200
     2.128    31.968     0.200
     2.134    30.191     0.200
     2.177    30.965     0.200
     2.186    34.466     0.200
     2.206    31.531     0.200
     2.256    38.358     0.200
     2.254    36.296     0.200
     2.273    36.804     0.200
     2.321    33.845     0.200
     2.330    39.372     0.200
     2.602    39.013     0.200
     2.717    40.162     0.200
     2.806    39.698     0.200
     2.819    44.003     0.200
     2.850    44.309     0.200
     3.014    45.973     0.200
     3.043    47.826     0.200
     3.489    51.933     0.200
     3.579    57.707     0.200
     3.667    55.303     0.200
     3.715    56.579     0.200
     3.874    54.927     0.200
     3.938    58.476     0.200
     4.171    63.841     0.200
     4.252    63.816     0.200
     4.312    64.273     0.200
     4.539    72.427     0.200
     4.782    68.907     0.200
     0.297    11.153     0.200
     0.290    10.935     0.200
     0.397    11.756     0.200
     0.522    13.226     0.200
     0.760    16.667     0.200
     0.860    16.809     0.200
     1.156    22.939     0.200
     1.197    22.215     0.200
     1.559    26.569     0.200
     1.781    30.558     0.200
     1.813    30.361     0.200
     1.869    30.493     0.200
     1.822    30.967     0.200
     2.025    32.792     0.200
     2.082    34.001     0.200
     2.069    34.860     0.200
     2.080    34.602     0.200
     2.075    34.515     0.200
     2.111    34.776     0.200
     2.120    34.420     0.200
     2.129    34.970     0.200
     2.129    35.635     0.200
     2.151    34.795     0.200
     2.152    35.043     0.200
     2.176    36.548     0.200
     2.187    35.277     0.200
     2.204    35.471     0.200
     2.266    36.470     0.200
     2.282    36.608     0.200
     2.435    39.502     0.200
     2.485    39.973     0.200
     2.691    41.855     0.200
     2.752    42.736     0.200
     2.759    44.364     0.200
     2.760    43.405     0.200
     2.832    43.405     0.200
     2.888    42.997     0.200
     3.018    45.722     0.200
     3.468    51.184     0.200
     3.633    53.931     0.200
     3.667    54.717     0.200
     3.896    53.279     0.200
     3.931    55.894     0.200
     4.199    62.422     0.200
     4.218    62.418     0.200
     4.237    61.975     0.200
     4.354    64.017     0.200
     4.784    66.559     0.200
     5.486    76.076     0.200
     1.180    23.682     0.200
     2.636    44.106     0.200
     2.903    43.951     0.200
     3.047    49.642     0.200
     3.186    52.675     0.200
     3.187    52.671     0.200
     3.214    49.309     0.200
     3.229    50.905     0.200
     3.468    51.922     0.200
     3.927    55.126     0.200
     4.323    69.498     0.200
     4.435    71.355     0.200
     4.505    70.338     0.200
     5.445    85.783     0.200
     5.578    86.908     0.200
     5.671    79.618     0.200
     5.972    87.872     0.200
     6.380    98.409     0.200
     6.637    95.185     0.200
     7.609   113.535     0.200
     8.709   121.144     0.200
     1.353    24.716     0.200
     1.557    24.567     0.200
     1.875    30.668     0.200
     2.025    31.940     0.200
     2.107    35.441     0.200
     2.394    40.637     0.200
     2.362    38.751     0.200
     2.447    41.525     0.200
     2.455    39.563     0.200
     2.465    40.750     0.200
     2.481    40.894     0.200
     2.497    41.748     0.200
     2.533    41.768     0.200
     2.572    41.331     0.200
     2.603    42.583     0.200
     2.761    46.298     0.200
     2.764    46.191     0.200
     2.814    45.173     0.200
     2.890    42.821     0.200
     2.983    45.170     0.200
     3.143    50.998     0.200
     3.142    51.002     0.200
     3.151    52.312     0.200
     3.200    52.611     0.200
     3.170    47.942     0.200
     3.467    48.787     0.200
     3.808    60.247     0.200
     3.916    59.428     0.200
     3.913    55.224     0.200
     3.987    64.172     0.200
     4.103    61.676     0.200
     4.277    63.989     0.200
     4.300    63.503     0.200
     4.315    65.891     0.200
     4.319    66.964     0.200
     4.418    62.445     0.200
     4.422    68.136     0.200
     4.910    69.271     0.200
     4.910    70.328     0.200
     4.940    75.167     0.200
     5.437    74.731     0.200
     5.453    77.828     0.200
     5.625    78.116     0.200
     6.189    91.590     0.200
     6.317    94.287     0.200
     6.599    98.125     0.200
     6.630    94.352     0.200
     7.575   103.407     0.200
     7.686   103.086     0.200
     7.721   113.304     0.200
     7.809   107.938     0.200
     7.977   112.428     0.200
     8.328   115.535     0.200
     8.349   117.277     0.200
     9.534   134.738     0.200
     9.711   135.272     0.200
    11.012   149.444     0.200
    11.611   158.226     0.200
    12.560   172.650     0.200
     0.308    11.427     0.200
     0.781    16.460     0.200
     1.061    20.071     0.200
     1.017    20.206     0.200
     1.407    23.056     0.200
     1.465    24.557     0.200
     1.440    26.661     0.200
     1.778    29.046     0.200
     1.864    30.266     0.200
     1.864    30.066     0.200
     1.931    33.401     0.200
     2.088    36.222     0.200
     2.150    36.083     0.200
     2.258    37.765     0.200
     2.273    37.829     0.200
     2.280    37.939     0.200
     2.341    36.688     0.200
     2.314    37.642     0.200
     2.428    37.210     0.200
     2.357    37.654     0.200
     2.369    40.900     0.200
     2.385    37.799     0.200
     2.391    39.325     0.200
     2.401    39.174     0.200
     2.402    39.159     0.200
     2.431    40.465     0.200
     2.461    40.255     0.200
     2.461    40.445     0.200
     2.445    39.360     0.200
     2.465    40.181     0.200
     2.454    39.228     0.200
     2.502    40.876     0.200
     2.494    39.264     0.200
     2.514    40.703     0.200
     2.520    40.606     0.200
     2.521    40.597     0.200
     2.509    42.301     0.200
     2.524    41.886     0.200
     2.543    40.879     0.200
     2.606    39.923     0.200
     2.628    40.836     0.200
     2.557    44.043     0.200
     2.576    40.987     0.200
     2.613    41.955     0.200
     2.624    42.488     0.200
     2.659    42.787     0.200
     2.616    42.844     0.200
     2.850    43.078     0.200
     2.760    46.475     0.200
     2.831    43.483     0.200
     2.769    45.054     0.200
     2.879    45.346     0.200
     2.977    47.161     0.200
     2.900    45.604     0.200
     3.196    48.207     0.200
     3.372    50.308     0.200
     3.318    52.614     0.200
     3.319    52.604     0.200
     3.448    50.221     0.200
     3.601    52.373     0.200
     3.601    52.377     0.200
     3.610    52.740     0.200
     3.630    53.438     0.200
     3.556    55.842     0.200
     3.710    57.519     0.200
     3.717    57.808     0.200
     3.728    57.590     0.200
     3.735    57.437     0.200
     3.829    58.672     0.200
     3.991    61.659     0.200
     4.464    60.520     0.200
     4.500    64.174     0.200
     4.575    65.668     0.200
     4.645    71.856     0.200
     4.856    69.842     0.200
     5.270    71.076     0.200
     5.366    72.027     0.200
     5.366    76.128     0.200
     5.354    81.190     0.200
     5.839    80.376     0.200
     6.065    80.588     0.200
     7.070    98.256     0.200
     7.151    94.173     0.200
     8.065   111.897     0.200
     8.219   111.466     0.200
     8.251   112.606     0.200
     8.342   113.680     0.200
     9.898   132.375     0.200
    10.169   131.756     0.200
    10.599   146.258     0.200
    10.746   148.368     0.200
     1.269    24.641     0.200
     1.503    27.631     0.200
     1.984    30.013     0.200
     2.335    38.832     0.200
     2.491    41.346     0.200
     2.550    43.388     0.200
     2.618    38.285     0.200
     2.720    45.994     0.200
     2.715    43.925     0.200
     2.824    47.510     0.200
     2.859    46.916     0.200
     3.270    52.362     0.200
     3.297    50.012     0.200
     3.296    50.015     0.200
     3.396    55.388     0.200
     3.679    55.403     0.200
     3.679    55.392     0.200
     4.016    56.325     0.200
     4.121    63.395     0.200
     4.259    61.785     0.200
     4.272    61.558     0.200
     4.381    63.682     0.200
     4.619    71.109     0.200
     5.100    77.972     0.200
     5.062    77.825     0.200
     5.937    87.346     0.200
     6.342    89.791     0.200
     9.493   128.428     0.200
     9.579   129.211     0.200
     0.038    10.978     0.200
     0.807    16.359     0.200
     0.958    19.000     0.200
     1.133    22.038     0.200
     1.265    21.860     0.200
     1.365    23.622     0.200
     1.433    24.535     0.200
     1.555    24.248     0.200
     1.658    26.042     0.200
     1.777    31.264     0.200
     1.900    31.177     0.200
     1.926    34.223     0.200
     1.903    34.470     0.200
     1.984    33.538     0.200
     2.100    37.080     0.200
     2.154    33.726     0.200
     2.173    37.460     0.200
     2.178    38.566     0.200
     2.202    35.089     0.200
     2.217    35.427     0.200
     2.213    35.915     0.200
     2.247    36.142     0.200
     2.237    39.211     0.200
     2.265    39.101     0.200
     2.266    35.375     0.200
     2.329    39.867     0.200
     2.354    35.380     0.200
     2.401    36.551     0.200
     2.456    37.942     0.200
     2.566    41.085     0.200
     2.554    41.569     0.200
     2.598    40.802     0.200
     2.575    37.600     0.200
     2.732    44.639     0.200
     2.754    42.739     0.200
     2.844    42.063     0.200
     3.035    46.407     0.200
     3.305    50.979     0.200
     3.543    52.923     0.200
     3.587    50.376     0.200
     3.672    54.089     0.200
     3.702    53.239     0.200
     3.776    55.543     0.200
     4.536    68.999     0.200
     4.522    62.001     0.200
     4.672    66.375     0.200
     5.233    71.056     0.200
     5.718    81.599     0.200
     6.275    84.406     0.200
     1.076    21.494     0.200
     1.076    21.334     0.200
     1.352    24.332     0.200
     1.538    26.998     0.200
     1.538    26.679     0.200
     1.671    28.313     0.200
     1.781    27.451     0.200
     1.781    27.161     0.200
     2.158    35.223     0.200
     2.166    35.837     0.200
     2.210    36.427     0.200
     2.210    35.876     0.200
     2.442    40.680     0.200
     2.472    37.556     0.200
     2.468    41.610     0.200
     2.661    39.101     0.200
     2.657    43.432     0.200
     2.671    44.467     0.200
     2.710    44.812     0.200
     2.762    44.720     0.200
     2.778    46.087     0.200
     2.776    43.733     0.200
     2.804    37.939     0.200
     2.792    46.348     0.200
     2.828    44.059     0.200
     2.867    46.195     0.200
     2.871    46.072     0.200
     2.874    46.239     0.200
     2.896    46.092     0.200
     2.948    43.865     0.200
     2.951    47.456     0.200
     3.048    48.533     0.200
     3.054    46.852     0.200
     3.116    43.507     0.200
     3.200    50.406     0.200
     3.221    50.120     0.200
     3.278    50.987     0.200
     3.328    52.591     0.200
     3.748    58.758     0.200
     3.748    58.748     0.200
     3.801    59.977     0.200
     3.833    55.787     0.200
     3.902    56.935     0.200
     3.902    57.972     0.200
     3.902    57.594     0.200
     3.902    57.861     0.200
     4.157    60.075     0.200
     4.135    60.117     0.200
     4.574    64.861     0.200
     4.545    61.166     0.200
     4.545    63.996     0.200
     4.632    64.413     0.200
     4.778    69.067     0.200
     5.361    79.402     0.200
     5.382    73.880     0.200
     5.494    79.418     0.200
     5.773    84.882     0.200
     5.890    84.053     0.200
     6.170    83.313     0.200
     6.318    93.629     0.200
     6.511    93.493     0.200
     6.503    94.000     0.200
     6.606    95.186     0.200
     6.621    88.560     0.200
     6.813    94.778     0.200
     6.905    91.846     0.200
     6.955   102.065     0.200
     7.092   102.563     0.200
     7.234   101.650     0.200
     7.241   100.875     0.200
     8.278   111.817     0.200
     8.338   113.841     0.200
     8.679   118.396     0.200
     8.679   117.055     0.200
     9.581   133.936     0.200
     9.679   126.953     0.200
     9.742   128.348     0.200
     9.742   133.315     0.200
    10.001   138.941     0.200
    10.406   150.155     0.200
    10.747   141.349     0.200
    10.747   142.405     0.200
    11.535   162.135     0.200
    12.097   166.908     0.200
    16.070   216.733     0.200
    16.642   223.553     0.200
     0.237    11.469     0.200
     0.494    12.948     0.200
     0.799    16.012     0.200
     0.987    18.199     0.200
     1.053    19.728     0.200
     1.084    20.170     0.200
     1.128    21.924     0.200
     1.334    23.871     0.200
     1.338    23.766     0.200
     1.453    25.651     0.200
     1.531    28.095     0.200
     1.528    27.504     0.200
     1.738    29.061     0.200
     1.879    30.861     0.200
     1.987    32.542     0.200
     2.001    35.429     0.200
     2.047    34.004     0.200
     2.054    33.116     0.200
     2.073    34.372     0.200
     2.074    34.896     0.200
     2.112    35.267     0.200
     2.137    35.667     0.200
     2.141    33.784     0.200
     2.218    37.328     0.200
     2.223    36.795     0.200
     2.220    37.055     0.200
     2.255    38.512     0.200
     2.266    37.237     0.200
     2.270    37.894     0.200
     2.287    37.987     0.200
     2.316    40.373     0.200
     2.302    36.164     0.200
     2.312    35.808     0.200
     2.329    37.912     0.200
     2.342    37.149     0.200
     2.353    40.624     0.200
     2.454    40.124     0.200
     2.600    42.499     0.200
     2.605    41.677     0.200
     2.837    45.720     0.200
     3.145    45.302     0.200
     3.268    50.130     0.200
     3.310    55.030     0.200
     3.321    48.745     0.200
     4.070    57.004     0.200
     4.221    59.646     0.200
     0.169    11.373     0.200
     0.541    13.644     0.200
     0.722    15.234     0.200
     0.794    17.116     0.200
     0.878    17.673     0.200
     1.004    19.845     0.200
     1.129    21.578     0.200
     1.252    23.332     0.200
     1.388    25.458     0.200
     1.523    29.863     0.200
     1.677    31.059     0.200
     1.777    30.718     0.200
     1.814    28.665     0.200
     1.907    33.367     0.200
     1.918    30.062     0.200
     1.963    34.184     0.200
     2.018    33.558     0.200
     2.037    34.061     0.200
     2.042    34.404     0.200
     2.078    30.494     0.200
     2.094    33.016     0.200
     2.101    32.476     0.200
     2.143    32.340     0.200
     2.150    33.995     0.200
     2.344    35.246     0.200
     2.332    37.558     0.200
     2.420    40.186     0.200
     2.476    38.584     0.200
     2.538    37.394     0.200
     2.632    37.977     0.200
     2.664    43.983     0.200
     3.542    48.343     0.200
     4.431    64.886     0.200
     0.235    11.055     0.200
     0.398    12.102     0.200
     0.376    12.129     0.200
     0.872    18.804     0.200
     1.161    22.739     0.200
     1.340    23.356     0.200
     1.873    31.788     0.200
     1.941    33.542     0.200
     2.179    36.774     0.200
     2.151    32.696     0.200
     2.215    36.252     0.200
     2.243    37.303     0.200
     2.218    38.186     0.200
     2.216    35.672     0.200
     2.263    34.977     0.200
     2.265    34.960     0.200
     2.270    35.767     0.200
     2.284    37.684     0.200
     2.319    41.359     0.200
     2.335    34.541     0.200
     2.336    34.535     0.200
     2.345    37.059     0.200
     2.365    36.119     0.200
     2.409    37.340     0.200
     2.379    35.791     0.200
     2.424    40.661     0.200
     2.455    37.228     0.200
     2.528    43.289     0.200
     2.606    44.974     0.200
     2.740    46.812     0.200
     2.817    43.723     0.200
     2.872    46.085     0.200
     3.005    43.765     0.200
     2.994    47.505     0.200
     2.971    45.576     0.200
     3.177    45.902     0.200
     3.277    49.782     0.200
     3.278    49.771     0.200
     3.344    49.842     0.200
     3.788    55.967     0.200
     3.803    56.122     0.200
     3.785    62.066     0.200
     4.019    52.993     0.200
     4.142    59.669     0.200
     4.253    64.665     0.200
     4.290    64.365     0.200
     7.773   107.247     0.200
     7.729   111.114     0.200
     7.806   109.226     0.200
     7.896   107.362     0.200
     8.422   119.778     0.200
     0.379    13.633     0.200
     0.383    13.583     0.200
     0.470    14.508     0.200
     0.716    16.877     0.200
     1.069    21.129     0.200
     1.187    23.102     0.200
     1.725    33.091     0.200
     1.839    31.056     0.200
     2.011    33.075     0.200
     2.110    37.246     0.200
     2.117    36.491     0.200
     2.116    33.804     0.200
     2.125    39.062     0.200
     2.156    40.030     0.200
     2.333    36.755     0.200
     2.710    43.146     0.200
     2.864    43.803     0.200
     2.968    42.067     0.200
     3.077    45.350     0.200
     3.393    46.899     0.200
     3.644    57.705     0.200
     3.977    55.523     0.200
     4.270    61.072     0.200
     5.321    73.892     0.200
     1.119    21.763     0.200
     1.737    27.721     0.200
     1.700    28.247     0.200
     2.574    40.883     0.200
     2.574    43.033     0.200
     2.574    40.628     0.200
     2.740    44.598     0.200
     2.799    43.704     0.200
     2.917    45.217     0.200
     3.022    46.715     0.200
     3.022    46.719     0.200
     3.031    49.191     0.200
     3.094    49.662     0.200
     3.316    52.266     0.200
     3.545    56.055     0.200
     3.610    52.841     0.200
     3.773    52.364     0.200
     4.459    71.687     0.200
     4.560    66.525     0.200
     4.789    69.573     0.200
     4.789    70.018     0.200
     4.935    77.734     0.200
     5.215    75.451     0.200
     5.346    80.964     0.200
     5.895    84.805     0.200
     6.077    88.806     0.200
     6.241    94.400     0.200
     6.473    95.912     0.200
     6.495    90.669     0.200
     6.495    95.657     0.200
     6.667    95.699     0.200
     7.446   107.140     0.200
     7.585   105.013     0.200
     8.210   117.683     0.200
     8.547   122.395     0.200
     8.547   114.363     0.200
     9.274   133.083     0.200
    10.078   143.317     0.200
    10.439   143.852     0.200
    10.419   147.730     0.200
    10.451   143.679     0.200
    10.439   147.641     0.200
    10.550   151.019     0.200
    10.740   149.577     0.200
    10.692   142.496     0.200
    10.770   142.918     0.200
    10.970   155.692     0.200
    11.513   151.558     0.200
    11.513   158.389     0.200
    12.160   170.236     0.200
    12.155   170.581     0.200
    12.464   175.617     0.200
    13.150   183.691     0.200
    13.576   182.603     0.200
    13.996   194.844     0.200
    14.186   196.574     0.200
    14.426   198.396     0.200
    15.015   206.174     0.200
    15.486   209.582     0.200
    15.599   213.938     0.200
    16.151   220.326     0.200
    16.317   222.596     0.200
    16.764   220.498     0.200
    22.401   287.869     0.200
     1.093    21.770     0.200
     2.549    41.159     0.200
     2.786    40.860     0.200
     3.054    47.315     0.200
     3.053    49.515     0.200
     3.572    50.577     0.200
     3.808    51.903     0.200
     4.418    63.953     0.200
     4.519    65.434     0.200
     4.814    66.995     0.200
     4.814    68.536     0.200
     4.814    74.548     0.200
     4.892    73.635     0.200
     5.176    73.722     0.200
     5.540    89.355     0.200
     6.211    94.595     0.200
     6.500    99.476     0.200
     7.475    99.842     0.200
     7.582   103.449     0.200
     7.617   104.365     0.200
     7.705   103.340     0.200
     8.006   117.861     0.200
     8.564   117.551     0.200
     8.711   125.141     0.200
     9.615   137.776     0.200
    10.449   143.485     0.200
    11.528   153.390     0.200
    11.528   153.782     0.200
    11.528   151.782     0.200
     1.027    20.554     0.200
     3.548    52.445     0.200
     4.380    68.646     0.200
     4.750    74.274     0.200
     4.807    67.338     0.200
     5.147    74.347     0.200
     5.346    82.670     0.200
     5.529    84.008     0.200
     5.991    91.392     0.200
     7.476   101.909     0.200
     7.593   100.946     0.200
     7.628   102.541     0.200
     7.717   109.508     0.200
     7.939   114.993     0.200
     9.559   139.015     0.200
    10.358   145.882     0.200
    12.074   165.753     0.200
     0.742    16.123     0.200
     0.995    20.247     0.200
     1.265    22.449     0.200
     1.802    28.622     0.200
     2.018    34.723     0.200
     2.027    33.439     0.200
     2.078    34.531     0.200
     2.256    34.263     0.200
     2.334    36.981     0.200
     2.341    35.752     0.200
     2.355    37.065     0.200
     2.356    36.537     0.200
     2.362    38.844     0.200
     2.370    38.833     0.200
     2.379    37.889     0.200
     2.440    39.460     0.200
     2.510    41.321     0.200
     2.511    38.750     0.200
     2.569    40.511     0.200
     2.632    39.119     0.200
     2.590    41.366     0.200
     2.672    43.551     0.200
     2.689    40.229     0.200
     2.710    44.711     0.200
     2.782    44.887     0.200
     2.819    45.767     0.200
     2.857    44.635     0.200
     2.857    44.639     0.200
     2.865    41.159     0.200
     2.944    47.901     0.200
     3.342    52.663     0.200
     3.414    51.266     0.200
     3.415    51.256     0.200
     3.650    51.108     0.200
     3.717    54.432     0.200
     3.818    54.362     0.200
     4.625    65.775     0.200
     4.625    64.143     0.200
     4.697    68.798     0.200
     5.309    74.167     0.200
     5.961    83.074     0.200
     7.932   109.110     0.200
     1.268    26.478     0.200
     1.350    26.528     0.200
     1.382    28.080     0.200
     1.691    30.948     0.200
     2.252    39.348     0.200
     2.252    39.678     0.200
     2.677    44.105     0.200
     2.745    45.226     0.200
     2.793    46.549     0.200
     0.302    12.132     0.200
     0.385    11.477     0.200
     0.686    14.367     0.200
     0.699    15.452     0.200
     0.859    17.105     0.200
     0.899    17.955     0.200
     1.141    21.886     0.200
     1.165    21.967     0.200
     1.204    22.396     0.200
     1.289    22.285     0.200
     1.323    24.320     0.200
     1.372    23.282     0.200
     1.524    26.964     0.200
     1.886    30.955     0.200
     1.892    30.773     0.200
     1.956    31.234     0.200
     1.956    31.086     0.200
     2.005    33.821     0.200
     2.018    34.158     0.200
     2.044    32.138     0.200
     2.055    36.723     0.200
     2.076    36.021     0.200
     2.084    35.151     0.200
     2.098    31.835     0.200
     2.100    34.190     0.200
     2.110    34.297     0.200
     2.160    34.865     0.200
     2.226    36.034     0.200
     2.244    33.360     0.200
     2.283    34.112     0.200
     2.322    35.131     0.200
     2.334    36.018     0.200
     2.355    36.594     0.200
     2.374    39.673     0.200
     2.409    38.644     0.200
     2.415    38.013     0.200
     2.445    39.041     0.200
     2.511    37.080     0.200
     2.525    37.495     0.200
     2.629    43.121     0.200
     2.850    45.602     0.200
     2.916    45.470     0.200
     2.952    40.607     0.200
     3.072    46.064     0.200
     3.321    52.686     0.200
     3.452    52.661     0.200
     3.866    55.270     0.200
     4.581    62.997     0.200
     0.312    11.927     0.200
     0.411    12.898     0.200
     0.642    14.746     0.200
     0.855    17.420     0.200
     0.871    16.940     0.200
     0.998    20.167     0.200
     1.130    21.481     0.200
     1.166    21.740     0.200
     1.269    22.779     0.200
     1.275    23.441     0.200
     1.446    25.154     0.200
     1.604    27.858     0.200
     1.621    27.374     0.200
     1.811    29.995     0.200
     1.944    32.487     0.200
     1.952    31.556     0.200
     1.960    32.623     0.200
     1.982    32.507     0.200
     1.983    32.015     0.200
     1.993    32.228     0.200
     2.014    32.528     0.200
     2.022    33.505     0.200
     2.049    32.822     0.200
     2.056    33.612     0.200
     2.089    34.078     0.200
     2.115    34.685     0.200
     2.120    36.697     0.200
     2.176    32.960     0.200
     2.284    35.876     0.200
     2.321    36.209     0.200
     2.372    38.356     0.200
     2.405    38.518     0.200
     2.408    38.148     0.200
     2.409    37.234     0.200
     2.449    36.083     0.200
     2.484    39.292     0.200
     2.487    36.250     0.200
     2.502    43.988     0.200
     2.656    41.821     0.200
     2.667    39.282     0.200
     2.673    41.809     0.200
     2.802    40.705     0.200
     2.984    46.165     0.200
     3.349    50.057     0.200
     3.548    52.354     0.200
     3.566    52.812     0.200
     3.712    54.997     0.200
     4.428    64.466     0.200
     4.520    63.722     0.200
     5.190    75.668     0.200
     5.291    75.995     0.200
     5.422    76.968     0.200
     6.133    86.154     0.200
     1.172    23.705     0.200
     2.556    43.018     0.200
     2.557    43.015     0.200
     2.650    39.035     0.200
     2.650    42.566     0.200
     2.724    45.191     0.200
     2.759    43.234     0.200
     2.791    40.641     0.200
     2.894    45.958     0.200
     2.969    46.060     0.200
     2.969    46.064     0.200
     3.179    45.233     0.200
     3.405    51.250     0.200
     3.596    54.745     0.200
     3.597    54.735     0.200
     3.698    51.239     0.200
     3.692    53.290     0.200
     4.219    64.468     0.200
     4.547    63.097     0.200
     4.647    68.874     0.200
     4.734    66.934     0.200
     5.299    83.509     0.200
     5.983    78.509     0.200
     1.602    26.002     0.200
     2.461    40.455     0.200
     2.625    43.474     0.200
     3.638    51.372     0.200
     4.448    66.454     0.200
     4.669    65.494     0.200
     4.669    65.884     0.200
     4.669    67.789     0.200
     7.319   103.943     0.200
     7.416   104.321     0.200
     7.623   112.079     0.200
     9.548   138.680     0.200
     0.312    11.558     0.200
     0.363    11.994     0.200
     0.489    12.875     0.200
     0.884    17.587     0.200
     1.152    20.998     0.200
     1.254    23.105     0.200
     1.530    22.380     0.200
     1.797    30.734     0.200
     1.844    31.807     0.200
     2.058    35.106     0.200
     2.087    35.377     0.200
     2.106    37.971     0.200
     2.130    35.289     0.200
     2.116    34.677     0.200
     2.136    38.476     0.200
     2.166    36.927     0.200
     2.173    36.732     0.200
     2.176    36.808     0.200
     2.182    34.812     0.200
     2.206    34.820     0.200
     2.208    38.368     0.200
     2.230    37.208     0.200
     2.232    37.863     0.200
     2.235    36.500     0.200
     2.287    37.844     0.200
     2.297    39.074     0.200
     2.369    39.073     0.200
     2.451    43.026     0.200
     2.735    43.531     0.200
     2.724    43.016     0.200
     2.745    45.398     0.200
     2.866    45.327     0.200
     3.199    50.492     0.200
     3.440    54.093     0.200
     3.964    57.228     0.200
     4.090    62.316     0.200
     4.330    65.448     0.200
     4.817    67.627     0.200
     0.408    13.402     0.200
     0.610    14.599     0.200
     0.875    17.416     0.200
     1.018    19.993     0.200
     1.111    21.031     0.200
     1.217    21.872     0.200
     1.205    23.438     0.200
     1.263    22.403     0.200
     1.865    30.427     0.200
     1.916    29.264     0.200
     1.957    33.043     0.200
     1.954    29.633     0.200
     1.972    34.135     0.200
     1.976    30.905     0.200
     1.985    32.172     0.200
     2.005    29.037     0.200
     2.011    30.583     0.200
     2.065    35.053     0.200
     2.129    33.456     0.200
     2.208    36.059     0.200
     2.313    34.827     0.200
     2.355    38.967     0.200
     2.353    39.438     0.200
     2.355    37.540     0.200
     2.398    40.512     0.200
     2.403    38.872     0.200
     2.428    38.664     0.200
     2.432    41.411     0.200
     2.435    34.992     0.200
     2.514    36.613     0.200
     2.621    37.174     0.200
     2.621    39.977     0.200
     2.764    41.373     0.200
     2.833    41.894     0.200
     2.853    39.680     0.200
     3.029    46.421     0.200
     3.300    49.471     0.200
     3.534    51.761     0.200
     3.745    54.766     0.200
     5.138    74.353     0.200
     5.238    74.800     0.200
     5.370    74.321     0.200
     5.506    75.803     0.200
     6.055    88.134     0.200
     6.579    90.149     0.200
     6.610    91.367     0.200
     6.702    91.243     0.200
     0.512    14.104     0.200
     0.480    14.511     0.200
     0.718    16.529     0.200
     1.005    20.109     0.200
     1.046    20.581     0.200
     1.101    21.684     0.200
     1.247    23.602     0.200
     1.335    24.581     0.200
     1.349    26.000     0.200
     1.686    29.363     0.200
     1.750    26.510     0.200
     1.802    30.302     0.200
     1.838    25.487     0.200
     1.857    30.313     0.200
     1.903    32.183     0.200
     1.952    31.865     0.200
     2.038    34.180     0.200
     1.990    36.100     0.200
     2.153    36.837     0.200
     2.158    36.197     0.200
     2.091    37.260     0.200
     2.219    36.058     0.200
     2.060    34.753     0.200
     2.240    37.147     0.200
     2.471    35.641     0.200
     2.965    45.294     0.200
     3.021    43.275     0.200
     3.295    55.023     0.200
     3.857    55.376     0.200
     4.561    63.393     0.200
     4.957    69.890     0.200
     5.186    74.526     0.200
     6.261    89.690     0.200
     0.217    10.088     0.200
     0.295    10.807     0.200
     0.910    18.297     0.200
     1.198    22.299     0.200
     1.360    23.937     0.200
     1.378    24.658     0.200
     1.439    24.605     0.200
     1.487    25.390     0.200
     1.912    31.300     0.200
     1.976    31.216     0.200
     1.978    32.508     0.200
     1.995    32.868     0.200
     2.187    35.297     0.200
     2.250    36.442     0.200
     2.256    35.378     0.200
     2.261    36.852     0.200
     2.297    37.872     0.200
     2.303    36.728     0.200
     2.308    37.435     0.200
     2.319    36.266     0.200
     2.343    36.988     0.200
     2.355    37.343     0.200
     2.378    37.552     0.200
     2.410    37.649     0.200
     2.417    37.979     0.200
     2.567    39.993     0.200
     2.645    41.402     0.200
     2.774    42.825     0.200
     2.874    44.204     0.200
     2.910    44.052     0.200
     2.995    44.739     0.200
     3.012    46.188     0.200
     3.173    48.230     0.200
     3.317    50.464     0.200
     3.816    56.197     0.200
     4.011    58.026     0.200
     4.027    59.259     0.200
     4.100    60.006     0.200
     4.270    62.180     0.200
     4.941    70.298     0.200
     5.647    80.226     0.200
     0.918    18.770     0.200
     1.504    26.404     0.200
     1.933    31.215     0.200
     2.422    38.405     0.200
     2.461    39.712     0.200
     2.505    40.861     0.200
     2.538    41.100     0.200
     2.556    41.635     0.200
     2.564    42.922     0.200
     2.608    43.246     0.200
     2.610    43.745     0.200
     2.619    41.119     0.200
     2.629    42.939     0.200
     2.636    40.103     0.200
     2.668    41.976     0.200
     2.699    44.526     0.200
     2.752    45.517     0.200
     2.777    44.606     0.200
     2.857    45.693     0.200
     2.948    42.965     0.200
     2.961    47.625     0.200
     3.063    48.050     0.200
     3.110    50.529     0.200
     3.203    48.986     0.200
     3.202    48.990     0.200
     3.211    49.979     0.200
     3.149    49.972     0.200
     3.413    50.086     0.200
     3.970    56.225     0.200
     4.014    62.742     0.200
     4.161    62.758     0.200
     4.121    60.044     0.200
     4.252    61.331     0.200
     4.468    67.705     0.200
     4.368    64.200     0.200
     4.832    73.364     0.200
     4.970    69.398     0.200
     4.970    73.624     0.200
     4.962    76.993     0.200
     5.385    80.349     0.200
     5.685    80.864     0.200
     5.898    87.014     0.200
     6.196    94.197     0.200
     6.689    93.507     0.200
     7.635   105.441     0.200
     7.745   107.056     0.200
     7.780   109.302     0.200
     7.868   107.609     0.200
     7.981   117.922     0.200
     9.503   136.386     0.200
    11.668   156.159     0.200
    11.967   164.623     0.200
     0.257    11.808     0.200
     0.593    14.525     0.200
     0.650    14.888     0.200
     0.708    15.623     0.200
     0.761    15.580     0.200
     1.014    20.655     0.200
     1.113    20.404     0.200
     1.125    23.094     0.200
     1.177    22.468     0.200
     1.616    27.026     0.200
     1.686    29.263     0.200
     1.722    28.180     0.200
     1.841    28.725     0.200
     1.886    31.612     0.200
     1.920    36.114     0.200
     1.971    34.449     0.200
     1.993    35.253     0.200
     2.036    36.025     0.200
     2.097    33.645     0.200
     2.099    33.476     0.200
     2.495    39.034     0.200
     2.636    42.167     0.200
     2.695    43.810     0.200
     2.753    39.605     0.200
     2.778    42.050     0.200
     3.622    51.411     0.200
     3.752    49.130     0.200
     4.243    63.468     0.200
     4.334    65.520     0.200
     4.479    63.532     0.200
     4.602    65.404     0.200
     0.845    17.058     0.200
     1.871    30.885     0.200
     1.875    32.028     0.200
     1.863    30.633     0.200
     1.912    32.881     0.200
     2.060    34.010     0.200
     2.167    35.195     0.200
     2.163    34.537     0.200
     2.201    35.213     0.200
     2.217    36.566     0.200
     2.218    35.729     0.200
     2.238    36.402     0.200
     2.242    36.579     0.200
     2.272    37.070     0.200
     2.277    37.014     0.200
     2.290    36.634     0.200
     2.306    37.530     0.200
     2.286    37.237     0.200
     2.307    36.777     0.200
     2.309    36.852     0.200
     2.334    38.490     0.200
     2.352    37.195     0.200
     2.356    37.865     0.200
     2.373    38.765     0.200
     2.378    37.566     0.200
     2.409    39.177     0.200
     2.440    37.956     0.200
     2.449    38.300     0.200
     2.489    39.514     0.200
     2.524    39.779     0.200
     2.575    40.752     0.200
     2.758    43.533     0.200
     2.807    43.186     0.200
     2.815    43.296     0.200
     2.850    43.800     0.200
     2.890    44.783     0.200
     2.883    44.171     0.200
     3.047    47.057     0.200
     3.047    47.053     0.200
     3.071    47.006     0.200
     3.271    50.447     0.200
     3.272    50.437     0.200
     3.851    57.661     0.200
     3.896    57.277     0.200
     4.129    60.416     0.200
     4.371    63.279     0.200
     4.740    70.743     0.200
     5.412    77.817     0.200
     5.851    85.530     0.200
     5.957    85.180     0.200
     6.514    92.119     0.200
     6.582    87.909     0.200
     7.504   106.086     0.200
     7.650   106.073     0.200
     7.682   108.142     0.200
     7.750   107.219     0.200
     0.905    18.381     0.200
     2.351    37.816     0.200
     2.410    38.770     0.200
     2.408    40.858     0.200
     2.464    41.174     0.200
     2.506    40.741     0.200
     2.516    41.923     0.200
     2.539    42.797     0.200
     2.536    40.753     0.200
     2.555    42.780     0.200
     2.567    42.018     0.200
     2.595    43.784     0.200
     2.612    42.170     0.200
     2.613    42.612     0.200
     2.621    42.628     0.200
     2.633    41.785     0.200
     2.679    43.255     0.200
     2.703    43.726     0.200
     2.864    45.463     0.200
     2.973    47.254     0.200
     3.102    46.443     0.200
     3.079    49.470     0.200
     3.115    51.185     0.200
     3.191    52.590     0.200
     3.191    52.593     0.200
     3.162    46.570     0.200
     3.427    51.040     0.200
     3.529    57.219     0.200
     3.530    57.208     0.200
     3.957    55.609     0.200
     4.026    59.678     0.200
     4.136    62.856     0.200
     4.267    63.464     0.200
     4.383    66.172     0.200
     4.464    67.727     0.200
     4.835    72.510     0.200
     4.959    72.967     0.200
     4.970    76.285     0.200
     5.034    75.219     0.200
     5.399    80.618     0.200
     5.505    84.269     0.200
     5.721    85.384     0.200
     5.912    89.009     0.200
     6.203    91.577     0.200
     6.306    92.995     0.200
     6.647    95.588     0.200
     6.676    91.051     0.200
     7.623   106.713     0.200
     7.731   107.237     0.200
     7.767   111.307     0.200
     7.855   109.391     0.200
     7.988   115.405     0.200
     8.680   125.378     0.200
     1.244    24.697     0.200
     1.244    24.182     0.200
     1.982    32.227     0.200
     2.059    34.295     0.200
     2.181    36.269     0.200
     2.388    39.681     0.200
     2.427    39.391     0.200
     2.435    37.312     0.200
     2.506    42.111     0.200
     2.508    41.554     0.200
     2.555    42.978     0.200
     2.568    43.145     0.200
     2.605    42.633     0.200
     2.622    42.436     0.200
     2.623    44.130     0.200
     2.622    43.358     0.200
     2.636    42.035     0.200
     2.644    43.725     0.200
     2.647    42.621     0.200
     2.651    42.357     0.200
     2.653    43.943     0.200
     2.669    43.685     0.200
     2.670    44.409     0.200
     2.695    44.910     0.200
     2.697    41.076     0.200
     2.694    45.070     0.200
     2.694    45.074     0.200
     2.719    44.632     0.200
     2.736    44.607     0.200
     2.745    44.761     0.200
     2.776    44.463     0.200
     2.865    47.593     0.200
     2.891    47.023     0.200
     3.048    48.764     0.200
     3.123    50.560     0.200
     3.267    52.364     0.200
     3.348    50.815     0.200
     3.348    50.644     0.200
     3.411    51.086     0.200
     3.598    56.295     0.200
     3.599    56.285     0.200
     3.626    55.968     0.200
     3.695    56.677     0.200
     3.692    57.239     0.200
     3.900    59.739     0.200
     3.971    56.370     0.200
     4.203    64.762     0.200
     4.368    68.326     0.200
     4.456    61.509     0.200
     5.163    76.340     0.200
     5.179    76.645     0.200
     5.573    79.101     0.200
     5.883    86.275     0.200
     5.937    82.320     0.200
     6.132    90.560     0.200
     6.238    91.923     0.200
     6.330    94.178     0.200
     6.406    93.271     0.200
     6.672    96.319     0.200
     7.097   103.309     0.200
     8.144   120.909     0.200
     8.882   129.326     0.200
     9.937   140.597     0.200
    11.227   151.096     0.200
     1.160    21.372     0.200
     1.241    21.903     0.200
     2.092    35.229     0.200
     2.176    36.534     0.200
     2.288    37.355     0.200
     2.288    37.488     0.200
     2.341    38.441     0.200
     2.340    37.705     0.200
     2.354    38.843     0.200
     2.373    37.861     0.200
     2.396    38.324     0.200
     2.482    39.998     0.200
     2.520    42.080     0.200
     2.586    39.977     0.200
     2.957    45.811     0.200
     3.120    48.694     0.200
     3.197    46.109     0.200
     3.231    51.801     0.200
     3.336    51.669     0.200
     3.816    59.237     0.200
     3.930    61.890     0.200
     4.058    61.723     0.200
     4.210    57.484     0.200
     4.736    69.544     0.200
     1.283    26.121     0.200
     1.421    27.990     0.200
     1.525    28.921     0.200
     2.361    41.285     0.200
     2.407    41.792     0.200
     3.439    56.516     0.200
     7.714   111.756     0.200
     0.192    10.787     0.200
     0.306    11.336     0.200
     0.469    12.162     0.200
     0.885    18.434     0.200
     1.037    19.242     0.200
     1.123    21.391     0.200
     1.345    24.819     0.200
     1.360    24.612     0.200
     1.417    25.259     0.200
     1.528    26.586     0.200
     1.870    31.760     0.200
     1.953    33.038     0.200
     2.056    33.466     0.200
     2.139    35.400     0.200
     2.218    36.562     0.200
     2.222    36.682     0.200
     2.244    36.138     0.200
     2.275    38.028     0.200
     2.286    36.781     0.200
     2.292    39.108     0.200
     2.300    37.630     0.200
     2.304    38.287     0.200
     2.322    37.976     0.200
     2.321    37.729     0.200
     2.321    38.869     0.200
     2.350    37.741     0.200
     2.350    39.311     0.200
     2.355    39.139     0.200
     2.355    39.133     0.200
     2.366    37.634     0.200
     2.371    38.636     0.200
     2.370    38.187     0.200
     2.385    38.579     0.200
     2.387    39.008     0.200
     2.393    38.694     0.200
     2.426    39.354     0.200
     2.431    38.593     0.200
     2.458    39.387     0.200
     2.459    39.126     0.200
     2.478    39.152     0.200
     2.525    40.582     0.200
     2.588    40.721     0.200
     2.692    42.476     0.200
     2.801    44.628     0.200
     2.879    45.012     0.200
     2.901    45.128     0.200
     3.050    47.132     0.200
     3.076    46.556     0.200
     3.235    49.316     0.200
     3.235    49.320     0.200
     3.274    50.802     0.200
     3.275    50.792     0.200
     3.273    49.914     0.200
     3.741    56.759     0.200
     3.825    57.802     0.200
     3.828    56.225     0.200
     3.942    58.800     0.200
     4.090    55.912     0.200
     4.151    61.914     0.200
     4.184    61.938     0.200
     4.329    64.356     0.200
     4.587    67.384     0.200
     4.689    70.103     0.200
     4.859    71.262     0.200
     5.002    70.099     0.200
     5.002    72.789     0.200
     5.226    76.968     0.200
     5.221    75.499     0.200
     5.495    78.509     0.200
     5.705    81.290     0.200
     5.679    82.099     0.200
     6.025    87.613     0.200
     6.703    94.080     0.200
     6.776    91.584     0.200
     7.695   107.472     0.200
     7.710   110.022     0.200
     7.844   109.623     0.200
     7.876   110.513     0.200
     8.397   119.700     0.200
     8.420   117.460     0.200
    10.044   138.574     0.200
    10.728   147.837     0.200
    10.991   152.256     0.200
    11.621   152.556     0.200
    11.621   150.834     0.200
     2.155    35.707     0.200
     2.335    38.840     0.200
     2.335    38.298     0.200
     2.409    39.613     0.200
     2.698    42.317     0.200
     2.768    43.163     0.200
     2.761    45.729     0.200
     3.020    47.205     0.200
     3.107    46.258     0.200
     3.242    48.750     0.200
     3.274    52.138     0.200
     3.274    53.048     0.200
     3.393    50.489     0.200
     3.779    56.727     0.200
     3.881    60.052     0.200
     4.022    57.475     0.200
     4.299    62.934     0.200
     4.594    70.026     0.200
     4.694    67.455     0.200
     5.056    72.507     0.200
     5.159    74.132     0.200
     5.351    75.219     0.200
     5.860    79.692     0.200
     8.009   108.266     0.200
     8.042   112.869     0.200
     8.132   110.151     0.200
     1.051    19.086     0.200
     1.351    23.287     0.200
     1.410    24.772     0.200
     1.512    26.620     0.200
     1.911    32.349     0.200
     2.006    33.246     0.200
     2.068    32.417     0.200
     2.093    35.607     0.200
     2.173    36.159     0.200
     2.178    35.905     0.200
     2.237    35.585     0.200
     2.232    36.742     0.200
     2.242    35.991     0.200
     2.282    36.633     0.200
     2.326    36.379     0.200
     2.339    36.850     0.200
     2.478    39.261     0.200
     2.476    40.497     0.200
     2.542    42.429     0.200
     2.652    41.536     0.200
     2.876    44.527     0.200
     3.031    47.196     0.200
     3.088    43.839     0.200
     3.231    47.822     0.200
     3.263    48.478     0.200
     3.230    49.938     0.200
     4.035    59.559     0.200
     4.165    58.040     0.200
     4.845    70.789     0.200
     2.758    45.780     0.200
     4.422    64.569     0.200
    11.229   157.222     0.200
     1.037    24.321     0.200
     1.312    28.374     0.200
     1.356    27.802     0.200
     1.866    33.910     0.200
     2.169    39.346     0.200
     2.302    39.564     0.200
     2.312    42.111     0.200
     2.374    42.758     0.200
     2.610    46.573     0.200
     2.630    45.128     0.200
     2.668    45.957     0.200
     2.643    46.306     0.200
     2.689    47.095     0.200
     2.705    47.196     0.200
     2.708    47.617     0.200
     2.753    48.567     0.200
     2.743    48.457     0.200
     2.758    46.760     0.200
     2.759    48.628     0.200
     2.767    48.180     0.200
     2.782    48.661     0.200
     2.782    49.332     0.200
     2.784    48.633     0.200
     2.804    49.732     0.200
     2.826    49.755     0.200
     2.831    49.996     0.200
     2.833    48.733     0.200
     2.853    49.757     0.200
     2.879    50.109     0.200
     2.896    49.329     0.200
     2.913    49.134     0.200
     3.004    51.342     0.200
     3.026    51.988     0.200
     3.194    53.612     0.200
     3.251    54.490     0.200
     3.260    55.309     0.200
     3.327    50.208     0.200
     3.414    57.324     0.200
     3.497    58.351     0.200
     3.686    60.266     0.200
     3.734    61.640     0.200
     3.766    61.095     0.200
     4.004    66.791     0.200
     4.075    63.667     0.200
     4.273    68.784     0.200
     4.422    69.159     0.200
     4.518    67.982     0.200
     4.588    72.117     0.200
     4.784    74.648     0.200
     4.910    78.738     0.200
     4.918    76.221     0.200
     4.989    77.489     0.200
     5.030    77.192     0.200
     5.036    78.493     0.200
     5.150    78.158     0.200
     6.049    92.771     0.200
     6.069    87.205     0.200
     6.032    93.529     0.200
     6.087    92.988     0.200
     6.119    92.123     0.200
     6.364    95.896     0.200
     6.539    98.142     0.200
     6.822   103.918     0.200
     7.043   104.788     0.200
     7.131   106.530     0.200
     8.245   123.856     0.200
     8.286   122.756     0.200
     9.280   128.987     0.200
    10.084   145.256     0.200
    10.900   154.979     0.200
    11.229   157.827     0.200
    11.406   163.217     0.200
    11.808   168.285     0.200
    12.624   178.058     0.200
    12.663   181.012     0.200
    13.133   183.770     0.200
    15.784   217.898     0.200
    16.280   222.792     0.200
    16.548   225.095     0.200
    17.882   240.553     0.200
    18.729   249.932     0.200
    20.520   274.217     0.200
    22.101   287.671     0.200
    22.187   289.486     0.200
     0.233    12.233     0.200
     0.568    14.541     0.200
     0.690    15.507     0.200
     0.679    15.655     0.200
     0.753    16.036     0.200
     1.029    20.589     0.200
     1.136    21.562     0.200
     1.155    21.117     0.200
     1.192    22.661     0.200
     1.642    27.842     0.200
     1.718    29.337     0.200
     1.857    30.585     0.200
     1.909    31.659     0.200
     2.017    33.218     0.200
     2.024    31.627     0.200
     2.026    31.033     0.200
     2.068    34.745     0.200
     2.082    34.630     0.200
     2.168    32.348     0.200
     2.261    35.603     0.200
     2.400    40.523     0.200
     2.523    40.784     0.200
     2.660    40.612     0.200
     2.661    46.318     0.200
     2.754    39.260     0.200
     2.794    44.636     0.200
     2.852    40.388     0.200
     3.103    45.040     0.200
     4.242    63.509     0.200
     4.335    62.311     0.200
     4.478    66.605     0.200
     0.318    10.954     0.200
     0.317    11.400     0.200
     0.462    12.592     0.200
     0.832    17.607     0.200
     0.889    17.041     0.200
     1.183    22.057     0.200
     1.306    22.769     0.200
     1.847    30.379     0.200
     1.892    31.978     0.200
     1.898    32.739     0.200
     2.091    32.248     0.200
     2.135    32.392     0.200
     2.139    35.740     0.200
     2.159    35.666     0.200
     2.183    35.836     0.200
     2.220    33.939     0.200
     2.226    32.213     0.200
     2.230    32.651     0.200
     2.286    36.826     0.200
     2.340    33.720     0.200
     2.421    36.539     0.200
     2.502    40.115     0.200
     2.555    42.138     0.200
     2.598    41.974     0.200
     2.772    41.154     0.200
     2.925    41.598     0.200
     3.080    47.278     0.200
     3.250    52.075     0.200
     1.834    30.729     0.200
     1.889    31.995     0.200
     2.104    34.959     0.200
     2.195    36.879     0.200
     2.225    35.721     0.200
     2.226    37.513     0.200
     2.288    37.802     0.200
     2.277    35.427     0.200
     2.291    37.754     0.200
     2.359    39.565     0.200
     2.712    41.378     0.200
     2.744    44.587     0.200
     2.854    46.205     0.200
     2.908    44.695     0.200
     3.040    46.398     0.200
     3.190    52.107     0.200
     3.447    52.833     0.200
     3.917    57.158     0.200
     4.095    62.664     0.200
     4.199    64.110     0.200
     4.335    65.850     0.200
     4.807    69.453     0.200
     1.412    28.100     0.200
     1.429    28.265     0.200
     1.529    27.610     0.200
     1.914    32.424     0.200
     2.144    37.035     0.200
     2.481    42.269     0.200
     2.927    47.307     0.200
     2.991    49.655     0.200
     3.191    52.053     0.200
     3.178    50.486     0.200
     3.436    51.982     0.200
     4.036    65.512     0.200
     3.950    59.787     0.200
     4.044    63.455     0.200
     4.154    65.333     0.200
     4.475    71.272     0.200
     4.283    65.405     0.200
     4.853    75.376     0.200
     4.989    78.790     0.200
     4.959    71.543     0.200
     4.959    75.211     0.200
     5.044    72.275     0.200
     5.504    82.271     0.200
     5.523    83.013     0.200
     5.409    78.168     0.200
     5.674    84.790     0.200
     5.734    82.724     0.200
     5.926    86.951     0.200
     6.221    93.738     0.200
     6.324    93.995     0.200
     6.646    97.293     0.200
     6.672    95.866     0.200
     7.621   110.658     0.200
     7.726   105.574     0.200
     7.850   113.115     0.200
     8.007   116.357     0.200
     8.702   124.502     0.200
     8.699   126.242     0.200
     8.675   123.492     0.200
     9.533   136.494     0.200
    10.310   145.317     0.200
    11.283   158.366     0.200
    12.059   167.784     0.200
    12.553   174.030     0.200
    15.257   207.556     0.200
    15.695   210.944     0.200
    15.997   216.630     0.200
    19.899   267.918     0.200
     1.236    21.336     0.200
     1.992    33.001     0.200
     2.229    33.405     0.200
     2.256    32.640     0.200
     2.630    43.549     0.200
     2.723    45.462     0.200
     2.761    44.339     0.200
     2.785    46.058     0.200
     2.836    45.471     0.200
     2.833    44.507     0.200
     2.856    45.233     0.200
     2.899    47.050     0.200
     2.925    45.763     0.200
     2.987    47.686     0.200
     3.098    51.044     0.200
     3.255    45.560     0.200
     3.317    54.473     0.200
     3.279    51.595     0.200
     3.499    52.356     0.200
     3.659    56.606     0.200
     3.592    54.405     0.200
     3.807    61.240     0.200
     3.862    57.410     0.200
     4.294    69.199     0.200
     4.378    64.475     0.200
     4.378    63.568     0.200
     4.160    56.321     0.200
     4.612    70.158     0.200
     5.008    76.874     0.200
     5.055    77.535     0.200
     4.874    67.525     0.200
     5.108    76.371     0.200
     5.002    70.398     0.200
     5.009    69.942     0.200
     5.121    71.753     0.200
     5.393    81.160     0.200
     5.771    78.986     0.200
     6.004    85.389     0.200
     6.036    85.279     0.200
     6.128    89.535     0.200
     6.137    83.169     0.200
     6.546    93.771     0.200
     6.456    89.599     0.200
     6.634    92.530     0.200
     6.985    99.542     0.200
     6.985    97.706     0.200
     6.917   100.141     0.200
     7.043    94.044     0.200
     7.060   100.896     0.200
     7.082    98.241     0.200
     8.217   118.720     0.200
     8.217   119.376     0.200
     8.365   120.799     0.200
     9.111   129.701     0.200
    10.183   145.745     0.200
    11.205   149.719     0.200
    11.493   160.443     0.200
    11.904   163.572     0.200
    15.880   211.857     0.200
    20.597   266.973     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    24.130   368.577     0.200
    12.726   254.012     0.200
     5.198   100.628     0.200
    11.591   236.492     0.200
    12.453   252.063     0.200
    18.495   373.120     0.200
    21.844   454.100     0.200
    26.361   533.854     0.200
    26.664   540.265     0.200
    30.045   606.469     0.200
    33.153   670.713     0.200
    33.886   693.365     0.200
    45.490   916.172     0.200
    45.983   925.589     0.200
    46.332   928.603     0.200
    46.627   940.651     0.200
    12.735   257.488     0.200
    18.782   379.400     0.200
    26.671   543.906     0.200
    27.063   536.025     0.200
     5.186    98.799     0.200
    12.760   257.071     0.200
    18.799   377.335     0.200
     4.487    86.742     0.200
    12.926   257.466     0.200
    18.989   381.184     0.200
    22.526   463.242     0.200
    27.005   547.580     0.200
    27.146   549.890     0.200
    27.344   553.906     0.200
    31.725   648.459     0.200
     4.567    88.583     0.200
    12.725   248.541     0.200
     4.541    92.616     0.200
    13.036   262.407     0.200
    19.096   390.610     0.200
     3.768    76.719     0.200
    13.324   264.527     0.200
     2.944    57.991     0.200
     2.953    57.169     0.200
    12.917   262.175     0.200
     2.621    50.325     0.200
     2.727    52.947     0.200
     4.174    84.574     0.200
     4.222    84.985     0.200
     4.296    85.747     0.200
    13.291   266.312     0.200
     2.676    51.045     0.200
     3.257    62.375     0.200
     3.493    72.342     0.200
     4.442    91.361     0.200
     8.894   179.470     0.200
    13.026   264.575     0.200
     2.559    52.625     0.200
     4.570    90.031     0.200
     9.015   178.971     0.200
    13.014   266.776     0.200
     2.654    52.287     0.200
     3.063    58.052     0.200
     3.034    59.277     0.200
     3.234    63.294     0.200
     3.616    72.460     0.200
     3.972    80.830     0.200
     4.543    88.357     0.200
     5.001    97.991     0.200
     5.001    96.323     0.200
     9.443   187.775     0.200
    12.888   264.946     0.200
    18.935   382.155     0.200
     2.858    53.024     0.200
     2.793    52.154     0.200
     2.637    52.517     0.200
     2.766    54.523     0.200
     4.704    92.363     0.200
    13.030   272.159     0.200
     2.946    52.554     0.200
     4.635    91.484     0.200
     3.872    78.348     0.200
     8.364   167.828     0.200
    13.081   264.012     0.200
    19.154   384.375     0.200
    22.896   455.182     0.200
    27.325   541.451     0.200
    27.596   551.049     0.200
     2.846    50.835     0.200
     4.375    85.488     0.200
    13.153   264.959     0.200
     2.544    45.670     0.200
     2.603    46.567     0.200
     2.904    51.691     0.200
     4.675    86.948     0.200
    12.778   253.015     0.200
    18.836   377.960     0.200
     2.613    53.723     0.200
     4.635    90.944     0.200
     2.635    51.937     0.200
     2.635    51.939     0.200
     4.025    76.442     0.200
    13.517   269.774     0.200
     2.664    49.352     0.200
     2.525    50.428     0.200
     2.525    50.427     0.200
     2.544    48.570     0.200
     2.670    51.666     0.200
     2.694    53.887     0.200
     4.737    88.898     0.200
     4.826    92.395     0.200
     4.830    90.734     0.200
     4.837    92.946     0.200
     4.858    91.468     0.200
     4.877    92.915     0.200
    12.752   260.700     0.200
     4.786    91.059     0.200
    18.916   379.604     0.200
     2.593    50.019     0.200
     2.701    50.888     0.200
     3.283    64.948     0.200
     3.698    73.881     0.200
     2.809    50.857     0.200
     4.519    86.073     0.200
    12.669   251.629     0.200
     2.557    46.289     0.200
     4.821    89.139     0.200
    12.653   252.874     0.200
     4.705    89.253     0.200
    13.004   269.466     0.200
    19.060   374.663     0.200
     4.239    79.416     0.200
    13.400   271.844     0.200
    19.467   396.575     0.200
     2.619    50.492     0.200
     2.702    53.553     0.200
     4.953    96.563     0.200
     9.397   183.256     0.200
    12.896   262.844     0.200
     2.612    51.793     0.200
     2.946    56.197     0.200
     4.910    93.921     0.200
     9.374   185.584     0.200
    12.825   255.508     0.200
    18.876   373.021     0.200
     9.898   195.975     0.200
    12.358   246.684     0.200
     2.507    49.434     0.200
     2.785    52.413     0.200
     3.307    62.268     0.200
     3.305    62.289     0.200
     3.324    62.729     0.200
     5.062    96.954     0.200
     9.493   181.853     0.200
    11.987   243.240     0.200
    12.922   254.994     0.200
    18.965   381.202     0.200
     2.653    49.048     0.200
     3.902    75.160     0.200
     2.716    49.359     0.200
    11.836   235.839     0.200
    12.575   246.453     0.200
     2.664    49.104     0.200
     2.525    47.939     0.200
     2.575    52.339     0.200
     2.643    50.765     0.200
     2.617    49.758     0.200
     2.617    51.745     0.200
     2.884    54.613     0.200
    12.884   250.260     0.200
     2.530    50.015     0.200
     2.552    48.402     0.200
     2.552    51.479     0.200
     2.617    49.804     0.200
     2.617    50.054     0.200
     2.675    53.369     0.200
     2.706    51.674     0.200
     2.706    52.023     0.200
     2.817    53.695     0.200
     2.817    55.774     0.200
     3.022    57.803     0.200
     4.807    90.238     0.200
     4.625    90.193     0.200
     2.554    50.399     0.200
     2.597    49.767     0.200
     2.685    52.597     0.200
     2.510    47.686     0.200
     2.533    49.747     0.200
     2.535    48.169     0.200
     2.553    51.232     0.200
     2.565    50.656     0.200
     2.659    51.880     0.200
     2.670    52.707     0.200
     2.694    50.931     0.200
     2.772    54.005     0.200
     2.864    55.779     0.200
     2.983    57.275     0.200
    19.057   378.273     0.200
     2.519    50.774     0.200
     2.519    50.770     0.200
     2.514    52.074     0.200
     2.539    53.546     0.200
     2.599    49.455     0.200
     2.615    52.223     0.200
     2.630    53.261     0.200
     2.646    55.386     0.200
     2.670    52.108     0.200
     2.728    52.636     0.200
     2.749    53.404     0.200
     2.762    53.861     0.200
     2.831    57.179     0.200
     2.869    55.258     0.200
     3.103    60.636     0.200
     3.746    70.583     0.200
     3.809    74.578     0.200
     4.669    87.794     0.200
     4.694    88.273     0.200
     5.351   101.447     0.200
     6.350   118.580     0.200
    13.009   251.295     0.200
    12.810   251.414     0.200
     3.073    56.452     0.200
     3.125    61.316     0.200
     4.456    89.064     0.200
    13.126   261.361     0.200
     2.909    56.077     0.200
     3.092    59.039     0.200
     3.771    71.015     0.200
     3.925    74.154     0.200
     2.816    53.322     0.200
     5.002    93.977     0.200
    12.535   247.494     0.200
     4.422    87.003     0.200
    13.277   267.251     0.200
    19.339   384.811     0.200
     2.813    49.906     0.200
     4.959    94.078     0.200
    12.840   253.005     0.200
    18.888   375.265     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.180     5.699     0.200
     0.250     6.712     0.200
     1.452    26.802     0.200
     1.972    35.312     0.200
     2.110    37.734     0.200
     2.358    41.164     0.200
     2.499    43.380     0.200
     2.499    44.560     0.200
     4.429    73.514     0.200
     0.168     9.394     0.200
     0.977    20.992     0.200
     1.411    27.672     0.200
     2.031    35.645     0.200
     2.371    40.100     0.200
     2.451    42.674     0.200
     2.451    42.174     0.200
     0.168     6.424     0.200
     1.533    29.106     0.200
     1.440    27.384     0.200
     2.365    40.875     0.200
     2.367    40.858     0.200
     0.154     8.319     0.200
     0.397    11.091     0.200
     1.212    22.803     0.200
     1.377    25.382     0.200
     2.280    38.740     0.200
     0.682    14.130     0.200
     1.012    20.863     0.200
     1.475    27.331     0.200
     1.553    28.597     0.200
     2.000    36.062     0.200
     2.326    39.911     0.200
     2.435    41.536     0.200
     2.586    43.516     0.200
     2.719    45.265     0.200
     0.274     7.832     0.200
     0.677    14.194     0.200
     1.646    30.057     0.200
     1.480    29.129     0.200
     2.461    47.586     0.200
     2.568    46.481     0.200
     4.270    72.091     0.200
     5.113    88.970     0.200
     6.292   108.607     0.200
     0.865    19.507     0.200
     1.023    19.716     0.200
     1.094    22.441     0.200
     2.010    36.251     0.200
     2.176    38.481     0.200
     2.337    39.496     0.200
     1.011    19.621     0.200
     1.185    22.384     0.200
     1.478    26.827     0.200
     1.538    27.479     0.200
     2.040    38.346     0.200
     2.338    46.609     0.200
     2.455    44.502     0.200
     2.612    44.227     0.200
     2.679    49.280     0.200
     3.417    59.886     0.200
     4.581    83.044     0.200
     0.242     6.958     0.200
     1.019    19.896     0.200
     1.287    24.330     0.200
     1.436    26.130     0.200
     0.594    12.925     0.200
     0.997    19.254     0.200
     1.181    21.723     0.200
     1.797    32.273     0.200
     2.554    47.918     0.200
     0.358     9.072     0.200
     1.564    30.678     0.200
     1.655    31.189     0.200
     2.076    38.417     0.200
     2.390    46.892     0.200
     5.891   103.409     0.200
     0.240     8.005     0.200
     0.642    13.971     0.200
     1.594    30.169     0.200
     1.594    31.169     0.200
     1.620    29.535     0.200
     2.128    39.818     0.200
     3.551    65.088     0.200
     0.215     7.365     0.200
     0.285     7.867     0.200
     1.674    32.700     0.200
     1.526    30.029     0.200
     4.377    75.165     0.200
     5.406    97.312     0.200
     0.626    15.310     0.200
     0.553    11.784     0.200
     1.187    21.178     0.200
     1.422    26.262     0.200
     1.422    29.055     0.200
     1.627    29.249     0.200
     2.148    37.382     0.200
     2.180    38.389     0.200
     2.216    38.294     0.200
     2.925    49.126     0.200
     3.140    57.881     0.200
     3.161    54.942     0.200
     4.362    76.906     0.200
     4.249    70.944     0.200
     4.537    75.794     0.200
     0.294     9.047     0.200
     0.372     9.007     0.200
     0.461    10.986     0.200
     0.864    17.439     0.200
     0.929    18.892     0.200
     1.222    22.371     0.200
     1.675    30.140     0.200
     1.686    32.550     0.200
     1.724    32.827     0.200
     1.788    34.061     0.200
     1.817    36.828     0.200
     1.918    35.089     0.200
     2.170    39.315     0.200
     2.135    40.397     0.200
     2.236    45.069     0.200
     2.289    42.906     0.200
     2.309    46.115     0.200
     2.468    47.063     0.200
     2.595    46.248     0.200
     2.632    47.690     0.200
     2.652    46.274     0.200
     2.641    45.081     0.200
     4.087    69.693     0.200
     4.825    81.357     0.200
     0.190     6.776     0.200
     0.167     6.437     0.200
     0.249     7.514     0.200
     0.811    16.389     0.200
     1.499    28.564     0.200
     1.611    30.034     0.200
     1.618    30.942     0.200
     1.883    33.696     0.200
     1.922    34.977     0.200
     2.080    36.212     0.200
     2.156    38.374     0.200
     2.162    37.679     0.200
     2.177    42.377     0.200
     2.501    45.494     0.200
     2.502    45.801     0.200
     2.504    45.124     0.200
     2.588    44.702     0.200
     2.588    46.117     0.200
     2.601    44.315     0.200
     2.616    44.445     0.200
     2.634    47.064     0.200
     2.657    46.788     0.200
     2.687    48.378     0.200
     2.692    46.087     0.200
     2.715    47.883     0.200
     2.878    50.565     0.200
     2.897    52.369     0.200
     3.188    54.277     0.200
     3.244    54.685     0.200
     4.238    70.252     0.200
     4.616    75.260     0.200
     5.086    92.130     0.200
     7.407   123.877     0.200
     8.082   144.129     0.200
     0.871    17.682     0.200
     0.824    16.689     0.200
     1.197    23.245     0.200
     1.576    28.682     0.200
     1.810    34.133     0.200
     1.987    37.048     0.200
     1.864    39.214     0.200
     2.289    46.237     0.200
     2.289    46.241     0.200
     2.403    43.491     0.200
     2.529    45.547     0.200
     2.536    44.650     0.200
     2.682    46.672     0.200
     2.599    47.207     0.200
     2.820    49.129     0.200
     2.850    49.668     0.200
     2.850    49.474     0.200
     2.857    53.041     0.200
     2.871    51.975     0.200
     2.892    50.551     0.200
     2.957    50.778     0.200
     2.974    51.067     0.200
     2.984    51.737     0.200
     3.032    52.471     0.200
     3.131    54.637     0.200
     3.316    58.076     0.200
     3.363    60.544     0.200
     3.387    58.015     0.200
     4.275    73.543     0.200
     4.443    76.223     0.200
     5.485   102.743     0.200
     6.112   110.861     0.200
     0.110    10.103     0.200
     0.323    11.100     0.200
     0.698    15.865     0.200
     0.726    15.704     0.200
     0.807    16.727     0.200
     0.819    17.159     0.200
     1.011    19.407     0.200
     0.957    19.101     0.200
     0.991    20.171     0.200
     1.393    27.221     0.200
     1.596    30.440     0.200
     1.735    32.574     0.200
     1.811    33.069     0.200
     2.016    35.697     0.200
     2.210    39.456     0.200
     2.445    42.978     0.200
     2.450    44.208     0.200
     2.697    46.562     0.200
     3.690    61.066     0.200
     3.731    61.507     0.200
     4.508    79.297     0.200
     0.421     9.676     0.200
     1.268    23.284     0.200
     1.724    31.253     0.200
     1.731    33.073     0.200
     1.818    32.517     0.200
     1.780    34.308     0.200
     1.780    32.308     0.200
     1.852    34.512     0.200
     1.971    37.482     0.200
     2.224    41.119     0.200
     2.286    40.038     0.200
     2.555    44.583     0.200
     2.566    44.373     0.200
     2.598    45.004     0.200
     2.601    46.128     0.200
     2.617    44.841     0.200
     2.619    45.328     0.200
     2.671    47.037     0.200
     2.670    47.046     0.200
     2.670    48.137     0.200
     2.671    45.936     0.200
     2.694    47.230     0.200
     2.694    46.127     0.200
     2.676    48.260     0.200
     2.665    47.542     0.200
     2.716    49.638     0.200
     2.651    45.770     0.200
     2.650    45.773     0.200
     2.745    47.569     0.200
     2.658    45.901     0.200
     2.703    46.458     0.200
     2.678    46.196     0.200
     2.791    49.052     0.200
     2.809    48.557     0.200
     2.839    48.342     0.200
     2.938    50.042     0.200
     3.106    52.241     0.200
     3.164    56.562     0.200
     3.172    56.184     0.200
     3.420    63.929     0.200
     3.420    60.908     0.200
     3.645    60.687     0.200
     3.646    60.677     0.200
     4.887    88.357     0.200
     4.902    87.349     0.200
     4.971    91.248     0.200
     5.221    86.662     0.200
     5.134    84.366     0.200
     6.008   105.671     0.200
     0.231     9.946     0.200
     0.342    10.566     0.200
     0.360    11.314     0.200
     0.366    11.136     0.200
     0.438    12.237     0.200
     0.853    17.653     0.200
     1.186    22.681     0.200
     1.316    26.123     0.200
     1.378    26.410     0.200
     1.708    31.492     0.200
     1.921    34.310     0.200
     1.986    35.710     0.200
     2.188    40.992     0.200
     2.193    39.454     0.200
     2.193    41.869     0.200
     2.259    39.395     0.200
     2.288    43.359     0.200
     2.322    41.529     0.200
     2.468    45.783     0.200
     2.500    47.112     0.200
     2.560    45.723     0.200
     2.569    44.855     0.200
     2.693    49.076     0.200
     2.783    46.292     0.200
     2.860    48.082     0.200
     3.249    56.663     0.200
     0.226     7.145     0.200
     0.334     9.374     0.200
     0.753    17.175     0.200
     1.036    19.745     0.200
     1.232    21.835     0.200
     1.245    22.949     0.200
     1.717    31.707     0.200
     1.744    30.857     0.200
     2.250    38.723     0.200
     2.739    47.799     0.200
     3.161    55.454     0.200
     0.019    10.336     0.200
     0.255     9.352     0.200
     0.401    12.027     0.200
     0.616    14.432     0.200
     1.058    20.291     0.200
     0.047    10.159     0.200
     0.268    10.593     0.200
     0.734    16.279     0.200
     0.865    18.343     0.200
     1.017    20.773     0.200
     1.177    23.060     0.200
     1.300    25.878     0.200
     1.338    25.890     0.200
     1.371    26.292     0.200
     1.630    31.858     0.200
     1.583    29.434     0.200
     1.703    32.813     0.200
     1.840    32.537     0.200
     1.887    33.872     0.200
     1.891    34.314     0.200
     1.950    35.594     0.200
     2.235    42.734     0.200
     2.228    43.937     0.200
     2.309    40.841     0.200
     2.650    49.281     0.200
     2.820    52.247     0.200
     4.429    73.256     0.200
     4.481    74.433     0.200
     0.258     9.828     0.200
     0.319    10.927     0.200
     0.387    11.713     0.200
     0.391    11.191     0.200
     0.957    18.686     0.200
     1.151    22.296     0.200
     1.319    26.625     0.200
     1.333    25.612     0.200
     1.449    26.133     0.200
     1.952    34.387     0.200
     2.151    37.662     0.200
     2.160    36.811     0.200
     2.196    39.372     0.200
     2.201    40.566     0.200
     2.243    40.046     0.200
     2.249    42.066     0.200
     2.249    38.819     0.200
     2.284    40.400     0.200
     2.286    40.868     0.200
     2.288    39.990     0.200
     2.295    40.678     0.200
     2.313    42.346     0.200
     2.326    40.230     0.200
     2.343    41.046     0.200
     2.437    43.810     0.200
     2.490    43.057     0.200
     2.589    43.544     0.200
     2.732    45.460     0.200
     2.796    46.436     0.200
     2.972    50.351     0.200
     3.355    55.081     0.200
     3.542    60.387     0.200
     0.141     6.397     0.200
     0.283     7.644     0.200
     0.536    11.846     0.200
     0.630    14.772     0.200
     0.758    15.531     0.200
     1.557    29.244     0.200
     1.595    28.817     0.200
     1.636    30.061     0.200
     1.637    30.632     0.200
     1.945    35.412     0.200
     2.150    38.241     0.200
     2.152    38.378     0.200
     2.170    38.568     0.200
     2.192    37.850     0.200
     2.274    40.309     0.200
     2.474    44.523     0.200
     2.498    43.488     0.200
     2.539    46.283     0.200
     2.598    45.159     0.200
     2.611    48.094     0.200
     2.612    46.119     0.200
     2.738    47.793     0.200
     2.837    49.207     0.200
     2.854    48.630     0.200
     2.916    50.483     0.200
     3.585    59.843     0.200
     4.223    71.471     0.200
     8.094   138.483     0.200
     0.170     9.889     0.200
     0.210     9.680     0.200
     0.207    10.101     0.200
     0.390    11.752     0.200
     0.562    14.087     0.200
     0.778    16.452     0.200
     0.872    17.602     0.200
     1.280    24.590     0.200
     1.326    24.758     0.200
     1.619    28.900     0.200
     1.843    33.874     0.200
     1.899    35.826     0.200
     1.926    35.225     0.200
     2.100    37.512     0.200
     2.197    39.003     0.200
     2.222    41.036     0.200
     2.227    43.555     0.200
     2.235    43.894     0.200
     2.245    43.330     0.200
     2.259    43.595     0.200
     2.273    42.866     0.200
     2.298    40.078     0.200
     2.334    44.270     0.200
     2.461    45.873     0.200
     2.867    47.873     0.200
     2.884    48.387     0.200
     3.755    64.254     0.200
     4.361    78.443     0.200
     0.637    13.627     0.200
     1.619    30.173     0.200
     1.772    37.006     0.200
     2.816    51.422     0.200
     4.198    72.782     0.200
     0.239     9.045     0.200
     0.256     9.717     0.200
     0.379    10.437     0.200
     0.528    11.958     0.200
     0.828    17.106     0.200
     1.199    24.631     0.200
     1.325    26.125     0.200
     1.843    33.745     0.200
     1.839    32.734     0.200
     1.876    33.271     0.200
     2.273    38.557     0.200
     2.300    39.622     0.200
     2.815    47.712     0.200
     3.240    54.590     0.200
     0.169     7.403     0.200
     0.435    10.894     0.200
     0.885    18.320     0.200
     1.362    25.252     0.200
     1.485    27.360     0.200
     1.564    28.434     0.200
     1.603    30.561     0.200
     1.603    30.209     0.200
     1.729    34.199     0.200
     1.892    34.004     0.200
     2.131    41.257     0.200
     2.197    39.984     0.200
     2.228    40.593     0.200
     2.242    39.481     0.200
     2.373    42.862     0.200
     2.400    42.170     0.200
     2.481    42.727     0.200
     2.537    44.651     0.200
     2.545    47.540     0.200
     2.601    44.991     0.200
     2.636    44.905     0.200
     2.681    48.763     0.200
     2.747    48.817     0.200
     2.770    47.197     0.200
     2.778    46.819     0.200
     2.820    48.220     0.200
     2.851    50.487     0.200
     2.904    49.310     0.200
     3.021    50.467     0.200
     3.123    55.501     0.200
     3.195    53.186     0.200
     3.273    58.097     0.200
     3.600    61.427     0.200
     4.100    70.344     0.200
     4.157    70.748     0.200
     0.122     7.185     0.200
     0.367    10.408     0.200
     0.510    10.496     0.200
     0.859    17.952     0.200
     1.412    27.639     0.200
     1.564    31.128     0.200
     1.651    32.092     0.200
     2.057    37.861     0.200
     2.151    37.517     0.200
     2.176    37.575     0.200
     2.304    41.645     0.200
     2.398    41.627     0.200
     2.440    41.592     0.200
     2.465    43.100     0.200
     2.493    44.484     0.200
     2.510    43.351     0.200
     2.528    47.199     0.200
     2.528    47.194     0.200
     2.545    43.486     0.200
     2.545    44.569     0.200
     2.591    44.446     0.200
     2.596    46.270     0.200
     2.611    44.772     0.200
     2.648    47.776     0.200
     2.679    45.503     0.200
     2.687    46.290     0.200
     2.729    49.018     0.200
     2.983    53.346     0.200
     3.055    54.034     0.200
     3.090    55.366     0.200
     3.509    58.031     0.200
     3.510    58.021     0.200
     0.302     7.263     0.200
     0.519    10.980     0.200
     0.553    13.117     0.200
     0.988    20.268     0.200
     1.521    27.629     0.200
     1.740    33.060     0.200
     1.721    33.693     0.200
     1.721    33.584     0.200
     1.846    36.306     0.200
     2.275    42.780     0.200
     2.342    46.112     0.200
     2.617    46.699     0.200
     2.623    45.662     0.200
     2.655    49.479     0.200
     2.662    49.486     0.200
     2.665    48.866     0.200
     2.670    47.725     0.200
     2.690    46.873     0.200
     2.697    49.409     0.200
     2.707    48.658     0.200
     2.720    49.840     0.200
     2.748    49.518     0.200
     2.776    50.772     0.200
     2.795    50.872     0.200
     2.830    51.211     0.200
     2.856    50.438     0.200
     2.930    49.992     0.200
     3.000    53.163     0.200
     2.991    54.546     0.200
     3.139    56.407     0.200
     3.218    55.380     0.200
     3.211    59.404     0.200
     3.241    59.474     0.200
     4.274    70.242     0.200
     0.288     8.925     0.200
     1.303    26.082     0.200
     1.558    27.842     0.200
     1.558    28.601     0.200
     1.671    30.603     0.200
     1.931    33.621     0.200
     2.354    40.295     0.200
     2.354    40.854     0.200
     2.380    41.371     0.200
     2.391    41.280     0.200
     2.421    45.065     0.200
     2.473    42.727     0.200
     2.534    45.522     0.200
     2.534    45.524     0.200
     2.596    43.928     0.200
     2.654    44.919     0.200
     2.791    47.135     0.200
     2.811    51.021     0.200
     3.748    64.338     0.200
     0.103     7.242     0.200
     0.429     9.869     0.200
     0.651    14.056     0.200
     0.724    15.748     0.200
     1.453    26.306     0.200
     1.588    30.498     0.200
     1.596    29.994     0.200
     2.167    42.563     0.200
     2.393    47.332     0.200
     2.445    44.290     0.200
     2.468    46.453     0.200
     2.483    46.346     0.200
     2.503    46.043     0.200
     2.500    44.083     0.200
     2.517    43.219     0.200
     2.620    48.286     0.200
     2.720    47.240     0.200
     2.750    48.610     0.200
     4.371    70.954     0.200
     4.448    73.152     0.200
     4.838    78.906     0.200
     6.473   108.181     0.200
     0.293     8.683     0.200
     0.610    12.998     0.200
     1.459    26.879     0.200
     1.459    28.079     0.200
     1.570    29.322     0.200
     1.589    31.795     0.200
     1.661    30.973     0.200
     1.771    32.496     0.200
     2.084    39.136     0.200
     2.120    39.549     0.200
     2.127    38.305     0.200
     2.144    40.033     0.200
     2.263    44.775     0.200
     2.378    46.573     0.200
     2.417    41.905     0.200
     2.430    45.967     0.200
     2.445    47.983     0.200
     2.452    47.332     0.200
     2.456    45.509     0.200
     2.467    46.866     0.200
     2.478    47.397     0.200
     2.486    45.310     0.200
     2.491    44.585     0.200
     2.493    45.222     0.200
     2.497    48.503     0.200
     2.508    45.879     0.200
     2.509    45.875     0.200
     2.550    47.225     0.200
     2.549    46.169     0.200
     2.595    47.353     0.200
     2.682    46.767     0.200
     2.772    51.943     0.200
     2.819    50.486     0.200
     2.978    51.004     0.200
     3.046    54.780     0.200
     3.046    54.784     0.200
     3.086    57.758     0.200
     3.274    58.047     0.200
     3.274    55.388     0.200
     3.518    63.266     0.200
     3.519    63.256     0.200
     4.369    71.151     0.200
     4.407    74.021     0.200
     5.589    90.770     0.200
     0.260     8.497     0.200
     0.577    13.444     0.200
     1.426    26.092     0.200
     1.426    28.252     0.200
     1.504    28.596     0.200
     1.548    30.343     0.200
     1.635    29.280     0.200
     1.786    31.704     0.200
     2.070    38.579     0.200
     2.054    38.683     0.200
     2.054    41.003     0.200
     2.081    39.750     0.200
     2.096    38.864     0.200
     2.198    40.366     0.200
     2.260    43.052     0.200
     2.319    47.259     0.200
     2.350    44.386     0.200
     2.370    47.929     0.200
     2.385    47.872     0.200
     2.393    47.366     0.200
     2.390    46.888     0.200
     2.400    44.608     0.200
     2.400    45.378     0.200
     2.426    45.697     0.200
     2.434    49.416     0.200
     2.435    46.863     0.200
     2.435    47.493     0.200
     2.449    48.914     0.200
     2.484    48.700     0.200
     2.754    51.007     0.200
     2.754    51.427     0.200
     2.842    50.948     0.200
     2.993    52.277     0.200
     3.047    53.012     0.200
     3.224    60.252     0.200
     3.452    60.344     0.200
     3.453    60.333     0.200
     4.323    75.229     0.200
     4.484    73.454     0.200
     5.511    89.290     0.200
     0.100     7.805     0.200
     0.110     7.635     0.200
     0.541    12.859     0.200
     0.591    13.266     0.200
     1.401    27.073     0.200
     1.469    26.389     0.200
     1.613    29.810     0.200
     1.890    37.158     0.200
     2.033    35.251     0.200
     2.306    39.346     0.200
     2.486    42.698     0.200
     2.567    43.971     0.200
     2.963    50.368     0.200
     0.137     4.716     0.200
     0.459     9.956     0.200
     0.634    13.490     0.200
     0.707    15.173     0.200
     0.873    17.782     0.200
     1.324    25.977     0.200
     1.725    32.996     0.200
     1.789    35.056     0.200
     1.940    38.162     0.200
     2.042    39.668     0.200
     2.148    43.261     0.200
     2.155    42.333     0.200
     2.200    43.055     0.200
     2.211    42.835     0.200
     2.219    40.630     0.200
     2.222    44.061     0.200
     2.237    40.285     0.200
     2.250    44.499     0.200
     2.256    41.448     0.200
     2.261    43.214     0.200
     2.270    44.547     0.200
     2.366    47.209     0.200
     2.458    45.046     0.200
     0.303     8.098     0.200
     0.515    11.784     0.200
     0.659    14.432     0.200
     0.739    15.750     0.200
     1.226    23.974     0.200
     1.437    28.327     0.200
     1.583    31.558     0.200
     1.648    32.045     0.200
     1.784    33.781     0.200
     1.972    38.365     0.200
     2.021    39.871     0.200
     2.178    38.991     0.200
     2.198    42.736     0.200
     2.204    40.231     0.200
     2.422    47.223     0.200
     2.475    50.058     0.200
     2.493    49.780     0.200
     2.493    50.334     0.200
     2.499    50.645     0.200
     2.514    46.781     0.200
     2.527    47.075     0.200
     2.544    45.891     0.200
     2.624    44.920     0.200
     2.754    51.481     0.200
     2.944    50.834     0.200
     3.127    56.488     0.200
     4.400    71.645     0.200
     4.734    85.637     0.200
     0.264     9.684     0.200
     0.595    13.390     0.200
     0.565    12.818     0.200
     1.163    21.934     0.200
     1.153    22.567     0.200
     1.378    26.225     0.200
     1.603    29.850     0.200
     1.627    31.609     0.200
     1.913    38.192     0.200
     2.383    40.755     0.200
     2.497    44.214     0.200
     2.515    46.319     0.200
     2.882    50.692     0.200
     3.196    59.475     0.200
     5.089    93.117     0.200
     5.239    97.202     0.200
     5.716   104.969     0.200
     0.237     8.219     0.200
     0.424    10.533     0.200
     0.464    11.109     0.200
     1.418    27.611     0.200
     1.400    25.693     0.200
     1.586    29.193     0.200
     1.586    30.423     0.200
     1.584    28.918     0.200
     2.109    37.819     0.200
     2.177    39.138     0.200
     2.235    39.890     0.200
     2.359    40.204     0.200
     2.434    42.777     0.200
     2.484    43.059     0.200
     2.470    42.723     0.200
     2.496    43.918     0.200
     2.506    42.805     0.200
     2.564    44.135     0.200
     2.563    44.160     0.200
     2.592    43.763     0.200
     2.705    46.346     0.200
     2.997    49.995     0.200
     2.961    52.926     0.200
     3.113    51.587     0.200
     3.526    60.400     0.200
     3.525    60.410     0.200
     4.257    69.264     0.200
     0.275    10.036     0.200
     0.341    10.124     0.200
     0.499    12.375     0.200
     0.850    16.936     0.200
     1.224    22.802     0.200
     1.233    23.270     0.200
     1.325    24.446     0.200
     1.364    26.243     0.200
     1.364    25.185     0.200
     0.252     8.102     0.200
     0.415    10.260     0.200
     1.114    20.058     0.200
     1.408    26.431     0.200
     1.519    29.357     0.200
     1.578    29.707     0.200
     1.578    29.441     0.200
     1.587    31.316     0.200
     1.920    35.324     0.200
     2.102    41.663     0.200
     2.126    36.921     0.200
     2.179    37.967     0.200
     2.224    41.162     0.200
     2.496    42.540     0.200
     2.507    43.742     0.200
     2.568    44.118     0.200
     2.568    45.363     0.200
     2.568    45.105     0.200
     2.595    44.175     0.200
     2.634    48.891     0.200
     2.709    46.600     0.200
     2.836    47.513     0.200
     2.991    51.349     0.200
     2.973    54.879     0.200
     3.067    52.676     0.200
     0.331     8.486     0.200
     0.788    16.152     0.200
     1.003    19.119     0.200
     1.210    22.850     0.200
     1.762    31.979     0.200
     1.898    34.173     0.200
     2.232    38.474     0.200
     2.491    42.851     0.200
     2.491    42.849     0.200
     2.622    45.124     0.200
     2.647    45.387     0.200
     2.702    45.870     0.200
     0.210     9.855     0.200
     0.209     9.812     0.200
     0.589    14.423     0.200
     0.879    18.047     0.200
     1.029    20.375     0.200
     1.322    25.339     0.200
     1.514    27.937     0.200
     1.606    28.487     0.200
     1.938    33.330     0.200
     2.082    37.360     0.200
     2.192    38.133     0.200
     2.247    38.591     0.200
     2.249    39.499     0.200
     2.276    40.749     0.200
     2.311    40.040     0.200
     2.333    39.491     0.200
     2.363    41.385     0.200
     2.383    41.606     0.200
     2.420    42.669     0.200
     2.427    42.783     0.200
     2.581    44.626     0.200
     2.552    45.198     0.200
     2.730    46.827     0.200
     0.289     7.419     0.200
     0.307     7.484     0.200
     0.465     9.597     0.200
     0.869    18.809     0.200
     1.380    26.503     0.200
     1.935    36.739     0.200
     1.970    37.136     0.200
     2.109    40.474     0.200
     2.210    41.656     0.200
     2.196    41.384     0.200
     2.257    43.471     0.200
     2.270    43.335     0.200
     2.289    42.783     0.200
     2.299    41.397     0.200
     2.309    43.704     0.200
     2.330    44.442     0.200
     2.331    44.395     0.200
     2.353    41.899     0.200
     2.362    44.856     0.200
     2.361    41.872     0.200
     2.351    44.106     0.200
     2.327    46.280     0.200
     2.404    47.309     0.200
     2.413    44.987     0.200
     2.495    47.655     0.200
     2.503    46.928     0.200
     2.576    47.960     0.200
     2.630    48.790     0.200
     2.672    49.334     0.200
     2.835    50.838     0.200
     2.818    52.461     0.200
     2.907    54.483     0.200
     2.947    53.677     0.200
     3.073    56.162     0.200
     3.325    56.811     0.200
     3.815    71.214     0.200
     4.112    69.871     0.200
     4.355    73.498     0.200
     0.148     8.715     0.200
     0.181     9.188     0.200
     0.635    13.705     0.200
     0.935    18.947     0.200
     1.047    20.607     0.200
     1.193    22.667     0.200
     1.372    25.761     0.200
     1.571    29.655     0.200
     1.668    31.105     0.200
     1.991    34.954     0.200
     2.222    38.891     0.200
     2.399    43.695     0.200
     2.435    42.725     0.200
     2.441    41.962     0.200
     2.584    44.233     0.200
     2.640    46.461     0.200
     0.228     9.954     0.200
     0.309    10.934     0.200
     0.480    12.422     0.200
     0.844    18.177     0.200
     1.080    21.478     0.200
     1.302    24.366     0.200
     1.825    32.656     0.200
     2.253    38.622     0.200
     2.277    38.478     0.200
     2.316    39.439     0.200
     2.415    40.661     0.200
     2.480    42.598     0.200
     2.544    42.642     0.200
     2.755    47.253     0.200
     2.836    49.327     0.200
     0.364     7.123     0.200
     1.122    23.504     0.200
     1.300    26.162     0.200
     1.765    33.805     0.200
     1.813    34.922     0.200
     1.845    36.789     0.200
     1.896    36.329     0.200
     2.026    38.407     0.200
     2.544    45.815     0.200
     2.546    45.970     0.200
     2.547    46.408     0.200
     2.615    47.128     0.200
     2.726    48.854     0.200
     2.782    49.993     0.200
     0.307    10.560     0.200
     0.375    11.328     0.200
     0.499    12.762     0.200
     0.769    17.068     0.200
     0.879    17.953     0.200
     1.149    22.839     0.200
     1.244    23.599     0.200
     1.332    25.346     0.200
     1.538    28.513     0.200
     1.788    34.021     0.200
     1.834    32.897     0.200
     2.048    36.345     0.200
     2.079    37.801     0.200
     2.120    36.340     0.200
     2.136    37.074     0.200
     2.155    39.772     0.200
     2.162    37.894     0.200
     2.165    39.653     0.200
     2.195    37.715     0.200
     2.220    40.990     0.200
     2.225    39.292     0.200
     2.268    39.099     0.200
     2.271    38.727     0.200
     2.494    44.316     0.200
     2.545    45.477     0.200
     2.761    46.374     0.200
     2.771    50.375     0.200
     0.492    11.621     0.200
     0.900    18.899     0.200
     1.585    30.538     0.200
     1.604    32.842     0.200
     2.110    38.368     0.200
     2.195    40.250     0.200
     2.226    39.407     0.200
     2.357    41.887     0.200
     2.427    42.067     0.200
     2.492    42.991     0.200
     2.521    45.027     0.200
     2.408    41.222     0.200
     2.524    44.654     0.200
     2.534    44.830     0.200
     2.555    45.667     0.200
     2.570    44.757     0.200
     2.554    44.921     0.200
     2.585    46.998     0.200
     2.585    46.192     0.200
     2.613    46.408     0.200
     2.613    46.998     0.200
     2.629    46.057     0.200
     2.631    46.567     0.200
     2.638    46.699     0.200
     2.650    46.680     0.200
     2.689    47.251     0.200
     2.720    47.366     0.200
     2.726    47.440     0.200
     2.799    48.804     0.200
     2.854    48.897     0.200
     2.883    49.872     0.200
     2.999    50.485     0.200
     3.132    52.827     0.200
     3.108    54.157     0.200
     3.098    52.410     0.200
     3.548    59.933     0.200
     0.575    13.295     0.200
     1.338    26.621     0.200
     1.441    26.708     0.200
     1.747    32.807     0.200
     1.825    32.615     0.200
     1.866    34.338     0.200
     1.893    33.470     0.200
     2.034    36.428     0.200
     2.381    41.049     0.200
     2.454    41.945     0.200
     2.596    44.946     0.200
     2.606    45.495     0.200
     2.606    45.500     0.200
     2.669    46.777     0.200
     2.693    46.466     0.200
     2.740    45.923     0.200
     2.689    46.514     0.200
     2.752    46.468     0.200
     2.715    46.211     0.200
     2.818    47.669     0.200
     2.832    47.940     0.200
     2.855    48.564     0.200
     2.858    49.198     0.200
     2.878    48.964     0.200
     2.908    48.615     0.200
     2.946    50.173     0.200
     2.951    50.110     0.200
     2.964    49.954     0.200
EOF
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
