#!/bin/bash
gmt begin acapulco7.51_tt5_local pdf,ps
proj=-JX18/12
reg=-R0/4.0/0/120
gmt basemap $proj $reg -Bxa1f0.1+l'Epicentral Distance (deg)' -Bya50f10+l'Travel Time (s)' -BWeSn+t'Local Distance acapulco7.51'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0  0.000
  1.0 90.000
EOF
# Pn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.600    12.836
     0.700    14.234
     0.800    15.633
     0.900    17.031
     1.000    18.430
     1.100    19.828
     1.200    21.227
     1.300    22.626
     1.400    24.024
     1.500    25.423
     1.600    26.821
     1.700    28.220
     1.800    29.618
     1.900    31.017
     2.000    32.416
     2.100    33.814
     2.200    35.213
     2.300    36.611
     2.400    38.010
     2.500    39.409
     2.600    40.807
     2.700    42.206
     2.800    43.604
     2.900    45.003
     3.000    46.401
     3.100    47.800
     3.200    49.198
     3.300    50.597
     3.400    51.995
     3.500    53.393
     3.600    54.791
     3.700    56.189
     3.800    57.587
     3.900    58.985
     4.000    60.383
EOF
# Pn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    52.791 Pn
EOF
# Pb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Pg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100     6.208
     0.200     6.958
     0.300     8.053
     0.400     9.368
     0.500    10.820
     0.600    12.357
     0.700    13.946
     0.800    15.570
     0.900    17.215
     1.000    18.875
     1.100    20.544
     1.200    22.221
     1.300    23.903
     1.400    25.589
     1.500    27.277
     1.600    28.968
     1.700    30.661
     1.800    32.354
     1.900    34.050
     2.000    35.746
     2.100    37.442
     2.200    39.140
     2.300    40.838
     2.400    42.536
     2.500    44.235
     2.600    45.934
     2.700    47.633
     2.800    49.333
     2.900    51.033
     3.000    52.733
     3.100    54.433
     3.200    56.133
     3.300    57.834
     3.400    59.534
     3.500    61.235
     3.600    62.936
     3.700    64.636
     3.800    66.337
     3.900    68.038
     4.000    69.739
EOF
# Pg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600    61.936 Pg
EOF
# P_ TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    47.500
     2.600    49.400
     2.700    51.300
     2.800    53.200
     2.900    55.100
     3.000    57.000
     3.100    58.900
     3.200    60.800
     3.300    62.700
     3.400    64.600
     3.500    66.500
     3.600    68.400
     3.700    70.300
     3.800    72.200
     3.900    74.100
     4.000    76.000
EOF
# P_ label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600    70.400 P_
EOF
# Sn TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,green << EOF
     0.600    21.673
     0.700    24.139
     0.800    26.605
     0.900    29.071
     1.000    31.537
     1.100    34.004
     1.200    36.470
     1.300    38.936
     1.400    41.402
     1.500    43.868
     1.600    46.334
     1.700    48.801
     1.800    51.267
     1.900    53.733
     2.000    56.199
     2.100    58.665
     2.200    61.131
     2.300    63.597
     2.400    66.064
     2.500    68.530
     2.600    70.996
     2.700    73.462
     2.800    75.928
     2.900    78.394
     3.000    80.859
     3.100    83.324
     3.200    85.789
     3.300    88.254
     3.400    90.719
     3.500    93.184
     3.600    95.649
     3.700    98.114
     3.800   100.579
     3.900   103.044
     4.000   105.509
EOF
# Sn label
gmt text $proj $reg -F+f10p,Helvetica,green+a0.+jTL << EOF
     3.600    93.649 Sn
EOF
# Sb TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,blue -Vq << EOF
EOF
# Sg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,red << EOF
     0.100    10.437
     0.200    11.700
     0.300    13.542
     0.400    15.756
     0.500    18.201
     0.600    20.790
     0.700    23.469
     0.800    26.206
     0.900    28.981
     1.000    31.781
     1.100    34.599
     1.200    37.429
     1.300    40.268
     1.400    43.113
     1.500    45.963
     1.600    48.818
     1.700    51.675
     1.800    54.534
     1.900    57.396
     2.000    60.259
     2.100    63.124
     2.200    65.989
     2.300    68.856
     2.400    71.723
     2.500    74.591
     2.600    77.460
     2.700    80.328
     2.800    83.198
     2.900    86.068
     3.000    88.938
     3.100    91.808
     3.200    94.679
     3.300    97.550
     3.400   100.421
     3.500   103.292
     3.600   106.163
     3.700   109.035
     3.800   111.906
     3.900   114.778
     4.000   117.650
EOF
# Sg label
gmt text $proj $reg -F+f10p,Helvetica,red+a0.+jTL << EOF
     3.600   105.163 Sg
EOF
# Lg TT curve at hypocentroid depth
gmt plot $proj $reg -Wthick,cyan << EOF
     2.500    78.750
     2.600    81.900
     2.700    85.050
     2.800    88.200
     2.900    91.350
     3.000    94.500
     3.100    97.650
     3.200   100.800
     3.300   103.950
     3.400   107.100
     3.500   110.250
     3.600   113.400
     3.700   116.550
     3.800   119.700
     3.900   122.850
     4.000   126.000
EOF
# Lg label
gmt text $proj $reg -F+f10p,Helvetica,cyan+a0.+jBR << EOF
     3.600   115.400 Lg
EOF
# Pn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.900    20.216
     1.000    21.615
     1.100    23.013
     1.200    24.412
     1.300    25.810
     1.400    27.209
     1.500    28.607
     1.600    30.006
     1.700    31.405
     1.800    32.803
     1.900    34.202
     2.000    35.600
     2.100    36.999
     2.200    38.397
     2.300    39.796
     2.400    41.194
     2.500    42.593
     2.600    43.992
     2.700    45.390
     2.800    46.789
     2.900    48.187
     3.000    49.586
     3.100    50.984
     3.200    52.383
     3.300    53.782
     3.400    55.180
     3.500    56.579
     3.600    57.977
     3.700    59.375
     3.800    60.774
     3.900    62.172
     4.000    63.570
EOF
# Pb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     2.101
     0.200     3.929
     0.300     5.813
     0.400     7.714
     0.500     9.621
     0.600    11.531
     0.700    13.442
     0.800    15.355
     0.900    17.269
     1.000    19.183
     1.100    21.098
     1.200    23.013
     1.300    24.908
     1.400    26.613
     1.500    28.318
     1.600    30.023
     1.700    31.729
     1.800    33.434
     1.900    35.139
     2.000    36.845
     2.100    38.550
     2.200    40.255
     2.300    41.960
     2.400    43.666
     2.500    45.371
     2.600    47.076
     2.700    48.781
     2.800    50.486
     2.900    52.191
     3.000    53.896
     3.100    55.600
     3.200    57.305
     3.300    59.010
     3.400    60.715
     3.500    62.420
     3.600    64.125
     3.700    65.830
     3.800    67.534
     3.900    69.239
     4.000    70.943
EOF
# Sn TT curve at minimum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     1.000    36.469
     1.100    38.935
     1.200    41.401
     1.300    43.868
     1.400    46.334
     1.500    48.800
     1.600    51.266
     1.700    53.732
     1.800    56.198
     1.900    58.665
     2.000    61.131
     2.100    63.597
     2.200    66.063
     2.300    68.529
     2.400    70.995
     2.500    73.461
     2.600    75.928
     2.700    78.394
     2.800    80.860
     2.900    83.326
     3.000    85.792
     3.100    88.258
     3.200    90.724
     3.300    93.190
     3.400    95.655
     3.500    98.120
     3.600   100.585
     3.700   103.050
     3.800   105.516
     3.900   107.981
     4.000   110.446
EOF
# Sb TT curve at minimum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at minimum depth
gmt plot $proj $reg -Wthin,red,- << EOF
     0.100     3.523
     0.200     6.585
     0.300     9.745
     0.400    12.931
     0.500    16.127
     0.600    19.329
     0.700    22.534
     0.800    25.740
     0.900    28.948
     1.000    32.157
     1.100    35.366
     1.200    38.576
     1.300    41.786
     1.400    44.769
     1.500    47.648
     1.600    50.527
     1.700    53.406
     1.800    56.285
     1.900    59.164
     2.000    62.043
     2.100    64.922
     2.200    67.801
     2.300    70.680
     2.400    73.559
     2.500    76.438
     2.600    79.317
     2.700    82.195
     2.800    85.074
     2.900    87.952
     3.000    90.831
     3.100    93.709
     3.200    96.587
     3.300    99.466
     3.400   102.344
     3.500   105.223
     3.600   108.102
     3.700   110.979
     3.800   113.857
     3.900   116.735
     4.000   119.613
EOF
# Pn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100     8.960
     0.200     9.412
     0.300    10.117
     0.400    11.022
     0.500    12.075
     0.600    13.235
     0.700    14.468
     0.800    15.751
     0.900    17.067
     1.000    18.404
     1.100    19.757
     1.200    21.119
     1.300    22.489
     1.400    23.864
     1.500    25.243
     1.600    26.625
     1.700    28.009
     1.800    29.395
     1.900    30.782
     2.000    32.170
     2.100    33.560
     2.200    34.950
     2.300    36.341
     2.400    37.732
     2.500    39.124
     2.600    40.516
     2.700    41.909
     2.800    43.302
     2.900    44.695
     3.000    46.089
     3.100    47.482
     3.200    48.876
     3.300    50.270
     3.400    51.664
     3.500    53.058
     3.600    54.452
     3.700    55.847
     3.800    57.241
     3.900    58.636
     4.000    60.030
EOF
# Pb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Pg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Sn TT curve at maximum depth
gmt plot $proj $reg -Wthin,green,- << EOF
     0.100    15.258
     0.200    16.032
     0.300    17.241
     0.400    18.795
     0.500    20.610
     0.600    22.614
     0.700    24.753
     0.800    26.986
     0.900    29.283
     1.000    31.624
     1.100    33.996
     1.200    36.388
     1.300    38.796
     1.400    41.215
     1.500    43.641
     1.600    46.074
     1.700    48.510
     1.800    50.951
     1.900    53.394
     2.000    55.840
     2.100    58.288
     2.200    60.737
     2.300    63.187
     2.400    65.639
     2.500    68.091
     2.600    70.544
     2.700    72.998
     2.800    75.452
     2.900    77.906
     3.000    80.361
     3.100    82.817
     3.200    85.272
     3.300    87.728
     3.400    90.185
     3.500    92.641
     3.600    95.097
     3.700    97.554
     3.800   100.010
     3.900   102.467
     4.000   104.924
EOF
# Sb TT curve at maximum depth
gmt plot $proj $reg -Wthin,blue,- -Vq << EOF
EOF
# Sg TT curve at maximum depth
gmt plot $proj $reg -Wthin,red,- -Vq << EOF
EOF
# Phases other than the standard crustal phases
gmt plot $proj $reg -Sd -Wthin -Gorange << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
     2.403    42.172     0.200
     2.541    41.672     0.200
     2.570    45.172     0.200
     2.864    46.672     0.200
     2.926    48.172     0.200
     4.735    73.172     0.200
     6.448    98.172     0.200
     7.098   105.422     0.200
     9.177   137.672     0.200
    10.298   149.172     0.200
    17.276   241.672     0.200
    17.821   247.371     0.200
    19.124   265.273     0.200
    19.127   265.324     0.200
    20.380   280.672     0.200
    20.394   281.172     0.200
    20.830   283.273     0.200
    20.768   283.973     0.200
    20.860   285.941     0.200
     1.452    25.965     0.200
     1.512    27.525     0.200
     1.972    34.226     0.200
     2.110    36.325     0.200
     2.358    39.755     0.200
     2.425    42.755     0.200
     2.492    42.105     0.200
     2.492    42.325     0.200
     2.499    41.625     0.200
     2.499    42.025     0.200
     2.499    42.235     0.200
     2.580    41.825     0.200
     2.665    43.615     0.200
     2.759    45.556     0.200
     2.878    47.766     0.200
     2.903    47.995     0.200
     3.215    51.705     0.200
     3.224    52.135     0.200
     3.265    51.415     0.200
     4.010    63.825     0.200
     4.063    64.235     0.200
     4.192    65.806     0.200
     4.429    68.635     0.200
     4.467    70.285     0.200
     5.330    83.205     0.200
     5.510    82.825     0.200
     7.657   112.695     0.200
     7.810   117.396     0.200
     8.574   131.465     0.200
     9.696   146.575     0.200
    10.180   149.825     0.200
    10.428   156.075     0.200
    12.726   186.565     0.200
    12.726   181.613     0.200
    13.485   194.226     0.200
    13.538   197.035     0.200
    13.538   197.425     0.200
    13.550   197.855     0.200
    13.706   200.795     0.200
    13.874   203.235     0.200
    14.162   205.715     0.200
    14.235   205.655     0.200
    14.284   208.545     0.200
    15.639   224.115     0.200
    17.723   245.965     0.200
    18.463   259.325     0.200
    18.449   261.675     0.200
    18.774   261.925     0.200
    21.020   287.605     0.200
     0.308     8.846     0.200
     0.729    14.246     0.200
     0.979    17.824     0.200
     1.481    25.955     0.200
     2.105    34.395     0.200
     2.234    36.086     0.200
     2.267    37.025     0.200
     2.279    38.324     0.200
     2.338    37.645     0.200
     2.435    39.016     0.200
     2.418    39.785     0.200
     2.418    40.086     0.200
     2.538    40.586     0.200
     2.495    40.135     0.200
     2.521    43.564     0.200
     2.564    40.984     0.200
     2.572    45.096     0.200
     2.649    42.234     0.200
     2.668    40.734     0.200
     2.675    42.135     0.200
     2.875    44.395     0.200
     3.439    53.455     0.200
     3.612    55.324     0.200
     3.621    57.225     0.200
     3.714    59.055     0.200
     4.010    63.205     0.200
     4.471    68.105     0.200
     4.851    74.096     0.200
     5.852    86.086     0.200
     8.076   118.996     0.200
    10.881   160.305     0.200
    11.372   166.746     0.200
    11.609   170.166     0.200
    11.675   170.465     0.200
    11.817   172.484     0.200
    12.367   178.086     0.200
    12.367   177.410     0.200
    13.180   187.785     0.200
    13.340   188.785     0.200
    17.479   240.734     0.200
    18.402   255.096     0.200
    18.912   258.625     0.200
    19.848   269.686     0.200
    20.225   274.455     0.200
    20.345   276.984     0.200
    20.601   280.055     0.200
    20.834   279.865     0.200
    20.880   281.395     0.200
     1.163    20.662     0.200
     2.031    34.014     0.200
     2.284    38.963     0.200
     2.371    39.572     0.200
     2.451    40.752     0.200
     2.479    40.902     0.200
     2.511    41.053     0.200
     2.590    41.492     0.200
     3.064    48.492     0.200
     3.077    47.184     0.200
     3.308    51.684     0.200
     4.154    62.213     0.200
     4.287    65.723     0.200
     4.469    67.232     0.200
     5.030    76.582     0.200
     5.030    75.783     0.200
     5.198    75.588     0.200
     5.198    78.123     0.200
     5.513    83.613     0.200
     5.683    85.973     0.200
     7.894   116.732     0.200
     8.259   121.402     0.200
     8.862   126.482     0.200
    10.212   148.344     0.200
    10.236   149.934     0.200
    10.529   151.643     0.200
    10.871   157.963     0.200
    11.591   168.760     0.200
    11.591   165.094     0.200
    11.799   167.924     0.200
    11.799   166.686     0.200
    12.453   179.312     0.200
    12.951   185.793     0.200
    12.951   186.363     0.200
    13.219   188.082     0.200
    13.330   187.703     0.200
    13.330   189.131     0.200
    14.845   211.184     0.200
    15.140   214.373     0.200
    15.370   214.633     0.200
    15.874   223.145     0.200
    17.187   237.473     0.200
    17.350   240.973     0.200
    17.350   242.293     0.200
    17.511   241.604     0.200
    17.645   244.033     0.200
    18.342   256.053     0.200
    18.425   256.389     0.200
    18.495   256.383     0.200
    18.495   255.713     0.200
    18.495   256.713     0.200
    18.495   256.125     0.200
    18.802   260.709     0.200
    18.921   261.498     0.200
    18.984   263.293     0.200
    19.389   266.988     0.200
    19.694   270.348     0.200
    19.760   270.613     0.200
    19.820   271.863     0.200
    19.856   272.037     0.200
    20.177   275.438     0.200
    20.244   276.463     0.200
    20.488   279.213     0.200
    20.507   279.275     0.200
    20.544   279.912     0.200
    20.720   282.053     0.200
    20.720   281.906     0.200
    20.828   283.287     0.200
    20.834   282.658     0.200
    20.968   284.334     0.200
    20.984   284.500     0.200
     0.158     7.408     0.200
     0.538    10.627     0.200
     0.969    18.588     0.200
     1.181    21.268     0.200
     1.407    25.137     0.200
     2.025    33.168     0.200
     2.283    38.678     0.200
     2.369    40.236     0.200
     2.444    39.566     0.200
     2.464    40.277     0.200
     2.508    39.857     0.200
     2.602    41.396     0.200
     3.051    48.297     0.200
     3.095    48.117     0.200
     3.307    51.508     0.200
     3.414    54.037     0.200
     3.423    53.316     0.200
     4.268    65.168     0.200
     5.049    76.486     0.200
     5.181    77.838     0.200
     5.181    77.947     0.200
     5.530    84.277     0.200
     5.667    83.008     0.200
     7.876   116.307     0.200
     8.276   123.357     0.200
     8.846   127.617     0.200
    10.884   159.188     0.200
    11.609   168.920     0.200
    11.783   165.777     0.200
    12.463   179.197     0.200
    12.933   186.146     0.200
    13.224   187.537     0.200
    13.331   187.396     0.200
    15.150   214.377     0.200
    15.370   215.037     0.200
    17.173   238.207     0.200
    17.332   241.547     0.200
    17.516   241.518     0.200
    17.651   243.938     0.200
    18.085   252.922     0.200
    18.323   255.617     0.200
    18.439   256.348     0.200
    18.506   256.457     0.200
    18.506   256.197     0.200
    18.817   260.672     0.200
    18.935   261.422     0.200
    19.403   266.922     0.200
    19.745   269.797     0.200
    19.708   269.896     0.200
    19.834   271.482     0.200
    19.870   271.646     0.200
    20.191   275.473     0.200
    20.257   276.396     0.200
    20.504   279.066     0.200
    20.522   279.348     0.200
    20.558   279.531     0.200
    20.733   281.727     0.200
    20.733   281.871     0.200
    20.841   283.271     0.200
     1.064    20.037     0.200
     1.440    25.346     0.200
     1.987    33.916     0.200
     2.365    40.156     0.200
     2.367    39.688     0.200
     2.523    41.387     0.200
     2.780    45.496     0.200
     2.926    46.727     0.200
     3.236    51.688     0.200
     3.351    53.516     0.200
     4.454    70.527     0.200
     5.004    75.576     0.200
     5.823    92.057     0.200
     6.696   100.877     0.200
     6.737   100.557     0.200
     7.915   117.697     0.200
     7.822   118.006     0.200
    11.175   161.596     0.200
    11.896   172.971     0.200
    12.735   184.352     0.200
    12.709   184.117     0.200
    13.455   192.906     0.200
    13.505   191.557     0.200
    15.150   216.496     0.200
    15.589   221.596     0.200
    17.497   242.387     0.200
    17.899   248.496     0.200
    18.377   257.631     0.200
    18.470   258.367     0.200
    18.734   260.982     0.200
    18.750   261.646     0.200
    18.782   261.227     0.200
    18.782   261.107     0.200
    18.782   260.477     0.200
    18.806   262.654     0.200
    18.849   262.725     0.200
    18.968   264.057     0.200
    19.112   265.430     0.200
    19.235   266.949     0.200
    19.229   266.277     0.200
    19.252   266.914     0.200
    19.544   269.703     0.200
    19.584   270.842     0.200
    19.696   271.832     0.200
    19.777   272.953     0.200
    19.879   273.814     0.200
    19.991   275.215     0.200
    20.016   275.225     0.200
    20.004   275.055     0.200
    20.126   276.830     0.200
    20.164   276.656     0.200
    20.295   278.010     0.200
    20.284   277.773     0.200
    20.372   279.219     0.200
    20.486   280.486     0.200
    20.551   281.283     0.200
    20.615   281.705     0.200
    20.735   283.627     0.200
    20.800   283.957     0.200
    20.818   283.932     0.200
    20.852   284.744     0.200
    20.943   284.557     0.200
    21.024   286.727     0.200
     1.212    21.473     0.200
     1.318    22.513     0.200
     1.377    24.192     0.200
     1.671    28.283     0.200
     1.889    31.643     0.200
     2.143    34.562     0.200
     2.280    37.793     0.200
     2.498    40.812     0.200
     2.559    40.923     0.200
     2.644    42.482     0.200
     2.682    43.223     0.200
     2.843    45.103     0.200
     2.892    46.663     0.200
     2.910    46.353     0.200
     2.946    45.713     0.200
     3.025    48.103     0.200
     3.071    48.583     0.200
     3.185    49.223     0.200
     3.217    48.883     0.200
     3.418    53.253     0.200
     3.427    53.123     0.200
     3.593    55.573     0.200
     4.178    63.623     0.200
     5.186    76.748     0.200
     5.186    77.183     0.200
     5.198    76.893     0.200
     5.748    84.423     0.200
     6.219    91.312     0.200
     8.000   116.982     0.200
    10.830   156.143     0.200
    11.781   170.111     0.200
    11.873   166.596     0.200
    11.873   166.183     0.200
    12.461   177.900     0.200
    12.561   179.145     0.200
    12.754   182.989     0.200
    12.760   183.423     0.200
    12.815   183.477     0.200
    12.871   184.093     0.200
    13.080   187.660     0.200
    13.176   188.015     0.200
    13.209   188.181     0.200
    13.226   189.903     0.200
    13.284   191.242     0.200
    13.399   192.865     0.200
    13.532   194.047     0.200
    13.555   195.558     0.200
    13.622   193.963     0.200
    13.727   195.659     0.200
    13.744   196.247     0.200
    13.854   198.441     0.200
    13.924   197.593     0.200
    13.938   199.731     0.200
    14.126   202.157     0.200
    14.176   203.426     0.200
    14.348   203.217     0.200
    14.431   203.036     0.200
    14.467   204.867     0.200
    14.473   205.867     0.200
    14.600   207.624     0.200
    14.606   207.188     0.200
    14.741   210.007     0.200
    14.944   211.375     0.200
    14.973   210.982     0.200
    15.024   213.616     0.200
    15.229   216.672     0.200
    15.248   216.492     0.200
    15.292   216.578     0.200
    15.297   216.231     0.200
    15.671   220.449     0.200
    15.676   221.772     0.200
    15.692   221.632     0.200
    15.730   220.656     0.200
    15.781   221.770     0.200
    15.837   223.204     0.200
    15.953   224.056     0.200
    16.038   225.417     0.200
    16.181   227.510     0.200
    16.337   228.347     0.200
    16.342   228.371     0.200
    16.349   229.924     0.200
    16.430   230.420     0.200
    16.572   232.628     0.200
    16.639   232.556     0.200
    16.702   234.266     0.200
    16.792   233.269     0.200
    16.937   234.934     0.200
    17.031   237.419     0.200
    17.111   238.144     0.200
    17.146   238.445     0.200
    17.248   240.723     0.200
    17.408   242.741     0.200
    17.521   242.780     0.200
    17.575   244.896     0.200
    17.631   244.723     0.200
    17.643   243.003     0.200
    17.820   244.812     0.200
    17.854   247.547     0.200
    17.860   247.641     0.200
    17.956   248.232     0.200
    17.956   247.961     0.200
    17.987   249.224     0.200
    18.190   250.796     0.200
    18.260   252.157     0.200
    18.430   256.365     0.200
    18.479   257.062     0.200
    18.538   256.595     0.200
    18.720   259.483     0.200
    18.799   260.073     0.200
    18.799   259.723     0.200
    18.803   260.914     0.200
    18.801   259.469     0.200
    18.925   261.165     0.200
    19.045   263.436     0.200
    19.358   266.239     0.200
    19.572   268.660     0.200
    19.577   268.431     0.200
    19.966   274.040     0.200
    20.008   273.270     0.200
    20.104   275.712     0.200
    20.181   275.185     0.200
    20.257   276.099     0.200
    20.451   278.536     0.200
    20.749   282.593     0.200
    20.749   282.700     0.200
     1.553    26.766     0.200
     1.939    31.645     0.200
     2.000    33.125     0.200
     2.326    38.156     0.200
     2.435    39.957     0.200
     2.586    41.816     0.200
     2.719    45.008     0.200
     3.412    53.945     0.200
     3.512    55.227     0.200
     3.854    58.676     0.200
     4.487    67.855     0.200
     4.763    73.656     0.200
     5.805    86.816     0.200
     6.175    92.516     0.200
     6.240    92.797     0.200
     6.476    96.617     0.200
     7.154   106.355     0.200
     7.304   108.266     0.200
     7.950   119.395     0.200
     8.065   121.426     0.200
     8.755   131.484     0.200
     8.972   130.926     0.200
     9.196   138.328     0.200
     9.675   141.805     0.200
     9.923   146.816     0.200
    10.027   147.957     0.200
    10.073   149.316     0.200
    10.144   149.137     0.200
    10.416   152.688     0.200
    10.861   158.047     0.200
    11.206   158.797     0.200
    11.206   158.652     0.200
    11.466   166.855     0.200
    11.771   168.703     0.200
    12.187   176.207     0.200
    12.342   176.746     0.200
    12.342   178.273     0.200
    12.480   177.930     0.200
    12.541   178.855     0.200
    12.884   185.008     0.200
    12.926   184.305     0.200
    12.968   186.180     0.200
    13.162   187.180     0.200
    13.225   188.008     0.200
    13.264   190.156     0.200
    13.278   189.672     0.200
    13.377   191.930     0.200
    13.424   187.758     0.200
    13.516   193.680     0.200
    13.685   195.719     0.200
    13.730   196.531     0.200
    13.744   194.922     0.200
    13.818   197.180     0.200
    13.898   198.281     0.200
    13.905   196.402     0.200
    14.046   201.230     0.200
    14.290   204.082     0.200
    14.311   204.387     0.200
    14.357   202.840     0.200
    14.410   202.801     0.200
    14.507   205.188     0.200
    14.671   208.680     0.200
    14.678   207.699     0.200
    14.707   208.707     0.200
    14.831   210.887     0.200
    14.894   211.605     0.200
    14.913   209.531     0.200
    14.976   210.359     0.200
    14.978   210.875     0.200
    15.129   213.102     0.200
    15.138   211.855     0.200
    15.213   215.555     0.200
    15.388   216.438     0.200
    15.411   217.527     0.200
    15.436   217.980     0.200
    15.647   218.906     0.200
    15.645   218.906     0.200
    15.667   221.457     0.200
    15.670   219.406     0.200
    15.651   222.676     0.200
    15.714   219.727     0.200
    15.779   222.535     0.200
    15.791   220.938     0.200
    15.832   223.258     0.200
    15.865   222.383     0.200
    15.866   223.582     0.200
    15.957   225.598     0.200
    16.036   226.074     0.200
    16.068   225.172     0.200
    16.178   226.832     0.200
    16.243   226.438     0.200
    16.328   227.230     0.200
    16.342   229.145     0.200
    16.348   227.473     0.200
    16.368   227.508     0.200
    16.394   227.957     0.200
    16.506   230.086     0.200
    16.598   233.281     0.200
    16.637   230.656     0.200
    16.663   231.832     0.200
    16.771   233.508     0.200
    16.787   235.508     0.200
    16.938   234.441     0.200
    16.949   235.879     0.200
    16.985   235.586     0.200
    16.993   235.199     0.200
    17.023   235.395     0.200
    17.098   236.938     0.200
    17.165   239.980     0.200
    17.209   238.555     0.200
    17.231   238.629     0.200
    17.309   238.297     0.200
    17.369   240.980     0.200
    17.503   242.105     0.200
    17.567   243.074     0.200
    17.652   243.633     0.200
    17.694   244.555     0.200
    17.769   244.156     0.200
    17.945   247.309     0.200
    17.975   248.406     0.200
    18.000   248.605     0.200
    18.000   248.258     0.200
    18.129   250.785     0.200
    18.206   250.480     0.200
    18.220   250.969     0.200
    18.232   251.051     0.200
    18.301   254.098     0.200
    18.323   254.926     0.200
    18.351   254.305     0.200
    18.392   255.555     0.200
    18.425   255.156     0.200
    18.451   255.395     0.200
    18.519   257.465     0.200
    18.570   257.359     0.200
    18.687   259.383     0.200
    18.695   258.758     0.200
    18.749   260.180     0.200
    18.953   262.031     0.200
    18.989   261.707     0.200
    19.103   262.914     0.200
    19.171   264.758     0.200
    19.200   265.031     0.200
    19.228   264.969     0.200
    19.296   265.965     0.200
    19.516   267.852     0.200
    19.663   269.070     0.200
    19.724   272.008     0.200
    19.818   271.582     0.200
    19.859   272.152     0.200
    20.144   274.500     0.200
    20.281   276.188     0.200
    20.338   277.047     0.200
    20.343   277.168     0.200
    20.412   277.953     0.200
    20.426   278.035     0.200
    20.814   282.312     0.200
    20.931   284.418     0.200
     0.294     9.141     0.200
     0.584    12.266     0.200
     1.350    23.445     0.200
     1.625    27.258     0.200
     1.799    29.258     0.200
     1.846    29.930     0.200
     1.916    31.828     0.200
     2.123    34.641     0.200
     2.193    35.898     0.200
     2.397    38.484     0.200
     2.539    40.625     0.200
     2.638    41.984     0.200
     2.791    44.070     0.200
     2.798    44.641     0.200
     3.654    56.375     0.200
     3.709    55.578     0.200
     4.434    69.344     0.200
     4.567    68.477     0.200
     4.567    68.094     0.200
     4.601    70.266     0.200
     6.053    88.891     0.200
     6.273    92.344     0.200
     6.264    95.109     0.200
     7.254   107.898     0.200
     7.767   113.906     0.200
    11.229   160.188     0.200
    11.229   160.422     0.200
    11.584   166.523     0.200
    12.290   175.141     0.200
    12.356   176.586     0.200
    12.685   181.180     0.200
    12.725   181.180     0.200
    12.768   182.031     0.200
    12.976   184.438     0.200
    13.036   185.281     0.200
    13.063   186.586     0.200
    13.085   186.188     0.200
    13.181   187.938     0.200
    13.318   189.773     0.200
    13.325   189.648     0.200
    13.485   192.117     0.200
    13.528   192.617     0.200
    13.555   192.719     0.200
    13.623   193.742     0.200
    13.706   194.938     0.200
    13.720   194.648     0.200
    13.848   196.547     0.200
    14.089   199.828     0.200
    14.112   200.523     0.200
    14.225   201.289     0.200
    14.315   203.562     0.200
    14.469   205.602     0.200
    14.510   205.367     0.200
    14.729   207.016     0.200
    14.788   208.203     0.200
    14.936   209.883     0.200
    15.011   212.352     0.200
    15.234   215.609     0.200
    15.467   218.617     0.200
    15.632   220.180     0.200
    15.665   220.719     0.200
    15.669   220.977     0.200
    15.802   222.359     0.200
    15.834   222.938     0.200
    15.978   224.195     0.200
    16.074   220.891     0.200
    16.142   225.875     0.200
    16.144   224.484     0.200
    16.161   225.930     0.200
    16.177   225.719     0.200
    16.202   226.352     0.200
    16.311   228.445     0.200
    16.395   230.188     0.200
    16.397   230.062     0.200
    16.466   229.289     0.200
    16.572   232.219     0.200
    16.748   233.398     0.200
    16.793   233.867     0.200
    16.806   234.461     0.200
    16.840   234.805     0.200
    16.964   236.570     0.200
    17.013   236.578     0.200
    17.036   236.578     0.200
    17.154   238.930     0.200
    17.183   236.977     0.200
    17.314   240.648     0.200
    17.357   241.375     0.200
    17.545   243.211     0.200
    17.588   241.328     0.200
    17.723   245.719     0.200
    17.749   245.086     0.200
    17.777   245.953     0.200
    17.808   245.625     0.200
    17.808   246.367     0.200
    18.010   248.539     0.200
    18.020   248.547     0.200
    18.152   250.031     0.200
    18.484   255.641     0.200
    18.493   255.445     0.200
    18.750   259.055     0.200
    18.787   258.344     0.200
    19.656   270.031     0.200
    20.144   276.016     0.200
    20.223   275.148     0.200
    20.613   280.500     0.200
     1.480    25.711     0.200
     1.948    33.070     0.200
     2.461    40.449     0.200
     2.568    42.652     0.200
     2.698    43.582     0.200
     2.776    45.020     0.200
     3.245    52.832     0.200
     3.544    54.742     0.200
     3.517    54.852     0.200
     3.860    59.500     0.200
     4.219    62.352     0.200
     4.270    66.160     0.200
     4.541    68.344     0.200
     5.113    74.832     0.200
     6.292    94.230     0.200
     6.221    93.160     0.200
     6.238    92.711     0.200
     6.572    99.750     0.200
     6.572   100.582     0.200
     7.191   104.551     0.200
     7.316   111.570     0.200
     9.741   141.777     0.200
    10.204   148.293     0.200
    10.270   149.305     0.200
    10.785   157.109     0.200
    10.802   156.266     0.200
    10.816   156.793     0.200
    11.333   164.395     0.200
    11.290   159.262     0.200
    11.290   160.262     0.200
    11.453   165.422     0.200
    11.489   166.316     0.200
    11.569   167.039     0.200
    11.556   169.020     0.200
    11.885   171.492     0.200
    11.785   171.223     0.200
    12.049   173.125     0.200
    12.132   174.156     0.200
    12.280   176.363     0.200
    12.342   176.930     0.200
    12.207   176.461     0.200
    12.383   178.613     0.200
    12.546   179.797     0.200
    12.595   180.102     0.200
    12.626   180.637     0.200
    12.661   180.184     0.200
    12.857   182.898     0.200
    12.955   185.008     0.200
    13.036   187.949     0.200
    13.036   187.977     0.200
    13.148   187.438     0.200
    13.228   188.176     0.200
    13.240   188.176     0.200
    13.319   189.309     0.200
    13.438   190.621     0.200
    13.558   191.652     0.200
    13.578   192.578     0.200
    13.637   193.965     0.200
    13.637   193.750     0.200
    13.902   196.789     0.200
    13.918   197.102     0.200
    14.002   197.078     0.200
    14.024   197.938     0.200
    14.061   199.109     0.200
    14.162   200.020     0.200
    14.327   202.207     0.200
    14.340   202.512     0.200
    14.410   203.398     0.200
    14.468   204.809     0.200
    14.490   204.664     0.200
    14.541   204.641     0.200
    14.573   205.359     0.200
    14.634   206.141     0.200
    14.758   207.945     0.200
    14.829   208.227     0.200
    14.863   208.656     0.200
    15.030   211.004     0.200
    15.184   213.625     0.200
    15.202   213.262     0.200
    15.215   214.082     0.200
    15.269   214.477     0.200
    15.269   214.730     0.200
    15.340   214.879     0.200
    15.120   219.359     0.200
    15.359   214.891     0.200
    15.408   215.578     0.200
    15.474   216.418     0.200
    15.542   217.891     0.200
    15.577   217.977     0.200
    15.577   218.391     0.200
    15.631   218.039     0.200
    15.649   217.145     0.200
    15.695   219.691     0.200
    15.771   221.590     0.200
    15.774   221.207     0.200
    15.774   221.570     0.200
    15.784   221.301     0.200
    15.834   221.625     0.200
    15.873   221.793     0.200
    15.872   221.816     0.200
    15.644   223.777     0.200
    15.644   221.410     0.200
    15.972   222.539     0.200
    16.061   223.426     0.200
    16.092   224.113     0.200
    16.130   225.797     0.200
    16.171   225.305     0.200
    16.264   226.523     0.200
    16.332   228.215     0.200
    16.346   227.812     0.200
    16.453   229.754     0.200
    16.520   230.059     0.200
    16.590   231.676     0.200
    16.616   231.816     0.200
    16.652   231.422     0.200
    16.667   232.516     0.200
    16.693   231.695     0.200
    16.710   232.539     0.200
    16.739   233.223     0.200
    16.748   232.340     0.200
    16.792   232.977     0.200
    16.885   234.324     0.200
    16.890   233.898     0.200
    16.932   235.484     0.200
    17.108   237.762     0.200
    16.882   238.641     0.200
    17.166   237.672     0.200
    17.177   239.180     0.200
    17.165   237.766     0.200
    17.185   238.324     0.200
    17.209   239.305     0.200
    17.219   238.238     0.200
    17.227   238.484     0.200
    17.022   241.922     0.200
    17.307   240.219     0.200
    17.339   240.598     0.200
    17.349   241.238     0.200
    17.338   241.000     0.200
    17.443   240.914     0.200
    17.507   241.539     0.200
    17.519   242.441     0.200
    17.559   242.195     0.200
    17.569   243.520     0.200
    17.630   243.871     0.200
    17.704   244.621     0.200
    17.714   245.254     0.200
    17.702   244.262     0.200
    17.699   244.172     0.200
    17.791   246.070     0.200
    17.818   246.602     0.200
    17.819   245.988     0.200
    17.824   247.102     0.200
    17.838   246.344     0.200
    17.898   247.152     0.200
    17.904   246.684     0.200
    17.955   248.301     0.200
    18.018   248.895     0.200
    18.028   248.785     0.200
    18.048   248.637     0.200
    18.079   249.695     0.200
    18.332   253.133     0.200
    18.385   253.352     0.200
    18.451   253.578     0.200
    18.500   254.785     0.200
    18.661   257.824     0.200
    18.776   259.145     0.200
    18.799   260.973     0.200
    18.869   259.895     0.200
    19.000   261.523     0.200
    19.066   261.773     0.200
    19.065   262.656     0.200
    19.066   261.820     0.200
    19.068   262.094     0.200
    19.068   261.902     0.200
    19.096   263.965     0.200
    19.096   263.707     0.200
    19.096   264.551     0.200
    19.096   264.449     0.200
    19.246   263.852     0.200
    19.276   265.629     0.200
    19.276   267.180     0.200
    19.528   267.129     0.200
    19.560   267.570     0.200
    19.664   268.711     0.200
    19.953   274.570     0.200
    20.377   278.172     0.200
    20.377   278.922     0.200
    20.419   279.570     0.200
    20.515   280.723     0.200
    20.716   280.832     0.200
    20.716   281.500     0.200
    20.896   284.570     0.200
     0.725    13.871     0.200
     1.094    20.543     0.200
     1.429    24.500     0.200
     2.010    33.520     0.200
     2.139    34.242     0.200
     2.143    35.012     0.200
     2.176    35.609     0.200
     2.318    37.660     0.200
     2.337    38.270     0.200
     2.487    40.441     0.200
     2.617    42.281     0.200
     2.694    40.301     0.200
     2.756    42.801     0.200
     3.713    56.422     0.200
     3.713    58.359     0.200
     3.768    56.840     0.200
     4.607    67.070     0.200
     6.546    95.562     0.200
     6.982   105.020     0.200
     9.717   140.465     0.200
    10.186   146.945     0.200
    10.292   148.672     0.200
    10.576   150.270     0.200
    10.576   150.383     0.200
    10.830   156.023     0.200
    10.847   156.305     0.200
    11.351   162.688     0.200
    11.429   164.152     0.200
    11.544   165.816     0.200
    11.558   165.582     0.200
    11.559   165.848     0.200
    11.731   165.520     0.200
    11.755   168.312     0.200
    11.800   166.699     0.200
    11.949   170.926     0.200
    11.992   173.172     0.200
    12.070   171.941     0.200
    12.110   172.719     0.200
    12.180   172.527     0.200
    12.279   175.508     0.200
    12.405   175.957     0.200
    12.450   178.020     0.200
    12.607   178.152     0.200
    12.642   178.641     0.200
    12.682   179.344     0.200
    12.800   181.297     0.200
    12.859   181.715     0.200
    13.007   182.715     0.200
    13.043   184.891     0.200
    13.248   186.598     0.200
    13.290   187.516     0.200
    13.293   187.547     0.200
    13.325   190.020     0.200
    13.324   190.246     0.200
    13.386   188.359     0.200
    13.444   188.270     0.200
    13.444   186.621     0.200
    13.489   190.129     0.200
    13.725   193.852     0.200
    13.725   194.270     0.200
    13.775   193.273     0.200
    13.837   193.742     0.200
    13.971   196.477     0.200
    14.036   196.863     0.200
    14.040   197.297     0.200
    14.103   198.145     0.200
    14.131   197.395     0.200
    14.236   198.434     0.200
    14.252   199.812     0.200
    14.290   200.227     0.200
    14.484   202.129     0.200
    14.515   200.172     0.200
    14.538   203.473     0.200
    14.548   204.223     0.200
    14.554   203.688     0.200
    14.643   203.797     0.200
    14.707   206.055     0.200
    14.744   205.051     0.200
    14.743   204.789     0.200
    14.769   206.859     0.200
    14.902   211.871     0.200
    14.873   207.199     0.200
    14.911   208.094     0.200
    15.049   208.621     0.200
    15.050   208.996     0.200
    15.091   209.188     0.200
    15.226   213.062     0.200
    15.228   213.207     0.200
    15.250   213.281     0.200
    15.289   212.621     0.200
    15.296   212.074     0.200
    15.349   213.812     0.200
    15.377   212.277     0.200
    15.423   213.383     0.200
    15.436   214.543     0.200
    15.436   214.250     0.200
    15.452   215.559     0.200
    15.576   216.707     0.200
    15.727   218.086     0.200
    15.733   218.062     0.200
    15.751   217.410     0.200
    15.795   220.258     0.200
    15.808   218.598     0.200
    15.816   220.188     0.200
    15.817   220.914     0.200
    15.818   220.207     0.200
    15.850   220.949     0.200
    15.904   219.809     0.200
    15.919   219.867     0.200
    15.941   219.707     0.200
    15.989   223.551     0.200
    16.044   223.281     0.200
    16.064   225.312     0.200
    16.141   222.613     0.200
    16.220   225.215     0.200
    16.282   224.500     0.200
    16.309   228.332     0.200
    16.381   226.059     0.200
    16.400   226.602     0.200
    16.420   225.848     0.200
    16.440   225.906     0.200
    16.489   227.254     0.200
    16.493   229.223     0.200
    16.540   228.102     0.200
    16.571   228.688     0.200
    16.596   230.086     0.200
    16.597   230.309     0.200
    16.614   230.336     0.200
    16.654   231.094     0.200
    16.792   231.297     0.200
    16.823   232.906     0.200
    16.892   232.582     0.200
    16.968   234.141     0.200
    17.159   235.516     0.200
    17.171   236.344     0.200
    17.184   237.871     0.200
    17.188   237.387     0.200
    17.213   237.941     0.200
    17.252   236.469     0.200
    17.261   236.820     0.200
    17.308   237.734     0.200
    17.331   238.023     0.200
    17.341   237.887     0.200
    17.420   240.270     0.200
    17.519   241.395     0.200
    17.541   242.262     0.200
    17.541   242.590     0.200
    17.560   240.676     0.200
    17.573   241.148     0.200
    17.602   241.430     0.200
    17.658   242.793     0.200
    17.670   242.664     0.200
    17.679   243.555     0.200
    17.734   243.027     0.200
    17.746   244.320     0.200
    17.777   243.262     0.200
    17.825   246.215     0.200
    17.845   243.973     0.200
    17.909   246.695     0.200
    17.927   247.191     0.200
    17.941   245.770     0.200
    18.056   248.770     0.200
    18.172   248.996     0.200
    18.206   249.715     0.200
    18.724   258.230     0.200
    18.755   259.535     0.200
    18.755   261.852     0.200
    18.873   260.293     0.200
    18.940   262.117     0.200
    18.940   262.672     0.200
    19.128   263.562     0.200
    19.397   266.098     0.200
    19.397   265.777     0.200
    19.397   265.973     0.200
    19.626   268.090     0.200
    19.790   271.281     0.200
    19.790   270.730     0.200
    19.937   273.531     0.200
    19.937   274.109     0.200
    20.354   277.543     0.200
    20.763   281.094     0.200
    20.934   283.473     0.200
    20.952   283.793     0.200
     0.650    13.227     0.200
     1.185    21.531     0.200
     1.185    20.922     0.200
     1.332    23.711     0.200
     1.478    25.586     0.200
     1.505    25.539     0.200
     1.538    26.250     0.200
     1.910    31.688     0.200
     2.008    32.320     0.200
     2.040    34.625     0.200
     2.295    37.766     0.200
     2.338    37.289     0.200
     2.362    39.625     0.200
     2.441    38.727     0.200
     2.455    39.117     0.200
     2.612    41.125     0.200
     2.679    43.266     0.200
     2.751    44.828     0.200
     2.760    46.070     0.200
     2.944    46.328     0.200
     2.953    45.859     0.200
     3.139    49.352     0.200
     3.139    49.055     0.200
     3.417    52.156     0.200
     4.581    72.047     0.200
     4.735    73.117     0.200
     6.246    92.078     0.200
     6.462    94.852     0.200
     7.186   107.539     0.200
    10.077   142.664     0.200
    10.142   149.961     0.200
    10.657   155.055     0.200
    10.689   152.648     0.200
    11.236   159.055     0.200
    11.236   160.102     0.200
    11.327   163.547     0.200
    11.362   162.969     0.200
    11.451   164.250     0.200
    11.758   168.672     0.200
    11.921   170.547     0.200
    12.004   171.695     0.200
    12.214   172.289     0.200
    12.219   175.578     0.200
    12.498   178.367     0.200
    12.730   180.391     0.200
    12.918   183.680     0.200
    12.917   185.023     0.200
    13.100   184.305     0.200
    13.113   186.195     0.200
    13.192   187.703     0.200
    13.451   189.789     0.200
    13.791   195.039     0.200
    13.896   197.602     0.200
    13.933   198.477     0.200
    14.363   201.953     0.200
    14.413   203.531     0.200
    14.445   204.227     0.200
    14.509   204.062     0.200
    14.630   206.461     0.200
    14.651   206.172     0.200
    14.705   206.539     0.200
    14.904   209.789     0.200
    15.056   211.055     0.200
    15.076   210.266     0.200
    15.087   212.758     0.200
    15.281   217.281     0.200
    15.349   214.961     0.200
    15.451   217.492     0.200
    15.451   214.969     0.200
    15.508   216.555     0.200
    15.647   218.289     0.200
    15.632   220.633     0.200
    15.632   218.789     0.200
    15.657   218.914     0.200
    15.706   220.773     0.200
    15.746   221.281     0.200
    15.746   222.438     0.200
    15.850   221.812     0.200
    15.967   222.641     0.200
    16.003   225.680     0.200
    16.048   225.562     0.200
    16.530   231.719     0.200
    16.585   230.133     0.200
    16.612   231.406     0.200
    16.627   233.414     0.200
    16.678   233.914     0.200
    16.761   234.016     0.200
    16.773   234.852     0.200
    16.805   235.094     0.200
    16.879   236.039     0.200
    16.982   237.141     0.200
    17.043   238.414     0.200
    17.099   237.305     0.200
    17.111   239.016     0.200
    17.226   238.281     0.200
    17.226   238.656     0.200
    17.371   241.836     0.200
    17.395   242.156     0.200
    17.442   241.797     0.200
    17.504   241.734     0.200
    17.588   242.773     0.200
    17.589   242.000     0.200
    17.577   244.180     0.200
    17.587   244.109     0.200
    17.665   243.531     0.200
    17.696   243.422     0.200
    17.699   244.086     0.200
    17.690   244.930     0.200
    17.718   246.023     0.200
    17.771   246.195     0.200
    17.771   245.852     0.200
    17.909   248.328     0.200
    17.936   246.812     0.200
    17.954   247.188     0.200
    17.997   249.617     0.200
    18.010   249.461     0.200
    18.031   248.383     0.200
    18.074   249.609     0.200
    18.143   250.023     0.200
    18.196   251.695     0.200
    18.197   251.562     0.200
    18.206   250.000     0.200
    18.223   249.477     0.200
    18.262   251.648     0.200
    18.275   251.148     0.200
    18.334   252.312     0.200
    18.324   252.984     0.200
    18.313   253.109     0.200
    18.375   255.648     0.200
    18.375   255.781     0.200
    19.181   264.945     0.200
    19.181   264.148     0.200
    19.845   272.172     0.200
    20.324   277.266     0.200
    20.410   278.266     0.200
    20.729   282.031     0.200
    20.720   282.562     0.200
     1.436    25.458     0.200
     1.488    26.668     0.200
     1.562    28.197     0.200
     1.562    28.067     0.200
     2.021    34.098     0.200
     1.985    33.058     0.200
     2.087    35.748     0.200
     2.296    37.548     0.200
     2.467    39.878     0.200
     2.479    41.817     0.200
     2.603    42.518     0.200
     2.735    44.938     0.200
     2.960    48.008     0.200
     3.902    60.147     0.200
     5.509    85.958     0.200
     6.183    96.758     0.200
     7.664   116.768     0.200
     7.872   119.447     0.200
    10.052   148.944     0.200
    10.092   151.324     0.200
    10.581   158.137     0.200
    10.642   158.723     0.200
    10.678   158.674     0.200
    11.144   167.288     0.200
    11.155   165.664     0.200
    11.280   167.780     0.200
    11.418   169.049     0.200
    11.977   175.508     0.200
    12.212   178.146     0.200
    12.421   181.518     0.200
    12.504   182.377     0.200
    12.698   185.708     0.200
    12.698   184.646     0.200
    12.701   185.688     0.200
    12.845   187.280     0.200
    13.045   188.876     0.200
    13.165   191.149     0.200
    13.412   194.397     0.200
    13.412   191.078     0.200
    13.714   197.475     0.200
    13.844   200.028     0.200
    13.902   200.149     0.200
    14.288   204.555     0.200
    14.314   204.655     0.200
    14.360   205.970     0.200
    14.415   206.653     0.200
    14.558   208.041     0.200
    14.616   209.062     0.200
    14.749   210.477     0.200
    14.932   212.641     0.200
    14.983   213.002     0.200
    15.035   213.639     0.200
    15.108   214.689     0.200
    15.108   215.328     0.200
    15.271   217.497     0.200
    15.414   218.035     0.200
    15.492   219.107     0.200
    15.492   219.987     0.200
    15.553   220.968     0.200
    15.591   220.562     0.200
    15.733   223.755     0.200
    15.952   225.081     0.200
    16.009   227.031     0.200
    16.090   226.523     0.200
    16.303   230.710     0.200
    16.302   230.295     0.200
    16.432   232.167     0.200
    16.525   232.631     0.200
    16.627   233.944     0.200
    16.644   234.564     0.200
    16.710   235.089     0.200
    16.741   235.514     0.200
    16.834   236.975     0.200
    16.851   236.732     0.200
    16.925   237.802     0.200
    17.020   239.190     0.200
    17.049   238.854     0.200
    17.060   239.062     0.200
    17.060   238.027     0.200
    17.165   240.287     0.200
    17.227   240.011     0.200
    17.370   241.983     0.200
    17.452   242.921     0.200
    17.464   242.876     0.200
    17.490   243.932     0.200
    17.524   243.979     0.200
    17.543   245.126     0.200
    17.695   245.466     0.200
    17.695   245.888     0.200
    17.807   248.659     0.200
    17.858   249.462     0.200
    18.005   250.300     0.200
    18.012   250.631     0.200
    18.044   249.683     0.200
    18.097   251.071     0.200
    18.208   253.168     0.200
    18.345   254.828     0.200
    18.414   254.777     0.200
    18.530   258.191     0.200
    18.746   261.612     0.200
    18.746   261.357     0.200
    18.824   263.045     0.200
    18.824   262.647     0.200
    19.552   271.438     0.200
    19.966   275.407     0.200
    19.983   275.567     0.200
    20.411   279.357     0.200
    20.459   280.907     0.200
    20.776   284.678     0.200
    20.993   287.248     0.200
     1.353    24.238     0.200
     1.797    31.039     0.200
     1.935    32.969     0.200
     2.269    37.789     0.200
     2.273    37.699     0.200
     2.542    42.031     0.200
     2.621    42.762     0.200
     2.727    45.391     0.200
     3.212    50.539     0.200
     3.537    58.828     0.200
     4.174    61.078     0.200
     4.174    61.762     0.200
     4.179    64.352     0.200
     4.222    67.012     0.200
     4.296    65.434     0.200
     4.969    78.191     0.200
     6.919   104.121     0.200
    11.676   170.668     0.200
    13.291   188.801     0.200
    13.292   189.609     0.200
    13.831   196.309     0.200
    15.172   215.020     0.200
    15.427   216.871     0.200
    16.457   232.570     0.200
    16.810   236.645     0.200
    17.291   242.211     0.200
    17.272   241.848     0.200
    17.440   244.152     0.200
    17.576   245.188     0.200
    17.578   245.859     0.200
    17.612   246.043     0.200
    17.924   248.660     0.200
    18.078   251.125     0.200
    18.078   251.602     0.200
    18.183   251.484     0.200
    18.273   253.609     0.200
    18.273   253.941     0.200
    18.337   254.289     0.200
    18.671   259.000     0.200
    18.776   261.578     0.200
    18.776   260.918     0.200
    18.996   268.000     0.200
    19.077   266.551     0.200
    19.357   266.816     0.200
    19.357   267.059     0.200
    19.585   270.586     0.200
    20.239   278.102     0.200
    20.659   282.199     0.200
    20.728   283.059     0.200
    20.809   284.000     0.200
     1.105    21.445     0.200
     1.171    23.156     0.200
     1.171    22.535     0.200
     1.335    25.613     0.200
     1.564    29.066     0.200
     1.655    29.734     0.200
     2.020    33.535     0.200
     2.076    35.383     0.200
     2.403    41.324     0.200
     2.558    42.633     0.200
     2.676    44.574     0.200
     2.684    44.836     0.200
     2.943    49.766     0.200
     3.018    50.633     0.200
     3.020    50.406     0.200
     3.257    53.605     0.200
     3.257    55.305     0.200
     3.436    54.215     0.200
     3.493    54.633     0.200
     4.124    61.465     0.200
     4.442    68.176     0.200
     4.442    67.863     0.200
     4.699    75.594     0.200
     4.851    76.273     0.200
     5.891    89.953     0.200
     6.125    92.684     0.200
     6.149    92.375     0.200
     6.337    96.484     0.200
     6.578    99.727     0.200
     6.578   100.816     0.200
     7.098   106.523     0.200
     7.098   106.324     0.200
     7.232   110.203     0.200
     8.038   117.285     0.200
     8.038   117.555     0.200
     8.038   118.086     0.200
     9.071   134.406     0.200
     9.123   139.852     0.200
     9.611   145.652     0.200
    10.128   144.324     0.200
    10.402   152.895     0.200
    11.187   160.156     0.200
    11.187   158.086     0.200
    11.450   165.434     0.200
    11.568   169.484     0.200
    11.568   169.633     0.200
    12.120   176.004     0.200
    12.120   174.977     0.200
    12.436   181.035     0.200
    12.436   178.445     0.200
    13.027   188.184     0.200
    13.026   188.305     0.200
    13.026   186.176     0.200
    13.026   187.355     0.200
    13.124   190.246     0.200
    13.230   188.773     0.200
    13.317   191.453     0.200
    13.499   191.254     0.200
    13.601   194.254     0.200
    13.601   193.898     0.200
    13.661   196.996     0.200
    13.694   197.105     0.200
    13.807   197.586     0.200
    14.012   199.059     0.200
    14.704   209.953     0.200
    15.220   215.379     0.200
    15.220   215.145     0.200
    15.216   216.484     0.200
    15.431   220.336     0.200
    15.431   218.703     0.200
    15.514   217.582     0.200
    15.514   217.406     0.200
    15.544   221.574     0.200
    15.570   221.066     0.200
    15.570   220.863     0.200
    15.736   221.289     0.200
    15.743   223.094     0.200
    15.743   223.543     0.200
    15.743   224.426     0.200
    15.877   225.586     0.200
    15.931   226.484     0.200
    17.327   241.531     0.200
    17.366   240.332     0.200
    17.452   241.621     0.200
    17.607   245.684     0.200
    17.758   246.965     0.200
    17.857   248.055     0.200
    17.857   248.539     0.200
    18.082   251.395     0.200
    18.094   251.035     0.200
    18.094   251.426     0.200
    18.245   251.402     0.200
    18.245   252.746     0.200
    18.402   256.855     0.200
    18.424   257.309     0.200
    18.424   256.375     0.200
    18.494   258.656     0.200
    18.494   258.406     0.200
    18.526   258.035     0.200
    18.552   258.703     0.200
    19.089   264.477     0.200
    19.089   264.156     0.200
    19.302   266.930     0.200
    19.302   267.543     0.200
    19.961   275.145     0.200
    20.253   277.727     0.200
    20.288   278.656     0.200
    20.383   279.746     0.200
    20.383   279.426     0.200
    20.445   280.145     0.200
    20.528   281.125     0.200
    20.814   286.355     0.200
    20.964   285.773     0.200
     1.620    28.727     0.200
     1.914    31.887     0.200
     2.128    35.477     0.200
     2.464    40.387     0.200
     2.474    41.047     0.200
     2.643    43.270     0.200
     2.805    45.719     0.200
     3.063    48.617     0.200
     3.073    48.156     0.200
     3.218    52.406     0.200
     3.551    55.297     0.200
     4.231    62.496     0.200
     4.570    68.867     0.200
     4.570    69.168     0.200
     6.546    98.719     0.200
     7.223   106.566     0.200
     8.064   117.527     0.200
     9.015   128.598     0.200
    10.252   145.906     0.200
    10.821   154.648     0.200
    11.315   160.285     0.200
    11.476   162.699     0.200
    11.529   166.539     0.200
    12.240   174.367     0.200
    12.350   180.004     0.200
    13.014   187.445     0.200
    13.014   186.449     0.200
    13.014   187.449     0.200
    13.014   186.906     0.200
    13.014   186.898     0.200
    13.347   188.867     0.200
    13.552   191.047     0.200
    13.622   191.746     0.200
    13.622   193.688     0.200
    14.051   199.547     0.200
    14.819   211.316     0.200
    15.259   215.203     0.200
    15.259   214.688     0.200
    15.572   218.031     0.200
    15.572   217.469     0.200
    15.547   217.668     0.200
    15.725   222.676     0.200
    15.725   222.207     0.200
    15.678   220.691     0.200
    15.678   221.848     0.200
    15.759   221.590     0.200
    15.759   221.109     0.200
    15.871   224.617     0.200
    15.921   224.867     0.200
    15.997   226.008     0.200
    16.546   232.309     0.200
    17.330   240.922     0.200
    17.444   241.520     0.200
    17.444   240.906     0.200
    17.516   242.809     0.200
    17.736   246.188     0.200
    17.820   246.727     0.200
    17.885   246.449     0.200
    17.885   248.062     0.200
    18.129   250.207     0.200
    18.340   252.566     0.200
    18.462   253.906     0.200
    18.448   257.148     0.200
    18.448   257.266     0.200
    18.505   257.648     0.200
    19.059   262.004     0.200
    19.073   263.566     0.200
    19.073   263.949     0.200
    19.246   265.488     0.200
    19.246   266.129     0.200
    19.319   264.711     0.200
    19.927   273.848     0.200
    20.351   278.129     0.200
    20.389   278.598     0.200
    20.696   281.344     0.200
     1.481    26.523     0.200
     1.526    26.141     0.200
     2.266    36.750     0.200
     3.063    48.680     0.200
     3.034    50.832     0.200
     3.034    48.941     0.200
     3.234    51.633     0.200
     4.543    74.031     0.200
     4.377    69.902     0.200
     5.001    74.422     0.200
     6.366    93.293     0.200
     7.656   111.660     0.200
     9.443   136.352     0.200
    11.719   166.324     0.200
    11.719   166.531     0.200
    12.667   182.203     0.200
    12.889   184.113     0.200
    12.889   184.602     0.200
    12.888   184.488     0.200
    12.888   184.133     0.200
    13.610   196.363     0.200
    15.580   220.391     0.200
    17.255   240.551     0.200
    17.255   240.660     0.200
    17.628   245.000     0.200
    17.893   247.801     0.200
    17.944   248.730     0.200
    18.054   250.836     0.200
    18.054   250.621     0.200
    18.205   251.453     0.200
    18.604   256.805     0.200
    18.935   262.195     0.200
    18.935   262.852     0.200
    18.983   263.922     0.200
    19.160   263.977     0.200
    19.406   267.027     0.200
    19.474   267.340     0.200
    19.535   267.922     0.200
    20.021   273.160     0.200
    20.269   277.180     0.200
    20.449   279.742     0.200
    20.561   279.512     0.200
    20.605   281.098     0.200
    20.915   287.223     0.200
    20.981   285.352     0.200
     0.292     9.250     0.200
     0.397    10.109     0.200
     0.827    16.016     0.200
     0.791    15.359     0.200
     1.197    21.250     0.200
     1.306    23.336     0.200
     1.268    22.492     0.200
     1.400    25.570     0.200
     1.584    26.727     0.200
     1.839    30.172     0.200
     1.816    31.961     0.200
     2.012    33.680     0.200
     2.019    34.000     0.200
     2.229    35.836     0.200
     2.249    36.875     0.200
     2.858    44.695     0.200
     2.793    47.609     0.200
     2.793    44.266     0.200
     3.494    52.820     0.200
    12.601   180.156     0.200
     1.621    28.547     0.200
     1.822    30.125     0.200
     2.216    36.625     0.200
     2.561    41.887     0.200
     2.560    41.738     0.200
     2.637    41.465     0.200
     2.638    42.738     0.200
     2.638    43.086     0.200
     2.850    45.715     0.200
     2.925    46.926     0.200
     2.906    47.738     0.200
     2.939    47.598     0.200
     3.140    51.977     0.200
     3.210    53.336     0.200
     3.662    57.156     0.200
     4.362    61.406     0.200
     4.249    66.438     0.200
     4.438    70.086     0.200
     4.704    69.656     0.200
     4.704    71.105     0.200
     4.537    72.945     0.200
     4.669    73.238     0.200
     5.747    84.828     0.200
     6.318    91.668     0.200
     6.391    95.488     0.200
     6.542    97.758     0.200
     7.350   107.918     0.200
     8.088   119.336     0.200
     9.499   137.648     0.200
    10.311   149.688     0.200
    11.516   167.926     0.200
    13.030   187.762     0.200
    13.030   186.547     0.200
    13.031   185.465     0.200
    13.031   185.316     0.200
    14.120   200.387     0.200
    15.328   215.637     0.200
    15.298   218.035     0.200
    15.615   219.316     0.200
    15.659   219.285     0.200
    15.813   221.867     0.200
    16.071   225.285     0.200
    15.958   225.488     0.200
    16.675   233.527     0.200
    16.802   233.215     0.200
    17.309   243.707     0.200
    17.364   241.637     0.200
    17.549   242.836     0.200
    18.392   255.996     0.200
    18.582   255.367     0.200
    18.738   257.445     0.200
    18.889   260.727     0.200
    19.144   262.945     0.200
    19.312   265.027     0.200
    19.499   266.605     0.200
    19.911   270.797     0.200
    19.944   271.488     0.200
    20.253   274.945     0.200
    20.404   277.398     0.200
     0.087     6.789     0.200
     0.514    11.449     0.200
     0.863    15.727     0.200
     1.062    19.520     0.200
     1.217    21.449     0.200
     1.217    22.289     0.200
     1.338    22.859     0.200
     1.345    22.969     0.200
     1.675    27.617     0.200
     1.743    28.719     0.200
     1.896    31.668     0.200
     1.990    32.668     0.200
     2.207    35.559     0.200
     2.251    35.609     0.200
     2.313    38.258     0.200
     2.364    38.316     0.200
     2.582    42.590     0.200
     2.629    40.770     0.200
     2.695    42.379     0.200
     2.742    42.609     0.200
     2.946    49.039     0.200
     2.946    45.949     0.200
     3.286    52.879     0.200
     3.655    54.719     0.200
     3.683    59.258     0.200
     3.969    63.840     0.200
     4.314    67.020     0.200
     4.394    68.418     0.200
     4.554    70.328     0.200
     4.635    68.723     0.200
     4.801    71.609     0.200
     5.481    83.758     0.200
     6.271    92.418     0.200
     7.319   106.598     0.200
    12.736   180.957     0.200
    12.736   180.309     0.200
    12.736   183.078     0.200
    12.736   180.738     0.200
    13.796   194.547     0.200
    15.337   215.789     0.200
    15.447   217.539     0.200
    15.757   220.598     0.200
    16.350   228.898     0.200
    16.685   233.418     0.200
    17.037   237.809     0.200
    17.055   238.359     0.200
    17.293   239.699     0.200
    18.796   258.930     0.200
    19.327   264.328     0.200
     0.406    10.219     0.200
     0.697    14.172     0.200
     0.710    14.242     0.200
     0.710    14.523     0.200
     0.941    17.344     0.200
     0.920    17.070     0.200
     0.924    17.719     0.200
     1.152    21.500     0.200
     1.183    21.430     0.200
     1.226    22.453     0.200
     1.286    22.250     0.200
     1.326    24.102     0.200
     1.392    24.664     0.200
     1.948    31.883     0.200
     1.917    32.602     0.200
     2.078    34.891     0.200
     2.104    35.734     0.200
     2.112    36.016     0.200
     2.097    34.609     0.200
     2.117    34.891     0.200
     2.135    36.305     0.200
     2.389    39.016     0.200
     2.389    39.359     0.200
     2.441    40.844     0.200
     2.514    39.930     0.200
     2.645    42.836     0.200
     2.947    46.641     0.200
     2.940    46.766     0.200
     3.157    50.070     0.200
     3.345    51.836     0.200
     3.469    55.195     0.200
     3.469    55.352     0.200
     3.654    53.836     0.200
     3.872    58.234     0.200
     3.872    58.953     0.200
     3.878    61.109     0.200
     4.422    66.086     0.200
     4.435    67.391     0.200
     4.422    67.820     0.200
     5.049    76.945     0.200
     5.111    79.242     0.200
     5.296    80.062     0.200
     5.561    84.336     0.200
     5.617    84.109     0.200
     5.969    89.844     0.200
     6.100    89.203     0.200
     6.345    91.891     0.200
     6.543    97.352     0.200
     6.543    97.133     0.200
     6.735    98.711     0.200
     6.735    99.891     0.200
     7.316   106.422     0.200
     7.366   108.641     0.200
     7.935   114.211     0.200
     8.364   120.586     0.200
     8.673   124.719     0.200
     9.394   138.250     0.200
     9.528   137.742     0.200
     9.554   137.469     0.200
     9.897   139.336     0.200
    10.070   148.352     0.200
    10.599   151.781     0.200
    10.969   160.383     0.200
    11.339   162.523     0.200
    11.570   167.172     0.200
    11.593   167.070     0.200
    11.595   166.820     0.200
    11.637   167.930     0.200
    11.745   168.875     0.200
    12.228   177.492     0.200
    12.624   180.242     0.200
    12.819   186.773     0.200
    13.082   186.844     0.200
    13.082   186.055     0.200
    13.081   186.375     0.200
    13.081   186.516     0.200
    13.257   186.711     0.200
    13.503   190.711     0.200
    13.503   191.445     0.200
    13.582   192.945     0.200
    13.836   195.055     0.200
    13.836   194.172     0.200
    14.204   201.555     0.200
    14.345   203.156     0.200
    14.730   209.539     0.200
    14.711   206.461     0.200
    14.921   211.633     0.200
    15.045   210.797     0.200
    15.252   215.430     0.200
    15.255   212.594     0.200
    15.255   212.875     0.200
    15.261   213.242     0.200
    15.576   216.203     0.200
    15.630   218.336     0.200
    15.630   218.203     0.200
    15.820   223.016     0.200
    15.820   222.156     0.200
    15.965   224.492     0.200
    16.062   223.516     0.200
    16.257   225.781     0.200
    16.391   228.164     0.200
    16.633   232.055     0.200
    16.635   231.180     0.200
    16.762   230.695     0.200
    17.014   235.328     0.200
    17.014   233.891     0.200
    17.065   238.062     0.200
    17.054   234.953     0.200
    17.105   237.766     0.200
    17.106   236.023     0.200
    17.307   239.859     0.200
    17.307   240.109     0.200
    17.479   241.289     0.200
    17.616   242.250     0.200
    17.726   244.016     0.200
    17.726   244.375     0.200
    17.819   243.477     0.200
    17.819   244.125     0.200
    17.863   246.289     0.200
    17.998   247.094     0.200
    18.040   248.781     0.200
    18.040   248.281     0.200
    18.098   248.992     0.200
    18.088   248.531     0.200
    18.177   249.812     0.200
    18.177   249.664     0.200
    18.480   255.812     0.200
    18.511   256.312     0.200
    18.511   256.719     0.200
    18.612   256.742     0.200
    18.693   259.211     0.200
    18.693   258.797     0.200
    19.154   263.609     0.200
    19.154   263.320     0.200
    19.154   263.453     0.200
    19.545   268.555     0.200
    20.125   273.805     0.200
    20.108   274.523     0.200
    20.013   274.453     0.200
    20.516   278.992     0.200
    20.516   278.859     0.200
    20.689   280.969     0.200
    20.705   280.969     0.200
     0.302     9.727     0.200
     0.423    11.086     0.200
     0.633    13.363     0.200
     0.815    16.023     0.200
     0.862    16.586     0.200
     0.865    16.734     0.200
     0.986    18.746     0.200
     1.091    19.637     0.200
     1.119    20.195     0.200
     1.157    21.285     0.200
     1.257    22.203     0.200
     1.277    23.023     0.200
     1.455    24.766     0.200
     1.603    28.066     0.200
     1.933    32.305     0.200
     1.942    32.066     0.200
     1.961    33.016     0.200
     1.970    31.934     0.200
     2.017    33.785     0.200
     2.400    40.637     0.200
     2.400    37.965     0.200
     2.675    42.324     0.200
     3.567    56.695     0.200
     3.701    56.121     0.200
     6.811   101.875     0.200
     8.200   117.801     0.200
    11.823   169.035     0.200
    13.126   188.316     0.200
    13.126   187.523     0.200
    13.502   192.477     0.200
    13.502   191.773     0.200
    13.811   198.156     0.200
    13.811   197.035     0.200
    15.870   223.414     0.200
    15.870   223.598     0.200
    17.328   240.664     0.200
    17.535   243.031     0.200
    17.596   244.055     0.200
    18.250   253.629     0.200
    18.530   255.934     0.200
    18.658   256.926     0.200
    19.054   261.164     0.200
    19.153   262.496     0.200
    19.200   263.406     0.200
    20.340   277.105     0.200
     0.101     7.875     0.200
     0.370    10.004     0.200
     0.540    12.095     0.200
     0.672    13.584     0.200
     0.840    16.214     0.200
     0.904    17.274     0.200
     1.304    23.145     0.200
     1.405    24.365     0.200
     1.540    25.854     0.200
     1.595    27.125     0.200
     1.728    29.285     0.200
     1.832    29.825     0.200
     1.839    30.575     0.200
     1.887    30.705     0.200
     1.866    31.895     0.200
     1.947    32.544     0.200
     2.152    35.234     0.200
     2.166    34.734     0.200
     2.186    35.904     0.200
     2.191    36.245     0.200
     2.200    35.745     0.200
     2.287    37.185     0.200
     2.390    36.785     0.200
     2.534    40.135     0.200
     2.590    40.654     0.200
     2.709    43.524     0.200
     3.472    51.645     0.200
     3.566    54.564     0.200
     3.566    54.834     0.200
     3.648    55.165     0.200
     3.797    57.444     0.200
     4.442    68.254     0.200
     4.478    66.904     0.200
     4.508    71.024     0.200
     4.515    70.075     0.200
     4.523    70.455     0.200
     4.541    70.674     0.200
     4.615    70.205     0.200
     4.685    72.234     0.200
     0.291     9.102     0.200
     0.288     9.156     0.200
     0.371     9.867     0.200
     0.251     8.672     0.200
     0.401    10.203     0.200
     0.876    16.211     0.200
     0.939    17.438     0.200
     1.182    20.844     0.200
     1.329    23.375     0.200
     1.346    23.312     0.200
     1.453    25.055     0.200
     1.543    26.352     0.200
     1.457    24.664     0.200
     1.766    30.297     0.200
     1.882    30.812     0.200
     1.959    32.133     0.200
     1.958    31.812     0.200
     1.903    32.375     0.200
     2.157    35.352     0.200
     2.162    34.891     0.200
     2.226    35.828     0.200
     2.223    35.273     0.200
     2.224    35.414     0.200
     2.230    35.875     0.200
     2.276    36.281     0.200
     2.308    36.188     0.200
     2.324    38.188     0.200
     2.371    40.742     0.200
     2.383    37.938     0.200
     2.501    39.727     0.200
     2.537    41.055     0.200
     2.594    41.875     0.200
     2.620    42.758     0.200
     2.846    43.438     0.200
     2.824    43.156     0.200
     2.834    42.633     0.200
     2.877    44.617     0.200
     3.779    56.758     0.200
     4.068    61.141     0.200
     4.039    63.547     0.200
     4.120    66.133     0.200
     4.125    65.086     0.200
     4.132    66.008     0.200
     4.153    65.547     0.200
     4.277    66.234     0.200
     4.912    73.039     0.200
     7.780   113.891     0.200
     7.780   114.094     0.200
     7.870   115.656     0.200
    12.596   180.914     0.200
     1.675    29.537     0.200
     1.686    29.848     0.200
     1.724    29.998     0.200
     1.788    31.059     0.200
     1.817    31.479     0.200
     1.918    32.857     0.200
     2.170    36.418     0.200
     2.135    35.318     0.200
     2.289    39.688     0.200
     2.309    38.217     0.200
     2.468    40.277     0.200
     2.617    42.908     0.200
     2.610    42.148     0.200
     2.632    42.059     0.200
     2.621    43.748     0.200
     2.652    42.658     0.200
     2.641    43.867     0.200
     2.754    45.367     0.200
     3.280    51.967     0.200
     3.331    50.838     0.200
     3.390    54.309     0.200
     3.390    52.627     0.200
     3.390    53.107     0.200
     4.047    60.178     0.200
     4.403    71.738     0.200
     4.375    66.242     0.200
     4.375    66.748     0.200
     4.736    74.068     0.200
     4.820    76.027     0.200
     4.825    76.258     0.200
     4.832    75.867     0.200
     4.853    75.697     0.200
     4.889    75.229     0.200
     4.966    72.357     0.200
     4.972    77.059     0.200
     6.010    90.268     0.200
     6.468    94.367     0.200
     6.710    99.367     0.200
     7.015   105.488     0.200
     7.015   107.908     0.200
     7.754   114.338     0.200
     8.148   120.229     0.200
     9.167   132.857     0.200
     9.978   145.408     0.200
    11.560   166.758     0.200
    11.560   165.125     0.200
    11.701   170.078     0.200
    12.023   173.047     0.200
    13.153   188.717     0.200
    13.153   189.277     0.200
    13.153   188.297     0.200
    13.153   188.707     0.200
    13.587   195.367     0.200
    13.592   192.998     0.200
    13.712   194.598     0.200
    13.712   192.480     0.200
    14.112   198.639     0.200
    14.599   207.287     0.200
    14.705   209.258     0.200
    15.095   212.809     0.200
    15.328   217.188     0.200
    15.600   218.658     0.200
    15.600   217.365     0.200
    15.847   224.928     0.200
    16.129   227.357     0.200
    16.148   227.697     0.200
    16.678   234.408     0.200
    16.962   236.928     0.200
    17.430   242.598     0.200
    17.430   242.365     0.200
    17.447   242.998     0.200
    17.473   243.816     0.200
    17.504   244.297     0.200
    17.964   248.498     0.200
    18.175   252.207     0.200
    18.211   252.238     0.200
    18.211   251.883     0.200
    18.289   251.867     0.200
    18.289   251.197     0.200
    18.382   255.758     0.200
    18.530   257.658     0.200
    18.554   258.012     0.200
    19.217   265.395     0.200
    19.436   267.758     0.200
    19.436   268.691     0.200
    20.093   275.059     0.200
    20.514   280.090     0.200
     0.171     7.918     0.200
     0.204     8.018     0.200
     0.463    10.969     0.200
     0.484    11.357     0.200
     0.576    12.238     0.200
     0.911    16.857     0.200
     1.069    19.379     0.200
     1.144    20.078     0.200
     1.253    22.668     0.200
     1.357    23.648     0.200
     1.515    26.178     0.200
     1.616    27.447     0.200
     1.683    29.059     0.200
     1.687    28.828     0.200
     1.973    31.527     0.200
     2.107    34.299     0.200
     2.122    34.758     0.200
     2.163    34.438     0.200
     2.214    36.219     0.200
     2.215    36.168     0.200
     2.229    35.598     0.200
     2.283    36.709     0.200
     2.345    38.129     0.200
     2.343    37.688     0.200
     2.386    38.549     0.200
     2.399    37.918     0.200
     2.458    39.768     0.200
     2.500    39.809     0.200
     2.521    39.879     0.200
     2.560    42.078     0.200
     2.590    40.898     0.200
     2.619    43.818     0.200
     2.771    44.469     0.200
     2.975    46.988     0.200
     3.166    48.828     0.200
     3.183    49.398     0.200
     3.336    51.738     0.200
     3.836    58.818     0.200
     3.857    57.277     0.200
     3.920    61.148     0.200
     3.925    62.988     0.200
     3.932    60.758     0.200
     3.953    61.549     0.200
     3.995    61.549     0.200
     4.073    62.629     0.200
     4.197    61.398     0.200
     4.245    64.818     0.200
     5.102    75.188     0.200
     0.477    11.703     0.200
     0.664    13.982     0.200
     0.923    17.104     0.200
     1.110    19.883     0.200
     1.275    22.354     0.200
     1.397    24.373     0.200
     1.399    24.242     0.200
     1.379    24.293     0.200
     1.519    26.094     0.200
     1.690    27.742     0.200
     1.801    29.723     0.200
     1.724    29.162     0.200
     1.930    31.873     0.200
     1.920    33.094     0.200
     1.960    31.443     0.200
     2.047    33.172     0.200
     2.135    34.922     0.200
     2.266    36.354     0.200
     2.263    36.764     0.200
     2.172    36.764     0.200
     2.286    36.684     0.200
     2.309    36.434     0.200
     2.299    36.844     0.200
     2.317    36.344     0.200
     2.317    36.344     0.200
     2.316    36.943     0.200
     2.362    37.982     0.200
     2.375    37.832     0.200
     2.375    38.223     0.200
     2.375    37.562     0.200
     2.375    37.832     0.200
     2.384    38.094     0.200
     2.411    38.283     0.200
     2.421    38.502     0.200
     2.445    39.463     0.200
     2.488    41.242     0.200
     2.533    39.773     0.200
     2.544    40.152     0.200
     2.548    39.893     0.200
     2.644    41.172     0.200
     2.690    41.703     0.200
     2.738    42.863     0.200
     2.710    42.912     0.200
     2.798    43.213     0.200
     2.878    44.184     0.200
     2.904    44.604     0.200
     2.907    45.844     0.200
     2.906    45.844     0.200
     2.915    45.252     0.200
     2.976    47.713     0.200
     3.143    47.752     0.200
     3.148    50.033     0.200
     3.248    52.162     0.200
     3.347    50.082     0.200
     3.347    50.082     0.200
     3.667    52.982     0.200
     3.638    55.723     0.200
     3.730    56.604     0.200
     3.766    54.992     0.200
     3.726    56.953     0.200
     3.854    58.062     0.200
     4.174    59.344     0.200
     4.308    67.123     0.200
     4.387    68.482     0.200
     4.392    68.934     0.200
     4.399    69.373     0.200
     4.419    68.883     0.200
     4.438    69.514     0.200
     4.469    68.252     0.200
     4.546    70.943     0.200
     4.684    67.422     0.200
     4.675    68.918     0.200
     4.675    69.543     0.200
     4.854    71.912     0.200
     5.203    72.723     0.200
     5.226    79.023     0.200
     5.386    79.053     0.200
     5.513    83.113     0.200
     5.588    84.252     0.200
     6.030    92.934     0.200
     6.305    94.293     0.200
     6.305    94.113     0.200
     6.369    92.844     0.200
     6.422    95.184     0.200
     7.353   108.732     0.200
     7.486   110.023     0.200
     7.519   111.232     0.200
     7.609   111.773     0.200
     7.854   112.703     0.200
     8.158   121.893     0.200
     9.478   137.473     0.200
     9.560   140.873     0.200
    10.330   149.184     0.200
    11.266   158.662     0.200
    11.266   159.859     0.200
    11.287   161.594     0.200
    11.928   168.684     0.200
    12.396   174.502     0.200
    12.778   181.492     0.200
    12.778   181.463     0.200
    12.778   181.607     0.200
    12.778   182.242     0.200
    13.376   186.283     0.200
    13.409   189.803     0.200
    13.409   189.150     0.200
    13.855   196.502     0.200
    13.855   194.264     0.200
    14.374   201.463     0.200
    14.937   208.453     0.200
    15.063   210.502     0.200
    15.063   210.215     0.200
    15.400   214.402     0.200
    15.486   217.930     0.200
    15.547   217.104     0.200
    15.547   216.307     0.200
    15.637   219.922     0.200
    15.788   220.922     0.200
    15.823   219.393     0.200
    16.375   228.594     0.200
    16.409   227.332     0.200
    16.561   227.604     0.200
    16.746   231.893     0.200
    17.071   234.453     0.200
    17.108   235.492     0.200
    17.059   235.934     0.200
    17.071   237.230     0.200
    17.103   236.443     0.200
    17.103   236.684     0.200
    17.307   237.412     0.200
    17.307   236.572     0.200
    17.355   238.572     0.200
    17.605   241.482     0.200
    17.654   242.863     0.200
    17.678   242.553     0.200
    17.678   242.381     0.200
    17.883   246.232     0.200
    17.883   245.652     0.200
    18.165   249.232     0.200
    18.165   249.488     0.200
    18.165   249.035     0.200
    18.239   249.045     0.200
    18.253   250.053     0.200
    18.266   251.033     0.200
    18.296   250.002     0.200
    18.323   250.832     0.200
    18.323   250.391     0.200
    18.531   255.273     0.200
    18.825   257.453     0.200
    18.836   258.627     0.200
    18.899   258.203     0.200
    20.110   272.711     0.200
     1.129    21.469     0.200
     1.145    21.102     0.200
     1.347    24.930     0.200
     1.499    27.559     0.200
     1.571    27.379     0.200
     1.611    28.020     0.200
     1.660    29.289     0.200
     1.618    28.680     0.200
     1.864    32.711     0.200
     1.883    32.352     0.200
     1.922    33.219     0.200
     2.080    35.238     0.200
     2.162    35.660     0.200
     2.177    37.750     0.200
     2.476    41.160     0.200
     2.491    42.820     0.200
     2.501    40.691     0.200
     2.500    40.910     0.200
     2.500    40.910     0.200
     2.502    41.879     0.200
     2.504    41.879     0.200
     2.584    42.449     0.200
     2.526    42.762     0.200
     2.574    42.539     0.200
     2.588    42.660     0.200
     2.588    43.680     0.200
     2.588    43.680     0.200
     2.588    43.559     0.200
     2.601    42.469     0.200
     2.616    43.211     0.200
     2.634    43.672     0.200
     2.657    43.891     0.200
     2.692    43.719     0.200
     2.715    43.969     0.200
     2.747    45.020     0.200
     2.760    44.879     0.200
     2.775    44.539     0.200
     2.849    45.500     0.200
     2.870    46.691     0.200
     2.869    46.691     0.200
     2.878    45.480     0.200
     2.857    47.172     0.200
     2.897    46.629     0.200
     3.091    52.629     0.200
     3.188    53.531     0.200
     3.206    51.730     0.200
     3.244    51.141     0.200
     3.607    56.719     0.200
     3.562    54.879     0.200
     3.563    54.879     0.200
     3.775    58.199     0.200
     3.781    57.301     0.200
     3.853    59.691     0.200
     3.933    58.762     0.200
     4.238    65.039     0.200
     4.289    68.379     0.200
     4.473    70.512     0.200
     4.565    73.699     0.200
     4.569    72.922     0.200
     4.575    73.180     0.200
     4.597    72.922     0.200
     4.616    74.359     0.200
     4.635    68.957     0.200
     4.635    70.172     0.200
     4.707    73.988     0.200
     4.718    69.770     0.200
     4.842    76.191     0.200
     5.355    80.102     0.200
     5.378    80.461     0.200
     5.743    85.512     0.200
     6.226    92.590     0.200
     6.277    96.199     0.200
     6.331    95.332     0.200
     6.536   100.141     0.200
     6.536    99.801     0.200
     7.285   109.469     0.200
     7.285   108.340     0.200
     7.384   111.012     0.200
     7.420   111.590     0.200
     7.507   112.199     0.200
    12.698   180.199     0.200
    13.013   186.211     0.200
    13.013   186.422     0.200
    13.013   186.648     0.200
    14.457   203.148     0.200
    14.750   209.480     0.200
    15.284   216.949     0.200
    15.284   217.078     0.200
    15.606   219.039     0.200
    15.606   220.336     0.200
    15.643   221.359     0.200
    15.721   223.293     0.200
    15.777   223.105     0.200
    16.023   226.012     0.200
    16.739   235.832     0.200
    17.302   242.879     0.200
    17.292   240.832     0.200
    17.338   242.730     0.200
    17.553   243.832     0.200
    17.851   248.441     0.200
    17.856   247.891     0.200
    17.905   248.012     0.200
    17.905   249.312     0.200
    18.159   250.461     0.200
    18.379   256.289     0.200
    18.430   257.102     0.200
    18.430   257.586     0.200
    19.071   264.047     0.200
    19.223   266.727     0.200
    19.915   273.711     0.200
    20.341   278.777     0.200
    20.472   279.980     0.200
     1.576    28.441     0.200
     1.689    30.359     0.200
     1.810    32.129     0.200
     1.987    34.680     0.200
     1.864    33.242     0.200
     2.289    39.602     0.200
     2.289    39.602     0.200
     2.403    41.391     0.200
     2.495    41.730     0.200
     2.529    41.730     0.200
     2.635    43.801     0.200
     2.635    43.820     0.200
     2.682    43.551     0.200
     2.599    42.680     0.200
     2.752    47.160     0.200
     2.793    47.879     0.200
     2.820    47.789     0.200
     2.850    49.051     0.200
     2.871    47.109     0.200
     2.871    48.430     0.200
     2.872    47.109     0.200
     2.957    50.469     0.200
     2.974    50.941     0.200
     2.984    50.492     0.200
     3.131    53.301     0.200
     3.316    56.121     0.200
     3.336    53.770     0.200
     3.387    57.742     0.200
     3.597    55.270     0.200
     3.835    63.430     0.200
     3.814    60.852     0.200
     3.953    60.148     0.200
     4.025    62.766     0.200
     4.025    62.660     0.200
     4.100    60.582     0.200
     4.509    69.699     0.200
     4.679    69.859     0.200
     4.758    72.648     0.200
     5.041    82.051     0.200
     5.204    81.930     0.200
     5.289    83.750     0.200
     5.294    82.762     0.200
     5.301    84.109     0.200
     5.321    84.469     0.200
     5.340    85.922     0.200
     5.355    84.109     0.200
     5.439    85.320     0.200
     5.637    85.059     0.200
     5.675    87.430     0.200
     6.112    93.352     0.200
     6.588    98.301     0.200
     6.621   100.750     0.200
     7.118   109.461     0.200
     7.118   107.922     0.200
     8.420   125.340     0.200
     8.796   130.180     0.200
    10.882   154.289     0.200
    11.826   171.840     0.200
    11.826   169.961     0.200
    12.999   185.930     0.200
    13.517   195.070     0.200
    16.247   230.512     0.200
    17.501   244.285     0.200
    17.599   246.410     0.200
    17.772   248.621     0.200
    18.446   258.211     0.200
    18.514   257.473     0.200
    19.055   266.461     0.200
    19.055   266.176     0.200
    19.877   275.543     0.200
    20.500   282.441     0.200
     1.011    18.234     0.200
     1.454    24.070     0.200
     1.811    30.422     0.200
     1.861    30.656     0.200
     2.016    32.805     0.200
     2.210    36.070     0.200
     2.283    37.492     0.200
     2.407    38.070     0.200
     2.450    39.375     0.200
     2.561    41.422     0.200
     2.572    41.461     0.200
     2.697    40.031     0.200
     2.814    45.594     0.200
     3.250    50.641     0.200
     3.314    51.016     0.200
     3.427    52.781     0.200
     3.592    58.156     0.200
     3.680    58.836     0.200
     3.684    57.867     0.200
     3.712    57.867     0.200
     3.751    58.938     0.200
     3.920    58.688     0.200
     0.282     8.906     0.200
     0.353     9.547     0.200
     0.594    12.484     0.200
     0.649    13.613     0.200
     0.745    14.375     0.200
     0.771    14.555     0.200
     0.980    18.273     0.200
     1.118    20.336     0.200
     1.243    21.727     0.200
     1.228    21.965     0.200
     1.303    22.523     0.200
     1.582    27.504     0.200
     1.636    27.715     0.200
     1.647    27.305     0.200
     1.786    29.406     0.200
     1.808    30.934     0.200
     1.792    29.965     0.200
     1.803    30.715     0.200
     1.807    30.406     0.200
     1.892    31.273     0.200
     2.040    33.934     0.200
     2.103    34.176     0.200
     2.120    35.516     0.200
     2.129    35.766     0.200
     2.144    37.434     0.200
     2.142    35.324     0.200
     2.215    33.977     0.200
     2.483    40.797     0.200
     2.643    41.195     0.200
     2.664    42.086     0.200
     2.796    43.926     0.200
     2.905    47.656     0.200
     3.493    52.695     0.200
     3.588    53.797     0.200
     3.721    56.156     0.200
     4.563    67.254     0.200
     1.818    31.685     0.200
     1.925    32.414     0.200
     2.130    35.984     0.200
     2.224    37.114     0.200
     2.286    38.484     0.200
     2.525    42.005     0.200
     2.525    42.005     0.200
     2.555    43.034     0.200
     2.566    43.095     0.200
     2.598    43.064     0.200
     2.594    43.944     0.200
     2.601    43.534     0.200
     2.617    43.685     0.200
     2.619    43.534     0.200
     2.671    45.034     0.200
     2.670    45.034     0.200
     2.671    44.265     0.200
     2.679    44.345     0.200
     2.694    43.994     0.200
     2.676    44.954     0.200
     2.665    44.215     0.200
     2.716    45.675     0.200
     2.745    45.685     0.200
     2.658    45.875     0.200
     2.678    45.805     0.200
     2.784    44.555     0.200
     2.791    45.744     0.200
     2.938    48.005     0.200
     3.106    51.465     0.200
     3.646    59.045     0.200
     3.701    57.335     0.200
     3.698    57.064     0.200
     4.040    62.484     0.200
     4.206    63.295     0.200
     4.410    68.324     0.200
     4.737    74.354     0.200
     4.652    72.364     0.200
     4.826    75.215     0.200
     4.830    76.675     0.200
     4.837    76.564     0.200
     4.858    76.694     0.200
     4.877    78.805     0.200
     4.887    76.015     0.200
     4.971    77.564     0.200
     5.221    77.675     0.200
     5.134    78.164     0.200
     5.954    91.284     0.200
     6.008    90.305     0.200
     6.082    93.704     0.200
     6.079    92.284     0.200
     6.381    93.265     0.200
     7.043   103.364     0.200
     7.251   109.814     0.200
    11.197   160.714     0.200
    12.749   184.635     0.200
    12.812   185.114     0.200
    13.193   190.345     0.200
    13.457   193.305     0.200
    13.761   197.564     0.200
    14.279   205.194     0.200
    14.568   208.675     0.200
    15.465   219.663     0.200
    15.645   222.305     0.200
    16.720   234.805     0.200
    18.568   259.364     0.200
    18.586   260.654     0.200
    18.655   259.755     0.200
    18.725   259.104     0.200
    19.256   266.295     0.200
    19.256   265.965     0.200
    19.289   265.545     0.200
    19.340   266.085     0.200
    19.359   266.005     0.200
    19.403   266.515     0.200
    19.438   267.074     0.200
    19.459   269.824     0.200
    19.806   271.385     0.200
    19.811   271.465     0.200
    19.905   272.595     0.200
    19.981   273.444     0.200
    20.125   276.895     0.200
    20.122   275.755     0.200
    20.152   275.795     0.200
    20.212   276.524     0.200
    20.351   278.284     0.200
    20.691   281.625     0.200
     1.009    18.180     0.200
     1.117    19.871     0.200
     1.391    24.070     0.200
     1.921    32.211     0.200
     1.986    33.043     0.200
     2.027    32.531     0.200
     2.188    36.543     0.200
     2.206    36.352     0.200
     2.259    37.051     0.200
     2.442    40.141     0.200
     2.790    43.922     0.200
     3.009    47.082     0.200
     3.249    49.922     0.200
     3.967    63.711     0.200
     4.052    65.551     0.200
     0.142     8.145     0.200
     0.281     8.994     0.200
     0.349     9.664     0.200
     0.576    12.363     0.200
     0.724    14.264     0.200
     0.762    15.193     0.200
     1.000    18.594     0.200
     1.133    20.814     0.200
     1.240    22.193     0.200
     1.235    22.273     0.200
     1.283    22.764     0.200
     1.560    27.354     0.200
     1.670    27.574     0.200
     1.650    28.154     0.200
     1.764    29.055     0.200
     1.793    31.023     0.200
     1.788    29.295     0.200
     1.794    31.994     0.200
     1.827    30.764     0.200
     1.907    31.715     0.200
     2.097    33.305     0.200
     2.121    34.465     0.200
     2.125    34.613     0.200
     2.135    34.465     0.200
     2.136    34.705     0.200
     2.142    34.295     0.200
     2.147    34.324     0.200
     2.207    34.215     0.200
     2.219    35.164     0.200
     2.240    36.295     0.200
     2.278    37.523     0.200
     2.380    37.674     0.200
     2.477    39.965     0.200
     2.536    40.205     0.200
     2.687    42.443     0.200
     3.502    52.744     0.200
     3.590    52.875     0.200
     3.672    55.555     0.200
     3.739    56.564     0.200
     4.583    68.764     0.200
     1.232    21.127     0.200
     1.717    30.438     0.200
     1.744    30.467     0.200
     1.747    29.928     0.200
     1.900    32.447     0.200
     2.250    39.137     0.200
     2.253    35.836     0.200
     2.359    38.258     0.200
     2.415    39.727     0.200
     2.597    41.207     0.200
     2.598    42.236     0.200
     2.567    41.787     0.200
     2.615    42.707     0.200
     2.669    42.836     0.200
     2.673    42.848     0.200
     2.697    43.836     0.200
     2.675    43.268     0.200
     2.699    44.508     0.200
     2.710    44.736     0.200
     2.711    44.268     0.200
     2.730    42.938     0.200
     2.739    43.848     0.200
     2.739    45.316     0.200
     2.755    44.367     0.200
     2.769    44.598     0.200
     2.768    44.277     0.200
     2.768    44.277     0.200
     2.785    44.348     0.200
     2.755    44.227     0.200
     2.818    46.867     0.200
     2.885    45.557     0.200
     2.903    46.098     0.200
     2.922    47.678     0.200
     2.918    46.678     0.200
     2.978    48.656     0.200
     2.974    46.688     0.200
     3.129    49.758     0.200
     3.121    47.326     0.200
     3.161    47.707     0.200
     3.199    50.227     0.200
     3.297    51.586     0.200
     3.426    53.307     0.200
     3.536    55.367     0.200
     3.536    55.367     0.200
     3.544    53.246     0.200
     3.564    55.236     0.200
     3.650    55.666     0.200
     3.651    55.666     0.200
     3.733    59.047     0.200
     3.861    60.416     0.200
     3.950    63.797     0.200
     3.979    63.457     0.200
     3.979    62.887     0.200
     3.984    63.086     0.200
     3.985    60.887     0.200
     4.001    61.697     0.200
     4.010    63.768     0.200
     4.028    63.826     0.200
     4.084    63.646     0.200
     4.239    62.967     0.200
     4.239    61.906     0.200
     4.287    64.887     0.200
     4.492    67.777     0.200
     4.582    72.277     0.200
     4.744    72.086     0.200
     4.740    71.416     0.200
     4.742    70.447     0.200
     4.971    73.957     0.200
     4.999    78.416     0.200
     5.108    77.066     0.200
     5.304    78.646     0.200
     5.317    77.887     0.200
     5.391    83.357     0.200
     5.683    88.307     0.200
     5.841    90.098     0.200
     6.019    87.637     0.200
     6.199    93.326     0.200
     6.199    96.826     0.200
     6.270    92.188     0.200
     6.276    96.697     0.200
     6.992   104.258     0.200
     7.015   102.947     0.200
     7.967   118.146     0.200
     8.031   119.076     0.200
     8.439   125.996     0.200
     8.691   128.367     0.200
     8.713   127.896     0.200
     8.724   127.996     0.200
     9.035   129.537     0.200
     9.355   138.877     0.200
    10.091   150.477     0.200
    10.105   144.916     0.200
    10.268   146.496     0.200
    10.916   158.117     0.200
    10.937   159.027     0.200
    11.127   162.787     0.200
    11.127   163.387     0.200
    11.117   163.666     0.200
    11.117   164.166     0.200
    11.432   164.697     0.200
    11.432   163.889     0.200
    11.432   164.199     0.200
    11.576   169.018     0.200
    11.721   170.316     0.200
    11.990   171.547     0.200
    11.990   170.607     0.200
    11.990   169.740     0.200
    12.162   175.166     0.200
    12.489   179.406     0.200
    12.637   180.928     0.200
    12.752   183.387     0.200
    12.752   182.930     0.200
    12.752   182.857     0.200
    12.752   183.922     0.200
    12.982   186.197     0.200
    12.982   186.357     0.200
    12.982   186.857     0.200
    13.111   189.598     0.200
    13.553   191.717     0.200
    13.553   193.406     0.200
    13.553   192.818     0.200
    13.674   194.377     0.200
    13.674   192.496     0.200
    13.997   200.678     0.200
    13.970   200.496     0.200
    13.970   201.396     0.200
    14.083   200.777     0.200
    14.083   199.562     0.200
    14.403   203.916     0.200
    14.459   205.326     0.200
    14.549   207.727     0.200
    14.765   210.326     0.200
    14.985   212.336     0.200
    14.938   213.258     0.200
    15.287   215.277     0.200
    15.287   215.578     0.200
    15.298   216.986     0.200
    15.305   215.666     0.200
    15.305   215.951     0.200
    15.428   219.438     0.200
    15.428   218.312     0.200
    15.428   218.197     0.200
    15.552   220.586     0.200
    15.552   221.066     0.200
    15.629   219.396     0.200
    15.629   219.279     0.200
    15.644   219.656     0.200
    15.694   221.146     0.200
    15.694   220.912     0.200
    15.694   221.416     0.200
    15.714   220.496     0.200
    15.714   219.918     0.200
    15.714   221.285     0.200
    15.729   220.727     0.200
    15.742   223.807     0.200
    15.767   224.307     0.200
    15.778   224.307     0.200
    15.861   222.996     0.200
    15.921   224.086     0.200
    15.936   223.916     0.200
    15.991   227.598     0.200
    15.992   225.576     0.200
    16.014   226.836     0.200
    16.018   227.836     0.200
    16.149   226.547     0.200
    16.178   229.357     0.200
    16.233   227.518     0.200
    16.234   227.598     0.200
    16.189   228.848     0.200
    16.380   229.086     0.200
    16.395   229.916     0.200
    16.631   232.416     0.200
    16.631   232.131     0.200
    16.951   237.078     0.200
    16.951   237.740     0.200
    16.977   236.600     0.200
    17.034   237.742     0.200
    17.151   239.947     0.200
    17.151   239.703     0.200
    17.550   244.258     0.200
    17.699   244.947     0.200
    17.716   244.600     0.200
    17.716   245.855     0.200
    17.742   244.861     0.200
    17.848   246.947     0.200
    17.848   246.600     0.200
    17.968   249.266     0.200
    18.210   251.885     0.200
    18.752   261.438     0.200
    18.752   259.688     0.200
    18.786   259.920     0.200
    18.786   261.213     0.200
    18.786   260.496     0.200
    18.786   260.992     0.200
    19.663   271.537     0.200
    19.981   274.365     0.200
    20.974   285.922     0.200
     1.058    19.477     0.200
     1.240    22.047     0.200
     1.422    24.867     0.200
     1.450    25.633     0.200
     1.467    25.656     0.200
     1.551    26.719     0.200
     1.535    26.688     0.200
     1.753    28.844     0.200
     1.672    28.594     0.200
     1.951    32.188     0.200
     2.053    34.008     0.200
     2.018    34.547     0.200
     2.107    33.766     0.200
     2.192    35.656     0.200
     2.236    36.562     0.200
     2.470    38.914     0.200
     2.514    40.469     0.200
     2.770    43.258     0.200
     2.842    44.148     0.200
     2.942    45.625     0.200
     3.018    47.578     0.200
     3.036    48.273     0.200
     3.036    50.312     0.200
     3.484    52.445     0.200
     3.584    55.039     0.200
     3.791    57.773     0.200
     4.077    66.539     0.200
     4.330    65.656     0.200
     4.786    71.383     0.200
     4.824    69.648     0.200
     4.967    76.305     0.200
     5.501    80.523     0.200
     5.549    83.719     0.200
     6.033    92.695     0.200
     6.179    94.156     0.200
     6.369    95.359     0.200
     6.369    97.086     0.200
     6.505    95.312     0.200
     7.450   108.586     0.200
     9.586   137.062     0.200
    11.386   161.656     0.200
    11.386   162.484     0.200
    11.493   160.812     0.200
    11.493   162.477     0.200
    11.517   166.867     0.200
    12.491   177.047     0.200
    12.590   178.836     0.200
    12.862   184.828     0.200
    13.164   186.016     0.200
    13.526   190.594     0.200
    13.526   191.086     0.200
    13.853   194.469     0.200
    13.986   197.438     0.200
    14.013   198.492     0.200
    14.352   200.477     0.200
    14.594   206.359     0.200
    14.620   206.508     0.200
    14.999   210.844     0.200
    15.168   214.180     0.200
    15.193   211.773     0.200
    15.193   213.297     0.200
    15.353   214.586     0.200
    15.441   215.305     0.200
    15.542   215.898     0.200
    15.542   218.344     0.200
    15.551   215.625     0.200
    15.565   218.969     0.200
    15.630   218.008     0.200
    15.665   219.914     0.200
    15.920   223.109     0.200
    15.920   224.055     0.200
    15.915   221.734     0.200
    15.926   222.633     0.200
    16.885   236.867     0.200
    17.136   239.070     0.200
    17.200   238.180     0.200
    17.203   239.727     0.200
    17.501   241.914     0.200
    17.990   248.570     0.200
    18.240   252.836     0.200
    19.038   263.430     0.200
    19.117   263.969     0.200
     1.177    21.531     0.200
     1.300    23.113     0.200
     1.338    23.723     0.200
     1.371    24.230     0.200
     1.630    26.934     0.200
     1.583    28.023     0.200
     1.703    28.832     0.200
     1.840    30.980     0.200
     1.887    31.023     0.200
     1.891    32.953     0.200
     1.950    32.332     0.200
     2.054    34.062     0.200
     2.235    36.441     0.200
     2.228    38.730     0.200
     2.593    41.082     0.200
     2.650    41.934     0.200
     2.701    42.391     0.200
     2.820    45.070     0.200
     2.973    50.410     0.200
     4.357    67.344     0.200
     4.429    68.250     0.200
     4.435    69.203     0.200
     4.443    69.434     0.200
     4.481    70.242     0.200
     4.589    67.840     0.200
     4.525    68.422     0.200
     0.220     8.027     0.200
     0.606    12.379     0.200
     0.765    14.438     0.200
     0.828    15.699     0.200
     0.969    17.590     0.200
     1.013    18.168     0.200
     1.141    20.160     0.200
     1.196    20.438     0.200
     1.243    22.258     0.200
     1.291    22.770     0.200
     1.417    24.848     0.200
     1.468    24.898     0.200
     1.523    26.020     0.200
     1.842    31.160     0.200
     1.920    32.500     0.200
     2.026    33.180     0.200
     2.157    36.160     0.200
     2.199    36.109     0.200
     2.196    37.098     0.200
     3.213    48.160     0.200
     3.174    48.938     0.200
     3.352    55.188     0.200
     3.964    59.527     0.200
     4.337    62.520     0.200
     6.634   100.117     0.200
     0.150     8.539     0.200
     0.394    10.891     0.200
     0.754    14.852     0.200
     0.640    13.812     0.200
     0.788    15.562     0.200
     0.935    17.930     0.200
     1.071    19.938     0.200
     1.182    21.500     0.200
     1.223    22.031     0.200
     1.311    23.070     0.200
     1.590    27.414     0.200
     1.616    27.320     0.200
     1.621    26.969     0.200
     1.763    28.914     0.200
     1.783    29.398     0.200
     1.763    29.922     0.200
     1.845    31.023     0.200
     1.825    30.469     0.200
     2.077    33.953     0.200
     1.999    33.461     0.200
     2.101    33.867     0.200
     2.108    33.789     0.200
     2.107    34.258     0.200
     2.126    34.531     0.200
     2.123    33.359     0.200
     2.189    35.641     0.200
     2.189    35.617     0.200
     2.189    34.914     0.200
     2.204    36.031     0.200
     2.214    36.508     0.200
     2.216    35.711     0.200
     2.235    35.961     0.200
     2.261    36.461     0.200
     2.316    34.797     0.200
     2.339    36.180     0.200
     2.348    37.148     0.200
     2.250    38.539     0.200
     2.477    39.242     0.200
     2.597    40.570     0.200
     2.707    41.750     0.200
     2.809    46.281     0.200
     2.761    40.023     0.200
     2.927    43.961     0.200
     2.912    46.672     0.200
     2.912    45.438     0.200
     3.047    46.383     0.200
     3.164    47.969     0.200
     3.163    47.969     0.200
     3.242    49.844     0.200
     3.449    51.719     0.200
     3.606    55.203     0.200
     3.675    54.641     0.200
     3.636    56.812     0.200
     3.731    55.578     0.200
     3.955    57.188     0.200
     4.443    69.484     0.200
     4.365    65.789     0.200
     4.488    64.664     0.200
     4.427    68.492     0.200
     4.443    68.070     0.200
     4.460    69.148     0.200
     4.480    68.000     0.200
     4.543    67.570     0.200
     4.602    68.797     0.200
     5.223    77.141     0.200
     5.299    76.922     0.200
     5.443    80.992     0.200
     5.657    82.133     0.200
     5.884    84.328     0.200
     5.909    88.320     0.200
     6.041    88.219     0.200
     6.228    91.133     0.200
     6.228    93.117     0.200
     6.303    92.812     0.200
     7.214   108.000     0.200
     7.375   107.930     0.200
     7.406   108.500     0.200
     7.498   108.578     0.200
     7.693   113.539     0.200
     8.425   125.953     0.200
     9.512   135.453     0.200
    11.106   157.289     0.200
    11.162   157.008     0.200
    11.162   157.734     0.200
    11.222   159.539     0.200
    11.564   167.281     0.200
    12.234   173.148     0.200
    12.669   178.648     0.200
    12.669   180.664     0.200
    12.670   179.414     0.200
    13.253   185.000     0.200
    13.253   186.219     0.200
    13.763   194.078     0.200
    14.067   196.492     0.200
    14.416   201.344     0.200
    14.888   208.547     0.200
    15.124   210.711     0.200
    15.206   211.570     0.200
    15.390   214.188     0.200
    15.390   215.367     0.200
    15.923   221.664     0.200
    16.653   231.539     0.200
    17.155   235.281     0.200
    17.514   240.258     0.200
    18.129   248.742     0.200
    18.733   256.602     0.200
    18.733   257.094     0.200
    18.733   257.562     0.200
    18.971   260.188     0.200
    20.031   272.328     0.200
     0.089     6.711     0.200
     0.290     8.613     0.200
     0.662    13.480     0.200
     0.784    15.082     0.200
     0.840    16.172     0.200
     0.976    17.863     0.200
     0.981    18.312     0.200
     1.046    18.664     0.200
     1.352    22.992     0.200
     1.391    24.332     0.200
     1.490    26.551     0.200
     1.612    27.293     0.200
     1.705    29.062     0.200
     1.785    29.332     0.200
     1.839    31.812     0.200
     2.014    32.062     0.200
     2.215    35.152     0.200
     2.260    37.004     0.200
     2.372    37.883     0.200
     2.384    37.184     0.200
     2.384    37.371     0.200
     2.426    38.383     0.200
     2.436    38.082     0.200
     2.445    37.613     0.200
     2.548    40.223     0.200
     2.782    44.473     0.200
     2.958    46.082     0.200
     3.292    49.703     0.200
     3.716    61.262     0.200
     3.748    61.391     0.200
     3.767    61.754     0.200
     3.865    60.922     0.200
     3.872    62.582     0.200
     3.999    61.594     0.200
     4.423    67.633     0.200
     0.371    10.328     0.200
     0.413    10.408     0.200
     0.587    12.467     0.200
     0.647    13.387     0.200
     0.834    16.248     0.200
     0.838    16.088     0.200
     0.989    18.367     0.200
     1.124    20.137     0.200
     1.183    21.338     0.200
     1.173    20.447     0.200
     1.228    22.197     0.200
     1.358    23.748     0.200
     1.388    23.938     0.200
     1.711    28.707     0.200
     1.753    29.479     0.200
     1.933    32.938     0.200
     1.934    32.547     0.200
     1.934    33.238     0.200
     1.971    33.357     0.200
     1.996    33.678     0.200
     2.101    32.117     0.200
     2.122    34.979     0.200
     2.131    34.387     0.200
     2.172    36.557     0.200
     2.209    34.607     0.200
     2.200    34.098     0.200
     2.203    34.979     0.200
     2.329    37.207     0.200
     4.945    75.297     0.200
     4.959    76.877     0.200
     4.980    76.287     0.200
     5.111    77.207     0.200
     1.919    31.404     0.200
     1.952    32.623     0.200
     1.975    31.744     0.200
     2.151    35.703     0.200
     2.160    35.635     0.200
     2.196    36.543     0.200
     2.222    36.434     0.200
     2.243    36.174     0.200
     2.249    36.693     0.200
     2.249    36.885     0.200
     2.284    37.533     0.200
     2.286    36.953     0.200
     2.288    37.023     0.200
     2.291    37.084     0.200
     2.291    37.324     0.200
     2.313    37.713     0.200
     2.343    38.135     0.200
     2.362    36.164     0.200
     2.393    38.914     0.200
     2.434    40.533     0.200
     2.508    40.824     0.200
     2.589    42.193     0.200
     2.732    44.623     0.200
     2.796    45.373     0.200
     2.803    46.154     0.200
     2.829    44.924     0.200
     2.850    45.623     0.200
     2.972    46.744     0.200
     2.995    46.885     0.200
     3.150    49.725     0.200
     3.258    53.145     0.200
     3.542    55.543     0.200
     3.780    57.123     0.200
     4.008    59.834     0.200
     4.069    61.604     0.200
     4.110    65.123     0.200
     4.130    65.123     0.200
     4.149    64.773     0.200
     4.182    63.014     0.200
     4.260    65.174     0.200
     4.566    69.783     0.200
     4.917    73.793     0.200
     4.939    74.213     0.200
     5.300    80.834     0.200
     5.621    81.674     0.200
     5.746    85.543     0.200
     6.065    91.783     0.200
     0.210     7.938     0.200
     0.226     8.039     0.200
     0.274     8.633     0.200
     0.331     9.164     0.200
     0.498    11.242     0.200
     0.842    15.953     0.200
     0.873    17.125     0.200
     1.242    22.492     0.200
     1.349    23.203     0.200
     1.348    24.336     0.200
     1.378    24.375     0.200
     1.378    24.508     0.200
     1.478    25.938     0.200
     1.555    26.125     0.200
     1.861    30.312     0.200
     1.891    31.719     0.200
     1.934    31.477     0.200
     2.000    33.680     0.200
     2.069    34.305     0.200
     2.224    36.312     0.200
     2.232    36.508     0.200
     2.241    36.594     0.200
     2.238    36.359     0.200
     2.251    36.703     0.200
     2.264    36.125     0.200
     2.276    36.594     0.200
     2.285    36.812     0.200
     2.290    37.539     0.200
     2.292    36.992     0.200
     2.292    37.312     0.200
     2.294    36.992     0.200
     2.316    37.359     0.200
     2.314    37.453     0.200
     2.314    37.453     0.200
     2.329    36.312     0.200
     2.329    37.523     0.200
     2.463    39.062     0.200
     2.547    40.836     0.200
     2.650    41.719     0.200
     2.774    43.586     0.200
     2.783    43.562     0.200
     2.832    44.828     0.200
     2.832    46.078     0.200
     2.866    45.047     0.200
     2.881    44.930     0.200
     2.903    45.477     0.200
     3.023    47.758     0.200
     3.053    48.266     0.200
     3.054    48.266     0.200
     3.083    51.008     0.200
     3.062    47.055     0.200
     3.082    49.617     0.200
     3.294    49.797     0.200
     3.295    49.797     0.200
     3.468    52.562     0.200
     3.619    55.906     0.200
     3.619    58.055     0.200
     3.727    55.164     0.200
     3.776    54.789     0.200
     3.869    61.680     0.200
     3.895    59.203     0.200
     3.984    60.125     0.200
     4.227    66.508     0.200
     4.247    66.859     0.200
     4.265    68.688     0.200
     4.231    63.469     0.200
     4.266    66.703     0.200
     4.297    65.289     0.200
     4.377    67.633     0.200
     4.596    68.656     0.200
     4.821    72.133     0.200
     5.054    75.953     0.200
     5.331    77.234     0.200
     5.368    80.555     0.200
     5.416    81.039     0.200
     5.861    89.680     0.200
     5.980    86.016     0.200
     6.163    92.906     0.200
     6.163    90.469     0.200
     6.163    91.133     0.200
     6.584    96.828     0.200
     7.508   108.977     0.200
     7.508   110.648     0.200
     7.772   111.547     0.200
     9.406   139.844     0.200
    10.519   151.453     0.200
    11.139   160.719     0.200
    11.359   166.828     0.200
    11.470   161.562     0.200
    11.470   160.773     0.200
    12.284   172.617     0.200
    12.653   181.305     0.200
    12.954   184.008     0.200
    13.644   192.328     0.200
    13.805   194.023     0.200
    14.149   197.125     0.200
    14.386   202.688     0.200
    14.411   203.023     0.200
    14.653   207.273     0.200
    14.791   207.906     0.200
    14.912   209.398     0.200
    14.995   210.164     0.200
    15.269   213.047     0.200
    15.300   213.727     0.200
    15.356   215.617     0.200
    15.356   216.125     0.200
    15.353   213.906     0.200
    15.358   213.273     0.200
    15.460   215.695     0.200
    15.518   218.164     0.200
    15.597   220.734     0.200
    15.647   219.586     0.200
    15.670   219.828     0.200
    15.714   219.148     0.200
    15.736   220.289     0.200
    15.948   222.398     0.200
    15.950   222.328     0.200
    15.962   223.086     0.200
    15.961   222.594     0.200
    16.158   225.867     0.200
    16.563   231.555     0.200
    16.697   230.992     0.200
    16.993   235.812     0.200
    17.323   237.328     0.200
    17.476   240.938     0.200
    17.596   241.477     0.200
    17.862   246.516     0.200
    17.935   246.969     0.200
    18.013   249.477     0.200
    18.024   249.977     0.200
    18.707   258.305     0.200
     1.410    25.939     0.200
     1.410    25.799     0.200
     1.603    27.520     0.200
     1.557    28.180     0.200
     1.595    28.088     0.200
     1.636    28.578     0.200
     1.637    28.908     0.200
     1.806    30.908     0.200
     1.945    33.199     0.200
     1.992    34.309     0.200
     2.152    37.229     0.200
     2.170    36.369     0.200
     2.192    36.449     0.200
     2.274    38.959     0.200
     2.474    41.279     0.200
     2.498    41.449     0.200
     2.538    42.379     0.200
     2.539    42.379     0.200
     2.648    43.158     0.200
     2.611    43.299     0.200
     2.612    42.939     0.200
     2.741    44.459     0.200
     2.738    44.100     0.200
     2.837    45.629     0.200
     2.854    45.758     0.200
     2.916    46.430     0.200
     2.940    47.629     0.200
     2.940    47.629     0.200
     2.948    46.680     0.200
     2.968    47.168     0.200
     3.185    54.020     0.200
     3.185    52.049     0.200
     3.306    53.100     0.200
     3.585    57.359     0.200
     3.672    56.838     0.200
     3.715    57.008     0.200
     3.838    58.129     0.200
     3.923    60.838     0.200
     3.977    60.020     0.200
     4.346    65.309     0.200
     4.547    70.619     0.200
     4.565    69.398     0.200
     4.566    73.789     0.200
     4.667    72.699     0.200
     4.705    72.318     0.200
     4.705    71.264     0.200
     4.786    70.318     0.200
     4.870    77.109     0.200
     5.321    80.078     0.200
     5.275    78.229     0.200
     5.686    86.299     0.200
     5.721    86.879     0.200
     6.182    97.219     0.200
     6.292    95.889     0.200
     6.386    97.850     0.200
     6.398    95.949     0.200
     6.517    99.209     0.200
     6.517    98.508     0.200
     6.517    99.939     0.200
     7.355   109.969     0.200
     7.355   109.838     0.200
     7.450   108.898     0.200
     7.486   111.078     0.200
     9.754   145.418     0.200
    11.449   164.979     0.200
    11.491   167.559     0.200
    11.491   168.180     0.200
    11.506   166.479     0.200
    12.365   179.318     0.200
    12.618   181.199     0.200
    12.709   182.389     0.200
    13.004   187.818     0.200
    13.004   187.648     0.200
    13.298   192.100     0.200
    13.648   196.689     0.200
    13.993   200.379     0.200
    14.470   204.109     0.200
    14.738   209.939     0.200
    14.756   210.418     0.200
    15.791   224.463     0.200
    15.786   223.309     0.200
    15.935   226.369     0.200
    16.870   237.020     0.200
    18.403   257.248     0.200
    19.060   264.109     0.200
     1.797    29.703     0.200
     1.843    31.023     0.200
     1.926    31.984     0.200
     2.008    33.434     0.200
     2.100    34.574     0.200
     2.227    37.055     0.200
     2.259    36.754     0.200
     2.298    37.094     0.200
     2.729    41.934     0.200
     2.852    44.223     0.200
     2.867    46.043     0.200
     2.992    47.434     0.200
     3.689    56.242     0.200
     3.755    56.633     0.200
     4.288    65.395     0.200
     4.308    66.102     0.200
     4.327    66.715     0.200
     4.439    68.082     0.200
     4.760    70.703     0.200
     1.252    22.508     0.200
     1.252    22.398     0.200
     1.459    24.672     0.200
     1.772    29.648     0.200
     2.500    38.711     0.200
     2.519    38.188     0.200
     2.816    44.273     0.200
     3.121    46.320     0.200
     3.653    57.508     0.200
     3.949    62.078     0.200
     4.239    62.633     0.200
     4.198    60.469     0.200
     4.330    66.391     0.200
     4.969    72.820     0.200
     5.401    84.367     0.200
     6.535   101.844     0.200
     6.846   101.031     0.200
     6.846   101.570     0.200
     6.970   104.648     0.200
     6.970   102.547     0.200
     6.970   103.781     0.200
     7.031   101.320     0.200
     9.776   141.188     0.200
    11.824   168.789     0.200
    11.770   167.680     0.200
    12.223   178.562     0.200
    12.801   182.750     0.200
    12.924   182.281     0.200
    12.970   183.453     0.200
    13.401   190.398     0.200
    13.400   190.484     0.200
    13.400   192.141     0.200
    13.648   192.289     0.200
    13.754   194.117     0.200
    13.754   197.430     0.200
    13.926   196.039     0.200
    14.382   203.281     0.200
    14.380   205.469     0.200
    14.458   205.883     0.200
    14.723   208.922     0.200
    15.117   213.422     0.200
    15.115   215.281     0.200
    15.152   214.570     0.200
    15.387   218.992     0.200
    15.440   220.188     0.200
    15.760   222.961     0.200
    16.059   224.258     0.200
    16.122   225.438     0.200
    16.245   227.438     0.200
    16.371   230.141     0.200
    16.415   229.734     0.200
    16.475   229.867     0.200
    16.538   230.594     0.200
    16.569   230.734     0.200
    16.586   231.617     0.200
    16.619   232.359     0.200
    16.772   234.680     0.200
    16.858   233.414     0.200
    17.131   238.023     0.200
    17.210   240.172     0.200
    17.303   238.312     0.200
    17.521   243.109     0.200
    17.549   243.547     0.200
    17.634   245.500     0.200
    17.681   244.664     0.200
    17.678   245.633     0.200
    17.731   247.094     0.200
    17.884   247.703     0.200
    17.992   248.367     0.200
    18.073   250.141     0.200
    18.169   249.711     0.200
    18.295   254.023     0.200
    18.365   252.430     0.200
    18.756   259.523     0.200
    18.806   260.297     0.200
    19.227   268.289     0.200
     1.577    26.400     0.200
     1.843    30.029     0.200
     1.876    31.520     0.200
     2.026    34.061     0.200
     2.128    35.221     0.200
     2.167    36.391     0.200
     2.177    36.480     0.200
     2.178    36.119     0.200
     2.206    36.660     0.200
     2.256    37.561     0.200
     2.254    37.619     0.200
     2.300    38.311     0.200
     2.321    38.051     0.200
     2.330    36.369     0.200
     2.717    43.199     0.200
     2.862    45.029     0.200
     2.850    45.230     0.200
     3.014    47.461     0.200
     3.043    48.930     0.200
     3.240    50.590     0.200
     3.489    53.881     0.200
     3.667    56.740     0.200
     3.715    56.199     0.200
     3.874    59.211     0.200
     3.938    60.051     0.200
     4.233    66.670     0.200
     4.252    67.529     0.200
     4.272    65.939     0.200
     4.312    65.891     0.200
     4.386    68.490     0.200
     4.539    72.830     0.200
     4.782    72.119     0.200
     0.297     8.645     0.200
     0.290     8.824     0.200
     0.397     9.824     0.200
     0.522    11.496     0.200
     0.760    15.176     0.200
     0.860    16.246     0.200
     1.156    21.055     0.200
     1.197    21.816     0.200
     1.559    25.734     0.200
     1.781    30.047     0.200
     1.813    30.824     0.200
     1.869    30.496     0.200
     1.822    29.676     0.200
     2.025    33.508     0.200
     2.082    34.824     0.200
     2.069    33.867     0.200
     2.080    34.164     0.200
     2.075    34.215     0.200
     2.111    33.656     0.200
     2.120    34.625     0.200
     2.129    34.996     0.200
     2.129    35.715     0.200
     2.151    35.336     0.200
     2.152    34.414     0.200
     2.176    35.496     0.200
     2.187    35.457     0.200
     2.204    35.176     0.200
     2.205    35.848     0.200
     2.266    36.707     0.200
     2.282    36.574     0.200
     2.435    38.305     0.200
     2.485    40.066     0.200
     2.691    42.574     0.200
     2.752    43.387     0.200
     2.759    42.535     0.200
     2.760    43.574     0.200
     2.832    44.258     0.200
     2.888    44.996     0.200
     3.183    48.945     0.200
     3.468    53.176     0.200
     3.633    54.574     0.200
     3.667    55.746     0.200
     3.931    60.047     0.200
     4.199    62.598     0.200
     4.237    62.125     0.200
     4.354    66.777     0.200
     4.784    70.348     0.200
     5.486    80.074     0.200
     1.362    23.406     0.200
     1.485    26.125     0.200
     1.564    25.906     0.200
     1.603    28.367     0.200
     1.603    28.477     0.200
     1.655    29.039     0.200
     1.729    30.273     0.200
     1.729    30.398     0.200
     1.892    31.641     0.200
     2.131    35.797     0.200
     2.197    37.430     0.200
     2.228    37.453     0.200
     2.242    36.477     0.200
     2.373    39.164     0.200
     2.400    39.773     0.200
     2.481    39.453     0.200
     2.531    43.117     0.200
     2.537    41.367     0.200
     2.545    40.969     0.200
     2.601    41.859     0.200
     2.618    41.719     0.200
     2.619    41.719     0.200
     2.636    43.148     0.200
     2.636    43.195     0.200
     2.636    42.414     0.200
     2.663    45.078     0.200
     2.681    45.070     0.200
     2.687    42.641     0.200
     2.701    45.164     0.200
     2.739    43.094     0.200
     2.770    43.195     0.200
     2.778    45.438     0.200
     2.820    44.289     0.200
     2.851    45.727     0.200
     2.852    46.156     0.200
     2.904    46.086     0.200
     2.903    46.078     0.200
     3.021    47.719     0.200
     3.047    49.539     0.200
     3.047    48.508     0.200
     3.123    49.070     0.200
     3.136    49.680     0.200
     3.186    50.258     0.200
     3.214    51.141     0.200
     3.229    51.375     0.200
     3.273    52.930     0.200
     3.468    54.273     0.200
     3.599    54.977     0.200
     3.600    54.977     0.200
     3.887    61.391     0.200
     3.927    61.094     0.200
     4.100    63.719     0.200
     4.157    63.375     0.200
     4.298    67.156     0.200
     4.298    67.867     0.200
     4.322    68.438     0.200
     4.322    69.938     0.200
     4.323    71.836     0.200
     4.323    65.734     0.200
     4.323    67.070     0.200
     4.340    68.734     0.200
     4.340    69.117     0.200
     4.435    68.508     0.200
     4.505    67.367     0.200
     4.953    73.594     0.200
     4.953    74.219     0.200
     5.445    82.469     0.200
     5.578    86.664     0.200
     5.671    81.609     0.200
     5.972    91.039     0.200
     6.276    92.297     0.200
     6.380    94.828     0.200
     6.380    99.906     0.200
     6.380    97.344     0.200
     6.637    98.969     0.200
     6.654    98.109     0.200
     7.609   113.289     0.200
     8.062   118.305     0.200
     8.364   123.117     0.200
     8.755   133.977     0.200
     9.397   135.070     0.200
     9.586   138.273     0.200
    10.576   153.086     0.200
    11.090   160.344     0.200
    11.471   164.125     0.200
    11.435   167.234     0.200
    11.673   166.055     0.200
    11.774   174.219     0.200
    12.161   173.797     0.200
    12.562   179.086     0.200
    12.621   181.141     0.200
    12.621   182.617     0.200
    12.676   180.180     0.200
    12.896   184.945     0.200
    12.896   184.586     0.200
    12.897   183.969     0.200
    13.605   192.406     0.200
    13.891   198.117     0.200
    14.439   202.953     0.200
    14.579   208.328     0.200
    15.293   215.680     0.200
    15.590   220.117     0.200
    15.665   221.828     0.200
    15.745   223.539     0.200
    16.041   225.938     0.200
    16.041   228.039     0.200
    16.753   235.070     0.200
    17.144   239.938     0.200
    17.630   245.609     0.200
    17.677   247.156     0.200
    17.925   248.109     0.200
    18.148   252.688     0.200
    18.944   262.664     0.200
     1.089    20.963     0.200
     1.353    23.043     0.200
     1.360    24.762     0.200
     1.412    25.262     0.200
     1.532    27.723     0.200
     1.532    27.543     0.200
     1.651    29.201     0.200
     1.875    30.691     0.200
     2.025    32.441     0.200
     2.057    34.662     0.200
     2.107    34.951     0.200
     2.151    35.482     0.200
     2.176    36.312     0.200
     2.304    38.262     0.200
     2.394    40.092     0.200
     2.362    39.082     0.200
     2.398    39.883     0.200
     2.440    39.252     0.200
     2.447    41.303     0.200
     2.455    39.861     0.200
     2.465    40.172     0.200
     2.481    39.871     0.200
     2.493    40.352     0.200
     2.497    41.252     0.200
     2.510    39.932     0.200
     2.528    40.822     0.200
     2.528    40.822     0.200
     2.545    41.312     0.200
     2.545    41.893     0.200
     2.545    41.072     0.200
     2.591    41.342     0.200
     2.596    41.182     0.200
     2.603    42.172     0.200
     2.611    42.672     0.200
     2.679    44.361     0.200
     2.729    44.812     0.200
     2.761    43.771     0.200
     2.764    43.303     0.200
     2.814    44.082     0.200
     2.946    47.053     0.200
     2.983    48.691     0.200
     2.983    47.982     0.200
     2.983    47.678     0.200
     3.055    48.312     0.200
     3.185    51.463     0.200
     3.143    49.973     0.200
     3.142    49.973     0.200
     3.200    50.332     0.200
     3.170    52.232     0.200
     3.467    51.562     0.200
     3.510    55.701     0.200
     3.808    60.172     0.200
     3.916    58.223     0.200
     3.987    59.293     0.200
     4.103    61.871     0.200
     4.271    67.383     0.200
     4.277    66.232     0.200
     4.300    66.643     0.200
     4.306    66.322     0.200
     4.315    64.021     0.200
     4.319    67.572     0.200
     4.418    67.762     0.200
     4.422    65.793     0.200
     4.910    73.826     0.200
     4.940    70.842     0.200
     5.625    83.402     0.200
     5.940    94.223     0.200
     6.189    89.973     0.200
     6.317    95.682     0.200
     6.317    93.332     0.200
     6.317    95.182     0.200
     6.599    98.732     0.200
     7.575   111.361     0.200
     7.575   112.715     0.200
     7.686   112.883     0.200
     7.721   114.281     0.200
     7.809   114.371     0.200
     7.977   120.602     0.200
     8.349   122.762     0.200
     8.349   120.361     0.200
     8.349   124.520     0.200
     8.673   123.021     0.200
     9.374   136.107     0.200
     9.534   138.121     0.200
     9.711   140.293     0.200
     9.711   137.633     0.200
     9.711   139.920     0.200
    10.109   148.406     0.200
    10.195   145.752     0.200
    10.307   150.793     0.200
    10.474   154.570     0.200
    10.534   151.572     0.200
    10.534   153.473     0.200
    10.556   152.111     0.200
    10.556   154.088     0.200
    10.690   155.629     0.200
    11.280   161.162     0.200
    11.387   162.973     0.200
    11.414   163.883     0.200
    11.414   166.893     0.200
    11.611   165.871     0.200
    11.611   163.553     0.200
    11.901   169.502     0.200
    12.480   178.043     0.200
    12.591   179.182     0.200
    12.600   180.502     0.200
    12.600   178.172     0.200
    12.600   181.852     0.200
    12.825   184.752     0.200
    12.825   184.082     0.200
    12.826   182.852     0.200
    13.107   185.883     0.200
    13.440   190.822     0.200
    13.522   192.021     0.200
    13.544   192.521     0.200
    13.819   196.633     0.200
    13.999   198.842     0.200
    13.999   199.621     0.200
    14.354   202.723     0.200
    14.552   207.652     0.200
    14.595   208.342     0.200
    14.985   212.383     0.200
    15.092   213.633     0.200
    15.330   216.492     0.200
    15.522   219.232     0.200
    15.522   219.361     0.200
    15.564   218.883     0.200
    16.037   226.252     0.200
    16.037   227.492     0.200
    17.801   246.332     0.200
    18.876   261.025     0.200
    18.876   261.633     0.200
     0.080     7.790     0.200
     0.308     9.330     0.200
     0.701    14.310     0.200
     0.843    15.959     0.200
     0.781    16.600     0.200
     1.061    19.189     0.200
     1.017    19.009     0.200
     0.986    19.469     0.200
     1.407    23.830     0.200
     1.465    25.529     0.200
     1.440    25.949     0.200
     1.778    29.879     0.200
     1.864    30.149     0.200
     1.864    31.060     0.200
     1.920    32.060     0.200
     1.931    31.479     0.200
     2.088    33.399     0.200
     2.150    35.109     0.200
     2.258    36.500     0.200
     2.273    36.679     0.200
     2.280    36.520     0.200
     2.341    37.790     0.200
     2.314    37.319     0.200
     2.428    38.209     0.200
     2.369    37.870     0.200
     2.385    38.109     0.200
     2.391    38.310     0.200
     2.401    38.819     0.200
     2.402    38.459     0.200
     2.402    38.770     0.200
     2.461    39.000     0.200
     2.461    39.109     0.200
     2.445    39.009     0.200
     2.465    39.149     0.200
     2.454    39.429     0.200
     2.502    38.969     0.200
     2.494    39.639     0.200
     2.514    39.310     0.200
     2.520    39.879     0.200
     2.521    39.879     0.200
     2.509    40.149     0.200
     2.524    40.839     0.200
     2.543    40.009     0.200
     2.606    41.759     0.200
     2.487    40.560     0.200
     2.487    40.709     0.200
     2.628    41.839     0.200
     2.557    41.250     0.200
     2.576    40.969     0.200
     2.613    41.739     0.200
     2.624    41.439     0.200
     2.659    41.569     0.200
     2.616    43.879     0.200
     2.850    45.370     0.200
     2.760    43.580     0.200
     2.831    43.439     0.200
     2.879    46.290     0.200
     2.977    46.709     0.200
     2.900    45.850     0.200
     3.196    48.830     0.200
     3.372    51.889     0.200
     3.318    50.100     0.200
     3.319    50.100     0.200
     3.448    53.100     0.200
     3.601    55.889     0.200
     3.601    55.889     0.200
     3.610    54.649     0.200
     3.630    56.370     0.200
     3.556    54.620     0.200
     3.710    60.330     0.200
     3.717    58.459     0.200
     3.728    60.779     0.200
     3.735    58.270     0.200
     3.829    59.659     0.200
     3.991    58.679     0.200
     4.081    60.859     0.200
     4.464    67.600     0.200
     4.500    66.799     0.200
     4.575    70.049     0.200
     4.645    69.699     0.200
     4.856    74.089     0.200
     5.270    74.649     0.200
     5.366    78.999     0.200
     5.366    79.409     0.200
     5.354    84.339     0.200
     5.839    82.830     0.200
     5.810    85.489     0.200
     5.810    87.139     0.200
     5.903    85.949     0.200
     6.065    88.779     0.200
     7.070   103.549     0.200
     7.151   103.689     0.200
     8.065   116.919     0.200
     8.065   117.279     0.200
     8.219   119.609     0.200
     8.251   120.270     0.200
     8.342   122.259     0.200
     8.984   133.089     0.200
     9.898   141.604     0.200
    10.169   143.500     0.200
    10.169   143.639     0.200
    10.599   152.419     0.200
    10.746   154.169     0.200
    10.746   153.399     0.200
    10.824   156.449     0.200
    11.087   160.370     0.200
    11.051   158.479     0.200
    11.942   169.790     0.200
    12.101   172.839     0.200
    12.256   174.479     0.200
    12.358   176.088     0.200
    12.358   179.139     0.200
    12.359   179.439     0.200
    12.717   183.859     0.200
    13.168   186.839     0.200
    13.360   191.790     0.200
    13.606   195.560     0.200
    14.023   197.870     0.200
    14.150   201.209     0.200
    14.067   200.339     0.200
    14.189   201.049     0.200
    14.161   201.149     0.200
    14.371   205.179     0.200
    14.529   205.379     0.200
    14.594   205.489     0.200
    14.684   207.290     0.200
    14.916   209.509     0.200
    14.905   210.179     0.200
    14.981   208.719     0.200
    14.952   209.589     0.200
    15.130   213.229     0.200
    15.273   213.810     0.200
    15.275   215.959     0.200
    15.310   215.229     0.200
    15.368   215.569     0.200
    15.557   217.779     0.200
    15.436   216.909     0.200
    15.760   220.409     0.200
    15.861   220.750     0.200
    15.994   222.439     0.200
    16.156   226.330     0.200
    16.260   225.949     0.200
    16.604   231.229     0.200
    16.531   229.000     0.200
    16.566   231.580     0.200
    16.680   231.729     0.200
    16.919   233.649     0.200
    17.087   236.879     0.200
    17.321   239.649     0.200
    17.364   240.169     0.200
    17.410   239.560     0.200
    17.424   239.870     0.200
    17.466   240.159     0.200
    17.534   243.649     0.200
    17.577   242.969     0.200
    17.646   242.870     0.200
    17.766   246.000     0.200
    17.802   246.529     0.200
     1.521    27.082     0.200
     1.503    26.922     0.200
     1.536    28.043     0.200
     1.740    30.625     0.200
     1.721    30.574     0.200
     1.721    30.742     0.200
     2.248    38.035     0.200
     2.335    38.152     0.200
     2.342    39.883     0.200
     2.491    41.582     0.200
     2.550    42.203     0.200
     2.507    42.273     0.200
     2.618    42.723     0.200
     2.623    43.715     0.200
     2.655    43.105     0.200
     2.662    44.535     0.200
     2.665    43.305     0.200
     2.690    43.312     0.200
     2.697    43.402     0.200
     2.720    44.965     0.200
     2.720    45.723     0.200
     2.720    45.133     0.200
     2.715    43.504     0.200
     2.748    45.703     0.200
     2.795    44.434     0.200
     2.856    46.723     0.200
     2.959    49.695     0.200
     3.000    50.172     0.200
     3.061    49.605     0.200
     3.139    49.152     0.200
     3.139    49.973     0.200
     3.270    54.133     0.200
     3.241    51.605     0.200
     3.297    52.934     0.200
     3.296    52.934     0.200
     3.396    50.762     0.200
     3.679    56.203     0.200
     3.679    56.203     0.200
     4.016    62.633     0.200
     4.259    66.832     0.200
     4.274    69.395     0.200
     4.272    65.062     0.200
     4.381    69.145     0.200
     4.619    73.652     0.200
     5.100    81.672     0.200
     5.062    75.504     0.200
     5.381    77.953     0.200
     5.937    89.965     0.200
     6.342    89.504     0.200
     6.391    98.055     0.200
     6.391    98.363     0.200
     6.391    92.672     0.200
     8.454   123.043     0.200
     9.493   136.457     0.200
     9.579   145.043     0.200
     9.859   139.383     0.200
    11.338   161.562     0.200
    11.384   165.793     0.200
    12.734   179.215     0.200
    12.922   185.410     0.200
    12.922   185.062     0.200
    13.255   191.703     0.200
    13.660   191.875     0.200
    13.919   194.414     0.200
    14.125   201.945     0.200
    14.155   200.195     0.200
    14.387   205.754     0.200
    14.499   204.965     0.200
    14.499   208.164     0.200
    14.640   209.355     0.200
    14.706   209.824     0.200
    14.930   212.824     0.200
    15.112   214.875     0.200
    15.310   215.113     0.200
    15.356   218.152     0.200
    15.361   216.742     0.200
    15.718   220.953     0.200
    15.654   218.785     0.200
    15.801   222.695     0.200
    15.837   224.344     0.200
    16.069   225.684     0.200
    17.716   245.082     0.200
    17.945   247.203     0.200
    17.945   248.332     0.200
    18.099   250.805     0.200
    18.965   262.551     0.200
    18.965   262.125     0.200
    18.965   263.523     0.200
     0.038     7.074     0.200
     0.807    15.938     0.200
     0.897    16.055     0.200
     0.958    18.098     0.200
     1.133    20.605     0.200
     1.265    22.527     0.200
     1.365    23.438     0.200
     1.433    24.285     0.200
     1.555    26.445     0.200
     1.658    29.848     0.200
     1.777    30.266     0.200
     1.863    30.785     0.200
     1.900    30.527     0.200
     1.926    31.734     0.200
     1.903    31.906     0.200
     1.984    33.445     0.200
     2.100    34.098     0.200
     2.154    34.438     0.200
     2.173    36.195     0.200
     2.184    36.145     0.200
     2.202    34.496     0.200
     2.217    35.188     0.200
     2.213    36.266     0.200
     2.247    36.258     0.200
     2.237    36.418     0.200
     2.265    37.055     0.200
     2.329    38.438     0.200
     2.354    37.086     0.200
     2.401    36.215     0.200
     2.456    41.258     0.200
     2.566    39.816     0.200
     2.554    39.125     0.200
     2.598    41.465     0.200
     2.575    40.246     0.200
     2.754    43.617     0.200
     3.035    47.367     0.200
     3.543    53.277     0.200
     3.587    53.055     0.200
     3.672    53.547     0.200
     3.702    57.246     0.200
     3.776    56.855     0.200
     4.536    70.277     0.200
     4.522    66.758     0.200
     4.672    70.887     0.200
     5.233    77.746     0.200
     5.718    84.598     0.200
     6.275    91.234     0.200
     1.538    26.372     0.200
     1.558    26.872     0.200
     1.671    28.452     0.200
     1.931    32.492     0.200
     2.158    35.482     0.200
     2.166    35.242     0.200
     2.210    36.093     0.200
     2.210    36.643     0.200
     2.354    38.022     0.200
     2.354    38.732     0.200
     2.380    39.622     0.200
     2.391    38.822     0.200
     2.391    38.582     0.200
     2.421    39.152     0.200
     2.442    39.332     0.200
     2.472    41.683     0.200
     2.468    39.912     0.200
     2.473    40.312     0.200
     2.508    40.702     0.200
     2.534    40.853     0.200
     2.534    41.843     0.200
     2.534    40.853     0.200
     2.661    41.122     0.200
     2.596    41.643     0.200
     2.654    43.362     0.200
     2.657    44.062     0.200
     2.671    45.003     0.200
     2.710    43.442     0.200
     2.710    43.582     0.200
     2.762    44.213     0.200
     2.778    45.032     0.200
     2.776    44.763     0.200
     2.804    43.492     0.200
     2.791    44.022     0.200
     2.791    44.622     0.200
     2.791    45.372     0.200
     2.791    45.521     0.200
     2.791    44.853     0.200
     2.792    45.312     0.200
     2.792    45.872     0.200
     2.828    45.662     0.200
     2.867    46.362     0.200
     2.871    46.812     0.200
     2.874    47.622     0.200
     2.896    46.383     0.200
     2.948    43.082     0.200
     2.951    49.223     0.200
     3.048    47.843     0.200
     3.054    49.572     0.200
     3.116    46.412     0.200
     3.200    49.782     0.200
     3.221    50.253     0.200
     3.278    52.643     0.200
     3.328    52.433     0.200
     3.328    53.923     0.200
     3.461    51.912     0.200
     3.748    57.173     0.200
     3.748    57.173     0.200
     3.801    60.910     0.200
     3.801    59.282     0.200
     3.801    59.893     0.200
     3.833    57.003     0.200
     3.902    58.566     0.200
     3.902    58.462     0.200
     4.157    63.393     0.200
     4.135    60.792     0.200
     4.574    68.082     0.200
     4.545    67.622     0.200
     4.545    67.463     0.200
     4.632    68.503     0.200
     4.778    72.622     0.200
     5.361    81.812     0.200
     5.382    80.872     0.200
     5.494    82.872     0.200
     5.559    82.522     0.200
     5.559    82.292     0.200
     5.559    81.912     0.200
     5.773    83.982     0.200
     6.170    91.173     0.200
     6.318    93.133     0.200
     6.532    96.133     0.200
     6.511    96.944     0.200
     6.511    96.633     0.200
     6.503    94.812     0.200
     6.606    97.645     0.200
     6.584    96.822     0.200
     6.584    97.173     0.200
     6.606    96.822     0.200
     6.621    98.103     0.200
     6.708    98.822     0.200
     6.813   102.162     0.200
     6.905   102.173     0.200
     6.955   102.603     0.200
     6.955   102.753     0.200
     7.092   106.122     0.200
     7.092   105.853     0.200
     7.092   106.857     0.200
     7.092   106.013     0.200
     7.092   106.258     0.200
     7.234   107.223     0.200
     7.234   106.923     0.200
     7.241   106.692     0.200
     7.318   109.772     0.200
     7.753   112.012     0.200
     7.753   112.782     0.200
     8.084   119.802     0.200
     8.253   120.650     0.200
     8.278   118.723     0.200
     8.308   124.715     0.200
     8.338   122.322     0.200
     8.338   119.593     0.200
     8.679   124.822     0.200
     8.679   124.032     0.200
     8.679   123.883     0.200
     9.146   134.035     0.200
     9.365   138.109     0.200
     9.377   137.939     0.200
     9.581   140.442     0.200
     9.585   140.888     0.200
     9.679   142.423     0.200
     9.679   139.173     0.200
     9.679   139.553     0.200
     9.689   141.126     0.200
     9.732   143.676     0.200
     9.748   142.657     0.200
     9.742   138.742     0.200
     9.794   142.641     0.200
     9.835   144.174     0.200
     9.938   143.038     0.200
    10.001   145.924     0.200
    10.036   145.827     0.200
    10.117   147.090     0.200
    10.234   148.615     0.200
    10.406   152.782     0.200
    10.678   154.902     0.200
    10.721   155.468     0.200
    10.759   155.468     0.200
    10.747   151.991     0.200
    10.747   152.522     0.200
    10.747   151.253     0.200
    10.747   152.843     0.200
    10.747   151.822     0.200
    11.000   159.362     0.200
    11.000   161.197     0.200
    11.128   160.267     0.200
    11.191   162.365     0.200
    11.501   165.423     0.200
    11.501   165.281     0.200
    11.501   164.853     0.200
    11.501   165.022     0.200
    11.540   167.736     0.200
    11.535   166.942     0.200
    11.581   168.547     0.200
    11.658   169.353     0.200
    11.688   169.263     0.200
    11.742   169.112     0.200
    12.097   175.662     0.200
    12.099   174.961     0.200
    12.099   174.332     0.200
    12.099   175.317     0.200
    12.099   174.723     0.200
    12.180   175.076     0.200
    12.189   174.812     0.200
    12.332   177.176     0.200
    12.331   177.525     0.200
    12.331   177.292     0.200
    12.397   178.108     0.200
    12.404   178.575     0.200
    12.442   178.809     0.200
    12.489   179.392     0.200
    12.567   180.790     0.200
    12.599   182.307     0.200
    12.633   180.558     0.200
    12.659   180.452     0.200
    12.777   184.173     0.200
    12.837   183.939     0.200
    12.924   183.463     0.200
    12.939   183.963     0.200
    13.008   186.506     0.200
    13.018   186.621     0.200
    13.026   187.622     0.200
    13.026   186.723     0.200
    13.031   186.854     0.200
    13.066   186.467     0.200
    13.066   187.612     0.200
    13.066   187.982     0.200
    13.057   186.963     0.200
    13.057   187.872     0.200
    13.136   188.138     0.200
    13.456   192.093     0.200
    13.456   192.768     0.200
    13.467   192.723     0.200
    13.467   192.423     0.200
    13.489   193.003     0.200
    13.489   194.272     0.200
    13.650   193.122     0.200
    13.650   192.643     0.200
    13.806   197.583     0.200
    13.905   197.423     0.200
    13.905   196.692     0.200
    14.046   202.132     0.200
    14.929   211.741     0.200
    14.929   212.322     0.200
    14.929   213.362     0.200
    14.929   213.622     0.200
    15.186   216.941     0.200
    15.905   224.871     0.200
    15.905   224.458     0.200
    16.176   228.839     0.200
    16.202   227.742     0.200
    16.202   228.122     0.200
    16.219   227.723     0.200
    16.219   226.183     0.200
    16.356   229.022     0.200
    17.099   237.402     0.200
    18.172   251.603     0.200
    18.706   259.072     0.200
    19.039   264.322     0.200
    19.039   264.692     0.200
    19.102   266.343     0.200
    19.102   264.322     0.200
    19.346   266.723     0.200
    19.539   268.816     0.200
    19.819   275.522     0.200
    19.869   273.822     0.200
    20.126   276.112     0.200
    20.173   280.622     0.200
    20.315   280.112     0.200
    20.540   282.593     0.200
    20.867   283.133     0.200
    20.897   284.372     0.200
    20.915   285.383     0.200
     0.237     8.312     0.200
     0.494    11.082     0.200
     0.799    15.023     0.200
     0.987    17.992     0.200
     1.053    18.543     0.200
     1.084    19.113     0.200
     1.128    20.293     0.200
     1.262    21.832     0.200
     1.334    23.293     0.200
     1.338    23.812     0.200
     1.453    25.182     0.200
     1.531    26.203     0.200
     1.528    26.713     0.200
     1.738    29.252     0.200
     1.879    31.502     0.200
     1.987    32.543     0.200
     2.001    33.242     0.200
     2.047    32.982     0.200
     2.054    32.422     0.200
     2.073    33.623     0.200
     2.074    34.252     0.200
     2.112    34.182     0.200
     2.137    34.443     0.200
     2.141    34.873     0.200
     2.218    36.193     0.200
     2.223    36.152     0.200
     2.220    35.453     0.200
     2.255    34.953     0.200
     2.266    37.373     0.200
     2.270    36.002     0.200
     2.287    37.072     0.200
     2.316    38.902     0.200
     2.302    37.543     0.200
     2.312    37.312     0.200
     2.329    38.043     0.200
     2.342    37.752     0.200
     2.353    38.703     0.200
     2.454    39.512     0.200
     2.501    39.922     0.200
     2.600    43.803     0.200
     2.605    41.383     0.200
     3.145    48.773     0.200
     3.268    50.193     0.200
     3.310    53.762     0.200
     3.321    52.723     0.200
     4.070    60.732     0.200
     4.221    62.312     0.200
     0.169     8.133     0.200
     0.541    11.789     0.200
     0.722    14.289     0.200
     0.794    15.602     0.200
     0.878    16.516     0.200
     1.004    18.992     0.200
     1.129    20.742     0.200
     1.252    22.562     0.200
     1.388    24.453     0.200
     1.523    25.227     0.200
     1.677    28.555     0.200
     1.777    30.055     0.200
     1.772    29.320     0.200
     1.814    31.305     0.200
     1.907    31.750     0.200
     1.918    31.711     0.200
     1.963    31.430     0.200
     2.018    32.781     0.200
     2.037    33.070     0.200
     2.042    33.359     0.200
     2.063    33.570     0.200
     2.063    34.250     0.200
     2.078    33.320     0.200
     2.094    34.703     0.200
     2.101    34.164     0.200
     2.106    33.062     0.200
     2.112    34.414     0.200
     2.131    35.320     0.200
     2.143    36.484     0.200
     2.150    37.133     0.200
     2.227    35.070     0.200
     2.281    33.789     0.200
     2.344    36.523     0.200
     2.332    37.672     0.200
     2.448    39.695     0.200
     2.476    39.414     0.200
     2.538    40.086     0.200
     2.632    45.852     0.200
     3.542    54.320     0.200
     3.594    54.516     0.200
     0.235     8.424     0.200
     0.398    10.203     0.200
     0.376    10.104     0.200
     0.872    17.184     0.200
     1.161    21.434     0.200
     1.340    24.123     0.200
     1.471    25.895     0.200
     1.430    24.693     0.200
     1.873    31.053     0.200
     1.985    32.244     0.200
     1.941    31.443     0.200
     1.974    32.953     0.200
     2.179    36.123     0.200
     2.151    35.424     0.200
     2.215    35.623     0.200
     2.243    36.674     0.200
     2.218    36.164     0.200
     2.216    36.193     0.200
     2.263    36.553     0.200
     2.265    36.514     0.200
     2.270    36.734     0.200
     2.284    36.645     0.200
     2.307    36.803     0.200
     2.314    37.104     0.200
     2.319    37.594     0.200
     2.319    37.564     0.200
     2.335    37.504     0.200
     2.336    37.504     0.200
     2.345    37.104     0.200
     2.365    37.994     0.200
     2.409    39.363     0.200
     2.379    37.494     0.200
     2.383    37.645     0.200
     2.384    39.854     0.200
     2.424    40.193     0.200
     2.455    39.033     0.200
     2.458    39.354     0.200
     2.528    40.434     0.200
     2.596    40.654     0.200
     2.587    40.803     0.200
     2.606    41.074     0.200
     2.740    44.744     0.200
     2.740    44.213     0.200
     2.817    43.713     0.200
     2.852    44.684     0.200
     2.872    45.574     0.200
     3.005    46.773     0.200
     2.994    46.834     0.200
     2.971    46.725     0.200
     3.168    50.104     0.200
     3.168    50.104     0.200
     3.177    52.193     0.200
     3.277    49.574     0.200
     3.278    49.574     0.200
     3.344    51.203     0.200
     3.788    56.533     0.200
     3.803    56.463     0.200
     3.785    58.434     0.200
     4.019    59.443     0.200
     4.142    66.904     0.200
     4.144    65.174     0.200
     4.253    66.443     0.200
     4.290    64.443     0.200
     4.930    73.783     0.200
     5.291    79.924     0.200
     5.578    86.373     0.200
     6.635    99.344     0.200
     6.706    99.064     0.200
     7.626   111.014     0.200
     7.626   110.633     0.200
     7.773   114.254     0.200
     7.729   110.043     0.200
     7.806   115.783     0.200
     7.896   115.863     0.200
     8.422   123.744     0.200
     9.304   134.264     0.200
    11.043   158.963     0.200
    11.138   158.914     0.200
    11.267   160.953     0.200
    11.564   162.408     0.200
    11.564   164.773     0.200
    11.836   170.508     0.200
    12.229   174.373     0.200
    12.343   175.084     0.200
    12.576   179.412     0.200
    12.575   180.338     0.200
    12.575   180.584     0.200
    12.581   181.713     0.200
    12.682   179.814     0.200
    13.272   187.936     0.200
    13.568   193.354     0.200
    13.747   196.092     0.200
    14.106   197.936     0.200
    14.303   202.943     0.200
    14.342   203.205     0.200
    14.578   206.525     0.200
    14.733   208.154     0.200
    15.011   212.654     0.200
    15.274   215.783     0.200
    18.627   256.834     0.200
    18.627   256.635     0.200
    18.627   257.354     0.200
    18.627   257.014     0.200
     0.379    10.914     0.200
     0.383    10.766     0.200
     0.470    12.008     0.200
     0.716    14.945     0.200
     1.069    19.977     0.200
     1.187    21.594     0.200
     1.346    24.086     0.200
     1.488    25.914     0.200
     1.725    28.297     0.200
     1.784    28.789     0.200
     1.839    30.945     0.200
     1.950    31.648     0.200
     2.011    32.945     0.200
     2.056    33.148     0.200
     2.067    33.242     0.200
     2.080    34.578     0.200
     2.104    33.867     0.200
     2.114    34.305     0.200
     2.116    34.742     0.200
     2.125    34.242     0.200
     2.149    35.289     0.200
     2.156    34.414     0.200
     2.177    34.969     0.200
     2.187    34.633     0.200
     2.333    38.094     0.200
     2.380    37.945     0.200
     2.664    43.523     0.200
     2.710    42.695     0.200
     2.864    44.789     0.200
     3.077    49.016     0.200
     3.393    49.484     0.200
     3.636    53.086     0.200
     3.644    53.086     0.200
     3.977    60.477     0.200
     4.152    65.719     0.200
     4.270    65.047     0.200
     5.321    77.578     0.200
     1.119    21.477     0.200
     1.453    26.147     0.200
     1.588    28.387     0.200
     1.596    28.627     0.200
     1.737    28.667     0.200
     1.700    28.007     0.200
     2.148    36.047     0.200
     2.167    35.667     0.200
     2.393    39.977     0.200
     2.445    40.717     0.200
     2.448    41.287     0.200
     2.461    41.367     0.200
     2.468    41.277     0.200
     2.483    41.437     0.200
     2.494    41.107     0.200
     2.502    39.377     0.200
     2.503    41.227     0.200
     2.500    41.297     0.200
     2.516    41.027     0.200
     2.517    42.467     0.200
     2.525    40.897     0.200
     2.525    40.897     0.200
     2.575    43.917     0.200
     2.574    42.167     0.200
     2.574    43.367     0.200
     2.574    41.537     0.200
     2.574    43.018     0.200
     2.620    43.817     0.200
     2.643    44.107     0.200
     2.676    44.057     0.200
     2.706    43.737     0.200
     2.720    45.487     0.200
     2.740    44.497     0.200
     2.799    45.357     0.200
     2.844    45.417     0.200
     2.917    47.717     0.200
     3.022    48.557     0.200
     3.022    48.557     0.200
     3.031    48.597     0.200
     3.077    48.927     0.200
     3.108    49.277     0.200
     3.094    48.827     0.200
     3.094    50.467     0.200
     3.316    54.247     0.200
     3.544    54.397     0.200
     3.545    54.397     0.200
     3.610    55.197     0.200
     3.773    57.347     0.200
     3.773    58.585     0.200
     3.995    61.597     0.200
     4.371    65.017     0.200
     4.448    73.257     0.200
     4.459    69.557     0.200
     4.560    70.237     0.200
     4.789    71.036     0.200
     4.789    74.104     0.200
     4.838    70.607     0.200
     5.215    77.907     0.200
     5.346    81.197     0.200
     5.580    81.947     0.200
     5.630    82.337     0.200
     5.895    91.867     0.200
     6.077    91.937     0.200
     6.241    95.087     0.200
     6.473    94.497     0.200
     6.473    95.151     0.200
     6.473    96.111     0.200
     6.495    94.117     0.200
     6.495    98.179     0.200
     7.446   109.867     0.200
     7.446   110.247     0.200
     7.446   109.643     0.200
     7.446   109.540     0.200
     7.549   110.167     0.200
     7.585   112.097     0.200
     7.672   112.977     0.200
     8.038   119.277     0.200
     8.210   121.780     0.200
     8.210   122.285     0.200
     8.547   124.546     0.200
     8.547   119.837     0.200
     8.547   121.179     0.200
     8.550   120.681     0.200
     8.746   132.017     0.200
     8.822   131.457     0.200
     8.980   131.771     0.200
     9.187   135.309     0.200
     9.238   136.646     0.200
     9.276   133.388     0.200
     9.274   140.327     0.200
     9.274   137.423     0.200
     9.277   136.364     0.200
     9.381   133.105     0.200
     9.485   138.144     0.200
     9.657   140.967     0.200
     9.682   142.033     0.200
     9.852   147.600     0.200
     9.852   146.432     0.200
     9.909   143.460     0.200
    10.045   143.794     0.200
    10.078   144.638     0.200
    10.078   147.910     0.200
    10.112   149.378     0.200
    10.138   149.937     0.200
    10.168   147.797     0.200
    10.168   148.196     0.200
    10.334   152.311     0.200
    10.439   148.167     0.200
    10.419   151.022     0.200
    10.419   152.899     0.200
    10.451   151.787     0.200
    10.550   152.247     0.200
    10.550   152.943     0.200
    10.550   153.525     0.200
    10.554   154.712     0.200
    10.717   157.030     0.200
    10.740   156.045     0.200
    10.692   152.297     0.200
    10.698   157.977     0.200
    10.721   157.857     0.200
    10.767   159.607     0.200
    10.770   156.317     0.200
    10.896   157.360     0.200
    10.896   158.923     0.200
    10.970   160.955     0.200
    11.004   158.697     0.200
    11.004   161.293     0.200
    11.203   164.650     0.200
    11.397   165.317     0.200
    11.449   164.417     0.200
    11.513   161.736     0.200
    11.513   162.677     0.200
    11.513   163.227     0.200
    11.513   164.287     0.200
    11.513   165.832     0.200
    11.589   166.407     0.200
    11.647   168.757     0.200
    11.647   169.785     0.200
    11.690   171.760     0.200
    12.121   173.457     0.200
    12.160   176.697     0.200
    12.155   173.786     0.200
    12.155   175.007     0.200
    12.472   177.957     0.200
    12.464   178.737     0.200
    12.464   179.667     0.200
    12.464   179.777     0.200
    12.464   177.047     0.200
    12.464   178.217     0.200
    12.923   186.292     0.200
    12.923   184.237     0.200
    12.928   185.317     0.200
    13.069   188.959     0.200
    13.069   187.207     0.200
    13.069   189.929     0.200
    13.069   188.017     0.200
    13.149   186.897     0.200
    13.150   190.324     0.200
    13.226   188.877     0.200
    13.460   193.357     0.200
    13.460   192.305     0.200
    13.460   193.483     0.200
    13.576   191.917     0.200
    13.576   190.837     0.200
    13.576   193.049     0.200
    13.576   190.467     0.200
    13.576   191.617     0.200
    13.996   198.987     0.200
    13.996   200.917     0.200
    13.996   201.804     0.200
    13.996   199.517     0.200
    13.996   199.879     0.200
    14.337   204.987     0.200
    14.426   204.457     0.200
    14.426   206.457     0.200
    14.426   207.150     0.200
    14.426   204.567     0.200
    14.654   210.807     0.200
    14.682   208.947     0.200
    14.900   210.317     0.200
    14.962   212.735     0.200
    14.979   214.127     0.200
    15.015   214.322     0.200
    15.015   214.083     0.200
    15.041   212.807     0.200
    15.041   213.618     0.200
    15.255   214.287     0.200
    15.240   216.606     0.200
    15.266   218.016     0.200
    15.318   218.021     0.200
    15.322   218.021     0.200
    15.344   219.425     0.200
    15.486   219.757     0.200
    15.486   215.917     0.200
    15.516   221.368     0.200
    15.520   221.537     0.200
    15.552   221.896     0.200
    15.602   217.937     0.200
    15.602   218.117     0.200
    15.577   222.072     0.200
    15.589   222.242     0.200
    15.599   221.577     0.200
    15.599   222.038     0.200
    15.601   221.544     0.200
    15.624   221.657     0.200
    15.802   223.650     0.200
    15.834   224.707     0.200
    15.895   224.361     0.200
    15.895   225.277     0.200
    15.895   224.017     0.200
    15.895   225.587     0.200
    15.895   225.717     0.200
    16.034   225.942     0.200
    16.122   225.827     0.200
    16.151   226.297     0.200
    16.151   224.538     0.200
    16.151   228.487     0.200
    16.147   228.061     0.200
    16.154   228.407     0.200
    16.154   229.117     0.200
    16.317   229.998     0.200
    16.317   230.417     0.200
    16.317   229.466     0.200
    16.435   232.460     0.200
    16.709   235.626     0.200
    16.764   234.227     0.200
    16.942   232.447     0.200
    16.942   235.037     0.200
    16.942   236.617     0.200
    16.975   238.997     0.200
    16.994   238.975     0.200
    17.265   240.177     0.200
    17.423   243.357     0.200
    17.514   240.667     0.200
    17.793   245.937     0.200
    17.858   247.207     0.200
    17.856   248.669     0.200
    17.948   249.917     0.200
    18.084   251.056     0.200
    18.398   257.121     0.200
    18.546   259.408     0.200
    18.555   258.178     0.200
    18.555   258.307     0.200
    18.646   259.761     0.200
    18.677   259.413     0.200
    18.750   261.171     0.200
    18.769   260.947     0.200
    18.774   261.882     0.200
    18.971   262.217     0.200
    18.977   262.736     0.200
    18.977   262.907     0.200
    18.977   262.317     0.200
    19.000   263.986     0.200
    19.167   264.787     0.200
    19.658   273.150     0.200
    19.799   272.607     0.200
    19.799   274.617     0.200
    20.309   277.555     0.200
    20.309   279.017     0.200
    20.831   284.217     0.200
    21.006   286.009     0.200
     1.093    20.391     0.200
     1.570    27.690     0.200
     1.589    27.851     0.200
     1.661    29.030     0.200
     1.771    29.040     0.200
     2.084    35.181     0.200
     2.120    34.681     0.200
     2.127    34.920     0.200
     2.144    35.080     0.200
     2.263    37.681     0.200
     2.378    38.160     0.200
     2.417    39.940     0.200
     2.430    39.230     0.200
     2.445    40.431     0.200
     2.452    40.431     0.200
     2.456    40.330     0.200
     2.467    41.101     0.200
     2.478    39.771     0.200
     2.486    40.200     0.200
     2.491    39.091     0.200
     2.493    40.431     0.200
     2.497    39.771     0.200
     2.508    40.051     0.200
     2.509    40.051     0.200
     2.550    42.551     0.200
     2.549    41.110     0.200
     2.549    42.851     0.200
     2.549    40.670     0.200
     2.682    43.311     0.200
     2.695    45.120     0.200
     2.729    44.341     0.200
     2.786    44.391     0.200
     2.772    45.080     0.200
     2.819    46.160     0.200
     2.880    45.830     0.200
     2.884    47.080     0.200
     2.978    46.940     0.200
     3.046    48.730     0.200
     3.046    48.730     0.200
     3.054    43.750     0.200
     3.053    48.900     0.200
     3.053    49.750     0.200
     3.086    48.521     0.200
     3.518    53.280     0.200
     3.519    53.280     0.200
     3.572    53.181     0.200
     3.808    57.181     0.200
     4.369    63.250     0.200
     4.407    68.311     0.200
     4.418    70.330     0.200
     4.519    67.011     0.200
     4.814    72.069     0.200
     4.814    70.210     0.200
     4.814    73.650     0.200
     5.176    78.311     0.200
     5.540    81.870     0.200
     5.589    84.341     0.200
     5.853    91.591     0.200
     6.035    92.641     0.200
     6.211    90.480     0.200
     7.475   110.801     0.200
     7.475   109.841     0.200
     7.582   111.551     0.200
     7.617   111.530     0.200
     7.705   113.990     0.200
     8.006   113.971     0.200
     8.564   119.980     0.200
     8.711   130.500     0.200
     9.615   142.080     0.200
    10.202   147.990     0.200
    10.585   152.780     0.200
    11.039   159.230     0.200
    11.356   162.610     0.200
    11.528   163.470     0.200
    11.528   162.891     0.200
    11.528   160.700     0.200
    11.528   166.011     0.200
    11.681   167.400     0.200
    12.496   177.801     0.200
    12.496   180.601     0.200
    12.519   178.131     0.200
    12.621   179.971     0.200
    12.884   185.340     0.200
    13.189   187.561     0.200
    13.551   191.181     0.200
    14.040   200.561     0.200
    14.413   202.960     0.200
    14.460   205.240     0.200
    14.614   207.210     0.200
    14.645   207.391     0.200
    14.885   209.940     0.200
    15.076   213.610     0.200
    15.226   215.381     0.200
    15.695   221.240     0.200
    15.933   224.670     0.200
    16.954   235.620     0.200
    17.835   246.381     0.200
    18.937   261.794     0.200
    18.937   261.200     0.200
    19.472   267.341     0.200
    20.002   275.030     0.200
     0.577    12.812     0.200
     1.027    19.822     0.200
     1.426    25.282     0.200
     1.635    28.012     0.200
     1.786    29.122     0.200
     2.070    34.901     0.200
     2.054    35.092     0.200
     2.081    34.521     0.200
     2.096    34.082     0.200
     2.198    36.502     0.200
     2.260    37.271     0.200
     2.319    37.521     0.200
     2.350    41.132     0.200
     2.370    38.892     0.200
     2.385    38.492     0.200
     2.393    39.052     0.200
     2.400    40.512     0.200
     2.426    38.892     0.200
     2.434    38.242     0.200
     2.435    37.512     0.200
     2.435    37.722     0.200
     2.448    39.562     0.200
     2.449    39.562     0.200
     2.484    38.502     0.200
     2.485    41.771     0.200
     2.484    39.292     0.200
     2.530    42.492     0.200
     2.617    42.021     0.200
     2.617    42.422     0.200
     2.675    42.062     0.200
     2.706    43.822     0.200
     2.706    44.552     0.200
     2.754    45.052     0.200
     2.754    45.332     0.200
     2.842    45.332     0.200
     2.817    45.611     0.200
     2.817    46.062     0.200
     2.993    46.231     0.200
     2.986    47.122     0.200
     2.986    47.542     0.200
     2.993    48.642     0.200
     3.022    48.132     0.200
     3.022    48.572     0.200
     3.452    52.332     0.200
     3.453    52.332     0.200
     3.548    54.151     0.200
     3.824    56.642     0.200
     4.380    71.962     0.200
     4.484    70.632     0.200
     4.750    73.282     0.200
     4.807    71.860     0.200
     4.807    70.752     0.200
     5.147    78.602     0.200
     5.346    76.632     0.200
     5.511    81.432     0.200
     5.529    84.932     0.200
     5.991    90.002     0.200
     6.497    96.832     0.200
     6.535    96.202     0.200
     7.476   109.952     0.200
     7.476   109.132     0.200
     7.593   111.162     0.200
     7.628   112.492     0.200
     7.717   113.151     0.200
     7.939   115.802     0.200
     9.559   140.002     0.200
    10.217   147.782     0.200
    10.358   148.972     0.200
    10.601   153.052     0.200
    10.992   158.752     0.200
    11.053   157.901     0.200
    11.297   160.292     0.200
    11.350   159.382     0.200
    11.504   163.461     0.200
    11.504   162.521     0.200
    11.696   167.392     0.200
    12.074   175.011     0.200
    12.506   177.012     0.200
    12.506   180.012     0.200
    12.453   174.822     0.200
    12.554   176.422     0.200
    12.820   184.542     0.200
    12.820   181.552     0.200
    12.821   180.092     0.200
    13.811   194.912     0.200
    14.316   201.472     0.200
    14.476   203.932     0.200
    14.476   206.242     0.200
    14.551   205.382     0.200
    14.722   209.092     0.200
    14.960   210.032     0.200
    15.060   211.332     0.200
    15.159   213.151     0.200
    15.312   212.392     0.200
    15.513   216.062     0.200
    15.661   221.782     0.200
    15.628   217.151     0.200
    15.740   222.102     0.200
    15.955   226.110     0.200
    15.955   225.622     0.200
    16.212   228.032     0.200
    16.327   227.472     0.200
    16.719   233.722     0.200
    16.824   236.502     0.200
    16.925   236.042     0.200
    17.035   238.412     0.200
    17.092   238.322     0.200
    17.166   237.512     0.200
    17.163   237.082     0.200
    17.436   240.632     0.200
    17.771   245.472     0.200
    17.917   249.512     0.200
    17.950   247.812     0.200
    18.085   249.111     0.200
    18.436   254.512     0.200
    18.874   261.636     0.200
    18.874   261.852     0.200
     0.995    18.996     0.200
     1.265    23.328     0.200
     1.613    27.266     0.200
     1.802    30.535     0.200
     1.890    32.418     0.200
     2.033    34.445     0.200
     2.018    33.707     0.200
     2.027    34.277     0.200
     2.078    34.895     0.200
     2.256    34.035     0.200
     2.306    37.887     0.200
     2.334    37.887     0.200
     2.341    39.195     0.200
     2.355    39.656     0.200
     2.356    38.207     0.200
     2.362    39.395     0.200
     2.364    38.656     0.200
     2.364    38.656     0.200
     2.370    39.895     0.200
     2.441    41.008     0.200
     2.440    40.285     0.200
     2.440    39.766     0.200
     2.486    39.555     0.200
     2.510    41.855     0.200
     2.511    39.188     0.200
     2.567    41.445     0.200
     2.569    42.145     0.200
     2.590    43.297     0.200
     2.672    44.207     0.200
     2.689    43.117     0.200
     2.710    43.836     0.200
     2.782    44.367     0.200
     2.819    46.566     0.200
     2.857    45.906     0.200
     2.857    45.906     0.200
     2.865    46.586     0.200
     3.071    51.605     0.200
     3.342    51.656     0.200
     3.414    51.996     0.200
     3.415    51.996     0.200
     3.650    56.527     0.200
     3.679    56.285     0.200
     3.717    57.516     0.200
     3.818    58.625     0.200
     4.187    60.328     0.200
     4.625    68.961     0.200
     4.625    69.355     0.200
     4.697    73.656     0.200
     5.309    78.547     0.200
     5.607    87.895     0.200
     5.961    90.836     0.200
     6.355    94.465     0.200
    11.331   159.934     0.200
    15.787   222.512     0.200
    18.928   260.961     0.200
     1.268    24.495     0.200
     1.382    26.085     0.200
     1.691    29.585     0.200
     1.725    30.615     0.200
     2.677    44.515     0.200
     2.745    45.565     0.200
     0.302     9.227     0.200
     0.385    10.066     0.200
     0.686    13.836     0.200
     0.699    14.195     0.200
     0.899    16.918     0.200
     0.952    17.719     0.200
     1.141    20.906     0.200
     1.165    21.219     0.200
     1.204    21.508     0.200
     1.289    22.059     0.200
     1.323    23.688     0.200
     1.372    23.809     0.200
     1.465    24.496     0.200
     1.524    26.535     0.200
     1.886    31.766     0.200
     1.892    32.016     0.200
     2.005    34.426     0.200
     2.018    32.707     0.200
     2.055    35.086     0.200
     2.076    33.117     0.200
     2.098    35.148     0.200
     2.100    33.656     0.200
     2.110    34.719     0.200
     2.160    36.719     0.200
     2.244    38.957     0.200
     2.322    39.008     0.200
     2.334    37.637     0.200
     2.409    41.027     0.200
     2.415    39.656     0.200
     2.445    41.508     0.200
     2.511    39.758     0.200
     2.525    38.879     0.200
     2.621    44.156     0.200
     2.629    42.598     0.200
     2.952    45.898     0.200
     3.072    47.527     0.200
     3.452    54.047     0.200
     3.866    58.336     0.200
     4.581    66.387     0.200
     0.312     9.473     0.200
     0.411    10.430     0.200
     0.642    13.453     0.200
     0.818    16.152     0.200
     0.855    16.023     0.200
     0.871    16.762     0.200
     0.998    19.293     0.200
     1.130    20.590     0.200
     1.166    21.781     0.200
     1.269    22.551     0.200
     1.275    22.543     0.200
     1.446    24.031     0.200
     1.604    27.473     0.200
     1.621    26.902     0.200
     1.811    29.871     0.200
     1.944    32.691     0.200
     1.952    31.430     0.200
     1.960    33.312     0.200
     1.982    32.160     0.200
     1.983    32.453     0.200
     1.993    33.160     0.200
     2.014    33.352     0.200
     2.022    33.543     0.200
     2.049    34.211     0.200
     2.056    34.332     0.200
     2.089    34.242     0.200
     2.115    35.383     0.200
     2.120    36.352     0.200
     2.176    34.391     0.200
     2.284    38.160     0.200
     2.372    39.590     0.200
     2.405    38.902     0.200
     2.408    38.930     0.200
     2.409    39.113     0.200
     2.449    39.742     0.200
     2.484    41.602     0.200
     2.487    37.781     0.200
     2.502    42.422     0.200
     2.656    43.242     0.200
     2.667    41.641     0.200
     2.673    44.891     0.200
     2.802    43.953     0.200
     2.984    46.773     0.200
     3.349    51.422     0.200
     3.548    53.820     0.200
     3.566    55.832     0.200
     3.712    56.160     0.200
     4.428    66.262     0.200
     4.520    66.973     0.200
     4.572    68.172     0.200
     5.190    77.570     0.200
     5.291    76.512     0.200
     5.422    82.230     0.200
     6.133    90.062     0.200
    13.129   186.312     0.200
     1.437    25.727     0.200
     1.583    27.812     0.200
     1.592    28.094     0.200
     1.648    29.141     0.200
     1.663    27.867     0.200
     1.784    30.023     0.200
     1.972    33.328     0.200
     2.021    34.258     0.200
     2.178    36.211     0.200
     2.198    36.562     0.200
     2.422    39.422     0.200
     2.475    40.578     0.200
     2.493    40.328     0.200
     2.493    41.172     0.200
     2.499    41.094     0.200
     2.510    40.727     0.200
     2.514    41.016     0.200
     2.527    40.367     0.200
     2.533    40.906     0.200
     2.535    41.984     0.200
     2.544    40.773     0.200
     2.553    38.555     0.200
     2.556    41.695     0.200
     2.557    41.695     0.200
     2.565    42.086     0.200
     2.624    42.555     0.200
     2.624    42.891     0.200
     2.624    41.977     0.200
     2.650    41.938     0.200
     2.659    42.266     0.200
     2.694    44.016     0.200
     2.737    43.578     0.200
     2.754    43.805     0.200
     2.759    43.523     0.200
     2.791    44.078     0.200
     2.864    45.625     0.200
     2.944    46.422     0.200
     2.969    47.562     0.200
     2.969    47.562     0.200
     3.179    49.656     0.200
     3.405    54.117     0.200
     3.597    57.992     0.200
     3.698    56.102     0.200
     3.692    57.484     0.200
     4.219    61.195     0.200
     4.400    69.531     0.200
     4.547    72.008     0.200
     4.647    72.602     0.200
     4.734    70.609     0.200
     5.299    80.781     0.200
     6.511    99.531     0.200
     6.511    95.797     0.200
     6.511   100.281     0.200
    10.308   147.711     0.200
    11.478   161.281     0.200
    11.478   163.273     0.200
    11.484   164.594     0.200
    11.484   164.266     0.200
    11.513   163.117     0.200
    11.643   168.945     0.200
    12.015   170.281     0.200
    12.177   170.992     0.200
    12.717   179.195     0.200
    13.203   185.281     0.200
    13.300   189.023     0.200
    13.625   192.156     0.200
    13.655   191.914     0.200
    13.993   196.945     0.200
    14.146   198.258     0.200
    14.735   207.391     0.200
    14.758   208.992     0.200
    14.812   209.016     0.200
    15.002   210.523     0.200
    15.132   213.023     0.200
    15.181   212.281     0.200
    15.438   218.102     0.200
    15.489   216.977     0.200
    15.559   217.484     0.200
    15.602   218.891     0.200
    15.649   219.688     0.200
    15.706   222.688     0.200
    15.706   220.977     0.200
    15.756   220.258     0.200
    15.793   220.172     0.200
    15.815   223.891     0.200
    15.872   223.055     0.200
    15.934   222.992     0.200
    16.038   224.383     0.200
    16.131   227.031     0.200
    16.268   225.945     0.200
    16.287   227.453     0.200
    16.304   228.062     0.200
    16.494   231.055     0.200
    16.905   236.273     0.200
    16.975   236.992     0.200
    16.995   236.242     0.200
    17.320   239.617     0.200
    18.123   250.742     0.200
    18.271   252.938     0.200
    18.393   257.742     0.200
    18.393   256.461     0.200
    19.057   263.922     0.200
    19.057   262.727     0.200
    19.057   264.383     0.200
     0.595    12.791     0.200
     0.565    12.501     0.200
     0.785    15.741     0.200
     1.163    21.711     0.200
     1.153    21.331     0.200
     1.602    27.071     0.200
     1.603    28.391     0.200
     1.627    28.561     0.200
     1.836    31.141     0.200
     1.913    31.931     0.200
     2.114    35.571     0.200
     2.136    35.621     0.200
     2.177    35.361     0.200
     2.383    38.481     0.200
     2.455    39.901     0.200
     2.461    39.681     0.200
     2.484    40.171     0.200
     2.489    40.551     0.200
     2.496    40.121     0.200
     2.497    41.181     0.200
     2.515    41.111     0.200
     2.514    41.991     0.200
     2.539    41.471     0.200
     2.599    42.561     0.200
     2.599    42.451     0.200
     2.599    40.701     0.200
     2.615    41.881     0.200
     2.630    41.891     0.200
     2.670    44.081     0.200
     2.728    43.951     0.200
     2.762    45.391     0.200
     2.806    44.511     0.200
     2.831    45.921     0.200
     2.869    46.571     0.200
     2.882    45.351     0.200
     2.904    46.901     0.200
     2.904    46.901     0.200
     3.103    51.551     0.200
     3.196    51.641     0.200
     3.196    53.561     0.200
     3.638    56.331     0.200
     3.746    58.031     0.200
     3.809    57.741     0.200
     3.887    59.881     0.200
     4.448    69.541     0.200
     4.669    69.930     0.200
     4.669    71.760     0.200
     4.694    73.261     0.200
     5.351    81.271     0.200
     5.716    86.401     0.200
     6.350    97.411     0.200
     6.527    99.861     0.200
     6.527    96.761     0.200
     6.527   100.228     0.200
     6.527   100.361     0.200
     7.319   107.511     0.200
     7.319   108.081     0.200
     7.319   109.910     0.200
     7.416   109.781     0.200
     7.452   109.891     0.200
     7.623   115.008     0.200
     8.647   125.361     0.200
     9.548   141.985     0.200
     9.770   139.661     0.200
    10.033   145.071     0.200
    11.414   162.041     0.200
    11.414   160.730     0.200
    11.414   162.441     0.200
    11.688   173.211     0.200
    11.688   170.011     0.200
    11.688   169.812     0.200
    11.998   170.911     0.200
    12.331   174.111     0.200
    12.509   175.541     0.200
    13.009   187.011     0.200
    13.009   184.771     0.200
    13.010   184.971     0.200
    13.010   188.061     0.200
    13.300   189.761     0.200
    13.598   192.291     0.200
    13.644   193.011     0.200
    13.998   198.791     0.200
    14.141   200.271     0.200
    14.291   202.771     0.200
    14.464   203.251     0.200
    14.759   208.311     0.200
    14.905   211.391     0.200
    15.007   210.881     0.200
    15.126   211.601     0.200
    15.184   213.821     0.200
    15.462   218.181     0.200
    15.620   217.581     0.200
    15.716   222.501     0.200
    15.759   222.201     0.200
    15.782   220.311     0.200
    15.874   223.121     0.200
    15.954   225.861     0.200
    16.017   225.231     0.200
    16.628   232.831     0.200
    16.640   231.741     0.200
    16.850   234.211     0.200
    16.839   235.531     0.200
    16.927   237.101     0.200
    16.970   235.261     0.200
    17.294   241.941     0.200
    17.507   240.711     0.200
    17.720   246.001     0.200
    17.871   246.731     0.200
    17.911   246.501     0.200
    18.281   253.271     0.200
    18.417   257.091     0.200
    19.066   263.661     0.200
    19.066   263.155     0.200
    19.066   263.861     0.200
     0.312     9.062     0.200
     0.363     9.648     0.200
     0.489    10.875     0.200
     0.779    14.367     0.200
     0.884    16.578     0.200
     1.152    20.156     0.200
     1.254    21.844     0.200
     1.230    21.977     0.200
     1.343    23.438     0.200
     1.797    30.266     0.200
     1.844    29.398     0.200
     1.846    30.578     0.200
     2.058    33.719     0.200
     2.087    34.977     0.200
     2.106    35.656     0.200
     2.130    36.625     0.200
     2.116    34.328     0.200
     2.136    35.555     0.200
     2.166    34.766     0.200
     2.173    35.453     0.200
     2.176    34.586     0.200
     2.182    35.016     0.200
     2.208    34.688     0.200
     2.230    35.414     0.200
     2.235    37.586     0.200
     2.287    37.773     0.200
     2.297    37.492     0.200
     2.369    39.766     0.200
     2.451    41.172     0.200
     2.735    43.016     0.200
     2.724    42.586     0.200
     2.745    46.078     0.200
     2.866    44.508     0.200
     3.050    47.266     0.200
     3.199    48.516     0.200
     3.440    52.352     0.200
     3.964    59.383     0.200
     4.090    66.242     0.200
     4.330    67.406     0.200
     4.817    71.297     0.200
     0.287     9.652     0.200
     0.408    10.734     0.200
     0.610    13.113     0.200
     0.875    17.113     0.200
     1.018    19.426     0.200
     1.111    20.184     0.200
     1.217    21.766     0.200
     1.205    22.395     0.200
     1.263    22.383     0.200
     1.408    23.715     0.200
     1.547    26.676     0.200
     1.865    30.863     0.200
     1.879    31.934     0.200
     1.957    32.652     0.200
     1.954    32.945     0.200
     1.978    33.535     0.200
     1.972    31.793     0.200
     1.976    33.035     0.200
     1.985    32.035     0.200
     2.005    34.363     0.200
     2.065    33.574     0.200
     2.233    39.383     0.200
     2.355    37.844     0.200
     2.353    40.223     0.200
     2.355    37.695     0.200
     2.398    40.742     0.200
     2.428    40.902     0.200
     2.432    38.973     0.200
     2.514    41.953     0.200
     2.621    41.363     0.200
     2.621    39.574     0.200
     2.764    45.633     0.200
     2.833    44.305     0.200
     2.853    45.324     0.200
     3.029    45.324     0.200
     3.300    51.293     0.200
     3.508    52.645     0.200
     3.534    49.844     0.200
     3.745    56.734     0.200
     4.525    66.332     0.200
     5.138    77.395     0.200
     5.238    79.266     0.200
     5.370    81.266     0.200
     5.437    81.082     0.200
     5.506    82.043     0.200
     6.055    90.676     0.200
     6.579    96.793     0.200
     6.610    97.234     0.200
     6.702    97.383     0.200
     0.512    12.188     0.200
     0.480    11.738     0.200
     0.718    14.586     0.200
     1.005    18.816     0.200
     1.046    19.438     0.200
     1.101    20.617     0.200
     1.084    19.676     0.200
     1.247    22.445     0.200
     1.335    23.695     0.200
     1.297    22.047     0.200
     1.349    24.328     0.200
     1.686    28.215     0.200
     1.750    28.957     0.200
     1.802    29.145     0.200
     1.812    29.906     0.200
     1.838    29.715     0.200
     1.842    31.055     0.200
     1.857    30.727     0.200
     1.903    31.395     0.200
     1.952    33.387     0.200
     1.932    31.957     0.200
     2.019    34.047     0.200
     1.990    32.297     0.200
     2.153    35.375     0.200
     2.158    36.688     0.200
     2.091    35.008     0.200
     2.219    38.707     0.200
     2.240    38.035     0.200
     2.424    41.355     0.200
     2.471    38.945     0.200
     2.720    46.008     0.200
     2.965    44.785     0.200
     3.021    46.637     0.200
     3.035    46.176     0.200
     3.295    52.988     0.200
     3.473    49.465     0.200
     3.857    58.375     0.200
     4.309    67.277     0.200
     4.364    64.805     0.200
     4.561    66.465     0.200
     4.957    74.586     0.200
     5.186    77.906     0.200
     6.261    89.707     0.200
    12.864   183.098     0.200
     0.217     7.705     0.200
     0.295     8.984     0.200
     0.379     9.514     0.200
     0.392     9.314     0.200
     0.910    17.184     0.200
     0.955    17.395     0.200
     1.198    21.545     0.200
     1.360    24.055     0.200
     1.378    24.564     0.200
     1.439    24.764     0.200
     1.487    25.945     0.200
     1.912    32.895     0.200
     1.976    31.754     0.200
     1.978    31.404     0.200
     1.995    33.205     0.200
     2.187    35.805     0.200
     2.190    36.295     0.200
     2.250    36.445     0.200
     2.261    36.785     0.200
     2.256    37.334     0.200
     2.261    38.264     0.200
     2.297    36.965     0.200
     2.303    36.584     0.200
     2.308    37.674     0.200
     2.319    37.494     0.200
     2.343    38.984     0.200
     2.355    38.264     0.200
     2.378    37.844     0.200
     2.410    39.354     0.200
     2.417    37.844     0.200
     2.567    40.865     0.200
     2.645    42.625     0.200
     2.774    43.764     0.200
     2.874    44.725     0.200
     2.995    46.635     0.200
     3.012    47.004     0.200
     3.173    48.805     0.200
     3.317    50.834     0.200
     3.816    58.314     0.200
     4.027    61.273     0.200
     4.100    61.795     0.200
     4.270    63.465     0.200
     4.941    74.074     0.200
     0.918    17.879     0.200
     1.418    25.688     0.200
     1.400    24.699     0.200
     1.504    26.199     0.200
     1.933    32.250     0.200
     2.109    35.328     0.200
     2.177    35.070     0.200
     2.235    37.418     0.200
     2.359    38.867     0.200
     2.422    40.238     0.200
     2.434    38.109     0.200
     2.461    38.840     0.200
     2.484    39.520     0.200
     2.470    40.148     0.200
     2.496    38.637     0.200
     2.505    40.148     0.200
     2.538    40.418     0.200
     2.556    39.520     0.200
     2.564    42.289     0.200
     2.564    41.770     0.200
     2.564    40.980     0.200
     2.564    42.238     0.200
     2.608    42.250     0.200
     2.610    41.609     0.200
     2.619    43.258     0.200
     2.629    43.430     0.200
     2.630    43.617     0.200
     2.636    42.949     0.200
     2.699    43.289     0.200
     2.705    43.199     0.200
     2.752    44.949     0.200
     2.777    44.578     0.200
     2.857    45.648     0.200
     2.997    47.410     0.200
     2.961    47.879     0.200
     2.961    48.699     0.200
     3.063    47.730     0.200
     3.110    48.797     0.200
     3.113    49.598     0.200
     3.203    50.520     0.200
     3.202    50.520     0.200
     3.211    49.109     0.200
     3.149    51.457     0.200
     3.413    54.258     0.200
     3.963    59.258     0.200
     3.970    58.738     0.200
     4.014    65.047     0.200
     4.161    63.629     0.200
     4.121    64.168     0.200
     4.252    65.867     0.200
     4.468    71.707     0.200
     4.368    66.707     0.200
     4.832    75.180     0.200
     4.970    73.754     0.200
     4.970    74.688     0.200
     5.385    81.258     0.200
     5.685    84.180     0.200
     6.196    91.527     0.200
     6.294    95.637     0.200
     6.294    93.047     0.200
     6.689    97.500     0.200
     7.635   110.078     0.200
     7.635   110.488     0.200
     7.745   113.719     0.200
     7.780   114.379     0.200
     7.868   115.047     0.200
     7.981   114.297     0.200
    11.253   162.750     0.200
    11.253   161.930     0.200
    11.517   165.449     0.200
    11.366   164.668     0.200
    11.668   162.570     0.200
    11.668   164.102     0.200
    11.668   163.270     0.200
    11.668   162.230     0.200
    11.907   169.938     0.200
    11.967   172.828     0.200
    12.594   178.137     0.200
    12.810   184.941     0.200
    12.810   183.547     0.200
    12.811   183.680     0.200
    13.132   187.707     0.200
    13.523   190.949     0.200
    13.805   196.598     0.200
    13.994   198.277     0.200
    14.313   202.848     0.200
    14.358   202.309     0.200
    14.534   206.199     0.200
    14.585   206.758     0.200
    14.635   208.020     0.200
    14.816   211.320     0.200
    14.981   212.109     0.200
    15.153   213.508     0.200
    15.214   214.230     0.200
    15.246   215.688     0.200
    15.321   217.020     0.200
    15.528   219.117     0.200
    15.504   219.707     0.200
    15.504   219.230     0.200
    15.592   218.949     0.200
    15.575   219.277     0.200
    15.663   219.547     0.200
    15.692   221.809     0.200
    15.926   223.148     0.200
    16.141   226.809     0.200
    16.151   226.520     0.200
    16.358   229.590     0.200
    16.669   235.148     0.200
    16.716   234.180     0.200
    16.860   235.410     0.200
    16.926   236.090     0.200
    17.172   239.520     0.200
    17.221   239.488     0.200
    17.540   243.359     0.200
    17.560   243.648     0.200
    17.549   243.918     0.200
    17.744   246.500     0.200
    17.804   246.730     0.200
    17.804   246.910     0.200
    17.854   247.438     0.200
    17.976   248.578     0.200
    17.970   248.879     0.200
    18.062   251.137     0.200
    18.133   250.230     0.200
    18.250   251.938     0.200
    18.404   253.289     0.200
    18.514   255.059     0.200
    18.514   254.527     0.200
    18.753   259.207     0.200
    18.858   261.617     0.200
     0.257     8.988     0.200
     0.593    12.637     0.200
     0.650    13.676     0.200
     0.708    14.066     0.200
     0.761    14.797     0.200
     1.014    19.117     0.200
     1.113    20.348     0.200
     1.125    20.449     0.200
     1.177    21.066     0.200
     1.616    27.609     0.200
     1.686    28.379     0.200
     1.722    28.438     0.200
     1.841    31.129     0.200
     1.886    31.289     0.200
     1.920    31.656     0.200
     1.971    32.938     0.200
     1.985    32.477     0.200
     1.993    33.289     0.200
     2.036    33.168     0.200
     2.049    34.547     0.200
     2.097    34.789     0.200
     2.495    38.938     0.200
     2.636    41.367     0.200
     2.695    40.516     0.200
     2.753    43.266     0.200
     2.778    44.617     0.200
     3.622    52.227     0.200
     3.752    56.547     0.200
     4.243    66.219     0.200
     4.479    67.516     0.200
     4.602    69.258     0.200
     1.224    21.465     0.200
     1.233    22.422     0.200
     1.875    31.633     0.200
     1.863    30.234     0.200
     1.912    31.273     0.200
     2.060    34.203     0.200
     2.167    35.293     0.200
     2.217    35.953     0.200
     2.229    36.773     0.200
     2.238    36.422     0.200
     2.242    36.285     0.200
     2.290    37.473     0.200
     2.306    38.344     0.200
     2.306    38.234     0.200
     2.378    39.043     0.200
     2.524    41.414     0.200
     2.758    43.242     0.200
     2.815    45.465     0.200
     2.844    45.664     0.200
     2.890    45.324     0.200
     2.883    45.484     0.200
     3.047    48.363     0.200
     3.047    48.363     0.200
     3.071    47.922     0.200
     3.271    50.535     0.200
     3.272    50.535     0.200
     3.467    52.402     0.200
     3.851    58.492     0.200
     3.896    58.945     0.200
     4.129    63.594     0.200
     4.212    64.504     0.200
     4.371    67.984     0.200
     4.740    70.473     0.200
     4.815    73.262     0.200
     5.412    81.004     0.200
     5.851    85.863     0.200
     5.957    87.754     0.200
     6.514    96.594     0.200
     6.582    96.324     0.200
     7.504   108.844     0.200
     7.504   109.664     0.200
     7.650   111.805     0.200
     7.682   113.562     0.200
     7.750   113.633     0.200
     8.454   122.754     0.200
    11.458   163.332     0.200
    11.458   163.934     0.200
    12.634   182.520     0.200
    12.634   182.402     0.200
    12.634   182.172     0.200
    12.934   186.652     0.200
    14.127   198.785     0.200
    14.367   204.203     0.200
    14.391   204.902     0.200
    14.910   211.992     0.200
    14.973   211.812     0.200
    15.069   213.645     0.200
    15.388   217.195     0.200
    15.692   220.074     0.200
    15.926   224.414     0.200
    16.137   226.875     0.200
    16.547   231.684     0.200
    18.415   254.023     0.200
    18.542   256.414     0.200
    18.596   257.902     0.200
    18.647   257.016     0.200
    18.688   257.473     0.200
    18.688   258.273     0.200
    18.689   258.789     0.200
    18.735   258.875     0.200
    19.001   261.535     0.200
    19.039   262.062     0.200
    19.071   262.855     0.200
    19.947   271.535     0.200
     1.410    24.820     0.200
     1.519    26.484     0.200
     1.587    27.891     0.200
     2.102    35.320     0.200
     2.126    36.430     0.200
     2.179    35.648     0.200
     2.351    38.609     0.200
     2.408    39.867     0.200
     2.464    40.039     0.200
     2.496    40.758     0.200
     2.506    40.625     0.200
     2.507    40.836     0.200
     2.539    41.258     0.200
     2.536    42.898     0.200
     2.555    41.016     0.200
     2.568    42.734     0.200
     2.595    43.641     0.200
     2.612    43.711     0.200
     2.613    42.906     0.200
     2.621    41.391     0.200
     2.633    41.070     0.200
     2.679    43.938     0.200
     2.703    44.711     0.200
     2.709    43.266     0.200
     2.836    44.398     0.200
     2.864    46.648     0.200
     2.934    47.070     0.200
     2.991    47.234     0.200
     2.973    47.969     0.200
     3.067    48.938     0.200
     3.102    49.047     0.200
     3.079    50.648     0.200
     3.191    50.750     0.200
     3.191    50.750     0.200
     3.162    51.297     0.200
     3.427    53.367     0.200
     3.530    55.641     0.200
     3.957    59.508     0.200
     3.958    59.555     0.200
     4.026    62.789     0.200
     4.136    66.219     0.200
     4.267    69.172     0.200
     4.383    69.430     0.200
     4.464    68.070     0.200
     4.835    74.930     0.200
     4.959    74.195     0.200
     4.959    74.430     0.200
     4.970    77.281     0.200
     5.034    76.984     0.200
     5.399    81.289     0.200
     5.505    87.531     0.200
     5.721    89.516     0.200
     5.912    90.430     0.200
     6.203    92.375     0.200
     6.647    98.656     0.200
     6.676    99.609     0.200
     7.623   112.320     0.200
     7.731   113.891     0.200
     7.767   114.734     0.200
     7.855   115.188     0.200
     7.988   120.000     0.200
    11.659   162.398     0.200
    11.659   164.195     0.200
    12.822   182.297     0.200
    12.821   184.430     0.200
    12.821   181.922     0.200
    13.142   186.422     0.200
    13.530   195.305     0.200
    13.565   195.516     0.200
    14.003   201.172     0.200
    14.365   204.531     0.200
    14.545   207.875     0.200
    14.595   208.258     0.200
    14.826   211.625     0.200
    14.990   212.602     0.200
    15.680   222.305     0.200
    15.761   223.422     0.200
    17.071   237.859     0.200
    17.182   239.109     0.200
    17.563   244.289     0.200
    17.583   244.336     0.200
    17.812   246.859     0.200
    18.074   250.906     0.200
    18.141   251.039     0.200
    18.594   256.695     0.200
    18.648   257.602     0.200
    18.787   259.352     0.200
    18.869   260.609     0.200
    18.869   260.500     0.200
    19.975   273.078     0.200
     1.670    29.023     0.200
     1.747    29.852     0.200
     1.762    30.883     0.200
     1.781    30.562     0.200
     1.898    32.633     0.200
     1.982    33.391     0.200
     2.059    33.750     0.200
     2.181    35.609     0.200
     2.232    38.039     0.200
     2.388    39.602     0.200
     2.427    40.609     0.200
     2.435    39.359     0.200
     2.478    41.078     0.200
     2.491    39.914     0.200
     2.491    39.914     0.200
     2.506    42.047     0.200
     2.508    41.398     0.200
     2.555    42.453     0.200
     2.568    42.203     0.200
     2.605    42.648     0.200
     2.622    41.641     0.200
     2.622    42.711     0.200
     2.623    43.938     0.200
     2.622    41.750     0.200
     2.636    43.281     0.200
     2.644    43.812     0.200
     2.647    43.477     0.200
     2.651    44.320     0.200
     2.653    44.164     0.200
     2.669    43.594     0.200
     2.670    42.188     0.200
     2.695    44.328     0.200
     2.697    43.898     0.200
     2.694    44.523     0.200
     2.694    44.523     0.200
     2.702    44.133     0.200
     2.719    43.461     0.200
     2.745    43.219     0.200
     2.776    44.922     0.200
     2.865    47.898     0.200
     2.891    45.133     0.200
     3.048    49.297     0.200
     3.123    49.969     0.200
     3.267    52.812     0.200
     3.348    53.680     0.200
     3.348    53.523     0.200
     3.411    54.188     0.200
     3.599    59.164     0.200
     3.626    56.430     0.200
     3.695    56.172     0.200
     3.692    56.797     0.200
     3.900    59.562     0.200
     3.971    60.852     0.200
     4.203    64.438     0.200
     4.368    67.914     0.200
     4.456    67.938     0.200
     4.456    66.172     0.200
     5.163    81.531     0.200
     5.179    77.539     0.200
     5.573    83.773     0.200
     5.937    89.312     0.200
     6.132    94.852     0.200
     6.238    93.062     0.200
     6.330    94.688     0.200
     6.406    97.281     0.200
     6.672    99.992     0.200
     6.672   100.844     0.200
     7.097   103.273     0.200
     7.097   107.078     0.200
     8.144   124.523     0.200
     9.256   137.492     0.200
     9.937   145.570     0.200
    11.227   160.016     0.200
    11.227   158.062     0.200
    11.227   161.438     0.200
    11.556   166.500     0.200
    11.659   168.312     0.200
    11.899   173.031     0.200
    12.759   181.719     0.200
    13.126   188.523     0.200
    13.126   187.789     0.200
    13.127   187.594     0.200
    13.395   191.828     0.200
    13.603   193.219     0.200
    13.706   195.359     0.200
    14.111   203.070     0.200
    14.221   203.297     0.200
    14.516   206.781     0.200
    14.858   211.977     0.200
    14.871   211.750     0.200
    15.119   215.820     0.200
    15.204   216.898     0.200
    15.533   218.062     0.200
    15.562   218.828     0.200
    15.841   222.727     0.200
    15.842   222.602     0.200
    16.067   225.188     0.200
    16.234   227.227     0.200
    16.550   232.703     0.200
    16.673   234.812     0.200
    16.929   237.172     0.200
    17.533   244.617     0.200
    17.554   245.203     0.200
    17.854   248.672     0.200
    17.861   248.219     0.200
    17.878   248.297     0.200
    17.963   249.922     0.200
    18.088   250.922     0.200
    18.199   252.008     0.200
    18.328   253.578     0.200
    18.411   255.602     0.200
    18.817   259.969     0.200
    19.022   262.711     0.200
    19.189   264.992     0.200
    19.189   264.617     0.200
    19.188   264.820     0.200
    19.295   265.531     0.200
    20.170   275.438     0.200
     1.241    21.148     0.200
     1.938    31.871     0.200
     2.247    36.602     0.200
     2.249    37.051     0.200
     2.276    37.930     0.200
     2.288    38.180     0.200
     2.341    38.379     0.200
     2.333    37.090     0.200
     2.340    37.820     0.200
     2.347    38.121     0.200
     2.354    38.570     0.200
     2.373    38.789     0.200
     2.383    37.641     0.200
     2.396    38.730     0.200
     2.482    40.500     0.200
     2.520    41.621     0.200
     2.586    42.059     0.200
     2.552    41.250     0.200
     2.957    45.648     0.200
     3.120    48.559     0.200
     3.197    49.332     0.200
     3.231    51.031     0.200
     3.336    52.199     0.200
     3.816    59.441     0.200
     3.930    61.141     0.200
     4.058    63.410     0.200
     4.210    62.219     0.200
     4.736    70.980     0.200
     5.383    82.180     0.200
     1.421    25.928     0.200
     1.970    34.137     0.200
     2.289    38.988     0.200
     2.299    38.777     0.200
     2.362    40.328     0.200
     2.407    38.758     0.200
     2.818    45.717     0.200
     2.947    48.488     0.200
     4.112    64.268     0.200
     0.192     8.120     0.200
     0.306     9.220     0.200
     0.469    10.760     0.200
     0.885    16.760     0.200
     1.037    18.820     0.200
     1.123    20.480     0.200
     1.345    23.720     0.200
     1.360    24.070     0.200
     1.417    24.990     0.200
     1.528    25.600     0.200
     1.528    26.500     0.200
     1.870    31.520     0.200
     1.953    32.000     0.200
     2.056    33.220     0.200
     2.139    35.950     0.200
     2.218    36.780     0.200
     2.222    37.040     0.200
     2.244    36.880     0.200
     2.275    37.930     0.200
     2.286    37.930     0.200
     2.292    37.730     0.200
     2.300    37.400     0.200
     2.304    37.630     0.200
     2.322    37.690     0.200
     2.321    38.750     0.200
     2.321    38.080     0.200
     2.321    37.590     0.200
     2.350    38.100     0.200
     2.355    38.180     0.200
     2.355    38.180     0.200
     2.366    38.890     0.200
     2.371    37.560     0.200
     2.370    38.820     0.200
     2.383    39.150     0.200
     2.385    38.650     0.200
     2.387    38.780     0.200
     2.393    38.810     0.200
     2.426    39.700     0.200
     2.431    39.550     0.200
     2.458    39.410     0.200
     2.459    39.760     0.200
     2.478    40.260     0.200
     2.525    41.270     0.200
     2.588    41.030     0.200
     2.692    42.460     0.200
     2.692    44.490     0.200
     2.692    43.510     0.200
     2.801    44.470     0.200
     2.879    46.580     0.200
     2.901    45.410     0.200
     2.910    48.150     0.200
     3.050    47.460     0.200
     3.076    47.760     0.200
     3.235    50.840     0.200
     3.235    50.840     0.200
     3.274    50.280     0.200
     3.275    50.280     0.200
     3.273    50.710     0.200
     3.741    57.310     0.200
     3.825    56.790     0.200
     3.828    57.200     0.200
     3.942    63.090     0.200
     4.090    62.240     0.200
     4.151    62.910     0.200
     4.184    65.720     0.200
     4.329    65.050     0.200
     4.587    68.520     0.200
     4.689    69.810     0.200
     4.859    73.350     0.200
     5.002    73.476     0.200
     5.002    74.030     0.200
     5.226    78.290     0.200
     5.221    78.190     0.200
     5.495    80.580     0.200
     5.510    84.920     0.200
     5.705    82.950     0.200
     5.679    84.900     0.200
     6.025    91.210     0.200
     6.025    87.760     0.200
     6.025    91.690     0.200
     6.025    89.640     0.200
     6.703    98.430     0.200
     6.776    99.510     0.200
     7.695   112.600     0.200
     7.695   112.380     0.200
     7.710   112.860     0.200
     7.844   115.100     0.200
     7.876   115.820     0.200
     7.967   117.050     0.200
     8.397   122.640     0.200
     8.420   123.100     0.200
     9.249   134.670     0.200
    10.044   145.480     0.200
    10.728   154.520     0.200
    10.991   158.290     0.200
    11.242   160.630     0.200
    11.621   165.760     0.200
    11.621   164.292     0.200
    11.621   163.720     0.200
    11.621   166.090     0.200
    12.536   179.340     0.200
    12.535   180.544     0.200
    12.535   180.670     0.200
    12.855   185.750     0.200
    13.249   187.570     0.200
    13.530   190.490     0.200
    13.718   194.700     0.200
    13.743   195.160     0.200
    14.087   198.820     0.200
    15.231   213.620     0.200
    15.657   218.240     0.200
    16.233   227.575     0.200
    16.294   225.900     0.200
    18.585   257.790     0.200
     1.193    20.814     0.200
     1.991    32.295     0.200
     2.155    35.895     0.200
     2.222    35.953     0.200
     2.335    37.494     0.200
     2.335    36.904     0.200
     2.409    38.555     0.200
     2.435    39.584     0.200
     2.441    38.404     0.200
     2.640    42.264     0.200
     2.768    41.234     0.200
     2.761    43.514     0.200
     3.020    46.264     0.200
     3.107    47.934     0.200
     3.183    49.664     0.200
     3.242    50.623     0.200
     3.274    49.844     0.200
     3.779    60.033     0.200
     3.881    57.363     0.200
     3.926    59.873     0.200
     4.022    63.254     0.200
     4.256    63.895     0.200
     4.299    65.033     0.200
     4.694    70.443     0.200
     5.159    77.674     0.200
     5.351    81.484     0.200
     5.860    84.904     0.200
     8.009   117.414     0.200
     1.351    23.094     0.200
     1.911    31.422     0.200
     2.006    33.645     0.200
     2.068    33.273     0.200
     2.093    35.004     0.200
     2.178    35.734     0.200
     2.237    36.652     0.200
     2.242    36.785     0.200
     2.282    37.125     0.200
     2.277    36.055     0.200
     2.277    36.523     0.200
     2.316    35.762     0.200
     2.326    38.273     0.200
     2.339    37.902     0.200
     2.415    39.543     0.200
     2.478    40.355     0.200
     2.480    40.082     0.200
     2.876    44.574     0.200
     3.031    47.285     0.200
     3.088    47.945     0.200
     3.231    50.332     0.200
     3.263    51.223     0.200
     3.923    58.234     0.200
     4.165    64.492     0.200
     2.758    46.305     0.200
     3.497    56.824     0.200
     4.422    70.539     0.200
     6.822   103.066     0.200
     7.043   108.453     0.200
     7.043   106.805     0.200
     7.883   119.445     0.200
    10.101   150.395     0.200
    10.559   155.207     0.200
    11.229   165.699     0.200
    11.229   163.062     0.200
    11.229   163.605     0.200
    11.200   165.125     0.200
    11.698   172.637     0.200
    11.808   175.684     0.200
    11.808   174.340     0.200
    11.808   174.227     0.200
    11.808   172.305     0.200
    12.029   177.504     0.200
    12.029   175.535     0.200
    12.029   176.004     0.200
    12.129   177.375     0.200
    13.277   193.906     0.200
    13.543   199.355     0.200
    13.729   198.805     0.200
    13.729   197.410     0.200
    13.849   200.004     0.200
    15.434   222.176     0.200
     0.900    20.277     0.200
     1.037    22.324     0.200
     1.312    26.484     0.200
     1.356    27.586     0.200
     1.813    32.547     0.200
     2.374    41.555     0.200
     2.544    43.457     0.200
     2.615    45.406     0.200
     2.630    45.547     0.200
     2.668    46.176     0.200
     2.643    45.367     0.200
     2.689    46.086     0.200
     2.705    45.754     0.200
     2.708    46.637     0.200
     2.726    46.297     0.200
     2.743    47.305     0.200
     2.758    47.305     0.200
     2.767    47.434     0.200
     2.782    48.027     0.200
     2.782    47.766     0.200
     2.782    47.895     0.200
     2.784    47.695     0.200
     2.804    47.637     0.200
     2.833    48.477     0.200
     2.853    48.344     0.200
     2.879    48.957     0.200
     2.896    49.535     0.200
     2.913    48.797     0.200
     3.004    50.625     0.200
     3.026    51.066     0.200
     3.194    53.234     0.200
     3.251    54.105     0.200
     3.327    54.875     0.200
     3.414    56.645     0.200
     3.497    58.684     0.200
     3.686    59.855     0.200
     3.734    61.395     0.200
     3.766    60.266     0.200
     4.004    64.355     0.200
     4.075    65.414     0.200
     4.273    65.645     0.200
     4.422    70.297     0.200
     4.518    71.926     0.200
     4.784    76.496     0.200
     4.910    78.207     0.200
     4.918    79.035     0.200
     4.989    78.055     0.200
     5.030    78.695     0.200
     5.036    78.426     0.200
     5.150    79.836     0.200
     6.049    94.004     0.200
     6.069    92.984     0.200
     6.087    92.984     0.200
     6.119    93.664     0.200
     6.364   101.066     0.200
     6.469   100.824     0.200
     6.539    98.625     0.200
     6.822   105.105     0.200
     7.043   107.727     0.200
     7.131   107.434     0.200
     8.245   126.555     0.200
     8.286   124.617     0.200
     9.027   134.684     0.200
     9.280   140.457     0.200
    10.084   149.906     0.200
    10.900   162.164     0.200
    11.229   163.336     0.200
    11.406   168.246     0.200
    11.808   173.367     0.200
    13.133   190.836     0.200
     0.233     8.941     0.200
     0.568    12.383     0.200
     0.690    13.961     0.200
     0.679    14.102     0.200
     0.753    14.914     0.200
     1.029    19.504     0.200
     1.136    20.902     0.200
     1.155    21.113     0.200
     1.192    21.602     0.200
     1.642    28.023     0.200
     1.712    26.582     0.200
     1.739    28.523     0.200
     1.718    28.492     0.200
     1.857    31.184     0.200
     1.909    31.723     0.200
     2.017    33.152     0.200
     2.021    35.281     0.200
     2.024    32.094     0.200
     2.026    32.645     0.200
     2.068    33.574     0.200
     2.069    34.422     0.200
     2.108    34.672     0.200
     2.106    35.594     0.200
     2.261    38.922     0.200
     2.359    39.441     0.200
     2.400    40.094     0.200
     2.660    41.691     0.200
     2.661    41.684     0.200
     2.754    43.184     0.200
     4.242    64.684     0.200
     4.335    65.492     0.200
     4.478    68.984     0.200
     0.318     8.797     0.200
     0.317     8.969     0.200
     0.462    10.559     0.200
     0.832    16.039     0.200
     0.889    16.438     0.200
     1.183    21.137     0.200
     1.306    23.098     0.200
     1.385    24.398     0.200
     1.513    25.898     0.200
     1.847    31.027     0.200
     1.905    30.508     0.200
     1.892    31.500     0.200
     1.898    30.359     0.200
     2.091    34.449     0.200
     2.139    35.930     0.200
     2.159    35.219     0.200
     2.183    37.488     0.200
     2.230    35.750     0.200
     2.286    37.199     0.200
     2.322    38.207     0.200
     2.421    41.199     0.200
     2.502    39.027     0.200
     2.598    39.500     0.200
     2.772    43.309     0.200
     2.910    45.359     0.200
     3.080    47.598     0.200
     4.847    72.797     0.200
     0.879    16.266     0.200
     1.538    26.066     0.200
     1.834    31.016     0.200
     1.834    30.266     0.200
     1.889    31.727     0.200
     2.048    34.008     0.200
     2.104    34.949     0.200
     2.155    35.746     0.200
     2.162    34.348     0.200
     2.195    36.379     0.200
     2.220    35.746     0.200
     2.225    35.098     0.200
     2.288    37.766     0.200
     2.277    34.797     0.200
     2.291    37.516     0.200
     2.359    38.855     0.200
     2.494    40.719     0.200
     2.712    42.617     0.200
     2.744    44.426     0.200
     2.771    42.566     0.200
     2.854    45.008     0.200
     3.040    47.277     0.200
     3.190    47.559     0.200
     3.447    51.758     0.200
     3.652    54.297     0.200
     3.682    54.027     0.200
     4.095    63.188     0.200
     4.199    67.605     0.200
     4.335    69.078     0.200
     4.807    70.766     0.200
     5.023    73.066     0.200
     1.529    26.309     0.200
     2.110    35.039     0.200
     2.195    36.566     0.200
     2.357    38.508     0.200
     2.521    41.449     0.200
     2.534    42.137     0.200
     2.555    42.098     0.200
     2.570    41.066     0.200
     2.585    43.039     0.200
     2.585    42.887     0.200
     2.585    42.387     0.200
     2.585    43.207     0.200
     2.613    43.496     0.200
     2.631    42.746     0.200
     2.689    43.539     0.200
     2.726    44.406     0.200
     2.799    45.598     0.200
     2.883    46.777     0.200
     2.999    47.129     0.200
     2.991    49.469     0.200
     2.991    48.699     0.200
     3.132    51.246     0.200
     3.108    48.508     0.200
     3.098    49.789     0.200
     3.191    50.340     0.200
     3.548    55.020     0.200
     3.436    52.688     0.200
     3.970    61.098     0.200
     4.036    63.109     0.200
     3.950    61.027     0.200
     4.044    62.520     0.200
     4.154    62.898     0.200
     4.475    68.457     0.200
     4.283    65.699     0.200
     4.853    74.289     0.200
     4.989    74.996     0.200
     4.959    74.262     0.200
     4.959    74.129     0.200
     5.044    74.520     0.200
     5.504    81.539     0.200
     5.523    83.828     0.200
     5.409    80.559     0.200
     5.674    84.180     0.200
     5.734    84.867     0.200
     5.926    87.559     0.200
     6.221    92.949     0.200
     6.324    95.668     0.200
     6.324    94.477     0.200
     6.646    98.859     0.200
     6.672    98.859     0.200
     7.621   113.457     0.200
     7.621   112.648     0.200
     7.726   114.387     0.200
     7.750   113.406     0.200
     7.762   116.117     0.200
     7.850   115.957     0.200
     8.007   117.707     0.200
     8.505   125.488     0.200
     8.702   125.258     0.200
     8.699   129.539     0.200
     8.675   126.109     0.200
     8.950   131.598     0.200
    10.227   149.746     0.200
    10.310   150.258     0.200
    10.727   156.758     0.200
    11.283   164.207     0.200
    11.283   165.449     0.200
    11.416   166.879     0.200
    11.544   167.020     0.200
    11.826   171.066     0.200
    12.059   173.098     0.200
    12.553   180.289     0.200
    12.641   183.207     0.200
    12.641   182.770     0.200
    12.840   186.566     0.200
    12.840   185.668     0.200
    12.840   185.680     0.200
    13.161   190.340     0.200
    13.246   193.027     0.200
    13.549   193.777     0.200
    13.583   192.430     0.200
    13.583   193.809     0.200
    13.636   197.359     0.200
    14.033   200.727     0.200
    14.384   204.367     0.200
    16.071   228.953     0.200
     1.338    23.547     0.200
     1.441    24.555     0.200
     1.866    30.969     0.200
     1.893    31.492     0.200
     2.034    33.156     0.200
     2.381    38.195     0.200
     2.256    34.844     0.200
     2.454    39.156     0.200
     2.596    40.555     0.200
     2.606    41.617     0.200
     2.606    42.242     0.200
     2.630    41.414     0.200
     2.669    42.727     0.200
     2.693    43.008     0.200
     2.740    42.867     0.200
     2.689    43.164     0.200
     2.752    43.086     0.200
     2.715    42.258     0.200
     2.723    43.234     0.200
     2.761    43.656     0.200
     2.785    44.453     0.200
     2.818    44.484     0.200
     2.836    44.484     0.200
     2.832    44.992     0.200
     2.832    45.406     0.200
     2.832    45.742     0.200
     2.832    45.586     0.200
     2.833    44.445     0.200
     2.856    45.047     0.200
     2.855    45.312     0.200
     2.855    46.008     0.200
     2.858    45.742     0.200
     2.878    45.742     0.200
     2.899    46.422     0.200
     2.908    45.469     0.200
     2.925    46.023     0.200
     2.946    47.992     0.200
     2.951    46.375     0.200
     2.964    46.375     0.200
     2.987    47.914     0.200
     3.098    48.469     0.200
     3.255    48.656     0.200
     3.317    51.836     0.200
     3.279    50.547     0.200
     3.333    52.477     0.200
     3.499    53.594     0.200
     3.659    55.383     0.200
     3.592    58.516     0.200
     3.592    55.023     0.200
     3.787    57.078     0.200
     3.807    58.969     0.200
     3.862    59.297     0.200
     4.294    65.156     0.200
     4.378    64.406     0.200
     4.160    59.922     0.200
     4.612    68.148     0.200
     5.008    72.758     0.200
     5.055    77.453     0.200
     5.108    74.633     0.200
     5.009    71.914     0.200
     5.393    80.594     0.200
     5.771    82.383     0.200
     6.004    88.023     0.200
     6.036    89.039     0.200
     6.128    91.656     0.200
     6.137    87.703     0.200
     6.546    96.305     0.200
     6.456    92.867     0.200
     6.634    94.984     0.200
     6.985   102.336     0.200
     6.985   103.227     0.200
     6.985   102.734     0.200
     6.917   103.688     0.200
     6.917   103.164     0.200
     6.917   104.312     0.200
     6.917   101.312     0.200
     7.043   102.117     0.200
     7.082   103.578     0.200
     7.260   106.242     0.200
     7.810   114.078     0.200
     8.365   123.688     0.200
     9.111   135.258     0.200
    10.027   144.695     0.200
    10.485   149.789     0.200
    11.205   159.945     0.200
    11.205   159.312     0.200
    11.493   166.625     0.200
    11.777   170.039     0.200
    11.960   170.742     0.200
    11.960   170.062     0.200
    11.960   174.812     0.200
    11.904   169.727     0.200
    11.904   172.367     0.200
    11.904   171.445     0.200
    11.904   173.219     0.200
    12.209   174.055     0.200
    12.339   176.273     0.200
    12.543   180.227     0.200
    13.368   191.594     0.200
    13.368   191.164     0.200
    13.369   191.367     0.200
    13.369   192.312     0.200
    13.466   191.656     0.200
    13.466   190.758     0.200
    13.631   194.172     0.200
    13.793   196.016     0.200
    13.793   193.656     0.200
    13.793   194.938     0.200
    13.930   196.953     0.200
    14.351   203.953     0.200
    14.451   204.922     0.200
    14.734   207.234     0.200
    14.781   207.188     0.200
    15.114   213.359     0.200
    15.352   218.336     0.200
    18.826   261.812     0.200
    19.431   267.617     0.200
     2.610    43.113     0.200
     2.591    43.715     0.200
     4.982    75.715     0.200
     6.085    93.016     0.200
     6.674   103.215     0.200
     6.674   102.406     0.200
     8.119   121.816     0.200
    11.165   160.414     0.200
    11.165   161.016     0.200
    11.665   171.887     0.200
    12.053   175.043     0.200
    13.565   195.016     0.200
    13.565   195.414     0.200
    13.565   193.113     0.200
    13.565   194.016     0.200
    13.683   195.805     0.200
    15.579   219.734     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
EOF
# P_ arrivals
gmt plot $proj $reg -Sx -Wthin -Gcyan << EOF
     2.837    51.930     0.200
     3.072    57.000     0.200
     3.079    58.090     0.200
     3.140    57.434     0.200
     3.251    65.047     0.200
     4.570    83.277     0.200
     2.701    51.012     0.200
     7.407   144.121     0.200
     8.082   149.340     0.200
     2.892    54.551     0.200
     5.485    99.809     0.200
     2.891    55.531     0.200
     2.605    55.680     0.200
     2.785    51.684     0.200
     2.599    47.573     0.200
     2.625    48.271     0.200
     3.125    59.664     0.200
     2.826    52.426     0.200
     2.524    46.168     0.200
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
     1.544    29.672     0.200
     2.495    44.672     0.200
     2.583    46.172     0.200
     0.180     4.766     0.200
     0.250     6.155     0.200
     0.168     7.523     0.200
     0.556    11.713     0.200
     0.977    18.742     0.200
     0.168     5.396     0.200
     1.533    27.957     0.200
     0.154     6.413     0.200
     0.397     9.803     0.200
     0.424    10.223     0.200
     0.682    13.848     0.200
     1.012    19.137     0.200
     0.274     6.949     0.200
     0.677    13.379     0.200
     1.138    21.430     0.200
     1.270    23.730     0.200
     1.646    29.230     0.200
     2.423    44.871     0.200
     2.806    49.172     0.200
     3.245    53.750     0.200
     0.865    16.691     0.200
     0.865    16.859     0.200
     1.023    18.859     0.200
     2.617    45.070     0.200
     0.274     8.391     0.200
     1.011    18.375     0.200
     1.185    21.711     0.200
     0.168     4.598     0.200
     0.242     5.768     0.200
     1.019    18.407     0.200
     1.287    23.008     0.200
     2.467    42.978     0.200
     2.850    50.397     0.200
     0.594    12.398     0.200
     0.997    18.469     0.200
     1.181    21.379     0.200
     1.217    22.559     0.200
     2.554    45.301     0.200
     4.296    73.309     0.200
     0.358     8.176     0.200
     0.754    14.773     0.200
     0.240     6.789     0.200
     0.642    13.020     0.200
     1.124    20.969     0.200
     1.286    24.020     0.200
     1.441    26.188     0.200
     1.594    28.508     0.200
     0.215     6.000     0.200
     0.285     6.980     0.200
     1.646    28.891     0.200
     1.674    29.543     0.200
     2.654    45.730     0.200
     3.616    61.871     0.200
     3.972    68.402     0.200
     0.626    13.809     0.200
     0.553    11.246     0.200
     1.187    22.246     0.200
     1.422    26.168     0.200
     1.422    26.285     0.200
     1.627    28.336     0.200
     1.958    33.535     0.200
     2.148    36.875     0.200
     2.180    37.047     0.200
     2.220    37.855     0.200
     3.004    52.258     0.200
     3.161    56.488     0.200
     3.221    54.777     0.200
     3.990    66.578     0.200
     0.294     7.928     0.200
     0.372     8.357     0.200
     0.419     9.078     0.200
     0.929    17.838     0.200
     1.189    22.408     0.200
     1.189    22.277     0.200
     1.222    22.387     0.200
     1.295    23.197     0.200
     2.610    44.047     0.200
     2.595    45.979     0.200
     4.087    69.697     0.200
     0.190     5.582     0.200
     0.167     5.430     0.200
     0.249     6.648     0.200
     0.592    11.871     0.200
     0.811    15.391     0.200
     2.156    38.551     0.200
     2.687    48.680     0.200
     2.969    53.000     0.200
     3.107    54.031     0.200
     3.456    58.371     0.200
     3.965    68.820     0.200
     0.871    17.398     0.200
     0.824    16.441     0.200
     1.197    22.680     0.200
     1.197    22.922     0.200
     1.327    24.230     0.200
     1.453    27.359     0.200
     1.482    28.020     0.200
     2.536    44.852     0.200
     2.857    50.379     0.200
     2.871    50.309     0.200
     3.131    54.480     0.200
     3.363    57.762     0.200
     3.607    62.309     0.200
     4.443    75.000     0.200
     0.110     6.422     0.200
     0.323     8.703     0.200
     0.698    13.984     0.200
     0.726    14.234     0.200
     0.807    15.227     0.200
     0.819    15.531     0.200
     0.957    17.477     0.200
     0.991    18.352     0.200
     1.393    24.711     0.200
     1.596    27.477     0.200
     1.735    30.336     0.200
     2.445    41.227     0.200
     3.690    60.984     0.200
     3.731    62.547     0.200
     3.829    64.305     0.200
     4.508    75.094     0.200
     0.421     9.345     0.200
     0.455     9.675     0.200
     0.858    16.625     0.200
     1.075    20.104     0.200
     1.268    23.625     0.200
     1.427    26.925     0.200
     1.724    30.864     0.200
     1.731    32.024     0.200
     1.780    31.925     0.200
     2.328    40.515     0.200
     2.544    44.795     0.200
     2.619    44.725     0.200
     2.670    45.895     0.200
     2.694    46.015     0.200
     2.809    47.595     0.200
     2.839    48.435     0.200
     3.172    55.215     0.200
     3.326    56.585     0.200
     3.420    57.354     0.200
     3.420    57.545     0.200
     4.129    73.744     0.200
     4.902    86.935     0.200
     0.231     7.582     0.200
     0.342     8.680     0.200
     0.360     9.203     0.200
     0.366     8.922     0.200
     0.438    10.191     0.200
     0.853    16.062     0.200
     1.186    21.320     0.200
     1.316    23.391     0.200
     1.378    24.312     0.200
     1.488    26.301     0.200
     1.708    29.781     0.200
     2.193    38.680     0.200
     2.193    37.680     0.200
     2.243    39.863     0.200
     2.288    40.152     0.200
     2.322    41.430     0.200
     2.321    39.031     0.200
     2.430    41.031     0.200
     2.468    42.203     0.200
     2.500    44.070     0.200
     2.560    44.141     0.200
     2.569    44.402     0.200
     2.693    47.203     0.200
     2.860    47.793     0.200
     4.079    67.250     0.200
     4.098    69.012     0.200
     0.226     6.117     0.200
     0.334     7.826     0.200
     0.513    11.027     0.200
     0.579    12.037     0.200
     0.753    14.928     0.200
     1.036    18.508     0.200
     1.294    23.848     0.200
     1.398    25.217     0.200
     2.031    36.166     0.200
     2.817    50.027     0.200
     0.019     6.648     0.200
     0.255     7.898     0.200
     0.616    12.883     0.200
     0.735    14.359     0.200
     0.047     6.582     0.200
     0.268     8.191     0.200
     0.617    12.633     0.200
     0.560    11.891     0.200
     0.734    14.391     0.200
     0.865    16.613     0.200
     1.017    19.113     0.200
     3.283    56.102     0.200
     3.698    64.473     0.200
     0.258     7.773     0.200
     0.319     8.674     0.200
     0.387     9.613     0.200
     0.391     9.104     0.200
     0.850    16.674     0.200
     0.957    17.555     0.200
     1.151    20.703     0.200
     1.319    23.334     0.200
     1.333    23.924     0.200
     1.449    25.584     0.200
     2.196    36.914     0.200
     2.201    37.293     0.200
     2.295    39.174     0.200
     2.298    39.533     0.200
     2.402    43.203     0.200
     2.437    41.623     0.200
     2.490    42.783     0.200
     0.283     7.119     0.200
     0.536    11.158     0.200
     0.630    13.520     0.200
     0.758    14.639     0.200
     1.162    21.449     0.200
     1.197    22.459     0.200
     3.418    59.189     0.200
     4.223    71.139     0.200
     5.092    91.498     0.200
     0.170     7.242     0.200
     0.210     7.574     0.200
     0.207     7.523     0.200
     0.390     9.914     0.200
     0.562    12.305     0.200
     0.778    15.102     0.200
     0.872    16.453     0.200
     1.280    22.781     0.200
     1.326    23.633     0.200
     1.619    28.203     0.200
     1.899    33.203     0.200
     2.222    38.652     0.200
     2.235    37.965     0.200
     2.245    39.074     0.200
     2.334    40.895     0.200
     2.461    41.594     0.200
     0.270     7.211     0.200
     2.816    49.383     0.200
     0.239     7.230     0.200
     0.256     7.689     0.200
     0.379     8.789     0.200
     0.528    11.131     0.200
     0.828    15.600     0.200
     0.816    16.570     0.200
     1.199    22.141     0.200
     1.212    22.230     0.200
     1.325    24.279     0.200
     1.421    25.699     0.200
     1.835    31.609     0.200
     1.839    32.930     0.200
     2.126    35.900     0.200
     2.134    36.500     0.200
     2.273    41.760     0.200
     2.273    38.789     0.200
     2.406    41.150     0.200
     2.542    45.020     0.200
     2.602    45.490     0.200
     2.774    46.561     0.200
     2.806    46.721     0.200
     2.819    48.750     0.200
     2.815    47.311     0.200
     3.579    60.199     0.200
     4.171    69.480     0.200
     0.169     5.930     0.200
     0.435     9.844     0.200
     0.885    17.195     0.200
     1.180    21.797     0.200
     1.419    25.688     0.200
     2.488    43.344     0.200
     2.636    46.250     0.200
     2.702    47.406     0.200
     3.195    54.969     0.200
     0.367     9.012     0.200
     0.859    16.303     0.200
     1.564    28.322     0.200
     2.533    44.082     0.200
     2.612    45.371     0.200
     2.648    45.092     0.200
     2.687    47.191     0.200
     3.046    53.562     0.200
     3.090    53.803     0.200
     4.033    66.742     0.200
     4.812    80.803     0.200
     0.302     7.234     0.200
     0.519    10.793     0.200
     0.988    19.762     0.200
     1.269    23.633     0.200
     1.304    23.574     0.200
     2.275    40.504     0.200
     2.573    44.535     0.200
     2.617    45.875     0.200
     2.670    45.324     0.200
     2.707    46.375     0.200
     2.720    47.703     0.200
     2.776    49.395     0.200
     2.784    49.195     0.200
     2.859    48.172     0.200
     3.061    52.105     0.200
     3.218    55.184     0.200
     3.211    55.012     0.200
     3.307    57.004     0.200
     3.305    56.332     0.200
     3.324    59.664     0.200
     4.121    68.562     0.200
     0.288     7.263     0.200
     0.770    14.763     0.200
     1.076    19.622     0.200
     1.076    19.952     0.200
     1.076    19.513     0.200
     1.303    23.162     0.200
     2.811    50.522     0.200
     3.748    66.042     0.200
     4.778    83.122     0.200
     0.103     5.007     0.200
     0.291     7.677     0.200
     0.651    12.437     0.200
     0.724    14.357     0.200
     2.643    45.917     0.200
     4.935    82.567     0.200
     0.293     7.681     0.200
     1.459    26.150     0.200
     1.459    26.341     0.200
     2.595    43.750     0.200
     2.617    44.420     0.200
     2.617    46.351     0.200
     3.052    51.670     0.200
     3.274    57.040     0.200
     3.274    56.381     0.200
     0.260     7.292     0.200
     1.426    25.892     0.200
     1.504    27.401     0.200
     1.548    27.361     0.200
     2.054    36.012     0.200
     2.350    40.952     0.200
     2.390    40.901     0.200
     2.400    41.092     0.200
     2.552    43.282     0.200
     2.552    43.382     0.200
     2.629    45.552     0.200
     3.047    54.021     0.200
     3.224    54.021     0.200
     0.100     5.887     0.200
     0.110     5.746     0.200
     0.541    11.617     0.200
     0.591    12.258     0.200
     0.742    14.797     0.200
     1.401    25.828     0.200
     1.469    26.988     0.200
     2.632    45.035     0.200
     2.944    50.867     0.200
     2.963    51.348     0.200
     0.137     3.945     0.200
     0.150     4.385     0.200
     0.459     9.205     0.200
     0.634    12.275     0.200
     0.707    14.305     0.200
     0.873    16.285     0.200
     1.324    24.195     0.200
     1.940    35.085     0.200
     2.042    36.325     0.200
     2.148    39.275     0.200
     2.155    38.315     0.200
     2.200    39.145     0.200
     2.219    40.385     0.200
     2.222    39.835     0.200
     2.250    40.145     0.200
     2.252    42.025     0.200
     2.256    39.885     0.200
     2.261    39.475     0.200
     2.270    42.385     0.200
     2.366    42.705     0.200
     2.366    42.265     0.200
     2.397    44.125     0.200
     2.554    46.175     0.200
     2.597    46.495     0.200
     2.685    48.335     0.200
     0.303     7.328     0.200
     0.515    10.703     0.200
     0.739    14.594     0.200
     1.172    21.797     0.200
     1.226    22.758     0.200
     2.204    38.164     0.200
     2.624    47.336     0.200
     2.724    47.625     0.200
     2.772    49.414     0.200
     2.983    50.828     0.200
     3.127    55.555     0.200
     3.179    55.281     0.200
     3.179    54.383     0.200
     0.264     8.141     0.200
     1.378    24.491     0.200
     1.378    24.671     0.200
     2.625    47.251     0.200
     2.749    49.471     0.200
     3.573    61.031     0.200
     3.574    61.031     0.200
     5.089    90.691     0.200
     6.027   103.531     0.200
     6.205   104.901     0.200
     0.237     6.957     0.200
     0.424     9.770     0.200
     0.464    10.309     0.200
     1.586    27.730     0.200
     1.586    28.059     0.200
     1.584    27.969     0.200
     1.702    29.719     0.200
     2.563    43.020     0.200
     2.948    50.320     0.200
     4.970    85.727     0.200
     0.275     7.902     0.200
     0.341     8.562     0.200
     0.499    10.582     0.200
     0.850    16.023     0.200
     0.845    15.895     0.200
     1.325    23.312     0.200
     1.364    24.875     0.200
     1.364    24.473     0.200
     1.871    32.285     0.200
     2.163    37.105     0.200
     2.201    37.445     0.200
     2.218    38.285     0.200
     2.272    39.504     0.200
     2.277    39.832     0.200
     2.307    41.094     0.200
     2.309    40.414     0.200
     2.334    41.414     0.200
     2.352    41.172     0.200
     2.356    39.824     0.200
     2.373    41.434     0.200
     2.440    41.863     0.200
     2.449    42.273     0.200
     2.489    44.715     0.200
     2.575    43.812     0.200
     2.815    48.695     0.200
     2.850    47.203     0.200
     2.844    48.973     0.200
     0.252     7.430     0.200
     0.415     9.586     0.200
     0.479    10.539     0.200
     0.905    17.719     0.200
     1.114    20.141     0.200
     1.408    25.352     0.200
     1.578    27.828     0.200
     1.920    33.078     0.200
     2.224    41.398     0.200
     2.410    40.625     0.200
     2.516    43.922     0.200
     2.568    43.875     0.200
     2.568    43.484     0.200
     2.567    43.938     0.200
     2.595    43.938     0.200
     2.634    44.797     0.200
     2.973    51.672     0.200
     3.115    54.938     0.200
     0.331     8.039     0.200
     0.788    15.539     0.200
     1.003    18.852     0.200
     1.210    22.023     0.200
     1.244    22.633     0.200
     0.210     7.570     0.200
     0.209     7.500     0.200
     0.589    12.672     0.200
     0.879    16.980     0.200
     1.029    18.910     0.200
     1.160    20.680     0.200
     1.322    23.762     0.200
     1.514    26.191     0.200
     1.606    28.059     0.200
     2.082    35.449     0.200
     2.176    36.820     0.200
     2.192    37.000     0.200
     2.363    40.051     0.200
     2.427    41.891     0.200
     2.581    43.180     0.200
     2.853    48.680     0.200
     0.289     6.357     0.200
     0.307     6.627     0.200
     0.465     8.977     0.200
     0.869    16.738     0.200
     1.380    24.127     0.200
     1.935    34.348     0.200
     2.109    37.068     0.200
     2.210    38.688     0.200
     2.196    38.238     0.200
     2.257    39.508     0.200
     2.270    39.848     0.200
     2.309    41.078     0.200
     2.330    40.838     0.200
     2.331    42.287     0.200
     2.353    40.758     0.200
     2.361    41.988     0.200
     2.351    41.238     0.200
     2.327    41.707     0.200
     2.404    44.137     0.200
     2.413    41.908     0.200
     2.427    43.727     0.200
     2.495    42.848     0.200
     2.630    46.797     0.200
     2.672    48.037     0.200
     2.835    49.027     0.200
     2.888    49.248     0.200
     2.907    52.607     0.200
     2.909    52.148     0.200
     3.439    60.938     0.200
     3.771    67.697     0.200
     3.815    67.527     0.200
     4.355    72.768     0.200
     0.148     6.814     0.200
     0.181     7.113     0.200
     0.635    12.943     0.200
     0.935    17.844     0.200
     1.047    19.314     0.200
     1.372    24.074     0.200
     1.571    27.443     0.200
     1.668    28.684     0.200
     2.399    41.074     0.200
     2.584    45.494     0.200
     0.228     7.832     0.200
     0.309     8.723     0.200
     0.480    10.914     0.200
     0.844    16.582     0.200
     1.051    18.875     0.200
     1.080    19.875     0.200
     1.302    23.605     0.200
     1.410    24.773     0.200
     1.512    26.355     0.200
     1.825    30.973     0.200
     2.173    36.832     0.200
     2.253    38.074     0.200
     2.544    42.855     0.200
     2.652    43.895     0.200
     0.364     7.484     0.200
     0.481     8.855     0.200
     1.037    19.125     0.200
     1.300    24.516     0.200
     1.765    32.387     0.200
     1.866    34.484     0.200
     1.896    34.504     0.200
     2.026    36.305     0.200
     2.302    41.297     0.200
     2.312    42.676     0.200
     2.546    45.664     0.200
     2.547    44.426     0.200
     2.610    45.617     0.200
     2.753    48.484     0.200
     2.759    48.637     0.200
     2.831    50.906     0.200
     3.260    55.566     0.200
     0.307     8.496     0.200
     0.375     9.328     0.200
     0.499    11.156     0.200
     0.769    15.258     0.200
     1.149    20.926     0.200
     1.244    22.738     0.200
     1.332    23.789     0.200
     1.788    30.789     0.200
     2.079    35.969     0.200
     2.120    36.617     0.200
     2.136    36.238     0.200
     2.165    36.488     0.200
     2.195    37.766     0.200
     2.225    37.668     0.200
     2.226    38.008     0.200
     2.268    38.977     0.200
     2.761    45.699     0.200
     0.420     9.109     0.200
     0.492     9.656     0.200
     0.900    16.418     0.200
     1.131    21.066     0.200
     1.412    24.969     0.200
     1.429    25.387     0.200
     1.585    28.488     0.200
     1.585    27.746     0.200
     1.604    28.449     0.200
     2.144    38.148     0.200
     2.427    41.770     0.200
     2.481    43.180     0.200
     2.492    42.078     0.200
     2.554    44.277     0.200
     2.613    44.379     0.200
     2.629    45.539     0.200
     2.638    47.430     0.200
     2.650    45.227     0.200
     2.720    46.637     0.200
     2.854    48.367     0.200
     3.178    53.188     0.200
     0.363     8.625     0.200
     1.049    19.148     0.200
     3.592    60.312     0.200
     1.326    24.414     0.200
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthin,green << EOF
    20.830   520.172     0.200
    24.130   590.512     0.200
     1.512    47.375     0.200
     2.425    70.355     0.200
     2.492    71.865     0.200
     2.665    75.875     0.200
     2.759    78.615     0.200
     2.878    81.925     0.200
     2.903    82.955     0.200
     3.215    89.835     0.200
     3.224    91.615     0.200
     4.010   109.436     0.200
     4.192   112.646     0.200
     5.510   152.665     0.200
     7.657   202.075     0.200
     7.810   208.115     0.200
     0.308    14.676     0.200
     0.729    23.215     0.200
     0.979    29.555     0.200
     2.435    68.926     0.200
     2.495    69.795     0.200
     2.495    72.496     0.200
     3.612    99.975     0.200
     4.851   130.564     0.200
     1.163    34.104     0.200
     2.252    63.273     0.200
     2.284    63.533     0.200
     2.479    69.152     0.200
     2.511    70.562     0.200
     2.590    72.514     0.200
     3.064    85.812     0.200
     3.077    81.242     0.200
     3.308    89.732     0.200
     3.432    93.082     0.200
     4.287   113.434     0.200
     4.469   119.662     0.200
     5.030   130.973     0.200
     5.198   136.924     0.200
     5.513   149.223     0.200
     5.683   148.273     0.200
     7.894   203.094     0.200
     8.259   217.613     0.200
     8.862   228.312     0.200
    19.760   489.514     0.200
     0.158    11.428     0.200
     0.969    31.268     0.200
     1.181    36.178     0.200
     1.407    42.658     0.200
     2.025    58.736     0.200
     2.233    61.367     0.200
     2.283    64.637     0.200
     2.369    69.518     0.200
     2.444    69.307     0.200
     2.464    68.938     0.200
     2.508    71.828     0.200
     2.602    72.217     0.200
     3.051    83.168     0.200
     3.095    83.527     0.200
     3.307    90.137     0.200
     3.414    91.338     0.200
     3.423    90.117     0.200
     4.268   111.508     0.200
     5.049   133.438     0.200
     5.181   132.387     0.200
     5.181   135.688     0.200
    11.783   297.188     0.200
    19.745   490.197     0.200
    22.254   545.498     0.200
     1.064    34.627     0.200
     1.987    56.596     0.200
     2.523    71.156     0.200
     2.780    78.156     0.200
     2.926    81.756     0.200
     3.236    89.537     0.200
     3.351    91.777     0.200
     4.454   123.906     0.200
     1.318    38.583     0.200
     1.671    48.633     0.200
     2.143    59.513     0.200
     2.498    69.873     0.200
     2.559    71.732     0.200
     2.644    74.373     0.200
     2.682    75.933     0.200
     2.843    79.613     0.200
     2.892    79.713     0.200
     2.910    80.723     0.200
     2.946    81.713     0.200
     3.025    82.442     0.200
     3.071    85.013     0.200
     3.185    86.973     0.200
     3.217    86.503     0.200
     3.418    92.293     0.200
     3.427    91.763     0.200
     3.593    98.153     0.200
     4.170   110.843     0.200
     4.178   110.713     0.200
     5.186   130.801     0.200
     5.186   136.833     0.200
     5.198   136.473     0.200
     5.748   149.383     0.200
     6.219   161.703     0.200
     8.000   206.683     0.200
    11.873   292.812     0.200
    11.873   297.843     0.200
     1.939    55.078     0.200
     3.412    93.617     0.200
     3.854   102.625     0.200
     4.487   116.508     0.200
     4.607   122.957     0.200
     4.763   125.285     0.200
     5.805   151.887     0.200
     6.175   162.926     0.200
     6.240   162.566     0.200
    11.206   278.305     0.200
     0.294    15.016     0.200
     0.584    20.594     0.200
     1.350    40.305     0.200
     1.625    46.148     0.200
     1.799    50.523     0.200
     1.846    53.164     0.200
     1.916    54.805     0.200
     2.123    60.344     0.200
     2.193    62.555     0.200
     2.397    67.258     0.200
     2.539    70.625     0.200
     2.638    73.570     0.200
     2.791    75.969     0.200
     2.798    75.188     0.200
     3.654    96.156     0.200
     3.709    97.578     0.200
     4.434   116.430     0.200
     4.567   120.336     0.200
     4.567   119.422     0.200
     4.601   120.766     0.200
     6.053   156.938     0.200
     6.273   162.719     0.200
     6.264   162.227     0.200
     7.254   187.797     0.200
     7.767   200.586     0.200
    11.229   283.219     0.200
     1.138    37.051     0.200
     1.270    40.562     0.200
     1.948    54.492     0.200
     4.219   111.500     0.200
     4.541   122.141     0.200
     6.572   177.699     0.200
    11.290   280.918     0.200
    11.290   284.129     0.200
    13.637   340.051     0.200
    15.269   380.281     0.200
     1.429    41.910     0.200
     2.139    59.461     0.200
     2.143    61.051     0.200
     2.318    65.391     0.200
     2.487    69.473     0.200
     2.617    73.641     0.200
     2.694    70.793     0.200
     2.756    75.000     0.200
     3.713   100.191     0.200
     3.768    99.789     0.200
     4.607   119.242     0.200
     5.500   142.582     0.200
     6.546   167.902     0.200
    10.576   263.445     0.200
    10.576   264.211     0.200
    13.444   336.883     0.200
    14.548   364.324     0.200
     0.650    22.680     0.200
     1.332    39.625     0.200
     1.505    43.805     0.200
     1.910    54.445     0.200
     2.008    57.539     0.200
     2.751    75.367     0.200
     3.139    83.250     0.200
     4.158   111.680     0.200
     6.246   157.352     0.200
     6.216   161.961     0.200
    11.236   279.180     0.200
     1.488    45.668     0.200
     1.562    47.678     0.200
     2.021    58.458     0.200
     1.985    58.138     0.200
     2.087    61.098     0.200
     2.296    65.798     0.200
     2.603    73.428     0.200
     2.735    76.768     0.200
     1.217    38.059     0.200
     1.217    37.820     0.200
     1.353    41.309     0.200
     1.935    54.930     0.200
     2.269    63.660     0.200
     2.273    65.430     0.200
     2.542    72.102     0.200
     2.727    77.668     0.200
     3.212    84.270     0.200
     3.537    96.789     0.200
     4.174   113.410     0.200
     4.179   111.418     0.200
     4.969   131.961     0.200
     2.020    58.484     0.200
     2.020    56.977     0.200
     4.124   114.426     0.200
     4.442   120.352     0.200
    11.187   283.324     0.200
     1.914    55.316     0.200
     1.914    53.098     0.200
     2.805    78.047     0.200
     4.570   121.367     0.200
     9.015   225.898     0.200
    11.315   283.047     0.200
     1.937    55.742     0.200
     5.001   128.445     0.200
    11.719   299.848     0.200
     0.292    15.695     0.200
     0.292    15.555     0.200
     0.397    17.109     0.200
     0.397    16.930     0.200
     0.827    26.672     0.200
     0.791    26.109     0.200
     1.197    36.602     0.200
     1.268    38.305     0.200
     1.268    39.289     0.200
     1.400    39.602     0.200
     1.839    50.352     0.200
     1.816    54.352     0.200
     2.019    57.664     0.200
     3.494    92.000     0.200
    12.601   320.453     0.200
     1.621    46.617     0.200
     1.822    50.309     0.200
     3.662    95.738     0.200
     3.729   100.266     0.200
     3.990   109.906     0.200
     4.438   123.496     0.200
     4.704   122.758     0.200
     6.318   166.715     0.200
     0.087    11.270     0.200
     0.087    11.137     0.200
     0.514    19.066     0.200
     0.863    26.777     0.200
     1.062    31.969     0.200
     1.062    33.289     0.200
     1.217    36.906     0.200
     1.338    39.598     0.200
     1.345    39.156     0.200
     1.675    47.238     0.200
     1.743    49.078     0.200
     1.896    52.930     0.200
     1.896    54.930     0.200
     1.990    56.148     0.200
     2.251    62.879     0.200
     2.364    71.098     0.200
     2.742    79.488     0.200
     3.286    87.977     0.200
     3.655    98.699     0.200
     3.683    98.707     0.200
     3.969   105.328     0.200
     4.314   113.750     0.200
     4.394   115.977     0.200
     4.554   120.008     0.200
     5.481   144.289     0.200
     5.598   145.340     0.200
     0.406    16.562     0.200
     0.697    24.070     0.200
     0.710    24.031     0.200
     0.920    29.391     0.200
     0.924    30.266     0.200
     1.152    37.625     0.200
     1.286    37.500     0.200
     1.392    44.102     0.200
     1.948    55.266     0.200
     1.917    56.680     0.200
     2.078    59.555     0.200
     2.112    60.070     0.200
     2.097    61.133     0.200
     2.117    62.133     0.200
     2.675    70.805     0.200
     3.345    90.281     0.200
     3.469    95.305     0.200
     3.872   101.555     0.200
     3.878   107.719     0.200
     4.422   116.883     0.200
     4.435   118.133     0.200
     5.019   136.844     0.200
     5.049   135.680     0.200
     5.561   147.656     0.200
     5.617   143.766     0.200
     7.640   192.695     0.200
     7.935   202.703     0.200
     8.364   212.109     0.200
     9.394   242.109     0.200
    10.070   256.086     0.200
    10.969   275.375     0.200
    13.836   349.445     0.200
    19.154   478.984     0.200
    19.545   486.133     0.200
    20.516   509.562     0.200
    20.696   510.641     0.200
    21.518   528.945     0.200
    21.520   526.500     0.200
    21.572   529.594     0.200
    22.023   538.969     0.200
    22.040   537.984     0.200
    22.040   539.883     0.200
     0.302    16.086     0.200
     0.423    18.684     0.200
     0.633    22.215     0.200
     0.862    27.055     0.200
     0.865    27.363     0.200
     0.986    31.426     0.200
     1.091    33.254     0.200
     1.119    33.453     0.200
     1.157    36.465     0.200
     1.257    37.664     0.200
     1.277    38.004     0.200
     1.455    42.297     0.200
     1.603    44.234     0.200
     1.933    53.613     0.200
     1.970    54.965     0.200
     2.017    56.023     0.200
     2.400    64.297     0.200
     2.675    70.945     0.200
     3.701    97.395     0.200
     8.200   206.227     0.200
     0.101    13.024     0.200
     0.370    16.944     0.200
     0.540    20.194     0.200
     0.672    22.654     0.200
     0.840    26.975     0.200
     0.904    29.205     0.200
     1.304    38.754     0.200
     1.405    41.875     0.200
     1.595    46.245     0.200
     1.728    49.504     0.200
     1.832    51.924     0.200
     1.839    52.765     0.200
     1.887    51.615     0.200
     1.866    54.765     0.200
     1.947    54.714     0.200
     2.152    61.234     0.200
     2.191    63.805     0.200
     2.200    61.135     0.200
     2.282    67.935     0.200
     2.287    64.964     0.200
     2.390    68.225     0.200
     2.558    67.584     0.200
     3.566    90.654     0.200
     3.566    90.825     0.200
     3.648    95.095     0.200
     3.797    96.455     0.200
     4.442   117.595     0.200
     4.478   115.984     0.200
     4.615   119.544     0.200
     0.291    15.102     0.200
     0.288    15.047     0.200
     0.371    16.422     0.200
     0.251    14.516     0.200
     0.401    16.992     0.200
     0.939    29.805     0.200
     1.182    35.422     0.200
     1.329    40.734     0.200
     1.346    41.086     0.200
     1.453    43.031     0.200
     1.543    47.117     0.200
     1.457    43.641     0.200
     1.457    43.992     0.200
     1.766    52.562     0.200
     1.903    56.422     0.200
     2.162    60.367     0.200
     2.226    63.727     0.200
     2.223    62.984     0.200
     2.276    61.461     0.200
     2.371    70.164     0.200
     2.383    67.266     0.200
     2.620    75.266     0.200
     4.068   107.133     0.200
     4.912   127.242     0.200
     1.189    36.559     0.200
     1.222    38.238     0.200
     1.295    41.518     0.200
     1.675    49.248     0.200
     1.686    48.898     0.200
     1.724    49.848     0.200
     2.617    73.078     0.200
     2.754    74.979     0.200
     3.280    92.328     0.200
     4.047   103.457     0.200
     4.736   131.668     0.200
     4.832   132.059     0.200
     4.853   132.447     0.200
     4.889   131.988     0.200
     4.966   132.068     0.200
     6.468   174.828     0.200
     8.148   214.688     0.200
     0.171    12.988     0.200
     0.204    13.188     0.200
     0.463    18.258     0.200
     0.484    18.639     0.200
     0.576    20.598     0.200
     0.911    28.719     0.200
     1.069    33.008     0.200
     1.253    37.129     0.200
     1.357    40.328     0.200
     1.515    44.607     0.200
     1.616    46.518     0.200
     1.683    49.408     0.200
     1.687    49.178     0.200
     1.867    53.428     0.200
     1.973    55.078     0.200
     2.107    58.479     0.200
     2.122    61.158     0.200
     2.163    59.889     0.200
     2.214    61.328     0.200
     2.215    63.389     0.200
     2.229    62.188     0.200
     2.283    65.148     0.200
     2.345    64.588     0.200
     2.343    65.607     0.200
     2.386    66.178     0.200
     2.399    67.789     0.200
     2.458    68.299     0.200
     2.500    68.348     0.200
     2.521    70.607     0.200
     2.560    68.988     0.200
     2.582    69.857     0.200
     2.590    71.959     0.200
     2.619    71.498     0.200
     2.771    76.197     0.200
     2.816    80.139     0.200
     2.889    79.209     0.200
     2.975    81.027     0.200
     3.166    84.229     0.200
     3.183    83.549     0.200
     3.336    88.469     0.200
     3.836   103.828     0.200
     3.857   102.768     0.200
     3.920   104.729     0.200
     3.925   104.527     0.200
     3.932   106.578     0.200
     3.953   107.098     0.200
     3.995   105.768     0.200
     4.197   105.658     0.200
     4.245   110.648     0.200
     5.102   130.129     0.200
     0.477    19.354     0.200
     0.664    23.812     0.200
     1.110    33.662     0.200
     1.275    38.633     0.200
     1.275    37.252     0.200
     1.397    41.604     0.200
     1.399    41.523     0.200
     1.379    41.143     0.200
     1.519    45.062     0.200
     1.690    47.312     0.200
     1.801    51.832     0.200
     1.724    50.143     0.200
     1.930    54.773     0.200
     1.920    56.094     0.200
     1.960    54.992     0.200
     2.047    57.742     0.200
     2.135    60.963     0.200
     2.266    66.514     0.200
     2.263    67.443     0.200
     2.172    61.514     0.200
     2.286    65.662     0.200
     2.309    65.662     0.200
     2.299    64.094     0.200
     2.317    63.502     0.200
     2.317    63.502     0.200
     2.316    70.232     0.200
     2.362    64.953     0.200
     2.375    65.543     0.200
     2.375    64.742     0.200
     2.375    65.543     0.200
     2.375    67.672     0.200
     2.384    65.822     0.200
     2.411    67.912     0.200
     2.445    66.713     0.200
     2.505    69.303     0.200
     2.533    69.672     0.200
     2.548    71.422     0.200
     2.644    74.422     0.200
     2.690    71.232     0.200
     2.738    79.514     0.200
     2.710    70.893     0.200
     2.798    78.242     0.200
     2.907    79.383     0.200
     2.906    79.383     0.200
     2.915    79.293     0.200
     2.976    77.822     0.200
     3.143    84.523     0.200
     3.148    87.184     0.200
     3.248    88.562     0.200
     3.347    95.264     0.200
     3.638    98.514     0.200
     3.730   101.844     0.200
     3.766   105.113     0.200
     3.726    94.672     0.200
     3.854   100.943     0.200
     4.174   110.492     0.200
     4.308   114.502     0.200
     4.392   114.973     0.200
     4.399   117.363     0.200
     4.419   120.703     0.200
     4.438   118.783     0.200
     4.469   116.184     0.200
     4.546   118.553     0.200
     4.684   125.143     0.200
     4.675   120.229     0.200
     4.675   121.502     0.200
     4.854   132.062     0.200
     5.226   138.002     0.200
     5.386   139.094     0.200
     5.513   146.514     0.200
     5.588   146.322     0.200
     6.030   157.953     0.200
     6.305   164.652     0.200
     6.369   168.752     0.200
     6.422   162.582     0.200
     7.486   191.053     0.200
     7.519   195.002     0.200
     7.609   193.002     0.200
     7.854   199.533     0.200
     9.560   246.594     0.200
     1.129    36.711     0.200
     1.145    35.430     0.200
     1.347    42.270     0.200
     1.571    45.230     0.200
     1.660    48.961     0.200
     1.864    53.961     0.200
     2.476    68.320     0.200
     2.491    66.141     0.200
     2.500    71.051     0.200
     2.500    71.051     0.200
     2.519    70.820     0.200
     2.584    70.059     0.200
     2.526    69.262     0.200
     2.574    72.859     0.200
     2.588    73.840     0.200
     2.588    73.840     0.200
     2.701    75.699     0.200
     2.747    76.609     0.200
     2.760    78.672     0.200
     2.775    78.602     0.200
     2.849    80.148     0.200
     2.870    79.691     0.200
     2.869    79.691     0.200
     2.857    79.941     0.200
     2.969    81.770     0.200
     3.091    84.961     0.200
     3.107    87.949     0.200
     3.206    88.012     0.200
     3.456    93.930     0.200
     3.607    93.621     0.200
     3.562    98.160     0.200
     3.563    98.160     0.200
     3.775   102.551     0.200
     3.853   103.320     0.200
     3.933   108.852     0.200
     4.289   117.391     0.200
     4.473   116.988     0.200
     4.565   124.148     0.200
     4.569   122.539     0.200
     4.575   126.219     0.200
     4.597   117.809     0.200
     4.621   120.969     0.200
     4.635   120.930     0.200
     4.635   124.582     0.200
     4.707   126.359     0.200
     4.718   129.832     0.200
     4.842   130.172     0.200
     5.355   145.660     0.200
     5.378   148.199     0.200
     5.743   148.680     0.200
     6.226   165.750     0.200
     6.277   170.582     0.200
     6.316   166.969     0.200
     6.331   158.699     0.200
     6.536   176.551     0.200
     7.285   193.891     0.200
     7.384   185.441     0.200
     7.420   188.379     0.200
     7.507   192.750     0.200
     1.453    47.340     0.200
     1.482    46.242     0.200
     2.495    71.801     0.200
     2.752    79.148     0.200
     2.793    78.332     0.200
     2.871    80.160     0.200
     2.872    80.160     0.200
     3.131    88.129     0.200
     3.336    92.891     0.200
     3.607   101.449     0.200
     3.835   103.332     0.200
     3.834   103.332     0.200
     3.814   103.309     0.200
     3.953   110.910     0.200
     4.025   108.262     0.200
     4.509   119.121     0.200
     4.806   124.582     0.200
     4.758   128.281     0.200
     5.041   140.031     0.200
     5.204   141.262     0.200
     5.289   146.691     0.200
     5.301   145.941     0.200
     5.321   147.699     0.200
     5.340   146.949     0.200
     5.355   146.949     0.200
     5.675   156.930     0.200
     6.477   175.219     0.200
     6.588   175.359     0.200
     7.118   193.379     0.200
     8.420   222.660     0.200
     1.454    42.008     0.200
     1.861    53.617     0.200
     2.283    63.516     0.200
     2.407    64.258     0.200
     2.561    71.336     0.200
     2.572    70.695     0.200
     2.814    76.875     0.200
     3.134    84.602     0.200
     3.314    91.477     0.200
     3.427    88.867     0.200
     3.559    94.508     0.200
     3.712    99.766     0.200
     4.449   115.141     0.200
     4.870   125.758     0.200
     0.282    15.496     0.200
     0.353    16.734     0.200
     0.594    21.453     0.200
     0.649    23.047     0.200
     0.745    25.176     0.200
     0.771    24.887     0.200
     0.980    31.934     0.200
     1.118    34.477     0.200
     1.243    35.094     0.200
     1.228    37.695     0.200
     1.303    38.625     0.200
     1.582    47.504     0.200
     1.636    47.855     0.200
     1.647    47.496     0.200
     1.786    51.023     0.200
     1.808    51.734     0.200
     1.792    50.773     0.200
     1.803    52.184     0.200
     1.807    51.766     0.200
     1.892    55.105     0.200
     2.040    59.887     0.200
     2.103    60.934     0.200
     2.120    60.727     0.200
     2.129    61.547     0.200
     2.144    62.926     0.200
     2.142    63.363     0.200
     2.524    72.703     0.200
     2.643    73.805     0.200
     2.796    77.145     0.200
     3.588    98.734     0.200
     3.721    97.496     0.200
     4.563   118.547     0.200
     1.268    39.484     0.200
     1.245    38.515     0.200
     1.313    41.585     0.200
     1.427    45.814     0.200
     1.427    43.814     0.200
     1.724    50.375     0.200
     1.925    53.885     0.200
     1.971    57.484     0.200
     2.130    59.494     0.200
     2.328    66.055     0.200
     2.323    65.755     0.200
     2.594    72.045     0.200
     2.679    76.204     0.200
     3.347    89.904     0.200
     3.701   101.704     0.200
     3.657   102.034     0.200
     4.040   104.135     0.200
     4.129   114.085     0.200
     4.206   117.654     0.200
     4.437   122.185     0.200
     4.549   126.635     0.200
     4.652   122.244     0.200
     5.954   162.755     0.200
     6.079   156.085     0.200
     6.743   179.734     0.200
     7.164   191.015     0.200
     7.251   186.694     0.200
    11.197   279.063     0.200
     1.009    30.672     0.200
     1.391    40.410     0.200
     1.488    42.531     0.200
     2.027    55.051     0.200
     2.206    61.973     0.200
     2.289    65.223     0.200
     2.339    65.102     0.200
     2.442    68.133     0.200
     2.790    77.512     0.200
     3.009    83.441     0.200
     3.046    78.762     0.200
     3.967   107.012     0.200
     4.059   109.043     0.200
     4.206   113.113     0.200
     0.142    13.514     0.200
     0.281    15.225     0.200
     0.349    16.363     0.200
     0.576    20.734     0.200
     0.724    24.584     0.200
     0.762    25.795     0.200
     1.000    31.244     0.200
     1.133    33.625     0.200
     1.240    38.254     0.200
     1.235    38.014     0.200
     1.283    38.844     0.200
     1.560    44.404     0.200
     1.670    46.545     0.200
     1.650    47.244     0.200
     1.764    48.514     0.200
     1.793    52.955     0.200
     1.788    50.104     0.200
     1.794    53.914     0.200
     1.827    52.295     0.200
     1.907    53.564     0.200
     2.097    57.205     0.200
     2.121    59.805     0.200
     2.125    59.805     0.200
     2.135    60.104     0.200
     2.136    61.154     0.200
     2.142    61.443     0.200
     2.147    60.635     0.200
     2.207    62.174     0.200
     2.219    64.154     0.200
     2.240    60.844     0.200
     2.278    62.504     0.200
     2.336    63.295     0.200
     2.380    66.434     0.200
     2.477    69.514     0.200
     2.536    69.875     0.200
     2.687    70.254     0.200
     3.181    89.684     0.200
     3.502    93.145     0.200
     3.590    96.594     0.200
     3.672    93.885     0.200
     3.739    96.975     0.200
     4.583   118.385     0.200
     1.294    39.316     0.200
     1.398    41.428     0.200
     1.747    50.857     0.200
     1.900    54.957     0.200
     2.253    63.387     0.200
     2.359    67.107     0.200
     2.415    68.258     0.200
     2.597    70.377     0.200
     2.598    73.707     0.200
     2.567    72.076     0.200
     2.615    74.486     0.200
     2.669    71.848     0.200
     2.697    70.758     0.200
     2.675    74.236     0.200
     2.699    75.396     0.200
     2.710    76.666     0.200
     2.739    73.406     0.200
     2.755    75.957     0.200
     2.769    76.146     0.200
     2.768    77.816     0.200
     2.768    77.816     0.200
     2.782    77.527     0.200
     2.785    75.896     0.200
     2.755    77.217     0.200
     2.818    78.428     0.200
     2.850    77.496     0.200
     2.903    79.646     0.200
     2.922    80.697     0.200
     2.918    78.688     0.200
     2.978    83.457     0.200
     2.974    83.336     0.200
     3.041    85.008     0.200
     3.129    88.166     0.200
     3.121    81.326     0.200
     3.199    88.107     0.200
     3.262    90.066     0.200
     3.297    91.047     0.200
     3.426    93.947     0.200
     3.536    97.137     0.200
     3.536    97.137     0.200
     3.544    92.877     0.200
     3.564    94.107     0.200
     3.650    98.896     0.200
     3.651    98.896     0.200
     3.733   100.336     0.200
     3.861   100.736     0.200
     3.950   108.137     0.200
     3.979   108.076     0.200
     3.979   108.598     0.200
     3.984   102.986     0.200
     3.985   104.797     0.200
     4.001   108.727     0.200
     4.010   105.826     0.200
     4.028   108.787     0.200
     3.979   109.297     0.200
     4.084   106.406     0.200
     4.239   116.207     0.200
     4.261   111.467     0.200
     4.492   120.906     0.200
     4.582   126.057     0.200
     4.744   129.688     0.200
     4.740   125.777     0.200
     4.742   130.287     0.200
     4.971   133.697     0.200
     4.999   133.996     0.200
     5.108   135.727     0.200
     5.304   139.896     0.200
     5.317   140.586     0.200
     5.391   145.326     0.200
     5.572   147.496     0.200
     5.683   151.258     0.200
     5.719   152.826     0.200
     5.841   157.957     0.200
     6.019   158.666     0.200
     6.199   163.598     0.200
     6.270   160.916     0.200
     6.992   185.617     0.200
     8.439   216.246     0.200
     9.035   230.297     0.200
     9.355   237.877     0.200
    20.240   507.820     0.200
    20.532   511.475     0.200
    21.657   534.105     0.200
    21.708   536.463     0.200
     0.735    23.469     0.200
     1.240    36.594     0.200
     1.422    41.430     0.200
     1.450    41.789     0.200
     1.753    47.516     0.200
     1.672    48.633     0.200
     1.951    54.773     0.200
     2.053    57.039     0.200
     2.018    55.406     0.200
     2.107    57.508     0.200
     2.192    60.906     0.200
     2.236    61.625     0.200
     2.470    67.117     0.200
     2.514    70.695     0.200
     2.770    71.664     0.200
     2.842    77.688     0.200
     2.942    80.773     0.200
     3.018    80.055     0.200
     3.036    84.609     0.200
     3.484    94.375     0.200
     3.584    94.938     0.200
     3.791    96.445     0.200
     4.077   111.875     0.200
     4.824   124.195     0.200
     5.549   148.164     0.200
     6.033   158.938     0.200
     6.369   168.062     0.200
     6.505   165.539     0.200
     0.617    21.352     0.200
     0.560    20.352     0.200
     4.357   112.773     0.200
     0.220    13.609     0.200
     0.479    17.770     0.200
     0.606    21.117     0.200
     0.765    24.578     0.200
     0.828    27.520     0.200
     1.013    32.879     0.200
     1.141    34.648     0.200
     1.243    38.188     0.200
     1.291    39.078     0.200
     1.417    42.609     0.200
     1.468    43.520     0.200
     1.920    55.957     0.200
     2.026    56.207     0.200
     2.157    64.738     0.200
     2.168    63.047     0.200
     2.199    64.668     0.200
     2.240    66.570     0.200
     2.196    61.098     0.200
     3.029    78.180     0.200
     3.213    85.957     0.200
     3.174    85.688     0.200
     3.419    92.648     0.200
     3.720   100.898     0.200
     4.049   105.598     0.200
     4.337   112.449     0.200
     5.706   143.777     0.200
     0.394    18.383     0.200
     0.640    23.133     0.200
     0.788    26.719     0.200
     0.935    30.711     0.200
     1.071    33.242     0.200
     1.071    33.000     0.200
     1.182    36.859     0.200
     1.223    35.883     0.200
     1.311    39.773     0.200
     1.590    47.031     0.200
     1.616    47.844     0.200
     1.621    49.250     0.200
     1.763    50.453     0.200
     1.783    52.312     0.200
     1.763    50.664     0.200
     1.845    54.422     0.200
     1.825    52.008     0.200
     2.043    58.938     0.200
     2.077    59.414     0.200
     1.999    56.578     0.200
     2.101    60.594     0.200
     2.107    62.258     0.200
     2.108    62.258     0.200
     2.107    60.312     0.200
     2.126    60.547     0.200
     2.123    61.453     0.200
     2.189    64.352     0.200
     2.189    61.617     0.200
     2.204    63.117     0.200
     2.214    64.094     0.200
     2.216    62.164     0.200
     2.235    63.844     0.200
     2.258    65.852     0.200
     2.261    64.328     0.200
     2.287    64.211     0.200
     2.316    64.000     0.200
     2.339    63.570     0.200
     2.348    66.000     0.200
     2.250    67.609     0.200
     2.477    68.547     0.200
     2.597    74.102     0.200
     2.707    78.508     0.200
     2.752    74.078     0.200
     2.752    74.078     0.200
     2.761    71.672     0.200
     2.781    72.961     0.200
     2.927    80.023     0.200
     2.912    78.469     0.200
     3.047    86.891     0.200
     3.164    85.188     0.200
     3.163    85.188     0.200
     3.242    89.000     0.200
     3.675    97.188     0.200
     3.636    93.070     0.200
     3.731    99.281     0.200
     3.955   108.938     0.200
     4.365   115.148     0.200
     4.488   115.414     0.200
     4.427   115.711     0.200
     4.435   117.203     0.200
     4.443   117.641     0.200
     4.460   118.852     0.200
     4.480   117.859     0.200
     4.519   118.984     0.200
     4.519   114.578     0.200
     4.491   119.867     0.200
     4.543   116.508     0.200
     4.602   121.188     0.200
     4.706   128.070     0.200
     5.223   132.703     0.200
     5.299   134.961     0.200
     5.443   144.047     0.200
     5.657   146.914     0.200
     6.041   158.680     0.200
     6.303   158.680     0.200
     6.623   170.969     0.200
     7.214   182.211     0.200
     7.375   185.172     0.200
     7.406   188.570     0.200
     7.410   191.484     0.200
     8.210   208.547     0.200
    11.162   276.312     0.200
     0.089    11.922     0.200
     0.290    14.441     0.200
     0.662    22.773     0.200
     0.784    25.293     0.200
     0.840    28.141     0.200
     0.976    30.152     0.200
     1.046    32.551     0.200
     1.352    39.441     0.200
     1.391    42.281     0.200
     1.490    39.871     0.200
     1.612    48.320     0.200
     1.785    50.844     0.200
     1.839    53.562     0.200
     2.014    57.551     0.200
     2.215    64.570     0.200
     2.260    62.012     0.200
     2.372    67.172     0.200
     2.384    64.242     0.200
     2.384    67.012     0.200
     2.426    68.613     0.200
     2.436    69.621     0.200
     2.445    66.781     0.200
     2.548    69.703     0.200
     2.782    75.973     0.200
     3.716   100.031     0.200
     3.727    96.070     0.200
     3.748   102.383     0.200
     3.865   101.711     0.200
     4.423   112.070     0.200
     0.371    17.807     0.200
     0.413    17.387     0.200
     0.587    21.457     0.200
     0.647    22.758     0.200
     0.834    27.338     0.200
     0.989    31.057     0.200
     1.124    34.057     0.200
     1.183    35.867     0.200
     1.228    37.297     0.200
     1.358    40.748     0.200
     1.388    41.887     0.200
     1.453    44.238     0.200
     1.711    50.758     0.200
     1.753    51.107     0.200
     1.933    55.768     0.200
     1.934    53.547     0.200
     1.934    55.818     0.200
     1.971    54.588     0.200
     1.971    56.197     0.200
     1.996    56.998     0.200
     2.086    59.797     0.200
     2.090    61.127     0.200
     2.101    61.768     0.200
     2.122    59.287     0.200
     2.131    60.768     0.200
     2.142    60.598     0.200
     2.172    60.738     0.200
     2.209    63.887     0.200
     2.200    61.898     0.200
     2.203    62.479     0.200
     2.261    64.127     0.200
     2.329    65.418     0.200
     3.184    90.488     0.200
     4.945   130.268     0.200
     4.959   129.348     0.200
     0.850    28.463     0.200
     2.196    62.873     0.200
     2.222    63.104     0.200
     2.243    61.814     0.200
     2.362    65.234     0.200
     2.362    65.564     0.200
     2.393    67.994     0.200
     2.434    67.594     0.200
     2.508    70.703     0.200
     2.803    78.043     0.200
     2.829    76.895     0.200
     2.850    79.504     0.200
     3.150    86.914     0.200
     3.179    86.904     0.200
     3.258    88.953     0.200
     3.780   100.094     0.200
     4.008   100.354     0.200
     4.069   108.084     0.200
     4.110   112.293     0.200
     4.130   112.674     0.200
     4.182   111.734     0.200
     4.260   115.135     0.200
     4.695   127.453     0.200
     4.868   127.193     0.200
     4.939   131.764     0.200
     5.268   144.193     0.200
     5.621   144.984     0.200
     5.746   154.543     0.200
     6.618   174.174     0.200
     0.210    13.039     0.200
     0.226    13.203     0.200
     0.274    14.055     0.200
     0.331    15.164     0.200
     0.498    18.875     0.200
     0.873    28.898     0.200
     1.242    37.562     0.200
     1.349    38.867     0.200
     1.348    40.562     0.200
     1.378    41.438     0.200
     1.555    44.086     0.200
     1.861    50.812     0.200
     1.893    54.266     0.200
     1.934    57.258     0.200
     2.000    55.867     0.200
     2.224    64.492     0.200
     2.232    65.805     0.200
     2.241    64.969     0.200
     2.264    64.492     0.200
     2.276    66.828     0.200
     2.290    63.414     0.200
     2.292    63.359     0.200
     2.292    67.266     0.200
     2.294    66.258     0.200
     2.316    63.523     0.200
     2.314    69.492     0.200
     2.329    67.227     0.200
     2.329    67.758     0.200
     2.331    69.148     0.200
     2.356    68.219     0.200
     2.356    69.477     0.200
     2.375    67.758     0.200
     2.400    71.938     0.200
     2.463    69.375     0.200
     2.547    73.336     0.200
     2.650    76.594     0.200
     2.774    78.406     0.200
     2.832    81.984     0.200
     2.881    74.406     0.200
     3.023    87.008     0.200
     3.053    82.938     0.200
     3.054    82.938     0.200
     3.083    86.828     0.200
     3.062    81.359     0.200
     3.082    84.062     0.200
     3.776   100.859     0.200
     3.895    97.859     0.200
     3.984   103.656     0.200
     4.227   115.359     0.200
     4.265   115.664     0.200
     4.231   112.773     0.200
     4.377   116.703     0.200
     4.821   124.578     0.200
     6.163   165.258     0.200
     6.584   165.328     0.200
    11.470   286.039     0.200
     1.162    36.600     0.200
     1.197    38.418     0.200
     1.410    44.318     0.200
     1.603    45.908     0.200
     1.806    51.668     0.200
     1.992    57.299     0.200
     2.648    71.299     0.200
     2.741    77.389     0.200
     2.940    80.100     0.200
     2.940    80.100     0.200
     2.948    79.748     0.200
     2.968    82.078     0.200
     3.185    86.488     0.200
     3.418    95.008     0.200
     3.672    95.539     0.200
     3.715    96.258     0.200
     3.923   109.279     0.200
     3.977   106.238     0.200
     4.346   120.508     0.200
     4.547   119.979     0.200
     4.565   117.869     0.200
     4.566   121.199     0.200
     4.667   120.299     0.200
     4.705   128.439     0.200
     4.705   123.889     0.200
     4.786   125.539     0.200
     4.870   133.699     0.200
     5.321   137.600     0.200
     5.275   141.119     0.200
     5.686   150.988     0.200
     5.721   154.838     0.200
     6.182   167.488     0.200
     6.386   172.930     0.200
     6.398   168.389     0.200
     6.517   175.088     0.200
     7.355   193.508     0.200
     7.450   192.998     0.200
     7.486   193.479     0.200
     8.096   214.789     0.200
     9.501   242.699     0.200
     9.754   255.779     0.200
     1.797    49.703     0.200
     2.008    56.043     0.200
     2.729    75.914     0.200
     2.816    73.953     0.200
     2.852    79.633     0.200
     2.992    81.152     0.200
     3.926   102.512     0.200
     4.288   112.594     0.200
     4.308   113.984     0.200
     4.327   115.383     0.200
     4.439   117.715     0.200
     2.095    55.719     0.200
     2.493    70.102     0.200
     2.493    70.102     0.200
     3.121    80.367     0.200
     4.282   111.031     0.200
     4.239   109.086     0.200
     4.969   134.438     0.200
     6.535   174.359     0.200
     6.846   180.742     0.200
     6.907   180.367     0.200
     6.945   179.484     0.200
     6.970   185.547     0.200
     7.031   180.961     0.200
     1.421    41.900     0.200
     1.577    42.211     0.200
     1.835    52.789     0.200
     2.026    57.150     0.200
     2.128    56.801     0.200
     2.134    55.100     0.200
     2.177    56.369     0.200
     2.186    59.980     0.200
     2.206    57.279     0.200
     2.256    64.689     0.200
     2.254    62.600     0.200
     2.273    63.330     0.200
     2.321    60.930     0.200
     2.330    66.561     0.200
     2.602    69.381     0.200
     2.717    71.869     0.200
     2.806    72.449     0.200
     2.819    76.900     0.200
     2.850    77.570     0.200
     3.014    81.150     0.200
     3.043    83.340     0.200
     3.489    92.650     0.200
     3.579    99.471     0.200
     3.667    98.100     0.200
     3.715    99.930     0.200
     3.874   100.131     0.200
     3.938   104.430     0.200
     4.171   112.520     0.200
     4.252   113.439     0.200
     4.312   114.600     0.200
     4.539   125.400     0.200
     4.782   124.711     0.200
     0.297    14.617     0.200
     0.290    14.324     0.200
     0.397    16.387     0.200
     0.522    19.316     0.200
     0.760    25.535     0.200
     0.860    26.848     0.200
     1.156    36.426     0.200
     1.197    36.188     0.200
     1.559    44.766     0.200
     1.781    51.348     0.200
     1.813    51.516     0.200
     1.869    52.305     0.200
     1.822    52.234     0.200
     2.025    56.426     0.200
     2.082    58.297     0.200
     2.069    59.008     0.200
     2.080    58.875     0.200
     2.075    58.734     0.200
     2.111    59.414     0.200
     2.120    59.156     0.200
     2.129    59.816     0.200
     2.129    60.477     0.200
     2.151    59.895     0.200
     2.152    60.156     0.200
     2.176    61.945     0.200
     2.187    60.797     0.200
     2.204    61.195     0.200
     2.266    62.914     0.200
     2.282    63.234     0.200
     2.435    67.914     0.200
     2.485    68.977     0.200
     2.691    73.258     0.200
     2.752    74.855     0.200
     2.759    76.566     0.200
     2.760    75.617     0.200
     2.832    76.457     0.200
     2.888    76.695     0.200
     3.018    80.938     0.200
     3.468    91.656     0.200
     3.633    96.324     0.200
     3.667    97.516     0.200
     3.896    98.746     0.200
     3.931   101.766     0.200
     4.199   111.426     0.200
     4.218   111.637     0.200
     4.237   111.426     0.200
     4.354   114.824     0.200
     4.784   122.387     0.200
     5.486   140.098     0.200
     1.180    37.453     0.200
     2.636    74.867     0.200
     2.903    77.828     0.200
     3.047    85.195     0.200
     3.186    89.859     0.200
     3.187    89.859     0.200
     3.214    86.820     0.200
     3.229    88.586     0.200
     3.468    92.391     0.200
     3.927   100.953     0.200
     4.323   119.945     0.200
     4.435   123.109     0.200
     4.505   122.906     0.200
     5.445   149.328     0.200
     5.578   152.008     0.200
     5.671   145.797     0.200
     5.972   157.570     0.200
     6.380   172.859     0.200
     6.637   172.641     0.200
     7.609   202.328     0.200
     8.709   222.773     0.200
     1.353    40.512     0.200
     1.557    42.742     0.200
     1.875    52.553     0.200
     2.025    55.572     0.200
     2.107    60.031     0.200
     2.394    68.572     0.200
     2.362    66.312     0.200
     2.447    70.082     0.200
     2.455    68.213     0.200
     2.465    69.512     0.200
     2.481    69.852     0.200
     2.497    70.893     0.200
     2.533    71.322     0.200
     2.572    71.352     0.200
     2.603    72.963     0.200
     2.761    78.521     0.200
     2.764    78.441     0.200
     2.814    78.012     0.200
     2.890    76.553     0.200
     2.983    79.982     0.200
     3.143    87.672     0.200
     3.142    87.672     0.200
     3.151    89.082     0.200
     3.200    89.951     0.200
     3.170    84.941     0.200
     3.467    89.252     0.200
     3.808   104.691     0.200
     3.916   105.133     0.200
     3.913   100.883     0.200
     3.987   110.701     0.200
     4.103   109.553     0.200
     4.277   113.902     0.200
     4.300   113.682     0.200
     4.315   116.252     0.200
     4.319   117.361     0.200
     4.418   114.002     0.200
     4.422   119.742     0.200
     4.910   126.576     0.200
     4.910   127.633     0.200
     4.940   132.812     0.200
     5.437   138.182     0.200
     5.453   141.463     0.200
     5.625   143.762     0.200
     6.189   163.812     0.200
     6.317   168.002     0.200
     6.599   175.133     0.200
     6.630   171.723     0.200
     7.575   191.812     0.200
     7.686   192.781     0.200
     7.721   203.412     0.200
     7.809   199.072     0.200
     7.977   205.521     0.200
     8.328   212.723     0.200
     8.349   214.713     0.200
     9.534   246.002     0.200
     9.711   248.602     0.200
    11.012   277.951     0.200
    11.611   293.723     0.200
    12.560   319.223     0.200
     0.308    15.020     0.200
     0.781    25.569     0.200
     1.061    32.449     0.200
     1.017    32.080     0.200
     1.407    39.479     0.200
     1.465    41.649     0.200
     1.440    43.469     0.200
     1.778    49.799     0.200
     1.864    52.020     0.200
     1.864    51.819     0.200
     1.931    55.939     0.200
     2.088    60.589     0.200
     2.150    61.169     0.200
     2.258    64.120     0.200
     2.273    64.359     0.200
     2.280    64.549     0.200
     2.341    64.009     0.200
     2.314    64.649     0.200
     2.428    65.549     0.200
     2.357    65.159     0.200
     2.369    68.549     0.200
     2.385    65.629     0.200
     2.391    67.229     0.200
     2.401    67.199     0.200
     2.402    67.189     0.200
     2.431    68.839     0.200
     2.461    68.969     0.200
     2.461    69.159     0.200
     2.445    67.889     0.200
     2.465    68.949     0.200
     2.454    67.870     0.200
     2.502    70.080     0.200
     2.494    68.370     0.200
     2.514    70.040     0.200
     2.520    70.020     0.200
     2.521    70.020     0.200
     2.509    71.580     0.200
     2.524    71.339     0.200
     2.543    70.560     0.200
     2.606    70.330     0.200
     2.628    71.500     0.200
     2.557    73.889     0.200
     2.576    71.049     0.200
     2.613    72.449     0.200
     2.624    73.109     0.200
     2.659    73.819     0.200
     2.616    73.370     0.200
     2.850    76.339     0.200
     2.760    78.689     0.200
     2.831    76.520     0.200
     2.769    77.370     0.200
     2.879    78.939     0.200
     2.977    81.899     0.200
     2.900    79.449     0.200
     3.196    85.509     0.200
     3.372    89.659     0.200
     3.318    91.339     0.200
     3.319    91.339     0.200
     3.448    90.459     0.200
     3.601    94.399     0.200
     3.601    94.399     0.200
     3.610    94.870     0.200
     3.630    95.799     0.200
     3.556    97.339     0.200
     3.710   100.810     0.200
     3.717   101.189     0.200
     3.728   101.100     0.200
     3.735   101.029     0.200
     3.829   103.359     0.200
     3.991   108.239     0.200
     4.464   112.609     0.200
     4.500   116.689     0.200
     4.575   119.060     0.200
     4.645   126.060     0.200
     4.856   126.509     0.200
     5.270   132.580     0.200
     5.366   134.648     0.200
     5.366   138.750     0.200
     5.354   143.669     0.200
     5.839   148.520     0.200
     6.065   151.370     0.200
     7.070   180.759     0.200
     7.151   177.620     0.200
     8.065   206.020     0.200
     8.219   207.379     0.200
     8.251   208.899     0.200
     8.342   211.029     0.200
     9.898   247.879     0.200
    10.169   250.429     0.200
    10.599   269.949     0.200
    10.746   273.779     0.200
     1.269    39.445     0.200
     1.503    45.172     0.200
     1.984    53.172     0.200
     2.335    66.082     0.200
     2.491    70.414     0.200
     2.550    73.145     0.200
     2.618    68.832     0.200
     2.720    77.734     0.200
     2.715    75.605     0.200
     2.824    80.465     0.200
     2.859    80.285     0.200
     3.270    90.523     0.200
     3.297    88.484     0.200
     3.296    88.484     0.200
     3.396    95.023     0.200
     3.679    98.332     0.200
     3.679    98.332     0.200
     4.016   103.195     0.200
     4.121   111.492     0.200
     4.259   111.484     0.200
     4.272   111.414     0.200
     4.381   114.812     0.200
     4.619   125.012     0.200
     5.100   137.484     0.200
     5.062   136.902     0.200
     5.937   156.633     0.200
     6.342   163.805     0.200
     9.493   239.207     0.200
     9.579   240.992     0.200
     0.038    11.418     0.200
     0.807    25.777     0.200
     0.958    30.176     0.200
     1.133    35.258     0.200
     1.265    36.625     0.200
     1.365    39.547     0.200
     1.433    41.258     0.200
     1.555    42.395     0.200
     1.658    45.387     0.200
     1.777    52.008     0.200
     1.900    53.348     0.200
     1.926    56.695     0.200
     1.903    56.676     0.200
     1.984    56.695     0.200
     2.100    61.586     0.200
     2.154    58.867     0.200
     2.173    62.816     0.200
     2.178    63.984     0.200
     2.202    60.785     0.200
     2.217    61.297     0.200
     2.213    61.746     0.200
     2.247    62.367     0.200
     2.237    65.316     0.200
     2.265    65.535     0.200
     2.266    61.816     0.200
     2.329    67.047     0.200
     2.354    62.848     0.200
     2.401    64.574     0.200
     2.456    66.598     0.200
     2.566    71.027     0.200
     2.554    71.375     0.200
     2.598    71.125     0.200
     2.575    67.645     0.200
     2.732    76.516     0.200
     2.754    74.875     0.200
     2.844    75.258     0.200
     3.035    81.824     0.200
     3.305    89.547     0.200
     3.543    94.266     0.200
     3.587    92.234     0.200
     3.672    96.945     0.200
     3.702    96.438     0.200
     3.776    99.605     0.200
     4.536   121.938     0.200
     4.522   114.777     0.200
     4.672   120.895     0.200
     5.233   132.125     0.200
     5.718   148.324     0.200
     6.275   157.637     0.200
     1.076    34.053     0.200
     1.076    33.893     0.200
     1.352    40.112     0.200
     1.538    44.952     0.200
     1.538    44.633     0.200
     1.671    47.812     0.200
     1.781    48.232     0.200
     1.781    47.942     0.200
     2.158    60.412     0.200
     2.166    61.112     0.200
     2.210    62.213     0.200
     2.210    61.662     0.200
     2.442    69.173     0.200
     2.472    66.402     0.200
     2.468    70.412     0.200
     2.661    70.152     0.200
     2.657    74.442     0.200
     2.671    75.633     0.200
     2.710    76.442     0.200
     2.762    76.952     0.200
     2.778    78.503     0.200
     2.776    76.133     0.200
     2.804    70.662     0.200
     2.792    78.933     0.200
     2.828    77.062     0.200
     2.867    79.652     0.200
     2.871    79.582     0.200
     2.874    79.782     0.200
     2.896    79.883     0.200
     2.948    78.263     0.200
     2.951    81.893     0.200
     3.048    84.103     0.200
     3.054    82.492     0.200
     3.116    79.872     0.200
     3.200    87.753     0.200
     3.221    87.713     0.200
     3.278    89.242     0.200
     3.328    91.433     0.200
     3.748   102.492     0.200
     3.748   102.492     0.200
     3.801   104.332     0.200
     3.833   100.513     0.200
     3.902   102.467     0.200
     3.902   103.503     0.200
     3.902   103.125     0.200
     3.902   103.393     0.200
     4.157   108.582     0.200
     4.135   108.372     0.200
     4.574   118.242     0.200
     4.545   114.202     0.200
     4.545   117.032     0.200
     4.632   118.473     0.200
     4.778   124.832     0.200
     5.361   141.963     0.200
     5.382   136.692     0.200
     5.494   143.532     0.200
     5.773   152.253     0.200
     5.890   152.792     0.200
     6.170   155.312     0.200
     6.318   167.362     0.200
     6.511   169.479     0.200
     6.503   169.893     0.200
     6.606   172.278     0.200
     6.621   165.832     0.200
     6.813   174.282     0.200
     6.905   172.423     0.200
     6.955   183.232     0.200
     7.092   185.322     0.200
     7.234   186.072     0.200
     7.241   185.383     0.200
     8.278   208.423     0.200
     8.338   211.143     0.200
     8.679   219.683     0.200
     8.679   218.341     0.200
     9.581   245.745     0.200
     9.679   239.902     0.200
     9.742   242.042     0.200
     9.742   247.010     0.200
    10.001   255.657     0.200
    10.406   271.593     0.200
    10.747   266.767     0.200
    10.747   267.822     0.200
    11.535   296.753     0.200
    12.097   308.082     0.200
    16.070   404.272     0.200
    16.642   417.763     0.200
     0.237    14.232     0.200
     0.494    18.713     0.200
     0.799    25.342     0.200
     0.987    29.723     0.200
     1.053    32.012     0.200
     1.084    32.822     0.200
     1.128    35.082     0.200
     1.334    39.443     0.200
     1.338    39.383     0.200
     1.453    42.604     0.200
     1.531    45.963     0.200
     1.528    45.332     0.200
     1.738    49.342     0.200
     1.879    52.783     0.200
     1.987    55.732     0.200
     2.001    58.783     0.200
     2.047    57.893     0.200
     2.054    57.082     0.200
     2.073    58.562     0.200
     2.074    59.104     0.200
     2.112    59.912     0.200
     2.137    60.604     0.200
     2.141    58.773     0.200
     2.218    63.213     0.200
     2.223    62.742     0.200
     2.220    62.963     0.200
     2.255    64.832     0.200
     2.266    63.682     0.200
     2.270    64.383     0.200
     2.287    64.682     0.200
     2.316    67.402     0.200
     2.302    63.023     0.200
     2.312    62.783     0.200
     2.329    65.092     0.200
     2.342    64.482     0.200
     2.353    68.082     0.200
     2.454    68.762     0.200
     2.600    72.842     0.200
     2.605    72.072     0.200
     2.837    78.832     0.200
     3.145    82.002     0.200
     3.268    88.273     0.200
     3.310    93.662     0.200
     3.321    87.502     0.200
     4.070   104.502     0.200
     4.221   108.902     0.200
     0.169    13.344     0.200
     0.541    19.961     0.200
     0.722    23.656     0.200
     0.794    26.383     0.200
     0.878    27.914     0.200
     1.004    31.562     0.200
     1.129    34.750     0.200
     1.252    37.945     0.200
     1.388    41.656     0.200
     1.523    47.633     0.200
     1.677    50.633     0.200
     1.777    51.453     0.200
     1.814    49.836     0.200
     1.907    55.625     0.200
     1.918    52.445     0.200
     1.963    57.094     0.200
     2.018    57.109     0.200
     2.037    57.836     0.200
     2.042    58.234     0.200
     2.078    54.742     0.200
     2.094    57.453     0.200
     2.101    57.000     0.200
     2.143    57.352     0.200
     2.150    59.086     0.200
     2.344    62.602     0.200
     2.332    64.773     0.200
     2.420    68.430     0.200
     2.476    67.484     0.200
     2.538    67.016     0.200
     2.632    68.695     0.200
     2.664    75.070     0.200
     3.542    89.680     0.200
     4.431   116.602     0.200
     0.235    13.803     0.200
     0.398    16.744     0.200
     0.376    16.514     0.200
     0.872    28.984     0.200
     1.161    36.293     0.200
     1.340    38.994     0.200
     1.873    53.645     0.200
     1.941    56.193     0.200
     2.179    62.203     0.200
     2.151    57.793     0.200
     2.215    62.104     0.200
     2.243    63.484     0.200
     2.218    64.064     0.200
     2.216    61.533     0.200
     2.263    61.383     0.200
     2.265    61.395     0.200
     2.270    62.264     0.200
     2.284    64.334     0.200
     2.319    68.424     0.200
     2.335    61.793     0.200
     2.336    61.793     0.200
     2.345    64.424     0.200
     2.365    63.713     0.200
     2.409    65.453     0.200
     2.379    63.553     0.200
     2.424    68.943     0.200
     2.455    65.883     0.200
     2.528    72.793     0.200
     2.606    75.383     0.200
     2.740    78.783     0.200
     2.817    76.594     0.200
     2.872    79.604     0.200
     3.005    78.834     0.200
     2.994    82.443     0.200
     2.971    80.244     0.200
     3.177    82.975     0.200
     3.277    88.023     0.200
     3.278    88.023     0.200
     3.344    88.863     0.200
     3.788   100.174     0.200
     3.803   100.504     0.200
     3.785   106.234     0.200
     4.019    99.895     0.200
     4.142   108.004     0.200
     4.253   114.303     0.200
     4.290   114.434     0.200
     7.773   197.963     0.200
     7.729   201.314     0.200
     7.806   200.322     0.200
     7.896   199.514     0.200
     8.422   218.064     0.200
     0.379    18.055     0.200
     0.383    18.055     0.200
     0.470    19.992     0.200
     0.716    25.234     0.200
     1.069    33.609     0.200
     1.187    36.953     0.200
     1.725    53.227     0.200
     1.839    52.516     0.200
     2.011    56.547     0.200
     2.110    61.867     0.200
     2.117    61.195     0.200
     2.116    58.492     0.200
     2.125    63.859     0.200
     2.156    65.188     0.200
     2.333    63.977     0.200
     2.710    74.773     0.200
     2.864    77.227     0.200
     2.968    76.703     0.200
     3.077    81.258     0.200
     3.393    86.492     0.200
     3.644   100.234     0.200
     3.977   101.938     0.200
     4.270   110.898     0.200
     5.321   135.992     0.200
     1.119    34.817     0.200
     1.737    47.987     0.200
     1.700    48.087     0.200
     2.574    70.927     0.200
     2.574    73.077     0.200
     2.574    70.671     0.200
     2.740    76.577     0.200
     2.799    76.367     0.200
     2.917    79.257     0.200
     3.022    81.987     0.200
     3.022    81.987     0.200
     3.031    84.557     0.200
     3.094    85.767     0.200
     3.316    90.967     0.200
     3.545    97.427     0.200
     3.610    94.967     0.200
     3.773    96.397     0.200
     4.459   123.727     0.200
     4.560   119.737     0.200
     4.789   125.461     0.200
     4.789   125.907     0.200
     4.935   135.327     0.200
     5.215   136.307     0.200
     5.346   143.353     0.200
     5.895   153.597     0.200
     6.077   159.727     0.200
     6.241   167.237     0.200
     6.473   171.457     0.200
     6.495   166.467     0.200
     6.495   171.455     0.200
     6.667   173.497     0.200
     7.446   194.036     0.200
     7.585   193.527     0.200
     8.210   213.497     0.200
     8.547   222.139     0.200
     8.547   214.107     0.200
     9.274   241.309     0.200
    10.078   260.933     0.200
    10.439   265.677     0.200
    10.419   269.319     0.200
    10.451   265.637     0.200
    10.439   269.466     0.200
    10.550   274.140     0.200
    10.740   274.918     0.200
    10.692   267.277     0.200
    10.770   268.607     0.200
    10.970   283.717     0.200
    11.513   285.917     0.200
    11.513   292.748     0.200
    12.160   312.139     0.200
    12.155   312.427     0.200
    12.464   321.068     0.200
    13.150   337.151     0.200
    13.576   341.037     0.200
    13.996   358.177     0.200
    14.186   362.123     0.200
    14.426   366.742     0.200
    15.015   381.400     0.200
    15.486   390.307     0.200
    15.599   395.977     0.200
    16.151   408.803     0.200
    16.317   413.019     0.200
    16.764   416.137     0.200
    22.401   549.286     0.200
     1.093    34.521     0.200
     2.549    70.910     0.200
     2.786    73.370     0.200
     3.054    82.960     0.200
     3.053    85.141     0.200
     3.572    92.261     0.200
     3.808    96.341     0.200
     4.418   115.511     0.200
     4.519   118.170     0.200
     4.814   123.169     0.200
     4.814   124.710     0.200
     4.814   130.730     0.200
     4.892   130.730     0.200
     5.176   134.120     0.200
     5.540   154.011     0.200
     6.211   167.080     0.200
     6.500   175.330     0.200
     7.475   187.070     0.200
     7.582   191.931     0.200
     7.617   193.261     0.200
     7.705   193.261     0.200
     8.006   211.290     0.200
     8.564   217.490     0.200
     8.711   226.801     0.200
     9.615   249.980     0.200
    10.449   265.431     0.200
    11.528   287.919     0.200
    11.528   288.311     0.200
    11.528   286.311     0.200
     1.027    32.542     0.200
     3.548    93.852     0.200
     4.380   119.762     0.200
     4.750   129.702     0.200
     4.807   123.436     0.200
     5.147   134.412     0.200
     5.346   145.062     0.200
     5.529   148.532     0.200
     5.991   161.302     0.200
     7.476   189.151     0.200
     7.593   189.562     0.200
     7.628   191.562     0.200
     7.717   199.562     0.200
     7.939   207.642     0.200
     9.559   250.572     0.200
    10.358   266.762     0.200
    12.074   306.661     0.200
     0.742    24.777     0.200
     0.995    31.855     0.200
     1.265    37.215     0.200
     1.802    49.656     0.200
     2.018    58.277     0.200
     2.027    57.098     0.200
     2.078    58.785     0.200
     2.256    60.586     0.200
     2.334    64.215     0.200
     2.341    63.066     0.200
     2.355    64.547     0.200
     2.356    64.035     0.200
     2.362    66.406     0.200
     2.370    66.488     0.200
     2.379    65.656     0.200
     2.440    67.938     0.200
     2.510    70.617     0.200
     2.511    68.055     0.200
     2.569    70.488     0.200
     2.632    69.836     0.200
     2.590    71.586     0.200
     2.672    74.738     0.200
     2.689    71.605     0.200
     2.710    76.336     0.200
     2.782    77.355     0.200
     2.819    78.668     0.200
     2.857    77.977     0.200
     2.857    77.977     0.200
     2.865    74.598     0.200
     2.944    82.258     0.200
     3.342    91.668     0.200
     3.414    91.105     0.200
     3.415    91.105     0.200
     3.650    93.707     0.200
     3.717    97.805     0.200
     3.818    98.918     0.200
     4.625   119.750     0.200
     4.625   118.117     0.200
     4.697   123.617     0.200
     5.309   136.125     0.200
     5.961   152.645     0.200
     7.932   201.676     0.200
     1.268    41.275     0.200
     1.350    42.285     0.200
     1.382    44.205     0.200
     1.691    50.685     0.200
     2.252    65.625     0.200
     2.252    65.955     0.200
     2.677    75.345     0.200
     2.745    77.255     0.200
     2.793    79.145     0.200
     0.302    15.656     0.200
     0.385    15.969     0.200
     0.686    22.367     0.200
     0.699    23.605     0.200
     0.859    27.129     0.200
     0.899    28.445     0.200
     1.141    35.207     0.200
     1.165    35.559     0.200
     1.204    36.445     0.200
     1.289    37.328     0.200
     1.323    39.758     0.200
     1.372    39.297     0.200
     1.524    44.746     0.200
     1.886    52.969     0.200
     1.892    52.855     0.200
     1.956    54.059     0.200
     1.956    53.918     0.200
     2.005    57.219     0.200
     2.018    57.707     0.200
     2.044    55.996     0.200
     2.055    60.707     0.200
     2.076    60.246     0.200
     2.084    59.477     0.200
     2.098    56.316     0.200
     2.100    58.695     0.200
     2.110    58.918     0.200
     2.160    60.066     0.200
     2.226    62.016     0.200
     2.244    59.547     0.200
     2.283    60.758     0.200
     2.322    62.227     0.200
     2.334    63.258     0.200
     2.355    64.078     0.200
     2.374    67.379     0.200
     2.409    66.758     0.200
     2.415    66.195     0.200
     2.445    67.578     0.200
     2.511    66.387     0.200
     2.525    66.957     0.200
     2.629    73.797     0.200
     2.850    78.867     0.200
     2.916    79.496     0.200
     2.952    75.059     0.200
     3.072    81.918     0.200
     3.321    91.438     0.200
     3.452    92.945     0.200
     3.866   100.387     0.200
     4.581   116.457     0.200
     0.312    15.570     0.200
     0.411    17.691     0.200
     0.642    22.242     0.200
     0.855    27.402     0.200
     0.871    27.102     0.200
     0.998    31.812     0.200
     1.130    34.672     0.200
     1.166    35.352     0.200
     1.269    37.590     0.200
     1.275    38.320     0.200
     1.446    42.023     0.200
     1.604    46.582     0.200
     1.621    46.293     0.200
     1.811    51.133     0.200
     1.944    55.172     0.200
     1.952    54.340     0.200
     1.960    55.492     0.200
     1.982    55.641     0.200
     1.983    55.152     0.200
     1.993    55.492     0.200
     2.014    56.031     0.200
     2.022    57.102     0.200
     2.049    56.730     0.200
     2.056    57.602     0.200
     2.089    58.461     0.200
     2.115    59.363     0.200
     2.120    61.441     0.200
     2.176    58.352     0.200
     2.284    62.531     0.200
     2.321    63.293     0.200
     2.372    66.031     0.200
     2.405    66.582     0.200
     2.408    66.250     0.200
     2.409    65.352     0.200
     2.449    64.660     0.200
     2.484    68.281     0.200
     2.487    65.273     0.200
     2.502    73.191     0.200
     2.656    72.812     0.200
     2.667    70.402     0.200
     2.673    73.000     0.200
     2.802    73.402     0.200
     2.984    80.992     0.200
     3.349    89.141     0.200
     3.548    93.762     0.200
     3.566    94.422     0.200
     3.712    98.312     0.200
     4.428   116.141     0.200
     4.520   116.473     0.200
     5.190   136.230     0.200
     5.291   137.742     0.200
     5.422   140.242     0.200
     6.133   157.723     0.200
     1.172    37.383     0.200
     2.556    72.852     0.200
     2.557    72.852     0.200
     2.650    69.961     0.200
     2.650    73.492     0.200
     2.724    76.984     0.200
     2.759    75.438     0.200
     2.791    73.211     0.200
     2.894    79.727     0.200
     2.969    80.711     0.200
     2.969    80.711     0.200
     3.179    82.328     0.200
     3.405    90.992     0.200
     3.596    96.711     0.200
     3.597    96.711     0.200
     3.698    94.391     0.200
     3.692    96.375     0.200
     4.219   113.703     0.200
     4.547   116.164     0.200
     4.647   123.102     0.200
     4.734   122.180     0.200
     5.299   145.352     0.200
     5.983   148.328     0.200
     1.602    44.701     0.200
     2.461    69.171     0.200
     2.625    74.111     0.200
     3.638    93.831     0.200
     4.448   118.361     0.200
     4.669   119.980     0.200
     4.669   120.371     0.200
     4.669   122.275     0.200
     7.319   189.355     0.200
     7.416   190.861     0.200
     7.623   201.038     0.200
     9.548   250.106     0.200
     0.312    15.195     0.200
     0.363    16.234     0.200
     0.489    18.586     0.200
     0.884    27.898     0.200
     1.152    34.438     0.200
     1.254    37.734     0.200
     1.530    40.234     0.200
     1.797    51.703     0.200
     1.844    53.328     0.200
     2.058    59.125     0.200
     2.087    59.734     0.200
     2.106    62.547     0.200
     2.130    60.148     0.200
     2.116    59.367     0.200
     2.136    63.406     0.200
     2.166    62.203     0.200
     2.173    62.086     0.200
     2.176    62.203     0.200
     2.182    60.281     0.200
     2.206    60.562     0.200
     2.208    64.133     0.200
     2.230    63.227     0.200
     2.232    63.906     0.200
     2.235    62.578     0.200
     2.287    64.531     0.200
     2.297    65.883     0.200
     2.369    66.719     0.200
     2.451    71.625     0.200
     2.735    75.445     0.200
     2.724    74.805     0.200
     2.745    77.438     0.200
     2.866    78.773     0.200
     3.199    87.828     0.200
     3.440    94.234     0.200
     3.964   103.492     0.200
     4.090   110.047     0.200
     4.330   115.977     0.200
     4.817   123.836     0.200
     0.408    18.164     0.200
     0.610    21.715     0.200
     0.875    27.633     0.200
     1.018    31.875     0.200
     1.111    33.992     0.200
     1.217    36.074     0.200
     1.205    37.504     0.200
     1.263    37.145     0.200
     1.865    52.195     0.200
     1.916    51.625     0.200
     1.957    55.883     0.200
     1.954    52.434     0.200
     1.972    57.152     0.200
     1.976    53.965     0.200
     1.985    55.332     0.200
     2.005    52.434     0.200
     2.011    54.055     0.200
     2.065    59.152     0.200
     2.129    58.305     0.200
     2.208    61.824     0.200
     2.313    61.824     0.200
     2.355    66.445     0.200
     2.353    66.902     0.200
     2.355    65.023     0.200
     2.398    68.492     0.200
     2.403    66.914     0.200
     2.428    67.004     0.200
     2.432    69.793     0.200
     2.435    63.414     0.200
     2.514    65.953     0.200
     2.621    67.766     0.200
     2.621    70.562     0.200
     2.764    73.633     0.200
     2.833    74.953     0.200
     2.853    72.973     0.200
     3.029    81.766     0.200
     3.300    87.984     0.200
     3.534    93.004     0.200
     3.745    98.465     0.200
     5.138   134.312     0.200
     5.238   135.926     0.200
     5.370   136.984     0.200
     5.506   140.055     0.200
     6.055   158.793     0.200
     6.579   166.926     0.200
     6.610   168.504     0.200
     6.702   169.453     0.200
     0.512    20.078     0.200
     0.480    20.117     0.200
     0.718    24.906     0.200
     1.005    31.836     0.200
     1.046    32.785     0.200
     1.101    34.535     0.200
     1.247    38.156     0.200
     1.335    40.156     0.200
     1.349    41.746     0.200
     1.686    49.035     0.200
     1.750    46.938     0.200
     1.802    51.336     0.200
     1.838    46.938     0.200
     1.857    51.988     0.200
     1.903    54.395     0.200
     1.952    54.645     0.200
     2.038    57.965     0.200
     1.990    59.328     0.200
     2.153    61.957     0.200
     2.158    61.387     0.200
     2.091    61.656     0.200
     2.219    61.957     0.200
     2.060    58.797     0.200
     2.240    63.285     0.200
     2.471    64.477     0.200
     2.965    79.895     0.200
     3.021    78.535     0.200
     3.295    93.477     0.200
     3.857   100.387     0.200
     4.561   116.625     0.200
     4.957   127.738     0.200
     5.186   135.047     0.200
     6.261   162.758     0.200
     0.217    12.615     0.200
     0.295    14.244     0.200
     0.910    28.914     0.200
     1.198    36.285     0.200
     1.360    39.805     0.200
     1.378    40.744     0.200
     1.439    41.395     0.200
     1.487    42.744     0.200
     1.912    53.615     0.200
     1.976    54.273     0.200
     1.978    55.594     0.200
     1.995    56.145     0.200
     2.187    60.814     0.200
     2.250    62.695     0.200
     2.256    61.705     0.200
     2.261    63.234     0.200
     2.297    64.684     0.200
     2.303    63.604     0.200
     2.308    64.365     0.200
     2.319    63.324     0.200
     2.343    64.334     0.200
     2.355    64.824     0.200
     2.378    65.305     0.200
     2.410    65.773     0.200
     2.417    66.184     0.200
     2.567    69.955     0.200
     2.645    72.273     0.200
     2.774    75.195     0.200
     2.874    77.744     0.200
     2.910    78.014     0.200
     2.995    79.695     0.200
     3.012    81.334     0.200
     3.173    85.254     0.200
     3.317    89.174     0.200
     3.816   100.725     0.200
     4.011   104.834     0.200
     4.027   106.254     0.200
     4.100   107.854     0.200
     4.270   112.014     0.200
     4.941   127.955     0.200
     5.647   146.125     0.200
     0.918    29.480     0.200
     1.504    43.957     0.200
     1.933    53.777     0.200
     2.422    66.668     0.200
     2.461    68.430     0.200
     2.505    70.090     0.200
     2.538    70.719     0.200
     2.556    71.469     0.200
     2.564    72.848     0.200
     2.608    73.688     0.200
     2.610    74.199     0.200
     2.619    71.680     0.200
     2.629    73.617     0.200
     2.636    70.859     0.200
     2.668    73.109     0.200
     2.699    76.027     0.200
     2.752    77.629     0.200
     2.777    77.008     0.200
     2.857    79.039     0.200
     2.948    77.367     0.200
     2.961    82.180     0.200
     3.063    83.797     0.200
     3.110    86.820     0.200
     3.203    86.359     0.200
     3.202    86.359     0.200
     3.211    87.449     0.200
     3.149    86.719     0.200
     3.413    89.910     0.200
     3.970   102.559     0.200
     4.014   109.590     0.200
     4.161   111.320     0.200
     4.121   108.137     0.200
     4.252   110.957     0.200
     4.468   119.848     0.200
     4.368   115.180     0.200
     4.832   129.750     0.200
     4.970   127.402     0.200
     4.970   131.629     0.200
     4.962   134.898     0.200
     5.385   143.188     0.200
     5.685   147.207     0.200
     5.898   155.840     0.200
     6.196   166.508     0.200
     6.689   171.570     0.200
     7.635   194.547     0.200
     7.745   197.438     0.200
     7.780   200.098     0.200
     7.868   199.430     0.200
     7.981   211.059     0.200
     9.503   247.289     0.200
    11.668   292.320     0.200
    11.967   304.277     0.200
     0.257    14.809     0.200
     0.593    21.449     0.200
     0.650    22.469     0.200
     0.708    23.887     0.200
     0.761    24.457     0.200
     1.014    32.488     0.200
     1.113    33.398     0.200
     1.125    36.219     0.200
     1.177    36.199     0.200
     1.616    45.887     0.200
     1.686    48.938     0.200
     1.722    48.277     0.200
     1.841    50.207     0.200
     1.886    53.617     0.200
     1.920    58.516     0.200
     1.971    57.449     0.200
     1.993    58.516     0.200
     2.036    59.789     0.200
     2.097    58.117     0.200
     2.099    57.977     0.200
     2.495    68.156     0.200
     2.636    72.926     0.200
     2.695    75.258     0.200
     2.753    71.727     0.200
     2.778    74.469     0.200
     3.622    93.676     0.200
     3.752    92.918     0.200
     4.243   112.988     0.200
     4.334   116.098     0.200
     4.479   115.797     0.200
     4.602   119.105     0.200
     0.845    26.922     0.200
     1.871    52.715     0.200
     1.875    53.914     0.200
     1.863    52.375     0.200
     1.912    55.195     0.200
     2.060    58.055     0.200
     2.167    60.484     0.200
     2.163    59.773     0.200
     2.201    60.902     0.200
     2.217    62.434     0.200
     2.218    61.613     0.200
     2.238    62.523     0.200
     2.242    62.742     0.200
     2.272    63.582     0.200
     2.277    63.582     0.200
     2.290    63.355     0.200
     2.306    64.445     0.200
     2.286    63.914     0.200
     2.307    63.695     0.200
     2.309    63.793     0.200
     2.334    65.723     0.200
     2.352    64.645     0.200
     2.356    65.363     0.200
     2.373    66.453     0.200
     2.378    65.312     0.200
     2.409    67.293     0.200
     2.440    66.434     0.200
     2.449    66.883     0.200
     2.489    68.562     0.200
     2.524    69.234     0.200
     2.575    70.805     0.200
     2.758    75.715     0.200
     2.807    75.945     0.200
     2.815    76.145     0.200
     2.850    77.062     0.200
     2.890    78.504     0.200
     2.883    77.812     0.200
     3.047    82.613     0.200
     3.047    82.613     0.200
     3.071    82.844     0.200
     3.271    88.625     0.200
     3.272    88.625     0.200
     3.851   102.605     0.200
     3.896   102.742     0.200
     4.129   108.605     0.200
     4.371   114.285     0.200
     4.740   126.055     0.200
     5.412   140.973     0.200
     5.851   153.812     0.200
     5.957   154.703     0.200
     6.514   168.133     0.200
     6.582   164.723     0.200
     7.504   193.652     0.200
     7.650   195.344     0.200
     7.682   197.793     0.200
     7.750   197.664     0.200
     0.905    28.938     0.200
     2.351    65.250     0.200
     2.410    66.891     0.200
     2.408    68.961     0.200
     2.464    69.930     0.200
     2.506    69.984     0.200
     2.516    71.289     0.200
     2.539    72.430     0.200
     2.536    70.352     0.200
     2.555    72.602     0.200
     2.567    71.977     0.200
     2.595    74.070     0.200
     2.612    72.648     0.200
     2.613    73.109     0.200
     2.621    73.219     0.200
     2.633    72.508     0.200
     2.679    74.516     0.200
     2.703    75.266     0.200
     2.864    78.891     0.200
     2.973    81.945     0.200
     3.102    82.641     0.200
     3.079    85.398     0.200
     3.115    87.539     0.200
     3.191    89.828     0.200
     3.191    89.828     0.200
     3.162    83.477     0.200
     3.427    91.031     0.200
     3.529    98.406     0.200
     3.530    98.406     0.200
     3.957   101.781     0.200
     4.026   106.656     0.200
     4.136   111.117     0.200
     4.267   113.258     0.200
     4.383   117.320     0.200
     4.464   119.820     0.200
     4.835   128.938     0.200
     4.959   130.836     0.200
     4.970   134.281     0.200
     5.034   133.961     0.200
     5.399   143.625     0.200
     5.505   148.516     0.200
     5.721   152.148     0.200
     5.912   158.000     0.200
     6.203   163.961     0.200
     6.306   166.586     0.200
     6.647   173.156     0.200
     6.676   168.961     0.200
     7.623   195.672     0.200
     7.731   197.461     0.200
     7.767   201.945     0.200
     7.855   201.055     0.200
     7.988   208.625     0.200
     8.680   226.672     0.200
     1.244    39.219     0.200
     1.244    38.703     0.200
     1.982    55.359     0.200
     2.059    58.328     0.200
     2.181    61.719     0.200
     2.388    67.547     0.200
     2.427    67.719     0.200
     2.435    65.727     0.200
     2.506    71.352     0.200
     2.508    70.820     0.200
     2.555    72.797     0.200
     2.568    73.109     0.200
     2.605    73.039     0.200
     2.622    73.039     0.200
     2.623    74.742     0.200
     2.622    73.961     0.200
     2.636    72.797     0.200
     2.644    74.578     0.200
     2.647    73.508     0.200
     2.651    73.289     0.200
     2.653    74.898     0.200
     2.669    74.828     0.200
     2.670    75.562     0.200
     2.695    76.359     0.200
     2.697    72.547     0.200
     2.694    76.508     0.200
     2.694    76.508     0.200
     2.719    76.367     0.200
     2.736    76.539     0.200
     2.745    76.797     0.200
     2.776    76.859     0.200
     2.865    81.031     0.200
     2.891    80.758     0.200
     3.048    84.328     0.200
     3.123    87.000     0.200
     3.267    90.492     0.200
     3.348    89.883     0.200
     3.348    89.711     0.200
     3.411    90.891     0.200
     3.598    98.281     0.200
     3.599    98.281     0.200
     3.626    98.289     0.200
     3.695    99.797     0.200
     3.692   100.320     0.200
     3.900   105.250     0.200
     3.971   102.711     0.200
     4.203   113.812     0.200
     4.368   119.297     0.200
     4.456   113.508     0.200
     5.163   136.594     0.200
     5.179   137.078     0.200
     5.573   144.133     0.200
     5.883   154.930     0.200
     5.937   151.602     0.200
     6.132   162.117     0.200
     6.238   164.727     0.200
     6.330   168.047     0.200
     6.406   168.023     0.200
     6.672   174.180     0.200
     7.097   186.133     0.200
     8.144   215.953     0.200
     8.882   232.977     0.200
     9.937   256.562     0.200
    11.227   282.117     0.200
     1.160    34.910     0.200
     1.241    36.391     0.200
     2.092    59.648     0.200
     2.176    61.930     0.200
     2.288    64.059     0.200
     2.288    64.191     0.200
     2.341    65.762     0.200
     2.340    65.012     0.200
     2.354    66.309     0.200
     2.373    65.559     0.200
     2.396    66.281     0.200
     2.482    68.969     0.200
     2.520    71.488     0.200
     2.586    70.160     0.200
     2.957    80.320     0.200
     3.120    85.109     0.200
     3.197    83.422     0.200
     3.231    89.512     0.200
     3.336    90.602     0.200
     3.816   103.770     0.200
     3.930   107.750     0.200
     4.058   109.082     0.200
     4.210   106.609     0.200
     4.736   124.809     0.200
     1.283    41.098     0.200
     1.421    44.578     0.200
     1.525    46.717     0.200
     2.361    68.838     0.200
     2.407    69.877     0.200
     3.439    96.648     0.200
     7.714   201.777     0.200
     0.192    13.030     0.200
     0.306    14.910     0.200
     0.469    17.630     0.200
     0.885    28.760     0.200
     1.037    31.340     0.200
     1.123    34.500     0.200
     1.345    40.520     0.200
     1.360    40.480     0.200
     1.417    41.790     0.200
     1.528    44.420     0.200
     1.870    53.580     0.200
     1.953    55.830     0.200
     2.056    57.460     0.200
     2.139    60.360     0.200
     2.218    62.450     0.200
     2.222    62.610     0.200
     2.244    62.330     0.200
     2.275    64.580     0.200
     2.286    63.460     0.200
     2.292    65.860     0.200
     2.300    64.470     0.200
     2.304    65.180     0.200
     2.322    65.070     0.200
     2.321    64.820     0.200
     2.321    65.960     0.200
     2.350    65.160     0.200
     2.350    66.730     0.200
     2.355    66.620     0.200
     2.355    66.620     0.200
     2.366    65.250     0.200
     2.371    66.310     0.200
     2.370    65.840     0.200
     2.385    66.410     0.200
     2.387    66.860     0.200
     2.393    66.620     0.200
     2.426    67.670     0.200
     2.431    66.960     0.200
     2.458    68.070     0.200
     2.459    67.820     0.200
     2.478    68.070     0.200
     2.525    70.050     0.200
     2.588    70.920     0.200
     2.692    73.890     0.200
     2.801    77.310     0.200
     2.879    78.610     0.200
     2.901    78.980     0.200
     3.050    82.720     0.200
     3.076    82.450     0.200
     3.235    87.070     0.200
     3.235    87.070     0.200
     3.274    89.010     0.200
     3.275    89.010     0.200
     3.273    88.110     0.200
     3.741   100.420     0.200
     3.825   102.440     0.200
     3.828   100.900     0.200
     3.942   104.800     0.200
     4.090   103.640     0.200
     4.151   110.360     0.200
     4.184   110.770     0.200
     4.329   114.880     0.200
     4.587   120.920     0.200
     4.689   124.820     0.200
     4.859   127.970     0.200
     5.002   128.470     0.200
     5.002   131.160     0.200
     5.226   137.960     0.200
     5.221   136.430     0.200
     5.495   142.640     0.200
     5.705   147.870     0.200
     5.679   148.370     0.200
     6.025   157.930     0.200
     6.703   172.300     0.200
     6.776   170.660     0.200
     7.695   197.270     0.200
     7.710   200.000     0.200
     7.844   201.160     0.200
     7.876   202.430     0.200
     8.397   217.690     0.200
     8.420   215.720     0.200
    10.044   255.790     0.200
    10.728   273.030     0.200
    10.991   280.520     0.200
    11.621   288.172     0.200
    11.621   286.450     0.200
     2.155    60.854     0.200
     2.335    66.084     0.200
     2.335    65.545     0.200
     2.409    67.725     0.200
     2.698    73.805     0.200
     2.768    75.465     0.200
     2.761    77.953     0.200
     3.020    82.443     0.200
     3.107    82.514     0.200
     3.242    86.584     0.200
     3.274    90.344     0.200
     3.274    91.254     0.200
     3.393    90.084     0.200
     3.779   100.824     0.200
     3.881   105.344     0.200
     4.022   104.414     0.200
     4.299   113.104     0.200
     4.594   123.635     0.200
     4.694   122.234     0.200
     5.056   131.514     0.200
     5.159   134.334     0.200
     5.351   137.664     0.200
     5.860   148.074     0.200
     8.009   201.734     0.200
     8.042   206.715     0.200
     8.132   205.055     0.200
     1.051    31.355     0.200
     1.351    39.055     0.200
     1.410    41.223     0.200
     1.512    44.262     0.200
     1.911    54.652     0.200
     2.006    56.652     0.200
     2.068    56.555     0.200
     2.093    60.035     0.200
     2.173    61.523     0.200
     2.178    61.324     0.200
     2.237    61.695     0.200
     2.232    62.785     0.200
     2.242    62.152     0.200
     2.282    63.262     0.200
     2.326    63.523     0.200
     2.339    64.145     0.200
     2.478    68.184     0.200
     2.476    69.395     0.200
     2.542    72.094     0.200
     2.652    72.484     0.200
     2.876    78.094     0.200
     3.031    82.562     0.200
     3.088    79.875     0.200
     3.231    85.523     0.200
     3.263    86.555     0.200
     3.230    87.633     0.200
     4.035   106.645     0.200
     4.165   106.645     0.200
     4.845   127.324     0.200
     2.758    77.965     0.200
     4.422   116.176     0.200
    11.229   288.270     0.200
     1.037    36.426     0.200
     1.312    43.684     0.200
     1.356    43.625     0.200
     1.866    55.684     0.200
     2.169    64.656     0.200
     2.302    66.426     0.200
     2.312    69.086     0.200
     2.374    70.465     0.200
     2.610    77.027     0.200
     2.630    75.816     0.200
     2.668    77.094     0.200
     2.643    77.145     0.200
     2.689    78.477     0.200
     2.705    78.766     0.200
     2.708    79.215     0.200
     2.753    80.695     0.200
     2.743    80.465     0.200
     2.758    78.945     0.200
     2.759    80.824     0.200
     2.767    80.465     0.200
     2.782    81.125     0.200
     2.782    81.797     0.200
     2.784    81.125     0.200
     2.804    82.457     0.200
     2.826    82.734     0.200
     2.831    83.035     0.200
     2.833    81.797     0.200
     2.853    83.047     0.200
     2.879    83.707     0.200
     2.896    83.125     0.200
     2.913    83.125     0.200
     3.004    86.395     0.200
     3.026    87.297     0.200
     3.194    90.887     0.200
     3.251    92.426     0.200
     3.260    93.355     0.200
     3.327    89.035     0.200
     3.414    97.164     0.200
     3.497    99.156     0.200
     3.686   103.285     0.200
     3.734   105.215     0.200
     3.766   105.047     0.200
     4.004   113.516     0.200
     4.075   111.227     0.200
     4.273   118.645     0.200
     4.422   120.766     0.200
     4.518   120.707     0.200
     4.588   125.664     0.200
     4.784   130.477     0.200
     4.910   136.035     0.200
     4.918   133.617     0.200
     4.989   135.707     0.200
     5.030   135.895     0.200
     5.036   137.266     0.200
     5.150   138.254     0.200
     6.049   163.367     0.200
     6.069   158.027     0.200
     6.032   163.926     0.200
     6.087   164.027     0.200
     6.119   163.527     0.200
     6.364   170.164     0.200
     6.539   174.457     0.200
     6.822   183.527     0.200
     7.043   186.977     0.200
     7.131   189.754     0.200
     8.245   220.074     0.200
     8.286   219.457     0.200
     9.280   237.285     0.200
    10.084   262.934     0.200
    10.900   282.184     0.200
    11.229   288.875     0.200
    11.406   296.324     0.200
    11.808   306.086     0.200
    12.624   325.375     0.200
    12.663   328.785     0.200
    13.133   337.027     0.200
    15.784   402.094     0.200
    16.280   412.777     0.200
    16.548   418.215     0.200
    17.882   449.234     0.200
    18.729   468.504     0.200
    20.520   513.684     0.200
    22.101   545.586     0.200
    22.187   548.406     0.200
     0.233    14.953     0.200
     0.568    21.172     0.200
     0.690    23.562     0.200
     0.679    23.582     0.200
     0.753    24.824     0.200
     1.029    32.602     0.200
     1.136    34.824     0.200
     1.155    34.594     0.200
     1.192    36.574     0.200
     1.642    47.004     0.200
     1.718    49.383     0.200
     1.857    52.254     0.200
     1.909    53.941     0.200
     2.017    56.762     0.200
     2.024    55.242     0.200
     2.026    54.672     0.200
     2.068    58.883     0.200
     2.082    58.922     0.200
     2.168    57.645     0.200
     2.261    61.984     0.200
     2.400    68.531     0.200
     2.523    70.223     0.200
     2.660    71.652     0.200
     2.661    77.371     0.200
     2.754    71.402     0.200
     2.794    77.242     0.200
     2.852    73.672     0.200
     3.103    81.254     0.200
     4.242   113.012     0.200
     4.335   112.902     0.200
     4.478   118.863     0.200
     0.318    14.668     0.200
     0.317    15.098     0.200
     0.462    17.988     0.200
     0.832    27.320     0.200
     0.889    27.410     0.200
     1.183    35.867     0.200
     1.306    38.008     0.200
     1.847    51.938     0.200
     1.892    54.059     0.200
     1.898    54.887     0.200
     2.091    56.648     0.200
     2.135    57.309     0.200
     2.139    60.707     0.200
     2.159    60.859     0.200
     2.183    61.309     0.200
     2.220    59.848     0.200
     2.226    58.188     0.200
     2.230    58.680     0.200
     2.286    63.500     0.200
     2.340    61.027     0.200
     2.421    64.797     0.200
     2.502    69.309     0.200
     2.555    71.957     0.200
     2.598    72.289     0.200
     2.772    73.500     0.200
     2.925    75.730     0.200
     3.080    83.219     0.200
     3.250    90.008     0.200
     1.834    52.137     0.200
     1.889    54.039     0.200
     2.104    59.516     0.200
     2.195    62.496     0.200
     2.225    61.688     0.200
     2.226    63.496     0.200
     2.288    64.508     0.200
     2.277    61.996     0.200
     2.291    64.488     0.200
     2.359    67.098     0.200
     2.712    73.027     0.200
     2.744    76.605     0.200
     2.854    79.516     0.200
     2.908    78.629     0.200
     3.040    81.879     0.200
     3.190    89.336     0.200
     3.447    93.059     0.200
     3.917   102.867     0.200
     4.095   110.457     0.200
     4.199   113.117     0.200
     4.335   116.438     0.200
     4.807   125.547     0.200
     1.412    44.578     0.200
     1.429    44.938     0.200
     1.529    45.449     0.200
     1.914    54.758     0.200
     2.144    62.059     0.200
     2.481    71.227     0.200
     2.927    81.469     0.200
     2.991    84.559     0.200
     3.191    89.289     0.200
     3.178    87.578     0.200
     3.436    92.078     0.200
     4.036   112.609     0.200
     3.950   105.887     0.200
     4.044   110.648     0.200
     4.154   113.809     0.200
     4.475   123.496     0.200
     4.283   115.387     0.200
     4.853   132.008     0.200
     4.989   137.008     0.200
     4.959   129.410     0.200
     4.959   133.078     0.200
     5.044   131.137     0.200
     5.504   146.508     0.200
     5.523   147.469     0.200
     5.409   141.297     0.200
     5.674   151.008     0.200
     5.734   149.637     0.200
     5.926   156.109     0.200
     6.221   166.340     0.200
     6.324   167.797     0.200
     6.646   174.848     0.200
     6.672   173.727     0.200
     7.621   199.590     0.200
     7.726   195.738     0.200
     7.850   204.719     0.200
     8.007   209.797     0.200
     8.702   226.059     0.200
     8.699   227.758     0.200
     8.675   224.727     0.200
     9.533   247.746     0.200
    10.310   265.637     0.200
    11.283   290.039     0.200
    12.059   308.508     0.200
    12.553   320.527     0.200
    15.257   385.609     0.200
    15.695   394.109     0.200
    15.997   403.316     0.200
    19.899   500.137     0.200
     1.236    35.766     0.200
     1.992    56.242     0.200
     2.229    59.422     0.200
     2.256    58.969     0.200
     2.630    74.242     0.200
     2.723    77.234     0.200
     2.761    76.562     0.200
     2.785    78.562     0.200
     2.836    78.562     0.200
     2.833    77.562     0.200
     2.856    78.562     0.200
     2.899    80.883     0.200
     2.925    79.898     0.200
     2.987    82.547     0.200
     3.098    87.203     0.200
     3.255    83.547     0.200
     3.317    93.188     0.200
     3.279    89.859     0.200
     3.499    93.188     0.200
     3.659    99.312     0.200
     3.592    96.328     0.200
     3.807   105.664     0.200
     3.862   102.484     0.200
     4.294   119.312     0.200
     4.378   115.562     0.200
     4.378   114.656     0.200
     4.160   104.867     0.200
     4.612   123.984     0.200
     5.008   135.312     0.200
     5.055   136.523     0.200
     4.874   124.406     0.200
     5.108   135.977     0.200
     5.002   128.773     0.200
     5.009   128.398     0.200
     5.121   131.516     0.200
     5.393   144.094     0.200
     5.771   146.336     0.200
     6.004   155.453     0.200
     6.036   155.719     0.200
     6.128   161.047     0.200
     6.137   154.789     0.200
     6.546   170.164     0.200
     6.456   164.945     0.200
     6.634   169.953     0.200
     6.985   181.062     0.200
     6.985   179.227     0.200
     6.917   180.859     0.200
     7.043   176.234     0.200
     7.060   183.289     0.200
     7.082   180.883     0.200
     8.217   214.609     0.200
     8.217   215.266     0.200
     8.365   218.422     0.200
     9.111   236.023     0.200
    10.183   264.578     0.200
    11.205   280.484     0.200
    11.493   294.562     0.200
    11.904   302.492     0.200
    15.880   397.172     0.200
    20.597   507.336     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthin,blue << EOF
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.180     7.806     0.200
     0.250     9.625     0.200
     1.452    43.745     0.200
     1.972    58.325     0.200
     2.110    62.355     0.200
     2.358    68.686     0.200
     2.499    72.545     0.200
     2.499    73.726     0.200
     4.429   125.195     0.200
     0.168    11.354     0.200
     0.977    32.393     0.200
     1.411    44.143     0.200
     2.031    59.344     0.200
     2.371    67.773     0.200
     2.451    71.273     0.200
     2.451    70.773     0.200
     0.168     8.387     0.200
     1.533    46.996     0.200
     1.440    44.188     0.200
     2.365    68.477     0.200
     2.367    68.477     0.200
     0.154    10.113     0.200
     0.397    15.723     0.200
     1.212    36.953     0.200
     1.377    41.453     0.200
     2.280    65.353     0.200
     0.682    22.086     0.200
     1.012    32.676     0.200
     1.475    44.547     0.200
     1.553    46.715     0.200
     2.000    59.406     0.200
     2.326    67.055     0.200
     2.435    69.957     0.200
     2.586    73.695     0.200
     2.719    76.996     0.200
     0.274    11.031     0.200
     0.677    22.090     0.200
     1.646    49.262     0.200
     1.480    46.402     0.200
     2.461    76.301     0.200
     2.568    76.449     0.200
     4.270   121.922     0.200
     5.113   148.641     0.200
     6.292   182.039     0.200
     0.865    29.602     0.200
     1.023    31.652     0.200
     1.094    35.211     0.200
     2.010    59.711     0.200
     2.176    63.871     0.200
     2.337    66.770     0.200
     1.011    31.422     0.200
     1.185    36.211     0.200
     1.478    44.078     0.200
     1.538    45.422     0.200
     2.040    62.148     0.200
     2.338    73.898     0.200
     2.455    73.148     0.200
     2.612    74.711     0.200
     2.679    80.539     0.200
     3.417    99.758     0.200
     4.581   136.500     0.200
     0.242     9.777     0.200
     1.019    31.788     0.200
     1.287    39.348     0.200
     1.436    42.888     0.200
     0.594    19.859     0.200
     0.997    30.891     0.200
     1.181    35.500     0.200
     1.797    53.250     0.200
     2.554    77.719     0.200
     0.358    13.254     0.200
     1.564    48.934     0.200
     1.655    50.504     0.200
     2.076    62.645     0.200
     2.390    74.785     0.200
     5.891   172.156     0.200
     0.240    10.809     0.200
     0.642    21.469     0.200
     1.594    48.770     0.200
     1.594    49.770     0.200
     1.620    48.438     0.200
     2.128    64.656     0.200
     3.551   106.527     0.200
     0.215     9.871     0.200
     0.285    11.191     0.200
     1.674    52.230     0.200
     1.526    47.832     0.200
     4.377   126.242     0.200
     5.406   160.402     0.200
     0.626    22.617     0.200
     0.553    18.238     0.200
     1.187    35.035     0.200
     1.422    42.855     0.200
     1.422    45.648     0.200
     1.627    48.238     0.200
     2.148    62.445     0.200
     2.180    63.828     0.200
     2.216    64.156     0.200
     2.925    83.258     0.200
     3.140    94.527     0.200
     3.161    91.828     0.200
     4.362   127.809     0.200
     4.249   120.527     0.200
     4.537   128.746     0.200
     0.294    12.479     0.200
     0.372    13.348     0.200
     0.461    16.367     0.200
     0.864    27.518     0.200
     0.929    29.729     0.200
     1.222    36.637     0.200
     1.675    49.688     0.200
     1.686    52.229     0.200
     1.724    52.947     0.200
     1.788    54.928     0.200
     1.817    58.037     0.200
     1.918    57.467     0.200
     2.170    64.637     0.200
     2.135    65.309     0.200
     2.236    71.168     0.200
     2.289    69.617     0.200
     2.309    73.059     0.200
     2.468    75.867     0.200
     2.595    76.527     0.200
     2.632    78.408     0.200
     2.652    77.217     0.200
     2.641    75.898     0.200
     4.087   117.387     0.200
     4.825   137.668     0.200
     0.190     8.988     0.200
     0.167     8.391     0.200
     0.249    10.422     0.200
     0.811    25.852     0.200
     1.499    46.059     0.200
     1.611    48.832     0.200
     1.618    49.820     0.200
     1.883    55.672     0.200
     1.922    57.410     0.200
     2.080    60.480     0.200
     2.156    63.531     0.200
     2.162    62.910     0.200
     2.177    67.781     0.200
     2.501    74.680     0.200
     2.502    75.000     0.200
     2.504    74.340     0.200
     2.588    74.898     0.200
     2.588    76.320     0.200
     2.601    74.672     0.200
     2.616    74.969     0.200
     2.634    77.801     0.200
     2.657    77.801     0.200
     2.687    79.730     0.200
     2.692    77.500     0.200
     2.715    79.570     0.200
     2.878    84.148     0.200
     2.897    86.180     0.200
     3.188    91.480     0.200
     3.244    92.539     0.200
     4.238   119.711     0.200
     4.616   129.129     0.200
     5.086   151.480     0.200
     7.407   210.320     0.200
     8.082   238.449     0.200
     0.871    27.852     0.200
     0.824    26.309     0.200
     1.197    37.211     0.200
     1.576    47.070     0.200
     1.810    55.250     0.200
     1.987    60.242     0.200
     1.864    60.969     0.200
     2.289    72.949     0.200
     2.289    72.949     0.200
     2.403    71.539     0.200
     2.529    75.059     0.200
     2.536    74.250     0.200
     2.682    77.969     0.200
     2.599    77.531     0.200
     2.820    82.039     0.200
     2.850    82.930     0.200
     2.850    82.730     0.200
     2.857    86.379     0.200
     2.871    85.480     0.200
     2.892    84.301     0.200
     2.957    85.289     0.200
     2.974    85.770     0.200
     2.984    86.559     0.200
     3.032    87.852     0.200
     3.131    91.180     0.200
     3.316    96.770     0.200
     3.363    99.789     0.200
     3.387    97.539     0.200
     4.275   123.430     0.200
     4.443   128.070     0.200
     5.485   166.750     0.200
     6.112   182.191     0.200
     0.110    11.391     0.200
     0.323    14.875     0.200
     0.698    24.008     0.200
     0.726    24.172     0.200
     0.807    26.141     0.200
     0.819    26.711     0.200
     1.011    31.211     0.200
     0.957    30.266     0.200
     0.991    31.734     0.200
     1.393    43.477     0.200
     1.596    49.062     0.200
     1.735    52.820     0.200
     1.811    54.203     0.200
     2.016    59.227     0.200
     2.210    65.242     0.200
     2.445    71.516     0.200
     2.450    72.797     0.200
     2.697    78.031     0.200
     3.690   104.133     0.200
     3.731   105.047     0.200
     4.508   131.906     0.200
     0.421    14.595     0.200
     1.268    38.085     0.200
     1.724    51.375     0.200
     1.731    53.274     0.200
     1.818    53.734     0.200
     1.780    55.085     0.200
     1.780    53.085     0.200
     1.852    56.125     0.200
     1.971    60.484     0.200
     2.224    67.074     0.200
     2.286    66.715     0.200
     2.555    74.395     0.200
     2.566    74.314     0.200
     2.598    75.324     0.200
     2.601    76.484     0.200
     2.617    75.385     0.200
     2.619    75.895     0.200
     2.671    78.204     0.200
     2.670    78.204     0.200
     2.670    79.295     0.200
     2.671    77.104     0.200
     2.694    78.664     0.200
     2.694    77.564     0.200
     2.676    79.484     0.200
     2.665    78.645     0.200
     2.716    81.335     0.200
     2.651    76.704     0.200
     2.650    76.704     0.200
     2.745    79.604     0.200
     2.658    76.925     0.200
     2.703    78.005     0.200
     2.678    77.444     0.200
     2.791    81.625     0.200
     2.809    81.335     0.200
     2.839    81.475     0.200
     2.938    84.324     0.200
     3.106    88.494     0.200
     3.164    93.484     0.200
     3.172    93.204     0.200
     3.420   103.835     0.200
     3.420   100.814     0.200
     3.645   103.225     0.200
     3.646   103.225     0.200
     4.887   145.385     0.200
     4.902   144.555     0.200
     4.971   149.265     0.200
     5.221   147.595     0.200
     5.134   144.284     0.200
     6.008   175.784     0.200
     0.231    12.641     0.200
     0.342    14.562     0.200
     0.360    15.520     0.200
     0.366    15.410     0.200
     0.438    17.352     0.200
     0.853    27.602     0.200
     1.186    36.520     0.200
     1.316    41.480     0.200
     1.378    42.492     0.200
     1.708    51.430     0.200
     1.921    56.730     0.200
     1.986    58.891     0.200
     2.188    66.531     0.200
     2.193    65.043     0.200
     2.193    67.461     0.200
     2.259    65.762     0.200
     2.288    70.062     0.200
     2.322    68.621     0.200
     2.468    74.590     0.200
     2.500    76.281     0.200
     2.560    75.602     0.200
     2.569    74.840     0.200
     2.693    80.500     0.200
     2.783    78.770     0.200
     2.860    81.461     0.200
     3.249    94.582     0.200
     0.226     9.777     0.200
     0.334    13.277     0.200
     0.753    25.957     0.200
     1.036    31.836     0.200
     1.232    36.217     0.200
     1.245    37.477     0.200
     1.717    51.746     0.200
     1.744    51.207     0.200
     2.250    64.977     0.200
     2.739    79.768     0.200
     3.161    92.348     0.200
     0.019    10.555     0.200
     0.255    12.328     0.200
     0.401    16.703     0.200
     0.616    21.625     0.200
     1.058    32.633     0.200
     0.047    10.711     0.200
     0.268    13.723     0.200
     0.734    24.844     0.200
     0.865    28.434     0.200
     1.017    32.641     0.200
     1.177    36.801     0.200
     1.300    41.043     0.200
     1.338    41.500     0.200
     1.371    42.293     0.200
     1.630    50.883     0.200
     1.583    47.910     0.200
     1.703    52.684     0.200
     1.840    54.012     0.200
     1.887    55.891     0.200
     1.891    56.383     0.200
     1.950    58.352     0.200
     2.235    68.820     0.200
     2.228    69.941     0.200
     2.309    67.781     0.200
     2.650    80.203     0.200
     2.820    85.160     0.200
     4.429   124.941     0.200
     4.481   126.730     0.200
     0.258    12.844     0.200
     0.319    14.645     0.200
     0.387    16.225     0.200
     0.391    15.754     0.200
     0.957    29.854     0.200
     1.151    35.725     0.200
     1.319    42.014     0.200
     1.333    41.164     0.200
     1.449    43.043     0.200
     1.952    57.164     0.200
     2.151    62.764     0.200
     2.160    62.023     0.200
     2.196    64.994     0.200
     2.201    66.254     0.200
     2.243    66.225     0.200
     2.249    68.314     0.200
     2.249    65.064     0.200
     2.284    67.055     0.200
     2.286    67.543     0.200
     2.288    66.693     0.200
     2.295    67.463     0.200
     2.313    69.334     0.200
     2.326    67.373     0.200
     2.343    68.395     0.200
     2.437    72.254     0.200
     2.490    72.113     0.200
     2.589    73.754     0.200
     2.732    77.344     0.200
     2.796    79.064     0.200
     2.972    85.033     0.200
     3.355    94.234     0.200
     3.542   101.725     0.200
     0.141     8.039     0.200
     0.283    10.949     0.200
     0.536    18.100     0.200
     0.630    22.129     0.200
     0.758    24.379     0.200
     1.557    47.418     0.200
     1.595    47.430     0.200
     1.636    49.158     0.200
     1.637    49.738     0.200
     1.945    58.109     0.200
     2.150    63.328     0.200
     2.152    63.498     0.200
     2.170    63.889     0.200
     2.192    63.430     0.200
     2.274    66.850     0.200
     2.474    73.398     0.200
     2.498    72.639     0.200
     2.539    75.908     0.200
     2.598    75.479     0.200
     2.611    78.568     0.200
     2.612    76.600     0.200
     2.738    79.748     0.200
     2.837    82.318     0.200
     2.854    81.939     0.200
     2.916    84.508     0.200
     3.585   101.680     0.200
     4.223   120.748     0.200
     8.094   232.939     0.200
     0.170    11.875     0.200
     0.210    12.125     0.200
     0.207    12.512     0.200
     0.390    16.305     0.200
     0.562    20.645     0.200
     0.778    25.531     0.200
     0.872    27.773     0.200
     1.280    39.531     0.200
     1.326    40.234     0.200
     1.619    47.793     0.200
     1.843    55.383     0.200
     1.899    57.984     0.200
     1.926    57.703     0.200
     2.100    62.023     0.200
     2.197    64.645     0.200
     2.222    66.965     0.200
     2.227    69.543     0.200
     2.235    69.973     0.200
     2.245    69.531     0.200
     2.259    69.953     0.200
     2.273    69.395     0.200
     2.298    66.895     0.200
     2.334    71.504     0.200
     2.461    74.594     0.200
     2.867    81.332     0.200
     2.884    82.043     0.200
     3.755   108.074     0.200
     4.361   129.332     0.200
     0.637    21.062     0.200
     1.619    49.070     0.200
     1.772    57.680     0.200
     2.816    84.289     0.200
     4.198   121.773     0.200
     0.239    11.830     0.200
     0.256    12.699     0.200
     0.379    14.859     0.200
     0.528    18.119     0.200
     0.828    26.770     0.200
     1.199    38.619     0.200
     1.325    41.590     0.200
     1.843    55.250     0.200
     1.839    54.199     0.200
     1.876    55.160     0.200
     2.273    65.080     0.200
     2.300    66.461     0.200
     2.815    80.561     0.200
     3.240    92.400     0.200
     0.169     9.375     0.200
     0.435    15.977     0.200
     0.885    28.648     0.200
     1.362    41.148     0.200
     1.485    44.695     0.200
     1.564    46.688     0.200
     1.603    49.266     0.200
     1.603    48.914     0.200
     1.729    54.375     0.200
     1.892    56.086     0.200
     2.131    66.125     0.200
     2.197    65.617     0.200
     2.228    66.594     0.200
     2.242    65.648     0.200
     2.373    70.555     0.200
     2.400    70.180     0.200
     2.481    71.680     0.200
     2.537    74.258     0.200
     2.545    77.234     0.200
     2.601    75.344     0.200
     2.636    75.664     0.200
     2.681    80.055     0.200
     2.747    80.875     0.200
     2.770    79.523     0.200
     2.778    79.234     0.200
     2.820    81.125     0.200
     2.851    83.758     0.200
     2.904    83.203     0.200
     3.021    85.727     0.200
     3.123    91.945     0.200
     3.195    90.469     0.200
     3.273    96.297     0.200
     3.600   103.438     0.200
     4.100   118.195     0.200
     4.157   119.266     0.200
     0.122     8.611     0.200
     0.367    14.691     0.200
     0.510    16.451     0.200
     0.859    27.973     0.200
     1.412    44.121     0.200
     1.564    49.383     0.200
     1.651    51.361     0.200
     2.057    61.861     0.200
     2.151    62.621     0.200
     2.176    62.963     0.200
     2.304    68.531     0.200
     2.398    69.611     0.200
     2.440    70.072     0.200
     2.465    71.861     0.200
     2.493    73.572     0.200
     2.510    72.643     0.200
     2.528    76.701     0.200
     2.528    76.701     0.200
     2.545    73.191     0.200
     2.545    74.271     0.200
     2.591    74.682     0.200
     2.596    76.562     0.200
     2.611    75.242     0.200
     2.648    78.682     0.200
     2.679    76.771     0.200
     2.687    77.652     0.200
     2.729    80.861     0.200
     2.983    88.158     0.200
     3.055    89.682     0.200
     3.090    91.422     0.200
     3.509    98.982     0.200
     3.510    98.982     0.200
     0.302    10.793     0.200
     0.519    17.035     0.200
     0.553    19.574     0.200
     0.988    31.793     0.200
     1.521    45.383     0.200
     1.740    53.363     0.200
     1.721    53.773     0.200
     1.721    53.664     0.200
     1.846    57.844     0.200
     2.275    69.324     0.200
     2.342    73.445     0.200
     2.617    77.242     0.200
     2.623    76.273     0.200
     2.655    80.465     0.200
     2.662    80.555     0.200
     2.665    79.965     0.200
     2.670    78.883     0.200
     2.690    78.262     0.200
     2.697    80.883     0.200
     2.707    80.254     0.200
     2.720    81.582     0.200
     2.748    81.582     0.200
     2.776    83.172     0.200
     2.795    83.492     0.200
     2.830    84.242     0.200
     2.856    83.762     0.200
     2.930    84.184     0.200
     3.000    88.172     0.200
     2.991    89.453     0.200
     3.139    93.035     0.200
     3.218    92.934     0.200
     3.211    96.875     0.200
     3.241    97.293     0.200
     4.274   120.125     0.200
     0.288    12.282     0.200
     1.303    41.282     0.200
     1.558    46.022     0.200
     1.558    46.782     0.200
     1.671    50.103     0.200
     1.931    56.152     0.200
     2.354    67.763     0.200
     2.354    68.322     0.200
     2.380    69.143     0.200
     2.391    69.183     0.200
     2.421    73.322     0.200
     2.473    71.593     0.200
     2.534    75.093     0.200
     2.534    75.093     0.200
     2.596    74.223     0.200
     2.654    75.893     0.200
     2.791    79.702     0.200
     2.811    83.822     0.200
     3.748   108.072     0.200
     0.103     8.447     0.200
     0.429    14.877     0.200
     0.651    21.657     0.200
     0.724    24.197     0.200
     1.453    43.257     0.200
     1.588    49.027     0.200
     1.596    48.617     0.200
     2.167    67.857     0.200
     2.393    75.257     0.200
     2.445    72.827     0.200
     2.468    75.257     0.200
     2.483    75.317     0.200
     2.503    75.257     0.200
     2.500    73.257     0.200
     2.517    72.597     0.200
     2.620    78.867     0.200
     2.720    78.987     0.200
     2.750    80.707     0.200
     4.371   121.967     0.200
     4.448   125.057     0.200
     4.838   135.367     0.200
     6.473   183.726     0.200
     0.293    12.101     0.200
     0.610    20.120     0.200
     1.459    43.910     0.200
     1.459    45.110     0.200
     1.570    47.641     0.200
     1.589    50.341     0.200
     1.661    50.360     0.200
     1.771    53.160     0.200
     2.084    63.460     0.200
     2.120    64.290     0.200
     2.127    63.131     0.200
     2.144    65.051     0.200
     2.263    71.181     0.200
     2.378    74.320     0.200
     2.417    70.110     0.200
     2.430    74.320     0.200
     2.445    76.511     0.200
     2.452    75.950     0.200
     2.456    74.170     0.200
     2.467    75.650     0.200
     2.478    76.311     0.200
     2.486    74.320     0.200
     2.491    73.650     0.200
     2.493    74.320     0.200
     2.497    77.641     0.200
     2.508    75.150     0.200
     2.509    75.150     0.200
     2.550    76.980     0.200
     2.549    75.920     0.200
     2.595    77.641     0.200
     2.682    78.061     0.200
     2.772    84.290     0.200
     2.819    83.381     0.200
     2.978    85.761     0.200
     3.046    90.330     0.200
     3.046    90.330     0.200
     3.086    93.771     0.200
     3.274    96.250     0.200
     3.274    93.591     0.200
     3.518   104.320     0.200
     3.519   104.320     0.200
     4.369   122.141     0.200
     4.407   125.450     0.200
     5.589   155.990     0.200
     0.260    11.532     0.200
     0.577    20.182     0.200
     1.426    42.731     0.200
     1.426    44.892     0.200
     1.504    46.151     0.200
     1.548    48.412     0.200
     1.635    48.361     0.200
     1.786    52.552     0.200
     2.070    62.731     0.200
     2.054    62.651     0.200
     2.054    64.972     0.200
     2.081    64.032     0.200
     2.096    63.322     0.200
     2.198    66.012     0.200
     2.260    69.432     0.200
     2.319    74.322     0.200
     2.350    71.812     0.200
     2.370    75.592     0.200
     2.385    75.702     0.200
     2.393    75.292     0.200
     2.390    74.782     0.200
     2.400    72.622     0.200
     2.400    73.392     0.200
     2.426    74.012     0.200
     2.434    77.822     0.200
     2.435    75.282     0.200
     2.435    75.912     0.200
     2.449    77.492     0.200
     2.484    77.691     0.200
     2.754    83.142     0.200
     2.754    83.562     0.200
     2.842    84.111     0.200
     2.993    87.202     0.200
     3.047    88.572     0.200
     3.224    97.872     0.200
     3.452   100.632     0.200
     3.453   100.632     0.200
     4.323   125.682     0.200
     4.484   125.782     0.200
     5.511   153.602     0.200
     0.100     8.977     0.200
     0.110     8.918     0.200
     0.541    19.176     0.200
     0.591    20.168     0.200
     1.401    43.426     0.200
     1.469    43.527     0.200
     1.613    48.637     0.200
     1.890    59.215     0.200
     2.033    58.977     0.200
     2.306    66.258     0.200
     2.486    71.715     0.200
     2.567    73.926     0.200
     2.963    84.945     0.200
     0.137     6.315     0.200
     0.459    15.315     0.200
     0.634    20.895     0.200
     0.707    23.425     0.200
     0.873    27.975     0.200
     1.324    41.425     0.200
     1.725    53.125     0.200
     1.789    55.935     0.200
     1.940    60.805     0.200
     2.042    63.495     0.200
     2.148    68.325     0.200
     2.155    67.485     0.200
     2.200    68.725     0.200
     2.211    68.635     0.200
     2.219    66.525     0.200
     2.222    69.995     0.200
     2.237    66.395     0.200
     2.250    70.755     0.200
     2.256    67.775     0.200
     2.261    69.604     0.200
     2.270    71.035     0.200
     2.366    74.815     0.200
     2.458    73.735     0.200
     0.303    11.633     0.200
     0.515    17.797     0.200
     0.659    22.117     0.200
     0.739    24.375     0.200
     1.226    38.281     0.200
     1.437    45.094     0.200
     1.583    50.031     0.200
     1.648    51.281     0.200
     1.784    54.602     0.200
     1.972    61.375     0.200
     2.021    63.461     0.200
     2.178    64.414     0.200
     2.198    68.383     0.200
     2.204    65.953     0.200
     2.422    75.484     0.200
     2.475    78.945     0.200
     2.493    78.867     0.200
     2.493    79.422     0.200
     2.499    79.805     0.200
     2.514    76.125     0.200
     2.527    76.562     0.200
     2.544    75.578     0.200
     2.624    75.547     0.200
     2.754    83.617     0.200
     2.944    85.188     0.200
     3.127    92.984     0.200
     4.400   122.992     0.200
     4.734   140.883     0.200
     0.264    12.771     0.200
     0.595    20.331     0.200
     0.565    19.411     0.200
     1.163    35.501     0.200
     1.153    36.021     0.200
     1.378    42.301     0.200
     1.603    48.561     0.200
     1.627    50.601     0.200
     1.913    60.521     0.200
     2.383    68.561     0.200
     2.497    73.351     0.200
     2.515    75.671     0.200
     2.882    84.321     0.200
     3.196    96.771     0.200
     5.089   152.511     0.200
     5.239   158.341     0.200
     5.716   171.671     0.200
     0.237    10.988     0.200
     0.424    15.480     0.200
     0.464    16.527     0.200
     1.418    44.160     0.200
     1.400    42.027     0.200
     1.586    47.699     0.200
     1.586    48.930     0.200
     1.584    47.398     0.200
     2.109    62.430     0.200
     2.177    64.539     0.200
     2.235    65.969     0.200
     2.359    67.730     0.200
     2.434    71.188     0.200
     2.484    72.047     0.200
     2.470    71.547     0.200
     2.496    73.047     0.200
     2.506    72.047     0.200
     2.564    74.059     0.200
     2.563    74.070     0.200
     2.592    74.008     0.200
     2.705    77.910     0.200
     2.997    84.969     0.200
     2.961    87.480     0.200
     3.113    87.910     0.200
     3.526   101.547     0.200
     3.525   101.547     0.200
     4.257   118.938     0.200
     0.275    13.242     0.200
     0.341    14.105     0.200
     0.499    18.203     0.200
     0.850    26.855     0.200
     1.224    37.082     0.200
     1.233    37.664     0.200
     1.325    39.914     0.200
     1.364    42.164     0.200
     1.364    41.105     0.200
     0.252    11.039     0.200
     0.415    15.102     0.200
     1.114    33.055     0.200
     1.408    42.867     0.200
     1.519    47.078     0.200
     1.578    48.125     0.200
     1.578    47.859     0.200
     1.587    49.836     0.200
     1.920    57.727     0.200
     2.102    66.195     0.200
     2.126    61.734     0.200
     2.179    63.391     0.200
     2.224    67.117     0.200
     2.496    71.672     0.200
     2.507    73.000     0.200
     2.568    74.086     0.200
     2.568    75.328     0.200
     2.568    75.070     0.200
     2.595    74.461     0.200
     2.634    79.625     0.200
     2.709    78.211     0.200
     2.836    80.609     0.200
     2.991    86.250     0.200
     2.973    89.570     0.200
     3.067    88.469     0.200
     0.331    12.344     0.200
     0.788    25.344     0.200
     1.003    30.828     0.200
     1.210    36.969     0.200
     1.762    52.547     0.200
     1.898    56.328     0.200
     2.232    64.523     0.200
     2.491    71.922     0.200
     2.491    71.922     0.200
     2.622    75.727     0.200
     2.647    76.273     0.200
     2.702    77.398     0.200
     0.210    12.309     0.200
     0.209    12.250     0.200
     0.589    21.301     0.200
     0.879    28.301     0.200
     1.029    32.379     0.200
     1.322    40.762     0.200
     1.514    45.602     0.200
     1.606    47.230     0.200
     1.938    55.949     0.200
     2.082    61.660     0.200
     2.192    63.719     0.200
     2.247    64.809     0.200
     2.249    65.750     0.200
     2.276    67.309     0.200
     2.311    67.012     0.200
     2.333    66.711     0.200
     2.363    68.961     0.200
     2.383    69.410     0.200
     2.420    70.910     0.200
     2.427    71.109     0.200
     2.581    74.750     0.200
     2.552    74.980     0.200
     2.730    78.691     0.200
     0.289    10.797     0.200
     0.307    11.068     0.200
     0.465    15.027     0.200
     0.869    28.947     0.200
     1.380    42.607     0.200
     1.935    59.318     0.200
     1.970    60.127     0.200
     2.109    65.088     0.200
     2.210    67.447     0.200
     2.196    67.008     0.200
     2.257    69.807     0.200
     2.270    69.828     0.200
     2.289    69.498     0.200
     2.299    68.227     0.200
     2.309    70.648     0.200
     2.330    71.637     0.200
     2.331    71.598     0.200
     2.353    69.357     0.200
     2.362    72.418     0.200
     2.361    69.428     0.200
     2.351    71.547     0.200
     2.327    73.438     0.200
     2.404    75.367     0.200
     2.413    73.148     0.200
     2.495    76.777     0.200
     2.503    76.137     0.200
     2.576    78.027     0.200
     2.630    79.477     0.200
     2.672    80.518     0.200
     2.835    83.918     0.200
     2.818    85.348     0.200
     2.907    88.408     0.200
     2.947    88.068     0.200
     3.073    92.027     0.200
     3.325    95.617     0.200
     3.815   115.738     0.200
     4.112   117.857     0.200
     4.355   124.318     0.200
     0.148    10.443     0.200
     0.181    11.305     0.200
     0.635    21.113     0.200
     0.935    29.854     0.200
     1.047    32.824     0.200
     1.193    36.594     0.200
     1.372    41.773     0.200
     1.571    47.994     0.200
     1.668    50.564     0.200
     1.991    58.184     0.200
     2.222    64.824     0.200
     2.399    71.693     0.200
     2.435    71.145     0.200
     2.441    70.443     0.200
     2.584    74.385     0.200
     2.640    77.273     0.200
     0.228    12.613     0.200
     0.309    14.543     0.200
     0.480    18.023     0.200
     0.844    28.023     0.200
     1.080    34.082     0.200
     1.302    39.562     0.200
     1.825    53.953     0.200
     2.253    64.914     0.200
     2.277    65.055     0.200
     2.316    66.465     0.200
     2.415    68.844     0.200
     2.480    71.543     0.200
     2.544    72.324     0.200
     2.755    79.402     0.200
     2.836    82.422     0.200
     0.364    11.375     0.200
     1.122    36.594     0.200
     1.300    41.336     0.200
     1.765    54.406     0.200
     1.813    56.074     0.200
     1.845    58.316     0.200
     1.896    58.457     0.200
     2.026    62.055     0.200
     2.544    75.504     0.200
     2.546    75.684     0.200
     2.547    76.137     0.200
     2.615    77.645     0.200
     2.726    80.664     0.200
     2.782    82.457     0.200
     0.307    14.148     0.200
     0.375    15.707     0.200
     0.499    18.586     0.200
     0.769    26.047     0.200
     0.879    28.207     0.200
     1.149    36.246     0.200
     1.244    38.117     0.200
     1.332    40.887     0.200
     1.538    46.457     0.200
     1.788    54.887     0.200
     1.834    54.297     0.200
     2.048    60.246     0.200
     2.079    62.066     0.200
     2.120    61.086     0.200
     2.136    61.996     0.200
     2.155    64.918     0.200
     2.162    63.129     0.200
     2.165    64.918     0.200
     2.195    63.328     0.200
     2.220    66.898     0.200
     2.225    65.258     0.200
     2.268    65.566     0.200
     2.271    65.227     0.200
     2.494    73.418     0.200
     2.545    75.176     0.200
     2.761    78.598     0.200
     2.771    82.707     0.200
     0.492    17.367     0.200
     0.900    29.406     0.200
     1.585    49.039     0.200
     1.604    51.566     0.200
     2.110    62.996     0.200
     2.195    65.867     0.200
     2.226    65.387     0.200
     2.357    69.398     0.200
     2.427    70.387     0.200
     2.492    72.078     0.200
     2.521    74.449     0.200
     2.408    69.328     0.200
     2.524    74.109     0.200
     2.534    74.398     0.200
     2.555    75.488     0.200
     2.570    74.746     0.200
     2.554    74.727     0.200
     2.585    77.168     0.200
     2.585    76.359     0.200
     2.613    76.898     0.200
     2.613    77.488     0.200
     2.629    76.738     0.200
     2.631    77.270     0.200
     2.638    77.488     0.200
     2.650    77.609     0.200
     2.689    78.629     0.200
     2.720    79.109     0.200
     2.726    79.258     0.200
     2.799    81.469     0.200
     2.854    82.199     0.200
     2.883    83.520     0.200
     2.999    85.488     0.200
     3.132    89.379     0.200
     3.108    90.430     0.200
     3.098    88.559     0.200
     3.548   101.340     0.200
     0.575    20.008     0.200
     1.338    42.234     0.200
     1.441    43.523     0.200
     1.747    53.195     0.200
     1.825    53.914     0.200
     1.866    56.109     0.200
     1.893    55.562     0.200
     2.034    60.164     0.200
     2.381    68.836     0.200
     2.454    70.586     0.200
     2.596    75.242     0.200
     2.606    75.906     0.200
     2.606    75.906     0.200
     2.669    77.922     0.200
     2.693    77.898     0.200
     2.740    77.898     0.200
     2.689    77.898     0.200
     2.752    78.586     0.200
     2.715    77.898     0.200
     2.818    80.555     0.200
     2.832    80.984     0.200
     2.855    81.883     0.200
     2.858    82.547     0.200
     2.878    82.547     0.200
     2.908    82.547     0.200
     2.946    84.547     0.200
     2.951    84.547     0.200
     2.964    84.547     0.200
EOF
# Lg arrivals
gmt plot $proj $reg -Sc -Wthin,cyan << EOF
    24.130   650.172     0.200
    12.726   402.521     0.200
     5.198   161.293     0.200
    11.591   371.760     0.200
    12.453   397.391     0.200
    18.495   588.963     0.200
    21.844   709.014     0.200
    26.361   841.482     0.200
    26.664   851.438     0.200
    30.045   957.098     0.200
    33.153  1057.613     0.200
    33.886  1088.812     0.200
    45.490  1447.037     0.200
    45.983  1462.213     0.200
    46.332  1469.293     0.200
    46.627  1484.787     0.200
    12.735   406.104     0.200
    18.782   598.590     0.200
    26.671   855.152     0.200
    27.063   851.852     0.200
     5.186   159.323     0.200
    12.760   405.975     0.200
    18.799   596.723     0.200
     4.487   139.105     0.200
    12.926   408.316     0.200
    18.989   602.785     0.200
    22.526   726.125     0.200
    27.005   862.727     0.200
    27.146   866.688     0.200
    27.344   873.008     0.200
    31.725  1018.695     0.200
     4.567   141.875     0.200
    12.725   397.047     0.200
     4.541   145.605     0.200
    13.036   414.535     0.200
    19.096   613.465     0.200
     3.768   120.691     0.200
    13.324   420.020     0.200
     2.944    92.352     0.200
     2.953    91.625     0.200
    12.917   412.922     0.200
     2.621    80.910     0.200
     2.727    84.770     0.200
     4.174   133.281     0.200
     4.222   134.262     0.200
     4.296   135.883     0.200
    13.291   421.422     0.200
     2.676    82.273     0.200
     3.257   100.383     0.200
     3.493   113.105     0.200
     4.442   143.199     0.200
     8.894   283.262     0.200
    13.026   416.590     0.200
     2.559    82.488     0.200
     4.570   143.367     0.200
     9.015   284.172     0.200
    13.014   418.645     0.200
     2.654    83.262     0.200
     3.063    93.801     0.200
     3.034    94.680     0.200
     3.234   101.031     0.200
     3.616   114.660     0.200
     3.972   127.180     0.200
     4.543   141.371     0.200
     5.001   156.348     0.200
     5.001   154.680     0.200
     9.443   297.977     0.200
    12.888   415.352     0.200
    18.935   603.121     0.200
     2.858    86.383     0.200
     2.793    84.750     0.200
     2.637    83.285     0.200
     2.766    86.797     0.200
     4.704   147.258     0.200
    13.030   424.223     0.200
     2.946    86.930     0.200
     4.635   145.574     0.200
     3.872   123.531     0.200
     8.364   265.438     0.200
    13.081   416.672     0.200
    19.154   607.906     0.200
    22.896   722.383     0.200
    27.325   860.336     0.200
    27.596   873.094     0.200
     2.846    84.047     0.200
     4.375   136.543     0.200
    13.153   418.453     0.200
     2.544    75.354     0.200
     2.603    76.943     0.200
     2.904    85.582     0.200
     4.675   141.506     0.200
    12.778   402.131     0.200
    18.836   597.777     0.200
     2.613    84.219     0.200
     4.635   145.031     0.200
     2.635    82.691     0.200
     2.635    82.691     0.200
     4.025   123.414     0.200
    13.517   427.520     0.200
     2.664    80.445     0.200
     2.525    79.895     0.200
     2.525    79.895     0.200
     2.544    78.255     0.200
     2.670    82.824     0.200
     2.694    85.324     0.200
     4.737   144.185     0.200
     4.826   148.715     0.200
     4.830   147.104     0.200
     4.837   149.395     0.200
     4.858   148.164     0.200
     4.877   149.835     0.200
    12.752   409.512     0.200
     4.786   146.906     0.200
    18.916   600.359     0.200
     2.593    80.273     0.200
     2.701    82.410     0.200
     3.283   103.262     0.200
     3.698   117.031     0.200
     2.809    83.641     0.200
     4.519   138.812     0.200
    12.669   399.477     0.200
     2.557    76.125     0.200
     4.821   145.406     0.200
    12.653   400.531     0.200
     4.705   144.162     0.200
    13.004   421.219     0.200
    19.060   597.088     0.200
     4.239   128.883     0.200
    13.400   428.227     0.200
    19.467   623.750     0.200
     2.619    81.055     0.200
     2.702    85.086     0.200
     4.953   154.367     0.200
     9.397   292.922     0.200
    12.896   413.344     0.200
     2.612    82.271     0.200
     2.946    90.572     0.200
     4.910   151.227     0.200
     9.374   294.982     0.200
    12.825   405.182     0.200
    18.876   593.301     0.200
     9.898   311.479     0.200
    12.358   390.904     0.200
     2.507    78.695     0.200
     2.785    84.914     0.200
     3.307   100.855     0.200
     3.305   100.855     0.200
     3.324   101.523     0.200
     5.062   156.031     0.200
     9.493   292.633     0.200
    11.987   383.129     0.200
    12.922   405.789     0.200
    18.965   602.527     0.200
     2.653    80.008     0.200
     3.902   120.691     0.200
     2.716    81.055     0.200
    11.836   373.959     0.200
    12.575   393.205     0.200
     2.664    80.195     0.200
     2.525    77.407     0.200
     2.575    82.387     0.200
     2.643    81.607     0.200
     2.617    80.301     0.200
     2.617    82.290     0.200
     2.884    88.271     0.200
    12.884   400.614     0.200
     2.530    79.542     0.200
     2.552    78.182     0.200
     2.552    81.262     0.200
     2.617    80.342     0.200
     2.617    80.592     0.200
     2.675    84.582     0.200
     2.706    83.252     0.200
     2.706    83.602     0.200
     2.817    86.572     0.200
     2.817    88.651     0.200
     3.022    93.072     0.200
     4.807   146.336     0.200
     4.625   144.168     0.200
     2.554    80.205     0.200
     2.597    80.075     0.200
     2.685    83.935     0.200
     2.510    76.977     0.200
     2.533    79.312     0.200
     2.535    77.758     0.200
     2.553    81.023     0.200
     2.565    80.586     0.200
     2.659    82.906     0.200
     2.670    83.867     0.200
     2.694    82.367     0.200
     2.772    86.352     0.200
     2.864    89.203     0.200
     2.983    92.086     0.200
    19.057   600.672     0.200
     2.519    80.171     0.200
     2.519    80.171     0.200
     2.514    81.411     0.200
     2.539    83.171     0.200
     2.599    79.791     0.200
     2.615    82.741     0.200
     2.630    83.951     0.200
     2.646    86.261     0.200
     2.670    83.271     0.200
     2.728    84.471     0.200
     2.749    85.481     0.200
     2.762    86.091     0.200
     2.831    90.221     0.200
     2.869    88.741     0.200
     3.103    96.851     0.200
     3.746   114.301     0.200
     3.809   119.031     0.200
     4.669   142.280     0.200
     4.694   143.051     0.200
     5.351   163.891     0.200
     6.350   192.681     0.200
    13.009   403.111     0.200
    12.810   400.910     0.200
     3.073    92.309     0.200
     3.125    97.789     0.200
     4.456   141.062     0.200
    13.126   414.547     0.200
     2.909    90.027     0.200
     3.092    95.127     0.200
     3.771   115.018     0.200
     3.925   119.957     0.200
     2.816    86.190     0.200
     5.002   152.348     0.200
    12.535   393.780     0.200
     4.422   138.609     0.200
    13.277   422.191     0.200
    19.339   610.500     0.200
     2.813    82.738     0.200
     4.959   151.945     0.200
    12.840   402.844     0.200
    18.888   595.688     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
     0.180     7.806     0.200
     0.250     9.625     0.200
     1.452    43.745     0.200
     1.972    58.325     0.200
     2.110    62.355     0.200
     2.358    68.686     0.200
     2.499    72.545     0.200
     2.499    73.726     0.200
     4.429   125.195     0.200
     0.168    11.354     0.200
     0.977    32.393     0.200
     1.411    44.143     0.200
     2.031    59.344     0.200
     2.371    67.773     0.200
     2.451    71.273     0.200
     2.451    70.773     0.200
     0.168     8.387     0.200
     1.533    46.996     0.200
     1.440    44.188     0.200
     2.365    68.477     0.200
     2.367    68.477     0.200
     0.154    10.113     0.200
     0.397    15.723     0.200
     1.212    36.953     0.200
     1.377    41.453     0.200
     2.280    65.353     0.200
     0.682    22.086     0.200
     1.012    32.676     0.200
     1.475    44.547     0.200
     1.553    46.715     0.200
     2.000    59.406     0.200
     2.326    67.055     0.200
     2.435    69.957     0.200
     2.586    73.695     0.200
     2.719    76.996     0.200
     0.274    11.031     0.200
     0.677    22.090     0.200
     1.646    49.262     0.200
     1.480    46.402     0.200
     2.461    76.301     0.200
     2.568    76.449     0.200
     4.270   121.922     0.200
     5.113   148.641     0.200
     6.292   182.039     0.200
     0.865    29.602     0.200
     1.023    31.652     0.200
     1.094    35.211     0.200
     2.010    59.711     0.200
     2.176    63.871     0.200
     2.337    66.770     0.200
     1.011    31.422     0.200
     1.185    36.211     0.200
     1.478    44.078     0.200
     1.538    45.422     0.200
     2.040    62.148     0.200
     2.338    73.898     0.200
     2.455    73.148     0.200
     2.612    74.711     0.200
     2.679    80.539     0.200
     3.417    99.758     0.200
     4.581   136.500     0.200
     0.242     9.777     0.200
     1.019    31.788     0.200
     1.287    39.348     0.200
     1.436    42.888     0.200
     0.594    19.859     0.200
     0.997    30.891     0.200
     1.181    35.500     0.200
     1.797    53.250     0.200
     2.554    77.719     0.200
     0.358    13.254     0.200
     1.564    48.934     0.200
     1.655    50.504     0.200
     2.076    62.645     0.200
     2.390    74.785     0.200
     5.891   172.156     0.200
     0.240    10.809     0.200
     0.642    21.469     0.200
     1.594    48.770     0.200
     1.594    49.770     0.200
     1.620    48.438     0.200
     2.128    64.656     0.200
     3.551   106.527     0.200
     0.215     9.871     0.200
     0.285    11.191     0.200
     1.674    52.230     0.200
     1.526    47.832     0.200
     4.377   126.242     0.200
     5.406   160.402     0.200
     0.626    22.617     0.200
     0.553    18.238     0.200
     1.187    35.035     0.200
     1.422    42.855     0.200
     1.422    45.648     0.200
     1.627    48.238     0.200
     2.148    62.445     0.200
     2.180    63.828     0.200
     2.216    64.156     0.200
     2.925    83.258     0.200
     3.140    94.527     0.200
     3.161    91.828     0.200
     4.362   127.809     0.200
     4.249   120.527     0.200
     4.537   128.746     0.200
     0.294    12.479     0.200
     0.372    13.348     0.200
     0.461    16.367     0.200
     0.864    27.518     0.200
     0.929    29.729     0.200
     1.222    36.637     0.200
     1.675    49.688     0.200
     1.686    52.229     0.200
     1.724    52.947     0.200
     1.788    54.928     0.200
     1.817    58.037     0.200
     1.918    57.467     0.200
     2.170    64.637     0.200
     2.135    65.309     0.200
     2.236    71.168     0.200
     2.289    69.617     0.200
     2.309    73.059     0.200
     2.468    75.867     0.200
     2.595    76.527     0.200
     2.632    78.408     0.200
     2.652    77.217     0.200
     2.641    75.898     0.200
     4.087   117.387     0.200
     4.825   137.668     0.200
     0.190     8.988     0.200
     0.167     8.391     0.200
     0.249    10.422     0.200
     0.811    25.852     0.200
     1.499    46.059     0.200
     1.611    48.832     0.200
     1.618    49.820     0.200
     1.883    55.672     0.200
     1.922    57.410     0.200
     2.080    60.480     0.200
     2.156    63.531     0.200
     2.162    62.910     0.200
     2.177    67.781     0.200
     2.501    74.680     0.200
     2.502    75.000     0.200
     2.504    74.340     0.200
     2.588    74.898     0.200
     2.588    76.320     0.200
     2.601    74.672     0.200
     2.616    74.969     0.200
     2.634    77.801     0.200
     2.657    77.801     0.200
     2.687    79.730     0.200
     2.692    77.500     0.200
     2.715    79.570     0.200
     2.878    84.148     0.200
     2.897    86.180     0.200
     3.188    91.480     0.200
     3.244    92.539     0.200
     4.238   119.711     0.200
     4.616   129.129     0.200
     5.086   151.480     0.200
     7.407   210.320     0.200
     8.082   238.449     0.200
     0.871    27.852     0.200
     0.824    26.309     0.200
     1.197    37.211     0.200
     1.576    47.070     0.200
     1.810    55.250     0.200
     1.987    60.242     0.200
     1.864    60.969     0.200
     2.289    72.949     0.200
     2.289    72.949     0.200
     2.403    71.539     0.200
     2.529    75.059     0.200
     2.536    74.250     0.200
     2.682    77.969     0.200
     2.599    77.531     0.200
     2.820    82.039     0.200
     2.850    82.930     0.200
     2.850    82.730     0.200
     2.857    86.379     0.200
     2.871    85.480     0.200
     2.892    84.301     0.200
     2.957    85.289     0.200
     2.974    85.770     0.200
     2.984    86.559     0.200
     3.032    87.852     0.200
     3.131    91.180     0.200
     3.316    96.770     0.200
     3.363    99.789     0.200
     3.387    97.539     0.200
     4.275   123.430     0.200
     4.443   128.070     0.200
     5.485   166.750     0.200
     6.112   182.191     0.200
     0.110    11.391     0.200
     0.323    14.875     0.200
     0.698    24.008     0.200
     0.726    24.172     0.200
     0.807    26.141     0.200
     0.819    26.711     0.200
     1.011    31.211     0.200
     0.957    30.266     0.200
     0.991    31.734     0.200
     1.393    43.477     0.200
     1.596    49.062     0.200
     1.735    52.820     0.200
     1.811    54.203     0.200
     2.016    59.227     0.200
     2.210    65.242     0.200
     2.445    71.516     0.200
     2.450    72.797     0.200
     2.697    78.031     0.200
     3.690   104.133     0.200
     3.731   105.047     0.200
     4.508   131.906     0.200
     0.421    14.595     0.200
     1.268    38.085     0.200
     1.724    51.375     0.200
     1.731    53.274     0.200
     1.818    53.734     0.200
     1.780    55.085     0.200
     1.780    53.085     0.200
     1.852    56.125     0.200
     1.971    60.484     0.200
     2.224    67.074     0.200
     2.286    66.715     0.200
     2.555    74.395     0.200
     2.566    74.314     0.200
     2.598    75.324     0.200
     2.601    76.484     0.200
     2.617    75.385     0.200
     2.619    75.895     0.200
     2.671    78.204     0.200
     2.670    78.204     0.200
     2.670    79.295     0.200
     2.671    77.104     0.200
     2.694    78.664     0.200
     2.694    77.564     0.200
     2.676    79.484     0.200
     2.665    78.645     0.200
     2.716    81.335     0.200
     2.651    76.704     0.200
     2.650    76.704     0.200
     2.745    79.604     0.200
     2.658    76.925     0.200
     2.703    78.005     0.200
     2.678    77.444     0.200
     2.791    81.625     0.200
     2.809    81.335     0.200
     2.839    81.475     0.200
     2.938    84.324     0.200
     3.106    88.494     0.200
     3.164    93.484     0.200
     3.172    93.204     0.200
     3.420   103.835     0.200
     3.420   100.814     0.200
     3.645   103.225     0.200
     3.646   103.225     0.200
     4.887   145.385     0.200
     4.902   144.555     0.200
     4.971   149.265     0.200
     5.221   147.595     0.200
     5.134   144.284     0.200
     6.008   175.784     0.200
     0.231    12.641     0.200
     0.342    14.562     0.200
     0.360    15.520     0.200
     0.366    15.410     0.200
     0.438    17.352     0.200
     0.853    27.602     0.200
     1.186    36.520     0.200
     1.316    41.480     0.200
     1.378    42.492     0.200
     1.708    51.430     0.200
     1.921    56.730     0.200
     1.986    58.891     0.200
     2.188    66.531     0.200
     2.193    65.043     0.200
     2.193    67.461     0.200
     2.259    65.762     0.200
     2.288    70.062     0.200
     2.322    68.621     0.200
     2.468    74.590     0.200
     2.500    76.281     0.200
     2.560    75.602     0.200
     2.569    74.840     0.200
     2.693    80.500     0.200
     2.783    78.770     0.200
     2.860    81.461     0.200
     3.249    94.582     0.200
     0.226     9.777     0.200
     0.334    13.277     0.200
     0.753    25.957     0.200
     1.036    31.836     0.200
     1.232    36.217     0.200
     1.245    37.477     0.200
     1.717    51.746     0.200
     1.744    51.207     0.200
     2.250    64.977     0.200
     2.739    79.768     0.200
     3.161    92.348     0.200
     0.019    10.555     0.200
     0.255    12.328     0.200
     0.401    16.703     0.200
     0.616    21.625     0.200
     1.058    32.633     0.200
     0.047    10.711     0.200
     0.268    13.723     0.200
     0.734    24.844     0.200
     0.865    28.434     0.200
     1.017    32.641     0.200
     1.177    36.801     0.200
     1.300    41.043     0.200
     1.338    41.500     0.200
     1.371    42.293     0.200
     1.630    50.883     0.200
     1.583    47.910     0.200
     1.703    52.684     0.200
     1.840    54.012     0.200
     1.887    55.891     0.200
     1.891    56.383     0.200
     1.950    58.352     0.200
     2.235    68.820     0.200
     2.228    69.941     0.200
     2.309    67.781     0.200
     2.650    80.203     0.200
     2.820    85.160     0.200
     4.429   124.941     0.200
     4.481   126.730     0.200
     0.258    12.844     0.200
     0.319    14.645     0.200
     0.387    16.225     0.200
     0.391    15.754     0.200
     0.957    29.854     0.200
     1.151    35.725     0.200
     1.319    42.014     0.200
     1.333    41.164     0.200
     1.449    43.043     0.200
     1.952    57.164     0.200
     2.151    62.764     0.200
     2.160    62.023     0.200
     2.196    64.994     0.200
     2.201    66.254     0.200
     2.243    66.225     0.200
     2.249    68.314     0.200
     2.249    65.064     0.200
     2.284    67.055     0.200
     2.286    67.543     0.200
     2.288    66.693     0.200
     2.295    67.463     0.200
     2.313    69.334     0.200
     2.326    67.373     0.200
     2.343    68.395     0.200
     2.437    72.254     0.200
     2.490    72.113     0.200
     2.589    73.754     0.200
     2.732    77.344     0.200
     2.796    79.064     0.200
     2.972    85.033     0.200
     3.355    94.234     0.200
     3.542   101.725     0.200
     0.141     8.039     0.200
     0.283    10.949     0.200
     0.536    18.100     0.200
     0.630    22.129     0.200
     0.758    24.379     0.200
     1.557    47.418     0.200
     1.595    47.430     0.200
     1.636    49.158     0.200
     1.637    49.738     0.200
     1.945    58.109     0.200
     2.150    63.328     0.200
     2.152    63.498     0.200
     2.170    63.889     0.200
     2.192    63.430     0.200
     2.274    66.850     0.200
     2.474    73.398     0.200
     2.498    72.639     0.200
     2.539    75.908     0.200
     2.598    75.479     0.200
     2.611    78.568     0.200
     2.612    76.600     0.200
     2.738    79.748     0.200
     2.837    82.318     0.200
     2.854    81.939     0.200
     2.916    84.508     0.200
     3.585   101.680     0.200
     4.223   120.748     0.200
     8.094   232.939     0.200
     0.170    11.875     0.200
     0.210    12.125     0.200
     0.207    12.512     0.200
     0.390    16.305     0.200
     0.562    20.645     0.200
     0.778    25.531     0.200
     0.872    27.773     0.200
     1.280    39.531     0.200
     1.326    40.234     0.200
     1.619    47.793     0.200
     1.843    55.383     0.200
     1.899    57.984     0.200
     1.926    57.703     0.200
     2.100    62.023     0.200
     2.197    64.645     0.200
     2.222    66.965     0.200
     2.227    69.543     0.200
     2.235    69.973     0.200
     2.245    69.531     0.200
     2.259    69.953     0.200
     2.273    69.395     0.200
     2.298    66.895     0.200
     2.334    71.504     0.200
     2.461    74.594     0.200
     2.867    81.332     0.200
     2.884    82.043     0.200
     3.755   108.074     0.200
     4.361   129.332     0.200
     0.637    21.062     0.200
     1.619    49.070     0.200
     1.772    57.680     0.200
     2.816    84.289     0.200
     4.198   121.773     0.200
     0.239    11.830     0.200
     0.256    12.699     0.200
     0.379    14.859     0.200
     0.528    18.119     0.200
     0.828    26.770     0.200
     1.199    38.619     0.200
     1.325    41.590     0.200
     1.843    55.250     0.200
     1.839    54.199     0.200
     1.876    55.160     0.200
     2.273    65.080     0.200
     2.300    66.461     0.200
     2.815    80.561     0.200
     3.240    92.400     0.200
     0.169     9.375     0.200
     0.435    15.977     0.200
     0.885    28.648     0.200
     1.362    41.148     0.200
     1.485    44.695     0.200
     1.564    46.688     0.200
     1.603    49.266     0.200
     1.603    48.914     0.200
     1.729    54.375     0.200
     1.892    56.086     0.200
     2.131    66.125     0.200
     2.197    65.617     0.200
     2.228    66.594     0.200
     2.242    65.648     0.200
     2.373    70.555     0.200
     2.400    70.180     0.200
     2.481    71.680     0.200
     2.537    74.258     0.200
     2.545    77.234     0.200
     2.601    75.344     0.200
     2.636    75.664     0.200
     2.681    80.055     0.200
     2.747    80.875     0.200
     2.770    79.523     0.200
     2.778    79.234     0.200
     2.820    81.125     0.200
     2.851    83.758     0.200
     2.904    83.203     0.200
     3.021    85.727     0.200
     3.123    91.945     0.200
     3.195    90.469     0.200
     3.273    96.297     0.200
     3.600   103.438     0.200
     4.100   118.195     0.200
     4.157   119.266     0.200
     0.122     8.611     0.200
     0.367    14.691     0.200
     0.510    16.451     0.200
     0.859    27.973     0.200
     1.412    44.121     0.200
     1.564    49.383     0.200
     1.651    51.361     0.200
     2.057    61.861     0.200
     2.151    62.621     0.200
     2.176    62.963     0.200
     2.304    68.531     0.200
     2.398    69.611     0.200
     2.440    70.072     0.200
     2.465    71.861     0.200
     2.493    73.572     0.200
     2.510    72.643     0.200
     2.528    76.701     0.200
     2.528    76.701     0.200
     2.545    73.191     0.200
     2.545    74.271     0.200
     2.591    74.682     0.200
     2.596    76.562     0.200
     2.611    75.242     0.200
     2.648    78.682     0.200
     2.679    76.771     0.200
     2.687    77.652     0.200
     2.729    80.861     0.200
     2.983    88.158     0.200
     3.055    89.682     0.200
     3.090    91.422     0.200
     3.509    98.982     0.200
     3.510    98.982     0.200
     0.302    10.793     0.200
     0.519    17.035     0.200
     0.553    19.574     0.200
     0.988    31.793     0.200
     1.521    45.383     0.200
     1.740    53.363     0.200
     1.721    53.773     0.200
     1.721    53.664     0.200
     1.846    57.844     0.200
     2.275    69.324     0.200
     2.342    73.445     0.200
     2.617    77.242     0.200
     2.623    76.273     0.200
     2.655    80.465     0.200
     2.662    80.555     0.200
     2.665    79.965     0.200
     2.670    78.883     0.200
     2.690    78.262     0.200
     2.697    80.883     0.200
     2.707    80.254     0.200
     2.720    81.582     0.200
     2.748    81.582     0.200
     2.776    83.172     0.200
     2.795    83.492     0.200
     2.830    84.242     0.200
     2.856    83.762     0.200
     2.930    84.184     0.200
     3.000    88.172     0.200
     2.991    89.453     0.200
     3.139    93.035     0.200
     3.218    92.934     0.200
     3.211    96.875     0.200
     3.241    97.293     0.200
     4.274   120.125     0.200
     0.288    12.282     0.200
     1.303    41.282     0.200
     1.558    46.022     0.200
     1.558    46.782     0.200
     1.671    50.103     0.200
     1.931    56.152     0.200
     2.354    67.763     0.200
     2.354    68.322     0.200
     2.380    69.143     0.200
     2.391    69.183     0.200
     2.421    73.322     0.200
     2.473    71.593     0.200
     2.534    75.093     0.200
     2.534    75.093     0.200
     2.596    74.223     0.200
     2.654    75.893     0.200
     2.791    79.702     0.200
     2.811    83.822     0.200
     3.748   108.072     0.200
     0.103     8.447     0.200
     0.429    14.877     0.200
     0.651    21.657     0.200
     0.724    24.197     0.200
     1.453    43.257     0.200
     1.588    49.027     0.200
     1.596    48.617     0.200
     2.167    67.857     0.200
     2.393    75.257     0.200
     2.445    72.827     0.200
     2.468    75.257     0.200
     2.483    75.317     0.200
     2.503    75.257     0.200
     2.500    73.257     0.200
     2.517    72.597     0.200
     2.620    78.867     0.200
     2.720    78.987     0.200
     2.750    80.707     0.200
     4.371   121.967     0.200
     4.448   125.057     0.200
     4.838   135.367     0.200
     6.473   183.726     0.200
     0.293    12.101     0.200
     0.610    20.120     0.200
     1.459    43.910     0.200
     1.459    45.110     0.200
     1.570    47.641     0.200
     1.589    50.341     0.200
     1.661    50.360     0.200
     1.771    53.160     0.200
     2.084    63.460     0.200
     2.120    64.290     0.200
     2.127    63.131     0.200
     2.144    65.051     0.200
     2.263    71.181     0.200
     2.378    74.320     0.200
     2.417    70.110     0.200
     2.430    74.320     0.200
     2.445    76.511     0.200
     2.452    75.950     0.200
     2.456    74.170     0.200
     2.467    75.650     0.200
     2.478    76.311     0.200
     2.486    74.320     0.200
     2.491    73.650     0.200
     2.493    74.320     0.200
     2.497    77.641     0.200
     2.508    75.150     0.200
     2.509    75.150     0.200
     2.550    76.980     0.200
     2.549    75.920     0.200
     2.595    77.641     0.200
     2.682    78.061     0.200
     2.772    84.290     0.200
     2.819    83.381     0.200
     2.978    85.761     0.200
     3.046    90.330     0.200
     3.046    90.330     0.200
     3.086    93.771     0.200
     3.274    96.250     0.200
     3.274    93.591     0.200
     3.518   104.320     0.200
     3.519   104.320     0.200
     4.369   122.141     0.200
     4.407   125.450     0.200
     5.589   155.990     0.200
     0.260    11.532     0.200
     0.577    20.182     0.200
     1.426    42.731     0.200
     1.426    44.892     0.200
     1.504    46.151     0.200
     1.548    48.412     0.200
     1.635    48.361     0.200
     1.786    52.552     0.200
     2.070    62.731     0.200
     2.054    62.651     0.200
     2.054    64.972     0.200
     2.081    64.032     0.200
     2.096    63.322     0.200
     2.198    66.012     0.200
     2.260    69.432     0.200
     2.319    74.322     0.200
     2.350    71.812     0.200
     2.370    75.592     0.200
     2.385    75.702     0.200
     2.393    75.292     0.200
     2.390    74.782     0.200
     2.400    72.622     0.200
     2.400    73.392     0.200
     2.426    74.012     0.200
     2.434    77.822     0.200
     2.435    75.282     0.200
     2.435    75.912     0.200
     2.449    77.492     0.200
     2.484    77.691     0.200
     2.754    83.142     0.200
     2.754    83.562     0.200
     2.842    84.111     0.200
     2.993    87.202     0.200
     3.047    88.572     0.200
     3.224    97.872     0.200
     3.452   100.632     0.200
     3.453   100.632     0.200
     4.323   125.682     0.200
     4.484   125.782     0.200
     5.511   153.602     0.200
     0.100     8.977     0.200
     0.110     8.918     0.200
     0.541    19.176     0.200
     0.591    20.168     0.200
     1.401    43.426     0.200
     1.469    43.527     0.200
     1.613    48.637     0.200
     1.890    59.215     0.200
     2.033    58.977     0.200
     2.306    66.258     0.200
     2.486    71.715     0.200
     2.567    73.926     0.200
     2.963    84.945     0.200
     0.137     6.315     0.200
     0.459    15.315     0.200
     0.634    20.895     0.200
     0.707    23.425     0.200
     0.873    27.975     0.200
     1.324    41.425     0.200
     1.725    53.125     0.200
     1.789    55.935     0.200
     1.940    60.805     0.200
     2.042    63.495     0.200
     2.148    68.325     0.200
     2.155    67.485     0.200
     2.200    68.725     0.200
     2.211    68.635     0.200
     2.219    66.525     0.200
     2.222    69.995     0.200
     2.237    66.395     0.200
     2.250    70.755     0.200
     2.256    67.775     0.200
     2.261    69.604     0.200
     2.270    71.035     0.200
     2.366    74.815     0.200
     2.458    73.735     0.200
     0.303    11.633     0.200
     0.515    17.797     0.200
     0.659    22.117     0.200
     0.739    24.375     0.200
     1.226    38.281     0.200
     1.437    45.094     0.200
     1.583    50.031     0.200
     1.648    51.281     0.200
     1.784    54.602     0.200
     1.972    61.375     0.200
     2.021    63.461     0.200
     2.178    64.414     0.200
     2.198    68.383     0.200
     2.204    65.953     0.200
     2.422    75.484     0.200
     2.475    78.945     0.200
     2.493    78.867     0.200
     2.493    79.422     0.200
     2.499    79.805     0.200
     2.514    76.125     0.200
     2.527    76.562     0.200
     2.544    75.578     0.200
     2.624    75.547     0.200
     2.754    83.617     0.200
     2.944    85.188     0.200
     3.127    92.984     0.200
     4.400   122.992     0.200
     4.734   140.883     0.200
     0.264    12.771     0.200
     0.595    20.331     0.200
     0.565    19.411     0.200
     1.163    35.501     0.200
     1.153    36.021     0.200
     1.378    42.301     0.200
     1.603    48.561     0.200
     1.627    50.601     0.200
     1.913    60.521     0.200
     2.383    68.561     0.200
     2.497    73.351     0.200
     2.515    75.671     0.200
     2.882    84.321     0.200
     3.196    96.771     0.200
     5.089   152.511     0.200
     5.239   158.341     0.200
     5.716   171.671     0.200
     0.237    10.988     0.200
     0.424    15.480     0.200
     0.464    16.527     0.200
     1.418    44.160     0.200
     1.400    42.027     0.200
     1.586    47.699     0.200
     1.586    48.930     0.200
     1.584    47.398     0.200
     2.109    62.430     0.200
     2.177    64.539     0.200
     2.235    65.969     0.200
     2.359    67.730     0.200
     2.434    71.188     0.200
     2.484    72.047     0.200
     2.470    71.547     0.200
     2.496    73.047     0.200
     2.506    72.047     0.200
     2.564    74.059     0.200
     2.563    74.070     0.200
     2.592    74.008     0.200
     2.705    77.910     0.200
     2.997    84.969     0.200
     2.961    87.480     0.200
     3.113    87.910     0.200
     3.526   101.547     0.200
     3.525   101.547     0.200
     4.257   118.938     0.200
     0.275    13.242     0.200
     0.341    14.105     0.200
     0.499    18.203     0.200
     0.850    26.855     0.200
     1.224    37.082     0.200
     1.233    37.664     0.200
     1.325    39.914     0.200
     1.364    42.164     0.200
     1.364    41.105     0.200
     0.252    11.039     0.200
     0.415    15.102     0.200
     1.114    33.055     0.200
     1.408    42.867     0.200
     1.519    47.078     0.200
     1.578    48.125     0.200
     1.578    47.859     0.200
     1.587    49.836     0.200
     1.920    57.727     0.200
     2.102    66.195     0.200
     2.126    61.734     0.200
     2.179    63.391     0.200
     2.224    67.117     0.200
     2.496    71.672     0.200
     2.507    73.000     0.200
     2.568    74.086     0.200
     2.568    75.328     0.200
     2.568    75.070     0.200
     2.595    74.461     0.200
     2.634    79.625     0.200
     2.709    78.211     0.200
     2.836    80.609     0.200
     2.991    86.250     0.200
     2.973    89.570     0.200
     3.067    88.469     0.200
     0.331    12.344     0.200
     0.788    25.344     0.200
     1.003    30.828     0.200
     1.210    36.969     0.200
     1.762    52.547     0.200
     1.898    56.328     0.200
     2.232    64.523     0.200
     2.491    71.922     0.200
     2.491    71.922     0.200
     2.622    75.727     0.200
     2.647    76.273     0.200
     2.702    77.398     0.200
     0.210    12.309     0.200
     0.209    12.250     0.200
     0.589    21.301     0.200
     0.879    28.301     0.200
     1.029    32.379     0.200
     1.322    40.762     0.200
     1.514    45.602     0.200
     1.606    47.230     0.200
     1.938    55.949     0.200
     2.082    61.660     0.200
     2.192    63.719     0.200
     2.247    64.809     0.200
     2.249    65.750     0.200
     2.276    67.309     0.200
     2.311    67.012     0.200
     2.333    66.711     0.200
     2.363    68.961     0.200
     2.383    69.410     0.200
     2.420    70.910     0.200
     2.427    71.109     0.200
     2.581    74.750     0.200
     2.552    74.980     0.200
     2.730    78.691     0.200
     0.289    10.797     0.200
     0.307    11.068     0.200
     0.465    15.027     0.200
     0.869    28.947     0.200
     1.380    42.607     0.200
     1.935    59.318     0.200
     1.970    60.127     0.200
     2.109    65.088     0.200
     2.210    67.447     0.200
     2.196    67.008     0.200
     2.257    69.807     0.200
     2.270    69.828     0.200
     2.289    69.498     0.200
     2.299    68.227     0.200
     2.309    70.648     0.200
     2.330    71.637     0.200
     2.331    71.598     0.200
     2.353    69.357     0.200
     2.362    72.418     0.200
     2.361    69.428     0.200
     2.351    71.547     0.200
     2.327    73.438     0.200
     2.404    75.367     0.200
     2.413    73.148     0.200
     2.495    76.777     0.200
     2.503    76.137     0.200
     2.576    78.027     0.200
     2.630    79.477     0.200
     2.672    80.518     0.200
     2.835    83.918     0.200
     2.818    85.348     0.200
     2.907    88.408     0.200
     2.947    88.068     0.200
     3.073    92.027     0.200
     3.325    95.617     0.200
     3.815   115.738     0.200
     4.112   117.857     0.200
     4.355   124.318     0.200
     0.148    10.443     0.200
     0.181    11.305     0.200
     0.635    21.113     0.200
     0.935    29.854     0.200
     1.047    32.824     0.200
     1.193    36.594     0.200
     1.372    41.773     0.200
     1.571    47.994     0.200
     1.668    50.564     0.200
     1.991    58.184     0.200
     2.222    64.824     0.200
     2.399    71.693     0.200
     2.435    71.145     0.200
     2.441    70.443     0.200
     2.584    74.385     0.200
     2.640    77.273     0.200
     0.228    12.613     0.200
     0.309    14.543     0.200
     0.480    18.023     0.200
     0.844    28.023     0.200
     1.080    34.082     0.200
     1.302    39.562     0.200
     1.825    53.953     0.200
     2.253    64.914     0.200
     2.277    65.055     0.200
     2.316    66.465     0.200
     2.415    68.844     0.200
     2.480    71.543     0.200
     2.544    72.324     0.200
     2.755    79.402     0.200
     2.836    82.422     0.200
     0.364    11.375     0.200
     1.122    36.594     0.200
     1.300    41.336     0.200
     1.765    54.406     0.200
     1.813    56.074     0.200
     1.845    58.316     0.200
     1.896    58.457     0.200
     2.026    62.055     0.200
     2.544    75.504     0.200
     2.546    75.684     0.200
     2.547    76.137     0.200
     2.615    77.645     0.200
     2.726    80.664     0.200
     2.782    82.457     0.200
     0.307    14.148     0.200
     0.375    15.707     0.200
     0.499    18.586     0.200
     0.769    26.047     0.200
     0.879    28.207     0.200
     1.149    36.246     0.200
     1.244    38.117     0.200
     1.332    40.887     0.200
     1.538    46.457     0.200
     1.788    54.887     0.200
     1.834    54.297     0.200
     2.048    60.246     0.200
     2.079    62.066     0.200
     2.120    61.086     0.200
     2.136    61.996     0.200
     2.155    64.918     0.200
     2.162    63.129     0.200
     2.165    64.918     0.200
     2.195    63.328     0.200
     2.220    66.898     0.200
     2.225    65.258     0.200
     2.268    65.566     0.200
     2.271    65.227     0.200
     2.494    73.418     0.200
     2.545    75.176     0.200
     2.761    78.598     0.200
     2.771    82.707     0.200
     0.492    17.367     0.200
     0.900    29.406     0.200
     1.585    49.039     0.200
     1.604    51.566     0.200
     2.110    62.996     0.200
     2.195    65.867     0.200
     2.226    65.387     0.200
     2.357    69.398     0.200
     2.427    70.387     0.200
     2.492    72.078     0.200
     2.521    74.449     0.200
     2.408    69.328     0.200
     2.524    74.109     0.200
     2.534    74.398     0.200
     2.555    75.488     0.200
     2.570    74.746     0.200
     2.554    74.727     0.200
     2.585    77.168     0.200
     2.585    76.359     0.200
     2.613    76.898     0.200
     2.613    77.488     0.200
     2.629    76.738     0.200
     2.631    77.270     0.200
     2.638    77.488     0.200
     2.650    77.609     0.200
     2.689    78.629     0.200
     2.720    79.109     0.200
     2.726    79.258     0.200
     2.799    81.469     0.200
     2.854    82.199     0.200
     2.883    83.520     0.200
     2.999    85.488     0.200
     3.132    89.379     0.200
     3.108    90.430     0.200
     3.098    88.559     0.200
     3.548   101.340     0.200
     0.575    20.008     0.200
     1.338    42.234     0.200
     1.441    43.523     0.200
     1.747    53.195     0.200
     1.825    53.914     0.200
     1.866    56.109     0.200
     1.893    55.562     0.200
     2.034    60.164     0.200
     2.381    68.836     0.200
     2.454    70.586     0.200
     2.596    75.242     0.200
     2.606    75.906     0.200
     2.606    75.906     0.200
     2.669    77.922     0.200
     2.693    77.898     0.200
     2.740    77.898     0.200
     2.689    77.898     0.200
     2.752    78.586     0.200
     2.715    77.898     0.200
     2.818    80.555     0.200
     2.832    80.984     0.200
     2.855    81.883     0.200
     2.858    82.547     0.200
     2.878    82.547     0.200
     2.908    82.547     0.200
     2.946    84.547     0.200
     2.951    84.547     0.200
     2.964    84.547     0.200
EOF
# S-P arrivals
gmt plot $proj $reg -Sc -Wthin,red << EOF
EOF
gmt end
