#!/bin/bash
gmt begin acapulco7.51_tt4_near_source pdf,ps
proj=-JX18/12
reg=-R0/1.0/-10/10
gmt basemap $proj $reg -Bxa0.1f0.1+l'Epicentral Distance (deg)' -Bya5f1g5+l'Travel Time Residual (s)' -BWeSn+t'Near-Source acapulco7.51'
# Distance limit for hypocentroid
gmt plot $proj $reg -Wthick,black,- << EOF
  1.0 -10.0
  1.0 10.0
EOF
# Pg arrivals
gmt plot $proj $reg -Sx -Wthick -Gred << EOF
     0.180     0.225     0.200
     0.250     0.521     0.200
     0.168     0.454     0.200
     0.556    -0.183     0.200
     0.977     0.080     0.200
     0.168     0.125     0.200
     0.154     0.136     0.200
     0.397     0.645     0.200
     0.424     0.657     0.200
     0.682     0.143     0.200
     0.274     0.213     0.200
     0.677     0.197     0.200
     0.865    -0.211     0.200
     0.865    -0.043     0.200
     0.274     0.536     0.200
     0.168     0.121     0.200
     0.242     0.181     0.200
     0.594     0.661     0.200
     0.997    -0.115     0.200
     0.358     0.261     0.200
     0.754     0.311     0.200
     0.240     0.105     0.200
     0.642     0.279     0.200
     0.215     0.055     0.200
     0.285     0.103     0.200
     0.626     1.495     0.200
     0.553     0.164     0.200
     0.294     0.743     0.200
     0.372     0.025     0.200
     0.419     0.042     0.200
     0.929     0.242     0.200
     0.190     0.052     0.200
     0.167     0.169     0.200
     0.249     0.340     0.200
     0.592     0.130     0.200
     0.811    -0.041     0.200
     0.871     0.542     0.200
     0.824     0.487     0.200
     0.110    -0.263     0.200
     0.323     0.050     0.200
     0.698    -0.094     0.200
     0.726    -0.275     0.200
     0.807    -0.586     0.200
     0.819    -0.489     0.200
     0.957    -0.814     0.200
     0.991    -0.540     0.200
     0.421     0.553     0.200
     0.455     0.314     0.200
     0.858     0.419     0.200
     0.231     0.079     0.200
     0.342    -0.101     0.200
     0.360     0.177     0.200
     0.366    -0.168     0.200
     0.438     0.099     0.200
     0.853    -0.517     0.200
     0.226    -0.057     0.200
     0.334     0.149     0.200
     0.513     0.524     0.200
     0.579     0.456     0.200
     0.753     0.430     0.200
     0.019     0.086     0.200
     0.255    -0.120     0.200
     0.616     0.025     0.200
     0.735    -0.356     0.200
     0.047     0.112     0.200
     0.268     0.164     0.200
     0.617    -0.174     0.200
     0.560    -0.048     0.200
     0.734    -0.250     0.200
     0.865    -0.209     0.200
     0.258     0.101     0.200
     0.319     0.281     0.200
     0.387     0.326     0.200
     0.391    -0.221     0.200
     0.850     0.176     0.200
     0.957    -0.643     0.200
     0.283     0.408     0.200
     0.536     0.392     0.200
     0.630     1.155     0.200
     0.758     0.114     0.200
     0.170     0.021     0.200
     0.210    -0.003     0.200
     0.207    -0.016     0.200
     0.390     0.314     0.200
     0.562     0.272     0.200
     0.778    -0.303     0.200
     0.872    -0.525     0.200
     0.270    -0.042     0.200
     0.239     0.245     0.200
     0.256     0.484     0.200
     0.379    -0.018     0.200
     0.528     0.088     0.200
     0.828    -0.324     0.200
     0.816     0.792     0.200
     0.169     0.278     0.200
     0.435     0.531     0.200
     0.885     0.451     0.200
     0.367     0.754     0.200
     0.859     0.003     0.200
     0.302     0.441     0.200
     0.519     0.371     0.200
     0.988     1.344     0.200
     0.288    -0.021     0.200
     0.770    -0.123     0.200
     0.103    -0.198     0.200
     0.291     0.423     0.200
     0.651    -0.409     0.200
     0.724     0.295     0.200
     0.293     0.118     0.200
     0.260    -0.079     0.200
     0.100     0.127     0.200
     0.110    -0.100     0.200
     0.541     0.362     0.200
     0.591     0.203     0.200
     0.742     0.310     0.200
     0.137     0.466     0.200
     0.150     0.729     0.200
     0.459     0.125     0.200
     0.634    -0.082     0.200
     0.707     0.574     0.200
     0.873    -0.613     0.200
     0.303    -0.174     0.200
     0.515     0.030     0.200
     0.739     0.255     0.200
     0.264     0.828     0.200
     0.237    -0.016     0.200
     0.424     0.290     0.200
     0.464     0.247     0.200
     0.275     0.248     0.200
     0.341     0.093     0.200
     0.499    -0.152     0.200
     0.850    -0.394     0.200
     0.845    -0.384     0.200
     0.252     0.401     0.200
     0.415     0.317     0.200
     0.479     0.326     0.200
     0.905     0.551     0.200
     0.331     0.474     0.200
     0.788     0.482     0.200
     0.210     0.140     0.200
     0.209     0.087     0.200
     0.589     0.275     0.200
     0.879    -0.069     0.200
     0.289     0.306     0.200
     0.307     0.253     0.200
     0.465    -0.258     0.200
     0.869    -0.076     0.200
     0.148     0.174     0.200
     0.181     0.203     0.200
     0.635    -0.034     0.200
     0.935    -0.044     0.200
     0.228     0.108     0.200
     0.309     0.133     0.200
     0.480     0.060     0.200
     0.844     0.055     0.200
     0.364     0.447     0.200
     0.481    -0.408     0.200
     0.307     0.012     0.200
     0.375     0.021     0.200
     0.499     0.130     0.200
     0.769    -0.024     0.200
     0.420     0.250     0.200
     0.492    -0.381     0.200
     0.900    -0.530     0.200
     0.363     0.034     0.200
EOF
# Pb arrivals
gmt plot $proj $reg -Sx -Wthick -Gblue << EOF
EOF
# Pn arrivals
gmt plot $proj $reg -Sx -Wthick -Ggreen << EOF
     0.308    -0.139     0.200
     0.729    -0.164     0.200
     0.979    -0.030     0.200
     0.158     0.034     0.200
     0.538    -1.088     0.200
     0.969     0.793     0.200
     0.294     0.176     0.200
     0.584    -0.155     0.200
     0.725    -0.440     0.200
     0.650    -0.265     0.200
     0.292     0.136     0.200
     0.397    -0.084     0.200
     0.827     0.210     0.200
     0.791    -0.055     0.200
     0.087    -0.092     0.200
     0.514     0.119     0.200
     0.863    -0.590     0.200
     0.406     0.053     0.200
     0.697     0.256     0.200
     0.710     0.022     0.200
     0.710     0.303     0.200
     0.941     0.008     0.200
     0.920     0.047     0.200
     0.924     0.537     0.200
     0.302    -0.075     0.200
     0.423     0.296     0.200
     0.633    -0.127     0.200
     0.815     0.239     0.200
     0.862     0.085     0.200
     0.865     0.300     0.200
     0.986     0.403     0.200
     0.101     0.084     0.200
     0.370     0.102     0.200
     0.540     0.147     0.200
     0.672    -0.087     0.200
     0.840     0.127     0.200
     0.904     0.251     0.200
     0.291     0.110     0.200
     0.288     0.176     0.200
     0.371     0.026     0.200
     0.251     0.059     0.200
     0.401     0.040     0.200
     0.876    -0.341     0.200
     0.939     0.116     0.200
     0.171     0.124     0.200
     0.204     0.004     0.200
     0.463     0.153     0.200
     0.484     0.285     0.200
     0.576    -0.061     0.200
     0.911    -0.144     0.200
     0.477     0.018     0.200
     0.664     0.050     0.200
     0.923    -0.333     0.200
     0.282    -0.098     0.200
     0.353    -0.177     0.200
     0.594    -0.152     0.200
     0.649     0.227     0.200
     0.745    -0.289     0.200
     0.771    -0.587     0.200
     0.980     0.196     0.200
     0.142     0.153     0.200
     0.281     0.003     0.200
     0.349    -0.020     0.200
     0.576    -0.034     0.200
     0.724    -0.111     0.200
     0.762     0.181     0.200
     1.000     0.245     0.200
     0.220     0.260     0.200
     0.606    -0.258     0.200
     0.765    -0.535     0.200
     0.828    -0.024     0.200
     0.969    -0.217     0.200
     0.150    -0.444     0.200
     0.394     0.063     0.200
     0.754    -0.357     0.200
     0.640     0.186     0.200
     0.788     0.044     0.200
     0.935     0.264     0.200
     0.089    -0.282     0.200
     0.290     0.062     0.200
     0.662     0.068     0.200
     0.784    -0.038     0.200
     0.840     0.276     0.200
     0.976     0.020     0.200
     0.981     0.352     0.200
     0.371     0.159     0.200
     0.413    -0.386     0.200
     0.587    -0.241     0.200
     0.647    -0.222     0.200
     0.834     0.171     0.200
     0.838     0.054     0.200
     0.989     0.175     0.200
     0.210     0.165     0.200
     0.226     0.102     0.200
     0.274     0.240     0.200
     0.331     0.171     0.200
     0.498     0.120     0.200
     0.842     0.036     0.200
     0.873     0.676     0.200
     0.297    -0.063     0.200
     0.290     0.170     0.200
     0.397    -0.028     0.200
     0.522     0.015     0.200
     0.760     0.291     0.200
     0.860     0.061     0.200
     0.080    -0.019     0.200
     0.308    -0.007     0.200
     0.701     0.198     0.200
     0.843    -0.095     0.200
     0.781     1.417     0.200
     0.986     1.467     0.200
     0.038     0.091     0.200
     0.807     0.505     0.200
     0.897    -0.740     0.200
     0.958     0.389     0.200
     0.237     0.095     0.200
     0.494    -0.088     0.200
     0.799    -0.456     0.200
     0.987    -0.082     0.200
     0.169     0.223     0.200
     0.541    -0.082     0.200
     0.722    -0.007     0.200
     0.794     0.194     0.200
     0.878     0.067     0.200
     0.235     0.042     0.200
     0.398     0.126     0.200
     0.376     0.308     0.200
     0.872     0.697     0.200
     0.379     0.043     0.200
     0.383    -0.120     0.200
     0.470     0.246     0.200
     0.716     0.132     0.200
     0.577     0.078     0.200
     0.995     0.230     0.200
     0.302     0.544     0.200
     0.385     0.220     0.200
     0.686    -0.038     0.200
     0.699     0.264     0.200
     0.899     0.090     0.200
     0.952     0.235     0.200
     0.312     0.046     0.200
     0.411     0.145     0.200
     0.642     0.055     0.200
     0.818     0.461     0.200
     0.855    -0.157     0.200
     0.871     0.265     0.200
     0.998     0.885     0.200
     0.595    -0.275     0.200
     0.565    -0.150     0.200
     0.785     0.007     0.200
     0.312     0.102     0.200
     0.363     0.134     0.200
     0.489    -0.209     0.200
     0.779    -0.800     0.200
     0.884     0.059     0.200
     0.287    -0.014     0.200
     0.408     0.105     0.200
     0.610    -0.076     0.200
     0.875     0.513     0.200
     0.512     0.083     0.200
     0.480     0.137     0.200
     0.718     0.044     0.200
     0.217    -0.015     0.200
     0.295     0.473     0.200
     0.379    -0.006     0.200
     0.392    -0.389     0.200
     0.910     0.220     0.200
     0.955    -0.103     0.200
     0.918     0.290     0.200
     0.257     0.277     0.200
     0.593     0.048     0.200
     0.650     0.219     0.200
     0.708    -0.065     0.200
     0.761    -0.073     0.200
     0.192     0.076     0.200
     0.306     0.179     0.200
     0.469    -0.181     0.200
     0.885     0.102     0.200
     0.900     0.033     0.200
     0.233     0.125     0.200
     0.568    -0.014     0.200
     0.690    -0.027     0.200
     0.679     0.138     0.200
     0.753     0.064     0.200
     0.318    -0.054     0.200
     0.317     0.111     0.200
     0.462    -0.087     0.200
     0.832     0.153     0.200
     0.889    -0.135     0.200
     0.879    -0.253     0.200
EOF
# Sg arrivals
gmt plot $proj $reg -Sc -Wthick,red << EOF
     0.180     0.195     0.200
     0.250     0.181     0.200
     0.168    -0.537     0.200
     0.977     0.971     0.200
     0.168    -0.462     0.200
     0.154    -0.438     0.200
     0.397     0.325     0.200
     0.682    -0.976     0.200
     0.274    -0.280     0.200
     0.677    -0.077     0.200
     0.865     1.148     0.200
     0.242     0.413     0.200
     0.594     0.134     0.200
     0.997    -0.392     0.200
     0.358    -0.037     0.200
     0.240    -0.422     0.200
     0.642     0.041     0.200
     0.215    -0.111     0.200
     0.285    -0.358     0.200
     0.626     1.916     0.200
     0.553    -0.386     0.200
     0.294     0.410     0.200
     0.372    -0.651     0.200
     0.461     0.048     0.200
     0.864    -0.049     0.200
     0.929     0.116     0.200
     0.190    -0.295     0.200
     0.167    -0.439     0.200
     0.249    -0.169     0.200
     0.811    -0.111     0.200
     0.871    -0.490     0.200
     0.824    -0.515     0.200
     0.110     0.148     0.200
     0.323     0.319     0.200
     0.698     0.314     0.200
     0.726    -0.250     0.200
     0.807    -0.477     0.200
     0.819    -0.256     0.200
     0.957    -0.531     0.200
     0.991    -0.074     0.200
     0.421    -0.161     0.200
     0.231     0.022     0.200
     0.342    -0.206     0.200
     0.360     0.338     0.200
     0.366     0.121     0.200
     0.438     0.374     0.200
     0.853    -0.307     0.200
     0.226    -0.591     0.200
     0.334     0.383     0.200
     0.753     1.570     0.200
     0.019    -0.483     0.200
     0.255    -1.159     0.200
     0.401     0.316     0.200
     0.616    -0.013     0.200
     0.047    -0.170     0.200
     0.268     0.221     0.200
     0.734     0.201     0.200
     0.865     0.116     0.200
     0.258    -0.059     0.200
     0.319     0.531     0.200
     0.387     0.604     0.200
     0.391     0.070     0.200
     0.957    -0.786     0.200
     0.141    -0.135     0.200
     0.283    -0.315     0.200
     0.536     0.010     0.200
     0.630     1.345     0.200
     0.758    -0.052     0.200
     0.170    -0.271     0.200
     0.210    -0.621     0.200
     0.207    -0.170     0.200
     0.390     0.153     0.200
     0.562     0.397     0.200
     0.778    -0.399     0.200
     0.872    -0.810     0.200
     0.637    -0.388     0.200
     0.239     0.088     0.200
     0.256     0.586     0.200
     0.379     0.052     0.200
     0.528    -0.452     0.200
     0.828    -0.029     0.200
     0.169    -0.118     0.200
     0.435     0.328     0.200
     0.885     0.468     0.200
     0.122    -0.161     0.200
     0.367     0.817     0.200
     0.510    -1.181     0.200
     0.859     0.543     0.200
     0.302    -0.599     0.200
     0.519    -0.468     0.200
     0.553     1.055     0.200
     0.988     0.791     0.200
     0.288     0.044     0.200
     0.103    -0.297     0.200
     0.429    -0.683     0.200
     0.651     0.051     0.200
     0.724     0.542     0.200
     0.293    -0.610     0.200
     0.610    -0.569     0.200
     0.260    -0.859     0.200
     0.577     0.201     0.200
     0.100    -0.703     0.200
     0.110    -0.908     0.200
     0.541     0.246     0.200
     0.591    -0.107     0.200
     0.137     0.484     0.200
     0.459     0.095     0.200
     0.634     0.179     0.200
     0.707     0.409     0.200
     0.873    -0.352     0.200
     0.303    -0.974     0.200
     0.515    -0.147     0.200
     0.659     0.236     0.200
     0.739     0.252     0.200
     0.264     0.479     0.200
     0.595    -0.033     0.200
     0.565    -0.146     0.200
     0.237    -0.732     0.200
     0.424    -0.457     0.200
     0.464    -0.391     0.200
     0.275     0.373     0.200
     0.341    -0.136     0.200
     0.499     0.148     0.200
     0.850    -0.776     0.200
     0.252    -0.773     0.200
     0.415    -0.480     0.200
     0.331    -0.361     0.200
     0.788     0.012     0.200
     0.210    -0.187     0.200
     0.209    -0.219     0.200
     0.589     0.440     0.200
     0.879    -0.401     0.200
     0.289     0.654     0.200
     0.307     0.383     0.200
     0.465    -0.452     0.200
     0.869     0.762     0.200
     0.148    -0.722     0.200
     0.181    -0.316     0.200
     0.635    -0.722     0.200
     0.935    -0.261     0.200
     0.228    -0.380     0.200
     0.309     0.093     0.200
     0.480    -0.239     0.200
     0.844     0.201     0.200
     0.364    -0.423     0.200
     0.307    -0.121     0.200
     0.375     0.051     0.200
     0.499     0.034     0.200
     0.769     0.326     0.200
     0.879    -0.392     0.200
     0.492     0.507     0.200
     0.900     0.885     0.200
     0.575     0.149     0.200
EOF
# Sb arrivals
gmt plot $proj $reg -Sc -Wthick,blue << EOF
EOF
# Sn arrivals
gmt plot $proj $reg -Sc -Wthick,green << EOF
     0.308    -0.506     0.200
     0.729    -1.331     0.200
     0.979    -1.061     0.200
     0.158    -0.977     0.200
     0.969     0.789     0.200
     0.294    -0.139     0.200
     0.584    -0.507     0.200
     0.650    -0.174     0.200
     0.292     0.282     0.200
     0.292     0.141     0.200
     0.397    -0.182     0.200
     0.397    -0.362     0.200
     0.827    -0.345     0.200
     0.791    -0.193     0.200
     0.087    -0.316     0.200
     0.087    -0.449     0.200
     0.514    -0.065     0.200
     0.863    -1.083     0.200
     0.406    -0.598     0.200
     0.697     0.395     0.200
     0.710    -0.141     0.200
     0.920     0.243     0.200
     0.924     0.878     0.200
     0.302    -0.543     0.200
     0.423     0.335     0.200
     0.633    -0.761     0.200
     0.862    -1.171     0.200
     0.865    -0.787     0.200
     0.986    -0.029     0.200
     0.101    -0.160     0.200
     0.370     0.159     0.200
     0.540    -0.097     0.200
     0.672    -0.642     0.200
     0.840    -0.504     0.200
     0.904     0.068     0.200
     0.291    -0.110     0.200
     0.288    -0.137     0.200
     0.371    -0.256     0.200
     0.251    -0.069     0.200
     0.401    -0.241     0.200
     0.939     0.127     0.200
     0.171    -0.156     0.200
     0.204    -0.364     0.200
     0.463    -0.045     0.200
     0.484    -0.110     0.200
     0.576    -0.274     0.200
     0.911    -0.366     0.200
     0.477    -0.582     0.200
     0.664    -0.006     0.200
     0.282     0.258     0.200
     0.353     0.266     0.200
     0.594    -0.044     0.200
     0.649     0.264     0.200
     0.745     0.146     0.200
     0.771    -0.935     0.200
     0.980     0.944     0.200
     0.142     0.010     0.200
     0.281     0.010     0.200
     0.349    -0.036     0.200
     0.576    -0.350     0.200
     0.724     0.061     0.200
     0.762     0.199     0.200
     1.000    -0.222     0.200
     0.735    -1.072     0.200
     0.617    -0.408     0.200
     0.560    -0.009     0.200
     0.220     0.547     0.200
     0.479    -0.818     0.200
     0.606    -0.295     0.200
     0.765    -0.913     0.200
     0.828     0.668     0.200
     0.394    -0.051     0.200
     0.640    -0.155     0.200
     0.788     0.139     0.200
     0.935     0.405     0.200
     0.089     0.162     0.200
     0.290     0.041     0.200
     0.662     0.003     0.200
     0.784    -0.491     0.200
     0.840     0.983     0.200
     0.976    -0.409     0.200
     0.371     0.559     0.200
     0.413    -0.957     0.200
     0.587    -0.195     0.200
     0.647    -0.429     0.200
     0.834    -0.148     0.200
     0.989    -0.141     0.200
     0.850     0.534     0.200
     0.210    -0.044     0.200
     0.226    -0.151     0.200
     0.274    -0.100     0.200
     0.331    -0.008     0.200
     0.498     0.079     0.200
     0.873     0.801     0.200
     0.297    -0.053     0.200
     0.290    -0.273     0.200
     0.397    -0.255     0.200
     0.522    -0.118     0.200
     0.760     0.191     0.200
     0.860    -0.813     0.200
     0.308    -0.803     0.200
     0.781    -0.371     0.200
     0.038    -0.368     0.200
     0.807    -0.569     0.200
     0.958    -0.150     0.200
     0.237     0.382     0.200
     0.494    -0.201     0.200
     0.799    -1.055     0.200
     0.987    -1.245     0.200
     0.169    -0.024     0.200
     0.541    -0.170     0.200
     0.722    -0.712     0.200
     0.794     0.107     0.200
     0.878    -0.235     0.200
     0.235    -0.376     0.200
     0.398    -0.324     0.200
     0.376    -0.079     0.200
     0.872     0.807     0.200
     0.379    -0.472     0.200
     0.383    -0.502     0.200
     0.470    -0.090     0.200
     0.716    -0.092     0.200
     0.742    -0.856     0.200
     0.995    -0.176     0.200
     0.302     1.027     0.200
     0.385    -0.634     0.200
     0.686    -1.189     0.200
     0.699    -0.092     0.200
     0.859    -0.477     0.200
     0.899    -0.318     0.200
     0.312    -0.373     0.200
     0.411     0.261     0.200
     0.642    -0.525     0.200
     0.855    -0.275     0.200
     0.871    -1.090     0.200
     0.998     0.264     0.200
     0.312     0.062     0.200
     0.363     0.153     0.200
     0.489    -0.182     0.200
     0.884    -0.355     0.200
     0.408     0.096     0.200
     0.610    -0.742     0.200
     0.875    -0.787     0.200
     0.512    -0.533     0.200
     0.480     0.380     0.200
     0.718     0.047     0.200
     0.217    -0.391     0.200
     0.295    -0.085     0.200
     0.910    -0.092     0.200
     0.918    -0.509     0.200
     0.257     0.090     0.200
     0.593     0.051     0.200
     0.650    -0.405     0.200
     0.708    -0.204     0.200
     0.761    -0.905     0.200
     0.845    -1.009     0.200
     0.905    -0.858     0.200
     0.192    -0.567     0.200
     0.306    -0.398     0.200
     0.469    -0.915     0.200
     0.885     0.280     0.200
     0.233     0.027     0.200
     0.568     0.072     0.200
     0.690    -0.305     0.200
     0.679    -0.200     0.200
     0.753    -0.525     0.200
     0.318    -0.260     0.200
     0.317     0.161     0.200
     0.462     0.006     0.200
     0.832     0.215     0.200
     0.889    -0.934     0.200
EOF
# Average Pg residual
gmt plot $proj $reg -Wthicker,red << EOF
 0.00    0.134
 1.00    0.134
EOF
# Average Pn residual
gmt plot $proj $reg -Wthicker,green << EOF
 0.00    0.057
 1.00    0.057
EOF
# Average Sg residual
gmt plot $proj $reg -Wthin,red,- << EOF
 0.00   -0.1
 1.00   -0.1
EOF
# Average Sn residual
gmt plot $proj $reg -Wthin,green,- << EOF
 0.00   -0.2
 1.00   -0.2
EOF
gmt text $proj $reg -F+f12p,Helvetica-Bold,black+a0.+jBL << EOF
     0.025     8.000   Residuals for crustal phases, average over (0-1.0)
     0.050     7.000   Pg = red x; average =   0.1 (solid red line)
     0.050     5.000   Pn = green x; average =   0.1 (solid green line)
     0.050    -7.500   Sg = red circles; average =  -0.1 (dashed red line)
     0.050    -9.500   Sn = green circles; average =  -0.2 (dashed green line)
EOF
gmt end
