#!/bin/bash
gmt begin acapulco7.51_tt3_pkp_caustic pdf,ps
proj=-JX12
reg=-R135/160/-12/20
gmt basemap $proj $reg -Bxa5+l'Epicentral Distance (deg)' -Bya10+l'Travel Time (s)' -BWeSn+t'PKP Caustic acapulco7.51'
# PKPdf theoretical
gmt plot $proj $reg -Wthick,black << EOF
   135.000     0.000
   160.000     0.000
EOF
# PKiKP theoretical
gmt plot $proj $reg -Wthick,green << EOF
   135.000     1.474
   135.500     1.556
   136.000     1.642
   136.500     1.730
   137.000     1.822
   137.500     1.917
   138.000     2.015
   138.500     2.117
   139.000     2.222
   139.500     2.331
   140.000     2.444
   140.500     2.561
   141.000     2.682
   141.500     2.808
   142.000     2.939
   142.500     3.074
   143.000     3.214
   143.500     3.359
   144.000     3.510
   144.500     3.667
   145.000     3.829
   145.500     3.998
   146.000     4.173
   146.500     4.355
   147.000     4.544
   147.500     4.740
   148.000     4.943
   148.500     5.154
   149.000     5.374
   149.500     5.603
   150.000     5.842
   150.500     6.090
   151.000     6.349
   151.500     6.618
   152.000     6.897
   152.500     7.186
   153.000     7.485
   153.500     7.795
   154.000     8.116
   154.500     8.447
   155.000     8.790
EOF
# PKPab theoretical
gmt plot $proj $reg -Wthick,blue << EOF
   145.000    -0.624
   145.500     0.347
   146.000     1.378
   146.500     2.451
   147.000     3.558
   147.500     4.694
   148.000     5.858
   148.500     7.046
   149.000     8.258
   149.500     9.492
   150.000    10.749
   150.500    12.026
   151.000    13.324
   151.500    14.642
   152.000    15.978
   152.500    17.333
   153.000    18.706
   153.500    20.096
   154.000    21.504
   154.500    22.929
   155.000    24.372
   155.500    25.831
   156.000    27.308
   156.500    28.801
   157.000    30.311
   157.500    31.837
   158.000    33.380
   158.500    34.939
   159.000    36.515
   159.500    38.108
   160.000    39.716
EOF
# PKPbc theoretical
gmt plot $proj $reg -Wthick,red << EOF
   145.000    -0.635
   145.500     0.122
   146.000     0.810
   146.500     1.448
   147.000     2.043
   147.500     2.601
   148.000     3.123
   148.500     3.613
   149.000     4.077
   149.500     4.522
   150.000     4.951
   150.500     5.367
   151.000     5.773
   151.500     6.169
   152.000     6.557
   152.500     6.938
   153.000     7.313
   153.500     7.684
   154.000     8.052
   154.500     8.419
   155.000     8.783
EOF
# PKPdf observed
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
   140.225     0.643     0.200
   140.139    -3.501     0.200
   140.268    -2.837     0.200
   142.750    -2.185     0.200
   143.585     0.343     0.200
   144.238     1.501     0.200
   145.569    -1.099     0.200
   145.912     1.714     0.200
   146.707     2.968     0.200
   147.487     4.664     0.200
   149.026     4.342     0.200
   150.361     5.023     0.200
   150.772     4.783     0.200
   150.815     5.819     0.200
   152.932     4.139     0.200
   143.940     1.299     0.200
   145.794     3.196     0.200
   148.824     5.148     0.200
   149.356     5.291     0.200
   152.853     1.932     0.200
   141.874    -3.074     0.200
   141.875     1.083     0.200
   142.423     0.945     0.200
   142.690    -1.308     0.200
   145.575     2.762     0.200
   149.520     4.883     0.200
   149.594     6.087     0.200
   149.661     1.940     0.200
   149.852     5.884     0.200
   149.858     5.888     0.200
   150.302     5.463     0.200
   152.583     3.751     0.200
   152.646     3.882     0.200
   154.307     2.588     0.200
   155.655     4.864     0.200
   142.054    -2.353     0.200
   145.580     2.607     0.200
   145.809     3.101     0.200
   142.673    -0.497     0.200
   143.196    -0.067     0.200
   144.194     1.242     0.200
   145.841     2.504     0.200
   148.319     4.099     0.200
   148.371     4.674     0.200
   150.235     4.130     0.200
   150.235     4.599     0.200
   150.575     3.869     0.200
   150.575     4.556     0.200
   150.610     4.745     0.200
   152.687     4.558     0.200
   153.303     3.372     0.200
   145.662     1.811     0.200
   145.970     2.554     0.200
   153.360     3.756     0.200
   145.766     3.477     0.200
   145.927     2.978     0.200
   145.927     2.138     0.200
   146.160     3.171     0.200
   147.229     4.653     0.200
   147.757     2.366     0.200
   148.307     2.239     0.200
   150.303     1.873     0.200
   150.334     3.492     0.200
   150.443     3.104     0.200
   150.674     3.495     0.200
   153.401     4.188     0.200
   153.401     3.250     0.200
   154.595     1.949     0.200
   155.330     3.076     0.200
   145.958     3.484     0.200
   148.429     2.962     0.200
   153.328     3.614     0.200
   155.257     3.465     0.200
   139.637     0.669     0.200
   142.980     0.575     0.200
   142.980     0.973     0.200
   143.171    -0.490     0.200
   144.197     1.033     0.200
   144.197     1.337     0.200
   145.578     3.249     0.200
   145.753     2.598     0.200
   145.771     3.020     0.200
   145.849     3.183     0.200
   146.406     3.841     0.200
   146.694     3.659     0.200
   146.694     2.862     0.200
   146.988     0.462     0.200
   148.703     3.695     0.200
   148.980     4.285     0.200
   149.396     5.219     0.200
   149.681     4.960     0.200
   149.681     5.804     0.200
   149.910     5.597     0.200
   150.325     4.844     0.200
   150.415     5.407     0.200
   150.635     4.127     0.200
   150.989     3.760     0.200
   151.177     4.730     0.200
   151.314     5.020     0.200
   151.656     5.604     0.200
   151.787     3.907     0.200
   152.185     4.506     0.200
   152.715     4.824     0.200
   152.819     3.977     0.200
   152.861     5.509     0.200
   153.088     2.781     0.200
   153.811     3.547     0.200
   154.049     7.506     0.200
   154.186     2.415     0.200
   154.186     3.110     0.200
   154.414     5.197     0.200
   154.553     5.403     0.200
   155.089     4.266     0.200
   145.747     2.235     0.200
   145.908     3.289     0.200
   145.522     3.152     0.200
   135.426    -3.403     0.200
   143.800     0.081     0.200
   144.633     1.054     0.200
   145.578     2.476     0.200
   145.578     2.207     0.200
   146.172     3.675     0.200
   146.776     3.244     0.200
   154.007     3.880     0.200
   136.218    -0.302     0.200
   142.365    -0.144     0.200
   142.687     0.909     0.200
   143.056     0.955     0.200
   145.579     3.257     0.200
   145.815     2.613     0.200
   145.936     3.268     0.200
   147.290     3.216     0.200
   148.109     4.320     0.200
   148.653     3.211     0.200
   148.700     2.985     0.200
   150.294     5.982     0.200
   151.640     3.762     0.200
   152.991     2.518     0.200
   152.991     4.219     0.200
   153.147     3.491     0.200
   154.632     4.045     0.200
   154.933     2.560     0.200
   155.076     2.795     0.200
   156.046     3.412     0.200
   146.172     1.700     0.200
EOF
# PKPbc observed
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   145.207     2.522     0.200
   145.333     1.306     0.200
   145.353     2.850     0.200
   145.105     2.049     0.200
   145.277     2.753     0.200
   145.366     3.430     0.200
   145.328     3.113     0.200
   145.328     3.480     0.200
   145.349     3.397     0.200
   145.196     2.718     0.200
   145.415     3.814     0.200
   145.315     3.404     0.200
   153.811     3.945     0.200
EOF
# PKPab observed
gmt plot $proj $reg -Sx -Wthin -Gblue << EOF
   148.645     7.560     0.200
   149.599    10.224     0.200
   154.567    20.810     0.200
   150.167    11.006     0.200
   147.776     7.096     0.200
   148.135     7.467     0.200
   149.520     9.454     0.200
   152.583    20.901     0.200
   148.894     8.708     0.200
   148.319     8.642     0.200
   148.371     7.975     0.200
   150.235     9.150     0.200
   150.235     9.458     0.200
   150.349     9.909     0.200
   151.038    10.233     0.200
   150.295     8.997     0.200
   153.360    22.857     0.200
   148.256     6.733     0.200
   149.221     8.500     0.200
   150.334     9.785     0.200
   151.776    11.901     0.200
   156.062    30.772     0.200
   148.378     8.044     0.200
   148.850     9.394     0.200
   149.681     8.663     0.200
   149.681     9.460     0.200
   149.910     8.495     0.200
   150.325     9.344     0.200
   150.821    10.776     0.200
   151.177    10.129     0.200
   147.693     7.844     0.200
   147.693     6.514     0.200
   149.796     8.807     0.200
   150.014     8.510     0.200
   152.256    18.879     0.200
   147.610     6.875     0.200
   148.062     7.347     0.200
   148.603     6.853     0.200
   148.653     7.361     0.200
   149.960    10.016     0.200
   148.099     6.671     0.200
   148.684     6.303     0.200
   148.119     6.744     0.200
   148.223     9.347     0.200
   148.243     7.642     0.200
EOF
# PKiKP observed
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
   135.410     3.105     0.200
   136.463     4.047     0.200
   139.303     5.019     0.200
   140.260     6.278     0.200
   142.413     1.913     0.200
   143.285     5.870     0.200
   143.350     2.756     0.200
   143.678     2.178     0.200
   144.406     1.908     0.200
   144.453     1.826     0.200
   149.870     7.193     0.200
   135.289     5.013     0.200
   135.372     4.157     0.200
   135.852     0.763     0.200
   136.132     4.541     0.200
   144.213     1.922     0.200
   144.855     3.709     0.200
   145.465     2.558     0.200
   139.683     4.007     0.200
   142.558     4.038     0.200
   142.656     1.264     0.200
   143.741     1.752     0.200
   145.260     2.884     0.200
   145.369     3.327     0.200
   145.535     3.144     0.200
   135.325     2.653     0.200
   135.325     5.683     0.200
   135.668     6.849     0.200
   135.855     4.247     0.200
   135.962     1.047     0.200
   136.282     3.051     0.200
   136.535     6.400     0.200
   137.139     3.153     0.200
   137.139     3.989     0.200
   139.501     3.628     0.200
   139.501     4.228     0.200
   140.832     2.395     0.200
   142.038     4.412     0.200
   142.234     3.932     0.200
   143.871     2.212     0.200
   144.026     2.571     0.200
   144.376     3.331     0.200
   144.466     2.844     0.200
   144.555     2.270     0.200
   144.555     3.573     0.200
   149.070     6.505     0.200
   149.520     6.247     0.200
   152.583    11.327     0.200
   136.299     3.474     0.200
   144.573     2.663     0.200
   136.141     1.976     0.200
   138.794     3.880     0.200
   139.968     1.000     0.200
   140.117     3.049     0.200
   144.231     1.512     0.200
   145.483     2.960     0.200
   153.139    11.260     0.200
   135.052     3.221     0.200
   135.061     3.346     0.200
   135.135     3.886     0.200
   135.190     2.183     0.200
   135.261     3.199     0.200
   135.319     2.339     0.200
   135.442     2.411     0.200
   135.481     2.241     0.200
   135.518     2.969     0.200
   135.523     2.960     0.200
   135.972     2.226     0.200
   135.994     0.984     0.200
   136.508     2.679     0.200
   136.716     4.273     0.200
   136.948     4.504     0.200
   139.585     4.572     0.200
   139.719     3.762     0.200
   140.104     3.429     0.200
   140.104     4.089     0.200
   140.416     4.551     0.200
   140.416     3.914     0.200
   141.078     4.368     0.200
   145.471     3.067     0.200
   152.687    11.230     0.200
   152.687    11.980     0.200
   153.303    10.571     0.200
   140.506     3.061     0.200
   140.506     3.057     0.200
   140.506     4.171     0.200
   151.603    10.347     0.200
   153.360    10.424     0.200
   153.360    10.658     0.200
   140.923     2.881     0.200
   145.977     4.358     0.200
   142.203     5.590     0.200
   135.408     4.118     0.200
   135.879     1.661     0.200
   138.761     2.527     0.200
   139.291     5.050     0.200
   140.074     4.836     0.200
   140.206     3.264     0.200
   140.519     3.976     0.200
   142.241     2.080     0.200
   143.716     1.562     0.200
   153.401    12.750     0.200
   140.479     4.277     0.200
   140.479     4.277     0.200
   140.479     3.230     0.200
   150.263     8.347     0.200
   151.660     9.698     0.200
   153.328    11.114     0.200
   140.259     3.549     0.200
   140.259     3.549     0.200
   136.460     3.113     0.200
   136.939     3.726     0.200
   137.011     3.592     0.200
   139.530     5.067     0.200
   139.765     5.742     0.200
   139.921     5.256     0.200
   139.998     4.919     0.200
   140.071     4.287     0.200
   140.676     3.887     0.200
   143.110     1.642     0.200
   143.110     1.846     0.200
   144.254     2.137     0.200
   144.254     2.238     0.200
   145.608     4.697     0.200
   145.759     4.243     0.200
   145.849     4.887     0.200
   145.862     4.069     0.200
   146.409     5.140     0.200
   146.778     6.213     0.200
   146.988     5.064     0.200
   146.988     5.666     0.200
   147.299     6.146     0.200
   148.850     5.894     0.200
   149.910     7.191     0.200
   150.089     7.815     0.200
   150.635     9.064     0.200
   150.989     9.518     0.200
   151.314    10.223     0.200
   151.787     8.602     0.200
   152.185    11.413     0.200
   152.715    10.527     0.200
   152.715    10.629     0.200
   152.819    10.875     0.200
   152.861    10.813     0.200
   153.336     8.125     0.200
   153.893    10.829     0.200
   154.404    10.805     0.200
   154.632     8.690     0.200
   154.632    11.487     0.200
   140.744     3.824     0.200
   140.651     4.562     0.200
   140.051     4.395     0.200
   140.289     4.069     0.200
   140.439     4.293     0.200
   140.913     4.295     0.200
   140.278     4.432     0.200
   140.278     2.573     0.200
   140.224     5.134     0.200
   140.273     3.718     0.200
   135.240     3.869     0.200
   136.853     3.045     0.200
   136.853     3.275     0.200
   137.510     4.030     0.200
   140.725     1.805     0.200
   151.282     9.294     0.200
   152.526    10.289     0.200
   152.526    10.531     0.200
   135.092     3.942     0.200
   135.156     3.953     0.200
   135.191     0.945     0.200
   135.478     4.305     0.200
   135.598     4.439     0.200
   135.675     6.743     0.200
   135.846     4.746     0.200
   136.083     4.956     0.200
   136.153     4.495     0.200
   136.185     4.766     0.200
   136.218     1.303     0.200
   136.274     3.326     0.200
   136.473     4.268     0.200
   136.454     5.517     0.200
   136.589     3.664     0.200
   136.538     2.555     0.200
   136.660     2.284     0.200
   136.624     4.930     0.200
   136.642     4.118     0.200
   136.833     5.984     0.200
   137.945     5.421     0.200
   137.933     5.112     0.200
   138.072     4.697     0.200
   138.322     4.568     0.200
   139.474     5.346     0.200
   140.344     5.290     0.200
   141.233     2.036     0.200
   141.482     1.108     0.200
   142.208     3.761     0.200
   142.250     3.510     0.200
   142.259     3.545     0.200
   142.293     3.834     0.200
   142.865     5.775     0.200
   142.936     4.843     0.200
   142.936     3.909     0.200
   143.973     2.045     0.200
   144.034     3.168     0.200
   144.034     4.168     0.200
   144.327     2.699     0.200
   144.712     3.462     0.200
   144.725     3.446     0.200
   144.729     3.751     0.200
   144.889     4.628     0.200
   145.936     7.998     0.200
   145.936     4.898     0.200
   147.422     8.787     0.200
   147.422     5.717     0.200
   140.245     4.818     0.200
   140.431     4.197     0.200
   140.431     5.290     0.200
   140.452     3.949     0.200
   140.452     3.499     0.200
   140.195     2.446     0.200
   140.208     5.008     0.200
   140.610     3.176     0.200
   135.147     3.334     0.200
   139.936     3.277     0.200
   152.748    10.501     0.200
   140.758     4.211     0.200
   140.225     5.183     0.200
   145.902     7.121     0.200
   140.854     3.844     0.200
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    19.000 All times reduced by theoretical PKPdf travel time
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,green+a0.+jBL << EOF
   136.000    18.000 PKiKP in green (top layer)
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,blue+a0.+jBL << EOF
   136.000    17.000 PKPab in blue
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,red+a0.+jBL << EOF
   136.000    16.000 PKPbc in red
EOF
gmt text $proj $reg -F+f8p,Helvetica-Bold,black+a0.+jBL << EOF
   136.000    15.000 PKPdf in black (bottom layer)
EOF
gmt end
