#!/bin/bash
gmt begin acapulco7.51_tt2_teleseismic_p pdf,ps
proj=-JX18/12
reg=-R10/120/-10/10
gmt basemap $proj $reg -Bxa10f5+l'Epicentral Distance (deg)' -Bya10f1g5+l'Travel Time Residual (s)' -BWeSn+t'Teleseismic P acapulco7.51'
gmt plot $proj $reg -Wthick,green << EOF
    78.000     9.628
    79.000     8.459
    80.000     7.374
    81.000     6.376
    82.000     5.463
    83.000     4.634
    84.000     3.889
    85.000     3.231
    86.000     2.659
    87.000     2.164
    88.000     1.777
    89.000     1.480
    90.000     1.225
    91.000     1.000
    92.000     0.800
    93.000     0.619
    94.000     0.455
    95.000     0.311
    96.000     0.193
    97.000     0.102
    98.000     0.038
    99.000     0.005
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
    15.976     4.663     0.200
    16.387     4.703     0.200
    16.519     3.818     0.200
    16.818     4.240     0.200
    19.124     3.335     0.200
    19.271     2.719     0.200
    19.274    -1.205     0.200
    19.888     2.082     0.200
    20.710     1.755     0.200
    21.191     7.563     0.200
    21.346     3.698     0.200
    21.654     4.893     0.200
    21.702     4.876     0.200
    21.978     6.420     0.200
    22.259     0.925     0.200
    22.259     1.226     0.200
    22.223     4.312     0.200
    22.376     1.079     0.200
    22.496     0.404     0.200
    22.496     0.802     0.200
    22.714     4.773     0.200
    22.787     4.316     0.200
    22.811     4.069     0.200
    22.983     1.245     0.200
    22.983     1.444     0.200
    23.113     0.882     0.200
    23.113     1.281     0.200
    23.383     2.835     0.200
    23.402     2.443     0.200
    23.533     3.557     0.200
    24.096     4.908     0.200
    24.109     5.292     0.200
    24.130     5.348     0.200
    24.130     4.461     0.200
    24.915     4.442     0.200
    25.324     5.221     0.200
    25.521     5.437     0.200
    26.088     5.298     0.200
    26.002     4.082     0.200
    26.047     3.775     0.200
    26.306     3.326     0.200
    26.414     4.853     0.200
    26.685     3.909     0.200
    26.849     3.932     0.200
    26.814     4.246     0.200
    26.943     3.585     0.200
    26.957     3.359     0.200
    26.975     4.596     0.200
    27.106     5.515     0.200
    27.452     1.512     0.200
    27.452     3.912     0.200
    27.611     5.585     0.200
    27.534     2.279     0.200
    27.534     2.779     0.200
    27.535     4.463     0.200
    27.857     3.489     0.200
    28.061     4.071     0.200
    28.230     4.062     0.200
    28.347     4.722     0.200
    28.366     4.247     0.200
    28.740     2.519     0.200
    28.975     1.034     0.200
    28.901     4.494     0.200
    29.050     2.964     0.200
    29.064     4.843     0.200
    29.734     5.004     0.200
    30.252     4.423     0.200
    30.340     4.448     0.200
    30.799     3.287     0.200
    30.858     3.871     0.200
    30.908     3.831     0.200
    31.017     2.365     0.200
    31.114     4.813     0.200
    31.194     4.006     0.200
    31.582     2.396     0.200
    31.981     5.185     0.200
    32.356     2.893     0.200
    32.389     4.603     0.200
    32.503     2.704     0.200
    34.253     0.053     0.200
    34.253     0.854     0.200
    34.655     2.266     0.200
    34.614     3.927     0.200
    34.744     2.804     0.200
    34.906     3.167     0.200
    34.906     4.128     0.200
    35.025     2.375     0.200
    35.159     3.828     0.200
    35.159     3.293     0.200
    35.535     1.983     0.200
    35.863     6.177     0.200
    36.121     0.964     0.200
    36.246     0.894     0.200
    36.199     2.695     0.200
    36.383     0.725     0.200
    36.403     3.954     0.200
    36.339     3.104     0.200
    36.797     0.691     0.200
    36.964     2.773     0.200
    36.965     2.412     0.200
    36.993     1.529     0.200
    37.090     3.302     0.200
    37.339     2.492     0.200
    37.372     1.879     0.200
    37.330     3.671     0.200
    37.698    -0.632     0.200
    37.877     2.142     0.200
    37.937     2.733     0.200
    43.003     3.639     0.200
    45.060     3.581     0.200
    45.060     1.620     0.200
    45.264     4.418     0.200
    45.437     1.642     0.200
    46.820     1.455     0.200
    46.856     2.180     0.200
    48.355     3.336     0.200
    49.219     3.699     0.200
    50.654     1.501     0.200
    51.430     1.969     0.200
    52.871     3.253     0.200
    52.805     3.245     0.200
    55.336     4.878     0.200
    55.494     1.137     0.200
    55.792     4.496     0.200
    55.825     1.764     0.200
    56.744     4.709     0.200
    56.736     2.364     0.200
    56.736     2.262     0.200
    57.012     3.303     0.200
    57.054     3.009     0.200
    57.079     4.830     0.200
    57.096     3.213     0.200
    57.070     4.496     0.200
    57.156     4.483     0.200
    57.294     4.411     0.200
    57.391     4.526     0.200
    57.908     3.389     0.200
    57.908     2.835     0.200
    57.908     2.690     0.200
    59.122     0.924     0.200
    60.069     1.100     0.200
    59.959     4.156     0.200
    59.971     4.068     0.200
    60.186     1.695     0.200
    60.108     4.434     0.200
    60.217     0.988     0.200
    60.217     1.589     0.200
    60.160     4.274     0.200
    60.348     2.092     0.200
    60.256     4.323     0.200
    60.622     2.321     0.200
    60.622     2.118     0.200
    60.876     1.589     0.200
    63.338     1.570     0.200
    63.972     1.587     0.200
    64.228     3.911     0.200
    64.744     0.836     0.200
    64.771    -0.444     0.200
    65.401     2.167     0.200
    66.182     3.329     0.200
    67.297     1.322     0.200
    69.140     1.465     0.200
    69.528     6.569     0.200
    70.057     2.113     0.200
    70.257     4.888     0.200
    70.536     3.181     0.200
    71.208     5.498     0.200
    71.579     1.258     0.200
    74.785     5.122     0.200
    74.718     5.008     0.200
    76.248     6.132     0.200
    76.407     3.831     0.200
    77.586     2.999     0.200
    77.918     3.346     0.200
    77.743     5.123     0.200
    78.017     2.997     0.200
    78.137     2.931     0.200
    78.686     2.598     0.200
    78.705     2.292     0.200
    78.952     2.137     0.200
    79.335     4.145     0.200
    79.397     3.905     0.200
    79.389     2.550     0.200
    79.521     2.226     0.200
    79.580     2.309     0.200
    79.589     3.960     0.200
    79.694    -0.610     0.200
    79.787     1.871     0.200
    79.808     1.768     0.200
    79.808     2.619     0.200
    79.841     3.191     0.200
    79.957     2.362     0.200
    80.050     3.064     0.200
    80.077     4.312     0.200
    80.099     2.587     0.200
    80.110     1.829     0.200
    80.151     2.221     0.200
    80.460     4.052     0.200
    80.836     2.600     0.200
    81.034     3.578     0.200
    81.560     2.601     0.200
    81.818     3.832     0.200
    81.954     4.216     0.200
    81.982     2.887     0.200
    81.991     2.360     0.200
    82.020     2.579     0.200
    82.026     2.146     0.200
    82.029     2.920     0.200
    82.029     3.420     0.200
    82.489     6.512     0.200
    82.538     6.260     0.200
    82.589     4.992     0.200
    82.695     5.240     0.200
    82.711     2.828     0.200
    82.807     6.359     0.200
    82.968     4.522     0.200
    83.037     3.864     0.200
    83.078     3.455     0.200
    83.079     4.450     0.200
    83.081     3.239     0.200
    83.097     2.457     0.200
    83.107     2.805     0.200
    83.167     3.995     0.200
    83.240     4.816     0.200
    83.232     2.856     0.200
    83.283     4.393     0.200
    83.286     4.380     0.200
    83.371     2.944     0.200
    83.365     5.575     0.200
    83.485     2.818     0.200
    83.511     2.620     0.200
    83.656     5.479     0.200
    83.653     5.693     0.200
    83.704     3.229     0.200
    83.797     3.757     0.200
    83.733     4.085     0.200
    83.982     3.813     0.200
    84.109     3.663     0.200
    84.113     2.246     0.200
    84.234     3.027     0.200
    84.315     3.117     0.200
    84.320     4.594     0.200
    84.321     5.085     0.200
    84.474     4.312     0.200
    84.476     5.301     0.200
    84.496     3.200     0.200
    84.558     4.087     0.200
    84.849     3.333     0.200
    84.878     2.772     0.200
    84.908     2.623     0.200
    85.083     0.142     0.200
    85.229     2.713     0.200
    85.112     3.100     0.200
    85.112     3.401     0.200
    85.260     3.212     0.200
    85.260    -0.640     0.200
    85.260    -0.241     0.200
    85.323     2.343     0.200
    85.519     3.069     0.200
    85.520     4.060     0.200
    85.571     2.908     0.200
    85.577     4.076     0.200
    85.613     2.598     0.200
    85.628     2.624     0.200
    85.726     3.040     0.200
    85.755     2.290     0.200
    85.871     2.490     0.200
    85.913     3.510     0.200
    85.927     4.041     0.200
    86.011     2.128     0.200
    85.951     0.923     0.200
    86.077     2.200     0.200
    86.093     6.220     0.200
    86.097     6.200     0.200
    86.121     2.685     0.200
    86.322     1.892     0.200
    86.325     2.077     0.200
    86.333     3.038     0.200
    86.395     1.734     0.200
    86.453     2.449     0.200
    86.477     4.329     0.200
    86.477     2.133     0.200
    86.494     3.444     0.200
    86.485     1.489     0.200
    86.562     3.715     0.200
    86.654     1.764     0.200
    86.688     1.898     0.200
    87.009     2.229     0.200
    87.253     2.045     0.200
    87.279     0.716     0.200
    87.460     3.745     0.200
    87.537     2.561     0.200
    87.757     2.141     0.200
    87.766     1.777     0.200
    87.954     5.182     0.200
    88.109     3.699     0.200
    88.149     2.257     0.200
    88.163     3.192     0.200
    88.178     3.812     0.200
    88.302     1.732     0.200
    88.312     2.986     0.200
    88.319     2.954     0.200
    88.338     0.260     0.200
    88.408     3.733     0.200
    88.613     2.013     0.200
    88.699     3.230     0.200
    88.845     2.902     0.200
    88.887     4.376     0.200
    88.996     2.961     0.200
    89.079     0.573     0.200
    89.186     3.572     0.200
    89.188     4.462     0.200
    89.238     3.327     0.200
    89.248     4.062     0.200
    89.259     4.529     0.200
    89.467     4.065     0.200
    89.555     4.843     0.200
    89.624     4.147     0.200
    89.681     2.054     0.200
    89.685     1.637     0.200
    89.711     3.514     0.200
    89.735     3.428     0.200
    89.866     3.637     0.200
    89.885     4.398     0.200
    89.925     4.310     0.200
    89.997     2.879     0.200
    89.997     3.500     0.200
    89.996     2.799     0.200
    90.022     3.498     0.200
    90.060     1.283     0.200
    90.091     2.140     0.200
    90.093     3.497     0.200
    90.097     2.211     0.200
    90.109     3.855     0.200
    90.141     3.203     0.200
    90.178     3.285     0.200
    90.214     3.550     0.200
    90.276     3.375     0.200
    90.294     3.281     0.200
    90.314     4.399     0.200
    90.375     0.744     0.200
    90.445     3.041     0.200
    90.445     3.275     0.200
    90.453     3.492     0.200
    90.461     2.604     0.200
    90.482     3.045     0.200
    90.493     3.275     0.200
    90.523     3.273     0.200
    90.545     3.129     0.200
    90.567     3.281     0.200
    90.660     4.287     0.200
    90.778     2.939     0.200
    90.864     2.638     0.200
    90.864     1.536     0.200
    91.004     1.888     0.200
    91.127     4.317     0.200
    91.209     2.236     0.200
    91.367     3.808     0.200
    91.575     1.539     0.200
    91.622     2.522     0.200
    91.664     3.829     0.200
    91.765     1.862     0.200
    91.868     3.486     0.200
    92.236     3.183     0.200
    92.318     3.804     0.200
    92.327     3.363     0.200
    92.351     3.450     0.200
    92.447     2.208     0.200
    92.455     2.369     0.200
    92.633     3.348     0.200
    92.881     1.807     0.200
    92.894     3.445     0.200
    92.962     3.932     0.200
    93.273     3.296     0.200
    93.346     2.262     0.200
    93.344     1.071     0.200
    93.517     2.276     0.200
    93.630     1.255     0.200
    93.656     3.136     0.200
    93.740     2.248     0.200
    93.854     2.923     0.200
    93.865     2.774     0.200
    93.814     2.510     0.200
    94.062     3.666     0.200
    94.117     2.215     0.200
    94.193     2.965     0.200
    94.256     3.429     0.200
    94.363     3.884     0.200
    94.599     2.403     0.200
    94.651     4.266     0.200
    94.715     1.769     0.200
    95.011     4.520     0.200
    95.251     2.620     0.200
    95.270     4.234     0.200
    95.357     2.939     0.200
    95.593     2.759     0.200
    95.703     5.258     0.200
    95.777     1.818     0.200
    95.855     4.565     0.200
    95.973     1.027     0.200
    96.346     2.332     0.200
    96.782     2.356     0.200
    96.791     3.315     0.200
    96.789     2.325     0.200
    97.024     2.363     0.200
    97.160     1.648     0.200
    97.814     2.197     0.200
    97.890     1.355     0.200
    98.606     1.140     0.200
    14.216     7.285     0.200
    14.247     7.996     0.200
    14.623     6.971     0.200
    14.923     6.869     0.200
    16.316     8.438     0.200
    18.076     4.576     0.200
    18.073     3.978     0.200
    18.193     5.297     0.200
    18.228     5.492     0.200
    18.439     1.139     0.200
    19.876     0.844     0.200
    19.908     0.441     0.200
    20.388     1.264     0.200
    20.896     0.444     0.200
    20.900     0.609     0.200
    21.359     2.671     0.200
    21.754     1.151     0.200
    21.962     0.609     0.200
    22.157     3.779     0.200
    22.173     1.074     0.200
    22.351     3.102     0.200
    22.388     0.512     0.200
    22.714     1.925     0.200
    22.765     0.118     0.200
    22.910     3.800     0.200
    23.008     3.858     0.200
    23.121     3.375     0.200
    23.237     0.210     0.200
    23.238     2.127     0.200
    23.335     5.933     0.200
    23.561     4.652     0.200
    23.579     2.689     0.200
    23.844     2.719     0.200
    23.904     2.581     0.200
    23.929     3.872     0.200
    23.952     2.360     0.200
    24.082     2.742     0.200
    24.082     2.772     0.200
    24.117     1.737     0.200
    24.387     0.870     0.200
    24.528     2.474     0.200
    24.675     4.416     0.200
    24.706     4.357     0.200
    25.082     1.462     0.200
    25.629     3.565     0.200
    25.813     4.499     0.200
    26.595     1.857     0.200
    26.593     4.809     0.200
    26.670     4.228     0.200
    26.810     4.768     0.200
    26.941     3.069     0.200
    26.941     2.710     0.200
    27.059     4.017     0.200
    27.041     6.379     0.200
    27.293     4.364     0.200
    27.363     3.675     0.200
    27.510     1.137     0.200
    27.522     3.619     0.200
    27.677     4.156     0.200
    27.841     2.932     0.200
    27.957     3.605     0.200
    28.226     4.625     0.200
    28.300     4.298     0.200
    28.412     8.242     0.200
    28.646     1.862     0.200
    29.043     4.696     0.200
    29.051     3.279     0.200
    29.136     6.867     0.200
    29.150     3.660     0.200
    29.763     4.820     0.200
    29.785     4.027     0.200
    29.913     3.643     0.200
    30.119     3.650     0.200
    30.286     3.752     0.200
    30.395     1.825     0.200
    30.408     3.564     0.200
    30.474     6.137     0.200
    30.496     5.172     0.200
    30.552     3.274     0.200
    31.203     3.825     0.200
    31.351     4.474     0.200
    31.388     2.348     0.200
    31.775     2.730     0.200
    32.010     6.368     0.200
    32.307     2.933     0.200
    32.357     2.039     0.200
    32.509     2.202     0.200
    32.702     4.238     0.200
    32.722     6.435     0.200
    32.827     1.138     0.200
    32.897     2.789     0.200
    33.360     1.011     0.200
    33.913     4.462     0.200
    33.971     4.564     0.200
    34.146     4.513     0.200
    34.282     3.894     0.200
    34.514     4.204     0.200
    34.538     4.105     0.200
    34.661     4.132     0.200
    34.708     3.004     0.200
    34.715     3.406     0.200
    34.792     3.839     0.200
    35.041     4.058     0.200
    35.777     3.030     0.200
    35.898     2.597     0.200
    36.592     4.165     0.200
    36.884     3.225     0.200
    36.830     5.219     0.200
    37.697     1.745     0.200
    43.282     3.408     0.200
    43.579     8.768     0.200
    45.595     1.366     0.200
    45.669     4.604     0.200
    46.590     1.231     0.200
    49.793     6.450     0.200
    51.488     2.288     0.200
    54.671     4.119     0.200
    55.502     2.438     0.200
    56.076     4.317     0.200
    56.135     4.305     0.200
    56.235     3.333     0.200
    56.295     3.286     0.200
    56.304     3.190     0.200
    56.378     5.120     0.200
    56.527     4.192     0.200
    57.110     2.915     0.200
    57.304     3.192     0.200
    57.336     3.400     0.200
    57.342     3.123     0.200
    57.511     2.635     0.200
    57.785     2.024     0.200
    58.885     2.124     0.200
    59.773     2.581     0.200
    59.837     2.608     0.200
    60.216     1.741     0.200
    60.734     3.890     0.200
    63.640     4.648     0.200
    65.580     2.375     0.200
    65.580     4.917     0.200
    67.341     4.317     0.200
    68.539     5.886     0.200
    71.623     1.525     0.200
    74.703     3.651     0.200
    75.681     3.391     0.200
    77.562     5.221     0.200
    78.222     4.779     0.200
    78.315     4.867     0.200
    78.669     4.812     0.200
    80.487     4.454     0.200
    80.639     2.913     0.200
    80.880     4.680     0.200
    81.208     2.474     0.200
    81.280     4.092     0.200
    81.318     4.089     0.200
    81.448     4.403     0.200
    81.891     4.461     0.200
    81.930     2.359     0.200
    82.258     3.225     0.200
    82.419     3.488     0.200
    82.746     3.093     0.200
    82.797     6.137     0.200
    82.937     4.180     0.200
    83.497     1.879     0.200
    83.574     2.213     0.200
    83.650     4.395     0.200
    83.678     5.151     0.200
    83.683     2.524     0.200
    83.722     3.476     0.200
    83.713     4.662     0.200
    83.897     5.820     0.200
    83.932     2.996     0.200
    84.043     4.015     0.200
    84.113     6.138     0.200
    84.318     4.125     0.200
    84.476     1.715     0.200
    84.505     3.786     0.200
    84.525     4.345     0.200
    84.602     3.376     0.200
    84.630     2.716     0.200
    84.827     0.644     0.200
    84.828     4.137     0.200
    84.857     1.993     0.200
    84.934     3.664     0.200
    84.982     4.242     0.200
    85.049     4.028     0.200
    85.046     4.044     0.200
    85.067     4.427     0.200
    85.163     3.157     0.200
    85.163     3.458     0.200
    85.152     2.842     0.200
    85.324     3.849     0.200
    85.388     2.031     0.200
    85.509     4.087     0.200
    85.607     1.443     0.200
    85.625     1.851     0.200
    85.653     1.626     0.200
    85.653     4.363     0.200
    85.798     3.093     0.200
    85.831     2.629     0.200
    85.918     3.998     0.200
    85.969     1.747     0.200
    86.000     1.390     0.200
    86.010     1.642     0.200
    86.033     3.130     0.200
    86.042     3.386     0.200
    86.048     1.355     0.200
    86.062     4.907     0.200
    86.116     1.520     0.200
    86.159     3.865     0.200
    86.270     2.720     0.200
    86.312     5.654     0.200
    86.362     1.807     0.200
    86.433     1.059     0.200
    86.495     1.451     0.200
    86.515     3.056     0.200
    86.653     4.117     0.200
    86.675     0.873     0.200
    86.674     1.074     0.200
    86.752     3.515     0.200
    86.764     4.057     0.200
    86.789     4.532     0.200
    86.798     7.969     0.200
    86.813     4.894     0.200
    86.823     1.347     0.200
    86.826     5.131     0.200
    87.170     5.858     0.200
    87.788     4.883     0.200
    87.962     3.775     0.200
    87.998     2.384     0.200
    88.098     0.611     0.200
    88.188     1.081     0.200
    88.243     0.821     0.200
    88.485     0.581     0.200
    88.485     0.677     0.200
    88.503     0.493     0.200
    88.549     6.074     0.200
    88.590     6.084     0.200
    88.643     3.833     0.200
    88.701     5.359     0.200
    89.182     2.896     0.200
    89.332     2.993     0.200
    89.674     1.292     0.200
    89.800     4.903     0.200
    89.911     2.387     0.200
    90.058     0.797     0.200
    90.060     0.892     0.200
    90.296     2.988     0.200
    90.460     0.624     0.200
    90.554     1.489     0.200
    90.621     3.878     0.200
    90.750     3.876     0.200
    90.964     1.507     0.200
    91.008     4.276     0.200
    91.283     3.302     0.200
    91.288     2.677     0.200
    91.919     5.254     0.200
    92.128     2.087     0.200
    92.588     3.162     0.200
    92.765     2.646     0.200
    92.941     2.736     0.200
    92.905     2.522     0.200
    93.022     3.062     0.200
    93.253     1.964     0.200
    93.645    -0.608     0.200
    94.022     5.960     0.200
    94.312     4.026     0.200
    94.333     3.132     0.200
    94.410     5.676     0.200
    94.813     3.230     0.200
    95.032     5.025     0.200
    15.284     4.256     0.200
    16.611     4.215     0.200
    17.638     4.353     0.200
    17.697     4.366     0.200
    18.079     4.261     0.200
    18.302     1.395     0.200
    19.877     1.369     0.200
    20.852     0.613     0.200
    21.184     2.865     0.200
    21.490     1.422     0.200
    21.631     3.242     0.200
    21.697     4.361     0.200
    21.844     3.089     0.200
    21.907    -0.052     0.200
    21.971     3.407     0.200
    22.017     5.265     0.200
    22.218     0.989     0.200
    22.260     0.361     0.200
    22.331     1.560     0.200
    22.437     5.075     0.200
    22.488     3.816     0.200
    22.672     0.544     0.200
    22.898     2.014     0.200
    22.985     0.199     0.200
    23.119     0.645     0.200
    23.079     3.896     0.200
    23.105     3.423     0.200
    23.514     4.026     0.200
    23.605     1.790     0.200
    23.663     4.660     0.200
    23.981     1.865     0.200
    24.043     4.663     0.200
    24.170     2.798     0.200
    24.173     0.990     0.200
    24.174     1.297     0.200
    24.211     4.329     0.200
    24.649     3.632     0.200
    25.010     1.282     0.200
    25.115     4.201     0.200
    25.224     3.509     0.200
    25.295     3.984     0.200
    25.349     4.725     0.200
    25.402     4.244     0.200
    25.569     3.383     0.200
    25.570     4.797     0.200
    25.945     3.471     0.200
    26.082     3.613     0.200
    26.149     4.789     0.200
    26.225     4.377     0.200
    26.347     4.865     0.200
    26.573     2.584     0.200
    26.618     1.677     0.200
    26.641     3.761     0.200
    26.830     3.821     0.200
    26.948     2.234     0.200
    26.983     3.014     0.200
    27.027     0.971     0.200
    27.067     3.727     0.200
    27.248     4.820     0.200
    27.469     1.309     0.200
    27.466     2.932     0.200
    27.587     3.437     0.200
    27.787     4.662     0.200
    28.064     3.571     0.200
    28.644     1.804     0.200
    28.751     3.609     0.200
    28.819     0.857     0.200
    29.263     4.663     0.200
    29.849     3.957     0.200
    30.035     3.279     0.200
    30.399     1.604     0.200
    30.835     3.490     0.200
    31.489    -0.569     0.200
    32.149     3.062     0.200
    32.510     1.144     0.200
    32.600     3.233     0.200
    32.718     1.958     0.200
    33.067     1.640     0.200
    33.124     0.404     0.200
    33.113     3.026     0.200
    33.139     4.390     0.200
    33.286     1.468     0.200
    33.723     4.930     0.200
    33.781     3.541     0.200
    33.809     3.870     0.200
    34.124     4.532     0.200
    34.207     4.893     0.200
    34.288     4.117     0.200
    34.573     1.216     0.200
    34.656     2.339     0.200
    34.693     3.515     0.200
    34.766     4.036     0.200
    34.847     3.584     0.200
    35.034     4.188     0.200
    35.206     4.065     0.200
    35.356     2.818     0.200
    35.483     3.151     0.200
    35.522     2.892     0.200
    36.229     3.567     0.200
    36.234     3.579     0.200
    37.414     1.020     0.200
    44.047     5.982     0.200
    45.529     1.034     0.200
    46.258     1.181     0.200
    46.324     2.109     0.200
    46.520     4.542     0.200
    50.254     4.719     0.200
    51.347     2.208     0.200
    55.139     2.056     0.200
    55.639     4.343     0.200
    55.811     3.509     0.200
    55.877     3.138     0.200
    56.709     2.298     0.200
    56.896     3.251     0.200
    56.909     3.581     0.200
    56.920     2.977     0.200
    57.110     2.574     0.200
    59.814     1.972     0.200
    61.214     3.425     0.200
    65.849     0.208     0.200
    75.740     1.492     0.200
    76.961     2.940     0.200
    78.249     2.107     0.200
    78.337     2.222     0.200
    78.696     2.147     0.200
    79.867     1.928     0.200
    80.069     2.788     0.200
    80.411     3.124     0.200
    80.470     2.110     0.200
    80.779     3.554     0.200
    80.780     2.112     0.200
    80.883     3.201     0.200
    80.997     2.083     0.200
    81.068     4.016     0.200
    81.222     2.998     0.200
    81.357     2.384     0.200
    81.406     1.922     0.200
    81.417     3.262     0.200
    81.439     2.747     0.200
    81.600     3.698     0.200
    82.023     2.132     0.200
    82.047     2.544     0.200
    82.122     1.982     0.200
    82.184     2.829     0.200
    82.392     2.563     0.200
    82.579     2.515     0.200
    83.629     3.346     0.200
    83.646     2.636     0.200
    83.817     3.191     0.200
    83.873     3.567     0.200
    84.064     2.985     0.200
    84.064     2.932     0.200
    84.547     3.276     0.200
    84.649     3.369     0.200
    85.000     2.796     0.200
    85.032     3.237     0.200
    85.100     2.893     0.200
    85.100     1.994     0.200
    85.221     3.461     0.200
    85.297     3.729     0.200
    85.265     1.969     0.200
    85.462     3.618     0.200
    85.489     3.654     0.200
    85.505     2.562     0.200
    85.654     3.607     0.200
    85.689     3.161     0.200
    85.716     3.236     0.200
    85.941     2.763     0.200
    86.047     2.999     0.200
    86.046     2.896     0.200
    86.067     3.391     0.200
    86.079     3.033     0.200
    86.169     3.950     0.200
    86.287     3.347     0.200
    86.334     3.387     0.200
    86.390     3.539     0.200
    86.396     2.870     0.200
    86.498     2.468     0.200
    86.575     3.091     0.200
    86.737     2.099     0.200
    86.768     3.281     0.200
    86.790     2.492     0.200
    86.804     2.691     0.200
    86.881     2.598     0.200
    87.103     2.117     0.200
    87.126     4.615     0.200
    87.152     2.578     0.200
    87.245     3.228     0.200
    88.080     3.439     0.200
    88.144     2.434     0.200
    88.323     2.791     0.200
    88.543     2.550     0.200
    88.961     3.424     0.200
    89.056     1.637     0.200
    89.417     3.545     0.200
    89.745     2.910     0.200
    90.319     3.135     0.200
    90.560     3.013     0.200
    90.866     0.489     0.200
    91.631     2.442     0.200
    91.940     2.612     0.200
    92.062     1.549     0.200
    93.260     2.819     0.200
    93.380     3.068     0.200
    93.546     2.603     0.200
    93.610     3.107     0.200
    94.428     1.253     0.200
    94.808     2.609     0.200
    15.834     5.941     0.200
    15.908     5.562     0.200
    15.908     8.271     0.200
    15.970     5.332     0.200
    16.286     4.273     0.200
    16.489     6.606     0.200
    16.566     8.554     0.200
    16.592     5.902     0.200
    16.669     4.575     0.200
    16.877     6.485     0.200
    16.979     4.945     0.200
    16.979     5.484     0.200
    17.140     4.500     0.200
    17.298     5.558     0.200
    17.347     4.722     0.200
    17.485     4.642     0.200
    17.478     5.749     0.200
    17.501     5.756     0.200
    17.509     5.300     0.200
    17.509     5.460     0.200
    17.563     5.001     0.200
    17.596     5.843     0.200
    17.648     6.068     0.200
    17.767     4.238     0.200
    17.767     4.447     0.200
    17.808     5.030     0.200
    17.853     4.631     0.200
    18.072     5.123     0.200
    18.289     0.840     0.200
    18.891     1.608     0.200
    19.812     1.587     0.200
    20.103     2.911     0.200
    20.196     1.486     0.200
    20.501     2.628     0.200
    20.802     2.026     0.200
    20.804     0.309     0.200
    20.960     2.809     0.200
    21.027     2.761     0.200
    21.049     4.310     0.200
    21.113     4.411     0.200
    21.191     2.837     0.200
    21.191     3.548     0.200
    21.237     4.849     0.200
    21.286     4.343     0.200
    21.318     2.016     0.200
    21.324     4.454     0.200
    21.335     4.454     0.200
    21.357     1.778     0.200
    21.469     3.302     0.200
    21.469     5.595     0.200
    21.481     4.612     0.200
    21.517     0.999     0.200
    21.531     0.990     0.200
    21.538     4.691     0.200
    21.594     1.239     0.200
    21.589     3.260     0.200
    21.590     4.711     0.200
    21.657     4.343     0.200
    21.746     3.852     0.200
    21.844     4.650     0.200
    21.849     4.312     0.200
    21.863    -0.225     0.200
    21.863     0.054     0.200
    21.980     4.280     0.200
    22.037     4.032     0.200
    22.049     0.458     0.200
    22.051     0.656     0.200
    22.138     0.849     0.200
    22.154     5.781     0.200
    22.199     4.265     0.200
    22.231     4.319     0.200
    22.244     0.466     0.200
    22.244     0.605     0.200
    22.269     4.067     0.200
    22.271     3.498     0.200
    22.281     3.397     0.200
    22.420     2.858     0.200
    22.424     4.070     0.200
    22.447     0.333     0.200
    22.498     3.596     0.200
    22.518     3.880     0.200
    22.572     4.215     0.200
    22.630     4.092     0.200
    22.642     0.434     0.200
    22.645     3.226     0.200
    22.639     4.142     0.200
    22.726     4.422     0.200
    22.761     3.806     0.200
    22.834     3.599     0.200
    22.860     4.415     0.200
    22.903     4.102     0.200
    22.910     3.699     0.200
    22.918     3.941     0.200
    22.975     0.578     0.200
    22.975     2.691     0.200
    22.996     3.664     0.200
    23.035     3.773     0.200
    23.050     4.003     0.200
    23.099     0.462     0.200
    23.094     3.996     0.200
    23.229     5.382     0.200
    23.237     3.694     0.200
    23.247     4.148     0.200
    23.291     3.729     0.200
    23.330     3.657     0.200
    23.384     3.963     0.200
    23.396     3.561     0.200
    23.418     3.853     0.200
    23.475     1.079     0.200
    23.496     2.760     0.200
    23.523     3.913     0.200
    23.540     0.459     0.200
    23.535     3.855     0.200
    23.533     3.589     0.200
    23.568     2.548     0.200
    23.627     3.429     0.200
    23.637     3.625     0.200
    23.779     3.793     0.200
    23.779     4.163     0.200
    23.816     4.345     0.200
    23.873     4.309     0.200
    23.890     1.927     0.200
    23.892     4.077     0.200
    23.898     4.213     0.200
    23.966     3.213     0.200
    24.009     4.700     0.200
    24.075     2.290     0.200
    24.071     3.826     0.200
    24.090     1.426     0.200
    24.135     4.426     0.200
    24.177     4.907     0.200
    24.177     4.590     0.200
    24.177     4.679     0.200
    24.286     0.575     0.200
    24.286     1.046     0.200
    24.315     1.343     0.200
    24.306     4.529     0.200
    24.414     2.536     0.200
    24.461     4.809     0.200
    24.461     4.651     0.200
    24.467     4.632     0.200
    24.484     4.289     0.200
    24.502     2.112     0.200
    24.755     3.629     0.200
    24.754     4.467     0.200
    24.783     4.644     0.200
    24.798     4.774     0.200
    24.856     4.014     0.200
    24.880     4.739     0.200
    24.914     5.401     0.200
    24.943     4.574     0.200
    24.949     4.381     0.200
    24.973     1.322     0.200
    24.973     1.447     0.200
    24.985     3.521     0.200
    25.105     3.284     0.200
    25.103     4.388     0.200
    25.144     0.777     0.200
    25.144     4.723     0.200
    25.169     4.334     0.200
    25.169     4.164     0.200
    25.220     3.810     0.200
    25.244     4.932     0.200
    25.270     4.139     0.200
    25.310     5.077     0.200
    25.335     3.678     0.200
    25.335     3.297     0.200
    25.335     3.996     0.200
    25.380     4.490     0.200
    25.401     3.854     0.200
    25.451     4.647     0.200
    25.491     4.135     0.200
    25.488     4.709     0.200
    25.499     5.523     0.200
    25.560     4.117     0.200
    25.586     4.427     0.200
    25.602     4.856     0.200
    25.710     4.795     0.200
    25.713     5.021     0.200
    25.730     4.191     0.200
    25.842     3.373     0.200
    25.892     4.483     0.200
    25.895     4.632     0.200
    25.896     4.417     0.200
    26.047     3.953     0.200
    26.054     3.343     0.200
    26.059     4.984     0.200
    26.075     5.152     0.200
    26.099     4.782     0.200
    26.109     4.241     0.200
    26.110     3.359     0.200
    26.155     4.196     0.200
    26.164     3.062     0.200
    26.168     4.304     0.200
    26.188     5.015     0.200
    26.198     5.063     0.200
    26.312     4.380     0.200
    26.325     3.128     0.200
    26.366     2.026     0.200
    26.361     4.467     0.200
    26.370     4.636     0.200
    26.376     4.496     0.200
    26.429     4.252     0.200
    26.437     3.951     0.200
    26.494     4.855     0.200
    26.506     5.108     0.200
    26.546     1.974     0.200
    26.592     5.529     0.200
    26.600     3.986     0.200
    26.626     0.979     0.200
    26.639     4.252     0.200
    26.664     2.497     0.200
    26.664     2.578     0.200
    26.676     3.725     0.200
    26.702     3.773     0.200
    26.719     4.079     0.200
    26.767     3.805     0.200
    26.801     4.309     0.200
    26.862     2.546     0.200
    26.855     3.752     0.200
    26.933     4.018     0.200
    26.979     3.933     0.200
    27.002     4.882     0.200
    27.011     2.336     0.200
    27.011     2.539     0.200
    27.020     0.687     0.200
    27.028     3.971     0.200
    27.039     5.056     0.200
    27.041     4.045     0.200
    27.081     2.793     0.200
    27.194     3.964     0.200
    27.206     4.461     0.200
    27.210     3.749     0.200
    27.210     3.924     0.200
    27.282     4.046     0.200
    27.395     4.067     0.200
    27.404     3.880     0.200
    27.420     1.009     0.200
    27.408     6.041     0.200
    27.494     4.812     0.200
    27.508     4.931     0.200
    27.519     6.261     0.200
    27.535     3.557     0.200
    27.561     2.984     0.200
    27.562     4.133     0.200
    27.599     3.637     0.200
    27.627     3.091     0.200
    27.640     4.657     0.200
    27.640     4.796     0.200
    27.660     4.243     0.200
    27.677     4.977     0.200
    27.703     4.214     0.200
    27.707     3.072     0.200
    27.726     2.739     0.200
    27.727     4.710     0.200
    27.780     4.804     0.200
    27.768     5.235     0.200
    27.773     3.467     0.200
    27.848     4.082     0.200
    27.856     3.569     0.200
    27.868     3.743     0.200
    27.890     2.113     0.200
    27.912     4.449     0.200
    27.944     3.981     0.200
    27.952     4.206     0.200
    28.011     4.790     0.200
    28.075     4.133     0.200
    28.080     2.640     0.200
    28.119     4.842     0.200
    28.163     3.792     0.200
    28.189     3.483     0.200
    28.226     5.106     0.200
    28.232     4.058     0.200
    28.270     4.521     0.200
    28.259     7.338     0.200
    28.259     4.137     0.200
    28.259     4.719     0.200
    28.327     5.058     0.200
    28.323     4.839     0.200
    28.382     4.140     0.200
    28.440     4.881     0.200
    28.476     4.369     0.200
    28.499     4.783     0.200
    28.511     1.872     0.200
    28.528     4.652     0.200
    28.531     4.904     0.200
    28.552     5.539     0.200
    28.563     4.915     0.200
    28.568     4.771     0.200
    28.580     1.516     0.200
    28.620     4.109     0.200
    28.631     3.484     0.200
    28.714     3.909     0.200
    28.731     4.556     0.200
    28.741     4.418     0.200
    28.774     4.530     0.200
    28.781     0.984     0.200
    28.783     3.733     0.200
    28.804     3.423     0.200
    28.799     5.133     0.200
    28.823     2.469     0.200
    28.823     3.559     0.200
    28.827     4.690     0.200
    28.834     3.632     0.200
    28.846     4.023     0.200
    28.859     3.467     0.200
    28.859     3.747     0.200
    28.864     4.954     0.200
    28.879     4.409     0.200
    28.893     4.623     0.200
    28.965     4.995     0.200
    29.013     4.247     0.200
    29.040     3.891     0.200
    29.067     3.591     0.200
    29.078     3.992     0.200
    29.127     3.653     0.200
    29.211     5.187     0.200
    29.239     5.034     0.200
    29.249     3.672     0.200
    29.285     3.508     0.200
    29.408     4.868     0.200
    29.422     4.161     0.200
    29.479     4.172     0.200
    29.495     3.890     0.200
    29.547     2.342     0.200
    29.543     4.618     0.200
    29.607     4.023     0.200
    29.610     3.491     0.200
    29.626     3.425     0.200
    29.643     5.058     0.200
    29.681     3.871     0.200
    29.687     3.769     0.200
    29.723     3.927     0.200
    29.766     4.664     0.200
    29.779     4.103     0.200
    29.800     2.046     0.200
    29.840     3.251     0.200
    29.884     2.219     0.200
    29.877     3.909     0.200
    29.876     4.989     0.200
    29.892     3.770     0.200
    29.963     3.875     0.200
    29.980     4.269     0.200
    29.980     3.947     0.200
    29.997     4.173     0.200
    30.040     3.437     0.200
    30.039     3.625     0.200
    30.045     4.849     0.200
    30.045     4.160     0.200
    30.089     4.114     0.200
    30.108     2.406     0.200
    30.149     3.330     0.200
    30.162     4.108     0.200
    30.180     2.073     0.200
    30.180     2.323     0.200
    30.184     4.911     0.200
    30.193     4.117     0.200
    30.275     1.251     0.200
    30.271     3.402     0.200
    30.278     3.889     0.200
    30.300     3.448     0.200
    30.334     1.797     0.200
    30.349     4.635     0.200
    30.421     3.536     0.200
    30.443     3.332     0.200
    30.456     1.616     0.200
    30.472     3.612     0.200
    30.529     0.888     0.200
    30.527     3.460     0.200
    30.597     3.061     0.200
    30.598     5.100     0.200
    30.638     4.010     0.200
    30.656     3.376     0.200
    30.661     4.213     0.200
    30.765     3.544     0.200
    30.778     3.181     0.200
    30.767     4.332     0.200
    30.801     3.300     0.200
    30.856     5.046     0.200
    30.877     2.460     0.200
    30.889     4.227     0.200
    30.915     2.748     0.200
    30.926     2.918     0.200
    30.942     3.291     0.200
    30.973     3.967     0.200
    31.016     3.080     0.200
    31.033     2.503     0.200
    31.040     5.091     0.200
    31.072     3.472     0.200
    31.079     2.577     0.200
    31.079     2.688     0.200
    31.110     3.077     0.200
    31.112     3.004     0.200
    31.220     1.443     0.200
    31.214     3.898     0.200
    31.302     3.134     0.200
    31.304     3.315     0.200
    31.333     2.994     0.200
    31.339     2.144     0.200
    31.341     2.991     0.200
    31.412     2.843     0.200
    31.475     3.711     0.200
    31.498     1.052     0.200
    31.495     2.726     0.200
    31.495     2.673     0.200
    31.508     3.424     0.200
    31.578     4.063     0.200
    31.615     2.603     0.200
    31.691     2.655     0.200
    31.706     4.003     0.200
    31.719     2.745     0.200
    31.737     3.306     0.200
    31.830     1.943     0.200
    31.830     2.552     0.200
    31.849     3.584     0.200
    31.865     4.180     0.200
    31.919     2.424     0.200
    31.916     4.470     0.200
    31.951     3.221     0.200
    31.983     3.038     0.200
    32.009     2.799     0.200
    32.050     3.005     0.200
    32.159     3.878     0.200
    32.184     3.332     0.200
    32.220     3.279     0.200
    32.223     5.008     0.200
    32.248     2.281     0.200
    32.324     3.333     0.200
    32.346     2.256     0.200
    32.386     2.967     0.200
    32.394     2.506     0.200
    32.412     2.710     0.200
    32.423     3.210     0.200
    32.446     1.411     0.200
    32.514     3.331     0.200
    32.546     2.334     0.200
    32.564     2.150     0.200
    32.569     2.360     0.200
    32.690     3.782     0.200
    32.690     3.565     0.200
    32.711     3.020     0.200
    32.731     0.719     0.200
    32.736     5.058     0.200
    32.748     2.140     0.200
    32.764     1.955     0.200
    32.774     1.288     0.200
    32.787     2.461     0.200
    32.814    -0.253     0.200
    32.829     2.898     0.200
    32.854     2.360     0.200
    32.893     2.323     0.200
    32.938     3.256     0.200
    32.979     3.621     0.200
    32.982     3.443     0.200
    33.015     3.711     0.200
    33.078     1.701     0.200
    33.114    -0.253     0.200
    33.153     0.526     0.200
    33.153    -0.300     0.200
    33.165     3.077     0.200
    33.183     1.711     0.200
    33.193     3.493     0.200
    33.226     4.372     0.200
    33.270     2.532     0.200
    33.276     3.305     0.200
    33.440     3.887     0.200
    33.447     3.094     0.200
    33.495     2.349     0.200
    33.502     3.627     0.200
    33.513     3.415     0.200
    33.562     2.511     0.200
    33.580     2.982     0.200
    33.578     4.088     0.200
    33.635     3.083     0.200
    33.657     3.217     0.200
    33.792     2.419     0.200
    33.846     3.815     0.200
    33.883     3.074     0.200
    33.886     2.190     0.200
    33.886     3.250     0.200
    33.894     3.910     0.200
    33.950     2.351     0.200
    33.970     3.729     0.200
    34.014     3.108     0.200
    34.012     3.301     0.200
    34.040     3.511     0.200
    34.149     3.162     0.200
    34.238     3.843     0.200
    34.251     2.804     0.200
    34.360     4.092     0.200
    34.370     2.863     0.200
    34.408     3.753     0.200
    34.454     3.476     0.200
    34.508     1.613     0.200
    34.559     3.520     0.200
    34.594     1.434     0.200
    34.652     2.361     0.200
    34.681     4.045     0.200
    34.736     3.069     0.200
    34.822     1.763     0.200
    34.828     3.918     0.200
    34.846     1.161     0.200
    34.965     0.638     0.200
    34.969     3.679     0.200
    34.992     3.029     0.200
    35.022     3.873     0.200
    35.105     3.030     0.200
    35.111     2.976     0.200
    35.116     3.468     0.200
    35.162     3.188     0.200
    35.214     2.969     0.200
    35.483     2.355     0.200
    35.477     2.697     0.200
    35.499     1.160     0.200
    35.512     1.716     0.200
    35.547     4.035     0.200
    35.658     2.891     0.200
    35.683     2.993     0.200
    35.696     3.132     0.200
    35.723     2.695     0.200
    35.799     3.925     0.200
    36.023     2.758     0.200
    36.149     3.621     0.200
    36.151     2.808     0.200
    36.305     2.730     0.200
    36.333     3.483     0.200
    36.528     3.454     0.200
    36.585     3.492     0.200
    37.144     4.239     0.200
    37.357     1.814     0.200
    37.366     1.040     0.200
    37.464     1.863     0.200
    37.464     1.273     0.200
    37.560     0.964     0.200
    37.699     3.268     0.200
    37.899     2.850     0.200
    38.131     1.923     0.200
    41.211     3.841     0.200
    41.744     1.536     0.200
    43.893     5.035     0.200
    44.930     5.348     0.200
    44.930     4.639     0.200
    44.930     4.948     0.200
    45.490     1.490     0.200
    45.638     4.140     0.200
    45.983     4.405     0.200
    46.332     1.075     0.200
    46.627     4.330     0.200
    46.627     2.459     0.200
    47.621     2.778     0.200
    49.262     3.644     0.200
    50.846     2.125     0.200
    52.236     4.608     0.200
    52.479     4.076     0.200
    53.816     3.154     0.200
    54.047     4.303     0.200
    54.132     4.266     0.200
    54.357     4.917     0.200
    54.358     4.459     0.200
    54.611     3.149     0.200
    54.863     2.913     0.200
    55.019     4.648     0.200
    55.228     2.440     0.200
    55.228     2.290     0.200
    55.228     2.590     0.200
    55.777     3.386     0.200
    55.829     3.812     0.200
    55.934     3.353     0.200
    55.996     3.277     0.200
    56.715     4.860     0.200
    56.806     5.011     0.200
    57.010     3.209     0.200
    57.219     2.700     0.200
    57.476     4.176     0.200
    57.565     1.511     0.200
    57.798     3.859     0.200
    57.858     2.662     0.200
    58.327     4.388     0.200
    58.560     2.390     0.200
    59.400     4.760     0.200
    59.474     2.055     0.200
    59.544     4.871     0.200
    59.544     6.031     0.200
    59.597     4.601     0.200
    59.801     3.572     0.200
    59.927     2.137     0.200
    60.661     2.988     0.200
    61.036     3.101     0.200
    61.874     2.441     0.200
    62.253     2.380     0.200
    63.937     3.679     0.200
    63.937     3.199     0.200
    65.235     2.995     0.200
    65.626     1.697     0.200
    65.714     2.544     0.200
    66.484     3.039     0.200
    67.017     0.792     0.200
    67.608     5.025     0.200
    68.259     2.811     0.200
    68.845     2.755     0.200
    69.666     5.721     0.200
    69.720     4.362     0.200
    69.886     1.821     0.200
    70.777     2.067     0.200
    70.894     3.995     0.200
    71.455     2.119     0.200
    74.458     6.355     0.200
    75.387     3.358     0.200
    75.387     2.778     0.200
    75.480     5.245     0.200
    77.002     5.208     0.200
    77.380     3.758     0.200
    77.380     1.209     0.200
    77.380     3.489     0.200
    77.654     2.679     0.200
    77.852     2.452     0.200
    77.978     2.706     0.200
    78.177     2.755     0.200
    78.177     1.942     0.200
    78.180     2.054     0.200
    78.190     2.800     0.200
    78.195     2.913     0.200
    78.266     2.859     0.200
    78.326     2.136     0.200
    78.328     2.424     0.200
    78.440     2.498     0.200
    78.506     3.277     0.200
    78.676     2.319     0.200
    78.726     2.795     0.200
    78.737     2.503     0.200
    78.831     2.446     0.200
    78.864     3.066     0.200
    79.156     2.154     0.200
    79.173     2.684     0.200
    79.285     2.415     0.200
    79.373     2.918     0.200
    79.446     1.995     0.200
    79.568     3.021     0.200
    79.590     2.480     0.200
    79.595     1.902     0.200
    79.715     1.921     0.200
    79.729     2.586     0.200
    79.764     3.335     0.200
    79.850     2.699     0.200
    79.958     1.886     0.200
    79.968     2.382     0.200
    80.003     2.462     0.200
    80.003     2.132     0.200
    80.083     2.583     0.200
    80.162     2.708     0.200
    80.176     2.431     0.200
    80.256     2.918     0.200
    80.261     1.894     0.200
    80.336     2.918     0.200
    80.335     2.951     0.200
    80.365     3.534     0.200
    80.429     2.871     0.200
    80.478     2.538     0.200
    80.650     3.423     0.200
    80.677     2.913     0.200
    80.764     3.377     0.200
    80.775     3.017     0.200
    80.907     2.452     0.200
    80.952     3.875     0.200
    80.977     3.542     0.200
    81.037     1.869     0.200
    81.069     3.552     0.200
    81.113     2.814     0.200
    81.113     2.673     0.200
    81.243     2.225     0.200
    81.243     2.725     0.200
    81.259     2.452     0.200
    81.269     3.119     0.200
    81.293     3.158     0.200
    81.302     3.754     0.200
    81.307     2.984     0.200
    81.334     3.141     0.200
    81.420     3.107     0.200
    81.476     2.492     0.200
    81.485     3.741     0.200
    81.532     2.916     0.200
    81.640     3.727     0.200
    81.762     3.382     0.200
    81.813     3.071     0.200
    81.907     2.118     0.200
    81.907     4.016     0.200
    81.940     3.485     0.200
    82.022     3.044     0.200
    82.076     3.234     0.200
    82.097     2.220     0.200
    82.295     3.642     0.200
    82.389     2.094     0.200
    82.446     2.695     0.200
    82.465     3.439     0.200
    82.883     4.385     0.200
    82.883     3.924     0.200
    83.285     3.136     0.200
    83.331     4.059     0.200
    83.339     4.102     0.200
    83.428     2.412     0.200
    83.531     3.220     0.200
    83.546     3.105     0.200
    83.573    -0.466     0.200
    83.694     3.664     0.200
    83.709     3.200     0.200
    83.777     4.049     0.200
    83.826     2.870     0.200
    83.913     6.365     0.200
    83.940     3.047     0.200
    83.956     3.447     0.200
    83.956     3.209     0.200
    84.120     3.354     0.200
    84.260     4.192     0.200
    84.354     4.687     0.200
    84.459     2.554     0.200
    84.523     3.329     0.200
    84.523     2.829     0.200
    84.537     3.857     0.200
    84.562     3.632     0.200
    84.563     4.789     0.200
    84.617     4.255     0.200
    84.630     2.800     0.200
    84.859     2.834     0.200
    84.866     4.261     0.200
    84.955     3.336     0.200
    84.955     6.185     0.200
    84.970     4.597     0.200
    84.998     4.099     0.200
    85.005     3.753     0.200
    85.060     2.826     0.200
    85.060     3.002     0.200
    85.106     3.461     0.200
    85.185     4.324     0.200
    85.352     4.309     0.200
    85.353     1.954     0.200
    85.353     0.864     0.200
    85.391     3.074     0.200
    85.451     3.678     0.200
    85.498     2.341     0.200
    85.498     3.571     0.200
    85.597     2.349     0.200
    85.602     3.776     0.200
    85.761    -1.365     0.200
    85.761     4.115     0.200
    85.780     3.040     0.200
    85.783     3.328     0.200
    85.800     2.941     0.200
    85.840     4.193     0.200
    85.847     2.272     0.200
    85.949     3.795     0.200
    85.970     2.601     0.200
    85.970     2.602     0.200
    85.988     2.210     0.200
    86.024     2.433     0.200
    86.044     3.636     0.200
    86.059     4.480     0.200
    86.098     1.971     0.200
    86.098     4.719     0.200
    86.130     2.509     0.200
    86.180     3.885     0.200
    86.187     2.629     0.200
    86.286     4.223     0.200
    86.313     3.711     0.200
    86.321     2.672     0.200
    86.412     2.022     0.200
    86.468     2.650     0.200
    86.483     2.654     0.200
    86.484     2.267     0.200
    86.515     3.317     0.200
    86.556     4.357     0.200
    86.649     4.062     0.200
    86.649     3.560     0.200
    86.650     1.954     0.200
    86.652     1.746     0.200
    86.665     3.781     0.200
    86.717     2.772     0.200
    86.780     3.023     0.200
    86.797     2.235     0.200
    86.809     3.576     0.200
    86.810     3.082     0.200
    86.822     2.714     0.200
    87.018     1.760     0.200
    87.018     4.681     0.200
    87.058     3.405     0.200
    87.073     2.293     0.200
    87.128     2.928     0.200
    87.150     2.318     0.200
    87.155     3.492     0.200
    87.283     3.224     0.200
    87.343     5.285     0.200
    87.754     3.013     0.200
    87.807     3.359     0.200
    87.988     3.101     0.200
    88.022     3.442     0.200
    88.065     2.438     0.200
    88.109     3.427     0.200
    88.233     2.239     0.200
    88.355     2.766     0.200
    88.452     2.409     0.200
    88.460     1.872     0.200
    88.467     2.538     0.200
    88.476     2.796     0.200
    88.550     2.946     0.200
    88.610     2.664     0.200
    88.626     2.988     0.200
    88.792     3.305     0.200
    88.950     3.065     0.200
    88.951     6.758     0.200
    89.000     2.229     0.200
    89.040     3.142     0.200
    89.102     2.279     0.200
    89.133     3.204     0.200
    89.139     2.374     0.200
    89.171     2.625     0.200
    89.173     3.315     0.200
    89.311     2.968     0.200
    89.331     2.875     0.200
    89.344     3.412     0.200
    89.465     3.107     0.200
    89.512     2.525     0.200
    89.625     2.799     0.200
    89.657     2.547     0.200
    90.034     2.790     0.200
    90.049     1.819     0.200
    90.049     2.119     0.200
    90.058     2.975     0.200
    90.248     3.592     0.200
    90.248     3.592     0.200
    90.247     2.864     0.200
    90.247     4.393     0.200
    90.493     0.648     0.200
    90.494     2.442     0.200
    90.494     2.642     0.200
    90.534     3.188     0.200
    90.562     2.325     0.200
    90.618     3.065     0.200
    90.620     3.158     0.200
    90.697     3.201     0.200
    90.779     3.218     0.200
    90.808     2.984     0.200
    90.840     1.376     0.200
    90.840     1.813     0.200
    90.980     3.215     0.200
    91.171     3.370     0.200
    91.224     2.983     0.200
    91.224     2.753     0.200
    91.370     3.977     0.200
    91.460     3.157     0.200
    91.673     0.473     0.200
    91.741     2.659     0.200
    91.738     2.100     0.200
    91.738     2.670     0.200
    91.748     2.257     0.200
    91.870     1.063     0.200
    91.870     3.063     0.200
    91.994     2.886     0.200
    92.080     2.791     0.200
    92.080     2.580     0.200
    92.095     4.620     0.200
    92.180     2.925     0.200
    92.314     4.609     0.200
    92.382     3.168     0.200
    92.526     3.181     0.200
    92.526     2.931     0.200
    92.546     2.938     0.200
    92.726     3.021     0.200
    92.789     1.116     0.200
    92.797     2.878     0.200
    92.875     2.921     0.200
    92.881     6.992     0.200
    92.896     2.953     0.200
    92.898     4.915     0.200
    92.995     7.467     0.200
    93.014     1.277     0.200
    93.055     2.789     0.200
    93.121     2.431     0.200
    93.136     0.718     0.200
    93.209     3.381     0.200
    93.227     2.315     0.200
    93.237     3.170     0.200
    93.489     2.770     0.200
    93.494     1.668     0.200
    93.505     2.515     0.200
    93.520     0.948     0.200
    93.564     2.745     0.200
    93.768     2.766     0.200
    93.768     3.007     0.200
    93.785     3.177     0.200
    93.943     2.663     0.200
    94.032     2.711     0.200
    94.066     2.235     0.200
    94.235     2.853     0.200
    94.243     1.882     0.200
    94.246     2.612     0.200
    94.358     3.496     0.200
    94.364     3.868     0.200
    94.652     2.921     0.200
    94.720     3.298     0.200
    94.720     3.538     0.200
    94.747     2.315     0.200
    94.884     2.886     0.200
    94.887     3.470     0.200
    95.175     3.255     0.200
    95.207     3.835     0.200
    95.237     3.074     0.200
    95.465     3.730     0.200
    95.928     3.323     0.200
    95.973     3.617     0.200
    96.084     3.155     0.200
    96.084     3.915     0.200
    96.084     3.715     0.200
    96.094     3.466     0.200
    96.304     1.893     0.200
    96.386     3.340     0.200
    96.624     2.575     0.200
    96.624     3.165     0.200
    96.804     3.545     0.200
    96.992     3.795     0.200
    97.007     3.428     0.200
    97.199     1.759     0.200
    97.317     2.578     0.200
    97.317     2.610     0.200
    98.811    -0.321     0.200
    14.858    10.845     0.200
    15.890     8.757     0.200
    15.890     9.155     0.200
    16.299     4.473     0.200
    16.470     8.311     0.200
    16.470     8.530     0.200
    16.683     4.365     0.200
    17.153     4.415     0.200
    17.332     3.424     0.200
    17.361     4.526     0.200
    17.490     6.054     0.200
    17.498     4.411     0.200
    17.781     4.058     0.200
    17.819     4.557     0.200
    17.867     4.481     0.200
    18.290     0.906     0.200
    18.398     1.324     0.200
    18.891     1.365     0.200
    19.807     0.906     0.200
    20.194     1.597     0.200
    20.490     2.063     0.200
    20.800    -0.287     0.200
    20.800     3.241     0.200
    20.970     3.105     0.200
    20.983     4.926     0.200
    21.025     0.851     0.200
    20.999     4.584     0.200
    21.064     4.365     0.200
    21.127     4.299     0.200
    21.202     3.185     0.200
    21.202     3.296     0.200
    21.251     4.769     0.200
    21.302     4.334     0.200
    21.355     2.048     0.200
    21.340     4.601     0.200
    21.351     5.041     0.200
    21.450     4.738     0.200
    21.515     1.004     0.200
    21.496     4.533     0.200
    21.537     1.219     0.200
    21.552     4.681     0.200
    21.592     2.373     0.200
    21.645     7.192     0.200
    21.604     4.735     0.200
    21.672     4.282     0.200
    21.761     4.843     0.200
    21.860    -0.283     0.200
    21.859     4.303     0.200
    21.859     4.533     0.200
    21.859     3.902     0.200
    21.859     4.728     0.200
    21.864     4.406     0.200
    22.044     0.157     0.200
    22.054     0.680     0.200
    22.050     3.944     0.200
    22.254     4.791     0.200
    22.213     4.194     0.200
    22.244     0.250     0.200
    22.245     4.231     0.200
    22.282     4.221     0.200
    22.295     4.419     0.200
    22.446    -0.127     0.200
    22.437     3.929     0.200
    22.533     4.165     0.200
    22.588     4.643     0.200
    22.641     0.025     0.200
    22.643     4.093     0.200
    22.655     2.944     0.200
    22.654     4.277     0.200
    22.774     3.828     0.200
    22.874     4.227     0.200
    22.917     3.774     0.200
    22.926     4.401     0.200
    22.970     0.558     0.200
    22.932     3.863     0.200
    22.984     2.299     0.200
    23.012     4.235     0.200
    23.051     4.239     0.200
    23.065     4.335     0.200
    23.099     0.182     0.200
    23.108     4.162     0.200
    23.245     5.692     0.200
    23.251     3.792     0.200
    23.262     4.147     0.200
    23.304     4.486     0.200
    23.344     3.847     0.200
    23.397     4.322     0.200
    23.411     3.912     0.200
    23.434     4.182     0.200
    23.473     0.334     0.200
    23.534     0.941     0.200
    23.536     4.396     0.200
    23.548     4.098     0.200
    23.580     2.855     0.200
    23.640     3.008     0.200
    23.653     3.971     0.200
    23.792     3.972     0.200
    23.795     4.434     0.200
    23.830     4.588     0.200
    23.882     2.314     0.200
    23.888     4.666     0.200
    23.905     4.205     0.200
    23.914     4.414     0.200
    23.978     3.599     0.200
    24.022     4.485     0.200
    24.067     2.928     0.200
    24.082     1.535     0.200
    24.087     4.547     0.200
    24.150     4.507     0.200
    24.192     4.939     0.200
    24.192     4.834     0.200
    24.193     4.556     0.200
    24.310     1.273     0.200
    24.322     4.728     0.200
    24.423     2.411     0.200
    24.495     2.123     0.200
    24.476     4.863     0.200
    24.476     4.673     0.200
    24.481     4.497     0.200
    24.497     4.282     0.200
    24.767     3.757     0.200
    24.770     4.463     0.200
    24.798     4.605     0.200
    24.863     4.249     0.200
    24.813     4.860     0.200
    24.868     3.648     0.200
    24.970     0.999     0.200
    24.963     4.345     0.200
    24.959     4.779     0.200
    24.997     3.430     0.200
    25.114     3.013     0.200
    25.143     0.966     0.200
    25.117     4.448     0.200
    25.160     4.849     0.200
    25.182     4.257     0.200
    25.182     4.019     0.200
    25.231     3.770     0.200
    25.257     4.730     0.200
    25.285     4.374     0.200
    25.324     4.980     0.200
    25.348     3.861     0.200
    25.394     4.507     0.200
    25.412     3.843     0.200
    25.466     5.207     0.200
    25.503     3.853     0.200
    25.503     4.937     0.200
    25.515     5.116     0.200
    25.574     4.176     0.200
    25.600     4.494     0.200
    25.617     5.061     0.200
    25.724     4.466     0.200
    25.727     4.712     0.200
    25.742     4.121     0.200
    25.853     3.181     0.200
    25.908     4.163     0.200
    25.910     4.338     0.200
    25.912     4.394     0.200
    26.059     3.715     0.200
    26.067     3.579     0.200
    26.074     5.092     0.200
    26.113     4.754     0.200
    26.124     4.612     0.200
    26.125     3.468     0.200
    26.168     4.220     0.200
    26.176     3.084     0.200
    26.212     4.860     0.200
    26.360     2.124     0.200
    26.337     3.206     0.200
    26.328     4.496     0.200
    26.375     4.926     0.200
    26.390     4.404     0.200
    26.386     4.797     0.200
    26.442     4.172     0.200
    26.449     3.916     0.200
    26.540     1.605     0.200
    26.508     4.824     0.200
    26.574     5.122     0.200
    26.521     5.114     0.200
    26.630     1.258     0.200
    26.615     4.137     0.200
    26.653     4.339     0.200
    26.675     2.481     0.200
    26.675     2.450     0.200
    26.688     3.694     0.200
    26.718     3.895     0.200
    26.730     3.509     0.200
    26.780     3.899     0.200
    26.854     1.944     0.200
    26.817     4.359     0.200
    26.867     3.763     0.200
    26.946     4.061     0.200
    27.021     0.807     0.200
    27.041     4.175     0.200
    27.053     5.218     0.200
    27.057     4.222     0.200
    27.091     3.100     0.200
    27.207     3.842     0.200
    27.220     4.151     0.200
    27.225     3.819     0.200
    27.225     4.147     0.200
    27.296     3.971     0.200
    27.390     5.908     0.200
    27.416     0.809     0.200
    27.416     3.990     0.200
    27.410     4.057     0.200
    27.500     4.924     0.200
    27.508     4.934     0.200
    27.580     3.118     0.200
    27.523     5.109     0.200
    27.547     3.449     0.200
    27.572     2.795     0.200
    27.623     4.313     0.200
    27.575     4.442     0.200
    27.638     3.104     0.200
    27.762     5.282     0.200
    27.692     5.106     0.200
    27.755     2.650     0.200
    27.717     3.036     0.200
    27.717     4.291     0.200
    27.736     2.785     0.200
    27.743     4.910     0.200
    27.783     5.222     0.200
    27.861     4.236     0.200
    27.868     3.720     0.200
    27.879     3.755     0.200
    27.901     2.658     0.200
    27.891     4.299     0.200
    27.927     4.514     0.200
    27.956     3.717     0.200
    27.966     4.162     0.200
    28.027     5.006     0.200
    28.089     3.955     0.200
    28.133     4.926     0.200
    28.176     3.928     0.200
    28.240     2.091     0.200
    28.245     3.967     0.200
    28.241     5.301     0.200
    28.304     5.332     0.200
    28.284     4.288     0.200
    28.343     5.083     0.200
    28.395     4.124     0.200
    28.513     5.638     0.200
    28.455     4.772     0.200
    28.504     2.102     0.200
    28.490     4.010     0.200
    28.513     4.973     0.200
    28.575     1.631     0.200
    28.578     4.367     0.200
    28.643     3.347     0.200
    28.636     4.407     0.200
    28.781     5.423     0.200
    28.727     4.046     0.200
    28.779     1.384     0.200
    28.746     4.631     0.200
    28.784     6.506     0.200
    28.796     3.614     0.200
    28.814     3.408     0.200
    28.833     2.491     0.200
    28.846     3.594     0.200
    28.842     4.415     0.200
    28.860     3.950     0.200
    28.871     3.592     0.200
    28.879     5.086     0.200
    28.893     4.578     0.200
    28.908     4.732     0.200
    29.006     2.225     0.200
    28.980     4.660     0.200
    29.054     3.875     0.200
    29.078     3.658     0.200
    29.088     3.876     0.200
    29.140     3.709     0.200
    29.226     4.766     0.200
    29.253     5.175     0.200
    29.262     3.630     0.200
    29.298     3.760     0.200
    29.424     5.040     0.200
    29.436     4.116     0.200
    29.490     4.072     0.200
    29.556     2.616     0.200
    29.557     4.815     0.200
    29.621     4.273     0.200
    29.623     3.202     0.200
    29.639     3.403     0.200
    29.658     5.266     0.200
    29.692     3.845     0.200
    29.699     3.436     0.200
    29.735     3.814     0.200
    29.737     4.328     0.200
    29.781     4.447     0.200
    29.793     4.204     0.200
    29.851     3.249     0.200
    29.851     3.360     0.200
    29.879     0.776     0.200
    29.889     3.799     0.200
    29.892     4.951     0.200
    29.902     3.682     0.200
    30.027     4.821     0.200
    30.027     3.692     0.200
    29.976     3.882     0.200
    29.994     4.165     0.200
    29.994     3.943     0.200
    30.011     4.424     0.200
    30.051     3.442     0.200
    30.055     3.857     0.200
    30.103     4.159     0.200
    30.161     3.577     0.200
    30.206     3.722     0.200
    30.199     5.437     0.200
    30.276     1.103     0.200
    30.282     3.378     0.200
    30.291     4.068     0.200
    30.329     1.464     0.200
    30.311     3.399     0.200
    30.363     4.609     0.200
    30.407     4.240     0.200
    30.433     3.390     0.200
    30.457     3.479     0.200
    30.485     3.539     0.200
    30.528     1.218     0.200
    30.538     3.248     0.200
    30.609     3.015     0.200
    30.652     3.932     0.200
    30.670     3.542     0.200
    30.675     4.253     0.200
    30.771     1.946     0.200
    30.761     3.796     0.200
    30.778     3.407     0.200
    30.838     4.549     0.200
    30.812     3.183     0.200
    30.887     2.860     0.200
    30.903     4.301     0.200
    30.937     3.598     0.200
    30.956     3.114     0.200
    30.987     3.876     0.200
    31.028     3.293     0.200
    31.045     2.574     0.200
    31.055     4.659     0.200
    31.084     3.474     0.200
    31.093     2.930     0.200
    31.121     2.982     0.200
    31.124     3.194     0.200
    31.224     1.289     0.200
    31.229     3.773     0.200
    31.243     3.961     0.200
    31.315     3.366     0.200
    31.317     3.139     0.200
    31.346     2.101     0.200
    31.346     2.946     0.200
    31.352     2.940     0.200
    31.422     2.717     0.200
    31.501     0.374     0.200
    31.489     3.577     0.200
    31.505     2.743     0.200
    31.506     2.732     0.200
    31.521     3.181     0.200
    31.593     3.373     0.200
    31.626     3.248     0.200
    31.701     2.911     0.200
    31.701     2.759     0.200
    31.729     2.671     0.200
    31.750     3.215     0.200
    31.845     4.277     0.200
    31.879     3.977     0.200
    31.931     2.376     0.200
    31.931     4.530     0.200
    31.963     2.985     0.200
    31.995     3.037     0.200
    32.020     2.623     0.200
    32.063     3.139     0.200
    32.145     3.237     0.200
    32.173     3.866     0.200
    32.197     3.314     0.200
    32.238     4.429     0.200
    32.259     2.258     0.200
    32.337     3.318     0.200
    32.358     2.456     0.200
    32.441     2.019     0.200
    32.461     6.203     0.200
    32.423     2.677     0.200
    32.437     3.041     0.200
    32.529     2.461     0.200
    32.529     1.975     0.200
    32.527     3.285     0.200
    32.576     2.125     0.200
    32.580     2.360     0.200
    32.757     5.047     0.200
    32.724     3.157     0.200
    32.798     0.316     0.200
    32.751     4.202     0.200
    32.761     2.000     0.200
    32.798     1.676     0.200
    32.848     0.848     0.200
    32.905     2.523     0.200
    32.951     2.838     0.200
    32.993     3.713     0.200
    32.996     3.471     0.200
    33.028     3.480     0.200
    33.097    -0.584     0.200
    33.158     0.586     0.200
    33.176     3.029     0.200
    33.180     4.216     0.200
    33.195     2.623     0.200
    33.207     3.718     0.200
    33.240     4.967     0.200
    33.254     3.101     0.200
    33.282     2.266     0.200
    33.459     2.964     0.200
    33.507     1.992     0.200
    33.516     3.355     0.200
    33.527     3.224     0.200
    33.574     2.352     0.200
    33.591     2.896     0.200
    33.591     4.332     0.200
    33.645     2.925     0.200
    33.667     3.116     0.200
    33.803     2.753     0.200
    33.895     2.968     0.200
    33.907     4.144     0.200
    33.983     3.602     0.200
    34.025     2.930     0.200
    34.025     3.367     0.200
    34.032     2.288     0.200
    34.053     3.104     0.200
    34.162     3.024     0.200
    34.251     4.003     0.200
    34.262     2.719     0.200
    34.337     4.321     0.200
    34.372     3.733     0.200
    34.381     2.928     0.200
    34.421     2.515     0.200
    34.432     2.101     0.200
    34.466     3.368     0.200
    34.502     1.645     0.200
    34.572     4.222     0.200
    34.664     2.408     0.200
    34.695     3.785     0.200
    34.748     3.012     0.200
    34.841     3.774     0.200
    34.960     1.441     0.200
    34.981     3.684     0.200
    35.004     3.003     0.200
    35.036     3.936     0.200
    35.118     3.320     0.200
    35.124     2.947     0.200
    35.130     3.509     0.200
    35.223     4.509     0.200
    35.226     2.897     0.200
    35.507     2.744     0.200
    35.490     2.921     0.200
    35.560     3.840     0.200
    35.613     2.569     0.200
    35.671     3.168     0.200
    35.695     2.886     0.200
    35.708     3.112     0.200
    35.736     2.561     0.200
    35.812     4.499     0.200
    35.812     3.696     0.200
    36.163     3.027     0.200
    36.162     3.824     0.200
    36.318     2.960     0.200
    36.346     3.455     0.200
    36.598     3.737     0.200
    37.128     4.610     0.200
    37.471     0.986     0.200
    37.471     1.437     0.200
    41.748     1.615     0.200
    43.877     4.951     0.200
    44.928     4.829     0.200
    45.487     1.371     0.200
    45.967     4.086     0.200
    46.340     1.193     0.200
    46.639     3.908     0.200
    49.275     3.715     0.200
    53.827     2.050     0.200
    54.376     4.956     0.200
    54.624     3.762     0.200
    54.875     2.911     0.200
    55.238     2.430     0.200
    55.790     2.566     0.200
    55.947     3.402     0.200
    56.009     3.289     0.200
    56.726     4.779     0.200
    56.818     4.830     0.200
    57.022     3.157     0.200
    57.231     2.308     0.200
    57.570     1.398     0.200
    58.573     2.702     0.200
    59.487     3.072     0.200
    59.939     2.062     0.200
    61.017     3.774     0.200
    63.924     3.944     0.200
    65.248     2.985     0.200
    66.497     2.538     0.200
    67.022     1.881     0.200
    68.275     2.329     0.200
    71.457     1.829     0.200
    75.400     3.131     0.200
    77.382     2.399     0.200
    78.171     2.513     0.200
    78.260     2.618     0.200
    79.437     3.093     0.200
    79.755     3.232     0.200
    79.998     2.369     0.200
    80.019     2.456     0.200
    80.355     2.293     0.200
    80.419     3.150     0.200
    80.641     2.060     0.200
    80.754     3.356     0.200
    80.765     2.999     0.200
    81.058     3.137     0.200
    81.104     2.493     0.200
    81.104     2.974     0.200
    81.233     2.509     0.200
    81.233     2.907     0.200
    81.284     2.438     0.200
    81.297     3.365     0.200
    81.325     3.319     0.200
    81.466     2.474     0.200
    81.475     3.327     0.200
    81.629     3.013     0.200
    81.751     3.166     0.200
    81.897     3.032     0.200
    81.900     2.285     0.200
    81.930     3.419     0.200
    82.013     2.440     0.200
    82.065     2.417     0.200
    82.090     2.387     0.200
    82.382     3.361     0.200
    82.454     3.105     0.200
    82.459     3.957     0.200
    82.898     2.976     0.200
    82.898     4.075     0.200
    83.276     3.561     0.200
    83.321     3.382     0.200
    83.328     3.247     0.200
    83.421     2.479     0.200
    83.522     3.140     0.200
    83.539     2.972     0.200
    83.699     2.981     0.200
    83.819     2.737     0.200
    83.946     2.627     0.200
    83.946     3.391     0.200
    84.249     3.429     0.200
    84.451     2.623     0.200
    84.527     3.061     0.200
    84.552     3.573     0.200
    84.556     2.596     0.200
    84.537     3.191     0.200
    84.851     3.010     0.200
    84.856     3.326     0.200
    84.960     3.581     0.200
    84.951     2.805     0.200
    85.057     3.172     0.200
    85.175     2.227     0.200
    85.342     3.570     0.200
    85.382     2.949     0.200
    85.363     1.848     0.200
    85.442     3.752     0.200
    85.499     2.469     0.200
    85.499     2.440     0.200
    85.591     4.192     0.200
    85.589     2.520     0.200
    85.777     3.271     0.200
    85.831     3.160     0.200
    85.840     3.585     0.200
    85.940     2.430     0.200
    85.961     2.676     0.200
    85.963     2.565     0.200
    85.980     2.383     0.200
    86.035     3.611     0.200
    86.049     3.911     0.200
    86.090     2.241     0.200
    86.170     3.964     0.200
    86.181     3.663     0.200
    86.314     2.835     0.200
    86.405     2.093     0.200
    86.460     1.821     0.200
    86.476     2.341     0.200
    86.477     4.748     0.200
    86.507     2.692     0.200
    86.537     2.801     0.200
    86.550     4.528     0.200
    86.565     2.927     0.200
    86.640     4.037     0.200
    86.642     2.630     0.200
    86.643     1.925     0.200
    86.645     1.814     0.200
    86.711     2.189     0.200
    86.790     2.305     0.200
    86.802     2.347     0.200
    86.816     3.806     0.200
    87.011     1.829     0.200
    87.049     1.372     0.200
    87.066     2.759     0.200
    87.129     3.055     0.200
    87.142     2.592     0.200
    87.148     2.965     0.200
    87.277     2.327     0.200
    87.277     3.528     0.200
    87.277     2.637     0.200
    87.980     2.474     0.200
    88.058     2.805     0.200
    88.226     2.210     0.200
    88.349     2.625     0.200
    88.445     2.674     0.200
    88.452     1.840     0.200
    88.460     2.904     0.200
    88.469     1.961     0.200
    88.603     2.531     0.200
    88.619     2.957     0.200
    88.787     2.464     0.200
    88.970    -0.397     0.200
    89.034     2.902     0.200
    89.133     1.740     0.200
    89.304     2.637     0.200
    89.324     2.944     0.200
    89.463     2.094     0.200
    89.650     2.319     0.200
    89.964     3.349     0.200
    90.028     2.853     0.200
    90.041     3.293     0.200
    90.041     1.692     0.200
    90.242     2.555     0.200
    90.242     2.555     0.200
    90.439     2.939     0.200
    90.489     2.902     0.200
    90.492     1.290     0.200
    90.527     3.135     0.200
    90.613     2.527     0.200
    90.614     2.020     0.200
    90.691     2.464     0.200
    90.750     3.271     0.200
    90.773     2.680     0.200
    90.838     1.680     0.200
    91.219     2.283     0.200
    91.219     2.014     0.200
    91.454     2.620     0.200
    91.735     2.920     0.200
    91.750     2.951     0.200
    91.864     2.827     0.200
    91.989     2.747     0.200
    92.074     2.754     0.200
    92.074     2.793     0.200
    92.375     3.156     0.200
    92.541     2.897     0.200
    92.719     3.105     0.200
    92.792     3.039     0.200
    92.789     1.151     0.200
    93.012     2.822     0.200
    93.048     2.357     0.200
    93.071     2.953     0.200
    93.192     3.393     0.200
    93.221     2.612     0.200
    93.221     2.211     0.200
    93.288     2.953     0.200
    93.483     2.155     0.200
    93.719     2.695     0.200
    93.763     2.557     0.200
    93.779     1.095     0.200
    94.026     2.888     0.200
    94.352     3.757     0.200
    94.358     3.631     0.200
    94.607     2.441     0.200
    94.645     3.037     0.200
    94.742     2.674     0.200
    94.735     2.804     0.200
    94.735     3.304     0.200
    95.170     3.015     0.200
    95.968     3.476     0.200
    96.089     3.227     0.200
    96.381     3.299     0.200
    96.619     3.001     0.200
    96.799     2.103     0.200
    96.987     3.456     0.200
    97.301     2.359     0.200
    15.538     6.248     0.200
    15.649     4.255     0.200
    16.210    10.358     0.200
    16.592     4.620     0.200
    16.977     4.217     0.200
    17.111     4.127     0.200
    17.447     4.252     0.200
    17.656     4.398     0.200
    17.788     4.257     0.200
    17.970     4.873     0.200
    18.083     4.243     0.200
    18.075     4.331     0.200
    18.099     4.459     0.200
    18.163     4.338     0.200
    18.200     4.281     0.200
    18.236     4.761     0.200
    18.229     4.537     0.200
    18.269     4.532     0.200
    18.459     1.421     0.200
    18.472     1.381     0.200
    19.049     1.856     0.200
    19.899     2.076     0.200
    19.930     0.986     0.200
    21.134     5.182     0.200
    21.161     0.749     0.200
    21.145     4.473     0.200
    21.221     3.682     0.200
    21.237     2.916     0.200
    21.299     3.309     0.200
    21.295     4.526     0.200
    21.203     6.807     0.200
    21.359     4.366     0.200
    21.422     4.422     0.200
    21.460     4.344     0.200
    21.482     3.078     0.200
    21.482     3.226     0.200
    21.493     2.207     0.200
    21.545     4.649     0.200
    21.598     4.206     0.200
    21.626     4.863     0.200
    21.659     1.044     0.200
    21.636     4.651     0.200
    21.674     4.009     0.200
    21.727     1.215     0.200
    21.769     1.139     0.200
    21.792     4.607     0.200
    21.847     4.495     0.200
    21.864     3.386     0.200
    21.897     4.483     0.200
    21.984    -0.251     0.200
    22.078     3.622     0.200
    22.057     4.213     0.200
    22.146     0.790     0.200
    22.172     3.019     0.200
    22.155     4.073     0.200
    22.155     4.704     0.200
    22.155     4.429     0.200
    22.160     4.459     0.200
    22.189     4.073     0.200
    22.197     1.126     0.200
    22.265     1.270     0.200
    22.339     3.945     0.200
    22.409     0.689     0.200
    22.404     3.364     0.200
    22.464     5.529     0.200
    22.494     4.299     0.200
    22.508     4.198     0.200
    22.542     3.958     0.200
    22.575     4.290     0.200
    22.604    -0.014     0.200
    22.591     4.245     0.200
    22.640     3.575     0.200
    22.711     2.878     0.200
    22.721     1.981     0.200
    22.727     4.156     0.200
    22.787     1.216     0.200
    22.884     4.628     0.200
    22.926     2.894     0.200
    22.951     4.260     0.200
    22.999     2.812     0.200
    23.016     3.400     0.200
    23.063     0.454     0.200
    23.037     3.939     0.200
    23.065     3.848     0.200
    23.170     4.276     0.200
    23.213     4.187     0.200
    23.249     2.216     0.200
    23.226     4.045     0.200
    23.258     0.260     0.200
    23.222     3.734     0.200
    23.280     4.349     0.200
    23.305     2.643     0.200
    23.322     2.346     0.200
    23.308     3.821     0.200
    23.347     3.524     0.200
    23.361     3.907     0.200
    23.401     3.912     0.200
    23.545     3.684     0.200
    23.541     4.047     0.200
    23.559     4.063     0.200
    23.608     1.460     0.200
    23.596     4.303     0.200
    23.591     3.694     0.200
    23.623     0.392     0.200
    23.623     0.093     0.200
    23.639     3.886     0.200
    23.688     4.223     0.200
    23.706     3.500     0.200
    23.707     4.002     0.200
    23.728     2.772     0.200
    23.730     4.195     0.200
    23.828     4.134     0.200
    23.840     4.295     0.200
    23.863     3.018     0.200
    23.863     2.805     0.200
    23.868     2.779     0.200
    23.844     3.942     0.200
    23.912     3.616     0.200
    23.928     3.758     0.200
    23.953     2.201     0.200
    23.928     2.411     0.200
    23.949     3.982     0.200
    24.081     3.805     0.200
    24.101     1.663     0.200
    24.091     4.386     0.200
    24.107     2.801     0.200
    24.126     4.582     0.200
    24.141     1.559     0.200
    24.185     4.770     0.200
    24.200     4.181     0.200
    24.242     3.754     0.200
    24.262     3.055     0.200
    24.263     4.149     0.200
    24.316     4.496     0.200
    24.385     4.634     0.200
    24.409     0.953     0.200
    24.404     1.861     0.200
    24.382     3.239     0.200
    24.429     3.587     0.200
    24.446     4.247     0.200
    24.487     4.716     0.200
    24.487     4.904     0.200
    24.489     4.453     0.200
    24.527     3.264     0.200
    24.618     4.265     0.200
    24.685     2.762     0.200
    24.699     4.242     0.200
    24.716     4.199     0.200
    24.752     3.336     0.200
    24.773     4.032     0.200
    24.775     4.687     0.200
    24.773     4.551     0.200
    24.790     4.550     0.200
    24.890     3.671     0.200
    24.914     3.770     0.200
    25.052     4.264     0.200
    25.053     4.216     0.200
    25.097     3.123     0.200
    25.066     4.230     0.200
    25.104     1.359     0.200
    25.095     4.584     0.200
    25.109     4.734     0.200
    25.177     3.580     0.200
    25.207     4.229     0.200
    25.256     4.374     0.200
    25.279     4.143     0.200
    25.255     4.708     0.200
    25.304     1.185     0.200
    25.310     2.909     0.200
    25.382     3.698     0.200
    25.411     4.728     0.200
    25.472     4.432     0.200
    25.474     4.272     0.200
    25.456     4.695     0.200
    25.514     3.114     0.200
    25.552     1.562     0.200
    25.552     4.678     0.200
    25.583     4.023     0.200
    25.580     4.292     0.200
    25.624     3.746     0.200
    25.634     3.903     0.200
    25.621     5.162     0.200
    25.663     2.605     0.200
    25.680     2.832     0.200
    25.696     3.983     0.200
    25.687     4.592     0.200
    25.766     3.668     0.200
    25.787     4.256     0.200
    25.763     4.903     0.200
    25.840     2.428     0.200
    25.811     4.534     0.200
    25.845     4.864     0.200
    25.895     3.992     0.200
    25.935     3.149     0.200
    26.021     4.771     0.200
    26.031     4.142     0.200
    26.021     4.726     0.200
    26.057     2.884     0.200
    26.139     3.500     0.200
    26.215     3.291     0.200
    26.204     4.293     0.200
    26.207     4.351     0.200
    26.274     2.849     0.200
    26.304     4.303     0.200
    26.346     3.798     0.200
    26.353     3.353     0.200
    26.370     4.903     0.200
    26.408     4.623     0.200
    26.420     4.462     0.200
    26.441     1.962     0.200
    26.421     3.397     0.200
    26.458     3.276     0.200
    26.458     4.312     0.200
    26.484     3.974     0.200
    26.508     4.672     0.200
    26.621     3.342     0.200
    26.619     2.241     0.200
    26.624     4.513     0.200
    26.671     4.978     0.200
    26.683     4.345     0.200
    26.682     4.572     0.200
    26.738     3.991     0.200
    26.734     4.133     0.200
    26.785     3.372     0.200
    26.803     4.620     0.200
    26.846     1.330     0.200
    26.901     2.635     0.200
    26.949     2.803     0.200
    26.949     2.965     0.200
    26.949     2.744     0.200
    26.947     4.424     0.200
    26.974     3.524     0.200
    27.015     3.744     0.200
    27.014     3.808     0.200
    27.063     4.245     0.200
    27.070     4.046     0.200
    27.083     3.435     0.200
    27.049     5.948     0.200
    27.239     4.301     0.200
    27.272     2.713     0.200
    27.291     4.333     0.200
    27.312     4.219     0.200
    27.332     3.967     0.200
    27.329     5.074     0.200
    27.370     3.520     0.200
    27.349     5.110     0.200
    27.353     4.228     0.200
    27.402     3.739     0.200
    27.240     7.762     0.200
    27.496     3.879     0.200
    27.515     4.439     0.200
    27.533     1.635     0.200
    27.522     3.904     0.200
    27.577     3.345     0.200
    27.588     4.022     0.200
    27.486     3.848     0.200
    27.519     4.686     0.200
    27.680     4.143     0.200
    27.702     3.905     0.200
    27.740     3.661     0.200
    27.811     3.019     0.200
    27.803     4.848     0.200
    27.831     3.462     0.200
    27.849     3.044     0.200
    27.865     4.307     0.200
    27.891     3.076     0.200
    27.915     3.238     0.200
    27.968     3.651     0.200
    27.987     3.330     0.200
    27.995     3.036     0.200
    28.013     2.964     0.200
    27.988     4.718     0.200
    28.011     4.028     0.200
    28.039     5.066     0.200
    28.079     4.941     0.200
    28.157     3.731     0.200
    28.156     3.597     0.200
    28.154     3.953     0.200
    27.983     8.038     0.200
    28.177     2.777     0.200
    28.182     5.158     0.200
    28.241     3.639     0.200
    28.223     4.294     0.200
    28.257     4.224     0.200
    28.266     4.079     0.200
    28.291     3.615     0.200
    28.323     4.968     0.200
    28.352     3.254     0.200
    28.368     3.403     0.200
    28.383     4.119     0.200
    28.429     4.796     0.200
    28.465     4.139     0.200
    28.501     3.425     0.200
    28.532     3.814     0.200
    28.570     2.006     0.200
    28.576     4.657     0.200
    28.637     3.449     0.200
    28.669     2.769     0.200
    28.507     4.408     0.200
    28.685     4.064     0.200
    28.734     3.473     0.200
    28.750     4.756     0.200
    28.616     5.708     0.200
    28.784     4.167     0.200
    28.809     4.802     0.200
    28.847     4.877     0.200
    28.854     5.668     0.200
    28.840     4.234     0.200
    28.864     5.366     0.200
    28.911     2.149     0.200
    28.910     3.532     0.200
    28.928     3.485     0.200
    28.932     4.170     0.200
    29.020     3.466     0.200
    29.059     4.337     0.200
    29.043     4.473     0.200
    29.053     4.771     0.200
    29.053     4.208     0.200
    29.075     3.331     0.200
    29.085     3.875     0.200
    29.103     2.542     0.200
    29.103     3.003     0.200
    29.133     3.543     0.200
    29.152     4.162     0.200
    29.156     3.642     0.200
    29.151     3.887     0.200
    29.135     4.044     0.200
    29.175     4.828     0.200
    29.198     3.467     0.200
    29.188     4.465     0.200
    29.204     4.767     0.200
    29.277     4.994     0.200
    29.355     2.517     0.200
    29.362     3.706     0.200
    29.430     3.797     0.200
    29.518     3.837     0.200
    29.521     4.685     0.200
    29.550     3.578     0.200
    29.591     3.664     0.200
    29.616     3.768     0.200
    29.640     3.826     0.200
    29.727     4.221     0.200
    29.740     4.126     0.200
    29.720     5.546     0.200
    29.720     4.763     0.200
    29.770     3.991     0.200
    29.827     2.637     0.200
    29.834     4.014     0.200
    29.915     4.348     0.200
    29.916     3.623     0.200
    29.928     3.660     0.200
    29.946     2.949     0.200
    29.971     4.053     0.200
    29.955     5.188     0.200
    30.022     3.805     0.200
    30.033     4.341     0.200
    30.068     2.430     0.200
    30.085     3.884     0.200
    30.127     3.604     0.200
    30.166     3.426     0.200
    30.174     3.837     0.200
    30.181     3.505     0.200
    30.267     3.807     0.200
    30.299     3.483     0.200
    30.288     3.591     0.200
    30.288     4.029     0.200
    30.350     4.312     0.200
    30.396     4.048     0.200
    30.419     2.334     0.200
    30.443     3.651     0.200
    30.473     5.473     0.200
    30.494     3.869     0.200
    30.490     2.682     0.200
    30.496     5.315     0.200
    30.589     3.525     0.200
    30.582     3.964     0.200
    30.617     2.865     0.200
    30.720     3.513     0.200
    30.736     3.041     0.200
    30.575     3.155     0.200
    30.753     3.412     0.200
    30.775     3.517     0.200
    30.817     3.323     0.200
    30.897     3.305     0.200
    30.910     4.816     0.200
    30.962     3.503     0.200
    31.007     3.079     0.200
    31.069     3.558     0.200
    31.094     3.494     0.200
    31.078     4.490     0.200
    31.165     3.007     0.200
    31.190     2.957     0.200
    31.212     3.599     0.200
    31.197     4.115     0.200
    31.226     2.686     0.200
    31.238     4.150     0.200
    31.249     3.424     0.200
    31.317     3.094     0.200
    31.333     2.771     0.200
    31.345     2.628     0.200
    31.367     3.539     0.200
    31.351     5.014     0.200
    31.400     2.798     0.200
    31.389     2.460     0.200
    31.410     3.109     0.200
    31.441     1.845     0.200
    31.437     2.675     0.200
    31.597     2.972     0.200
    31.597     2.517     0.200
    31.605     3.395     0.200
    31.609     3.212     0.200
    31.633     2.953     0.200
    31.633     2.904     0.200
    31.699     2.595     0.200
    31.783     2.751     0.200
    31.791     2.824     0.200
    31.815     2.858     0.200
    31.814     3.250     0.200
    31.873     2.558     0.200
    31.906     2.993     0.200
    31.889     4.813     0.200
    31.969     3.248     0.200
    31.969     2.918     0.200
    32.008     2.639     0.200
    32.041     3.177     0.200
    32.051     2.766     0.200
    32.140     2.895     0.200
    32.140     3.030     0.200
    32.160     3.196     0.200
    32.204     2.894     0.200
    32.215     2.300     0.200
    32.227     4.302     0.200
    32.250     3.111     0.200
    32.283     3.032     0.200
    32.300     2.678     0.200
    32.353     3.101     0.200
    32.397     2.684     0.200
    32.466     3.766     0.200
    32.489     3.317     0.200
    32.532     2.315     0.200
    32.541     2.219     0.200
    32.530     3.084     0.200
    32.534     5.266     0.200
    32.563     2.754     0.200
    32.627     3.377     0.200
    32.643     2.325     0.200
    32.645     4.110     0.200
    32.695     2.312     0.200
    32.766     2.328     0.200
    32.820     3.122     0.200
    32.850     0.587     0.200
    32.859     2.274     0.200
    32.860     2.207     0.200
    32.883     2.529     0.200
    32.999     3.530     0.200
    33.015     3.288     0.200
    32.948     3.382     0.200
    33.048     1.866     0.200
    33.047     5.346     0.200
    33.077     2.967     0.200
    33.074     4.846     0.200
    33.112     2.678     0.200
    33.161     2.430     0.200
    33.190     2.665     0.200
    33.242     2.825     0.200
    33.241     3.090     0.200
    33.289     3.505     0.200
    33.288     3.471     0.200
    33.320     3.679     0.200
    33.376     1.190     0.200
    33.376     0.471     0.200
    33.454     3.095     0.200
    33.484     2.889     0.200
    33.498     3.373     0.200
    33.509     2.901     0.200
    33.525     2.363     0.200
    33.541     2.496     0.200
    33.532     4.054     0.200
    33.569     2.328     0.200
    33.585     3.855     0.200
    33.713     2.773     0.200
    33.749     3.781     0.200
    33.748     3.771     0.200
    33.795     2.350     0.200
    33.810     3.782     0.200
    33.820     3.221     0.200
    33.872     3.041     0.200
    33.883     4.257     0.200
    33.922     3.353     0.200
    33.945     3.253     0.200
    33.995     2.321     0.200
    34.085     2.790     0.200
    34.155     4.438     0.200
    34.181     3.775     0.200
    34.181     3.146     0.200
    34.197     4.192     0.200
    34.277     3.858     0.200
    34.305     2.858     0.200
    34.314     3.119     0.200
    34.346     3.287     0.200
    34.427     2.151     0.200
    34.448     3.173     0.200
    34.543     2.881     0.200
    34.543     3.719     0.200
    34.666     3.102     0.200
    34.662     3.768     0.200
    34.712     4.197     0.200
    34.754     3.586     0.200
    34.789     3.327     0.200
    34.866     4.116     0.200
    34.947     2.798     0.200
    34.987     3.746     0.200
    35.034     3.146     0.200
    35.123     4.120     0.200
    35.132     3.557     0.200
    35.270     3.596     0.200
    35.289     2.958     0.200
    35.407     2.892     0.200
    35.411     2.792     0.200
    35.421     3.833     0.200
    35.511     3.231     0.200
    35.781     2.925     0.200
    35.852     4.111     0.200
    35.902     2.788     0.200
    35.939     3.029     0.200
    35.962     3.176     0.200
    35.984     2.705     0.200
    35.995     3.205     0.200
    36.026     2.494     0.200
    36.105     3.658     0.200
    36.451     2.846     0.200
    36.453     3.913     0.200
    36.607     2.817     0.200
    36.635     3.349     0.200
    36.833     4.177     0.200
    36.888     3.890     0.200
    37.636     2.155     0.200
    37.711     2.110     0.200
    37.711     1.340     0.200
    45.673     4.429     0.200
    46.601     1.145     0.200
    46.923     4.471     0.200
    49.561     3.357     0.200
    51.256     4.027     0.200
    51.290     5.064     0.200
    54.110     2.876     0.200
    55.158     2.913     0.200
    55.511     2.630     0.200
    55.708     2.583     0.200
    56.138     2.859     0.200
    56.239     3.426     0.200
    56.263     4.015     0.200
    56.299     2.895     0.200
    56.307     3.097     0.200
    57.310     2.857     0.200
    57.517     2.566     0.200
    57.689     3.187     0.200
    57.800     1.471     0.200
    57.987     2.621     0.200
    58.181     2.872     0.200
    58.279     2.410     0.200
    58.690     1.902     0.200
    58.865     2.694     0.200
    59.590     3.356     0.200
    60.225     1.739     0.200
    60.745     4.137     0.200
    63.635     4.621     0.200
    65.581     2.463     0.200
    67.240     1.372     0.200
    75.686     3.899     0.200
    75.686     2.928     0.200
    81.114     2.744     0.200
    81.233     1.819     0.200
    81.893     3.365     0.200
    81.933     3.144     0.200
    82.283     3.464     0.200
    82.436     1.885     0.200
    82.452     3.323     0.200
    82.750     3.054     0.200
    82.750     2.953     0.200
    83.305     2.929     0.200
    83.322     3.661     0.200
    83.322     4.060     0.200
    83.478     2.690     0.200
    83.598     2.871     0.200
    83.710     3.801     0.200
    83.709     3.254     0.200
    83.878     2.740     0.200
    83.933     3.240     0.200
    83.957     3.552     0.200
    83.957     2.919     0.200
    83.957     2.938     0.200
    84.243     4.129     0.200
    84.500     2.375     0.200
    84.530     4.004     0.200
    84.550     5.183     0.200
    84.652     2.969     0.200
    84.882     2.754     0.200
    84.959     4.813     0.200
    85.007     3.972     0.200
    85.071     3.005     0.200
    85.185     3.931     0.200
    85.177     3.791     0.200
    85.349     4.690     0.200
    85.413     2.693     0.200
    85.534     4.259     0.200
    85.631     2.306     0.200
    85.673     2.876     0.200
    85.823     3.656     0.200
    85.971     4.024     0.200
    85.994     2.410     0.200
    86.025     2.155     0.200
    86.034     2.411     0.200
    86.058     4.192     0.200
    86.073     2.222     0.200
    86.067     3.550     0.200
    86.141     1.986     0.200
    86.184     4.190     0.200
    86.295     4.104     0.200
    86.386     2.475     0.200
    86.457     1.827     0.200
    86.520     2.019     0.200
    86.543     3.489     0.200
    86.673     0.272     0.200
    86.699     1.643     0.200
    86.699     1.540     0.200
    86.847     2.016     0.200
    86.851     2.500     0.200
    87.019     4.450     0.200
    87.065     1.456     0.200
    87.075     3.149     0.200
    87.178     2.204     0.200
    87.194     3.126     0.200
    87.293     2.551     0.200
    87.874     1.964     0.200
    87.917     2.560     0.200
    88.122     1.486     0.200
    88.476     2.112     0.200
    88.509     1.257     0.200
    88.510     2.753     0.200
    88.527     1.371     0.200
    88.535     2.633     0.200
    88.680     2.650     0.200
    89.192     1.344     0.200
    89.357     2.370     0.200
    89.699     1.969     0.200
    90.320     3.169     0.200
    90.320     3.169     0.200
    90.577     1.972     0.200
    90.577     2.372     0.200
    90.647     2.549     0.200
    90.708     2.866     0.200
    90.774     2.059     0.200
    90.854     2.587     0.200
    90.957     2.708     0.200
    91.306     1.986     0.200
    91.533     3.235     0.200
    91.943     2.335     0.200
    92.035     2.114     0.200
    92.152     2.670     0.200
    92.152     2.957     0.200
    92.881     3.004     0.200
    93.075     3.138     0.200
    94.836     2.816     0.200
    95.974     0.428     0.200
    97.194     2.396     0.200
    15.659     5.249     0.200
    16.208     4.382     0.200
    16.293     6.473     0.200
    16.293     5.657     0.200
    16.411     3.693     0.200
    16.504     3.850     0.200
    16.568     4.646     0.200
    16.977     3.848     0.200
    16.988     3.822     0.200
    17.151     3.564     0.200
    17.310     3.883     0.200
    17.362     3.542     0.200
    17.641     3.939     0.200
    17.734     3.569     0.200
    17.796     3.626     0.200
    17.995     3.770     0.200
    18.046     3.503     0.200
    18.096     3.315     0.200
    18.282     4.890     0.200
    18.365     1.484     0.200
    18.384     2.345     0.200
    18.579     0.545     0.200
    18.621     2.021     0.200
    18.856     1.738     0.200
    19.078     2.110     0.200
    19.176     1.112     0.200
    19.253     1.899     0.200
    19.269     2.446     0.200
    19.490     3.159     0.200
    19.660     2.607     0.200
    19.765     2.505     0.200
    19.833     2.992     0.200
    19.931     2.557     0.200
    19.933     3.352     0.200
    20.049     3.137     0.200
    20.057     1.445     0.200
    20.073     2.091     0.200
    20.408     2.108     0.200
    20.488     3.245     0.200
    20.520     2.813     0.200
    20.533     3.028     0.200
    20.693     2.850     0.200
    20.728     3.320     0.200
    20.834     2.357     0.200
    20.872     3.184     0.200
    20.874     3.567     0.200
    21.003     2.497     0.200
    21.008     3.821     0.200
    21.008     4.612     0.200
    21.014     3.134     0.200
    21.100     4.388     0.200
    21.113     2.904     0.200
    21.219     5.127     0.200
    21.319     3.981     0.200
    21.330     2.953     0.200
    21.350     3.671     0.200
    21.421     1.622     0.200
    21.458     2.121     0.200
    21.492     3.025     0.200
    21.502     2.112     0.200
    21.547     4.055     0.200
    21.551     3.147     0.200
    21.575     5.118     0.200
    21.584     4.308     0.200
    21.631     0.610     0.200
    21.670     2.396     0.200
    21.713     2.879     0.200
    21.745     4.666     0.200
    21.762     2.808     0.200
    21.813     4.557     0.200
    21.866    -0.113     0.200
    21.927     4.461     0.200
    21.995     3.249     0.200
    22.027     3.187     0.200
    22.099     5.082     0.200
    22.099     4.587     0.200
    22.108     4.197     0.200
    22.125     2.116     0.200
    22.127     2.129     0.200
    22.129     0.414     0.200
    22.171     3.650     0.200
    22.207     2.369     0.200
    22.301     0.643     0.200
    22.317     2.821     0.200
    22.356     1.070     0.200
    22.367     2.796     0.200
    22.365     0.871     0.200
    22.371     3.620     0.200
    22.405     2.311     0.200
    22.423     5.324     0.200
    22.454     2.053     0.200
    22.496     3.971     0.200
    22.531     4.657     0.200
    22.636     2.623     0.200
    22.664     2.138     0.200
    22.708     2.615     0.200
    22.731     2.066     0.200
    22.737     1.750     0.200
    22.765     2.432     0.200
    22.784     1.750     0.200
    22.902     3.998     0.200
    22.911     2.919     0.200
    22.921     1.156     0.200
    23.127     4.084     0.200
    23.221     1.753     0.200
    23.284     2.168     0.200
    23.284     2.037     0.200
    23.287     1.777     0.200
    23.306     2.349     0.200
    23.390     2.029     0.200
    23.409     1.156     0.200
    23.510     4.111     0.200
    23.511     1.800     0.200
    23.599     2.508     0.200
    23.664     4.125     0.200
    23.737     2.156     0.200
    23.783     0.437     0.200
    23.809     3.515     0.200
    23.808     2.433     0.200
    23.867     2.440     0.200
    23.867     2.812     0.200
    23.883     3.117     0.200
    23.893     4.263     0.200
    23.904     2.517     0.200
    23.911     3.032     0.200
    23.920     4.038     0.200
    23.925     4.073     0.200
    24.054     2.366     0.200
    24.082     3.830     0.200
    24.133     4.530     0.200
    24.160     3.416     0.200
    24.174     2.385     0.200
    24.249     3.376     0.200
    24.265     3.193     0.200
    24.282     3.288     0.200
    24.311     2.405     0.200
    24.403     4.371     0.200
    24.407     2.787     0.200
    24.409     2.807     0.200
    24.441     4.718     0.200
    24.498     2.698     0.200
    24.542     3.488     0.200
    24.553     1.740     0.200
    24.561     1.692     0.200
    24.586     3.610     0.200
    24.667     2.765     0.200
    24.719     5.231     0.200
    24.724     2.554     0.200
    24.795     2.771     0.200
    24.827     3.163     0.200
    24.920     3.780     0.200
    24.928     3.163     0.200
    25.017     3.069     0.200
    25.046     5.371     0.200
    25.052     3.577     0.200
    25.067     5.230     0.200
    25.114     3.482     0.200
    25.179     3.744     0.200
    25.199     5.103     0.200
    25.229     4.534     0.200
    25.283     4.516     0.200
    25.364     3.107     0.200
    25.429     0.580     0.200
    25.556     2.802     0.200
    25.580     3.859     0.200
    25.596     4.438     0.200
    25.629     3.748     0.200
    25.629     3.537     0.200
    25.632     3.761     0.200
    25.682     2.975     0.200
    25.959     3.164     0.200
    26.067     3.231     0.200
    26.137     3.703     0.200
    26.171     2.815     0.200
    26.214     3.085     0.200
    26.220     3.830     0.200
    26.293     2.985     0.200
    26.306     3.910     0.200
    26.330     3.732     0.200
    26.464     4.121     0.200
    26.557     4.351     0.200
    26.622     3.415     0.200
    26.632     5.077     0.200
    26.782     2.380     0.200
    26.934     1.257     0.200
    26.969     3.216     0.200
    26.969     2.374     0.200
    26.969     3.137     0.200
    26.972     3.279     0.200
    27.015     3.790     0.200
    27.055     2.882     0.200
    27.075     2.508     0.200
    27.086     3.012     0.200
    27.154     6.814     0.200
    27.189     3.034     0.200
    27.415     2.862     0.200
    27.477     2.761     0.200
    27.503     2.778     0.200
    27.745     3.500     0.200
    27.770     3.048     0.200
    27.826     3.202     0.200
    27.832     3.200     0.200
    27.995     2.867     0.200
    27.998     3.154     0.200
    28.223     2.775     0.200
    28.309     3.189     0.200
    28.359     3.471     0.200
    28.639     2.973     0.200
    28.639     3.326     0.200
    29.054     2.151     0.200
    29.130     3.075     0.200
    29.130     2.615     0.200
    29.155     3.579     0.200
    29.155     3.774     0.200
    29.157     2.797     0.200
    29.364     3.726     0.200
    29.542     3.752     0.200
    29.542     3.305     0.200
    29.555     2.697     0.200
    29.612     3.581     0.200
    29.747     3.878     0.200
    29.829     2.166     0.200
    29.850     3.871     0.200
    29.972     3.003     0.200
    29.985     3.456     0.200
    30.090     1.930     0.200
    30.144     3.701     0.200
    30.174     4.005     0.200
    30.189     4.039     0.200
    30.194     3.876     0.200
    30.231     2.450     0.200
    30.312     2.841     0.200
    30.317     2.549     0.200
    30.340     3.485     0.200
    30.448     3.426     0.200
    30.557     2.421     0.200
    30.574     3.957     0.200
    30.590     2.677     0.200
    30.603     2.900     0.200
    30.643     2.879     0.200
    30.737     2.302     0.200
    30.759     2.797     0.200
    30.799     2.324     0.200
    30.843     3.511     0.200
    31.006     2.342     0.200
    31.026     2.834     0.200
    31.082     2.547     0.200
    31.101     2.900     0.200
    31.180     2.392     0.200
    31.219     3.115     0.200
    31.231     3.532     0.200
    31.325     2.647     0.200
    31.348     2.802     0.200
    31.369     2.651     0.200
    31.380     2.816     0.200
    31.412     3.188     0.200
    31.458     2.690     0.200
    31.527     1.495     0.200
    31.585     2.838     0.200
    31.642     2.982     0.200
    31.716     3.171     0.200
    31.840     2.768     0.200
    31.917     3.440     0.200
    31.917     2.947     0.200
    32.021     2.912     0.200
    32.085     2.561     0.200
    32.164     1.403     0.200
    32.226     2.554     0.200
    32.260     2.206     0.200
    32.309     2.842     0.200
    32.337     2.794     0.200
    32.416     3.089     0.200
    32.463     2.424     0.200
    32.472     2.630     0.200
    32.500     2.558     0.200
    32.547     2.652     0.200
    32.550     3.156     0.200
    32.681     2.072     0.200
    32.715     3.145     0.200
    32.870     2.573     0.200
    32.903     2.450     0.200
    33.069     2.615     0.200
    33.129     2.852     0.200
    33.169     2.872     0.200
    33.267     2.644     0.200
    33.461     0.661     0.200
    33.461     0.506     0.200
    33.467     2.786     0.200
    33.530     2.417     0.200
    33.562     2.437     0.200
    33.731     2.839     0.200
    33.881     3.216     0.200
    33.959     3.011     0.200
    34.184     3.007     0.200
    34.184     3.304     0.200
    34.315     3.075     0.200
    37.776     1.266     0.200
    45.752     4.430     0.200
    45.759     2.070     0.200
    45.759     1.346     0.200
    46.641     1.505     0.200
    46.707     1.046     0.200
    55.534     2.797     0.200
    57.114     3.278     0.200
    57.204     3.936     0.200
    57.875     1.295     0.200
    59.919     2.631     0.200
    60.867     3.821     0.200
    65.699     2.145     0.200
    65.699     1.355     0.200
    82.126     1.774     0.200
    83.648     2.382     0.200
    83.768     2.567     0.200
    84.048     2.339     0.200
    84.139     2.401     0.200
    85.591     2.278     0.200
    85.806     2.010     0.200
    86.171     2.006     0.200
    86.199     1.667     0.200
    86.201     1.861     0.200
    86.313     1.607     0.200
    86.871     1.276     0.200
    86.870     1.479     0.200
    87.018     1.857     0.200
    88.446     2.629     0.200
    89.214     2.218     0.200
    16.267     3.721     0.200
    16.515     4.723     0.200
    16.515     4.219     0.200
    16.598     3.640     0.200
    16.776     3.715     0.200
    16.895     3.916     0.200
    16.998     3.728     0.200
    17.097     3.629     0.200
    17.240     3.886     0.200
    17.356     3.300     0.200
    17.589     3.638     0.200
    17.596     4.097     0.200
    17.746     3.051     0.200
    17.888     4.435     0.200
    17.925     3.256     0.200
    18.072     4.133     0.200
    18.212     3.496     0.200
    18.348     1.097     0.200
    18.425     1.209     0.200
    18.490     1.638     0.200
    18.750     2.037     0.200
    18.791     2.287     0.200
    18.804     1.833     0.200
    18.914     1.704     0.200
    18.958     2.831     0.200
    18.968     1.725     0.200
    18.996     2.211     0.200
    19.182     2.172     0.200
    19.221     1.420     0.200
    19.381     2.249     0.200
    19.385     2.188     0.200
    19.417     2.697     0.200
    19.524     1.764     0.200
    19.536     1.769     0.200
    19.567     2.176     0.200
    19.648     2.058     0.200
    19.660     1.351     0.200
    19.752     0.419     0.200
    19.759     2.400     0.200
    19.883     2.475     0.200
    20.023     3.299     0.200
    20.073     2.958     0.200
    20.083     2.236     0.200
    20.110     1.848     0.200
    20.198     1.424     0.200
    20.216     3.293     0.200
    20.226     1.839     0.200
    20.258     1.843     0.200
    20.266     1.978     0.200
    20.440     3.269     0.200
    20.498     2.244     0.200
    20.499     1.486     0.200
    20.600     3.008     0.200
    20.663     2.926     0.200
    20.703     1.704     0.200
    20.723     3.806     0.200
    20.693     4.319     0.200
    20.794     1.660     0.200
    20.848     3.371     0.200
    20.902     1.929     0.200
    20.918     2.262     0.200
    20.953     3.428     0.200
    20.999     0.682     0.200
    21.050     3.260     0.200
    21.049     3.748     0.200
    21.112     2.661     0.200
    21.161     4.257     0.200
    21.208     3.394     0.200
    21.242     2.905     0.200
    21.310     4.474     0.200
    21.478     3.630     0.200
    21.484     1.886     0.200
    21.494     4.140     0.200
    21.513     1.027     0.200
    21.560     2.651     0.200
    21.561     0.904     0.200
    21.581     2.441     0.200
    21.626     3.662     0.200
    21.659     4.440     0.200
    21.668     4.369     0.200
    21.696     4.079     0.200
    21.706     2.968     0.200
    21.706     3.108     0.200
    21.720     3.336     0.200
    21.792     2.452     0.200
    21.800     0.003     0.200
    21.902     2.803     0.200
    21.906     3.221     0.200
    21.922     0.159     0.200
    21.958     4.132     0.200
    22.015     4.335     0.200
    22.032     3.891     0.200
    22.143     4.207     0.200
    22.157     3.391     0.200
    22.172     4.286     0.200
    22.182     1.985     0.200
    22.203     2.397     0.200
    22.231     3.094     0.200
    22.261     0.589     0.200
    22.303     2.295     0.200
    22.305     3.816     0.200
    22.443     4.027     0.200
    22.482    -0.661     0.200
    22.478     4.107     0.200
    22.496     3.049     0.200
    22.509     2.051     0.200
    22.522     4.154     0.200
    22.526     3.817     0.200
    22.526     4.168     0.200
    22.567     3.304     0.200
    22.575     2.829     0.200
    22.589     2.320     0.200
    22.643     0.148     0.200
    22.647     2.871     0.200
    22.716     2.048     0.200
    22.796     2.366     0.200
    22.807     2.342     0.200
    22.803     4.868     0.200
    22.822     0.116     0.200
    22.875     1.457     0.200
    22.890     3.965     0.200
    22.917     2.729     0.200
    22.940     2.871     0.200
    22.970     4.205     0.200
    22.999     2.067     0.200
    23.041     2.703     0.200
    23.110     2.745     0.200
    23.251     3.043     0.200
    23.252     4.106     0.200
    23.306     3.847     0.200
    23.335     1.629     0.200
    23.376     0.356     0.200
    23.406     2.137     0.200
    23.394     3.953     0.200
    23.443     0.139     0.200
    23.434     3.915     0.200
    23.456     1.628     0.200
    23.455     2.341     0.200
    23.476     1.956     0.200
    23.514     3.955     0.200
    23.556     3.070     0.200
    23.619     2.039     0.200
    23.613     3.694     0.200
    23.683     3.934     0.200
    23.722     4.197     0.200
    23.734     3.644     0.200
    23.786     3.045     0.200
    23.786     1.949     0.200
    23.847     1.012     0.200
    23.863     2.684     0.200
    23.886     4.261     0.200
    23.913     4.409     0.200
    23.913     4.253     0.200
    23.919     3.950     0.200
    23.948     2.709     0.200
    23.951     2.266     0.200
    23.950     0.016     0.200
    23.964     4.081     0.200
    24.044     2.424     0.200
    24.046     1.388     0.200
    24.046     2.334     0.200
    24.049     4.032     0.200
    24.080     2.909     0.200
    24.101     2.891     0.200
    24.101     3.055     0.200
    24.110     4.711     0.200
    24.117     4.344     0.200
    24.139     2.599     0.200
    24.161     3.671     0.200
    24.166     1.488     0.200
    24.136     4.356     0.200
    24.194     3.546     0.200
    24.200     3.652     0.200
    24.214     3.466     0.200
    24.227     0.541     0.200
    24.320     4.267     0.200
    24.337     3.369     0.200
    24.385     2.000     0.200
    24.445     1.964     0.200
    24.500     2.897     0.200
    24.508     3.548     0.200
    24.528     3.141     0.200
    24.543     3.388     0.200
    24.545     4.411     0.200
    24.590     5.454     0.200
    24.590     4.579     0.200
    24.654     2.633     0.200
    24.665     2.743     0.200
    24.735     3.309     0.200
    24.742     3.647     0.200
    24.745     3.023     0.200
    24.776     4.153     0.200
    24.788     4.318     0.200
    24.833     2.713     0.200
    24.841     4.491     0.200
    24.889     3.058     0.200
    24.935     1.790     0.200
    24.997     3.198     0.200
    24.993     4.738     0.200
    25.041     3.024     0.200
    25.056     4.490     0.200
    25.105     4.544     0.200
    25.138     4.244     0.200
    25.138     4.916     0.200
    25.149     3.432     0.200
    25.187     1.537     0.200
    25.200     2.845     0.200
    25.297     3.195     0.200
    25.301     5.850     0.200
    25.442     2.856     0.200
    25.448     4.245     0.200
    25.449     4.851     0.200
    25.410     2.534     0.200
    25.451     4.612     0.200
    25.468     2.445     0.200
    25.504     1.258     0.200
    25.510     3.004     0.200
    25.516     3.316     0.200
    25.565     4.299     0.200
    25.596     2.942     0.200
    25.624     4.799     0.200
    25.665     2.336     0.200
    25.720     3.464     0.200
    25.752     3.251     0.200
    25.765     1.400     0.200
    25.810     2.685     0.200
    25.838     4.961     0.200
    25.852     2.514     0.200
    25.863     2.546     0.200
    25.815     3.974     0.200
    25.880     2.741     0.200
    25.891     2.533     0.200
    25.893     3.702     0.200
    25.893     3.886     0.200
    25.937     3.693     0.200
    25.969     4.639     0.200
    26.053     2.348     0.200
    26.115     2.969     0.200
    26.121     2.790     0.200
    26.274     2.702     0.200
    26.278     3.073     0.200
    26.336     2.799     0.200
    26.355     2.324     0.200
    26.466     2.623     0.200
    26.473     3.258     0.200
    26.500     2.278     0.200
    26.589     1.971     0.200
    26.567     5.558     0.200
    26.631     2.315     0.200
    26.595     4.992     0.200
    26.690     2.957     0.200
    26.688     3.176     0.200
    26.717     4.524     0.200
    26.736     2.250     0.200
    26.742     5.371     0.200
    26.856     1.277     0.200
    26.894     2.746     0.200
    26.911     2.333     0.200
    26.928     4.810     0.200
    26.974     3.516     0.200
    26.950     5.366     0.200
    27.005     4.998     0.200
    27.011     2.805     0.200
    27.016     2.391     0.200
    26.998     4.003     0.200
    27.063     2.488     0.200
    27.146     2.855     0.200
    27.146     2.746     0.200
    27.159     3.225     0.200
    27.189     3.161     0.200
    27.204     2.683     0.200
    27.259     3.186     0.200
    27.320     3.288     0.200
    27.332     1.023     0.200
    27.335     3.281     0.200
    27.344     3.783     0.200
    27.344     3.974     0.200
    27.424     2.133     0.200
    27.453     1.434     0.200
    27.482     2.286     0.200
    27.519     2.906     0.200
    27.528     2.924     0.200
    27.482     6.470     0.200
    27.482     6.654     0.200
    27.514     3.556     0.200
    27.587     3.107     0.200
    27.547     4.197     0.200
    27.605     2.859     0.200
    27.649     3.406     0.200
    27.668     4.719     0.200
    27.684     2.887     0.200
    27.798     3.163     0.200
    27.756     4.184     0.200
    27.877     4.053     0.200
    27.912     3.289     0.200
    27.974     3.444     0.200
    27.984     4.101     0.200
    28.002     2.007     0.200
    28.018     3.254     0.200
    27.980     4.505     0.200
    28.058     3.288     0.200
    28.068     2.359     0.200
    28.073     3.331     0.200
    28.086     3.025     0.200
    28.122     3.531     0.200
    28.159     2.367     0.200
    28.183     3.168     0.200
    28.186     2.845     0.200
    28.193     3.342     0.200
    28.204     3.309     0.200
    28.205     3.207     0.200
    28.217     2.911     0.200
    28.341     2.675     0.200
    28.368     3.400     0.200
    28.382     2.901     0.200
    28.397     2.577     0.200
    28.416     4.751     0.200
    28.493     3.338     0.200
    28.574     2.826     0.200
    28.579     3.361     0.200
    28.623     2.404     0.200
    28.626     2.196     0.200
    28.714     3.182     0.200
    28.782     2.196     0.200
    28.790     3.276     0.200
    28.795     0.563     0.200
    28.796     2.893     0.200
    28.876     3.537     0.200
    28.932     3.703     0.200
    28.949     2.408     0.200
    28.959     2.727     0.200
    29.043     3.980     0.200
    29.133     3.574     0.200
    29.136     2.299     0.200
    29.138     2.083     0.200
    29.143     2.091     0.200
    29.146     4.656     0.200
    29.174     3.412     0.200
    29.282     2.786     0.200
    29.291     4.138     0.200
    29.322     1.597     0.200
    29.281     5.299     0.200
    29.387     3.884     0.200
    29.403     3.571     0.200
    29.404     3.452     0.200
    29.511     2.072     0.200
    29.536     2.866     0.200
    29.571     4.282     0.200
    29.604     3.601     0.200
    29.684     2.614     0.200
    29.738     4.028     0.200
    29.813     3.523     0.200
    29.827     2.336     0.200
    29.834     4.274     0.200
    29.868     3.716     0.200
    29.886     2.017     0.200
    29.902     2.549     0.200
    29.908     2.402     0.200
    29.918     1.835     0.200
    29.968     3.960     0.200
    29.991     4.217     0.200
    30.007     2.939     0.200
    30.042     3.957     0.200
    30.125     2.857     0.200
    30.173     2.206     0.200
    30.186     3.944     0.200
    30.197     2.431     0.200
    30.208     1.175     0.200
    30.214     3.612     0.200
    30.220     3.794     0.200
    30.330     3.186     0.200
    30.330     3.479     0.200
    30.355     2.754     0.200
    30.357     3.660     0.200
    30.368     4.942     0.200
    30.377     1.018     0.200
    30.377     2.975     0.200
    30.396     3.962     0.200
    30.418     3.719     0.200
    30.447     2.793     0.200
    30.501     3.659     0.200
    30.537     2.427     0.200
    30.540     2.170     0.200
    30.557     3.723     0.200
    30.605     3.809     0.200
    30.647     2.855     0.200
    30.677     3.606     0.200
    30.693     2.951     0.200
    30.770     3.272     0.200
    30.795     3.007     0.200
    30.797     2.973     0.200
    30.799     3.592     0.200
    30.836     5.421     0.200
    30.837     2.211     0.200
    30.854     2.037     0.200
    30.856     5.600     0.200
    30.870     4.019     0.200
    30.920     2.469     0.200
    30.925     3.059     0.200
    31.037     3.262     0.200
    31.137     2.986     0.200
    31.153     2.787     0.200
    31.188     2.665     0.200
    31.205     3.201     0.200
    31.324     3.469     0.200
    31.364     3.031     0.200
    31.373     3.092     0.200
    31.410     3.253     0.200
    31.448     2.612     0.200
    31.495     2.715     0.200
    31.528     3.181     0.200
    31.598     2.009     0.200
    31.606     3.512     0.200
    31.617     3.185     0.200
    31.631     3.011     0.200
    31.656     0.512     0.200
    31.703     2.510     0.200
    31.703     2.674     0.200
    31.703     5.158     0.200
    31.715     2.977     0.200
    31.725     2.836     0.200
    31.725     3.027     0.200
    31.747     2.384     0.200
    31.782     2.980     0.200
    31.856     3.107     0.200
    31.901     2.841     0.200
    31.870     2.242     0.200
    31.870     1.910     0.200
    31.994     2.756     0.200
    31.996     3.057     0.200
    32.020     2.588     0.200
    32.059     2.828     0.200
    32.124     2.975     0.200
    32.135     2.814     0.200
    32.138     2.644     0.200
    32.138     2.945     0.200
    32.141     2.220     0.200
    32.197     2.473     0.200
    32.220     2.723     0.200
    32.236     4.260     0.200
    32.258     3.027     0.200
    32.288     2.180     0.200
    32.361     2.859     0.200
    32.384     3.106     0.200
    32.395     2.935     0.200
    32.415     2.846     0.200
    32.439     2.506     0.200
    32.470     4.430     0.200
    32.481     1.401     0.200
    32.494     2.821     0.200
    32.505     2.828     0.200
    32.521     2.815     0.200
    32.596     2.808     0.200
    32.607     2.560     0.200
    32.623     2.763     0.200
    32.658     0.757     0.200
    32.733     3.748     0.200
    32.752     2.728     0.200
    32.771     2.208     0.200
    32.799     2.594     0.200
    32.834     3.772     0.200
    32.876     5.020     0.200
    32.953     2.313     0.200
    33.008     2.267     0.200
    33.049     2.773     0.200
    33.073     3.133     0.200
    33.078     2.565     0.200
    33.078     2.411     0.200
    33.214     2.836     0.200
    33.297     2.707     0.200
    33.310     3.246     0.200
    33.314     2.702     0.200
    33.388     2.393     0.200
    33.391     1.005     0.200
    33.384     4.890     0.200
    33.412     2.813     0.200
    33.425     2.821     0.200
    33.667     3.123     0.200
    33.734     2.327     0.200
    33.755     2.187     0.200
    33.758     2.306     0.200
    33.798     4.940     0.200
    33.853     3.680     0.200
    33.912     3.050     0.200
    33.908     2.618     0.200
    34.063     3.768     0.200
    34.094     2.783     0.200
    34.125     3.277     0.200
    34.343     1.739     0.200
    34.357     1.163     0.200
    34.417     2.554     0.200
    34.417     2.250     0.200
    34.446     1.845     0.200
    34.524     3.084     0.200
    34.608     2.513     0.200
    34.713     1.371     0.200
    34.841     1.701     0.200
    34.869     3.924     0.200
    34.959     2.418     0.200
    34.997     3.488     0.200
    35.017     1.795     0.200
    35.057     3.694     0.200
    35.051     3.510     0.200
    35.309     2.734     0.200
    35.371     1.404     0.200
    35.854     2.422     0.200
    36.398     4.103     0.200
    36.455     4.265     0.200
    37.169     2.263     0.200
    37.317     2.917     0.200
    37.787     1.886     0.200
    37.787     1.386     0.200
    38.662     2.640     0.200
    39.523     2.845     0.200
    44.214     1.735     0.200
    44.786     5.306     0.200
    45.264     4.046     0.200
    45.264     4.562     0.200
    45.439     1.703     0.200
    45.439     1.805     0.200
    46.218     4.520     0.200
    46.559     1.518     0.200
    46.742     2.248     0.200
    46.808     1.513     0.200
    47.164     4.703     0.200
    49.816     2.652     0.200
    50.099     3.062     0.200
    51.523     3.327     0.200
    52.662     4.619     0.200
    53.498     4.428     0.200
    54.384     4.222     0.200
    54.949     3.493     0.200
    55.126     5.159     0.200
    55.127     5.047     0.200
    55.390     2.843     0.200
    55.696     2.456     0.200
    55.706     3.487     0.200
    55.840     3.328     0.200
    55.999     3.152     0.200
    56.354     3.356     0.200
    56.453     3.727     0.200
    56.577     2.667     0.200
    56.584     3.664     0.200
    57.246     4.329     0.200
    57.265     5.291     0.200
    57.363     2.956     0.200
    57.569     3.249     0.200
    57.633     2.949     0.200
    57.765     2.675     0.200
    57.718     4.598     0.200
    57.843     1.274     0.200
    57.953     2.751     0.200
    58.455     2.628     0.200
    58.939     4.782     0.200
    59.143     2.269     0.200
    59.143     2.371     0.200
    59.143     0.988     0.200
    59.435     2.600     0.200
    59.792     2.307     0.200
    59.824     3.516     0.200
    59.795     4.971     0.200
    59.838     4.972     0.200
    59.986     5.855     0.200
    59.998     4.979     0.200
    60.264     3.995     0.200
    62.928     3.015     0.200
    63.367     3.771     0.200
    64.215     1.591     0.200
    64.913     3.033     0.200
    65.484     3.141     0.200
    65.484     2.770     0.200
    65.810     3.990     0.200
    66.839     4.468     0.200
    67.252     1.027     0.200
    70.048     2.396     0.200
    71.572     1.633     0.200
    75.072     2.338     0.200
    75.072     2.760     0.200
    75.940     3.536     0.200
    77.541     2.763     0.200
    77.541     3.704     0.200
    77.541     3.044     0.200
    77.584     4.056     0.200
    77.584     4.200     0.200
    79.833     1.995     0.200
    79.841     4.052     0.200
    79.947     2.481     0.200
    80.292     3.422     0.200
    80.328     2.928     0.200
    80.412     3.274     0.200
    80.551     3.533     0.200
    80.563     2.863     0.200
    80.564     3.559     0.200
    80.571     3.725     0.200
    80.665     3.419     0.200
    80.665     2.618     0.200
    80.748     2.775     0.200
    80.748     2.572     0.200
    80.772     3.246     0.200
    80.855     2.904     0.200
    80.855     2.802     0.200
    80.936     2.673     0.200
    80.938     3.659     0.200
    80.988     3.498     0.200
    81.092     3.643     0.200
    81.093     3.036     0.200
    81.102     2.888     0.200
    81.237     3.571     0.200
    81.362     3.307     0.200
    81.648     2.497     0.200
    81.833     2.521     0.200
    82.131     2.459     0.200
    82.612     2.536     0.200
    82.691     1.424     0.200
    83.029     3.578     0.200
    83.175     3.026     0.200
    83.299     3.086     0.200
    83.337     4.200     0.200
    83.350     2.487     0.200
    83.342     2.766     0.200
    83.389     4.178     0.200
    83.460     3.568     0.200
    83.550     2.695     0.200
    83.591     2.716     0.200
    83.591     3.216     0.200
    83.635     3.340     0.200
    83.761     0.488     0.200
    84.064     3.442     0.200
    84.064     3.571     0.200
    84.187     3.046     0.200
    84.543     3.443     0.200
    84.731     3.690     0.200
    84.871     2.747     0.200
    84.871     3.388     0.200
    84.940     2.792     0.200
    84.999     2.948     0.200
    84.999     2.167     0.200
    85.073     3.472     0.200
    85.136     3.263     0.200
    85.252     0.411     0.200
    85.252     1.208     0.200
    85.277     1.927     0.200
    85.308     3.203     0.200
    85.484     3.420     0.200
    85.578     2.488     0.200
    85.578     0.937     0.200
    85.578     1.847     0.200
    85.635     2.292     0.200
    85.657     3.263     0.200
    85.705     3.021     0.200
    85.728     3.811     0.200
    85.753     3.088     0.200
    85.768     3.010     0.200
    85.829     2.812     0.200
    85.847     1.521     0.200
    85.972     3.215     0.200
    86.106     3.242     0.200
    86.148     2.630     0.200
    86.193     2.609     0.200
    86.199     2.883     0.200
    86.203     2.961     0.200
    86.274     2.986     0.200
    86.393     2.229     0.200
    86.395     2.419     0.200
    86.537     2.921     0.200
    86.545     2.679     0.200
    86.617     2.716     0.200
    86.759     2.135     0.200
    86.840     2.642     0.200
    86.846     3.006     0.200
    86.877     3.658     0.200
    86.942     2.341     0.200
    86.956     2.973     0.200
    87.068     2.629     0.200
    87.068     2.129     0.200
    87.068     2.828     0.200
    87.234     2.725     0.200
    87.521     2.740     0.200
    87.595     2.984     0.200
    87.675     2.900     0.200
    87.698     3.190     0.200
    87.712     3.021     0.200
    87.830     2.365     0.200
    87.956     2.865     0.200
    88.082     6.466     0.200
    88.082     6.067     0.200
    88.186     2.771     0.200
    88.204     2.688     0.200
    88.207     2.575     0.200
    88.216     2.130     0.200
    88.240     2.320     0.200
    88.246     1.391     0.200
    88.246     2.091     0.200
    88.332     2.284     0.200
    88.376     2.076     0.200
    88.385     2.436     0.200
    88.617     3.039     0.200
    88.696     2.667     0.200
    88.726     2.922     0.200
    88.851     2.836     0.200
    88.902     2.395     0.200
    88.912     3.754     0.200
    88.915     2.035     0.200
    88.915     1.785     0.200
    88.915     3.035     0.200
    89.055     3.478     0.200
    89.048     3.312     0.200
    89.068     3.418     0.200
    89.147     1.448     0.200
    89.253     2.748     0.200
    89.287     1.889     0.200
    89.385     2.829     0.200
    89.684     2.833     0.200
    89.760     2.577     0.200
    89.763     2.063     0.200
    89.849     2.762     0.200
    90.050     3.322     0.200
    90.193     2.643     0.200
    90.229     2.589     0.200
    90.303     2.913     0.200
    90.323     2.652     0.200
    90.323     2.351     0.200
    90.320     2.832     0.200
    90.331     2.711     0.200
    90.384     2.765     0.200
    90.429     3.054     0.200
    90.434     2.633     0.200
    90.444     2.984     0.200
    90.497    -0.658     0.200
    90.510     3.177     0.200
    90.587     2.924     0.200
    90.700     2.895     0.200
    90.755     2.949     0.200
    90.764     2.296     0.200
    90.836     0.654     0.200
    90.835     1.588     0.200
    90.940     3.039     0.200
    91.026     2.882     0.200
    91.051     2.805     0.200
    91.051     2.664     0.200
    91.263     3.079     0.200
    91.567     3.075     0.200
    91.675     2.670     0.200
    91.675     2.542     0.200
    91.706     0.930     0.200
    91.713     3.097     0.200
    91.814     2.629     0.200
    91.869     2.476     0.200
    91.882     2.414     0.200
    91.882     2.914     0.200
    92.156     2.542     0.200
    92.275     2.398     0.200
    92.362     2.492     0.200
    92.362     2.594     0.200
    92.378     2.922     0.200
    92.507     2.729     0.200
    92.535     3.194     0.200
    92.628     3.167     0.200
    92.689     2.217     0.200
    92.690     1.979     0.200
    93.146     2.747     0.200
    93.505     2.292     0.200
    93.587     2.784     0.200
    93.598     2.597     0.200
    93.715     1.860     0.200
    93.786     2.604     0.200
    93.803     3.425     0.200
    93.900     3.111     0.200
    94.024     2.559     0.200
    94.116     3.317     0.200
    94.168     2.275     0.200
    94.492     1.523     0.200
    94.551     1.560     0.200
    94.592     2.132     0.200
    94.732     1.380     0.200
    94.844     3.879     0.200
    94.984     1.115     0.200
    94.997     2.978     0.200
    95.304     3.374     0.200
    95.394     2.163     0.200
    95.644     3.624     0.200
    95.904     3.641     0.200
    95.904     4.040     0.200
    96.225     2.277     0.200
    96.477     2.936     0.200
    96.648     3.263     0.200
    96.709     1.685     0.200
    96.832     3.427     0.200
    97.061     2.489     0.200
    14.966     5.716     0.200
    15.526     4.218     0.200
    16.312     4.125     0.200
    16.692     4.822     0.200
    16.795     4.418     0.200
    17.037     3.385     0.200
    17.386     2.858     0.200
    17.393     4.092     0.200
    17.685     4.297     0.200
    18.099     4.360     0.200
    18.222     1.187     0.200
    18.249     0.888     0.200
    18.757     2.793     0.200
    18.787     3.098     0.200
    18.985     2.006     0.200
    19.054     2.135     0.200
    19.182     1.256     0.200
    19.217     1.229     0.200
    19.552    -0.178     0.200
    19.562     2.398     0.200
    19.615     2.498     0.200
    19.821     2.059     0.200
    19.926     1.813     0.200
    20.016     2.376     0.200
    20.055     1.397     0.200
    20.066     1.282     0.200
    20.073     1.544     0.200
    20.210     2.628     0.200
    20.302     1.563     0.200
    20.403     1.743     0.200
    20.447     2.001     0.200
    20.464     2.056     0.200
    20.480     1.843     0.200
    20.512     2.085     0.200
    20.521     2.325     0.200
    20.601    -0.005     0.200
    20.723     1.459     0.200
    20.750     2.815     0.200
    20.849     2.485     0.200
    20.915     1.705     0.200
    21.006     2.128     0.200
    21.044     2.212     0.200
    21.107     2.166     0.200
    21.107     3.322     0.200
    21.117     1.399     0.200
    21.205     2.719     0.200
    21.252     1.152     0.200
    21.290     1.821     0.200
    21.291     1.730     0.200
    21.363     1.516     0.200
    21.387     2.115     0.200
    21.429    -0.857     0.200
    21.503     2.425     0.200
    21.503     2.714     0.200
    21.519     2.697     0.200
    21.594     1.717     0.200
    21.639     1.831     0.200
    21.673    -0.617     0.200
    21.704     2.770     0.200
    21.703     2.540     0.200
    21.809    -0.738     0.200
    21.943     5.435     0.200
    21.970     5.091     0.200
    22.029     2.764     0.200
    22.087     0.501     0.200
    22.275     4.039     0.200
    22.295     2.565     0.200
    22.366     2.992     0.200
    22.373     2.074     0.200
    22.444     3.311     0.200
    22.503     1.874     0.200
    22.524     2.570     0.200
    22.595     2.454     0.200
    22.614     1.693     0.200
    22.691     5.345     0.200
    22.715     1.057     0.200
    22.910     2.761     0.200
    22.992    -0.265     0.200
    23.050     2.577     0.200
    23.107     4.605     0.200
    23.209     1.080     0.200
    23.209     2.072     0.200
    23.271    -0.736     0.200
    23.271    -0.330     0.200
    23.310     0.657     0.200
    23.584     2.225     0.200
    23.665     2.124     0.200
    23.683     4.482     0.200
    23.712     1.523     0.200
    23.749     2.418     0.200
    23.760     2.669     0.200
    23.813     3.421     0.200
    23.856     2.828     0.200
    23.878     2.736     0.200
    23.898     3.238     0.200
    23.898     3.606     0.200
    23.990     3.928     0.200
    23.997     2.703     0.200
    24.058     1.172     0.200
    24.136     3.069     0.200
    24.269     3.529     0.200
    24.305     3.774     0.200
    24.331     2.536     0.200
    24.534     3.646     0.200
    24.542     4.008     0.200
    24.797     3.260     0.200
    24.804     0.987     0.200
    25.040     0.913     0.200
    25.094     2.968     0.200
    25.311     4.535     0.200
    25.313     4.035     0.200
    25.339     1.331     0.200
    25.362     4.490     0.200
    25.689     3.626     0.200
    25.689     5.391     0.200
    25.921     3.267     0.200
    26.267     3.674     0.200
    26.257     1.540     0.200
    26.272     3.757     0.200
    26.680     1.688     0.200
    26.727     4.409     0.200
    26.804     4.208     0.200
    26.945     3.515     0.200
    26.945     3.280     0.200
    26.945     2.391     0.200
    27.117     3.729     0.200
    27.136     3.143     0.200
    27.211     0.828     0.200
    27.407     2.845     0.200
    27.446     3.759     0.200
    27.483     2.972     0.200
    27.713     3.416     0.200
    27.993     3.128     0.200
    28.016     3.303     0.200
    28.068     1.443     0.200
    28.144     3.005     0.200
    28.181     3.308     0.200
    28.373     3.142     0.200
    28.759     3.085     0.200
    28.943     2.760     0.200
    29.201     4.114     0.200
    29.609     4.127     0.200
    29.703     3.162     0.200
    29.766     3.506     0.200
    29.789     3.894     0.200
    29.926     3.093     0.200
    30.068     2.226     0.200
    30.220     1.286     0.200
    30.248     2.283     0.200
    30.474     3.588     0.200
    30.568     3.003     0.200
    30.595     3.598     0.200
    30.597     3.714     0.200
    30.670     3.545     0.200
    30.723     3.250     0.200
    30.725     2.922     0.200
    30.884     3.361     0.200
    30.939     3.038     0.200
    30.959     3.208     0.200
    31.004     3.240     0.200
    31.121     3.182     0.200
    31.171     3.585     0.200
    31.328     3.272     0.200
    31.403     3.675     0.200
    31.415     3.173     0.200
    31.517     3.048     0.200
    31.527     5.811     0.200
    31.552     3.346     0.200
    31.589     3.097     0.200
    31.793     3.142     0.200
    31.796     3.149     0.200
    31.961     6.245     0.200
    32.159     3.266     0.200
    32.194     3.093     0.200
    32.319     2.616     0.200
    32.550     2.509     0.200
    32.569     2.593     0.200
    32.602     2.051     0.200
    32.709     3.131     0.200
    32.848     2.685     0.200
    33.015     3.009     0.200
    33.113     3.325     0.200
    33.214     1.794     0.200
    33.711     3.940     0.200
    37.599     1.560     0.200
    45.311     0.624     0.200
    45.455     3.956     0.200
    46.546     1.088     0.200
    50.281     2.087     0.200
    54.181     5.310     0.200
    57.043     3.464     0.200
    57.430     2.908     0.200
    57.430     2.909     0.200
    57.750     2.424     0.200
    60.430     3.253     0.200
    63.570     3.211     0.200
    65.332     2.308     0.200
    83.864     2.716     0.200
    15.748     2.947     0.200
    15.748     3.255     0.200
    15.644     7.234     0.200
    16.028     4.266     0.200
    16.724     6.209     0.200
    16.983     4.219     0.200
    17.338     3.678     0.200
    18.122     1.170     0.200
    18.122     1.401     0.200
    18.137     1.611     0.200
    18.270     1.088     0.200
    18.323     1.392     0.200
    18.324     1.583     0.200
    18.406     3.575     0.200
    18.428     3.570     0.200
    18.428     4.230     0.200
    18.452     1.310     0.200
    18.452     2.193     0.200
    18.459     1.619     0.200
    18.476     3.686     0.200
    18.476     4.174     0.200
    18.532     1.348     0.200
    18.557     3.735     0.200
    18.651     0.607     0.200
    18.666     0.253     0.200
    18.859     0.677     0.200
    19.083     0.948     0.200
    19.209     1.115     0.200
    19.273     0.793     0.200
    19.354     1.362     0.200
    19.438     1.194     0.200
    19.464     1.364     0.200
    19.464     1.490     0.200
    19.479     1.432     0.200
    19.562     0.654     0.200
    19.585     0.895     0.200
    19.619     0.921     0.200
    19.664     1.129     0.200
    19.679     1.071     0.200
    19.711     1.355     0.200
    19.791     1.997     0.200
    19.835     1.010     0.200
    19.886     0.937     0.200
    19.951     0.601     0.200
    20.067     1.185     0.200
    20.064     0.618     0.200
    20.123     0.935     0.200
    20.243     0.838     0.200
    20.258     1.453     0.200
    20.269     1.131     0.200
    20.276     1.007     0.200
    20.328     1.627     0.200
    20.401     1.095     0.200
    20.469     1.055     0.200
    20.623     1.286     0.200
    20.623     1.700     0.200
    20.684     0.258     0.200
    20.717     0.218     0.200
    20.781     0.713     0.200
    20.847     1.151     0.200
    20.858     1.549     0.200
    20.905     0.914     0.200
    20.956     0.913     0.200
    21.022     0.738     0.200
    21.162     0.824     0.200
    21.238     0.630     0.200
    21.109     3.584     0.200
    21.234     4.175     0.200
    21.234     4.440     0.200
    21.320     0.658     0.200
    21.370     0.478     0.200
    21.402     4.614     0.200
    21.402     4.840     0.200
    21.493     0.991     0.200
    21.517     0.971     0.200
    21.518     2.963     0.200
    21.518     2.849     0.200
    21.539     1.071     0.200
    21.555     0.203     0.200
    21.574     0.668     0.200
    21.570     3.628     0.200
    21.570     4.132     0.200
    21.648     0.726     0.200
    21.666     0.532     0.200
    21.669     0.763     0.200
    21.696     2.255     0.200
    21.763     0.976     0.200
    21.737     4.234     0.200
    21.776     3.459     0.200
    21.810     2.912     0.200
    21.810     3.260     0.200
    21.830     3.421     0.200
    21.859     0.191     0.200
    21.907     1.007     0.200
    21.934     0.131     0.200
    21.934     0.303     0.200
    21.951     1.490     0.200
    21.951     0.450     0.200
    22.043     0.868     0.200
    22.054     0.349     0.200
    22.031     3.561     0.200
    22.083     3.894     0.200
    22.146     1.054     0.200
    22.097     5.330     0.200
    22.182     0.833     0.200
    22.189     0.889     0.200
    22.216     0.478     0.200
    22.218     3.767     0.200
    22.255     4.458     0.200
    22.303     1.925     0.200
    22.303     2.140     0.200
    22.379     0.440     0.200
    22.392     0.699     0.200
    22.392     1.109     0.200
    22.395     0.509     0.200
    22.384     3.344     0.200
    22.472     0.576     0.200
    22.508     3.682     0.200
    22.570     4.414     0.200
    22.634     0.901     0.200
    22.624     2.455     0.200
    22.624     2.334     0.200
    22.595     4.067     0.200
    22.596     3.225     0.200
    22.596     4.233     0.200
    22.596     4.780     0.200
    22.712     0.416     0.200
    22.775     1.082     0.200
    22.777     2.901     0.200
    22.813     0.858     0.200
    22.795     3.042     0.200
    22.880     0.441     0.200
    22.929     0.020     0.200
    22.882     5.431     0.200
    22.953     0.532     0.200
    22.967     3.521     0.200
    23.022     2.634     0.200
    23.049     2.189     0.200
    23.078     0.406     0.200
    23.093    -0.021     0.200
    23.037     3.026     0.200
    23.183     0.237     0.200
    23.190     2.968     0.200
    23.221     2.879     0.200
    23.277     0.798     0.200
    23.288     0.396     0.200
    23.295     3.810     0.200
    23.370     0.324     0.200
    23.322     3.978     0.200
    23.425     0.593     0.200
    23.381     3.926     0.200
    23.456     0.641     0.200
    23.480     3.878     0.200
    23.507     0.636     0.200
    23.522     2.219     0.200
    23.577     1.477     0.200
    23.463     4.391     0.200
    23.607     0.467     0.200
    23.615     0.267     0.200
    23.621     0.578     0.200
    23.592     4.108     0.200
    23.676     3.417     0.200
    23.781     0.023     0.200
    23.751     4.096     0.200
    23.795     4.169     0.200
    23.861     0.117     0.200
    23.799     3.646     0.200
    23.889     4.407     0.200
    23.925     1.589     0.200
    23.906     2.899     0.200
    23.909     3.352     0.200
    23.946     1.427     0.200
    23.964     1.619     0.200
    23.988     4.273     0.200
    23.988     5.062     0.200
    23.987     5.174     0.200
    24.085     2.365     0.200
    24.031     4.349     0.200
    24.123     1.261     0.200
    24.169     2.509     0.200
    24.169     3.454     0.200
    24.127     3.607     0.200
    24.182     0.827     0.200
    24.209     0.671     0.200
    24.203     3.198     0.200
    24.177     4.246     0.200
    24.240     1.222     0.200
    24.286     1.069     0.200
    24.297     1.783     0.200
    24.290     3.903     0.200
    24.346     0.910     0.200
    24.361     1.358     0.200
    24.305     3.584     0.200
    24.390     4.581     0.200
    24.446     3.790     0.200
    24.446     3.904     0.200
    24.484     2.747     0.200
    24.513     1.930     0.200
    24.513     2.375     0.200
    24.556     1.244     0.200
    24.574     2.215     0.200
    24.575     3.588     0.200
    24.544     4.025     0.200
    24.602     3.236     0.200
    24.609     3.888     0.200
    24.644     3.310     0.200
    24.644     2.931     0.200
    24.618     4.170     0.200
    24.657     4.119     0.200
    24.774     1.774     0.200
    24.787     1.095     0.200
    24.794     1.677     0.200
    24.831     1.737     0.200
    24.655     4.691     0.200
    24.839     3.677     0.200
    24.866     4.478     0.200
    24.935     1.328     0.200
    24.899     4.314     0.200
    24.899     4.962     0.200
    24.949     2.952     0.200
    24.917     4.392     0.200
    25.000     1.665     0.200
    25.037     3.993     0.200
    25.070     2.005     0.200
    25.062     4.349     0.200
    25.167     1.632     0.200
    25.175     1.847     0.200
    25.132     4.434     0.200
    25.169     2.918     0.200
    25.254     1.779     0.200
    25.210     4.190     0.200
    25.210     5.029     0.200
    25.318     2.629     0.200
    25.322     1.338     0.200
    25.322     1.760     0.200
    25.379     1.943     0.200
    25.397     3.590     0.200
    25.486     1.497     0.200
    25.504     3.847     0.200
    25.528     4.727     0.200
    25.517     4.387     0.200
    25.589     1.959     0.200
    25.637     1.694     0.200
    25.652     3.877     0.200
    25.652     4.162     0.200
    25.753     0.806     0.200
    25.766     2.012     0.200
    25.807     2.670     0.200
    25.831     2.103     0.200
    25.835     1.814     0.200
    25.812     4.565     0.200
    25.854     3.927     0.200
    25.899     0.887     0.200
    25.899     2.137     0.200
    25.911     1.022     0.200
    25.904     4.749     0.200
    25.994     1.409     0.200
    25.991     3.977     0.200
    26.038     3.929     0.200
    26.045     4.131     0.200
    26.124     1.623     0.200
    26.147     1.962     0.200
    26.301     3.995     0.200
    26.398     0.817     0.200
    26.434     1.526     0.200
    26.436     1.031     0.200
    26.457     2.299     0.200
    26.451     2.830     0.200
    26.451     3.400     0.200
    26.463     3.273     0.200
    26.484     2.189     0.200
    26.545     2.334     0.200
    26.547     1.616     0.200
    26.547     1.452     0.200
    26.592     3.117     0.200
    26.600     1.537     0.200
    26.608     3.191     0.200
    26.706     4.161     0.200
    26.762     0.765     0.200
    26.760     2.972     0.200
    26.760     2.134     0.200
    26.771     3.506     0.200
    26.792     3.365     0.200
    26.556     5.091     0.200
    26.556     5.560     0.200
    26.840     0.856     0.200
    26.794     5.245     0.200
    26.676     4.478     0.200
    26.942     0.952     0.200
    26.986     1.694     0.200
    26.986     1.913     0.200
    27.047     2.057     0.200
    27.085     4.433     0.200
    27.085     4.429     0.200
    27.141     0.167     0.200
    27.160     2.089     0.200
    27.163     2.622     0.200
    27.038     4.218     0.200
    27.177     1.897     0.200
    27.220     1.483     0.200
    27.246     2.829     0.200
    27.256     2.696     0.200
    27.256     3.134     0.200
    27.256     2.994     0.200
    27.256     2.994     0.200
    27.273     1.141     0.200
    27.279     3.400     0.200
    27.284     1.460     0.200
    27.301     2.934     0.200
    27.357     1.549     0.200
    27.375     2.970     0.200
    27.360     3.712     0.200
    27.437     4.313     0.200
    27.465     1.666     0.200
    27.509     2.482     0.200
    27.509     3.075     0.200
    27.563     0.486     0.200
    27.581     1.421     0.200
    27.628     1.158     0.200
    27.653     0.590     0.200
    27.697     1.864     0.200
    27.693     3.018     0.200
    27.474     6.717     0.200
    27.763     1.472     0.200
    27.750     5.044     0.200
    27.832     2.374     0.200
    27.842     2.659     0.200
    27.864     0.676     0.200
    27.876     2.809     0.200
    27.918     1.346     0.200
    27.956     3.215     0.200
    27.987     1.061     0.200
    27.952     4.012     0.200
    28.121     1.028     0.200
    28.122     1.240     0.200
    28.166     3.208     0.200
    28.228     2.250     0.200
    28.230     3.535     0.200
    28.264     1.066     0.200
    28.284     1.333     0.200
    28.287     2.247     0.200
    28.326     1.591     0.200
    28.325     3.305     0.200
    28.135     2.105     0.200
    28.382     1.531     0.200
    28.443     1.382     0.200
    28.452     0.969     0.200
    28.490     2.937     0.200
    28.505     2.837     0.200
    28.536     2.558     0.200
    28.570     1.191     0.200
    28.561     2.192     0.200
    28.577     2.412     0.200
    28.677     1.152     0.200
    28.682     3.384     0.200
    28.791     1.004     0.200
    28.786     3.598     0.200
    28.874     1.908     0.200
    28.928     1.344     0.200
    28.924     2.749     0.200
    28.914     3.716     0.200
    28.966     1.720     0.200
    28.972     1.814     0.200
    28.997     2.126     0.200
    29.014     1.414     0.200
    29.041     3.211     0.200
    29.041     4.258     0.200
    29.077     0.754     0.200
    29.074     2.292     0.200
    29.095     2.812     0.200
    29.105     0.974     0.200
    29.156     0.940     0.200
    29.153     4.933     0.200
    29.164     5.062     0.200
    29.234     2.591     0.200
    29.295     1.290     0.200
    29.395     2.911     0.200
    29.395     3.024     0.200
    29.400     3.835     0.200
    29.438     0.880     0.200
    29.459     1.605     0.200
    29.299     3.741     0.200
    29.299     4.355     0.200
    29.504     3.834     0.200
    29.606     2.273     0.200
    29.640     1.564     0.200
    29.630     5.005     0.200
    29.679     2.300     0.200
    29.678     4.368     0.200
    29.698     2.306     0.200
    29.700     1.963     0.200
    29.720     2.121     0.200
    29.725     1.157     0.200
    29.788     0.968     0.200
    29.800     1.130     0.200
    29.800     2.583     0.200
    29.876     1.192     0.200
    29.906     1.582     0.200
    29.910     3.761     0.200
    30.004     1.536     0.200
    30.032     1.363     0.200
    30.037     2.487     0.200
    30.097     4.589     0.200
    30.118     1.375     0.200
    30.193     1.711     0.200
    30.221     1.026     0.200
    30.249     1.559     0.200
    30.253     2.549     0.200
    30.282     2.269     0.200
    30.303     2.205     0.200
    30.336     2.239     0.200
    30.303     3.742     0.200
    30.344     1.376     0.200
    30.310     3.857     0.200
    30.433     1.089     0.200
    30.439     1.192     0.200
    30.438     2.572     0.200
    30.438     3.495     0.200
    30.438     3.749     0.200
    30.502     4.172     0.200
    30.563     0.783     0.200
    30.690     4.289     0.200
    30.728     4.017     0.200
    30.776     0.630     0.200
    30.850     2.044     0.200
    30.855     2.352     0.200
    30.870     1.223     0.200
    30.886     2.264     0.200
    30.877     3.717     0.200
    30.964     1.770     0.200
    30.914     2.247     0.200
    30.991     2.438     0.200
    31.026     0.563     0.200
    31.026     2.653     0.200
    31.053     0.963     0.200
    31.063     1.482     0.200
    31.182     0.779     0.200
    31.276     2.348     0.200
    31.391     1.113     0.200
    31.382     4.045     0.200
    31.463     1.588     0.200
    31.519     3.298     0.200
    31.539     2.052     0.200
    31.566     2.245     0.200
    31.579     1.202     0.200
    31.581     1.331     0.200
    31.581     2.132     0.200
    31.582     2.273     0.200
    31.588     2.591     0.200
    31.598     1.760     0.200
    31.599     1.940     0.200
    31.601     1.906     0.200
    31.607     0.939     0.200
    31.629     1.477     0.200
    31.596     4.291     0.200
    31.657     1.627     0.200
    31.669     3.039     0.200
    31.646     3.079     0.200
    31.695     2.995     0.200
    31.789     0.695     0.200
    31.825     2.574     0.200
    31.825     2.949     0.200
    31.778     3.728     0.200
    31.805     2.603     0.200
    31.862     1.142     0.200
    31.880     1.294     0.200
    31.948     3.013     0.200
    32.048     2.082     0.200
    32.058     1.924     0.200
    31.932     1.351     0.200
    32.092     2.147     0.200
    32.092     2.256     0.200
    32.114     2.109     0.200
    32.101     3.161     0.200
    32.127     1.738     0.200
    32.152     1.470     0.200
    32.199     2.784     0.200
    32.188     3.115     0.200
    32.180     3.724     0.200
    32.230     3.349     0.200
    32.230     3.173     0.200
    32.256     1.435     0.200
    32.252     2.850     0.200
    32.252     1.956     0.200
    32.419     2.241     0.200
    32.425     2.421     0.200
    32.580     3.297     0.200
    32.604     3.145     0.200
    32.777     2.578     0.200
    32.792     1.052     0.200
    32.792     0.860     0.200
    32.858     2.920     0.200
    33.025     3.552     0.200
    33.132     3.214     0.200
    33.156     3.350     0.200
    33.180     3.456     0.200
    33.321     3.756     0.200
    33.402     3.079     0.200
    33.396     3.772     0.200
    33.404     2.521     0.200
    33.417     3.502     0.200
    33.521     1.458     0.200
    33.540     3.049     0.200
    33.530     3.595     0.200
    33.683     3.377     0.200
    33.705     4.256     0.200
    34.038     2.481     0.200
    34.233     3.335     0.200
    34.356     4.361     0.200
    34.473     2.159     0.200
    34.486     2.499     0.200
    34.520     3.266     0.200
    34.520     3.914     0.200
    34.530     3.335     0.200
    34.577     2.919     0.200
    34.588     3.402     0.200
    34.658     4.509     0.200
    34.691     4.210     0.200
    34.732     3.799     0.200
    34.844     1.460     0.200
    34.911     4.318     0.200
    34.981     4.313     0.200
    35.011     3.644     0.200
    35.087     2.817     0.200
    35.090     3.895     0.200
    35.116     3.736     0.200
    35.147     2.039     0.200
    35.149     2.480     0.200
    35.153     3.728     0.200
    35.158     2.887     0.200
    35.387     3.108     0.200
    35.439     2.482     0.200
    35.503     1.780     0.200
    35.635     4.019     0.200
    35.717     2.972     0.200
    36.271     2.515     0.200
    36.304     2.822     0.200
    36.349     3.317     0.200
    36.395     2.776     0.200
    36.489     3.888     0.200
    36.738     4.765     0.200
    37.005     3.141     0.200
    37.446     2.189     0.200
    38.084     2.055     0.200
    39.008     1.590     0.200
    39.653     2.530     0.200
    40.980     1.919     0.200
    41.888     2.996     0.200
    42.114     1.947     0.200
    42.787     2.586     0.200
    44.183     1.747     0.200
    45.206     4.238     0.200
    45.573     1.702     0.200
    46.312     3.348     0.200
    46.860     1.482     0.200
    46.860     1.475     0.200
    46.970     1.643     0.200
    47.266     4.227     0.200
    49.354     4.813     0.200
    51.544     1.988     0.200
    53.617     4.666     0.200
    53.769     4.463     0.200
    54.480     4.188     0.200
    54.723     4.311     0.200
    55.045     3.776     0.200
    55.263     3.475     0.200
    55.301     4.034     0.200
    55.494     2.495     0.200
    55.808     2.310     0.200
    55.806     3.553     0.200
    55.938     3.145     0.200
    56.052     3.333     0.200
    56.090     3.219     0.200
    56.449     3.602     0.200
    56.449     3.461     0.200
    56.539     3.962     0.200
    56.577     3.427     0.200
    56.671     3.020     0.200
    56.669     2.969     0.200
    56.684     3.035     0.200
    56.725     3.341     0.200
    56.875     3.970     0.200
    57.286     2.567     0.200
    57.463     2.666     0.200
    57.463     2.666     0.200
    57.469     3.274     0.200
    57.668     2.978     0.200
    57.727     1.755     0.200
    57.724     3.273     0.200
    57.726     2.929     0.200
    57.737     2.300     0.200
    57.866     2.486     0.200
    57.866     2.869     0.200
    57.928     3.310     0.200
    57.971     1.197     0.200
    58.048     2.490     0.200
    58.051     3.040     0.200
    58.094     2.830     0.200
    58.350     2.699     0.200
    58.550     2.742     0.200
    58.638     2.390     0.200
    58.747     2.272     0.200
    59.000     2.771     0.200
    59.277     2.196     0.200
    59.277     2.353     0.200
    59.250     1.940     0.200
    59.376     2.267     0.200
    59.928     3.231     0.200
    60.151     2.239     0.200
    62.241     1.781     0.200
    63.270     3.755     0.200
    65.619     2.966     0.200
    65.619     2.786     0.200
    70.183     1.348     0.200
    71.707     1.201     0.200
    76.040     3.031     0.200
    77.674     3.422     0.200
    79.963     3.747     0.200
    80.238     2.963     0.200
    80.406     3.256     0.200
    80.528     2.902     0.200
    80.677     2.507     0.200
    80.864     2.708     0.200
    80.968     3.049     0.200
    80.979     4.093     0.200
    81.051     3.212     0.200
    81.055     3.088     0.200
    81.169     3.081     0.200
    81.204     3.195     0.200
    81.217     2.629     0.200
    81.349     3.727     0.200
    81.743     3.066     0.200
    81.799     2.949     0.200
    83.124     3.638     0.200
    83.457     2.817     0.200
    83.707     2.838     0.200
    84.138     3.387     0.200
    84.139     3.380     0.200
    85.005     4.559     0.200
    85.132     3.317     0.200
    85.132     3.599     0.200
    85.132     3.591     0.200
    85.220     2.378     0.200
    85.712     1.958     0.200
    85.712     1.950     0.200
    85.763     3.388     0.200
    85.926     1.666     0.200
    86.099     3.481     0.200
    86.401     3.554     0.200
    86.745     3.515     0.200
    89.042     3.269     0.200
    90.453     2.774     0.200
    90.639     2.406     0.200
    90.970     1.268     0.200
    90.970     1.295     0.200
    90.970     1.170     0.200
    90.954     3.182     0.200
    91.181     2.300     0.200
    91.804     2.403     0.200
    91.943     2.461     0.200
    92.011     2.347     0.200
    92.377     2.053     0.200
    92.629     2.066     0.200
    92.758     2.794     0.200
    93.728     2.628     0.200
    93.961     2.205     0.200
    95.126     2.712     0.200
    95.947     2.769     0.200
    95.810     2.446     0.200
    96.356     1.511     0.200
    96.783     1.776     0.200
    96.787     1.761     0.200
    15.453     5.620     0.200
    15.769     5.793     0.200
    16.138     5.571     0.200
    16.569     3.747     0.200
    17.428     3.954     0.200
    17.718     3.610     0.200
    17.718     3.075     0.200
    18.130    -0.598     0.200
    18.223     0.857     0.200
    18.252     1.116     0.200
    18.269     1.327     0.200
    18.269     1.491     0.200
    18.300    -0.508     0.200
    18.330     0.767     0.200
    18.356     0.505     0.200
    18.356     2.082     0.200
    18.435     1.357     0.200
    18.460     1.450     0.200
    18.460     1.782     0.200
    18.482     0.171     0.200
    18.485     1.539     0.200
    18.500     0.534     0.200
    18.519     0.480     0.200
    18.523     0.318     0.200
    18.586     1.584     0.200
    18.658     0.581     0.200
    18.669     1.491     0.200
    18.824     1.256     0.200
    18.885     1.531     0.200
    18.922     2.091     0.200
    18.936     1.433     0.200
    18.993     1.318     0.200
    19.027     1.650     0.200
    19.044     1.138     0.200
    19.050     0.890     0.200
    19.069     1.331     0.200
    19.069     1.456     0.200
    19.094     1.491     0.200
    19.157     1.426     0.200
    19.286     1.140     0.200
    19.286     1.165     0.200
    19.297     1.169     0.200
    19.297     1.286     0.200
    19.306     1.477     0.200
    19.359     0.736     0.200
    19.367     1.320     0.200
    19.385     1.459     0.200
    19.427     0.695     0.200
    19.436     0.873     0.200
    19.460     0.914     0.200
    19.579     1.990     0.200
    19.585     1.339     0.200
    19.614    -0.136     0.200
    19.641     1.039     0.200
    19.656     1.282     0.200
    19.668     0.989     0.200
    19.668     1.243     0.200
    19.737     1.516     0.200
    19.739     1.072     0.200
    19.780     0.944     0.200
    19.876     0.517     0.200
    19.954     0.956     0.200
    20.026     0.828     0.200
    20.143     1.242     0.200
    20.151     1.199     0.200
    20.151     1.734     0.200
    20.216     1.046     0.200
    20.256     1.559     0.200
    20.270     0.984     0.200
    20.286     1.328     0.200
    20.378     1.517     0.200
    20.423     0.872     0.200
    20.609     0.546     0.200
    20.623     0.612     0.200
    20.784     0.907     0.200
    20.802     1.084     0.200
    20.897     1.293     0.200
    20.933     3.460     0.200
    20.933     3.034     0.200
    20.951     0.766     0.200
    20.993     0.698     0.200
    21.093     0.971     0.200
    21.111     0.640     0.200
    21.247     0.582     0.200
    21.270     0.372     0.200
    21.309     0.879     0.200
    21.374     4.129     0.200
    21.439     0.828     0.200
    21.441     1.430     0.200
    21.516     1.487     0.200
    21.525     1.007     0.200
    21.540     1.179     0.200
    21.612     1.063     0.200
    21.618     0.930     0.200
    21.640     0.849     0.200
    21.650     0.151     0.200
    21.710     1.141     0.200
    21.713     0.547     0.200
    21.762     4.278     0.200
    21.762     4.157     0.200
    21.759     2.677     0.200
    21.759     2.485     0.200
    21.790     0.242     0.200
    21.819     4.180     0.200
    21.819     4.575     0.200
    22.024     1.025     0.200
    22.024     1.857     0.200
    22.080     3.997     0.200
    22.097     0.477     0.200
    22.105     3.142     0.200
    22.105     3.314     0.200
    22.134     3.250     0.200
    22.134     3.125     0.200
    22.176     0.814     0.200
    22.186     0.494     0.200
    22.186     1.191     0.200
    22.209     0.889     0.200
    22.240     0.669     0.200
    22.269     3.470     0.200
    22.283     4.319     0.200
    22.348     0.209     0.200
    22.378     0.890     0.200
    22.397    -0.123     0.200
    22.457     1.746     0.200
    22.457     2.649     0.200
    22.553    -0.691     0.200
    22.558     4.038     0.200
    22.585     0.003     0.200
    22.615    -0.054     0.200
    22.638     4.097     0.200
    22.651     0.900     0.200
    22.660     3.846     0.200
    22.709     1.707     0.200
    22.728     3.985     0.200
    22.731     3.641     0.200
    22.806     0.717     0.200
    22.816     0.280     0.200
    22.817     0.975     0.200
    22.844     2.171     0.200
    22.844     3.257     0.200
    22.852     0.656     0.200
    22.956    -0.038     0.200
    22.989     4.177     0.200
    22.994     2.214     0.200
    23.028     0.102     0.200
    23.073     3.872     0.200
    23.087     1.205     0.200
    23.110    -0.331     0.200
    23.123     3.926     0.200
    23.122     3.235     0.200
    23.128     0.250     0.200
    23.128     0.875     0.200
    23.139     3.104     0.200
    23.139     4.452     0.200
    23.139     3.944     0.200
    23.276    -0.386     0.200
    23.282     2.152     0.200
    23.293     0.672     0.200
    23.320     0.844     0.200
    23.350     0.931     0.200
    23.369     2.051     0.200
    23.412     1.881     0.200
    23.419     0.036     0.200
    23.448     0.505     0.200
    23.458     0.885     0.200
    23.476     4.027     0.200
    23.475    -0.197     0.200
    23.512     2.911     0.200
    23.562     0.158     0.200
    23.590     4.345     0.200
    23.594     0.474     0.200
    23.614     4.111     0.200
    23.707    -0.135     0.200
    23.715     4.108     0.200
    23.746     2.657     0.200
    23.770     0.191     0.200
    23.836     5.252     0.200
    23.849     0.753     0.200
    23.860     4.942     0.200
    23.888     1.671     0.200
    23.899     4.540     0.200
    23.908     3.855     0.200
    23.931     1.358     0.200
    23.959     1.450     0.200
    23.960     1.625     0.200
    24.016     1.666     0.200
    24.046     3.704     0.200
    24.094     6.455     0.200
    24.069     0.389     0.200
    24.077     4.643     0.200
    24.081     1.704     0.200
    24.078     1.488     0.200
    24.079     0.467     0.200
    24.094     4.515     0.200
    24.113     1.518     0.200
    24.237     0.678     0.200
    24.249     4.132     0.200
    24.281     4.252     0.200
    24.278     0.630     0.200
    24.299     4.337     0.200
    24.299     2.715     0.200
    24.323     4.058     0.200
    24.435     4.490     0.200
    24.465     1.194     0.200
    24.469     4.182     0.200
    24.505     5.038     0.200
    24.505     4.401     0.200
    24.540     4.382     0.200
    24.536     2.919     0.200
    24.546     3.324     0.200
    24.587     6.395     0.200
    24.607     2.123     0.200
    24.607     2.315     0.200
    24.620     3.925     0.200
    24.626     4.140     0.200
    24.686     5.896     0.200
    24.675     4.153     0.200
    24.679     1.276     0.200
    24.728     3.272     0.200
    24.728     3.729     0.200
    24.734     4.600     0.200
    24.768     2.035     0.200
    24.803     1.824     0.200
    24.803     1.610     0.200
    24.807     1.655     0.200
    24.867     3.288     0.200
    24.867     3.409     0.200
    24.885     1.308     0.200
    24.893     3.412     0.200
    24.906     3.765     0.200
    24.931     4.080     0.200
    24.932     1.639     0.200
    24.944     3.530     0.200
    24.963     3.958     0.200
    25.032     4.339     0.200
    25.063     7.401     0.200
    25.079     1.090     0.200
    25.105     4.312     0.200
    25.112     4.371     0.200
    25.137     1.449     0.200
    25.137     1.609     0.200
    25.145     4.304     0.200
    25.158     3.565     0.200
    25.184     4.029     0.200
    25.205     2.005     0.200
    25.212     4.225     0.200
    25.212     4.940     0.200
    25.244     1.662     0.200
    25.364     4.264     0.200
    25.367     2.673     0.200
    25.379     4.731     0.200
    25.379     4.453     0.200
    25.379     4.227     0.200
    25.391     1.590     0.200
    25.415     4.137     0.200
    25.424     4.187     0.200
    25.430     4.410     0.200
    25.458     1.741     0.200
    25.540     1.069     0.200
    25.553     1.982     0.200
    25.609     4.590     0.200
    25.644     4.053     0.200
    25.666     1.941     0.200
    25.684     1.269     0.200
    25.738     2.886     0.200
    25.744     4.816     0.200
    25.744     4.449     0.200
    25.814     2.426     0.200
    25.823     0.976     0.200
    25.842     1.835     0.200
    25.895     5.501     0.200
    25.895     3.141     0.200
    25.860     2.138     0.200
    25.866     4.036     0.200
    25.874     2.721     0.200
    25.931     6.105     0.200
    25.936     4.826     0.200
    25.959     3.898     0.200
    25.996     7.983     0.200
    25.981     1.288     0.200
    26.024     4.510     0.200
    26.080     4.486     0.200
    26.078     2.123     0.200
    26.092     0.995     0.200
    26.099     4.559     0.200
    26.099     4.094     0.200
    26.096     0.950     0.200
    26.196     3.980     0.200
    26.233     4.574     0.200
    26.275     4.260     0.200
    26.330     0.533     0.200
    26.347     2.508     0.200
    26.348    -0.015     0.200
    26.363     4.065     0.200
    26.462     4.976     0.200
    26.482     1.690     0.200
    26.522     1.976     0.200
    26.554     1.339     0.200
    26.552     3.158     0.200
    26.555     1.224     0.200
    26.575     1.893     0.200
    26.584     3.465     0.200
    26.586     1.543     0.200
    26.628     2.389     0.200
    26.636     4.100     0.200
    26.672     2.803     0.200
    26.672     3.158     0.200
    26.695     2.686     0.200
    26.732     3.894     0.200
    26.732     0.883     0.200
    26.752     3.392     0.200
    26.804     4.804     0.200
    26.790     0.713     0.200
    26.875     1.166     0.200
    26.908     6.261     0.200
    26.919     3.179     0.200
    27.000     5.913     0.200
    26.974     3.790     0.200
    26.988     1.305     0.200
    27.051     0.985     0.200
    27.072     3.960     0.200
    27.107     1.149     0.200
    27.110     1.606     0.200
    27.146     4.596     0.200
    27.152     1.581     0.200
    27.180     4.118     0.200
    27.221     1.561     0.200
    27.240     1.377     0.200
    27.241     1.506     0.200
    27.242     1.896     0.200
    27.264     2.309     0.200
    27.291     1.350     0.200
    27.300     4.273     0.200
    27.343     0.929     0.200
    27.380     5.379     0.200
    27.398     2.598     0.200
    27.438     3.257     0.200
    27.493     4.709     0.200
    27.510     1.083     0.200
    27.529     3.670     0.200
    27.536     3.412     0.200
    27.536     3.088     0.200
    27.536     3.218     0.200
    27.536     3.101     0.200
    27.571     4.085     0.200
    27.571     4.186     0.200
    27.587     1.548     0.200
    27.634     1.835     0.200
    27.669     3.309     0.200
    27.671     1.440     0.200
    27.710     3.743     0.200
    27.718     1.390     0.200
    27.777     0.377     0.200
    27.843     4.861     0.200
    27.842     1.650     0.200
    27.925     0.986     0.200
    27.928     1.935     0.200
    27.960     2.603     0.200
    27.972     2.540     0.200
    27.974     1.314     0.200
    28.002     2.989     0.200
    28.008     2.509     0.200
    28.071     0.848     0.200
    28.089     0.771     0.200
    28.105     3.662     0.200
    28.212     0.923     0.200
    28.249     4.955     0.200
    28.321     2.180     0.200
    28.321     1.481     0.200
    28.399     1.393     0.200
    28.420     0.694     0.200
    28.454     0.984     0.200
    28.464     3.369     0.200
    28.470     3.870     0.200
    28.467     1.653     0.200
    28.522     3.025     0.200
    28.525     3.823     0.200
    28.556     0.945     0.200
    28.604     1.983     0.200
    28.616     3.532     0.200
    28.641     0.639     0.200
    28.648     3.034     0.200
    28.662     2.629     0.200
    28.690     2.229     0.200
    28.739     0.979     0.200
    28.858     1.430     0.200
    28.858     0.941     0.200
    28.975     3.430     0.200
    29.027     1.606     0.200
    29.037     1.766     0.200
    29.054     0.825     0.200
    29.074     3.638     0.200
    29.087     2.179     0.200
    29.095     0.401     0.200
    29.106     0.488     0.200
    29.111     1.770     0.200
    29.137     0.810     0.200
    29.187     2.105     0.200
    29.221     2.630     0.200
    29.263     1.152     0.200
    29.299     2.050     0.200
    29.324     4.172     0.200
    29.324     4.879     0.200
    29.375     3.033     0.200
    29.385     0.854     0.200
    29.425     4.176     0.200
    29.430     4.648     0.200
    29.450     5.342     0.200
    29.571     1.857     0.200
    29.621     2.759     0.200
    29.647     3.249     0.200
    29.647     3.007     0.200
    29.648     4.380     0.200
    29.688     1.660     0.200
    29.686     4.340     0.200
    29.693     1.353     0.200
    29.709     2.580     0.200
    29.759     1.185     0.200
    29.763     4.134     0.200
    29.767     2.005     0.200
    29.785     0.603     0.200
    29.807     1.925     0.200
    29.818     2.367     0.200
    29.818     1.022     0.200
    29.859     3.918     0.200
    29.859     3.640     0.200
    29.857     0.938     0.200
    29.921     2.233     0.200
    29.937     2.401     0.200
    29.971     4.350     0.200
    29.972     1.400     0.200
    30.011     1.777     0.200
    30.064     1.221     0.200
    30.137     4.895     0.200
    30.229     0.811     0.200
    30.252     0.555     0.200
    30.258     1.131     0.200
    30.288     4.322     0.200
    30.299     1.468     0.200
    30.362     1.019     0.200
    30.371     2.359     0.200
    30.373     3.091     0.200
    30.380     1.380     0.200
    30.383     2.201     0.200
    30.412     4.462     0.200
    30.419     2.287     0.200
    30.423     0.815     0.200
    30.430     0.472     0.200
    30.526     0.765     0.200
    30.571     2.887     0.200
    30.724     0.726     0.200
    30.733     3.825     0.200
    30.726     3.577     0.200
    30.726     3.889     0.200
    30.809     2.008     0.200
    30.804     1.065     0.200
    30.808     4.207     0.200
    30.895     1.697     0.200
    30.934     2.149     0.200
    30.985     1.940     0.200
    30.996     1.420     0.200
    31.008     0.679     0.200
    31.017     3.921     0.200
    31.050     0.218     0.200
    31.073     0.501     0.200
    31.121     2.131     0.200
    31.135     2.334     0.200
    31.148     3.979     0.200
    31.164     2.694     0.200
    31.164     2.428     0.200
    31.147     0.762     0.200
    31.175     3.718     0.200
    31.253     2.460     0.200
    31.256     2.912     0.200
    31.337     0.960     0.200
    31.396     0.931     0.200
    31.466     2.301     0.200
    31.525     0.142     0.200
    31.574     1.201     0.200
    31.581     1.459     0.200
    31.629     1.656     0.200
    31.641     1.364     0.200
    31.644     1.808     0.200
    31.660     2.291     0.200
    31.660     2.220     0.200
    31.666     2.733     0.200
    31.667     2.508     0.200
    31.693     2.452     0.200
    31.712     0.813     0.200
    31.766     2.799     0.200
    31.774     3.357     0.200
    31.799     3.943     0.200
    31.820     0.464     0.200
    31.825     0.747     0.200
    31.860     3.574     0.200
    31.860     1.034     0.200
    32.011     2.571     0.200
    32.117     1.960     0.200
    32.124     2.370     0.200
    32.135     1.923     0.200
    32.140     4.085     0.200
    32.151     1.258     0.200
    32.164     1.229     0.200
    32.198     2.307     0.200
    32.207     2.154     0.200
    32.250     1.432     0.200
    32.289     5.749     0.200
    32.323     2.715     0.200
    32.354     2.472     0.200
    32.400     3.126     0.200
    32.413     3.914     0.200
    32.488     2.927     0.200
    32.488     3.201     0.200
    32.490     0.684     0.200
    32.490     1.285     0.200
    32.540     3.302     0.200
    32.540     3.544     0.200
    32.630     2.767     0.200
    33.071     4.427     0.200
    33.162     2.898     0.200
    33.461     3.468     0.200
    33.461     3.169     0.200
    33.480     3.107     0.200
    33.526     0.930     0.200
    33.587     2.872     0.200
    33.640     2.814     0.200
    33.713     2.744     0.200
    33.720     3.911     0.200
    33.996     3.247     0.200
    34.085     2.465     0.200
    34.124     3.113     0.200
    34.129     3.184     0.200
    34.485     2.231     0.200
    34.520     3.759     0.200
    34.526     2.961     0.200
    34.590     4.497     0.200
    34.602     5.000     0.200
    34.648     3.253     0.200
    34.764     2.300     0.200
    34.774     4.317     0.200
    34.856     3.004     0.200
    34.886     3.867     0.200
    35.032     3.815     0.200
    35.042     3.325     0.200
    35.057     4.414     0.200
    35.136     2.482     0.200
    35.401     3.722     0.200
    35.499     3.574     0.200
    35.535     3.614     0.200
    35.547     4.030     0.200
    35.667     2.366     0.200
    35.696     5.485     0.200
    35.749     2.401     0.200
    35.847     2.690     0.200
    35.913     4.223     0.200
    36.020     4.082     0.200
    36.147     5.325     0.200
    36.233     2.116     0.200
    36.369     1.767     0.200
    36.532     2.210     0.200
    36.620     1.115     0.200
    36.642     3.599     0.200
    36.732     4.084     0.200
    36.789     2.710     0.200
    36.911     3.935     0.200
    37.399     2.947     0.200
    37.665     1.504     0.200
    38.650     3.248     0.200
    42.034     3.073     0.200
    42.118     1.951     0.200
    43.496     0.044     0.200
    44.616     3.634     0.200
    44.770     4.785     0.200
    45.285     1.813     0.200
    45.285     1.688     0.200
    46.549     2.278     0.200
    47.049     1.566     0.200
    47.049     0.359     0.200
    47.114     1.551     0.200
    47.280     2.826     0.200
    47.606     4.999     0.200
    47.892     3.985     0.200
    48.826     4.017     0.200
    52.348     3.261     0.200
    52.957     3.544     0.200
    53.179     3.615     0.200
    53.992     5.517     0.200
    54.773     3.241     0.200
    54.865     4.792     0.200
    55.433     4.952     0.200
    55.621     4.087     0.200
    55.685     4.368     0.200
    55.933     4.165     0.200
    55.955     3.345     0.200
    56.062     2.423     0.200
    56.104     3.382     0.200
    56.157     3.633     0.200
    56.303     3.453     0.200
    56.355     4.012     0.200
    56.504     3.502     0.200
    56.838     3.553     0.200
    57.086     1.945     0.200
    57.129     4.518     0.200
    57.638     3.194     0.200
    57.804     4.534     0.200
    57.810     1.981     0.200
    57.811     2.590     0.200
    57.811     3.141     0.200
    57.840     3.487     0.200
    58.011     1.382     0.200
    58.034     2.919     0.200
    58.078     2.252     0.200
    58.092     3.920     0.200
    58.134     3.006     0.200
    58.231     2.452     0.200
    58.215     2.459     0.200
    58.215     3.068     0.200
    58.248     3.630     0.200
    58.397     3.909     0.200
    58.425     2.931     0.200
    58.457     3.232     0.200
    58.725     2.655     0.200
    58.789     1.685     0.200
    58.937     3.442     0.200
    59.006     2.443     0.200
    59.064     1.952     0.200
    59.064     2.320     0.200
    59.127     2.256     0.200
    59.357     2.878     0.200
    59.669     2.118     0.200
    60.174     1.710     0.200
    60.255     3.372     0.200
    60.542     2.084     0.200
    60.548     2.055     0.200
    62.140     1.793     0.200
    62.898     2.837     0.200
    62.898     3.235     0.200
    64.533     2.595     0.200
    65.449     2.612     0.200
    66.080     4.621     0.200
    66.290     3.601     0.200
    67.581     3.730     0.200
    69.965     1.954     0.200
    71.576     1.360     0.200
    76.395     3.103     0.200
    76.395     2.443     0.200
    79.096     3.466     0.200
    79.885     3.271     0.200
    80.086     2.986     0.200
    80.096     2.535     0.200
    80.296     2.856     0.200
    80.296     2.656     0.200
    80.495     3.388     0.200
    80.640     2.809     0.200
    81.212     2.865     0.200
    82.888     3.274     0.200
    83.139     2.946     0.200
    83.139     3.024     0.200
    83.179     3.137     0.200
    83.518     3.048     0.200
    84.647     3.077     0.200
    84.678     4.018     0.200
    84.826     2.676     0.200
    84.826     3.274     0.200
    85.542     2.398     0.200
    85.646     2.479     0.200
    85.775     3.238     0.200
    86.168     1.501     0.200
    86.168     1.950     0.200
    87.757     4.476     0.200
    88.718     5.330     0.200
    89.025     4.685     0.200
    89.277     1.703     0.200
    89.971     3.256     0.200
    90.046     2.907     0.200
    90.429     3.494     0.200
    90.491     4.836     0.200
    90.717     0.907     0.200
    90.773     2.920     0.200
    91.377     4.322     0.200
    91.581     2.171     0.200
    92.185     3.017     0.200
    92.380     4.497     0.200
    92.709     2.386     0.200
    92.709     1.758     0.200
    93.285     3.407     0.200
    93.322     4.433     0.200
    93.396     2.675     0.200
    93.400     1.477     0.200
    94.052     1.979     0.200
    94.331     3.496     0.200
    94.392     3.693     0.200
    95.606     0.064     0.200
    95.797     0.394     0.200
    96.051     1.637     0.200
    96.222     3.339     0.200
    14.736     6.170     0.200
    15.142     6.801     0.200
    15.415     6.021     0.200
    15.568     4.753     0.200
    15.644     5.397     0.200
    15.943     3.871     0.200
    16.147     4.508     0.200
    16.206     4.722     0.200
    16.325     4.612     0.200
    16.394     4.266     0.200
    16.462     4.498     0.200
    16.488     4.498     0.200
    16.540     3.801     0.200
    16.548     6.784     0.200
    16.574     3.847     0.200
    17.050     3.373     0.200
    17.058     3.496     0.200
    17.082     3.710     0.200
    17.180     3.784     0.200
    17.214     3.179     0.200
    17.227     4.325     0.200
    17.385     2.871     0.200
    17.441     2.843     0.200
    17.828     2.729     0.200
    18.290     4.197     0.200
    18.341     0.730     0.200
    18.332     1.897     0.200
    18.313     4.515     0.200
    18.374     0.554     0.200
    18.374     0.351     0.200
    18.405     1.761     0.200
    18.441     2.718     0.200
    18.526     0.437     0.200
    18.534     1.723     0.200
    18.553     1.087     0.200
    18.629     0.954     0.200
    18.640     2.425     0.200
    18.649     1.498     0.200
    18.666     1.284     0.200
    18.684     2.125     0.200
    18.743     1.366     0.200
    18.742     1.789     0.200
    18.851     1.637     0.200
    18.872     1.859     0.200
    18.939     1.682     0.200
    18.938     1.275     0.200
    18.941     1.415     0.200
    18.941     0.884     0.200
    18.962     1.573     0.200
    18.979     2.882     0.200
    18.979     2.022     0.200
    19.082     1.198     0.200
    19.120     2.015     0.200
    19.154     1.768     0.200
    19.198     1.930     0.200
    19.227     1.112     0.200
    19.227     0.893     0.200
    19.268     1.240     0.200
    19.310     0.914     0.200
    19.339     2.877     0.200
    19.354     1.748     0.200
    19.401     1.583     0.200
    19.416     1.208     0.200
    19.435     1.329     0.200
    19.435     0.634     0.200
    19.459     1.145     0.200
    19.466     1.224     0.200
    19.491     1.046     0.200
    19.537     1.146     0.200
    19.537     1.037     0.200
    19.551     1.068     0.200
    19.585     1.263     0.200
    19.664     0.868     0.200
    19.697     0.738     0.200
    19.708     1.290     0.200
    19.766     0.158     0.200
    19.824     0.640     0.200
    19.935     1.321     0.200
    19.947     0.825     0.200
    19.940     0.716     0.200
    19.996     0.591     0.200
    20.122     1.563     0.200
    20.116     0.783     0.200
    20.131     1.314     0.200
    20.143     0.451     0.200
    20.148     0.843     0.200
    20.191     0.758     0.200
    20.209     1.116     0.200
    20.201     1.373     0.200
    20.275     0.996     0.200
    20.267     3.911     0.200
    20.267     2.684     0.200
    20.341     0.888     0.200
    20.415     0.405     0.200
    20.520     1.190     0.200
    20.520     1.338     0.200
    20.557     0.521     0.200
    20.590     0.704     0.200
    20.594     3.164     0.200
    20.594     2.937     0.200
    20.653     1.741     0.200
    20.739    -0.026     0.200
    20.779     0.492     0.200
    20.806     0.580     0.200
    20.828     0.570     0.200
    20.796     3.750     0.200
    20.895     0.657     0.200
    21.012     1.355     0.200
    21.034     0.529     0.200
    21.080     2.468     0.200
    21.112     0.832     0.200
    21.141     4.273     0.200
    21.141     4.038     0.200
    21.192     0.786     0.200
    21.220     0.631     0.200
    21.243     0.035     0.200
    21.295     3.960     0.200
    21.347     3.645     0.200
    21.366     1.055     0.200
    21.393     0.442     0.200
    21.411     1.066     0.200
    21.397     1.845     0.200
    21.397     1.665     0.200
    21.429     0.306     0.200
    21.447     1.191     0.200
    21.475     3.560     0.200
    21.475     4.365     0.200
    21.540     0.562     0.200
    21.542     0.534     0.200
    21.575     2.596     0.200
    21.635     0.640     0.200
    21.637     3.602     0.200
    21.648     4.454     0.200
    21.678     4.538     0.200
    21.695     2.399     0.200
    21.695     2.656     0.200
    21.732     0.821     0.200
    21.711     2.667     0.200
    21.780     0.980     0.200
    21.814    -0.040     0.200
    21.824     2.131     0.200
    21.935     0.461     0.200
    21.938    -0.022     0.200
    21.938     4.649     0.200
    22.019     1.961     0.200
    21.995     4.518     0.200
    22.010     4.366     0.200
    22.054     0.931     0.200
    22.062     1.754     0.200
    22.089     0.410     0.200
    22.090     1.107     0.200
    22.124     4.237     0.200
    22.155     4.360     0.200
    22.179     0.651     0.200
    22.230     2.796     0.200
    22.253     0.600     0.200
    22.264     1.217     0.200
    22.264     1.342     0.200
    22.267     1.006     0.200
    22.345     1.288     0.200
    22.463     2.784     0.200
    22.507     2.448     0.200
    22.502     3.095     0.200
    22.502     1.657     0.200
    22.499     4.214     0.200
    22.502     4.589     0.200
    22.506     4.477     0.200
    22.506     3.532     0.200
    22.506     4.367     0.200
    22.585     1.999     0.200
    22.565     2.227     0.200
    22.655     0.303     0.200
    22.648     2.228     0.200
    22.685     2.394     0.200
    22.680     1.140     0.200
    22.753     0.976     0.200
    22.803     0.610     0.200
    22.785     5.243     0.200
    22.840    -0.116     0.200
    22.854     0.644     0.200
    22.871     2.893     0.200
    22.951     1.079     0.200
    22.967     0.640     0.200
    22.949     4.052     0.200
    23.056     0.723     0.200
    23.075     2.829     0.200
    23.102     2.686     0.200
    23.149     0.880     0.200
    23.150     0.810     0.200
    23.179     0.244     0.200
    23.188     3.704     0.200
    23.243     0.372     0.200
    23.275     0.479     0.200
    23.297     0.357     0.200
    23.313     0.490     0.200
    23.287     4.475     0.200
    23.328     0.908     0.200
    23.324     3.463     0.200
    23.394     0.044     0.200
    23.374     3.966     0.200
    23.425     3.189     0.200
    23.400     3.591     0.200
    23.400     1.747     0.200
    23.456     0.698     0.200
    23.412     3.464     0.200
    23.481     0.064     0.200
    23.487     0.150     0.200
    23.494     1.005     0.200
    23.496     4.729     0.200
    23.597    -0.128     0.200
    23.675     1.742     0.200
    23.662     3.230     0.200
    23.789     0.780     0.200
    23.806     1.913     0.200
    23.808     1.508     0.200
    23.780     4.049     0.200
    23.819     0.841     0.200
    23.868     1.902     0.200
    23.871    -0.299     0.200
    23.871     4.569     0.200
    23.894     3.881     0.200
    23.894     4.068     0.200
    23.897     4.082     0.200
    23.898     4.041     0.200
    23.963     1.884     0.200
    23.943     3.487     0.200
    23.995     1.203     0.200
    24.055     1.673     0.200
    24.044     2.767     0.200
    24.030     3.797     0.200
    24.083     0.947     0.200
    24.113     1.203     0.200
    24.089     3.539     0.200
    24.183     0.833     0.200
    24.180     4.297     0.200
    24.219     1.677     0.200
    24.241     0.224     0.200
    24.223     3.919     0.200
    24.332     1.130     0.200
    24.299     3.396     0.200
    24.328     3.638     0.200
    24.328     3.872     0.200
    24.357     2.196     0.200
    24.405     1.350     0.200
    24.405     1.233     0.200
    24.429     1.777     0.200
    24.447     2.669     0.200
    24.447     1.779     0.200
    24.460     4.165     0.200
    24.458     4.225     0.200
    24.488     3.084     0.200
    24.522     2.532     0.200
    24.522     3.095     0.200
    24.569     3.464     0.200
    24.569     4.058     0.200
    24.647     1.968     0.200
    24.661     1.136     0.200
    24.666     1.961     0.200
    24.703     1.919     0.200
    24.754     5.097     0.200
    24.769     4.023     0.200
    24.807     1.872     0.200
    24.799     4.873     0.200
    24.827     2.407     0.200
    24.822     4.238     0.200
    24.873     1.880     0.200
    24.902     3.396     0.200
    24.949     1.181     0.200
    24.973     4.721     0.200
    25.040     1.008     0.200
    25.048     2.066     0.200
    25.126     2.061     0.200
    25.119     3.659     0.200
    25.198     1.550     0.200
    25.198     1.245     0.200
    25.190     3.451     0.200
    25.251     2.995     0.200
    25.358     1.928     0.200
    25.392     3.908     0.200
    25.461     2.665     0.200
    25.429     3.785     0.200
    25.431     3.547     0.200
    25.430     4.284     0.200
    25.510     1.045     0.200
    25.548     4.046     0.200
    25.548     4.312     0.200
    25.626     1.748     0.200
    25.604     4.520     0.200
    25.680     3.238     0.200
    25.740     2.316     0.200
    25.777     2.665     0.200
    25.777     2.133     0.200
    25.784     1.794     0.200
    25.845     5.110     0.200
    25.817     5.342     0.200
    25.866     1.721     0.200
    25.880     3.467     0.200
    25.880     3.850     0.200
    25.925     2.713     0.200
    25.961     0.707     0.200
    25.950     4.980     0.200
    25.997     2.446     0.200
    26.019     3.261     0.200
    26.012     3.595     0.200
    26.269     1.050     0.200
    26.271     0.891     0.200
    26.309     3.243     0.200
    26.329     3.044     0.200
    26.329     2.857     0.200
    26.374     2.055     0.200
    26.419     3.229     0.200
    26.542     0.344     0.200
    26.594     3.799     0.200
    26.620     5.463     0.200
    26.703    -0.024     0.200
    26.677     3.350     0.200
    26.712     0.704     0.200
    26.699     5.532     0.200
    26.716     4.012     0.200
    26.814     0.966     0.200
    26.859     1.581     0.200
    26.859     1.276     0.200
    27.014     0.392     0.200
    27.120     2.896     0.200
    27.137     2.880     0.200
    27.137     3.005     0.200
    27.137     3.038     0.200
    27.137     2.920     0.200
    27.184     0.966     0.200
    27.247     3.649     0.200
    27.347     1.046     0.200
    27.330     4.251     0.200
    27.384     2.900     0.200
    27.525     1.057     0.200
    27.570     1.489     0.200
    27.737     0.836     0.200
    27.791     1.959     0.200
    27.831     2.952     0.200
    27.860     1.939     0.200
    27.994     2.203     0.200
    28.049     3.269     0.200
    28.113     3.597     0.200
    28.156     1.434     0.200
    28.194     4.126     0.200
    28.208     2.741     0.200
    28.304     2.132     0.200
    28.316     3.390     0.200
    28.352     2.706     0.200
    28.447     1.986     0.200
    28.442     1.271     0.200
    28.564     2.832     0.200
    28.753     1.389     0.200
    28.801     1.569     0.200
    28.816     2.431     0.200
    28.970     2.575     0.200
    29.275     3.198     0.200
    29.275     3.026     0.200
    29.310     2.086     0.200
    29.312     2.631     0.200
    29.392     3.543     0.200
    29.566     1.837     0.200
    29.799     3.791     0.200
    29.876     1.390     0.200
    29.916     1.097     0.200
    29.928     2.532     0.200
    29.991     1.419     0.200
    29.981     4.364     0.200
    29.999     2.984     0.200
    30.122     2.268     0.200
    30.127     2.042     0.200
    30.190     1.379     0.200
    30.209     1.669     0.200
    30.198     3.763     0.200
    30.213     4.028     0.200
    30.321     3.487     0.200
    30.321     3.612     0.200
    30.386     3.793     0.200
    30.602     2.641     0.200
    30.588     4.170     0.200
    30.648     2.477     0.200
    30.722     0.534     0.200
    30.728     1.271     0.200
    30.760     3.475     0.200
    30.837     1.843     0.200
    31.054     1.380     0.200
    31.264     0.424     0.200
    31.283     2.866     0.200
    31.454     1.706     0.200
    31.454     1.307     0.200
    31.472     2.055     0.200
    31.474     2.348     0.200
    31.502     2.089     0.200
    31.546     1.497     0.200
    31.559     2.433     0.200
    31.585     2.821     0.200
    31.700     1.812     0.200
    31.700     2.694     0.200
    31.734     1.140     0.200
    31.752     0.956     0.200
    31.790     6.210     0.200
    31.931     1.590     0.200
    31.965     1.404     0.200
    31.966     2.010     0.200
    31.984     3.002     0.200
    32.078     2.552     0.200
    32.073     2.424     0.200
    32.078     4.183     0.200
    32.128     1.586     0.200
    32.114     2.882     0.200
    32.114     2.569     0.200
    32.131     3.117     0.200
    32.306     2.035     0.200
    32.315     2.059     0.200
    32.492     3.071     0.200
    32.482     3.753     0.200
    32.614     3.331     0.200
    32.668     2.228     0.200
    32.673     0.115     0.200
    32.742     2.905     0.200
    33.064     3.145     0.200
    33.393     1.753     0.200
    33.393     0.776     0.200
    33.429     3.373     0.200
    34.116     3.295     0.200
    34.361     1.719     0.200
    34.406     2.610     0.200
    34.484     3.345     0.200
    34.978     2.614     0.200
    34.983     3.753     0.200
    35.035     1.531     0.200
    42.819     2.630     0.200
    44.241     1.309     0.200
    45.287     3.727     0.200
    45.287     4.250     0.200
    45.453     1.561     0.200
    46.737     1.176     0.200
    46.775     1.071     0.200
    46.802     1.742     0.200
    47.152     4.531     0.200
    47.152     3.992     0.200
    47.152     4.703     0.200
    49.445     4.698     0.200
    53.507     4.391     0.200
    55.192     4.153     0.200
    55.379     2.716     0.200
    55.688     2.334     0.200
    55.694     4.168     0.200
    55.827     2.719     0.200
    57.181     3.578     0.200
    57.350     2.174     0.200
    57.351     2.486     0.200
    57.351     3.236     0.200
    57.358     2.884     0.200
    57.619     3.278     0.200
    57.940     3.215     0.200
    57.982     3.281     0.200
    58.239     2.724     0.200
    58.441     3.309     0.200
    58.527     2.429     0.200
    58.888     3.023     0.200
    59.144     2.274     0.200
    59.458     1.836     0.200
    59.458     2.258     0.200
    59.813     3.425     0.200
    60.037     1.843     0.200
    65.493     2.569     0.200
    65.493     2.749     0.200
    71.580     0.481     0.200
    75.928     3.297     0.200
    83.616     2.901     0.200
    83.656     3.346     0.200
    85.013     3.168     0.200
    95.014     4.792     0.200
    95.016     2.587     0.200
    15.392     4.336     0.200
    15.553     4.266     0.200
    15.566     7.599     0.200
    16.562     5.543     0.200
    16.617     2.921     0.200
    16.825     3.172     0.200
    16.948     3.865     0.200
    16.948     5.243     0.200
    17.756     2.291     0.200
    18.048     4.372     0.200
    18.047     4.231     0.200
    18.047     3.704     0.200
    18.064     3.206     0.200
    18.200     5.188     0.200
    18.234     1.893     0.200
    18.297     1.876     0.200
    18.384     1.980     0.200
    18.423     2.479     0.200
    18.435     4.383     0.200
    18.484     0.988     0.200
    18.582     1.718     0.200
    18.665     1.612     0.200
    18.691     1.802     0.200
    18.739     1.561     0.200
    18.733     0.685     0.200
    18.795     1.249     0.200
    18.902     1.226     0.200
    18.907     0.045     0.200
    18.969     1.522     0.200
    18.995     1.403     0.200
    19.004     1.313     0.200
    19.047     0.456     0.200
    19.064     1.103     0.200
    19.074     0.242     0.200
    19.165     0.186     0.200
    19.211     0.714     0.200
    19.211     1.710     0.200
    19.279     0.533     0.200
    19.308     0.873     0.200
    19.318     1.426     0.200
    19.400     1.076     0.200
    19.411     2.162     0.200
    19.427    -0.546     0.200
    19.448     1.272     0.200
    19.494     1.906     0.200
    19.515     1.733     0.200
    19.603     0.589     0.200
    19.613     1.173     0.200
    19.691     1.101     0.200
    19.733     0.749     0.200
    19.807     0.571     0.200
    19.819     1.022     0.200
    19.818     0.692     0.200
    19.828     0.294     0.200
    19.855     0.613     0.200
    19.885     2.094     0.200
    19.959     1.632     0.200
    19.983     2.635     0.200
    19.991     0.489     0.200
    20.005     0.184     0.200
    20.081     0.357     0.200
    20.100     0.698     0.200
    20.100    -0.749     0.200
    20.169     0.812     0.200
    20.261     0.524     0.200
    20.314     0.485     0.200
    20.318     0.280     0.200
    20.411     2.640     0.200
    20.530    -0.261     0.200
    20.552     0.781     0.200
    20.579     0.872     0.200
    20.597     1.692     0.200
    20.780     0.581     0.200
    20.803     0.214     0.200
    20.807     0.671     0.200
    20.861     0.233     0.200
    20.993     3.252     0.200
    21.014     0.143     0.200
    21.112     0.581     0.200
    21.120     4.245     0.200
    21.125    -0.361     0.200
    21.185     0.672     0.200
    21.198     2.493     0.200
    21.198     2.828     0.200
    21.254     0.681     0.200
    21.256     3.761     0.200
    21.272     0.029     0.200
    21.272     3.959     0.200
    21.202     0.921     0.200
    21.333     3.834     0.200
    21.359     0.486     0.200
    21.447     1.850     0.200
    21.447     3.383     0.200
    21.449    -0.005     0.200
    21.470     0.804     0.200
    21.472     0.327     0.200
    21.491     2.390     0.200
    21.491     3.356     0.200
    21.508     1.105     0.200
    21.575     0.392     0.200
    21.573     3.611     0.200
    21.614    -0.096     0.200
    21.614     0.917     0.200
    21.614     4.112     0.200
    21.722     0.570     0.200
    21.726     1.166     0.200
    21.726     1.493     0.200
    21.728     0.536     0.200
    21.767     4.034     0.200
    21.780     0.805     0.200
    21.787     1.079     0.200
    21.793    -0.127     0.200
    21.820     4.705     0.200
    21.941     3.564     0.200
    21.939    -0.274     0.200
    22.005     1.331     0.200
    22.032     1.126     0.200
    22.036     2.906     0.200
    22.048    -0.200     0.200
    22.056     0.975     0.200
    22.102     0.379     0.200
    22.132     4.146     0.200
    22.132     3.292     0.200
    22.132     3.945     0.200
    22.136     3.972     0.200
    22.159     4.464     0.200
    22.154     0.998     0.200
    22.243     0.714     0.200
    22.287     0.155     0.200
    22.306     1.621     0.200
    22.323     2.974     0.200
    22.339     0.671     0.200
    22.430     2.730     0.200
    22.438     5.283     0.200
    22.516     3.619     0.200
    22.546     0.184     0.200
    22.569     3.819     0.200
    22.592     1.574     0.200
    22.636     0.334     0.200
    22.709    -0.622     0.200
    22.709    -0.440     0.200
    22.717     0.119     0.200
    22.820    -0.107     0.200
    22.860     3.236     0.200
    22.883     4.249     0.200
    22.889     2.369     0.200
    22.928     0.527     0.200
    22.926     3.396     0.200
    22.951    -0.381     0.200
    22.988     0.284     0.200
    22.999     0.293     0.200
    23.017     3.311     0.200
    23.019     0.378     0.200
    23.047     0.682     0.200
    23.064     3.825     0.200
    23.087     0.797     0.200
    23.144     4.056     0.200
    23.196    -0.045     0.200
    23.210     2.028     0.200
    23.247    -0.150     0.200
    23.263    -0.172     0.200
    23.280     1.198     0.200
    23.293     0.012     0.200
    23.285     3.856     0.200
    23.337     4.452     0.200
    23.369     0.628     0.200
    23.458     1.534     0.200
    23.484     4.986     0.200
    23.491     5.020     0.200
    23.509     0.239     0.200
    23.518     5.282     0.200
    23.534     2.581     0.200
    23.565     3.763     0.200
    23.563     4.178     0.200
    23.563     1.893     0.200
    23.579     0.103     0.200
    23.579     0.653     0.200
    23.646    -0.047     0.200
    23.666     0.136     0.200
    23.680     2.758     0.200
    23.737     0.015     0.200
    23.829     3.150     0.200
    23.867    -0.046     0.200
    23.895     4.012     0.200
    23.914    -0.335     0.200
    23.870     3.597     0.200
    23.926     2.794     0.200
    23.948     0.308     0.200
    24.044    -0.399     0.200
    24.056     2.764     0.200
    24.071     0.065     0.200
    24.066     2.008     0.200
    24.103     1.723     0.200
    24.103     3.202     0.200
    24.110     0.251     0.200
    24.099     2.476     0.200
    24.135    -0.078     0.200
    24.188     2.971     0.200
    24.207    -0.146     0.200
    24.229     4.447     0.200
    24.333     1.639     0.200
    24.333     2.921     0.200
    24.373     1.085     0.200
    24.373     2.750     0.200
    24.360     0.923     0.200
    24.364     0.402     0.200
    24.374     0.417     0.200
    24.432     0.642     0.200
    24.460     4.881     0.200
    24.509     0.328     0.200
    24.596     1.198     0.200
    24.595     3.308     0.200
    24.607     1.004     0.200
    24.624     1.707     0.200
    24.646     2.156     0.200
    24.674     0.459     0.200
    24.680     3.921     0.200
    24.684     0.605     0.200
    24.749     4.124     0.200
    24.784     1.044     0.200
    24.860     1.104     0.200
    24.903     1.625     0.200
    24.976     2.323     0.200
    25.008     1.915     0.200
    25.044     4.483     0.200
    25.077     1.687     0.200
    25.070     4.174     0.200
    25.082     4.226     0.200
    25.120     3.938     0.200
    25.189     2.014     0.200
    25.227     3.548     0.200
    25.227     4.344     0.200
    25.232     4.135     0.200
    25.158     3.633     0.200
    25.258     1.306     0.200
    25.258     0.972     0.200
    25.279     1.376     0.200
    25.225     0.199     0.200
    25.321     1.744     0.200
    25.321     0.951     0.200
    25.344     2.711     0.200
    25.412     1.145     0.200
    25.437     1.796     0.200
    25.434     4.333     0.200
    25.555     2.515     0.200
    25.602     3.156     0.200
    25.602     3.357     0.200
    25.595     3.763     0.200
    25.615     1.350     0.200
    25.630     2.451     0.200
    25.638     1.316     0.200
    25.648     1.998     0.200
    25.643     3.486     0.200
    25.820     1.677     0.200
    25.868     1.385     0.200
    25.868     1.742     0.200
    25.936     1.136     0.200
    25.962     0.863     0.200
    26.103     0.527     0.200
    26.140     1.386     0.200
    26.140     2.831     0.200
    26.223     0.901     0.200
    26.258     0.613     0.200
    26.302     0.472     0.200
    26.308     0.293     0.200
    26.320     3.766     0.200
    26.347     0.833     0.200
    26.344     3.250     0.200
    26.359     1.755     0.200
    26.423     3.044     0.200
    26.426     1.427     0.200
    26.517     2.202     0.200
    26.553     1.096     0.200
    26.575     1.468     0.200
    26.598     1.245     0.200
    26.688     0.929     0.200
    26.724     0.791     0.200
    26.800     0.495     0.200
    26.803     0.738     0.200
    26.803     1.338     0.200
    26.862     5.245     0.200
    26.913     3.200     0.200
    26.913     2.626     0.200
    26.913     2.646     0.200
    26.913     2.476     0.200
    26.909     2.209     0.200
    26.968     2.253     0.200
    26.981     4.031     0.200
    27.014     2.400     0.200
    27.025     2.420     0.200
    27.097     1.624     0.200
    27.111     1.483     0.200
    27.061     5.115     0.200
    27.182     1.925     0.200
    27.194     1.349     0.200
    27.231     2.409     0.200
    27.303     5.319     0.200
    27.365     2.406     0.200
    27.412     2.158     0.200
    27.419     2.992     0.200
    27.488     1.709     0.200
    27.501     2.294     0.200
    27.497     3.989     0.200
    27.510     2.112     0.200
    27.547     4.884     0.200
    27.634     1.350     0.200
    27.731     2.243     0.200
    27.728     1.846     0.200
    27.736     2.158     0.200
    27.812     2.049     0.200
    27.813     1.936     0.200
    27.814     5.200     0.200
    27.958     1.856     0.200
    27.959     3.327     0.200
    27.971     2.038     0.200
    27.977     2.937     0.200
    28.155     4.741     0.200
    28.176     2.104     0.200
    28.245     2.303     0.200
    28.267     1.731     0.200
    28.331     2.964     0.200
    28.355     2.421     0.200
    28.266     6.228     0.200
    28.462     4.373     0.200
    28.618     5.856     0.200
    28.643     4.572     0.200
    28.643     4.862     0.200
    28.782     4.913     0.200
    28.807     2.483     0.200
    28.920     2.845     0.200
    29.066     3.087     0.200
    29.066     2.745     0.200
    29.123     3.552     0.200
    29.123     3.689     0.200
    29.169     1.864     0.200
    29.179     4.834     0.200
    29.286     2.532     0.200
    29.371     2.793     0.200
    29.506     1.613     0.200
    29.517     3.782     0.200
    29.521     1.838     0.200
    29.571     1.730     0.200
    29.605     1.836     0.200
    29.668     2.299     0.200
    29.703     2.774     0.200
    29.749     1.505     0.200
    29.862     3.410     0.200
    30.076     1.002     0.200
    30.146     3.718     0.200
    30.251     1.577     0.200
    30.260     4.189     0.200
    30.401     1.585     0.200
    30.726     0.486     0.200
    30.757     2.307     0.200
    30.757     2.135     0.200
    30.761     0.824     0.200
    30.943     3.309     0.200
    31.019     1.705     0.200
    31.049     1.945     0.200
    31.242     1.493     0.200
    31.301     2.733     0.200
    31.326     4.652     0.200
    31.394     1.805     0.200
    31.397     1.820     0.200
    31.397     1.206     0.200
    31.437     2.109     0.200
    31.699     1.687     0.200
    31.708     1.867     0.200
    31.871     2.477     0.200
    31.931     2.356     0.200
    31.960     1.725     0.200
    32.075     1.906     0.200
    32.146     3.580     0.200
    32.217     2.747     0.200
    32.358     2.480     0.200
    32.488     1.427     0.200
    32.604     2.985     0.200
    32.805     0.857     0.200
    33.015     2.038     0.200
    33.020     5.431     0.200
    33.095     3.685     0.200
    33.333     0.640     0.200
    34.146     3.094     0.200
    34.163     3.565     0.200
    34.611     3.557     0.200
    35.001     3.044     0.200
    35.299     5.098     0.200
    36.604     3.556     0.200
    37.598     1.689     0.200
    39.060     3.921     0.200
    43.296     2.092     0.200
    44.692     1.110     0.200
    45.572     0.843     0.200
    45.692     4.066     0.200
    45.692     4.424     0.200
    46.562     1.416     0.200
    46.889     4.499     0.200
    50.205     3.904     0.200
    54.076     3.163     0.200
    54.903     4.604     0.200
    55.123     2.688     0.200
    55.423     3.763     0.200
    55.474     2.322     0.200
    56.268     2.972     0.200
    56.883     3.738     0.200
    56.902     2.938     0.200
    57.077     3.364     0.200
    57.082     2.226     0.200
    57.082     2.884     0.200
    57.082     2.785     0.200
    57.277     3.287     0.200
    57.309     3.342     0.200
    57.316     3.295     0.200
    57.343     2.360     0.200
    57.352     2.638     0.200
    57.656     3.384     0.200
    57.665     2.629     0.200
    58.150     3.781     0.200
    58.350     2.173     0.200
    58.835     2.129     0.200
    59.556     2.708     0.200
    59.740     1.921     0.200
    59.746     1.830     0.200
    59.860     1.339     0.200
    60.114     2.700     0.200
    63.667     2.762     0.200
    65.535     1.560     0.200
    71.597     0.807     0.200
    83.917     2.410     0.200
    85.421     3.426     0.200
    85.627     2.475     0.200
    93.053     2.014     0.200
    15.327     6.705     0.200
    15.965     3.930     0.200
    15.965     5.450     0.200
    16.195     6.128     0.200
    16.341     6.193     0.200
    17.578     3.596     0.200
    17.618     3.682     0.200
    18.450     1.588     0.200
    18.611     0.633     0.200
    18.611     0.289     0.200
    18.752     0.456     0.200
    18.901     1.685     0.200
    19.162     1.723     0.200
    19.182     1.747     0.200
    19.209     0.899     0.200
    19.223     1.735     0.200
    19.223     1.974     0.200
    19.328     1.582     0.200
    19.354     2.399     0.200
    19.397     1.713     0.200
    19.415     1.372     0.200
    19.499     0.789     0.200
    19.499     1.211     0.200
    19.562     1.627     0.200
    19.571     1.350     0.200
    19.574     0.229     0.200
    19.579     1.014     0.200
    19.632     0.808     0.200
    19.648     1.182     0.200
    19.659     1.882     0.200
    19.690     0.749     0.200
    19.711     1.900     0.200
    19.711     1.791     0.200
    19.806     0.520     0.200
    19.808    -0.158     0.200
    19.830     1.039     0.200
    19.836     1.596     0.200
    19.873     0.804     0.200
    19.875     0.945     0.200
    19.948     0.372     0.200
    19.945     0.433     0.200
    19.945     1.613     0.200
    19.981     1.243     0.200
    19.989     0.317     0.200
    19.997     0.581     0.200
    20.089     0.644     0.200
    20.160     0.970     0.200
    20.173     0.566     0.200
    20.190     2.023     0.200
    20.253     0.100     0.200
    20.315     1.228     0.200
    20.324     0.950     0.200
    20.388     0.513     0.200
    20.399     0.916     0.200
    20.406     0.297     0.200
    20.429    -0.060     0.200
    20.439     0.708     0.200
    20.512     0.857     0.200
    20.539     0.594     0.200
    20.609     0.119     0.200
    20.618     0.199     0.200
    20.659     2.970     0.200
    20.749     0.393     0.200
    20.758     0.170     0.200
    20.822     0.259     0.200
    20.848     0.870     0.200
    20.905     0.460     0.200
    20.928     0.130     0.200
    20.956     0.318     0.200
    20.953     3.328     0.200
    20.997     7.467     0.200
    21.026     0.017     0.200
    21.131     0.043     0.200
    21.178     0.392     0.200
    21.198     4.043     0.200
    21.309     0.365     0.200
    21.323     0.163     0.200
    21.341     0.247     0.200
    21.349     0.630     0.200
    21.447     0.538     0.200
    21.459     0.594     0.200
    21.499     0.555     0.200
    21.545    -0.192     0.200
    21.545     4.985     0.200
    21.586    -0.335     0.200
    21.603     0.978     0.200
    21.620    -0.357     0.200
    21.628     0.359     0.200
    21.678     0.118     0.200
    21.691     3.717     0.200
    21.705     0.596     0.200
    21.761     2.303     0.200
    21.761     2.713     0.200
    21.779     0.888     0.200
    21.806     0.670     0.200
    21.824     1.340     0.200
    21.861    -0.328     0.200
    21.879     4.163     0.200
    21.911     1.141     0.200
    21.927     0.354     0.200
    21.962     0.909     0.200
    21.988    -0.104     0.200
    21.988     0.056     0.200
    22.038     0.730     0.200
    22.051     4.293     0.200
    22.077     3.105     0.200
    22.081     3.913     0.200
    22.083     2.735     0.200
    22.083     3.637     0.200
    22.094     0.221     0.200
    22.142     1.065     0.200
    22.162     0.208     0.200
    22.337     0.415     0.200
    22.342     3.307     0.200
    22.372     0.321     0.200
    22.402     0.973     0.200
    22.398     3.430     0.200
    22.441     0.292     0.200
    22.480    -0.425     0.200
    22.493     0.484     0.200
    22.521     2.028     0.200
    22.527     3.921     0.200
    22.538     0.513     0.200
    22.553     1.209     0.200
    22.556     3.581     0.200
    22.727     0.541     0.200
    22.749     0.121     0.200
    22.824     1.095     0.200
    22.842     1.552     0.200
    22.856     1.983     0.200
    22.862     0.039     0.200
    22.860     3.757     0.200
    22.875     0.750     0.200
    22.906     4.334     0.200
    22.907     3.118     0.200
    22.910     3.046     0.200
    22.945     2.456     0.200
    23.023     0.613     0.200
    23.048     0.853     0.200
    23.063     2.606     0.200
    23.131     0.546     0.200
    23.188     5.455     0.200
    23.208     1.244     0.200
    23.226     1.518     0.200
    23.275     3.130     0.200
    23.318     1.732     0.200
    23.315     2.244     0.200
    23.322    -0.549     0.200
    23.353     3.712     0.200
    23.383     1.587     0.200
    23.427     0.296     0.200
    23.449     1.353     0.200
    23.456     3.288     0.200
    23.477     2.293     0.200
    23.471     3.753     0.200
    23.501     0.205     0.200
    23.517     1.488     0.200
    23.517     1.875     0.200
    23.525    -0.016     0.200
    23.537    -0.235     0.200
    23.619     1.028     0.200
    23.635     3.795     0.200
    23.690     3.503     0.200
    23.703     0.373     0.200
    23.723     0.893     0.200
    23.762     0.528     0.200
    23.761     2.813     0.200
    23.772     3.934     0.200
    23.812     0.447     0.200
    23.865    -0.399     0.200
    23.899     4.234     0.200
    23.918     0.607     0.200
    23.996     0.911     0.200
    24.032     0.543     0.200
    24.066     3.758     0.200
    24.173     4.335     0.200
    24.216     0.456     0.200
    24.268     4.522     0.200
    24.282     0.174     0.200
    24.297     3.268     0.200
    24.299     4.235     0.200
    24.306     1.112     0.200
    24.327     1.425     0.200
    24.377     1.204     0.200
    24.379     2.395     0.200
    24.395     1.399     0.200
    24.416     0.967     0.200
    24.416     1.748     0.200
    24.433     3.574     0.200
    24.475     2.886     0.200
    24.566     1.048     0.200
    24.572     2.941     0.200
    24.637     0.838     0.200
    24.689     1.714     0.200
    24.703     4.173     0.200
    24.702     2.688     0.200
    24.702     2.090     0.200
    24.736     0.951     0.200
    24.844     3.407     0.200
    24.873     3.726     0.200
    24.883     2.937     0.200
    24.883     3.484     0.200
    24.884     3.816     0.200
    24.913     1.508     0.200
    24.929     4.263     0.200
    24.967     0.573     0.200
    25.120     1.658     0.200
    25.141     2.246     0.200
    25.172     4.123     0.200
    25.202     4.388     0.200
    25.226     3.844     0.200
    25.264     1.562     0.200
    25.301     1.134     0.200
    25.298     3.891     0.200
    25.376     4.113     0.200
    25.418     1.168     0.200
    25.418     1.430     0.200
    25.441     4.561     0.200
    25.460     1.607     0.200
    25.503     1.191     0.200
    25.522     5.220     0.200
    25.522     6.092     0.200
    25.559     0.681     0.200
    25.633     1.823     0.200
    25.641     1.757     0.200
    25.672     3.885     0.200
    25.781     3.997     0.200
    25.833     4.068     0.200
    25.837     1.673     0.200
    25.949     2.725     0.200
    25.948     4.028     0.200
    25.948     4.665     0.200
    25.996     1.689     0.200
    26.008     4.374     0.200
    26.188     1.227     0.200
    26.270     4.251     0.200
    26.270     4.142     0.200
    26.311     3.969     0.200
    26.327     1.930     0.200
    26.416     3.970     0.200
    26.482     1.448     0.200
    26.482     1.995     0.200
    26.540     0.836     0.200
    26.571     3.706     0.200
    26.689     2.708     0.200
    26.689     3.677     0.200
    26.806     2.516     0.200
    26.984     2.505     0.200
    27.061     3.372     0.200
    27.103     4.028     0.200
    27.147     1.074     0.200
    27.153     0.999     0.200
    27.153     2.359     0.200
    27.313     4.988     0.200
    27.389     4.369     0.200
    27.389     5.115     0.200
    27.507     0.726     0.200
    27.511     2.696     0.200
    27.511     3.161     0.200
    27.511     2.849     0.200
    27.511     2.958     0.200
    27.625     3.915     0.200
    27.634     3.802     0.200
    27.729     2.499     0.200
    27.729     3.292     0.200
    27.744     4.469     0.200
    27.843     1.406     0.200
    27.999     0.994     0.200
    28.272     2.494     0.200
    28.426     3.535     0.200
    28.489     3.619     0.200
    28.575     0.977     0.200
    28.572     3.307     0.200
    28.619     1.227     0.200
    28.729     3.374     0.200
    28.749     3.059     0.200
    28.844     4.069     0.200
    28.941     3.335     0.200
    29.000     4.374     0.200
    29.505     3.928     0.200
    29.510     2.066     0.200
    29.531     4.924     0.200
    29.642     2.887     0.200
    29.642     3.055     0.200
    29.657     3.224     0.200
    29.690     2.124     0.200
    29.779     2.889     0.200
    29.779     3.842     0.200
    29.798     1.659     0.200
    29.937     0.930     0.200
    30.059     0.248     0.200
    30.159     0.880     0.200
    30.313     2.302     0.200
    30.362     4.249     0.200
    30.587     1.970     0.200
    30.696     3.442     0.200
    30.765     4.112     0.200
    31.138     3.403     0.200
    31.142     1.228     0.200
    31.685     3.232     0.200
    31.748     1.332     0.200
    31.748     1.566     0.200
    31.800     1.671     0.200
    32.040     1.648     0.200
    32.097     2.891     0.200
    32.110     2.465     0.200
    32.179     3.418     0.200
    32.323     1.360     0.200
    32.494     2.604     0.200
    32.494     3.503     0.200
    32.882     2.786     0.200
    33.008     3.443     0.200
    33.418     3.030     0.200
    33.690     0.767     0.200
    34.023     1.811     0.200
    34.865     0.248     0.200
    35.236     6.335     0.200
    35.272     6.205     0.200
    38.111     1.820     0.200
    45.627     1.363     0.200
    47.090     1.212     0.200
    56.057     2.570     0.200
    57.738     2.855     0.200
    57.738     2.816     0.200
    60.741     2.117     0.200
    15.570     5.434     0.200
    15.570     5.700     0.200
    15.743     4.656     0.200
    16.058     4.475     0.200
    16.058     5.018     0.200
    16.438     5.021     0.200
    16.997     4.424     0.200
    17.342     3.827     0.200
    17.342     4.464     0.200
    17.858     4.116     0.200
    18.394     1.535     0.200
    18.438     0.887     0.200
    18.438     1.019     0.200
    18.570     1.139     0.200
    18.586     0.971     0.200
    18.616     0.952     0.200
    18.616     1.510     0.200
    18.959     0.580     0.200
    18.999     1.329     0.200
    19.004     1.605     0.200
    19.004     2.066     0.200
    19.127     1.607     0.200
    19.166     1.128     0.200
    19.249     2.209     0.200
    19.272     1.228     0.200
    19.275     1.028     0.200
    19.275     0.391     0.200
    19.292     0.524     0.200
    19.292     2.911     0.200
    19.301     1.233     0.200
    19.301     1.752     0.200
    19.309     0.797     0.200
    19.398     1.512     0.200
    19.488     2.323     0.200
    19.494     1.881     0.200
    19.513     1.451     0.200
    19.513     1.916     0.200
    19.543     1.302     0.200
    19.598     1.457     0.200
    19.603     0.805     0.200
    19.676     2.308     0.200
    19.676     2.058     0.200
    19.707     1.953     0.200
    19.707     1.848     0.200
    19.721     1.274     0.200
    19.721     1.797     0.200
    19.791     0.555     0.200
    19.791     1.364     0.200
    19.811     0.945     0.200
    19.811     0.519     0.200
    19.969     1.512     0.200
    19.969     1.770     0.200
    20.008     2.654     0.200
    20.021     1.674     0.200
    20.033     0.407     0.200
    20.071     1.789     0.200
    20.068     0.596     0.200
    20.101     1.487     0.200
    20.110     1.449     0.200
    20.110     1.922     0.200
    20.110     1.472     0.200
    20.110     1.230     0.200
    20.199     0.755     0.200
    20.215     1.911     0.200
    20.262     1.983     0.200
    20.255     1.463     0.200
    20.338     1.608     0.200
    20.338     1.924     0.200
    20.430     1.979     0.200
    20.427     1.439     0.200
    20.445     1.394     0.200
    20.445     1.707     0.200
    20.452     1.475     0.200
    20.446     2.335     0.200
    20.446     1.784     0.200
    20.458     1.872     0.200
    20.531     1.782     0.200
    20.564     1.740     0.200
    20.571     0.079     0.200
    20.613     1.015     0.200
    20.613     1.671     0.200
    20.655     1.173     0.200
    20.655     1.860     0.200
    20.616     3.099     0.200
    20.688     1.059     0.200
    20.688     1.676     0.200
    20.697     2.935     0.200
    20.722     1.494     0.200
    20.780     0.924     0.200
    20.815     0.958     0.200
    20.857     3.058     0.200
    20.864     3.946     0.200
    20.903     1.645     0.200
    20.913     0.652     0.200
    20.924     1.068     0.200
    20.924     1.850     0.200
    20.948     1.768     0.200
    21.009     5.777     0.200
    21.009     3.196     0.200
    21.045     3.107     0.200
    21.060     2.406     0.200
    21.057     0.726     0.200
    21.123     1.338     0.200
    21.171     2.408     0.200
    21.209     0.940     0.200
    21.244     1.700     0.200
    21.239     2.156     0.200
    21.262     4.614     0.200
    21.262     4.193     0.200
    21.265     5.529     0.200
    21.384     1.459     0.200
    21.396     3.097     0.200
    21.400     1.133     0.200
    21.413     4.458     0.200
    21.413     5.001     0.200
    21.417     0.490     0.200
    21.448     1.224     0.200
    21.502     2.731     0.200
    21.502     3.336     0.200
    21.567     0.981     0.200
    21.567     1.453     0.200
    21.564     5.210     0.200
    21.601     0.548     0.200
    21.620     0.999     0.200
    21.658     0.644     0.200
    21.724     2.847     0.200
    21.698     2.775     0.200
    21.732     0.701     0.200
    21.759     4.261     0.200
    21.769     4.235     0.200
    21.799     3.562     0.200
    21.807     3.183     0.200
    21.807     3.675     0.200
    21.799     0.527     0.200
    21.819     3.078     0.200
    21.858     0.933     0.200
    21.858     0.015     0.200
    21.886     5.046     0.200
    21.914     1.307     0.200
    21.914     1.783     0.200
    21.911     1.222     0.200
    21.932     0.300     0.200
    21.932     1.077     0.200
    21.953     1.306     0.200
    21.953     0.264     0.200
    21.972     0.838     0.200
    21.972     2.752     0.200
    21.972     3.131     0.200
    21.974     0.217     0.200
    21.974     0.725     0.200
    21.986     0.953     0.200
    22.016     0.356     0.200
    22.016     1.095     0.200
    22.027     0.478     0.200
    22.060     4.184     0.200
    22.116     3.991     0.200
    22.132     4.510     0.200
    22.113     4.989     0.200
    22.200     0.289     0.200
    22.207     1.049     0.200
    22.244     3.878     0.200
    22.276     1.753     0.200
    22.276     2.624     0.200
    22.269     0.405     0.200
    22.344     0.859     0.200
    22.371     0.264     0.200
    22.407     3.433     0.200
    22.427    -0.085     0.200
    22.489     1.287     0.200
    22.523     1.195     0.200
    22.544     3.476     0.200
    22.512     4.855     0.200
    22.556     1.599     0.200
    22.569     1.143     0.200
    22.606     2.437     0.200
    22.623     3.649     0.200
    22.628     4.480     0.200
    22.628     4.332     0.200
    22.632     0.500     0.200
    22.675     0.689     0.200
    22.670     0.733     0.200
    22.732     1.078     0.200
    22.746     0.696     0.200
    22.792     3.088     0.200
    22.829     0.047     0.200
    22.873     2.988     0.200
    22.915     1.171     0.200
    22.992     3.331     0.200
    23.010     1.268     0.200
    23.070     3.439     0.200
    23.089    -0.584     0.200
    23.186     3.282     0.200
    23.183     0.569     0.200
    23.209     3.281     0.200
    23.230    -0.394     0.200
    23.230     1.962     0.200
    23.244     2.061     0.200
    23.285     0.532     0.200
    23.306     4.775     0.200
    23.285     3.638     0.200
    23.353     4.202     0.200
    23.361     2.492     0.200
    23.391     1.963     0.200
    23.392     2.891     0.200
    23.396     1.377     0.200
    23.408     3.614     0.200
    23.422     0.697     0.200
    23.441     5.266     0.200
    23.460     0.196     0.200
    23.504     2.737     0.200
    23.503     1.979     0.200
    23.530     0.690     0.200
    23.534     2.887     0.200
    23.578     1.427     0.200
    23.591     1.207     0.200
    23.616     3.519     0.200
    23.655     1.374     0.200
    23.655     2.225     0.200
    23.686     0.942     0.200
    23.682     2.612     0.200
    23.713     3.671     0.200
    23.784     3.882     0.200
    23.783     1.006     0.200
    23.812     2.732     0.200
    23.815     1.741     0.200
    23.815     3.144     0.200
    23.824     3.840     0.200
    23.834     3.966     0.200
    23.846     0.866     0.200
    23.885     1.846     0.200
    23.944     0.377     0.200
    23.952     2.507     0.200
    24.015     3.820     0.200
    24.064     4.760     0.200
    24.055     2.889     0.200
    24.139     2.305     0.200
    24.151     3.514     0.200
    24.164     1.533     0.200
    24.193     1.926     0.200
    24.202     3.597     0.200
    24.197     1.475     0.200
    24.211     4.710     0.200
    24.213     1.398     0.200
    24.251     1.430     0.200
    24.251     1.922     0.200
    24.285     0.927     0.200
    24.285     1.521     0.200
    24.296     4.828     0.200
    24.337     1.425     0.200
    24.349     1.178     0.200
    24.354     0.152     0.200
    24.421     3.332     0.200
    24.423     1.832     0.200
    24.437     3.387     0.200
    24.488     4.116     0.200
    24.495     2.270     0.200
    24.514     1.600     0.200
    24.532     2.132     0.200
    24.580     4.463     0.200
    24.593     1.365     0.200
    24.601     3.323     0.200
    24.610     4.170     0.200
    24.626     2.747     0.200
    24.647     4.105     0.200
    24.646     1.758     0.200
    24.646     1.375     0.200
    24.679     1.198     0.200
    24.641     5.956     0.200
    24.690     3.719     0.200
    24.690     4.418     0.200
    24.728     2.094     0.200
    24.769     5.411     0.200
    24.822     0.975     0.200
    24.822     1.487     0.200
    24.868     1.545     0.200
    24.876     3.945     0.200
    24.890     4.316     0.200
    24.919     4.284     0.200
    24.930     3.324     0.200
    24.935     1.943     0.200
    24.935     2.533     0.200
    24.943     4.081     0.200
    24.957     0.726     0.200
    24.957     0.976     0.200
    24.986     1.852     0.200
    24.995     1.855     0.200
    25.038     1.710     0.200
    25.076     1.926     0.200
    25.094     4.149     0.200
    25.112     1.014     0.200
    25.119     1.090     0.200
    25.121     1.620     0.200
    25.082     4.540     0.200
    25.152     0.886     0.200
    25.198     1.218     0.200
    25.205     4.194     0.200
    25.216     1.621     0.200
    25.240     4.656     0.200
    25.240     1.534     0.200
    25.256     0.663     0.200
    25.264     2.311     0.200
    25.326     2.278     0.200
    25.378     1.835     0.200
    25.453     6.111     0.200
    25.541     2.140     0.200
    25.550     4.512     0.200
    25.552     4.314     0.200
    25.552     3.911     0.200
    25.563     1.464     0.200
    25.525     6.521     0.200
    25.581     1.391     0.200
    25.627     0.977     0.200
    25.653     3.116     0.200
    25.648     1.635     0.200
    25.664     0.732     0.200
    25.667     4.220     0.200
    25.667     4.396     0.200
    25.661     0.662     0.200
    25.661     2.744     0.200
    25.686     0.756     0.200
    25.686     2.478     0.200
    25.725     4.396     0.200
    25.750     1.222     0.200
    25.735     6.445     0.200
    25.812     0.957     0.200
    25.815     1.940     0.200
    25.814     1.582     0.200
    25.828     1.384     0.200
    25.828     2.247     0.200
    25.798     4.432     0.200
    25.853     3.600     0.200
    25.860     1.554     0.200
    25.938     4.974     0.200
    25.995     4.359     0.200
    26.049     1.542     0.200
    26.051     1.978     0.200
    26.071     4.331     0.200
    26.037     2.998     0.200
    26.037     5.029     0.200
    26.072     5.786     0.200
    26.126     2.158     0.200
    26.145     1.854     0.200
    26.162     2.289     0.200
    26.201     1.537     0.200
    26.221     2.089     0.200
    26.227     4.328     0.200
    26.253     1.485     0.200
    26.252     4.728     0.200
    26.334     1.923     0.200
    26.318     7.726     0.200
    26.396     1.960     0.200
    26.397     1.615     0.200
    26.405     1.176     0.200
    26.433     3.024     0.200
    26.382     4.945     0.200
    26.470     0.505     0.200
    26.485     0.178     0.200
    26.490     2.135     0.200
    26.489     2.100     0.200
    26.513     0.978     0.200
    26.561     4.783     0.200
    26.621     1.861     0.200
    26.622     0.417     0.200
    26.601     6.899     0.200
    26.722     1.721     0.200
    26.726     1.253     0.200
    26.750     0.954     0.200
    26.754     1.013     0.200
    26.754     1.798     0.200
    26.753     1.903     0.200
    26.788     1.080     0.200
    26.786     1.661     0.200
    26.819     4.862     0.200
    26.830     3.355     0.200
    26.842     5.988     0.200
    26.920     2.389     0.200
    26.941     1.829     0.200
    26.939     1.547     0.200
    26.937     3.529     0.200
    26.930     5.975     0.200
    27.014     1.963     0.200
    27.032     0.790     0.200
    27.031     1.261     0.200
    26.993     6.156     0.200
    26.999     7.023     0.200
    27.054     6.046     0.200
    27.107     5.002     0.200
    27.107     4.302     0.200
    27.161     1.926     0.200
    27.169     2.064     0.200
    27.142     2.453     0.200
    27.185     1.255     0.200
    27.185     0.759     0.200
    27.207     2.149     0.200
    27.194     1.263     0.200
    27.229     0.823     0.200
    27.246     2.854     0.200
    27.246     3.202     0.200
    27.246     3.074     0.200
    27.246     3.226     0.200
    27.309     1.202     0.200
    27.311     1.294     0.200
    27.272     6.751     0.200
    27.329     1.374     0.200
    27.347     1.867     0.200
    27.379     2.113     0.200
    27.379     1.683     0.200
    27.386     0.707     0.200
    27.429     1.034     0.200
    27.446     4.259     0.200
    27.463     1.682     0.200
    27.400     6.054     0.200
    27.400     6.929     0.200
    27.483     2.278     0.200
    27.483     3.012     0.200
    27.491     0.962     0.200
    27.512     1.222     0.200
    27.462     6.103     0.200
    27.541     1.115     0.200
    27.541     2.647     0.200
    27.552     1.210     0.200
    27.552     1.729     0.200
    27.560     1.444     0.200
    27.560     1.889     0.200
    27.615     2.139     0.200
    27.687     3.537     0.200
    27.686     1.362     0.200
    27.686     1.690     0.200
    27.680     5.196     0.200
    27.748     1.537     0.200
    27.769     4.421     0.200
    27.806     2.303     0.200
    27.812     2.168     0.200
    27.828     0.941     0.200
    27.850     1.886     0.200
    27.866     1.935     0.200
    27.830     4.773     0.200
    27.919     0.559     0.200
    27.922     1.010     0.200
    27.977     0.776     0.200
    27.979     3.942     0.200
    27.940     5.643     0.200
    27.992     4.864     0.200
    28.042     1.576     0.200
    28.078     3.155     0.200
    28.078     3.581     0.200
    28.057     6.359     0.200
    28.188     0.806     0.200
    28.212     0.445     0.200
    28.222     3.313     0.200
    28.216     1.655     0.200
    28.216     1.808     0.200
    28.232     1.465     0.200
    28.230     1.608     0.200
    28.281     4.921     0.200
    28.304     2.422     0.200
    28.311     1.285     0.200
    28.311     1.649     0.200
    28.317     2.960     0.200
    28.325     0.600     0.200
    28.355     1.606     0.200
    28.355     1.716     0.200
    28.308     5.072     0.200
    28.376     1.945     0.200
    28.377     1.854     0.200
    28.377     1.694     0.200
    28.381     2.454     0.200
    28.442     1.547     0.200
    28.442     1.140     0.200
    28.445     1.230     0.200
    28.457     4.632     0.200
    28.476     1.684     0.200
    28.476     2.153     0.200
    28.483     3.227     0.200
    28.530     1.870     0.200
    28.534     1.682     0.200
    28.534     2.092     0.200
    28.557     5.215     0.200
    28.593     1.062     0.200
    28.594     0.845     0.200
    28.594     1.443     0.200
    28.465     3.441     0.200
    28.615     4.642     0.200
    28.631     0.722     0.200
    28.674     3.234     0.200
    28.777     3.776     0.200
    28.773     0.745     0.200
    28.781     0.599     0.200
    28.799     1.543     0.200
    28.799     1.062     0.200
    28.805     1.902     0.200
    28.835     2.385     0.200
    28.835     2.932     0.200
    28.844     0.939     0.200
    28.844     1.498     0.200
    28.874     0.858     0.200
    28.900     1.656     0.200
    28.881    -0.028     0.200
    28.935     1.300     0.200
    28.940     3.159     0.200
    28.924     2.560     0.200
    28.954     1.008     0.200
    28.980     3.911     0.200
    28.984     2.117     0.200
    29.032     2.857     0.200
    29.032     4.033     0.200
    29.041     1.091     0.200
    29.009     6.728     0.200
    29.143     3.791     0.200
    29.151     0.856     0.200
    29.151     1.883     0.200
    29.162     1.419     0.200
    29.172     0.704     0.200
    29.152     6.411     0.200
    29.232     0.573     0.200
    29.213     4.284     0.200
    29.285     0.271     0.200
    29.292     1.324     0.200
    29.292     1.945     0.200
    29.338     2.172     0.200
    29.345     2.151     0.200
    29.357     4.033     0.200
    29.367     2.139     0.200
    29.381     2.808     0.200
    29.411     0.682     0.200
    29.420     1.641     0.200
    29.443     7.305     0.200
    29.531     2.992     0.200
    29.531     0.594     0.200
    29.545     0.797     0.200
    29.984    -1.585     0.200
    29.594     1.939     0.200
    29.616     0.899     0.200
    29.694     1.728     0.200
    29.741     1.887     0.200
    29.747     1.697     0.200
    29.895     0.804     0.200
    29.902     3.524     0.200
    29.941     1.204     0.200
    29.941     1.056     0.200
    29.953     2.361     0.200
    29.950     1.192     0.200
    30.006     0.955     0.200
    30.047    -0.012     0.200
    30.054     1.645     0.200
    30.106     2.887     0.200
    30.141     2.344     0.200
    30.155     1.456     0.200
    30.187     5.021     0.200
    30.205     1.950     0.200
    30.218     2.899     0.200
    30.218     2.207     0.200
    30.260     1.218     0.200
    30.260     1.515     0.200
    30.262     2.808     0.200
    30.262     2.944     0.200
    30.299     2.155     0.200
    30.317     1.598     0.200
    30.334     3.207     0.200
    30.368     0.628     0.200
    30.382     0.918     0.200
    30.382     2.520     0.200
    30.381     0.838     0.200
    30.387     1.355     0.200
    30.428     0.870     0.200
    30.428     1.241     0.200
    30.430     4.093     0.200
    30.430     3.261     0.200
    30.445     1.058     0.200
    30.451     1.587     0.200
    30.450     0.605     0.200
    30.450     2.738     0.200
    30.483     1.923     0.200
    30.495     3.010     0.200
    30.505     1.344     0.200
    30.505     2.676     0.200
    30.553     1.424     0.200
    30.570     2.276     0.200
    30.605     1.439     0.200
    30.671     1.469     0.200
    30.675     1.417     0.200
    30.804     3.222     0.200
    30.911     0.775     0.200
    30.911     2.540     0.200
    30.916     0.717     0.200
    30.937     4.058     0.200
    30.943     1.669     0.200
    30.943     2.286     0.200
    30.955     1.893     0.200
    30.960     1.614     0.200
    30.960     1.880     0.200
    30.921     4.286     0.200
    30.995     1.095     0.200
    30.995     1.743     0.200
    31.032     1.110     0.200
    31.062     1.170     0.200
    31.069     1.044     0.200
    31.074     0.425     0.200
    31.094     1.996     0.200
    31.129     0.474     0.200
    31.174     1.198     0.200
    31.258     0.978     0.200
    31.257     1.187     0.200
    31.300     2.114     0.200
    31.312     1.106     0.200
    31.318     2.576     0.200
    31.360     4.330     0.200
    31.377     2.124     0.200
    31.391     1.270     0.200
    31.403     3.147     0.200
    31.488     0.764     0.200
    31.486     1.672     0.200
    31.503     1.632     0.200
    31.536     1.277     0.200
    31.570     1.875     0.200
    31.570     2.286     0.200
    31.582     2.963     0.200
    31.649     1.169     0.200
    31.669     2.633     0.200
    31.630     1.655     0.200
    31.693     1.102     0.200
    31.700     2.880     0.200
    31.706     1.060     0.200
    31.719     0.807     0.200
    31.734     0.862     0.200
    31.734     2.359     0.200
    31.727     1.697     0.200
    31.732     1.916     0.200
    31.771     0.818     0.200
    31.787     1.718     0.200
    31.787     0.996     0.200
    31.784     0.387     0.200
    31.784     0.837     0.200
    31.790     1.185     0.200
    31.797     2.058     0.200
    31.797     3.246     0.200
    31.804     3.754     0.200
    31.828     2.456     0.200
    31.831     1.646     0.200
    31.916     2.123     0.200
    31.956     3.130     0.200
    31.957     1.265     0.200
    31.967     3.110     0.200
    32.007     1.614     0.200
    32.064     1.688     0.200
    32.090     0.777     0.200
    32.099     3.070     0.200
    32.116     0.367     0.200
    32.102     2.126     0.200
    32.115     2.545     0.200
    32.161     2.395     0.200
    32.161     0.626     0.200
    32.173     1.435     0.200
    32.182     1.379     0.200
    32.180     1.875     0.200
    32.196     3.885     0.200
    32.201     1.474     0.200
    32.225     2.855     0.200
    32.236     2.468     0.200
    32.288     0.712     0.200
    32.299     1.626     0.200
    32.334     1.900     0.200
    32.338     4.800     0.200
    32.340     1.336     0.200
    32.338     2.530     0.200
    32.395     0.655     0.200
    32.437     1.719     0.200
    32.487     1.379     0.200
    32.521     2.112     0.200
    32.573     3.452     0.200
    32.595     2.814     0.200
    32.602     2.842     0.200
    32.607     3.331     0.200
    32.614     1.139     0.200
    32.689     2.524     0.200
    32.689     1.012     0.200
    32.714     1.073     0.200
    32.714     0.706     0.200
    32.726     0.730     0.200
    32.810     0.668     0.200
    32.903     1.609     0.200
    32.952     0.902     0.200
    32.966     1.818     0.200
    33.039     3.029     0.200
    33.068     1.107     0.200
    33.070     0.604     0.200
    33.070     1.491     0.200
    33.130     2.409     0.200
    33.136     0.972     0.200
    33.149     3.863     0.200
    33.210     0.630     0.200
    33.219     0.672     0.200
    33.312     0.453     0.200
    33.391     0.481     0.200
    33.439     0.615     0.200
    33.450    -0.108     0.200
    33.451     0.107     0.200
    33.451     2.123     0.200
    33.472     4.165     0.200
    33.476     1.682     0.200
    33.486     4.984     0.200
    33.548     2.795     0.200
    33.670     0.384     0.200
    33.717     3.254     0.200
    33.844     2.215     0.200
    33.857     3.662     0.200
    33.857     1.156     0.200
    33.869     0.506     0.200
    33.912     0.587     0.200
    33.951     2.562     0.200
    33.975     0.439     0.200
    34.092     3.314     0.200
    34.120     0.925     0.200
    34.121     0.681     0.200
    34.165     4.358     0.200
    34.184     0.607     0.200
    34.225     3.588     0.200
    34.263     0.896     0.200
    34.353     0.454     0.200
    34.475     0.438     0.200
    34.519     2.526     0.200
    34.519     2.827     0.200
    34.516     2.649     0.200
    34.603     2.992     0.200
    34.619     0.380     0.200
    34.647     1.306     0.200
    34.625     1.955     0.200
    34.762     1.074     0.200
    34.773     0.675     0.200
    34.756     3.111     0.200
    34.791     0.600     0.200
    34.871     0.633     0.200
    34.894     0.916     0.200
    34.903     0.844     0.200
    34.903     1.519     0.200
    34.906     0.824     0.200
    34.883     3.976     0.200
    34.966     2.041     0.200
    34.999     2.148     0.200
    35.018     3.495     0.200
    35.057     2.361     0.200
    35.119     2.683     0.200
    35.130     3.494     0.200
    35.153     2.002     0.200
    35.127     2.346     0.200
    35.127     2.499     0.200
    35.285     2.935     0.200
    35.334     1.364     0.200
    35.392     1.137     0.200
    35.401     1.603     0.200
    35.517     3.701     0.200
    35.514     1.710     0.200
    35.552     2.562     0.200
    35.559     0.823     0.200
    35.641     3.139     0.200
    35.657     0.626     0.200
    35.704     3.023     0.200
    35.850     3.181     0.200
    35.899     2.071     0.200
    35.922     1.926     0.200
    35.931     1.113     0.200
    35.975     1.052     0.200
    36.027     1.531     0.200
    36.007    -0.283     0.200
    36.082     0.861     0.200
    36.250     2.363     0.200
    36.255     1.084     0.200
    36.262     2.359     0.200
    36.354     2.977     0.200
    36.432     0.572     0.200
    36.501     3.881     0.200
    36.532     1.042     0.200
    36.649     1.602     0.200
    36.674     3.139     0.200
    36.943     0.637     0.200
    37.013     2.850     0.200
    37.012     1.873     0.200
    37.036     1.292     0.200
    37.104     2.382     0.200
    37.083     0.273     0.200
    37.109     2.562     0.200
    37.189     3.225     0.200
    37.221     1.342     0.200
    37.316     1.757     0.200
    37.304     2.135     0.200
    37.359     2.707     0.200
    37.537     2.074     0.200
    37.565     1.553     0.200
    37.604     2.138     0.200
    37.803     1.841     0.200
    37.878     2.284     0.200
    37.878     2.002     0.200
    37.997     2.025     0.200
    38.101     2.607     0.200
    38.198     1.280     0.200
    38.702     2.583     0.200
    38.745     1.136     0.200
    38.766     1.805     0.200
    40.968     2.307     0.200
    41.000     2.091     0.200
    41.896     3.445     0.200
    42.630     1.948     0.200
    42.710     3.366     0.200
    42.710     4.596     0.200
    44.123     1.872     0.200
    44.508     3.080     0.200
    44.710     5.815     0.200
    45.165     4.596     0.200
    45.165     3.853     0.200
    45.165     4.467     0.200
    45.497     1.852     0.200
    46.662     2.733     0.200
    46.838     1.884     0.200
    47.266     4.585     0.200
    47.347     2.822     0.200
    47.785     3.541     0.200
    48.382     3.988     0.200
    48.748     3.252     0.200
    49.137     3.387     0.200
    49.324     5.401     0.200
    49.324     3.659     0.200
    49.918     3.204     0.200
    50.790     3.649     0.200
    51.479     1.925     0.200
    51.897     2.696     0.200
    52.231     3.366     0.200
    52.963     4.133     0.200
    53.040     4.860     0.200
    53.044     4.303     0.200
    53.069     4.398     0.200
    53.135     5.130     0.200
    53.192     6.015     0.200
    53.482     4.898     0.200
    53.775     3.510     0.200
    53.780     5.776     0.200
    54.731     3.778     0.200
    55.143     2.969     0.200
    55.168     4.939     0.200
    55.202     2.519     0.200
    55.197     4.238     0.200
    55.199     5.527     0.200
    55.468     2.394     0.200
    55.795     2.728     0.200
    56.556     3.008     0.200
    56.644     3.258     0.200
    56.693     3.643     0.200
    56.709     3.695     0.200
    56.896     2.506     0.200
    57.287     2.572     0.200
    57.287     2.892     0.200
    57.298     3.235     0.200
    57.464     2.575     0.200
    57.464     2.274     0.200
    57.849     1.740     0.200
    57.867     2.385     0.200
    57.870     1.746     0.200
    57.931     1.503     0.200
    57.931     1.390     0.200
    57.952     3.972     0.200
    58.411     3.237     0.200
    58.411     1.835     0.200
    58.932     7.907     0.200
    59.209     0.984     0.200
    59.209     3.691     0.200
    59.209     2.328     0.200
    59.336     2.378     0.200
    59.790     7.883     0.200
    59.833     8.087     0.200
    59.894     2.690     0.200
    59.981     7.250     0.200
    59.993     7.987     0.200
    60.034     7.706     0.200
    60.176     3.532     0.200
    60.176     3.032     0.200
    60.292     3.637     0.200
    60.292     2.188     0.200
    60.472     2.433     0.200
    60.472     2.589     0.200
    60.560     1.952     0.200
    62.003     4.441     0.200
    62.184     2.023     0.200
    62.593     3.073     0.200
    62.936     3.634     0.200
    63.482     3.936     0.200
    64.675     2.380     0.200
    64.819     3.864     0.200
    64.853     5.691     0.200
    64.976     2.492     0.200
    64.976     2.711     0.200
    65.051     2.302     0.200
    65.187     2.621     0.200
    65.378     2.779     0.200
    65.356     3.012     0.200
    65.555     2.839     0.200
    65.645     3.245     0.200
    66.066     3.240     0.200
    66.080     3.707     0.200
    66.768     4.721     0.200
    67.216     3.805     0.200
    67.375     3.096     0.200
    67.402     4.928     0.200
    67.517     1.138     0.200
    67.655     2.924     0.200
    67.703     3.394     0.200
    67.749     2.835     0.200
    67.799     3.122     0.200
    68.305     2.949     0.200
    69.342     1.949     0.200
    69.888     1.207     0.200
    70.114     4.131     0.200
    70.128     6.950     0.200
    71.647     1.518     0.200
    74.757     4.954     0.200
    75.010     5.896     0.200
    75.041     5.010     0.200
    75.424     3.607     0.200
    76.042     3.877     0.200
    76.042     3.127     0.200
    77.619     2.286     0.200
    78.313     3.759     0.200
    78.721     2.311     0.200
    78.745     1.964     0.200
    79.051     3.398     0.200
    79.148     3.210     0.200
    79.375     2.512     0.200
    79.622     2.007     0.200
    79.662     3.236     0.200
    79.733     4.115     0.200
    79.804     3.864     0.200
    79.854     2.336     0.200
    79.861     4.356     0.200
    79.877     3.381     0.200
    79.877     4.471     0.200
    79.877     2.310     0.200
    79.898     2.184     0.200
    79.966     3.450     0.200
    79.961     3.148     0.200
    80.097     4.580     0.200
    80.120     1.997     0.200
    80.139     4.755     0.200
    80.167     4.805     0.200
    80.167     3.106     0.200
    80.225     2.571     0.200
    80.292     5.132     0.200
    80.307     4.349     0.200
    80.347     4.036     0.200
    80.427     5.205     0.200
    80.507     2.796     0.200
    80.562     4.377     0.200
    80.578     4.192     0.200
    80.577     4.601     0.200
    80.582     4.671     0.200
    80.677     3.035     0.200
    80.694     2.525     0.200
    80.766     3.688     0.200
    80.766     2.731     0.200
    80.793     3.302     0.200
    80.863     3.079     0.200
    80.952     4.192     0.200
    80.957     4.466     0.200
    81.008     3.799     0.200
    81.020     2.680     0.200
    81.032     3.956     0.200
    81.070     4.668     0.200
    81.126     3.828     0.200
    81.221     2.305     0.200
    81.249     5.114     0.200
    81.308     7.371     0.200
    81.374     3.853     0.200
    81.421     3.182     0.200
    81.450     2.870     0.200
    81.654     3.480     0.200
    81.712     3.776     0.200
    82.010     2.808     0.200
    82.144     3.183     0.200
    82.485     6.267     0.200
    82.535     5.917     0.200
    82.780     3.250     0.200
    82.786     5.496     0.200
    82.839     6.339     0.200
    82.930     6.034     0.200
    83.132     3.552     0.200
    83.143     5.174     0.200
    83.188     4.202     0.200
    83.247     6.227     0.200
    83.288     3.547     0.200
    83.359     2.880     0.200
    83.510     6.872     0.200
    83.578     2.427     0.200
    83.588     4.544     0.200
    83.608     2.949     0.200
    83.628     5.936     0.200
    83.652     1.873     0.200
    83.652     2.783     0.200
    83.641     7.200     0.200
    83.832     7.222     0.200
    83.835     6.207     0.200
    84.079     4.943     0.200
    84.129     6.709     0.200
    84.165     3.369     0.200
    84.445     4.174     0.200
    84.612     6.257     0.200
    84.630     3.299     0.200
    84.649     6.242     0.200
    84.902     5.859     0.200
    84.925     3.213     0.200
    85.055     3.363     0.200
    85.055     2.719     0.200
    85.056     3.256     0.200
    85.100     6.814     0.200
    85.119     5.863     0.200
    85.167     6.472     0.200
    85.233     3.068     0.200
    85.233     2.959     0.200
    85.301     3.321     0.200
    85.614     2.972     0.200
    85.614     4.253     0.200
    85.648     1.952     0.200
    85.664     3.541     0.200
    85.777     6.432     0.200
    85.730     3.085     0.200
    85.913     2.790     0.200
    85.913     2.310     0.200
    85.946     3.727     0.200
    86.009     3.402     0.200
    86.055     4.385     0.200
    86.216     6.261     0.200
    86.241     6.265     0.200
    86.312     3.088     0.200
    86.392     4.306     0.200
    86.445     3.515     0.200
    86.553     2.863     0.200
    86.558     2.495     0.200
    86.591     4.146     0.200
    86.657     3.018     0.200
    87.064     6.105     0.200
    87.105     2.637     0.200
    87.105     3.117     0.200
    87.963     6.788     0.200
    88.036     4.771     0.200
    88.282     2.108     0.200
    88.952     2.752     0.200
    88.952     2.310     0.200
    89.018     4.988     0.200
    89.219     1.096     0.200
    89.219     1.796     0.200
    89.227     3.459     0.200
    89.532     4.537     0.200
    89.554     5.624     0.200
    90.238    -0.223     0.200
    90.339     2.697     0.200
    90.355     2.689     0.200
    90.366     2.533     0.200
    90.552     2.271     0.200
    90.555     2.395     0.200
    90.792     3.163     0.200
    90.863     2.691     0.200
    90.898     1.358     0.200
    90.976     3.014     0.200
    91.063     3.706     0.200
    91.094     2.547     0.200
    91.354     3.250     0.200
    91.423     2.549     0.200
    91.610     3.361     0.200
    91.671     0.006     0.200
    91.715     3.870     0.200
    91.715     2.148     0.200
    91.856     2.517     0.200
    91.922     2.413     0.200
    91.977     2.147     0.200
    92.008     1.597     0.200
    92.192     2.589     0.200
    92.299     2.149     0.200
    92.376     3.414     0.200
    92.376     2.355     0.200
    92.404     3.284     0.200
    92.381     2.592     0.200
    92.421     3.107     0.200
    92.439     0.872     0.200
    92.538     2.687     0.200
    92.544     3.045     0.200
    92.528     2.815     0.200
    92.528     2.709     0.200
    92.672     2.849     0.200
    92.728     2.877     0.200
    92.729     2.688     0.200
    92.935     2.953     0.200
    93.041     2.947     0.200
    93.041    -0.424     0.200
    93.255     1.962     0.200
    93.277     4.059     0.200
    93.352     2.542     0.200
    93.352     3.316     0.200
    93.352     3.913     0.200
    93.364     3.257     0.200
    93.445     2.556     0.200
    93.491     4.074     0.200
    93.542     3.908     0.200
    93.542     1.953     0.200
    93.627     3.046     0.200
    93.641     2.881     0.200
    93.641     3.881     0.200
    93.641     1.471     0.200
    93.677    -0.892     0.200
    93.752     2.597     0.200
    93.764     2.223     0.200
    93.823     3.754     0.200
    93.944     3.592     0.200
    94.060     2.665     0.200
    94.156     4.043     0.200
    94.190     4.756     0.200
    94.218     3.830     0.200
    94.459     4.226     0.200
    94.547     2.969     0.200
    94.606     2.699     0.200
    94.637     2.704     0.200
    94.788     3.348     0.200
    94.861     2.731     0.200
    95.039     3.969     0.200
    95.039     3.267     0.200
    95.496     3.982     0.200
    95.685     5.040     0.200
    95.929     0.608     0.200
    95.929     0.710     0.200
    95.946     5.130     0.200
    95.946     3.896     0.200
    95.946     3.251     0.200
    96.021     4.489     0.200
    96.021     2.567     0.200
    96.047     1.370     0.200
    96.138     2.046     0.200
    96.693     5.837     0.200
    96.804     4.934     0.200
    96.811     3.404     0.200
    96.877     2.805     0.200
    97.046     0.143     0.200
    97.109     1.756     0.200
    97.299     2.742     0.200
    97.371     2.394     0.200
    98.729     3.169     0.200
    99.004     3.145     0.200
    16.608     4.455     0.200
    16.955     4.537     0.200
    17.312     3.581     0.200
    17.444     3.042     0.200
    18.105     2.040     0.200
    18.383     3.049     0.200
    18.404     2.849     0.200
    18.495     0.740     0.200
    18.495     1.118     0.200
    18.534     2.100     0.200
    18.647     1.171     0.200
    18.647     0.554     0.200
    19.059     1.006     0.200
    19.062     1.204     0.200
    19.073     2.490     0.200
    19.114     1.499     0.200
    19.345     1.605     0.200
    19.386     1.738     0.200
    19.386     1.156     0.200
    19.427     1.354     0.200
    19.460     0.949     0.200
    19.514     1.764     0.200
    19.556     0.937     0.200
    19.634     1.545     0.200
    19.651     1.372     0.200
    19.705     1.528     0.200
    19.719     1.376     0.200
    19.778     0.913     0.200
    19.778    -0.208     0.200
    19.795     1.735     0.200
    19.795     0.966     0.200
    19.820     1.427     0.200
    19.820     1.127     0.200
    19.887     0.804     0.200
    19.887     0.609     0.200
    19.909     1.010     0.200
    19.909     0.815     0.200
    20.060     1.017     0.200
    20.080     1.128     0.200
    20.080     0.480     0.200
    20.138     1.230     0.200
    20.162     1.336     0.200
    20.173     1.514     0.200
    20.181     1.215     0.200
    20.217     0.723     0.200
    20.217     1.888     0.200
    20.297     0.891     0.200
    20.351     2.780     0.200
    20.395     1.413     0.200
    20.395     1.222     0.200
    20.487     2.169     0.200
    20.536     2.281     0.200
    20.536     1.336     0.200
    20.536     1.847     0.200
    20.558     1.790     0.200
    20.629     0.603     0.200
    20.633     1.394     0.200
    20.682     1.249     0.200
    20.712     1.338     0.200
    20.743     1.319     0.200
    20.743     0.667     0.200
    20.784     1.965     0.200
    20.784     0.512     0.200
    20.859     0.454     0.200
    20.899     1.166     0.200
    20.899     0.557     0.200
    20.927     1.014     0.200
    20.996     1.689     0.200
    21.115     1.261     0.200
    21.159     1.308     0.200
    21.243     0.396     0.200
    21.204     3.938     0.200
    21.204     4.949     0.200
    21.307     1.298     0.200
    21.302     0.875     0.200
    21.334     1.999     0.200
    21.375     4.782     0.200
    21.492     1.390     0.200
    21.514     0.504     0.200
    21.497     3.449     0.200
    21.497     2.234     0.200
    21.646     0.770     0.200
    21.671     0.954     0.200
    21.671     0.146     0.200
    21.689     0.152     0.200
    21.695     1.278     0.200
    21.721     1.469     0.200
    21.721     0.809     0.200
    21.730     1.080     0.200
    21.694     4.343     0.200
    21.707     4.201     0.200
    21.747     4.520     0.200
    21.794     1.278     0.200
    21.787     3.544     0.200
    21.787     2.470     0.200
    21.817     1.188     0.200
    21.808     3.996     0.200
    21.896     0.957     0.200
    21.935     0.097     0.200
    21.935     1.105     0.200
    21.936     1.280     0.200
    21.936     1.460     0.200
    22.026     1.130     0.200
    22.026     0.743     0.200
    22.001     4.155     0.200
    22.051     0.561     0.200
    22.051     1.080     0.200
    22.056     0.576     0.200
    22.056    -0.162     0.200
    22.058     0.556     0.200
    22.052     4.575     0.200
    22.107     0.980     0.200
    22.107     0.301     0.200
    22.066     3.119     0.200
    22.128     1.116     0.200
    22.189     4.346     0.200
    22.226     4.279     0.200
    22.296     1.458     0.200
    22.286     2.464     0.200
    22.286     1.526     0.200
    22.306     0.940     0.200
    22.357     0.705     0.200
    22.357     0.459     0.200
    22.381     1.253     0.200
    22.432    -0.094     0.200
    22.432     0.628     0.200
    22.511     0.881     0.200
    22.477     4.373     0.200
    22.477     3.795     0.200
    22.571     0.182     0.200
    22.543     3.256     0.200
    22.612     0.567     0.200
    22.613    -0.220     0.200
    22.564     3.936     0.200
    22.566     3.855     0.200
    22.566     3.582     0.200
    22.604     2.861     0.200
    22.661     0.726     0.200
    22.658     2.786     0.200
    22.733     1.381     0.200
    22.743     0.495     0.200
    22.773     1.558     0.200
    22.775    -0.366     0.200
    22.757     2.944     0.200
    22.771     2.445     0.200
    22.776     2.785     0.200
    22.830     0.414     0.200
    22.833     0.733     0.200
    22.853     2.197     0.200
    22.865     2.344     0.200
    22.923     0.477     0.200
    22.897     2.706     0.200
    22.902     2.246     0.200
    22.912     2.164     0.200
    22.927     2.243     0.200
    22.958     0.152     0.200
    22.937     3.774     0.200
    22.961     2.492     0.200
    22.970     2.203     0.200
    23.006     0.881     0.200
    23.006     0.557     0.200
    22.999     2.784     0.200
    23.017     2.634     0.200
    23.006     3.660     0.200
    23.085     2.721     0.200
    23.114     1.329     0.200
    23.093     2.803     0.200
    23.172     0.479     0.200
    23.166     2.869     0.200
    23.174     2.813     0.200
    23.199     2.599     0.200
    23.270     0.349     0.200
    23.268     3.785     0.200
    23.318     0.376     0.200
    23.318    -0.159     0.200
    23.342    -0.437     0.200
    23.292     4.645     0.200
    23.384     1.428     0.200
    23.351     3.917     0.200
    23.406     2.332     0.200
    23.484     1.064     0.200
    23.486     0.461     0.200
    23.452     2.874     0.200
    23.492     2.488     0.200
    23.512     0.848     0.200
    23.490     1.007     0.200
    23.501     2.029     0.200
    23.501     2.775     0.200
    23.546     0.606     0.200
    23.576     0.528     0.200
    23.563     4.366     0.200
    23.684     2.010     0.200
    23.694     1.819     0.200
    23.645     4.524     0.200
    23.745     1.464     0.200
    23.745     0.605     0.200
    23.768     0.918     0.200
    23.768     0.461     0.200
    23.721     4.240     0.200
    23.881     1.675     0.200
    23.863     3.950     0.200
    23.866     2.941     0.200
    23.917     1.684     0.200
    23.920     2.596     0.200
    23.920     2.021     0.200
    23.933     1.847     0.200
    23.981     1.948     0.200
    23.982     1.332     0.200
    23.950     2.962     0.200
    23.958     4.628     0.200
    23.958     3.433     0.200
    23.956     3.471     0.200
    23.969     3.079     0.200
    24.014     1.564     0.200
    24.028     0.998     0.200
    24.044     1.995     0.200
    24.044     1.393     0.200
    24.000     3.382     0.200
    24.084     0.964     0.200
    24.098     4.024     0.200
    24.153     3.165     0.200
    24.153     2.505     0.200
    24.146     4.712     0.200
    24.179     2.636     0.200
    24.263     2.112     0.200
    24.282     1.366     0.200
    24.264     2.456     0.200
    24.302     1.607     0.200
    24.302     1.275     0.200
    24.301     1.691     0.200
    24.362     0.965     0.200
    24.362     1.457     0.200
    24.359     4.340     0.200
    24.412     1.782     0.200
    24.424     1.530     0.200
    24.435     1.393     0.200
    24.424     3.936     0.200
    24.424     3.491     0.200
    24.520     2.151     0.200
    24.520     1.241     0.200
    24.561     2.399     0.200
    24.561     1.657     0.200
    24.512     4.396     0.200
    24.577     2.276     0.200
    24.608     2.200     0.200
    24.584     3.510     0.200
    24.588     4.309     0.200
    24.623     3.135     0.200
    24.684     1.340     0.200
    24.716     1.734     0.200
    24.763     2.037     0.200
    24.760     4.750     0.200
    24.837     4.589     0.200
    24.902     1.187     0.200
    24.902     0.336     0.200
    24.870     4.784     0.200
    24.870     4.460     0.200
    24.887     4.622     0.200
    24.929     2.007     0.200
    24.880     2.806     0.200
    24.967     1.678     0.200
    24.996     1.476     0.200
    25.014     1.547     0.200
    25.014     0.930     0.200
    24.982     3.363     0.200
    25.023     2.188     0.200
    25.023     1.184     0.200
    25.069     1.125     0.200
    25.082     2.185     0.200
    25.082     1.572     0.200
    25.031     4.465     0.200
    25.124     1.777     0.200
    25.124     1.051     0.200
    25.165     2.280     0.200
    25.189     1.580     0.200
    25.190     1.447     0.200
    25.214     2.235     0.200
    25.214     2.102     0.200
    25.218     1.413     0.200
    25.218     0.948     0.200
    25.201     2.485     0.200
    25.180     4.322     0.200
    25.180     4.435     0.200
    25.195     5.042     0.200
    25.280     1.610     0.200
    25.280     0.564     0.200
    25.319     1.467     0.200
    25.319     0.600     0.200
    25.340     1.549     0.200
    25.340     0.956     0.200
    25.367     1.733     0.200
    25.367     0.905     0.200
    25.372     2.852     0.200
    25.413     2.106     0.200
    25.475     1.934     0.200
    25.475     1.105     0.200
    25.485     4.159     0.200
    25.493     4.399     0.200
    25.499     4.928     0.200
    25.629     1.476     0.200
    25.629     1.265     0.200
    25.635     2.323     0.200
    25.561     6.822     0.200
    25.647     1.584     0.200
    25.624     4.721     0.200
    25.664     4.789     0.200
    25.721     0.986     0.200
    25.729     1.867     0.200
    25.740     2.479     0.200
    25.763     1.479     0.200
    25.763     1.112     0.200
    25.853     2.742     0.200
    25.829     2.447     0.200
    25.894     1.736     0.200
    25.898     1.930     0.200
    25.898     0.841     0.200
    25.904     2.298     0.200
    25.910     2.069     0.200
    25.959     2.602     0.200
    25.911     5.360     0.200
    25.965     3.800     0.200
    25.965     4.007     0.200
    26.016     5.179     0.200
    26.127     1.455     0.200
    26.137     1.894     0.200
    26.199     1.155     0.200
    26.199     0.503     0.200
    26.154     4.014     0.200
    26.219     2.573     0.200
    26.300     2.125     0.200
    26.300     1.578     0.200
    26.277     2.661     0.200
    26.324     1.856     0.200
    26.336     1.498     0.200
    26.336     0.752     0.200
    26.300     3.849     0.200
    26.424     2.282     0.200
    26.424     1.512     0.200
    26.372     3.745     0.200
    26.431     3.038     0.200
    26.431     2.054     0.200
    26.470     1.785     0.200
    26.470     0.133     0.200
    26.484     2.328     0.200
    26.484     1.390     0.200
    26.491     1.851     0.200
    26.491     2.453     0.200
    26.425     5.809     0.200
    26.544     1.423     0.200
    26.544     0.373     0.200
    26.545     1.050     0.200
    26.585     2.322     0.200
    26.586     2.048     0.200
    26.594     1.425     0.200
    26.681     2.958     0.200
    26.725     2.065     0.200
    26.660     5.398     0.200
    26.710     6.643     0.200
    26.768     3.554     0.200
    26.807     1.568     0.200
    26.765     5.062     0.200
    26.828     2.104     0.200
    26.832     1.470     0.200
    26.832     0.884     0.200
    26.832     1.509     0.200
    26.832     1.044     0.200
    26.805     3.042     0.200
    26.845     2.143     0.200
    26.860     0.984     0.200
    26.860     0.637     0.200
    26.876     2.061     0.200
    26.844     3.776     0.200
    26.902     4.437     0.200
    26.975     1.678     0.200
    26.975     1.369     0.200
    27.016     2.187     0.200
    27.016     1.734     0.200
    26.980     4.822     0.200
    27.038     2.141     0.200
    27.066     2.666     0.200
    27.056     5.404     0.200
    27.056     4.826     0.200
    27.101     2.338     0.200
    27.106     1.071     0.200
    27.111     1.441     0.200
    27.225     1.357     0.200
    27.159     6.854     0.200
    27.240     0.900     0.200
    27.240     1.025     0.200
    27.233     2.776     0.200
    27.233     3.265     0.200
    27.233     3.097     0.200
    27.233     3.268     0.200
    27.233     2.694     0.200
    27.274     1.940     0.200
    27.301     0.547     0.200
    27.301     2.340     0.200
    27.319     3.086     0.200
    27.335     2.551     0.200
    27.393     1.370     0.200
    27.409     2.278     0.200
    27.420     2.495     0.200
    27.411     3.848     0.200
    27.411     2.973     0.200
    27.450     0.949     0.200
    27.450     0.273     0.200
    27.413     3.350     0.200
    27.467     1.312     0.200
    27.467    -0.204     0.200
    27.479     2.007     0.200
    27.479     1.031     0.200
    27.506     1.386     0.200
    27.506     0.480     0.200
    27.491     2.154     0.200
    27.491     2.920     0.200
    27.551     2.207     0.200
    27.551     1.453     0.200
    27.573     1.636     0.200
    27.574     1.390     0.200
    27.574     0.034     0.200
    27.567     2.588     0.200
    27.567     1.115     0.200
    27.646     1.678     0.200
    27.669     1.677     0.200
    27.710     2.329     0.200
    27.710     1.454     0.200
    27.705     3.035     0.200
    27.760     1.769     0.200
    27.760     0.769     0.200
    27.827     1.683     0.200
    27.904     2.823     0.200
    27.912     1.270     0.200
    27.912     0.883     0.200
    27.956     2.301     0.200
    27.922     3.600     0.200
    27.991     1.125     0.200
    27.961     4.947     0.200
    27.945     4.924     0.200
    28.021     2.033     0.200
    28.021     0.697     0.200
    28.053     1.400     0.200
    28.139     1.617     0.200
    28.139     1.128     0.200
    28.143     3.285     0.200
    28.207     3.189     0.200
    28.262     1.325     0.200
    28.229     3.842     0.200
    28.293     0.982     0.200
    28.293     0.490     0.200
    28.288     2.256     0.200
    28.317     1.482     0.200
    28.325     2.003     0.200
    28.303     2.849     0.200
    28.389     1.366     0.200
    28.394     1.972     0.200
    28.406     4.150     0.200
    28.465     2.548     0.200
    28.472     2.849     0.200
    28.472     2.146     0.200
    28.474     2.198     0.200
    28.474     1.323     0.200
    28.468     1.911     0.200
    28.500     1.458     0.200
    28.500     0.853     0.200
    28.565     2.439     0.200
    28.565     1.510     0.200
    28.565     3.962     0.200
    28.626     2.447     0.200
    28.634     2.595     0.200
    28.665     1.489     0.200
    28.668     1.648     0.200
    28.681     1.683     0.200
    28.659     3.190     0.200
    28.563     3.526     0.200
    28.711     1.223     0.200
    28.763     3.211     0.200
    28.851     1.365     0.200
    28.874     0.530     0.200
    28.874     1.768     0.200
    28.898     3.055     0.200
    28.919     1.427     0.200
    28.919     0.877     0.200
    28.928     1.495     0.200
    28.928     1.128     0.200
    28.884     4.072     0.200
    28.992     2.631     0.200
    28.966     3.030     0.200
    29.012     1.386     0.200
    29.019     4.416     0.200
    29.019     3.248     0.200
    29.081     2.872     0.200
    29.113     1.117     0.200
    29.221     2.070     0.200
    29.221    -0.387     0.200
    29.197     4.915     0.200
    29.245     2.466     0.200
    29.251     2.105     0.200
    29.253     0.973     0.200
    29.253     0.399     0.200
    29.282     1.019     0.200
    29.344     3.239     0.200
    29.373     3.224     0.200
    29.373     3.068     0.200
    29.377     3.068     0.200
    29.431     2.721     0.200
    29.431     2.155     0.200
    29.462     1.816     0.200
    29.462     1.406     0.200
    29.473     1.207     0.200
    29.473     0.601     0.200
    29.457     2.734     0.200
    29.494     1.175     0.200
    29.612     1.662     0.200
    29.656     3.514     0.200
    29.684     2.198     0.200
    29.684     1.705     0.200
    29.692     1.291     0.200
    29.692    -0.021     0.200
    29.790     3.114     0.200
    29.835     2.344     0.200
    29.835     1.621     0.200
    29.835     2.361     0.200
    29.909     0.248     0.200
    29.884     1.960     0.200
    29.968     1.440     0.200
    30.011     1.224     0.200
    30.035     1.710     0.200
    30.035     0.757     0.200
    30.089     0.948     0.200
    30.073     3.120     0.200
    30.098     2.813     0.200
    30.146     2.397     0.200
    30.101     3.643     0.200
    30.222     2.121     0.200
    30.294     2.329     0.200
    30.308     2.187     0.200
    30.302     2.871     0.200
    30.280     3.666     0.200
    30.343     1.742     0.200
    30.343     0.039     0.200
    30.360     2.641     0.200
    30.412     2.678     0.200
    30.416     4.370     0.200
    30.452     1.599     0.200
    30.455     1.791     0.200
    30.455    -0.131     0.200
    30.475     1.510     0.200
    30.480     2.484     0.200
    30.479     3.712     0.200
    30.505     0.710     0.200
    30.515     1.925     0.200
    30.525     1.217     0.200
    30.574     2.526     0.200
    30.579     1.674     0.200
    30.622     1.972     0.200
    30.663     1.275     0.200
    30.673     1.992     0.200
    30.662     4.177     0.200
    30.719     2.016     0.200
    30.755     1.267     0.200
    30.763     1.999     0.200
    30.763     1.834     0.200
    30.748     4.023     0.200
    30.885     2.633     0.200
    30.935     3.988     0.200
    30.967     2.621     0.200
    30.967     0.961     0.200
    30.996     0.769     0.200
    31.007     2.659     0.200
    31.007     1.729     0.200
    31.030     1.597     0.200
    31.086     2.045     0.200
    31.086     0.252     0.200
    31.108     1.401     0.200
    31.148     1.802     0.200
    31.156     1.308     0.200
    31.207     1.258     0.200
    31.231     1.064     0.200
    31.243     0.829     0.200
    31.246     3.079     0.200
    31.317     1.544     0.200
    31.317     0.993     0.200
    31.342     1.479     0.200
    31.303     2.500     0.200
    31.388     1.625     0.200
    31.353     4.287     0.200
    31.371     2.739     0.200
    31.472     2.556     0.200
    31.497     3.311     0.200
    31.543     1.615     0.200
    31.543     1.135     0.200
    31.569     1.512     0.200
    31.570     1.790     0.200
    31.570     1.336     0.200
    31.594     2.505     0.200
    31.616     2.950     0.200
    31.663     2.469     0.200
    31.663     2.266     0.200
    31.669     2.526     0.200
    31.734     1.572     0.200
    31.768     1.738     0.200
    31.780     1.735     0.200
    31.780     1.188     0.200
    31.784     2.141     0.200
    31.749     3.103     0.200
    31.818     1.294     0.200
    31.808     2.989     0.200
    31.808     2.505     0.200
    31.776     2.883     0.200
    31.849     2.184     0.200
    31.852     1.314     0.200
    31.868     1.037     0.200
    31.874     1.369     0.200
    31.874     1.174     0.200
    31.907     3.592     0.200
    31.920     3.798     0.200
    31.960     1.809     0.200
    32.011     2.899     0.200
    32.035     1.812     0.200
    32.098     0.830     0.200
    32.087     1.146     0.200
    32.129     1.775     0.200
    32.164     1.191     0.200
    32.152     4.106     0.200
    32.212     1.302     0.200
    32.206     3.179     0.200
    32.206     2.183     0.200
    32.231     3.159     0.200
    32.231     2.733     0.200
    32.252     1.132     0.200
    32.258     1.460     0.200
    32.273     2.244     0.200
    32.282     1.056     0.200
    32.283     4.760     0.200
    32.366     1.343     0.200
    32.389     2.272     0.200
    32.412     1.219     0.200
    32.424     2.051     0.200
    32.424     1.270     0.200
    32.395     4.349     0.200
    32.477     1.043     0.200
    32.554     1.391     0.200
    32.523     3.869     0.200
    32.549     3.997     0.200
    32.550     3.598     0.200
    32.579     3.184     0.200
    32.679     1.657     0.200
    32.784     1.339     0.200
    32.784     2.519     0.200
    32.793     0.422     0.200
    32.802     1.483     0.200
    32.890     1.291     0.200
    32.925     3.423     0.200
    32.973     1.689     0.200
    32.957     3.913     0.200
    33.035     1.134     0.200
    32.997     3.489     0.200
    33.061     2.748     0.200
    33.104     3.293     0.200
    33.155     1.556     0.200
    33.155     1.135     0.200
    33.132     2.789     0.200
    33.214     1.109     0.200
    33.292     1.365     0.200
    33.292     0.736     0.200
    33.298     1.073     0.200
    33.388     1.248     0.200
    33.379     2.049     0.200
    33.464     1.061     0.200
    33.422     4.690     0.200
    33.434     4.476     0.200
    33.491     1.483     0.200
    33.509     1.689     0.200
    33.509     1.217     0.200
    33.522     1.005     0.200
    33.527     1.110     0.200
    33.532     1.157     0.200
    33.501     4.095     0.200
    33.548     1.336     0.200
    33.655     3.413     0.200
    33.678     4.358     0.200
    33.750     1.398     0.200
    33.800     3.372     0.200
    33.825     2.208     0.200
    33.939     1.664     0.200
    33.940     1.127     0.200
    33.997     1.089     0.200
    34.044     2.306     0.200
    34.050     1.243     0.200
    34.045     4.761     0.200
    34.127     1.831     0.200
    34.198     1.206     0.200
    34.199     1.064     0.200
    34.211     2.929     0.200
    34.267     1.344     0.200
    34.239     4.897     0.200
    34.344     1.258     0.200
    34.426     1.264     0.200
    34.479     1.711     0.200
    34.493     1.363     0.200
    34.495     2.054     0.200
    34.495     3.729     0.200
    34.505     2.718     0.200
    34.549     1.134     0.200
    34.582     1.365     0.200
    34.560     4.142     0.200
    34.698     1.516     0.200
    34.744     1.547     0.200
    34.849     2.056     0.200
    34.849     1.411     0.200
    34.850     1.552     0.200
    34.873     1.460     0.200
    34.950     1.499     0.200
    34.987     1.763     0.200
    34.987     0.971     0.200
    34.991     1.512     0.200
    35.094     2.594     0.200
    35.063     2.453     0.200
    35.089     4.332     0.200
    35.215     0.330     0.200
    35.230     1.756     0.200
    35.230     0.045     0.200
    35.247     4.083     0.200
    35.418     1.750     0.200
    35.445     1.387     0.200
    35.473     1.804     0.200
    35.488     1.596     0.200
    35.507     1.280     0.200
    35.481     3.217     0.200
    35.604     0.091     0.200
    35.644     1.294     0.200
    35.735     1.384     0.200
    35.813     4.171     0.200
    35.990     2.492     0.200
    35.990     2.878     0.200
    36.006     1.307     0.200
    36.013     1.888     0.200
    36.163     2.026     0.200
    36.225     3.819     0.200
    36.339     1.633     0.200
    36.339     2.572     0.200
    36.323     2.489     0.200
    36.369     3.099     0.200
    36.462     3.739     0.200
    36.514     1.894     0.200
    36.525     1.805     0.200
    36.619     2.262     0.200
    36.734     2.174     0.200
    36.979     3.886     0.200
    37.087     1.660     0.200
    37.124     2.357     0.200
    37.236     3.402     0.200
    37.388     1.582     0.200
    37.453     2.336     0.200
    37.626     1.988     0.200
    37.653     2.580     0.200
    37.889     2.263     0.200
    37.896     2.386     0.200
    37.896     2.066     0.200
    38.090     2.382     0.200
    38.090     1.816     0.200
    38.190     2.898     0.200
    38.160     3.334     0.200
    38.286     2.010     0.200
    38.798     1.053     0.200
    38.822     1.602     0.200
    38.854     1.205     0.200
    39.391     1.162     0.200
    39.658     1.516     0.200
    40.988     1.002     0.200
    41.092     1.403     0.200
    41.861     3.331     0.200
    42.821     1.774     0.200
    44.217     1.988     0.200
    44.470     2.820     0.200
    45.238     3.372     0.200
    45.238     3.048     0.200
    45.573     1.644     0.200
    45.573     1.304     0.200
    46.841     1.977     0.200
    46.840     1.969     0.200
    46.778     3.572     0.200
    47.241     4.181     0.200
    50.559     3.340     0.200
    53.450     2.815     0.200
    53.591     3.305     0.200
    53.743     3.506     0.200
    54.404     3.747     0.200
    54.422     2.859     0.200
    54.696     4.087     0.200
    55.109     3.476     0.200
    55.082     4.657     0.200
    55.187     2.986     0.200
    55.238     3.511     0.200
    55.434     3.203     0.200
    55.470     2.863     0.200
    55.786     2.496     0.200
    55.781     3.376     0.200
    55.913     3.284     0.200
    55.947     3.549     0.200
    56.026     3.375     0.200
    56.063     3.228     0.200
    56.118     3.190     0.200
    56.423     2.945     0.200
    56.511     4.019     0.200
    56.511     2.578     0.200
    56.550     2.977     0.200
    56.604     3.485     0.200
    56.645     3.064     0.200
    56.640     2.887     0.200
    56.848     3.356     0.200
    57.261     2.936     0.200
    57.261     2.721     0.200
    57.263     2.959     0.200
    57.386     2.681     0.200
    57.438     2.570     0.200
    57.438     3.199     0.200
    57.438     2.449     0.200
    57.443     3.515     0.200
    57.642     3.015     0.200
    57.702     2.437     0.200
    57.697     3.201     0.200
    57.699     2.796     0.200
    57.712     2.404     0.200
    57.824     3.482     0.200
    57.834     3.181     0.200
    57.841     2.320     0.200
    57.844     2.696     0.200
    57.904     3.254     0.200
    58.068     2.604     0.200
    58.324     2.937     0.200
    58.524     2.603     0.200
    58.612     2.688     0.200
    58.975     2.852     0.200
    59.223     2.558     0.200
    59.275     2.931     0.200
    59.275     1.419     0.200
    59.408     2.781     0.200
    59.904     2.496     0.200
    60.124     2.179     0.200
    60.275     3.951     0.200
    60.275     2.751     0.200
    60.453     3.031     0.200
    60.453     2.363     0.200
    62.970     2.288     0.200
    64.254     2.378     0.200
    65.614     3.262     0.200
    65.614     2.461     0.200
    69.278     2.346     0.200
    71.700     1.914     0.200
    76.015     3.051     0.200
    76.015     2.653     0.200
    78.793     2.610     0.200
    78.793     2.610     0.200
    79.969     4.493     0.200
    80.879     2.221     0.200
    83.097     3.608     0.200
    83.097     2.858     0.200
    83.472     1.726     0.200
    83.595     3.390     0.200
    83.721     3.396     0.200
    83.722     2.002     0.200
    84.108     3.841     0.200
    84.109     3.565     0.200
    84.109     3.842     0.200
    84.109     2.967     0.200
    85.007     2.230     0.200
    85.134     2.086     0.200
    85.134     2.082     0.200
    85.193     3.643     0.200
    85.193     2.799     0.200
    85.402     1.226     0.200
    85.707     2.438     0.200
    85.707     2.438     0.200
    85.707     1.535     0.200
    85.905     2.915     0.200
    85.905     2.055     0.200
    86.107     3.757     0.200
    86.409     3.671     0.200
    86.753     3.743     0.200
    87.203     1.892     0.200
    90.438     3.208     0.200
    90.459     2.634     0.200
    90.891     3.838     0.200
    90.969     1.163     0.200
    90.969     1.163     0.200
    91.075     3.218     0.200
    91.161     4.346     0.200
    91.187     3.340     0.200
    91.522     0.406     0.200
    92.018     2.382     0.200
    92.018     2.382     0.200
    92.353     3.556     0.200
    92.353     2.638     0.200
    92.510     2.631     0.200
    92.637     1.953     0.200
    92.642     3.348     0.200
    92.625     3.297     0.200
    92.657     3.097     0.200
    92.858     3.224     0.200
    93.033     0.387     0.200
    93.641     1.479     0.200
    93.850     2.789     0.200
    93.861     2.806     0.200
    94.974     2.947     0.200
    95.992     0.757     0.200
    96.613     3.008     0.200
    15.304     6.939     0.200
    15.304     6.068     0.200
    15.580     4.602     0.200
    15.682     6.987     0.200
    15.682     3.757     0.200
    15.750     5.209     0.200
    15.750     4.314     0.200
    15.719     8.332     0.200
    16.084     4.126     0.200
    16.084     7.318     0.200
    16.734     4.564     0.200
    17.129     5.665     0.200
    17.129     4.942     0.200
    17.893     1.891     0.200
    18.235     3.322     0.200
    18.215     4.500     0.200
    18.215     3.598     0.200
    18.351     2.954     0.200
    18.604     0.541     0.200
    18.770     1.063     0.200
    18.770     0.539     0.200
    18.935     2.444     0.200
    19.160     1.145     0.200
    19.191     0.854     0.200
    19.406     1.172     0.200
    19.474     1.731     0.200
    19.587     1.375     0.200
    19.587     0.769     0.200
    19.682     1.150     0.200
    20.021     0.890     0.200
    20.151    -0.213     0.200
    20.163     3.412     0.200
    20.163     2.748     0.200
    20.285     0.937     0.200
    20.504     1.417     0.200
    20.504     0.308     0.200
    20.605     2.945     0.200
    20.624     2.969     0.200
    20.766     0.121     0.200
    20.772     1.222     0.200
    20.772     0.980     0.200
    20.922     0.456     0.200
    20.966     0.624     0.200
    20.966    -0.068     0.200
    20.981    -0.368     0.200
    21.040     1.598     0.200
    21.040     0.247     0.200
    20.931     3.329     0.200
    21.049     0.729     0.200
    21.081     0.350     0.200
    21.108     0.553     0.200
    21.108     0.143     0.200
    21.239     0.922     0.200
    21.169     4.959     0.200
    21.169     1.752     0.200
    21.270     0.169     0.200
    21.297     0.613     0.200
    21.279     4.627     0.200
    21.279     4.080     0.200
    21.414     0.220     0.200
    21.437     1.160     0.200
    21.391     3.318     0.200
    21.391     2.111     0.200
    21.406     4.576     0.200
    21.424     4.005     0.200
    21.587     1.281     0.200
    21.495     4.487     0.200
    21.655     0.073     0.200
    21.633     3.117     0.200
    21.730     0.295     0.200
    21.798     1.038     0.200
    21.729     5.069     0.200
    21.763     4.834     0.200
    21.889     0.305     0.200
    21.773     3.976     0.200
    21.914     0.273     0.200
    21.949     1.727     0.200
    21.924     1.526     0.200
    21.956     0.145     0.200
    21.993     1.114     0.200
    22.028     1.875     0.200
    21.925     4.799     0.200
    21.986     3.256     0.200
    22.117    -0.288     0.200
    22.117    -0.030     0.200
    22.156     3.169     0.200
    22.254     0.431     0.200
    22.254    -0.288     0.200
    22.229     2.529     0.200
    22.229     1.267     0.200
    22.271    -0.179     0.200
    22.275     1.705     0.200
    22.275    -0.010     0.200
    22.310     0.134     0.200
    22.339     2.996     0.200
    22.339     0.371     0.200
    22.284     4.366     0.200
    22.284     5.433     0.200
    22.284     3.405     0.200
    22.406     2.418     0.200
    22.291     4.702     0.200
    22.333     2.944     0.200
    22.549     2.982     0.200
    22.552     1.891     0.200
    22.552     0.583     0.200
    22.509     1.985     0.200
    22.573     2.888     0.200
    22.510     2.479     0.200
    22.578     1.879     0.200
    22.578     0.020     0.200
    22.719     0.656     0.200
    22.745    -0.415     0.200
    22.771     0.283     0.200
    22.702     2.275     0.200
    22.713     2.471     0.200
    22.675     4.569     0.200
    22.747     2.452     0.200
    22.759     1.954     0.200
    22.839     2.326     0.200
    22.719     3.920     0.200
    22.775     2.235     0.200
    22.794     2.665     0.200
    22.814     2.338     0.200
    22.819     2.398     0.200
    22.893     0.146     0.200
    22.903     3.322     0.200
    22.848     2.216     0.200
    22.925    -0.633     0.200
    22.864     2.122     0.200
    22.945     1.995     0.200
    23.051     1.635     0.200
    23.058     4.239     0.200
    23.091     1.321     0.200
    23.024     2.340     0.200
    23.080     2.329     0.200
    23.058     3.285     0.200
    23.153     0.020     0.200
    23.153    -0.421     0.200
    23.172     1.892     0.200
    23.185     0.563     0.200
    23.083     4.499     0.200
    23.242     2.296     0.200
    23.242     0.757     0.200
    23.206     3.707     0.200
    23.238     3.095     0.200
    23.402     1.915     0.200
    23.400     0.457     0.200
    23.305     4.874     0.200
    23.403     2.519     0.200
    23.403     1.828     0.200
    23.346     4.407     0.200
    23.543     1.563     0.200
    23.543     0.762     0.200
    23.603     0.662     0.200
    23.652     2.020     0.200
    23.727     2.258     0.200
    23.733     0.310     0.200
    23.744     0.440     0.200
    23.743     0.209     0.200
    23.659     4.133     0.200
    23.749     2.455     0.200
    23.669     3.917     0.200
    23.759     2.271     0.200
    23.691     4.667     0.200
    23.691     3.675     0.200
    23.739     4.024     0.200
    23.730     3.283     0.200
    23.710     4.059     0.200
    23.842     4.701     0.200
    23.967     0.588     0.200
    23.967     0.080     0.200
    23.977     0.747     0.200
    23.977     0.294     0.200
    23.977     0.777     0.200
    23.978     2.309     0.200
    24.013     2.755     0.200
    24.061     2.920     0.200
    24.108     2.084     0.200
    24.155     2.622     0.200
    24.075     3.274     0.200
    24.078     4.317     0.200
    24.209     1.755     0.200
    24.210     3.346     0.200
    24.210     2.831     0.200
    24.233     2.140     0.200
    24.235     1.158     0.200
    24.239     0.660     0.200
    24.251     1.493     0.200
    24.272     1.811     0.200
    24.285     2.916     0.200
    24.285     1.193     0.200
    24.264     3.197     0.200
    24.293     4.090     0.200
    24.293     2.540     0.200
    24.316     4.912     0.200
    24.411     2.989     0.200
    24.412     3.507     0.200
    24.510     2.401     0.200
    24.526     2.136     0.200
    24.526     1.050     0.200
    24.531     2.533     0.200
    24.542     1.505     0.200
    24.542     0.947     0.200
    24.543     1.773     0.200
    24.526     3.344     0.200
    24.526     2.824     0.200
    24.591     2.839     0.200
    24.571     2.328     0.200
    24.630     1.326     0.200
    24.631     2.018     0.200
    24.640     2.266     0.200
    24.624     4.940     0.200
    24.624     4.440     0.200
    24.622     4.810     0.200
    24.779     1.996     0.200
    24.779     1.348     0.200
    24.855     2.520     0.200
    24.774     3.576     0.200
    24.746     5.364     0.200
    24.840     2.357     0.200
    24.968     1.826     0.200
    24.987     1.123     0.200
    24.903     4.697     0.200
    24.903     4.154     0.200
    25.034     3.292     0.200
    25.034     1.471     0.200
    25.057     2.972     0.200
    25.232     1.523     0.200
    25.239     1.169     0.200
    25.248     1.679     0.200
    25.248     0.777     0.200
    25.201     3.224     0.200
    25.185     3.593     0.200
    25.191     5.028     0.200
    25.334     2.403     0.200
    25.334     1.204     0.200
    25.337     1.760     0.200
    25.337     1.072     0.200
    25.227     4.661     0.200
    25.349     1.855     0.200
    25.358     1.985     0.200
    25.358     0.989     0.200
    25.369     1.916     0.200
    25.395     2.244     0.200
    25.446     1.391     0.200
    25.446     0.977     0.200
    25.454     2.741     0.200
    25.454     1.671     0.200
    25.480     1.475     0.200
    25.397     5.046     0.200
    25.397     3.956     0.200
    25.384     5.129     0.200
    25.537     3.097     0.200
    25.609     2.169     0.200
    25.609     1.458     0.200
    25.609     2.672     0.200
    25.609     0.309     0.200
    25.630     1.941     0.200
    25.647     2.746     0.200
    25.582     5.368     0.200
    25.701     1.054     0.200
    25.733     1.822     0.200
    25.733     1.474     0.200
    25.800     2.056     0.200
    25.855     1.416     0.200
    25.782     3.981     0.200
    25.782     2.891     0.200
    25.882     2.309     0.200
    25.977     2.036     0.200
    26.005     1.753     0.200
    26.051     1.782     0.200
    26.092     1.302     0.200
    26.131     1.943     0.200
    26.011     3.424     0.200
    26.164     2.386     0.200
    26.115     2.135     0.200
    26.222     1.981     0.200
    26.295     1.696     0.200
    26.295     1.160     0.200
    26.312     1.374     0.200
    26.353     1.616     0.200
    26.333     3.759     0.200
    26.333     1.974     0.200
    26.462     2.191     0.200
    26.538     1.462     0.200
    26.538     0.630     0.200
    26.569     2.313     0.200
    26.569     0.973     0.200
    26.501     2.923     0.200
    26.605     1.382     0.200
    26.605     0.648     0.200
    26.656     1.740     0.200
    26.656     0.369     0.200
    26.576     3.871     0.200
    26.582     3.249     0.200
    26.705     2.096     0.200
    26.705     1.174     0.200
    26.633     2.367     0.200
    26.720     1.439     0.200
    26.736     2.412     0.200
    26.736     1.580     0.200
    26.639     3.823     0.200
    26.787     1.552     0.200
    26.835     2.372     0.200
    26.847     2.322     0.200
    26.807     4.468     0.200
    26.807     4.468     0.200
    26.807     4.187     0.200
    26.830     5.876     0.200
    27.006     2.593     0.200
    27.011     2.694     0.200
    27.015     1.616     0.200
    27.015     0.678     0.200
    27.020     1.351     0.200
    27.000     3.259     0.200
    27.000     1.998     0.200
    27.024     1.345     0.200
    27.024     0.813     0.200
    27.033     1.441     0.200
    27.033     0.223     0.200
    27.084     2.182     0.200
    27.103     2.224     0.200
    27.107     2.167     0.200
    26.994     6.103     0.200
    27.102     3.709     0.200
    27.102     2.896     0.200
    27.102     3.034     0.200
    27.102     2.776     0.200
    27.102     2.237     0.200
    27.070     4.187     0.200
    27.073     3.690     0.200
    27.164     2.842     0.200
    27.272     2.365     0.200
    27.171     4.013     0.200
    27.277     1.010     0.200
    27.208     3.492     0.200
    27.301     0.913     0.200
    27.305     2.284     0.200
    27.321     4.076     0.200
    27.342     2.372     0.200
    27.427     3.394     0.200
    27.418     4.526     0.200
    27.548     1.849     0.200
    27.464     4.519     0.200
    27.601     1.109     0.200
    27.657     2.413     0.200
    27.657     1.983     0.200
    27.662     1.685     0.200
    27.662     1.142     0.200
    27.670     2.465     0.200
    27.556     5.349     0.200
    27.684     1.274     0.200
    27.684     0.985     0.200
    27.751     1.283     0.200
    27.654     3.828     0.200
    27.772     1.166     0.200
    27.776     3.552     0.200
    27.776     2.474     0.200
    27.710     3.824     0.200
    27.862     1.740     0.200
    27.822     3.395     0.200
    27.929     1.465     0.200
    27.929     0.520     0.200
    27.961     2.239     0.200
    27.961     0.935     0.200
    28.001     2.495     0.200
    27.976     4.687     0.200
    28.118     1.403     0.200
    28.118     1.114     0.200
    28.067     3.138     0.200
    28.146     2.797     0.200
    28.147     3.478     0.200
    28.226     2.729     0.200
    28.165     3.822     0.200
    28.228     1.208     0.200
    28.289     2.540     0.200
    28.289     1.361     0.200
    28.304     2.822     0.200
    28.329     3.127     0.200
    28.397     2.460     0.200
    28.319     4.882     0.200
    28.430     1.705     0.200
    28.573     2.732     0.200
    28.520     2.477     0.200
    28.611     0.747     0.200
    28.628     3.385     0.200
    28.693     2.580     0.200
    28.709     2.941     0.200
    28.709     1.840     0.200
    28.730     1.983     0.200
    28.730     0.897     0.200
    28.620     4.261     0.200
    28.822     1.061     0.200
    28.878     2.319     0.200
    28.983     2.257     0.200
    28.983     0.421     0.200
    29.046     1.939     0.200
    29.046     1.329     0.200
    28.945     4.487     0.200
    29.000     2.684     0.200
    29.140     2.676     0.200
    29.227     3.384     0.200
    29.277     1.220     0.200
    29.181     4.228     0.200
    29.257     3.537     0.200
    29.257     2.966     0.200
    29.469     3.772     0.200
    29.672     2.342     0.200
    29.869     1.815     0.200
    29.869     0.252     0.200
    29.914     1.894     0.200
    29.914     1.765     0.200
    29.850     4.533     0.200
    29.921     3.993     0.200
    30.058     3.952     0.200
    30.058     1.073     0.200
    30.080     2.412     0.200
    30.023     5.001     0.200
    30.137     1.360     0.200
    30.246     1.361     0.200
    30.246     0.947     0.200
    30.279     3.954     0.200
    30.279     3.442     0.200
    30.382     2.125     0.200
    30.333     3.194     0.200
    30.520     1.758     0.200
    30.428     3.133     0.200
    30.540     2.172     0.200
    30.649     1.298     0.200
    30.649     0.540     0.200
    30.673     1.556     0.200
    30.673     0.821     0.200
    30.718     1.821     0.200
    30.722     2.010     0.200
    30.772     1.239     0.200
    30.807     1.990     0.200
    30.985     1.629     0.200
    30.985     1.078     0.200
    30.955     1.671     0.200
    31.187     1.385     0.200
    31.108     4.305     0.200
    31.267     2.223     0.200
    31.194     3.246     0.200
    31.441     1.841     0.200
    31.441     1.118     0.200
    31.361     3.223     0.200
    31.480     2.835     0.200
    31.594     2.226     0.200
    31.594     1.003     0.200
    31.640     1.644     0.200
    31.640     1.300     0.200
    31.752     2.689     0.200
    31.828     1.720     0.200
    31.846     0.814     0.200
    31.905     2.710     0.200
    31.905    -0.056     0.200
    31.923     4.667     0.200
    32.054     1.745     0.200
    32.071     0.738     0.200
    32.057     3.123     0.200
    32.057     2.252     0.200
    32.123     2.623     0.200
    32.123     2.072     0.200
    32.257     2.749     0.200
    32.387     1.289     0.200
    32.398     2.623     0.200
    32.512     1.766     0.200
    32.498     2.972     0.200
    32.621     1.906     0.200
    32.654     2.634     0.200
    32.981     0.621     0.200
    32.981     0.914     0.200
    33.037     0.852     0.200
    32.986     2.657     0.200
    33.084     1.295     0.200
    33.162     2.368     0.200
    33.224     2.104     0.200
    33.175     4.825     0.200
    33.262     3.887     0.200
    33.395     1.607     0.200
    33.463     5.078     0.200
    33.530     0.984     0.200
    33.530     1.801     0.200
    33.570     3.029     0.200
    33.806     5.089     0.200
    33.940     1.278     0.200
    33.998     2.041     0.200
    33.942     2.295     0.200
    34.028     4.954     0.200
    34.074     2.398     0.200
    34.220     0.402     0.200
    34.222     1.419     0.200
    34.314     1.402     0.200
    34.330     1.848     0.200
    34.330     3.379     0.200
    34.330     2.496     0.200
    34.329     3.377     0.200
    34.466     2.574     0.200
    34.718     0.987     0.200
    34.789     3.740     0.200
    34.875     1.629     0.200
    34.856     3.358     0.200
    35.138     1.941     0.200
    35.182     2.282     0.200
    35.471     0.836     0.200
    36.016     3.721     0.200
    36.213     4.316     0.200
    36.171     3.081     0.200
    36.357     0.587     0.200
    36.863     0.389     0.200
    36.781     3.425     0.200
    37.257     0.066     0.200
    37.550     1.557     0.200
    37.615     3.053     0.200
    37.615     2.233     0.200
    37.867     1.975     0.200
    38.703     1.967     0.200
    39.219     1.978     0.200
    39.519     1.847     0.200
    39.642     1.802     0.200
    41.329     1.980     0.200
    45.556     4.819     0.200
    45.751     1.573     0.200
    45.751     1.679     0.200
    46.756     1.124     0.200
    46.756     0.808     0.200
    46.756     1.129     0.200
    46.822     1.603     0.200
    47.072     4.028     0.200
    51.653     2.099     0.200
    53.425     3.578     0.200
    53.549     3.202     0.200
    53.872     4.278     0.200
    54.214     3.774     0.200
    54.260     2.527     0.200
    54.434     3.162     0.200
    54.729     3.846     0.200
    54.907     3.788     0.200
    55.046     3.206     0.200
    55.046     2.518     0.200
    55.058     3.290     0.200
    55.308     2.727     0.200
    55.605     3.290     0.200
    55.664     2.116     0.200
    55.729     3.227     0.200
    55.774     3.689     0.200
    55.851     3.831     0.200
    56.074     2.772     0.200
    56.225     2.968     0.200
    56.333     3.216     0.200
    56.385     3.400     0.200
    56.401     3.433     0.200
    56.444     3.097     0.200
    56.449     3.083     0.200
    56.451     2.334     0.200
    56.512     3.204     0.200
    57.058     3.228     0.200
    57.084     3.248     0.200
    57.084     2.967     0.200
    57.219     3.333     0.200
    57.256     2.950     0.200
    57.264     2.713     0.200
    57.264     2.674     0.200
    57.264     2.432     0.200
    57.457     3.026     0.200
    57.482     3.236     0.200
    57.524     2.068     0.200
    57.533     2.938     0.200
    57.631     3.023     0.200
    57.651     3.337     0.200
    57.835     3.044     0.200
    57.847     2.780     0.200
    57.885     2.614     0.200
    57.955     0.936     0.200
    57.955     1.350     0.200
    57.951     3.166     0.200
    58.065     2.889     0.200
    58.133     2.773     0.200
    58.327     2.999     0.200
    58.426     2.521     0.200
    58.528     2.419     0.200
    58.796     2.674     0.200
    59.008     2.039     0.200
    59.740     3.060     0.200
    60.300     2.870     0.200
    60.356     1.739     0.200
    60.658     2.021     0.200
    63.489     4.150     0.200
    78.860     1.349     0.200
    78.860     1.353     0.200
    83.840     3.154     0.200
    83.842     3.147     0.200
    84.046     2.268     0.200
    85.318     2.202     0.200
    85.318     2.206     0.200
    85.818     2.234     0.200
    85.818     2.231     0.200
    91.124     1.476     0.200
    91.124     1.480     0.200
    92.184     2.560     0.200
    92.269     2.784     0.200
    92.269     2.788     0.200
    93.084     3.092     0.200
    97.221     3.035     0.200
    97.225     3.012     0.200
    18.658     3.065     0.200
    18.759     2.437     0.200
    19.502     3.491     0.200
    19.878     1.207     0.200
    20.062     3.442     0.200
    20.100     1.215     0.200
    20.294     3.293     0.200
    20.950     4.095     0.200
    21.090     2.657     0.200
    22.842     3.523     0.200
    23.097     1.714     0.200
    23.438     3.751     0.200
    23.758     3.174     0.200
    24.010     3.175     0.200
    24.785     3.720     0.200
    26.555     4.397     0.200
    26.632     4.638     0.200
    26.632     3.747     0.200
    26.820     2.825     0.200
    26.820     2.271     0.200
    26.988     4.080     0.200
    30.510     3.489     0.200
    46.442     1.182     0.200
    55.375     1.926     0.200
    57.017     2.852     0.200
    14.120     9.907     0.200
    15.328     7.102     0.200
    15.778     6.881     0.200
    16.892     1.216     0.200
    17.007     3.254     0.200
    16.938     5.077     0.200
    17.364     4.393     0.200
    17.607     1.490     0.200
    17.609     3.053     0.200
    17.870     1.701     0.200
    17.911     0.944     0.200
    17.944     1.717     0.200
    18.427     4.282     0.200
    18.427     3.786     0.200
    18.582     1.034     0.200
    18.562     1.655     0.200
    19.144     2.845     0.200
    19.086     2.622     0.200
    19.086     3.556     0.200
    19.294     1.031     0.200
    19.419     1.962     0.200
    19.506     0.116     0.200
    19.544     1.173     0.200
    19.571     1.530     0.200
    19.749     0.844     0.200
    19.911     2.271     0.200
    19.991    -0.562     0.200
    19.919     4.148     0.200
    20.031     1.455     0.200
    20.142     0.798     0.200
    20.196     1.139     0.200
    20.294    -0.244     0.200
    20.302     0.768     0.200
    20.301     0.871     0.200
    20.347     4.077     0.200
    20.482     1.174     0.200
    20.482     1.447     0.200
    20.356     4.101     0.200
    20.536     1.555     0.200
    20.598     0.611     0.200
    20.472     2.611     0.200
    20.725     2.172     0.200
    20.725     3.457     0.200
    20.858     0.860     0.200
    20.906    -1.096     0.200
    20.966     0.848     0.200
    20.843     3.737     0.200
    21.011     0.976     0.200
    21.115     0.830     0.200
    21.214     1.158     0.200
    21.167     4.935     0.200
    21.167     4.673     0.200
    21.390    -0.878     0.200
    21.364     3.333     0.200
    21.364     4.993     0.200
    21.521     2.434     0.200
    21.521     2.965     0.200
    21.609     0.929     0.200
    21.632     1.223     0.200
    21.804     0.731     0.200
    21.845     0.934     0.200
    21.719     4.847     0.200
    21.794     3.180     0.200
    21.794     3.055     0.200
    21.825     3.589     0.200
    22.040     1.021     0.200
    22.040     1.619     0.200
    22.146     0.921     0.200
    22.173     1.153     0.200
    22.173     1.868     0.200
    22.165     0.742     0.200
    22.170     0.863     0.200
    22.224     1.429     0.200
    22.156     4.436     0.200
    22.202     4.653     0.200
    22.325     1.783     0.200
    22.471     0.745     0.200
    22.459     1.208     0.200
    22.448     0.945     0.200
    22.522     1.156     0.200
    22.530     3.494     0.200
    22.680     1.296     0.200
    22.528     4.283     0.200
    22.526     4.613     0.200
    22.526     4.203     0.200
    22.706     0.417     0.200
    22.905     4.461     0.200
    23.074     0.439     0.200
    23.076     0.826     0.200
    23.124     0.143     0.200
    23.219     2.733     0.200
    23.255     3.766     0.200
    23.253     5.739     0.200
    23.433     0.727     0.200
    23.465     0.814     0.200
    23.316     5.131     0.200
    23.397     3.404     0.200
    23.438     3.393     0.200
    23.606     1.568     0.200
    23.528     2.114     0.200
    23.528     2.556     0.200
    23.629     0.570     0.200
    23.629     1.351     0.200
    23.678    -0.072     0.200
    23.532     4.525     0.200
    23.685    -0.118     0.200
    23.862     0.737     0.200
    23.856     4.160     0.200
    23.855     3.584     0.200
    23.938     3.885     0.200
    23.946     3.693     0.200
    24.106     1.518     0.200
    24.136     2.069     0.200
    24.163     1.142     0.200
    24.068     4.071     0.200
    24.182     3.134     0.200
    24.300     1.483     0.200
    24.259     3.718     0.200
    24.417     1.853     0.200
    24.417     2.587     0.200
    24.467     2.217     0.200
    24.467     2.736     0.200
    24.320     4.372     0.200
    24.505     0.866     0.200
    24.439     4.187     0.200
    24.643     2.544     0.200
    24.627     1.486     0.200
    24.581     2.722     0.200
    24.552     5.031     0.200
    24.650     3.419     0.200
    24.601     3.498     0.200
    24.807     4.516     0.200
    24.844     4.172     0.200
    24.844     4.781     0.200
    24.959     2.759     0.200
    24.970     3.453     0.200
    25.101     0.817     0.200
    25.203     2.361     0.200
    25.237     1.193     0.200
    25.142     3.504     0.200
    25.142     4.789     0.200
    25.212     3.254     0.200
    25.390     1.092     0.200
    25.464     0.708     0.200
    25.374     3.317     0.200
    25.479     4.034     0.200
    25.460     4.572     0.200
    25.470     5.206     0.200
    25.606     3.466     0.200
    25.606     4.606     0.200
    25.625     5.015     0.200
    25.809     2.258     0.200
    26.031     1.272     0.200
    25.963     2.440     0.200
    25.963     4.175     0.200
    25.984     4.822     0.200
    26.233     0.726     0.200
    26.283     0.870     0.200
    26.202     3.197     0.200
    26.541     1.306     0.200
    26.610     0.878     0.200
    26.610     2.417     0.200
    26.632    -1.111     0.200
    26.773     3.217     0.200
    26.733     5.309     0.200
    26.938     0.587     0.200
    26.942     0.690     0.200
    26.962     1.193     0.200
    27.039     2.095     0.200
    26.912     4.818     0.200
    27.138     2.365     0.200
    27.004     4.352     0.200
    27.029     5.056     0.200
    27.249     2.061     0.200
    27.249     3.299     0.200
    27.326     0.850     0.200
    27.249     2.741     0.200
    27.249     3.311     0.200
    27.292     4.045     0.200
    27.337     2.881     0.200
    27.401     4.639     0.200
    27.401     3.116     0.200
    27.538    -0.336     0.200
    27.389     3.565     0.200
    27.679     2.714     0.200
    27.831     1.831     0.200
    27.691     4.250     0.200
    27.934     3.501     0.200
    28.024     2.408     0.200
    28.155     2.631     0.200
    28.220     2.893     0.200
    28.201     4.748     0.200
    28.316     3.011     0.200
    28.681     2.139     0.200
    28.977     1.746     0.200
    29.394     2.728     0.200
    29.394     3.490     0.200
    29.448     1.037     0.200
    29.472     2.305     0.200
    29.480     2.874     0.200
    29.480     3.792     0.200
    29.800     2.076     0.200
    29.755     2.032     0.200
    29.794     3.589     0.200
    29.880     3.377     0.200
    30.082     2.696     0.200
    30.118     2.874     0.200
    30.261     3.480     0.200
    30.335     1.808     0.200
    30.335     2.734     0.200
    30.425     2.124     0.200
    30.430     2.452     0.200
    30.430     3.663     0.200
    31.020     2.682     0.200
    31.020     1.967     0.200
    31.328     4.368     0.200
    31.371     2.891     0.200
    31.512     3.307     0.200
    31.664     2.934     0.200
    31.749     2.495     0.200
    31.848     2.242     0.200
    31.882     1.901     0.200
    31.951     3.265     0.200
    32.198     2.584     0.200
    32.254     2.395     0.200
    32.254     3.859     0.200
    32.540     2.574     0.200
    32.636     1.921     0.200
    32.527     4.722     0.200
    32.577     3.006     0.200
    32.689     2.734     0.200
    33.044     2.462     0.200
    33.112     1.635     0.200
    33.396     4.799     0.200
    33.572     0.767     0.200
    33.478     3.822     0.200
    33.638     3.251     0.200
    34.111     2.006     0.200
    34.202     1.947     0.200
    34.344     3.167     0.200
    34.226     4.874     0.200
    34.499     3.301     0.200
    34.499     2.313     0.200
    34.505     2.554     0.200
    34.541     4.025     0.200
    34.978     3.633     0.200
    35.052     3.492     0.200
    35.674     3.350     0.200
    36.213     3.436     0.200
    37.489     1.897     0.200
    37.945     1.720     0.200
    39.402     2.494     0.200
    45.678     0.826     0.200
    45.678     1.474     0.200
    46.872     1.716     0.200
    54.427     2.965     0.200
    54.610     2.769     0.200
    54.623     3.047     0.200
    54.623     3.856     0.200
    55.311     4.089     0.200
    55.475     2.417     0.200
    55.475     2.694     0.200
    55.782     3.348     0.200
    55.805     2.950     0.200
    55.805     2.598     0.200
    55.805     2.735     0.200
    55.911     3.232     0.200
    55.911     3.513     0.200
    55.949     3.049     0.200
    56.637     2.800     0.200
    57.108     2.843     0.200
    57.389     3.556     0.200
    57.389     3.341     0.200
    57.440     2.358     0.200
    57.440     2.979     0.200
    57.440     2.499     0.200
    57.440     3.688     0.200
    57.687     3.265     0.200
    57.825     2.891     0.200
    58.531     2.521     0.200
    58.531     3.028     0.200
    58.975     2.686     0.200
    58.975     3.018     0.200
    59.908     4.219     0.200
    60.461     3.580     0.200
    83.088     3.683     0.200
    83.855     2.914     0.200
    84.076     3.202     0.200
    85.796     1.725     0.200
    85.926     1.974     0.200
    85.926     1.767     0.200
    15.853     3.468     0.200
    17.590     2.953     0.200
    17.884     2.272     0.200
    18.105     2.958     0.200
    18.228     1.982     0.200
    18.260     1.657     0.200
    18.821     2.310     0.200
    18.988     1.644     0.200
    19.218     1.946     0.200
    19.220     1.759     0.200
    19.614     1.759     0.200
    19.932     1.673     0.200
    19.978     1.663     0.200
    20.216     2.038     0.200
    20.420     2.633     0.200
    20.561    -0.157     0.200
    20.659     0.890     0.200
    21.103     3.105     0.200
    21.220     2.538     0.200
    21.508     1.783     0.200
    21.509     2.077     0.200
    21.731     0.929     0.200
    21.860     0.090     0.200
    21.870    -0.141     0.200
    22.012     1.551     0.200
    22.137     1.471     0.200
    22.173     1.369     0.200
    22.995     2.665     0.200
    23.137     2.234     0.200
    23.335    -0.217     0.200
    23.335     0.740     0.200
    23.568     1.754     0.200
    23.872     1.753     0.200
    23.902     3.574     0.200
    24.146     2.803     0.200
    24.300     3.457     0.200
    24.917     1.540     0.200
    24.936     1.577     0.200
    24.923     1.481     0.200
    25.042     2.618     0.200
    25.369     3.026     0.200
    25.924     2.235     0.200
    26.147     2.392     0.200
    26.247     2.838     0.200
    26.301     1.450     0.200
    26.490     2.870     0.200
    26.648     2.238     0.200
    26.715     3.182     0.200
    26.791     5.135     0.200
    26.955     2.749     0.200
    26.955     3.312     0.200
    26.955     2.722     0.200
    26.955     2.862     0.200
    27.246     2.827     0.200
    28.025     2.087     0.200
    30.131     1.985     0.200
    31.304     1.635     0.200
    45.368     0.571     0.200
    45.368     1.376     0.200
    45.482     2.940     0.200
    46.965     6.016     0.200
    55.508     1.776     0.200
    57.162     3.072     0.200
    14.626     6.137     0.200
    15.100     5.387     0.200
    15.100     4.871     0.200
    16.269     4.232     0.200
    16.292     6.295     0.200
    16.979     3.387     0.200
    17.161     3.217     0.200
    17.182     4.224     0.200
    17.471     4.125     0.200
    17.471     3.508     0.200
    17.718     4.921     0.200
    17.768     5.297     0.200
    17.768     3.344     0.200
    18.232     0.885     0.200
    18.294     0.775     0.200
    18.308     0.321     0.200
    18.308     0.758     0.200
    18.439     2.429     0.200
    18.448     1.604     0.200
    18.621     0.914     0.200
    18.679     0.789     0.200
    18.753     1.762     0.200
    18.753     2.301     0.200
    18.827     1.467     0.200
    18.848     2.080     0.200
    18.867    -0.381     0.200
    18.920     0.569     0.200
    19.008     0.896     0.200
    19.029     0.354     0.200
    19.100     1.745     0.200
    19.100    -0.044     0.200
    19.114     1.611     0.200
    19.154     3.150     0.200
    19.213     1.310     0.200
    19.257     1.443     0.200
    19.272     1.838     0.200
    19.363     1.278     0.200
    19.471     0.975     0.200
    19.506     0.961     0.200
    19.589     1.205     0.200
    19.768     1.240     0.200
    19.797     1.112     0.200
    19.802     1.348     0.200
    19.821     1.333     0.200
    19.837     0.830     0.200
    19.857    -1.228     0.200
    19.951     1.993     0.200
    19.958     1.104     0.200
    20.013     0.782     0.200
    20.037     1.365     0.200
    20.053     1.382     0.200
    20.067     1.459     0.200
    20.067     1.873     0.200
    20.077     1.478     0.200
    20.077     1.072     0.200
    20.114     1.723     0.200
    20.113     1.522     0.200
    20.120     0.876     0.200
    20.119     0.840     0.200
    20.152     1.786     0.200
    20.162     1.383     0.200
    20.222     2.560     0.200
    20.227     2.106     0.200
    20.253     2.113     0.200
    20.256     1.361     0.200
    20.252     1.094     0.200
    20.267     1.310     0.200
    20.296     2.196     0.200
    20.435     2.254     0.200
    20.435     3.012     0.200
    20.419     1.457     0.200
    20.433     0.716     0.200
    20.481     2.014     0.200
    20.539     2.118     0.200
    20.696     3.560     0.200
    20.696     3.114     0.200
    20.726     2.353     0.200
    20.730     1.339     0.200
    20.846     0.693     0.200
    20.978     1.424     0.200
    21.054     1.603     0.200
    21.069     0.466     0.200
    21.099     1.494     0.200
    21.111     1.053     0.200
    21.128     4.307     0.200
    21.145     1.197     0.200
    21.167     1.063     0.200
    21.200     1.029     0.200
    21.254     0.583     0.200
    21.289     0.976     0.200
    21.333     0.778     0.200
    21.377     2.919     0.200
    21.405     1.750     0.200
    21.404     1.170     0.200
    21.504     1.189     0.200
    21.506     0.375     0.200
    21.506     0.610     0.200
    21.513     0.695     0.200
    21.513     1.445     0.200
    21.518     3.541     0.200
    21.518     4.744     0.200
    21.520     3.445     0.200
    21.520     2.601     0.200
    21.572     4.837     0.200
    21.572     4.681     0.200
    21.583     0.627     0.200
    21.604    -0.053     0.200
    21.606     1.873     0.200
    21.805     1.473     0.200
    21.805     1.738     0.200
    21.864     3.829     0.200
    21.872     0.503     0.200
    21.890     3.487     0.200
    21.890     2.667     0.200
    21.900     3.446     0.200
    21.971     0.611     0.200
    21.989     2.121     0.200
    22.023     3.960     0.200
    22.040     4.533     0.200
    22.040     4.399     0.200
    22.060     0.724     0.200
    22.077     1.543     0.200
    22.094     0.190     0.200
    22.094     0.760     0.200
    22.115     1.056     0.200
    22.173     0.397     0.200
    22.173     0.163     0.200
    22.227     2.156     0.200
    22.227     2.453     0.200
    22.258    -0.054     0.200
    22.306     4.752     0.200
    22.314     4.145     0.200
    22.361     0.271     0.200
    22.393     0.401     0.200
    22.397     4.564     0.200
    22.419     3.527     0.200
    22.466     1.349     0.200
    22.482     4.045     0.200
    22.486     4.359     0.200
    22.500     0.531     0.200
    22.540     0.536     0.200
    22.560     4.924     0.200
    22.608     2.454     0.200
    22.631     4.382     0.200
    22.713     0.391     0.200
    22.742     4.295     0.200
    22.785     1.917     0.200
    22.785     2.128     0.200
    22.808     1.224     0.200
    22.802     1.384     0.200
    22.828     1.223     0.200
    22.833     4.435     0.200
    22.833     3.263     0.200
    22.880     4.168     0.200
    22.889     4.541     0.200
    22.896     4.312     0.200
    22.896     4.421     0.200
    22.918     0.564     0.200
    22.966     1.650     0.200
    23.012     1.593     0.200
    23.012     1.234     0.200
    23.087     0.105     0.200
    23.231     4.018     0.200
    23.246     1.099     0.200
    23.244     2.139     0.200
    23.293    -0.604     0.200
    23.342     0.650     0.200
    23.342     1.056     0.200
    23.349     4.116     0.200
    23.432     1.020     0.200
    23.468     3.586     0.200
    23.477     1.348     0.200
    23.509     2.611     0.200
    23.509     3.017     0.200
    23.532     2.082     0.200
    23.537     0.881     0.200
    23.562     1.019     0.200
    23.589     2.970     0.200
    23.617     4.219     0.200
    23.655     5.550     0.200
    23.661     3.296     0.200
    23.692     0.902     0.200
    23.790     1.893     0.200
    23.811     1.132     0.200
    23.811     2.272     0.200
    23.838     5.125     0.200
    23.848     4.009     0.200
    23.934     1.225     0.200
    23.934     1.077     0.200
    23.983     1.161     0.200
    23.983     1.740     0.200
    24.007     1.453     0.200
    24.009     4.887     0.200
    24.065     3.474     0.200
    24.034     4.312     0.200
    24.057     1.209     0.200
    24.062     4.234     0.200
    24.072     2.748     0.200
    24.072     3.427     0.200
    24.079     4.357     0.200
    24.121     2.829     0.200
    24.121     4.469     0.200
    24.124     4.700     0.200
    24.153     4.396     0.200
    24.163     2.161     0.200
    24.178     2.040     0.200
    24.222     3.668     0.200
    24.261     3.146     0.200
    24.261     5.083     0.200
    24.275     1.267     0.200
    24.298     3.402     0.200
    24.301     3.275     0.200
    24.345     2.936     0.200
    24.374     3.971     0.200
    24.380     4.912     0.200
    24.394     1.788     0.200
    24.394     1.944     0.200
    24.428     4.021     0.200
    24.436     4.032     0.200
    24.458     1.587     0.200
    24.486     3.877     0.200
    24.486     3.541     0.200
    24.492     5.065     0.200
    24.553     1.608     0.200
    24.585     3.262     0.200
    24.629     2.148     0.200
    24.624     3.635     0.200
    24.630     3.454     0.200
    24.649     1.859     0.200
    24.657     0.940     0.200
    24.655     3.493     0.200
    24.661     3.371     0.200
    24.688     3.915     0.200
    24.693     0.830     0.200
    24.701     0.368     0.200
    24.699     3.805     0.200
    24.718     3.831     0.200
    24.743     2.462     0.200
    24.763     3.522     0.200
    24.789     2.171     0.200
    24.794     1.878     0.200
    24.801     2.183     0.200
    24.808     3.772     0.200
    24.823     1.864     0.200
    24.849     0.664     0.200
    24.855     3.651     0.200
    24.901     5.268     0.200
    24.980     3.406     0.200
    24.968     1.619     0.200
    24.970     4.879     0.200
    24.970     4.489     0.200
    25.039     1.906     0.200
    25.115     1.525     0.200
    25.118     4.588     0.200
    25.175     5.039     0.200
    25.202     1.271     0.200
    25.177     2.868     0.200
    25.186     4.750     0.200
    25.300     3.208     0.200
    25.286     3.453     0.200
    25.337     0.228     0.200
    25.362     1.839     0.200
    25.367     5.707     0.200
    25.378     1.751     0.200
    25.523     1.645     0.200
    25.498     5.296     0.200
    25.500     3.973     0.200
    25.500     5.137     0.200
    25.505     3.557     0.200
    25.508     1.478     0.200
    25.508     1.611     0.200
    25.625     3.227     0.200
    25.599     2.790     0.200
    25.621     3.852     0.200
    25.673     3.217     0.200
    25.691     1.835     0.200
    25.691     1.600     0.200
    25.772     3.570     0.200
    25.839     5.234     0.200
    25.852     4.021     0.200
    25.875     2.008     0.200
    25.896     0.713     0.200
    25.922     2.292     0.200
    25.951     3.132     0.200
    25.971     2.207     0.200
    25.971     2.691     0.200
    25.990     5.430     0.200
    25.997     2.010     0.200
    26.121     3.556     0.200
    26.121     4.743     0.200
    26.121     4.610     0.200
    26.125     2.394     0.200
    26.104     3.635     0.200
    26.106     0.544     0.200
    26.117     3.695     0.200
    26.117     4.515     0.200
    26.172     4.390     0.200
    26.139     3.133     0.200
    26.155     3.574     0.200
    26.155     1.106     0.200
    26.157     1.018     0.200
    26.213     0.834     0.200
    26.221     5.170     0.200
    26.329     5.463     0.200
    26.307     3.599     0.200
    26.362     4.932     0.200
    26.332     1.877     0.200
    26.362     1.062     0.200
    26.362     2.594     0.200
    26.373     1.199     0.200
    26.420     3.029     0.200
    26.419     1.635     0.200
    26.419     2.081     0.200
    26.391     3.651     0.200
    26.399     1.474     0.200
    26.435     3.132     0.200
    26.435     3.585     0.200
    26.483     4.085     0.200
    26.455     0.518     0.200
    26.495    -0.778     0.200
    26.485     3.666     0.200
    26.487     4.500     0.200
    26.563     6.568     0.200
    26.540     1.357     0.200
    26.600     2.600     0.200
    26.598     3.839     0.200
    26.598     2.519     0.200
    26.643     4.202     0.200
    26.791     3.172     0.200
    26.781     1.644     0.200
    26.826     3.133     0.200
    26.867     1.361     0.200
    26.867     2.455     0.200
    26.894     3.384     0.200
    26.878     3.234     0.200
    26.912     2.434     0.200
    26.929     1.896     0.200
    26.929     5.271     0.200
    26.923     2.049     0.200
    26.925     1.385     0.200
    26.927     1.686     0.200
    26.927     2.749     0.200
    26.935     3.414     0.200
    27.017     1.686     0.200
    27.059     2.021     0.200
    27.080     1.886     0.200
    27.184     5.011     0.200
    27.183     2.171     0.200
    27.195     4.624     0.200
    27.227     1.099     0.200
    27.237    -0.983     0.200
    27.325     5.503     0.200
    27.296     4.743     0.200
    27.295     3.573     0.200
    27.295     3.003     0.200
    27.295     3.184     0.200
    27.295     2.496     0.200
    27.295     2.730     0.200
    27.307     3.457     0.200
    27.325     3.293     0.200
    27.325     3.980     0.200
    27.392     2.721     0.200
    27.418     1.774     0.200
    27.439     1.893     0.200
    27.439     3.346     0.200
    27.471     2.345     0.200
    27.465     3.260     0.200
    27.568     3.728     0.200
    27.587     4.804     0.200
    27.596     3.392     0.200
    27.596     3.713     0.200
    27.669     4.438     0.200
    27.757     1.259     0.200
    27.758     3.143     0.200
    27.774     1.538     0.200
    27.844     1.329     0.200
    27.845     2.204     0.200
    27.845     1.720     0.200
    27.851     1.641     0.200
    27.953     1.758     0.200
    28.044     3.984     0.200
    28.071     2.354     0.200
    28.071     2.119     0.200
    28.105     3.156     0.200
    28.221     3.442     0.200
    28.234     4.060     0.200
    28.265     3.516     0.200
    28.282     3.034     0.200
    28.367     3.040     0.200
    28.374     3.158     0.200
    28.396     1.558     0.200
    28.396     1.238     0.200
    28.456     1.722     0.200
    28.456     1.371     0.200
    28.459     1.419     0.200
    28.509     2.863     0.200
    28.505     3.244     0.200
    28.524     3.319     0.200
    28.540     2.204     0.200
    28.687     4.162     0.200
    28.687     3.365     0.200
    28.687     1.537     0.200
    28.664     1.648     0.200
    28.664     1.031     0.200
    28.678     4.341     0.200
    28.704     3.555     0.200
    28.787     4.235     0.200
    28.799     1.434     0.200
    28.829     0.681     0.200
    28.827     3.790     0.200
    28.832     3.027     0.200
    28.888     3.546     0.200
    28.899     1.431     0.200
    28.917     2.491     0.200
    28.986     1.534     0.200
    29.029     5.211     0.200
    29.031     1.072     0.200
    29.031     2.940     0.200
    29.068     0.581     0.200
    29.082     3.280     0.200
    29.082     3.420     0.200
    29.168     0.922     0.200
    29.177     0.277     0.200
    29.184     1.797     0.200
    29.184     0.992     0.200
    29.188     1.201     0.200
    29.189     3.912     0.200
    29.267     1.469     0.200
    29.283     3.811     0.200
    29.356     3.823     0.200
    29.405     3.554     0.200
    29.408     2.713     0.200
    29.408     2.252     0.200
    29.443     0.335     0.200
    29.444     3.568     0.200
    29.521     3.422     0.200
    29.562     1.531     0.200
    29.562     2.804     0.200
    29.586     1.873     0.200
    29.613     2.650     0.200
    29.613     3.353     0.200
    29.729     4.130     0.200
    29.796     4.815     0.200
    29.807     2.047     0.200
    29.807     1.406     0.200
    29.880     1.637     0.200
    29.880     1.434     0.200
    29.892     3.491     0.200
    29.898     3.690     0.200
    29.971     1.974     0.200
    30.048     1.006     0.200
    30.041     3.284     0.200
    30.116     0.795     0.200
    30.133     3.215     0.200
    30.151     0.733     0.200
    30.152     0.913     0.200
    30.161     5.469     0.200
    30.169     2.314     0.200
    30.168     4.060     0.200
    30.196     2.232     0.200
    30.199     1.638     0.200
    30.208     1.847     0.200
    30.276     2.097     0.200
    30.276     1.816     0.200
    30.294     1.842     0.200
    30.294     0.709     0.200
    30.446     5.044     0.200
    30.475     2.114     0.200
    30.475     2.771     0.200
    30.484     2.654     0.200
    30.484     3.232     0.200
    30.486     3.634     0.200
    30.564     3.662     0.200
    30.565     3.762     0.200
    30.576     2.229     0.200
    30.710     2.649     0.200
    30.758    -0.081     0.200
    30.851     2.556     0.200
    30.829     1.260     0.200
    30.829     1.416     0.200
    30.933     3.603     0.200
    30.984     1.045     0.200
    31.044     3.665     0.200
    31.070     0.734     0.200
    31.130     4.081     0.200
    31.146     0.935     0.200
    31.146     1.263     0.200
    31.172     2.284     0.200
    31.191     3.105     0.200
    31.257     2.262     0.200
    31.257     2.418     0.200
    31.236     2.322     0.200
    31.341     1.708     0.200
    31.383     1.595     0.200
    31.375     1.787     0.200
    31.375     0.881     0.200
    31.404    -0.479     0.200
    31.528     1.724     0.200
    31.509     2.813     0.200
    31.520     1.347     0.200
    31.520     1.581     0.200
    31.529     2.790     0.200
    31.557     3.000     0.200
    31.589     0.474     0.200
    31.608     3.928     0.200
    31.614     3.865     0.200
    31.625     0.961     0.200
    31.665     2.098     0.200
    31.741     2.506     0.200
    31.741     2.810     0.200
    31.761     1.411     0.200
    31.787     1.579     0.200
    31.828     2.611     0.200
    31.894     2.486     0.200
    31.924     1.400     0.200
    32.031     1.562     0.200
    32.044     3.599     0.200
    32.047     1.993     0.200
    32.164     1.129     0.200
    32.162     3.135     0.200
    32.166     2.693     0.200
    32.166     3.473     0.200
    32.254     2.776     0.200
    32.254     1.456     0.200
    32.250     2.529     0.200
    32.250     2.342     0.200
    32.259     2.397     0.200
    32.297     3.120     0.200
    32.297     2.815     0.200
    32.351     1.194     0.200
    32.383     3.681     0.200
    32.418     2.930     0.200
    32.570     3.978     0.200
    32.615     4.307     0.200
    32.683     1.445     0.200
    32.693     2.530     0.200
    32.723     2.558     0.200
    32.785     1.573     0.200
    32.783     3.614     0.200
    32.790     3.042     0.200
    32.825     3.825     0.200
    32.833     2.152     0.200
    32.872     3.476     0.200
    33.111     1.958     0.200
    33.205     3.200     0.200
    33.214     4.213     0.200
    33.218     2.829     0.200
    33.224     3.967     0.200
    33.319     1.370     0.200
    33.341     2.642     0.200
    33.481     0.159     0.200
    33.528     1.874     0.200
    33.588     0.597     0.200
    33.590     2.176     0.200
    33.684     3.258     0.200
    33.705     3.631     0.200
    33.730    -1.013     0.200
    33.749     3.513     0.200
    33.766     3.567     0.200
    33.876     2.145     0.200
    33.882     4.416     0.200
    33.891     1.424     0.200
    33.919     3.980     0.200
    33.973     1.977     0.200
    33.993     3.309     0.200
    34.029     2.942     0.200
    34.087     2.010     0.200
    34.098     3.656     0.200
    34.259     3.324     0.200
    34.278     2.113     0.200
    34.280     2.133     0.200
    34.294     3.156     0.200
    34.355     4.870     0.200
    34.364     2.229     0.200
    34.564     2.054     0.200
    34.612     2.246     0.200
    34.612     2.434     0.200
    34.641     3.229     0.200
    34.785     2.816     0.200
    34.912     2.992     0.200
    35.017     2.472     0.200
    35.155     3.984     0.200
    35.300     2.681     0.200
    35.447     3.523     0.200
    35.469     1.347     0.200
    35.482     1.535     0.200
    35.532     4.239     0.200
    35.503     2.343     0.200
    35.539     2.257     0.200
    35.563     1.786     0.200
    35.683     5.655     0.200
    35.683     3.601     0.200
    35.666     4.074     0.200
    35.723     0.210     0.200
    35.773     3.214     0.200
    35.900     2.776     0.200
    35.921     3.935     0.200
    36.007     4.051     0.200
    36.030     2.256     0.200
    36.091     3.330     0.200
    36.091     4.033     0.200
    36.416     4.367     0.200
    36.417     3.351     0.200
    36.486     2.186     0.200
    36.542     2.965     0.200
    36.664     3.895     0.200
    36.874     2.494     0.200
    36.994     3.405     0.200
    37.152     3.417     0.200
    37.418     2.706     0.200
    37.575     2.302     0.200
    37.784     1.052     0.200
    37.843     2.951     0.200
    37.929     2.031     0.200
    38.302     2.830     0.200
    38.467     1.832     0.200
    38.529    -0.419     0.200
    38.869     2.311     0.200
    39.284     2.037     0.200
    40.303     1.607     0.200
    40.409     3.626     0.200
    40.409     2.267     0.200
    41.871     3.650     0.200
    41.871     1.408     0.200
    42.714     3.687     0.200
    43.715     0.566     0.200
    44.401     3.482     0.200
    44.469     4.116     0.200
    44.668     5.114     0.200
    44.855     2.752     0.200
    44.855     4.455     0.200
    44.855     4.650     0.200
    45.144     1.457     0.200
    45.461     5.064     0.200
    46.445     3.750     0.200
    46.460     3.665     0.200
    46.460     5.063     0.200
    46.745     4.238     0.200
    46.788     3.697     0.200
    46.816     0.887     0.200
    47.039     3.047     0.200
    47.361     4.481     0.200
    47.524     3.091     0.200
    47.816     3.579     0.200
    47.845     3.906     0.200
    48.137     1.780     0.200
    48.248     3.797     0.200
    48.216     3.477     0.200
    48.435     3.429     0.200
    48.435     1.851     0.200
    48.435     3.427     0.200
    48.758     3.142     0.200
    48.867     5.022     0.200
    49.070     2.127     0.200
    49.070     3.854     0.200
    49.070     4.674     0.200
    49.157     3.357     0.200
    49.208     4.062     0.200
    49.267     2.780     0.200
    49.255     4.113     0.200
    49.640     1.825     0.200
    49.637     4.159     0.200
    50.030     3.295     0.200
    50.030     4.552     0.200
    50.442     2.308     0.200
    50.683     3.978     0.200
    50.683     3.150     0.200
    50.759     1.918     0.200
    50.900     3.830     0.200
    51.269     3.098     0.200
    51.569     3.410     0.200
    51.592     4.111     0.200
    51.752     2.186     0.200
    51.752     4.343     0.200
    51.752     2.691     0.200
    52.149     3.266     0.200
    52.255     5.520     0.200
    52.357     3.222     0.200
    52.357     3.472     0.200
    52.512     2.590     0.200
    52.661     3.080     0.200
    52.917     5.333     0.200
    53.090     4.187     0.200
    53.090     5.796     0.200
    53.091     4.856     0.200
    53.114     5.101     0.200
    53.305     5.106     0.200
    53.307     3.218     0.200
    53.344     4.761     0.200
    53.440     5.675     0.200
    53.455     4.444     0.200
    53.460     3.083     0.200
    53.490     4.055     0.200
    53.489     4.398     0.200
    53.493     4.427     0.200
    53.567     5.434     0.200
    53.571     4.752     0.200
    53.594     4.511     0.200
    53.606     3.806     0.200
    53.614     3.516     0.200
    53.662     5.441     0.200
    53.689     3.316     0.200
    53.699     3.719     0.200
    53.717     4.727     0.200
    53.734     4.959     0.200
    53.779     3.957     0.200
    53.883     3.804     0.200
    53.905     3.812     0.200
    53.932     4.217     0.200
    53.977     2.785     0.200
    54.002     1.885     0.200
    54.133     4.683     0.200
    54.215     3.425     0.200
    54.215     4.652     0.200
    54.297     4.428     0.200
    54.334     4.231     0.200
    54.345     3.016     0.200
    54.345     3.695     0.200
    54.398     2.918     0.200
    54.529     2.698     0.200
    54.529     2.018     0.200
    54.560     3.516     0.200
    54.619     3.928     0.200
    54.619     4.225     0.200
    54.718     3.364     0.200
    54.737     2.757     0.200
    54.751     3.436     0.200
    54.751     3.209     0.200
    54.793     4.280     0.200
    54.793     3.249     0.200
    54.871     3.687     0.200
    54.871     4.476     0.200
    54.966     4.000     0.200
    54.966     3.524     0.200
    55.036     3.409     0.200
    55.148     4.183     0.200
    55.113     4.263     0.200
    55.186     4.235     0.200
    55.310     3.408     0.200
    55.284     3.852     0.200
    55.288     3.503     0.200
    55.376     4.618     0.200
    55.439     3.540     0.200
    55.439     3.775     0.200
    55.576     2.487     0.200
    55.610     2.619     0.200
    55.610     1.744     0.200
    55.627     3.824     0.200
    55.714     3.820     0.200
    55.823     1.842     0.200
    55.823     2.576     0.200
    55.867     2.790     0.200
    55.867     4.665     0.200
    55.912     3.258     0.200
    56.057     3.267     0.200
    56.057     3.619     0.200
    56.074     3.561     0.200
    56.074     2.780     0.200
    56.128     2.357     0.200
    56.128     2.896     0.200
    56.191     3.313     0.200
    56.191     3.095     0.200
    56.231     2.348     0.200
    56.276     3.500     0.200
    56.250     2.420     0.200
    56.250     3.482     0.200
    56.257     3.520     0.200
    56.385     3.629     0.200
    56.413     3.273     0.200
    56.413     2.250     0.200
    56.448     3.142     0.200
    56.534     3.874     0.200
    56.591     3.938     0.200
    56.591     3.102     0.200
    56.642     2.307     0.200
    56.670     3.581     0.200
    56.629     3.553     0.200
    56.738     3.333     0.200
    56.753     2.753     0.200
    56.826     5.008     0.200
    56.819     2.550     0.200
    56.819     3.401     0.200
    56.867     3.836     0.200
    56.839     4.250     0.200
    56.839     1.546     0.200
    56.848     2.753     0.200
    56.882     3.755     0.200
    56.882     4.216     0.200
    56.934     3.205     0.200
    56.995     3.203     0.200
    57.037     2.054     0.200
    57.101     3.615     0.200
    57.172     2.510     0.200
    57.172     1.306     0.200
    57.187     3.048     0.200
    57.311     2.872     0.200
    57.393     1.651     0.200
    57.393     1.885     0.200
    57.514     3.897     0.200
    57.499     3.174     0.200
    57.557     4.019     0.200
    57.566     1.870     0.200
    57.566     2.464     0.200
    57.566     2.105     0.200
    57.594     3.273     0.200
    57.611     3.397     0.200
    57.676     3.466     0.200
    57.677     3.000     0.200
    57.677     4.007     0.200
    57.756     4.173     0.200
    57.789     2.803     0.200
    57.789     3.193     0.200
    57.833     2.116     0.200
    57.846     3.038     0.200
    57.887     2.949     0.200
    57.896     2.744     0.200
    57.986     3.898     0.200
    57.948     2.535     0.200
    57.948     2.785     0.200
    57.962     3.469     0.200
    57.970     3.534     0.200
    57.970     3.214     0.200
    57.970     2.136     0.200
    57.973     3.453     0.200
    57.973     2.344     0.200
    58.004     3.878     0.200
    58.152     2.117     0.200
    58.179     3.334     0.200
    58.179     2.404     0.200
    58.211     2.846     0.200
    58.273     3.445     0.200
    58.273     3.273     0.200
    58.305     2.487     0.200
    58.479     2.642     0.200
    58.491     2.871     0.200
    58.491     2.316     0.200
    58.536     3.926     0.200
    58.633     2.015     0.200
    58.661     2.677     0.200
    58.661     2.123     0.200
    58.691     3.244     0.200
    58.691     3.814     0.200
    58.760     2.815     0.200
    58.760     2.627     0.200
    58.881     2.917     0.200
    58.903     1.230     0.200
    58.903     2.261     0.200
    59.028     1.764     0.200
    59.028     3.460     0.200
    59.028     1.319     0.200
    59.111     2.998     0.200
    59.181     2.615     0.200
    59.219     3.168     0.200
    59.249     2.809     0.200
    59.349     4.068     0.200
    59.502     2.944     0.200
    59.516     3.007     0.200
    59.516     2.492     0.200
    59.646     2.144     0.200
    59.646     1.464     0.200
    59.662     2.778     0.200
    59.662     1.309     0.200
    59.746     2.003     0.200
    59.746     2.612     0.200
    60.020     3.620     0.200
    60.011     2.527     0.200
    60.011     2.316     0.200
    60.036     2.159     0.200
    60.036     1.284     0.200
    60.081     3.000     0.200
    60.116     2.182     0.200
    60.123     3.172     0.200
    60.171     2.858     0.200
    60.171     1.921     0.200
    60.301     2.504     0.200
    60.407     3.882     0.200
    60.542     2.658     0.200
    60.542     2.056     0.200
    60.593     4.361     0.200
    60.666     1.928     0.200
    60.794     3.571     0.200
    60.825     3.755     0.200
    61.046     2.378     0.200
    61.351     2.871     0.200
    61.499     4.041     0.200
    61.607     2.984     0.200
    61.654     4.356     0.200
    61.665     3.286     0.200
    61.739     3.202     0.200
    61.739     2.491     0.200
    62.202     3.685     0.200
    62.568     4.057     0.200
    62.598     1.950     0.200
    62.654     2.434     0.200
    63.143     2.551     0.200
    63.143     3.075     0.200
    63.143     4.317     0.200
    63.281     2.805     0.200
    63.409     1.832     0.200
    63.455     5.159     0.200
    63.525     1.833     0.200
    63.668     4.334     0.200
    63.717     4.212     0.200
    63.885     3.794     0.200
    63.919     4.736     0.200
    63.963     1.621     0.200
    63.963     2.067     0.200
    64.107     4.055     0.200
    64.186     4.331     0.200
    64.284     3.499     0.200
    64.281     4.094     0.200
    64.473     4.016     0.200
    64.577     2.170     0.200
    64.665     4.408     0.200
    64.779     3.326     0.200
    64.763     2.510     0.200
    64.775     1.927     0.200
    64.973     2.315     0.200
    65.066     3.546     0.200
    65.066     2.991     0.200
    65.101     3.803     0.200
    65.128     4.118     0.200
    65.277     2.092     0.200
    65.277     1.772     0.200
    65.324     3.434     0.200
    65.692     4.843     0.200
    65.873     5.326     0.200
    66.044     4.227     0.200
    66.050     4.280     0.200
    66.497     3.847     0.200
    66.699     4.600     0.200
    66.736     4.168     0.200
    66.812     4.039     0.200
    66.847     4.627     0.200
    66.926     4.319     0.200
    67.030     5.402     0.200
    67.113     4.872     0.200
    67.269     3.513     0.200
    67.343     4.201     0.200
    67.334     3.074     0.200
    67.599     4.146     0.200
    68.013     4.930     0.200
    68.048     4.804     0.200
    68.218     4.230     0.200
    70.753     1.578     0.200
    71.396     0.519     0.200
    72.217     1.293     0.200
    76.054     2.649     0.200
    76.150     4.276     0.200
    76.150     1.651     0.200
    77.398     4.638     0.200
    78.522     1.346     0.200
    79.475     3.063     0.200
    79.625     3.771     0.200
    80.054     3.346     0.200
    80.060     2.918     0.200
    80.254     3.373     0.200
    80.348     4.457     0.200
    80.449     3.822     0.200
    80.503     4.729     0.200
    80.545     4.901     0.200
    80.602     2.597     0.200
    82.124     5.304     0.200
    82.846     2.875     0.200
    83.097     1.930     0.200
    83.097     2.172     0.200
    83.097    -0.348     0.200
    83.891     4.497     0.200
    83.907     4.049     0.200
    84.402     3.003     0.200
    84.402     3.581     0.200
    84.402     3.183     0.200
    84.549     5.466     0.200
    84.549     1.974     0.200
    84.691     3.749     0.200
    84.691     2.546     0.200
    84.839     2.871     0.200
    85.229     2.550     0.200
    85.371     1.592     0.200
    85.399     4.598     0.200
    85.592     3.139     0.200
    85.753     2.333     0.200
    85.921     4.025     0.200
    85.930     2.964     0.200
    85.930     1.643     0.200
    86.192     2.670     0.200
    86.200    -0.369     0.200
    86.215     2.837     0.200
    86.297     1.921     0.200
    86.659     2.590     0.200
    88.673     3.306     0.200
    88.673     4.837     0.200
    88.853     4.684     0.200
    89.653     3.865     0.200
    89.942     2.187     0.200
    90.340     4.335     0.200
    90.420     2.751     0.200
    90.567     0.977     0.200
    90.567     2.125     0.200
    90.567     1.889     0.200
    90.611     4.325     0.200
    90.669     2.986     0.200
    90.730     4.484     0.200
    90.904     4.707     0.200
    90.972     4.655     0.200
    91.279     3.466     0.200
    91.485     1.326     0.200
    91.740     3.199     0.200
    91.806     3.323     0.200
    91.922     3.287     0.200
    91.954     1.592     0.200
    92.154     3.517     0.200
    92.286     4.025     0.200
    92.465     2.978     0.200
    92.465     2.697     0.200
    92.923     1.789     0.200
    92.923     3.867     0.200
    92.934     3.520     0.200
    93.093     3.597     0.200
    93.217     3.213     0.200
    93.217     4.010     0.200
    93.305     3.738     0.200
    93.786     3.691     0.200
    93.832     1.705     0.200
    93.832     3.181     0.200
    93.832     2.392     0.200
    94.221     1.892     0.200
    94.349     1.352     0.200
    94.349     0.734     0.200
    95.633     1.333     0.200
    95.678     1.730     0.200
    95.850     4.242     0.200
    96.109     1.813     0.200
    96.109     1.165     0.200
    96.458     2.684     0.200
    96.701     4.285     0.200
    96.775     1.146     0.200
    96.877     3.151     0.200
    97.431     2.613     0.200
    97.767     1.440     0.200
    98.871     2.217     0.200
    14.643     7.333     0.200
    15.020     6.847     0.200
    15.020     6.163     0.200
    15.204     6.056     0.200
    15.204     5.669     0.200
    15.220     6.363     0.200
    15.503     5.206     0.200
    15.626     5.788     0.200
    15.626     5.464     0.200
    16.141     6.602     0.200
    16.173     7.848     0.200
    16.366     4.447     0.200
    16.932     3.510     0.200
    17.099     3.331     0.200
    17.261     3.928     0.200
    17.328     3.488     0.200
    17.535     4.146     0.200
    18.124     1.978     0.200
    18.598     2.186     0.200
    18.704     3.009     0.200
    18.777     2.730     0.200
    18.777     3.124     0.200
    18.982     1.363     0.200
    19.200     3.492     0.200
    19.640     2.997     0.200
    19.762     1.663     0.200
    19.986     1.348     0.200
    20.024     1.183     0.200
    20.334     2.331     0.200
    20.722     4.015     0.200
    21.079     1.669     0.200
    21.207     0.907     0.200
    21.401     0.669     0.200
    21.424    -0.265     0.200
    21.551     2.890     0.200
    21.551     3.585     0.200
    21.616     3.722     0.200
    21.643     2.395     0.200
    21.643     4.368     0.200
    21.903     3.911     0.200
    21.940     2.624     0.200
    21.940     3.991     0.200
    22.035     1.624     0.200
    22.113     3.892     0.200
    22.148     2.103     0.200
    22.239     2.458     0.200
    22.412     3.651     0.200
    22.502     3.118     0.200
    22.580     2.819     0.200
    22.910     1.222     0.200
    22.940     2.497     0.200
    22.998     3.371     0.200
    22.998     3.183     0.200
    23.280     3.162     0.200
    23.324     2.478     0.200
    23.453     2.600     0.200
    23.541     3.109     0.200
    23.717     3.810     0.200
    23.736     2.647     0.200
    23.751     4.187     0.200
    23.870     3.038     0.200
    23.940     4.508     0.200
    24.118     3.305     0.200
    24.134     3.582     0.200
    24.306     2.932     0.200
    24.356     4.126     0.200
    24.471     4.202     0.200
    24.527     3.553     0.200
    24.657     3.951     0.200
    24.789     3.222     0.200
    24.906     2.428     0.200
    25.280     3.827     0.200
    25.321     1.870     0.200
    25.436     1.795     0.200
    25.469     3.200     0.200
    25.607     1.962     0.200
    25.599     4.056     0.200
    25.843     1.735     0.200
    25.864     2.026     0.200
    25.931     4.075     0.200
    26.090     4.483     0.200
    26.178     2.974     0.200
    26.178     4.345     0.200
    26.194     3.159     0.200
    26.400     4.618     0.200
    26.462     3.608     0.200
    26.759     3.372     0.200
    26.759     1.700     0.200
    26.875     2.570     0.200
    26.928     1.841     0.200
    27.335     3.123     0.200
    27.334     3.088     0.200
    27.413     4.564     0.200
    27.413     3.162     0.200
    27.664     3.665     0.200
    27.664     2.501     0.200
    27.675     3.635     0.200
    27.753     2.819     0.200
    29.082     0.895     0.200
    29.466     1.815     0.200
    29.670     3.629     0.200
    29.704     1.697     0.200
    30.525     4.136     0.200
    31.352     2.441     0.200
    31.821     0.819     0.200
    32.279     2.239     0.200
    32.343     3.339     0.200
    34.506     4.801     0.200
    37.782     1.145     0.200
    45.060     1.202     0.200
    46.834     1.678     0.200
    47.414     2.766     0.200
    48.498     4.482     0.200
    49.300     3.530     0.200
    49.689     3.714     0.200
    50.736     3.682     0.200
    51.316     3.676     0.200
    51.621     3.919     0.200
    51.640     3.857     0.200
    51.807     2.859     0.200
    51.813     4.278     0.200
    52.206     4.316     0.200
    52.418     4.253     0.200
    52.568     4.477     0.200
    52.712     4.051     0.200
    53.109     4.441     0.200
    53.367     3.482     0.200
    53.516     3.969     0.200
    53.945     3.125     0.200
    54.057     3.866     0.200
    54.275     4.161     0.200
    54.401     4.534     0.200
    54.578     3.031     0.200
    54.805     3.761     0.200
    54.850     4.069     0.200
    54.936     3.288     0.200
    55.027     4.732     0.200
    55.081     2.736     0.200
    55.297     2.512     0.200
    55.343     3.290     0.200
    55.501     4.258     0.200
    55.624     3.146     0.200
    55.686     3.485     0.200
    55.855     2.405     0.200
    55.855     2.608     0.200
    56.115     3.382     0.200
    56.127     4.084     0.200
    56.127     3.049     0.200
    56.282     3.167     0.200
    56.305     2.009     0.200
    56.799     3.358     0.200
    56.883     3.102     0.200
    56.905     2.984     0.200
    56.907     2.733     0.200
    57.189     1.699     0.200
    57.189     2.012     0.200
    57.447     1.887     0.200
    57.619     2.720     0.200
    57.619     1.459     0.200
    57.783     1.215     0.200
    57.783     1.567     0.200
    57.847     2.486     0.200
    58.001     3.099     0.200
    58.024     2.544     0.200
    58.027     2.858     0.200
    58.030     2.872     0.200
    58.239     3.035     0.200
    58.329     2.844     0.200
    58.542     3.232     0.200
    58.715     2.448     0.200
    58.889     2.522     0.200
    59.167     2.533     0.200
    59.273     2.540     0.200
    59.284     2.775     0.200
    59.583     3.341     0.200
    59.604     2.312     0.200
    59.702     2.735     0.200
    59.724     2.569     0.200
    60.060     1.887     0.200
    60.060     2.930     0.200
    60.097     2.016     0.200
    60.097     2.587     0.200
    60.227     2.295     0.200
    60.366     2.218     0.200
    60.586     2.881     0.200
    66.105     3.133     0.200
    82.957     2.522     0.200
    83.335     2.574     0.200
    91.372     1.153     0.200
    95.942     2.730     0.200
    26.580     4.959     0.200
    26.813     3.246     0.200
    45.429     0.890     0.200
    46.451     0.808     0.200
    15.457     6.303     0.200
    15.769     6.751     0.200
    15.847     5.705     0.200
    15.971     4.677     0.200
    16.192     6.925     0.200
    16.600     4.073     0.200
    16.649     6.219     0.200
    17.131     4.775     0.200
    17.447     3.514     0.200
    17.875     4.077     0.200
    18.470     0.859     0.200
    18.523     0.848     0.200
    18.628     2.648     0.200
    18.888     2.032     0.200
    19.217     3.051     0.200
    19.397     1.134     0.200
    19.536     1.587     0.200
    19.575     1.763     0.200
    19.596     2.159     0.200
    19.758     0.558     0.200
    19.786     2.032     0.200
    19.852     1.877     0.200
    19.878    -0.056     0.200
    19.931     1.869     0.200
    20.115     1.265     0.200
    20.309     2.801     0.200
    20.514     3.247     0.200
    20.562     1.472     0.200
    20.820     2.707     0.200
    20.872     0.507     0.200
    20.947     3.028     0.200
    21.050     4.025     0.200
    21.131     1.717     0.200
    21.396     4.529     0.200
    21.396     4.420     0.200
    21.467     2.855     0.200
    21.545     3.939     0.200
    21.627     2.402     0.200
    21.730     4.163     0.200
    21.922    -0.131     0.200
    21.936     2.656     0.200
    21.932     4.876     0.200
    21.945     1.928     0.200
    21.992    -0.118     0.200
    22.024     1.556     0.200
    22.024     1.849     0.200
    22.193     3.852     0.200
    22.378     2.880     0.200
    22.394     1.472     0.200
    22.408     4.306     0.200
    22.445     0.734     0.200
    22.453     0.400     0.200
    22.541     2.451     0.200
    22.676     1.911     0.200
    22.713     3.809     0.200
    22.729     2.774     0.200
    22.729     1.625     0.200
    22.754     4.264     0.200
    22.757     3.853     0.200
    22.761     5.345     0.200
    22.761     4.823     0.200
    23.107     3.068     0.200
    23.126     5.285     0.200
    23.204     3.358     0.200
    23.471     0.493     0.200
    23.486     3.767     0.200
    23.541     4.095     0.200
    23.573     4.061     0.200
    23.627     3.436     0.200
    23.627     2.936     0.200
    23.666     3.693     0.200
    23.750     4.427     0.200
    23.843     2.166     0.200
    23.843     1.856     0.200
    23.846     4.041     0.200
    23.917     4.351     0.200
    23.958     4.301     0.200
    23.967     3.649     0.200
    23.998     2.170     0.200
    24.027     3.319     0.200
    24.122     3.709     0.200
    24.151     4.224     0.200
    24.148     3.531     0.200
    24.255     3.021     0.200
    24.255     2.578     0.200
    24.264     1.596     0.200
    24.285     3.862     0.200
    24.350     0.690     0.200
    24.344     4.184     0.200
    24.393     3.742     0.200
    24.462     1.750     0.200
    24.477     3.521     0.200
    24.563     2.866     0.200
    24.554     4.703     0.200
    24.639     2.026     0.200
    24.731     3.133     0.200
    24.740     3.446     0.200
    24.749     2.528     0.200
    24.749     3.501     0.200
    25.008     5.163     0.200
    25.023     4.044     0.200
    25.053     3.819     0.200
    25.077     3.521     0.200
    25.227     3.599     0.200
    25.257     1.292     0.200
    25.275     1.691     0.200
    25.295     1.694     0.200
    25.336     1.064     0.200
    25.338     3.845     0.200
    25.373     4.310     0.200
    25.637     3.898     0.200
    25.675     2.561     0.200
    25.684     3.152     0.200
    25.685     3.480     0.200
    25.685     4.380     0.200
    25.800     4.122     0.200
    25.859     4.320     0.200
    25.901     1.539     0.200
    26.071     4.739     0.200
    26.112     1.059     0.200
    26.126     3.975     0.200
    26.204     4.620     0.200
    26.360     4.307     0.200
    26.441     1.799     0.200
    26.374     6.001     0.200
    26.537     0.911     0.200
    26.556     1.646     0.200
    26.545     4.000     0.200
    26.651     1.322     0.200
    26.596     3.236     0.200
    26.879     3.052     0.200
    27.044     1.242     0.200
    27.239     1.805     0.200
    27.241     4.835     0.200
    27.271     0.045     0.200
    27.237     5.422     0.200
    27.366     1.174     0.200
    27.373     2.685     0.200
    27.373     3.301     0.200
    27.447     1.401     0.200
    27.579     4.884     0.200
    27.601     2.094     0.200
    27.650     2.269     0.200
    28.288     0.985     0.200
    28.527     1.864     0.200
    28.590     6.072     0.200
    28.866     0.929     0.200
    28.875     1.585     0.200
    28.969     0.186     0.200
    29.115     4.071     0.200
    29.115     3.756     0.200
    29.384     1.872     0.200
    29.468    -0.112     0.200
    29.506     1.890     0.200
    29.519     3.416     0.200
    29.636     3.186     0.200
    30.046     2.885     0.200
    30.267     2.075     0.200
    30.318     1.374     0.200
    30.420     2.696     0.200
    30.421     1.654     0.200
    30.557     3.431     0.200
    30.680     1.569     0.200
    30.841     3.535     0.200
    31.053     2.471     0.200
    31.522     1.516     0.200
    31.529     3.115     0.200
    31.639     2.526     0.200
    31.829     2.567     0.200
    31.914     2.779     0.200
    32.090     3.301     0.200
    32.090     3.736     0.200
    32.330     3.492     0.200
    32.353     3.423     0.200
    32.353     3.241     0.200
    32.360     3.488     0.200
    32.383     1.794     0.200
    32.383     1.995     0.200
    32.730     1.360     0.200
    32.728     3.869     0.200
    32.738     2.575     0.200
    33.141     3.529     0.200
    33.172     3.065     0.200
    33.237     1.535     0.200
    33.282     3.843     0.200
    33.580     0.759     0.200
    33.606     4.249     0.200
    33.682     2.544     0.200
    33.977     2.688     0.200
    34.648     3.776     0.200
    34.736     3.031     0.200
    34.814     1.789     0.200
    35.263     3.923     0.200
    35.946     3.017     0.200
    35.901     5.149     0.200
    37.990     1.794     0.200
    38.319     3.468     0.200
    42.125     2.615     0.200
    43.066     2.919     0.200
    45.034     4.652     0.200
    45.034     4.443     0.200
    45.562     1.115     0.200
    45.732     3.951     0.200
    46.959     2.080     0.200
    47.401     4.785     0.200
    48.270     3.311     0.200
    48.270     3.770     0.200
    48.437     4.360     0.200
    48.575     5.122     0.200
    48.703     3.843     0.200
    49.224     3.717     0.200
    49.371     2.521     0.200
    49.545     4.172     0.200
    49.875     2.930     0.200
    50.963     4.246     0.200
    51.222     2.641     0.200
    51.320     3.332     0.200
    51.604     3.547     0.200
    51.639     3.148     0.200
    51.757     3.430     0.200
    51.774     3.942     0.200
    51.836     4.147     0.200
    52.046     4.294     0.200
    53.188     4.816     0.200
    53.167     5.272     0.200
    53.233     4.858     0.200
    53.515     4.420     0.200
    53.810     3.089     0.200
    54.223     4.662     0.200
    54.366     4.256     0.200
    54.574     3.639     0.200
    54.618     4.302     0.200
    54.778     3.858     0.200
    54.810     3.692     0.200
    54.972     3.157     0.200
    55.096     1.917     0.200
    55.316     1.843     0.200
    55.330     2.440     0.200
    55.439     2.979     0.200
    55.462     3.909     0.200
    55.621     2.123     0.200
    55.920     2.461     0.200
    55.920     3.202     0.200
    56.073     3.854     0.200
    56.103     3.646     0.200
    56.190     3.706     0.200
    56.266     4.141     0.200
    56.266     3.806     0.200
    56.275     3.840     0.200
    56.296     3.585     0.200
    56.588     3.133     0.200
    56.599     3.172     0.200
    56.669     3.563     0.200
    56.811     3.517     0.200
    57.021     3.786     0.200
    57.081     2.614     0.200
    57.418     2.499     0.200
    57.538     2.099     0.200
    57.595     2.759     0.200
    57.595     2.519     0.200
    57.803     2.523     0.200
    57.825     2.421     0.200
    57.958     3.818     0.200
    57.979     2.849     0.200
    58.001     2.945     0.200
    58.072     3.371     0.200
    58.187     2.899     0.200
    58.295     3.793     0.200
    58.393     3.141     0.200
    58.527     3.382     0.200
    58.638     2.940     0.200
    58.689     2.542     0.200
    58.791     2.769     0.200
    58.791     2.967     0.200
    58.866     3.727     0.200
    58.884     2.338     0.200
    59.081     2.753     0.200
    59.103     3.193     0.200
    59.133     2.856     0.200
    59.189     2.933     0.200
    59.209     3.103     0.200
    59.204     2.988     0.200
    59.377     2.965     0.200
    59.455     2.582     0.200
    59.473     2.890     0.200
    59.501     3.108     0.200
    59.612     3.176     0.200
    59.660     2.887     0.200
    59.667     3.022     0.200
    59.728     2.978     0.200
    59.790     3.372     0.200
    59.953     3.495     0.200
    60.032     2.526     0.200
    60.043     3.047     0.200
    60.055     3.523     0.200
    60.055     2.935     0.200
    60.195     2.820     0.200
    60.291     2.335     0.200
    60.302     3.308     0.200
    60.342     2.967     0.200
    60.600     3.104     0.200
    60.637     2.401     0.200
    60.652     2.343     0.200
    60.846     2.604     0.200
    60.859     3.321     0.200
    60.932     2.697     0.200
    61.048     2.929     0.200
    61.115     3.091     0.200
    61.166     3.678     0.200
    61.553     2.692     0.200
    63.134     4.986     0.200
    65.637     2.075     0.200
    83.264     2.579     0.200
    83.619     1.604     0.200
    84.299     2.706     0.200
    85.731     1.850     0.200
    91.963     1.310     0.200
    96.641     1.888     0.200
    15.390     7.881     0.200
    15.489     7.954     0.200
    15.687     3.670     0.200
    15.715     7.261     0.200
    15.759     3.951     0.200
    15.867     4.860     0.200
    16.713     3.823     0.200
    16.734     5.157     0.200
    17.071     3.247     0.200
    17.359     2.539     0.200
    17.623     3.742     0.200
    17.945     2.674     0.200
    17.994     2.343     0.200
    18.127     3.276     0.200
    18.144     2.938     0.200
    18.206     2.927     0.200
    18.327    -0.574     0.200
    18.481     0.298     0.200
    18.586     1.888     0.200
    18.623     1.279     0.200
    18.672     1.568     0.200
    18.836     2.706     0.200
    18.836     1.139     0.200
    18.982     1.797     0.200
    18.982     1.645     0.200
    19.029     1.945     0.200
    19.006     2.866     0.200
    19.125     1.521     0.200
    19.155     2.018     0.200
    19.155     1.135     0.200
    19.198     2.148     0.200
    19.264     1.937     0.200
    19.279     2.097     0.200
    19.306     1.383     0.200
    19.391     2.186     0.200
    19.466     1.719     0.200
    19.477     0.888     0.200
    19.644     2.333     0.200
    19.681     2.156     0.200
    19.681     0.631     0.200
    19.732     1.409     0.200
    19.685     1.924     0.200
    19.746     0.571     0.200
    19.765     1.562     0.200
    19.803     1.207     0.200
    19.837     1.025     0.200
    19.881     1.473     0.200
    19.934     1.382     0.200
    19.934     1.889     0.200
    19.996     1.970     0.200
    20.028     1.603     0.200
    20.035     2.158     0.200
    20.091     1.869     0.200
    20.139     1.888     0.200
    20.110     2.978     0.200
    20.144     2.164     0.200
    20.176     1.312     0.200
    20.191     0.650     0.200
    20.149     3.438     0.200
    20.202     2.313     0.200
    20.231     1.417     0.200
    20.237     2.211     0.200
    20.270     2.312     0.200
    20.394     0.723     0.200
    20.469     0.497     0.200
    20.466     2.879     0.200
    20.555     1.872     0.200
    20.555     1.258     0.200
    20.628     1.395     0.200
    20.689     1.977     0.200
    20.626     3.305     0.200
    20.725     1.131     0.200
    20.776     0.857     0.200
    20.775     0.635     0.200
    20.892     1.833     0.200
    20.964     0.609     0.200
    20.964     4.104     0.200
    21.094     1.332     0.200
    21.133     2.829     0.200
    21.133     4.903     0.200
    21.264     2.655     0.200
    21.264     3.770     0.200
    21.300     3.436     0.200
    21.371     1.453     0.200
    21.406     4.243     0.200
    21.457     3.332     0.200
    21.469     4.646     0.200
    21.506     4.755     0.200
    21.575     1.199     0.200
    21.548     3.496     0.200
    21.548     4.057     0.200
    21.595     1.355     0.200
    21.572     3.238     0.200
    21.572     3.549     0.200
    21.724     0.407     0.200
    21.724     1.428     0.200
    21.797     0.097     0.200
    21.797     0.988     0.200
    21.762     3.542     0.200
    21.815     3.222     0.200
    21.926     1.302     0.200
    21.926     1.350     0.200
    21.937     0.926     0.200
    21.997     1.188     0.200
    21.949     4.277     0.200
    21.985     4.277     0.200
    22.062     2.239     0.200
    22.062     1.754     0.200
    22.092     0.832     0.200
    22.114     0.556     0.200
    22.183     1.930     0.200
    22.183     0.975     0.200
    22.200     0.875     0.200
    22.265    -0.111     0.200
    22.265    -0.297     0.200
    22.301     4.600     0.200
    22.328     4.373     0.200
    22.328     2.603     0.200
    22.452     0.200     0.200
    22.622     0.428     0.200
    22.697     3.140     0.200
    22.723     3.086     0.200
    22.833    -0.693     0.200
    22.769     2.769     0.200
    22.968     4.322     0.200
    23.045     0.819     0.200
    23.107     0.499     0.200
    23.054     3.383     0.200
    23.111     3.644     0.200
    23.179    -0.043     0.200
    23.250     2.351     0.200
    23.210     3.758     0.200
    23.270     2.895     0.200
    23.270     3.003     0.200
    23.385     2.872     0.200
    23.322     4.417     0.200
    23.401    -0.560     0.200
    23.401     1.080     0.200
    23.425     1.511     0.200
    23.431     1.319     0.200
    23.410     3.329     0.200
    23.483     3.568     0.200
    23.635     0.399     0.200
    23.731     1.051     0.200
    23.753     1.700     0.200
    23.718     3.827     0.200
    23.718     3.566     0.200
    23.846     1.659     0.200
    23.847     1.778     0.200
    23.847     1.343     0.200
    23.895     1.712     0.200
    23.903     1.237     0.200
    23.932     2.519     0.200
    23.909     3.148     0.200
    23.939     3.432     0.200
    23.995     4.418     0.200
    24.035     1.158     0.200
    24.023     4.884     0.200
    24.187     0.619     0.200
    24.121     3.770     0.200
    24.223     2.360     0.200
    24.223     1.028     0.200
    24.187     3.912     0.200
    24.187     2.078     0.200
    24.283     4.531     0.200
    24.355     2.035     0.200
    24.365     2.279     0.200
    24.337     3.287     0.200
    24.344     3.040     0.200
    24.349     4.135     0.200
    24.427     2.262     0.200
    24.427     1.702     0.200
    24.392     2.507     0.200
    24.389     4.519     0.200
    24.631     2.665     0.200
    24.572     4.609     0.200
    24.596     4.411     0.200
    24.628     4.977     0.200
    24.628     4.695     0.200
    24.647     3.557     0.200
    24.769     1.693     0.200
    24.709     4.101     0.200
    24.842     1.885     0.200
    24.793     4.216     0.200
    24.902     5.136     0.200
    24.963     4.430     0.200
    24.941     5.224     0.200
    25.060     2.156     0.200
    25.031     2.839     0.200
    25.109     2.903     0.200
    25.152     1.971     0.200
    25.155     1.600     0.200
    25.132     4.548     0.200
    25.253     2.690     0.200
    25.287     1.621     0.200
    25.254     4.248     0.200
    25.258     5.092     0.200
    25.249     4.657     0.200
    25.333     3.134     0.200
    25.413     3.499     0.200
    25.443     2.495     0.200
    25.443     3.450     0.200
    25.426     4.560     0.200
    25.636     4.637     0.200
    25.724     5.411     0.200
    25.724     4.606     0.200
    25.788     5.620     0.200
    25.860     4.543     0.200
    25.991     2.331     0.200
    26.023     1.491     0.200
    25.985     2.712     0.200
    26.314     1.653     0.200
    26.367     2.668     0.200
    26.388     1.179     0.200
    26.388     3.153     0.200
    26.404     2.366     0.200
    26.528     3.039     0.200
    26.646     1.970     0.200
    26.686     2.218     0.200
    26.704     1.932     0.200
    26.714     1.937     0.200
    26.739     3.833     0.200
    26.815     6.184     0.200
    26.921     2.286     0.200
    26.997     3.715     0.200
    26.997     3.800     0.200
    26.997     4.351     0.200
    27.066     2.528     0.200
    27.169     4.760     0.200
    27.172     5.664     0.200
    27.269     2.166     0.200
    27.269     2.836     0.200
    27.313     1.726     0.200
    27.336     2.864     0.200
    27.611     1.190     0.200
    27.673     4.634     0.200
    27.720     3.894     0.200
    27.803     2.930     0.200
    27.933     2.867     0.200
    28.194     2.961     0.200
    28.180     6.559     0.200
    28.369     6.808     0.200
    28.783     4.525     0.200
    29.139     4.003     0.200
    29.239     4.742     0.200
    29.368     2.103     0.200
    29.490     1.020     0.200
    30.198     2.592     0.200
    30.179     3.741     0.200
    30.754     2.587     0.200
    31.368     3.253     0.200
    31.585     3.701     0.200
    31.968     3.657     0.200
    31.998     3.890     0.200
    31.972     6.107     0.200
    32.312     3.133     0.200
    32.687     2.648     0.200
    33.306     2.170     0.200
    33.413     3.524     0.200
    34.256     3.722     0.200
    34.256     3.898     0.200
    34.313     2.629     0.200
    35.447     5.162     0.200
    37.919     4.598     0.200
    39.459     3.252     0.200
    40.930     2.005     0.200
    42.559     4.006     0.200
    45.326     3.524     0.200
    45.434     2.000     0.200
    45.471     4.983     0.200
    45.471     5.358     0.200
    45.993     4.132     0.200
    46.044     4.331     0.200
    46.046     5.892     0.200
    46.495     4.661     0.200
    46.508     4.071     0.200
    46.612     2.683     0.200
    46.906     3.825     0.200
    47.001     5.166     0.200
    47.001     3.912     0.200
    47.003     2.858     0.200
    47.233     4.200     0.200
    47.303     3.690     0.200
    47.883     3.329     0.200
    48.178     3.972     0.200
    49.004     2.895     0.200
    49.149     2.541     0.200
    49.280     3.080     0.200
    50.037     2.848     0.200
    50.319     3.368     0.200
    50.579     4.128     0.200
    50.706     4.743     0.200
    50.932     4.121     0.200
    50.932     2.735     0.200
    51.210     4.178     0.200
    51.210     3.348     0.200
    51.249     5.203     0.200
    51.376     5.068     0.200
    51.376     3.382     0.200
    51.435     3.694     0.200
    51.650     2.505     0.200
    51.770     3.385     0.200
    51.959     3.696     0.200
    52.137     4.104     0.200
    52.310     4.383     0.200
    52.512     3.383     0.200
    52.793     3.903     0.200
    53.081     3.085     0.200
    53.123     3.309     0.200
    53.421     3.566     0.200
    53.629     3.348     0.200
    53.820     3.116     0.200
    53.967     3.640     0.200
    54.183     3.284     0.200
    54.212     3.424     0.200
    54.381     3.047     0.200
    54.410     4.974     0.200
    54.710     4.318     0.200
    54.710     2.382     0.200
    54.873     2.899     0.200
    55.236     2.772     0.200
    55.468     3.102     0.200
    55.551     1.701     0.200
    55.672     2.782     0.200
    55.707     2.751     0.200
    55.821     2.633     0.200
    55.872     2.723     0.200
    55.877     2.479     0.200
    56.033     2.862     0.200
    56.181     3.114     0.200
    56.223     3.264     0.200
    56.184     3.833     0.200
    56.256     3.609     0.200
    56.283     2.657     0.200
    56.403     2.848     0.200
    56.415     2.873     0.200
    56.696     2.640     0.200
    56.973     2.117     0.200
    57.020     3.026     0.200
    57.021     2.870     0.200
    57.146     2.704     0.200
    57.185     4.279     0.200
    57.198     3.729     0.200
    57.198     3.969     0.200
    57.198     2.909     0.200
    57.202     3.520     0.200
    57.268     4.064     0.200
    57.268     1.956     0.200
    57.336     2.648     0.200
    57.401     2.779     0.200
    57.439     2.929     0.200
    57.583     1.583     0.200
    57.592     2.279     0.200
    57.600     1.619     0.200
    57.604     1.876     0.200
    57.749     2.173     0.200
    57.784     2.507     0.200
    57.788     2.407     0.200
    57.827     3.635     0.200
    58.009     2.623     0.200
    58.079     2.992     0.200
    58.133     2.698     0.200
    58.290     2.443     0.200
    58.475     1.247     0.200
    58.479     3.179     0.200
    58.697     1.478     0.200
    58.778     2.288     0.200
    58.800     1.412     0.200
    59.067     1.791     0.200
    59.096     1.425     0.200
    59.091     1.993     0.200
    59.194     2.371     0.200
    59.254     1.666     0.200
    59.605     1.137     0.200
    59.610     2.666     0.200
    59.651     1.729     0.200
    59.664     1.254     0.200
    59.797     2.979     0.200
    59.883     0.833     0.200
    59.914     1.779     0.200
    60.214     1.478     0.200
    60.220     2.350     0.200
    60.350     3.015     0.200
    60.450     1.842     0.200
    60.481     4.221     0.200
    60.560     1.682     0.200
    61.647     3.241     0.200
    62.049     3.012     0.200
    63.538     4.629     0.200
    63.738     3.221     0.200
    64.348     2.222     0.200
    65.050     3.621     0.200
    65.444     2.658     0.200
    65.638     3.779     0.200
    65.638     2.476     0.200
    75.774     4.520     0.200
    82.855     4.796     0.200
    83.676     3.358     0.200
    84.998     4.429     0.200
    85.671     2.946     0.200
    93.728     3.578     0.200
    15.251     7.282     0.200
    15.347     8.313     0.200
    15.730     5.898     0.200
    15.730     7.008     0.200
    15.971     5.910     0.200
    16.480     3.780     0.200
    16.939     3.990     0.200
    17.302     4.498     0.200
    17.338     3.598     0.200
    17.487     2.944     0.200
    18.529     1.040     0.200
    18.529     1.778     0.200
    19.071     2.732     0.200
    19.099     1.885     0.200
    19.318     0.199     0.200
    19.372     0.590     0.200
    19.372     2.309     0.200
    19.434     1.364     0.200
    19.438     2.024     0.200
    19.592     1.475     0.200
    19.641     0.639     0.200
    19.714     0.531     0.200
    19.844     1.596     0.200
    19.844     2.186     0.200
    19.874     1.133     0.200
    20.091     0.546     0.200
    20.146     0.562     0.200
    20.198     0.927     0.200
    20.258     0.523     0.200
    20.286     3.145     0.200
    20.341     2.483     0.200
    20.578     0.367     0.200
    20.701     2.587     0.200
    20.701     3.130     0.200
    20.792     1.149     0.200
    20.837     1.113     0.200
    20.904    -0.091     0.200
    20.946     0.210     0.200
    21.047     0.908     0.200
    21.179     4.538     0.200
    21.337     3.240     0.200
    21.362     4.720     0.200
    21.362     4.005     0.200
    21.518     4.416     0.200
    21.500     1.758     0.200
    21.500     2.520     0.200
    21.566     1.277     0.200
    21.667     4.503     0.200
    21.680     4.544     0.200
    21.726     4.206     0.200
    21.726     1.194     0.200
    21.738    -0.394     0.200
    21.782     3.144     0.200
    21.775     1.341     0.200
    21.807     3.236     0.200
    21.807     3.650     0.200
    21.976     4.077     0.200
    21.953     2.385     0.200
    22.078     0.304     0.200
    22.105    -0.617     0.200
    22.166     4.445     0.200
    22.156     0.054     0.200
    22.286     1.135     0.200
    22.296     1.385     0.200
    22.296     2.518     0.200
    22.405     2.522     0.200
    22.405    -0.163     0.200
    22.407     0.591     0.200
    22.467     1.407     0.200
    22.467     2.005     0.200
    22.539     4.777     0.200
    22.616     0.465     0.200
    22.783     0.936     0.200
    22.914     4.654     0.200
    22.979     5.170     0.200
    23.007     1.133     0.200
    23.014     0.480     0.200
    23.056     1.756     0.200
    23.190     3.261     0.200
    23.266     4.948     0.200
    23.327     4.929     0.200
    23.505     2.201     0.200
    23.505     3.904     0.200
    23.541     4.790     0.200
    23.538     1.045     0.200
    23.562    -0.044     0.200
    23.562     0.347     0.200
    23.615     5.424     0.200
    23.634     0.233     0.200
    23.694     5.045     0.200
    23.739     5.038     0.200
    23.795     0.674     0.200
    23.852     3.868     0.200
    23.934     4.305     0.200
    23.976     2.785     0.200
    24.036     1.472     0.200
    24.076     4.210     0.200
    24.074     0.153     0.200
    24.118     4.185     0.200
    24.095     1.812     0.200
    24.165     3.333     0.200
    24.333     4.438     0.200
    24.350     1.583     0.200
    24.405     2.525     0.200
    24.423     2.674     0.200
    24.423     3.947     0.200
    24.573     1.450     0.200
    24.573     2.325     0.200
    24.582     1.971     0.200
    24.628     2.462     0.200
    24.777     4.651     0.200
    24.815     4.551     0.200
    24.850     4.124     0.200
    25.004     4.818     0.200
    25.134     1.663     0.200
    25.171     0.961     0.200
    25.264     1.636     0.200
    25.355     2.183     0.200
    25.457     4.342     0.200
    25.470     4.189     0.200
    25.477     4.543     0.200
    25.607     3.631     0.200
    25.638     4.425     0.200
    25.649     2.515     0.200
    25.845     3.971     0.200
    25.938     2.479     0.200
    26.171     1.277     0.200
    26.354     2.053     0.200
    26.435     2.483     0.200
    26.532     2.156     0.200
    26.542     2.049     0.200
    26.588     1.544     0.200
    26.742     3.796     0.200
    26.779     1.660     0.200
    26.878     0.399     0.200
    26.997     2.290     0.200
    27.036     3.073     0.200
    27.036     4.940     0.200
    27.069     2.011     0.200
    27.232     3.084     0.200
    27.232     2.881     0.200
    27.232     1.834     0.200
    27.232     2.432     0.200
    27.262     1.291     0.200
    27.274     1.933     0.200
    27.394     4.103     0.200
    27.398     2.979     0.200
    27.440     1.518     0.200
    27.500     2.328     0.200
    27.512     1.420     0.200
    27.762     2.410     0.200
    28.364     1.989     0.200
    28.614     1.984     0.200
    28.916     2.380     0.200
    28.947     2.757     0.200
    28.985     2.222     0.200
    29.018     3.497     0.200
    29.375     3.179     0.200
    29.471     3.286     0.200
    29.541     1.892     0.200
    29.874     3.267     0.200
    30.096     2.254     0.200
    30.309     2.541     0.200
    30.358     1.650     0.200
    30.414     3.285     0.200
    30.476     2.865     0.200
    30.712     2.205     0.200
    30.984     2.350     0.200
    31.592     2.089     0.200
    31.755     2.165     0.200
    31.809     2.287     0.200
    31.819     2.165     0.200
    31.819     2.868     0.200
    32.203     3.217     0.200
    32.234     2.767     0.200
    32.473     1.477     0.200
    32.473     2.079     0.200
    32.743     1.956     0.200
    32.836     2.306     0.200
    32.976     2.063     0.200
    33.320     1.464     0.200
    33.531     1.251     0.200
    33.543     2.255     0.200
    33.653     1.197     0.200
    34.465     1.821     0.200
    34.489     3.598     0.200
    35.146     1.701     0.200
    36.040     2.147     0.200
    37.431     2.299     0.200
    37.911     1.617     0.200
    39.414     2.181     0.200
    45.557     3.837     0.200
    45.617     0.934     0.200
    45.617     1.266     0.200
    46.225     3.963     0.200
    46.730     2.993     0.200
    46.743     3.043     0.200
    46.847     0.734     0.200
    46.847     2.109     0.200
    47.137     4.016     0.200
    47.234     3.566     0.200
    47.234     4.124     0.200
    47.235     3.254     0.200
    48.118     4.146     0.200
    48.277     4.094     0.200
    48.759     4.428     0.200
    49.222     3.215     0.200
    49.240     3.381     0.200
    49.381     3.901     0.200
    49.513     4.318     0.200
    49.881     4.155     0.200
    50.127     2.990     0.200
    50.269     3.822     0.200
    50.289     3.827     0.200
    50.938     3.921     0.200
    51.058     3.769     0.200
    51.166     3.558     0.200
    51.443     3.350     0.200
    51.483     3.458     0.200
    51.583     4.094     0.200
    51.608     4.010     0.200
    51.883     3.752     0.200
    52.002     4.016     0.200
    52.369     3.932     0.200
    52.543     3.698     0.200
    52.583     4.042     0.200
    52.744     4.017     0.200
    53.026     4.065     0.200
    53.313     4.115     0.200
    53.356     3.919     0.200
    53.655     3.768     0.200
    53.861     3.861     0.200
    54.051     3.948     0.200
    54.051     4.159     0.200
    54.200     3.760     0.200
    54.352     4.131     0.200
    54.417     3.095     0.200
    54.601     3.593     0.200
    54.614     3.160     0.200
    54.642     3.198     0.200
    54.684     3.768     0.200
    54.700     2.529     0.200
    54.799     3.932     0.200
    54.945     2.691     0.200
    55.102     3.349     0.200
    55.144     3.063     0.200
    55.179     2.229     0.200
    55.185     3.317     0.200
    55.264     3.940     0.200
    55.301     3.522     0.200
    55.467     4.098     0.200
    55.464     2.621     0.200
    55.464     3.535     0.200
    55.699     3.579     0.200
    55.773     2.529     0.200
    55.787     2.476     0.200
    55.787     2.577     0.200
    55.904     3.195     0.200
    55.935     2.853     0.200
    55.940     3.148     0.200
    56.049     3.259     0.200
    56.105     3.797     0.200
    56.110     3.621     0.200
    56.142     3.508     0.200
    56.155     2.926     0.200
    56.262     3.414     0.200
    56.411     2.809     0.200
    56.412     3.502     0.200
    56.457     2.964     0.200
    56.488     3.391     0.200
    56.517     2.570     0.200
    56.622     3.191     0.200
    56.633     2.904     0.200
    56.644     3.207     0.200
    56.802     2.781     0.200
    56.931     2.891     0.200
    57.020     2.886     0.200
    57.124     2.718     0.200
    57.208     1.860     0.200
    57.208     2.013     0.200
    57.250     3.204     0.200
    57.253     2.688     0.200
    57.379     3.093     0.200
    57.431     1.916     0.200
    57.431     2.525     0.200
    57.498     2.904     0.200
    57.633     2.967     0.200
    57.673     2.791     0.200
    57.685     3.014     0.200
    57.761     2.303     0.200
    57.813     3.293     0.200
    57.821     2.723     0.200
    58.012     4.153     0.200
    58.015     2.988     0.200
    58.244     2.764     0.200
    58.283     2.367     0.200
    58.302     2.927     0.200
    58.297     2.701     0.200
    58.366     2.863     0.200
    58.396     2.525     0.200
    58.457     3.073     0.200
    58.512     2.915     0.200
    58.523     3.133     0.200
    58.561     2.500     0.200
    58.604     2.451     0.200
    58.602     2.624     0.200
    58.639     3.232     0.200
    58.710     2.434     0.200
    58.709     1.688     0.200
    58.826     3.591     0.200
    58.903     3.679     0.200
    58.931     3.214     0.200
    58.962     3.494     0.200
    58.967     3.044     0.200
    59.007     2.624     0.200
    59.016     2.864     0.200
    59.030     2.369     0.200
    59.189     2.465     0.200
    59.320     3.071     0.200
    59.331     2.688     0.200
    59.420     3.199     0.200
    59.484     2.445     0.200
    59.500     2.694     0.200
    59.626     2.318     0.200
    59.835     2.643     0.200
    59.870     2.180     0.200
    59.886     2.491     0.200
    60.029     2.336     0.200
    60.148     2.787     0.200
    60.447     2.490     0.200
    60.700     2.939     0.200
    60.778     3.429     0.200
    60.785     2.717     0.200
    60.964     3.214     0.200
    61.006     3.754     0.200
    63.887     2.929     0.200
    64.227     4.513     0.200
    64.578     3.923     0.200
    83.085     2.052     0.200
    83.781     1.266     0.200
    86.187     3.559     0.200
    17.552     4.590     0.200
    19.600     1.093     0.200
    19.587     1.467     0.200
    19.587     2.897     0.200
    19.587     3.240     0.200
    19.777     0.973     0.200
    20.504     0.843     0.200
    20.904     1.026     0.200
    20.910     1.203     0.200
    21.020     4.936     0.200
    21.080     4.688     0.200
    21.481     4.537     0.200
    21.841     4.621     0.200
    21.957     4.239     0.200
    21.957     4.512     0.200
    21.993    -0.184     0.200
    21.993     0.410     0.200
    22.170     4.698     0.200
    22.305     3.666     0.200
    22.315     3.616     0.200
    22.315     3.147     0.200
    22.344     4.580     0.200
    22.352     4.558     0.200
    22.368     4.481     0.200
    22.638     4.579     0.200
    22.701     4.548     0.200
    22.819     4.335     0.200
    22.838     5.093     0.200
    23.027     2.066     0.200
    23.127     4.066     0.200
    23.202     4.592     0.200
    23.210     3.991     0.200
    23.210     4.737     0.200
    23.566     4.164     0.200
    23.659     1.318     0.200
    23.655     4.435     0.200
    23.852     4.527     0.200
    23.966     2.718     0.200
    23.934     4.517     0.200
    23.984     4.015     0.200
    24.188     4.709     0.200
    24.281     0.418     0.200
    24.421     1.138     0.200
    24.434     1.135     0.200
    24.431     3.980     0.200
    24.551     1.738     0.200
    24.580     5.066     0.200
    24.836     4.454     0.200
    24.926     3.245     0.200
    25.003     4.546     0.200
    25.084     3.752     0.200
    25.225     5.328     0.200
    25.466     1.722     0.200
    25.485     4.957     0.200
    25.518     4.757     0.200
    25.677     4.944     0.200
    25.820     4.822     0.200
    26.002     1.454     0.200
    26.072     4.110     0.200
    26.177     1.596     0.200
    26.223     4.032     0.200
    26.613     1.203     0.200
    26.946     1.324     0.200
    27.277     1.445     0.200
    27.402     1.276     0.200
    27.428     1.986     0.200
    27.498     1.063     0.200
    27.597     4.277     0.200
    27.675     5.061     0.200
    27.675     4.752     0.200
    27.735     3.003     0.200
    27.735     3.300     0.200
    27.735     3.547     0.200
    27.735     2.524     0.200
    27.735     2.875     0.200
    27.987     4.504     0.200
    28.540     1.640     0.200
    28.655     3.560     0.200
    28.977     3.295     0.200
    29.509     1.433     0.200
    29.857     3.630     0.200
    29.857     3.259     0.200
    30.027     3.677     0.200
    30.272     1.655     0.200
    30.321     4.919     0.200
    30.742     2.859     0.200
    30.922     3.807     0.200
    30.997     4.438     0.200
    31.367     3.155     0.200
    31.871     2.383     0.200
    31.921     3.980     0.200
    31.998     3.905     0.200
    32.020     0.920     0.200
    32.217     2.428     0.200
    32.704     3.654     0.200
    32.704     2.466     0.200
    32.727     3.727     0.200
    33.815    -0.313     0.200
    38.270     1.893     0.200
    44.106     2.446     0.200
    45.629     1.535     0.200
    45.629     0.906     0.200
    46.784     3.455     0.200
    46.857     3.648     0.200
    47.248     3.558     0.200
    47.283     1.605     0.200
    47.781     3.473     0.200
    47.791     3.310     0.200
    48.804     3.322     0.200
    48.821     3.326     0.200
    48.835     3.482     0.200
    49.720     2.015     0.200
    49.935     3.274     0.200
    50.058     3.553     0.200
    50.442     4.008     0.200
    50.827     3.732     0.200
    51.477     3.370     0.200
    51.499     3.204     0.200
    51.611     3.146     0.200
    51.697     3.109     0.200
    51.989     3.436     0.200
    52.018     3.474     0.200
    52.156     3.524     0.200
    52.166     5.112     0.200
    52.166     3.628     0.200
    52.232     3.231     0.200
    52.434     3.467     0.200
    52.562     3.298     0.200
    52.762     3.602     0.200
    52.926     3.428     0.200
    53.085     3.276     0.200
    53.150     4.042     0.200
    53.306     3.645     0.200
    53.574     3.206     0.200
    53.715     3.584     0.200
    53.873     3.399     0.200
    53.898     3.614     0.200
    54.188     3.836     0.200
    54.417     3.257     0.200
    54.621     3.878     0.200
    54.759     3.160     0.200
    54.954     3.064     0.200
    54.954     2.896     0.200
    55.154     3.318     0.200
    55.167     3.115     0.200
    55.204     3.794     0.200
    55.371     3.144     0.200
    55.672     2.526     0.200
    55.695     3.000     0.200
    55.695     2.609     0.200
    55.847     3.782     0.200
    55.847     2.606     0.200
    55.991     2.683     0.200
    56.001     3.000     0.200
    56.035     3.412     0.200
    56.272     2.525     0.200
    56.272     2.357     0.200
    56.272     3.023     0.200
    56.328     3.897     0.200
    56.468     3.296     0.200
    56.492     3.219     0.200
    56.651     3.574     0.200
    56.651     3.172     0.200
    56.665     2.907     0.200
    56.943     2.961     0.200
    56.995     2.437     0.200
    57.044     2.811     0.200
    57.046     2.909     0.200
    57.247     2.572     0.200
    57.352     2.968     0.200
    57.352     3.135     0.200
    57.453     2.443     0.200
    57.592     3.013     0.200
    57.640     1.997     0.200
    57.640     2.411     0.200
    57.708     3.334     0.200
    57.808     3.001     0.200
    57.838     3.147     0.200
    57.922     2.711     0.200
    57.983     3.121     0.200
    57.983     3.000     0.200
    57.983     2.562     0.200
    58.078     3.050     0.200
    58.199     2.468     0.200
    58.198     2.852     0.200
    58.323     2.711     0.200
    58.353     2.837     0.200
    58.386     2.900     0.200
    58.390     2.531     0.200
    58.451     2.305     0.200
    58.585     2.660     0.200
    58.622     3.085     0.200
    58.687     2.682     0.200
    58.737     3.232     0.200
    58.765     2.432     0.200
    58.830     2.623     0.200
    58.912     2.701     0.200
    58.963     3.486     0.200
    59.077     2.195     0.200
    59.092     3.165     0.200
    59.164     2.797     0.200
    59.169     2.854     0.200
    59.170     2.965     0.200
    59.204     2.548     0.200
    59.246     2.646     0.200
    59.285     2.645     0.200
    59.285     2.415     0.200
    59.452     2.200     0.200
    59.446     2.840     0.200
    59.489     2.155     0.200
    59.525     2.346     0.200
    59.587     2.655     0.200
    59.598     2.632     0.200
    59.615     2.423     0.200
    59.588     4.179     0.200
    59.835     2.213     0.200
    60.032     3.035     0.200
    60.063     2.256     0.200
    60.066     2.487     0.200
    60.111     2.578     0.200
    60.178     2.176     0.200
    60.328     2.469     0.200
    60.344     2.098     0.200
    60.398     2.374     0.200
    60.436     2.779     0.200
    60.442     2.678     0.200
    60.442     2.779     0.200
    60.450     2.857     0.200
    60.586     2.434     0.200
    60.678     2.027     0.200
    60.698     2.702     0.200
    60.726     2.457     0.200
    60.755     1.954     0.200
    60.974     2.672     0.200
    61.022     2.528     0.200
    61.056     3.470     0.200
    61.234     3.484     0.200
    61.240     3.039     0.200
    61.299     2.383     0.200
    61.426     2.734     0.200
    61.488     2.789     0.200
    61.550     2.919     0.200
    65.474     1.045     0.200
    71.897     0.510     0.200
    83.485     3.129     0.200
    85.869     3.297     0.200
    14.938     4.839     0.200
    15.184     4.309     0.200
    15.263     4.333     0.200
    15.374     3.589     0.200
    15.632     5.830     0.200
    15.733     6.092     0.200
    15.896     4.707     0.200
    16.046     3.845     0.200
    16.098     5.272     0.200
    16.171     4.294     0.200
    16.191     4.833     0.200
    16.335     3.000     0.200
    16.359     5.459     0.200
    16.440     5.287     0.200
    16.605     5.515     0.200
    16.986     3.682     0.200
    17.018     3.017     0.200
    17.059     3.042     0.200
    17.159     4.035     0.200
    17.492     3.754     0.200
    17.507     4.189     0.200
    17.562     2.378     0.200
    17.588     1.797     0.200
    17.928     2.934     0.200
    18.015     1.574     0.200
    18.230     2.070     0.200
    18.257     1.829     0.200
    18.489     1.005     0.200
    18.579     0.551     0.200
    19.136     1.352     0.200
    19.417    -0.014     0.200
    19.632     1.832     0.200
    19.751     1.742     0.200
    19.826     1.343     0.200
    19.816    -0.371     0.200
    19.903     1.912     0.200
    20.239     1.252     0.200
    20.347     1.368     0.200
    20.699     2.412     0.200
    20.863     2.614     0.200
    20.900     1.282     0.200
    20.930    -0.928     0.200
    21.006    -0.795     0.200
    21.377     2.821     0.200
    21.576     4.048     0.200
    21.581     0.289     0.200
    21.603     2.683     0.200
    21.641     2.226     0.200
    21.669     2.796     0.200
    21.711    -0.455     0.200
    21.753     4.013     0.200
    21.973     3.367     0.200
    21.986     3.193     0.200
    21.981     0.767     0.200
    22.033    -0.551     0.200
    22.050     0.092     0.200
    22.085     0.290     0.200
    22.092     0.523     0.200
    22.380     0.026     0.200
    22.434     5.262     0.200
    22.459     1.894     0.200
    22.510     2.150     0.200
    22.606     0.929     0.200
    22.744     5.009     0.200
    22.781     4.829     0.200
    22.806     1.759     0.200
    22.838     1.609     0.200
    22.943     3.184     0.200
    23.006     3.516     0.200
    22.978     0.360     0.200
    23.016     1.165     0.200
    23.020     0.797     0.200
    23.271     2.584     0.200
    23.340    -0.564     0.200
    23.406     2.797     0.200
    23.418     2.969     0.200
    23.469     3.567     0.200
    23.494    -0.828     0.200
    23.529     0.573     0.200
    23.529     2.303     0.200
    23.670     2.482     0.200
    23.689     0.781     0.200
    23.762     1.169     0.200
    23.976     1.217     0.200
    24.060     4.098     0.200
    24.059    -0.002     0.200
    24.152     3.748     0.200
    24.143     0.186     0.200
    24.171     2.316     0.200
    24.302     1.535     0.200
    24.343     1.583     0.200
    24.323     0.062     0.200
    24.368     3.245     0.200
    24.428     3.271     0.200
    24.408     0.331     0.200
    24.603     3.825     0.200
    24.684     3.040     0.200
    24.735     3.483     0.200
    24.739     3.500     0.200
    24.792     2.454     0.200
    25.160     3.612     0.200
    25.182     2.623     0.200
    25.225    -0.013     0.200
    25.385     2.376     0.200
    25.728     3.602     0.200
    25.776     2.516     0.200
    25.876     2.178     0.200
    26.440    -0.411     0.200
    26.506     0.852     0.200
    26.835     0.640     0.200
    26.874     2.125     0.200
    26.915    -0.055     0.200
    26.956     2.753     0.200
    27.189     3.179     0.200
    27.266     3.071     0.200
    27.266     5.146     0.200
    27.413     2.517     0.200
    27.413     2.407     0.200
    27.413     3.557     0.200
    27.413     2.136     0.200
    27.434     0.318     0.200
    27.526     2.940     0.200
    29.548     2.457     0.200
    30.596     3.530     0.200
    30.663     3.253     0.200
    31.036     3.497     0.200
    38.039     1.238     0.200
    38.076     2.020     0.200
    45.620     1.835     0.200
    47.004     2.146     0.200
    57.630     3.227     0.200
    15.098     5.644     0.200
    15.480     8.603     0.200
    15.815     5.736     0.200
    15.833     5.105     0.200
    16.053     4.927     0.200
    16.395     5.945     0.200
    16.395     7.606     0.200
    16.531     4.627     0.200
    16.532     4.698     0.200
    16.655     4.370     0.200
    16.951     4.732     0.200
    17.032     4.378     0.200
    17.376     5.159     0.200
    17.692     5.665     0.200
    17.977     4.074     0.200
    18.005     3.653     0.200
    18.005     4.028     0.200
    18.092     3.330     0.200
    18.092     2.976     0.200
    18.301     5.051     0.200
    18.634     0.028     0.200
    18.634     1.319     0.200
    18.724     0.681     0.200
    18.724     1.472     0.200
    19.400     1.414     0.200
    19.466     2.028     0.200
    19.540     2.086     0.200
    19.703     1.470     0.200
    19.769     2.843     0.200
    19.801     1.090     0.200
    20.139     1.070     0.200
    20.139     1.628     0.200
    20.144     0.825     0.200
    20.144     0.426     0.200
    20.208     0.837     0.200
    20.208     1.122     0.200
    20.240     2.079     0.200
    20.259     1.051     0.200
    20.488     2.858     0.200
    20.532     1.477     0.200
    20.773     1.409     0.200
    20.787     1.162     0.200
    21.045     3.593     0.200
    21.050     3.651     0.200
    21.077     1.560     0.200
    21.082     0.947     0.200
    21.144     0.898     0.200
    21.159     4.427     0.200
    21.181     4.286     0.200
    21.182     0.315     0.200
    21.182     0.959     0.200
    21.213     0.619     0.200
    21.272     4.163     0.200
    21.371     0.880     0.200
    21.371     1.425     0.200
    21.474     3.097     0.200
    21.470     0.882     0.200
    21.493     4.411     0.200
    21.516     3.843     0.200
    21.517     1.310     0.200
    21.541     3.824     0.200
    21.698     0.882     0.200
    21.703    -0.046     0.200
    21.708     1.123     0.200
    21.864     1.190     0.200
    21.863     1.805     0.200
    21.932     2.699     0.200
    21.934     0.946     0.200
    21.956     0.058     0.200
    22.035     4.401     0.200
    22.042     4.284     0.200
    22.054     4.367     0.200
    22.136     1.599     0.200
    22.136     2.263     0.200
    22.121    -0.299     0.200
    22.200     0.433     0.200
    22.200    -0.045     0.200
    22.350     0.310     0.200
    22.390     2.329     0.200
    22.380    -0.043     0.200
    22.391     0.668     0.200
    22.410     0.409     0.200
    22.445     4.208     0.200
    22.454     0.044     0.200
    22.454     0.854     0.200
    22.472     3.373     0.200
    22.462     0.630     0.200
    22.502    -0.175     0.200
    22.588    -0.013     0.200
    22.588     0.755     0.200
    22.601     1.802     0.200
    22.691     0.423     0.200
    22.773     4.155     0.200
    22.791    -0.310     0.200
    22.791     0.138     0.200
    22.850     2.944     0.200
    22.860     2.883     0.200
    22.902     4.261     0.200
    22.951    -0.122     0.200
    22.951     0.328     0.200
    23.038     2.690     0.200
    23.078     3.963     0.200
    23.092     3.654     0.200
    23.191     3.946     0.200
    23.221     3.285     0.200
    23.237     0.044     0.200
    23.255     3.667     0.200
    23.282     2.045     0.200
    23.282     2.357     0.200
    23.282     2.818     0.200
    23.303    -0.350     0.200
    23.368     0.225     0.200
    23.443     0.653     0.200
    23.446    -0.072     0.200
    23.458     3.762     0.200
    23.473    -0.239     0.200
    23.589     0.615     0.200
    23.609     3.720     0.200
    23.615     3.727     0.200
    23.659     0.631     0.200
    23.706     3.669     0.200
    23.721     0.681     0.200
    23.836     3.339     0.200
    23.866     0.802     0.200
    23.867     1.616     0.200
    23.982     3.265     0.200
    24.024     1.337     0.200
    24.079     4.130     0.200
    24.089     3.716     0.200
    24.099     1.041     0.200
    24.106     1.103     0.200
    24.149     3.243     0.200
    24.255     1.346     0.200
    24.302     0.416     0.200
    24.338     0.524     0.200
    24.355     4.538     0.200
    24.389     4.720     0.200
    24.378     2.561     0.200
    24.378     2.866     0.200
    24.405     2.677     0.200
    24.404     4.634     0.200
    24.402     1.875     0.200
    24.414     2.248     0.200
    24.502     4.057     0.200
    24.525     1.871     0.200
    24.525     2.770     0.200
    24.587     4.568     0.200
    24.588     1.286     0.200
    24.630     1.379     0.200
    24.624     0.929     0.200
    24.624     1.485     0.200
    24.643     1.479     0.200
    24.643     0.510     0.200
    24.663     4.027     0.200
    24.790     2.196     0.200
    24.923     2.214     0.200
    24.941     3.849     0.200
    24.994     4.568     0.200
    25.018     4.780     0.200
    25.029     3.044     0.200
    25.143     4.936     0.200
    25.148     1.149     0.200
    25.190     3.409     0.200
    25.198     2.756     0.200
    25.245     2.054     0.200
    25.333     4.307     0.200
    25.409     1.104     0.200
    25.414     1.422     0.200
    25.445     1.836     0.200
    25.472     1.930     0.200
    25.487     1.461     0.200
    25.487     1.565     0.200
    25.500     5.045     0.200
    25.577     1.524     0.200
    25.583     2.225     0.200
    25.602     4.344     0.200
    25.701     1.848     0.200
    25.761     1.910     0.200
    25.807     2.837     0.200
    25.925     5.082     0.200
    26.022     0.936     0.200
    26.112     1.624     0.200
    26.112     1.829     0.200
    26.212     2.457     0.200
    26.212     3.559     0.200
    26.274     4.095     0.200
    26.312     1.012     0.200
    26.397     1.028     0.200
    26.397     0.825     0.200
    26.385     4.472     0.200
    26.504     0.416     0.200
    26.480     3.624     0.200
    26.585     5.136     0.200
    26.566     5.082     0.200
    26.637     1.562     0.200
    26.653     1.539     0.200
    26.688     0.921     0.200
    26.641     3.420     0.200
    26.721     1.980     0.200
    26.764     2.852     0.200
    26.778     2.289     0.200
    26.797     0.619     0.200
    26.819     1.655     0.200
    26.868     1.543     0.200
    26.868     1.994     0.200
    26.875    -0.391     0.200
    26.957     2.910     0.200
    26.957     3.503     0.200
    26.965     1.141     0.200
    26.965     1.836     0.200
    27.015     3.841     0.200
    26.988     3.656     0.200
    27.093     1.128     0.200
    27.099     0.899     0.200
    27.127     1.787     0.200
    27.131     1.572     0.200
    27.172     3.042     0.200
    27.169     1.659     0.200
    27.169     2.261     0.200
    27.140     6.642     0.200
    27.155     4.294     0.200
    27.238     4.456     0.200
    27.238     5.755     0.200
    27.364     1.583     0.200
    27.337     2.610     0.200
    27.332     5.162     0.200
    27.345     4.012     0.200
    27.401     1.975     0.200
    27.413     2.090     0.200
    27.412     5.828     0.200
    27.429     6.030     0.200
    27.486     4.045     0.200
    27.447     5.985     0.200
    27.508     1.589     0.200
    27.473     4.936     0.200
    27.528     5.867     0.200
    27.616     3.308     0.200
    27.697     1.525     0.200
    27.704     0.740     0.200
    27.736     1.639     0.200
    27.755     1.637     0.200
    27.764     0.379     0.200
    27.783     1.659     0.200
    27.783     2.731     0.200
    27.828     2.812     0.200
    27.811     4.800     0.200
    27.892     2.027     0.200
    27.864     4.907     0.200
    27.905     2.330     0.200
    27.970     1.613     0.200
    28.024     6.387     0.200
    28.098     3.906     0.200
    28.097     1.934     0.200
    28.097     2.401     0.200
    28.104     6.016     0.200
    28.161     5.421     0.200
    28.219     0.699     0.200
    28.224     5.568     0.200
    28.224     3.767     0.200
    28.272     4.519     0.200
    28.439     2.123     0.200
    28.501     0.935     0.200
    28.580     0.405     0.200
    28.631     1.677     0.200
    28.639     1.423     0.200
    28.658     1.060     0.200
    28.679     5.565     0.200
    28.740     4.083     0.200
    28.721     6.302     0.200
    28.834     2.576     0.200
    28.871     1.908     0.200
    28.896     4.395     0.200
    28.857     5.702     0.200
    28.908     1.740     0.200
    28.894     5.081     0.200
    28.976     2.901     0.200
    29.058     1.956     0.200
    29.082     1.126     0.200
    29.095     2.672     0.200
    29.122     3.802     0.200
    29.121     1.465     0.200
    29.121     1.750     0.200
    29.131     3.671     0.200
    29.131     3.852     0.200
    29.239     0.954     0.200
    29.236     3.846     0.200
    29.236     3.386     0.200
    29.331     2.456     0.200
    29.437     2.184     0.200
    29.468     0.831     0.200
    29.613     2.242     0.200
    29.711     0.912     0.200
    29.801     2.054     0.200
    29.854     5.449     0.200
    29.948     0.889     0.200
    29.951     4.961     0.200
    30.113     2.298     0.200
    30.113     1.884     0.200
    30.073     3.832     0.200
    30.073     2.471     0.200
    30.131     3.744     0.200
    30.177     3.543     0.200
    30.215     6.692     0.200
    30.472     4.976     0.200
    30.646     2.398     0.200
    30.661     1.948     0.200
    30.661     1.825     0.200
    30.783     1.390     0.200
    30.871     1.669     0.200
    30.893     1.850     0.200
    31.017     3.125     0.200
    31.300     2.710     0.200
    31.398     1.102     0.200
    31.462     1.383     0.200
    31.558     1.726     0.200
    31.558     1.993     0.200
    31.561     0.858     0.200
    31.659     2.324     0.200
    31.657     1.529     0.200
    31.841     1.230     0.200
    31.841     0.740     0.200
    31.874     1.036     0.200
    31.899     3.048     0.200
    31.890     2.319     0.200
    31.994     2.933     0.200
    32.583     2.744     0.200
    32.773     2.033     0.200
    32.814     2.328     0.200
    32.856     1.772     0.200
    33.014     2.384     0.200
    33.068     0.590     0.200
    33.174     2.066     0.200
    33.174     2.478     0.200
    33.194     3.112     0.200
    33.286     2.527     0.200
    33.369     2.462     0.200
    33.472     4.596     0.200
    33.491     1.125     0.200
    33.603     1.467     0.200
    33.943     1.815     0.200
    33.978     2.131     0.200
    34.162     2.789     0.200
    34.162     2.289     0.200
    34.179     1.167     0.200
    34.432     1.347     0.200
    34.529     2.553     0.200
    34.793     2.177     0.200
    34.834     2.163     0.200
    35.177     1.675     0.200
    35.430     2.405     0.200
    35.573     2.276     0.200
    35.577     2.402     0.200
    35.729     2.788     0.200
    35.842     2.607     0.200
    36.276     2.678     0.200
    36.349     1.851     0.200
    36.449     3.094     0.200
    36.700     3.818     0.200
    36.731     3.772     0.200
    36.731     4.303     0.200
    36.988     2.079     0.200
    36.987     3.080     0.200
    36.956     3.597     0.200
    36.984     2.452     0.200
    37.657     2.360     0.200
    37.737     2.781     0.200
    37.792     2.068     0.200
    38.456     2.494     0.200
    38.456     2.115     0.200
    38.472     2.494     0.200
    38.827     2.294     0.200
    39.165     2.562     0.200
    39.186     2.235     0.200
    39.345     2.715     0.200
    39.404     2.590     0.200
    39.641     2.862     0.200
    39.707     2.209     0.200
    40.737     3.192     0.200
    41.765     2.578     0.200
    41.765     2.949     0.200
    42.987     1.804     0.200
    42.987     2.396     0.200
    43.999     2.920     0.200
    43.999     2.729     0.200
    44.886     1.242     0.200
    44.886     0.371     0.200
    44.886     1.601     0.200
    45.183     4.114     0.200
    45.829     1.968     0.200
    45.876     4.516     0.200
    45.822     3.422     0.200
    45.822     3.541     0.200
    45.822     3.846     0.200
    45.893     3.996     0.200
    46.343     3.634     0.200
    46.402     1.898     0.200
    46.402     3.479     0.200
    46.427     3.285     0.200
    46.366     4.076     0.200
    46.459     3.370     0.200
    46.642     1.849     0.200
    46.770     3.955     0.200
    46.890     4.032     0.200
    46.900     3.443     0.200
    47.805     3.377     0.200
    47.805     4.070     0.200
    47.862     4.388     0.200
    47.946     4.350     0.200
    48.069     3.998     0.200
    48.400     3.908     0.200
    48.983     2.839     0.200
    48.983     3.269     0.200
    48.934     2.011     0.200
    49.038     3.981     0.200
    49.181     4.302     0.200
    49.186     2.910     0.200
    49.529     3.644     0.200
    49.575     2.176     0.200
    49.963     3.947     0.200
    49.912     2.739     0.200
    50.213     3.604     0.200
    50.511     4.070     0.200
    50.511     4.482     0.200
    50.548     3.751     0.200
    50.500     1.559     0.200
    50.585     4.305     0.200
    50.632     2.957     0.200
    50.715     3.842     0.200
    50.849     3.137     0.200
    50.849     3.678     0.200
    51.108     3.938     0.200
    51.161     4.263     0.200
    51.215     4.323     0.200
    51.259     4.046     0.200
    51.259     4.658     0.200
    51.308     3.620     0.200
    51.543     3.702     0.200
    51.651     3.366     0.200
    51.639     1.795     0.200
    51.822     4.171     0.200
    51.808     1.737     0.200
    51.871     2.152     0.200
    52.021     4.815     0.200
    52.027     1.593     0.200
    52.215     4.020     0.200
    52.223     4.281     0.200
    52.689     4.454     0.200
    52.783     3.932     0.200
    52.962     3.922     0.200
    53.027     4.002     0.200
    53.046     3.972     0.200
    53.082     1.229     0.200
    53.335     4.014     0.200
    53.340     3.715     0.200
    53.484     4.423     0.200
    53.515     3.431     0.200
    53.687     3.466     0.200
    53.819     3.398     0.200
    53.849     4.020     0.200
    53.956     3.713     0.200
    53.964     3.232     0.200
    54.258     3.496     0.200
    54.271     3.503     0.200
    54.271     4.099     0.200
    54.288     4.097     0.200
    54.302     3.822     0.200
    54.431     4.270     0.200
    54.484     2.260     0.200
    54.637     2.407     0.200
    54.709     2.435     0.200
    54.795     3.293     0.200
    54.892     2.609     0.200
    54.891     4.041     0.200
    54.832     2.745     0.200
    54.908     2.593     0.200
    54.967     4.291     0.200
    55.038     3.234     0.200
    55.016     2.906     0.200
    55.106     3.042     0.200
    55.053     3.538     0.200
    55.195     2.403     0.200
    55.201     2.472     0.200
    55.332     3.783     0.200
    55.524     2.553     0.200
    55.524     2.832     0.200
    55.547     3.055     0.200
    55.547     3.197     0.200
    55.547     2.869     0.200
    55.598     4.019     0.200
    55.641     3.437     0.200
    55.651     3.035     0.200
    55.770     3.488     0.200
    55.770     3.717     0.200
    55.780     3.547     0.200
    55.824     3.299     0.200
    55.881     3.567     0.200
    56.034     3.776     0.200
    56.006     3.246     0.200
    56.063     2.947     0.200
    56.131     3.106     0.200
    56.139     3.381     0.200
    56.203     3.668     0.200
    56.206     3.318     0.200
    56.251     3.086     0.200
    56.255     3.454     0.200
    56.317     3.394     0.200
    56.328     3.404     0.200
    56.382     2.628     0.200
    56.424     2.338     0.200
    56.385     3.221     0.200
    56.463     2.891     0.200
    56.435     3.156     0.200
    56.625     2.829     0.200
    56.652     3.060     0.200
    56.711     3.338     0.200
    56.741     3.061     0.200
    56.687     1.967     0.200
    56.862     3.559     0.200
    56.803     1.139     0.200
    56.899     3.063     0.200
    56.906     3.040     0.200
    57.004     2.183     0.200
    57.043     2.910     0.200
    57.048     3.101     0.200
    57.055     3.239     0.200
    57.088     2.131     0.200
    57.088     2.900     0.200
    57.033     3.698     0.200
    57.122     2.928     0.200
    57.149     3.136     0.200
    57.273     3.147     0.200
    57.291     3.095     0.200
    57.362     2.992     0.200
    57.367     3.323     0.200
    57.476     2.769     0.200
    57.488     2.552     0.200
    57.488     2.126     0.200
    57.492     2.409     0.200
    57.521     3.398     0.200
    57.486     2.275     0.200
    57.571     2.065     0.200
    57.585     2.562     0.200
    57.649     3.504     0.200
    57.777     2.531     0.200
    57.870     2.686     0.200
    57.873     2.288     0.200
    57.895     3.169     0.200
    57.904     2.743     0.200
    57.853     2.075     0.200
    57.939     3.512     0.200
    57.977     3.527     0.200
    57.977     2.774     0.200
    58.032     3.458     0.200
    57.996     3.759     0.200
    58.067     3.064     0.200
    58.136     3.160     0.200
    58.146     2.761     0.200
    58.177     3.218     0.200
    58.201     2.706     0.200
    58.201     2.505     0.200
    58.242     2.311     0.200
    58.182     2.745     0.200
    58.329     2.333     0.200
    58.339     2.589     0.200
    58.300     3.419     0.200
    58.384     3.292     0.200
    58.396     3.490     0.200
    58.478     2.892     0.200
    58.504     3.658     0.200
    58.601     2.964     0.200
    58.615     3.176     0.200
    58.616     2.995     0.200
    58.626     3.832     0.200
    58.645     2.927     0.200
    58.650     2.076     0.200
    58.652     3.945     0.200
    58.693     3.361     0.200
    58.761     0.286     0.200
    58.781     2.854     0.200
    58.930     3.097     0.200
    58.984     3.151     0.200
    59.000     2.991     0.200
    59.047     2.976     0.200
    59.106     3.071     0.200
    59.108     3.371     0.200
    59.148     2.740     0.200
    59.170     3.358     0.200
    59.124     3.057     0.200
    59.237     2.818     0.200
    59.283     2.489     0.200
    59.316     2.865     0.200
    59.348     2.422     0.200
    59.411     3.001     0.200
    59.456     2.457     0.200
    59.456     0.974     0.200
    59.488     3.134     0.200
    59.502     2.529     0.200
    59.489     2.318     0.200
    59.555     3.200     0.200
    59.571     3.776     0.200
    59.591     2.984     0.200
    59.680     2.660     0.200
    59.727     1.095     0.200
    59.733     2.691     0.200
    59.752     2.593     0.200
    59.832     3.967     0.200
    59.849     2.458     0.200
    59.907     2.848     0.200
    60.007     2.095     0.200
    60.031     3.080     0.200
    59.988     2.435     0.200
    59.988     3.056     0.200
    59.988     1.521     0.200
    60.139     2.648     0.200
    60.178     1.882     0.200
    60.201     2.400     0.200
    60.235     2.427     0.200
    60.306     2.831     0.200
    60.309     2.973     0.200
    60.342     2.582     0.200
    60.370     2.576     0.200
    60.372     3.486     0.200
    60.401     2.570     0.200
    60.488     2.861     0.200
    60.506     1.832     0.200
    60.506     0.990     0.200
    60.572     3.013     0.200
    60.615     2.086     0.200
    60.654     3.675     0.200
    60.672     3.382     0.200
    60.704     1.989     0.200
    60.774     3.397     0.200
    60.817     3.663     0.200
    60.842     3.110     0.200
    60.869     3.221     0.200
    60.975     2.250     0.200
    60.999     2.735     0.200
    60.960     2.169     0.200
    61.106     2.729     0.200
    61.113     2.829     0.200
    61.192     2.782     0.200
    61.151     2.271     0.200
    61.159     3.119     0.200
    61.241     2.381     0.200
    61.343     2.613     0.200
    61.369     2.798     0.200
    61.471     2.089     0.200
    61.404     3.386     0.200
    61.559     2.853     0.200
    61.509     2.242     0.200
    61.612     2.710     0.200
    61.671     2.805     0.200
    61.798     3.117     0.200
    61.863     2.521     0.200
    61.881     3.140     0.200
    61.959     3.054     0.200
    61.975     2.382     0.200
    62.040     3.675     0.200
    62.075     2.898     0.200
    62.089     3.309     0.200
    62.119     2.883     0.200
    62.099     2.741     0.200
    62.177     2.959     0.200
    62.454     2.643     0.200
    62.581     3.178     0.200
    62.602     3.265     0.200
    62.655     2.732     0.200
    62.655     2.593     0.200
    62.700     2.288     0.200
    62.733     2.369     0.200
    62.913     3.354     0.200
    62.981     1.912     0.200
    63.142     3.492     0.200
    63.187     2.902     0.200
    63.215     3.055     0.200
    63.256     2.891     0.200
    63.282     3.493     0.200
    63.337     2.832     0.200
    63.543     3.289     0.200
    63.591     3.263     0.200
    63.623     1.050     0.200
    63.679     4.150     0.200
    63.679     3.859     0.200
    63.706     3.669     0.200
    63.780     2.584     0.200
    63.814     2.957     0.200
    64.079     2.229     0.200
    64.029     3.034     0.200
    64.220     3.385     0.200
    64.159     3.374     0.200
    64.300     3.676     0.200
    64.494     2.969     0.200
    64.827     3.838     0.200
    64.842     3.681     0.200
    65.049     3.002     0.200
    65.226     2.671     0.200
    65.293     1.548     0.200
    65.493     3.384     0.200
    65.593     3.576     0.200
    65.752     3.003     0.200
    65.752     1.893     0.200
    65.875     3.548     0.200
    65.985     2.839     0.200
    66.047     3.484     0.200
    66.294     4.138     0.200
    66.312     3.425     0.200
    66.701     1.961     0.200
    66.732     3.630     0.200
    67.624     4.771     0.200
    68.147     3.709     0.200
    68.368     3.813     0.200
    69.091     3.330     0.200
    69.418     3.396     0.200
    71.217     0.053     0.200
    71.799     1.234     0.200
    72.497     0.336     0.200
    78.853     2.691     0.200
    80.456     3.286     0.200
    80.688     3.141     0.200
    80.778     3.557     0.200
    80.971     3.229     0.200
    81.061     3.346     0.200
    81.226     2.969     0.200
    81.235     3.623     0.200
    81.399     3.552     0.200
    81.522     3.501     0.200
    81.540     3.808     0.200
    81.540     3.228     0.200
    81.582     3.387     0.200
    81.591     3.036     0.200
    81.625     2.957     0.200
    81.731     3.998     0.200
    81.761     3.041     0.200
    81.763     3.632     0.200
    81.914     4.536     0.200
    82.037     3.687     0.200
    82.354     3.329     0.200
    82.699     2.329     0.200
    83.605     0.750     0.200
    83.605     3.023     0.200
    83.994     2.631     0.200
    83.994     3.631     0.200
    84.242     3.127     0.200
    84.316     4.794     0.200
    84.512     4.850     0.200
    84.765     2.358     0.200
    85.291     1.915     0.200
    85.304     4.821     0.200
    85.346     4.748     0.200
    85.399     2.479     0.200
    85.399     2.629     0.200
    85.577     4.479     0.200
    85.649     2.241     0.200
    85.649     1.932     0.200
    85.755     4.184     0.200
    85.842     1.773     0.200
    86.004     4.004     0.200
    86.486     4.968     0.200
    86.531     3.100     0.200
    86.689     0.124     0.200
    87.143     1.579     0.200
    87.243     3.166     0.200
    87.300     5.550     0.200
    90.821     2.357     0.200
    91.182     0.655     0.200
    91.298     3.450     0.200
    91.487     3.220     0.200
    91.569     3.187     0.200
    92.011     2.842     0.200
    92.402     1.707     0.200
    92.480     2.712     0.200
    92.699     2.270     0.200
    93.044     2.501     0.200
    93.385    -0.702     0.200
    93.814     2.824     0.200
    93.829     2.054     0.200
    93.829     2.929     0.200
    94.044     2.622     0.200
    94.094     3.137     0.200
    94.250     2.173     0.200
    94.476     3.041     0.200
    95.493     3.181     0.200
    95.672     1.777     0.200
    96.152     0.632     0.200
    97.226     0.764     0.200
    97.503     1.792     0.200
    16.364     4.653     0.200
    16.539     5.212     0.200
    18.252     2.673     0.200
    18.396     1.303     0.200
    18.423     2.183     0.200
    18.916     3.382     0.200
    18.916     2.507     0.200
    18.916     3.053     0.200
    19.038     3.569     0.200
    19.221     0.791     0.200
    19.288     1.141     0.200
    19.288     1.329     0.200
    19.536     1.569     0.200
    19.432     3.063     0.200
    19.675     0.413     0.200
    19.837     1.194     0.200
    19.837     1.475     0.200
    20.071     0.671     0.200
    20.140     1.516     0.200
    20.173     3.359     0.200
    20.346     1.093     0.200
    20.561     1.531     0.200
    20.561     3.297     0.200
    20.712     1.320     0.200
    20.783     0.400     0.200
    20.930     0.078     0.200
    21.112    -0.278     0.200
    21.136    -0.768     0.200
    21.189     3.652     0.200
    21.274     0.998     0.200
    21.355     2.980     0.200
    21.355     2.676     0.200
    21.362     4.019     0.200
    21.478     3.662     0.200
    21.510     0.808     0.200
    21.544     2.873     0.200
    21.623     2.699     0.200
    21.657     3.194     0.200
    21.752     0.695     0.200
    21.790     3.724     0.200
    21.835     3.658     0.200
    21.848     3.233     0.200
    21.948     0.380     0.200
    21.948     1.568     0.200
    21.981     3.477     0.200
    22.082    -1.096     0.200
    22.079    -0.391     0.200
    22.091    -1.213     0.200
    22.114     1.254     0.200
    22.168     2.755     0.200
    22.259     3.450     0.200
    22.311     2.304     0.200
    22.341     0.771     0.200
    22.345     4.208     0.200
    22.352     4.205     0.200
    22.356     4.835     0.200
    22.395     0.518     0.200
    22.408     1.962     0.200
    22.468     3.795     0.200
    22.597    -0.021     0.200
    22.691     3.997     0.200
    22.730     5.517     0.200
    22.770     2.761     0.200
    22.790     4.224     0.200
    22.965     4.154     0.200
    23.079     3.632     0.200
    23.142     4.741     0.200
    23.242     3.362     0.200
    23.363     2.938     0.200
    23.357     4.464     0.200
    23.425     4.453     0.200
    23.506     4.074     0.200
    23.557     0.258     0.200
    23.680     3.534     0.200
    23.749     4.911     0.200
    23.783     0.460     0.200
    23.893     4.466     0.200
    24.004     2.523     0.200
    24.004     2.383     0.200
    24.041     3.145     0.200
    24.145     4.635     0.200
    24.271     4.424     0.200
    24.342     2.753     0.200
    24.375     2.546     0.200
    24.377     4.732     0.200
    24.409     4.314     0.200
    24.486     3.407     0.200
    24.584     2.389     0.200
    24.586     4.226     0.200
    24.632     4.468     0.200
    24.669     4.101     0.200
    24.679     4.261     0.200
    24.795     3.259     0.200
    24.816     3.729     0.200
    24.918     3.424     0.200
    24.967     3.369     0.200
    25.050     5.144     0.200
    25.267     3.753     0.200
    25.300     2.233     0.200
    25.285     3.695     0.200
    25.294     4.350     0.200
    25.410     1.806     0.200
    25.430     3.837     0.200
    25.451     4.744     0.200
    25.578     3.125     0.200
    25.656     3.970     0.200
    25.789     3.966     0.200
    25.809     4.475     0.200
    25.894     2.249     0.200
    26.143     1.449     0.200
    26.293     2.963     0.200
    26.371     1.663     0.200
    26.545     2.621     0.200
    26.506     2.729     0.200
    26.555     1.830     0.200
    26.558     4.698     0.200
    26.854     4.031     0.200
    26.899     2.153     0.200
    27.080     3.506     0.200
    27.080     3.507     0.200
    27.208     2.347     0.200
    27.207     2.799     0.200
    27.370     3.447     0.200
    27.424     2.159     0.200
    27.489     1.978     0.200
    28.364     1.940     0.200
    28.607     1.979     0.200
    28.864     2.720     0.200
    28.882     1.853     0.200
    28.865     3.851     0.200
    29.227     3.703     0.200
    29.307     3.945     0.200
    29.393     4.600     0.200
    29.706     1.963     0.200
    30.371     2.400     0.200
    30.664     2.404     0.200
    30.871     2.833     0.200
    31.691     2.714     0.200
    31.727     2.905     0.200
    32.045     3.505     0.200
    32.221     2.712     0.200
    32.468     2.258     0.200
    32.514     4.649     0.200
    32.843     1.701     0.200
    33.431     1.488     0.200
    33.431     2.777     0.200
    35.153     2.000     0.200
    37.758     2.556     0.200
    37.792     2.255     0.200
    42.024     1.348     0.200
    44.456     1.191     0.200
    44.456     2.136     0.200
    45.387     2.230     0.200
    45.585     1.907     0.200
    46.060     2.748     0.200
    46.103     2.555     0.200
    46.451     2.991     0.200
    46.590     3.219     0.200
    46.710     2.164     0.200
    47.071     3.289     0.200
    47.072     3.844     0.200
    47.959     4.469     0.200
    48.062     2.073     0.200
    48.115     3.239     0.200
    48.922     3.402     0.200
    49.052     3.158     0.200
    49.092     3.567     0.200
    49.217     3.345     0.200
    49.351     3.556     0.200
    49.715     3.764     0.200
    50.127     3.713     0.200
    50.388     3.983     0.200
    50.657     4.505     0.200
    50.742     3.900     0.200
    50.772     4.122     0.200
    50.894     3.991     0.200
    51.006     3.380     0.200
    51.280     3.968     0.200
    51.322     3.684     0.200
    51.462     2.395     0.200
    51.414     3.751     0.200
    51.443     3.986     0.200
    51.500     2.403     0.200
    51.719     2.489     0.200
    51.837     3.637     0.200
    52.021     4.459     0.200
    52.204     4.586     0.200
    52.382     3.704     0.200
    52.578     3.624     0.200
    52.863     3.848     0.200
    52.863     4.496     0.200
    52.978     3.514     0.200
    53.195     4.646     0.200
    53.495     4.230     0.200
    53.542     4.418     0.200
    53.616     2.976     0.200
    53.634     3.413     0.200
    53.697     2.557     0.200
    54.034     2.897     0.200
    54.109     2.715     0.200
    54.179     2.583     0.200
    54.256     2.634     0.200
    54.450     2.652     0.200
    54.476     2.781     0.200
    54.513     3.049     0.200
    54.560     2.466     0.200
    54.630     2.164     0.200
    54.771     2.660     0.200
    54.787     2.473     0.200
    54.929     3.054     0.200
    54.979     2.874     0.200
    55.030     2.561     0.200
    55.095     3.366     0.200
    55.139     3.533     0.200
    55.300     3.606     0.200
    55.303     3.058     0.200
    55.333     2.429     0.200
    55.350     3.380     0.200
    55.398     3.131     0.200
    55.531     3.226     0.200
    55.637     3.374     0.200
    55.678     2.869     0.200
    55.737     3.432     0.200
    55.776     2.850     0.200
    55.782     3.566     0.200
    55.845     3.229     0.200
    55.876     3.275     0.200
    55.942     3.627     0.200
    55.945     3.860     0.200
    55.982     3.146     0.200
    55.986     3.646     0.200
    56.092     4.163     0.200
    56.176     3.136     0.200
    56.241     4.384     0.200
    56.237     2.813     0.200
    56.296     2.806     0.200
    56.323     3.295     0.200
    56.359     3.795     0.200
    56.402     3.322     0.200
    56.442     3.734     0.200
    56.462     3.896     0.200
    56.472     2.661     0.200
    56.639     3.163     0.200
    56.658     2.958     0.200
    56.773     3.028     0.200
    56.789     3.006     0.200
    56.793     2.990     0.200
    56.851     3.366     0.200
    56.953     3.216     0.200
    57.091     2.594     0.200
    57.071     2.726     0.200
    57.078     3.121     0.200
    57.088     2.817     0.200
    57.156     3.184     0.200
    57.217     2.256     0.200
    57.217     2.795     0.200
    57.267     3.039     0.200
    57.287     2.339     0.200
    57.287     3.388     0.200
    57.329     3.298     0.200
    57.376     2.648     0.200
    57.386     3.031     0.200
    57.466     2.722     0.200
    57.515     2.869     0.200
    57.588     3.142     0.200
    57.650     2.627     0.200
    57.658     3.750     0.200
    57.676     2.203     0.200
    57.834     2.928     0.200
    57.847     3.060     0.200
    57.962     3.318     0.200
    58.086     3.247     0.200
    58.108     3.012     0.200
    58.124     3.385     0.200
    58.137     3.012     0.200
    58.156     3.168     0.200
    58.192     2.812     0.200
    58.204     3.005     0.200
    58.220     3.136     0.200
    58.285     3.369     0.200
    58.343     3.184     0.200
    58.358     3.702     0.200
    58.385     2.785     0.200
    58.481     2.618     0.200
    58.541     2.910     0.200
    58.548     2.752     0.200
    58.648     2.916     0.200
    58.725     3.244     0.200
    58.735     3.165     0.200
    58.774     2.266     0.200
    58.779     2.845     0.200
    58.801     2.802     0.200
    58.848     2.571     0.200
    58.858     2.726     0.200
    59.014     2.421     0.200
    59.141     2.045     0.200
    59.148     2.603     0.200
    59.243     2.649     0.200
    59.295     2.116     0.200
    59.314     1.827     0.200
    59.334     2.286     0.200
    59.383     2.495     0.200
    59.406     3.003     0.200
    59.421     2.904     0.200
    59.462     2.770     0.200
    59.632     2.640     0.200
    59.553     3.126     0.200
    59.634     1.834     0.200
    59.642     2.482     0.200
    59.657     1.750     0.200
    59.687     0.734     0.200
    59.701     1.557     0.200
    59.731     1.661     0.200
    59.736     1.714     0.200
    59.864     1.768     0.200
    59.941     2.576     0.200
    59.954     2.731     0.200
    59.954     2.153     0.200
    59.981     1.856     0.200
    59.989     2.967     0.200
    60.020     1.935     0.200
    60.102     2.786     0.200
    60.211     2.304     0.200
    60.270     2.749     0.200
    60.291     2.954     0.200
    60.347     3.024     0.200
    60.365     2.774     0.200
    60.515     3.733     0.200
    60.445     1.776     0.200
    60.519     2.745     0.200
    60.539     2.977     0.200
    60.541     1.942     0.200
    60.559     2.871     0.200
    60.625     2.712     0.200
    60.630     2.781     0.200
    60.732     2.958     0.200
    60.797     2.744     0.200
    60.806     2.911     0.200
    60.834     3.321     0.200
    60.843     3.478     0.200
    61.003     3.740     0.200
    61.095     2.991     0.200
    61.167     2.407     0.200
    61.163     3.230     0.200
    61.239     3.604     0.200
    61.249     2.918     0.200
    61.384     3.477     0.200
    61.384     3.938     0.200
    61.489     3.366     0.200
    61.546     2.713     0.200
    61.584     2.947     0.200
    61.658     2.742     0.200
    61.757     1.275     0.200
    61.904     2.590     0.200
    62.109     2.816     0.200
    62.150     1.938     0.200
    62.181     1.981     0.200
    62.189     2.710     0.200
    62.315     3.316     0.200
    62.233     2.914     0.200
    62.250     3.151     0.200
    62.252     2.770     0.200
    62.291     2.920     0.200
    62.291     2.639     0.200
    62.334     2.525     0.200
    62.346     3.159     0.200
    62.357     3.330     0.200
    62.423     2.347     0.200
    62.573     2.901     0.200
    62.759     3.311     0.200
    62.779     3.420     0.200
    62.981     2.427     0.200
    63.110     2.616     0.200
    63.139     3.291     0.200
    63.332     3.390     0.200
    63.416     2.844     0.200
    63.436     3.707     0.200
    63.716     2.651     0.200
    63.732     2.602     0.200
    63.764     2.239     0.200
    63.974     2.613     0.200
    64.086     2.314     0.200
    64.407     2.493     0.200
    64.421     2.369     0.200
    64.478     3.423     0.200
    64.546     2.746     0.200
    64.615     2.614     0.200
    64.712     3.103     0.200
    64.876     2.886     0.200
    65.032     2.472     0.200
    65.329     2.986     0.200
    65.414     2.190     0.200
    65.698     1.333     0.200
    66.957     1.693     0.200
    67.294     1.941     0.200
    83.832     3.493     0.200
    85.679     2.427     0.200
    85.759     2.173     0.200
    26.822     2.743     0.200
    26.974     2.532     0.200
    46.578     0.401     0.200
    15.386     3.586     0.200
    16.869     5.328     0.200
    16.971     2.891     0.200
    16.990     3.089     0.200
    16.990     3.948     0.200
    17.514     1.526     0.200
    18.153     3.718     0.200
    18.974     1.353     0.200
    19.144     1.763     0.200
    19.465     1.809     0.200
    19.747     0.675     0.200
    19.799     0.683     0.200
    19.862     0.409     0.200
    20.335     1.717     0.200
    20.341     2.351     0.200
    20.341     2.601     0.200
    20.514     0.199     0.200
    20.935     3.705     0.200
    20.935     4.228     0.200
    21.064     3.318     0.200
    21.064     4.193     0.200
    21.145     1.622     0.200
    21.145     3.208     0.200
    21.181     0.526     0.200
    21.359     0.454     0.200
    21.451     2.522     0.200
    21.451     3.428     0.200
    21.462     2.577     0.200
    21.462     3.600     0.200
    21.463     4.792     0.200
    21.587     0.362     0.200
    21.587     1.276     0.200
    21.796     5.133     0.200
    21.923     2.322     0.200
    21.913     4.479     0.200
    22.010     1.654     0.200
    22.068     1.952     0.200
    22.249     3.177     0.200
    22.226     4.986     0.200
    22.296     4.144     0.200
    22.297     4.135     0.200
    22.304     4.023     0.200
    22.660     4.706     0.200
    22.750     4.793     0.200
    22.887     2.636     0.200
    23.078     3.644     0.200
    23.147     2.103     0.200
    23.283     3.536     0.200
    23.398     3.887     0.200
    23.627     0.882     0.200
    23.684     3.994     0.200
    23.971     0.882     0.200
    24.014     0.994     0.200
    24.080     3.231     0.200
    24.208     1.137     0.200
    24.269     2.673     0.200
    24.370     4.910     0.200
    24.562     4.826     0.200
    24.612     4.544     0.200
    24.789     1.757     0.200
    24.771     5.202     0.200
    24.957     2.067     0.200
    24.889     5.014     0.200
    24.914     5.120     0.200
    25.219     4.446     0.200
    25.234     4.628     0.200
    25.323     4.767     0.200
    25.400     5.375     0.200
    25.642     4.082     0.200
    25.619     5.730     0.200
    26.171     2.427     0.200
    26.196     2.304     0.200
    26.770     4.421     0.200
    26.770     5.194     0.200
    26.874     2.996     0.200
    26.889     2.673     0.200
    26.889     3.227     0.200
    27.056     3.056     0.200
    27.124     2.808     0.200
    27.129     3.545     0.200
    27.980     2.628     0.200
    28.549     2.850     0.200
    28.619     2.597     0.200
    29.024     4.006     0.200
    29.155     2.430     0.200
    29.152     4.053     0.200
    29.943     2.425     0.200
    30.004     2.319     0.200
    30.073     3.108     0.200
    30.597     1.840     0.200
    31.198     1.095     0.200
    31.410     1.373     0.200
    31.444     2.402     0.200
    31.869     2.719     0.200
    31.879     3.362     0.200
    31.879     2.800     0.200
    32.096     1.589     0.200
    32.468     1.453     0.200
    33.138     1.596     0.200
    34.164     2.673     0.200
    34.778     1.217     0.200
    37.767     1.342     0.200
    45.225     1.686     0.200
    45.678     3.606     0.200
    45.908     3.785     0.200
    45.908     3.348     0.200
    45.970     3.827     0.200
    46.310     4.328     0.200
    46.482     1.858     0.200
    46.911     2.485     0.200
    46.916     3.551     0.200
    47.952     3.486     0.200
    48.740     3.461     0.200
    48.913     3.648     0.200
    49.061     3.525     0.200
    49.189     3.601     0.200
    49.565     3.449     0.200
    49.961     3.905     0.200
    50.230     3.390     0.200
    50.478     3.021     0.200
    50.597     3.368     0.200
    50.622     3.673     0.200
    50.738     3.517     0.200
    50.835     3.526     0.200
    51.119     3.825     0.200
    51.154     3.658     0.200
    51.562     4.420     0.200
    51.685     4.342     0.200
    52.217     4.363     0.200
    52.428     3.895     0.200
    52.607     4.782     0.200
    52.703     4.392     0.200
    52.834     2.797     0.200
    52.996     3.998     0.200
    53.030     3.979     0.200
    53.030     3.792     0.200
    53.119     4.459     0.200
    53.325     3.297     0.200
    53.458     3.253     0.200
    53.766     2.951     0.200
    53.882     3.080     0.200
    53.930     3.684     0.200
    54.135     3.750     0.200
    54.294     3.504     0.200
    54.338     2.582     0.200
    54.326     4.002     0.200
    54.381     4.583     0.200
    54.579     2.717     0.200
    54.579     2.568     0.200
    54.845     2.389     0.200
    54.956     3.291     0.200
    54.978     3.122     0.200
    55.136     3.080     0.200
    55.145     2.815     0.200
    55.176     2.469     0.200
    55.218     2.420     0.200
    55.438     2.480     0.200
    55.438     3.207     0.200
    55.486     3.015     0.200
    55.597     3.640     0.200
    55.589     3.552     0.200
    55.619     3.157     0.200
    55.753     3.405     0.200
    55.781     3.117     0.200
    55.812     3.394     0.200
    55.958     3.781     0.200
    56.105     3.287     0.200
    56.130     3.535     0.200
    56.184     3.363     0.200
    56.329     3.200     0.200
    56.343     3.465     0.200
    56.346     4.152     0.200
    56.454     3.271     0.200
    56.481     2.677     0.200
    56.542     3.804     0.200
    56.557     4.095     0.200
    56.596     3.231     0.200
    56.601     2.672     0.200
    56.604     3.292     0.200
    56.810     3.496     0.200
    56.842     2.423     0.200
    56.934     3.161     0.200
    56.949     3.351     0.200
    57.054     3.100     0.200
    57.059     3.239     0.200
    57.058     3.575     0.200
    57.110     3.499     0.200
    57.186     3.251     0.200
    57.170     4.107     0.200
    57.273     3.232     0.200
    57.340     2.906     0.200
    57.474     2.952     0.200
    57.463     3.935     0.200
    57.481     2.197     0.200
    57.495     3.930     0.200
    57.519     3.441     0.200
    57.586     3.635     0.200
    57.810     4.430     0.200
    57.909     3.680     0.200
    57.967     4.074     0.200
    58.001     3.930     0.200
    58.111     3.490     0.200
    58.156     3.002     0.200
    58.203     3.723     0.200
    58.206     3.748     0.200
    58.273     3.013     0.200
    58.289     2.652     0.200
    58.306     2.786     0.200
    58.311     2.503     0.200
    58.401     2.810     0.200
    58.618     2.213     0.200
    58.620     2.600     0.200
    58.649     2.841     0.200
    58.705     2.559     0.200
    58.708     2.333     0.200
    58.727     2.182     0.200
    58.897     2.633     0.200
    58.936     1.953     0.200
    58.970     1.674     0.200
    58.989     1.669     0.200
    59.020     2.551     0.200
    59.134     3.143     0.200
    59.173     1.905     0.200
    59.177     1.804     0.200
    59.183     2.378     0.200
    59.305     2.687     0.200
    59.302     2.556     0.200
    59.318     2.737     0.200
    59.439     2.655     0.200
    59.469     2.678     0.200
    59.498     2.238     0.200
    59.547     2.612     0.200
    59.559     2.677     0.200
    59.570     2.164     0.200
    59.711     1.574     0.200
    59.828     1.880     0.200
    59.857     2.187     0.200
    59.861     2.493     0.200
    59.956     2.421     0.200
    60.072     2.581     0.200
    60.115     2.440     0.200
    60.159     2.213     0.200
    60.311     1.824     0.200
    60.362     2.226     0.200
    60.374     2.401     0.200
    60.426     2.187     0.200
    60.520     3.176     0.200
    60.630     2.326     0.200
    60.681     2.876     0.200
    60.689     3.034     0.200
    60.707     2.782     0.200
    61.019     2.404     0.200
    61.069     3.543     0.200
    61.211     2.688     0.200
    61.275     3.207     0.200
    61.388     3.246     0.200
    61.508     2.836     0.200
    61.887     2.885     0.200
    61.988     3.511     0.200
    62.003     3.547     0.200
    62.009     3.486     0.200
    62.034     2.357     0.200
    62.068     2.623     0.200
    62.091     2.554     0.200
    62.120     3.315     0.200
    62.154     1.725     0.200
    62.151     3.594     0.200
    62.171     2.901     0.200
    62.243     3.107     0.200
    62.317     3.389     0.200
    62.406     2.381     0.200
    62.638     2.497     0.200
    62.636     2.557     0.200
    62.702     3.088     0.200
    62.817     2.291     0.200
    62.928     2.623     0.200
    63.136     2.673     0.200
    63.183     2.398     0.200
    63.549     2.278     0.200
    63.549     2.276     0.200
    63.612     3.510     0.200
    63.688     2.837     0.200
    63.837     2.828     0.200
    63.923     2.761     0.200
    63.990     3.947     0.200
    64.272     2.695     0.200
    64.274     1.861     0.200
    64.280     3.024     0.200
    64.380     1.818     0.200
    64.443     2.012     0.200
    64.552     2.208     0.200
    64.801     2.369     0.200
    64.894     2.020     0.200
    65.257     2.225     0.200
    65.250     2.689     0.200
    65.561     1.344     0.200
    66.833     1.329     0.200
    83.834     3.581     0.200
    14.541     5.533     0.200
    15.356     3.785     0.200
    17.119     4.716     0.200
    18.054     3.149     0.200
    18.054     3.852     0.200
    18.281     0.755     0.200
    18.281     1.146     0.200
    18.505     0.665     0.200
    18.707     0.815     0.200
    18.707     1.120     0.200
    18.752    -0.228     0.200
    18.916     0.115     0.200
    19.023     0.123     0.200
    19.331     1.169     0.200
    19.483    -0.228     0.200
    19.880     0.206     0.200
    19.989     2.427     0.200
    20.711    -0.336     0.200
    20.776     0.260     0.200
    20.987     2.691     0.200
    21.415     3.414     0.200
    21.635     1.030     0.200
    21.785    -0.146     0.200
    21.785     1.096     0.200
    21.959     1.198     0.200
    21.982     0.425     0.200
    21.982     0.605     0.200
    22.165     3.948     0.200
    22.227    -0.231     0.200
    22.227     0.238     0.200
    22.438    -0.902     0.200
    22.494     2.008     0.200
    22.592     1.543     0.200
    22.911     0.246     0.200
    23.154     2.095     0.200
    23.275     0.314     0.200
    23.833     1.644     0.200
    23.857     2.294     0.200
    23.887     2.860     0.200
    24.195     1.677     0.200
    24.210     1.097     0.200
    25.005     1.438     0.200
    25.282     0.725     0.200
    25.584     4.117     0.200
    26.242     1.102     0.200
    26.394     4.038     0.200
    26.659     2.530     0.200
    26.659     4.444     0.200
    26.698     0.249     0.200
    26.871     1.866     0.200
    26.871     3.499     0.200
    27.786     1.252     0.200
    27.922     2.647     0.200
    28.519     1.788     0.200
    29.885     3.800     0.200
    30.991     2.225     0.200
    31.293     0.321     0.200
    32.311     2.338     0.200
    33.230    -0.479     0.200
    33.230     0.263     0.200
    37.585     0.925     0.200
    37.585     1.518     0.200
    45.183     2.692     0.200
    45.420     1.590     0.200
    45.639     4.562     0.200
    45.648     2.893     0.200
    45.854     3.341     0.200
    45.900     2.932     0.200
    46.344     3.588     0.200
    46.381     3.547     0.200
    46.471     0.871     0.200
    46.500     1.580     0.200
    46.565     1.239     0.200
    46.701     3.191     0.200
    46.763     3.284     0.200
    46.865     3.000     0.200
    46.865     2.742     0.200
    47.253     0.793     0.200
    47.857     2.533     0.200
    47.881     2.889     0.200
    47.908     3.187     0.200
    48.040     3.375     0.200
    48.387     3.184     0.200
    48.882     3.458     0.200
    49.010     2.771     0.200
    49.144     2.884     0.200
    49.896     2.932     0.200
    50.181     3.575     0.200
    50.448     3.708     0.200
    50.537     3.733     0.200
    50.687     3.574     0.200
    50.798     3.613     0.200
    51.073     3.409     0.200
    51.115     3.402     0.200
    51.210     3.062     0.200
    51.236     2.441     0.200
    51.294     2.578     0.200
    51.329     1.826     0.200
    51.513     2.537     0.200
    51.631     3.484     0.200
    51.816     3.036     0.200
    51.998     3.749     0.200
    52.372     3.577     0.200
    52.656     3.758     0.200
    52.773     3.370     0.200
    52.942     3.220     0.200
    52.987     3.281     0.200
    53.287     3.294     0.200
    53.287     3.513     0.200
    53.413     3.426     0.200
    53.426     3.713     0.200
    53.459     1.457     0.200
    53.490     3.817     0.200
    53.678     3.645     0.200
    53.744     3.517     0.200
    53.828     4.057     0.200
    53.901     2.861     0.200
    54.048     2.575     0.200
    54.230     2.762     0.200
    54.243     3.317     0.200
    54.270     3.214     0.200
    54.310     3.919     0.200
    54.425     3.306     0.200
    54.561     3.075     0.200
    54.579     2.874     0.200
    54.727     2.511     0.200
    54.821     2.993     0.200
    54.890     3.444     0.200
    54.932     3.723     0.200
    55.047     3.421     0.200
    55.095     3.531     0.200
    55.124     2.359     0.200
    55.142     2.708     0.200
    55.190     2.908     0.200
    55.190     2.501     0.200
    55.326     3.309     0.200
    55.428     3.068     0.200
    55.428     2.810     0.200
    55.469     2.451     0.200
    55.532     2.971     0.200
    55.560     3.620     0.200
    55.569     2.903     0.200
    55.573     2.823     0.200
    55.641     3.327     0.200
    55.674     2.872     0.200
    55.735     3.446     0.200
    55.739     4.002     0.200
    55.739     2.619     0.200
    55.774     3.222     0.200
    55.888     3.276     0.200
    56.037     2.904     0.200
    56.036     3.329     0.200
    56.088     2.780     0.200
    56.116     3.862     0.200
    56.117     3.329     0.200
    56.151     2.859     0.200
    56.198     3.650     0.200
    56.245     3.313     0.200
    56.269     2.834     0.200
    56.317     3.410     0.200
    56.362     3.374     0.200
    56.432     3.150     0.200
    56.451     3.233     0.200
    56.565     2.838     0.200
    56.580     2.928     0.200
    56.584     2.782     0.200
    56.647     3.383     0.200
    56.861     2.165     0.200
    56.875     3.732     0.200
    56.882     3.794     0.200
    56.947     3.490     0.200
    56.959     3.301     0.200
    57.010     2.902     0.200
    57.030     1.475     0.200
    57.060     2.203     0.200
    57.060     3.508     0.200
    57.086     3.551     0.200
    57.088     2.681     0.200
    57.125     3.779     0.200
    57.167     3.009     0.200
    57.260     3.196     0.200
    57.307     3.073     0.200
    57.386     3.171     0.200
    57.447     2.803     0.200
    57.449     3.254     0.200
    57.467     2.757     0.200
    57.546     3.424     0.200
    57.636     2.467     0.200
    57.642     3.573     0.200
    57.664     1.621     0.200
    57.756     2.938     0.200
    57.878     3.398     0.200
    57.926     3.055     0.200
    57.929     3.431     0.200
    57.983     1.975     0.200
    57.997     2.550     0.200
    58.020     2.559     0.200
    58.082     3.040     0.200
    58.139     3.120     0.200
    58.152     2.810     0.200
    58.185     2.772     0.200
    58.228     2.507     0.200
    58.230     2.739     0.200
    58.273     2.262     0.200
    58.336     2.761     0.200
    58.340     3.491     0.200
    58.340     2.983     0.200
    58.526     3.250     0.200
    58.565     2.931     0.200
    58.570     3.468     0.200
    58.595     2.489     0.200
    58.632     3.155     0.200
    58.655     3.017     0.200
    58.815     3.870     0.200
    58.813     3.444     0.200
    58.934     3.240     0.200
    58.945     3.317     0.200
    58.969     3.417     0.200
    59.093     3.508     0.200
    59.110     2.766     0.200
    59.128     3.721     0.200
    59.189     2.676     0.200
    59.199     2.416     0.200
    59.222     2.575     0.200
    59.255     2.676     0.200
    59.434     3.053     0.200
    59.442     4.125     0.200
    59.458     3.845     0.200
    59.478     3.562     0.200
    59.497     2.620     0.200
    59.522     2.330     0.200
    59.529     2.404     0.200
    59.658     2.346     0.200
    59.751     2.235     0.200
    59.779     3.775     0.200
    59.781     2.149     0.200
    59.896     3.995     0.200
    60.070     3.818     0.200
    60.167     3.595     0.200
    60.241     3.219     0.200
    60.312     3.004     0.200
    60.331     3.906     0.200
    60.340     3.691     0.200
    60.353     3.522     0.200
    60.402     3.840     0.200
    60.423     2.923     0.200
    60.524     3.065     0.200
    60.597     3.146     0.200
    60.631     3.362     0.200
    60.636     3.673     0.200
    60.636     3.462     0.200
    60.653     4.936     0.200
    60.802     2.941     0.200
    60.897     3.144     0.200
    61.039     2.526     0.200
    61.041     3.008     0.200
    61.176     2.023     0.200
    61.203     2.885     0.200
    61.339     3.106     0.200
    61.376     3.284     0.200
    61.453     2.902     0.200
    61.453     2.457     0.200
    61.552     3.216     0.200
    61.654     3.091     0.200
    61.703     2.831     0.200
    61.813     3.117     0.200
    61.907     3.496     0.200
    61.945     2.690     0.200
    61.973     3.155     0.200
    61.983     2.662     0.200
    61.992     1.005     0.200
    62.026     2.732     0.200
    62.043     2.980     0.200
    62.049     2.420     0.200
    62.086     3.296     0.200
    62.126     3.373     0.200
    62.138     2.004     0.200
    62.156     3.076     0.200
    62.224     3.334     0.200
    62.365     2.833     0.200
    62.570     3.043     0.200
    62.574     1.916     0.200
    62.583     2.559     0.200
    62.774     2.843     0.200
    62.902     2.353     0.200
    62.928     2.964     0.200
    62.937     3.372     0.200
    63.102     2.185     0.200
    63.211     3.401     0.200
    63.221     3.057     0.200
    63.230     3.103     0.200
    63.292     2.465     0.200
    63.509     1.691     0.200
    63.593     2.115     0.200
    63.706     2.128     0.200
    63.770     3.181     0.200
    63.853     3.499     0.200
    63.879     2.839     0.200
    64.203     3.090     0.200
    64.216     3.505     0.200
    64.220     3.400     0.200
    64.339     2.251     0.200
    64.407     2.450     0.200
    64.505     2.507     0.200
    64.683     3.134     0.200
    64.828     2.261     0.200
    64.989     2.023     0.200
    65.135     2.234     0.200
    65.208     2.926     0.200
    65.402     2.589     0.200
    65.402     3.097     0.200
    65.402     3.597     0.200
    65.494     2.729     0.200
    66.754     2.684     0.200
    78.546     4.095     0.200
    83.710     3.466     0.200
    14.142     7.288     0.200
    15.127     5.549     0.200
    15.791     6.797     0.200
    15.791     8.486     0.200
    17.917     1.549     0.200
    18.557     0.567     0.200
    19.060     3.744     0.200
    19.926     2.025     0.200
    21.345     3.611     0.200
    21.768     2.984     0.200
    21.768     3.164     0.200
    21.963     0.789     0.200
    22.018     0.592     0.200
    22.018     0.101     0.200
    22.154     0.878     0.200
    22.451     1.784     0.200
    23.416     0.838     0.200
    23.446     2.005     0.200
    23.501     2.462     0.200
    24.031     2.746     0.200
    24.396     1.843     0.200
    24.445    -0.437     0.200
    24.445     1.214     0.200
    24.461     1.529     0.200
    25.937     4.044     0.200
    26.747     3.695     0.200
    27.005     4.502     0.200
    27.013     1.684     0.200
    27.202     4.102     0.200
    27.202     4.333     0.200
    27.222     2.761     0.200
    27.222     3.052     0.200
    29.454     3.963     0.200
    30.236     4.141     0.200
    30.405     1.547     0.200
    30.405     2.408     0.200
    31.608     1.345     0.200
    32.520     2.353     0.200
    32.551     3.042     0.200
    33.546     1.147     0.200
    34.473     2.590     0.200
    37.918     1.384     0.200
    42.139     1.853     0.200
    45.314     4.704     0.200
    45.536     3.791     0.200
    45.656     1.097     0.200
    46.001     2.789     0.200
    46.207     3.747     0.200
    46.252     3.327     0.200
    46.600     2.963     0.200
    46.696     2.855     0.200
    46.717     3.353     0.200
    46.732     3.262     0.200
    46.816     2.026     0.200
    46.845     1.695     0.200
    46.910     2.005     0.200
    47.218     3.606     0.200
    47.218     2.799     0.200
    47.440     5.867     0.200
    47.375     2.375     0.200
    47.575     1.824     0.200
    48.104     3.770     0.200
    48.104     3.663     0.200
    48.210     3.729     0.200
    48.234     3.388     0.200
    48.261     3.680     0.200
    48.394     3.577     0.200
    49.065     4.426     0.200
    49.201     3.778     0.200
    49.232     3.897     0.200
    49.364     3.330     0.200
    49.497     3.201     0.200
    49.863     3.556     0.200
    50.250     3.662     0.200
    50.273     4.085     0.200
    50.535     3.816     0.200
    50.801     4.276     0.200
    50.890     3.922     0.200
    50.919     4.190     0.200
    51.041     3.522     0.200
    51.152     3.716     0.200
    51.426     3.366     0.200
    51.468     2.690     0.200
    51.563     3.402     0.200
    51.590     3.175     0.200
    51.647     3.869     0.200
    51.866     4.069     0.200
    51.984     4.079     0.200
    52.169     3.397     0.200
    52.351     4.146     0.200
    52.528     3.584     0.200
    52.564     4.277     0.200
    52.726     4.067     0.200
    52.894     3.417     0.200
    52.947     4.574     0.200
    53.009     3.926     0.200
    53.126     3.614     0.200
    53.295     3.822     0.200
    53.341     4.136     0.200
    53.640     3.662     0.200
    53.690     3.384     0.200
    53.765     3.408     0.200
    53.779     3.303     0.200
    54.031     3.936     0.200
    54.096     3.324     0.200
    54.181     3.575     0.200
    54.253     3.171     0.200
    54.328     3.236     0.200
    54.401     3.188     0.200
    54.422     3.832     0.200
    54.584     2.830     0.200
    54.597     3.555     0.200
    54.624     3.456     0.200
    54.662     3.837     0.200
    54.778     3.940     0.200
    54.913     2.916     0.200
    54.931     2.595     0.200
    55.079     3.158     0.200
    55.126     3.552     0.200
    55.170     2.279     0.200
    55.173     2.476     0.200
    55.243     3.019     0.200
    55.285     3.188     0.200
    55.400     3.639     0.200
    55.448     3.743     0.200
    55.476     2.735     0.200
    55.495     3.092     0.200
    55.542     3.482     0.200
    55.679     3.786     0.200
    55.778     2.728     0.200
    55.778     2.453     0.200
    55.821     2.990     0.200
    55.885     2.634     0.200
    55.912     4.031     0.200
    55.923     3.078     0.200
    55.925     3.032     0.200
    56.026     3.691     0.200
    56.089     3.808     0.200
    56.092     3.309     0.200
    56.128     3.012     0.200
    56.442     3.120     0.200
    56.465     4.097     0.200
    56.470     3.392     0.200
    56.504     2.914     0.200
    56.551     3.753     0.200
    56.593     3.651     0.200
    56.611     3.110     0.200
    56.621     3.488     0.200
    56.670     3.458     0.200
    56.786     3.272     0.200
    56.798     3.930     0.200
    56.808     2.892     0.200
    56.918     3.049     0.200
    56.932     3.096     0.200
    56.935     2.926     0.200
    57.000     3.109     0.200
    57.102     3.234     0.200
    57.206     2.399     0.200
    57.227     3.004     0.200
    57.235     3.050     0.200
    57.292     3.678     0.200
    57.307     3.410     0.200
    57.363     3.258     0.200
    57.414     2.245     0.200
    57.414     2.755     0.200
    57.437     3.154     0.200
    57.437     3.018     0.200
    57.477     3.214     0.200
    57.519     2.278     0.200
    57.537     2.911     0.200
    57.613     2.837     0.200
    57.659     2.732     0.200
    57.738     2.311     0.200
    57.737     2.430     0.200
    57.799     3.211     0.200
    57.802     2.515     0.200
    57.815     2.371     0.200
    57.899     2.667     0.200
    57.985     3.124     0.200
    57.995     2.497     0.200
    58.110     2.584     0.200
    58.200     2.395     0.200
    58.231     2.521     0.200
    58.274     2.818     0.200
    58.290     3.058     0.200
    58.282     2.798     0.200
    58.334     2.716     0.200
    58.350     2.900     0.200
    58.370     2.682     0.200
    58.434     2.860     0.200
    58.491     2.617     0.200
    58.505     2.817     0.200
    58.535     2.891     0.200
    58.580     2.311     0.200
    58.583     2.253     0.200
    58.625     2.921     0.200
    58.689     2.378     0.200
    58.694     3.786     0.200
    58.799     3.376     0.200
    58.876     3.179     0.200
    58.931     3.078     0.200
    58.918     2.280     0.200
    58.923     2.480     0.200
    58.949     2.352     0.200
    58.984     2.913     0.200
    58.996     2.109     0.200
    59.008     2.388     0.200
    59.158     2.766     0.200
    59.164     3.167     0.200
    59.287     2.178     0.200
    59.297     3.414     0.200
    59.321     2.473     0.200
    59.393     2.777     0.200
    59.483     2.668     0.200
    59.445     2.743     0.200
    59.463     2.368     0.200
    59.553     2.529     0.200
    59.572     2.675     0.200
    59.609     2.974     0.200
    59.703     3.135     0.200
    59.785     3.317     0.200
    59.787     2.766     0.200
    59.808     3.573     0.200
    59.830     2.856     0.200
    59.850     2.787     0.200
    59.874     3.006     0.200
    59.882     3.057     0.200
    60.011     2.545     0.200
    60.103     2.875     0.200
    60.131     3.090     0.200
    60.134     2.617     0.200
    60.166     2.483     0.200
    60.250     3.477     0.200
    60.378     3.565     0.200
    60.378     2.594     0.200
    60.359     2.488     0.200
    60.421     2.956     0.200
    60.435     2.771     0.200
    60.491     3.069     0.200
    60.516     3.580     0.200
    60.594     2.793     0.200
    60.666     2.357     0.200
    60.691     3.197     0.200
    60.685     2.732     0.200
    60.707     2.679     0.200
    60.746     4.093     0.200
    60.775     3.047     0.200
    60.773     2.433     0.200
    60.878     2.652     0.200
    60.947     3.285     0.200
    60.950     2.809     0.200
    60.983     2.728     0.200
    60.989     3.173     0.200
    61.153     2.721     0.200
    61.165     2.484     0.200
    61.246     3.039     0.200
    61.390     3.170     0.200
    61.393     2.590     0.200
    61.529     3.225     0.200
    61.529     3.100     0.200
    61.555     2.479     0.200
    61.692     2.894     0.200
    61.806     2.965     0.200
    61.905     2.370     0.200
    62.004     2.873     0.200
    62.054     2.977     0.200
    62.165     2.547     0.200
    62.259     3.451     0.200
    62.298     3.625     0.200
    62.326     3.344     0.200
    62.336     2.738     0.200
    62.379     2.954     0.200
    62.397     2.905     0.200
    62.401     3.253     0.200
    62.439     3.251     0.200
    62.491     2.611     0.200
    62.507     3.429     0.200
    62.574     3.544     0.200
    62.719     2.884     0.200
    62.910     4.058     0.200
    62.927     2.351     0.200
    62.936     2.133     0.200
    63.127     2.749     0.200
    63.289     2.954     0.200
    63.455     2.379     0.200
    63.480     2.664     0.200
    63.564     2.757     0.200
    63.571     3.138     0.200
    63.583     2.451     0.200
    63.862     2.177     0.200
    63.943     2.839     0.200
    63.968     1.600     0.200
    64.122     2.860     0.200
    64.191     4.173     0.200
    64.232     2.565     0.200
    64.556     2.860     0.200
    64.569     2.287     0.200
    64.574     2.447     0.200
    64.692     2.648     0.200
    64.760     1.898     0.200
    64.858     1.789     0.200
    65.027     2.801     0.200
    65.181     2.023     0.200
    65.288     1.706     0.200
    65.480     3.241     0.200
    65.561     1.396     0.200
    65.678     3.115     0.200
    65.678     2.545     0.200
    65.847     1.956     0.200
    66.570     1.370     0.200
    67.106     1.445     0.200
    71.758     1.393     0.200
    71.758     0.652     0.200
    78.844     2.210     0.200
    80.089     1.704     0.200
    83.841     2.493     0.200
    83.841     1.899     0.200
    84.052     2.807     0.200
    84.052     3.423     0.200
    86.682     3.070     0.200
    14.302     6.796     0.200
    15.226     8.408     0.200
    15.234     5.149     0.200
    15.512     5.273     0.200
    15.751     5.978     0.200
    15.836     5.890     0.200
    15.871     5.675     0.200
    16.122     2.427     0.200
    18.169     1.740     0.200
    18.436     0.801     0.200
    18.550     2.223     0.200
    18.634     3.068     0.200
    18.610     0.461     0.200
    18.696     2.678     0.200
    18.683     0.682     0.200
    18.683     1.525     0.200
    18.782     3.483     0.200
    18.803     0.927     0.200
    18.892     3.582     0.200
    18.892     4.449     0.200
    18.908     3.368     0.200
    18.900     1.845     0.200
    19.076     1.160     0.200
    19.288     1.189     0.200
    19.382    -0.138     0.200
    19.412     0.040     0.200
    19.423     1.387     0.200
    19.467     2.639     0.200
    19.467     2.053     0.200
    19.467     2.749     0.200
    19.467     3.256     0.200
    19.467     3.475     0.200
    19.461    -0.329     0.200
    19.488     0.267     0.200
    19.540     0.875     0.200
    19.580     1.051     0.200
    19.701     3.523     0.200
    19.726     1.404     0.200
    19.726     1.499     0.200
    19.788     3.949     0.200
    19.817     1.384     0.200
    19.849     0.918     0.200
    19.906     1.858     0.200
    19.945     1.847     0.200
    19.948     1.018     0.200
    19.959     0.962     0.200
    20.000     0.686     0.200
    20.044    -0.222     0.200
    20.058     1.335     0.200
    20.098     1.851     0.200
    20.264     0.908     0.200
    20.265     0.948     0.200
    20.353     3.757     0.200
    20.329     0.566     0.200
    20.334     1.527     0.200
    20.483     1.146     0.200
    20.611     2.175     0.200
    20.685     0.903     0.200
    20.679     0.853     0.200
    20.773     4.102     0.200
    20.786     1.089     0.200
    20.844     2.856     0.200
    20.798     1.169     0.200
    20.800     2.018     0.200
    20.924     3.940     0.200
    20.956     0.729     0.200
    20.974     1.491     0.200
    21.058     3.953     0.200
    21.315     3.334     0.200
    21.486     1.186     0.200
    21.625     3.520     0.200
    21.598     1.458     0.200
    21.662     3.420     0.200
    21.666     0.413     0.200
    21.712     0.098     0.200
    21.743     0.805     0.200
    21.806     3.553     0.200
    21.819     0.671     0.200
    21.846     1.343     0.200
    21.868     2.051     0.200
    21.861    -0.313     0.200
    21.996     2.206     0.200
    21.973     1.064     0.200
    22.040     2.593     0.200
    22.041    -0.609     0.200
    22.041     0.985     0.200
    22.049     1.313     0.200
    22.059     0.350     0.200
    22.125     1.189     0.200
    22.142     0.793     0.200
    22.151     2.012     0.200
    22.188     2.649     0.200
    22.188     3.251     0.200
    22.284     3.108     0.200
    22.236     1.698     0.200
    22.392     1.031     0.200
    22.459     3.279     0.200
    22.415     1.061     0.200
    22.512     3.226     0.200
    22.530     2.750     0.200
    22.565     1.009     0.200
    22.644     2.796     0.200
    22.606     0.420     0.200
    22.606     1.045     0.200
    22.618     1.509     0.200
    22.672     3.047     0.200
    22.638     0.691     0.200
    22.655     0.954     0.200
    22.766     2.994     0.200
    22.806     3.106     0.200
    22.775     0.497     0.200
    22.911     4.311     0.200
    22.942     4.334     0.200
    22.886     0.487     0.200
    22.918     1.040     0.200
    23.002     3.235     0.200
    23.023     3.167     0.200
    23.027     3.486     0.200
    23.027     4.103     0.200
    23.009     0.947     0.200
    23.056     2.748     0.200
    23.100     3.801     0.200
    23.045     2.044     0.200
    23.075     1.268     0.200
    23.128     3.459     0.200
    23.157     3.047     0.200
    23.175     2.610     0.200
    23.253     2.913     0.200
    23.265     2.911     0.200
    23.253     0.966     0.200
    23.296     2.357     0.200
    23.302     2.223     0.200
    23.312     1.270     0.200
    23.347     2.646     0.200
    23.358     3.060     0.200
    23.371     2.225     0.200
    23.347     0.947     0.200
    23.417     3.491     0.200
    23.486     2.740     0.200
    23.491     2.317     0.200
    23.511     1.921     0.200
    23.574     2.348     0.200
    23.556     1.437     0.200
    23.578     0.930     0.200
    23.645     3.301     0.200
    23.628     3.489     0.200
    23.657     2.734     0.200
    23.700     3.584     0.200
    23.699     1.528     0.200
    23.796     0.386     0.200
    23.849     3.458     0.200
    23.866     4.034     0.200
    23.866     2.167     0.200
    23.887     2.929     0.200
    23.879     1.951     0.200
    23.885     1.593     0.200
    23.977     2.134     0.200
    24.022     1.310     0.200
    24.059     0.570     0.200
    24.077     1.868     0.200
    24.103     1.335     0.200
    24.183     3.817     0.200
    24.219     1.388     0.200
    24.297     3.425     0.200
    24.383     3.721     0.200
    24.355     1.326     0.200
    24.355     2.802     0.200
    24.419     4.446     0.200
    24.414     3.862     0.200
    24.415     3.627     0.200
    24.478     2.945     0.200
    24.469     2.002     0.200
    24.469     2.151     0.200
    24.550     4.327     0.200
    24.528     1.922     0.200
    24.587     3.160     0.200
    24.574     1.300     0.200
    24.649     3.210     0.200
    24.707     1.892     0.200
    24.721    -0.292     0.200
    24.766     2.110     0.200
    24.811     3.507     0.200
    24.893     4.426     0.200
    24.920     3.104     0.200
    24.960     4.132     0.200
    24.976     3.376     0.200
    24.986     3.268     0.200
    24.996     3.616     0.200
    25.020     4.298     0.200
    25.046     4.428     0.200
    24.996     1.355     0.200
    25.062     3.427     0.200
    25.098     2.441     0.200
    25.233     3.374     0.200
    25.189     2.070     0.200
    25.191     1.754     0.200
    25.200     1.355     0.200
    25.289     4.326     0.200
    25.246     2.300     0.200
    25.342     4.121     0.200
    25.322     1.700     0.200
    25.333     1.889     0.200
    25.401     3.881     0.200
    25.363     1.761     0.200
    25.502     1.840     0.200
    25.592     4.033     0.200
    25.639     3.945     0.200
    25.784     3.073     0.200
    25.851     1.316     0.200
    25.872     0.971     0.200
    25.949     4.970     0.200
    25.951     4.185     0.200
    25.944     3.265     0.200
    25.924     0.936     0.200
    26.007     3.296     0.200
    26.064     3.014     0.200
    26.035     1.555     0.200
    26.117     3.613     0.200
    26.124     4.520     0.200
    26.090     2.004     0.200
    26.238     3.995     0.200
    26.294     1.925     0.200
    26.423     3.458     0.200
    26.398     1.258     0.200
    26.415     2.195     0.200
    26.467     1.910     0.200
    26.553     4.470     0.200
    26.517     1.913     0.200
    26.626     1.451     0.200
    26.674     3.552     0.200
    26.683     3.690     0.200
    26.658     1.104     0.200
    26.751     1.610     0.200
    26.751     6.454     0.200
    26.724     1.774     0.200
    26.795     2.392     0.200
    26.874     1.777     0.200
    26.913     2.205     0.200
    26.935     1.808     0.200
    26.985     1.137     0.200
    27.082     4.045     0.200
    27.059     2.425     0.200
    27.172     3.010     0.200
    27.172     3.518     0.200
    27.241     1.757     0.200
    27.241     2.101     0.200
    27.356     2.868     0.200
    27.429     3.864     0.200
    27.385     0.505     0.200
    27.483     4.171     0.200
    27.506     3.863     0.200
    27.506     4.652     0.200
    27.466     0.966     0.200
    27.556     1.801     0.200
    27.620     2.981     0.200
    27.620     2.982     0.200
    27.620     2.435     0.200
    27.620     3.404     0.200
    27.603     1.375     0.200
    27.614     0.994     0.200
    27.683     3.922     0.200
    27.724     3.724     0.200
    27.768     3.727     0.200
    27.728     0.827     0.200
    27.743     1.910     0.200
    27.762     1.588     0.200
    27.830     2.929     0.200
    27.830     4.038     0.200
    27.876     1.096     0.200
    27.987     1.816     0.200
    28.599     3.331     0.200
    28.659     4.706     0.200
    28.615     1.399     0.200
    28.682     3.339     0.200
    28.693     3.300     0.200
    28.683     1.432     0.200
    28.849     3.059     0.200
    29.013     3.067     0.200
    29.000     1.752     0.200
    29.149     1.114     0.200
    29.356     3.169     0.200
    29.338     0.603     0.200
    29.359     1.383     0.200
    29.357     1.418     0.200
    29.614     3.537     0.200
    29.731     2.182     0.200
    29.750     2.655     0.200
    29.767     3.170     0.200
    29.825     2.693     0.200
    29.801     1.181     0.200
    29.845     2.921     0.200
    29.892     3.575     0.200
    29.995     3.318     0.200
    30.012     2.655     0.200
    30.054     3.984     0.200
    30.102     1.430     0.200
    30.304     2.515     0.200
    30.351     2.248     0.200
    30.473     3.677     0.200
    30.586     6.032     0.200
    30.653     2.201     0.200
    30.711     3.122     0.200
    30.711     3.333     0.200
    30.805     3.036     0.200
    30.875     3.413     0.200
    31.247     3.210     0.200
    31.263     2.889     0.200
    31.337     2.739     0.200
    31.761     1.395     0.200
    31.771     4.154     0.200
    31.785     2.768     0.200
    31.835     2.094     0.200
    31.835     1.109     0.200
    31.883     3.497     0.200
    31.884     2.028     0.200
    32.010     4.192     0.200
    32.068     3.659     0.200
    32.090     2.240     0.200
    32.102     3.278     0.200
    32.140     2.604     0.200
    32.247     2.614     0.200
    32.533     2.018     0.200
    32.604     2.566     0.200
    32.833     3.000     0.200
    32.992     2.854     0.200
    32.963     2.679     0.200
    33.122     1.951     0.200
    33.317     1.795     0.200
    33.373     1.506     0.200
    33.394     1.208     0.200
    33.435     3.743     0.200
    33.453     3.368     0.200
    33.511     2.063     0.200
    33.797     1.591     0.200
    33.777     1.791     0.200
    34.135     2.093     0.200
    34.326     3.621     0.200
    34.514     2.919     0.200
    34.902     3.142     0.200
    34.902     2.619     0.200
    34.919     2.775     0.200
    35.029     2.294     0.200
    35.409     3.194     0.200
    35.493     3.286     0.200
    35.561     1.849     0.200
    35.777     2.715     0.200
    36.125     3.187     0.200
    36.109     3.087     0.200
    36.562     2.791     0.200
    36.609     2.868     0.200
    37.235     3.653     0.200
    37.418     2.681     0.200
    38.207     2.171     0.200
    38.207     2.687     0.200
    38.576     2.445     0.200
    39.413     2.119     0.200
    44.770     4.116     0.200
    44.770     3.741     0.200
    44.902     2.685     0.200
    45.345     5.159     0.200
    45.345     4.237     0.200
    45.679     1.111     0.200
    45.992     3.850     0.200
    46.413     3.985     0.200
    46.648     4.113     0.200
    46.712     4.420     0.200
    47.152     4.167     0.200
    47.193     0.319     0.200
    47.386     2.716     0.200
    47.650     4.061     0.200
    47.826     1.744     0.200
    48.106     4.511     0.200
    48.449     3.825     0.200
    48.522     2.753     0.200
    48.522     4.089     0.200
    48.691     3.122     0.200
    48.691     3.517     0.200
    48.691     3.345     0.200
    49.474     3.806     0.200
    49.614     2.025     0.200
    49.614     3.361     0.200
    49.655     3.667     0.200
    49.801     3.696     0.200
    49.928     4.013     0.200
    50.305     4.394     0.200
    50.695     4.170     0.200
    50.699     4.201     0.200
    50.969     4.014     0.200
    51.213     3.239     0.200
    51.213     3.911     0.200
    51.338     4.410     0.200
    51.362     3.814     0.200
    51.478     3.895     0.200
    51.858     4.078     0.200
    51.892     3.604     0.200
    52.015     3.739     0.200
    52.030     3.805     0.200
    52.094     3.817     0.200
    52.302     4.109     0.200
    52.426     4.248     0.200
    52.621     3.703     0.200
    52.791     4.046     0.200
    52.956     3.605     0.200
    53.011     4.151     0.200
    53.169     3.785     0.200
    53.349     3.954     0.200
    53.442     3.868     0.200
    53.769     2.647     0.200
    53.769     4.163     0.200
    53.861     3.731     0.200
    54.063     3.338     0.200
    54.194     3.414     0.200
    54.481     3.681     0.200
    54.498     3.245     0.200
    54.623     3.528     0.200
    54.665     2.319     0.200
    54.665     3.733     0.200
    54.701     3.545     0.200
    54.827     3.339     0.200
    54.877     3.818     0.200
    55.034     3.608     0.200
    55.067     3.984     0.200
    55.123     3.841     0.200
    55.230     3.449     0.200
    55.309     2.234     0.200
    55.309     2.843     0.200
    55.346     1.877     0.200
    55.346     3.057     0.200
    55.545     3.290     0.200
    55.561     1.129     0.200
    55.561     2.394     0.200
    55.578     2.671     0.200
    55.698     3.576     0.200
    55.717     3.466     0.200
    55.874     1.933     0.200
    55.896     3.394     0.200
    55.913     3.178     0.200
    55.952     2.294     0.200
    55.952     3.029     0.200
    56.131     3.666     0.200
    56.164     2.028     0.200
    56.164     2.638     0.200
    56.164     2.763     0.200
    56.194     2.622     0.200
    56.216     2.854     0.200
    56.330     2.917     0.200
    56.330     3.285     0.200
    56.330     2.166     0.200
    56.330     2.776     0.200
    56.359     2.595     0.200
    56.359     3.595     0.200
    56.375     3.712     0.200
    56.449     3.333     0.200
    56.495     3.421     0.200
    56.521     2.513     0.200
    56.521     3.224     0.200
    56.531     3.150     0.200
    56.531     3.376     0.200
    56.548     3.401     0.200
    56.793     3.622     0.200
    56.847     3.334     0.200
    56.868     3.197     0.200
    56.861     3.880     0.200
    56.910     3.034     0.200
    56.920     3.041     0.200
    57.002     3.650     0.200
    57.118     3.177     0.200
    57.195     3.015     0.200
    57.220     2.999     0.200
    57.283     2.999     0.200
    57.331     2.676     0.200
    57.331     2.607     0.200
    57.337     3.340     0.200
    57.451     3.300     0.200
    57.552     3.269     0.200
    57.552     2.543     0.200
    57.674     3.123     0.200
    57.691     3.286     0.200
    57.792     3.430     0.200
    57.850     2.269     0.200
    57.850     2.566     0.200
    57.850     2.425     0.200
    57.862     2.830     0.200
    57.911     3.415     0.200
    57.920     3.685     0.200
    57.917     3.010     0.200
    57.934     2.155     0.200
    57.934     3.421     0.200
    58.014     3.203     0.200
    58.060     3.164     0.200
    58.076     3.252     0.200
    58.204     3.147     0.200
    58.206     2.975     0.200
    58.210     2.804     0.200
    58.234     2.874     0.200
    58.261     2.893     0.200
    58.324     3.393     0.200
    58.445     3.121     0.200
    58.471     3.014     0.200
    58.551     3.468     0.200
    58.615     3.321     0.200
    58.644     3.340     0.200
    58.705     3.267     0.200
    58.731     3.049     0.200
    58.763     3.375     0.200
    58.783     3.059     0.200
    58.781     3.099     0.200
    58.940     3.397     0.200
    58.852     2.987     0.200
    58.898     3.007     0.200
    58.943     3.453     0.200
    58.948     3.428     0.200
    59.014     3.202     0.200
    59.030     2.699     0.200
    59.052     3.197     0.200
    59.052     2.822     0.200
    59.042     3.348     0.200
    59.119     2.400     0.200
    59.119     3.259     0.200
    59.331     3.331     0.200
    59.360     2.653     0.200
    59.358     2.967     0.200
    59.390     3.011     0.200
    59.432     3.341     0.200
    59.450     3.120     0.200
    59.447     3.045     0.200
    59.469     2.759     0.200
    59.639     2.824     0.200
    59.668     2.827     0.200
    59.707     2.673     0.200
    59.720     2.364     0.200
    59.810     2.876     0.200
    59.762     2.657     0.200
    59.875     2.748     0.200
    59.915     2.566     0.200
    59.919     2.496     0.200
    59.923     2.540     0.200
    59.982     2.709     0.200
    60.037     3.221     0.200
    60.045     2.742     0.200
    60.180     3.059     0.200
    60.205     2.657     0.200
    60.230     2.588     0.200
    60.294     2.916     0.200
    60.292     2.642     0.200
    60.280     2.725     0.200
    60.301     2.467     0.200
    60.308     3.034     0.200
    60.451     2.863     0.200
    60.554     3.118     0.200
    60.570     3.563     0.200
    60.603     3.257     0.200
    60.596     3.048     0.200
    60.814     1.471     0.200
    60.814     2.361     0.200
    60.851     3.100     0.200
    60.900     2.948     0.200
    60.902     2.620     0.200
    61.003     2.996     0.200
    61.053     2.606     0.200
    61.101     2.838     0.200
    61.151     2.879     0.200
    61.167     3.268     0.200
    61.181     2.832     0.200
    61.253     3.590     0.200
    61.243     2.892     0.200
    61.300     2.437     0.200
    61.366     2.861     0.200
    61.430     3.187     0.200
    61.420     2.915     0.200
    61.449     3.207     0.200
    61.626     3.362     0.200
    61.735     2.770     0.200
    61.760     2.990     0.200
    61.803     3.062     0.200
    61.869     3.513     0.200
    61.948     2.908     0.200
    61.948     3.213     0.200
    62.017     2.502     0.200
    62.125     3.312     0.200
    62.127     2.937     0.200
    62.355     3.121     0.200
    62.485     3.054     0.200
    62.529     3.025     0.200
    62.629     3.302     0.200
    62.730     2.887     0.200
    62.744     2.982     0.200
    62.746     3.201     0.200
    62.775     2.838     0.200
    62.806     2.900     0.200
    62.831     3.035     0.200
    62.892     2.790     0.200
    62.907     2.848     0.200
    62.984     3.372     0.200
    63.057     3.867     0.200
    63.143     2.997     0.200
    63.759     3.662     0.200
    63.924     3.535     0.200
    64.017     3.116     0.200
    64.021     3.383     0.200
    64.287     2.981     0.200
    64.353     3.052     0.200
    65.016     3.485     0.200
    65.022     2.760     0.200
    65.180     3.171     0.200
    65.463     2.339     0.200
    65.636     3.674     0.200
    65.791     2.440     0.200
    65.791     2.315     0.200
    65.791     2.737     0.200
    65.984     3.296     0.200
    65.997     3.580     0.200
    66.303     3.106     0.200
    67.575     3.391     0.200
    67.830     6.306     0.200
    69.063     3.982     0.200
    69.741     1.520     0.200
    71.265     2.305     0.200
    71.899     0.126     0.200
    72.700     2.315     0.200
    83.625     2.323     0.200
    92.030     1.515     0.200
    15.312     7.480     0.200
    15.590     4.724     0.200
    15.577     5.914     0.200
    16.041     7.342     0.200
    18.236     4.068     0.200
    18.944     3.009     0.200
    18.944     3.728     0.200
    20.288     3.494     0.200
    20.957     2.602     0.200
    21.059     1.039     0.200
    21.186     1.386     0.200
    21.397     1.892     0.200
    21.511     7.664     0.200
    21.518     2.038     0.200
    21.518     3.570     0.200
    21.645     2.463     0.200
    21.645     3.635     0.200
    22.092     0.688     0.200
    22.092     0.336     0.200
    22.277     0.908     0.200
    22.311     4.239     0.200
    22.311     2.942     0.200
    22.644     2.172     0.200
    22.987     2.508     0.200
    23.050     3.131     0.200
    23.409     2.616     0.200
    23.685     3.685     0.200
    23.702     1.758     0.200
    23.714     0.788     0.200
    23.714     0.968     0.200
    23.865     4.951     0.200
    24.026     2.244     0.200
    24.497     3.294     0.200
    24.497     1.841     0.200
    24.518     1.594     0.200
    25.797     2.968     0.200
    25.797     4.507     0.200
    26.339     2.460     0.200
    26.620     2.638     0.200
    26.620     3.263     0.200
    26.705     1.086     0.200
    26.830     3.481     0.200
    26.912     5.700     0.200
    26.912     3.341     0.200
    27.111     1.991     0.200
    27.111     3.249     0.200
    27.111     2.428     0.200
    27.225     3.801     0.200
    27.225     2.981     0.200
    27.444     3.072     0.200
    27.444     4.134     0.200
    27.533     3.364     0.200
    27.871     3.684     0.200
    27.975     3.103     0.200
    29.319     3.914     0.200
    29.319     2.734     0.200
    29.713     3.644     0.200
    29.713     3.308     0.200
    30.077     4.221     0.200
    30.510     2.014     0.200
    31.496     2.319     0.200
    31.586     2.993     0.200
    32.413     2.835     0.200
    32.515     2.194     0.200
    32.956     0.704     0.200
    32.956     0.946     0.200
    33.174     0.998     0.200
    33.463     1.279     0.200
    33.522     1.288     0.200
    36.418     4.029     0.200
    37.797     1.865     0.200
    37.865     1.795     0.200
    37.865     2.295     0.200
    42.114     1.865     0.200
    45.524     4.736     0.200
    45.524     3.822     0.200
    45.727     1.610     0.200
    45.880     3.081     0.200
    46.069     3.304     0.200
    46.081     2.460     0.200
    46.081     4.577     0.200
    46.619     3.338     0.200
    46.731     1.370     0.200
    46.760     1.956     0.200
    46.760     1.855     0.200
    47.086     4.695     0.200
    47.428     2.003     0.200
    47.541     1.401     0.200
    47.980     4.047     0.200
    48.130     4.445     0.200
    48.259     4.399     0.200
    49.128     3.839     0.200
    49.365     3.707     0.200
    50.144     3.876     0.200
    50.401     3.972     0.200
    50.780     3.776     0.200
    50.905     3.684     0.200
    51.294     3.657     0.200
    51.340     3.905     0.200
    51.452     4.151     0.200
    51.731     3.674     0.200
    51.846     4.619     0.200
    52.025     4.563     0.200
    52.214     4.333     0.200
    52.398     3.945     0.200
    52.586     4.382     0.200
    52.765     4.169     0.200
    52.876     4.239     0.200
    52.984     3.791     0.200
    53.156     3.970     0.200
    53.210     3.753     0.200
    53.210     4.011     0.200
    53.513     4.096     0.200
    53.656     3.909     0.200
    53.707     4.099     0.200
    53.756     1.813     0.200
    53.888     3.378     0.200
    53.888     4.284     0.200
    53.980     3.492     0.200
    54.043     4.276     0.200
    54.133     2.963     0.200
    54.133     3.690     0.200
    54.273     3.048     0.200
    54.275     4.143     0.200
    54.448     3.582     0.200
    54.461     3.951     0.200
    54.608     2.524     0.200
    54.634     4.040     0.200
    54.801     3.029     0.200
    55.061     2.872     0.200
    55.156     3.890     0.200
    55.306     3.590     0.200
    55.370     3.555     0.200
    55.423     3.248     0.200
    55.535     3.981     0.200
    55.672     2.250     0.200
    55.672     2.555     0.200
    55.709     2.962     0.200
    55.744     3.443     0.200
    55.788     3.937     0.200
    55.808     2.751     0.200
    55.956     3.894     0.200
    55.955     3.551     0.200
    55.955     3.840     0.200
    56.001     3.431     0.200
    56.091     3.221     0.200
    56.242     3.744     0.200
    56.229     4.238     0.200
    56.298     3.813     0.200
    56.332     3.607     0.200
    56.380     3.424     0.200
    56.406     3.026     0.200
    56.461     3.117     0.200
    56.466     2.781     0.200
    56.469     3.225     0.200
    56.528     3.247     0.200
    56.651     3.376     0.200
    56.796     2.731     0.200
    56.815     2.907     0.200
    56.824     2.948     0.200
    56.855     3.014     0.200
    57.076     3.102     0.200
    57.076     3.453     0.200
    57.098     2.824     0.200
    57.122     2.024     0.200
    57.122     2.227     0.200
    57.232     3.276     0.200
    57.278     2.529     0.200
    57.278     2.998     0.200
    57.278     2.685     0.200
    57.327     1.612     0.200
    57.330     3.362     0.200
    57.406     2.488     0.200
    57.472     2.974     0.200
    57.472     3.107     0.200
    57.583     3.100     0.200
    57.649     2.614     0.200
    57.649     3.106     0.200
    57.665     2.229     0.200
    57.665     2.846     0.200
    57.685     3.064     0.200
    57.851     3.037     0.200
    57.851     3.412     0.200
    57.972     3.074     0.200
    58.098     3.437     0.200
    58.109     3.063     0.200
    58.106     3.216     0.200
    58.119     2.993     0.200
    58.207     2.702     0.200
    58.218     3.545     0.200
    58.282     2.638     0.200
    58.282     3.185     0.200
    58.344     3.096     0.200
    58.369     3.398     0.200
    58.422     2.976     0.200
    58.441     2.681     0.200
    58.502     3.170     0.200
    58.565     3.208     0.200
    58.797     3.244     0.200
    58.810     3.180     0.200
    59.005     2.854     0.200
    59.145     2.995     0.200
    59.207     3.097     0.200
    59.230     3.007     0.200
    59.289     2.458     0.200
    59.316     2.539     0.200
    59.343     2.712     0.200
    59.405     2.790     0.200
    59.421     2.877     0.200
    59.473     2.434     0.200
    59.604     3.262     0.200
    59.643     3.099     0.200
    59.662     3.005     0.200
    59.705     2.288     0.200
    59.716     2.913     0.200
    59.692     2.464     0.200
    59.753     3.045     0.200
    59.756     2.773     0.200
    59.874     2.428     0.200
    59.949     2.760     0.200
    60.008     3.410     0.200
    60.034     3.052     0.200
    60.213     2.482     0.200
    60.259     2.951     0.200
    60.312     3.181     0.200
    60.348     2.737     0.200
    60.370     2.635     0.200
    60.444     2.439     0.200
    60.531     2.990     0.200
    60.567     2.698     0.200
    60.619     2.669     0.200
    60.619     2.271     0.200
    60.619     3.060     0.200
    60.655     2.309     0.200
    60.827     3.713     0.200
    60.830     2.600     0.200
    60.996     2.577     0.200
    61.174     2.238     0.200
    61.404     3.133     0.200
    61.558     2.951     0.200
    61.667     2.685     0.200
    61.761     2.737     0.200
    61.841     2.722     0.200
    61.876     2.087     0.200
    61.876     1.400     0.200
    61.895     2.713     0.200
    62.012     3.057     0.200
    62.102     3.064     0.200
    62.157     3.259     0.200
    62.199     2.686     0.200
    62.201     2.887     0.200
    62.251     3.322     0.200
    62.263     2.580     0.200
    62.293     3.094     0.200
    62.346     2.571     0.200
    62.590     2.659     0.200
    62.783     3.027     0.200
    62.797     2.901     0.200
    62.997     2.436     0.200
    63.133     3.141     0.200
    63.133     3.328     0.200
    63.339     3.016     0.200
    63.412     3.059     0.200
    63.419     3.036     0.200
    63.447     2.934     0.200
    63.473     3.913     0.200
    63.733     2.830     0.200
    63.773     2.797     0.200
    63.854     3.405     0.200
    63.975     3.214     0.200
    64.100     2.327     0.200
    64.406     3.364     0.200
    64.424     3.580     0.200
    64.437     3.009     0.200
    64.725     2.600     0.200
    65.034     2.886     0.200
    65.290     1.372     0.200
    65.426     2.547     0.200
    65.708     2.855     0.200
    65.708     1.816     0.200
    65.708     3.253     0.200
    65.700     3.019     0.200
    65.698     2.983     0.200
    66.951     3.069     0.200
    75.849     2.303     0.200
    78.847     2.685     0.200
    80.197     1.871     0.200
    81.789     3.789     0.200
    83.867     3.086     0.200
    84.007     2.118     0.200
    85.293     1.858     0.200
    85.358     3.041     0.200
    85.359     3.000     0.200
    85.801     1.910     0.200
    85.801     1.597     0.200
    85.796     1.655     0.200
    91.102     1.931     0.200
    93.037     2.625     0.200
    93.037     2.782     0.200
    97.179     1.975     0.200
    15.522     3.843     0.200
    16.037     4.635     0.200
    18.184     3.789     0.200
    18.184     2.779     0.200
    18.184     2.920     0.200
    18.499     0.901     0.200
    18.497     1.040     0.200
    18.497     0.640     0.200
    18.876     2.696     0.200
    19.948     1.000     0.200
    21.453     7.630     0.200
    21.470     1.886     0.200
    21.470     2.706     0.200
    21.578     2.880     0.200
    21.837     1.451     0.200
    22.001     0.237     0.200
    22.001     0.827     0.200
    22.270     3.874     0.200
    22.321     1.038     0.200
    22.391     3.141     0.200
    22.443     0.418     0.200
    23.335     2.213     0.200
    23.625     2.526     0.200
    23.811     3.926     0.200
    24.407     2.196     0.200
    24.427     1.800     0.200
    24.433     1.100     0.200
    24.651     3.955     0.200
    25.488     2.116     0.200
    25.526     2.197     0.200
    25.694     2.892     0.200
    25.733     4.051     0.200
    25.736     3.803     0.200
    26.555     2.986     0.200
    26.781     3.280     0.200
    26.781     3.735     0.200
    26.905     2.085     0.200
    26.902     1.916     0.200
    26.930     4.364     0.200
    26.930     4.825     0.200
    27.041     2.611     0.200
    27.041     2.381     0.200
    27.114     3.309     0.200
    27.167     3.182     0.200
    27.466     2.505     0.200
    27.868     3.084     0.200
    27.868     2.680     0.200
    29.256     3.508     0.200
    29.693     2.629     0.200
    29.866     3.013     0.200
    31.500     1.372     0.200
    33.436     1.269     0.200
    37.783     1.380     0.200
    37.783     1.871     0.200
    42.029     1.896     0.200
    45.330     3.678     0.200
    45.556     4.771     0.200
    45.556     2.607     0.200
    45.636     1.636     0.200
    45.813     3.537     0.200
    46.007     3.886     0.200
    46.045     4.233     0.200
    46.117     3.927     0.200
    46.550     4.196     0.200
    46.656     1.328     0.200
    46.685     1.486     0.200
    46.685     1.902     0.200
    47.019     4.320     0.200
    47.022     4.874     0.200
    47.337     2.207     0.200
    47.457     1.568     0.200
    47.914     2.873     0.200
    47.914     3.763     0.200
    48.027     5.213     0.200
    48.066     4.863     0.200
    49.057     4.361     0.200
    49.302     4.272     0.200
    50.338     4.142     0.200
    50.843     4.244     0.200
    51.230     4.550     0.200
    51.275     4.000     0.200
    51.390     4.479     0.200
    51.445     4.578     0.200
    51.566     2.955     0.200
    51.668     4.568     0.200
    51.784     3.773     0.200
    52.151     4.729     0.200
    52.333     3.680     0.200
    52.333     4.549     0.200
    52.361     4.333     0.200
    52.443     4.338     0.200
    52.525     4.441     0.200
    52.756     4.648     0.200
    52.813     4.657     0.200
    53.146     4.531     0.200
    53.448     4.521     0.200
    53.485     4.314     0.200
    53.590     4.512     0.200
    53.645     4.413     0.200
    53.828     3.967     0.200
    53.912     4.041     0.200
    53.981     4.296     0.200
    54.066     3.931     0.200
    54.208     3.600     0.200
    54.216     4.419     0.200
    54.386     2.751     0.200
    54.398     3.715     0.200
    54.423     3.605     0.200
    54.533     2.162     0.200
    54.574     2.584     0.200
    54.732     2.881     0.200
    54.742     3.236     0.200
    54.926     3.252     0.200
    54.988     2.996     0.200
    54.991     2.525     0.200
    55.037     3.835     0.200
    55.191     3.152     0.200
    55.245     4.015     0.200
    55.304     3.681     0.200
    55.355     3.105     0.200
    55.475     3.705     0.200
    55.602     2.520     0.200
    55.602     2.393     0.200
    55.640     3.088     0.200
    55.683     3.580     0.200
    55.725     3.365     0.200
    55.740     3.321     0.200
    55.893     3.682     0.200
    55.893     3.822     0.200
    55.928     3.017     0.200
    55.936     3.331     0.200
    56.033     3.483     0.200
    56.115     3.593     0.200
    56.183     3.347     0.200
    56.270     3.339     0.200
    56.314     3.091     0.200
    56.346     3.461     0.200
    56.372     3.498     0.200
    56.403     3.694     0.200
    56.588     3.328     0.200
    56.729     2.967     0.200
    56.747     3.094     0.200
    56.754     2.953     0.200
    56.795     3.111     0.200
    56.894     2.777     0.200
    57.018     2.901     0.200
    57.036     2.527     0.200
    57.046     1.747     0.200
    57.168     2.975     0.200
    57.215     2.227     0.200
    57.337     2.600     0.200
    57.411     2.872     0.200
    57.526     2.892     0.200
    57.591     2.998     0.200
    57.602     2.969     0.200
    57.617     3.198     0.200
    57.617     2.943     0.200
    57.638     2.772     0.200
    57.791     3.281     0.200
    57.866     1.243     0.200
    57.910     2.969     0.200
    58.044     3.456     0.200
    58.042     3.054     0.200
    58.055     3.129     0.200
    58.153     3.038     0.200
    58.154     3.411     0.200
    58.224     2.985     0.200
    58.285     3.095     0.200
    58.306     3.186     0.200
    58.367     2.992     0.200
    58.380     3.085     0.200
    58.436     3.050     0.200
    58.500     3.398     0.200
    58.579     3.232     0.200
    58.730     2.927     0.200
    58.792     2.736     0.200
    58.950     3.098     0.200
    59.087     3.198     0.200
    59.138     2.794     0.200
    59.177     2.762     0.200
    59.233     2.521     0.200
    59.257     2.960     0.200
    59.281     3.058     0.200
    59.357     3.044     0.200
    59.488     2.978     0.200
    59.590     2.189     0.200
    59.596     3.143     0.200
    59.645     2.834     0.200
    59.635     5.048     0.200
    59.688     2.925     0.200
    59.689     2.903     0.200
    59.724     1.332     0.200
    59.811     2.933     0.200
    59.918     2.740     0.200
    59.942     2.911     0.200
    60.047     2.483     0.200
    60.154     2.023     0.200
    60.205     2.858     0.200
    60.246     2.902     0.200
    60.303     2.556     0.200
    60.386     2.292     0.200
    60.476     2.964     0.200
    60.505     2.327     0.200
    60.563     2.839     0.200
    60.587     2.887     0.200
    60.627     2.471     0.200
    60.761     3.233     0.200
    60.773     2.832     0.200
    60.793     3.590     0.200
    60.940     2.953     0.200
    61.112     2.464     0.200
    61.338     2.999     0.200
    61.347     2.593     0.200
    61.495     2.787     0.200
    61.605     2.908     0.200
    61.701     2.573     0.200
    61.788     2.725     0.200
    61.789     1.518     0.200
    61.789     1.829     0.200
    61.840     2.943     0.200
    61.955     2.814     0.200
    62.046     2.823     0.200
    62.096     3.131     0.200
    62.135     2.648     0.200
    62.137     2.553     0.200
    62.193     3.414     0.200
    62.200     2.548     0.200
    62.205     2.233     0.200
    62.234     2.910     0.200
    62.292     2.829     0.200
    62.356     2.949     0.200
    62.525     2.760     0.200
    62.723     3.127     0.200
    62.736     3.117     0.200
    62.932     3.097     0.200
    63.074     3.017     0.200
    63.077     2.922     0.200
    63.278     3.111     0.200
    63.357     2.583     0.200
    63.359     3.235     0.200
    63.385     3.102     0.200
    63.532     2.255     0.200
    63.712     2.497     0.200
    63.916     3.004     0.200
    64.036     2.399     0.200
    64.348     2.863     0.200
    64.348     3.201     0.200
    64.364     3.359     0.200
    64.375     2.631     0.200
    64.661     2.734     0.200
    64.975     3.327     0.200
    65.202     2.488     0.200
    65.618     2.882     0.200
    65.618     1.433     0.200
    65.618     2.173     0.200
    65.641     1.677     0.200
    65.641     3.095     0.200
    65.733     2.058     0.200
    72.417     1.094     0.200
    72.417     2.764     0.200
    75.790     2.837     0.200
    75.787     2.003     0.200
    75.787     3.343     0.200
    78.759     1.880     0.200
    80.108     1.887     0.200
    82.854     1.507     0.200
    83.822     2.769     0.200
    83.822     6.519     0.200
    83.822     4.369     0.200
    83.822     3.289     0.200
    83.926     3.401     0.200
    84.799     4.156     0.200
    84.937     3.673     0.200
    85.202     2.844     0.200
    85.202     3.094     0.200
    85.202     4.742     0.200
    85.724     1.753     0.200
    89.272     5.966     0.200
    92.988     3.913     0.200
    93.171     5.067     0.200
    95.145     4.304     0.200
    97.119     2.639     0.200
    15.110     4.893     0.200
    16.146     3.967     0.200
    16.604     3.182     0.200
    17.466     0.981     0.200
    17.634     5.015     0.200
    17.687     4.338     0.200
    18.103     1.568     0.200
    18.097     1.457     0.200
    18.269     1.852     0.200
    18.287     1.212     0.200
    18.336     1.721     0.200
    18.394     3.029     0.200
    18.394     3.130     0.200
    18.394     1.600     0.200
    18.394     4.520     0.200
    18.462     0.711     0.200
    18.395     2.134     0.200
    18.469     0.500     0.200
    18.464     1.660     0.200
    18.652     0.876     0.200
    18.748     1.066     0.200
    18.839     0.725     0.200
    18.897     0.775     0.200
    18.938     0.863     0.200
    18.764     4.347     0.200
    19.033     1.109     0.200
    19.127     0.477     0.200
    19.160     2.624     0.200
    19.231     0.605     0.200
    19.199     1.313     0.200
    19.199     1.962     0.200
    19.383     1.038     0.200
    19.413     1.513     0.200
    19.507     1.372     0.200
    19.536     3.340     0.200
    19.633     1.681     0.200
    19.597     2.348     0.200
    19.647     0.510     0.200
    19.691     3.348     0.200
    19.811     1.221     0.200
    19.761     1.869     0.200
    19.887     0.620     0.200
    19.956     1.573     0.200
    20.007     1.051     0.200
    20.107     1.694     0.200
    20.040     3.553     0.200
    20.094     1.971     0.200
    20.209     0.517     0.200
    20.276     2.256     0.200
    20.342     3.376     0.200
    20.605     3.126     0.200
    20.595     4.389     0.200
    20.638     3.476     0.200
    20.691     3.479     0.200
    20.700     2.500     0.200
    20.801     0.612     0.200
    20.927     0.890     0.200
    20.922    -0.268     0.200
    20.871     2.594     0.200
    21.003     2.231     0.200
    20.931     2.148     0.200
    21.098     0.966     0.200
    21.084     2.049     0.200
    21.084     3.909     0.200
    21.134     1.204     0.200
    21.148     2.514     0.200
    21.183     3.716     0.200
    21.302     1.263     0.200
    21.365     1.487     0.200
    21.376     1.054     0.200
    21.337     3.237     0.200
    21.429     3.168     0.200
    21.592     2.541     0.200
    21.751     1.041     0.200
    21.671     2.767     0.200
    21.694     4.235     0.200
    21.694     3.661     0.200
    21.694     4.851     0.200
    21.744     1.879     0.200
    21.759     3.365     0.200
    21.765     2.378     0.200
    21.906     0.306     0.200
    21.891     0.547     0.200
    21.891     1.107     0.200
    22.017     0.874     0.200
    21.996     1.290     0.200
    22.050     1.463     0.200
    22.091     1.709     0.200
    22.058     2.724     0.200
    22.066     2.202     0.200
    22.079     2.051     0.200
    22.188     2.103     0.200
    22.202     1.056     0.200
    22.155     2.856     0.200
    22.245     0.693     0.200
    22.245     1.533     0.200
    22.200     2.982     0.200
    22.203     2.330     0.200
    22.211     2.328     0.200
    22.284     0.528     0.200
    22.245     2.590     0.200
    22.268     2.219     0.200
    22.270     2.598     0.200
    22.300     2.699     0.200
    22.316     2.336     0.200
    22.323     2.133     0.200
    22.408     1.726     0.200
    22.385     2.205     0.200
    22.380     2.158     0.200
    22.398     2.859     0.200
    22.476     2.334     0.200
    22.474     2.526     0.200
    22.483     3.395     0.200
    22.570     1.606     0.200
    22.623     0.720     0.200
    22.557     2.834     0.200
    22.656     0.061     0.200
    22.634     3.632     0.200
    22.661     3.277     0.200
    22.973     1.774     0.200
    22.846     3.306     0.200
    22.888     2.940     0.200
    23.104     0.360     0.200
    23.084     2.747     0.200
    23.100     2.840     0.200
    23.176     2.153     0.200
    23.102     2.898     0.200
    23.120     2.692     0.200
    23.146     2.930     0.200
    23.164     2.752     0.200
    23.254     3.602     0.200
    23.369     0.800     0.200
    23.497     1.800     0.200
    23.457     2.243     0.200
    23.500     2.786     0.200
    23.590     1.534     0.200
    23.578     1.544     0.200
    23.633     1.390     0.200
    23.623     3.501     0.200
    23.626     3.165     0.200
    23.680     2.705     0.200
    23.696     2.561     0.200
    23.726     4.449     0.200
    23.809     3.694     0.200
    23.840     3.423     0.200
    23.882     1.284     0.200
    23.856     3.429     0.200
    23.899     3.691     0.200
    23.919     2.991     0.200
    24.157     0.755     0.200
    24.161     1.542     0.200
    24.143     1.854     0.200
    24.114     3.611     0.200
    24.200     3.648     0.200
    24.313     0.810     0.200
    24.313     0.310     0.200
    24.362     2.202     0.200
    24.362     0.912     0.200
    24.313     3.804     0.200
    24.512     3.401     0.200
    24.669     1.973     0.200
    24.642     2.133     0.200
    24.639     3.649     0.200
    24.795     3.821     0.200
    24.897     1.945     0.200
    24.830     3.691     0.200
    24.968     1.787     0.200
    25.089     2.252     0.200
    25.166     4.303     0.200
    25.278     3.014     0.200
    25.218     3.476     0.200
    25.218     4.916     0.200
    25.314     1.814     0.200
    25.288     3.056     0.200
    25.338     2.456     0.200
    25.335     2.683     0.200
    25.561     3.039     0.200
    25.818     4.124     0.200
    25.938     3.571     0.200
    26.044     2.746     0.200
    26.055     5.255     0.200
    26.051     4.179     0.200
    26.074     3.195     0.200
    26.077     2.786     0.200
    26.160     3.532     0.200
    26.193     2.574     0.200
    26.221     4.895     0.200
    26.218     3.592     0.200
    26.316     2.141     0.200
    26.340     1.309     0.200
    26.475     1.419     0.200
    26.502     1.038     0.200
    26.459     4.501     0.200
    26.587     0.652     0.200
    26.565     2.199     0.200
    26.565     2.870     0.200
    26.565     3.030     0.200
    26.565     3.169     0.200
    26.605     3.068     0.200
    26.635     3.653     0.200
    26.828     2.648     0.200
    26.937     4.371     0.200
    27.012     1.775     0.200
    27.325     2.769     0.200
    27.452     1.975     0.200
    27.389     2.961     0.200
    27.733     3.244     0.200
    27.761     3.807     0.200
    27.788     3.007     0.200
    28.032     3.233     0.200
    28.472     3.158     0.200
    28.744     4.673     0.200
    28.749     4.181     0.200
    29.130     3.892     0.200
    29.480     3.716     0.200
    29.480     4.986     0.200
    29.634     2.010     0.200
    29.786     3.728     0.200
    30.302     2.796     0.200
    30.443     4.232     0.200
    30.465     2.871     0.200
    30.539     1.758     0.200
    30.632     2.689     0.200
    30.755     4.115     0.200
    30.808     3.816     0.200
    30.895     2.614     0.200
    30.912     1.922     0.200
    30.938     1.914     0.200
    31.077     2.772     0.200
    31.179     1.282     0.200
    31.730     2.996     0.200
    31.753     2.833     0.200
    31.927     2.605     0.200
    32.081     4.176     0.200
    32.121     3.891     0.200
    32.205     4.109     0.200
    32.678     3.869     0.200
    32.866     2.154     0.200
    33.111     0.821     0.200
    33.097     3.176     0.200
    33.767     2.849     0.200
    34.219     3.644     0.200
    34.282     3.707     0.200
    34.619     3.267     0.200
    35.351     2.799     0.200
    36.877     2.590     0.200
    37.402     1.495     0.200
    37.402     1.855     0.200
    45.513     1.336     0.200
    46.143     4.696     0.200
    46.143     4.020     0.200
    46.220     1.911     0.200
    46.248     2.042     0.200
    46.314     1.722     0.200
    46.700     3.600     0.200
    46.700     5.630     0.200
    47.109     1.760     0.200
    47.173     1.803     0.200
    47.416     5.024     0.200
    47.660     4.075     0.200
    47.881     5.193     0.200
    48.256     4.393     0.200
    48.684     2.064     0.200
    48.590     3.782     0.200
    49.144     2.885     0.200
    52.640     3.652     0.200
    52.947     3.757     0.200
    53.369     2.616     0.200
    53.574     2.951     0.200
    54.247     3.478     0.200
    54.515     3.029     0.200
    55.131     2.387     0.200
    55.131     3.287     0.200
    55.161     3.132     0.200
    55.378     3.599     0.200
    56.702     3.378     0.200
    56.702     3.688     0.200
    57.512     1.877     0.200
    59.116     2.494     0.200
    59.466     2.816     0.200
    60.905     2.467     0.200
    60.916     2.624     0.200
    60.982     2.612     0.200
    60.982     2.902     0.200
    61.489     2.495     0.200
    61.489     2.255     0.200
    61.941     2.984     0.200
    61.941     2.464     0.200
    62.537     3.302     0.200
    62.833     3.004     0.200
    62.870     3.247     0.200
    63.164     3.630     0.200
    64.924     3.367     0.200
    65.401     3.637     0.200
    65.401     3.367     0.200
    65.401     2.937     0.200
    71.439     1.830     0.200
    71.439     2.090     0.200
    72.125     2.595     0.200
    72.125     2.735     0.200
    75.272     4.417     0.200
    75.269     3.973     0.200
    78.484     3.231     0.200
    80.073     2.282     0.200
    84.048     3.218     0.200
    85.030     0.732     0.200
    85.084     3.631     0.200
    85.084     3.957     0.200
    85.256     2.961     0.200
    85.256     3.281     0.200
    85.490     3.380     0.200
    15.610     4.025     0.200
    15.610     4.783     0.200
    15.799     3.258     0.200
    18.229     2.542     0.200
    19.732     1.626     0.200
    20.334     0.546     0.200
    20.643     2.545     0.200
    21.039     0.882     0.200
    21.181     0.090     0.200
    21.661     3.535     0.200
    22.187     0.434     0.200
    22.187     1.055     0.200
    22.385     0.980     0.200
    23.441     2.541     0.200
    24.599     0.587     0.200
    24.612     0.951     0.200
    24.612     1.463     0.200
    25.063     2.140     0.200
    25.805     4.488     0.200
    26.635     3.965     0.200
    26.817     4.871     0.200
    26.817     4.632     0.200
    27.054     1.984     0.200
    27.134     3.017     0.200
    27.134     2.490     0.200
    28.364     1.478     0.200
    30.074     4.313     0.200
    31.648     1.777     0.200
    33.583     0.589     0.200
    37.914     1.780     0.200
    37.914     2.182     0.200
    45.392     4.402     0.200
    45.821     1.669     0.200
    46.077     4.026     0.200
    46.105     4.786     0.200
    46.553     4.445     0.200
    46.640     3.714     0.200
    46.795     1.616     0.200
    46.795     0.640     0.200
    47.090     4.522     0.200
    47.097     4.697     0.200
    47.598     1.305     0.200
    47.995     4.014     0.200
    48.070     4.510     0.200
    48.142     4.135     0.200
    48.268     3.793     0.200
    48.965     3.914     0.200
    49.059     4.074     0.200
    49.154     2.881     0.200
    49.238     4.044     0.200
    49.377     4.063     0.200
    49.732     4.140     0.200
    50.116     4.218     0.200
    50.157     3.946     0.200
    50.411     4.057     0.200
    50.697     4.414     0.200
    50.754     4.150     0.200
    50.915     4.232     0.200
    51.305     4.086     0.200
    51.354     4.049     0.200
    51.461     4.656     0.200
    51.513     4.578     0.200
    51.741     4.353     0.200
    51.854     4.497     0.200
    52.030     4.552     0.200
    52.222     4.942     0.200
    52.380     4.498     0.200
    52.410     4.177     0.200
    52.594     4.603     0.200
    52.887     4.415     0.200
    53.164     4.038     0.200
    53.223     3.851     0.200
    53.528     3.755     0.200
    53.548     4.444     0.200
    53.673     3.645     0.200
    53.716     3.917     0.200
    53.822     1.049     0.200
    53.893     4.125     0.200
    54.000     3.318     0.200
    54.051     3.666     0.200
    54.151     3.405     0.200
    54.278     3.888     0.200
    54.458     2.895     0.200
    54.470     3.533     0.200
    54.491     3.460     0.200
    54.514     3.896     0.200
    54.638     3.697     0.200
    54.823     2.887     0.200
    54.924     3.768     0.200
    54.997     3.254     0.200
    55.075     2.955     0.200
    55.084     2.183     0.200
    55.100     3.569     0.200
    55.251     3.783     0.200
    55.311     3.842     0.200
    55.382     3.070     0.200
    55.385     2.933     0.200
    55.440     2.815     0.200
    55.440     3.186     0.200
    55.539     3.191     0.200
    55.697     2.291     0.200
    55.697     2.584     0.200
    55.731     2.656     0.200
    55.798     3.265     0.200
    55.828     2.609     0.200
    55.850     3.446     0.200
    55.964     3.453     0.200
    56.016     3.498     0.200
    56.093     3.415     0.200
    56.244     3.217     0.200
    56.289     3.819     0.200
    56.326     3.458     0.200
    56.341     3.308     0.200
    56.396     2.850     0.200
    56.411     3.504     0.200
    56.413     3.189     0.200
    56.469     3.390     0.200
    56.533     2.997     0.200
    56.644     3.520     0.200
    56.662     3.375     0.200
    56.813     2.973     0.200
    56.835     2.631     0.200
    56.846     2.872     0.200
    56.953     3.319     0.200
    57.107     3.349     0.200
    57.157     1.838     0.200
    57.244     3.048     0.200
    57.275     3.659     0.200
    57.288     2.837     0.200
    57.288     1.977     0.200
    57.332     3.121     0.200
    57.371     3.216     0.200
    57.427     2.451     0.200
    57.478     3.016     0.200
    57.551     2.759     0.200
    57.582     3.282     0.200
    57.595     3.004     0.200
    57.650     2.950     0.200
    57.675     2.498     0.200
    57.704     2.764     0.200
    57.731     2.365     0.200
    57.811     2.884     0.200
    57.856     2.993     0.200
    57.980     2.966     0.200
    58.126     2.888     0.200
    58.169     2.997     0.200
    58.200     2.906     0.200
    58.229     2.821     0.200
    58.244     2.488     0.200
    58.282     2.960     0.200
    58.346     3.067     0.200
    58.368     3.340     0.200
    58.378     3.333     0.200
    58.419     3.370     0.200
    58.518     2.893     0.200
    58.548     2.595     0.200
    58.578     2.692     0.200
    58.800     3.056     0.200
    58.814     2.780     0.200
    58.818     3.012     0.200
    58.830     2.845     0.200
    58.857     2.880     0.200
    58.956     3.053     0.200
    59.001     2.936     0.200
    59.144     2.648     0.200
    59.175     2.502     0.200
    59.227     2.414     0.200
    59.223     3.008     0.200
    59.287     2.757     0.200
    59.318     2.816     0.200
    59.350     2.850     0.200
    59.433     2.514     0.200
    59.483     2.950     0.200
    59.538     3.232     0.200
    59.586     3.173     0.200
    59.636     3.375     0.200
    59.678     2.618     0.200
    59.710     2.936     0.200
    59.736     2.028     0.200
    59.766     2.933     0.200
    59.775     2.463     0.200
    59.882     2.475     0.200
    59.948     3.077     0.200
    59.970     3.485     0.200
    60.023     2.768     0.200
    60.046     2.936     0.200
    60.113     2.310     0.200
    60.217     1.948     0.200
    60.217     2.436     0.200
    60.253     2.678     0.200
    60.328     2.492     0.200
    60.339     2.722     0.200
    60.387     2.194     0.200
    60.526     2.963     0.200
    60.538     5.492     0.200
    60.541     2.603     0.200
    60.567     3.031     0.200
    60.574     2.405     0.200
    60.618     2.810     0.200
    60.830     2.815     0.200
    60.843     2.621     0.200
    60.843     2.879     0.200
    60.868     1.508     0.200
    60.868     2.672     0.200
    60.993     2.782     0.200
    61.069     2.610     0.200
    61.221     2.757     0.200
    61.291     3.100     0.200
    61.291     2.725     0.200
    61.405     2.810     0.200
    61.466     3.096     0.200
    61.568     2.875     0.200
    61.615     2.563     0.200
    61.674     2.712     0.200
    61.766     3.082     0.200
    61.835     2.801     0.200
    62.012     3.094     0.200
    62.163     2.878     0.200
    62.208     2.676     0.200
    62.215     2.876     0.200
    62.253     2.753     0.200
    62.261     2.772     0.200
    62.273     3.021     0.200
    62.297     2.769     0.200
    62.341     2.907     0.200
    62.376     2.222     0.200
    62.383     2.294     0.200
    62.401     3.189     0.200
    62.603     2.987     0.200
    62.698     3.180     0.200
    62.788     2.828     0.200
    62.805     2.742     0.200
    63.009     2.418     0.200
    63.135     2.965     0.200
    63.347     2.215     0.200
    63.346     2.612     0.200
    63.407     3.150     0.200
    63.423     2.977     0.200
    63.456     2.433     0.200
    63.746     2.642     0.200
    63.776     3.027     0.200
    63.781     2.806     0.200
    63.977     2.715     0.200
    64.112     2.973     0.200
    64.407     3.181     0.200
    64.428     3.609     0.200
    64.446     2.879     0.200
    64.735     2.970     0.200
    65.037     2.174     0.200
    65.361     0.492     0.200
    65.435     1.809     0.200
    65.703     2.194     0.200
    65.789     2.242     0.200
    65.789     3.575     0.200
    66.949     1.815     0.200
    80.301     1.967     0.200
    83.847     4.170     0.200
    83.847     2.119     0.200
    84.122     2.138     0.200
    85.388     2.441     0.200
    85.881     1.883     0.200
    85.881     1.035     0.200
    14.636     6.544     0.200
    14.640     6.947     0.200
    14.929     5.290     0.200
    15.540     6.716     0.200
    15.608     5.852     0.200
    15.615     5.508     0.200
    15.762     5.668     0.200
    15.798     4.634     0.200
    15.798     5.314     0.200
    15.798     5.864     0.200
    15.843     5.704     0.200
    15.892     6.584     0.200
    15.939     4.931     0.200
    16.009     5.986     0.200
    16.027     7.069     0.200
    16.044     4.682     0.200
    16.070     4.675     0.200
    16.090     6.073     0.200
    16.103     6.487     0.200
    16.104     4.794     0.200
    16.105     4.475     0.200
    16.105     4.841     0.200
    16.120     4.566     0.200
    16.148     4.226     0.200
    16.149     4.817     0.200
    16.204     5.043     0.200
    16.219     5.705     0.200
    16.356     3.928     0.200
    16.356     5.051     0.200
    16.622     6.077     0.200
    16.642     4.121     0.200
    16.652     7.523     0.200
    16.652     4.005     0.200
    16.850     7.261     0.200
    16.847     4.661     0.200
    16.865     4.718     0.200
    16.921     7.299     0.200
    18.279     2.876     0.200
    18.484     2.449     0.200
    19.539     3.483     0.200
    19.539     3.143     0.200
    19.829     1.007     0.200
    19.829     1.627     0.200
    20.256     1.276     0.200
    20.327     0.756     0.200
    20.365     1.448     0.200
    20.476     2.829     0.200
    20.476     3.204     0.200
    20.476     2.709     0.200
    20.476     2.179     0.200
    20.540     6.402     0.200
    20.540     6.862     0.200
    21.092     3.347     0.200
    21.094     2.560     0.200
    21.154     3.276     0.200
    21.318     4.188     0.200
    21.638     1.987     0.200
    21.729     1.498     0.200
    21.828     1.014     0.200
    21.867    -0.401     0.200
    21.867    -0.156     0.200
    21.956    -0.198     0.200
    22.071     0.430     0.200
    22.122     1.842     0.200
    22.271     3.116     0.200
    22.273     2.650     0.200
    22.313     5.962     0.200
    22.483     4.427     0.200
    22.705     0.133     0.200
    22.856     2.934     0.200
    22.856     2.450     0.200
    22.856     1.190     0.200
    23.212     3.711     0.200
    23.212     4.727     0.200
    23.904     3.219     0.200
    24.131     7.646     0.200
    24.148     1.842     0.200
    24.295     0.951     0.200
    24.295     1.172     0.200
    24.446     7.771     0.200
    24.812     6.237     0.200
    25.211     6.909     0.200
    25.431     5.118     0.200
    25.555     6.491     0.200
    25.677     6.983     0.200
    25.867     7.166     0.200
    25.870     6.458     0.200
    25.870     2.797     0.200
    25.920     5.879     0.200
    26.452     5.679     0.200
    26.460     5.515     0.200
    26.414     4.684     0.200
    26.414     5.689     0.200
    26.414     4.814     0.200
    26.488     4.649     0.200
    26.760     6.174     0.200
    26.811     5.632     0.200
    27.182     1.600     0.200
    27.273     4.329     0.200
    27.258     4.318     0.200
    27.664     4.432     0.200
    27.683     3.613     0.200
    27.683     3.343     0.200
    27.839     3.116     0.200
    27.839     3.536     0.200
    28.142     3.913     0.200
    28.357     4.098     0.200
    28.375     4.440     0.200
    28.510     4.335     0.200
    28.591     4.163     0.200
    28.591     5.019     0.200
    29.355     5.336     0.200
    29.988     4.474     0.200
    31.776     1.236     0.200
    31.915     1.936     0.200
    32.198     3.155     0.200
    32.255     2.249     0.200
    33.720     0.802     0.200
    33.720     0.252     0.200
    34.881     2.097     0.200
    34.991     3.252     0.200
    34.991     3.603     0.200
    35.409     3.797     0.200
    35.409     3.147     0.200
    35.409     5.047     0.200
    35.770     2.848     0.200
    36.272     6.982     0.200
    38.187     1.808     0.200
    39.296     2.579     0.200
    40.284     2.311     0.200
    42.312     1.803     0.200
    42.482     2.424     0.200
    42.540     2.555     0.200
    44.559     4.379     0.200
    44.559     3.629     0.200
    44.559     2.819     0.200
    44.616     5.815     0.200
    44.616     6.376     0.200
    45.502     1.908     0.200
    45.502     1.314     0.200
    46.127     2.770     0.200
    46.127     3.251     0.200
    46.342     4.963     0.200
    46.423     1.303     0.200
    46.722     5.051     0.200
    47.215     1.809     0.200
    47.467     2.101     0.200
    47.817     4.576     0.200
    47.925     4.622     0.200
    47.963     1.773     0.200
    48.194     2.379     0.200
    49.047     1.444     0.200
    50.224     3.716     0.200
    50.508     1.960     0.200
    50.601     2.239     0.200
    50.601     2.085     0.200
    51.498     4.795     0.200
    51.584     1.537     0.200
    51.584     1.961     0.200
    51.916     5.134     0.200
    52.127     4.779     0.200
    52.853     3.307     0.200
    52.925     3.704     0.200
    53.449     3.319     0.200
    53.545     2.809     0.200
    53.663     4.706     0.200
    53.692     4.102     0.200
    53.760     4.291     0.200
    53.946     4.258     0.200
    54.364     3.137     0.200
    54.518     3.915     0.200
    54.910     3.005     0.200
    54.948     2.478     0.200
    55.063     2.618     0.200
    55.114     3.280     0.200
    55.230     4.018     0.200
    55.358     2.046     0.200
    55.926     4.464     0.200
    56.027     4.068     0.200
    56.149     2.272     0.200
    56.149     1.992     0.200
    56.282     4.321     0.200
    56.282     3.871     0.200
    56.446     2.784     0.200
    56.701     2.611     0.200
    57.095     2.952     0.200
    57.151     3.777     0.200
    57.186     2.908     0.200
    57.310     2.903     0.200
    57.319     3.943     0.200
    57.623     3.871     0.200
    57.943     2.878     0.200
    57.943     2.288     0.200
    57.966     3.815     0.200
    58.169     3.542     0.200
    58.201     0.869     0.200
    58.201     1.569     0.200
    58.346     2.353     0.200
    58.346     3.299     0.200
    58.398     1.771     0.200
    58.689     2.583     0.200
    59.278     1.882     0.200
    59.278     2.652     0.200
    59.536     2.493     0.200
    59.536     3.823     0.200
    60.152     2.784     0.200
    60.152     3.255     0.200
    60.329     1.855     0.200
    60.478     6.068     0.200
    60.570     2.923     0.200
    60.645     2.212     0.200
    60.632     3.165     0.200
    61.042     1.709     0.200
    61.180     2.157     0.200
    61.424     2.115     0.200
    61.337     0.552     0.200
    61.337     1.903     0.200
    61.432     1.911     0.200
    61.959     3.209     0.200
    62.297     3.631     0.200
    62.297     3.261     0.200
    62.771     3.605     0.200
    62.771     3.980     0.200
    62.771     3.399     0.200
    62.868     2.684     0.200
    62.868     3.434     0.200
    62.868     3.144     0.200
    62.977     2.670     0.200
    63.226     2.776     0.200
    63.726     4.677     0.200
    63.809     2.533     0.200
    64.057     3.612     0.200
    64.280     0.808     0.200
    64.418     3.396     0.200
    64.418     3.956     0.200
    64.897     4.131     0.200
    64.897     4.760     0.200
    64.989     4.115     0.200
    65.130     2.566     0.200
    65.368     2.087     0.200
    65.660     1.738     0.200
    65.660     3.183     0.200
    65.660     2.018     0.200
    66.430     4.292     0.200
    66.632     2.638     0.200
    66.923     3.697     0.200
    66.917     2.562     0.200
    67.062     3.612     0.200
    67.570     1.647     0.200
    67.665     2.969     0.200
    69.640     1.929     0.200
    69.640     2.373     0.200
    70.179     2.277     0.200
    71.136     1.500     0.200
    71.136     1.939     0.200
    71.785     1.179     0.200
    71.785     1.004     0.200
    72.614     2.174     0.200
    72.614     1.523     0.200
    76.357     2.181     0.200
    76.526     2.075     0.200
    76.526     3.045     0.200
    76.526     3.225     0.200
    76.634     2.611     0.200
    77.418     4.002     0.200
    77.418     4.203     0.200
    78.378     2.169     0.200
    78.378     4.069     0.200
    78.433     2.660     0.200
    78.915     2.349     0.200
    79.260     3.077     0.200
    79.772     4.613     0.200
    79.776     2.015     0.200
    79.776     4.290     0.200
    79.797     2.218     0.200
    79.869     4.163     0.200
    80.223     3.327     0.200
    80.298     3.545     0.200
    80.500     3.620     0.200
    80.587     4.262     0.200
    80.590     5.174     0.200
    80.681     4.069     0.200
    80.776     4.394     0.200
    80.843     3.243     0.200
    80.909     4.316     0.200
    81.105     5.011     0.200
    81.529     4.075     0.200
    83.060     4.871     0.200
    83.091     3.981     0.200
    83.091     3.762     0.200
    83.343     2.688     0.200
    83.343     3.193     0.200
    83.638     3.045     0.200
    84.222     3.566     0.200
    84.734     2.252     0.200
    84.724     3.478     0.200
    84.896     2.263     0.200
    84.896     6.233     0.200
    85.044     2.722     0.200
    85.044     2.322     0.200
    85.044     2.622     0.200
    85.366     4.468     0.200
    85.481     3.198     0.200
    85.481     3.799     0.200
    85.646     3.077     0.200
    85.758     2.680     0.200
    85.758     2.980     0.200
    85.758     1.359     0.200
    85.753     3.410     0.200
    85.762     2.300     0.200
    85.869     3.938     0.200
    85.900     2.738     0.200
    86.177     1.646     0.200
    86.228     4.275     0.200
    86.228     4.985     0.200
    86.235     2.885     0.200
    86.324     1.864     0.200
    86.324     1.664     0.200
    86.408     3.812     0.200
    86.476     3.635     0.200
    86.526     2.723     0.200
    86.526     5.681     0.200
    86.658     3.903     0.200
    86.965     3.594     0.200
    87.614     4.486     0.200
    87.635     4.175     0.200
    87.635     3.631     0.200
    87.704     3.269     0.200
    88.115     3.027     0.200
    88.115     3.651     0.200
    88.130     2.532     0.200
    88.553     4.679     0.200
    88.553     3.185     0.200
    88.553     6.005     0.200
    88.449     4.256     0.200
    88.449     3.767     0.200
    88.554     3.553     0.200
    88.715     4.356     0.200
    88.599     3.385     0.200
    88.804     2.512     0.200
    88.825     3.152     0.200
    88.825     2.859     0.200
    89.132     3.587     0.200
    89.236     0.722     0.200
    89.450     5.547     0.200
    89.776     2.735     0.200
    89.965     2.117     0.200
    89.992     4.578     0.200
    90.062     4.099     0.200
    90.160     5.221     0.200
    90.186     2.891     0.200
    90.263     3.223     0.200
    90.263     3.664     0.200
    90.263     2.790     0.200
    90.319     4.360     0.200
    90.397     3.946     0.200
    90.436     3.216     0.200
    90.436     5.436     0.200
    90.643     2.140     0.200
    90.823     3.180     0.200
    90.826     4.224     0.200
    90.914     3.150     0.200
    90.933     1.056     0.200
    90.990     3.162     0.200
    90.990     2.842     0.200
    90.990     3.512     0.200
    91.032     2.118     0.200
    91.178     3.823     0.200
    91.207     2.451     0.200
    91.276     2.371     0.200
    91.593     2.146     0.200
    91.593     4.446     0.200
    91.745     3.912     0.200
    91.797     2.774     0.200
    91.805     3.864     0.200
    91.838     2.533     0.200
    91.996     2.930     0.200
    92.042     2.482     0.200
    92.295     3.038     0.200
    92.320     3.381     0.200
    92.320     3.752     0.200
    92.400     6.678     0.200
    92.400     2.783     0.200
    92.400     3.731     0.200
    92.409     3.371     0.200
    92.570     2.026     0.200
    92.595     2.257     0.200
    92.617     3.130     0.200
    92.788     1.997     0.200
    92.846     2.955     0.200
    92.889     2.424     0.200
    92.963     2.957     0.200
    93.000     3.445     0.200
    93.123     2.054     0.200
    93.241     2.251     0.200
    93.241     3.632     0.200
    93.251     3.288     0.200
    93.251     3.758     0.200
    93.398     2.241     0.200
    93.500     2.140     0.200
    93.536     3.191     0.200
    93.539     3.462     0.200
    93.539     4.312     0.200
    93.611     1.799     0.200
    93.868     2.906     0.200
    94.048     2.220     0.200
    94.101     4.974     0.200
    94.235     2.487     0.200
    94.235     0.462     0.200
    94.595     3.092     0.200
    94.985     4.124     0.200
    95.835     5.889     0.200
    96.010     1.347     0.200
    96.071     2.372     0.200
    96.419     1.592     0.200
    96.419     2.192     0.200
    14.912     6.634     0.200
    14.962     6.157     0.200
    17.952     3.606     0.200
    18.266     0.563     0.200
    19.799     1.155     0.200
    20.633     1.769     0.200
    20.493     3.379     0.200
    21.331     3.306     0.200
    21.331     3.685     0.200
    21.420     6.586     0.200
    21.793    -0.472     0.200
    21.793    -0.069     0.200
    21.793     0.040     0.200
    21.933     3.392     0.200
    22.015     0.314     0.200
    22.054     4.511     0.200
    22.215    -0.244     0.200
    22.215     0.346     0.200
    22.215     0.639     0.200
    22.669     3.050     0.200
    23.083     2.409     0.200
    23.083     2.268     0.200
    24.216     1.430     0.200
    24.218     0.392     0.200
    24.218     0.599     0.200
    24.699     0.357     0.200
    25.319     1.369     0.200
    25.493     3.684     0.200
    25.493     4.625     0.200
    26.308     3.766     0.200
    26.555     4.849     0.200
    26.555     4.537     0.200
    26.659     1.203     0.200
    26.659     2.582     0.200
    26.791     3.293     0.200
    26.792     2.587     0.200
    26.792     2.357     0.200
    29.012     3.391     0.200
    29.787     3.824     0.200
    30.232     1.104     0.200
    30.232     1.475     0.200
    31.253     1.698     0.200
    31.253     2.757     0.200
    32.345     1.402     0.200
    33.189     0.808     0.200
    34.033     2.436     0.200
    37.532     0.659     0.200
    37.532     1.519     0.200
    37.532     2.480     0.200
    45.426     0.905     0.200
    45.426     1.561     0.200
    45.755     2.781     0.200
    45.755     3.410     0.200
    45.755     3.250     0.200
    46.325     4.816     0.200
    46.403     0.999     0.200
    46.432     1.349     0.200
    47.208     1.331     0.200
    47.291     3.145     0.200
    47.509     4.277     0.200
    51.843     1.574     0.200
    52.656     4.954     0.200
    53.425     1.952     0.200
    54.141     3.295     0.200
    55.351     2.097     0.200
    55.439     3.417     0.200
    55.439     2.859     0.200
    55.481     4.217     0.200
    56.190     2.629     0.200
    56.971     3.487     0.200
    56.971     2.987     0.200
    57.233     2.439     0.200
    57.373     3.542     0.200
    57.549     3.209     0.200
    57.763     2.471     0.200
    58.045     3.035     0.200
    58.138     2.477     0.200
    59.924     1.240     0.200
    60.065     1.919     0.200
    60.241     2.916     0.200
    60.777     1.102     0.200
    61.993     2.891     0.200
    62.426     2.456     0.200
    63.773     2.194     0.200
    65.390     3.214     0.200
    65.388     2.878     0.200
    65.388     4.007     0.200
    65.388     2.308     0.200
    78.519     2.931     0.200
    83.602     3.450     0.200
    83.791     1.235     0.200
    84.993     2.424     0.200
    85.304     2.519     0.200
    85.480     1.594     0.200
    90.792     2.191     0.200
    91.968     1.402     0.200
    14.186     7.069     0.200
    14.742     6.449     0.200
    15.296     6.870     0.200
    15.316     6.432     0.200
    15.320     5.498     0.200
    15.332     8.344     0.200
    15.350     6.872     0.200
    15.489     5.585     0.200
    15.490     5.218     0.200
    15.513     5.804     0.200
    15.518     7.151     0.200
    15.528     7.193     0.200
    15.527     5.095     0.200
    15.699     5.147     0.200
    15.711     6.039     0.200
    15.713     5.321     0.200
    15.761     7.342     0.200
    15.804     5.732     0.200
    15.806     5.353     0.200
    15.807     5.691     0.200
    15.870     6.106     0.200
    15.894     7.218     0.200
    15.995     5.556     0.200
    16.021     7.155     0.200
    16.029     6.008     0.200
    16.031     4.571     0.200
    16.030     8.987     0.200
    16.063     4.513     0.200
    16.072     5.271     0.200
    16.089     6.988     0.200
    16.121     7.109     0.200
    16.136     8.497     0.200
    16.154     5.679     0.200
    16.154     9.720     0.200
    16.222     5.293     0.200
    16.396     4.841     0.200
    16.403     5.278     0.200
    16.414     6.723     0.200
    16.438     5.887     0.200
    16.441     6.385     0.200
    16.444     4.766     0.200
    16.457     5.831     0.200
    16.486     5.987     0.200
    16.506     4.506     0.200
    16.529     4.028     0.200
    16.536     4.820     0.200
    16.560     5.757     0.200
    16.575     4.865     0.200
    16.582     4.955     0.200
    16.582     5.180     0.200
    16.618     8.544     0.200
    16.657     6.471     0.200
    16.671     6.821     0.200
    16.729     4.855     0.200
    16.731     4.661     0.200
    16.747     6.042     0.200
    16.764     4.435     0.200
    16.764     4.279     0.200
    16.764     4.989     0.200
    16.786     6.075     0.200
    16.793     5.983     0.200
    16.809     5.083     0.200
    16.844     6.760     0.200
    16.846     6.018     0.200
    16.875     5.486     0.200
    16.906     4.744     0.200
    16.912     4.669     0.200
    16.946     5.821     0.200
    16.975     5.647     0.200
    16.975     4.725     0.200
    16.991     6.316     0.200
    17.011     5.196     0.200
    17.057     5.323     0.200
    17.070     4.989     0.200
    17.068     4.837     0.200
    17.072     4.781     0.200
    17.072     4.429     0.200
    17.075     4.573     0.200
    17.088     4.765     0.200
    17.117     4.930     0.200
    17.185     4.429     0.200
    17.193     3.766     0.200
    17.414     5.812     0.200
    17.579     5.087     0.200
    17.587     4.728     0.200
    17.616     5.064     0.200
    17.620     4.500     0.200
    17.815     5.434     0.200
    17.971     5.449     0.200
    18.187     3.193     0.200
    18.306     3.420     0.200
    18.359     4.360     0.200
    18.525     0.999     0.200
    18.525     0.759     0.200
    18.977     2.912     0.200
    19.014     1.879     0.200
    19.014     2.188     0.200
    19.325     2.191     0.200
    19.316     3.368     0.200
    19.400     1.055     0.200
    19.479     1.704     0.200
    19.479     2.763     0.200
    19.479     4.523     0.200
    19.889     1.340     0.200
    20.019     1.714     0.200
    20.019     1.394     0.200
    20.010     1.623     0.200
    20.045     1.922     0.200
    20.067    -0.323     0.200
    20.271     1.283     0.200
    20.383     0.691     0.200
    20.383     1.701     0.200
    20.383     0.461     0.200
    20.383     1.361     0.200
    20.623     2.387     0.200
    20.803     2.278     0.200
    20.803    -0.333     0.200
    20.933     1.318     0.200
    21.082     6.123     0.200
    21.138     4.591     0.200
    21.209     3.369     0.200
    21.246     4.047     0.200
    21.246     3.137     0.200
    21.310     3.079     0.200
    21.350     5.318     0.200
    21.354     4.155     0.200
    21.354     2.682     0.200
    21.354     4.872     0.200
    21.354     4.152     0.200
    21.354     2.472     0.200
    21.416     3.080     0.200
    21.410     3.034     0.200
    21.546     2.107     0.200
    21.350     6.008     0.200
    21.350     6.868     0.200
    21.646     3.772     0.200
    21.683     2.954     0.200
    21.683     3.545     0.200
    21.683     2.625     0.200
    21.716     2.617     0.200
    21.717     2.815     0.200
    21.782     0.707     0.200
    21.733     2.875     0.200
    21.787     1.456     0.200
    21.903     1.694     0.200
    21.903     1.214     0.200
    21.934     1.958     0.200
    22.004     0.176     0.200
    22.004    -0.124     0.200
    22.004     0.506     0.200
    22.101     3.963     0.200
    22.121     3.751     0.200
    22.163     0.524     0.200
    22.163     0.834     0.200
    22.373     0.519     0.200
    22.373     0.779     0.200
    22.373     2.279     0.200
    22.401     3.382     0.200
    22.401     4.492     0.200
    22.401     4.350     0.200
    22.401     4.202     0.200
    22.412     4.067     0.200
    22.468     0.699     0.200
    22.468     0.474     0.200
    22.468     0.319     0.200
    22.468     1.769     0.200
    22.481     1.575     0.200
    22.481     2.034     0.200
    22.563     1.957     0.200
    22.846     2.866     0.200
    22.893     0.264     0.200
    22.913     1.989     0.200
    23.013     3.277     0.200
    23.105     1.932     0.200
    23.097     3.441     0.200
    23.156     1.892     0.200
    23.425     1.929     0.200
    23.425     2.539     0.200
    23.425     2.299     0.200
    23.409     3.437     0.200
    23.609     0.412     0.200
    23.701     2.188     0.200
    23.701     4.748     0.200
    23.701     3.038     0.200
    23.701     1.738     0.200
    23.701     2.808     0.200
    23.721     0.808     0.200
    23.866     1.831     0.200
    23.866     1.631     0.200
    23.999     2.176     0.200
    23.999     1.718     0.200
    24.103     2.064     0.200
    24.103     2.244     0.200
    24.125     1.553     0.200
    24.195     3.731     0.200
    24.395     1.356     0.200
    24.395     1.876     0.200
    24.395     1.486     0.200
    24.379     6.250     0.200
    24.430     1.210     0.200
    24.430     1.580     0.200
    24.405     5.015     0.200
    24.542     5.075     0.200
    24.722     3.828     0.200
    24.722     4.878     0.200
    24.963     3.827     0.200
    25.081     4.455     0.200
    25.228     4.425     0.200
    25.359     1.095     0.200
    25.359     1.285     0.200
    25.359     1.635     0.200
    25.416     4.265     0.200
    25.779     5.328     0.200
    25.826     4.598     0.200
    25.847     4.009     0.200
    25.847     4.259     0.200
    25.847     2.908     0.200
    25.868     4.819     0.200
    25.973     3.870     0.200
    26.079     3.756     0.200
    26.132     3.552     0.200
    26.132     4.096     0.200
    26.132     4.326     0.200
    26.243     8.024     0.200
    26.388     3.850     0.200
    26.388     4.182     0.200
    26.388     3.612     0.200
    26.507     4.739     0.200
    26.507     4.043     0.200
    26.595     2.456     0.200
    26.595     2.226     0.200
    26.573     8.150     0.200
    26.609     4.918     0.200
    26.661     3.275     0.200
    26.661     3.725     0.200
    26.661     3.485     0.200
    26.698     7.720     0.200
    26.786     4.723     0.200
    26.787     3.679     0.200
    26.788     3.844     0.200
    26.788     6.264     0.200
    26.788     4.879     0.200
    26.788     5.193     0.200
    26.788     3.444     0.200
    26.788     5.024     0.200
    26.788     5.304     0.200
    26.817     3.145     0.200
    26.849     7.257     0.200
    26.868     5.304     0.200
    26.884     4.879     0.200
    26.895     4.340     0.200
    26.907     4.990     0.200
    26.907     3.620     0.200
    26.913     4.482     0.200
    26.928     4.345     0.200
    26.961     1.440     0.200
    26.961     1.870     0.200
    26.961     1.630     0.200
    26.961     2.450     0.200
    26.930     3.106     0.200
    27.015     4.804     0.200
    27.015     6.365     0.200
    27.140     2.842     0.200
    27.141     2.936     0.200
    27.140     2.937     0.200
    27.140     3.207     0.200
    27.140     2.737     0.200
    27.225     4.682     0.200
    27.267     1.580     0.200
    27.280     3.492     0.200
    27.280     5.712     0.200
    27.280     3.912     0.200
    27.280     3.682     0.200
    27.283     3.757     0.200
    27.283     4.137     0.200
    27.373     4.646     0.200
    27.369     4.419     0.200
    27.369     6.029     0.200
    27.379     5.497     0.200
    27.432     2.381     0.200
    27.432     3.331     0.200
    27.432     3.071     0.200
    27.492     2.586     0.200
    27.492     2.451     0.200
    27.492     3.186     0.200
    27.469     5.681     0.200
    27.529     2.262     0.200
    27.529     3.922     0.200
    27.544     1.358     0.200
    27.544     1.167     0.200
    27.569     2.277     0.200
    27.569     3.317     0.200
    27.569     2.997     0.200
    27.569     2.697     0.200
    27.601     4.406     0.200
    27.720     5.644     0.200
    27.721     4.732     0.200
    27.726     4.843     0.200
    27.726     4.033     0.200
    27.763     3.956     0.200
    27.812     1.803     0.200
    27.812     3.851     0.200
    27.908     3.219     0.200
    27.969     6.921     0.200
    28.014     4.621     0.200
    28.067     7.147     0.200
    28.106     6.396     0.200
    28.169     2.536     0.200
    28.167     4.752     0.200
    28.207     2.540     0.200
    28.451     4.822     0.200
    28.590     2.652     0.200
    28.590     3.934     0.200
    28.632     5.519     0.200
    28.835     3.814     0.200
    28.938     2.395     0.200
    28.938     1.475     0.200
    29.043     1.693     0.200
    29.043     2.413     0.200
    29.038     4.538     0.200
    29.299     4.713     0.200
    29.345     4.889     0.200
    29.363     2.943     0.200
    29.365     3.114     0.200
    29.365     4.024     0.200
    29.365     3.684     0.200
    29.365     2.904     0.200
    29.427     1.314     0.200
    29.466     4.209     0.200
    29.682     3.380     0.200
    29.746     6.135     0.200
    29.764     3.214     0.200
    29.970     3.217     0.200
    30.041     1.228     0.200
    30.141     4.085     0.200
    30.235     2.012     0.200
    30.235     2.382     0.200
    30.235     2.202     0.200
    30.320     2.600     0.200
    30.320     3.630     0.200
    30.316     5.192     0.200
    30.405     1.161     0.200
    30.405     2.540     0.200
    30.405     2.151     0.200
    30.425     1.158     0.200
    31.226     1.790     0.200
    31.226     1.934     0.200
    31.270     1.415     0.200
    31.334     0.850     0.200
    31.430     1.457     0.200
    31.556     1.978     0.200
    31.556     1.708     0.200
    31.556     1.558     0.200
    31.548     2.597     0.200
    31.548     2.907     0.200
    31.592     1.332     0.200
    31.626     2.452     0.200
    31.753     3.023     0.200
    31.753     2.873     0.200
    31.770     1.274     0.200
    31.788     3.384     0.200
    31.788     1.244     0.200
    31.799     0.470     0.200
    31.964     1.360     0.200
    32.105     2.422     0.200
    32.105     2.813     0.200
    32.150     2.839     0.200
    32.176     2.209     0.200
    32.176     2.069     0.200
    32.176     2.309     0.200
    32.176     1.909     0.200
    32.321     3.987     0.200
    32.459     1.550     0.200
    32.520     2.003     0.200
    32.520     2.413     0.200
    32.520     2.123     0.200
    32.589     2.284     0.200
    32.744     1.532     0.200
    32.866     1.102     0.200
    32.874     3.317     0.200
    33.138     1.255     0.200
    33.283     0.933     0.200
    33.493     0.689     0.200
    33.493     0.789     0.200
    33.493     0.988     0.200
    33.539     2.647     0.200
    33.597     1.963     0.200
    33.701     2.470     0.200
    33.966     2.439     0.200
    33.979     2.939     0.200
    33.979     4.229     0.200
    33.979     3.561     0.200
    33.979     3.969     0.200
    34.380     1.507     0.200
    34.386     2.330     0.200
    34.386     2.606     0.200
    34.743     3.608     0.200
    34.860     1.452     0.200
    34.938     1.505     0.200
    34.938     1.615     0.200
    34.970     2.459     0.200
    34.970     3.599     0.200
    34.970     1.170     0.200
    35.100     1.942     0.200
    35.100     2.832     0.200
    35.202     2.048     0.200
    35.202     2.648     0.200
    35.202     1.783     0.200
    35.202     2.309     0.200
    35.229     3.514     0.200
    35.269     1.450     0.200
    35.345     2.673     0.200
    35.345     4.653     0.200
    35.345     2.070     0.200
    36.040     1.851     0.200
    36.089     2.609     0.200
    36.149     3.665     0.200
    36.303     3.726     0.200
    36.303     4.064     0.200
    36.303     2.235     0.200
    36.303     4.556     0.200
    36.352     2.295     0.200
    36.352     0.043     0.200
    36.352     0.435     0.200
    36.329     3.963     0.200
    36.585     3.860     0.200
    36.585     3.650     0.200
    36.585     4.110     0.200
    36.678     3.844     0.200
    36.678     1.526     0.200
    36.676     2.606     0.200
    36.676     3.116     0.200
    36.746     4.232     0.200
    37.002     3.294     0.200
    37.108     3.112     0.200
    37.175     0.717     0.200
    37.253     1.294     0.200
    37.265     2.255     0.200
    37.265     4.525     0.200
    37.265     2.588     0.200
    37.265     2.366     0.200
    37.399     3.648     0.200
    37.637     2.182     0.200
    37.819     2.171     0.200
    37.855     1.992     0.200
    37.855     2.332     0.200
    38.923     0.963     0.200
    39.076     2.158     0.200
    39.076     2.008     0.200
    41.097     1.342     0.200
    41.184     2.615     0.200
    41.253     2.345     0.200
    41.253     2.714     0.200
    41.253     2.566     0.200
    41.352     2.765     0.200
    41.734     2.198     0.200
    41.734     2.553     0.200
    41.734     5.493     0.200
    41.734     4.223     0.200
    41.927     1.692     0.200
    42.846     1.148     0.200
    43.504     2.172     0.200
    44.337     3.832     0.200
    44.337     3.411     0.200
    44.337     4.681     0.200
    44.646     7.106     0.200
    45.419     3.726     0.200
    45.419     3.311     0.200
    45.419     4.101     0.200
    45.419     3.156     0.200
    45.419     3.851     0.200
    45.480     4.816     0.200
    45.641     1.392     0.200
    45.641     1.522     0.200
    45.641     1.693     0.200
    45.983     4.746     0.200
    45.983     5.055     0.200
    46.160     4.302     0.200
    46.160     3.242     0.200
    46.515     4.120     0.200
    46.515     5.111     0.200
    46.535     5.459     0.200
    46.605     3.239     0.200
    46.772     1.852     0.200
    46.772     2.452     0.200
    46.772     2.102     0.200
    46.947     3.833     0.200
    47.130     3.451     0.200
    47.166     4.120     0.200
    47.166     6.470     0.200
    47.231     3.986     0.200
    47.231     4.556     0.200
    47.352     1.770     0.200
    47.543     5.212     0.200
    47.543     3.938     0.200
    47.543     5.798     0.200
    47.976     4.113     0.200
    47.976     5.793     0.200
    47.976     1.240     0.200
    48.013     3.992     0.200
    48.142     4.651     0.200
    48.292     5.881     0.200
    48.434     2.078     0.200
    48.434     1.857     0.200
    48.599     4.125     0.200
    48.617     3.878     0.200
    48.617     5.848     0.200
    48.822     2.855     0.200
    48.989     2.775     0.200
    48.972     4.114     0.200
    48.972     3.484     0.200
    49.120     2.466     0.200
    49.120     1.567     0.200
    49.227     3.159     0.200
    49.227     5.819     0.200
    49.227     4.636     0.200
    49.672     6.576     0.200
    49.773     3.845     0.200
    49.773     2.805     0.200
    50.245     4.105     0.200
    50.241     5.529     0.200
    50.241     4.095     0.200
    50.241     2.409     0.200
    50.313     4.772     0.200
    51.123     3.034     0.200
    51.168     1.211     0.200
    51.168     0.349     0.200
    51.168     2.109     0.200
    51.375     1.845     0.200
    51.375     1.688     0.200
    51.425     2.125     0.200
    51.425     1.716     0.200
    51.472     4.032     0.200
    51.501     3.996     0.200
    51.550     1.360     0.200
    51.550     1.244     0.200
    52.311     4.941     0.200
    52.309     4.502     0.200
    52.387     4.355     0.200
    52.435     4.206     0.200
    52.492     4.496     0.200
    52.496     4.634     0.200
    52.476     6.054     0.200
    52.637     4.123     0.200
    52.697     4.417     0.200
    52.726     4.603     0.200
    52.819     3.357     0.200
    52.792     7.077     0.200
    52.818     4.417     0.200
    52.850     5.487     0.200
    53.056     3.471     0.200
    53.082     4.343     0.200
    53.217     3.550     0.200
    53.439     7.523     0.200
    53.487     3.206     0.200
    53.588     4.295     0.200
    53.588     3.955     0.200
    53.718     1.794     0.200
    53.666     5.859     0.200
    54.018     3.432     0.200
    54.196     5.893     0.200
    54.200     5.969     0.200
    54.213     3.669     0.200
    54.315     2.782     0.200
    54.377     2.112     0.200
    54.377     1.790     0.200
    54.495     3.248     0.200
    54.485     4.670     0.200
    54.570     4.095     0.200
    54.679     4.351     0.200
    54.679     5.401     0.200
    54.805     3.418     0.200
    54.859     4.130     0.200
    55.152     3.886     0.200
    55.233     5.447     0.200
    55.698     2.678     0.200
    55.698     2.803     0.200
    55.819     2.885     0.200
    55.834     3.268     0.200
    55.903     2.726     0.200
    55.903     2.944     0.200
    55.903     2.516     0.200
    55.938     5.352     0.200
    56.255     1.438     0.200
    56.255     1.157     0.200
    56.369     3.229     0.200
    56.369     2.540     0.200
    56.369     4.060     0.200
    56.369     3.650     0.200
    56.416     2.972     0.200
    56.440     4.230     0.200
    56.440     7.150     0.200
    56.519     3.091     0.200
    56.660     4.053     0.200
    56.700     3.400     0.200
    56.759     3.596     0.200
    56.734     4.078     0.200
    56.734     4.358     0.200
    56.985     3.680     0.200
    56.987     4.180     0.200
    56.987     4.670     0.200
    56.985     5.130     0.200
    57.051     2.293     0.200
    57.051     1.973     0.200
    57.051     1.583     0.200
    57.313     2.761     0.200
    57.325     2.478     0.200
    57.325     2.728     0.200
    57.325     2.918     0.200
    57.324     2.888     0.200
    57.379     2.171     0.200
    57.379     2.341     0.200
    57.324     3.513     0.200
    57.324     3.982     0.200
    57.386     2.271     0.200
    57.419     3.398     0.200
    57.419     3.797     0.200
    57.370     4.037     0.200
    57.370     4.157     0.200
    57.548     4.246     0.200
    57.523     2.781     0.200
    57.525     2.564     0.200
    57.539     5.112     0.200
    57.587     2.134     0.200
    57.596     2.268     0.200
    57.667     2.938     0.200
    57.667     3.160     0.200
    57.667     2.357     0.200
    57.707     3.016     0.200
    57.727     2.660     0.200
    57.727     3.050     0.200
    57.727     2.251     0.200
    57.841     3.828     0.200
    58.020     2.689     0.200
    57.987     3.814     0.200
    57.987     4.844     0.200
    57.987     3.624     0.200
    58.114     2.650     0.200
    58.242     2.399     0.200
    58.242     2.149     0.200
    58.242     3.219     0.200
    58.312     3.807     0.200
    58.312     3.946     0.200
    58.493     2.388     0.200
    58.430     6.026     0.200
    58.430     5.186     0.200
    58.430     5.916     0.200
    58.563     2.058     0.200
    58.563     3.547     0.200
    58.563     2.398     0.200
    58.944     4.057     0.200
    59.320     2.075     0.200
    59.320     4.104     0.200
    59.320     2.440     0.200
    59.320     3.104     0.200
    59.501     5.495     0.200
    59.545     6.291     0.200
    59.705     2.737     0.200
    59.685     3.525     0.200
    59.669     4.730     0.200
    59.692     6.656     0.200
    59.695     5.409     0.200
    59.704     6.897     0.200
    60.350     2.426     0.200
    60.390     3.552     0.200
    60.390     2.253     0.200
    60.418     2.378     0.200
    60.484     3.190     0.200
    60.484     2.860     0.200
    60.484     3.550     0.200
    60.555     3.556     0.200
    60.601     3.209     0.200
    60.717     0.988     0.200
    61.156     3.300     0.200
    61.266     4.382     0.200
    61.266     1.772     0.200
    61.447     3.519     0.200
    61.447     3.084     0.200
    61.509     3.295     0.200
    61.509     2.334     0.200
    61.509     2.805     0.200
    61.607     3.753     0.200
    61.607     3.092     0.200
    61.573     3.850     0.200
    61.839     2.330     0.200
    61.839     3.420     0.200
    61.839     2.100     0.200
    61.957     2.442     0.200
    62.071     3.700     0.200
    62.269     3.064     0.200
    62.269     2.084     0.200
    62.274     1.767     0.200
    62.274     2.731     0.200
    62.269     2.251     0.200
    62.269     2.624     0.200
    62.274     2.591     0.200
    62.274     2.851     0.200
    62.362     3.357     0.200
    62.362     2.720     0.200
    62.412     2.699     0.200
    62.429     3.313     0.200
    62.417     3.872     0.200
    62.601     2.947     0.200
    62.601     3.153     0.200
    62.786     1.634     0.200
    62.905     1.740     0.200
    62.884     2.358     0.200
    62.884     2.582     0.200
    62.890     6.107     0.200
    63.143     3.896     0.200
    63.210     4.447     0.200
    63.238     3.598     0.200
    63.340     3.876     0.200
    63.340     2.071     0.200
    63.453     1.578     0.200
    63.453     3.258     0.200
    63.453     0.718     0.200
    63.418     3.210     0.200
    63.418     3.475     0.200
    63.418     3.935     0.200
    63.418     3.675     0.200
    63.418     3.335     0.200
    63.593     3.336     0.200
    63.744     3.323     0.200
    63.744     4.004     0.200
    63.744     2.191     0.200
    63.744     2.973     0.200
    64.125     3.728     0.200
    64.170     2.988     0.200
    64.170     2.607     0.200
    64.317     3.961     0.200
    64.321     2.010     0.200
    64.392     2.483     0.200
    64.832     2.165     0.200
    64.832     2.656     0.200
    64.832     2.906     0.200
    64.880     4.655     0.200
    65.027     3.474     0.200
    65.027     2.159     0.200
    65.109     3.994     0.200
    65.111     3.874     0.200
    65.036     3.440     0.200
    65.036     3.930     0.200
    65.094     3.057     0.200
    65.104     2.532     0.200
    65.104     3.532     0.200
    65.104     2.332     0.200
    65.169     2.805     0.200
    65.140     2.443     0.200
    65.140     3.235     0.200
    65.140     3.055     0.200
    65.145     3.086     0.200
    65.170     2.530     0.200
    65.245     3.133     0.200
    65.285     5.033     0.200
    65.331     3.949     0.200
    65.401     1.851     0.200
    65.401     2.347     0.200
    65.459     5.111     0.200
    65.466     3.245     0.200
    65.466     2.505     0.200
    65.573     5.220     0.200
    65.589     4.500     0.200
    65.609     3.007     0.200
    65.646     2.559     0.200
    65.646     3.799     0.200
    65.605     2.658     0.200
    65.605     3.298     0.200
    65.656     2.736     0.200
    65.599     2.626     0.200
    65.599     2.404     0.200
    65.599     2.036     0.200
    65.832     1.898     0.200
    65.832     3.352     0.200
    65.832     3.982     0.200
    65.903     3.312     0.200
    65.903     3.422     0.200
    66.066     2.804     0.200
    66.168     3.262     0.200
    66.256     3.450     0.200
    66.289     2.883     0.200
    66.345     3.016     0.200
    66.338     3.658     0.200
    66.338     2.075     0.200
    66.330     4.786     0.200
    66.330     4.546     0.200
    66.330     3.966     0.200
    66.725     3.738     0.200
    66.773     3.171     0.200
    66.843     2.972     0.200
    67.029     4.085     0.200
    67.029     5.125     0.200
    67.317     2.871     0.200
    67.357     2.406     0.200
    67.357     1.526     0.200
    67.498     3.693     0.200
    67.549     3.790     0.200
    67.546     2.710     0.200
    67.609     5.094     0.200
    67.594     2.972     0.200
    67.594     2.337     0.200
    67.658     3.485     0.200
    67.658     2.845     0.200
    67.658     3.785     0.200
    67.684     6.798     0.200
    67.670     3.169     0.200
    67.670     2.756     0.200
    67.670     3.308     0.200
    67.670     3.669     0.200
    67.874     4.032     0.200
    67.886     3.086     0.200
    67.875     4.610     0.200
    67.937     3.063     0.200
    68.013     3.379     0.200
    68.013     3.216     0.200
    68.084     2.104     0.200
    68.176     3.289     0.200
    68.614     2.862     0.200
    68.819     2.278     0.200
    68.819     1.868     0.200
    69.417     4.481     0.200
    69.417     6.551     0.200
    70.035     3.203     0.200
    70.035     3.873     0.200
    70.227     2.939     0.200
    70.227     3.679     0.200
    71.116     3.304     0.200
    71.142     3.373     0.200
    71.433     3.518     0.200
    71.721     3.613     0.200
    71.721     3.003     0.200
    71.721     2.812     0.200
    72.465     2.049     0.200
    72.931     1.317     0.200
    74.405     2.417     0.200
    74.405     4.238     0.200
    74.608     3.131     0.200
    74.670     3.768     0.200
    74.694     3.310     0.200
    74.742     3.326     0.200
    75.054     3.182     0.200
    75.054     5.392     0.200
    75.054     3.407     0.200
    75.054     4.373     0.200
    75.306     4.457     0.200
    75.338     4.784     0.200
    75.720     4.348     0.200
    75.724     4.923     0.200
    75.898     2.628     0.200
    75.898     3.748     0.200
    75.898     1.539     0.200
    76.527     2.748     0.200
    76.527     5.758     0.200
    76.719     2.424     0.200
    76.719     3.882     0.200
    76.719     4.532     0.200
    76.971     3.661     0.200
    76.971     2.220     0.200
    76.971     3.811     0.200
    77.389     3.910     0.200
    77.332     4.336     0.200
    77.332     5.136     0.200
    77.674     5.424     0.200
    77.674     5.284     0.200
    77.674     4.404     0.200
    77.674     3.395     0.200
    77.674     2.965     0.200
    77.725     3.738     0.200
    77.725     2.488     0.200
    77.725     4.439     0.200
    78.260     2.430     0.200
    78.318     2.315     0.200
    78.509     2.410     0.200
    78.509     4.430     0.200
    78.616     3.705     0.200
    78.616     2.025     0.200
    78.616     3.905     0.200
    78.638     2.373     0.200
    78.726     3.898     0.200
    78.726     2.117     0.200
    78.726     4.148     0.200
    78.726     3.097     0.200
    78.767     2.511     0.200
    78.767     3.770     0.200
    78.767     1.950     0.200
    78.767     4.370     0.200
    78.802     3.721     0.200
    78.802     2.631     0.200
    78.898     2.541     0.200
    78.898     4.781     0.200
    79.209     4.601     0.200
    79.209     4.821     0.200
    79.230     2.437     0.200
    79.242     2.528     0.200
    79.331     2.426     0.200
    79.344     2.461     0.200
    79.378     2.345     0.200
    79.462     2.192     0.200
    79.552     2.489     0.200
    79.574     2.711     0.200
    79.574     4.651     0.200
    79.762     2.812     0.200
    79.825     2.058     0.200
    79.829     3.096     0.200
    79.912     2.307     0.200
    79.912     2.677     0.200
    79.923     2.449     0.200
    80.039     2.753     0.200
    80.039     3.053     0.200
    80.040     2.473     0.200
    80.070     2.684     0.200
    80.070     2.484     0.200
    80.071     4.609     0.200
    80.074     2.205     0.200
    80.074     3.140     0.200
    80.091     2.310     0.200
    80.119     3.300     0.200
    80.185     2.552     0.200
    80.185     4.752     0.200
    80.232     3.181     0.200
    80.232     2.691     0.200
    80.235     2.545     0.200
    80.310     3.498     0.200
    80.316     2.515     0.200
    80.316     4.155     0.200
    80.316     3.045     0.200
    80.356     4.245     0.200
    80.405     3.361     0.200
    80.426     2.566     0.200
    80.440     2.822     0.200
    80.440     4.132     0.200
    80.451     2.259     0.200
    80.606     3.579     0.200
    80.692     3.117     0.200
    80.712     2.483     0.200
    80.712     4.013     0.200
    80.712     3.223     0.200
    80.765     2.930     0.200
    80.837     4.582     0.200
    80.847     3.152     0.200
    80.858     3.105     0.200
    80.858     3.330     0.200
    80.858     2.870     0.200
    80.858     5.050     0.200
    80.885     3.386     0.200
    80.888     2.811     0.200
    80.888     3.121     0.200
    80.925     2.244     0.200
    80.952     3.399     0.200
    80.952     3.629     0.200
    80.952     3.833     0.200
    81.000     2.326     0.200
    80.291     7.201     0.200
    81.072     2.362     0.200
    81.140     2.743     0.200
    81.140     3.222     0.200
    81.153     3.301     0.200
    81.153     3.062     0.200
    81.217     3.821     0.200
    81.217     3.819     0.200
    81.213     3.505     0.200
    81.230     2.432     0.200
    81.233     2.813     0.200
    81.233     4.955     0.200
    81.236     2.833     0.200
    81.236     4.063     0.200
    81.265     4.218     0.200
    81.310     3.126     0.200
    81.325     2.790     0.200
    81.344     3.079     0.200
    81.344     3.349     0.200
    81.377     2.905     0.200
    81.377     3.665     0.200
    81.377     4.775     0.200
    81.377     3.871     0.200
    81.385     3.331     0.200
    81.426     2.915     0.200
    81.426     4.035     0.200
    81.431     2.626     0.200
    81.524     3.118     0.200
    81.524     3.544     0.200
    81.630     2.043     0.200
    81.645     3.294     0.200
    81.649     3.356     0.200
    81.649     3.706     0.200
    81.796     3.672     0.200
    81.841     3.009     0.200
    81.858     2.721     0.200
    81.858     4.062     0.200
    81.864     2.333     0.200
    81.922     3.024     0.200
    81.971     3.034     0.200
    81.971     3.229     0.200
    82.209     1.829     0.200
    82.209     3.249     0.200
    82.254     3.594     0.200
    82.320     3.250     0.200
    82.327     2.923     0.200
    82.357     3.142     0.200
    82.366     3.051     0.200
    82.487     3.458     0.200
    82.725     3.487     0.200
    82.826     3.257     0.200
    82.868     3.624     0.200
    82.898     3.461     0.200
    82.925     3.331     0.200
    82.953     3.024     0.200
    82.970     3.137     0.200
    83.063     4.156     0.200
    83.213     3.011     0.200
    83.216     3.366     0.200
    83.224     3.750     0.200
    83.229     3.156     0.200
    83.191     5.393     0.200
    83.395     2.862     0.200
    83.399     3.541     0.200
    83.428     3.664     0.200
    83.437     4.029     0.200
    83.437     4.229     0.200
    83.482     3.457     0.200
    83.437     3.379     0.200
    83.437     3.729     0.200
    83.522     3.468     0.200
    83.527     4.035     0.200
    83.603     3.646     0.200
    83.623     3.093     0.200
    83.623     3.633     0.200
    83.660     3.753     0.200
    83.710     3.399     0.200
    83.711     2.381     0.200
    83.787     2.912     0.200
    83.787     5.222     0.200
    83.803     4.791     0.200
    83.803     3.210     0.200
    83.812     3.456     0.200
    83.841     3.137     0.200
    83.839     3.618     0.200
    83.844     3.592     0.200
    83.863     4.159     0.200
    83.872     3.075     0.200
    83.872     2.960     0.200
    83.884     3.335     0.200
    83.921     3.348     0.200
    83.954     3.611     0.200
    83.937     3.564     0.200
    83.951     3.593     0.200
    83.951     2.493     0.200
    83.951     3.343     0.200
    83.951     3.123     0.200
    84.067     3.622     0.200
    84.145     2.582     0.200
    84.217     3.349     0.200
    84.217     3.830     0.200
    84.280     3.419     0.200
    84.353     3.652     0.200
    84.448     3.328     0.200
    84.491     2.250     0.200
    84.491     3.570     0.200
    84.566     3.543     0.200
    84.826     2.513     0.200
    85.084     2.795     0.200
    85.084     4.425     0.200
    85.084     3.475     0.200
    85.084     2.965     0.200
    85.057     3.234     0.200
    85.057     5.314     0.200
    85.057     4.104     0.200
    85.057     4.403     0.200
    85.057     3.403     0.200
    85.145     1.720     0.200
    85.145     3.170     0.200
    85.187     3.130     0.200
    85.190     3.027     0.200
    85.205     3.160     0.200
    85.205     2.660     0.200
    85.205     3.360     0.200
    85.205     2.610     0.200
    85.212     2.564     0.200
    85.233     2.261     0.200
    85.418     3.339     0.200
    85.442     3.776     0.200
    85.473     3.882     0.200
    85.484     3.538     0.200
    85.710     2.615     0.200
    85.732     2.936     0.200
    85.738     3.006     0.200
    85.739     3.309     0.200
    85.739     2.899     0.200
    85.739     1.500     0.200
    85.739     2.060     0.200
    85.723     2.983     0.200
    85.821     2.463     0.200
    85.821     3.523     0.200
    85.820     2.100     0.200
    85.820     1.930     0.200
    85.827     2.985     0.200
    85.827     2.296     0.200
    85.989     2.805     0.200
    86.007     1.376     0.200
    86.007     3.386     0.200
    86.007     2.776     0.200
    86.012     1.601     0.200
    86.083     1.848     0.200
    86.094     2.976     0.200
    86.220     2.674     0.200
    86.231     0.521     0.200
    86.246     2.784     0.200
    86.374     2.204     0.200
    86.380     3.144     0.200
    86.453     2.989     0.200
    86.453     3.449     0.200
    86.575     2.887     0.200
    86.575     2.377     0.200
    86.705     2.152     0.200
    86.617     3.700     0.200
    86.710     1.849     0.200
    86.714     1.789     0.200
    86.714     4.060     0.200
    86.741     1.006     0.200
    86.759     2.666     0.200
    86.791     4.533     0.200
    86.802     2.507     0.200
    87.104     5.096     0.200
    87.115     3.143     0.200
    87.170     1.307     0.200
    87.195     2.951     0.200
    87.269     2.888     0.200
    87.269     3.788     0.200
    87.316     2.729     0.200
    87.316     2.519     0.200
    87.316     2.965     0.200
    87.355     2.770     0.200
    87.468     0.466     0.200
    87.474     3.178     0.200
    87.739    -0.835     0.200
    87.721     5.122     0.200
    87.721     4.003     0.200
    87.873     4.878     0.200
    87.854     5.615     0.200
    87.774     5.168     0.200
    87.774     6.968     0.200
    87.774     4.138     0.200
    87.774     7.828     0.200
    87.774     5.668     0.200
    87.863     5.470     0.200
    87.890     4.817     0.200
    87.875     4.632     0.200
    87.906     2.880     0.200
    87.906     3.254     0.200
    87.907     3.138     0.200
    87.974     3.218     0.200
    88.023     2.505     0.200
    88.015     3.286     0.200
    87.999     4.082     0.200
    88.264     0.865     0.200
    88.324    -0.616     0.200
    88.449     2.491     0.200
    88.449     2.773     0.200
    88.498     2.271     0.200
    88.498     2.432     0.200
    88.498     3.242     0.200
    88.550     1.303     0.200
    88.607     4.165     0.200
    88.656     1.387     0.200
    88.743    -1.395     0.200
    88.756     4.253     0.200
    88.756     2.741     0.200
    88.857     2.766     0.200
    88.895     2.840     0.200
    88.895     2.982     0.200
    88.988     4.453     0.200
    88.944     3.571     0.200
    88.944     4.551     0.200
    89.103     5.273     0.200
    89.116     3.732     0.200
    89.116     2.300     0.200
    89.116     2.721     0.200
    89.165     2.411     0.200
    89.165     2.119     0.200
    89.165     3.201     0.200
    89.173     4.693     0.200
    89.304     2.003     0.200
    89.304     2.253     0.200
    89.304     3.313     0.200
    89.304     2.553     0.200
    89.331     2.743     0.200
    89.424     2.790     0.200
    89.457     3.233     0.200
    89.603     3.908     0.200
    89.500     2.532     0.200
    89.502     2.493     0.200
    89.580     4.457     0.200
    89.573     0.689     0.200
    89.630     2.906     0.200
    89.728     3.674     0.200
    89.728     0.554     0.200
    89.831     4.403     0.200
    89.923     2.774     0.200
    89.923     4.546     0.200
    90.047     2.808     0.200
    90.089     2.738     0.200
    90.106     2.978     0.200
    90.134     4.598     0.200
    90.163     3.883     0.200
    90.294     2.616     0.200
    90.294     3.192     0.200
    90.426     2.400     0.200
    90.470     2.824     0.200
    90.477     4.303     0.200
    90.555     3.127     0.200
    90.560     1.965     0.200
    90.560     3.685     0.200
    90.560     3.525     0.200
    90.560     2.503     0.200
    90.560     2.784     0.200
    90.617     2.500     0.200
    90.675     2.792     0.200
    90.751     3.696     0.200
    90.751     2.955     0.200
    91.006     3.169     0.200
    91.013     4.612     0.200
    91.021     2.641     0.200
    91.024     1.601     0.200
    91.024     2.367     0.200
    91.027     2.715     0.200
    91.081     3.243     0.200
    91.081     3.473     0.200
    91.131     3.232     0.200
    91.192     3.226     0.200
    91.277     3.029     0.200
    91.289     2.719     0.200
    91.289     2.471     0.200
    91.396     2.948     0.200
    91.507     3.158     0.200
    91.507     3.020     0.200
    91.534     4.663     0.200
    91.568     3.078     0.200
    91.637     3.186     0.200
    91.637     3.048     0.200
    91.804     3.611     0.200
    91.821    -0.917     0.200
    91.824     4.151     0.200
    91.842     3.665     0.200
    91.918     2.366     0.200
    91.918     2.585     0.200
    91.918     4.235     0.200
    91.918     2.985     0.200
    92.053     2.260     0.200
    92.053     2.570     0.200
    92.126     2.624     0.200
    92.126     2.742     0.200
    92.126     2.449     0.200
    92.126     2.664     0.200
    92.192     2.818     0.200
    92.259     3.180     0.200
    92.259     4.450     0.200
    92.242     3.248     0.200
    92.242     2.688     0.200
    92.242     2.588     0.200
    92.406     2.633     0.200
    92.490     3.041     0.200
    92.532     3.217     0.200
    92.565     2.188     0.200
    92.565     2.378     0.200
    92.596     2.751     0.200
    92.597     3.107     0.200
    92.597     2.747     0.200
    92.597     3.546     0.200
    92.614     3.170     0.200
    92.640     2.452     0.200
    92.701     2.669     0.200
    92.756     2.699     0.200
    92.817     4.331     0.200
    92.865     2.513     0.200
    92.865     2.813     0.200
    92.873     2.427     0.200
    92.873     3.097     0.200
    92.873     3.627     0.200
    92.873     2.828     0.200
    92.873     3.877     0.200
    92.931     2.569     0.200
    92.931     3.609     0.200
    92.935     1.274     0.200
    92.935     2.697     0.200
    93.019     2.802     0.200
    93.109     4.308     0.200
    93.086     3.395     0.200
    93.148     2.831     0.200
    93.190     2.472     0.200
    93.212     1.659     0.200
    93.259     2.994     0.200
    93.278     0.807     0.200
    93.286     4.469     0.200
    93.366     4.011     0.200
    93.397     2.518     0.200
    93.432     4.710     0.200
    93.472     2.610     0.200
    93.512     2.510     0.200
    93.549     2.262     0.200
    93.563     2.797     0.200
    93.563     2.437     0.200
    93.563     2.425     0.200
    93.563     3.155     0.200
    93.706     3.738     0.200
    93.755     2.867     0.200
    93.755     4.173     0.200
    93.831     1.202     0.200
    93.835     4.209     0.200
    93.835     2.646     0.200
    93.835     2.846     0.200
    93.834     1.831     0.200
    93.834     3.291     0.200
    93.834     3.791     0.200
    93.834     2.451     0.200
    93.863     1.238     0.200
    93.902     1.313     0.200
    93.902     2.348     0.200
    93.902     0.638     0.200
    93.902     2.638     0.200
    93.963     2.803     0.200
    93.968     2.553     0.200
    93.972     1.292     0.200
    93.972     2.966     0.200
    93.972     4.076     0.200
    94.136     3.163     0.200
    94.199     1.720     0.200
    94.209     3.126     0.200
    94.360     4.233     0.200
    94.360     2.534     0.200
    94.364     2.426     0.200
    94.364     1.896     0.200
    94.364     3.117     0.200
    94.387     3.607     0.200
    94.387     5.617     0.200
    94.405     3.827     0.200
    94.418     4.066     0.200
    94.418     4.946     0.200
    94.431     4.906     0.200
    94.443     5.090     0.200
    94.553     2.448     0.200
    94.723     2.648     0.200
    94.847    -0.197     0.200
    94.946     3.347     0.200
    95.018     2.619     0.200
    95.018     4.479     0.200
    95.018     3.419     0.200
    95.108     4.209     0.200
    95.108     2.409     0.200
    95.108     3.009     0.200
    95.124     1.584     0.200
    95.124     4.057     0.200
    95.124     1.924     0.200
    95.124     3.534     0.200
    95.195     4.328     0.200
    95.231     4.143     0.200
    95.236     3.622     0.200
    95.304     4.114     0.200
    95.304     5.024     0.200
    95.275     2.972     0.200
    95.275     4.732     0.200
    95.275     3.842     0.200
    95.275     3.942     0.200
    95.275     2.542     0.200
    95.512     3.062     0.200
    95.539     3.810     0.200
    95.543     3.022     0.200
    95.539     3.340     0.200
    95.886     3.988     0.200
    95.886     3.159     0.200
    95.928     4.669     0.200
    96.032     0.896     0.200
    96.050     3.911     0.200
    96.091     3.126     0.200
    96.143     2.978     0.200
    96.143     5.179     0.200
    96.143     3.304     0.200
    96.236     4.245     0.200
    96.236     2.186     0.200
    96.236     3.126     0.200
    96.236     2.966     0.200
    96.345     3.227     0.200
    96.345     3.553     0.200
    96.345     2.173     0.200
    96.345     3.073     0.200
    96.611     3.866     0.200
    96.682     4.924     0.200
    96.694     3.798     0.200
    96.694     5.317     0.200
    96.881     4.642     0.200
    96.843     2.387     0.200
    96.843     3.512     0.200
    96.842     3.510     0.200
    97.017     1.601     0.200
    97.017     2.706     0.200
    97.030     3.168     0.200
    97.109     3.513     0.200
    97.119     3.164     0.200
    97.256     2.549     0.200
    97.367     2.746     0.200
    97.483     3.123     0.200
    97.490     3.091     0.200
    97.589     2.776     0.200
    97.603     2.782     0.200
    98.012     2.540     0.200
    98.013     2.095     0.200
    98.065     2.756     0.200
    98.082     3.035     0.200
    98.103    -0.167     0.200
    98.360     3.009     0.200
    98.624     3.153     0.200
    98.731     3.219     0.200
    98.732     2.035     0.200
    98.817     3.235     0.200
    98.846     3.004     0.200
    98.952     2.428     0.200
    14.460    11.898     0.200
    15.637     4.353     0.200
    15.791     4.447     0.200
    15.933     4.619     0.200
    15.933     7.261     0.200
    16.954     5.396     0.200
    17.012     3.214     0.200
    18.147     2.479     0.200
    18.460     1.322     0.200
    18.501     1.061     0.200
    18.795     1.431     0.200
    18.937     2.262     0.200
    19.080     2.102     0.200
    19.326     1.404     0.200
    19.572     2.102     0.200
    19.929     1.529     0.200
    20.033     1.790     0.200
    20.055     0.603     0.200
    20.401     1.233     0.200
    20.586     2.853     0.200
    20.752     1.395     0.200
    21.000     2.880     0.200
    21.376     2.643     0.200
    21.378     2.281     0.200
    21.426     3.384     0.200
    21.643     2.156     0.200
    21.643     3.585     0.200
    21.367     6.557     0.200
    21.367     7.757     0.200
    21.678     2.925     0.200
    21.832     0.145     0.200
    21.987     0.377     0.200
    21.987     0.827     0.200
    22.154     0.736     0.200
    22.154     1.356     0.200
    22.358     5.089     0.200
    22.445     0.251     0.200
    22.445     0.951     0.200
    22.500     1.583     0.200
    22.634     0.599     0.200
    23.039     0.541     0.200
    23.057     2.978     0.200
    23.387     1.572     0.200
    23.387     2.932     0.200
    23.446     0.864     0.200
    23.601     0.108     0.200
    23.721     0.891     0.200
    23.721     5.021     0.200
    24.382     0.659     0.200
    24.382     2.219     0.200
    24.413     0.696     0.200
    24.413     1.925     0.200
    24.623     0.966     0.200
    24.679     3.987     0.200
    25.336     0.545     0.200
    25.806     4.205     0.200
    25.999     3.813     0.200
    26.584     1.639     0.200
    26.620     4.233     0.200
    26.703     3.709     0.200
    26.864     4.908     0.200
    26.864     3.737     0.200
    26.930     1.561     0.200
    26.930     2.101     0.200
    27.101     3.565     0.200
    27.101     2.695     0.200
    27.101     2.395     0.200
    27.242     1.349     0.200
    27.529     3.730     0.200
    28.332     2.531     0.200
    29.925     1.920     0.200
    29.930     3.620     0.200
    30.099     4.553     0.200
    30.339     3.134     0.200
    30.393     2.329     0.200
    30.763     3.333     0.200
    31.507     2.699     0.200
    31.525     2.257     0.200
    31.986     1.748     0.200
    32.198     2.233     0.200
    32.325     1.765     0.200
    32.507     1.152     0.200
    32.530     3.066     0.200
    32.766     2.225     0.200
    32.849     0.810     0.200
    33.109     1.263     0.200
    33.265     0.858     0.200
    33.462     1.114     0.200
    33.475     2.737     0.200
    34.366     1.948     0.200
    34.845     1.369     0.200
    35.388     2.557     0.200
    35.843     1.701     0.200
    37.486     2.756     0.200
    37.821     2.654     0.200
    38.002     2.513     0.200
    38.180     1.488     0.200
    38.908     1.583     0.200
    41.181     1.698     0.200
    41.288     2.417     0.200
    43.542     2.808     0.200
    45.461     4.433     0.200
    45.461     3.308     0.200
    45.623     1.727     0.200
    46.025     4.793     0.200
    46.734     1.986     0.200
    47.090     4.211     0.200
    51.590     2.516     0.200
    51.862     3.099     0.200
    54.454     3.105     0.200
    55.659     2.533     0.200
    55.659     1.804     0.200
    56.374     2.974     0.200
    57.284     3.206     0.200
    57.546     2.245     0.200
    57.704     3.289     0.200
    60.524     3.936     0.200
    60.524     2.996     0.200
    60.534     2.415     0.200
    61.645     3.224     0.200
    63.460     3.996     0.200
    63.460     4.341     0.200
    63.786     3.335     0.200
    65.217     3.034     0.200
    65.622     2.264     0.200
    65.622     2.974     0.200
    67.326     1.503     0.200
    78.774     2.755     0.200
    80.058     2.359     0.200
    80.079     2.508     0.200
    80.404     4.033     0.200
    80.839     3.445     0.200
    80.847     3.131     0.200
    80.861     2.751     0.200
    81.141     3.418     0.200
    81.217     3.101     0.200
    81.377     3.574     0.200
    81.379     3.396     0.200
    81.385     3.232     0.200
    81.526     4.106     0.200
    81.650     3.679     0.200
    81.972     3.356     0.200
    82.929     3.026     0.200
    83.622     2.649     0.200
    83.871     3.383     0.200
    85.188     2.715     0.200
    85.217     3.317     0.200
    85.715     1.677     0.200
    85.715     1.805     0.200
    85.979     3.137     0.200
    86.210     3.335     0.200
    86.237     3.126     0.200
    86.566     3.329     0.200
    86.693     1.998     0.200
    86.702     3.025     0.200
    86.853     3.103     0.200
    91.004     1.395     0.200
    92.116     2.129     0.200
    92.116     2.449     0.200
    92.895     3.303     0.200
    92.895     2.874     0.200
    15.955     6.342     0.200
    18.436     0.961     0.200
    18.874     2.521     0.200
    19.018     1.625     0.200
    19.388     0.836     0.200
    19.398     0.809     0.200
    19.415     2.879     0.200
    19.508     1.620     0.200
    19.818     1.114     0.200
    19.876     1.122     0.200
    20.008     1.351     0.200
    19.989     0.424     0.200
    20.137     2.321     0.200
    20.336     0.965     0.200
    20.520     2.798     0.200
    20.744     3.416     0.200
    21.146     1.455     0.200
    21.314     1.717     0.200
    21.365     3.491     0.200
    21.445     0.489     0.200
    21.580     1.894     0.200
    21.580     4.133     0.200
    21.346     6.164     0.200
    21.346     7.614     0.200
    21.712     0.536     0.200
    21.803     1.445     0.200
    21.926     0.388     0.200
    21.926     1.259     0.200
    22.067     0.522     0.200
    22.072     0.530     0.200
    22.100     0.871     0.200
    22.100     1.630     0.200
    22.214     0.566     0.200
    22.276     1.081     0.200
    22.308     5.085     0.200
    22.380     0.197     0.200
    22.380     0.667     0.200
    22.484     1.246     0.200
    22.962     0.931     0.200
    22.982     0.588     0.200
    22.996     2.990     0.200
    23.322     1.548     0.200
    23.322     3.168     0.200
    23.540     0.248     0.200
    23.557     1.082     0.200
    23.636     2.846     0.200
    23.782     3.054     0.200
    23.866     2.771     0.200
    23.967     2.095     0.200
    24.002     2.075     0.200
    24.079     1.291     0.200
    24.324     1.365     0.200
    24.324     2.444     0.200
    24.352     1.233     0.200
    24.355     2.155     0.200
    24.775     1.115     0.200
    24.819     0.726     0.200
    24.923     3.105     0.200
    25.158     1.764     0.200
    25.272     1.108     0.200
    25.746     2.943     0.200
    25.746     5.302     0.200
    25.948     2.922     0.200
    26.529     1.752     0.200
    26.559     2.453     0.200
    26.559     4.673     0.200
    26.866     4.241     0.200
    26.810     5.338     0.200
    26.821     0.829     0.200
    26.864     1.035     0.200
    26.864     2.255     0.200
    27.038     2.548     0.200
    27.037     4.394     0.200
    27.038     3.888     0.200
    27.038     2.169     0.200
    27.038     2.629     0.200
    27.555     1.637     0.200
    27.662     1.224     0.200
    28.088     2.959     0.200
    28.979     1.429     0.200
    29.868     3.195     0.200
    30.042     2.945     0.200
    30.218     3.580     0.200
    30.336     1.385     0.200
    31.458     1.899     0.200
    31.974     1.817     0.200
    32.033     3.099     0.200
    32.187     2.309     0.200
    32.187     1.979     0.200
    32.755     2.530     0.200
    33.042     1.421     0.200
    33.396     2.926     0.200
    33.396     1.836     0.200
    34.284     4.156     0.200
    35.785     1.630     0.200
    36.014     1.813     0.200
    37.754     2.096     0.200
    37.754     3.077     0.200
    37.754     2.566     0.200
    39.064     1.957     0.200
    45.506     4.140     0.200
    45.506     3.756     0.200
    45.562     1.926     0.200
    45.562     1.436     0.200
    46.073     4.781     0.200
    46.669     2.264     0.200
    46.669     3.063     0.200
    47.269     1.601     0.200
    47.634     3.999     0.200
    49.197     2.855     0.200
    51.399     2.611     0.200
    53.917     3.818     0.200
    54.182     3.739     0.200
    54.394     3.158     0.200
    54.882     3.208     0.200
    55.733     3.360     0.200
    55.970     3.167     0.200
    56.270     3.143     0.200
    56.270     3.823     0.200
    56.731     3.009     0.200
    57.132     2.663     0.200
    57.223     3.421     0.200
    57.223     3.091     0.200
    57.727     3.092     0.200
    57.831     1.982     0.200
    57.831     1.712     0.200
    58.012     3.143     0.200
    58.241     3.622     0.200
    58.392     2.820     0.200
    60.317     2.382     0.200
    60.554     3.333     0.200
    60.554     2.793     0.200
    60.497     2.494     0.200
    61.670     2.969     0.200
    62.207     2.592     0.200
    63.519     4.078     0.200
    63.519     3.403     0.200
    63.830     3.266     0.200
    65.557     2.359     0.200
    68.727     2.169     0.200
    68.727     2.520     0.200
    80.002     1.977     0.200
    80.002     3.126     0.200
    80.023     2.222     0.200
    80.821     3.868     0.200
    82.919     3.271     0.200
    83.578     3.202     0.200
    83.578     3.972     0.200
    83.826     3.373     0.200
    83.857     4.156     0.200
    84.313     4.334     0.200
    85.127     2.413     0.200
    85.178     3.405     0.200
    85.650     1.956     0.200
    86.695     3.264     0.200
    86.743     3.588     0.200
    87.836     2.636     0.200
    87.839     3.217     0.200
    90.557     2.982     0.200
    90.941     1.440     0.200
    92.061     2.689     0.200
    92.882     3.522     0.200
    92.882     2.886     0.200
    93.801     2.818     0.200
    15.865     5.988     0.200
    19.163     1.417     0.200
    19.610     2.410     0.200
    21.170     5.703     0.200
    21.662     2.178     0.200
    23.437     2.166     0.200
    23.973     1.696     0.200
    24.404     3.249     0.200
    25.014     1.607     0.200
    26.911     4.100     0.200
    27.088     2.623     0.200
    27.088     2.271     0.200
    46.699     2.596     0.200
    27.338     2.273     0.200
    46.839     1.033     0.200
    14.350    12.752     0.200
    15.312     4.900     0.200
    15.694     4.513     0.200
    15.815     8.116     0.200
    15.815     8.850     0.200
    15.923     4.723     0.200
    18.269     2.631     0.200
    18.571     1.627     0.200
    18.649     1.450     0.200
    18.683     0.167     0.200
    18.770     1.583     0.200
    18.883     0.536     0.200
    19.057     1.764     0.200
    19.841     1.624     0.200
    20.924     5.756     0.200
    21.370     2.147     0.200
    21.309     7.787     0.200
    21.765     3.852     0.200
    21.851     1.705     0.200
    22.036     0.841     0.200
    22.036     0.591     0.200
    22.177     1.553     0.200
    22.227     4.605     0.200
    22.490     5.435     0.200
    22.490     3.716     0.200
    22.490     1.389     0.200
    22.512     1.495     0.200
    22.607     3.871     0.200
    22.638     1.958     0.200
    23.502     3.248     0.200
    23.630     0.044     0.200
    24.055     1.655     0.200
    24.417     2.846     0.200
    24.423     3.008     0.200
    24.463     1.875     0.200
    24.463     0.219     0.200
    24.527     2.494     0.200
    24.846     2.000     0.200
    25.469     1.558     0.200
    25.932     5.144     0.200
    26.743     4.631     0.200
    26.984     6.045     0.200
    26.995     3.461     0.200
    26.995     4.734     0.200
    27.022     2.377     0.200
    27.221     2.472     0.200
    27.221     2.793     0.200
    27.231     5.440     0.200
    28.150     1.261     0.200
    30.426     2.752     0.200
    30.426     1.158     0.200
    31.616     3.277     0.200
    31.714     2.044     0.200
    32.541     2.753     0.200
    33.555    -0.832     0.200
    34.469     4.213     0.200
    36.761     3.349     0.200
    37.923     2.537     0.200
    37.923     0.889     0.200
    37.923     2.998     0.200
    38.127     4.057     0.200
    41.212     0.958     0.200
    41.952     2.599     0.200
    44.141     3.238     0.200
    44.261     2.627     0.200
    45.330     2.457     0.200
    45.530     2.679     0.200
    45.674     1.059     0.200
    46.847     2.179     0.200
    46.847     0.944     0.200
    46.847     2.819     0.200
    47.214     3.486     0.200
    47.583     1.943     0.200
    51.466     2.562     0.200
    54.434     3.294     0.200
    54.579     3.630     0.200
    54.618     3.564     0.200
    55.237     3.270     0.200
    55.393     3.334     0.200
    55.777     3.291     0.200
    55.879     2.567     0.200
    55.918     3.127     0.200
    57.409     4.091     0.200
    57.409     1.169     0.200
    57.409     2.951     0.200
    57.586     3.871     0.200
    57.995     1.651     0.200
    59.498     2.659     0.200
    60.399     0.811     0.200
    60.503     2.371     0.200
    60.683     3.221     0.200
    61.391     2.645     0.200
    61.688     3.288     0.200
    63.333     1.511     0.200
    63.452     3.179     0.200
    65.692     2.564     0.200
    71.771     2.126     0.200
    76.003     0.189     0.200
    80.110     2.047     0.200
    80.117     4.373     0.200
    80.688     3.409     0.200
    80.759     1.282     0.200
    80.840     3.691     0.200
    80.849     1.287     0.200
    80.878     4.061     0.200
    80.284     8.706     0.200
    81.132     4.002     0.200
    81.369     4.167     0.200
    81.379     3.224     0.200
    81.963     3.720     0.200
    83.618     2.269     0.200
    83.867     1.369     0.200
    83.867     2.237     0.200
    84.040     2.307     0.200
    84.040     2.486     0.200
    85.899     2.376     0.200
    86.234     3.409     0.200
    86.261     3.918     0.200
    86.590     2.754     0.200
    86.878     2.022     0.200
    87.330     3.485     0.200
    92.142     0.550     0.200
    92.142     1.511     0.200
    92.577     2.114     0.200
    15.759     5.593     0.200
    15.759    10.649     0.200
    18.415     0.669     0.200
    18.417     3.077     0.200
    18.543     1.073     0.200
    18.543     0.123     0.200
    18.698     0.759     0.200
    18.904     1.187     0.200
    19.066     2.805     0.200
    19.287     3.267     0.200
    19.867     0.464     0.200
    19.900     1.351     0.200
    19.920     0.773     0.200
    20.387     1.004     0.200
    20.460     3.570     0.200
    20.700     2.590     0.200
    20.959     4.796     0.200
    21.163     3.382     0.200
    21.237     2.088     0.200
    21.497     2.771     0.200
    21.244     7.253     0.200
    21.244     4.993     0.200
    21.776     3.790     0.200
    21.776     2.610     0.200
    21.998     0.815     0.200
    21.998     0.415     0.200
    21.998     1.195     0.200
    22.128     1.095     0.200
    22.128     0.325     0.200
    22.370     1.635     0.200
    22.483     0.239     0.200
    22.483     0.399     0.200
    22.522     5.939     0.200
    22.522     3.640     0.200
    23.243     3.410     0.200
    23.676     3.559     0.200
    23.757     1.850     0.200
    24.003     1.372     0.200
    24.168     2.700     0.200
    24.373     1.885     0.200
    24.373     1.085     0.200
    24.425     0.915     0.200
    24.425     1.385     0.200
    24.796     1.660     0.200
    25.371     1.449     0.200
    25.670     1.430     0.200
    25.947     4.786     0.200
    25.947     3.686     0.200
    26.161     3.210     0.200
    26.566     1.904     0.200
    26.751     2.557     0.200
    26.755     4.368     0.200
    26.755     2.138     0.200
    26.827     2.757     0.200
    26.881     2.890     0.200
    27.005     2.068     0.200
    27.005     1.418     0.200
    27.021     5.298     0.200
    27.021     3.953     0.200
    27.227     6.623     0.200
    27.228     2.938     0.200
    27.228     3.518     0.200
    27.228     2.408     0.200
    27.236     2.096     0.200
    27.336     3.131     0.200
    27.361     3.572     0.200
    27.361     1.672     0.200
    27.359     3.053     0.200
    27.388     2.504     0.200
    27.502     4.085     0.200
    27.502     4.865     0.200
    27.533     0.593     0.200
    27.660     3.945     0.200
    27.660     2.345     0.200
    28.017     2.642     0.200
    28.281     2.461     0.200
    29.372     2.879     0.200
    29.422     4.478     0.200
    29.422     2.028     0.200
    29.463     4.574     0.200
    30.259     1.023     0.200
    30.249     2.699     0.200
    30.381     0.742     0.200
    31.600     2.128     0.200
    31.650     2.094     0.200
    31.939     2.862     0.200
    32.197     2.466     0.200
    32.496     3.070     0.200
    32.496     1.300     0.200
    33.124     2.435     0.200
    33.178     1.423     0.200
    33.627     2.259     0.200
    34.482     4.280     0.200
    34.482     2.850     0.200
    36.171     3.211     0.200
    37.915     2.664     0.200
    37.915     2.134     0.200
    38.143     4.133     0.200
    38.143     2.983     0.200
    41.909     4.273     0.200
    43.367     1.977     0.200
    43.367     2.697     0.200
    45.291     4.290     0.200
    45.291     3.170     0.200
    45.291     3.670     0.200
    45.329     6.238     0.200
    45.636     2.121     0.200
    45.636     1.730     0.200
    45.858     5.546     0.200
    45.858     3.007     0.200
    46.391     4.761     0.200
    46.847     1.255     0.200
    46.915     2.350     0.200
    47.043     5.275     0.200
    47.380     5.996     0.200
    47.854     4.805     0.200
    47.891     5.259     0.200
    48.610     5.356     0.200
    48.986     1.837     0.200
    48.986     2.797     0.200
    49.656     2.432     0.200
    50.123     2.151     0.200
    50.193     5.213     0.200
    50.999     5.213     0.200
    51.415     1.766     0.200
    51.415     1.876     0.200
    51.600     2.903     0.200
    52.188     5.416     0.200
    52.860     5.455     0.200
    53.552     4.883     0.200
    54.242     2.756     0.200
    54.377     1.617     0.200
    54.377     2.007     0.200
    54.593     3.506     0.200
    54.973     4.394     0.200
    54.973     2.754     0.200
    54.994     5.647     0.200
    55.025     2.459     0.200
    55.086     3.028     0.200
    55.457     2.636     0.200
    55.783     3.156     0.200
    55.783     2.135     0.200
    55.828     4.471     0.200
    55.895     2.924     0.200
    55.932     2.699     0.200
    56.124     2.377     0.200
    56.251     1.981     0.200
    56.623     2.794     0.200
    56.626     3.139     0.200
    56.919     2.710     0.200
    56.919     2.070     0.200
    56.919     2.830     0.200
    57.245     2.569     0.200
    57.250     2.209     0.200
    57.438     3.553     0.200
    57.423     2.581     0.200
    57.423     2.891     0.200
    57.531     1.991     0.200
    57.531     1.791     0.200
    57.812     2.926     0.200
    57.825     2.975     0.200
    57.881     3.622     0.200
    58.207     2.477     0.200
    58.205     4.254     0.200
    58.594     2.640     0.200
    58.739     3.616     0.200
    58.739     2.856     0.200
    58.933     3.033     0.200
    58.959     2.574     0.200
    59.436     2.480     0.200
    59.461     2.730     0.200
    59.461     2.310     0.200
    59.461     3.171     0.200
    59.563     4.162     0.200
    60.348     3.495     0.200
    60.348     2.505     0.200
    60.570     2.438     0.200
    61.470     2.382     0.200
    61.470     3.062     0.200
    62.065     2.297     0.200
    62.144     2.710     0.200
    62.144     3.540     0.200
    62.275     1.725     0.200
    62.478     3.386     0.200
    62.750     3.154     0.200
    63.316     3.823     0.200
    63.316     3.398     0.200
    63.316     3.173     0.200
    63.316     3.643     0.200
    63.615     2.757     0.200
    63.615     2.557     0.200
    63.615     2.887     0.200
    64.027     3.997     0.200
    64.484     3.637     0.200
    64.937     4.334     0.200
    65.474     3.358     0.200
    65.474     3.068     0.200
    65.663     1.852     0.200
    66.933     3.321     0.200
    67.458     2.724     0.200
    67.739     2.287     0.200
    71.745     1.957     0.200
    72.501     2.425     0.200
    75.998     3.895     0.200
    80.043     3.624     0.200
    80.065     1.505     0.200
    80.065     1.940     0.200
    81.827     3.046     0.200
    83.562     1.768     0.200
    83.811     3.092     0.200
    83.811     2.772     0.200
    84.070     3.319     0.200
    84.158     4.122     0.200
    84.657     3.483     0.200
    85.138     2.840     0.200
    85.138     2.678     0.200
    85.788     3.540     0.200
    85.742     6.369     0.200
    85.904     2.436     0.200
    85.904     3.138     0.200
    85.904     2.228     0.200
    86.185     3.907     0.200
    86.212     2.614     0.200
    86.653     2.300     0.200
    86.727     2.908     0.200
    86.761     2.860     0.200
    87.065     3.170     0.200
    87.281     2.590     0.200
    87.281     3.090     0.200
    87.485     3.498     0.200
    87.741     1.259     0.200
    87.874     5.448     0.200
    87.874     6.519     0.200
    88.417     3.319     0.200
    88.461     1.321     0.200
    88.828     3.022     0.200
    88.834     2.463     0.200
    88.868     2.692     0.200
    89.396     3.043     0.200
    89.558     2.815     0.200
    89.463     2.761     0.200
    89.467     2.752     0.200
    89.534     3.567     0.200
    89.792     3.171     0.200
    90.088     2.230     0.200
    90.288     3.128     0.200
    90.360     3.744     0.200
    90.486     3.453     0.200
    90.518     3.148     0.200
    90.518     3.325     0.200
    90.533     2.565     0.200
    90.533     1.945     0.200
    90.576     2.725     0.200
    90.646     2.582     0.200
    90.799     1.951     0.200
    90.970     2.757     0.200
    91.043     3.406     0.200
    91.043     2.626     0.200
    91.155     2.596     0.200
    91.240     3.186     0.200
    91.360     2.396     0.200
    91.476     3.460     0.200
    91.532     2.790     0.200
    91.887     3.114     0.200
    91.924     3.514     0.200
    92.025     3.267     0.200
    92.095     2.771     0.200
    92.157     1.944     0.200
    92.370     2.293     0.200
    92.527     2.787     0.200
    92.588     2.927     0.200
    92.606     2.478     0.200
    92.675     2.805     0.200
    92.839     3.361     0.200
    93.233     2.843     0.200
    93.808     3.344     0.200
    93.929     2.253     0.200
    93.963     3.218     0.200
    93.963     1.973     0.200
    96.665     4.126     0.200
    96.685     2.856     0.200
    97.032     4.785     0.200
    98.333     2.469     0.200
    27.283     2.730     0.200
    27.354     5.311     0.200
    27.076     2.637     0.200
    27.140     3.986     0.200
    46.589     1.270     0.200
    57.354     2.701     0.200
    15.666     5.340     0.200
    16.093     5.423     0.200
    16.351     3.932     0.200
    17.059     3.920     0.200
    17.173     4.128     0.200
    18.153     4.488     0.200
    18.588     1.623     0.200
    18.647     1.451     0.200
    18.640     1.483     0.200
    18.753    -1.319     0.200
    18.781     1.190     0.200
    18.896     0.980     0.200
    18.858     1.338     0.200
    18.858     2.240     0.200
    18.858     2.881     0.200
    18.858     2.740     0.200
    19.136     0.882     0.200
    19.591     0.987     0.200
    19.935     1.189     0.200
    20.676     0.703     0.200
    20.834     0.686     0.200
    20.957     0.588     0.200
    21.311     1.490     0.200
    21.551     2.037     0.200
    21.566     0.919     0.200
    21.559     4.211     0.200
    21.604     1.976     0.200
    21.911     1.082     0.200
    22.028     1.433     0.200
    22.028     0.542     0.200
    22.227     1.373     0.200
    22.387     0.986     0.200
    22.462     1.108     0.200
    22.683    -0.388     0.200
    22.803     0.164     0.200
    23.323     2.516     0.200
    23.654     1.158     0.200
    23.600     3.313     0.200
    24.189     1.584     0.200
    24.209     3.236     0.200
    24.319     3.030     0.200
    24.440     2.701     0.200
    24.453     2.742     0.200
    24.453     1.254     0.200
    25.109     3.813     0.200
    25.251     1.049     0.200
    25.722     3.520     0.200
    26.294     1.437     0.200
    26.534     4.678     0.200
    26.748     2.805     0.200
    26.748     3.641     0.200
    26.927     0.752     0.200
    26.935     0.558     0.200
    26.911     2.604     0.200
    27.025     1.984     0.200
    29.627     2.974     0.200
    30.454     1.185     0.200
    30.366     3.478     0.200
    31.505     3.322     0.200
    32.723     3.529     0.200
    33.441     0.915     0.200
    34.221     3.521     0.200
    37.711     1.584     0.200
    37.781     2.585     0.200
    37.781     1.585     0.200
    37.909     4.044     0.200
    43.939     2.907     0.200
    45.599     3.490     0.200
    45.662     1.221     0.200
    46.675     1.438     0.200
    47.459     1.743     0.200
    50.316     3.554     0.200
    51.562     1.869     0.200
    51.807     2.749     0.200
    52.846     0.594     0.200
    54.363     2.977     0.200
    55.235     3.157     0.200
    55.586     3.467     0.200
    55.870     3.384     0.200
    57.193     3.614     0.200
    57.193     3.485     0.200
    57.406     3.249     0.200
    57.594     3.676     0.200
    57.991     2.847     0.200
    58.338     3.107     0.200
    58.459     2.597     0.200
    58.589     0.822     0.200
    59.336     2.800     0.200
    62.177     2.715     0.200
    64.321     3.631     0.200
    65.635     3.280     0.200
    65.635     2.960     0.200
    71.700     2.369     0.200
    71.700     2.208     0.200
    83.787     3.448     0.200
    85.332     1.928     0.200
    85.710     2.747     0.200
    91.034     1.389     0.200
    26.635     2.550     0.200
    46.362    -0.250     0.200
    56.979     1.160     0.200
    15.941     3.984     0.200
    16.501     3.484     0.200
    16.913     3.595     0.200
    16.973     2.601     0.200
    17.508     3.548     0.200
    17.901     4.271     0.200
    17.913     2.347     0.200
    18.006     2.940     0.200
    18.038     4.160     0.200
    18.211     3.525     0.200
    18.345     2.986     0.200
    19.333     1.276     0.200
    19.501     1.262     0.200
    19.937     0.403     0.200
    20.080     2.226     0.200
    20.158     0.760     0.200
    20.698     2.231     0.200
    20.863     1.493     0.200
    20.951     1.649     0.200
    20.970     2.354     0.200
    21.199     3.138     0.200
    21.298     1.611     0.200
    21.397     2.555     0.200
    21.561     2.386     0.200
    21.763     0.412     0.200
    21.987     1.920     0.200
    22.133     1.663     0.200
    22.224     0.628     0.200
    22.435     3.453     0.200
    22.799     1.803     0.200
    22.831     2.161     0.200
    23.356     3.003     0.200
    23.391     2.312     0.200
    23.881     2.482     0.200
    24.983     2.202     0.200
    25.699     2.576     0.200
    26.311     3.061     0.200
    26.366     1.402     0.200
    26.376     1.924     0.200
    26.666     1.566     0.200
    26.671     1.988     0.200
    26.852     3.612     0.200
    26.852     3.395     0.200
    27.919     3.621     0.200
    28.850     2.550     0.200
    37.564     2.330     0.200
    46.480     0.961     0.200
    57.043     2.030     0.200
    59.503     3.252     0.200
    61.157     2.545     0.200
    67.313     1.346     0.200
    15.220     5.038     0.200
    15.256     4.502     0.200
    15.596     4.172     0.200
    15.702     4.247     0.200
    15.933     4.982     0.200
    16.079     4.625     0.200
    16.079     3.156     0.200
    16.149     4.473     0.200
    16.160     4.764     0.200
    16.218     3.695     0.200
    16.682     4.176     0.200
    16.724     4.017     0.200
    17.751     2.956     0.200
    17.982     2.486     0.200
    18.166     2.391     0.200
    18.176     3.359     0.200
    18.464     2.033     0.200
    18.518     1.334     0.200
    18.641     2.735     0.200
    18.869     2.091     0.200
    18.869     1.341     0.200
    18.901     0.989     0.200
    18.985     2.281     0.200
    19.247     2.453     0.200
    19.497     2.396     0.200
    19.595     1.830     0.200
    19.615     2.110     0.200
    19.935     1.552     0.200
    20.065     2.134     0.200
    20.082     2.950     0.200
    20.199     1.434     0.200
    20.679     1.120     0.200
    20.966     0.598     0.200
    21.022     0.594     0.200
    21.114     2.418     0.200
    21.569     0.568     0.200
    21.828     0.626     0.200
    22.030     0.761     0.200
    22.190     0.330     0.200
    22.254     0.516     0.200
    22.308    -0.012     0.200
    22.976     2.014     0.200
    23.004     2.793     0.200
    23.613     2.868     0.200
    23.966     0.969     0.200
    24.187     1.397     0.200
    24.330     2.690     0.200
    24.455     0.823     0.200
    24.576     2.890     0.200
    25.121     2.829     0.200
    25.251     1.598     0.200
    26.485     1.227     0.200
    26.633     1.498     0.200
    26.761     5.652     0.200
    26.761     3.707     0.200
    26.918     1.604     0.200
    26.937     1.208     0.200
    27.036     2.681     0.200
    27.036     2.829     0.200
    33.137     1.384     0.200
    33.308     0.647     0.200
    33.448    -0.406     0.200
    37.789     1.841     0.200
    43.950     1.810     0.200
    45.584     1.681     0.200
    45.664     1.340     0.200
    46.684    -0.068     0.200
    46.684     2.104     0.200
    47.466     1.067     0.200
    54.375     2.142     0.200
    57.205     3.561     0.200
    57.205     1.890     0.200
    58.144     1.857     0.200
    58.737     3.368     0.200
    58.759     3.263     0.200
    58.785     3.263     0.200
    60.141     2.323     0.200
    60.297     2.033     0.200
    60.783     1.935     0.200
    80.142     0.911     0.200
    83.967     1.487     0.200
    91.037     1.147     0.200
    92.184     1.437     0.200
    15.536     4.907     0.200
    15.533     4.958     0.200
    16.138     4.545     0.200
    16.354     3.535     0.200
    16.381     3.442     0.200
    16.977     2.859     0.200
    17.008     3.872     0.200
    17.431     3.225     0.200
    17.447     2.815     0.200
    17.463     3.192     0.200
    17.673     2.438     0.200
    18.516     1.533     0.200
    18.534     1.488     0.200
    18.541     0.915     0.200
    18.900     2.055     0.200
    18.966     1.684     0.200
    19.074     2.448     0.200
    19.102     2.129     0.200
    19.195     2.333     0.200
    19.355     2.080     0.200
    19.571     1.334     0.200
    19.597     1.198     0.200
    19.853     2.026     0.200
    19.857     1.432     0.200
    20.044     2.928     0.200
    20.112     2.232     0.200
    20.203     2.262     0.200
    20.300     1.229     0.200
    20.442     0.726     0.200
    20.527     2.658     0.200
    20.879     0.843     0.200
    20.909     1.548     0.200
    21.343     2.879     0.200
    21.504     2.930     0.200
    21.549     1.837     0.200
    21.719     3.444     0.200
    21.905     2.389     0.200
    21.920     2.450     0.200
    21.955     1.169     0.200
    22.107     2.371     0.200
    22.141     2.803     0.200
    22.166     3.602     0.200
    22.208     3.285     0.200
    22.327     2.887     0.200
    22.402     3.337     0.200
    22.445     3.153     0.200
    22.450     2.394     0.200
    22.589     2.771     0.200
    22.584     1.163     0.200
    22.672     2.656     0.200
    22.707     2.587     0.200
    22.775     1.841     0.200
    22.990     0.957     0.200
    24.038     2.021     0.200
    24.041     1.694     0.200
    25.132     1.721     0.200
    26.145     1.328     0.200
    26.486     1.699     0.200
    26.815     1.916     0.200
    27.193     4.677     0.200
    27.193     3.810     0.200
    27.346     1.999     0.200
    27.346     2.648     0.200
    45.094     4.199     0.200
    45.094     3.847     0.200
    45.594     0.835     0.200
    45.594     1.530     0.200
    46.942     1.535     0.200
    46.942     2.332     0.200
    50.933     3.048     0.200
    54.731     2.790     0.200
    55.896     2.099     0.200
    57.561     2.548     0.200
    57.561     2.071     0.200
    58.150     2.613     0.200
    60.128     3.096     0.200
    60.128     2.964     0.200
    76.159     2.577     0.200
    14.540     4.957     0.200
    14.816     4.865     0.200
    14.971     4.627     0.200
    15.044     3.616     0.200
    15.100     3.944     0.200
    15.299     4.597     0.200
    15.475     3.330     0.200
    15.874     3.223     0.200
    16.083     1.672     0.200
    16.233     3.260     0.200
    16.440     1.673     0.200
    16.590     2.532     0.200
    16.671     1.857     0.200
    16.791     3.930     0.200
    16.896     1.897     0.200
    17.053     1.212     0.200
    17.317     2.259     0.200
    17.349     0.944     0.200
    17.490     0.461     0.200
    17.533     0.845     0.200
    17.533    -0.095     0.200
    17.693     1.293     0.200
    17.711     0.673     0.200
    17.769     1.973     0.200
    17.791     3.361     0.200
    17.859     1.836     0.200
    17.898     5.051     0.200
    17.898     3.021     0.200
    17.898     5.431     0.200
    18.138     1.930     0.200
    18.172     2.004     0.200
    18.263     1.474     0.200
    18.263     0.974     0.200
    18.367     1.980     0.200
    18.384     0.947     0.200
    18.433     1.326     0.200
    18.501     1.708     0.200
    18.515     1.033     0.200
    18.584     2.482     0.200
    18.585     4.194     0.200
    18.585     3.706     0.200
    18.585     2.864     0.200
    18.637     1.673     0.200
    18.681     3.195     0.200
    18.716     1.345     0.200
    18.762     0.974     0.200
    18.801     1.296     0.200
    18.871     1.186     0.200
    18.975     1.024     0.200
    19.224     2.477     0.200
    19.329     1.699     0.200
    19.346     1.339     0.200
    19.348     1.095     0.200
    19.397     3.790     0.200
    19.474     1.310     0.200
    19.679     0.704     0.200
    19.694     1.317     0.200
    19.823     1.921     0.200
    19.851     0.545     0.200
    19.922     1.343     0.200
    19.949     0.797     0.200
    19.944     3.563     0.200
    20.163     0.723     0.200
    20.433     0.477     0.200
    20.742     0.446     0.200
    20.767     1.687     0.200
    20.825     1.041     0.200
    20.840     3.798     0.200
    21.004     2.951     0.200
    21.035     2.462     0.200
    21.074     0.402     0.200
    21.060     3.748     0.200
    21.206     0.676     0.200
    21.287     3.855     0.200
    21.287     1.885     0.200
    21.325     0.957     0.200
    21.329     3.120     0.200
    21.433     3.158     0.200
    21.493     3.802     0.200
    21.491     2.759     0.200
    21.622    -0.066     0.200
    21.624     3.662     0.200
    21.731     3.662     0.200
    21.479     6.745     0.200
    21.479     5.485     0.200
    21.802    -0.106     0.200
    21.997     0.590     0.200
    21.994     4.939     0.200
    21.994     3.019     0.200
    21.994     3.591     0.200
    22.039     0.936     0.200
    22.061     1.460     0.200
    22.135     1.155     0.200
    22.162     2.830     0.200
    22.214     1.007     0.200
    22.214     0.247     0.200
    22.283     0.195     0.200
    22.329     3.591     0.200
    22.465     0.433     0.200
    22.565     0.755     0.200
    22.696     2.659     0.200
    22.882     3.372     0.200
    22.912     2.882     0.200
    22.957     0.621     0.200
    23.046     2.646     0.200
    23.046     2.516     0.200
    23.146     2.489     0.200
    23.330     3.856     0.200
    23.356     1.124     0.200
    23.455     0.359     0.200
    23.554     2.804     0.200
    23.670     2.337     0.200
    23.721     2.515     0.200
    23.789     2.516     0.200
    23.858     2.645     0.200
    23.869     3.746     0.200
    23.888     2.847     0.200
    23.919     0.718     0.200
    23.933     0.716     0.200
    23.927     3.691     0.200
    23.941     3.017     0.200
    23.961     2.064     0.200
    23.962     3.130     0.200
    23.966     1.700     0.200
    24.047     2.750     0.200
    24.073     2.580     0.200
    24.169     2.680     0.200
    24.209     1.194     0.200
    24.211     2.805     0.200
    24.227     1.133     0.200
    24.234     1.879     0.200
    24.234     0.969     0.200
    24.392     3.749     0.200
    24.844     2.331     0.200
    25.038     1.805     0.200
    25.037     3.226     0.200
    25.058     2.283     0.200
    25.421     1.454     0.200
    25.445     4.428     0.200
    25.634     3.950     0.200
    25.671     3.849     0.200
    25.923     1.213     0.200
    25.976     3.052     0.200
    26.079     0.663     0.200
    26.234     0.957     0.200
    26.263     3.979     0.200
    26.263     2.559     0.200
    26.368     1.117     0.200
    26.402     0.537     0.200
    26.423     4.130     0.200
    26.455     1.236     0.200
    26.487     5.712     0.200
    26.498     4.483     0.200
    26.498     3.672     0.200
    26.642     2.034     0.200
    26.642     1.144     0.200
    26.751     2.751     0.200
    26.858     3.646     0.200
    27.174     3.186     0.200
    27.815     0.945     0.200
    28.903     2.262     0.200
    29.707     2.712     0.200
    31.236     1.897     0.200
    31.768     2.880     0.200
    33.171     0.783     0.200
    33.171     1.239     0.200
    33.959     3.485     0.200
    36.940     3.164     0.200
    37.435     1.940     0.200
    37.506     2.356     0.200
    37.506     1.786     0.200
    37.506     2.976     0.200
    45.434     1.066     0.200
    46.398     1.496     0.200
    46.398     2.286     0.200
    46.920     4.411     0.200
    47.948     4.512     0.200
    50.720     4.749     0.200
    51.312     1.950     0.200
    51.913     1.782     0.200
    52.717     5.011     0.200
    53.410     1.545     0.200
    55.311     2.840     0.200
    55.311     2.000     0.200
    55.311     3.510     0.200
    55.434     3.160     0.200
    55.493     3.861     0.200
    56.260     2.137     0.200
    56.366     2.762     0.200
    56.924     4.197     0.200
    56.924     2.826     0.200
    56.924     1.367     0.200
    56.981     1.292     0.200
    57.326     3.521     0.200
    57.440     2.235     0.200
    57.500     3.141     0.200
    57.595     1.852     0.200
    57.595     1.566     0.200
    58.004     3.064     0.200
    58.457     2.358     0.200
    59.355     2.034     0.200
    59.446     2.715     0.200
    59.988     2.497     0.200
    59.988     1.777     0.200
    60.502     2.393     0.200
    61.047     2.742     0.200
    61.204     3.268     0.200
    61.944     3.281     0.200
    63.823     3.523     0.200
    63.823     2.346     0.200
    63.823     3.183     0.200
    65.234     2.279     0.200
    65.384     2.987     0.200
    66.002     2.815     0.200
    71.443     1.595     0.200
    71.443     2.055     0.200
    75.517     2.455     0.200
    78.508     1.910     0.200
    79.940     2.925     0.200
    83.827     2.965     0.200
    83.827     3.712     0.200
    84.649     3.620     0.200
    85.002     2.330     0.200
    85.434     2.337     0.200
    85.476     1.861     0.200
    85.476     2.320     0.200
    86.117     1.073     0.200
    86.416     3.105     0.200
    87.786     1.887     0.200
    88.314     2.364     0.200
    88.744     3.035     0.200
    89.481     2.707     0.200
    90.507     2.388     0.200
    90.656     3.999     0.200
    91.989     1.932     0.200
    95.384     3.991     0.200
    96.545     3.607     0.200
    98.993     2.574     0.200
    54.094     3.273     0.200
    60.017     1.759     0.200
    21.994     2.311     0.200
    85.215     3.558     0.200
    19.437     0.627     0.200
    14.861     5.234     0.200
    15.434     5.654     0.200
    15.434     5.041     0.200
    15.434     4.845     0.200
    15.434     3.443     0.200
    15.589     6.964     0.200
    15.871     2.645     0.200
    15.992     3.423     0.200
    16.280     4.881     0.200
    16.303     7.371     0.200
    16.303     7.109     0.200
    17.648     3.539     0.200
    18.103     2.424     0.200
    18.103     1.041     0.200
    18.092     5.064     0.200
    18.665     1.210     0.200
    18.729     4.865     0.200
    18.729     2.428     0.200
    19.339     3.897     0.200
    19.339     4.065     0.200
    19.339     2.037     0.200
    19.960     1.030     0.200
    19.993     0.742     0.200
    20.000     1.962     0.200
    20.102     1.980     0.200
    20.210     2.572     0.200
    20.204     2.587     0.200
    20.225     1.815     0.200
    20.225     1.342     0.200
    20.281     2.001     0.200
    20.299     1.074     0.200
    20.324     1.034     0.200
    20.435     1.257     0.200
    20.477     1.705     0.200
    20.493     4.160     0.200
    20.997     3.050     0.200
    21.786     0.891     0.200
    22.056     3.791     0.200
    22.061     0.773     0.200
    22.061     0.441     0.200
    22.061     0.265     0.200
    22.121     1.191     0.200
    22.121     0.921     0.200
    22.348     3.859     0.200
    22.595     0.687     0.200
    22.595     0.472     0.200
    22.729     2.563     0.200
    22.848     4.946     0.200
    22.848     4.735     0.200
    22.848     3.958     0.200
    22.848     4.194     0.200
    22.925     2.671     0.200
    23.367     4.052     0.200
    23.367     2.400     0.200
    23.604     1.508     0.200
    23.756     4.035     0.200
    23.965     2.334     0.200
    23.950     5.015     0.200
    24.390     2.964     0.200
    24.398     1.920     0.200
    24.489     1.654     0.200
    24.489     1.517     0.200
    24.489     0.896     0.200
    25.152     4.956     0.200
    25.420     1.191     0.200
    25.817     1.815     0.200
    26.240     4.612     0.200
    26.215     5.816     0.200
    26.364     2.695     0.200
    26.318     3.851     0.200
    26.399     5.652     0.200
    26.932     4.511     0.200
    26.932     3.640     0.200
    26.897    -0.645     0.200
    27.038     3.889     0.200
    27.184     2.069     0.200
    27.184     1.811     0.200
    27.142     6.255     0.200
    27.123     5.328     0.200
    27.328     3.986     0.200
    27.339     5.052     0.200
    27.339     4.138     0.200
    27.345     3.627     0.200
    27.496     2.370     0.200
    27.497     2.367     0.200
    27.497     3.671     0.200
    27.497     3.445     0.200
    27.735     3.725     0.200
    27.735     3.600     0.200
    27.735     2.987     0.200
    27.735     2.338     0.200
    27.676     4.155     0.200
    27.817     3.577     0.200
    28.205     4.139     0.200
    29.005     1.657     0.200
    29.118     4.756     0.200
    29.118     4.026     0.200
    29.118     3.717     0.200
    30.399     3.005     0.200
    30.399     2.306     0.200
    30.399     2.423     0.200
    30.555     4.134     0.200
    30.555     3.584     0.200
    30.680     4.129     0.200
    31.819     2.486     0.200
    31.819     2.193     0.200
    31.819     1.846     0.200
    31.875     3.199     0.200
    31.944     3.122     0.200
    32.488     3.356     0.200
    32.914     0.546     0.200
    33.720     1.409     0.200
    33.720     1.011     0.200
    34.766     3.836     0.200
    34.766     3.637     0.200
    35.170     1.422     0.200
    35.170     2.297     0.200
    35.154     2.916     0.200
    35.296     1.959     0.200
    35.571     1.898     0.200
    36.536     3.861     0.200
    38.127     2.477     0.200
    38.127     2.277     0.200
    38.127     2.008     0.200
    38.127     1.637     0.200
    38.434     3.435     0.200
    40.803     3.958     0.200
    40.803     2.509     0.200
    41.941     1.943     0.200
    42.792     1.977     0.200
    44.958     3.958     0.200
    44.958     3.493     0.200
    44.958     2.821     0.200
    45.700     1.819     0.200
    45.700     1.644     0.200
    47.061     1.539     0.200
    47.090     1.054     0.200
    47.090     2.199     0.200
    47.090     1.706     0.200
    47.156     0.943     0.200
    48.650     3.607     0.200
    49.321     2.490     0.200
    50.831     4.121     0.200
    51.861     6.026     0.200
    54.692     3.268     0.200
    55.434     2.396     0.200
    55.740     2.529     0.200
    56.046     2.566     0.200
    56.046     1.691     0.200
    56.583     2.273     0.200
    56.922     3.453     0.200
    57.205     3.109     0.200
    57.205     2.390     0.200
    57.699     2.166     0.200
    57.711     2.181     0.200
    57.711     1.943     0.200
    57.711     2.603     0.200
    57.917     2.235     0.200
    58.113     2.556     0.200
    58.113     1.638     0.200
    58.173     3.159     0.200
    58.668     3.433     0.200
    59.128     2.980     0.200
    59.128     2.866     0.200
    59.426     3.304     0.200
    60.402     2.188     0.200
    60.667     1.915     0.200
    60.721     2.943     0.200
    61.011     2.755     0.200
    62.418     2.031     0.200
    63.021     2.964     0.200
    63.021     2.628     0.200
    65.441     3.081     0.200
    65.779     2.494     0.200
    67.580     1.407     0.200
    67.580     1.290     0.200
    68.883     2.483     0.200
    69.270     2.077     0.200
    69.560     1.995     0.200
    71.877     1.542     0.200
    71.877     0.812     0.200
    74.843     4.581     0.200
    75.095     2.060     0.200
    75.512     1.715     0.200
    76.288     3.505     0.200
    76.288     3.033     0.200
    77.855     3.823     0.200
    77.855     1.346     0.200
    77.855     2.811     0.200
    78.981     2.148     0.200
    78.981     1.698     0.200
    79.920     1.500     0.200
    80.053     2.778     0.200
    80.053     2.219     0.200
    80.075     2.718     0.200
    80.260     3.831     0.200
    80.473     3.076     0.200
    80.554     3.161     0.200
    80.617     4.114     0.200
    80.660     3.090     0.200
    80.660     5.141     0.200
    80.673     3.012     0.200
    80.691     3.128     0.200
    80.695     2.555     0.200
    80.729     4.252     0.200
    80.787     3.136     0.200
    80.792     1.539     0.200
    80.888     1.902     0.200
    80.136     5.350     0.200
    80.984     1.100     0.200
    80.992     3.110     0.200
    80.992     2.669     0.200
    81.136     1.451     0.200
    81.181     1.200     0.200
    81.224     0.670     0.200
    83.374     2.228     0.200
    83.481     3.107     0.200
    83.481     2.380     0.200
    83.731     3.036     0.200
    83.731     2.606     0.200
    83.878     3.341     0.200
    84.392     3.498     0.200
    84.392     3.045     0.200
    85.121     2.551     0.200
    85.255     3.181     0.200
    85.255     3.306     0.200
    85.839     2.641     0.200
    85.873     2.656     0.200
    85.873     2.183     0.200
    86.164     1.562     0.200
    86.175     2.710     0.200
    86.203     1.934     0.200
    86.532     1.713     0.200
    86.734     4.062     0.200
    86.825     1.600     0.200
    87.270     2.307     0.200
    90.542     3.118     0.200
    90.550     2.652     0.200
    91.108     1.576     0.200
    91.108     1.463     0.200
    91.886     3.641     0.200
    91.886     3.981     0.200
    92.092     2.003     0.200
    92.624     3.191     0.200
    92.624     1.602     0.200
    92.624     2.473     0.200
    92.624     3.070     0.200
    93.526     2.119     0.200
    93.818     2.510     0.200
    93.818     4.768     0.200
    94.177     2.019     0.200
    94.390     4.566     0.200
    95.215     4.682     0.200
    99.476     1.534     0.200
    20.676     4.274     0.200
    54.882     3.139     0.200
    58.485     2.661     0.200
    19.844     5.519     0.200
    22.848     3.397     0.200
    85.020     2.747     0.200
    85.021     2.624     0.200
    26.452     6.969     0.200
    20.327     5.662     0.200
    21.975     0.485     0.200
    15.784     3.705     0.200
    16.280     4.498     0.200
    16.548     5.599     0.200
    17.612     1.904     0.200
    18.204     5.116     0.200
    18.729     4.139     0.200
    19.192     3.957     0.200
    19.602     2.282     0.200
    19.738     2.792     0.200
    20.225     2.201     0.200
    20.501     5.580     0.200
    20.520     4.544     0.200
    20.545     2.967     0.200
    20.997     2.933     0.200
    21.604     3.557     0.200
    21.684     2.553     0.200
    22.101     4.168     0.200
    22.633     3.140     0.200
    22.780     2.778     0.200
    22.824     2.186     0.200
    23.214     5.619     0.200
    23.367     3.201     0.200
    23.669     2.186     0.200
    26.932     3.800     0.200
    27.213     4.795     0.200
    14.836     3.663     0.200
    15.257     6.424     0.200
    15.534     3.571     0.200
    15.695     4.240     0.200
    15.997     3.342     0.200
    15.997     4.034     0.200
    16.071     4.878     0.200
    17.085     2.048     0.200
    17.274     4.276     0.200
    18.183     3.987     0.200
    18.183     4.315     0.200
    18.536     0.893     0.200
    18.730     3.561     0.200
    18.888     4.180     0.200
    18.888     3.555     0.200
    19.334     7.766     0.200
    19.861     5.986     0.200
    19.899     2.881     0.200
    19.924     7.127     0.200
    20.168     2.253     0.200
    20.216     1.237     0.200
    20.213     1.065     0.200
    20.409     1.383     0.200
    20.435     0.866     0.200
    20.497     0.709     0.200
    20.583     1.507     0.200
    20.552     2.688     0.200
    20.696     0.810     0.200
    20.845     1.992     0.200
    20.857    -0.009     0.200
    21.588     2.777     0.200
    21.589     3.845     0.200
    21.505     6.829     0.200
    21.505     6.067     0.200
    21.752     4.664     0.200
    22.046     0.323     0.200
    22.046     0.210     0.200
    22.239     0.749     0.200
    22.261     4.466     0.200
    22.261     3.606     0.200
    22.483     0.588     0.200
    22.483     0.689     0.200
    22.871     3.634     0.200
    23.352     2.450     0.200
    23.673     0.942     0.200
    24.455     2.081     0.200
    24.471     1.076     0.200
    24.471     1.389     0.200
    26.309     3.708     0.200
    26.645     4.325     0.200
    26.778     3.888     0.200
    26.778     4.517     0.200
    26.936     1.859     0.200
    27.055     3.156     0.200
    26.952     5.935     0.200
    26.952     5.165     0.200
    27.125     5.546     0.200
    27.372     3.144     0.200
    27.372     3.015     0.200
    27.444     2.777     0.200
    27.887     5.270     0.200
    29.264     4.052     0.200
    29.733     4.951     0.200
    30.024     3.940     0.200
    30.469     2.402     0.200
    30.469     1.871     0.200
    31.780     0.583     0.200
    33.467     1.361     0.200
    35.275     2.471     0.200
    37.808     2.389     0.200
    37.808     2.120     0.200
    37.939     3.647     0.200
    41.170     1.818     0.200
    41.430     3.288     0.200
    41.983     2.100     0.200
    42.059     1.885     0.200
    43.958     3.086     0.200
    44.065     3.521     0.200
    44.650     6.770     0.200
    45.334     3.142     0.200
    45.681     1.776     0.200
    45.570     4.832     0.200
    45.570     3.719     0.200
    45.570     4.574     0.200
    46.703     1.253     0.200
    46.703     1.995     0.200
    47.485     1.614     0.200
    47.686     5.032     0.200
    50.345     4.016     0.200
    51.721     1.980     0.200
    52.452     5.271     0.200
    55.265     2.906     0.200
    55.208     4.432     0.200
    55.616     2.977     0.200
    56.075     3.188     0.200
    56.149     2.451     0.200
    57.223     2.251     0.200
    57.223     2.751     0.200
    57.211     3.013     0.200
    57.842     3.369     0.200
    59.738     2.857     0.200
    59.738     3.107     0.200
    59.738     2.256     0.200
    60.158     2.285     0.200
    61.788     2.797     0.200
    62.241     2.242     0.200
    63.501     3.710     0.200
    64.981     2.648     0.200
    65.657     3.068     0.200
    65.657     2.748     0.200
    65.746     3.026     0.200
    66.056     3.377     0.200
    67.331     1.516     0.200
    71.723     1.505     0.200
    77.665     3.447     0.200
    80.136     2.780     0.200
    80.136     2.902     0.200
    80.157     1.843     0.200
    80.186     3.882     0.200
    80.222     3.500     0.200
    80.513     2.891     0.200
    80.711     2.626     0.200
    80.799     3.047     0.200
    80.874     4.157     0.200
    80.933     3.215     0.200
    80.933     4.074     0.200
    80.952     3.993     0.200
    80.958     4.392     0.200
    80.974     4.574     0.200
    80.997     3.730     0.200
    81.065     3.149     0.200
    81.067     3.276     0.200
    81.067     3.526     0.200
    81.136     2.680     0.200
    80.403     8.010     0.200
    81.267     3.190     0.200
    81.267     2.600     0.200
    81.322     4.333     0.200
    81.368     3.581     0.200
    81.458     3.376     0.200
    81.487     3.227     0.200
    81.490     3.293     0.200
    81.494     3.221     0.200
    81.639     3.418     0.200
    81.763     3.584     0.200
    82.083     3.451     0.200
    83.334     3.097     0.200
    83.730     3.610     0.200
    83.730     3.360     0.200
    83.952     3.217     0.200
    83.979     1.174     0.200
    83.979     3.580     0.200
    83.982     3.600     0.200
    83.816     3.781     0.200
    83.816     3.660     0.200
    84.467     4.058     0.200
    84.536     3.141     0.200
    84.853     3.833     0.200
    85.131     3.845     0.200
    85.247     3.015     0.200
    85.247     1.566     0.200
    85.750     2.458     0.200
    85.750     2.083     0.200
    85.739     2.257     0.200
    85.895     3.131     0.200
    85.957     2.646     0.200
    86.295     3.468     0.200
    86.321     2.220     0.200
    86.320     4.087     0.200
    86.562     3.035     0.200
    86.650     2.193     0.200
    86.650     2.771     0.200
    86.832     3.464     0.200
    86.860     2.719     0.200
    86.936     3.604     0.200
    87.209     3.047     0.200
    87.370     1.553     0.200
    87.392     3.286     0.200
    87.590     3.324     0.200
    87.746     1.135     0.200
    87.968     2.931     0.200
    87.990     3.545     0.200
    88.059     0.592     0.200
    88.127     4.946     0.200
    88.521     3.201     0.200
    88.576     2.413     0.200
    88.676     1.431     0.200
    88.736     1.469     0.200
    88.922     3.196     0.200
    88.953     3.249     0.200
    88.961     2.542     0.200
    89.181     2.390     0.200
    89.490     2.789     0.200
    89.692     3.586     0.200
    89.696     2.433     0.200
    89.912     3.537     0.200
    90.158     2.428     0.200
    90.634     3.175     0.200
    90.744     2.504     0.200
    90.817     3.760     0.200
    90.818     2.837     0.200
    90.828     4.547     0.200
    90.896     2.944     0.200
    90.900     2.476     0.200
    91.054     1.872     0.200
    91.054     1.751     0.200
    91.162     3.512     0.200
    91.355     2.622     0.200
    91.579     2.649     0.200
    91.989     2.896     0.200
    92.122     2.683     0.200
    92.192     1.189     0.200
    92.198     2.573     0.200
    92.198     2.928     0.200
    92.198     2.682     0.200
    92.210     2.708     0.200
    92.142     2.492     0.200
    92.644     1.994     0.200
    92.662     2.688     0.200
    92.680     2.220     0.200
    92.930     2.882     0.200
    93.026     2.160     0.200
    93.038     3.524     0.200
    93.268     2.345     0.200
    93.325     2.891     0.200
    93.511     4.299     0.200
    93.901     2.544     0.200
    94.276     2.821     0.200
    94.488     2.898     0.200
    95.182     2.887     0.200
    95.603     3.999     0.200
    96.748     3.284     0.200
    97.256     4.478     0.200
    98.480     1.999     0.200
    99.296     2.043     0.200
    99.430     1.757     0.200
    54.393     2.706     0.200
    58.021     3.228     0.200
    60.315     2.252     0.200
    85.335     3.587     0.200
    85.336     3.565     0.200
    15.290     6.702     0.200
    15.359     6.548     0.200
    15.352     6.090     0.200
    15.352     5.035     0.200
    15.352     4.848     0.200
    15.352     6.785     0.200
    15.352     5.489     0.200
    15.509     3.515     0.200
    15.785     5.493     0.200
    15.770     5.788     0.200
    15.819     5.619     0.200
    15.804     3.240     0.200
    15.881     5.503     0.200
    15.907     5.772     0.200
    15.880     4.300     0.200
    16.064     5.501     0.200
    16.085     2.606     0.200
    16.157     3.544     0.200
    16.281     5.196     0.200
    16.222     3.134     0.200
    16.222     6.243     0.200
    16.285     2.506     0.200
    16.431     6.226     0.200
    16.376     4.099     0.200
    16.376     6.599     0.200
    16.612     4.724     0.200
    16.774     3.331     0.200
    16.881     3.864     0.200
    17.169     1.132     0.200
    17.223     1.532     0.200
    17.312     4.566     0.200
    17.331     3.539     0.200
    17.695     1.267     0.200
    17.729     2.548     0.200
    17.666     1.463     0.200
    18.040     0.075     0.200
    18.090     1.933     0.200
    18.180     1.982     0.200
    18.180     1.451     0.200
    18.238     2.933     0.200
    18.398     2.325     0.200
    18.429     1.411     0.200
    18.726     1.181     0.200
    18.726     0.424     0.200
    18.723     1.798     0.200
    18.655     2.618     0.200
    18.761     3.841     0.200
    18.868     0.517     0.200
    18.898     1.766     0.200
    18.826     4.078     0.200
    18.826     2.735     0.200
    18.826     2.407     0.200
    18.959     1.597     0.200
    19.038     1.655     0.200
    19.108     1.811     0.200
    19.133     3.151     0.200
    19.163     1.742     0.200
    19.279     0.982     0.200
    19.277     1.324     0.200
    19.337     2.000     0.200
    19.267     3.944     0.200
    19.413     2.063     0.200
    19.426     1.407     0.200
    19.448     1.284     0.200
    19.431     3.791     0.200
    19.431     3.478     0.200
    19.431     3.916     0.200
    19.431     2.775     0.200
    19.431     2.846     0.200
    19.431     3.299     0.200
    19.536     1.539     0.200
    19.563     1.512     0.200
    19.608     1.303     0.200
    19.713     1.668     0.200
    19.700     1.750     0.200
    19.821     1.709     0.200
    19.975     1.225     0.200
    20.033     1.707     0.200
    20.086     1.956     0.200
    20.283     0.961     0.200
    20.303     0.380     0.200
    20.365     0.401     0.200
    20.382     1.575     0.200
    20.359     1.350     0.200
    20.299     3.978     0.200
    20.415     4.906     0.200
    20.415     5.687     0.200
    20.507     1.120     0.200
    20.627     1.068     0.200
    20.564     2.047     0.200
    20.597     4.097     0.200
    20.616     4.817     0.200
    20.839     1.149     0.200
    20.879     0.419     0.200
    20.768     3.321     0.200
    20.952     2.585     0.200
    20.952     4.874     0.200
    20.863     4.139     0.200
    21.028     0.264     0.200
    21.049     0.230     0.200
    21.038     2.950     0.200
    21.093     2.993     0.200
    21.008     6.919     0.200
    21.008     5.801     0.200
    21.531     1.614     0.200
    21.720     0.180     0.200
    21.583     2.868     0.200
    21.823     0.833     0.200
    21.733     4.187     0.200
    21.749     4.009     0.200
    21.857     1.299     0.200
    21.921     0.900     0.200
    21.844     2.149     0.200
    22.108     1.041     0.200
    22.108     0.283     0.200
    22.108     1.377     0.200
    22.136     0.953     0.200
    22.111     0.340     0.200
    21.956     3.050     0.200
    22.149     3.363     0.200
    22.149     2.645     0.200
    22.161     3.043     0.200
    22.126     2.996     0.200
    22.241     1.648     0.200
    22.494     0.670     0.200
    22.411     3.513     0.200
    22.557     1.081     0.200
    22.444     3.030     0.200
    22.607     0.490     0.200
    22.654     0.645     0.200
    22.654    -0.300     0.200
    22.613     2.466     0.200
    22.727     0.829     0.200
    22.568     3.210     0.200
    22.873     4.962     0.200
    22.917     3.568     0.200
    23.090     1.380     0.200
    23.018     3.103     0.200
    23.235     1.821     0.200
    23.327     1.028     0.200
    23.329     2.713     0.200
    23.447     3.140     0.200
    23.639     2.695     0.200
    23.581     3.106     0.200
    23.642     3.955     0.200
    23.779     4.635     0.200
    23.826     3.912     0.200
    24.071     1.703     0.200
    24.018     3.692     0.200
    24.162     2.367     0.200
    24.178     1.764     0.200
    24.234     4.109     0.200
    24.435     2.339     0.200
    24.435     2.136     0.200
    24.473     3.442     0.200
    24.536     1.759     0.200
    24.536     1.353     0.200
    24.536     0.610     0.200
    24.536     2.540     0.200
    24.476     3.646     0.200
    24.544     2.935     0.200
    24.757     4.103     0.200
    24.885     3.357     0.200
    24.914     2.657     0.200
    24.967     3.805     0.200
    24.878     3.220     0.200
    24.915     3.412     0.200
    25.187     2.113     0.200
    25.252     1.812     0.200
    25.268     1.903     0.200
    25.331     2.397     0.200
    25.428     1.890     0.200
    25.436     2.143     0.200
    25.356     4.161     0.200
    25.560     3.413     0.200
    25.602     3.148     0.200
    25.743     4.598     0.200
    25.884     2.366     0.200
    25.847     3.809     0.200
    25.904     4.234     0.200
    26.093     1.835     0.200
    26.158     3.662     0.200
    26.322     2.111     0.200
    26.388     2.087     0.200
    26.227     2.732     0.200
    26.311     5.929     0.200
    26.334     3.196     0.200
    26.438     0.352     0.200
    26.489     2.533     0.200
    26.550     1.550     0.200
    26.604     2.353     0.200
    26.454     5.338     0.200
    26.679     2.040     0.200
    26.724     1.803     0.200
    26.581     3.514     0.200
    26.890     3.617     0.200
    26.890     3.750     0.200
    26.890     2.210     0.200
    26.951     2.120     0.200
    27.003     1.797     0.200
    26.860     3.976     0.200
    27.047     1.624     0.200
    26.982     4.339     0.200
    27.118     2.279     0.200
    27.049     3.108     0.200
    27.131     3.816     0.200
    27.259     2.490     0.200
    27.541     2.387     0.200
    27.424     5.311     0.200
    27.435     4.681     0.200
    27.435     3.658     0.200
    27.684     2.111     0.200
    27.588     2.827     0.200
    27.588     3.695     0.200
    27.588     3.203     0.200
    27.788     1.732     0.200
    27.792     2.326     0.200
    27.701     2.691     0.200
    27.820     3.883     0.200
    27.820     2.453     0.200
    27.820     4.578     0.200
    27.791     3.745     0.200
    28.454     1.013     0.200
    28.593     2.883     0.200
    29.054     2.697     0.200
    29.076     1.164     0.200
    29.047     3.764     0.200
    29.047     3.264     0.200
    29.047     2.779     0.200
    29.411     1.966     0.200
    29.469     2.701     0.200
    29.846     3.940     0.200
    30.179     1.367     0.200
    30.152     4.062     0.200
    30.434     2.091     0.200
    30.434     2.482     0.200
    30.587     3.854     0.200
    30.651     3.745     0.200
    30.772     4.126     0.200
    30.772     3.978     0.200
    30.946     2.865     0.200
    31.013     2.502     0.200
    31.309     3.242     0.200
    31.339     3.518     0.200
    31.503     3.207     0.200
    31.512     4.126     0.200
    31.693     1.596     0.200
    31.775     2.420     0.200
    31.775     2.233     0.200
    31.775     1.951     0.200
    31.854     2.314     0.200
    31.852     3.503     0.200
    32.038     1.637     0.200
    32.155     2.313     0.200
    32.338     3.029     0.200
    32.551     1.752     0.200
    32.577     3.201     0.200
    32.959     1.550     0.200
    33.047     3.104     0.200
    33.301     1.130     0.200
    33.385     1.375     0.200
    33.417     1.508     0.200
    33.389     3.799     0.200
    33.492     2.468     0.200
    33.657     2.165     0.200
    33.795     1.990     0.200
    33.795     1.842     0.200
    33.801     3.854     0.200
    34.215     1.956     0.200
    34.227     1.884     0.200
    34.266     3.471     0.200
    34.613     3.758     0.200
    34.915     3.115     0.200
    34.919     1.462     0.200
    34.860     3.478     0.200
    34.860     3.189     0.200
    34.987     0.337     0.200
    34.871     3.799     0.200
    35.150     4.112     0.200
    35.199     2.539     0.200
    35.199     2.828     0.200
    35.267     1.846     0.200
    35.338     1.997     0.200
    35.437     3.066     0.200
    35.730     2.347     0.200
    35.742     6.549     0.200
    35.742     5.073     0.200
    35.742     3.612     0.200
    35.922     2.950     0.200
    36.195     3.605     0.200
    36.747     2.999     0.200
    36.631     3.343     0.200
    36.837     4.183     0.200
    37.037     2.734     0.200
    37.178     3.429     0.200
    37.503     2.841     0.200
    38.207     2.330     0.200
    38.209     2.720     0.200
    38.209     2.916     0.200
    38.209     2.275     0.200
    38.209     3.322     0.200
    38.949     2.390     0.200
    38.984     2.009     0.200
    39.098     2.238     0.200
    39.133     2.093     0.200
    39.151     1.992     0.200
    40.728     2.168     0.200
    40.728     2.027     0.200
    41.091     1.999     0.200
    41.980     2.325     0.200
    41.980     0.551     0.200
    43.862     0.945     0.200
    44.579     3.700     0.200
    44.863     3.809     0.200
    44.863     3.621     0.200
    44.863     2.848     0.200
    45.432     3.538     0.200
    45.747     2.511     0.200
    45.747     0.808     0.200
    45.966     4.601     0.200
    47.148     1.378     0.200
    47.177     2.202     0.200
    47.177     3.679     0.200
    47.243     2.569     0.200
    47.607     3.566     0.200
    48.559     4.841     0.200
    48.559     3.685     0.200
    48.559     2.763     0.200
    50.925     3.992     0.200
    50.925     4.164     0.200
    50.994     1.922     0.200
    51.765     6.562     0.200
    53.815     1.790     0.200
    53.992     1.034     0.200
    53.974     3.780     0.200
    53.974     2.311     0.200
    54.596     1.083     0.200
    54.566     5.446     0.200
    54.566     4.532     0.200
    54.775     4.106     0.200
    55.020     2.755     0.200
    55.348     1.651     0.200
    55.423     1.996     0.200
    55.646     2.626     0.200
    55.821     2.880     0.200
    56.137     2.810     0.200
    56.137     2.638     0.200
    56.137     3.068     0.200
    56.148     3.189     0.200
    56.282     2.869     0.200
    56.314     3.734     0.200
    56.485     2.725     0.200
    56.826     3.574     0.200
    56.826     1.875     0.200
    57.020     2.500     0.200
    57.034     4.213     0.200
    57.123     2.042     0.200
    57.123     2.495     0.200
    57.176     3.272     0.200
    57.565     2.143     0.200
    57.628     2.413     0.200
    57.805     2.755     0.200
    57.805     3.662     0.200
    57.805     3.060     0.200
    57.805     2.810     0.200
    58.011     2.731     0.200
    58.069     1.860     0.200
    58.118     2.657     0.200
    58.173     3.173     0.200
    58.207     2.889     0.200
    58.266     3.414     0.200
    58.395     3.532     0.200
    58.503     2.850     0.200
    58.571     2.679     0.200
    58.898     2.425     0.200
    59.092     1.737     0.200
    59.167     4.595     0.200
    59.343     1.973     0.200
    59.481     2.591     0.200
    59.939     1.991     0.200
    59.927     2.656     0.200
    60.251     1.836     0.200
    60.762     2.119     0.200
    60.813     3.200     0.200
    61.058     4.353     0.200
    61.058     2.431     0.200
    61.377     3.284     0.200
    61.578     4.449     0.200
    61.767     2.926     0.200
    61.717     2.950     0.200
    61.909     2.809     0.200
    62.201     2.341     0.200
    62.787     2.688     0.200
    62.926     2.319     0.200
    64.555     1.881     0.200
    64.555     4.835     0.200
    64.645     3.884     0.200
    64.645     4.360     0.200
    64.843     2.643     0.200
    65.838     3.222     0.200
    65.838     2.722     0.200
    66.555     2.493     0.200
    66.555     2.766     0.200
    66.555     3.274     0.200
    66.779     2.195     0.200
    67.348     1.812     0.200
    71.940     1.830     0.200
    71.940     2.174     0.200
    76.382     3.392     0.200
    76.382     2.861     0.200
    79.047     2.754     0.200
    80.107     2.980     0.200
    82.324     3.411     0.200
    83.487     3.467     0.200
    83.487     3.709     0.200
    83.487     2.366     0.200
    83.492     3.809     0.200
    83.470     2.643     0.200
    83.692     2.955     0.200
    83.738     3.517     0.200
    83.738     3.025     0.200
    84.192     4.014     0.200
    84.539     3.606     0.200
    84.489     3.432     0.200
    85.299     3.273     0.200
    85.299     3.679     0.200
    85.808     3.288     0.200
    85.932     2.051     0.200
    86.084     1.924     0.200
    86.254     2.142     0.200
    86.254     1.892     0.200
    86.254     0.892     0.200
    86.559     3.598     0.200
    86.756     2.961     0.200
    86.852     4.029     0.200
    87.029     3.318     0.200
    87.508     3.224     0.200
    87.738     3.391     0.200
    87.902     1.572     0.200
    87.937     3.608     0.200
    88.441     3.084     0.200
    88.468     2.328     0.200
    88.468     2.563     0.200
    88.866     3.265     0.200
    88.909     3.392     0.200
    89.134     2.259     0.200
    89.539     2.573     0.200
    89.436     2.804     0.200
    89.470     2.870     0.200
    89.506     5.297     0.200
    89.506     5.125     0.200
    90.386     3.408     0.200
    90.536     2.826     0.200
    90.572     2.564     0.200
    90.572     2.290     0.200
    90.674     3.270     0.200
    90.679     2.698     0.200
    90.827     2.884     0.200
    91.046     2.985     0.200
    91.159     1.173     0.200
    91.264     1.981     0.200
    91.302     3.488     0.200
    91.816     3.010     0.200
    91.915     2.242     0.200
    92.121     2.766     0.200
    92.121     3.118     0.200
    92.121     2.430     0.200
    92.479     2.883     0.200
    92.479     2.316     0.200
    92.533     2.642     0.200
    92.533     1.876     0.200
    92.734     2.919     0.200
    92.717     2.987     0.200
    92.717     2.714     0.200
    92.880     2.719     0.200
    93.088     3.233     0.200
    93.164     2.749     0.200
    93.294     3.923     0.200
    93.338     2.612     0.200
    93.556     3.120     0.200
    93.568     3.162     0.200
    93.595     2.785     0.200
    93.732     2.586     0.200
    93.850     2.718     0.200
    93.850     2.968     0.200
    96.077     2.523     0.200
    96.096     3.803     0.200
    96.207     3.156     0.200
    96.864     4.067     0.200
    96.864     2.778     0.200
    97.509     4.250     0.200
    97.587     2.686     0.200
    97.675     2.128     0.200
    98.771     3.777     0.200
    23.872     7.299     0.200
    54.976     3.690     0.200
    27.602     2.924     0.200
    58.577     2.261     0.200
    26.322     2.734     0.200
    60.901     1.512     0.200
    85.016     2.895     0.200
    85.016     2.347     0.200
    26.549     2.490     0.200
    26.918     4.355     0.200
    15.490     6.170     0.200
    15.490     6.068     0.200
    15.836     3.171     0.200
    15.837     4.730     0.200
    16.359     4.710     0.200
    17.794     4.357     0.200
    17.936     0.878     0.200
    18.180     1.324     0.200
    18.502     0.048     0.200
    18.590     5.476     0.200
    18.590     4.476     0.200
    18.590     4.315     0.200
    19.182     3.779     0.200
    19.182     3.459     0.200
    19.747     1.648     0.200
    20.117     2.768     0.200
    20.117     1.276     0.200
    20.540     4.179     0.200
    20.968     3.529     0.200
    20.987     6.104     0.200
    21.508     4.722     0.200
    21.593     2.692     0.200
    21.908     0.245     0.200
    21.985     0.255     0.200
    22.433     0.936     0.200
    22.420     1.253     0.200
    22.723     4.329     0.200
    22.720     4.990     0.200
    22.723     4.856     0.200
    23.326     2.580     0.200
    23.594     2.730     0.200
    23.839     2.975     0.200
    24.168     4.533     0.200
    24.253     1.314     0.200
    24.225     2.110     0.200
    24.335     1.120     0.200
    24.335     0.581     0.200
    24.572     4.958     0.200
    24.572     3.958     0.200
    25.016     4.748     0.200
    25.217     6.787     0.200
    25.657     6.094     0.200
    25.657     5.293     0.200
    26.432     1.529     0.200
    26.411     4.753     0.200
    26.898     3.754     0.200
    26.858     5.636     0.200
    26.858     5.237     0.200
    27.018     0.792     0.200
    27.083     3.376     0.200
    27.080     4.140     0.200
    27.163     3.729     0.200
    27.433     0.680     0.200
    27.339     2.867     0.200
    27.570     3.544     0.200
    27.570     3.083     0.200
    27.542     4.113     0.200
    27.981     4.974     0.200
    27.981     4.372     0.200
    28.516     1.990     0.200
    28.851     1.425     0.200
    29.145     4.114     0.200
    29.145     3.313     0.200
    29.145     3.493     0.200
    29.235     5.411     0.200
    29.473     3.026     0.200
    29.600     3.555     0.200
    30.257     2.567     0.200
    30.257     1.864     0.200
    30.257     1.696     0.200
    30.305     1.086     0.200
    30.523     3.363     0.200
    31.612     1.858     0.200
    31.790     2.642     0.200
    31.790     1.931     0.200
    31.805     1.544     0.200
    31.795     2.757     0.200
    32.372     1.818     0.200
    32.327     2.692     0.200
    32.318     2.953     0.200
    32.762     0.447     0.200
    33.553     1.508     0.200
    33.553     1.610     0.200
    34.318     3.217     0.200
    34.261     5.154     0.200
    34.261     4.455     0.200
    34.583     2.106     0.200
    34.613     2.388     0.200
    34.803     1.366     0.200
    34.841     2.428     0.200
    35.032     3.292     0.200
    35.032     2.870     0.200
    35.057     3.278     0.200
    35.057     3.067     0.200
    35.411     1.365     0.200
    35.432     1.673     0.200
    35.965     0.478     0.200
    36.285     2.783     0.200
    36.355     1.596     0.200
    36.258     5.463     0.200
    36.258     4.861     0.200
    36.610     1.933     0.200
    36.775     0.342     0.200
    36.597     3.851     0.200
    38.001     2.324     0.200
    38.283     3.034     0.200
    44.035     1.673     0.200
    44.035     1.411     0.200
    44.547     2.958     0.200
    45.071     4.071     0.200
    45.117     6.444     0.200
    45.547     1.575     0.200
    45.340     4.160     0.200
    45.648     4.612     0.200
    46.184     5.017     0.200
    46.207     4.071     0.200
    46.916     1.707     0.200
    46.757     4.618     0.200
    46.713     4.052     0.200
    47.287     1.732     0.200
    47.119     3.824     0.200
    47.214     4.649     0.200
    47.654     3.839     0.200
    47.689     4.042     0.200
    48.298     3.903     0.200
    48.409     4.974     0.200
    49.098     1.879     0.200
    48.910     4.412     0.200
    48.974     4.811     0.200
    49.356     4.546     0.200
    49.999     4.869     0.200
    50.679     3.852     0.200
    50.809     4.821     0.200
    51.157     1.325     0.200
    51.039     5.219     0.200
    51.542     1.868     0.200
    52.039     2.742     0.200
    51.986     5.756     0.200
    51.986     4.654     0.200
    52.454     4.877     0.200
    53.137     5.125     0.200
    53.137     4.676     0.200
    53.300     4.030     0.200
    53.300     4.628     0.200
    53.203     5.859     0.200
    53.374     4.508     0.200
    53.754     1.450     0.200
    53.850     7.335     0.200
    54.201     4.386     0.200
    54.391     4.840     0.200
    54.538     2.803     0.200
    54.803     3.878     0.200
    54.954     4.053     0.200
    55.270     5.719     0.200
    55.270     3.977     0.200
    55.606     1.799     0.200
    55.662     3.207     0.200
    55.887     2.223     0.200
    56.170     5.656     0.200
    56.419     3.400     0.200
    56.458     4.131     0.200
    56.682     1.935     0.200
    56.652     3.581     0.200
    56.652     2.581     0.200
    56.652     3.921     0.200
    56.902     1.143     0.200
    56.711     3.840     0.200
    56.719     5.440     0.200
    56.781     7.215     0.200
    57.328     1.554     0.200
    57.275     3.517     0.200
    57.519     4.536     0.200
    57.573     3.269     0.200
    57.863     2.398     0.200
    58.011     0.917     0.200
    57.961     3.237     0.200
    57.961     3.038     0.200
    57.961     2.674     0.200
    58.044     4.034     0.200
    58.459     1.906     0.200
    58.360     2.843     0.200
    58.584     3.895     0.200
    59.267     3.840     0.200
    59.267     2.641     0.200
    59.267     1.738     0.200
    59.267     1.879     0.200
    60.324     2.059     0.200
    59.984     8.416     0.200
    60.579     4.074     0.200
    60.691     1.671     0.200
    61.131     1.834     0.200
    61.822     3.809     0.200
    62.824     1.652     0.200
    62.610     3.579     0.200
    62.656     5.549     0.200
    62.811     5.950     0.200
    62.967     2.190     0.200
    63.371     1.771     0.200
    63.170     3.505     0.200
    63.389     2.594     0.200
    64.013     2.733     0.200
    64.490     1.961     0.200
    64.728     2.232     0.200
    64.879     3.555     0.200
    64.879     3.348     0.200
    65.261     2.816     0.200
    65.446     3.149     0.200
    66.698     4.831     0.200
    66.802     4.209     0.200
    67.413     1.492     0.200
    67.753     5.463     0.200
    69.201     3.991     0.200
    69.937     3.843     0.200
    69.937     4.343     0.200
    69.937     3.714     0.200
    70.172     2.164     0.200
    70.132     7.167     0.200
    71.713     0.644     0.200
    71.713     0.875     0.200
    72.493     1.620     0.200
    72.555     4.606     0.200
    72.555     3.966     0.200
    74.819     4.588     0.200
    74.890     5.088     0.200
    74.907     3.950     0.200
    74.919     3.476     0.200
    74.943     5.136     0.200
    74.948     4.833     0.200
    74.964     5.217     0.200
    74.963     4.968     0.200
    74.976     5.143     0.200
    74.986     5.958     0.200
    75.001     4.499     0.200
    75.008     4.667     0.200
    75.011     5.272     0.200
    75.023     5.029     0.200
    75.023     4.443     0.200
    75.033     3.704     0.200
    75.041     4.931     0.200
    75.071     5.562     0.200
    75.616     5.818     0.200
    75.913     4.359     0.200
    75.996     6.296     0.200
    76.020     5.950     0.200
    76.022     5.992     0.200
    76.043     5.456     0.200
    76.061     6.272     0.200
    76.067     5.641     0.200
    76.070     6.135     0.200
    76.080     5.759     0.200
    76.119     5.143     0.200
    76.121     4.009     0.200
    76.127     5.369     0.200
    76.130     5.436     0.200
    76.205     4.821     0.200
    76.214     4.958     0.200
    76.247     6.464     0.200
    76.288     3.252     0.200
    76.137     3.051     0.200
    76.140     3.535     0.200
    76.137     3.347     0.200
    76.534     3.992     0.200
    76.534     4.504     0.200
    76.796     4.442     0.200
    76.984     4.368     0.200
    77.036     6.555     0.200
    77.067     5.367     0.200
    77.563     2.760     0.200
    77.689     1.503     0.200
    77.689     4.113     0.200
    78.114     1.129     0.200
    77.626     4.953     0.200
    77.626     5.055     0.200
    78.259     5.976     0.200
    78.306     5.577     0.200
    78.335     4.945     0.200
    78.417     5.360     0.200
    77.875     7.767     0.200
    78.447     4.354     0.200
    78.547     2.236     0.200
    78.576     4.791     0.200
    78.594     4.581     0.200
    78.642     6.205     0.200
    79.183     4.831     0.200
    79.214     2.962     0.200
    79.389     3.841     0.200
    79.463     5.832     0.200
    79.525     4.206     0.200
    79.741     4.335     0.200
    79.812     5.845     0.200
    79.893     4.378     0.200
    79.913     3.379     0.200
    79.913     2.641     0.200
    80.049     4.608     0.200
    80.177     4.899     0.200
    80.298     4.630     0.200
    80.359     3.763     0.200
    80.508     4.891     0.200
    80.539     4.365     0.200
    80.569     5.439     0.200
    80.587     3.451     0.200
    80.703     7.022     0.200
    80.729     3.015     0.200
    80.777     2.160     0.200
    80.894     1.917     0.200
    80.970     4.372     0.200
    80.991     6.467     0.200
    81.116     5.593     0.200
    81.255     4.243     0.200
    81.258     3.756     0.200
    81.528     4.379     0.200
    81.737     5.684     0.200
    81.743     4.042     0.200
    81.822     6.790     0.200
    81.946     4.575     0.200
    82.091     4.240     0.200
    82.663     4.989     0.200
    82.663     4.000     0.200
    82.791     6.332     0.200
    82.955     4.764     0.200
    82.967     6.370     0.200
    83.004     3.218     0.200
    83.247     4.065     0.200
    83.367     6.575     0.200
    83.370     4.339     0.200
    83.370     3.202     0.200
    83.411     5.077     0.200
    83.411     2.710     0.200
    83.228     3.654     0.200
    83.513     6.689     0.200
    83.580     3.210     0.200
    83.590     5.427     0.200
    83.620     4.671     0.200
    83.875     5.499     0.200
    84.015     4.805     0.200
    84.020     5.123     0.200
    84.085     5.638     0.200
    84.233     5.392     0.200
    84.241     2.867     0.200
    84.356     4.893     0.200
    84.439     6.742     0.200
    84.592     4.432     0.200
    84.672     5.126     0.200
    84.646     4.660     0.200
    84.715     5.223     0.200
    84.824     5.094     0.200
    84.924     2.916     0.200
    84.959     4.580     0.200
    84.959     2.248     0.200
    84.971     3.865     0.200
    84.971     4.576     0.200
    85.169     3.624     0.200
    85.229     5.043     0.200
    85.400     5.928     0.200
    85.409     4.773     0.200
    85.547     4.919     0.200
    85.329     3.731     0.200
    85.716     6.729     0.200
    85.717     5.364     0.200
    85.729     5.849     0.200
    85.843     5.483     0.200
    85.843     4.638     0.200
    85.851     4.457     0.200
    85.876     5.354     0.200
    85.866     3.054     0.200
    85.973     3.314     0.200
    85.982     3.890     0.200
    85.982     4.129     0.200
    86.137     5.227     0.200
    86.004     2.630     0.200
    86.004     1.931     0.200
    86.004     1.470     0.200
    86.194     2.727     0.200
    86.204     4.982     0.200
    86.231     5.004     0.200
    86.360     6.294     0.200
    86.364     4.771     0.200
    86.397     3.023     0.200
    86.425     3.225     0.200
    86.466     5.006     0.200
    86.586     2.464     0.200
    86.604     2.063     0.200
    86.626     4.549     0.200
    86.643     5.272     0.200
    86.654     4.540     0.200
    86.670     5.357     0.200
    86.689     3.299     0.200
    86.700     4.966     0.200
    86.716     5.145     0.200
    86.718     6.807     0.200
    86.732     4.271     0.200
    86.761     6.126     0.200
    86.766     6.038     0.200
    86.895     4.893     0.200
    86.966     3.203     0.200
    87.018     4.731     0.200
    87.101     3.766     0.200
    87.136     3.499     0.200
    87.227     5.072     0.200
    87.243     5.505     0.200
    87.397     3.876     0.200
    87.316     4.401     0.200
    87.567     3.065     0.200
    87.583     4.893     0.200
    87.586     6.322     0.200
    87.646     5.262     0.200
    87.663     4.419     0.200
    87.663     3.274     0.200
    87.685     1.306     0.200
    87.732     3.975     0.200
    87.732     3.072     0.200
    87.766     3.193     0.200
    87.759     2.773     0.200
    87.765     3.737     0.200
    87.902     6.549     0.200
    88.016     4.975     0.200
    88.311     2.448     0.200
    88.409     2.741     0.200
    88.549     4.948     0.200
    88.603     1.249     0.200
    88.123     7.542     0.200
    88.123     6.745     0.200
    88.123     7.085     0.200
    88.681     3.861     0.200
    88.654     1.677     0.200
    88.695     2.570     0.200
    88.780     3.512     0.200
    88.926     2.594     0.200
    88.956     5.390     0.200
    88.657     3.823     0.200
    88.657     4.523     0.200
    88.657     3.105     0.200
    88.961     2.162     0.200
    88.981     2.495     0.200
    88.981     3.495     0.200
    88.981     2.136     0.200
    89.074     1.161     0.200
    89.134     3.981     0.200
    89.394     3.809     0.200
    89.264     2.638     0.200
    89.313     4.504     0.200
    89.313     2.000     0.200
    89.368     4.858     0.200
    89.322     2.429     0.200
    89.282     1.182     0.200
    89.470     2.656     0.200
    89.514     4.439     0.200
    89.619     4.783     0.200
    89.639     2.674     0.200
    89.762     2.290     0.200
    89.836     5.277     0.200
    89.925     2.805     0.200
    90.125     4.850     0.200
    90.123     3.399     0.200
    90.123     3.452     0.200
    90.149     2.894     0.200
    90.177     2.580     0.200
    90.249     4.946     0.200
    90.249     3.946     0.200
    90.304     2.618     0.200
    90.338     2.171     0.200
    90.367     2.760     0.200
    90.382     2.896     0.200
    90.402     2.528     0.200
    90.509     2.505     0.200
    90.571     3.015     0.200
    90.572     2.729     0.200
    90.579     2.844     0.200
    90.586     2.794     0.200
    90.609     3.999     0.200
    90.620     2.707     0.200
    90.615     2.279     0.200
    90.650     0.857     0.200
    90.673     5.454     0.200
    90.693     3.215     0.200
    90.891     4.680     0.200
    90.891     2.856     0.200
    90.970     1.701     0.200
    91.130     2.097     0.200
    91.336     2.580     0.200
    91.465     3.257     0.200
    91.645     4.280     0.200
    91.749     2.097     0.200
    91.749     3.027     0.200
    91.799     4.217     0.200
    91.891     3.240     0.200
    91.891     2.213     0.200
    91.956     3.207     0.200
    91.967     1.867     0.200
    92.320     2.933     0.200
    92.377     1.846     0.200
    92.441     2.601     0.200
    92.443     2.998     0.200
    92.457     2.711     0.200
    92.488     3.082     0.200
    92.545     2.587     0.200
    92.574     2.825     0.200
    92.470     3.362     0.200
    92.470     3.061     0.200
    92.470     2.401     0.200
    92.708     2.413     0.200
    92.760     2.474     0.200
    92.766     3.048     0.200
    92.790     2.079     0.200
    92.838     2.487     0.200
    92.915     2.468     0.200
    92.924     3.497     0.200
    93.006     2.263     0.200
    93.244     4.870     0.200
    93.369     2.437     0.200
    93.387     3.836     0.200
    93.387     2.265     0.200
    93.399     3.478     0.200
    93.424     2.694     0.200
    93.519     2.599     0.200
    93.572     3.261     0.200
    93.659     4.279     0.200
    93.677     3.298     0.200
    93.677     2.286     0.200
    93.723     4.554     0.200
    93.796     1.805     0.200
    93.980     2.656     0.200
    94.050     3.264     0.200
    94.189     2.768     0.200
    94.225     6.381     0.200
    94.243     1.298     0.200
    95.023     2.199     0.200
    95.023     4.723     0.200
    95.382     3.883     0.200
    95.386     3.094     0.200
    95.719     2.894     0.200
    95.592     3.825     0.200
    95.914     3.756     0.200
    95.914     2.095     0.200
    95.981     3.362     0.200
    95.981     4.753     0.200
    95.981     3.479     0.200
    96.095     1.736     0.200
    96.170     2.831     0.200
    96.170     1.971     0.200
    96.525     2.980     0.200
    96.562     3.114     0.200
    96.800     3.086     0.200
    97.335     2.645     0.200
    97.425     2.658     0.200
    98.238     4.950     0.200
    98.238     0.270     0.200
    98.455     3.229     0.200
    98.495     5.699     0.200
    98.594     2.966     0.200
    98.829     1.641     0.200
    99.097     5.696     0.200
    59.673     2.987     0.200
    99.202     0.937     0.200
    99.205     4.024     0.200
    99.202     0.648     0.200
    99.210     0.901     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Gred << EOF
   100.024     3.520     0.200
   100.090     1.829     0.200
   100.480     4.693     0.200
   100.656     4.013     0.200
   100.656     2.013     0.200
   100.663     1.983     0.200
   100.663     2.682     0.200
   101.090     4.083     0.200
   101.274     1.263     0.200
   101.394     2.730     0.200
   101.395     2.727     0.200
   101.724     4.866     0.200
   102.064     3.751     0.200
   102.064     2.751     0.200
   103.702     4.469     0.200
   104.066     4.853     0.200
   104.345     3.613     0.200
   104.706     2.007     0.200
   104.741     0.851     0.200
   105.177     2.414     0.200
   105.392     1.957     0.200
   105.701     4.583     0.200
   107.158     2.108     0.200
   107.069     4.504     0.200
   108.217     2.398     0.200
   108.588     0.751     0.200
   108.588     1.552     0.200
   109.164     4.189     0.200
   109.441     3.957     0.200
   110.174     3.697     0.200
   110.174     4.299     0.200
   112.130     4.003     0.200
   112.434     4.649     0.200
   112.718     3.387     0.200
   112.954     4.340     0.200
   113.005     4.115     0.200
   113.061     2.864     0.200
   113.061     3.063     0.200
   114.056     3.440     0.200
   114.544     4.269     0.200
   114.453     2.676     0.200
   115.835     2.531     0.200
   116.601     5.128     0.200
   116.670     2.820     0.200
   116.968     3.493     0.200
   118.450     4.904     0.200
   119.144     1.819     0.200
   120.381     2.320     0.200
   120.953     1.777     0.200
   121.193     4.711     0.200
   121.256     2.431     0.200
   122.808     1.534     0.200
   122.975     4.788     0.200
   123.798     0.132     0.200
   127.588     3.481     0.200
   100.306     0.573     0.200
   103.247     2.263     0.200
   100.024     1.919     0.200
   100.877     2.174     0.200
   100.877     3.051     0.200
   101.454     2.261     0.200
   103.153     4.337     0.200
   103.214     2.432     0.200
   104.527     1.525     0.200
   104.527     0.396     0.200
   106.257     4.504     0.200
   108.998     3.719     0.200
   108.998     3.620     0.200
   109.564     3.507     0.200
   111.761     4.738     0.200
   129.304     1.885     0.200
   103.340     0.783     0.200
   103.830     3.006     0.200
   113.978     5.188     0.200
   129.599     1.644     0.200
   101.313     3.594     0.200
   103.136     3.814     0.200
   103.171     1.936     0.200
   103.413     1.154     0.200
   104.246     2.158     0.200
   104.668     1.979     0.200
   106.895     4.080     0.200
   114.285     2.923     0.200
   117.273     2.638     0.200
   129.918     2.425     0.200
   130.003     3.869     0.200
   100.555     2.330     0.200
   103.022     2.261     0.200
   110.104    -0.420     0.200
   130.454    -0.088     0.200
   100.082     4.346     0.200
   100.119     3.183     0.200
   100.276     4.882     0.200
   100.626     2.326     0.200
   100.646     3.209     0.200
   100.742     1.510     0.200
   100.746     3.756     0.200
   100.746     3.189     0.200
   100.862     2.174     0.200
   101.199     3.278     0.200
   101.360    -0.437     0.200
   102.079     1.665     0.200
   102.746     3.203     0.200
   103.230     1.851     0.200
   104.260     0.471     0.200
   104.744     1.318     0.200
   107.238     3.132     0.200
   109.369     3.959     0.200
   110.345     1.918     0.200
   113.237     0.459     0.200
   100.320     3.395     0.200
   100.375     2.726     0.200
   100.998     1.855     0.200
   112.883     0.221     0.200
    99.617     3.653     0.200
   103.737     3.337     0.200
    99.805     4.997     0.200
   121.515     1.771     0.200
   123.143     3.531     0.200
    99.577     4.067     0.200
    99.676     3.669     0.200
    99.877     3.239     0.200
    99.927     3.318     0.200
    99.944     4.343     0.200
    99.929     4.081     0.200
   100.139     3.247     0.200
   100.163     2.848     0.200
   100.280     4.490     0.200
   100.342     3.574     0.200
   100.342     3.832     0.200
   100.415     5.081     0.200
   100.427     3.045     0.200
   100.473     4.319     0.200
   100.473     2.761     0.200
   100.567     3.204     0.200
   100.567     2.745     0.200
   100.568     3.417     0.200
   100.576     4.105     0.200
   100.635     2.878     0.200
   100.674     2.622     0.200
   100.732     0.910     0.200
   100.941     3.983     0.200
   100.950     3.641     0.200
   100.970     3.128     0.200
   101.075     2.934     0.200
   101.132     2.721     0.200
   101.142     4.680     0.200
   101.240     3.330     0.200
   101.334     2.835     0.200
   101.353     4.861     0.200
   101.324     4.279     0.200
   101.408     3.946     0.200
   101.409     2.812     0.200
   101.415     3.619     0.200
   101.474     3.474     0.200
   101.509     3.431     0.200
   101.583     3.131     0.200
   101.651     3.436     0.200
   101.673     3.539     0.200
   101.685     3.127     0.200
   101.698     3.539     0.200
   101.703     3.431     0.200
   101.867     2.719     0.200
   101.876     3.026     0.200
   101.896     3.023     0.200
   101.897     3.129     0.200
   101.969     2.983     0.200
   102.032     2.923     0.200
   102.042     3.124     0.200
   102.042     2.924     0.200
   102.046     3.217     0.200
   102.045     3.220     0.200
   102.100     2.511     0.200
   102.158     2.844     0.200
   102.180     2.712     0.200
   102.190     2.827     0.200
   102.214     3.521     0.200
   102.247     2.919     0.200
   102.259     2.923     0.200
   102.267     2.823     0.200
   102.281     3.125     0.200
   102.283     2.515     0.200
   102.290     2.415     0.200
   102.345     3.463     0.200
   102.494     2.914     0.200
   102.513     3.022     0.200
   102.518     3.123     0.200
   102.512     2.345     0.200
   102.547     2.835     0.200
   102.609     3.014     0.200
   102.706     3.531     0.200
   102.795     3.729     0.200
   102.851     3.420     0.200
   102.896     3.903     0.200
   102.902     3.120     0.200
   102.907     3.221     0.200
   102.957     3.268     0.200
   102.961     3.122     0.200
   102.961     2.809     0.200
   102.972     3.427     0.200
   103.037     2.462     0.200
   103.028     4.854     0.200
   103.156     2.906     0.200
   103.150     3.216     0.200
   103.178     2.709     0.200
   103.188     3.323     0.200
   103.299     3.220     0.200
   103.312     3.020     0.200
   103.330     3.223     0.200
   103.369     2.986     0.200
   103.396     3.219     0.200
   103.519     3.220     0.200
   103.612     3.706     0.200
   103.729     3.008     0.200
   103.716     5.143     0.200
   103.717     3.839     0.200
   103.717     4.529     0.200
   103.788     1.712     0.200
   103.848     2.502     0.200
   104.083     3.521     0.200
   104.067     3.783     0.200
   104.116     2.703     0.200
   104.155     3.315     0.200
   104.228     2.837     0.200
   104.392     3.339     0.200
   104.453     3.367     0.200
   104.568     3.522     0.200
   104.603     3.308     0.200
   104.679     3.104     0.200
   104.812     2.474     0.200
   104.833     2.478     0.200
   104.917     3.289     0.200
   104.946     3.621     0.200
   105.294     2.885     0.200
   105.425     2.903     0.200
   105.517     4.334     0.200
   105.632     3.004     0.200
   105.640     3.107     0.200
   105.653     3.835     0.200
   105.734     2.967     0.200
   106.001     2.998     0.200
   106.019     3.717     0.200
   106.034     3.307     0.200
   106.053     3.002     0.200
   106.107     2.998     0.200
   106.194     1.986     0.200
   106.341     2.897     0.200
   106.441     3.208     0.200
   106.459     3.816     0.200
   106.526     4.325     0.200
   106.838     3.502     0.200
   106.802     2.726     0.200
   106.872     3.505     0.200
   107.327     3.910     0.200
   107.406     1.940     0.200
   107.456     2.069     0.200
   107.694     2.476     0.200
   108.147     3.647     0.200
   108.066     5.000     0.200
   108.269     2.570     0.200
   108.993     2.684     0.200
   109.078     2.907     0.200
   109.409     2.634     0.200
   109.398     4.610     0.200
   109.930     4.893     0.200
   109.905     4.122     0.200
   110.501     4.183     0.200
   111.196     3.093     0.200
   112.309     4.842     0.200
   112.739     1.943     0.200
   113.379    -0.515     0.200
   114.203     4.622     0.200
   114.696     4.930     0.200
   116.698     3.930     0.200
   117.816     4.560     0.200
   121.050     4.782     0.200
   122.451     3.756     0.200
   122.523     4.636     0.200
   122.783     4.678     0.200
   133.912     1.202     0.200
   105.994    -0.931     0.200
    99.589     1.054     0.200
   108.390     0.825     0.200
    99.739     0.983     0.200
   100.349     3.112     0.200
    99.830     1.989     0.200
    99.741     2.651     0.200
   100.116     1.338     0.200
   100.116     1.811     0.200
   100.986     0.353     0.200
   102.190     1.147     0.200
   106.663     4.567     0.200
   110.163     2.109     0.200
EOF
gmt plot $proj $reg -Sx -Wthin -Ggreen << EOF
    24.130   221.098     0.200
    70.536    23.181     0.200
    85.577     6.076     0.200
    87.009     5.229     0.200
    88.149     3.858     0.200
    91.004     3.888     0.200
    92.447     5.009     0.200
    94.715     2.969     0.200
    95.593     4.759     0.200
    97.829     3.327     0.200
    97.881     2.893     0.200
    97.919     3.222     0.200
    98.118     3.432     0.200
    98.111     3.360     0.200
    98.410     4.019     0.200
    98.761     2.447     0.200
    98.954     4.588     0.200
    99.138     4.762     0.200
    99.202     2.480     0.200
    99.369     4.735     0.200
    65.580    34.815     0.200
    77.562    10.991     0.200
    99.267     2.194     0.200
    99.341     2.865     0.200
    26.573   206.383     0.200
    26.641   206.710     0.200
    46.258    97.181     0.200
    26.361   209.246     0.200
    27.890   199.263     0.200
    29.610   186.671     0.200
    31.615   176.542     0.200
    37.144   143.698     0.200
    46.332    96.614     0.200
    68.845    26.203     0.200
    92.526     5.170     0.200
    94.243     4.103     0.200
    98.162     3.925     0.200
    98.361     3.002     0.200
    99.142     0.741     0.200
    99.156     3.679     0.200
    99.207     1.492     0.200
    99.210     1.437     0.200
    99.210     1.562     0.200
    99.210     1.138     0.200
    99.387     0.147     0.200
    26.375   209.202     0.200
    26.675   206.101     0.200
    97.195     2.816     0.200
    98.176     4.097     0.200
    99.206     1.666     0.200
    99.218     1.636     0.200
    26.671   207.966     0.200
    26.949   203.945     0.200
    97.258     4.123     0.200
    99.321     1.626     0.200
    99.362     0.866     0.200
    99.362     1.766     0.200
    25.893   211.804     0.200
    26.928   205.240     0.200
    27.005   205.049     0.200
    27.146   202.946     0.200
    27.344   202.454     0.200
    27.344   202.673     0.200
    28.574   194.978     0.200
    29.146   190.648     0.200
    30.605   181.629     0.200
    31.598   174.611     0.200
    31.725   173.828     0.200
    32.752   167.947     0.200
    33.049   166.406     0.200
    33.391   163.337     0.200
    34.417   157.144     0.200
    34.997   154.784     0.200
    41.794   119.112     0.200
    44.214   107.493     0.200
    46.742    95.498     0.200
    47.164    95.132     0.200
    57.363    56.706     0.200
    75.940    12.735     0.200
    83.350     3.537     0.200
    83.635     3.449     0.200
    84.871     3.927     0.200
    97.255     3.217     0.200
    99.139     0.260     0.200
    99.206     1.963     0.200
    99.076     2.108     0.200
    20.739   254.325     0.200
    16.562   294.923     0.200
    26.913   204.702     0.200
    57.082    56.995     0.200
    57.738    54.906     0.200
    27.107   204.107     0.200
    27.246   202.628     0.200
    27.446   201.856     0.200
    31.828   174.710     0.200
    33.476   165.229     0.200
    34.519   159.405     0.200
    37.083   143.766     0.200
    46.838    95.482     0.200
    47.347    93.927     0.200
    57.464    56.048     0.200
    64.853    37.691     0.200
    76.042    12.479     0.200
    86.037     5.066     0.200
    86.753     4.443     0.200
    97.781     4.026     0.200
    97.810     4.396     0.200
    97.865     3.348     0.200
    98.164     3.201     0.200
    98.546     4.588     0.200
    99.059     2.175     0.200
    99.114     3.549     0.200
    99.161     1.578     0.200
    99.202     1.360     0.200
    99.267     1.869     0.200
    27.056   205.334     0.200
    27.056   205.338     0.200
    27.233   202.136     0.200
    27.233   202.136     0.200
    27.411   201.723     0.200
    28.659   194.120     0.200
    35.063   154.754     0.200
    46.841    95.477     0.200
    46.840    95.469     0.200
    57.438    56.300     0.200
    57.438    56.300     0.200
    76.015    16.450     0.200
    99.245     1.509     0.200
    99.245     1.513     0.200
    99.340     2.980     0.200
    26.807   206.390     0.200
    26.807   206.386     0.200
    27.102   203.186     0.200
    27.102   203.182     0.200
    28.329   195.928     0.200
    34.330   158.320     0.200
    27.295   201.590     0.200
    27.325   203.316     0.200
    27.596   200.517     0.200
    31.257   173.762     0.200
    76.150    15.276     0.200
    85.563     6.495     0.200
    85.753     4.278     0.200
    86.297     4.562     0.200
    86.311     4.759     0.200
    98.929     4.059     0.200
    27.334   201.003     0.200
    27.413   201.322     0.200
    46.847    93.058     0.200
    57.630    54.979     0.200
    26.585   208.336     0.200
    26.957   204.552     0.200
    27.015   204.440     0.200
    33.491   162.799     0.200
    34.162   158.588     0.200
    46.642    95.798     0.200
    57.088    57.400     0.200
    90.850     3.705     0.200
    91.689     3.791     0.200
    91.928     3.594     0.200
    99.545     3.271     0.200
    26.854   206.109     0.200
    27.080   203.405     0.200
    27.005   205.105     0.200
    27.222   202.167     0.200
    26.781   205.920     0.200
    27.041   203.742     0.200
    98.825     4.644     0.200
    99.387     4.758     0.200
    26.221   210.670     0.200
    27.664   199.646     0.200
    27.683   199.113     0.200
    86.177     4.736     0.200
    97.201     3.922     0.200
    97.372     3.477     0.200
    98.054     3.175     0.200
    98.080     4.111     0.200
    99.293     0.866     0.200
    26.907   206.502     0.200
    93.968     4.773     0.200
    97.067     3.203     0.200
    97.109     4.653     0.200
    97.119     4.054     0.200
    97.285     3.115     0.200
    97.483     4.613     0.200
    97.490     3.761     0.200
    97.593     4.625     0.200
    97.589     4.296     0.200
    97.569     4.035     0.200
    97.569     3.835     0.200
    98.013     3.641     0.200
    98.034     4.742     0.200
    98.057     3.440     0.200
    98.408     4.271     0.200
    98.408     4.422     0.200
    98.656     4.345     0.200
    98.732     4.162     0.200
    98.732     3.415     0.200
    98.732     4.575     0.200
    98.995     3.974     0.200
    99.098     3.066     0.200
    99.120     2.782     0.200
    99.191     2.765     0.200
    99.206     4.110     0.200
    99.212     2.671     0.200
    99.215     2.457     0.200
    99.239     2.851     0.200
    99.247     3.451     0.200
    99.273     3.321     0.200
    99.291     4.243     0.200
    99.315     2.209     0.200
    99.319     3.192     0.200
    99.324     2.540     0.200
    99.324     1.949     0.200
    99.328     0.955     0.200
    99.328     2.656     0.200
    99.324     1.729     0.200
    99.324     2.829     0.200
    99.324     3.170     0.200
    99.329     2.650     0.200
    99.328     3.054     0.200
    99.398     2.111     0.200
    99.398     3.051     0.200
    99.398     1.641     0.200
    99.409     2.900     0.200
    26.995   203.078     0.200
    46.847    96.139     0.200
    46.847    93.874     0.200
    27.021   204.798     0.200
    27.228   202.368     0.200
    57.423    56.391     0.200
    57.423    56.071     0.200
    97.464     3.183     0.200
    98.377     3.399     0.200
    99.471     2.222     0.200
    46.675    95.075     0.200
    99.267     1.901     0.200
    27.036   203.478     0.200
    99.278     4.430     0.200
    26.498   206.603     0.200
    26.751   205.219     0.200
    46.398    96.333     0.200
    51.312    75.385     0.200
    56.924    57.306     0.200
    27.588   199.664     0.200
    57.805    54.591     0.200
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,green+a0.+jBL << EOF
    12.000    -8.500 PcP in green
EOF
gmt text $proj $reg -F+f10p,Helvetica-Bold,red+a0.+jBL << EOF
    12.000    -9.500 Pdiff in red
EOF
gmt end
