#!/bin/bash
gmt begin acapulco7.51_tt1_summary pdf,ps
proj=-JX12/16
reg=-R0/180/0/1500
gmt basemap $proj $reg -Bxa30f10+l'Epicentral Distance (deg)' -Bya200f100+l'Travel Time (s)' -BWeSn+t'Summary Travel Times acapulco7.51'
gmt plot $proj $reg -Wthick,red  << EOF
    25.000   320.333
    25.500   324.873
    26.000   329.402
    26.500   333.919
    27.000   338.423
    27.500   342.910
    28.000   347.377
    28.500   351.830
    29.000   356.272
    29.500   360.707
    30.000   365.133
    30.500   369.552
    31.000   373.963
    31.500   378.366
    32.000   382.761
    32.500   387.146
    33.000   391.520
    33.500   395.880
    34.000   400.227
    34.500   404.559
    35.000   408.875
    35.500   413.176
    36.000   417.463
    36.500   421.734
    37.000   425.989
    37.500   430.229
    38.000   434.453
    38.500   438.661
    39.000   442.852
    39.500   447.026
    40.000   451.183
    40.500   455.323
    41.000   459.446
    41.500   463.552
    42.000   467.641
    42.500   471.712
    43.000   475.766
    43.500   479.803
    44.000   483.822
    44.500   487.823
    45.000   491.806
    45.500   495.772
    46.000   499.719
    46.500   503.648
    47.000   507.560
    47.500   511.453
    48.000   515.328
    48.500   519.185
    49.000   523.024
    49.500   526.845
    50.000   530.647
    50.500   534.431
    51.000   538.197
    51.500   541.945
    52.000   545.675
    52.500   549.387
    53.000   553.081
    53.500   556.757
    54.000   560.415
    54.500   564.055
    55.000   567.676
    55.500   571.279
    56.000   574.864
    56.500   578.430
    57.000   581.977
    57.500   585.507
    58.000   589.019
    58.500   592.512
    59.000   595.988
    59.500   599.445
    60.000   602.883
    60.500   606.304
    61.000   609.706
    61.500   613.089
    62.000   616.455
    62.500   619.802
    63.000   623.132
    63.500   626.443
    64.000   629.737
    64.500   633.013
    65.000   636.271
    65.500   639.511
    66.000   642.733
    66.500   645.937
    67.000   649.123
    67.500   652.291
    68.000   655.440
    68.500   658.572
    69.000   661.685
    69.500   664.780
    70.000   667.857
    70.500   670.916
    71.000   673.957
    71.500   676.980
    72.000   679.985
    72.500   682.971
    73.000   685.939
    73.500   688.889
    74.000   691.820
    74.500   694.732
    75.000   697.625
    75.500   700.500
    76.000   703.356
    76.500   706.195
    77.000   709.015
    77.500   711.818
    78.000   714.602
    78.500   717.368
    79.000   720.116
    79.500   722.846
    80.000   725.556
    80.500   728.248
    81.000   730.921
    81.500   733.574
    82.000   736.208
    82.500   738.823
    83.000   741.420
    83.500   743.998
    84.000   746.556
    84.500   749.094
    85.000   751.612
    85.500   754.109
    86.000   756.589
    86.500   759.051
    87.000   761.494
    87.500   763.914
    88.000   766.298
    88.500   768.663
    89.000   771.016
    89.500   773.360
    90.000   775.697
    90.500   778.028
    91.000   780.352
    91.500   782.671
    92.000   784.985
    92.500   787.295
    93.000   789.602
    93.500   791.905
    94.000   794.205
    94.500   796.500
    95.000   798.789
    95.500   801.073
    96.000   803.350
    96.500   805.621
    97.000   807.886
    97.500   810.143
    98.000   812.394
    98.500   814.637
    99.000   816.873
    99.500   819.100
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   115.500  1118.007
   116.000  1118.969
   116.500  1119.931
   117.000  1120.893
   117.500  1121.855
   118.000  1122.817
   118.500  1123.779
   119.000  1124.740
   119.500  1125.702
   120.000  1126.663
   120.500  1127.624
   121.000  1128.585
   121.500  1129.546
   122.000  1130.506
   122.500  1131.466
   123.000  1132.425
   123.500  1133.384
   124.000  1134.343
   124.500  1135.301
   125.000  1136.259
   125.500  1137.216
   126.000  1138.172
   126.500  1139.128
   127.000  1140.083
   127.500  1141.038
   128.000  1141.991
   128.500  1142.944
   129.000  1143.896
   129.500  1144.847
   130.000  1145.797
   130.500  1146.745
   131.000  1147.693
   131.500  1148.639
   132.000  1149.584
   132.500  1150.528
   133.000  1151.470
   133.500  1152.410
   134.000  1153.349
   134.500  1154.286
   135.000  1155.221
   135.500  1156.154
   136.000  1157.085
   136.500  1158.014
   137.000  1158.940
   137.500  1159.864
   138.000  1160.785
   138.500  1161.704
   139.000  1162.620
   139.500  1163.532
   140.000  1164.442
   140.500  1165.347
   141.000  1166.250
   141.500  1167.148
   142.000  1168.043
   142.500  1168.933
   143.000  1169.819
   143.500  1170.700
   144.000  1171.576
   144.500  1172.447
   145.000  1173.312
   145.500  1174.172
   146.000  1175.025
   146.500  1175.873
   147.000  1176.713
   147.500  1177.547
   148.000  1178.374
   148.500  1179.193
   149.000  1180.004
   149.500  1180.807
   150.000  1181.599
   150.500  1182.382
   151.000  1183.155
   151.500  1183.918
   152.000  1184.671
   152.500  1185.414
   153.000  1186.147
   153.500  1186.870
   154.000  1187.582
   154.500  1188.283
   155.000  1188.973
   155.500  1189.652
   156.000  1190.318
   156.500  1190.974
   157.000  1191.617
   157.500  1192.248
   158.000  1192.867
   158.500  1193.473
   159.000  1194.067
   159.500  1194.648
   160.000  1195.216
   160.500  1195.771
   161.000  1196.313
   161.500  1196.842
   162.000  1197.358
   162.500  1197.860
   163.000  1198.350
   163.500  1198.825
   164.000  1199.287
   164.500  1199.735
   165.000  1200.169
   165.500  1200.590
   166.000  1200.996
   166.500  1201.389
   167.000  1201.768
   167.500  1202.133
   168.000  1202.484
   168.500  1202.821
   169.000  1203.143
   169.500  1203.452
   170.000  1203.746
   170.500  1204.026
   171.000  1204.292
   171.500  1204.544
   172.000  1204.781
   172.500  1205.004
   173.000  1205.213
   173.500  1205.407
   174.000  1205.588
   174.500  1205.753
   175.000  1205.905
   175.500  1206.042
   176.000  1206.164
   176.500  1206.272
   177.000  1206.366
   177.500  1206.445
   178.000  1206.510
   178.500  1206.561
   179.000  1206.597
   179.500  1206.619
   180.000  1206.626
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   988.924
     1.000   988.933
     1.500   988.947
     2.000   988.966
     2.500   988.992
     3.000   989.022
     3.500   989.059
     4.000   989.101
     4.500   989.148
     5.000   989.201
     5.500   989.260
     6.000   989.324
     6.500   989.394
     7.000   989.470
     7.500   989.551
     8.000   989.638
     8.500   989.730
     9.000   989.828
     9.500   989.931
    10.000   990.040
    10.500   990.154
    11.000   990.274
    11.500   990.400
    12.000   990.531
    12.500   990.668
    13.000   990.810
    13.500   990.958
    14.000   991.111
    14.500   991.270
    15.000   991.434
    15.500   991.604
    16.000   991.779
    16.500   991.960
    17.000   992.146
    17.500   992.338
    18.000   992.535
    18.500   992.738
    19.000   992.946
    19.500   993.160
    20.000   993.379
    20.500   993.604
    21.000   993.834
    21.500   994.069
    22.000   994.310
    22.500   994.556
    23.000   994.808
    23.500   995.065
    24.000   995.328
    24.500   995.595
    25.000   995.869
    25.500   996.147
    26.000   996.431
    26.500   996.720
    27.000   997.015
    27.500   997.315
    28.000   997.620
    28.500   997.930
    29.000   998.246
    29.500   998.567
    30.000   998.893
    30.500   999.225
    31.000   999.562
    31.500   999.904
    32.000  1000.251
    32.500  1000.604
    33.000  1000.961
    33.500  1001.324
    34.000  1001.692
    34.500  1002.066
    35.000  1002.444
    35.500  1002.827
    36.000  1003.216
    36.500  1003.610
    37.000  1004.008
    37.500  1004.412
    38.000  1004.821
    38.500  1005.235
    39.000  1005.654
    39.500  1006.078
    40.000  1006.508
    40.500  1006.942
    41.000  1007.381
    41.500  1007.825
    42.000  1008.274
    42.500  1008.728
    43.000  1009.187
    43.500  1009.651
    44.000  1010.119
    44.500  1010.593
    45.000  1011.071
    45.500  1011.555
    46.000  1012.043
    46.500  1012.536
    47.000  1013.033
    47.500  1013.536
    48.000  1014.043
    48.500  1014.555
    49.000  1015.072
    49.500  1015.594
    50.000  1016.120
    50.500  1016.651
    51.000  1017.186
    51.500  1017.727
    52.000  1018.271
    52.500  1018.821
    53.000  1019.375
    53.500  1019.934
    54.000  1020.497
    54.500  1021.064
    55.000  1021.637
    55.500  1022.214
    56.000  1022.795
    56.500  1023.381
    57.000  1023.971
    57.500  1024.566
    58.000  1025.165
    58.500  1025.768
    59.000  1026.376
    59.500  1026.988
    60.000  1027.605
    60.500  1028.225
    61.000  1028.851
    61.500  1029.480
    62.000  1030.114
    62.500  1030.752
    63.000  1031.394
    63.500  1032.040
    64.000  1032.691
    64.500  1033.346
    65.000  1034.005
    65.500  1034.667
    66.000  1035.335
    66.500  1036.006
    67.000  1036.681
    67.500  1037.360
    68.000  1038.044
    68.500  1038.731
    69.000  1039.422
    69.500  1040.117
    70.000  1040.817
    70.500  1041.520
    71.000  1042.227
    71.500  1042.938
    72.000  1043.652
    72.500  1044.371
    73.000  1045.093
    73.500  1045.819
    74.000  1046.549
    74.500  1047.283
    75.000  1048.020
    75.500  1048.761
    76.000  1049.506
    76.500  1050.255
    77.000  1051.006
    77.500  1051.762
    78.000  1052.521
    78.500  1053.284
    79.000  1054.051
    79.500  1054.820
    80.000  1055.594
    80.500  1056.371
    81.000  1057.151
    81.500  1057.935
    82.000  1058.722
    82.500  1059.512
    83.000  1060.306
    83.500  1061.104
    84.000  1061.904
    84.500  1062.708
    85.000  1063.515
    85.500  1064.326
    86.000  1065.139
    86.500  1065.956
    87.000  1066.776
    87.500  1067.599
    88.000  1068.426
    88.500  1069.255
    89.000  1070.088
    89.500  1070.923
    90.000  1071.762
    90.500  1072.603
    91.000  1073.448
    91.500  1074.296
    92.000  1075.146
    92.500  1076.000
    93.000  1076.856
    93.500  1077.715
    94.000  1078.577
    94.500  1079.442
    95.000  1080.310
    95.500  1081.181
    96.000  1082.054
    96.500  1082.930
    97.000  1083.809
    97.500  1084.690
    98.000  1085.574
    98.500  1086.461
    99.000  1087.350
    99.500  1088.242
   100.000  1089.136
   100.500  1090.033
   101.000  1090.933
   101.500  1091.835
   102.000  1092.740
   102.500  1093.646
   103.000  1094.556
   103.500  1095.468
   104.000  1096.382
   104.500  1097.298
   105.000  1098.217
   105.500  1099.138
   106.000  1100.062
   106.500  1100.987
   107.000  1101.915
   107.500  1102.845
   108.000  1103.778
   108.500  1104.712
   109.000  1105.649
   109.500  1106.587
   110.000  1107.528
   110.500  1108.471
   111.000  1109.416
   111.500  1110.363
   112.000  1111.311
   112.500  1112.262
   113.000  1113.215
   113.500  1114.170
   114.000  1115.126
   114.500  1116.085
   115.000  1117.045
   115.500  1118.007
   116.000  1118.971
   116.500  1119.937
   117.000  1120.904
   117.500  1121.873
   118.000  1122.844
   118.500  1123.817
   119.000  1124.791
   119.500  1125.767
   120.000  1126.744
   120.500  1127.723
   121.000  1128.704
   121.500  1129.686
   122.000  1130.669
   122.500  1131.654
   123.000  1132.641
   123.500  1133.629
   124.000  1134.618
   124.500  1135.609
   125.000  1136.601
   125.500  1137.595
   126.000  1138.590
   126.500  1139.586
   127.000  1140.583
   127.500  1141.582
   128.000  1142.582
   128.500  1143.583
   129.000  1144.585
   129.500  1145.588
   130.000  1146.593
   130.500  1147.599
   131.000  1148.605
   131.500  1149.613
   132.000  1150.622
   132.500  1151.632
   133.000  1152.642
   133.500  1153.654
   134.000  1154.667
   134.500  1155.681
   135.000  1156.695
   135.500  1157.711
   136.000  1158.727
   136.500  1159.744
   137.000  1160.762
   137.500  1161.781
   138.000  1162.800
   138.500  1163.821
   139.000  1164.842
   139.500  1165.863
   140.000  1166.886
   140.500  1167.909
   141.000  1168.932
   141.500  1169.957
   142.000  1170.981
   142.500  1172.007
   143.000  1173.033
   143.500  1174.059
   144.000  1175.086
   144.500  1176.114
   145.000  1177.141
   145.500  1178.170
   146.000  1179.199
   146.500  1180.228
   147.000  1181.257
   147.500  1182.287
   148.000  1183.317
   148.500  1184.348
   149.000  1185.379
   149.500  1186.410
   150.000  1187.441
   150.500  1188.473
   151.000  1189.504
   151.500  1190.536
   152.000  1191.568
   152.500  1192.600
   153.000  1193.633
   153.500  1194.665
   154.000  1195.698
   154.500  1196.730
   155.000  1197.763
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1172.688
   145.500  1174.519
   146.000  1176.403
   146.500  1178.324
   147.000  1180.271
   147.500  1182.242
   148.000  1184.232
   148.500  1186.239
   149.000  1188.262
   149.500  1190.299
   150.000  1192.348
   150.500  1194.409
   151.000  1196.480
   151.500  1198.560
   152.000  1200.650
   152.500  1202.748
   153.000  1204.853
   153.500  1206.966
   154.000  1209.086
   154.500  1211.213
   155.000  1213.345
   155.500  1215.483
   156.000  1217.626
   156.500  1219.774
   157.000  1221.927
   157.500  1224.085
   158.000  1226.247
   158.500  1228.412
   159.000  1230.582
   159.500  1232.755
   160.000  1234.932
   160.500  1237.112
   161.000  1239.295
   161.500  1241.481
   162.000  1243.669
   162.500  1245.860
   163.000  1248.054
   163.500  1250.249
   164.000  1252.447
   164.500  1254.647
   165.000  1256.849
   165.500  1259.052
   166.000  1261.257
   166.500  1263.464
   167.000  1265.673
   167.500  1267.883
   168.000  1270.094
   168.500  1272.306
   169.000  1274.520
   169.500  1276.734
   170.000  1278.950
   170.500  1281.166
   171.000  1283.383
   171.500  1285.602
   172.000  1287.820
   172.500  1290.040
   173.000  1292.260
   173.500  1294.481
   174.000  1296.702
   174.500  1298.923
   175.000  1301.145
   175.500  1303.367
   176.000  1305.589
   176.500  1307.812
   177.000  1310.034
   177.500  1312.257
   178.000  1314.480
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   145.000  1172.677
   145.500  1174.293
   146.000  1175.835
   146.500  1177.321
   147.000  1178.757
   147.500  1180.148
   148.000  1181.497
   148.500  1182.806
   149.000  1184.082
   149.500  1185.328
   150.000  1186.550
   150.500  1187.750
   151.000  1188.928
   151.500  1190.088
   152.000  1191.229
   152.500  1192.353
   153.000  1193.461
   153.500  1194.554
   154.000  1195.635
   154.500  1196.702
   155.000  1197.756
EOF
gmt plot $proj $reg -Wthick,red  << EOF
     0.500   505.800
     1.000   505.836
     1.500   505.896
     2.000   505.980
     2.500   506.088
     3.000   506.220
     3.500   506.377
     4.000   506.557
     4.500   506.760
     5.000   506.988
     5.500   507.240
     6.000   507.515
     6.500   507.814
     7.000   508.137
     7.500   508.483
     8.000   508.853
     8.500   509.247
     9.000   509.663
     9.500   510.103
    10.000   510.566
    10.500   511.053
    11.000   511.562
    11.500   512.095
    12.000   512.650
    12.500   513.228
    13.000   513.828
    13.500   514.451
    14.000   515.097
    14.500   515.764
    15.000   516.454
    15.500   517.166
    16.000   517.900
    16.500   518.656
    17.000   519.433
    17.500   520.232
    18.000   521.052
    18.500   521.893
    19.000   522.756
    19.500   523.639
    20.000   524.544
    20.500   525.469
    21.000   526.414
    21.500   527.379
    22.000   528.365
    22.500   529.371
    23.000   530.397
    23.500   531.442
    24.000   532.507
    24.500   533.591
    25.000   534.694
    25.500   535.816
    26.000   536.957
    26.500   538.117
    27.000   539.295
    27.500   540.492
    28.000   541.706
    28.500   542.939
    29.000   544.189
    29.500   545.457
    30.000   546.742
    30.500   548.044
    31.000   549.363
    31.500   550.699
    32.000   552.052
    32.500   553.421
    33.000   554.806
    33.500   556.208
    34.000   557.625
    34.500   559.058
    35.000   560.507
    35.500   561.971
    36.000   563.450
    36.500   564.944
    37.000   566.453
    37.500   567.976
    38.000   569.513
    38.500   571.065
    39.000   572.631
    39.500   574.211
    40.000   575.804
    40.500   577.411
    41.000   579.031
    41.500   580.664
    42.000   582.311
    42.500   583.969
    43.000   585.641
    43.500   587.325
    44.000   589.021
    44.500   590.728
    45.000   592.448
    45.500   594.180
    46.000   595.923
    46.500   597.677
    47.000   599.442
    47.500   601.219
    48.000   603.006
    48.500   604.803
    49.000   606.611
    49.500   608.430
    50.000   610.259
    50.500   612.097
    51.000   613.945
    51.500   615.803
    52.000   617.671
    52.500   619.547
    53.000   621.433
    53.500   623.328
    54.000   625.231
    54.500   627.144
    55.000   629.064
    55.500   630.993
    56.000   632.931
    56.500   634.876
    57.000   636.829
    57.500   638.790
    58.000   640.759
    58.500   642.735
    59.000   644.719
    59.500   646.709
    60.000   648.707
    60.500   650.711
    61.000   652.722
    61.500   654.740
    62.000   656.765
    62.500   658.795
    63.000   660.832
    63.500   662.875
    64.000   664.924
    64.500   666.979
    65.000   669.040
    65.500   671.106
    66.000   673.177
    66.500   675.254
    67.000   677.336
    67.500   679.423
    68.000   681.515
    68.500   683.612
    69.000   685.714
    69.500   687.820
    70.000   689.931
    70.500   692.046
    71.000   694.166
    71.500   696.289
    72.000   698.417
    72.500   700.549
    73.000   702.684
    73.500   704.824
    74.000   706.967
    74.500   709.113
    75.000   711.263
    75.500   713.416
    76.000   715.573
    76.500   717.732
    77.000   719.895
    77.500   722.061
    78.000   724.229
    78.500   726.401
    79.000   728.575
    79.500   730.752
    80.000   732.931
    80.500   735.112
    81.000   737.296
    81.500   739.483
    82.000   741.671
    82.500   743.862
    83.000   746.054
    83.500   748.249
    84.000   750.445
    84.500   752.643
    85.000   754.843
    85.500   757.045
    86.000   759.248
    86.500   761.453
    87.000   763.659
    87.500   765.866
    88.000   768.075
    88.500   770.285
    89.000   772.496
    89.500   774.709
    90.000   776.922
    90.500   779.136
    91.000   781.352
    91.500   783.568
    92.000   785.785
    92.500   788.003
    93.000   790.221
    93.500   792.440
    94.000   794.660
    94.500   796.880
    95.000   799.101
    95.500   801.322
    96.000   803.543
    96.500   805.765
    97.000   807.987
    97.500   810.210
    98.000   812.432
    98.500   814.655
    99.000   816.878
    99.500   819.100
EOF
gmt plot $proj $reg -Wthick,red  << EOF
    28.000   410.945
    28.500   416.502
    29.000   422.060
    29.500   427.616
    30.000   433.172
    30.500   438.727
    31.000   444.280
    31.500   449.831
    32.000   455.380
    32.500   460.926
    33.000   466.469
    33.500   472.009
    34.000   477.545
    34.500   483.077
    35.000   488.604
    35.500   494.125
    36.000   499.641
    36.500   505.151
    37.000   510.654
    37.500   516.149
    38.000   521.637
    38.500   527.116
    39.000   532.586
    39.500   538.046
    40.000   543.496
    40.500   548.936
    41.000   554.364
    41.500   559.780
    42.000   565.184
    42.500   570.574
    43.000   575.951
    43.500   581.315
    44.000   586.663
    44.500   591.997
    45.000   597.315
    45.500   602.617
    46.000   607.903
    46.500   613.173
    47.000   618.387
    47.500   622.961
    48.000   627.530
    48.500   632.095
    49.000   636.655
    49.500   641.211
    50.000   645.761
    50.500   650.305
    51.000   654.845
    51.500   659.379
    52.000   663.907
    52.500   668.430
    53.000   672.947
    53.500   677.457
    54.000   681.960
    54.500   686.455
    55.000   690.941
    55.500   695.416
    56.000   699.881
    56.500   704.339
    57.000   708.791
    57.500   713.238
    58.000   717.680
    58.500   722.118
    59.000   726.552
    59.500   730.981
    60.000   735.407
    60.500   739.829
    61.000   744.247
    61.500   748.662
    62.000   753.073
    62.500   757.479
    63.000   761.882
    63.500   766.280
    64.000   770.675
    64.500   775.064
    65.000   779.449
    65.500   783.828
    66.000   788.201
    66.500   792.567
    67.000   796.927
    67.500   801.280
    68.000   805.626
    68.500   809.964
    69.000   814.294
    69.500   818.617
    70.000   822.932
    70.500   827.240
    71.000   831.541
    71.500   835.833
    72.000   840.119
    72.500   844.396
    73.000   848.666
    73.500   852.928
    74.000   857.183
    74.500   861.429
    75.000   865.668
    75.500   869.899
    76.000   874.121
    76.500   878.336
    77.000   882.542
    77.500   886.740
    78.000   890.930
    78.500   895.111
    79.000   899.284
    79.500   903.448
    80.000   907.604
    80.500   911.751
    81.000   915.890
    81.500   920.020
    82.000   924.141
    82.500   928.254
    83.000   932.359
    83.500   936.455
    84.000   940.543
    84.500   944.621
    85.000   948.692
    85.500   952.753
    86.000   956.806
    86.500   960.850
    87.000   964.885
    87.500   968.911
    88.000   972.928
    88.500   976.937
    89.000   980.937
    89.500   984.927
    90.000   988.909
    90.500   992.882
    91.000   996.845
    91.500  1000.800
    92.000  1004.746
    92.500  1008.683
    93.000  1012.610
    93.500  1016.529
    94.000  1020.439
    94.500  1024.339
    95.000  1028.231
    95.500  1032.114
    96.000  1035.987
    96.500  1039.851
    97.000  1043.707
    97.500  1047.553
    98.000  1051.390
    98.500  1055.218
    99.000  1059.037
    99.500  1062.847
   100.000  1066.648
   100.500  1070.439
   101.000  1074.221
   101.500  1077.995
   102.000  1081.759
   102.500  1085.513
   103.000  1089.259
   103.500  1092.996
   104.000  1096.724
   104.500  1100.443
   105.000  1104.153
   105.500  1107.854
   106.000  1111.547
   106.500  1115.230
   107.000  1118.905
   107.500  1122.570
   108.000  1126.226
   108.500  1129.874
   109.000  1133.511
   109.500  1137.140
   110.000  1140.759
   110.500  1144.370
   111.000  1147.970
   111.500  1151.562
   112.000  1155.144
   112.500  1158.718
   113.000  1162.281
   113.500  1165.837
   114.000  1169.382
   114.500  1172.919
   115.000  1176.447
   115.500  1179.965
   116.000  1183.475
   116.500  1186.976
   117.000  1190.467
   117.500  1193.950
   118.000  1197.423
   118.500  1200.887
   119.000  1204.342
   119.500  1207.788
   120.000  1211.224
   120.500  1214.652
   121.000  1218.070
   121.500  1221.479
   122.000  1224.879
   122.500  1228.269
   123.000  1231.651
   123.500  1235.023
   124.000  1238.386
   124.500  1241.741
   125.000  1245.086
   125.500  1248.422
   126.000  1251.749
   126.500  1255.068
   127.000  1258.377
   127.500  1261.678
   128.000  1264.969
   128.500  1268.252
   129.000  1271.526
   129.500  1274.791
   130.000  1278.046
   130.500  1281.293
   131.000  1284.531
   131.500  1287.760
   132.000  1290.980
   132.500  1294.190
   133.000  1297.392
   133.500  1300.585
   134.000  1303.768
   134.500  1306.943
   135.000  1310.108
   135.500  1313.265
   136.000  1316.412
   136.500  1319.550
   137.000  1322.679
   137.500  1325.800
   138.000  1328.911
   138.500  1332.013
   139.000  1335.105
   139.500  1338.189
   140.000  1341.264
   140.500  1344.330
   141.000  1347.386
   141.500  1350.434
   142.000  1353.472
   142.500  1356.502
   143.000  1359.522
   143.500  1362.533
   144.000  1365.536
   144.500  1368.529
   145.000  1371.513
   145.500  1374.488
   146.000  1377.453
   146.500  1380.409
   147.000  1383.356
   147.500  1386.294
   148.000  1389.222
   148.500  1392.141
   149.000  1395.050
   149.500  1397.950
   150.000  1400.841
EOF
gmt plot $proj $reg -Wthick,red  << EOF
   100.000   821.323
   100.500   823.546
   101.000   825.769
   101.500   827.992
   102.000   830.215
   102.500   832.437
   103.000   834.660
   103.500   836.883
   104.000   839.106
   104.500   841.329
   105.000   843.552
   105.500   845.774
   106.000   847.997
   106.500   850.220
   107.000   852.443
   107.500   854.666
   108.000   856.889
   108.500   859.111
   109.000   861.334
   109.500   863.557
   110.000   865.780
   110.500   868.003
   111.000   870.226
   111.500   872.448
   112.000   874.671
   112.500   876.894
   113.000   879.117
   113.500   881.340
   114.000   883.563
   114.500   885.785
   115.000   888.008
   115.500   890.231
   116.000   892.454
   116.500   894.677
   117.000   896.900
   117.500   899.122
   118.000   901.345
   118.500   903.568
   119.000   905.791
   119.500   908.014
   120.000   910.237
   120.500   912.459
   121.000   914.682
   121.500   916.905
   122.000   919.128
   122.500   921.351
   123.000   923.574
   123.500   925.797
   124.000   928.019
   124.500   930.242
   125.000   932.465
   125.500   934.688
   126.000   936.911
   126.500   939.133
   127.000   941.356
   127.500   943.579
   128.000   945.802
   128.500   948.025
   129.000   950.248
   129.500   952.470
   130.000   954.693
   130.500   956.916
   131.000   959.139
   131.500   961.362
   132.000   963.585
   132.500   965.807
   133.000   968.030
   133.500   970.253
   134.000   972.476
   134.500   974.699
   135.000   976.922
   135.500   979.145
   136.000   981.367
   136.500   983.590
   137.000   985.813
   137.500   988.036
   138.000   990.259
   138.500   992.481
   139.000   994.704
   139.500   996.927
   140.000   999.150
   140.500  1001.373
   141.000  1003.596
   141.500  1005.819
   142.000  1008.041
   142.500  1010.264
   143.000  1012.487
   143.500  1014.710
   144.000  1016.933
   144.500  1019.156
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    14.500   380.623
    15.000   390.860
    15.500   401.092
    16.000   411.316
    16.500   421.528
    17.000   431.724
    17.500   441.899
    18.000   452.050
    18.500   462.170
    19.000   472.218
    19.500   482.296
    20.000   492.290
    20.500   502.230
    21.000   512.110
    21.500   521.926
    22.000   531.672
    22.500   541.334
    23.000   549.500
    23.500   557.633
    24.000   565.733
    24.500   573.798
    25.000   581.813
    25.500   589.745
    26.000   597.653
    26.500   605.550
    27.000   613.439
    27.500   621.321
    28.000   629.196
    28.500   637.065
    29.000   644.927
    29.500   652.782
    30.000   660.630
    30.500   668.469
    31.000   676.298
    31.500   684.115
    32.000   691.919
    32.500   699.709
    33.000   707.483
    33.500   715.239
    34.000   722.978
    34.500   730.698
    35.000   738.399
    35.500   746.081
    36.000   753.742
    36.500   761.384
    37.000   769.005
    37.500   776.606
    38.000   784.185
    38.500   791.742
    39.000   799.278
    39.500   806.790
    40.000   814.280
    40.500   821.747
    41.000   829.190
    41.500   836.610
    42.000   844.005
    42.500   851.377
    43.000   858.724
    43.500   866.047
    44.000   873.344
    44.500   880.617
    45.000   887.865
    45.500   895.087
    46.000   902.284
    46.500   909.455
    47.000   916.599
    47.500   923.718
    48.000   930.809
    48.500   937.874
    49.000   944.912
    49.500   951.922
    50.000   958.906
    50.500   965.863
    51.000   972.793
    51.500   979.695
    52.000   986.569
    52.500   993.416
    53.000  1000.236
    53.500  1007.030
    54.000  1013.798
    54.500  1020.540
    55.000  1027.255
    55.500  1033.943
    56.000  1040.603
    56.500  1047.236
    57.000  1053.841
    57.500  1060.417
    58.000  1066.965
    58.500  1073.486
    59.000  1079.979
    59.500  1086.445
    60.000  1092.883
    60.500  1099.293
    61.000  1105.675
    61.500  1112.030
    62.000  1118.355
    62.500  1124.653
    63.000  1130.922
    63.500  1137.163
    64.000  1143.375
    64.500  1149.559
    65.000  1155.715
    65.500  1161.843
    66.000  1167.942
    66.500  1174.013
    67.000  1180.056
    67.500  1186.071
    68.000  1192.056
    68.500  1198.014
    69.000  1203.942
    69.500  1209.842
    70.000  1215.713
    70.500  1221.556
    71.000  1227.370
    71.500  1233.155
    72.000  1238.910
    72.500  1244.637
    73.000  1250.333
    73.500  1256.000
    74.000  1261.636
    74.500  1267.243
    75.000  1272.820
    75.500  1278.367
    76.000  1283.886
    76.500  1289.375
    77.000  1294.834
    77.500  1300.264
    78.000  1305.663
    78.500  1311.031
    79.000  1316.370
    79.500  1321.680
    80.000  1326.960
    80.500  1332.211
    81.000  1337.431
    81.500  1342.621
    82.000  1347.778
    82.500  1352.903
    83.000  1357.997
    83.500  1363.059
    84.000  1368.091
    84.500  1373.091
    85.000  1378.060
    85.500  1382.998
    86.000  1387.904
    86.500  1392.779
    87.000  1397.621
    87.500  1402.430
    88.000  1407.206
    88.500  1411.950
    89.000  1416.660
    89.500  1421.336
    90.000  1425.979
    90.500  1430.589
    91.000  1435.164
    91.500  1439.706
    92.000  1444.214
    92.500  1448.688
    93.000  1453.128
    93.500  1457.534
    94.000  1461.917
    94.500  1466.283
    95.000  1470.636
    95.500  1474.978
    96.000  1479.308
    96.500  1483.624
    97.000  1487.924
    97.500  1492.203
    98.000  1496.462
    98.500  1500.701
    99.000  1504.922
    99.500  1509.121
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   713.815
     1.000   713.862
     1.500   713.940
     2.000   714.049
     2.500   714.189
     3.000   714.360
     3.500   714.562
     4.000   714.796
     4.500   715.060
     5.000   715.355
     5.500   715.681
     6.000   716.037
     6.500   716.424
     7.000   716.842
     7.500   717.290
     8.000   717.769
     8.500   718.277
     9.000   718.816
     9.500   719.385
    10.000   719.983
    10.500   720.611
    11.000   721.269
    11.500   721.956
    12.000   722.672
    12.500   723.417
    13.000   724.192
    13.500   724.994
    14.000   725.826
    14.500   726.685
    15.000   727.573
    15.500   728.488
    16.000   729.431
    16.500   730.402
    17.000   731.400
    17.500   732.424
    18.000   733.476
    18.500   734.554
    19.000   735.658
    19.500   736.789
    20.000   737.945
    20.500   739.126
    21.000   740.333
    21.500   741.565
    22.000   742.822
    22.500   744.103
    23.000   745.408
    23.500   746.737
    24.000   748.090
    24.500   749.466
    25.000   750.865
    25.500   752.287
    26.000   753.731
    26.500   755.197
    27.000   756.685
    27.500   758.195
    28.000   759.726
    28.500   761.278
    29.000   762.850
    29.500   764.443
    30.000   766.055
    30.500   767.687
    31.000   769.339
    31.500   771.009
    32.000   772.698
    32.500   774.405
    33.000   776.131
    33.500   777.874
    34.000   779.634
    34.500   781.411
    35.000   783.206
    35.500   785.016
    36.000   786.842
    36.500   788.684
    37.000   790.542
    37.500   792.414
    38.000   794.301
    38.500   796.202
    39.000   798.118
    39.500   800.046
    40.000   801.989
    40.500   803.944
    41.000   805.912
    41.500   807.892
    42.000   809.884
    42.500   811.888
    43.000   813.903
    43.500   815.929
    44.000   817.966
    44.500   820.013
    45.000   822.070
    45.500   824.137
    46.000   826.213
    46.500   828.298
    47.000   830.392
    47.500   832.494
    48.000   834.604
    48.500   836.722
    49.000   838.847
    49.500   840.980
    50.000   843.119
    50.500   845.265
    51.000   847.417
    51.500   849.575
    52.000   851.739
    52.500   853.908
    53.000   856.082
    53.500   858.261
    54.000   860.444
    54.500   862.632
    55.000   864.824
    55.500   867.019
    56.000   869.217
    56.500   871.419
    57.000   873.624
    57.500   875.832
    58.000   878.042
    58.500   880.254
    59.000   882.468
    59.500   884.684
    60.000   886.902
    60.500   889.120
    61.000   891.340
    61.500   893.561
    62.000   895.783
    62.500   898.005
    63.000   900.228
    63.500   902.451
EOF
gmt plot $proj $reg -Wthick,green  << EOF
     0.500   925.869
     1.000   925.936
     1.500   926.046
     2.000   926.202
     2.500   926.401
     3.000   926.645
     3.500   926.933
     4.000   927.265
     4.500   927.641
     5.000   928.061
     5.500   928.525
     6.000   929.033
     6.500   929.585
     7.000   930.180
     7.500   930.819
     8.000   931.501
     8.500   932.227
     9.000   932.996
     9.500   933.807
    10.000   934.662
    10.500   935.559
    11.000   936.499
    11.500   937.481
    12.000   938.505
    12.500   939.571
    13.000   940.679
    13.500   941.829
    14.000   943.020
    14.500   944.252
    15.000   945.526
    15.500   946.839
    16.000   948.194
    16.500   949.588
    17.000   951.023
    17.500   952.497
    18.000   954.011
    18.500   955.565
    19.000   957.157
    19.500   958.788
    20.000   960.457
    20.500   962.164
    21.000   963.910
    21.500   965.693
    22.000   967.513
    22.500   969.370
    23.000   971.264
    23.500   973.195
    24.000   975.162
    24.500   977.164
    25.000   979.202
    25.500   981.275
    26.000   983.383
    26.500   985.526
    27.000   987.702
    27.500   989.913
    28.000   992.157
    28.500   994.435
    29.000   996.745
    29.500   999.088
    30.000  1001.464
    30.500  1003.871
    31.000  1006.310
    31.500  1008.780
    32.000  1011.281
    32.500  1013.813
    33.000  1016.375
    33.500  1018.967
    34.000  1021.588
    34.500  1024.239
    35.000  1026.918
    35.500  1029.627
    36.000  1032.363
    36.500  1035.127
    37.000  1037.919
    37.500  1040.738
    38.000  1043.584
    38.500  1046.457
    39.000  1049.356
    39.500  1052.280
    40.000  1055.230
    40.500  1058.206
    41.000  1061.206
    41.500  1064.231
    42.000  1067.280
    42.500  1070.353
    43.000  1073.449
    43.500  1076.569
    44.000  1079.712
    44.500  1082.877
    45.000  1086.064
    45.500  1089.274
    46.000  1092.505
    46.500  1095.757
    47.000  1099.031
    47.500  1102.325
    48.000  1105.639
    48.500  1108.974
    49.000  1112.328
    49.500  1115.702
    50.000  1119.095
    50.500  1122.506
    51.000  1125.937
    51.500  1129.385
    52.000  1132.852
    52.500  1136.336
    53.000  1139.838
    53.500  1143.357
    54.000  1146.892
    54.500  1150.444
    55.000  1154.013
    55.500  1157.597
    56.000  1161.197
    56.500  1164.812
    57.000  1168.443
    57.500  1172.089
    58.000  1175.749
    58.500  1179.423
    59.000  1183.112
    59.500  1186.814
    60.000  1190.530
    60.500  1194.260
    61.000  1198.002
    61.500  1201.757
    62.000  1205.525
    62.500  1209.305
    63.000  1213.098
    63.500  1216.902
    64.000  1220.717
    64.500  1224.544
    65.000  1228.383
    65.500  1232.232
    66.000  1236.092
    66.500  1239.962
    67.000  1243.842
    67.500  1247.733
    68.000  1251.633
    68.500  1255.543
    69.000  1259.463
    69.500  1263.391
    70.000  1267.328
    70.500  1271.275
    71.000  1275.229
    71.500  1279.192
    72.000  1283.163
    72.500  1287.142
    73.000  1291.129
    73.500  1295.124
    74.000  1299.125
    74.500  1303.134
    75.000  1307.150
    75.500  1311.173
    76.000  1315.202
    76.500  1319.238
    77.000  1323.280
    77.500  1327.328
    78.000  1331.382
    78.500  1335.441
    79.000  1339.506
    79.500  1343.577
    80.000  1347.653
    80.500  1351.734
    81.000  1355.819
    81.500  1359.910
    82.000  1364.005
    82.500  1368.105
    83.000  1372.208
    83.500  1376.316
    84.000  1380.428
    84.500  1384.544
    85.000  1388.663
    85.500  1392.786
    86.000  1396.912
    86.500  1401.042
    87.000  1405.175
    87.500  1409.310
    88.000  1413.449
    88.500  1417.590
    89.000  1421.733
    89.500  1425.880
    90.000  1430.028
    90.500  1434.179
    91.000  1438.331
    91.500  1442.486
    92.000  1446.642
    92.500  1450.801
    93.000  1454.960
    93.500  1459.122
    94.000  1463.284
    94.500  1467.448
    95.000  1471.613
    95.500  1475.779
    96.000  1479.946
    96.500  1484.113
    97.000  1488.281
    97.500  1492.450
    98.000  1496.620
    98.500  1500.789
    99.000  1504.959
    99.500  1509.130
EOF
gmt plot $proj $reg -Wthick,green  << EOF
    28.500   758.338
    29.000   768.577
    29.500   778.816
    30.000   789.054
    30.500   799.289
    31.000   809.522
    31.500   819.751
    32.000   829.975
    32.500   840.194
    33.000   850.406
    33.500   860.612
    34.000   870.808
    34.500   880.996
    35.000   891.173
    35.500   901.338
    36.000   911.490
    36.500   921.627
    37.000   931.749
    37.500   941.853
    38.000   951.939
    38.500   962.005
    39.000   972.049
    39.500   982.070
    40.000   992.066
    40.500  1002.036
    41.000  1011.978
    41.500  1021.891
    42.000  1031.774
    42.500  1041.625
    43.000  1051.443
    43.500  1061.227
    44.000  1070.975
    44.500  1080.687
    45.000  1090.362
    45.500  1099.219
    46.000  1107.384
    46.500  1115.532
    47.000  1123.663
    47.500  1131.778
    48.000  1139.877
    48.500  1147.959
    49.000  1156.022
    49.500  1164.064
    50.000  1172.078
    50.500  1180.047
    51.000  1187.970
    51.500  1195.884
    52.000  1203.791
    52.500  1211.693
    53.000  1219.590
    53.500  1227.482
    54.000  1235.371
    54.500  1243.256
    55.000  1251.138
    55.500  1259.016
    56.000  1266.891
    56.500  1274.762
    57.000  1282.630
    57.500  1290.495
    58.000  1298.357
    58.500  1306.215
    59.000  1314.070
    59.500  1321.921
    60.000  1329.769
    60.500  1337.612
    61.000  1345.450
    61.500  1353.284
    62.000  1361.113
    62.500  1368.935
    63.000  1376.752
    63.500  1384.562
    64.000  1392.366
    64.500  1400.162
    65.000  1407.951
    65.500  1415.732
    66.000  1423.505
    66.500  1431.270
    67.000  1439.025
    67.500  1446.772
    68.000  1454.510
    68.500  1462.238
    69.000  1469.958
    69.500  1477.667
    70.000  1485.367
EOF
gmt plot $proj $reg -Sx -Wthin -Gcyan  << EOF
     0.474     8.672     0.150
    20.830   290.672     0.150
    20.830   299.172     0.150
    21.848   300.371     0.150
    22.289   304.570     0.150
    22.635   309.172     0.150
    23.628   318.672     0.150
    23.806   319.973     0.150
    24.193   306.973     0.150
    24.130    45.750     0.150
    24.275   325.871     0.150
    27.517   355.672     0.150
    28.061   353.766     0.150
    28.347   654.172     0.150
    28.740   432.172     0.150
    29.050   665.172     0.150
    34.744   465.773     0.150
    34.744   495.973     0.150
    34.906   755.703     0.150
    36.681   423.172     0.150
    37.813   432.852     0.150
    45.264   955.172     0.150
    45.541   494.070     0.150
    55.825   617.172     0.150
    56.398   573.172     0.150
    57.908   812.082     0.150
    59.346   607.871     0.150
    59.561   625.473     0.150
    59.561   816.172     0.150
    63.338   654.973     0.150
    65.401    18.102     0.150
    66.780   658.070     0.150
    70.536   676.172     0.150
    70.536  1274.172     0.150
    74.931   717.570     0.150
    76.248   799.672     0.150
    76.407  1008.172     0.150
    76.407  1660.172     0.150
    76.407  1836.172     0.150
    77.743  1800.172     0.150
    79.841   924.172     0.150
    82.538   765.672     0.150
    83.286   791.172     0.150
    83.733   751.172     0.150
    83.733  1376.172     0.150
    84.908    41.500     0.150
    85.112  1076.172     0.150
    85.520  1073.172     0.150
    85.913   948.172     0.150
    85.951   759.172     0.150
    85.951    11.000     0.150
    85.951  1082.172     0.150
    85.951  1385.172     0.150
    85.951  1480.172     0.150
    86.097   780.172     0.150
    86.097   801.172     0.150
    86.453   804.172     0.150
    86.494   823.672     0.150
    87.954  1375.172     0.150
    89.079   773.871     0.150
    89.079  1105.172     0.150
    89.079  1410.172     0.150
    89.123   778.672     0.150
    89.799   778.672     0.150
    89.799  1108.172     0.150
    89.799  1350.172     0.150
    89.799   778.672     0.150
    89.799   778.672     0.150
    89.799   990.172     0.150
    89.799   990.172     0.150
    89.799  1108.172     0.150
    89.799  1350.172     0.150
    89.799  1415.172     0.150
    89.799  1500.172     0.150
    89.799  1795.172     0.150
    89.799   778.672     0.150
    89.799  1415.172     0.150
    90.060   779.172     0.150
    90.276   782.273     0.150
    90.276   992.172     0.150
    91.004   880.172     0.150
    91.004  1102.172     0.150
    91.004  2334.172     0.150
    91.004   784.172     0.150
    91.004  1436.172     0.150
    91.622   787.672     0.150
    91.622    11.500     0.150
    91.765  1410.172     0.150
    91.765   787.672     0.150
    91.765  1007.273     0.150
    91.765  1410.172     0.150
    92.447   791.172     0.150
    92.447  1012.973     0.150
    92.447  1447.672     0.150
    92.455  1413.273     0.150
    92.455   791.371     0.150
    92.455  1013.172     0.150
    92.455  1413.273     0.150
    93.346   847.773     0.150
    93.346   398.801     0.150
    93.346  1824.172     0.150
    93.344   794.172     0.150
    93.517   796.172     0.150
    93.517  1137.172     0.150
    93.517  1465.172     0.150
    93.814   797.773     0.150
    94.062   848.172     0.150
    94.117   881.973     0.150
    94.117   798.871     0.150
    94.117  1023.570     0.150
    94.125   793.492     0.150
    94.715   801.172     0.150
    94.715     9.301     0.150
    94.715  1031.871     0.150
    94.715  1556.172     0.150
    95.011  1571.973     0.150
    95.011   805.273     0.150
    95.011  1032.773     0.150
    95.973   806.172     0.150
    95.973  1476.172     0.150
    96.789   811.172     0.150
    96.789  1170.172     0.150
    96.789  1484.172     0.150
    97.024   812.273     0.150
    98.000   811.172     0.150
    97.931   825.172     0.150
    97.931  1416.172     0.150
    97.931  1460.172     0.150
    99.017   826.871     0.150
    99.138   824.172     0.150
    99.202   822.172     0.150
    99.202  1646.172     0.150
    99.325   827.172     0.150
   100.024   837.172     0.150
   100.024  1198.172     0.150
   100.024  2190.172     0.150
   100.090   866.672     0.150
   100.234   831.172     0.150
   100.279   830.172     0.150
   101.148   843.172     0.150
   101.274   830.172     0.150
   102.831   843.172     0.150
   104.706   846.172     0.150
   104.741   845.172     0.150
   105.392   849.172     0.150
   105.392  1240.172     0.150
   105.701   853.172     0.150
   105.701  1246.172     0.150
   105.701  1563.172     0.150
   105.701  2024.172     0.150
   106.724   875.273     0.150
   107.158   857.172     0.150
   107.151   864.172     0.150
   107.151  1552.172     0.150
   107.151  2284.172     0.150
   108.121   865.172     0.150
   108.217   862.172     0.150
   108.217  1269.473     0.150
   108.588  1268.172     0.150
   108.588  1760.672     0.150
   109.164   868.172     0.150
   109.164  1284.172     0.150
   109.520   872.172     0.150
   109.713   874.672     0.150
   109.734   874.172     0.150
   110.036   876.172     0.150
   110.036   876.473     0.150
   110.036  1284.172     0.150
   112.130   881.172     0.150
   112.130  1305.172     0.150
   112.130  1807.172     0.150
   112.434   883.172     0.150
   112.586   886.172     0.150
   112.718   883.172     0.150
   112.718  1748.172     0.150
   112.954  1808.172     0.150
   112.954  2364.172     0.150
   113.168   886.773     0.150
   113.168   886.773     0.150
   113.130  1113.172     0.150
   114.056   889.172     0.150
   114.056  1322.172     0.150
   114.056  1830.172     0.150
   114.544   892.172     0.150
   114.544  1322.172     0.150
   115.144  1116.973     0.150
   115.144  1212.871     0.150
   115.460  1106.172     0.150
   115.460  1106.172     0.150
   115.460  1330.172     0.150
   115.460  1840.172     0.150
   115.561  1112.172     0.150
   115.561  1112.172     0.150
   115.561  1331.172     0.150
   116.319  1825.672     0.150
   116.281   904.172     0.150
   116.281   904.172     0.150
   116.601  1167.172     0.150
   116.670  1788.172     0.150
   116.968  1667.172     0.150
   118.096  1348.172     0.150
   118.096  1876.172     0.150
   118.096  2003.172     0.150
   118.054   910.473     0.150
   118.272   920.172     0.150
   118.272  1692.172     0.150
   118.272  1794.172     0.150
   118.272  1876.172     0.150
   118.272  2188.172     0.150
   118.450  1192.172     0.150
   119.942   919.172     0.150
   119.942   919.172     0.150
   120.105   918.172     0.150
   120.105   918.172     0.150
   120.105  1877.172     0.150
   120.381   916.172     0.150
   120.953  1380.172     0.150
   121.193   922.672     0.150
   121.193  1380.172     0.150
   121.193  1889.172     0.150
   121.256  1220.172     0.150
   121.548  1134.172     0.150
   121.548  1380.172     0.150
   121.548  1902.172     0.150
   121.880  1135.371     0.150
   121.880  1909.172     0.150
   122.202  1381.172     0.150
   122.370  1136.172     0.150
   122.370  1386.273     0.150
   122.975  1197.172     0.150
   122.975  1230.172     0.150
   122.975  1398.172     0.150
   122.975  1658.531     0.150
   122.975  1716.883     0.150
   122.975  2180.172     0.150
   123.492  1129.172     0.150
   123.492  1221.172     0.150
   123.635  1924.172     0.150
   123.798   929.172     0.150
   123.798  1394.172     0.150
   124.618  1142.672     0.150
   124.618  1403.473     0.150
   127.054   950.172     0.150
   129.084  1354.473     0.150
   129.084  1943.871     0.150
   129.116  1207.672     0.150
   129.695  1170.773     0.150
   129.643  1151.172     0.150
   129.643  1292.172     0.150
   129.794  1355.371     0.150
   130.681  1357.980     0.150
   132.646  1173.172     0.150
   133.340  1168.172     0.150
   134.193  1141.672     0.150
   134.193  1273.172     0.150
   134.123  1146.172     0.150
   134.639  1488.172     0.150
   134.639  2388.172     0.150
   134.639  2686.172     0.150
   134.639  1160.672     0.150
   134.639  1312.172     0.150
   134.639  1488.172     0.150
   135.625  1149.172     0.150
   136.225  1150.672     0.150
   136.563  1149.773     0.150
   140.225  1350.371     0.150
   140.268  1160.371     0.150
   144.238  1562.172     0.150
   144.238  1175.672     0.150
   145.912  1032.172     0.150
   145.912  1224.172     0.150
   145.912  1236.672     0.150
   145.912  1254.172     0.150
   145.912  1364.172     0.150
   145.912  1426.172     0.150
   145.912  1476.172     0.150
   145.912  1572.172     0.150
   145.912  1670.172     0.150
   145.912  1702.172     0.150
   145.912  1840.172     0.150
   145.912  1994.172     0.150
   145.912  2024.172     0.150
   145.912  2044.172     0.150
   145.912  2076.172     0.150
   145.912  2138.172     0.150
   145.912  2560.172     0.150
   145.912  2594.172     0.150
   145.912  2824.172     0.150
   145.912  2840.172     0.150
   145.912  1178.570     0.150
   147.192  1181.172     0.150
   147.192  1579.172     0.150
   149.026  2524.973     0.150
   150.772  1222.172     0.150
   152.932  1192.172     0.150
   152.932  1419.172     0.150
   153.499  1191.172     0.150
     4.983    78.146     0.150
     9.678   149.595     0.150
    11.658   153.085     0.150
    12.726   416.345     0.150
    14.235   217.825     0.150
    20.030   281.325     0.150
    21.111   279.835     0.150
    21.261   294.905     0.150
    23.848   317.766     0.150
    26.670   548.069     0.150
    29.357   368.345     0.150
    31.678   387.165     0.150
    33.746   407.245     0.150
    34.568   411.445     0.150
    47.919   524.025     0.150
    65.580    10.838     0.150
    65.580   671.486     0.150
    67.224   653.226     0.150
    68.539     1.240     0.150
    68.539   676.947     0.150
    68.539   683.182     0.150
    68.539   696.542     0.150
    68.539   731.167     0.150
    80.300   736.425     0.150
    81.089   739.825     0.150
    83.195   751.525     0.150
    83.195   948.226     0.150
    83.512   752.226     0.150
    83.854   750.625     0.150
    83.897   764.775     0.150
    83.932   754.186     0.150
    86.209   753.525     0.150
    87.041   765.425     0.150
    87.154   766.625     0.150
    88.511   776.425     0.150
    89.352   777.825     0.150
    90.087   784.525     0.150
    90.087   811.525     0.150
    90.087   784.525     0.150
    90.087   811.525     0.150
    90.087   996.825     0.150
    90.087  1443.825     0.150
    90.087  1791.825     0.150
    90.296   821.625     0.150
    90.296  1114.325     0.150
    90.568   785.425     0.150
    91.283  1418.825     0.150
    92.028   794.056     0.150
    92.588  1007.825     0.150
    92.588  2034.825     0.150
    92.858   797.226     0.150
    93.645  1150.825     0.150
    94.022     0.500     0.150
    94.128   803.025     0.150
    94.333    10.500     0.150
    94.410   819.825     0.150
    94.410   840.726     0.150
    96.693   814.525     0.150
    99.267  1501.726     0.150
    99.694   828.325     0.150
   101.526   829.825     0.150
   101.526  1678.825     0.150
   104.704   838.825     0.150
   106.077   856.825     0.150
   106.794   862.625     0.150
   110.462   878.325     0.150
   120.287  1135.825     0.150
   120.899  1382.825     0.150
   123.587  1075.825     0.150
   128.468  1136.159     0.150
   129.171  1137.976     0.150
   132.605  1441.325     0.150
   136.465  1155.325     0.150
     1.481    46.086     0.150
     2.105    62.996     0.150
     2.675    81.176     0.150
     3.439    53.455     0.150
     4.471   118.186     0.150
     4.591    75.824     0.150
     4.591   135.516     0.150
     5.852   160.375     0.150
    20.834   291.574     0.150
    21.631    10.090     0.150
    21.907   303.246     0.150
    21.971    11.510     0.150
    22.108   289.096     0.150
    22.218    10.172     0.150
    22.898     9.090     0.150
    23.119     8.600     0.150
    23.605    10.750     0.150
    24.043     9.520     0.150
    24.043    14.510     0.150
    24.170     9.090     0.150
    24.211     8.730     0.150
    24.747   320.115     0.150
    26.573   550.385     0.150
    29.747   366.855     0.150
    32.776   388.385     0.150
    34.374   406.824     0.150
    41.714   465.426     0.150
    46.258   608.279     0.150
    67.792   656.545     0.150
    82.739   738.086     0.150
    85.505     7.574     0.150
    90.102   776.285     0.150
    90.102   776.285     0.150
    91.940    20.000     0.150
    99.249   829.484     0.150
   106.122   854.285     0.150
   113.542   869.086     0.150
   118.769  1138.586     0.150
   122.365  1130.436     0.150
   128.873  1868.285     0.150
   133.975  1173.086     0.150
   136.112  1150.186     0.150
   145.260  1190.965     0.150
     1.411    26.062     0.150
     2.252    36.832     0.150
     2.451    40.752     0.150
     3.432    55.014     0.150
     5.030   130.973     0.150
     5.198    95.742     0.150
     5.198    95.738     0.150
     5.198   161.287     0.150
     5.198   136.924     0.150
    10.212   757.418     0.150
    10.236   747.451     0.150
    10.871   284.373     0.150
    11.799   301.393     0.150
    11.799   167.924     0.150
    11.799   301.398     0.150
    13.330   187.713     0.150
    14.845   377.322     0.150
    16.489   237.043     0.150
    18.289   251.312     0.150
    18.404   254.002     0.150
    18.495   256.352     0.150
    20.488   279.230     0.150
    20.501   277.178     0.150
    21.531   286.713     0.150
    21.844   293.643     0.150
    21.844   293.613     0.150
    21.844   293.613     0.150
    21.844   293.697     0.150
    21.844   293.602     0.150
    21.844   293.621     0.150
    21.863   289.014     0.150
    22.975   303.812     0.150
    23.099   302.812     0.150
    23.247   308.123     0.150
    23.540   307.213     0.150
    23.540   560.389     0.150
    24.286   314.580     0.150
    26.361   336.863     0.150
    26.361   541.646     0.150
    26.361   609.062     0.150
    26.361   841.488     0.150
    26.546   336.014     0.150
    26.664   541.912     0.150
    26.979   341.912     0.150
    27.011   340.613     0.150
    27.210   343.812     0.150
    27.768   350.244     0.150
    27.875   350.455     0.150
    28.259   640.900     0.150
    28.499   356.320     0.150
    28.741   358.197     0.150
    28.781   355.014     0.150
    29.408   365.893     0.150
    29.408     6.090     0.150
    29.610   364.912     0.150
    29.610   548.113     0.150
    29.840   366.713     0.150
    29.840   366.734     0.150
    30.045   370.115     0.150
    30.180   368.514     0.150
    30.334   369.521     0.150
    30.334     0.041     0.150
    31.169   379.748     0.150
    31.601   398.863     0.150
    31.691   382.514     0.150
    32.263   389.502     0.150
    32.546   389.613     0.150
    32.731   389.613     0.150
    32.731   701.389     0.150
    32.854   392.312     0.150
    33.440   399.014     0.150
    33.886   401.113     0.150
    35.162   413.213     0.150
    35.229   412.662     0.150
    35.229   417.014     0.150
    35.799   416.053     0.150
    36.023   420.113     0.150
    37.464   430.912     0.150
    37.853   444.572     0.150
    37.853   444.572     0.150
    37.899   436.174     0.150
    41.744   466.812     0.150
    41.744   564.113     0.150
    45.490   496.963     0.150
    45.983   503.713     0.150
    45.983   503.764     0.150
    46.332   503.113     0.150
    46.332   598.613     0.150
    46.332   610.014     0.150
    46.332   503.107     0.150
    46.332   598.658     0.150
    46.332   610.059     0.150
    46.332  1469.295     0.150
    47.621   514.912     0.150
    47.621    11.301     0.150
    52.479   553.014     0.150
    52.479   996.812     0.150
    52.479  1216.912     0.150
    52.479   553.014     0.150
    52.479   996.812     0.150
    52.479  1216.912     0.150
    54.346  4064.869     0.150
    54.358   567.213     0.150
    54.358    10.801     0.150
    54.354  4075.443     0.150
    54.363  4069.246     0.150
    55.996   577.812     0.150
    57.010   584.912     0.150
    57.219   585.912     0.150
    57.565   587.213     0.150
    58.284   594.412     0.150
    59.400   603.213     0.150
    59.597   604.412     0.150
    63.937   632.713     0.150
    63.937    10.400     0.150
    68.259   659.613     0.150
    68.845   692.396     0.150
    68.845   701.432     0.150
    69.720   664.137     0.150
    69.720   683.533     0.150
    69.886   665.572     0.150
    71.455   678.514     0.150
    76.156   713.152     0.150
    76.664   715.703     0.150
    76.695   716.912     0.150
    76.821   720.684     0.150
    77.002   713.912     0.150
    78.177   729.514     0.150
    78.177   717.203     0.150
    78.266   730.213     0.150
    79.093   729.543     0.150
    79.285   723.764     0.150
    79.285   723.764     0.150
    79.764   727.312     0.150
    79.850   727.123     0.150
    80.003   727.383     0.150
    80.003   727.684     0.150
    80.003   727.713     0.150
    80.335  1331.113     0.150
    80.946   748.113     0.150
    80.946   748.113     0.150
    80.946  1343.742     0.150
    81.113   189.299     0.150
    81.269   735.143     0.150
    81.293   189.801     0.150
    81.485   186.000     0.150
    81.762   191.199     0.150
    81.907   737.514     0.150
    81.907   737.514     0.150
    82.097   738.613     0.150
    82.097   738.613     0.150
    82.389   740.014     0.150
    82.389   740.014     0.150
    82.698   740.312     0.150
    82.831   740.514     0.150
    82.831   743.594     0.150
    82.883   939.812     0.150
    83.428   745.713     0.150
    83.428   745.713     0.150
    83.546   747.014     0.150
    83.546   747.014     0.150
    83.709   747.912     0.150
    83.826   748.213     0.150
    83.826   748.213     0.150
    84.120   750.213     0.150
    84.354   752.713     0.150
    84.459   751.113     0.150
    84.459   751.113     0.150
    84.537   752.812     0.150
    84.563   753.912     0.150
    84.859   753.412     0.150
    84.859   753.412     0.150
    84.955   754.412     0.150
    84.970   755.713     0.150
    84.998   755.412     0.150
    85.166   750.312     0.150
    85.166   765.412     0.150
    85.166  1069.713     0.150
    85.339   770.693     0.150
    85.339    -0.250     0.150
    85.352   757.312     0.150
    85.391   756.312     0.150
    85.391   756.312     0.150
    85.597   756.613     0.150
    85.597   756.613     0.150
    85.761   759.213     0.150
    85.970   758.713     0.150
    85.970   758.713     0.150
    85.970   758.713     0.150
    85.970   758.713     0.150
    85.988   758.412     0.150
    85.988   758.412     0.150
    86.098   758.713     0.150
    86.098   758.713     0.150
    86.098   761.514     0.150
    86.130   962.213     0.150
    86.130   759.412     0.150
    86.130   962.213     0.150
    86.180   761.014     0.150
    86.321   760.514     0.150
    86.321   760.514     0.150
    86.412   760.312     0.150
    86.412   760.312     0.150
    86.484   760.912     0.150
    86.484   760.912     0.150
    86.650   761.412     0.150
    86.650   761.412     0.150
    86.652   761.213     0.150
    86.652   761.213     0.150
    86.717   197.971     0.150
    86.797   762.412     0.150
    86.797   762.412     0.150
    87.018   763.014     0.150
    87.018   763.014     0.150
    87.073   763.812     0.150
    87.150   764.213     0.150
    87.150   764.213     0.150
    87.283   765.812     0.150
    87.283    10.000     0.150
    87.283   765.873     0.150
    87.283   765.912     0.150
    87.765   779.713     0.150
    88.065   768.713     0.150
    88.065   768.713     0.150
    88.109   769.912     0.150
    88.109   975.312     0.150
    88.109  1400.912     0.150
    88.207   777.713     0.150
    88.233   769.312     0.150
    88.233   769.312     0.150
    88.452   770.514     0.150
    88.452   770.514     0.150
    88.460   770.014     0.150
    88.460   770.014     0.150
    88.467   770.713     0.150
    88.467   770.713     0.150
    88.792   773.014     0.150
    88.792   980.713     0.150
    88.969   784.113     0.150
    88.969   797.213     0.150
    89.000   772.912     0.150
    89.000   772.912     0.150
    89.083   786.213     0.150
    89.139   773.713     0.150
    89.139    10.600     0.150
    89.139   981.713     0.150
    89.158   788.412     0.150
    89.171   774.113     0.150
    89.299   787.713     0.150
    89.311   775.113     0.150
    89.311   775.113     0.150
    89.331   775.113     0.150
    89.331   775.113     0.150
    89.465   776.014     0.150
    89.625   989.713     0.150
    89.625   776.412     0.150
    89.625   989.713     0.150
    89.657   776.312     0.150
    89.657   776.312     0.150
    90.034     8.301     0.150
    90.034   778.312     0.150
    90.034     8.301     0.150
    90.034   778.312     0.150
    90.049   777.412     0.150
    90.049   777.412     0.150
    90.049   777.713     0.150
    90.049   777.713     0.150
    90.058   778.613     0.150
    90.248   780.113     0.150
    90.248    10.600     0.150
    90.248   992.912     0.150
    90.248  1437.113     0.150
    90.248   780.113     0.150
    90.248    10.600     0.150
    90.248   992.912     0.150
    90.248  1437.113     0.150
    90.247    10.602     0.150
    90.263   791.514     0.150
    90.494   780.113     0.150
    90.494    11.199     0.150
    90.494  1408.713     0.150
    90.494  1497.713     0.150
    90.494  2015.113     0.150
    90.494   780.113     0.150
    90.494    11.199     0.150
    90.494  1408.713     0.150
    90.494  1431.713     0.150
    90.494  1497.713     0.150
    90.494  2013.713     0.150
    90.534   781.041     0.150
    90.697   781.812     0.150
    90.697    10.900     0.150
    90.697  1410.812     0.150
    90.697  1504.213     0.150
    90.697   781.812     0.150
    90.697    10.900     0.150
    90.697   990.412     0.150
    90.697  1410.812     0.150
    90.697  1504.213     0.150
    91.224   803.873     0.150
    91.224   784.014     0.150
    91.224    10.898     0.150
    91.224   995.713     0.150
    91.224  1414.713     0.150
    91.224  1439.713     0.150
    91.224  1510.713     0.150
    91.224   784.043     0.150
    91.224    10.859     0.150
    91.224   803.873     0.150
    91.224   995.713     0.150
    91.224  1414.713     0.150
    91.224  1439.713     0.150
    91.224  1510.713     0.150
    91.224  1792.713     0.150
    91.460   785.312     0.150
    91.460    10.801     0.150
    91.741   786.113     0.150
    91.741    11.199     0.150
    91.741   999.213     0.150
    91.741  1416.213     0.150
    91.741  1514.613     0.150
    91.748   791.023     0.150
    91.748   785.713     0.150
    91.748   791.014     0.150
    91.748  1004.812     0.150
    91.748  1412.613     0.150
    91.748  1439.613     0.150
    91.748  1450.312     0.150
    91.748  1457.713     0.150
    91.748   785.713     0.150
    91.748   791.014     0.150
    91.748  1004.812     0.150
    91.748  1412.613     0.150
    91.748  1439.613     0.150
    91.994   787.514     0.150
    91.994    10.100     0.150
    91.994  1419.312     0.150
    91.994  1519.412     0.150
    91.994  1813.213     0.150
    92.080   787.812     0.150
    92.080  1005.912     0.150
    92.080  1018.676     0.150
    92.080  1834.125     0.150
    92.526  1805.713     0.150
    92.526   790.014     0.150
    92.526    10.398     0.150
    92.526  1009.713     0.150
    92.526  1417.713     0.150
    92.526  1520.713     0.150
    92.696   797.713     0.150
    92.726   791.025     0.150
    92.726   791.014     0.150
    92.797  1422.713     0.150
    92.896   791.742     0.150
    93.209   793.613     0.150
    93.227   811.184     0.150
    93.237   793.514     0.150
    93.237    10.799     0.150
    93.237   793.537     0.150
    93.489   794.312     0.150
    93.564   818.014     0.150
    93.564   821.014     0.150
    93.564  1028.912     0.150
    93.564   794.613     0.150
    93.564    10.799     0.150
    93.564   818.014     0.150
    93.564   821.014     0.150
    93.768   795.613     0.150
    93.768     9.799     0.150
    94.066   796.412     0.150
    94.066    11.500     0.150
    94.066  1019.213     0.150
    94.066  1428.713     0.150
    94.243   796.912     0.150
    94.243   799.113     0.150
    94.243    11.301     0.150
    94.243  1424.812     0.150
    94.243  1463.014     0.150
    94.243  1845.514     0.150
    94.358   818.113     0.150
    94.358  1038.613     0.150
    94.358   799.014     0.150
    94.358    10.898     0.150
    94.358  1023.514     0.150
    94.358  1433.113     0.150
    94.358  1547.812     0.150
    94.358   799.014     0.150
    94.358    10.799     0.150
    94.358    19.100     0.150
    94.358  1023.514     0.150
    94.358  1038.613     0.150
    94.364  1038.312     0.150
    94.364   799.412     0.150
    94.364    10.602     0.150
    94.364  1021.713     0.150
    94.364  1433.014     0.150
    94.364  1458.412     0.150
    94.364  1545.312     0.150
    94.364   799.412     0.150
    94.364    10.602     0.150
    94.364  1021.713     0.150
    94.364  1038.312     0.150
    94.720  1037.713     0.150
    94.720  2081.713     0.150
    95.175   823.213     0.150
    95.175  1040.412     0.150
    95.175   802.514     0.150
    95.175    11.100     0.150
    95.175  1030.213     0.150
    95.175  1437.312     0.150
    95.175   802.514     0.150
    95.175    11.100     0.150
    95.175   823.213     0.150
    95.175  1030.213     0.150
    95.175  1040.412     0.150
    95.973  1046.412     0.150
    95.973   806.514     0.150
    95.973    11.199     0.150
    95.973  1033.514     0.150
    96.060   802.713     0.150
    96.084   807.412     0.150
    96.094   827.312     0.150
    96.094  1052.912     0.150
    96.094   806.912     0.150
    96.094    10.400     0.150
    96.094   806.912     0.150
    96.094    10.400     0.150
    96.094   827.312     0.150
    96.094  1052.812     0.150
    96.304   806.312     0.150
    96.386   825.113     0.150
    96.386   835.812     0.150
    96.386   808.113     0.150
    96.386   825.113     0.150
    96.386  1441.514     0.150
    96.386   808.113     0.150
    96.386    17.000     0.150
    96.386   835.812     0.150
    96.624   808.412     0.150
    96.624    10.301     0.150
    96.624  1043.514     0.150
    96.624  1439.412     0.150
    96.624  1482.812     0.150
    96.804   810.213     0.150
    96.804    12.500     0.150
    97.007   811.014     0.150
    97.317  1811.232     0.150
    97.317   811.588     0.150
    97.317  1057.713     0.150
    97.317  1811.238     0.150
    98.361   816.713     0.150
    99.207   818.912     0.150
    99.220   817.113     0.150
    99.220   817.014     0.150
   100.877   827.014     0.150
   101.454  1071.713     0.150
   101.454  1601.713     0.150
   103.153   833.713     0.150
   105.554   862.312     0.150
   105.554  1722.713     0.150
   105.554  2011.713     0.150
   106.364  1123.613     0.150
   106.778  1127.713     0.150
   107.082  1131.113     0.150
   108.450  1117.803     0.150
   109.415  1122.873     0.150
   110.974   875.293     0.150
   110.974  1112.912     0.150
   111.761  1162.713     0.150
   111.901  1145.014     0.150
   111.948  1143.502     0.150
   112.180  1146.883     0.150
   113.218  1170.113     0.150
   115.093  1188.014     0.150
   116.256  1753.238     0.150
   117.270  1802.713     0.150
   118.289  1141.014     0.150
   118.835  1142.713     0.150
   118.835  1361.713     0.150
   120.077  1365.713     0.150
   120.616  1147.113     0.150
   120.616  1371.014     0.150
   120.672  1142.514     0.150
   122.272  1149.613     0.150
   122.272  1388.713     0.150
   122.503  1133.514     0.150
   122.503  1740.264     0.150
   126.850  1156.613     0.150
   127.553  1144.982     0.150
   127.553  1155.502     0.150
   128.292  1282.312     0.150
   128.303  1131.547     0.150
   128.478  1144.801     0.150
   128.975  1157.832     0.150
   128.975  1146.963     0.150
   129.028  1131.812     0.150
   129.223  1158.924     0.150
   129.915  1158.713     0.150
   130.642  1151.762     0.150
   130.642  1352.811     0.150
   132.071  1168.113     0.150
   132.302  1168.014     0.150
   132.302  1468.014     0.150
   133.352  1171.613     0.150
   134.115  1151.213     0.150
   134.115  1157.303     0.150
   134.115  1364.812     0.150
   135.325  1158.139     0.150
   136.282  1148.713     0.150
   136.282  1148.713     0.150
   136.282  1160.312     0.150
   136.282  1161.184     0.150
   136.282  1371.713     0.150
   141.603  1161.912     0.150
   142.038  1165.764     0.150
   142.783  1168.383     0.150
   143.871  1185.613     0.150
   145.575  1187.713     0.150
   145.575  1176.713     0.150
   145.575  1187.713     0.150
     2.233    36.418     0.150
     2.444    36.947     0.150
     2.444    39.566     0.150
     2.444    69.307     0.150
     4.457    74.158     0.150
     5.181   135.688     0.150
     5.181    77.838     0.150
     5.181   132.387     0.150
     5.530   153.307     0.150
    10.230   764.287     0.150
    11.783   165.783     0.150
    11.783   297.182     0.150
    13.331   187.396     0.150
    17.516   241.498     0.150
    18.290   251.197     0.150
    18.506   256.373     0.150
    20.504   279.107     0.150
    21.859   293.498     0.150
    22.403   295.908     0.150
    22.446   295.098     0.150
    23.099   302.297     0.150
    23.262   308.000     0.150
    23.534   307.373     0.150
    24.283   312.348     0.150
    25.348   326.896     0.150
    25.503    13.621     0.150
    26.150   342.408     0.150
    26.540   335.297     0.150
    27.225   343.697     0.150
    27.225    12.301     0.150
    28.240   351.061     0.150
    28.573   350.207     0.150
    28.779   355.098     0.150
    28.779    13.699     0.150
    28.871   358.182     0.150
    30.102   366.717     0.150
    31.184   379.586     0.150
    32.256   402.297     0.150
    32.529   389.297     0.150
    32.848   390.498     0.150
    32.848    12.000     0.150
    37.128   431.123     0.150
    37.471   430.896     0.150
    54.334  4052.721     0.150
    54.342  4054.803     0.150
    54.351  4054.025     0.150
    56.009   577.598     0.150
    57.022   584.697     0.150
    57.231   585.197     0.150
    68.275   658.896     0.150
    71.457   677.896     0.150
    79.755   726.797     0.150
    79.998   727.297     0.150
    81.900   737.297     0.150
    81.900   737.297     0.150
    82.090   738.396     0.150
    82.090   738.396     0.150
    82.382   740.896     0.150
    82.382   740.896     0.150
    83.522   746.598     0.150
    83.539   746.498     0.150
    83.539   746.498     0.150
    83.699   747.297     0.150
    83.699    15.100     0.150
    83.819   747.697     0.150
    83.819   747.697     0.150
    83.930   747.918     0.150
    84.527   751.598     0.150
    84.552   752.297     0.150
    84.537   751.697     0.150
    84.851   753.197     0.150
    84.851   753.197     0.150
    84.960   754.297     0.150
    84.989   754.146     0.150
    84.989   754.197     0.150
    85.342   756.197     0.150
    85.382   755.797     0.150
    85.382   755.797     0.150
    85.589   756.396     0.150
    85.589   756.396     0.150
    85.961   758.396     0.150
    85.961   758.396     0.150
    85.963   758.297     0.150
    85.963   758.297     0.150
    85.980   758.197     0.150
    85.980   758.197     0.150
    86.090   758.598     0.150
    86.090   758.598     0.150
    86.170   760.697     0.150
    86.276   759.816     0.150
    86.405   759.998     0.150
    86.405   759.998     0.150
    86.476   760.598     0.150
    86.476   760.598     0.150
    86.643   760.998     0.150
    86.643   760.998     0.150
    86.711    20.918     0.150
    86.790   762.098     0.150
    86.790   762.098     0.150
    87.011   762.697     0.150
    87.011   762.697     0.150
    87.142   764.098     0.150
    87.142   764.098     0.150
    87.277    21.012     0.150
    87.277   764.498     0.150
    87.277    14.299     0.150
    88.058   768.697     0.150
    88.226   768.896     0.150
    88.226   768.896     0.150
    88.452   769.598     0.150
    88.452   769.598     0.150
    88.460   770.697     0.150
    88.460   770.697     0.150
    88.787   771.797     0.150
    88.787   979.197     0.150
    89.133   772.697     0.150
    89.133   981.498     0.150
    89.304   774.396     0.150
    89.304   774.396     0.150
    89.324   774.797     0.150
    89.324   774.797     0.150
    89.650   775.697     0.150
    89.650   775.697     0.150
    90.028   778.098     0.150
    90.041   776.896     0.150
    90.041   776.896     0.150
    90.242   778.697     0.150
    90.242    11.100     0.150
    90.242  1423.998     0.150
    90.242   778.697     0.150
    90.242    11.199     0.150
    90.242  1423.998     0.150
    90.439   779.998     0.150
    90.439   779.998     0.150
    90.489   780.197     0.150
    90.489  1406.197     0.150
    90.489   780.098     0.150
    90.489   780.197     0.150
    90.489  1406.197     0.150
    90.691   780.697     0.150
    90.691    12.000     0.150
    90.691   994.998     0.150
    91.219   782.998     0.150
    91.219    10.799     0.150
    91.219   996.197     0.150
    91.219  1414.197     0.150
    91.219  1509.197     0.150
    91.219   782.967     0.150
    91.219    10.820     0.150
    91.219   996.197     0.150
    91.219  1414.197     0.150
    91.219  1509.197     0.150
    91.454   784.396     0.150
    91.750   784.098     0.150
    91.864   786.498     0.150
    91.864    10.100     0.150
    92.074   787.396     0.150
    92.074    10.000     0.150
    92.074  1005.896     0.150
    93.192   793.197     0.150
    93.221   810.816     0.150
    93.288   793.197     0.150
    93.763   794.998     0.150
    93.763    15.000     0.150
    94.352   798.896     0.150
    94.352     9.701     0.150
    94.352  1025.598     0.150
    94.352   798.896     0.150
    94.352     9.701     0.150
    94.352  1025.598     0.150
    95.170   801.896     0.150
    95.170    10.000     0.150
    95.170  1028.697     0.150
    95.968   834.998     0.150
    95.968   805.998     0.150
    95.968    14.600     0.150
    95.968  1033.297     0.150
    96.089   806.297     0.150
    96.089    15.801     0.150
    96.381     6.100     0.150
    96.987  1051.197     0.150
    98.176  1181.396     0.150
    98.176  2135.896     0.150
    99.218   818.697     0.150
   106.272   848.197     0.150
   115.106  1121.797     0.150
   118.843  1146.197     0.150
   120.627  1146.297     0.150
   122.284  1148.297     0.150
   122.284  1387.998     0.150
   126.863  1155.797     0.150
   129.043  1142.547     0.150
   129.043  1146.955     0.150
   129.304  1446.998     0.150
   132.315  1470.498     0.150
   145.580  1187.697     0.150
   145.580  1176.197     0.150
     5.004   149.777     0.150
    10.452   786.975     0.150
    10.521   777.418     0.150
    13.455   355.977     0.150
    13.505   191.576     0.150
    17.391   250.367     0.150
    18.075   253.676     0.150
    18.459   255.277     0.150
    19.930   270.877     0.150
    20.800   283.977     0.150
    20.800   284.072     0.150
    21.024   286.695     0.150
    21.769   290.877     0.150
    21.984   291.877     0.150
    22.155   298.576     0.150
    22.197   295.477     0.150
    22.409   297.277     0.150
    22.604   298.676     0.150
    23.249   307.676     0.150
    23.258   305.877     0.150
    23.541   312.477     0.150
    23.559   312.676     0.150
    23.559   312.693     0.150
    23.863   314.377     0.150
    23.844   315.098     0.150
    24.409   317.277     0.150
    24.487   321.777     0.150
    24.685   329.438     0.150
    24.773   324.277     0.150
    24.773   324.359     0.150
    25.104   324.076     0.150
    25.154   325.938     0.150
    25.634   331.377     0.150
    25.634   331.309     0.150
    25.667   332.225     0.150
    25.845   334.277     0.150
    26.619   338.676     0.150
    26.671   341.857     0.150
    26.671   544.836     0.150
    26.671   855.146     0.150
    27.015   343.676     0.150
    27.063   344.646     0.150
    27.063   851.857     0.150
    27.291   346.777     0.150
    27.533   352.127     0.150
    27.522   348.477     0.150
    27.522   348.484     0.150
    27.680   350.076     0.150
    27.983   358.537     0.150
    28.187   354.830     0.150
    28.847   361.176     0.150
    28.911   359.076     0.150
    29.156   362.699     0.150
    29.135   376.557     0.150
    29.365   366.557     0.150
    29.916   369.477     0.150
    30.127   371.277     0.150
    30.127   371.189     0.150
    30.490   373.576     0.150
    30.490   374.629     0.150
    30.560   368.236     0.150
    31.389   381.344     0.150
    31.480   384.258     0.150
    32.534   399.336     0.150
    32.922   400.146     0.150
    32.922   400.176     0.150
    34.181   406.977     0.150
    35.296   422.387     0.150
    36.105   423.477     0.150
    37.711   434.777     0.150
    45.673   507.727     0.150
    45.673   507.777     0.150
    46.601   507.066     0.150
    49.794   540.396     0.150
    54.048  4052.867     0.150
    54.057  4053.514     0.150
    54.065  4060.699     0.150
    55.511   581.416     0.150
    55.511   575.477     0.150
    55.511   581.377     0.150
    56.299   581.377     0.150
    57.310   588.576     0.150
    57.517   589.777     0.150
    57.800   596.176     0.150
    57.800   590.576     0.150
    57.800   596.176     0.150
    63.635   637.438     0.150
    63.635   637.477     0.150
    82.283   742.777     0.150
    82.436   741.977     0.150
    82.436   741.977     0.150
    83.195   753.176     0.150
    83.195   942.176     0.150
    83.195  1440.477     0.150
    83.478   748.176     0.150
    83.478   748.176     0.150
    83.537   750.086     0.150
    83.537   750.076     0.150
    83.598   748.977     0.150
    83.598   748.977     0.150
    83.709   749.977     0.150
    83.878   750.277     0.150
    83.878   750.277     0.150
    84.500   753.076     0.150
    84.500   753.076     0.150
    84.530   754.877     0.150
    84.550   756.176     0.150
    84.882   755.377     0.150
    84.882   755.377     0.150
    84.959   757.877     0.150
    85.007   757.277     0.150
    85.349   759.676     0.150
    85.413   757.977     0.150
    85.413   757.977     0.150
    85.534   760.176     0.150
    85.631   758.676     0.150
    85.631   758.676     0.150
    85.994   760.576     0.150
    85.994   760.576     0.150
    86.025   760.477     0.150
    86.025   760.477     0.150
    86.034   760.777     0.150
    86.034   760.777     0.150
    86.141   760.877     0.150
    86.141   760.877     0.150
    86.184   763.277     0.150
    86.457   762.277     0.150
    86.457   762.277     0.150
    86.520   762.777     0.150
    86.520   762.777     0.150
    86.847   764.377     0.150
    87.178   766.176     0.150
    87.178   766.176     0.150
    87.917   770.076     0.150
    88.122   769.977     0.150
    88.122   769.977     0.150
    88.476   772.277     0.150
    88.527   771.777     0.150
    88.527   771.777     0.150
    89.201   773.176     0.150
    89.699   777.877     0.150
    89.699   777.877     0.150
    90.320   781.977     0.150
    90.320     9.600     0.150
    90.320   781.977     0.150
    90.320     9.600     0.150
    90.577   781.977     0.150
    90.577  1448.977     0.150
    90.577  1544.977     0.150
    90.695   782.076     0.150
    91.306   791.277     0.150
    91.306   791.256     0.150
    91.533   787.676     0.150
    92.035  1128.377     0.150
    92.074   787.176     0.150
    92.152   789.977     0.150
    92.630   790.777     0.150
    93.075   794.727     0.150
    93.075   794.777     0.150
    99.321   822.076     0.150
   111.266  1144.336     0.150
   113.978  2108.377     0.150
   113.978   890.277     0.150
   113.978  1174.277     0.150
   118.601  1133.676     0.150
   122.225  1138.277     0.150
   122.225  1147.877     0.150
   122.571  1135.977     0.150
   122.571  1150.777     0.150
   122.571  1157.977     0.150
   122.571  1235.176     0.150
   122.571  1560.676     0.150
   122.571  1135.977     0.150
   122.571  1150.777     0.150
   122.571  1235.176     0.150
   122.571  1560.676     0.150
   122.571  2226.576     0.150
   132.608  1155.777     0.150
   132.608  1171.377     0.150
   132.608  1179.477     0.150
   132.608  1302.877     0.150
   132.608  1706.377     0.150
   132.608  2648.576     0.150
   132.608  1155.777     0.150
   132.608  1171.377     0.150
   132.608  1302.877     0.150
   132.608  2351.676     0.150
   132.608  2648.576     0.150
   140.117  1164.326     0.150
   140.117  1169.377     0.150
   144.231  1175.166     0.150
   145.809  1186.477     0.150
   145.809  1179.477     0.150
     0.154     6.413     0.150
     0.154    10.113     0.150
     0.424    10.223     0.150
     1.212    21.473     0.150
     1.212    36.953     0.150
     1.318    22.513     0.150
     1.318    38.583     0.150
     1.671    28.283     0.150
     1.671    48.633     0.150
     1.889    54.673     0.150
     2.143    34.562     0.150
     2.143    59.513     0.150
     2.280    37.793     0.150
     2.280    65.353     0.150
     2.559    40.923     0.150
     2.559    71.732     0.150
     2.644    42.482     0.150
     2.644    74.373     0.150
     2.682    43.223     0.150
     2.682    75.933     0.150
     2.892    46.663     0.150
     2.892    79.713     0.150
     2.910    46.353     0.150
     2.910    80.723     0.150
     3.071    48.583     0.150
     3.071    85.013     0.150
     3.185    49.223     0.150
     3.185    86.973     0.150
     3.217    48.883     0.150
     3.217    86.503     0.150
     3.418    53.253     0.150
     3.418    92.293     0.150
     3.593    55.573     0.150
     3.593    98.153     0.150
     4.170    63.323     0.150
     4.178    63.623     0.150
     4.178   110.713     0.150
     5.186    76.753     0.150
     5.186   130.803     0.150
     5.186   159.323     0.150
     5.186    77.183     0.150
     5.186   136.833     0.150
     5.198    76.893     0.150
     5.198   136.473     0.150
     5.748    84.423     0.150
     5.748   149.383     0.150
     6.219    91.312     0.150
     6.219   161.703     0.150
     8.000   116.982     0.150
     8.000   206.683     0.150
    10.291   813.939     0.150
    11.873   292.812     0.150
    12.760   183.423     0.150
    12.760   405.973     0.150
    18.799   596.723     0.150
    21.066   289.433     0.150
    21.492   288.727     0.150
    23.510   311.116     0.150
    23.783   309.982     0.150
    24.263   314.953     0.150
    25.613   332.146     0.150
    26.632   340.423     0.150
    26.969   341.522     0.150
    28.928   358.514     0.150
    30.569   379.183     0.150
    45.752   502.543     0.150
    46.641   506.522     0.150
    46.984  3520.723     0.150
    52.259  3920.223     0.150
    54.051  4056.559     0.150
    54.059  4057.969     0.150
    54.068  4057.854     0.150
    56.660  4245.623     0.150
    57.114   586.323     0.150
    57.204   587.623     0.150
    59.919   605.223     0.150
    60.867   612.893     0.150
    62.511  1138.223     0.150
    62.511  4685.623     0.150
    82.126   738.923     0.150
    83.648   747.423     0.150
    83.768   748.223     0.150
    84.048   749.423     0.150
    84.139   749.953     0.150
    85.591   757.123     0.150
    85.806   757.923     0.150
    86.171   759.723     0.150
    86.199   759.522     0.150
    86.201   759.723     0.150
    86.313   760.022     0.150
    86.871   762.423     0.150
    86.870   762.623     0.150
    87.018   763.723     0.150
    88.446   771.323     0.150
    89.214   774.522     0.150
    93.231   792.723     0.150
    93.231   792.723     0.150
    95.417   808.823     0.150
    96.632   816.522     0.150
    97.051   820.723     0.150
   128.256  1146.403     0.150
     0.682    13.848     0.150
     0.682    22.086     0.150
     1.012    19.137     0.150
     1.012    32.676     0.150
     1.475    26.668     0.150
     1.475    26.668     0.150
     1.475    44.547     0.150
     1.939    31.645     0.150
     1.939    55.078     0.150
     2.000    33.125     0.150
     2.000    59.406     0.150
     2.326    38.195     0.150
     2.326    67.066     0.150
     2.326    38.195     0.150
     2.326    67.066     0.150
     2.435    39.996     0.150
     2.435    69.996     0.150
     2.435    39.996     0.150
     2.435    69.996     0.150
     2.586    41.816     0.150
     2.586    73.695     0.150
     2.719    45.008     0.150
     2.719    76.996     0.150
     3.412    53.945     0.150
     3.412    93.617     0.150
     3.512    96.066     0.150
     3.512    55.227     0.150
     3.512    96.066     0.150
     3.854    58.676     0.150
     3.854   102.625     0.150
     4.487    67.855     0.150
     4.487   116.508     0.150
     4.487   139.105     0.150
     4.607    69.668     0.150
     5.805    86.816     0.150
     5.805   151.887     0.150
     6.175    92.516     0.150
     6.175   162.926     0.150
     6.240    92.797     0.150
     6.240   162.566     0.150
     6.476    96.617     0.150
     7.154   106.355     0.150
     7.304   108.266     0.150
     7.950   119.395     0.150
     8.972   130.926     0.150
    11.206   278.305     0.150
    11.466   166.855     0.150
    12.342   322.328     0.150
    12.342   176.746     0.150
    12.342   322.324     0.150
    12.926   184.305     0.150
    12.926   408.316     0.150
    12.926   993.281     0.150
    13.424   187.727     0.150
    14.978   389.723     0.150
    14.978   389.723     0.150
    15.441   218.328     0.150
    15.441   218.328     0.150
    15.645   218.906     0.150
    15.957   225.598     0.150
    17.769   244.188     0.150
    18.392   255.555     0.150
    18.989   261.758     0.150
    18.989   475.457     0.150
    18.989   602.781     0.150
    19.752   267.047     0.150
    21.161   286.105     0.150
    21.161   286.207     0.150
    21.310   287.922     0.150
    21.626   514.258     0.150
    21.800   288.707     0.150
    22.482   295.395     0.150
    22.526   548.887     0.150
    22.526   300.656     0.150
    22.526   300.656     0.150
    22.526   548.883     0.150
    22.526   726.133     0.150
    22.849   305.656     0.150
    23.139   302.355     0.150
    23.139   302.375     0.150
    23.376   305.883     0.150
    23.376   558.531     0.150
    23.406   307.828     0.150
    23.406   307.906     0.150
    23.847   310.746     0.150
    23.913   314.707     0.150
    23.919   314.367     0.150
    24.101   314.984     0.150
    24.117   316.566     0.150
    24.194   316.438     0.150
    24.227   313.734     0.150
    24.479   320.371     0.150
    24.935   321.457     0.150
    25.056   325.215     0.150
    25.138   325.707     0.150
    25.398   341.395     0.150
    25.516   328.215     0.150
    25.893   332.098     0.150
    25.893   540.168     0.150
    26.032   334.223     0.150
    26.355   334.816     0.150
    27.005  2299.828     0.150
    27.005   343.383     0.150
    27.005   543.441     0.150
    27.005   862.723     0.150
    27.005  1000.980     0.150
    27.005  2299.832     0.150
    27.005  2537.082     0.150
    27.146   342.527     0.150
    27.146   342.406     0.150
    27.146   542.605     0.150
    27.146   866.680     0.150
    27.146   998.957     0.150
    27.146  2110.457     0.150
    27.259   343.855     0.150
    27.344   544.105     0.150
    27.344   873.008     0.150
    27.482   629.844     0.150
    27.668   349.047     0.150
    27.877   350.227     0.150
    27.984   351.234     0.150
    28.029   349.305     0.150
    28.114   350.234     0.150
    28.416   355.777     0.150
    29.043   360.598     0.150
    29.282   361.551     0.150
    29.404   363.305     0.150
    29.813   366.848     0.150
    30.214   370.516     0.150
    30.214     9.590     0.150
    30.330   371.188     0.150
    30.837   374.625     0.150
    31.725   554.023     0.150
    31.725  1018.699     0.150
    31.768   387.586     0.150
    31.768   387.582     0.150
    32.124   386.793     0.150
    32.658   389.207     0.150
    32.733   392.836     0.150
    33.391   395.855     0.150
    33.391   558.180     0.150
    33.853   402.516     0.150
    34.063   404.438     0.150
    34.417   406.105     0.150
    34.417   560.906     0.150
    34.959   410.848     0.150
    34.997   412.215     0.150
    34.997   563.555     0.150
    35.021   411.258     0.150
    35.021   411.246     0.150
    35.854   418.547     0.150
    37.787   434.445     0.150
    41.794   584.980     0.150
    44.786   495.332     0.150
    45.264   597.730     0.150
    46.742  2343.305     0.150
    46.742   507.703     0.150
    46.742     9.098     0.150
    46.742   600.953     0.150
    46.742  1013.652     0.150
    46.742  2343.301     0.150
    47.164   603.883     0.150
    50.099   534.375     0.150
    53.803  4032.648     0.150
    53.811  4033.148     0.150
    53.820  4034.984     0.150
    55.126   573.676     0.150
    55.127   573.578     0.150
    55.127     9.457     0.150
    55.696   575.055     0.150
    55.696     9.527     0.150
    55.696  2379.508     0.150
    55.840   576.965     0.150
    55.840     9.051     0.150
    56.354   580.695     0.150
    56.453   581.730     0.150
    56.577   581.566     0.150
    56.577    10.059     0.150
    57.363   587.406     0.150
    57.363    10.199     0.150
    57.363   641.156     0.150
    57.363  2376.355     0.150
    57.569   589.176     0.150
    57.765   589.945     0.150
    59.435   601.508     0.150
    59.986   608.555     0.150
    60.264   608.598     0.150
    61.326   614.375     0.150
    63.367   629.332     0.150
    65.484   642.457     0.150
    67.207   663.758     0.150
    67.647   666.457     0.150
    67.792   665.457     0.150
    70.048   670.457     0.150
    71.572   678.957     0.150
    74.494   703.695     0.150
    75.940   879.555     0.150
    77.541     0.641     0.150
    79.833   726.547     0.150
    79.833    10.621     0.150
    79.947   727.656     0.150
    80.665  1335.555     0.150
    80.772   732.855     0.150
    81.057   734.156     0.150
    81.648   736.758     0.150
    81.648   736.758     0.150
    81.833   737.758     0.150
    81.833   737.758     0.150
    82.131   739.258     0.150
    82.131   739.258     0.150
    82.612   742.125     0.150
    83.175   745.258     0.150
    83.175   745.258     0.150
    83.299   745.957     0.150
    83.299   745.957     0.150
    83.342   745.828     0.150
    83.389   747.535     0.150
    83.389   757.445     0.150
    83.550   946.258     0.150
    83.578   748.055     0.150
    83.578   748.055     0.150
    83.578   748.055     0.150
    83.591   747.082     0.150
    83.591    10.551     0.150
    83.591  1845.980     0.150
    83.761   745.156     0.150
    84.064   750.328     0.150
    84.064    10.609     0.150
    84.064   750.332     0.150
    84.064    10.598     0.150
    84.187   750.457     0.150
    84.187   750.457     0.150
    84.543   752.656     0.150
    84.543   752.656     0.150
    84.731   753.855     0.150
    84.871   754.207     0.150
    84.999   754.457     0.150
    84.999   753.676     0.150
    84.999  1839.555     0.150
    85.073   755.355     0.150
    85.073   755.355     0.150
    85.136   755.457     0.150
    85.308   756.258     0.150
    85.308   756.258     0.150
    85.484   757.355     0.150
    85.578   756.883     0.150
    85.578  1839.281     0.150
    85.657   758.055     0.150
    85.657   758.055     0.150
    85.705   758.055     0.150
    85.705   758.055     0.150
    85.728   758.957     0.150
    85.753   758.355     0.150
    85.753   758.355     0.150
    85.768   758.355     0.150
    85.829   758.457     0.150
    85.829   758.457     0.150
    85.847   757.258     0.150
    86.006   767.656     0.150
    86.006   767.656     0.150
    86.006   768.355     0.150
    86.106   760.258     0.150
    86.106   760.258     0.150
    86.148   759.855     0.150
    86.148   759.855     0.150
    86.193   760.055     0.150
    86.199   760.355     0.150
    86.199   760.355     0.150
    86.203   760.457     0.150
    86.393   760.656     0.150
    86.393   760.656     0.150
    86.395   760.855     0.150
    86.395   760.855     0.150
    86.537   762.055     0.150
    86.537   762.055     0.150
    86.545   761.855     0.150
    86.759   762.355     0.150
    86.759   762.355     0.150
    86.840   763.258     0.150
    86.846   763.656     0.150
    86.846   763.656     0.150
    86.877   764.457     0.150
    86.877   764.457     0.150
    86.942   763.457     0.150
    87.068   763.875     0.150
    87.234   765.258     0.150
    87.521   766.656     0.150
    87.521   766.656     0.150
    87.595   767.258     0.150
    87.675   767.555     0.150
    87.675    11.000     0.150
    87.675   971.457     0.150
    87.698   767.957     0.150
    87.712   767.816     0.150
    87.830   767.758     0.150
    87.830   767.758     0.150
    87.956   768.855     0.150
    87.956   768.855     0.150
    87.987   779.758     0.150
    87.987   779.758     0.150
    88.082   773.086     0.150
    88.160  6660.891     0.150
    88.161  6664.414     0.150
    88.176  6659.828     0.150
    88.204   769.855     0.150
    88.204    11.301     0.150
    88.207   769.758     0.150
    88.207   769.758     0.150
    88.216   769.355     0.150
    88.216   769.355     0.150
    88.240   769.656     0.150
    88.240   769.656     0.150
    88.246   768.777     0.150
    88.332   770.055     0.150
    88.332   770.055     0.150
    88.376   770.055     0.150
    88.376   770.055     0.150
    88.385   770.457     0.150
    88.385   770.457     0.150
    88.617   772.156     0.150
    88.617    10.801     0.150
    88.696   772.156     0.150
    88.726   772.555     0.150
    88.726   772.555     0.150
    88.912   774.258     0.150
    88.912   774.258     0.150
    88.915   772.555     0.150
    88.915    11.203     0.150
    88.915   980.758     0.150
    88.970   982.055     0.150
    89.048   774.457     0.150
    89.048   774.457     0.150
    89.068   774.656     0.150
    89.068   774.656     0.150
    89.385   775.555     0.150
    89.385   775.555     0.150
    89.505   786.258     0.150
    89.505   786.258     0.150
    89.760   777.055     0.150
    89.760   777.055     0.150
    89.763   776.555     0.150
    89.763   776.555     0.150
    89.849   777.656     0.150
    89.849    10.801     0.150
    89.849   988.758     0.150
    89.849  1769.656     0.150
    90.050   779.156     0.150
    90.050   991.258     0.150
    90.050  1779.156     0.150
    90.303   779.926     0.150
    90.323   779.758     0.150
    90.323   785.855     0.150
    90.323    10.199     0.150
    90.323  1002.355     0.150
    90.323  1407.656     0.150
    90.323  1858.656     0.150
    90.323  2020.656     0.150
    90.323  2230.656     0.150
    90.497   777.258     0.150
    90.510   781.156     0.150
    90.510    10.398     0.150
    90.510   994.156     0.150
    90.755   782.066     0.150
    90.764   781.457     0.150
    90.764    11.199     0.150
    90.835   991.828     0.150
    90.835   781.082     0.150
    90.835   991.832     0.150
    90.835  1827.582     0.150
    90.940   783.016     0.150
    91.026   783.262     0.150
    91.026   783.258     0.150
    91.051  1414.656     0.150
    91.051  1451.656     0.150
    91.051   783.258     0.150
    91.051    10.898     0.150
    91.051   998.156     0.150
    91.051  1414.656     0.150
    91.051  1804.656     0.150
    91.263   784.555     0.150
    91.263    10.801     0.150
    91.263  1000.957     0.150
    91.567   785.957     0.150
    91.567    11.000     0.150
    91.675   786.055     0.150
    91.675    10.902     0.150
    91.675  1003.957     0.150
    91.675  1418.156     0.150
    91.675  1515.055     0.150
    91.706   784.457     0.150
    91.814  1010.055     0.150
    91.814   786.656     0.150
    91.814    11.301     0.150
    91.814  1010.055     0.150
    91.814  1414.355     0.150
    91.814  1516.055     0.150
    91.882   786.758     0.150
    91.882    11.297     0.150
    91.882  1004.707     0.150
    91.882   787.258     0.150
    91.882    10.125     0.150
    91.882  1004.707     0.150
    91.882  1825.105     0.150
    92.156   788.145     0.150
    92.275  1125.758     0.150
    92.275  2038.555     0.150
    92.362  1018.355     0.150
    92.378   789.555     0.150
    92.378    11.102     0.150
    92.378  1009.855     0.150
    92.507   789.922     0.150
    92.507   789.926     0.150
    92.535   790.555     0.150
    92.628   790.957     0.150
    92.628    10.598     0.150
    92.628  1010.355     0.150
    92.628  1424.258     0.150
    92.689   790.285     0.150
    92.690   790.055     0.150
    93.505   794.125     0.150
    93.587   794.996     0.150
    93.598   794.805     0.150
    93.715   794.656     0.150
    93.900   796.758     0.150
    93.900    10.598     0.150
    93.900  1019.957     0.150
    93.900  1430.656     0.150
    94.168   797.156     0.150
    94.592   798.957     0.150
    94.592    10.301     0.150
    94.592  1026.656     0.150
    94.592  1431.258     0.150
    94.844   801.855     0.150
    94.983   803.758     0.150
    94.983  1159.555     0.150
    94.983  2079.855     0.150
    94.997  1039.555     0.150
    94.997   801.656     0.150
    94.997  1039.555     0.150
    95.304   803.457     0.150
    95.904   806.477     0.150
    95.904    10.789     0.150
    95.992   802.656     0.150
    95.992   802.656     0.150
    96.225   806.555     0.150
    96.648   809.457     0.150
    96.709  1039.008     0.150
    96.709   808.156     0.150
    96.709    11.074     0.150
    96.709  1039.008     0.150
    96.709  1813.707     0.150
    96.709  2304.230     0.150
    96.832   821.656     0.150
    99.110   817.855     0.150
    99.110   817.828     0.150
    99.110  1060.207     0.150
    99.110   817.832     0.150
    99.110  1060.207     0.150
    99.110  1805.258     0.150
    99.206   829.957     0.150
    99.772   825.656     0.150
   100.016   839.355     0.150
   101.313  1078.656     0.150
   101.313  1667.656     0.150
   101.313  1944.656     0.150
   101.313   830.656     0.150
   101.313  1078.656     0.150
   103.869   843.797     0.150
   103.869  1106.566     0.150
   103.869   843.793     0.150
   103.869  1106.566     0.150
   104.668  1652.758     0.150
   106.833  1779.980     0.150
   107.187   859.758     0.150
   108.252  1107.633     0.150
   108.252  1776.633     0.150
   108.753  1108.258     0.150
   108.753  1776.656     0.150
   108.753  1790.605     0.150
   109.333  1128.688     0.150
   109.333  1108.305     0.150
   109.333  1128.680     0.150
   109.333  1773.105     0.150
   109.891  1139.605     0.150
   109.891  1784.555     0.150
   110.043   859.055     0.150
   110.291   885.758     0.150
   111.487  1113.176     0.150
   111.487  1153.016     0.150
   111.487  1767.797     0.150
   111.487  1777.578     0.150
   112.405  1115.645     0.150
   116.221  1753.555     0.150
   116.575  1121.305     0.150
   116.575  1122.055     0.150
   116.575  1175.234     0.150
   116.575  1122.055     0.150
   116.575  1175.230     0.150
   116.575  1749.832     0.150
   117.273  1188.656     0.150
   117.273  1765.656     0.150
   117.273  2144.656     0.150
   117.853  1126.480     0.150
   119.380  1196.156     0.150
   120.304  1140.457     0.150
   120.304  1129.926     0.150
   120.304  1140.406     0.150
   120.317  1222.656     0.150
   120.413  1131.035     0.150
   120.501  1130.867     0.150
   120.501  1130.867     0.150
   120.501  1737.477     0.150
   120.490  1737.398     0.150
   121.119  1635.156     0.150
   122.047  1137.258     0.150
   123.005  1136.355     0.150
   127.702  1144.668     0.150
   128.079  1144.867     0.150
   128.079  1144.871     0.150
   128.198  1146.180     0.150
   128.931  1147.555     0.150
   128.942  1130.625     0.150
   128.942  1130.633     0.150
   128.942  1146.730     0.150
   128.942  1158.281     0.150
   128.942  1938.055     0.150
   129.628  1133.055     0.150
   129.628  1133.055     0.150
   129.628  1148.805     0.150
   129.628  1931.355     0.150
   132.524  1154.188     0.150
   134.718  1160.480     0.150
   136.948  1152.746     0.150
   136.948  1152.742     0.150
   136.948  1163.242     0.150
   139.719  1157.906     0.150
   139.719  1158.176     0.150
   139.719  1158.176     0.150
   140.043  1193.355     0.150
   140.104  1167.965     0.150
   140.416  1160.508     0.150
   140.416  1160.508     0.150
   140.416  1169.008     0.150
   142.673  1168.168     0.150
   143.229  1169.938     0.150
   143.229  1170.055     0.150
   143.229  1170.055     0.150
   148.319  1182.895     0.150
   148.319  1187.438     0.150
   148.371  1183.578     0.150
   148.371  1186.887     0.150
   150.575  1191.727     0.150
   150.575  1198.805     0.150
   153.303  1189.855     0.150
   153.303  1197.055     0.150
     0.294     9.141     0.150
     0.294    15.016     0.150
     0.584    12.266     0.150
     0.584    20.594     0.150
     1.625    27.258     0.150
     1.625    46.148     0.150
     1.799    29.258     0.150
     1.799    50.523     0.150
     1.846    29.930     0.150
     1.846    53.164     0.150
     1.916    31.828     0.150
     1.916    54.805     0.150
     2.193    35.898     0.150
     2.193    62.555     0.150
     2.539    40.625     0.150
     2.539    70.625     0.150
     2.638    41.984     0.150
     2.638    73.570     0.150
     2.798    44.641     0.150
     2.798    75.188     0.150
     3.654    56.375     0.150
     3.654    96.156     0.150
     3.709    55.578     0.150
     3.709    97.578     0.150
     4.567    68.484     0.150
     4.567   120.336     0.150
     4.567   141.875     0.150
     6.053    88.891     0.150
     6.053   156.938     0.150
     6.273    92.344     0.150
     6.273   162.719     0.150
     6.264    95.109     0.150
     6.264   162.227     0.150
     7.254   107.898     0.150
     7.254   187.797     0.150
     7.767   113.906     0.150
     7.767   200.586     0.150
    11.229   275.422     0.150
    12.725   181.172     0.150
    12.725   397.039     0.150
    18.190   254.297     0.150
    18.212   248.195     0.150
    18.787   258.344     0.150
    20.963   283.555     0.150
    20.963   285.344     0.150
    21.295   288.133     0.150
    21.471   291.016     0.150
    21.820   295.367     0.150
    21.824   291.688     0.150
    22.330   300.375     0.150
    22.603   301.367     0.150
    22.715   299.047     0.150
    22.741   299.289     0.150
    23.271     9.938     0.150
    23.271     9.523     0.150
    23.914   309.078     0.150
    24.100   309.766     0.150
    24.636   313.844     0.150
    25.257   329.148     0.150
    26.486   338.906     0.150
    26.804   339.945     0.150
    26.804     9.078     0.150
    26.945   339.398     0.150
    28.002   347.734     0.150
    31.209   376.008     0.150
    31.961   387.719     0.150
    32.872   391.344     0.150
    33.465   398.305     0.150
    45.311   493.898     0.150
    45.311    11.500     0.150
    45.455   498.375     0.150
    46.546   504.094     0.150
    46.961   507.008     0.150
    46.961   507.047     0.150
    50.281   533.844     0.150
    51.258   539.828     0.150
    51.258   539.820     0.150
    52.814  3936.445     0.150
    53.447   565.898     0.150
    54.006  4038.109     0.150
    54.014  4041.273     0.150
    54.023  4039.516     0.150
    55.188   573.188     0.150
    55.496   571.594     0.150
    55.496   571.594     0.150
    55.496    11.375     0.150
    55.503   576.016     0.150
    55.637   577.086     0.150
    56.151   582.797     0.150
    57.043   584.695     0.150
    57.043    11.180     0.150
    57.287  4262.250     0.150
    60.430   608.016     0.150
    63.570   629.047     0.150
    63.570    10.828     0.150
    71.414   695.648     0.150
    83.864   747.445     0.150
    85.426   758.469     0.150
    85.426   758.469     0.150
    89.955   781.469     0.150
   123.014  1133.969     0.150
   128.897  1145.922     0.150
   128.897  1157.695     0.150
   129.600  1147.250     0.150
   129.600  1158.594     0.150
     0.247     9.590     0.150
     0.247     9.590     0.150
     0.677    13.379     0.150
     0.677    22.090     0.150
     1.138    21.430     0.150
     1.138    37.051     0.150
     1.270    41.570     0.150
     1.270    23.699     0.150
     1.480    25.711     0.150
     1.480    46.402     0.150
     1.948    33.070     0.150
     1.948    54.492     0.150
     2.461    40.410     0.150
     2.461    40.410     0.150
     2.461    76.301     0.150
     2.488    47.160     0.150
     2.568    42.629     0.150
     2.568    76.492     0.150
     2.568    42.629     0.150
     2.568    76.492     0.150
     2.693    48.250     0.150
     2.693    48.250     0.150
     2.698    43.582     0.150
     2.837    51.930     0.150
     2.776    45.020     0.150
     3.544    92.039     0.150
     3.544    54.742     0.150
     3.544    92.039     0.150
     3.517    54.852     0.150
     3.860    59.500     0.150
     4.219    62.352     0.150
     4.219   111.500     0.150
     5.113    74.832     0.150
     5.113   148.641     0.150
     6.292    94.230     0.150
     6.292   182.039     0.150
     6.221   173.062     0.150
     6.221    93.160     0.150
     6.221   173.062     0.150
     6.238   167.129     0.150
     6.238    92.711     0.150
     6.238   167.129     0.150
     6.572   177.699     0.150
     7.316   111.570     0.150
     9.031   125.609     0.150
     9.031   223.160     0.150
     9.031   125.609     0.150
     9.031   223.160     0.150
    10.954   823.211     0.150
    10.978   824.574     0.150
    11.024   820.941     0.150
    13.036   187.980     0.150
    13.558   191.621     0.150
    13.637   193.699     0.150
    13.637   340.070     0.150
    15.092   211.121     0.150
    17.349   241.289     0.150
    17.898   247.109     0.150
    18.500   254.852     0.150
    18.500   254.840     0.150
    18.476   258.020     0.150
    19.354   264.910     0.150
    19.886   270.270     0.150
    21.234   288.359     0.150
    21.830   293.723     0.150
    21.951   292.000     0.150
    22.043   293.473     0.150
    22.596   301.691     0.150
    23.274   308.551     0.150
    23.274   308.531     0.150
    23.295   309.629     0.150
    23.522   310.352     0.150
    23.522   310.359     0.150
    23.495   309.082     0.150
    23.988   317.410     0.150
    23.987   317.520     0.150
    24.203   317.582     0.150
    24.290   319.082     0.150
    24.361   317.121     0.150
    24.574   319.949     0.150
    24.899   325.672     0.150
    24.846   333.922     0.150
    25.070   324.223     0.150
    25.132   327.250     0.150
    25.210   328.520     0.150
    25.991   334.551     0.150
    25.991   334.562     0.150
    26.104   336.062     0.150
    26.484   337.211     0.150
    27.246   344.770     0.150
    27.360   346.660     0.150
    27.437   347.949     0.150
    27.509   347.391     0.150
    27.759   355.422     0.150
    27.952   352.223     0.150
    27.912   350.891     0.150
    28.874   358.301     0.150
    29.153   363.820     0.150
    29.504   365.801     0.150
    29.630   368.129     0.150
    30.303   372.812     0.150
    30.438   374.090     0.150
    30.914   376.770     0.150
    31.805   384.949     0.150
    31.805   384.949     0.150
    31.706   385.902     0.150
    31.932   384.852     0.150
    31.932   384.812     0.150
    32.777   393.492     0.150
    34.520   409.250     0.150
    34.520   409.910     0.150
    35.087   413.723     0.150
    35.090   414.820     0.150
    35.149   413.992     0.150
    42.114   471.812     0.150
    42.787   477.949     0.150
    45.206   499.051     0.150
    47.266   515.211     0.150
    47.496  3543.852     0.150
    52.610  3935.152     0.150
    53.617   563.609     0.150
    55.808   577.152     0.150
    55.808   577.172     0.150
    55.938   578.992     0.150
    56.052   579.910     0.150
    56.671   584.082     0.150
    57.161  4268.449     0.150
    57.469   589.992     0.150
    57.668   591.070     0.150
    57.971   591.352     0.150
    57.971   591.391     0.150
    59.277   601.480     0.150
    60.151   607.531     0.150
    59.891  1340.949     0.150
    62.241   629.949     0.150
    62.241   621.250     0.150
    62.241   629.949     0.150
    64.995   646.621     0.150
    65.619   644.652     0.150
    70.183   671.750     0.150
    71.707   689.551     0.150
    71.707   680.852     0.150
    71.707   689.551     0.150
    76.040   708.031     0.150
    77.674   717.621     0.150
    80.662   732.250     0.150
    83.457   748.020     0.150
    85.132   757.051     0.150
    85.926   759.262     0.150
    90.453  1001.051     0.150
    90.453  1462.051     0.150
    90.453   782.051     0.150
    90.639   782.551     0.150
    90.639   791.949     0.150
    90.970   782.973     0.150
    90.970   998.289     0.150
    91.804   787.949     0.150
    91.943   788.652     0.150
    91.943   797.652     0.150
    92.508   800.152     0.150
    92.758   792.750     0.150
    92.758   801.750     0.150
    93.728   797.020     0.150
    96.787  1813.883     0.150
    99.242  1068.711     0.150
   112.781  1115.949     0.150
   112.781  1160.992     0.150
   112.872  1777.219     0.150
   114.373  1125.551     0.150
   127.525  1680.551     0.150
   127.525  2294.051     0.150
   130.003  1153.852     0.150
   145.970  1189.051     0.150
   150.632  1193.402     0.150
   150.632  1199.879     0.150
   153.360  1191.949     0.150
   153.360  1198.871     0.150
   153.360  1211.062     0.150
     0.725    24.270     0.150
     0.725    13.871     0.150
     0.725    24.270     0.150
     1.023    18.859     0.150
     1.023    31.652     0.150
     1.050    16.402     0.150
     1.050    28.652     0.150
     1.440    22.082     0.150
     1.440    38.730     0.150
     1.440    22.082     0.150
     1.440    38.730     0.150
     1.429    24.500     0.150
     1.429    41.910     0.150
     2.010    33.520     0.150
     2.010    59.711     0.150
     2.143    35.012     0.150
     2.143    61.051     0.150
     2.176    35.609     0.150
     2.176    63.871     0.150
     2.337    38.281     0.150
     2.337    66.812     0.150
     2.337    38.281     0.150
     2.337    66.812     0.150
     2.617    45.020     0.150
     2.617    73.641     0.150
     2.694    40.301     0.150
     2.694    70.793     0.150
     2.756    42.801     0.150
     2.756    75.000     0.150
     3.713   100.191     0.150
     4.607    67.070     0.150
     4.607   119.242     0.150
     5.500    80.793     0.150
     6.408    99.172     0.150
     6.546    95.562     0.150
     6.546   167.902     0.150
    10.576   263.441     0.150
    11.731   905.062     0.150
    11.755   898.227     0.150
    11.800   916.742     0.150
    13.725   194.270     0.150
    14.902   211.852     0.150
    14.967   215.262     0.150
    15.250   213.320     0.150
    17.652   241.902     0.150
    17.918   245.676     0.150
    17.941   245.750     0.150
    18.132   248.242     0.150
    19.397   266.051     0.150
    19.614   264.770     0.150
    20.341   270.820     0.150
    20.763   281.031     0.150
    21.612   287.582     0.150
    21.650   287.090     0.150
    21.762   292.262     0.150
    21.811   288.559     0.150
    22.024   292.812     0.150
    22.080   295.461     0.150
    23.087   303.352     0.150
    23.377   312.859     0.150
    23.715   312.340     0.150
    23.746   311.270     0.150
    23.746   311.293     0.150
    24.081   313.332     0.150
    24.078   313.062     0.150
    24.364   318.801     0.150
    24.505   319.859     0.150
    24.540   320.160     0.150
    24.546   319.152     0.150
    24.675   321.172     0.150
    24.807   319.910     0.150
    25.379   327.820     0.150
    25.644   329.891     0.150
    25.744   331.160     0.150
    25.959   332.602     0.150
    26.312   340.691     0.150
    26.363   336.473     0.150
    26.363   336.480     0.150
    26.636   333.020     0.150
    26.732   339.543     0.150
    26.732     8.047     0.150
    26.732   344.383     0.150
    26.916   347.602     0.150
    27.107   340.121     0.150
    27.669   347.270     0.150
    27.669   347.230     0.150
    27.710   348.172     0.150
    27.843   350.422     0.150
    28.470   355.109     0.150
    28.522   362.883     0.150
    28.604   354.383     0.150
    29.430   364.383     0.150
    29.621     4.949     0.150
    30.137   370.910     0.150
    30.137    12.750     0.150
    30.733   375.070     0.150
    30.726   375.102     0.150
    31.164   377.449     0.150
    31.699   387.801     0.150
    32.050   386.270     0.150
    32.075   383.840     0.150
    32.289     5.141     0.150
    32.354   387.941     0.150
    33.526   396.621     0.150
    33.774   401.473     0.150
    33.812   402.973     0.150
    34.239   407.430     0.150
    34.602   410.051     0.150
    34.856   410.230     0.150
    35.499   416.320     0.150
    35.847   418.430     0.150
    36.642   426.141     0.150
    42.118   470.211     0.150
    44.616   491.992     0.150
    44.770   494.391     0.150
    48.150  3575.371     0.150
    53.094  3961.270     0.150
    53.992   565.473     0.150
    55.118   573.902     0.150
    55.820   575.211     0.150
    56.062   577.371     0.150
    56.062   577.320     0.150
    56.303   580.020     0.150
    56.437   582.371     0.150
    56.437   582.402     0.150
    56.838   584.012     0.150
    56.991   587.371     0.150
    57.065   584.070     0.150
    57.065   584.090     0.150
    57.804  4300.070     0.150
    57.840   590.949     0.150
    58.011   590.031     0.150
    58.034   591.793     0.150
    59.064   597.973     0.150
    60.174   605.371     0.150
    60.548   608.293     0.150
    61.911   617.141     0.150
    62.140   618.770     0.150
    62.898   625.242     0.150
    65.449   641.371     0.150
    65.449   641.402     0.150
    69.965   669.172     0.150
    71.576   678.371     0.150
    79.474   722.840     0.150
    79.474   722.770     0.150
    79.885  1311.172     0.150
    80.179   726.793     0.150
    80.179  1329.590     0.150
    80.179   726.770     0.150
    80.179  1329.570     0.150
    80.296  1634.473     0.150
    80.387   728.043     0.150
    80.387   727.973     0.150
    80.387  1331.871     0.150
    82.888   743.699     0.150
    84.136   745.770     0.150
    84.136  1909.172     0.150
    84.678   753.531     0.150
    84.826   752.973     0.150
    85.646   756.891     0.150
    85.775   767.672     0.150
    85.775   758.270     0.150
    85.775   767.672     0.150
    87.342   764.371     0.150
    87.342   764.320     0.150
    87.757   769.172     0.150
    88.718   774.562     0.150
    89.277   773.570     0.150
    90.046   785.371     0.150
    90.046   788.672     0.150
    90.046  1997.371     0.150
    90.046   778.371     0.150
    90.046   788.672     0.150
    90.046  1399.371     0.150
    90.609   783.086     0.150
    90.773  1412.371     0.150
    90.773   781.770     0.150
    90.773   993.973     0.150
    90.773  1412.371     0.150
    90.773  1433.371     0.150
    90.773  1797.371     0.150
    91.377     6.199     0.150
    91.377   785.973     0.150
    91.377   792.172     0.150
    91.377   998.371     0.150
    91.377  1414.770     0.150
    91.377  1515.371     0.150
    91.377  1805.973     0.150
    92.093   795.320     0.150
    92.093   795.371     0.150
    92.093  1005.270     0.150
    92.354   790.172     0.150
    92.354     6.801     0.150
    92.354    10.000     0.150
    92.354   790.172     0.150
    92.354   800.172     0.150
    92.354  1005.473     0.150
    92.354  1422.270     0.150
    92.354  1520.672     0.150
    92.354  1817.473     0.150
    92.709   798.672     0.150
    92.709   790.199     0.150
    93.322   795.062     0.150
    93.414   799.039     0.150
    93.716   789.371     0.150
    94.331   798.770     0.150
    94.331  1023.070     0.150
    94.331  1430.672     0.150
    94.713   796.770     0.150
    94.713   807.672     0.150
    94.713   796.770     0.150
    94.713   807.672     0.150
    95.037   809.223     0.150
    95.037   809.172     0.150
    95.037  1028.672     0.150
    95.797  1030.672     0.150
    96.222   807.270     0.150
    96.222  1037.770     0.150
    96.384   814.973     0.150
   100.922   821.070     0.150
   110.104  2311.270     0.150
   116.161  1184.672     0.150
   119.468  1210.871     0.150
   121.514  1131.973     0.150
   123.199  1133.172     0.150
   123.275  1140.270     0.150
   123.574  1135.195     0.150
   127.786  1141.836     0.150
   127.909  1149.371     0.150
   127.909  1682.172     0.150
   130.278  1138.816     0.150
   130.454  1147.570     0.150
   134.660  1165.672     0.150
   140.923  1163.922     0.150
     0.274    13.711     0.150
     2.295    71.430     0.150
     2.362    73.602     0.150
     4.158    58.086     0.150
     4.735   132.102     0.150
     6.216   100.000     0.150
    11.236   279.180     0.150
    15.647   221.820     0.150
    17.997   247.492     0.150
    18.324   253.070     0.150
    18.941   257.516     0.150
    18.979   261.164     0.150
    21.295   287.391     0.150
    21.525   287.570     0.150
    21.711   287.398     0.150
    21.824   288.852     0.150
    22.622   299.773     0.150
    22.933   303.969     0.150
    23.394   305.617     0.150
    23.654   309.172     0.150
    24.496   318.039     0.150
    24.799   323.219     0.150
    25.703   329.781     0.150
    25.707   329.609     0.150
    27.384   344.789     0.150
    28.373   355.477     0.150
    29.343   359.781     0.150
    29.392   363.242     0.150
    45.453   496.867     0.150
    47.570  3544.750     0.150
    52.713  3938.250     0.150
    59.154   608.352     0.150
    63.044  4707.547     0.150
     0.168     6.618     0.150
     0.168     4.598     0.150
     0.168     6.618     0.150
     0.267    10.308     0.150
     0.267    14.128     0.150
     0.267    10.308     0.150
     0.267    14.128     0.150
     1.019    18.407     0.150
     1.019    31.788     0.150
     1.436    25.458     0.150
     1.436    42.888     0.150
     1.488    26.668     0.150
     1.488    45.668     0.150
     1.985    33.058     0.150
     1.985    58.138     0.150
     2.087    35.748     0.150
     2.087    61.098     0.150
     2.479    41.817     0.150
     2.603    42.518     0.150
     2.603    73.428     0.150
     2.735    44.938     0.150
     2.735    76.768     0.150
     2.960    48.008     0.150
    10.459   784.392     0.150
    11.223   167.436     0.150
    11.679   172.978     0.150
    11.868   174.725     0.150
    12.724   185.311     0.150
    13.039   190.078     0.150
    13.463   194.414     0.150
    15.392   220.527     0.150
    15.425   218.601     0.150
    17.858   249.388     0.150
    18.746   261.577     0.150
    19.291   264.045     0.150
    20.776   283.734     0.150
    21.120   286.855     0.150
    21.150   283.261     0.150
    22.110   293.924     0.150
    22.125   297.139     0.150
    22.686   304.708     0.150
    23.210   307.978     0.150
    23.467   309.848     0.150
    24.078   314.405     0.150
    24.070   317.491     0.150
    24.160   317.903     0.150
    24.357   316.498     0.150
    24.420   320.531     0.150
    24.460   321.080     0.150
    24.464   320.744     0.150
    24.624   318.728     0.150
    24.666   320.532     0.150
    25.040   324.961     0.150
    27.879   350.828     0.150
    29.840   368.333     0.150
    29.886   371.708     0.150
    30.375   371.218     0.150
    33.333   397.438     0.150
    47.217   517.978     0.150
    57.955   593.298     0.150
    63.667   632.888     0.150
    65.535   643.968     0.150
     0.997    18.469     0.150
     0.997    30.891     0.150
     1.181    21.379     0.150
     1.181    35.500     0.150
     1.217    22.570     0.150
     1.353    24.238     0.150
     1.353    41.309     0.150
     1.797    31.039     0.150
     1.797    53.250     0.150
     2.269    37.789     0.150
     2.269    63.660     0.150
     2.273    37.699     0.150
     2.273    65.430     0.150
     2.542    42.031     0.150
     2.542    72.102     0.150
     2.554    45.301     0.150
     2.554    77.719     0.150
     2.621    42.859     0.150
     2.621    42.859     0.150
     2.621    80.910     0.150
     2.727    45.391     0.150
     3.212    50.539     0.150
     3.212    84.270     0.150
     3.537    58.828     0.150
     3.537    96.789     0.150
     4.174    61.719     0.150
     4.174   113.410     0.150
     4.179    64.352     0.150
     4.179   111.418     0.150
     5.962    95.988     0.150
     5.962    95.988     0.150
    11.848   178.719     0.150
    13.291   188.801     0.150
    13.831   201.648     0.150
    16.012   228.527     0.150
    16.012   231.430     0.150
    18.337   254.262     0.150
    19.354   266.340     0.150
    19.357   266.883     0.150
    20.953   284.559     0.150
    21.545   288.262     0.150
    21.691   292.891     0.150
    21.879   292.980     0.150
    22.028   291.887     0.150
    22.028   296.129     0.150
    22.077   296.418     0.150
    22.346   298.297     0.150
    22.538   300.699     0.150
    22.710   302.340     0.150
    23.761   313.609     0.150
    24.379   318.789     0.150
    29.690   362.801     0.150
    30.313   369.184     0.150
    30.696   376.480     0.150
    31.387   382.914     0.150
    34.400   406.668     0.150
     0.754    25.586     0.150
     0.754    14.824     0.150
     0.754    24.855     0.150
     1.105    37.105     0.150
     1.105    21.445     0.150
     1.105    37.105     0.150
     1.171    40.316     0.150
     1.171    39.836     0.150
     1.564    29.066     0.150
     1.564    48.934     0.150
     2.020    33.535     0.150
     2.076    35.383     0.150
     2.390    42.156     0.150
     2.390    42.105     0.150
     2.390    42.105     0.150
     2.455    44.184     0.150
     2.676    44.574     0.150
     3.257   100.383     0.150
     3.436    94.977     0.150
     3.436    54.215     0.150
     3.436    94.977     0.150
     3.493    54.633     0.150
     4.124   114.426     0.150
     4.124   114.426     0.150
     4.124    61.383     0.150
     4.442   133.273     0.150
     4.442   133.273     0.150
     4.442   120.355     0.150
     4.442    67.863     0.150
     5.891    89.953     0.150
     5.891   172.156     0.150
     6.125    92.684     0.150
     6.149    92.375     0.150
     6.337    96.484     0.150
     6.578   197.844     0.150
     7.098   106.523     0.150
     7.232   110.203     0.150
     7.932   124.160     0.150
     8.038   117.555     0.150
     8.014   125.645     0.150
     8.014   280.051     0.150
     8.683   135.199     0.150
     8.683   296.609     0.150
     8.683   135.199     0.150
     8.683   296.609     0.150
     8.894   129.973     0.150
     8.894   235.227     0.150
     8.916   137.805     0.150
     8.916   137.805     0.150
     9.071   276.633     0.150
     9.071   134.406     0.150
     9.105   141.055     0.150
     9.105   306.688     0.150
     9.105   141.055     0.150
     9.105   306.688     0.150
     9.123   139.852     0.150
     9.611   315.699     0.150
     9.611   145.652     0.150
     9.611   315.699     0.150
    10.128   141.746     0.150
    10.128   273.316     0.150
    11.041   827.160     0.150
    11.110   828.230     0.150
    11.187   283.324     0.150
    11.568   306.977     0.150
    12.436   178.445     0.150
    13.026   187.395     0.150
    13.499   191.234     0.150
    13.601   194.266     0.150
    14.704   210.004     0.150
    15.544   221.574     0.150
    15.736   221.375     0.150
    17.327   241.504     0.150
    17.366   240.355     0.150
    17.857   248.023     0.150
    17.858   250.766     0.150
    18.438   254.477     0.150
    18.494   258.684     0.150
    18.586   256.254     0.150
    18.985   257.555     0.150
    19.089   264.562     0.150
    19.089   264.164     0.150
    19.811   269.574     0.150
    20.288   278.656     0.150
    20.458   277.523     0.150
    20.531   278.234     0.150
    20.616   280.434     0.150
    20.815   280.566     0.150
    20.814   286.355     0.150
    20.964   285.773     0.150
    21.123   284.273     0.150
    21.262   288.996     0.150
    21.577   290.844     0.150
    21.756   300.566     0.150
    21.858   291.613     0.150
    21.886   296.074     0.150
    21.953   293.086     0.150
    22.371   298.754     0.150
    22.371   298.727     0.150
    22.512   302.555     0.150
    22.556   301.555     0.150
    22.628   303.293     0.150
    22.915   303.074     0.150
    23.193   308.023     0.150
    23.207   307.555     0.150
    23.207   307.566     0.150
    23.306   310.844     0.150
    23.285   309.496     0.150
    23.686   310.656     0.150
    23.952   313.266     0.150
    24.055   316.016     0.150
    24.285   316.184     0.150
    24.296   320.113     0.150
    24.423   318.293     0.150
    24.641   324.434     0.150
    24.769   325.055     0.150
    24.942   321.977     0.150
    24.995   323.504     0.150
    25.038   323.824     0.150
    25.082   327.023     0.150
    25.453   331.965     0.150
    25.525   333.035     0.150
    25.666   332.773     0.150
    25.666   332.773     0.150
    25.735   334.863     0.150
    25.798   333.414     0.150
    26.037   334.145     0.150
    26.037   336.176     0.150
    26.072   337.254     0.150
    26.252   337.824     0.150
    26.318   341.414     0.150
    26.382   339.215     0.150
    26.548   341.836     0.150
    26.548   341.836     0.150
    26.561   340.664     0.150
    26.601   343.145     0.150
    26.788   338.934     0.150
    26.842   344.406     0.150
    26.930   345.184     0.150
    26.993   345.934     0.150
    26.999   346.855     0.150
    27.054   346.375     0.150
    27.107  2303.129     0.150
    27.142   343.566     0.150
    27.185   342.773     0.150
    27.272   349.035     0.150
    27.347   344.773     0.150
    27.400   350.363     0.150
    27.483   346.465     0.150
    27.462   350.094     0.150
    27.519   346.363     0.150
    27.519   346.363     0.150
    27.680   351.133     0.150
    27.769   351.176     0.150
    27.830   352.055     0.150
    27.979   352.566     0.150
    27.940   353.906     0.150
    27.992   353.594     0.150
    28.033   355.984     0.150
    28.033   355.984     0.150
    28.057   355.664     0.150
    28.308   356.613     0.150
    28.381   354.605     0.150
    28.799   357.477     0.150
    28.881   356.613     0.150
    29.009   364.504     0.150
    29.143   362.715     0.150
    29.152   365.453     0.150
    29.201   365.293     0.150
    29.201   365.293     0.150
    29.213   363.863     0.150
    29.377   361.957     0.150
    29.443   368.934     0.150
    29.984   364.246     0.150
    29.996   368.945     0.150
    29.996   368.945     0.150
    30.430   374.406     0.150
    30.921   378.977     0.150
    31.790   383.453     0.150
    31.828   385.125     0.150
    31.831   384.305     0.150
    31.936   385.395     0.150
    32.689   392.754     0.150
    33.007   396.129     0.150
    34.165   407.453     0.150
    34.277   407.828     0.150
    34.756   407.344     0.150
    34.999   412.383     0.150
    34.999   412.445     0.150
    35.061   413.156     0.150
    35.061   413.113     0.150
    35.127   413.727     0.150
    36.403   424.137     0.150
    36.700   423.227     0.150
    38.164   433.113     0.150
    38.728   431.426     0.150
    40.968   462.984     0.150
    42.710   478.227     0.150
    44.123   489.984     0.150
    44.123   488.195     0.150
    44.710   496.754     0.150
    44.710   496.793     0.150
    45.165   498.445     0.150
    47.598  3543.156     0.150
    49.324   532.414     0.150
    49.324   530.613     0.150
    52.963   558.484     0.150
    55.197   574.863     0.150
    55.199   576.113     0.150
    56.556   583.445     0.150
    56.774   586.875     0.150
    57.167   592.953     0.150
    57.167  4261.055     0.150
    57.263   592.656     0.150
    57.263  4268.855     0.150
    57.395   588.414     0.150
    57.464   589.055     0.150
    57.931   591.434     0.150
    58.411   596.656     0.150
    58.932  4395.254     0.150
    59.209   602.656     0.150
    59.790  4458.656     0.150
    59.833  4462.254     0.150
    59.993  4472.953     0.150
    60.292   610.055     0.150
    62.184   621.254     0.150
    63.054  4705.555     0.150
    64.853     3.000     0.150
    64.853   788.555     0.150
    64.853   874.555     0.150
    64.853   883.555     0.150
    64.853  1189.555     0.150
    64.853  1465.555     0.150
    64.853  1597.555     0.150
    64.853  1614.555     0.150
    64.853  2456.555     0.150
    64.976   640.176     0.150
    65.555   644.254     0.150
    69.888   669.953     0.150
    69.888   669.945     0.150
    70.114   674.254     0.150
    70.128   677.156     0.150
    70.128   677.156     0.150
    71.647   680.953     0.150
    76.042   881.555     0.150
    76.042   984.754     0.150
    76.042  1782.254     0.150
    77.175   720.355     0.150
    77.619   716.355     0.150
    77.603   724.246     0.150
    79.961   731.555     0.150
    79.961   730.055     0.150
    79.961  1332.555     0.150
    80.167   731.184     0.150
    80.430   733.656     0.150
    80.677   735.656     0.150
    80.677   733.855     0.150
    80.677  1340.156     0.150
    80.766  1668.953     0.150
    80.957  1672.855     0.150
    81.105   738.453     0.150
    81.118   737.355     0.150
    81.308   741.523     0.150
    81.374   742.219     0.150
    82.485   746.613     0.150
    82.535   746.523     0.150
    82.839   748.523     0.150
    82.930   748.691     0.150
    83.247   750.523     0.150
    83.359   747.766     0.150
    83.510   752.523     0.150
    83.628   752.195     0.150
    83.652  1906.254     0.150
    83.641   753.523     0.150
    83.832   754.523     0.150
    83.835   753.523     0.150
    84.129   755.523     0.150
    84.612   757.523     0.150
    84.649   757.691     0.150
    84.902   758.582     0.150
    84.925   756.043     0.150
    85.055   756.855     0.150
    85.056   760.355     0.150
    85.056   760.355     0.150
    85.100   760.531     0.150
    85.119   759.676     0.150
    85.167   760.523     0.150
    85.614   759.203     0.150
    85.777   763.523     0.150
    86.055   762.855     0.150
    86.216   765.523     0.150
    86.241   765.652     0.150
    86.445  1411.863     0.150
    87.064   769.523     0.150
    87.105   766.273     0.150
    87.963   774.523     0.150
    88.036   772.855     0.150
    88.237  6664.730     0.150
    88.237  6664.555     0.150
    88.252  6665.750     0.150
    88.282   771.375     0.150
    89.127   772.555     0.150
    89.127  1103.555     0.150
    89.227   777.105     0.150
    89.554   780.855     0.150
    90.366   788.555     0.150
    90.366   794.555     0.150
    90.366   781.555     0.150
    90.366   794.555     0.150
    90.366  1378.555     0.150
    90.366  1420.555     0.150
    90.366  1460.555     0.150
    90.366  1532.555     0.150
    90.366  2018.555     0.150
    90.366  2228.555     0.150
    90.552   790.953     0.150
    90.552   782.156     0.150
    90.552   994.355     0.150
    91.094   798.586     0.150
    91.094  1421.555     0.150
    91.094  1829.555     0.150
    91.094   784.953     0.150
    91.094   798.555     0.150
    91.094  1002.555     0.150
    91.094  1512.555     0.150
    91.610   788.156     0.150
    91.715   801.055     0.150
    91.715   789.156     0.150
    91.715  1419.156     0.150
    91.856   788.453     0.150
    91.856  1005.055     0.150
    91.922  1833.453     0.150
    92.404  1005.953     0.150
    92.421   791.656     0.150
    92.421  1009.555     0.150
    92.496   791.555     0.150
    92.528   791.727     0.150
    92.672   792.555     0.150
    92.672  1003.055     0.150
    92.732   788.156     0.150
    92.732   788.156     0.150
    92.732  1010.453     0.150
    92.732  1425.754     0.150
    93.066   796.453     0.150
    93.066   803.156     0.150
    93.066   796.453     0.150
    93.255  1139.355     0.150
    93.255  2055.754     0.150
    93.352   796.156     0.150
    93.641   797.055     0.150
    93.944   799.156     0.150
    94.190  1554.754     0.150
    94.218   800.656     0.150
    94.637   801.453     0.150
    95.039   804.555     0.150
    95.039   803.855     0.150
    95.496   818.055     0.150
    95.496  2095.656     0.150
    95.946   809.855     0.150
    95.946  1027.645     0.150
    96.047  1044.555     0.150
    96.047  1864.555     0.150
    96.047  2114.555     0.150
    96.047   806.555     0.150
    96.047  1044.555     0.150
    96.047  1444.555     0.150
    96.047  1478.555     0.150
    96.693   813.953     0.150
    96.811   812.086     0.150
    96.877   824.055     0.150
    96.877   828.555     0.150
    97.371  1030.586     0.150
    98.164   817.953     0.150
    99.004   821.656     0.150
    99.059   824.754     0.150
    99.114  1062.555     0.150
    99.267  2145.156     0.150
   100.276   829.055     0.150
   100.746   829.453     0.150
   101.360  1672.555     0.150
   101.360  2230.555     0.150
   101.360   828.555     0.150
   101.360  1078.555     0.150
   101.360  1515.555     0.150
   101.360  1612.555     0.150
   101.360  1672.555     0.150
   101.360  1964.555     0.150
   104.744  2239.656     0.150
   105.476   852.953     0.150
   109.243   863.156     0.150
   109.243  1274.855     0.150
   109.992  1156.699     0.150
   110.345  1285.453     0.150
   110.345  2323.656     0.150
   112.512  1111.355     0.150
   112.512  1157.453     0.150
   112.512  2092.156     0.150
   112.832  1777.230     0.150
   113.237  2362.254     0.150
   116.658  1123.996     0.150
   116.666  1759.156     0.150
   120.841  1132.805     0.150
   121.219  1135.555     0.150
   121.219  1146.656     0.150
   121.270  1133.656     0.150
   121.897  1135.406     0.150
   122.624  1136.355     0.150
   122.624  1136.355     0.150
   122.706  1136.914     0.150
   122.731  1146.355     0.150
   122.927  1153.953     0.150
   123.666  1138.895     0.150
   124.300   940.855     0.150
   127.314  1145.695     0.150
   127.532  1682.953     0.150
   127.984  1146.145     0.150
   128.371  1147.035     0.150
   129.651  1137.363     0.150
   129.651  1150.035     0.150
   130.021  1166.656     0.150
   132.622  1158.664     0.150
   140.206  1169.793     0.150
   140.519  1164.301     0.150
   145.927  1576.555     0.150
   145.927  1996.555     0.150
   145.927  2292.555     0.150
   156.062  1222.855     0.150
     0.642    13.020     0.150
     0.642    21.469     0.150
     1.124    20.969     0.150
     1.286    41.258     0.150
     1.286    23.977     0.150
     1.594    28.508     0.150
     1.914    31.887     0.150
     2.128    35.477     0.150
     2.128    64.656     0.150
     2.805    45.719     0.150
     2.805    78.047     0.150
     2.956    41.719     0.150
     3.551    55.297     0.150
    10.921   812.184     0.150
    13.014   186.477     0.150
    13.552   191.066     0.150
    13.622   191.707     0.150
    15.668   226.578     0.150
    15.678   221.828     0.150
    15.997   230.699     0.150
    17.312   242.879     0.150
    17.330   240.988     0.150
    17.885   246.469     0.150
    18.105   249.566     0.150
    18.448   257.129     0.150
    18.495   254.297     0.150
    19.073   262.449     0.150
    19.345   264.598     0.150
    19.887   269.688     0.150
    20.225   271.992     0.150
    20.633   277.336     0.150
    20.921   291.336     0.150
    20.921   291.336     0.150
    21.204   287.039     0.150
    21.375   289.719     0.150
    21.935   291.047     0.150
    21.936   292.207     0.150
    22.051   292.727     0.150
    22.432   296.129     0.150
    22.613   297.949     0.150
    22.566   301.289     0.150
    22.946   303.566     0.150
    23.270   305.457     0.150
    23.501   309.438     0.150
    23.982   313.188     0.150
    23.956   314.996     0.150
    24.179   316.219     0.150
    24.264   316.828     0.150
    24.362   316.246     0.150
    24.760   323.656     0.150
    24.880   322.809     0.150
    25.069   322.848     0.150
    25.180   327.008     0.150
    25.195   327.906     0.150
    25.479   328.277     0.150
    25.561   333.008     0.150
    25.624   329.848     0.150
    25.646   329.148     0.150
    25.911   334.719     0.150
    25.965   333.609     0.150
    26.014   332.609     0.150
    26.154   335.566     0.150
    26.372   337.270     0.150
    26.491   336.477     0.150
    26.425   339.816     0.150
    26.660   341.520     0.150
    26.710   343.219     0.150
    27.056   345.098     0.150
    27.056  2293.473     0.150
    27.159   347.469     0.150
    27.240   342.219     0.150
    27.265   355.129     0.150
    27.265   355.129     0.150
    27.335   344.727     0.150
    27.420   345.379     0.150
    27.413   346.219     0.150
    27.491   345.746     0.150
    27.646   345.746     0.150
    27.705   348.559     0.150
    27.721   349.379     0.150
    27.922   351.020     0.150
    27.945   352.578     0.150
    28.141   360.227     0.150
    28.141   360.227     0.150
    28.169   360.227     0.150
    28.169   360.227     0.150
    28.874   356.418     0.150
    29.141   359.867     0.150
    29.600   365.348     0.150
    29.600   365.367     0.150
    30.059   364.617     0.150
    30.059   363.598     0.150
    30.011   368.191     0.150
    30.101   370.438     0.150
    30.276   370.449     0.150
    30.276   370.449     0.150
    30.302   368.969     0.150
    30.416   371.648     0.150
    30.416   371.617     0.150
    30.885   376.309     0.150
    31.669   383.148     0.150
    31.776   384.438     0.150
    31.964   385.477     0.150
    32.195   385.859     0.150
    32.258   386.117     0.150
    32.432   388.328     0.150
    32.784   391.777     0.150
    33.509   397.949     0.150
    34.495   407.297     0.150
    35.094   410.148     0.150
    35.094   410.188     0.150
    35.063   412.629     0.150
    35.063   564.938     0.150
    35.990   420.598     0.150
    44.217   488.348     0.150
    45.238   497.520     0.150
    47.476  3526.348     0.150
    53.591   561.559     0.150
    55.082   573.777     0.150
    55.187   572.809     0.150
    55.786   576.656     0.150
    55.913   578.367     0.150
    56.026   579.238     0.150
    56.423   581.609     0.150
    56.645   583.348     0.150
    57.046   591.746     0.150
    57.142  4263.746     0.150
    57.438   588.367     0.150
    57.443   589.418     0.150
    57.642   590.387     0.150
    57.841   591.008     0.150
    58.813   604.148     0.150
    58.813  4389.449     0.150
    59.275   601.648     0.150
    59.408   602.348     0.150
    59.408   602.316     0.150
    59.670   609.949     0.150
    59.670  4453.648     0.150
    59.713   610.246     0.150
    59.873   611.348     0.150
    59.873  4467.746     0.150
    60.124   606.777     0.150
    60.275   608.359     0.150
    60.275   609.547     0.150
    62.940  4700.348     0.150
    65.614   644.348     0.150
    71.700   680.949     0.150
    76.015   982.246     0.150
    78.793   722.449     0.150
    83.472   746.438     0.150
    84.109   751.527     0.150
    84.109   750.957     0.150
    85.007   754.707     0.150
    85.193   757.086     0.150
    85.707   757.578     0.150
    87.847   768.008     0.150
    90.455   779.457     0.150
    90.459   781.348     0.150
    91.187   785.449     0.150
    92.018   788.328     0.150
    92.291   788.051     0.150
    92.657   791.996     0.150
    94.974   802.496     0.150
    95.992   804.949     0.150
    99.340  1188.848     0.150
   109.939  1135.336     0.150
   116.686  1123.520     0.150
   121.300  1132.758     0.150
   121.692  1133.383     0.150
   121.929  1134.617     0.150
   123.710  1137.227     0.150
   129.521  1149.898     0.150
   129.523  1145.434     0.150
   129.523  1149.578     0.150
   140.479  1163.598     0.150
   140.479  1163.594     0.150
   140.479  1169.418     0.150
   148.429  1182.949     0.150
   150.599  1192.738     0.150
   153.328  1211.449     0.150
     1.481    46.652     0.150
     1.646    28.961     0.150
     1.937    26.223     0.150
     5.001    90.621     0.150
     5.001    74.441     0.150
     5.406    89.391     0.150
    13.610   190.723     0.150
    15.580   224.613     0.150
    20.931   288.617     0.150
    21.633   289.562     0.150
    21.924   294.598     0.150
    21.956   296.199     0.150
    21.993   295.047     0.150
    22.310   299.004     0.150
    22.277   300.371     0.150
    22.417   300.035     0.150
    22.606   300.613     0.150
    22.751   301.730     0.150
    23.436   313.094     0.150
    24.543   317.801     0.150
    24.581   323.391     0.150
    24.839   323.180     0.150
    25.185   326.883     0.150
    25.480   325.371     0.150
    25.647   326.430     0.150
    26.504   343.582     0.150
    26.576   339.762     0.150
    26.830   344.051     0.150
    26.994   345.762     0.150
    27.073   344.051     0.150
    27.272   342.203     0.150
    27.208   343.027     0.150
    27.556   350.051     0.150
    28.187   358.836     0.150
    29.676   367.125     0.150
    31.525   381.059     0.150
    33.491   403.457     0.150
    33.431   399.293     0.150
    36.711   432.949     0.150
    47.072   513.590     0.150
    47.107  3520.000     0.150
    55.664   575.980     0.150
    55.830   579.070     0.150
    56.779  4250.402     0.150
    58.462  4378.801     0.150
    62.608  4691.801     0.150
    84.046   750.430     0.150
    90.697   785.102     0.150
   122.719  1150.602     0.150
   129.112  1147.500     0.150
   129.113  1147.500     0.150
     0.292     9.250     0.150
     0.397    10.023     0.150
     0.791    15.359     0.150
     0.791    26.109     0.150
     1.197    21.250     0.150
     1.197    36.602     0.150
     1.306    23.336     0.150
     1.268    22.492     0.150
     1.584    26.727     0.150
     1.839    30.172     0.150
     1.839    50.352     0.150
     1.816    31.961     0.150
     1.816    54.352     0.150
     2.229    69.289     0.150
     2.249    39.375     0.150
     3.494    52.820     0.150
    21.242   285.062     0.150
     2.766    42.527     0.150
     2.850    51.227     0.150
     3.729    62.996     0.150
     4.704    76.418     0.150
     4.669   114.848     0.150
    10.806   817.027     0.150
    10.829   814.082     0.150
    10.876   818.426     0.150
    13.675   190.605     0.150
    19.086   263.406     0.150
    19.552   270.387     0.150
    21.619   290.086     0.150
    21.965   297.715     0.150
    24.005   311.316     0.150
    24.048   311.695     0.150
    24.585   320.328     0.150
    26.446   334.027     0.150
    26.920   339.508     0.150
    27.888   350.637     0.150
    28.777   357.625     0.150
    29.169   362.695     0.150
    30.489   371.766     0.150
    52.473  3919.738     0.150
    53.724  4027.551     0.150
    53.733  4033.020     0.150
    53.742  4027.461     0.150
    54.399   567.168     0.150
    55.949   579.016     0.150
    62.805  4693.535     0.150
     0.087     6.789     0.150
     0.514    11.449     0.150
     0.514    19.066     0.150
     0.863    15.727     0.150
     1.062    19.566     0.150
     1.338    22.859     0.150
     1.345    22.969     0.150
     1.345    39.156     0.150
     1.675    27.617     0.150
     1.743    28.719     0.150
     1.896    31.668     0.150
     2.207    58.008     0.150
     2.207    35.559     0.150
     2.442    31.289     0.150
     2.442    63.750     0.150
     2.442    63.750     0.150
     2.582    42.590     0.150
     2.629    77.180     0.150
     2.629    40.770     0.150
     2.695    81.090     0.150
     2.904    49.047     0.150
     2.904    87.020     0.150
     3.655    54.719     0.150
     3.683    59.258     0.150
     3.969    63.840     0.150
     4.394    68.418     0.150
     4.554    70.328     0.150
     4.635    81.648     0.150
     4.801   124.789     0.150
     5.598    75.020     0.150
     5.995    82.848     0.150
     5.995   151.508     0.150
    12.736   408.527     0.150
    17.832   247.148     0.150
    19.872   269.090     0.150
    21.890   291.809     0.150
    22.270   295.809     0.150
    24.120   311.500     0.150
    24.308   315.379     0.150
    26.619   337.438     0.150
    54.003  4038.562     0.150
    54.011  4037.906     0.150
    54.020  4036.934     0.150
     0.697    14.172     0.150
     0.697    24.070     0.150
     0.710    23.992     0.150
     0.941    31.750     0.150
     0.941    17.344     0.150
     0.941    31.750     0.150
     0.920    17.070     0.150
     0.920    29.391     0.150
     0.924    17.719     0.150
     0.924    30.266     0.150
     1.183    37.734     0.150
     1.183    21.430     0.150
     1.183    37.734     0.150
     1.226    39.266     0.150
     1.286    22.250     0.150
     1.286    37.500     0.150
     1.326    35.781     0.150
     1.917    32.602     0.150
     1.917    56.680     0.150
     2.078    34.891     0.150
     2.078    59.555     0.150
     2.104    66.812     0.150
     2.112    36.016     0.150
     2.112    60.070     0.150
     2.097    34.609     0.150
     2.097    61.133     0.150
     2.135    69.125     0.150
     2.185    38.461     0.150
     2.185    38.461     0.150
     2.389    39.023     0.150
     2.389    72.805     0.150
     2.514    77.812     0.150
     2.514    39.930     0.150
     2.514    77.812     0.150
     2.675    47.172     0.150
     2.675    47.172     0.150
     2.675    70.805     0.150
     2.645    74.992     0.150
     2.645    42.836     0.150
     2.645    74.992     0.150
     2.947    85.594     0.150
     2.947    46.641     0.150
     2.947    85.594     0.150
     2.940    88.234     0.150
     3.157    91.289     0.150
     3.469    95.305     0.150
     3.654   101.289     0.150
     3.654    53.836     0.150
     3.654   101.289     0.150
     3.872   107.891     0.150
     3.872    58.953     0.150
     3.872   107.891     0.150
     3.878    61.109     0.150
     3.878   107.719     0.150
     4.422    66.086     0.150
     4.422   116.883     0.150
     4.435    67.391     0.150
     4.435   118.133     0.150
     4.422   122.633     0.150
     4.422    67.820     0.150
     4.422   122.633     0.150
     5.019    84.531     0.150
     5.111    79.242     0.150
     5.111   138.000     0.150
     5.296    80.062     0.150
     5.296   146.375     0.150
     5.561    84.336     0.150
     5.561   147.656     0.150
     5.617    84.109     0.150
     5.617   143.766     0.150
     5.969   161.242     0.150
     6.100   165.992     0.150
     6.345   174.609     0.150
     6.543   172.891     0.150
     6.543   172.891     0.150
     6.735   181.125     0.150
     6.735   181.125     0.150
     7.640   117.805     0.150
     7.640   117.805     0.150
     7.640   192.695     0.150
     7.935   114.211     0.150
     7.935   202.703     0.150
     9.394   138.250     0.150
     9.394   242.109     0.150
    11.570   843.375     0.150
    11.595   844.828     0.150
    11.637   842.609     0.150
    11.745   301.961     0.150
    11.745   168.875     0.150
    11.745   301.961     0.150
    11.905   165.742     0.150
    12.819   186.773     0.150
    13.081   186.492     0.150
    13.257   186.750     0.150
    13.503   190.734     0.150
    15.045   210.883     0.150
    15.100   215.781     0.150
    15.396   219.031     0.150
    16.062   223.523     0.150
    17.726   243.961     0.150
    18.177   249.836     0.150
    18.695   251.133     0.150
    18.693   259.250     0.150
    19.545   265.039     0.150
    21.261   283.992     0.150
    21.506   285.500     0.150
    21.513   285.875     0.150
    21.518   288.789     0.150
    21.805   289.844     0.150
    22.094   291.570     0.150
    22.258   293.141     0.150
    22.397   545.703     0.150
    22.896   304.211     0.150
    22.896   304.164     0.150
    22.918   300.719     0.150
    23.432   306.414     0.150
    23.468   309.281     0.150
    23.509   308.703     0.150
    23.934   311.164     0.150
    24.057   316.227     0.150
    24.261   316.094     0.150
    24.298   316.695     0.150
    24.301   316.586     0.150
    24.428   318.523     0.150
    24.657   317.492     0.150
    24.655   321.836     0.150
    24.968   321.031     0.150
    25.207   322.062     0.150
    25.300   325.695     0.150
    25.362   326.695     0.150
    25.500   328.250     0.150
    25.794   332.391     0.150
    25.852   331.469     0.150
    25.951   329.789     0.150
    25.971   330.664     0.150
    26.059   330.656     0.150
    26.121   333.445     0.150
    26.117   333.555     0.150
    26.482   334.336     0.150
    26.485   336.852     0.150
    26.781   339.531     0.150
    26.929   342.453     0.150
    26.925   338.445     0.150
    26.927   338.789     0.150
    27.017   339.672     0.150
    27.055   344.062     0.150
    27.167   341.984     0.150
    27.247   342.602     0.150
    27.439   343.656     0.150
    27.446   341.445     0.150
    27.465   345.211     0.150
    27.669   348.250     0.150
    27.939   349.516     0.150
    28.044   351.094     0.150
    28.173   348.133     0.150
    28.226   352.109     0.150
    28.226   352.086     0.150
    28.265   352.562     0.150
    28.456   352.531     0.150
    28.681   353.484     0.150
    28.687   357.102     0.150
    28.986   357.055     0.150
    29.189   361.250     0.150
    29.518   361.062     0.150
    29.892   366.969     0.150
    30.484   371.375     0.150
    30.486   372.359     0.150
    30.902   375.430     0.150
    31.152   376.602     0.150
    31.172   377.156     0.150
    31.407   376.000     0.150
    31.803   383.070     0.150
    31.828   383.203     0.150
    31.924   385.180     0.150
    32.047   384.523     0.150
    32.179   388.383     0.150
    32.254   387.109     0.150
    32.966   394.039     0.150
    33.319   392.164     0.150
    34.355   407.555     0.150
    34.364   404.781     0.150
    34.435   406.828     0.150
    34.612   407.125     0.150
    36.091   421.625     0.150
    37.784   433.000     0.150
    37.929   435.234     0.150
    43.715   481.453     0.150
    44.855   494.445     0.150
    45.144   493.625     0.150
    47.630   514.812     0.150
    48.148  3532.609     0.150
    49.070   526.664     0.150
    50.759   539.086     0.150
    50.811   538.891     0.150
    53.610  3988.336     0.150
    53.618  3989.516     0.150
    53.627  3988.477     0.150
    53.734   562.742     0.150
    55.288   574.094     0.150
    55.823   574.750     0.150
    56.057   577.812     0.150
    56.191   578.820     0.150
    56.276   579.641     0.150
    56.448   579.312     0.150
    56.642   581.000     0.150
    56.819   582.469     0.150
    56.848   584.156     0.150
    57.312   585.859     0.150
    57.499   587.992     0.150
    57.594   588.750     0.150
    57.809  4304.609     0.150
    57.789   589.656     0.150
    57.799   589.609     0.150
    57.799   589.570     0.150
    58.903   595.844     0.150
    59.111   599.094     0.150
    59.746   603.055     0.150
    60.301   606.805     0.150
    60.301   606.680     0.150
    60.533  1098.914     0.150
    61.607   611.812     0.150
    63.143   626.391     0.150
    63.573  1136.516     0.150
    63.573  4733.414     0.150
    64.779   638.430     0.150
    64.779   637.375     0.150
    64.948   640.953     0.150
    64.973   655.016     0.150
    65.277   639.422     0.150
    66.814   651.836     0.150
    67.873   657.750     0.150
    76.150     8.703     0.150
    76.150  1346.711     0.150
    78.522   718.016     0.150
    80.348   739.711     0.150
    80.849   731.516     0.150
    81.686   747.352     0.150
    82.846   742.680     0.150
    83.059   756.039     0.150
    83.059  1381.453     0.150
    83.449   756.750     0.150
    83.449  1389.305     0.150
    83.554   754.289     0.150
    85.371   754.312     0.150
    85.921     9.344     0.150
    88.673   773.469     0.150
    89.885   778.992     0.150
    89.885    10.352     0.150
    89.942    18.000     0.150
    89.942  2002.812     0.150
    89.942  2224.812     0.150
    89.942   776.812     0.150
    89.942    11.602     0.150
    89.942  1405.812     0.150
    89.942  1432.812     0.150
    90.120   790.016     0.150
    90.340    10.500     0.150
    90.567   780.312     0.150
    90.611    10.539     0.150
    90.669   792.609     0.150
    90.669  1779.812     0.150
    90.730    10.516     0.150
    90.904    10.219     0.150
    90.972    11.078     0.150
    91.279   784.312     0.150
    91.279   795.812     0.150
    91.279  1414.211     0.150
    91.279  1802.609     0.150
    91.427   796.414     0.150
    91.427  1414.016     0.150
    91.427  1806.812     0.150
    91.485   783.195     0.150
    91.485   781.492     0.150
    91.740    11.602     0.150
    92.086   799.516     0.150
    92.248   800.211     0.150
    92.248  1420.914     0.150
    92.248  1816.711     0.150
    92.286    10.547     0.150
    92.465  1127.609     0.150
    92.465  2040.211     0.150
    92.923   801.914     0.150
    92.934   802.711     0.150
    93.093    10.484     0.150
    93.188   804.656     0.150
    93.217   804.516     0.150
    93.217   793.031     0.150
    93.305    10.398     0.150
    93.786   806.609     0.150
    93.786   796.016     0.150
    93.786   806.609     0.150
    94.221   796.281     0.150
    94.950   811.891     0.150
    95.517   801.109     0.150
    95.517   801.070     0.150
    95.633   802.211     0.150
    95.633  1031.711     0.150
    95.633  1152.414     0.150
    95.633  1862.414     0.150
    95.633  1862.414     0.150
    95.678  1034.211     0.150
    95.678  1154.516     0.150
    95.678  1436.016     0.150
    95.678  1868.211     0.150
    95.678  2094.312     0.150
    95.678   802.883     0.150
    95.678   802.883     0.150
    95.678   802.883     0.150
    95.678  1034.289     0.150
    95.678  1154.555     0.150
    95.678  1436.102     0.150
    95.678  1868.289     0.150
    95.678  2094.320     0.150
    95.850   821.812     0.150
    95.850   806.109     0.150
    95.850   821.812     0.150
    96.458   814.016     0.150
    96.458   821.211     0.150
    96.949   821.445     0.150
    97.736   823.453     0.150
    97.736   823.414     0.150
    97.767   812.016     0.150
    98.929  1511.516     0.150
   100.320   836.945     0.150
   112.883  2359.414     0.150
   116.558  1751.164     0.150
   120.414  1213.016     0.150
   120.414  1127.484     0.150
   126.850  1142.023     0.150
   127.646  1144.125     0.150
   128.017  1143.812     0.150
   136.460  1160.164     0.150
   138.071  1156.109     0.150
   138.071  1156.109     0.150
   139.637  1162.414     0.150
   140.676  1160.664     0.150
   144.045  1169.812     0.150
   153.811  1190.414     0.150
   153.893  1192.516     0.150
     0.423    18.684     0.150
     0.815    25.676     0.150
     0.865    16.734     0.150
     0.865    27.363     0.150
     2.468    34.375     0.150
     6.375    99.273     0.150
    11.335   165.492     0.150
    17.908   250.746     0.150
    18.021   251.645     0.150
    18.124   250.602     0.150
    19.200    11.727     0.150
    19.200   262.875     0.150
    21.213   299.273     0.150
    21.391   287.086     0.150
    21.424   288.137     0.150
    22.008   292.086     0.150
    22.035   292.500     0.150
    22.143   293.953     0.150
    22.144   293.918     0.150
    22.855   318.227     0.150
    22.910    14.223     0.150
    22.978   302.703     0.150
    22.991   303.609     0.150
    23.537   310.027     0.150
    23.852   312.156     0.150
    23.870   328.574     0.150
    24.856   318.656     0.150
    24.998   322.262     0.150
    25.889   330.254     0.150
    25.945   330.551     0.150
    26.370   351.047     0.150
    27.147   339.004     0.150
    29.441   358.902     0.150
    29.704   381.016     0.150
    30.224   385.797     0.150
    34.266   406.586     0.150
    34.453   408.215     0.150
    36.607   425.520     0.150
    53.560  3988.828     0.150
    53.568  3989.160     0.150
    53.577  3988.145     0.150
    57.247   584.270     0.150
    84.493   748.250     0.150
   115.977  1198.676     0.150
   115.977  2152.176     0.150
     2.166    65.984     0.150
     2.282    41.924     0.150
     2.558    38.714     0.150
     3.006    51.354     0.150
     3.006    88.314     0.150
     4.685   120.354     0.150
     5.731    80.805     0.150
     0.876    26.047     0.150
     1.959    56.906     0.150
     1.958    59.078     0.150
     2.157    63.922     0.150
     2.224    69.055     0.150
     2.353    73.477     0.150
     2.461    42.336     0.150
     2.824    84.656     0.150
     2.998    55.344     0.150
     2.998    91.164     0.150
     3.779   106.031     0.150
     4.039   112.367     0.150
     4.125   128.242     0.150
     4.132   123.531     0.150
     4.153   125.992     0.150
     4.277   120.766     0.150
     9.427   137.141     0.150
    54.169  4060.133     0.150
    54.178  4060.617     0.150
    54.187  4060.195     0.150
     0.294     7.928     0.150
     0.294     7.998     0.150
     0.294    12.479     0.150
     0.372    12.787     0.150
     0.372     8.408     0.150
     0.419    15.059     0.150
     0.461     9.979     0.150
     0.461     9.979     0.150
     0.461    16.367     0.150
     0.864    16.447     0.150
     0.864    16.447     0.150
     0.864    27.518     0.150
     0.929    17.838     0.150
     0.929    29.729     0.150
     1.222    22.387     0.150
     1.295    23.197     0.150
     1.675    29.537     0.150
     1.686    29.848     0.150
     1.724    29.998     0.150
     1.788    31.059     0.150
     1.788    54.928     0.150
     1.817    31.479     0.150
     1.817    58.037     0.150
     1.918    32.857     0.150
     1.918    57.467     0.150
     2.170    64.637     0.150
     2.170    64.637     0.150
     2.135    35.318     0.150
     2.135    65.309     0.150
     2.236    42.148     0.150
     3.331    93.457     0.150
     3.593    63.588     0.150
     4.375   123.008     0.150
     4.820   133.697     0.150
     4.972   136.018     0.150
    15.321   213.143     0.150
    19.217   264.857     0.150
    21.545   290.951     0.150
    21.892   292.439     0.150
    21.902   294.195     0.150
    21.922   290.836     0.150
    22.249   296.246     0.150
    22.761   302.137     0.150
    24.824   325.787     0.150
    26.953   341.773     0.150
    29.159   359.914     0.150
    30.267   370.551     0.150
    31.536   385.098     0.150
    32.135   388.867     0.150
    47.611  3560.898     0.150
    53.572  4023.771     0.150
    53.580  4024.951     0.150
    53.589  4021.855     0.150
    54.816   571.061     0.150
    55.462   575.932     0.150
    56.860   583.895     0.150
    63.048  4722.098     0.150
   120.676  1139.898     0.150
     1.144    20.078     0.150
     1.867    37.088     0.150
     2.464    21.008     0.150
     2.464    50.197     0.150
     2.582    40.328     0.150
     2.816    39.889     0.150
     2.889    49.299     0.150
     4.073   103.229     0.150
     0.477    11.703     0.150
     0.477    19.354     0.150
     0.923    28.363     0.150
     0.923    17.104     0.150
     0.923    28.363     0.150
     1.110    19.883     0.150
     1.110    33.662     0.150
     1.275    22.363     0.150
     1.397    24.373     0.150
     1.397    41.604     0.150
     1.399    24.242     0.150
     1.399    41.523     0.150
     1.379    24.293     0.150
     1.379    41.143     0.150
     1.690    27.742     0.150
     1.690    47.312     0.150
     1.801    29.723     0.150
     1.801    51.832     0.150
     1.724    29.162     0.150
     1.724    50.143     0.150
     1.930    31.873     0.150
     1.930    54.773     0.150
     1.960    31.443     0.150
     1.960    54.992     0.150
     1.955    42.383     0.150
     1.955    66.152     0.150
     2.047    33.172     0.150
     2.047    57.742     0.150
     2.135    34.922     0.150
     2.135    60.963     0.150
     2.263    36.764     0.150
     2.263    67.443     0.150
     2.309    36.434     0.150
     2.309    65.662     0.150
     2.375    37.623     0.150
     2.421    73.582     0.150
     2.488    70.283     0.150
     2.505    37.363     0.150
     2.505    37.363     0.150
     2.505    69.303     0.150
     2.533    39.773     0.150
     2.533    69.672     0.150
     2.603    39.062     0.150
     2.603    39.062     0.150
     2.603    76.943     0.150
     2.644    41.172     0.150
     2.644    74.422     0.150
     2.690    41.703     0.150
     2.690    71.232     0.150
     2.738    42.863     0.150
     2.738    79.514     0.150
     2.710    42.912     0.150
     2.710    70.893     0.150
     2.798    43.213     0.150
     2.798    78.242     0.150
     2.878    83.264     0.150
     2.878    44.184     0.150
     2.878    83.264     0.150
     2.904    44.604     0.150
     2.904    85.582     0.150
     2.915    45.252     0.150
     2.915    79.293     0.150
     2.976    47.643     0.150
     3.248    52.162     0.150
     3.248    88.562     0.150
     3.347    95.264     0.150
     3.667    95.094     0.150
     3.638    55.723     0.150
     3.638    98.514     0.150
     3.726    56.953     0.150
     3.726    94.672     0.150
     4.387   121.113     0.150
     4.392    68.934     0.150
     4.546    70.943     0.150
     4.675    69.543     0.150
     4.675   121.502     0.150
     4.854    71.912     0.150
     4.854   132.062     0.150
     5.513    83.113     0.150
     5.513   146.514     0.150
     6.030    92.934     0.150
     6.030   157.953     0.150
     6.369    92.844     0.150
     6.369   168.752     0.150
     6.422    95.184     0.150
     6.422   162.582     0.150
     8.120   120.322     0.150
     9.560   140.873     0.150
     9.560   246.594     0.150
    15.400   214.334     0.150
    18.206   251.254     0.150
    20.037   270.402     0.150
    20.964   278.953     0.150
    21.353   282.572     0.150
    22.241   292.529     0.150
    22.321   293.820     0.150
    22.328   294.684     0.150
    22.373   292.441     0.150
    24.040   312.479     0.150
    24.250   313.873     0.150
    24.312   317.514     0.150
    24.378   314.113     0.150
    25.155   321.521     0.150
    25.258   327.213     0.150
    25.382   327.434     0.150
    25.382   327.338     0.150
    25.991   329.756     0.150
    26.997   340.764     0.150
    27.682   347.283     0.150
    27.787   346.104     0.150
    28.452   352.801     0.150
    30.693   372.133     0.150
    31.535   380.551     0.150
    32.338   388.482     0.150
    32.659   386.383     0.150
    47.001   509.393     0.150
    50.055   531.207     0.150
    50.826   537.059     0.150
    54.369   566.023     0.150
    54.912   566.861     0.150
    54.944   565.188     0.150
    54.950   565.281     0.150
    55.034   567.244     0.150
    55.230   571.453     0.150
    55.230   568.234     0.150
    55.551   573.232     0.150
    55.551   573.383     0.150
    55.908   574.207     0.150
    56.340   577.420     0.150
    57.146   585.723     0.150
    57.532   585.070     0.150
    57.532   585.072     0.150
    58.228   590.488     0.150
    58.282   590.836     0.150
    58.335   590.180     0.150
    58.377   590.148     0.150
    58.405   589.797     0.150
    58.479   591.053     0.150
    58.735   595.934     0.150
    58.735   593.344     0.150
    58.785   593.730     0.150
    59.267   597.021     0.150
    59.335   597.432     0.150
    59.883   604.123     0.150
    60.214   606.854     0.150
    60.293   606.252     0.150
    60.550   605.949     0.150
    60.729   606.910     0.150
    60.772   607.553     0.150
    85.671   756.502     0.150
   129.473  1147.332     0.150
     0.190     5.582     0.150
     0.190     8.988     0.150
     0.249     6.648     0.150
     0.249    10.422     0.150
     0.592    17.230     0.150
     0.592    11.871     0.150
     0.592    17.230     0.150
     1.129    21.469     0.150
     1.129    36.711     0.150
     1.145    21.102     0.150
     1.145    35.430     0.150
     1.347    24.871     0.150
     1.499    27.559     0.150
     1.499    46.059     0.150
     1.571    27.379     0.150
     1.571    45.230     0.150
     1.611    28.020     0.150
     1.611    48.832     0.150
     1.618    28.680     0.150
     1.618    49.820     0.150
     1.864    32.711     0.150
     1.864    53.961     0.150
     1.883    32.352     0.150
     1.883    55.672     0.150
     1.922    33.219     0.150
     1.922    57.410     0.150
     2.080    35.238     0.150
     2.080    60.480     0.150
     2.162    35.660     0.150
     2.162    62.910     0.150
     2.177    37.750     0.150
     2.177    67.781     0.150
     2.491    42.820     0.150
     2.491    66.141     0.150
     2.502    41.879     0.150
     2.502    75.000     0.150
     2.519    45.559     0.150
     2.584    42.449     0.150
     2.584    70.059     0.150
     2.588    43.719     0.150
     2.692    43.719     0.150
     2.692    77.500     0.150
     2.715    43.969     0.150
     2.715    79.570     0.150
     2.775    44.539     0.150
     2.775    78.602     0.150
     2.849    45.500     0.150
     2.849    80.148     0.150
     2.878    45.480     0.150
     2.878    84.148     0.150
     2.857    47.172     0.150
     2.857    79.941     0.150
     2.969    53.000     0.150
     2.969    81.770     0.150
     3.091    52.629     0.150
     3.091    84.961     0.150
     3.107    54.031     0.150
     3.107    87.949     0.150
     3.188    53.531     0.150
     3.188    91.480     0.150
     3.206    51.770     0.150
     3.456    58.371     0.150
     3.456    93.930     0.150
     3.607    56.719     0.150
     3.607    93.621     0.150
     3.775    58.199     0.150
     3.775   102.551     0.150
     3.781   106.141     0.150
     4.238    65.039     0.150
     4.238   119.711     0.150
     4.569    72.922     0.150
     4.621    74.641     0.150
     4.635    70.172     0.150
     4.635   124.582     0.150
     4.707    73.988     0.150
     4.891   155.852     0.150
     5.086    94.051     0.150
     6.226    92.590     0.150
     6.226   165.750     0.150
     6.277    96.199     0.150
     6.277   170.582     0.150
     6.316   101.070     0.150
     6.316   101.070     0.150
     6.316   166.969     0.150
     6.331    95.332     0.150
     6.331   158.699     0.150
     8.028   122.770     0.150
    15.922   223.301     0.150
    16.298   230.770     0.150
    16.852   237.281     0.150
    19.071   263.270     0.150
    21.782   293.145     0.150
    24.242   320.137     0.150
    24.255   315.320     0.150
    27.232   345.109     0.150
    51.443   546.414     0.150
    53.733  4031.242     0.150
    53.742  4032.438     0.150
    53.751  4031.500     0.150
    55.264   574.941     0.150
    55.301   574.832     0.150
    55.487   576.219     0.150
    56.015   581.008     0.150
    60.321   607.309     0.150
     0.871    17.398     0.150
     0.871    27.852     0.150
     0.824    16.441     0.150
     0.824    26.309     0.150
     0.870    18.871     0.150
     0.870    29.781     0.150
     0.870    18.871     0.150
     0.870    29.781     0.150
     1.327    39.102     0.150
     1.327    24.230     0.150
     1.327    39.102     0.150
     1.453    27.352     0.150
     1.453    47.340     0.150
     1.482    28.031     0.150
     1.482    46.242     0.150
     1.576    28.441     0.150
     1.576    47.070     0.150
     1.689    50.082     0.150
     1.689    30.359     0.150
     1.689    50.082     0.150
     1.810    32.109     0.150
     1.810    55.250     0.150
     1.987    34.680     0.150
     1.987    60.242     0.150
     1.864    33.242     0.150
     1.864    60.969     0.150
     2.403    41.391     0.150
     2.403    71.539     0.150
     2.495    41.730     0.150
     2.495    71.801     0.150
     2.529    41.730     0.150
     2.529    75.059     0.150
     2.599    42.680     0.150
     2.599    77.531     0.150
     3.032    51.961     0.150
     3.597   100.211     0.150
     3.834    63.430     0.150
     3.814    65.281     0.150
     4.025    62.672     0.150
     4.025   108.262     0.150
     4.100   106.672     0.150
     4.275    61.801     0.150
     4.509    69.699     0.150
     4.509   119.121     0.150
     4.679   116.211     0.150
     4.806   124.582     0.150
     5.294   146.191     0.150
     5.439   149.949     0.150
     5.637   141.309     0.150
     5.637    85.059     0.150
     5.637   141.309     0.150
     5.675    87.430     0.150
     5.675   156.930     0.150
     6.477   102.148     0.150
     6.588    98.301     0.150
     6.588   175.359     0.150
     6.621   106.461     0.150
     6.621   181.242     0.150
    21.841   296.414     0.150
    22.935   305.879     0.150
    23.203   311.145     0.150
    23.479   306.688     0.150
    25.461   332.621     0.150
    26.524   343.207     0.150
    26.828   350.422     0.150
    28.681   364.367     0.150
    56.674   585.148     0.150
    57.922   594.031     0.150
    59.046   601.637     0.150
    62.735   637.395     0.150
    72.718   685.219     0.150
   129.347  1151.152     0.150
   129.986  1150.922     0.150
   141.065  1173.672     0.150
     3.592    90.055     0.150
     3.680   101.070     0.150
     3.684    91.875     0.150
     3.751    91.875     0.150
     3.829   104.758     0.150
     3.920   111.227     0.150
     4.013    63.352     0.150
     4.013   111.016     0.150
     4.449    60.055     0.150
     2.215    64.316     0.150
     2.213    40.555     0.150
     2.483    73.395     0.150
     2.524    36.414     0.150
     2.905    84.184     0.150
     3.493    94.477     0.150
     0.332    10.255     0.150
     0.332    10.274     0.150
     0.332    15.635     0.150
     0.455    14.784     0.150
     0.455     9.675     0.150
     0.455    15.404     0.150
     0.858    26.774     0.150
     0.858    16.625     0.150
     0.858    26.774     0.150
     1.075    32.154     0.150
     1.268    23.625     0.150
     1.245    23.725     0.150
     1.245    40.614     0.150
     1.245    24.255     0.150
     1.313    25.574     0.150
     1.313    25.465     0.150
     1.427    26.925     0.150
     1.724    30.864     0.150
     1.731    32.024     0.150
     1.731    53.274     0.150
     1.818    31.685     0.150
     1.818    50.194     0.150
     1.780    31.925     0.150
     1.852    33.725     0.150
     1.852    33.725     0.150
     1.971    34.864     0.150
     1.971    34.864     0.150
     2.130    35.984     0.150
     2.130    59.494     0.150
     2.224    37.114     0.150
     2.224    67.074     0.150
     2.286    38.484     0.150
     2.286    66.715     0.150
     2.323    40.465     0.150
     2.323    40.465     0.150
     2.323    65.755     0.150
     2.544    44.795     0.150
     2.544    78.255     0.150
     2.617    43.685     0.150
     2.617    75.385     0.150
     2.670    45.795     0.150
     2.676    44.954     0.150
     2.676    79.484     0.150
     2.665    44.215     0.150
     2.665    78.645     0.150
     2.651    45.305     0.150
     2.650    45.305     0.150
     2.658    45.875     0.150
     2.658    76.925     0.150
     2.703    44.545     0.150
     2.703    44.545     0.150
     2.703    78.005     0.150
     2.791    45.744     0.150
     2.791    81.625     0.150
     2.938    48.005     0.150
     2.938    84.324     0.150
     3.106    51.465     0.150
     3.106    88.494     0.150
     3.164    47.994     0.150
     3.164    47.994     0.150
     3.164    93.484     0.150
     3.172    55.215     0.150
     3.172    93.204     0.150
     3.326    56.585     0.150
     3.347    55.585     0.150
     3.347    55.585     0.150
     3.347    89.904     0.150
     3.645    59.045     0.150
     3.701    57.335     0.150
     3.701   101.704     0.150
     3.657    58.494     0.150
     3.698   102.935     0.150
     4.040    62.484     0.150
     4.040   104.135     0.150
     4.437    72.975     0.150
     4.437    72.975     0.150
     4.437   122.185     0.150
     4.437   122.185     0.150
     4.410    68.324     0.150
     4.410   125.585     0.150
     4.549    69.055     0.150
     4.830    76.675     0.150
     4.971    77.564     0.150
     5.221    77.675     0.150
     5.954    91.284     0.150
     6.082   167.005     0.150
     6.082    93.704     0.150
     6.082   167.005     0.150
     6.079    92.284     0.150
     6.381    93.265     0.150
     6.381   175.895     0.150
     6.743   107.944     0.150
     7.043    96.574     0.150
     7.043   188.435     0.150
     7.164   109.765     0.150
    11.120   822.650     0.150
    15.909   227.774     0.150
    17.896   247.164     0.150
    23.895   311.135     0.150
    24.056   312.625     0.150
    25.151   324.005     0.150
    25.672   330.734     0.150
    26.170   332.385     0.150
    26.369   333.085     0.150
    26.499   335.395     0.150
    27.715   344.935     0.150
    27.943   347.784     0.150
    53.536  4025.174     0.150
    53.544  4023.200     0.150
    53.553  4025.204     0.150
   132.402  1152.395     0.150
     1.117    33.953     0.150
     2.243    68.012     0.150
     2.289    29.520     0.150
     2.321    70.031     0.150
     2.339    34.203     0.150
     2.356    71.051     0.150
     2.783    38.363     0.150
     3.046    48.680     0.150
     4.046    61.281     0.150
     4.046   105.121     0.150
     4.052   114.742     0.150
     4.059    58.133     0.150
     4.079   115.012     0.150
     4.098   115.473     0.150
     4.130   116.012     0.150
     4.206    67.410     0.150
     2.336    33.924     0.150
     3.181    45.305     0.150
     0.226     6.117     0.150
     0.226     9.777     0.150
     0.513    19.057     0.150
     0.513    11.027     0.150
     0.513    19.057     0.150
     0.579    20.857     0.150
     0.753    14.928     0.150
     0.753    25.957     0.150
     1.245    21.617     0.150
     1.245    37.477     0.150
     1.294    23.848     0.150
     1.294    39.316     0.150
     1.398    25.217     0.150
     1.398    41.428     0.150
     1.744    30.467     0.150
     1.744    51.207     0.150
     1.747    29.928     0.150
     1.747    50.857     0.150
     2.031    61.797     0.150
     2.250    39.137     0.150
     2.250    64.977     0.150
     2.253    35.836     0.150
     2.253    63.387     0.150
     2.359    38.258     0.150
     2.359    67.107     0.150
     2.415    39.727     0.150
     2.415    68.258     0.150
     2.567    41.787     0.150
     2.567    72.076     0.150
     2.675    43.268     0.150
     2.675    74.236     0.150
     2.711    44.297     0.150
     2.730    71.666     0.150
     2.730    42.938     0.150
     2.730    71.666     0.150
     2.782    41.576     0.150
     2.755    44.227     0.150
     2.755    77.217     0.150
     2.817    75.156     0.150
     2.850    40.688     0.150
     2.850    77.496     0.150
     2.885    75.977     0.150
     2.903    46.098     0.150
     2.903    79.646     0.150
     2.922    47.678     0.150
     2.922    80.697     0.150
     2.978    48.656     0.150
     2.978    83.457     0.150
     2.974    46.688     0.150
     2.974    83.336     0.150
     3.041    43.906     0.150
     3.041    85.008     0.150
     3.129    49.758     0.150
     3.129    88.166     0.150
     3.199    50.227     0.150
     3.262    49.717     0.150
     3.262    49.717     0.150
     3.262    90.066     0.150
     3.297    51.586     0.150
     3.426    53.307     0.150
     3.426    93.947     0.150
     3.544    53.246     0.150
     3.544    92.877     0.150
     3.950    63.797     0.150
     3.950   108.137     0.150
     3.979    63.457     0.150
     3.979   109.297     0.150
     4.084    63.646     0.150
     4.239   115.357     0.150
     4.287   116.227     0.150
     4.287    64.887     0.150
     4.287   116.227     0.150
     5.304    78.646     0.150
     5.304   139.896     0.150
     5.391    83.357     0.150
     5.683    88.307     0.150
     5.683   151.258     0.150
     6.270    92.188     0.150
     6.270   160.916     0.150
     6.992   104.258     0.150
     7.015   102.947     0.150
     7.015   187.027     0.150
     8.031   219.117     0.150
     8.439   125.996     0.150
     8.439   216.246     0.150
     8.691   128.367     0.150
     9.355   138.877     0.150
     9.355   237.877     0.150
    10.250   760.211     0.150
    11.576   169.018     0.150
    11.990   311.041     0.150
    12.752   182.896     0.150
    13.553   193.361     0.150
    13.553   191.697     0.150
    13.674   194.471     0.150
    15.098   217.027     0.150
    15.287   215.330     0.150
    15.428   222.836     0.150
    15.815   226.467     0.150
    16.725   233.547     0.150
    17.968   249.234     0.150
    19.400   265.385     0.150
    20.532   277.688     0.150
    20.532   511.475     0.150
    20.695   281.748     0.150
    21.077   283.746     0.150
    21.657   287.609     0.150
    22.391   296.777     0.150
    22.410   296.785     0.150
    22.454   297.631     0.150
    22.454   296.896     0.150
    22.462   297.559     0.150
    22.791   300.098     0.150
    23.282   307.598     0.150
    23.866   311.916     0.150
    24.338   315.975     0.150
    24.414   318.395     0.150
    24.790   321.771     0.150
    24.923   322.975     0.150
    25.198   326.039     0.150
    25.445   327.359     0.150
    25.472   327.703     0.150
    25.577   328.248     0.150
    25.583   329.002     0.150
    25.701   329.609     0.150
    25.761   330.299     0.150
    25.807   331.646     0.150
    26.022   331.688     0.150
    26.637   337.873     0.150
    26.721   339.043     0.150
    26.778   339.869     0.150
    26.797   338.326     0.150
    26.819   339.605     0.150
    27.093   341.547     0.150
    27.099   341.365     0.150
    27.127   342.508     0.150
    27.131   342.326     0.150
    27.172   344.197     0.150
    27.238   346.197     0.150
    27.413   345.377     0.150
    27.616   348.396     0.150
    27.764   346.809     0.150
    27.783   349.330     0.150
    27.828   349.811     0.150
    27.892   349.598     0.150
    27.905   350.021     0.150
    27.970   349.885     0.150
    28.097   351.803     0.150
    28.219   351.189     0.150
    28.224   354.271     0.150
    28.439   354.570     0.150
    28.501   353.936     0.150
    28.580   354.107     0.150
    28.658   355.455     0.150
    28.834   358.539     0.150
    28.871   358.193     0.150
    29.239   360.508     0.150
    29.437   363.494     0.150
    29.801   366.586     0.150
    29.948   366.725     0.150
    30.783   374.602     0.150
    31.561   380.924     0.150
    31.890   385.277     0.150
    32.773   392.754     0.150
    33.286   397.711     0.150
    33.603   399.412     0.150
    33.943   402.719     0.150
    34.432   406.488     0.150
    34.529   408.539     0.150
    35.177   413.244     0.150
    35.430   416.152     0.150
    35.573   417.260     0.150
    36.449   425.574     0.150
    36.988   429.145     0.150
    36.987   430.143     0.150
    37.657   435.098     0.150
    37.737   436.199     0.150
    37.792   435.996     0.150
    38.472   442.102     0.150
    38.827   444.889     0.150
    39.165   447.980     0.150
    39.345   449.635     0.150
    39.404   450.004     0.150
    39.641   452.250     0.150
    39.707   452.148     0.150
    44.886   493.396     0.150
    45.822   503.098     0.150
    45.822   502.996     0.150
    46.873  3505.496     0.150
    48.780   527.039     0.150
    54.077  4064.135     0.150
    54.086  4063.736     0.150
    54.094  4067.510     0.150
    56.550  4241.797     0.150
    56.741   584.348     0.150
    58.088   594.566     0.150
    59.988   606.496     0.150
    60.506   609.396     0.150
    62.007   621.023     0.150
    65.488   648.537     0.150
    65.752   645.396     0.150
    78.853   723.287     0.150
    83.994   750.496     0.150
    85.755   760.771     0.150
    90.821   783.197     0.150
    90.821     9.100     0.150
    96.152   805.896     0.150
    96.152  1037.896     0.150
    99.562   822.297     0.150
   140.051  1170.246     0.150
     0.019     6.648     0.150
     0.019    10.555     0.150
     0.255     7.898     0.150
     0.255    12.328     0.150
     0.401    10.492     0.150
     0.401    10.492     0.150
     0.401    16.703     0.150
     0.735    14.398     0.150
     1.058    19.477     0.150
     1.058    32.633     0.150
     1.240    22.047     0.150
     1.422    24.875     0.150
     1.450    25.633     0.150
     1.467    35.445     0.150
     1.551    36.688     0.150
     1.551    26.719     0.150
     1.551    36.688     0.150
     1.535    36.484     0.150
     1.535    26.688     0.150
     1.535    36.484     0.150
     1.753    28.844     0.150
     1.951    32.180     0.150
     2.514    40.398     0.150
     4.330   118.148     0.150
     4.786   120.977     0.150
     4.786    71.328     0.150
     4.786   130.180     0.150
     4.967   136.977     0.150
     5.501   144.336     0.150
     6.179   166.375     0.150
    11.341   160.734     0.150
    11.493   281.680     0.150
    12.862   403.180     0.150
    15.059   210.758     0.150
    15.855   217.648     0.150
    16.148   223.539     0.150
    16.730   234.328     0.150
    19.897   269.867     0.150
    21.492   288.641     0.150
    21.841   291.891     0.150
    22.114   293.094     0.150
    22.240   292.953     0.150
    22.353   299.625     0.150
    22.737   301.148     0.150
    24.051   316.141     0.150
    24.063   312.859     0.150
    24.375   317.211     0.150
    24.477   319.227     0.150
    25.954   331.539     0.150
    28.131   349.219     0.150
    29.307   359.656     0.150
    30.173   369.680     0.150
    31.491   379.445     0.150
    31.776   385.047     0.150
    31.920   385.625     0.150
    34.327   403.664     0.150
    34.885   409.422     0.150
    37.792   434.586     0.150
    47.330  3543.586     0.150
    49.351   526.719     0.150
    51.443   541.859     0.150
    52.802   554.781     0.150
    53.147   556.227     0.150
    53.897  4036.117     0.150
    53.906  4038.734     0.150
    53.914  4037.812     0.150
    54.273   564.359     0.150
    56.522   580.297     0.150
    56.562   579.414     0.150
    57.001  4294.289     0.150
    57.088   585.008     0.150
    57.376   586.828     0.150
    57.868   590.555     0.150
    58.430   595.000     0.150
    58.435   594.977     0.150
    59.632   602.664     0.150
    60.515   609.797     0.150
    60.497   618.695     0.150
    61.854   616.656     0.150
    62.015   618.133     0.150
    62.824  4709.289     0.150
    63.132   625.883     0.150
    63.310   627.914     0.150
    63.884   638.039     0.150
    65.184   650.844     0.150
    65.586   649.648     0.150
     2.309    40.371     0.150
     2.973    75.043     0.150
     3.698    96.512     0.150
     4.435   120.820     0.150
     4.443   126.031     0.150
     4.589   116.066     0.150
     4.589   137.316     0.150
     4.525   108.871     0.150
     4.525   123.961     0.150
    53.980  4028.953     0.150
    53.989  4034.434     0.150
    53.998  4029.176     0.150
     0.479    10.379     0.150
     0.969    28.148     0.150
     1.196    37.340     0.150
     1.376    22.340     0.150
     1.376    42.090     0.150
     1.523    37.918     0.150
     1.842    54.758     0.150
     2.168    29.668     0.150
     2.240    38.539     0.150
     3.029    51.859     0.150
     3.419    58.047     0.150
     3.720    62.180     0.150
     3.964   101.578     0.150
     4.049    66.988     0.150
     4.970   145.207     0.150
     5.027   154.320     0.150
     5.035   155.418     0.150
     5.044   149.188     0.150
     5.080   159.457     0.150
     5.151   145.207     0.150
     5.206   147.219     0.150
     5.706    87.609     0.150
     5.907   173.227     0.150
     6.506   194.547     0.150
     6.634   176.207     0.150
     0.150    13.867     0.150
     0.150     8.539     0.150
     0.150    13.867     0.150
     0.394    10.891     0.150
     0.394    18.383     0.150
     0.754    23.289     0.150
     0.754    14.852     0.150
     0.754    23.289     0.150
     0.640    13.812     0.150
     0.640    23.133     0.150
     0.935    17.930     0.150
     0.935    30.711     0.150
     1.071    19.922     0.150
     1.182    21.500     0.150
     1.182    36.859     0.150
     1.223    22.031     0.150
     1.223    35.883     0.150
     1.311    23.070     0.150
     1.311    39.773     0.150
     1.590    27.414     0.150
     1.590    47.031     0.150
     1.616    27.320     0.150
     1.616    47.844     0.150
     1.763    28.914     0.150
     1.763    50.453     0.150
     1.783    29.398     0.150
     1.783    52.312     0.150
     1.763    29.922     0.150
     1.763    50.664     0.150
     1.845    31.023     0.150
     1.845    54.422     0.150
     1.825    30.469     0.150
     1.825    52.008     0.150
     2.043    32.594     0.150
     2.043    32.594     0.150
     2.043    58.938     0.150
     1.999    33.461     0.150
     1.999    56.578     0.150
     2.107    33.789     0.150
     2.258    35.484     0.150
     2.316    34.797     0.150
     2.316    64.000     0.150
     2.477    39.242     0.150
     2.477    68.547     0.150
     2.597    40.570     0.150
     2.707    41.750     0.150
     2.707    78.508     0.150
     2.632    74.188     0.150
     2.632    46.391     0.150
     2.632    74.188     0.150
     2.752    38.438     0.150
     2.809    83.641     0.150
     2.761    40.023     0.150
     2.781    40.562     0.150
     3.242    49.844     0.150
     3.242    89.000     0.150
     3.449    97.211     0.150
     3.636    56.812     0.150
     3.731    55.578     0.150
     3.731    99.281     0.150
     4.443   120.914     0.150
     4.435    66.219     0.150
     4.435    66.219     0.150
     4.519    68.070     0.150
     4.519    67.609     0.150
     4.519    77.586     0.150
     4.519    68.070     0.150
     4.706    75.164     0.150
     5.021    66.461     0.150
     5.021   123.508     0.150
     5.443    80.992     0.150
     5.884   148.828     0.150
     5.884    84.328     0.150
     5.884   148.828     0.150
     5.909   155.234     0.150
     6.041    88.219     0.150
     6.041   158.680     0.150
     6.228   166.984     0.150
     6.220    94.742     0.150
     6.220   156.539     0.150
     6.303    92.812     0.150
     7.410   191.484     0.150
     7.498   192.820     0.150
     7.693   204.094     0.150
     8.210   122.039     0.150
     9.050   232.891     0.150
     9.512   135.453     0.150
     9.512   244.070     0.150
    15.788   226.539     0.150
    15.788   226.656     0.150
    16.472   228.078     0.150
    18.974   257.070     0.150
    19.537   264.828     0.150
    21.439   288.539     0.150
    21.446   288.539     0.150
    23.971   310.039     0.150
    35.665   414.234     0.150
    54.056  4037.445     0.150
    54.064  4043.617     0.150
    54.073  4037.648     0.150
    58.024   591.641     0.150
    60.502   606.297     0.150
    60.425   610.492     0.150
    60.563   606.508     0.150
    61.744   616.172     0.150
    63.017   623.562     0.150
    63.275   625.023     0.150
     0.981    26.852     0.150
     1.705    53.320     0.150
     1.866    16.203     0.150
     1.866    37.523     0.150
     2.958    81.543     0.150
     3.292    84.594     0.150
     3.727    54.941     0.150
     3.767    96.820     0.150
     3.872    97.051     0.150
     0.765    15.957     0.150
     0.765    26.768     0.150
     0.838    29.578     0.150
     1.173    33.957     0.150
     1.453    26.797     0.150
     1.897    17.297     0.150
     1.897    40.658     0.150
     1.971    33.438     0.150
     2.071    32.027     0.150
     2.071    62.908     0.150
     2.086    36.037     0.150
     2.090    36.127     0.150
     2.142    32.137     0.150
     3.184    55.367     0.150
     4.980   126.268     0.150
     5.111   137.857     0.150
     1.853    16.674     0.150
     1.853    42.123     0.150
     1.919    57.854     0.150
     1.975    53.725     0.150
     2.291    66.594     0.150
     2.298    71.385     0.150
     2.326    37.023     0.150
     2.995    78.193     0.150
     3.355    55.744     0.150
     4.149   109.264     0.150
     4.267    67.814     0.150
     4.566   127.244     0.150
     4.695    77.193     0.150
     4.917   133.564     0.150
     5.300   137.564     0.150
     6.065   156.924     0.150
     0.226     8.039     0.150
     0.226    13.203     0.150
     0.274     8.633     0.150
     0.274    14.055     0.150
     0.331     9.164     0.150
     0.331    15.164     0.150
     0.842    26.562     0.150
     0.842    15.953     0.150
     0.842    26.562     0.150
     0.873    17.125     0.150
     0.873    28.898     0.150
     1.242    22.492     0.150
     1.242    37.562     0.150
     1.348    24.336     0.150
     1.348    40.562     0.150
     1.378    35.484     0.150
     1.478    43.406     0.150
     1.478    25.938     0.150
     1.478    43.406     0.150
     1.555    26.125     0.150
     1.555    44.086     0.150
     1.861    30.312     0.150
     1.861    50.812     0.150
     1.893    31.336     0.150
     1.893    31.336     0.150
     1.893    54.266     0.150
     1.891    57.266     0.150
     1.891    31.719     0.150
     1.891    57.266     0.150
     1.934    31.477     0.150
     1.934    57.258     0.150
     2.069    34.305     0.150
     2.232    36.508     0.150
     2.232    65.805     0.150
     2.238    68.219     0.150
     2.251    69.297     0.150
     2.285    67.289     0.150
     2.290    37.539     0.150
     2.290    63.414     0.150
     2.294    36.992     0.150
     2.294    66.258     0.150
     2.314    69.492     0.150
     2.329    54.773     0.150
     2.329    34.844     0.150
     2.331    40.773     0.150
     2.356    40.312     0.150
     2.356    43.109     0.150
     2.375    41.703     0.150
     2.400    43.109     0.150
     2.432    72.406     0.150
     2.441    71.477     0.150
     2.463    39.062     0.150
     2.463    69.375     0.150
     2.472    43.789     0.150
     2.472    43.789     0.150
     2.547    40.836     0.150
     2.547    73.336     0.150
     2.557    48.688     0.150
     2.557    48.688     0.150
     2.557    76.125     0.150
     2.650    41.719     0.150
     2.650    76.594     0.150
     2.774    43.586     0.150
     2.774    78.406     0.150
     2.783    84.969     0.150
     2.830    48.219     0.150
     2.830    83.562     0.150
     2.830    48.219     0.150
     2.830    83.562     0.150
     2.866    85.898     0.150
     2.866    45.047     0.150
     2.866    85.898     0.150
     2.873    50.078     0.150
     2.873    85.898     0.150
     2.873    50.078     0.150
     2.873    85.898     0.150
     2.881    44.930     0.150
     2.881    74.406     0.150
     2.903    45.477     0.150
     3.023    47.758     0.150
     3.023    87.008     0.150
     3.083    51.008     0.150
     3.083    86.828     0.150
     3.062    47.055     0.150
     3.062    81.359     0.150
     3.294    96.633     0.150
     3.295    96.633     0.150
     3.468    52.562     0.150
     3.619   104.555     0.150
     3.727    94.367     0.150
     3.869   111.180     0.150
     3.869    61.680     0.150
     3.869   111.180     0.150
     3.895    59.203     0.150
     3.895    97.859     0.150
     4.247   118.914     0.150
     4.266   122.797     0.150
     4.297   109.727     0.150
     4.596   125.133     0.150
     4.761    76.773     0.150
     4.761   131.258     0.150
     4.761    76.773     0.150
     4.761   131.258     0.150
     5.054   129.266     0.150
     5.331   145.492     0.150
     5.368   150.195     0.150
     5.368    80.555     0.150
     5.368   150.195     0.150
     5.416   136.727     0.150
     5.861   149.914     0.150
     5.861    89.680     0.150
     5.861   149.914     0.150
     5.980   163.523     0.150
     5.980    86.016     0.150
     5.980   163.523     0.150
     6.118    95.664     0.150
     6.118   167.766     0.150
     6.118    95.664     0.150
     6.118   167.766     0.150
     6.519    93.164     0.150
     6.519   176.508     0.150
     6.519    93.164     0.150
     6.519   176.508     0.150
     6.584    96.828     0.150
     6.584   165.328     0.150
     7.508   187.555     0.150
     7.508   186.297     0.150
     7.772   206.164     0.150
     9.406   235.680     0.150
     9.406   139.844     0.150
     9.406   235.680     0.150
    11.139   156.703     0.150
    12.387   172.547     0.150
    12.653   177.656     0.150
    12.653   177.188     0.150
    16.522   229.844     0.150
    18.707   600.477     0.150
    18.707   258.242     0.150
    21.415   285.312     0.150
    24.195     9.633     0.150
    29.017   357.453     0.150
    29.101   358.234     0.150
    51.073   540.953     0.150
    52.210   549.312     0.150
    54.069   562.547     0.150
    59.043   599.719     0.150
    59.352   601.570     0.150
    60.006   605.906     0.150
    60.082   606.766     0.150
    60.421   608.938     0.150
    60.961   612.078     0.150
    63.706   626.977     0.150
    79.896   729.445     0.150
    83.734   749.820     0.150
    84.986   771.836     0.150
    84.986   756.484     0.150
    85.495   758.781     0.150
    90.794   783.828     0.150
     0.141     5.439     0.150
     0.147     5.248     0.150
     0.147     7.809     0.150
     0.536    11.158     0.150
     0.630    13.520     0.150
     0.630    22.129     0.150
     0.758    14.639     0.150
     0.758    24.379     0.150
     1.162    21.449     0.150
     1.162    36.600     0.150
     1.197    22.459     0.150
     1.197    38.418     0.150
     1.603    27.520     0.150
     1.603    45.908     0.150
     1.557    28.180     0.150
     1.557    47.418     0.150
     1.595    28.088     0.150
     1.595    47.430     0.150
     1.636    28.578     0.150
     1.636    49.158     0.150
     1.637    28.908     0.150
     1.637    49.738     0.150
     1.806    30.908     0.150
     1.806    51.668     0.150
     1.945    33.199     0.150
     1.945    58.109     0.150
     1.992    34.309     0.150
     1.992    57.299     0.150
     2.150    35.719     0.150
     2.150    35.719     0.150
     2.150    63.328     0.150
     2.152    37.229     0.150
     2.152    63.498     0.150
     2.170    36.369     0.150
     2.170    63.889     0.150
     2.192    36.449     0.150
     2.192    63.430     0.150
     2.598    43.709     0.150
     2.648    43.158     0.150
     2.611    43.219     0.150
     2.612    42.939     0.150
     2.612    76.600     0.150
     2.741    44.459     0.150
     2.741    77.389     0.150
     2.738    44.100     0.150
     2.738    79.748     0.150
     2.837    45.629     0.150
     2.837    82.318     0.150
     2.854    45.758     0.150
     2.854    81.939     0.150
     2.916    46.430     0.150
     2.916    84.508     0.150
     2.948    46.680     0.150
     2.948    79.748     0.150
     2.968    47.168     0.150
     2.968    82.078     0.150
     3.306    53.100     0.150
     3.418    95.008     0.150
     3.584    57.359     0.150
     3.672    56.838     0.150
     3.715    57.008     0.150
     3.838   102.869     0.150
     3.838    58.129     0.150
     3.838   102.869     0.150
     3.923    60.838     0.150
     3.923   109.279     0.150
     3.977    60.020     0.150
     3.977   106.238     0.150
     4.705    72.318     0.150
     4.705   128.439     0.150
     4.786    70.318     0.150
     4.786   125.539     0.150
     4.870    77.109     0.150
     5.092   157.318     0.150
     5.321    80.078     0.150
     5.321   137.600     0.150
     5.721    86.879     0.150
     6.292    95.889     0.150
     6.292   173.779     0.150
     6.386    97.850     0.150
     6.398    95.949     0.150
     6.398   168.389     0.150
     7.450   108.898     0.150
     7.450   192.998     0.150
     7.486   111.078     0.150
     7.486   193.479     0.150
     8.109   218.109     0.150
     8.094   147.748     0.150
    10.797   808.512     0.150
    11.449   170.059     0.150
    13.611   198.328     0.150
    15.709   226.168     0.150
    19.060   264.062     0.150
    22.498   300.180     0.150
    22.806   303.270     0.150
    37.918   436.828     0.150
    53.750  4032.447     0.150
    53.759  4031.252     0.150
    53.768  4030.152     0.150
    54.401   568.189     0.150
    55.994   580.381     0.150
    56.712   585.887     0.150
    60.359   609.436     0.150
    85.771   757.520     0.150
   127.972  1144.943     0.150
     2.197    36.844     0.150
     2.273    28.883     0.150
     2.816    45.305     0.150
     2.884    38.152     0.150
     3.689   102.844     0.150
     3.926    52.082     0.150
     4.760   131.043     0.150
     0.270    14.453     0.150
     0.270     7.211     0.150
     0.270    14.453     0.150
     0.637    10.938     0.150
     0.637    21.062     0.150
     0.672    20.039     0.150
     0.672    10.570     0.150
     0.672    20.039     0.150
     1.104    29.539     0.150
     1.104    16.359     0.150
     1.104    29.539     0.150
     1.324    20.062     0.150
     1.252    43.711     0.150
     1.459    24.672     0.150
     1.459    24.383     0.150
     1.459    24.383     0.150
     1.619    26.867     0.150
     1.619    26.867     0.150
     1.619    49.070     0.150
     1.772    29.648     0.150
     1.772    57.680     0.150
     2.051    32.328     0.150
     2.051    32.328     0.150
     2.095    31.094     0.150
     2.095    31.094     0.150
     2.095    55.719     0.150
     2.493    38.961     0.150
     2.493    38.961     0.150
     2.500    38.711     0.150
     2.519    38.188     0.150
     3.121    46.320     0.150
     3.121    80.367     0.150
     3.949    62.078     0.150
     4.282    61.109     0.150
     4.282    61.109     0.150
     4.282   111.031     0.150
     4.969    72.820     0.150
     4.969   134.438     0.150
     5.401    84.367     0.150
     6.535   101.844     0.150
     6.535   174.359     0.150
     6.907    99.023     0.150
     6.907    99.023     0.150
     6.907   180.367     0.150
     6.945    99.547     0.150
     6.945    99.547     0.150
     6.945   179.484     0.150
     8.359   131.148     0.150
    11.344   841.156     0.150
    14.382   201.414     0.150
    16.266   229.680     0.150
    17.160   239.570     0.150
    17.394   243.820     0.150
    18.821   255.938     0.150
    19.229   261.422     0.150
    22.059   295.758     0.150
    23.219   306.914     0.150
    23.426   307.617     0.150
    23.434   308.102     0.150
    24.478   318.281     0.150
    25.318   327.188     0.150
    27.027   342.883     0.150
    27.839   348.203     0.150
    28.173   352.953     0.150
    29.647   365.734     0.150
    29.892   366.828     0.150
    31.337   380.133     0.150
    31.366   379.781     0.150
    33.329   397.781     0.150
    34.094   404.078     0.150
    50.756   543.117     0.150
    53.317  4012.289     0.150
    53.325  4016.766     0.150
    53.334  4011.164     0.150
    53.442   560.719     0.150
    55.874   578.164     0.150
    55.876   577.961     0.150
    56.216   578.914     0.150
    56.386   582.438     0.150
     0.816    28.080     0.150
     1.212    37.811     0.150
     2.126    53.730     0.150
     2.167    57.369     0.150
     2.178    57.939     0.150
     2.186    38.520     0.150
     2.406    62.250     0.150
     2.542    64.561     0.150
     2.774    70.020     0.150
     2.862    81.670     0.150
     4.233   104.539     0.150
     4.272   108.971     0.150
     4.386   108.471     0.150
     3.018    45.895     0.150
     3.896    55.547     0.150
     4.218    62.125     0.150
     0.169     5.930     0.150
     0.169     9.375     0.150
     0.311     6.766     0.150
     0.311    10.906     0.150
     0.311     6.766     0.150
     0.311    10.906     0.150
     0.435     9.844     0.150
     0.435    15.977     0.150
     0.539    10.273     0.150
     0.539    17.406     0.150
     0.539    10.273     0.150
     0.539    17.406     0.150
     0.885    17.195     0.150
     0.885    28.648     0.150
     1.180    21.797     0.150
     1.180    37.453     0.150
     1.362    23.406     0.150
     1.419    25.688     0.150
     1.485    26.125     0.150
     1.485    44.695     0.150
     1.564    25.906     0.150
     1.564    46.688     0.150
     1.655    29.039     0.150
     1.892    31.641     0.150
     1.892    56.086     0.150
     2.131    35.797     0.150
     2.131    66.125     0.150
     2.197    37.430     0.150
     2.197    65.617     0.150
     2.228    37.453     0.150
     2.228    66.594     0.150
     2.242    36.477     0.150
     2.242    65.648     0.150
     2.373    39.164     0.150
     2.373    70.555     0.150
     2.400    39.773     0.150
     2.400    70.180     0.150
     2.481    39.453     0.150
     2.481    71.680     0.150
     2.488    74.906     0.150
     2.488    43.344     0.150
     2.488    74.906     0.150
     2.531    43.117     0.150
     2.537    41.367     0.150
     2.537    74.258     0.150
     2.545    40.969     0.150
     2.545    77.234     0.150
     2.572    45.094     0.150
     2.572    45.094     0.150
     2.583    39.844     0.150
     2.583    39.844     0.150
     2.601    41.859     0.150
     2.601    75.344     0.150
     2.605    91.523     0.150
     2.636    43.148     0.150
     2.636    74.867     0.150
     2.681    45.070     0.150
     2.681    80.055     0.150
     2.687    42.641     0.150
     2.701    45.164     0.150
     2.739    43.094     0.150
     2.747    80.875     0.150
     2.770    43.195     0.150
     2.770    79.523     0.150
     2.778    45.438     0.150
     2.778    79.234     0.150
     2.820    44.289     0.150
     2.820    81.125     0.150
     2.851    45.727     0.150
     2.851    83.758     0.150
     2.852    86.688     0.150
     2.904    46.086     0.150
     2.903    46.078     0.150
     3.021    47.719     0.150
     3.021    85.727     0.150
     3.047    85.195     0.150
     3.123    49.070     0.150
     3.123    91.945     0.150
     3.136    93.695     0.150
     3.136    49.680     0.150
     3.136    93.695     0.150
     3.187    50.258     0.150
     3.229    51.375     0.150
     3.229    88.586     0.150
     3.273    52.930     0.150
     3.273    96.297     0.150
     3.468    54.273     0.150
     3.599   103.438     0.150
     3.927    61.094     0.150
     4.100   121.656     0.150
     4.100    63.719     0.150
     4.157    63.375     0.150
     4.505    67.367     0.150
     4.953    74.219     0.150
     4.953   136.641     0.150
     5.972    91.039     0.150
     6.276    92.297     0.150
     6.637    98.969     0.150
     6.637   172.641     0.150
     6.654    98.109     0.150
     7.609   107.578     0.150
     7.729   204.141     0.150
     8.062   118.305     0.150
     8.062   216.984     0.150
     8.709   222.773     0.150
     9.586   138.273     0.150
     9.586   253.703     0.150
    11.090   160.344     0.150
    12.604   175.891     0.150
    12.604   321.750     0.150
    15.312   221.570     0.150
    18.236   253.516     0.150
    18.236   252.773     0.150
    22.277   298.750     0.150
    22.311   299.508     0.150
    24.646   320.828     0.150
    33.522   398.453     0.150
    47.150  3533.195     0.150
    51.635   545.016     0.150
    53.885  4050.156     0.150
    53.894  4051.375     0.150
    53.903  4047.344     0.150
    55.672   574.000     0.150
    56.821  4274.594     0.150
    62.648  4702.594     0.150
     0.122     5.082     0.150
     0.122     5.082     0.150
     0.122     8.611     0.150
     0.287     5.832     0.150
     0.287     9.682     0.150
     0.287     5.832     0.150
     0.287     9.682     0.150
     0.367     9.012     0.150
     0.367    14.691     0.150
     0.510     9.422     0.150
     0.510     9.422     0.150
     0.510    16.451     0.150
     0.859    16.303     0.150
     0.859    27.973     0.150
     1.089    36.723     0.150
     1.089    20.963     0.150
     1.089    36.723     0.150
     1.353    23.043     0.150
     1.353    40.512     0.150
     1.360    43.932     0.150
     1.360    24.762     0.150
     1.360    43.932     0.150
     1.412    25.262     0.150
     1.412    44.121     0.150
     1.557    24.482     0.150
     1.557    24.482     0.150
     1.557    42.742     0.150
     1.532    51.172     0.150
     1.532    27.609     0.150
     1.564    28.322     0.150
     1.564    49.383     0.150
     1.651    29.201     0.150
     1.651    51.361     0.150
     1.875    30.691     0.150
     1.875    52.553     0.150
     2.057    34.662     0.150
     2.057    61.861     0.150
     2.107    34.951     0.150
     2.107    60.031     0.150
     2.151    35.482     0.150
     2.151    62.621     0.150
     2.176    36.312     0.150
     2.176    62.963     0.150
     2.304    38.262     0.150
     2.304    68.531     0.150
     2.394    40.092     0.150
     2.394    68.572     0.150
     2.362    39.082     0.150
     2.362    66.312     0.150
     2.398    39.883     0.150
     2.398    69.611     0.150
     2.440    39.252     0.150
     2.440    70.072     0.150
     2.447    41.303     0.150
     2.447    70.082     0.150
     2.455    39.861     0.150
     2.455    68.213     0.150
     2.465    40.223     0.150
     2.481    39.871     0.150
     2.481    69.852     0.150
     2.493    40.352     0.150
     2.493    73.572     0.150
     2.510    39.932     0.150
     2.510    72.643     0.150
     2.515    53.201     0.150
     2.515    82.713     0.150
     2.545    41.312     0.150
     2.545    73.191     0.150
     2.545    41.932     0.150
     2.572    40.133     0.150
     2.591    41.342     0.150
     2.591    74.682     0.150
     2.596    41.182     0.150
     2.596    76.562     0.150
     2.611    42.672     0.150
     2.611    75.242     0.150
     2.648    45.092     0.150
     2.648    78.682     0.150
     2.679    44.361     0.150
     2.679    76.771     0.150
     2.687    47.191     0.150
     2.687    77.652     0.150
     2.729    44.812     0.150
     2.729    80.861     0.150
     2.761    43.771     0.150
     2.761    78.521     0.150
     2.764    43.303     0.150
     2.764    78.441     0.150
     2.814    44.082     0.150
     2.814    78.012     0.150
     2.890    45.121     0.150
     2.890    45.121     0.150
     2.890    76.553     0.150
     2.946    47.053     0.150
     2.946    90.572     0.150
     3.046    86.531     0.150
     3.046    53.562     0.150
     3.046    86.531     0.150
     3.055    48.312     0.150
     3.055    89.682     0.150
     3.090    53.803     0.150
     3.090    91.422     0.150
     3.185    82.383     0.150
     3.185    51.463     0.150
     3.185    82.383     0.150
     3.151    89.082     0.150
     3.200    50.332     0.150
     3.200    89.951     0.150
     3.170    52.232     0.150
     3.170    84.941     0.150
     3.467    51.562     0.150
     3.467    89.252     0.150
     3.509    55.701     0.150
     3.808    60.172     0.150
     3.916    58.223     0.150
     3.916   105.133     0.150
     3.913    55.893     0.150
     3.913    55.893     0.150
     3.913   100.883     0.150
     3.987    59.293     0.150
     3.987   110.701     0.150
     4.033    66.742     0.150
     4.103    61.871     0.150
     4.103   109.553     0.150
     4.271    67.383     0.150
     4.271   113.723     0.150
     4.306   107.521     0.150
     4.306    66.322     0.150
     4.306   107.521     0.150
     4.422    65.793     0.150
     4.422   119.742     0.150
     4.812    80.803     0.150
     4.910    70.342     0.150
     4.910    70.342     0.150
     4.910   127.633     0.150
     4.940    70.842     0.150
     4.940   132.812     0.150
     5.437    77.643     0.150
     5.453    73.393     0.150
     5.453    73.393     0.150
     5.453   141.463     0.150
     5.625    83.402     0.150
     5.625   143.762     0.150
     5.940   147.361     0.150
     5.940    94.223     0.150
     5.940   147.361     0.150
     6.189    89.973     0.150
     6.189   163.812     0.150
     6.599    98.732     0.150
     6.599   175.133     0.150
     6.630    95.043     0.150
     6.630    95.043     0.150
     6.630   171.723     0.150
     7.575   106.762     0.150
     7.686   112.883     0.150
     7.686   192.781     0.150
     7.711   189.582     0.150
     7.711   189.582     0.150
     7.721   114.281     0.150
     7.721   203.412     0.150
     7.977   120.602     0.150
     7.977   205.521     0.150
     8.328   121.201     0.150
     8.328   116.053     0.150
     8.328   123.902     0.150
     8.673   123.021     0.150
     9.534   138.121     0.150
     9.534   246.002     0.150
    10.584   788.713     0.150
    11.012   155.473     0.150
    11.012   293.602     0.150
    11.012   155.473     0.150
    11.280   299.582     0.150
    11.280   154.793     0.150
    11.280   282.951     0.150
    11.611   293.723     0.150
    11.714   157.572     0.150
    12.560   172.762     0.150
    12.560   172.762     0.150
    12.560   319.223     0.150
    13.522   192.031     0.150
    13.522   186.143     0.150
    13.544   192.531     0.150
    15.255   216.562     0.150
    15.255   216.562     0.150
    17.801   246.281     0.150
    18.184   253.133     0.150
    18.497   254.531     0.150
    18.876   261.002     0.150
    18.876   261.572     0.150
    19.948   270.732     0.150
    21.837   291.633     0.150
    22.001   292.133     0.150
    22.189   296.932     0.150
    22.189   296.951     0.150
    22.270   296.383     0.150
    22.270   298.543     0.150
    22.443   299.871     0.150
    22.443   297.031     0.150
    23.335   308.271     0.150
    24.427   317.932     0.150
    24.427   319.793     0.150
    25.733   332.031     0.150
    26.930   343.232     0.150
    27.114   343.832     0.150
    27.351   348.432     0.150
    30.022   368.232     0.150
    30.022   368.402     0.150
    37.783   435.031     0.150
    42.029   470.832     0.150
    46.117   505.691     0.150
    46.685   508.031     0.150
    47.224  3525.332     0.150
    51.545   546.002     0.150
    53.948  4048.795     0.150
    53.957  4053.375     0.150
    53.965  4053.131     0.150
    56.896  4277.031     0.150
    57.215   586.771     0.150
    59.635  1339.232     0.150
    60.627   610.732     0.150
    62.729  4694.633     0.150
    63.532   635.732     0.150
    64.348   636.031     0.150
    65.618   644.332     0.150
    78.759   721.832     0.150
    85.724   762.232     0.150
    92.134   791.332     0.150
    93.828   800.633     0.150
    94.439   796.531     0.150
    94.439   796.432     0.150
    96.199   810.992     0.150
    96.199   810.992     0.150
    96.199   810.992     0.150
    96.199  1165.771     0.150
    96.199  2105.322     0.150
    96.199   810.932     0.150
    96.199  1043.133     0.150
    96.199  1165.732     0.150
    96.199  1447.133     0.150
    96.199  1570.232     0.150
    96.199  1881.531     0.150
    96.199  2105.232     0.150
    98.836   814.232     0.150
    99.387  1070.031     0.150
    99.387  2144.133     0.150
   110.772  1119.732     0.150
   122.332  1138.633     0.150
   128.526  1149.732     0.150
     0.080    12.580     0.150
     0.080     7.790     0.150
     0.080    12.580     0.150
     0.308     9.330     0.150
     0.308    15.020     0.150
     0.701    14.310     0.150
     0.843    26.040     0.150
     0.843    15.959     0.150
     0.843    26.040     0.150
     0.781    16.600     0.150
     0.781    25.569     0.150
     1.061    19.189     0.150
     1.061    32.449     0.150
     1.017    19.009     0.150
     1.017    32.080     0.150
     0.986    33.399     0.150
     0.986    19.469     0.150
     0.986    33.399     0.150
     1.407    23.830     0.150
     1.407    39.479     0.150
     1.465    25.529     0.150
     1.465    41.649     0.150
     1.778    29.879     0.150
     1.778    49.799     0.150
     1.920    32.060     0.150
     1.931    31.479     0.150
     1.931    55.939     0.150
     2.088    33.399     0.150
     2.088    60.589     0.150
     2.150    35.109     0.150
     2.150    61.169     0.150
     2.258    36.500     0.150
     2.258    64.120     0.150
     2.273    36.679     0.150
     2.273    64.359     0.150
     2.280    36.520     0.150
     2.280    64.549     0.150
     2.341    37.790     0.150
     2.341    64.009     0.150
     2.314    37.319     0.150
     2.314    64.649     0.150
     2.428    38.209     0.150
     2.428    65.549     0.150
     2.357    35.739     0.150
     2.369    37.870     0.150
     2.369    68.549     0.150
     2.385    38.109     0.150
     2.385    65.629     0.150
     2.401    38.819     0.150
     2.401    67.199     0.150
     2.431    36.819     0.150
     2.445    39.009     0.150
     2.445    67.889     0.150
     2.465    39.149     0.150
     2.465    68.949     0.150
     2.454    39.429     0.150
     2.454    67.870     0.150
     2.494    39.639     0.150
     2.494    68.370     0.150
     2.505    68.139     0.150
     2.505    68.139     0.150
     2.509    40.149     0.150
     2.509    71.580     0.150
     2.524    40.839     0.150
     2.524    71.339     0.150
     2.543    40.009     0.150
     2.543    70.560     0.150
     2.606    41.759     0.150
     2.606    70.330     0.150
     2.628    41.839     0.150
     2.628    71.500     0.150
     2.557    41.250     0.150
     2.557    73.889     0.150
     2.576    40.969     0.150
     2.576    71.049     0.150
     2.624    41.439     0.150
     2.624    73.109     0.150
     2.659    41.569     0.150
     2.659    73.819     0.150
     2.616    43.879     0.150
     2.616    73.370     0.150
     2.850    45.370     0.150
     2.850    76.339     0.150
     2.760    43.580     0.150
     2.760    78.689     0.150
     2.831    43.439     0.150
     2.831    76.520     0.150
     2.769    77.370     0.150
     2.879    46.290     0.150
     2.879    78.939     0.150
     2.977    46.709     0.150
     2.977    81.899     0.150
     2.900    45.850     0.150
     2.900    79.449     0.150
     3.196    48.830     0.150
     3.196    85.509     0.150
     3.372    51.889     0.150
     3.372    89.659     0.150
     3.448    53.100     0.150
     3.448    90.459     0.150
     3.610    54.649     0.150
     3.610    94.870     0.150
     3.630    56.370     0.150
     3.630    95.799     0.150
     3.556    54.620     0.150
     3.556    97.339     0.150
     3.717    58.459     0.150
     3.717   101.189     0.150
     3.991    58.679     0.150
     3.991   108.239     0.150
     4.081   109.109     0.150
     4.081    60.859     0.150
     4.081   109.109     0.150
     4.464    67.600     0.150
     4.464   112.609     0.150
     4.500    66.799     0.150
     4.500   116.689     0.150
     4.575    70.049     0.150
     4.575   119.060     0.150
     4.645    69.699     0.150
     4.645   126.060     0.150
     5.270    74.649     0.150
     5.270   132.580     0.150
     5.366   152.698     0.150
     5.366    79.409     0.150
     5.366   138.750     0.150
     5.354    84.339     0.150
     5.354   143.669     0.150
     5.839    82.830     0.150
     5.839   148.520     0.150
     5.810   158.879     0.150
     5.903   177.709     0.150
     5.903    85.949     0.150
     5.903   177.709     0.150
     6.065    88.779     0.150
     6.065   151.370     0.150
     7.070   103.549     0.150
     7.151   103.689     0.150
     8.219   119.609     0.150
     8.251   120.270     0.150
     8.984   133.089     0.150
    10.599   152.419     0.150
    15.272   216.229     0.150
    15.603   218.149     0.150
    15.758   220.919     0.150
    16.335   226.909     0.150
    17.634   243.919     0.150
    18.394   254.009     0.150
    21.140   283.080     0.150
    21.402   286.239     0.150
    23.994   313.330     0.150
    24.039   313.850     0.150
    24.332   314.919     0.150
    25.218   326.049     0.150
    27.065   340.540     0.150
    27.724   346.219     0.150
    31.179   375.659     0.150
    32.814   389.830     0.150
    32.851   392.959     0.150
    46.143   503.600     0.150
    53.427   557.419     0.150
    54.462  4070.221     0.150
    54.471  4073.792     0.150
    54.479  4069.196     0.150
    59.436   605.679     0.150
   114.967  1122.679     0.150
     0.302     7.234     0.150
     0.302    10.793     0.150
     0.519    10.793     0.150
     0.519    17.035     0.150
     0.553    12.453     0.150
     0.553    12.453     0.150
     0.553    19.574     0.150
     0.988    19.762     0.150
     0.988    31.793     0.150
     1.269    23.633     0.150
     1.269    39.445     0.150
     1.304    37.922     0.150
     1.304    23.574     0.150
     1.304    37.922     0.150
     1.521    27.082     0.150
     1.521    45.383     0.150
     1.503    26.922     0.150
     1.503    45.172     0.150
     1.536    50.062     0.150
     1.536    28.043     0.150
     1.536    50.062     0.150
     1.740    30.625     0.150
     1.740    53.363     0.150
     1.846    30.332     0.150
     1.846    30.332     0.150
     1.846    57.844     0.150
     1.984    25.672     0.150
     2.275    40.504     0.150
     2.275    69.324     0.150
     2.248    38.035     0.150
     2.335    38.152     0.150
     2.335    66.082     0.150
     2.342    39.883     0.150
     2.342    73.445     0.150
     2.491    41.582     0.150
     2.491    70.414     0.150
     2.550    42.203     0.150
     2.550    73.145     0.150
     2.507    42.273     0.150
     2.507    78.695     0.150
     2.573    70.043     0.150
     2.573    44.535     0.150
     2.573    70.043     0.150
     2.618    42.723     0.150
     2.618    68.832     0.150
     2.617    45.875     0.150
     2.617    77.242     0.150
     2.623    43.715     0.150
     2.623    76.273     0.150
     2.662    44.535     0.150
     2.662    80.555     0.150
     2.670    45.324     0.150
     2.670    78.883     0.150
     2.697    36.172     0.150
     2.697    80.883     0.150
     2.697    80.965     0.150
     2.720    47.703     0.150
     2.720    81.582     0.150
     2.776    49.395     0.150
     2.776    83.172     0.150
     2.784    83.414     0.150
     2.784    49.195     0.150
     2.784    83.414     0.150
     2.824    80.465     0.150
     2.830    84.242     0.150
     2.856    46.723     0.150
     2.856    83.762     0.150
     2.859    48.172     0.150
     2.859    80.285     0.150
     2.930    49.535     0.150
     2.930    49.535     0.150
     2.930    84.184     0.150
     2.959    88.895     0.150
     2.959    49.695     0.150
     2.959    88.895     0.150
     3.000    50.172     0.150
     3.000    88.172     0.150
     2.991    49.203     0.150
     2.991    49.203     0.150
     2.991    89.453     0.150
     3.139    49.152     0.150
     3.139    49.973     0.150
     3.139    93.035     0.150
     3.218    55.184     0.150
     3.218    92.934     0.150
     3.211    55.012     0.150
     3.211    96.875     0.150
     3.270    54.133     0.150
     3.270    90.523     0.150
     3.241    51.605     0.150
     3.241    97.293     0.150
     3.307    57.004     0.150
     3.307   100.855     0.150
     3.305    56.332     0.150
     3.305   100.855     0.150
     3.324    59.664     0.150
     3.324   101.523     0.150
     3.396    50.762     0.150
     3.396    95.023     0.150
     4.016    62.633     0.150
     4.016   103.195     0.150
     4.121    68.562     0.150
     4.121   111.492     0.150
     4.272    65.062     0.150
     4.272   111.414     0.150
     4.381    69.145     0.150
     4.381   114.812     0.150
     4.619    73.652     0.150
     4.619   125.012     0.150
     5.100    81.672     0.150
     5.100   137.484     0.150
     5.062    75.434     0.150
     5.062    75.434     0.150
     5.062   136.902     0.150
     5.381   134.613     0.150
     5.937    89.965     0.150
     5.937   156.633     0.150
     6.342    89.504     0.150
     6.342   163.805     0.150
     6.391   160.922     0.150
     6.391   160.922     0.150
     8.122   111.793     0.150
     8.122   202.914     0.150
     8.122   111.793     0.150
     8.122   202.914     0.150
     9.579   145.043     0.150
     9.579   240.992     0.150
    10.669   151.535     0.150
    18.010   248.984     0.150
    18.229   252.203     0.150
    20.295   274.113     0.150
    25.805     6.219     0.150
    29.329   362.934     0.150
    45.821   500.559     0.150
    47.032  3519.980     0.150
    53.876  4055.426     0.150
    53.885  4056.457     0.150
    53.893  4055.848     0.150
    55.731   577.605     0.150
    56.704  4261.785     0.150
    60.538   614.215     0.150
    65.789   645.684     0.150
    84.122   749.773     0.150
   129.043  1147.195     0.150
   140.273  1168.012     0.150
     0.897    25.645     0.150
     1.863    56.598     0.150
     2.184    60.176     0.150
     2.178    37.195     0.150
     2.266    33.105     0.150
     2.653    42.926     0.150
     2.732    50.375     0.150
     2.844    40.098     0.150
     3.305    53.438     0.150
     0.288     7.263     0.150
     0.288    12.282     0.150
     0.770    14.223     0.150
     0.770    24.242     0.150
     0.854    15.103     0.150
     0.854    24.242     0.150
     0.854    15.162     0.150
     0.854    25.213     0.150
     1.076    28.596     0.150
     1.076    19.883     0.150
     1.303    23.162     0.150
     1.303    41.282     0.150
     1.312    23.463     0.150
     1.312    35.232     0.150
     1.312    23.402     0.150
     1.312    35.232     0.150
     1.391    22.713     0.150
     1.391    38.232     0.150
     1.391    22.713     0.150
     1.391    38.232     0.150
     1.352    24.022     0.150
     1.352    24.022     0.150
     1.352    40.112     0.150
     1.538    26.353     0.150
     1.601    25.923     0.150
     1.601    43.503     0.150
     1.601    25.923     0.150
     1.601    43.503     0.150
     1.558    26.883     0.150
     1.558    46.022     0.150
     1.671    28.383     0.150
     1.671    47.812     0.150
     1.781    29.032     0.150
     1.781    29.103     0.150
     1.931    32.522     0.150
     1.931    56.162     0.150
     2.166    35.242     0.150
     2.166    61.112     0.150
     2.210    36.093     0.150
     2.210    62.213     0.150
     2.354    38.022     0.150
     2.380    39.622     0.150
     2.380    69.143     0.150
     2.421    39.152     0.150
     2.421    73.322     0.150
     2.442    39.332     0.150
     2.442    69.173     0.150
     2.472    41.683     0.150
     2.472    66.402     0.150
     2.468    39.912     0.150
     2.468    70.412     0.150
     2.508    71.593     0.150
     2.661    41.112     0.150
     2.661    41.112     0.150
     2.661    70.152     0.150
     2.596    41.643     0.150
     2.596    74.223     0.150
     2.654    43.362     0.150
     2.654    75.893     0.150
     2.657    44.062     0.150
     2.657    74.442     0.150
     2.671    45.003     0.150
     2.671    75.633     0.150
     2.710    76.442     0.150
     2.762    44.213     0.150
     2.762    76.952     0.150
     2.778    45.032     0.150
     2.778    78.503     0.150
     2.791    45.473     0.150
     2.792    78.933     0.150
     2.828    45.662     0.150
     2.828    77.062     0.150
     2.867    46.362     0.150
     2.867    79.652     0.150
     2.871    46.812     0.150
     2.871    79.582     0.150
     2.874    47.622     0.150
     2.874    79.782     0.150
     2.896    46.383     0.150
     2.896    79.883     0.150
     2.951    49.223     0.150
     2.951    81.893     0.150
     3.048    47.843     0.150
     3.048    84.103     0.150
     3.054    49.572     0.150
     3.054    82.492     0.150
     3.200    49.782     0.150
     3.200    87.753     0.150
     3.221    50.253     0.150
     3.221    87.713     0.150
     3.278    52.643     0.150
     3.278    89.242     0.150
     3.328    91.433     0.150
     3.461    93.872     0.150
     3.461    51.912     0.150
     3.461    93.872     0.150
     3.833    57.003     0.150
     3.833   100.513     0.150
     3.902    58.572     0.150
     3.902    58.572     0.150
     4.157    63.393     0.150
     4.157   108.582     0.150
     4.135    60.792     0.150
     4.135   108.372     0.150
     4.574    68.082     0.150
     4.574   118.242     0.150
     4.545    67.463     0.150
     4.632    68.503     0.150
     4.632   118.473     0.150
     4.778    72.622     0.150
     4.778   124.832     0.150
     5.382    80.872     0.150
     5.382   136.692     0.150
     5.494    82.872     0.150
     5.494   143.532     0.150
     5.559   137.933     0.150
     5.559    82.251     0.150
     5.559   137.933     0.150
     5.773    83.982     0.150
     5.773   152.253     0.150
     5.890    80.992     0.150
     6.170    91.173     0.150
     6.170   155.312     0.150
     6.318    93.133     0.150
     6.318   167.362     0.150
     6.532   163.662     0.150
     6.511    91.702     0.150
     6.511   160.692     0.150
     6.503    94.812     0.150
     6.503   169.893     0.150
     6.584   163.782     0.150
     6.584    97.173     0.150
     6.584   163.782     0.150
     6.606   163.883     0.150
     6.606    96.822     0.150
     6.606   163.883     0.150
     6.621    98.103     0.150
     6.621   165.832     0.150
     6.708   165.112     0.150
     6.813   102.162     0.150
     6.813   174.282     0.150
     6.955   175.383     0.150
     7.234   107.162     0.150
     7.234   107.106     0.150
    90.643   107.091     0.150
    90.643   190.703     0.150
    90.643   107.093     0.150
     7.753    99.303     0.150
     7.753   184.662     0.150
     7.753   191.582     0.150
     7.753   112.782     0.150
     7.753   191.582     0.150
     8.679   124.032     0.150
    26.460   134.035     0.150
    74.660   137.294     0.150
    74.660   136.883     0.150
     9.679   239.902     0.150
   113.349   142.641     0.150
     9.742   140.568     0.150
     9.742   136.582     0.150
    95.384   143.676     0.150
    10.406   143.202     0.150
    10.406   319.622     0.150
    10.406   143.202     0.150
    10.747   264.662     0.150
    10.747   152.439     0.150
    10.747   152.042     0.150
    11.501   165.497     0.150
    11.535   166.942     0.150
    11.535   296.753     0.150
    11.663   904.564     0.150
    12.097   166.492     0.150
    12.097   214.872     0.150
    12.097   370.753     0.150
    12.097   175.726     0.150
    13.467   192.423     0.150
    13.489   335.122     0.150
    13.489   335.122     0.150
    13.650   193.122     0.150
    93.846   206.797     0.150
    16.070   228.393     0.150
    16.070   404.272     0.150
    16.219   227.683     0.150
    16.642   235.053     0.150
    16.865   238.513     0.150
    16.865   426.393     0.150
    17.215   248.146     0.150
    18.279   254.112     0.150
    18.206   263.423     0.150
    19.039   264.332     0.150
    19.039   264.282     0.150
    19.254   260.643     0.150
    19.539   268.492     0.150
    20.126   260.162     0.150
    20.327   284.322     0.150
    20.315   280.093     0.150
    21.828   290.872     0.150
    21.867   289.853     0.150
    23.158   303.022     0.150
    23.212   309.223     0.150
    23.435   315.822     0.150
    23.904   314.372     0.150
    24.295   315.622     0.150
    24.902   330.822     0.150
    32.570   329.022     0.150
    91.276   327.423     0.150
    91.276   327.923     0.150
    25.870   335.423     0.150
    64.320   335.423     0.150
    26.087   341.522     0.150
    21.198   342.622     0.150
    26.488   339.247     0.150
    26.539   343.322     0.150
    26.633   344.223     0.150
    26.760   350.822     0.150
    26.795   348.723     0.150
    91.644   349.223     0.150
    26.877   350.122     0.150
    27.100   352.122     0.150
    27.141   355.822     0.150
    84.503   350.223     0.150
    27.492   354.122     0.150
    27.667   353.423     0.150
    27.839   349.803     0.150
    27.959   353.522     0.150
    30.843   378.723     0.150
    31.298   382.893     0.150
    34.881   410.683     0.150
    23.479   422.777     0.150
    36.700   434.558     0.150
    38.187   438.652     0.150
    38.187   438.593     0.150
    40.284   459.312     0.150
    42.312   472.822     0.150
    45.718   497.173     0.150
    49.523   531.973     0.150
    52.853   556.072     0.150
    53.229  3985.928     0.150
    53.238  3987.120     0.150
    53.692   564.292     0.150
    73.571   584.848     0.150
    56.701   583.202     0.150
    57.095   586.442     0.150
    57.186   586.923     0.150
    57.186   586.933     0.150
    59.278   600.643     0.150
    59.278   600.662     0.150
    59.712   606.032     0.150
    60.329  1339.923     0.150
    62.771   625.992     0.150
    65.660   643.122     0.150
    66.141   647.522     0.150
    66.141   652.367     0.150
    66.141   647.353     0.150
    67.062   652.973     0.150
    69.640   668.423     0.150
    71.785   680.572     0.150
    79.776   729.542     0.150
    80.500   739.567     0.150
    84.734   752.673     0.150
    85.758   758.866     0.150
    86.324   760.742     0.150
    86.424   764.242     0.150
    86.524   772.423     0.150
    86.965   775.723     0.150
    88.130   772.473     0.150
    88.554   774.218     0.150
    88.599   773.292     0.150
    89.124   776.572     0.150
    89.328   777.654     0.150
    89.776   778.992     0.150
    90.186   781.893     0.150
    90.263   781.022     0.150
    90.263     6.000     0.150
    90.263  1001.022     0.150
    90.263  1530.022     0.150
    90.263  1998.022     0.150
    90.263  2202.022     0.150
    90.362   781.817     0.150
    90.412   788.463     0.150
    90.436   781.822     0.150
    90.705   791.372     0.150
    90.933   782.022     0.150
    91.593   794.473     0.150
    91.745   785.223     0.150
    91.745   795.022     0.150
    91.745   785.223     0.150
    91.797   784.923     0.150
    91.797   787.633     0.150
    91.996   796.048     0.150
    91.986   796.051     0.150
    92.320   790.723     0.150
    92.409   799.022     0.150
    92.409   791.122     0.150
    92.570   790.522     0.150
    92.570   792.893     0.150
    92.595   797.042     0.150
    92.827   797.900     0.150
    93.241   801.122     0.150
    93.241   801.292     0.150
    93.251   801.022     0.150
    93.398   804.492     0.150
    93.539   798.723     0.150
    94.101   800.433     0.150
    94.101   800.423     0.150
    94.985   803.723     0.150
    96.006   816.272     0.150
    96.208   809.223     0.150
    96.387   817.322     0.150
    96.419   807.723     0.150
    99.293  1192.522     0.150
   100.640   838.154     0.150
   113.240   888.522     0.150
   119.886  1131.366     0.150
   121.954  1134.803     0.150
   123.390  1136.548     0.150
   123.390  1136.598     0.150
   123.390  1135.747     0.150
   123.390  1135.522     0.150
   130.669  1161.322     0.150
    57.305  1162.893     0.150
   136.853  1162.582     0.150
   141.038  1164.572     0.150
   143.800  1172.218     0.150
    18.892  1172.593     0.150
   144.633  1174.567     0.150
   145.578  1177.643     0.150
    26.821  1179.463     0.150
   111.760  1192.652     0.150
   111.760  1190.093     0.150
     1.262    34.662     0.150
     2.501    70.643     0.150
     2.837    46.453     0.150
     1.772    52.602     0.150
     2.063    60.453     0.150
     2.063    52.055     0.150
     2.106    54.930     0.150
     2.112    52.664     0.150
     2.131    53.523     0.150
     2.227    55.406     0.150
     2.281    57.227     0.150
     2.420    35.930     0.150
     2.448    71.250     0.150
     2.664    45.625     0.150
     2.716    51.172     0.150
     3.594    90.383     0.150
     4.431    61.789     0.150
     0.235     8.424     0.150
     0.235    13.803     0.150
     0.398    10.203     0.150
     0.398    16.744     0.150
     0.376    10.104     0.150
     0.376    16.514     0.150
     0.872    17.184     0.150
     0.872    28.984     0.150
     1.161    21.434     0.150
     1.161    36.293     0.150
     1.340    24.123     0.150
     1.340    38.994     0.150
     1.471    25.834     0.150
     1.471    37.703     0.150
     1.430    24.693     0.150
     1.430    35.703     0.150
     1.873    31.053     0.150
     1.873    53.645     0.150
     1.876    27.574     0.150
     1.876    47.434     0.150
     1.985    59.645     0.150
     1.985    32.244     0.150
     1.985    59.645     0.150
     1.941    31.443     0.150
     1.941    56.193     0.150
     1.974    57.293     0.150
     1.974    32.953     0.150
     1.974    57.293     0.150
     2.179    36.123     0.150
     2.179    62.203     0.150
     2.151    35.424     0.150
     2.151    57.793     0.150
     2.215    35.623     0.150
     2.215    62.104     0.150
     2.243    36.674     0.150
     2.243    63.484     0.150
     2.218    36.164     0.150
     2.218    64.064     0.150
     2.216    36.193     0.150
     2.216    61.533     0.150
     2.263    36.553     0.150
     2.263    61.383     0.150
     2.265    36.514     0.150
     2.265    61.395     0.150
     2.270    36.734     0.150
     2.270    62.264     0.150
     2.284    36.645     0.150
     2.284    64.334     0.150
     2.307    69.053     0.150
     2.307    36.803     0.150
     2.307    69.053     0.150
     2.314    59.053     0.150
     2.319    69.854     0.150
     2.319    37.594     0.150
     2.319    69.854     0.150
     2.319    37.553     0.150
     2.345    37.104     0.150
     2.345    64.424     0.150
     2.365    37.994     0.150
     2.365    63.713     0.150
     2.409    39.363     0.150
     2.409    65.453     0.150
     2.379    37.494     0.150
     2.379    63.553     0.150
     2.383    68.145     0.150
     2.383    37.645     0.150
     2.383    68.145     0.150
     2.384    69.873     0.150
     2.384    39.854     0.150
     2.384    69.873     0.150
     2.424    40.193     0.150
     2.424    68.943     0.150
     2.455    39.033     0.150
     2.455    65.883     0.150
     2.458    75.363     0.150
     2.458    39.354     0.150
     2.458    75.363     0.150
     2.528    40.434     0.150
     2.528    72.793     0.150
     2.596    74.684     0.150
     2.596    40.654     0.150
     2.596    74.684     0.150
     2.587    67.553     0.150
     2.587    40.803     0.150
     2.587    67.553     0.150
     2.606    41.074     0.150
     2.606    75.383     0.150
     2.740    44.213     0.150
     2.817    43.713     0.150
     2.817    76.594     0.150
     2.852    44.684     0.150
     2.852    73.395     0.150
     2.872    45.574     0.150
     2.872    79.604     0.150
     3.005    46.773     0.150
     2.994    46.834     0.150
     2.994    82.443     0.150
     2.971    46.725     0.150
     2.971    80.244     0.150
     3.168    89.645     0.150
     3.177    52.193     0.150
     3.177    82.975     0.150
     3.344    51.203     0.150
     3.344    88.863     0.150
     3.788    56.533     0.150
     3.788   100.174     0.150
     3.803    56.463     0.150
     3.803   100.504     0.150
     3.785    58.434     0.150
     4.019    59.443     0.150
     4.142   108.004     0.150
     4.144   114.014     0.150
     4.253    66.443     0.150
     4.253   114.303     0.150
     4.587    65.984     0.150
     4.587    65.984     0.150
     4.587   115.383     0.150
     4.930    73.783     0.150
     4.930   125.314     0.150
     5.291   143.645     0.150
     5.578   141.754     0.150
     6.635    99.344     0.150
     6.635   178.455     0.150
     6.706    99.064     0.150
     6.706   164.713     0.150
     7.626   198.674     0.150
     7.626   198.674     0.150
     7.773   114.254     0.150
     7.773   197.963     0.150
     7.806   115.783     0.150
     7.806   200.322     0.150
     8.422   123.744     0.150
     9.304   134.264     0.150
     9.304   230.232     0.150
    11.043   161.314     0.150
    11.564   281.533     0.150
    94.722   209.283     0.150
    47.291   214.592     0.150
    15.274   218.615     0.150
    24.218   312.814     0.150
    37.121   319.615     0.150
    46.432   503.463     0.150
    57.089   587.615     0.150
    72.959   589.725     0.150
    58.342   586.412     0.150
    59.924   602.537     0.150
    60.777   608.232     0.150
    62.279   619.322     0.150
    65.388   640.525     0.150
    90.391  2624.014     0.150
    99.170   823.115     0.150
   102.215   836.814     0.150
     1.346    38.328     0.150
     1.488    46.555     0.150
     1.784    55.945     0.150
     1.950    61.555     0.150
     2.064    31.969     0.150
     2.064    57.219     0.150
     2.067    51.148     0.150
     2.074    28.648     0.150
     2.074    65.188     0.150
     2.080    62.039     0.150
     2.104    65.188     0.150
     2.110    30.633     0.150
     2.114    65.188     0.150
     2.117    25.312     0.150
     2.149    65.188     0.150
     2.177    52.039     0.150
     2.187    60.539     0.150
     2.224    31.969     0.150
     2.224    71.164     0.150
     2.303    40.609     0.150
     2.303    73.156     0.150
     2.380    72.492     0.150
     2.474    45.914     0.150
     2.474    77.812     0.150
     2.717    37.945     0.150
     2.717    80.469     0.150
     2.968    47.945     0.150
     3.636   102.258     0.150
     4.152   117.547     0.150
     0.103     5.007     0.150
     0.103     8.447     0.150
     0.291     7.677     0.150
     0.429     8.757     0.150
     0.724    14.357     0.150
     0.724    24.197     0.150
     1.119    21.477     0.150
     1.119    34.817     0.150
     1.588    28.387     0.150
     1.596    28.627     0.150
     1.596    48.617     0.150
     1.737    28.667     0.150
     2.148    36.047     0.150
     2.393    39.977     0.150
     2.445    40.717     0.150
     2.445    72.827     0.150
     2.448    41.287     0.150
     2.461    77.247     0.150
     2.468    41.277     0.150
     2.483    41.437     0.150
     2.483    75.317     0.150
     2.494    41.107     0.150
     2.502    77.247     0.150
     2.503    41.227     0.150
     2.503    75.257     0.150
     2.500    41.297     0.150
     2.500    73.257     0.150
     2.516    41.027     0.150
     2.517    42.467     0.150
     2.517    72.597     0.150
     2.575    43.917     0.150
     2.574    42.217     0.150
     2.574    70.917     0.150
     2.574    67.317     0.150
     2.574    42.167     0.150
     2.620    43.817     0.150
     2.620    78.867     0.150
     2.643    45.917     0.150
     2.643    75.557     0.150
     2.643    44.107     0.150
     2.643    75.557     0.150
     2.676    44.057     0.150
     2.706    43.737     0.150
     2.720    45.487     0.150
     2.720    78.987     0.150
     2.740    44.497     0.150
     2.740    76.577     0.150
     2.750    43.327     0.150
     2.750    43.327     0.150
     2.750    80.707     0.150
     2.799    45.357     0.150
     2.799    76.367     0.150
     2.844    45.417     0.150
     2.917    47.717     0.150
     2.917    79.257     0.150
     3.031    48.597     0.150
     3.031    84.557     0.150
     3.077    48.927     0.150
     3.108    49.277     0.150
     3.094    85.767     0.150
     3.316    54.247     0.150
     3.316    90.967     0.150
     3.610    55.197     0.150
     3.773    57.347     0.150
     3.773    96.320     0.150
     3.995    61.597     0.150
     4.560    70.237     0.150
     4.789    69.687     0.150
     4.789    69.687     0.150
     4.789   125.907     0.150
     4.789   132.268     0.150
     4.838    70.607     0.150
     5.215    77.907     0.150
     5.580   152.887     0.150
     5.630    82.337     0.150
     5.630   155.227     0.150
     5.895    91.867     0.150
     5.895   153.597     0.150
     6.077    91.937     0.150
     6.077   159.727     0.150
     6.473    94.497     0.150
     6.473   171.487     0.150
     6.495    94.117     0.150
     6.495   166.467     0.150
     6.667   173.497     0.150
     7.446   184.347     0.150
     7.446   207.024     0.150
     7.549   110.167     0.150
     7.549   186.877     0.150
     7.585   112.097     0.150
     7.585   193.527     0.150
     7.672   197.547     0.150
     8.038   215.747     0.150
     8.193   126.609     0.150
     8.547   214.107     0.150
     8.746   226.347     0.150
     8.822   131.457     0.150
     8.822   233.087     0.150
     9.187   247.598     0.150
     9.239   132.381     0.150
     9.274   253.361     0.150
     9.277   252.770     0.150
     9.657   140.967     0.150
     9.657   255.687     0.150
     9.852   276.557     0.150
    10.045   272.081     0.150
    10.078   273.265     0.150
    27.369   149.493     0.150
    10.397   154.351     0.150
    10.419   292.524     0.150
    10.451   151.787     0.150
    10.451   265.637     0.150
    10.439   148.167     0.150
    10.439   265.677     0.150
    10.439   152.325     0.150
    10.698   804.372     0.150
    10.721   806.494     0.150
    10.723   162.297     0.150
    10.767   810.454     0.150
    10.770   156.317     0.150
    10.896   300.818     0.150
    11.513   285.436     0.150
    11.513   160.317     0.150
    12.155   169.697     0.150
    12.155   175.007     0.150
    12.155   303.127     0.150
    12.923   186.317     0.150
    13.460   192.217     0.150
    13.576   191.977     0.150
    15.486   390.307     0.150
    15.895   225.243     0.150
    16.122   225.827     0.150
    16.209   233.835     0.150
    16.818   237.097     0.150
    16.942   232.417     0.150
    84.996   242.237     0.150
    17.423   243.357     0.150
    18.084   251.117     0.150
    91.512   254.727     0.150
    91.512   455.386     0.150
    91.512   252.417     0.150
    18.306   255.117     0.150
    18.445   251.597     0.150
    18.525   255.017     0.150
    18.525   255.117     0.150
    18.977   262.687     0.150
    19.479   267.277     0.150
    19.889   270.417     0.150
    20.010   271.927     0.150
    20.045   272.607     0.150
    20.067   270.607     0.150
    20.383   276.042     0.150
    20.803   281.187     0.150
    20.803   510.557     0.150
    53.217   286.417     0.150
    21.354   287.617     0.150
    21.354   287.517     0.150
    96.236   288.977     0.150
    59.151   288.327     0.150
    21.646   296.547     0.150
    21.683   291.417     0.150
    21.733   291.787     0.150
    21.733   528.187     0.150
    21.903   292.417     0.150
    22.004   292.017     0.150
    22.004   291.977     0.150
    22.043   296.807     0.150
    22.163   294.017     0.150
    22.163   294.097     0.150
    22.401   300.436     0.150
    22.401   300.317     0.150
    22.468   297.417     0.150
    22.468   297.327     0.150
    23.425   308.817     0.150
    23.425   309.117     0.150
    23.609   308.917     0.150
    23.609   308.837     0.150
    23.701   312.117     0.150
   118.673   313.107     0.150
    24.430   317.217     0.150
    24.430   317.227     0.150
    24.542   319.557     0.150
    24.542   318.717     0.150
    29.047   322.617     0.150
    24.722   322.517     0.150
    58.610   324.587     0.150
    58.610   325.415     0.150
    58.610   586.266     0.150
    58.610   325.387     0.150
    58.610   324.917     0.150
    25.416   329.217     0.150
    83.274   328.767     0.150
    83.274   329.617     0.150
    35.616   331.047     0.150
    35.616   331.717     0.150
    25.847   332.917     0.150
    32.893   333.917     0.150
    91.391   334.627     0.150
    91.391   336.005     0.150
    91.391   604.082     0.150
    91.391   336.117     0.150
    26.079   334.817     0.150
    26.112   340.217     0.150
    26.595   338.117     0.150
    26.788   341.217     0.150
    26.868   342.717     0.150
    63.759   342.193     0.150
    63.759   342.837     0.150
    63.759   342.417     0.150
    26.907  2295.653     0.150
    27.140   546.139     0.150
    27.267   343.317     0.150
    21.416   345.356     0.150
    21.416   621.577     0.150
    21.416   345.955     0.150
    21.416   345.517     0.150
    27.432   345.617     0.150
    27.432   345.632     0.150
    27.432   345.717     0.150
    27.529   347.917     0.150
    27.726   349.817     0.150
    27.763   350.167     0.150
    91.952   350.307     0.150
    91.952   630.601     0.150
    91.952   351.237     0.150
    91.952   350.717     0.150
    27.831   353.017     0.150
    27.908   350.717     0.150
   100.980   354.717     0.150
    27.109   356.221     0.150
    27.109   357.487     0.150
    27.109   357.017     0.150
    83.712   355.367     0.150
    83.712   356.359     0.150
    83.712   642.622     0.150
    83.712   356.737     0.150
    83.712   356.317     0.150
    28.434   354.907     0.150
    28.938   359.017     0.150
    30.151   368.897     0.150
    30.141   370.257     0.150
    30.141   370.217     0.150
    30.141   375.647     0.150
    30.320   371.517     0.150
    93.456   379.637     0.150
    31.548   382.317     0.150
    31.721   384.237     0.150
    32.176   387.417     0.150
    32.176   387.318     0.150
    32.176   387.237     0.150
    33.701   401.047     0.150
    33.979   403.917     0.150
    34.386   406.847     0.150
    34.386   406.717     0.150
    35.202   413.617     0.150
    35.345   415.417     0.150
    22.673   424.877     0.150
    22.673   426.217     0.150
    36.585   427.017     0.150
    37.265   431.817     0.150
    37.819   435.987     0.150
    37.855   436.217     0.150
    37.855   436.278     0.150
    37.855   436.517     0.150
    41.184   464.517     0.150
    41.253   464.797     0.150
    41.253   465.217     0.150
    43.504   482.939     0.150
    43.504   481.027     0.150
    45.419   499.437     0.150
    45.419   499.717     0.150
    45.455   500.937     0.150
    46.772  2776.392     0.150
    46.772   509.217     0.150
    46.947   513.567     0.150
    96.941   516.517     0.150
    48.013   521.277     0.150
    48.434   940.807     0.150
    48.822   525.386     0.150
    49.120   527.267     0.150
    50.241   538.957     0.150
    50.241   537.517     0.150
    51.425   544.377     0.150
    51.425   544.517     0.150
    51.572   545.987     0.150
    27.010   549.897     0.150
    52.726   556.677     0.150
    53.588   562.617     0.150
    53.588   560.494     0.150
    53.839  4040.633     0.150
    53.847  4039.323     0.150
    54.196  4071.986     0.150
    54.200  4065.112     0.150
    54.213  4067.733     0.150
    54.485   571.137     0.150
    54.485   569.517     0.150
    54.857   574.127     0.150
    54.859   571.717     0.150
    55.834   577.817     0.150
    34.725   580.787     0.150
    56.660   584.617     0.150
    56.874   593.117     0.150
    56.985   586.537     0.150
    56.969   589.617     0.150
    57.051   585.317     0.150
    57.325   588.117     0.150
    57.379   588.917     0.150
    73.278   590.087     0.150
    57.727   592.517     0.150
    57.727   589.217     0.150
    57.841   593.537     0.150
    57.930   592.667     0.150
    58.312   597.027     0.150
    58.563   596.017     0.150
    58.845   600.667     0.150
    26.541   599.747     0.150
    59.057   601.817     0.150
    59.320   601.217     0.150
    59.745   610.417     0.150
    60.484   610.317     0.150
    61.607   617.797     0.150
    61.607   617.717     0.150
    62.809   627.217     0.150
    63.238   628.335     0.150
    63.238   628.277     0.150
    63.340   628.527     0.150
    63.418   630.317     0.150
    63.418   630.343     0.150
    65.071  1646.917     0.150
    65.071   635.817     0.150
    65.071    12.200     0.150
    65.071    19.300     0.150
    65.071   677.117     0.150
    65.071   798.617     0.150
    65.071   887.217     0.150
    65.071  1157.417     0.150
    65.071  1200.517     0.150
    65.071  1208.817     0.150
    65.071  1217.817     0.150
    65.071  1247.417     0.150
    65.071  1432.417     0.150
    65.071  1457.717     0.150
    65.646   644.017     0.150
    65.832   644.627     0.150
    65.832   644.457     0.150
    65.903   646.317     0.150
    65.903   645.057     0.150
    67.357   654.817     0.150
    67.658   657.117     0.150
    68.013   659.687     0.150
    68.819   665.417     0.150
    68.819   663.817     0.150
    68.819   663.827     0.150
    69.833   676.007     0.150
    70.035   672.317     0.150
    70.035   672.217     0.150
    74.405   697.617     0.150
    77.276   720.983     0.150
    78.767   722.277     0.150
    79.209   726.917     0.150
    80.070   729.617     0.150
    80.070   729.687     0.150
    80.070   729.727     0.150
    80.232   730.417     0.150
    80.232   731.017     0.150
    80.952   735.117     0.150
    80.952  1342.817     0.150
    81.153   736.107     0.150
    81.153   735.817     0.150
    81.377   736.807     0.150
    81.907   741.457     0.150
    82.826   746.827     0.150
    82.953   745.207     0.150
    82.982   745.957     0.150
    83.191   753.280     0.150
    83.437   748.827     0.150
    83.623   749.217     0.150
    83.623   748.717     0.150
    85.084   755.817     0.150
    85.205   756.317     0.150
    85.205   756.317     0.150
    85.739   758.417     0.150
    85.821   758.417     0.150
    85.821   758.387     0.150
    86.007   759.017     0.150
    86.007   759.061     0.150
    86.863   766.177     0.150
    86.863   764.117     0.150
    87.195   767.907     0.150
    87.316   766.817     0.150
    87.316   768.767     0.150
    87.316   968.707     0.150
    87.364  6605.788     0.150
    87.372  6617.517     0.150
    87.382  6594.184     0.150
    87.729   768.657     0.150
    87.907   769.935     0.150
    87.974   771.617     0.150
    87.903  6654.660     0.150
    87.904  6655.294     0.150
    87.919  6657.307     0.150
    88.080   776.610     0.150
    88.211   768.837     0.150
    88.498   771.917     0.150
   106.521   775.827     0.150
    88.944   775.317     0.150
    89.165   775.217     0.150
    89.215   768.717     0.150
    89.457   778.807     0.150
    89.502   778.407     0.150
    90.089   779.885     0.150
    90.294   780.717     0.150
    90.555   782.427     0.150
    90.560   783.017     0.150
    90.560  1001.317     0.150
    90.560  1112.317     0.150
    90.560  1197.317     0.150
    90.560  1534.317     0.150
    90.560  2025.317     0.150
    90.560  2295.317     0.150
    90.560  2535.317     0.150
    90.675   782.735     0.150
    90.751   783.917     0.150
    91.024   783.817     0.150
    91.289   794.877     0.150
    91.289  1832.317     0.150
    91.289   785.227     0.150
    91.804   788.717     0.150
    91.804  1008.517     0.150
    91.842   788.917     0.150
    91.918   788.217     0.150
    92.053   788.517     0.150
    92.053  1412.017     0.150
    92.126   789.217     0.150
    92.242  1129.617     0.150
    92.242  2040.517     0.150
    92.242   791.827     0.150
    92.490   791.317     0.150
    92.490  1389.117     0.150
    92.596  1013.417     0.150
    92.597   791.917     0.150
    92.614   792.017     0.150
    92.756   793.777     0.150
    92.865  1429.717     0.150
    92.873   793.117     0.150
    93.019  1138.217     0.150
    93.019  1847.717     0.150
    93.835   797.337     0.150
    93.835   797.407     0.150
    93.801   804.744     0.150
    93.968  1553.747     0.150
    93.996   807.196     0.150
    94.364   799.317     0.150
    94.256   809.996     0.150
    94.418   801.183     0.150
    94.431   802.103     0.150
    94.443   802.317     0.150
    94.624   808.895     0.150
    94.635   806.231     0.150
    94.723   809.127     0.150
    94.847  1154.417     0.150
    94.847  2090.117     0.150
    95.018   802.517     0.150
    95.018   802.557     0.150
    94.914   811.402     0.150
    95.231   805.040     0.150
    95.118   812.022     0.150
    95.236   804.551     0.150
    95.304   805.285     0.150
    95.275  1605.317     0.150
    95.275  2086.317     0.150
    95.539   806.117     0.150
    95.644   815.372     0.150
    96.050   808.467     0.150
    95.976   815.883     0.150
    96.143   808.017     0.150
    96.201   808.567     0.150
    96.201  1161.157     0.150
    96.201  1878.477     0.150
    96.201  2104.277     0.150
    96.201   808.517     0.150
    96.201  1040.217     0.150
    96.201  1161.117     0.150
    96.201  1444.717     0.150
    96.201  1878.417     0.150
    96.201  2104.217     0.150
    96.263   815.883     0.150
    96.294   821.088     0.150
    96.881   813.005     0.150
    97.119   812.607     0.150
    97.569   815.317     0.150
    97.569   817.377     0.150
    97.569   815.318     0.150
    97.922   818.817     0.150
    98.360   818.017     0.150
    98.408   819.517     0.150
    98.952  1463.717     0.150
    98.995   821.817     0.150
    99.206   822.917     0.150
    99.247   822.417     0.150
    99.273   824.617     0.150
    99.324   821.817     0.150
    99.328   820.192     0.150
    99.328   821.917     0.150
    99.328  1193.117     0.150
    99.328  2148.617     0.150
    99.398   822.629     0.150
    99.398   826.417     0.150
    99.398  1190.817     0.150
    99.398  2151.717     0.150
    99.676   824.517     0.150
    99.877   827.547     0.150
   100.473   828.717     0.150
   100.567   828.017     0.150
   100.674   830.957     0.150
   100.941   830.517     0.150
   100.965   832.817     0.150
   101.075   833.417     0.150
   101.273   835.617     0.150
   101.415   835.917     0.150
   101.675   836.217     0.150
   101.969   838.617     0.150
   102.259   838.317     0.150
   102.290   838.317     0.150
   102.345   836.217     0.150
   103.176   842.517     0.150
   103.717   845.317     0.150
   105.188   851.282     0.150
   106.753   859.086     0.150
   107.406  1268.517     0.150
   109.409  1278.817     0.150
   109.409  2306.217     0.150
   109.767  1112.917     0.150
   110.041   872.317     0.150
   110.501  1287.517     0.150
   110.501  2325.417     0.150
   110.773   877.967     0.150
   111.467   880.677     0.150
   111.467  1116.777     0.150
   112.309  2102.917     0.150
   112.830   885.767     0.150
   112.830  1765.717     0.150
   113.379  1114.117     0.150
   113.379  1311.717     0.150
   114.567  1122.715     0.150
   116.994   904.017     0.150
   116.994  1667.317     0.150
   118.449  1129.797     0.150
   118.449  1205.257     0.150
   118.844   911.717     0.150
   119.461  1130.267     0.150
   119.693  1132.077     0.150
   119.716  1129.517     0.150
   119.990  1132.507     0.150
   120.140  1131.207     0.150
   120.128  1132.927     0.150
   120.240  1132.927     0.150
   120.240  1217.367     0.150
   120.315  1132.927     0.150
   120.362  1133.357     0.150
   120.362  1218.217     0.150
   120.390  1133.357     0.150
   120.390  1218.507     0.150
   121.277  1133.317     0.150
   121.395  1133.617     0.150
   121.701  1134.217     0.150
   121.910  1134.517     0.150
   122.704  1136.567     0.150
   122.704  1136.292     0.150
   122.704  1136.517     0.150
   124.049   935.617     0.150
   125.126   939.317     0.150
   126.702  1150.897     0.150
   126.895  2303.567     0.150
   127.373  2292.417     0.150
   127.536  1145.317     0.150
   127.841  1148.112     0.150
   127.841  1146.017     0.150
   128.044  1145.467     0.150
   128.044  1145.217     0.150
   128.440  1147.017     0.150
   128.440  1148.827     0.150
   128.456  1152.797     0.150
   128.705  1147.717     0.150
   128.634  1148.767     0.150
   128.790  1153.917     0.150
   129.379  1149.077     0.150
   129.320  1148.317     0.150
   129.320  1149.617     0.150
   130.305  1142.167     0.150
   131.438  1161.457     0.150
   132.810   975.717     0.150
   132.810  1365.417     0.150
   133.379  1164.592     0.150
    60.894  1163.857     0.150
   140.344  1163.817     0.150
    18.291  1174.677     0.150
   142.936  1174.717     0.150
    27.781  1177.217     0.150
   148.653  1183.757     0.150
   152.991  1189.717     0.150
   153.147  1190.867     0.150
   153.244  1188.815     0.150
     0.293     7.681     0.150
     0.610    12.170     0.150
     0.610    12.170     0.150
     0.610    20.120     0.150
     1.093    20.391     0.150
     1.093    34.521     0.150
     1.570    27.690     0.150
     1.570    47.641     0.150
     1.589    27.851     0.150
     1.661    29.030     0.150
     1.661    50.360     0.150
     1.771    29.040     0.150
     1.771    53.160     0.150
     2.084    35.181     0.150
     2.084    63.460     0.150
     2.120    34.681     0.150
     2.120    64.290     0.150
     2.144    35.080     0.150
     2.144    65.051     0.150
     2.263    37.681     0.150
     2.378    38.160     0.150
     2.417    39.940     0.150
     2.417    70.110     0.150
     2.430    39.230     0.150
     2.430    74.320     0.150
     2.452    40.431     0.150
     2.456    40.330     0.150
     2.456    74.170     0.150
     2.467    41.101     0.150
     2.478    39.771     0.150
     2.491    39.091     0.150
     2.491    73.650     0.150
     2.493    40.431     0.150
     2.493    74.320     0.150
     2.497    39.771     0.150
     2.550    42.551     0.150
     2.550    76.980     0.150
     2.595    43.750     0.150
     2.595    77.641     0.150
     2.617    44.420     0.150
     2.617    46.351     0.150
     2.682    43.311     0.150
     2.682    78.061     0.150
     2.695    45.120     0.150
     2.695    82.290     0.150
     2.729    44.341     0.150
     2.729    84.290     0.150
     2.786    44.391     0.150
     2.772    45.080     0.150
     2.772    84.290     0.150
     2.819    46.160     0.150
     2.819    83.381     0.150
     2.880    45.830     0.150
     2.884    47.080     0.150
     2.978    46.940     0.150
     2.978    85.761     0.150
     3.054    82.960     0.150
     3.052    92.000     0.150
     3.052    51.670     0.150
     3.052    92.000     0.150
     3.053    85.141     0.150
     3.086    48.521     0.150
     3.274    57.040     0.150
     3.274    96.250     0.150
     3.572    53.181     0.150
     3.808    57.181     0.150
     4.407    68.311     0.150
     4.519    67.011     0.150
     4.519   118.170     0.150
     4.814   143.720     0.150
     4.814    70.210     0.150
     4.814   124.710     0.150
     4.814    73.650     0.150
     4.892   130.730     0.150
     5.176    78.311     0.150
     5.176   134.120     0.150
     5.540   154.011     0.150
     5.589    84.341     0.150
     5.853   161.360     0.150
     6.035    92.641     0.150
     6.035   164.410     0.150
     6.211    90.480     0.150
     6.500    92.370     0.150
     6.500    92.370     0.150
     6.527    87.601     0.150
     6.527   161.391     0.150
     7.582   111.551     0.150
     7.617   111.530     0.150
     8.564   119.980     0.150
     8.564   217.490     0.150
    10.449   265.431     0.150
    10.665   824.082     0.150
    10.688   816.556     0.150
    10.734   816.210     0.150
    11.528   171.341     0.150
    11.528   288.311     0.150
    48.056   203.910     0.150
    94.850   210.681     0.150
    10.808   222.200     0.150
    18.501   254.400     0.150
    20.002   275.030     0.150
    53.176   285.940     0.150
    42.555   311.910     0.150
    58.652   323.320     0.150
    83.669   354.351     0.150
    29.325   361.931     0.150
    29.325   360.471     0.150
    30.281   370.400     0.150
    13.741   389.511     0.150
    45.623   498.980     0.150
    53.880  4036.504     0.150
    53.888  4037.993     0.150
    57.284   587.670     0.150
    73.244   595.471     0.150
    81.216   733.290     0.150
    85.979     3.080     0.150
   122.696  1135.851     0.150
   128.081  1145.580     0.150
   140.302  1161.129     0.150
     0.577    12.812     0.150
     0.577    20.182     0.150
     1.027    19.822     0.150
     1.027    32.542     0.150
     1.504    27.401     0.150
     1.504    46.151     0.150
     1.548    27.361     0.150
     1.548    48.412     0.150
     1.635    28.012     0.150
     1.635    48.361     0.150
     1.786    29.122     0.150
     1.786    52.552     0.150
     2.070    34.901     0.150
     2.070    62.731     0.150
     2.054    35.092     0.150
     2.054    36.012     0.150
     2.081    34.521     0.150
     2.198    36.502     0.150
     2.198    66.012     0.150
     2.260    37.271     0.150
     2.260    69.432     0.150
     2.319    37.521     0.150
     2.350    40.952     0.150
     2.350    41.132     0.150
     2.350    71.812     0.150
     2.370    38.892     0.150
     2.393    39.052     0.150
     2.390    40.901     0.150
     2.400    40.512     0.150
     2.400    41.092     0.150
     2.400    72.622     0.150
     2.400    73.392     0.150
     2.434    38.242     0.150
     2.435    37.512     0.150
     2.485    41.771     0.150
     2.485    78.812     0.150
     2.530    42.492     0.150
     2.552    43.282     0.150
     2.552    43.382     0.150
     2.617    42.021     0.150
     2.617    42.422     0.150
     2.629    79.882     0.150
     2.629    45.552     0.150
     2.629    79.882     0.150
     2.675    42.062     0.150
     2.706    43.822     0.150
     2.706    44.552     0.150
     2.754    45.052     0.150
     2.754    45.332     0.150
     2.754    83.142     0.150
     2.754    83.562     0.150
     2.842    45.332     0.150
     2.842    84.111     0.150
     2.817    45.611     0.150
     2.817    46.062     0.150
     2.986    47.122     0.150
     2.986    91.162     0.150
     2.986    91.622     0.150
     2.993    87.202     0.150
     3.047    54.021     0.150
     3.047    88.572     0.150
     3.022    48.132     0.150
     3.022    93.082     0.150
     3.224    97.872     0.150
     3.548    54.151     0.150
     3.824    56.642     0.150
     3.824    93.802     0.150
     4.323    57.872     0.150
     4.484    70.632     0.150
     4.750    73.282     0.150
     4.807    70.752     0.150
     4.807   132.332     0.150
     5.147    78.602     0.150
     5.147   134.412     0.150
     5.346    76.632     0.150
     5.529    84.932     0.150
     5.815   160.992     0.150
     5.991    90.002     0.150
     6.144    84.182     0.150
     6.144   169.602     0.150
     6.497    96.832     0.150
     6.497   177.111     0.150
     6.535    96.202     0.150
     6.535   160.592     0.150
     7.476   189.151     0.150
     7.593   111.162     0.150
     7.628   112.492     0.150
     8.645   134.882     0.150
     8.645   231.361     0.150
     9.559   140.002     0.150
    10.358   148.972     0.150
    10.358   266.762     0.150
    10.654   810.128     0.150
    10.678   809.111     0.150
    10.723   811.432     0.150
    10.992   158.752     0.150
    10.992   287.062     0.150
    11.504   283.836     0.150
    11.489   162.342     0.150
    12.595   173.122     0.150
    48.106   202.882     0.150
    49.321   210.592     0.150
    15.092   211.242     0.150
    94.790   211.852     0.150
    10.823   219.271     0.150
    94.808   220.722     0.150
    94.799   221.271     0.150
    15.880   221.392     0.150
    18.208   251.412     0.150
    18.874   261.592     0.150
    59.250   286.002     0.150
    21.580   293.792     0.150
    21.926   291.592     0.150
    22.308   296.312     0.150
    22.308     9.270     0.150
    22.380   300.292     0.150
    23.322   308.292     0.150
    42.604   311.731     0.150
    24.352   318.252     0.150
    24.352   318.191     0.150
    24.381   317.191     0.150
    58.710   323.252     0.150
    25.746     8.610     0.150
   146.839   332.532     0.150
    26.810   339.072     0.150
    26.864   341.092     0.150
    29.264   360.962     0.150
    29.264   363.762     0.150
    30.042   370.792     0.150
    30.336   369.632     0.150
    31.154   376.812     0.150
    55.595   575.992     0.150
   127.132   581.042     0.150
    56.418   579.691     0.150
    61.348   586.941     0.150
    58.392   595.892     0.150
   101.435   837.191     0.150
   128.147  1145.552     0.150
     0.100     5.887     0.150
     0.100     8.977     0.150
     0.110     5.746     0.150
     0.110     8.918     0.150
     0.541    11.617     0.150
     0.541    19.176     0.150
     0.591    12.258     0.150
     0.591    20.168     0.150
     0.742    14.797     0.150
     0.742    24.777     0.150
     0.995    18.996     0.150
     0.995    31.855     0.150
     1.265    23.328     0.150
     1.265    37.215     0.150
     1.401    25.828     0.150
     1.401    43.426     0.150
     1.469    26.988     0.150
     1.469    43.527     0.150
     1.613    27.266     0.150
     1.613    48.637     0.150
     1.802    30.535     0.150
     1.802    49.656     0.150
     1.890    32.418     0.150
     1.890    59.215     0.150
     2.033    34.445     0.150
     2.033    58.977     0.150
     2.018    33.707     0.150
     2.018    58.277     0.150
     2.027    34.277     0.150
     2.027    57.098     0.150
     2.078    34.895     0.150
     2.078    58.785     0.150
     2.306    37.887     0.150
     2.306    66.258     0.150
     2.334    37.887     0.150
     2.334    64.215     0.150
     2.341    39.195     0.150
     2.355    39.656     0.150
     2.355    64.547     0.150
     2.356    38.207     0.150
     2.356    64.035     0.150
     2.362    39.395     0.150
     2.362    66.406     0.150
     2.370    39.895     0.150
     2.370    66.488     0.150
     2.379    35.605     0.150
     2.379    65.656     0.150
     2.441    74.285     0.150
     2.441    41.008     0.150
     2.441    74.285     0.150
     2.486    39.555     0.150
     2.486    71.715     0.150
     2.510    36.926     0.150
     2.510    70.617     0.150
     2.510    67.645     0.150
     2.510    41.855     0.150
     2.510    67.645     0.150
     2.511    39.188     0.150
     2.511    68.055     0.150
     2.567    41.445     0.150
     2.567    73.926     0.150
     2.569    42.145     0.150
     2.569    70.488     0.150
     2.632    45.035     0.150
     2.632    69.836     0.150
     2.590    43.297     0.150
     2.590    71.586     0.150
     2.672    44.207     0.150
     2.672    74.738     0.150
     2.689    43.117     0.150
     2.689    71.605     0.150
     2.710    43.836     0.150
     2.710    76.336     0.150
     2.782    44.367     0.150
     2.782    77.355     0.150
     2.819    46.566     0.150
     2.819    78.668     0.150
     2.865    46.586     0.150
     2.944    82.258     0.150
     2.963    84.945     0.150
     3.071    51.605     0.150
     3.071    80.516     0.150
     3.342    51.656     0.150
     3.342    91.668     0.150
     3.650    56.527     0.150
     3.679    56.285     0.150
     3.679    94.465     0.150
     3.717    57.516     0.150
     3.717    97.805     0.150
     3.818    58.625     0.150
     4.187   102.125     0.150
     4.625    69.355     0.150
     4.697    73.656     0.150
     4.697   123.617     0.150
     5.309    78.547     0.150
     5.309   136.125     0.150
     5.607   141.895     0.150
     5.961    90.836     0.150
     5.961   152.645     0.150
     6.355    94.465     0.150
     7.932   121.457     0.150
    94.675   209.605     0.150
    10.648   225.078     0.150
    20.109   273.238     0.150
     0.150     7.445     0.150
     1.350    25.255     0.150
     1.789    33.285     0.150
     2.211    40.235     0.150
     2.237    41.435     0.150
     2.366    66.655     0.150
     2.793    45.305     0.150
     0.859    16.207     0.150
     0.952    27.688     0.150
     1.465    41.156     0.150
     1.956    34.297     0.150
     1.956    34.336     0.150
     2.044    35.867     0.150
     2.084    35.637     0.150
     2.226    38.398     0.150
     2.283    39.238     0.150
     2.355    40.906     0.150
     2.374    40.457     0.150
     2.850    40.598     0.150
     2.916    50.285     0.150
     3.321    56.426     0.150
     0.818    25.582     0.150
     2.321    39.812     0.150
     4.572   115.062     0.150
    27.412   350.270     0.150
     0.303     7.328     0.150
     0.515    10.703     0.150
     0.515    17.797     0.150
     0.659    13.336     0.150
     0.739    24.375     0.150
     1.172    21.797     0.150
     1.172    37.383     0.150
     1.226    38.281     0.150
     1.437    25.805     0.150
     1.583    27.812     0.150
     1.592    49.812     0.150
     1.592    28.094     0.150
     1.592    49.812     0.150
     1.648    29.141     0.150
     1.663    27.867     0.150
     1.663    52.734     0.150
     1.784    30.023     0.150
     1.784    54.602     0.150
     1.972    33.328     0.150
     2.021    34.258     0.150
     2.178    36.211     0.150
     2.178    64.414     0.150
     2.198    36.562     0.150
     2.204    38.164     0.150
     2.204    65.953     0.150
     2.422    39.422     0.150
     2.475    40.578     0.150
     2.499    41.094     0.150
     2.510    40.727     0.150
     2.510    76.977     0.150
     2.514    41.016     0.150
     2.514    76.125     0.150
     2.527    40.367     0.150
     2.527    76.562     0.150
     2.535    41.984     0.150
     2.535    77.758     0.150
     2.544    40.773     0.150
     2.544    75.578     0.150
     2.553    38.555     0.150
     2.565    42.086     0.150
     2.624    67.242     0.150
     2.624    42.891     0.150
     2.624    75.547     0.150
     2.650    41.938     0.150
     2.650    69.961     0.150
     2.659    42.266     0.150
     2.659    82.906     0.150
     2.670    39.242     0.150
     2.670    39.242     0.150
     2.670    83.867     0.150
     2.694    44.016     0.150
     2.694    82.367     0.150
     2.693    40.828     0.150
     2.693    71.328     0.150
     2.693    40.828     0.150
     2.693    71.328     0.150
     2.724    47.625     0.150
     2.724    76.984     0.150
     2.737    77.688     0.150
     2.737    43.578     0.150
     2.737    77.688     0.150
     2.754    43.805     0.150
     2.754    83.617     0.150
     2.759    43.523     0.150
     2.759    75.438     0.150
     2.772    49.414     0.150
     2.772    86.352     0.150
     2.791    44.078     0.150
     2.791    73.211     0.150
     2.864    45.625     0.150
     2.894    43.633     0.150
     2.894    43.633     0.150
     2.894    79.727     0.150
     2.944    46.422     0.150
     2.944    85.188     0.150
     2.983    50.828     0.150
     2.983    92.086     0.150
     3.127    55.555     0.150
     3.127    92.984     0.150
     3.405    54.117     0.150
     3.405    90.992     0.150
     3.596    57.992     0.150
     3.698    56.102     0.150
     3.698    94.391     0.150
     3.692    57.484     0.150
     4.219    61.195     0.150
     4.219   113.703     0.150
     4.647    72.602     0.150
     4.647   123.102     0.150
     5.299    80.781     0.150
     5.299   145.352     0.150
     5.983    80.844     0.150
     5.983   148.328     0.150
    10.770   807.109     0.150
    11.478   282.727     0.150
    11.478   282.727     0.150
    11.658   164.914     0.150
    48.883   204.297     0.150
    47.924   206.203     0.150
    94.864   215.781     0.150
    94.855   218.695     0.150
    46.857   219.336     0.150
    94.872   222.172     0.150
    94.863   223.477     0.150
    18.393   258.086     0.150
    18.683     7.867     0.150
   105.645   267.281     0.150
    19.057     7.508     0.150
    21.499   290.742     0.150
    22.036   295.586     0.150
    22.736   300.781     0.150
    24.463   319.688     0.150
    25.425   326.312     0.150
    26.995   542.211     0.150
    27.221   345.281     0.150
    32.897   390.055     0.150
    33.555   396.297     0.150
    42.147   470.125     0.150
    45.330   497.672     0.150
    45.674   501.383     0.150
    47.214   513.516     0.150
    59.498   602.930     0.150
    60.399   607.258     0.150
    81.024   733.461     0.150
    80.284   736.656     0.150
    87.981   769.188     0.150
   116.714  1122.922     0.150
   128.679  1148.484     0.150
     0.264     8.141     0.150
     0.264    12.771     0.150
     0.595    12.791     0.150
     0.595    20.331     0.150
     0.785    15.741     0.150
     0.785    23.601     0.150
     1.163    21.711     0.150
     1.163    35.501     0.150
     1.153    21.331     0.150
     1.153    36.021     0.150
     1.378    34.221     0.150
     1.602    27.071     0.150
     1.603    28.391     0.150
     1.603    48.561     0.150
     1.627    28.561     0.150
     1.836    40.941     0.150
     1.913    31.931     0.150
     2.383    38.481     0.150
     2.455    77.871     0.150
     2.461    39.681     0.150
     2.484    80.601     0.150
     2.484    40.171     0.150
     2.484    80.601     0.150
     2.489    80.231     0.150
     2.489    40.551     0.150
     2.489    80.231     0.150
     2.496    84.291     0.150
     2.497    41.181     0.150
     2.515    41.111     0.150
     2.519    38.621     0.150
     2.519    38.621     0.150
     2.514    41.991     0.150
     2.514    81.411     0.150
     2.539    41.471     0.150
     2.539    83.171     0.150
     2.615    41.881     0.150
     2.625    48.271     0.150
     2.625    89.051     0.150
     2.630    41.891     0.150
     2.630    83.951     0.150
     2.646    45.531     0.150
     2.646    45.531     0.150
     2.646    86.261     0.150
     2.670    44.081     0.150
     2.728    43.951     0.150
     2.749    49.471     0.150
     2.806    90.371     0.150
     2.806    44.511     0.150
     2.806    90.371     0.150
     2.831    45.921     0.150
     2.831    90.221     0.150
     2.869    46.571     0.150
     2.882    45.351     0.150
     2.882    84.321     0.150
     2.904    74.851     0.150
     3.196    58.275     0.150
     3.196    53.611     0.150
     3.574   107.281     0.150
     3.638    56.331     0.150
     3.746    58.031     0.150
     3.746   114.301     0.150
     3.809    57.741     0.150
     4.669    69.871     0.150
     4.669    69.871     0.150
     4.669   120.371     0.150
     4.694    73.261     0.150
     4.856    78.781     0.150
     4.856   135.291     0.150
     5.089    90.691     0.150
     5.239    65.251     0.150
     5.351    81.271     0.150
     5.733   105.601     0.150
     5.733   177.311     0.150
     6.027   186.831     0.150
     6.205   132.591     0.150
     7.319   199.191     0.150
     7.416   190.861     0.150
     7.452   200.921     0.150
     8.088   148.571     0.150
     8.807   138.221     0.150
    30.179   133.611     0.150
     9.770   139.661     0.150
    10.831   810.028     0.150
    11.414   279.055     0.150
    13.598   199.561     0.150
    47.891   206.791     0.150
    16.234   221.261     0.150
    84.929   235.211     0.150
    18.417   257.961     0.150
    19.066   594.430     0.150
    59.042   287.961     0.150
    24.425   318.661     0.150
    24.431   317.491     0.150
    58.505   321.291     0.150
    91.390   331.941     0.150
    27.021   552.686     0.150
    27.228   344.861     0.150
    27.228   552.211     0.150
    27.228   543.181     0.150
    83.831   355.201     0.150
    83.831   352.191     0.150
    29.463   362.481     0.150
    13.572   390.741     0.150
    36.171   422.511     0.150
    45.291   498.786     0.150
    45.329   497.441     0.150
    53.741  4030.183     0.150
    53.749  4031.285     0.150
    34.825   580.891     0.150
    73.333   588.951     0.150
    73.333     8.200     0.150
    14.536   586.721     0.150
    57.423   588.181     0.150
    59.461   601.936     0.150
    59.563   602.961     0.150
    63.103   626.821     0.150
    63.103   626.861     0.150
    88.039  6663.585     0.150
    88.039  6659.105     0.150
    88.055  6662.790     0.150
    90.060   779.591     0.150
    90.533  1512.761     0.150
    90.533  1772.761     0.150
    90.533  2006.761     0.150
    90.641   782.531     0.150
    91.027   787.436     0.150
   128.744  1148.131     0.150
     0.298    12.023     0.150
     0.298    18.086     0.150
     0.779    24.203     0.150
     1.530    24.945     0.150
     1.846    54.922     0.150
     1.895    33.336     0.150
     1.895    58.203     0.150
     2.206    31.703     0.150
     2.914    48.477     0.150
     2.914    89.078     0.150
     3.050    80.086     0.150
     0.287    14.465     0.150
     0.981    17.285     0.150
     0.981    29.312     0.150
     1.408    35.855     0.150
     1.547    38.676     0.150
     1.879    45.965     0.150
     1.916    33.832     0.150
     1.978    52.074     0.150
     2.011    35.125     0.150
     2.129    38.414     0.150
     2.208    38.844     0.150
     2.233    58.805     0.150
     2.313    39.652     0.150
     2.403    42.234     0.150
     2.435    43.992     0.150
     3.508   100.754     0.150
     4.525   134.074     0.150
     5.437   139.164     0.150
    13.073   197.602     0.150
     0.900    15.918     0.150
     0.900    27.328     0.150
     1.084    31.195     0.150
     1.297    34.516     0.150
     1.812    47.895     0.150
     1.842    46.168     0.150
     2.019    48.008     0.150
     2.038    37.375     0.150
     2.077    32.055     0.150
     2.077    51.988     0.150
     2.060    35.578     0.150
     2.587    45.348     0.150
     3.035    75.395     0.150
     3.473    86.965     0.150
     4.309   119.766     0.150
     4.364   107.258     0.150
     0.379    14.854     0.150
     0.392    15.285     0.150
     0.955    29.584     0.150
     2.190    61.535     0.150
     2.910    49.494     0.150
     4.011    64.625     0.150
     5.647    79.035     0.150
     0.237     6.957     0.150
     0.237    10.988     0.150
     0.424     9.770     0.150
     0.424    15.480     0.150
     0.464    10.309     0.150
     0.464    16.527     0.150
     0.918    17.879     0.150
     0.918    29.480     0.150
     1.418    25.688     0.150
     1.418    44.160     0.150
     1.400    24.699     0.150
     1.400    42.027     0.150
     1.584    27.969     0.150
     1.584    47.398     0.150
     1.504    26.199     0.150
     1.504    43.957     0.150
     1.702    51.117     0.150
     1.702    29.719     0.150
     1.702    51.117     0.150
     1.933    32.250     0.150
     1.933    53.777     0.150
     2.109    35.328     0.150
     2.109    62.430     0.150
     2.177    35.070     0.150
     2.177    64.539     0.150
     2.235    37.418     0.150
     2.235    65.969     0.150
     2.359    38.867     0.150
     2.359    67.730     0.150
     2.422    40.238     0.150
     2.422    66.668     0.150
     2.434    38.109     0.150
     2.434    71.188     0.150
     2.461    38.840     0.150
     2.461    68.430     0.150
     2.484    39.520     0.150
     2.484    72.047     0.150
     2.470    40.148     0.150
     2.470    71.547     0.150
     2.506    38.250     0.150
     2.506    38.250     0.150
     2.506    72.047     0.150
     2.505    40.148     0.150
     2.505    70.090     0.150
     2.538    40.418     0.150
     2.538    70.719     0.150
     2.556    39.520     0.150
     2.556    71.469     0.150
     2.564    42.289     0.150
     2.564    72.848     0.150
     2.563    43.020     0.150
     2.563    74.070     0.150
     2.608    42.250     0.150
     2.608    73.688     0.150
     2.610    41.609     0.150
     2.610    74.199     0.150
     2.619    43.258     0.150
     2.619    71.680     0.150
     2.629    43.430     0.150
     2.629    73.617     0.150
     2.630    76.180     0.150
     2.630    43.617     0.150
     2.630    76.180     0.150
     2.636    42.949     0.150
     2.636    70.859     0.150
     2.668    73.109     0.150
     2.675    70.930     0.150
     2.699    43.289     0.150
     2.699    76.027     0.150
     2.705    43.199     0.150
     2.705    77.910     0.150
     2.752    44.949     0.150
     2.752    77.629     0.150
     2.777    44.578     0.150
     2.777    77.008     0.150
     2.857    45.648     0.150
     2.857    79.039     0.150
     2.948    50.320     0.150
     2.997    47.410     0.150
     2.997    84.969     0.150
     3.063    47.730     0.150
     3.063    83.797     0.150
     3.110    48.797     0.150
     3.110    86.820     0.150
     3.113    49.598     0.150
     3.113    87.910     0.150
     3.211    49.109     0.150
     3.211    87.449     0.150
     3.149    51.457     0.150
     3.149    86.719     0.150
     3.413    54.258     0.150
     3.413    89.910     0.150
     3.526    57.988     0.150
     3.525    57.988     0.150
     3.963   108.137     0.150
     3.963    59.258     0.150
     3.963   108.137     0.150
     3.970    58.738     0.150
     4.014    65.047     0.150
     4.014   109.590     0.150
     4.161    63.629     0.150
     4.161   111.320     0.150
     4.257   118.938     0.150
     4.368    66.707     0.150
     4.368   115.180     0.150
     4.832    75.180     0.150
     4.832   129.750     0.150
     4.970    74.688     0.150
     4.970   131.629     0.150
     4.962    80.387     0.150
     4.962   134.898     0.150
     5.685    84.180     0.150
     5.685   147.207     0.150
     5.898    94.570     0.150
     5.898   155.840     0.150
     6.196    91.527     0.150
     6.196   166.508     0.150
     6.689    97.500     0.150
     6.689   171.570     0.150
     7.635   194.547     0.150
     7.745   113.719     0.150
     7.745   197.438     0.150
     7.780   114.379     0.150
     7.780   200.098     0.150
     9.503   247.289     0.150
    11.004   329.559     0.150
    11.668   287.777     0.150
    94.933   210.230     0.150
    49.395   212.770     0.150
    94.924   214.000     0.150
    47.119   218.270     0.150
    94.933   221.547     0.150
    91.954   243.680     0.150
   151.150   253.609     0.150
   105.722   259.078     0.150
    85.730   259.297     0.150
    96.302   287.000     0.150
    59.301   286.270     0.150
    21.511   289.047     0.150
    27.025   340.207     0.150
    27.025   341.008     0.150
    27.252   347.797     0.150
    45.599   500.438     0.150
    45.662   497.633     0.150
    46.675   506.848     0.150
    46.675   600.488     0.150
    53.971  4058.816     0.150
    53.979  4053.398     0.150
    57.193   639.113     0.150
    57.193   639.109     0.150
    83.787   749.348     0.150
    91.034   782.328     0.150
   106.711   849.270     0.150
   108.191   851.680     0.150
   109.846   863.199     0.150
   128.467  1146.887     0.150
   129.163  1147.598     0.150
   140.195  1167.688     0.150
     1.739    29.797     0.150
     1.739    53.668     0.150
     1.985    61.066     0.150
     2.049    49.246     0.150
     2.099    30.996     0.150
     3.073    51.789     0.150
     4.334    73.379     0.150
    11.207   155.957     0.150
    11.207   272.855     0.150
     0.275     7.902     0.150
     0.275    13.242     0.150
     0.341     8.562     0.150
     0.341    14.105     0.150
     0.499    10.582     0.150
     0.499    18.203     0.150
     0.850    16.023     0.150
     0.850    26.855     0.150
     0.845    15.895     0.150
     0.845    26.922     0.150
     1.224    21.465     0.150
     1.224    37.082     0.150
     1.233    22.422     0.150
     1.233    37.664     0.150
     1.325    23.312     0.150
     1.325    39.914     0.150
     1.871    32.285     0.150
     1.871    52.715     0.150
     1.875    31.633     0.150
     1.875    53.914     0.150
     1.863    30.234     0.150
     1.863    52.375     0.150
     1.912    31.273     0.150
     1.912    55.195     0.150
     2.060    34.203     0.150
     2.060    58.055     0.150
     2.167    35.293     0.150
     2.167    60.484     0.150
     2.163    37.105     0.150
     2.163    59.773     0.150
     2.201    37.445     0.150
     2.201    60.902     0.150
     2.217    35.953     0.150
     2.217    62.434     0.150
     2.218    38.285     0.150
     2.218    61.613     0.150
     2.229    63.082     0.150
     2.238    36.422     0.150
     2.238    62.523     0.150
     2.242    36.285     0.150
     2.242    62.742     0.150
     2.272    39.504     0.150
     2.272    63.582     0.150
     2.290    37.473     0.150
     2.290    63.355     0.150
     2.286    36.672     0.150
     2.286    36.672     0.150
     2.286    63.914     0.150
     2.307    41.094     0.150
     2.307    63.695     0.150
     2.309    40.414     0.150
     2.309    63.793     0.150
     2.334    41.414     0.150
     2.334    65.723     0.150
     2.352    41.172     0.150
     2.352    64.645     0.150
     2.356    39.824     0.150
     2.356    65.363     0.150
     2.373    41.434     0.150
     2.373    66.453     0.150
     2.378    39.043     0.150
     2.378    65.312     0.150
     2.378    65.312     0.150
     2.409    46.883     0.150
     2.409    46.883     0.150
     2.409    67.293     0.150
     2.440    41.863     0.150
     2.440    66.434     0.150
     2.449    42.273     0.150
     2.449    66.883     0.150
     2.489    44.715     0.150
     2.489    68.562     0.150
     2.524    41.414     0.150
     2.524    69.234     0.150
     2.575    43.812     0.150
     2.575    70.805     0.150
     2.758    43.242     0.150
     2.758    75.715     0.150
     2.807    57.543     0.150
     2.807    75.945     0.150
     2.850    47.203     0.150
     2.850    77.062     0.150
     2.844    76.395     0.150
     2.844    45.664     0.150
     2.844    48.973     0.150
     2.844    76.395     0.150
     2.890    45.324     0.150
     2.890    78.504     0.150
     2.883    45.484     0.150
     2.883    77.812     0.150
     3.071    47.922     0.150
     3.071    82.844     0.150
     3.467    52.402     0.150
     3.851    58.492     0.150
     3.851   102.605     0.150
     3.896    58.945     0.150
     3.896   102.742     0.150
     4.371    67.984     0.150
     4.371   114.285     0.150
     4.740    70.473     0.150
     4.740   126.055     0.150
     4.815   133.961     0.150
     5.851    85.863     0.150
     5.851   153.812     0.150
     5.957    87.754     0.150
     5.957   154.703     0.150
     6.514    96.594     0.150
     6.514   168.133     0.150
     6.582    96.324     0.150
     6.582   164.723     0.150
     7.650   111.805     0.150
     7.650   195.344     0.150
     7.682   113.562     0.150
     7.682   197.793     0.150
     8.454   122.754     0.150
    10.605   795.062     0.150
    10.672   796.684     0.150
    11.458   165.938     0.150
    11.458   280.461     0.150
    48.260   202.812     0.150
    94.669   206.922     0.150
    47.191   215.383     0.150
   105.459   257.684     0.150
    85.475   257.152     0.150
    18.689   258.844     0.150
    88.638   268.773     0.150
    20.754   280.332     0.150
    21.628   289.613     0.150
    22.043   293.855     0.150
    22.396   298.082     0.150
    22.890   302.945     0.150
    23.933   313.293     0.150
    61.174   314.844     0.150
    26.645   336.594     0.150
    13.822   387.355     0.150
    54.213   564.293     0.150
    61.474   585.035     0.150
    57.043   582.793     0.150
   128.660  1145.395     0.150
     0.252     7.430     0.150
     0.252    11.039     0.150
     0.415     9.586     0.150
     0.415    15.102     0.150
     0.479    15.469     0.150
     0.479    10.539     0.150
     0.479    15.469     0.150
     0.905    17.719     0.150
     0.905    28.938     0.150
     1.114    20.141     0.150
     1.114    33.055     0.150
     1.408    25.352     0.150
     1.408    42.867     0.150
     1.410    24.820     0.150
     1.410    39.688     0.150
     1.519    26.484     0.150
     1.519    47.078     0.150
     1.578    27.820     0.150
     1.587    27.891     0.150
     1.587    49.836     0.150
     1.920    33.078     0.150
     1.920    57.727     0.150
     2.102    35.320     0.150
     2.102    66.195     0.150
     2.126    36.430     0.150
     2.126    61.734     0.150
     2.179    35.648     0.150
     2.179    63.391     0.150
     2.224    41.398     0.150
     2.224    67.117     0.150
     2.351    38.609     0.150
     2.351    65.250     0.150
     2.410    40.625     0.150
     2.410    66.891     0.150
     2.408    39.867     0.150
     2.408    68.961     0.150
     2.464    40.039     0.150
     2.464    69.930     0.150
     2.506    40.625     0.150
     2.506    69.984     0.150
     2.507    40.836     0.150
     2.507    73.000     0.150
     2.516    43.922     0.150
     2.516    71.289     0.150
     2.539    41.258     0.150
     2.539    72.430     0.150
     2.555    41.016     0.150
     2.555    72.602     0.150
     2.568    43.875     0.150
     2.568    74.086     0.150
     2.567    43.938     0.150
     2.567    71.977     0.150
     2.595    43.641     0.150
     2.595    74.461     0.150
     2.612    43.711     0.150
     2.612    72.648     0.150
     2.613    42.906     0.150
     2.613    73.109     0.150
     2.621    41.391     0.150
     2.621    73.219     0.150
     2.633    41.070     0.150
     2.633    72.508     0.150
     2.634    44.797     0.150
     2.634    79.625     0.150
     2.679    43.938     0.150
     2.679    74.516     0.150
     2.703    44.711     0.150
     2.703    75.266     0.150
     2.709    43.266     0.150
     2.709    78.211     0.150
     2.836    44.398     0.150
     2.836    80.609     0.150
     2.864    46.648     0.150
     2.864    78.891     0.150
     2.934    82.805     0.150
     2.934    47.070     0.150
     2.934    82.805     0.150
     2.991    47.234     0.150
     2.991    86.250     0.150
     2.973    81.945     0.150
     3.067    48.938     0.150
     3.067    88.469     0.150
     3.102    49.047     0.150
     3.102    82.641     0.150
     3.079    50.648     0.150
     3.079    85.398     0.150
     3.115    54.938     0.150
     3.115    87.539     0.150
     3.162    51.297     0.150
     3.427    53.367     0.150
     3.427    91.031     0.150
     3.529    55.641     0.150
     3.957    59.508     0.150
     3.957   101.781     0.150
     3.958   102.852     0.150
     3.958    59.555     0.150
     3.958   102.852     0.150
     4.026    62.789     0.150
     4.026   106.656     0.150
     4.383    69.430     0.150
     4.383   117.320     0.150
     4.835    74.930     0.150
     4.835   128.938     0.150
     4.959   121.594     0.150
     4.959    74.430     0.150
     4.970    77.281     0.150
     4.970   134.281     0.150
     5.034    76.984     0.150
     5.034   133.961     0.150
     5.505    87.531     0.150
     5.505   148.516     0.150
     5.721    89.516     0.150
     5.721   152.148     0.150
     5.912    90.430     0.150
     5.912   158.000     0.150
     6.203    92.375     0.150
     6.203   163.961     0.150
     6.306    90.102     0.150
     6.306   100.219     0.150
     6.306   166.586     0.150
     6.647    98.656     0.150
     6.647   173.156     0.150
     6.676    99.609     0.150
     6.676   168.961     0.150
     7.623   107.031     0.150
     7.623   195.672     0.150
     7.731   113.891     0.150
     7.731   197.461     0.150
     7.767   114.734     0.150
     7.767   201.945     0.150
     8.680   120.852     0.150
     8.680   120.852     0.150
     8.680   226.672     0.150
    10.208   152.258     0.150
    10.351   144.578     0.150
    11.659   279.898     0.150
    11.981   182.195     0.150
    11.981   313.570     0.150
    13.816   201.688     0.150
    48.170   205.531     0.150
    94.931   214.266     0.150
    49.381   212.258     0.150
    47.105   219.547     0.150
    10.956   222.906     0.150
    94.930   223.938     0.150
    17.858   247.891     0.150
   111.809   256.898     0.150
   105.719   260.805     0.150
    19.322   264.875     0.150
    20.194   274.039     0.150
    96.301   286.109     0.150
    59.288   286.977     0.150
    27.036   542.727     0.150
    27.187   341.938     0.150
    45.584   503.328     0.150
    45.664   496.281     0.150
    63.545   626.867     0.150
    83.967   748.461     0.150
    91.037   782.250     0.150
    92.184   787.852     0.150
   128.477  1151.078     0.150
   140.208  1170.430     0.150
     0.331     8.039     0.150
     0.331    12.344     0.150
     0.788    15.539     0.150
     0.788    25.344     0.150
     1.003    18.852     0.150
     1.003    30.828     0.150
     1.210    22.023     0.150
     1.210    36.969     0.150
     1.244    22.719     0.150
     1.670    47.680     0.150
     1.670    29.023     0.150
     1.670    47.680     0.150
     1.747    29.852     0.150
     1.762    30.883     0.150
     1.762    52.547     0.150
     1.781    30.562     0.150
     1.898    32.633     0.150
     1.898    56.328     0.150
     1.982    33.391     0.150
     1.982    55.359     0.150
     2.059    33.750     0.150
     2.059    58.328     0.150
     2.181    35.609     0.150
     2.181    61.719     0.150
     2.232    38.039     0.150
     2.232    64.523     0.150
     2.388    39.602     0.150
     2.388    67.547     0.150
     2.435    39.359     0.150
     2.435    65.727     0.150
     2.478    73.039     0.150
     2.478    41.078     0.150
     2.478    73.039     0.150
     2.506    42.047     0.150
     2.506    71.352     0.150
     2.508    41.398     0.150
     2.508    70.820     0.150
     2.555    42.453     0.150
     2.555    72.797     0.150
     2.568    42.203     0.150
     2.568    73.109     0.150
     2.623    43.938     0.150
     2.623    74.742     0.150
     2.636    43.281     0.150
     2.636    72.797     0.150
     2.644    43.812     0.150
     2.644    74.578     0.150
     2.647    43.477     0.150
     2.647    73.508     0.150
     2.651    44.320     0.150
     2.651    73.289     0.150
     2.653    44.164     0.150
     2.653    74.898     0.150
     2.669    43.594     0.150
     2.669    74.828     0.150
     2.670    42.188     0.150
     2.670    75.562     0.150
     2.695    44.328     0.150
     2.695    76.359     0.150
     2.697    43.898     0.150
     2.697    72.547     0.150
     2.702    44.133     0.150
     2.702    77.398     0.150
     2.719    43.461     0.150
     2.719    76.367     0.150
     2.736    76.539     0.150
     2.745    43.219     0.150
     2.745    76.797     0.150
     2.776    44.922     0.150
     2.776    76.859     0.150
     2.865    47.898     0.150
     2.865    81.031     0.150
     2.891    45.133     0.150
     2.891    80.758     0.150
     3.048    49.297     0.150
     3.048    84.328     0.150
     3.123    49.969     0.150
     3.123    87.000     0.150
     3.267    52.812     0.150
     3.267    90.492     0.150
     3.411    54.188     0.150
     3.411    90.891     0.150
     3.598    59.164     0.150
     3.626    56.430     0.150
     3.626    98.289     0.150
     3.695    56.172     0.150
     3.695    99.797     0.150
     3.692    56.797     0.150
     3.692   100.320     0.150
     3.900    59.562     0.150
     3.900   105.250     0.150
     3.971    60.852     0.150
     3.971   102.711     0.150
     4.368    67.914     0.150
     4.368   119.297     0.150
     4.456    66.172     0.150
     4.456   113.508     0.150
     5.163    81.531     0.150
     5.163   136.594     0.150
     5.179    77.539     0.150
     5.179   137.078     0.150
     5.573    83.773     0.150
     5.573   144.133     0.150
     5.883    94.750     0.150
     5.883    94.750     0.150
     5.883   154.930     0.150
     6.132    94.852     0.150
     6.132   162.117     0.150
     6.238    93.062     0.150
     6.238   164.727     0.150
     6.330    94.688     0.150
     6.330   168.047     0.150
     6.406    97.281     0.150
     6.406   168.023     0.150
     6.672   174.180     0.150
     7.097   186.133     0.150
     8.882   232.977     0.150
     9.937   145.570     0.150
     9.937   256.562     0.150
    11.058   816.453     0.150
    11.227   277.211     0.150
    11.227   277.211     0.150
    48.672   207.938     0.150
    47.706   209.711     0.150
    94.706   215.289     0.150
    94.705   225.688     0.150
    18.582   257.461     0.150
   105.480   262.312     0.150
    85.754   262.648     0.150
    19.407   266.312     0.150
    96.769   297.312     0.150
     2.039   297.023     0.150
    22.361   298.742     0.150
    94.357   302.531     0.150
    28.062   303.461     0.150
    95.786   306.883     0.150
   123.976   308.477     0.150
    27.007   342.773     0.150
    53.605  4025.594     0.150
    53.613  4028.570     0.150
    53.962  4071.414     0.150
    53.967  4064.359     0.150
    53.980  4067.695     0.150
   128.945  1148.469     0.150
   140.610  1168.422     0.150
     2.092    34.871     0.150
     2.288    38.219     0.150
     2.347    68.961     0.150
     5.383   143.961     0.150
     0.906    15.508     0.150
     0.906    26.668     0.150
     1.250    21.707     0.150
     1.250    38.377     0.150
     1.283    23.918     0.150
     1.525    26.617     0.150
     2.361    45.297     0.150
     2.427    74.748     0.150
     2.503    38.957     0.150
     2.576    44.207     0.150
     2.861    62.158     0.150
     2.861   100.697     0.150
     2.888    88.428     0.150
     3.092    48.998     0.150
     3.325    59.498     0.150
     3.876   117.018     0.150
     4.628    83.297     0.150
     4.628   140.678     0.150
     6.558   201.107     0.150
     0.469    10.760     0.150
     0.469    17.630     0.150
     0.885    16.760     0.150
     1.037    18.820     0.150
     1.037    31.340     0.150
     1.123    20.480     0.150
     1.123    34.500     0.150
     1.345    23.720     0.150
     1.345    40.520     0.150
     1.360    24.070     0.150
     1.360    40.480     0.150
     1.417    24.990     0.150
     1.417    41.790     0.150
     1.870    31.520     0.150
     1.870    53.580     0.150
     1.953    32.000     0.150
     1.953    55.830     0.150
     2.056    33.220     0.150
     2.056    57.460     0.150
     2.139    35.950     0.150
     2.139    60.360     0.150
     2.218    36.780     0.150
     2.218    62.450     0.150
     2.222    37.040     0.150
     2.222    62.610     0.150
     2.244    36.880     0.150
     2.244    62.330     0.150
     2.275    37.930     0.150
     2.275    64.580     0.150
     2.300    37.400     0.150
     2.300    64.470     0.150
     2.304    37.630     0.150
     2.304    65.180     0.150
     2.322    37.690     0.150
     2.322    65.070     0.150
     2.321    38.750     0.150
     2.321    64.820     0.150
     2.321    38.170     0.150
     2.350    38.100     0.150
     2.350    40.940     0.150
     2.350    65.160     0.150
     2.366    38.890     0.150
     2.366    65.250     0.150
     2.371    37.560     0.150
     2.371    66.310     0.150
     2.370    38.820     0.150
     2.370    65.840     0.150
     2.383    68.310     0.150
     2.383    39.150     0.150
     2.383    68.310     0.150
     2.385    38.650     0.150
     2.385    66.410     0.150
     2.387    38.780     0.150
     2.387    66.860     0.150
     2.393    38.810     0.150
     2.393    66.620     0.150
     2.426    39.700     0.150
     2.426    67.670     0.150
     2.431    73.880     0.150
     2.431    39.550     0.150
     2.431    66.960     0.150
     2.431    73.880     0.150
     2.458    39.410     0.150
     2.458    68.070     0.150
     2.459    39.760     0.150
     2.459    67.820     0.150
     2.478    40.260     0.150
     2.478    68.070     0.150
     2.525    41.270     0.150
     2.525    70.050     0.150
     2.588    41.030     0.150
     2.588    70.920     0.150
     2.624    68.250     0.150
     2.624    32.030     0.150
     2.624    68.250     0.150
     2.801    44.470     0.150
     2.801    77.310     0.150
     2.816    56.740     0.150
     2.816    86.190     0.150
     2.879    46.580     0.150
     2.879    78.610     0.150
     2.901    45.410     0.150
     2.901    78.980     0.150
     2.910    48.150     0.150
     2.910    87.750     0.150
     3.050    47.460     0.150
     3.050    82.720     0.150
     3.076    47.760     0.150
     3.076    82.450     0.150
     3.273    50.710     0.150
     3.273    88.110     0.150
     3.741    57.310     0.150
     3.741   100.420     0.150
     3.825    56.790     0.150
     3.825   102.440     0.150
     3.828    57.200     0.150
     3.828   100.900     0.150
     4.090    62.240     0.150
     4.151    62.910     0.150
     4.151   110.360     0.150
     4.184    65.720     0.150
     4.184   110.770     0.150
     4.587    68.520     0.150
     4.587   120.920     0.150
     4.689    69.810     0.150
     4.689   124.820     0.150
     4.859    73.350     0.150
     4.859   127.970     0.150
     5.002    74.030     0.150
     5.002   131.160     0.150
     5.226    78.290     0.150
     5.226   137.960     0.150
     5.495    80.580     0.150
     5.495   142.640     0.150
     5.510   144.580     0.150
     5.510   144.580     0.150
     5.705    82.950     0.150
     5.705   147.870     0.150
     5.679    84.900     0.150
     5.679   148.370     0.150
     6.703    98.430     0.150
     6.703   172.300     0.150
     6.776    99.510     0.150
     6.776   170.660     0.150
     7.844   115.100     0.150
     7.844   201.160     0.150
     7.876   115.820     0.150
     7.876   202.430     0.150
     7.967   204.590     0.150
     8.397   122.640     0.150
     8.420   123.100     0.150
     8.420   215.720     0.150
     9.249   238.510     0.150
     9.249   134.670     0.150
     9.249   238.510     0.150
     9.943    67.700     0.150
     9.943   118.320     0.150
    10.044   255.790     0.150
    10.411   768.051     0.150
    10.436   750.447     0.150
    10.728   154.520     0.150
    10.728   273.030     0.150
    10.991   156.180     0.150
    10.991   161.790     0.150
    12.536   184.190     0.150
    12.541   187.490     0.150
    49.379   197.990     0.150
    48.420   201.450     0.150
    14.261   202.720     0.150
    14.308   203.430     0.150
    50.720   204.730     0.150
    94.758   207.330     0.150
    14.705   208.000     0.150
    94.750   209.900     0.150
    14.916   210.730     0.150
    47.352   214.660     0.150
    11.083   217.850     0.150
    15.426   150.390     0.150
    17.608   241.200     0.150
    99.686   251.110     0.150
    18.585   585.421     0.150
    20.248   257.370     0.150
    88.700   265.890     0.150
    19.730   265.700     0.150
    19.805   269.570     0.150
    96.115   281.090     0.150
    59.559   281.740     0.150
     2.213   288.080     0.150
    21.672   288.690     0.150
    94.274   294.060     0.150
    28.791   294.590     0.150
    72.935   299.170     0.150
    32.924   302.450     0.150
    61.298   314.840     0.150
    24.227   313.580     0.150
    24.227   316.490     0.150
   120.844   316.500     0.150
    25.093   323.580     0.150
   122.807   329.760     0.150
    26.721   335.720     0.150
    26.751   338.010     0.150
    29.734   366.590     0.150
    32.356   388.370     0.150
    56.912   587.790     0.150
    58.194   591.510     0.150
    59.988   604.153     0.150
    78.508   718.200     0.150
    79.940   727.030     0.150
    85.002   752.820     0.150
    90.611   782.490     0.150
    91.656   787.010     0.150
    91.989   785.720     0.150
    98.993   818.260     0.150
   100.833   829.300     0.150
    85.478   255.280     0.150
    72.935   255.480     0.150
   105.553   255.000     0.150
     7.710   112.860     0.150
     4.329    65.050     0.150
     4.329   114.880     0.150
     2.698    38.443     0.150
     3.183    82.484     0.150
     3.393    48.914     0.150
     3.926   105.734     0.150
     4.256   111.414     0.150
     4.594    74.395     0.150
     5.056    71.885     0.150
     8.042   114.795     0.150
     8.132   115.084     0.150
    10.109    73.773     0.150
    10.109   117.273     0.150
     2.277    65.145     0.150
     2.306    60.094     0.150
     2.322    60.363     0.150
     2.413    62.855     0.150
     2.772    84.645     0.150
     3.923    98.004     0.150
     4.035    58.234     0.150
     0.900    15.914     0.150
     0.900    27.234     0.150
     1.037    22.684     0.150
     1.312    27.117     0.150
     1.312    20.664     0.150
     1.356    21.695     0.150
     1.300    21.637     0.150
     1.813    28.254     0.150
     1.845    28.387     0.150
     2.169    34.297     0.150
     2.302    36.137     0.150
     2.668    41.184     0.150
     2.726    38.805     0.150
     2.758    46.305     0.150
    29.850   132.836     0.150
    11.138   836.426     0.150
    11.161   837.504     0.150
    11.229   166.797     0.150
    11.866   174.895     0.150
    13.277   193.906     0.150
    13.729   198.895     0.150
    91.588   250.805     0.150
    18.103   254.605     0.150
    18.665   260.004     0.150
    18.729   264.301     0.150
    18.729   261.906     0.150
    19.339   270.223     0.150
    19.339   270.207     0.150
    19.382   277.105     0.150
    88.847   277.215     0.150
    22.061   296.395     0.150
    22.061   296.406     0.150
    22.162   302.305     0.150
    22.595   302.066     0.150
    22.595   302.105     0.150
    22.848   562.676     0.150
    22.848   308.004     0.150
    23.367   317.707     0.150
    23.604   313.406     0.150
    23.756   317.406     0.150
    24.489   321.547     0.150
    24.489   321.504     0.150
    73.535   323.906     0.150
    58.203   324.496     0.150
    58.203   317.207     0.150
    73.535   327.605     0.150
    91.464   335.660     0.150
    26.240   340.504     0.150
    73.535   336.906     0.150
    26.318   340.504     0.150
    73.535   342.105     0.150
    73.535   336.207     0.150
    27.735   352.406     0.150
    27.217   359.504     0.150
    84.155   355.875     0.150
    84.155   355.707     0.150
    73.535   356.605     0.150
    96.880   365.305     0.150
    29.118   365.785     0.150
    31.819   388.133     0.150
    31.819   387.805     0.150
    35.170   417.004     0.150
    36.741   432.727     0.150
    38.127   442.406     0.150
    44.958   499.504     0.150
    45.700   503.754     0.150
    45.700   503.504     0.150
    47.090   515.004     0.150
    51.703   549.406     0.150
    51.703   549.367     0.150
    51.861   562.664     0.150
    56.046   581.504     0.150
    56.302   583.406     0.150
    56.302   583.406     0.150
    57.711   594.207     0.150
    57.917   595.305     0.150
    58.113   596.953     0.150
    59.128   604.504     0.150
    60.402   612.504     0.150
    62.418   626.004     0.150
    63.021   630.605     0.150
    65.779   648.504     0.150
    67.580   658.805     0.150
    69.270   670.195     0.150
    69.270   670.207     0.150
    71.877   684.805     0.150
    80.053   732.906     0.150
    80.075   733.504     0.150
    80.787   734.656     0.150
    80.888   938.094     0.150
    81.083   736.707     0.150
    81.083   935.254     0.150
    81.237   737.906     0.150
    81.237   939.047     0.150
    81.359   739.066     0.150
    81.485   739.344     0.150
    81.814   741.414     0.150
    83.481   751.875     0.150
    83.481   751.906     0.150
    83.878  1442.805     0.150
    84.392   756.406     0.150
    85.255   761.004     0.150
    85.873   763.004     0.150
    86.164   763.855     0.150
    91.108   787.207     0.150
    91.886   793.004     0.150
    92.092   792.277     0.150
    92.092   792.305     0.150
    92.624   804.004     0.150
    92.624  1138.805     0.150
    94.390   805.406     0.150
    95.215   809.305     0.150
   128.963  1149.922     0.150
   128.963  1149.906     0.150
   129.621  1153.605     0.150
   140.758  1175.004     0.150
    52.819   342.605     0.150
    73.535   344.605     0.150
   139.012   342.305     0.150
    73.535   347.504     0.150
    73.535   341.504     0.150
    73.535   347.805     0.150
    73.535   347.707     0.150
    32.320   255.906     0.150
    73.535   340.105     0.150
    78.981   726.496     0.150
     0.364    11.797     0.150
     0.364    17.246     0.150
     0.481    13.766     0.150
     0.481    19.945     0.150
     1.122    22.707     0.150
     1.845    33.004     0.150
     2.169    39.844     0.150
     3.765    62.527     0.150
     3.765   106.375     0.150
     4.588    71.605     0.150
     5.309   100.465     0.150
     5.309   170.906     0.150
     6.032    97.887     0.150
     9.027   237.387     0.150
     9.164    84.707     0.150
     9.164   144.027     0.150
    12.624   191.285     0.150
    16.548   238.375     0.150
    18.683   264.566     0.150
    22.149   307.824     0.150
    22.187   302.816     0.150
     1.712    42.074     0.150
     1.739    53.152     0.150
     2.021    51.773     0.150
     2.082    40.352     0.150
     2.108    55.324     0.150
     2.106    57.332     0.150
     2.359    62.074     0.150
     2.523    36.352     0.150
     2.852    39.262     0.150
     3.103    44.543     0.150
     1.385    36.359     0.150
     1.513    37.570     0.150
     1.905    57.590     0.150
     2.135    32.547     0.150
     2.220    32.637     0.150
     2.226    29.789     0.150
     2.235    57.098     0.150
     2.256    32.570     0.150
     2.256    61.059     0.150
     2.284   242.840     0.150
     2.284   270.879     0.150
     2.322    69.387     0.150
     2.555    44.480     0.150
     2.773    79.250     0.150
     2.813    51.020     0.150
     2.925    49.777     0.150
     2.910    82.578     0.150
     3.250    54.027     0.150
     3.425    93.480     0.150
     2.218   242.477     0.150
     2.218   270.586     0.150
     2.545    37.148     0.150
     2.908    44.598     0.150
     3.652   102.316     0.150
     3.682   103.258     0.150
     5.023   136.629     0.150
     9.770    68.898     0.150
     9.770   120.996     0.150
     0.420    17.199     0.150
     0.265     6.047     0.150
     1.131    38.309     0.150
     1.914    30.777     0.150
     2.226    36.656     0.150
     2.408    39.066     0.150
     2.927    45.746     0.150
     3.970   109.277     0.150
     7.750   199.059     0.150
     7.762   193.047     0.150
    30.489   140.039     0.150
     9.533   144.680     0.150
     9.795    71.699     0.150
     9.795   126.840     0.150
    10.520   787.621     0.150
    10.544   789.219     0.150
   109.599   275.398     0.150
    57.220   277.898     0.150
    22.261     6.652     0.150
    23.352     6.770     0.150
    24.455     6.953     0.150
    58.725   327.688     0.150
    91.424   339.527     0.150
    91.424   338.488     0.150
    83.575   358.770     0.150
    35.275   415.199     0.150
    53.941  4053.715     0.150
    53.949  4054.898     0.150
    54.297  4086.469     0.150
    54.301  4080.004     0.150
    54.315  4086.898     0.150
    81.136   737.809     0.150
    87.263   769.566     0.150
   108.014   771.137     0.150
   145.902  2105.520     0.150
     0.575    10.539     0.150
     0.989    14.805     0.150
     0.989    27.562     0.150
     1.236    19.555     0.150
     1.338    35.203     0.150
     1.338    23.508     0.150
     1.747    28.758     0.150
     1.825    29.719     0.150
     1.992    31.609     0.150
     2.229    33.625     0.150
     2.855    81.883     0.150
     3.333    95.172     0.150
     3.787   104.344     0.150
     4.378    64.398     0.150
     4.874    70.203     0.150
     5.002    72.562     0.150
     5.121    73.375     0.150
     7.166   101.719     0.150
     7.166   178.234     0.150
    29.766   128.273     0.150
     9.087    78.945     0.150
     9.087   141.688     0.150
    10.183   267.242     0.150
    11.205   159.859     0.150
    11.205   159.953     0.150
    11.210   842.273     0.150
    11.904   172.430     0.150
    13.374   202.414     0.150
    13.793   201.117     0.150
    46.995   209.242     0.150
    14.781   210.844     0.150
    48.432   210.836     0.150
    47.468   211.266     0.150
    15.095   213.859     0.150
    15.352   219.195     0.150
    94.800   223.188     0.150
    94.786   223.609     0.150
    46.399   225.094     0.150
    16.085   226.289     0.150
    10.252   229.547     0.150
    17.615   244.273     0.150
    91.637   244.047     0.150
    91.637   244.516     0.150
    18.180   251.672     0.150
    32.113   257.867     0.150
    99.723   259.312     0.150
   112.310   258.883     0.150
    18.826   260.875     0.150
   105.562   262.977     0.150
    85.935   264.039     0.150
    19.431   267.312     0.150
    88.881   273.914     0.150
    57.857   283.086     0.150
    58.638   291.945     0.150
    96.207   293.523     0.150
   129.221   295.094     0.150
    96.842   297.883     0.150
    22.654   298.867     0.150
    22.827   301.719     0.150
    27.841   306.164     0.150
    23.329   308.117     0.150
    41.964   318.875     0.150
    58.108   319.898     0.150
    58.108   319.016     0.150
    63.201   323.773     0.150
    60.403   324.508     0.150
    83.812   323.555     0.150
    83.812   325.812     0.150
    91.512   330.648     0.150
    91.512   333.414     0.150
    32.113   336.242     0.150
    27.259   343.586     0.150
    27.820   349.938     0.150
    27.273   353.414     0.150
    84.252   350.648     0.150
    84.252   352.219     0.150
    29.047   360.867     0.150
    29.047   360.312     0.150
    30.434   373.305     0.150
    55.619   373.023     0.150
    31.212   380.703     0.150
    31.775   385.016     0.150
    13.185   394.242     0.150
    33.795   400.742     0.150
   124.591   407.016     0.150
    39.495   450.266     0.150
    40.728   459.648     0.150
    40.728   458.719     0.150
    44.863   494.914     0.150
    44.863   494.758     0.150
    45.432   499.094     0.150
    45.747   500.992     0.150
    45.747   501.414     0.150
    47.148   511.750     0.150
    53.360  4017.234     0.150
    53.369  4020.891     0.150
    20.314   568.289     0.150
    54.566   570.359     0.150
    55.423   573.203     0.150
    56.137   578.984     0.150
    57.123   585.828     0.150
    57.280   589.977     0.150
    14.134   590.047     0.150
    58.843   597.758     0.150
    59.927   605.539     0.150
    59.927   605.609     0.150
    62.083   619.688     0.150
    62.926   625.328     0.150
    71.940   681.969     0.150
    83.487   750.719     0.150
    86.097   762.047     0.150
   107.969   769.406     0.150
    93.164   792.289     0.150
    96.864   811.750     0.150
   122.948  1134.867     0.150
   122.948  1134.914     0.150
   111.462  1190.836     0.150
    73.614   338.617     0.150
    73.614   355.219     0.150
    73.614   266.109     0.150
   139.103   343.516     0.150
    73.614   322.516     0.150
    73.614   356.617     0.150
    73.614   335.719     0.150
    73.614   334.914     0.150
    73.614   339.516     0.150
    73.614   332.719     0.150
    73.614   340.617     0.150
    29.917   348.016     0.150
    73.614   336.414     0.150
    73.614   334.617     0.150
    73.614   317.719     0.150
    73.614   339.516     0.150
    73.614   335.812     0.150
     8.188   122.316     0.150
    11.165   160.414     0.150
    11.165   160.414     0.150
    13.565   195.414     0.150
    13.565   195.414     0.150
    13.565   193.945     0.150
    14.015   205.016     0.150
    14.015   205.016     0.150
    14.015   205.016     0.150
    14.015   204.016     0.150
    15.490   224.016     0.150
    15.490   224.016     0.150
    15.490   224.016     0.150
    15.490   223.293     0.150
    17.794   251.414     0.150
    17.794   251.414     0.150
    17.794   251.414     0.150
    18.590   262.016     0.150
    18.590   262.016     0.150
    19.182   266.816     0.150
    19.182   266.816     0.150
    19.182   266.816     0.150
    19.182   266.914     0.150
    19.525   276.914     0.150
    19.525   276.914     0.150
    19.525   276.914     0.150
    19.525   276.914     0.150
    20.117   277.613     0.150
    20.117   277.613     0.150
    20.117   277.613     0.150
    21.908   292.816     0.150
    21.908   292.816     0.150
    21.908   292.816     0.150
    21.908   292.746     0.150
    22.433   299.113     0.150
    22.433   299.113     0.150
    22.433   299.113     0.150
    22.433   299.023     0.150
    22.720   306.215     0.150
    22.720   306.215     0.150
    22.720   306.215     0.150
    22.723   306.113     0.150
    22.723   306.113     0.150
    22.723   306.016     0.150
    24.335   318.215     0.150
    24.335   318.215     0.150
    24.335   318.215     0.150
    24.572   324.215     0.150
    24.572   324.215     0.150
    25.217   335.414     0.150
    25.217   335.414     0.150
    25.217   335.414     0.150
    91.309   334.023     0.150
    25.657   335.215     0.150
    25.657   335.215     0.150
    26.858   345.613     0.150
    26.858   345.613     0.150
    27.080   346.113     0.150
    27.080   346.113     0.150
    27.080   346.113     0.150
    27.570   349.914     0.150
    27.570   349.914     0.150
    27.570   349.914     0.150
    84.026   353.906     0.150
    27.981   355.016     0.150
    27.981   355.016     0.150
    29.145   364.516     0.150
    29.145   364.516     0.150
    30.257   372.816     0.150
    30.257   372.816     0.150
    31.790   386.414     0.150
    31.790   386.414     0.150
    31.790   386.414     0.150
    34.261   410.516     0.150
    34.261   410.516     0.150
    34.261   409.895     0.150
    35.032   415.316     0.150
    35.032   415.316     0.150
    35.032   415.316     0.150
    35.057   415.516     0.150
    35.057   415.516     0.150
    35.057   415.516     0.150
    22.993   423.137     0.150
    36.258   428.016     0.150
    36.258   428.016     0.150
    36.258   430.113     0.150
    36.258   427.316     0.150
    73.368   477.043     0.150
    73.368   476.785     0.150
    73.368   481.086     0.150
    44.035   488.715     0.150
    44.035   488.715     0.150
    44.642   500.613     0.150
    44.642   500.613     0.150
    44.642   499.715     0.150
    44.642   501.016     0.150
    44.642   499.754     0.150
    73.368   500.215     0.150
    73.368   513.555     0.150
    96.711   516.055     0.150
    73.368   548.914     0.150
    51.986   554.316     0.150
    51.986   554.316     0.150
    53.137   563.215     0.150
    53.137   563.215     0.150
    53.300   562.316     0.150
    53.300   562.316     0.150
    53.300   562.336     0.150
    56.652   586.113     0.150
    56.652   586.113     0.150
    57.279   590.816     0.150
    73.368   589.855     0.150
    57.961   595.016     0.150
    57.961   595.016     0.150
    59.267   604.715     0.150
    59.267   604.715     0.150
    59.267   603.516     0.150
    62.849   627.613     0.150
    64.879   642.113     0.150
    64.879   642.113     0.150
    65.191   648.023     0.150
    65.551   645.434     0.150
    66.698   655.113     0.150
    66.698   655.113     0.150
    67.413   656.316     0.150
    67.413   656.316     0.150
    69.937   674.414     0.150
    69.937   674.414     0.150
    71.713   682.016     0.150
    71.713   682.016     0.150
    72.555   691.016     0.150
    72.555   691.016     0.150
    27.361   705.188     0.150
    73.368   707.570     0.150
    73.368   707.527     0.150
    64.836   709.414     0.150
    73.368   712.758     0.150
    16.544   713.551     0.150
    73.368   712.816     0.150
    76.140   710.816     0.150
    76.140   710.816     0.150
    77.689   717.516     0.150
    77.689   717.516     0.150
    77.626   720.613     0.150
    77.626   720.613     0.150
    77.875   728.113     0.150
    77.875   728.113     0.150
    16.180   725.914     0.150
    79.144   730.391     0.150
    79.913   731.613     0.150
    79.913   731.613     0.150
    80.359   735.750     0.150
    80.587   738.504     0.150
    80.682   737.824     0.150
    80.777   738.316     0.150
    80.877   740.184     0.150
    80.886   739.094     0.150
    81.076   739.176     0.150
    81.380   740.996     0.150
    81.706   742.816     0.150
    73.368   745.410     0.150
    83.004   751.309     0.150
    83.209   750.539     0.150
    73.368   752.406     0.150
    83.370   747.113     0.150
    83.370   747.113     0.150
    83.370   747.113     0.150
    73.368   750.617     0.150
    83.580   752.160     0.150
    84.085   752.203     0.150
    73.368   758.418     0.150
    73.368   761.676     0.150
    73.368   762.195     0.150
    85.973   766.820     0.150
    85.982   764.816     0.150
    85.982   764.816     0.150
    85.982   764.816     0.150
    86.004   762.414     0.150
    86.004   762.414     0.150
    73.368   764.949     0.150
    86.194   766.172     0.150
    73.368   766.215     0.150
    86.247   767.195     0.150
    73.368   767.523     0.150
    86.476   768.055     0.150
    73.368   767.645     0.150
    73.368   768.754     0.150
    87.136   770.547     0.150
    86.824   712.211     0.150
    86.824   772.609     0.150
    73.368   773.766     0.150
   107.795   772.414     0.150
    88.311   775.438     0.150
    88.123   777.613     0.150
    88.123   777.613     0.150
    88.657   776.414     0.150
    88.657   776.414     0.150
    88.981   776.613     0.150
    88.981   778.789     0.150
    89.282   776.715     0.150
    89.282   776.715     0.150
    89.282   775.613     0.150
    89.282   779.906     0.150
    90.220   782.914     0.150
    90.382   785.594     0.150
    90.420   782.695     0.150
    90.510   783.293     0.150
    91.891   790.914     0.150
    91.891   790.914     0.150
    91.955   789.934     0.150
    92.470   793.715     0.150
    92.470   793.715     0.150
    93.387   798.414     0.150
    93.387   798.414     0.150
    93.399   798.113     0.150
    93.399   798.113     0.150
    93.572   801.914     0.150
    93.572   801.914     0.150
    93.572   801.914     0.150
    93.659   800.113     0.150
    93.659   800.113     0.150
    73.368   798.676     0.150
    73.368   798.246     0.150
    93.677   799.215     0.150
    93.677   799.215     0.150
    93.796   802.414     0.150
    93.796   802.414     0.150
    93.796   802.414     0.150
    94.027   803.914     0.150
    94.027   803.914     0.150
    94.027   803.914     0.150
    94.189   804.613     0.150
    94.189   804.613     0.150
    94.225   804.816     0.150
    94.675   802.586     0.150
    94.930   811.113     0.150
    94.930   811.113     0.150
    95.023   806.816     0.150
    95.370   798.113     0.150
    95.382   807.613     0.150
    95.719   813.215     0.150
    95.719   813.215     0.150
    95.981   811.215     0.150
    95.989   808.613     0.150
    96.170   813.016     0.150
    96.562   813.414     0.150
    96.562   813.414     0.150
    73.368   824.320     0.150
    99.037   813.926     0.150
    73.368   814.492     0.150
    99.202   821.914     0.150
    99.202   821.914     0.150
    99.413   815.969     0.150
    99.450   814.426     0.150
    99.576   811.254     0.150
    73.368   816.512     0.150
    73.368   826.520     0.150
    73.368   827.371     0.150
    73.368   821.691     0.150
   102.669   832.387     0.150
   104.814   851.715     0.150
   104.814   851.715     0.150
   104.814   851.715     0.150
   106.663   858.715     0.150
   106.663   858.715     0.150
   110.163   871.816     0.150
EOF
gmt plot $proj $reg -Sx -Wthin -Gblack << EOF
     1.544    29.672     0.150
     2.403    42.172     0.150
     2.541    41.672     0.150
     2.495    44.672     0.150
     2.570    45.172     0.150
     2.583    46.172     0.150
     2.864    46.672     0.150
     2.926    48.172     0.150
     4.735    73.172     0.150
     6.448    98.172     0.150
     7.098   105.422     0.150
     9.177   137.672     0.150
    10.298   149.172     0.150
    15.976   227.871     0.150
    16.387   233.172     0.150
    16.519   233.973     0.150
    16.818   238.172     0.150
    17.276   241.672     0.150
    17.276   437.422     0.150
    17.821   247.371     0.150
    19.124   265.273     0.150
    19.124   264.672     0.150
    19.127   265.324     0.150
    19.271   265.672     0.150
    19.274   261.773     0.150
    19.888   271.773     0.150
    20.380   280.672     0.150
    20.394   281.172     0.150
    20.710   280.371     0.150
    20.830   283.273     0.150
    20.830   520.172     0.150
    20.768   283.973     0.150
    20.860   285.941     0.150
    21.191   291.371     0.150
    21.346   289.172     0.150
    21.654   293.672     0.150
    21.702   294.172     0.150
    21.978   298.672     0.150
    22.259   296.172     0.150
    22.259   296.473     0.150
    22.223   299.172     0.150
    22.376   297.570     0.150
    22.496   298.172     0.150
    22.496   298.570     0.150
    22.714   304.852     0.150
    22.787   305.172     0.150
    22.811   305.172     0.150
    22.983   304.172     0.150
    22.983   304.371     0.150
    23.113   305.172     0.150
    23.113   305.570     0.150
    23.383   309.973     0.150
    23.402   309.773     0.150
    23.533   312.172     0.150
    24.096   318.672     0.150
    24.109   319.172     0.150
    24.130   319.422     0.150
    24.130   535.172     0.150
    24.130   590.512     0.150
    24.130   650.172     0.150
    24.130   318.535     0.150
    24.915   325.672     0.150
    25.324   330.172     0.150
    25.521   332.172     0.150
    26.088   337.172     0.150
    26.002   335.172     0.150
    26.047   335.273     0.150
    26.306   337.172     0.150
    26.414   339.672     0.150
    26.685   341.172     0.150
    26.849   342.672     0.150
    26.814   342.672     0.150
    26.943   343.172     0.150
    26.957   343.070     0.150
    26.975   344.473     0.150
    27.106   346.570     0.150
    27.452   345.672     0.150
    27.452   348.070     0.150
    27.611   351.172     0.150
    27.534   347.172     0.150
    27.534   347.672     0.150
    27.535   349.371     0.150
    27.857   351.273     0.150
    27.857   644.172     0.150
    28.061   353.672     0.150
    28.061   633.172     0.150
    28.230   355.172     0.150
    28.347   356.871     0.150
    28.347   996.172     0.150
    28.366   356.570     0.150
    28.740   358.172     0.150
    28.975   358.773     0.150
    28.975   656.070     0.150
    28.901   361.570     0.150
    29.050   361.371     0.150
    29.064   363.371     0.150
    29.734   369.473     0.150
    30.252   373.473     0.150
    30.340   374.273     0.150
    30.799   377.172     0.150
    30.858   378.273     0.150
    30.908   378.672     0.150
    31.017   378.172     0.150
    31.114   381.473     0.150
    31.194   381.371     0.150
    31.582   383.172     0.150
    31.981   389.473     0.150
    32.356   390.473     0.150
    32.389   392.473     0.150
    32.389     6.500     0.150
    32.389   458.570     0.150
    32.503   391.570     0.150
    34.253   404.172     0.150
    34.253   404.973     0.150
    34.655   409.871     0.150
    34.614   411.172     0.150
    34.744   411.172     0.150
    34.906   412.934     0.150
    34.906     7.449     0.150
    34.906   740.312     0.150
    34.906   413.895     0.150
    35.025   413.172     0.150
    35.159   415.781     0.150
    35.159     6.461     0.150
    35.159   501.703     0.150
    35.159   415.246     0.150
    35.535   417.172     0.150
    35.863   424.172     0.150
    36.121   421.172     0.150
    36.246   422.172     0.150
    36.199   423.570     0.150
    36.383   423.172     0.150
    36.403   426.570     0.150
    36.339   425.172     0.150
    36.797   426.672     0.150
    36.797   785.172     0.150
    36.964   430.172     0.150
    36.965   429.820     0.150
    36.993   429.172     0.150
    37.090   431.773     0.150
    37.339   433.070     0.150
    37.372   432.742     0.150
    37.330   434.172     0.150
    37.698   432.992     0.150
    37.877   437.273     0.150
    37.937   438.371     0.150
    43.003   481.172     0.150
    45.060   497.613     0.150
    45.060   495.652     0.150
    45.264   500.070     0.150
    45.437   498.672     0.150
    46.820   509.371     0.150
    46.856   510.371     0.150
    48.355   523.172     0.150
    49.219   530.172     0.150
    50.654   538.871     0.150
    51.430   545.172     0.150
    52.871   557.172     0.150
    52.805   556.672     0.150
    55.336   576.773     0.150
    55.494   574.172     0.150
    55.792   579.672     0.150
    55.825   577.172     0.150
    56.744   586.672     0.150
    56.736   584.273     0.150
    56.736   584.172     0.150
    57.012   587.172     0.150
    57.054   587.172     0.150
    57.079   589.172     0.150
    57.096   587.672     0.150
    57.070   588.773     0.150
    57.156   589.371     0.150
    57.294   590.273     0.150
    57.391   591.070     0.150
    57.908   593.570     0.150
    57.908     6.621     0.150
    57.908   724.352     0.150
    57.908  1076.410     0.150
    57.908  1087.453     0.150
    57.908   593.016     0.150
    57.908   592.871     0.150
    59.122   599.570     0.150
    59.561   738.172     0.150
    59.561  1095.172     0.150
    60.069   606.273     0.150
    59.959   608.570     0.150
    59.971   608.570     0.150
    60.186   607.672     0.150
    60.108   609.871     0.150
    60.217   607.172     0.150
    60.217   607.773     0.150
    60.160   610.070     0.150
    60.348   609.172     0.150
    60.256   610.773     0.150
    60.622   611.273     0.150
    60.622   611.070     0.150
    60.876   612.273     0.150
    63.338   628.773     0.150
    63.972   632.973     0.150
    64.228   636.973     0.150
    64.228  1152.973     0.150
    64.744   637.273     0.150
    64.771   636.172     0.150
    64.771   784.172     0.150
    64.771  1160.172     0.150
    64.771  1230.172     0.150
    65.401   642.871     0.150
    66.182   649.070     0.150
    67.297   654.172     0.150
    69.140   665.871     0.150
    69.528   673.371     0.150
    70.057   672.172     0.150
    70.257   676.172     0.150
    70.257  1228.172     0.150
    70.536   676.172     0.150
    70.536   696.172     0.150
    70.536   836.172     0.150
    71.208   682.570     0.150
    71.579   680.570     0.150
    74.785   703.371     0.150
    74.718   702.871     0.150
    76.248   712.773     0.150
    76.407   711.371     0.150
    76.407   875.172     0.150
    76.407  1296.172     0.150
    77.586   717.172     0.150
    77.918   719.371     0.150
    77.743   720.172     0.150
    77.743  1312.172     0.150
    77.743  1620.172     0.150
    78.017   719.570     0.150
    78.137   720.172     0.150
    78.686   722.871     0.150
    78.705   722.672     0.150
    78.952   723.871     0.150
    79.335   727.973     0.150
    79.397   728.070     0.150
    79.389   726.672     0.150
    79.521   727.070     0.150
    79.580   727.473     0.150
    79.589   729.172     0.150
    79.694   725.172     0.150
    79.694  1326.172     0.150
    79.787   728.160     0.150
    79.808   728.172     0.150
    79.808   729.023     0.150
    79.841   729.773     0.150
    79.841  1332.172     0.150
    79.957   729.570     0.150
    80.050   730.773     0.150
    80.077   732.172     0.150
    80.099   730.562     0.150
    80.110   729.863     0.150
    80.151   730.480     0.150
    80.460   733.973     0.150
    80.836   734.531     0.150
    81.034   736.570     0.150
    81.560   738.383     0.150
    81.818   740.973     0.150
    81.954   742.070     0.150
    81.982   740.891     0.150
    81.991   740.410     0.150
    82.020   740.781     0.150
    82.026   740.383     0.150
    82.029   741.172     0.150
    82.029   741.672     0.150
    82.029   931.172     0.150
    82.489   747.172     0.150
    82.538   747.172     0.150
    82.589   746.172     0.150
    82.695   746.973     0.150
    82.711   744.641     0.150
    82.807   748.672     0.150
    82.968   747.672     0.150
    83.037   747.371     0.150
    83.078   747.172     0.150
    83.079   748.172     0.150
    83.081   746.973     0.150
    83.097   746.273     0.150
    83.107   746.672     0.150
    83.167   748.172     0.150
    83.240   749.371     0.150
    83.232   747.371     0.150
    83.283   749.172     0.150
    83.286   749.172     0.150
    83.371   748.172     0.150
    83.371   935.172     0.150
    83.371  1375.172     0.150
    83.371  1421.172     0.150
    83.365   750.773     0.150
    83.485   748.633     0.150
    83.511   748.570     0.150
    83.656   752.172     0.150
    83.653   752.371     0.150
    83.704   750.172     0.150
    83.797   751.172     0.150
    83.733   751.172     0.150
    83.733  1376.172     0.150
    83.733   940.172     0.150
    83.982   752.172     0.150
    83.982  1376.172     0.150
    83.982  1432.172     0.150
    84.109   752.672     0.150
    84.113   751.273     0.150
    84.234   752.672     0.150
    84.315   753.172     0.150
    84.320   754.672     0.150
    84.321   755.172     0.150
    84.474   755.172     0.150
    84.476   756.172     0.150
    84.496   754.172     0.150
    84.558   755.371     0.150
    84.849   756.086     0.150
    84.878   755.672     0.150
    84.908   755.672     0.150
    85.083   754.070     0.150
    85.083   954.273     0.150
    85.229   757.371     0.150
    85.112   757.172     0.150
    85.112     8.000     0.150
    85.112   757.473     0.150
    85.112     7.699     0.150
    85.112  1440.172     0.150
    85.260   758.023     0.150
    85.260   754.172     0.150
    85.260   754.570     0.150
    85.323   757.473     0.150
    85.519   759.172     0.150
    85.519  1385.172     0.150
    85.519  1393.172     0.150
    85.520   760.172     0.150
    85.520   957.172     0.150
    85.520  1394.172     0.150
    85.520  1732.172     0.150
    85.571   759.273     0.150
    85.577   760.473     0.150
    85.577   762.473     0.150
    85.613   759.172     0.150
    85.628   759.273     0.150
    85.726   760.172     0.150
    85.755   759.570     0.150
    85.871   760.344     0.150
    85.871     5.137     0.150
    85.871     7.777     0.150
    85.871   959.480     0.150
    85.871  1391.582     0.150
    85.871  1397.711     0.150
    85.871  1406.262     0.150
    85.913   761.570     0.150
    85.913  1386.172     0.150
    85.913  1398.172     0.150
    85.927   762.172     0.150
    86.011   760.672     0.150
    85.951   759.172     0.150
    85.951    11.000     0.150
    85.951  1385.172     0.150
    85.951   962.172     0.150
    85.951  1454.172     0.150
    86.077   761.070     0.150
    86.093   765.172     0.150
    86.097   765.172     0.150
    86.121   761.773     0.150
    86.322   761.973     0.150
    86.325   762.172     0.150
    86.333   763.172     0.150
    86.395   762.172     0.150
    86.395   964.172     0.150
    86.395  1396.172     0.150
    86.453   763.172     0.150
    86.453   973.172     0.150
    86.477   765.172     0.150
    86.477   762.973     0.150
    86.494   764.371     0.150
    86.494   974.172     0.150
    86.485   762.371     0.150
    86.562   764.973     0.150
    86.654   763.473     0.150
    86.688   763.773     0.150
    87.009   765.672     0.150
    87.009   768.672     0.150
    87.253   766.672     0.150
    87.253     7.500     0.150
    87.253   970.371     0.150
    87.253  1383.172     0.150
    87.279   765.473     0.150
    87.460   769.371     0.150
    87.537   768.562     0.150
    87.757   769.191     0.150
    87.766   768.871     0.150
    87.954   773.172     0.150
    87.954   976.172     0.150
    87.954  1405.172     0.150
    88.109   772.422     0.150
    88.149   771.172     0.150
    88.149   772.773     0.150
    88.163   772.172     0.150
    88.178   772.863     0.150
    88.302   771.371     0.150
    88.312   772.672     0.150
    88.319   772.672     0.150
    88.338   770.070     0.150
    88.338   978.672     0.150
    88.338  1401.172     0.150
    88.408   773.871     0.150
    88.613   773.121     0.150
    88.699   774.742     0.150
    88.845   775.102     0.150
    88.887   776.773     0.150
    88.996   775.871     0.150
    89.079   773.871     0.150
    89.079  1410.172     0.150
    89.079   983.172     0.150
    89.079  1480.172     0.150
    89.186   777.371     0.150
    89.188   778.273     0.150
    89.238   777.371     0.150
    89.248   778.152     0.150
    89.259   778.672     0.150
    89.467   779.184     0.150
    89.555   780.371     0.150
    89.624   780.000     0.150
    89.681   778.172     0.150
    89.685   777.773     0.150
    89.711   779.773     0.150
    89.735   779.801     0.150
    89.799   990.172     0.150
    89.799  1415.172     0.150
    89.799  1500.172     0.150
    89.799  1795.172     0.150
    89.866   780.621     0.150
    89.885   781.473     0.150
    89.925   781.570     0.150
    89.997   780.473     0.150
    89.997     9.801     0.150
    89.997   994.570     0.150
    89.997  1420.172     0.150
    89.997   781.094     0.150
    89.996   780.391     0.150
    89.996     6.953     0.150
    89.996     8.941     0.150
    89.996   992.031     0.150
    90.022   781.211     0.150
    90.060   779.172     0.150
    90.091   780.172     0.150
    90.093   781.543     0.150
    90.097   780.273     0.150
    90.109   781.973     0.150
    90.141   781.473     0.150
    90.178   781.723     0.150
    90.214   782.160     0.150
    90.276   782.273     0.150
    90.276   992.172     0.150
    90.276  1417.172     0.150
    90.276  1440.172     0.150
    90.276  2321.172     0.150
    90.294   782.262     0.150
    90.314   783.473     0.150
    90.375   780.102     0.150
    90.445   782.723     0.150
    90.445   782.961     0.150
    90.453   783.211     0.150
    90.461   782.363     0.150
    90.482   782.902     0.150
    90.493   783.184     0.150
    90.523   783.320     0.150
    90.545   783.281     0.150
    90.567   783.531     0.150
    90.660   784.973     0.150
    90.778   784.172     0.150
    90.864   784.273     0.150
    90.864   783.172     0.150
    91.004   784.172     0.150
    91.004   786.172     0.150
    91.004   996.172     0.150
    91.004  1436.172     0.150
    91.004  1520.172     0.150
    91.004  1800.172     0.150
    91.127   787.172     0.150
    91.209   785.473     0.150
    91.209  1004.172     0.150
    91.367   787.773     0.150
    91.575   786.473     0.150
    91.622   787.672     0.150
    91.622    11.500     0.150
    91.622  1008.172     0.150
    91.622  1426.172     0.150
    91.622  1516.172     0.150
    91.664   789.172     0.150
    91.664  1004.172     0.150
    91.664  1422.172     0.150
    91.664  1524.172     0.150
    91.765   787.672     0.150
    91.765  1007.273     0.150
    91.868   789.773     0.150
    92.236   791.172     0.150
    92.318   792.172     0.150
    92.318  1012.172     0.150
    92.327   791.773     0.150
    92.351   791.973     0.150
    92.447   791.172     0.150
    92.447   793.973     0.150
    92.447  1012.973     0.150
    92.447  1447.672     0.150
    92.455   791.371     0.150
    92.455  1013.172     0.150
    92.633   793.172     0.150
    92.881   792.773     0.150
    92.894   794.473     0.150
    92.962   795.273     0.150
    93.273   796.070     0.150
    93.346   795.371     0.150
    93.346  1019.273     0.150
    93.346  1433.172     0.150
    93.346  1540.172     0.150
    93.344   794.172     0.150
    93.344  1018.172     0.150
    93.517   796.172     0.150
    93.517  1465.172     0.150
    93.517  1020.172     0.150
    93.517  1432.172     0.150
    93.517  1542.172     0.150
    93.630   795.672     0.150
    93.630  1021.973     0.150
    93.630  1432.672     0.150
    93.630  1533.672     0.150
    93.630  1542.172     0.150
    93.656   797.672     0.150
    93.656  1023.172     0.150
    93.656  1434.172     0.150
    93.740   797.172     0.150
    93.854   798.371     0.150
    93.865   798.273     0.150
    93.814   797.773     0.150
    93.814  1018.172     0.150
    93.814  1434.172     0.150
    93.814  1547.172     0.150
    93.814  1854.172     0.150
    94.062   800.070     0.150
    94.062    12.102     0.150
    94.117   798.871     0.150
    94.117  1023.570     0.150
    94.193   799.973     0.150
    94.256   800.723     0.150
    94.363   801.672     0.150
    94.599   801.273     0.150
    94.651   803.371     0.150
    94.715   801.172     0.150
    94.715   802.371     0.150
    94.715     9.301     0.150
    94.715  1031.871     0.150
    94.715  1440.172     0.150
    94.715  1556.172     0.150
    95.011   805.273     0.150
    95.011  1032.773     0.150
    95.251   804.473     0.150
    95.270   806.172     0.150
    95.357   805.273     0.150
    95.357  1036.773     0.150
    95.593   806.172     0.150
    95.593   808.172     0.150
    95.593    11.000     0.150
    95.703   809.172     0.150
    95.777   806.070     0.150
    95.855   809.172     0.150
    95.855  1039.172     0.150
    95.973   806.172     0.150
    95.973  1476.172     0.150
    95.973  1040.172     0.150
    95.973  1444.172     0.150
    95.973  1568.172     0.150
    96.346   809.172     0.150
    96.782   811.172     0.150
    96.791   812.172     0.150
    96.789   811.172     0.150
    96.789  1484.172     0.150
    96.789  1045.172     0.150
    96.789  1444.172     0.150
    96.789  1575.172     0.150
    97.024   812.273     0.150
    97.024  1044.172     0.150
    97.024  1448.172     0.150
    97.024  1571.172     0.150
    97.024  1884.172     0.150
    97.160   812.172     0.150
    97.814   815.672     0.150
    97.829   816.871     0.150
    97.881   816.672     0.150
    97.881  1055.672     0.150
    97.890   815.172     0.150
    97.919   817.172     0.150
    98.118   818.273     0.150
    98.111   818.172     0.150
    98.111  1458.172     0.150
    97.931  1058.172     0.150
    97.931  1590.172     0.150
    98.410   820.172     0.150
    98.410  1456.172     0.150
    98.606   818.172     0.150
    98.606  1459.172     0.150
    98.761   820.172     0.150
    98.954   823.172     0.150
    99.138   824.172     0.150
    99.138  1062.172     0.150
    99.138  1462.172     0.150
    99.138  1598.172     0.150
    99.202   822.172     0.150
    99.202  1062.172     0.150
    99.202  1460.172     0.150
    99.202  1600.172     0.150
    99.369   825.172     0.150
    99.369  1465.172     0.150
   100.024   826.871     0.150
   100.024  1068.172     0.150
   100.024  1466.172     0.150
   100.024  1611.172     0.150
   100.024  1945.172     0.150
   100.090   825.473     0.150
   100.090  1071.172     0.150
   100.480   830.070     0.150
   100.656   830.172     0.150
   100.656   828.172     0.150
   100.663   828.172     0.150
   100.663   828.871     0.150
   101.090   832.172     0.150
   101.274   830.172     0.150
   101.274  1078.172     0.150
   101.274  1468.172     0.150
   101.274  1622.172     0.150
   101.394   832.172     0.150
   101.395   832.172     0.150
   101.724   835.773     0.150
   102.064   836.172     0.150
   102.064   835.172     0.150
   102.831  1470.172     0.150
   103.702   844.172     0.150
   104.066   846.172     0.150
   104.345   846.172     0.150
   104.345  1105.172     0.150
   104.345  1486.172     0.150
   104.345  1556.172     0.150
   104.706   846.172     0.150
   104.706  1102.172     0.150
   104.706  1660.172     0.150
   104.706  1995.172     0.150
   104.741   845.172     0.150
   104.741  1104.172     0.150
   104.741  1484.172     0.150
   104.741  1658.172     0.150
   104.741  1988.172     0.150
   105.177   848.672     0.150
   105.392   849.172     0.150
   105.392  1106.172     0.150
   105.392  1492.172     0.150
   105.392  2010.172     0.150
   105.701   853.172     0.150
   105.701  1563.172     0.150
   105.701  1116.172     0.150
   107.158   857.172     0.150
   107.158  2043.172     0.150
   107.069   859.172     0.150
   107.069  1124.172     0.150
   107.151  1124.172     0.150
   107.151  1500.172     0.150
   107.151  1680.172     0.150
   107.151  2040.172     0.150
   108.217   862.172     0.150
   108.217  1138.172     0.150
   108.217  1504.172     0.150
   108.217  2040.172     0.150
   108.588   862.172     0.150
   108.588   862.973     0.150
   108.588  1130.973     0.150
   108.588  1502.773     0.150
   108.588  1692.570     0.150
   109.164   868.172     0.150
   109.164  1707.172     0.150
   109.441   869.172     0.150
   109.441  1140.172     0.150
   109.441  2064.172     0.150
   110.036  1142.172     0.150
   110.036  1512.172     0.150
   110.036  1713.172     0.150
   110.036  2072.172     0.150
   110.174   872.172     0.150
   110.174   872.773     0.150
   110.174  1507.172     0.150
   110.174  1705.172     0.150
   112.130   881.172     0.150
   112.130  1160.172     0.150
   112.130  1514.172     0.150
   112.130  1736.172     0.150
   112.434   883.172     0.150
   112.434  1161.172     0.150
   112.434  1732.172     0.150
   112.586  1165.172     0.150
   112.586  1614.172     0.150
   112.718   883.172     0.150
   112.718  1169.172     0.150
   112.718  1520.172     0.150
   112.718  1737.172     0.150
   112.954   885.172     0.150
   112.954  1166.172     0.150
   112.954  1744.172     0.150
   112.954  2107.172     0.150
   113.005   885.172     0.150
   113.061   884.172     0.150
   113.061   884.371     0.150
   113.061  1164.172     0.150
   113.061  1738.172     0.150
   113.061  1740.172     0.150
   113.168  1165.172     0.150
   113.168  1525.773     0.150
   113.168  1744.773     0.150
   114.056   889.172     0.150
   114.056  1174.172     0.150
   114.056  2117.172     0.150
   114.544   892.172     0.150
   114.544  1182.172     0.150
   114.544  1530.172     0.150
   114.544  1756.172     0.150
   114.453   890.172     0.150
   114.453  1180.172     0.150
   115.144  1125.570     0.150
   115.144  1182.172     0.150
   115.460  1192.172     0.150
   115.460  1532.172     0.150
   115.460  1764.172     0.150
   115.561  1185.172     0.150
   115.561  1528.172     0.150
   115.561  1768.172     0.150
   115.561  2140.172     0.150
   115.739  1124.172     0.150
   115.835   896.172     0.150
   116.042  1123.172     0.150
   116.319  1118.172     0.150
   116.319  1190.172     0.150
   116.319  1535.172     0.150
   116.319  1759.172     0.150
   116.281  1193.172     0.150
   116.281  1544.172     0.150
   116.601   902.172     0.150
   116.601  1191.172     0.150
   116.670   900.172     0.150
   116.670  1195.172     0.150
   116.968   902.172     0.150
   116.968  1194.172     0.150
   118.096  1130.172     0.150
   118.096  1202.172     0.150
   118.096  1541.172     0.150
   118.096  1785.672     0.150
   118.054  1204.172     0.150
   118.054  1556.172     0.150
   118.054  2173.172     0.150
   118.272  1202.172     0.150
   118.272  1546.172     0.150
   118.450   910.172     0.150
   118.450  1129.172     0.150
   118.450  1552.172     0.150
   118.450  1622.172     0.150
   118.450  1672.172     0.150
   118.450  1792.172     0.150
   118.450  2180.172     0.150
   119.144   910.172     0.150
   119.144  1131.172     0.150
   119.942  1131.172     0.150
   119.942  1215.172     0.150
   119.942  1550.172     0.150
   119.942  1808.172     0.150
   120.105  1131.172     0.150
   120.105  1218.672     0.150
   120.105  1553.172     0.150
   120.105  1808.172     0.150
   120.381   916.172     0.150
   120.381  1132.172     0.150
   120.381  1218.172     0.150
   120.381  1550.172     0.150
   120.381  1800.172     0.150
   120.953   918.172     0.150
   120.953  1135.172     0.150
   120.953  1225.172     0.150
   121.193   922.172     0.150
   121.193  1134.773     0.150
   121.193  1556.672     0.150
   121.193  1811.172     0.150
   121.256   920.172     0.150
   121.256  1134.172     0.150
   121.548  1134.172     0.150
   121.548  1226.172     0.150
   121.548  1822.172     0.150
   121.880  1135.371     0.150
   121.880  1823.172     0.150
   121.880  2214.172     0.150
   122.202  1137.172     0.150
   122.202  1137.871     0.150
   122.202  1227.871     0.150
   122.202  1560.172     0.150
   122.202  1826.172     0.150
   122.370  1136.172     0.150
   122.370  1545.172     0.150
   122.686  1135.371     0.150
   122.686  1231.172     0.150
   122.808   926.172     0.150
   122.808  1138.172     0.150
   122.808  1564.172     0.150
   122.975   930.172     0.150
   122.975  1137.000     0.150
   122.975  1571.621     0.150
   122.975  1772.172     0.150
   123.635  1138.172     0.150
   123.635  1138.570     0.150
   123.635  1240.172     0.150
   123.635  1842.172     0.150
   123.798   929.172     0.150
   123.798  1242.172     0.150
   123.798  1563.172     0.150
   123.798  1842.172     0.150
   124.268  1138.172     0.150
   124.618  1142.672     0.150
   124.618  1246.973     0.150
   125.155  1141.172     0.150
   125.307  1142.172     0.150
   125.307  1142.371     0.150
   125.307  1571.070     0.150
   125.456  1145.172     0.150
   125.456  1145.570     0.150
   127.054  1147.172     0.150
   127.054  1261.172     0.150
   127.129  1144.773     0.150
   127.129  1152.473     0.150
   127.129  1275.172     0.150
   127.588   949.371     0.150
   127.588  1266.672     0.150
   127.588  2299.172     0.150
   127.877  1147.172     0.150
   128.604  1145.172     0.150
   129.043  1149.172     0.150
   129.043  1274.172     0.150
   129.103  1152.172     0.150
   129.084  1147.172     0.150
   129.084  1158.273     0.150
   129.435  1148.672     0.150
   129.293  1150.172     0.150
   129.695  1144.773     0.150
   129.695  1157.672     0.150
   129.643  1151.172     0.150
   129.643  1572.172     0.150
   129.643  1898.172     0.150
   129.614  1152.172     0.150
   129.794  1148.973     0.150
   130.089  1152.172     0.150
   130.089  1283.371     0.150
   130.458  1151.172     0.150
   130.681  1153.461     0.150
   130.681  1287.621     0.150
   130.710  1152.773     0.150
   130.710  1359.172     0.150
   131.270  1156.672     0.150
   131.125  1152.172     0.150
   131.435  1153.672     0.150
   132.530  1151.070     0.150
   132.530  1157.973     0.150
   132.530  1302.570     0.150
   132.530  1366.273     0.150
   132.646  1157.672     0.150
   132.646  1299.172     0.150
   132.646  1577.172     0.150
   132.646  2360.672     0.150
   133.060  1155.672     0.150
   133.060  1296.172     0.150
   133.069  1157.613     0.150
   133.069  1305.434     0.150
   133.069  1370.820     0.150
   133.069  1584.172     0.150
   133.069  1716.672     0.150
   133.211  1158.371     0.150
   134.123  1159.672     0.150
   134.234  1160.172     0.150
   134.639  1160.672     0.150
   134.639  1312.172     0.150
   134.639  1374.172     0.150
   135.410  1161.070     0.150
   136.463  1163.973     0.150
   136.463  1330.172     0.150
   136.563  1318.871     0.150
   139.303  1170.172     0.150
   139.303  1342.172     0.150
   140.225  1167.473     0.150
   140.139  1163.172     0.150
   140.268  1164.070     0.150
   140.268  1349.082     0.150
   140.260  1173.172     0.150
   142.413  1172.672     0.150
   142.750  1169.172     0.150
   143.285  1178.172     0.150
   143.350  1175.172     0.150
   143.678  1175.172     0.150
   143.585  1173.172     0.150
   144.238  1175.473     0.150
   144.238  1372.172     0.150
   144.406  1176.172     0.150
   144.453  1176.172     0.150
   145.207  1178.172     0.150
   145.333  1177.172     0.150
   145.569  1175.172     0.150
   145.912  1178.570     0.150
   145.912  1384.172     0.150
   145.912  1388.172     0.150
   145.912  1794.172     0.150
   145.912  1934.172     0.150
   145.912  2145.172     0.150
   145.912  2520.172     0.150
   146.707  1181.172     0.150
   147.487  1184.172     0.150
   148.645  1188.973     0.150
   149.026  1186.371     0.150
   149.599  1193.172     0.150
   149.870  1190.570     0.150
   150.361  1189.172     0.150
   150.772  1189.570     0.150
   150.815  1190.672     0.150
   152.932  1192.172     0.150
   152.932  1419.172     0.150
   154.567  1211.172     0.150
     0.180     4.766     0.150
     0.180     7.806     0.150
     0.250     6.155     0.150
     0.250     9.625     0.150
     1.452    25.965     0.150
     1.452    43.745     0.150
     1.512    27.525     0.150
     1.512    47.375     0.150
     1.972    34.226     0.150
     1.972    58.325     0.150
     2.110    36.325     0.150
     2.110    62.355     0.150
     2.358    39.755     0.150
     2.358    68.686     0.150
     2.425    42.755     0.150
     2.425    70.355     0.150
     2.492    42.105     0.150
     2.492    42.325     0.150
     2.492    71.865     0.150
     2.499    41.625     0.150
     2.499    42.025     0.150
     2.499    42.235     0.150
     2.499    72.545     0.150
     2.499    73.726     0.150
     2.580    41.825     0.150
     2.665    43.615     0.150
     2.665    75.875     0.150
     2.759    45.556     0.150
     2.759    78.615     0.150
     2.878    47.766     0.150
     2.878    81.925     0.150
     2.903    47.995     0.150
     2.903    82.955     0.150
     3.215    51.705     0.150
     3.215    89.835     0.150
     3.224    52.135     0.150
     3.224    91.615     0.150
     3.265    51.415     0.150
     4.010    63.825     0.150
     4.010   109.436     0.150
     4.063    64.235     0.150
     4.192    65.806     0.150
     4.192   112.646     0.150
     4.429    68.635     0.150
     4.429   125.195     0.150
     4.467    70.285     0.150
     5.330    83.205     0.150
     5.510    82.825     0.150
     5.510   152.665     0.150
     7.657   112.695     0.150
     7.657   202.075     0.150
     7.810   117.396     0.150
     7.810   208.115     0.150
     8.574   131.465     0.150
     9.696   146.575     0.150
    10.180   149.825     0.150
    10.428   156.075     0.150
    12.726   186.565     0.150
    12.726   181.613     0.150
    12.726   402.521     0.150
    13.485   194.226     0.150
    13.538   197.035     0.150
    13.538   197.425     0.150
    13.550   197.855     0.150
    13.706   200.795     0.150
    13.874   203.235     0.150
    14.162   205.715     0.150
    14.216   207.766     0.150
    14.235   205.655     0.150
    14.247   208.896     0.150
    14.284   208.545     0.150
    14.623   212.995     0.150
    14.923   216.985     0.150
    15.639   224.115     0.150
    16.316   236.695     0.150
    17.088   245.255     0.150
    17.128   244.476     0.150
    17.220   247.155     0.150
    17.269   247.175     0.150
    17.518   252.205     0.150
    17.723   245.965     0.150
    18.076   254.835     0.150
    18.073   254.206     0.150
    18.073   461.032     0.150
    18.193   256.995     0.150
    18.228   257.615     0.150
    18.439   255.735     0.150
    18.463   259.325     0.150
    18.449   261.675     0.150
    18.774   261.925     0.150
    19.876   271.175     0.150
    19.908   271.125     0.150
    20.388   277.165     0.150
    20.896   281.855     0.150
    20.900   282.056     0.150
    21.020   287.605     0.150
    21.359   289.075     0.150
    21.754   291.795     0.150
    21.962   293.476     0.150
    22.157   298.726     0.150
    22.173   296.195     0.150
    22.351   300.115     0.150
    22.388   297.925     0.150
    22.714   302.795     0.150
    22.765   301.535     0.150
    22.910   306.745     0.150
    23.008   307.835     0.150
    23.121   308.545     0.150
    23.237   306.605     0.150
    23.238   308.535     0.150
    23.335   313.355     0.150
    23.561   314.375     0.150
    23.579   312.575     0.150
    23.844   315.025     0.150
    23.904   315.436     0.150
    23.929   316.955     0.150
    23.952   315.655     0.150
    24.082   317.226     0.150
    24.082   317.255     0.150
    24.117   316.535     0.150
    24.387   318.135     0.150
    24.528   321.025     0.150
    24.675   324.306     0.150
    24.706   324.525     0.150
    25.082   325.056     0.150
    25.629   332.125     0.150
    25.813   334.726     0.150
    26.595   339.155     0.150
    26.593   342.095     0.150
    26.670   342.200     0.150
    26.670   613.065     0.150
    26.810   344.005     0.150
    26.941   343.485     0.150
    26.941   343.125     0.150
    27.059   345.495     0.150
    27.041   347.695     0.150
    27.293   347.945     0.150
    27.363   347.885     0.150
    27.510   346.665     0.150
    27.522   349.255     0.150
    27.677   351.186     0.150
    27.841   351.425     0.150
    27.957   353.135     0.150
    28.226   356.556     0.150
    28.300   356.885     0.150
    28.412   361.825     0.150
    28.646   357.525     0.150
    29.043   363.885     0.150
    29.051   362.545     0.150
    29.136   366.885     0.150
    29.150   363.806     0.150
    29.763   370.396     0.150
    29.785   369.795     0.150
    29.913   370.545     0.150
    30.119   372.375     0.150
    30.286   373.955     0.150
    30.395   372.995     0.150
    30.408   374.845     0.150
    30.474   378.005     0.150
    30.496   377.235     0.150
    30.552   375.825     0.150
    31.203   382.125     0.150
    31.351   384.075     0.150
    31.388   382.275     0.150
    31.775   386.065     0.150
    32.010   391.766     0.150
    32.307   390.936     0.150
    32.357   390.485     0.150
    32.509   391.976     0.150
    32.702   395.705     0.150
    32.722   398.075     0.150
    32.827   393.700     0.150
    32.897   395.965     0.150
    33.360   398.226     0.150
    33.360   715.360     0.150
    33.913   406.495     0.150
    33.971   407.095     0.150
    34.146   408.565     0.150
    34.282   409.125     0.150
    34.514   411.445     0.150
    34.538   411.556     0.150
    34.661   412.646     0.150
    34.708   411.925     0.150
    34.715   412.385     0.150
    34.792   413.485     0.150
    35.041   415.855     0.150
    35.777   421.155     0.150
    35.898   421.755     0.150
    36.592   429.255     0.150
    36.884   430.806     0.150
    36.830   432.341     0.150
    37.697   436.226     0.150
    43.282   484.075     0.150
    43.579   491.825     0.150
    45.595   500.525     0.150
    45.595   901.526     0.150
    45.669   504.345     0.150
    46.590   508.226     0.150
    46.590   912.711     0.150
    49.793   538.186     0.150
    51.488   546.815     0.150
    54.671   572.105     0.150
    55.502   576.425     0.150
    56.076   582.425     0.150
    56.135   582.835     0.150
    56.235   582.575     0.150
    56.295   582.955     0.150
    56.304   582.925     0.150
    56.378   585.385     0.150
    56.527   585.516     0.150
    57.110   588.373     0.150
    57.304   590.025     0.150
    57.336   590.455     0.150
    57.342   590.226     0.150
    57.511   590.925     0.150
    57.785   592.245     0.150
    58.885   600.025     0.150
    59.773   606.625     0.150
    59.837   607.095     0.150
    60.216   608.825     0.150
    60.734   614.516     0.150
    63.640   634.755     0.150
    65.580   645.151     0.150
    65.580   647.693     0.150
    65.580     4.890     0.150
    65.580   677.591     0.150
    67.341   658.365     0.150
    68.539   667.468     0.150
    68.539     4.580     0.150
    71.623   682.025     0.150
    74.535  1273.705     0.150
    74.703   702.354     0.150
    75.681   707.726     0.150
    77.562   720.195     0.150
    77.562   725.965     0.150
    77.562  1307.125     0.150
    77.562  1312.575     0.150
    77.562  1355.795     0.150
    77.562  1608.556     0.150
    77.562  1612.266     0.150
    78.222   723.425     0.150
    78.315   724.025     0.150
    78.669   725.925     0.150
    80.300  1339.625     0.150
    80.487   735.455     0.150
    80.639   734.726     0.150
    80.880   737.785     0.150
    81.089  1352.025     0.150
    81.089  1662.025     0.150
    81.208   737.325     0.150
    81.280   739.325     0.150
    81.318   739.525     0.150
    81.448   740.525     0.150
    81.891   742.925     0.150
    81.930   741.025     0.150
    82.258   743.615     0.150
    82.419   744.715     0.150
    82.746   746.025     0.150
    82.746  1368.325     0.150
    82.746  1415.425     0.150
    82.797   749.335     0.150
    82.797     3.610     0.150
    82.937   748.105     0.150
    82.937  1364.205     0.150
    83.195  1374.825     0.150
    83.195  1700.425     0.150
    83.497   748.695     0.150
    83.574   749.425     0.150
    83.650   751.995     0.150
    83.678   752.896     0.150
    83.678     4.699     0.150
    83.683   750.295     0.150
    83.722   751.445     0.150
    83.722     5.220     0.150
    83.713   752.585     0.150
    83.897   754.686     0.150
    83.932   752.039     0.150
    83.932  1382.375     0.150
    84.043   753.625     0.150
    84.043     4.250     0.150
    84.113   756.105     0.150
    84.318   755.135     0.150
    84.476   753.525     0.150
    84.505   755.745     0.150
    84.525   756.405     0.150
    84.602   755.825     0.150
    84.630   755.306     0.150
    84.827   754.226     0.150
    84.827     9.100     0.150
    84.827  1375.925     0.150
    84.828   757.726     0.150
    84.857   755.726     0.150
    84.934   757.785     0.150
    84.982   758.605     0.150
    85.049   758.726     0.150
    85.049     9.109     0.150
    85.049  1386.815     0.150
    85.049  1716.815     0.150
    85.046   758.726     0.150
    85.067   759.215     0.150
    85.163   758.425     0.150
    85.163   758.726     0.150
    85.163  1390.099     0.150
    85.152   758.056     0.150
    85.324   759.925     0.150
    85.388   758.425     0.150
    85.509   761.085     0.150
    85.607   758.925     0.150
    85.625   759.425     0.150
    85.653   759.338     0.150
    85.653  1391.093     0.150
    85.653   762.075     0.150
    85.798   761.525     0.150
    85.831   761.226     0.150
    85.918   763.025     0.150
    85.969   761.025     0.150
    86.000   760.825     0.150
    86.010   761.125     0.150
    86.033   762.726     0.150
    86.042   763.025     0.150
    86.048   761.025     0.150
    86.062   764.646     0.150
    86.116   761.525     0.150
    86.159   764.085     0.150
    86.270   763.485     0.150
    86.312   766.625     0.150
    86.362   763.025     0.150
    86.433   762.625     0.150
    86.495   763.325     0.150
    86.515   765.025     0.150
    86.653   766.766     0.150
    86.675   763.625     0.150
    86.674   763.825     0.150
    86.752   766.646     0.150
    86.764   767.245     0.150
    86.789   767.845     0.150
    86.798   771.325     0.150
    86.813   768.325     0.150
    86.823   764.825     0.150
    86.826   768.625     0.150
    87.170   771.025     0.150
    87.788   773.025     0.150
    87.962   772.745     0.150
    87.998   771.525     0.150
    88.098   770.226     0.150
    88.188   771.125     0.150
    88.188   974.726     0.150
    88.188  1404.825     0.150
    88.188  1417.925     0.150
    88.243   771.125     0.150
    88.485   772.025     0.150
    88.485   772.125     0.150
    88.503   772.025     0.150
    88.549   777.825     0.150
    88.590   778.025     0.150
    88.643   776.025     0.150
    88.701   777.825     0.150
    89.182   777.625     0.150
    89.332   778.425     0.150
    89.674   778.325     0.150
    89.800   782.525     0.150
    89.911   780.525     0.150
    90.058   779.625     0.150
    90.060   779.726     0.150
    90.087   996.825     0.150
    90.087  1443.825     0.150
    90.087  1791.825     0.150
    90.296   782.925     0.150
    90.296   995.825     0.150
    90.296  1436.825     0.150
    90.296  1786.625     0.150
    90.460   781.325     0.150
    90.554   782.625     0.150
    90.554  1447.825     0.150
    90.621   785.325     0.150
    90.750   785.925     0.150
    90.750  1002.925     0.150
    90.964   784.550     0.150
    90.964  1000.601     0.150
    91.008   787.525     0.150
    91.283   787.825     0.150
    91.283  1001.825     0.150
    91.283  1449.825     0.150
    91.283  1514.825     0.150
    91.283  1807.825     0.150
    91.288   787.226     0.150
    91.919   792.726     0.150
    91.919  1010.325     0.150
    92.128   790.525     0.150
    92.128  1010.675     0.150
    92.128  1419.290     0.150
    92.128  1829.101     0.150
    92.588   793.726     0.150
    92.588  1426.825     0.150
    92.588  1523.825     0.150
    92.588  1816.825     0.150
    92.588  2247.825     0.150
    92.765   794.025     0.150
    92.941   794.925     0.150
    92.905   794.545     0.150
    93.022   795.625     0.150
    93.253   795.595     0.150
    93.645   794.825     0.150
    93.645  1023.825     0.150
    93.645  1838.825     0.150
    94.022   803.125     0.150
    94.022  1029.025     0.150
    94.022  1440.925     0.150
    94.022  1474.226     0.150
    94.022  1555.625     0.150
    94.022  1854.325     0.150
    94.312   802.525     0.150
    94.312  1430.425     0.150
    94.333   801.726     0.150
    94.410   804.625     0.150
    94.410     4.101     0.150
    94.813   804.025     0.150
    94.813  1034.925     0.150
    94.813  1851.825     0.150
    95.032   806.825     0.150
    95.032  1036.825     0.150
    95.032  1443.825     0.150
    96.693  1048.226     0.150
    96.693  1435.525     0.150
    96.693  1479.025     0.150
    99.267   823.125     0.150
    99.267  1462.726     0.150
    99.267  1596.825     0.150
    99.341   824.125     0.150
    99.341  1063.226     0.150
    99.341  1604.625     0.150
    99.694  1073.325     0.150
    99.694  1465.825     0.150
    99.694  1608.825     0.150
    99.694  1941.825     0.150
   100.306   826.125     0.150
   101.526  1086.825     0.150
   101.526  1462.825     0.150
   101.526  1946.825     0.150
   103.468  1100.825     0.150
   106.077  1118.525     0.150
   106.794  1123.726     0.150
   119.085  1129.825     0.150
   119.085  1213.825     0.150
   119.085  1345.825     0.150
   119.085  1556.825     0.150
   119.085  1621.226     0.150
   119.085  2186.825     0.150
   120.287  1217.825     0.150
   120.899  1134.226     0.150
   120.899  1563.825     0.150
   122.222  1136.825     0.150
   122.222  1562.825     0.150
   122.283  1140.125     0.150
   122.283  1238.825     0.150
   122.594  1138.125     0.150
   123.679  1141.325     0.150
   124.789  1141.715     0.150
   128.223  1147.825     0.150
   128.468  1149.584     0.150
   128.944  1151.272     0.150
   129.162  1147.025     0.150
   129.171  1150.479     0.150
   129.174  1149.925     0.150
   129.597  1152.226     0.150
   129.597  1284.825     0.150
   129.597  2326.825     0.150
   129.716  1150.825     0.150
   132.605  1157.325     0.150
   132.605  1300.825     0.150
   132.605  1369.325     0.150
   132.938  1158.325     0.150
   133.666  1161.825     0.150
   133.666  1315.325     0.150
   133.666  1374.825     0.150
   133.666  2379.825     0.150
   133.805  1160.125     0.150
   133.805  1159.825     0.150
   134.105  1160.325     0.150
   134.518  1160.226     0.150
   134.784  1165.125     0.150
   134.836  1160.625     0.150
   135.289  1163.726     0.150
   135.372  1163.025     0.150
   135.852  1160.525     0.150
   136.132  1164.825     0.150
   143.940  1175.726     0.150
   144.213  1176.825     0.150
   144.855  1179.726     0.150
   145.353  1179.726     0.150
   145.465  1179.625     0.150
   145.794  1180.825     0.150
   148.824  1187.825     0.150
   149.356  1188.825     0.150
   150.167  1195.825     0.150
   152.853  1190.825     0.150
     0.308     8.846     0.150
     0.308    14.676     0.150
     0.729    14.246     0.150
     0.729    23.215     0.150
     0.979    17.824     0.150
     0.979    29.555     0.150
     1.481    25.955     0.150
     2.105    34.395     0.150
     2.234    36.086     0.150
     2.267    37.025     0.150
     2.279    38.324     0.150
     2.338    37.645     0.150
     2.435    39.016     0.150
     2.435    68.926     0.150
     2.418    39.785     0.150
     2.418    40.086     0.150
     2.538    40.586     0.150
     2.495    40.135     0.150
     2.495    69.795     0.150
     2.495    72.496     0.150
     2.521    43.564     0.150
     2.564    40.984     0.150
     2.572    45.096     0.150
     2.649    42.234     0.150
     2.668    40.734     0.150
     2.675    42.135     0.150
     2.875    44.395     0.150
     3.439    53.455     0.150
     3.612    55.324     0.150
     3.612    99.975     0.150
     3.621    57.225     0.150
     3.714    59.055     0.150
     4.010    63.205     0.150
     4.471    68.105     0.150
     4.851    74.096     0.150
     4.851   130.564     0.150
     5.852    86.086     0.150
     8.076   118.996     0.150
    10.881   160.305     0.150
    11.372   166.746     0.150
    11.609   170.166     0.150
    11.675   170.465     0.150
    11.817   172.484     0.150
    12.367   178.086     0.150
    12.367   177.410     0.150
    13.180   187.785     0.150
    13.340   188.785     0.150
    15.284   216.904     0.150
    16.611   233.785     0.150
    17.479   240.734     0.150
    17.638   246.686     0.150
    17.697   247.426     0.150
    18.079   251.965     0.150
    18.302   251.545     0.150
    18.402   255.096     0.150
    18.912   258.625     0.150
    18.912   271.295     0.150
    19.848   269.686     0.150
    19.877   268.756     0.150
    19.877   281.256     0.150
    20.225   274.455     0.150
    20.345   276.984     0.150
    20.601   280.055     0.150
    20.601   292.734     0.150
    20.834   279.865     0.150
    20.852   278.564     0.150
    20.852   294.605     0.150
    20.880   281.395     0.150
    21.184   284.395     0.150
    21.490   286.234     0.150
    21.631   289.564     0.150
    21.697   291.385     0.150
    21.844   291.686     0.150
    21.907   289.215     0.150
    21.971   293.365     0.150
    22.017   295.705     0.150
    22.218   293.574     0.150
    22.260   293.395     0.150
    22.331   295.346     0.150
    22.437   299.984     0.150
    22.488   299.266     0.150
    22.672   297.936     0.150
    22.898   301.795     0.150
    22.985   300.895     0.150
    23.119   302.756     0.150
    23.079   305.586     0.150
    23.105   305.385     0.150
    23.514   309.984     0.150
    23.605   308.586     0.150
    23.663   311.984     0.150
    23.981   312.096     0.150
    24.043   315.455     0.150
    24.170   314.746     0.150
    24.173   312.965     0.150
    24.174   313.285     0.150
    24.211   316.654     0.150
    24.649   319.945     0.150
    25.010   320.885     0.150
    25.115   324.756     0.150
    25.224   325.055     0.150
    25.295   326.176     0.150
    25.349   327.404     0.150
    25.402   327.404     0.150
    25.569   328.055     0.150
    25.570   329.475     0.150
    25.945   331.545     0.150
    26.082   332.926     0.150
    26.149   334.715     0.150
    26.225   334.984     0.150
    26.347   336.574     0.150
    26.573   336.336     0.150
    26.573     9.799     0.150
    26.573   540.135     0.150
    26.618   335.836     0.150
    26.641   338.125     0.150
    26.641   541.074     0.150
    26.830   339.885     0.150
    26.948   339.355     0.150
    26.983   340.455     0.150
    27.027   338.805     0.150
    27.067   341.926     0.150
    27.248   344.635     0.150
    27.469   343.105     0.150
    27.466   344.705     0.150
    27.587   346.295     0.150
    27.787   349.305     0.150
    28.064   350.686     0.150
    28.644   354.074     0.150
    28.751   356.836     0.150
    28.819   354.686     0.150
    29.263   362.426     0.150
    29.849   366.916     0.150
    30.035   367.885     0.150
    30.399   369.426     0.150
    30.835   375.154     0.150
    31.489   376.855     0.150
    32.149   386.285     0.150
    32.510   387.535     0.150
    32.510     9.859     0.150
    32.600   390.404     0.150
    32.718   390.166     0.150
    32.776    10.051     0.150
    32.776    15.100     0.150
    33.067   392.895     0.150
    33.124   392.160     0.150
    33.124    10.375     0.150
    33.113   394.686     0.150
    33.139   396.275     0.150
    33.286   394.635     0.150
    33.723   401.904     0.150
    33.781   401.016     0.150
    33.809   401.586     0.150
    34.124   404.984     0.150
    34.207   406.064     0.150
    34.288   405.984     0.150
    34.573   405.555     0.150
    34.656   407.395     0.150
    34.693   408.885     0.150
    34.766   410.035     0.150
    34.847   410.285     0.150
    35.034   412.496     0.150
    35.206   413.855     0.150
    35.356   413.904     0.150
    35.483   415.324     0.150
    35.522   415.404     0.150
    36.229   422.125     0.150
    36.234   422.186     0.150
    37.414   429.654     0.150
    44.047   489.285     0.150
    45.529   496.135     0.150
    45.529     8.000     0.150
    46.258   502.029     0.150
    46.258    10.250     0.150
    46.258   598.029     0.150
    46.324   503.475     0.150
    46.520   507.445     0.150
    50.254   536.375     0.150
    50.254     8.850     0.150
    51.347   542.086     0.150
    55.139   569.805     0.150
    55.639   575.686     0.150
    55.811   576.086     0.150
    55.811     9.600     0.150
    55.877   576.186     0.150
    56.709   581.273     0.150
    56.709     8.262     0.150
    56.896   583.555     0.150
    56.896     9.811     0.150
    56.909   583.975     0.150
    56.920   583.445     0.150
    56.920     9.900     0.150
    57.110   584.385     0.150
    59.419  1090.984     0.150
    59.419  1325.285     0.150
    59.814   602.625     0.150
    61.214   613.623     0.150
    61.214     7.898     0.150
    62.579  1130.885     0.150
    65.849   640.996     0.150
    75.740   702.365     0.150
    76.961   710.734     0.150
    78.249   717.086     0.150
    78.337   717.686     0.150
    78.696   719.586     0.150
    79.867   725.756     0.150
    80.069   727.705     0.150
    80.069     9.869     0.150
    80.411   729.885     0.150
    80.470   729.186     0.150
    80.779   732.285     0.150
    80.779    10.100     0.150
    80.780   730.846     0.150
    80.883   732.484     0.150
    80.883     9.900     0.150
    80.997   731.975     0.150
    81.068   734.285     0.150
    81.068     9.600     0.150
    81.222   734.086     0.150
    81.222     9.799     0.150
    81.357   734.186     0.150
    81.406   733.984     0.150
    81.417   735.385     0.150
    81.417     9.900     0.150
    81.439   734.984     0.150
    81.439     9.602     0.150
    81.600   736.785     0.150
    81.600     9.900     0.150
    82.023   737.445     0.150
    82.047   737.984     0.150
    82.122   737.814     0.150
    82.184   738.984     0.150
    82.392   739.805     0.150
    82.392    10.641     0.150
    82.579   740.734     0.150
    82.579    10.641     0.150
    82.739  1361.984     0.150
    83.629   746.984     0.150
    83.646   746.365     0.150
    83.646    10.641     0.150
    83.817   747.795     0.150
    83.873   748.455     0.150
    84.064   748.848     0.150
    84.064     9.426     0.150
    84.064   748.795     0.150
    84.547   751.586     0.150
    84.649   752.195     0.150
    84.649    10.051     0.150
    85.000   753.385     0.150
    85.032   753.984     0.150
    85.100   753.984     0.150
    85.100   753.086     0.150
    85.100    10.000     0.150
    85.221   755.154     0.150
    85.297   755.805     0.150
    85.265   753.885     0.150
    85.265    10.201     0.150
    85.265    14.600     0.150
    85.462   756.516     0.150
    85.462    10.049     0.150
    85.489   756.686     0.150
    85.505   755.674     0.150
    85.654   757.455     0.150
    85.654     9.461     0.150
    85.689   757.186     0.150
    85.716   757.395     0.150
    85.716     9.961     0.150
    85.941   758.035     0.150
    86.047   758.795     0.150
    86.046   758.686     0.150
    86.067   759.285     0.150
    86.079   758.984     0.150
    86.169   760.346     0.150
    86.287   760.324     0.150
    86.287    10.342     0.150
    86.334   760.596     0.150
    86.334     9.750     0.150
    86.390   761.025     0.150
    86.390    10.340     0.150
    86.396   760.385     0.150
    86.498   760.484     0.150
    86.575   761.484     0.150
    86.737   761.285     0.150
    86.768   762.615     0.150
    86.790   761.936     0.150
    86.790    10.369     0.150
    86.804   762.205     0.150
    86.881   762.484     0.150
    87.103   763.086     0.150
    87.126   765.695     0.150
    87.152   763.785     0.150
    87.245   764.885     0.150
    88.080   769.086     0.150
    88.144   768.385     0.150
    88.323   769.586     0.150
    88.543   770.385     0.150
    88.961   773.225     0.150
    89.056   771.885     0.150
    89.056  1416.785     0.150
    89.417   775.484     0.150
    89.745   776.385     0.150
    90.319   779.285     0.150
    90.560   780.285     0.150
    90.866   779.186     0.150
    90.866    10.199     0.150
    91.631   784.686     0.150
    91.940   786.285     0.150
    92.062   785.785     0.150
    92.062    11.000     0.150
    93.260   792.586     0.150
    93.380   793.385     0.150
    93.546   793.686     0.150
    93.546  1452.484     0.150
    93.546  1528.484     0.150
    93.610   794.484     0.150
    94.428   796.385     0.150
    94.808   799.484     0.150
    99.249  1601.484     0.150
   103.247   836.984     0.150
   110.404  1109.785     0.150
   113.542  2122.984     0.150
   115.720  1119.633     0.150
   116.203  1119.785     0.150
   116.203  1129.984     0.150
   116.203  1183.109     0.150
   117.067  1116.785     0.150
   118.769  1124.285     0.150
   118.769  1207.785     0.150
   118.769  2180.785     0.150
   121.793  1130.785     0.150
   122.159  1130.285     0.150
   122.365  1133.686     0.150
   122.365  1133.336     0.150
   122.365  1143.186     0.150
   124.618  1137.324     0.150
   124.618  1147.895     0.150
   128.138  1144.395     0.150
   128.138  1155.068     0.150
   128.549  1144.836     0.150
   128.549  1154.535     0.150
   128.778  1146.385     0.150
   128.870  1146.086     0.150
   128.870  1156.535     0.150
   128.873  1146.086     0.150
   132.176  1147.785     0.150
   139.683  1166.785     0.150
   139.683  1176.484     0.150
   141.874  1163.654     0.150
   142.558  1171.984     0.150
   142.656  1169.385     0.150
   143.741  1171.785     0.150
   145.260  1175.555     0.150
   145.260  1185.795     0.150
   145.260  1190.516     0.150
   145.369  1176.186     0.150
   145.535  1176.285     0.150
   145.535  1186.785     0.150
     0.168     7.523     0.150
     0.168    11.354     0.150
     0.556    11.713     0.150
     0.977    18.742     0.150
     0.977    32.393     0.150
     1.163    20.662     0.150
     1.163    34.104     0.150
     1.411    44.143     0.150
     2.031    34.014     0.150
     2.031    59.344     0.150
     2.252    63.273     0.150
     2.284    38.963     0.150
     2.284    63.533     0.150
     2.371    39.572     0.150
     2.371    67.773     0.150
     2.451    40.752     0.150
     2.451    71.273     0.150
     2.451    70.773     0.150
     2.479    40.902     0.150
     2.479    69.152     0.150
     2.511    41.053     0.150
     2.511    70.562     0.150
     2.590    41.492     0.150
     2.590    72.514     0.150
     3.064    48.492     0.150
     3.064    85.812     0.150
     3.077    47.184     0.150
     3.077    81.242     0.150
     3.308    51.684     0.150
     3.308    89.732     0.150
     3.432    93.082     0.150
     4.154    62.213     0.150
     4.287    65.723     0.150
     4.287   113.434     0.150
     4.469    67.232     0.150
     4.469   119.662     0.150
     5.030    76.582     0.150
     5.030   130.973     0.150
     5.030    75.783     0.150
     5.198   136.924     0.150
     5.198   161.293     0.150
     5.198    75.588     0.150
     5.198    78.123     0.150
     5.513    83.613     0.150
     5.513   149.223     0.150
     5.683    85.973     0.150
     5.683   148.273     0.150
     7.894   116.732     0.150
     7.894   203.094     0.150
     8.259   121.402     0.150
     8.259   217.613     0.150
     8.862   126.482     0.150
     8.862   228.312     0.150
    10.212   148.344     0.150
    10.236   149.934     0.150
    10.529   151.643     0.150
    10.871   157.963     0.150
    11.591   168.760     0.150
    11.591   371.760     0.150
    11.591   165.094     0.150
    11.799   167.924     0.150
    11.799   166.686     0.150
    12.453   179.312     0.150
    12.453   397.391     0.150
    12.951   185.793     0.150
    12.951   186.363     0.150
    13.219   188.082     0.150
    13.330   187.703     0.150
    13.330   189.131     0.150
    14.845   211.184     0.150
    15.140   214.373     0.150
    15.370   214.633     0.150
    15.834   225.943     0.150
    15.874   223.145     0.150
    15.908   226.514     0.150
    15.908   229.223     0.150
    15.970   227.082     0.150
    16.286   230.039     0.150
    16.489   234.943     0.150
    16.566   237.863     0.150
    16.592   235.543     0.150
    16.669   235.188     0.150
    16.877   239.693     0.150
    16.979   239.434     0.150
    16.979   239.973     0.150
    17.098   242.844     0.150
    17.140   240.990     0.150
    17.129   242.514     0.150
    17.129   242.252     0.150
    17.187   237.473     0.150
    17.298   244.014     0.150
    17.347   243.787     0.150
    17.350   240.973     0.150
    17.350   242.293     0.150
    17.485   245.412     0.150
    17.478   246.434     0.150
    17.511   241.604     0.150
    17.501   246.732     0.150
    17.509   246.363     0.150
    17.509   246.523     0.150
    17.515   247.322     0.150
    17.563   246.732     0.150
    17.596   247.982     0.150
    17.645   244.033     0.150
    17.648   248.854     0.150
    17.666   249.184     0.150
    17.666   249.543     0.150
    17.767   248.492     0.150
    17.767   248.701     0.150
    17.808   249.787     0.150
    17.808   251.652     0.150
    17.808   253.082     0.150
    17.853   249.938     0.150
    18.072   253.113     0.150
    18.289   251.303     0.150
    18.342   256.053     0.150
    18.425   256.389     0.150
    18.495   256.383     0.150
    18.495   255.713     0.150
    18.495   256.713     0.150
    18.495   463.188     0.150
    18.495   588.963     0.150
    18.495   256.125     0.150
    18.802   260.709     0.150
    18.891   258.684     0.150
    18.921   261.498     0.150
    18.984   263.293     0.150
    19.389   266.988     0.150
    19.694   270.348     0.150
    19.760   270.613     0.150
    19.760   489.514     0.150
    19.812   268.723     0.150
    19.820   271.863     0.150
    19.856   272.037     0.150
    20.103   273.213     0.150
    20.177   275.438     0.150
    20.196   272.793     0.150
    20.244   276.463     0.150
    20.488   279.213     0.150
    20.501   277.252     0.150
    20.507   279.275     0.150
    20.544   279.912     0.150
    20.720   282.053     0.150
    20.720   281.906     0.150
    20.802   279.902     0.150
    20.804   278.203     0.150
    20.828   283.287     0.150
    20.834   282.658     0.150
    20.960   282.393     0.150
    20.968   284.334     0.150
    20.984   284.500     0.150
    21.027   283.062     0.150
    21.049   284.850     0.150
    21.113   285.637     0.150
    21.191   284.902     0.150
    21.191   285.613     0.150
    21.237   287.412     0.150
    21.286   287.436     0.150
    21.318   285.453     0.150
    21.324   287.953     0.150
    21.335   288.072     0.150
    21.357   285.633     0.150
    21.469   288.354     0.150
    21.469   290.646     0.150
    21.481   289.793     0.150
    21.517   286.562     0.150
    21.531   286.713     0.150
    21.538   290.488     0.150
    21.594   287.633     0.150
    21.589   289.604     0.150
    21.590   291.062     0.150
    21.657   291.412     0.150
    21.746   291.867     0.150
    21.844   293.713     0.150
    21.844   525.520     0.150
    21.844   709.014     0.150
    21.849   293.430     0.150
    21.863   289.043     0.150
    21.863   289.322     0.150
    21.980   294.803     0.150
    22.037   295.162     0.150
    22.049   291.713     0.150
    22.051   291.934     0.150
    22.138   293.053     0.150
    22.154   298.152     0.150
    22.199   297.113     0.150
    22.231   297.508     0.150
    22.244   293.803     0.150
    22.244   293.941     0.150
    22.269   297.662     0.150
    22.271   297.113     0.150
    22.271   540.912     0.150
    22.281   297.123     0.150
    22.420   298.062     0.150
    22.424   299.312     0.150
    22.447   295.822     0.150
    22.498   299.623     0.150
    22.518   300.123     0.150
    22.572   301.029     0.150
    22.630   301.514     0.150
    22.642   297.992     0.150
    22.645   300.812     0.150
    22.639   301.668     0.150
    22.726   302.861     0.150
    22.761   302.613     0.150
    22.834   303.184     0.150
    22.860   304.270     0.150
    22.903   304.412     0.150
    22.910   304.086     0.150
    22.918   304.412     0.150
    22.975   301.652     0.150
    22.975   303.764     0.150
    22.996   304.957     0.150
    23.035   305.480     0.150
    23.050   305.859     0.150
    23.099   302.844     0.150
    23.094   306.322     0.150
    23.229   309.123     0.150
    23.237   307.523     0.150
    23.247   308.082     0.150
    23.291   308.123     0.150
    23.330   308.461     0.150
    23.384   309.287     0.150
    23.396   308.998     0.150
    23.418   309.492     0.150
    23.475   307.242     0.150
    23.496   309.113     0.150
    23.496   552.412     0.150
    23.523   310.514     0.150
    23.523   747.482     0.150
    23.540   307.213     0.150
    23.540   560.383     0.150
    23.535   310.562     0.150
    23.533   310.281     0.150
    23.568   309.562     0.150
    23.627   310.982     0.150
    23.637   311.271     0.150
    23.779   312.730     0.150
    23.779   313.107     0.150
    23.816   313.621     0.150
    23.873   314.107     0.150
    23.890   311.883     0.150
    23.892   314.045     0.150
    23.898   314.242     0.150
    23.966   313.863     0.150
    24.009   315.738     0.150
    24.075   313.934     0.150
    24.071   315.430     0.150
    24.090   313.203     0.150
    24.135   316.619     0.150
    24.177   317.482     0.150
    24.177   317.166     0.150
    24.177   317.258     0.150
    24.286   314.143     0.150
    24.286   314.613     0.150
    24.315   315.174     0.150
    24.306   318.283     0.150
    24.414   317.273     0.150
    24.461   319.973     0.150
    24.461   319.814     0.150
    24.467   319.848     0.150
    24.484   319.662     0.150
    24.502   317.652     0.150
    24.755   321.473     0.150
    24.754   322.301     0.150
    24.783   322.742     0.150
    24.798   323.008     0.150
    24.856   322.773     0.150
    24.880   323.713     0.150
    24.880   585.613     0.150
    24.914   324.684     0.150
    24.943   324.127     0.150
    24.949   323.988     0.150
    24.973   321.143     0.150
    24.973   321.268     0.150
    24.985   323.453     0.150
    25.105   324.303     0.150
    25.103   325.389     0.150
    25.144   322.152     0.150
    25.144   326.100     0.150
    25.169   325.938     0.150
    25.169   325.764     0.150
    25.220   325.873     0.150
    25.244   327.213     0.150
    25.270   326.662     0.150
    25.310   327.957     0.150
    25.335   326.793     0.150
    25.335   326.412     0.150
    25.335   327.111     0.150
    25.380   328.014     0.150
    25.401   327.562     0.150
    25.451   328.809     0.150
    25.491   328.662     0.150
    25.488   329.207     0.150
    25.499   330.123     0.150
    25.560   329.273     0.150
    25.586   329.812     0.150
    25.602   330.389     0.150
    25.710   331.303     0.150
    25.713   331.562     0.150
    25.730   330.881     0.150
    25.842   331.076     0.150
    25.892   332.643     0.150
    25.895   332.816     0.150
    25.896   332.611     0.150
    26.047   333.514     0.150
    26.054   332.973     0.150
    26.059   334.654     0.150
    26.075   334.963     0.150
    26.099   334.816     0.150
    26.109   334.359     0.150
    26.110   333.488     0.150
    26.155   334.738     0.150
    26.164   333.684     0.150
    26.168   334.963     0.150
    26.188   335.854     0.150
    26.198   335.986     0.150
    26.312   336.342     0.150
    26.325   335.205     0.150
    26.366   334.473     0.150
    26.361   336.863     0.150
    26.361   541.643     0.150
    26.361   609.062     0.150
    26.361   841.482     0.150
    26.370   337.119     0.150
    26.376   337.033     0.150
    26.429   337.264     0.150
    26.437   337.033     0.150
    26.494   338.455     0.150
    26.506   338.814     0.150
    26.546   336.043     0.150
    26.592   340.014     0.150
    26.600   338.537     0.150
    26.626   335.773     0.150
    26.639   339.160     0.150
    26.664   337.633     0.150
    26.664   337.713     0.150
    26.664   614.588     0.150
    26.664   851.438     0.150
    26.676   338.963     0.150
    26.702   339.250     0.150
    26.719   339.703     0.150
    26.767   339.869     0.150
    26.801   340.678     0.150
    26.862   339.463     0.150
    26.855   340.605     0.150
    26.933   341.570     0.150
    26.979   341.902     0.150
    27.002   343.061     0.150
    27.011   340.594     0.150
    27.011   340.797     0.150
    27.020   339.023     0.150
    27.028   342.383     0.150
    27.039   343.561     0.150
    27.041   342.574     0.150
    27.081   341.674     0.150
    27.194   343.863     0.150
    27.206   344.469     0.150
    27.210   343.793     0.150
    27.210   343.969     0.150
    27.282   344.738     0.150
    27.395   345.768     0.150
    27.404   345.662     0.150
    27.420   342.934     0.150
    27.408   347.863     0.150
    27.494   347.400     0.150
    27.508   347.645     0.150
    27.519   349.072     0.150
    27.535   346.514     0.150
    27.561   346.174     0.150
    27.562   347.332     0.150
    27.599   347.162     0.150
    27.627   346.873     0.150
    27.640   348.553     0.150
    27.640   348.691     0.150
    27.660   348.312     0.150
    27.677   349.199     0.150
    27.703   348.670     0.150
    27.707   347.562     0.150
    27.726   347.402     0.150
    27.727   349.387     0.150
    27.780   349.953     0.150
    27.768   350.275     0.150
    27.773   348.553     0.150
    27.848   349.830     0.150
    27.856   349.389     0.150
    27.868   349.674     0.150
    27.890   348.242     0.150
    27.890   545.393     0.150
    27.912   350.770     0.150
    27.944   350.588     0.150
    27.952   350.891     0.150
    28.011   352.000     0.150
    28.075   351.912     0.150
    28.080   350.463     0.150
    28.119   353.008     0.150
    28.163   352.357     0.150
    28.189   352.273     0.150
    28.226   354.229     0.150
    28.232   353.238     0.150
    28.270   354.037     0.150
    28.259   356.752     0.150
    28.259   640.902     0.150
    28.259   353.551     0.150
    28.259   354.133     0.150
    28.327   355.084     0.150
    28.323   354.822     0.150
    28.382   354.648     0.150
    28.440   355.912     0.150
    28.476   355.713     0.150
    28.499   356.332     0.150
    28.511   353.533     0.150
    28.528   356.465     0.150
    28.531   356.742     0.150
    28.552   357.564     0.150
    28.563   357.033     0.150
    28.568   356.934     0.150
    28.580   353.793     0.150
    28.620   356.740     0.150
    28.631   356.213     0.150
    28.714   357.369     0.150
    28.731   358.174     0.150
    28.741   358.123     0.150
    28.774   358.523     0.150
    28.781   355.043     0.150
    28.783   357.812     0.150
    28.804   357.684     0.150
    28.799   359.354     0.150
    28.823   356.902     0.150
    28.823   357.992     0.150
    28.823    10.531     0.150
    28.827   359.156     0.150
    28.834   358.162     0.150
    28.846   358.662     0.150
    28.859   358.223     0.150
    28.859   358.502     0.150
    28.864   359.752     0.150
    28.879   359.338     0.150
    28.893   359.676     0.150
    28.965   360.688     0.150
    29.013   360.363     0.150
    29.013     7.980     0.150
    29.040   360.250     0.150
    29.067   360.186     0.150
    29.078   360.684     0.150
    29.127   360.787     0.150
    29.211   363.062     0.150
    29.239   363.158     0.150
    29.249   361.889     0.150
    29.285   362.037     0.150
    29.408   364.492     0.150
    29.422   363.912     0.150
    29.479   364.424     0.150
    29.495   364.281     0.150
    29.547   363.193     0.150
    29.543   365.436     0.150
    29.607   365.412     0.150
    29.610   364.902     0.150
    29.610   548.082     0.150
    29.626   364.980     0.150
    29.643   366.764     0.150
    29.681   365.912     0.150
    29.687   365.863     0.150
    29.723   366.336     0.150
    29.766   367.457     0.150
    29.779   367.014     0.150
    29.800   365.143     0.150
    29.840   366.703     0.150
    29.884   366.053     0.150
    29.877   367.688     0.150
    29.876   368.758     0.150
    29.892   367.674     0.150
    29.963   368.412     0.150
    29.980   368.953     0.150
    29.980   368.631     0.150
    29.997   369.006     0.150
    30.040   368.654     0.150
    30.039   368.830     0.150
    30.045   370.113     0.150
    30.045   369.424     0.150
    30.045   665.248     0.150
    30.045   957.098     0.150
    30.089   369.768     0.150
    30.108   368.223     0.150
    30.149   369.514     0.150
    30.162   370.402     0.150
    30.162    10.801     0.150
    30.180   368.523     0.150
    30.180   368.773     0.150
    30.184   371.402     0.150
    30.193   370.688     0.150
    30.275   368.543     0.150
    30.271   370.662     0.150
    30.278   371.207     0.150
    30.300   370.963     0.150
    30.312   382.643     0.150
    30.334   369.613     0.150
    30.349   372.584     0.150
    30.421   372.121     0.150
    30.443   372.107     0.150
    30.456   370.508     0.150
    30.472   372.650     0.150
    30.529   370.424     0.150
    30.527   372.977     0.150
    30.597   373.195     0.150
    30.598   375.248     0.150
    30.638   374.514     0.150
    30.656   374.037     0.150
    30.661   374.916     0.150
    30.765   375.164     0.150
    30.778   374.912     0.150
    30.767   375.973     0.150
    30.801   375.238     0.150
    30.856   377.473     0.150
    30.877   375.064     0.150
    30.889   376.938     0.150
    30.915   375.695     0.150
    30.926   375.963     0.150
    30.942   376.473     0.150
    30.973   377.422     0.150
    31.016   376.910     0.150
    31.033   376.482     0.150
    31.040   379.133     0.150
    31.072   377.801     0.150
    31.079   376.963     0.150
    31.079   377.074     0.150
    31.110   377.740     0.150
    31.112   377.688     0.150
    31.220   377.072     0.150
    31.214   379.480     0.150
    31.302   379.488     0.150
    31.304   379.688     0.150
    31.333   379.623     0.150
    31.339   378.822     0.150
    31.341   379.688     0.150
    31.412   380.162     0.150
    31.475   381.588     0.150
    31.498   379.133     0.150
    31.495   380.773     0.150
    31.495   380.721     0.150
    31.508   381.588     0.150
    31.578   382.844     0.150
    31.615   381.713     0.150
    31.615   555.652     0.150
    31.691   382.434     0.150
    31.706   383.912     0.150
    31.719   382.764     0.150
    31.737   383.486     0.150
    31.830   382.943     0.150
    31.830   383.553     0.150
    31.849   384.750     0.150
    31.865   385.488     0.150
    31.919   384.205     0.150
    31.916   386.227     0.150
    31.951   385.283     0.150
    31.983   385.377     0.150
    32.009   385.363     0.150
    32.050   385.938     0.150
    32.159   387.764     0.150
    32.184   387.438     0.150
    32.220   387.697     0.150
    32.223   389.453     0.150
    32.248   386.947     0.150
    32.324   388.662     0.150
    32.346   387.779     0.150
    32.386   388.842     0.150
    32.394   388.447     0.150
    32.412   388.814     0.150
    32.423   389.410     0.150
    32.446   387.812     0.150
    32.514   390.324     0.150
    32.546   389.613     0.150
    32.546   704.236     0.150
    32.564   389.588     0.150
    32.569   389.838     0.150
    32.690   392.322     0.150
    32.690   392.100     0.150
    32.711   391.738     0.150
    32.731   389.613     0.150
    32.731   701.383     0.150
    32.736   394.002     0.150
    32.748   391.188     0.150
    32.764   391.141     0.150
    32.774   390.562     0.150
    32.787   391.844     0.150
    32.814   389.373     0.150
    32.829   392.652     0.150
    32.854   392.332     0.150
    32.893   392.637     0.150
    32.938   393.963     0.150
    32.979   394.684     0.150
    32.982   394.537     0.150
    33.015   395.090     0.150
    33.078   393.627     0.150
    33.114   391.992     0.150
    33.153   393.113     0.150
    33.153   392.287     0.150
    33.153   704.338     0.150
    33.153  1057.613     0.150
    33.165   395.764     0.150
    33.183   394.553     0.150
    33.193   396.430     0.150
    33.226   397.594     0.150
    33.270   396.139     0.150
    33.276   396.963     0.150
    33.440   398.973     0.150
    33.447   398.238     0.150
    33.495   397.912     0.150
    33.502   399.250     0.150
    33.513   399.139     0.150
    33.562   398.662     0.150
    33.580   399.287     0.150
    33.578   400.375     0.150
    33.635   399.863     0.150
    33.657   400.188     0.150
    33.792   400.568     0.150
    33.846   402.434     0.150
    33.883   402.014     0.150
    33.886   401.152     0.150
    33.886   402.213     0.150
    33.886  1088.812     0.150
    33.894   402.945     0.150
    33.950   401.875     0.150
    33.970   403.420     0.150
    34.014   403.180     0.150
    34.012   403.363     0.150
    34.040   403.812     0.150
    34.149   404.412     0.150
    34.238   405.863     0.150
    34.251   404.932     0.150
    34.360   407.162     0.150
    34.370   406.020     0.150
    34.408   407.242     0.150
    34.454   407.363     0.150
    34.508   405.963     0.150
    34.559   408.312     0.150
    34.594   406.533     0.150
    34.652   407.963     0.150
    34.681   409.896     0.150
    34.736   409.389     0.150
    34.822   408.832     0.150
    34.828   411.037     0.150
    34.846   408.434     0.150
    34.965   408.934     0.150
    34.969   412.012     0.150
    34.992   411.562     0.150
    35.022   412.666     0.150
    35.105   412.533     0.150
    35.111   412.537     0.150
    35.116   413.072     0.150
    35.162   413.184     0.150
    35.214   413.412     0.150
    35.483   415.113     0.150
    35.477   415.402     0.150
    35.499   414.053     0.150
    35.512   414.723     0.150
    35.547   417.338     0.150
    35.658   417.150     0.150
    35.683   417.463     0.150
    35.696   417.713     0.150
    35.723   417.514     0.150
    35.799   419.391     0.150
    36.023   420.143     0.150
    36.149   422.080     0.150
    36.151   421.283     0.150
    36.305   422.527     0.150
    36.333   423.514     0.150
    36.528   425.148     0.150
    36.585   425.674     0.150
    37.144   431.174     0.150
    37.144   570.633     0.150
    37.144   780.438     0.150
    37.357   430.553     0.150
    37.366   429.854     0.150
    37.464   431.514     0.150
    37.464   430.924     0.150
    37.560   431.424     0.150
    37.699   434.902     0.150
    37.899   436.174     0.150
    38.131   437.203     0.150
    41.211   464.738     0.150
    41.744   466.803     0.150
    41.744   564.143     0.150
    43.893   487.713     0.150
    44.930   496.312     0.150
    44.930   495.604     0.150
    44.930   495.912     0.150
    44.930   894.961     0.150
    45.490   496.893     0.150
    45.490   604.424     0.150
    45.490   897.162     0.150
    45.490  1447.037     0.150
    45.638   500.713     0.150
    45.983   503.703     0.150
    45.983   909.188     0.150
    45.983  1462.213     0.150
    46.332   503.113     0.150
    46.332   598.652     0.150
    46.332   610.053     0.150
    46.332  1469.293     0.150
    46.627   508.684     0.150
    46.627   506.812     0.150
    46.627   918.537     0.150
    46.627  1484.787     0.150
    47.124   923.514     0.150
    47.621   514.883     0.150
    47.621    11.330     0.150
    49.262   528.383     0.150
    50.846   538.873     0.150
    52.236   551.742     0.150
    52.236    10.240     0.150
    52.479   553.014     0.150
    52.479   996.812     0.150
    52.479  1216.912     0.150
    53.816   561.924     0.150
    54.047   564.764     0.150
    54.132   565.344     0.150
    54.132    10.170     0.150
    54.357   567.633     0.150
    54.357    10.211     0.150
    54.358   567.184     0.150
    54.358    10.799     0.150
    54.611   567.713     0.150
    54.863   569.303     0.150
    54.863    10.490     0.150
    55.019   572.162     0.150
    55.228   571.463     0.150
    55.228   571.312     0.150
    55.228   571.613     0.150
    55.228  1033.738     0.150
    55.777   576.354     0.150
    55.777    10.930     0.150
    55.829   577.152     0.150
    55.934   577.443     0.150
    55.996   577.812     0.150
    56.715   584.514     0.150
    56.806   585.312     0.150
    57.010   584.953     0.150
    57.219   585.924     0.150
    57.476   589.213     0.150
    57.476  1073.162     0.150
    57.565   587.174     0.150
    57.798   591.162     0.150
    57.858   590.383     0.150
    58.327   595.393     0.150
    58.560   595.014     0.150
    59.400   603.213     0.150
    59.474   601.014     0.150
    59.544   604.312     0.150
    59.544  1090.312     0.150
    59.544  1329.113     0.150
    59.544   605.473     0.150
    59.597   604.412     0.150
    59.801   604.783     0.150
    59.927   604.213     0.150
    60.661   610.082     0.150
    61.036   612.742     0.150
    61.874   617.742     0.150
    62.253   620.223     0.150
    62.690  1130.113     0.150
    62.690  1377.812     0.150
    63.937   632.693     0.150
    63.937    10.430     0.150
    63.937   632.213     0.150
    65.235   640.482     0.150
    65.626   641.713     0.150
    65.626    12.000     0.150
    65.626  1166.713     0.150
    65.626  1181.713     0.150
    65.626  1246.713     0.150
    65.626  1251.713     0.150
    65.714   643.123     0.150
    66.484   648.562     0.150
    67.017   649.713     0.150
    67.608   657.684     0.150
    68.259   659.562     0.150
    68.845   663.166     0.150
    68.845    10.615     0.150
    68.845   686.613     0.150
    69.666   671.211     0.150
    69.720   670.184     0.150
    69.720    12.404     0.150
    69.886   668.662     0.150
    70.777   674.354     0.150
    70.894   676.992     0.150
    71.455   678.514     0.150
    74.458   700.523     0.150
    75.387   702.893     0.150
    75.387   702.312     0.150
    75.387    11.201     0.150
    75.387   869.412     0.150
    75.387  1280.514     0.150
    75.387  1577.213     0.150
    75.480   705.312     0.150
    75.480     9.201     0.150
    75.894   716.713     0.150
    77.002   713.912     0.150
    77.380   714.582     0.150
    77.380   712.033     0.150
    77.380  1302.434     0.150
    77.380   714.312     0.150
    77.654   715.033     0.150
    77.852   715.912     0.150
    77.978   716.863     0.150
    78.177   718.014     0.150
    78.177   717.203     0.150
    78.180   717.332     0.150
    78.190   718.133     0.150
    78.195   718.273     0.150
    78.266   718.613     0.150
    78.326   718.223     0.150
    78.328   718.523     0.150
    78.440   719.213     0.150
    78.506   720.354     0.150
    78.676   720.332     0.150
    78.726   721.082     0.150
    78.737   720.854     0.150
    78.831   721.312     0.150
    78.864   722.113     0.150
    79.156   722.803     0.150
    79.173   723.424     0.150
    79.285   723.764     0.150
    79.373   724.752     0.150
    79.446   724.223     0.150
    79.568   725.912     0.150
    79.590   725.492     0.150
    79.595   724.943     0.150
    79.715   725.613     0.150
    79.729   726.354     0.150
    79.764   727.293     0.150
    79.850   727.123     0.150
    79.958   726.893     0.150
    79.968   727.443     0.150
    80.003   727.713     0.150
    80.003   727.383     0.150
    80.083   728.264     0.150
    80.162   728.812     0.150
    80.176   728.613     0.150
    80.176    10.900     0.150
    80.176  1332.613     0.150
    80.176  1642.812     0.150
    80.256   729.533     0.150
    80.261   728.533     0.150
    80.336   729.963     0.150
    80.335   729.992     0.150
    80.335  1331.072     0.150
    80.335  1331.184     0.150
    80.365   730.732     0.150
    80.429   730.412     0.150
    80.429    11.102     0.150
    80.478   730.344     0.150
    80.650   732.152     0.150
    80.677   731.783     0.150
    80.764   732.713     0.150
    80.764    10.000     0.150
    80.775   732.412     0.150
    80.775    10.400     0.150
    80.907   732.553     0.150
    80.946  1343.742     0.150
    80.952   734.213     0.150
    80.952    10.100     0.150
    80.977   734.014     0.150
    80.977    10.100     0.150
    80.977  1340.113     0.150
    80.977  1659.113     0.150
    81.037   732.662     0.150
    81.069   734.514     0.150
    81.069    10.500     0.150
    81.069  1341.812     0.150
    81.069  1654.613     0.150
    81.113   734.014     0.150
    81.113    10.199     0.150
    81.113  1341.514     0.150
    81.113  1657.713     0.150
    81.113   733.873     0.150
    81.243   734.113     0.150
    81.243   734.613     0.150
    81.243    10.699     0.150
    81.259   734.424     0.150
    81.269   735.143     0.150
    81.293   735.312     0.150
    81.293    10.000     0.150
    81.293  1343.514     0.150
    81.293  1666.113     0.150
    81.302   735.953     0.150
    81.307   735.213     0.150
    81.307    10.900     0.150
    81.334   735.514     0.150
    81.334    10.799     0.150
    81.420   735.934     0.150
    81.476   735.613     0.150
    81.476    11.000     0.150
    81.476  1345.014     0.150
    81.476  1662.113     0.150
    81.485   736.912     0.150
    81.485     9.801     0.150
    81.532   736.332     0.150
    81.640   737.713     0.150
    81.640    10.199     0.150
    81.640  1349.113     0.150
    81.640  1665.213     0.150
    81.762   738.014     0.150
    81.762    10.398     0.150
    81.762  1349.213     0.150
    81.762  1666.514     0.150
    81.813   737.973     0.150
    81.907   737.514     0.150
    81.907   739.412     0.150
    81.940   739.053     0.150
    82.022   739.043     0.150
    82.076   739.514     0.150
    82.076    10.000     0.150
    82.076  1352.213     0.150
    82.076  1671.912     0.150
    82.097   738.613     0.150
    82.295   741.072     0.150
    82.389   740.014     0.150
    82.446   740.912     0.150
    82.465   741.752     0.150
    82.698  1364.863     0.150
    82.883   744.873     0.150
    82.883     9.459     0.150
    82.883   744.412     0.150
    82.883  1359.812     0.150
    82.883  1412.514     0.150
    82.883  1686.514     0.150
    83.285   745.703     0.150
    83.331   746.863     0.150
    83.339   746.943     0.150
    83.428   745.713     0.150
    83.531   747.053     0.150
    83.546   747.014     0.150
    83.573   743.582     0.150
    83.573   939.844     0.150
    83.573  1367.732     0.150
    83.694   748.332     0.150
    83.694    11.201     0.150
    83.709   747.943     0.150
    83.777   749.143     0.150
    83.777  1366.113     0.150
    83.777  1374.283     0.150
    83.826   748.213     0.150
    83.913   752.152     0.150
    83.940   748.973     0.150
    83.956   749.451     0.150
    83.956   749.213     0.150
    84.120   750.193     0.150
    84.260   751.742     0.150
    84.354   752.713     0.150
    84.459   751.113     0.150
    84.523   752.213     0.150
    84.523    10.301     0.150
    84.523   751.713     0.150
    84.537   752.812     0.150
    84.562   752.713     0.150
    84.563   753.873     0.150
    84.617   753.613     0.150
    84.630   752.223     0.150
    84.859   753.412     0.150
    84.866   754.873     0.150
    84.955   754.393     0.150
    84.955   757.242     0.150
    84.955  1383.363     0.150
    84.970   755.732     0.150
    84.998   755.373     0.150
    85.005   755.062     0.150
    85.060   754.412     0.150
    85.060   754.588     0.150
    85.106   755.273     0.150
    85.166  1378.713     0.150
    85.185   756.533     0.150
    85.352   757.354     0.150
    85.353   755.002     0.150
    85.353    10.842     0.150
    85.353   753.912     0.150
    85.391   756.312     0.150
    85.451   757.213     0.150
    85.498   756.113     0.150
    85.498   757.344     0.150
    85.597   756.613     0.150
    85.602   758.062     0.150
    85.761   753.713     0.150
    85.761   759.193     0.150
    85.780   758.213     0.150
    85.783   758.514     0.150
    85.800   758.213     0.150
    85.840   759.662     0.150
    85.847   757.773     0.150
    85.949   759.803     0.150
    85.970   758.713     0.150
    85.970   758.713     0.150
    85.988   758.412     0.150
    86.024   758.812     0.150
    86.044   760.113     0.150
    86.059   761.033     0.150
    86.098   758.713     0.150
    86.098   761.463     0.150
    86.130   759.412     0.150
    86.180   761.033     0.150
    86.187   759.812     0.150
    86.286   761.893     0.150
    86.313   761.514     0.150
    86.321   760.514     0.150
    86.412   760.312     0.150
    86.468   761.213     0.150
    86.483   761.293     0.150
    86.484   760.912     0.150
    86.515   762.113     0.150
    86.556   763.354     0.150
    86.649   763.514     0.150
    86.649   763.014     0.150
    86.650   761.412     0.150
    86.652   761.213     0.150
    86.665   763.312     0.150
    86.717   762.559     0.150
    86.717    11.283     0.150
    86.717  1409.570     0.150
    86.717  1727.133     0.150
    86.780   763.113     0.150
    86.797   762.412     0.150
    86.809   763.812     0.150
    86.810   763.322     0.150
    86.810     9.361     0.150
    86.822   763.014     0.150
    87.018   763.014     0.150
    87.018   765.934     0.150
    87.058   764.854     0.150
    87.073   763.812     0.150
    87.128   764.713     0.150
    87.150   764.213     0.150
    87.155   765.412     0.150
    87.283   765.764     0.150
    87.283    10.080     0.150
    87.343   768.113     0.150
    87.754   767.812     0.150
    87.807   768.412     0.150
    87.988   769.014     0.150
    88.022   769.514     0.150
    88.065   768.713     0.150
    88.109   769.912     0.150
    88.109   975.312     0.150
    88.109  1400.912     0.150
    88.233   769.312     0.150
    88.355   770.412     0.150
    88.355    10.701     0.150
    88.452   770.514     0.150
    88.460   770.014     0.150
    88.467   770.713     0.150
    88.476   771.014     0.150
    88.550   771.514     0.150
    88.610   771.514     0.150
    88.626   771.912     0.150
    88.792   773.014     0.150
    88.792   980.713     0.150
    88.950   773.514     0.150
    88.951   777.213     0.150
    88.969  1393.713     0.150
    89.000   772.912     0.150
    89.040   774.014     0.150
    89.040   983.613     0.150
    89.102   773.443     0.150
    89.133   774.514     0.150
    89.139   773.713     0.150
    89.139    10.600     0.150
    89.139   981.713     0.150
    89.171   774.113     0.150
    89.173   774.812     0.150
    89.311   775.113     0.150
    89.331   775.113     0.150
    89.344   775.713     0.150
    89.465   775.973     0.150
    89.512   775.613     0.150
    89.625   776.412     0.150
    89.657   776.312     0.150
    90.034   778.312     0.150
    90.034    11.000     0.150
    90.034   990.812     0.150
    90.049   777.412     0.150
    90.049   777.713     0.150
    90.058   778.613     0.150
    90.248   780.113     0.150
    90.248    10.600     0.150
    90.248   992.912     0.150
    90.248  1437.113     0.150
    90.248  1778.812     0.150
    90.248   780.113     0.150
    90.248    10.600     0.150
    90.248   992.912     0.150
    90.248  1437.113     0.150
    90.248  1778.812     0.150
    90.247   779.383     0.150
    90.247    10.660     0.150
    90.247   780.912     0.150
    90.493   778.312     0.150
    90.494   780.113     0.150
    90.494    11.199     0.150
    90.494  1408.713     0.150
    90.494  1497.713     0.150
    90.494   780.312     0.150
    90.494    10.900     0.150
    90.494    14.201     0.150
    90.494   991.213     0.150
    90.494  1411.713     0.150
    90.494  1430.412     0.150
    90.494  1501.613     0.150
    90.494  1792.213     0.150
    90.494  1825.514     0.150
    90.494   990.713     0.150
    90.494  1792.713     0.150
    90.494  1825.713     0.150
    90.534   781.041     0.150
    90.562   780.312     0.150
    90.618   781.312     0.150
    90.618    10.801     0.150
    90.618   995.613     0.150
    90.620   781.412     0.150
    90.620   995.812     0.150
    90.697   781.812     0.150
    90.697    10.900     0.150
    90.697   990.412     0.150
    90.697  1410.812     0.150
    90.697  1504.213     0.150
    90.779   782.213     0.150
    90.779   996.014     0.150
    90.808   782.113     0.150
    90.840   780.652     0.150
    90.840   781.088     0.150
    90.840  1828.113     0.150
    90.980   783.143     0.150
    91.171   784.182     0.150
    91.224   784.043     0.150
    91.224    10.859     0.150
    91.224   995.713     0.150
    91.224  1414.713     0.150
    91.224  1439.713     0.150
    91.224  1510.713     0.150
    91.224  1792.713     0.150
    91.224   783.812     0.150
    91.224   999.014     0.150
    91.370   785.713     0.150
    91.460   785.312     0.150
    91.460    10.801     0.150
    91.673   783.613     0.150
    91.741   786.113     0.150
    91.741    11.199     0.150
    91.741  1416.213     0.150
    91.741  1514.613     0.150
    91.738   785.543     0.150
    91.738    11.199     0.150
    91.738   786.113     0.150
    91.738    10.199     0.150
    91.738  1002.412     0.150
    91.738  1415.312     0.150
    91.738  1446.912     0.150
    91.738  1820.412     0.150
    91.748   785.742     0.150
    91.748  1004.773     0.150
    91.748  1412.613     0.150
    91.748  1439.594     0.150
    91.748  1450.273     0.150
    91.748  1457.703     0.150
    91.870   785.113     0.150
    91.870   787.113     0.150
    91.870    10.500     0.150
    91.870  1002.713     0.150
    91.870  1418.213     0.150
    91.870  1519.713     0.150
    91.870  1812.412     0.150
    91.994   787.514     0.150
    91.994    10.100     0.150
    91.994  1419.312     0.150
    91.994  1519.412     0.150
    91.994  1813.213     0.150
    91.994   999.912     0.150
    92.080   787.812     0.150
    92.080  1005.912     0.150
    92.080   787.602     0.150
    92.095   789.713     0.150
    92.180   788.412     0.150
    92.314   790.713     0.150
    92.382   789.586     0.150
    92.526   790.264     0.150
    92.526   792.252     0.150
    92.526    10.229     0.150
    92.526  1010.623     0.150
    92.526  1426.023     0.150
    92.526  1454.992     0.150
    92.526   790.014     0.150
    92.526    10.398     0.150
    92.526  1009.713     0.150
    92.526  1417.713     0.150
    92.526  1520.713     0.150
    92.546   790.113     0.150
    92.546    10.699     0.150
    92.546  1010.912     0.150
    92.726   791.025     0.150
    92.789   789.412     0.150
    92.789    10.301     0.150
    92.797   791.213     0.150
    92.797    11.100     0.150
    92.797  1010.613     0.150
    92.797  1823.912     0.150
    92.875   791.613     0.150
    92.875    10.600     0.150
    92.875  1010.613     0.150
    92.881   795.713     0.150
    92.896   791.742     0.150
    92.898   793.713     0.150
    92.995   796.713     0.150
    93.014   790.613     0.150
    93.055   792.312     0.150
    93.121   792.258     0.150
    93.136   790.613     0.150
    93.209   793.613     0.150
    93.227   792.633     0.150
    93.227    11.189     0.150
    93.227  1014.492     0.150
    93.237   793.533     0.150
    93.237    10.750     0.150
    93.489   794.293     0.150
    93.494   793.213     0.150
    93.505   794.113     0.150
    93.520   792.613     0.150
    93.564   794.613     0.150
    93.564    10.799     0.150
    93.768   795.572     0.150
    93.768     9.811     0.150
    93.768   795.812     0.150
    93.785   796.062     0.150
    93.943   796.273     0.150
    93.943    11.250     0.150
    93.943  1020.502     0.150
    93.943  1429.594     0.150
    93.943  1542.293     0.150
    93.943  1836.793     0.150
    94.032   796.732     0.150
    94.032    11.510     0.150
    94.032  1430.652     0.150
    94.066   796.412     0.150
    94.066    11.500     0.150
    94.066  1019.213     0.150
    94.066  1428.713     0.150
    94.235   797.803     0.150
    94.235  1024.783     0.150
    94.243   796.873     0.150
    94.243   799.094     0.150
    94.243    11.379     0.150
    94.243  1424.793     0.150
    94.243  1429.434     0.150
    94.243  1463.062     0.150
    94.243  1845.482     0.150
    94.246   797.613     0.150
    94.314   809.613     0.150
    94.358   799.014     0.150
    94.358    10.898     0.150
    94.358  1023.514     0.150
    94.358  1433.113     0.150
    94.358  1547.812     0.150
    94.364   799.412     0.150
    94.364    10.602     0.150
    94.364  1021.713     0.150
    94.364  1433.014     0.150
    94.364  1458.412     0.150
    94.364  1545.312     0.150
    94.652   799.783     0.150
    94.652    11.240     0.150
    94.652  1024.203     0.150
    94.720   800.473     0.150
    94.720     9.859     0.150
    94.720   800.713     0.150
    94.720     8.801     0.150
    94.720  1431.713     0.150
    94.720  1467.713     0.150
    94.720  1543.713     0.150
    94.720  1853.713     0.150
    94.747   799.613     0.150
    94.747     9.900     0.150
    94.747  1026.514     0.150
    94.747  1431.213     0.150
    94.747  1543.713     0.150
    94.884   800.812     0.150
    94.887   801.412     0.150
    94.887    11.500     0.150
    95.175   802.514     0.150
    95.175    11.100     0.150
    95.175  1030.213     0.150
    95.175  1437.312     0.150
    95.207   803.238     0.150
    95.237   802.613     0.150
    95.465   804.312     0.150
    95.465    10.900     0.150
    95.833   816.812     0.150
    95.928   806.014     0.150
    95.973   806.514     0.150
    95.973    11.199     0.150
    95.973  1033.514     0.150
    96.084   806.553     0.150
    96.084    10.480     0.150
    96.084  1037.543     0.150
    96.084   807.312     0.150
    96.084    11.301     0.150
    96.084   807.113     0.150
    96.094   806.912     0.150
    96.094    10.400     0.150
    96.304   806.293     0.150
    96.386   808.113     0.150
    96.386  1441.514     0.150
    96.624   808.424     0.150
    96.624    10.309     0.150
    96.624  1043.543     0.150
    96.624  1439.424     0.150
    96.624  1482.822     0.150
    96.624   809.014     0.150
    96.804   810.213     0.150
    96.804    12.500     0.150
    96.804  1444.312     0.150
    96.992   811.312     0.150
    96.992    10.201     0.150
    96.992  1046.713     0.150
    96.992  1443.713     0.150
    96.992  1488.312     0.150
    96.992  1569.713     0.150
    96.992  1889.713     0.150
    97.007   811.014     0.150
    97.199   810.213     0.150
    97.199  1048.412     0.150
    97.199  1445.014     0.150
    97.199  1481.812     0.150
    97.199  1571.812     0.150
    97.317   811.562     0.150
    97.317     9.680     0.150
    97.317   811.594     0.150
    97.317  1057.713     0.150
    98.162   816.713     0.150
    98.162   824.812     0.150
    98.162  1053.713     0.150
    98.162  1451.713     0.150
    98.162  1907.412     0.150
    98.361   816.684     0.150
    98.811   815.373     0.150
    98.811    13.529     0.150
    99.142   817.912     0.150
    99.156   820.912     0.150
    99.207   818.953     0.150
    99.210   818.912     0.150
    99.210   819.037     0.150
    99.210  1061.537     0.150
    99.210  1806.963     0.150
    99.210   818.613     0.150
    99.220  1060.912     0.150
    99.220  1448.812     0.150
    99.220  1596.312     0.150
    99.220  1919.014     0.150
    99.387   818.412     0.150
    99.387  1599.713     0.150
    99.387  1925.213     0.150
   100.024   823.014     0.150
   100.877   827.062     0.150
   100.877   827.939     0.150
   100.877  1800.939     0.150
   101.454   829.713     0.150
   101.454  1463.713     0.150
   101.454  1071.713     0.150
   103.153   839.342     0.150
   103.153  1546.713     0.150
   103.214   837.713     0.150
   103.214  1474.613     0.150
   103.214  1535.812     0.150
   103.214  1630.613     0.150
   104.527   842.643     0.150
   104.527   841.514     0.150
   104.527  1478.613     0.150
   104.527  1649.213     0.150
   105.016  1103.473     0.150
   105.554  1107.713     0.150
   105.554  1487.713     0.150
   105.554  1526.713     0.150
   105.554  1671.713     0.150
   106.073  1105.402     0.150
   106.257   853.312     0.150
   106.257  1120.312     0.150
   106.257  1566.014     0.150
   106.257  1674.713     0.150
   106.364  1115.713     0.150
   106.778  1119.412     0.150
   106.948  1101.273     0.150
   107.010  1115.523     0.150
   107.082  1122.213     0.150
   108.380  1107.053     0.150
   108.877  1111.133     0.150
   108.998   864.713     0.150
   108.998   864.613     0.150
   108.998  1109.037     0.150
   108.998  1131.113     0.150
   108.998  1785.238     0.150
   109.209  1109.113     0.150
   109.564   867.014     0.150
   109.999  1109.293     0.150
   109.999  1109.287     0.150
   110.271  1141.693     0.150
   110.362  1111.312     0.150
   110.362  1146.912     0.150
   110.362  1504.412     0.150
   110.600  1139.232     0.150
   110.741  1111.514     0.150
   110.741  1110.613     0.150
   110.974  1112.912     0.150
   110.974  1768.713     0.150
   111.761   878.014     0.150
   112.368  1114.613     0.150
   112.565  1113.902     0.150
   112.565  1158.764     0.150
   113.107  1162.674     0.150
   113.218  1115.713     0.150
   113.218  1544.213     0.150
   113.218  1741.113     0.150
   113.467  1165.652     0.150
   113.510  1161.863     0.150
   114.555  1169.203     0.150
   115.093  1120.312     0.150
   115.093  1338.014     0.150
   115.093  1548.213     0.150
   115.093  1593.613     0.150
   116.256  1122.033     0.150
   116.256  1122.113     0.150
   117.229  1125.123     0.150
   117.270  1200.713     0.150
   117.575  1122.014     0.150
   118.289  1128.812     0.150
   118.289  1209.713     0.150
   118.289  1341.713     0.150
   118.289  1557.713     0.150
   118.835  1127.713     0.150
   118.835  1210.713     0.150
   118.835  1342.713     0.150
   118.835  1554.713     0.150
   118.835  1619.713     0.150
   118.835  2183.713     0.150
   120.054  1129.562     0.150
   120.077  1129.713     0.150
   120.077  1212.713     0.150
   120.077  1541.713     0.150
   120.077  1803.713     0.150
   120.183  1131.072     0.150
   120.616  1131.312     0.150
   120.616  1345.713     0.150
   120.616  1555.514     0.150
   120.616  1629.213     0.150
   120.672  1131.764     0.150
   120.702  1131.633     0.150
   120.702  1214.594     0.150
   121.255  1133.023     0.150
   121.919  1133.213     0.150
   121.972  1133.713     0.150
   122.272  1135.014     0.150
   122.272  1234.213     0.150
   122.272  1349.812     0.150
   122.272  1562.014     0.150
   122.272  1642.213     0.150
   122.272  1830.014     0.150
   122.272  2227.113     0.150
   122.503  1145.613     0.150
   122.503  1232.514     0.150
   122.503  1134.338     0.150
   123.493  1137.213     0.150
   123.493  1244.014     0.150
   124.195  1136.783     0.150
   124.212  1136.344     0.150
   124.615  1137.443     0.150
   124.956  1138.312     0.150
   126.850  1143.213     0.150
   126.850  1262.014     0.150
   126.850  1357.514     0.150
   126.850  1570.014     0.150
   126.850  1670.014     0.150
   128.292  1145.412     0.150
   128.292  1156.412     0.150
   128.292  1145.443     0.150
   128.292  1144.812     0.150
   128.303  1145.547     0.150
   128.478  1144.803     0.150
   128.954  1148.312     0.150
   128.954  1158.412     0.150
   128.975  1147.033     0.150
   129.028  1147.014     0.150
   129.223  1147.633     0.150
   129.223  1147.863     0.150
   129.915  1148.713     0.150
   130.642  1151.764     0.150
   130.642  1352.812     0.150
   131.602  1153.764     0.150
   131.602  1357.162     0.150
   131.882  1152.242     0.150
   132.071  1154.713     0.150
   132.071  1154.312     0.150
   132.302  1154.514     0.150
   132.302  1297.113     0.150
   132.302  1369.514     0.150
   132.302  1580.812     0.150
   132.302  1705.014     0.150
   132.720  1155.713     0.150
   133.352  1155.312     0.150
   133.352  1307.312     0.150
   133.352  1370.812     0.150
   133.739  1158.014     0.150
   134.115  1151.213     0.150
   134.115  1157.312     0.150
   134.115  1364.812     0.150
   134.317  1156.713     0.150
   135.325  1158.133     0.150
   135.325  1161.162     0.150
   135.668  1162.969     0.150
   135.855  1160.713     0.150
   135.962  1157.713     0.150
   136.282  1160.312     0.150
   136.282  1371.713     0.150
   136.535  1164.131     0.150
   137.139  1162.002     0.150
   137.139  1162.838     0.150
   139.501  1166.812     0.150
   139.501  1167.412     0.150
   140.832  1167.992     0.150
   141.875  1168.553     0.150
   142.038  1172.174     0.150
   142.234  1172.043     0.150
   142.423  1169.393     0.150
   142.690  1167.613     0.150
   143.871  1173.213     0.150
   144.026  1173.844     0.150
   144.376  1175.213     0.150
   144.466  1174.883     0.150
   144.555  1174.463     0.150
   144.555  1175.766     0.150
   145.105  1175.193     0.150
   145.277  1176.193     0.150
   145.575  1176.713     0.150
   145.575  1376.713     0.150
   145.575  1379.713     0.150
   147.776  1184.750     0.150
   148.135  1185.713     0.150
   149.070  1186.273     0.150
   149.520  1185.373     0.150
   149.520  1189.943     0.150
   149.520  1195.723     0.150
   149.520  1186.736     0.150
   149.594  1186.693     0.150
   149.661  1182.652     0.150
   149.852  1186.900     0.150
   149.858  1186.914     0.150
   150.302  1187.188     0.150
   152.583  1188.938     0.150
   152.583  1196.514     0.150
   152.583  1206.088     0.150
   152.646  1189.162     0.150
   154.307  1190.252     0.150
   155.655  1194.373     0.150
     0.158     7.408     0.150
     0.158    11.428     0.150
     0.538    10.627     0.150
     0.969    18.588     0.150
     0.969    31.268     0.150
     1.181    21.268     0.150
     1.181    36.178     0.150
     1.407    25.137     0.150
     1.407    42.658     0.150
     2.025    33.168     0.150
     2.025    58.736     0.150
     2.233    61.367     0.150
     2.283    38.678     0.150
     2.283    64.637     0.150
     2.369    40.236     0.150
     2.369    69.518     0.150
     2.444    39.566     0.150
     2.444    69.307     0.150
     2.464    40.277     0.150
     2.464    68.938     0.150
     2.508    39.857     0.150
     2.508    71.828     0.150
     2.602    41.396     0.150
     2.602    72.217     0.150
     3.051    48.297     0.150
     3.051    83.168     0.150
     3.095    48.117     0.150
     3.095    83.527     0.150
     3.307    51.508     0.150
     3.307    90.137     0.150
     3.414    54.037     0.150
     3.414    91.338     0.150
     3.423    53.316     0.150
     3.423    90.117     0.150
     4.268    65.168     0.150
     4.268   111.508     0.150
     5.049    76.486     0.150
     5.049   133.438     0.150
     5.181    77.838     0.150
     5.181   132.387     0.150
     5.181   135.688     0.150
     5.181    77.947     0.150
     5.530    84.277     0.150
     5.667    83.008     0.150
     7.876   116.307     0.150
     8.276   123.357     0.150
     8.846   127.617     0.150
    10.884   159.188     0.150
    11.609   168.920     0.150
    11.783   165.777     0.150
    11.783   297.188     0.150
    12.463   179.197     0.150
    12.933   186.146     0.150
    13.224   187.537     0.150
    13.331   187.396     0.150
    14.858   218.047     0.150
    15.150   214.377     0.150
    15.370   215.037     0.150
    15.890   229.338     0.150
    15.890   229.736     0.150
    16.299   230.266     0.150
    16.470   236.268     0.150
    16.470   236.486     0.150
    16.683   235.000     0.150
    17.111   243.816     0.150
    17.111   242.867     0.150
    17.173   238.207     0.150
    17.153   240.916     0.150
    17.332   241.547     0.150
    17.332   242.137     0.150
    17.361   243.604     0.150
    17.490   246.727     0.150
    17.490   247.277     0.150
    17.498   245.178     0.150
    17.516   241.518     0.150
    17.516   256.178     0.150
    17.647   248.947     0.150
    17.647   249.408     0.150
    17.651   243.938     0.150
    17.781   248.316     0.150
    17.819   249.281     0.150
    17.867   249.795     0.150
    18.085   252.922     0.150
    18.290   251.146     0.150
    18.323   255.617     0.150
    18.398   252.758     0.150
    18.439   256.348     0.150
    18.506   256.457     0.150
    18.506   256.197     0.150
    18.817   260.672     0.150
    18.891   258.207     0.150
    18.935   261.422     0.150
    19.403   266.922     0.150
    19.745   269.797     0.150
    19.745   490.197     0.150
    19.708   269.896     0.150
    19.807   267.758     0.150
    19.834   271.482     0.150
    19.870   271.646     0.150
    20.194   272.658     0.150
    20.194   286.768     0.150
    20.191   275.473     0.150
    20.257   276.396     0.150
    20.490   276.338     0.150
    20.504   279.066     0.150
    20.522   279.348     0.150
    20.558   279.531     0.150
    20.733   281.727     0.150
    20.733   281.871     0.150
    20.800   277.338     0.150
    20.800   280.867     0.150
    20.841   283.271     0.150
    20.970   282.557     0.150
    20.983   284.527     0.150
    21.025   280.896     0.150
    20.999   284.354     0.150
    21.064   284.830     0.150
    21.127   285.447     0.150
    21.202   285.137     0.150
    21.202   285.248     0.150
    21.251   287.248     0.150
    21.302   287.357     0.150
    21.355   285.646     0.150
    21.340   288.037     0.150
    21.351   288.598     0.150
    21.450   289.357     0.150
    21.515   286.316     0.150
    21.496   289.641     0.150
    21.537   286.768     0.150
    21.552   290.396     0.150
    21.592   288.508     0.150
    21.645   293.896     0.150
    21.604   291.000     0.150
    21.672   291.273     0.150
    21.761   292.795     0.150
    21.860   288.717     0.150
    21.859   293.297     0.150
    21.859   293.527     0.150
    21.859   292.896     0.150
    21.859   293.723     0.150
    21.864   293.451     0.150
    22.044   291.127     0.150
    22.054   291.758     0.150
    22.050   294.973     0.150
    22.254   297.998     0.150
    22.254   545.498     0.150
    22.213   296.959     0.150
    22.244   293.348     0.150
    22.245   297.342     0.150
    22.282   297.723     0.150
    22.295   298.061     0.150
    22.446   295.117     0.150
    22.437   299.072     0.150
    22.533   300.322     0.150
    22.588   301.383     0.150
    22.641   297.328     0.150
    22.643   301.422     0.150
    22.655   300.396     0.150
    22.654   301.725     0.150
    22.774   302.537     0.150
    22.874   303.998     0.150
    22.917   303.998     0.150
    22.926   304.719     0.150
    22.970   301.338     0.150
    22.932   304.242     0.150
    22.984   303.227     0.150
    23.012   305.453     0.150
    23.051   305.875     0.150
    23.065   306.111     0.150
    23.099   302.316     0.150
    23.108   306.391     0.150
    23.245   309.357     0.150
    23.251   307.527     0.150
    23.262   307.998     0.150
    23.304   308.777     0.150
    23.344   308.533     0.150
    23.397   309.486     0.150
    23.411   309.205     0.150
    23.434   309.688     0.150
    23.473   306.197     0.150
    23.534   307.367     0.150
    23.536   310.838     0.150
    23.548   310.648     0.150
    23.580   309.697     0.150
    23.640   310.396     0.150
    23.653   311.480     0.150
    23.792   312.748     0.150
    23.795   313.246     0.150
    23.830   313.719     0.150
    23.882   311.918     0.150
    23.888   314.324     0.150
    23.905   314.021     0.150
    23.914   314.309     0.150
    23.978   314.078     0.150
    24.022   315.369     0.150
    24.067   314.217     0.150
    24.082   312.967     0.150
    24.087   316.020     0.150
    24.150   316.555     0.150
    24.192   317.367     0.150
    24.192   317.262     0.150
    24.193   316.992     0.150
    24.310   314.777     0.150
    24.322   318.346     0.150
    24.423   316.947     0.150
    24.495   317.316     0.150
    24.476   319.887     0.150
    24.476   319.697     0.150
    24.481   319.561     0.150
    24.497   319.498     0.150
    24.767   321.428     0.150
    24.770   322.162     0.150
    24.798   322.561     0.150
    24.863   322.797     0.150
    24.863   591.896     0.150
    24.813   322.947     0.150
    24.868   322.236     0.150
    24.970   320.518     0.150
    24.963   323.797     0.150
    24.959   324.193     0.150
    24.997   323.188     0.150
    25.114   323.838     0.150
    25.143   322.057     0.150
    25.117   325.297     0.150
    25.160   326.090     0.150
    25.182   325.697     0.150
    25.182   325.459     0.150
    25.231   325.658     0.150
    25.257   326.857     0.150
    25.285   326.748     0.150
    25.324   327.715     0.150
    25.348   326.807     0.150
    25.394   327.873     0.150
    25.412   327.377     0.150
    25.466   329.230     0.150
    25.503   328.207     0.150
    25.503   329.293     0.150
    25.515   329.578     0.150
    25.574   329.172     0.150
    25.600   329.729     0.150
    25.617   330.447     0.150
    25.724   330.828     0.150
    25.727   331.098     0.150
    25.742   330.645     0.150
    25.853   330.711     0.150
    25.908   332.184     0.150
    25.910   332.383     0.150
    25.912   332.451     0.150
    26.059   333.105     0.150
    26.067   333.037     0.150
    26.074   334.615     0.150
    26.113   334.635     0.150
    26.124   334.586     0.150
    26.125   333.455     0.150
    26.168   334.598     0.150
    26.176   333.527     0.150
    26.176    13.820     0.150
    26.212   335.633     0.150
    26.360   334.236     0.150
    26.337   335.107     0.150
    26.328   336.318     0.150
    26.375   337.172     0.150
    26.375   541.447     0.150
    26.390   336.783     0.150
    26.386   337.143     0.150
    26.442   337.021     0.150
    26.449   336.830     0.150
    26.540   335.338     0.150
    26.508   338.271     0.150
    26.574   339.158     0.150
    26.521   338.672     0.150
    26.630   335.807     0.150
    26.615   338.547     0.150
    26.653   339.090     0.150
    26.675   337.428     0.150
    26.675   337.396     0.150
    26.675   541.047     0.150
    26.688   338.758     0.150
    26.718   339.229     0.150
    26.730   338.957     0.150
    26.780   339.797     0.150
    26.854   338.508     0.150
    26.817   340.588     0.150
    26.867   340.445     0.150
    26.946   341.451     0.150
    27.021   338.867     0.150
    27.041   342.422     0.150
    27.053   343.572     0.150
    27.057   342.609     0.150
    27.091   341.797     0.150
    27.207   343.572     0.150
    27.220   344.002     0.150
    27.225   343.717     0.150
    27.225    12.260     0.150
    27.225   344.045     0.150
    27.296   344.500     0.150
    27.390   347.287     0.150
    27.416   342.418     0.150
    27.416   345.598     0.150
    27.410   345.613     0.150
    27.500   347.287     0.150
    27.508   347.367     0.150
    27.580   346.197     0.150
    27.523   347.672     0.150
    27.547   346.227     0.150
    27.572   345.797     0.150
    27.623   347.777     0.150
    27.575   347.473     0.150
    27.638   346.697     0.150
    27.762   349.986     0.150
    27.692   349.180     0.150
    27.755   347.287     0.150
    27.717   347.338     0.150
    27.717   348.588     0.150
    27.736   347.258     0.150
    27.743   349.441     0.150
    27.783   350.109     0.150
    27.861   349.822     0.150
    27.868   349.367     0.150
    27.879   349.498     0.150
    27.901   348.598     0.150
    27.891   350.148     0.150
    27.927   350.684     0.150
    27.956   350.146     0.150
    27.966   350.680     0.150
    28.027   352.070     0.150
    28.089   351.572     0.150
    28.133   352.938     0.150
    28.176   352.322     0.150
    28.240   351.057     0.150
    28.240    16.611     0.150
    28.245   352.973     0.150
    28.241   354.271     0.150
    28.304   354.867     0.150
    28.284   353.639     0.150
    28.343   354.959     0.150
    28.395   354.463     0.150
    28.513   357.027     0.150
    28.455   355.646     0.150
    28.504   353.418     0.150
    28.504    10.799     0.150
    28.504    14.510     0.150
    28.490   355.193     0.150
    28.513   356.367     0.150
    28.575   353.578     0.150
    28.578   356.338     0.150
    28.643   355.896     0.150
    28.636   356.891     0.150
    28.781   359.197     0.150
    28.727   357.342     0.150
    28.779   355.137     0.150
    28.779    13.660     0.150
    28.746   358.098     0.150
    28.784   360.307     0.150
    28.796   357.521     0.150
    28.814   357.477     0.150
    28.814    14.160     0.150
    28.833   356.727     0.150
    28.846   357.947     0.150
    28.842   358.730     0.150
    28.860   358.422     0.150
    28.871   358.168     0.150
    28.879   359.730     0.150
    28.893   359.348     0.150
    28.908   359.633     0.150
    29.006   357.998     0.150
    28.980   360.203     0.150
    29.054   360.072     0.150
    29.078   360.072     0.150
    29.088   360.377     0.150
    29.140   360.672     0.150
    29.226   362.486     0.150
    29.253   363.143     0.150
    29.262   361.672     0.150
    29.298   362.123     0.150
    29.424   364.516     0.150
    29.436   363.697     0.150
    29.490   364.137     0.150
    29.556   363.268     0.150
    29.557   365.473     0.150
    29.621   365.498     0.150
    29.623   364.447     0.150
    29.639   364.785     0.150
    29.658   366.820     0.150
    29.692   365.697     0.150
    29.699   365.348     0.150
    29.735   366.047     0.150
    29.737   366.578     0.150
    29.781   367.084     0.150
    29.793   366.947     0.150
    29.851   366.508     0.150
    29.851   366.619     0.150
    29.879   364.287     0.150
    29.889   367.396     0.150
    29.892   368.570     0.150
    29.902   367.396     0.150
    30.027   369.637     0.150
    30.027   368.508     0.150
    29.976   368.248     0.150
    29.994   368.688     0.150
    29.994   368.465     0.150
    30.011   369.098     0.150
    30.051   368.473     0.150
    30.055   368.918     0.150
    30.103   369.646     0.150
    30.161   369.576     0.150
    30.206   370.117     0.150
    30.199   371.777     0.150
    30.276   368.117     0.150
    30.282   370.447     0.150
    30.291   371.217     0.150
    30.329   368.947     0.150
    30.311   370.723     0.150
    30.363   372.396     0.150
    30.407   372.418     0.150
    30.433   371.797     0.150
    30.457   372.098     0.150
    30.485   372.404     0.150
    30.528   370.457     0.150
    30.538   372.576     0.150
    30.609   372.973     0.150
    30.652   374.271     0.150
    30.670   374.035     0.150
    30.675   374.797     0.150
    30.771   373.338     0.150
    30.761   375.098     0.150
    30.778   374.855     0.150
    30.838   376.527     0.150
    30.812   374.936     0.150
    30.887   375.271     0.150
    30.903   376.848     0.150
    30.937   376.447     0.150
    30.956   376.129     0.150
    30.987   377.170     0.150
    31.028   376.947     0.150
    31.045   376.377     0.150
    31.055   378.547     0.150
    31.084   377.619     0.150
    31.093   377.158     0.150
    31.121   377.455     0.150
    31.124   377.697     0.150
    31.224   376.668     0.150
    31.229   379.193     0.150
    31.243   379.508     0.150
    31.315   379.547     0.150
    31.317   379.342     0.150
    31.346   378.557     0.150
    31.346   379.396     0.150
    31.352   379.447     0.150
    31.422   379.842     0.150
    31.501   378.188     0.150
    31.489   381.289     0.150
    31.505   380.598     0.150
    31.506   380.598     0.150
    31.521   381.176     0.150
    31.593   381.998     0.150
    31.626   382.168     0.150
    31.701   382.486     0.150
    31.701   382.334     0.150
    31.729   382.498     0.150
    31.750   383.223     0.150
    31.845   385.117     0.150
    31.879   385.121     0.150
    31.931   383.973     0.150
    31.931   386.129     0.150
    31.963   384.867     0.150
    31.995   385.197     0.150
    32.020   384.998     0.150
    32.063   385.896     0.150
    32.145   386.717     0.150
    32.173   387.584     0.150
    32.197   387.248     0.150
    32.238   388.717     0.150
    32.238    13.820     0.150
    32.259   386.736     0.150
    32.337   388.473     0.150
    32.358   387.797     0.150
    32.441   388.088     0.150
    32.461   392.447     0.150
    32.423   388.588     0.150
    32.437   389.076     0.150
    32.529   389.307     0.150
    32.529   388.820     0.150
    32.527   390.109     0.150
    32.576   389.377     0.150
    32.580   389.646     0.150
    32.684   401.748     0.150
    32.757   393.887     0.150
    32.724   391.703     0.150
    32.798   389.508     0.150
    32.751   392.986     0.150
    32.751    14.111     0.150
    32.761   390.867     0.150
    32.798   390.867     0.150
    32.848   390.477     0.150
    32.848    12.051     0.150
    32.905   392.652     0.150
    32.951   393.369     0.150
    32.993   394.611     0.150
    32.996   394.396     0.150
    33.028   394.688     0.150
    33.097   391.227     0.150
    33.158   392.922     0.150
    33.176   395.521     0.150
    33.180   396.748     0.150
    33.195   395.287     0.150
    33.207   396.480     0.150
    33.240   398.018     0.150
    33.254   396.277     0.150
    33.282   395.689     0.150
    33.459   397.930     0.150
    33.507   397.373     0.150
    33.516   398.811     0.150
    33.527   398.777     0.150
    33.574   398.316     0.150
    33.591   399.010     0.150
    33.591   400.445     0.150
    33.645   399.508     0.150
    33.667   399.891     0.150
    33.803   400.711     0.150
    33.895   401.723     0.150
    33.907   403.002     0.150
    33.983   403.123     0.150
    34.025   402.809     0.150
    34.025   403.248     0.150
    34.032   402.227     0.150
    34.053   403.232     0.150
    34.162   404.090     0.150
    34.251   405.848     0.150
    34.262   404.654     0.150
    34.337   406.908     0.150
    34.372   406.623     0.150
    34.381   405.896     0.150
    34.421   405.828     0.150
    34.432   405.508     0.150
    34.466   407.072     0.150
    34.502   405.658     0.150
    34.572   408.842     0.150
    34.664   407.818     0.150
    34.695   409.461     0.150
    34.748   409.146     0.150
    34.841   410.715     0.150
    34.960   409.408     0.150
    34.981   411.834     0.150
    35.004   411.348     0.150
    35.036   412.555     0.150
    35.118   412.643     0.150
    35.124   412.322     0.150
    35.130   412.936     0.150
    35.223   414.736     0.150
    35.226   413.152     0.150
    35.507   415.418     0.150
    35.507    14.000     0.150
    35.490   415.447     0.150
    35.560   416.967     0.150
    35.613   416.146     0.150
    35.671   417.248     0.150
    35.695   417.172     0.150
    35.708   417.506     0.150
    35.736   417.197     0.150
    35.812   419.787     0.150
    35.812   418.984     0.150
    36.163   421.316     0.150
    36.162   422.104     0.150
    36.318   422.572     0.150
    36.346   423.303     0.150
    36.598   425.736     0.150
    37.128   431.117     0.150
    37.471   430.396     0.150
    37.471   430.848     0.150
    41.748   466.617     0.150
    43.877   487.197     0.150
    44.928   495.471     0.150
    45.487   496.447     0.150
    45.967   502.947     0.150
    46.340   502.992     0.150
    46.639   508.047     0.150
    47.136   920.498     0.150
    49.275   528.236     0.150
    52.487   997.197     0.150
    53.827   560.588     0.150
    54.376   567.498     0.150
    54.624   568.098     0.150
    54.875   569.066     0.150
    55.238   571.207     0.150
    55.790   575.307     0.150
    55.947   577.268     0.150
    56.009   577.598     0.150
    56.726   584.197     0.150
    56.818   584.896     0.150
    57.022   584.668     0.150
    57.231   585.297     0.150
    57.570   586.777     0.150
    58.573   595.098     0.150
    59.487   601.797     0.150
    59.555  1089.697     0.150
    59.939   603.896     0.150
    61.017   612.967     0.150
    62.700  1130.598     0.150
    63.924   632.547     0.150
    65.248   640.227     0.150
    66.497   647.816     0.150
    67.022   650.498     0.150
    68.275   658.848     0.150
    71.457   677.896     0.150
    75.400   702.396     0.150
    75.400    12.801     0.150
    77.382   712.896     0.150
    78.171   717.396     0.150
    78.260   717.998     0.150
    79.437   724.928     0.150
    79.755   726.797     0.150
    79.998   727.248     0.150
    80.019   727.447     0.150
    80.355   729.098     0.150
    80.419   730.297     0.150
    80.641   730.396     0.150
    80.754   732.297     0.150
    80.765   731.998     0.150
    81.058   733.697     0.150
    81.104   733.297     0.150
    81.104   733.777     0.150
    81.104    14.910     0.150
    81.233   733.998     0.150
    81.233   734.396     0.150
    81.284   734.197     0.150
    81.297   735.197     0.150
    81.325   735.297     0.150
    81.466   735.197     0.150
    81.475   736.098     0.150
    81.629   736.598     0.150
    81.751   737.396     0.150
    81.897   738.027     0.150
    81.900   737.297     0.150
    81.930   738.588     0.150
    82.013   738.047     0.150
    82.065   738.297     0.150
    82.090   738.396     0.150
    82.382   740.896     0.150
    82.454   741.018     0.150
    82.459   741.896     0.150
    82.898   743.197     0.150
    82.898   744.297     0.150
    82.898  1357.396     0.150
    82.898  1409.299     0.150
    82.898  1684.998     0.150
    83.276   745.736     0.150
    83.321   745.787     0.150
    83.328   745.688     0.150
    83.421   745.396     0.150
    83.522   746.578     0.150
    83.539   746.498     0.150
    83.699   747.328     0.150
    83.699    15.059     0.150
    83.819   747.697     0.150
    83.946   748.234     0.150
    83.946   748.998     0.150
    83.946    14.818     0.150
    84.249   750.578     0.150
    84.451   750.797     0.150
    84.527   751.617     0.150
    84.552   752.258     0.150
    84.556   751.297     0.150
    84.537   751.797     0.150
    84.851   753.197     0.150
    84.856   753.537     0.150
    84.960   754.316     0.150
    84.951   753.498     0.150
    85.057   754.396     0.150
    85.175   754.037     0.150
    85.342   756.217     0.150
    85.382   755.797     0.150
    85.363   754.598     0.150
    85.442   756.896     0.150
    85.499   755.896     0.150
    85.499   755.867     0.150
    85.499    12.680     0.150
    85.591   758.078     0.150
    85.589   756.396     0.150
    85.777   758.078     0.150
    85.831   758.236     0.150
    85.840   758.707     0.150
    85.940   758.047     0.150
    85.961   758.396     0.150
    85.963   758.297     0.150
    85.980   758.197     0.150
    86.035   759.697     0.150
    86.049   760.066     0.150
    86.090   758.598     0.150
    86.170   760.717     0.150
    86.181   760.467     0.150
    86.314   760.297     0.150
    86.405   759.998     0.150
    86.460   759.998     0.150
    86.476   760.598     0.150
    86.477   763.008     0.150
    86.507   761.098     0.150
    86.537   761.357     0.150
    86.550   763.146     0.150
    86.565   761.617     0.150
    86.640   763.098     0.150
    86.642   761.697     0.150
    86.643   760.998     0.150
    86.645   760.896     0.150
    86.711   761.598     0.150
    86.711    13.025     0.150
    86.790   762.098     0.150
    86.802   762.197     0.150
    86.816   763.727     0.150
    87.011   762.697     0.150
    87.049   762.428     0.150
    87.066   763.896     0.150
    87.129   764.498     0.150
    87.142   764.098     0.150
    87.148   764.498     0.150
    87.277   764.486     0.150
    87.277    14.271     0.150
    87.277   765.688     0.150
    87.277   764.797     0.150
    87.277   967.098     0.150
    87.980   767.998     0.150
    88.058   768.697     0.150
    88.226   768.896     0.150
    88.349   769.896     0.150
    88.445   770.396     0.150
    88.452   769.598     0.150
    88.460   770.697     0.150
    88.469   769.797     0.150
    88.603   770.998     0.150
    88.619   771.498     0.150
    88.787   771.797     0.150
    88.787   979.197     0.150
    88.970   769.797     0.150
    89.034   773.396     0.150
    89.133   772.697     0.150
    89.133   981.498     0.150
    89.304   774.396     0.150
    89.324   774.797     0.150
    89.463   774.598     0.150
    89.650   775.697     0.150
    89.964   778.197     0.150
    90.028   777.998     0.150
    90.028   990.697     0.150
    90.028   988.998     0.150
    90.041   778.498     0.150
    90.041   776.896     0.150
    90.242   778.697     0.150
    90.242    11.100     0.150
    90.242  1423.998     0.150
    90.242   778.697     0.150
    90.242    11.199     0.150
    90.242  1423.998     0.150
    90.439   779.998     0.150
    90.489   780.197     0.150
    90.489  1406.197     0.150
    90.489   992.598     0.150
    90.489    15.000     0.150
    90.489   993.197     0.150
    90.489  1501.197     0.150
    90.492   778.598     0.150
    90.527   780.605     0.150
    90.613   780.396     0.150
    90.613   994.197     0.150
    90.614   779.896     0.150
    90.691   780.697     0.150
    90.691    12.000     0.150
    90.691   994.998     0.150
    90.750   781.779     0.150
    90.773   781.297     0.150
    90.773   994.998     0.150
    90.838   780.598     0.150
    91.219   782.967     0.150
    91.219    10.820     0.150
    91.219   996.197     0.150
    91.219  1414.197     0.150
    91.219  1509.197     0.150
    91.219   782.697     0.150
    91.219    11.000     0.150
    91.454   784.396     0.150
    91.735   785.998     0.150
    91.735  1003.797     0.150
    91.750   786.098     0.150
    91.864   786.498     0.150
    91.864    10.100     0.150
    91.864  1004.098     0.150
    91.989   786.998     0.150
    91.989    11.799     0.150
    91.989  1006.197     0.150
    92.074   787.396     0.150
    92.074    10.000     0.150
    92.074  1005.896     0.150
    92.074   787.436     0.150
    92.375   789.191     0.150
    92.541   789.697     0.150
    92.541    10.301     0.150
    92.541  1009.598     0.150
    92.719   790.729     0.150
    92.792   790.998     0.150
    92.792    10.699     0.150
    92.792  1011.598     0.150
    92.789   789.098     0.150
    93.012   791.797     0.150
    93.048   791.498     0.150
    93.071   792.197     0.150
    93.192   793.197     0.150
    93.221   792.547     0.150
    93.221   792.146     0.150
    93.221    10.371     0.150
    93.288   793.197     0.150
    93.483   793.301     0.150
    93.719   794.926     0.150
    93.763   794.986     0.150
    93.763    15.012     0.150
    93.779   793.602     0.150
    94.026   796.527     0.150
    94.026  1020.117     0.150
    94.352   798.896     0.150
    94.352     9.701     0.150
    94.352  1025.598     0.150
    94.358   798.797     0.150
    94.358    14.500     0.150
    94.358  1023.998     0.150
    94.607   798.748     0.150
    94.645   799.518     0.150
    94.645  1025.217     0.150
    94.742   799.598     0.150
    94.735   799.697     0.150
    94.735   800.197     0.150
    95.170   801.896     0.150
    95.170    10.000     0.150
    95.170  1028.697     0.150
    95.968   805.998     0.150
    95.968    14.600     0.150
    95.968  1033.297     0.150
    96.089   806.297     0.150
    96.089    15.801     0.150
    96.381   807.697     0.150
    96.619   808.477     0.150
    96.799   808.396     0.150
    96.987   810.598     0.150
    96.987    11.799     0.150
    96.987    17.199     0.150
    96.987  1482.596     0.150
    97.195   810.896     0.150
    97.195   827.498     0.150
    97.301   810.922     0.150
    97.301  1811.146     0.150
    98.176   816.598     0.150
    98.176   827.197     0.150
    98.176  1056.598     0.150
    98.176  1451.596     0.150
    98.176  1906.096     0.150
    99.206   818.771     0.150
    99.206  1804.049     0.150
    99.218   818.797     0.150
    99.218  1061.098     0.150
   110.359  1110.797     0.150
   110.985  1768.119     0.150
   115.106  1186.498     0.150
   118.304  1129.297     0.150
   118.843  1130.197     0.150
   118.843  1211.697     0.150
   118.843  1345.197     0.150
   120.627  1130.297     0.150
   121.932  1132.697     0.150
   122.284  1133.697     0.150
   122.284  1232.797     0.150
   122.284  1348.697     0.150
   122.284  1560.498     0.150
   122.284  1639.799     0.150
   122.516  1134.098     0.150
   122.516  1144.797     0.150
   122.516  1134.373     0.150
   126.863  1141.498     0.150
   126.863  1356.697     0.150
   128.308  1145.297     0.150
   128.308  1157.197     0.150
   128.308  1145.557     0.150
   128.319  1145.396     0.150
   128.319  1145.531     0.150
   128.470  1144.660     0.150
   128.957  1146.822     0.150
   129.043  1146.957     0.150
   129.304   952.797     0.150
   129.304  1147.598     0.150
   129.304  1279.498     0.150
   129.304  1362.596     0.150
   129.304  1571.498     0.150
   129.304  1685.096     0.150
   129.304  1753.697     0.150
   132.315  1154.598     0.150
   132.315  1296.998     0.150
   136.299  1160.396     0.150
   142.054  1165.066     0.150
   144.573  1174.518     0.150
   145.580  1176.197     0.150
     0.168     5.396     0.150
     0.168     8.387     0.150
     1.064    20.037     0.150
     1.064    34.627     0.150
     1.533    27.957     0.150
     1.533    46.996     0.150
     1.440    25.346     0.150
     1.440    44.188     0.150
     1.987    33.916     0.150
     1.987    56.596     0.150
     2.365    40.156     0.150
     2.365    68.477     0.150
     2.367    39.688     0.150
     2.367    68.477     0.150
     2.523    41.387     0.150
     2.523    71.156     0.150
     2.780    45.496     0.150
     2.780    78.156     0.150
     2.926    46.727     0.150
     2.926    81.756     0.150
     3.236    51.688     0.150
     3.236    89.537     0.150
     3.351    53.516     0.150
     3.351    91.777     0.150
     4.454    70.527     0.150
     4.454   123.906     0.150
     5.004    75.576     0.150
     5.823    92.057     0.150
     6.696   100.877     0.150
     6.737   100.557     0.150
     7.915   117.697     0.150
     7.822   118.006     0.150
    11.175   161.596     0.150
    11.896   172.971     0.150
    12.735   184.352     0.150
    12.735   406.104     0.150
    12.709   184.117     0.150
    13.455   192.906     0.150
    13.505   191.557     0.150
    15.150   216.496     0.150
    15.538   223.586     0.150
    15.589   221.596     0.150
    15.649   223.037     0.150
    16.210   236.367     0.150
    16.592   235.486     0.150
    16.977   239.936     0.150
    17.111   241.514     0.150
    17.447   245.822     0.150
    17.497   242.387     0.150
    17.656   248.559     0.150
    17.532   250.137     0.150
    17.788   250.053     0.150
    17.899   248.496     0.150
    17.970   252.908     0.150
    18.083   253.666     0.150
    18.075   253.656     0.150
    18.099   254.076     0.150
    18.163   254.732     0.150
    18.200   255.137     0.150
    18.236   256.047     0.150
    18.229   255.742     0.150
    18.269   256.223     0.150
    18.377   257.631     0.150
    18.459   255.227     0.150
    18.470   258.367     0.150
    18.472   255.326     0.150
    18.734   260.982     0.150
    18.750   261.646     0.150
    18.782   261.227     0.150
    18.782   598.590     0.150
    18.782   261.107     0.150
    18.782   260.477     0.150
    18.806   262.654     0.150
    18.849   262.725     0.150
    18.968   264.057     0.150
    19.049   262.137     0.150
    19.112   265.430     0.150
    19.235   266.949     0.150
    19.229   266.277     0.150
    19.252   266.914     0.150
    19.544   269.703     0.150
    19.584   270.842     0.150
    19.696   271.832     0.150
    19.777   272.953     0.150
    19.879   273.814     0.150
    19.899   271.646     0.150
    19.930   270.896     0.150
    19.991   275.215     0.150
    20.016   275.225     0.150
    20.004   275.055     0.150
    20.126   276.830     0.150
    20.164   276.656     0.150
    20.295   278.010     0.150
    20.284   277.773     0.150
    20.372   279.219     0.150
    20.486   280.486     0.150
    20.551   281.283     0.150
    20.615   281.705     0.150
    20.735   283.627     0.150
    20.800   283.957     0.150
    20.818   283.932     0.150
    20.852   284.744     0.150
    20.943   284.557     0.150
    21.024   286.727     0.150
    21.134   288.141     0.150
    21.161   283.996     0.150
    21.145   287.551     0.150
    21.221   287.570     0.150
    21.237   286.977     0.150
    21.299   288.045     0.150
    21.295   289.219     0.150
    21.203   290.506     0.150
    21.359   289.746     0.150
    21.422   290.480     0.150
    21.460   290.807     0.150
    21.482   289.777     0.150
    21.482   289.926     0.150
    21.493   289.027     0.150
    21.545   292.021     0.150
    21.598   292.148     0.150
    21.626   293.104     0.150
    21.659   289.646     0.150
    21.636   293.002     0.150
    21.674   292.771     0.150
    21.727   290.537     0.150
    21.769   290.916     0.150
    21.792   294.629     0.150
    21.847   295.109     0.150
    21.864   294.176     0.150
    21.897   295.631     0.150
    21.984   291.826     0.150
    22.078   296.695     0.150
    22.057   297.070     0.150
    22.146   294.596     0.150
    22.172   297.102     0.150
    22.155   297.977     0.150
    22.155   298.607     0.150
    22.155   298.332     0.150
    22.160   298.414     0.150
    22.189   298.338     0.150
    22.197   295.477     0.150
    22.265   296.336     0.150
    22.339   299.801     0.150
    22.409   297.287     0.150
    22.404   299.910     0.150
    22.464   302.717     0.150
    22.494   301.805     0.150
    22.508   301.857     0.150
    22.542   301.969     0.150
    22.575   302.654     0.150
    22.604   298.656     0.150
    22.591   302.785     0.150
    22.640   302.633     0.150
    22.711   302.688     0.150
    22.721   301.896     0.150
    22.727   304.137     0.150
    22.787   301.826     0.150
    22.884   306.264     0.150
    22.926   304.977     0.150
    22.951   306.602     0.150
    22.999   305.668     0.150
    23.016   306.426     0.150
    23.063   303.977     0.150
    23.037   307.191     0.150
    23.065   307.400     0.150
    23.170   308.934     0.150
    23.213   309.291     0.150
    23.249   307.697     0.150
    23.226   309.291     0.150
    23.258   305.836     0.150
    23.222   308.932     0.150
    23.280   310.160     0.150
    23.305   308.717     0.150
    23.322   308.602     0.150
    23.308   309.926     0.150
    23.347   310.041     0.150
    23.361   310.570     0.150
    23.401   310.990     0.150
    23.545   312.156     0.150
    23.541   312.477     0.150
    23.559   312.656     0.150
    23.608   310.506     0.150
    23.596   313.236     0.150
    23.591   312.586     0.150
    23.623   309.576     0.150
    23.623   309.277     0.150
    23.639   313.219     0.150
    23.688   313.996     0.150
    23.706   313.438     0.150
    23.707   313.949     0.150
    23.728   312.912     0.150
    23.730   314.355     0.150
    23.828   315.188     0.150
    23.840   315.465     0.150
    23.863   314.396     0.150
    23.863   314.184     0.150
    23.868   314.205     0.150
    23.844   315.146     0.150
    23.912   315.441     0.150
    23.928   315.727     0.150
    23.953   314.396     0.150
    23.928   314.387     0.150
    23.949   316.148     0.150
    24.081   317.178     0.150
    24.101   315.217     0.150
    24.091   317.848     0.150
    24.107   316.406     0.150
    24.126   318.361     0.150
    24.141   315.477     0.150
    24.185   319.084     0.150
    24.200   318.633     0.150
    24.242   318.590     0.150
    24.262   318.074     0.150
    24.263   319.176     0.150
    24.316   320.008     0.150
    24.385   320.773     0.150
    24.409   317.316     0.150
    24.404   318.176     0.150
    24.382   319.355     0.150
    24.429   320.131     0.150
    24.446   320.943     0.150
    24.487   321.787     0.150
    24.487   321.975     0.150
    24.489   321.541     0.150
    24.527   320.699     0.150
    24.618   322.533     0.150
    24.685   321.637     0.150
    24.699   323.250     0.150
    24.716   323.354     0.150
    24.752   322.820     0.150
    24.773   323.711     0.150
    24.775   324.383     0.150
    24.773   324.227     0.150
    24.790   324.381     0.150
    24.890   324.412     0.150
    24.914   324.730     0.150
    25.052   326.477     0.150
    25.053   326.443     0.150
    25.097   325.746     0.150
    25.066   326.572     0.150
    25.104   324.047     0.150
    25.095   327.188     0.150
    25.109   327.465     0.150
    25.177   326.936     0.150
    25.207   327.855     0.150
    25.256   328.447     0.150
    25.279   328.426     0.150
    25.255   328.770     0.150
    25.304   325.688     0.150
    25.310   327.473     0.150
    25.382   328.916     0.150
    25.411   330.209     0.150
    25.472   330.461     0.150
    25.474   330.316     0.150
    25.456   330.578     0.150
    25.514   329.527     0.150
    25.552   328.316     0.150
    25.552   331.432     0.150
    25.583   331.061     0.150
    25.580   331.301     0.150
    25.624   331.152     0.150
    25.634   331.406     0.150
    25.621   332.539     0.150
    25.663   330.367     0.150
    25.680   330.746     0.150
    25.696   332.047     0.150
    25.687   332.572     0.150
    25.766   332.367     0.150
    25.787   333.146     0.150
    25.763   333.568     0.150
    25.840   331.791     0.150
    25.811   333.637     0.150
    25.845   334.277     0.150
    25.895   333.855     0.150
    25.935   333.377     0.150
    26.021   335.775     0.150
    26.031   335.240     0.150
    26.021   335.727     0.150
    26.057   334.215     0.150
    26.139   335.568     0.150
    26.215   336.047     0.150
    26.204   336.951     0.150
    26.207   337.035     0.150
    26.274   336.143     0.150
    26.304   337.871     0.150
    26.346   337.738     0.150
    26.353   337.357     0.150
    26.370   339.062     0.150
    26.408   339.125     0.150
    26.420   339.072     0.150
    26.441   336.766     0.150
    26.441     7.701     0.150
    26.421   338.021     0.150
    26.458   338.227     0.150
    26.458   339.271     0.150
    26.484   339.166     0.150
    26.508   340.074     0.150
    26.621   339.770     0.150
    26.619   338.646     0.150
    26.624   340.969     0.150
    26.671   341.852     0.150
    26.671   544.840     0.150
    26.671   855.152     0.150
    26.683   341.330     0.150
    26.682   341.549     0.150
    26.738   341.469     0.150
    26.734   341.574     0.150
    26.785   341.277     0.150
    26.803   342.689     0.150
    26.846   339.787     0.150
    26.846     7.340     0.150
    26.901   341.586     0.150
    26.949   342.188     0.150
    26.949     6.359     0.150
    26.949   342.350     0.150
    26.949   342.127     0.150
    26.949   543.328     0.150
    26.947   343.785     0.150
    26.974   343.127     0.150
    27.015   343.717     0.150
    27.014   343.773     0.150
    27.063   344.652     0.150
    27.063   851.852     0.150
    27.070   344.516     0.150
    27.083   344.018     0.150
    27.049   346.227     0.150
    27.239   346.285     0.150
    27.272   344.996     0.150
    27.291   346.787     0.150
    27.312   346.865     0.150
    27.332   346.793     0.150
    27.329   347.867     0.150
    27.370   346.688     0.150
    27.349   348.088     0.150
    27.353   347.242     0.150
    27.402   347.188     0.150
    27.240   349.756     0.150
    27.496   348.168     0.150
    27.515   348.898     0.150
    27.533   346.256     0.150
    27.522   348.426     0.150
    27.577   348.359     0.150
    27.588   349.135     0.150
    27.486   348.047     0.150
    27.519   349.188     0.150
    27.680   350.086     0.150
    27.702   350.045     0.150
    27.740   350.137     0.150
    27.811   350.129     0.150
    27.803   351.891     0.150
    27.831   350.750     0.150
    27.849   350.496     0.150
    27.865   351.902     0.150
    27.891   350.904     0.150
    27.915   351.277     0.150
    27.968   352.166     0.150
    27.987   352.010     0.150
    27.995   351.787     0.150
    28.013   351.877     0.150
    27.988   353.410     0.150
    28.011   352.922     0.150
    28.039   354.215     0.150
    28.079   354.439     0.150
    28.157   353.926     0.150
    28.156   353.787     0.150
    28.154   354.125     0.150
    27.983   356.688     0.150
    28.177   353.156     0.150
    28.182   355.576     0.150
    28.241   354.590     0.150
    28.223   355.078     0.150
    28.257   355.311     0.150
    28.266   355.250     0.150
    28.291   355.008     0.150
    28.323   356.646     0.150
    28.352   355.186     0.150
    28.368   355.477     0.150
    28.383   356.326     0.150
    28.429   357.414     0.150
    28.465   357.084     0.150
    28.501   356.688     0.150
    28.532   357.352     0.150
    28.570   355.877     0.150
    28.576   358.584     0.150
    28.637   357.916     0.150
    28.669   357.527     0.150
    28.507   357.727     0.150
    28.685   358.961     0.150
    28.734   358.803     0.150
    28.750   360.232     0.150
    28.616   359.996     0.150
    28.784   359.943     0.150
    28.809   360.801     0.150
    28.847   361.217     0.150
    28.854   362.066     0.150
    28.840   360.510     0.150
    28.864   361.854     0.150
    28.911   359.057     0.150
    28.910   360.428     0.150
    28.928   360.543     0.150
    28.932   361.264     0.150
    29.020   361.344     0.150
    29.059   362.557     0.150
    29.043   362.547     0.150
    29.053   362.938     0.150
    29.053   362.375     0.150
    29.075   361.697     0.150
    29.085   362.324     0.150
    29.103   361.156     0.150
    29.103   361.617     0.150
    29.133   362.420     0.150
    29.152   363.211     0.150
    29.156   362.727     0.150
    29.151   362.928     0.150
    29.135   362.938     0.150
    29.175   364.076     0.150
    29.198   362.922     0.150
    29.188   363.830     0.150
    29.204   364.273     0.150
    29.277   365.145     0.150
    29.355   363.359     0.150
    29.362   364.617     0.150
    29.430   365.311     0.150
    29.518   366.125     0.150
    29.521   367.006     0.150
    29.550   366.148     0.150
    29.591   366.598     0.150
    29.616   366.924     0.150
    29.640   367.195     0.150
    29.727   368.361     0.150
    29.740   368.385     0.150
    29.720   369.627     0.150
    29.720   368.844     0.150
    29.770   368.516     0.150
    29.827   367.666     0.150
    29.834   369.107     0.150
    29.915   370.152     0.150
    29.916   369.438     0.150
    29.928   369.582     0.150
    29.946   369.025     0.150
    29.971   370.354     0.150
    29.955   371.346     0.150
    30.022   370.561     0.150
    30.033   371.188     0.150
    30.068   369.586     0.150
    30.085   371.191     0.150
    30.127   371.287     0.150
    30.166   371.457     0.150
    30.174   371.932     0.150
    30.181   371.666     0.150
    30.267   372.723     0.150
    30.299   372.689     0.150
    30.288   372.697     0.150
    30.288   373.135     0.150
    30.350   373.967     0.150
    30.396   374.105     0.150
    30.419   372.596     0.150
    30.443   374.129     0.150
    30.473   376.217     0.150
    30.494   374.793     0.150
    30.490   373.576     0.150
    30.496   376.256     0.150
    30.589   375.285     0.150
    30.582   375.668     0.150
    30.617   374.873     0.150
    30.720   376.430     0.150
    30.736   376.105     0.150
    30.575   374.797     0.150
    30.753   376.623     0.150
    30.775   376.922     0.150
    30.817   377.104     0.150
    30.897   377.783     0.150
    30.910   379.410     0.150
    30.962   378.557     0.150
    31.007   378.533     0.150
    31.069   379.555     0.150
    31.094   379.715     0.150
    31.078   380.572     0.150
    31.165   379.848     0.150
    31.190   380.025     0.150
    31.212   380.857     0.150
    31.197   381.238     0.150
    31.226   380.068     0.150
    31.238   381.637     0.150
    31.249   381.006     0.150
    31.317   381.277     0.150
    31.333   381.096     0.150
    31.345   381.057     0.150
    31.367   382.166     0.150
    31.351   383.496     0.150
    31.400   381.715     0.150
    31.389   381.277     0.150
    31.410   382.113     0.150
    31.441   381.117     0.150
    31.437   381.920     0.150
    31.597   383.617     0.150
    31.597   383.162     0.150
    31.605   384.115     0.150
    31.609   383.967     0.150
    31.633   383.916     0.150
    31.633   383.867     0.150
    31.699   384.137     0.150
    31.783   385.037     0.150
    31.791   385.182     0.150
    31.815   385.420     0.150
    31.814   385.803     0.150
    31.873   385.635     0.150
    31.906   386.357     0.150
    31.889   388.027     0.150
    31.889     7.080     0.150
    31.969   387.166     0.150
    31.969   386.836     0.150
    32.008   386.898     0.150
    32.041   387.730     0.150
    32.051   387.402     0.150
    32.140   388.316     0.150
    32.140   388.451     0.150
    32.160   388.789     0.150
    32.204   388.877     0.150
    32.215   388.381     0.150
    32.227   390.488     0.150
    32.250   389.496     0.150
    32.283   389.707     0.150
    32.300   389.500     0.150
    32.353   390.389     0.150
    32.397   390.361     0.150
    32.466   392.043     0.150
    32.489   391.799     0.150
    32.532   391.176     0.150
    32.541   391.158     0.150
    32.530   391.922     0.150
    32.534   394.137     0.150
    32.563   391.887     0.150
    32.627   393.066     0.150
    32.643   392.158     0.150
    32.645   393.957     0.150
    32.695   392.596     0.150
    32.766   393.236     0.150
    32.820   394.498     0.150
    32.850   392.227     0.150
    32.859   393.998     0.150
    32.860   393.932     0.150
    32.883   394.457     0.150
    32.999   396.475     0.150
    33.015   396.375     0.150
    32.948   395.877     0.150
    33.048   395.234     0.150
    33.047   398.707     0.150
    33.047     7.109     0.150
    33.077   396.596     0.150
    33.074   398.449     0.150
    33.112   396.607     0.150
    33.161   396.791     0.150
    33.190   397.277     0.150
    33.242   397.893     0.150
    33.241   398.146     0.150
    33.289   398.984     0.150
    33.288   398.934     0.150
    33.320   399.430     0.150
    33.376   397.426     0.150
    33.376   396.707     0.150
    33.454   400.010     0.150
    33.484   400.066     0.150
    33.498   400.668     0.150
    33.509   400.297     0.150
    33.525   399.898     0.150
    33.541   400.172     0.150
    33.532   401.646     0.150
    33.569   400.244     0.150
    33.585   401.912     0.150
    33.713   401.939     0.150
    33.749   403.260     0.150
    33.748   403.246     0.150
    33.795   402.229     0.150
    33.810   403.793     0.150
    33.820   403.320     0.150
    33.872   403.590     0.150
    33.883   404.902     0.150
    33.922   404.336     0.150
    33.945   404.438     0.150
    33.995   403.938     0.150
    34.085   405.193     0.150
    34.155   407.443     0.150
    34.181   407.006     0.150
    34.181   406.377     0.150
    34.197   407.568     0.150
    34.277   407.924     0.150
    34.305   407.162     0.150
    34.314   407.502     0.150
    34.346   407.949     0.150
    34.427   407.516     0.150
    34.448   408.723     0.150
    34.543   409.250     0.150
    34.543   410.084     0.150
    34.666   410.533     0.150
    34.662   411.164     0.150
    34.712   412.027     0.150
    34.754   411.783     0.150
    34.789   411.826     0.150
    34.866   413.271     0.150
    34.947   412.654     0.150
    34.987   413.945     0.150
    35.034   413.754     0.150
    35.123   415.496     0.150
    35.132   415.008     0.150
    35.270   416.238     0.150
    35.289   415.758     0.150
    35.407   416.715     0.150
    35.411   416.645     0.150
    35.421   417.773     0.150
    35.511   417.947     0.150
    35.781   419.957     0.150
    35.852   421.754     0.150
    35.902   420.857     0.150
    35.939   421.416     0.150
    35.962   421.760     0.150
    35.984   421.475     0.150
    35.995   422.066     0.150
    36.026   421.621     0.150
    36.105   423.467     0.150
    36.451   425.607     0.150
    36.453   426.691     0.150
    36.607   426.906     0.150
    36.635   427.682     0.150
    36.833   430.195     0.150
    36.888   430.377     0.150
    37.636   434.986     0.150
    37.711   435.576     0.150
    37.711   434.807     0.150
    45.673   503.051     0.150
    46.601   507.072     0.150
    46.923   512.916     0.150
    46.923     7.441     0.150
    47.174   936.277     0.150
    49.561   532.166     0.150
    51.256   545.646     0.150
    51.290   546.938     0.150
    52.430  1009.477     0.150
    54.110   565.607     0.150
    55.158   573.246     0.150
    55.511   575.506     0.150
    55.708   576.877     0.150
    55.708     7.750     0.150
    56.138   580.227     0.150
    56.239   581.516     0.150
    56.263   582.277     0.150
    56.299   581.416     0.150
    56.307   581.676     0.150
    57.310   588.547     0.150
    57.517   589.717     0.150
    57.689   591.547     0.150
    57.800   590.617     0.150
    57.987   593.076     0.150
    58.181   594.688     0.150
    58.279   594.906     0.150
    58.690   597.266     0.150
    58.865   599.277     0.150
    59.590   604.957     0.150
    59.579  1103.977     0.150
    60.225   607.697     0.150
    60.745   613.646     0.150
    62.695  1143.477     0.150
    63.635   633.502     0.150
    65.581   644.047     0.150
    65.581     8.600     0.150
    67.240   653.576     0.150
    75.686   707.047     0.150
    75.686   706.076     0.150
    75.686  1279.076     0.150
    81.114   735.867     0.150
    81.233   735.576     0.150
    81.893   740.607     0.150
    81.933   740.596     0.150
    82.283   742.756     0.150
    82.436   741.977     0.150
    82.452   743.496     0.150
    82.750   744.777     0.150
    82.750   744.676     0.150
    83.195  1368.377     0.150
    83.195  1419.777     0.150
    83.195  1692.176     0.150
    83.305   747.527     0.150
    83.322   748.346     0.150
    83.322   748.746     0.150
    83.478   748.176     0.150
    83.598   748.977     0.150
    83.710   750.477     0.150
    83.709   749.926     0.150
    83.878   750.277     0.150
    83.933   751.057     0.150
    83.957   751.490     0.150
    83.957   750.857     0.150
    83.957   750.877     0.150
    84.243   753.527     0.150
    84.500   753.076     0.150
    84.530   754.857     0.150
    84.550   756.137     0.150
    84.652   754.438     0.150
    84.882   755.377     0.150
    84.959   757.826     0.150
    85.007   757.227     0.150
    85.071   756.576     0.150
    85.185   758.076     0.150
    85.177   757.896     0.150
    85.349   759.656     0.150
    85.413   757.977     0.150
    85.534   760.146     0.150
    85.631   758.676     0.150
    85.673   759.451     0.150
    85.823   760.977     0.150
    85.971   762.076     0.150
    85.994   760.576     0.150
    86.025   760.477     0.150
    86.034   760.777     0.150
    86.058   762.676     0.150
    86.073   760.777     0.150
    86.067   762.076     0.150
    86.141   760.877     0.150
    86.184   763.297     0.150
    86.295   763.756     0.150
    86.386   762.576     0.150
    86.457   762.277     0.150
    86.520   762.777     0.150
    86.543   764.357     0.150
    86.673   761.777     0.150
    86.699   763.277     0.150
    86.699   763.176     0.150
    86.847   764.377     0.150
    86.851   764.877     0.150
    87.019   767.646     0.150
    87.065   764.877     0.150
    87.075   766.617     0.150
    87.178   766.176     0.150
    87.194   767.176     0.150
    87.293   767.076     0.150
    87.874   769.277     0.150
    87.917   770.076     0.150
    88.122   769.977     0.150
    88.476   772.277     0.150
    88.509   771.576     0.150
    88.510   773.076     0.150
    88.527   771.777     0.150
    88.535   773.076     0.150
    88.680   773.777     0.150
    89.192   774.877     0.150
    89.357   776.676     0.150
    89.699   777.877     0.150
    90.320   781.977     0.150
    90.320     9.600     0.150
    90.320   781.977     0.150
    90.320     9.600     0.150
    90.577   781.977     0.150
    90.577  1448.977     0.150
    90.577   782.377     0.150
    90.577   997.977     0.150
    90.577  1411.977     0.150
    90.647   782.877     0.150
    90.708   783.477     0.150
    90.774   782.977     0.150
    90.854   783.877     0.150
    90.957   784.477     0.150
    91.306   785.377     0.150
    91.533   787.676     0.150
    91.943   788.676     0.150
    91.943    11.500     0.150
    92.035   788.877     0.150
    92.035  1009.576     0.150
    92.035  1418.777     0.150
    92.035  1451.076     0.150
    92.074     9.602     0.150
    92.152   789.977     0.150
    92.152   790.264     0.150
    92.630  1012.576     0.150
    92.881   793.676     0.150
    92.881     7.900     0.150
    92.881  1015.176     0.150
    93.075   794.701     0.150
    94.836   802.477     0.150
    95.974   805.277     0.150
    97.194   812.777     0.150
    97.258   814.797     0.150
    99.321   821.551     0.150
    99.362   820.977     0.150
    99.362   821.877     0.150
    99.362  1063.377     0.150
    99.362  1608.676     0.150
    99.362  1914.377     0.150
   103.340   838.576     0.150
   103.830   842.977     0.150
   103.830  1099.076     0.150
   109.250  1133.102     0.150
   113.978   890.277     0.150
   113.978  1174.277     0.150
   113.978  1538.076     0.150
   115.397  1126.576     0.150
   115.397  1191.176     0.150
   115.397  1553.977     0.150
   115.397  1599.076     0.150
   115.397  2140.277     0.150
   116.503  1184.752     0.150
   116.503  1755.402     0.150
   117.125  1782.977     0.150
   117.125  2168.977     0.150
   119.097  1130.977     0.150
   119.097  1214.977     0.150
   119.097  1555.977     0.150
   119.097  1619.977     0.150
   119.097  2184.977     0.150
   120.907  1134.377     0.150
   120.907  1562.676     0.150
   120.907  1634.377     0.150
   120.907  2208.676     0.150
   122.283  1135.777     0.150
   122.571  1135.977     0.150
   122.571  1235.176     0.150
   122.571  1560.676     0.150
   122.571  1641.277     0.150
   122.571  2226.576     0.150
   122.569  1136.877     0.150
   127.154  1146.176     0.150
   127.154  1263.277     0.150
   127.154  1361.377     0.150
   127.154  1572.877     0.150
   128.211  1146.539     0.150
   128.434  1148.477     0.150
   128.434  1146.676     0.150
   128.445  1148.061     0.150
   129.147  1149.477     0.150
   129.599   956.176     0.150
   129.599  1150.676     0.150
   129.599  1282.676     0.150
   129.599  1365.777     0.150
   129.599  1574.176     0.150
   129.599  1688.877     0.150
   132.112  1152.377     0.150
   132.608  1155.777     0.150
   132.608  1302.877     0.150
   132.608  1706.377     0.150
   132.608  2351.676     0.150
   136.141  1160.996     0.150
   138.794  1167.797     0.150
   139.968  1167.057     0.150
   140.117  1169.377     0.150
   145.366  1179.047     0.150
   145.483  1178.777     0.150
   145.809  1179.477     0.150
   148.894  1190.217     0.150
   153.139  1199.287     0.150
     0.154     6.413     0.150
     0.154    10.113     0.150
     0.397     9.803     0.150
     0.397    15.723     0.150
     0.424    10.223     0.150
     1.212    21.473     0.150
     1.212    36.953     0.150
     1.318    22.513     0.150
     1.318    38.583     0.150
     1.377    24.192     0.150
     1.377    41.453     0.150
     1.671    28.283     0.150
     1.671    48.633     0.150
     1.889    31.643     0.150
     2.143    34.562     0.150
     2.143    59.513     0.150
     2.280    37.793     0.150
     2.280    65.353     0.150
     2.498    40.812     0.150
     2.498    69.873     0.150
     2.559    40.923     0.150
     2.559    71.732     0.150
     2.644    42.482     0.150
     2.644    74.373     0.150
     2.682    43.223     0.150
     2.682    75.933     0.150
     2.843    45.103     0.150
     2.843    79.613     0.150
     2.892    46.663     0.150
     2.892    79.713     0.150
     2.910    46.353     0.150
     2.910    80.723     0.150
     2.946    45.713     0.150
     2.946    81.713     0.150
     3.025    48.103     0.150
     3.025    82.442     0.150
     3.071    48.583     0.150
     3.071    85.013     0.150
     3.185    49.223     0.150
     3.185    86.973     0.150
     3.217    48.883     0.150
     3.217    86.503     0.150
     3.418    53.253     0.150
     3.418    92.293     0.150
     3.427    53.123     0.150
     3.427    91.763     0.150
     3.593    55.573     0.150
     3.593    98.153     0.150
     4.170   110.843     0.150
     4.178    63.623     0.150
     4.178   110.713     0.150
     5.186    76.748     0.150
     5.186   130.801     0.150
     5.186   159.323     0.150
     5.186    77.183     0.150
     5.186   136.833     0.150
     5.198    76.893     0.150
     5.198   136.473     0.150
     5.748    84.423     0.150
     5.748   149.383     0.150
     6.219    91.312     0.150
     6.219   161.703     0.150
     8.000   116.982     0.150
     8.000   206.683     0.150
    10.830   156.143     0.150
    11.781   170.111     0.150
    11.873   166.596     0.150
    11.873   166.183     0.150
    11.873   297.843     0.150
    12.461   177.900     0.150
    12.561   179.145     0.150
    12.754   182.989     0.150
    12.760   183.423     0.150
    12.760   405.975     0.150
    12.815   183.477     0.150
    12.871   184.093     0.150
    13.080   187.660     0.150
    13.176   188.015     0.150
    13.209   188.181     0.150
    13.226   189.903     0.150
    13.284   191.242     0.150
    13.399   192.865     0.150
    13.532   194.047     0.150
    13.555   195.558     0.150
    13.622   193.963     0.150
    13.727   195.659     0.150
    13.744   196.247     0.150
    13.854   198.441     0.150
    13.924   197.593     0.150
    13.938   199.731     0.150
    14.126   202.157     0.150
    14.176   203.426     0.150
    14.348   203.217     0.150
    14.431   203.036     0.150
    14.467   204.867     0.150
    14.473   205.867     0.150
    14.600   207.624     0.150
    14.606   207.188     0.150
    14.741   210.007     0.150
    14.944   211.375     0.150
    14.973   210.982     0.150
    15.024   213.616     0.150
    15.229   216.672     0.150
    15.248   216.492     0.150
    15.292   216.578     0.150
    15.297   216.231     0.150
    15.659   223.263     0.150
    15.671   220.449     0.150
    15.676   221.772     0.150
    15.692   221.632     0.150
    15.730   220.656     0.150
    15.781   221.770     0.150
    15.837   223.204     0.150
    15.953   224.056     0.150
    16.038   225.417     0.150
    16.181   227.510     0.150
    16.208   229.456     0.150
    16.293   232.628     0.150
    16.293   231.812     0.150
    16.337   228.347     0.150
    16.342   228.371     0.150
    16.349   229.924     0.150
    16.411   231.342     0.150
    16.430   230.420     0.150
    16.504   232.685     0.150
    16.568   234.287     0.150
    16.572   232.628     0.150
    16.639   232.556     0.150
    16.702   234.266     0.150
    16.792   233.269     0.150
    16.937   234.934     0.150
    16.977   238.625     0.150
    16.988   238.736     0.150
    17.031   237.419     0.150
    17.111   238.144     0.150
    17.146   238.445     0.150
    17.151   240.511     0.150
    17.248   240.723     0.150
    17.310   242.807     0.150
    17.362   243.112     0.150
    17.408   242.741     0.150
    17.521   242.780     0.150
    17.575   244.896     0.150
    17.631   244.723     0.150
    17.641   246.964     0.150
    17.643   243.003     0.150
    17.734   247.742     0.150
    17.796   248.561     0.150
    17.820   244.812     0.150
    17.854   247.547     0.150
    17.860   247.641     0.150
    17.956   248.232     0.150
    17.956   247.961     0.150
    17.987   249.224     0.150
    17.995   251.147     0.150
    18.046   251.503     0.150
    18.096   251.933     0.150
    18.190   250.796     0.150
    18.260   252.157     0.150
    18.282   255.692     0.150
    18.365   253.196     0.150
    18.384   254.265     0.150
    18.430   256.365     0.150
    18.479   257.062     0.150
    18.538   256.595     0.150
    18.579   254.613     0.150
    18.621   256.543     0.150
    18.720   259.483     0.150
    18.799   260.073     0.150
    18.799   596.723     0.150
    18.799   259.723     0.150
    18.803   260.914     0.150
    18.801   259.469     0.150
    18.856   258.844     0.150
    18.925   261.165     0.150
    19.045   263.436     0.150
    19.078   261.647     0.150
    19.176   261.723     0.150
    19.253   263.351     0.150
    19.269   264.075     0.150
    19.358   266.239     0.150
    19.490   267.203     0.150
    19.572   268.660     0.150
    19.577   268.431     0.150
    19.660   268.504     0.150
    19.765   269.551     0.150
    19.833   270.773     0.150
    19.931   271.412     0.150
    19.933   272.229     0.150
    19.966   274.040     0.150
    20.008   273.270     0.150
    20.049   273.278     0.150
    20.057   271.673     0.150
    20.073   272.493     0.150
    20.104   275.712     0.150
    20.181   275.185     0.150
    20.257   276.099     0.150
    20.408   276.145     0.150
    20.451   278.536     0.150
    20.488   278.151     0.150
    20.520   278.060     0.150
    20.533   278.420     0.150
    20.693   279.968     0.150
    20.728   280.819     0.150
    20.749   282.593     0.150
    20.749   282.700     0.150
    20.834   281.003     0.150
    20.872   282.243     0.150
    20.874   282.650     0.150
    21.003   282.968     0.150
    21.008   284.343     0.150
    21.008   285.134     0.150
    21.014   283.724     0.150
    21.100   285.903     0.150
    21.113   284.562     0.150
    21.219   287.924     0.150
    21.319   287.856     0.150
    21.330   286.940     0.150
    21.350   287.883     0.150
    21.421   286.595     0.150
    21.458   287.486     0.150
    21.492   288.753     0.150
    21.502   287.950     0.150
    21.547   290.373     0.150
    21.551   289.512     0.150
    21.575   291.741     0.150
    21.584   291.022     0.150
    21.631   287.833     0.150
    21.670   290.033     0.150
    21.713   290.983     0.150
    21.745   293.113     0.150
    21.762   291.434     0.150
    21.813   293.729     0.150
    21.866   289.623     0.150
    21.927   294.851     0.150
    21.995   294.365     0.150
    22.027   294.646     0.150
    22.099   297.303     0.150
    22.099   296.808     0.150
    22.108   296.519     0.150
    22.125   294.619     0.150
    22.127   294.647     0.150
    22.129   292.953     0.150
    22.171   296.643     0.150
    22.207   295.737     0.150
    22.301   295.013     0.150
    22.317   297.367     0.150
    22.356   296.033     0.150
    22.367   297.876     0.150
    22.365   295.923     0.150
    22.371   298.732     0.150
    22.405   297.792     0.150
    22.423   300.993     0.150
    22.454   298.057     0.150
    22.496   300.414     0.150
    22.531   301.476     0.150
    22.636   300.551     0.150
    22.664   300.363     0.150
    22.708   301.303     0.150
    22.731   301.003     0.150
    22.737   300.745     0.150
    22.765   301.724     0.150
    22.784   301.249     0.150
    22.902   304.737     0.150
    22.911   303.752     0.150
    22.921   302.093     0.150
    23.127   307.196     0.150
    23.221   305.853     0.150
    23.284   306.933     0.150
    23.284   306.801     0.150
    23.287   306.574     0.150
    23.306   307.340     0.150
    23.390   307.908     0.150
    23.409   307.212     0.150
    23.510   311.093     0.150
    23.511   308.794     0.150
    23.599   310.308     0.150
    23.664   312.514     0.150
    23.737   311.217     0.150
    23.783   309.913     0.150
    23.809   313.232     0.150
    23.808   312.141     0.150
    23.867   312.683     0.150
    23.867   313.055     0.150
    23.883   313.506     0.150
    23.893   314.745     0.150
    23.904   313.103     0.150
    23.911   313.681     0.150
    23.920   314.763     0.150
    23.925   314.853     0.150
    24.054   314.320     0.150
    24.082   316.043     0.150
    24.133   317.203     0.150
    24.160   316.338     0.150
    24.174   315.430     0.150
    24.249   317.105     0.150
    24.265   317.075     0.150
    24.282   317.323     0.150
    24.311   316.703     0.150
    24.403   319.511     0.150
    24.407   317.958     0.150
    24.409   318.001     0.150
    24.441   320.202     0.150
    24.498   318.696     0.150
    24.542   319.895     0.150
    24.553   318.243     0.150
    24.561   318.272     0.150
    24.586   320.414     0.150
    24.667   320.305     0.150
    24.719   323.243     0.150
    24.724   320.613     0.150
    24.795   321.476     0.150
    24.827   322.161     0.150
    24.920   323.624     0.150
    24.928   323.082     0.150
    25.017   323.799     0.150
    25.046   326.364     0.150
    25.052   324.623     0.150
    25.067   326.407     0.150
    25.114   325.087     0.150
    25.179   325.945     0.150
    25.199   327.486     0.150
    25.229   327.190     0.150
    25.283   327.663     0.150
    25.364   326.989     0.150
    25.429   325.053     0.150
    25.556   328.423     0.150
    25.580   329.697     0.150
    25.596   330.425     0.150
    25.629   330.033     0.150
    25.629   329.821     0.150
    25.632   330.066     0.150
    25.682   329.734     0.150
    25.959   332.438     0.150
    26.067   333.482     0.150
    26.137   334.588     0.150
    26.171   334.001     0.150
    26.214   334.662     0.150
    26.220   335.457     0.150
    26.293   335.276     0.150
    26.306   336.320     0.150
    26.330   336.359     0.150
    26.464   337.953     0.150
    26.557   339.022     0.150
    26.622   338.679     0.150
    26.632   340.423     0.150
    26.782   339.083     0.150
    26.934   339.323     0.150
    26.969   341.603     0.150
    26.969   340.760     0.150
    26.969   341.522     0.150
    26.972   341.690     0.150
    27.015   342.593     0.150
    27.055   342.042     0.150
    27.075   341.843     0.150
    27.086   342.448     0.150
    27.154   346.863     0.150
    27.189   343.397     0.150
    27.415   345.256     0.150
    27.477   345.705     0.150
    27.503   345.956     0.150
    27.745   348.840     0.150
    27.770   348.616     0.150
    27.826   349.272     0.150
    27.832   349.321     0.150
    27.995   350.439     0.150
    27.998   350.752     0.150
    28.223   352.384     0.150
    28.309   353.560     0.150
    28.359   354.289     0.150
    28.639   356.279     0.150
    28.639   356.632     0.150
    29.054   359.146     0.150
    29.130   360.743     0.150
    29.130   360.283     0.150
    29.155   361.473     0.150
    29.155   361.668     0.150
    29.157   360.703     0.150
    29.364   363.469     0.150
    29.542   365.073     0.150
    29.542   364.627     0.150
    29.555   364.136     0.150
    29.612   365.524     0.150
    29.747   367.016     0.150
    29.829   366.025     0.150
    29.850   367.918     0.150
    29.972   368.129     0.150
    29.985   368.699     0.150
    30.090   368.104     0.150
    30.144   370.353     0.150
    30.174   370.920     0.150
    30.189   371.082     0.150
    30.194   370.963     0.150
    30.231   369.865     0.150
    30.312   370.972     0.150
    30.317   370.726     0.150
    30.340   371.870     0.150
    30.448   372.762     0.150
    30.557   372.722     0.150
    30.574   374.403     0.150
    30.590   373.264     0.150
    30.603   373.601     0.150
    30.643   373.938     0.150
    30.737   374.191     0.150
    30.759   374.876     0.150
    30.799   374.762     0.150
    30.843   376.330     0.150
    31.006   376.597     0.150
    31.026   377.272     0.150
    31.082   377.476     0.150
    31.101   377.992     0.150
    31.180   378.180     0.150
    31.219   379.249     0.150
    31.231   379.772     0.150
    31.325   379.713     0.150
    31.348   380.069     0.150
    31.369   380.112     0.150
    31.380   380.366     0.150
    31.412   381.021     0.150
    31.458   380.934     0.150
    31.527   380.343     0.150
    31.585   382.194     0.150
    31.642   382.836     0.150
    31.716   383.684     0.150
    31.840   384.367     0.150
    31.917   385.713     0.150
    31.917   385.221     0.150
    32.021   386.101     0.150
    32.085   386.315     0.150
    32.164   385.843     0.150
    32.226   387.543     0.150
    32.260   387.488     0.150
    32.309   388.562     0.150
    32.337   388.759     0.150
    32.416   389.741     0.150
    32.463   389.487     0.150
    32.472   389.771     0.150
    32.500   389.947     0.150
    32.547   390.456     0.150
    32.550   390.982     0.150
    32.681   391.048     0.150
    32.715   392.415     0.150
    32.870   393.203     0.150
    32.903   393.364     0.150
    33.069   394.982     0.150
    33.129   395.744     0.150
    33.169   396.109     0.150
    33.267   396.740     0.150
    33.461   396.448     0.150
    33.461   396.293     0.150
    33.467   398.624     0.150
    33.530   398.806     0.150
    33.562   399.104     0.150
    33.731   400.975     0.150
    33.881   402.653     0.150
    33.959   403.131     0.150
    34.184   405.073     0.150
    34.184   405.370     0.150
    34.315   406.275     0.150
    37.776   434.073     0.150
    45.752   502.448     0.150
    45.759   500.147     0.150
    45.759   499.423     0.150
    46.641   506.518     0.150
    46.707   506.573     0.150
    55.534   574.583     0.150
    57.114   586.323     0.150
    57.204   587.623     0.150
    57.875   589.703     0.150
    59.919   605.223     0.150
    60.867   612.893     0.150
    65.699   643.213     0.150
    65.699   642.423     0.150
    82.126   738.923     0.150
    83.648   747.423     0.150
    83.768   748.223     0.150
    84.048   749.423     0.150
    84.139   749.948     0.150
    85.591   757.123     0.150
    85.806   757.923     0.150
    86.171   759.723     0.150
    86.199   759.522     0.150
    86.201   759.723     0.150
    86.313   760.022     0.150
    86.871   762.423     0.150
    86.870   762.623     0.150
    87.018   763.723     0.150
    88.446   771.323     0.150
    89.214   774.522     0.150
   128.256  1146.408     0.150
     0.682    13.848     0.150
     0.682    22.086     0.150
     1.012    19.137     0.150
     1.012    32.676     0.150
     1.475    44.547     0.150
     1.553    26.766     0.150
     1.553    46.715     0.150
     1.939    31.645     0.150
     1.939    55.078     0.150
     2.000    33.125     0.150
     2.000    59.406     0.150
     2.326    38.156     0.150
     2.326    67.055     0.150
     2.435    39.957     0.150
     2.435    69.957     0.150
     2.586    41.816     0.150
     2.586    73.695     0.150
     2.719    45.008     0.150
     2.719    76.996     0.150
     3.412    53.945     0.150
     3.412    93.617     0.150
     3.512    55.227     0.150
     3.854    58.676     0.150
     3.854   102.625     0.150
     4.487    67.855     0.150
     4.487   116.508     0.150
     4.487   139.105     0.150
     4.607   122.957     0.150
     4.763    73.656     0.150
     4.763   125.285     0.150
     5.805    86.816     0.150
     5.805   151.887     0.150
     6.175    92.516     0.150
     6.175   162.926     0.150
     6.240    92.797     0.150
     6.240   162.566     0.150
     6.476    96.617     0.150
     7.154   106.355     0.150
     7.304   108.266     0.150
     7.950   119.395     0.150
     8.065   121.426     0.150
     8.755   131.484     0.150
     8.972   130.926     0.150
     9.196   138.328     0.150
     9.675   141.805     0.150
     9.923   146.816     0.150
    10.027   147.957     0.150
    10.073   149.316     0.150
    10.144   149.137     0.150
    10.416   152.688     0.150
    10.861   158.047     0.150
    11.206   158.797     0.150
    11.206   278.305     0.150
    11.206   158.652     0.150
    11.466   166.855     0.150
    11.771   168.703     0.150
    12.187   176.207     0.150
    12.342   176.746     0.150
    12.342   178.273     0.150
    12.480   177.930     0.150
    12.541   178.855     0.150
    12.884   185.008     0.150
    12.926   184.305     0.150
    12.926   408.316     0.150
    12.926   993.285     0.150
    12.968   186.180     0.150
    13.162   187.180     0.150
    13.225   188.008     0.150
    13.264   190.156     0.150
    13.278   189.672     0.150
    13.377   191.930     0.150
    13.424   187.758     0.150
    13.516   193.680     0.150
    13.685   195.719     0.150
    13.730   196.531     0.150
    13.744   194.922     0.150
    13.818   197.180     0.150
    13.898   198.281     0.150
    13.905   196.402     0.150
    14.046   201.230     0.150
    14.290   204.082     0.150
    14.311   204.387     0.150
    14.357   202.840     0.150
    14.410   202.801     0.150
    14.507   205.188     0.150
    14.671   208.680     0.150
    14.678   207.699     0.150
    14.707   208.707     0.150
    14.831   210.887     0.150
    14.894   211.605     0.150
    14.913   209.531     0.150
    14.976   210.359     0.150
    14.978   210.875     0.150
    14.978   389.723     0.150
    15.129   213.102     0.150
    15.138   211.855     0.150
    15.213   215.555     0.150
    15.388   216.438     0.150
    15.411   217.527     0.150
    15.436   217.980     0.150
    15.647   218.906     0.150
    15.645   218.906     0.150
    15.667   221.457     0.150
    15.670   219.406     0.150
    15.651   222.676     0.150
    15.714   219.727     0.150
    15.779   222.535     0.150
    15.791   220.938     0.150
    15.832   223.258     0.150
    15.865   222.383     0.150
    15.866   223.582     0.150
    15.957   225.598     0.150
    16.036   226.074     0.150
    16.068   225.172     0.150
    16.178   226.832     0.150
    16.243   226.438     0.150
    16.267   229.348     0.150
    16.328   227.230     0.150
    16.342   229.145     0.150
    16.348   227.473     0.150
    16.368   227.508     0.150
    16.394   227.957     0.150
    16.506   230.086     0.150
    16.515   233.484     0.150
    16.515   232.980     0.150
    16.598   233.281     0.150
    16.598   233.457     0.150
    16.637   230.656     0.150
    16.637   426.055     0.150
    16.663   231.832     0.150
    16.771   233.508     0.150
    16.776   235.770     0.150
    16.787   235.508     0.150
    16.895   237.457     0.150
    16.938   234.441     0.150
    16.949   235.879     0.150
    16.985   235.586     0.150
    16.993   235.199     0.150
    16.998   238.555     0.150
    17.023   235.395     0.150
    17.098   236.938     0.150
    17.097   239.695     0.150
    17.165   239.980     0.150
    17.209   238.555     0.150
    17.231   238.629     0.150
    17.240   241.730     0.150
    17.309   238.297     0.150
    17.356   242.582     0.150
    17.369   240.980     0.150
    17.503   242.105     0.150
    17.567   243.074     0.150
    17.589   245.805     0.150
    17.596   246.355     0.150
    17.652   243.633     0.150
    17.694   244.555     0.150
    17.746   247.156     0.150
    17.769   244.156     0.150
    17.888   250.281     0.150
    17.925   249.555     0.150
    17.945   247.309     0.150
    17.975   248.406     0.150
    18.000   248.605     0.150
    18.000   248.258     0.150
    18.072   252.230     0.150
    18.129   250.785     0.150
    18.206   250.480     0.150
    18.212   253.258     0.150
    18.220   250.969     0.150
    18.232   251.051     0.150
    18.301   254.098     0.150
    18.323   254.926     0.150
    18.348   252.352     0.150
    18.351   254.305     0.150
    18.392   255.555     0.150
    18.425   253.309     0.150
    18.425   255.156     0.150
    18.451   255.395     0.150
    18.490   254.453     0.150
    18.519   257.465     0.150
    18.570   257.359     0.150
    18.687   259.383     0.150
    18.695   258.758     0.150
    18.750   257.707     0.150
    18.749   260.180     0.150
    18.791   258.406     0.150
    18.804   258.098     0.150
    18.914   259.176     0.150
    18.953   262.031     0.150
    18.958   260.781     0.150
    18.968   259.789     0.150
    18.989   261.707     0.150
    18.989   475.457     0.150
    18.989   602.785     0.150
    18.996   260.582     0.150
    19.103   262.914     0.150
    19.182   262.582     0.150
    19.171   264.758     0.150
    19.200   265.031     0.150
    19.221   262.258     0.150
    19.228   264.969     0.150
    19.296   265.965     0.150
    19.381   264.832     0.150
    19.385   264.816     0.150
    19.417   265.672     0.150
    19.516   267.852     0.150
    19.524   265.910     0.150
    19.536   266.043     0.150
    19.567   266.797     0.150
    19.648   267.562     0.150
    19.660   266.977     0.150
    19.663   269.070     0.150
    19.752   267.055     0.150
    19.759   269.105     0.150
    19.724   272.008     0.150
    19.818   271.582     0.150
    19.859   272.152     0.150
    19.883   270.531     0.150
    20.023   272.883     0.150
    20.073   273.082     0.150
    20.083   272.473     0.150
    20.110   272.383     0.150
    20.144   274.500     0.150
    20.198   272.906     0.150
    20.216   274.977     0.150
    20.226   273.633     0.150
    20.258   273.980     0.150
    20.266   274.207     0.150
    20.281   276.188     0.150
    20.338   277.047     0.150
    20.343   277.168     0.150
    20.412   277.953     0.150
    20.426   278.035     0.150
    20.440   277.383     0.150
    20.498   276.980     0.150
    20.499   276.234     0.150
    20.600   278.855     0.150
    20.663   279.449     0.150
    20.703   278.668     0.150
    20.723   280.980     0.150
    20.693   281.168     0.150
    20.794   279.598     0.150
    20.814   282.312     0.150
    20.848   281.898     0.150
    20.902   281.035     0.150
    20.918   281.539     0.150
    20.931   284.418     0.150
    20.953   283.086     0.150
    20.999   280.836     0.150
    21.050   283.965     0.150
    21.049   284.438     0.150
    21.112   284.031     0.150
    21.161   286.156     0.150
    21.208   285.797     0.150
    21.242   285.680     0.150
    21.310   287.977     0.150
    21.478   288.938     0.150
    21.484   287.258     0.150
    21.494   289.617     0.150
    21.513   286.707     0.150
    21.560   288.832     0.150
    21.561   287.105     0.150
    21.581   288.855     0.150
    21.626   290.555     0.150
    21.659   291.684     0.150
    21.668   291.711     0.150
    21.696   291.727     0.150
    21.706   290.715     0.150
    21.706   290.855     0.150
    21.720   291.230     0.150
    21.792   291.117     0.150
    21.800   288.758     0.150
    21.902   292.648     0.150
    21.906   293.105     0.150
    21.922   290.215     0.150
    21.958   294.574     0.150
    22.015   295.391     0.150
    22.032   295.117     0.150
    22.143   296.617     0.150
    22.157   295.957     0.150
    22.172   297.008     0.150
    22.182   294.816     0.150
    22.203   295.453     0.150
    22.231   296.445     0.150
    22.261   294.258     0.150
    22.303   296.406     0.150
    22.305   297.949     0.150
    22.443   299.633     0.150
    22.482   295.355     0.150
    22.478   300.082     0.150
    22.496   299.219     0.150
    22.509   298.352     0.150
    22.522   300.594     0.150
    22.526   300.305     0.150
    22.526   726.125     0.150
    22.526   300.656     0.150
    22.567   300.227     0.150
    22.575   299.836     0.150
    22.589   299.469     0.150
    22.643   297.867     0.150
    22.647   300.633     0.150
    22.716   300.547     0.150
    22.796   301.703     0.150
    22.807   301.805     0.150
    22.803   304.285     0.150
    22.822   299.734     0.150
    22.875   301.633     0.150
    22.849   552.258     0.150
    22.890   304.301     0.150
    22.917   303.348     0.150
    22.940   303.730     0.150
    22.970   305.379     0.150
    22.999   303.547     0.150
    23.041   304.633     0.150
    23.110   305.395     0.150
    23.251   307.180     0.150
    23.252   308.246     0.150
    23.306   308.559     0.150
    23.335   306.645     0.150
    23.376   305.797     0.150
    23.376   558.535     0.150
    23.406   307.855     0.150
    23.394   309.555     0.150
    23.443   306.188     0.150
    23.434   309.887     0.150
    23.456   307.801     0.150
    23.455   308.508     0.150
    23.476   308.309     0.150
    23.514   310.660     0.150
    23.556   310.156     0.150
    23.619   309.703     0.150
    23.613   311.301     0.150
    23.683   312.180     0.150
    23.722   312.805     0.150
    23.734   312.355     0.150
    23.786   312.230     0.150
    23.786   311.137     0.150
    23.847   310.758     0.150
    23.863   312.582     0.150
    23.886   314.367     0.150
    23.913   314.758     0.150
    23.913   314.602     0.150
    23.919   314.355     0.150
    23.948   313.383     0.150
    23.951   312.965     0.150
    23.950   310.707     0.150
    23.964   314.895     0.150
    24.044   313.973     0.150
    24.046   312.957     0.150
    24.046   313.902     0.150
    24.049   315.621     0.150
    24.080   314.781     0.150
    24.101   314.957     0.150
    24.101   315.121     0.150
    24.110   316.863     0.150
    24.117   316.555     0.150
    24.139   315.008     0.150
    24.161   316.281     0.150
    24.166   314.145     0.150
    24.136   316.746     0.150
    24.194   316.457     0.150
    24.200   316.625     0.150
    24.214   316.562     0.150
    24.227   313.758     0.150
    24.320   318.328     0.150
    24.337   317.586     0.150
    24.385   316.656     0.150
    24.445   317.172     0.150
    24.500   318.598     0.150
    24.508   319.328     0.150
    24.528   319.105     0.150
    24.543   319.480     0.150
    24.545   320.527     0.150
    24.590   321.977     0.150
    24.590   321.102     0.150
    24.654   319.742     0.150
    24.665   319.953     0.150
    24.735   321.156     0.150
    24.742   321.555     0.150
    24.745   320.957     0.150
    24.776   322.371     0.150
    24.788   322.641     0.150
    24.833   321.445     0.150
    24.841   323.301     0.150
    24.889   322.305     0.150
    24.935   321.457     0.150
    24.997   323.430     0.150
    24.993   324.930     0.150
    25.041   323.656     0.150
    25.056   325.258     0.150
    25.105   325.754     0.150
    25.138   325.758     0.150
    25.138   326.430     0.150
    25.149   325.043     0.150
    25.187   323.496     0.150
    25.200   324.918     0.150
    25.297   326.145     0.150
    25.301   328.836     0.150
    25.442   327.121     0.150
    25.448   328.570     0.150
    25.449   329.188     0.150
    25.410   326.516     0.150
    25.451   328.965     0.150
    25.468   326.953     0.150
    25.504   326.086     0.150
    25.510   327.891     0.150
    25.516   328.258     0.150
    25.565   329.680     0.150
    25.596   328.605     0.150
    25.624   330.719     0.150
    25.665   328.625     0.150
    25.720   330.258     0.150
    25.752   330.328     0.150
    25.765   328.594     0.150
    25.810   330.289     0.150
    25.838   332.816     0.150
    25.852   330.500     0.150
    25.863   330.633     0.150
    25.815   331.625     0.150
    25.880   330.980     0.150
    25.891   330.875     0.150
    25.893   332.055     0.150
    25.893   540.156     0.150
    25.893   332.238     0.150
    25.937   332.445     0.150
    25.969   333.680     0.150
    26.053   332.148     0.150
    26.115   333.336     0.150
    26.121   333.207     0.150
    26.274   334.504     0.150
    26.278   334.906     0.150
    26.336   335.156     0.150
    26.355   334.855     0.150
    26.466   336.156     0.150
    26.473   336.855     0.150
    26.500   336.121     0.150
    26.589   336.617     0.150
    26.567   340.008     0.150
    26.631   337.336     0.150
    26.595   339.688     0.150
    26.690   338.508     0.150
    26.688   338.715     0.150
    26.717   340.324     0.150
    26.736   338.215     0.150
    26.742   341.395     0.150
    26.856   338.328     0.150
    26.894   340.141     0.150
    26.911   339.879     0.150
    26.928   342.508     0.150
    26.928   542.938     0.150
    26.974   341.625     0.150
    26.950   343.258     0.150
    27.005   343.387     0.150
    27.005   543.438     0.150
    27.005   862.727     0.150
    27.005  1000.984     0.150
    27.005  2537.086     0.150
    27.011   341.250     0.150
    27.016   340.883     0.150
    26.998   342.328     0.150
    27.063   341.398     0.150
    27.146   342.516     0.150
    27.146   342.406     0.150
    27.146   542.605     0.150
    27.146   866.688     0.150
    27.146   998.957     0.150
    27.146  2110.457     0.150
    27.159   343.000     0.150
    27.189   343.207     0.150
    27.204   342.863     0.150
    27.259   343.855     0.150
    27.320   344.508     0.150
    27.332   342.348     0.150
    27.335   344.633     0.150
    27.344   345.215     0.150
    27.344   543.887     0.150
    27.344   544.105     0.150
    27.344   873.008     0.150
    27.344   345.406     0.150
    27.424   344.281     0.150
    27.453   343.844     0.150
    27.482   344.953     0.150
    27.519   345.906     0.150
    27.528   346.008     0.150
    27.482   349.137     0.150
    27.482   629.848     0.150
    27.482   349.320     0.150
    27.514   346.516     0.150
    27.587   346.715     0.150
    27.547   347.445     0.150
    27.605   346.629     0.150
    27.649   347.570     0.150
    27.668   349.055     0.150
    27.684   347.367     0.150
    27.798   348.660     0.150
    27.756   349.305     0.150
    27.877   350.258     0.150
    27.912   349.805     0.150
    27.974   350.508     0.150
    27.984   351.258     0.150
    28.002   349.324     0.150
    28.018   350.715     0.150
    27.980   351.625     0.150
    28.058   351.105     0.150
    28.068   350.262     0.150
    28.073   351.281     0.150
    28.086   351.086     0.150
    28.122   351.918     0.150
    28.159   351.086     0.150
    28.183   352.098     0.150
    28.186   351.797     0.150
    28.193   352.363     0.150
    28.204   352.426     0.150
    28.205   352.336     0.150
    28.217   352.145     0.150
    28.341   353.016     0.150
    28.368   353.977     0.150
    28.382   353.605     0.150
    28.397   353.410     0.150
    28.416   355.758     0.150
    28.493   355.027     0.150
    28.574   355.234     0.150
    28.574   547.387     0.150
    28.579   355.812     0.150
    28.623   355.250     0.150
    28.626   355.070     0.150
    28.714   356.836     0.150
    28.782   356.457     0.150
    28.790   357.605     0.150
    28.795   354.938     0.150
    28.796   357.277     0.150
    28.876   358.633     0.150
    28.932   359.297     0.150
    28.949   358.145     0.150
    28.959   358.555     0.150
    29.043   360.555     0.150
    29.133   360.949     0.150
    29.136   359.703     0.150
    29.138   359.500     0.150
    29.143   359.551     0.150
    29.146   362.145     0.150
    29.146   548.137     0.150
    29.174   361.152     0.150
    29.282   361.484     0.150
    29.291   362.918     0.150
    29.322   360.648     0.150
    29.281   363.984     0.150
    29.387   363.508     0.150
    29.403   363.336     0.150
    29.404   363.227     0.150
    29.511   362.797     0.150
    29.536   363.812     0.150
    29.571   365.535     0.150
    29.604   365.148     0.150
    29.684   364.875     0.150
    29.738   366.766     0.150
    29.813   366.918     0.150
    29.827   365.859     0.150
    29.834   367.863     0.150
    29.868   367.605     0.150
    29.886   366.062     0.150
    29.902   366.738     0.150
    29.908   366.645     0.150
    29.918   366.164     0.150
    29.968   368.734     0.150
    29.991   369.195     0.150
    29.991     8.742     0.150
    30.007   368.055     0.150
    30.042   369.379     0.150
    30.125   369.020     0.150
    30.173   368.785     0.150
    30.173    10.082     0.150
    30.186   370.641     0.150
    30.197   369.230     0.150
    30.208   368.066     0.150
    30.214   370.555     0.150
    30.214     9.602     0.150
    30.220   370.793     0.150
    30.330   371.156     0.150
    30.330   371.449     0.150
    30.355   370.945     0.150
    30.357   371.867     0.150
    30.368   373.246     0.150
    30.377   369.406     0.150
    30.377   371.359     0.150
    30.396   372.516     0.150
    30.418   372.465     0.150
    30.447   371.793     0.150
    30.501   373.141     0.150
    30.537   372.223     0.150
    30.540   371.996     0.150
    30.557   373.695     0.150
    30.605   374.207     0.150
    30.605   552.027     0.150
    30.647   373.625     0.150
    30.677   374.641     0.150
    30.693   374.125     0.150
    30.770   375.125     0.150
    30.795   375.082     0.150
    30.797   375.070     0.150
    30.799   375.703     0.150
    30.836   377.855     0.150
    30.837   374.656     0.150
    30.854   374.633     0.150
    30.856   378.215     0.150
    30.870   376.758     0.150
    30.920   375.648     0.150
    30.925   376.285     0.150
    31.037   377.473     0.150
    31.137   378.078     0.150
    31.153   378.020     0.150
    31.188   378.203     0.150
    31.205   378.887     0.150
    31.324   380.203     0.150
    31.364   380.121     0.150
    31.373   380.258     0.150
    31.410   380.746     0.150
    31.448   380.441     0.150
    31.495   380.953     0.150
    31.528   381.715     0.150
    31.598   381.156     0.150
    31.598   553.758     0.150
    31.606   382.730     0.150
    31.617   382.500     0.150
    31.631   382.445     0.150
    31.656   380.168     0.150
    31.703   382.586     0.150
    31.703   382.750     0.150
    31.703   385.227     0.150
    31.715   383.156     0.150
    31.725   383.105     0.150
    31.725   554.098     0.150
    31.725  1018.695     0.150
    31.725   383.297     0.150
    31.747   382.844     0.150
    31.782   383.746     0.150
    31.856   384.523     0.150
    31.901   384.656     0.150
    31.870   383.785     0.150
    31.870   383.453     0.150
    31.994   385.387     0.150
    31.996   385.703     0.150
    32.020   385.445     0.150
    32.059   386.027     0.150
    32.059     9.668     0.150
    32.124   386.746     0.150
    32.135   386.676     0.150
    32.138   386.535     0.150
    32.138     9.723     0.150
    32.138   386.836     0.150
    32.141   386.137     0.150
    32.197   386.887     0.150
    32.220   387.336     0.150
    32.236   389.008     0.150
    32.258   387.969     0.150
    32.288   387.387     0.150
    32.361   388.707     0.150
    32.384   389.152     0.150
    32.395   389.078     0.150
    32.415   389.164     0.150
    32.439   389.035     0.150
    32.470   391.234     0.150
    32.481   388.305     0.150
    32.494   389.836     0.150
    32.505   389.938     0.150
    32.521   390.066     0.150
    32.596   390.719     0.150
    32.607   390.562     0.150
    32.623   390.906     0.150
    32.658   389.207     0.150
    32.733   392.855     0.150
    32.752   391.996     0.150
    32.752   557.215     0.150
    32.771   391.648     0.150
    32.799   392.281     0.150
    32.834   393.766     0.150
    32.876   395.375     0.150
    32.953   393.340     0.150
    33.008   393.773     0.150
    33.049   394.645     0.150
    33.049   558.277     0.150
    33.073   395.215     0.150
    33.078   394.688     0.150
    33.078   394.531     0.150
    33.214   396.148     0.150
    33.297   396.734     0.150
    33.310   397.395     0.150
    33.314   396.879     0.150
    33.388   397.215     0.150
    33.391   395.855     0.150
    33.391   558.188     0.150
    33.384   399.676     0.150
    33.412   397.848     0.150
    33.425   397.965     0.150
    33.667   400.375     0.150
    33.734   400.168     0.150
    33.755   400.207     0.150
    33.758   400.348     0.150
    33.798   403.336     0.150
    33.853   402.555     0.150
    33.912   402.434     0.150
    33.908   401.965     0.150
    34.063   404.457     0.150
    34.094   403.742     0.150
    34.125   404.508     0.150
    34.343   404.855     0.150
    34.357   404.406     0.150
    34.417   406.316     0.150
    34.417   560.906     0.150
    34.417   406.012     0.150
    34.446   405.855     0.150
    34.524   407.770     0.150
    34.608   407.926     0.150
    34.713   407.688     0.150
    34.841   409.125     0.150
    34.869   411.586     0.150
    34.959   410.855     0.150
    34.997   412.258     0.150
    34.997   563.555     0.150
    35.017   410.734     0.150
    35.057   412.977     0.150
    35.051   412.746     0.150
    35.309   414.188     0.150
    35.371   413.395     0.150
    35.854   418.555     0.150
    36.398   424.887     0.150
    36.455   425.535     0.150
    37.169   429.605     0.150
    37.317   431.516     0.150
    37.787   434.457     0.150
    37.787   433.957     0.150
    38.662   442.578     0.150
    38.662    10.078     0.150
    39.523   449.977     0.150
    41.794   584.984     0.150
    44.214   487.188     0.150
    44.214   592.945     0.150
    44.786   495.328     0.150
    45.264   497.867     0.150
    45.264   597.727     0.150
    45.264   498.383     0.150
    45.439   496.906     0.150
    45.439   497.008     0.150
    46.218   505.867     0.150
    46.218     9.250     0.150
    46.559   505.547     0.150
    46.742   507.707     0.150
    46.742     9.090     0.150
    46.742   600.957     0.150
    46.742  1013.645     0.150
    46.808   507.484     0.150
    46.808     9.820     0.150
    47.164   513.457     0.150
    47.164     9.359     0.150
    47.164   603.887     0.150
    49.816   531.816     0.150
    49.816    10.930     0.150
    50.099   534.375     0.150
    51.523   545.355     0.150
    51.523    10.441     0.150
    52.662   555.117     0.150
    53.498   561.086     0.150
    54.384   567.348     0.150
    54.384    10.207     0.150
    54.949   570.715     0.150
    54.949    10.211     0.150
    55.126   573.656     0.150
    55.127   573.555     0.150
    55.127     9.500     0.150
    55.390   573.246     0.150
    55.390    10.391     0.150
    55.696   575.055     0.150
    55.696     9.531     0.150
    55.696  2379.508     0.150
    55.706   576.156     0.150
    55.706    10.211     0.150
    55.840   576.957     0.150
    55.840     9.098     0.150
    55.999   577.918     0.150
    56.354   580.656     0.150
    56.453   581.734     0.150
    56.577   581.555     0.150
    56.577    10.102     0.150
    56.584   582.605     0.150
    56.584     9.410     0.150
    57.246   587.957     0.150
    57.265   589.055     0.150
    57.363   587.406     0.150
    57.363    10.199     0.150
    57.363   641.156     0.150
    57.363  2376.355     0.150
    57.569   589.156     0.150
    57.633   589.305     0.150
    57.765   589.957     0.150
    57.718   591.547     0.150
    57.843   589.105     0.150
    57.953   591.355     0.150
    58.455   594.734     0.150
    58.455    10.531     0.150
    58.939   600.258     0.150
    59.143   599.156     0.150
    59.143     9.941     0.150
    59.143   599.258     0.150
    59.143   597.875     0.150
    59.435   601.508     0.150
    59.792   603.676     0.150
    59.824   605.105     0.150
    59.824     9.941     0.150
    59.795   606.355     0.150
    59.838   606.656     0.150
    59.986   608.555     0.150
    59.998   607.758     0.150
    59.998  1097.758     0.150
    59.998  1336.457     0.150
    60.264   608.598     0.150
    62.928   625.578     0.150
    62.928     8.418     0.150
    63.069  1136.656     0.150
    63.069  1384.855     0.150
    63.367   629.246     0.150
    63.367    10.082     0.150
    64.215   632.645     0.150
    64.215     9.500     0.150
    64.913   638.645     0.150
    64.913    10.840     0.150
    65.484   642.457     0.150
    65.484   642.086     0.150
    65.810   645.406     0.150
    65.810     9.680     0.150
    66.839   652.477     0.150
    67.252   651.656     0.150
    70.048   670.457     0.150
    71.572   678.957     0.150
    75.072   700.285     0.150
    75.072    10.223     0.150
    75.072   700.707     0.150
    75.072     9.801     0.150
    75.423  1280.957     0.150
    75.940   706.457     0.150
    75.940   715.656     0.150
    75.940  1283.055     0.150
    77.541   714.715     0.150
    77.541   715.656     0.150
    77.541   714.996     0.150
    77.584   716.246     0.150
    77.584   716.391     0.150
    79.833   726.555     0.150
    79.833    10.602     0.150
    79.841   728.656     0.150
    79.841  1323.258     0.150
    79.841  1648.355     0.150
    79.947   727.656     0.150
    80.292   730.457     0.150
    80.292    10.500     0.150
    80.328   730.156     0.150
    80.328    10.602     0.150
    80.412   730.957     0.150
    80.412    10.301     0.150
    80.551   731.957     0.150
    80.551     9.898     0.150
    80.563   731.355     0.150
    80.563    10.000     0.150
    80.564   732.055     0.150
    80.571   732.258     0.150
    80.571    10.398     0.150
    80.665   732.457     0.150
    80.665    10.000     0.150
    80.665   731.656     0.150
    80.748   732.258     0.150
    80.748    10.199     0.150
    80.748  1341.457     0.150
    80.748   732.055     0.150
    80.748     9.953     0.150
    80.772   732.855     0.150
    80.855   732.957     0.150
    80.855    11.000     0.150
    80.855   732.855     0.150
    80.936   733.156     0.150
    80.936    11.102     0.150
    80.938   734.156     0.150
    80.938     9.500     0.150
    80.938  1339.457     0.150
    80.938  1656.758     0.150
    80.988   734.258     0.150
    81.057    10.699     0.150
    81.092   734.957     0.150
    81.093   734.355     0.150
    81.093    10.301     0.150
    81.102   734.258     0.150
    81.102     9.898     0.150
    81.102  1343.355     0.150
    81.102  1648.957     0.150
    81.237   735.656     0.150
    81.362   736.055     0.150
    81.362     9.301     0.150
    81.362  1343.855     0.150
    81.362  1666.656     0.150
    81.648   736.758     0.150
    81.833   737.758     0.150
    82.131   739.258     0.150
    82.612   741.848     0.150
    82.612    10.180     0.150
    82.691   741.145     0.150
    83.029   745.055     0.150
    83.175   745.258     0.150
    83.299   745.957     0.150
    83.337   747.266     0.150
    83.350   745.617     0.150
    83.350   746.668     0.150
    83.342   745.855     0.150
    83.389   747.508     0.150
    83.460   747.266     0.150
    83.550   746.855     0.150
    83.550  1365.656     0.150
    83.550  1698.957     0.150
    83.591   747.086     0.150
    83.591    10.551     0.150
    83.591  1845.984     0.150
    83.591   747.586     0.150
    83.635   747.938     0.150
    83.635   748.047     0.150
    83.761   745.727     0.150
    84.064   750.227     0.150
    84.064   750.355     0.150
    84.064    10.602     0.150
    84.187   750.457     0.150
    84.543   752.656     0.150
    84.731   753.855     0.150
    84.871   753.617     0.150
    84.871   754.797     0.150
    84.871    10.160     0.150
    84.871   754.258     0.150
    84.940   754.008     0.150
    84.999   754.457     0.150
    84.999   753.676     0.150
    84.999  1839.555     0.150
    85.073   755.355     0.150
    85.136   755.457     0.150
    85.252   753.188     0.150
    85.252   753.984     0.150
    85.252    12.719     0.150
    85.277   754.828     0.150
    85.277    10.598     0.150
    85.308   756.258     0.150
    85.484   757.355     0.150
    85.578   756.887     0.150
    85.578  1839.285     0.150
    85.578   755.336     0.150
    85.578   756.246     0.150
    85.635   756.977     0.150
    85.635    11.531     0.150
    85.635    16.020     0.150
    85.657   758.055     0.150
    85.705   758.055     0.150
    85.728   758.957     0.150
    85.753   758.355     0.150
    85.768   758.355     0.150
    85.829   758.457     0.150
    85.847   757.258     0.150
    85.972   759.566     0.150
    85.972    10.430     0.150
    86.106   760.258     0.150
    86.148   759.855     0.150
    86.193   760.055     0.150
    86.199   760.355     0.150
    86.203   760.457     0.150
    86.274   760.828     0.150
    86.274    10.688     0.150
    86.393   760.656     0.150
    86.395   760.855     0.150
    86.537   762.055     0.150
    86.545   761.855     0.150
    86.617   762.246     0.150
    86.759   762.355     0.150
    86.840   763.258     0.150
    86.846   763.656     0.150
    86.877   764.457     0.150
    86.942   763.457     0.150
    86.956   764.156     0.150
    87.068   764.355     0.150
    87.068   763.855     0.150
    87.068   764.555     0.150
    87.234   765.258     0.150
    87.521   766.656     0.150
    87.595   767.258     0.150
    87.675   767.555     0.150
    87.675    11.000     0.150
    87.675   971.457     0.150
    87.698   767.957     0.150
    87.712   767.855     0.150
    87.830   767.758     0.150
    87.956   768.855     0.150
    88.082   773.055     0.150
    88.082   772.656     0.150
    88.186   769.855     0.150
    88.186    10.902     0.150
    88.204   769.855     0.150
    88.204    11.301     0.150
    88.207   769.758     0.150
    88.216   769.355     0.150
    88.240   769.656     0.150
    88.246   768.758     0.150
    88.246   769.457     0.150
    88.332   770.055     0.150
    88.376   770.055     0.150
    88.385   770.457     0.150
    88.617   772.156     0.150
    88.617    10.801     0.150
    88.696   772.156     0.150
    88.726   772.555     0.150
    88.851   773.055     0.150
    88.902   772.855     0.150
    88.912   774.258     0.150
    88.915   772.555     0.150
    88.915    11.203     0.150
    88.915   980.758     0.150
    88.915   772.305     0.150
    88.915   773.555     0.150
    89.055   774.656     0.150
    89.048   774.457     0.150
    89.068   774.656     0.150
    89.147   773.055     0.150
    89.253   774.855     0.150
    89.253    11.602     0.150
    89.253   983.957     0.150
    89.287   774.156     0.150
    89.385   775.555     0.150
    89.684   776.957     0.150
    89.760   777.055     0.150
    89.763   776.555     0.150
    89.849   777.656     0.150
    89.849    10.801     0.150
    89.849   988.758     0.150
    90.050   779.156     0.150
    90.050   991.258     0.150
    90.050  1779.156     0.150
    90.193   779.145     0.150
    90.193    10.410     0.150
    90.229   779.258     0.150
    90.303   779.926     0.150
    90.323   779.758     0.150
    90.323    10.199     0.150
    90.323  1407.656     0.150
    90.323   779.457     0.150
    90.323    10.898     0.150
    90.323   992.156     0.150
    90.323   991.656     0.150
    90.323  1444.656     0.150
    90.323  1504.656     0.150
    90.323  1794.656     0.150
    90.320   779.926     0.150
    90.320    10.082     0.150
    90.331   779.855     0.150
    90.331    11.000     0.150
    90.384   780.156     0.150
    90.384    11.000     0.150
    90.429   780.656     0.150
    90.429    10.699     0.150
    90.434   780.258     0.150
    90.434    11.098     0.150
    90.444   780.656     0.150
    90.444    10.898     0.150
    90.497   777.258     0.150
    90.510   781.156     0.150
    90.510    10.398     0.150
    90.510   994.156     0.150
    90.587   781.258     0.150
    90.587    11.199     0.150
    90.700   781.758     0.150
    90.700    10.898     0.150
    90.755   782.066     0.150
    90.764   781.457     0.150
    90.764    11.199     0.150
    90.836   780.145     0.150
    90.835   781.078     0.150
    90.835  1827.586     0.150
    90.940   783.016     0.150
    91.026   783.258     0.150
    91.051   783.297     0.150
    91.051    10.879     0.150
    91.051   998.105     0.150
    91.051  1804.656     0.150
    91.051   783.156     0.150
    91.051    11.000     0.150
    91.051   998.855     0.150
    91.263   784.555     0.150
    91.263    10.801     0.150
    91.263  1000.957     0.150
    91.567   785.957     0.150
    91.567    11.000     0.150
    91.675   786.055     0.150
    91.675    10.902     0.150
    91.675  1003.957     0.150
    91.675  1418.156     0.150
    91.675  1515.055     0.150
    91.675   785.926     0.150
    91.675    10.801     0.150
    91.706   784.457     0.150
    91.713   786.656     0.150
    91.713    11.000     0.150
    91.713  1013.656     0.150
    91.814   786.656     0.150
    91.814    11.301     0.150
    91.814  1414.355     0.150
    91.814  1516.055     0.150
    91.869   786.758     0.150
    91.869    11.098     0.150
    91.882   786.758     0.150
    91.882    11.297     0.150
    91.882   787.258     0.150
    91.882    10.129     0.150
    91.882  1825.105     0.150
    92.156   788.148     0.150
    92.275   788.555     0.150
    92.275     9.703     0.150
    92.275  1007.957     0.150
    92.275  1418.656     0.150
    92.275  1451.758     0.150
    92.275  1824.055     0.150
    92.362   789.055     0.150
    92.362    10.000     0.150
    92.362  1009.656     0.150
    92.362  1419.656     0.150
    92.362  1522.156     0.150
    92.362   789.156     0.150
    92.378   789.555     0.150
    92.378    11.102     0.150
    92.378  1009.855     0.150
    92.507   789.957     0.150
    92.535   790.555     0.150
    92.628   790.957     0.150
    92.628    10.598     0.150
    92.628  1010.355     0.150
    92.628  1424.258     0.150
    92.689   790.289     0.150
    92.690   790.055     0.150
    93.146   792.926     0.150
    93.146    10.602     0.150
    93.505   794.125     0.150
    93.587   794.992     0.150
    93.598   794.855     0.150
    93.715   794.656     0.150
    93.786   795.727     0.150
    93.803   796.625     0.150
    93.803    10.141     0.150
    93.900   796.758     0.150
    93.900    10.598     0.150
    93.900  1019.957     0.150
    93.900  1430.656     0.150
    94.024   796.777     0.150
    94.116   797.957     0.150
    94.168   797.156     0.150
    94.168    11.102     0.150
    94.168  1023.156     0.150
    94.492   797.887     0.150
    94.551   798.195     0.150
    94.592   798.957     0.150
    94.592    10.301     0.150
    94.592  1026.656     0.150
    94.592  1431.258     0.150
    94.732   798.848     0.150
    94.844   801.855     0.150
    94.984   799.734     0.150
    94.983  1436.258     0.150
    94.997   801.656     0.150
    94.997    10.898     0.150
    94.997  1027.656     0.150
    95.304   803.457     0.150
    95.394   802.656     0.150
    95.394  1466.656     0.150
    95.644   805.258     0.150
    95.904   806.457     0.150
    95.904    10.801     0.150
    95.904   806.855     0.150
    96.225   806.555     0.150
    96.225    10.801     0.150
    96.477   808.355     0.150
    96.648   809.457     0.150
    96.648    11.199     0.150
    96.648  1044.156     0.150
    96.709   808.156     0.150
    96.709    11.078     0.150
    96.709  1813.707     0.150
    96.709  2304.234     0.150
    96.832   810.457     0.150
    97.061   810.555     0.150
    97.061  1445.555     0.150
    97.061  1573.758     0.150
    97.061  1879.156     0.150
    97.255   812.156     0.150
    99.110  1060.258     0.150
    99.110  1805.258     0.150
    99.139   817.656     0.150
    99.139  1063.855     0.150
    99.206   819.656     0.150
    99.206  1059.457     0.150
    99.206  1453.055     0.150
    99.206  1595.355     0.150
    99.206  1909.355     0.150
    99.772  1063.758     0.150
    99.772  1514.957     0.150
    99.772  1608.957     0.150
    99.772  1928.055     0.150
   101.313   830.656     0.150
   101.313  1616.656     0.150
   103.136   838.980     0.150
   103.136  1092.805     0.150
   103.171   837.258     0.150
   103.171  1097.555     0.150
   103.413   837.555     0.150
   104.246   842.258     0.150
   104.668   843.957     0.150
   104.668  1480.957     0.150
   104.668  1663.355     0.150
   106.556  1118.855     0.150
   106.895   855.957     0.150
   106.895  1575.156     0.150
   106.833  1779.977     0.150
   107.187  1488.758     0.150
   107.187  1677.156     0.150
   107.187  2021.555     0.150
   108.042  1129.656     0.150
   108.252  1107.637     0.150
   108.252  1776.637     0.150
   108.753  1108.156     0.150
   108.753  1108.258     0.150
   108.753  1776.656     0.150
   108.753  1790.605     0.150
   109.333  1108.305     0.150
   109.333  1773.105     0.150
   109.891  1110.605     0.150
   109.891  1110.605     0.150
   109.891  1139.605     0.150
   109.891  1784.555     0.150
   110.043  1145.156     0.150
   110.291  1140.758     0.150
   110.291  1704.656     0.150
   111.487  1113.176     0.150
   111.487  1153.016     0.150
   111.487  1767.797     0.150
   111.487  1777.578     0.150
   111.666  1113.656     0.150
   111.666  1113.207     0.150
   111.755  1113.656     0.150
   112.405  1115.656     0.150
   112.653  1115.055     0.150
   112.653  1115.195     0.150
   114.285   887.656     0.150
   114.285  1549.457     0.150
   114.285  1634.156     0.150
   115.676  1120.957     0.150
   115.676  1135.457     0.150
   115.676  1187.957     0.150
   115.676  1336.656     0.150
   115.676  1548.457     0.150
   115.676  1597.957     0.150
   116.221  1753.555     0.150
   116.575  1121.355     0.150
   116.575  1122.055     0.150
   116.575  1749.828     0.150
   117.273   900.656     0.150
   117.853  1126.484     0.150
   118.263  1126.457     0.150
   118.263  1205.656     0.150
   119.211  1127.656     0.150
   119.211  1212.656     0.150
   119.211  1342.656     0.150
   119.211  1554.656     0.150
   119.211  1620.656     0.150
   119.595  1128.156     0.150
   119.877  1129.875     0.150
   120.164  1130.438     0.150
   120.304  1129.957     0.150
   120.304  1130.758     0.150
   120.317  1130.258     0.150
   120.413  1131.055     0.150
   120.413  1131.234     0.150
   120.501  1130.957     0.150
   120.501  1737.477     0.150
   120.501  1131.277     0.150
   120.519  1131.418     0.150
   120.490  1131.367     0.150
   120.490  1737.395     0.150
   120.930  1132.816     0.150
   121.018  1132.816     0.150
   121.117  1133.105     0.150
   121.119  1132.457     0.150
   121.119  1148.957     0.150
   121.119  1225.156     0.150
   121.119  1347.457     0.150
   121.119  1554.457     0.150
   122.522  1134.156     0.150
   122.628  1134.457     0.150
   122.628  1240.156     0.150
   122.825  1135.656     0.150
   122.825  1147.156     0.150
   122.825  1237.656     0.150
   123.005  1135.734     0.150
   123.005  1136.355     0.150
   123.071  1137.258     0.150
   123.412  1135.977     0.150
   123.483  1135.957     0.150
   123.657  1137.156     0.150
   123.717  1138.656     0.150
   123.717  1152.656     0.150
   123.717  1242.656     0.150
   123.717  1353.957     0.150
   123.717  1565.656     0.150
   123.717  1651.656     0.150
   124.029  1137.586     0.150
   124.449  1139.168     0.150
   124.792  1139.465     0.150
   126.540  1144.055     0.150
   126.858  1140.258     0.150
   126.956  1144.555     0.150
   127.430  1143.656     0.150
   127.430  1158.656     0.150
   127.430  1266.156     0.150
   127.430  1358.656     0.150
   127.430  1570.156     0.150
   127.430  1674.156     0.150
   127.702  1144.656     0.150
   128.198  1145.527     0.150
   128.198  1146.176     0.150
   128.448  1146.035     0.150
   128.931  1147.555     0.150
   128.942  1146.734     0.150
   128.942  1158.285     0.150
   128.942  1938.055     0.150
   129.627  1148.266     0.150
   129.628  1148.805     0.150
   129.628  1931.355     0.150
   129.918   956.656     0.150
   129.918  1148.957     0.150
   129.918  1166.457     0.150
   129.918  1284.156     0.150
   129.918  1363.957     0.150
   129.918  1691.156     0.150
   129.898  1149.688     0.150
   129.898  1150.578     0.150
   131.866  1153.273     0.150
   132.005  1154.133     0.150
   132.231  1153.793     0.150
   132.315  1153.906     0.150
   132.524  1154.156     0.150
   132.905  1154.957     0.150
   132.905  1170.457     0.150
   132.905  1301.656     0.150
   132.905  1369.156     0.150
   132.905  1710.656     0.150
   132.988  1154.656     0.150
   133.274  1155.168     0.150
   134.045  1156.957     0.150
   134.045  1309.457     0.150
   134.506  1157.027     0.150
   134.571  1155.656     0.150
   134.647  1158.105     0.150
   134.718  1160.305     0.150
   134.718  1160.484     0.150
   134.718  1161.418     0.150
   134.765  1158.137     0.150
   134.894  1158.355     0.150
   135.052  1158.438     0.150
   135.061  1158.578     0.150
   135.135  1159.258     0.150
   135.190  1157.656     0.150
   135.261  1158.805     0.150
   135.319  1158.055     0.150
   135.442  1158.355     0.150
   135.481  1158.258     0.150
   135.518  1159.055     0.150
   135.523  1159.055     0.150
   135.972  1159.156     0.150
   135.994  1157.957     0.150
   136.508  1160.605     0.150
   136.716  1162.586     0.150
   136.948  1163.246     0.150
   139.585  1168.156     0.150
   139.719  1167.590     0.150
   140.104  1167.957     0.150
   140.104  1168.617     0.150
   140.416  1169.645     0.150
   140.416  1169.008     0.150
   141.078  1170.656     0.150
   142.673  1168.641     0.150
   143.196  1169.996     0.150
   144.194  1173.055     0.150
   145.328  1176.887     0.150
   145.328  1177.254     0.150
   145.471  1177.086     0.150
   145.841  1177.156     0.150
   148.319  1182.895     0.150
   148.319  1187.438     0.150
   148.371  1183.555     0.150
   148.371  1186.855     0.150
   150.235  1185.996     0.150
   150.235  1191.016     0.150
   150.235  1186.465     0.150
   150.235  1191.324     0.150
   150.349  1191.953     0.150
   150.575  1186.266     0.150
   150.575  1186.953     0.150
   150.610  1187.195     0.150
   151.038  1193.344     0.150
   152.687  1190.145     0.150
   152.687  1196.816     0.150
   152.687  1197.566     0.150
   153.303  1189.855     0.150
   153.303  1197.055     0.150
     0.294     9.141     0.150
     0.294    15.016     0.150
     0.584    12.266     0.150
     0.584    20.594     0.150
     1.350    23.445     0.150
     1.350    40.305     0.150
     1.625    27.258     0.150
     1.625    46.148     0.150
     1.799    29.258     0.150
     1.799    50.523     0.150
     1.846    29.930     0.150
     1.846    53.164     0.150
     1.916    31.828     0.150
     1.916    54.805     0.150
     2.123    34.641     0.150
     2.123    60.344     0.150
     2.193    35.898     0.150
     2.193    62.555     0.150
     2.397    38.484     0.150
     2.397    67.258     0.150
     2.539    40.625     0.150
     2.539    70.625     0.150
     2.638    41.984     0.150
     2.638    73.570     0.150
     2.791    44.070     0.150
     2.791    75.969     0.150
     2.798    44.641     0.150
     2.798    75.188     0.150
     3.654    56.375     0.150
     3.654    96.156     0.150
     3.709    55.578     0.150
     3.709    97.578     0.150
     4.434    69.344     0.150
     4.434   116.430     0.150
     4.567    68.477     0.150
     4.567   120.336     0.150
     4.567   141.875     0.150
     4.567    68.094     0.150
     4.567   119.422     0.150
     4.601    70.266     0.150
     4.601   120.766     0.150
     6.053    88.891     0.150
     6.053   156.938     0.150
     6.273    92.344     0.150
     6.273   162.719     0.150
     6.264    95.109     0.150
     6.264   162.227     0.150
     7.254   107.898     0.150
     7.254   187.797     0.150
     7.767   113.906     0.150
     7.767   200.586     0.150
    11.229   160.188     0.150
    11.229   283.219     0.150
    11.229   160.422     0.150
    11.584   166.523     0.150
    12.290   175.141     0.150
    12.356   176.586     0.150
    12.685   181.180     0.150
    12.725   181.180     0.150
    12.725   397.047     0.150
    12.768   182.031     0.150
    12.976   184.438     0.150
    13.036   185.281     0.150
    13.063   186.586     0.150
    13.085   186.188     0.150
    13.181   187.938     0.150
    13.318   189.773     0.150
    13.325   189.648     0.150
    13.485   192.117     0.150
    13.528   192.617     0.150
    13.555   192.719     0.150
    13.623   193.742     0.150
    13.706   194.938     0.150
    13.720   194.648     0.150
    13.848   196.547     0.150
    14.089   199.828     0.150
    14.112   200.523     0.150
    14.225   201.289     0.150
    14.315   203.562     0.150
    14.469   205.602     0.150
    14.510   205.367     0.150
    14.729   207.016     0.150
    14.788   208.203     0.150
    14.936   209.883     0.150
    14.966   214.172     0.150
    15.011   212.352     0.150
    15.234   215.609     0.150
    15.467   218.617     0.150
    15.526   219.953     0.150
    15.632   220.180     0.150
    15.665   220.719     0.150
    15.669   220.977     0.150
    15.802   222.359     0.150
    15.834   222.938     0.150
    15.978   224.195     0.150
    16.074   220.891     0.150
    16.142   225.875     0.150
    16.144   224.484     0.150
    16.161   225.930     0.150
    16.177   225.719     0.150
    16.202   226.352     0.150
    16.312   229.883     0.150
    16.311   228.445     0.150
    16.395   230.188     0.150
    16.397   230.062     0.150
    16.466   229.289     0.150
    16.572   232.219     0.150
    16.692   235.367     0.150
    16.748   233.398     0.150
    16.795   236.242     0.150
    16.793   233.867     0.150
    16.806   234.461     0.150
    16.840   234.805     0.150
    16.964   236.570     0.150
    17.013   236.578     0.150
    17.037   238.227     0.150
    17.036   236.578     0.150
    17.154   238.930     0.150
    17.183   236.977     0.150
    17.314   240.648     0.150
    17.357   241.375     0.150
    17.386   242.031     0.150
    17.393   243.352     0.150
    17.545   243.211     0.150
    17.588   241.328     0.150
    17.685   247.148     0.150
    17.723   245.719     0.150
    17.749   245.086     0.150
    17.777   245.953     0.150
    17.808   245.625     0.150
    17.808   246.367     0.150
    18.010   248.539     0.150
    18.020   248.547     0.150
    18.099   252.203     0.150
    18.152   250.031     0.150
    18.222   250.391     0.150
    18.249   250.391     0.150
    18.484   255.641     0.150
    18.493   255.445     0.150
    18.750   259.055     0.150
    18.757   257.875     0.150
    18.787   258.344     0.150
    18.787   258.508     0.150
    18.985   259.586     0.150
    19.054   260.461     0.150
    19.182   260.992     0.150
    19.217   261.344     0.150
    19.552   263.594     0.150
    19.562   266.281     0.150
    19.615   266.961     0.150
    19.656   270.031     0.150
    19.821   268.766     0.150
    19.926   269.656     0.150
    20.016   271.195     0.150
    20.055   270.648     0.150
    20.066   270.648     0.150
    20.073   270.984     0.150
    20.144   276.016     0.150
    20.210   273.555     0.150
    20.223   275.148     0.150
    20.302   273.492     0.150
    20.403   274.766     0.150
    20.447   275.500     0.150
    20.464   275.742     0.150
    20.480   275.695     0.150
    20.512   276.289     0.150
    20.521   276.625     0.150
    20.613   280.500     0.150
    20.601   275.156     0.150
    20.723   277.938     0.150
    20.750   279.594     0.150
    20.849   280.328     0.150
    20.915   280.258     0.150
    21.006   281.664     0.150
    21.044   282.156     0.150
    21.107   282.789     0.150
    21.107   283.945     0.150
    21.117   282.133     0.150
    21.205   284.398     0.150
    21.252   283.336     0.150
    21.290   284.406     0.150
    21.291   284.328     0.150
    21.363   284.891     0.150
    21.387   285.742     0.150
    21.429   283.219     0.150
    21.503   287.305     0.150
    21.503   287.594     0.150
    21.519   287.742     0.150
    21.594   287.562     0.150
    21.639   288.164     0.150
    21.673   286.078     0.150
    21.704   289.797     0.150
    21.703   289.555     0.150
    21.809   287.406     0.150
    21.943   295.016     0.150
    21.970   294.961     0.150
    22.029   293.258     0.150
    22.087   291.609     0.150
    22.275   297.148     0.150
    22.295   295.891     0.150
    22.366   297.062     0.150
    22.373   296.227     0.150
    22.444   298.211     0.150
    22.503   297.406     0.150
    22.524   298.320     0.150
    22.595   298.961     0.150
    22.614   298.391     0.150
    22.691   302.859     0.150
    22.715   298.828     0.150
    22.910   302.586     0.150
    22.992   300.430     0.150
    23.050   303.875     0.150
    23.107   306.508     0.150
    23.209   304.047     0.150
    23.209   305.039     0.150
    23.271   302.891     0.150
    23.271   303.297     0.150
    23.310   304.656     0.150
    23.584   308.734     0.150
    23.665   309.375     0.150
    23.683   311.898     0.150
    23.712   309.203     0.150
    23.749   310.438     0.150
    23.760   310.781     0.150
    23.813   312.023     0.150
    23.856   311.820     0.150
    23.878   311.930     0.150
    23.898   312.617     0.150
    23.898   312.984     0.150
    23.990   314.148     0.150
    23.997   312.984     0.150
    24.058   312.008     0.150
    24.136   314.617     0.150
    24.269   316.289     0.150
    24.305   316.867     0.150
    24.331   315.859     0.150
    24.534   318.820     0.150
    24.542   319.258     0.150
    24.797   320.828     0.150
    24.804   318.617     0.150
    25.040   320.695     0.150
    25.094   323.234     0.150
    25.311   326.773     0.150
    25.313   326.297     0.150
    25.339   323.828     0.150
    25.362   327.195     0.150
    25.689   329.297     0.150
    25.689   331.062     0.150
    25.921   331.031     0.150
    26.267   334.570     0.150
    26.257   332.344     0.150
    26.272   334.695     0.150
    26.680   336.305     0.150
    26.727   339.453     0.150
    26.804   339.945     0.150
    26.804     9.070     0.150
    26.945   340.523     0.150
    26.945   340.289     0.150
    26.945   339.398     0.150
    27.117   342.281     0.150
    27.136   341.859     0.150
    27.211   340.219     0.150
    27.407   343.992     0.150
    27.446   345.258     0.150
    27.483   344.805     0.150
    27.713   347.305     0.150
    27.993   349.516     0.150
    28.016   349.891     0.150
    28.068   348.500     0.150
    28.144   350.734     0.150
    28.181   351.367     0.150
    28.373   352.906     0.150
    28.759   356.281     0.150
    28.943   357.594     0.150
    29.201   361.234     0.150
    29.609   364.867     0.150
    29.703   364.734     0.150
    29.766   365.633     0.150
    29.789   366.227     0.150
    29.926   366.633     0.150
    30.068   367.023     0.150
    30.220   367.430     0.150
    30.248   368.672     0.150
    30.474   371.977     0.150
    30.568   372.219     0.150
    30.595   373.055     0.150
    30.597   373.188     0.150
    30.670   373.656     0.150
    30.723   373.828     0.150
    30.725   373.523     0.150
    30.884   375.359     0.150
    30.939   375.523     0.150
    30.959   375.875     0.150
    31.004   376.297     0.150
    31.121   377.273     0.150
    31.171   378.117     0.150
    31.328   379.188     0.150
    31.403   380.250     0.150
    31.415   379.852     0.150
    31.517   380.625     0.150
    31.527   383.477     0.150
    31.552   381.234     0.150
    31.589   381.305     0.150
    31.793   383.141     0.150
    31.796   383.180     0.150
    31.961   387.727     0.150
    32.159   386.484     0.150
    32.194   386.617     0.150
    32.319   387.234     0.150
    32.550   389.148     0.150
    32.569   389.398     0.150
    32.602   389.148     0.150
    32.709   391.164     0.150
    32.848   391.930     0.150
    33.015   393.719     0.150
    33.113   394.883     0.150
    33.214   394.234     0.150
    33.711   400.711     0.150
    37.599   431.664     0.150
    45.311   493.898     0.150
    45.311    11.500     0.150
    45.455   498.375     0.150
    46.546   504.094     0.150
    50.281   533.844     0.150
    54.181   566.008     0.150
    55.496    11.375     0.150
    57.043   584.695     0.150
    57.043    11.180     0.150
    57.430   586.875     0.150
    57.430   586.875     0.150
    57.750   588.641     0.150
    60.430   608.016     0.150
    63.570   629.047     0.150
    63.570    10.820     0.150
    65.332   639.656     0.150
    65.332    10.992     0.150
    83.864   747.445     0.150
   123.014  1133.969     0.150
   128.897  1145.930     0.150
   128.897  1157.695     0.150
   129.600  1147.250     0.150
   129.600  1158.594     0.150
   145.662  1175.047     0.150
     0.274     6.949     0.150
     0.274    11.031     0.150
     0.677    13.379     0.150
     0.677    22.090     0.150
     1.138    21.430     0.150
     1.138    37.051     0.150
     1.270    23.730     0.150
     1.270    40.562     0.150
     1.646    29.230     0.150
     1.646    49.262     0.150
     1.480    25.711     0.150
     1.480    46.402     0.150
     1.948    33.070     0.150
     1.948    54.492     0.150
     2.423    44.871     0.150
     2.461    40.449     0.150
     2.461    76.301     0.150
     2.568    42.652     0.150
     2.568    76.449     0.150
     2.698    43.582     0.150
     2.806    49.172     0.150
     2.837    51.930     0.150
     2.776    45.020     0.150
     3.072    57.000     0.150
     3.079    58.090     0.150
     3.245    52.832     0.150
     3.245    53.750     0.150
     3.544    54.742     0.150
     3.517    54.852     0.150
     3.860    59.500     0.150
     4.219    62.352     0.150
     4.219   111.500     0.150
     4.270    66.160     0.150
     4.270   121.922     0.150
     4.541    68.344     0.150
     4.541   122.141     0.150
     4.541   145.605     0.150
     5.113    74.832     0.150
     5.113   148.641     0.150
     6.292    94.230     0.150
     6.292   182.039     0.150
     6.221    93.160     0.150
     6.238    92.711     0.150
     6.572    99.750     0.150
     6.572   177.699     0.150
     6.572   100.582     0.150
     7.191   104.551     0.150
     7.316   111.570     0.150
     9.741   141.777     0.150
    10.204   148.293     0.150
    10.270   149.305     0.150
    10.785   157.109     0.150
    10.802   156.266     0.150
    10.816   156.793     0.150
    11.333   164.395     0.150
    11.290   159.262     0.150
    11.290   280.918     0.150
    11.290   160.262     0.150
    11.290   284.129     0.150
    11.453   165.422     0.150
    11.489   166.316     0.150
    11.569   167.039     0.150
    11.556   169.020     0.150
    11.885   171.492     0.150
    11.785   171.223     0.150
    12.049   173.125     0.150
    12.132   174.156     0.150
    12.280   176.363     0.150
    12.342   176.930     0.150
    12.207   176.461     0.150
    12.383   178.613     0.150
    12.546   179.797     0.150
    12.595   180.102     0.150
    12.626   180.637     0.150
    12.661   180.184     0.150
    12.857   182.898     0.150
    12.955   185.008     0.150
    13.036   187.949     0.150
    13.036   187.977     0.150
    13.036   414.535     0.150
    13.148   187.438     0.150
    13.228   188.176     0.150
    13.240   188.176     0.150
    13.319   189.309     0.150
    13.438   190.621     0.150
    13.558   191.652     0.150
    13.578   192.578     0.150
    13.637   193.965     0.150
    13.637   193.750     0.150
    13.637   340.051     0.150
    13.902   196.789     0.150
    13.918   197.102     0.150
    14.002   197.078     0.150
    14.024   197.938     0.150
    14.061   199.109     0.150
    14.162   200.020     0.150
    14.327   202.207     0.150
    14.340   202.512     0.150
    14.410   203.398     0.150
    14.468   204.809     0.150
    14.490   204.664     0.150
    14.541   204.641     0.150
    14.573   205.359     0.150
    14.634   206.141     0.150
    14.758   207.945     0.150
    14.829   208.227     0.150
    14.863   208.656     0.150
    15.030   211.004     0.150
    15.184   213.625     0.150
    15.202   213.262     0.150
    15.215   214.082     0.150
    15.269   214.477     0.150
    15.269   214.730     0.150
    15.269   380.281     0.150
    15.340   214.879     0.150
    15.120   219.359     0.150
    15.359   214.891     0.150
    15.408   215.578     0.150
    15.474   216.418     0.150
    15.542   217.891     0.150
    15.577   217.977     0.150
    15.577   218.391     0.150
    15.631   218.039     0.150
    15.649   217.145     0.150
    15.695   219.691     0.150
    15.748   222.914     0.150
    15.748   223.223     0.150
    15.771   221.590     0.150
    15.774   221.207     0.150
    15.774   221.570     0.150
    15.784   221.301     0.150
    15.834   221.625     0.150
    15.873   221.793     0.150
    15.872   221.816     0.150
    15.644   223.777     0.150
    15.644   225.852     0.150
    15.644   221.410     0.150
    15.972   222.539     0.150
    16.061   223.426     0.150
    16.028   227.840     0.150
    16.092   224.113     0.150
    16.130   225.797     0.150
    16.171   225.305     0.150
    16.264   226.523     0.150
    16.332   228.215     0.150
    16.346   227.812     0.150
    16.453   229.754     0.150
    16.520   230.059     0.150
    16.590   231.676     0.150
    16.616   231.816     0.150
    16.652   231.422     0.150
    16.667   232.516     0.150
    16.693   231.695     0.150
    16.710   232.539     0.150
    16.739   233.223     0.150
    16.748   232.340     0.150
    16.792   232.977     0.150
    16.885   234.324     0.150
    16.890   233.898     0.150
    16.932   235.484     0.150
    16.724   238.641     0.150
    16.983   239.902     0.150
    17.108   237.762     0.150
    16.882   238.641     0.150
    17.166   237.672     0.150
    17.177   239.180     0.150
    17.165   237.766     0.150
    17.185   238.324     0.150
    17.209   239.305     0.150
    17.219   238.238     0.150
    17.227   238.484     0.150
    17.022   241.922     0.150
    17.307   240.219     0.150
    17.339   240.598     0.150
    17.349   241.238     0.150
    17.338   241.000     0.150
    17.338   243.789     0.150
    17.338   436.609     0.150
    17.443   240.914     0.150
    17.507   241.539     0.150
    17.519   242.441     0.150
    17.559   242.195     0.150
    17.569   243.520     0.150
    17.630   243.871     0.150
    17.704   244.621     0.150
    17.714   245.254     0.150
    17.702   244.262     0.150
    17.699   244.172     0.150
    17.791   246.070     0.150
    17.818   246.602     0.150
    17.819   245.988     0.150
    17.824   247.102     0.150
    17.838   246.344     0.150
    17.898   247.152     0.150
    17.904   246.684     0.150
    17.955   248.301     0.150
    18.018   248.895     0.150
    18.028   248.785     0.150
    18.048   248.637     0.150
    18.079   249.695     0.150
    18.122   250.961     0.150
    18.122   251.191     0.150
    18.137   251.590     0.150
    18.270   252.691     0.150
    18.323   253.578     0.150
    18.324   253.781     0.150
    18.332   253.133     0.150
    18.385   253.352     0.150
    18.406   256.680     0.150
    18.428   256.910     0.150
    18.428   257.570     0.150
    18.452   254.918     0.150
    18.452   255.801     0.150
    18.459   255.309     0.150
    18.451   253.578     0.150
    18.500   254.785     0.150
    18.476   257.562     0.150
    18.476   258.051     0.150
    18.532   255.836     0.150
    18.557   258.500     0.150
    18.651   256.406     0.150
    18.661   257.824     0.150
    18.666   256.215     0.150
    18.776   259.145     0.150
    18.799   260.973     0.150
    18.869   259.895     0.150
    18.859   258.758     0.150
    19.000   261.523     0.150
    19.066   261.773     0.150
    19.065   262.656     0.150
    19.066   261.820     0.150
    19.068   262.094     0.150
    19.068   261.902     0.150
    19.083   261.480     0.150
    19.096   263.965     0.150
    19.096   613.465     0.150
    19.096   263.707     0.150
    19.096   264.551     0.150
    19.096   264.449     0.150
    19.209   263.031     0.150
    19.246   263.852     0.150
    19.273   263.414     0.150
    19.276   265.629     0.150
    19.276   267.180     0.150
    19.354   264.863     0.150
    19.438   265.609     0.150
    19.464   266.070     0.150
    19.464   266.195     0.150
    19.479   266.301     0.150
    19.528   267.129     0.150
    19.562   266.430     0.150
    19.560   267.570     0.150
    19.585   266.922     0.150
    19.619   267.316     0.150
    19.664   268.020     0.150
    19.664   268.711     0.150
    19.679   268.125     0.150
    19.711   268.762     0.150
    19.791   270.270     0.150
    19.835   269.770     0.150
    19.886   270.250     0.150
    19.951   270.617     0.150
    19.953   274.570     0.150
    20.067   272.461     0.150
    20.064   271.867     0.150
    20.123   272.824     0.150
    20.243   274.035     0.150
    20.258   274.812     0.150
    20.269   274.605     0.150
    20.276   274.559     0.150
    20.328   275.746     0.150
    20.401   276.004     0.150
    20.377   278.172     0.150
    20.377   278.922     0.150
    20.469   276.699     0.150
    20.419   279.570     0.150
    20.515   280.723     0.150
    20.623   278.605     0.150
    20.623   279.020     0.150
    20.684   278.234     0.150
    20.717   278.555     0.150
    20.716   280.832     0.150
    20.716   281.500     0.150
    20.781   279.738     0.150
    20.847   280.891     0.150
    20.858   281.402     0.150
    20.905   281.285     0.150
    20.896   284.570     0.150
    20.956   281.828     0.150
    21.022   282.371     0.150
    21.162   283.957     0.150
    21.238   284.582     0.150
    21.109   286.152     0.150
    21.234   288.086     0.150
    21.234   288.352     0.150
    21.320   285.492     0.150
    21.370   285.855     0.150
    21.402   290.336     0.150
    21.402   290.562     0.150
    21.493   287.691     0.150
    21.517   287.922     0.150
    21.518   289.926     0.150
    21.518   289.812     0.150
    21.539   288.262     0.150
    21.555   287.570     0.150
    21.574   288.238     0.150
    21.570   291.156     0.150
    21.570   291.660     0.150
    21.648   289.082     0.150
    21.666   289.082     0.150
    21.669   289.352     0.150
    21.696   291.129     0.150
    21.763   290.566     0.150
    21.737   293.551     0.150
    21.776   293.191     0.150
    21.810   293.012     0.150
    21.810   293.359     0.150
    21.830   293.727     0.150
    21.859   290.809     0.150
    21.907   292.141     0.150
    21.934   291.551     0.150
    21.934   291.723     0.150
    21.951   293.090     0.150
    21.951   292.051     0.150
    22.043   293.449     0.150
    22.054   293.051     0.150
    22.031   296.020     0.150
    22.083   296.902     0.150
    22.146   294.742     0.150
    22.097   298.492     0.150
    22.182   294.898     0.150
    22.189   295.035     0.150
    22.216   294.902     0.150
    22.218   298.223     0.150
    22.255   299.301     0.150
    22.303   297.285     0.150
    22.303   297.500     0.150
    22.379   296.605     0.150
    22.392   297.000     0.150
    22.392   297.410     0.150
    22.395   296.840     0.150
    22.384   299.562     0.150
    22.472   297.730     0.150
    22.508   301.219     0.150
    22.570   302.602     0.150
    22.634   299.773     0.150
    22.624   301.223     0.150
    22.624   301.102     0.150
    22.595   302.520     0.150
    22.596   301.695     0.150
    22.596   302.703     0.150
    22.596   303.250     0.150
    22.712   300.113     0.150
    22.775   301.445     0.150
    22.777   303.289     0.150
    22.813   301.621     0.150
    22.795   303.621     0.150
    22.880   301.918     0.150
    22.929   302.016     0.150
    22.882   306.930     0.150
    22.953   302.781     0.150
    22.967   305.910     0.150
    23.022   305.609     0.150
    23.049   305.441     0.150
    23.078   303.973     0.150
    23.093   303.703     0.150
    23.037   306.160     0.150
    23.183   304.906     0.150
    23.190   307.711     0.150
    23.221   307.949     0.150
    23.277   306.461     0.150
    23.288   306.172     0.150
    23.295   309.652     0.150
    23.370   306.957     0.150
    23.322   310.113     0.150
    23.425   307.801     0.150
    23.381   310.672     0.150
    23.456   308.164     0.150
    23.480   311.621     0.150
    23.507   308.625     0.150
    23.522   310.344     0.150
    23.577   310.109     0.150
    23.463   311.980     0.150
    23.607   309.371     0.150
    23.615   309.246     0.150
    23.621   309.617     0.150
    23.592   312.879     0.150
    23.676   312.957     0.150
    23.781   310.520     0.150
    23.751   314.324     0.150
    23.795   314.797     0.150
    23.861   311.348     0.150
    23.799   314.305     0.150
    23.889   315.891     0.150
    23.925   313.406     0.150
    23.906   314.539     0.150
    23.909   315.020     0.150
    23.946   313.434     0.150
    23.964   313.793     0.150
    23.988   316.660     0.150
    23.988   317.449     0.150
    23.987   317.551     0.150
    24.085   315.641     0.150
    24.031   317.129     0.150
    24.123   314.883     0.150
    24.169   316.555     0.150
    24.169   317.500     0.150
    24.127   317.266     0.150
    24.182   314.984     0.150
    24.209   315.082     0.150
    24.203   317.551     0.150
    24.203   983.949     0.150
    24.177   318.363     0.150
    24.240   315.914     0.150
    24.286   316.180     0.150
    24.297   316.992     0.150
    24.290   319.051     0.150
    24.346   316.570     0.150
    24.361   317.152     0.150
    24.305   318.871     0.150
    24.390   320.637     0.150
    24.446   320.359     0.150
    24.446   320.473     0.150
    24.484   319.660     0.150
    24.513   319.105     0.150
    24.513   319.551     0.150
    24.556   318.816     0.150
    24.574   319.953     0.150
    24.575   321.332     0.150
    24.544   321.484     0.150
    24.602   321.223     0.150
    24.609   321.941     0.150
    24.644   321.680     0.150
    24.644   321.301     0.150
    24.618   322.309     0.150
    24.657   322.609     0.150
    24.774   321.332     0.150
    24.787   320.773     0.150
    24.794   321.414     0.150
    24.831   321.812     0.150
    24.655   323.160     0.150
    24.839   323.820     0.150
    24.866   324.871     0.150
    24.935   322.348     0.150
    24.899   325.004     0.150
    24.899   325.652     0.150
    24.949   324.102     0.150
    24.917   325.246     0.150
    25.000   323.277     0.150
    25.037   325.941     0.150
    25.070   324.250     0.150
    25.062   326.523     0.150
    25.167   324.762     0.150
    25.175   325.055     0.150
    25.132   327.250     0.150
    25.169   326.066     0.150
    25.254   325.695     0.150
    25.210   327.711     0.150
    25.210   328.551     0.150
    25.318   327.129     0.150
    25.322   325.879     0.150
    25.322   326.301     0.150
    25.379   326.996     0.150
    25.397   328.812     0.150
    25.486   327.523     0.150
    25.504   330.039     0.150
    25.528   331.137     0.150
    25.517   330.691     0.150
    25.589   328.918     0.150
    25.637   329.090     0.150
    25.652   331.406     0.150
    25.652   331.691     0.150
    25.753   329.258     0.150
    25.766   330.578     0.150
    25.807   331.605     0.150
    25.831   331.254     0.150
    25.835   331.004     0.150
    25.812   333.551     0.150
    25.854   333.289     0.150
    25.899   330.660     0.150
    25.899   331.910     0.150
    25.911   330.902     0.150
    25.904   334.566     0.150
    25.994   332.039     0.150
    25.991   334.578     0.150
    26.038   334.961     0.150
    26.045   335.227     0.150
    26.124   333.434     0.150
    26.147   333.973     0.150
    26.301   337.402     0.150
    26.398   335.102     0.150
    26.434   336.137     0.150
    26.436   335.656     0.150
    26.457   337.117     0.150
    26.451   337.590     0.150
    26.451   338.160     0.150
    26.463   338.145     0.150
    26.484   337.250     0.150
    26.545   337.945     0.150
    26.547   337.242     0.150
    26.547   337.078     0.150
    26.592   339.148     0.150
    26.600   337.641     0.150
    26.608   339.371     0.150
    26.706   341.223     0.150
    26.762   338.332     0.150
    26.760   340.523     0.150
    26.760   339.680     0.150
    26.771   341.152     0.150
    26.792   341.199     0.150
    26.556   340.801     0.150
    26.556   341.270     0.150
    26.840   339.125     0.150
    26.794   343.102     0.150
    26.676   341.270     0.150
    26.942   340.137     0.150
    26.986   341.281     0.150
    26.986   341.500     0.150
    27.047   342.188     0.150
    27.085   344.910     0.150
    27.085   344.906     0.150
    27.141   341.141     0.150
    27.160   343.234     0.150
    27.163   343.801     0.150
    27.038   344.270     0.150
    27.177   343.199     0.150
    27.220   343.172     0.150
    27.246   344.750     0.150
    27.256   344.703     0.150
    27.256   345.141     0.150
    27.256   345.000     0.150
    27.256   345.000     0.150
    27.273   343.305     0.150
    27.279   345.617     0.150
    27.284   343.723     0.150
    27.301   345.352     0.150
    27.357   344.465     0.150
    27.375   346.043     0.150
    27.360   346.652     0.150
    27.437   347.949     0.150
    27.465   345.551     0.150
    27.509   346.758     0.150
    27.509   347.352     0.150
    27.563   345.246     0.150
    27.581   346.340     0.150
    27.628   346.504     0.150
    27.653   346.156     0.150
    27.697   347.828     0.150
    27.693   348.941     0.150
    27.474   350.684     0.150
    27.763   348.020     0.150
    27.750   351.480     0.150
    27.832   349.543     0.150
    27.842   349.918     0.150
    27.864   348.133     0.150
    27.876   350.371     0.150
    27.918   349.285     0.150
    27.956   351.488     0.150
    27.987   349.613     0.150
    27.952   352.250     0.150
    28.121   350.777     0.150
    28.122   350.996     0.150
    28.166   353.352     0.150
    28.228   352.949     0.150
    28.230   354.250     0.150
    28.264   352.086     0.150
    28.284   352.527     0.150
    28.287   353.473     0.150
    28.326   353.160     0.150
    28.325   354.871     0.150
    28.135   351.973     0.150
    28.382   353.602     0.150
    28.443   353.996     0.150
    28.452   353.664     0.150
    28.490   355.973     0.150
    28.505   356.000     0.150
    28.536   355.996     0.150
    28.570   354.934     0.150
    28.561   355.852     0.150
    28.577   356.219     0.150
    28.677   355.852     0.150
    28.682   358.121     0.150
    28.791   356.711     0.150
    28.786   359.262     0.150
    28.874   358.352     0.150
    28.928   358.270     0.150
    28.924   359.641     0.150
    28.914   360.520     0.150
    28.966   358.984     0.150
    28.972   359.129     0.150
    28.997   359.668     0.150
    29.014   359.105     0.150
    29.041   361.145     0.150
    29.041   362.191     0.150
    29.077   359.004     0.150
    29.074   360.516     0.150
    29.095   361.223     0.150
    29.105   359.469     0.150
    29.156   359.891     0.150
    29.153   363.852     0.150
    29.164   364.082     0.150
    29.234   362.234     0.150
    29.295   361.473     0.150
    29.395   363.977     0.150
    29.395   364.090     0.150
    29.400   364.949     0.150
    29.438   362.328     0.150
    29.459   363.238     0.150
    29.299   363.957     0.150
    29.299   364.570     0.150
    29.504   365.871     0.150
    29.606   365.211     0.150
    29.640   364.805     0.150
    29.630   368.152     0.150
    29.679   365.883     0.150
    29.678   367.949     0.150
    29.698   366.059     0.150
    29.700   365.738     0.150
    29.720   366.074     0.150
    29.725   365.152     0.150
    29.788   365.516     0.150
    29.800   365.789     0.150
    29.800   367.238     0.150
    29.876   366.520     0.150
    29.906   367.180     0.150
    29.910   369.391     0.150
    30.004   368.000     0.150
    30.032   368.070     0.150
    30.037   369.242     0.150
    30.097   371.871     0.150
    30.118   368.848     0.150
    30.193   369.844     0.150
    30.221   369.410     0.150
    30.249   370.188     0.150
    30.253   371.211     0.150
    30.282   371.188     0.150
    30.303   371.312     0.150
    30.336   371.633     0.150
    30.303   372.852     0.150
    30.344   370.848     0.150
    30.310   373.023     0.150
    30.433   371.348     0.150
    30.439   371.496     0.150
    30.438   372.871     0.150
    30.438   373.797     0.150
    30.438   374.051     0.150
    30.502   375.039     0.150
    30.563   372.184     0.150
    30.690   376.812     0.150
    30.728   376.879     0.150
    30.776   373.910     0.150
    30.850   375.977     0.150
    30.855   376.332     0.150
    30.870   375.332     0.150
    30.886   376.516     0.150
    30.877   377.891     0.150
    30.964   376.715     0.150
    30.914   376.750     0.150
    30.991   377.613     0.150
    31.026   376.055     0.150
    31.026   378.141     0.150
    31.053   376.691     0.150
    31.063   377.293     0.150
    31.182   377.641     0.150
    31.276   380.035     0.150
    31.391   379.820     0.150
    31.382   382.672     0.150
    31.463   380.922     0.150
    31.519   383.129     0.150
    31.539   382.059     0.150
    31.566   382.492     0.150
    31.579   381.559     0.150
    31.581   381.711     0.150
    31.581   382.512     0.150
    31.582   382.660     0.150
    31.588   383.031     0.150
    31.598   382.285     0.150
    31.599   382.473     0.150
    31.601   382.461     0.150
    31.607   381.539     0.150
    31.629   382.277     0.150
    31.596   384.801     0.150
    31.657   382.668     0.150
    31.669   384.191     0.150
    31.646   384.023     0.150
    31.695   384.371     0.150
    31.789   382.898     0.150
    31.825   385.098     0.150
    31.825   385.473     0.150
    31.778   385.840     0.150
    31.805   384.953     0.150
    31.862   383.984     0.150
    31.880   384.297     0.150
    31.948   386.617     0.150
    32.048   386.559     0.150
    32.058   386.492     0.150
    31.932   384.809     0.150
    32.092   387.012     0.150
    32.092   387.121     0.150
    32.114   387.172     0.150
    32.101   388.109     0.150
    32.127   386.910     0.150
    32.152   386.863     0.150
    32.199   388.590     0.150
    32.188   388.820     0.150
    32.180   389.367     0.150
    32.230   389.426     0.150
    32.230   389.250     0.150
    32.256   387.738     0.150
    32.252   389.117     0.150
    32.252   388.223     0.150
    32.419   389.973     0.150
    32.425   390.211     0.150
    32.580   392.441     0.150
    32.604   392.500     0.150
    32.777   393.449     0.150
    32.792   392.051     0.150
    32.792   391.859     0.150
    32.858   394.500     0.150
    33.025   396.590     0.150
    33.132   397.188     0.150
    33.156   397.531     0.150
    33.180   397.852     0.150
    33.321   399.379     0.150
    33.402   399.410     0.150
    33.396   400.051     0.150
    33.404   398.871     0.150
    33.417   399.961     0.150
    33.521   398.824     0.150
    33.540   400.582     0.150
    33.530   401.035     0.150
    33.683   402.152     0.150
    33.705   403.227     0.150
    34.038   404.340     0.150
    34.233   406.891     0.150
    34.356   408.980     0.150
    34.473   407.789     0.150
    34.486   408.242     0.150
    34.520   409.301     0.150
    34.520   409.949     0.150
    34.530   409.461     0.150
    34.577   409.449     0.150
    34.588   410.023     0.150
    34.658   411.742     0.150
    34.691   411.723     0.150
    34.732   411.672     0.150
    34.844   410.301     0.150
    34.911   413.730     0.150
    34.981   414.332     0.150
    35.011   413.922     0.150
    35.087   413.750     0.150
    35.090   414.852     0.150
    35.116   414.922     0.150
    35.147   413.492     0.150
    35.149   413.949     0.150
    35.153   415.230     0.150
    35.158   414.430     0.150
    35.387   416.621     0.150
    35.439   416.441     0.150
    35.503   416.289     0.150
    35.635   419.664     0.150
    35.717   419.320     0.150
    36.271   423.609     0.150
    36.304   424.199     0.150
    36.349   425.070     0.150
    36.395   424.930     0.150
    36.489   426.840     0.150
    36.738   429.840     0.150
    37.005   430.488     0.150
    37.446   433.281     0.150
    38.084   438.531     0.150
    39.008   445.832     0.150
    39.653   452.152     0.150
    40.980   462.531     0.150
    41.888   471.051     0.150
    42.114   471.852     0.150
    42.787   477.965     0.150
    44.183   488.379     0.150
    45.206   499.027     0.150
    45.573   499.395     0.150
    46.312   506.871     0.150
    46.860   509.297     0.150
    46.860   509.289     0.150
    46.970   510.320     0.150
    47.266   515.211     0.150
    47.496   935.449     0.150
    49.354   531.902     0.150
    51.544   545.625     0.150
    52.610  1003.852     0.150
    53.617   563.652     0.150
    53.769   564.562     0.150
    54.480   569.473     0.150
    54.723   571.359     0.150
    55.045   573.152     0.150
    55.263   574.430     0.150
    55.301   575.262     0.150
    55.494   575.109     0.150
    55.808   577.176     0.150
    55.806   578.410     0.150
    55.938   578.949     0.150
    56.052   579.949     0.150
    56.090   580.109     0.150
    56.449   583.051     0.150
    56.449   582.910     0.150
    56.539   584.051     0.150
    56.577   583.789     0.150
    56.671   584.051     0.150
    56.671     8.699     0.150
    56.669   583.980     0.150
    56.684   584.152     0.150
    56.725   584.750     0.150
    56.875   586.449     0.150
    57.286   587.949     0.150
    57.463   589.301     0.150
    57.463   589.301     0.150
    57.469   589.949     0.150
    57.668   591.051     0.150
    57.727   590.242     0.150
    57.724   591.742     0.150
    57.726   591.410     0.150
    57.737   590.859     0.150
    57.866   591.949     0.150
    57.866   592.332     0.150
    57.928   593.211     0.150
    57.971   591.402     0.150
    57.971     8.801     0.150
    58.048   593.230     0.150
    58.051   593.801     0.150
    58.094   593.891     0.150
    58.350   595.551     0.150
    58.550   596.992     0.150
    58.638   597.250     0.150
    58.747   597.891     0.150
    59.000   600.152     0.150
    59.277   601.496     0.150
    59.277   601.652     0.150
    59.277     8.199     0.150
    59.250   601.051     0.150
    59.376   602.250     0.150
    59.928   607.012     0.150
    60.151   607.551     0.150
    60.151     8.500     0.150
    59.891  1099.949     0.150
    62.241   621.250     0.150
    63.270   630.082     0.150
    65.619   644.652     0.150
    65.619   644.473     0.150
    70.183   671.750     0.150
    71.707   680.852     0.150
    76.040   708.051     0.150
    76.040     9.102     0.150
    77.674   717.652     0.150
    79.963   730.551     0.150
    80.238   731.250     0.150
    80.406   732.449     0.150
    80.528   732.750     0.150
    80.677   733.152     0.150
    80.864   734.352     0.150
    80.968   735.250     0.150
    80.979   736.352     0.150
    81.051   735.852     0.150
    81.055   735.750     0.150
    81.169   736.352     0.150
    81.204   736.652     0.150
    81.217   736.152     0.150
    81.349   737.949     0.150
    81.743   739.371     0.150
    81.799   739.551     0.150
    83.124   747.152     0.150
    83.457   748.051     0.150
    83.707   749.352     0.150
    84.138   752.102     0.150
    84.139   752.102     0.150
    85.005   757.652     0.150
    85.132   757.051     0.150
    85.132   757.332     0.150
    85.132   757.324     0.150
    85.220   756.551     0.150
    85.712   758.582     0.150
    85.712   758.574     0.150
    85.763   760.262     0.150
    85.926   759.352     0.150
    86.099   762.020     0.150
    86.401   763.582     0.150
    86.745   765.230     0.150
    89.042   775.949     0.150
    90.453   782.051     0.150
    90.453  1792.051     0.150
    90.639   782.551     0.150
    90.970   782.949     0.150
    90.970   998.250     0.150
    90.970   782.977     0.150
    90.970   998.289     0.150
    90.970   782.852     0.150
    90.954   784.789     0.150
    91.181   784.961     0.150
    91.804   787.949     0.150
    91.943   788.652     0.150
    92.011   788.852     0.150
    92.377   790.250     0.150
    92.377     9.199     0.150
    92.377  1419.750     0.150
    92.629   791.426     0.150
    92.758   792.750     0.150
    93.728   797.051     0.150
    93.961   797.699     0.150
    95.126   803.551     0.150
    95.947   807.352     0.150
    95.810   806.402     0.150
    96.356   807.949     0.150
    96.783   810.152     0.150
    96.783  1046.180     0.150
    96.787   810.156     0.150
    96.787  1046.184     0.150
    99.242  1068.711     0.150
   104.802  1103.746     0.150
   108.882  1138.730     0.150
   108.882  1784.352     0.150
   108.882  1138.730     0.150
   108.882  1784.352     0.150
   109.454  1137.020     0.150
   109.458  1137.027     0.150
   109.950  1143.270     0.150
   110.239  1142.633     0.150
   111.593  1155.902     0.150
   112.781  1115.949     0.150
   112.781  1160.949     0.150
   112.781  1777.223     0.150
   112.872  1115.949     0.150
   112.872  1160.992     0.150
   115.771  1121.551     0.150
   115.771  1187.352     0.150
   115.771  1549.852     0.150
   115.771  2140.551     0.150
   116.701  1123.699     0.150
   116.701  1188.020     0.150
   116.701  1755.582     0.150
   116.701  1123.699     0.150
   116.701  1188.027     0.150
   116.701  1755.578     0.150
   119.035  1133.852     0.150
   119.332  1131.551     0.150
   119.332  1216.051     0.150
   119.332  1349.352     0.150
   119.332  1626.852     0.150
   119.332  2191.051     0.150
   121.695  1134.652     0.150
   122.925  1134.551     0.150
   122.925  1237.051     0.150
   122.907  1137.500     0.150
   123.847  1140.051     0.150
   123.847  1249.551     0.150
   123.847  1355.352     0.150
   123.847  1567.551     0.150
   123.847  1657.051     0.150
   123.847  2251.852     0.150
   125.463  1142.109     0.150
   127.525  1146.551     0.150
   127.525  1155.551     0.150
   127.525  1265.352     0.150
   127.525  1577.051     0.150
   128.870  1148.980     0.150
   128.871  1148.977     0.150
   129.547  1149.801     0.150
   129.548  1149.801     0.150
   130.003   960.051     0.150
   130.003  1286.551     0.150
   132.996  1158.051     0.150
   132.996  1168.551     0.150
   132.996  1303.551     0.150
   132.996  2360.551     0.150
   134.113  1160.051     0.150
   134.113  1316.051     0.150
   134.113  2382.852     0.150
   140.506  1169.941     0.150
   140.506  1169.938     0.150
   140.506  1171.051     0.150
   145.349  1178.832     0.150
   145.970  1179.051     0.150
   150.295  1192.582     0.150
   151.603  1195.945     0.150
   153.360  1198.617     0.150
   153.360  1191.949     0.150
   153.360  1198.852     0.150
   153.360  1211.051     0.150
     0.725    13.871     0.150
     0.865    16.691     0.150
     0.865    29.602     0.150
     0.865    16.859     0.150
     1.023    18.859     0.150
     1.023    31.652     0.150
     1.094    20.543     0.150
     1.094    35.211     0.150
     1.429    24.500     0.150
     1.429    41.910     0.150
     2.010    33.520     0.150
     2.010    59.711     0.150
     2.139    34.242     0.150
     2.139    59.461     0.150
     2.143    35.012     0.150
     2.143    61.051     0.150
     2.176    35.609     0.150
     2.176    63.871     0.150
     2.318    37.660     0.150
     2.318    65.391     0.150
     2.337    38.270     0.150
     2.337    66.770     0.150
     2.487    40.441     0.150
     2.487    69.473     0.150
     2.617    45.070     0.150
     2.617    42.281     0.150
     2.617    73.641     0.150
     2.694    40.301     0.150
     2.694    70.793     0.150
     2.756    42.801     0.150
     2.756    75.000     0.150
     3.713    56.422     0.150
     3.713   100.191     0.150
     3.713    58.359     0.150
     3.768    56.840     0.150
     3.768    99.789     0.150
     3.768   120.691     0.150
     4.607    67.070     0.150
     4.607   119.242     0.150
     5.500   142.582     0.150
     6.546    95.562     0.150
     6.546   167.902     0.150
     6.982   105.020     0.150
     9.717   140.465     0.150
    10.186   146.945     0.150
    10.292   148.672     0.150
    10.576   150.270     0.150
    10.576   263.445     0.150
    10.576   150.383     0.150
    10.576   264.211     0.150
    10.830   156.023     0.150
    10.847   156.305     0.150
    11.351   162.688     0.150
    11.429   164.152     0.150
    11.544   165.816     0.150
    11.558   165.582     0.150
    11.559   165.848     0.150
    11.731   165.520     0.150
    11.755   168.312     0.150
    11.800   166.699     0.150
    11.949   170.926     0.150
    11.992   173.172     0.150
    12.070   171.941     0.150
    12.110   172.719     0.150
    12.180   172.527     0.150
    12.279   175.508     0.150
    12.405   175.957     0.150
    12.450   178.020     0.150
    12.607   178.152     0.150
    12.642   178.641     0.150
    12.682   179.344     0.150
    12.800   181.297     0.150
    12.859   181.715     0.150
    13.007   182.715     0.150
    13.043   184.891     0.150
    13.248   186.598     0.150
    13.290   187.516     0.150
    13.293   187.547     0.150
    13.325   190.020     0.150
    13.324   190.246     0.150
    13.324   420.020     0.150
    13.386   188.359     0.150
    13.444   188.270     0.150
    13.444   186.621     0.150
    13.444   336.883     0.150
    13.489   190.129     0.150
    13.725   193.852     0.150
    13.725   194.270     0.150
    13.775   193.273     0.150
    13.837   193.742     0.150
    13.971   196.477     0.150
    14.036   196.863     0.150
    14.040   197.297     0.150
    14.103   198.145     0.150
    14.131   197.395     0.150
    14.236   198.434     0.150
    14.252   199.812     0.150
    14.290   200.227     0.150
    14.484   202.129     0.150
    14.515   200.172     0.150
    14.538   203.473     0.150
    14.548   204.223     0.150
    14.548   364.324     0.150
    14.554   203.688     0.150
    14.643   203.797     0.150
    14.707   206.055     0.150
    14.744   205.051     0.150
    14.743   204.789     0.150
    14.769   206.859     0.150
    14.902   211.871     0.150
    14.873   207.199     0.150
    14.911   208.094     0.150
    15.049   208.621     0.150
    15.050   208.996     0.150
    15.091   209.188     0.150
    15.226   213.062     0.150
    15.228   213.207     0.150
    15.250   213.281     0.150
    15.289   212.621     0.150
    15.296   212.074     0.150
    15.349   213.812     0.150
    15.377   212.277     0.150
    15.423   213.383     0.150
    15.453   220.660     0.150
    15.436   214.543     0.150
    15.436   214.250     0.150
    15.452   215.559     0.150
    15.576   216.707     0.150
    15.727   218.086     0.150
    15.733   218.062     0.150
    15.769   224.910     0.150
    15.751   217.410     0.150
    15.795   220.258     0.150
    15.808   218.598     0.150
    15.816   220.188     0.150
    15.817   220.914     0.150
    15.818   220.207     0.150
    15.850   220.949     0.150
    15.904   219.809     0.150
    15.919   219.867     0.150
    15.941   219.707     0.150
    15.989   223.551     0.150
    16.044   223.281     0.150
    16.064   225.312     0.150
    16.138   229.422     0.150
    16.141   222.613     0.150
    16.220   225.215     0.150
    16.282   224.500     0.150
    16.309   228.332     0.150
    16.381   226.059     0.150
    16.400   226.602     0.150
    16.420   225.848     0.150
    16.440   225.906     0.150
    16.489   227.254     0.150
    16.493   229.223     0.150
    16.540   228.102     0.150
    16.569   233.043     0.150
    16.571   228.688     0.150
    16.596   230.086     0.150
    16.597   230.309     0.150
    16.614   230.336     0.150
    16.654   231.094     0.150
    16.792   231.297     0.150
    16.823   232.906     0.150
    16.892   232.582     0.150
    16.968   234.141     0.150
    17.159   235.516     0.150
    17.171   236.344     0.150
    17.184   237.871     0.150
    17.188   237.387     0.150
    17.213   237.941     0.150
    17.252   236.469     0.150
    17.261   236.820     0.150
    17.308   237.734     0.150
    17.331   238.023     0.150
    17.341   237.887     0.150
    17.420   240.270     0.150
    17.428   243.973     0.150
    17.519   241.395     0.150
    17.541   242.262     0.150
    17.541   242.590     0.150
    17.560   240.676     0.150
    17.573   241.148     0.150
    17.602   241.430     0.150
    17.658   242.793     0.150
    17.670   242.664     0.150
    17.679   243.555     0.150
    17.718   247.195     0.150
    17.718   246.660     0.150
    17.734   243.027     0.150
    17.746   244.320     0.150
    17.777   243.262     0.150
    17.825   246.215     0.150
    17.845   243.973     0.150
    17.909   246.695     0.150
    17.927   247.191     0.150
    17.941   245.770     0.150
    18.056   248.770     0.150
    18.130   248.039     0.150
    18.172   248.996     0.150
    18.206   249.715     0.150
    18.223   250.516     0.150
    18.252   251.090     0.150
    18.269   251.488     0.150
    18.269   251.652     0.150
    18.300   249.992     0.150
    18.330   251.602     0.150
    18.356   251.629     0.150
    18.356   253.203     0.150
    18.435   253.348     0.150
    18.460   253.711     0.150
    18.460   254.043     0.150
    18.482   252.680     0.150
    18.485   254.078     0.150
    18.500   253.238     0.150
    18.519   253.398     0.150
    18.523   253.277     0.150
    18.586   255.238     0.150
    18.658   255.020     0.150
    18.669   256.055     0.150
    18.724   258.230     0.150
    18.755   259.535     0.150
    18.755   261.852     0.150
    18.824   257.512     0.150
    18.873   260.293     0.150
    18.885   258.461     0.150
    18.922   259.426     0.150
    18.940   262.117     0.150
    18.940   262.672     0.150
    18.936   258.922     0.150
    18.993   259.434     0.150
    19.027   260.133     0.150
    19.044   259.805     0.150
    19.050   259.629     0.150
    19.069   260.277     0.150
    19.069   260.402     0.150
    19.094   260.707     0.150
    19.128   263.562     0.150
    19.157   261.332     0.150
    19.286   262.461     0.150
    19.286   262.484     0.150
    19.297   262.613     0.150
    19.297   262.730     0.150
    19.306   263.020     0.150
    19.359   262.859     0.150
    19.367   263.531     0.150
    19.385   263.859     0.150
    19.397   266.098     0.150
    19.397   265.777     0.150
    19.397   265.973     0.150
    19.427   263.551     0.150
    19.427   479.902     0.150
    19.436   263.832     0.150
    19.460   264.137     0.150
    19.579   266.516     0.150
    19.585   265.926     0.150
    19.614   264.770     0.150
    19.626   268.090     0.150
    19.641   266.238     0.150
    19.656   266.645     0.150
    19.668   266.477     0.150
    19.668   266.730     0.150
    19.737   267.754     0.150
    19.739   267.340     0.150
    19.780   267.660     0.150
    19.790   271.281     0.150
    19.790   270.730     0.150
    19.876   268.277     0.150
    19.937   273.531     0.150
    19.937   274.109     0.150
    19.954   269.562     0.150
    20.026   270.215     0.150
    20.143   271.906     0.150
    20.151   271.945     0.150
    20.151   272.480     0.150
    20.216   272.500     0.150
    20.256   273.449     0.150
    20.270   273.027     0.150
    20.286   273.543     0.150
    20.354   277.543     0.150
    20.378   274.723     0.150
    20.423   274.566     0.150
    20.609   276.258     0.150
    20.623   276.473     0.150
    20.763   281.094     0.150
    20.784   278.508     0.150
    20.802   278.887     0.150
    20.897   280.117     0.150
    20.934   283.473     0.150
    20.933   282.668     0.150
    20.933   282.242     0.150
    20.952   283.793     0.150
    20.951   280.168     0.150
    20.993   280.559     0.150
    21.093   281.902     0.150
    21.111   281.770     0.150
    21.247   283.172     0.150
    21.270   283.207     0.150
    21.309   284.141     0.150
    21.374   288.090     0.150
    21.439   285.480     0.150
    21.441   286.109     0.150
    21.516   286.965     0.150
    21.525   286.586     0.150
    21.540   286.914     0.150
    21.612   287.570     0.150
    21.618   287.504     0.150
    21.640   287.656     0.150
    21.650   287.070     0.150
    21.710   288.699     0.150
    21.713   288.141     0.150
    21.762   292.391     0.150
    21.762   292.270     0.150
    21.759   290.754     0.150
    21.759   290.562     0.150
    21.790   288.656     0.150
    21.819   292.898     0.150
    21.819   293.293     0.150
    22.024   291.938     0.150
    22.024   292.770     0.150
    22.080   295.504     0.150
    22.097   292.168     0.150
    22.105   294.918     0.150
    22.105   295.090     0.150
    22.134   295.336     0.150
    22.134   295.211     0.150
    22.176   293.344     0.150
    22.186   293.129     0.150
    22.186   293.832     0.150
    22.209   293.770     0.150
    22.240   293.879     0.150
    22.269   296.984     0.150
    22.283   297.984     0.150
    22.348   294.566     0.150
    22.378   295.562     0.150
    22.397   294.758     0.150
    22.457   297.258     0.150
    22.457   298.160     0.150
    22.553   295.840     0.150
    22.558   300.621     0.150
    22.585   296.871     0.150
    22.615   297.137     0.150
    22.638   301.531     0.150
    22.651   298.469     0.150
    22.660   301.512     0.150
    22.709   299.891     0.150
    22.728   302.371     0.150
    22.731   302.055     0.150
    22.806   299.926     0.150
    22.816   299.598     0.150
    22.817   300.297     0.150
    22.844   301.785     0.150
    22.844   302.871     0.150
    22.852   300.348     0.150
    22.956   300.758     0.150
    22.989   305.320     0.150
    22.994   303.410     0.150
    23.028   301.656     0.150
    23.073   305.898     0.150
    23.087   303.371     0.150
    23.110   302.086     0.150
    23.123   306.477     0.150
    23.122   305.770     0.150
    23.128   302.848     0.150
    23.128   303.473     0.150
    23.139   305.820     0.150
    23.139   307.168     0.150
    23.139   306.660     0.150
    23.276   303.773     0.150
    23.282   306.371     0.150
    23.293   305.004     0.150
    23.320   305.461     0.150
    23.350   305.852     0.150
    23.369   307.152     0.150
    23.412   307.371     0.150
    23.419   305.590     0.150
    23.448   306.324     0.150
    23.458   306.801     0.150
    23.476   310.102     0.150
    23.475   305.867     0.150
    23.512   309.312     0.150
    23.562   307.020     0.150
    23.590   311.469     0.150
    23.594   307.625     0.150
    23.614   311.449     0.150
    23.707   308.055     0.150
    23.715   312.371     0.150
    23.746   311.203     0.150
    23.770   308.957     0.150
    23.836   314.621     0.150
    23.849   310.242     0.150
    23.860   314.527     0.150
    23.888   311.512     0.150
    23.899   314.484     0.150
    23.908   313.883     0.150
    23.931   311.590     0.150
    23.959   311.945     0.150
    23.960   312.129     0.150
    24.016   312.680     0.150
    24.046   314.992     0.150
    24.094   318.180     0.150
    24.069   311.883     0.150
    24.077   316.211     0.150
    24.081   313.309     0.150
    24.078   313.070     0.150
    24.079   312.055     0.150
    24.094   316.234     0.150
    24.113   313.410     0.150
    24.237   313.707     0.150
    24.249   317.266     0.150
    24.281   317.680     0.150
    24.278   314.035     0.150
    24.299   317.934     0.150
    24.299   316.305     0.150
    24.323   317.867     0.150
    24.435   319.320     0.150
    24.465   316.297     0.150
    24.469   319.320     0.150
    24.505   320.508     0.150
    24.505   319.871     0.150
    24.540   320.172     0.150
    24.536   318.676     0.150
    24.546   319.172     0.150
    24.587   322.609     0.150
    24.607   318.520     0.150
    24.607   318.711     0.150
    24.620   320.441     0.150
    24.626   320.711     0.150
    24.686   323.012     0.150
    24.675   321.172     0.150
    24.679   318.332     0.150
    24.728   320.773     0.150
    24.728   321.230     0.150
    24.734   322.152     0.150
    24.768   319.902     0.150
    24.803   320.008     0.150
    24.803   319.797     0.150
    24.807   319.871     0.150
    24.867   322.051     0.150
    24.867   322.172     0.150
    24.885   320.242     0.150
    24.893   322.418     0.150
    24.906   322.883     0.150
    24.931   323.426     0.150
    24.932   321.000     0.150
    24.944   323.000     0.150
    24.963   323.602     0.150
    25.032   324.609     0.150
    25.063   327.949     0.150
    25.079   321.785     0.150
    25.105   325.242     0.150
    25.112   325.359     0.150
    25.137   322.672     0.150
    25.137   322.832     0.150
    25.145   325.594     0.150
    25.158   324.973     0.150
    25.184   325.672     0.150
    25.205   323.844     0.150
    25.212   326.125     0.150
    25.212   326.840     0.150
    25.244   323.855     0.150
    25.364   327.543     0.150
    25.367   325.984     0.150
    25.379   328.148     0.150
    25.379   327.871     0.150
    25.379   327.641     0.150
    25.391   325.117     0.150
    25.415   327.879     0.150
    25.424   328.012     0.150
    25.430   328.293     0.150
    25.458   325.871     0.150
    25.540   325.945     0.150
    25.553   326.980     0.150
    25.609   330.094     0.150
    25.644   329.871     0.150
    25.666   327.957     0.150
    25.684   327.449     0.150
    25.738   329.562     0.150
    25.744   331.539     0.150
    25.744   331.172     0.150
    25.814   329.785     0.150
    25.823   328.422     0.150
    25.842   329.449     0.150
    25.895   333.590     0.150
    25.895   331.230     0.150
    25.860   329.918     0.150
    25.866   331.871     0.150
    25.874   330.629     0.150
    25.931   334.520     0.150
    25.936   333.293     0.150
    25.959   332.570     0.150
    25.996   336.992     0.150
    25.981   330.156     0.150
    26.024   333.773     0.150
    26.080   334.250     0.150
    26.078   331.871     0.150
    26.092   330.867     0.150
    26.099   334.496     0.150
    26.099   334.031     0.150
    26.096   330.859     0.150
    26.196   334.793     0.150
    26.233   335.723     0.150
    26.275   335.793     0.150
    26.330   332.559     0.150
    26.347   334.691     0.150
    26.348   332.172     0.150
    26.363   336.391     0.150
    26.462   338.195     0.150
    26.482   335.090     0.150
    26.522   335.734     0.150
    26.554   335.391     0.150
    26.552   337.191     0.150
    26.555   335.281     0.150
    26.575   336.129     0.150
    26.584   337.781     0.150
    26.586   335.875     0.150
    26.628   337.105     0.150
    26.636   338.883     0.150
    26.672   337.914     0.150
    26.672   338.270     0.150
    26.695   338.004     0.150
    26.732   339.547     0.150
    26.732   336.531     0.150
    26.752   339.223     0.150
    26.804   341.102     0.150
    26.790   336.891     0.150
    26.875   338.105     0.150
    26.908   343.500     0.150
    26.919   340.516     0.150
    27.000   343.973     0.150
    26.974   341.621     0.150
    26.988   339.262     0.150
    27.051   339.508     0.150
    27.072   342.672     0.150
    27.107   340.172     0.150
    27.110   340.656     0.150
    27.146   343.973     0.150
    27.152   341.012     0.150
    27.180   343.801     0.150
    27.221   341.609     0.150
    27.240   341.598     0.150
    27.241   341.734     0.150
    27.242   342.129     0.150
    27.264   342.742     0.150
    27.291   342.023     0.150
    27.300   345.027     0.150
    27.343   342.074     0.150
    27.380   346.852     0.150
    27.398   344.234     0.150
    27.438   345.246     0.150
    27.493   347.191     0.150
    27.510   343.723     0.150
    27.529   346.477     0.150
    27.536   346.285     0.150
    27.536   345.961     0.150
    27.536   346.090     0.150
    27.536   345.973     0.150
    27.571   347.270     0.150
    27.571   347.371     0.150
    27.587   344.879     0.150
    27.634   345.578     0.150
    27.669   347.367     0.150
    27.671   345.520     0.150
    27.710   348.172     0.150
    27.718   345.891     0.150
    27.777   345.402     0.150
    27.843   350.473     0.150
    27.842   347.254     0.150
    27.925   347.336     0.150
    27.928   348.309     0.150
    27.960   349.262     0.150
    27.972   349.301     0.150
    27.974   348.098     0.150
    28.002   350.020     0.150
    28.008   349.598     0.150
    28.071   348.492     0.150
    28.089   348.578     0.150
    28.105   351.609     0.150
    28.212   349.824     0.150
    28.249   354.191     0.150
    28.321   352.055     0.150
    28.321   351.355     0.150
    28.399   351.957     0.150
    28.420   351.449     0.150
    28.454   352.043     0.150
    28.464   354.512     0.150
    28.470   355.070     0.150
    28.467   352.824     0.150
    28.522   354.691     0.150
    28.525   355.512     0.150
    28.556   352.910     0.150
    28.604   354.371     0.150
    28.616   356.031     0.150
    28.641   353.355     0.150
    28.648   355.812     0.150
    28.662   355.535     0.150
    28.690   355.383     0.150
    28.739   354.574     0.150
    28.858   356.078     0.150
    28.858   355.590     0.150
    28.975   359.121     0.150
    29.027   357.750     0.150
    29.037   358.000     0.150
    29.054   357.211     0.150
    29.074   360.199     0.150
    29.087   358.859     0.150
    29.095   357.148     0.150
    29.106   357.336     0.150
    29.111   358.660     0.150
    29.137   357.934     0.150
    29.187   359.676     0.150
    29.221   360.500     0.150
    29.263   359.391     0.150
    29.299   360.613     0.150
    29.324   362.953     0.150
    29.324   363.660     0.150
    29.375   362.266     0.150
    29.385   360.180     0.150
    29.425   363.852     0.150
    29.430   364.371     0.150
    29.450   365.242     0.150
    29.571   362.832     0.150
    29.621   364.172     0.150
    29.647   364.895     0.150
    29.647   364.652     0.150
    29.648   366.031     0.150
    29.688   363.664     0.150
    29.686   366.332     0.150
    29.693   363.402     0.150
    29.709   364.773     0.150
    29.759   363.816     0.150
    29.763   366.801     0.150
    29.767   364.711     0.150
    29.785   363.469     0.150
    29.807   364.984     0.150
    29.818   365.523     0.150
    29.818   364.180     0.150
    29.859   367.438     0.150
    29.859   367.160     0.150
    29.857   364.445     0.150
    29.921   366.301     0.150
    29.937   366.613     0.150
    29.971   368.859     0.150
    29.972   365.918     0.150
    30.011   366.641     0.150
    30.064   366.559     0.150
    30.137   370.871     0.150
    30.137    12.801     0.150
    30.229   367.602     0.150
    30.252   367.551     0.150
    30.258   368.184     0.150
    30.288   371.633     0.150
    30.299   368.879     0.150
    30.362   368.988     0.150
    30.371   370.402     0.150
    30.373   371.152     0.150
    30.380   369.512     0.150
    30.383   370.352     0.150
    30.412   372.871     0.150
    30.419   370.758     0.150
    30.423   369.320     0.150
    30.430   369.039     0.150
    30.526   370.184     0.150
    30.571   372.703     0.150
    30.724   371.887     0.150
    30.733   375.070     0.150
    30.726   374.758     0.150
    30.726   375.070     0.150
    30.809   373.922     0.150
    30.804   372.938     0.150
    30.808   376.109     0.150
    30.895   374.367     0.150
    30.934   375.168     0.150
    30.985   375.406     0.150
    30.996   374.984     0.150
    31.008   374.344     0.150
    31.017   377.672     0.150
    31.050   374.258     0.150
    31.073   374.742     0.150
    31.121   376.793     0.150
    31.135   377.125     0.150
    31.148   378.883     0.150
    31.164   377.738     0.150
    31.164   377.473     0.150
    31.147   375.652     0.150
    31.175   378.859     0.150
    31.253   378.285     0.150
    31.256   378.762     0.150
    31.337   377.523     0.150
    31.396   378.020     0.150
    31.466   380.000     0.150
    31.525   378.359     0.150
    31.574   379.852     0.150
    31.581   380.176     0.150
    31.629   380.793     0.150
    31.641   380.605     0.150
    31.644   381.078     0.150
    31.660   381.699     0.150
    31.660   381.625     0.150
    31.666   382.191     0.150
    31.667   381.973     0.150
    31.693   382.148     0.150
    31.712   380.680     0.150
    31.766   383.141     0.150
    31.774   383.770     0.150
    31.799   384.570     0.150
    31.820   381.277     0.150
    31.825   381.605     0.150
    31.853   396.621     0.150
    31.860   384.738     0.150
    31.860   382.195     0.150
    32.011   385.062     0.150
    32.117   385.379     0.150
    32.124   385.852     0.150
    32.135   385.500     0.150
    32.140   387.707     0.150
    32.151   384.977     0.150
    32.164   385.066     0.150
    32.198   386.438     0.150
    32.207   386.363     0.150
    32.250   386.016     0.150
    32.289   390.680     0.150
    32.323   387.941     0.150
    32.354   387.973     0.150
    32.400   389.031     0.150
    32.413   389.930     0.150
    32.488   389.598     0.150
    32.488   389.871     0.150
    32.490   387.371     0.150
    32.490   387.973     0.150
    32.540   390.430     0.150
    32.540   390.672     0.150
    32.630   390.684     0.150
    33.071   396.195     0.150
    33.162   395.461     0.150
    33.461   398.641     0.150
    33.461   398.340     0.150
    33.480   398.449     0.150
    33.526   396.672     0.150
    33.587   399.145     0.150
    33.640   399.543     0.150
    33.713   400.109     0.150
    33.720   401.340     0.150
    33.996   403.070     0.150
    34.085   403.062     0.150
    34.124   404.043     0.150
    34.129   404.160     0.150
    34.485   406.293     0.150
    34.520   408.121     0.150
    34.526   407.371     0.150
    34.590   409.461     0.150
    34.602   410.070     0.150
    34.648   408.723     0.150
    34.764   408.770     0.150
    34.774   410.871     0.150
    34.856   410.270     0.150
    34.886   411.391     0.150
    35.032   412.598     0.150
    35.042   412.191     0.150
    35.057   413.410     0.150
    35.136   412.160     0.150
    35.401   415.680     0.150
    35.499   416.371     0.150
    35.535   416.723     0.150
    35.547   417.238     0.150
    35.667   416.602     0.150
    35.696   419.973     0.150
    35.749   417.340     0.150
    35.847   418.473     0.150
    35.913   420.570     0.150
    36.020   421.340     0.150
    36.147   423.672     0.150
    36.233   421.199     0.150
    36.369   422.012     0.150
    36.532   423.840     0.150
    36.620   423.500     0.150
    36.642   426.172     0.150
    36.732   427.422     0.150
    36.789   426.527     0.150
    36.911   428.793     0.150
    37.399   431.945     0.150
    37.665   432.750     0.150
    38.650   442.793     0.150
    42.034   470.609     0.150
    42.118   470.172     0.150
    43.496   479.430     0.150
    44.616   491.996     0.150
    44.770   494.371     0.150
    45.285   495.496     0.150
    45.285   495.371     0.150
    46.549   505.922     0.150
    47.049   509.117     0.150
    47.049   507.910     0.150
    47.114   509.609     0.150
    47.280   512.180     0.150
    47.606   516.883     0.150
    47.892   518.082     0.150
    48.150   933.270     0.150
    48.826   525.312     0.150
    52.348   551.121     0.150
    52.957   555.902     0.150
    53.094  1002.172     0.150
    53.179   557.609     0.150
    53.992   565.473     0.150
    54.773   568.871     0.150
    54.865   571.090     0.150
    55.433   575.340     0.150
    55.621   575.832     0.150
    55.685   576.570     0.150
    55.933   578.141     0.150
    55.955   577.480     0.150
    56.062   577.320     0.150
    56.104   578.582     0.150
    56.157   579.211     0.150
    56.303   580.070     0.150
    56.355   581.000     0.150
    56.504   581.551     0.150
    56.838   583.973     0.150
    57.086   584.121     0.150
    57.129   587.000     0.150
    57.638   589.262     0.150
    57.804   591.770     0.150
    57.810   589.262     0.150
    57.811   589.871     0.150
    57.811   590.422     0.150
    57.840   590.973     0.150
    58.011   590.070     0.150
    58.034   591.770     0.150
    58.078   591.410     0.150
    58.092   593.172     0.150
    58.134   592.551     0.150
    58.231   592.680     0.150
    58.215   592.570     0.150
    58.215   593.180     0.150
    58.248   593.973     0.150
    58.397   595.293     0.150
    58.425   594.512     0.150
    58.457   595.031     0.150
    58.725   596.320     0.150
    58.789   595.797     0.150
    58.937   598.582     0.150
    59.006   598.062     0.150
    59.064   597.973     0.150
    59.064   598.340     0.150
    59.127   598.711     0.150
    59.357   600.922     0.150
    59.669   602.312     0.150
    60.174   605.371     0.150
    60.255   607.590     0.150
    60.522  1101.570     0.150
    60.522  1344.570     0.150
    60.542   608.262     0.150
    60.548   608.270     0.150
    62.140   618.770     0.150
    62.898   624.871     0.150
    62.898   625.270     0.150
    64.533   635.402     0.150
    65.449   641.371     0.150
    66.080   647.449     0.150
    66.290   647.770     0.150
    67.581   656.109     0.150
    69.965   669.172     0.150
    71.576   678.371     0.150
    76.395   708.270     0.150
    76.395   707.609     0.150
    79.096   723.672     0.150
    79.319  1318.473     0.150
    79.319  1630.770     0.150
    79.885   727.770     0.150
    79.885  1628.871     0.150
    80.083  1332.973     0.150
    80.083  1653.172     0.150
    80.086   728.570     0.150
    80.086  1324.672     0.150
    80.086  1641.973     0.150
    80.096   728.172     0.150
    80.096  1325.270     0.150
    80.096  1641.973     0.150
    80.179  1332.570     0.150
    80.179  1651.371     0.150
    80.296   729.570     0.150
    80.296  1328.270     0.150
    80.296   729.371     0.150
    80.387  1331.910     0.150
    80.495   731.172     0.150
    80.495  1337.770     0.150
    80.495  1645.770     0.150
    80.576  1333.473     0.150
    80.576  1655.070     0.150
    80.625  1329.473     0.150
    80.625  1651.371     0.150
    80.640   731.371     0.150
    80.640  1328.871     0.150
    80.640  1645.770     0.150
    80.752  1336.172     0.150
    80.879  1330.672     0.150
    80.879  1655.973     0.150
    81.212   734.473     0.150
    81.212  1334.070     0.150
    81.212  1670.973     0.150
    82.888   743.672     0.150
    83.139   744.645     0.150
    83.139   744.723     0.150
    83.179   745.043     0.150
    83.518   746.695     0.150
    84.136  1366.672     0.150
    84.136  1709.871     0.150
    84.647   752.473     0.150
    84.678   753.570     0.150
    84.826   752.973     0.150
    84.826   753.570     0.150
    85.542   756.270     0.150
    85.646   756.871     0.150
    85.775   758.270     0.150
    86.168   758.473     0.150
    86.168   758.922     0.150
    87.757   769.172     0.150
    88.718   774.570     0.150
    89.025   775.371     0.150
    89.277   773.570     0.150
    89.971   778.371     0.150
    90.046   778.371     0.150
    90.046   988.371     0.150
    90.046  1399.371     0.150
    90.046  1499.371     0.150
    90.046  1782.371     0.150
    90.220   986.770     0.150
    90.429   780.742     0.150
    90.491   782.371     0.150
    90.717   779.496     0.150
    90.773   781.770     0.150
    90.773   993.930     0.150
    90.773  1433.371     0.150
    90.773  1797.371     0.150
    91.287   998.871     0.150
    91.377   785.973     0.150
    91.377   998.371     0.150
    91.377  1414.770     0.150
    91.377  1515.371     0.150
    91.377  1805.973     0.150
    91.528  1000.172     0.150
    91.528  1416.871     0.150
    91.528  1514.570     0.150
    91.528  1808.973     0.150
    91.581   784.770     0.150
    91.703  1001.371     0.150
    91.703  1418.570     0.150
    91.703  1516.871     0.150
    92.093  1005.301     0.150
    92.093  1423.109     0.150
    92.103  1006.270     0.150
    92.103  1420.570     0.150
    92.103  1518.570     0.150
    92.103  1815.770     0.150
    92.185   788.410     0.150
    92.354  1005.473     0.150
    92.354  1422.270     0.150
    92.354  1520.672     0.150
    92.354  1817.473     0.150
    92.380   790.789     0.150
    92.401  1006.473     0.150
    92.709   790.199     0.150
    92.709   789.570     0.150
    92.709    14.199     0.150
    92.709  1419.871     0.150
    92.709  1455.770     0.150
    92.709  1828.270     0.150
    93.285   793.871     0.150
    93.322   795.070     0.150
    93.396   793.652     0.150
    93.400   792.473     0.150
    93.627  1016.270     0.150
    94.052   795.973     0.150
    94.052  1021.672     0.150
    94.331   798.770     0.150
    94.331  1023.121     0.150
    94.331  1430.699     0.150
    94.392   799.246     0.150
    95.037  1028.652     0.150
    95.606   801.172     0.150
    95.606  1556.172     0.150
    95.797   802.371     0.150
    96.051   804.770     0.150
    96.051  1814.047     0.150
    96.222   807.250     0.150
    96.222  1037.730     0.150
    99.076   818.871     0.150
    99.076  1061.473     0.150
    99.076  1458.473     0.150
    99.076  1602.672     0.150
   100.555   825.672     0.150
   103.022   836.570     0.150
   108.462  1777.723     0.150
   109.551  1137.473     0.150
   110.104   865.371     0.150
   110.104  1140.070     0.150
   110.104  1708.473     0.150
   110.104  2065.672     0.150
   111.893  1158.293     0.150
   114.806  1117.770     0.150
   114.806  1176.070     0.150
   114.806  2129.871     0.150
   116.161  1122.371     0.150
   116.161  2147.473     0.150
   116.775  1121.246     0.150
   116.775  1750.223     0.150
   119.468  1128.172     0.150
   119.468  1621.973     0.150
   119.468  2194.871     0.150
   119.551  1128.770     0.150
   121.470  1132.219     0.150
   121.514  1226.770     0.150
   121.514  1558.871     0.150
   121.514  1635.270     0.150
   121.514  2214.871     0.150
   123.028  1134.570     0.150
   123.028  1148.371     0.150
   123.028  1238.672     0.150
   123.028  1348.973     0.150
   123.028  1560.871     0.150
   123.028  1645.570     0.150
   123.028  2236.770     0.150
   123.199  1242.070     0.150
   123.199  2243.570     0.150
   123.275  1135.871     0.150
   123.275  1239.672     0.150
   123.275  1351.371     0.150
   123.275  1565.371     0.150
   123.275  1650.570     0.150
   123.275  2240.973     0.150
   123.844  1136.973     0.150
   123.844  1150.570     0.150
   123.844  1353.770     0.150
   123.844  1565.570     0.150
   127.449  1142.672     0.150
   127.909  1144.570     0.150
   127.909  1270.570     0.150
   127.909  1570.371     0.150
   127.909  2299.070     0.150
   129.611  1148.070     0.150
   129.622  1147.621     0.150
   130.278  1148.520     0.150
   130.278  1352.922     0.150
   130.454   956.172     0.150
   130.454  1284.371     0.150
   130.454  1362.973     0.150
   130.454  1693.770     0.150
   130.454  2326.570     0.150
   133.411  1152.672     0.150
   133.411  1164.270     0.150
   133.411  1307.570     0.150
   133.411  1713.473     0.150
   133.411  2368.070     0.150
   134.660  1318.973     0.150
   140.923  1168.520     0.150
   145.977  1178.871     0.150
     0.274     8.391     0.150
     0.650    13.227     0.150
     0.650    22.680     0.150
     1.011    18.375     0.150
     1.011    31.422     0.150
     1.185    21.531     0.150
     1.185    36.211     0.150
     1.185    20.922     0.150
     1.185    21.711     0.150
     1.332    23.711     0.150
     1.332    39.625     0.150
     1.478    25.586     0.150
     1.478    44.078     0.150
     1.505    25.539     0.150
     1.505    43.805     0.150
     1.538    26.250     0.150
     1.538    45.422     0.150
     1.910    31.688     0.150
     1.910    54.445     0.150
     2.008    32.320     0.150
     2.008    57.539     0.150
     2.040    34.625     0.150
     2.040    62.148     0.150
     2.295    37.766     0.150
     2.338    37.289     0.150
     2.338    73.898     0.150
     2.362    39.625     0.150
     2.441    38.727     0.150
     2.455    39.117     0.150
     2.455    73.148     0.150
     2.612    41.125     0.150
     2.612    74.711     0.150
     2.679    43.266     0.150
     2.679    80.539     0.150
     2.751    44.828     0.150
     2.751    75.367     0.150
     2.760    46.070     0.150
     2.944    46.328     0.150
     2.944    92.352     0.150
     2.953    45.859     0.150
     2.953    91.625     0.150
     3.139    49.352     0.150
     3.139    83.250     0.150
     3.139    49.055     0.150
     3.417    52.156     0.150
     3.417    99.758     0.150
     4.158   111.680     0.150
     4.581    72.047     0.150
     4.581   136.500     0.150
     4.735    73.117     0.150
     6.246    92.078     0.150
     6.246   157.352     0.150
     6.216   161.961     0.150
     6.462    94.852     0.150
     7.186   107.539     0.150
    10.077   142.664     0.150
    10.142   149.961     0.150
    10.657   155.055     0.150
    10.689   152.648     0.150
    11.236   159.055     0.150
    11.236   279.180     0.150
    11.236   160.102     0.150
    11.327   163.547     0.150
    11.362   162.969     0.150
    11.451   164.250     0.150
    11.758   168.672     0.150
    11.921   170.547     0.150
    12.004   171.695     0.150
    12.214   172.289     0.150
    12.219   175.578     0.150
    12.498   178.367     0.150
    12.730   180.391     0.150
    12.918   183.680     0.150
    12.917   185.023     0.150
    12.917   412.922     0.150
    13.100   184.305     0.150
    13.113   186.195     0.150
    13.192   187.703     0.150
    13.451   189.789     0.150
    13.791   195.039     0.150
    13.896   197.602     0.150
    13.933   198.477     0.150
    14.363   201.953     0.150
    14.413   203.531     0.150
    14.445   204.227     0.150
    14.509   204.062     0.150
    14.630   206.461     0.150
    14.651   206.172     0.150
    14.705   206.539     0.150
    14.736   211.945     0.150
    14.904   209.789     0.150
    15.056   211.055     0.150
    15.076   210.266     0.150
    15.087   212.758     0.150
    15.142   217.906     0.150
    15.281   217.281     0.150
    15.349   214.961     0.150
    15.415   220.695     0.150
    15.451   217.492     0.150
    15.451   214.969     0.150
    15.508   216.555     0.150
    15.568   221.414     0.150
    15.644   223.031     0.150
    15.647   218.289     0.150
    15.632   220.633     0.150
    15.632   218.789     0.150
    15.657   218.914     0.150
    15.706   220.773     0.150
    15.746   221.281     0.150
    15.746   222.438     0.150
    15.850   221.812     0.150
    15.943   225.359     0.150
    15.967   222.641     0.150
    16.003   225.680     0.150
    16.048   225.562     0.150
    16.147   228.609     0.150
    16.206   229.570     0.150
    16.325   230.977     0.150
    16.394   231.500     0.150
    16.462   232.602     0.150
    16.488   232.930     0.150
    16.530   231.719     0.150
    16.540   232.883     0.150
    16.548   235.969     0.150
    16.574   233.359     0.150
    16.585   230.133     0.150
    16.612   231.406     0.150
    16.627   233.414     0.150
    16.678   233.914     0.150
    16.761   234.016     0.150
    16.773   234.852     0.150
    16.805   235.094     0.150
    16.879   236.039     0.150
    16.982   237.141     0.150
    17.043   238.414     0.150
    17.050   238.852     0.150
    17.058   239.070     0.150
    17.082   239.586     0.150
    17.099   237.305     0.150
    17.111   239.016     0.150
    17.180   240.883     0.150
    17.214   240.695     0.150
    17.226   238.281     0.150
    17.226   238.656     0.150
    17.227   242.008     0.150
    17.371   241.836     0.150
    17.385   242.516     0.150
    17.395   242.156     0.150
    17.441   243.180     0.150
    17.442   241.797     0.150
    17.504   241.734     0.150
    17.588   242.773     0.150
    17.589   242.000     0.150
    17.577   244.180     0.150
    17.587   244.109     0.150
    17.665   243.531     0.150
    17.696   243.422     0.150
    17.699   244.086     0.150
    17.690   244.930     0.150
    17.718   246.023     0.150
    17.771   246.195     0.150
    17.771   245.852     0.150
    17.828   247.836     0.150
    17.909   248.328     0.150
    17.936   246.812     0.150
    17.954   247.188     0.150
    17.997   249.617     0.150
    18.010   249.461     0.150
    18.031   248.383     0.150
    18.074   249.609     0.150
    18.143   250.023     0.150
    18.196   251.695     0.150
    18.197   251.562     0.150
    18.206   250.000     0.150
    18.223   249.477     0.150
    18.262   251.648     0.150
    18.275   251.148     0.150
    18.290   254.820     0.150
    18.334   252.312     0.150
    18.324   252.984     0.150
    18.341   251.906     0.150
    18.332   252.977     0.150
    18.313   255.383     0.150
    18.313   253.109     0.150
    18.374   252.102     0.150
    18.374   251.898     0.150
    18.405   253.641     0.150
    18.375   255.648     0.150
    18.375   255.781     0.150
    18.441   255.000     0.150
    18.526   253.656     0.150
    18.534   255.023     0.150
    18.553   254.594     0.150
    18.629   255.305     0.150
    18.640   256.891     0.150
    18.649   256.062     0.150
    18.666   256.039     0.150
    18.684   257.078     0.150
    18.743   256.969     0.150
    18.742   257.375     0.150
    18.851   258.414     0.150
    18.872   258.875     0.150
    18.939   259.430     0.150
    18.938   259.016     0.150
    18.941   259.180     0.150
    18.941   258.648     0.150
    18.962   259.570     0.150
    18.979   261.070     0.150
    18.979   260.211     0.150
    19.082   260.508     0.150
    19.120   261.750     0.150
    19.154   261.867     0.150
    19.198   262.516     0.150
    19.181   264.945     0.150
    19.181   264.148     0.150
    19.227   262.008     0.150
    19.227   261.789     0.150
    19.268   262.586     0.150
    19.310   262.727     0.150
    19.339   265.008     0.150
    19.354   264.039     0.150
    19.401   264.383     0.150
    19.416   264.172     0.150
    19.435   264.508     0.150
    19.435   263.812     0.150
    19.459   264.586     0.150
    19.466   264.742     0.150
    19.491   264.836     0.150
    19.537   265.430     0.150
    19.537   265.320     0.150
    19.551   265.516     0.150
    19.585   266.078     0.150
    19.664   266.539     0.150
    19.697   266.773     0.150
    19.708   267.445     0.150
    19.766   266.945     0.150
    19.824   268.055     0.150
    19.845   272.172     0.150
    19.935   269.945     0.150
    19.947   269.586     0.150
    19.940   269.398     0.150
    19.996   269.883     0.150
    20.122   272.227     0.150
    20.116   271.375     0.150
    20.131   272.070     0.150
    20.143   271.336     0.150
    20.148   271.789     0.150
    20.191   272.164     0.150
    20.209   272.727     0.150
    20.201   272.891     0.150
    20.275   273.320     0.150
    20.267   276.148     0.150
    20.267   274.922     0.150
    20.341   273.930     0.150
    20.324   277.266     0.150
    20.415   274.250     0.150
    20.410   278.266     0.150
    20.520   276.172     0.150
    20.520   276.320     0.150
    20.557   275.898     0.150
    20.590   276.445     0.150
    20.594   278.945     0.150
    20.594   278.719     0.150
    20.653   278.164     0.150
    20.729   282.031     0.150
    20.720   282.562     0.150
    20.739   277.320     0.150
    20.739   531.672     0.150
    20.779   278.273     0.150
    20.806   278.648     0.150
    20.828   278.883     0.150
    20.796   281.719     0.150
    20.895   279.688     0.150
    21.012   281.648     0.150
    21.034   281.062     0.150
    21.080   283.500     0.150
    21.112   282.203     0.150
    21.141   285.961     0.150
    21.141   285.727     0.150
    21.192   283.023     0.150
    21.220   283.164     0.150
    21.243   282.820     0.150
    21.295   287.305     0.150
    21.347   287.547     0.150
    21.366   285.156     0.150
    21.393   284.836     0.150
    21.411   285.656     0.150
    21.397   286.281     0.150
    21.397   286.102     0.150
    21.429   285.086     0.150
    21.447   286.164     0.150
    21.475   288.836     0.150
    21.475   289.641     0.150
    21.540   286.531     0.150
    21.542   286.523     0.150
    21.575   288.938     0.150
    21.635   287.633     0.150
    21.637   290.617     0.150
    21.648   291.578     0.150
    21.678   291.992     0.150
    21.695   290.031     0.150
    21.695   290.289     0.150
    21.732   288.844     0.150
    21.711   290.469     0.150
    21.780   289.523     0.150
    21.814   288.867     0.150
    21.824   291.141     0.150
    21.935   290.656     0.150
    21.938   290.211     0.150
    21.938   294.883     0.150
    22.019   293.055     0.150
    21.995   295.352     0.150
    22.010   295.367     0.150
    22.054   292.398     0.150
    22.062   293.305     0.150
    22.089   292.250     0.150
    22.090   292.953     0.150
    22.124   296.445     0.150
    22.155   296.898     0.150
    22.179   293.445     0.150
    22.230   296.141     0.150
    22.253   294.188     0.150
    22.264   294.922     0.150
    22.264   295.047     0.150
    22.267   294.742     0.150
    22.345   295.852     0.150
    22.463   298.602     0.150
    22.507   298.727     0.150
    22.502   299.328     0.150
    22.502   297.891     0.150
    22.499   300.414     0.150
    22.502   300.820     0.150
    22.506   300.750     0.150
    22.506   299.805     0.150
    22.506   300.641     0.150
    22.585   299.109     0.150
    22.565   299.125     0.150
    22.565   745.289     0.150
    22.655   298.148     0.150
    22.648   300.000     0.150
    22.685   300.562     0.150
    22.680   299.258     0.150
    22.753   299.859     0.150
    22.803   300.023     0.150
    22.785   304.469     0.150
    22.840   299.688     0.150
    22.854   300.594     0.150
    22.871   303.031     0.150
    22.951   302.055     0.150
    22.933   579.867     0.150
    22.967   301.789     0.150
    22.949   305.008     0.150
    23.056   302.805     0.150
    23.075   305.109     0.150
    23.102   305.250     0.150
    23.149   303.945     0.150
    23.150   303.883     0.150
    23.179   303.617     0.150
    23.188   307.180     0.150
    23.243   304.422     0.150
    23.275   304.867     0.150
    23.297   304.977     0.150
    23.313   305.273     0.150
    23.287   308.984     0.150
    23.328   305.852     0.150
    23.324   308.367     0.150
    23.394   305.648     0.150
    23.374   309.391     0.150
    23.374   746.938     0.150
    23.425   309.078     0.150
    23.400   309.250     0.150
    23.400   307.406     0.150
    23.456   306.867     0.150
    23.412   309.234     0.150
    23.481   306.461     0.150
    23.487   306.609     0.150
    23.494   307.523     0.150
    23.496   311.266     0.150
    23.597   307.336     0.150
    23.675   309.922     0.150
    23.662   311.289     0.150
    23.789   309.992     0.150
    23.806   311.281     0.150
    23.808   310.898     0.150
    23.780   313.180     0.150
    23.819   310.328     0.150
    23.868   311.836     0.150
    23.871   309.672     0.150
    23.871   314.539     0.150
    23.894   314.055     0.150
    23.894   314.242     0.150
    23.897   314.289     0.150
    23.898   314.258     0.150
    23.963   312.688     0.150
    23.943   314.109     0.150
    23.995   312.305     0.150
    24.055   313.320     0.150
    24.044   314.312     0.150
    24.030   315.219     0.150
    24.083   312.852     0.150
    24.113   313.375     0.150
    24.089   315.500     0.150
    24.183   313.648     0.150
    24.180   317.086     0.150
    24.219   314.820     0.150
    24.241   313.570     0.150
    24.223   317.102     0.150
    24.332   315.305     0.150
    24.299   317.273     0.150
    24.328   317.773     0.150
    24.328   318.008     0.150
    24.357   316.594     0.150
    24.405   316.188     0.150
    24.405   316.070     0.150
    24.429   316.836     0.150
    24.447   317.891     0.150
    24.447   317.000     0.150
    24.460   319.508     0.150
    24.458   319.547     0.150
    24.488   318.680     0.150
    24.522   318.438     0.150
    24.522   319.000     0.150
    24.569   319.797     0.150
    24.569   320.391     0.150
    24.647   319.008     0.150
    24.661   318.305     0.150
    24.666   319.180     0.150
    24.703   319.477     0.150
    24.754   323.117     0.150
    24.769   322.180     0.150
    24.807   320.375     0.150
    24.799   323.305     0.150
    24.827   321.086     0.150
    24.822   322.875     0.150
    24.873   320.977     0.150
    24.902   322.758     0.150
    24.949   320.969     0.150
    24.973   324.727     0.150
    25.040   321.625     0.150
    25.048   322.758     0.150
    25.126   323.461     0.150
    25.119   324.992     0.150
    25.198   323.602     0.150
    25.198   323.297     0.150
    25.190   325.438     0.150
    25.251   325.531     0.150
    25.358   325.438     0.150
    25.392   327.727     0.150
    25.461   327.109     0.150
    25.429   327.938     0.150
    25.431   327.719     0.150
    25.430   328.445     0.150
    25.510   325.930     0.150
    25.548   329.281     0.150
    25.548   329.547     0.150
    25.626   327.688     0.150
    25.604   330.258     0.150
    25.680   329.664     0.150
    25.740   329.289     0.150
    25.777   329.969     0.150
    25.777   329.438     0.150
    25.784   329.164     0.150
    25.845   333.031     0.150
    25.817   333.008     0.150
    25.866   329.836     0.150
    25.880   331.703     0.150
    25.880   332.086     0.150
    25.925   331.359     0.150
    25.961   329.680     0.150
    25.950   333.852     0.150
    25.997   331.742     0.150
    26.019   332.758     0.150
    26.012   333.031     0.150
    26.269   332.805     0.150
    26.271   332.664     0.150
    26.309   335.359     0.150
    26.329   335.344     0.150
    26.329   335.156     0.150
    26.329   761.156     0.150
    26.374   334.758     0.150
    26.419   336.344     0.150
    26.542   334.562     0.150
    26.594   338.492     0.150
    26.620   340.391     0.150
    26.703   335.648     0.150
    26.677   338.789     0.150
    26.712   336.461     0.150
    26.699   341.164     0.150
    26.716   339.805     0.150
    26.814   337.641     0.150
    26.859   338.656     0.150
    26.859   338.352     0.150
    27.014   338.859     0.150
    27.120   342.320     0.150
    27.137   342.461     0.150
    27.137   342.586     0.150
    27.137   342.617     0.150
    27.137   342.500     0.150
    27.184   340.961     0.150
    27.247   344.211     0.150
    27.347   342.508     0.150
    27.330   345.555     0.150
    27.330    12.156     0.150
    27.384   344.695     0.150
    27.525   344.117     0.150
    27.570   344.945     0.150
    27.737   345.789     0.150
    27.791   347.391     0.150
    27.831   348.742     0.150
    27.860   347.984     0.150
    27.994   349.445     0.150
    28.049   351.000     0.150
    28.113   351.898     0.150
    28.156   350.125     0.150
    28.194   353.156     0.150
    28.208   351.891     0.150
    28.304   352.141     0.150
    28.316   353.500     0.150
    28.352   353.141     0.150
    28.447   353.266     0.150
    28.442   352.508     0.150
    28.564   355.156     0.150
    28.753   355.391     0.150
    28.801   355.992     0.150
    28.816   356.992     0.150
    28.970   358.500     0.150
    29.275   361.828     0.150
    29.275   361.656     0.150
    29.310   361.031     0.150
    29.312   361.594     0.150
    29.392   363.211     0.150
    29.566   363.047     0.150
    29.799   367.070     0.150
    29.876   365.352     0.150
    29.916   365.406     0.150
    29.928   366.945     0.150
    29.928     7.930     0.150
    29.991   366.391     0.150
    29.981   369.250     0.150
    29.981     8.336     0.150
    29.999   368.031     0.150
    30.122   368.398     0.150
    30.127   368.219     0.150
    30.190   368.117     0.150
    30.209   368.570     0.150
    30.198   370.570     0.150
    30.213   370.969     0.150
    30.321   371.375     0.150
    30.321   371.500     0.150
    30.386   372.258     0.150
    30.602   373.016     0.150
    30.602     8.414     0.150
    30.588   374.422     0.150
    30.648   373.258     0.150
    30.722   371.969     0.150
    30.728   372.758     0.150
    30.760   375.242     0.150
    30.837   374.289     0.150
    31.054   375.742     0.150
    31.264   376.633     0.150
    31.283   379.242     0.150
    31.454   379.586     0.150
    31.454   379.188     0.150
    31.472   380.094     0.150
    31.474   380.406     0.150
    31.502   380.391     0.150
    31.546   380.188     0.150
    31.559   381.242     0.150
    31.585   381.852     0.150
    31.700   381.859     0.150
    31.700   382.742     0.150
    31.734   381.484     0.150
    31.752   381.461     0.150
    31.790   387.047     0.150
    31.931   383.664     0.150
    31.965   383.773     0.150
    31.966   384.391     0.150
    31.984   385.547     0.150
    32.078   385.922     0.150
    32.073   385.750     0.150
    32.078   387.547     0.150
    32.128   385.391     0.150
    32.114   386.562     0.150
    32.114   386.250     0.150
    32.131   386.945     0.150
    32.306   387.398     0.150
    32.315   387.508     0.150
    32.315     8.750     0.150
    32.492   390.070     0.150
    32.482   390.664     0.150
    32.614   391.398     0.150
    32.668   390.766     0.150
    32.668     8.000     0.150
    32.673   388.695     0.150
    32.742   392.086     0.150
    33.064   395.141     0.150
    33.393   396.625     0.150
    33.393   395.648     0.150
    33.393     8.172     0.150
    33.429   398.555     0.150
    34.116   404.445     0.150
    34.361   404.992     0.150
    34.361    12.930     0.150
    34.406   406.273     0.150
    34.484   407.688     0.150
    34.978   411.219     0.150
    34.983   412.398     0.150
    34.983    12.320     0.150
    35.035   410.625     0.150
    42.819   476.844     0.150
    44.241   486.977     0.150
    45.287   497.727     0.150
    45.287   498.250     0.150
    45.453   496.875     0.150
    45.453     7.133     0.150
    46.737   506.594     0.150
    46.775   506.789     0.150
    46.802   507.672     0.150
    47.152   513.195     0.150
    47.152   512.656     0.150
    47.152   513.367     0.150
    49.445   531.039     0.150
    53.507   561.109     0.150
    55.192   573.125     0.150
    55.379   573.039     0.150
    55.688   574.875     0.150
    55.688     9.102     0.150
    55.688     9.477     0.150
    55.694   576.750     0.150
    55.827   576.258     0.150
    55.827     9.414     0.150
    57.181   586.750     0.150
    57.350   586.539     0.150
    57.351   586.852     0.150
    57.351     9.195     0.150
    57.351   587.602     0.150
    57.358   587.305     0.150
    57.619   589.531     0.150
    57.619     8.844     0.150
    57.940   591.727     0.150
    57.982   592.086     0.150
    58.239   593.328     0.150
    58.441   595.320     0.150
    58.441     8.734     0.150
    58.527   595.039     0.150
    58.888   598.148     0.150
    59.144   599.172     0.150
    59.144     8.594     0.150
    59.458   600.898     0.150
    59.458     9.375     0.150
    59.458   601.320     0.150
    59.458     9.195     0.150
    59.813   604.938     0.150
    60.037   604.891     0.150
    60.037     8.195     0.150
    65.493   641.945     0.150
    65.493   642.125     0.150
    71.580   677.852     0.150
    75.928   706.148     0.150
    75.928     8.867     0.150
    83.616   747.398     0.150
    83.656   748.047     0.150
    85.013   754.750     0.150
    95.014   803.547     0.150
    95.016   801.352     0.150
   127.416  1144.648     0.150
   128.084  1144.914     0.150
   128.911  1151.227     0.150
     0.168     4.598     0.150
     0.242     5.768     0.150
     0.242     9.777     0.150
     1.019    18.407     0.150
     1.019    31.788     0.150
     1.287    23.008     0.150
     1.287    39.348     0.150
     1.436    25.458     0.150
     1.436    42.888     0.150
     1.488    26.668     0.150
     1.488    45.668     0.150
     1.562    28.197     0.150
     1.562    28.067     0.150
     1.562    47.678     0.150
     2.021    34.098     0.150
     2.021    58.458     0.150
     1.985    33.058     0.150
     1.985    58.138     0.150
     2.087    35.748     0.150
     2.087    61.098     0.150
     2.296    37.548     0.150
     2.296    65.798     0.150
     2.467    42.978     0.150
     2.467    39.878     0.150
     2.479    41.817     0.150
     2.603    42.518     0.150
     2.603    73.428     0.150
     2.735    44.938     0.150
     2.735    76.768     0.150
     2.850    50.397     0.150
     2.960    48.008     0.150
     3.902    60.147     0.150
     5.509    85.958     0.150
     6.183    96.758     0.150
     7.664   116.768     0.150
     7.872   119.447     0.150
    10.052   148.944     0.150
    10.092   151.324     0.150
    10.581   158.137     0.150
    10.642   158.723     0.150
    10.678   158.674     0.150
    11.144   167.288     0.150
    11.155   165.664     0.150
    11.280   167.780     0.150
    11.418   169.049     0.150
    11.977   175.508     0.150
    12.212   178.146     0.150
    12.421   181.518     0.150
    12.504   182.377     0.150
    12.698   185.708     0.150
    12.698   184.646     0.150
    12.701   185.688     0.150
    12.845   187.280     0.150
    13.045   188.876     0.150
    13.165   191.149     0.150
    13.412   194.397     0.150
    13.412   191.078     0.150
    13.714   197.475     0.150
    13.844   200.028     0.150
    13.902   200.149     0.150
    14.288   204.555     0.150
    14.314   204.655     0.150
    14.360   205.970     0.150
    14.415   206.653     0.150
    14.558   208.041     0.150
    14.616   209.062     0.150
    14.749   210.477     0.150
    14.932   212.641     0.150
    14.983   213.002     0.150
    15.035   213.639     0.150
    15.108   214.689     0.150
    15.108   215.328     0.150
    15.271   217.497     0.150
    15.392   220.520     0.150
    15.414   218.035     0.150
    15.492   219.107     0.150
    15.492   219.987     0.150
    15.553   220.968     0.150
    15.553   222.548     0.150
    15.566   226.048     0.150
    15.591   220.562     0.150
    15.733   223.755     0.150
    15.952   225.081     0.150
    16.009   227.031     0.150
    16.090   226.523     0.150
    16.303   230.710     0.150
    16.302   230.295     0.150
    16.432   232.167     0.150
    16.525   232.631     0.150
    16.562   236.808     0.150
    16.562   526.188     0.150
    16.617   234.880     0.150
    16.627   233.944     0.150
    16.644   234.564     0.150
    16.710   235.089     0.150
    16.741   235.514     0.150
    16.825   237.754     0.150
    16.834   236.975     0.150
    16.851   236.732     0.150
    16.925   237.802     0.150
    16.948   240.000     0.150
    16.948   241.378     0.150
    17.020   239.190     0.150
    17.049   238.854     0.150
    17.060   239.062     0.150
    17.060   238.027     0.150
    17.165   240.287     0.150
    17.227   240.011     0.150
    17.370   241.983     0.150
    17.452   242.921     0.150
    17.464   242.876     0.150
    17.490   243.932     0.150
    17.524   243.979     0.150
    17.543   245.126     0.150
    17.695   245.466     0.150
    17.695   245.888     0.150
    17.756   248.487     0.150
    17.807   248.659     0.150
    17.858   249.462     0.150
    18.005   250.300     0.150
    18.012   250.631     0.150
    18.048   254.157     0.150
    18.047   254.005     0.150
    18.047   253.478     0.150
    18.044   249.683     0.150
    18.064   253.190     0.150
    18.097   251.071     0.150
    18.200   256.838     0.150
    18.208   253.168     0.150
    18.234   253.965     0.150
    18.297   254.719     0.150
    18.345   254.828     0.150
    18.384   255.827     0.150
    18.414   254.777     0.150
    18.423   256.758     0.150
    18.435   258.788     0.150
    18.484   255.938     0.150
    18.530   258.191     0.150
    18.582   257.741     0.150
    18.665   258.547     0.150
    18.691   259.027     0.150
    18.746   261.612     0.150
    18.746   261.357     0.150
    18.739   259.310     0.150
    18.733   258.370     0.150
    18.795   259.613     0.150
    18.824   263.045     0.150
    18.824   262.647     0.150
    18.902   260.767     0.150
    18.907   259.635     0.150
    18.969   261.797     0.150
    18.995   261.962     0.150
    19.004   261.968     0.150
    19.047   261.585     0.150
    19.064   262.416     0.150
    19.074   261.664     0.150
    19.165   262.606     0.150
    19.211   263.642     0.150
    19.211   264.638     0.150
    19.279   264.201     0.150
    19.308   264.864     0.150
    19.318   265.528     0.150
    19.400   266.069     0.150
    19.411   267.277     0.150
    19.427   264.741     0.150
    19.448   266.792     0.150
    19.494   267.928     0.150
    19.515   267.985     0.150
    19.552   271.438     0.150
    19.603   267.803     0.150
    19.613   268.496     0.150
    19.691   269.280     0.150
    19.733   269.382     0.150
    19.807   270.012     0.150
    19.819   270.593     0.150
    19.818   270.249     0.150
    19.828   269.968     0.150
    19.855   270.578     0.150
    19.885   272.388     0.150
    19.959   272.728     0.150
    19.966   275.407     0.150
    19.983   273.998     0.150
    19.983   275.567     0.150
    19.991   271.937     0.150
    20.005   271.786     0.150
    20.081   272.787     0.150
    20.100   273.336     0.150
    20.100   271.885     0.150
    20.169   274.199     0.150
    20.261   274.905     0.150
    20.314   275.442     0.150
    20.318   275.288     0.150
    20.411   278.650     0.150
    20.411   279.357     0.150
    20.459   280.907     0.150
    20.530   277.049     0.150
    20.552   278.321     0.150
    20.579   278.709     0.150
    20.597   279.729     0.150
    20.780   280.592     0.150
    20.776   284.678     0.150
    20.803   280.476     0.150
    20.807   280.972     0.150
    20.861   281.122     0.150
    20.993   285.569     0.150
    20.993   287.248     0.150
    21.014   282.680     0.150
    21.112   284.185     0.150
    21.120   287.928     0.150
    21.125   283.378     0.150
    21.185   285.062     0.150
    21.198   287.022     0.150
    21.198   287.357     0.150
    21.254   285.806     0.150
    21.256   288.916     0.150
    21.272   285.353     0.150
    21.272   289.285     0.150
    21.202   285.487     0.150
    21.333   289.810     0.150
    21.359   286.741     0.150
    21.447   289.055     0.150
    21.447   290.588     0.150
    21.449   287.223     0.150
    21.470   288.258     0.150
    21.472   287.802     0.150
    21.491   290.072     0.150
    21.491   291.038     0.150
    21.508   288.963     0.150
    21.575   288.971     0.150
    21.573   292.175     0.150
    21.614   288.898     0.150
    21.614   289.918     0.150
    21.614   293.113     0.150
    21.722   290.723     0.150
    21.726   291.370     0.150
    21.726   291.697     0.150
    21.728   290.752     0.150
    21.767   294.669     0.150
    21.780   291.585     0.150
    21.787   291.933     0.150
    21.793   290.793     0.150
    21.820   295.907     0.150
    21.941   296.062     0.150
    21.939   292.208     0.150
    22.005   294.517     0.150
    22.032   294.604     0.150
    22.036   296.418     0.150
    22.048   293.445     0.150
    22.056   294.710     0.150
    22.102   294.598     0.150
    22.132   298.688     0.150
    22.132   297.834     0.150
    22.132   298.487     0.150
    22.136   298.555     0.150
    22.159   299.288     0.150
    22.154   295.777     0.150
    22.243   296.442     0.150
    22.287   296.348     0.150
    22.306   298.012     0.150
    22.323   299.548     0.150
    22.339   297.414     0.150
    22.430   300.447     0.150
    22.438   303.078     0.150
    22.516   302.247     0.150
    22.546   299.128     0.150
    22.569   303.010     0.150
    22.592   301.011     0.150
    22.636   300.237     0.150
    22.709   300.056     0.150
    22.709   300.234     0.150
    22.717   300.883     0.150
    22.820   301.741     0.150
    22.860   305.513     0.150
    22.883   306.768     0.150
    22.889   304.947     0.150
    22.928   303.524     0.150
    22.926   306.366     0.150
    22.951   302.851     0.150
    22.988   303.915     0.150
    22.999   304.036     0.150
    23.017   307.241     0.150
    23.019   304.328     0.150
    23.047   304.936     0.150
    23.064   308.258     0.150
    23.087   305.471     0.150
    23.144   309.333     0.150
    23.196   305.779     0.150
    23.210   307.996     0.150
    23.247   306.212     0.150
    23.263   306.348     0.150
    23.280   307.896     0.150
    23.293   306.851     0.150
    23.285   310.614     0.150
    23.337   311.754     0.150
    23.369   308.269     0.150
    23.458   310.104     0.150
    23.484   313.828     0.150
    23.491   313.938     0.150
    23.509   309.331     0.150
    23.518   314.458     0.150
    23.534   311.897     0.150
    23.565   313.368     0.150
    23.563   313.768     0.150
    23.563   311.478     0.150
    23.579   309.838     0.150
    23.579   310.388     0.150
    23.646   310.295     0.150
    23.666   310.662     0.150
    23.680   313.418     0.150
    23.737   311.191     0.150
    23.829   315.168     0.150
    23.867   312.322     0.150
    23.895   316.638     0.150
    23.914   312.459     0.150
    23.870   315.987     0.150
    23.926   315.699     0.150
    23.948   313.414     0.150
    24.044   313.585     0.150
    24.056   316.857     0.150
    24.071   314.297     0.150
    24.066   316.188     0.150
    24.103   316.248     0.150
    24.103   317.728     0.150
    24.110   314.840     0.150
    24.099   316.958     0.150
    24.135   314.737     0.150
    24.188   318.267     0.150
    24.207   315.328     0.150
    24.229   320.118     0.150
    24.333   318.256     0.150
    24.333   319.538     0.150
    24.373   318.072     0.150
    24.373   319.737     0.150
    24.360   317.788     0.150
    24.364   317.308     0.150
    24.374   317.410     0.150
    24.432   318.164     0.150
    24.460   322.657     0.150
    24.509   318.557     0.150
    24.596   320.219     0.150
    24.595   322.322     0.150
    24.607   320.119     0.150
    24.624   320.978     0.150
    24.646   321.628     0.150
    24.674   320.186     0.150
    24.680   323.708     0.150
    24.684   320.424     0.150
    24.749   324.536     0.150
    24.784   321.771     0.150
    24.860   322.527     0.150
    24.903   323.436     0.150
    24.976   324.797     0.150
    25.008   324.680     0.150
    25.044   327.583     0.150
    25.077   325.087     0.150
    25.070   327.504     0.150
    25.082   327.673     0.150
    25.120   327.728     0.150
    25.189   326.429     0.150
    25.227   328.312     0.150
    25.227   329.107     0.150
    25.232   328.938     0.150
    25.158   327.768     0.150
    25.258   326.352     0.150
    25.258   326.018     0.150
    25.279   326.610     0.150
    25.225   324.938     0.150
    25.321   327.361     0.150
    25.321   326.569     0.150
    25.344   328.538     0.150
    25.412   327.585     0.150
    25.437   328.463     0.150
    25.434   330.971     0.150
    25.555   330.252     0.150
    25.602   331.316     0.150
    25.602   331.518     0.150
    25.595   331.864     0.150
    25.615   329.629     0.150
    25.630   330.871     0.150
    25.638   329.811     0.150
    25.648   330.581     0.150
    25.643   332.024     0.150
    25.820   331.815     0.150
    25.868   331.960     0.150
    25.868   332.317     0.150
    25.936   332.327     0.150
    25.962   332.292     0.150
    26.103   333.230     0.150
    26.140   334.423     0.150
    26.140   335.868     0.150
    26.223   334.688     0.150
    26.258   334.718     0.150
    26.302   334.976     0.150
    26.308   334.854     0.150
    26.320   338.428     0.150
    26.347   335.743     0.150
    26.344   338.135     0.150
    26.359   336.773     0.150
    26.423   338.638     0.150
    26.426   337.048     0.150
    26.517   338.647     0.150
    26.553   337.864     0.150
    26.575   338.438     0.150
    26.598   338.421     0.150
    26.688   338.915     0.150
    26.724   339.103     0.150
    26.800   339.494     0.150
    26.803   339.758     0.150
    26.803   340.357     0.150
    26.862   344.798     0.150
    26.913   343.212     0.150
    26.913   342.638     0.150
    26.913   342.657     0.150
    26.913   342.487     0.150
    26.913   544.713     0.150
    26.909   342.188     0.150
    26.968   342.760     0.150
    26.981   344.657     0.150
    27.014   343.320     0.150
    27.025   343.439     0.150
    27.097   343.296     0.150
    27.111   343.275     0.150
    27.061   346.458     0.150
    27.182   344.361     0.150
    27.194   343.887     0.150
    27.231   345.287     0.150
    27.303   348.838     0.150
    27.365   346.487     0.150
    27.412   346.660     0.150
    27.419   347.555     0.150
    27.488   346.888     0.150
    27.501   347.594     0.150
    27.497   349.248     0.150
    27.510   347.493     0.150
    27.547   350.598     0.150
    27.634   347.836     0.150
    27.731   349.599     0.150
    27.728   349.176     0.150
    27.736   349.556     0.150
    27.812   350.128     0.150
    27.813   350.027     0.150
    27.814   353.298     0.150
    27.958   351.239     0.150
    27.959   352.718     0.150
    27.971   351.534     0.150
    27.977   352.487     0.150
    28.155   355.878     0.150
    28.176   353.428     0.150
    28.245   354.248     0.150
    28.267   353.873     0.150
    28.331   355.678     0.150
    28.355   355.347     0.150
    28.266   358.357     0.150
    28.462   358.248     0.150
    28.618   361.118     0.150
    28.643   360.058     0.150
    28.643   360.348     0.150
    28.782   361.638     0.150
    28.807   359.423     0.150
    28.920   360.797     0.150
    29.066   362.329     0.150
    29.066   361.987     0.150
    29.123   363.301     0.150
    29.123   363.438     0.150
    29.169   362.022     0.150
    29.179   365.078     0.150
    29.286   363.731     0.150
    29.371   364.740     0.150
    29.506   364.759     0.150
    29.517   367.027     0.150
    29.521   365.119     0.150
    29.571   365.449     0.150
    29.605   365.862     0.150
    29.668   366.881     0.150
    29.703   367.667     0.150
    29.749   366.801     0.150
    29.862   369.711     0.150
    30.076   369.192     0.150
    30.146   372.527     0.150
    30.251   371.323     0.150
    30.260   374.008     0.150
    30.401   372.653     0.150
    30.726   374.422     0.150
    30.757   376.520     0.150
    30.757   376.348     0.150
    30.761   375.067     0.150
    30.943   379.166     0.150
    31.019   378.228     0.150
    31.049   378.732     0.150
    31.242   379.980     0.150
    31.301   381.737     0.150
    31.326   383.878     0.150
    31.394   381.635     0.150
    31.397   381.672     0.150
    31.397   381.058     0.150
    31.437   382.317     0.150
    31.699   384.201     0.150
    31.708   384.453     0.150
    31.871   386.495     0.150
    31.931   386.904     0.150
    31.960   386.527     0.150
    32.075   387.718     0.150
    32.146   390.016     0.150
    32.217   389.808     0.150
    32.358   390.781     0.150
    32.488   390.868     0.150
    32.604   393.442     0.150
    32.805   393.070     0.150
    33.015   396.088     0.150
    33.020   399.527     0.150
    33.095   398.438     0.150
    33.333   397.463     0.150
    34.146   406.997     0.150
    34.163   407.611     0.150
    34.611   411.487     0.150
    35.001   414.338     0.150
    35.299   418.958     0.150
    36.604   428.594     0.150
    37.598   435.178     0.150
    39.060   449.708     0.150
    43.296   482.714     0.150
    44.692   492.938     0.150
    45.572   499.664     0.150
    45.692   503.829     0.150
    45.692   504.188     0.150
    46.562   508.032     0.150
    46.889   513.678     0.150
    50.205   538.607     0.150
    54.076   566.657     0.150
    54.903   574.107     0.150
    55.123   573.788     0.150
    55.423   577.027     0.150
    55.474   575.947     0.150
    56.268   582.288     0.150
    56.883   587.428     0.150
    56.902   586.768     0.150
    57.077   588.428     0.150
    57.082   587.328     0.150
    57.082   587.987     0.150
    57.082   642.098     0.150
    57.082   587.888     0.150
    57.277   589.768     0.150
    57.309   590.048     0.150
    57.316   590.048     0.150
    57.343   589.308     0.150
    57.352   589.647     0.150
    57.656   592.538     0.150
    57.665   591.848     0.150
    58.150   596.397     0.150
    58.350   596.188     0.150
    58.835   599.527     0.150
    59.556   605.098     0.150
    59.740   605.578     0.150
    59.746   605.527     0.150
    59.860   605.822     0.150
    60.114   608.928     0.150
    63.667   632.887     0.150
    65.535   643.888     0.150
    71.597   680.987     0.150
    83.917   751.214     0.150
    85.421   759.818     0.150
    85.627   759.895     0.150
    93.053   794.554     0.150
   106.105  1100.519     0.150
   106.822  1104.407     0.150
   108.303  1107.921     0.150
   123.652  1141.888     0.150
   123.652  1247.888     0.150
   123.652  1356.688     0.150
   123.652  1569.188     0.150
   123.652  2248.888     0.150
   128.251  1148.001     0.150
   128.459  1148.527     0.150
   128.470  1149.438     0.150
   129.175  1150.538     0.150
   142.203  1176.777     0.150
   145.766  1180.888     0.150
     0.594    12.398     0.150
     0.594    19.859     0.150
     0.997    18.469     0.150
     0.997    30.891     0.150
     1.181    21.379     0.150
     1.181    35.500     0.150
     1.217    22.559     0.150
     1.217    38.059     0.150
     1.217    37.820     0.150
     1.353    24.238     0.150
     1.353    41.309     0.150
     1.797    31.039     0.150
     1.797    53.250     0.150
     1.935    32.969     0.150
     1.935    54.930     0.150
     2.269    37.789     0.150
     2.269    63.660     0.150
     2.273    37.699     0.150
     2.273    65.430     0.150
     2.542    42.031     0.150
     2.542    72.102     0.150
     2.554    45.301     0.150
     2.554    77.719     0.150
     2.621    42.762     0.150
     2.621    80.910     0.150
     2.727    45.391     0.150
     2.727    84.770     0.150
     2.727    77.668     0.150
     3.212    50.539     0.150
     3.212    84.270     0.150
     3.537    58.828     0.150
     3.537    96.789     0.150
     4.174    61.078     0.150
     4.174    61.762     0.150
     4.174   113.410     0.150
     4.174   133.281     0.150
     4.179    64.352     0.150
     4.179   111.418     0.150
     4.222    67.012     0.150
     4.222   134.262     0.150
     4.296    65.434     0.150
     4.296    73.309     0.150
     4.296   135.883     0.150
     4.969    78.191     0.150
     4.969   131.961     0.150
     6.919   104.121     0.150
    11.676   170.668     0.150
    13.291   188.801     0.150
    13.291   421.422     0.150
    13.292   189.609     0.150
    13.831   196.309     0.150
    15.172   215.020     0.150
    15.327   221.484     0.150
    15.427   216.871     0.150
    15.965   227.000     0.150
    15.965   228.520     0.150
    16.195   232.148     0.150
    16.341   234.078     0.150
    16.457   232.570     0.150
    16.810   236.645     0.150
    17.291   242.211     0.150
    17.272   241.848     0.150
    17.278   247.211     0.150
    17.440   244.152     0.150
    17.576   245.188     0.150
    17.578   247.004     0.150
    17.578   245.859     0.150
    17.612   246.043     0.150
    17.618   247.586     0.150
    17.924   248.660     0.150
    18.078   251.125     0.150
    18.078   251.602     0.150
    18.183   251.484     0.150
    18.273   253.609     0.150
    18.273   253.941     0.150
    18.337   254.289     0.150
    18.450   255.523     0.150
    18.611   256.344     0.150
    18.611   256.000     0.150
    18.671   259.000     0.150
    18.752   257.719     0.150
    18.776   261.578     0.150
    18.776   260.918     0.150
    18.901   260.582     0.150
    18.996   268.000     0.150
    19.077   266.551     0.150
    19.162   263.480     0.150
    19.182   263.723     0.150
    19.209   263.168     0.150
    19.223   264.160     0.150
    19.223   264.398     0.150
    19.328   265.156     0.150
    19.354   266.254     0.150
    19.357   266.816     0.150
    19.357   267.059     0.150
    19.397   266.039     0.150
    19.415   265.895     0.150
    19.499   266.227     0.150
    19.499   266.648     0.150
    19.562   267.754     0.150
    19.571   267.574     0.150
    19.574   266.492     0.150
    19.579   267.328     0.150
    19.585   270.586     0.150
    19.632   267.699     0.150
    19.648   268.250     0.150
    19.659   269.070     0.150
    19.690   268.273     0.150
    19.711   269.660     0.150
    19.711   269.551     0.150
    19.806   269.312     0.150
    19.808   268.656     0.150
    19.830   270.090     0.150
    19.836   270.719     0.150
    19.873   270.328     0.150
    19.875   270.488     0.150
    19.948   270.715     0.150
    19.945   270.738     0.150
    19.945   271.918     0.150
    19.981   271.941     0.150
    19.989   271.105     0.150
    19.997   271.453     0.150
    20.089   272.520     0.150
    20.160   273.613     0.150
    20.173   273.355     0.150
    20.190   275.000     0.150
    20.239   278.102     0.150
    20.253   273.754     0.150
    20.315   275.562     0.150
    20.324   275.379     0.150
    20.388   275.633     0.150
    20.399   276.160     0.150
    20.406   275.613     0.150
    20.429   275.508     0.150
    20.439   276.391     0.150
    20.512   277.328     0.150
    20.539   277.352     0.150
    20.609   277.637     0.150
    20.618   277.812     0.150
    20.659   281.035     0.150
    20.659   282.199     0.150
    20.728   283.059     0.150
    20.749   279.426     0.150
    20.758   279.301     0.150
    20.809   284.000     0.150
    20.822   280.086     0.150
    20.848   280.977     0.150
    20.905   281.180     0.150
    20.928   281.098     0.150
    20.956   281.590     0.150
    20.953   284.566     0.150
    20.997   289.180     0.150
    21.026   282.043     0.150
    21.131   283.203     0.150
    21.178   284.055     0.150
    21.198   287.930     0.150
    21.309   285.441     0.150
    21.323   285.395     0.150
    21.341   285.672     0.150
    21.349   286.137     0.150
    21.447   287.102     0.150
    21.459   287.281     0.150
    21.499   287.672     0.150
    21.545   287.418     0.150
    21.545   292.602     0.150
    21.586   287.723     0.150
    21.603   289.211     0.150
    21.620   288.059     0.150
    21.628   288.859     0.150
    21.678   289.156     0.150
    21.691   292.902     0.150
    21.705   289.926     0.150
    21.761   292.238     0.150
    21.761   292.648     0.150
    21.779   291.008     0.150
    21.806   291.078     0.150
    21.824   291.949     0.150
    21.861   290.668     0.150
    21.879   295.352     0.150
    21.911   292.672     0.150
    21.927   292.059     0.150
    21.962   292.992     0.150
    21.988   292.250     0.150
    21.988   292.410     0.150
    22.038   293.617     0.150
    22.051   297.328     0.150
    22.077   296.414     0.150
    22.081   297.266     0.150
    22.083   296.109     0.150
    22.083   297.012     0.150
    22.094   293.707     0.150
    22.142   295.066     0.150
    22.162   294.426     0.150
    22.337   296.496     0.150
    22.342   299.441     0.150
    22.372   296.770     0.150
    22.402   297.738     0.150
    22.398   300.160     0.150
    22.441   297.477     0.150
    22.480   297.172     0.150
    22.493   298.219     0.150
    22.521   300.059     0.150
    22.527   302.020     0.150
    22.538   298.727     0.150
    22.553   299.578     0.150
    22.556   301.988     0.150
    22.727   300.762     0.150
    22.749   300.574     0.150
    22.824   302.344     0.150
    22.842   302.988     0.150
    22.856   303.570     0.150
    22.862   301.680     0.150
    22.860   305.379     0.150
    22.875   302.531     0.150
    22.906   306.445     0.150
    22.907   305.238     0.150
    22.910   305.199     0.150
    22.945   304.980     0.150
    23.023   303.953     0.150
    23.048   304.465     0.150
    23.063   306.371     0.150
    23.131   305.031     0.150
    23.188   310.539     0.150
    23.208   306.539     0.150
    23.226   307.004     0.150
    23.275   309.129     0.150
    23.318   308.180     0.150
    23.315   308.660     0.150
    23.322   305.949     0.150
    23.353   310.527     0.150
    23.383   308.719     0.150
    23.427   307.891     0.150
    23.449   309.180     0.150
    23.456   311.191     0.150
    23.477   310.398     0.150
    23.471   311.809     0.150
    23.501   308.535     0.150
    23.517   309.965     0.150
    23.517   310.352     0.150
    23.525   308.531     0.150
    23.537   308.418     0.150
    23.619   310.434     0.150
    23.635   313.352     0.150
    23.690   313.562     0.150
    23.703   310.543     0.150
    23.723   311.254     0.150
    23.762   311.238     0.150
    23.761   313.516     0.150
    23.772   314.738     0.150
    23.812   311.621     0.150
    23.865   311.254     0.150
    23.899   316.199     0.150
    23.918   312.742     0.150
    23.996   313.766     0.150
    24.032   313.727     0.150
    24.066   317.250     0.150
    24.173   318.801     0.150
    24.216   315.316     0.150
    24.268   319.859     0.150
    24.282   315.641     0.150
    24.297   318.871     0.150
    24.299   319.852     0.150
    24.306   316.793     0.150
    24.327   317.297     0.150
    24.377   317.535     0.150
    24.379   318.746     0.150
    24.395   317.891     0.150
    24.416   317.648     0.150
    24.416   318.430     0.150
    24.433   320.418     0.150
    24.475   320.109     0.150
    24.566   319.098     0.150
    24.572   321.051     0.150
    24.637   319.539     0.150
    24.689   320.883     0.150
    24.703   323.477     0.150
    24.702   321.977     0.150
    24.702   321.379     0.150
    24.736   320.555     0.150
    24.844   323.988     0.150
    24.873   324.578     0.150
    24.883   323.871     0.150
    24.883   324.418     0.150
    24.884   324.762     0.150
    24.913   322.723     0.150
    24.929   325.625     0.150
    24.967   322.277     0.150
    25.120   324.754     0.150
    25.141   325.535     0.150
    25.172   327.691     0.150
    25.202   328.223     0.150
    25.226   327.898     0.150
    25.264   325.961     0.150
    25.301   325.871     0.150
    25.298   328.602     0.150
    25.376   329.535     0.150
    25.418   326.969     0.150
    25.418   327.230     0.150
    25.441   330.570     0.150
    25.460   327.785     0.150
    25.503   327.766     0.150
    25.522   331.969     0.150
    25.522   332.840     0.150
    25.559   327.762     0.150
    25.633   329.578     0.150
    25.641   329.578     0.150
    25.672   331.988     0.150
    25.781   333.090     0.150
    25.833   333.629     0.150
    25.837   331.273     0.150
    25.949   333.340     0.150
    25.948   334.633     0.150
    25.948   335.270     0.150
    25.996   332.730     0.150
    26.008   335.520     0.150
    26.188   334.004     0.150
    26.270   337.770     0.150
    26.270   337.660     0.150
    26.311   337.859     0.150
    26.327   335.965     0.150
    26.416   338.809     0.150
    26.482   336.883     0.150
    26.482   337.430     0.150
    26.540   336.789     0.150
    26.571   339.941     0.150
    26.689   340.012     0.150
    26.689   340.980     0.150
    26.806   340.871     0.150
    26.984   342.461     0.150
    27.061   344.020     0.150
    27.103   345.059     0.150
    27.147   342.500     0.150
    27.153   342.480     0.150
    27.153   343.840     0.150
    27.313   347.898     0.150
    27.389   347.969     0.150
    27.389   348.715     0.150
    27.507   345.375     0.150
    27.511   347.387     0.150
    27.511   347.852     0.150
    27.511   347.539     0.150
    27.511   347.648     0.150
    27.625   349.621     0.150
    27.634   349.590     0.150
    27.729   349.137     0.150
    27.729   349.930     0.150
    27.744   351.238     0.150
    27.843   349.062     0.150
    27.999   350.043     0.150
    28.272   353.980     0.150
    28.426   356.391     0.150
    28.489   357.039     0.150
    28.575   355.160     0.150
    28.572   357.461     0.150
    28.619   355.805     0.150
    28.729   358.930     0.150
    28.749   358.789     0.150
    28.844   360.641     0.150
    28.941   360.770     0.150
    29.000   362.336     0.150
    29.505   366.371     0.150
    29.510   364.551     0.150
    29.531   367.590     0.150
    29.642   366.543     0.150
    29.642   366.711     0.150
    29.657   367.012     0.150
    29.690   366.199     0.150
    29.779   367.758     0.150
    29.779   368.711     0.150
    29.798   366.691     0.150
    29.937   367.191     0.150
    30.059   367.594     0.150
    30.159   369.109     0.150
    30.313   371.891     0.150
    30.362   374.270     0.150
    30.587   373.980     0.150
    30.696   376.414     0.150
    30.765   377.691     0.150
    31.138   380.270     0.150
    31.142   378.137     0.150
    31.685   384.918     0.150
    31.748   383.574     0.150
    31.748   383.809     0.150
    31.800   384.371     0.150
    32.040   386.457     0.150
    32.097   388.199     0.150
    32.110   387.887     0.150
    32.179   389.441     0.150
    32.323   388.652     0.150
    32.494   391.391     0.150
    32.494   392.289     0.150
    32.882   394.969     0.150
    33.008   396.730     0.150
    33.418   399.898     0.150
    33.690   400.000     0.150
    34.023   403.941     0.150
    34.865   409.668     0.150
    35.236   418.949     0.150
    35.272   419.129     0.150
    38.111   438.930     0.150
    45.627   499.891     0.150
    47.090   511.234     0.150
    56.057   579.641     0.150
    57.738   591.840     0.150
    57.738   643.891     0.150
    57.738   591.801     0.150
    60.741   611.879     0.150
   127.809  1145.641     0.150
   129.089  1149.930     0.150
   129.089  1149.926     0.150
     0.358     8.176     0.150
     0.358    13.254     0.150
     0.754    14.773     0.150
     1.105    21.445     0.150
     1.171    23.156     0.150
     1.171    22.535     0.150
     1.335    25.613     0.150
     1.564    29.066     0.150
     1.564    48.934     0.150
     1.655    29.734     0.150
     1.655    50.504     0.150
     2.020    33.535     0.150
     2.020    58.484     0.150
     2.020    56.977     0.150
     2.076    35.383     0.150
     2.076    62.645     0.150
     2.390    74.785     0.150
     2.403    41.324     0.150
     2.558    42.633     0.150
     2.676    44.574     0.150
     2.676    82.273     0.150
     2.684    44.836     0.150
     2.943    49.766     0.150
     3.018    50.633     0.150
     3.020    50.406     0.150
     3.140    57.434     0.150
     3.257    53.605     0.150
     3.257   100.383     0.150
     3.257    55.305     0.150
     3.436    54.215     0.150
     3.493    54.633     0.150
     3.493   113.105     0.150
     4.124    61.465     0.150
     4.124   114.426     0.150
     4.442    68.176     0.150
     4.442   120.352     0.150
     4.442   143.199     0.150
     4.442    67.863     0.150
     4.699    75.594     0.150
     4.851    76.273     0.150
     5.891    89.953     0.150
     5.891   172.156     0.150
     6.125    92.684     0.150
     6.149    92.375     0.150
     6.337    96.484     0.150
     6.578    99.727     0.150
     6.578   100.816     0.150
     7.098   106.523     0.150
     7.098   106.324     0.150
     7.232   110.203     0.150
     8.038   117.285     0.150
     8.038   117.555     0.150
     8.038   118.086     0.150
     8.894   283.262     0.150
     9.071   134.406     0.150
     9.123   139.852     0.150
     9.611   145.652     0.150
    10.128   144.324     0.150
    10.402   152.895     0.150
    11.187   160.156     0.150
    11.187   283.324     0.150
    11.187   158.086     0.150
    11.450   165.434     0.150
    11.568   169.484     0.150
    11.568   169.633     0.150
    12.120   176.004     0.150
    12.120   174.977     0.150
    12.436   181.035     0.150
    12.436   178.445     0.150
    13.027   188.184     0.150
    13.026   188.305     0.150
    13.026   186.176     0.150
    13.026   416.590     0.150
    13.026   187.355     0.150
    13.124   190.246     0.150
    13.230   188.773     0.150
    13.317   191.453     0.150
    13.499   191.254     0.150
    13.601   194.254     0.150
    13.601   193.898     0.150
    13.661   196.996     0.150
    13.694   197.105     0.150
    13.807   197.586     0.150
    14.012   199.059     0.150
    14.704   209.953     0.150
    15.220   215.379     0.150
    15.220   215.145     0.150
    15.216   216.484     0.150
    15.431   220.336     0.150
    15.431   218.703     0.150
    15.514   217.582     0.150
    15.514   217.406     0.150
    15.544   221.574     0.150
    15.570   223.188     0.150
    15.570   223.453     0.150
    15.570   221.066     0.150
    15.570   220.863     0.150
    15.736   221.289     0.150
    15.743   223.094     0.150
    15.743   223.543     0.150
    15.743   224.664     0.150
    15.743   224.426     0.150
    15.877   225.586     0.150
    15.931   226.484     0.150
    16.058   228.543     0.150
    16.058   229.086     0.150
    16.438   233.934     0.150
    16.997   240.395     0.150
    17.327   241.531     0.150
    17.342   244.098     0.150
    17.342   244.734     0.150
    17.366   240.332     0.150
    17.452   241.621     0.150
    17.607   245.684     0.150
    17.758   246.965     0.150
    17.857   248.055     0.150
    17.857   248.539     0.150
    17.858   250.766     0.150
    18.082   251.395     0.150
    18.094   251.035     0.150
    18.094   251.426     0.150
    18.245   251.402     0.150
    18.245   252.746     0.150
    18.394   254.625     0.150
    18.402   256.855     0.150
    18.424   257.309     0.150
    18.424   256.375     0.150
    18.438   254.453     0.150
    18.438   254.586     0.150
    18.438   464.484     0.150
    18.494   258.656     0.150
    18.494   258.406     0.150
    18.526   258.035     0.150
    18.552   258.703     0.150
    18.570   256.160     0.150
    18.586   256.172     0.150
    18.616   256.484     0.150
    18.616   257.043     0.150
    18.959   259.875     0.150
    18.999   261.066     0.150
    19.004   261.395     0.150
    19.004   261.855     0.150
    19.089   264.477     0.150
    19.089   264.156     0.150
    19.127   262.742     0.150
    19.166   262.695     0.150
    19.249   264.684     0.150
    19.272   263.953     0.150
    19.275   263.781     0.150
    19.275   263.145     0.150
    19.292   263.469     0.150
    19.292   265.855     0.150
    19.301   264.273     0.150
    19.301   264.793     0.150
    19.302   266.930     0.150
    19.302   267.543     0.150
    19.309   263.930     0.150
    19.398   265.613     0.150
    19.488   267.406     0.150
    19.494   267.035     0.150
    19.513   266.809     0.150
    19.513   267.273     0.150
    19.543   266.984     0.150
    19.598   267.746     0.150
    19.603   267.145     0.150
    19.676   269.445     0.150
    19.676   269.195     0.150
    19.707   269.430     0.150
    19.707   269.324     0.150
    19.721   268.902     0.150
    19.721   269.426     0.150
    19.791   268.945     0.150
    19.791   269.754     0.150
    19.811   269.555     0.150
    19.811   269.129     0.150
    19.961   275.145     0.150
    19.969   271.848     0.150
    19.969   272.105     0.150
    20.008   273.406     0.150
    20.021   272.578     0.150
    20.033   271.438     0.150
    20.071   273.234     0.150
    20.068   272.008     0.150
    20.101   273.254     0.150
    20.110   273.312     0.150
    20.110   273.785     0.150
    20.110   273.336     0.150
    20.110   273.094     0.150
    20.199   273.594     0.150
    20.215   274.922     0.150
    20.262   275.504     0.150
    20.255   274.910     0.150
    20.253   277.727     0.150
    20.288   278.656     0.150
    20.338   275.957     0.150
    20.338   276.273     0.150
    20.383   279.746     0.150
    20.383   279.426     0.150
    20.430   277.324     0.150
    20.427   276.754     0.150
    20.445   280.145     0.150
    20.445   276.902     0.150
    20.445   277.215     0.150
    20.452   277.059     0.150
    20.446   277.855     0.150
    20.446   277.305     0.150
    20.458   277.523     0.150
    20.528   281.125     0.150
    20.531   278.219     0.150
    20.564   278.535     0.150
    20.571   276.953     0.150
    20.613   278.340     0.150
    20.613   278.996     0.150
    20.655   278.957     0.150
    20.655   279.645     0.150
    20.616   280.453     0.150
    20.688   279.199     0.150
    20.688   279.816     0.150
    20.697   281.176     0.150
    20.722   280.000     0.150
    20.780   280.055     0.150
    20.815   280.473     0.150
    20.857   283.023     0.150
    20.814   286.355     0.150
    20.864   283.984     0.150
    20.903   282.105     0.150
    20.913   281.227     0.150
    20.924   281.754     0.150
    20.924   282.535     0.150
    20.948   282.719     0.150
    20.964   285.773     0.150
    21.009   287.383     0.150
    21.009   284.805     0.150
    21.045   285.105     0.150
    21.060   284.566     0.150
    21.057   282.855     0.150
    21.123   284.176     0.150
    21.171   285.766     0.150
    21.209   284.703     0.150
    21.244   285.844     0.150
    21.239   286.238     0.150
    21.262   288.953     0.150
    21.262   288.531     0.150
    21.265   289.895     0.150
    21.384   287.105     0.150
    21.396   288.875     0.150
    21.400   286.953     0.150
    21.413   290.410     0.150
    21.413   290.953     0.150
    21.417   286.492     0.150
    21.448   287.555     0.150
    21.502   289.648     0.150
    21.502   290.254     0.150
    21.567   288.594     0.150
    21.567   289.066     0.150
    21.564   292.793     0.150
    21.601   288.523     0.150
    21.620   289.184     0.150
    21.658   289.234     0.150
    21.724   292.145     0.150
    21.698   291.793     0.150
    21.732   290.078     0.150
    21.759   293.930     0.150
    21.769   294.012     0.150
    21.799   293.656     0.150
    21.807   293.363     0.150
    21.807   293.855     0.150
    21.799   290.625     0.150
    21.819   293.391     0.150
    21.858   291.656     0.150
    21.858   290.738     0.150
    21.886   296.074     0.150
    21.914   292.629     0.150
    21.914   293.105     0.150
    21.911   292.520     0.150
    21.932   291.816     0.150
    21.932   292.594     0.150
    21.953   293.055     0.150
    21.953   292.012     0.150
    21.972   292.785     0.150
    21.972   294.695     0.150
    21.972   295.074     0.150
    21.974   292.188     0.150
    21.974   292.695     0.150
    21.986   293.047     0.150
    22.016   292.777     0.150
    22.016   293.516     0.150
    22.027   293.012     0.150
    22.060   297.066     0.150
    22.116   297.477     0.150
    22.132   298.164     0.150
    22.113   298.445     0.150
    22.200   294.672     0.150
    22.207   295.508     0.150
    22.244   298.730     0.150
    22.276   296.945     0.150
    22.276   297.816     0.150
    22.269   295.523     0.150
    22.344   296.773     0.150
    22.371   296.465     0.150
    22.407   300.012     0.150
    22.427   296.707     0.150
    22.489   298.734     0.150
    22.523   299.008     0.150
    22.544   301.508     0.150
    22.512   302.555     0.150
    22.556   299.766     0.150
    22.569   299.441     0.150
    22.606   301.133     0.150
    22.623   302.527     0.150
    22.628   303.402     0.150
    22.628   303.254     0.150
    22.632   299.473     0.150
    22.675   300.109     0.150
    22.670   300.105     0.150
    22.732   301.105     0.150
    22.746   300.871     0.150
    22.792   303.754     0.150
    22.829   301.098     0.150
    22.873   304.504     0.150
    22.915   303.133     0.150
    22.992   306.109     0.150
    23.010   304.234     0.150
    23.070   307.043     0.150
    23.089   303.219     0.150
    23.186   308.105     0.150
    23.183   305.363     0.150
    23.209   308.344     0.150
    23.230   304.891     0.150
    23.230   307.246     0.150
    23.244   307.496     0.150
    23.285   306.395     0.150
    23.306   310.855     0.150
    23.285   309.496     0.150
    23.353   310.777     0.150
    23.361   309.156     0.150
    23.391   308.941     0.150
    23.392   309.883     0.150
    23.396   308.406     0.150
    23.408   310.766     0.150
    23.422   307.996     0.150
    23.441   312.766     0.150
    23.460   307.891     0.150
    23.504   310.832     0.150
    23.503   310.066     0.150
    23.530   309.020     0.150
    23.534   311.254     0.150
    23.578   310.199     0.150
    23.591   310.098     0.150
    23.616   312.641     0.150
    23.655   310.852     0.150
    23.655   311.703     0.150
    23.686   310.699     0.150
    23.682   312.336     0.150
    23.713   313.676     0.150
    23.784   314.535     0.150
    23.783   311.652     0.150
    23.812   313.645     0.150
    23.815   312.684     0.150
    23.815   314.086     0.150
    23.824   314.859     0.150
    23.834   315.078     0.150
    23.846   312.086     0.150
    23.885   313.426     0.150
    23.944   312.492     0.150
    23.952   314.695     0.150
    24.015   316.582     0.150
    24.064   317.977     0.150
    24.055   316.016     0.150
    24.139   316.207     0.150
    24.151   317.520     0.150
    24.164   315.656     0.150
    24.193   316.316     0.150
    24.202   318.074     0.150
    24.197   315.898     0.150
    24.211   319.266     0.150
    24.213   315.973     0.150
    24.251   316.352     0.150
    24.251   316.844     0.150
    24.285   316.156     0.150
    24.285   316.750     0.150
    24.296   320.156     0.150
    24.337   317.133     0.150
    24.349   316.988     0.150
    24.354   316.012     0.150
    24.421   319.801     0.150
    24.423   318.324     0.150
    24.437   320.000     0.150
    24.488   321.195     0.150
    24.495   319.418     0.150
    24.514   318.914     0.150
    24.532   319.617     0.150
    24.580   322.379     0.150
    24.593   319.402     0.150
    24.601   321.434     0.150
    24.610   322.363     0.150
    24.626   321.086     0.150
    24.647   322.633     0.150
    24.646   320.277     0.150
    24.646   319.895     0.150
    24.679   320.023     0.150
    24.641   324.434     0.150
    24.690   322.645     0.150
    24.690   323.344     0.150
    24.728   321.359     0.150
    24.769   325.055     0.150
    24.822   321.102     0.150
    24.822   321.613     0.150
    24.868   322.090     0.150
    24.876   324.559     0.150
    24.890   325.055     0.150
    24.919   325.293     0.150
    24.930   324.426     0.150
    24.935   323.094     0.150
    24.935   323.684     0.150
    24.943   325.305     0.150
    24.957   322.074     0.150
    24.957   322.324     0.150
    24.986   323.469     0.150
    24.995   323.555     0.150
    25.038   323.801     0.150
    25.076   324.355     0.150
    25.094   326.746     0.150
    25.112   323.773     0.150
    25.119   323.918     0.150
    25.121   324.465     0.150
    25.082   327.023     0.150
    25.152   324.008     0.150
    25.198   324.758     0.150
    25.205   327.801     0.150
    25.216   325.324     0.150
    25.240   328.578     0.150
    25.240   325.461     0.150
    25.256   324.730     0.150
    25.264   326.457     0.150
    25.326   326.980     0.150
    25.378   327.008     0.150
    25.453   331.965     0.150
    25.541   328.793     0.150
    25.550   331.250     0.150
    25.552   331.066     0.150
    25.552   330.664     0.150
    25.563   328.324     0.150
    25.525   333.035     0.150
    25.581   328.414     0.150
    25.627   328.418     0.150
    25.653   330.785     0.150
    25.648   329.266     0.150
    25.664   328.504     0.150
    25.667   332.020     0.150
    25.667   332.195     0.150
    25.661   328.402     0.150
    25.661   330.484     0.150
    25.686   328.730     0.150
    25.686   330.453     0.150
    25.725   332.723     0.150
    25.750   329.770     0.150
    25.735   334.863     0.150
    25.812   330.070     0.150
    25.815   331.082     0.150
    25.814   330.711     0.150
    25.828   330.641     0.150
    25.828   331.504     0.150
    25.798   333.414     0.150
    25.853   333.086     0.150
    25.860   331.105     0.150
    25.938   335.230     0.150
    25.995   335.125     0.150
    26.049   332.797     0.150
    26.051   333.254     0.150
    26.071   335.785     0.150
    26.037   334.145     0.150
    26.037   336.176     0.150
    26.072   337.254     0.150
    26.126   334.113     0.150
    26.145   333.984     0.150
    26.162   334.566     0.150
    26.201   334.168     0.150
    26.221   334.906     0.150
    26.227   337.191     0.150
    26.253   334.586     0.150
    26.252   337.824     0.150
    26.334   335.754     0.150
    26.318   341.414     0.150
    26.396   336.355     0.150
    26.397   336.020     0.150
    26.405   335.648     0.150
    26.433   337.754     0.150
    26.382   339.215     0.150
    26.470   335.566     0.150
    26.485   335.375     0.150
    26.490   337.379     0.150
    26.489   337.332     0.150
    26.513   336.434     0.150
    26.561   340.664     0.150
    26.621   338.285     0.150
    26.622   336.848     0.150
    26.601   343.145     0.150
    26.722   339.055     0.150
    26.726   338.629     0.150
    26.750   338.539     0.150
    26.754   338.641     0.150
    26.754   339.426     0.150
    26.753   339.516     0.150
    26.788   339.008     0.150
    26.786   339.570     0.150
    26.819   343.074     0.150
    26.830   341.664     0.150
    26.842   344.406     0.150
    26.920   341.508     0.150
    26.941   341.137     0.150
    26.939   340.840     0.150
    26.937   342.805     0.150
    26.930   345.184     0.150
    27.014   341.926     0.150
    27.032   340.914     0.150
    27.031   341.383     0.150
    26.993   345.934     0.150
    26.999   346.855     0.150
    27.054   346.375     0.150
    27.107   345.805     0.150
    27.107   544.910     0.150
    27.107   762.758     0.150
    27.107  1003.676     0.150
    27.107   345.105     0.150
    27.161   343.211     0.150
    27.169   343.426     0.150
    27.142   343.566     0.150
    27.185   342.754     0.150
    27.185   342.258     0.150
    27.207   343.852     0.150
    27.194   342.844     0.150
    27.229   342.719     0.150
    27.246   344.906     0.150
    27.246   345.254     0.150
    27.246   345.125     0.150
    27.246   345.277     0.150
    27.246   544.680     0.150
    27.309   343.820     0.150
    27.311   343.930     0.150
    27.272   349.035     0.150
    27.329   344.168     0.150
    27.347   344.824     0.150
    27.379   345.355     0.150
    27.379   344.926     0.150
    27.386   344.016     0.150
    27.429   344.730     0.150
    27.446   348.105     0.150
    27.446   545.703     0.150
    27.446   766.012     0.150
    27.463   345.676     0.150
    27.400   349.488     0.150
    27.400   350.363     0.150
    27.483   346.453     0.150
    27.483   347.188     0.150
    27.491   345.207     0.150
    27.512   345.656     0.150
    27.462   350.094     0.150
    27.541   345.812     0.150
    27.541   347.344     0.150
    27.552   346.004     0.150
    27.552   346.523     0.150
    27.560   346.309     0.150
    27.560   346.754     0.150
    27.615   347.496     0.150
    27.687   349.543     0.150
    27.686   347.355     0.150
    27.686   347.684     0.150
    27.680   351.133     0.150
    27.748   348.086     0.150
    27.769   351.156     0.150
    27.806   349.367     0.150
    27.812   349.285     0.150
    27.828   348.203     0.150
    27.850   349.344     0.150
    27.866   349.539     0.150
    27.830   352.055     0.150
    27.919   348.633     0.150
    27.922   349.109     0.150
    27.977   349.367     0.150
    27.979   352.555     0.150
    27.940   353.906     0.150
    27.992   353.594     0.150
    28.042   350.746     0.150
    28.078   352.648     0.150
    28.078   353.074     0.150
    28.057   355.664     0.150
    28.188   351.281     0.150
    28.212   351.137     0.150
    28.222   354.094     0.150
    28.216   352.383     0.150
    28.216   352.535     0.150
    28.232   352.332     0.150
    28.230   352.457     0.150
    28.281   356.227     0.150
    28.304   353.934     0.150
    28.311   352.852     0.150
    28.311   353.215     0.150
    28.317   354.586     0.150
    28.325   352.293     0.150
    28.355   353.566     0.150
    28.355   353.676     0.150
    28.308   356.613     0.150
    28.376   354.094     0.150
    28.377   354.016     0.150
    28.377   353.855     0.150
    28.381   354.645     0.150
    28.442   354.281     0.150
    28.442   353.875     0.150
    28.445   353.996     0.150
    28.457   357.504     0.150
    28.476   354.727     0.150
    28.476   355.195     0.150
    28.483   356.324     0.150
    28.530   355.391     0.150
    28.534   355.234     0.150
    28.534   355.645     0.150
    28.557   358.977     0.150
    28.593   355.141     0.150
    28.594   354.938     0.150
    28.594   355.531     0.150
    28.465   356.379     0.150
    28.615   358.914     0.150
    28.631   355.137     0.150
    28.674   358.035     0.150
    28.777   359.496     0.150
    28.773   356.426     0.150
    28.781   356.348     0.150
    28.799   357.453     0.150
    28.799   356.973     0.150
    28.805   357.863     0.150
    28.835   358.617     0.150
    28.835   359.164     0.150
    28.844   357.246     0.150
    28.844   357.805     0.150
    28.874   357.438     0.150
    28.900   358.469     0.150
    28.881   356.613     0.150
    28.935   358.418     0.150
    28.940   360.324     0.150
    28.924   359.586     0.150
    28.954   358.293     0.150
    28.980   361.434     0.150
    28.984   359.672     0.150
    29.032   360.840     0.150
    29.032   362.016     0.150
    29.041   359.148     0.150
    29.009   364.504     0.150
    29.143   362.754     0.150
    29.151   359.895     0.150
    29.151   360.918     0.150
    29.162   360.555     0.150
    29.172   359.926     0.150
    29.152   365.453     0.150
    29.232   360.332     0.150
    29.213   363.867     0.150
    29.285   360.492     0.150
    29.292   361.613     0.150
    29.292   362.234     0.150
    29.338   362.871     0.150
    29.345   362.910     0.150
    29.357   364.895     0.150
    29.367   363.094     0.150
    29.381   363.887     0.150
    29.411   362.023     0.150
    29.420   363.066     0.150
    29.443   368.934     0.150
    29.531   365.402     0.150
    29.531   363.004     0.150
    29.545   363.324     0.150
    29.984   364.836     0.150
    29.594   364.902     0.150
    29.616   364.059     0.150
    29.694   365.574     0.150
    29.741   366.152     0.150
    29.747   366.020     0.150
    29.895   366.430     0.150
    29.902   369.215     0.150
    29.941   367.242     0.150
    29.941   367.094     0.150
    29.953   368.508     0.150
    29.950   367.309     0.150
    30.006   367.566     0.150
    30.047   366.965     0.150
    30.054   368.680     0.150
    30.106   370.383     0.150
    30.141   370.152     0.150
    30.155   369.387     0.150
    30.187   373.234     0.150
    30.205   370.320     0.150
    30.218   371.387     0.150
    30.218   370.695     0.150
    30.260   370.078     0.150
    30.260   370.375     0.150
    30.262   371.688     0.150
    30.262   371.824     0.150
    30.299   371.359     0.150
    30.317   370.961     0.150
    30.334   372.719     0.150
    30.368   370.438     0.150
    30.382   370.852     0.150
    30.382   372.453     0.150
    30.381   370.762     0.150
    30.387   371.332     0.150
    30.428   371.215     0.150
    30.428   371.586     0.150
    30.430   374.453     0.150
    30.430   373.621     0.150
    30.445   371.551     0.150
    30.451   372.133     0.150
    30.450   371.141     0.150
    30.450   373.273     0.150
    30.483   372.754     0.150
    30.495   373.941     0.150
    30.505   372.371     0.150
    30.505   373.703     0.150
    30.553   372.867     0.150
    30.570   373.875     0.150
    30.605   373.344     0.150
    30.671   373.957     0.150
    30.675   373.941     0.150
    30.804   376.883     0.150
    30.911   375.379     0.150
    30.911   377.145     0.150
    30.916   375.367     0.150
    30.937   378.895     0.150
    30.943   376.559     0.150
    30.943   377.176     0.150
    30.955   376.891     0.150
    30.960   376.648     0.150
    30.960   376.914     0.150
    30.921   378.977     0.150
    30.995   376.438     0.150
    30.995   377.086     0.150
    31.032   376.781     0.150
    31.062   377.109     0.150
    31.069   377.043     0.150
    31.074   376.473     0.150
    31.094   378.215     0.150
    31.129   377.004     0.150
    31.174   378.125     0.150
    31.258   378.641     0.150
    31.257   378.844     0.150
    31.300   380.145     0.150
    31.312   379.250     0.150
    31.318   380.770     0.150
    31.360   382.895     0.150
    31.377   380.836     0.150
    31.391   380.109     0.150
    31.403   382.086     0.150
    31.488   380.457     0.150
    31.486   381.348     0.150
    31.503   381.453     0.150
    31.536   381.387     0.150
    31.570   382.285     0.150
    31.570   382.695     0.150
    31.582   383.477     0.150
    31.649   382.273     0.150
    31.669   383.914     0.150
    31.630   382.594     0.150
    31.693   382.594     0.150
    31.700   384.434     0.150
    31.706   382.664     0.150
    31.719   382.531     0.150
    31.734   382.719     0.150
    31.734   384.215     0.150
    31.727   383.492     0.150
    31.732   383.754     0.150
    31.771   383.000     0.150
    31.787   384.039     0.150
    31.787   383.316     0.150
    31.784   382.684     0.150
    31.784   383.133     0.150
    31.790   383.531     0.150
    31.797   384.469     0.150
    31.797   385.656     0.150
    31.804   386.227     0.150
    31.828   385.133     0.150
    31.828   557.387     0.150
    31.831   384.355     0.150
    31.916   385.578     0.150
    31.956   386.938     0.150
    31.957   385.078     0.150
    31.967   387.008     0.150
    32.007   385.863     0.150
    32.064   386.438     0.150
    32.090   385.762     0.150
    32.099   388.133     0.150
    32.116   385.574     0.150
    32.102   387.215     0.150
    32.115   387.746     0.150
    32.161   387.996     0.150
    32.161   386.227     0.150
    32.173   387.148     0.150
    32.182   387.164     0.150
    32.180   387.648     0.150
    32.196   389.801     0.150
    32.201   387.426     0.150
    32.225   389.020     0.150
    32.236   388.730     0.150
    32.288   387.434     0.150
    32.299   388.438     0.150
    32.334   389.020     0.150
    32.338   391.953     0.150
    32.340   388.512     0.150
    32.338   389.684     0.150
    32.395   388.309     0.150
    32.437   389.746     0.150
    32.487   389.840     0.150
    32.521   390.875     0.150
    32.573   392.664     0.150
    32.595   392.219     0.150
    32.602   392.316     0.150
    32.607   392.844     0.150
    32.614   390.715     0.150
    32.689   392.754     0.150
    32.689   391.242     0.150
    32.714   391.523     0.150
    32.714   391.156     0.150
    32.726   391.289     0.150
    32.810   391.957     0.150
    32.903   393.715     0.150
    32.952   393.434     0.150
    32.966   394.473     0.150
    33.039   396.320     0.150
    33.068   394.652     0.150
    33.070   394.168     0.150
    33.070   395.055     0.150
    33.130   396.496     0.150
    33.136   395.113     0.150
    33.149   398.117     0.150
    33.210   395.414     0.150
    33.219   395.535     0.150
    33.312   396.133     0.150
    33.391   396.844     0.150
    33.439   397.398     0.150
    33.450   396.773     0.150
    33.451   396.992     0.150
    33.451   399.016     0.150
    33.472   401.234     0.150
    33.476   398.789     0.150
    33.476   562.336     0.150
    33.486   402.176     0.150
    33.548   400.531     0.150
    33.670   399.180     0.150
    33.717   402.461     0.150
    33.844   402.520     0.150
    33.857   404.086     0.150
    33.857   401.582     0.150
    33.869   401.031     0.150
    33.912   401.488     0.150
    33.951   403.805     0.150
    33.975   401.883     0.150
    34.092   405.777     0.150
    34.120   403.633     0.150
    34.121   403.395     0.150
    34.165   407.453     0.150
    34.184   403.871     0.150
    34.225   407.203     0.150
    34.263   404.844     0.150
    34.353   405.176     0.150
    34.475   406.215     0.150
    34.519   408.684     0.150
    34.519   565.562     0.150
    34.519   408.984     0.150
    34.516   408.781     0.150
    34.603   409.879     0.150
    34.619   407.410     0.150
    34.647   408.574     0.150
    34.625   409.035     0.150
    34.762   409.332     0.150
    34.773   409.035     0.150
    34.756   411.316     0.150
    34.791   409.113     0.150
    34.871   409.836     0.150
    34.894   410.316     0.150
    34.903   410.320     0.150
    34.903   410.996     0.150
    34.906   410.324     0.150
    34.883   413.285     0.150
    34.966   412.066     0.150
    34.999   412.453     0.150
    35.018   413.965     0.150
    35.057   413.164     0.150
    35.119   414.023     0.150
    35.130   414.926     0.150
    35.153   413.633     0.150
    35.127   413.754     0.150
    35.127   413.906     0.150
    35.285   415.707     0.150
    35.334   414.551     0.150
    35.392   414.828     0.150
    35.401   415.375     0.150
    35.517   418.465     0.150
    35.514   416.445     0.150
    35.552   417.625     0.150
    35.559   415.949     0.150
    35.641   418.969     0.150
    35.657   416.590     0.150
    35.704   419.395     0.150
    35.850   420.805     0.150
    35.899   420.109     0.150
    35.922   420.164     0.150
    35.931   419.426     0.150
    35.975   419.746     0.150
    36.027   420.668     0.150
    36.007   418.684     0.150
    36.082   420.469     0.150
    36.250   423.406     0.150
    36.255   422.168     0.150
    36.262   423.504     0.150
    36.354   424.914     0.150
    36.432   423.168     0.150
    36.501   427.066     0.150
    36.532   424.492     0.150
    36.649   426.051     0.150
    36.674   427.805     0.150
    36.943   427.586     0.150
    37.013   430.395     0.150
    37.012   429.414     0.150
    37.036   429.035     0.150
    37.104   430.699     0.150
    37.083   428.414     0.150
    37.083   571.906     0.150
    37.109   430.926     0.150
    37.189   432.266     0.150
    37.221   430.656     0.150
    37.316   431.879     0.150
    37.304   432.156     0.150
    37.359   433.195     0.150
    37.537   434.066     0.150
    37.565   433.781     0.150
    37.604   434.699     0.150
    37.803   436.086     0.150
    37.878   437.156     0.150
    37.878   436.875     0.150
    37.997   437.906     0.150
    38.101   439.363     0.150
    38.198   438.855     0.150
    38.702   444.395     0.150
    38.745   443.309     0.150
    38.766   444.152     0.150
    40.968   462.953     0.150
    41.000   463.004     0.150
    41.896   471.703     0.150
    42.630   476.184     0.150
    42.710   478.254     0.150
    42.710   479.484     0.150
    44.123   488.156     0.150
    44.123   885.934     0.150
    44.508   492.445     0.150
    44.710   496.793     0.150
    45.165   499.195     0.150
    45.165   498.453     0.150
    45.165   499.066     0.150
    45.497   499.078     0.150
    46.662   509.133     0.150
    46.838   509.668     0.150
    46.838   603.266     0.150
    47.266   515.703     0.150
    47.347   514.574     0.150
    47.347   605.680     0.150
    47.598   933.355     0.150
    47.785   518.695     0.150
    48.382   523.754     0.150
    48.748   525.836     0.150
    49.137   528.953     0.150
    49.324   532.398     0.150
    49.324   530.656     0.150
    49.918   534.727     0.150
    50.790   541.766     0.150
    51.479   545.219     0.150
    51.897   549.105     0.150
    52.231   552.266     0.150
    52.963   558.453     0.150
    53.040   559.746     0.150
    53.044   559.215     0.150
    53.069   559.496     0.150
    53.135   560.715     0.150
    53.192   562.023     0.150
    53.482   563.035     0.150
    53.775   563.793     0.150
    53.780   566.094     0.150
    54.731   571.023     0.150
    55.143   573.195     0.150
    55.168   575.344     0.150
    55.202   573.172     0.150
    55.197   574.855     0.150
    55.199   576.156     0.150
    55.468   574.965     0.150
    55.795   577.645     0.150
    56.556   583.355     0.150
    56.644   584.234     0.150
    56.693   584.965     0.150
    56.709   585.133     0.150
    56.807   591.344     0.150
    56.896   585.273     0.150
    57.287   588.105     0.150
    57.287   588.426     0.150
    57.298   588.844     0.150
    57.464   589.355     0.150
    57.464   642.828     0.150
    57.464  2402.156     0.150
    57.464   589.055     0.150
    57.849   591.227     0.150
    57.867   591.996     0.150
    57.870   591.383     0.150
    57.931   591.566     0.150
    57.931   591.453     0.150
    57.952   594.184     0.150
    58.411   596.656     0.150
    58.411   595.254     0.150
    58.932   604.953     0.150
    59.209   599.949     0.150
    59.209   602.656     0.150
    59.209   601.293     0.150
    59.336   602.223     0.150
    59.790   610.855     0.150
    59.833   611.355     0.150
    59.894   606.383     0.150
    59.981   611.539     0.150
    59.993   612.355     0.150
    59.993  1100.555     0.150
    59.993  1338.855     0.150
    60.034   612.355     0.150
    60.176   609.156     0.150
    60.176   608.656     0.150
    60.292   610.055     0.150
    60.292   608.605     0.150
    60.472   610.078     0.150
    60.472   610.234     0.150
    60.560   610.203     0.150
    62.003   622.453     0.150
    62.184   621.254     0.150
    62.593   625.035     0.150
    62.936   627.883     0.150
    63.054  1139.953     0.150
    63.054  1382.754     0.150
    63.482   631.805     0.150
    64.675   638.086     0.150
    64.819   640.504     0.150
    64.853   642.555     0.150
    64.853     7.000     0.150
    64.853   674.555     0.150
    64.853  1039.555     0.150
    64.853  1160.555     0.150
    64.853  1180.555     0.150
    64.853  1233.555     0.150
    64.853  1249.555     0.150
    64.853  1413.555     0.150
    64.976   640.156     0.150
    64.976   640.375     0.150
    65.051   640.453     0.150
    65.187   641.656     0.150
    65.378   643.055     0.150
    65.356   643.145     0.150
    65.555   644.254     0.150
    65.645   645.246     0.150
    66.066   647.953     0.150
    66.080   648.504     0.150
    66.768   653.926     0.150
    67.216   655.855     0.150
    67.375   656.156     0.150
    67.402   658.156     0.150
    67.517   655.094     0.150
    67.655   657.754     0.150
    67.703   658.523     0.150
    67.749   658.254     0.150
    67.799   658.855     0.150
    68.305   661.863     0.150
    69.342   667.316     0.150
    69.888   669.941     0.150
    70.114   674.254     0.150
    70.128   677.160     0.150
    71.647   680.953     0.150
    74.757   702.754     0.150
    74.757  1283.855     0.150
    75.010   705.156     0.150
    75.041   704.453     0.150
    75.424   705.254     0.150
    76.042   709.055     0.150
    76.042   717.656     0.150
    76.042  1286.953     0.150
    76.042  1588.656     0.150
    76.042   708.305     0.150
    77.619   716.355     0.150
    77.603   724.254     0.150
    78.313   721.684     0.150
    78.721   722.484     0.150
    78.745   722.273     0.150
    79.051   725.383     0.150
    79.148   725.727     0.150
    79.375   726.266     0.150
    79.622   727.105     0.150
    79.662   728.555     0.150
    79.733   729.816     0.150
    79.804   729.953     0.150
    79.804   907.156     0.150
    79.854   728.695     0.150
    79.861   730.754     0.150
    79.861  1347.754     0.150
    79.861  1650.355     0.150
    79.877   729.863     0.150
    79.877   730.953     0.150
    79.877   728.793     0.150
    79.898   728.781     0.150
    79.966   730.414     0.150
    79.961   730.086     0.150
    79.961  1332.516     0.150
    80.097   732.254     0.150
    80.097   918.156     0.150
    80.120   729.793     0.150
    80.139   732.656     0.150
    80.139   912.555     0.150
    80.167   732.855     0.150
    80.167   731.156     0.150
    80.225   730.934     0.150
    80.292   733.855     0.150
    80.307   733.156     0.150
    80.347   733.055     0.150
    80.347   912.555     0.150
    80.427   734.656     0.150
    80.507   732.676     0.150
    80.562   734.555     0.150
    80.578   734.453     0.150
    80.577   734.855     0.150
    80.577   914.953     0.150
    80.582   734.953     0.150
    80.677   733.824     0.150
    80.677  1340.164     0.150
    80.694   733.406     0.150
    80.766   734.953     0.150
    80.766  1358.754     0.150
    80.766   733.996     0.150
    80.793   734.715     0.150
    80.863   734.863     0.150
    80.952   736.453     0.150
    80.957   736.754     0.150
    80.957  1363.355     0.150
    81.008   736.355     0.150
    81.020   735.305     0.150
    81.032   736.645     0.150
    81.070   737.555     0.150
    81.105   927.953     0.150
    81.126   737.016     0.150
    81.118  1359.555     0.150
    81.118  1662.656     0.150
    81.221   735.996     0.150
    81.249   738.953     0.150
    81.308   741.523     0.150
    81.374   738.355     0.150
    81.374  1360.953     0.150
    81.374  1671.453     0.150
    81.421   737.934     0.150
    81.450   737.773     0.150
    81.654   739.465     0.150
    81.712   740.066     0.150
    82.010   740.664     0.150
    82.144   741.746     0.150
    82.485   746.613     0.150
    82.535   746.523     0.150
    82.780   745.133     0.150
    82.786   747.406     0.150
    82.839   748.523     0.150
    82.930   748.691     0.150
    83.132   747.254     0.150
    83.143   748.934     0.150
    83.188   748.195     0.150
    83.247   750.523     0.150
    83.288   748.055     0.150
    83.359   747.754     0.150
    83.510   752.523     0.150
    83.578   748.426     0.150
    83.588   750.594     0.150
    83.588  1385.895     0.150
    83.608   749.105     0.150
    83.628   752.195     0.150
    83.652   748.254     0.150
    83.652   937.855     0.150
    83.652  1367.453     0.150
    83.652  1423.754     0.150
    83.652  1702.953     0.150
    83.652   749.164     0.150
    83.641   753.523     0.150
    83.832   754.523     0.150
    83.835   753.523     0.150
    84.079   753.504     0.150
    84.079  1390.035     0.150
    84.129   755.523     0.150
    84.165   752.371     0.150
    84.445   754.594     0.150
    84.445  1388.273     0.150
    84.612   757.523     0.150
    84.630   754.656     0.150
    84.630  1377.945     0.150
    84.649   757.691     0.150
    84.902   758.582     0.150
    84.925   756.055     0.150
    85.055   756.855     0.150
    85.055   756.211     0.150
    85.056   756.754     0.150
    85.100   760.531     0.150
    85.119   759.676     0.150
    85.167   760.523     0.150
    85.233   757.453     0.150
    85.233   757.344     0.150
    85.301   758.043     0.150
    85.614   759.254     0.150
    85.614   760.535     0.150
    85.648   758.406     0.150
    85.664   760.074     0.150
    85.664  1400.184     0.150
    85.777   763.523     0.150
    85.730   759.945     0.150
    85.913   760.555     0.150
    85.913   760.074     0.150
    85.946   761.656     0.150
    85.946  1393.156     0.150
    86.009   761.645     0.150
    86.037   763.445     0.150
    86.055   762.855     0.150
    86.216   765.523     0.150
    86.241   765.652     0.150
    86.312   762.824     0.150
    86.392   764.434     0.150
    86.445   763.906     0.150
    86.553   763.785     0.150
    86.553  1400.855     0.150
    86.558   763.441     0.150
    86.591   765.254     0.150
    86.657   764.445     0.150
    86.753   766.344     0.150
    87.064   769.523     0.150
    87.105   766.254     0.150
    87.105   766.734     0.150
    87.963   774.523     0.150
    88.036   772.855     0.150
    88.282   771.355     0.150
    88.952   775.156     0.150
    88.952   774.715     0.150
    89.018   777.703     0.150
    89.127   982.555     0.150
    89.127  1406.555     0.150
    89.127  1413.555     0.150
    89.127  1491.555     0.150
    89.219   774.754     0.150
    89.219   775.453     0.150
    89.227   777.156     0.150
    89.532   779.664     0.150
    89.532  1427.496     0.150
    89.554   780.855     0.150
    90.238   778.203     0.150
    90.339   781.590     0.150
    90.339   994.414     0.150
    90.355   781.656     0.150
    90.366   781.555     0.150
    90.366  1420.555     0.150
    90.366     7.000     0.150
    90.366   993.555     0.150
    90.366  1502.555     0.150
    90.366  1808.555     0.150
    90.552   782.156     0.150
    90.552   994.355     0.150
    90.552     8.797     0.150
    90.555   782.297     0.150
    90.792   784.164     0.150
    90.792   998.664     0.150
    90.863   784.023     0.150
    90.898   782.852     0.150
    90.898  1000.281     0.150
    90.976   784.871     0.150
    90.976  1000.918     0.150
    91.063   785.965     0.150
    91.094   784.953     0.150
    91.094  1002.555     0.150
    91.094  1512.555     0.150
    91.354   786.863     0.150
    91.423   786.480     0.150
    91.423  1003.547     0.150
    91.610   788.156     0.150
    91.671   785.086     0.150
    91.715   789.156     0.150
    91.715  1419.156     0.150
    91.715   997.355     0.150
    91.715   787.434     0.150
    91.856   788.453     0.150
    91.856  1005.055     0.150
    91.922   788.656     0.150
    91.922  1008.289     0.150
    91.977   788.645     0.150
    92.008   788.234     0.150
    92.192   790.078     0.150
    92.192  1009.305     0.150
    92.299   790.133     0.150
    92.376   791.754     0.150
    92.376     9.402     0.150
    92.376  1011.055     0.150
    92.376  1421.055     0.150
    92.376  1824.855     0.150
    92.376   790.695     0.150
    92.404   791.754     0.150
    92.381   790.953     0.150
    92.421   791.656     0.150
    92.421  1009.555     0.150
    92.439   789.504     0.150
    92.538   791.773     0.150
    92.544   792.160     0.150
    92.544  1013.191     0.150
    92.528   791.859     0.150
    92.528   791.754     0.150
    92.672   792.555     0.150
    92.728   792.844     0.150
    92.728  1014.418     0.150
    92.732  1010.453     0.150
    92.732  1425.754     0.150
    92.729   792.656     0.150
    92.935   793.871     0.150
    92.935  1011.527     0.150
    93.041   794.355     0.150
    93.041   790.984     0.150
    93.066     6.703     0.150
    93.255   794.355     0.150
    93.255  1019.254     0.150
    93.255  1465.355     0.150
    93.255  1844.855     0.150
    93.277   796.555     0.150
    93.352   795.383     0.150
    93.352   796.156     0.150
    93.352   796.754     0.150
    93.352  1019.055     0.150
    93.352  1433.754     0.150
    93.352  1537.754     0.150
    93.364   796.156     0.150
    93.364  1018.953     0.150
    93.364  1433.754     0.150
    93.364  1537.754     0.150
    93.445   795.824     0.150
    93.491   797.555     0.150
    93.491  1461.555     0.150
    93.542   797.625     0.150
    93.542  1021.414     0.150
    93.542  1433.113     0.150
    93.542   795.672     0.150
    93.542  1015.238     0.150
    93.627   797.152     0.150
    93.627  1021.168     0.150
    93.641   797.055     0.150
    93.641   798.055     0.150
    93.641  1021.254     0.150
    93.641  1427.656     0.150
    93.641  1544.656     0.150
    93.641   795.645     0.150
    93.677   793.445     0.150
    93.752   797.281     0.150
    93.752  1016.875     0.150
    93.764   796.961     0.150
    93.764  1019.941     0.150
    93.823   798.766     0.150
    93.823  1022.855     0.150
    93.823  1432.484     0.150
    93.944   799.156     0.150
    93.944  1435.855     0.150
    94.060   798.766     0.150
    94.060  1022.734     0.150
    94.060  1447.996     0.150
    94.156   800.582     0.150
    94.156  1021.594     0.150
    94.190   801.453     0.150
    94.190  1026.355     0.150
    94.190  1441.156     0.150
    94.218   800.656     0.150
    94.459   802.156     0.150
    94.459  1028.574     0.150
    94.459  1449.586     0.150
    94.547   801.305     0.150
    94.606   801.305     0.150
    94.637   801.453     0.150
    94.788   802.785     0.150
    94.861   802.504     0.150
    95.039   804.555     0.150
    95.039   803.855     0.150
    95.310  1031.648     0.150
    95.338  1028.625     0.150
    95.496   806.656     0.150
    95.496  1037.156     0.150
    95.496  1479.555     0.150
    95.496  1560.453     0.150
    95.685   808.578     0.150
    95.685  1038.578     0.150
    95.929   805.254     0.150
    95.929  1035.953     0.150
    95.929   805.355     0.150
    95.929  1036.055     0.150
    95.946   809.855     0.150
    95.946   808.621     0.150
    95.946   807.977     0.150
    96.021   809.555     0.150
    96.021   807.633     0.150
    96.047   806.555     0.150
    96.047  1444.555     0.150
    96.047  1478.555     0.150
    96.047  1572.555     0.150
    96.138   807.645     0.150
    96.138  1031.648     0.150
    96.693   813.953     0.150
    96.804   813.555     0.150
    96.811   812.055     0.150
    96.877   811.754     0.150
    96.877  1044.953     0.150
    96.877  1445.656     0.150
    96.877  1488.156     0.150
    97.046   809.855     0.150
    97.046  1043.656     0.150
    97.109   811.754     0.150
    97.299   813.598     0.150
    97.299  1045.633     0.150
    97.371   813.574     0.150
    97.781   817.055     0.150
    97.810   817.555     0.150
    97.865   816.754     0.150
    98.164   817.953     0.150
    98.546   821.055     0.150
    98.729   820.453     0.150
    99.004   821.656     0.150
    99.059   820.934     0.150
    99.114   822.555     0.150
    99.114  1460.555     0.150
    99.114  1513.555     0.150
    99.161   820.793     0.150
    99.161  1060.715     0.150
    99.202   820.754     0.150
    99.202  1058.855     0.150
    99.267   821.555     0.150
    99.267  1062.355     0.150
    99.267  1456.953     0.150
    99.267  1595.156     0.150
    99.267  1915.156     0.150
    99.789  1071.156     0.150
    99.789  1461.055     0.150
    99.789  1609.754     0.150
    99.789  1931.453     0.150
   100.082   827.656     0.150
   100.119   826.656     0.150
   100.276   829.055     0.150
   100.626   828.055     0.150
   100.646   829.027     0.150
   100.646  1073.730     0.150
   100.742   827.754     0.150
   100.746   830.020     0.150
   100.746  1078.375     0.150
   100.746   829.453     0.150
   100.862   828.953     0.150
   101.199   831.555     0.150
   101.360   828.555     0.150
   101.360  1078.555     0.150
   101.360  1612.555     0.150
   101.360  1964.555     0.150
   101.360  1470.555     0.150
   102.079   833.855     0.150
   102.746   838.355     0.150
   103.230   839.156     0.150
   103.968  1103.828     0.150
   104.260   842.355     0.150
   104.744   845.355     0.150
   104.744  1482.453     0.150
   104.744  1648.855     0.150
   104.744  1662.156     0.150
   105.476  1110.555     0.150
   107.238   858.254     0.150
   107.238  1122.453     0.150
   107.238  1491.953     0.150
   108.794  1109.715     0.150
   108.794  1132.500     0.150
   109.243  1136.953     0.150
   109.243  1504.754     0.150
   109.243  1709.953     0.150
   109.243  2055.953     0.150
   109.369   868.555     0.150
   109.369  1141.156     0.150
   109.369  1601.855     0.150
   109.425  1110.559     0.150
   109.425  1139.094     0.150
   109.992  1112.250     0.150
   109.992  1792.953     0.150
   110.177  1792.590     0.150
   110.345   870.855     0.150
   110.345  2067.355     0.150
   110.618  1791.531     0.150
   111.587  1115.363     0.150
   111.587  1152.434     0.150
   111.587  1784.234     0.150
   112.741  1116.555     0.150
   112.832  1115.965     0.150
   112.832  1157.781     0.150
   113.237   882.254     0.150
   113.237  1117.656     0.150
   113.237  1166.254     0.150
   113.237  1518.855     0.150
   113.237  1741.555     0.150
   113.237  2109.953     0.150
   115.778  1124.055     0.150
   115.778  1190.355     0.150
   115.778  1547.453     0.150
   116.658  1123.953     0.150
   116.666  1123.730     0.150
   116.666  1183.004     0.150
   118.364  1124.055     0.150
   118.364  2178.855     0.150
   119.063  1130.453     0.150
   119.063  2184.855     0.150
   119.305  1129.953     0.150
   119.305  1140.953     0.150
   119.305  1215.656     0.150
   119.305  1559.156     0.150
   119.305  2192.355     0.150
   119.961  1131.227     0.150
   120.389  1134.293     0.150
   120.496  1132.914     0.150
   120.585  1132.680     0.150
   120.585  1132.055     0.150
   120.585  1132.445     0.150
   120.841  1132.855     0.150
   120.994  1133.984     0.150
   121.014  1134.055     0.150
   121.202  1136.953     0.150
   121.219  1229.355     0.150
   121.219  1565.953     0.150
   121.219  2217.855     0.150
   121.270  1133.656     0.150
   121.626  1134.855     0.150
   121.697  1134.863     0.150
   121.897  1135.453     0.150
   122.624  1136.355     0.150
   122.624  1234.656     0.150
   122.624  1645.953     0.150
   122.624  2233.355     0.150
   122.706  1136.953     0.150
   122.731  1239.055     0.150
   122.731  2243.656     0.150
   122.927  1139.453     0.150
   122.927  1238.156     0.150
   122.927  2243.656     0.150
   123.009  1137.504     0.150
   123.666  1138.855     0.150
   123.802  1140.355     0.150
   123.802  1566.656     0.150
   124.227  1137.938     0.150
   124.300  1248.355     0.150
   124.300  2259.355     0.150
   125.480  1141.543     0.150
   127.314  1145.656     0.150
   127.532  1148.355     0.150
   127.532  1270.453     0.150
   127.532  1578.855     0.150
   127.532  2297.453     0.150
   127.779  1146.625     0.150
   127.984  1146.141     0.150
   128.116  1147.254     0.150
   128.371  1148.367     0.150
   128.371  1147.055     0.150
   128.452  1148.871     0.150
   128.452  1152.094     0.150
   128.961  1148.855     0.150
   128.973  1149.230     0.150
   129.650  1150.164     0.150
   129.651  1150.504     0.150
   129.651  1933.434     0.150
   129.651  1150.055     0.150
   130.021  1152.355     0.150
   130.021  1285.453     0.150
   130.021  1367.355     0.150
   130.021  1697.453     0.150
   130.768  1151.922     0.150
   130.768  1355.988     0.150
   131.047  1152.363     0.150
   132.223  1154.754     0.150
   132.622  1158.953     0.150
   132.622  1302.355     0.150
   132.622  1158.656     0.150
   133.008  1158.355     0.150
   133.008  1165.953     0.150
   133.008  1302.855     0.150
   133.008  1369.355     0.150
   133.008  1582.855     0.150
   133.075  1156.023     0.150
   134.146  1157.953     0.150
   134.146  2376.055     0.150
   134.681  1154.055     0.150
   134.693  1160.668     0.150
   134.817  1159.504     0.150
   135.408  1161.773     0.150
   135.879  1160.195     0.150
   138.761  1166.383     0.150
   139.291  1169.875     0.150
   140.074  1171.086     0.150
   140.206  1169.754     0.150
   140.519  1171.031     0.150
   142.241  1172.227     0.150
   143.716  1174.316     0.150
   145.196  1178.043     0.150
   145.415  1179.516     0.150
   145.927  1179.555     0.150
   145.927  1380.555     0.150
   145.927  1788.555     0.150
   145.927  2148.555     0.150
   145.927  1178.715     0.150
   146.160  1180.145     0.150
   147.229  1183.426     0.150
   147.757  1182.016     0.150
   148.256  1187.203     0.150
   148.307  1182.793     0.150
   149.221  1190.535     0.150
   150.303  1185.625     0.150
   150.334  1187.293     0.150
   150.334  1193.586     0.150
   150.443  1187.074     0.150
   150.443  1195.004     0.150
   150.674  1187.824     0.150
   150.674  1195.203     0.150
   151.776  1197.914     0.150
   153.401  1192.594     0.150
   153.401  1201.262     0.150
   153.401  1191.656     0.150
   153.401  1201.156     0.150
   154.595  1192.043     0.150
   155.330  1194.176     0.150
   156.062  1222.852     0.150
     0.240     6.789     0.150
     0.240    10.809     0.150
     0.642    13.020     0.150
     0.642    21.469     0.150
     1.124    20.969     0.150
     1.286    24.020     0.150
     1.441    26.188     0.150
     1.594    28.508     0.150
     1.594    48.770     0.150
     1.594    49.770     0.150
     1.620    28.727     0.150
     1.620    48.438     0.150
     1.914    31.887     0.150
     1.914    55.316     0.150
     1.914    53.098     0.150
     2.128    35.477     0.150
     2.128    64.656     0.150
     2.464    40.387     0.150
     2.474    41.047     0.150
     2.559    82.488     0.150
     2.643    43.270     0.150
     2.805    45.719     0.150
     2.805    78.047     0.150
     3.063    48.617     0.150
     3.073    48.156     0.150
     3.218    52.406     0.150
     3.251    65.047     0.150
     3.551    55.297     0.150
     3.551   106.527     0.150
     4.231    62.496     0.150
     4.570    68.867     0.150
     4.570    83.277     0.150
     4.570   121.367     0.150
     4.570   143.367     0.150
     4.570    69.168     0.150
     6.546    98.719     0.150
     7.223   106.566     0.150
     8.064   117.527     0.150
     9.015   128.598     0.150
     9.015   225.898     0.150
     9.015   284.172     0.150
    10.252   145.906     0.150
    10.821   154.648     0.150
    11.315   160.285     0.150
    11.315   283.047     0.150
    11.476   162.699     0.150
    11.529   166.539     0.150
    12.240   174.367     0.150
    12.350   180.004     0.150
    13.014   187.445     0.150
    13.014   418.645     0.150
    13.014   186.449     0.150
    13.014   187.449     0.150
    13.014   186.906     0.150
    13.014   186.898     0.150
    13.347   188.867     0.150
    13.552   191.047     0.150
    13.622   191.746     0.150
    13.622   193.688     0.150
    14.051   199.547     0.150
    14.819   211.316     0.150
    15.259   215.203     0.150
    15.259   214.688     0.150
    15.572   218.031     0.150
    15.572   217.469     0.150
    15.547   217.668     0.150
    15.725   222.676     0.150
    15.725   222.207     0.150
    15.678   220.691     0.150
    15.678   221.848     0.150
    15.759   221.590     0.150
    15.759   221.109     0.150
    15.871   224.617     0.150
    15.921   224.867     0.150
    15.997   226.008     0.150
    16.546   232.309     0.150
    16.608   235.008     0.150
    16.955   239.457     0.150
    17.312   242.953     0.150
    17.330   240.922     0.150
    17.444   241.520     0.150
    17.444   240.906     0.150
    17.444   244.047     0.150
    17.516   242.809     0.150
    17.736   246.188     0.150
    17.820   246.727     0.150
    17.885   246.449     0.150
    17.885   248.062     0.150
    18.105   251.191     0.150
    18.129   250.207     0.150
    18.340   252.566     0.150
    18.383   255.426     0.150
    18.404   255.457     0.150
    18.462   253.906     0.150
    18.448   257.148     0.150
    18.448   257.266     0.150
    18.495   254.348     0.150
    18.495   254.727     0.150
    18.505   257.648     0.150
    18.534   256.137     0.150
    18.647   256.453     0.150
    18.647   255.836     0.150
    19.059   262.004     0.150
    19.059   260.809     0.150
    19.062   261.039     0.150
    19.073   263.566     0.150
    19.073   262.449     0.150
    19.073   263.949     0.150
    19.114   261.906     0.150
    19.246   265.488     0.150
    19.246   266.129     0.150
    19.319   264.711     0.150
    19.345   264.535     0.150
    19.386   265.121     0.150
    19.386   264.539     0.150
    19.427   265.184     0.150
    19.460   265.141     0.150
    19.514   266.547     0.150
    19.556   266.176     0.150
    19.634   267.637     0.150
    19.651   267.652     0.150
    19.705   268.387     0.150
    19.719   268.395     0.150
    19.778   268.578     0.150
    19.778   267.457     0.150
    19.795   269.586     0.150
    19.795   268.816     0.150
    19.820   269.547     0.150
    19.820   269.246     0.150
    19.887   269.648     0.150
    19.887   269.453     0.150
    19.909   270.102     0.150
    19.909   269.906     0.150
    19.927   273.848     0.150
    20.060   271.746     0.150
    20.080   272.074     0.150
    20.080   271.426     0.150
    20.138   272.805     0.150
    20.162   273.176     0.150
    20.173   273.469     0.150
    20.181   273.258     0.150
    20.217   273.164     0.150
    20.217   274.328     0.150
    20.297   274.203     0.150
    20.351   278.129     0.150
    20.351   276.676     0.150
    20.395   275.789     0.150
    20.395   275.598     0.150
    20.389   278.598     0.150
    20.487   277.539     0.150
    20.536   278.184     0.150
    20.536   277.238     0.150
    20.536   277.750     0.150
    20.558   277.926     0.150
    20.629   277.508     0.150
    20.633   278.348     0.150
    20.682   278.730     0.150
    20.712   279.145     0.150
    20.696   281.344     0.150
    20.743   279.461     0.150
    20.743   278.809     0.150
    20.784   280.551     0.150
    20.784   279.098     0.150
    20.859   279.848     0.150
    20.899   280.996     0.150
    20.899   280.387     0.150
    20.927   281.137     0.150
    20.996   282.559     0.150
    21.115   283.418     0.150
    21.159   283.938     0.150
    21.243   283.926     0.150
    21.204   287.047     0.150
    21.204   288.059     0.150
    21.307   285.523     0.150
    21.302   285.047     0.150
    21.334   286.512     0.150
    21.375   289.738     0.150
    21.492   287.598     0.150
    21.514   286.949     0.150
    21.497   289.711     0.150
    21.497   288.496     0.150
    21.646   288.629     0.150
    21.671   289.078     0.150
    21.671   288.270     0.150
    21.689   288.477     0.150
    21.695   289.668     0.150
    21.721   290.129     0.150
    21.721   289.469     0.150
    21.730   289.836     0.150
    21.694   292.723     0.150
    21.707   292.711     0.150
    21.747   293.461     0.150
    21.794   290.727     0.150
    21.787   292.910     0.150
    21.787   291.836     0.150
    21.817   290.875     0.150
    21.808   293.586     0.150
    21.896   291.496     0.150
    21.935   291.047     0.150
    21.935   292.055     0.150
    21.936   292.246     0.150
    21.936   292.426     0.150
    22.026   293.055     0.150
    22.026   292.668     0.150
    22.001   295.812     0.150
    22.051   292.746     0.150
    22.051   293.266     0.150
    22.056   292.816     0.150
    22.056   292.078     0.150
    22.058   292.816     0.150
    22.052   296.773     0.150
    22.107   293.766     0.150
    22.107   293.086     0.150
    22.066   295.469     0.150
    22.128   294.133     0.150
    22.189   298.004     0.150
    22.226   298.336     0.150
    22.296   296.258     0.150
    22.286   297.156     0.150
    22.286   296.219     0.150
    22.306   295.852     0.150
    22.357   296.152     0.150
    22.357   295.906     0.150
    22.381   296.957     0.150
    22.432   296.148     0.150
    22.432   296.871     0.150
    22.511   297.965     0.150
    22.477   301.098     0.150
    22.477   300.520     0.150
    22.571   297.898     0.150
    22.543   300.676     0.150
    22.612   298.723     0.150
    22.613   297.949     0.150
    22.564   301.586     0.150
    22.566   301.520     0.150
    22.566   301.246     0.150
    22.604   300.934     0.150
    22.661   299.406     0.150
    22.658   301.426     0.150
    22.733   300.816     0.150
    22.743   300.039     0.150
    22.773   301.422     0.150
    22.775   299.520     0.150
    22.757   302.637     0.150
    22.771   302.289     0.150
    22.776   302.676     0.150
    22.830   300.871     0.150
    22.833   301.223     0.150
    22.853   302.906     0.150
    22.865   303.176     0.150
    22.923   301.922     0.150
    22.897   303.879     0.150
    22.902   303.469     0.150
    22.912   303.488     0.150
    22.927   303.727     0.150
    22.958   301.969     0.150
    22.937   305.367     0.150
    22.961   304.336     0.150
    22.970   304.148     0.150
    23.006   303.203     0.150
    23.006   302.879     0.150
    22.999   305.027     0.150
    23.017   305.066     0.150
    23.006   305.984     0.150
    23.085   305.879     0.150
    23.114   304.789     0.150
    23.093   306.039     0.150
    23.172   304.547     0.150
    23.166   306.879     0.150
    23.174   306.906     0.150
    23.199   306.957     0.150
    23.270   305.449     0.150
    23.268   308.859     0.150
    23.318   305.984     0.150
    23.318   305.449     0.150
    23.342   305.418     0.150
    23.292   309.977     0.150
    23.384   307.727     0.150
    23.351   309.863     0.150
    23.406   308.859     0.150
    23.484   308.328     0.150
    23.486   307.746     0.150
    23.452   309.848     0.150
    23.492   309.828     0.150
    23.512   308.367     0.150
    23.490   308.328     0.150
    23.501   309.449     0.150
    23.501   310.195     0.150
    23.546   308.434     0.150
    23.576   308.637     0.150
    23.563   312.348     0.150
    23.684   311.098     0.150
    23.694   311.004     0.150
    23.645   313.258     0.150
    23.745   311.117     0.150
    23.745   310.258     0.150
    23.768   310.773     0.150
    23.768   310.316     0.150
    23.721   313.668     0.150
    23.881   312.570     0.150
    23.863   314.676     0.150
    23.866   313.699     0.150
    23.917   312.906     0.150
    23.920   313.844     0.150
    23.920   313.270     0.150
    23.933   313.219     0.150
    23.981   313.750     0.150
    23.982   313.148     0.150
    23.950   314.488     0.150
    23.958   316.223     0.150
    23.958   315.027     0.150
    23.956   315.047     0.150
    23.969   314.777     0.150
    24.014   313.668     0.150
    24.028   313.230     0.150
    24.044   314.379     0.150
    24.044   313.777     0.150
    24.000   315.359     0.150
    24.084   313.707     0.150
    24.098   316.895     0.150
    24.153   316.539     0.150
    24.153   315.879     0.150
    24.146   318.027     0.150
    24.179   316.246     0.150
    24.263   316.492     0.150
    24.282   315.922     0.150
    24.264   316.848     0.150
    24.302   316.340     0.150
    24.302   316.008     0.150
    24.301   316.418     0.150
    24.362   316.246     0.150
    24.362   316.738     0.150
    24.359   319.598     0.150
    24.412   317.523     0.150
    24.424   317.375     0.150
    24.435   317.340     0.150
    24.424   319.781     0.150
    24.424   319.336     0.150
    24.520   318.879     0.150
    24.520   317.969     0.150
    24.561   319.500     0.150
    24.561   318.758     0.150
    24.512   321.051     0.150
    24.577   319.520     0.150
    24.608   319.723     0.150
    24.584   320.816     0.150
    24.588   321.652     0.150
    24.623   320.801     0.150
    24.684   319.559     0.150
    24.716   320.246     0.150
    24.763   320.973     0.150
    24.760   323.656     0.150
    24.837   324.195     0.150
    24.902   321.391     0.150
    24.902   320.539     0.150
    24.870   324.691     0.150
    24.870   324.367     0.150
    24.887   324.684     0.150
    24.929   322.457     0.150
    24.880   322.809     0.150
    24.967   322.469     0.150
    24.996   322.535     0.150
    25.014   322.766     0.150
    25.014   322.148     0.150
    24.982   324.289     0.150
    25.023   323.492     0.150
    25.023   322.488     0.150
    25.069   322.848     0.150
    25.082   324.020     0.150
    25.082   323.406     0.150
    25.031   325.840     0.150
    25.124   323.996     0.150
    25.124   323.270     0.150
    25.165   324.875     0.150
    25.189   324.387     0.150
    25.190   324.270     0.150
    25.214   325.270     0.150
    25.214   325.137     0.150
    25.218   324.484     0.150
    25.218   324.020     0.150
    25.201   325.406     0.150
    25.180   327.047     0.150
    25.180   327.160     0.150
    25.195   327.906     0.150
    25.280   325.246     0.150
    25.280   324.199     0.150
    25.319   325.453     0.150
    25.319   324.586     0.150
    25.340   325.730     0.150
    25.340   325.137     0.150
    25.367   326.156     0.150
    25.367   325.328     0.150
    25.372   327.328     0.150
    25.413   326.945     0.150
    25.475   327.336     0.150
    25.475   326.508     0.150
    25.485   329.660     0.150
    25.493   329.973     0.150
    25.499   330.551     0.150
    25.629   328.277     0.150
    25.629   328.066     0.150
    25.635   329.180     0.150
    25.561   333.008     0.150
    25.647   328.555     0.150
    25.624   331.477     0.150
    25.664   331.910     0.150
    25.721   328.625     0.150
    25.729   329.574     0.150
    25.740   330.289     0.150
    25.763   329.496     0.150
    25.763   329.129     0.150
    25.853   331.574     0.150
    25.829   331.066     0.150
    25.894   330.938     0.150
    25.898   331.168     0.150
    25.898   330.078     0.150
    25.904   331.594     0.150
    25.910   331.414     0.150
    25.959   332.391     0.150
    25.911   334.719     0.150
    25.965   333.648     0.150
    25.965   333.855     0.150
    26.016   335.484     0.150
    26.127   332.766     0.150
    26.137   333.297     0.150
    26.199   333.121     0.150
    26.199   332.469     0.150
    26.154   335.566     0.150
    26.219   334.719     0.150
    26.300   335.004     0.150
    26.300   334.457     0.150
    26.277   335.328     0.150
    26.324   334.945     0.150
    26.336   334.695     0.150
    26.336   333.949     0.150
    26.300   336.727     0.150
    26.424   336.277     0.150
    26.424   335.508     0.150
    26.372   337.270     0.150
    26.431   337.094     0.150
    26.431   336.109     0.150
    26.470   336.191     0.150
    26.470   334.539     0.150
    26.484   336.863     0.150
    26.484   335.926     0.150
    26.491   336.449     0.150
    26.491   337.051     0.150
    26.425   339.816     0.150
    26.544   336.500     0.150
    26.544   335.449     0.150
    26.545   336.141     0.150
    26.585   337.770     0.150
    26.586   337.508     0.150
    26.594   336.953     0.150
    26.681   339.270     0.150
    26.725   338.777     0.150
    26.660   341.520     0.150
    26.710   343.219     0.150
    26.768   340.648     0.150
    26.807   339.020     0.150
    26.765   342.129     0.150
    26.828   339.738     0.150
    26.832   339.145     0.150
    26.832   338.559     0.150
    26.832   339.184     0.150
    26.832   338.719     0.150
    26.805   340.469     0.150
    26.845   339.934     0.150
    26.860   338.914     0.150
    26.860   338.566     0.150
    26.876   340.129     0.150
    26.844   341.559     0.150
    26.902   342.738     0.150
    26.975   340.637     0.150
    26.975   340.328     0.150
    27.016   341.520     0.150
    27.016   341.066     0.150
    26.980   343.828     0.150
    27.038   341.672     0.150
    27.066   342.449     0.150
    27.056   545.027     0.150
    27.056   345.098     0.150
    27.056   545.031     0.150
    27.056   344.520     0.150
    27.101   342.434     0.150
    27.106   341.211     0.150
    27.111   341.625     0.150
    27.225   342.562     0.150
    27.159   347.469     0.150
    27.240   342.246     0.150
    27.240   342.371     0.150
    27.233   344.059     0.150
    27.233   543.418     0.150
    27.233   344.547     0.150
    27.233   543.418     0.150
    27.233   344.379     0.150
    27.233   344.551     0.150
    27.233   343.977     0.150
    27.274   343.586     0.150
    27.301   342.434     0.150
    27.301   344.234     0.150
    27.319   345.137     0.150
    27.335   344.746     0.150
    27.393   344.090     0.150
    27.409   345.137     0.150
    27.420   345.457     0.150
    27.411   346.723     0.150
    27.411   544.598     0.150
    27.411   345.848     0.150
    27.450   344.172     0.150
    27.450   343.496     0.150
    27.413   346.246     0.150
    27.467   344.691     0.150
    27.467   343.176     0.150
    27.479   345.496     0.150
    27.479   344.520     0.150
    27.506   345.113     0.150
    27.506   344.207     0.150
    27.491   345.746     0.150
    27.491   346.512     0.150
    27.551   346.340     0.150
    27.551   345.586     0.150
    27.573   345.961     0.150
    27.574   345.723     0.150
    27.574   344.367     0.150
    27.567   346.859     0.150
    27.567   345.387     0.150
    27.646   346.660     0.150
    27.669   346.867     0.150
    27.710   347.883     0.150
    27.710   347.008     0.150
    27.705   348.547     0.150
    27.760   347.770     0.150
    27.760   346.770     0.150
    27.827   348.285     0.150
    27.904   350.113     0.150
    27.912   348.625     0.150
    27.912   348.238     0.150
    27.956   350.055     0.150
    27.922   351.047     0.150
    27.991   349.184     0.150
    27.961   352.746     0.150
    27.945   352.578     0.150
    28.021   350.363     0.150
    28.021   349.027     0.150
    28.053   350.012     0.150
    28.139   350.996     0.150
    28.139   350.508     0.150
    28.143   352.699     0.150
    28.207   353.176     0.150
    28.262   351.801     0.150
    28.229   354.027     0.150
    28.293   351.738     0.150
    28.293   351.246     0.150
    28.288   352.969     0.150
    28.317   352.449     0.150
    28.325   353.039     0.150
    28.303   353.688     0.150
    28.389   352.973     0.150
    28.394   353.621     0.150
    28.406   355.906     0.150
    28.465   354.836     0.150
    28.472   355.199     0.150
    28.472   354.496     0.150
    28.474   354.562     0.150
    28.474   353.688     0.150
    28.468   354.219     0.150
    28.500   354.055     0.150
    28.500   353.449     0.150
    28.565   355.617     0.150
    28.565   354.688     0.150
    28.565   357.137     0.150
    28.626   356.160     0.150
    28.634   356.383     0.150
    28.665   355.555     0.150
    28.668   355.738     0.150
    28.681   355.887     0.150
    28.659   357.199     0.150
    28.659   548.129     0.150
    28.563   356.688     0.150
    28.711   355.695     0.150
    28.763   358.148     0.150
    28.851   357.086     0.150
    28.874   356.449     0.150
    28.874   357.688     0.150
    28.898   359.188     0.150
    28.919   357.750     0.150
    28.919   357.199     0.150
    28.928   357.895     0.150
    28.928   357.527     0.150
    28.884   360.086     0.150
    28.992   359.598     0.150
    28.966   359.770     0.150
    29.012   358.535     0.150
    29.019   361.625     0.150
    29.019   360.457     0.150
    29.081   360.633     0.150
    29.113   359.164     0.150
    29.221   361.074     0.150
    29.221   358.617     0.150
    29.197   363.699     0.150
    29.245   361.684     0.150
    29.251   361.371     0.150
    29.253   360.262     0.150
    29.253   359.688     0.150
    29.282   360.562     0.150
    29.344   363.328     0.150
    29.373   363.574     0.150
    29.373   363.418     0.150
    29.377   363.457     0.150
    29.431   363.586     0.150
    29.431   363.020     0.150
    29.462   362.957     0.150
    29.462   362.547     0.150
    29.473   362.441     0.150
    29.473   361.836     0.150
    29.457   363.828     0.150
    29.494   362.598     0.150
    29.612   364.129     0.150
    29.656   366.367     0.150
    29.684   365.301     0.150
    29.684   364.809     0.150
    29.692   364.469     0.150
    29.692   363.156     0.150
    29.790   367.156     0.150
    29.835   366.789     0.150
    29.835   366.066     0.150
    29.835   366.801     0.150
    29.909   365.348     0.150
    29.884   366.836     0.150
    29.968   367.062     0.150
    30.011   367.219     0.150
    30.035   367.922     0.150
    30.035   366.969     0.150
    30.089   367.637     0.150
    30.073   369.668     0.150
    30.098   369.578     0.150
    30.146   369.586     0.150
    30.101   370.438     0.150
    30.222   369.984     0.150
    30.294   370.828     0.150
    30.308   370.816     0.150
    30.302   371.445     0.150
    30.280   372.047     0.150
    30.343   370.680     0.150
    30.343   368.977     0.150
    30.360   371.723     0.150
    30.412   372.223     0.150
    30.416   373.945     0.150
    30.452   371.492     0.150
    30.455   371.711     0.150
    30.455   369.789     0.150
    30.475   371.613     0.150
    30.480   372.625     0.150
    30.479   373.848     0.150
    30.505   371.078     0.150
    30.515   372.375     0.150
    30.525   371.762     0.150
    30.574   373.500     0.150
    30.579   372.691     0.150
    30.622   373.367     0.150
    30.663   373.039     0.150
    30.673   373.836     0.150
    30.662   375.926     0.150
    30.719   374.270     0.150
    30.755   373.840     0.150
    30.763   374.641     0.150
    30.763   374.477     0.150
    30.748   376.531     0.150
    30.885   376.348     0.150
    30.935   378.148     0.150
    30.967   377.059     0.150
    30.967   375.398     0.150
    30.996   375.465     0.150
    31.007   377.449     0.150
    31.007   376.520     0.150
    31.030   376.598     0.150
    31.086   377.539     0.150
    31.086   375.746     0.150
    31.108   377.082     0.150
    31.148   377.840     0.150
    31.156   377.414     0.150
    31.207   377.812     0.150
    31.231   377.836     0.150
    31.243   377.703     0.150
    31.246   379.980     0.150
    31.317   379.070     0.150
    31.317   378.520     0.150
    31.342   379.223     0.150
    31.303   379.898     0.150
    31.388   379.777     0.150
    31.353   382.133     0.150
    31.371   380.738     0.150
    31.472   381.445     0.150
    31.497   382.418     0.150
    31.543   381.129     0.150
    31.543   380.648     0.150
    31.569   381.254     0.150
    31.570   381.539     0.150
    31.570   381.086     0.150
    31.594   382.469     0.150
    31.616   383.109     0.150
    31.663   383.039     0.150
    31.663   382.836     0.150
    31.669   383.148     0.150
    31.734   382.770     0.150
    31.768   383.234     0.150
    31.780   383.336     0.150
    31.780   382.789     0.150
    31.784   383.777     0.150
    31.749   384.426     0.150
    31.818   383.227     0.150
    31.808   384.832     0.150
    31.808   384.348     0.150
    31.776   384.449     0.150
    31.849   384.387     0.150
    31.852   383.543     0.150
    31.868   383.406     0.150
    31.874   383.793     0.150
    31.874   383.598     0.150
    31.907   386.309     0.150
    31.920   386.625     0.150
    31.960   384.992     0.150
    32.011   386.523     0.150
    32.035   385.648     0.150
    32.098   385.227     0.150
    32.087   385.438     0.150
    32.129   386.441     0.150
    32.164   386.164     0.150
    32.152   388.977     0.150
    32.212   386.699     0.150
    32.206   388.523     0.150
    32.206   387.527     0.150
    32.231   388.715     0.150
    32.231   388.289     0.150
    32.252   386.875     0.150
    32.258   387.258     0.150
    32.273   388.168     0.150
    32.282   387.066     0.150
    32.283   390.777     0.150
    32.366   388.090     0.150
    32.389   389.219     0.150
    32.412   388.363     0.150
    32.424   389.301     0.150
    32.424   388.520     0.150
    32.395   391.348     0.150
    32.477   388.758     0.150
    32.554   389.785     0.150
    32.523   391.988     0.150
    32.549   392.340     0.150
    32.550   391.957     0.150
    32.579   391.789     0.150
    32.679   391.145     0.150
    32.784   391.746     0.150
    32.784   392.926     0.150
    32.793   390.906     0.150
    32.802   392.047     0.150
    32.890   392.625     0.150
    32.925   395.059     0.150
    32.973   393.746     0.150
    32.957   395.828     0.150
    33.035   393.730     0.150
    32.997   395.758     0.150
    33.061   395.574     0.150
    33.104   396.492     0.150
    33.155   395.199     0.150
    33.155   394.777     0.150
    33.132   396.238     0.150
    33.214   395.266     0.150
    33.292   396.207     0.150
    33.292   395.578     0.150
    33.298   395.969     0.150
    33.388   396.926     0.150
    33.379   397.648     0.150
    33.464   397.398     0.150
    33.422   400.664     0.150
    33.434   400.559     0.150
    33.491   398.059     0.150
    33.509   398.422     0.150
    33.509   397.949     0.150
    33.522   397.852     0.150
    33.527   398.000     0.150
    33.532   398.086     0.150
    33.501   400.758     0.150
    33.548   398.406     0.150
    33.655   401.418     0.150
    33.678   402.562     0.150
    33.750   400.227     0.150
    33.800   402.633     0.150
    33.825   401.688     0.150
    33.939   402.137     0.150
    33.940   401.605     0.150
    33.997   402.062     0.150
    34.044   403.688     0.150
    34.050   402.676     0.150
    34.045   406.152     0.150
    34.127   403.938     0.150
    34.198   403.926     0.150
    34.199   403.793     0.150
    34.211   405.758     0.150
    34.267   404.660     0.150
    34.239   407.969     0.150
    34.344   405.242     0.150
    34.426   405.957     0.150
    34.479   406.859     0.150
    34.493   406.637     0.150
    34.495   407.348     0.150
    34.495   409.023     0.150
    34.505   408.098     0.150
    34.549   406.891     0.150
    34.582   407.406     0.150
    34.560   409.992     0.150
    34.698   408.562     0.150
    34.744   408.988     0.150
    34.849   410.402     0.150
    34.849   409.758     0.150
    34.850   409.906     0.150
    34.873   410.016     0.150
    34.950   410.723     0.150
    34.987   411.301     0.150
    34.987   410.508     0.150
    34.991   411.086     0.150
    35.094   413.059     0.150
    35.063   412.648     0.150
    35.063   564.949     0.150
    35.089   414.750     0.150
    35.215   411.836     0.150
    35.230   413.387     0.150
    35.230   411.676     0.150
    35.247   415.859     0.150
    35.418   415.000     0.150
    35.445   414.867     0.150
    35.473   415.527     0.150
    35.488   415.449     0.150
    35.507   415.297     0.150
    35.481   417.008     0.150
    35.604   414.938     0.150
    35.644   416.480     0.150
    35.735   417.359     0.150
    35.813   420.809     0.150
    35.990   420.648     0.150
    35.990   421.035     0.150
    36.006   419.598     0.150
    36.013   420.242     0.150
    36.163   421.660     0.150
    36.225   423.980     0.150
    36.339   422.770     0.150
    36.339   423.711     0.150
    36.323   423.488     0.150
    36.369   424.496     0.150
    36.462   425.926     0.150
    36.514   424.523     0.150
    36.525   424.527     0.150
    36.619   425.789     0.150
    36.734   426.684     0.150
    36.979   430.477     0.150
    37.087   429.168     0.150
    37.124   430.180     0.150
    37.236   432.176     0.150
    37.388   431.648     0.150
    37.453   432.949     0.150
    37.626   434.066     0.150
    37.653   434.883     0.150
    37.889   436.566     0.150
    37.896   436.746     0.150
    37.896   436.426     0.150
    38.090   438.375     0.150
    38.090   437.809     0.150
    38.190   439.734     0.150
    38.160   439.918     0.150
    38.286   439.652     0.150
    38.798   442.996     0.150
    38.822   443.750     0.150
    38.854   443.617     0.150
    39.391   448.066     0.150
    39.658   450.648     0.150
    40.988   461.137     0.150
    41.092   462.398     0.150
    41.861   470.629     0.150
    42.821   476.887     0.150
    44.217   488.348     0.150
    44.470   491.199     0.150
    44.660   595.340     0.150
    45.238   497.871     0.150
    45.238   497.547     0.150
    45.573   498.797     0.150
    45.573   498.457     0.150
    46.841   509.094     0.150
    46.841   602.594     0.150
    46.840   509.086     0.150
    46.840   602.586     0.150
    46.778   510.199     0.150
    47.241   514.426     0.150
    50.559   539.027     0.150
    53.450   560.020     0.150
    53.591   561.547     0.150
    53.743   562.859     0.150
    54.404   567.926     0.150
    54.422   567.168     0.150
    54.696   570.387     0.150
    55.109   572.758     0.150
    55.082   573.746     0.150
    55.187   572.832     0.150
    55.238   573.727     0.150
    55.434   574.828     0.150
    55.470   574.746     0.150
    55.786   576.648     0.150
    55.781   577.496     0.150
    55.913   578.348     0.150
    55.947   578.859     0.150
    56.026   579.246     0.150
    56.063   579.367     0.150
    56.118   579.719     0.150
    56.423   581.648     0.150
    56.511   583.348     0.150
    56.511   581.906     0.150
    56.550   582.586     0.150
    56.604   583.477     0.150
    56.645   583.348     0.150
    56.640   583.137     0.150
    56.848   585.078     0.150
    57.261   587.582     0.150
    57.261   587.367     0.150
    57.263   587.617     0.150
    57.386   588.207     0.150
    57.438   588.469     0.150
    57.438   642.199     0.150
    57.438   589.098     0.150
    57.438   642.199     0.150
    57.438   588.348     0.150
    57.443   589.449     0.150
    57.642   590.348     0.150
    57.702   590.188     0.150
    57.697   590.918     0.150
    57.699   590.527     0.150
    57.712   590.227     0.150
    57.824   592.090     0.150
    57.834   591.859     0.150
    57.841   591.047     0.150
    57.844   591.449     0.150
    57.904   592.426     0.150
    58.068   592.926     0.150
    58.324   595.047     0.150
    58.524   596.109     0.150
    58.612   596.809     0.150
    58.975   599.496     0.150
    59.223   600.918     0.150
    59.275   601.648     0.150
    59.275   600.137     0.150
    59.408   602.422     0.150
    59.904   605.547     0.150
    60.124   606.746     0.150
    60.275   609.547     0.150
    60.275   608.348     0.150
    60.453   609.844     0.150
    60.453   609.176     0.150
    62.970   626.059     0.150
    64.254   634.617     0.150
    65.614   644.348     0.150
    65.614   643.547     0.150
    69.278   666.598     0.150
    71.700   680.949     0.150
    76.015   707.348     0.150
    76.015   720.746     0.150
    76.015   878.547     0.150
    76.015   706.949     0.150
    78.793   722.449     0.150
    78.793   722.449     0.150
    79.969   730.746     0.150
    80.879   733.359     0.150
    83.097   746.398     0.150
    83.097   745.648     0.150
    83.472   746.449     0.150
    83.595   748.746     0.150
    83.721   749.398     0.150
    83.722   748.008     0.150
    84.108   751.816     0.150
    84.109   751.547     0.150
    84.109   751.824     0.150
    84.109   750.949     0.150
    85.007   754.746     0.150
    85.134   755.238     0.150
    85.134   755.234     0.150
    85.193   757.090     0.150
    85.193   756.246     0.150
    85.402   755.719     0.150
    85.707   758.449     0.150
    85.707   758.449     0.150
    85.707   957.359     0.150
    85.707   757.547     0.150
    85.905   759.906     0.150
    85.905   759.047     0.150
    86.107   761.746     0.150
    86.409   763.148     0.150
    86.753   764.906     0.150
    87.203   765.246     0.150
    90.438   781.824     0.150
    90.459   781.348     0.150
    90.459   995.348     0.150
    90.891   784.559     0.150
    90.969   782.246     0.150
    90.969  1000.168     0.150
    90.969   782.246     0.150
    90.969  1000.168     0.150
    91.075   784.797     0.150
    91.161   786.324     0.150
    91.187   785.438     0.150
    91.522   784.055     0.150
    92.018   788.328     0.150
    92.018   788.328     0.150
    92.353   791.047     0.150
    92.353   790.129     0.150
    92.510   790.848     0.150
    92.637   790.758     0.150
    92.642   792.176     0.150
    92.625   792.047     0.150
    92.657   791.996     0.150
    92.858   793.047     0.150
    93.033   791.020     0.150
    93.641   794.910     0.150
    93.850   797.184     0.150
    93.861   797.250     0.150
    94.974   802.496     0.150
    95.992   804.949     0.150
    96.613   810.020     0.150
    99.245   820.355     0.150
    99.245  1062.285     0.150
    99.245   820.359     0.150
    99.245  1062.289     0.150
    99.340   822.246     0.150
    99.340  1063.547     0.150
   108.889  1137.938     0.150
   108.889  1137.941     0.150
   109.438  1139.758     0.150
   109.442  1139.754     0.150
   109.939  1135.336     0.150
   110.233  1143.848     0.150
   112.768  1116.246     0.150
   112.859  1116.547     0.150
   115.744  1120.848     0.150
   116.686  1123.547     0.150
   116.686  1122.957     0.150
   116.686  1188.496     0.150
   116.686  1756.316     0.150
   116.686  1122.961     0.150
   116.686  1188.496     0.150
   116.686  1756.324     0.150
   116.686  1123.547     0.150
   119.005  1128.949     0.150
   119.314  1128.648     0.150
   119.314  1142.648     0.150
   120.620  1133.148     0.150
   121.204  1132.648     0.150
   121.204  1146.648     0.150
   121.300  1132.746     0.150
   121.726  1134.277     0.150
   121.929  1134.648     0.150
   122.900  1136.148     0.150
   122.900  1150.246     0.150
   122.886  1136.348     0.150
   123.710  1137.246     0.150
   123.834  1138.348     0.150
   125.435  1141.297     0.150
   127.415  1145.309     0.150
   127.499  1143.348     0.150
   127.979  1145.734     0.150
   127.979  1145.598     0.150
   128.224  1146.672     0.150
   128.581  1148.766     0.150
   128.832  1148.488     0.150
   128.832  1148.449     0.150
   128.843  1148.598     0.150
   128.843  1148.598     0.150
   129.523  1149.898     0.150
   129.523  1149.547     0.150
   129.975  1149.949     0.150
   129.975  1164.648     0.150
   129.975  1286.348     0.150
   132.969  1154.746     0.150
   140.479  1170.496     0.150
   140.479  1170.496     0.150
   140.479  1169.449     0.150
   145.315  1178.168     0.150
   145.958  1179.348     0.150
   148.378  1187.949     0.150
   148.429  1182.949     0.150
   150.263  1191.270     0.150
   151.660  1194.770     0.150
   153.328  1191.148     0.150
   153.328  1198.648     0.150
   155.257  1193.699     0.150
   155.257  1203.309     0.150
     0.215     6.000     0.150
     0.215     9.871     0.150
     0.285     6.980     0.150
     0.285    11.191     0.150
     1.481    26.523     0.150
     1.646    28.891     0.150
     1.674    29.543     0.150
     1.674    52.230     0.150
     1.526    26.141     0.150
     1.526    47.832     0.150
     1.937    55.742     0.150
     2.266    36.750     0.150
     2.654    45.730     0.150
     2.654    83.262     0.150
     3.063    48.680     0.150
     3.063    93.801     0.150
     3.034    50.832     0.150
     3.034    94.680     0.150
     3.034    48.941     0.150
     3.234    51.633     0.150
     3.234   101.031     0.150
     3.616    61.871     0.150
     3.616   114.660     0.150
     3.972    68.402     0.150
     3.972   127.180     0.150
     4.543    74.031     0.150
     4.543   141.371     0.150
     4.377    69.902     0.150
     4.377   126.242     0.150
     5.001    74.422     0.150
     5.001   128.445     0.150
     5.001   156.348     0.150
     5.001   154.680     0.150
     5.406   160.402     0.150
     6.366    93.293     0.150
     7.656   111.660     0.150
     9.443   136.352     0.150
     9.443   297.977     0.150
    11.719   166.324     0.150
    11.719   299.848     0.150
    11.719   166.531     0.150
    12.667   182.203     0.150
    12.889   184.113     0.150
    12.889   184.602     0.150
    12.888   184.488     0.150
    12.888   415.352     0.150
    12.888   184.133     0.150
    13.610   196.363     0.150
    15.304   221.121     0.150
    15.304   220.250     0.150
    15.580   222.387     0.150
    15.580   220.391     0.150
    15.682   226.102     0.150
    15.682   222.871     0.150
    15.750   225.207     0.150
    15.750   224.312     0.150
    15.719   227.930     0.150
    16.084   228.422     0.150
    16.084   231.613     0.150
    16.734   237.121     0.150
    17.129   243.176     0.150
    17.129   242.453     0.150
    17.255   240.551     0.150
    17.255   240.660     0.150
    17.628   245.000     0.150
    17.893   248.863     0.150
    17.893   247.801     0.150
    17.944   248.730     0.150
    18.054   250.836     0.150
    18.054   250.621     0.150
    18.205   251.453     0.150
    18.235   254.492     0.150
    18.215   255.434     0.150
    18.215   254.531     0.150
    18.351   255.453     0.150
    18.604   256.805     0.150
    18.604   255.820     0.150
    18.770   258.164     0.150
    18.770   257.641     0.150
    18.935   262.195     0.150
    18.935   603.121     0.150
    18.935   262.852     0.150
    18.935   261.352     0.150
    18.983   263.922     0.150
    19.160   263.977     0.150
    19.160   262.523     0.150
    19.191   262.570     0.150
    19.406   267.027     0.150
    19.406   265.242     0.150
    19.474   267.340     0.150
    19.474   266.543     0.150
    19.535   267.922     0.150
    19.587   267.426     0.150
    19.587   266.820     0.150
    19.682   268.230     0.150
    20.021   273.160     0.150
    20.021   271.672     0.150
    20.151   271.980     0.150
    20.163   275.734     0.150
    20.163   275.070     0.150
    20.285   274.590     0.150
    20.269   277.180     0.150
    20.449   279.742     0.150
    20.504   277.441     0.150
    20.504   276.332     0.150
    20.561   279.512     0.150
    20.605   281.098     0.150
    20.605   280.062     0.150
    20.624   280.301     0.150
    20.766   278.980     0.150
    20.772   280.152     0.150
    20.772   279.910     0.150
    20.915   287.223     0.150
    20.922   281.000     0.150
    20.966   281.652     0.150
    20.966   280.961     0.150
    20.981   285.352     0.150
    20.981   280.820     0.150
    21.040   283.422     0.150
    21.040   282.070     0.150
    20.931   283.980     0.150
    21.049   282.652     0.150
    21.081   282.613     0.150
    21.108   283.113     0.150
    21.108   282.703     0.150
    21.239   284.891     0.150
    21.169   288.168     0.150
    21.169   284.961     0.150
    21.270   284.473     0.150
    21.297   285.203     0.150
    21.279   289.027     0.150
    21.279   288.480     0.150
    21.414   286.070     0.150
    21.437   287.258     0.150
    21.391   288.918     0.150
    21.391   287.711     0.150
    21.406   290.336     0.150
    21.424   289.961     0.150
    21.587   288.984     0.150
    21.495   291.211     0.150
    21.655   288.512     0.150
    21.633   291.316     0.150
    21.730   289.531     0.150
    21.798   291.000     0.150
    21.729   294.301     0.150
    21.763   294.426     0.150
    21.889   291.250     0.150
    21.773   293.672     0.150
    21.914   291.480     0.150
    21.949   293.312     0.150
    21.924   292.840     0.150
    21.956   291.801     0.150
    21.993   293.160     0.150
    22.028   294.297     0.150
    21.925   296.129     0.150
    21.986   295.230     0.150
    22.117   293.082     0.150
    22.117   293.340     0.150
    22.156   296.961     0.150
    22.254   295.262     0.150
    22.254   294.543     0.150
    22.229   297.094     0.150
    22.229   295.832     0.150
    22.271   294.840     0.150
    22.275   296.758     0.150
    22.275   295.043     0.150
    22.310   295.562     0.150
    22.339   298.738     0.150
    22.339   296.113     0.150
    22.284   299.523     0.150
    22.284   300.590     0.150
    22.284   298.562     0.150
    22.406   298.867     0.150
    22.291   299.934     0.150
    22.333   298.621     0.150
    22.549   300.953     0.150
    22.552   299.891     0.150
    22.552   298.582     0.150
    22.509   299.531     0.150
    22.573   301.117     0.150
    22.510   300.031     0.150
    22.578   300.152     0.150
    22.578   298.293     0.150
    22.719   300.430     0.150
    22.745   299.633     0.150
    22.771   300.602     0.150
    22.702   301.871     0.150
    22.713   302.180     0.150
    22.675   303.879     0.150
    22.747   302.523     0.150
    22.759   302.152     0.150
    22.839   303.367     0.150
    22.719   303.688     0.150
    22.775   302.602     0.150
    22.794   303.230     0.150
    22.814   303.113     0.150
    22.819   303.223     0.150
    22.893   301.754     0.150
    22.903   305.043     0.150
    22.848   303.352     0.150
    22.925   301.320     0.150
    22.864   303.430     0.150
    22.945   304.152     0.150
    23.051   304.910     0.150
    23.058   307.594     0.150
    23.091   305.020     0.150
    23.024   305.332     0.150
    23.080   305.910     0.150
    23.058   306.633     0.150
    23.153   304.371     0.150
    23.153   303.930     0.150
    23.172   306.441     0.150
    23.185   305.250     0.150
    23.083   308.117     0.150
    23.242   307.590     0.150
    23.242   306.051     0.150
    23.206   308.613     0.150
    23.238   308.340     0.150
    23.402   308.891     0.150
    23.400   307.402     0.150
    23.305   310.828     0.150
    23.403   309.504     0.150
    23.403   308.812     0.150
    23.346   310.785     0.150
    23.543   309.883     0.150
    23.543   309.082     0.150
    23.603   309.531     0.150
    23.652   311.336     0.150
    23.727   312.262     0.150
    23.733   310.371     0.150
    23.744   310.598     0.150
    23.743   310.363     0.150
    23.659   313.512     0.150
    23.749   312.660     0.150
    23.669   313.391     0.150
    23.759   312.566     0.150
    23.691   314.344     0.150
    23.691   313.352     0.150
    23.739   314.141     0.150
    23.730   313.312     0.150
    23.710   313.910     0.150
    23.842   315.754     0.150
    23.967   312.781     0.150
    23.967   312.273     0.150
    23.977   313.035     0.150
    23.977   312.582     0.150
    23.977   313.066     0.150
    23.978   314.605     0.150
    24.013   315.371     0.150
    24.061   315.973     0.150
    24.108   315.570     0.150
    24.155   316.539     0.150
    24.075   316.453     0.150
    24.078   317.531     0.150
    24.209   316.160     0.150
    24.210   317.758     0.150
    24.210   317.242     0.150
    24.233   316.766     0.150
    24.235   315.801     0.150
    24.239   315.340     0.150
    24.251   316.281     0.150
    24.272   316.793     0.150
    24.285   318.016     0.150
    24.285   316.293     0.150
    24.264   318.102     0.150
    24.293   319.262     0.150
    24.293   317.711     0.150
    24.316   320.293     0.150
    24.411   319.242     0.150
    24.412   319.762     0.150
    24.510   319.555     0.150
    24.526   319.438     0.150
    24.526   318.352     0.150
    24.531   319.879     0.150
    24.542   318.949     0.150
    24.542   318.391     0.150
    24.543   319.230     0.150
    24.526   320.641     0.150
    24.526   320.121     0.150
    24.591   320.727     0.150
    24.571   320.031     0.150
    24.630   319.570     0.150
    24.631   320.273     0.150
    24.640   320.605     0.150
    24.624   323.133     0.150
    24.624   322.633     0.150
    24.622   322.980     0.150
    24.779   321.602     0.150
    24.779   320.953     0.150
    24.855   322.812     0.150
    24.774   323.133     0.150
    24.746   324.668     0.150
    24.840   322.512     0.150
    24.968   323.148     0.150
    24.987   322.621     0.150
    24.903   325.426     0.150
    24.903   324.883     0.150
    25.034   325.211     0.150
    25.034   323.391     0.150
    25.057   325.102     0.150
    25.232   325.242     0.150
    25.239   324.953     0.150
    25.248   325.543     0.150
    25.248   324.641     0.150
    25.201   326.660     0.150
    25.185   326.883     0.150
    25.191   328.379     0.150
    25.334   327.051     0.150
    25.334   325.852     0.150
    25.337   326.438     0.150
    25.337   325.750     0.150
    25.227   328.340     0.150
    25.349   326.637     0.150
    25.358   326.848     0.150
    25.358   325.852     0.150
    25.369   326.879     0.150
    25.395   327.445     0.150
    25.446   327.055     0.150
    25.446   326.641     0.150
    25.454   328.480     0.150
    25.454   327.410     0.150
    25.480   327.449     0.150
    25.397   330.270     0.150
    25.397   329.180     0.150
    25.384   330.234     0.150
    25.537   329.582     0.150
    25.609   329.312     0.150
    25.609   328.602     0.150
    25.609   329.816     0.150
    25.609   327.453     0.150
    25.630   329.277     0.150
    25.647   330.230     0.150
    25.582   332.266     0.150
    25.701   329.031     0.150
    25.733   330.090     0.150
    25.733   329.742     0.150
    25.800   330.926     0.150
    25.855   330.785     0.150
    25.782   332.691     0.150
    25.782   331.602     0.150
    25.882   331.926     0.150
    25.977   332.516     0.150
    26.005   332.480     0.150
    26.051   332.930     0.150
    26.092   332.820     0.150
    26.131   333.809     0.150
    26.011   334.211     0.150
    26.164   334.551     0.150
    26.115   333.863     0.150
    26.222   334.672     0.150
    26.295   335.047     0.150
    26.295   334.512     0.150
    26.312   334.879     0.150
    26.353   335.488     0.150
    26.333   337.457     0.150
    26.333   335.672     0.150
    26.462   337.055     0.150
    26.538   337.012     0.150
    26.538   336.180     0.150
    26.569   338.141     0.150
    26.569   336.801     0.150
    26.501   338.133     0.150
    26.605   337.535     0.150
    26.605   336.801     0.150
    26.656   338.352     0.150
    26.656   336.980     0.150
    26.576   339.762     0.150
    26.582   339.191     0.150
    26.705   339.152     0.150
    26.705   338.230     0.150
    26.633   338.773     0.150
    26.720   338.625     0.150
    26.736   339.742     0.150
    26.736   338.910     0.150
    26.639   340.281     0.150
    26.787   339.344     0.150
    26.835   340.594     0.150
    26.847   340.656     0.150
    26.807   342.441     0.150
    26.807   544.363     0.150
    26.807   342.441     0.150
    26.807   544.359     0.150
    26.807   342.160     0.150
    26.830   344.051     0.150
    27.006   342.359     0.150
    27.011   342.500     0.150
    27.015   341.461     0.150
    27.015   340.523     0.150
    27.020   341.242     0.150
    27.000   342.965     0.150
    27.000   341.703     0.150
    27.024   341.273     0.150
    27.024   340.742     0.150
    27.033   341.449     0.150
    27.033   340.230     0.150
    27.084   342.645     0.150
    27.103   342.855     0.150
    27.107   342.836     0.150
    26.994   345.762     0.150
    27.102   344.336     0.150
    27.102   343.523     0.150
    27.102   343.660     0.150
    27.102   543.812     0.150
    27.102   343.402     0.150
    27.102   543.809     0.150
    27.102   342.863     0.150
    27.070   344.523     0.150
    27.073   344.051     0.150
    27.164   344.023     0.150
    27.272   344.520     0.150
    27.171   345.262     0.150
    27.277   343.207     0.150
    27.208   345.070     0.150
    27.301   343.328     0.150
    27.305   344.734     0.150
    27.321   346.672     0.150
    27.342   345.156     0.150
    27.427   346.941     0.150
    27.418   347.992     0.150
    27.548   346.480     0.150
    27.464   348.391     0.150
    27.601   346.215     0.150
    27.657   348.020     0.150
    27.657   347.590     0.150
    27.662   347.336     0.150
    27.662   346.793     0.150
    27.670   348.188     0.150
    27.556   350.051     0.150
    27.684   347.121     0.150
    27.684   346.832     0.150
    27.751   347.730     0.150
    27.654   349.402     0.150
    27.772   347.797     0.150
    27.776   350.219     0.150
    27.776   349.141     0.150
    27.710   349.902     0.150
    27.862   349.172     0.150
    27.822   350.473     0.150
    27.929   349.496     0.150
    27.929   348.551     0.150
    27.961   350.555     0.150
    27.961   349.250     0.150
    28.001   351.172     0.150
    27.976   353.141     0.150
    28.118   351.121     0.150
    28.118   350.832     0.150
    28.067   352.402     0.150
    28.146   352.762     0.150
    28.147   353.453     0.150
    28.226   353.410     0.150
    28.165   353.961     0.150
    28.228   351.910     0.150
    28.289   353.781     0.150
    28.289   352.602     0.150
    28.304   354.203     0.150
    28.329   354.730     0.150
    28.329   547.531     0.150
    28.397   354.664     0.150
    28.319   356.391     0.150
    28.430   354.199     0.150
    28.573   356.504     0.150
    28.520   355.773     0.150
    28.611   354.852     0.150
    28.628   357.641     0.150
    28.693   357.418     0.150
    28.709   357.922     0.150
    28.709   356.820     0.150
    28.730   357.148     0.150
    28.730   356.062     0.150
    28.620   358.453     0.150
    28.822   357.047     0.150
    28.878   358.797     0.150
    28.983   359.668     0.150
    28.983   357.832     0.150
    29.046   359.910     0.150
    29.046   359.301     0.150
    28.945   361.562     0.150
    29.000   360.250     0.150
    29.140   361.484     0.150
    29.227   362.961     0.150
    29.277   361.246     0.150
    29.181   363.402     0.150
    29.257   363.383     0.150
    29.257   362.812     0.150
    29.469   365.500     0.150
    29.672   365.867     0.150
    29.869   367.086     0.150
    29.869   365.523     0.150
    29.914   367.559     0.150
    29.914   367.430     0.150
    29.850   369.633     0.150
    29.921   369.723     0.150
    30.058   370.891     0.150
    30.058   368.012     0.150
    30.080   369.551     0.150
    30.023   371.629     0.150
    30.137   368.996     0.150
    30.246   369.965     0.150
    30.246   369.551     0.150
    30.279   372.852     0.150
    30.279   372.340     0.150
    30.382   371.934     0.150
    30.333   372.562     0.150
    30.520   372.781     0.150
    30.428   373.340     0.150
    30.540   373.371     0.150
    30.649   373.461     0.150
    30.649   372.703     0.150
    30.673   373.926     0.150
    30.673   373.191     0.150
    30.718   374.590     0.150
    30.722   374.816     0.150
    30.772   374.484     0.150
    30.807   375.543     0.150
    30.985   376.754     0.150
    30.985   376.203     0.150
    30.955   376.531     0.150
    31.187   378.293     0.150
    31.108   380.516     0.150
    31.267   379.836     0.150
    31.194   380.211     0.150
    31.441   380.984     0.150
    31.441   380.262     0.150
    31.361   381.664     0.150
    31.480   382.320     0.150
    31.594   382.715     0.150
    31.594   381.492     0.150
    31.640   382.535     0.150
    31.640   382.191     0.150
    31.752   384.570     0.150
    31.828   384.270     0.150
    31.846   383.523     0.150
    31.905   385.938     0.150
    31.905   383.172     0.150
    31.923   388.051     0.150
    32.054   386.277     0.150
    32.071   385.422     0.150
    32.057   387.684     0.150
    32.057   386.812     0.150
    32.123   387.762     0.150
    32.123   387.211     0.150
    32.257   389.066     0.150
    32.387   388.746     0.150
    32.398   390.172     0.150
    32.512   390.312     0.150
    32.498   391.402     0.150
    32.621   391.414     0.150
    32.654   392.426     0.150
    32.981   393.277     0.150
    32.981   393.570     0.150
    33.037   393.992     0.150
    32.986   395.352     0.150
    33.084   394.848     0.150
    33.162   396.602     0.150
    33.224   396.879     0.150
    33.175   399.172     0.150
    33.262   398.992     0.150
    33.395   397.871     0.150
    33.463   401.941     0.150
    33.530   398.426     0.150
    33.530   399.242     0.150
    33.570   400.824     0.150
    33.806   404.934     0.150
    33.940   402.289     0.150
    33.998   403.551     0.150
    33.942   403.320     0.150
    34.028   406.727     0.150
    34.074   404.570     0.150
    34.220   403.840     0.150
    34.222   404.875     0.150
    34.314   405.656     0.150
    34.330   406.242     0.150
    34.330   562.715     0.150
    34.330   407.773     0.150
    34.330   406.891     0.150
    34.329   407.762     0.150
    34.466   408.148     0.150
    34.718   408.734     0.150
    34.789   412.102     0.150
    34.875   410.730     0.150
    34.856   412.301     0.150
    35.138   413.316     0.150
    35.182   414.031     0.150
    35.471   415.070     0.150
    36.016   422.629     0.150
    36.213   424.914     0.150
    36.171   423.320     0.150
    36.357   422.410     0.150
    36.863   426.531     0.150
    36.781   428.863     0.150
    37.257   429.551     0.150
    37.550   433.523     0.150
    37.615   435.570     0.150
    37.615   434.750     0.150
    37.867   436.621     0.150
    38.703   443.652     0.150
    39.219   447.980     0.150
    39.519   450.352     0.150
    39.642   451.332     0.150
    41.329   465.461     0.150
    45.556   502.375     0.150
    45.751   500.676     0.150
    45.751   500.781     0.150
    46.756   508.129     0.150
    46.756   507.812     0.150
    46.756   508.133     0.150
    46.822   509.121     0.150
    47.072   513.500     0.150
    51.653   546.551     0.150
    53.425   561.160     0.150
    53.549   561.691     0.150
    53.872   565.133     0.150
    54.214   567.121     0.150
    54.260   566.211     0.150
    54.434   568.113     0.150
    54.729   570.941     0.150
    54.907   572.172     0.150
    55.046   572.590     0.150
    55.046   571.902     0.150
    55.058   572.762     0.150
    55.308   574.000     0.150
    55.605   576.703     0.150
    55.664   575.953     0.150
    55.729   577.531     0.150
    55.774   578.312     0.150
    55.851   579.012     0.150
    56.074   579.543     0.150
    56.225   580.820     0.150
    56.333   581.840     0.150
    56.385   582.391     0.150
    56.401   582.543     0.150
    56.444   582.512     0.150
    56.449   582.531     0.150
    56.451   581.801     0.150
    56.512   583.102     0.150
    57.058   587.000     0.150
    57.084   587.203     0.150
    57.084   586.922     0.150
    57.219   588.242     0.150
    57.256   588.121     0.150
    57.264   587.941     0.150
    57.264   587.902     0.150
    57.264   587.660     0.150
    57.457   589.613     0.150
    57.482   590.000     0.150
    57.524   589.133     0.150
    57.533   590.062     0.150
    57.631   590.840     0.150
    57.651   591.289     0.150
    57.835   592.293     0.150
    57.847   592.113     0.150
    57.885   592.211     0.150
    57.955   591.027     0.150
    57.955   591.441     0.150
    57.951   593.230     0.150
    58.065   593.750     0.150
    58.133   594.113     0.150
    58.327   595.691     0.150
    58.426   595.902     0.150
    58.528   596.512     0.150
    58.796   598.633     0.150
    59.008   599.473     0.150
    59.740   605.551     0.150
    59.516  1096.500     0.150
    60.300   609.203     0.150
    60.356   608.453     0.150
    60.658   610.801     0.150
    63.489   631.926     0.150
    78.860   722.141     0.150
    78.860   722.145     0.150
    83.840   750.352     0.150
    83.842   750.352     0.150
    84.046   750.516     0.150
    85.318   756.863     0.150
    85.318   756.867     0.150
    85.818   759.383     0.150
    85.818   759.379     0.150
    91.124   783.871     0.150
    91.124   783.875     0.150
    92.184   789.863     0.150
    92.269   790.480     0.150
    92.269   790.484     0.150
    93.084   794.551     0.150
    97.221   813.391     0.150
    97.225   813.387     0.150
   115.541  1125.203     0.150
   118.731  1130.102     0.150
   119.253  1131.301     0.150
   121.058  1136.301     0.150
   121.829  1135.195     0.150
   122.719  1134.500     0.150
   122.508  1136.277     0.150
   123.849  1141.301     0.150
   127.298  1145.801     0.150
   128.424  1147.980     0.150
   128.424  1147.977     0.150
   140.259  1169.980     0.150
   140.259  1169.980     0.150
     0.292     9.250     0.150
     0.292    15.695     0.150
     0.292    15.555     0.150
     0.397    10.109     0.150
     0.397    17.109     0.150
     0.397    16.930     0.150
     0.827    16.016     0.150
     0.827    26.672     0.150
     0.791    15.359     0.150
     0.791    26.109     0.150
     1.197    21.250     0.150
     1.197    36.602     0.150
     1.306    23.336     0.150
     1.268    22.492     0.150
     1.268    38.305     0.150
     1.268    39.289     0.150
     1.400    25.570     0.150
     1.400    39.602     0.150
     1.584    26.727     0.150
     1.839    30.172     0.150
     1.839    50.352     0.150
     1.816    31.961     0.150
     1.816    54.352     0.150
     2.012    33.680     0.150
     2.019    34.000     0.150
     2.019    57.664     0.150
     2.229    35.836     0.150
     2.249    36.875     0.150
     2.858    44.695     0.150
     2.858    86.383     0.150
     2.793    47.609     0.150
     2.793    84.750     0.150
     2.793    44.266     0.150
     3.494    52.820     0.150
     3.494    92.000     0.150
    12.601   180.156     0.150
    12.601   320.453     0.150
    18.658   256.906     0.150
    18.759   257.383     0.150
    19.502   266.570     0.150
    19.878   268.383     0.150
    20.062   272.609     0.150
    20.100   270.805     0.150
    20.294   274.984     0.150
    20.950   282.875     0.150
    21.090   282.945     0.150
    22.842   302.477     0.150
    23.097   303.352     0.150
    23.438   308.742     0.150
    23.758   311.086     0.150
    24.010   313.391     0.150
    24.785   320.992     0.150
    26.555   337.703     0.150
    26.632   338.633     0.150
    26.632   337.742     0.150
    26.820   338.516     0.150
    26.820   337.961     0.150
    26.988   341.281     0.150
    30.510   372.000     0.150
    46.442   503.164     0.150
    55.375   571.055     0.150
    57.017   583.688     0.150
     0.626    13.809     0.150
     0.626    22.617     0.150
     0.553    11.246     0.150
     0.553    18.238     0.150
     1.187    22.246     0.150
     1.187    35.035     0.150
     1.422    26.168     0.150
     1.422    42.855     0.150
     1.422    26.285     0.150
     1.422    45.648     0.150
     1.627    28.336     0.150
     1.627    48.238     0.150
     1.621    28.547     0.150
     1.621    46.617     0.150
     1.958    33.535     0.150
     1.822    30.125     0.150
     1.822    50.309     0.150
     2.148    36.875     0.150
     2.148    62.445     0.150
     2.180    37.047     0.150
     2.180    63.828     0.150
     2.216    36.625     0.150
     2.216    64.156     0.150
     2.220    37.855     0.150
     2.561    41.887     0.150
     2.560    41.738     0.150
     2.637    41.465     0.150
     2.637    83.285     0.150
     2.638    42.738     0.150
     2.638    43.086     0.150
     2.766    86.797     0.150
     2.850    45.715     0.150
     2.925    46.926     0.150
     2.925    83.258     0.150
     2.906    47.738     0.150
     2.939    47.598     0.150
     3.004    52.258     0.150
     3.140    51.977     0.150
     3.140    94.527     0.150
     3.161    56.488     0.150
     3.161    91.828     0.150
     3.221    54.777     0.150
     3.210    53.336     0.150
     3.662    57.156     0.150
     3.662    95.738     0.150
     3.729   100.266     0.150
     3.990    66.578     0.150
     3.990   109.906     0.150
     4.362    61.406     0.150
     4.362   127.809     0.150
     4.249    66.438     0.150
     4.249   120.527     0.150
     4.438    70.086     0.150
     4.438   123.496     0.150
     4.704    69.656     0.150
     4.704   122.758     0.150
     4.704   147.258     0.150
     4.704    71.105     0.150
     4.537    72.945     0.150
     4.537   128.746     0.150
     4.669    73.238     0.150
     5.747    84.828     0.150
     6.318    91.668     0.150
     6.318   166.715     0.150
     6.391    95.488     0.150
     6.542    97.758     0.150
     7.350   107.918     0.150
     8.088   119.336     0.150
     9.499   137.648     0.150
    10.311   149.688     0.150
    11.516   167.926     0.150
    13.030   187.762     0.150
    13.030   424.223     0.150
    13.030   186.547     0.150
    13.031   185.465     0.150
    13.031   185.316     0.150
    14.120   200.387     0.150
    14.120   208.262     0.150
    15.328   215.637     0.150
    15.328   221.707     0.150
    15.298   218.035     0.150
    15.615   219.316     0.150
    15.659   219.285     0.150
    15.778   227.332     0.150
    15.813   221.867     0.150
    16.071   225.285     0.150
    15.958   225.488     0.150
    16.675   233.527     0.150
    16.802   233.215     0.150
    16.892   235.867     0.150
    17.007   239.348     0.150
    16.938   240.309     0.150
    17.309   243.707     0.150
    17.364   241.637     0.150
    17.364   244.934     0.150
    17.549   242.836     0.150
    17.607   245.047     0.150
    17.609   246.641     0.150
    17.870   248.508     0.150
    17.911   248.246     0.150
    17.944   249.426     0.150
    18.392   255.996     0.150
    18.427   257.734     0.150
    18.427   257.238     0.150
    18.582   255.367     0.150
    18.582   256.188     0.150
    18.562   256.586     0.150
    18.738   257.445     0.150
    18.889   260.727     0.150
    19.144   264.168     0.150
    19.144   262.945     0.150
    19.086   263.309     0.150
    19.086   264.242     0.150
    19.294   263.996     0.150
    19.312   265.027     0.150
    19.419   266.293     0.150
    19.499   266.605     0.150
    19.506   265.398     0.150
    19.544   266.867     0.150
    19.571   267.527     0.150
    19.749   268.777     0.150
    19.911   271.969     0.150
    19.911   270.797     0.150
    19.944   271.488     0.150
    19.991   270.008     0.150
    19.919   273.938     0.150
    20.031   272.465     0.150
    20.142   273.016     0.150
    20.196   273.938     0.150
    20.253   274.945     0.150
    20.294   273.625     0.150
    20.302   274.727     0.150
    20.301   274.816     0.150
    20.404   277.398     0.150
    20.347   278.516     0.150
    20.482   277.086     0.150
    20.482   277.359     0.150
    20.356   278.637     0.150
    20.536   278.047     0.150
    20.598   277.777     0.150
    20.472   278.406     0.150
    20.725   280.707     0.150
    20.725   281.992     0.150
    20.858   280.836     0.150
    20.906   279.398     0.150
    20.966   281.996     0.150
    20.843   283.547     0.150
    21.011   282.605     0.150
    21.115   283.578     0.150
    21.214   284.977     0.150
    21.167   288.250     0.150
    21.167   287.988     0.150
    21.390   284.836     0.150
    21.364   288.766     0.150
    21.364   290.426     0.150
    21.521   289.547     0.150
    21.521   290.078     0.150
    21.609   288.996     0.150
    21.632   289.527     0.150
    21.804   290.887     0.150
    21.845   291.527     0.150
    21.719   294.086     0.150
    21.794   293.227     0.150
    21.794   293.102     0.150
    21.825   293.961     0.150
    22.040   293.695     0.150
    22.040   294.293     0.150
    22.146   294.727     0.150
    22.173   295.242     0.150
    22.173   295.957     0.150
    22.165   294.746     0.150
    22.170   294.926     0.150
    22.224   296.059     0.150
    22.156   298.348     0.150
    22.202   299.059     0.150
    22.325   297.496     0.150
    22.471   298.008     0.150
    22.459   298.348     0.150
    22.448   297.965     0.150
    22.522   298.957     0.150
    22.530   301.387     0.150
    22.680   300.777     0.150
    22.528   302.148     0.150
    22.526   302.457     0.150
    22.526   302.047     0.150
    22.706   300.176     0.150
    22.905   306.320     0.150
    23.074   304.078     0.150
    23.076   304.488     0.150
    23.124   304.309     0.150
    23.219   307.898     0.150
    23.255   309.316     0.150
    23.253   311.270     0.150
    23.433   308.148     0.150
    23.465   308.547     0.150
    23.316   311.324     0.150
    23.397   310.445     0.150
    23.438   310.867     0.150
    23.606   310.598     0.150
    23.528   310.426     0.150
    23.528   310.867     0.150
    23.629   309.805     0.150
    23.629   310.586     0.150
    23.678   309.617     0.150
    23.532   312.879     0.150
    23.685   309.637     0.150
    23.862   312.105     0.150
    23.856   315.477     0.150
    23.855   314.887     0.150
    23.938   315.945     0.150
    23.946   315.828     0.150
    24.106   315.117     0.150
    24.136   315.938     0.150
    24.163   315.258     0.150
    24.068   317.320     0.150
    24.182   317.426     0.150
    24.300   316.848     0.150
    24.259   318.715     0.150
    24.417   318.285     0.150
    24.417   319.020     0.150
    24.467   319.105     0.150
    24.467   319.625     0.150
    24.320   319.918     0.150
    24.505   318.105     0.150
    24.439   320.824     0.150
    24.643   321.035     0.150
    24.627   319.836     0.150
    24.581   320.648     0.150
    24.552   322.695     0.150
    24.650   321.977     0.150
    24.601   321.605     0.150
    24.807   324.504     0.150
    24.844   324.496     0.150
    24.844   325.105     0.150
    24.959   324.125     0.150
    24.970   324.926     0.150
    25.101   323.477     0.150
    25.203   325.945     0.150
    25.237   325.086     0.150
    25.142   326.535     0.150
    25.142   327.820     0.150
    25.212   326.926     0.150
    25.390   326.375     0.150
    25.464   326.668     0.150
    25.374   328.457     0.150
    25.479   330.125     0.150
    25.460   330.492     0.150
    25.470   331.215     0.150
    25.606   330.707     0.150
    25.606   331.848     0.150
    25.625   332.434     0.150
    25.809   331.348     0.150
    26.031   332.367     0.150
    25.963   332.918     0.150
    25.963   334.652     0.150
    25.984   335.492     0.150
    26.233   333.648     0.150
    26.283   334.246     0.150
    26.202   335.836     0.150
    26.541   337.008     0.150
    26.610   337.207     0.150
    26.610   338.746     0.150
    26.632   335.418     0.150
    26.773   341.016     0.150
    26.733   342.746     0.150
    26.938   339.867     0.150
    26.942   340.008     0.150
    26.962   340.688     0.150
    27.039   342.285     0.150
    26.912   343.867     0.150
    27.138   343.445     0.150
    27.004   344.227     0.150
    27.029   345.160     0.150
    27.249   344.137     0.150
    27.249   345.375     0.150
    27.326   343.617     0.150
    27.249   344.816     0.150
    27.249   345.387     0.150
    27.292   346.508     0.150
    27.337   345.746     0.150
    27.401   348.082     0.150
    27.401   346.559     0.150
    27.538   344.336     0.150
    27.389   346.898     0.150
    27.679   348.648     0.150
    27.831   349.117     0.150
    27.691   350.285     0.150
    27.934   351.707     0.150
    28.024   351.418     0.150
    28.155   352.809     0.150
    28.220   353.648     0.150
    28.201   355.336     0.150
    28.316   354.625     0.150
    28.681   357.000     0.150
    28.977   359.238     0.150
    29.394   363.918     0.150
    29.394   364.680     0.150
    29.448   362.707     0.150
    29.472   364.188     0.150
    29.480   364.828     0.150
    29.480   365.746     0.150
    29.800   366.867     0.150
    29.755   366.426     0.150
    29.794   368.328     0.150
    29.880   368.875     0.150
    30.082   369.977     0.150
    30.118   370.477     0.150
    30.261   372.348     0.150
    30.335   371.328     0.150
    30.335   372.254     0.150
    30.425   372.441     0.150
    30.430   372.809     0.150
    30.430   374.020     0.150
    31.020   378.250     0.150
    31.020   377.535     0.150
    31.328   382.648     0.150
    31.371   381.547     0.150
    31.512   383.207     0.150
    31.664   384.176     0.150
    31.749   384.477     0.150
    31.848   385.098     0.150
    31.882   385.055     0.150
    31.951   387.027     0.150
    32.198   388.516     0.150
    32.254   388.816     0.150
    32.254   390.281     0.150
    32.540   391.504     0.150
    32.636   391.688     0.150
    32.527   393.535     0.150
    32.577   392.258     0.150
    32.689   392.965     0.150
    33.044   395.797     0.150
    33.112   395.570     0.150
    33.396   401.207     0.150
    33.572   398.711     0.150
    33.478   400.945     0.150
    33.638   401.766     0.150
    34.111   404.637     0.150
    34.202   405.363     0.150
    34.344   407.812     0.150
    34.226   408.500     0.150
    34.499   409.293     0.150
    34.499   408.305     0.150
    34.505   408.598     0.150
    34.541   410.379     0.150
    34.978   413.758     0.150
    35.052   414.258     0.150
    35.674   419.465     0.150
    36.213   424.164     0.150
    37.489   433.484     0.150
    37.945   437.156     0.150
    39.402   450.160     0.150
    45.678   499.488     0.150
    45.678   500.137     0.150
    46.872   509.762     0.150
    54.427   568.008     0.150
    54.610   569.137     0.150
    54.623   569.508     0.150
    54.623   570.316     0.150
    55.311   575.527     0.150
    55.475   575.035     0.150
    55.475   575.312     0.150
    55.782   578.168     0.150
    55.805   577.938     0.150
    55.805   577.586     0.150
    55.805   577.723     0.150
    55.911   578.977     0.150
    55.911   579.258     0.150
    55.949   579.066     0.150
    55.949     8.480     0.150
    56.637   583.723     0.150
    57.108   587.105     0.150
    57.389   589.809     0.150
    57.389   589.594     0.150
    57.440   588.965     0.150
    57.440     8.352     0.150
    57.440   589.586     0.150
    57.440   589.105     0.150
    57.440     8.621     0.150
    57.440   590.297     0.150
    57.440     6.711     0.150
    57.687   591.617     0.150
    57.687     7.941     0.150
    57.825   592.207     0.150
    58.531   596.777     0.150
    58.531     8.750     0.150
    58.531   597.285     0.150
    58.975   600.027     0.150
    58.975   600.359     0.150
    59.908   608.008     0.150
    60.461   611.156     0.150
    83.088   747.160     0.150
    83.855   750.336     0.150
    84.076   751.746     0.150
    85.796   758.910     0.150
    85.926   759.805     0.150
    85.926   759.598     0.150
    85.926     9.168     0.150
   128.705  1148.836     0.150
   128.705  1149.059     0.150
   129.383  1149.500     0.150
     0.087     6.789     0.150
     0.087    11.270     0.150
     0.087    11.137     0.150
     0.514    11.449     0.150
     0.514    19.066     0.150
     0.863    15.727     0.150
     0.863    26.777     0.150
     1.062    19.520     0.150
     1.062    31.969     0.150
     1.062    33.289     0.150
     1.217    21.449     0.150
     1.217    36.906     0.150
     1.217    22.289     0.150
     1.338    22.859     0.150
     1.338    39.598     0.150
     1.345    22.969     0.150
     1.345    39.156     0.150
     1.675    27.617     0.150
     1.675    47.238     0.150
     1.743    28.719     0.150
     1.743    49.078     0.150
     1.896    31.668     0.150
     1.896    52.930     0.150
     1.896    54.930     0.150
     1.990    32.668     0.150
     1.990    56.148     0.150
     2.207    35.559     0.150
     2.251    35.609     0.150
     2.251    62.879     0.150
     2.313    38.258     0.150
     2.364    38.316     0.150
     2.364    71.098     0.150
     2.582    42.590     0.150
     2.629    40.770     0.150
     2.695    42.379     0.150
     2.742    42.609     0.150
     2.742    79.488     0.150
     2.946    49.039     0.150
     2.946    86.930     0.150
     2.946    45.949     0.150
     3.286    52.879     0.150
     3.286    87.977     0.150
     3.655    54.719     0.150
     3.655    98.699     0.150
     3.683    59.258     0.150
     3.683    98.707     0.150
     3.969    63.840     0.150
     3.969   105.328     0.150
     4.314    67.020     0.150
     4.314   113.750     0.150
     4.394    68.418     0.150
     4.394   115.977     0.150
     4.554    70.328     0.150
     4.554   120.008     0.150
     4.635    68.723     0.150
     4.635   145.574     0.150
     4.801    71.609     0.150
     5.481    83.758     0.150
     5.481   144.289     0.150
     5.598   145.340     0.150
     6.271    92.418     0.150
     7.319   106.598     0.150
    12.736   180.957     0.150
    12.736   180.309     0.150
    12.736   183.078     0.150
    12.736   180.738     0.150
    13.796   194.547     0.150
    15.337   215.789     0.150
    15.447   217.539     0.150
    15.757   220.598     0.150
    15.853   223.621     0.150
    16.350   228.898     0.150
    16.685   233.418     0.150
    17.037   237.809     0.150
    17.055   238.359     0.150
    17.293   239.699     0.150
    17.590   244.918     0.150
    17.884   247.840     0.150
    18.105   251.238     0.150
    18.228   251.617     0.150
    18.260   251.648     0.150
    18.796   266.922     0.150
    18.796   258.930     0.150
    18.821   258.469     0.150
    18.988   259.629     0.150
    19.218   262.449     0.150
    19.220   262.277     0.150
    19.327   264.328     0.150
    19.614   266.590     0.150
    19.932   269.969     0.150
    19.978   270.457     0.150
    20.216   273.418     0.150
    20.420   276.219     0.150
    20.561   274.957     0.150
    20.659   277.066     0.150
    21.103   284.066     0.150
    21.220   284.758     0.150
    21.508   287.098     0.150
    21.509   287.406     0.150
    21.731   288.629     0.150
    21.860   289.168     0.150
    21.870   289.047     0.150
    22.012   292.258     0.150
    22.137   293.508     0.150
    22.173   293.789     0.150
    22.995   303.789     0.150
    23.137   304.848     0.150
    23.335   304.473     0.150
    23.335   305.430     0.150
    23.568   308.578     0.150
    23.872   311.359     0.150
    23.902   313.449     0.150
    24.146   314.906     0.150
    24.300   316.969     0.150
    24.917   320.668     0.150
    24.936   320.879     0.150
    24.923   320.668     0.150
    25.042   322.879     0.150
    25.369   326.258     0.150
    25.924   330.500     0.150
    26.147   332.668     0.150
    26.247   334.020     0.150
    26.301   333.117     0.150
    26.490   336.250     0.150
    26.648   337.039     0.150
    26.715   338.590     0.150
    26.791   341.227     0.150
    26.955   340.316     0.150
    26.955   340.879     0.150
    26.955     8.098     0.150
    26.955   340.289     0.150
    26.955   340.430     0.150
    27.246   343.008     0.150
    28.025   349.227     0.150
    30.131   367.816     0.150
    31.304   377.816     0.150
    45.368   494.805     0.150
    45.368   495.609     0.150
    45.482   498.078     0.150
    46.965   512.805     0.150
    55.508   572.602     0.150
    55.508     9.102     0.150
    57.162   585.680     0.150
    57.162     9.449     0.150
   128.824  1146.352     0.150
   129.526  1147.531     0.150
     0.406    10.219     0.150
     0.406    16.562     0.150
     0.697    14.172     0.150
     0.697    24.070     0.150
     0.710    14.242     0.150
     0.710    24.031     0.150
     0.710    14.523     0.150
     0.941    17.344     0.150
     0.920    17.070     0.150
     0.920    29.391     0.150
     0.924    17.719     0.150
     0.924    30.266     0.150
     1.152    21.500     0.150
     1.152    37.625     0.150
     1.183    21.430     0.150
     1.226    22.453     0.150
     1.286    22.250     0.150
     1.286    37.500     0.150
     1.326    24.102     0.150
     1.392    24.664     0.150
     1.392    44.102     0.150
     1.948    31.883     0.150
     1.948    55.266     0.150
     1.917    32.602     0.150
     1.917    56.680     0.150
     2.078    34.891     0.150
     2.078    59.555     0.150
     2.104    35.734     0.150
     2.112    36.016     0.150
     2.112    60.070     0.150
     2.097    34.609     0.150
     2.097    61.133     0.150
     2.117    34.891     0.150
     2.117    62.133     0.150
     2.135    36.305     0.150
     2.389    39.016     0.150
     2.389    39.359     0.150
     2.441    40.844     0.150
     2.514    39.930     0.150
     2.675    70.805     0.150
     2.645    42.836     0.150
     2.947    46.641     0.150
     2.940    46.766     0.150
     3.157    50.070     0.150
     3.345    51.836     0.150
     3.345    90.281     0.150
     3.469    55.195     0.150
     3.469    95.305     0.150
     3.469    55.352     0.150
     3.654    53.836     0.150
     3.872    58.234     0.150
     3.872   101.555     0.150
     3.872   123.531     0.150
     3.872    58.953     0.150
     3.878    61.109     0.150
     3.878   107.719     0.150
     4.422    66.086     0.150
     4.422   116.883     0.150
     4.435    67.391     0.150
     4.435   118.133     0.150
     4.422    67.820     0.150
     5.019   136.844     0.150
     5.049    76.945     0.150
     5.049   135.680     0.150
     5.111    79.242     0.150
     5.296    80.062     0.150
     5.561    84.336     0.150
     5.561   147.656     0.150
     5.617    84.109     0.150
     5.617   143.766     0.150
     5.969    89.844     0.150
     6.100    89.203     0.150
     6.345    91.891     0.150
     6.543    97.352     0.150
     6.543    97.133     0.150
     6.735    98.711     0.150
     6.735    99.891     0.150
     7.316   106.422     0.150
     7.366   108.641     0.150
     7.640   192.695     0.150
     7.935   114.211     0.150
     7.935   202.703     0.150
     8.364   120.586     0.150
     8.364   212.109     0.150
     8.364   265.438     0.150
     8.673   124.719     0.150
     9.394   138.250     0.150
     9.394   242.109     0.150
     9.528   137.742     0.150
     9.554   137.469     0.150
     9.897   139.336     0.150
    10.070   148.352     0.150
    10.070   256.086     0.150
    10.599   151.781     0.150
    10.969   160.383     0.150
    10.969   275.375     0.150
    11.339   162.523     0.150
    11.570   167.172     0.150
    11.593   167.070     0.150
    11.595   166.820     0.150
    11.637   167.930     0.150
    11.745   168.875     0.150
    12.228   177.492     0.150
    12.624   180.242     0.150
    12.819   186.773     0.150
    13.082   186.844     0.150
    13.082   186.055     0.150
    13.081   186.375     0.150
    13.081   416.672     0.150
    13.081   186.516     0.150
    13.257   186.711     0.150
    13.503   190.711     0.150
    13.503   191.445     0.150
    13.582   192.945     0.150
    13.836   195.055     0.150
    13.836   349.445     0.150
    13.836   194.172     0.150
    14.204   201.555     0.150
    14.345   203.156     0.150
    14.626   210.242     0.150
    14.730   209.539     0.150
    14.711   206.461     0.150
    14.921   211.633     0.150
    15.045   210.797     0.150
    15.045   391.953     0.150
    15.100   215.711     0.150
    15.100   215.195     0.150
    15.252   215.430     0.150
    15.255   212.594     0.150
    15.255   212.875     0.150
    15.261   213.242     0.150
    15.576   216.203     0.150
    15.630   218.336     0.150
    15.630   403.352     0.150
    15.630   218.203     0.150
    15.820   223.016     0.150
    15.820   405.852     0.150
    15.820   222.156     0.150
    15.965   224.492     0.150
    16.062   223.516     0.150
    16.269   229.594     0.150
    16.257   225.781     0.150
    16.292   231.945     0.150
    16.391   228.164     0.150
    16.633   232.055     0.150
    16.635   231.180     0.150
    16.762   230.695     0.150
    16.979   237.672     0.150
    17.014   235.328     0.150
    17.014   433.102     0.150
    17.014   233.891     0.150
    17.065   238.062     0.150
    17.054   234.953     0.150
    17.105   237.766     0.150
    17.106   236.023     0.150
    17.161   239.766     0.150
    17.161   434.422     0.150
    17.182   241.023     0.150
    17.307   239.859     0.150
    17.307   438.789     0.150
    17.307   240.109     0.150
    17.471   244.508     0.150
    17.471   243.891     0.150
    17.479   241.289     0.150
    17.616   242.250     0.150
    17.718   248.344     0.150
    17.726   244.016     0.150
    17.726   244.375     0.150
    17.726   447.570     0.150
    17.768   249.336     0.150
    17.768   247.383     0.150
    17.819   243.477     0.150
    17.819   449.961     0.150
    17.819   244.125     0.150
    17.863   246.289     0.150
    17.998   247.094     0.150
    18.040   248.781     0.150
    18.040   455.422     0.150
    18.040   248.281     0.150
    18.098   248.992     0.150
    18.088   248.531     0.150
    18.177   249.812     0.150
    18.177   249.664     0.150
    18.177   454.250     0.150
    18.232   250.414     0.150
    18.294   250.992     0.150
    18.308   250.695     0.150
    18.308   251.133     0.150
    18.439   254.242     0.150
    18.448   253.516     0.150
    18.480   255.812     0.150
    18.511   256.312     0.150
    18.511   256.719     0.150
    18.612   256.742     0.150
    18.621   254.719     0.150
    18.679   255.234     0.150
    18.693   259.211     0.150
    18.693   258.797     0.150
    18.693   469.711     0.150
    18.753   257.023     0.150
    18.753   469.539     0.150
    18.753   257.562     0.150
    18.827   257.539     0.150
    18.848   258.375     0.150
    18.867   256.125     0.150
    18.920   257.656     0.150
    19.008   258.953     0.150
    19.029   258.633     0.150
    19.100   260.805     0.150
    19.100   475.336     0.150
    19.100   259.016     0.150
    19.114   260.828     0.150
    19.114   474.523     0.150
    19.154   262.805     0.150
    19.154   607.906     0.150
    19.154   263.609     0.150
    19.154   263.320     0.150
    19.154   478.984     0.150
    19.154   263.453     0.150
    19.213   261.602     0.150
    19.257   262.219     0.150
    19.272   262.781     0.150
    19.363   263.219     0.150
    19.471   264.086     0.150
    19.506   264.461     0.150
    19.545   268.555     0.150
    19.545   486.133     0.150
    19.589   265.609     0.150
    19.768   267.594     0.150
    19.797   267.781     0.150
    19.802   268.070     0.150
    19.821   268.266     0.150
    19.837   267.930     0.150
    19.857   266.094     0.150
    19.951   270.344     0.150
    19.958   269.523     0.150
    20.013   269.805     0.150
    20.037   270.641     0.150
    20.053   270.836     0.150
    20.067   271.070     0.150
    20.067   492.844     0.150
    20.067   271.484     0.150
    20.077   271.195     0.150
    20.077   492.586     0.150
    20.077   270.789     0.150
    20.125   273.805     0.150
    20.108   274.523     0.150
    20.114   271.836     0.150
    20.113   271.625     0.150
    20.120   271.062     0.150
    20.119   271.016     0.150
    20.152   272.312     0.150
    20.162   272.023     0.150
    20.013   274.453     0.150
    20.222   273.852     0.150
    20.227   273.445     0.150
    20.253   273.734     0.150
    20.256   273.023     0.150
    20.252   272.711     0.150
    20.267   273.094     0.150
    20.296   274.289     0.150
    20.435   275.852     0.150
    20.435   276.609     0.150
    20.419   274.883     0.150
    20.433   274.289     0.150
    20.481   276.109     0.150
    20.516   278.992     0.150
    20.516   509.562     0.150
    20.516   278.859     0.150
    20.539   276.844     0.150
    20.689   280.969     0.150
    20.696   279.984     0.150
    20.696   510.641     0.150
    20.696   279.539     0.150
    20.705   280.969     0.150
    20.726   279.102     0.150
    20.730   278.133     0.150
    20.846   278.734     0.150
    20.978   280.891     0.150
    21.054   281.883     0.150
    21.069   280.914     0.150
    21.099   282.266     0.150
    21.111   281.953     0.150
    21.128   285.391     0.150
    21.145   282.461     0.150
    21.167   282.562     0.150
    21.200   282.883     0.150
    21.254   283.016     0.150
    21.289   283.789     0.150
    21.333   284.062     0.150
    21.377   286.680     0.150
    21.405   285.805     0.150
    21.404   285.211     0.150
    21.504   286.305     0.150
    21.506   285.516     0.150
    21.506   285.750     0.150
    21.506   522.820     0.150
    21.513   285.914     0.150
    21.513   286.664     0.150
    21.513   522.586     0.150
    21.518   288.812     0.150
    21.518   290.016     0.150
    21.518   528.945     0.150
    21.520   288.734     0.150
    21.520   526.500     0.150
    21.520   287.891     0.150
    21.572   290.680     0.150
    21.572   529.594     0.150
    21.572   290.523     0.150
    21.583   286.594     0.150
    21.604   286.133     0.150
    21.606   288.086     0.150
    21.805   289.812     0.150
    21.805   290.078     0.150
    21.805   527.062     0.150
    21.864   292.797     0.150
    21.872   289.562     0.150
    21.890   292.734     0.150
    21.890   532.547     0.150
    21.890   291.914     0.150
    21.900   292.805     0.150
    21.971   290.719     0.150
    21.989   292.422     0.150
    22.023   294.625     0.150
    22.023   538.969     0.150
    22.040   295.375     0.150
    22.040   537.984     0.150
    22.040   295.250     0.150
    22.040   539.883     0.150
    22.060   291.781     0.150
    22.077   292.781     0.150
    22.094   291.609     0.150
    22.094   292.180     0.150
    22.094   532.484     0.150
    22.115   292.703     0.150
    22.173   292.656     0.150
    22.173   534.656     0.150
    22.173   292.422     0.150
    22.227   294.992     0.150
    22.227   538.477     0.150
    22.227   295.289     0.150
    22.258   293.109     0.150
    22.306   298.430     0.150
    22.314   297.906     0.150
    22.314   542.766     0.150
    22.361   294.531     0.150
    22.393   295.000     0.150
    22.397   299.203     0.150
    22.419   298.406     0.150
    22.466   296.719     0.150
    22.482   299.586     0.150
    22.486   299.945     0.150
    22.486   546.484     0.150
    22.500   296.266     0.150
    22.540   296.695     0.150
    22.560   301.289     0.150
    22.608   299.328     0.150
    22.608   546.203     0.150
    22.631   301.500     0.150
    22.631   548.977     0.150
    22.713   298.383     0.150
    22.742   302.594     0.150
    22.785   300.664     0.150
    22.785   300.875     0.150
    22.808   300.211     0.150
    22.802   300.312     0.150
    22.828   300.430     0.150
    22.833   303.688     0.150
    22.833   552.898     0.150
    22.833   302.516     0.150
    22.880   303.914     0.150
    22.880   553.539     0.150
    22.889   304.391     0.150
    22.889   553.023     0.150
    22.896   304.234     0.150
    22.896   722.383     0.150
    22.896   304.344     0.150
    22.896   553.328     0.150
    22.918   300.711     0.150
    22.966   302.305     0.150
    23.012   302.734     0.150
    23.012   302.375     0.150
    23.087   302.031     0.150
    23.231   307.461     0.150
    23.231   560.078     0.150
    23.246   304.695     0.150
    23.244   305.719     0.150
    23.293   303.492     0.150
    23.342   305.227     0.150
    23.342   556.484     0.150
    23.342   305.633     0.150
    23.349   308.750     0.150
    23.349   560.844     0.150
    23.432   306.414     0.150
    23.468   309.312     0.150
    23.477   307.156     0.150
    23.509   308.711     0.150
    23.509   309.117     0.150
    23.509   560.961     0.150
    23.532   308.391     0.150
    23.537   307.234     0.150
    23.562   307.602     0.150
    23.589   309.805     0.150
    23.617   311.305     0.150
    23.617   567.055     0.150
    23.655   312.984     0.150
    23.655   566.547     0.150
    23.661   310.789     0.150
    23.692   308.680     0.150
    23.790   310.562     0.150
    23.811   309.992     0.150
    23.811   564.945     0.150
    23.811   311.133     0.150
    23.838   314.234     0.150
    23.838   568.445     0.150
    23.848   313.211     0.150
    23.848   570.312     0.150
    23.934   311.211     0.150
    23.934   311.062     0.150
    23.934   566.703     0.150
    23.983   311.594     0.150
    23.983   567.992     0.150
    23.983   312.172     0.150
    24.007   312.102     0.150
    24.009   315.555     0.150
    24.009   572.406     0.150
    24.065   314.656     0.150
    24.034   315.211     0.150
    24.057   312.312     0.150
    24.057   574.398     0.150
    24.062   315.391     0.150
    24.072   313.992     0.150
    24.072   314.672     0.150
    24.079   315.664     0.150
    24.079   573.492     0.150
    24.121   314.516     0.150
    24.121   316.156     0.150
    24.124   316.414     0.150
    24.124   573.383     0.150
    24.153   316.375     0.150
    24.163   314.234     0.150
    24.178   314.250     0.150
    24.222   316.281     0.150
    24.261   316.109     0.150
    24.261   318.047     0.150
    24.261   573.844     0.150
    24.275   314.359     0.150
    24.298   316.711     0.150
    24.301   316.609     0.150
    24.345   316.672     0.150
    24.374   317.969     0.150
    24.380   318.969     0.150
    24.380   579.070     0.150
    24.394   315.969     0.150
    24.394   316.125     0.150
    24.428   318.516     0.150
    24.436   318.594     0.150
    24.458   316.352     0.150
    24.486   318.898     0.150
    24.486   584.578     0.150
    24.486   318.562     0.150
    24.492   320.141     0.150
    24.492   580.930     0.150
    24.553   317.234     0.150
    24.585   319.180     0.150
    24.629   318.469     0.150
    24.624   319.906     0.150
    24.630   319.781     0.150
    24.630   585.188     0.150
    24.649   318.359     0.150
    24.657   317.516     0.150
    24.655   584.156     0.150
    24.655   320.055     0.150
    24.661   319.984     0.150
    24.688   320.773     0.150
    24.688   582.219     0.150
    24.693   317.734     0.150
    24.701   317.344     0.150
    24.699   320.766     0.150
    24.718   320.961     0.150
    24.743   319.820     0.150
    24.763   321.062     0.150
    24.789   319.945     0.150
    24.794   319.703     0.150
    24.801   320.070     0.150
    24.808   321.719     0.150
    24.823   319.953     0.150
    24.849   318.984     0.150
    24.855   322.031     0.150
    24.901   324.062     0.150
    24.980   322.922     0.150
    24.968   321.023     0.150
    24.968   584.602     0.150
    24.970   324.305     0.150
    24.970   589.547     0.150
    24.970   323.914     0.150
    25.039   321.953     0.150
    25.115   322.266     0.150
    25.118   325.359     0.150
    25.118   586.742     0.150
    25.175   326.328     0.150
    25.175   590.547     0.150
    25.202   322.805     0.150
    25.177   324.172     0.150
    25.186   326.133     0.150
    25.186   588.648     0.150
    25.300   325.633     0.150
    25.286   325.750     0.150
    25.337   322.984     0.150
    25.362   324.820     0.150
    25.367   328.734     0.150
    25.367   593.789     0.150
    25.378   324.883     0.150
    25.523   326.086     0.150
    25.498   329.516     0.150
    25.498   596.336     0.150
    25.500   328.211     0.150
    25.500   329.375     0.150
    25.500   597.727     0.150
    25.505   327.836     0.150
    25.508   325.789     0.150
    25.508   592.102     0.150
    25.508   325.922     0.150
    25.625   328.594     0.150
    25.599   327.922     0.150
    25.621   329.180     0.150
    25.673   329.016     0.150
    25.691   327.805     0.150
    25.691   594.133     0.150
    25.691   327.570     0.150
    25.772   330.266     0.150
    25.794   600.594     0.150
    25.839   332.539     0.150
    25.839   603.195     0.150
    25.852   331.445     0.150
    25.852   604.891     0.150
    25.875   329.641     0.150
    25.896   328.539     0.150
    25.922   330.352     0.150
    25.951   331.453     0.150
    25.971   330.711     0.150
    25.971   331.195     0.150
    25.971   602.156     0.150
    25.990   334.102     0.150
    25.997   330.742     0.150
    26.121   333.414     0.150
    26.121   334.602     0.150
    26.121   334.469     0.150
    26.125   332.289     0.150
    26.104   333.336     0.150
    26.106   330.266     0.150
    26.117   333.516     0.150
    26.117   334.336     0.150
    26.117   605.750     0.150
    26.172   334.711     0.150
    26.139   333.156     0.150
    26.155   333.734     0.150
    26.155   331.266     0.150
    26.157   331.203     0.150
    26.213   331.523     0.150
    26.221   335.930     0.150
    26.329   337.195     0.150
    26.307   335.141     0.150
    26.307   610.516     0.150
    26.362   336.969     0.150
    26.332   333.641     0.150
    26.362   333.094     0.150
    26.362   334.625     0.150
    26.373   333.336     0.150
    26.420   335.586     0.150
    26.419   334.180     0.150
    26.419   334.625     0.150
    26.391   335.945     0.150
    26.399   333.844     0.150
    26.435   335.828     0.150
    26.435   336.281     0.150
    26.483   337.211     0.150
    26.455   333.391     0.150
    26.495   332.453     0.150
    26.485   336.812     0.150
    26.487   337.664     0.150
    26.487   611.594     0.150
    26.563   340.414     0.150
    26.540   334.992     0.150
    26.600   336.781     0.150
    26.598   338.000     0.150
    26.598   336.680     0.150
    26.643   338.773     0.150
    26.791   339.070     0.150
    26.781   337.453     0.150
    26.826   339.352     0.150
    26.867   337.945     0.150
    26.867   339.039     0.150
    26.894   340.211     0.150
    26.878   339.922     0.150
    26.912   339.422     0.150
    26.929   339.039     0.150
    26.929   342.414     0.150
    26.923   339.141     0.150
    26.925   338.492     0.150
    26.927   338.812     0.150
    26.927   339.875     0.150
    26.935   340.609     0.150
    27.017   339.617     0.150
    27.059   340.336     0.150
    27.080   340.383     0.150
    27.184   344.445     0.150
    27.183   341.594     0.150
    27.195   344.156     0.150
    27.227   340.922     0.150
    27.237   338.922     0.150
    27.325   346.203     0.150
    27.296   345.180     0.150
    27.295   344.000     0.150
    27.295   343.430     0.150
    27.295   343.609     0.150
    27.295   342.922     0.150
    27.295   542.016     0.150
    27.295   343.156     0.150
    27.307   343.992     0.150
    27.325   343.992     0.150
    27.325   544.016     0.150
    27.325   860.336     0.150
    27.325   344.680     0.150
    27.392   344.023     0.150
    27.418   343.305     0.150
    27.439   343.609     0.150
    27.439   345.062     0.150
    27.471   344.352     0.150
    27.465   345.211     0.150
    27.568   346.602     0.150
    27.587   347.852     0.150
    27.596   346.516     0.150
    27.596   543.641     0.150
    27.596   873.094     0.150
    27.596   346.836     0.150
    27.669   348.211     0.150
    27.757   345.820     0.150
    27.758   347.719     0.150
    27.774   346.250     0.150
    27.844   346.664     0.150
    27.845   347.555     0.150
    27.845   347.070     0.150
    27.851   347.039     0.150
    27.953   348.070     0.150
    28.044   351.109     0.150
    28.071   349.719     0.150
    28.071   349.484     0.150
    28.105   350.820     0.150
    28.221   352.141     0.150
    28.234   352.875     0.150
    28.265   352.609     0.150
    28.282   352.281     0.150
    28.367   353.039     0.150
    28.374   353.219     0.150
    28.396   351.812     0.150
    28.396   351.492     0.150
    28.456   352.516     0.150
    28.456   352.164     0.150
    28.459   352.234     0.150
    28.509   354.125     0.150
    28.505   354.469     0.150
    28.524   354.719     0.150
    28.540   353.742     0.150
    28.687   357.008     0.150
    28.687   356.211     0.150
    28.687   354.383     0.150
    28.664   354.289     0.150
    28.664   353.672     0.150
    28.678   357.109     0.150
    28.704   356.555     0.150
    28.787   357.969     0.150
    28.799   355.273     0.150
    28.829   354.789     0.150
    28.827   357.883     0.150
    28.832   357.156     0.150
    28.888   358.172     0.150
    28.899   356.156     0.150
    28.917   357.375     0.150
    28.986   357.031     0.150
    29.029   361.094     0.150
    29.031   356.969     0.150
    29.031   358.836     0.150
    29.068   356.805     0.150
    29.082   359.633     0.150
    29.082   359.773     0.150
    29.168   358.039     0.150
    29.177   357.469     0.150
    29.184   359.055     0.150
    29.184   358.250     0.150
    29.188   358.492     0.150
    29.189   361.211     0.150
    29.267   359.461     0.150
    29.283   361.945     0.150
    29.356   362.602     0.150
    29.405   362.773     0.150
    29.408   361.953     0.150
    29.408   361.492     0.150
    29.443   359.883     0.150
    29.444   363.133     0.150
    29.521   363.664     0.150
    29.562   362.133     0.150
    29.562   363.406     0.150
    29.586   362.695     0.150
    29.613   363.711     0.150
    29.613   364.414     0.150
    29.729   366.211     0.150
    29.796   367.492     0.150
    29.807   364.820     0.150
    29.807   364.180     0.150
    29.880   365.062     0.150
    29.880   364.859     0.150
    29.892   367.016     0.150
    29.898   367.273     0.150
    29.971   366.203     0.150
    30.048   365.914     0.150
    30.041   368.133     0.150
    30.116   366.305     0.150
    30.133   368.875     0.150
    30.151   366.555     0.150
    30.152   366.742     0.150
    30.161   371.375     0.150
    30.169   368.289     0.150
    30.168   370.031     0.150
    30.196   368.445     0.150
    30.199   367.883     0.150
    30.208   368.172     0.150
    30.276   369.016     0.150
    30.276   368.734     0.150
    30.294   368.922     0.150
    30.294   367.789     0.150
    30.446   373.469     0.150
    30.475   370.797     0.150
    30.475   371.453     0.150
    30.484   371.414     0.150
    30.484   371.992     0.150
    30.486   372.414     0.150
    30.564   373.125     0.150
    30.565   373.234     0.150
    30.576   371.805     0.150
    30.710   373.406     0.150
    30.758   371.094     0.150
    30.851   374.555     0.150
    30.829   373.062     0.150
    30.829   373.219     0.150
    30.933   376.320     0.150
    30.984   374.211     0.150
    31.044   377.367     0.150
    31.070   374.664     0.150
    31.130   378.539     0.150
    31.146   375.531     0.150
    31.146   375.859     0.150
    31.172   377.109     0.150
    31.191   378.102     0.150
    31.257   377.836     0.150
    31.257   549.336     0.150
    31.257   377.992     0.150
    31.236   377.711     0.150
    31.341   378.023     0.150
    31.383   378.281     0.150
    31.375   378.398     0.150
    31.375   377.492     0.150
    31.404   376.391     0.150
    31.528   379.680     0.150
    31.509   380.609     0.150
    31.520   379.234     0.150
    31.520   379.469     0.150
    31.529   380.758     0.150
    31.557   381.219     0.150
    31.589   378.969     0.150
    31.608   382.594     0.150
    31.614   382.578     0.150
    31.625   379.773     0.150
    31.665   381.266     0.150
    31.741   382.336     0.150
    31.741   382.641     0.150
    31.761   381.422     0.150
    31.787   381.812     0.150
    31.828   383.211     0.150
    31.894   383.664     0.150
    31.924   382.836     0.150
    32.031   383.945     0.150
    32.044   386.094     0.150
    32.047   384.516     0.150
    32.164   384.680     0.150
    32.162   386.664     0.150
    32.166   386.258     0.150
    32.166   387.039     0.150
    32.254   387.109     0.150
    32.254   385.789     0.150
    32.250   386.828     0.150
    32.250   386.641     0.150
    32.259   386.781     0.150
    32.297   387.828     0.150
    32.297   387.523     0.150
    32.351   386.383     0.150
    32.383   389.148     0.150
    32.418   388.703     0.150
    32.570   391.086     0.150
    32.615   391.805     0.150
    32.683   389.539     0.150
    32.693   390.711     0.150
    32.723   391.000     0.150
    32.785   390.562     0.150
    32.783   392.586     0.150
    32.790   392.070     0.150
    32.825   393.156     0.150
    32.833   391.555     0.150
    32.872   393.219     0.150
    33.111   393.789     0.150
    33.205   395.852     0.150
    33.214   396.945     0.150
    33.218   395.594     0.150
    33.224   396.781     0.150
    33.319   395.016     0.150
    33.341   396.477     0.150
    33.481   395.219     0.150
    33.528   397.344     0.150
    33.588   396.586     0.150
    33.590   398.180     0.150
    33.684   400.086     0.150
    33.705   400.641     0.150
    33.730   396.211     0.150
    33.749   400.906     0.150
    33.766   401.102     0.150
    33.876   400.641     0.150
    33.882   402.961     0.150
    33.891   400.047     0.150
    33.919   402.844     0.150
    33.973   401.312     0.150
    33.993   402.812     0.150
    34.029   402.766     0.150
    34.087   402.336     0.150
    34.098   404.070     0.150
    34.259   405.141     0.150
    34.278   404.094     0.150
    34.280   404.125     0.150
    34.294   405.273     0.150
    34.355   407.516     0.150
    34.364   404.953     0.150
    34.564   406.508     0.150
    34.612   407.109     0.150
    34.612   407.297     0.150
    34.641   408.344     0.150
    34.785   409.180     0.150
    34.912   410.445     0.150
    35.017   410.836     0.150
    35.155   413.531     0.150
    35.300   413.477     0.150
    35.447   415.578     0.150
    35.469   413.594     0.150
    35.482   413.891     0.150
    35.532   417.023     0.150
    35.503   414.883     0.150
    35.539   415.102     0.150
    35.563   414.844     0.150
    35.683   419.734     0.150
    35.683   417.680     0.150
    35.666   418.016     0.150
    35.723   414.641     0.150
    35.773   418.070     0.150
    35.900   418.719     0.150
    35.921   420.055     0.150
    36.007   420.906     0.150
    36.030   419.312     0.150
    36.091   420.906     0.150
    36.091   421.609     0.150
    36.416   424.719     0.150
    36.417   423.711     0.150
    36.486   423.133     0.150
    36.542   424.391     0.150
    36.664   426.359     0.150
    36.874   426.742     0.150
    36.994   428.680     0.150
    37.152   430.031     0.150
    37.418   431.570     0.150
    37.575   432.500     0.150
    37.784   433.016     0.150
    37.843   435.406     0.150
    37.929   435.211     0.150
    38.302   439.156     0.150
    38.467   439.539     0.150
    38.529   437.812     0.150
    38.869   443.391     0.150
    39.284   446.586     0.150
    40.303   454.625     0.150
    40.409   457.516     0.150
    40.409   456.156     0.150
    41.871   469.555     0.150
    41.871   467.312     0.150
    42.714   476.453     0.150
    43.715   481.414     0.150
    44.401   489.820     0.150
    44.469   491.000     0.150
    44.668   493.586     0.150
    44.855   492.711     0.150
    44.855   494.414     0.150
    44.855   494.609     0.150
    45.144   493.711     0.150
    45.461   499.836     0.150
    46.445   506.266     0.150
    46.460   506.305     0.150
    46.460   507.703     0.150
    46.745   509.109     0.150
    46.788   508.906     0.150
    46.816   506.312     0.150
    47.039   510.211     0.150
    47.361   514.156     0.150
    47.524   514.031     0.150
    47.816   516.781     0.150
    47.845   517.336     0.150
    48.137   517.461     0.150
    48.148   932.312     0.150
    48.248   520.336     0.150
    48.216   519.773     0.150
    48.435   521.414     0.150
    48.435   519.836     0.150
    48.435   521.406     0.150
    48.758   523.609     0.150
    48.867   526.320     0.150
    49.070   524.984     0.150
    49.070   526.711     0.150
    49.070   527.531     0.150
    49.157   526.875     0.150
    49.208   527.969     0.150
    49.267   527.141     0.150
    49.255   528.383     0.150
    49.640   529.031     0.150
    49.637   531.344     0.150
    50.030   533.461     0.150
    50.030   534.719     0.150
    50.442   535.594     0.150
    50.683   539.078     0.150
    50.683   538.250     0.150
    50.759   537.594     0.150
    50.900   540.562     0.150
    51.269   542.602     0.150
    51.569   545.156     0.150
    51.592   546.031     0.150
    51.752   545.297     0.150
    51.752   547.453     0.150
    51.752   545.805     0.150
    52.149   549.336     0.150
    52.255   552.375     0.150
    52.357   550.836     0.150
    52.357   551.086     0.150
    52.512   551.352     0.150
    52.661   552.945     0.150
    52.917   557.086     0.150
    53.090   557.211     0.150
    53.090   558.820     0.150
    53.091   557.891     0.150
    53.114   558.305     0.150
    53.305   559.711     0.150
    53.307   557.844     0.150
    53.344   559.656     0.150
    53.440   561.273     0.150
    53.455   560.156     0.150
    53.460   558.828     0.150
    53.490   560.023     0.150
    53.489   560.359     0.150
    53.493   560.414     0.150
    53.567   561.961     0.150
    53.571   561.312     0.150
    53.594   561.242     0.150
    53.606   560.625     0.150
    53.614   560.391     0.150
    53.662   562.664     0.150
    53.689   560.742     0.150
    53.699   561.219     0.150
    53.717   562.352     0.150
    53.734   562.711     0.150
    53.779   562.039     0.150
    53.883   562.648     0.150
    53.905   562.812     0.150
    53.932   563.414     0.150
    53.977   562.312     0.150
    54.002   561.594     0.150
    54.133   565.352     0.150
    54.215   564.688     0.150
    54.215   565.914     0.150
    54.297   566.289     0.150
    54.334   566.359     0.150
    54.345   565.227     0.150
    54.345   565.906     0.150
    54.398   565.508     0.150
    54.529   566.242     0.150
    54.529   565.562     0.150
    54.560   567.289     0.150
    54.619   568.125     0.150
    54.619   568.422     0.150
    54.718   568.281     0.150
    54.737   567.812     0.150
    54.751   568.586     0.150
    54.751   568.359     0.150
    54.793   569.734     0.150
    54.793   568.703     0.150
    54.871   569.711     0.150
    54.871   570.500     0.150
    54.966   570.711     0.150
    54.966   570.234     0.150
    55.036   570.625     0.150
    55.148   572.203     0.150
    55.113   572.031     0.150
    55.186   572.531     0.150
    55.310   572.594     0.150
    55.284   572.852     0.150
    55.288   572.531     0.150
    55.376   574.281     0.150
    55.439   573.656     0.150
    55.439   573.891     0.150
    55.576   573.586     0.150
    55.610   573.961     0.150
    55.610   573.086     0.150
    55.627   575.289     0.150
    55.714   575.914     0.150
    55.823   574.711     0.150
    55.823   575.445     0.150
    55.867   575.977     0.150
    55.867   577.852     0.150
    55.912   576.766     0.150
    56.057   577.812     0.150
    56.057   578.164     0.150
    56.074   578.227     0.150
    56.074   577.445     0.150
    56.128   577.406     0.150
    56.128   577.945     0.150
    56.191   578.812     0.150
    56.191   578.594     0.150
    56.231   578.133     0.150
    56.276   579.609     0.150
    56.250   578.344     0.150
    56.250   579.406     0.150
    56.257   579.492     0.150
    56.385   580.516     0.150
    56.413   580.359     0.150
    56.413   579.336     0.150
    56.448   580.477     0.150
    56.534   581.820     0.150
    56.591   582.289     0.150
    56.591   581.453     0.150
    56.642   581.016     0.150
    56.670   582.492     0.150
    56.629   582.172     0.150
    56.738   582.727     0.150
    56.753   582.250     0.150
    56.826   585.023     0.150
    56.819   582.516     0.150
    56.819   583.367     0.150
    56.867   584.141     0.150
    56.839   584.359     0.150
    56.839   581.656     0.150
    56.848   582.930     0.150
    56.882   584.172     0.150
    56.882   584.633     0.150
    56.934   583.984     0.150
    56.995   584.414     0.150
    57.037   583.562     0.150
    57.101   585.578     0.150
    57.172   584.977     0.150
    57.172   583.773     0.150
    57.187   585.617     0.150
    57.311   586.320     0.150
    57.393   585.672     0.150
    57.393   585.906     0.150
    57.514   588.773     0.150
    57.499   587.945     0.150
    57.557   589.195     0.150
    57.566   587.109     0.150
    57.566   587.703     0.150
    57.566   587.344     0.150
    57.594   588.711     0.150
    57.611   588.953     0.150
    57.676   589.484     0.150
    57.677   589.023     0.150
    57.677   590.031     0.150
    57.756   590.750     0.150
    57.789   589.609     0.150
    57.789   590.000     0.150
    57.833   589.234     0.150
    57.846   590.250     0.150
    57.887   590.445     0.150
    57.896   590.305     0.150
    57.986   592.086     0.150
    57.948   590.461     0.150
    57.948   590.711     0.150
    57.962   591.492     0.150
    57.970   591.609     0.150
    57.970   591.289     0.150
    57.970   590.211     0.150
    57.973   591.555     0.150
    57.973   590.445     0.150
    58.004   592.195     0.150
    58.152   591.469     0.150
    58.179   592.875     0.150
    58.179   591.945     0.150
    58.211   592.609     0.150
    58.273   593.641     0.150
    58.273   593.469     0.150
    58.305   592.906     0.150
    58.479   594.273     0.150
    58.491   594.586     0.150
    58.491   594.031     0.150
    58.536   595.953     0.150
    58.633   594.719     0.150
    58.661   595.578     0.150
    58.661   595.023     0.150
    58.691   596.352     0.150
    58.691   596.922     0.150
    58.760   596.406     0.150
    58.760   596.219     0.150
    58.881   597.344     0.150
    58.903   595.812     0.150
    58.903   596.844     0.150
    59.028   597.211     0.150
    59.028   598.906     0.150
    59.028   596.766     0.150
    59.111   599.023     0.150
    59.181   599.125     0.150
    59.219   599.938     0.150
    59.249   599.789     0.150
    59.349   601.734     0.150
    59.502   601.664     0.150
    59.516   601.828     0.150
    59.516   601.312     0.150
    59.646   601.859     0.150
    59.646   601.180     0.150
    59.662   602.602     0.150
    59.662   601.133     0.150
    59.746   602.406     0.150
    59.746   603.016     0.150
    60.020   605.906     0.150
    60.011   604.750     0.150
    60.011   604.539     0.150
    60.036   604.555     0.150
    60.036   603.680     0.150
    60.081   605.703     0.150
    60.116   605.125     0.150
    60.123   606.164     0.150
    60.171   606.180     0.150
    60.171   605.242     0.150
    60.301   606.711     0.150
    60.407   608.812     0.150
    60.542   608.508     0.150
    60.542   607.906     0.150
    60.593   610.562     0.150
    60.666   608.625     0.150
    60.794   611.141     0.150
    60.825   611.531     0.150
    61.046   611.656     0.150
    61.351   614.211     0.150
    61.499   616.383     0.150
    61.607   616.055     0.150
    61.654   617.742     0.150
    61.665   616.750     0.150
    61.739   617.164     0.150
    61.739   616.453     0.150
    62.202   620.750     0.150
    62.568   623.570     0.150
    62.598   621.664     0.150
    62.654   622.523     0.150
    63.143   625.891     0.150
    63.143   626.414     0.150
    63.143   627.656     0.150
    63.281   627.055     0.150
    63.409   626.930     0.150
    63.455   630.562     0.150
    63.525   627.695     0.150
    63.668   631.141     0.150
    63.717   631.344     0.150
    63.885   632.031     0.150
    63.919   633.195     0.150
    63.963   630.367     0.150
    63.963   630.812     0.150
    64.107   633.750     0.150
    64.186   634.539     0.150
    64.284   634.352     0.150
    64.281   634.930     0.150
    64.473   636.102     0.150
    64.577   634.938     0.150
    64.665   637.750     0.150
    64.779   637.414     0.150
    64.763   636.492     0.150
    64.775   635.984     0.150
    64.973   637.664     0.150
    65.066   639.500     0.150
    65.066   638.945     0.150
    65.101   639.984     0.150
    65.128   640.469     0.150
    65.277   639.414     0.150
    65.277   639.094     0.150
    65.324   641.055     0.150
    65.692   644.844     0.150
    65.873   646.492     0.150
    66.044   646.492     0.150
    66.050   646.586     0.150
    66.497   649.016     0.150
    66.699   651.055     0.150
    66.736   650.859     0.150
    66.812   651.211     0.150
    66.847   652.023     0.150
    66.926   652.219     0.150
    67.030   653.961     0.150
    67.113   653.961     0.150
    67.269   653.586     0.150
    67.343   654.742     0.150
    67.334   653.562     0.150
    67.599   656.305     0.150
    68.013   659.695     0.150
    68.048   659.789     0.150
    68.218   660.281     0.150
    70.753   673.273     0.150
    71.396   676.109     0.150
    72.217   681.812     0.150
    76.054   705.539     0.150
    76.150   707.711     0.150
    76.150   718.711     0.150
    76.150    15.203     0.150
    76.150  1290.609     0.150
    76.150   705.086     0.150
    77.398   715.109     0.150
    78.522   718.055     0.150
    79.475   724.992     0.150
    79.625   726.516     0.150
    79.625    11.398     0.150
    79.839   738.414     0.150
    80.055   739.211     0.150
    80.054   728.414     0.150
    80.054    11.297     0.150
    80.060   728.016     0.150
    80.060    11.695     0.150
    80.254   729.516     0.150
    80.254    11.594     0.150
    80.254  1337.109     0.150
    80.254  1646.016     0.150
    80.348  1339.344     0.150
    80.348   731.109     0.150
    80.348    10.305     0.150
    80.356   741.414     0.150
    80.449   731.016     0.150
    80.449    11.094     0.150
    80.503   732.211     0.150
    80.503    10.805     0.150
    80.545   732.609     0.150
    80.545    10.102     0.150
    80.589   742.812     0.150
    80.602   730.609     0.150
    80.602    12.102     0.150
    80.723   744.016     0.150
    80.849    12.898     0.150
    80.849  1339.211     0.150
    80.849  1659.711     0.150
    82.124   741.375     0.150
    82.124  1352.445     0.150
    82.846   742.711     0.150
    83.097   743.062     0.150
    83.097   743.305     0.150
    83.097   740.789     0.150
    83.554  1374.344     0.150
    83.891   749.711     0.150
    83.891  1368.312     0.150
    83.891  1703.016     0.150
    83.907   749.344     0.150
    83.907  1371.609     0.150
    84.402   750.812     0.150
    84.402   751.391     0.150
    84.402   750.992     0.150
    84.549   754.016     0.150
    84.549   750.523     0.150
    84.691   753.016     0.150
    84.691   751.812     0.150
    84.839   752.883     0.150
    85.171   765.906     0.150
    85.229   754.516     0.150
    85.229    11.938     0.150
    85.371   754.266     0.150
    85.399   757.414     0.150
    85.563   760.125     0.150
    85.563   768.445     0.150
    85.592   756.914     0.150
    85.592    11.641     0.150
    85.753   756.906     0.150
    85.753   758.852     0.150
    85.753    12.305     0.150
    85.753    16.969     0.150
    85.869   769.750     0.150
    85.921   759.430     0.150
    85.930   758.414     0.150
    85.930   757.094     0.150
    86.192   759.414     0.150
    86.200   756.414     0.150
    86.200  1376.414     0.150
    86.215   759.695     0.150
    86.215    12.406     0.150
    86.297   759.180     0.150
    86.297   761.820     0.150
    86.297    12.055     0.150
    86.311   762.086     0.150
    86.311   772.414     0.150
    86.311   777.406     0.150
    86.659   761.625     0.150
    86.659    11.789     0.150
    88.673   771.984     0.150
    88.673   773.516     0.150
    88.853   774.211     0.150
    88.853  1397.812     0.150
    88.853  1416.812     0.150
    88.853  1766.812     0.150
    89.653   777.141     0.150
    89.653    11.039     0.150
    89.942   776.812     0.150
    89.942    11.602     0.150
    89.942   988.812     0.150
    89.942  1405.812     0.150
    89.942  1432.812     0.150
    89.942  1496.812     0.150
    89.942  1780.812     0.150
    90.120   790.016     0.150
    90.340   780.820     0.150
    90.420   779.609     0.150
    90.567   778.516     0.150
    90.567   779.664     0.150
    90.567   779.430     0.150
    90.611   782.070     0.150
    90.669   781.000     0.150
    90.730   782.781     0.150
    90.904   783.812     0.150
    90.972   784.078     0.150
    91.279   784.312     0.150
    91.279    11.500     0.150
    91.279  1414.211     0.150
    91.279  1802.609     0.150
    91.427   796.414     0.150
    91.427  1414.016     0.150
    91.427  1806.812     0.150
    91.485   783.125     0.150
    91.485  1003.797     0.150
    91.740   786.180     0.150
    91.806   786.609     0.150
    91.922   787.109     0.150
    91.954   785.562     0.150
    91.982   798.609     0.150
    92.154   788.414     0.150
    92.248   800.211     0.150
    92.248  1420.914     0.150
    92.248  1816.711     0.150
    92.286   789.531     0.150
    92.465   789.312     0.150
    92.465    11.602     0.150
    92.465  1009.914     0.150
    92.465  1418.516     0.150
    92.465  1452.812     0.150
    92.465  1821.516     0.150
    92.465   789.031     0.150
    92.923   790.234     0.150
    92.923   792.312     0.150
    92.934   792.016     0.150
    93.093   792.828     0.150
    93.217   793.016     0.150
    93.217   793.812     0.150
    93.305   793.945     0.150
    93.521  1844.414     0.150
    93.786   796.109     0.150
    93.832   794.336     0.150
    93.832  1020.664     0.150
    93.832  1819.266     0.150
    93.832   795.812     0.150
    93.832   795.023     0.150
    94.221   796.312     0.150
    94.349   796.359     0.150
    94.349   795.742     0.150
    95.633   802.211     0.150
    95.633  1031.711     0.150
    95.633  1862.414     0.150
    95.678   802.812     0.150
    95.850   806.109     0.150
    96.109   804.859     0.150
    96.109  1814.086     0.150
    96.109   804.211     0.150
    96.458   807.312     0.150
    96.701   810.016     0.150
    96.775   807.211     0.150
    96.775    10.805     0.150
    96.877   809.680     0.150
    97.431   811.641     0.150
    97.767   811.984     0.150
    98.871   817.711     0.150
    98.871  1057.312     0.150
    98.929   819.812     0.150
    98.929   829.711     0.150
    98.929   836.609     0.150
    98.929  1455.914     0.150
    98.929  1593.414     0.150
   100.320   825.336     0.150
   100.359  1066.109     0.150
   100.359  1931.016     0.150
   100.375   824.914     0.150
   100.998   826.812     0.150
   100.998  1460.812     0.150
   100.998  1614.812     0.150
   104.278  1098.500     0.150
   104.506  1101.680     0.150
   109.331  1134.711     0.150
   109.718  1140.227     0.150
   109.914  1139.336     0.150
   111.651  1112.586     0.150
   111.651  1148.734     0.150
   111.651  1765.234     0.150
   112.608  1112.812     0.150
   112.698  1112.789     0.150
   112.698  1158.812     0.150
   112.883   878.016     0.150
   112.883  1114.109     0.150
   112.883  1162.312     0.150
   112.883  1516.109     0.150
   112.883  2100.312     0.150
   113.419  1115.109     0.150
   115.914  1122.609     0.150
   116.558  1121.516     0.150
   116.558  1182.938     0.150
   118.456  1125.438     0.150
   119.242  1128.211     0.150
   119.306  1129.914     0.150
   120.414  1129.531     0.150
   120.414  1212.984     0.150
   120.414  1127.516     0.150
   121.272  1132.109     0.150
   121.272  1148.609     0.150
   121.272  1225.609     0.150
   121.468  1132.609     0.150
   121.468  1133.109     0.150
   121.709  1131.812     0.150
   122.781  1134.109     0.150
   123.030  1136.109     0.150
   123.030  1147.812     0.150
   123.030  2240.414     0.150
   123.453  1136.500     0.150
   123.565  1135.961     0.150
   123.565  1135.555     0.150
   123.639  1136.609     0.150
   123.639  1149.109     0.150
   123.639  1243.812     0.150
   123.639  1562.109     0.150
   123.639  1649.211     0.150
   123.639  2244.609     0.150
   126.850  1142.016     0.150
   127.646  1143.711     0.150
   127.646  1144.109     0.150
   127.663  1143.609     0.150
   127.875  1146.211     0.150
   128.017  1143.773     0.150
   128.105  1145.812     0.150
   129.538  1148.312     0.150
   129.538  1146.641     0.150
   129.549  1148.141     0.150
   130.224  1148.453     0.150
   130.225  1149.164     0.150
   130.225  1147.766     0.150
   130.207  1149.711     0.150
   131.521  1153.609     0.150
   131.549  1151.336     0.150
   131.948  1153.914     0.150
   132.625  1155.109     0.150
   133.164  1155.414     0.150
   133.164  1173.609     0.150
   133.164  1304.109     0.150
   133.164  1368.414     0.150
   133.164  2357.812     0.150
   133.446  1156.414     0.150
   134.118  1157.086     0.150
   134.118  1154.914     0.150
   134.278  1159.016     0.150
   134.417  1157.812     0.150
   134.417  1309.211     0.150
   134.417  2379.609     0.150
   136.460  1160.211     0.150
   136.939  1161.711     0.150
   137.011  1161.711     0.150
   139.530  1167.812     0.150
   139.637  1163.609     0.150
   139.765  1168.914     0.150
   139.921  1168.711     0.150
   139.998  1168.516     0.150
   140.071  1168.016     0.150
   140.676  1168.711     0.150
   142.980  1169.516     0.150
   142.980  1169.914     0.150
   143.110  1170.812     0.150
   143.110  1171.016     0.150
   143.171  1168.789     0.150
   144.197  1172.109     0.150
   144.197  1172.414     0.150
   144.254  1173.312     0.150
   144.254  1173.414     0.150
   145.578  1176.711     0.150
   145.608  1178.211     0.150
   145.753  1176.359     0.150
   145.759  1178.016     0.150
   145.771  1176.812     0.150
   145.771  1188.812     0.150
   145.849  1178.812     0.150
   145.849  1177.109     0.150
   145.862  1178.016     0.150
   146.406  1178.711     0.150
   146.409  1180.016     0.150
   146.694  1179.016     0.150
   146.694  1178.219     0.150
   146.778  1181.711     0.150
   146.988  1176.312     0.150
   146.988  1180.914     0.150
   146.988  1181.516     0.150
   147.299  1182.516     0.150
   148.703  1182.375     0.150
   148.850  1184.812     0.150
   148.850  1188.312     0.150
   148.980  1183.414     0.150
   149.396  1185.016     0.150
   149.681  1185.211     0.150
   149.681  1188.914     0.150
   149.681  1189.711     0.150
   149.681  1186.055     0.150
   149.910  1186.211     0.150
   149.910  1189.109     0.150
   149.910  1187.805     0.150
   150.089  1188.711     0.150
   150.325  1186.109     0.150
   150.325  1190.609     0.150
   150.415  1186.812     0.150
   150.635  1190.812     0.150
   150.635  1185.875     0.150
   150.821  1192.812     0.150
   150.989  1191.812     0.150
   150.989  1186.055     0.150
   151.177  1187.312     0.150
   151.177  1192.711     0.150
   151.314  1187.812     0.150
   151.314  1193.016     0.150
   151.656  1188.914     0.150
   151.787  1187.414     0.150
   151.787  1192.109     0.150
   152.185  1188.609     0.150
   152.185  1195.516     0.150
   152.715  1189.711     0.150
   152.715  1195.414     0.150
   152.715  1195.516     0.150
   152.819  1189.016     0.150
   152.819  1195.914     0.150
   152.861  1190.609     0.150
   152.861  1195.914     0.150
   153.088  1188.211     0.150
   153.336  1193.914     0.150
   153.811  1190.016     0.150
   153.893  1197.414     0.150
   154.049  1194.312     0.150
   154.186  1189.414     0.150
   154.186  1190.109     0.150
   154.404  1198.109     0.150
   154.414  1192.516     0.150
   154.553  1192.914     0.150
   154.632  1196.312     0.150
   154.632  1199.109     0.150
   155.089  1192.516     0.150
     0.302     9.727     0.150
     0.302    16.086     0.150
     0.423    18.684     0.150
     0.423    11.086     0.150
     0.633    13.363     0.150
     0.633    22.215     0.150
     0.815    16.023     0.150
     0.862    16.586     0.150
     0.862    27.055     0.150
     0.865    16.734     0.150
     0.865    27.363     0.150
     0.986    18.746     0.150
     0.986    31.426     0.150
     1.091    19.637     0.150
     1.091    33.254     0.150
     1.119    20.195     0.150
     1.119    33.453     0.150
     1.157    21.285     0.150
     1.157    36.465     0.150
     1.257    22.203     0.150
     1.257    37.664     0.150
     1.277    23.023     0.150
     1.277    38.004     0.150
     1.455    24.766     0.150
     1.455    42.297     0.150
     1.603    28.066     0.150
     1.603    44.234     0.150
     1.933    32.305     0.150
     1.933    53.613     0.150
     1.942    32.066     0.150
     1.961    33.016     0.150
     1.970    31.934     0.150
     1.970    54.965     0.150
     2.017    33.785     0.150
     2.017    56.023     0.150
     2.400    40.637     0.150
     2.400    37.965     0.150
     2.400    64.297     0.150
     2.675    42.324     0.150
     2.675    70.945     0.150
     3.567    56.695     0.150
     3.701    56.121     0.150
     3.701    97.395     0.150
     6.811   101.875     0.150
     8.200   117.801     0.150
     8.200   206.227     0.150
    11.823   169.035     0.150
    13.126   188.316     0.150
    13.126   187.523     0.150
    13.502   192.477     0.150
    13.502   191.773     0.150
    13.811   198.156     0.150
    13.811   197.035     0.150
    14.643   211.344     0.150
    15.020   215.785     0.150
    15.020   215.102     0.150
    15.204   217.375     0.150
    15.204   216.988     0.150
    15.220   217.895     0.150
    15.503   220.387     0.150
    15.626   222.547     0.150
    15.626   222.223     0.150
    15.870   223.414     0.150
    15.870   223.598     0.150
    16.141   229.914     0.150
    16.173   231.566     0.150
    16.366   230.594     0.150
    16.932   236.730     0.150
    17.099   238.633     0.150
    17.261   241.227     0.150
    17.328   240.664     0.150
    17.328   241.621     0.150
    17.535   244.824     0.150
    17.535   243.031     0.150
    17.596   244.055     0.150
    18.124   249.656     0.150
    18.250   253.629     0.150
    18.530   255.934     0.150
    18.598   255.066     0.150
    18.658   256.926     0.150
    18.704   257.055     0.150
    18.777   257.574     0.150
    18.777   257.969     0.150
    18.982   258.453     0.150
    19.054   261.164     0.150
    19.153   262.496     0.150
    19.200   262.969     0.150
    19.200   263.406     0.150
    19.640   267.281     0.150
    19.762   267.273     0.150
    19.986   269.387     0.150
    20.024   269.641     0.150
    20.334   274.145     0.150
    20.340   277.105     0.150
    20.722   280.031     0.150
    21.079   281.523     0.150
    21.207   282.137     0.150
    21.401   283.984     0.150
    21.424   283.293     0.150
    21.551   287.816     0.150
    21.551   288.512     0.150
    21.616   289.344     0.150
    21.643   288.305     0.150
    21.643   290.277     0.150
    21.903   292.594     0.150
    21.940   291.703     0.150
    21.940   293.070     0.150
    22.035   291.715     0.150
    22.113   294.805     0.150
    22.148   293.387     0.150
    22.239   294.711     0.150
    22.412   297.738     0.150
    22.502   298.156     0.150
    22.580   298.691     0.150
    22.910   300.570     0.150
    22.940   302.160     0.150
    22.998   303.645     0.150
    22.998   303.457     0.150
    23.280   306.336     0.150
    23.324   306.055     0.150
    23.453   307.352     0.150
    23.537   320.797     0.150
    23.541   308.664     0.150
    23.717   310.977     0.150
    23.736   309.984     0.150
    23.751   311.660     0.150
    23.870   311.605     0.150
    23.940   313.711     0.150
    24.118   314.129     0.150
    24.134   314.555     0.150
    24.306   315.477     0.150
    24.356   317.121     0.150
    24.471   318.250     0.150
    24.527   318.105     0.150
    24.657   319.688     0.150
    24.789   320.160     0.150
    24.906   320.430     0.150
    25.280   325.227     0.150
    25.321   323.645     0.150
    25.436   324.609     0.150
    25.469   326.316     0.150
    25.607   326.324     0.150
    25.599   328.352     0.150
    25.843   328.234     0.150
    25.864   328.715     0.150
    25.931   331.367     0.150
    26.090   333.219     0.150
    26.178   332.504     0.150
    26.178   333.875     0.150
    26.194   332.836     0.150
    26.400   336.152     0.150
    26.462   335.699     0.150
    26.759   338.137     0.150
    26.759   336.465     0.150
    26.875   338.379     0.150
    26.928   338.129     0.150
    27.335   343.059     0.150
    27.334   343.023     0.150
    27.334    13.402     0.150
    27.334   540.938     0.150
    27.413   345.199     0.150
    27.413    12.676     0.150
    27.413   541.957     0.150
    27.413   343.797     0.150
    27.664   346.551     0.150
    27.664    14.051     0.150
    27.664   345.387     0.150
    27.675   346.613     0.150
    27.753   346.496     0.150
    29.082   356.391     0.150
    29.466   360.719     0.150
    29.670   364.336     0.150
    29.704   362.703     0.150
    30.525   372.402     0.150
    31.352   377.992     0.150
    31.821   380.492     0.150
    32.279   385.934     0.150
    32.343   387.590     0.150
    34.506   407.883     0.150
    37.782   432.203     0.150
    45.060   491.875     0.150
    45.060    12.824     0.150
    46.834   506.324     0.150
    46.834    12.652     0.150
    47.414   511.926     0.150
    48.498   522.023     0.150
    49.300   527.215     0.150
    49.689   530.359     0.150
    50.736   538.246     0.150
    51.316   542.594     0.150
    51.621   545.113     0.150
    51.640   545.199     0.150
    51.807   545.445     0.150
    51.813   546.906     0.150
    52.206   549.863     0.150
    52.418   551.375     0.150
    52.568   552.707     0.150
    52.712   553.344     0.150
    53.109   556.660     0.150
    53.367   557.598     0.150
    53.516   559.180     0.150
    53.945   561.473     0.150
    54.057   563.027     0.150
    54.275   564.910     0.150
    54.401   566.203     0.150
    54.578   565.980     0.150
    54.805   568.352     0.150
    54.850   568.984     0.150
    54.936   568.828     0.150
    55.027   570.930     0.150
    55.081   569.320     0.150
    55.297   570.656     0.150
    55.343   571.766     0.150
    55.501   573.867     0.150
    55.624   573.641     0.150
    55.686   574.418     0.150
    55.855   574.551     0.150
    55.855   574.754     0.150
    56.115   577.383     0.150
    56.127   578.176     0.150
    56.127   577.141     0.150
    56.282   578.363     0.150
    56.305   577.367     0.150
    56.799   582.223     0.150
    56.883   582.566     0.150
    56.905   582.605     0.150
    56.907   582.367     0.150
    57.189   583.324     0.150
    57.189   583.637     0.150
    57.447   585.332     0.150
    57.619   587.375     0.150
    57.619    14.301     0.150
    57.619   586.113     0.150
    57.783   587.023     0.150
    57.783   587.375     0.150
    57.847   588.738     0.150
    58.001   590.434     0.150
    58.024   590.035     0.150
    58.027   590.375     0.150
    58.030   590.406     0.150
    58.239   592.031     0.150
    58.329   592.465     0.150
    58.542   594.340     0.150
    58.715   594.762     0.150
    58.889   596.039     0.150
    59.167   597.977     0.150
    59.273   598.715     0.150
    59.284   599.027     0.150
    59.583   601.652     0.150
    59.604   600.773     0.150
    59.702   601.867     0.150
    59.724   601.855     0.150
    60.060   603.477     0.150
    60.060   604.520     0.150
    60.097   603.855     0.150
    60.097   604.426     0.150
    60.227   605.023     0.150
    60.366   605.898     0.150
    60.586   608.062     0.150
    66.105   644.801     0.150
    82.957   741.898     0.150
    82.957    13.727     0.150
    83.335   743.898     0.150
    91.372   781.375     0.150
    95.942   803.961     0.150
   115.977  1122.676     0.150
   123.722  1135.301     0.150
   123.722  1148.738     0.150
   129.718  1146.773     0.150
   129.718  1160.949     0.150
   129.718  1147.504     0.150
   130.391  1148.176     0.150
   130.391  1162.125     0.150
   140.744  1167.660     0.150
   145.747  1174.875     0.150
     0.101     7.875     0.150
     0.101    13.024     0.150
     0.370    10.004     0.150
     0.370    16.944     0.150
     0.540    12.095     0.150
     0.540    20.194     0.150
     0.672    13.584     0.150
     0.672    22.654     0.150
     0.840    16.214     0.150
     0.840    26.975     0.150
     0.904    17.274     0.150
     0.904    29.205     0.150
     1.304    23.145     0.150
     1.304    38.754     0.150
     1.405    24.365     0.150
     1.405    41.875     0.150
     1.540    25.854     0.150
     1.595    27.125     0.150
     1.595    46.245     0.150
     1.728    29.285     0.150
     1.728    49.504     0.150
     1.832    29.825     0.150
     1.832    51.924     0.150
     1.839    30.575     0.150
     1.839    52.765     0.150
     1.887    30.705     0.150
     1.887    51.615     0.150
     1.866    31.895     0.150
     1.866    54.765     0.150
     1.947    32.544     0.150
     1.947    54.714     0.150
     2.152    35.234     0.150
     2.152    61.234     0.150
     2.166    34.734     0.150
     2.186    35.904     0.150
     2.191    36.245     0.150
     2.191    63.805     0.150
     2.200    35.745     0.150
     2.200    61.135     0.150
     2.282    67.935     0.150
     2.287    37.185     0.150
     2.287    64.964     0.150
     2.390    36.785     0.150
     2.390    68.225     0.150
     2.558    67.584     0.150
     2.534    40.135     0.150
     2.590    40.654     0.150
     2.709    43.524     0.150
     3.472    51.645     0.150
     3.566    54.564     0.150
     3.566    54.834     0.150
     3.566    90.654     0.150
     3.566    90.825     0.150
     3.648    55.165     0.150
     3.648    95.095     0.150
     3.797    57.444     0.150
     3.797    96.455     0.150
     4.442    68.254     0.150
     4.442   117.595     0.150
     4.478    66.904     0.150
     4.478   115.984     0.150
     4.508    71.024     0.150
     4.515    70.075     0.150
     4.523    70.455     0.150
     4.541    70.674     0.150
     4.615    70.205     0.150
     4.615   119.544     0.150
     4.685    72.234     0.150
     0.291     9.102     0.150
     0.291    15.102     0.150
     0.288     9.156     0.150
     0.288    15.047     0.150
     0.371     9.867     0.150
     0.371    16.422     0.150
     0.251     8.672     0.150
     0.251    14.516     0.150
     0.401    10.203     0.150
     0.401    16.992     0.150
     0.876    16.211     0.150
     0.939    17.438     0.150
     0.939    29.805     0.150
     1.182    20.844     0.150
     1.182    35.422     0.150
     1.329    23.375     0.150
     1.329    40.734     0.150
     1.346    23.312     0.150
     1.346    41.086     0.150
     1.453    25.055     0.150
     1.453    43.031     0.150
     1.543    26.352     0.150
     1.543    47.117     0.150
     1.457    24.664     0.150
     1.457    43.641     0.150
     1.457    43.992     0.150
     1.766    30.297     0.150
     1.766    52.562     0.150
     1.882    30.812     0.150
     1.959    32.133     0.150
     1.958    31.812     0.150
     1.903    32.375     0.150
     1.903    56.422     0.150
     2.157    35.352     0.150
     2.162    34.891     0.150
     2.162    60.367     0.150
     2.226    35.828     0.150
     2.226    63.727     0.150
     2.223    35.273     0.150
     2.223    62.984     0.150
     2.224    35.414     0.150
     2.230    35.875     0.150
     2.276    36.281     0.150
     2.276    61.461     0.150
     2.308    36.188     0.150
     2.324    38.188     0.150
     2.371    40.742     0.150
     2.371    70.164     0.150
     2.383    37.938     0.150
     2.383    67.266     0.150
     2.501    39.727     0.150
     2.537    41.055     0.150
     2.594    41.875     0.150
     2.620    42.758     0.150
     2.620    75.266     0.150
     2.846    43.438     0.150
     2.846    84.047     0.150
     2.824    43.156     0.150
     2.834    42.633     0.150
     2.877    44.617     0.150
     3.779    56.758     0.150
     4.068    61.141     0.150
     4.068   107.133     0.150
     4.039    63.547     0.150
     4.120    66.133     0.150
     4.125    65.086     0.150
     4.132    66.008     0.150
     4.153    65.547     0.150
     4.277    66.234     0.150
     4.912    73.039     0.150
     4.912   127.242     0.150
     7.780   113.891     0.150
     7.780   114.094     0.150
     7.870   115.656     0.150
    12.596   180.914     0.150
    26.580   338.586     0.150
    26.813   338.969     0.150
    45.429   495.000     0.150
    46.451   502.969     0.150
   128.567  1144.812     0.150
     0.294     7.928     0.150
     0.294    12.479     0.150
     0.372     8.357     0.150
     0.372    13.348     0.150
     0.419     9.078     0.150
     0.461    16.367     0.150
     0.864    27.518     0.150
     0.929    17.838     0.150
     0.929    29.729     0.150
     1.189    22.408     0.150
     1.189    22.277     0.150
     1.189    36.559     0.150
     1.222    22.387     0.150
     1.222    38.238     0.150
     1.222    36.637     0.150
     1.295    23.197     0.150
     1.295    41.518     0.150
     1.675    29.537     0.150
     1.675    49.688     0.150
     1.675    49.248     0.150
     1.686    29.848     0.150
     1.686    52.229     0.150
     1.686    48.898     0.150
     1.724    29.998     0.150
     1.724    52.947     0.150
     1.724    49.848     0.150
     1.788    31.059     0.150
     1.788    54.928     0.150
     1.817    31.479     0.150
     1.817    58.037     0.150
     1.918    32.857     0.150
     1.918    57.467     0.150
     2.170    64.637     0.150
     2.170    36.418     0.150
     2.135    35.318     0.150
     2.135    65.309     0.150
     2.236    71.168     0.150
     2.289    39.688     0.150
     2.289    69.617     0.150
     2.309    38.217     0.150
     2.309    73.059     0.150
     2.468    40.277     0.150
     2.468    75.867     0.150
     2.617    42.908     0.150
     2.617    73.078     0.150
     2.610    42.148     0.150
     2.610    44.047     0.150
     2.595    45.979     0.150
     2.595    76.527     0.150
     2.632    42.059     0.150
     2.632    78.408     0.150
     2.621    43.748     0.150
     2.652    42.658     0.150
     2.652    77.217     0.150
     2.641    43.867     0.150
     2.641    75.898     0.150
     2.754    45.367     0.150
     2.754    74.979     0.150
     3.280    51.967     0.150
     3.280    92.328     0.150
     3.331    50.838     0.150
     3.390    54.309     0.150
     3.390    52.627     0.150
     3.390    53.107     0.150
     4.047    60.178     0.150
     4.047   103.457     0.150
     4.087    69.697     0.150
     4.087   117.387     0.150
     4.403    71.738     0.150
     4.375    66.242     0.150
     4.375   136.543     0.150
     4.375    66.748     0.150
     4.736    74.068     0.150
     4.736   131.668     0.150
     4.820    76.027     0.150
     4.825    76.258     0.150
     4.825   137.668     0.150
     4.832    75.867     0.150
     4.832   132.059     0.150
     4.853    75.697     0.150
     4.853   132.447     0.150
     4.889    75.229     0.150
     4.889   131.988     0.150
     4.966    72.357     0.150
     4.966   132.068     0.150
     4.972    77.059     0.150
     6.010    90.268     0.150
     6.468    94.367     0.150
     6.468   174.828     0.150
     6.710    99.367     0.150
     7.015   105.488     0.150
     7.015   107.908     0.150
     7.754   114.338     0.150
     8.148   120.229     0.150
     8.148   214.688     0.150
     9.167   132.857     0.150
     9.978   145.408     0.150
    11.560   166.758     0.150
    11.560   165.125     0.150
    11.701   170.078     0.150
    12.023   173.047     0.150
    13.153   188.717     0.150
    13.153   189.277     0.150
    13.153   188.297     0.150
    13.153   418.453     0.150
    13.153   188.707     0.150
    13.587   195.367     0.150
    13.592   192.998     0.150
    13.712   194.598     0.150
    13.712   192.480     0.150
    14.112   198.639     0.150
    14.599   207.287     0.150
    14.705   209.258     0.150
    15.095   212.809     0.150
    15.328   217.188     0.150
    15.457   222.287     0.150
    15.600   218.658     0.150
    15.600   217.365     0.150
    15.769   226.787     0.150
    15.847   226.748     0.150
    15.847   224.928     0.150
    15.971   227.318     0.150
    16.129   227.357     0.150
    16.148   227.697     0.150
    16.192   232.398     0.150
    16.600   234.738     0.150
    16.678   234.408     0.150
    16.649   237.498     0.150
    16.962   236.928     0.150
    17.131   242.098     0.150
    17.430   242.598     0.150
    17.430   242.365     0.150
    17.447   244.777     0.150
    17.447   242.998     0.150
    17.473   243.816     0.150
    17.504   244.297     0.150
    17.875   250.627     0.150
    17.964   248.498     0.150
    18.175   252.207     0.150
    18.211   252.238     0.150
    18.211   251.883     0.150
    18.289   251.867     0.150
    18.289   251.197     0.150
    18.382   255.758     0.150
    18.470   254.428     0.150
    18.523   254.998     0.150
    18.530   257.658     0.150
    18.554   258.012     0.150
    18.628   257.951     0.150
    18.888   260.197     0.150
    19.217   264.818     0.150
    19.217   265.395     0.150
    19.397   264.873     0.150
    19.436   267.758     0.150
    19.436   268.691     0.150
    19.536   266.838     0.150
    19.575   267.447     0.150
    19.596   268.068     0.150
    19.758   268.238     0.150
    19.786   270.018     0.150
    19.852   270.578     0.150
    19.878   268.926     0.150
    19.931   271.428     0.150
    20.093   275.059     0.150
    20.115   272.832     0.150
    20.309   276.479     0.150
    20.514   279.148     0.150
    20.514   280.090     0.150
    20.562   277.885     0.150
    20.820   281.916     0.150
    20.872   280.277     0.150
    20.947   283.607     0.150
    21.050   285.717     0.150
    21.131   284.277     0.150
    21.396   289.947     0.150
    21.396   289.838     0.150
    21.467   289.037     0.150
    21.545   290.957     0.150
    21.627   290.293     0.150
    21.730   293.158     0.150
    21.922   290.928     0.150
    21.936   293.857     0.150
    21.932   296.041     0.150
    21.945   293.232     0.150
    21.992   291.688     0.150
    22.024   293.697     0.150
    22.024   293.990     0.150
    22.193   297.799     0.150
    22.378   298.795     0.150
    22.394   297.555     0.150
    22.408   300.537     0.150
    22.445   297.363     0.150
    22.453   297.111     0.150
    22.541   300.090     0.150
    22.676   300.990     0.150
    22.713   303.277     0.150
    22.729   302.408     0.150
    22.729   301.260     0.150
    22.754   304.164     0.150
    22.757   303.785     0.150
    22.761   305.318     0.150
    22.761   304.797     0.150
    23.107   306.697     0.150
    23.126   309.111     0.150
    23.204   308.002     0.150
    23.471   307.893     0.150
    23.486   311.311     0.150
    23.541   312.143     0.150
    23.573   312.398     0.150
    23.627   312.268     0.150
    23.627   311.768     0.150
    23.666   312.881     0.150
    23.750   314.383     0.150
    23.843   312.967     0.150
    23.843   312.656     0.150
    23.846   314.869     0.150
    23.917   315.832     0.150
    23.958   316.152     0.150
    23.967   315.586     0.150
    23.998   314.387     0.150
    24.027   315.809     0.150
    24.122   317.059     0.150
    24.151   317.838     0.150
    24.148   317.125     0.150
    24.255   317.588     0.150
    24.255   317.145     0.150
    24.264   316.248     0.150
    24.285   318.699     0.150
    24.350   316.125     0.150
    24.344   319.564     0.150
    24.393   319.568     0.150
    24.462   318.209     0.150
    24.477   320.113     0.150
    24.563   320.244     0.150
    24.554   321.998     0.150
    24.639   320.090     0.150
    24.731   322.037     0.150
    24.740   322.438     0.150
    24.749   321.598     0.150
    24.749   322.570     0.150
    25.008   326.592     0.150
    25.023   325.609     0.150
    25.053   325.654     0.150
    25.077   325.570     0.150
    25.227   327.018     0.150
    25.257   324.979     0.150
    25.275   325.547     0.150
    25.295   325.729     0.150
    25.336   325.467     0.150
    25.338   328.268     0.150
    25.373   329.055     0.150
    25.637   331.037     0.150
    25.675   330.039     0.150
    25.684   330.711     0.150
    25.685   331.055     0.150
    25.685   331.947     0.150
    25.800   332.738     0.150
    25.859   333.465     0.150
    25.901   331.064     0.150
    26.071   335.809     0.150
    26.112   332.498     0.150
    26.126   335.537     0.150
    26.204   336.893     0.150
    26.360   337.986     0.150
    26.441   336.209     0.150
    26.374   339.809     0.150
    26.537   336.184     0.150
    26.556   337.094     0.150
    26.545   339.348     0.150
    26.651   337.623     0.150
    26.596   339.047     0.150
    26.879   341.408     0.150
    27.044   341.086     0.150
    27.239   343.404     0.150
    27.241   346.447     0.150
    27.271   341.926     0.150
    27.237   346.998     0.150
    27.366   343.906     0.150
    27.373   345.482     0.150
    27.373   346.098     0.150
    27.373     8.051     0.150
    27.447   344.859     0.150
    27.579   349.523     0.150
    27.579     8.074     0.150
    27.601   346.936     0.150
    27.650   347.545     0.150
    28.288   351.955     0.150
    28.527   354.961     0.150
    28.590   359.729     0.150
    28.866   357.045     0.150
    28.875   357.773     0.150
    28.969   357.215     0.150
    29.115   362.393     0.150
    29.115   362.078     0.150
    29.384   362.578     0.150
    29.468   361.346     0.150
    29.506   363.684     0.150
    29.519   365.318     0.150
    29.636   366.129     0.150
    30.046   369.457     0.150
    30.267   370.598     0.150
    30.318   370.350     0.150
    30.420   372.570     0.150
    30.421   371.537     0.150
    30.557   374.520     0.150
    30.680   373.740     0.150
    30.841   377.127     0.150
    31.053   377.934     0.150
    31.522   381.107     0.150
    31.529   382.768     0.150
    31.639   383.148     0.150
    31.829   384.857     0.150
    31.914   385.822     0.150
    32.090   387.887     0.150
    32.090   388.322     0.150
    32.330   390.182     0.150
    32.353   390.318     0.150
    32.353   390.137     0.150
    32.360   390.443     0.150
    32.383   388.947     0.150
    32.383   389.148     0.150
    32.730   391.553     0.150
    32.728   394.047     0.150
    32.738   392.838     0.150
    33.141   397.318     0.150
    33.172   397.123     0.150
    33.237   396.158     0.150
    33.282   398.865     0.150
    33.580   398.373     0.150
    33.606   402.086     0.150
    33.682   401.047     0.150
    33.977   403.754     0.150
    34.648   410.658     0.150
    34.736   410.672     0.150
    34.814   410.105     0.150
    35.263   416.102     0.150
    35.946   421.059     0.150
    35.901   422.809     0.150
    37.990   437.217     0.150
    38.319   441.658     0.150
    42.125   472.338     0.150
    43.066   480.287     0.150
    45.034   497.797     0.150
    45.034   497.588     0.150
    45.562   498.447     0.150
    45.732   502.633     0.150
    46.959   510.398     0.150
    46.959     7.799     0.150
    47.401   516.545     0.150
    48.270   521.809     0.150
    48.270   522.268     0.150
    48.437   524.141     0.150
    48.575   525.963     0.150
    48.703   525.668     0.150
    49.224   529.541     0.150
    49.371   529.467     0.150
    49.545   532.447     0.150
    49.875   533.717     0.150
    50.963   543.250     0.150
    51.222   543.596     0.150
    51.320   545.020     0.150
    51.604   547.357     0.150
    51.639   547.219     0.150
    51.757   548.381     0.150
    51.774   549.023     0.150
    51.836   549.693     0.150
    52.046   551.404     0.150
    53.188   560.373     0.150
    53.167   560.678     0.150
    53.233   560.748     0.150
    53.515   562.383     0.150
    53.810   563.213     0.150
    54.223   567.801     0.150
    54.366   568.438     0.150
    54.574   569.326     0.150
    54.618   570.312     0.150
    54.778   571.029     0.150
    54.810   571.096     0.150
    54.972   571.729     0.150
    55.096   571.383     0.150
    55.316   572.898     0.150
    55.330   573.594     0.150
    55.439   574.922     0.150
    55.462   576.018     0.150
    55.621   575.371     0.150
    55.920   577.857     0.150
    55.920   578.598     0.150
    56.073   580.340     0.150
    56.103   580.350     0.150
    56.190   581.031     0.150
    56.266   582.008     0.150
    56.266   581.672     0.150
    56.275   581.770     0.150
    56.296   581.666     0.150
    56.588   583.291     0.150
    56.599   583.406     0.150
    56.669   584.299     0.150
    56.811   585.262     0.150
    57.021   587.018     0.150
    57.081   586.268     0.150
    57.418   588.533     0.150
    57.538   588.982     0.150
    57.595   590.037     0.150
    57.595   589.797     0.150
    57.803   591.264     0.150
    57.825   591.320     0.150
    57.958   593.648     0.150
    57.979   592.828     0.150
    58.001   593.074     0.150
    58.072   593.998     0.150
    58.187   594.334     0.150
    58.295   595.980     0.150
    58.393   596.016     0.150
    58.527   597.191     0.150
    58.638   597.520     0.150
    58.689   597.477     0.150
    58.791   598.412     0.150
    58.791   598.609     0.150
    58.866   599.893     0.150
    58.884   598.631     0.150
    59.081   600.408     0.150
    59.103   601.002     0.150
    59.133   600.877     0.150
    59.189   601.340     0.150
    59.209   601.648     0.150
    59.204   601.498     0.150
    59.377   602.670     0.150
    59.455   602.828     0.150
    59.473   603.260     0.150
    59.501   603.672     0.150
    59.612   604.502     0.150
    59.660   604.547     0.150
    59.667   604.727     0.150
    59.728   605.104     0.150
    59.790   605.924     0.150
    59.953   607.170     0.150
    60.032   606.738     0.150
    60.043   607.336     0.150
    60.055   607.896     0.150
    60.055   607.309     0.150
    60.195   608.152     0.150
    60.291   608.326     0.150
    60.302   609.369     0.150
    60.342   609.303     0.150
    60.600   611.203     0.150
    60.637   610.754     0.150
    60.652   610.797     0.150
    60.846   612.379     0.150
    60.859   613.180     0.150
    60.932   613.053     0.150
    61.048   614.072     0.150
    61.115   614.689     0.150
    61.166   615.623     0.150
    61.553   617.256     0.150
    63.134   630.123     0.150
    65.637   643.598     0.150
    83.264   746.523     0.150
    83.619   747.373     0.150
    84.299   751.947     0.150
    85.731   758.273     0.150
    91.963   787.297     0.150
    95.381  1032.418     0.150
    96.641   809.322     0.150
   127.864  1145.910     0.150
   129.024  1148.873     0.150
   129.692  1150.598     0.150
   132.370  1156.598     0.150
   140.651  1171.398     0.150
     0.171     7.918     0.150
     0.171    12.988     0.150
     0.204     8.018     0.150
     0.204    13.188     0.150
     0.463    10.969     0.150
     0.463    18.258     0.150
     0.484    11.357     0.150
     0.484    18.639     0.150
     0.576    12.238     0.150
     0.576    20.598     0.150
     0.911    16.857     0.150
     0.911    28.719     0.150
     1.069    19.379     0.150
     1.069    33.008     0.150
     1.144    20.078     0.150
     1.253    22.668     0.150
     1.253    37.129     0.150
     1.357    23.648     0.150
     1.357    40.328     0.150
     1.515    26.178     0.150
     1.515    44.607     0.150
     1.616    27.447     0.150
     1.616    46.518     0.150
     1.683    29.059     0.150
     1.683    49.408     0.150
     1.687    28.828     0.150
     1.687    49.178     0.150
     1.867    53.428     0.150
     1.973    31.527     0.150
     1.973    55.078     0.150
     2.107    34.299     0.150
     2.107    58.479     0.150
     2.122    34.758     0.150
     2.122    61.158     0.150
     2.163    34.438     0.150
     2.163    59.889     0.150
     2.214    36.219     0.150
     2.214    61.328     0.150
     2.215    36.168     0.150
     2.215    63.389     0.150
     2.229    35.598     0.150
     2.229    62.188     0.150
     2.283    36.709     0.150
     2.283    65.148     0.150
     2.345    38.129     0.150
     2.345    64.588     0.150
     2.343    37.688     0.150
     2.343    65.607     0.150
     2.386    38.549     0.150
     2.386    66.178     0.150
     2.399    37.918     0.150
     2.399    67.789     0.150
     2.458    39.768     0.150
     2.458    68.299     0.150
     2.500    39.809     0.150
     2.500    68.348     0.150
     2.521    39.879     0.150
     2.521    70.607     0.150
     2.560    42.078     0.150
     2.560    68.988     0.150
     2.582    69.857     0.150
     2.590    40.898     0.150
     2.590    71.959     0.150
     2.619    43.818     0.150
     2.619    71.498     0.150
     2.771    44.469     0.150
     2.771    76.197     0.150
     2.816    80.139     0.150
     2.889    79.209     0.150
     2.975    46.988     0.150
     2.975    81.027     0.150
     3.166    48.828     0.150
     3.166    84.229     0.150
     3.183    49.398     0.150
     3.183    83.549     0.150
     3.336    51.738     0.150
     3.336    88.469     0.150
     3.836    58.818     0.150
     3.836   103.828     0.150
     3.857    57.277     0.150
     3.857   102.768     0.150
     3.920    61.148     0.150
     3.920   104.729     0.150
     3.925    62.988     0.150
     3.925   104.527     0.150
     3.932    60.758     0.150
     3.932   106.578     0.150
     3.953    61.549     0.150
     3.953   107.098     0.150
     3.995    61.549     0.150
     3.995   105.768     0.150
     4.073    62.629     0.150
     4.197    61.398     0.150
     4.197   105.658     0.150
     4.245    64.818     0.150
     4.245   110.648     0.150
     5.102    75.188     0.150
     5.102   130.129     0.150
     0.477    11.703     0.150
     0.477    19.354     0.150
     0.664    13.982     0.150
     0.664    23.812     0.150
     0.923    17.104     0.150
     1.110    19.883     0.150
     1.110    33.662     0.150
     1.275    22.354     0.150
     1.275    38.633     0.150
     1.275    37.252     0.150
     1.397    24.373     0.150
     1.397    41.604     0.150
     1.399    24.242     0.150
     1.399    41.523     0.150
     1.379    24.293     0.150
     1.379    41.143     0.150
     1.519    26.094     0.150
     1.519    45.062     0.150
     1.690    27.742     0.150
     1.690    47.312     0.150
     1.801    29.723     0.150
     1.801    51.832     0.150
     1.724    29.162     0.150
     1.724    50.143     0.150
     1.930    31.873     0.150
     1.930    54.773     0.150
     1.920    33.094     0.150
     1.920    56.094     0.150
     1.960    31.443     0.150
     1.960    54.992     0.150
     2.047    33.172     0.150
     2.047    57.742     0.150
     2.135    34.922     0.150
     2.135    60.963     0.150
     2.266    36.354     0.150
     2.266    66.514     0.150
     2.263    36.764     0.150
     2.263    67.443     0.150
     2.172    36.764     0.150
     2.172    61.514     0.150
     2.286    36.684     0.150
     2.286    65.662     0.150
     2.309    36.434     0.150
     2.309    65.662     0.150
     2.299    36.844     0.150
     2.299    64.094     0.150
     2.317    36.344     0.150
     2.317    63.502     0.150
     2.317    36.344     0.150
     2.317    63.502     0.150
     2.316    36.943     0.150
     2.316    70.232     0.150
     2.362    37.982     0.150
     2.362    64.953     0.150
     2.375    37.832     0.150
     2.375    65.543     0.150
     2.375    38.223     0.150
     2.375    64.742     0.150
     2.375    37.562     0.150
     2.375    37.832     0.150
     2.375    65.543     0.150
     2.375    67.672     0.150
     2.384    38.094     0.150
     2.384    65.822     0.150
     2.411    38.283     0.150
     2.411    67.912     0.150
     2.421    38.502     0.150
     2.445    39.463     0.150
     2.445    66.713     0.150
     2.488    41.242     0.150
     2.505    69.303     0.150
     2.533    39.773     0.150
     2.533    69.672     0.150
     2.544    40.152     0.150
     2.544    75.354     0.150
     2.548    39.893     0.150
     2.548    71.422     0.150
     2.603    76.943     0.150
     2.644    41.172     0.150
     2.644    74.422     0.150
     2.690    41.703     0.150
     2.690    71.232     0.150
     2.738    42.863     0.150
     2.738    79.514     0.150
     2.710    42.912     0.150
     2.710    70.893     0.150
     2.798    43.213     0.150
     2.798    78.242     0.150
     2.878    44.184     0.150
     2.904    44.604     0.150
     2.904    85.582     0.150
     2.907    45.844     0.150
     2.907    79.383     0.150
     2.906    45.844     0.150
     2.906    79.383     0.150
     2.915    45.252     0.150
     2.915    79.293     0.150
     2.976    47.713     0.150
     2.976    77.822     0.150
     3.143    47.752     0.150
     3.143    84.523     0.150
     3.148    50.033     0.150
     3.148    87.184     0.150
     3.248    52.162     0.150
     3.248    88.562     0.150
     3.347    50.082     0.150
     3.347    50.082     0.150
     3.347    95.264     0.150
     3.667    52.982     0.150
     3.638    55.723     0.150
     3.638    98.514     0.150
     3.730    56.604     0.150
     3.730   101.844     0.150
     3.766    54.992     0.150
     3.766   105.113     0.150
     3.726    56.953     0.150
     3.726    94.672     0.150
     3.854    58.062     0.150
     3.854   100.943     0.150
     4.174    59.344     0.150
     4.174   110.492     0.150
     4.308    67.123     0.150
     4.308   114.502     0.150
     4.387    68.482     0.150
     4.392    68.934     0.150
     4.392   114.973     0.150
     4.399    69.373     0.150
     4.399   117.363     0.150
     4.419    68.883     0.150
     4.419   120.703     0.150
     4.438    69.514     0.150
     4.438   118.783     0.150
     4.469    68.252     0.150
     4.469   116.184     0.150
     4.546    70.943     0.150
     4.546   118.553     0.150
     4.684    67.422     0.150
     4.684   125.143     0.150
     4.675    68.918     0.150
     4.675   120.229     0.150
     4.675   141.506     0.150
     4.675    69.543     0.150
     4.675   121.502     0.150
     4.854    71.912     0.150
     4.854   132.062     0.150
     5.203    72.723     0.150
     5.226    79.023     0.150
     5.226   138.002     0.150
     5.386    79.053     0.150
     5.386   139.094     0.150
     5.513    83.113     0.150
     5.513   146.514     0.150
     5.588    84.252     0.150
     5.588   146.322     0.150
     6.030    92.934     0.150
     6.030   157.953     0.150
     6.305    94.293     0.150
     6.305    94.113     0.150
     6.305   164.652     0.150
     6.369    92.844     0.150
     6.369   168.752     0.150
     6.422    95.184     0.150
     6.422   162.582     0.150
     7.353   108.732     0.150
     7.486   110.023     0.150
     7.486   191.053     0.150
     7.519   111.232     0.150
     7.519   195.002     0.150
     7.609   111.773     0.150
     7.609   193.002     0.150
     7.854   112.703     0.150
     7.854   199.533     0.150
     8.158   121.893     0.150
     9.478   137.473     0.150
     9.560   140.873     0.150
     9.560   246.594     0.150
    10.330   149.184     0.150
    11.266   158.662     0.150
    11.266   159.859     0.150
    11.287   161.594     0.150
    11.928   168.684     0.150
    12.396   174.502     0.150
    12.778   181.492     0.150
    12.778   181.463     0.150
    12.778   181.607     0.150
    12.778   402.131     0.150
    12.778   182.242     0.150
    13.376   186.283     0.150
    13.409   189.803     0.150
    13.409   189.150     0.150
    13.855   196.502     0.150
    13.855   194.264     0.150
    14.374   201.463     0.150
    14.937   208.453     0.150
    15.063   210.502     0.150
    15.063   210.215     0.150
    15.400   214.402     0.150
    15.390   221.434     0.150
    15.486   217.930     0.150
    15.489   222.783     0.150
    15.547   217.104     0.150
    15.547   216.307     0.150
    15.637   219.922     0.150
    15.687   221.023     0.150
    15.715   224.982     0.150
    15.788   220.922     0.150
    15.823   219.393     0.150
    15.759   222.223     0.150
    15.867   224.510     0.150
    16.375   228.594     0.150
    16.409   227.332     0.150
    16.561   227.604     0.150
    16.746   231.893     0.150
    16.713   234.113     0.150
    16.734   235.713     0.150
    17.071   234.453     0.150
    17.108   235.492     0.150
    17.059   235.934     0.150
    17.071   237.982     0.150
    17.071   237.230     0.150
    17.103   236.443     0.150
    17.103   236.684     0.150
    17.307   237.412     0.150
    17.307   236.572     0.150
    17.355   238.572     0.150
    17.359   240.832     0.150
    17.605   241.482     0.150
    17.654   242.863     0.150
    17.623   245.273     0.150
    17.678   242.553     0.150
    17.678   242.381     0.150
    17.883   246.232     0.150
    17.883   245.652     0.150
    17.945   248.082     0.150
    17.994   248.293     0.150
    18.127   250.684     0.150
    18.144   250.543     0.150
    18.165   249.232     0.150
    18.165   249.488     0.150
    18.165   249.035     0.150
    18.239   249.045     0.150
    18.206   251.213     0.150
    18.253   250.053     0.150
    18.266   251.033     0.150
    18.296   250.002     0.150
    18.327   249.033     0.150
    18.323   250.832     0.150
    18.323   250.391     0.150
    18.481   251.604     0.150
    18.531   255.273     0.150
    18.586   254.344     0.150
    18.623   254.143     0.150
    18.672   254.963     0.150
    18.825   257.453     0.150
    18.836   258.627     0.150
    18.836   597.777     0.150
    18.836   257.902     0.150
    18.836   256.336     0.150
    18.899   258.203     0.150
    18.982   258.594     0.150
    18.982   258.443     0.150
    19.029   259.252     0.150
    19.006   259.922     0.150
    19.125   259.883     0.150
    19.155   260.703     0.150
    19.155   259.820     0.150
    19.198   261.303     0.150
    19.264   261.812     0.150
    19.279   262.133     0.150
    19.306   261.713     0.150
    19.391   263.453     0.150
    19.466   263.803     0.150
    19.477   263.094     0.150
    19.644   266.354     0.150
    19.681   266.582     0.150
    19.681   265.057     0.150
    19.732   266.393     0.150
    19.685   266.393     0.150
    19.746   265.701     0.150
    19.765   266.902     0.150
    19.803   266.963     0.150
    19.837   267.143     0.150
    19.881   268.072     0.150
    19.934   268.553     0.150
    19.934   269.062     0.150
    19.996   269.822     0.150
    20.028   269.803     0.150
    20.035   270.434     0.150
    20.091   270.752     0.150
    20.139   271.283     0.150
    20.110   272.062     0.150
    20.110   272.711     0.150
    20.144   271.623     0.150
    20.176   271.113     0.150
    20.191   270.617     0.150
    20.149   272.943     0.150
    20.202   272.393     0.150
    20.231   271.812     0.150
    20.237   272.672     0.150
    20.270   273.133     0.150
    20.394   272.883     0.150
    20.469   273.473     0.150
    20.466   275.820     0.150
    20.555   275.773     0.150
    20.555   275.160     0.150
    20.628   276.082     0.150
    20.689   277.322     0.150
    20.626   277.973     0.150
    20.725   276.873     0.150
    20.776   277.143     0.150
    20.775   276.912     0.150
    20.892   279.373     0.150
    20.964   278.922     0.150
    20.964   282.422     0.150
    21.094   281.043     0.150
    21.133   282.963     0.150
    21.133   285.037     0.150
    21.264   284.193     0.150
    21.264   285.309     0.150
    21.300   285.363     0.150
    21.371   284.133     0.150
    21.406   287.303     0.150
    21.457   286.941     0.150
    21.469   288.377     0.150
    21.506   288.883     0.150
    21.575   286.062     0.150
    21.548   288.072     0.150
    21.548   288.633     0.150
    21.595   286.434     0.150
    21.572   288.072     0.150
    21.572   288.383     0.150
    21.724   286.863     0.150
    21.724   287.885     0.150
    21.797   287.332     0.150
    21.797   288.223     0.150
    21.762   290.404     0.150
    21.815   290.648     0.150
    21.926   289.912     0.150
    21.926   289.963     0.150
    21.937   289.652     0.150
    21.997   290.553     0.150
    21.949   293.131     0.150
    21.985   293.514     0.150
    22.062   292.303     0.150
    22.062   291.818     0.150
    22.092   291.213     0.150
    22.114   291.168     0.150
    22.183   293.273     0.150
    22.183   292.318     0.150
    22.200   292.402     0.150
    22.265   292.104     0.150
    22.265   291.918     0.150
    22.301   297.193     0.150
    22.328   297.252     0.150
    22.328   295.482     0.150
    22.452   294.393     0.150
    22.622   296.422     0.150
    22.697   299.924     0.150
    22.723   300.143     0.150
    22.833   297.523     0.150
    22.769   300.316     0.150
    22.968   303.963     0.150
    23.045   301.264     0.150
    23.107   301.604     0.150
    23.054   303.922     0.150
    23.111   304.785     0.150
    23.179   301.812     0.150
    23.250   304.873     0.150
    23.210   305.922     0.150
    23.270   305.604     0.150
    23.270   305.711     0.150
    23.385   306.633     0.150
    23.322   307.602     0.150
    23.401   303.352     0.150
    23.401   304.992     0.150
    23.425   305.643     0.150
    23.431   305.502     0.150
    23.410   307.314     0.150
    23.483   308.227     0.150
    23.635   306.443     0.150
    23.731   307.973     0.150
    23.753   308.822     0.150
    23.718   310.633     0.150
    23.718   310.371     0.150
    23.846   309.633     0.150
    23.847   309.764     0.150
    23.847   309.328     0.150
    23.895   310.133     0.150
    23.903   309.732     0.150
    23.932   311.279     0.150
    23.909   311.701     0.150
    23.939   312.252     0.150
    23.995   313.752     0.150
    24.035   310.854     0.150
    24.023   314.473     0.150
    24.187   311.705     0.150
    24.121   314.254     0.150
    24.223   313.773     0.150
    24.223   312.441     0.150
    24.187   315.002     0.150
    24.187   313.168     0.150
    24.283   316.492     0.150
    24.355   314.652     0.150
    24.365   314.982     0.150
    24.337   315.742     0.150
    24.344   315.553     0.150
    24.349   316.695     0.150
    24.427   315.533     0.150
    24.427   314.973     0.150
    24.392   315.463     0.150
    24.389   317.445     0.150
    24.631   317.793     0.150
    24.572   319.203     0.150
    24.596   319.221     0.150
    24.628   320.082     0.150
    24.628   319.801     0.150
    24.647   318.830     0.150
    24.769   318.082     0.150
    24.709   319.943     0.150
    24.842   318.934     0.150
    24.793   320.822     0.150
    24.902   322.730     0.150
    24.963   322.582     0.150
    24.941   323.172     0.150
    25.060   321.184     0.150
    25.031   321.604     0.150
    25.109   322.373     0.150
    25.152   321.832     0.150
    25.155   321.492     0.150
    25.132   324.232     0.150
    25.253   323.473     0.150
    25.287   322.713     0.150
    25.254   325.035     0.150
    25.258   325.920     0.150
    25.249   325.404     0.150
    25.333   324.643     0.150
    25.413   325.732     0.150
    25.443   325.002     0.150
    25.443   325.957     0.150
    25.426   326.908     0.150
    25.636   328.895     0.150
    25.724   330.463     0.150
    25.724   329.658     0.150
    25.788   331.252     0.150
    25.860   330.822     0.150
    25.991   329.793     0.150
    26.023   329.242     0.150
    25.985   330.123     0.150
    26.314   332.033     0.150
    26.367   333.533     0.150
    26.388   332.232     0.150
    26.388   334.207     0.150
    26.404   333.559     0.150
    26.528   335.354     0.150
    26.646   335.348     0.150
    26.686   335.953     0.150
    26.704   335.832     0.150
    26.714   335.922     0.150
    26.739   338.043     0.150
    26.815   341.082     0.150
    26.921   338.133     0.150
    26.997   340.248     0.150
    26.997   340.332     0.150
    26.997   340.883     0.150
    27.066   339.682     0.150
    27.169   342.834     0.150
    27.172   343.764     0.150
    27.269   341.143     0.150
    27.269   341.812     0.150
    27.313   341.094     0.150
    27.336   342.438     0.150
    27.611   343.223     0.150
    27.673   347.223     0.150
    27.720   346.902     0.150
    27.803   346.672     0.150
    27.933   347.773     0.150
    28.194   350.191     0.150
    28.180   353.662     0.150
    28.369   355.594     0.150
    28.783   356.986     0.150
    29.139   359.627     0.150
    29.239   361.250     0.150
    29.368   359.756     0.150
    29.490   359.752     0.150
    30.198   367.588     0.150
    30.179   368.568     0.150
    30.754   372.494     0.150
    31.368   378.564     0.150
    31.585   380.920     0.150
    31.968   384.242     0.150
    31.998   384.736     0.150
    31.972   386.729     0.150
    32.312   386.736     0.150
    32.687   389.527     0.150
    33.306   394.457     0.150
    33.413   396.742     0.150
    34.256   404.252     0.150
    34.256   404.428     0.150
    34.313   403.652     0.150
    35.447   415.963     0.150
    37.919   436.422     0.150
    39.459   447.973     0.150
    40.930   458.902     0.150
    42.559   474.213     0.150
    45.326   495.906     0.150
    45.434   495.232     0.150
    45.471   498.508     0.150
    45.471   498.883     0.150
    45.993   501.775     0.150
    46.044   502.377     0.150
    46.046   503.953     0.150
    46.495   506.246     0.150
    46.508   505.758     0.150
    46.612   505.184     0.150
    46.906   508.619     0.150
    47.001   510.707     0.150
    47.001   509.453     0.150
    47.003   508.412     0.150
    47.233   511.543     0.150
    47.303   511.582     0.150
    47.883   515.719     0.150
    48.178   518.637     0.150
    49.004   523.904     0.150
    49.149   524.654     0.150
    49.280   526.197     0.150
    50.037   531.719     0.150
    50.319   534.371     0.150
    50.579   537.094     0.150
    50.706   538.664     0.150
    50.932   539.742     0.150
    50.932   538.355     0.150
    51.210   541.883     0.150
    51.210   541.053     0.150
    51.249   543.201     0.150
    51.376   544.014     0.150
    51.376   542.328     0.150
    51.435   543.084     0.150
    51.650   543.504     0.150
    51.770   545.277     0.150
    51.959   546.990     0.150
    52.137   548.721     0.150
    52.310   550.285     0.150
    52.512   550.783     0.150
    52.793   553.377     0.150
    53.081   554.682     0.150
    53.123   555.213     0.150
    53.421   557.658     0.150
    53.629   558.965     0.150
    53.820   560.129     0.150
    53.967   561.729     0.150
    54.183   562.941     0.150
    54.212   563.295     0.150
    54.381   564.148     0.150
    54.410   566.285     0.150
    54.710   567.803     0.150
    54.710   565.867     0.150
    54.873   567.562     0.150
    55.236   570.051     0.150
    55.468   572.053     0.150
    55.551   571.246     0.150
    55.672   573.193     0.150
    55.707   573.414     0.150
    55.821   574.113     0.150
    55.872   574.566     0.150
    55.877   574.359     0.150
    56.033   575.854     0.150
    56.181   577.164     0.150
    56.223   577.615     0.150
    56.184   577.906     0.150
    56.256   578.191     0.150
    56.283   577.434     0.150
    56.403   578.480     0.150
    56.415   578.590     0.150
    56.696   580.354     0.150
    56.973   581.789     0.150
    57.020   583.033     0.150
    57.021   582.881     0.150
    57.146   583.598     0.150
    57.185   585.453     0.150
    57.198   584.992     0.150
    57.198   585.232     0.150
    57.198   584.172     0.150
    57.202   584.812     0.150
    57.268   585.822     0.150
    57.268   583.715     0.150
    57.336   584.881     0.150
    57.401   585.473     0.150
    57.439   585.889     0.150
    57.583   585.559     0.150
    57.592   586.314     0.150
    57.600   585.713     0.150
    57.604   585.996     0.150
    57.749   587.309     0.150
    57.784   587.889     0.150
    57.788   587.816     0.150
    57.827   589.322     0.150
    58.009   589.584     0.150
    58.079   590.439     0.150
    58.133   590.527     0.150
    58.290   591.367     0.150
    58.475   591.461     0.150
    58.479   593.422     0.150
    58.697   593.232     0.150
    58.778   594.609     0.150
    58.800   593.887     0.150
    59.067   596.113     0.150
    59.096   595.949     0.150
    59.091   596.482     0.150
    59.194   597.572     0.150
    59.254   597.281     0.150
    59.605   599.174     0.150
    59.610   600.732     0.150
    59.651   600.080     0.150
    59.664   599.695     0.150
    59.797   602.332     0.150
    59.883   600.775     0.150
    59.914   601.936     0.150
    60.214   603.691     0.150
    60.220   604.605     0.150
    60.350   606.152     0.150
    60.450   605.666     0.150
    60.481   608.252     0.150
    60.560   606.254     0.150
    61.647   615.172     0.150
    62.049   617.643     0.150
    63.538   629.158     0.150
    63.738   629.072     0.150
    64.348   632.072     0.150
    65.050   638.043     0.150
    65.444   639.633     0.150
    65.638   642.002     0.150
    65.638   640.699     0.150
    75.774   704.344     0.150
    82.855   743.184     0.150
    83.676   745.973     0.150
    84.998   753.732     0.150
    85.671   755.607     0.150
    91.920  1003.457     0.150
    93.728   794.207     0.150
   115.503  1123.434     0.150
   118.765  1126.934     0.150
   119.091  1127.633     0.150
   128.775  1145.258     0.150
   131.961  1152.232     0.150
     0.190     5.582     0.150
     0.190     8.988     0.150
     0.167     5.430     0.150
     0.167     8.391     0.150
     0.249     6.648     0.150
     0.249    10.422     0.150
     0.592    11.871     0.150
     0.811    15.391     0.150
     0.811    25.852     0.150
     1.129    21.469     0.150
     1.129    36.711     0.150
     1.145    21.102     0.150
     1.145    35.430     0.150
     1.347    24.930     0.150
     1.347    42.270     0.150
     1.499    27.559     0.150
     1.499    46.059     0.150
     1.571    27.379     0.150
     1.571    45.230     0.150
     1.611    28.020     0.150
     1.611    48.832     0.150
     1.660    29.289     0.150
     1.660    48.961     0.150
     1.618    28.680     0.150
     1.618    49.820     0.150
     1.864    32.711     0.150
     1.864    53.961     0.150
     1.883    32.352     0.150
     1.883    55.672     0.150
     1.922    33.219     0.150
     1.922    57.410     0.150
     2.080    35.238     0.150
     2.080    60.480     0.150
     2.156    38.551     0.150
     2.156    63.531     0.150
     2.162    35.660     0.150
     2.162    62.910     0.150
     2.177    37.750     0.150
     2.177    67.781     0.150
     2.476    41.160     0.150
     2.476    68.320     0.150
     2.491    42.820     0.150
     2.491    66.141     0.150
     2.501    40.691     0.150
     2.501    74.680     0.150
     2.500    40.910     0.150
     2.500    71.051     0.150
     2.500    40.910     0.150
     2.500    71.051     0.150
     2.502    41.879     0.150
     2.502    75.000     0.150
     2.504    41.879     0.150
     2.504    74.340     0.150
     2.519    70.820     0.150
     2.584    42.449     0.150
     2.584    70.059     0.150
     2.526    42.762     0.150
     2.526    69.262     0.150
     2.574    42.539     0.150
     2.574    72.859     0.150
     2.588    42.660     0.150
     2.588    43.680     0.150
     2.588    73.840     0.150
     2.588    74.898     0.150
     2.588    43.680     0.150
     2.588    73.840     0.150
     2.588    43.559     0.150
     2.588    76.320     0.150
     2.601    42.469     0.150
     2.601    74.672     0.150
     2.613    84.219     0.150
     2.616    43.211     0.150
     2.616    74.969     0.150
     2.634    43.672     0.150
     2.634    77.801     0.150
     2.657    43.891     0.150
     2.657    77.801     0.150
     2.687    48.680     0.150
     2.687    79.730     0.150
     2.692    43.719     0.150
     2.692    77.500     0.150
     2.701    51.012     0.150
     2.701    75.699     0.150
     2.715    43.969     0.150
     2.715    79.570     0.150
     2.747    45.020     0.150
     2.747    76.609     0.150
     2.760    44.879     0.150
     2.760    78.672     0.150
     2.775    44.539     0.150
     2.775    78.602     0.150
     2.849    45.500     0.150
     2.849    80.148     0.150
     2.870    46.691     0.150
     2.870    79.691     0.150
     2.869    46.691     0.150
     2.869    79.691     0.150
     2.878    45.480     0.150
     2.878    84.148     0.150
     2.857    47.172     0.150
     2.857    79.941     0.150
     2.897    46.629     0.150
     2.897    86.180     0.150
     2.969    53.000     0.150
     2.969    81.770     0.150
     3.091    52.629     0.150
     3.091    84.961     0.150
     3.107    54.031     0.150
     3.107    87.949     0.150
     3.188    53.531     0.150
     3.188    91.480     0.150
     3.206    51.730     0.150
     3.206    88.012     0.150
     3.244    51.141     0.150
     3.244    92.539     0.150
     3.456    58.371     0.150
     3.456    93.930     0.150
     3.607    56.719     0.150
     3.607    93.621     0.150
     3.562    54.879     0.150
     3.562    98.160     0.150
     3.563    54.879     0.150
     3.563    98.160     0.150
     3.775    58.199     0.150
     3.775   102.551     0.150
     3.781    57.301     0.150
     3.853    59.691     0.150
     3.853   103.320     0.150
     3.933    58.762     0.150
     3.933   108.852     0.150
     3.965    68.820     0.150
     4.238    65.039     0.150
     4.238   119.711     0.150
     4.289    68.379     0.150
     4.289   117.391     0.150
     4.473    70.512     0.150
     4.473   116.988     0.150
     4.565    73.699     0.150
     4.565   124.148     0.150
     4.569    72.922     0.150
     4.569   122.539     0.150
     4.575    73.180     0.150
     4.575   126.219     0.150
     4.597    72.922     0.150
     4.597   117.809     0.150
     4.621   120.969     0.150
     4.616    74.359     0.150
     4.616   129.129     0.150
     4.635    68.957     0.150
     4.635   120.930     0.150
     4.635   145.031     0.150
     4.635    70.172     0.150
     4.635   124.582     0.150
     4.707    73.988     0.150
     4.707   126.359     0.150
     4.718    69.770     0.150
     4.718   129.832     0.150
     4.842    76.191     0.150
     4.842   130.172     0.150
     5.086   151.480     0.150
     5.355    80.102     0.150
     5.355   145.660     0.150
     5.378    80.461     0.150
     5.378   148.199     0.150
     5.743    85.512     0.150
     5.743   148.680     0.150
     6.226    92.590     0.150
     6.226   165.750     0.150
     6.277    96.199     0.150
     6.277   170.582     0.150
     6.316   166.969     0.150
     6.331    95.332     0.150
     6.331   158.699     0.150
     6.536   100.141     0.150
     6.536    99.801     0.150
     6.536   176.551     0.150
     7.285   109.469     0.150
     7.285   108.340     0.150
     7.285   193.891     0.150
     7.384   111.012     0.150
     7.384   185.441     0.150
     7.407   144.121     0.150
     7.407   210.320     0.150
     7.420   111.590     0.150
     7.420   188.379     0.150
     7.507   112.199     0.150
     7.507   192.750     0.150
     8.082   149.340     0.150
     8.082   238.449     0.150
    12.698   180.199     0.150
    13.013   186.211     0.150
    13.013   186.422     0.150
    13.013   186.648     0.150
    14.457   203.148     0.150
    14.750   209.480     0.150
    15.251   220.871     0.150
    15.347   223.160     0.150
    15.284   216.949     0.150
    15.284   217.078     0.150
    15.606   219.039     0.150
    15.606   220.336     0.150
    15.643   221.359     0.150
    15.730   225.730     0.150
    15.730   226.840     0.150
    15.721   223.293     0.150
    15.777   223.105     0.150
    15.971   228.859     0.150
    16.023   226.012     0.150
    16.480   233.230     0.150
    16.739   235.832     0.150
    16.939   239.230     0.150
    17.302   242.879     0.150
    17.302   244.277     0.150
    17.292   240.832     0.150
    17.338   242.730     0.150
    17.338   243.816     0.150
    17.487   245.020     0.150
    17.553   243.832     0.150
    17.851   248.441     0.150
    17.856   247.891     0.150
    17.905   248.012     0.150
    17.905   249.312     0.150
    18.159   250.461     0.150
    18.379   256.289     0.150
    18.430   257.102     0.150
    18.430   257.586     0.150
    18.529   255.609     0.150
    18.529   256.348     0.150
    19.071   263.254     0.150
    19.071   264.047     0.150
    19.099   262.711     0.150
    19.223   266.727     0.150
    19.318   263.422     0.150
    19.372   264.410     0.150
    19.372   266.129     0.150
    19.434   265.859     0.150
    19.438   266.559     0.150
    19.592   267.699     0.150
    19.641   267.391     0.150
    19.714   268.082     0.150
    19.844   270.570     0.150
    19.844   271.160     0.150
    19.874   270.430     0.150
    19.915   273.711     0.150
    20.091   272.211     0.150
    20.146   272.820     0.150
    20.198   273.750     0.150
    20.258   274.000     0.150
    20.286   276.926     0.150
    20.341   276.859     0.150
    20.341   278.777     0.150
    20.472   279.980     0.150
    20.578   277.320     0.150
    20.701   280.871     0.150
    20.701   281.414     0.150
    20.792   280.410     0.150
    20.837   280.859     0.150
    20.904   280.379     0.150
    20.946   281.141     0.150
    21.047   282.922     0.150
    21.179   287.977     0.150
    21.337   288.379     0.150
    21.362   290.129     0.150
    21.362   289.414     0.150
    21.518   291.500     0.150
    21.500   288.648     0.150
    21.500   289.410     0.150
    21.566   288.879     0.150
    21.667   293.184     0.150
    21.680   293.367     0.150
    21.726   293.520     0.150
    21.726   290.512     0.150
    21.738   289.051     0.150
    21.782   293.059     0.150
    21.775   291.180     0.150
    21.807   293.422     0.150
    21.807   293.836     0.150
    21.976   296.070     0.150
    21.953   294.133     0.150
    22.078   293.379     0.150
    22.105   292.750     0.150
    22.166   298.457     0.150
    22.156   293.969     0.150
    22.286   296.430     0.150
    22.296   296.789     0.150
    22.296   297.922     0.150
    22.405   299.082     0.150
    22.405   296.398     0.150
    22.407   297.172     0.150
    22.467   298.629     0.150
    22.467   299.227     0.150
    22.539   302.766     0.150
    22.616   299.270     0.150
    22.783   301.500     0.150
    22.914   306.609     0.150
    22.979   307.809     0.150
    23.007   304.070     0.150
    23.014   303.488     0.150
    23.056   305.211     0.150
    23.190   308.121     0.150
    23.266   310.613     0.150
    23.327   311.230     0.150
    23.505   310.309     0.150
    23.505   312.012     0.150
    23.541   313.219     0.150
    23.538   309.449     0.150
    23.562   308.578     0.150
    23.562   308.969     0.150
    23.615   314.535     0.150
    23.634   309.512     0.150
    23.694   314.875     0.150
    23.739   315.277     0.150
    23.795   311.430     0.150
    23.852   315.141     0.150
    23.934   316.332     0.150
    23.976   315.195     0.150
    24.036   314.430     0.150
    24.076   317.531     0.150
    24.074   313.461     0.150
    24.118   317.895     0.150
    24.095   315.309     0.150
    24.165   317.469     0.150
    24.333   320.105     0.150
    24.350   317.410     0.150
    24.405   318.852     0.150
    24.423   319.160     0.150
    24.423   320.434     0.150
    24.573   319.309     0.150
    24.573   320.184     0.150
    24.582   319.906     0.150
    24.628   320.816     0.150
    24.777   324.363     0.150
    24.815   324.609     0.150
    24.850   324.500     0.150
    25.004   326.598     0.150
    25.134   324.621     0.150
    25.171   324.262     0.150
    25.264   325.781     0.150
    25.355   327.152     0.150
    25.457   330.234     0.150
    25.470   330.199     0.150
    25.477   330.621     0.150
    25.607   330.887     0.150
    25.638   331.961     0.150
    25.649   330.148     0.150
    25.845   333.383     0.150
    25.938   332.730     0.150
    26.171   333.637     0.150
    26.354   336.070     0.150
    26.435   337.230     0.150
    26.532   337.781     0.150
    26.542   337.762     0.150
    26.588   337.672     0.150
    26.742   341.312     0.150
    26.779   339.512     0.150
    26.878   339.141     0.150
    26.997   342.105     0.150
    27.036   343.234     0.150
    27.036   345.102     0.150
    27.069   342.469     0.150
    27.232   345.012     0.150
    27.232   344.809     0.150
    27.232   343.762     0.150
    27.232   344.359     0.150
    27.262   343.484     0.150
    27.274   344.230     0.150
    27.394   347.480     0.150
    27.398   346.395     0.150
    27.440   345.312     0.150
    27.500   346.660     0.150
    27.512   345.859     0.150
    27.762   349.082     0.150
    28.364   354.031     0.150
    28.614   356.254     0.150
    28.916   359.332     0.150
    28.947   359.984     0.150
    28.985   359.781     0.150
    29.018   361.352     0.150
    29.375   364.199     0.150
    29.471   365.164     0.150
    29.541   364.383     0.150
    29.874   368.711     0.150
    30.096   369.660     0.150
    30.309   371.836     0.150
    30.358   371.375     0.150
    30.414   373.504     0.150
    30.476   373.629     0.150
    30.712   375.051     0.150
    30.984   377.598     0.150
    31.592   382.695     0.150
    31.755   384.207     0.150
    31.809   384.797     0.150
    31.819   384.762     0.150
    31.819   385.465     0.150
    32.203   389.188     0.150
    32.234   389.008     0.150
    32.473   389.820     0.150
    32.473   390.422     0.150
    32.743   392.660     0.150
    32.836   393.828     0.150
    32.976   394.809     0.150
    33.320   397.211     0.150
    33.531   398.836     0.150
    33.543   399.941     0.150
    33.653   399.840     0.150
    34.465   407.520     0.150
    34.489   409.500     0.150
    35.146   413.277     0.150
    36.040   421.398     0.150
    37.431   433.391     0.150
    37.911   436.770     0.150
    39.414   449.949     0.150
    45.557   501.539     0.150
    45.617   499.109     0.150
    45.617   499.441     0.150
    46.225   506.938     0.150
    46.730   509.926     0.150
    46.743   510.082     0.150
    46.847   508.586     0.150
    46.847   600.910     0.150
    46.847   509.961     0.150
    47.137   514.129     0.150
    47.234   514.441     0.150
    47.234   515.000     0.150
    47.235   514.137     0.150
    48.118   521.875     0.150
    48.277   523.055     0.150
    48.759   527.102     0.150
    49.222   529.430     0.150
    49.240   529.734     0.150
    49.381   531.336     0.150
    49.513   532.762     0.150
    49.881   535.398     0.150
    50.127   536.102     0.150
    50.269   538.004     0.150
    50.289   538.160     0.150
    50.938   543.152     0.150
    51.058   543.906     0.150
    51.166   544.504     0.150
    51.443   546.371     0.150
    51.483   546.777     0.150
    51.583   548.164     0.150
    51.608   548.266     0.150
    51.883   550.062     0.150
    52.002   551.215     0.150
    52.369   553.855     0.150
    52.543   554.914     0.150
    52.583   555.551     0.150
    52.744   556.719     0.150
    53.026   558.848     0.150
    53.313   561.012     0.150
    53.356   561.133     0.150
    53.655   563.172     0.150
    53.861   564.777     0.150
    54.051   566.250     0.150
    54.051   566.461     0.150
    54.200   567.145     0.150
    54.352   568.625     0.150
    54.417   568.059     0.150
    54.601   569.898     0.150
    54.614   569.559     0.150
    54.642   569.801     0.150
    54.684   570.676     0.150
    54.700   569.551     0.150
    54.799   571.668     0.150
    54.945   571.484     0.150
    55.102   573.277     0.150
    55.144   573.297     0.150
    55.179   572.715     0.150
    55.185   573.844     0.150
    55.264   575.039     0.150
    55.301   574.891     0.150
    55.467   576.660     0.150
    55.464   575.160     0.150
    55.464   576.074     0.150
    55.699   577.809     0.150
    55.773   577.289     0.150
    55.787   577.332     0.150
    55.787   577.434     0.150
    55.904   578.891     0.150
    55.935   578.770     0.150
    55.940   579.102     0.150
    56.049   579.996     0.150
    56.105   580.934     0.150
    56.110   580.789     0.150
    56.142   580.906     0.150
    56.155   580.422     0.150
    56.262   581.672     0.150
    56.411   582.129     0.150
    56.412   582.824     0.150
    56.457   582.609     0.150
    56.488   583.258     0.150
    56.517   582.645     0.150
    56.622   584.008     0.150
    56.633   583.801     0.150
    56.644   584.184     0.150
    56.802   584.883     0.150
    56.931   585.902     0.150
    57.020   586.527     0.150
    57.124   587.098     0.150
    57.208   586.832     0.150
    57.208   586.984     0.150
    57.250   588.473     0.150
    57.253   587.977     0.150
    57.379   589.273     0.150
    57.431   588.461     0.150
    57.431   589.070     0.150
    57.498   589.926     0.150
    57.633   590.934     0.150
    57.673   591.043     0.150
    57.685   591.352     0.150
    57.761   591.172     0.150
    57.813   592.527     0.150
    57.821   592.016     0.150
    58.012   594.785     0.150
    58.015   593.637     0.150
    58.244   595.016     0.150
    58.283   594.895     0.150
    58.302   595.590     0.150
    58.297   595.324     0.150
    58.366   595.973     0.150
    58.396   595.844     0.150
    58.457   596.812     0.150
    58.512   597.043     0.150
    58.523   597.332     0.150
    58.561   596.969     0.150
    58.604   597.219     0.150
    58.602   597.379     0.150
    58.639   598.242     0.150
    58.710   597.938     0.150
    58.709   597.184     0.150
    58.826   599.902     0.150
    58.903   600.523     0.150
    58.931   600.254     0.150
    58.962   600.746     0.150
    58.967   600.332     0.150
    59.007   600.191     0.150
    59.016   600.496     0.150
    59.030   600.094     0.150
    59.189   601.293     0.150
    59.320   602.805     0.150
    59.331   602.500     0.150
    59.420   603.621     0.150
    59.484   603.312     0.150
    59.500   603.668     0.150
    59.626   604.164     0.150
    59.835   605.926     0.150
    59.870   605.703     0.150
    59.886   606.125     0.150
    60.029   606.953     0.150
    60.148   608.219     0.150
    60.447   609.965     0.150
    60.700   612.145     0.150
    60.778   613.164     0.150
    60.785   612.500     0.150
    60.964   614.211     0.150
    61.006   615.035     0.150
    63.887   633.473     0.150
    64.227   637.289     0.150
    64.578   638.992     0.150
    83.085   745.512     0.150
    83.781   748.309     0.150
    86.187   762.680     0.150
   128.778  1148.309     0.150
   129.457  1150.059     0.150
   132.191  1156.262     0.150
     0.871    17.398     0.150
     0.871    27.852     0.150
     0.824    16.441     0.150
     0.824    26.309     0.150
     1.197    22.680     0.150
     1.197    22.922     0.150
     1.197    37.211     0.150
     1.327    24.230     0.150
     1.453    27.359     0.150
     1.453    47.340     0.150
     1.482    28.020     0.150
     1.482    46.242     0.150
     1.576    28.441     0.150
     1.576    47.070     0.150
     1.689    30.359     0.150
     1.810    32.129     0.150
     1.810    55.250     0.150
     1.987    34.680     0.150
     1.987    60.242     0.150
     1.864    33.242     0.150
     1.864    60.969     0.150
     2.289    39.602     0.150
     2.289    72.949     0.150
     2.289    39.602     0.150
     2.289    72.949     0.150
     2.403    41.391     0.150
     2.403    71.539     0.150
     2.495    41.730     0.150
     2.495    71.801     0.150
     2.529    41.730     0.150
     2.529    75.059     0.150
     2.536    44.852     0.150
     2.536    74.250     0.150
     2.635    43.801     0.150
     2.635    82.691     0.150
     2.635    43.820     0.150
     2.635    82.691     0.150
     2.682    43.551     0.150
     2.682    77.969     0.150
     2.599    42.680     0.150
     2.599    77.531     0.150
     2.752    47.160     0.150
     2.752    79.148     0.150
     2.793    47.879     0.150
     2.793    78.332     0.150
     2.820    47.789     0.150
     2.820    82.039     0.150
     2.850    49.051     0.150
     2.850    82.930     0.150
     2.850    82.730     0.150
     2.857    50.379     0.150
     2.857    86.379     0.150
     2.871    50.309     0.150
     2.871    47.109     0.150
     2.871    48.430     0.150
     2.871    80.160     0.150
     2.871    85.480     0.150
     2.872    47.109     0.150
     2.872    80.160     0.150
     2.892    54.551     0.150
     2.892    84.301     0.150
     2.957    50.469     0.150
     2.957    85.289     0.150
     2.974    50.941     0.150
     2.974    85.770     0.150
     2.984    50.492     0.150
     2.984    86.559     0.150
     3.032    87.852     0.150
     3.131    53.301     0.150
     3.131    88.129     0.150
     3.131    54.480     0.150
     3.131    91.180     0.150
     3.316    56.121     0.150
     3.316    96.770     0.150
     3.363    57.762     0.150
     3.363    99.789     0.150
     3.336    53.770     0.150
     3.336    92.891     0.150
     3.387    57.742     0.150
     3.387    97.539     0.150
     3.597    55.270     0.150
     3.607    62.309     0.150
     3.607   101.449     0.150
     3.835    63.430     0.150
     3.835   103.332     0.150
     3.834   103.332     0.150
     3.814    60.852     0.150
     3.814   103.309     0.150
     3.953    60.148     0.150
     3.953   110.910     0.150
     4.025    62.766     0.150
     4.025   123.414     0.150
     4.025    62.660     0.150
     4.025   108.262     0.150
     4.100    60.582     0.150
     4.275   123.430     0.150
     4.443    75.000     0.150
     4.443   128.070     0.150
     4.509    69.699     0.150
     4.509   119.121     0.150
     4.679    69.859     0.150
     4.806   124.582     0.150
     4.758    72.648     0.150
     4.758   128.281     0.150
     5.041    82.051     0.150
     5.041   140.031     0.150
     5.204    81.930     0.150
     5.204   141.262     0.150
     5.289    83.750     0.150
     5.289   146.691     0.150
     5.294    82.762     0.150
     5.301    84.109     0.150
     5.301   145.941     0.150
     5.321    84.469     0.150
     5.321   147.699     0.150
     5.340    85.922     0.150
     5.340   146.949     0.150
     5.355    84.109     0.150
     5.355   146.949     0.150
     5.485    99.809     0.150
     5.485   166.750     0.150
     5.439    85.320     0.150
     5.637    85.059     0.150
     5.675    87.430     0.150
     5.675   156.930     0.150
     6.112    93.352     0.150
     6.112   182.191     0.150
     6.477   175.219     0.150
     6.588    98.301     0.150
     6.588   175.359     0.150
     6.621   100.750     0.150
     7.118   109.461     0.150
     7.118   107.922     0.150
     7.118   193.379     0.150
     8.420   125.340     0.150
     8.420   222.660     0.150
     8.796   130.180     0.150
    10.882   154.289     0.150
    11.826   171.840     0.150
    11.826   169.961     0.150
    12.999   185.930     0.150
    13.517   427.520     0.150
    13.517   195.070     0.150
    16.247   230.512     0.150
    17.501   244.285     0.150
    17.552   248.520     0.150
    17.599   246.410     0.150
    17.772   248.621     0.150
    18.446   258.211     0.150
    18.514   257.473     0.150
    19.055   266.461     0.150
    19.055   266.176     0.150
    19.600   268.559     0.150
    19.587   268.789     0.150
    19.587   270.219     0.150
    19.587   270.562     0.150
    19.777   270.367     0.150
    19.877   275.543     0.150
    20.504   278.148     0.150
    20.500   282.441     0.150
    20.904   282.660     0.150
    20.910   282.910     0.150
    21.020   287.832     0.150
    21.080   288.230     0.150
    21.481   292.398     0.150
    21.841   296.340     0.150
    21.957   297.199     0.150
    21.957   297.473     0.150
    21.993   293.160     0.150
    21.993   293.754     0.150
    22.170   299.930     0.150
    22.305   300.340     0.150
    22.315   300.391     0.150
    22.315   299.922     0.150
    22.344   301.664     0.150
    22.352   301.727     0.150
    22.368   301.824     0.150
    22.638   304.789     0.150
    22.701   305.426     0.150
    22.819   306.465     0.150
    22.838   307.422     0.150
    23.027   306.391     0.150
    23.127   309.441     0.150
    23.202   310.766     0.150
    23.210   310.242     0.150
    23.210   310.988     0.150
    23.566   314.082     0.150
    23.659   312.090     0.150
    23.655   315.164     0.150
    23.852   317.059     0.150
    23.966   316.289     0.150
    23.934   317.797     0.150
    23.984   317.754     0.150
    24.188   320.312     0.150
    24.281   316.867     0.150
    24.421   318.867     0.150
    24.434   318.980     0.150
    24.431   321.801     0.150
    24.551   320.648     0.150
    24.580   324.242     0.150
    24.836   325.961     0.150
    24.926   325.570     0.150
    25.003   327.570     0.150
    25.084   327.512     0.150
    25.225   330.375     0.150
    25.466   328.957     0.150
    25.485   332.367     0.150
    25.518   332.465     0.150
    25.677   334.094     0.150
    25.820   335.266     0.150
    26.002   333.547     0.150
    26.072   336.840     0.150
    26.177   335.270     0.150
    26.223   338.121     0.150
    26.613   338.820     0.150
    26.946   341.941     0.150
    27.277   345.039     0.150
    27.402   345.988     0.150
    27.428   346.930     0.150
    27.498   346.641     0.150
    27.597   350.742     0.150
    27.675   352.219     0.150
    27.675   351.910     0.150
    27.735   350.699     0.150
    27.735   350.996     0.150
    27.735   351.242     0.150
    27.735   350.219     0.150
    27.735   350.570     0.150
    27.987   354.453     0.150
    28.540   356.512     0.150
    28.655   359.461     0.150
    28.977   362.051     0.150
    29.509   364.910     0.150
    29.857   370.191     0.150
    29.857   369.820     0.150
    30.027   371.742     0.150
    30.272   371.891     0.150
    30.321   375.590     0.150
    30.742   377.246     0.150
    30.922   379.781     0.150
    30.997   381.070     0.150
    31.367   383.051     0.150
    31.871   386.715     0.150
    31.921   388.750     0.150
    31.998   389.352     0.150
    32.020   386.562     0.150
    32.217   389.797     0.150
    32.704   395.289     0.150
    32.704   394.102     0.150
    32.727   395.566     0.150
    33.815   401.020     0.150
    38.270   441.359     0.150
    44.106   489.898     0.150
    45.629   501.121     0.150
    45.629   500.492     0.150
    46.784   512.129     0.150
    46.857   512.895     0.150
    47.248   515.852     0.150
    47.283   514.172     0.150
    47.781   519.914     0.150
    47.791   519.828     0.150
    48.804   527.656     0.150
    48.821   527.789     0.150
    48.835   528.051     0.150
    49.720   533.355     0.150
    49.935   536.246     0.150
    50.058   537.465     0.150
    50.442   540.824     0.150
    50.827   543.457     0.150
    51.477   547.977     0.150
    51.499   547.973     0.150
    51.611   548.754     0.150
    51.697   549.359     0.150
    51.989   551.863     0.150
    52.018   552.117     0.150
    52.156   553.195     0.150
    52.166   554.852     0.150
    52.166   553.367     0.150
    52.232   553.465     0.150
    52.434   555.203     0.150
    52.562   555.980     0.150
    52.762   557.766     0.150
    52.926   558.805     0.150
    53.085   559.820     0.150
    53.150   561.066     0.150
    53.306   561.816     0.150
    53.574   563.348     0.150
    53.715   564.758     0.150
    53.873   565.730     0.150
    53.898   566.129     0.150
    54.188   568.473     0.150
    54.417   569.559     0.150
    54.621   571.664     0.150
    54.759   571.941     0.150
    54.954   573.262     0.150
    54.954   573.094     0.150
    55.154   574.961     0.150
    55.167   574.852     0.150
    55.204   575.797     0.150
    55.371   576.352     0.150
    55.672   577.895     0.150
    55.695   578.539     0.150
    55.695   578.148     0.150
    55.847   580.410     0.150
    55.847   579.234     0.150
    55.991   580.340     0.150
    56.001   580.730     0.150
    56.035   581.383     0.150
    56.272   582.191     0.150
    56.272   582.023     0.150
    56.272   582.688     0.150
    56.328   583.961     0.150
    56.468   584.355     0.150
    56.492   584.449     0.150
    56.651   585.941     0.150
    56.651   585.539     0.150
    56.665   585.375     0.150
    56.943   587.398     0.150
    56.995   587.246     0.150
    57.044   587.961     0.150
    57.046   588.074     0.150
    57.247   589.164     0.150
    57.352   590.301     0.150
    57.352   590.469     0.150
    57.453   590.484     0.150
    57.592   592.035     0.150
    57.640   591.359     0.150
    57.640   591.773     0.150
    57.708   593.176     0.150
    57.808   593.543     0.150
    57.838   593.898     0.150
    57.922   594.051     0.150
    57.983   594.891     0.150
    57.983   594.770     0.150
    57.983   594.332     0.150
    58.078   595.484     0.150
    58.199   595.754     0.150
    58.198   596.129     0.150
    58.323   596.863     0.150
    58.353   597.199     0.150
    58.386   597.492     0.150
    58.390   597.148     0.150
    58.451   597.352     0.150
    58.585   598.641     0.150
    58.622   599.320     0.150
    58.687   599.367     0.150
    58.737   600.270     0.150
    58.765   599.660     0.150
    58.830   600.309     0.150
    58.912   600.953     0.150
    58.963   602.094     0.150
    59.077   601.594     0.150
    59.092   602.664     0.150
    59.164   602.801     0.150
    59.169   602.891     0.150
    59.170   603.008     0.150
    59.204   602.828     0.150
    59.246   603.215     0.150
    59.285   603.480     0.150
    59.285   603.250     0.150
    59.452   604.191     0.150
    59.446   604.793     0.150
    59.489   604.406     0.150
    59.525   604.844     0.150
    59.587   605.582     0.150
    59.598   605.633     0.150
    59.615   605.543     0.150
    59.588   607.109     0.150
    59.835   606.844     0.150
    60.032   609.020     0.150
    60.063   608.453     0.150
    60.066   608.703     0.150
    60.111   609.105     0.150
    60.178   609.164     0.150
    60.328   610.484     0.150
    60.344   610.223     0.150
    60.398   610.867     0.150
    60.436   611.531     0.150
    60.442   611.469     0.150
    60.442   611.570     0.150
    60.450   611.703     0.150
    60.586   612.211     0.150
    60.678   612.430     0.150
    60.698   613.238     0.150
    60.726   613.184     0.150
    60.755   612.883     0.150
    60.974   615.086     0.150
    61.022   615.273     0.150
    61.056   616.441     0.150
    61.234   617.664     0.150
    61.240   617.262     0.150
    61.299   617.004     0.150
    61.426   618.215     0.150
    61.488   618.688     0.150
    61.550   619.238     0.150
    65.474   643.301     0.150
    71.897   682.820     0.150
    83.485   750.047     0.150
    85.869   762.250     0.150
     0.110     6.422     0.150
     0.110    11.391     0.150
     0.323     8.703     0.150
     0.323    14.875     0.150
     0.698    13.984     0.150
     0.698    24.008     0.150
     0.726    14.234     0.150
     0.726    24.172     0.150
     0.807    15.227     0.150
     0.807    26.141     0.150
     0.819    15.531     0.150
     0.819    26.711     0.150
     1.011    18.234     0.150
     1.011    31.211     0.150
     0.957    17.477     0.150
     0.957    30.266     0.150
     0.991    18.352     0.150
     0.991    31.734     0.150
     1.393    24.711     0.150
     1.393    43.477     0.150
     1.454    24.070     0.150
     1.454    42.008     0.150
     1.596    27.477     0.150
     1.596    49.062     0.150
     1.735    30.336     0.150
     1.735    52.820     0.150
     1.811    30.422     0.150
     1.811    54.203     0.150
     1.861    30.656     0.150
     1.861    53.617     0.150
     2.016    32.805     0.150
     2.016    59.227     0.150
     2.210    36.070     0.150
     2.210    65.242     0.150
     2.283    37.492     0.150
     2.283    63.516     0.150
     2.407    38.070     0.150
     2.407    64.258     0.150
     2.445    41.227     0.150
     2.445    71.516     0.150
     2.450    39.375     0.150
     2.450    72.797     0.150
     2.561    41.422     0.150
     2.561    71.336     0.150
     2.572    41.461     0.150
     2.572    70.695     0.150
     2.697    40.031     0.150
     2.697    78.031     0.150
     2.814    45.594     0.150
     2.814    76.875     0.150
     3.134    84.602     0.150
     3.250    50.641     0.150
     3.314    51.016     0.150
     3.314    91.477     0.150
     3.427    52.781     0.150
     3.427    88.867     0.150
     3.592    58.156     0.150
     3.559    94.508     0.150
     3.680    58.836     0.150
     3.684    57.867     0.150
     3.690    60.984     0.150
     3.690   104.133     0.150
     3.712    57.867     0.150
     3.712    99.766     0.150
     3.731    62.547     0.150
     3.731   105.047     0.150
     3.751    58.938     0.150
     3.829    64.305     0.150
     3.920    58.688     0.150
     4.449   115.141     0.150
     4.508    75.094     0.150
     4.508   131.906     0.150
     4.870   125.758     0.150
     0.282     8.906     0.150
     0.282    15.496     0.150
     0.353     9.547     0.150
     0.353    16.734     0.150
     0.594    12.484     0.150
     0.594    21.453     0.150
     0.649    13.613     0.150
     0.649    23.047     0.150
     0.745    14.375     0.150
     0.745    25.176     0.150
     0.771    14.555     0.150
     0.771    24.887     0.150
     0.980    18.273     0.150
     0.980    31.934     0.150
     1.118    20.336     0.150
     1.118    34.477     0.150
     1.243    21.727     0.150
     1.243    35.094     0.150
     1.228    21.965     0.150
     1.228    37.695     0.150
     1.303    22.523     0.150
     1.303    38.625     0.150
     1.582    27.504     0.150
     1.582    47.504     0.150
     1.636    27.715     0.150
     1.636    47.855     0.150
     1.647    27.305     0.150
     1.647    47.496     0.150
     1.786    29.406     0.150
     1.786    51.023     0.150
     1.808    30.934     0.150
     1.808    51.734     0.150
     1.792    29.965     0.150
     1.792    50.773     0.150
     1.803    30.715     0.150
     1.803    52.184     0.150
     1.807    30.406     0.150
     1.807    51.766     0.150
     1.892    31.273     0.150
     1.892    55.105     0.150
     2.040    33.934     0.150
     2.040    59.887     0.150
     2.103    34.176     0.150
     2.103    60.934     0.150
     2.120    35.516     0.150
     2.120    60.727     0.150
     2.129    35.766     0.150
     2.129    61.547     0.150
     2.144    37.434     0.150
     2.144    62.926     0.150
     2.142    35.324     0.150
     2.142    63.363     0.150
     2.215    33.977     0.150
     2.483    40.797     0.150
     2.524    72.703     0.150
     2.643    41.195     0.150
     2.643    73.805     0.150
     2.664    42.086     0.150
     2.664    80.445     0.150
     2.796    43.926     0.150
     2.796    77.145     0.150
     2.905    47.656     0.150
     3.493    52.695     0.150
     3.588    53.797     0.150
     3.588    98.734     0.150
     3.721    56.156     0.150
     3.721    97.496     0.150
     4.563    67.254     0.150
     4.563   118.547     0.150
     0.421     9.345     0.150
     0.421    14.595     0.150
     0.455     9.675     0.150
     0.858    16.625     0.150
     1.075    20.104     0.150
     1.268    23.625     0.150
     1.268    39.484     0.150
     1.268    38.085     0.150
     1.245    38.515     0.150
     1.313    41.585     0.150
     1.427    26.925     0.150
     1.427    45.814     0.150
     1.427    43.814     0.150
     1.724    30.864     0.150
     1.724    51.375     0.150
     1.724    50.375     0.150
     1.731    32.024     0.150
     1.731    53.274     0.150
     1.818    31.685     0.150
     1.818    53.734     0.150
     1.780    31.925     0.150
     1.780    55.085     0.150
     1.780    53.085     0.150
     1.925    32.414     0.150
     1.925    53.885     0.150
     1.852    56.125     0.150
     1.971    60.484     0.150
     1.971    57.484     0.150
     2.130    35.984     0.150
     2.130    59.494     0.150
     2.224    37.114     0.150
     2.224    67.074     0.150
     2.286    38.484     0.150
     2.286    66.715     0.150
     2.328    40.515     0.150
     2.328    66.055     0.150
     2.323    65.755     0.150
     2.525    42.005     0.150
     2.525    79.895     0.150
     2.525    42.005     0.150
     2.525    79.895     0.150
     2.544    44.795     0.150
     2.544    78.255     0.150
     2.555    43.034     0.150
     2.555    74.395     0.150
     2.566    43.095     0.150
     2.566    74.314     0.150
     2.598    43.064     0.150
     2.598    75.324     0.150
     2.594    43.944     0.150
     2.594    72.045     0.150
     2.601    43.534     0.150
     2.601    76.484     0.150
     2.617    43.685     0.150
     2.617    75.385     0.150
     2.619    43.534     0.150
     2.619    44.725     0.150
     2.619    75.895     0.150
     2.671    45.034     0.150
     2.671    78.204     0.150
     2.670    45.895     0.150
     2.670    82.824     0.150
     2.670    45.034     0.150
     2.670    78.204     0.150
     2.670    79.295     0.150
     2.671    44.265     0.150
     2.671    77.104     0.150
     2.679    44.345     0.150
     2.679    76.204     0.150
     2.694    46.015     0.150
     2.694    78.664     0.150
     2.694    43.994     0.150
     2.694    77.564     0.150
     2.694    85.324     0.150
     2.676    44.954     0.150
     2.676    79.484     0.150
     2.665    44.215     0.150
     2.665    78.645     0.150
     2.716    45.675     0.150
     2.716    81.335     0.150
     2.651    76.704     0.150
     2.650    76.704     0.150
     2.745    45.685     0.150
     2.745    79.604     0.150
     2.658    45.875     0.150
     2.658    76.925     0.150
     2.703    78.005     0.150
     2.678    45.805     0.150
     2.678    77.444     0.150
     2.784    44.555     0.150
     2.791    45.744     0.150
     2.791    81.625     0.150
     2.809    47.595     0.150
     2.809    81.335     0.150
     2.839    48.435     0.150
     2.839    81.475     0.150
     2.938    48.005     0.150
     2.938    84.324     0.150
     3.106    51.465     0.150
     3.106    88.494     0.150
     3.164    93.484     0.150
     3.172    55.215     0.150
     3.172    93.204     0.150
     3.326    56.585     0.150
     3.420    57.354     0.150
     3.420   103.835     0.150
     3.420    57.545     0.150
     3.420   100.814     0.150
     3.347    89.904     0.150
     3.645   103.225     0.150
     3.646    59.045     0.150
     3.646   103.225     0.150
     3.701    57.335     0.150
     3.701   101.704     0.150
     3.657   102.034     0.150
     3.698    57.064     0.150
     4.040    62.484     0.150
     4.040   104.135     0.150
     4.129    73.744     0.150
     4.129   114.085     0.150
     4.206    63.295     0.150
     4.206   117.654     0.150
     4.437   122.185     0.150
     4.410    68.324     0.150
     4.549   126.635     0.150
     4.737    74.354     0.150
     4.737   144.185     0.150
     4.652    72.364     0.150
     4.652   122.244     0.150
     4.826    75.215     0.150
     4.826   148.715     0.150
     4.830    76.675     0.150
     4.830   147.104     0.150
     4.837    76.564     0.150
     4.837   149.395     0.150
     4.858    76.694     0.150
     4.858   148.164     0.150
     4.877    78.805     0.150
     4.877   149.835     0.150
     4.887    76.015     0.150
     4.887   145.385     0.150
     4.902    86.935     0.150
     4.902   144.555     0.150
     4.971    77.564     0.150
     4.971   149.265     0.150
     5.221    77.675     0.150
     5.221   147.595     0.150
     5.134    78.164     0.150
     5.134   144.284     0.150
     5.954    91.284     0.150
     5.954   162.755     0.150
     6.008    90.305     0.150
     6.008   175.784     0.150
     6.082    93.704     0.150
     6.079    92.284     0.150
     6.079   156.085     0.150
     6.381    93.265     0.150
     6.743   179.734     0.150
     7.043   103.364     0.150
     7.164   191.015     0.150
     7.251   109.814     0.150
     7.251   186.694     0.150
    11.197   160.714     0.150
    11.197   279.063     0.150
    12.749   184.635     0.150
    12.812   185.114     0.150
    13.193   190.345     0.150
    13.457   193.305     0.150
    13.761   197.564     0.150
    14.279   205.194     0.150
    14.568   208.675     0.150
    14.938   214.614     0.150
    15.184   217.314     0.150
    15.263   218.375     0.150
    15.374   219.085     0.150
    15.465   219.663     0.150
    15.632   224.694     0.150
    15.645   222.305     0.150
    15.733   226.265     0.150
    15.896   226.994     0.150
    16.046   228.064     0.150
    16.098   230.154     0.150
    16.171   230.114     0.150
    16.191   230.904     0.150
    16.335   230.914     0.150
    16.359   233.685     0.150
    16.440   234.534     0.150
    16.605   236.864     0.150
    16.720   234.805     0.150
    16.986   239.824     0.150
    17.018   239.555     0.150
    17.059   240.095     0.150
    17.159   242.345     0.150
    17.492   246.204     0.150
    17.507   246.824     0.150
    17.562   245.694     0.150
    17.588   245.435     0.150
    17.928   250.765     0.150
    18.015   250.475     0.150
    18.230   253.604     0.150
    18.257   253.704     0.150
    18.489   255.484     0.150
    18.568   259.364     0.150
    18.586   260.654     0.150
    18.579   256.024     0.150
    18.655   259.755     0.150
    18.725   259.104     0.150
    19.136   262.944     0.150
    19.256   266.295     0.150
    19.256   265.965     0.150
    19.289   265.545     0.150
    19.340   266.085     0.150
    19.359   266.005     0.150
    19.403   266.515     0.150
    19.438   267.074     0.150
    19.417   264.654     0.150
    19.459   269.824     0.150
    19.632   268.845     0.150
    19.751   270.055     0.150
    19.806   271.385     0.150
    19.811   271.465     0.150
    19.826   270.475     0.150
    19.816   268.654     0.150
    19.903   271.875     0.150
    19.905   272.595     0.150
    19.981   273.444     0.150
    20.125   276.895     0.150
    20.122   275.755     0.150
    20.152   275.795     0.150
    20.212   276.524     0.150
    20.239   274.875     0.150
    20.347   276.164     0.150
    20.351   278.284     0.150
    20.691   281.625     0.150
    20.699   281.024     0.150
    20.863   283.005     0.150
    20.900   282.074     0.150
    20.930   280.185     0.150
    21.006   281.135     0.150
    21.377   288.755     0.150
    21.576   292.114     0.150
    21.581   288.414     0.150
    21.603   291.034     0.150
    21.641   290.984     0.150
    21.669   291.854     0.150
    21.711   289.055     0.150
    21.753   293.975     0.150
    21.973   295.685     0.150
    21.986   295.645     0.150
    21.981   293.164     0.150
    22.033   292.404     0.150
    22.050   293.234     0.150
    22.085   293.805     0.150
    22.092   294.114     0.150
    22.380   296.685     0.150
    22.434   302.494     0.150
    22.459   299.395     0.150
    22.510   300.185     0.150
    22.606   299.984     0.150
    22.744   305.524     0.150
    22.781   305.738     0.150
    22.806   302.935     0.150
    22.838   303.125     0.150
    22.943   305.805     0.150
    23.006   306.805     0.150
    22.978   303.354     0.150
    23.016   304.555     0.150
    23.020   304.234     0.150
    23.271   308.664     0.150
    23.340   306.244     0.150
    23.406   310.295     0.150
    23.418   310.595     0.150
    23.469   311.725     0.150
    23.494   307.564     0.150
    23.529   309.284     0.150
    23.529   311.014     0.150
    23.670   312.484     0.150
    23.689   310.954     0.150
    23.762   312.015     0.150
    23.976   314.015     0.150
    24.060   317.664     0.150
    24.059   313.555     0.150
    24.152   318.154     0.150
    24.143   314.515     0.150
    24.171   316.895     0.150
    24.302   317.314     0.150
    24.343   317.734     0.150
    24.323   316.024     0.150
    24.368   319.625     0.150
    24.428   320.194     0.150
    24.408   317.074     0.150
    24.603   322.345     0.150
    24.684   322.295     0.150
    24.735   323.204     0.150
    24.739   323.255     0.150
    24.792   322.694     0.150
    25.160   327.204     0.150
    25.182   326.414     0.150
    25.225   324.164     0.150
    25.385   328.005     0.150
    25.728   332.345     0.150
    25.776   331.694     0.150
    25.876   332.265     0.150
    26.440   334.774     0.150
    26.506   336.635     0.150
    26.835   339.385     0.150
    26.874   341.225     0.150
    26.915   339.414     0.150
    26.956   342.585     0.150
    27.189   345.114     0.150
    27.266   345.694     0.150
    27.266   347.770     0.150
    27.413   346.454     0.150
    27.413   346.345     0.150
    27.413   347.494     0.150
    27.413   346.074     0.150
    27.434   344.444     0.150
    27.526   347.895     0.150
    29.548   365.404     0.150
    30.596   375.755     0.150
    30.663   376.064     0.150
    31.036   379.604     0.150
    38.039   437.875     0.150
    38.076   438.965     0.150
    45.620   500.444     0.150
    47.004   511.632     0.150
    57.630   591.595     0.150
    57.630   643.347     0.150
   128.984  1150.194     0.150
     0.231     7.582     0.150
     0.231    12.641     0.150
     0.342     8.680     0.150
     0.342    14.562     0.150
     0.360     9.203     0.150
     0.360    15.520     0.150
     0.366     8.922     0.150
     0.366    15.410     0.150
     0.438    10.191     0.150
     0.438    17.352     0.150
     0.853    16.062     0.150
     0.853    27.602     0.150
     1.009    18.180     0.150
     1.009    30.672     0.150
     1.117    19.871     0.150
     1.186    21.320     0.150
     1.186    36.520     0.150
     1.316    23.391     0.150
     1.316    41.480     0.150
     1.391    24.070     0.150
     1.391    40.410     0.150
     1.378    24.312     0.150
     1.378    42.492     0.150
     1.488    26.301     0.150
     1.488    42.531     0.150
     1.708    29.781     0.150
     1.708    51.430     0.150
     1.921    32.211     0.150
     1.921    56.730     0.150
     1.986    33.043     0.150
     1.986    58.891     0.150
     2.027    32.531     0.150
     2.027    55.051     0.150
     2.188    36.543     0.150
     2.188    66.531     0.150
     2.193    38.680     0.150
     2.193    65.043     0.150
     2.193    37.680     0.150
     2.193    67.461     0.150
     2.206    36.352     0.150
     2.206    61.973     0.150
     2.243    39.863     0.150
     2.259    37.051     0.150
     2.259    65.762     0.150
     2.288    40.152     0.150
     2.288    70.062     0.150
     2.289    65.223     0.150
     2.322    41.430     0.150
     2.322    68.621     0.150
     2.321    39.031     0.150
     2.339    65.102     0.150
     2.442    40.141     0.150
     2.442    68.133     0.150
     2.430    41.031     0.150
     2.468    42.203     0.150
     2.468    74.590     0.150
     2.500    44.070     0.150
     2.500    76.281     0.150
     2.560    44.141     0.150
     2.560    75.602     0.150
     2.569    44.402     0.150
     2.569    74.840     0.150
     2.693    47.203     0.150
     2.693    80.500     0.150
     2.783    78.770     0.150
     2.790    43.922     0.150
     2.790    77.512     0.150
     2.860    47.793     0.150
     2.860    81.461     0.150
     3.009    47.082     0.150
     3.009    83.441     0.150
     3.046    78.762     0.150
     3.249    49.922     0.150
     3.249    94.582     0.150
     3.967    63.711     0.150
     3.967   107.012     0.150
     4.052    65.551     0.150
     4.059   109.043     0.150
     4.079    67.250     0.150
     4.098    69.012     0.150
     4.206   113.113     0.150
     0.142     8.145     0.150
     0.142    13.514     0.150
     0.281     8.994     0.150
     0.281    15.225     0.150
     0.349     9.664     0.150
     0.349    16.363     0.150
     0.576    12.363     0.150
     0.576    20.734     0.150
     0.724    14.264     0.150
     0.724    24.584     0.150
     0.762    15.193     0.150
     0.762    25.795     0.150
     1.000    18.594     0.150
     1.000    31.244     0.150
     1.133    20.814     0.150
     1.133    33.625     0.150
     1.240    22.193     0.150
     1.240    38.254     0.150
     1.235    22.273     0.150
     1.235    38.014     0.150
     1.283    22.764     0.150
     1.283    38.844     0.150
     1.560    27.354     0.150
     1.560    44.404     0.150
     1.670    27.574     0.150
     1.670    46.545     0.150
     1.650    28.154     0.150
     1.650    47.244     0.150
     1.764    29.055     0.150
     1.764    48.514     0.150
     1.793    31.023     0.150
     1.793    52.955     0.150
     1.788    29.295     0.150
     1.788    50.104     0.150
     1.794    31.994     0.150
     1.794    53.914     0.150
     1.827    30.764     0.150
     1.827    52.295     0.150
     1.907    31.715     0.150
     1.907    53.564     0.150
     2.097    33.305     0.150
     2.097    57.205     0.150
     2.121    34.465     0.150
     2.121    59.805     0.150
     2.125    34.613     0.150
     2.125    59.805     0.150
     2.135    34.465     0.150
     2.135    60.104     0.150
     2.136    34.705     0.150
     2.136    61.154     0.150
     2.142    34.295     0.150
     2.142    61.443     0.150
     2.147    34.324     0.150
     2.147    60.635     0.150
     2.207    34.215     0.150
     2.207    62.174     0.150
     2.219    35.164     0.150
     2.219    64.154     0.150
     2.240    36.295     0.150
     2.240    60.844     0.150
     2.278    37.523     0.150
     2.278    62.504     0.150
     2.336    63.295     0.150
     2.380    37.674     0.150
     2.380    66.434     0.150
     2.477    39.965     0.150
     2.477    69.514     0.150
     2.536    40.205     0.150
     2.536    69.875     0.150
     2.687    42.443     0.150
     2.687    70.254     0.150
     3.181    89.684     0.150
     3.502    52.744     0.150
     3.502    93.145     0.150
     3.590    52.875     0.150
     3.590    96.594     0.150
     3.672    55.555     0.150
     3.672    93.885     0.150
     3.739    56.564     0.150
     3.739    96.975     0.150
     4.583    68.764     0.150
     4.583   118.385     0.150
     0.226     6.117     0.150
     0.226     9.777     0.150
     0.334     7.826     0.150
     0.334    13.277     0.150
     0.513    11.027     0.150
     0.579    12.037     0.150
     0.753    14.928     0.150
     0.753    25.957     0.150
     1.036    18.508     0.150
     1.036    31.836     0.150
     1.232    21.127     0.150
     1.232    36.217     0.150
     1.245    37.477     0.150
     1.294    23.848     0.150
     1.294    39.316     0.150
     1.398    25.217     0.150
     1.398    41.428     0.150
     1.717    30.438     0.150
     1.717    51.746     0.150
     1.744    30.467     0.150
     1.744    51.207     0.150
     1.747    29.928     0.150
     1.747    50.857     0.150
     1.900    32.447     0.150
     1.900    54.957     0.150
     2.031    36.166     0.150
     2.250    39.137     0.150
     2.250    64.977     0.150
     2.253    35.836     0.150
     2.253    63.387     0.150
     2.359    38.258     0.150
     2.359    67.107     0.150
     2.415    39.727     0.150
     2.415    68.258     0.150
     2.597    41.207     0.150
     2.597    70.377     0.150
     2.598    42.236     0.150
     2.598    73.707     0.150
     2.567    41.787     0.150
     2.567    72.076     0.150
     2.615    42.707     0.150
     2.615    74.486     0.150
     2.669    42.836     0.150
     2.669    71.848     0.150
     2.673    42.848     0.150
     2.697    43.836     0.150
     2.697    70.758     0.150
     2.675    43.268     0.150
     2.675    74.236     0.150
     2.699    44.508     0.150
     2.699    75.396     0.150
     2.710    44.736     0.150
     2.710    76.666     0.150
     2.711    44.268     0.150
     2.730    42.938     0.150
     2.739    43.848     0.150
     2.739    45.316     0.150
     2.739    73.406     0.150
     2.739    79.768     0.150
     2.755    44.367     0.150
     2.755    75.957     0.150
     2.769    44.598     0.150
     2.769    76.146     0.150
     2.768    44.277     0.150
     2.768    77.816     0.150
     2.768    44.277     0.150
     2.768    77.816     0.150
     2.782    77.527     0.150
     2.785    44.348     0.150
     2.785    75.896     0.150
     2.755    44.227     0.150
     2.755    77.217     0.150
     2.817    50.027     0.150
     2.818    46.867     0.150
     2.818    78.428     0.150
     2.850    77.496     0.150
     2.885    45.557     0.150
     2.903    46.098     0.150
     2.903    79.646     0.150
     2.922    47.678     0.150
     2.922    80.697     0.150
     2.918    46.678     0.150
     2.918    78.688     0.150
     2.978    48.656     0.150
     2.978    83.457     0.150
     2.974    46.688     0.150
     2.974    83.336     0.150
     3.041    85.008     0.150
     3.129    49.758     0.150
     3.129    88.166     0.150
     3.121    47.326     0.150
     3.121    81.326     0.150
     3.161    47.707     0.150
     3.161    92.348     0.150
     3.199    50.227     0.150
     3.199    88.107     0.150
     3.262    90.066     0.150
     3.297    51.586     0.150
     3.297    91.047     0.150
     3.426    53.307     0.150
     3.426    93.947     0.150
     3.536    55.367     0.150
     3.536    97.137     0.150
     3.536    55.367     0.150
     3.536    97.137     0.150
     3.544    53.246     0.150
     3.544    92.877     0.150
     3.564    55.236     0.150
     3.564    94.107     0.150
     3.650    55.666     0.150
     3.650    98.896     0.150
     3.651    55.666     0.150
     3.651    98.896     0.150
     3.733    59.047     0.150
     3.733   100.336     0.150
     3.861    60.416     0.150
     3.861   100.736     0.150
     3.950    63.797     0.150
     3.950   108.137     0.150
     3.979    63.457     0.150
     3.979   108.076     0.150
     3.979    62.887     0.150
     3.979   108.598     0.150
     3.984    63.086     0.150
     3.984   102.986     0.150
     3.985    60.887     0.150
     3.985   104.797     0.150
     4.001    61.697     0.150
     4.001   108.727     0.150
     4.010    63.768     0.150
     4.010   105.826     0.150
     4.028    63.826     0.150
     4.028   108.787     0.150
     3.979   109.297     0.150
     4.084    63.646     0.150
     4.084   106.406     0.150
     4.239    62.967     0.150
     4.239   116.207     0.150
     4.239    61.906     0.150
     4.261   111.467     0.150
     4.287    64.887     0.150
     4.492    67.777     0.150
     4.492   120.906     0.150
     4.582    72.277     0.150
     4.582   126.057     0.150
     4.744    72.086     0.150
     4.744   129.688     0.150
     4.740    71.416     0.150
     4.740   125.777     0.150
     4.742    70.447     0.150
     4.742   130.287     0.150
     4.971    73.957     0.150
     4.971   133.697     0.150
     4.999    78.416     0.150
     4.999   133.996     0.150
     5.108    77.066     0.150
     5.108   135.727     0.150
     5.304    78.646     0.150
     5.304   139.896     0.150
     5.317    77.887     0.150
     5.317   140.586     0.150
     5.391    83.357     0.150
     5.391   145.326     0.150
     5.572   147.496     0.150
     5.683    88.307     0.150
     5.683   151.258     0.150
     5.719   152.826     0.150
     5.841    90.098     0.150
     5.841   157.957     0.150
     6.019    87.637     0.150
     6.019   158.666     0.150
     6.199    93.326     0.150
     6.199    96.826     0.150
     6.199   163.598     0.150
     6.270    92.188     0.150
     6.270   160.916     0.150
     6.276    96.697     0.150
     6.992   104.258     0.150
     6.992   185.617     0.150
     7.015   102.947     0.150
     7.967   118.146     0.150
     8.031   119.076     0.150
     8.439   125.996     0.150
     8.439   216.246     0.150
     8.691   128.367     0.150
     8.713   127.896     0.150
     8.724   127.996     0.150
     9.035   129.537     0.150
     9.035   230.297     0.150
     9.355   138.877     0.150
     9.355   237.877     0.150
    10.091   150.477     0.150
    10.105   144.916     0.150
    10.268   146.496     0.150
    10.916   158.117     0.150
    10.937   159.027     0.150
    11.127   162.787     0.150
    11.127   163.387     0.150
    11.117   163.666     0.150
    11.117   164.166     0.150
    11.432   164.697     0.150
    11.432   163.889     0.150
    11.432   164.199     0.150
    11.576   169.018     0.150
    11.721   170.316     0.150
    11.990   171.547     0.150
    11.990   170.607     0.150
    11.990   169.740     0.150
    12.162   175.166     0.150
    12.489   179.406     0.150
    12.637   180.928     0.150
    12.752   183.387     0.150
    12.752   182.930     0.150
    12.752   182.857     0.150
    12.752   183.922     0.150
    12.752   409.512     0.150
    12.982   186.197     0.150
    12.982   186.357     0.150
    12.982   186.857     0.150
    13.111   189.598     0.150
    13.553   191.717     0.150
    13.553   193.406     0.150
    13.553   192.818     0.150
    13.674   194.377     0.150
    13.674   192.496     0.150
    13.997   200.678     0.150
    13.970   200.496     0.150
    13.970   201.396     0.150
    14.083   200.777     0.150
    14.083   199.562     0.150
    14.403   203.916     0.150
    14.459   205.326     0.150
    14.549   207.727     0.150
    14.765   210.326     0.150
    14.985   212.336     0.150
    14.938   213.258     0.150
    15.098   217.027     0.150
    15.287   215.277     0.150
    15.287   215.578     0.150
    15.287   400.623     0.150
    15.298   216.986     0.150
    15.305   215.666     0.150
    15.305   215.951     0.150
    15.428   219.438     0.150
    15.428   218.312     0.150
    15.428   218.197     0.150
    15.428   400.779     0.150
    15.480   224.996     0.150
    15.552   220.586     0.150
    15.552   221.066     0.150
    15.629   219.396     0.150
    15.629   219.279     0.150
    15.629   407.021     0.150
    15.644   219.656     0.150
    15.694   221.146     0.150
    15.694   220.912     0.150
    15.694   221.416     0.150
    15.694   410.553     0.150
    15.714   220.496     0.150
    15.714   219.918     0.150
    15.714   221.285     0.150
    15.729   220.727     0.150
    15.742   223.807     0.150
    15.815   226.467     0.150
    15.767   224.307     0.150
    15.778   224.307     0.150
    15.861   222.996     0.150
    15.833   226.076     0.150
    15.921   224.086     0.150
    15.936   223.916     0.150
    15.991   227.598     0.150
    15.992   225.576     0.150
    16.014   226.836     0.150
    16.018   227.836     0.150
    16.053   228.727     0.150
    16.149   226.547     0.150
    16.178   229.357     0.150
    16.233   227.518     0.150
    16.234   227.598     0.150
    16.189   228.848     0.150
    16.380   229.086     0.150
    16.395   234.107     0.150
    16.395   235.768     0.150
    16.395   229.916     0.150
    16.531   234.518     0.150
    16.532   234.607     0.150
    16.631   232.416     0.150
    16.631   232.131     0.150
    16.631   429.125     0.150
    16.655   235.826     0.150
    16.951   239.916     0.150
    16.951   237.078     0.150
    16.951   237.740     0.150
    16.977   236.600     0.150
    17.032   240.576     0.150
    17.034   237.742     0.150
    17.151   239.947     0.150
    17.151   239.703     0.150
    17.151   440.982     0.150
    17.376   245.637     0.150
    17.550   244.258     0.150
    17.699   244.947     0.150
    17.716   244.600     0.150
    17.716   245.855     0.150
    17.691   250.307     0.150
    17.692   250.057     0.150
    17.742   244.861     0.150
    17.848   246.947     0.150
    17.848   246.600     0.150
    17.968   249.266     0.150
    17.977   251.979     0.150
    18.005   251.896     0.150
    18.005   252.271     0.150
    18.092   252.645     0.150
    18.092   252.293     0.150
    18.210   251.885     0.150
    18.210   460.223     0.150
    18.301   256.877     0.150
    18.634   255.514     0.150
    18.634   256.805     0.150
    18.634   468.869     0.150
    18.724   257.160     0.150
    18.724   257.951     0.150
    18.752   261.438     0.150
    18.752   259.688     0.150
    18.786   259.920     0.150
    18.786   261.213     0.150
    18.786   260.496     0.150
    18.786   260.992     0.150
    19.400   265.297     0.150
    19.466   266.637     0.150
    19.540   267.504     0.150
    19.663   271.537     0.150
    19.703   268.666     0.150
    19.769   270.758     0.150
    19.801   269.357     0.150
    19.981   274.365     0.150
    20.139   273.018     0.150
    20.139   273.576     0.150
    20.144   272.822     0.150
    20.144   272.424     0.150
    20.208   273.527     0.150
    20.208   273.812     0.150
    20.240   275.125     0.150
    20.240   507.820     0.150
    20.259   274.295     0.150
    20.488   278.598     0.150
    20.532   277.688     0.150
    20.532   511.475     0.150
    20.773   280.230     0.150
    20.787   280.135     0.150
    20.974   285.922     0.150
    21.045   285.348     0.150
    21.050   285.457     0.150
    21.077   283.668     0.150
    21.082   283.107     0.150
    21.144   283.717     0.150
    21.159   287.412     0.150
    21.181   287.508     0.150
    21.182   283.547     0.150
    21.182   284.191     0.150
    21.213   284.189     0.150
    21.272   288.365     0.150
    21.371   286.146     0.150
    21.371   286.691     0.150
    21.474   289.471     0.150
    21.470   287.217     0.150
    21.493   290.990     0.150
    21.516   290.668     0.150
    21.517   288.145     0.150
    21.541   290.922     0.150
    21.657   534.105     0.150
    21.698   289.656     0.150
    21.703   288.787     0.150
    21.708   290.008     0.150
    21.708   536.463     0.150
    21.864   291.738     0.150
    21.864   534.100     0.150
    21.863   292.348     0.150
    21.932   293.979     0.150
    21.934   292.246     0.150
    21.956   291.598     0.150
    22.035   296.781     0.150
    22.042   296.738     0.150
    22.054   296.951     0.150
    22.136   295.061     0.150
    22.136   295.725     0.150
    22.121   293.002     0.150
    22.121   539.600     0.150
    22.200   294.574     0.150
    22.200   294.096     0.150
    22.350   296.043     0.150
    22.390   298.492     0.150
    22.380   296.008     0.150
    22.391   296.842     0.150
    22.391   546.699     0.150
    22.410   296.785     0.150
    22.445   300.957     0.150
    22.454   296.887     0.150
    22.454   297.697     0.150
    22.472   300.408     0.150
    22.462   297.559     0.150
    22.502   297.178     0.150
    22.502   548.238     0.150
    22.588   298.254     0.150
    22.588   299.021     0.150
    22.601   300.207     0.150
    22.691   299.781     0.150
    22.773   304.377     0.150
    22.791   300.098     0.150
    22.791   300.545     0.150
    22.850   303.975     0.150
    22.860   304.027     0.150
    22.902   305.852     0.150
    22.951   301.986     0.150
    22.951   302.436     0.150
    23.038   305.707     0.150
    23.078   307.402     0.150
    23.092   307.244     0.150
    23.191   308.582     0.150
    23.221   308.236     0.150
    23.237   305.156     0.150
    23.255   308.975     0.150
    23.282   307.637     0.150
    23.282   307.949     0.150
    23.282   308.410     0.150
    23.303   305.457     0.150
    23.368   306.719     0.150
    23.443   307.930     0.150
    23.446   307.236     0.150
    23.446   565.477     0.150
    23.458   311.174     0.150
    23.473   307.312     0.150
    23.589   309.223     0.150
    23.609   312.512     0.150
    23.615   312.578     0.150
    23.659   309.887     0.150
    23.706   313.350     0.150
    23.721   310.502     0.150
    23.836   314.211     0.150
    23.866   311.945     0.150
    23.866   570.441     0.150
    23.867   312.771     0.150
    23.982   315.467     0.150
    24.024   313.928     0.150
    24.079   317.219     0.150
    24.089   316.902     0.150
    24.099   314.312     0.150
    24.106   314.438     0.150
    24.149   316.971     0.150
    24.255   316.041     0.150
    24.302   315.539     0.150
    24.338   315.975     0.150
    24.355   320.143     0.150
    24.389   320.643     0.150
    24.378   318.381     0.150
    24.378   318.686     0.150
    24.405   318.740     0.150
    24.404   320.691     0.150
    24.402   317.916     0.150
    24.414   318.395     0.150
    24.502   321.002     0.150
    24.525   319.029     0.150
    24.525   319.928     0.150
    24.587   322.291     0.150
    24.588   319.018     0.150
    24.630   319.490     0.150
    24.624   318.988     0.150
    24.624   319.545     0.150
    24.643   319.711     0.150
    24.643   318.742     0.150
    24.663   322.443     0.150
    24.790   321.771     0.150
    24.923   322.996     0.150
    24.941   324.793     0.150
    24.994   325.998     0.150
    25.018   326.426     0.150
    25.029   324.787     0.150
    25.143   327.717     0.150
    25.148   323.980     0.150
    25.190   326.615     0.150
    25.198   326.039     0.150
    25.245   325.760     0.150
    25.333   328.816     0.150
    25.409   326.299     0.150
    25.414   326.662     0.150
    25.445   327.359     0.150
    25.472   327.703     0.150
    25.487   327.371     0.150
    25.487   327.475     0.150
    25.500   331.066     0.150
    25.577   328.248     0.150
    25.583   329.002     0.150
    25.602   331.297     0.150
    25.701   329.697     0.150
    25.761   330.299     0.150
    25.807   331.646     0.150
    25.925   334.957     0.150
    26.022   331.688     0.150
    26.112   333.193     0.150
    26.112   333.398     0.150
    26.212   334.930     0.150
    26.212   336.031     0.150
    26.274   337.127     0.150
    26.312   334.391     0.150
    26.397   335.172     0.150
    26.397   334.969     0.150
    26.385   338.508     0.150
    26.504   335.525     0.150
    26.480   338.518     0.150
    26.585   340.973     0.150
    26.585   544.172     0.150
    26.566   340.746     0.150
    26.637   337.873     0.150
    26.653   337.990     0.150
    26.688   337.693     0.150
    26.641   339.768     0.150
    26.721   339.043     0.150
    26.764   340.303     0.150
    26.778   339.869     0.150
    26.797   338.369     0.150
    26.819   339.605     0.150
    26.868   339.934     0.150
    26.868   340.385     0.150
    26.875   338.066     0.150
    26.957   342.105     0.150
    26.957   342.697     0.150
    26.957   543.746     0.150
    26.965   340.404     0.150
    26.965   341.100     0.150
    27.015   343.557     0.150
    27.015   544.156     0.150
    26.988   343.127     0.150
    27.093   341.547     0.150
    27.099   341.365     0.150
    27.127   342.508     0.150
    27.131   342.326     0.150
    27.172   344.166     0.150
    27.169   342.756     0.150
    27.169   343.357     0.150
    27.140   347.477     0.150
    27.155   345.268     0.150
    27.238   346.178     0.150
    27.238   347.477     0.150
    27.364   344.434     0.150
    27.337   345.217     0.150
    27.332   347.727     0.150
    27.345   346.688     0.150
    27.401   345.152     0.150
    27.413   345.377     0.150
    27.412   349.107     0.150
    27.429   349.457     0.150
    27.486   347.986     0.150
    27.447   349.576     0.150
    27.508   345.725     0.150
    27.473   348.758     0.150
    27.528   350.188     0.150
    27.616   348.416     0.150
    27.697   347.359     0.150
    27.704   346.635     0.150
    27.736   347.814     0.150
    27.755   347.986     0.150
    27.764   346.809     0.150
    27.783   348.258     0.150
    27.783   349.330     0.150
    27.828   349.811     0.150
    27.811   351.646     0.150
    27.892   349.598     0.150
    27.864   352.227     0.150
    27.905   350.021     0.150
    27.970   349.885     0.150
    28.024   355.137     0.150
    28.098   353.316     0.150
    28.097   351.336     0.150
    28.097   351.803     0.150
    28.104   355.477     0.150
    28.161   355.396     0.150
    28.219   351.189     0.150
    28.224   356.098     0.150
    28.224   354.297     0.150
    28.272   355.477     0.150
    28.439   354.570     0.150
    28.501   353.936     0.150
    28.580   354.107     0.150
    28.631   355.836     0.150
    28.639   355.646     0.150
    28.658   355.455     0.150
    28.679   360.146     0.150
    28.740   359.209     0.150
    28.721   361.258     0.150
    28.834   358.539     0.150
    28.871   358.193     0.150
    28.896   360.906     0.150
    28.857   361.867     0.150
    28.908   358.361     0.150
    28.894   361.576     0.150
    28.976   360.121     0.150
    29.058   359.906     0.150
    29.082   359.289     0.150
    29.095   360.947     0.150
    29.122   362.322     0.150
    29.121   359.969     0.150
    29.121   360.254     0.150
    29.131   362.268     0.150
    29.131   362.449     0.150
    29.239   360.508     0.150
    29.236   363.377     0.150
    29.236   362.916     0.150
    29.331   362.822     0.150
    29.437   363.494     0.150
    29.468   362.414     0.150
    29.613   365.109     0.150
    29.711   364.652     0.150
    29.801   366.586     0.150
    29.854   370.457     0.150
    29.948   366.725     0.150
    29.951   370.826     0.150
    30.113   369.596     0.150
    30.113   369.182     0.150
    30.073   370.777     0.150
    30.073   369.416     0.150
    30.131   371.197     0.150
    30.177   371.406     0.150
    30.215   374.887     0.150
    30.472   375.447     0.150
    30.646   374.400     0.150
    30.661   374.082     0.150
    30.661   373.959     0.150
    30.783   374.602     0.150
    30.871   375.662     0.150
    30.893   376.035     0.150
    31.017   378.406     0.150
    31.300   380.484     0.150
    31.398   379.732     0.150
    31.462   380.582     0.150
    31.558   381.768     0.150
    31.558   382.035     0.150
    31.561   380.924     0.150
    31.659   383.258     0.150
    31.657   382.441     0.150
    31.841   383.762     0.150
    31.841   383.271     0.150
    31.874   383.857     0.150
    31.899   386.092     0.150
    31.890   385.277     0.150
    31.994   386.807     0.150
    32.583   391.783     0.150
    32.773   392.738     0.150
    32.814   393.387     0.150
    32.856   393.205     0.150
    33.014   395.197     0.150
    33.068   393.871     0.150
    33.174   396.273     0.150
    33.174   396.686     0.150
    33.194   397.496     0.150
    33.286   397.711     0.150
    33.369   398.375     0.150
    33.472   401.406     0.150
    33.491   398.098     0.150
    33.491   559.771     0.150
    33.603   399.412     0.150
    33.943   402.719     0.150
    33.978   403.342     0.150
    34.162   405.592     0.150
    34.162   405.092     0.150
    34.162   561.391     0.150
    34.179   404.121     0.150
    34.432   406.488     0.150
    34.529   408.539     0.150
    34.793   410.439     0.150
    34.834   410.779     0.150
    35.177   413.246     0.150
    35.430   416.152     0.150
    35.573   417.260     0.150
    35.577   417.418     0.150
    35.729   419.107     0.150
    35.842   419.893     0.150
    36.276   423.678     0.150
    36.349   423.475     0.150
    36.449   425.574     0.150
    36.700   428.438     0.150
    36.731   428.656     0.150
    36.731   429.188     0.150
    36.988   429.145     0.150
    36.987   430.143     0.150
    36.956   430.396     0.150
    36.984   429.486     0.150
    37.657   435.098     0.150
    37.737   436.199     0.150
    37.792   435.947     0.150
    38.456   441.969     0.150
    38.456   441.590     0.150
    38.472   442.102     0.150
    38.827   444.889     0.150
    39.165   447.980     0.150
    39.186   447.826     0.150
    39.345   449.635     0.150
    39.404   450.004     0.150
    39.641   452.250     0.150
    39.707   452.148     0.150
    40.737   461.666     0.150
    41.765   469.496     0.150
    41.765   469.867     0.150
    42.987   478.666     0.150
    42.987   479.258     0.150
    43.999   487.938     0.150
    43.999   487.746     0.150
    44.886   493.348     0.150
    44.886   492.477     0.150
    44.886   493.707     0.150
    45.183   498.584     0.150
    45.829   501.547     0.150
    45.876   504.465     0.150
    45.822   502.947     0.150
    45.822   503.066     0.150
    45.822   503.371     0.150
    45.893   504.086     0.150
    46.343   507.266     0.150
    46.402   505.986     0.150
    46.402   507.566     0.150
    46.427   507.574     0.150
    46.366   507.887     0.150
    46.459   507.912     0.150
    46.642   507.822     0.150
    46.642   601.771     0.150
    46.770   510.934     0.150
    46.890   511.945     0.150
    46.900   511.436     0.150
    47.805   518.416     0.150
    47.805   519.109     0.150
    47.862   519.867     0.150
    47.946   520.480     0.150
    48.069   521.078     0.150
    48.400   523.539     0.150
    48.983   526.957     0.150
    48.983   527.387     0.150
    48.934   525.746     0.150
    49.038   528.518     0.150
    49.181   529.930     0.150
    49.186   528.576     0.150
    49.529   531.932     0.150
    49.575   530.816     0.150
    49.963   535.539     0.150
    49.912   533.938     0.150
    50.213   537.092     0.150
    50.511   539.807     0.150
    50.511   540.219     0.150
    50.548   539.770     0.150
    50.500   537.217     0.150
    50.585   540.600     0.150
    50.632   539.607     0.150
    50.715   541.123     0.150
    50.849   541.428     0.150
    50.849   541.969     0.150
    51.108   544.174     0.150
    51.161   544.896     0.150
    51.215   545.361     0.150
    51.259   545.416     0.150
    51.259   546.027     0.150
    51.308   545.357     0.150
    51.543   547.193     0.150
    51.651   547.670     0.150
    51.639   546.008     0.150
    51.822   549.752     0.150
    51.808   547.207     0.150
    51.871   548.098     0.150
    52.021   551.873     0.150
    52.027   548.697     0.150
    52.215   552.521     0.150
    52.223   552.842     0.150
    52.689   556.473     0.150
    52.783   556.645     0.150
    52.962   557.955     0.150
    53.027   558.518     0.150
    53.046   558.625     0.150
    53.082   556.146     0.150
    53.335   560.797     0.150
    53.340   560.527     0.150
    53.484   562.299     0.150
    53.515   561.533     0.150
    53.687   562.824     0.150
    53.819   563.723     0.150
    53.849   564.566     0.150
    53.956   565.043     0.150
    53.964   564.621     0.150
    54.258   567.027     0.150
    54.271   567.127     0.150
    54.271   567.723     0.150
    54.288   567.848     0.150
    54.302   567.674     0.150
    54.431   569.059     0.150
    54.484   567.434     0.150
    54.637   568.691     0.150
    54.709   569.240     0.150
    54.795   570.725     0.150
    54.892   570.744     0.150
    54.891   572.166     0.150
    54.832   570.447     0.150
    54.908   570.840     0.150
    54.967   572.965     0.150
    55.038   572.426     0.150
    55.016   571.938     0.150
    55.106   572.721     0.150
    55.053   572.836     0.150
    55.195   572.729     0.150
    55.201   572.842     0.150
    55.332   575.090     0.150
    55.524   575.242     0.150
    55.524   575.521     0.150
    55.547   575.912     0.150
    55.547   576.057     0.150
    55.547   575.729     0.150
    55.598   577.244     0.150
    55.641   576.967     0.150
    55.651   576.641     0.150
    55.770   577.947     0.150
    55.770   578.176     0.150
    55.780   578.074     0.150
    55.824   578.146     0.150
    55.881   578.816     0.150
    56.034   580.123     0.150
    56.006   579.393     0.150
    56.063   579.500     0.150
    56.131   580.150     0.150
    56.139   580.479     0.150
    56.203   581.225     0.150
    56.206   580.896     0.150
    56.251   580.984     0.150
    56.255   581.383     0.150
    56.317   581.766     0.150
    56.328   581.850     0.150
    56.382   581.457     0.150
    56.424   581.471     0.150
    56.385   582.076     0.150
    56.463   582.299     0.150
    56.435   582.367     0.150
    56.625   583.391     0.150
    56.652   583.816     0.150
    56.711   584.514     0.150
    56.741   584.447     0.150
    56.687   582.967     0.150
    56.862   585.805     0.150
    56.803   582.967     0.150
    56.899   585.568     0.150
    56.906   585.598     0.150
    57.004   585.436     0.150
    57.043   586.436     0.150
    57.048   586.664     0.150
    57.055   586.852     0.150
    57.088   585.977     0.150
    57.088   586.746     0.150
    57.088   641.246     0.150
    57.033   587.156     0.150
    57.122   587.012     0.150
    57.149   587.414     0.150
    57.273   588.303     0.150
    57.291   588.377     0.150
    57.362   588.771     0.150
    57.367   589.137     0.150
    57.476   589.350     0.150
    57.488   589.223     0.150
    57.488   588.797     0.150
    57.492   589.105     0.150
    57.521   590.297     0.150
    57.486   588.928     0.150
    57.571   589.316     0.150
    57.585   589.914     0.150
    57.649   591.305     0.150
    57.777   591.234     0.150
    57.870   592.037     0.150
    57.873   591.666     0.150
    57.895   592.701     0.150
    57.904   592.336     0.150
    57.853   591.307     0.150
    57.939   593.348     0.150
    57.977   593.631     0.150
    57.977   592.875     0.150
    58.032   593.947     0.150
    57.996   593.996     0.150
    58.067   593.803     0.150
    58.136   594.379     0.150
    58.146   594.051     0.150
    58.177   594.723     0.150
    58.201   594.377     0.150
    58.201   594.176     0.150
    58.242   594.268     0.150
    58.182   594.287     0.150
    58.329   594.898     0.150
    58.339   595.229     0.150
    58.300   595.787     0.150
    58.384   596.246     0.150
    58.396   596.525     0.150
    58.478   596.502     0.150
    58.504   597.447     0.150
    58.601   597.430     0.150
    58.615   597.738     0.150
    58.616   597.566     0.150
    58.626   598.473     0.150
    58.645   597.697     0.150
    58.650   596.881     0.150
    58.652   598.768     0.150
    58.693   598.467     0.150
    58.761   595.867     0.150
    58.781   598.570     0.150
    58.930   599.848     0.150
    58.984   600.275     0.150
    59.000   600.227     0.150
    59.047   600.537     0.150
    59.106   601.041     0.150
    59.108   601.357     0.150
    59.148   601.000     0.150
    59.170   601.773     0.150
    59.124   601.156     0.150
    59.237   601.699     0.150
    59.283   601.686     0.150
    59.316   602.293     0.150
    59.348   602.066     0.150
    59.411   603.084     0.150
    59.456   602.848     0.150
    59.456   601.365     0.150
    59.488   603.744     0.150
    59.502   603.240     0.150
    59.489   602.938     0.150
    59.555   604.277     0.150
    59.571   604.965     0.150
    59.591   604.307     0.150
    59.680   604.598     0.150
    59.727   603.357     0.150
    59.733   604.990     0.150
    59.752   605.021     0.150
    59.832   606.947     0.150
    59.849   605.559     0.150
    59.907   606.348     0.150
    60.007   606.281     0.150
    60.031   607.428     0.150
    59.988   606.486     0.150
    59.988   607.107     0.150
    59.988   605.572     0.150
    60.139   607.734     0.150
    60.178   607.236     0.150
    60.201   607.910     0.150
    60.235   608.172     0.150
    60.306   609.061     0.150
    60.309   609.227     0.150
    60.342   609.057     0.150
    60.370   609.246     0.150
    60.372   610.172     0.150
    60.401   609.449     0.150
    60.488   610.340     0.150
    60.506   609.428     0.150
    60.506   608.586     0.150
    60.572   611.061     0.150
    60.615   610.426     0.150
    60.654   612.285     0.150
    60.672   612.109     0.150
    60.704   610.938     0.150
    60.774   612.820     0.150
    60.817   613.383     0.150
    60.842   612.996     0.150
    60.869   613.293     0.150
    60.975   613.043     0.150
    60.999   613.688     0.150
    60.960   612.857     0.150
    61.106   614.406     0.150
    61.113   614.557     0.150
    61.192   615.045     0.150
    61.151   614.258     0.150
    61.159   615.156     0.150
    61.241   614.975     0.150
    61.343   615.896     0.150
    61.369   616.258     0.150
    61.471   616.242     0.150
    61.404   617.086     0.150
    61.559   617.598     0.150
    61.509   616.646     0.150
    61.612   617.812     0.150
    61.671   618.305     0.150
    61.798   619.471     0.150
    61.863   619.316     0.150
    61.881   620.057     0.150
    61.959   620.488     0.150
    61.975   619.928     0.150
    62.040   621.656     0.150
    62.075   621.111     0.150
    62.089   621.617     0.150
    62.119   621.396     0.150
    62.099   621.117     0.150
    62.177   621.857     0.150
    62.454   623.396     0.150
    62.581   624.779     0.150
    62.602   625.008     0.150
    62.655   624.826     0.150
    62.655   624.688     0.150
    62.700   624.688     0.150
    62.733   624.986     0.150
    62.913   627.170     0.150
    62.981   626.178     0.150
    63.142   628.824     0.150
    63.187   628.535     0.150
    63.215   628.871     0.150
    63.256   628.979     0.150
    63.282   629.758     0.150
    63.337   629.457     0.150
    63.543   631.275     0.150
    63.591   631.568     0.150
    63.623   629.566     0.150
    63.679   633.037     0.150
    63.679   632.746     0.150
    63.706   632.736     0.150
    63.780   632.137     0.150
    63.814   632.736     0.150
    64.079   633.746     0.150
    64.029   634.227     0.150
    64.220   635.828     0.150
    64.159   635.416     0.150
    64.300   636.646     0.150
    64.494   637.207     0.150
    64.827   640.250     0.150
    64.842   640.188     0.150
    65.049   640.855     0.150
    65.226   641.678     0.150
    65.293   640.986     0.150
    65.493   644.115     0.150
    65.593   644.957     0.150
    65.752   645.406     0.150
    65.752   644.297     0.150
    65.875   646.746     0.150
    65.985   646.746     0.150
    66.047   647.787     0.150
    66.294   650.027     0.150
    66.312   649.428     0.150
    66.701   650.447     0.150
    66.732   652.320     0.150
    67.624   659.117     0.150
    68.147   661.348     0.150
    68.368   662.836     0.150
    69.091   666.857     0.150
    69.418   668.947     0.150
    71.217   676.607     0.150
    71.799   681.297     0.150
    72.497   684.576     0.150
    78.853   723.297     0.150
    80.456   732.598     0.150
    80.688   733.697     0.150
    80.778   734.598     0.150
    80.971   735.297     0.150
    81.061   735.896     0.150
    81.226   736.396     0.150
    81.235   737.098     0.150
    81.399   737.896     0.150
    81.522   738.496     0.150
    81.540   738.896     0.150
    81.540   738.316     0.150
    81.582   738.697     0.150
    81.591   738.396     0.150
    81.625   738.496     0.150
    81.731   740.098     0.150
    81.761   739.297     0.150
    81.763   739.896     0.150
    81.914   741.598     0.150
    82.037   741.396     0.150
    82.354   742.697     0.150
    82.699   743.496     0.150
    83.605   746.598     0.150
    83.605   748.871     0.150
    83.994   750.467     0.150
    83.994   751.467     0.150
    84.242   752.223     0.150
    84.316   754.266     0.150
    84.512   755.314     0.150
    84.765   754.098     0.150
    85.291   756.297     0.150
    85.304   759.266     0.150
    85.346   759.404     0.150
    85.399   757.396     0.150
    85.399   757.547     0.150
    85.577   760.285     0.150
    85.649   758.406     0.150
    85.649   758.098     0.150
    85.755   760.871     0.150
    85.842   758.896     0.150
    86.004   761.928     0.150
    86.486   765.266     0.150
    86.531   763.617     0.150
    86.689   761.416     0.150
    87.143   765.086     0.150
    87.243   767.156     0.150
    87.300   769.816     0.150
    90.821   783.197     0.150
    90.821     9.100     0.150
    90.821    11.100     0.150
    90.850   784.682     0.150
    91.182   783.172     0.150
    91.182  1000.646     0.150
    91.298   786.504     0.150
    91.298  1000.467     0.150
    91.487   787.152     0.150
    91.487  1001.994     0.150
    91.569   787.498     0.150
    91.569  1003.920     0.150
    91.689   788.658     0.150
    91.689  1004.283     0.150
    91.859  1007.781     0.150
    91.928   789.568     0.150
    91.928  1007.074     0.150
    92.011   789.197     0.150
    92.402   789.871     0.150
    92.480   791.234     0.150
    92.480  1011.863     0.150
    92.699   791.807     0.150
    93.044   793.629     0.150
    93.044  1015.584     0.150
    93.217  1017.520     0.150
    93.385   791.996     0.150
    93.439  1021.311     0.150
    93.814   797.496     0.150
    93.829   796.797     0.150
    93.829   797.672     0.150
    93.829  1022.297     0.150
    94.044   798.352     0.150
    94.044  1022.805     0.150
    94.094   799.098     0.150
    94.250   798.850     0.150
    94.250  1024.439     0.150
    94.476   800.754     0.150
    94.476  1025.498     0.150
    95.493   805.547     0.150
    95.672   804.957     0.150
    96.152   805.996     0.150
    96.152  1037.896     0.150
    97.226   810.996     0.150
    97.503   813.271     0.150
    99.545  1065.947     0.150
    99.545   823.896     0.150
    99.617   824.598     0.150
   103.737   842.598     0.150
   103.737  1102.598     0.150
   104.871  1107.092     0.150
   109.261  1109.896     0.150
   109.322  1138.521     0.150
   110.916  1112.896     0.150
   113.356  1116.996     0.150
   115.346  1121.697     0.150
   116.582  1188.473     0.150
   118.490  1129.098     0.150
   119.151  1130.697     0.150
   121.873  1134.977     0.150
   122.161  1135.098     0.150
   122.265  1135.797     0.150
   122.537  1136.598     0.150
   125.281  1142.797     0.150
   127.104  1145.098     0.150
   128.126  1145.996     0.150
   128.137  1147.521     0.150
   128.165  1145.734     0.150
   128.838  1147.697     0.150
   128.936  1147.871     0.150
   131.800  1155.098     0.150
   140.051  1170.297     0.150
   145.908  1179.527     0.150
     0.019     6.648     0.150
     0.019    10.555     0.150
     0.255     7.898     0.150
     0.255    12.328     0.150
     0.401    16.703     0.150
     0.616    12.883     0.150
     0.616    21.625     0.150
     0.735    14.359     0.150
     0.735    23.469     0.150
     1.058    19.477     0.150
     1.058    32.633     0.150
     1.240    22.047     0.150
     1.240    36.594     0.150
     1.422    24.867     0.150
     1.422    41.430     0.150
     1.450    25.633     0.150
     1.450    41.789     0.150
     1.467    25.656     0.150
     1.551    26.719     0.150
     1.535    26.688     0.150
     1.753    28.844     0.150
     1.753    47.516     0.150
     1.672    28.594     0.150
     1.672    48.633     0.150
     1.951    32.188     0.150
     1.951    54.773     0.150
     2.053    34.008     0.150
     2.053    57.039     0.150
     2.018    34.547     0.150
     2.018    55.406     0.150
     2.107    33.766     0.150
     2.107    57.508     0.150
     2.192    35.656     0.150
     2.192    60.906     0.150
     2.236    36.562     0.150
     2.236    61.625     0.150
     2.470    38.914     0.150
     2.470    67.117     0.150
     2.514    40.469     0.150
     2.514    70.695     0.150
     2.770    43.258     0.150
     2.770    71.664     0.150
     2.842    44.148     0.150
     2.842    77.688     0.150
     2.942    45.625     0.150
     2.942    80.773     0.150
     3.018    47.578     0.150
     3.018    80.055     0.150
     3.036    48.273     0.150
     3.036    50.312     0.150
     3.036    84.609     0.150
     3.484    52.445     0.150
     3.484    94.375     0.150
     3.584    55.039     0.150
     3.584    94.938     0.150
     3.791    57.773     0.150
     3.791    96.445     0.150
     4.077    66.539     0.150
     4.077   111.875     0.150
     4.330    65.656     0.150
     4.786    71.383     0.150
     4.786   146.906     0.150
     4.824    69.648     0.150
     4.824   124.195     0.150
     4.967    76.305     0.150
     5.501    80.523     0.150
     5.549    83.719     0.150
     5.549   148.164     0.150
     6.033    92.695     0.150
     6.033   158.938     0.150
     6.179    94.156     0.150
     6.369    95.359     0.150
     6.369    97.086     0.150
     6.369   168.062     0.150
     6.505    95.312     0.150
     6.505   165.539     0.150
     7.450   108.586     0.150
     9.586   137.062     0.150
    11.386   161.656     0.150
    11.386   162.484     0.150
    11.493   160.812     0.150
    11.493   162.477     0.150
    11.517   166.867     0.150
    12.491   177.047     0.150
    12.590   178.836     0.150
    12.862   184.828     0.150
    13.164   186.016     0.150
    13.526   190.594     0.150
    13.526   191.086     0.150
    13.853   194.469     0.150
    13.986   197.438     0.150
    14.013   198.492     0.150
    14.352   200.477     0.150
    14.594   206.359     0.150
    14.620   206.508     0.150
    14.999   210.844     0.150
    15.168   214.180     0.150
    15.193   211.773     0.150
    15.193   213.297     0.150
    15.353   214.586     0.150
    15.441   215.305     0.150
    15.542   215.898     0.150
    15.542   218.344     0.150
    15.551   215.625     0.150
    15.565   218.969     0.150
    15.630   218.008     0.150
    15.665   219.914     0.150
    15.920   223.109     0.150
    15.920   224.055     0.150
    15.915   221.734     0.150
    15.926   222.633     0.150
    16.364   231.367     0.150
    16.539   234.133     0.150
    16.885   236.867     0.150
    17.136   239.070     0.150
    17.200   238.180     0.150
    17.203   239.727     0.150
    17.501   241.914     0.150
    17.990   248.570     0.150
    18.240   252.836     0.150
    18.252   252.648     0.150
    18.396   252.859     0.150
    18.423   254.047     0.150
    18.916   260.656     0.150
    18.916   259.781     0.150
    18.916   260.328     0.150
    18.916   600.359     0.150
    19.038   263.430     0.150
    19.038   262.180     0.150
    19.117   263.969     0.150
    19.221   261.398     0.150
    19.288   262.484     0.150
    19.288   262.672     0.150
    19.536   265.617     0.150
    19.432   265.977     0.150
    19.675   265.984     0.150
    19.837   268.523     0.150
    19.837   268.805     0.150
    20.071   270.547     0.150
    20.140   272.148     0.150
    20.173   274.344     0.150
    20.346   273.953     0.150
    20.561   276.727     0.150
    20.561   278.492     0.150
    20.712   278.148     0.150
    20.783   277.992     0.150
    20.930   279.258     0.150
    21.112   280.867     0.150
    21.136   280.625     0.150
    21.189   285.625     0.150
    21.274   283.883     0.150
    21.355   286.734     0.150
    21.355   286.430     0.150
    21.362   287.844     0.150
    21.478   288.734     0.150
    21.510   286.219     0.150
    21.544   288.648     0.150
    21.623   289.328     0.150
    21.657   290.180     0.150
    21.752   288.703     0.150
    21.790   292.141     0.150
    21.835   292.555     0.150
    21.848   292.266     0.150
    21.948   290.484     0.150
    21.948   291.672     0.150
    21.981   293.930     0.150
    22.082   290.438     0.150
    22.079   291.109     0.150
    22.091   290.414     0.150
    22.114   293.125     0.150
    22.168   295.195     0.150
    22.259   296.859     0.150
    22.311   296.266     0.150
    22.341   295.055     0.150
    22.345   298.531     0.150
    22.352   298.602     0.150
    22.356   299.273     0.150
    22.395   295.375     0.150
    22.408   296.961     0.150
    22.468   299.422     0.150
    22.597   296.977     0.150
    22.691   301.992     0.150
    22.730   303.922     0.150
    22.770   301.586     0.150
    22.790   303.266     0.150
    22.965   305.039     0.150
    23.079   305.719     0.150
    23.142   307.484     0.150
    23.242   307.164     0.150
    23.359   316.188     0.150
    23.363   307.984     0.150
    23.357   309.453     0.150
    23.425   310.062     0.150
    23.506   310.422     0.150
    23.557   307.078     0.150
    23.680   311.477     0.150
    23.749   313.484     0.150
    23.783   309.344     0.150
    23.893   314.352     0.150
    24.004   313.430     0.150
    24.004   313.289     0.150
    24.041   314.383     0.150
    24.145   316.828     0.150
    24.271   317.758     0.150
    24.342   316.742     0.150
    24.375   316.828     0.150
    24.377   319.039     0.150
    24.409   318.914     0.150
    24.486   318.703     0.150
    24.584   318.578     0.150
    24.586   320.438     0.150
    24.632   321.094     0.150
    24.669   321.062     0.150
    24.679   321.312     0.150
    24.795   321.375     0.150
    24.816   322.031     0.150
    24.918   322.656     0.150
    24.967   323.047     0.150
    25.050   325.578     0.150
    25.267   326.156     0.150
    25.300   324.930     0.150
    25.285   326.258     0.150
    25.294   327.000     0.150
    25.410   325.508     0.150
    25.430   327.719     0.150
    25.451   328.812     0.150
    25.578   328.352     0.150
    25.656   329.898     0.150
    25.789   331.102     0.150
    25.809   331.789     0.150
    25.894   330.336     0.150
    26.143   331.781     0.150
    26.293   334.656     0.150
    26.371   334.055     0.150
    26.545   336.586     0.150
    26.506   336.344     0.150
    26.555   335.883     0.150
    26.558   338.781     0.150
    26.854   340.781     0.150
    26.854   542.859     0.150
    26.899   339.305     0.150
    27.080   342.289     0.150
    27.080   342.289     0.150
    27.080   542.188     0.150
    27.208   342.281     0.150
    27.207   342.719     0.150
    27.370   344.828     0.150
    27.424   344.023     0.150
    27.489   344.430     0.150
    28.364   352.195     0.150
    28.607   354.398     0.150
    28.864   357.422     0.150
    28.882   356.711     0.150
    28.865   358.562     0.150
    29.227   361.625     0.150
    29.307   362.578     0.150
    29.393   363.992     0.150
    29.706   364.133     0.150
    30.371   370.445     0.150
    30.664   373.039     0.150
    30.871   375.297     0.150
    31.691   382.391     0.150
    31.727   382.898     0.150
    32.045   386.297     0.150
    32.221   387.047     0.150
    32.468   388.758     0.150
    32.514   391.555     0.150
    32.843   391.484     0.150
    33.431   396.398     0.150
    33.431   397.688     0.150
    35.153   411.820     0.150
    37.758   434.594     0.150
    37.792   434.578     0.150
    37.792     9.070     0.150
    42.024   468.797     0.150
    44.456   488.273     0.150
    44.456   489.219     0.150
    44.456     8.398     0.150
    44.456    12.648     0.150
    45.387   496.719     0.150
    45.585   497.961     0.150
    46.060   502.547     0.150
    46.103   502.695     0.150
    46.451   505.867     0.150
    46.590   507.180     0.150
    46.710   507.062     0.150
    47.071   511.008     0.150
    47.072   511.570     0.150
    47.959   519.086     0.150
    48.062   517.484     0.150
    48.115   519.062     0.150
    48.922   525.430     0.150
    49.052   526.188     0.150
    49.092   526.898     0.150
    49.217   527.633     0.150
    49.351   528.867     0.150
    49.715   531.852     0.150
    50.127   534.930     0.150
    50.388   537.172     0.150
    50.657   539.719     0.150
    50.742   539.758     0.150
    50.772   540.203     0.150
    50.894   540.992     0.150
    51.006   541.227     0.150
    51.280   543.867     0.150
    51.322   543.898     0.150
    51.462   543.656     0.150
    51.414   544.656     0.150
    51.443   545.102     0.150
    51.500   543.945     0.150
    51.719   545.672     0.150
    51.837   547.695     0.150
    52.021   549.891     0.150
    52.204   551.375     0.150
    52.382   551.812     0.150
    52.578   553.188     0.150
    52.863   555.516     0.150
    52.863   556.164     0.150
    52.978   556.031     0.150
    53.195   558.758     0.150
    53.495   560.547     0.150
    53.542   561.078     0.150
    53.616   560.180     0.150
    53.634   560.750     0.150
    53.697   560.352     0.150
    54.034   563.156     0.150
    54.109   563.523     0.150
    54.179   563.898     0.150
    54.256   564.508     0.150
    54.450   565.938     0.150
    54.476   566.258     0.150
    54.513   566.797     0.150
    54.560   566.555     0.150
    54.630   566.758     0.150
    54.771   568.273     0.150
    54.787   568.203     0.150
    54.929   569.812     0.150
    54.979   569.992     0.150
    55.030   570.047     0.150
    55.095   571.320     0.150
    55.139   571.805     0.150
    55.300   573.039     0.150
    55.303   572.516     0.150
    55.333   572.102     0.150
    55.350   573.172     0.150
    55.398   573.273     0.150
    55.531   574.320     0.150
    55.637   575.234     0.150
    55.678   575.023     0.150
    55.737   576.008     0.150
    55.776   575.703     0.150
    55.782   576.461     0.150
    55.845   576.578     0.150
    55.876   576.844     0.150
    55.942   577.672     0.150
    55.945   577.922     0.150
    55.982   577.477     0.150
    55.986   578.000     0.150
    56.092   579.273     0.150
    56.176   578.852     0.150
    56.241   580.562     0.150
    56.237   578.961     0.150
    56.296   579.375     0.150
    56.323   580.055     0.150
    56.359   580.812     0.150
    56.402   580.648     0.150
    56.442   581.344     0.150
    56.462   581.648     0.150
    56.472   580.484     0.150
    56.639   582.172     0.150
    56.658   582.102     0.150
    56.773   582.992     0.150
    56.789   583.078     0.150
    56.793   583.094     0.150
    56.851   583.883     0.150
    56.953   584.453     0.150
    57.091   584.805     0.150
    57.071   584.797     0.150
    57.078   585.242     0.150
    57.088   585.008     0.150
    57.156   585.859     0.150
    57.217   585.359     0.150
    57.217    10.945     0.150
    57.217   585.898     0.150
    57.267   596.539     0.150
    57.267   586.492     0.150
    57.287   585.938     0.150
    57.287   586.984     0.150
    57.329   587.188     0.150
    57.376   586.875     0.150
    57.386   587.328     0.150
    57.466   587.578     0.150
    57.515   588.070     0.150
    57.588   588.859     0.150
    57.650   588.781     0.150
    57.658   599.586     0.150
    57.658   589.961     0.150
    57.676   588.539     0.150
    57.834   590.375     0.150
    57.847   590.594     0.150
    57.962   601.398     0.150
    57.962   591.664     0.150
    58.086   592.461     0.150
    58.108   592.375     0.150
    58.124   592.859     0.150
    58.137   592.578     0.150
    58.156   592.867     0.150
    58.192   592.766     0.150
    58.204   603.086     0.150
    58.204   593.039     0.150
    58.220   593.281     0.150
    58.285   593.969     0.150
    58.343   594.188     0.150
    58.358   594.812     0.150
    58.385   594.086     0.150
    58.481   594.586     0.150
    58.541   595.297     0.150
    58.548   595.188     0.150
    58.648   596.047     0.150
    58.725   596.914     0.150
    58.735   596.898     0.150
    58.774   596.273     0.150
    58.779   596.891     0.150
    58.801   597.000     0.150
    58.848   597.094     0.150
    58.858   597.320     0.150
    59.014   598.094     0.150
    59.141   598.602     0.150
    59.148   599.203     0.150
    59.243   599.906     0.150
    59.295   599.734     0.150
    59.314   599.578     0.150
    59.334   600.172     0.150
    59.383   600.719     0.150
    59.406   601.391     0.150
    59.421   601.391     0.150
    59.462   601.539     0.150
    59.632   602.586     0.150
    59.632     8.664     0.150
    59.632    12.430     0.150
    59.553   602.523     0.150
    59.634   601.789     0.150
    59.642   602.492     0.150
    59.657   601.867     0.150
    59.687   601.055     0.150
    59.701   601.977     0.150
    59.731   613.453     0.150
    59.731   602.281     0.150
    59.736   602.375     0.150
    59.864   603.305     0.150
    59.941   604.641     0.150
    59.954   604.883     0.150
    59.954   604.305     0.150
    59.981   604.195     0.150
    59.989   605.359     0.150
    60.020   604.539     0.150
    60.102   605.953     0.150
    60.211   606.219     0.150
    60.270   607.070     0.150
    60.291   607.414     0.150
    60.347   607.867     0.150
    60.365   607.742     0.150
    60.515   609.727     0.150
    60.445   607.289     0.150
    60.519   608.766     0.150
    60.539   609.133     0.150
    60.541   608.109     0.150
    60.559   609.164     0.150
    60.625   609.453     0.150
    60.630   609.555     0.150
    60.732   610.430     0.150
    60.797   610.656     0.150
    60.806   610.883     0.150
    60.834   611.484     0.150
    60.843   611.703     0.150
    61.003   613.055     0.150
    61.095   612.930     0.150
    61.167   612.828     0.150
    61.163   613.625     0.150
    61.239   614.516     0.150
    61.249   613.898     0.150
    61.384   615.367     0.150
    61.384   615.828     0.150
    61.489   615.969     0.150
    61.546   615.695     0.150
    61.584   616.188     0.150
    61.658   616.484     0.150
    61.757   615.680     0.150
    61.904   617.984     0.150
    62.109   619.586     0.150
    62.150   618.984     0.150
    62.181   619.234     0.150
    62.189   620.016     0.150
    62.315   621.469     0.150
    62.233   620.516     0.150
    62.250   620.867     0.150
    62.252   620.500     0.150
    62.291   620.906     0.150
    62.291   620.625     0.150
    62.334   620.805     0.150
    62.346   621.516     0.150
    62.357   621.758     0.150
    62.423   621.219     0.150
    62.573   622.773     0.150
    62.759   624.422     0.150
    62.779   624.664     0.150
    62.981   625.016     0.150
    63.110   626.062     0.150
    63.139   626.930     0.150
    63.332   628.305     0.150
    63.416   628.312     0.150
    63.436   629.312     0.150
    63.716   630.102     0.150
    63.732   630.156     0.150
    63.764   630.008     0.150
    63.974   631.758     0.150
    64.086   632.195     0.150
    64.407   634.477     0.150
    64.421   634.445     0.150
    64.478   635.875     0.150
    64.546   635.641     0.150
    64.615   635.961     0.150
    64.712   637.078     0.150
    64.876   637.930     0.150
    65.032   638.531     0.150
    65.329   640.969     0.150
    65.414   640.727     0.150
    65.698   641.703     0.150
    66.957   650.117     0.150
    67.294   652.508     0.150
    67.294     8.898     0.150
    67.294    13.211     0.150
    83.832   748.750     0.150
    85.679   756.984     0.150
    85.759   757.125     0.150
   109.868  1142.398     0.150
   112.767  1162.953     0.150
   115.974  1121.492     0.150
   122.733  1135.188     0.150
   128.106  1144.773     0.150
   128.647  1146.734     0.150
   129.338  1148.148     0.150
   132.019  1152.586     0.150
   140.289  1168.562     0.150
     0.047     6.582     0.150
     0.047    10.711     0.150
     0.268     8.191     0.150
     0.268    13.723     0.150
     0.617    12.633     0.150
     0.617    21.352     0.150
     0.560    11.891     0.150
     0.560    20.352     0.150
     0.734    14.391     0.150
     0.734    24.844     0.150
     0.865    16.613     0.150
     0.865    28.434     0.150
     1.017    19.113     0.150
     1.017    32.641     0.150
     1.177    21.531     0.150
     1.177    36.801     0.150
     1.300    23.113     0.150
     1.300    41.043     0.150
     1.338    23.723     0.150
     1.338    41.500     0.150
     1.371    24.230     0.150
     1.371    42.293     0.150
     1.630    26.934     0.150
     1.630    50.883     0.150
     1.583    28.023     0.150
     1.583    47.910     0.150
     1.703    28.832     0.150
     1.703    52.684     0.150
     1.840    30.980     0.150
     1.840    54.012     0.150
     1.887    31.023     0.150
     1.887    55.891     0.150
     1.891    32.953     0.150
     1.891    56.383     0.150
     1.950    32.332     0.150
     1.950    58.352     0.150
     2.054    34.062     0.150
     2.235    36.441     0.150
     2.235    68.820     0.150
     2.228    38.730     0.150
     2.228    69.941     0.150
     2.309    67.781     0.150
     2.593    41.082     0.150
     2.593    80.273     0.150
     2.650    41.934     0.150
     2.650    80.203     0.150
     2.701    42.391     0.150
     2.701    82.410     0.150
     2.820    45.070     0.150
     2.820    85.160     0.150
     2.973    50.410     0.150
     3.283    56.102     0.150
     3.283   103.262     0.150
     3.698    64.473     0.150
     3.698   117.031     0.150
     4.357    67.344     0.150
     4.357   112.773     0.150
     4.429    68.250     0.150
     4.429   124.941     0.150
     4.435    69.203     0.150
     4.443    69.434     0.150
     4.481    70.242     0.150
     4.481   126.730     0.150
     4.589    67.840     0.150
     4.525    68.422     0.150
    26.822   339.297     0.150
    26.974   340.453     0.150
    46.578   504.371     0.150
     0.220     8.027     0.150
     0.220    13.609     0.150
     0.479    17.770     0.150
     0.606    12.379     0.150
     0.606    21.117     0.150
     0.765    14.438     0.150
     0.765    24.578     0.150
     0.828    15.699     0.150
     0.828    27.520     0.150
     0.969    17.590     0.150
     1.013    18.168     0.150
     1.013    32.879     0.150
     1.141    20.160     0.150
     1.141    34.648     0.150
     1.196    20.438     0.150
     1.243    22.258     0.150
     1.243    38.188     0.150
     1.291    22.770     0.150
     1.291    39.078     0.150
     1.417    24.848     0.150
     1.417    42.609     0.150
     1.468    24.898     0.150
     1.468    43.520     0.150
     1.523    26.020     0.150
     1.842    31.160     0.150
     1.920    32.500     0.150
     1.920    55.957     0.150
     2.026    33.180     0.150
     2.026    56.207     0.150
     2.157    36.160     0.150
     2.157    64.738     0.150
     2.168    63.047     0.150
     2.199    36.109     0.150
     2.199    64.668     0.150
     2.240    66.570     0.150
     2.196    37.098     0.150
     2.196    61.098     0.150
     3.029    78.180     0.150
     3.213    48.160     0.150
     3.213    85.957     0.150
     3.174    48.938     0.150
     3.174    85.688     0.150
     3.352    55.188     0.150
     3.419    92.648     0.150
     3.720   100.898     0.150
     3.964    59.527     0.150
     4.049   105.598     0.150
     4.337    62.520     0.150
     4.337   112.449     0.150
     5.706   143.777     0.150
     6.634   100.117     0.150
     0.150     8.539     0.150
     0.394    10.891     0.150
     0.394    18.383     0.150
     0.754    14.852     0.150
     0.640    13.812     0.150
     0.640    23.133     0.150
     0.788    15.562     0.150
     0.788    26.719     0.150
     0.935    17.930     0.150
     0.935    30.711     0.150
     1.071    19.938     0.150
     1.071    33.242     0.150
     1.071    33.000     0.150
     1.182    21.500     0.150
     1.182    36.859     0.150
     1.223    22.031     0.150
     1.223    35.883     0.150
     1.311    23.070     0.150
     1.311    39.773     0.150
     1.590    27.414     0.150
     1.590    47.031     0.150
     1.616    27.320     0.150
     1.616    47.844     0.150
     1.621    26.969     0.150
     1.621    49.250     0.150
     1.763    28.914     0.150
     1.763    50.453     0.150
     1.783    29.398     0.150
     1.783    52.312     0.150
     1.763    29.922     0.150
     1.763    50.664     0.150
     1.845    31.023     0.150
     1.845    54.422     0.150
     1.825    30.469     0.150
     1.825    52.008     0.150
     2.043    58.938     0.150
     2.077    33.953     0.150
     2.077    59.414     0.150
     1.999    33.461     0.150
     1.999    56.578     0.150
     2.101    33.867     0.150
     2.101    60.594     0.150
     2.107    62.258     0.150
     2.108    33.789     0.150
     2.108    62.258     0.150
     2.107    34.258     0.150
     2.107    60.312     0.150
     2.126    34.531     0.150
     2.126    60.547     0.150
     2.123    33.359     0.150
     2.123    61.453     0.150
     2.189    35.641     0.150
     2.189    64.352     0.150
     2.189    35.617     0.150
     2.189    34.914     0.150
     2.189    61.617     0.150
     2.204    36.031     0.150
     2.204    63.117     0.150
     2.214    36.508     0.150
     2.214    64.094     0.150
     2.216    35.711     0.150
     2.216    62.164     0.150
     2.235    35.961     0.150
     2.235    63.844     0.150
     2.258    65.852     0.150
     2.261    36.461     0.150
     2.261    64.328     0.150
     2.287    64.211     0.150
     2.316    34.797     0.150
     2.316    64.000     0.150
     2.339    36.180     0.150
     2.339    63.570     0.150
     2.348    37.148     0.150
     2.348    66.000     0.150
     2.250    38.539     0.150
     2.250    67.609     0.150
     2.477    39.242     0.150
     2.477    68.547     0.150
     2.597    40.570     0.150
     2.597    74.102     0.150
     2.707    41.750     0.150
     2.707    78.508     0.150
     2.752    74.078     0.150
     2.752    74.078     0.150
     2.809    83.641     0.150
     2.809    46.281     0.150
     2.761    40.023     0.150
     2.761    71.672     0.150
     2.781    72.961     0.150
     2.927    43.961     0.150
     2.927    80.023     0.150
     2.912    46.672     0.150
     2.912    45.438     0.150
     2.912    78.469     0.150
     3.047    46.383     0.150
     3.047    86.891     0.150
     3.164    47.969     0.150
     3.164    85.188     0.150
     3.163    47.969     0.150
     3.163    85.188     0.150
     3.242    49.844     0.150
     3.242    89.000     0.150
     3.449    51.719     0.150
     3.606    55.203     0.150
     3.675    54.641     0.150
     3.675    97.188     0.150
     3.636    56.812     0.150
     3.636    93.070     0.150
     3.731    55.578     0.150
     3.731    99.281     0.150
     3.955    57.188     0.150
     3.955   108.938     0.150
     4.443    69.484     0.150
     4.365    65.789     0.150
     4.365   115.148     0.150
     4.488    64.664     0.150
     4.488   115.414     0.150
     4.427    68.492     0.150
     4.427   115.711     0.150
     4.435   117.203     0.150
     4.443    68.070     0.150
     4.443   117.641     0.150
     4.460    69.148     0.150
     4.460   118.852     0.150
     4.480    68.000     0.150
     4.480   117.859     0.150
     4.519   118.984     0.150
     4.519   138.812     0.150
     4.519   114.578     0.150
     4.491   119.867     0.150
     4.543    67.570     0.150
     4.543   116.508     0.150
     4.602    68.797     0.150
     4.602   121.188     0.150
     4.706   128.070     0.150
     5.223    77.141     0.150
     5.223   132.703     0.150
     5.299    76.922     0.150
     5.299   134.961     0.150
     5.443    80.992     0.150
     5.443   144.047     0.150
     5.657    82.133     0.150
     5.657   146.914     0.150
     5.884    84.328     0.150
     5.909    88.320     0.150
     6.041    88.219     0.150
     6.041   158.680     0.150
     6.228    91.133     0.150
     6.228    93.117     0.150
     6.303    92.812     0.150
     6.303   158.680     0.150
     6.623   170.969     0.150
     7.214   108.000     0.150
     7.214   182.211     0.150
     7.375   107.930     0.150
     7.375   185.172     0.150
     7.406   108.500     0.150
     7.406   188.570     0.150
     7.410   191.484     0.150
     7.498   108.578     0.150
     7.693   113.539     0.150
     8.210   208.547     0.150
     8.425   125.953     0.150
     9.512   135.453     0.150
    11.106   157.289     0.150
    11.162   157.008     0.150
    11.162   157.734     0.150
    11.162   276.312     0.150
    11.222   159.539     0.150
    11.564   167.281     0.150
    12.234   173.148     0.150
    12.669   178.648     0.150
    12.669   180.664     0.150
    12.669   399.477     0.150
    12.670   179.414     0.150
    13.253   185.000     0.150
    13.253   186.219     0.150
    13.763   194.078     0