#!/bin/bash
gmt begin acapulco7.51_ot_mislocation pdf,ps
proj=-JX12/10c
reg=-R-4/7/0/18
gmt histogram $proj $reg -W0.5 -F -Gcyan -L1p -Z0 -Bxa1+l'Time (s)' -Bya10f5+l'Counts' -BWeSn+t'Origin Time Mislocation acapulco7.51' << EOF
     3.082
     2.837
     0.365
     1.973
     2.467
     3.477
     1.254
     2.086
     1.688
     2.242
     0.930
     1.109
     1.358
     2.840
     2.066
     0.367
     2.160
     1.102
     2.707
     1.258
     1.469
     1.645
     2.195
     1.531
     1.887
     1.977
     0.652
     0.281
     2.422
     2.570
     2.227
     1.307
     2.137
     2.193
     1.719
     0.992
     1.137
     2.898
     0.492
     2.242
     2.516
     3.072
     1.180
     0.289
     3.051
    -1.945
     2.598
     2.234
     0.055
    -0.678
     1.860
     1.742
     3.246
     0.863
     2.842
     2.336
     0.273
     2.539
     1.658
    -0.979
     0.981
     1.125
     1.384
     2.605
     1.180
     1.688
     1.062
     2.680
     0.035
     0.406
     2.434
    -0.570
     0.207
     1.340
    -0.586
     0.547
     2.305
     0.637
     1.071
     2.830
     2.430
     4.285
     2.332
     2.207
     3.176
     5.570
     0.250
     5.715
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
     1.730    15.945 Median =   1.7 s
EOF
# Median OT mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
  1.7  0.
  1.7  15.6
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
    -3.800    17.055 Author: all (  88 samples)
EOF
gmt end
