#!/bin/bash
gmt begin acapulco7.51_epicenter_mislocation pdf,ps
proj=-JX12
reg=-R-32/32/-32/32
gmt basemap $proj $reg -Bxa25f5+l'km' -Bya25f5+l'km' -BWeSn+t'Epicentral Mislocation acapulco7.51'

# Circle with radius of median vector length
gmt plot $proj $reg -SE -Wthick,red << EOF
     0.000     0.000     0.000     9.266     9.266
EOF

# Mislocation vectors, with event numbers for the longer ones
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    11.657     4.243
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    11.657     4.243 1
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.602     6.881
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.158     0.180
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.221     2.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.846    -0.748
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.658    15.775
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     1.658    15.775 6
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.604    -0.392
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.164     4.688
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.808    -1.129
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.862    20.366
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.862    20.366 10
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.085    -2.427
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.967     3.350
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.690     7.888
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.481    -7.136
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.219     4.182
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.639     8.369
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     4.639     8.369 16
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    10.658    14.143
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    10.658    14.143 17
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.079    -7.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    15.982    11.612
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    15.982    11.612 19
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.047     0.704
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.639    -2.386
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.227    -0.399
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.017    -3.356
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.146     5.715
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.146     5.715 24
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.137     5.848
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.927    -0.410
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     6.552     7.027
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     6.552     7.027 27
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.579    -6.719
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.107    14.619
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     3.107    14.619 29
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.623    -3.886
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.456     0.486
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.341     7.872
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.165    -2.770
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.383    -4.822
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.151     3.766
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.247    -3.692
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.967    -3.100
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.079     7.680
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     5.365    11.506
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     5.365    11.506 39
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.829    -0.739
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.848     0.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.412     1.412
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.332    -1.137
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.687    -5.901
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.731     0.155
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -4.685   -10.048
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -4.685   -10.048 46
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.810    -7.166
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.512    -4.168
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.269     2.491
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.085     2.159
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     8.175    -3.470
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.402     7.662
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.770     6.173
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -3.978    -5.681
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.084     2.397
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.758    -3.899
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.543    -3.140
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.127     0.260
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     4.410     4.729
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.706    -1.839
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.209    -3.954
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.279    -3.990
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.230     2.047
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.846    -0.592
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.097    -0.615
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.127     1.915
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     3.346     2.431
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     1.184     4.420
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.266    -0.538
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.168    11.112
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    -1.168    11.112 70
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.090    -1.714
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     9.378     1.993
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     9.378     1.993 72
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.417    -2.365
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.737     3.909
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.910    -1.818
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.554    -0.081
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -5.422    -7.195
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.590     8.442
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.250     0.731
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -2.536    -5.200
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -1.182    -6.079
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     2.733    10.963
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
     2.733    10.963 82
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.981    -2.694
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    -0.853    -4.015
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
     0.000    -1.665
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    19.117    24.469
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    19.117    24.469 86
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.154    15.599
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.154    15.599 87
EOF
gmt plot $proj $reg -Wthin,black << EOF
     0.000     0.000
    16.947    18.173
EOF
gmt text $proj $reg -F+f8p+jCM << EOF
    16.947    18.173 88
EOF
gmt plot $proj $reg -SE -Gred << EOF
     1.522     1.846     0.000     2.000     2.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -30.000    30.000 Author: all (  88 samples)
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -30.000   -30.000 Average =   2.4 km at  39.5 deg; median =    4.6 km
EOF
gmt end
