#!/bin/bash
gmt begin acapulco7.51_depth_mislocation pdf,ps
proj=-JX12/10c
reg=-R-37/25/0/10
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depth Mislocation acapulco7.51' << EOF
     2.800
    -3.300
   -14.500
    -6.100
     0.300
     2.400
    -7.400
    -4.200
    -8.100
    -6.600
    -8.500
   -13.600
    -7.400
    -3.000
    -6.100
   -16.200
    -6.800
   -12.300
    -0.400
    -8.500
    -9.000
    -7.200
    -1.100
   -16.400
    -7.700
    -1.000
   -26.100
   -10.200
    -6.000
    -2.000
     0.300
    -5.500
     0.900
     1.100
    -6.900
   -11.800
    -6.200
    -9.200
   -28.200
     0.200
    -5.600
   -25.100
    -9.500
   -11.300
    -9.200
   -26.300
    -1.500
    -0.100
   -15.900
   -23.100
    -8.400
    -1.500
    -9.400
    -9.700
   -15.600
    -0.700
   -16.100
    -6.400
   -10.300
   -22.300
   -10.300
    -4.300
    -8.000
    -3.100
   -12.200
    -3.700
   -10.700
   -32.100
   -27.600
   -22.100
    -4.500
   -18.300
   -11.300
    -4.000
   -16.200
    -9.300
     0.600
   -10.500
   -11.000
    -6.300
    -0.900
    10.000
    -0.200
     0.100
    -8.800
    10.700
   -23.000
    20.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBC << EOF
    -7.550     8.525 Median =  -7.6 km
EOF
# Median depth mislocation
gmt plot $proj $reg -Wthick,black,- << EOF
 -7.6  0.
 -7.6   8.4
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
   -36.000     9.475 Author: all (  88 samples)
EOF
gmt end
