#!/bin/bash
gmt begin acapulco7.51_depth_histogram pdf,ps
proj=-JX12/10
reg=-R0/63/0/10
gmt histogram $proj $reg -W1 -F -Gcyan -L1p -Z0 -Bxa25f5+l'Depth (km)' -Bya10f1+lCounts -BWeSn+t'Focal Depths acapulco7.51' << EOF
    23.000
    17.000
    45.000
    39.000
    42.000
    25.000
    34.000
    37.000
    46.000
    26.000
    40.000
    37.000
    18.000
    23.000
    25.000
    30.000
    26.000
    48.000
    25.000
    41.000
    43.000
    52.000
    48.000
    47.000
    28.000
    45.000
    56.000
    25.000
    16.000
    39.000
    48.000
    22.000
    38.000
    48.000
    27.000
    40.000
    39.000
    41.000
    56.000
    42.000
    51.000
    37.000
    42.000
    24.000
    40.000
    32.000
    33.000
    43.000
    28.000
    28.000
    49.000
    21.000
    43.000
    30.000
    44.000
    46.000
    46.000
    58.000
    29.000
    32.000
    34.000
    33.000
    13.000
    42.000
    47.000
    30.000
    33.000
    44.000
    52.000
    54.000
    41.000
    33.000
    47.000
    35.000
    32.000
    26.000
    39.000
    14.000
    46.000
    37.000
    40.000
     5.000
    50.000
    42.000
    39.000
    24.000
    33.000
    15.000
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000     9.400 Median of constrained depths =  38.5
EOF
gmt text $proj $reg -F+f10p,Helvetica,black+a0.+jBL << EOF
     1.000     8.800 Spread of constrained depths =  10.7
EOF
gmt end
